﻿USE sofia;
DROP TABLE IF EXISTS sofia.tzoNT_vpl;
CREATE TABLE tzoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tzoNT_vpl WRITE;
INSERT INTO tzoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ja' sunal ti antiguo statamoltac ti Jesucristoe. Ti Jesucristoe ja' statamol ti Davide. Ti Davide ja' statamol ti Abrahame. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ti Isaaque ja' stot ti Abrahame. Ti Jacobe ja' stot ti Isaaque. Ti Judae ja' stot ti Jacobe. Oy ep yermanotac ti Judae. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ti Fares xchi'uc ti Zarae ja' stot ti Judae. Ja' sme' ti Tamare. Ti Esrome ja' stot ti Farese. Ti Arame ja' stot ti Esrome. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ti Aminadabe ja' stot ti Arame. Ti Naasone ja' stot ti Aminadabe. Ti Salmone ja' stot ti Naasone. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ti Booze ja' stot ti Salmone. Ja' sme' ti Rahabe. Ti Obede ja' stot ti Booze. Ja' sme' ti Rute. Ti Isaíe ja' stot ti Obede. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ti Davide, ja' ti totil ajvalile, ja' stot ti Isaíe. Ti Salomone ja' stot ti Davide, ja' ti totil ajvalile. Ja' sme' ti yajnil ti Uríase. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ti Roboame ja' stot ti Salomone. Ti Abíase ja' stot ti Roboame. Ti Asae ja' stot ti Abíase. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ti Josafate ja' stot ti Asae. Ti Jorame ja' stot ti Josafate. Ti Uzíase ja' stot ti Jorame. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ti Jotame ja' stot ti Uzíase. Ti Acaze ja' stot ti Jotame. Ti Ezequíase ja' stot ti Acaze. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ti Manasese ja' stot ti Ezequíase. Ti Amone ja' stot ti Manasese. Ti Josíase ja' stot ti Amone. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ti Jeconíase ja' stot ti Josíase. Oy yermanotac uc ti Jeconíase. Ja' ic'bil ibatic ti Babilonia. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Patil i'an snich'on ti Jeconíase. Salatiel sbi ti snich'one. Ti Zorobabele ja' stot ti Salatiele. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ti Abiude ja' stot ti Zorobabele. Ti Eliaquime ja' stot ti Abiude. Ti Azore ja' stot ti Eliaquime. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ti Sadoque ja' stot ti Azore. Ti Aquime ja' stot ti Sadoque. Ti Eliude ja' stot ti Aquime. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ti Eleazare ja' stot ti Eliude. Ti Matane ja' stot ti Eleazare. Ti Jacobe ja' stot ti Matane. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ti Josee ja' stot ti Jacobe. Laj yic' yajnil ti Josee. María sbi ti yajnile. I'an yol ti Maríae. Jesús sbi ti yole, ja' ti Cristo x'utate. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Lajchavo' i'ech' ox ti balumil ti totiletique ja' ti yelnich'nabtac ti Abrahame c'alal ihul ti Davide. Ja' chanlajunvo' xchi'uc ti Abrahame xchi'uc ti Davide. C'alal ic'bil ibatic ti Babilonia, chanlajunvo' i'ech' ox ti balumil ti totiletique ja' ti yelnich'nabtac ti Davide. C'alal i'an ti Cristoe, ja' its'aqui yan chanlajunvo' ti totiletique xchi'uc ti Cristoe. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Hech i'an ti Jesucristoe. María sbi ti sme' ti Jesuse. Jac'bil xa ti Maríae yu'un ti Josee. Mu to yic'ojuc sbaic. Slicoj xa yol ti Maríae ti sventa ti Ch'ul Espíritue. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Lec yo'nton ti Josee. Hech yu'un mu sc'an ti ac'o ac'batuc castigo ti Maríae. Ja' no'ox tsp'ejan ti hun stuc ti Josee c'usi sventail ti tscomese. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","C'alal hech snopoj ti yo'nton ti Josee, ivachaj. Ti svaich laj sq'uel xch'ul abat ti Cajvaltic Diose. Hech i'albat yu'un ti ch'ul abate: ―José, yelnich'onot David, mu xaxi'. Ic'o ti Maríae. Mu snich'onuc vinic ti slicoje. Ja' slicoj yol yu'un ti Ch'ul Espíritue. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Querem chac'. Jesús chavac'be sbi yu'un ti sventa ti Jesuse chcol yu'un smulic scotol ti much'utic t'ujbilic yu'un ti Diose ―xchi ti xch'ul abat ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Scotol hech ic'ot ti pasel yu'un chc'ot sc'op ti Cajvaltic Diose. Ti Diose laj xch'amumbe ye ti yaj'alc'op ti vo'one, hech laj yal: ");
INSERT INTO tzoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ch-alaj jun soltera tseb. Querem chac'. Ch-ac'bat sbi Emanuel, xchi. Ja' Dios jchi'uctic, xchi sjam sbi ti bats'ic'op. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","C'alal icux yo'nton ti vayel ti Josee, lic spas hech chaj c'u che'el i'albat yu'un ti xch'ul abat ti Cajvaltic Diose. Laj yic' ti Maríae. ");
INSERT INTO tzoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Muc xchi'in sbaic ja'to c'alal i'an ti sba yol ti Maríae. Querem laj yac'. Ti Josee, Jesús laj yac'be sbi ti olole. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","C'alal i'an ti Jesuse te ti jteclum Belén te ti estado Judea, ja' ochem ti ajvalil jun vinic, Herodes sbi. Ti yan c'ac'al ic'otic ti jteclum Jerusalén p'ijil viniquetic liquemic tal ti sloq'ueb c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Hech c'ot sjaq'uic: ―¿Bu oy ti ajvalil avu'unic ti anem xae, ho'oxuc ti judiooxuque? Ti jna'tutic ti i'an xae yu'un laj quilbetutic ti sc'anale ti bu nacaluntutique te ti sloq'ueb c'ac'al. Hech yu'un tal jquejan jbatutic ti stojol ―xchiic ti p'ijil viniquetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","C'alal laj ya'yic ti ajvalile, ja' ti Herodese, xchi'uc scotol ti jchi'iltique ti te nacajtic ti Jerusalene, toj xi'el ic'otic. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ti Herodese laj yic' tal scotol ti totil paleetic cu'untique xchi'uc ti much'utic chixchanubtasucutic ti smantal ti Diose ti scuyoj sbaique, ja' ti jchi'iltique ti co'ol judioucutic xchi'uque. Laj sjac'beic bu jteclumal sc'opilal ch-an ti Cristoe. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hech itac'avic: ―Ch-an ti Belén li' ti estado Judea. Yu'un hech ts'ibabil yu'un ti j'alc'op yu'un ti Diose ti vo'one: ");
INSERT INTO tzoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Manchuc mi biq'uit no'ox jteclum ti Belene te ti estado Judea, ja' pasbil ti muc' ti much'utic te nacajtique yu'un te chloc' tal jun ajvalil, ja' ti chaspasoxuc ti mantal, ho'oxuc ti yelnich'onoxuc ti Israele. Ho'oxuc t'ujbiloxuc cu'un, xchi ti Diose, xchi ti j'alc'ope ―xchiic ti much'utic chixchanubtasucutic ti smantal ti Diose ti scuyoj sbaique. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ti Herodese laj smucul'ic' tal ti p'ijil viniquetique. Lec laj sjac'be c'usi ora laj yilic ti c'anale. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Laj stac batel ti Belén. Hech laj yalbe batel: ―Batanic ti Belén. Ba sa'ic ti olole. C'alal mi laj ataique, xtal avalbun yu'un chba jquejan jba ti stojol uc ―xchi ti Herodese. Ti hech laj yale, yac'o yal. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ti p'ijil viniquetique c'alal laj ya'ibeic sc'op ti Herodese, hech ibatic. Te oy to ti c'anale ti laj yilic te ti sloq'ueb c'ac'ale ibaej batel yu'unic yan vuelta. C'alal laj yilic yan vuelta ti c'anale, hech nichim no'ox yo'ntonic ti p'ijil viniquetique. Laj sts'acliic batel. Ti c'anale te cajal ic'ot ti na ti yo' bu oy ti olole. Te icom. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Hech i'ochic ti yut na ti p'ijil viniquetique. Te laj staic ti olole xchi'uc ti sme'e, ja' ti Maríae. Laj squejan sbaic ti stojol ti olole. Laj sloq'uesbeic smoton. Laj yac'beic c'anal taq'uin xchi'uc pom xchi'uc mirra perfume. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yu'un mu laj sna'ic mi chlo'laat yu'un ti Herodese, hech yu'un hech i'albatic ti svaichic yu'un ti Diose: ―Mu me xasutic xa batel yo' bu ti Herodese ―x'utatic. Hech yu'un c'alal isutic batel ti slumal, yan be laj stamic batel. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","C'alal batem xa ti p'ijil viniquetique, ivachaj ti Josee. Ivinaj ti svaich xch'ul abat ti Cajvaltic Diose. Hech i'albat: ―Lican, ic'o batel ti olole xchi'uc ti sme'e. Batanic ti anil ti slumal Egipto. Teanic te ti Egipto. Ja'to mi chacalbote, ja'to chasutic talel. Yu'un tsa' ti olole ti Herodese yu'un tsc'an tsmil ―xchi ti xch'ul abat ti Cajvaltic Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hech icux yo'nton ti vayel ti Josee. Ti ora ti ac'ubal laj yic' batel ti olole xchi'uc ti sme'e. Ibatic ti Egipto. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Te ihalejic ja'to icham ti Herodese. Hech ic'ot ti pasel yu'un tsts'aqui ti c'usi laj yal ti j'alc'op yu'un ti Cajvaltic Diose ti vo'one: “Ti slumal Egipto chquic' loq'uel ti Jnich'one”, xchi ti Diose, xchi ti j'alc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","C'alal laj sna' ti Herodese ti ilabanat yu'un ti p'ijil viniquetique, xtec'tun no'ox i'ilin. Laj spas mantal yu'un ac'o smilic scotol biq'uit queremotic te ti Belén xchi'uc ti sjoylejal Belén. Tsmil ti much'u mu to bu tsts'aqui oxib habil yu'un sna' ti Herodese ti c'usi ora laj yil ti c'anale ti p'ijil viniquetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Hech ic'ot sc'op ti Jeremíase, ja' ti j'alc'op yu'un ti Diose ti vo'one. Hech laj yal: ");
INSERT INTO tzoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","C'alal ti jteclum Ramá tsots chlic oc'uc ti antsetique, ja' ti achi'iltaque. Ep chich'ic mul, choc'taic ti yolique. Mu xmuc'ub yo'ntonic yu'un ti imilbat xa ti yolique, xchi ti Diose, xchi ti Jeremíase. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","C'alal icham xa ti Herodese, ivachaj ti Josee te ti Egipto. Ti svaich ic'oponat yu'un xch'ul abat ti Cajvaltic Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Hech i'albat: ―Batan, ic'o batel ti olole xchi'uc ti sme'e. Sutanic batel ti alumal ti yo' bu nacajtic ti achi'iltaque, ho'oxuc ti yelnich'onoxuc ti Israele. Icham xa ti much'u tsc'an tsmil ti olole ―xchi ti xch'ul abat ti Cajvaltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hech laj xch'un ti Josee. Laj yic' sutel ti quereme xchi'uc ti sme'e. Ic'otic ti slumal. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Te ti estado Judea ochem xa ti ajvalil ti snich'on ti Herodese. Arquelao sbi ti snich'one. C'alal laj ya'i ti Josee, ixi'. Hech muc sc'an ch-och ti Judea ti Josee. Hech yu'un i'albat yu'un ti Diose ti svaich ti ac'o ba nacluc ti estado Galilea. ");
INSERT INTO tzoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Te c'ot nacluc ti jteclum, Nazaret sbi. Hech its'aqui ti sc'op ti Diose hech chaj c'u che'el laj yal ti j'alc'opetic yu'un ti Diose ti vo'one: “Ja' liquem tal ti Nazaret, xchiic ti crixchanoetique. Ja' sc'opilal ti Cajvaltique”, xchiic ti j'alc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","C'alal te nacal ti Nazaret ti Jesuse, laj sta yorail lic abtejuc ti Juane, ja' ti much'u laj yac' ich'ho'e. Lic xchol ti sc'op ti Diose te ti xocol balumil te ti estado Judea. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Hech laj yal ti Juane: ―Suteso me avo'ntonic yu'un amulic, yu'un po'ot xa chtal sventaimbucutic co'ntontic ti Diose ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ti Juane ja' albil sc'opilal yu'un ti Isaíase, ja' ti j'alc'op yu'un ti Diose ti vo'one. Hech laj yal ti Isaíase: Chlic jun jchi'iltic, tsots chc'opoj ti xocol balumil. Hech chal: “Chtal xa ti Cajvaltique, hech yu'un comesic ti c'usi chasbolibtasoxuque”, chlic yut ti xchi'iltaque, xchi ti Isaíase. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ti Juane ja' slapoj sc'u' meltsambil ti stsotsil camello. Ja' xchucoj xch'ut ti xincha. Puru c'ulub laj sve' xchi'uc ajapom. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hech ba ya'ibeic sc'op ti Juane ti jchi'iltique ti te nacajtic ti Jerusalén xchi'uc ti te nacajtic ti scotol yan jteclumetic te ti estado Judea xchi'uc ti te nopol nacajtic ti ti'uc'um Jordán. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jamal c'ot yalic ti stojol ti Juane ti c'usi smulic jujun. Hech yu'un i'ac'batic yich'ic ho' yu'un ti Juane te ti uc'um Jordán. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Laj yil ti Juane ti ep chtal uc ti fariseoetique xchi'uc ti saduceoetique, ja' ti jchi'iltique. (Ti fariseoetique ja' tsots sc'opilal c'otem yu'unic tscuyic ti smantal ti Diose. Ja'uc ti saduceoetique ja' chch'unic ti mu'yuc much'u chcha'cuxie.) Italic yu'un tsc'an chich'ic ho' uc. Hech yu'un hech i'albatic yu'un ti Juane: ―Ti ho'oxuque hech chaj c'u che'el ti orachone mi chtal c'oc' cha'i, chjatav. Hech un ja' no'ox hech ti ho'oxuque, ¿mi yu'un chava'yic ti ta ono'ox xavich'ic vocol yu'un ti Diose yu'un ti natalic ti anil yu'un tal ac'anic ich'ho' ti jtojol ti ho'oxuque? ");
INSERT INTO tzoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ja' tsc'an ti primero chavac' ti q'uelel ti avabtelique mi melel ti sutem xa avo'ntonic yu'un ti amulique. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mu me hechuc chanop ti avo'ntonic: “Ja' jtatamoltic ti Abrahame, hech yu'un chijcolucutic”, mu me xachiic. Melel ti c'usi chacalbee, ti Diose xu' tsc'atajes ti yelnich'on Abraham avi ton li'to. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ti ho'oxuque hech chaj c'u che'el ti te'etique ti mu xac' lec sate, hech yu'un te xa oy eq'uel ti yoc. Ja' chich' ts'etel. Patil chtenat ochel ti c'oc'. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’Ho'oni ja' no'ox cabtel chcac'be yich' ho' ti much'u sutemic xa yo'ntonic yu'un smulic. Ti much'u patil chtale ja' tsots yabtel yich'oj. Ho'oni mu tsotsuc cabtel quich'oj. Ma mi sjitumbeluc yaq'uil sempat, mu'yuc c'usi xu' ti jcolta mi jutuc. Ja' chayac'boxuc avich'ic ti Ch'ul Espíritue xchi'uc c'oc' yu'un hech chloc' scotol ti sbolil avo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jun to stsacoj ti sc'ob ti sjorquetae yu'un chic'a strigo. C'alal chlaj yo'nton laj yic'a strigo, tsmes ti yelae. Tstsob ochel ti sna ti strigoe. Ti spaxaq'uil trigoe chchic' ti c'oc' ti bu mu stac' tup'ele ―xchi ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hech yorail iloc' batel ti estado Galilea ti Jesuse. Ic'ot ti uc'um Jordán yu'un sc'an ti ac'o ac'batuc yich' ho' yu'un ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Vocol chch'un ti Juane. Hech laj yalbe: ―Ho'oti, ho'ot chavac'bun quich' ho' ho'oni. Ho'oti mu yu'unuc natal yu'un chacac'bot avich' ho' ―xchi ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Hech itac'av ti Jesuse: ―Ac'bun quich' ho' yu'un ja' lec ti jpastic scotol ti c'usi tsc'an ti Diose ―xchi ti Jesuse. Hech yu'un laj xch'un ti Juane. Laj yac'be yich' ho' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","C'alal laj yich' ho' ti Jesuse, iloc' ti yut uc'um. Ti ora ijam ti vinajele. Ti Jesuse sq'ueloj iyal tal ti sba ti Espíritu yu'un ti Diose. Jun to culajte x'elan ti c'alal iyal tal ti sbae. Te icom. ");
INSERT INTO tzoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ti Diose ic'opoj te ti vinajel. Hech laj yal: ―Ja' Jnich'on li'to, ja' ti lum c'ux ti co'ntone. Nichim no'ox co'nton yu'un ―xchi xc'opoj te ti vinajel. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Patil i'ic'at batel ti Jesuse yu'un ti Ch'ul Espíritue. I'ic'at batel ti xocol balumil. Te ital ti totil pucuje. Tal spasbe proval yo'nton ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Te ti xocol balumil cha'vinic c'ac'al cha'vinic ac'ubal yipanoj sba ti Jesuse. Muc xve' hech lic vi'najuc. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ti totil pucuje, ja' ti mero jlo'lavaneje, lic sc'opon ti Jesuse. Hech laj yalbe: ―Mi ho'ot snich'onot ti Diose, paso mantal ac'o pasuc ti vaj avi ton li'to, hech chata ave'el ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Hech itac'av ti Jesuse: ―Hech ts'ibabil: “Ma'uc no'ox ti vaj chijcuxi. Ja' chijcuxi ti sventa ti sc'op Dios uque”, ti xchie. Hech ts'ibabil ti sun ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Patil ti totil pucuje laj yic' batel ti Jerusalén ti Jesuse. Te laj yic' batel ti muc'ta templo. Ti totil pucuje c'ot sva'an ti mero jol templo ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Hech laj yalbe: ―Mi ho'ot snich'onot ti Diose, teno aba yalel li'i. Yu'un hech ts'ibabil: Chastacbot talel xch'ul abat yu'un chaxchabiot. Chastsacot ti sc'ob ti xch'ul abate chayic' batel yu'un hech mu xyaj avacan ti ton, xchi ts'ibabil ―x'utat ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Hech itac'av ti Jesuse: ―Mi ti jten jba yalel li'i, ti jpasbe proval yo'nton ti Diose yu'un ti jq'uel mi chiscoltaun. Hech ts'ibabil ti sc'op ti Diose: “Mu me xapasbe proval yo'nton ti Cajvaltic Diose, ja' ti Dios cu'untique”, xchi ts'ibabil ―x'utat ti totil pucuje yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Patil ti totil pucuje laj yic' batel ti jol vits ti Jesuse. Toyol ti vitse. Ti ora i'ac'bat sq'uel ti Jesuse scotol ti ajvaliletique ti li' ti balumile xchi'uc ti sp'ijilique ti c'u che'el tspasic mantale. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ti totil pucuje hech laj yalbe ti Jesuse: ―Mi chaquejan aba ti jtojol, mi chapasun ti muq'ue, ja' avu'un scotol ti avac'oj aba chaq'uel avi li'to ―x'utat ti Jesuse yu'un ti totil pucuje. Yu'un mi chch'un ti Jesuse, jun chc'otic xchi'uc o. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Hech itac'av ti Jesuse: ―Batan, Satanás, mu stac' ti jch'un amantal. Yu'un hech ts'ibabil: “Ja' chapasic ti muc' stuc ti Cajvaltic Diose, ja' ti Dios cu'untique. Ja' chach'umbeic smantal stuc”, ti xchie. Hech ts'ibabil ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","C'alal laj yo'nton ti totil pucuje ti muc xch'un ti Jesuse, hech ibat ti totil pucuje. Ital ch'ul abatetic, tal scoltael ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","C'alal laj ya'i ti Jesuse ti chucul xa ti Juane, isut batel. Te ba sq'uej sba ti estado Galilea. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Laj scomes o ti jteclum Nazaret ti bu ich'ie. Ba nacluc ti jteclum, Capernaum sbi. Ti Capernaume te oy ti ti'nab te ti slum ti jtatamoltique, ja' ti Zabulone xchi'uc ti Neftalime. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hech its'aqui ti c'usi laj yal comel ti Isaíase, ja' ti j'alc'op yu'un ti Diose ti vo'one. Hech laj yal: ");
INSERT INTO tzoNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ti slum ti Zabulone xchi'uc ti slum ti Neftalime te ti bu nopol ti muc'ta nabe te ti jech uc'um Jordán. Ja' ch-ac'bat sbi Galilea yu'un ti yanlum viniquetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Scotol ti much'utic oyic ti vocol te o, ti oyic ti xi'el yu'un mu sna'ic mi chcolic, nichim no'ox yo'ntonic ti patil yu'un te chc'ot ti stojolic ti Jcoltavaneje, xchi ti Diose, xchi ti Isaíase. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ja' hech yorail ti lic xchol ti sc'op ti Diose ti Jesuse. Hech laj yalbe ti jchi'iltique: ―Suteso me avo'ntonic yu'un amulic yu'un ista xa yorail ti chasventaimboxuc avo'ntonic ti Diose ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ti Jesuse ixanav batel ti ti'ti'nab te ti estado Galilea. Te laj yil cha'vo' jchi'iltic. Yermano sbaic. Simón sbi ti june. Ja' chib ti sbie. Ja' Pedro x'utat. Andrés sbi ti yits'ine. Yac'oj sba tstenic ochel slebic ti ho' yu'un tstsaquic choy. Ja' yabtelic o. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ti Jesuse hech laj yalbe: ―La' chi'inun batel. Ti jel avabtelic. Chba asa'bucun tal crixchanoetic ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ti ora laj scomesic ti slebique, laj xchi'inic batel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ixanavic batel. Ti Jesuse laj yil yan cha'vo' jchi'iltic. Yermano sbaic uc ti xcha'va'alique. Ja' xnich'nab ti Zebedeoe. Jacobo sbi ti jun snich'one. Juan sbi ti its'inale. Te tic'ajtic ti barco xchi'uc stot, ja' ti Zebedeoe. Tsmeltsanic slebic. Ti Jesuse laj yic' ti xcha'va'alique. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ti ora laj scomesic ti sbarcoe. Laj scomesic uc ti stote. Laj xchi'inic batel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ti Jesuse ixanav batel ti scotol jteclumetic te ti estado Galilea. Te ichanubtasvan ti temploetic yu'un ti jchi'iltique. Laj xcholbe ya'yic ti lequil ach' c'ope, ja' ti chisventaimbucutic co'ntontic ti Diose. Icol yu'un ti Jesuse scotol ti jchameletique. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ti scotol slumal Siria ipuc sc'opilal ti Jesuse ti icol yu'un scotol ti jchameletique. Hech laj yiq'uic talel ti stojol ti Jesuse scotol ti jchameletic yu'unique. Ep ti tos ti jchameletique ti italique. Ital ti much'u ip c'ux cha'yique xchi'uc ti much'utic ochem pucuj ti yo'ntonique xchi'uc ti much'utic cha'yic tup' iq'ue xchi'uc ti much'utic sicuben yacanic. Icol yu'un scotol ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Laj sts'acliic batel ti Jesuse ep jchi'iltic. Liquemic tal ti estado Galilea xchi'uc ti slumal ti lajuneb jteclumetique xchi'uc ti jteclum Jerusalén xchi'uc ti estado Judea. Laj sts'acliic batel uc ti jchi'iltic ti liquemic tal lum ti jech uc'um Jordán. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","C'alal laj yil ti Jesuse ti ep stsoboj sbaic ti jchi'iltique, imu batel ti vits jutuc. Te c'ot nacluc. Inopejic batel ti stojol ti Jesuse ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Te ichanubtasvan ti vits ti Jesuse. Hech laj yalbe ti yajchanc'opetique xchi'uc ti crixchanoetique: ");
INSERT INTO tzoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Chich'ic bendición ti much'utic tsna'ic ti mu'yuc yutsil ti yo'ntonique. Ja' chventaimbat yo'ntonic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Chich'ic bendición ti much'utic ch-oq'uic yu'un ti oy smulique. Ja' chmuc'ubtasbatic yo'ntonic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Chich'ic bendición ti much'utic mu sna' stoy sbaique. Ja' ch-ac'bat slumalinic ti ach' balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Chich'ic bendición ti much'utic toyol yo'ntonic tsc'an ti toj yo'ntonique. Ja' ch-ac'batic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Chich'ic bendición ti much'utic chc'uxubinic yantique. Ja' chc'uxubinatic uc yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Chich'ic bendición ti much'utic mu sc'an spas ti c'usi chopole. Ja' chba sq'uelbeic sat ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Chich'ic bendición ti much'utic tspajesic pleitojele. Ja' col jnich'on, xchi sc'opilalic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Chich'ic bendición ti much'utic chich'ic ilbajinel yu'un ti toj ti c'usi tspasique. Ja' chventaimbat yo'ntonic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Jun no'ox yutsil chc'ot ti aventaic mi ho'on ti jventa chayutoxuc ti crixchanoetique, chayilbajinoxuc, chasnopboxuc amulic. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nichimuc me avo'ntonic yu'un. Mu me xavich'ic mul yu'un. Yu'un chc'o avich'ic ep amotonic te ti vinajel. Hech ono'ox laj yich'ic ilbajinel ti j'alc'opetic yu'un ti Diose, ja' ti much'u i'ayic ti balumil ti vo'onee. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Ti ho'oxuque hech chaj c'u che'el ats'am c'otemoxuc yu'un ho'oxuc ti aventaic ti chlecub ti crixchanoetique. Yu'un ti mi oy yutsil avo'ntonique hech yu'un chatunic li' ti balumile. Ti mi mu'yuc yutsil avo'ntonique, mu'yuc atuic li' ti balumile hech chaj c'u che'el ti mi mu xa chi'uc ti ats'ame, ja' chtenat loq'uel. Te chtec'at yu'un crixchanoetic. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Ti ho'oxuque hech chaj c'u che'el luz c'otemoxuc. Ti ho'oxuque ja' aventaic chavaq'uic ti q'uelel ti oy yutsil avo'ntonique hech chaj c'u che'el ti muc'ta jteclum ti te oy ti ba vitse. Ja' mu stac' naq'uel. Ja' chq'uelilanat scotol ora. Ja' hechoxuc ti ho'oxuque. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ti ho'oxuque hech chaj c'u che'el ti toje ti muc un chavac' ti yolon almud. Ja' chavac' ti scuxabbil toj hech chac' squeval ti stojol scotol ti much'utic te oyic ti anae. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hech yu'un ja' hech tsc'an ti ho'oxuque, chavaq'uic ti q'uelel yutsil avo'ntonic ti stojol crixchanoetic. Yu'un ti oy yutsil avo'ntonique, hech chlic spasic uc ti muc' ti Jtotique ti te oy ti vinajele ti aventaic. Hech yu'un ja' atuic ti li'to oyoxuc ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Mu me xacuyic ti nital yu'un ti jch'aybe ti smantal ti Diose ti laj yal ti Moisese xchi'uc ti c'utic laj yal ti yan j'alc'opetic yu'un ti Diose. Mu yu'unuc tal jch'aybe smantal, tal jts'acubtasbe. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Melel ti c'usi chacalbeique, c'alal oy to ti vinajele ti balumile, mu xlaj sc'opilal ti smantal ti Diose ti laj yal ti Moisese ja'to mi ic'ot ti pasel scotol. Manchuc mi tscuyic ti oy bu mu tsotsuc sc'opilal, chc'ot ti pasel scotol. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hech yu'un ti much'u tspec'tsambe sc'opilal ti smantal ti Diose ti laj yal ti Moisese, manchuc mi jun no'ox tspec'tsambe sc'opilale, mi hech chac'be snop ti crixchanoetique, ja' mu lum lequil abatuc ch-ilat yu'un ti Diose ti much'u hech tspase. Ja'uc ti much'u chch'umbe scotol smantal ti Diose, mi hech chchanubtas ti crixchanoetique, ja' lequil abat ch-ilat yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chacalbeic, tscuyic ti oy yutsil yo'ntonic ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti fariseoetique. Ti ho'oxuque mu me xanopic hech. Ho'oxuque jelavenuc me yutsil avo'ntonic ti mero melel. Yu'un mi hech avo'ntonic hech chaj c'u che'el ti much'u chcale, mu stac' chasventaimboxuc avo'ntonic ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ava'yojic xa ti hech albil comel ti antiguoetic ti vo'onee: “Mu me xamilvanic. Ti much'u chmilvane ja' chmilat uc”, x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ho'oni chacalbeic, ti much'u ch-ilin ti stojol ti yermanoe, ti mu'yuc stu chil ti yermanoe, ti chixtalc'opta ti yermanoe, ja' imilvan xa hech chaj c'u che'el ti much'u imilvane. Co'ol chba yich'ic castigo ti c'atimbac xchi'uc ti jmilvaneje. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","’Ja' tsots sc'opilal ti oy yutsil avo'ntonic ti stojol ti avermanoe. Hech yu'un mi oy avich'oj talel smoton Dios ti chavac'be yo' bu tscajambeic ti smoton ti Diose, mi te chana' ti oy amul ti stojol ti avermanoe, te chavac' comel bu nopol tscajambeic smoton ti Diose ti smoton Dios ti avich'oj tale. Jbael chba bic'tajan ti stojol ti avermanoe. Patil chtal avac'be smoton ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Mi oy ataoj amul ti stojol avermano, ba lequilc'opono ti ora. Mo'oje, quechel to amul ti stojol ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Melel ti c'usi chacalbeique, mi mu hechuc chapasique, ts'acal chayac'bot atoj ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ava'yojic xa ti hech albil comel ti antiguoetic ti vo'onee: “Mu me xamulivajic”, x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ho'oni chacalbeic, scotol ti much'u tsc'upin ti antse imulav xa c'otem obi. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Hech yu'un mi chasbolibtasot ti c'u che'el chaq'uele, mu lecuc. Hech yu'un ja' tsc'an ti mu'yuc c'usi chaq'uel hech chaj c'u che'el ti much'u mu xc'ot sate. Hech cha'och ti utsilal. Ja' vocol mi chabatic ti c'atimbac yu'un ti mu xapajes abaique. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ja' no'ox hech uc mi chasbolibtasot ti ac'obe, ja' tsc'an ti mu'yuc ac'ob hech chaj c'u che'el ti much'u mu'yuc sc'obe. Hech cha'och ti utsilal. Ja' vocol mi chabatic ti c'atimbac yu'un ti mu xapajes abaique. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Hech albil comel uc ti antiguoetic ti vo'onee: “Scotol ti much'u tsutes ti yajnile, ac'o sp'ejan ti hun ac'o yac'be ti yajnile ti c'usi sventailuc ti tsutese”, x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ho'oni chacalbeic, scotol ti much'u tsutes ti yajnile, mi mu scojuc ti imulav ti yajnile ti tsutese, ja' chac' mulivajuc ti yajnile. Scotol ti much'u chic' yu'un chajnilin ti much'u sutesbil yu'un ti smalale, ja' chmulav chc'ot. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ava'yojic xa uc ti hech albil comel ti antiguoetic ti vo'onee: “Mu me hoviluc chaval ti stojol ti Cajvaltic Diose. Ac'o c'otuc ti pasel avu'un ti c'usi laj aval ti stojole”, x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ho'oni chacalbeic, mi jutuc mu me xava'anic rextico. Mu me xava'an ti rextico ti vinajele yu'un ja' smuc'ta nacleb ti Diose yo' bu tspas mantal. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mu me xava'an ti rextico ti balumile yu'un ja' scajleb yacan ti Diose. Mu me xava'an ti rextico ti Jerusalene yu'un ja' slum ti Diose, ja' ti mero Totil Ajvalile. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mu me xava'an ti rextico ti stojol Dios ti ajole. Yu'un ti stsotsil ajole mu stac' xac'atajes ti sac, mu stac' xac'atajes ti ic'. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Meleluc me ti ac'opique. Mu me xava'an rextico. Yu'un mi chavac' jelavuc ti ac'opique, ja' mulil c'otem obi. Ja' chach'umbeic smantal ti pucuje. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ava'yojic xa uc ti hech albil comel ti antiguoetic ti vo'onee: “Mi chatup'be jp'ej sat yan, ja' chatup'bat jp'ej asat uc. Mi chapejbe jp'ej ye yan, ja' chapejbat jp'ej ave uc”, x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ho'oni chacalbeic, mu me xapacbeic sutel. Mi oy much'u chasmajot ti jech asate yu'un oy amul tscuy, ac'o smajot ti xcha'jechel uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mi oy much'u ti hovil chastic'bot amul ti stojol ti jueze, mi tsc'an chaspojbot ac'u', ac'o yich' batel achij uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ti much'u oy yabtele mi chasujot ti icatsil jun reva, cuchbo batel chib reva. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mi oy c'usi chasc'ambot avermano yu'un oy amul tscuy, ac'bo batel. Mi oy much'u tsc'an chch'amun ti c'usi oy avu'une, mu me xamac ti c'op. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ava'yojic xa uc ti hech albil comel ti antiguoetic ti vo'onee: “C'uxubino avecino, ilintao avajcontra”, x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ho'oni chacalbeic, c'uxubinic ti avajcontraique. C'ambeic bendición ti stojol ti much'u chayixtalc'optae. Ac'o ti q'uelel yutsil avo'ntonic ti stojol ti much'u chayilintae. C'opombeic Dios ti stojolic ti much'u chasmajoxuque xchi'uc ti much'u chayilbajinoxuque. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mi hech chapasique, hech chvinaj ti yol snich'onoxuc ti Jtotique ti te oy ti vinajele. Ti Jtotique ti te oy ti vinajele, co'ol chac' quevanuc c'ac'al ti stojol ti much'utic mu xtun yo'ntonique xchi'uc ti much'utic lec yo'ntonique. Co'ol chac' taluc ho' ti stojol ti much'utic toj yo'ntonique xchi'uc ti much'utic mu tojuc ti yo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mi ja' no'ox chac'uxubinic ti much'u chaxc'uxubinoxuque, mu yu'unuc más lec avo'ntonic. Co'ol chapasic xchi'uc ti jtsobpatanetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mi ja' no'ox avermanotac chac'opon, mu xvinaj ti oy yutsil avo'ntonique. Co'ol chapasic xchi'uc ti much'utic mu xojtiquinic ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ti ho'oxuque hechuc me yutsil avo'ntonic hech chac c'u che'el ti yutsil yo'nton ti Jtotique ti te oy ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’P'ijanic me, ti c'alal chana'ic ti Diose ti chvinaj ti chapasic ti muq'ue, mu me ja'uc chapasic yu'un chac'an ti lec chayiloxuc ti crixchanoetique. Mi hech chapasique mu xayac'boxuc amotonic ti Jtotique ti te oy ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Hech yu'un ti c'alal chavaq'uic ti motonil ataq'uin, mu me xavalbe yan ti hech chapase hech chaj c'u che'el tspasic ti jlo'lavanetique te ti temploetic xchi'uc ti plazaetic. Hech tspasic yu'un tsc'an tspasatic ti muc' yu'un ti crixchanoetique. Melel ti c'usi chacalbeique, mu'yuc stu chil ti Diose ti hech tspasique. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ho'oxuque c'alal chavaq'uic ti motonil ti ataq'uinique, mu me hechuc avo'ntonic ti ac'o yilot yan. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hech mu xilic ti chavaq'uic ti motonil ti ataq'uinique. Ti Jtotique ja' chil. Ja' chayac'boxuc bendición yu'un ti hech chapasique. Ti bendición ti chayac'boxuque ti stojol scotol crixchanoetic chvinaj. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ti c'alal chac'oponic ti Diose mu me hechuc chapasic hech chaj c'u che'el tspasic ti jlo'lavanejetique. Va'ajtic ti temploetic xchi'uc ti esquinaetic lec cha'yic chac' sbaic ti q'uelel ti stojol ti crixchanoetique ti tsc'oponic ti Diose. Melel ti c'usi chacalbeique, mu'yuc stu chil ti Diose ti hech tspasique. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ho'oxuque c'alal chac'oponic ti Diose, mu me hechuc avo'ntonic ti ac'o yilot yan. Q'uejo aba atuc, c'opono ti Jtotique. Ti Jtotique ja' chil ti hech chapasique. Ja' chayac'boxuc bendición yu'un ti hech chapasique. Ti bendición ti chayac'boxuque ti stojol scotol crixchanoetic chvinaj. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ti c'alal chac'oponic ti Diose, mu me co'oluc chac'opon hech chaj c'u che'el tsc'opon ti yajsantoic ti much'utic mu xojtiquinic ti Diose. Co'ol no'ox chalilambe ti jujun vuelta tsc'opone yu'un tscuyic ti hech ch-a'ibat sc'opique. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mu me hechuc chapasic. Ti Jtotique sna'oj c'usi chtun avu'unic ti c'alal mu to chac'ambeic ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ho'oxuque hech chac'oponic ti Diose: Jtotic Dios, te oyot ti vinajel. Ac'o xajpasotutic ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ac'o sta yorail chapas mantal atuc li' ti balumile. Ac'o c'otuc ti pasel li' ti balumile ti c'usi tsc'an ti avo'ntone hech chaj c'u che'el c'otem ti pasel ti vinajel. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ac'bun talel jve'eltutic c'ac'al li'to. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pasbuntutic perdón yu'un jmultutic hech chaj c'u che'el jpasojbetutic perdón much'u oy smul cu'untutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mu me xibatutic yo' bu chisujat ti mulil. Coltauntutic me hech mu xistsaluntutic ti pucuje. Ho'ot aventa chapas mantal sbatel osil. Ho'ot jelaven ap'ijil atuc sbatel osil. Ho'ot chapasat ti muc' sbatel osil. Jun yutsil ti hech chc'ot ti pasel, hech chavutic ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Yu'un mi chapasilambeic perdón much'u oy smul avu'unic, hech chaspasilamboxuc perdón yu'un amulic uc ti Jtotique ti te oy ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mi mu xapasilambeic perdón much'u oy smul avu'unic, hech mu xaspasilamboxuc perdón yu'un amulic uc ti Jtotique. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Ti c'alal chavipan abaic, mu me hechuc chapasic hech chaj c'u che'el tspasic ti jlo'lavanejetique ti tsbon satique yu'un hech chaq'uic ti q'uelel ti chich'ic mul yu'un ti smulique tscuyique. Melel ti c'usi chacalbeique, mu'yuc stu chil ti Diose ti hech tspasique yu'un mu hechuc ti yut yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ho'oxuque c'alal chavipan abaic, tuso me ajolic, poco asatic. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Hech mu xvinaj ti stojol crixchanoetic ti avipanoj abaique. Ja' no'ox chil ti Jtotique. Ja' chayac'boxuc bendición yu'un ti hech chapasique. Ti bendición ti chayac'boxuque, ti stojol scotol crixchanoetic chvinaj. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Mu me xatsobic ac'ulejalic li' ti balumile yo' bu tsep chon, yo' bu stsaqui ti cux, yo' bu tsjam na j'eleq'uetic yu'un ch-elc'ajic. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ho'oxuque tsobic ac'ulejalic ti vinajel yo' bu mu'yuc chon, yo' bu mu stsaqui ti cux, yo' bu mu'yuc j'eleq'uetic mu'yuc much'u ch-elc'ajic. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yu'un ti bu oy ti ac'ulejale, te chbat avo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Hech chaj c'u che'el lámpara chac' squeval yu'un chtun yu'un yan, ja' no'ox hech ti jsatique ja' chtun yu'un ti jq'ueltic much'u chich' vocol yu'un hech ti jq'uelambetic ti c'utic oy cu'untique. Yu'un mi ti jq'uelambetic ti c'utic oy cu'untique, lec co'ntontic, lec jvinquileltic, lec oyucutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mi mu xac'an xaq'uelambeic ti c'utic oy avu'unique hech mu xu' ch-abtej Dios ti avo'ntonic yu'un oy mulil te. Hech yu'un chtup' ti sc'op Diose ti te ti avo'ntonique ti c'u yepal ach'unojique. J'ech'el cha'ochic yan vuelta ti mulil o. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Mu xtun mi oy cha'vo' avajval. Ti june chavilinta. Ti yane ja' chac'uxubin. Jun no'ox avo'nton ti stojol ti june, mu xtun chavil ti yane. Mu xu' chatun yu'un ti Diose mi ja' chavajvalin ti ataq'uine. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Hech yu'un chacalbeic, mu me xlo'laj avo'ntonic yu'un ti c'u che'el chacuxiic li' ti balumile, yu'un ti c'usi chave'ic, c'usi chavuch'ic. Mu me xlo'laj avo'ntonic yu'un ti c'u che'el chata ac'u'ic. Ja' ti Diose laj yac'boxuc abec'talic, acuxlejalic. Hech yu'un chayac'boxuc uc ac'u'ic ave'elic. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Q'uelo avil ti mutetique. Mu x'avolajic, mu xc'ajovajic, mu stsobic sve'elic, mu'yuc snail sve'elic. Mac'limbilic yu'un ti Jtotique ti te oy ti vinajele. Ti ho'oxuque jelaven pasbiloxuc ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hovil ti chlo'laj avo'ntonique, mu yu'unuc más hal chacuxi yu'un ti hech chapasique. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Mu me xlo'laj avo'ntonic yu'un ac'u'ic. Q'uelo avil ti nichimetic ti yaxaltique c'u che'el chch'iic. Mu x'abtejic, mu xjalovajic. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Chacalbeic, ti Salomone manchuc mi ep sc'ulejal stuc muc xco'olaj ti sc'u'e hech chaj c'u che'el yutsil ti nichime. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ti vomole t'ujum yox xa. Patil ti yan chib oxib c'ac'al chtaquij, hech chtun yu'un tsq'uixna orno bu chta'aj caxlan vaj. Manchuc mi j'oc' no'ox li'oy ti balumile, t'ujum pasbil yu'un ti Diose ti vomole. Ti ho'oxuque jelaven chayac'boxuc ac'u'ic. Mu to chach'unic ti lec. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hech yu'un mu me xlo'laj avo'ntonic. “¿C'u che'el chijve'ucutic? ¿C'usi chcuch'tic? ¿Bu ti jtatic jc'u'tic?” mu me xachiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hech chlo'laj yo'ntonic ti much'utic mu xojtiquinic ti Diose. Ti Jtotique ti te oy ti vinajele scotol sna'oj ti c'usi chtun avu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mi toyol avo'ntonic yu'un chasventaimboxuc avo'ntonic ti Diose yu'un hech chapasic ti c'usi lec chil ti Diose, hech yu'un scotol chayac'boxuc ti c'utic chtun avu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hech yu'un mu me xlo'laj avo'ntonic yu'un ti c'usi chc'ot ti pasel ti oc'ome. Stuc ac'o sventain sba ti oc'ome. P'isbil no'ox chquich'tic vocol ti jujun c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Mu me xasa'beic smul yan hech mu xc'ot yich'bot ac'opic. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mi ep laj asa'beic smul yan, ep no'ox chc'ot yich'bot ac'opic. Mi jutuc no'ox laj asa'beic smul yan, jutuc no'ox chc'ot yich'bot ac'opic. Mi lec ti c'usi chapasique, lec chaspasbeic uc. Mi mu lecuc ti c'usi chapasique, mu lecuc chaspasbeic uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mu xtun chavil ti oy bu chjelav jutuc ti avermanoe. Mu xavil ti ep no'ox chajelav ho'oti. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hech yu'un chavalbe ti avermanoe: “Mu me xapas hech”, xavut. Ho'oti mu xavil ti yac'oj sba chapas ep ho'oti. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jlo'lavanejot. Ja' jbael chacomes scotol ho'oti. Hech patil xu' chacolta ti ac'o scomes ti bu jutuc no'ox chjelave. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ja'uc ti much'utic j'ech'el perroique ti mu sc'an xch'umbeic sc'op ti Diose ti ja' no'ox batem yo'ntonic chcontrainvanique, mu xa me xacha'alilambeic ti sc'op ti Diose ti ja' jelaven yutsile, ti ja' chacuxi sbatel osil yu'une. Hech chaj c'u che'el ti ts'i' ti mu xa'i pajesel ti chti'vane, ja' hechic ti much'utic mu sc'an cha'i ti sc'op Diose. Hech chaj c'u che'el ti chitome ti ch-ech' stec' ti nats'ile ti bu toyol stojole, ja' hechic ti much'utic mu xch'unic ti jelaven yutsil ti motonil ti chich'ique. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’C'anilambeic ti Diose asta chayac'boxuc. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yu'un scotol ti much'u tsc'anilambee, ja' ch-ac'bat scotol ti c'utic tsc'ane. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Ho'oxuque mi chasc'ambe vaj yu'un tsve' ti anich'one, mu tonuc chavac'be. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mi chasc'ambe choy yu'un tsti', mu chonuc chavac'be. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ho'oxuque ti mu xtun ti avo'ntonique chana'ic c'usi lec motonil chavac'beic ti anich'nabique. Ja'uc ti Jtotique ti te oy ti vinajele jelaven tsna' c'usi lec motonil chaq'uilambe ti much'u chc'anilambat ti stojole. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Hech yu'un mi chac'an ti lec chaspasboxuc ti yan crixchanoetique, lec chapasbeic uc. Hech chal ti smantal ti Diose ti laj yal ti Moisese. Hech chal uc ti sun ti j'alc'opetic yu'un ti Diose ti vo'one. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Tamo ti be ti bu biq'uit no'ox ch-oche. Yu'un ja' muc' ti sbelal ch'ayele. Jamal ti bu ch-oche. Ja' ep te chbatic yu'un mu vocoluc ti tamel ti be lume. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ja' biq'uit ti sbelal cuxlejale. Biq'uit no'ox ti bu ch-oche. Atabil no'ox ti much'u ch-och batele yu'un ja' no'ox ch-och batel ti much'u tsbic'tajes sbae. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’P'ijanic me, oy nopbilal j'alc'opetic. Chtal sva'an sbaic ti atojolic. Manso x'elan hech chaj c'u che'el carnero. Ti yo'ntone hech chaj c'u che'el bolom chti'van. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ti sventa yabtelic chvinaj. Hech chaj c'u che'el mu xata durazno ti ch'ix, mu xata manzana ti bu tomal ch'ix, ja' no'ox hech mu xata c'usi lec ti stojol nopbilal j'alc'op. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Scotol lequil te' lec tsatin. Ti bu mu xtun ti te'e, mu xtun uc ti sate. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ti lequil te'e puru lec sat chac'. Ti bu mu xtun ti te'e, puru mu xtun ti sat chaq'ue. Mu scap sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Scotol te' ti bu mu xtun ti sate, ja' chich' p'asel. Ja' chtenat ochel ti c'oc'. Ja' no'ox hech uc ti nopbilal j'alc'ope, ja' chtenat ochel ti c'oc'. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hech yu'un mi chopol ti yabtelique, hech chavojtiquinic ti ja' nopbilal j'alc'opetic. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ti much'u “Cajval, Cajval”, xiyutune, mu scotoluc ventaimbil yo'nton yu'un ti Diose. Ja' no'ox ventaimbilic yo'ntonic ti much'u tspas ti c'usi tsc'an yo'nton ti Jtote ti te oy ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ti slajebal c'ac'al ep ti much'u chiyalbun: “Cajval, ho'ot ti aventa laj caltutic ac'op. Ho'ot ti aventa laj jloq'uestutic pucujetic. Ho'ot ti aventa ep jchop o abteletic laj jpastutic”, chiyutun. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hech jamal chcalbe: “Muc bu laj cojtiquinoxuc. Batanic, muc xapasic ti c'usi laj jc'ane. Atuc laj apas abaic ti mantal”, chcut. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ti much'u chiya'ibun jc'ope, mi tspas ti c'usi chcale, ja' hech chaj c'u che'el jun vinic lec p'ij. Laj smeltsan sna ti ba ton. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tsots ital ho'. Inoj tal ti ho' ti spatpat snae. Ital ic'. X'i'et ti iq'ue c'ot smaj sba ti sna. Muc xbut'q'uij ti snae yu'un meltsambil ti ba ton. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ti much'u chiya'ibun jc'ope, mi mu spas ti c'usi chcale, ja' hech chaj c'u che'el jun vinic mu p'ijuc. Laj smeltsan sna ti hi'tic. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tsots ital ho'. Inoj tal ti ho' ti spatpat snae. Ital ic'. X'i'et ti iq'ue c'ot smaj sba ti sna. Ibut'q'uij ti snae. J'ech'el ibut'q'uij comel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Hech laj yo'nton c'opojuc ti Jesuse. C'alal laj ya'ibeic sc'op ti Jesuse, ich'ay yo'ntonic ti jchi'iltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yu'un ichanubtasvan hech chaj c'u che'el much'u oy tsots yabtel. Muc xchanubtasvan hech chaj c'u che'el ti much'utic ichanubtasvan ti smantal ti Diose ti scuyoj sbaique. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","C'alal iyal tal ti vits ti Jesuse, ep ti jyalel ti jchi'iltique laj sts'acliic batel. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Te laj snup ti be jun jchi'iltic. Yich'oj c'a'el chamel ti vinique. Tal squejan sba ti stojol ti Jesuse. Hech laj yalbe: ―Cajval, mi chac'ane, xu' chichop avu'un ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ti Jesuse laj yac' sc'ob, laj yac'be ti sjol ti vinique. Hech laj yalbe: ―Hechuc, chopan ―xut. Ti ora ichop ti jchi'iltique ti c'a'el chamel yich'oje. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ti Jesuse hech laj yalbe: ―A'yo' me ava'i, mu me much'u chavalbe ya'i. Batan, ba ac'o aba ti q'uelel ti stojol ti palee. Ac'bo smoton ti Diose hech chaj c'u che'el laj yal ti Moisese. Hech tsna'ic ti jchi'iltique ti nacol xae ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","I'och ti jteclum Capernaum ti Jesuse. Te ital ti stojol jun yanlum vinic. Ja' capitan soldado ti vinique. Tal yalbe vocol ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Hech laj yalbe: ―Cajval, oy jun jmozo te metsel ti jna. Sicuben ti yacane. Lum ep c'ux cha'i ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ti Jesuse hech laj yalbe: ―Te chibat. Chba jcolta comel ―xchi xtac'av ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Hech itac'av ti capitan soldadoe: ―Cajval, mu'yuc tsots cabtel yu'un ho'ot chabat ti jna. Ja' no'ox alo batel amantal hech chcol o ti jmozoe. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ho'oni quich'oj mantal. Ti jpas ti mantal soldadoetic. Chcalbe ti june: “Batan”, chcut. Chbat ju'un. Chcalbe ti yane: “La'”, chcut. Chtal ju'un. Chcalbe ti jmozoe: “Paso li'to”, chcut. Tspas ju'un. Ja' no'ox hech ti ho'ote ja' no'ox alo amantal ―xchi ti capitan soldadoe. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nichim no'ox yo'nton ti Jesuse yu'un ti hech laj yal ti vinique. Ti Jesuse hech laj yalbe ti much'utic xchi'inoje: ―Melel ti c'usi chacalbeique, mu to bu jtaoj junuc hech ti jchi'iltique, ho'ucutic ti yelnich'onucutic ti Israele, ti hech chch'un hech chaj c'u che'el chch'un ti yanlum vinic li'to. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chacalbeic uc. Ti yan c'ac'al ep yanlum crixchanoetic chtalic ti sjoylejal balumil. Te chc'ot xchi'inic ti jtotic Abrahame xchi'uc ti jtotic Isaaque xchi'uc ti jtotic Jacobe te ti yo' bu tspas mantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ti much'utic ja' jtot ti Abrahame, hech yu'un xu' chi'och yo' bu tspas mantal ti Diose, ti xchiique, ja' mu x'ochic. Ja' chtenatic ochel ti ic' osil. Te chc'ot yoc'ta sbaic o. Te xjep'et yeic o yu'un ep ti vocole ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ti Jesuse hech laj yalbe ti capitan soldadoe: ―Batan yu'un chc'ot ti pasel hech chaj c'u che'el ach'unoj ―xut. Ti ora icol ti smozoe. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ti Jesuse i'och ti sna ti Pedroe. Laj yil te metsel ti svayeb ti sme' ti yajnile. Oy sc'ac'al sbec'tal ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ti Jesuse laj stsacbe sc'ob. Ti ora ilamaj ti sc'ac'ale. Ilic ti antse, lic mac'linvanuc. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","C'alal imal xa ti c'ac'ale, i'ic'atic talel ti stojol ti Jesuse ep ti much'utic ochem pucuj ti yo'ntonique. Jp'el no'ox mantal laj yal ti Jesuse hech iloc' ti yo'ntonic ti pucujetique. Icol yu'un uc scotol jchameletic. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Hech ic'ot sc'op ti laj yal comel ti Isaíase, ja' ti j'alc'op yu'un ti Diose ti vo'one. Hech laj yal: “Ja' chixch'aybucutic jmultic. Chiscoltaucutic c'usuc no'ox c'ux chca'itic”, xchi ti Isaíase. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ti Jesuse c'alal laj yil ti joyubtabil yu'un ep jchi'iltic, hech laj yal mantal: ―Batic ti jech nab ―xut ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tal sc'opon ti Jesuse jun jchanubtasvanej yu'un ti mantaletique ti scuyoj sbae. Hech laj yalbe ti Jesuse: ―Cajval, buc no'ox chabat chajchi'in batel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ti Jesuse hech laj yalbe: ―Oy xch'en ti vete. Oy stso'op ti mutetique. Ho'oni ti co'ol crixchanoucutique mu'yuc bu ti jtaan jba ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ital jun jch'unojel. Tal yalbe: ―Cajval, coltaun batel. Chba jchi'in jtot. Ja'to mi ichame, ja'to chtal jchi'inot ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ti Jesuse hech laj yalbe: ―Ti much'utic jun to chamenic ya'yel yu'un mu sc'an chixch'umbun ti jc'ope, xu' tsmuc sbaic stuquic. Ja' tsots sc'opilal ti chachi'inune ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","I'och ti barco ti Jesuse. Laj xchi'in ochel ti barco ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","C'alal chanavic ti yut nabe, tsots ital ic'. Lic nicuc ti jyalel ti nabe. C'an ch'ayuc yalel ti ho' ti barcoe. Vayal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ti yajchanc'opetique laj stijic ti Jesuse. Hech laj yalbeic: ―Cajval, coltauntutic. Chijch'ay xa ti ho' ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ti Jesuse hech laj yalbe: ―¿C'u yu'un chaxi'ic? Yu'un mu ono'ox ach'unojucun ti lec, hech yu'un chaxi'ic ―xchi. Ilic ti Jesuse. Laj spajes ti iq'ue xchi'uc ti nabe. Hech ipaj yu'un ti iq'ue xchi'uc ti nabe. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ich'ay yo'ntonic ti yajchanc'opetique: ―¿Much'u vinical li'to ti ich'umbat smantal yu'un ti iq'ue xchi'uc ti nabe? Ti ora no'ox ipaj yu'un ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iloc' ti barco ti Jesuse lum ti jech nab yo' bu ti jteclum Gadara sbi. Ixanav batel ti be. Te laj snup cha'vo' jchi'iltic. Ochem pucuj ti yo'ntonic ti xcha'va'alique. Te iloq'uic tal ti campo santo yu'unique. Ti bu chba ac'atuc ti ánimae ja' te snainoj. Yu'un pujul ch'enetic jombil ti ton ti bu ch-ac'at ti ánimaetique te ti campo santo yu'unique. Perro ti jyalel ti jchi'iltique. Mu'yuc much'u tsc'an chjelavic batel te ti be yu'un xi'bil ti jchi'iltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ti xcha'va'alique hech laj yavtaic ti Jesuse: ―Mu aventaucuntutic, Jesús, ho'ot Snich'onot ti Diose. Mu to tsta yorail ti chavilbajinuntutic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ti bu va'ajtic ti jchi'iltique te no'ox oy nopol chitometic. Te tsa' sve'elic. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ti pucujetique hech laj yalbeic vocol ti Jesuse: ―Mi yu'un chaloq'uesuntutique, ac'un chi'och ti yo'ntonic ti chitometique ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Hech i'albatic yu'un ti Jesuse: ―Te batanic ―xut. Hech ti pucujetique iloq'uic tal ti yo'ntonic ti jchi'iltique, hech ba stic' sbaic ti yo'nton ti chitometique. Ti chitometique scotolic anil ba sten sbaic yalel ti ch'en hech i'ochic ti nab. Te laj sjiq'uic ho'. Te icham o scotol. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ijatav batel ti jchabiejchitometique. I'ochic batel ti jteclum. Scotol ba xcholic ti c'u che'el icham ti chitometique xchi'uc ti c'u che'el icol ti jchi'iltique ti oy ono'ox pucuj ti yo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hech yu'un scotol ti jchi'iltique ti te nacajtique loc' sa'ic ti Jesuse. C'alal laj staic ti Jesuse, laj yalbeic vocol yu'un ac'o loc'uc batel ti slumalic. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hech i'och ti barco ti Jesuse. Icha'sut batel ti jech nab ti bu itale, hech ic'ot ti slumal, ja' ti Capernaume. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","I'ic'at talel ti stojol ti Jesuse jun jchamel, ja' jchi'iltic. Sicuben yacan ti vinique. Metsel ti spop ital. C'alal laj yil ti Jesuse ti chch'unique, laj yalbe ti jchamele: ―Tote, mu xavich' mul. Ch'ayem xa amul ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Te oy uc cha'vo' oxvo' ti jchi'iltique ti ichanubtasvan ti smantal ti Diose ti scuyoj sbaique. Hech laj yal ti yo'ntonic: “Ja' ti jchi'iltic li'to, Dios tscuy sba”, xchi xc'opojic ti yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ti Jesuse sna'ojbe yo'ntonic. Hech yu'un hech laj yalbe: ―¿C'u yu'un ti mu lecuc chc'opoj avo'ntonic? ");
INSERT INTO tzoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Melel much'uuc no'ox xu' chal ti ch'ayem xa amul, xu' xchi. Much'uuc no'ox xu' chal uc ti lican, xanavan, xu' xchi. Ja' tsc'an chaq'uel ti much'u hech chc'opoje mi chc'ot ti pasel yu'un hech chaj c'u che'el chal. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Laj xa cal ti ch'ayem xa smul hech yu'un q'uelo c'usi ti jpas ti ora to yu'un hech chana' ti melel ti ho'on ti jch'ay mulil li' ti balumile, ho'on ti co'ol crixchanoucutique ―xut. Ti Jesuse hech laj yalbe ti jchamele: ―Lican, balo batel apop, batan ti ana ―xut ti jchamele, xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ti ora ilic ti jchamele. Ibat ti sna. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","C'alal laj sq'uelic ti hech ic'ot ti pasele, toj xi'el ic'otic ti jchi'iltique. Laj yalbeic vocol ti Diose yu'un hech yac'ojbe sp'ijil jun crixchano. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ixanav batel jutuc ti Jesuse. Laj yil jun vinic te nacal yo' bu tstojic spatanic ti crixchanoetique. Jtsobpatan ti vinique. Ja' batem yo'nton chlo'lavan ti taq'uin. Ho'on obi, Mateoun. Ti Jesuse hech laj yalbun: ―Chi'inun batel ―xiyutun. Ti ora laj jchi'in batel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Te ba nacluc ti yut na ti Jesuse yu'un te chve'. Ep italic jtsobpatanetic xchi'uc yan jp'ajmantaletique. Tal xchi'inuntutic ti naclej ti mesa, ho'ontutic ti yajchanc'opuntutique xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Te oy uc cha'vo' oxvo' ti fariseoetique. Hech yu'un c'alal laj yilic ti hech ic'ot ti pasele, hech laj sjac'buntutic: ―¿C'u yu'un chchi'in ti ve'el jtsobpatanetic xchi'uc yan jp'ajmantaletic ti maestro avu'unique? ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ti Jesuse laj ya'ibe sc'opic, hech laj yalbe: ―Ti much'utic lec oyique mu yu'unuc tsc'anic jun jpoxtavanej yu'un lec oyic. Ja' no'ox tsc'anic jpoxtavanej ti much'utic jchameletique. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ba nopo ava'yic c'usi sjam ti sc'op Dios avi to: “Ti jc'an ti chac'uxubinvanique. Mu jc'an ti chamilbucun jmotone”, ti xchie. Ti ho'one ma'uc tal jcolta ti much'utic ti jun yo'nton ti stojol ti Diose. Ja' tal quic' ti jtojol ti much'utic mu junuc yo'nton ti stojol ti Diose yu'un ac'o sutes yo'ntonic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ital uc cha'vo' oxvo' ti yajchanc'opetic ti Juane. Tal sc'oponic ti Jesuse. Hech laj sjac'be: ―Yipanoj sbaic ti fariseoetique ti ora to. Quipanoj jbatutic uc. ¿C'u yu'un mu xipan sbaic ti avajchanc'opetique? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Hech itac'av ti Jesuse: ―Ti yorail tspasic q'uin ti jnupunele xchi'uc scotol ti yuts yalaltaque, mu lecuc mi chich'ic mul ti yuts yalaltaque ti c'alal te to xchi'inojic ti jnupunele. Mu hechuc sjam. Hech yu'un ti mu xipan sbaic ti cajchanc'op ti ora to. Ja'to mi ic'ot yorail chismilucun ti cajcontrae, ja'to chlic yich'ic mul, chlic yipan sbaic ti cajchanc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Scotol ti much'u chixch'umbun ti jc'ope persa tscomes ti c'u che'el xch'unoj ono'oxe, ja' ti poco c'ope. Persa ja' chch'un scotol ti ach' c'ope. Hech chaj c'u che'el ti much'u tspac'an ti bu lajem ti sc'u'e, mu spac'an ti ach' poc' mi mu chuc'biluque. Yu'un mi mu chuc'biluc ti ach' poq'ue, ja' chcha'jat nixtoc ti bu poco xae. Ja' más ep chjat ti bu pocoe. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hech chaj c'u che'el mu'yuc much'u tspul ach' vino ti yac'oj sba chyijube ti bu poco nucul ti spulobil ti vinoe. Mi hech tspase, chjat ti nucule. Lástima chmal scotol ti vinoe. J'ech'el mu xa xtun ti nucule. Ti ach' vinoe ti yac'oj sba chyijube tsc'an pulel ti ach' nucul. Hech lec chcom xchi'uc ti yave ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","C'alal ta to xc'opoj ti Jesuse, ital jun jchi'iltic. Ja' tspas mantal te ti templo cu'untic ono'oxe, ho'ucutic ti co'ol judioucutic xchi'uque. Tal squejan sba ti stojol ti Jesuse. Hech laj yalbe: ―Ja'to no'ox icham ti jtsebe. La' ac'o ac'ob ti sjol yu'un ac'o cha'cuxiuc ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ilic ti Jesuse. Laj xchi'in batel ti jchi'iltique. Hech yu'un ho'ontutic ti yajchanc'opuntutique laj jchi'intutic batel uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Oy jun ants jchamel te jchi'inojtutic uc. Ja' jchi'iltic. Lajcheb xa habil tsacbil ti chamel ti antse. Scotol c'ac'al chil ti ch'ich'e. Ital ti spat ti Jesuse. Tal stsacbe sba sc'u' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yu'un hech laj snop ti yo'nton: “Mi ja' no'ox ti jtsacbe sc'u', hech chicol o”, xchi ti yo'nton ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ti Jesuse laj sjoyp'in sba. Laj yil ti antse. Hech laj yalbe: ―Mu me xavich' mul, me'e. Yu'un laj ach'un ti xu' cu'une, hech yu'un chacol ―xut. Ti ora icol ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ti Jesuse ic'ot ti sna ti much'u oy yabtel te ti temploe. I'och ti sna. Te laj yil oy much'utic choq'uesanic aj. Te xlaquetic ch-oq'uic ti jchi'iltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ti Jesuse hech laj yalbeic: ―Loc'anic batel. Mu chamenuc ti tsebe. Vayal no'ox ―xchi ti Jesuse. Yu'un ti hech laj yal ti Jesuse, ep ilabanat yu'un ti jchi'iltique yu'un laj sna'ic ti icham xa ti tsebe. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ti Jesuse c'alal laj stac loq'uel ti jchi'iltique, stuc i'och batel ti bu oy ti ánimae. Laj stsacbe sc'ob ti tsebe. Ti ora ilic ti tsebe. Hech icuxi ti tsebe. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ti ora ipuc sc'opilal ti sjoylejal balumil ti laj xcha'cuses ti tsebe ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hech lic xanavuc batel yan vuelta ti Jesuse. Its'acliat batel yu'un cha'vo' jchi'iltic, ja' ma'satetic. Hech laj yavtaic ti Jesuse: ―Ho'ot ti yelnich'onot ti Davide ti ac'opilal chatale, c'uxubinuntutic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","C'alal i'och xa ti sna ti Jesuse, italic ti stojol ti cha'vo' ma'satetique. Ti Jesuse hech laj sjac'be: ―¿Mi chach'unic ti xu' jam asatique? ―xchi ti Jesuse. ―Ti jch'un, Cajval ―xchi xtac'avic. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hech yu'un ti Jesuse laj spicbe satic. Hech laj yalbe: ―Ac'o c'otuc ti pasel avu'unic hech chaj c'u che'el ach'unojique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ti ora ijam satic. Ti Jesuse tsots mantal laj yalbe: ―Mu me much'u chavalbe yu'un ti hech laj jcoltaoxuque ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hech isutic batel ti bu talemique. Ba spucbeic sc'opilal ti sjoylejal ti bu oyique. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","C'alal mu to chloc' batel ti ma'satetique, i'ic'at tal ti stojol ti Jesuse jun jchi'iltic. Uma' ti vinique. Oy pucuj ti yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iloq'uesbat ti pucuje te ti yo'nton. Ic'opoj ti uma'e. Ich'ay yo'ntonic ti jchi'iltique. Hech laj yalic: ―Mi jutuc muc bu xquiltic hech ti jchi'iltique, ho'ucutic ti yelnich'onucutic ti Israele ―xchiic ti jchi'iltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ti cha'vo' oxvo' fariseoetic ti te oyique hech laj yalic: ―Tsloq'ues pucujetic ti sventa ti totil pucuje ―xchi tslabanic. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Xmelmun ixanav batel ti Jesuse ti scotol muc'ta jteclumetic xchi'uc ti scotol biq'uit jteclumetic. Te ichanubtasvan ti templo yu'un ti jchi'iltique. Laj xchol ti lequil ach' c'ope ja' ti chisventaimbucutic co'ntontic ti Diose. Icol yu'un scotol ti jchameletique xchi'uc scotol ti much'u ep c'ux laj ya'yique. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ti Jesuse c'alal laj yil ti te humajtic ti crixchanoetique, laj xc'uxubin yu'un uts sbaic laj yil. Colemic hech chaj c'u che'el carneroetic. Mu'yuc much'u chq'uelatic. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hech yu'un laj yalbuntutic, ho'ontutic ti yajchanc'opuntutique: ―Melel ti ep ti much'utic tsc'an cha'yic ti sc'op ti Diose. Mu epuc ti much'u tsc'an chcholbe. Hech chac c'u che'el mi ep ti c'ajoje, mu epuc ti much'u tsc'aje. ");
INSERT INTO tzoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hech yu'un c'ambeic vocol ti Diose, yu'un ja' Yajval ti abtele, yu'un ac'o stac batel yan ti much'u chcholbat ti sc'ope ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ti Jesuse lic st'ujuntutic, ho'ontutic ti yajchanc'opuntutique, lajchavo'untutic. Laj yac'buntutic jp'ijiltutic yu'un ti jloq'uestutic pucujetic ti yo'ntonic ti crixchanoetique, yu'un chcol cu'untutic scotol jchameletic. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ja' hech jbitutic ti lajchavo'untutique, ho'ontutic ti yajchanc'opuntutique. Ja' jbael ti Simone, ja' ti Pedro x'utate, xchi'uc ti Andrese, ja' ti yits'in ti Pedroe. Xchi'uc ti Jacoboe, ja' ti snich'on ti Zebedeoe, xchi'uc ti yits'in ti Jacoboe, ja' ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Xchi'uc yan, Felipe sbi, xchi'uc yan, Bartolomé sbi. Xchi'uc yan, Tomás sbi, xchi'uc ho'on ti Mateoune, ho'on ono'ox ti jtsobpatanune. Xchi'uc yan, Jacobo sbi, ja' snich'on Alfeo. Xchi'uc yan, Lebeo sbi. Oy chib sbi. Tadeo yan sbi. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Xchi'uc yan, Simón sbi, ja' ti laj xchi'in ti cananetic ono'oxe. Yu'un ti cananetic sbiique ja' yu'un ti toyol yo'ntonic mu sc'an x'ochic ti mozoil yu'un ti romaetique. Ja' zeloteetic sbiic ti griego c'op. Xchi'uc yan, Judas Iscariote sbi, ja' ti laj yac' entrecal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ti lajchavo'untutique laj stacuntutic batel ti Jesuse quich'ojtutic smantal: ―Mu me xabatic ti slumal yanlum viniquetic xchi'uc uc ti slumal ti samariaetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Batanic ti bu oy ti jchi'iltique, ho'ucutic ti yelnich'onucutic ti Israele, yu'un ch'ayemic ti be hech chaj c'u che'el carneroetic. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","C'alal chaxanavic batel, hech chacholic batel: “Ista xa yorail ti chisventaimbucutic co'ntontic ti Diose”, xavutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Coltao jchameletic. Cha'cuseso animaetic. Lamantasbo xchamel ti much'u yich'oj c'a'el chamele. Loq'uesbo pucujetic ti yo'ntonic. Hech chaj c'u che'el nac'uxubinatic xa ho'oxuque, c'uxubino ti yantique. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Mu me xavich'ic batel ataq'uinic, manchuc mi c'anal taq'uin, manchuc mi saquil taq'uin, manchuc mi cobre taq'uin. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mu me xavich'ic batel uc ave'elic. Mu me xavich'ic batel cha'lic ac'u' xchi'uc asempat xchi'uc anamte'. Yu'un scotol ti much'u ch-abteje ja' ch-ac'bat sve'el. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Buc no'ox jteclumal cha'ochic, buc no'ox colonial cha'ochic, jac'o me ava'yic ti much'u lec sc'opilale. Ochan ti sna, tean ja'to mi laj anop ti chaloc' batele. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","C'alal cha'och ti sna, c'ambo bendición ti stojol scotol ti much'utic te oye. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mi lec sc'opilal sjunul sna, chc'ot ti sventa ti bendicione. Mi mu lecuc ti sc'opilale, mu xc'ot ti sventa ti bendicione. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ti much'u mu xayic'ot ochel ti snae, ti much'u mu sc'an xa'i ac'opique, c'alal chaloq'uic batel ti sna, mi ti slumal, ta me xalilinic comel stanil avacanic. Ti stanil avacanique, ja' señail ti icom ti sventaic yu'un muc xaspasoxuc ti muq'ue. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Melel ti c'usi chacalbeique, ti c'alal tsta yorail ti chac' castigo ti Diose ep chich'ic castigo ti much'utic nacajtic ti jteclum yo' bu chalilinic comel ti stanil ti avacanique. Ja' jutuc no'ox chich'ic castigo ti much'utic te nacajtic ti jteclum Sodoma xchi'uc ti jteclum Gomorra ti vo'onee. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’A'yo' me ava'yic c'u che'el chajtaquic batel. Hech chaj c'u che'el ti carneroetic chc'ot sta ti bu jti'vanej bolom, ja' hechoxuc ti ho'oxuque. Hech chaj c'u che'el ti orachone ti p'ije, tsna' c'u che'el tscolta sba, ja' hech tsc'an ti p'ijoxuc ti ho'oxuque. Hech chac c'u che'el ti tsumute lec, ja' hech chapas abaic uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","P'ijanic me. Oy much'u mu xasc'anic. Chayac'oxuc entrecal ti sc'ob ti much'utic tspasic mantal te ti templo yu'unique. Chayac'boxuc acial ti yut templo yu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chayic'oxuc batel ti stojol gobernadoretic xchi'uc ti stojol yan ajvaliletic ho'on ti jventa. Hech chacholbucun jc'op ti stojolic xchi'uc ti stojol yanlum viniquetic. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","C'alal cha'ac'atic entrecal ti sc'obic, mu me xacajnopilanic ti avo'ntonic c'usi chc'o avalic xchi'uc ti c'usi chatac'avique. Ja' cha'albat ti avo'ntonic ti c'u che'el chatac'avique. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mu ho'ucot ti chac'opoje; ja' no'ox chaxch'amumbot ave'ic ti Ch'ul Espíritu yu'un ti Jtotique. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Oy chac' ti milel yits'in. Oy chac' ti milel sbanquil. Oy chac' ti milel snich'on. Oy tscontrain stot sme'. Chac' ti milel uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Chayilintaoxuc ep crixchanoetic ho'on ti jventa. Ti much'u scotol icuch yu'un c'alal tsta ti slajebal c'ac'al, ja' chcol. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mi te chavich' ilbajinel ti bu chac'ote, chaq'uej aba batel ti yan jteclum. Melel ti c'usi chacalbeique, mu to xu' avu'unic chaq'uel scotol ti jteclumetic ti li' ti jlumaltique, tal xa cac' castigo ho'oni ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ho'oxuc ti cajchanc'opoxuque, ho'oxuc ti cabatoxuque, mu me xacuyic ti más lec chayiloxuc. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ta me xavich'ic contrainel hech chaj c'u che'el chquich' contrainel ho'on ti maestroun avu'unique, ho'on ti avajvalune. Ho'ot pucujot, xiyutun ho'on ti totilune, hech yu'un ti ho'oxuque ti jnich'naboxuque, jelaven chopol chayalboxuc. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Hech yu'un mu me xaxi'ic ti stojolic. Scotol ti c'utic snopoj ti yo'ntonique persa ch-ac'at ti q'uelel scotol ti c'utic mu xvinaj ti ora to. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ti ho'oxuque ja' aventaic ti jamal chaval scotol ti jc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mu me ja'uc chaxi'ic ti much'u xu' chasmilot yu'un mu xu' chasmilbot ach'ulel. Ti Diose ti xu' chasmilbot ti abec'tale xchi'uc ti ach'ulele te ti c'atimbac, ja' me xaxi'ic. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Chana'ic ti cinco cobre no'ox stojol ti cha'cot biq'uit mutetique. Ti mutetique mi jcotuc mu xp'aj yal tal ti lum mi mu sc'an ti Jtotique. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ti stsotsil ajolic uque scotol atabil. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hech yu'un mu me xaxi'ic. Ho'oxuque jelaven ac'opilalic; mu'yuc sc'opilal ti biq'uit mutetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Hech yu'un scotol ti much'utic jamal chal ti stojol crixchanoetic ti chiyojtiquinune, jamal chcal uc ti chcojtiquin te ti stojol ti Jtote ti te oy ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Scotol ti much'utic chismucun ti yo'ntonic ti stojol crixchanoetic, hech jamal chcal ti stojol ti Jtote: “Mu xcojtiquin”, chcut. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Mu me xacuyic ti tal jtojobtas ti balumile ti ora to. Mu yu'unuc tal jtojobtas ti balumile, tal cac' yu'un tscontrain sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tal cac' yu'un tscontrain stot. Ja' no'ox hech uc ti tsebe tscontrain sme'. Ja' no'ox hech uc ti alibale tscontrain ti sme'el'alibe. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ja' contra chil sbaic xchi'uc yermanotac te ti yut sna. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Ti much'u mu sc'an chixch'umbun ti jc'ope yu'un naca me ilinuc ti stot sme'e, mu stac' chixchi'inun. Ti much'u mu sc'an chixch'umbun ti jc'ope yu'un naca me ilinuc ti yol snich'onique, mu stac' chixchi'inun uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yu'un ti much'u mu sc'an chich' vocol ti jventa hech chaj c'u che'el chquich' vocol ho'oni, mu stac' chixchi'inun. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ti much'u tsots sc'opilal cha'i ti xcuxlejal li' ti balumile, ja' chch'ay. Ti much'u mu tsotsuc sc'opilal cha'i ti xcuxlejal li' ti balumile ho'on ti jventa, ja' chcuxi. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Ti much'u chaspasoxuc ti muq'ue, ho'on chispasun ti muc' uc. Ti much'u chispasun ti muq'ue, ja' tspas ti muc' uc ti Jtote ti laj stacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ti much'u tspas ti muc' ti much'u j'alc'op yu'un ti Diose, yu'un yich'oj yabtel yu'un ti Diose, co'ol ch-ac'bat bendición xchi'uc ti much'u j'alc'op yu'un ti Diose. Ti much'u tspas ti muc' ti much'u toj yo'ntone yu'un toj yo'nton chil, co'ol ch-ac'bat bendición xchi'uc ti much'u toj yo'ntone. ");
INSERT INTO tzoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Melel ti c'usi chacalbeique, ti much'u chayac'boxuc avuch'ic ho' manchuc mi jun no'ox taza siquil ho' chayac'boxuc yu'un chil ti ach'unojbun jc'ope, ja' ch-ac'bat bendición yu'un hech laj spas ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","C'alal laj yo'nton laj spasuntutic ti mantal ti lajchavo'untutique ti yajchanc'opuntutique, niloc'tutic batel xchi'uc ti Jesuse. Ti Jesuse ba chanubtasvanuc, ba xchol ti sc'op Diose te ti jteclumetic te ti bu jlumaltutic, ja' ti Galileae. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","C'alal tiq'uil ti chuquel ti Juane, laj ya'i ti c'usi abtelal laj spas ti Cristoe. Laj stac talel cha'vo' oxvo' ti yajchanc'opetic yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Hech laj yalbe: ―Ba jac'bo ti Jesuse: “¿Mi ho'ot ono'ox ti ac'opilal chatale, mi ta to jmalatutic yan?” xavut ―xchi ital sc'op ti Juane. Hech tal sjaq'uic. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Hech itac'av ti Jesuse: ―Ba albo ya'i ti Juane scotol ti c'u yepal laj ava'yic ti ora to, scotol ti c'u yepal laj avilic ti ora to. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Chc'ot xa sat ma'satetic. Chanav xa mecanetic. Ichop xa xchamel ti much'u c'a'el ono'ox cha'yique. Cha'i xa c'op ti much'u maquem ono'ox xchiquinique. Icha'cuxi xa ánimaetic. Icholbatic xa ti lequil ach' c'ope ti me'onetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nichim no'ox yo'ntonic scotol ti much'utic mu xchibaj yo'ntonic ti jtojole, xchi ti Jesuse”, xavut ti Juane ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","C'alal isut batel ti viniquetique, ti Jesuse lic yalbe ti jchi'iltique ja' sc'opilal ti Juane: ―Ti much'u ay aq'uelic te ti xocol balumile, chana'ic ti ma'uc ti much'u chib ti c'usi tsnope hech chaj c'u che'el ti tsisan cotstique ti buc no'ox chjimat yu'un ti iq'ue. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Laj avilic ti ma'uc ti much'u tslap lec sc'u' spoc' ti c'alal na'ayique. Yu'un ti much'utic tslap lec sc'u' spoq'uique, te nacajtic ti sna ajvaliletic. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Laj ana'ic ti ja' j'alc'op yu'un Dios ti c'alal laj aq'uelique. Chacalbeic, jelaven sc'opilal stuc ti Juane ti laj aq'uelique; jutuc no'ox sc'opilal ti yan j'alc'opetic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ja' ti Juane ti hech ts'ibabil sc'opilale: Ja' chbaej avu'un ti j'alc'op ti jtac batele. Ja' tscajmeltsambe yo'ntonic yu'un hech chaxch'umbot ac'op, ti xchi ono'oxe. Ja' sc'opilal ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Melel ti c'usi chacalbeique, scotol ti much'u anem li' ti balumile mu'yuc much'u hech tsots yabtel yich'oj hech chaj c'u che'el ti Juane, ja' ti laj yac' ich'ho'e. Pero ti much'u ti chventaimbat yo'nton o yu'un ti Diose, manchuc mi mu'yuc tsots yabtel chich', ja' más ep bendición yich'oj. Ti Juane ja' muc xich' ep bendición. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Asta c'alal i'och ti abtel ti Juane, ja' ti laj yac' ich'ho'e, asta ti ora to oy much'u toyol yo'ntonic yu'un ac'o ventaimbatuc yo'nton yu'un ti Diose. Ti much'u toyol yo'ntonique ja' chventaimbat yo'ntonic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Scotol ti j'alc'opetic yu'un ti Diose ti vo'onee hech laj yalic ti hech chc'ot ti pasele. Hech ts'ibabil uc ti sun ti Diose c'alal mu to chtal ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mi chach'unique hech chana'ic ti ja' xq'uexol ti Elíase ti Juane ti ital xae. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nopilanic lec hech chaj c'u che'el laj xa calboxuc. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Chacalbeic ac'opilalic c'u xa'elanic li' ti balumil ti ora to. Ho'oxuque hech chaj c'u che'el ololetic nacajtic ti plaza ti hech chalbeic ti xchi'iltaque: ");
INSERT INTO tzoNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Laj xa coq'uesantutic aj ava'yic, muc xa'ac'otajic”, x'utatic. Chtac'av ti xchi'iltaque: “C'alal ni'oc'tutic, ho'oxuque muc xavich'ic mul”, xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yu'un c'alal ital ti Juane, muc xaxchi'inoxuc ti ve'el. Hech lic avalic: “Oy pucuj ti yo'nton”, xachiic. Ja' sc'opilal ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","C'alal nital ho'oni ti co'ol crixchanoucutic uque, laj jchi'inoxuc ti ve'el. Hech lic avalic: “Q'uelo avil, scotol c'ac'al chve', chuch' vino. Lec tsc'opon sbaic xchi'uc jtsobpatanetic xchi'uc yan jp'ajmantaletic”, xachiic. Ti ja'uc laj yac'boxuc ap'ijilic ti Diose ti ja' jelaven sp'ijil stuque, hech laj apasucuntutic ti muc' ti hechuque. Hech laj ana'ic ti ac'biluntutic jp'ijiltutic yu'un ti Diose ti hechuque ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hech yu'un ti Jesuse laj yalbe sc'opilal ti jchi'iltique ti te nacajtic ti jteclumetic yo' bu laj spas ep jchop o abteletique. Hech laj yalbe sc'opilal yu'un muc sutes yo'ntonic yu'un ti smulique: ");
INSERT INTO tzoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Ta me xich'ic vocol ti jchi'iltic ti te nacajtic ti jteclum Corazín. Ta me xich'ic vocol ti jchi'iltic ti te nacajtic ti jteclum Betsaida. Ti yanlum crixchanoetic ti te nacajtic ti vo'one ti jteclum Tiro xchi'uc ti jteclum Sidón, ti lajuc yilic ti jchop o abteletic hech chaj c'u che'el laj xa yilic ti jchi'iltic ti nacajtic ti ora to te ti Corazín xchi'uc ti Betsaidae, laj slapic coxtal poc', laj sbon sbaic ti stanil c'oc' ti hechuque. Ja' señail ti tsutes yo'ntonic yu'un ti smulique. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hech yu'un chacalbeic sc'opilal ti ora to. Ti yorail chchapambat sc'opilal yu'un smulic scotol crixchanoetic yamal castigo chich'ic ti yanlum crixchanoetique ti te nacajtic ti Tiro xchi'uc ti Sidón ti vo'onee. Ja' tsots castigo chich'ic ti jchi'iltique ti te nacajtic ti Corazín xchi'uc ti Betsaida ti ora to. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ti jchi'iltic ti te nacajtic ti jteclum Capernaume, tscuyic ti más ech'em ch-ac'bat bendición. Mu hechuc, ja' más ech'em ch-ac'batic castigo. Ti crixchanoetic ti te nacajtic ti vo'one ti jteclum Sodoma, ti lajuc yilic ti jchop o abteletic hech chaj c'u che'el laj xa yilic ti ora to ti jchi'iltic ti te nacajtic ti Capernaume, te to oy ti jteclum Sodoma ti hechuque. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Hech yu'un chacalbeic sc'opilal ti ora to. Ti yorail chchapambat sc'opilal yu'un smul scotol crixchanoetic, yamal castigo chich' ti much'utic te nacajtic ti Sodoma ti vo'onee. Ja' tsots castigo chich'ic ti jchi'iltic ti te nacajtic ti Capernaum ti ora to ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hech lic sc'opon Dios ti Jesuse: ―Tote, Ho'ot Ajvalilot yu'un ti vinajele ti balumile. Hocol avalbun, Tote, ti amacojbe yo'ntonic ti much'u p'ij yo'ntonic scuyojique yu'un mu me xa'ibeic sjam. Avac'ojbe sna'ic ti much'utic tsc'an chchanic hech chac c'u che'el ololetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Lec oy, Tote, yu'un hech tsc'an ti avo'ntone ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Lic sc'opon ti jchi'iltique yan vuelta ti Jesuse. Hech laj yalbe: ―Scotol yac'ojbun ti jc'ob ti Jtote. Ho'on ti Snich'onune mu'yuc much'u chisna'bun ti co'ntone. Ja' no'ox stuc ti Jtote chisna'bun ti co'ntone. Mu'yuc much'u chna'bat yo'nton ti Jtote. Ja' no'ox jtuc ti Snich'onune ti jna'be yo'nton xchi'uc scotol ti much'utic chcac'be sna'beic yo'nton ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","La' ti jtojol acotolic ho'oxuc ti nalubic xa, ti chavich'ic mul yu'un ti mu xataic ti chcol ti libre ti avo'ntonique. Ho'on chacac'boxuc ti chcol ti libre ti avo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ajvalinun, chambun co'nton yu'un lec co'nton ti ho'one, mu jna' jtoy jba. Mi hech chachambun ti co'ntone hech chcol ti libre ti avo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yu'un lec ti jmantale. Mu vocoluc ti ch'unel ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ti yan c'ac'al ni'ech'tutic xchi'uc ti Jesuse ti bu ts'umbil trigo. Ja' sc'ac'alil ti jcux co'ntontic c'alal te ni'ech'tutic xchi'uc ti Jesuse. Nivi'najtutic ho'ontutic ti yajchanc'opuntutique hech yu'un laj jtuch'tutic jutuc trigo laj ju'tutic, laj jc'uxtutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Niyiluntutic cha'vo' oxvo' ti fariseoetique. Hech lic yalbeic ti Jesuse: ―Q'uelo avil, tsp'aj mantal ti avajchanc'opetique yu'un ja' sc'ac'alil ti jcux co'ntontic ti ora to ―x'uti ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ti Jesuse hech laj yalbe: ―Ti ho'oxuque aq'uelojic xa ti sun ti Diose ti c'usi laj spas ti Davide c'alal itsacat ti vi'nal xchi'uc ti much'utic xchi'inojique. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ja' i'och ti templo yu'un ti Diose. Laj sve' ti caxlan vaje te ti ba mesa te ti stojol ti Diose. Manchuc mi yaloj ti Diose ti stuquic no'ox tsve'ic ti paleetique, laj sve' ti Davide xchi'uc ti xchi'iltaque. Mu'yuc smulic yu'un hech laj spasic. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ho'oxuc aq'uelojic xa uc ti sun ti Diose yo' bu laj sts'iba ti Moisese ti scotol c'ac'al sc'ac'alil ti jcux co'ntontic ch-abtejic te ti muc'ta templo ti paleetique. Mu'yuc smul yu'un hech tspasic. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yu'un xu' ch-abtejic ti templo ti paleetic ti sc'ac'alil ti jcux co'ntontic hech yu'un xu' tstuch' jutuc trigo yu'un chc'ux ti cajchanc'opetique. Yu'un más tsots cabtel quich'oj ho'oni; mu tsotsuc yabtel laj yich' ti jtotic Moisese. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Hech yaloj ti Diose: “Ja' ti jc'an ti chac'uxubinvanique. Ma'uc ti jc'an ti chamilbucun jmotone”, ti xchie. Ti lajuc ava'ibeic sjam avi c'op lume, muc chasa'beic smul ti much'utic mu'yuc smul ti hechuque. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ho'on jventainoj ti sc'ac'alil ti jcux co'ntontique ho'on ti co'ol crixchanoucutique. Ho'on chcal ti c'usi stac' pasel ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ixanav batel ti Jesuse. Te i'och ti templo yu'un ti jchi'iltique, ja' ti co'ol judioucutic xchi'uque. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Te oy jun jchi'iltic sicuben sc'ob. Lic sjaq'uic cha'vo' oxvo' ti fariseoetique, laj sjac'beic ti Jesuse: ―¿Mi stac' chijcoltavan ti sc'ac'alil ti jcux co'ntontic? ―xchiic yu'un tsc'an tsa'beic smul ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Hech itac'av ti Jesuse: ―Ti sc'ac'alil ti jcux co'ntontique mi chp'aj ti ch'en jcot acarnero, ¿mi mu xba aloq'ues? ");
INSERT INTO tzoNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mu tsotsuc sc'opilal jcot carnero, ja' tsots sc'opilal jun vinic. Hech yu'un ti c'usi lec ti pasele stac' ti jpastic ti sc'ac'alil ti jcux co'ntontic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hech yu'un ti Jesuse hech laj yalbe ti vinique: ―Xach'o ac'ob ―xut. Ti ora ichop ti sc'obe. Laj xach' ti sc'obe. Lec xa oy hech chaj c'u che'el ti jun sc'obe. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hech iloq'uic batel ti fariseoetique, ba xchapambeic sc'opilal smilel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ti Jesuse laj sna' ti hech ba spasic, hech yu'un laj sq'uej sba batel. Its'acliat batel yu'un ep jchameletic. Scotol icol yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ti Jesuse hech laj spas ti mantal: ―Mu me xba apucbun jc'opilal ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Hech ic'ot ti pasel ti sc'op ti Diose hech chaj c'u che'el laj sts'iba ti Isaíase, ja' ti j'alc'op yu'un ti Diose. Hech laj sts'iba: ");
INSERT INTO tzoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Q'uelo avil ti cabate, ja' ti much'u t'ujbil cu'une. Ep c'ux ti co'nton. Nichim no'ox co'nton yu'un. Chcac'be yich' ti Ch'ul Espíritu cu'une. Ja' yabtel chich'be sc'op ti much'utic mu xixch'umbucun ti jc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mu x'utvan, mu stsac sbaic ti c'op xchi'uc yantic, mu xac' sba ti pasel ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mu yu'unuc chba xchibajesbe yo'ntonic ti much'utic tsna'ic ti mu'yuc yutsil ti yo'ntonique. Ja' ti much'utic hech chaj c'u che'el aj ti oy xchamele, o candil ti mu xtil leque. Ja' chba scolta hech chcolic sbatel osil ti sventa. Hech mu xba yich'ic castigo. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ti yanlum crixchanoetique chilic ti xu' chcolic uc ti sventa ti cabate, xchi ti Diose, xchi ti Isaíase. Ja' sc'opilal ti Cajvaltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","I'ic'at tal ti stojol ti Jesuse jun jchi'iltic. Oy pucuj ti yo'nton. Ma'sat uma' mu xloc' xc'opoj ti jchi'iltique. Icol yu'un ti Jesuse, hech lic c'opojuc ti jchi'iltique, hech iyil ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ich'ay yo'ntonic scotol ti yan jchi'iltique. ―Jun to ja' ti yelnich'on ti Davide li'to ti sc'opilal chtale ―xchiic. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","C'alal laj ya'yic ti cha'vo' oxvo' fariseoetic ti te oyique, hech laj yalic: ―Ti vinic li'to ja' tsloq'ues pucujetic ti sventa ti totil pucuje, ja' ti Satanase ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sna'oj ti Jesuse ti hech laj yal ti yo'ntonique, hech yu'un hech laj yalbe: ―Mi tscontrain sbaic ti much'utic ochemic ti pas mantal ti jun no'ox gobiernoe, chjin ti gobiernoe. Mi tscontrain sbaic ti much'utic jun no'ox snaic xchi'uc jun no'ox slumalic, mu xcuxiic ep c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mi Satanás tsloq'ues ti Satanase, ja' tscontrain sba obi. Mi hech tspase, mu haluc tspas mantal. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ti sventauc ti Satanás ti jloq'ues pucujetic ti ho'one ti chavalique, ¿much'u tsbiiltas c'alal tsloq'ues pucujetic ti avajchanc'opetique? Ho'oxuque mu xtojob avu'unic. Xu' chastojobtasoxuc ti avajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ja' ti sventa ti Ch'ul Espíritu yu'un ti Diose ti jloq'ues ti pucujetique hech yu'un li' ti ora to tspas mantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ti much'u tsc'an ch-och ti sna c'oc' vinic yu'un chelc'ambe batel c'usi oy yu'un, persa chchuc jbael ti c'oc' vinique. Patil xu' chelc'ambe batel c'usi oy yu'un te ti sna. Ti Satanase hech chaj c'u che'el ti c'oc' vinique. Pero laj xa jtsal ho'oni. Laj xa jpojbe ti sc'ob ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Ti much'u chopol chil ti cabtele, ja' chiscontrainun obi. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Hech yu'un chacalbeic, scotol ti much'u chopol ti c'usi tspasique, chopol ti c'usi chalique, chopol ti c'usi tsnopique, oy to perdón mi tsc'anique. Ja' no'ox ti much'u ti chopol chc'opoj yu'un ti Ch'ul Espíritue, mu'yuc xa perdón. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Scotol ti much'u chopol chc'opoj ti jtojol ho'on ti co'ol crixchanoucutique, ja' tspasbatic perdón to. Ja' no'ox ti much'u ti chopol chc'opoj yu'un ti Ch'ul Espíritue, mu spasbatic perdón manchuc mi ti ora to, manchuc mi lum to batele. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Ti c'u x'elan chac' sat ti te'e, ja' ojtiquimbil. Ti bu lec ti te'e lec chac' sat. Ti bu mu xtun ti te'e, mu xtun ti sat chac' uque. Hech yu'un nopic mi lec ti mu xtun chavilucune yu'un puru lec ti cabtele. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ho'oxuque chopoloxuc hech chaj c'u che'el orachon. Mu stac' ti lec chac'opojic yu'un chopol avo'ntonic. Yu'un ti c'usi chnoj ti co'ntontique, ja' chloc' ti quetic. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ti much'u lec yo'ntone, ja' chloc' ti ye ti c'usi lec snopoj ti yo'ntone. Ti much'u chopol yo'ntone, ja' chloc' ti ye ti c'usi chopol snopoj ti yo'ntone. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Chacalbeic, ti jayp'el laj snopbeic smul yan ti crixchanoetique, chc'ot jac'batuc ti yorail ch-ich'bat sc'op yu'un smulic. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yu'un ti sventa ti c'u che'el nac'opojic chaloq'uic ti libre. Ti sventa ti c'u che'el nac'opojic cha'ac'batic castigo ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Te oy cha'vo' oxvo' ti fariseoetique xchi'uc ti much'utic ichanubtasvan ti smantal ti Diose ti scuyoj sbaique. Hech laj yalbeic ti Jesuse: ―Maestro, ti jc'antutic chavac'bun jq'ueltutic muc'ta señail yu'un hech ti jna'tutic ti tsots avabtel ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Itac'av ti Jesuse, hech laj yalbe: ―Tsc'an tsq'uelic señail ti jp'ijile ti much'utic chopol yo'ntonique xchi'uc ti much'utic laj xa scomesic ti Diose. Mu'yuc c'usi yan ch-ac'bat sq'uelic. Ja' no'ox ch-ac'batic sq'uelic hech chaj c'u che'el ic'ot ti pasel yu'un ti Jonase, ja' ti j'alc'op yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Hech chaj c'u che'el i'ay ti yut xch'ut ti muc'ta choy oxib c'ac'al xchi'uc oxib ac'ubal ti Jonase, hechun uc oxib c'ac'al xchi'uc oxib ac'ubal chicom ti yut ch'en ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ti yorail ch-ich'bat sc'op yu'un smulic scotol crixchanoetic mu'yuc xa smulic ch-ilat yu'un ti Diose ti much'utic te nacajtic ti jteclum Nínive ti vo'one. Ja'uc ti ho'oxuque ti li' nacaloxuc ti balumil ti ora to ep amulic cha'ilatic. Yu'un ti c'alal icholbat ya'yic ti sc'op ti Diose yu'un ti Jonase ti much'utic te nacajtic ti Nínivee laj sutes yo'ntonic yu'un smulic. Ti Jonase mu tsotsuc yabtel laj yich'. Ho'on más tsots cabtel quich'oj, ho'on ti li' va'alun ti atojolic ti ora to. Mu xac'an chapasbucun ti muc' ti jc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ti yanlum antse ti i'och ti ajvalil ti balumil te oy ti stojol sur, mu'yuc xa smul ch-ilat yu'un ti Diose ti yorail ch-ich'bat sc'op yu'un smulic scotol crixchanoetic. Ja'uc ti ho'oxuque ti li' nacaloxuc ti balumil ti ora to ep amulic cha'ilatic. Yu'un ti antse nom tal ya'ibe sc'op ti Salomone yu'un lum p'ij ti Salomone. Ho'oni ti li' va'alun ti atojolic ti ora to, yu'un jelaven jp'ijil. Mu xac'an xapasucun ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Ho'oxuc ti li' nacaloxuc ti balumil ti ora to ti chopol avo'ntonique, ja' hech chaj c'u che'el jun vinic ti oy pucuj ti yo'nton. Ti c'alal chloc' ti yo'nton, chanav batel ti xocol balumil, tsa' bu chnaqui. Mu sta. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Hech yu'un chal: “Chisut batel ti bu ono'ox niloc' talele”, xchi. C'alal te chc'ot, mesbil xa, lec meltsambil mu'yuc yajval chc'ot sta. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hech yu'un chba stsob tal hucvo' xchi'iltac, ja' ti much'u ech'em chopole. Te ch-ochic ti yo'nton ti vinique. Te chnaquiic o. Hech chcha'bolib nixtoc ti vinique. Ech'em chbolib ti jyalel. Hech ono'ox uc chapasbatic ti ho'oxuque ti li' nacaloxuc ti balumil ti ora to yu'un mu yu'unuc j'ech'el chac'an chach'unic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","C'alal yac'oj sba tsc'opon ti jchi'iltique ti Jesuse, te oyic ti amac' ti sme' ti Jesuse xchi'uc ti yits'inabtaque. Sc'an tsc'oponic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Oy much'u laj yalbe ti Jesuse: ―Te va'ajtic ti amac' ti ame'e xchi'uc ti avits'inabtaque. Sc'an chasc'oponot ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","50","Itac'av ti Jesuse, hech laj yalbe: ―Hech, ja' jme', ja' quits'inab pero más tsots sc'opilal scotol ti much'u tspas ti c'usi sc'an yo'nton ti Jtote ti te oy ti vinajele. Ja' quits'in obi, ja' quixlel obi, ja' jme' obi chc'ot ―xut. Ti Jesuse laj yac' señail sc'ob ti jtojoltutic ti ho'ontutic ti yajchanc'opuntutique. Hech laj yal: ―Ja' jme', ja' quits'inab c'otemic avi jayvo'ic li'to ―xchi. Ja' jc'opilaltutic jayvo'untutic ti yajchanc'opuntutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Patil iloc' batel ti sna ti Jesuse, ba snacan sba ti ti'nab. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ep laj stsob sbaic tal ti stojol ti jchi'iltique. Hech yu'un i'och ti yut barco ti Jesuse. Te inaqui ti yut barco. Te va'ajtic ti ti'nab scotol ti jchi'iltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ti Jesuse laj yalbe ya'yic ep lo'il. Oy sjam ti lo'il ti laj yalbee. Hech laj yalbe: ―Oy much'u ba sts'un strigo. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","C'alal laj svaj ti strigoe, oy ic'ot sat strigo ti ti'be. Ital mutetic, tal stamic. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oy ic'ot sat strigo ti tontic ti bu mu'yuc ep slumal. Ti ora ich'i yu'un mu epuc ti slumale. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","C'alal iq'uep ti osile, ilaj ti c'ac'al, itaquij yu'un mu'yuc lec yibil. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oy ic'ot sat strigo ti ch'ixtic. C'alal ich'i ti ch'ixe, iquevtaat ti strigoe, hech muc xch'i. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Oy ic'ot sat strigo ti lequil lum. Ja' lec laj yac' sat. Oy laj yac' sat ho'vinic ti p'ej, oy laj yac' sat oxvinic ti p'ej, oy laj yac' sat lajuneb xcha'vinic ti p'ej. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nopilanic lec hech chaj c'u che'el laj xa calboxuc ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ninopejtutic batel ho'ontutic ti yajchanc'opuntutique, ba jac'betutic ti Jesuse: ―¿C'u yu'un chavalbe lo'il ti jchi'iltique? ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hech itac'av ti Jesuse: ―Ti yantique mu hechuc ac'biluc sna'ic hech chaj c'u che'el ho'oxuque. Ti ho'oxuque ac'biloxuc ana'ic ti c'u che'el tsventaimbe yo'ntonic crixchanoetic ti Diose. Mu to oyuc much'u yan hech ya'yojic hech chaj c'u che'el ti ho'oxuque. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yu'un scotol ti much'utic xch'unoj jutuc, ti Diose chac'be xch'un yan asta ep tsna'ic. Ti much'utic mu sc'an xch'un, ja' chpojbatic ti jutuc sna'ique. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hech yu'un ti ja' no'ox chcalbe lo'il. Hovil ti chililanique, mu ono'ox xch'unic. Hovil ti cha'ilanique, mu ono'ox xc'ot ti yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Hech yu'un hech ic'ot sc'opilal ti laj sts'iba ti Isaíase: Hovil ti chava'ilanique, mu xc'ot ti avo'ntonic. Hovil ti chavililanique, mu xach'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yu'un laj xa atsatsubtas avo'ntonic hech mu xc'ot ti avo'ntonic. Laj xa amac achiquinic, hech mu xu' chava'yic. Laj xa amuts' asatic, hech mu xu' chaq'uelic. Yu'un mu xac'an xasutes avo'ntonic yu'un amulic yu'un hech chacolic cu'un, xchi ti Diose, xchi ti Isaíase. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Ho'oxuque yu'un laj xa yac'bot bendición ti Diose hech yu'un chavilic, hech yu'un chava'yic. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Melel ti c'usi chacalbeique, ep ti j'alc'opetic yu'un ti Diose, ep ti much'utic toj yo'ntonic uque sc'an chilic uc ti c'usi chavilic ti ora to ti ho'oxuque, muc xilic. Sc'an cha'yic ti c'usi chava'yic ti ora to ti ho'oxuque, muc xa'yic. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’A'yo' me ava'yic c'usi sjam ti lo'ile ti laj xa calboxuque, ja' sc'opilal ti much'u laj sts'un ti strigoe. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ti crixchanoetique ti cha'yic ti xu' chventaimbat yo'ntonic yu'un ti Diose, yu'un ti mu sc'anic ventainel yu'un ti Diose, hech yu'un mu xcom ti yo'ntonic ti sc'op ti Diose ti laj ya'yique. Ja' tspas ti pucuje ti mu xcom ti yo'ntonique. Ja' hech chaj c'u che'el ti sat trigoe ti ic'ot ti bee. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ti sat strigoe ti ic'ot ti bu tontique, ja' señail ti much'u ti ora no'ox chch'un c'alal cha'ibe sc'op ti Diose. Nichim no'ox yo'nton yu'un laj xch'un. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","J'oc' no'ox te oy ti yo'nton. Mu xcom ti yo'nton. Mi chich' vocol, mi chich' ilbajinel ti sventa ti sc'op ti Diose ti ora chchibaj yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ti sat strigoe ti ic'ot ti bu ch'ixtique, ja' señail ti much'u batem ti yo'nton ti c'usi oy li' ti balumile. Ja' te chlo'laat yu'un ti c'usi tsc'ane. Hech yu'un ti sc'op ti Diose ti cha'ie, ja' chquevtaat ya'yel yu'un ti sbic'tal yo'ntone. Hech mu satin ti sc'op ti Diose te ti yo'ntone. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ti sat strigoe ti ic'ot ti bu lequil lume, ja' señail ti much'u chac' ti yo'nton ti sc'op ti Diose. Te tsatin ti yo'nton. Oy tsatin ho'vinic, oy tsatin oxvinic, oy tsatin lajuneb xcha'vinic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Oy yan lo'il uc laj yalbe ti jchi'iltique ti Jesuse. Hech laj yalbe: ―Chacalbeic ti c'utic x'elan tspasvan ti mantal ti Diose. Hech yu'un chacalbe hech chaj c'u che'el jun vinic ti ba sts'un lequil trigo ti slum. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","C'alal vayajtic scotolic, ital ti yajcontrae. Tal sts'un c'ut'ul ti bu ts'umbil xa ti strigoe. C'alal ilaj yo'nton laj sts'un comel ti sbec' c'ut'ule, ibat ti yajcontrae. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","C'alal ich'i ti trigoe, ich'i uc ti c'ut'ule. Co'ol isatin ti xcha'tosole. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hech yu'un italic ti smozotac ti yajval ti balumile. C'ot sjac'beic: “Cajval, ¿mi mu yalojuc sba puru trigo laj ats'un lum toe? Ti ora to te capal xchi'uc c'ut'ul laj quiltutic”, xchiic ti smozotaque. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Hech itac'av ti yajval ti balumile: “Ja' laj sts'un ti cajcontrae”, xchi. Hech laj sjaq'uic ti smozotaque: “¿Mi chac'an ti jbultutic loq'uel ti c'ut'ule te ti yut atrigo?” xut ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Hech itac'av ti yajvale: “Hu'u, naca me abulic loq'uel uc ti jtrigoe c'alal chabulic loq'uel ti c'ut'ule. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Te ac'o ch'iuc xcha'tosol ja'to mi laj sta yorail ti jcuptique. Mi laj sta yorail ti jcuptique, hech chcalbe ti much'u tscupe: Ja' jbael chatsobic ti c'ut'ule, chasut'ic yu'un ch-och ti chiq'uel. Patil chatsobic ti jtrigoe, chatiq'uic ochel ti bu ti lequil na cu'une, chcut”, xchi ti yajval ti trigoe ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Oy yan lo'il laj yalbe uc ti jchi'iltique ti Jesuse. Hech laj yalbe: ―Chacalbeic yan vuelta ti c'utic x'elan tspasvan ti mantal ti Diose. Oy yip ch-abtej hech chaj c'u che'el ti biq'uit sbec' mostazate' ti laj sts'un ti slum jun vinic ti muc' chc'ot. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Lum biq'uit ti sbec' mostazate'e. Ja' más muc'tic ti yan ts'unubiletique. Mi ich'ie, muc' chbat. Ja' biq'uit chc'ot ti yan ts'unubiletique. Ja' muc' chc'ot ti mostazate'e. Chtal mutetic, chtal spas stso'op ti sc'ob ti te'e ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Oy yan lo'il laj yalbe uc ti Jesuse. Hech laj yalbe: ―Chacalbeic yan vuelta ti c'utic x'elan tspasvan ti mantal ti Diose. Oy yip ch-abtej hech chaj c'u che'el ti jutuc ti spumesbil xch'ut vaje ti tspumesbe xch'ut ti vaquib cuartiya harina ti laj scap jun ants. Hech ipum xch'ut o ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Hech laj yalbe lo'il ti jchi'iltique ti Jesuse. Puru lo'il laj yalbe pero oy sjam ti lo'ile. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Hech ic'ot sc'op ti yaloj comel ti j'alc'opetic yu'un ti Diose. Hech yalojbeic sc'opilal ti Jesuse: Puru lo'il chalbe ti crixchanoetique. Chchol ti c'usi mucule ti mu'yuc much'u laj sna'ique ti c'alal ilic ti balumile asta ti ora to, xchiic. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ti Jesuse laj sc'opon comel ti jchi'iltique. I'och ti sna. Hech lic jac'betutic, ho'ontutic ti yajchanc'opuntutique: ―Albun ca'itutic c'usi sjam ti lo'ile, ja' ti sc'opilal ti c'ut'ule ―xichitutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ti Jesuse hech laj yalbuntutic: ―Ho'on laj jts'un ti lequil trigoe, ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ti jlume ja' scotol ti balumile. Ti lequil trigoe ja' señail ti much'utic ventaimbil yo'ntonic yu'un ti Diose. Ti c'ut'ule ja' señail ti much'utic yol snich'on ti pucuje. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ti cajcontrae ti laj sts'un comel ti c'ut'ule, ja' ti totil pucuje. Ti yorail ch-och ti cupele, ja' ti slajebal c'ac'ale. Ti much'u tscupe, ja' ti ch'ul abatetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hech chaj c'u che'el itsob yu'unic ti c'ut'ule, ichic'at, hech ono'ox uc chc'ot ti pasel ti slajebal c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ho'on ti co'ol crixchanoucutique ti jtac talel ti ch'ul abatetic cu'une. Ja' chtal stsobic scotol ti mulile xchi'uc scotol ti jp'ajmantaletique ti i'ech'ic ono'ox li' ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ja' tstenic ochel ti c'oc'. Te chc'ot yoc'ta sbaic o. Te xjep'et yeic o yu'un ep ti vocole. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Patil chlic quevanuc ti much'utic toj yo'ntonique c'alal te xa oyic yo' bu tspas mantal ti Jtotique. Ja' chquevanic hech chaj c'u che'el chquevan ti c'ac'ale. Nopilanic lec hech chaj c'u che'el laj xa calboxuc. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Ti yu'un ti chasventaimboxuc avo'ntonic ti Diose hech chaj c'u che'el me'taq'uin mucul ti jtuch' balumil. Oy much'u laj sta, laj xcha'muc yan vuelta. Nichim no'ox yo'nton yu'un laj xa sta, hech yu'un ba xchon scotol ti c'usi oy yu'une yu'un tsman ti jtuch' balumil bu mucul ti me'taq'uine. Ja' hech tsc'an ti toyol avo'ntonic chac'anic ti ventaimbil ti avo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Ja' tsc'an ti toyol avo'ntonic chac'anic ti ventaimbil avo'ntonic yu'un ti Diose hech chaj c'u che'el ti much'u chmanolaje ti tsa' lequil nats'il. Perla sbi ti nats'il ti tsa'e. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","C'alal laj xa sta jun perla ti toyol stojole, ba xchon scotol ti c'usi oy yu'une yu'un tsman. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Chacalbeic yan vuelta ti c'utic x'elan tspasvan ti mantal ti Diose. Hech yu'un chacalbe hech chaj c'u che'el jun leb ti tstenic ochel ti yut nab. Te ch-och tal ep ti tos choyetic. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","C'alal mi inoj, tsnitic loq'uel ti ti'nab ti viniquetique. Te chnaquiic tst'ujic ti bu leque, tstiq'uic ti moch. Ti bu chopole tstenic batel. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hech ono'ox uc chc'ot ti pasel ti slajebal c'ac'al. Chtal ti ch'ul abatetique, chtal xch'aquic ti much'u chopol yo'ntonique xchi'uc ti much'u toj yo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Chtenatic ochel ti muc'ta c'oc' ti much'u chopol yo'ntonique. Te chc'ot yoc'ta sbaic o. Te xjep'et yeic o yu'un ep ti vocole ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ti Jesuse hech laj sjac'buntutic: ―¿Mi laj ava'ibeic sjam ti scotol ti lo'il ti laj xa calboxuque? ―xiyutuntutic. Hech nitac'avtutic: ―Laj ca'ibetutic sjam, Cajval ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Hech laj yalbuntutic: ―Lec ti laj ava'ibeic sjam ti jc'ope. Yu'un ho'oxuc ti chana'ic ono'ox ti smantal ti Diose ti vo'onee, ti chac'anic pasel ti mantal yu'un ti Diose ti ora to, ja' hechoxuc hech chaj c'u che'el yajval na ti oy scotol ti c'utic chtun yu'une. Yich'oj comel ti c'utic oy yu'un ti statamolique. Stuc laj xa sta yan uc. Hech yu'un scotol ti c'usi chtun yu'une, te xa oy ti sna ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","C'alal laj yo'nton laj yal lo'il ti Jesuse, iloc' batel ti bu oye. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ibat ti slumal, ja' ti Nazarete. Te ichanubtasvan ti templo yu'un ti jchi'iltique, ja' ti co'ol judioucutic xchi'uque. Ich'ay yo'ntonic ti much'utic laj ya'yique. Hech laj yalbe sbaic: ―¿C'usi chcutic ti jelaven sp'ijil ti jchi'iltic avi li'to? Jchop o ti yabtel tspase. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ja' snich'on ti carpintero li'i. Ja' yol ti Maríae avi to. Ja' yits'in ti Jacoboe xchi'uc ti Josee xchi'uc ti Simone xchi'uc ti Judase. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ja' yixleltac ti tsebetic ti li' nacalucutic xchi'uque. ¿Bu xchanoj tal scotol c'op li'to? ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hech muc xch'umbeic sc'op. Ti Jesuse hech laj yalbe: ―Buc no'ox chbatic ti j'alc'opetic yu'un ti Diose ja' tspasat ti muc'. Ja' no'ox te ti slumal xchi'uc ti sna ja' mu spasat ti muc' ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hech yu'un te ti slumal mu epuc laj spas jchop o abteletic yu'un muc xch'umbat ti sc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Laj ya'ibe sc'opilal ti Jesuse ti gobernadore, ja' ti Herodes sbie. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Hech laj yalbe ti abatetic yu'une: ―Lume ja' ti Juane, ja' ti laj yac' ich'ho'e. Icha'cuxi xa loq'uel ti ch'en. Hech yu'un oy sp'ijil yo'nton yu'un tspas jchop o abteletic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","C'alal cuxul to ti Juane, ti Herodese laj stsac, laj xchuc, laj stic' ti chuquel ti scoj ti Herodíase, ja' ti yajnil ti yits'ine. Ja' Felipe sbi ti yits'in ti Herodese. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yu'un ti Herodese hech i'albat ono'ox yu'un ti Juane: ―Mu xtun ti laj apojbe ti yajnil ti avits'ine laj avic' ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hech yu'un ti Herodese sc'an smil ti Juane. Ixi' yu'un ti jchi'iltique yu'un laj xch'unic ti ja' j'alc'op yu'un ti Diose ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Laj spasic q'uin yu'un iloc' sabilal ti Herodese. Te ti q'uin i'ac'otaj ti stojolic ti yol ti Herodíase. Puru viniquetic te o. Yu'un ti i'ac'otaje ja' no'ox yu'un ac'o c'upinatuc. Lec laj yil ti Herodese. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hech yu'un hech laj yalbe ti tsebe: ―C'usuc no'ox chac'an chacac'be. Yiloj ti Diose chacac'be ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hech yu'un ti tsebe jbael ba sjac'be ti sme'e. I'ac'bat c'op yu'un ti sme'e. Patil tal yalbe ti Herodese: ―Ac'bun ti plato ti sjol ti Juane, ja' ti much'u chac' ich'ho'e ―xchi ti tsebe. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","C'alal laj ya'i ti Herodese, ep laj yich' mul. Scoj ti hech yaloje, scoj uc ti laj ya'yic uc ti much'utic te xchi'inojic ti mesae, hech yu'un hech laj yal mantal: ―Ac'bo ti sjol ti Juane ―xut ti yajsoldadoe. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hech yu'un hech laj stac batel ti yajsoldadoe yu'un chba sc'oc'be tal sjol ti Juane ti te tiq'uil ti chuquele. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hech i'ich'bat tal sjol ti plato. I'ac'bat ti sc'ob ti tsebe. Ti tsebe ba yac'be ti sme'e. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Patil ital ti yajchanc'opetic ti Juane, tal yich'be batel ti sbec'tale, ba smuquic. Patil tal yalbeic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","C'alal laj ya'i ti Jesuse ti imilat xa ti Juane, hech i'och ti barco. Laj sq'uej sba batel ti yan balumil. Ja' xocol balumil. C'alal laj ya'yic ti jchi'iltique ti bu ibat ti Jesuse, hech iloq'uic batel ti jujun jteclum. Laj sts'acliic batel, ja' laj stamic batel ti ti'ti'nab. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ti Jesuse, c'alal iloc' ti barco, laj yil ti ep ti jyalel te humajtic ti jchi'iltique. Ic'uxubinvan ti Jesuse. Laj scolta ti jchameletique ti te xchi'inojic tale. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mal xa c'ac'al ho'ontutic ti yajchanc'opuntutique hech lic jc'opontutic ti Jesuse. Hech laj calbetutic: ―Xocol balumil li'to. Ich'ay xa ti c'ac'ale. Taco batel ti jchi'iltique ac'o batuc ti jteclumetic. Ac'o ba sman sve'elic ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Itac'av ti Jesuse, hech laj yalbuntutic: ―Mu persauc chbatic. Ac'bo sve'elic ho'oxuque ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Hech nitac'avtutic: ―Ja' no'ox ho'ob muc'tic caxlan vaj xchi'uc cha'cot choy quich'ojtutic ―xichitutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","―Ich'o talel ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ti Jesuse laj spas ti mantal ti jchi'iltique ac'o ba nacluc ti stenlej. Ti Jesuse laj stsac ti ho'ob muc'tic caxlan vaje xchi'uc ti cha'cot choye. Laj sq'uel muel vinajel, hech lic yalbe vocol ti Diose. Laj xet'ilan ti caxlan vaje, laj stuch'ilan ti choye. Laj yac'buntutic, ho'ontutic ti yajchanc'opuntutique. Ti ho'ontutique laj cac'betutic ti jchi'iltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Hech ive'ic scotolic. Ta yutsil inoj xch'utic o. Patil laj jtsobtutic ti xet'elal caxlan vaje xchi'uc ti sobril choye ti te comene. Inoj lajcheb almud ti sobril ti caxlan vaj ti laj sve'ique xchi'uc ti sobril choye. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ho'mil ti viniquetique ti ive'ique. Mu atabiluc ti antsetique xchi'uc ti ololetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ti Jesuse laj stic'untutic ochel ti barco, ho'ontutic ti yajchanc'opuntutique. Laj stacuntutic batel. Hech nibatutic ti jech nab. Te to icom ti Jesuse. Stuc laj sc'opon comel ti jchi'iltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","C'alal laj yo'nton laj sc'opon comel ti jchi'iltique, imu batel ti vits. Stuc ba sc'opon Dios. C'alal i'ic'ub ti osile, stuc no'ox o. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Te nixanavtutic batel ti barco te ti o'lol ti nabe. Oy yip ti iq'ue tspajesvan. Tsots chnicat ti barcoe yu'un ti ho'e. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Po'ot xa tsacub c'alal ital ti Jesuse ti bu cac'oj jba chixanavtutic batele. Ixanav talel ti yacan ti ba ho' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ho'ontutic c'alal laj jq'ueltutic ti chanav talel ti yacan ti ba ho', toj xi'el nic'otutic. ―Ch'ulelal van ―xichitutic. Ni'avantutic yu'un nixi'tutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ti Jesuse ti ora ic'opoj, laj sc'oponuntutic: ―Mu me xaxi'ic yu'un ho'on Jesusun. Muc'ubtaso avo'ntonic ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hech itac'av ti Pedroe: ―Cajval, mi melel ti ho'ote, pasun ti mantal yu'un chixanav tal ti cacan ti ba ho' te ti yo' bu oyote ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Hech itac'av ti Jesuse: ―La' me ―xchi. Hech yu'un iloc' ti barco ti Pedroe, ixanav batel ti yacan ti ba ho'. Sc'an chba sta ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","C'alal laj yil ti tsots ital ti iq'ue, ixi'. C'an ch'ayuc yalel ti ho'. Hech yu'un hech laj yavta ti Jesuse: ―Cajval, coltaun yu'un chich'ay yalel ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ti Jesuse ti ora laj stsac ti Pedroe. Hech laj yalbe: ―¿C'u yu'un naxi'? Mu'yuc lec xch'unojel avo'nton chquil ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","C'alal i'ochic ti barco ti xcha'va'alique, ipaj ti iq'ue. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hech yu'un ti ho'ontutique ti te oyuntutic ti yut barcoe, laj jquejan jbatutic ti stojol ti Jesuse. ―Melel ti ho'ot Snich'onot ti Diose ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nic'otutic ti jech nab. Niloc'tutic ti barco te ti jteclum Genesaret. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ti jchi'iltique ti te nacajtique, c'alal laj yojtiquinic ti ja' ti Jesuse, iloc' yajval yu'un ba spuquic ti sjoylejal slumal ti ital xa ti Jesuse. Hech i'ic'atic tal ti stojol Jesús scotol ti jchameletique. ");
INSERT INTO tzoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Laj sc'ambeic vocol manchuc mi sba sc'u' no'ox tspicbeic. Scotol ti much'utic laj spicbeic ti sc'u'e, hech icolic uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Iloq'uic tal ti Jerusalén cha'vo' oxvo' ti fariseoetique xchi'uc ti much'utic ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Tal sc'oponic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Hech laj sjac'beic: ―¿C'u yu'un mu xa spasic ti avajchanc'opetique hech chaj c'u che'el laj spasic ti antiguo jtatamoltique? Ti antiguo jtatamoltique hal laj spoc sc'obic c'alal ive'ic yu'un hech lec ac'o ilatuc yu'un ti Diose. Ti avajchanc'opetique mu xa hechuc tsnop c'alal tspoc sc'obic c'alal chve'ique ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Hech itac'av ti Jesuse: ―Ho'oxuque scoj ti chach'umbeic sc'op ti antiguo jtatamoltique hech chap'ajbeic smantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yu'un hech laj yal mantal ti Diose: “Paso ti muc' atot ame'”, xchi. Laj yal uc: “Ja' ti much'u chopol chc'opoj yu'un stot sme', ta me xich' milel”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ti ho'oxuque lec chava'yic ti mu tsotsuc sc'opilal cha'i ti tspas ti muc' ti stot sme'ique. “Ti c'u yepal ti laj jnop ti c'an cac'bote, ja' laj xa cac' sventa smoton Diose, mi xut ti stot sme'e, lec oy ti hech tspasique”, xachiic ti ho'oxuque. Ti much'u hech tspase, ho'oxuc chavalbeic ti mu persauc tscolta stot sme' mi jutuc. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Hech chach'aybeic smantal ti Diose scoj ti chach'umbeic sc'op ti antiguo jtatamoltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jlo'lavanejoxuc. Melel ti hech ac'opilalic ts'ibabil yu'un ti Isaíase, ja' ti j'alc'op yu'un ti Diose. Hech laj sts'iba: ");
INSERT INTO tzoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Hovil ti chispasucun ti muc' ti sc'opic ti achi'iltac li'to, mu teucun ti yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Sc'op no'ox crixchanoetic xchi'uc smantal no'ox crixchanoetic ti chaq'uic ti chanele. Mu jc'opuc ti chaq'uic ti chanele, ti xchie. Ja' ac'opilalic obi ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ti Jesuse laj yic' tal ti stojol ti jchi'iltique. Hech laj yalbe: ―A'yo me ava'yic ti c'usi chacalbeique. Ac'o me ti avo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ma'uc chasbolibtasoxuc ti c'utic chave'e. Ja' chasbolibtasoxuc ti c'utic chopol chanope, ti c'utic chopol chavale ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ho'ontutic ti yajchanc'opuntutique ninopejtutic batel ti bu oy ti Jesuse, lic calbetutic: ―¿Mi chana' ti mu xtun cha'yic ti fariseoetique yu'un ti hech laj avalbee? ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Hech itac'av ti Jesuse: ―Ti fariseoetique ja' hech chaj c'u che'el ti vomole, mu'yuc stu. Ti Jtote ti te oy ti vinajele ja' no'ox tsts'un ti c'usi leque. Scotol ti c'usi mu ts'umbiluc yu'un ti Jtote ja' chich' bulel. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mu me xach'umbeic smantal. Ja' hech chaj c'u che'el ma'satetic ti tsc'an chtojobtasvane. Mi jtos ma'satetic xchi'uc ti much'u chtojobtasat yu'un ti ma'sate, jtos chp'ajic yalel ti ch'en ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ti Pedroe hech laj yalbe: ―Albun ca'itutic sjam ti alo'ile ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Hech itac'av ti Jesuse: ―¿Mi yu'un muc xava'ibeic sjam uc ho'oxuque? ―xiyutuntutic―. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Mi mu xavilic ti scotol ti c'utic chave'e, ja' chc'ot ti ach'ut, ja' chatsa' tal loq'uel? ");
INSERT INTO tzoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ti c'utic chopol chavale, ti avo'nton chloc' tal. Ja' chbolibtasvan. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yu'un ti yo'nton crixchanoetic chloc' tal c'usi chopol snopoj, mi milvanej, mi mulivajel, mi tsc'opon ants, mi elec', mi nopc'op, mi nopmulil. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ja' chbolibtasvan ti muliletic avi li'to. Mu xabolib yu'un mu xapoc ac'ob c'alal chave' ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Niloc'tutic batel xchi'uc ti Jesuse. Nibatutic ti slumal Tiro xchi'uc ti slumal Sidón. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Te iloc' tal jun cananea ants. Manchuc mi mu xtun ono'ox chquiltic scotol ti yanlum crixchanoetique ho'ucutic ti judioucutique, ti antse hech laj yavta ti Jesuse: ―Cajval, ho'ot ti yelnich'onot ti Davide ti ac'opilal chatale, c'uxubinun. Ep boliben yu'un pucuj ti jtsebe ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mi jp'eluc muc xtac'av ti Jesuse. Ho'ontutic ti yajchanc'opuntutique hech laj calbetutic vocol ti stojol ti Jesuse: ―Taco sutel ti antse yu'un chists'acliucutic yu'un chijyavtaucutic tal ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ti Jesuse hech lic yalbe ti antse: ―Ja' no'ox tacbilun tal ti sventa ti jchi'iltaque, ho'ontutic ti yelnich'onuntutic ti Israele, yu'un ch'ayemic hech chaj c'u che'el carneroetic ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Inopej tal ti antse, tal squejan sba ti stojol ti Jesuse. ―Avocoluc coltaun me, tote ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Hech itac'av ti Jesuse: ―Mu xtun mi ti jpojbetic yot ti col jnich'ontique yu'un ti jtembetic yu'un ac'o sve' ti ts'i'etique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hech itac'av ti antse: ―Melel ava'uc, tote. Pero ho'oni hech chaj c'u che'el ts'i'. Ti achi'iltaque hech chaj c'u che'el olol. C'alal chve' ti olole, oy xch'uch'elal vaj chp'aj yalel ti yolon smesa. Ja' stac' sve' ti ts'i'etique. Ja' no'ox hechun ti ho'one, ac'bun jutuc ti bendicione ―xchi ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ti Jesuse hech laj yalbe: ―Ep xch'unojel avo'nton chquil, me'e. Hech yu'un ac'o c'otuc ti pasel ti c'usi chac'ane ―xut. Ti ora iloc' ti pucuje ti yo'nton ti stsebe. Lec xa icom. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Niloc'tutic batel xchi'uc ti Jesuse. Nixanavtutic batel ti ti'ti'nab ti te oy ti estado Galilea. Nimututic batel ti vits. Te ba naclucuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ep ti jchi'iltique ital ti stojol ti Jesuse yic'ojic tal mecanetic xchi'uc ma'satetic xchi'uc uma'etic xchi'uc much'utic mu xtun ti sc'obe xchi'uc ep yan jchameletic. Hul smetsanic ti stojol ti Jesuse. Icol yu'un scotol ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hech yu'un ich'ay yo'ntonic ti jchi'iltique c'alal laj yilic ic'opoj ti much'u uma' ono'oxe, ilecub sc'ob ti much'u mu xtun ti sc'obe, ixanav ti much'u mecan ono'oxe, laj sq'uel balumil ti much'u ma'sat ono'oxe. Lec sc'opilal ibat yu'unic ti Dios cu'untique, ho'ucutic ti israelucutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ti Jesuse laj yic'untutic ti stojol, ho'ontutic ti yajchanc'opuntutique. Hech laj yalbuntutic: ―C'ux ti co'nton ti jchi'iltique yu'un yoxibal c'ac'al xa ti li' jchi'inojtique, mu'yuc xa sve'elic. Mu jc'an ti chipan sbaic batele naca me altsajuc ti be ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ho'ontutic hech laj calbetutic: ―Yu'un xocol balumil li'to mu jtatutic ti caxlan vaje yu'un ti jmac'lintutic ti ho'ontutique. Ep ti jyalel ti jchi'iltique ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ti Jesuse hech laj sjac'buntutic: ―¿Jayib muc'tic caxlan vaj avich'ojic? ―xiyutuntutic. Hech nitac'avtutic: ―Quich'ojtutic hucub muc'tic caxlan vaj xchi'uc cha'cot oxcot biq'uit choy ―xichitutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ti Jesuse laj spas ti mantal ti jchi'iltique yu'un ac'o nacluc. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Laj stsac ti hucub muc'tic caxlan vaje xchi'uc ti choye, laj yalbe vocol ti Diose. Laj xet'ilan ti caxlan vaje, laj stuch'ilan ti choye, laj yac'buntutic. Ho'ontutic ba cac'betutic ti jchi'iltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Scotolic ive'ic, inoj xch'utic. Patil laj jtsobtutic tal ti xet'elal ti caxlan vaje xchi'uc ti sobril choye ti te comene. Inoj hucub almud ti sobril ti caxlan vaj ti laj sve'ique xchi'uc ti sobril choye. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Chanmil ti viniquetique ti ive'ique. Mu atabiluc ti antsetique xchi'uc ti ololetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ti Jesuse laj sc'opon comel ti jchi'iltique hech ni'ochtutic ti barco xchi'uc, hech nibatutic ti slumal Magdala. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ital cha'vo' oxvo' ti fariseoetique xchi'uc ti saduceoetique. Sc'an spasbeic proval yo'nton ti Jesuse. ―Paso me señail ti vinajel yu'un ti jq'ueltutic yu'un hech ti jna'tutic ti tsots avabtel ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Itac'av ti Jesuse, hech laj yalbe: ―C'alal chmal ti c'ac'ale, hech chavalic: “Yu'un tsoj ti vinajele, q'uepel osil oc'om”, xachiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ti sob ic'luman chavalic: “Tsoj ti vinajele. Ja' chtal ho'. Macal ti osile”, xachiic. Chana' chaq'uelic señail ti vinajel. Mu xana' xaq'uelic ti yac'oj sba chc'ot xa ti pasel li' ti balumile ti ora to. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tsc'an tsq'uelic señail ti much'utic chopol yo'ntonique xchi'uc ti much'utic laj xa scomesic ti Diose. Mu xa x'ac'batic sq'uelic yan. Ja' no'ox ch-ac'batic sq'uelic hech chaj c'u che'el ic'ot ti pasel yu'un ti Jonase, ja' ti j'alc'op yu'un ti Diose ―xut. Hech laj scomes ti Jesuse, hech niloc'tutic batel xchi'uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nibatutic xchi'uc ti Jesuse lum ti jech nab. Ho'ontutic ti yajchanc'opuntutique muc jna' chquich'tutic batel caxlan vaj. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ti Jesuse hech laj yalbuntutic: ―P'ijanic me. Mu xtun ti spumesbil xch'ut caxlan vaj yu'un ti fariseoetique xchi'uc ti saduceoetique ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Hech laj calbe jbatutic: ―Ja' van chal yu'un muc xquich'tic tal ti caxlan vaj cu'untique ―xcut jbatutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Laj sna' ti Jesuse ti hech laj calbe jbatutique. Hech laj yalbuntutic: ―¿C'u yu'un ti hech chlo'laj avo'ntonic yu'un muc xavich'ic tal ti caxlan vaj cu'untique? Mu'yuc lec xch'unojel avo'ntonic xquil. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mu to chach'unic ti xu' cu'un. ¿Mi yu'un ich'ay xa ti avo'ntonic ti ho'ob caxlan vaj ti itun yu'un ti ho'mil viniquetique xchi'uc ti ep almud sobril ti laj atsobique? ");
INSERT INTO tzoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Mi ichay xa uc ti avo'ntonic ti hucub caxlan vaje ti itun yu'un ti chanmil viniquetique xchi'uc ti ep almud sobril ti laj atsobique? ");
INSERT INTO tzoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Muc xava'ibeic sjam ti ma'uc sc'opilal ti caxlan vaje ti laj calboxuque. P'ijanic me, mu xtun ti spumesbil xch'ut caxlan vaje yu'un ti fariseoetique xchi'uc ti saduceoetique, xacutic ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hech laj ca'ibetutic sjam ti ma'uc laj yalbuntutic sc'opilal ti spumesbil xch'ut ti mero caxlan vaje. Ja' laj yalbuntutic ti mu me jch'untutic ti c'op ti chac' ti chanel ti fariseoetique xchi'uc ti saduceoetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","C'alal nic'otutic ti slumal Cesarea yu'un Filipo xchi'uc ti Jesuse, hech laj sjac'buntutic ti Jesuse: ―¿C'usi cabtel chalic ti jchi'iltique, ho'on ti co'ol crixchanoucutique? ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hech nitac'avtutic: ―Oy chalic ti ho'ot Juanot, ja' ti laj yac' ich'ho'e. Oy chalic ti Elíasot. Oy chalic ti Jeremíasot. Oy chalic ti ho'ot j'alc'opot uc yu'un ti Diose ―xichitutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ti Jesuse hech laj sjac'buntutic: ―Ho'oxuque ¿much'uun chacuyic? ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Hech itac'av ti Simon Pedroe: ―Ho'ot ti Cristoote, ho'ot t'ujbilot yu'un ti Diose yu'un chacoltauntutic. Ho'ot Snich'onot ti Diose ti stalel cuxule ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ti Jesuse hech laj yalbe: ―Avich'oj bendición, Simón, snich'onot ti Jonase, yu'un ma'uc albilot ti avo'nton yu'un ti much'u co'ol ach'ich'el abec'talic xchi'uc. Ja' albilot ti avo'nton yu'un ti Jtote ti te oy ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Chacalbe uc. Ho'ot Pedroot, ho'ot ti aventa chlic jtsob ti much'utic chixch'umbun ti jc'ope. Persa chc'ot ti pasel scotol lume. Manchuc mi tsc'an tstup' ti pucuje, mu xu' yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Chacac'be tsots avabtel yu'un chavalbe ti crixchanoetique ti c'usi tspasique yu'un hech chventaimbat yo'ntonic yu'un ti Diose. Yu'un chavalbe ti c'usi mu xtun tspasique, yu'un hech ono'ox yaloj ti Diose. Yu'un chavalbe ti c'usi lec tspasique yu'un hech ono'ox yaloj ti Diose ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Hech laj spasuntutic ti mantal ti Jesuse: ―Mu to me much'u chavalbeic ti ho'on t'ujbilun yu'un ti Diose yu'un chajcoltaoxuc ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ti Jesuse hech lic yalbuntutic ho'ontutic ti yajchanc'opuntutique: ―Persa chibat ti Jerusalén yu'un persa te chc'ot quich' vocol. Chiyac'ucun ti sc'ob ti moletique xchi'uc ti sc'ob ti totil paleetique xchi'uc ti sc'ob ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Te chismilucun. Chicham. Patil ti yoxibal c'ac'al chicha'cusesat loq'uel ti ch'en ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ti Pedroe laj sq'uej sbaic xchi'uc ti Jesuse jutuc, hech lic yalbe: ―Cajval, ac'o xc'uxubinot ti Diose, mu me xac' c'otuc ti pasel hech ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ti Jesuse laj sjoyp'in sba, hech laj sc'opon ti Pedroe: ―Satanás, loc'an batel ti jtojol. Chac'an chabolibtasun. Ma'uc chanop c'usi tsc'an ti Diose. Ja' no'ox chanop hech chaj c'u che'el tsnop crixchanoetic ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ti Jesuse hech laj yalbuntutic: ―Ti much'u tsc'an chists'acliune, mu me xc'uxubin sba, ac'o cuchuc yu'un ti vocole hech chaj c'u che'el ti jcuch ho'oni, ac'o sts'acliun. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yu'un scotol ti much'u chc'uxubin sbae, ja' chch'ay. Scotol ti much'u mu xc'uxubin sbae, ho'on ti jventa, ja' chcuxi. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Manchuc mi ihu' avu'un laj avu'unin scotol ti c'utic oy li' ti balumile, mi mu xacuxi sbatel osil, hovil. Ja' tsots sc'opilal ti chacuxi sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yu'un ho'on ti co'ol crixchanoucutique chital quich'oj jqueval hech chaj c'u che'el squeval ti Jtote. Ti jchi'in tal ti ch'ul abatetic cu'une. Ja' chtal cac'be stojol jujun crixchano mi lec ti c'usi laj spasique, mi mu lecuc ti c'usi laj spasique. ");
INSERT INTO tzoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Melel ti c'usi chacalbeique, ho'oxuc ti li' va'aloxuc li'to oy mu to chachamic ja'to mi laj avilic ti oy chlic jventaimbe yo'ntonic crixchanoetic ho'on ti co'ol crixchanoucutique ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","C'alal i'ech' xa vaquib c'ac'al, ti Jesuse laj yic' batel ti yan parte ti Pedroe xchi'uc ti Jacoboe xchi'uc ti Juane. ja' ti yits'in ti Jacoboe. Imuic ti jol vits. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ti Jesuse te laj sc'atajes sba ti stojolic. Laj yac' squeval ti sate hech chaj c'u che'el chac' squeval ti c'ac'ale. Iquevan scotol sc'u'. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Te laj yac' sba iluc ti Moisese xchi'uc ti Elíase. Te ilo'lajic xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ti Pedroe hech laj yalbe ti Jesuse: ―Cajval, ja' lec ti li'ucutic no'oxe. Mi chac'ane ti jpas oxib nailvomol li'i, jun avu'un, jun yu'un Moisés, jun yu'un Elías ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","C'alal yac'oj sba chc'opoj ti Pedroe, ital toc, imacatic scotolic. Oy squeval ti toque. C'alal but'ibilic ti toc, hech ic'opoj ti Diose: ―Ja' Jnich'on li'to, ja' ti lum c'ux ti co'ntone. Nichim no'ox co'nton yu'un. A'ibo sc'op ―xchi c'alal te oy ti toque. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","C'alal laj ya'yic ti jchi'iltac ti abtele laj spatan sbaic ti lum. Toj xi'el ic'otic. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ti Jesuse laj stij liquel. Hech laj yalbe: ―Licanic, mu me xaxi'ic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","C'alal laj sq'uelic muel, mu'yuc xa much'u laj yilic, ja' no'ox stuc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","C'alal yac'oj sba chyalic tal ti vits hech ipasatic ti mantal yu'un ti Jesuse: ―Ti c'u che'el laj avilique, mu to me xavalic ja'to mi nicha'cuxi loq'uel ti ch'en ho'on ti co'ol crixchanoucutique ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ho'ontutic ti yajchanc'opuntutique hech laj jac'betutic ti Jesuse: ―¿C'u yu'un hech chalic ti much'utic chchanubtasvanic ti smantal ti Diose ti persa ja' jbael chtal ti Elíase? ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Hech itac'av ti Jesuse: ―Melel ti ja' jbael chtal ti Elíase. Scotol chtal smeltsan. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Chacalbeic uc, ital xa ti Elíase, muc xojtiquinic. Ja' laj spasic ti c'usi sc'an ti yo'ntonic ti crixchanoetique ti chopol tspasique. Hech ono'ox uc ch-ech' jvocol ti sc'obic uc ho'on ti co'ol crixchanoucutic uque ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hech laj jna'tutic ti ja' sc'opilal ti Juane ti ital xae, ja' ti laj yac' ich'ho'e. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","C'alal nic'otutic ti bu stsoboj sbaic ti jchi'iltique, te oy jun jchi'iltic tal squejan sba ti stojol ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Hech laj yalbe: ―Tote, c'uxubimbun ti jnich'one yu'un tsacbil ti tup' ic'. Ep chich' vocol. Ep vuelta ip'aj xa ti ho'. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Laj quic' tal ti stojol ti avajchanc'opetique, muc xu' yu'unic xiscoltabucun ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Hech yu'un hech lic yalbuntutic ti Jesuse: ―Mu'yuc xch'unojel avo'ntonic chquil. Boliben avo'ntonic ho'oxuc ti li'oyoxuc li' ti balumil ti ora to. Ep xa c'ac'al li' jchi'inojoxuc, mu to chach'unic. Ep xa c'ac'al jts'icojboxuc sbolil avo'ntonic acotolic ―xiyutuntutic―. Ic'o tal ti jtojol ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ti Jesuse laj spas ti mantal ti pucuje, iloc' tal ti yo'nton ti quereme. Ti ora icol ti quereme. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ho'ontutic ti yajchanc'opuntutique patil laj jac'betutic ti Jesuse: ―¿C'u yu'un muc xu' cu'untutic jloq'uestutic ti pucuje? ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Hech itac'av ti Jesuse: ―Yu'un mu'yuc lec xch'unojel avo'ntonic. Melel ti c'usi chacalbeique, mi tsta hech yepal xch'unojel avo'ntonic hech chaj c'u che'el jp'ej sat mostazate' ti biq'uite, chc'ot ti pasel avu'unic ti c'usi vocol ti pasel ti mu' xu' avu'unic atuquic. Hech chaj c'u che'el mi chavale: “Ac'o batuc ti vits lum toi”, mi xachiique, ta me xc'ot ti pasel avu'unic. Scotol xu' chapasic mi tsta hech yepal xch'unojel avo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ja'to mi laj ac'oponic Dios, ja'to mi laj avipan abaic, ja'to chloc' ti jtos pucujetic li'to ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","C'alal te oyuntutic ti Galilea xchi'uc ti Jesuse hech laj yalbuntutic: ―Chi'ac'at entrecal ti sc'ob viniquetic ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Chimilat, chicham, patil ti yoxibal c'ac'al chicha'cusesat loq'uel ti ch'en ―xiyutuntutic. C'alal hech laj ca'itutic, ep laj quich'tutic mul. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","C'alal nic'otutic ti jteclum Capernaum, tal sc'oponic ti Pedroe ti much'utic yac'oj sba tstsobic ti taq'uin chtun yu'un ti temploe. Chib dracmataq'uin tsc'anic. Hech tal sjac'bel: ―¿Mi chac' ti taq'uine yu'un ti temploe ti maestro avu'unique? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","―Chac' ―xchi ti Pedroe. I'och batel ti yut na ti Pedroe. Ti ora lic jac'batuc yu'un ti Jesuse: ―¿C'usi xchi avo'nton, Simón? Ti totil ajvaliletic li' ti balumile, ¿mi ja' tsc'ambe ti snich'one ti tstoj ti patan, mi tsc'ambe yan crixchanoetic? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Hech itac'av ti Pedroe: ―Ja' tsc'ambe ti yan crixchanoetique ―xchi. Ti Jesuse hech laj yalbe: ―Ti yol snich'onique ja' libre. Hech yu'un ti ho'one mu persauc ti jtoj. ");
INSERT INTO tzoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero yu'un mu me xbolib yo'ntonic cu'un, batan ti nab, teno ochel ti agancho. Ti choy ti jbael chatsac loq'uel tal, jambo ye. Te chata jun estaterotaq'uin. Ich'o tal, ac'bo. Ja' jtaq'uintic jcha'va'altic ti chavaq'ue ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ho'ontutic ti yajchanc'opuntutic ti Jesuse hech laj jac'betutic. ―¿Much'u más tsots yabtel chich' c'alal tsta yorail tspas mantal li'i ti Diose? ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ti Jesuse laj yic' tal ti stojol jun olol. Laj sva'an ti o'lol yo' bu oyuntutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Hech laj yalbuntutic: ―Melel ti c'usi chacalbeique, mi mu xac'ot hech chaj c'u che'el olol, mu xu' chac'ot te o yo' bu tspas mantal ti Diose ti c'alal tsta yorail yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Scotol ti much'u mu stoy sbae, ti biq'uit chac' sba hech chaj c'u che'el ti olol li'to, ja' más tsots yabtel chich' c'alal tsta yorail tspas mantal li'i ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Scotol ti much'u tspas ti muc' jun olol hech chaj c'u che'el olol avi to ho'on ti jventa, ho'on chispasun ti muc' uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Ti much'u tsbolibtasbe yo'nton junuc ti ololetic li'to ti xch'unoj ti ho'on Jcoltavanejun yu'une, ja' lec ac'o chucbatuc ti snuc' cho' ac'o tenatuc ochel ti nab. Te chch'ay batel ti nab. Te tsjic' ti ho'e. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Uts abaic ho'oxuc ti li'oyoxuc ti balumile yu'un ep ti c'usi tsc'an chasbolibtasoxuque. Ta ono'ox xava'yic ti tsc'an chasbolibtasoxuque. Pero uts sbaic ti much'utic hech chbolibtasvane. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Hech yu'un mi chasbolibtasot ti ac'obe, mi avacane, ja' tsc'an ti mu'yuc ac'ob o avacan hech chaj c'u che'el ti much'u mu'yuc sc'obe o mu'yuc yacane, hech cha'och ti utsilal. Ja' vocol mi chabatic ti c'atimbac yu'un ti mu xapajes abaique. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ja' no'ox hech uc mi chasbolibtasot ti c'u che'el chaq'uele, mu lecuc. Hech yu'un ja' tsc'an ti mu'yuc c'usi chaq'uel hech chaj c'u che'el ti much'u mu xc'ot sate, hech cha'och ti utsilal. Ja' vocol mi chabatic ti c'atimbac yu'un ti mu xapajes abaique. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’P'ijanic me, mu me biq'uituc chavil junuc ti ololetic li'to. Melel ti c'usi chacalbeique, te ti vinajel ti ch'ul abatetic ti chchabiat ti ololetique, ja' te oyic o ti stojol ti Jtote ti te oy ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ja' yu'un ti nitale ho'on ti co'ol crixchanoucutique yu'un tal jcoltaoxuc acotolic yu'un ti ch'ayemoxuque. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿C'usi xchi avo'ntonic? Ti much'u oy yu'un ho'vinic ti cot scarnero, mi ich'ay comel yu'un jcot, ¿mi mu scomes ti yan noventa y nueve ti cote yu'un chba sa' tal ti jcot ti ich'ay yu'une? ");
INSERT INTO tzoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Chich' mul yu'un mu ts'acaluc ti scarneroe. Melel ti c'usi chacalbeique, c'alal mi laj sta xa ti jcote, más nichim no'ox yo'nton. Yu'un mi jcotuc muc xch'ay ti scarneroe. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hech ono'ox uc mu sc'an ti Jtote ti te oy ti vinajele mi chch'ay junuc avi ololetic li'to. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Mi oy smul avu'un ti avermanoe, batan, ba chapano xchi'uc acha'va'alic no'ox. Mi chaspasbot ti muc' ac'ope, hech nichim no'ox avo'nton xchi'uc avermano obi. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mi mu xaspasbot ti muc' ti ac'ope, ic'o batel cha'vo' oxvo' achi'il, yu'un hech cha'vo' oxvo' rextico chc'ot ti jayp'el chavale. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mi mu spasbatic ti muc' sc'opic uc, albo scotol ti jch'unojeletique. Mi mu spasbat ti muc' sc'op scotol ti jch'unojeletique, hech ac'o c'otuc avu'un hech chaj c'u che'el yanlum vinic, hech chaj c'u che'el jtsobpatan ti mu xch'unojbuc sc'op ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Melel ti c'usi chacalbeique, yu'un chavalbe ti c'usi mu xtun tspasique, yu'un hech ono'ox yaloj ti Diose. Yu'un chavalbe ti c'usi lec tspasique, yu'un hech ono'ox yaloj ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Yan vuelta hech chacalbeic, mi jtos avo'ntonic cha'vo'oxuc li' ti balumile ti chac'ambeic ti stojol ti Diose ti c'uc no'ox chac'anique, ja' chayac'boxuc ti Jtote ti te oy ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yu'un mi oy stsoboj sbaic cha'vo' oxvo' ti jventa, te oyun ti o'lol yo' bu oyique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ti Pedroe lic sc'opon ti Jesuse, hech laj sjac'be: ―Cajval, ¿jayib vuelta sc'an ti jpasbe perdón ti much'u tstailan smul ti jtojole? ¿Mi ta yutsil hucub vuelta? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Hech itac'av ti Jesuse: ―Chacalbe, mu tauc yutsil ti hucub no'ox vuelta. Mu atabiluc ti chapasbe perdón. Ja' scotol c'ac'al chapasbe perdón. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Hech yu'un chacalbeic ti c'utic x'elan tspasvan ti mantal ti Diose. Hech yu'un chacalbe hech chaj c'u che'el jun ajvalil ti tsc'an yu'un ac'o sutesbatuc ti staq'uine yu'un ti yabate. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Laj scajtusbe yil. Patil laj yic' tal ti stojol ti much'u oy lajunmil yil yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mu xu' stoj ti yile hech yu'un laj yal mantal ti yajvale ti ac'o chonatuc xchi'uc yajnil xchi'uc xnich'nab xchi'uc scotol ti c'usi oy yu'une yu'un hech chtoj ti yile. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hech yu'un ti abate laj squejan sba ti stojol ti yajvale. Ep laj yalbe vocol: “Avocoluc me, Cajval, malabun to. Chajtojbe scotol”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Hech ti ajvalile laj xc'uxubin ti yabate, laj scolta batel, laj xch'aybe ti yile. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","C'alal iloc' batel ti yabate, laj snup ti be ti much'u oy ho'vinic yil yu'une ti ja' ono'ox xchi'il ti abtele. Laj stsac, hech laj yalbe: “Tojbun ti avile”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hech ti much'u co'ol yabtel xchi'uque laj squejan sba ti stojol, hech laj yalbe vocol: “Avocoluc me, malabun to. Chajtojbe scotol”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Muc sc'an smala. Ba stic' ti chuquel. “Ja'to mi laj stojbun ti yile ja'to chacoltabun loq'uel tal”, xchi ti yajval ti taq'uine. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ti xchi'iltac ti abtele c'alal laj yilic ti hech ic'ot ti pasele, ep laj yich'ic mul. Ba yalbeic ti yajvale scotol ti hech ic'ot ti pasele. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hech yu'un i'ic'at talel yu'un ti yajvale. Hech hul albatuc: “Chopol avo'nton chca'i. Scotol laj jch'aybot avil yu'un laj ac'ambun vocol ti jtojol. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ja' lec ti lajuc ac'uxubin ti achi'ile hech chaj c'u che'el ti laj jc'uxubinote”, x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Hech yu'un ti yajvale i'ilin ti stojol. Laj yac' ti sc'ob ti jchucvanejetique. “Ja'to mi laj stojbun scotol ti yile ja'to chacoltabun loq'uel tal”, xchi ti ajvalile. ");
INSERT INTO tzoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Hech ono'ox uc chaxcha'ac'boxuc atojic jujunoxuc ti Jtote ti te oy ti vinajele mi mu j'ech'eluc chach'ay ti avo'ntonic ti smul ti avermanoe ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","C'alal laj yo'nton laj sc'oponuntutic ti Jesuse, ho'ontutic ti yajchanc'opuntutique, niloc'tutic batel ti Galilea xchi'uc. Nijelavtutic batel ti jech uc'um Jordán, nixanavtutic batel yu'un chibatutic ti estado Judea xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Laj sts'acliuntutic batel ep jchi'iltic xchi'uc jchameletic. Laj scolta comel ti jchameletique ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ital cha'vo' oxvo' ti fariseoetique yu'un sc'an spasbeic proval yo'nton ti Jesuse. Hech tal sjac'beic: ―¿Mi stac' ti jsutes cajniltutic ti c'uc no'ox tspase? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Hech itac'av ti Jesuse: ―Aq'uelojic ti sc'op ti Diose ti bu chal ti c'alal ipasat ti sba crixchanoe, jun vinic jun ants ipasat. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hech chal uc ti sc'op ti Diose: “Hech yu'un ti viniquetique tscomes stot sme', chic' yajnil. Jun no'ox chc'ot xchi'uc ti yajnile”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hech yu'un mu cha'vo'uc icom yu'un jun no'ox ic'otic. Hech yu'un ti much'utic jun no'ox ic'otic yu'un ti Diose mu me sp'ev sbaic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lic sjac'beic yan vuelta: ―¿C'u yu'un hech laj yal mantal ti Moisese: “Scotol ti much'u tsutes ti yajnile, ac'o sp'ejan ti jun ac'o yac'be ti yajnile ti c'usi sventailuc ti tsutese”, ti xchie? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Hech itac'av ti Jesuse: ―Scoj ti tsots yo'ntonic hech yu'un ti hech i'ac'bat lisensa yu'un ti Moisese ti tsutes ti yajnilique. Mu hechuc ti sliqueb ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Chacalbeic, scotol ti much'u tsutes ti yajnile, mi mu scojuc ti imulav ti yajnile ti tsutese, mi chic' yan ants ja' chmulivaj obi. Scotol ti much'u chic' yu'un chajnilin ti much'u sutesbil yu'un ti smalale, ja' chmulav chc'ot ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ho'ontutic ti yajchanc'opuntutique hech laj calbetutic ti Jesuse: ―Mi hech oy sc'opilal ti much'u oy yajnile, ja' lec ti mu xquic' jbatutic xchi'uc ants ―xichitutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ti Jesuse hech laj yalbuntutic: ―Mu scotoluc xu' yu'unic chch'unic ti mu xic' sbaic xchi'uc ants. Ja' no'ox chch'un ti much'u tsnop ti hech tsc'an ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Oy viniquetic eunucoetic sbiic. C'alal i'an hech ti ora to mu sc'an chic' sbaic xchi'uc ants. Oy viniquetic uc ti ipasat ti eunuco yu'un yan viniquetic. Oy viniquetic mu xic' sbaic xchi'uc ants yu'un hech más xu' chtun yu'un ti Diose. Ti much'u tsnopic ti hech tsc'an ti Diose, ac'o spas ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","I'ic'at talel ti stojol ti Jesuse ololetic yu'un chac' sc'ob ti Jesuse, chac'be ti sjol ti ololetique, yu'un tsc'opombe Dios ti stojol ti ololetique. Ti ho'ontutique ti yajchanc'opuntutique jc'an jpajestutic ti jchi'iltique. Tsots laj calbetutic mantal yu'un ti jpajestutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ti Jesuse hech laj yalbuntutic: ―Ac'o taluc ti jtojol ti ololetique. Mu me xapajesic yu'un ti much'utic chventaimbat yo'ntonic yu'un ti Diose, ja' hech chc'otic hech chaj c'u che'el olol ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ti Jesuse laj yac' sc'ob, laj yac'be ti sjol ti ololetique. Patil niloc'tutic batel xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Oy jun jchi'iltic tal sc'opon ti Jesuse. ―Maestro, ho'ot lequil vinicot. ¿C'usi lequil abtelal ti jpas yu'un hech chicuxi sbatel osil? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Itac'av ti Jesuse, hech laj yalbe: ―¿C'u yu'un lequil vinicot xavutun? Mi junuc mu'yuc much'u lec, ja' no'ox stuc ti Diose. Mi chac'an chacuxi sbatel osil, ch'uno me ti mantaletique ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Hech laj sjac' ti vinique: ―¿C'usi mantalil? ―xchi. Hech itac'av ti Jesuse: ―Mu me xamilvan. Mu me xamulivaj. Mu me xa'elc'aj. Mu me xanopbe smul avecino. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Paso me ti muc' atot ame'. C'ux me xava'i avecino hech chaj c'u che'el c'ux chava'i aba, ti xchie ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Unen to ti vinique. Hech laj yalbe ti Jesuse: ―Scotol avi to jch'unoj c'alal nich'i tal. ¿C'usi xa sc'an ti mu jch'une? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Hech itac'av ti Jesuse: ―Mi chac'an ti mu'yuc apalta chayil ti Diose, batan, ba chono scotol ti c'usi oy avu'une, q'uelambo ti me'onetique. Hech oy ac'ulejal ti vinajel chc'ot. Patil chtal ats'acliun batel ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","C'alal laj ya'i ti unen vinique, isut batel. Laj yich' mul yu'un ep ti sc'ulejal li' ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ti Jesuse hech laj yalbuntutic ho'ontutic ti yajchanc'opuntutique: ―Melel ti c'usi chacalbeique, ti much'u jc'uleje vocol chac' sba ti ventainel yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Chacalbeic uc ti hech chaj c'u che'el mu xjelav jcot camello ti xchac acuxa, ja' no'ox hech uc ti much'u jc'uleje mu xu' chac' sba ti ventainel yu'un ti Diose ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ich'ay co'ntontutic c'alal hech laj ca'itutic. ―¿Much'u cac'tic xu' chcol che'e? ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ti Jesuse laj sq'uelbun jsatutic. Hech laj yalbuntutic: ―Ti crixchanoetique mu xu' scolta sba stuc. Ti Diose scotol xu' yu'un tspas stuc ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ti Pedroe hech laj yalbe ti Jesuse: ―Ho'ontutique scotol laj xa jcomestutic. Laj xa jts'acliotutic. ¿C'u x'elan chic'otutic ho'oni? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ti Jesuse hech laj yalbuntutic: ―Melel ti c'usi chacalbeique, ti c'alal tsta yorail ti jlecubtas ti balumile, chc'ot naclucun ti jmuc'ta naclebe yu'un ti jpas ti mantal scotolic, ho'on ti co'ol crixchanoucutique. Te chispasucun ti muc' scotol ti crixchanoetique. Ho'oxuque yu'un laj xa ats'acliucun, chc'ot naclanic uc ti lajcheb muc'tic naclebaltic yu'un chapas ti mantal ti lajchachop ti jchi'iltique, ho'ucutic ti yelnich'onucutic ti Israele. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Scotol ti much'u laj xa scomes mi sna, mi sbanquiltac, mi yits'inabtac, mi svixobtac, mi yixleltac, mi stot sme', mi yajnil, mi yol xnich'nab, mi slum, ho'on ti jventa, ho'vinic vuelta ch-epaj xq'uexol ti chcac'bee. Chcac'be yich' uc xcuxlejal sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Scotol ti much'utic hech tsnop ti yo'nton ho'on jbaejbeun, mi xchi tsnop, ja' patil ti yantique, mi xchi, ja' patil chc'otic lume. Ja' jbael chc'otic scotol ti much'utic mu hechuc tsnopique. Ja' ep ti much'utic patil chc'otique ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Hech laj yalbuntutic uc ti Jesuse: ―Hech yu'un chacalbeic ti c'utic x'elan tspasvan ti mantal ti Diose. Hech yu'un chacalbe hech chaj c'u che'el jun vinic ti oy slume. Sob ic'luman iloc' batel, ba sa' yaj'abtel yu'un chba abtejuc ti bu sts'unoj uvate'. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Laj spas trato xchi'uc ti yaj'abtele ti jun denariotaq'uin tstoj ti jun c'ac'ale. Laj stac batel ti bu ti yabtele te ti bu sts'unoj ti uvate'e. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","C'alal laj sta baluneb ora iloc' batel yan vuelta ti yajval ti abtele. Laj yil oy much'utic te va'ajtic ti plaza, mu'yuc yabtelic. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Hech yu'un hech laj yalbe: “Batanic ti cabtel ti bu jts'unoj uvate'. Lec atojolic chacac'boxuc”, xut. Hech laj xch'unic, hech ibatic ti abtel. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yan chib vuelta iloc' batel ti yajval ti abtele. Ba sa' yaj'abtel. Ba sa' ti o'lol c'ac'al uc. Ba sa' ti oxib ora mal c'ac'al uc. Co'ol ono'ox laj spas ti jujun vueltae. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","C'alal laj sta ho'ob ora mal c'ac'al, iloc' batel yan vuelta. Te laj sta yantic, mu'yuc yabtelic uc. Hech laj sjac'be: “¿C'u yu'un li' va'aloxuque sjunul c'ac'al?” xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Hech itac'avic: “Yu'un mu'yuc much'u laj yic'untutic ti abtel”, xchiic. Hech laj yalbe: “Batanic ti cabtel ti bu ts'umbil ti uvate' cu'une. Lec atojolic chacac'boxuc”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","C'alal imal xa ti c'ac'ale ti yajval ti abtele hech laj yalbe ti smayordomoe: “Ic'o talel ti j'abteletic cu'une. Ac'bo stojol yabtelic. Ja' jbael chatoj ti much'u patil italique. Patil chatoj ti much'u jbael italique”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","C'alal italic ti much'utic laj stsac yabtelic ti ho'ob ora mal c'ac'al, jujun denariotaq'uin i'ac'batic jujun. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","C'alal italic ti much'utic jbael laj stsac yabtelique, laj scuyic ti más ep stojol ch-ac'batic ti stuquique. Co'ol ono'ox uc jujun denariotaq'uin i'ac'batic jujun. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","C'alal laj yich' ti stojolique, mu xtun laj yilic ti c'usi laj spas ti yajval ti abtele. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Hech lic yalbeic: “Jun no'ox ora i'abtejic ti much'utic patil italique. Co'ol laj atojuntutic xchi'uc ti much'u patil italique. Ho'ontutique laj xa ca'ibetutic sc'uxul ti c'ac'ale. Nilubtutic xa ti abtel”, xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hech lic tac'avuc ti yajval ti abtele: “Quits'in, mu chopoluc ti c'usi laj jpasboxuque. Hech laj jpastic trato ti jun no'ox denariotaq'uin chajtojic jujunoxuque. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ich'o batel atojolic, batanic. Yutsil co'nton ti co'ol chajtojic acotolic xchi'uc ti much'utic patil italique. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ti c'usi sc'an ti co'ntone stac' ti jpas xchi'uc ti c'usi oy cu'une. Mu me chopoluc avo'ntonic yu'un ti c'usi lec laj jpase”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Hech chaj c'u che'el ic'ot ti pasel xchi'uc ti yaj'abtele, ja' no'ox hech chc'ot ti pasel xchi'uc ti much'utic ch-abtej cu'une li' ti balumile. Scotol ti much'utic hech tsnop ti yo'nton ho'on jbaejbeun, mi xchi tsnop, ja' patil ti yantique, mi xchi, ja' patil chc'otic lume. Ja' jbael chc'otic scotol ti much'utic mu hechuc tsnopique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","C'alal cac'oj jbatutic chimututic batel ti Jerusalén xchi'uc ti Jesuse, c'alal te oyuntutic ti be, laj jq'uej jbatutic jutuc xchi'uc ti Jesuse, ho'ontutic ti yajchanc'opuntutique, ti lajchavo'untutique. Hech laj yalbuntutic ti Jesuse: ");
INSERT INTO tzoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Ta xa xijc'ot ti Jerusalén. Ho'on ti co'ol crixchanoucutique te chiyac'ucun entrecal ti sc'ob ti totil paleetique xchi'uc ti sc'ob ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Ja' chixchapambucun jc'opilal yu'un chismilucun. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chi'ac'at entrecal uc ti sc'ob yanlum viniquetic yu'un chquich' labanel, chquich' acial. Patil chismilucun ti cruz. Chicham. Patil ti yoxibal c'ac'al chicha'cusesat loq'uel ti ch'en ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ital ti jchi'il ti abtele, ja' ti xnich'nab ti Zebedeoe. Xchi'inoj talel ti sme'e. Hul squejan sba ti stojol ti Jesuse yu'un oy c'usi tsc'ambe. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ti Jesuse hech laj sjac'be: ―¿C'usi chac'an? ―xut. Hech itac'av ti sme'ique: ―Alo amantal ti c'alal chtal apas mantal, chnaqui jun ti abats'ic'ob, jun ti ats'et ti jqueremetic li'to ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Hech lic yal ti Jesuse: ―Mu xana'ic ti c'usi chac'ambune. ¿Mi xu' avu'unic ti vocol hech chaj c'u che'el chquich' vocol ho'oni? ¿Mi xu' avu'unic ti contrainel hech chaj c'u che'el chquich' contrainel ho'oni? ―xchi. Hech itac'avic: ―Xu' cu'untutic ―xchi xtac'avic xcha'va'alic. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ti Jesuse hech laj yalbe: ―Melel ti c'u che'el chquich' vocol ho'oni ti c'u che'el chquich' contrainel, hech chavich'ic uc. Ho'on mu xu' chacalbe ti chanaquiic jun ti jbats'ic'ob jun ti jts'et. Ja' chal ti Jtote ti much'utic te chnaquiique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ho'ontutic ti lajunvo'untutique mu xtun laj ca'itutic ti c'usi laj yal ti cha'vo' ti jchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Hech yu'un ti Jesuse laj yic'untutic tal ti stojol jcotoltutic ho'ontutic ti yajchanc'opuntutique. Hech laj yalbuntutic: ―Chana'ic c'u x'elan tspasic ti ajvaliletic yu'un yanlum viniquetic. Chac' sbaic ti pasel ti muc'. Ti totiletic yu'unique ja' tsujvanic ti abtel. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mu me hechuc chapasic ti ho'oxuque. Ti much'u tsc'an ti totil chc'ot avu'unique, ja' chac' sba ti abatinel avu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ti much'u sc'an ti tspasat ti muc' avu'unique, ac'o me yac' sba ti abatinel ti atojolic. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hech me chapasic hech chaj c'u che'el ho'oni ti co'ol crixchanoucutique. Yu'un ho'oni ma'uc nital yu'un chi'abatinvan. Ja' tal cac' jba ti abatinel. Tal cac' jba ti milel sventa scolel scotol crixchanoetic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","C'alal niloc'tutic batel ti jteclum Jericó xchi'uc ti Jesuse, laj sts'acliuntutic batel ep jchi'iltic. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Te nacajtic ti ti'be cha'vo' jchi'iltic, ja' ma'satetic. C'alal laj ya'yic ti te ch-ech' ti Jesuse, hech laj yavtaic: ―Cajval, ho'ot ti yelnich'onot ti Davide ti ac'opilal chatale, c'uxubinuntutic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ti yan jchi'iltique tsc'an tspajesic. ―Anchan ―xutic. Más no'ox tsots laj yavtaic: ―Cajval, yelnich'onot David, avocoluc me, c'uxubinuntutic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Laj sva'an sba ti Jesuse. Laj yic' talel ti stojol ti ma'satetique. Hech laj sjac'be: ―¿C'usi chac'an chajpasbe? ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Hech itac'avic: ―Avocoluc, Cajval, jambun jsatutic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ic'uxubinvan ti Jesuse hech yu'un laj spicbe satic. Ti ora ijam ti satique. Laj sts'acliic batel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nic'otutic xchi'uc ti Jesuse ti nopol Jerusalén, te ti bu biq'uit jteclum Betfagé sbi. Te oy ti yolon vits Olivatic sbi. Ti Jesuse lic stac batel cha'vo' ti jchi'iltac ti abtele. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Hech laj yalbe: ―Toj chabatic ti biq'uit jteclum lum toi. Te chc'o ataic me'burro. Te chucul xchi'uc yol. Coltao, ic'bun talel. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mi chasjac'boxuc ti yajvale: “¿C'u stu avu'un ti burroe?” mi xayute, “chtun yu'un ti Cajvaltique”, xavut. Ti ora chayac'boxuc talel ―xut ti cha'vo'ique, xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hech ic'ot ti pasel yu'un tsts'aqui sc'op ti j'alc'op yu'un ti Diose. Hech laj yal: ");
INSERT INTO tzoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Albo ti much'utic te nacajtic ti Jerusalene: “Chtal ti ajvalil avu'unique. Biq'uit yac'oj sba. Cajal ti burro chtal. Ja' yol ti j'icatsnom me'burroe”, uto, xchi ti Diose, xchi ti j'alc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ibat ti cha'vo'ique, ba spasic hech chaj c'u che'el ipasatic ti mantal yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Laj yiq'uic tal ti me'burroe xchi'uc ti yole. Laj slambe xchijic ti spat ti xcha'cotolique. Hech yu'un lic scajlebin ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ep jchi'iltic laj sq'uiic xchijic ti be uc. Oy yantic laj sp'asic c'obte'. Laj sq'uiic ti be ti c'obte'e. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ti much'utic jbael ixanavique xchi'uc ti much'utic patil italique, co'ol tsots ic'opojic: ―¡Jpastic ti muc' ti yelnich'on ti Davide ti sc'opilal chtal ochuc ti ajvalile! ¡Jun no'ox yutsil ti itacat xa tal ti jtojoltic yu'un ti Cajvaltic Diose! ¡Ac'o spasic ti muc' ti Diose scotolic te ti vinajel uc! ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","C'alal i'och batel ti Jerusalén ti Jesuse, chvochetic no'ox liquel ti jchi'iltique. Scotolic lic sjaq'uic: ―¿Much'u li'to? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hech itac'av ti jchi'iltique ti te xchi'inojic tal ti Jesuse: ―Ja' Jesús. Ja' ti j'alc'op yu'un ti Diose ti liquem tal ti jteclum Nazarete te ti estado Galilea ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Te ti Jerusalén co'ol ni'ochtutic ti yamaq'uil templo yu'un ti Diose xchi'uc ti Jesuse. Ti Jesuse laj sten loq'uel ti yamaq'uil templo scotol ti much'utic ti te chchonilajique chmanilajique. Laj sbut'q'uimbe smesa ti jeltaq'uinetique. Laj sbut'q'uimbe snacleb ti much'utic chchonic culajteetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hech laj yalbe: ―Hech ts'ibabil comel ti sc'op ti Diose: “Ti Jnae ja' sventa ti chac'oponune”, ti xchi ti Diose. Ho'oxuque laj xa ac'atajesic ti xch'en j'eleq'uetic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Te ti yut templo italic ti stojol ti Jesuse ma'satetic xchi'uc mecanetic. Scotol icolic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Te oyic uc cha'vo' oxvo' ti totil paleetique xchi'uc cha'vo' oxvo' ti yan jchi'iltic ti ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Laj sq'uelic ti jchop o abteletic ti laj spas ti Jesuse. Laj ya'yic c'alal tsots laj yalic ti queremetique: “¡Jpastic ti muc' ti yelnich'on ti Davide ti sc'opilal chtal ochuc ti ajvalile!” xchiic. Hech yu'un i'ilinic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Hech yu'un hech laj sjac'beic ti Jesuse: ―¿Mi laj ava'i ti c'usi chalic ti queremetique? ―xchiic. Hech itac'av ti Jesuse: ―Laj ca'i. ¿Mi mu aq'uelojuc uc ti hech chal ti sc'op ti Diose? Ti ololetique jelaven yutsil ac'opilal chaxcholbot, ti xchie ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hech niloc'tutic batel xchi'uc ti Jesuse. Nicha'sututic batel ti jteclum Betania. Te c'ot vayucuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ti yoc'omal sob ic'luman nisututic batel yan vuelta ti jteclum Jerusalén xchi'uc ti Jesuse. C'alal nixanavtutic batel ti be, lic vi'najuc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Laj yil oy igote' nopol ti'be. Ba sq'uel mi repenta oy sat. Mu'yuc sat c'ot sta, ja' no'ox yanal. Ti Jesuse hech laj yalbe ti te'e: ―Mi jutuc mu xa xasatin ―xut. Ti ora itaquij ti igote'e. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","C'alal laj jq'ueltutic ti ho'ontutic ti yajchanc'opuntutique ich'ay co'ntontutic yu'un. ―¿C'u che'el ti ora itaquij ti igote'e? ―xichitutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Itac'av ti Jesuse, hech laj yalbuntutic: ―Melel ti c'usi chacalbeique, mi oy xch'unojel avo'ntonic, ma'uc no'ox xu' avu'unic chapasic hech chaj c'u che'el laj jpasbe ti igote'e, ja' chc'ot ti pasel avu'unic uc scotol ti c'usi vocol ti pasel ti mu xu' avu'unique. Hech chaj c'u che'el mi chavale: “Ac'o sq'uej sba batel ti vits li'to, ac'o ochuc ti nab”, mi xachiique, ta me xc'ot ti pasel avu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yu'un mi oy xch'unojel avo'ntonic, scotol ti c'utic chac'ambeic ti Diose ja' chayac'boxuc ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","C'alal nic'otutic ti templo te ti Jerusalén xchi'uc ti Jesuse, lic chanubtasvanuc ti Jesuse. Ital cha'vo' oxvo' ti totil paleetique xchi'uc cha'vo' oxvo' ti moletique te ti jteclum. Hech laj sjac'be: ―¿Much'u smantal avich'oj ti hech laj aten loq'uel ti jchonolajeletique li' ti yamaq'uil ti temploe? ¿Much'u laj yac'bot avabtel? ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Hech itac'av ti Jesuse: ―Oy c'usi chajac'be uc. Mi chana'ique, chacalbe ava'yic ti much'u laj yac'bun ti cabtele. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Hech chajac'be. Ti Juane ¿much'u i'ac'bat yabtel yu'un ti laj yac' ich'ho'e? ¿Mi yu'un Dios i'ac'bat yabtel o mi yu'un crixchanoetic i'ac'bat yabtel? ―xut. Hech lic yalbe sbaic: ―“Yu'un Dios”, mi chijchie, “¿c'u yu'un muc xach'unic che'e?” ta me xijyutucutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Yu'un crixchanoetic”, mi chijchie, yu'un ja' chijxi' yu'un ti crixchanoetique yu'un scotolic xch'unojic ti ja' j'alc'op yu'un ti Diose ti Juane ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hech yu'un hech laj yalbeic ti Jesuse: ―Mu jna'tutic ―xchiic. Ti Jesuse hech laj yalbe: ―Hechun uc, mu xacalbe much'u laj yac'bun ti cabtele ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Hech laj yalbe uc ti Jesuse: ―Chacalbe sc'opilal jun vinic. Oy cha'vo' xnich'nab. C'o sc'opon ti june: “Jnich'on, ti ora to chabat ti abtel ti bu uvate' cu'une”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Hech itac'av ti snich'one: “Mu jc'an chibat”, xchi. Patil laj snop xa ti yo'nton stuc ti chba spasbe yabtel ti stote. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ti vinique ba sc'opon ti jun snich'one. Co'ol laj yalbe. Hech itac'av ti snich'one: “Cuy, tote, chibat”, xchi. Patil muc xbat. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿C'usi xchi avo'ntonic? Ti xcha'va'alique, ¿much'u laj spas ti c'usi sc'an yo'nton ti stote? ―xchi. Hech itac'avic: ―Ja' ti much'u jbael ic'oponate ―xchiic. Ti Jesuse hech laj yalbe: ―Melel ti c'usi chacalbeique, ti much'utic jp'ajmantaletic chavilique, ja' ti jtsobpatanetique xchi'uc ti jmulavil antsetique, tspasatic xa ti mantal yu'un ti Diose. Ti ho'oxuque mu xac'anic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ital ti atojolic ti Juane. Ja' tal yalboxuc ti c'usi lec chapasique. Muc xach'umbeic sc'op. Ti jtsobpatanetique xchi'uc ti jmulavil antsetique, laj xch'umbeic sc'op, laj sutes yo'ntonic. C'alal laj avilic ti laj xch'unique, muc xasutes avo'ntonic ti ho'oxuque, muc xach'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’A'yo me ava'yic yan lo'il. Oy jun vinic oy slum. Te laj sts'un ep uvate'. Laj spas macte'ton ti sjoylejal. Laj sjomic ton yo' bu tsloq'uesbe ya'lel sat ti uvate'e. Laj spas jun na, toyol ti solel ti nae. Ja' sventa tsq'uel scotol ti uvate'e. Laj sa' yaj'abtel yu'un chchabibat ti slume. Patil nom ibat ti yajval ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’C'alal ista xa yorail itoc'onaj ti sat ti uvate'e, laj stac talel ti smozotaque yu'un chc'ot sc'opon ti jchabiejbalumile. Chc'ot sc'ambeic tal ti sate. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ti jchabiejbalumile itsacvanic, laj stsaquic ti mozoetique. Jun laj smajic, jun laj smilic, jun laj yac'beic ton. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ti yajval ti balumile laj xcha'tac talel nixtoc yan smozotac. Más ep laj stac talel. Co'ol ono'ox ipasbatic hech chaj c'u che'el ti much'u jbael itacatic talele. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Patil laj stac talel ti snich'one. Hech laj yal: “Ja' chispasbucun ti muc' ti jnich'one”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ti jchabiejbalumile c'alal laj yilic ti ja' snich'on ti yajval ti balumile, hech laj yalbe sbaic: “Ja' yajval balumil chcom avi to. Jmiltic. Ho'ucutic chquich'betic comel ti slume”, xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hech yu'un laj stsaquic, laj stenic loq'uel ti bu ts'umbil ti uvate'e, laj smilic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Hech yu'un mi isut tal ti yajval ti uvate'e, ¿c'usi chc'ot pasbatuc ti jchabiejbalumile? ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hech itac'avic: ―Ja' chmilat ti hovijoletique. Yan chac'be xchabi ti uvate' yu'une. Ja' tsa' ti much'u chac' entrecal ti sate c'alal tsatin ti te'etique ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ti Jesuse hech laj sjac'be: ―¿Mi mu hechuc aq'ueloj uc ti sun ti Diose? Hech chaj c'u che'el ti yajval nae ti laj yotes ti chiquina ti tone ti mu xtun laj yilic ti yaj'abtele, ja' no'ox hech laj xa yich' tsots yabtel yu'un ti Diose ti much'u t'ujbil yu'une ti ja' mu sc'anique. Ja' yabtel ti Cajvaltic Diose. Jun no'ox yutsil chc'ot ti jtojoltic, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Hech yu'un chacalbeic, ti ho'oxuque laj sc'opilal ti chaspasoxuc ti mantal ti Diose. Ja' tspas ti mantal yanlum crixchanoetic, ja' ti tspasic c'utic tsc'an ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hech chaj c'u che'el ti p'in ti chp'aj yal tal ti ba ton pedazo chc'ot o, mu'yuc xa stu, ja' no'ox hech uc mu'yuc xa stu cu'un ti much'u mu sc'an chixch'umbun ti jc'ope. Mi mu sutes yo'nton, ja' chc'o quich'be sc'op. Hech chaj c'u che'el ti p'in ti chp'aj yal tal muc'ta ton ti sba ja' tsts'ubilaj, ja' no'ox hech uc mi laj cal ti ch'ayel chbatique, jp'el sc'opilal ch'ayel chbatic o. Laj stu o, ti xchi ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","C'alal laj ya'yic ti lo'ile ti totil paleetique xchi'uc ti fariseoetique, laj sna'ic ti ja' sc'opilal stuquic ti icholbate. ");
INSERT INTO tzoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Hech yu'un sc'an stsaquic ti Jesuse. Ja' ixi'ic yu'un ti crixchanoetique yu'un xch'unojic ti ja' j'alc'op yu'un ti Diose ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ti Jesuse yan vuelta laj yal lo'il. Hech laj yalbe ti jchi'iltique: ");
INSERT INTO tzoNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Chacalbeic ti c'utic x'elan tspasvan ti mantal ti Diose. Hech yu'un chacalbe hech chaj c'u che'el jun ajvalil ti laj spas q'uin yu'un chnupun ti snich'one. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Laj stac batel yabat yu'un chba yiq'uic tal ti much'utic ch'amumbil xa yu'une yu'un chtal sq'uelic ti nupunele. Muc sc'an xtalic. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Laj xcha'tac batel yan vuelta yan yabat. Hech laj yalbe batel: “Hech chavalbeic ti much'utic ch'amumbilic xa cu'une: Scotol chapal xa cu'un ti ve'elile. Milbil xa ti vacaxe xchi'uc ti c'utic yan ti jup'ene. Chapal xa scotol. La'ic me. La' q'uelo ti nupunele, xchi ti cajvale, hech chavutic”, x'utatic batel. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ti much'utic ch'amumbilique muc xch'unic tal. Ti june ba sq'uel c'u x'elan xchob. Ti june ba chonilajuc. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ti yantique laj stsaquic ti abatetique, laj yilbajinic, laj smilic. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","C'alal laj ya'i ti ajvalile, i'ilin. Laj stac batel yajsoldadoetic yu'un ac'o ba smilic ti jmilvanejetique. Patil ichic'bat ti c'oc' ti slumalique. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Patil laj yalbe ti yabate: “Chapal xa scotol yu'un ti q'uin sventa nupunele. Yu'un muc spasic ti muc' ti much'utic ch'amumbile, ");
INSERT INTO tzoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","hech yu'un batanic ti bebetic, ba iq'uic tal yu'un ac'o sq'uelic ti q'uin sventa nupunele scotol ti much'utic chataic ti be”, x'utatic batel. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Hech iloq'uic batel ti yabate. Ixanavic batel ti bebetic. Laj stsobic tal scotol ti much'utic laj staic ti be capal ti much'utic chopol yo'ntonique xchi'uc ti much'utic lec yo'ntonique. Hech inoj ti na ti bu tspasic ti q'uine. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","C'alal i'och tal ti ajvalile, yu'un tal sc'opon ti much'u ic'bilic itale, laj yil ti te oy jun vinic ti mu sventauc nupunel ti sc'u' ti slapoje. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Hech laj yalbe: “Quits'in, ¿c'u yu'un ti muc xac'an xavich' ti c'u'ile ti jchapanoj ti chavich'ique ti ja' sventa ti q'uin yu'un nupunele?” xut. Muc xtac'av ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ti ajvalile hech lic yalbe ti yabate: “Chucbo sc'ob yacan, ic'o loq'uel, teno ochel ti ic' osil. Ac'o yich' ep vocol. Te chc'ot yoc'ta sba o, te xjep'et ye o”, xchi ti ajvalile. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Scotol ch-ic'atic. Atabil no'ox ti much'u tsc'anique. Ja' t'ujbilic yu'un ti Diose ti much'utic tsc'anique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hech yu'un ti fariseoetique ba xchapanic ti c'u che'el xu' tsjaq'uilambeic ti Jesuse yu'un ac'o loc'uc ti ye ti bu xu' tstabeic smul tscuyic. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Laj staquic talel ti yajchanc'opetic yu'unique xchi'uc ti svinictac ti Herodese, ja' ti much'utic toyol yo'ntonic itic'at yu'une. Hech tal sjac'beic ti Jesuse: ―Maestro, ti jna'tutic ti melel scotol ti c'usi chavale. Chavac' ti chanel ti sbe ti Diose ti mero melel. Co'ol chac'opon scotol, manchuc mi tsots yabtel yich'oj, manchuc mi mu'yuc yabtel. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Alo ca'itutic ti c'usi chanope. ¿Mi stac' chcac'betutic patan ti Césare, mi mu stac'? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ti Jesuse laj sna' ti chlo'lavanique. Hech yu'un hech laj yalbe: ―Jlo'lavanejoxuc. ¿C'u yu'un chapasbun proval co'nton? ");
INSERT INTO tzoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ac'bun jq'uel junuc ataq'uin ti ja' sventa yu'un chatoj apatanique ―xut. Hech yu'un ba yich' tal jun denariotaq'uin. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ti Jesuse hech laj sjac'be: ―¿Much'u sloc'tombail ti o'loli? ¿Much'u sbi te oy ti sti'ile? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hech itac'avic: ―Ja' ti Césare ―xchiic. Ti Jesuse hech laj yalbe: ―Oy c'usi stac' chach'umbeic ti Césare yu'un ja' totil ajvalil. Ja' no'ox hech uc ti Diose tsc'an chach'unic ti c'u che'el tsc'an ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","C'alal laj ya'yic ti hech laj yalbe, ich'ay yo'ntonic. Iloq'uic batel. Jtuctutic no'ox te nicomtutic xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Patil ital cha'vo' oxvo' ti saduceoetique, ja' ti chalic ti mu'yuc much'u chcha'cuxie. Hech tal sjac'beic ti Jesuse: ");
INSERT INTO tzoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, hech laj sts'iba comel ti Moisese: “Mi oy much'u mu'yuc yol snich'on chcham, ti its'inale ti mu to oyuc yajnile ac'o yic'be yajnil ti sbanquile yu'un hech c'alal ch-an sba yol snich'on xu' chac'be xq'uexolin ti sbanquile yu'un hech mu xtup' sbi ti sbanquile”, ti xchi ti Moisese. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oy hucvo' jchi'iltic. Yermano sbaic ti hucvo'ique. Ti banquilale laj yic' yajnil, patil icham. Mu'yuc yol snich'on icom. Hech yu'un ti its'inale laj yic'be yajnil ti ánima sbanquile. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hech laj spasic scotolic o. Xmelmun laj yiq'uic sucva'alic. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Icham scotolic. Patil icham uc ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","C'alal tsta yorail ti chcha'cuxiique, ¿much'u junuc yajnil chc'ot ti antse? Melel ti xmelmun laj yiq'uic scotolic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Hech itac'av ti Jesuse: ―Ch'ayemoxuc yu'un mu xana'ic c'usi chal ti sun ti Diose. Mu xana'ic c'u x'elan sp'ijil ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","C'alal chcha'cuxiic scotolic, mu'yuc xa yajnil viniquetic, mu'yuc xa smalal antsetic. Hech chc'otic hech chaj c'u che'el ti ch'ul abatetic yu'un ti Diose ti te oyic ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yu'un ti mu xach'unic ti chcha'cuxiic ti ánimaetique, hech yu'un hech chacalbeic. Aq'uelojic ti c'u che'el chayalboxuc ti Diose, ja' sc'opilal ti Abrahame xchi'uc ti Isaaque xchi'uc ti Jacobe. Manchuc mi ep xa habil chamenic ti Abrahame xchi'uc ti Isaaque xchi'uc ti Jacobe, hech ch-albatic to sc'opilal: ");
INSERT INTO tzoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ho'on Diosun yu'un ti Abrahame xchi'uc ti Isaaque xchi'uc ti Jacobe”, ti xchi ti Diose. Yu'un cuxajtic. Yu'un ja'uc j'ech'el ichamic oe, mu'yuc xa dios yu'unic. Hech yu'un ti Diose ja' yu'unic ti much'utic cuxajtique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","C'alal laj ya'yic ti jchi'iltique ti hech laj yal ti Jesuse, ich'ay yo'ntonic yu'un ti sc'op ti laj yac' ti a'yele. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","C'alal laj ya'yic ti fariseoetique ti itsalat ti saduceoetique yu'un ti Jesuse, patil stuquic laj stsob sbaic tal ox. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Oy jun fariseo, ja' jchanubtasvanej yu'un ti smantal ti Diose ti scuyoj sbae. Ja' sc'an spasbe proval yo'nton ti Jesuse. Hech yu'un hech tal sjac'be: ");
INSERT INTO tzoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ti scotol ti smantal ti Diose ti laj yal ti Moisese, ¿c'usi mantalil ti más tsots sc'opilale? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Hech itac'av ti Jesuse: ―“C'ux me xava'i ti Cajvaltic Diose, ja' ti Dios cu'untique, xchi'uc scotol avo'nton xchi'uc scotol ap'ijil”, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ja' mero sba mantal obi. Ja' tsots sc'opilal. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ti xchibal mantale co'ol tsots sc'opilal xchi'uc. “C'ux me xava'i avecino hech chaj c'u che'el c'ux chava'i aba”, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Avi chib mantaletic li'to ja' tsobbil scotol xchi'uc yan mantaletic xchi'uc ti sc'op ti j'alc'opetic yu'un ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","C'alal te stsoboj sbaic ti fariseoetique, ti Jesuse hech laj sjac'be: ");
INSERT INTO tzoNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿C'usi chanopic? ¿Much'u statamol ti Cristoe? ―xut. Hech itac'avic: ―Ja' statamol ti Davide ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ti Jesuse hech laj sjac'be: ―Mi yelnich'one, ¿c'u yu'un Cajval, xchi ti Davide? Yu'un ja' ti sventa ti Ch'ul Espíritue ti hech laj sts'iba comel ti Davide: ");
INSERT INTO tzoNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ti Cajvale hech i'albat yu'un ti Diose: “Chlic naclan li' ti jbats'ic'ob ja'to mi laj jtsalbot scotol avajcontra”, x'utat ti Cajvale, xchi ti Davide. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Hech yu'un ma'uc no'ox yelnich'on yu'un Cajval, xchi ti stojol ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mi junuc mu'yuc much'u itac'avic. Mi jutuc mu xa much'u tsjaq'uic o. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ti Jesuse laj sc'oponuntutic ho'ontutic ti yajchanc'opuntutique xchi'uc ti ep jchi'iltic ti te stsoboj sbaique. Hech laj yalbuntutic: ");
INSERT INTO tzoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti fariseoetique ja' xq'uexol ti Moisese icomic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hech yu'un scotol ti sc'op Diose ti chayalboxuque ta me xach'unic, ta me xapasic. Mu me hechuc chapasic hech chaj c'u che'el tspasic stuquique. Yu'un ja' no'ox hech no'ox chalic, mu xc'ot ti pasel yu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Sjeluc tsmeltsanic icatsil. Ol ti icatsile. Vocol ti cuchel. Chac'be xcuch ti crixchanoetique. Stuquic mi jutuc mu sliquic mu xcuchic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Scotol ti yabtelique ja' no'ox tspasic yu'un tsc'an ti lec ac'o ilatuc yu'un ti crixchanoetique. Muc' spasojic ti scaxail ti mantaletique ti chaq'uic ti sc'obic, chaq'uic ti stibaic c'alal tsc'oponic Dios. Nat yac'ojic ti sba ti sc'u'ique. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ja' no'ox lec cha'yic chnaquiic ti sba naclebal c'alal oy q'uin. Ja' no'ox lec cha'yic uc chnaquiic ti sba naclebal li' ti yut templo cu'untique. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ja' no'ox lec cha'yic mi ep chc'oponat yu'un jchi'iltic te ti plaza. Ja' no'ox lec cha'yic maestro, mi ch-utatic yu'un ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ti ho'oxuque mu me xac'anic ti maestro cha'utatic. Jun no'ox ti Maestro avu'unique. Ti ho'oxuque avermano abaic acotolic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mu me much'u chatotinic li' ti templo avu'unique. Melel ti jun no'ox ti Jtotique. Te oy ti vinajel. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mu me much'u Cajval, mu me xayutoxuc. Melel ti jun no'ox ti avajvalique, ho'on ti Cristoune. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ti much'u totil avu'unique, ac'o yac' sba ti abatinel avu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yu'un ti much'u chac' sba ti pasel ti muc', ja' chbic'tajesat yu'un ti Diose. Ja'uc ti much'u biq'uit chac' sbae, ja' ch-ac'at ti pasel ti muc' yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ho'oxuc ti chachanubtasvanic ti smantal ti Diose ti acuyoj abaique, xchi'uc ho'oxuc ti fariseooxuque, ta me xavich'ic ep vocol yu'un ti chalo'lavanique. Chapajesic ti jchi'iltique. Ho'oxuc ti jbaejbeoxuc mu xac'an ti chaspasoxuc ti mantal ti Diose, hech yu'un chapajesic ti much'utic tsc'anique. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ho'oxuc ti chachanubtasvanic ti smantal ti Diose ti acuyoj abaique, xchi'uc ho'oxuc ti fariseooxuque, ta me xavich'ic ep vocol yu'un ti chalo'lavanique. Hovil ti hal chac'oponic Dios. Chapojbeic ti c'utic oy yu'un ti me'on antsetique. Hech yu'un jelaven chavich'ic castigo. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ho'oxuc ti chachanubtasvanic ti smantal ti Diose ti acuyoj abaique, xchi'uc ho'oxuc ti fariseooxuque, ta me xavich'ic ep vocol yu'un ti chalo'lavanique. Chaxanavic batel ti scotol balumil yu'un chac'an chata avajchanc'op. Mi laj ataique, ech'em hech chaj c'u che'el yol snich'on ti pucuje chc'ot avu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ta me xavich'ic ep vocol yu'un mu xtun ti cha'ic'vanique yu'un ma'satoxuc. Hech chavalic: “Scotol ti much'u tsva'an ti rextico ti temploe, mu persauc chc'ot ti pasel ti c'usi laj yale. Ja'uc ti much'u tsva'an ti rextico ti sc'anal taq'uin ti temploe, ja' persa me chc'ot ti pasel ti c'usi laj yale”, xachiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Bolibenoxuc, ma'satoxuc! Ma'uc tsots sc'opilal ti c'anal taq'uine; ja' tsots sc'opilal ti temploe yo' bu oy ti c'anal taq'uine. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hech chavalic uc: “Scotol ti much'u tsva'an ti rextico ti scajaneb smoton ti Diose, mu persauc chc'ot ti pasel ti c'usi laj yale. Ja'uc ti much'u tsva'an ti rextico ti smoton ti Diose ti te cajambile, ja' persa me chc'ot ti pasel ti c'usi laj yale”, xachiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Bolibenoxuc, ma'satoxuc! Ma'uc tsots sc'opilal ti smoton ti Diose; ja' tsots sc'opilal ti scajaneb smoton ti Diose yo' bu chcajambat ti smoton ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ti much'u tsva'an ti rextico ti scajaneb smoton ti Diose, scotol tsva'an xchi'uc ti scajanebe xchi'uc scotol ti c'usi te cajambile. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Hech ono'ox uc ti much'u tsva'an ti rextico ti temploe, scotol tsva'an xchi'uc ti temploe xchi'uc ti Diose ti te nacale. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ti much'u tsva'an ti rextico ti vinajele, scotol tsva'an xchi'uc ti smuc'ta nacleb ti Diose xchi'uc ti Diose ti te nacale. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ho'oxuc ti chachanubtasvanic ti smantal ti Diose ti acuyoj abaique, xchi'uc ho'oxuc ti fariseooxuque, ta me xavich'ic ep vocol yu'un ti chalo'lavanique. Chavati ti lajlajuneb scotol ti c'utic ats'unojique, ja' ti tunichime xchi'uc ti eneldoe xchi'uc ti cominoe. Jujun chaloq'uesic ti lajlajuneb yu'un chavac'beic smoton ti Diose. Mu c'otemuc ti pasel avu'unic ti bu tsots sc'opilal ti smantal ti Diose ti laj yal ti Moisese. Mu tsotsuc sc'opilal chava'yic ti toj avo'ntonique, ti c'ux chava'yic ti Diose, ti oy xch'unojel avo'ntonique. Ja' lec ti lajuc apas ti bu tsots sc'opilal uque. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hovil ti chatojobtasvanic ti chacuyique yu'un mu xtojob avu'unic ti ho'oxuque. Ja' no'ox chach'unic ti bu mu tsotsuc sc'opilale. Ti bu tsots sc'opilale ja' comen avu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ho'oxuc ti chachanubtasvanic ti smantal ti Diose ti acuyoj abaique, xchi'uc ho'oxuc ti fariseooxuque, ta me xavich'ic ep vocol yu'un ti chalo'lavanique. Ja' no'ox chapocbeic spat ti tazae ti platoe. Ti yute mu xapoc. Nojem scotol ti c'usi chopole. Ho'oxuque hech chaj c'u che'el ti taza ti chcale. Ti avo'ntonique nojem ti sbic'tal avo'ntonique xchi'uc ti c'usi chopol chac'an chapasique. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ma'satoxuc, fariseoetic. Ja' sc'an ti jbael chavac' ti poquel avo'ntonic, hech co'ol lec ti yut, lec ti fuera. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ho'oxuc ti chachanubtasvanic ti smantal ti Diose ti acuyoj abaique, xchi'uc ho'oxuc ti fariseooxuque, ta me xavich'ic ep vocol yu'un ti chalo'lavanique. Hechoxuc hech chaj c'u che'el ti ch'en ti campo santoe. Ti sba oy vovoro sacubtasbil ti tan. T'ujum ti q'uelel. Ti yut ch'en nojem sbaquel ánimaetic xchi'uc scotol ti c'usi c'a'eme. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hechoxuc ono'ox uc. Toj avo'ntonic x'elan ti stojol crixchanoetic. Nojem ti avo'ntonic ti chalo'lavanique xchi'uc yan muliletic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ho'oxuc ti chachanubtasvanic ti smantal ti Diose ti acuyoj abaique, xchi'uc ho'oxuc ti fariseooxuque, ta me xavich'ic ep vocol yu'un ti chalo'lavanique. Laj apasic vovoro ti bu mucul ti j'alc'opetic yu'un ti Diose. Te chavaq'uic nichim yu'un chana'ic ti much'u toj yo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Hech chavalic: “Ti ho'ucun cuxuluntutic ti vo'one c'alal ti yorail cuxul ti antiguo jtot jme'tique, muc jch'untutic ti jmiltutic ti j'alc'opetic yu'un ti Diose ti hechuque”, xachiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yu'un ti hech chavalique chvinaj ti ho'ot yol snich'onoxuc ti much'utic laj smilic ti j'alc'opetic yu'un ti Diose ti vo'onee. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ho'oxuc chats'acubtasbe yabtel ti atotique. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Hech chaj c'u che'el orachon ti atotique. Ja' no'ox hechoxuc uc orachonoxuc uc. Mu xu' chacolic. Persa chba avich'ic castigo ti c'atimbac. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Hech yu'un ti jtac talel ti atojolic j'alc'opetic xchi'uc jchanubtasvanejetic xchi'uc much'utic chchanubtasvanic ti smantal ti Diose. Oy chlic amilic, oy chlic ajipanic ti cruz, oy chlic avac'beic acial te ti yut temploetic avu'unique. Oy chlic atenic loq'uel ti jujun jteclum ja'to mi iloc' ti alumalique. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hech yu'un chcom ti aventaic ti imilat li' ti balumile scotol ti much'utic toj yo'ntonique. Scotol chcom ti aventaic, ti Abele ti toj ti viniquile ti ja' imilat jbaele asta uc ti Zacaríase ja' ti snich'on ti Berequíase ti imilat te ti yut templo ti bu nopol scajaneb smoton ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Melel ti c'usi chacalbeique, scotol chcom ti aventaic ho'oxuc ti li'oyoxuc ti balumil ti ora to. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ho'oxuc ti li'oyoxuc li' ti Jerusalene atalelic chamilic ti j'alc'opetic yu'un ti Diose. Chavac'beic ton ti much'utic itacatic tal ti atojolique. Ep vuelta laj jc'an chajtsoboxuc hech chaj c'u che'el tstsob yol ti yolon xic' jcot me'caxlan. Muc xac'anic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","A'yo me ava'yic, ti ho'oxuque atuquic xa no'ox chaventain abaic. Mu xa teuc Dios ti atojolic. ");
INSERT INTO tzoNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chacalbeic, ja'to mi laj sta yorail ti hech chavalique: “Jun no'ox yutsil ti itacat xa tal ti jtojoltic yu'un ti Cajvaltic Diose”, mi chachiique, ja'to xu' chaq'uelbun jsat yan vuelta ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","C'alal niloc'tutic ti templo te ti Jerusalén xchi'uc ti Jesuse, ho'ontutic ti yajchanc'opuntutique, ilic sc'opilal cu'untutic yu'un ti temploe yu'un t'ujum ti naetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ti Jesuse hech laj yalbuntutic: ―Laj xa aq'uelic avi to. Melel ti c'usi chacalbeique, mi jp'ejuc ton mu'yuc bu chcom ti sba yan ton yu'un scotol chtal sjin ti yan c'ac'al yan crixchanoetic ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ba naclucuntutic ti vits Olivatic jtuctutic no'ox xchi'uc ti Jesuse. Hech laj jac'betutic ti Jesuse: ―Albun ca'itutic c'usi ora hech chjinat ti temploe. ¿C'usi señail ti jq'ueltutic c'alal chatal? ¿C'usi señail ti jq'ueltutic yu'un ti jna'tutic ti ja' ti yorail ti slajebal c'ac'ale? ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Hech itac'av ti Jesuse: ―P'ijanic me, mu me xalajic ti lo'lael. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yu'un ep chtalic chalic “ho'on jcoltavanejun”, xchiic. Ep ti much'utic chlaj ti lo'lael yu'un ti hech chalique. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ti yan c'ac'al chava'ibeic sc'opilal ti oy ep muc'ta pleito li' ti balumile. Chava'ibeic sc'opilal uc ti chlic yan muc'ta pleito. Mu me xaxi'ic. Persa scotol hech chc'ot ti pasel. Mu to ja'uc slajebal c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ti crixchanoetic ti jun balumile ja' tscontrain ti yan crixchanoetic ti yan balumile. Ti ajvaliletique tscontrain sbaic. Chtal vi'nal, chtal ep chamel. Buc no'ox chnic ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Avi c'u che'el laj cale ja' sliqueb to no'ox ti vocole. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Cha'ac'atic entrecal ti sc'obic yu'un chayilbajinoxuc yu'un chasmiloxuc. Ep crixchanoetic chayilintaoxuc ho'on ti jventa. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ep ti much'utic chchibaj yo'ntonic hech yu'un chlic stic'be sbaic smulic, chlic yilinta sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Chtalic ep nopbilal j'alc'opetic. Ep ti much'utic chlaj ti lo'lael yu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yu'un i'epaj xa ti mulile ep ti much'utic tspec'tsaj yo'ntonique. Hech yu'un mu xa c'uxuc ti yo'ntonic ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Scotol ti much'utic scotol sts'ic yu'un c'alal ti slajebal ora, ja' chcol. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ta me xich' cholel ti sjoylejal balumil ti lequil ach' c'ope, ja' ti c'u che'el tspasvan ti mantal ti Diose yu'un ac'o ya'yic scotol crixchanoetic. Patil tsta yorail ti slajebal c'ac'ale ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","A'ibeic me sjam ti c'usi chajts'ibaboxuc li'to. Hech laj yalbuntutic uc ti Jesuse: ―C'alal chaq'uelic ti ixtambil ti jyalel ti temploe hech chaj c'u che'el laj yal ti Daniele, ja' ti j'alc'op yu'un ti Diose ti vo'one, anil me batanic ti vits ho'oxuc ti li'oyoxuc li' ti Judeae. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ti much'utic muem ti yamaq'uil sjol sna, c'alal chyal tal, mu xa me c'usi chba stam loq'uel ti c'usi oy yu'un te ti yut sna. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ti much'utic te oyic ti xchobique, mu xa me sut batel yu'un tstam loq'uel ti xchije. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Uts sbaic ti much'utic slicojic yole xchi'uc ti much'utic oy yol chchu'unic toe. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","C'ambeic vocol ti Diose ti ma'uc ti yorail sic, ti ma'uc ti sc'ac'alil ti jcux co'ntontic ti c'alal chajatavique. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Melel ti ep ti vocol chtale. Mu'yuc bu hech yan vocol c'alal ilic ti balumile asta ti ora to. Mu'yuc bu hech yan vocol chtal yan vuelta. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ti manchuc tscomejes ti yorail vocole ti Diose, mu'yuc much'u chcol ti hechuque. Ja' ti sventa scotol ti much'utic t'ujbilic yu'une hech yu'un ti Diose tscomejes ti yorail vocole. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Hech yu'un mi oy much'u chayalbot: “Q'uelo avil, ja' Cristo li'to”, mi xayutote, “ja' Cristo lume”, mi xayutote, mu me xach'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Melel ti chtalic nopbilal cristoetic xchi'uc nopbilal j'alc'opetic. Chaq'uic ti q'uelel muc'ta señailetic. Hech tslo'laic scotol ti crixchanoetique. Taca hu'uc yu'unique, tsc'an tslo'laic uc ti much'utic t'ujbilic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Laj xa me calboxuc scotol. Mu to chc'ot ti pasel. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Hech yu'un mi oy much'u chayalboxuc jc'opilal: “Te oy ti xocol balumil”, mi xayutote, mu me xaloq'uic batel yu'un chba aq'uelic. “Te oy ti yut na”, mi xayutote, mu me xach'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yu'un hech chaj c'u che'el ti ora no'ox chleblej ti tselove chquiltic jcotoltic ti chlic ti sloq'ueb c'ac'al chleblej batel c'alal ti smaleb c'ac'al, ja' no'ox hechun ti ho'one ti ora no'ox chital chavilic acotolic, ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Hech chaj c'u che'el ti ora no'ox sna' bu oy ánima ti tanjole, ja' no'ox hech chc'ot ti pasel ti ora no'ox chavilic nital xa ti ho'one. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’C'alal mi i'ech' xa ti yorail ti vocole, ch-ic'ub ti c'ac'ale. Mu xa xac' squeval uc ti ue. Chp'aj yal tal ti c'analetique. Chnic scotol ti c'utic te oy ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Scotol crixchanoetic chilic oy señail te ti vinajel c'alal tsta yorail ti chitale, ho'on ti co'ol crixchanoucutique. Hech yu'un scotol crixchanoetic ch-oq'uic, ti jalajuntos crixchanoetic li' ti balumile. Tsq'uelic ti chiyal tal ti vinajel xchi'uc toc ho'on ti co'ol crixchanoucutique. Chvinaj ti jelaven jp'ijile, ti lum lec ti jquevale. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tsots ch-oc' corneta. Ja' ti jtac yal tal ti ch'ul abatetic cu'une. Chtal stsobic scotol ti much'utic t'ujbilic cu'une, ti buc no'ox oyic ti sjoylejal balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Nopic me c'u x'elan ti chjel ti igote'e li' ti jlumaltiqui. C'alal ch-ach'ub ti sc'obe, chloc' yanal. Ti c'alal chaq'uel ti yanale, chana'ic ti po'ot xa tsta yorail ho' li'i. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hech ono'ox uc c'alal chaq'uelic ti chc'ot ti pasel scotol ti vocol ti laj calboxuque, chana'ic ti po'ot xa tsta yorail chital ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Melel ti c'usi chacalbeique, oy mu to chachamic ja'to mi ic'ot xa ti pasel scotol ti vocol ti laj xa calboxuque. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Chlaj ti vinajele xchi'uc ti balumile. Ti jc'ope ja' mu xlaj stuc. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Mi junuc mu'yuc much'u sna' c'usi ora, c'usi c'ac'alil ti chc'ot ti pasele. Mu sna'ic uc ti ch'ul abatetique ti te oyic ti vinajele. Mu jna' uc ho'on ti Nich'onilune. Stuc no'ox sna'oj ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Hech chaj c'u che'el laj spasic ti crixchanoetique c'alal li'oy ti balumile ti Noee, ja' no'ox hech tspasic uc c'alal po'ot xa tsta yorail chital ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","C'alal mu to xtal ti nojelal ho'e, yac'oj sba chve'ic, yac'oj sba chnupunic, yac'oj sba chaq'uic ti nupunel stsebic. Ja'to c'alal laj sta yorail i'och ti barco ti Noee, ja'to ipajic. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ja'to c'alal ital ti nojelal ho'e, ja'to laj sna'ic. Scotolic itup'ic. Ja' no'ox hech uc ja'to mi nitale, ho'oni ti co'ol crixchanoucutique, ja'to chlic sna'ic. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mi oy cha'vo' viniquetic te ti chobtic, jun ch-ic'at, jun chcom. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mi oy cha'vo' antsetic xchi'inoj sbaic ti juch'nej, jun ch-ic'at, jun chcom. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Hech yu'un q'ueleluc me asatic yu'un mu xana'ic c'usi ora chital ho'on ti Avajvalune. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na'ic me, ti lajuc sna' ti yajval nae ti c'usi ora chtal ti j'eleq'ue, muc xvay ti hechuque. Hech muc xbat ti elc'anel ti c'utic te oy ti sna ti hechuque. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hech yu'un ti ho'oxuc uque, p'ijanic me. Chapalucoxuc me yu'un mu xana'ic c'usi ora chital ho'on ti co'ol crixchanoucutique. Mu me ja'uc mu xamalaun c'alal chital. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Ti much'u lequil abate jun no'ox yo'nton ch-abtej ti stojol ti yajvale. Yu'un oy sp'ijil yo'nton ch-ac'bat yabtel yu'un tsmac'lin scotol ti much'utic oyic ti stojol ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ja' chich' bendición yu'un ti hech yac'oj sba tspas c'alal chul taatuc yu'un ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Melel ti c'usi chacalbeique, yu'un ti hech tspase ch-ac'bat sventain scotol ti c'utic oy yu'un ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ti abate ti mu xtune hech chal ti yo'nton: Mu van xtal ti ora ti cajvale, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Hech chlic yilbajin ti much'utic i'ac'bat sventaine, chlic xchi'in ti ve'el ti much'utic lec chil sbaic xchi'uque. Co'ol chyacubic xchi'uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mu malabiluc yu'un ti c'usi ora chtal ti yajvale yu'un mu xch'un ti po'ot xa chtale. ");
INSERT INTO tzoNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hech yu'un c'alal mi ital ti yajvale, tsots castigo chich' ti jyalel. Ja' chba xchi'in ti much'utic jlo'lavanejetique. Te chc'ot yoc'ta sba o. Te xjep'et ye o ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Hech laj yalbuntutic uc ti Jesuse: ―Chacalbeic ti c'utic x'elan tspasvan ti mantal ti Diose mi laj sta yorail ti chitale. Hech yu'un chacalbe hech chaj c'u che'el lajunvo' tsebetic ti laj yich'ic batel sc'oq'uic yu'un ba snupic ti be ti jnupunele. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ti ho'vo'e oy sp'ijil yo'ntonic. Ti yan ho'vo'e mu'yuc sp'ijil yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ti tsebetique ti mu'yuc sp'ijil yo'ntonique c'alal laj yich'ic batel ti sc'oq'uique, muc xich'ic batel yan yaceiteic uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ti tsebetic ti oy sp'ijil yo'ntonique, c'alal laj yich'ic batel ti sc'oq'uique, laj yich'ic batel uc yan yaceiteic ti slimetaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Muc xtal ti ora ti jnupunele hech yu'un scotolic ital svayelic, hech ivayic. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ti o'lol ac'ubal oy much'u i'avan: “La' me, q'uelo avil, chtal xa ti jnupunele. La'ic me, ba nupic tal”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hech yu'un iliquic scotol ti tsebetique, laj xchapan sc'oq'uic. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ti tsebetic ti mu'yuc sp'ijil yo'ntonique, hech laj yalbeic ti tsebetic ti oy sp'ijil yo'ntonique: “Ac'buntutic jutuc avaceite yu'un ta xa xtup' ti jc'oc'tutique”, xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Hech itac'avic ti tsebetic ti oy sp'ijil yo'ntonique: “Mu xu' yu'un repenta mu tauc yutsil cu'untic jcotoltic. Ja' lec batanic ti sna ti much'u chchone, ba mano talel c'u yepal chtun avu'unic ho'oxuque”, xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","C'alal ba smanic tal ti yaceitee, ja' yorail ital ti jnupunele. Ti tsebetic ti chapajtique, laj xchi'inic ochel ti bu tspasic ti q'uin yu'un chnupunique. Hech yu'un laj smaquic ti ti'nae. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Patil ital uc ti yan tsebetique. Hech hul yalic: “Cajval, jambuntutic ti nae”, xchiic hulel. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Hech i'albatic: “Melel ti c'usi chacalbeique, mu xacojtiquinoxuc”, x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Hech yu'un q'ueleluc me asatic yu'un mu xana'ic c'usi c'ac'alil chital ho'oni ti co'ol crixchanoucutique. Mu xana'ic uc mi chital ti sob ic'luman, mi chital ti mal c'ac'al, mi chital ti ac'ubal ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Hech laj yalbuntutic uc ti Jesuse: ―Chacalbeic ti c'utic x'elan tspasvan ti mantal ti Diose. Hech yu'un chacalbe hech chaj c'u che'el jun vinic ti nom chbate. C'alal mu to chloc' batel laj yic' tal ti abatetic yu'une. Laj yac'be sventainic comel ti staq'uine. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Ti june laj yac'be sesenta ti mil ti staq'uine. Ti june laj yac'be veinticinco mil ti staq'uine. Ti june laj yac'be lajchamil ti staq'uine. Ti much'u ep sp'ijil ti yo'ntone, ja' ep i'ac'bat. Ti much'u mu epuc sp'ijil ti yo'ntone, ja' mu epuc i'ac'bat. C'alal laj xa yac'be comel ti oxvo'ique, patil nom ibat ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ti much'u ti i'ac'bat ti sesenta mile, ba spas canal xchi'uc. Ijolin yu'un. Sesenta mil ti sjole. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hech ono'ox uc ti much'u ti i'ac'bat ti veinticinco mile. Ijolin yu'un. Veinticinco mil ti sjole. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ti much'u ti i'ac'bat ti lajchamile, ba smucbe ti lum ti staq'uin ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’C'alal i'ech' ep c'ac'al, hech yu'un isut tal ti yajval ti abatetique. Laj yic' tal ti stojol yu'un tsjac'be c'usi laj yutic ti staq'uine ti laj yac'bee. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jbael ital ti much'u i'ac'bat ti sesenta mile. Laj yich'be tal uc ti sesenta mil ti ijolin yu'une. Hech hul yalbe: “Cajval, ilo ti sesenta mil ataq'uin ti laj avac'bune xchi'uc ti sesenta mil ti ijolin cu'une”, xchi hulel ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Hech i'albat yu'un ti yajvale: “Lec oy, chquich'. Ho'ot lequil abatot cu'un. Jun avo'nton ti jtojol. Yu'un lec laj achabibun ti jutuc ti laj cac'bot aventaine, ep ox chacac'bot aventain ti ora to. La' me li' ti jtojoli yu'un nichim no'ox avo'nton sbatel osil”, x'utat yu'un ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ital uc ti much'u ti i'ac'bat ti veinticinco mile. Hech hul yalbe ti yajvale: “Cajval, laj avac'bun veinticinco mil ataq'uin. Ilo xchi'uc ti veinticinco mil ti ijolin cu'une”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Hech i'albat yu'un ti yajvale: “Lec oy, chquich'. Ho'ot lequil abatot cu'un. Jun avo'nton ti jtojol. Yu'un lec laj achabibun ti jutuc laj cac'bot aventaine, ep ox chacac'bot aventain ti ora to. La' me li' ti jtojoli yu'un nichim no'ox avo'nton sbatel osil”, x'utat yu'un ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ital uc ti much'u i'ac'bat ti lajchamile. Hech hul yalbe ti yajvale: “Cajval, laj jna' ti c'oc' vinicote. Ho'ot hech chaj c'u che'el ti much'u tsc'aj ti bu mu sts'une, tstsob uc ti bu mu xic'ae. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hech yu'un nixi' mi chch'ay cu'un. Hech yu'un ba jmuc ti lum ti ataq'uine. Ilo ti c'u yepal laj avac'bune yu'un ja' avu'un”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Hech i'albat yu'un ti yajvale: “Chopol avo'nton. Ho'ot ch'ajil abatot. Chacuy ti ho'on chquich' ti bu mu ho'ucun laj jts'un, ti chquich' ti bu mu ho'ucun laj quic'a. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Hech yu'un ja' lec ti lajuc avac'be ti sc'ob ti much'u chjolin yu'un ti jtaq'uine. Hech c'alal nital, laj xa quich' sutel xchi'uc ti sjole ti hechuque”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Hech yu'un ti yajval ti taq'uine, hech laj yalbe ti yan yabate: “Pojbo ti lajchamile, ac'bo ti much'u laj yich' tal ti ciento veinte mile”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yu'un scotol ti much'u i'abtej xchi'uc ti c'u yepal i'ac'bate, ti Diose chac'be más asta oy yu'un scotol. Ti much'u mu sc'an ch-abtej xchi'uc ti c'u yepal i'ac'bate, ja' chpojbat ti c'u yepal i'ac'bat ono'oxe. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ti abate ti mu sc'an x'abtej cu'une, teno loq'uel ti fuera te ti ic' osil. Te chc'o yoc'ta sba o. Te xjep'et ye o ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Hech laj yalbuntutic uc ti Jesuse: ―C'alal chital xchi'uc ti jquevale, ho'on ti co'ol crixchanoucutique, jchi'inoj talel scotol ti ch'ul abatetique, chul naclucun ti bu ti jmuc'ta naclebe yo' bu chispasucun ti muc' scotol crixchanoetic. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Chquic' tal ti jtojol scotol ti jalajuntos ti crixchanoetique. C'alal te stsoboj sbaic ti jtojol, chlic jch'ac hech chaj c'u che'el ti much'u jpaxtol chch'ac ti scarneroe xchi'uc ti xchivoe. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ti jcarneroe chcac' ti jbats'ic'ob. Ti chivoe chcac' ti jts'et. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ho'on ti ajvalilune hech chcalbe ti much'utic te oyic ti jbats'ic'obe: “La'ic me, avich'ojic bendición yu'un ti Jtote. Ochanic ti pasmantal yu'un vo'one c'alal ilic ti balumile hech chapambil ac'opilal ti chapasique. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yu'un c'alal nivi'naj, laj amac'linun. C'alal itaquij co'nton, laj avac'bun ho' chcuch'. C'alal nom nital, laj avic'un ochel ti ana. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","C'alal t'analun, laj avac'bun jc'u' jpoc'. C'alal jchamelun, tal aq'uelun. C'alal tiq'uilun ti chuquel, tal ac'oponun”, chcut. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Hech chtac'av ti much'utic toj yo'ntonique: “Cajval, ¿c'usi ora laj quiltutic ti navi'naje ti laj jmac'linotutic ti chavale? ¿C'usi ora laj quiltutic ti itaquij avo'ntone ti laj cac'bot ho' laj avuch' ti chavale? ");
INSERT INTO tzoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿C'usi ora laj quiltutic ti nom natale ti laj quic'ot ochel ti jnatutic ti chavale? ¿C'usi ora laj quiltutic ti t'analote ti laj cac'bot ac'u' apoc' ti chavale? ");
INSERT INTO tzoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿C'usi ora laj quiltutic ti jchamelote, ti tiq'uilot ti chuquele, ti tal jc'oponot ti chavale?” xchiic hech chalic. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Chitac'av ho'oni ti Ajvalilune, hech chcalbe: “Melel ti c'usi chacalbeique, yu'un hech laj ac'uxubinic jun quermano ti mu tsotsuc yabtel yich'oje, ho'on me laj ac'uxubinun obi”, chcut. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Ho'on ti Ajvalilune hech chcalbe ti much'utic te oyic ti jts'ete: “Loc'anic ti jtojol yu'un chopol avo'ntonic. Batanic ti yo' bu oy c'oc' sbatel osil. Ti c'oq'ue ja' chapambil cu'un yu'un te ch-och batel ti totil pucuje xchi'uc ti xchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yu'un c'alal nivi'naj, muc xamac'linun. C'alal itaquij co'nton, muc xavac'bun ho' yu'un chcuch'. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","C'alal nom talemun, muc xavic'un ochel ti ana. C'alal t'analun, muc xavac'bun jc'u' jpoc'. C'alal jchamelun, c'alal tiq'uilun ti chuquel, muc xtal ac'oponun”, chcut. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hech chtac'avic: “Cajval, ¿c'usi ora laj quiltutic ti navi'naje, ti itaquij avo'ntone, ti nom natale, ti t'analote, ti jchamelote, ti tiq'uilot ti chuquele ti muc xajc'uxubinotutic ti chavale?” xchiic hech chalic. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hech chcalbe: “Melel ti c'usi chacalbeique, yu'un muc xac'uxubinic mi junuc ti much'utic mu tsotsuc yabtel yich'oj ti chcale, ho'on muc xac'uxubinun obi”, chcut. ");
INSERT INTO tzoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hech chba yich'ic castigo sbatel osil. Ti much'utic toj yo'ntonique ja' chcuxiic sbatel osil ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","C'alal laj yo'nton hech laj yalbuntutic scotol ti sc'opilale ti Jesuse, ho'ontutic ti yajchanc'opuntutique, patil hech laj yalbuntutic uc: ");
INSERT INTO tzoNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Chana'ic ti chib xa no'ox c'ac'al tsc'an tsta yorail q'uin Pascua. Hech yu'un ti mero q'uin chi'ac'at entrecal ho'on ti co'ol crixchanoucutique yu'un hech chismilucun ti cruz ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ti totil paleetique xchi'uc ti yan jchi'iltic ti ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti moletic cu'untique, ho'ucutic ti judioucutique, laj stsob sbaic ti yamaq'uil sna ti mero totil palee. Ja' Caifás sbi ti totil palee. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Laj xchapambeic sc'opilal ti Jesuse c'u che'el xu' yu'unic tstsaquic ti mucul, c'u che'el tsmilic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Hech laj yalbe sbaic: ―Ja' lec mi mu jpastic ti mero q'uin. Ja'to mi i'ech' ti q'uine naca me licuc c'op yu'un ti crixchanoetique ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nibatutic ti Betania xchi'uc ti Jesuse. Te ni'ochtutic ti sna ti Simone, ja' ti Simón ti yich'oj c'a'el chamel ono'oxe ti icoltaat yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Te ital jun ants, ja' jchi'iltic. Yich'oj tal sjarro pasbil ti alabastroton. Nojem ti perfume ti sjarroe. Toyol stojol ti perfumee. Laj smalbe ti sjol ti Jesuse c'alal te nacal ti mesa. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","C'alal laj quiltutic, ho'ontutic ti yajchanc'opuntutique, ni'ilintutic. Hech laj caltutic: ―¿C'u yu'un chac' ch'ayuc avi to? ");
INSERT INTO tzoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ti lajuc xchone, ep stojol iloc' ti hechuque. Ja' lec ti lajuc yac'be ti taq'uine ti me'onetique ―xichitutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ti Jesuse laj sna' ti c'usi laj jnoptutique hech yu'un hech laj yalbuntutic: ―¿C'u yu'un chavac'be yich' mul avi ants li'to? Lec ti c'usi laj xa spasbune. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Scotol c'ac'al achi'inojic ti me'onetique. Ti ho'one mu scotoluc c'ac'al li' jchi'inojoxuqui. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ti laj scajmalbun ti jbec'tal avi perfume li'to, ja' yu'un ti po'ot xa chichame. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Melel ti c'usi chacalbeique, ti scotol balumil buc no'ox chich' cholel ti lequil ach' c'op avi to, chcholbat sc'opilal uc ti hech laj xa spasbun ti antse. Hech ch-a'ibat sc'opilal o ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ti lajchavo'untutique oy jun, ja' Judas Iscariote sbi. Ja' ba sc'opon ti totil paleetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Hech laj sjac'be: ―¿Jayib chavac'bun mi chacac'be entrecal ti Jesuse? ―xchi. I'ac'bat lajuneb xcha'vinic peso bats'i taq'uin. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hech yu'un ti Judase ti ora no'ox lic snopilan ti yo'nton ti c'usi ora xu' chac' entrecal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ti sba c'ac'alil q'uin c'alal ti jve'tic caxlan vaj ti mu pumesbiluc xch'ute, ho'ontutic ti yajchanc'opuntutique ba jac'betutic ti Jesuse: ―¿Bu chac'an chajmeltsambe ti ch'iom carnero chati' sventa q'uin Pascua? ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hech itac'av ti Jesuse: ―Batanic ti Jerusalén. Te chc'ot ac'oponic ti jun quermanotique. Hech chavalbe: “Po'ot xa chc'ot la yorail chcham ti Maestro cu'untique. Chtal la ve'ucuntutic ti ana xchi'uc ho'ontutic ti yajchanc'opuntutique, yu'un ti jpastutic q'uin pascua”, xavutic c'otel ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ho'ontutic ti yajchanc'opuntutique laj jpastutic hech chaj c'u che'el laj yalbuntutic mantal ti Jesuse. Laj jmeltsantutic scotol ti c'utic chtun cu'untutic ti q'uine. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ja'to no'ox i'ic'ub osil c'alal tal naclucuntutic te ti mesa xchi'uc ti Jesuse, ho'ontutic ti lajchavo'untutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","C'alal nive'tutic, hech laj yalbuntutic ti Jesuse: ―Melel ti c'usi chacalbeique, oy jun ti li' jchi'inojtique, ja' chiyac'un entrecal ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jcotoltutic laj quich'tutic mul. Hech yu'un lic calbetutic jujun ti Jesuse: ―Mu ho'ucun, Cajval ―xichitutic liquel jujununtutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Hech itac'av ti Jesuse: ―Ja' ti co'ol chijve'ucutic xchi'uque, ja' chiyac'un entrecal. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ho'on ti co'ol crixchanoucutique chicham hech chaj c'u che'el ts'ibabil comel jc'opilal ti sun ti Diose. Uts sba ti much'u chiyac'un entrecale ho'on ti co'ol crixchanoucutique. Ja' lec ti ma anuque ti vinique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ti much'u laj yac' entrecal ti Jesuse, ja' ti Judase. Ja' laj sjac'be ti Jesuse: ―¿Mi ho'on jc'opilal ti hech chavale, Maestro? ―xchi ti Judase. Hech itac'av ti Jesuse: ―Ho'ot ac'opilal ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","C'alal lic ve'ucuntutic, ti Jesuse laj stam jun caxlan vaj, laj yalbe vocol ti Diose, laj xet' ti caxlan vaje, laj yac'buntutic, ho'ontutic ti yajchanc'opuntutique. Hech laj yalbuntutic: ―Ilo, ve'anic. Ja' jbec'tal li'to ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Patil laj stsac jun vasyo. Te tiq'uil ya'lel sat uvate'. Laj yalbe vocol ti Diose, laj yac'buntutic. Hech laj yalbuntutic: ―Uch'anic acotolic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ja' jch'ich'el li'to. Chcac' jba ti milel, chloc' ti jch'ich'ele. Ti jch'ich'ele ja' señail ti mu xch'ay ti ach' c'op ti yaloj ti Jtote ti c'u che'el chacolique. Yu'un jtuc chcac' jba ti milel hech chch'ay smul scotol crixchanoetic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Chacalbeic, ja'to mi laj sta yorail laj jtsob jbatic jcotoltic yo' bu tspas mantal ti Jtotic Diose, ja'to chcuch'be xq'uexol ti ya'lel sat uvate'e avi to ho'oni ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","C'alal laj co'ntontutic niq'uejintutic yu'un ti Diose, niloc'tutic batel xchi'uc ti Jesuse. Nibatutic ti vits Olivatic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ti Jesuse hech laj yalbuntutic: ―Ti ora to ti ac'ubaltic acotolic chchibaj avo'ntonic ti jtojol. Yu'un hech ts'ibabil comel ti sc'op ti Diose: “Chcac' ti milel ti jpaxtole, hech chpuc batel ti scarneroe”, ti xchi ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero c'alal chicha'cusesat loq'uel ti ch'en, ho'on chibaej batel avu'unic te ti Galilea ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ti Pedroe hech laj yalbe: ―Manchuc mi chchibaj yo'nton ti atojol ti yantique, mu xchibaj co'nton ho'oni ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ti Jesuse hech laj yalbe: ―Melel ti c'usi chacalbee, ja' avi ac'ubal to c'alal tsta yorail ch-oc' quelem, laj xa amucun ti avo'nton oxib vuelta ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Hech itac'av ti Pedroe: ―Manchuc mi co'ol chismilucutic, muc chajmuc ti co'nton ―xchi. Hech laj calbetutic uc jcotoltutic, ho'ontutic ti yajchanc'opuntutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nic'otutic xchi'uc ti Jesuse te ti balumil, Getsemaní sbi. Ti Jesuse hech laj yalbuntutic: ―Comanic li'to, chba jc'opon Dios li' no'oxi ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Laj yic' batel ti Pedroe xchi'uc ti cha'vo' xnich'nab ti Zebedeoe. Laj yich' mul ti Jesuse. Lic yich' vocol. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hech laj yalbe: ―Ep chquich' mul. Ta xa xicham chca'i ―xchi―. Comanic li'to. Mu me xavayic, c'oponic Dios hech chaj c'u che'el ho'on ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ja' ijelav batel jutuc stuc ti Jesuse. Laj spatan sba ti lum. Hech laj sc'opon Dios: ―Tote, taca stac'uque, q'uejbun batel ti vocol li'to. Mu me jpas c'usi tsc'an co'nton. Ja' ac'o jpas ti c'usi sc'an ti avo'nton atuque ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Isut talel yo' bu oyic ti oxvo'ique ti jchi'iltaque. Vayajtic c'ot staic. Ti Jesuse hech laj yalbe ti Pedroe: ―¿Mi mu xu' chavic' asatic junuc ora, mi mu xu' chac'opon Dios hech chaj c'u che'el ho'on? ");
INSERT INTO tzoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mu me xavayic, c'oponic Dios, hech mu xasujat ti mulil. Ti avo'ntone oy yip. Ti abec'tale mu'yuc yip ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Icha'bat nixtoc ti Jesuse. Ja' xchibal xa vuelta. Ba sc'opon Dios nixtoc ti Jesuse: ―Tote, mi mu stac' ti chaq'uejbun ti vocol ti chquich'e, ac'o jpas ti c'usi tsc'an ti avo'ntone ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Icha'sut talel ti Jesuse. Vayajtic c'ot sta ti oxvo'ic ti jchi'iltac ti abtele yu'un chchamic ti vayel. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Laj xcha'comes, icha'bat nixtoc. Ba xcha'c'opon nixtoc ti Diose. Ja' yoxibal xa vuelta. Co'ol laj sc'opon ti Diose ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Icha'tal nixtoc yo' bu oyic ti oxvo'ic ti jchi'iltaque. Hech laj yalbe: ―¿Mi ta to xavayic? ¿Mi ta to xacux avo'ntonic? Laj xa sta yorail ti chi'ac'at entrecal ti sc'ob jmulaviletic ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Licanic, batic. Q'uelo avil, chtal xa ti much'u chiyac'un entrecale ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","C'alal yac'oj sba chc'opoj ti Jesuse, ital ti Judase. Ti Judase ja' jchi'il ti abtel. Ja' lajchavo'untutic xchi'uc, ho'ontutic ti yajchanc'opuntutic ti Jesuse. Xchi'inoj talel ep crixchanoetic yich'ojic talel yespadaic xchi'uc ste'ic. Ja' tacbil talel yu'un ti totil paleetique xchi'uc ti moletic cu'untique, ho'ucutic ti judioucutique. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ti Judase, ja' ti chac' entrecal ti Jesuse, yalojbe xa ti xchi'iltaque: ―Ja' ti much'u ti jbuts'e, ja' me obi. La' tsaquic me ti ora ju'un ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ti ora ital ti Judase, ihul ti stojol ti Jesuse. Hech laj yalbe ti Jesuse: ―Nital xa, Maestro ―xchi hulel. Laj sbuts' ju'un. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ti Jesuse hech laj sjac'be: ―¿C'usi chasa', quits'in? ―xut. Hech laj stsaquic ti Jesuse, laj yiq'uic batel. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ho'ontutic te jchi'inojtutic ti Jesuse. Oy jchi'il laj sloq'ues yespada. Laj syajesbe yabat ti totil palee. Laj sbojbe loq'uel jun xchiquin. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ti Jesuse hech laj yalbe: ―Tic'o me ti sna ti avespadae yu'un scotol ti much'u stsac yespadae, ti espada ono'ox chcham. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Mi chacuy ti mu xu' cu'un ti jc'opon ti ora ti Jtote, hech chiyac'bun talel ech'em ti oxvinic ti mil ch'ul abatetic yu'un chiscoltaun? ");
INSERT INTO tzoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ti hechuc ti jpase, mu sts'aqui ti sc'op ti Diose ti chal ti persa hech chc'ot ti pasel ―x'utat yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ti Jesuse hech laj sjac'be ti epal crixchanoetic ti italique: ―¿C'u yu'un hech tal atsacucun hech chaj c'u che'el j'elec'? Avich'ojic talel avespadaic, ate'ic. Scotol c'ac'al te nacalun ti atojolic te ti yut templo. Te nichanubtasvan laj ava'yic. ¿C'u yu'un mu teuc laj atsacucun? ");
INSERT INTO tzoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Hech scotol c'otem ti pasel yu'un tsts'aqui ti c'usi ts'ibabil ti sun ti Diose yu'un ti j'alc'opetic yu'un ti Diose ―xchi ti Jesuse. Ho'ontutic ti yajchanc'opuntutique laj jcomestutic stuc ti Jesuse, nijatavtutic batel. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ti much'u laj stsaquic ti Jesuse laj yiq'uic batel, c'ot sva'anic ti Jesuse te ti stojol ti Caifase, ja' ti mero totil palee. Te stsoboj sbaic ti much'utic ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti moletique. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ti Pedroe nomtic to xbat. Ic'ot yo' bu yamaq'uil sna ti mero totil palee. Te i'och batel. C'ot xchi'in ti naclej ti abatetic yu'un ti totil palee yu'un tsc'an tsq'uel c'u che'el chchapanat ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ti totil paleetique xchi'uc scotol ti much'utic oy yabtelic cu'untique ho'ucutic ti judioucutique, laj sa'ic much'utic tsnopbeic smul ti Jesuse yu'un tsc'an tsmilic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Muc staic. Hovil ti tal sva'an sbaic ti jnopc'opetique. Ti patil ital yan cha'vo' jnopc'opetic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Hech laj yalic: ―Hech laj yal avi vinic li'to: “Ho'on xu' ti jin ti templo yu'un ti Diose. Ti oxib no'ox c'ac'al xu' ti jcha'pas nixtoc”, xchi ti vinic li'to ―xchiic. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Laj sva'an sba ti mero totil palee. Hech laj sjac'be ti Jesuse: ―¿C'u yu'un mu xatac'av? ¿Mi melel ti c'usi chal ti viniquetique? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Muc xtac'av ti Jesuse. Ti mero totil palee hech laj xcha'jac'be nixtoc ti Jesuse: ―Albun ca'itutic ti stojol ti Diose ti stalel cuxule, ¿mi melel ti ho'ot ti Cristoote ti t'ujbilot yu'un ti Diose? ¿Mi ho'ot snich'onot ti Diose? ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Hech itac'av ti Jesuse: ―Ho'on ―xchi―. Chacalbeic uc, ti yan c'ac'al chaq'uelucun, ho'on ti co'ol crixchanoucutique, ti te nacalun ti sbats'ic'ob ti Diose, ja' ti jelaven sp'ijile. Chaq'uelic ti chiyal tal ti vinajel xchi'uc toc ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ti mero totil palee laj sjat sc'u'. Yu'un ti laj sjat sc'u'e, yu'un tsots smul laj sta ti Jesuse tscuy. Hech laj yalbe ti crixchanoetique: ―Va'i Dios tscuy sba. ¿C'u yu'un ti jc'antic yan rextico? Laj xa ava'yic ti tstoy sba ti stojol ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿C'usi chanopic? ―xut. Hech itac'avic: ―Ja' lec ac'o chamuc ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Laj stubtabeic sat ti Jesuse, ti yane laj smajic, ti yane laj smajbeic sat. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Hech laj yalic: ―Alo ca'itutic, Cristo, much'u laj smajoti ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ti Pedroe te nacal ti amac'. Hul c'oponatuc yu'un jun quiara: ―Ho'ot laj achi'in ti Jesuse, ja' ti liquem tal ti Galileae ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ti Pedroe laj smuc ti yo'nton ti stojol scotolic. Hech itac'av: ―Mu jna' ti c'usi chavale ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Iloc' batel ti corredor ti Pedroe. Te i'ilat yu'un yan quiara. Ti quiarae hech laj yalbe ti much'utic te va'ajtique: ―Ja' ti vinic li'to ja' laj xchi'in ti Jesuse, ja' ti liquem tal ti Nazarete ―xchi. Ja' sc'opilal ti Pedroe. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ti Pedroe laj sva'an ti rextico ti Diose, hech laj xcha'muc yan vuelta ti yo'nton: ―Yiloj ti Diose mu xcojtiquin ti vinic ti chavale ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","J'oc' to no'ox ital yan. Hech laj yalbeic ti Pedroe: ―Ho'ot achi'inoj abaic xchi'uc yu'un chvinaj ti ac'op bu liquemot tal ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hech yu'un ti Pedroe yan vuelta laj sva'an ti rextico ti Diose. Hech laj yal: ―Yiloj ti Diose mu xcojtiquin ti vinic ti chavale ―xchi. Ja' yorail i'oc' quelem. ");
INSERT INTO tzoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ti Pedroe it'ab ti yo'nton ti c'u che'el i'albat yu'un ti Jesuse: “C'alal tsta yorail ch-oc' quelem, laj xa amucun ti avo'nton oxib vuelta”, ti x'utate. Hech iloc' batel ti Pedroe. Ep laj yoc'ta sba. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ti yoc'omal c'alal isacub xa ti osile, scotol ti totil paleetique xchi'uc scotol ti moletic cu'untique, ho'ucutic ti judioucutique, laj xchapambeic sc'opilal ti Jesuse ti c'u che'el tsmilique. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Chucul laj yiq'uic batel. Laj yaq'uic entrecal ti stojol ti gobernadore. Ja' Poncio Pilato sbi ti gobernadore. Ja' yanlum vinic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ti much'u laj yac' entrecal ti Jesuse, ja' ti Judase, c'alal laj yil ti ichapaj sc'opilale, lic sutes yo'nton. Sc'an to sutesbe ti lajuneb xcha'vinic peso bats'i taq'uin ti totil paleetique xchi'uc ti moletique. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Hech c'ot yalbe: ―Laj jta jmul yu'un laj cac' entrecal ti much'u mu'yuc smule ―xchi c'otel ti Judase. Hech i'albat: ―Mu jventauc ti ho'ontutique. Ja' amul atuc ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ti Judase laj sten comel ti yut templo ti taq'uine. Iloc' batel. Stuc ba sut' snuc' ti lazo. Te laj smil sba. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hech yu'un ti totil paleetique laj stamic ti taq'uine. Hech laj yalbe sbaic: ―Mu xtun mi ti jcaptic xchi'uc smoton Dios avi taq'uin li'to yu'un ja' stojol xch'ich'el sbec'tal jun vinic ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hech yu'un laj xchapanic ti tsmanic jtuch' balumil. Ja' jpasp'in ti yajval ti balumile. Laj smanic sventa campo santo. Ja' te tsmuquic ti much'utic nom chtalique. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hech yu'un ch'ich' balumil ic'ot sbi ti balumile. Ja' hech sbi ti ora to. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hech ic'ot ti pasel hech chaj c'u che'el laj yal ti Jeremíase, ja' ti j'alc'op yu'un ti Diose. Hech laj yal: “Chich'ic sutel ti lajuneb xcha'vinic pesoe. Ja' hech stojol ti much'u hech stojol ic'ot yu'un ti jchi'iltique, ho'ucutic ti yelnich'onucutic ti Israele. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tsmambeic sbalumil ti jpasp'ine hech chaj c'u che'el laj xa yalbun ti Cajvaltic Diose”, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Va'al ti Jesuse ti stojol ti gobernadore. Hech ijac'bat yu'un ti gobernadore: ―¿Mi ho'ot ajvalilot yu'un ti achi'iltaque, ho'oxuc ti judiooxuque? ―xut. Hech itac'av ti Jesuse: ―Ho'on ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","C'alal isa'bat smul ti Jesuse yu'un ti totil paleetique xchi'uc ti moletique, mu'yuc c'usi laj yal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Hech yu'un hech i'albat yu'un ti Pilatoe: ―¿Mi muc xava'i ti ep sa'bilot amule? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mi jutuc muc xtac'av ti Jesuse. Hech yu'un ich'ay yo'nton ti gobernadore. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hech stalel o ti yorail q'uin tscolta batel jchuquel ti jujun habil ti gobernadore. Tscolta ti much'u tsc'an ti jchi'iltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Oy to ono'ox jun jchuquel ti puquem sc'opilale, ja' Barrabás sbi. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hech yu'un c'alal te stsoboj sbaic ti jchi'iltique, hech ijac'batic yu'un ti Pilatoe: ―¿Much'u junucal chac'anic ti jcolta batel? ¿Mi ja' chac'anic ti jcolta batel ti Barrabase? ¿Mi ja' chac'anic ti jcolta batel ti Jesuse, ja' ti Cristo x'utate, ja' ti t'ujbil yu'un ti Diose? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yu'un sna'oj ti Pilatoe ti scoj sbic'tal yo'ntonic ti laj yaq'uic entrecale. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","C'alal te nacal ti gobernadore yo' bu chchapambe sc'opilal yu'un smul ti crixchanoetique, itacbat tal c'op yu'un ti yajnile. Hech i'albat tal: “P'ijan me xchi'uc ti vinic lume, ja' ti toj yo'ntone, yu'un ti jvaich nax ep laj quich' vocol yu'un”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ti totil paleetique xchi'uc ti moletique laj stsob sc'opic xchi'uc ti jchi'iltique ti ja' ac'o sc'ambeic ti Pilatoe ti chcol ti Barrabase, yu'un ac'o milatuc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ti gobernadore hech laj xcha'jac'be nixtoc: ―¿Much'u junucal chac'anic ti jcolta batel? ―xut. Scotolic hech itac'avic: ―Ja' ac'o coluc ti Barrabase, ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ti Pilatoe hech laj xcha'jac'be: ―¿C'usi chcutic ti Jesuse, ja' ti ac'bil sbi Cristoe yu'un t'ujbil yu'un ti Diose? ―xchi. Hech itac'avic scotolic: ―¡Milo ti cruz! ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ti gobernadore hech laj sjac'be: ―¿C'u yu'un? ¿C'usi smul avu'unic? ―xchi. Más tsots ic'opojic scotolic: ―¡Milo ti cruz! ―xchiic scotolic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Laj yil ti Pilatoe ti mu xch'umbat ti sc'ope, ti ep ilic c'op yu'unic o. Hech yu'un laj smal ho' spoc sc'ob ti stojol ti jchi'iltique. Hech laj yalbe: ―Mu jmuluc mi chmilat ti vinic li'to ti toj yo'ntone. Ja' aventa atuquic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hech itac'avic scotolic: ―Ja' jventatutic jcotoltutic xchi'uc col jnich'ontutic ti chmilate ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ti Pilatoe laj scolta batel ti Barrabase. Ti Jesuse i'ac'at entrecal yu'un chich' acial, yu'un chba milatuc ti cruz. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ti yajsoldado ti gobernadore laj yiq'uic ochel ti cabildo ti Jesuse. Te laj stsob sbaic tal ti stojol ti Jesuse scotol ti soldadoetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Laj st'ananic ti Jesuse. Laj slapbeic poco tsajal c'u'il. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Laj yac'beic pech'bil ch'ix ti sjol. Laj yac'beic jch'ix aj ti sbats'ic'ob. Laj squejan sbaic ti stojol. Hech laj slabanic: ―Ho'ot ajvalilot mati yu'un ti achi'iltaque, ho'oxuc ti judiooxuque ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Laj stubtabeic sat. Laj spojbeic ti aje. Laj smajbeic ti sjol. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","C'alal laj yo'nton ti laj slabanique, laj sloq'uesbeic ti tsajal c'u'ile. Laj xcha'lapbeic sc'u' nixtoc. Laj yiq'uic batel, ba smilic ti cruz. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","C'alal iloq'uic batel, c'ot snup ti be jun jchi'iltic liquem tal ti balumil Cirene sbi. Simón sbi ti vinique. Laj yac'beic sq'uechbe batel scruz ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ic'otic ti vits Gólgota sbi, ja' ti Baquel Jolal sbie. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Laj yac'beic yuch' vinagre capbil xchi'uc c'usi lum ch'a. Laj spas proval ti Jesuse, muc sc'an xuch' yu'un smacobil sc'uxul. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hech yu'un ti soldadoetique laj sjoc'anic ti cruz. Patil laj spasic al chil ti much'u chc'ot ti sventa ti sc'u' spoc' ti Jesuse. Hech ono'ox ic'ot ti pasel ti sc'op ti yaj'alc'op ti Diose. Hech laj yal: “Chch'acbe sbaic jc'u' jpoc'. Tspasic al tsq'uelic ti much'u chc'ot ti stojol ti jc'u'e”, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Te inaquiic ti soldadoetique, laj xchabiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Te pac'bil yu'unic ti sjol scruz yo' bu ts'ibabil c'usi smul ti Jesuse. “JA' JESUS LI'TO, JA' TI TOTIL AJVALIL YU'UN TI JUDIOETIQUE”, xchi ts'ibabil ti sjol scruz. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Te laj sjoc'anic uc cha'vo' j'eleq'uetic. Ja' laj xchi'in ti Jesuse, jun ti sbats'ic'ob, jun ti sts'et ti scruz ti Jesuse. Cacal ti o'lol ti scruz ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Scotol ti much'u i'ech' ti bee laj slabanic. Laj sjim sjolic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Hech laj yalbeic: ―Ho'ot ti chajin ti temploe, ti chacha'pas ti oxib no'ox c'ac'al chavale, coltao aba quiltic. Mi melel ti snich'onot ti Diose, yalan tal ti cruz che'e ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Co'ol ilabanvanic ti totil paleetique xchi'uc ti much'utic ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti moletique. Hech laj yalic: ");
INSERT INTO tzoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ep ti much'u laj scoltae. Tana mu xu' scolta sba. Mi melel ti ja' ajvalil cu'untic, ho'ucutic ti yelnich'onucutic ti Israele, ac'o yaluc tal ti cruz ti ora to, hech ti jch'untic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xch'unojbe sc'op ti Diose ti scuyoje. Hech yu'un mi c'ux x'a'yate ac'o yich' coltael yu'un ti Diose ti ora to. Yu'un hech yaloj: “Ho'on snich'onun ti Diose”, xchi ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Co'ol laj spasic uc ti j'eleq'uetique, ja' ti much'u co'ol ijoc'anatic ti cruz xchi'uc ti Jesuse. Laj slabanic uc. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ti o'lol c'ac'al i'ic'ub ti osile. Ic'uben icom oxib ora. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ti oxib ora mal c'ac'al tsots ic'opoj ti Jesuse: ―Elí, Elí, ¿lama sabactani? ―xchi. Dios cu'un, Dios cu'un, laj xa acomesun, xchi c'alal jelavesbil. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Laj ya'yic cha'vo' oxvo' ti much'utic te va'ajtique. ―Ja' chic' tal ti Elíase ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jun ibat ti anil, ba stam talel esponja. Laj sts'aj ti vinagre ti esponjae, laj slic muel ti te', laj yac'be sts'uts'un ti vinagree ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hech i'albat yu'un ti yantique: ―Malao to, jq'ueltic mi chtal coltaatuc yu'un ti Elíase ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ti Jesuse tsots ic'opoj yan vuelta. Hech icham. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ti muc'ta poc' te joc'ambil ti yut ti temploe te ti Jerusalene, ja' ti velo sbie, ijat ti o'lol. Ja' ijat yal tal ti cajale. Cha'lic ic'ot. Tsots inic ti balumile, ijav ti ch'enetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ijam ti pujul ch'enetic yo' bu mucajtic ti ánimaetique. Ep icha'cuxiic ti much'utic oyic ti stojol ti Diose ti vayemic xa ti sbec'talique. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Muc xloq'uic tal ti ch'en ti ora. Ja'to c'alal icha'cuxi xa loq'uel tal ti ch'en ti Jesuse, ja'to iloq'uic tal ti ch'en uc. I'ochic batel ti yut jteclum. Te ba yac' sbaic ti q'uelel ti stojol ep crixchanoetic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ti capitan soldadoe xchi'uc ti yajsoldadoetique ti te chchabiic ti Jesuse, laj ya'yic ti inic ti balumile. Laj yilic c'usi ic'ot ti pasel. Toj xi'el ic'otic. Hech laj yalbe sbaic: ―Melel ti ja' snich'on Dios avi li'to ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Te oy ep antsetic uc. Nom va'ajtic te tsq'uelic ti Jesuse c'alal te jipil ti cruze. Ja' ti antsetique ti laj xchi'inic ti Jesuse ti laj smac'linic te ti Galilea. Hech yu'un laj xchi'inic talel ti Judea. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Te oy uc ti Maríae ja' ti liquem tal ti jteclum Magdalae, xchi'uc ti yan Maríae, ja' ti sme' ti Jacoboe xchi'uc ti Josee. Te oy uc ti sme' ti Jacoboe xchi'uc ti Juane, ja' ti xnich'nab ti Zebedeoe. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mal xa c'ac'al ital jun jchi'iltic. Lum jc'ulej ti vinique. Ja' liquem tal ti jteclum Arimatea sbi. José sbi ti vinique. Ja' xch'unojbe sc'op uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","C'ot sc'opon ti Pilatoe. Laj sc'ambe stacopal ti Jesuse. Ti Pilatoe laj yal mantal ac'o ac'batuc ti stacopale. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ti Josee laj yich' batel ti stacopal ti Jesuse. Laj xpix ti saquil poc'. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Laj yac' ti yut ach' ch'en yu'un. Jombil ti ton ti ch'ene. Laj sbalch'un talel muc'ta ton, hech laj smac ti ch'ene. Ibat ju'un. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Te nacajtic icomic nopol sti' ti ch'ene ti Maríae ja' ti liquem tal ti Magdalae xchi'uc ti yan Maríae. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ti yoc'omal c'alal i'ech' xa ti sc'ac'alil c'alal yorail ti jchapan jbatic yu'un ti jchabitic ti sábadoe, laj stsob sbaic tal ti stojol ti Pilatoe ti totil paleetique xchi'uc ti fariseoetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Hech laj yalbeic ti Pilatoe: ―Tote, ho'ontutic ti jna'tutic ti hech laj yal ti jlo'lavaneje c'alal cuxul to: “Chicha'cuxi ti yoxibal c'ac'al”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hech yu'un paso me mantal lec ac'o yich' chabiel ti ch'ene ja'to mi its'aqui ti oxib c'ac'ale naca me tal sloq'uesbeic stacopal ti ac'ubaltic ti yajchanc'opetique, naca me yalbe ti crixchanoetique: “Icha'cuxi loq'uel ti ch'en”, naca me xchiic. Hech más xu' chlo'laatic ti crixchanoetique ―xchiic ti paleetique xchi'uc ti fariseoetique, xut ti Pilatoe. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ti Pilatoe hech laj yalbe: ―Te oy soldadoetic, iq'uic batel. Xana'ic c'usi chavutic chachabiic lec ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hech ba smaquic lec ti ch'ene. Te laj yac'be comel sello ti xocon ton. Te laj yaq'uic comel ti soldadoetique yu'un chchabiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","C'alal ech'em xa ti sc'ac'alil ti jcux co'ntontic c'alal po'ot xa tsacub ti osile ti sba c'ac'alil ti semanae, ja' ti domingoe, tal sq'uelic ti ch'ene ti Maríae, ja' ti liquem tal ti jteclum Magdalae, xchi'uc ti yan Maríae. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","C'alal mu to chloq'uic tal, tsots inic ti balumile. Iyal tal ti vinajel xch'ul abat ti Cajvaltic Diose. C'ot sbalch'un loq'uel ti tone. Te inaqui ti sba ti tone. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Xleblej talel ti ch'ul abate hech chaj c'u che'el ti tselove. Lum sac sc'u' yu'un muc xtup' ti squevale. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Iniquic ti jchabiejch'enetique yu'un toj xi'el ic'otic. Hech chaj c'u che'el ánimaetic ic'otic. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ti ch'ul abate hech laj yalbe ti antsetique: ―Mu me xaxi'ic. Jna' ti ja' chasa'ic ti Jesuse, ja' ti icham ti cruze ―xchi―. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mu xa li'uqui yu'un cha'cuxem xa loq'uel ti ch'en hech chaj c'u che'el laj yal ono'oxe ―xchi―. La'ic, la' q'uelo avilic ti bu laj yaq'uic ono'ox ti stacopal ti Cajvaltique. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Batanic ti ora, ba albeic ti yajchanc'opetique ti icha'cuxi xa loq'uel ti ch'en ―xut―. Ja' chbaej batel avu'unic te ti Galilea. Te chc'ot aq'uelic. Laj xa calboxuc ava'yic ―x'utatic yu'un ti ch'ul abate. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Toj xi'el ic'otic ti antsetique. Iloq'uic ti ora ti ch'en, italic ti anil. Nichim no'ox yo'ntonic talel, tal yalbuntutic ho'ontutic ti yajchanc'opuntutic ti Jesuse ti c'utic laj sq'uelique. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","C'alal yac'oj sba chanavic talel yu'un chtal yalbuntutic, te laj snupic ti be ti Jesuse. ―¿Bu chabatic? ―x'utatic yu'un ti Jesuse. Ti antsetique laj squejan sbaic ti stojol ti Jesuse, lic smeybeic yacan. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ti Jesuse hech laj yalbeic: ―Mu me xaxi'ic. Batanic, ba albo ya'yic ti quermanotique ti ac'o batuc te ti Galilea. Te chc'ot sq'uelucun ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","C'alal ibatic ti antsetique, ic'otic xa uc ti jteclum cha'vo' oxvo' ti jchabiejch'enetique. C'ot yalbeic ti totil paleetique scotol ti c'usi ic'ot ti pasele. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Laj stsob sbaic ti paleetique xchi'uc ti moletique, laj snopic c'usi tspasic. Laj yac'beic ep taq'uin ti soldadoetique. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Hech laj yalbeic: ―Hech chavalic: “Ital ti ac'ubaltic ti yajchanc'opetique, tal sloq'uesbeic batel sbec'tal c'alal vayaluntutic”, xachiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mi laj ya'i ti gobernadore hech chaj c'u che'el laj calbote, ho'ontutic chba jlajesbetutic yo'nton avu'unic. Hech mu xasmiloxuc ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ti soldadoetique laj yich'ic ti taq'uine. Laj spasic hech chaj c'u che'el i'albatic. Hech ipuc batel sc'opilal. Asta ti ora to hech xch'unojic ti jchi'iltique, ho'ucutic ti judioucutic xchi'uque. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nibatutic ti Galilea, ho'ontutic ti yajchanc'opuntutic ti Jesuse. Buluchvo'untutic nibatutic. Nic'otutic ti vits yu'un hech laj yalbuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","C'alal c'o jtatutic ti Jesuse, laj jquejan jbatutic ti stojol. Oy cha'vo' oxvo'untutic ti mu jch'untutic ti lec ti ja' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ti Jesuse hech laj yalbuntutic: ―Scotol ac'bilun jventain ti vinajele ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hech yu'un batanic me, ba cholbo ya'yic jc'op scotol crixchanoetic. Ba sa'bun tal ti much'utic chixch'umbun ti jc'ope. Ac'bo yich'ic ho' ti sventa ti Jtote, xchi'uc ti jventa uc ho'on ti Nich'onilune, xchi'uc ti sventa ti Ch'ul Espíritue hech chvinaj ti ja' cu'un. ");
INSERT INTO tzoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chanubtaso hech chixch'umbun scotol ti jmantale ti laj xa calboxuc ava'yique. Ti ho'one scotol c'ac'al chajchi'inoxuc c'alal ti slajebal ora ―xiyutuntutic ti Jesuse.");
INSERT INTO tzoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ja' hech ilic ti sc'opilal ti Jesucristoe, ja' ti Snich'on ti Diose. Ja' ti lequil ach' c'ope. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hech ono'ox ts'ibabil comel yu'un ti Isaíase, ja' ti j'alc'op yu'un ti Diose ti vo'one: A'yo me ava'i, ho'on Diosun, ti jtac batel ti j'alvanej cu'une. Ja' chbaej avu'un. Ja' chasmeltsambot abe, xchi ti Diose, xut ti Cajvaltique. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chlic jun jchi'iltic tsots chc'opoj ti xocol balumil. Hech chal: “Chtal xa ti Cajvaltique, hech yu'un comesic ti c'usi chasbolibtasoxuque”, chlic yut ti xchi'iltaque, xchi ti Isaíase. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Hech ital ti Juane. Te ti xocol balumil tal yac'be yich'ic ho' ti jchi'iltaque, ho'on ti co'ol judioun xchi'uque. Laj xcholbe ya'yic sc'opilal ti ich'ho'e ti ja' chch'aybat smul ti much'utic tsutes yo'ntonic yu'un ti smulique ti chich'ic ho'e. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ba ya'ibeic sc'op ti Juane scotol ti jchi'iltaque ti te nacajtic ti estado Judea, xchi'uc ti te nacajtic ti jteclum Jerusalén. Jamal c'ot yalic ti stojol ti Juane ti c'usi smulic jujun. Hech yu'un i'ac'batic yich'ic ho' yu'un ti Juane te ti uc'um Jordán. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ti Juane slapoj sc'u' meltsambil ti stsotsil camello. Xchucoj xch'ut ti xincha. Ti sve'ele puru c'ulub xchi'uc ajapom. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hech laj xcholbe ya'yic ti jchi'iltaque: ―Oy much'u patil chtal. Ja' tsots yabtel yich'oj. Ho'oni mu tsotsuc cabtel quich'oj. Ma mi sjitumbeluc yaq'uil sempat, mu'yuc c'usi xu' ti jcolta mi jutuc. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ho'oni ja' no'ox cabtel chacac'be avich'ic ho'. Ti chcale, ja' chayac'boxuc avich'ic ti Ch'ul Espíritue ―xchi ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hech yorail iloc' batel ti jteclum Nazaret ti Jesuse. Te oy ti estado Galilea ti Nazarete. Ic'ot ti uc'um Jordán ti Jesuse. Te i'ac'bat yich' ho' yu'un ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","C'alal iloc' ti yut uc'um ti Jesuse, ti ora ijam ti vinajele laj yil ti Jesuse. Sq'ueloj iyal tal ti sba ti Ch'ul Espíritue. Jun to culajte x'elan ti c'alal iyal tal ti sbae. Te icom. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ti Diose ic'opoj te ti vinajel. Hech laj yal: ―Ho'ot Jnich'onot. Lum c'uxot ti co'nton. Nichim no'ox co'nton avu'un ―xchi xc'opoj te ti vinajel. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ti ora i'ic'at batel ti Jesuse yu'un ti Ch'ul Espíritue. I'ic'at batel ti xocol balumil. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Oy jti'vanej bolom te oy. Te ihalej cha'vinic c'ac'al ti Jesuse. Te ipasbat proval yo'nton yu'un ti Satanase, ja' ti totil pucuje. Ti ch'ul abatetique ja' tal scoltael ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ti Juane itic'at ti chuquel. C'alal te tiq'uil ti Juane, ti Jesuse ibat ti Galilea, ba xcholbe ya'yic ti jchi'iltaque ti lequil ach' c'ope ti yaloj ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Hech laj yalbe ti jchi'iltaque: ―Laj xa sta yorail ti chasventaimboxuc avo'ntonic ti Diose. Suteso me avo'ntonic yu'un amulic. Ch'unic me ti lequil ach' c'ope ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ti Jesuse ixanav batel ti ti'ti'nab te ti estado Galilea. Hech laj yil ti Simone, ja' ti Pedro yan sbie, xchi'uc ti yits'ine, ja' ti Andrese. Te tstenic ochel slebic ti ho' yu'un tstsaquic choy. Ja' yabtelic o. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ti Jesuse hech laj yalbe: ―La' chi'inun batel. Ti jel avabtelic. Chba asa'bucun tal crixchanoetic ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ti ora laj scomesic ti slebique. Laj xchi'inic batel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ixanavic batel. Ti Jesuse te laj yil ti Jacoboe xchi'uc ti yits'ine, ja' ti Juane. Ja' xnich'nab ti Zebedeoe. Te tic'ajtic ti barco xchi'uc stot. Yac'oj sba tsmeltsanic slebic. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ti Jesuse hech lic yic' ti xcha'va'alique. Hech lic scomesic ti stote. Te tiq'uil icom ti barco xchi'uc ti yaj'abteletique. Ti xcha'va'alique laj xchi'inic batel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ibatic ti jteclum Capernaum sbi. C'alal ic'ot sc'ac'alil ti jcux co'ntontutic, ti Jesuse i'och ti templo yu'un ti jchi'iltaque xchi'uc ti yajchanc'opetique. Te ichanubtasvan ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ich'ay yo'ntonic ti jchi'iltaque yu'un ti c'usi laj yac' ti chanel ti Jesuse. Yu'un muc xchanubtasvan hech chaj c'u che'el ti jchi'iltaque ti chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Ja' ichanubtasvan hech chaj c'u che'el ti much'u tsots yabtel yich'oje. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Te oy ti yut templo jun jchi'il ti oy pucujetic ti yo'ntone. Tsots lic c'opojuc ti vinique. Hech laj yalbe ti Jesuse: ");
INSERT INTO tzoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Mu aventauntutic, Jesús, ho'ot liquemot tal ti Nazaret. ¿Mi yu'un tal amiluntutic? Chacojtiquin. Ho'ot Snich'onot ti Diose, ho'ot mu'yuc amul ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ti Jesuse laj spajes ti pucujetique. Tsots laj yalbe: ―Anchanic, loc'anic tal ti yo'nton ti vinique ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Toj tup'el yic' ti vinique c'alal iloc' tal ti yo'nton ti pucujetique. Tsots i'avan ti pucujetique c'alal iloq'uic tal. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Scotolic ich'ay yo'ntonic. Hech laj sjac'be sbaic: ―¿Much'u li' talem li'to? Ja' ach' avi to yu'un oy sp'ijil xu' yu'un tspas ti mantal ti pucujetique. Ch'umbil smantal yu'unic chavil ―xut sbaic ti jchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ti ora ipuc sc'opilal ti hech laj spas ti Jesuse. Ipuc ti scotol jteclumetic te ti sjoylejal ti Capernaume. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","C'alal iloc' ti templo ti Jesuse, te chbat ti sna ti Simone. Ibat xchi'uc ti Jacoboe xchi'uc ti Juane. Te oy uc Andrés, te oy Simón, yu'un jun snaic xchi'uc ti Simone. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ti sme' ti yajnil ti Simone te metsel ti svayeb. Oy sc'ac'al sbec'tal ti antse. Hech lic yalbeic ti Jesuse ti c'u x'elan ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ti Jesuse inopej batel ti yo' bu metsel ti antse, laj stsacbe sc'ob, laj snit liquel, hech inaqui ti antse. Ti ora ilamaj ti sc'ac'ale. Ti ora lic mac'linvanuc ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","C'alal imal xa ti c'ac'ale, po'ot xa ch-ic'ub ti osile, i'ic'atic talel ti stojol ti Jesuse scotol ti much'utic tsacbilic ti chamele xchi'uc ti much'utic ochem pucuj ti yo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Humul ihulic te ti ti'na scotolic xchi'uc ti jchameletique. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ep ti jchameletique ti italic ti stojol ti Jesuse. Icol yu'un scotol ti Jesuse ti c'uc no'ox chamel cha'yique. Ep italic ti much'utic ochem pucuj ti yo'ntonique. Laj sloq'ues scotol ti pucujetique ti Jesuse. Muc x'ac'at c'opojuc ti pucujetique yu'un ch-ojtiquinvan ti pucujetique ti ja' Snich'on ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ti yoc'omal ic' to ilic ti Jesuse. Iloc' batel ti jteclum, ibat ti bu mu'yuc crixchanoetic. Te laj sc'opon Dios. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ti Simone xchi'uc ti xchi'iltaque ba sa'ic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","C'alal c'o staic ti Jesuse, hech laj yalbeic: ―Scotolic chasa'ot ―xchiic c'otel. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Itac'av ti Jesuse, hech laj yalbe: ―Batic ti yan jteclumetic ti li' nopol no'oxe yu'un chba jcholbe ya'yic uc ti lequil ach' c'ope. Ja' yu'un ti talemun li'to ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hech ba xchol ti lequil ach' c'ope ti scotol jteclumetic yu'un ti estado Galilea ti Jesuse. Laj xcholbe ti yut templo yu'unic. Laj sloq'ues pucujetic uc ti ochemic ti yo'ntonic ti jchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Oy jun jchi'il yich'oj c'a'el chamel tal sc'opon ti Jesuse. Ep laj yalbe vocol ti Jesuse. Laj squejan sba ti stojol ti Jesuse, hech laj yalbe: ―Mi chac'ane, xu' chichop avu'un ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ti Jesuse laj xc'uxubin, laj yac' sc'ob laj yac'be ti sjol ti vinique. Hech laj yalbe: ―Hechuc, chopan ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","C'alal hech laj yal ti Jesuse, ti ora ichop ti vinique ti c'a'el chamel cha'ie. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ti Jesuse laj staq'ui batel ti vinique. Hech laj yalbe: ");
INSERT INTO tzoNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Mu me much'u chavalbe ya'i. Batan, ba ac'o aba ti q'uelel ti stojol ti palee. Ac'bo smoton ti Diose hech chaj c'u che'el laj yal ti Moisese. Hech tsna'ic ti jchi'iltique ti nacol xae ―x'utat batel yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hech iloc' batel ti vinique. Hech lic xcholbe ya'yic scotolic ti c'u che'el icoltaat yu'un ti Jesuse. Ep laj spuc batel ti lequil abtel tspas ti Jesuse. Hech yu'un ti Jesuse mi ch-och batel ti jun jteclum, mucul ch-och batel. Hech yu'un te ixanav ti bu mu'yuc crixchanoetic. Hech iloc' tal scotol ti crixchanoetic ti jujun jteclum, ba staic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","C'alal i'ech' chib oxib c'ac'al, patil icha'och yan vuelta ti yut Capernaum ti Jesuse. I'a'yat ti Jesuse ti ihul xa ti bu chvay ono'oxe. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ti ora laj stsob sbaic tal te ti stojol ti Jesuse ti jchi'iltaque. Inoj ti jyalel ti yut nae xchi'uc ti sti' nae. Mu xa spas bu tsva'an sbaic. Hech yu'un ti Jesuse lic xcholbe ya'yic ti sc'op ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Oy jchi'iltac italic spoyojic talel jun jchamel vinic. Ja' jchi'il uc. Sicuben yacan ti vinique. Chanvo' ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mu xu' chjelavic batel ti bu oy ti Jesuse yu'un tsinil ti crixchanoetique. Hech yu'un imuic ti jolna. Pamal ti jolnae. Hech yu'un lic sjomic jutuc ti jolnae ti bu stojol oy ti Jesuse. C'alal ijom yu'unic, laj sliquic yalel xchi'uc spop ti jchamele ti sicuben yacane. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","C'alal laj yil ti Jesuse ti chch'unic ti viniquetique, hech laj yalbe ti jchamele: ―Tote, ch'ayem xa amul ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Te nacajtic cha'vo' oxvo' ti jchi'iltaque ti ichanubtasvan ti smantal ti Diose ti scuyoj sbaique. Hech laj yal ti yo'ntonic: ");
INSERT INTO tzoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿C'u yu'un hech chal? ¿Mi yu'un Dios tscuy sba? Mu'yuc much'u yan xu' chixch'aybucutic ti jmultique, ja' no'ox stuc ti Diose”, xchi xc'opojic ti yo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ti Jesuse laj sna' ti hech chc'opojic ti yo'ntonique hech yu'un laj sjac'be: ―¿C'u yu'un ti mu lecuc chc'opoj ti avo'ntonique? ");
INSERT INTO tzoNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Melel much'uuc no'ox xu' chal ti ch'ayem xa amul, xu' xchi. Much'uuc no'ox xu' chal uc ti lican, q'uecho batel apop, xanavan, xu' xchi. Ja' tsc'an chaq'uel ti much'u hech chc'opoje mi chc'ot ti pasel yu'un hech chaj c'u che'el chal. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Laj xa cal ti ch'ayem xa smul hech yu'un q'uelo c'usi ti jpas ti ora to yu'un hech chana' ti melel ti ho'on ti jch'ay mulil li' ti balumile, ho'on ti co'ol crixchanoucutique ―xut. Ti Jesuse hech laj yalbe ti jchamele: ");
INSERT INTO tzoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Ho'oti chacalbe, lican, balo batel apop, batan ti ana ―xut ti jchamele, xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ti ora ilic ti jchamele. Laj sq'uech batel spop, iloc' batel. Hech yu'un laj yilic scotolic. Ich'ay yo'ntonic scotolic. Lic yalbeic vocol ti Diose yu'un lec ti jyalel laj yilic ti hech ic'ot ti pasele. Hech laj yalbe sbaic: ―Mu'yuc bu hech quilojtic ti oy sp'ijil jun crixchano ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Patil icha'bat yan vuelta ti ti'nab ti Jesuse. Ep jchi'iltac laj stsob sbaic tal ti stojol. Hech yu'un lic chanubtasvanuc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Patil c'alal ixanav batel ti Jesuse, laj yil ti Levie, ja' ti snich'on ti Alfeoe. Ja' Mateo sbi ti ac'opic. Te nacal yo' bu tstojic spatanic ti jchi'iltaque. Ja' jtsobpatan ti Levie. Ti Jesuse hech laj yalbe: ―La' chi'inun batel ―xut ti jtsobpatane ja' ti batem yo'nton chlo'lavan ti taq'uine. Hech ilic ti Levie, laj xchi'in batel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Patil c'alal te nacal ti yut sna ti Levie ti Jesuse yu'un te chve', te xchi'inoj ti mesa ti Jesuse ep xchi'iltac ti Levie ti co'ol jtsobpatanetic xchi'uque xchi'uc much'utic yan oy smul i'ilatic yu'un ti fariseoetique. Teic uc yu'un tsts'acliic tal ti Jesuse. Tal xchi'inic ti naclej te ti mesa xchi'uc ti Jesuse xchi'uc ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ti jchi'iltac ti ichanubtasvan ti smantal ti Diose ti scuyoj sbaique xchi'uc ti fariseoetique c'alal laj yilic ti hech ic'ot ti pasele, hech laj yalbeic ti yajchanc'opetic ti Jesuse: ―¿C'u yu'un chchi'in ti ve'el jtsobpatanetic xchi'uc yan jp'ajmantaletic ti Maestro avu'unique? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ti Jesuse laj ya'i ti c'u che'el i'albat ti yajchanc'opetique, hech yu'un laj yalbe ti jchi'iltac ti ichanubtasvan ti smantal ti Diose ti scuyoj sbaique xchi'uc ti fariseoetique: ―Ti much'utic lec oyique, mu yu'unuc tsc'anic jun jpoxtavanej yu'un lec oyic. Ja' no'ox tsc'anic jpoxtavanej ti much'utic jchameletique. Ja' no'ox hech uc ma'uc tal jcolta ti much'utic ti jun yo'nton ti stojol ti Diose. Ja' tal quic' ti jtojol ti much'utic mu junuc yo'nton ti stojol ti Diose yu'un ac'o sutes yo'ntonic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","C'alal yorail yipanoj sbaic ti yajchanc'opetic ti Juane, ja' yorail yipanoj sbaic uc ti yajchanc'opetic ti fariseoetique yu'un co'ol xch'unojic hech chaj c'u che'el laj yipanilan sbaic ti jtatamoltutique. Ital cha'vo oxvo' ti jchi'iltaque, tal sc'oponic ti Jesuse. Hech laj sjac'beic: ―Yipanoj sbaic ti ora to ti yajchanc'opetic ti Juane xchi'uc ti yajchanc'opetic ti fariseoetique. ¿C'u yu'un mu xipan sbaic ti avajchanc'opetique ti ho'ote? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Hech itac'av ti Jesuse: ―Ti yorail tspasic q'uin ti jnupunele xchi'uc scotol ti yuts yalaltaque, mu lecuc mi chipan sbaic ti yuts yalaltaque ti c'alal te to xchi'inojic ti jnupunele. Mu hechuc sjam. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Hech yu'un ti mu xipan sbaic ti cajchanc'op ti ora to. Ja'to mi ic'ot yorail chismilucun ti cajcontrae, ja'to chlic yich'ic mul, chlic yipan sbaic ti cajchanc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Scotol ti much'u chixch'umbun ti jc'ope persa tscomes ti c'u che'el xch'unoj ono'oxe, ja' ti poco c'ope. Persa ja' chch'un scotol ti ach' c'ope. Hech chaj c'u che'el ti much'u tspac'an ti bu lajem ti sc'u'e, mu spac'an ti ach' poc' mi mu chuc'biluque. Yu'un mi mu chuc'biluc ti ach' poq'ue, yu'un ta to smuts. Hech yu'un más ep chjat ti bu pocoe. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hech chaj c'u che'el mu'yuc much'u tspul ach' vino ti yac'oj sba chyijube ti bu poco nucul ti spulobil ti vinoe. Mi hech tspase, chjat ti nucule. Lástima chmal scotol ti vinoe. J'ech'el mu xa xtun ti nucule. Ti ach' vinoe ti yac'oj sba chyijube sc'an pulel ti ach' nucule ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ti yan c'ac'al i'ech'ic ti bu ts'umbil trigo ti Jesuse xchi'uc ti yajchanc'opetique. Ja' sc'ac'alil ti jcux co'ntontutic c'alal te i'ech'ic. Ti yajchanc'opetique laj stuch'ic jp'ej cha'p'ej trigo ti c'alal te i'ech'ic. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Oy cha'vo' oxvo' ti fariseoetique laj yilic, hech lic yalbeic ti Jesuse: ―Q'uelo avil, tsp'ajic mantal ti avajchanc'opetique yu'un ja' sc'ac'alil ti jcux co'ntontic ti ora to ―x'uti ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Itac'av ti Jesuse, hech laj yalbe: ―Ho'oxuc aq'uelojic xa ti sun ti Diose ti c'usi laj spas ti Davide c'alal itsacat ti vi'nal xchi'uc ti much'utic xchi'inojique. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Chana'ic ti i'och ti templo yu'un ti Diose c'alal tiq'uil ti totil pale ti Abiatare. Laj sve' ti caxlan vaje te ti ba mesa te ti stojol ti Diose ti Davide. Manchuc mi yaloj ti Diose ti stuquic no'ox tsve'ic ti paleetique, laj sve' ti Davide. Laj yac'be sve' uc ti xchi'iltaque. Mu'yuc smulic yu'un hech laj spasic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Hech laj yalbe uc: ―Yu'un laj xch'ac ti jun c'ac'al ti Diose, yu'un ja' ti jcux co'ntontic. Mu yu'unuc laj xch'ac ti Diose yu'un chucul chijc'ot yu'un, yu'un mu'yuc c'usi xu' ti jpastic. Mu hechuc. ");
INSERT INTO tzoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hech yu'un ho'on ti co'ol crixchanoucutique, ho'on jventainoj ti sc'ac'alil ti jcux co'ntontique. Ho'on chcal ti c'usi stac' pasel ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ti yan c'ac'al c'alal i'och ti templo ti Jesuse, te oy jun vinic sicuben sc'ob. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Te oy uc cha'vo' oxvo' ti fariseoetique. Te tsq'uelic mi tscolta ti vinique ti sc'ac'alil ti jcux co'ntontutic ti Jesuse yu'un tsc'an tsa'beic smul ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ti Jesuse hech laj yalbe ti vinique ti sicuben sc'obe: ―La' va'lan li'to ti o'lol ―x'utat yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ti Jesuse hech laj sjac'be ti fariseoetic ti te va'ajtique: ―Mi ti jch'umbetic smantal ti Diose, ¿c'usi lec ti jpastic ti sc'ac'alil ti jcux co'ntontic? ¿Mi chijc'uxubinvan, mi ja' lec chijcontrainvan? ¿Mi chijcoltavan, mi ja' lec chijmilvan? ¿C'usi chanopic? ―xchi. Mi junuc muc xtac'avic. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ti Jesuse i'ilin c'alal laj sq'uelbe satic ti fariseoetic ti te joyubtabil yu'une. Laj yich' mul uc yu'un tsots ti yo'ntonique. Hech laj yalbe ti vinique: ―Xach'o ac'ob ―xut. Ti ora ichop ti sc'obe, laj xach' ti sc'obe. Lec xa oy ti sc'obe. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Iloq'uic batel ti fariseoetique, ba sc'oponic ti much'u ti lec chil sbaic xchi'uc ti Herodese. Co'ol laj xchapanic ti c'u che'el tsmilic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ti Jesuse laj sq'uej sbaic batel xchi'uc ti yajchanc'opetique. Ibatic ti ti'nab. Its'acliat batel yu'un ep crixchanoetic. Oy talemic ti estado Galilea xchi'uc ti estado Judea ti jchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Oy talemic ti jteclum Jerusalén, xchi'uc ti slumal Idumea. Oy talemic uc ti much'utic nacajtic ti slumal ti chib jteclumetic, ja' ti Tiroe xchi'uc ti Sidone. Yu'un puquem sc'opilal ti Jesuse ti jchop o abteletic tspase hech yu'un ep ti jchi'iltaque italic ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ti Jesuse hech laj yalbe ti yajchanc'opetique: ―Ja' lec chachuquic jun barco li'i hech xu' chi'och ti barco mi ep chnet'van tal ti crixchanoetique ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yu'un ep ti much'utic icol xa yu'un ti Jesuse, hech yu'un scotol ti much'utic oy svocol yu'un oy xchamelique chnet'vanic tal yu'un tsc'an tspiquic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","C'alal laj yilic ti Jesuse ti pucujetique, laj squejan sbaic ti stojol, hech tsots ic'opojic: ―Ho'ot Snich'onot ti Diose ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ti Jesuse laj spajes. Tsots laj yalbe mantal: ―Mu me xapucbun jc'opilal ti ho'on Snich'onun ti Diose ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","C'alal chbat ti vits ti Jesuse, hech lic yic' ti stojol ti jayvo'ic ti chchi'inat batel. C'alal te stsoboj sbaic ti vits, te lic st'uj ti Jesuse ti much'utic laj sc'an yu'un chchi'in scotol c'ac'al. Ti much'utic it'ujate, hech laj xchi'inic o ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Lajchavo' laj st'uj yu'un chchi'in, yu'un tstac batel yu'un chba cholbatuc ti sc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yu'un chac'be sp'ijilic yu'un tsloq'uesbeic pucujetic ti yo'ntonic ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ja' hech sbiic ti lajchavo'ique. Ja' ti Simone, ja' ti Pedro sbi i'ac'bat yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Xchi'uc ti Jacoboe ja' ti snich'on ti Zebedeoe. Xchi'uc ti yits'in ti Jacoboe, ja' ti Juane. Ti xcha'va'alique, Boanerges i'ac'batic sbi yu'un ti Jesuse. Ja' hech chaj c'u che'el chtil chavuc, ti xchi ti sbiique yu'un tsc'an chac' castigo ti ora stuquic ti cha'vo'ique. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Xchi'uc ti Andrese, xchi'uc ti Felipee, xchi'uc ti Bartolomee, xchi'uc ti Mateoe, xchi'uc ti Tomase, xchi'uc ti yan Jacoboe, ja' ti snich'on ti Alfeoe, xchi'uc ti Tadeoe, xchi'uc ti yan Simone, ja' ti laj xchi'in ti zeloteetic ono'oxe. Yu'un ti zeloteetic sbiique ja' yu'un ti toyol yo'ntonic mu sc'an x'ochic ti mozoil yu'un ti romaetique ono'oxe. Ja' cananetic sbiic ti jc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Xchi'uc ti Judas Iscariotee, ja' ti laj yac' entrecal ti Jesuse. Ti c'alal laj xa st'uj ti lajchavo'ique ti Jesuse, scotolic ibatic ti na ti bu chvay ono'ox ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Laj xcha'tsob sbaic tal yan vuelta ti crixchanoetique. Yu'un laj stsin sbaic tal, hech yu'un mu xa spas chve'ic ti Jesuse xchi'uc ti yajchanc'opetique yu'un inoj ti jyalel ti nae. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","C'alal laj ya'yic ti yuts yalaltac ti Jesuse ti stsinoj sbaic ti crixchanoetique te ti nae, tsc'an chtal yic' batel yu'un laj scuyic ti chujuben sjol ti Jesuse yu'un ti hech tspase. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Te oyic cha'vo' oxvo' ti jchi'iltac ti ichanubtasvan ti smantal ti Diose ti scuyoj sbaique. Te talemic ti Jerusalén. Ja' laj yalic: ―Te tiq'uil ti yo'nton ti Satanase, ja' ti totil pucuje. Hech yu'un ti xu' yu'un tsloq'ues pucujetic ti yo'ntonic crixchanoetic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hech yu'un ti Jesuse laj yic' tal ti stojol ti jchanubtasvanejetique ti scuyoj sbaique. Hech lic yalbe lo'il. Oy sjam ti lo'il ti laj yalbee. Hech laj yalbe: ―Ti Satanase ¡bu ba sc'an sloq'ues ti xchi'ile! ");
INSERT INTO tzoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mi tscontrain sbaic ti much'utic ochemic ti pas mantal ti jun no'ox gobiernoe, chjin ti gobiernoe. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mi tscontrain sbaic ti much'utic jun no'ox snaic, mu xcuxiic ep c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ti Satanase mi tscontrain ti xchi'iltaque, ja' tsp'ev sbaic obi. Mi hech tspase, mu haluc tspas mantal. Ora chtenat loq'uel. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ti much'u tsc'an ch-och ti sna c'oc' vinic yu'un chelc'ambe batel c'usi oy yu'un, persa chchuc jbael ti c'oc' vinique. Patil xu' chelc'ambe batel c'usi oy yu'un te ti sna. Ti Satanase hech chaj c'u che'el ti c'oc' vinique. Pero laj xa jtsal ho'oni. Laj xa jpojbe ti sc'ob ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Melel ti c'usi chacalbeique, scotol ti much'utic chopol ti c'usi tspasique, chopol ti c'usi chalique, chopol ti c'usi tsnopique, oy to perdón mi tsc'anique. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ja' no'ox ti much'u ti chopol chc'opoj yu'un ti Ch'ul Espíritue, mu'yuc xa perdón. Ja' ch-ac'batic stoj sbatel osil ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yu'un ti hech laj yal ti Jesuse, yu'un laj yalic hech: ―Oy pucuj ti yo'nton ―xchiic. Mu xch'unic ti ja' ventaimbil yo'nton yu'un ti Ch'ul Espíritue. Hech yu'un ti hech laj yal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ital ti yits'inabtac ti Jesuse xchi'uc ti sme'e, tal sq'uelic ti Jesuse. Te va'ajtic ihul ti amac'. ―Ic'bun me loq'uel tal ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ep ti much'utic te nacajtic ti yut na. Te sjoyubtaojic ti Jesuse. Hech yu'un lic yalbeic ti Jesuse: ―Ba c'opono ti ame'e xchi'uc ti avits'inabtaque. Te va'ajtic ti amac' chasa'ot ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","35","Hech lic tac'avuc ti Jesuse: ―Hech, ja' jme', ja' quits'inab pero más tsots sc'opilal scotol ti much'u tspas ti c'usi sc'an yo'nton ti Diose. Ja' quits'in obi, ja' quixlel obi, ja' jme' obi chc'ot ―xut. Hech yu'un ti Jesuse lic sq'uelbe satic ti much'utic nopol joyubtabil yu'une. Hech laj yal: ―Ja' jme', ja' quits'inab c'otemic avi jayvo'ic li'to ―xchi. Ja' sc'opilal ti much'utic te nopol joyubtabile. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yan vuelta lic chanubtasvanuc te ti ti'nab ti Jesuse. Yu'un lum ep laj stsob sbaic tal ti jchi'iltaque, hech yu'un ba nacluc te ti yut barco ti Jesuse. Ti barcoe te ti ba ho'. Te nacajtic ti ti'ti'nab scotol ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ti Jesuse laj yalbe ya'yic ep lo'il. Oy sjam ti lo'il ti laj yalbee. Hech ichanubtasvan: ");
INSERT INTO tzoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―A'yo me ava'yic. Chacalbeic sc'opilal ti much'u ba sts'un ti strigoe. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","C'alal laj svaj ti strigoe, oy ic'ot sat strigo ti ti'be. Ital mutetic, tal stamic. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oy ic'ot sat strigo ti tontic ti bu mu'yuc ep slumal. Ti ora no'ox ich'i yu'un mu puru balumiluc. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","C'alal iq'uep ti osile, ilaj ti c'ac'al, itaquij, yu'un mu natuc ochem ti yibile. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oy ic'ot sat strigo ti ch'ixtic. C'alal ich'i ti ch'ixe, iquevtaat ti strigoe, hech muc xac' sat. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oy ic'ot sat strigo ti lequil lum. Ich'i, iyac' sat. Ja' lec laj yac' sat. Oy laj yac' sat lajuneb xcha'vinic ti p'ej, oy laj yac' sat oxvinic ti p'ej, oy laj yac' sat ho'vinic ti p'ej. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nopilanic lec hech chaj c'u che'el laj xa calboxuc ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ti c'alal ja' xa no'ox te oy ti much'utic scotol ora tsts'aclivan xchi'uc ti lajchavo'ique, hech lic sjac'beic ti Jesuse ti c'usi sjam ti lo'il ti laj yale. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ti Jesuse hech laj yalbe: ―Ti ho'oxuque ac'biloxuc ana'ic ti c'u che'el tsventaimbe yo'ntonic crixchanoetic ti Diose. Mu to oyuc much'u yan hech ya'yojic hech chaj c'u che'el ti ho'oxuque. Ti yantique ja' no'ox cha'i ti lo'ile. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hovil ti chililanique, mu ono'ox xch'unic. Hovil ti cha'ilanique, mu ono'ox xc'ot ti yo'ntonic. Hech yu'un ti ja' no'ox chcalbe lo'il. Yu'un mu sc'an sutes yo'ntonic yu'un ti smulique yu'un hech chlic ch'aybatuc smulic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Hech laj yalbe uc: ―Mi muc xava'ibeic sjam ti lo'il ti laj xa cale, ¿c'u che'el chava'ibeic sjam ti yan lo'il ti ta to xcal? ");
INSERT INTO tzoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ti much'u ba svaj ti strigoe, ja' señail ti much'u chchol ti sc'op ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ti sat strigoe ti ic'ot ti bee, ja' señail ti much'utic ya'yojic xa ti sc'op ti Diose. C'alal laj ya'yique, mu'yuc sc'opilal ti yo'ntonic hech yu'un hech xu' laj sloq'ues ti Satanase. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ti sat strigoe ti ic'ot ti bu tontique, ja' señail ti much'u ti ora no'ox chch'un c'alal cha'ibeic sc'op ti Diose. Nichim no'ox yo'ntonic yu'un laj xch'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","J'oc' no'ox te oy ti yo'ntonic. Mu xcom ti yo'ntonic. Mi chich'ic vocol, mi chich'ic ilbajinel yu'un ti sventa ti sc'op ti Diose, ti ora no'ox chchibaj yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Ti sat strigoe ti ic'ot ti bu ch'ixtique, ja' señail ti much'utic batem ti yo'ntonic ti c'utic oy li' ti balumile. Tsc'an sc'ulejal. C'usuc no'ox tsc'an. Ja' te chlo'laat yu'un ti c'usi tsc'ane. Hech yu'un ti sc'op ti Diose ti cha'ie, ja' chquevtaat yu'un ti sbic'tal yo'ntonique. Hech yu'un mu xac' sat ti sc'op ti Diose te ti yo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ti sat strigoe ti ic'ot ti bu lequil lume, ja' señail ti much'utic chac' ti yo'ntonic ti sc'op ti Diose. Tsatin ti sc'op ti Diose te ti yo'ntonique. Oy bu tsatin lajuneb xcha'vinic, oy bu tsatin oxvinic, oy bu tsatin ho'vinic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ti Jesuse hech laj yalbe uc: ―Mi jtsanoj jtojtic, muc un chcac'tic ti yolon almud, mi ti yolon jvayebtic. Ja' chcac'tic ti scuxabbil toj. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ja' no'ox hech scotol ti c'utic chajchanubtasoxuc atuquic ti ora to, oy ti aventaic ti jamal chavalic ti yan c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nopilanic lec hech chaj c'u che'el laj xa calboxuc ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ti Jesuse hech laj yalbe uc: ―A'ibo sjam ti c'utic chacalbeique. Yu'un mi chach'unic ti c'utic chacalboxuque ti scotol avo'nton, más jelaven chayac'boxuc ana'ic ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yu'un scotol ti much'u chch'un ti c'usi chcalbee, ja' ch-ac'bat sna' yan. Ti much'u mu xch'un ti c'usi chcalbee, mu'yuc xa c'usi ch-ac'bat sna' yan. Ti c'u yepal sna' tscuye, ja' chpojbat ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ti Jesuse hech laj yal uc: ―Chacalbeic ti c'utic x'elan tspasvan ti mantal ti Diose. Sna'oj stuc c'u che'el ch-abtej hech chaj c'u che'el ti trigo ti laj smuc ti slum jun vinic. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ti vinique ja' no'ox chvay, ja' no'ox chlic, ja' no'ox chil ti chloc' tal ti strigoe, chil ti chch'ie. Mu sna' c'u che'el. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yu'un stuc sna'oj c'u che'el chch'i tal. Jbael chac' tal yanal, patil chch'i tal ti unen sate, patil chyijub ti sate. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hech yu'un mi itaquij, hech yu'un ti ora tstac batel ti much'u chba scupe yu'un laj sta xa yorail tscup ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ti Jesuse hech laj yal uc: ―¿C'usi señail chacalboxuc yu'un hech chana'ic c'utic x'elan tspasvan ti mantal ti Diose? ¿C'usi lo'ilal chcal yu'un hech chana'ic c'utic x'elan? ");
INSERT INTO tzoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Chacalbeic c'u x'elan. Oy yip ch-abtej hech chaj c'u che'el ti biq'uit sbec' mostazate' ti ts'umbil ti lume ti muc' chc'ot. Lum biq'uit ti sbec' mostazate'e. Ja' más muc'tic sbec' ti yan ts'unubiletique. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mi ich'ie, ja' no'ox más ep tsjam sba. Ja' mu sjam sba lec ti yan ts'unubiletique. Ti mostazate'e muc'tic ti sc'obe. Hech yu'un xu' chtal spasic stso'op te ti sc'ob ti mostazate'e ti mutetique yu'un ep yaxinal ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Oy to ep yan lo'il laj yalbe ti jchi'iltaque ti Jesuse hech laj xchanubtas ti c'utic tsc'an ti Diose. Ja' no'ox laj yalbe ti c'u yepal xu' chcom ti yo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Puru lo'il laj yalbe. Oy sjam ti lo'ile. C'alal stuquic xa no'ox xchi'uc ti yajchanc'opetique, lic yalbe ya'yic c'usi sjam ti lo'il ti laj yale. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","C'alal imal xa ti c'ac'ale, hech lic yal ti Jesuse: ―Batic ti jech nab ―xut ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hech laj sc'oponic comel ti jchi'iltaque ti c'u yepal te stsoboj sbaique. Yu'un te ono'ox tiq'uil ti yut barco ti Jesuse te ti ba nab, hech yu'un ba staic ti Jesuse ti yajchanc'opetique. Oy yan barcoetic laj xchi'inic batel uc. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tsots ital ic'. Lic nicuc ti jyalel ti nabe. Hech yu'un i'och ho' ti yut barco. Hech yu'un c'an ch'ayuc yalel ti ho' ti barcoe. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ti Jesuse te vayal ti xchac barco. Oy xonjol yu'un te ono'ox oy pimil poc' sventa naclebal. Hech yu'un lic stijic ti Jesuse. Hech laj yalbeic: ―Maestro, ¿mi mu tsotsuc sc'opilal chava'i ti chijch'ay xa ti ho'? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hech ilic ti Jesuse. Laj spajes ti iq'ue. Hech laj yalbe ti nabe: ―Lamajan ―xut. Hech ipaj ti iq'ue. Ipaj uc ti nabe. Ilamaj scotol. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ti Jesuse hech laj yalbe ti yajchanc'opetique: ―¿C'u yu'un chaxi'ic? Yu'un mu ono'ox ach'unojucun ti lec, hech yu'un chaxi'ic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Más ep ixi'ic. Hech laj yalbe sbaic: ―¿Much'u vinical li'to ti ich'umbat smantal yu'un ti iq'ue xchi'uc ti nabe? Ti ora no'ox ipaj yu'un ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ibatic ti Jesuse xchi'uc ti yajchanc'opetique lum ti jech nab te ti jteclum Gadara sbi. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","C'alal iloc' ti barco ti Jesuse, ti ora c'ot snup ti be jun jchi'iltutic te nacal ti Gadara. Ochem pucuj ti yo'nton ti vinique. Te iloc' tal ti campo santo yu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ti bu chba ac'atuc ti ánimae ja' te snainoj. Yu'un pujul ch'enetic jombil ti ton ti bu ch-ac'at ti ánimaetique te ti campo santo yu'unique. Ti vinique mu xu' xchucat manchuc mi ti cadenataq'uin. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ep vuelta ichucbat sc'ob xchi'uc yacan. Ichucbat sc'ob ti cadenataq'uin. Itic'at ti manya. Ja' pasbil ti taq'uin. Tojtojtuch'el yu'un ti cadenae. Tojtojc'asel yu'un ti taq'uine ti pasbil ti manyae. Mu'yuc much'u xu' yu'un tspas ti manso. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ti c'ac'al ti ac'ubal chanav ti vitsetic, ti ch'entic; ch-avan batel, tstsac ton tsyajes sba. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nom to oy ti vinique ti c'alal laj yil chtal ti Jesuse. Anil tal squejan sba ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Hech laj yal ti Jesuse: ―Pucuj, loc'an tal ti yo'nton avi vinic li'to ―x'utat. Yu'un ti hech laj yal ti Jesuse, hech yu'un tsots lic c'opojuc ti vinique, hech laj yalbe: ―Mu aventaucun, Jesús, ho'ot Snich'onot ti Dios ti jelaven sp'ijile. Avocoluc ti stojol ti Diose, mu me xavilbajinun ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ti Jesuse lic sjac'be: ―¿C'usi abi? ―xut. Itac'av ti vinique: ―Legionun, yu'un epuntutic li' ochemuntutic ti yo'nton ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Laj yal ep vocol ti vinique ti mu me xtacatic batel ti yan balumil. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Te oy ep chitometic. Te tsa' sve'elic ti c'alc'alvits. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Scotol ti pucujetique laj yalbeic vocol ti Jesuse. Hech laj yalbeic: ―Mi yu'un chaloq'uesuntutique, tacuntutic batel ti yo' bu ti chitometique. Ac'un chi'ochtutic ti yo'ntonic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","―Te batanic ―xchi ti Jesuse. Hech iloq'uic ti yo'nton ti vinique ti pucujetique, ba stic' sbaic ti yo'ntonic ti chitometique. Jutuc van mu sta cha'mil ti cot ti chitometique. Ti chitometique scotolic anil ba sten sbaic yalel ti ch'en hech i'ochic ti nab. Te laj sjiq'uic ho'. Te icham o scotol. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ibatic ti anil ti jchabiejchitometique. Ba yalbeic ti much'utic te oy ti jteclum, ti much'utic te nacajtic ti vits. Scotolic ba yalbeic ti c'usi ic'ot ti pasele. Hech yu'un scotol ti jchi'iltaque tal sq'uelic mi melel ti hech ic'ot ti pasele. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Italic ti yo' bu oy ti Jesuse. Te laj yilic ti vinique ti ch-ilbajinat ono'ox yu'un ti pucuje, ja' ti ep pucujetic iloq'uesbat ti yo'ntone, te nacal, slapoj xa sc'u' spoc', tsna' xa balumil. Ixi'ic yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Icholbat ya'yic yu'un ti much'utic laj yilique ti c'u che'el icoltaat ti vinique ti oy ono'ox pucujetic ti yo'ntone, ti c'u che'el ichamic ti chitometique. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hech yu'un ti jchi'iltaque ti te nacajtique laj yalbeic vocol ti Jesuse yu'un ac'o loc'uc batel ti slumalic. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ti Jesuse laj stic' sba ochel ti barco yu'un tsut talel yan vuelta li'to. Ti vinique ti iloq'uesbat pucujetic ti yo'ntone, laj yalbe vocol ti Jesuse yu'un chchi'in. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","―Mu xu' ―xchi ti Jesuse. Hech laj yalbe: ―Batan ti ana, hech chc'o avalbe ya'yic ti avuts avalaltaque: “Q'uelo avil, laj xc'uxubinun ti Cajvaltique, laj scoltaun, hech yu'un lec oyun tana”, xavut ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hech yu'un ti vinique lic spuc te ti slumal ti c'u che'el icoltaat yu'un ti Jesuse. Decápolis sbi ti slumale yu'un oy lajuneb jteclum. Scotolic ich'ay yo'ntonic ti c'alal laj ya'yique. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","C'alal icha'sut xa tal li' ti jech nab ti Jesuse, ep jchi'iltac laj stsob sbaic tal ti stojol. C'alal te oy ti ti'nab ti Jesuse, ");
INSERT INTO tzoNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ital jun vinic, Jairo sbi. Ja' yich'oj yabtel te ti templo cu'untutique, ho'ontutic ti judiountutique. C'alal laj yil ti Jesuse ti Jairoe, ti ora ba spatan sba ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Laj yalbe vocol ti Jesuse. Hech laj yal: ―Chcham xa ti jtsebe. La' ac'o ac'ob ti sjol yu'un ac'o chopuc, hech chcuxi ―xchi ti Jairoe. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Laj xch'un ti Jesuse, hech laj xchi'in batel ti Jairoe. Its'acliat batel yu'un ep yan jchi'iltac. Hech xumetic batel. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Te oy jun ants jchi'il. Lajcheb habil tsacbil ti chamel ti antse. Scotol c'ac'al chil ti ch'ich'e. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Laj sa' ep doctoretic. Más no'ox i'ac'bat yich' vocol. Jovil ti j'ech'el ilaj scotol ti c'usi oy yu'une. Mi jutuc muc ono'ox xlecub. Yac'oj sba ti bats'ejel ti xchamele. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yu'un ya'yojbe sc'opilal ti Jesuse, hech yu'un te xchi'uc batel ti crixchanoetique. Laj spits sba jelavel ti antse asta c'ot spicbe sc'u' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yu'un hech laj snop ti yo'nton: Mi ja' no'ox ti jtsacbe sc'u', hech chicol o, xchi ti yo'nton ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ti ora imac ti ch'ich'e. Laj ya'i ti ichop xa ti sbec'tale. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ti Jesuse laj ya'i ti oy iloc' yip. Ti ora laj sjoyp'in sba, hech laj sjac'be ti crixchanoetique: ―¿Much'u laj spicbun jc'u'? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","I'albat yu'un ti yajchanc'opetique: ―Yac'oj sba chasnet'ot ti crixchanoetique chavil. ¿C'u yu'un chaval: “Much'u laj spicun”, xachi? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ti Jesuse laj sq'uelilan ti sjoylejal yu'un tsc'an tsq'uel ti much'u hech laj spase. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hech yu'un ixi' ti antse. Yu'un laj sna' ti ichop xa ti xchamele, hech yu'un lic squejan sba ti stojol. Jamal laj yalbe scotol. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ti Jesuse hech laj yalbe: ―Nich'on, colemot xa yu'un laj ach'un ti xu' cu'une. Jun avo'nton batan, j'ech'el ichop xa ti achamele ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","C'alal yac'oj sba tsc'opon ti antse ti Jesuse, oy much'utic italic te ti sna ti Jairoe, ja' ti oy yabtel te ti temploe. Hech hul albatuc: ―Icham xa ti atsebe. Mu xa xavac'be svocol ti Maestroe ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Te yabinoj ti Jesuse ti hech i'albate, hech yu'un lic yalbe ti ora ti Jairoe: ―Mu me xach'un. Ja' no'ox chach'un ti xu' cu'une ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ti Jesuse mu sc'an ti chchi'inat batel yu'un scotolique. Ja' no'ox laj yic' batel ti Pedroe, xchi'uc ti Jacoboe, xchi'uc ti Juane, ja' ti yits'in ti Jacoboe. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","C'alal ic'otic ti sna ti Jairoe, laj yil ti Jesuse ti xlaquetic ch-oq'uic ti jchi'iltaque, ti chich'ic mule. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","I'och ti yut na ti Jesuse. Hech laj sjac'be: ―¿C'u yu'un xalaquetic no'ox cha'oq'uic? Mu chamenuc ti tsebe, vayal no'ox ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yu'un ti hech laj yal ti Jesuse, ep ilabanat yu'un ti jchi'iltaque yu'un laj sna'ic ti icham xa ti tsebe. Ti Jesuse laj stac loq'uel scotolic. Ja' no'ox laj yic' ti stot sme' ti tsebe xchi'uc ti oxvo' xchi'iltaque. Ja' no'ox i'ochic batel xchi'uc ti bu oy ti ánimae. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ti Jesuse laj stsacbe sc'ob ti tsebe, hech laj yalbe: ―Talita cumi ―xut. Ja' sjam c'alal jelavesbil: Tseb, chacalbe, lican, xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ti ora ilic ti tsebe, ixanav batel. Cuxul xa. Oy lajcheb habil yich'oj ti tsebe. Toj ch'ayel yo'nton scotolic. ");
INSERT INTO tzoNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ti Jesuse tsots laj spas ti mantal ti stot sme' ti tsebe. Hech laj yalbe: ―Mu me much'u chavalbe ya'yic ―xut. Hech laj yalbe mantal uc: ―Ac'bo sve'el ti atsebe ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","C'alal laj yo'nton ti Jesuse, isut batel ti Nazaret, ja' ti slumale. Laj xchi'in batel ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","C'alal te xa oy ti slumal, ti sc'ac'alil ti jcux co'ntontutic ibat ti templo ti Jesuse. Te c'ot chanubtasvanuc. Ep ti much'utic laj ya'ibeic sc'ope. Ti c'alal laj ya'yique, ich'ay yo'ntonic. Hech lic yalbe sbaic: ―¿Bu laj xchan tal ti oy sp'ijil ti jchi'iltic li'to? Yu'un jchop o ti c'op chale. Jchop o ti yabtel tspase ―xut sbaic―. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ja' ti carpintero ono'ox li'i. Ja' yol ti María avi to. Ja' yits'inabtac ti Jacoboe xchi'uc ti Josee xchi'uc ti Judase xchi'uc ti Simone. Ja' yixleltac ti tsebetic ti li' nacalucutic xchi'uque ―xut sbaic. Yu'un xojtiquinic hech yu'un ti muc spasbeic ti muc' ti sc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ti Jesuse hech lic yalbe: ―Buc no'ox chbatic ti j'alc'opetic yu'un ti Diose, ja' tspasat ti muc'. Ja' no'ox te ti slumal xchi'uc ti sna xchi'uc ti bu oy ti yuts yalaltaque, ja' mu spasat ti muc' ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yu'un ti muc spasat ti muc' ti sc'ope te ti slumal, hech yu'un muc xu' yu'un spas ep jchop o abteletic te. Ja' no'ox cha'vo' oxvo' icol ti jchameletique. Ti Jesuse laj yac' sc'ob laj yac'be ti sjolic ti jchameletique hech icolic. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ich'ay yo'nton ti Jesuse yu'un ti muc sc'an xch'unique. Hech yu'un iloc' batel ti Jesuse. Xmelmun ixanav batel scotol ti biq'uit jteclumetique ti te oyic ti sjoylejal ti Nazarete. Te ichanubtasvan. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ti Jesuse laj yic' tal ti stojol ti lajchavo' yajchanc'opetique hech lic xch'ac. Cha'cha'vo' tstac batel. Lic yac'be sp'ijilic yu'un tsloq'uesic pucujetic ti yo'ntonic ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Hech laj spas ti mantal: ―C'alal chabatique, mu'yuc c'usi chavich'ic batel. Mu xavich'ic batel ave'elic, mu xavich'ic batel ataq'uinic. Ja' no'ox xu' chavich'ic batel anamte'ic. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ja' no'ox xu' chalapic batel asempatic. Mu me xalapic batel cha'lic ac'u'ic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hech laj yalbe uc: ―Mi na'och ti jun na, teno'oxan o. Mu me xajel asta chaloc' batel ti jteclum ti bu nac'ote. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Scotol ti much'utic mu xaspasot ti muc', ti mu sc'an xa'i ac'opique c'alal chaloq'uic batel ti sna, mi ti slumal, ta me xalilinic comel stanil avacanic. Ti stanil avacanique, ja' señail ti icom ti sventaic yu'un muc xaspasoxuc ti muq'ue ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hech laj xch'unic, hech ba xcholbe ya'yic ti jchi'iltaque ti ac'o sutes yo'ntonic yu'un ti smulique. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Laj sloq'uesbeic ep pucuj ti yo'nton ti jchi'iltaque. Laj yac'beic aceite ti sjolic ep ti jchameletique, hech icol yu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yu'un ep puquem sc'opilal ti Jesuse, hech yu'un laj ya'i uc ti ajvalile, ja' ti Herodese. Yu'un oy laj yalic ti jchi'iltaque: ―Lume, ja' ti Juane, ja' ti laj yac' ich'ho'e. Icha'cuxi xa loq'uel tal ti ch'en. Hech yu'un oy sp'ijil yo'nton hech yu'un xu' tspas jchop o abteletic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Oy yan laj yalic: ―Lume, ja' ti Elíase, ja' ti j'alc'op yu'un Dios ti vo'one ―xchiic. Oy yantic uc laj yalic: ―Lume, ja' j'alc'op yu'un Dios hech chaj c'u che'el ti j'alc'opetic yu'un ti Diose ti vo'one ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","C'alal laj ya'i ti Herodese, hech laj yal: ―Lume, ja' ti Juane, ja' ti laj cac' ti c'oc'bel sjole. Icha'cuxi xa loq'uel ti ch'en ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yu'un c'alal cuxul to ti Juane, ti Herodese laj stsac, laj xchuc, laj stic' ti chuquel ti scoj ti Herodíase, ja' ti yajnil ti yits'ine, ja' ti Felipee. Yu'un ti Herodese laj spojbe yajnil ti yits'ine laj yic'. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ti Herodese yu'un hech ono'ox i'albat yu'un ti Juane: ―Mu xtun ti laj apojbe ti yajnil ti avits'ine laj avic'. Mu hechuc chal ti leye ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hech yu'un ti Herodíase, ja' ti antse, mu xtun laj yil ti Juane yu'un ti hech laj yale. Sc'an xmilvan ti antse pero mu to xu' yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yu'un ti Herodese laj spas ti muc' ti Juane yu'un laj sna' ti toj ti viniquil ti Juane, ti lec ti yo'ntone. Hech yu'un laj yac' ti chabiel naca me milatuc. Manchuc mi muc xa'ibe lec sjam ti c'usi laj yal ti Juane, nichim no'ox yo'nton sc'an cha'ibe sc'op. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","22","C'alal iloc' sabilal ti Herodese, laj spasic q'uin. Laj yic' tal ti yaj'abtele yu'un chve'ic te ti q'uin xchi'uc, ja' ti much'utic yac'ojbe yabtele, ja' ti much'utic ochemic ti presidentee, xchi'uc ti capitan soldadoetique, xchi'uc ti jc'ulejetique te ti estado Galilea. C'alal i'och batel yu'un ba ac'otajuc ti stsebe, laj sna' ti antse ti ja' xa yorail xu' tspas. Ti tsebe te i'ac'otaj ti stojol scotolic. Puru viniquetic te o. Yu'un ti i'ac'otaje ja' no'ox yu'un ac'o c'upinatuc. Lec laj yil ti Herodese xchi'uc ti yaj'abtele ti te xchi'inoj ti mesae. Hech yu'un c'alal laj yo'nton ac'otajuc ti tsebe, hech lic yal ti Herodese: ―C'usuc no'ox chac'an, chacac'be. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yiloj ti Diose chacac'be c'usi chac'an. Manchuc mi chac'an o'lol ti bu ti jpas mantal, chacac'bot ―xut ti tsebe. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Iloc' batel ti tsebe, ba sc'opon ti sme'e. ―¿C'usi ti jc'ambe? ―xchi. ―Ja' xac'ambe ti sjol ti Juane, ja' ti chac' ich'ho'e ―xchi itac'av ti sme'e. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hech isut tal ti anil ti tsebe. Hech hul sc'ambe ti Herodese: ―Ti jc'an ti chavac'bun ti plato ti ora to sjol ti Juane, ja' ti chac' ich'ho'e ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","C'alal laj ya'i ti Herodese, ep laj yich' mul. Scoj ti hech laj yale, scoj uc ti laj ya'yic uc ti yaj'abtele ti te xchi'inoj ti mesae, hech yu'un muc sc'an sutes sc'op. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hech yu'un ti ora laj stac batel jun yajsoldado yu'un chba sc'oc'be tal sjol ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Hech ibat ti yajsoldadoe, ba sc'oc'be sjol ti Juane ti te tiq'uil ti chuquele. Laj yich'be tal sjol ti plato. Laj yac'be ti tsebe. Ti tsebe ba yac'be ti sme'e. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","C'alal laj ya'yic ti yajchanc'opetic ti Juane, tal yich'beic batel ti sbec'tale, ba smuquic. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ti lajchavo'ique ti itacatic batel yu'un ti Jesuse, isutic tal ti yo' bu oy ti Jesuse. Hul xcholbeic ya'i scotol ti c'utic laj spasique xchi'uc ti c'utic laj yaq'uic ti chanele. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yu'un ep ti much'utic italilanic asta muc spas chve'ic, hech yu'un ti Jesuse hech laj yalbe ya'yic ti lajchavo'ique: ―Ja' lec ti jq'uej jbatic. Batic ti xocol balumil yu'un te xu' chacux avo'ntonic ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hech yu'un laj stic' sbaic ti barco. Stuquic no'ox ibatic ti bu xocol ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ep ti much'utic laj yilic ti ibatique. Laj yojtiquinic. Hech yu'un anil laj sts'acliic batel, ja' laj stamic batel ti ti'ti'nab. Ja' talemic ti jujun jteclum. Ja' jbael ic'otic ti xocol balumil stuquic. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","C'alal c'o va'luc ti lum ti Jesuse, laj yil te stsoboj sbaic ep crixchanoetic. Laj xc'uxubin yu'un hech c'otemic hech chaj c'u che'el carneroetic ti mu'yuc jpaxtol yu'unique. Lic chanubtasvanuc ti Jesuse. Ep ti c'utic laj yalbee. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","C'alal ich'ay xa ti c'ac'ale, hech lic albatuc yu'un ti yajchanc'opetique: ―Xocol balumil li'to. Ich'ay xa ti c'ac'ale. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Hech yu'un taco batel ti crixchanoetique ac'o batuc ti coloniaetic xchi'uc ti biq'uit jteclumetic ti li' nopajtique. Ac'o ba sman sve'elic, yu'un mu yich'ojuc tal sve'elic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Itac'av ti Jesuse, hech laj yalbe: ―Ac'bo sve'elic ho'oxuque ―xchi. Itac'avic: ―¿Bu ti jtatutic ti chib ciento denariotaq'uin yu'un ti jmantutic tal ti caxlan vaj ti tsve'ique? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ti Jesuse hech laj sjac'be: ―¿Jayib caxlan vaj avich'ojic talel? Ba q'uelo ―xut. C'alal laj sq'uelic, hech tal yalbeic: ―Quich'ojtutic ho'ob muc'tic caxlan vaj xchi'uc cha'cot choy ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ti Jesuse laj yal ti jayjayvo' chic' sbaic. Hech yu'un hech laj spas ti mantal ti jchi'iltaque ac'o ba nacluc ti vomoltic. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hech yu'un hech laj yic' sbaic. Laj snacan sbaic. Oy laj yic' sbaic ti ho'vinic ti vo'. Oy laj yic' sbaic ti lajuneb yoxvinic ti vo'. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ti Jesuse laj stsac ti caxlan vaje xchi'uc ti cha'cot choye. Laj sq'uel muel vinajel, hech lic yalbe vocol ti Diose. Laj xet'ilan ti caxlan vaje. Laj yac'be ti yajchanc'opetique. Ti yajchanc'opetique laj yac'beic ti crixchanoetique. Laj stuch'ilan uc ti cha'cot choye. Scotolic laj yich'ic uc ti choye. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Hech ive'ic scotolic. Ta yutsil inoj xch'utic o. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Patil laj stsobic ti xet'elal caxlan vaje xchi'uc ti sobril choye ti te comene. Inoj lajcheb almud ti sobril ti caxlan vaj ti laj sve'ique xchi'uc ti sobril choye. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ja' no'ox tsacbil ti venta ti viniquetique ti ive'ique. Ho'mil. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ti Jesuse ti ora laj stic' ochel ti barco ti yajchanc'opetique, laj stac jelavel c'alal ti jech ti'nab te ti bu jteclum Betsaida. Te to icom ti Jesuse. Stuc xa no'ox laj sc'opon comel ti jchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","C'alal laj yo'nton laj sc'opon comel ti jchi'iltaque, imu batel ti vits stuc ti Jesuse, ba sc'opon Dios. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","C'alal i'ic'ub ti osile, te oy ti o'lol nab ti barcoe ti bu tic'ajtic ti yajchanc'opetique. Ja'uc ti Jesuse te oy ti vits. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Laj yil ti Jesuse ti ilubique. Mu xa xu' yu'unic tstijic batel ti barcoe yu'un chpajesvan ti iq'ue. Hech yu'un c'alal po'ot xa tsacub, ital ti Jesuse ti bu yac'oj sba chanavic batele. Ixanav talel ti yacan ti ba ho' ti Jesuse. Snopoj ti chjelav batel stuc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","C'alal laj yilic ti chanav talel ti yacan ti ba ho' ti Jesuse, ixi'ic scotolic. Laj scuyic ti ja' ch'ulelal hech lic avanucuc. Ti ora ic'oponat yu'un ti Jesuse. Hech i'albat: ―Mu me xaxi'ic yu'un ho'on Jesusun. Muc'ubtaso avo'ntonic ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Och xchi'in ti barco. C'alal i'oche, ipaj ti iq'ue. Ich'ay yo'ntonic ti yajchanc'opetique yu'un muc xa'ibeic sjam ti c'u che'el ipaj ti iq'ue. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Muc xa'ibeic sjam uc c'u che'el i'epaj ti caxlan vaje yu'un ti Jesuse yu'un mu'yuc to sc'opilal ti yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","C'alal ic'otic ti hech ti'nab, iloq'uic ti barco te ti jteclum Genesaret sbi. Te laj xchuquic comel ti barcoe. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","C'alal c'ot va'luc ti lum, ti ora i'ojtiquinat ti Jesuse yu'un ti jchi'iltaque ti te nacajtique. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Hech yu'un ti ora ba yalbeic ti much'utic oy jchamel yu'unique: ―Li' xa oy ti jlumaltic ti Jesuse. Q'uecho me batel ti ora xchi'uc ti svayebe ti jchamel avu'unique, ba ac'o ti stojol. Te oy ti jteclum lum toi ―xut. Hech yu'un ti c'alal laj ya'yic ti bu oy ti Jesuse, scotolic ti buc no'ox nacajtique ti sjoylejal ti Genesarete, hech laj sq'uechbeic batel xchi'uc svayebic ti jchameletique. C'ot yaq'uic ti stojol ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Buc no'ox i'och ti Jesuse, mi biq'uit jteclum, mi muc'ta jteclum, mi colonia, laj smetsanic ti bebetic ti jchameletique. Laj yalbeic vocol ti Jesuse manchuc mi sba sc'u' no'ox tspicbeic. Scotol ti much'utic laj spicbeique, hech icolic uc. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Italic ti stojol ti Jesuse cha'vo' oxvo' ti fariseoetique xchi'uc ti much'utic ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Ja' talemic ti Jerusalén ti jchanubtasvanejetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Laj sq'uelic ti mu haluc laj spoc sc'obic cha'vo' oxvo' ti yajchanc'opetic ti Jesuse ti c'alal lic ve'uque. Laj scuyic ti mu lecuc ch-ilatic yu'un ti Diose yu'un ti hech tspasique, hech yu'un laj sa'beic smul. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Yu'un ti fariseoetique xchi'uc scotol ti jchi'iltaque, ho'on ti judioun xchi'uque, xch'unojic ti c'u che'el laj spasic ti antiguo jtotutique, hal tspoc sc'ob, patil chlic ve'ucuc. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","C'alal tsutic tal ti plaza, ja'to mi hal laj spoc sc'obique, ja'to chlic ve'ucuc. Oy to ep yan c'op xch'unojic spasel uc. Ja' ti c'u che'el tsuquic stazaic, xchi'uc sjarroic, xchi'uc sp'inic ti ja' pasbil ti taq'uine.) ");
INSERT INTO tzoNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ti fariseoetique xchi'uc ti much'utic ti ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique hech lic sjac'beic ti Jesuse: ―¿C'u yu'un mu xa spasic ti avajchanc'opetique hech chaj c'u che'el laj spasic ti antiguo jtatamoltique? Ti antiguo jtatamoltique hal laj spoc sc'obic c'alal ive'ic yu'un hech lec ac'o ilatuc yu'un ti Diose. Ti avajchanc'opetique mu xa hechuc tsnop c'alal tspoc sc'obic c'alal chve'ique ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Itac'av ti Jesuse, hech laj yalbe: ―Jlo'lavanejoxuc. Melel ti hech ac'opilalic cholbil yu'un ti Isaíase, ja' ti j'alc'op yu'un ti Diose ti vo'one: Hovil ti chispasucun ti muc' ti sc'opic ti achi'iltac li'to, mu teucun ti yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sc'op no'ox crixchanoetic xchi'uc smantal no'ox crixchanoetic ti chaq'uic ti chanele. Mu jc'opuc ti chaq'uic ti chanele, ti xchie. Ja' ac'opilalic obi. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yu'un laj xa acomesic ti smantal ti Diose. Mu xa tsotsuc sc'opilal chava'yic. Ja' tsots sc'opilal chava'yic ti smantal no'ox ti crixchanoetique, xchi'uc ti ajarroique xchi'uc ti atazaique. Oy to ep yan hech chapasic uc ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hech laj yalbe uc: ―Lec chava'yic ti ja' no'ox chach'unic spasel ti c'u che'el laj spasic ti antiguo atatamolique, hech chach'aybeic ti smantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yu'un hech laj yal ti Moisese: “Paso me ti muc' atot ame'”, xchi. Laj yal uc: “Ja' ti much'u chopol chc'opoj yu'un stot sme', ta me xcham”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ti ho'oxuque lec chava'yic ti mu tsotsuc sc'opilal cha'i ti tspas ti muc' ti stot sme'ique. “Ti c'u yepal ti laj jnop ti c'an cac'bote, ja' laj xa cac' sventa smoton Diose”, mi xut ti stot sme'e, lec oy ti hech tspasique, xachiic ti ho'oxuque. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ti much'u hech tspase, ho'oxuc chavalbeic ti mu persauc tscolta stot sme' mi jutuc. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hech chach'aybeic smantal ti Diose scoj ti chach'umbeic sc'op ti antiguoetique. Oy to ep yan hech chapasic uc ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ti Jesuse laj yic' tal ti stojol scotol ti jchi'iltaque, hech lic yalbe: ―A'yo me ava'yic ti c'usi chacalbeique. A'ibo me sjam acotolic. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ma'uc chasbolibtasoxuc ti c'utic chave'e. Ja' chasbolibtasoxuc ti c'utic chopol chanope, ti c'utic chopol chavale. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nopilanic lec hech chaj c'u che'el laj calboxuc ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ti Jesuse laj scomes ti crixchanoetique, i'och ti yut na ti bu chvay ono'oxe. Te ijac'bat yu'un ti yajchanc'opetique c'usi sjam ti lo'il ti laj yale. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Ti Jesuse hech laj yalbe: ―¿Mi yu'un muc xava'ibeic sjam uc, ho'oxuque? ¿Mi mu xavilic ti scotol ti c'utic chave'e, ja' mu xasbolibtasoxuc, yu'un mu x'och ti avo'nton? Ja' chc'ot ti ach'ut, ja' chatsa' tal loq'uel ―xchi. Hech laj yal ti Jesuse ti lec scotol ve'elil. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hech laj yal uc: ―Ja' chasbolibtasoxuc ti c'utic chopol chanope, ti c'utic chopol chavale, ti xichie, ");
INSERT INTO tzoNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","yu'un ti yo'nton crixchanoetic chloc' tal c'usi chopol snopoj mi tsc'opon ants, mi elec', mi milvanej, mi mulivajel, mi oy sbic'tal yo'nton, mi chcontrainvan, mi chlo'lavan, mi batem yo'nton chch'umbe smantal ti sbec'tale, mi tspas biq'uit yo'nton, mi chal bolc'op, mi tstoy sba, mi hovil chc'opoj. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Scotol avi muliletic li'to ti avo'ntonic chloc' tal. Ja' chasbolibtasoxuc ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iloc' batel ti Jesuse, ibat ti slumal Tiro xchi'uc ti slumal Sidón. Te i'och ti jun na. Mu sc'an ti chpucbat ti sc'opilal yu'un ti ital xae pero ivinaj ti ora. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yu'un te oy jun ants. Ochem pucuj ti yo'nton ti stseb ti antse. Ti antse laj ya'i ti te xa oy ti Jesuse. Hech yu'un ti ora ital, tal spatan sba ti lum ti stojol ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ma'uc jchi'il ti antse, ja' yanlum ants. Sirofenicia sbi ti slumale. Manchuc mi mu xtun ono'ox chquiltutic scotol ti yanlum crixchanoetique ho'ontutic ti judiountutique, ti antse laj yalbe vocol ti Jesuse ti ac'o loq'uesbatuc pucuj ti yo'nton ti stsebe. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ti Jesuse hech laj yalbe: ―Ac'o nojuc xch'ut jbael ti col jnich'ontique. Mu xtun mi ti jpojbetic yot ti col jnich'ontique yu'un ti jtembetic yu'un ac'o sve' ti ts'i'etique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Itac'av ti antse, hech laj yalbe: ―Melel ava'uc, tote. Pero ho'oni hech chaj c'u che'el ts'i'. Ti achi'iltaque hech chaj c'u che'el olol. C'alal chve' ti olole, oy xch'uch'elal vaj chp'aj yalel ti yolon smesa. Ja' stac' tsve' ti ts'i'etique. Ja' no'ox hechun uc ti ho'one, ac'bun jutuc ti bendicione ―xchi ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Hech yu'un ti Jesuse hech laj yalbe: ―Yu'un ti hech laj avale, xu' chabat yu'un iloc' xa ti pucuj ti oy ti yo'nton ti atsebe ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hech ibat ti sna ti antse. Loq'uem xa ti pucuje c'ot sta. Te metsel ti svayeb c'o sta ti stsebe. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ti Jesuse iloc' batel ti slumal Tiro, i'ech' ti jteclum Sidón. Ijelav batel ti bu oy ti lajuneb jteclumetique, ic'ot ti ti'nab ti te oy ti estado Galilea. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Te oy jun jchi'il i'ic'at tal ti stojol ti Jesuse. Macal xchiquin ti vinique mu xa'i c'op. Uma' uc. Ti Jesuse i'albat vocol yu'unic ti ac'o yac' sc'ob ti Jesuse ac'o yac'be ti sjol ti vinique yu'un hech chchop ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ti Jesuse laj sq'uej sba xchi'uc ti vinique. Lic stic' sbic'tal sc'ob ti Jesuse ti jujujech xchiquin ti vinique. Lic stubtabe ochel ti yoq'ue ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ti Jesuse laj sq'uel muel vinajel, laj sjic' yo'nton. Hech laj yalbe ti vinique: ―Efata ―xut. Jamuc, xchi c'alal jelavesbil. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ti ora ijam ti xchiquine, ilecub ti yoq'ue, lec lic c'opojuc ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ti Jesuse hech laj spas ti mantal scotolic ti mu me xpucbat batel sc'opilal. Hovil ti hech ipasatic ti mantal yu'une, ech'em to laj spucbeic batel sc'opilal. ");
INSERT INTO tzoNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ich'ay yo'ntonic yu'un ti hech ic'ot ti pasele. Hech laj yalic: ―Lec scotol ti c'usi tspase. Tsjambe xchiquin ti much'utic macal xchiquine. Chac' c'opojuc ti much'utic uma'e ―xchiic. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yan vuelta hech ic'ot ti pasel ti mu'yuc xa sve'el ti jchi'iltaque yu'un te stsoboj sbaic cha'ibeic sc'op ti Jesuse. Hech yu'un ti Jesuse laj yic' tal ti yajchanc'opetique, hech laj yalbe: ");
INSERT INTO tzoNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―C'ux ti co'nton ti jchi'iltique yu'un yoxibal c'ac'al xa ti li' jchi'inojtique, mu'yuc xa sve'elic. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mi mu ve'emuc ti jtac batel ti snaique, repenta ch-altsajic ti be. Yu'un oy much'utic nom talemic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Itac'av ti yajchanc'opetique, hech laj yalbeic: ―Yu'un xocol balumil li'to mu jtatutic ti caxlan vaje yu'un ti jmac'lintutic chavale ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ti Jesuse hech laj sjac'be: ―¿Jayib muc'tic caxlan vaj oy avu'unic? ―xutic. Hech itac'avic: ―Hucub xa no'ox oy cu'untutic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hech yu'un ti Jesuse laj spas ti mantal ti jchi'iltaque yu'un ac'o ba nacluc ti lum. Laj stsac ti hucub muc'tic caxlan vaje, laj yalbe vocol ti Diose. Laj xet'ilan ti caxlan vaje, laj yac'be ti yajchanc'opetique. Ti yajchanc'opetique ba yac'beic ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Oy yu'unic uc cha'cot oxcot biq'uit choy. Ti Jesuse laj yalbe vocol ti Diose, laj yal mantal ti ac'o ba spucbeic uc ti choye. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Scotolic ive'ic, inoj xch'utic. Patil laj stsobic tal ti xet'elal ti caxlan vaje ti te comene. Inoj hucub almud ti sobril ti caxlan vaje ti much'utic laj sve'ique. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Oy chanmil ti ive'ique. Patil itacatic batel ti snaic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ti Jesuse ti ora laj stic' sba ochel ti barco xchi'uc ti yajchanc'opetique, ibatic ti bu slumal Dalmanuta. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ital cha'vo' oxvo' ti fariseoetique, tal sc'oponic ti Jesuse. Sc'an spasbeic proval yo'nton ti Jesuse, hech yu'un laj yalbeic: ―Paso me señail ti vinajel yu'un ti jq'ueltutic yu'un hech ti jna'tutic ti ja' ac'bilot avabtel yu'un ti Diose ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ti Jesuse laj sjic' yo'nton, hech laj yalbe: ―¿C'u yu'un chac'an chaq'uelic yan señail ti ho'oxuc ti li'oyoxuc li' ti balumile ti ora to yu'un laj xa cac' avilic? Melel ti c'usi chacalbeique, mu xa xa'ac'batic aq'uelic yan ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ti Jesuse laj scomes ti fariseoetique, laj xcha'tic' sba ti barco xchi'uc ti yajchanc'opetique, ibatic ti jech nab. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ti yajchanc'opetic ti Jesuse ich'ay ti yo'ntonic muc xich'ic batel ep caxlan vaj. Jp'ej no'ox muc'tic caxlan vaj yich'ojic batel te ti barco. Ja' pumen xch'ut ti caxlan vaje. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ti Jesuse hech laj spas ti mantal: ―P'ijanic me, mu xtun ti spumesbil xch'ut caxlan vaj yu'un ti fariseoetique. Mu xtun uc ti spumesbil xch'ut caxlan vaj yu'un ti Herodese ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ti yajchanc'opetique hech laj yalbe sbaic: ―Ja' van chal yu'un muc xquich'tic tal ti caxlan vaj cu'untique ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ti Jesuse sna' ti hech yac'oj sba chalbe sbaique. Hech yu'un laj sjac'be: ―¿C'u yu'un chlo'laj avo'ntonic yu'un muc xavich'ic tal ti caxlan vaj cu'untique? ¿Mi mu to chach'unic ti xu' cu'un? ¿Mi yu'un mu xavac' c'otuc ti avo'ntonic? ");
INSERT INTO tzoNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Mi hovil ti oy asatique? ¿Mi hovil ti oy achiquinique? ¿Mi ich'ay xa ti avo'ntonic ti c'usi laj jpase? ");
INSERT INTO tzoNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","C'alal laj jxet' ti ho'ob muc'tic caxlan vaje ti laj jpucbetic ti ho'mile, ¿jayib almud laj spas sobril ti xet'elal ti caxlan vaje ti laj atsobique? ―xut. Hech itac'avic: ―Lajcheb almud ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Ti yan vuelta c'alal laj jpucbetic ti hucub muc'tic caxlan vaje ti chanmile, ¿jayib almud laj spas sobril ti xet'elal ti caxlan vaje ti laj atsobique? ―xut. Hech itac'avic: ―Hucub almud ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ti Jesuse hech laj sjac'be: ―¿Mi yu'un mu to chava'ibeic sjam? Ja' sc'opilal ti fariseoetique ti laj calboxuque yu'un mu xtun ti c'op ti chac' ti chanele ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ic'otic ti jteclum Betsaida sbi. Te oy jun ma'sat initat talel ti stojol ti Jesuse. Laj yalbeic vocol ti Jesuse yu'un ac'o sjambe ti sate. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Hech yu'un ti Jesuse laj stsacbe sc'ob ti ma'sate, laj yic' loq'uel ti jteclum. Ibat ti fuera xchi'uc. Ti Jesuse laj stubtabe ochel sat ti vinique, laj spicbe sat ti sc'ob. Lic sjac'be: ―¿Mi oy c'usi chvinaj chavil? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ti vinique laj sq'uelilan, hech lic yal: ―Oy viniquetic chanavic batel chquil. Pero te'etic x'elan ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ti Jesuse laj xcha'picbe yan vuelta ti sate. Laj sjambe ti lec. Hech ilecub ti sate. Scotol lec chvinaj chil xa ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ti Jesuse laj stac batel ti sna. Hech laj yalbe batel: ―Mu me xa'och ti yut jteclum. Mu me much'u chavalbe ya'i li' ti jteclume ―xut batel. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iloq'uic batel ti Jesuse xchi'uc ti yajchanc'opetique. Ibatic ti biq'uit jteclumetic ja' ti macbil yu'un ti muc'ta jteclum Cesarea yu'un Filipo sbi. C'alal ixanavic batel ti be, ti Jesuse lic sjac'be ti yajchanc'opetique: ―¿C'usi cabtel chalic ti jchi'iltique? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hech itac'avic: ―Oy chalic ti ho'ot Juanot, ja' ti laj yac' ich'ho'e. Oy chalic ti ho'ot Elíasot, oy chalic ti ho'ot yan j'alc'opot yu'un ti Diose ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Hech yu'un ti Jesuse laj sjac'be: ―Ho'oxuque, ¿much'uun chacuyic? ―xchi. Itac'av ti Pedroe, hech laj yalbe: ―Ho'ot ti Cristoote, ho'ot t'ujbilot yu'un ti Diose yu'un chacoltauntutic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ti Jesuse hech laj spas ti mantal: ―Mu to me much'u chavalbeic ti ho'on ti Cristoune ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ti Jesuse hech lic yalbe ti yajchanc'opetique: ―Ho'on ti co'ol crixchanoucutique persa chquich' vocol yu'un mu xixch'umbun jc'op ti moletique xchi'uc ti totil paleetique xchi'uc ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Chismilucun, chicham, patil ti yoxibal c'ac'al chicha'cusesat loq'uel ti ch'en ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yu'un jamal laj yal ti Jesuse, hech yu'un ti Pedroe laj sq'uej sbaic xchi'uc ti Jesuse jutuc. ―Mu me hechuc chaspasbot ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ti Jesuse laj sjoyp'in sba, laj sq'uel batel ti yo' bu va'ajtic ti yan yajchanc'opetique, hech lic spajes ti Pedroe. Hech laj yalbe: ―Loc'an batel ti jtojol, Satanás. Chac'an chabolibtasun. Ma'uc chanop c'usi tsc'an ti Diose. Ja' no'ox chanop hech chaj c'u che'el tsnop crixchanoetic ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ti Jesuse laj yic' tal ti stojol scotol ti jchi'iltaque ti te stsoboj sbaique xchi'uc ti yajchanc'opetique. Hech laj yalbe: ―Ti much'u tsc'an chists'acliune, mu me xc'uxubin sba, ac'o cuchuc yu'un ti vocole hech chaj c'u che'el ti jcuch ho'oni, ac'o sts'acliun. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yu'un scotol ti much'u chc'uxubin sbae, ja' chch'ay. Scotol ti much'u mu xc'uxubin sbae ho'on ti jventa yu'un hech ac'o pucuc ti sc'op Diose, ja' chcuxi. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Manchuc mi ihu' avu'un laj avu'unin scotol ti c'utic oy li' ti balumile, mi mu xacuxi sbatel osil, hovil. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ja' tsots sc'opilal ti chacuxi sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Scotol ti much'u chq'uexav yu'un chch'un ti jc'ope ti stojol ti jmulaviletic li' ti balumile ti ora to, ti mu'yuc Dios ti yo'ntonique, hech ono'ox uc “ma'uc jnich'on lume”, xichi, ho'on ti co'ol crixchanoucutique, c'alal chital quich'oj jqueval hech chaj c'u che'el squeval ti Jtote, jchi'inoj tal ti ch'ul abatetique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ti Jesuse hech laj yalbe uc: ―Melel ti c'usi chacalbeique, ho'oxuc ti li' va'aloxuc li'to oy mu to chachamic ja'to mi laj avilic ti chtal xchi'uc yip ti Diose, oy c'u yepal crixchanoetic tsventaimbe yo'nton li' ti balumile ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","I'ech' vaquib c'ac'al. Patil ti Jesuse laj yic' batel ti yan parte ti Pedroe xchi'uc ti Jacoboe xchi'uc ti Juane. Stuquic imuic batel ti vits. Toyol ti vitse. Ti Jesuse te laj sc'atajes sba ti stojolic. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Iquevan scotol sc'u' ti Jesuse. Sac ti jyalel ic'ot, chtup' jsatic yu'un. Li' ti balumile mu xco'olaj xchi'uc ti much'u más sac chchuc'omaj. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Te laj yac' sba iluc ti Elíase xchi'uc ti Moisese. Te ilo'lajic xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Hech yu'un ti Pedroe hech laj yalbe ti Jesuse: ―Maestro, ja' lec ti li'ucutic no'oxi. Ja' lec jpastic oxib nailvomol li'i, jun avu'un, jun yu'un Moisés, jun yu'un Elías ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mu sjamuc ti c'u che'el chale yu'un chi'ic scotol xchi'uc xchi'iltac. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hech ital toc, imacatic scotolic. C'alal but'ibilic ti toc, hech ic'opoj ti Diose: ―Ja' Jnich'on li'to, ja' ti lum c'ux ti co'ntone. A'ibo sc'op ―xchi c'alal te oy ti toque. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","C'alal ibat ti toque, lic sq'uelilanic. Mu'yuc xa te o ti cha'vo'ique, ja' xa no'ox stuc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","C'alal yac'oj sba chyalic tal ti vits, hech ipasatic ti mantal yu'un ti Jesuse: ―Ti c'u che'el laj avilique, mu to me xavalic ja'to mi nicha'cuxi loq'uel ti ch'en ho'on ti co'ol crixchanoucutique ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hech laj xch'umbeic ti sc'ope ti mu xalic. Laj sjac'be sbaic stuquic c'usi sjam ti chcha'cuxi loq'uel ti ch'ene. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Lic sjac'beic ti Jesuse: ―¿C'u yu'un hech chalic ti jchi'iltic ti chchanubtasvan ti smantal ti Diose ti scuyoj sbaique ti persa ja' jbael chtal ti Elíase? ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Itac'av ti Jesuse, hech laj yalbe: ―Melel hech ts'ibabil ti sc'op ti Diose ti ja' jbael chtal ti Elíase, ti tsutesbe yo'ntonic ti jchi'iltique yu'un ac'o tspasic ti muc' ti Diose. Hech ts'ibabil comel uc ti sc'op ti Diose ti persa chquich' vocol, ho'oni ti co'ol crixchanoucutique, yu'un mu xispasucun ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Chacalbeic uc, ital xa ti Elíase, ja' ti Juane ti laj yac' ich'ho'e. Ja' laj spasic ti c'usi sc'an ti yo'ntonic ti crixchanoetique ti chopol tspasique. Hech ono'ox ts'ibabil sc'opilal ti Juane ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","C'alal ilaj yo'nton ti Jesuse, hech isut batel ti stojol ti yajchanc'opetic ti jayvo' ti te comen yu'une. Xchi'inoj ti oxvo'e. Hech yu'un c'alal ic'otic, joyubtabil yu'un ep crixchanoetic c'ot sta. Te oy uc ti jchi'iltac ti chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Stsacoj sbaic ti c'op xchi'uc ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Scotol ti crixchanoetique c'alal laj yilic ti Jesuse ich'ay yo'ntonic, anil ba sc'oponic. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ti Jesuse hech laj sjac'be: ―¿C'usi chajac'be ti cajchanc'opetique? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Itac'av jun ti much'utic te stsoboj sbaique: ―Maestro, laj quic' tal ti atojol ti jnich'one yu'un oy pucuj ti yo'nton yu'un uma' ti jnich'one. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Buc no'ox mi ch-ilbajinat yu'un, chp'aj ti lum, chvocan ye, xjep'et ye, chij sba. Laj calbe vocol ti avajchanc'opetique ti ac'o xisloq'uesbune. Muc xu' yu'unic xiscoltabucun ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Itac'av ti Jesuse, hech laj yalbe: ―Ho'oxuc ti li'oyoxuc li' ti balumil ti ora to mu'yuc xch'unojel avo'ntonic chquil. Ep xa c'ac'al li' jchi'inojoxuc mu to chach'unic. Ep xa c'ac'al jts'icojboxuc sbolil avo'ntonic acotolic ―xut―. Ic'o tal ti jtojol ti quereme ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hech laj yiq'uic tal ti stojol. Ti pucuje c'alal laj yil ti Jesuse ti ora lic yilbajin ti quereme. Ip'aj ti lum ti quereme. Te xbalet, chvocan ye. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ti Jesuse laj sjac'be ti stote: ―¿Jayib xa habil hech tsacbil? ―xut. Itac'av ti stote: ―Tsacbil c'alal biq'uit to ―xchi―. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ep vuelta ip'aj xa ti c'oc', ep vuelta ip'aj xa ti ho'. Tsc'an chmilat yu'un. Hech yu'un mi xu' avu'une, c'uxubimbun, coltabun ―x'utat ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ti Jesuse hech laj yalbe: ―Scotol tsta ti much'u chch'un ti chcoltaat cu'une ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ti ora tsots ic'opoj ti stot ti quereme, hech laj yalbe: ―Ti jch'un. Coltaun mi oy to sc'an ti jch'une ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","C'alal laj yil ti Jesuse ti tsnet' sbaic tal ti crixchanoetique, laj spas ti mantal ti ora ti pucuje, hech laj yalbe: ―Pucuj, ho'ot ti avabtel ti uma' ti quereme, ti mu xa'i c'ope, chajpas ti mantal. Loc'an tal ti yo'nton. Mu me xacha'och yan vuelta ti yo'nton ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tsots i'avan ti pucuje, ep laj yilbajin ti quereme. Hech iloc' ti yo'nton. Chamen x'elan icom ti quereme. Hech yu'un ep ti much'utic laj yalic: ―Icham xa ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ti Jesuse laj stsacbe sc'ob ti quereme, laj snit liquel yu'un ac'o va'luc. Hech iva'i ti quereme. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ti Jesuse hech ibatic xchi'uc ti yajchanc'opetique. Hech yu'un c'alal te xa oyic ti yut na ti bu chvay ono'ox ti Jesuse, ti yajchanc'opetique yu'un stuquic xa te o xchi'uc ti Jesuse lic sjac'beic ti Jesuse: ―¿C'u yu'un muc xu' cu'untutic jloq'uestutic ti pucuje? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ti Jesuse hech laj yalbe: ―Ja'to mi laj ac'oponic Dios, ja'to mi laj avipan abaic, ja'to chloc' ti jtos pucujetic lume ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iloq'uic batel ti Capernaum ti Jesuse xchi'uc ti yajchanc'opetique. Ixanavic batel te ti estado Galilea. Mu sc'an ti Jesuse mi oy much'u ch-a'yat ti te chanave. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yu'un tsc'an chchanubtas ti yajchanc'opetique. Hech laj yalbe: ―Chi'ac'at entrecal ti sc'ob viniquetic ho'on ti co'ol crixchanoucutique. Chismilucun, chicham, patil ti yoxibal c'ac'al chicha'cusesat loq'uel ti ch'en ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ti yajchanc'opetique ja' no'ox ilo'laj yo'ntonic yu'un mu xa'ibeic sjam. Hech yu'un muc sjac'beic xa. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Icha'sutic batel ti jteclum Capernaum yan vuelta. C'alal i'och xa ti na ti bu chvay ono'ox ti Jesuse, hech laj sjac'be ti yajchanc'opetique: ―¿C'usi ti alo'ile c'alal nijtal ti be? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Muc xtac'avic yu'un ja' no'ox laj stsaquilan sbaic ti c'op yu'un ti much'u totil chc'ot yu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hech yu'un inaqui ti Jesuse, hech lic yalbe ti lajchavo'ique: ―Ti much'u tsc'an ti totil chc'ot avu'unique, persa tsbic'tajes sba, persa chac' sba ti abatinel ti atojolic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ti Jesuse laj yic' tal ti stojol jun olol. Laj sva'an ti o'lol yo' bu oyique. Lic spet ti olole ti Jesuse. Hech lic yalbe ti yajchanc'opetique: ");
INSERT INTO tzoNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Scotol ti much'u tspas ti muc' jun olol hech chaj c'u che'el olol avi to ho'on ti jventa, ho'on chispasun ti muc' uc. Yu'un mi hech chapasun ti muq'ue, ja' chapas uc ti muc' ti Diose ti laj stacun talele ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ti Juane lic yalbe ti Jesuse: ―Maestro, oy much'u yac'oj sba tsloq'uesbe pucujetic ti yo'ntonic crixchanoetic ti aventa laj quiltutic. Hech yu'un laj jpajestutic yu'un ma'uc jchi'iltic ti abtel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ti Jesuse hech laj yalbe: ―Mu me xapajesic. Yu'un ti much'u tspas jchop o abtel ti jventae, mu yu'unuc chopol chiyalbun jc'opilal. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yu'un ti much'u mu cajcontraticuque ja' jchi'iltic obi. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ti much'u chayac'boxuc avuch'ic ho' manchuc mi jun no'ox taza ho' chayac'boxuc yu'un ti chachi'inucun ti ho'on ti Cristoune, ja' mu xch'ay ti yabtele. Ta ono'ox x'ac'batic bendición yu'un ti Diose yu'un ti hech laj spasique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Hech laj yalbe uc ti Jesuse: ―Ti much'u tsbolibtasbe yo'nton junuc ti ololetic li'to ti xch'unoj ti ho'on Jcoltavanejun yu'une, ja' lec ac'o chucbatuc ti snuc' cho' ac'o tenatuc ochel ti nab. Te chch'ay batel ti nab. Te tsjic' ti ho'e. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Hech yu'un mi chasbolibtasot ti ac'obe, ja' tsc'an ti mu'yuc ac'ob hech chaj c'u che'el ti much'u mu'yuc sc'obe. Hech cha'och ti utsilal. Ja' vocol mi chabatic ti c'atimbac yu'un ti mu xapajes abaique. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mi jutuc mu sna' xlaj o ti vocol te o yu'un mu sna' chtup' o ti c'oq'ue. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ja' no'ox hech uc mi chasbolibtasot ti bu chabate, ja' tsc'an ti mu'yuc avacan hech chaj c'u che'el ti much'u mu'yuc yacane. Hech cha'och ti utsilal. Ja' vocol mi chabatic ti c'atimbac yu'un ti mu xapajes abaique. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mi jutuc mu sna' xlaj o ti vocol te o yu'un mu sna' chtup' o ti c'oq'ue. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ja' no'ox hech uc mi chasbolibtasot ti c'u che'el chaq'uele, mu lecuc. Hech yu'un ja' tsc'an ti mu'yuc c'usi chaq'uel hech chaj c'u che'el ti much'u mu xc'ot sate. Hech cha'och ti bu tspas mantal ti Diose. Ja' vocol mi chabatic ti c'atimbac yu'un ti mu xapajes abaique. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mi jutuc mu sna' xlaj o ti vocol te o yu'un mu sna' chtup' o ti c'oq'ue. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Hech chaj c'u che'el persa laj yich' yats'amel ti ti'bol ti ja' smoton Diose ti vo'one yu'un hech lec chil ti smotone ti Diose, ja' no'ox hech uc persa chich' vocol li' ti balumile scotol ti much'u chists'acliune yu'un hech lec ch-ilat yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mi lec ti ats'ame, oy stu. Mi mu xa chi'uc ti ats'ame ¿c'usi chavut? Mu xa stac' chcha'chi'ub. Mu'yuc xa stu. Ja' no'ox hech uc ti ho'oxuque tsc'an ti oy yutsil avo'ntonique hech mu xabolibic, hech jtos avo'ntonic chac'otic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iloc' batel ti Jesuse, ibat ti estado Judea xchi'uc ti jech uc'um Jordán. Yan vuelta laj stsob sbaic tal ti stojol ti Jesuse ep jchi'iltac. Hech yu'un ti Jesuse lic xchanubtas yu'un hech ono'ox tspasilan. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Italic ti stojol ti Jesuse cha'vo' oxvo' ti fariseoetique. Yu'un sc'an spasbeic proval yo'nton ti Jesuse, hech laj sjac'beic: ―¿Mi stac' ti jsutes cajniltutic? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Itac'av ti Jesuse, hech laj sjac'be: ―¿C'usi laj yal ti Moisese? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Itac'avic: ―Ti Moisese laj yal ti persa tsts'iba ti jun ti c'usi sventailuc ti tsutes ti yajnile, hech xu' tsut yu'un, xchi ti Moisese ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Itac'av ti Jesuse, hech laj yalbe: ―Scoj ti tsots yo'ntonic ti antiguo jtatamoltique hech yu'un ti hech i'ac'bat lisensa yu'un ti Moisese ti tsutes yajnilique. Hech yu'un hech ts'ibabil comel. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mu hechuc ti sliqueb ti balumile. Yu'un ti Diose c'alal laj spas ti sba crixchanoe, jun vinic jun ants laj spas, ti xchi ti sc'op ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Hech ts'ibabil uc: “Hech yu'un ti viniquetique tscomes stot sme', chic' yajnil. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jun no'ox chc'ot xchi'uc yajnil. Hech yu'un mu cha'vo'uc icom yu'un jun no'ox ic'ot”, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hech yu'un ti much'utic jun no'ox ic'otic yu'un ti Diose, mu me sp'ev sbaic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Patil c'alal i'och xa ti yut na ti bu chvay ono'ox ti Jesuse, más ijac'bat sjam yu'un ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ti Jesuse hech laj yalbe: ―Scotol ti much'u tsutes ti yajnile, mi chic' yan ants, ja' chmulivaj obi. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mi tscomes smalal ti antse, mi chic' sbaic xchi'uc yan vinic, ja' chmulivaj obi ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ti jchi'iltaque laj yiq'uic tal ti stojol ti Jesuse ololetic yu'un ac'o yac' sc'ob ti Jesuse ac'o yac'be ti sjol ti ololetique. Ti yajchanc'opetique sc'an spajesic ti much'utic ti hech snopojique. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","C'alal laj yil ti Jesuse ti hech tsc'an tspajesvanic ti yajchanc'opetique, mu lecuc laj yil. Hech laj yalbe: ―Ac'o taluc ti jtojol ti ololetique. Mu me xapajesic yu'un ti much'utic tspasatic ti mantal yu'un ti Diose ja' hech chc'otic hech chaj c'u che'el olol. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Melel ti c'usi chacalbeique, ja'to mi chac'ot hech chaj c'u che'el olol, ja'to xu' chaspasot ti mantal ti Diose ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ti Jesuse laj spet ti ololetique, laj yac' sc'ob, laj yac'be ti sjolic ti ololetique, laj yac'be bendición scotolic. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","C'alal chloc' batel ti Jesuse, anil ital jun jchi'il. Tal squejan sba ti stojol ti Jesuse. Hech laj sjac'be: ―Maestro, ho'ot lequil vinicot. ¿C'usi chcut chicuxi sbatel osil? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ti Jesuse hech laj yalbe: ―¿C'u yu'un lequil vinicot xavutun? Mi junuc mu'yuc much'u lec, ja' no'ox stuc ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Chana' ti c'usi chal ti mantaletique. “Mu me xamulivaj. Mu me xamilvan. Mu me xa'elc'aj. Mu me xanopbe smul avecino. Mu me xalo'lavan. Paso me ti muc' atot ame'”, ti xchie ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Itac'av ti vinique: ―Scotol avi to jch'unoj c'alal nich'i tal ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Hech yu'un ti Jesuse laj sq'uelbe sat, c'ux laj ya'i. Hech laj yalbe: ―Oy to c'usi sc'an to avu'un. Batan, ba chono scotol ti c'utic oy avu'une, q'uelambo ti me'onetique. Hech oy ac'ulejal ti vinajel chc'ot. Patil chtal ats'acliun batel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ep laj yich' mul ti vinique yu'un ti hech i'albat yu'un ti Jesuse. Yu'un mu sc'an spas yu'un ep sc'ulejal li' ti balumile. Chich' mul ti c'alal isut batele. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hech yu'un ti Jesuse xmelmun lic sq'uelbe sat ti jchi'iltaque. Hech yu'un hech lic yalbe ti yajchanc'opetique: ―Vocol chac' sba ti ventainel yu'un ti Diose ti much'u jc'uleje ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ich'ay yo'ntonic ti yajchanc'opetique yu'un ti hech laj yale. Ti Jesuse laj xcha'albe yan vuelta: ―Jnich'nab, vocol chac' sbaic ti ventainel yu'un ti Diose ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Hech chaj c'u che'el mu xjelav jcot camello ti xchac acuxa, ja' no'ox hech uc ti much'u jc'uleje mu xu' chac' sba ti ventainel yu'un ti Diose ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Más ich'ay yo'ntonic. Hech laj sjac'be sbaic: ―¿Much'u cac'tic xu' chcol che'e? ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Hech yu'un ti Jesuse laj sq'uelbe satic, hech laj yalbe: ―Ti crixchanoetique mu xu' scolta sba stuc. Ti Diose scotol xu' yu'un tspas stuc yu'un jelaven sp'ijil ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hech yu'un ti Pedroe lic yalbe: ―Ho'ontutique scotol laj xa jcomestutic. Laj xa jts'acliotutic ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Itac'av ti Jesuse, hech laj yalbe: ―Melel ti c'usi chacalbeique, scotol ti much'u laj xa scomes mi sna, mi sbanquiltac, mi yits'inabtac, mi svixobtac, mi yixleltac, mi smucubtac, mi stot mi sme', mi yol xnich'nab, mi slum, ho'on ti jventa yu'un ac'o pucuc ti lequil ach' c'ope, ho'vinic vuelta ch-epaj xq'uexol ti ch-ac'bat ti ora to. Ch-ac'bat sna xchi'uc yermanotac, xchi'uc sme', xchi'uc yol xnich'nab, xchi'uc slum. Ta me xich' contrainel uc. Ti patil ta me xich' xcuxlejal sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Scotol ti much'utic hech tsnop ti yo'nton ho'on jbaejbeun mi xchi tsnop, ja' patil ti yantique mi xchi, ja' patil chc'otic lume. Ja' jbael chc'otic scotol ti much'utic mu hechuc tsnopique. Ja' ep ti much'utic patil chc'otique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ti Jesuse xchi'uc ti yajchanc'opetique c'alal ibatic ti be yu'un chmuic batel ti Jerusalén, ja' jbaejbe ti Jesuse. Ich'ay yo'ntonic ti yajchanc'opetique ti yu'un ja' jbaeltic no'ox chbat, mu'yuc sc'opilal cha'i mi oy c'usi chc'ot ti pasel te ti Jerusalén. Ti stuquique ixi'ic c'alal laj sts'acli batel. Hech yu'un ti Jesuse laj sq'uej sbaic xchi'uc. Lic yalbe ti c'usi chc'ot ti pasele. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Hech laj yalbe: ―A'yo me ava'yic, ta xa xijc'ot ti Jerusalén. Ho'on ti co'ol crixchanoucutique te chiyac'ucun ti sc'ob ti totil paleetique xchi'uc ti sc'ob ti jchi'iltic ti chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Ja' chixchapambucun jc'opilal yu'un chismilucun. Chiyac'ucun entrecal uc ti sc'ob yanlum viniquetic. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Chislabanucun, chiyac'bucun acial, chistubtabucun jsat. Patil chismilucun. Chicham, patil ti yoxibal c'ac'al chicha'cuxi loq'uel ti ch'en ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Hech yu'un ti xnich'nab ti Zebedeoe, ja' ti Jacoboe xchi'uc ti Juane, inopejic tal ti stojol ti Jesuse. Hech laj yalbeic: ―Maestro, ti jc'an ti chavac'buntutic ti c'usi chajc'ambote ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ti Jesuse hech laj sjac'be: ―¿C'usi chac'an chajpasboxuc? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hech itac'avic: ―C'alal cha'och ti pas mantal, ac'un xinaquitutic jun ti abats'ic'ob, jun ti ats'et ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Hech yu'un ti Jesuse hech laj yalbe: ―Mu xana'ic ti c'usi chac'ambune. ¿Mi xu' avu'unic chavich'ic vocol hech chaj c'u che'el chquich' vocol ho'oni? ¿Mi xu' avu'unic ti contrainel hech chaj c'u che'el chquich' contrainel ho'oni? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hech itac'avic: ―Xu' cu'untutic ―xchiic xtac'avic xcha'va'alic. Ti Jesuse hech laj yalbe: ―Melel ti c'u che'el chquich' vocol ho'oni, ti c'u che'el chquich' contrainel, hech chavich'ic uc. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ho'on mu xu' chacalbeic ti chanaquiic jun ti jbats'ic'ob jun ti jts'et. Chapal yu'un ti Jtote ti much'utic te chnaquiic ti jtojole ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ti xchi'iltaque ti lajunvo'e mu xtun laj ya'yic. Hech yu'un lic scontrain ti Jacoboe xchi'uc ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ti Jesuse laj yic' tal ti stojol ti lajchavo'ique. Hech laj yalbe: ―Chana'ic c'u x'elan tspasic ti ajvaliletic yu'un yanlum viniquetic. Chac' sbaic ti pasel ti muc'. Ti totiletic yu'unique ja' tsujvanic ti abtel. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mu me hechuc chapasic ti ho'oxuque. Ti much'u tsc'an ti totil chc'ot avu'unique, ja' chac' sba ti abatinel avu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ti much'u sc'an ti tspasat ti muc' avu'unique, ac'o me yac' sba ti abatinel ti atojolic. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hech me xapasic hech chaj c'u che'el ho'oni ti co'ol crixchanoucutique. Yu'un ho'oni ma'uc nital yu'un chi'abatinvan. Ja' tal cac' jba ti abatinel. Tal cac' jba ti milel sventa scolel scotol crixchanoetic ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hech yu'un ic'otic ti jteclum Jericó. Patil c'alal iloq'uic batel ti Jericó ti Jesuse xchi'uc ti yajchanc'opetique its'acliat batel yu'un ep jchi'iltac. Te snacanoj sba ti ti'be jun ma'sat c'ot sta. Bartimeo sbi ti ma'sate. Ja' tsc'an paramote. Ja' tsc'ambe ti much'utic te chjelave. Timeo sbi ti stot ti ma'sate. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ti ma'sate c'alal laj ya'i ti te ch-ech' ti Jesuse, ja' ti liquem tal ti Nazarete, hech laj yavta: ―Jesús, ho'ot ti yelnich'onot ti Davide ti ac'opilal chatale, c'uxubinun ―xchi chavta. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ti yan jchi'iltaque ti te xchi'inojic batel ti Jesuse sc'an spajesic. ―Anchan ―xutic. Más no'ox tsots laj yavta: ―Ho'ot ti yelnich'onot ti Davide, avocoluc me, c'uxubinun ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Laj sva'an sba ti Jesuse, hech laj yalbe ti crixchanoetique: ―Ic'bun me tal ―xut. Hech yu'un ba yiq'uic tal ti ma'sate. Hech laj yalbeic: ―Mu me xavich' mul. Lican, chayic'ot ti Jesuse ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hech yu'un ti ma'sate ti ora ilic. Laj sten comel ti xchije. Ital ti anil ti stojol ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ti Jesuse hech laj yalbe: ―¿C'usi chac'an chajpasbot? ―xchi. Itac'av ti ma'sate, hech laj yalbe: ―Maestro, avocoluc jambun jsat ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ti Jesuse hech laj yalbe: ―Xu' chabat. Icol xa ti asate yu'un laj ach'un ti xu' cu'un ―xchi. Ti ora ijam ti sate hech lic sts'acli batel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ti Jesuse xchi'uc ti yajchanc'opetique ic'otic xa ti jteclum Betfagé xchi'uc ti jteclum Betania te oy ti yolon vits Olivatic sbi. Ti bic'tal jteclumetique nopol xa xil sbaic xchi'uc ti Jerusalene. Hech yu'un c'alal te xa oy ti bic'tal jteclume, hech lic stac batel cha'vo' ti yajchanc'opetique ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Hech laj yalbe batel: ―Toj chabatic ti biq'uit jteclum lum toi. C'alal te cha'ochic batel, te chucul chc'o ataic ch'iom burro, ti mu'yuc to much'u scajlebinoje. Coltao, ic'bun talel. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mi chasjac'boxuc ti yajvale: “¿C'u stu avu'un ti jburroe?” mi xayute, “chtun yu'un ti Cajvaltique, chasutesbot ti ora”, xavut, xut ti cha'vo'ique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hech ibatic. Hech te chucul nopol ti'na c'ot staic ti ch'iom burroe te ti calle. Hech laj sjitumbeic yaq'uil yu'un chiq'uic batel. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Oy much'utic te va'ajtic hech ijac'batic yu'un: ―¿C'u stu avu'un ti chacoltaic batel ti jburroe? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hech lic xcholbe ya'yic ti c'u che'el i'albatic yu'un ti Jesuse. ―Lec oy che'e, iq'uic batel ―x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Hech laj yiq'uic tal ti ch'iom burroe ti bu oy ti Jesuse. Hech yu'un laj slambe xchijic ti spat. Hech yu'un lic scajlebin ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ep jchi'iltac laj sq'uiic xchijic ti be uc. Oy yantic laj sp'asic c'obte'. Laj sq'uiic ti be ti c'obte'e. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ti much'utic jbael ixanavique xchi'uc ti much'utic patil chtalique, co'ol tsots ic'opojic: ―¡Jun no'ox yutsil ti ajvalile ti itacat xa tal ti jtojoltic yu'un ti Cajvaltic Diose! ―xchiic―. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Jun no'ox yutsil ti chispasucutic ti mantal ja' xq'uexol ti jtatamoltic Davide! ¡Ac'o spasic ti muc' ti Diose scotolic te ti vinajel uc! ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Hech i'och ti Jerusalén ti Jesuse. Te i'och ti yut templo. C'alal laj yo'nton laj sq'uel scotol ti c'usitic te oye, yu'un mal xa c'ac'al, hech yu'un iloc' batel ti Jesuse. Isut batel ti jteclum Betania xchi'uc ti lajchavo' yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Hech yu'un ti yoc'omal iloq'uic tal ti Betania chbatic ti Jerusalén. Hech yu'un ivi'naj ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Laj yil jtec' igote' nom to. Oy yanal laj yil. Hech yu'un ba sq'uel mi repenta oy sat. Mu'yuc sat c'o sta, ja' no'ox yanal yu'un mu to yorailuc chac' sat. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hech yu'un ti Jesuse laj yalbe ti igote'e: ―Mi jutuc mu xa xasatin ―xut. Te yabinojic ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hech ic'otic ti Jerusalén. Te i'och ti yamaq'uil templo ti Jesuse. Lic sten loq'uel ti yamaq'uil templo ti much'utic ti te chchonilajique chmanilajique, ja' ti jchonvacaxetique, ti jchoncarneroetique. Laj sbut'q'uimbe smesa ti jeltaq'uinetique. Laj sbut'q'uimbe snacleb ti much'utic chchonic culajteetique. Yu'un ti templo cu'untutic te ti Jerusalene ja' te chismililambuntutic ti smoton ti Diose ti paleetic cu'untutique hech chac c'u che'el yalojbuntutic ono'ox ti Diose, ho'ontutic ti judiountutique. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Laj yal mantal ti mu me much'u chjelav xa xchi'uc yicatsic te ti yamaq'uil ti temploe. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Lic chanubtasvanuc ti Jesuse, hech laj yalbe: ―¿Mi mu hechuc ts'ibabil comel ti sc'op ti Diose: “Ti Jnae ja' sventa ti chisc'oponun scotol crixchanoetic ti jaylajuntos li' ti balumile”, ti xchi ti Diose? Ho'oxuque laj xa ac'atajesic ti xch'en j'eleq'uetic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Te oyic ti jchi'iltac ti ichanubtasvan ti smantal ti Diose ti scuyoj sbaique xchi'uc ti totil paleetique. Hech yu'un i'ilinic. Hech yu'un lic snopic c'u che'el tsmilic ti Jesuse. Ixi'ic yu'un ti Jesuse yu'un scotol ti jchi'iltaque lec laj ya'yic ti c'u che'el laj yac' ti a'yel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ti c'alal imal ti c'ac'ale, iloc' batel ti Jerusalén ti Jesuse xchi'uc ti yajchanc'opetique, isutic batel ti Betania. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sob ic'luman ti yoc'omal c'alal isutic tal laj yilic ti igote'e, taquijem xa xchi'uc yibil. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","It'ab ti yo'nton ti Pedroe, hech yu'un hech laj yalbe ti Jesuse: ―Maestro, q'uelo avil, taquijem xa ti igote'e ti laj avac'be castigoe ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Itac'av ti Jesuse, hech laj yalbe: ―Ch'unic ti scotol xu' yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yu'un melel ti c'usi chacalbeique, mi oy xch'unojel avo'ntonic, mi mu xchibaj avo'ntonic, mi chach'unic ti chc'ot ti pasel ti c'usi chavalique, hech chc'ot ti pasel avu'unic scotol ti c'usi vocol ti pasel ti mu xu' avu'unique. Hech chaj c'u che'el mi chavale: “Ac'o sq'uej sba batel ti vits li'to, ac'o ochuc ti nab”, mi xachiique, hech chaspasbot ti Diose hech chac c'u che'el laj ac'ambee. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hech yu'un chacalbeic, scotol ti c'usi chac'ambeic ti Diose ch'unic ti cha'ac'batic, hech chc'ot ti pasel. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","C'alal chac'oponic ti Diose, mi chana' ti oy much'u staoj smul ti atojol, pasbo perdón yu'un hech chaspasbot perdón uc ti amul ti ataoj ti stojole ti Jtotique ti te oy ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yu'un mi mu xapasbeic perdón yan, hech mu xaspasboxuc perdón uc ti amule ti Jtotique ti te oy ti vinajele ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ti Jesuse xchi'uc ti yajchanc'opetique isutic batel ti Jerusalén. Ti c'alal yac'oj sba chanav batel ti yamaq'uil templo ti Jesuse, italic ti stojol ti Jesuse ti totil paleetique xchi'uc ti jchi'iltac ti ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique, xchi'uc ti moletique. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Hech laj sjac'beic: ―¿Much'u smantal avich'oj ti hech laj aten loq'uel ti jchonolajeletique li' ti yamaq'uil ti temploe? ¿Much'u laj yac'bot avabtel yu'un hech chapas? ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Itac'av ti Jesuse, hech laj yalbe: ―Oy c'usi chajac'be uc. Albun chca'i ti c'usi chajac'bee hech chacalbe uc ti much'u laj yac'bun ti cabtele. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Hech chajac'be: Ti Juane ¿much'u i'ac'bat yabtel yu'un ti laj yac' ich'ho'e? ¿Mi yu'un Dios i'ac'bat yabtel o mi yu'un crixchanoetic i'ac'bat yabtel? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Hech lic yalbe sbaic: ―“Yu'un Dios”, mi chijchie, “¿c'u yu'un muc xach'unic che'e?” ta me xijyutucutic. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Yu'un crixchanoetic”, mi chijchie, ja' chijxi' yu'un ti crixchanoetique yu'un scotolic xch'unojic ti ja' j'alc'op yu'un Dios ti Juane ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hech yu'un hech laj yalbeic ti Jesuse: ―Mu jna'tutic ―xchiic. Ti Jesuse hech laj yalbe: ―Hechun uc, mu xacalbe much'u laj yac'bun ti cabtele ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ti Jesuse lic yalbe lo'il ti jchi'iltaque. Oy sjam ti lo'il ti laj yalbee. Hech laj yalbe: ―Oy jun vinic laj sts'un ep uvate'. Laj spas macte'ton ti sjoylejal. Laj sjomic ton yo' bu tsloq'uesbe ya'lel sat ti uvate'e. Laj spas jun na, toyol ti solel ti nae. Ja' sventa tsq'uel scotol ti uvate'e. ’Laj sa' yaj'abtel yu'un chchabibat ti slume. Patil nom ibat ti yajval ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","C'alal ista xa yorail itoc'onaj ti sat ti uvate'e, laj stac talel jun smozo yu'un chc'ot sc'opon ti jchabiejbalumile. C'ot sc'ambeic tal ti sate. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ti jchabiejbalumile itsacvanic, laj stsaquic ti mozoe, laj smajic. Laj staquic sutel. Xch'ixch'un sutel ti mozoe. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ti yajval ti balumile laj xcha'tac talel yan smozo. Ti jchabiejbalumile laj yac'beic ton, laj syajesbeic sjol, laj yilbajinic. Patil laj staquic sutel. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ti yajval ti balumile laj xcha'tac talel yan smozo. Laj smilic. Oy ep yantic itacatic talel uc. Oy ja' no'ox laj smajic, oy laj smilic o. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ti yajval ti balumile oy jun no'ox snich'on. Ep c'ux ti yo'nton ti snich'one. Ja' slajebal xa laj stac talel ti stojolic. Hech laj yal: “Ja' chispasbucun ti muc' ti jnich'one”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ti jchabiejbalumile c'alal laj yilic ti ja' snich'on ti yajval ti balumile, hech laj yalbe sbaic: “Ja' yajval balumil chcom avi to. Jmiltic. Ho'ucutic chquich'betic comel ti slume”, xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hech yu'un laj stsaquic, laj smilic, laj stenic loq'uel ti bu ts'umbil ti uvate'e. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Ti yajval ti balumile ¿c'usi chc'ot pasbatuc xana' ti jchabiejbalumil yu'une? Ja' xtal milatuc. Yan tsa' yu'un chac'be xchabi ti uvate' yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Mi mu hechuc aq'ueloj uc ti sun ti Diose: Hech chaj c'u che'el ti yajval nae ti laj yotes ti chiquina ti tone ti mu xtun laj yilic ti yaj'abtele, ja' no'ox hech laj xa yich' tsots yabtel yu'un ti Diose ti much'u t'ujbil yu'une ti ja' mu sc'anique. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ja' yabtel ti Cajvaltic Diose. Jun no'ox yutsil chc'ot ti jtojoltic, ti xchie? ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sc'an stsaquic ti Jesuse yu'un laj sna'ic ti ja' sc'opilal stuquic ti lo'il ti icholbatic ti totiletique. Ixi'ic yu'un ti crixchanoetique hech yu'un muc stsaquic. Hech ibatic. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Itacatic talel cha'vo' oxvo' ti fariseoetique xchi'uc ti svinictac ti Herodese yu'un ac'o sjaq'uilambeic ti Jesuse yu'un ac'o loc'uc ti ye ti bu xu' tstabeic smul tscuyic. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hech italic, tal sjac'beic: ―Maestro, ti jna'tutic ti melel scotol ti c'usi chavale. Co'ol chac'opon scotol, manchuc mi tsots yabtel yich'oj, manchuc mi mu'yuc yabtel. Co'ol chavil scotol crixchanoetic. Chavac' ti chanel ti sbe ti Diose ti mero melel. Hech yu'un chajac'betutic: ¿Mi stac' chcac'betutic patan ti Césare, mi mu stac'? ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ti Jesuse laj sna' ti chlo'lavanique. Hech yu'un laj yalbe: ―¿C'u yu'un chapasbun proval co'nton? Ac'bun jq'uel junuc ataq'uin ti ja' yu'un ti jtoj ti jpatantique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hech yu'un ba yich' tal jun denariotaq'uin. Ti Jesuse hech laj sjac'be: ―¿Much'u sloc'tombail ti o'loli? ¿Much'u sbi te oy ti sti'ile? ―xut. Hech itac'avic: ―Ja' ti Césare ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Itac'av ti Jesuse, hech laj yalbe: ―Oy c'usi stac' chach'umbeic ti Césare yu'un ja' totil ajvalil. Ja' no'ox hech uc ti Diose, tsc'an chach'unic ti c'u che'el tsc'an ―xut. Ich'ay yo'ntonic yu'un ti hech i'albatique. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Patil ital ti saduceoetique, ja' ti chalic ti mu'yuc much'u chcha'cuxie. Tal sjac'beic ti Jesuse: ");
INSERT INTO tzoNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, hech laj sts'iba comel ti Moisese. “Mi oy much'u mu'yuc yol snich'on ti c'alal chcham, ti its'inale ti mu to oyuc yajnile ac'o yic'be yajnil ti sbanquile yu'un hech c'alal ch-an sba yol snich'on xu' chac'be xq'uexolin ti sbanquile yu'un hech mu xtup' sbi ti sbanquile”, ti xchi ti Moisese. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oy laj jchi'intutic hucvo' viniquetic. Yermano sbaic ti hucvo'ique. Ti banquilale laj yic' yajnil, patil icham. Mu'yuc yol snich'on icom. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hech yu'un ti yutse laj yic'be yajnil ti ánima sbanquile. Patil icham. Mu'yuc yol snich'on icom. Hech laj spasic scotolic o. Xmelmun laj yiq'uic sucva'alic. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mu'yuc yol snich'on ichamic scotolic. Patil icham uc ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ti c'alal tsta yorail ti chcha'cuxiique, ¿much'u junuc yajnil chc'ot ti antse? Melel ti xmelmun laj yiq'uic scotolic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Hech itac'av ti Jesuse: ―Ch'ayemoxuc yu'un mu xana'ic c'usi chal ti sun ti Diose. Mu xana'ic c'u x'elan sp'ijil ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","C'alal chcha'cuxiic scotolic, mu'yuc xa yajnil viniquetic, mu'yuc xa smalal antsetic. Hech chc'otic hech chaj c'u che'el ti ch'ul abatetic yu'un ti Diose ti te oyic ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yu'un ti mu xach'unic ti chcha'cuxiic ti ánimaetique, ¿mi yu'un mu aq'uelojbeic sc'opilal te ti sun ti Moisese ja' ti c'alal ic'oponat yu'un ti Diose te ti bu jtec ch'ix? Manchuc mi ep xa habil chamenic ti Abrahame xchi'uc ti Isaaque xchi'uc ti Jacobe, hech ch-albatic to sc'opilal: “Ho'on Diosun yu'un ti Abrahame xchi'uc ti Isaaque xchi'uc ti Jacobe”, ti xchi ti Diose. Yu'un cuxajtic. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yu'un ja'uc j'ech'el ichamic oe, mu'yuc xa dios yu'unic. Hech yu'un ti Diose ja' yu'unic ti much'utic cuxajtique. Hech yu'un ep nach'ayic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Inopej talel jun jchi'il ti ichanubtasvan ti smantal ti Diose ti scuyoj sbae. Ja' laj ya'i ti yac'oj sba stsac sbaic ti c'op xchi'uc ti saduceoetique ti Jesuse. Laj sna' ti lec itac'av ti Jesuse, hech yu'un laj sjac'be ti Jesuse: ―Ti scotol ti smantal ti Diose ti laj yal ti Moisese, ¿c'usi mantalil ti más tsots sc'opilale? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ti Jesuse hech laj yalbe: ―Ti scotol ti smantal ti Diose, ja' tsots sc'opilal avi to: “A'yo me ava'yic, ho'ucutic ti yelnich'onucutic ti Israele. Jun no'ox ti Cajvaltic cu'untique, ja' ti Cajvaltic Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","C'ux me xava'yic ti Cajvaltic Diose xchi'uc scotol avo'nton xchi'uc scotol ap'ijil xchi'uc scotol avip”, ti xchie. Ja' mero sba mantal obi. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ti xchibal mantal co'ol tsots sc'opilal xchi'uc. “C'ux me xava'i avecino hech chaj c'u che'el c'ux xava'i aba”, ti xchie. Ja' tsots sc'opilal ti xchibal li'to ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hech yu'un i'albat yu'un ti jchanubtasvaneje: ―Melel ti hech laj avale, Maestro. Jun no'ox Dios oy, mu'yuc yan. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Melel ti ja' tsots sc'opilal ti c'ux chca'itic ti Diose xchi'uc scotol co'ntontic xchi'uc scotol jp'ijiltic xchi'uc scotol quiptic, ti c'ux chca'itic uc ti jvecinotique hech chaj c'u che'el c'ux chca'i jbatique. Ja' mu tsotsuc sc'opilal scotol ti smoton ti Diose ti jchic'tique xchi'uc ti jmiltique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ti Jesuse laj ya'i ti lec itac'av ti vinique, hech yu'un laj yalbe: ―Jutuc xa sc'an yu'un chavac' aba ti ventainel yu'un ti Diose ―xut. Scotolic ixi'ic, hech mu'yuc xa much'u lic sjac'beic. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","C'alal ichanubtasvan te ti yut templo te ti Jerusalén ti Jesuse, hech laj sjac'be ti jchi'iltaque: ―¿C'u yu'un ti hech chalic ti jchi'iltic ti chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique ti ja' no'ox chch'unic ti yelnich'on David ti Cristoe, ja' ti ac'bil yabtel yu'un ti Diose? ");
INSERT INTO tzoNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yu'un ti Davide hech laj yal ti sventa ti Ch'ul Espíritue: Ti Cajvale hech i'albat yu'un ti Diose: “Chlic naclan li' ti jbats'ic'ob ja'to mi laj jtsalbot scotol avajcontra”, x'utat ti Cajvale, xchi ti Davide. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Hech yu'un ma'uc no'ox yelnich'on yu'un “Cajval”, xchi ti stojol ―xchi ti Jesuse. Ep ti crixchanoetique ti te stsoboj sbaique nichim no'ox yo'ntonic laj ya'ibeic sc'op ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ja' hech ti smantal ti Jesuse ti laj yac'be xchanique: ―P'ijanic me, mu me xalajic ti lo'lael yu'un ti jchi'iltic ti chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Lec cha'yic ti c'alal chanavic batel tslapic natil sc'u'ic. Lec cha'yic ti ep chc'oponatic yu'un crixchanoetic te ti plaza. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lec cha'yic chnaquiic ti sba naclebaletic ti yut templo cu'untique. Lec cha'yic chnaquiic ti sba naclebal c'alal oy q'uin. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tspojbeic ti c'utic oy yu'un ti me'on antsetique. Hech yu'un hovil ti hal tsc'oponic ti Diose. Ja' no'ox tstoyilan smulic yu'un ti hech tspasique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Te inaqui ti Jesuse ti yut templo yo' bu oy scajonal ti taq'uine ja' ti yav ti smoton ti Diose. Ti Jesuse laj yil ti yac'oj sbaic tstiq'uic ochel ti staq'uinique ti bu yav ti smoton ti Diose. Oy jc'ulejetic ep taq'uin laj yaq'uic. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Te ital jun me'on ants ti uts sba ti jyalel laj yil ti Jesuse. Ti antse laj stic' ochel chib cinco. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ti Jesuse hech lic yalbe ti yajchanc'opetique: ―Melel ti c'usi chacalbeique, ti me'on ants li'to, ja' más ep laj yac' chil ti Diose. Ja' jutuc no'ox laj yac' scotol ti yantique chil ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yu'un ti jc'ulejetique scotolic sobrail xa staq'uinic laj yac'beic ti Diose. Ja'uc ti me'on ants li'to ja' scotol laj yac' ti c'u yepal oy yu'un yu'un tsmac'lin sbae ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","C'alal iloq'uic ti templo te ti Jerusalén ti Jesuse xchi'uc ti yajchanc'opetique, te oyic ti yamaq'uil templo, hech lic yal jun ti yajchanc'ope: ―Maestro, t'ujum no'ox ti muc'tic naetic yu'un ti templo li'to. T'ujum no'ox ti tonetic yu'un ti temploe ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Itac'av ti Jesuse, hech laj yalbe: ―Ti muc'tic naetic li'to ti t'ujum no'ox chavilic ti ora to, hovil. Melel ti c'usi chacalbeique, mi jp'ejuc ton mu'yuc bu chcom ti sba yan ton yu'un scotol chtal sjin ti yan c'ac'al yan crixchanoetic ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ti Jesuse xchi'uc ti yajchanc'opetique ba nacluc ti bu vits Olivatic sbi te ti bu nopol xil sbaic xchi'uc ti templo te ti Jerusalene. Hech yu'un ti Pedroe xchi'uc ti Jacoboe xchi'uc ti Juane xchi'uc ti Andrese, c'alal stuquic xchi'uc ti Jesuse, hech lic sjac'beic ti Jesuse: ");
INSERT INTO tzoNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Albun ca'itutic c'usi ora hech chjinat ti temploe. ¿C'usi señail ti jq'ueltutic c'alal chlaj scotol? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ti Jesuse hech lic yalbe: ―P'ijanic me, mu me xalajic ti lo'lael. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Melel ti ep chtalic chalic “ho'on jcoltavanejun”, xchiic. Ep ti much'utic chlaj ti lo'lael yu'un ti hech chalique. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Ti yan c'ac'al chava'ibeic sc'opilal ti oy ep muc'ta pleito li' ti balumile. Chava'ibeic sc'opilal uc ti chlic yan muc'ta pleito. Mu me xaxi'ic. Persa scotol hech chc'ot ti pasel. Mu to ja'uc slajebal c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ti crixchanoetic ti jun balumile ja' tscontrain ti yan crixchanoetic ti yan balumile. Ti ajvaliletique tscontrain sbaic. Buc no'ox chnic ti balumile. Chtal vi'nal. Avi c'usi laj cale, ja' sliqueb to no'ox ti vocole. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Ti ho'oxuque p'ijanic me, yu'un oy jchi'iltic chlic yac'oxuc entrecal ti sc'ob ti much'utic oy yabtelic te ti templo. Oy ti j'abteletique ti chayac'boxuc acial te ti yut templo yu'unique. Oy chayic'oxuc batel ti stojol gobernadoretic xchi'uc ti stojol yan ajvaliletic ho'on ti jventa. Hech chacholbucun jc'op ti stojolic. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yu'un ti c'alal mu to sta slajebal c'ac'al, ja' chich' cholel ti lequil ach' c'ope ti jaylajuntos ti crixchanoetic li' ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","C'alal cha'ic'atic talel yu'un cha'ac'at entrecal ti sc'obic, mu me xanopilan ti avo'ntonic c'usi chc'o avalic. Ja' cha'albatic ti avo'ntonic ti c'u che'el chatac'avique. Mu ho'ucot ti chac'opoje, ja' chaxch'amumbot ave ti Ch'ul Espíritue. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Oy chac' ti milel yits'in. Oy chac' ti milel snich'on. Oy tscontrain stot sme', chac' ti milel uc. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Chayilintaoxuc scotol crixchanoetic ho'on ti jventa. Ti much'u scotol chcuch yu'un c'alal tsta ti slajebal c'ac'al, ja' chcol ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","A'ibeic me sjam ti c'usi chajts'ibaboxuc li'to. Hech laj yal uc ti Jesuse: ―C'alal chaq'uelic ti ixtambil ti jyalel ti temploe hech chaj c'u che'el laj yal ti Daniele, ja' ti j'alc'op yu'un ti Diose ti vo'one, anil me batanic ti vits ho'oxuc ti li'oyoxuc li' ti Judeae. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ti much'utic muemic ti yamaq'uil sjol sna, c'alal chyal tal, mu xa me c'usi chba stam loq'uel ti c'usi oy yu'un te ti yut sna. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ti much'utic te oyic ti xchobique, mu xa me sut batel yu'un tstam loq'uel ti xchije. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Uts sbaic ti much'utic slicojic yole xchi'uc ti much'utic oy yol chchu'unic toe. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","C'ambeic vocol ti Diose ti ma'uc ti yorail sic ti c'alal chajatavique. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Melel ti ep ti vocol chtale. Mu'yuc bu hech yan vocol c'alal ilic ti balumile asta ti ora to. Mu'yuc bu hech yan vocol chtal yan vuelta. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ti manchuc tscomejes ti yorail vocole ti Diose, mu'yuc much'u chcol ti hechuque. Ti sventa scotol ti much'utic t'ujbilic yu'une, hech yu'un ti Diose tscomejes ti yorail vocole. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Hech yu'un mi oy much'u chayalbot: “Q'uelo avil, ja' Cristo li'to”, mi xayutote, “Ja' Cristo lume”, mi xayutote, mu me xach'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Melel ti chtalic nopbilal cristoetic xchi'uc nopbilal j'alc'opetic yu'un Dios scuyoj sbaic. Chaq'uic ti q'uelel señailetic xchi'uc jchop o abteletic hech tslo'laic scotol ti crixchanoetique. Taca hu'uc yu'unique tsc'an tslo'laic uc ti much'utic t'ujbilic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","P'ijanic me, laj xa me calboxuc scotol. Mu to chc'ot ti pasel. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’C'alal mi i'ech' xa ti yorail vocole, ch-ic'ub ti c'ac'ale. Mu xac' squeval uc ti ue. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Chp'aj yal tal ti c'analetique. Chnic scotol ti c'utic te oy ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ti crixchanoetique chisq'uelun ti chiyal tal ti vinajel xchi'uc toc, ho'on ti co'ol crixchanoucutique. Chvinaj ti jelaven jp'ijile. T'ujum ti jqueval chilique. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ti jtac yal tal ti ch'ul abatetic cu'une. Chtal stsobic ti much'utic t'ujbilic cu'une ti buc no'ox oyic ti sjoylejal balumile. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Nopic me c'u x'elan ti chjel ti igote'e li' ti jlumaltiqui. C'alal ch-ach'ub ti sc'obe, chloc' yanal. Ti c'alal chaq'uel ti yanale, chana'ic ti po'ot xa tsta yorail ho' li'i. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hech ono'ox uc c'alal chaq'uelic ti chc'ot ti pasel scotol ti vocol ti laj calboxuque, chana'ic ti po'ot xa tsta yorail chital, ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Melel ti c'usi chacalbeique, oy mu to chachamic ja'to mi ic'ot xa ti pasel scotol ti vocol ti laj xa calboxuque. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Chlaj ti vinajele xchi'uc ti balumile. Ti jc'ope ja' mu xlaj stuc. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Mi junuc mu'yuc much'u sna' c'usi ora, c'usi c'ac'alil ti chc'ot ti pasele. Mu sna'ic uc ti ch'ul abatetique ti te oyic ti vinajele. Mu jna' uc ho'on ti Nich'onilune. Stuc no'ox sna'oj ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’P'ijanic me, q'ueleluc me asatic, c'oponic Dios yu'un mu xana'ic c'usi ora chc'ot ti pasel. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ja' hech chaj c'u che'el ti jun vinique ti c'alal nom ibat, laj spas comel ti mantal ti smozotaque ti ac'o chabibatuc ti snae. Laj yac'be comel yabtel jujun. Laj yalbe comel ti jchabiejti'nae ti viq'uiluc me asate, mu me xavay, xut comel. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hech yu'un q'ueleluc me asatic yu'un mu xana'ic c'usi ora chital ho'on ti Avajvalune, mi sapet osil chital, mi ti o'lol ac'ubal, mi c'alal ch-oc' quelem, mi ti sob ic'luman. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Q'ueleluc me asatic naca me vayalucoxuc c'alal chitale. ");
INSERT INTO tzoNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ti ho'oxuque laj xa calboxuc. Hech chcalbe scotol crixchanoetic. Q'ueleluc me asatic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ho'ontutic ti yelnich'onuntutic ti Israele oy q'uin ti jpastutic yu'un ti jna'tutic ti c'u che'el laj scolta loq'uel ti Egipto ti antiguo jtatamoltutique ti Diose. Ja' Pascua sbi ti q'uine. Oy yan sbi uc. Ja' q'uin yu'un ti caxlan vaje ti mu pumesbiluc xch'ute. Chib xa no'ox c'ac'al tsc'an ti q'uin Pascuae, ja' hech yorail lic xchapambeic sc'opilal ti Jesuse ti totil paleetique xchi'uc ti jchi'iltac ti ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Laj xchapic ti c'u che'el tstsaquic ti mucul, ti c'u che'el tsmilique. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","―Ja' lec mi mu jpastic ti mero q'uin c'alal stsoboj sbaic ti crixchanoetique. Ja'to mi i'ech' ti q'uine naca me licuc c'op yu'unic. Ja' ti jsa'tic ti c'alal mu xchi'ucuc ti crixchanoetique ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Te oy ti Betania ti Jesuse. Te i'och ti sna ti Simone, ja' ti Simon ti yich'oj c'a'el chamel ono'oxe ti icoltaat yu'un ti Jesuse. C'alal te nacal ti mesa ti Jesuse yu'un chve', ital jun ants yich'oj tal sjarro pasbil ti alabastroton. Nojem ti perfume ti sjarroe. Nardo sbi ti perfumee. Toyol stojol ti perfumee. Laj svoc' ti sjarroe, laj smalbe ti sjol ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Oy cha'vo' oxvo' i'ilinic yu'un ti hech laj spas ti antse. Hech laj yalic: ―¿C'u yu'un chac' ch'ayuc avi to? ");
INSERT INTO tzoNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ti lajuc xchone, más ti oxib ciento iloc' stojol ti hechuque. Ja' lec ti lajuc yac'be ti taq'uine ti me'onetique ―xchiic. Hech laj stabeic ti alel ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ti Jesuse hech laj yalbe: ―Mu me xavut avi ants li'to. ¿C'u yu'un chavac'be yich' mul? Lec ti c'usi laj xa spasbune. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Scotol c'ac'al achi'inojic ti me'onetique. C'usuc no'ox ora xu' chac'uxubinic. Ti ho'one mu scotoluc c'ac'al li' jchi'inojoxuqui. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ti ants li'to laj xa yac' ti c'usi oy yu'une. Ti laj scajmalbun ti jbec'tal avi perfume li'to, ja' yu'un ti chichame. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Melel ti c'usi chacalbeique, ti scotol balumil buc no'ox chich' cholel ti lequil ach' c'ope, chcholbat sc'opilal uc ti hech laj xa spasbun ti antse. Hech ch-a'ibat sc'opilal o ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Lajchavo' ti yajchanc'op ti Jesuse. Oy jun ja' Judas Iscariote sbi. Ja' ba sc'opon ti totil paleetique yu'un tspas trato yu'un snopoj xa ti chac' entrecal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ti c'alal laj ya'yic ti totil paleetique, nichim no'ox yo'ntonic. Laj yalbeic ti lec chtojat mi ic'ot ti pasele. Ti Judase ti ora lic snop ti yo'nton c'u che'el chac' entrecal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ti sba c'ac'alil ti q'uine c'alal ti jve'tutic caxlan vaj ti mu pumesbiluc xch'ute, c'alal ti jmiltutic ti ch'iom carneroe ti jti'tutic ti q'uin Pascuae, ti yajchanc'opetique hech laj sjac'beic ti Jesuse: ―¿Bu chac'an chajmeltsambe ti ch'iom carnero ti ti jti'tique sventa q'uin Pascua? ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ti Jesuse laj stac batel cha'vo' ti yajchanc'opetique. Hech laj yalbe: ―Batanic ti Jerusalén. Te chataic ti be jun vinic, scuchoj ho' ti sq'uib. Ja' xats'acliic batel. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ti bu na ti ch-och batele, hech chavalbe ti yajval nae: “Hech chal ti Maestroe: ¿Bu oy ti cuartoe yo' bu sc'opilal ti jti' ti ch'iom carnero sventa q'uin Pascua xchi'uc ti cajchanc'opetique? xchi ital sc'op”, xavutic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ta me xayac'bot avilic muc'ta cuarto te ti xcha'cajal sna, chapambil xa. Te chachapambucutic ti ve'elile ―xut batel. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hech ibat ti cha'vo' yajchanc'opetique. I'ochic ti yut Jerusalén. Hech laj staic ti vinique hech chac c'u che'el i'albatic batele. Te laj smeltsanic ti ch'iom carnero sventa ti q'uin Pascuae. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ti c'alal ital ti mesa ti Jesuse xchi'uc ti lajchavo' yajchanc'opetique, ja'to no'ox i'ic'ub osil. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","C'alal te nacajtic ti mesa ive'ic, ti Jesuse hech laj yalbe: ―Melel ti c'usi chacalbeique, oy jun ti li' jchi'inojtique, ja' ti co'ol chijve'ucutic xchi'uque, ja' chiyac'un entrecal ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Scotolic laj yich'ic mul. Hech yu'un lic yalbeic ti Jesuse: ―Mu ho'ucun, Cajval ―xchiic liquel scotolic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","―Ja' ti co'ol chijve'ucutic xchi'uque, ja' ti co'ol lajchavo'oxuc xchi'uque ―xchi ti Jesuse―. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ho'on ti co'ol crixchanoucutique chicham hech chaj c'u che'el ts'ibabil comel jc'opilal. Uts sba ti much'u chiyac'un entrecale, ho'on ti co'ol crixchanoucutique. Ja' lec ti ma anuque ti vinique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","C'alal ive'ic, ti Jesuse laj stam jun caxlan vaj, laj yalbe vocol ti Diose, laj xet' ti caxlan vaje, laj yac'be ti yajchanc'opetique. Hech laj yalbe: ―Ilo, ve'anic, ja' jbec'tal li'to ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Patil laj stsac jun vasyo. Te tiq'uil ya'lel sat uvate'. Laj yalbe vocol ti Diose, laj yac'be. Scotolic laj yuch'ic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ti Jesuse hech laj yalbe: ―Ja' jch'ich'el li'to. Chcac' jba ti milel chloc' ti jch'ich'ele. Ti jch'ich'ele ja' señail ti mu xch'ay ti ach' c'op ti yaloj ti Jtote ti c'u che'el chcolic scotol ti much'utic t'ujbilic yu'une. Yu'un jtuc chcac' jba ti milel hech chch'ay smul scotol crixchanoetic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Melel ti c'usi chacalbeique, ja'to mi laj sta yorail laj jtsob jbatic jcotoltic yo' bu tspas mantal ti Jtotic Diose, ja'to chcuch'be xq'uexol ti ya'lel sat uvate'e avi to ho'oni ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","C'alal laj yo'ntonic iq'uejinic yu'un ti Diose, iloq'uic batel xchi'uc ti Jesuse. Ibatic ti vits Olivatic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ti Jesuse hech laj yalbe: ―Ti ora to ti ac'ubaltic acotolic chchibaj avo'ntonic ti jtojol. Yu'un hech ts'ibabil comel ti sc'op ti Diose: “Chcac' ti milel ti jpaxtole, hech chpuc batel ti scarneroe”, ti xchi ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero c'alal chicha'cusesat loq'uel ti ch'en, ho'on chibaej batel avu'unic te ti Galilea ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ti Pedroe hech laj yalbe: ―Manchuc mi chchibaj yo'nton ti atojol ti yantique, mu xchibaj co'nton ho'oni ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ti Jesuse hech laj yalbe: ―Melel ti c'usi chacalbee, ja' avi ac'ubal to c'alal mu to ch-oc' chib vuelta quelem, laj xa amucun ti avo'nton oxib vuelta ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Más tsots laj yal ti Pedroe: ―Manchuc mi co'ol chismilucutic, muc chajmuc ti co'nton ―xchi. Hech laj yalic uc scotolic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ic'otic xchi'uc ti Jesuse te ti bu balumil, Getsemaní sbi. Ti Jesuse hech laj yalbe ti yajchanc'opetique: ―Comanic li'to, chba jc'opon Dios li' no'oxi ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Laj yic' batel ti Pedroe xchi'uc ti Jacoboe xchi'uc ti Juane. Lic yich' mul ti Jesuse. Lic yich' vocol. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Hech laj yalbe: ―Ep chquich' mul. Ta xa xicham chca'i ―xchi―. Comanic li'to. Viq'uiluc me asatic, mu me xavayic ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ja' ijelav batel jutuc stuc ti Jesuse. Laj spatan sba ti lum, laj sc'opon Dios ti taca stac'uque, ac'o q'uejbatuc batel ti vocol ti chich'e. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hech laj yalbe ti Diose: ―Tote, scotol xu' avu'un chapas. Q'uejbun batel avi vocol li'to. Mu me jpas c'usi sc'an co'nton. Ja' ac'o jpas ti c'usi sc'an ti avo'nton atuque ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Isut talel yo' bu oyic ti oxvo'ique. Vayajtic c'o staic. Ti Jesuse hech laj yalbe ti Pedroe: ―¿Mi vayalot? Simón. ¿Mi mu xu' chavic' asat junuc ora? ");
INSERT INTO tzoNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mu me xavayic, c'oponic Dios, hech mu xasujat ti mulil. Ti avo'ntone oy yip. Ti abec'tale mu'yuc yip ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Icha'bat nixtoc ti Jesuse. Ba sc'opon Dios nixtoc. Co'ol laj sc'opon ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Icha'sut talel ti Jesuse. Vayajtic c'o sta ti oxvo'ique yu'un chchamic ti vayel. Muc sna'ic c'usi chtac'avic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ba xcha'c'opon Dios ti Jesuse. Icha'tal nixtoc yo' bu oyic ti oxvo'ique. Ja' yoxibal xa vuelta. Hech laj yalbe: ―¿Mi ta to xavayic? ¿Mi ta to xacux avo'ntonic? Laj xa sta yorail ti chi'ac'at entrecal ti sc'ob jmulaviletic ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Licanic, batic. Q'uelo avil, chtal xa ti much'u chiyac'un entrecale ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ti ora c'alal yac'oj sba chc'opoj ti Jesuse, ital ti Judase. Ti Judase ja' lajchavo'ic xchi'uc ti yajchanc'opetic ti Jesuse. Xchi'inoj talel ep crixchanoetic yich'ojic talel yespadaic xchi'uc ste'ic. Ja' tacbil talel yu'un ti totil paleetique xchi'uc ti jchi'iltac ti ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti moletic cu'untutique. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ti Judase, ja' ti chac' entrecal ti Jesuse, yalojbe xa ti xchi'iltaque: ―Ja' ti much'u ti jbuts'e, ja' me obi. La' tsaquic me ti ora ju'un. Mu me xcol batel avu'un ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ti ora ital ti Judase, ihul ti stojol ti Jesuse. Hech laj yalbe ti Jesuse: ―Nital xa, Maestro ―xchi hulel. Laj sbuts' ju'un. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hech laj stsaquic ti Jesuse, laj yiq'uic batel. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Te xchi'inoj ti yajchanc'opetic ti Jesuse, oy jun laj sloq'ues yespada, laj syajesbe yabat ti totil palee. Laj sbojbe loq'uel jun xchiquin. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ti Jesuse hech laj sjac'be ti crixchanoetic ti italique: ―¿C'u yu'un hech tal atsacucun hech chaj c'u che'el j'elec'? Avich'ojic talel avespadaic, ate'ic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Scotol c'ac'al te oyun ti atojolic te ti yut templo. Te nichanubtasvan laj ava'yic. ¿C'u yu'un mu teuc laj atsacucun? Scotol hech chc'ot ti pasel yu'un tsts'aqui ti c'usi ts'ibabil ti sun ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hech yu'un scotol ti yajchanc'opetique laj scomesic ti Jesuse ijatavic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Te oy jun unen vinic, ja' sts'acts'un batel. Jlom no'ox poc' sc'u'unoj batel. Ja' itsacat uc yu'un ti viniquetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Hech yu'un ti unen vinique laj scomes ti poq'ue, t'anal ti c'alal ijatav batel. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Laj yiq'uic batel ti Jesuse, c'ot sva'anic ti stojol ti mero totil palee. Te stsoboj sbaic scotol ti totil paleetique xchi'uc ti moletique xchi'uc ti jchi'iltac ti ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ti Pedroe nomtic to chbat yu'un tsts'acli batel ti Jesuse, asta ic'ot ti Pedroe yo' bu yamaq'uil sna ti mero totil palee. Te i'och batel. C'ot xchi'in ti naclej ti abatetic yu'un ti totil palee. Te ic'atin xchi'uc. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ti totil paleetique xchi'uc scotol ti much'utic oy yabtelic cu'untutique yu'un tsc'an tsmilic ti Jesuse laj sa'ic cha'vo' ti jun no'ox ti c'usi chalique yu'un tsnopbeic smul ti Jesuse. Muc staic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hovil ti tal sva'an sbaic ti jnopc'opetique, mu co'oluc ti c'usi laj yalique. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Patil ital yan jnopc'opetic. Laj snopbeic smul ti Jesuse. Hech laj yalic: ");
INSERT INTO tzoNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Hech laj yal avi vinic li'to laj ca'itutic: “Ho'on ti jin avi templo li'to ti pasbil ti sc'ob crixchanoetique. Ti oxib no'ox c'ac'al ti jcha'pas nixtoc, ja' ti mu pasbiluc ti c'obale”, xchi ti vinic li'to ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yan vuelta mu co'oluc ti c'usi laj yalic nixtoc. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hech yu'un laj sva'an sba ti o'lol ti mero totil palee. Hech laj sjac'be ti Jesuse: ―¿C'u yu'un mu xatac'av? ¿Mi melel ti c'usi chal ti viniquetique? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mi jp'eluc muc xtac'av ti Jesuse. Ti mero totil palee laj xcha'jac'be nixtoc ti Jesuse: ―¿Mi melel ti ho'ot ti Cristoote ti t'ujbilot yu'un ti Diose? ¿Mi ho'ot snich'onot ti Diose ti ja' pasbil ti muc' cu'untique? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Itac'av ti Jesuse, hech laj yalbe: ―Ho'on ―xchi―. Ti yan c'ac'al chaq'uelucun, ho'on ti co'ol crixchanoucutique, ti te nacalun ti sbats'ic'ob ti Diose, ja' ti jelaven sp'ijile. Chaq'uelic ti chiyal tal ti vinajel xchi'uc toc ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ti mero totil palee laj sjat sc'u'. Yu'un ti laj sjat sc'u'e, yu'un tsots smul laj sta ti Jesuse tscuy. Hech laj yalbe ti crixchanoetique: ―Va'i, Dios tscuy sba. ¿C'u yu'un ti jc'antic yan rextico? ");
INSERT INTO tzoNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Laj xa ava'yic ti tstoy sba ti stojol ti Diose. ¿C'usi chanopic? ―xut. Scotolic laj yalbeic smilel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Oy lic stubtabeic sat ti Jesuse. Oy laj smacbeic ti sate, hech lic smajic. Hech laj yalbeic: ―Alo ca'itutic much'u laj smajoti ―xchiic. Ti yabat ti totil palee tsots imajvanic uc. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ti Jesuse te ti xcha'cajal na oy. Ja'uc ti Pedroe te ti yalbal te ti yamaq'uil ti sna ti mero totil palee. Te ital jun squiara ti mero totil palee. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","C'alal laj yil ti te chc'atin ti Pedroe, laj sq'uelbe sat, hech laj yalbe: ―Ho'oti, laj achi'in uc ti vinic ti liquem tal ti Nazarete, ja' ti Jesus sbie ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ti Pedroe laj smuc ti yo'nton. Hech itac'av: ―Mu xcojtiquin. Mu jna' ti c'usi chavale ―xchi. Hech iloc' batel ti Pedroe, te ba va'luc ti bu muc'ta ti'na. Ja' hech yorail i'oc' quelem. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ti quiarae yan vuelta laj sq'uel ti Pedroe, hech lic yalbe ti much'utic te oyique: ―Ja' xchi'il avi to ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ti Pedroe laj xcha'muc yan vuelta ti yo'nton. Li' ti j'oq'ui i'albat yan vuelta ti Pedroe yu'un ti much'utic te oyique: ―Melel ti ho'ot achi'inoj abaic xchi'uc. Ho'ot liquemot tal ti Galilea uc yu'un co'ol chac'opojic ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hech yu'un ti Pedroe lic sva'an ti rextico ti Diose. Hech laj yal: ―Yiloj ti Diose mu xcojtiquin ti vinic ti chavale ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","I'oc' yan vuelta quelem. Ja' xchibal xa vuelta. Hech yu'un ti Pedroe it'ab ti yo'nton ti c'u che'el i'albat yu'un ti Jesuse: “C'alal sta yorail ch-oc' xchibal vuelta quelem, laj xa amucun ti avo'nton oxib vuelta”, ti x'utate. C'alal hech it'ab ti yo'nton ti Pedroe, lic yoc'ta sba. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ti yoc'omal c'alal isacub ti osile scotol ti totil paleetique xchi'uc scotol ti moletique xchi'uc ti jchi'iltac ti ichanubtasvan ti smantal ti Diose ti scuyoj sbaique xchi'uc scotol ti much'utic oy yabtelic cu'untutique laj xchapambeic sc'opilal ti Jesuse. Chucul laj yiq'uic batel. Ba yaq'uic entrecal ti stojol ti Pilatoe. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ti Pilatoe hech laj sjac'be ti Jesuse: ―¿Mi ho'ot ajvalilot yu'un ti achi'iltaque, ho'oxuc ti judiooxuque? ―x'utat. Itac'av ti Jesuse, hech laj yalbe: ―Ho'on ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ep isa'bat smul ti Jesuse yu'un ti totil paleetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yan vuelta hech ijac'bat yu'un ti Pilatoe: ―¿C'u yu'un mu xatac'av? ¿Mi mu xava'i ti yac'oj sba chasa'bot amule? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mi jutuc muc xtac'av ti Jesuse. Hech yu'un ich'ay yo'nton ti Pilatoe. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Hech stalel o ti yorail q'uin tscolta batel jchuquel ti jujun habil ti gobernadore, ja' ti Pilatoe. Ja' tscolta ti much'u tsc'an ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Oy to ono'ox jun jchuquel, Barrabás sbi. Te chucul xchi'uc xchi'iltac yu'un oy much'u laj smilic c'alal laj stsob svinictac laj scontrain ti gobiernoe. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","C'alal te stsoboj sbaic ti crixchanoetique, lic sc'ambeic ti Pilatoe ti ac'o scolta jun jchuquel hech chaj c'u che'el tspasilan ono'ox ti jujun habile ti yorail ti q'uine. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Itac'av ti Pilatoe, hech laj sjac'be: ―¿Mi ja' chac'anic ti jcolta batel ti ajvalil avu'unique, ho'oxuc ti judiooxuque? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yu'un ti hech laj yal ti Pilatoe yu'un laj sna' ti scoj sbic'tal yo'ntonic ti laj yaq'uic entrecal ti totil paleetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ti totil paleetique laj stsob sc'opic xchi'uc ti crixchanoetique ti ja' ac'o sc'ambeic ti Pilatoe ti chcol ti Barrabase. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Itac'av ti Pilatoe hech laj xcha'jac'be yan vuelta: ―¿C'usi chcutic ti Jesuse, ja' ti ho'oxuc laj avalic ti ja' ajvalil scuyoj sba cu'untutic, ti xachiique? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tsots ic'opojic scotolic. Hech laj yalic: ―¡Milo ti cruz! ―xchiic scotolic. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ti Pilatoe hech laj sjac'be: ―¿C'usi smul avu'unic? ―xchi. Más tsots ic'opojic scotolic: ―¡Milo ti cruz! ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ti Pilatoe yu'un laj sc'an ti lec ch-ilat yu'un ti crixchanoetique, hech yu'un laj scolta batel ti Barrabase. Ti Jesuse i'ac'at entrecal yu'un chich' acial, yu'un chba milatuc ti cruz. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hech yu'un ti yajsoldado ti gobernadore laj yiq'uic ochel ti yut cabildo, ja' ti Pretorio sbie. Te laj stsob sbaic tal scotol ti xchi'il ti soldadoile. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Laj slapbeic poco yaxal c'u'il ti Jesuse. Laj spech'ic ch'ix, laj yac'beic ti sjol. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Hech lic slabanic: ―Ho'ot ajvalilot mati yu'un ti achi'iltaque ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Laj smajbeic ti sjol aj. Laj stubtaic. Laj squejan sbaic ti stojol yu'un tslabanic. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","C'alal laj yo'ntonic laj slabanique, laj sloq'uesbeic ti yaxal c'u'ile. Laj xcha'lapbeic sc'u' nixtoc. Laj yiq'uic batel, ba smilic ti cruz. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","C'ot snup ti be jun jchi'il liquem tal ti balumil Cirene sbi. Simón sbi ti vinique. Ti Alejandro xchi'uc ti Rufoe, ja' stot ti Simone. Ja' chmu tal ti Jerusalén. Ti soldadoetique laj yac'beic sq'uechbe batel scruz ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ic'otic ti bu balumil Gólgota sbi. Gólgota, ti xchie, ja' Baquel Jolal, xchi c'alal jelavesbil. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Laj yac'beic yuch' vino capbil xchi'uc mirra. Ja' smacobil sc'uxul ti mirrae. Mu sc'an xuch' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","C'alal laj xa sjipanic ti cruz ti Jesuse, laj spasic al chil ti much'u chc'ot ti sventa ti sc'u' spoc' ti Jesuse. Hech laj xch'acbe sbaic ti sc'u' spoq'ue. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ja' baluneb ora sob ic'luman ti c'alal laj sjipanic ti cruz ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Te pac'al ti sjol scruz yo' bu ts'ibabil c'usi smul ti Jesuse. JA' TI TOTIL AJVALIL YU'UN TI JUDIOETIQUE, xchi ts'ibabil ti sjol scruz. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Te laj sjoc'anic uc cha'vo' j'eleq'uetic. Ja' laj xchi'in ti Jesuse, jun ti sbats'ic'ob, jun ti sts'et ti scruz ti Jesuse. Cacal ti o'lol ti scruz ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hech its'aqui ti hech ts'ibabil comel ti sc'op Diose: “Co'ol ch-ac'bat castigo xchi'uc ti jmulaviletique”, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Scotol ti much'u i'ech' ti be laj slabanic. Laj sjim sjolic. Hech laj yalic: ―Q'uelo avil, ho'ot ti chajin ti templo yu'un ti Diose, ti chacha'pas ti oxib no'ox c'ac'al chavale, coltao aba quiltic. Yalan tal ti cruz ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Co'ol ilabanvanic ti totil paleetique xchi'uc ti jchi'iltac ti ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Hech laj yalbe sbaic: ―Ep ti much'u laj scoltae. Tana mu xa xu' scolta sba. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cristo tscuy sba, ajvalil cu'untic tscuy sba. Ac'o yaluc tal ti cruz ti ora yu'un hech ti jq'ueltic, hech ti jch'untic ―xut sbaic. Co'ol laj spasic uc ti j'eleq'uetique, ja' ti much'u co'ol ijoc'anatic ti cruz xchi'uc ti Jesuse. Laj slabanic uc. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ti o'lol c'ac'al i'ic'ub ti osile. Ic'uben icom oxib ora. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ti oxib ora mal c'ac'al tsots ic'opoj ti Jesuse: ―Eloi, Eloi, lama sabactani ―xchi. Dios cu'un, Dios cu'un, laj xa acomesun, xchi c'alal jelavesbil. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Laj ya'yic cha'vo' oxvo' ti much'utic te va'ajtique. ―A'yo me ava'i, ja' chic' tal ti Elíase ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jun ibat ti anil, ba stam talel esponja. Laj sts'aj ti vinagre ti esponjae, laj slic muel ti te', laj yac'be sts'uts'un ti vinagree ti Jesuse. Hech laj yal: ―Malaic to, jq'ueltic mi chtal coltaatuc yu'un ti Elíase ―xut ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ti Jesuse tsots ic'opoj yan vuelta, hech icham. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hech yu'un ti muc'ta poc' te joc'ambil ti yut ti templo te ti Jerusalén, ja' ti velo sbie, ijat ti o'lol. Ja' ijat yal tal ti cajale. Cha'lic ic'ot. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ti capitan soldadoe te va'al ti stojol ti Jesuse. C'alal laj yil ti tsots ic'opoj ti Jesuse c'alal icham, hech laj yal: ―Melel ti ja' Snich'on Dios ti vinic li'to ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Te oy uc cha'vo' oxvo' antsetic. Nom va'ajtic. Ja' ti Maríae ti liquem tal ti Magdalae, xchi'uc ti Salomee, xchi'uc ti yan Maríae, ja' ti sme' ti Josee xchi'uc ti Jacoboe, ja' ti biq'uit Jacobo ch-albat sbie. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Avi antsetic li'to laj xchi'inic batel ti Jesuse c'alal chanav te ti Galilea. Ja' laj smac'linic ti Jesuse. Te va'ajtic uc ep yan antsetic ti laj xchi'in talel ti Jerusalén ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","C'alal icham ti Jesuse, ja' yorail ti jchapan jbatutic yu'un ti jcux co'ntontutic ti oc'ome. Hech yu'un mal xa c'ac'al ital jun jchi'il, José sbi. Ja' liquem tal ti jteclum Arimatea sbi. Ja' yich'oj yabtel te ti templo ti Josee. Pasbil ti muc'. Ja' yac'oj sba tsmala ti chtal spasucutic ti mantal ti Diose. Muc xi', ba sc'opon ti Pilatoe. Ba sc'ambe stacopal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","C'alal laj ya'i ti Pilatoe ti icham xa ti Jesuse, ich'ay yo'nton yu'un mu'yuc bu yiloj ti chcham ti ora ti much'u chjipanat ti cruz. Hech lic stac ti iq'uel ti capitan soldadoe. Laj sjac'be mi melel ti icham xae. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","I'albat ya'i yu'un ti capitan soldadoe ti chamen xa ti Jesuse. Hech yu'un ti Pilatoe laj yalbe ti Josee: ―Xu' chaloq'uesbe ti stacopale ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ti Josee laj sman poc', laj syales ti cruz ti stacopal ti Jesuse, laj xpix ti poc', laj yac' ti yut ch'en. Jombil ti ton ti ch'ene. Laj sbalch'un talel muc'ta ton, hech laj smac ti ti'ch'ene. ");
INSERT INTO tzoNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ti Maríae ti liquem tal ti Magdalae xchi'uc ti yan Maríae ja' ti sme' ti Josee, ja' laj yilic ti bu laj yaq'uique. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","C'alal i'ech' xa ti sabadoe ja' ti yorail ti jcux co'ntontutique, ti Maríae ti liquem tal ti Magdalae, xchi'uc ti yan Maríae ja' ti sme' ti Jacoboe, xchi'uc ti Salomee laj smanic poxil ti jun smuil yiq'ue, yu'un sc'an chba spoxtabeic sbec'tal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","C'alal isacub ti osile ti domingoe, ja' ti sba c'ac'alil ti semanae, ic'otic ti ch'en. Iloc' xa ti c'ac'ale ti c'alal ic'otique. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hech laj yalbe sbaic: ―¿Much'u chisbalch'umbucutic loq'uel ti tone ti macbil ti ti'ch'ene? ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yu'un muc' ti tone smacoj ti ti'ch'ene. C'alal hech yac'oj sba chlo'lajic, ic'otic ti bu ti ch'ene, laj yilic ti balch'umbil xa loq'uel ti muc'ta tone. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","C'alal i'ochic ti yut ch'ene, laj yilic jun unen vinic x'elan te nacal ti stojol sbats'ic'ob ti antsetique. Nat ti sc'u' slapoje. Sac ti sc'u'e. Hech ixi'ic ti antsetique. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ti unen vinique hech laj yalbe: ―Mu me xaxi'ic. Jna'oj ti ja' chasa'ic ti Jesuse, ja' ti liquem tal ti Nazarete, ja' ti icham ti cruze. Icha'cuxi xa, mu xa li'uqui. La' q'uelo avil ti yav bu laj yaq'uique. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Batanic, ba albeic ti Pedroe xchi'uc ti yan yajchanc'opetique ti ja' chbaej la batel avu'unic ti Galilea ti Jesuse. Te chc'o aq'uelic hech chaj c'u che'el laj yalboxuc ono'oxe, xavutic me ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Toj xi'el ic'otic ti antsetique. Iloq'uic ti ora ti ch'en, ibatic ti anil. Mu'yuc much'u laj yalbeic ti hech laj sq'uelique yu'un ixi'ic. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ti sob domingo icha'cuxi ti Jesuse, ja' ti sba c'ac'alil ti semanae. Primero laj yac' sba ti q'uelel ti stojol ti Maríae, ja' ti liquem tal ti Magdalae, ja' ti iloq'uesbat hucvo' pucuj ti yo'nton yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ibat ti Maríae, ba yalbe ya'yic ti yajchanc'opetique ti ja' ono'ox xchi'inojic ti Jesuse. Chich'ic mul, ch-oq'uic ti yajchanc'opetique ti c'alal c'ot taatuc yu'un ti Maríae. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","C'alal laj ya'yic ti laj yil ti Maríae ti cha'cuxem xa ti Jesuse, muc xch'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Patil ti Jesuse laj yac' sba ti q'uelel ti stojol cha'vo' ti much'u ch'umbil sc'ope ti c'alal yac'oj sba chanavic batel ti be yo' bu chobtic. Yu'un laj sjel ti sat ti Jesuse hech yu'un muc xojtiquinic ti ora ti ja' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hech yu'un patil ti cha'vo'ique isutic batel ti Jerusalén, ba yalbe ya'yic ti yantique. Muc xch'umbat sc'opic yu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ti patil laj yac' sba ti q'uelel ti stojol ti buluchvo' yajchanc'opetique c'alal chve'ique. Laj stabe ti alel ti muc sc'an xch'unique yu'un tsots ti yo'ntonique. Yu'un muc spasbeic ti muc' ti sc'ope ti much'utic i'albat yu'unique ti icha'cuxi xa ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hech lic yalbe: ―Batanic, xanavanic ti scotol balumil. Cholbo ya'yic ti lequil ach' c'ope scotol crixchanoetic. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Scotol ti much'utic chch'unique, ti chich'ic ho'e, ja' chcol. Scotol ti much'utic mu xch'unique, ja' chba ac'batuc castigo. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Oy señailetic chc'ot ti pasel ti sventaic ti much'utic chch'unique. Ti jventa tsloq'uesic pucujetic ti yo'ntonic crixchanoetic, chc'opojic ti ora no'ox ti yantic c'opetic. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Repenta mi tsta orachon, mu xti'atic yu'un. Repenta mi chuch' ti c'usi chmilvane, mu xchamic yu'un. Mi chac'beic sc'obic ti sjol jchameletic, hech chcolic ti jchameletique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","C'alal laj yo'nton laj sc'opon comel ti yajchanc'opetique ti Jesuse, i'ic'at muel ti vinajel. Te c'ot nacluc ti sbats'ic'ob ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ti yajchanc'opetique ba xcholic ti sc'op Diose ti sjoylejal balumil. Ja' xchi'inojic ti abtel ti Cajvaltique. Laj yac' ti q'uelel ti Cajvaltique ti ja' sc'op ti chcholbate yu'un laj yac'be spasic ep jchop o abteletic.");
INSERT INTO tzoNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Totil ajvalil Teófilo, ep ti much'utic laj xa sp'ejanic ti hun ti c'utic ic'ot xa ti pasel ti jventatutic. Hech chaj c'u che'el laj yalbucun ca'itutic ti much'utic laj sq'uelic c'alal lic abtejuc ti Jesuse, ja' ti much'utic sventainojic xcholel ti sc'op ti Diose, hech laj sp'ejanic ti hun. Hech yu'un ho'on ti Lucasune, laj xa jnop ti ja' lec chajcholbot scotol ti c'usi laj xa ca'i ti sliqueb asta ti ora to yu'un laj xa ca'i scotol ti c'utic x'elan ic'ot ti pasel. Hech yu'un xmelmun chajts'ibabot scotol yu'un hech chana' ti melel ti c'u che'el nachanubtasate. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","C'alal ochem ti rey te ti estado Judea ti Herodese, te oy jun pale yu'un ti judioetique, Zacarías sbi. Ep ti tos ti sbiic ti paleetique. Ja' ochem yu'un ti jtos Abías ti Zacaríase. Ti yajnil ti Zacaríase, Elisabet sbi. Ti Elisabete ja' antiguo statamol ti Aarone, ja' primero ti hech itic'at ti pale yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Toj yo'ntonic ti xcha'va'alique laj yil ti Diose. Xch'unojbeic scotol smantal, scotol sc'op ti Cajvaltic Diose. Mu'yuc smulic laj yil ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mu'yuc yol snich'on yu'un mi junuc vuelta mu yilojuc yol ti Elisabete. Molme'elic xa ti xcha'va'alique. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yu'un ochem ti pale ti Zacaríase, hech yu'un laj sta sc'ac'alil ti ja' yorail ch-abtej te ti stojol ti Diose xchi'uc ti xchi'iltac ti abtel. Yu'un ti paleetique tsjelilan sbaic ti jaytosique. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ti jayvo'ic ti ja' c'ac'al ch-abtejique ja' stalel tspasic al yu'un tsq'uelic ti much'u chc'ot ti sventa yu'un chba xchic' pom te ti yut templo yu'un ti Cajvaltic Diose. Ja' ic'ot ti sventa ti Zacaríase. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Scotol ti crixchanoetique te va'ajtic ti amac' yac'oj sba tsc'oponic Dios. Hech ono'ox tspasilanic scotol c'ac'al c'alal chchic' pom ti yut templo ti paleetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","C'alal te chchic' pom ti Zacaríase, ital xch'ul abat ti Cajvaltic Diose. Va'al ihul ti sts'el ti xchic'bil pome, te ti sbats'ic'ob ti Zacaríase. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","C'alal laj sq'uel ti ch'ul abate ti Zacaríase, toj xi'el ic'ot. Ep ilo'laj yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Hech i'albat yu'un ti ch'ul abate: ―Mu me xaxi', Zacarías. Laj xa stsacbot ac'op ti Diose. Ch-alaj ti Elisabete, ja' ti avajnile. Querem chac'. Juan chavac'be sbi. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Lec nichim no'ox avo'nton yu'un. Ep ti much'utic yan nichim no'ox yo'ntonic uc ti c'alal mi i'an xae. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yu'un tsots yabtel chich' ti stojol ti Diose. Mu xuch' ya'lel sat uvate' ti yijubene, mu xuch' pox. Nojem ti yo'nton ti Ch'ul Espíritue c'alal ch-an. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ep tsutesbat yo'ntonic yu'un ti Juane ti achi'iltaque, ho'oxuc ti yelnich'onoxuc ti Israele. Tsutesbat yo'ntonic ti stojol ti Cajvaltic Diose, ja' ti Dios cu'untique. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ti Juane ja' chbaej yu'un ti Cajvaltique yu'un hech chchapambe yo'ntonic ti achi'iltaque. Co'ol yo'nton, co'ol sp'ijil ti Juane xchi'uc ti Elíase. Tsutesbe yo'ntonic yu'un hech co'ol chch'unic hech chaj c'u che'el laj xch'unic ti atatamolique. Tsutesbe yo'ntonic ti much'utic jp'ajmantaletic yu'un hech toj yo'ntonic chc'otic ―xchi ti ch'ul abate. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ti Zacaríase hech laj sjac'be ti ch'ul abate: ―¿C'u che'el ti jna' mi melel ti c'u che'el laj avalbune? Yu'un molun xa. Me'el xa ti cajnile ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Itac'av ti ch'ul abate, hech laj yalbe: ―Ho'on Gabrielun, ho'on chi'abtej te ti mero stojol ti Diose. Ti Diose laj stacun tal yu'un tal jc'oponot yu'un chacalbot ava'i avi lequil c'op to. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A'yo me ava'i, yu'un mu xach'umbun ti jc'ope, hech yu'un chmac ave mu xloc' xac'opoj. Ja'to mi laj sta yorail chc'ot ti pasel hech chaj c'u che'el laj calbote, ja'to chjam ave. Yu'un ta me xc'ot ti pasel mi laj sta yoraile ―x'utat ti Zacaríase. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ti crixchanoetique te oyic ti fuera. Tsmalaic chloc' tal ti Zacaríase. Chlo'laj yo'ntonic yu'un te ihalej ti yut templo. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","C'alal iloc' tal ti Zacaríase, mu xu' tsc'opon ti crixchanoetique. Hech laj sna'ic ti oy c'usi jchop o laj sq'uel te ti yut templo. Ja' no'ox laj yac' señail ti sc'ob ti c'usi ic'ot ti pasel, yu'un uma' ic'ot ti mero melel. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","C'alal its'aqui ti jayib c'ac'al ti te ch-abtej ti templo ti Zacaríase, hech isut batel ti sna. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Patil lic slic yol ti yajnile, ja' ti Elisabete. Ho'ob xa u sc'an mu x'an ti yole ti muc xloc' ti sna mi jutuc. Hech laj yal: ");
INSERT INTO tzoNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Yu'un laj yil ti Cajvaltic Diose ti mu'yuc jtu ti stojol crixchanoetic, hech yu'un laj xa scoltaun, laj xa yac'bun ti cole”, xchi ti Elisabete. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","C'alal slicoj xa yol vaquib u ti Elisabete, ti Diose laj stac talel ti mantal ti jteclum te ti estado Galilea ti xch'ul abate, ja' ti Gabriele. Nazaret sbi ti jteclume. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ti Gabriele tacbil talel ti yo' bu jun soltera tseb. Mu to bu yiloj smalal ti tsebe. Jac'bil xa yu'un jun vinic, José sbi ti vinique. Ti Josee ja' antiguo statamol ti Davide. María sbi ti tsebe. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ti ch'ul abate hech c'ot yalbe ti Maríae: ―Ho'ot t'ujbilot yu'un ti Diose. Li' achi'uc ti Cajvaltic Diose. Mu'yuc bu hech yan ants ch-ac'bat bendición hech chaj c'u che'el ho'ot ―x'utat ti Maríae yu'un ti Gabriele. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ti Maríae c'alal laj ya'ibe sc'op ti ch'ul abate, toj xi'el ic'ot. Lic snop ti yo'nton ti c'u che'el i'albate. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","I'albat nixtoc yu'un ti Gabriele: ―Mu me xaxi', María, yu'un lec chayil ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","A'yo ti c'usi chacalbee. Chlic ata avol. Querem chavac'. Jesús chavac'be sbi. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tspasat ti muc' ti avole. Snich'on Dios ti cajal, xchiic ti crixchanoetique. Ti Cajvaltic Diose ja' chac' ochuc ti ajvalil. Ja' tstsacbe comel yabtel ti antiguo statamole, ja' ti Davide. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Sbatel osil chaspasoxuc ti mantal ho'oxuc ti yelnich'onoxuc ti Israele. Sbatel osil mu xlaj ti smantale ―xchi ti xch'ul abat ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Itac'av ti Maríae: ―Mu jna' c'usi chcut jba. Mu'yuc bu quiloj jmalal ―xchi ti Maríae. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Hech i'albat yu'un ti ch'ul abate: ―Chtal ti atojol ti Ch'ul Espíritu yu'un ti Diose. Ho'ot chasmacot ti Diose ti ja' jelaven sp'ijile. Hech yu'un ti olole ti ch-an avu'une, mu'yuc smul. Ja' Snich'on Dios. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ava'i, te xa slicoj yol avuts avalal, ja' ti Elisabete. Manchuc mi yij xa, svaquibal xa u slicoj yol ti avuts avalale ti mu sta yol chalique. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ti Diose ja' xu' yu'un tspas scotol ―xchi ti xch'ul abat ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","―Lec oy ―xchi xtac'av ti Maríae―. Yabatun ti Cajvaltique. Ac'o spasbun ti c'u che'el laj avalbune ―xchi xtac'av ti Maríae. Hech isut batel ti xch'ul abat ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Patil iloc' batel ti Maríae. Anil ibat ti jun jteclum te ti estado Judea. Te oy ti vits ti jteclume. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ja' te oy ti sna ti Zacaríase. Te ic'ot ti Maríae. I'och ti sna, laj sc'opon ti Elisabete, ja' ti yuts yalale. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ti Elisabete c'alal laj ya'ibe sc'op ti Maríae, tsots laj snic sba ti olole ti slicoje. Ti Elisabete iventaimbat yo'nton yu'un ti Ch'ul Espíritue. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Hech tsots lic c'opojuc, hech laj yalbe ti Maríae: ―Mu'yuc bu hech yan ants ch-ac'bat bendición hech chaj c'u che'el ho'ot. Jun no'ox yutsil ti olole ti ch-an avu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mu'yuc cabtel ho'oni yu'un chtal aq'uelun, ho'ot ti sme'ot ti Cajvale. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yu'un c'alal laj ac'oponun, nichim no'ox yo'nton laj snic sba ti cole ti jlicoje. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jun no'ox yutsil ti laj ach'une yu'un melel chc'ot ti pasel ti c'usi na'albat yu'un ti Cajvaltic Diose ―xchi ti Elisabete. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ti Maríae hech laj yal: Jelaven sp'ijil ti Cajvaltic Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nichim no'ox co'nton ti stojol ti Diose, ja' ti Jcoltavanej cu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Manchuc mi biq'uitun ti stojol, laj yilun, ho'on ti yabatune. “Ep i'ac'bat bendición”, xchi jc'opilal yu'un scotol crixchanoetic ti ch-ech'ic li' ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Jelaven yutsil ti hech laj xa spasbun ti Diose, ja' ti jelaven sp'ijile, ja' ti toj yo'ntone. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ti jujumaquel ti ch-ech'ic li' ti balumile chc'uxubin ti much'utic tspasat ti muc' yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Laj yac' ti q'uelel ti jelaven sp'ijile. Xu' yu'un tsjimbe yabtel ti much'utic tstoy sbaique, ja' ti much'utic p'ij scuyoj sbaique, hech mu xa xu' yu'unic ti c'utic snopojique. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Xu' yu'un tsten loq'uel ti totile ti tsots tspas mantale. Xu' yu'un chac'be tsots yabtel ti much'utic biq'uit ch-ilatique. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tsnojesbe yo'ntonic ti c'usi leque ti much'utic tsna'ic ti mu'yuc yutsil yo'ntonique. Ja'uc ti much'utic lec yo'ntonic scuyoj sbaique mu'yuc c'usi ch-ac'batic. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ta xa scoltaucutic, ho'ucutic ti yelnich'onucutic ti Israele ti jayvo'ucutic ti cajvalinojtic ti Diose. Yu'un mu xch'ay ti yo'nton ti Diose ti hech laj yalbe ti jtatamoltique, ja' ti Abrahame. Laj yalbe ti chc'uxubinatic xchi'uc yelnich'nabtac sbatel osil, xchi ti Maríae. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ti Maríae te laj xchi'in sbaic oxib u xchi'uc ti Elisabete. Patil isut batel ti sna. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Laj sta yorail chcol ti alajel ti Elisabete, hech i'an ti snene quereme. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ti svecinotaque xchi'uc ti yuts yalaltac ti Elisabete laj ya'ibeic sc'opilal ti ep ic'uxubinat yu'un ti Diose. Hech co'ol nichim no'ox yo'ntonic xchi'uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","C'alal laj sta vaxaquib c'ac'al yanel ti snene quereme, tal yac'be yich' circuncisión ti snene quereme. Ja' ituch'bat snuculel ti sc'unil ti nene quereme. Ja' señail ti ja' yu'un Dios ic'ot o ti hech ituch'bat ti snuculele. Ti yuts yalaltaque laj scuyic ti ja' Zacarías chc'ot sbi ti snene quereme. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ti sme'e hech laj yalbe: ―Mu hechuc chcac'be. Ja' Juan sbi chcac'be ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hech i'albat: ―¿C'u yu'un hech chavac'be sbi? Mu'yuc bu hech jbitic ti ho'ucutique ―x'utat ti Elisabete yu'un ti yuts yalaltaque. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Hech yu'un lic sc'oponic ti stot ti quereme. Hech lic spasbeic yil ti sc'obic yu'un hech ac'o yal c'usi sbi tsc'an chac'be. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ti Zacaríase hech lic sc'an te' yu'un tsts'ibaj ti te'. Hech laj sts'iba: “Juan sbi”, xchi laj sts'iba. Scotolic ich'ay yo'ntonic yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ti ora ijambat ye ti Zacaríase, hech ic'opoj. Ep laj yalbe vocol ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Toj xi'el ic'otic scotol ti svecinotaque. Ipuc batel sc'opilal scotol ti bu nacale te ti siquil balumil te ti Judea. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Scotol ti much'utic laj ya'ibeic sc'opilale, hech lic snopilanic ti yo'ntonic: ―¿C'u x'elan chbat avi olol lume? ―xchiic. Yu'un ti quereme xchi'inoj ti Cajvaltic Diose laj yilic. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ti Zacaríase, ja' ti stot ti quereme, inoj ti yo'nton ti Ch'ul Espíritue. Hech laj yal ti hech chc'ot ti pasele: ");
INSERT INTO tzoNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Hocol yal ti Cajvaltic Diose, ja' ti Dios cu'untique, ho'ucutic ti yelnich'onucutic ti Israele, ti chtal sq'uelucutic ho'ucutic ti t'ujbilucutic yu'une. Chtal scoltaucutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Chtal xa ti Jcoltavanej cu'untique, ja' ti scotol xu' yu'une. Ja' ti jun yelnich'on ti Davide. Ja' yabat ti Diose ti Davide. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ti vo'one laj xch'amumbe ye ti j'alc'opetic yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Hech laj yal ti chijcolucutic loq'uel ti sc'ob ti cajcontratique. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Hech chixc'uxubinucutic hech chaj c'u che'el laj yalbe ti antiguo jtotique. Hech chvinaj ti mu xch'ay ti yo'nton ti trato ti laj spasic xchi'uc ti antiguo jtotique. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ja' ti j'ech'el hech laj yalbe jc'opilaltic ti jtatamoltic Abrahame ti chiscoltaucutic loq'uel ti sc'ob ti cajcontratique hech mu'yuc xi'el ti co'ntontic chcac' jbatic ti abatinel ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Hech lecubtasbil co'ntontic, toj co'ntontic ti stojol ti jayib c'ac'al li' cuxulucutique. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ti ho'ote, nich'on, j'alc'opot yu'un Dios ti te oy ti vinajele chac'ot yu'un ho'ot chabaej yu'un ti Cajvaltique yu'un chachapambuntutic co'ntontutic yu'un hech ti jpastutic ti muc' ti sc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ho'ucutic t'ujbilucutic yu'un ti Diose, ho'ot chavac'bun jna'tutic ti chixch'aybucutic jmultic hech chijcolucutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yu'un yutsil yo'nton chixc'uxubinucutic ti Dios cu'untique, hech yu'un ta xa xistacbucutic tal ti Jcoltavanej cu'untique. Jun no'ox yutsil ti li' chul xa ti jtojoltique. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mi ihul xae, ja' chjelbat yo'ntonic ti much'utic chopol yo'ntonique. Ja' tsjin ti ch'ayel chijbatucutique. Ja' chiscoltaucutic yu'un hech ti jtatic jun co'ntontic yu'un, xchi ti Zacaríase. ");
INSERT INTO tzoNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","C'alal ich'i ti quereme, i'an yo'nton. Hech ba nacluc ti xocol balumil stuc ja'to c'alal laj sta yorail ti laj yac' sba ti q'uelel ti stojol ti xchi'iltaque, ja' ti co'ol yelnich'on ti Israel xchi'uque. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Oy to ono'ox totil ajvalil, César Augusto sbi. Ista yorail laj yal mantal ac'o yac' ti jun sbiic scotolic. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sba vuelta hech laj spasic c'alal tiq'uil ti gobernador ti Cirenioe te ti slumal Siria. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Hech mantal laj yich'ic scotolic ti ac'o ba yac' sbiic ti jteclum ti bu slumal ti antiguo statamolique. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Hech yu'un ti Josee iloc' batel ti jteclum Nazaret sbi, te ti estado Galilea. Imu batel ti estado Judea. Te ic'ot ti jteclum yo' bu i'an ti antiguo statamole. Ja' David sbi ti antiguo statamole ti Josee. Belén sbi ti jteclume. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Te ba yac' sbi ti Belén ti Josee xchi'uc ti Maríae, ja' ti yajnile. Mu to chcol ti alajel ti Maríae. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","C'alal te oyic ti Belén, te laj sta yorail icol ti alajel ti Maríae. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","I'an ti sba yole. Querem laj yac'. Laj xpix ti saquil poc'. Laj smetsan ti sve'ob vacax yu'un muc sta ti loq'uel ti nae. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nopol no'ox ti Belene te oy jpaxtoletic. Tsq'uel scarneroic ti ac'ubaltic. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Te laj yac' sba ti q'uelel ti xch'ul abat ti Diose. Laj yac' talel squeval Dios yo' bu oyique. C'alal laj yilic, toj xi'el ic'otic ti jpaxtoletique. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","I'albatic yu'un ti ch'ul abate: ―Mu me xaxi'ic. Oy c'usi lec chacalbe hech nichim no'ox avo'ntonic acotolic. Ac'o ya'yic scotol achi'iltac. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nax i'an ti Belén Jcoltavanej avu'unic, ja' ti Cristoe. Ja' Cajvaltic. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ja' señail chacalbeic. Te chataic ti olole, pixbil ti saquil poc', metsel ti sve'ob vacax ―x'utatic yu'un ti xch'ul abat ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ti ora ivinaj ep xchi'iltac ti xch'ul abat ti Diose. Ilequilc'opojic yu'un ti Diose. Hech laj yalic: ");
INSERT INTO tzoNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Jelaven yutsil ti Diose, ja' ti te oy ti vinajele. Ac'o tojobuc ti balumile yu'un yutsil yo'nton ti Diose xchi'uc scotol crixchanoetic, xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","C'alal isut xa batel ti vinajel ti ch'ul abatetique, hech laj sc'opon sbaic ti jpaxtoletique: ―Batic ti Belén, ba jq'ueltic ti c'usi ic'ot ti pasel, ja' ti c'usi laj yalbucutic ti Cajvaltique ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hech ibatic ti anil. Te laj staic ti Maríae xchi'uc ti Josee xchi'uc ti olole. Te metsel ti sve'ob vacax ti olole. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","C'alal laj yo'ntonic laj sq'uelic ti olole, ba spuquic ja' ti sc'opilal ti Jesuse ti i'albatic ti jbaele yu'un ti xch'ul abat ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ti much'utic laj ya'ibeic sc'op ti jpaxtoletique ich'ay yo'ntonic yu'un ti hech i'albatic yu'un ti jpaxtoletique. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ti Maríae muc xch'ay ti yo'nton ti c'usi i'albate. Laj snopilan ti yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hech isutic batel ti jpaxtoletique. Ilequilc'opojic batel yu'un ti Diose. Laj yalbeic vocol ti Diose yu'un scotol ya'yojic xa xchi'uc scotol sq'uelojic xa hech chaj c'u che'el i'albatic yu'un ti xch'ul abat ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","C'alal laj sta vaxaquib c'ac'al yanel ti unen quereme, laj yich' circuncisión. Jesús sbi laj yac'beic comel. Albil ono'ox comel ti sbie yu'un ti xch'ul abat ti Diose. Albil ono'ox sbi ti c'alal mu to tslic ti Maríae. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","C'alal i'ech' xa yorail hech chaj c'u che'el chal ti mantaletique ti ja'to mi its'aqui treinta y tres c'ac'al ja'to xu' chbat ti templo, hech yu'un its'aqui xa ti c'ac'ale hech yu'un ibat ti templo te ti Jerusalén ti Maríae xchi'uc ti Josee. Ba yac'beic ti stojol ti Cajvaltic Diose ti olole. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yu'un hech ts'ibabil ti sunal ti mantaletic yu'un ti Cajvaltic Diose: “Scotol ti sba yolique, mi querem, ja' cu'un”, ti xchi ono'ox ti Cajvaltic Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tal yac'beic smoton ti Diose yu'un hech tspas ti muc' hech chaj c'u che'el chal ti mantaletique yu'un ti Cajvaltic Diose: “Mi mu'yuc ti scarneroe, ac'o yich' tal cha'cot culajte, mi cha'cot tsumut yu'un jmoton”, ti xchi ono'ox ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Oy jun vinic te ti Jerusalén. Simeón sbi ti vinique. Toj yo'nton ti stojol ti Diose. Xch'unoj ti mero melel ti Diose. Smalaoj ti chtal ti Jcoltavaneje yu'un hech chmuc'ub yo'ntonic xchi'uc ti xchi'iltaque, ja' ti co'ol yelnich'nab Israel xchi'uque. Oy ti yo'nton ti Simeone ti Ch'ul Espíritue. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ti Simeone i'ac'bat xa sna' yu'un ti Ch'ul Espíritue ti ja'to mi laj sq'uelbe sat ti Jcoltavaneje ti chtacat tal yu'un ti Diose, ja'to chcham. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yu'un hech i'albat ti Simeone yu'un ti Ch'ul Espíritue, hech yu'un ital te ti templo te ti Jerusalén. Hech yu'un te oy ti templo ti Simeone ti c'alal italic ti templo xchi'uc ti nene olol Jesús ti Josee xchi'uc ti Maríae. Yu'un tal spasic hech chaj c'u che'el chal ti mantaletique. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ti Simeone laj spet ti olole, laj yalbe vocol ti stojol ti Diose. Hech laj yalbe ti Diose: ");
INSERT INTO tzoNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Cajval, jun co'nton ic'un me ti atojol hech chaj c'u che'el avalojbune, ho'on ti avabatune. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Yu'un laj xa jq'uel ti Jcoltavanej cu'untutique ti laj xa atac talel sventa jcotoltutic ti jaylajuntosuntutic ti li'oyuntutic li' ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ti yanlum crixchanoetique ja' luz yu'un, yu'un hech chilic ti xu' chcolic uque. Ti ho'ontutic ti yelnich'onuntutic ti Israele, ti t'ujbiluntutic avu'une, apasojuntutic ti muc' yu'un ho'ontutic ti jtojoltutic ihul ti Jcoltavaneje, xchi ti Simeone, xut ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ti Josee xchi'uc ti sme' ti olole ich'ay yo'ntonic yu'un ti hech oy sc'opilal laj ya'yic ti yole. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Ti Simeone laj sc'ambe bendición ti stojol ti olole. Hech laj yalbe ti sme' ti olole, ja' ti Maríae: ―A'yo me ava'i, ti sventa ti avol li'to hech tspasbatic proval yo'ntonic ti jchi'iltique, ho'ucutic ti yelnich'onucutic ti Israel xchi'uque, hech chvinaj ti c'usi tsnopique. Ja' ep chbolib yo'ntonic ti jchi'iltique yu'un. Hech yu'un ep chich' contrainel ti avole yu'un mu xc'anat yu'unic. Ja' ti sventa uc ti ep chavich' mul ho'oti. Oy yan ti jchi'iltique ja' chlecub yo'ntonic yu'un ―xchi ti Simeone. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Te oy uc ti yut templo jun ants, Ana sbi. Ja' j'alc'op yu'un Dios uc ti Anae. Ja' judio ants ti Anae, ja' stseb ti Fanuele ti oy ti jchop yu'un ti Asere. Me'el xa ti Anae. Hucub no'ox habil laj yic' sbaic xchi'uc ti smalale, patil icham ti smalale. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chanib yo'vinic habil yich'oj ti Anae, hech yu'un ep habil mu'yuc smalal. Scotol c'ac'al te italilan ti templo. Ti c'ac'al ti ac'ubal chac' sba ti abatinel te ti stojol ti Diose, chipan sba, tsc'opon Dios. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","C'alal yac'oj sba chalbe sc'opilal ti olole ti Simeone, ital ti Anae. Ti Ana uque lic yalbe vocol ti Cajvaltic Diose yu'un ti ital xa ti Jcoltavaneje. Patil lic spucbe sc'opilal ti olole scotol ti xchi'iltaque ti yac'oj sba tsmalaic ti tsc'an chcolique te ti Jerusalén. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ti c'alal laj xa spas scotol ti Josee xchi'uc ti Maríae hech chaj c'u che'el yaloj ti mantaletic ti Cajvaltic Diose, hech isutic batel ti sna te ti Nazaret. Ja' te ti estado Galilea. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Lec ich'i ti quereme, ja' ti Jesuse. Oy lec yip. P'ij ti quereme yu'un ep i'ac'bat bendición yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Scotol habil ibatilan ti Jerusalén ti stot sme' ti Jesuse. Ba yaq'uic ti milel ti smoton ti Diose yu'unique te ti yorail q'uin Pascua sbi. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","C'alal yich'oj xa lajcheb habil ti Jesuse, ibatic ti Jerusalén ti yorail ti q'uine yu'un smantal Dios yu'un ti hech chbatilanique. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","C'alal ilaj ti q'uine, isutic batel ti sna. Ti stot sme' ti Jesuse muc sna'ic ti te icom ti Jerusalén ti squereme. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Laj scuyic ti laj xchi'in sutel ti yuts yalaltaque. Hech yu'un ixanavic batel jun c'ac'al. Hech lic sa' ti stojol ti yuts yalaltaque xchi'uc ti much'utic xojtiquinic ti quereme. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Muc staic, hech yu'un isutic batel ti Jerusalén ti stot sme'e. Te c'ot sa'ic. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ti yoxibal c'ac'al c'ot staic te ti yut templo yu'unic te ti Jerusalén. Te nacal ti o'lol ti stojol ti xchi'iltac ti ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique c'ot staic. Ti Jesuse cha'ibe sc'op ti jchanubtasvanejetique. Stuc yac'oj sba tsjac' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ich'ay yo'ntonic scotol ti much'utic laj ya'yic ti c'u che'el itac'av, ti c'u che'el laj sjac' ti quereme. Yu'un ti Jesuse laj ya'ibe sjam scotol ti c'usi laj yal ti jchanubtasvanejetic ti scuyoj sbaique. Ich'ay yo'ntonic yu'un ti lec itac'av ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ti c'alal c'ot staic ti squereme ti stot sme'e, ich'ay yo'ntonic uc. Ti sme'e hech laj yalbe ti Jesuse: ―Querem, ¿c'u yu'un hech laj apasbuntutic? Laj jsa'ilanotutic ti jyalel. Laj quich'tutic mul avu'un, yu'un muc xajtatutic ti sa'el ―x'utat yu'un ti sme'e. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Itac'av ti Jesuse: ―¿C'u yu'un laj asa'ucun? ¿Mi mu xana'ic ti li' xu' xataun ti sna ti Jtote? ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ti stot sme'e muc xa'ibeic sjam ti hech itac'av ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ti Jesuse laj xchi'in batel ti Nazaret ti stot sme'e. Te laj xch'umbe smantalic. Scotol ti c'utic laj spas ti Jesuse icom ti yo'nton ti sme'e, tsnopilan ti yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","P'ij iloc' ti Jesuse. Laj sta xch'iel. Lec i'ilat yu'un ti Diose. Lec i'ilat uc yu'un ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yo'lajunebal xa habil yochel ti mero totil ajvalile te ti jteclum Roma, ja' ti Tiberio César sbie. Ja'uc te ti estado Judea ja' ochem ti gobernador yu'un ti Poncio Pilatoe. Ja'uc te ti estado Galilea ja' ochem ti gobernador yu'un ti Herodese. Ja'uc te ti balumil Iturea xchi'uc ti balumil Traconite ja' ochem ti ajvalil yu'un ti yits'in ti Herodese. Ja' Felipe sbi ti yits'ine. Ja'uc te ti balumil Abilinia ja' ochem ti ajvalil yu'un ti Lisaniase. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ja' ochem ti totil pale yu'un ti xchi'iltaque ti Anase xchi'uc ti Caifase, ja' ti co'ol judioetique. C'alal hech yich'ojic yabtelic, te oy ti xocol balumil ti Juane, ja' ti snich'on ti Zacaríase. Ja' hech yorail ti i'albat ti yo'nton yu'un ti Diose ti ac'o xcholbe ti sc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Hech ixanav batel ti Juane te ti ti'ti'uc'um Jordán. Hech laj yal: ―Suteso me avo'ntonic yu'un amulic, ich'ic ho' hech chaxch'ayboxuc amulic ti Diose ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yu'un hech ts'ibabil comel sc'opilal ti Juane te ti sun ti Isaíase, ja' ti j'alc'op yu'un ti Diose ti vo'one. Hech laj yal ti Isaíase: Chlic jun jchi'iltic. Tsots chc'opoj ti xocol balumil. Hech chal: “Chtal xa ti Cajvaltique hech yu'un comesic ti c'utic chasbolibtasoxuque, ");
INSERT INTO tzoNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","yu'un hech chapasic ti muc' ti sc'ope, yu'un hech lec chabatic. Chastojobtasoxuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yu'un chtal xa ti Jcoltavanej cu'untique ti laj xa stac talel ti Diose. Ja' chtal scolta scotol crixchanoetic li' ti balumile”, chlic yut ti xchi'iltaque, xchi ti Isaíase. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ep ti much'utic ba ya'ibeic sc'op ti Juane. Ti Juane hech laj yalbe ti much'utic tal sc'anic yu'un chich'ic ho': ―Ti ho'oxuque hech chaj c'u che'el ti orachone. Mi chtal c'oc' cha'i, chjatav. Hech un ja' no'ox hech ti ho'oxuque. ¿Mi yu'un chava'yic ti ta ono'ox xavich'ic vocol yu'un ti Diose yu'un ti natalic ti anil yu'un tal ac'anic ich'ho' ti jtojol ti ho'oxuque? ");
INSERT INTO tzoNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ja' tsc'an ti primero chavac' ti q'uelel ti avabtelique mi melel ti sutem xa avo'ntonic yu'un ti amulique. Mu me hechuc chanopic ti avo'ntonic: “Ja' jtatamoltic ti Abrahame, hech yu'un chijcolucutic”, mu me xachiic. Chacalbe, ti Diose xu' tsc'atajes ti yelnich'on Abraham avi ton li'to. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ti ho'oxuque hech chaj c'u che'el ti te'etique ti mu xac' lec sate, hech yu'un te xa oy eq'uel ti yoc. Ja' chich' ts'etel. Patil chtenat ochel ti c'oc' ―xchi ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ti Juane hech ijac'bat yu'un ti crixchanoetique: ―¿C'usi chcut jbatutic che'e, ho'ontutic? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Itac'av ti Juane, hech laj yalbe: ―Ti much'u cha'lic sc'u'e jlic ac'o yac'be ti much'u mu'yuc yu'une. Ti much'u oy sve'ele hech ac'o spas uc ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Oy italic uc jtsobpatanetic yu'un tal sc'anic yu'un chich'ic ho' uc. Hech tal sjac'be ti Juane: ―Maestro, ¿c'usi chcut jbatutic uc, ho'ontutic? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ti Juane hech laj yalbe: ―Mu me xac'ambeic yech'omal ti patan ti chatsobique ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Te oy soldadoetic uc. Hech ijac'bat ti Juane yu'un ti soldadoetique: ―Ti ho'ontutique, ¿c'usi chcut jbatutic? ―xchiic. Ti Juane hech laj yalbe: ―Nichimuc me avo'ntonic yu'un ti c'u yepal cha'ac'batic ti stojol avabtelique. Mu me much'u chasibtas, mu me much'u chanopbe smul yu'un hech xu' avu'un chavich'be staq'uin ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Scotol ti crixchanoetique chlo'laj yo'ntonic, tsc'an cha'yic ti mi ja' ti Jcoltavaneje ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hech lic c'opojuc ti Juane, hech laj yalbe ya'yic scotolic: ―Ho'oni, ja' no'ox cabtel chcac'be yich' ho' ti much'u sutem xa yo'ntonic yu'un smulic. Ti much'u patil chtale ja' tsots yabtel yich'oj. Ho'oni mu tsotsuc cabtel quich'oj. Ma mi sjitumbeluc yaq'uil sempat, mu'yuc c'usi xu' ti jcolta mi jutuc. Ja' chayac'boxuc avich'ic ti Ch'ul Espíritue xchi'uc c'oc' yu'un hech chloc' scotol ti sbolil avo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jun to stsacoj ti sc'ob ti sjorquetae yu'un chic'a strigo. C'alal chlaj yo'nton laj yic'a strigo, tsmes ti yelae. Tstsob ochel ti sna ti strigoe. Ti xpaxaq'uil trigoe chchic' ti c'oc' ti bu mu stac' tup'ele ―xchi ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ep yan mantal laj xcholbe ya'yic ti xchi'iltaque ti Juane, ja' ti co'ol judio xchi'uque, hech laj yalbe ya'yic ti lequil ach' c'ope. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ti Herodese, ja' ti ajvalile, albil ono'ox yu'un ti Juane ti mu xtun ti laj spojbe ti yajnil ti yits'ine, ja' ti Herodíase, yu'un laj yic'. Ja' Felipe sbi ti yits'in ti Herodese. Albil ono'ox uc yu'un ti Juane ti mu xtun ti c'utic yan chopol tspas uque. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Muc spas ti muc', ja' no'ox más ba stoy smul, laj stic' ti chuquel ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","C'alal te ch-ac'bat yich'ic ho' ep crixchanoetic, ital uc ti Jesuse. I'ac'bat yich' ho' uc. Patil c'alal yac'oj sba tsc'opon Dios ti Jesuse, ijam ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Iyal tal ti sba ti Jesuse ti Ch'ul Espíritue. Oy sbec'tal jun to culajte x'elan iyal tal ti sba ti Jesuse. Te icom. Ti Diose ic'opoj te ti vinajel: ―Ho'ot Jnich'onot, lum c'uxot ti co'nton. Nichim no'ox co'nton avu'un ―xchi xc'opoj te ti vinajel. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","C'alal lic abtejuc ti Jesuse, jun to lajuneb xcha'vinic habil yich'oj. Cuybil ti snich'on José pero ja' yelnich'on ti Elie, ja' ti stot ti Maríae. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ti Elie ja' stot ti Matate. Ti Matate ja' stot ti Levie. Ti Levie ja' stot ti Melquie. Ti Melquie ja' stot ti Janae. Ti Janae ja' stot ti Josee. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ti Josee ja' stot ti Matatíase. Ti Matatíase ja' stot ti Amose. Ti Amose ja' stot ti Naume. Ti Naume ja' stot ti Eslie. Ti Eslie ja' stot ti Nagaye. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ti Nagaye ja' stot ti Mate. Ti Mate ja' stot ti Matatíase. Ti Matatíase ja' stot ti Semeye. Ti Semeye ja' stot ti Josee. Ti Josee ja' stot ti Judae. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ti Judae ja' stot ti Joanae. Ti Joanae ja' stot ti Resae. Ti Resae ja' stot ti Zorababele. Ti Zorababele ja' stot ti Salatiele. Ti Salatiele ja' stot ti Nerie. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ti Nerie ja' stot ti Melquie. Ti Melquie ja' stot ti Adie. Ti Adie ja' stot ti Cosame. Ti Cosame ja' stot ti Elmodame. Ti Elmodame ja' stot ti Ere. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ti Ere ja' stot ti Josuee. Ti Josuee ja' stot ti Eliezere. Ti Eliezere ja' stot ti Jorime. Ti Jorime ja' stot ti Matate. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ti Matate ja' stot ti Levie. Ti Levie ja' stot ti Simeone. Ti Simeone ja' stot ti Judae. Ti Judae ja' stot ti Josee. Ti Josee ja' stot ti Jonane. Ti Jonane ja' stot ti Eliaquime. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ti Eliaquime ja' stot ti Meleae. Ti Meleae ja' stot ti Mainane. Ti Mainane ja' stot ti Matatae. Ti Matatae ja' stot ti Natane. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ti Natane ja' stot ti Davide. Ti Davide ja' stot ti Isaie. Ti Isaie ja' stot ti Obede. Ti Obede ja' stot ti Booze. Ti Booze ja' stot ti Salmone. Ti Salmone ja' stot ti Nasone. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ti Nasone ja' stot ti Aminadabe. Ti Aminadabe ja' stot ti Arame. Ti Arame ja' stot ti Esrome. Ti Esrome ja' stot ti Farese. Ti Farese ja' stot ti Judae. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ti Judae ja' stot ti Jacobe. Ti Jacobe ja' stot ti Isaaque. Ti Isaaque ja' stot ti Abrahame. Ti Abrahame ja' stot ti Taree. Ti Taree ja' stot ti Nacore. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ti Nacore ja' stot ti Serugue. Ti Serugue ja' stot ti Ragave. Ti Ragave ja' stot ti Pelegue. Ti Pelegue ja' stot ti Hebere. Ti Hebere ja' stot ti Salae. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ti Salae ja' stot ti Cainane. Ti Cainane ja' stot ti Arfajade. Ti Arfajade ja' stot ti Seme. Ti Seme ja' stot ti Noee. Ti Noee ja' stot ti Lameque. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ti Lameque ja' stot ti Matusalene. Ti Matusalene ja' stot ti Enoque. Ti Enoque ja' stot ti Jarede. Ti Jarede ja' stot ti Malalele. Ti Malalele ja' stot ti Cainane. ");
INSERT INTO tzoNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ti Cainane ja' stot ti Enose. Ti Enose ja' stot ti Sete. Ti Sete ja' stot ti Adane. Ti Adane ja' stot ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ti Jesuse nojem ti yo'nton ti Ch'ul Espíritue hech iloc' batel ti ti'uc'um Jordán. Te i'ic'at batel te ti xocol balumil yu'un ti Ch'ul Espíritue. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Te icom ti xocol balumil cha'vinic c'ac'al ti Jesuse. Te tal pasbatuc proval yo'nton ti Jesuse yu'un ti totil pucuje. Yu'un yipanoj sba ti Jesuse muc xve', hech lic vi'najuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ti Jesuse hech i'albat yu'un ti totil pucuje: ―Mi ho'ot Snich'onot ti Diose, paso mantal ac'o pasuc ti vaj avi ton li'to hech chata ave'el ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Itac'av ti Jesuse, hech laj yalbe: ―Hech ts'ibabil: “Ma'uc no'ox ti vaj chijcuxi. Ja' ti sventa ti sc'op Dios uque chijcuxi”, ti xchie. Hech ts'ibabil ti sun ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Patil ti totil pucuje laj yic' batel ti jolvits ti Jesuse. Toyol ti vitse. Ti ora i'ac'bat sq'uel ti Jesuse scotol ti ajvaliletique ti li' ti balumile xchi'uc ti sp'ijilique ti c'u che'el tspasic mantale. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Hech i'albat yu'un ti totil pucuje: ―Chacac'bot aventain scotol avi to xchi'uc sp'ijilic xchi'uc sc'ulejalic yu'un ni'ac'bat xa jventain ho'oni. Ja' chcac'be ti much'u sc'an co'nton chcac'be. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Hech yu'un mi chaquejan aba ti jtojole, ja' avu'un scotol ti avac'oj aba chaq'uel avi li'to ―x'utat ti Jesuse yu'un ti totil pucuje. Yu'un mi chch'un ti Jesuse jun chc'otic xchi'uc o. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Itac'av ti Jesuse, hech laj yalbe: ―Batan, Satanás, mu stac' ti jch'un amantal. Yu'un hech ts'ibabil: “Ja' chapasic ti muc' stuc ti Cajvaltic Diose, ja' ti Dios cu'untique. Ja' chach'umbeic smantal stuc”, ti xchie. Hech ts'ibabil ―xchi ti Jesuse, xut ti pucuje. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Patil ti totil pucuje laj yic' batel ti Jerusalén ti Jesuse. Te laj yic' batel ti templo. Ti totil pucuje c'ot sva'an ti mero joltemplo ti Jesuse. Hech laj yalbe: ―Mi ho'ot Snich'onot ti Diose, teno aba yalel li'i. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yu'un hech ts'ibabil: Chastacbot talel xch'ul abat yu'un chaxchabiot. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Chastsacot ti sc'ob ti xch'ul abate chayic' batel yu'un hech mu xyaj avacan ti ton, xchi ts'ibabil ―x'utat ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Itac'av ti Jesuse, hech laj yalbe: ―Mi ti jten jba yalel li'i, ti jpasbe proval yo'nton ti Diose yu'un ti jq'uel mi chiscoltaun. Hech ts'ibabil ti sc'op ti Diose: “Mu me xapasbe proval yo'nton ti Cajvaltic Diose, ja' ti Dios cu'untique”, xchi ts'ibabil ―x'utat ti totil pucuje yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","C'alal laj yo'nton ti totil pucuje ti muc xch'un ti Jesuse, hech ibat ti totil pucuje. Ti totil pucuje tsmala mi oy lec tiempo xu' tspasbe proval yo'nton ti Jesuse yan vuelta. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ti Jesuse isut batel ti Galilea. Jelaven sp'ijil ti Jesuse ti sventa ti Ch'ul Espíritue, hech yu'un ipuc sc'opilal ti sjoylejal balumil ti c'usi lec laj spas ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ichanubtasvan te ti temploetic yu'un ti judioetique. Lec sc'opilal yu'un scotol crixchanoetic. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ic'ot ti Nazaret ti Jesuse, ja' ti bu ich'ie. Ti yorail chcux yo'ntonic ti judioetique te ibat ti templo uc. Nopen cha'i ti hech chbatilan ti templo ti Jesuse ti yorail chcux yo'ntonic. Te ti yut templo laj sva'an sba ti Jesuse yu'un tsc'an tsq'uel sc'op Dios. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Hech lic ac'batuc ti sun ti Isaíase, ja' ti j'alc'op yu'un ti Diose. Laj sjam ti hune, laj sta yo' bu hech ts'ibabil: ");
INSERT INTO tzoNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ventaimbilun yu'un ti Ch'ul Espíritue, ja' yu'un ti Cajvaltic Diose. Laj xa st'ujun yu'un ti jcholbe ti lequil ach' c'ope ti much'utic uts sbaique. Laj xa stacun talel yu'un ti jmuc'ubtasbe yo'ntonic ti much'utic chich'ic mule, yu'un chcalbe ya'yic c'u che'el chcolic ti much'utic chucbilic yu'un mulile, c'u che'el chjam satic ti much'utic ma'satetique, c'u che'el chcolic ti libre ti much'utic chich'ic vocole. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Laj xa stacun talel uc yu'un ti jcholbe sc'opilal ti tsta yorail ti ch-ic'atic ti stojol ti Cajvaltic Diose, xchi laj sq'uel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ti Jesuse hech laj sbal ti sc'op Diose, ja' laj yac'be ti abate, hech inaqui te ti stojol scotolic. Scotol ti much'utic te oyic ti yut templo laj sq'uelilambeic sat ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ti Jesuse hech lic yalbe ya'yic: ―Ti ora to ic'ot xa ti pasel ti hech ts'ibabil ti sun ti Diose ti laj xa ava'yique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Hech yu'un ti Jesuse lec sc'opilal yu'unic scotolic. Ich'ay yo'ntonic yu'un ti jelaven yutsil ti sc'ope laj ya'yique. Hech laj yalbe sbaic: ―Ja' snich'on ti José li'to. ¿Mi mu hechuc? ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ti Jesuse hech laj yalbe: ―Hech chlic avalbucun hech chaj c'u che'el oy chalic: “Ho'ot jpoxtavanejot, poxtao aba atuc, hech chlic jch'untutic”, ti xchiique, xavutucun. Ja' hech sjam ti chac'an ti jpas li' ti jlumaltique ti c'u che'el laj xa ava'yic ti ihu' cu'un te ti jteclum Capernaume yu'un hech chlic ach'unic chacuyique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Hech laj yalbe uc: ―Melel ti c'usi chacalbeique, buc no'ox chbat j'alc'op yu'un ti Diose ja' tspasat ti muc'. Ja' no'ox te ti slumal ja' mu spasat ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Melel ti c'usi chacalbeique, c'alal i'ay li' ti balumile ti Elíase, o'lol xchanibal habil muc xac' ho' li' ti balumile. Scotol crixchanoetic itsacatic ti vi'nal. Ep me'on antsetic xchi'inojic ti jchi'iltique, ho'ucutic ti yelnich'onucutic ti Israele. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ti Elíase muc xbat te ti stojol ti me'on antsetique, ja' ti jchi'iltique. Ja' itacat batel ti stojol ti jun yanlum me'on ants te ti jteclum Sarepta ti nopol xil sbaic xchi'uc ti jteclum Sidone. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","C'alal i'ay li' ti balumile ti Eliseoe, ja' ti j'alc'op yu'un ti Diose, ep ti jchi'iltique tsacbilic ti c'a'el chamel. Mi junuc muc xcoltaat ti jchi'iltique yu'un ti hech oy xchamelique. Ja' no'ox icoltaat ti Naamane, ja' ti yanlum vinic ti liquem tal ti Siriae ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","C'alal laj ya'ibeic sc'op ti Jesuse hech yu'un ti judioetique ti te stsoboj sbaic te ti temploe, xtec'tun no'ox i'ilinic. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Laj yiq'uic loq'uel ti jteclum. Te meltsambil ti c'alvits ti jteclume, hech yu'un laj yiq'uic batel ti jolvits yu'un tsc'an tstenic yalel ti ch'en. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Hech yu'un ti Jesuse c'alal te oy ti jolvits i'ech' ti o'lol ti crixchanoetique, hech ibat. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ti Jesuse iyal batel ti jteclum Capernaum te ti estado Galilea. C'alal ic'ot sc'ac'alil chcux yo'ntonic ti judioetique, ti Jesuse i'och ti templo yu'unique xchi'uc ti yajchanc'opetique. Te ichanubtasvan ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ich'ay yo'ntonic ti crixchanoetique yu'un ti c'usi laj yac' ti chanel ti Jesuse yu'un ichanubtasvan hech chaj c'u che'el ti much'u tsots yabtel yich'oje. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Te oy ti yut templo jun judio vinic ti oy pucujetic ti yo'ntone. Tsots ic'opoj ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Hech laj yal: ―Mu xavilbajinuntutic. Mu aventauntutic, Jesús, ho'ot liquemot tal ti Nazarete. ¿Mi yu'un tal amiluntutic? Chacojtiquin. Ho'ot Snich'onot ti Diose, ho'ot mu'yuc amul ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ti Jesuse laj spajes ti pucujetique ti hech xch'amunojbe ye ti vinique, hech laj yalbe: ―Anchanic, loc'anic tal ti yo'nton ti vinique ―xut. Yip no'ox ip'aj ti lum ti vinique yu'un ti pucuje, hech iloq'uic tal ti yo'nton ti vinique. Mi jutuc muc xyaj ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Scotolic ich'ay yo'ntonic, hech laj sjac'be sbaic: ―¿Much'u li' talem li'to? Oy sp'ijil, xu' yu'un tspas ti mantal ti pucujetique. Ch'umbil smantal yu'unic chavil ―xut sbaic ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ipuc sc'opilal ti hech laj spas ti Jesuse. Ipuc ti scotol jteclumetic te ti sjoylejal ti Capernaume. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","C'alal iloc' ti templo ti Jesuse, te chbat ti sna ti Simone. Te oy ti sna ti sme' ti yajnil ti Simone. Oy sc'ac'al sbec'tal. Hech lic sc'ambeic vocol ti Jesuse ti ac'o scolta ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ti Jesuse inopej batel ti yo' bu metsel ti antse, laj yal mantal ac'o lamajuc ti sc'ac'ale. Ti ora ilamaj ti sc'ac'ale. Ti ora ilic ti antse, lic mac'linvanuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","C'alal chmal xa ti c'ac'ale, i'ic'atic talel ti stojol ti Jesuse scotol ti much'utic tsacbilic ti chamel, c'uc no'ox chamel yich'ojique. Ti Jesuse laj yac' sc'ob laj yac'be ti sjolic jujun, hech icolic yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ep iloc' pucuj ti yo'ntonic. Oy tsots ic'opoj ti pucujetique c'alal iloq'uique. Hech laj yalic: ―Ho'ot Snich'onot ti Diose ―xchiic. Hech yu'un ti Jesuse laj spas ti mantal ti yan pucujetique yu'un mu me xc'opojic yu'un laj yojtiquinic ti ja' ti Jcoltavaneje. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ti yoc'omal c'alal isacub ti osile, iloc' batel ti Jesuse, ibat ti yo' bu xocol balumil. Isa'at yu'un ti judioetique. C'alal c'ot staic, tsc'an tspajesic ti Jesuse yu'un mu me xloc' batel te ti jteclum yu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ti Jesuse hech laj yalbe: ―Persa chba jcholbe uc ti lequil ach' c'ope ti much'utic te ti yan jteclumetique, yu'un ac'o sna'ic uc ti tsc'an tsventaimbe yo'ntonic crixchanoetic ti Diose. Ja' yu'un ti talemun li'to ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hech ti Jesuse ba xchol ti sc'op Diose te ti scotol temploetic te ti estado Galilea. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Hech yu'un ti yan c'ac'al te ic'ot ti ti'nab ti Jesuse. Genesaret sbi ti nabe. Inet'van tal ti crixchanoetique yu'un sc'an cha'yic ti sc'op ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ti Jesuse laj yil te oy chib barcoetic nopol ti'nab. Loq'uemic ti yajval barcoe, ja' ti jtsacchoyetique. Yac'oj sba tsapilanic ti slebique ti jtsacchoyetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ti Jesuse laj stic' sba ochel ti yut jun barco, ja' ti sbarco ti Simone. Laj yal mantal ti ac'o batuc jutuc ti ba ho' ti barcoe. Ti Jesuse te laj snacan sba ti yut barco. Hech lic xchanubtas ti crixchanoetique ti te stsoboj sbaic te ti ti'ti'nab. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","C'alal laj yo'nton chanubtasvanuc ti Jesuse, hech laj yalbe ti Simone: ―Batic ti bu nat ti ho'e. Te chlic atenic ochel ti yut ho' ti alebique yu'un te chataic ep choy ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Itac'av ti Simone, hech laj yalbe: ―Maestro, sjunul ac'ubal laj jsa'tutic, muc jtatutic. Yu'un ho'ot amantal, hech yu'un ti jten ochel ti ho' ti jlebe ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","C'alal hech laj stenic ochel ti ho' ti slebique, ep choy i'ochic ti slebique. C'an tuch'uc ti slebique yu'un lum ep ti choye. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hech yu'un laj sjimc'obtaic ti xchi'iltaque ti te tic'ajtic ti yan barcoe yu'un ac'o tal coltavanuc. Hech italic. Inoj ti choy ti chib barcoetique. C'an ch'ayuc ochel ti yut ho' ti barcoetique yu'un ol ti yicatse. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","C'alal laj yil ti Simon Pedroe ti hech inoj ti choy ti barcoetique, laj squejan sba ti stojol ti Jesuse. Hech laj yalbe: ―Más lec mi chaq'uej aba ti jtojol, Cajval, yu'un ho'on jmulavilun ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yu'un ep ti jyalel ti choy ti laj stsaquique hech yu'un toj xi'el ic'ot ti Simone xchi'uc ti xchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hech yo'ntonic uc ti Jacoboe xchi'uc ti Juane, ja' ti xnich'nab ti Zebedeoe ti ja' chchi'in sbaic ti abtel xchi'uc ti Simone. Ti Jesuse hech laj yalbe ti Simone: ―Mu me xaxi'. Ti jel avabtel. Chba asa'bun tal crixchanoetic ―x'utat yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","C'alal ic'otic ti ti'nab, iloq'uic ti barco. Hech laj scomesic scotol ti c'utic oy yu'unique. Ja' laj sts'acliic batel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","C'alal te oy ti jun jteclum ti Jesuse, ital jun judio vinic. Tsacbil ti c'a'el chamel ti vinique. C'alal laj yil ti Jesuse ti vinique, tal spatan sba ti stojol ti Jesuse, lic yalbe vocol. Hech laj yalbe: ―Cajval, mi chac'ane, xu' chichop avu'un ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ti Jesuse laj yac' sc'ob laj yac'be ti sjol ti vinique. Hech laj yalbe: ―Hechuc, chopan ―xut. Ti ora ichop ti vinique ti c'a'el chamel yich'oje. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ti Jesuse hech laj yalbe: ―A'yo me ava'i, mu me much'u chavalbe ya'i. Batan, ba ac'o aba ti q'uelel ti stojol ti palee. Ac'bo smoton ti Diose hech chaj c'u che'el laj yal ti Moisese. Hech tsna'ic ti jchi'iltique ti nacol xae ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Más ipuc batel sc'opilal ti Jesuse. Ep crixchanoetic laj stsob sbaic tal yu'un sc'an cha'ibeic sc'op, yu'un tsc'anic ti chchop ti xchamelique. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ti Jesuse laj sq'uej sba batel ti bu xocol balumil. Te ba sc'opon Dios. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ti yan c'ac'al c'alal yac'oj sba chchanubtasvan ti Jesuse, te nacajtic uc fariseoetic xchi'uc ti xchi'iltac ti ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Te cha'ibeic sc'op uc ti Jesuse. Ti totiletique ja' talemic ti jujun biq'uit jteclum te ti estado Galilea xchi'uc ti estado Judea. Oy talemic uc ti muc'ta jteclum Jerusalén. Ti Jesuse i'ac'bat ep sp'ijil yu'un ti Cajvaltic Diose yu'un hech icol yu'un ti jchameletique. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Oy judio viniquetic laj yiq'uic tal ti stojol ti Jesuse jun jchamel vinic. Sicuben yacan ti vinique. Laj spasilanic preva mi xu' chjelavic ochel ti stojol ti crixchanoetique yu'un hech chc'ot smetsanic ti stojol ti Jesuse te ti yut na. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yu'un mu xu' ch-ochic ti yut na yu'un te humajtic ti crixchanoetique, hech yu'un imuic ti jolna yu'un pamal ti jolnae. Hech yu'un lic stotsic ti texa yu'un hech xu' tstiq'uic ochel yu'un hech xu' tsliquic yalel xchi'uc spop ti jchamele ti sicuben yacane. Hech chc'ot ti stojol ti Jesuse ti jchamele. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yu'un ti hech ic'ot ti stojol ti Jesuse ti jchamele, hech laj yil ti Jesuse ti chch'unique, hech yu'un laj yalbe ti jchamele: ―Tote, ch'ayem xa amul ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hech yu'un ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti fariseoetique hech laj yal ti yo'ntonic: “Ja' ti vinic li'to, Dios tscuy sba. Mu'yuc much'u yan xu' chixch'aybucutic jmultic. Ja' no'ox stuc ti Diose”, xchi xc'opojic ti yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ti Jesuse laj sna' ti hech yac'oj sba chc'opojic ti yo'ntonique hech yu'un hech laj yalbe: ―¿C'u yu'un ti mu lecuc chc'opoj avo'ntonic? ");
INSERT INTO tzoNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Melel much'uuc no'ox xu' chal ti “ch'ayem xa amul”, xu' xchi. Much'uuc no'ox xu' chal uc ti “lican, xanavan”, xu' xchi. Ja' tsc'an chaq'uel ti much'u hech chc'opoje mi chc'ot ti pasel yu'un hech chaj c'u che'el chal. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Laj xa cal ti ch'ayem xa smul hech yu'un q'uelo c'usi ti jpas ti ora to yu'un hech chana' ti melel ti ho'on ti jch'ay mulil li' ti balumile, ho'on ti co'ol crixchanoucutique ―xut. Ti Jesuse hech laj yalbe ti jchamele: ―Ho'ot chacalbe, lican, balo batel apop, batan ti ana ―xut ti jchamele, xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ti ora ilic ti jchamele. Hech laj yilic scotolic. Laj sbal ti spope, hech ibat ti sna yac'oj sba chalbe vocol ti Diose batel. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","C'alal laj sq'uelic ti hech ic'ot ti pasele, ich'ay yo'ntonic ti judioetique. Lic yalbeic vocol ti Diose yu'un ti hech ic'ot ti pasele. Yu'un ti ich'ay yo'ntonique, hech lic yalbe sbaic: ―Mu'yuc bu quilojtic hech hech chaj c'u che'el laj quiltic nax ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Patil iloc' batel ti Jesuse. Te oy jun jtsobpatan, Leví sbi. Ja' Mateo sbi ti jc'optique. Te nacal yac'oj sba tstsob patan laj yil ti Jesuse. Hech yu'un hech laj yalbe: ―Chi'inun batel ―xut ti jtsobpatane ja' ti batem yo'nton chlo'lavan ti taq'uine. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ti Levie laj scomes scotol ti c'usi oy yu'une, laj xchi'in batel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Patil ti Levie laj yac' ve'elil hech yu'un laj yic' ti ve'el ti Jesuse te ti sna. Te xchi'inoj ti mesa ti Jesuse ep xchi'iltac ti Levie ti co'ol jtsobpatanetic xchi'uque, xchi'uc yantic. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ti much'utic chchanubtasvan ti smantal ti Diose ti scuyoj sbaique xchi'uc ti fariseoetique hech lic yalbe ti yajchanc'opetic ti Jesuse: ―Mu xtun ti chachi'inic ti ve'el jtsobpatanetic xchi'uc yan jp'ajmantaletic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Itac'av ti Jesuse, hech laj yalbe: ―Ti much'utic lec oyique mu yu'unuc tsc'anic jun jpoxtavanej yu'un lec oyic. Ja' no'ox tsc'anic jpoxtavanej ti much'utic jchameletique. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ja' no'ox hech uc ma'uc tal jcolta ti much'utic ti jun yo'nton ti stojol ti Diose. Ja' tal quic' ti jtojol ti much'utic mu junuc yo'nton ti stojol ti Diose yu'un ac'o sutes yo'ntonic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hech lic sjac'beic: ―Ti yajchanc'opetic ti Juane ep vuelta chipan sbaic tsc'oponic Dios. Hech tspasic uc ti cajchanc'optutique, ho'ontutic ti fariseountutique. ¿C'u yu'un mu hechuc tspasic uc ti avajchanc'opetique? Ja'uque mu xipan sbaic ―x'utat ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ti Jesuse hech laj yalbe: ―Ti much'utic tspasic q'uin sventa nupunele, ¡bu c'amba yipan sbaic c'alal te to xchi'inojic ti much'u chnupune! ");
INSERT INTO tzoNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Hech yu'un ti mu xipan sbaic ti cajchanc'op ti ora to. Ja'to mi ic'ot yorail chismilucun ti cajcontrae, ja'to chlic yich'ic mul, chlic yipan sbaic ti cajchanc'ope ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ti Jesuse lic yalbe lo'il. Oy sjam ti lo'il ti laj yalbee. Hech laj yalbe: ―Scotol ti much'u chixch'umbun ti jc'ope persa tscomes ti c'u che'el xch'unoj ono'oxe, ja' ti poco c'ope. Persa ja' chch'un ti ach' c'ope. Hech chaj c'u che'el ti much'u tspac'an ti bu lajem ti sc'u'e, mu yu'unuc tstuch' loq'uel jun pedazo ti ach' sc'u'e yu'un hech tspac'an ti poco c'u'il yu'une. Taca hechuc tspase yu'un hovil yu'un jomol chcom ti ach' c'u'il yu'une. Yu'un ti ach' poc' xchi'uc ti poco c'u'ile mu snupin. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hech chaj c'u che'el mu'yuc much'u tspul ach' vino ti yac'oj sba chyijube ti bu poco nucul ti spulobil vinoe. Mi hech tspase, chjat ti nucule. Lástima chmal scotol ti vinoe. J'ech'el mu xa xtun ti nucule. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ti ach' vinoe ti yac'oj sba chyijube sc'an pulel ti ach' nucul. ");
INSERT INTO tzoNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ti much'u yuch'oj xa ti poco vinoe mu sc'an xuch' ti ora ti ach' vinoe yu'un chal: “Ja' lec stuc ti poco vinoe”, xchi ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ti yan c'ac'al i'ech'ic ti Jesuse xchi'uc ti yajchanc'opetique ti bu ts'umbil trigo. Ja' sc'ac'alil chcux yo'ntonic scotolic c'alal te i'ech'ic. Ti yajchanc'opetique laj stuch'ic jutuc trigo laj sju'ic laj sc'uxic. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","I'ilat yu'un ti fariseoetique. Hech yu'un ti fariseoetique lic yalbeic: ―¿C'u yu'un ti hech chap'ajic mantal? Yu'un ja' sc'ac'alil ti jcux co'ntontic ti ora to ―x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Itac'av ti Jesuse, hech laj yalbe: ―Ti ho'oxuque aq'uelojic xa ti sun ti Diose ti c'usi laj spas ti Davide c'alal itsacat ti vi'nal xchi'uc ti much'utic xchi'inojique. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ja' i'och ti templo yu'un ti Diose. Laj sve' ti caxlan vaje te ti ba mesa te ti stojol ti Diose. Manchuc mi yaloj ti Diose ti stuquic no'ox tsve'ic ti paleetique, laj sve' ti Davide xchi'uc ti xchi'iltaque. Mu'yuc smulic yu'un hech laj spasic ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hech lic yal uc ti Jesuse: ―Ho'on jventainoj ti sc'ac'alil ti jcux co'ntontique, ho'on ti co'ol crixchanoucutique. Ho'on chcal ti c'usi stac' pasel ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ti yan c'ac'al, ja' yorail uc ti chcux yo'ntonic ti judioetique, i'och ti templo yu'unic ti Jesuse. Te ichanubtasvan. Te oy jun vinic, sicuben ti sbats'ic'obe. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Te oy uc cha'vo' oxvo' ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti fariseoetique. Te tsq'uelilanic ti Jesuse mi chcoltavan ti sc'ac'alil chcux yo'ntonic. Yu'un tsc'an tsa'beic smul ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ti Jesuse laj sna' ti hech snopoj ti yo'ntonique, hech yu'un laj yalbe ti vinic ti sicuben sc'obe: ―La' va'ano aba li' ti jtojol ―xut. Hech te tal sva'an sba ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hech yu'un ti Jesuse laj yalbe ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti fariseoetique: ―Oy c'usi chajac'be. Ti sc'ac'alil ti jcux co'ntontic, ¿mi stac' ti jpastic ti c'usi leque, mi stac' ti jpastic ti c'usi chopole? ¿Mi stac' ti chijcoltavane, mi stac' ti chijmilvane? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ti Jesuse laj sq'uelbe satic scotolic ti te nacajtique. Hech lic yalbe ti jchamele: ―Xach'o ac'ob ―xut. Ti ora ichop ti sc'obe. Laj xach' ti sc'obe. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Xtec'tun no'ox i'ilinic. Hech lic comon snopic ti c'u chutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ja' yorail iloc' batel ti Jesuse, imu batel ti vits, te ba sc'opon Dios. Sjunul ac'ubal icom te tsc'opon ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","C'alal isacub xa ti osile, laj yic' tal ti stojol scotol ti much'utic tsts'acliat yu'une. Hech yu'un lic st'uj lajchavo' yu'un ja' tsventain comel yu'un ti xcholel ti sc'ope. Ja' jcholc'opetic ic'ot sbiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ja' laj st'uj ti Simone, ja' ti Pedro laj yac'be sbie, xchi'uc ti yits'ine, ja' ti Andrese. Xchi'uc ti Jacoboe, xchi'uc ti Juane, xchi'uc ti Felipee, xchi'uc ti Bartolomee. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Xchi'uc ti Mateoe, xchi'uc ti Tomase, xchi'uc yan Jacobo, ja' ti snich'on ti Alfeoe, xchi'uc yan Simón, ja' ti laj xchi'in ti zeloteetic ono'oxe. Yu'un ti zeloteetic sbiique ja' yu'un ti toyol yo'ntonic mu sc'an ch-ochic ti mozoil yu'un ti romaetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Xchi'uc ti Judase, ja' ti yermano ti Jacoboe, xchi'uc ti yan Judas, ja' ti Judas Iscariotee, ja' ti laj yac' entrecal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iyal tal ti vits xchi'uc ti yajchanc'opetique ti Jesuse xchi'uc ti jayvo' ichi'inat c'alal i'ay ti vits. Te c'o sva'an sbaic ti bu stenlejal xchi'uc ti yajchanc'opetique. Hech yu'un te c'ot staic ti much'u yan tsts'acliat yu'une xchi'uc yan ep crixchanoetic. Talemic ti estado Judea xchi'uc ti jteclum Jerusalén xchi'uc ti chib jteclum Tiro xchi'uc Sidón, ja' ti te oyic ti ti'ti'nabe. Tal ya'ibeic sc'op ti Jesuse. Italic uc yu'un ac'o chopuc ti xchamelique. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Italic uc ti much'utic oy pucujetic ti yo'ntonique. Scotolic icol yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Scotol ti crixchanoetique sc'an tspiquic ti Jesuse yu'un oy sp'ijil yu'un icol yu'un scotol. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ti Jesuse laj sq'uelbe satic ti yajchanc'opetique xchi'uc scotol ti crixchanoetic ti te stsoboj sbaique, hech lic yalbe: ―Ho'oxuc ti mu'yuc c'usi oy avu'unique chavich'ic bendición. Ja' chasventaimboxuc avo'ntonic ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ho'oxuc ti chavi'najic ti ora to chavich'ic bendición. Ja' chanojesbat avo'ntonic. ’Ho'oxuc ti cha'oq'uic ti ora to chavich'ic bendición. Ti yan c'ac'al chatse'inic. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ho'oxuc ti chayilintaoxuc ti crixchanoetique, ti mu sc'an ti chachi'inique, ti chayutoxuque, ti chaslabanoxuque ti jventa ho'on ti co'ol crixchanoucutique, chavich'ic bendición. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","C'alal hech chc'ot ti pasel, mu me xavich'ic mul. Nichimuc me avo'ntonic yu'un. A'yo me ava'yic, cha'ac'batic ep atojolic ti vinajel. Hech ono'ox i'ilbajinvanic ti statamolic ti vo'one lume. Ja' laj yilbajinic ti j'alc'opetic ti vo'one. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Ja'uc ti ho'oxuc ti jc'ulejoxuque chavich'ic vocol. Yu'un oy xa avu'unic ti c'utic tsc'an ti avo'ntonique, hech yu'un mu'yuc xa c'usi yan chac'anic. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Ho'oxuc ti noj ach'utic ti ora to chavich'ic vocol. Ti yan c'ac'al mu xa xmuc'ub avo'ntonic. ’Ho'oxuc ti chatse'inic ti ora to chavich'ic vocol. Ti yan c'ac'al chavich'ic mul, cha'oq'uic. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Chavich'ic vocol mi yu'un lec c'otem ac'opilalic yu'un scotol crixchanoetic. Ja' ti statamolic ti vo'one lume ja' lec laj yilic ti nopbilal j'alc'opetique ti vo'one. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Ho'oxuc ti chava'ibun jc'op ti ora to hech chacalbeic. C'uxubino ti avajcontraique. Ac'o ti q'uelel yutsil avo'ntonic ti stojol ti much'utic chayilintaoxuque. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","C'ambeic bendición ti stojol ti much'u chayixtalc'optaoxuque. C'opombeic Dios ti stojolic ti much'utic chayilbajinoxuque. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mi oy much'u chasmajot ti jech asate yu'un oy amul tscuy, ac'o smajot ti xcha'jechel uc. Mi oy much'u chaspojbot achij yu'un oy amul ti stojol tscuy, ac'o yich' batel ac'u' uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mi oy c'usi chasc'ambote yu'un oy amul tscuy, ac'bo batel. Mi oy much'u chaspojbot ti c'usi oy avu'une yu'un oy amul ti stojol tscuy, mu xa me xba ac'ambe sut tal. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mi chac'an ti lec chaspasboxuc ti yan crixchanoetique, lec chapasbeic uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Mi ja' no'ox chac'uxubinic ti much'u chaxc'uxubinoxuque, ¡bu ba tojuc ti c'usi chanope! Yu'un co'ol chapasic xchi'uc scotol ti much'utic ti c'utic chopol tspasique ti ja' no'ox chc'uxubinic ti much'u chc'uxubinatic yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mi ja' no'ox lec chapasbeic ti much'u lec chaspasboxuque, ¡bu ba tojuc ti c'usi chanope! Yu'un co'ol chapasic xchi'uc scotol ti much'utic ti c'utic chopol tspasique. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mi ja' no'ox chavac'be xq'uex ataq'uin ti much'u chasutesbot xchi'uc sjol, ¡bu ba tojuc ti c'usi chanope! Yu'un co'ol chapasic xchi'uc scotol ti much'utic ti c'utic chopol tspasique ti chac' ti q'uexel staq'uin yu'un oy xa ep sjol c'alal tsutesbat tal. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Hech yu'un c'uxubinic ti avajcontraique, pasic ti c'usi leque, ac'o ti q'uexel ti ataq'uine, mu me xac'ambeic sjol. Hech cha'ac'batic ep atojolic, hech chavaq'uic ti q'uelel ti yol snich'onoxuc ti Diose ti te oy ti vinajele. Yu'un ti Diose chc'uxubin uc ti much'utic “hocol aval” mu xutic ti Diose, ja' ti much'utic chopol yo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Hech yu'un c'uxubinvananic hech chaj c'u che'el chc'uxubinvan ti Jtotique. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Mu me xasa'beic smul yan hech mu xc'ot yich'bot ac'opic. Mu me xatic'beic smul yan, hech mu xc'ot tic'batucot amulic. Oyuc me perdón ti avo'ntonic hech chapasbatic perdón uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ac'bo smoton yan hech chavich'ic amotonic uc. Más ech'em to cha'ac'batic avich'ic ti ho'oxuque. Hech chaj c'u che'el ti much'u ts'acal chac', lec nojem asta tsbusq'uij xa, ja' hech chavich'ic. Mi mu ts'acaluc chavac' ho'oti hech mu ts'acaluc cha'ac'bat yu'un ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Hech laj yal lo'il ti Jesuse. Oy sjam ti lo'il ti laj yalbee. Hech laj yal: ―Ti much'u ma'sate ¿mi xu' tstojobtas ti yan ma'sate? ¿Mi mu co'oluc chp'ajic yalel ti ch'en? ");
INSERT INTO tzoNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mu tsotsuc yabtel yich'oj ti much'u ochem ti jchanc'ope. Ja' yich'oj tsots yabtel ti yajmaestroe. Mi ts'acal laj xchan ti jchanc'ope, hech co'ol chc'ot xchi'uc ti yajmaestroe. Hech yu'un ja' tsc'an ti chat'uj lec much'u chats'acli. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Mu xtun chavilic ti oy bu chjelav jutuc ti avermanoe. Mu xavil ti ep no'ox chajelav ho'oti. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hech yu'un chavalbe ti avermanoe: “Mu me xapas hech”, xavut. Ho'oti mu xavil ti yac'oj sba chapas ep ho'oti. Jlo'lavanejot. Ja' jbael chacomes scotol ho'oti hech patil xu' chacolta ti ac'o scomes ti bu jutuc no'ox chjelave ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Ti lequil te'e puru lec sat chac'. Ti bu mu xtun ti te'e puru mu xtun ti sat chaq'ue. Mu scap sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yu'un ti c'u x'elan ti sat ti te'e hech chavojtiquinic ti te'e. Hech chaj c'u che'el mu xata durazno ti ch'ix, mu xata manzana ti bu tomal ch'ix, ja' no'ox hech mu xata c'usi lec ti stojol nopbilal j'alc'opetic. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ti much'u lec yo'ntone ja' chloc' ti ye ti c'usi lec snopoj ti yo'ntone. Ti much'u chopol yo'ntone ja' chloc' ti ye ti c'usi chopol ono'ox snopoj ti yo'ntone. Yu'un ti c'usi chnoj ti co'ntontique ja' ta ono'ox chloc' ti quetic. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Hovil ti “Cajval, Cajval”, xavutucune, mu xapasic ti c'utic chacalbeique. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Scotol ti much'u chtal ti jtojol ti chiya'ibun jc'ope ti chch'un ti c'usi chcalbee, chacalbe c'u x'elan. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ja' hech chaj c'u che'el jun vinic ti laj smeltsan sna ti ba ton. Jbael nat laj sjem ti lume asta laj sta ti tone. Te laj sliques ti ba ton ti cementoe. Hech c'alal ital ho', hech inoj ti uc'ume, c'ot smaj sba ti spatpat sna ti ho'e. Muc xbut'q'uij ti snae yu'un lec meltsambil ti ba ton. ");
INSERT INTO tzoNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ti much'u chiya'ibun jc'ope, mi mu spas ti c'utic chcale, ja' hech chaj c'u che'el jun vinic ti laj smeltsan sna ti lum no'ox, muc xac' cemento. Hech c'alal ital ho', hech inoj ti uc'ume, c'ot smaj sba te ti nae. Toj but'q'uijel o ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","C'alal laj yo'nton laj sc'opon ti crixchanoetique ti te ch-a'ibat sc'op te ti yoc vits, i'och ti yut Capernaum ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Te nacal ti Capernaum jun capitan soldado. Ja' liquem tal ti Roma ti capitan soldadoe. Oy jun smozo lum ep c'ux ti yo'nton. Ja' tsacbil ti chamel ti smozo lume. Ta xa xcham xa. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hech yu'un c'alal laj ya'ibe sc'opilal ti Jesuse ti capitan soldadoe, laj stac batel cha'vo' oxvo' ti moletic yu'un ti judioetique yu'un ac'o ba sc'ambeic vocol ti Jesuse yu'un ac'o tal coltabatuc ti smozoe. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hech ibatic ti stojol ti Jesuse. Hech c'ot yalbeic vocol: ―Ja' lec mi chacolta ti capitan soldadoe. Ja' lec mi chac'uxubin. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yu'un c'ux chijya'yucutic jcotoltic. Laj yac' staq'uin hech imeltsaj ti templo cu'untutic li'to ―xchiic ti moletique, xut ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hech yu'un ti Jesuse laj xchi'in batel ti moletique. C'alal jutuc xa sc'an chc'otic ti bu sna ti capitan soldadoe, hech yu'un ti capitan soldadoe laj stac talel ti much'u lec chil sba xchi'uque yu'un ac'o tal spajes ti Jesuse. Hech hul yalbe: ―Tote, mu me xavac' avocol yu'un hech laj yalbun tal sc'op ti capitan soldadoe: “Mu'yuc tsots cabtel yu'un ja' chtal ti jna. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Hech yu'un muc chba jc'opon jtuc. Ja' no'ox ac'o yal tal smantal yu'un hech chcol o ti jmozoe. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yu'un ho'oni quich'oj mantal. Ti jpas ti mantal soldadoetic. Chcalbe ti june: Batan, chcut. Chbat. Chcalbe ti yane: La', chcut. Chtal. Chcalbe ti jmozoe: Paso li'to, chcut. Tspas, xchi ital sc'op” ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","C'alal laj ya'i ti Jesuse, nichim no'ox yo'nton yu'un ti hech laj yal tal ti capitan soldadoe. Ti Jesuse laj sjoyp'in sba, hech laj yalbe ti crixchanoetic te xchi'inoje: ―Chacalbeic, mu to bu jtaoj mi junuc hech ti jchi'iltique ti hech chch'un hech chaj c'u che'el chch'un ti capitan soldadoe ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ti much'utic tacbilic tale hech isutic batel ti sna ti capitan soldadoe. Lec xa oy c'ot staic ti smozo ti capitan soldadoe, ja' ti jchamele. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Patil ibat ti Jesuse ti jun muc'ta jteclum, Naín sbi. Laj xchi'in batel ti yajchanc'opetique xchi'uc ep yan crixchanoetic. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","C'alal ic'otic ti ti'macte'ton yu'un ti jteclume, te q'uechbil ital jun ánima. Jun no'ox yol ti antse, ja' ti q'uechbil tale. Ja' me'on ants. Ep xchi'il ti antse ja' ti much'utic te nacajtic ti jteclume. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","C'ux ti yo'nton ti Cajvaltique c'alal laj yil ti antse. Hech yu'un laj yalbe: ―Mu me xa'oc' ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Inopej batel ti Jesuse. Laj spicbe ti stenelte'e yo' bu cajal ti ánimae. Hech laj sva'an sbaic ti jcuch ánimaetique. Ti Jesuse hech laj yalbe ti ánimae: ―Querem, chacalbe, lican ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ti ora lic nacluc ti ánimae, lic c'opojuc. Ti Jesuse laj yic' tal yo' bu ti sme'e. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Toj xi'el ic'otic scotolic. Ilequilc'opojic yu'un ti Diose. Hech laj yalbe sbaic: ―Tsots yabtel staoj ti jchi'iltique. Ja' totil j'alc'op yu'un ti Diose ―xut sbaic. ―Tacbil tal yu'un ti Diose yu'un chiscoltaucutic, ho'ucutic ti t'ujbilucutic yu'une ―xut sbaic uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hech ipuc sc'opilal ti Jesuse ti scotol estado Judea xchi'uc ti sjoylejal ti xoconxocon ti Judeae. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ti yajchanc'opetic ti Juane ba xcholbeic ya'i ti Juane scotol ti c'usi yac'oj sba tspas ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Hech yu'un ti Juane laj yic' tal cha'vo' yajchanc'opetic. Hech laj yalbe: ―Ba jac'bo ti Jesuse: “¿Mi ho'ot ono'ox ti Cristoote ti sc'opilal chatale, mi ti jmalatutic yan?” xavut ―xchi ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hech yu'un c'alal italic ti stojol ti Jesuse, hech laj yalbeic: ―Tacbiluntutic tal yu'un ti Juane, ja' ti j'ac' ich'ho'e, yu'un oy c'usi sc'an chasjac'be. ¿Mi ho'ot ono'ox ti Cristoote ti ac'opilal chatale, mi ti jmalatutic yan? xchi ital sc'op ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ti Jesuse te yac'oj sba tscolta ep jchameletic c'ot staic. Tslamantasbe xchamel ti much'utic yaloj sba chin ti sbec'talique. Tsloq'uesbe pucujetic ti yo'ntonic yan, tsjambe satic yan. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hech yu'un itac'av ti Jesuse, hech laj yalbe: ―Ba albo ya'i ti Juane scotol ti c'usi avilojique, ti c'usi ava'yojique. “Chc'ot xa sat ma'satetic. Chanav xa mecanetic. Ichop xa xchamel ti much'u c'a'el ono'ox cha'yique. Cha'i xa c'op ti much'u maquem ono'ox xchiquinique. Icha'cuxi xa ánimaetic. Icholbatic xa ti lequil ach' c'ope ti me'onetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jun no'ox yutsil ti much'u mu xchibaj yo'nton ti jtojole, xchi ti Jesuse”, xavut ti Juane ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","C'alal isutic batel ti viniquetique ti itacatic talel yu'un ti Juane, hech yu'un lic yalbe ti crixchanoetique ti Jesuse, ja' sc'opilal ti Juane: ―Ti much'u ay aq'uelic te ti xocol balumile chana'ic ti ma'uc ti much'u chib ti c'usi tsnope hech chaj c'u che'el ti tsisan cotstique ti buc no'ox chjimat yu'un ti iq'ue. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Laj avilic ti ma'uc ti much'u tslap lec sc'u' spoc' ti c'alal na'ayique. Yu'un ti much'utic tslap lec sc'u' spoq'uique te nacajtic ti sna ajvaliletic. Mu'yuc palta cha'yic yu'un scotol oy yu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Laj ana'ic ti ja' j'alc'op yu'un Dios ti c'alal laj aq'uelique. Chacalbeic, jelaven sc'opilal stuc ti Juane ti laj aq'uelique, jutuc no'ox sc'opilal ti yan j'alc'opetic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ja' ti Juane ti hech ts'ibabil sc'opilale: Ja' chbaej avu'un ti j'alc'op ti jtac batele. Ja' tscajmeltsambe yo'ntonic yu'un hech chaxch'umbot ac'op, ti xchi ono'oxe. Ja' sc'opilal ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Chacalbeic, scotol ti much'u anem li' ti balumile mu'yuc much'u hech tsots yabtel yich'oj hech chaj c'u che'el ti Juane, ja' ti j'ac' ich'ho'e. Pero ti much'u ti chventaimbat yo'nton o yu'un ti Diose, manchuc mi mu'yuc tsots yabtel chich', ja' más ep bendición yich'oj. Ti Juane ja' muc xich' ep bendición ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yu'un scotol ti crixchanoetique xchi'uc ti jtsobpatanetic uque, c'alal laj ya'ibeic sc'op ti Juane, laj xch'unic ti toj ti smantal ti Diose, hech lic yich'ic ho' yu'un ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ja'uc ti fariseoetique xchi'uc ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique muc xich'ic ho' yu'un ti Juane, yu'un mu'yuc sc'opilal ti yo'ntonic ti hech smantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Hech laj yal uc ti Jesuse: ―Chacalbeic ac'opilalic c'u xa'elanic li' ti balumil ti ora to. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ho'oxuque hech chaj c'u che'el ololetic nacajtic ti plaza ti hech chalbeic ti xchi'iltaque: “Laj xa coq'uesantutic aj ava'yic, muc xa'ac'otajic”, x'utatic. Chtac'av ti xchi'iltaque: “C'alal ni'oc'tutic, ho'oxuque muc xavich'ic mul”, xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yu'un c'alal ital ti Juane, muc xaxchi'inoxuc ti ve'el. Hech lic avalic: “Oy pucuj ti yo'nton”, xachiic. Ja' sc'opilal ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","C'alal nital ho'oni ti co'ol crixchanoucutic uque, laj jchi'inoxuc ti ve'el. Hech lic avalic: “Q'uelo avil, scotol c'ac'al chve', chuch' vino. Lec tsc'opon sbaic xchi'uc jtsobpatanetic xchi'uc yan jp'ajmantaletic”, xachiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ti ja'uc laj yac'boxuc ap'ijilic ti Diose ti ja' jelaven sp'ijil stuque, hech laj apasucuntutic ti muc' ti hechuque. Hech laj ana'ic ti ac'biluntutic jp'ijiltutic yu'un ti Diose ti hechuque ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Oy jun fariseo laj yic' batel ti sna ti Jesuse yu'un te ba ve'uc xchi'uc. Hech i'och ti sna ti fariseoe ti Jesuse. Ti snaclebique vayebal x'elan. Te ba xup'an sbaic yu'un hech tsta sve'elic te ti mesa. Hech yu'un ti Jesuse te ba xup'an sba bu nopol mesa. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Oy jun jmulavil ants te ti jteclum. Ja' laj ya'i ti te chve' ti sna ti fariseoe ti Jesuse. Hech yu'un laj yich' tal perfume ti jarro. Pasbil ti alabastroton ti sjarroe. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ti antse c'ot va'luc ti spat ti Jesuse te nopol yacan. Lic oc'uc. Lic spocbe yacan ti Jesuse ti ya'lel sat. Lic scusbe ti stsotsil sjol. Laj sbuts'be yacan, laj smalbe ti yacan ti perfumee. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","C'alal laj sq'uel ti fariseoe, ja' ti much'u laj yic' ochel ti sna ti Jesuse, hech laj yal ti yo'nton: “Ti ja'uc bats'i j'alc'op yu'un ti Diose ti vinic li'to, sna' ti jmulavil ti ants li'to ti hechuque”, xchi ti yo'nton ti fariseoe. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ti Jesuse hech lic yalbe ti fariseoe: ―Simón, oy c'usi chacalbe ―xut. ―¿C'usi chavalbun? Maestro ―xchi xtac'av ti Simone. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hech lic yal ti Jesuse: ―Oy jun vinic ich'amumbat staq'uin. Hech yu'un oy cha'vo' viniquetic ich'amumbat yu'un ti staq'uine. Ti june ho'ob ciento denariotaq'uin laj xq'uex. Ti june lajuneb yoxvinic laj xq'uex. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mu'yuc staq'uinic hech yu'un mu xa xu' tsutes ti yilique, hech yu'un ich'aybat ti yilic yu'un ti yajval taq'uine. Hech yu'un ¿c'usi chanop? ¿Much'u lum c'ux ti yo'nton ti vinique? ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Itac'av ti Simone, hech laj yalbe: ―Ja' van ti much'u ep yil ich'aybate ―xchi. I'albat yu'un ti Jesuse: ―Melel ti c'usi chavale ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hech yu'un laj sjoyp'in sba ti Jesuse. Laj sq'uel ti antse. Hech lic yalbe ti Simone: ―Q'uelo ti ants li'to. C'alal ni'och ti ana, muc xavac'bun ho' yu'un ti jpoc cacan. Ti ants li'to laj spocbun cacan ti ya'lel sat. Laj scusbun ti stsotsil sjol. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ho'oti muc xabuts'un. Ti ants li'to muc spajes sba chisbuts'bun ti cacane asta c'alal nihul asta ti ora to chavil. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ho'oti muc xamalbun aceite ti jol. Ti ants li'to laj smalbun ti cacan ti perfumee. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hech yu'un chacalbe, manchuc mi ep smul ti antse, tana ch'ayem xa ti smule yu'un lum c'uxun chiya'i. Ti much'u jutuc no'ox smul laj jch'aybe tscuye, jutuc no'ox c'uxun chiya'i ―x'utat ti Simone. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ti Jesuse hech laj yalbe ti antse: ―Ch'ayem xa amul ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ti much'utic te xchi'inojic ti mesa ti Jesuse, hech laj yalbe sbaic: ―¿Much'u li'to ti xu' yu'un chch'ay mulil uc scuyoj sba? ―xut sbaic. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ti Jesuse hech laj yalbe ti antse: ―Yu'un oy xch'unojel avo'nton hech yu'un nacol xa. Junuc me avo'nton batan ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Patil ixanav batel ti Jesuse ti scotol jteclumetic xchi'uc coloniaetic. Yac'oj sba chchol ti lequil ach' c'ope, ja' ti tsc'an chisventaimbucutic co'ntontic ti Diose. Xchi'inoj batel ti lajchavo' yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Xchi'inoj uc cha'vo' oxvo' antsetic. Oy iloq'uesbat pucuj ti yo'ntonic yu'un ti Jesuse, oy ichop ti xchamele yu'un ti Jesuse. Ja' te xchi'inoj ti jun ants María sbi, ja' ti liquem tal ti jteclum Magdalae, ja' ti iloq'uesbat hucvo' pucuj ti yo'ntone. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Te xchi'inoj uc ti Juanae, ja' ti yajnil ti Chuzae. Ti Chuzae ja' yich'oj yabtel te ti sna ti ajvalile, ja' ti Herodese. Te xchi'inoj uc ti Susanae xchi'uc ep yan antsetic ti laj smac'linic ti Jesuse. Stuquic laj yaq'uic ti ve'elil ti antsetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ep no'ox laj stsob sbaic tal ti stojol ti Jesuse ti judioetique. Oy talemic ti jujun jteclum. Hech yu'un ti Jesuse lic yalbe lo'il. Oy sjam ti lo'il ti laj yale: ");
INSERT INTO tzoNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Oy much'u ba sts'un strigo. C'alal laj svaj ti strigoe, oy ic'ot sat strigo ti be. Ch-ech' teq'uilanatuc. Patil ital mutetic, tal stamic. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oy ic'ot sat strigo ti tontic. Ich'i jutuc, itaquij ti ora yu'un taquin ti lum te ti ba ton. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Oy ic'ot sat strigo ti ch'ixtic. C'alal ich'i ti ch'ixe, iquevtaat ti strigoe, hech muc xch'i. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Oy ic'ot sat strigo ti lequil lum. Lec ich'i. Lec laj yac' sat. Ho'vinic ti p'ej laj yac' sat ―xchi. C'alal hech laj yal ti Jesuse, tsots ic'opoj. Hech laj yal: ―Nopilanic lec hech chaj c'u che'el laj xa calboxuc ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Hech ijac'bat yu'un ti yajchanc'opetique: ―¿C'usi sjam ti lo'il ti hech laj avalbun jcotoltutique? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ti Jesuse hech laj yalbe: ―Ti ho'oxuque ac'biloxuc ana'ic ti c'u che'el tsventaimbe yo'ntonic crixchanoetic ti Diose. Mu to oyuc much'u yan hech ya'yojic hech chaj c'u che'el ti ho'oxuque. Ti yantique ja' no'ox cha'i ti lo'ile. Hovil ti chililanique, mu ono'ox xch'unic. Hovil ti cha'ilanique, mu ono'ox xc'ot ti yo'ntonic. Hech yu'un ti ja' no'ox chcalbe lo'il. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’A'yo me ava'yic c'usi sjam ti lo'ile ti laj calboxuque. Ti sat strigo ti vinique, ja' señail ti sc'op ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ti sat strigoe ti ic'ot ti bee ja' señail ti much'u cha'ibe sc'op ti Diose. C'alal laj ya'yique, mu'yuc sc'opilal ti yo'ntonic hech yu'un hech xu' laj sloq'ues ti pucuje, naca me xch'unic hech chcolic. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ti sat strigoe ti ic'ot ti bu tontique ja' señail ti much'u ti ora no'ox chch'un c'alal cha'ibe sc'op ti Diose. Nichim no'ox yo'nton yu'un laj xch'un. Mu'yuc yibil ya'yel. J'oc' no'ox te oy ti yo'nton. Muc xcom ti yo'nton. Mi chich' vocol, ti ora no'ox chchibaj yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ti sat strigoe ti ic'ot ti bu ch'ixtique ja' señail ti much'u batem ti yo'nton ti c'usi oy li' ti balumile, xchi'uc ti c'usi oy yu'une, xchi'uc ti c'usi lec cha'i ti sbec'talique. Hech muc satin ti sc'op ti Diose te ti yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ti sat strigoe ti ic'ot ti bu lequil lume ja' señail ti much'u lec cha'i ti sc'op ti Diose, jun yo'nton tsc'an chch'un. Hech yu'un j'ech'el chac' ti yo'nton ti sc'op ti Diose. Ja' chac' persa yu'un tsatin ti yo'nton ti sc'op ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Yu'un ti jtsantic jtojtic, mu yu'unuc ti jmactic ti poquet, mu yu'unuc chcac'tic ti yolon jvayebtic. Ja' yu'un chcac'tic ti xcuxabbil toj hech chac' squeval ti stojol scotol ti much'utic ch-ochic ti jnatique. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ja' no'ox hech scotol ti c'utic chajchanubtasoxuc atuquic ti ora to oy ti aventaic ti jamal chavalic ti yan c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Hech yu'un a'ibo sjam ti c'utic chacalbeique. Yu'un scotol ti much'u chch'un ti c'usi chcalbee ja' ch-ac'bat sna' yan. Ti much'u mu xch'un ti c'usi chcalbee mu'yuc xa c'usi ch-ac'bat sna' yan. Ti c'u yepal sna' tscuye ja' chpojbat ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ital ti sme' ti Jesuse xchi'uc ti yits'inabtaque. Yu'un te humajtic ti crixchanoetique te ti stojol ti Jesuse te ti yut na, mu spas tstaic ti c'oponel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oy much'u tal yalbe ti Jesuse: ―Te va'ajtic ti fuera ti ame'e xchi'uc ti avits'inabtaque. Sc'an chasc'oponot ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Itac'av ti Jesuse, hech laj yalbe: ―Ja' jme', ja' quits'inab c'otemic avi jayvo'ic li'to ti tspasic ti c'utic tsc'an ti Diose ti cha'yique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ti yan c'ac'al i'och ti barco ti Jesuse. Laj xchi'in ochel ti barco ti yajchanc'opetique. Hech lic yalbe: ―Batic ti jech nab ―xut. Hech ibatic. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","C'alal yac'oj sba chanavic batel ti ba nab xchi'uc ti barcoe, ivay ti Jesuse. Tsots ital ic'. Lic nicuc ti jyalel ti nabe, hech lic syuques sba, c'ot smaj sba ti barco hech its'itilan ochel ti ho'e ti yut barco asta i'epaj ti ho' te ti yut barco. Hech yu'un i'alub ti barcoe. Hech yu'un c'an ch'ayuc ochel ti yut ho'. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ti yajchanc'opetique laj stijic ti Jesuse. Hech laj yalbeic: ―Maestro, chijch'ay xa ti ho' ―xutic. Ilic ti Jesuse, laj spajes ti iq'ue xchi'uc ti nabe. Hech ipaj yu'un ti iq'ue xchi'uc ti nabe. Hech ilamaj scotol. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ti Jesuse hech laj yalbe: ―¿C'u sapas xchi'uc ti xch'unojel avo'ntonique? ¿C'u yu'un chaxi'ic? ―xut. Hech ich'ay yo'ntonic ti yajchanc'opetique. Hech laj yalbe sbaic: ―¿Much'u ti vinic li'to ti ich'umbat smantal yu'un ti iq'ue xchi'uc ti nabe? Ti ora no'ox ipaj yu'une ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hech ic'otic ti jteclum Gadara te ti jech nab. Te iloq'uic ti barco. Ti Galileae te icom ti jech nab yu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","C'alal j'oc' to no'ox chanav batel ti Jesuse, te laj snup ti be jun judio vinic loq'uem tal ti jteclum. Ep c'ac'al oy pucujetic ti yo'nton. Mu'yuc sc'u', mu'yuc sna. Ti bu chba ac'atuc ti ánimae ja' te snainoj. Yu'un ch'enetic jombil ti ton ti bu ch-ac'at ti ánimaetique te ti campo santo yu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","C'alal laj yil ti Jesuse ti vinique, tsots i'avan, tal spatan sba ti lum ti stojol ti Jesuse. Tsots ic'opoj, hech laj yalbe: ―Mu aventaucun, Jesús, ho'ot Snich'onot ti Diose ti te oy ti vinajele. Avocoluc mu me xavilbajinun ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ti c'alal lic spatan sba ti lum ti vinique, laj xa spas ti mantal ti pucujetique ti Jesuse. Laj xa yal ti ac'o loc'uc ti yo'nton ti vinique ti pucujetique. Yu'un oy xa ep c'ac'al ti hech i'ilbajinat yu'un. Ti vinique chchuquilanat ti cadenataq'uin yu'un mu me xmajvan. Ixojbat ti sc'ob ixojbat ti yacan yu'un hech ichucat. Manchuc mi pasbil ti taq'uin yu'un chchucat, laj stuch'ilan. Hech i'iq'uilanat batel ti xocol balumil yu'un ti pucujetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ti Jesuse hech lic sjac'be: ―¿C'usi abi? ―xut. Hech itac'av: ―Lejionun, yu'un epuntutic li' ochemuntutic ti yo'nton ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ti pucujetique laj yalbeic vocol ti Jesuse ti mu me xtacatic sutel te ti xab ti bu oyic ono'oxe, ti mu p'isbiluc snatile. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Te oy ep chitometic, te tsa' sve'elic te ti c'alc'alvits. Ti pucujetique laj yalbeic vocol ti Jesuse ti ac'o ac'atuc ochel ti yo'ntonic ti chitometique. ―Te batanic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ti pucujetique hech iloq'uic tal ti yo'nton ti vinique. Hech ba stic' sbaic ti yo'nton ti chitometique. Ti chitometique scotolic anil ba sten sbaic yalel ti ch'en hech i'ochic ti nab. Te laj sjiq'uic ho'. Te icham o scotol. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","C'alal laj yil ti jchabiejchitometique ti hech ic'ot ti pasele, ijatavic batel. Oy i'ochic batel ti jteclum, oy ibatic ti vits. Scotol ba xcholic ti c'u che'el ilecub ti vinique, ti c'u che'el icham ti xchitomique. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hech yu'un scotol ti judioetique tal sq'uelic ti c'usi ic'ot ti pasele. Te italic ti yo' bu oy ti Jesuse. Te laj yilic ti xchi'ile ti iloq'uesbat ep pucuj ti yo'ntone, te xa nacal ti bu nopol yacan ti Jesuse, slapoj xa sc'u' spoc', tsna' xa balumil. Ixi'ic yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Icholbat ya'yic yu'un ti much'utic laj yilique ti c'u che'el icoltaat ti xchi'ilique ti oy ono'ox pucujetic ti yo'ntone. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hech yu'un scotol ti judioetique ti te nacajtic ti Gadarae laj yalbeic vocol ti Jesuse yu'un ac'o loc'uc batel ti slumalic, yu'un ep ixi'ic. Hech yu'un laj stic' sba ti barco ti Jesuse, isut batel. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ti vinic ti iloq'uesbat ti pucujetic ti yo'ntone hech laj yalbe vocol ti Jesuse: ―Chajchi'in batel ―xut. Ti Jesuse laj stac sutel, hech laj yalbe batel: ");
INSERT INTO tzoNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Batan ti ana, ba cholbo ya'i ti avuts avalaltaque ti c'u che'el laj xa scoltaot ti Diose ―x'utat yu'un ti Jesuse. Hech ibat ti vinique, hech ba spuc te ti jteclum yu'une ti c'u che'el icoltaat yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","C'alal isut batel ti Jesuse, te chmalaat yu'un ep judioetic te ti jech nab. Nichim no'ox yo'ntonic ti crixchanoetique ti isut xa tale. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hech yu'un ital ti stojol ti Jesuse jun judio vinic, Jairo sbi. Ja' yabtel chal mantal te ti templo yu'unique. Tal spatan sba ti lum te ti stojol ti Jesuse. Laj yalbe vocol yu'un ac'o batuc ti sna. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yu'un chcham xa ti stsebe. Jun no'ox ti snich'one, ja' ti tsebe ti yich'oj lajcheb habile. Laj xch'un batel ti Jesuse. C'alal ixanav batel yu'un chbat ti sna ti Jairoe, inet'at ti Jesuse yu'un ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Te xchi'uc ti crixchanoetique jun ants. Lajcheb habil tsacbil ti chamel ti antse. Ch'ich' cha'i. I'ech' xa yo'nton ti poxtael yu'un ep jpoxtavanejetic. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hech yu'un ti antse inopej tal ti spat ti Jesuse. Tal stsacbe sba sc'u' ti Jesuse. Ti ora ichop xchamel ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Hech lic yal ti Jesuse: ―¿Much'u laj spicun? ―xchi. ―Mu ho'ucun ―xchiic scotolic. Hech yu'un ti Pedroe hech laj yalbe: ―Maestro, yu'un cacalot ti o'lol yu'un ti crixchanoetique, hech yu'un ja' chasnet'ot ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ti Jesuse hech laj yal: ―Oy much'u laj spicun yu'un laj ca'i ti iloc' jutuc ti jp'ijile ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hech yu'un c'alal laj yil ti antse ti laj xa sna' ti Jesuse ti hech laj spase, toj xi'el ic'ot. Hech yu'un tal spatan sba ti lum ti stojol ti Jesuse. Jamal laj yalbe ti c'usi sventail ti laj spique. ―Yu'un ti hech laj jpase, hech nicol avu'un ti ora ―xchi. Te yabinoj scotol ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ti Jesuse hech laj yalbe: ―Nich'on, colemot xa yu'un laj ach'un ti xu' cu'une. Jun avo'nton batan ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","C'alal yac'oj sba chc'opoj ti Jesuse, ti ora ihul jun vinic. Ja' te iloc' tal ti sna ti Jairoe, ja' ti oy yabtel te ti temploe. Hech hul yal: ―Icham xa ti anich'one. Mu xavac'be yan svocol ti Maestroe ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Laj ya'i ti Jesuse, hech lic yalbe ti Jairoe: ―Mu me xaxi'. Ch'uno ti chcol ti anich'one ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ti Jesuse ic'ot te ti sna ti Jairoe, ja' ti oy yabtel te ti temploe. I'och ti yut sna. Mu laj sc'an ti mi chchi'inat ochel ep, ja' no'ox stuc ti Pedroe xchi'uc ti Jacoboe xchi'uc ti Juane xchi'uc ti stot sme' ti tsebe. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Te oyic much'utic ch-oq'uic, xlaquetic no'ox. Ti Jesuse hech laj yalbe: ―Mu me xa'oq'uic. Mu chamenuc ti tsebe. Vayal no'ox ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yu'un ti hech laj yal ti Jesuse, ep ilabanat yu'un ti crixchanoetique yu'un laj sna'ic ti icham xa ti tsebe. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ti Jesuse laj stsacbe sc'ob ti tsebe, tsots ic'opoj, hech laj yalbe: ―Tseb, lican ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hech icuxi ti tsebe. Ti ora ilic. Laj yal mantal ti Jesuse ti ac'o ac'batuc sve'el. ");
INSERT INTO tzoNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ich'ay yo'ntonic ti stot sme' ti tsebe. Ti Jesuse laj spas ti mantal ti mu me much'u chalbe ti hech laj xa spase. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ti Jesuse laj yic' tal ti stojol ti lajchavo' yajchanc'opetique. Ja' i'ac'bat sp'ijilic yu'un tsloq'uesbeic pucujetic ti yo'nton ti crixchanoetique. Ja' i'ac'bat sp'ijilic uc yu'un chcol yu'unic scotol jchameletic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Itacatic batel yu'un ac'o ba xcholbe sc'opilal ti tsc'an chventaimbat yo'ntonic yu'un ti Diose, yu'un tscolta jchameletic uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Hech laj yalbe: ―Mu me xavich'ic batel c'usi chtun avu'unic ti be, mi anabte', mi anuti', mi ave'el, mi ataq'uin. Mu me xavich'ic batel cha'lic ac'u'. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ti na ti bu cha'ic'at ochele, te chacomic ja'to mi laj anop ti chaloc' batele. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ti bu jteclumal ti mu xayic'ot ochel ti sna mi junuc, c'alal chaloq'uic batel ti slumal, ta me xalilinic comel stanil avacanic. Ti stanil avacanique ja' señail ti icom ti sventaic yu'un muc xaspasoxuc ti muq'ue ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Hech iloq'uic batel. Xmelmun ixanavic batel ti scotol coloniaetic. Laj xcholbe ya'yic ti lequil ach' c'ope scotolic. Buc no'ox laj staic jchameletic laj scoltaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ti gobernador te ti Galileae, ja' ti Herodese, laj ya'i ti c'usi yac'oj sba spas ti Jesuse. Ep ilo'laj yo'nton yu'un oy much'u laj yalic: ―Ja' ti Juane icha'cuxi loq'uel ti ch'en ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Oy laj yalic: ―Ital xa ti Elíase ―xchiic. Oy laj yalic: ―Ja' jun j'alc'op ti vo'one icha'cuxi loq'uel ti ch'en ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ti Herodese hech laj yal: ―Ho'on laj jc'oc'be sjol ti Juane. ¿Much'u nixtoc ti lec sc'opilal yu'un scotol crixchanoetic? ―xchi. Hech yu'un tsc'an tsq'uel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","C'alal isutic tal ti jcholc'opetique ti itacatic batel yu'une, hul yalbeic ya'i ti Jesuse scotol ti c'utic ihu' yu'unic laj spasique. Ti Jesuse laj sq'uej sbaic batel xchi'uc. Laj yic' batel ti bu xocol balumil nopol xil sbaic xchi'uc ti jteclum Betsaidae. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","C'alal laj ya'yic ti crixchanoetique ti bu chbatique, te ba sa'ic asta laj staic. Ti Jesuse lec laj yil ti c'alal ic'otic ti crixchanoetique hech lic xcholbe ya'yic sc'opilal ti tsc'an chventaimbat yo'ntonic yu'un ti Diose. Laj scolta ti jchameletique. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","C'alal ich'ay xa ti c'ac'ale, ti lajchavo'ique hech lic yalbeic ti Jesuse: ―Taco batel ti jchi'iltique, ac'o batuc ti coloniaetic o parajeetic li' nopole. Ac'o ba xch'amun snaic, ac'o ba sman sve'elic yu'un xocol balumil li'to ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ti Jesuse hech laj yalbe: ―Ac'bo sve'elic ho'oxuque ―xut. Hech itac'avic: ―Ja' no'ox ho'ob muc'tic caxlan vaj xchi'uc cha'cot choy quich'ojtutic. O ¿mi yu'un ho'ontutic chba jmambetutic tal sve'elic? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Oy ho'mil viniquetic ti te stsoboj sbaique. Parte ti antsetique, parte ti ololetique. Hech yu'un ti Jesuse laj yalbe ti yajchanc'opetique: ―Ac'o yic' sbaic lajlajuneb yoxvinic ti vo' ti crixchanoetique. Hech ac'o nacluc ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hech laj yalic mantal ti yajchanc'opetique. Hech lic yic' sbaic lajlajuneb yoxvinic ti vo' ti crixchanoetique, hech inaquiic scotolic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ti Jesuse laj stsac ti ho'ob muc'tic caxlan vaje xchi'uc ti cha'cot choye. Laj sq'uel muel vinajel, hech lic yalbe vocol ti Diose. Laj xet'ilan ti caxlan vaje, laj stuch'ilan ti choye, laj yac'be ti yajchanc'opetique. Ti yajchanc'opetique ba yac'beic ti xchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Hech ive'ic scotolic. Ta yutsil inoj xch'utic o. Patil lic stsob ti xet'bile ti tuch'bile yu'un ti Cajvaltique. Icom to sobril lajcheb almud. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ti yan c'ac'al c'alal sq'uejoj sbaic batel xchi'uc ti yajchanc'opetique ti Jesuse, te tsc'opon Dios stuc ti Jesuse. Patil lic sjac'be ti yajchanc'opetique: ―¿Much'uun chiscuyun ti jchi'iltique? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hech itac'avic: ―Oy chalic ti ho'ot Juanot, ja' ti laj yac' ich'ho'e. Oy chalic ti Elíasot. Oy chalic ti ho'ot j'alc'opot ti vo'one ti icha'cuxi xae ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ti Jesuse laj sjac'be: ―Ti ho'oxuque, ¿much'uun chacuyic? ―xut. Itac'av ti Pedroe, hech laj yalbe: ―Ho'ot ti Cristoote, ho'ot t'ujbilot yu'un ti Diose yu'un chacoltauntutic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ti Jesuse hech laj spas ti mantal ti yajchanc'opetique: ―Mu me much'u chavalbeic ti ho'on Cristoune ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Hech laj yalbe uc: ―Persa ep chquich' vocol, ho'on ti co'ol crixchanoucutique. Mu xisc'anucun ti moletique xchi'uc ti totil paleetique xchi'uc ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Chismilucun, chicham, patil ti yoxibal c'ac'al chicha'cusesat loq'uel ti ch'en ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ti Jesuse hech laj yalbe scotol ti crixchanoetique: ―Ti much'u sc'an chists'acliune mu me xc'uxubin sba, ac'o sts'ic vocol jujun c'ac'al hech chaj c'u che'el sts'ic cu'un vocol ho'oni, ac'o sts'acliun. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yu'un scotol ti much'u chc'uxubin sbae ja' chch'ay. Scotol ti much'u mu xc'uxubin sbae ho'on ti jventa ja' chcuxi sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Manchuc mi ihu' avu'un laj avu'uninic scotol ti c'utic oy li' ti balumile, hovil. Ja' ch'ayel chabatic. Ja' no'ox chamil abaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yu'un scotol ti much'u chq'uexav yu'un chch'un ti jc'ope, hech ono'ox uc “ma'uc jnich'on lume”, xichi, ho'on ti co'ol crixchanoucutique, c'alal chital xchi'uc jqueval jtuc, chital xchi'uc squeval ti Jtot uque, jchi'inoj tal ti ch'ul abatetic yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Melel ti c'usi chacalbeique, ho'oxuc ti li' va'aloxuc li'to oy mu to chachamic ja'to mi laj xa avilic ti oy chlic ventaimbatuc yo'ntonic crixchanoetic yu'un ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","C'alal i'ech' xa vaxaquib c'ac'al laj yal hech ti Jesuse, laj yic' batel ti vits ti Pedroe xchi'uc ti Juane xchi'uc ti Jacoboe. Te ba sc'opon Dios. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","C'alal yac'oj sba tsc'opon Dios ti Jesuse, ijel ti sat ti Jesuse. Iquevan scotol sc'u'. Sac ti jyalel ic'ot. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ti ora ivinaj cha'vo' viniquetic te chlo'lajic xchi'uc ti Jesuse. Ja' ti Moisese xchi'uc ti Elíase. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Oy squevalic uc ti xcha'va'alique. Ti slo'ilic xchi'uc ti Jesuse ja' sc'opilal ti Jesuse ti c'u che'el chcham te ti Jerusalene, ja' ti c'u che'el yaloj ono'ox ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ti Pedroe xchi'uc ti xchi'ile samet no'ox cha'yic tsc'an chtal svayelic. Pero laj yaq'uic persa yu'un mu me x'och svayelic. Hech yu'un laj sq'uelbeic squeval ti Jesuse xchi'uc ti cha'vo' viniquetic ti te xchi'inoje. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","C'alal chbatic xa ti xcha'va'alique, ti Pedroe lic yalbe ti Jesuse: ―Maestro, ja' lec ti li'ucutic no'oxe. Ja' lec jpastic oxib nailvomol li'i, jun avu'un, jun yu'un ti Moisese, jun yu'un ti Elíase ―xut. Ti Pedroe mu laj sna' ti c'usi chal. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","C'alal yac'oj sba chc'opoj ti Pedroe, ital toc, imacatic scotolic. Ep ixi'ic yu'un ti c'alal imacatic yu'un ti toque. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Oy chc'opoj ti toc, ja' ti Diose. Hech laj yal: ―Ja' Jnich'on li'to. Ja' ti lum c'ux ti co'ntone. A'ibo sc'op ―xchi xc'opoj te ti toc. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","C'alal laj c'opojuc, stuc xa no'ox te oy ti Jesuse. Ti yajchanc'opetique ep c'ac'al mu'yuc much'u laj yalbe ya'yic ti hech laj yilic stuquique. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ti yoc'omal c'alal iyalic tal ti vits, te stsoboj sbaic ep judioetic c'ot staic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Te cacal ti o'lol ti xchi'iltaque jun vinic. Tsots lic c'opojuc. Hech laj yal: ―Maestro, avocoluc chaq'uelbun ti jnich'one. Jun no'ox ti jnich'one, mu'yuc yan. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ch-ilbajinat yu'un pucuj. Ti ora no'ox ch-avan. Chtup'bat yic' yu'un, hech chvocan ye, ep chich' vocol. J'oc' no'ox chlecub, chlic yan vuelta. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Laj calbe vocol ti avajchanc'opetique yu'un ac'o sloq'uesbucun. Muc xu' yu'unic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Itac'av ti Jesuse, hech laj yal: ―Mu'yuc xch'unojel avo'ntonic chquil. Boliben avo'ntonic ho'oxuc ti li'oyoxuc li' ti balumil ti ora to. Ep xa c'ac'al li' jchi'inojoxuque. Ep c'ac'al jts'icojboxuc sbolil avo'ntonic ―xut ti crixchanoetique―. Ic'o tal ti anich'one ―x'utat ti vinique, xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","C'alal yac'oj sba chnopej tal ti quereme, ip'ajesat ti lum yu'un ti pucuje, itup'bat yic' yu'un. Ti Jesuse laj spajes ti pucuje hech iloc' ti yo'nton ti quereme, hech icol ti quereme. Ti Jesuse laj yic' batel yo' bu ti stote. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Scotolic ich'ay yo'ntonic yu'un laj yilic ti jelaven sp'ijil ti Diose. C'alal ch'ayem to yo'ntonic ti crixchanoetique yu'un ti hech laj spas lequil abtel ti Jesuse, ti Jesuse hech lic yalbe ti yajchanc'opetique: ");
INSERT INTO tzoNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―A'yo me ava'yic ti lec ti c'usi chacalbeic ti ora to. Chc'ot ti pasel ti chi'ac'at entrecal ti sc'ob viniquetic, ho'on ti co'ol crixchanoucutique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Muc xa'ibeic sjam ti c'usi i'albatique. Muc x'ac'bat sna'ic hech muc xc'ot ti yo'ntonic. Ixi'ic yu'un tsjaq'uic c'usi sjam ti sc'ope ti c'u che'el i'albatique. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hech lic stsac sbaic ti c'op ti yajchanc'opetique: ―¿Much'u más totil chc'ot cu'untic? ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ti Jesuse laj sna' ti hech yac'oj sba tsnopic ti yo'ntonique, hech yu'un laj yic' tal ti stojol jun olol. Te laj sva'an ti sts'el. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Hech laj yalbe ti yajchanc'opetique: ―Scotol ti much'u tspas ti muc' avi olol li'to ho'on ti jventa, ho'on chispasun ti muc' uc. Scotol ti much'u chispasun ti muc' ja' tspas ti muc' uc ti Jtote ti ja' laj stacun talele. Ja' no'ox hech ti ho'oxuque ti much'u más biq'uit chac' sbae, ja' totil chc'ot avu'unic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ti Juane hech laj yalbe ti Jesuse: ―Maestro, oy much'u yac'oj sba tsloq'uesbe pucujetic ti yo'ntonic crixchanoetic ti aventa laj quiltutic. Hech yu'un laj jpajestutic yu'un ma'uc jchi'iltic ti abtel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Itac'av ti Jesuse, hech laj yal: ―Mu me xapajes. Yu'un ti much'u mu cajcontraticuque, ja' jchi'iltic obi ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","C'alal laj sta yorail c'alal po'ot xa ch-ic'at muel ti vinajel ti Jesuse, j'ech'el snopoj ti yo'nton ti chbat ti Jerusalén. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Oy much'u laj scajtac ech'el yu'un ac'o ba scajch'amun na ac'o xchapan ti bu chc'otique. Hech ibatic. Te ic'otic ti jun colonia yo' bu nacal samariaetic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Muc x'ac'bat xch'amun ti na yu'un ti samariaetique yu'un ya'yojic xa ti chbatic ti Jerusalén. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ti cha'vo' yajchanc'opetique, ja' ti Jacoboe xchi'uc ti Juane, c'alal laj yilic ti mu tabiluc ti nae, hech lic yalbe ti Jesuse: ―Cajval, ¿mi chac'an ti chcaltutic mantal yu'un ac'o yaluc tal c'oc' ti vinajel yu'un hech chtup'ic hech chaj c'u che'el laj spas ti Elíase? ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ti Jesuse laj sjoyp'in sba, hech laj staq'ui: ―Mu xana'ic much'u sventainojboxuc avo'ntonic yu'un ti hech chavalique. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yu'un ho'on ti co'ol crixchanoucutique ma'uc nital yu'un chcac' ch'ayel ac'o batuc ti crixchanoetique. Ja' nital yu'un tal jcolta ―xchi. Hech ibatic ti yan colonia. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","C'alal ixanavic batel ti be, hech lic yal jun vinic; laj yalbe ti Jesuse: ―Cajval, buc no'ox chabat chajchi'inot batel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ti Jesuse hech laj yalbe: ―Oy xch'en ti vete, oy stso'op ti mutetique. Ho'oni ti co'ol crixchanoucutique mu'yuc bu ti jtaan jba ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ti Jesuse lic yalbe ti june: ―Chi'inun batel ―xut. Itac'av: ―Cajval, coltaun batel. Chba jchi'in jtot. Ja'to mi ichame, ja'to chtal jchi'inot ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ti Jesuse hech laj yalbe: ―Ti much'utic jun to chamenic ya'yel yu'un mu sc'an chixch'umbun ti jc'ope, xu' tsmuc sbaic stuquic. Ho'oti batan, ba cholbo sc'opilal ti tsc'an chventaimbat yo'ntonic yu'un ti Diose ti crixchanoetique ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Oy yan hech laj yal: ―Chajchi'inot, Cajval. Ja' no'ox ac'un batel yu'un chba jc'opon comel scotol ti much'utic te ti jnae ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ti Jesuse hech laj yalbe: ―Mi mu junuc avo'nton chach'umbe smantal ti Diose, hechot hech chaj c'u che'el ti much'u chch'ayilan yo'nton c'alal tsvoc' osil. Mu xtun chbat ti yabtele yu'un mu teuc batem yo'nton. Ja' no'ox hech mi mu teuc batem avo'nton yu'un ti yabtel ti Diose, hech mu spas ti chaspasot ti mantal ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Patil laj st'uj yan setenta ti vo' ti Jesuse. Cha'cha'vo' laj scajtac jelavel ti jujun jteclum xchi'uc ti jujun coloniae. Patil te i'ech' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hech laj yalbe batel: ―Melel ti ep ti much'utic tsc'an cha'yic ti sc'op ti Diose. Mu epuc ti much'u tsc'an chcholbe. Hech chac c'u che'el mi ep ti c'ajoje, mu epuc ti much'u tsc'aje. Hech yu'un c'ambeic vocol ti Diose yu'un ja' Yajval ti abtele yu'un ac'o stac batel yan ti much'u chcholbat ti sc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Batanic, chajtacoxuc batel. Hech chaj c'u che'el ti carneroetic chc'ot sta ti bu coyoteetic, ja' hechoxuc ti ho'oxuque. Hech yu'un p'ijanic me. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mu me xavich'ic batel ataq'uinic, mu me xavich'ic batel uc ave'elic. Mu me xavich'ic batel yan asempat. Ti much'u chataic ti be mu me haluc chalo'laj xchi'uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ti buc no'ox nail ti bu cha'ochique jbael c'ambo bendición ti stojol scotol ti much'utic te oye. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mi tsc'an ti bendicione ti much'utic te nacale, chich'. Mi mu sc'ane, mu sta. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ti na ti bu cha'ic'at ochele te chacomic. Mu me xajelilan anaic. Chave'ic ti c'usi cha'ac'batique. Yu'un ti abate ti ch-abteje ja' ch-ac'bat sve'el. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Buc no'ox jteclumal cha'ochic, mi chayic'oxuc ochel ti snaique, ve'anic ti c'usi chayac'boxuque. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Coltao ti jchameletique ti te oyique. Hech chavalbeic: “Laj xa ava'yic ti c'u che'el tspasvan ti mantal ti Diose, laj xa avilic”, xavutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Buc no'ox jteclumal cha'ochic, mi mu xayic'oxuc ochel ti snaique, xanavanic batel ti calletic, hech chavalic batel: ");
INSERT INTO tzoNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ta me jlilintutic comel ti atojolic ti stanil cacantutique. Ja' señail ti icom ti aventaic yu'un muc xapasucuntutic ti muq'ue. Na'ic me, laj xa ava'yic ti tsc'an chasventaimboxuc avo'ntonic ti Diose”, xavutic comel. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Chacalbeic, ti c'alal tsta yorail ti chac' castigo ti Diose, ep chich'ic castigo ti much'utic nacajtic ti jteclum yo' bu chalilinic comel ti stanil ti avacanique. Ja' jutuc no'ox chich'ic castigo ti much'utic te nacajtic ti jteclum Sodoma ti vo'one. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ta me xich'ic vocol ti jchi'iltic ti te nacajtic ti jteclum Corazín. Ta me xich'ic vocol uc ti jchi'iltic ti te nacajtic ti jteclum Betsaida. Ti yanlum crixchanoetic ti te nacajtic ti vo'one ti jteclum Tiro xchi'uc ti jteclum Sidón, ti lajuc yilic ti jchop o abteletic hech chaj c'u che'el laj xa yilic ti jchi'iltic ti nacajtic ti ora to te ti Corazín xchi'uc ti Betsaidae, laj slapic coxtalpoc', laj sbon sbaic ti stanil c'oc' ti hechuque. Ja' señail ti tsutes yo'ntonic yu'un ti smulique. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hech yu'un ti yorail chchapambat sc'opilal yu'un smulic scotol crixchanoetic, yamal castigo chich'ic ti yanlum crixchanoetique ti te nacajtic ti Tiro xchi'uc ti Sidón ti vo'onee. Ja' tsots castigo chich'ic ti jchi'iltique ti te nacajtic ti Corazín xchi'uc ti Betsaida ti ora to. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ti jchi'iltic ti te nacajtic ti jteclum Capernaume tscuyic ti más ech'em ch-ac'bat bendición. Mu hechuc, ja' más ech'em ch-ac'batic castigo ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ti Jesuse hech lic yalbe ti yajchanc'opetique: ―Ti much'u chaspasboxuc ti muc' ti ac'ope ho'on chispasun ti muc' uc. Ti much'u mu xaspasoxuc ti muq'ue ho'on mu xispasun ti muc' uc. Ti much'u mu xispasun ti muq'ue ja' mu spas ti muc' uc ti Jtote ti laj stacun talele ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nichim no'ox yo'ntonic isutic tal ti setenta ti vo'ique. Hech hul yalbeic: ―Cajval, manchuc mi pucujetic, ho'ot ti aventa ch'umbil jmantaltutic yu'un ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Hech laj yalbe ti Jesuse: ―Hech chaj c'u che'el tselov ti chtil, ti ora no'ox chtup', ja' hech laj quil ilaj yip ti ora ti Satanase. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","A'yo me ava'yic, laj xa cac'boxuc ap'ijilic yu'un hech chatsalic scotol ti yabat ti cajcontratique, ja' ti más mañoso ti jyalele ti tsc'an ti ch'ayel chabatic xchi'uque. Hech chaj c'u che'el chajuyic ti teq'uel tsec xchi'uc chonetic, ja' hech tstsal avu'unic scotol ti cajcontratique. Mu'yuc c'usi xu' chaspasbot ti atojol. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mu me ja'uc nichim no'ox avo'ntonic yu'un ti ch'umbil amantalic yu'un ti pucujetique; ja' me nichim no'ox avo'ntonic yu'un ti p'ejambil abiic te ti vinajel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ti ora nichim no'ox yo'nton ti Jesuse ti sventa ti Ch'ul Espíritue, hech yu'un laj yalbe ti Diose: ―Tote, ho'ot ti ajvalilot yu'un ti vinajele ti balumile, hocol aval ti amacojbe yo'ntonic ti much'utic p'ij yo'ntonic ti scuyoj sbaique, ti much'utic cha'ibeic sjam ti scuyoj sbaique. Hocol aval ti avac'ojbe sna'ic ti much'utic tsc'anic coltael hech chaj c'u che'el tsc'anic coltael ololetic. Lec oy, Tote, yu'un hech avo'nton ti stojolic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Hech lic yalbe uc ti crixchanoetique: ―Scotol yac'ojbun ti jc'ob ti Jtote. Ho'on ti Snich'onune mu'yuc much'u chisna'bun ti co'ntone. Ja' no'ox stuc ti Jtote chisna'bun ti co'ntone. Mu'yuc much'u chna'bat yo'nton ti Jtote. Ja' no'ox jtuc ti Snich'onune ti jna'be yo'nton xchi'uc scotol ti much'utic chcac'be sna'beic yo'nton ti Jtote ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Parte laj sc'opon ti yajchanc'opetique, hech laj yalbe: ―Ho'oxuque yu'un laj xa yac'bot bendición ti Diose hech yu'un chavilic, hech yu'un chava'yic. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yu'un chacalbeic. Ep ti j'alc'opetic yu'un ti Diose xchi'uc ep ti ajvaliletique sc'an chilic uc ti c'usi chavilic ti ora to ti ho'oxuque, muc xilic. Sc'an cha'yic uc ti c'usi chava'yic ti ora to ti ho'oxuque, muc xa'yic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Te xchi'inoj sba xchi'uc jun vinic. Ja' chchanubtasvan ti smantal ti Diose ti scuyoj sbae. Hech lic sva'an sba, lic spasbe proval yo'nton ti Jesuse. Hech laj yalbe: ―Maestro, ¿c'usi chcut yu'un chicuxi sbatel osil? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ti Jesuse hech lic sjac'be: ―¿C'usi chal ti smantal ti Diose yu'un aq'ueloj? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Itac'av ti vinique, hech laj yalbe: ―“C'ux me xava'i ti Cajvaltic Diose, ja' ti Dios cu'untique, xchi'uc scotol avo'nton xchi'uc scotol avip xchi'uc scotol ap'ijil. C'ux me xava'i ti avecinoe hech chaj c'u che'el c'ux chava'i aba”, xchi ti smantal ti Diose ―xchi ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Itac'av ti Jesuse: ―Lec natac'av. Mi hech chapas, hech chacuxi sbatel osil ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yu'un tsc'an tscolta sba ti vinique, hech yu'un ti hech laj yalbe ti Jesuse: ―Yu'un ti hech chale, ¿much'u ti jvecinoe? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Itac'av ti Jesuse, hech laj yalbe: ―Oy jun jchi'iltic iloc' batel ti Jerusalén, iyal batel ti Jericó. C'alal te chanav batel ti be, laj snup ti be j'eleq'uetic. Hech ipojbat scotol ti c'utic oy yu'une. Imajat yu'unic, iyaj uc. Patil hech ibatic. Chamen x'elan icom yu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Te iyal tal ti be jun pale cu'untic. C'alal laj yil ti te metsel ti jchi'iltique, laj sjoy sbe ti palee, ijelav batel. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Patil ital ti be jun levita, ja' ti oy yabtel te ti templo uque. Ic'ot ti yo' bu metsel ti jchi'iltique. Laj sjoy sbe uc ti levitae, ijelav batel. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Patil ital ti be jun samariavinic. Ic'ot ti bu metsel ti jchi'iltique. C'alal laj sq'uel ti jchi'iltic ti te metsele, ic'uxubinvan ti samariavinique. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Inopej batel. Laj spoxtabe ti bu yajeme xchi'uc aceite xchi'uc vino. Laj smac ti poc'. Patil lic yac'be scajlebin ti sburroe, laj yic' batel ti bu ch-ac'at ti loq'uel na. Te laj xchabi. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ti yoc'omal c'alal chloc' batel ti samariavinique, laj sloq'ues chib denariotaq'uin, laj yac'be ti yajval nae. Hech laj yalbe comel: “Chabibun me ti vinique. C'alal chisut tal, scotol chajtojbot ti c'utic chlaj avu'une”, xut comel. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿C'usi chanop? Ti yoxva'alique ¿much'u laj yac' ti q'uelel ti ja' svecino ti jchi'iltic ti iyajesat comel yu'un ti j'eleq'uetique? ―x'utat ti vinique, xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Hech itac'av ti vinique: ―Ja' ti much'u ic'uxubinat yu'une ―xchi. Ti Jesuse hech laj yalbe: ―Ba c'uxubinvanan hech uc ho'oti ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ixanav batel ti be ti Jesuse. Te ic'ot ti jun colonia. Te i'ic'at ochel ti sna jun ants, Marta sbi ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Oy smuc ti Martae, María sbi. Ti Maríae tal snacan sba ti stojol ti Jesuse yu'un tsc'an cha'ibe sc'op. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ja'uc ti Martae ja' no'ox batem ti yo'nton tsc'an chmac'linvan. Hech lic tal sva'an sba ti stojol ti Jesuse, hech lic yal: ―Cajval, ¿mi mu'yuc sc'opilal ti avo'nton ti jtuc no'ox cac'oj jba ti jpas ti ve'elile? Yu'un ti jmuque jtuc no'ox chiyac'bun jpas scotol. Albo ac'o scoltaun ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Itac'av ti Jesuse, hech laj yalbe: ―Marta, scoj ti ep c'utic chapase, hech chlo'laj avo'nton yu'un. Hech mu nichimuc avo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Jun no'ox ti bu tsots sc'opilale. Ti Maríae laj xa st'uj ti bu tsots sc'opilale ti mu'yuc much'u chpojbat yu'un ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ti yan c'ac'al c'alal laj yo'nton laj sc'opon Dios ti Jesuse, hech i'albat yu'un ti jun yajchanc'ope: ―Cajval, chanubtasuntutic ti c'u che'el ti jc'opontutic Dios hech chaj c'u che'el laj xchanubtas ti yajchanc'opetique ti Juane ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ti Jesuse hech lic yalbe ya'yic: ―C'alal chac'oponic Dios, hech me xavalbeic: Jtotic Dios, te oyot ti vinajel, ac'o xajpasotutic ti muc'. Ac'o sta yorail chapas mantal atuc li' ti balumile. Ac'o c'otuc ti pasel li' ti balumile ti c'usi tsc'an ti avo'ntone hech chaj c'u che'el c'otem ti pasel ti vinajel. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ac'bun talel jve'eltutic c'ac'al li'to. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pasbuntutic perdón yu'un jmultutic hech chaj c'u che'el jpasojbetutic perdón much'u oy smul cu'untutic. Mu me xibatutic yo' bu chisujat ti mulil. Coltauntutic me, hech mu xistsaluntutic ti mulile, hech chavutic ti stojol ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Hech laj yalbe ya'yic uc: ―Mi hech chba avalbe jun avecino ti o'lol ac'ubal: “Tote, avocoluc jq'uextic chib oxibuc avot. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yu'un ja'to no'ox ihul jun jchi'iltic chcojtiquin. Ech' xch'amun jna yu'un chvay. Mu'yuc c'usi chcac'be sve'”, xavut. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Hech chtac'av te ti yut sna ti avecinoe: “Mu xu', macal xa ti jnae. Yu'un vayaluntutic xa. Mu xu' chilic yu'un chacac'bot”, xayut. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Chacalbeic, manchuc mi mu sc'an xayac'bot ti avecinoe, yu'un ti mu xlaj avo'nton chavalilambe vocol hech chlic yac'bot scotol ti c'utic chtun avu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hech yu'un chacalbeic. C'anilambeic ti Diose asta chayac'boxuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yu'un scotol ti much'u tsc'anilambee ja' ch-ac'bat. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Ho'oxuque mi chasc'ambe vaj yu'un tsve' ti anich'one, mu tonuc chavac'be. Mi chasc'ambe choy yu'un tsti', mu chonuc chavac'be. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mi chasc'ambe toncaxlan yu'un tslo', mu jcotuc tsec chavac'be. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ho'oxuque ti mu xtun ti avo'ntonique chana'ic c'usi lec chavac'beic ti anich'nabique. Ja'uc ti Jtotique ti te oy ti vinajele jelaven tsna'. Ja' chac'be ti Ch'ul Espíritue ti much'utic chc'ambat ti stojole ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Te oy jun vinic ti iloq'uesbat pucuj ti yo'nton yu'un ti Jesuse. Uma' ti vinique scoj ti ochem pucuj ti yo'nton. Hech yu'un c'alal iloc' ti pucuje ti yo'nton ic'opoj ti vinique. Ich'ay yo'ntonic ti crixchanoetique yu'un ti lic c'opojuc ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Oy much'utic laj yalic: ―Ja' tsloq'ues pucujetic ti sventa ti totil pucuje, ja' ti Satanase ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Oy yantic tsc'an tspasbeic proval yo'nton ti Jesuse, hech yu'un hech laj yalbe: ―Maestro, ti jc'antutic chavac'bun jq'ueltutic muc'ta señail yu'un hech ti jna'tutic ti tsots avabtel ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ti Jesuse laj sna' ti c'usi tsnopic ti yo'ntonique, hech yu'un laj yalbe: ―Mi tscontrain sbaic ti much'utic ochemic ti pas mantal ti jun no'ox gobiernoe, chjin ti gobiernoe. Mi tscontrain sbaic ti much'utic jun no'ox snaic, mu xcuxiic ep c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mi Satanás tscontrain ti Satanase, mu haluc tspas mantal. Hech chcal yu'un ho'oxuc chavalic ti ja' ti sventa Satanás ti jloq'ues ti pucujetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ti sventauc ti Satanás ti jloq'ues pucujetic ti ho'one ti chavalique, ¿much'u tsbiiltas c'alal tsloq'ues pucujetic ti avajchanc'opetique? Ho'oxuque mu xtojob avu'unic. Xu' chastojobtasoxuc ti avajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ja' ti sventa sp'ijil ti Diose ti jloq'ues ti pucujetique hech yu'un li' ti ora to tspas mantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Ti much'u c'oc' vinique mi lec xchapanoj sba xchi'uc stuc' yu'un chchabi ti snae, mu'yuc much'u xu' chpojbat ti c'usi oy yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mi chtal tsalatuc yu'un ti much'u ti más to c'oc' vinique, hech xu' chlic pojbatuc ti stuq'ue ti ja' yich'oj sba ti muc' xchi'uque, hech chbat scotol ti c'utic oy yu'une. Ti Satanase hech chaj c'u che'el ti c'oc' vinique. Pero laj xa jtsal ho'oni. Laj xa jpojbe ti sc'ob ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Ti much'u chopol chil ti cabtele ja' chiscontrainun obi. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Ho'oxuc ti li' nacaloxuc ti balumil ti ora to ti chopol avo'ntonique ja' hech chaj c'u che'el jun vinic ti oy pucuj ti yo'nton. Ti c'alal chloc' ti yo'nton chanav batel ti xocol balumil, tsa' bu chnaqui. Mu sta hech yu'un chal: “Chisut batel ti bu ono'ox niloc' talele”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","C'alal te chc'ot, mesbil xa, lec meltsambil, mu'yuc yajval chc'ot sta. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hech yu'un chba stsob tal hucvo' xchi'iltac, ja' ti much'u ech'em chopole. Te ch-ochic ti yo'nton ti vinique. Te chnaquiic o. Hech chcha'bolib nixtoc ti vinique. Ech'em chbolib ti jyalel ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","C'alal yac'oj sba chc'opoj ti Jesuse, te oy jun ants ti te tiq'uil ti o'lol ti crixchanoetique. Tsots lic c'opojuc ti antse, hech laj yalbe ti Jesuse: ―Jun no'ox yutsil ti ame'e ti hech laj slicote, ti laj yac'bot achu'e ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ti Jesuse hech laj yalbe: ―Mu hechuc. Ja' jun no'ox yutsil ti much'utic chac' ti yo'ntonic ti sc'op ti Diose ti cha'yique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","C'alal te yac'oj sba stsob sbaic tal más ti crixchanoetique, hech lic yal ti Jesuse: ―Chopol avo'ntonic ho'oxuc ti li'oyoxuc ti balumil ti ora to. Chac'an chaq'uelic señail ti jp'ijile. Mu'yuc c'usi yan cha'ac'bat aq'uelic. Ja' no'ox cha'ac'bat aq'uelic hech chaj c'u che'el ic'ot ti pasel yu'un ti Jonase, ja' ti j'alc'op yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Hech chaj c'u che'el laj sna'ic ti yanlum crixchanoetique ti te nacajtic ti Nínivee ti tacbil ibat yu'un ti Diose ti Jonase, hech ono'ox uc chlic ana'ic, ho'oxuc ti li'oyoxuc ti balumil ti ora to, ti ho'on tacbilun tal yu'un ti Diose, ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ti yanlum antse ti i'och ti ajvalil ti balumil te oy ti stojol sur mu'yuc xa smul ch-ilat yu'un ti Diose ti yorail ch-ich'bat sc'op yu'un smulic scotol crixchanoetic. Ja'uc ti ho'oxuque ti li' nacaloxuc ti balumil ti ora to ep amulic cha'ilatic. Yu'un ti antse nom tal ya'ibe sc'op ti Salomone yu'un lum p'ij ti Salomone. Ho'oni ti li' va'alun ti atojolic ti ora to, yu'un jelaven jp'ijil. Mu xac'an xapasucun ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ti yorail ch-ich'bat sc'op yu'un smulic scotol crixchanoetic mu'yuc xa smulic ch-ilat yu'un ti Diose ti much'utic te nacajtic ti jteclum Nínivee ti vo'one. Ja'uc ti ho'oxuque ti li' nacaloxuc ti balumil ti ora to ep amulic cha'ilatic. Yu'un ti c'alal icholbat ya'yic ti sc'op ti Diose yu'un ti Jonase ti much'utic te nacajtic ti Nínivee, laj sutes yo'ntonic yu'un smulic. Ti Jonase mu tsotsuc yabtel laj yich'. Ho'on más tsots cabtel quich'oj, ho'on ti li' va'alun ti atojolic ti ora to. Mu xac'an chapasbucun ti muc' ti jc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Mi atsanoj alámpara muc un chavac' ti ch'en ti yut lum. Muc un chavac' ti yolon almud. Te chavac' ti bu sjoc'ambil. Hech chac' squeval ti stojol scotol ti much'utic ch-ochic tal ti yut ana. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Hech yu'un mi mu'yuc yoboquil ti yespejoile, lec chac' squeval, hech chquiltic ti c'utic ti jpastique. Mi ep yoboquil ti yespejoile, mu xac' squeval. Hech ic'pulan ti yut jnatique, hech mu xquiltic ti c'utic ti jpastique. Ja' no'ox hech uc ti asatique. Mi lec chavilucun hech ch-och ti avo'ntonic ti jc'ope. Mi mu xtun chavilucun, mu x'och ti avo'ntonic ti jc'ope. Yu'un puru mulil oy ti avo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hech yu'un chabio me abaic, mu me xap'ajic ti jc'ope ti tsc'an ti ch-och ti avo'ntonique. Yu'un mi chap'ajic ti jc'ope, hech puru mulil oy ti avo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yu'un mi oy ti avo'ntonic ti jc'ope, mi mu'yuc bu chap'ajic ti jc'ope mi jutuc, hech puru lec te ti avo'ntonique. Mi jutuc mu'yuc mulil. Hech chaj c'u che'el ti lámpara ti chquevan no'ox ti atojolique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","C'alal laj yo'nton c'opojuc ti Jesuse, hech lic sc'ambe vocol ti Jesuse jun fariseo yu'un ac'o ba chi'inatuc ti ve'el. Hech ibat ti sna ti fariseoe ti Jesuse, te c'o nacluc ti mesa. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ti fariseoe ich'ay yo'nton yu'un ti mu haluc laj spoc sc'ob ti Jesuse ti c'alal ta xba nacluc ti mesa. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ti Cajvaltique hech lic yalbe: ―Ho'oxuc ti fariseooxuque ja' no'ox chapocbeic spat ti tazae ti platoe. Ti yute mu xapoc. Ho'oxuque hech chaj c'u che'el ti taza ti chcale. Ti avo'ntonique nojem ti sbic'tal avo'ntonique xchi'uc scotol ti c'usi chopole. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mu p'ijucoxuc. Ti much'u laj spas ti spate ja' laj spas uc ti yute. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ja' lec chac'uxubinvanic, chavac' ti motonil ti c'utic oy avu'unique, hech pocbiloxuc chac'otic ti mero melel. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Ho'oxuc ti fariseooxuque, ta me xavich'ic ep vocol. Chavati ti lajlajuneb scotol ti c'utic ats'unojique, ja' ti tunichime, xchi'uc ti rudae, xchi'uc scotol ti yan vomoletique. Jujun chaloq'uesic ti lajlajuneb yu'un chavac'beic smoton ti Diose. Yu'un ja' no'ox tsots sc'opilal chava'yic chavaq'uic ti c'utic oy avu'unique. Mu tsotsuc sc'opilal chava'yic ti toj avo'ntonique, ti c'ux chava'yic ti Diose. Ja' lec ti lajuc apas ti bu tsots sc'opilal uque. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Ho'oxuc ti fariseooxuque, ta me xavich'ic ep vocol yu'un ja' no'ox chac'anic ti chanaquiic ti sba naclebal te ti yut temploetique. Ja' no'ox chac'anic uc mi ep chac'oponat yu'un crixchanoetic te ti plaza. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Ho'oxuc hech chaj c'u che'el xch'enal ánima ti mu'yuc bu yich'oj señaile. Hech chaj c'u che'el chataic palta ti stojol ti Diose mi cha'ech'ic ti bu mucul ánima ja' no'ox hech tstaic palta avu'unic ti achi'iltaque ti stojol ti Diose ti scoj ti mi jutuc mu'yuc c'usi toj ti avo'ntonique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","―Maestro, yu'un ti hech chavale, jun to ho'on ti chavalbun jc'opilaltutic uc ―xchi liquel jun ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ti Jesuse hech laj yalbe: ―Ho'oxuc ti chachanubtasvanic ti smantal ti Diose ti acuyoj abaique, ta me xavich'ic ep vocol uc. Sjeluc chameltsambeic yicats ti crixchanoetique. Ol ti icatsile. Vocol ti cuchel. Chavac'be xcuchic. Atuquic mi jutuc mu xaliquic mu xacuchic. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Ta me xavich'ic ep vocol yu'un jtos avo'ntonic xchi'uc ti atatamolic ti vo'one. Yu'un ti ho'oxuque lec xa chapas abaic yu'un ho'oxuc chameltsambeic ti svolvoroal ti xch'en ti j'alc'opetic yu'un ti Diose, ja' ti imilatic yu'un ti atatamolique. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hech chavaq'uic ti q'uelel ti jtos avo'ntonic xchi'uc ti atatamolic ti vo'onee ti hech laj spasique. Stuquic laj smilic. Ho'oxuque chats'acubtasbe yabtel ti atatamolique. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Yu'un scotol sna'oj ti Diose hech yu'un laj yal: “Ti jtac talel ti stojolic j'alc'opetic xchi'uc jchanubtasvanejetic. Oy chlic smilic, oy chilbajinic”, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Hech yu'un ho'oxuc ti li'oyoxuc ti balumil ti ora to chcom ti aventaic ti imilat li' ti balumile scotol ti j'alc'opetique. Scotol chcom ti aventaic, ti Abele ti toj ti viniquile ti ja' imilat jbaele asta uc ti Zacaríase ti imilat te ti yut templo ti bu nopol scajaneb smoton ti Diose. Chacalbeic, scotol chcom ti aventaic, ho'oxuc ti li'oyoxuc ti balumil ti ora to. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Ho'oxuc ti chachanubtasvanic ti smantal ti Diose ti acuyoj abaique, ta me xavich'ic ep vocol yu'un laj xa abolibtasbeic yo'ntonic ti jchi'iltique. Ho'oxuc ti jbaejbeoxuc mu xac'an chach'unic, hech yu'un mu tojuc chavalic ti sc'op ti Diose. Hech yu'un chapajesic ti much'utic tsc'an chch'unique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","C'alal chloc' batel ti Jesuse, ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti fariseoetique, liquem sc'ac'al yo'ntonic hech yu'un ep ti c'usi lic sjac'beic ti Jesuse. Yu'un tsc'an tsujic yu'un ac'o c'opojuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yu'un mi mu sjamuc ti c'usi chal ti Jesuse, yu'un hech xu' tstabeic smul. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ti c'alal yac'oj sba chlo'laj xchi'uc ti fariseoetique ti Jesuse, laj stsob sbaic tal ti stojol ti Jesuse ep ti mil judioetic. Te humajtic ti crixchanoetique tsnet'ilan sbaic. Ti Jesuse jbael lic yalbe ti yajchanc'opetique: ―P'ijanic me. Mu xtun ti spumesbil xch'ut vaj yu'un ti fariseoetique. Jlo'lavanejetic yu'un toj yo'ntonic tscuy sbaic. Oy yip hech chaj c'u che'el spumesbil xch'ut vaj. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yu'un mi oy c'usi ti jmuctic ti co'ntontic ti ora to ja' chvinaj ti yan c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hech yu'un na'ic me ti scotol ti c'utic chavalic ti mu'yuc stue, ta ono'ox me xvinaj ti yan c'ac'al ti stojol ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Ho'oxuc ti lec chquil jbatique hech chacalbeic. Mu me ja'uc chaxi'ic ti crixchanoetique ti xu' chasmilote yu'un mu xu' chasmilbot ach'ulel. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Chacalbe ti much'u tsc'an ti chaxi'ique. Ti Diose ti xu' chasmilbot ti abec'tale xchi'uc ti ach'ulele te ti c'atimbac, ja' me xaxi'ic. Jamal chacalboxuc, xi'ic me. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Chana'ic ti lajuneb no'ox cobre stojol ti ho'cot biq'uit mutetique. Ti mutetique mi jcotuc mu xch'ay ti yo'nton ti Diose. Scotol chabibilic yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ti stsotsil ajolic uque scotol atabil. Hech yu'un mu me xaxi'ic. Ho'oxuque jelaven ac'opilalic; mu'yuc sc'opilal ti biq'uit mutetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Chacalbeic, scotol ti much'utic jamal chal ti stojol crixchanoetic ti chiyojtiquinune, ho'on ti co'ol crixchanoucutique, ja' no'ox hechun uc jamal chcal ti chcojtiquine te ti stojol ti Jtote xchi'uc ti stojol ti ch'ul abatetic yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Scotol ti much'utic “mu xcojtiquin” xchiic ja' jc'opilal, ja' no'ox hechun uc “mu xcojtiquin” chcut ti Jtote xchi'uc ti ch'ul abatetic yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Scotol ti much'u chopol chiyalbun jc'opilal, ho'on ti co'ol crixchanoucutique, ta to spasbatic perdón. Ja' no'ox ti much'u ti chopol chc'opoj yu'un ti Ch'ul Espíritue ja' mu xa spasbatic perdón. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’C'alal cha'ac'atic entrecal ti sc'obic te ti templo yu'unique, c'alal chc'ot sva'anoxuc ti stojol ti much'utic oy yabtelic yu'unique, mu me xacajnopilanic ti avo'ntonic c'usi chc'o avalic xchi'uc ti c'usi chatac'avique. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ti Ch'ul Espíritue chaxchanubtasot ti ora no'ox ti c'usi chavalique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Oy jun vinic te cacal ti o'lol crixchanoetic, hech lic yalbe ti Jesuse: ―Maestro, albo ti jbanquile ti ac'o xiyac'bun o'loluc ti jlumtutique xchi'uc ti c'utic te comen yu'un ti jtotutique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ti Jesuse hech lic yalbe: ―Tote, mu ochemucun ti juez avu'unic. Ma'uc cabtel yu'un chajchapanoxuc ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ti Jesuse hech lic yalbe ya'yic scotolic: ―P'ijanic me, mu me puru xbic'taj avo'ntonic yu'un ac'ulejalic. Yu'un ma'uc chacuxiic yu'un ti c'u yepal tstsob avu'unic li' ti balumile ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ti Jesuse hech lic yalbe lo'il. Hech laj yal: ―Oy to ono'ox jun vinic. Jc'ulej ti vinique. Lec laj yac' sat ti c'utic laj sts'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hech lic snop ti yo'nton: “¿C'usi chcut? Mu xa bu spas chcac' ti quixime”, xchi liquel ti yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Patil hech lic snop: “Ti jna' c'usi ti jpas. Ti jtuqui scotol ti snail quixime, ti jpas yan. Más muc' ti jpas yu'un te ti jq'uej scotol ti quixime xchi'uc scotol ti c'utic oy cu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mi laj xa jpas scotol hech, patil hech xu' chcal ti co'nton: Oy xa ep q'uejbil cu'un ti jve'ele yu'un ep habil. Hech yu'un ti jcux co'nton. C'usuc no'ox tsc'an ti co'ntone oy cu'un, xu' ti jve' xu' chcuch', hech nichim no'ox co'nton, xu' xichi ti co'nton”, xchi tsnop ti yo'nton ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","C'alal hech snopoj, hech i'albat yu'un ti Diose: “¡Ho'oti bolot! Ti ac'ubaltic tana to chajpojbot ach'ulel. Ti c'usi chapambil avu'une ¿much'u chavac'be yich' comel?” x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ja' hech sc'opilal ti much'u ja' no'ox tstsob sc'ulejal tsc'upin stuc. Mu'yuc sc'ulejal ti stojol ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ti Jesuse hech laj yalbe ti yajchanc'opetique: ―Hech chacalbeic. Mu me xlo'laj avo'ntonic yu'un ti c'u che'el chacuxiic li' ti balumile, yu'un ti c'usi chave'ique. Mu me xlo'laj avo'ntonic yu'un ti c'u che'el chata ac'u'ique. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ja' ti Diose laj yac'boxuc abec'talic, acuxlejalic. Hech yu'un chayac'boxuc uc ac'u'ic ave'elic. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Q'uelo avil ti joje. Mu x'avolajic, mu xc'ajovajic, mu stsobic sve'elic, mu'yuc snail sve'elic. Mac'limbilic yu'un ti Diose. Ti ho'oxuque jelaven pasbiloxuc ti muc'. Mu pasbiluc ti muc' lec ti mutetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hovil ti chlo'laj avo'ntonique, mu yu'unuc más hal chacuxi yu'un ti hech chapasique. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mu yu'unuc oy c'usi chc'ot ti pasel avu'un mi jutuc yu'un ti chlo'laj avo'ntonique. Hech yu'un hovil ti chlo'laj avo'ntonic yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Q'uelo avilic ti nichimetic ti yaxaltique c'u che'el chch'iic. Mu x'abtejic, mu xjalovajic. Chacalbeic, ti Salomone manchuc mi ep sc'ulejal stuc, muc xco'olaj ti sc'u'e hech chaj c'u che'el yutsil ti nichime. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ti vomole j'oc' no'ox li'oy ti balumile. Ti yox xa ti ora to patil ti yan chib oxib c'ac'al chtaquij, hech chtun yu'un chq'uixna orno bu chta'aj caxlan vaj. Manchuc mi j'oc' no'ox li'oy ti balumile t'ujum pasbil yu'un ti Diose ti vomole. Ti ho'oxuque jelaven chayac'boxuc ac'u'ic. Mu to chach'unic ti lec. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Hech yu'un mu me xlo'laj avo'ntonic. “¿C'u che'el chijve'ucutic? ¿C'usi chcuch'tic?” mu me xachiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hech chlo'laj yo'ntonic ti much'utic mu xojtiquinic ti Diose. Ti Jtotique scotol sna'oj ti c'usi chtun avu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mi toyol avo'ntonic yu'un chasventaimboxuc avo'ntonic ti Diose, hech yu'un scotol chayac'boxuc ti c'utic chtun avu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Ho'oxuc ti carnerooxuc cu'une, manchuc mi mu epucoxuc, mu me xaxi'ic. Ti Diose yutsil yo'nton laj xa yic'oxuc yu'un chapasic mantal xchi'uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chono ti c'utic oy avu'unique, coltaic ti me'onetique. Hech chnoj ti yav ac'ulejalique ti te ti vinajele. Ti yave mu sna' xlaj. Mu sna' xch'ay ti ac'ulejal te o yu'un mu x'och j'elec' te o. Mu xlaj ti chon uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yu'un ti bu oy ti ac'ulejalique, te chbat avo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Chapalucoxuc me, tilemucuc me ti ac'oq'uique. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Hechucoxuc me hech chaj c'u che'el ti abatetic ti tsmalaic tsut tal ti yajvalique yu'un i'ay ti q'uin sventa nupunel. C'alal chul c'opojuc, ora tsjambeic ti'na yu'un ac'o ochuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jun no'ox yutsil ti much'utic abatetic ti q'uelel satic chul taatuc yu'un ti yajvale c'alal chtal. Melel ti c'usi chacalbeique, chlic smac xch'ut ti yajvale, chlic yal mantal yu'un ac'o ba nacluc ti mesa ti yabate, chlic mac'linvanuc stuc ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mi ital ti c'alal mu to tsta o'lol ac'ubal, mi ital c'alal i'ech' o'lol ac'ubal, mi hech chul taatuc yu'un, jun no'ox yutsil chc'ot ti abatetic ti hech yo'ntonic tsmalaic ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Na'ic me, ti lajuc sna' ti yajval nae ti jayib ora ac'ubal chtal ti j'eleq'ue, muc xvay ti hechuque. Viq'uil sat hech muc xbat ti elc'anel ti c'utic oy ti sna ti hechuque. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Hech yu'un ti ho'oxuque chapalucoxuc me yu'un ti c'alal muc chamalaucun, ja' yorail chital, ho'on ti co'ol crixchanoucutique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ti Pedroe hech lic sjac'be: ―Cajval, ¿mi jtuctutic no'ox jc'opilaltutic ti yac'oj sba chavalbuntutic ti lo'il li'to, mi ja' sventa scotol yantic uc ti li'oyique? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ti Cajvaltique hech laj yalbe: ―Ti much'u p'ij yo'ntone ti jun yo'nton ch-abtej ti stojol ti yajvale, ja' ch-ac'bat sventain scotol ti much'utic te oy ti sna ti yajvale. Ja' tsventaimbe xch'aquel scotol ti ve'elile. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ja' chich' bendición yu'un ti hech yac'oj sba tspas c'alal chul taatuc yu'un ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Melel ti c'usi chacalbeique. Yu'un ti hech tspase ch-ac'bat sventain scotol ti c'utic oy yu'un ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero mi hech lic snop ti yo'nton ti abate: “Mu van chtal ti ora ti cajvale”, mi xchie, mi chlic yilbajin ti much'utic i'ac'bat sventaine, chlic xchi'in ti ve'el ti uch'pox ti much'utic lec chil sbaic xchi'uque, ");
INSERT INTO tzoNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","hech mu malabiluc yu'un ti c'usi ora chtal ti yajvale yu'un mu xch'un ti po'ot xa chtale. Ch'ayem ti yo'nton ti yajvale c'alal chul taatuc. Hech yu'un chpojbat yabtel yu'un mu junuc yo'nton ti stojol ti yajvale. Ja' chba xchi'in ti much'utic co'ol mu xch'unic mantal xchi'uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Ti abate ti laj sna' ti c'usi tsc'an yo'nton ti yajvale ti mu laj xchapan sbae, ti mu laj spas ti c'usi tsc'an ti yo'nton ti yajvale, ta me xich' ep castigo. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ti much'u mu laj sna' ti c'usi tsc'an yo'nton ti yajvale, ti mu laj sna' ti chich' castigo yu'un ti c'utic laj spasilane, ja' yamal chich' castigo. Yu'un ti i'ac'bat sp'ijil ep yu'un ti yajvale yu'un tsc'an ac'o abtejuc ep yu'un. Hech chaj c'u che'el mi chavac'beic yabtel jun achi'ilic yu'un chac'anic ti chascoltaoxuque. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Tal cac' tiluc c'oc' ya'yel li' ti balumile yu'un ti much'u chch'un ti tal jcolta, ja' chlecub. Ti much'u mu xch'un ti ho'on ti jcolta ja' tsoc. Taca hu'emuc xa ti cabtele, lec. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yan sba ti vocole ti ta to xquich'e. Taca c'otuc ti pasel ti ora, hech mu xa jnopilan. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Mi chacuyic ti tal jtojobtas ti balumile? Jamal chacalbeic, mu yu'unuc tal jtojobtas ti balumile, tal cac' yu'un tscontrain sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yu'un chc'ot ti pasel ti cha'tos chc'otic ti much'utic ti ho'vo' oyic ti snaique. Cha'vo' lec chiyilun, oxvo' mu xtun chiyilun, o oxvo' lec chiyilun, cha'vo' mu xtun chiyilun. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tal cac' yu'un tscontrain sbaic xchi'uc yol snich'onic xchi'uc yalibic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hech laj yalbe uc ti crixchanoetique: ―C'alal chaq'uelic ti chmu batel toc te ti smaleb c'ac'al, ti ora chavalic: “Chtal ho'”, xachiic. Melel chtal ti ho'e. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","C'alal chava'i ti chtal ti stojol sur ti iq'ue, hech chavalic: “C'ux c'ac'al chca'itic”, xachiic. Melel c'ux ti c'ac'ale. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jlo'lavanejoxuc. Chana' chaq'uelic señail ti vinajel xchi'uc señail ti balumil. Mu xana' xaq'uelic ti c'usi chc'ot xa ti pasel li' ti balumile ti ora to chacuyic. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿C'u yu'un mu xana'ic ti c'usi lec ti pasele? ");
INSERT INTO tzoNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Taca tojobuc avu'un ti c'usi lec ti pasele hech chapas. Mi oy ataoj amul ti stojol avermano, chba alequilc'opon ti ora. Mo'oje, quechel to amul ti stojol ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chacalbeic, mi mu hechuc chapasique, ts'acal chayac'bot atoj ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ti Jesuse ti c'alal te stsoboj sbaique, lic albatuc c'u x'elan imilat ti xchi'iltaque ti te nacajtic ti Galileae. Ja' ti imilatic yu'un ti Pilatoe te ti yut templo te ti Jerusalén ti c'alal yac'oj sba tsmilbeic ti smoton ti Diose yu'un chac'beic ti Diose. Te laj scap sbaic ti xch'ich'elique xchi'uc ti xch'ich'el ti smoton ti Diose ti trato chac'beique. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Itac'av ti Jesuse, hech laj sjac'be: ―¿Mi yu'un chacuyic ti ja' más ep smulic ti jchi'iltique ti imilatique, ja' ti nacajtic ti Galileae? ¿Mi yu'un chacuyic ti ja' mu'yuc smul ti yantique ti te nacajtic ti Galileae? ");
INSERT INTO tzoNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jamal chacalbeic mu hechuc. Co'ol ono'ox ch'ayel chabatic acotolic xchi'uc mi mu xasutes avo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ti vaxaclajunvo' ichamic ti c'alal ip'aj yal tal ti nae ti toyole te ti Siloee ti inet'atique, ¿mi yu'un chacuyic ti más ep smulic yu'un ti hech ichamique? ¿Mi yu'un chacuyic ti ja' mu'yuc smul ti yantique ti co'ol nacajtic xchi'uc te ti Jerusalene? ");
INSERT INTO tzoNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Chacalbeic mu hechuc. Co'ol ch'ayel chabatic acotolic xchi'uc mi mu xasutes avo'ntonic yu'un amulic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ti Jesuse laj yalbe ya'yic lo'il avi to. Ja' sjam ti mu j'ech'eluc chtenat loq'uel ti judioetique yu'un ti mu sc'an xch'umbat sc'op ti c'alal i'ay oxib habil li' ti balumile ti Jesuse. Ja' hech laj yal ti Jesuse: ―Oy jun vinic laj sts'un jtec' igote' yo' bu ts'umbil uvate' yu'une. Hech yu'un patil ba sq'uelilan ti igote'e ti bu sts'unoje mi chac' sate. Mu'yuc sat. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hech lic yalbe ti jchabiej uvate' yu'une: “A'yo me ava'i, yoxibal xa habil ti ora to ti chtal jq'uelilan mi oy sat avi igote' li'to. Asta ora mu'yuc sat. Hech yu'un ts'eto. Hovil ti smacoj ti balumile”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hech lic tac'avuc ti jchabiej uvate' yu'une: “Cajval, ac'o comuc xa junuc habil. Ti joc'be ti xoconxocone. Chcac'be sc'a'al. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ja' tsquitic mi mu xlic yac' sat. Mi mu xac' sat, xu' chlic ats'et”, xchi ti yaj'abtele ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ti Jesuse te chchanubtasvan ti yut templo ti sc'ac'alil chcux yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Te oy jun judio ants oy xa vaxaclajuneb habil jchamel ti antse. Ti antse isoquesbat sbaquel yu'un jun pucuj. Xt'int'un chanav ti antse. Mi jutuc mu xu' sva'an sba. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","C'alal laj yil ti antse ti Jesuse, laj yic' tal ti stojol, hech laj yalbe: ―Me'e, ichop xa ti achamele ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ti Jesuse laj yac' sc'ob laj yac'be ti sjol ti antse. Ti ora itojob ti sbaquele, lic yalbe ep vocol ti Diose yu'un ti ichope. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ti totil yu'un ti temploe i'ilin yu'un ti icoltavan ti Jesuse ti yorail chcux yo'ntonic. Hech yu'un laj yalbe ti xchi'iltaque: ―Oy vaquib c'ac'al sventa abtel. Ja' lec chatalic ti yan c'ac'al mi chac'anic coltael. Mu me xatalic ti yorail ti jcux co'ntontic ―xut ti xchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hech lic yal ti Cajvaltique: ―Jlo'lavanejoxuc. Jujunoxuc ti sc'ac'alil ti jcux co'ntontic ¿mi mu xacolta batel avacax aca' yu'un chba avac'be yuch' ho'? ");
INSERT INTO tzoNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ja'uc ti ants li'to ti ja' yelnich'on uc ti antiguo jtotic Abrahame, ti oy xa vaxaclajuneb habil ti chucbil yu'un ti Satanase, mu'yuc tsots sc'opilal ti avo'ntonic ti ac'o coluc manchuc mi ti sc'ac'alil ti jcux co'ntontic ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","C'alal hech laj yal ti Jesuse, iq'uexavic scotolic ti much'utic tscontrainic ti Jesuse. Ti crixchanoetique scotolic nichim no'ox yo'ntonic yu'un jelaven yutsil scotol yabtel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Hech yu'un ti Jesuse hech lic yalbe lo'il. Hech laj yalbe: ―Chacalbeic ti c'utic x'elan tspasvan ti mantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Oy yip ch-abtej hech chaj c'u che'el ti biq'uit sbec' mostazate' ti laj sts'un ti slum jun vinic ti ich'i hech muc'ta te' ic'ot. Ital mutetic, tal spas stso'op ti sc'ob ti te'e ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Oy yan lo'il laj yalbe uc ti Jesuse. Hech laj yalbe: ―Chacalbeic yan vuelta ti c'utic x'elan tspasvan ti mantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oy yip ch-abtej hech chaj c'u che'el ti jutuc ti spumesbil xch'ut vaje ti tspumesbe xch'ut ti vaquib cuartiya harina ti laj scap jun ants. Hech ipum xch'ut o ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ti Jesuse c'alal ixanav batel ti be yu'un chbat ti Jerusalén, ichanubtasvan ti scotol jteclumetic xchi'uc scotol coloniaetic ti butic i'ech'e. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Oy much'u lic sjac': ―Cajval, ¿mi atabil no'ox ti much'utic chcolique? ―xchi. Ti Jesuse hech laj yalbe: ");
INSERT INTO tzoNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Biq'uit ti ti'vinajele. Hech yu'un ac'o persa yu'un hech xu' cha'och. Yu'un chacalbeic, ep ti much'utic tsc'an ch-oche, mu xu' yu'unic yu'un ja' no'ox ch-och batel ti much'u tsbic'tajes sbae ―xchi―. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yu'un mi laj xa smac comel ti ti'nae ti yajval nae, mi patil chtal ava'an abaic ti amac', hech chlic ac'opon: “Cajval, jambuntutic ti ti'nae”, mi chavutique, hech chayalboxuc: “Mu xacojtiquinoxuc”, xayutoxuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hech chlic avalbeic: “Laj jchi'inot ti ve'el, laj achanubtasuntutic ti calletic cu'untutic”, chavutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hech chayalboxuc: “Laj xa calboxuc, mu xacojtiquinoxuc, xacutic. Batanic, mu xajc'anoxuc yu'un puru chopol ti c'utic chapasique”, xayutoxuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Te chavilic ti ochemic yo' bu tspas mantal ti Diose ti jtatamoltic ti vo'one, ja' ti Abrahame xchi'uc ti Isaaque xchi'uc ti Jacobe, xchi'uc scotol ti j'alc'opetic yu'un ti Diose. Ho'oxuque cha'oq'uic, te chavich'ic ep mul yu'un ti muc xu' cha'ochique. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yu'un ep yanlum crixchanoetic chtalic ti sjoylejal balumil. Te chc'ot xchi'inic ti Abrahame xchi'uc ti Isaaque xchi'uc ti Jacobe te yo' bu tspas mantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A'yo me ava'yic, ti much'utic hech tsnop ti yo'nton ho'on jbaejbeun, mi xchi tsnop, ja' patil ti yantique, mi xchi, ja' patil chc'otic lume. Ja' jbael chc'otic ti much'utic mu hechuc tsnopique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ti ora italic cha'vo' oxvo' ti fariseoetique. Hech tal yalbeic ti Jesuse: ―Batan, loc'an batel yu'un tsc'an chasmilot ti Herodese ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ti Jesuse hech laj yalbe: ―Ti Herodese mañoso hech chaj c'u che'el jcot vet. Batanic, ba albo: “Ta to la sloq'ues pucujetic, ta to la scolta jchameletic ti ora to xchi'uc oc'om. Cha'ej ta la sju'tes yabtel. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Persa ta to xanav batel ti ora to xchi'uc oc'om xchi'uc cha'ej, yu'un mu la stac' xcham ti yan parte ti much'u j'alc'op yu'un ti Diose. Persa la chcham te ti Jerusalén, xchi”, xavutic me ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Hech lic yal uc ti Jesuse: ―Ho'oxuc ti te oyoxuc te ti Jerusalene atalelic chamilic ti j'alc'opetic yu'un ti Diose. Chavac'beic ton ti much'utic itacatic tal ti atojolique. Ep vuelta laj jc'an chajtsoboxuc hech chaj c'u che'el tstsob yol ti yolon xic' jcot me'caxlan. Muc xac'anic. ");
INSERT INTO tzoNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","A'yo me ava'yic, ti ho'oxuque atuquic xa no'ox chaventain abaic. Mu xa teuc Dios ti atojolic. Chacalbeic, ja'to mi laj sta yorail ti hech chavalique: “Jun no'ox yutsil ti itacat xa tal ti jtojoltic yu'un ti Cajvaltic Diose”, mi xachiique, ja'to xu' chaq'uelbun jsat yan vuelta ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ti yorail chcux yo'ntonic ti judioetique i'ic'at ti ve'el ti Jesuse te ti sna ti jun totil fariseoe. Ti yan fariseoetique ti te talemic uque laj sq'uelilan ti jyalel ti c'utic tspas ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","C'alal i'och ti Jesuse, te va'al jun vinic c'o sta. Situben scotol svinquilel. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Hech yu'un ti Jesuse lic sjac'be ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti fariseoetique: ―¿Mi stac' ti jcoltatic jchameletic ti yorail ti jcux co'ntontic? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Muc xtac'avic. Hech yu'un ti Jesuse laj yic' tal ti stojol ti vinique, laj scolta, laj stac batel. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ti Jesuse hech lic sjac'be ti fariseoetique: ―Ti sc'ac'alil ti jcux co'ntontic mi chp'aj ti ch'en ti aca'e, ti avacaxe, ¿mi mu xba aloq'ues ti ora manchuc mi yorail ti jcux co'ntontic? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Muc xu' xtac'avic ti c'alal hech laj yale. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ti Jesuse laj yil ti ja' toyol yo'ntonic ti co'ol chnaquiic xchi'uc ti totile ti i'ic'van ti ve'ele. Hech yu'un hech lic yalbe lo'il: ");
INSERT INTO tzoNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Mi oy much'u chayic'ot ti q'uin yu'un oy much'u chnupun, mu me xba anacan aba ti ora ti sts'el ti totile ti ja' laj yic'ote. Repenta mi oy much'u más pasbil ti muc' ti ic'bil yu'un ti q'uin. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Hech yu'un hech chlic yalbot ti totile: “Loc'an yu'un ja' chnaqui ti jtotic li'to”, chayutot. Hech yu'un chlic q'uexavan ti c'alal chlic loc'an yu'un ja' te chba naclan ti bu mu'yuc xa sc'opilal ti yo'nton ti totile. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ti ho'ote, c'alal cha'ic'at ti ve'el, ba nacano aba ti slajeb naclebale. Hech yu'un ti c'alal chtal ti totil ti laj yic'ote, hech chlic yalbot: “Tote, la' li'i ti lequil naclebale”, chlic yutot. Hech chapasat ti muc' ti stojol scotol ti much'utic ti co'ol chanaquiic xchi'uc ti mesae. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yu'un scotol ti much'u chac' sba ti pasel ti muc', ja' chbic'tajesat. Ti much'u biq'uit chac' sbae ja' ch-ac'at ti pasel ti muc' ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ti Jesuse hech lic yalbe uc ti much'u i'ic'at ti ve'el yu'une: ―C'alal cha'ic'van ti ve'el, c'alal chapas q'uin, mu me ja'uc chavic' ti much'utic lec chac'opon abaic xchi'uque, xchi'uc ti anamtal'uts-alaltaque, xchi'uc ti avuts avalaltaque, xchi'uc ti avecinotaque ti jc'ulejique. Yu'un repenta chlic yic'ot ti ve'el uc, hech chaxq'uextabot ti ave'ele. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ti ho'ote, c'alal cha'ic'van ti ve'ele, ja' me xavic' ti much'utic me'onetic xchi'uc ti much'u tuncoe xchi'uc ti much'u mecane xchi'uc ti much'u ma'sate. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Hech chavich' bendición yu'un mu xu' tspaquic sutel. Ja' chavich' atojol c'alal co'ol chacha'cuxiic xchi'uc ti much'utic toj yo'ntonique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","C'alal laj ya'yic ti much'utic te chve'ic ti mesa xchi'uc ti Jesuse, oy jun hech lic yalbe ti Jesuse: ―Jun no'ox yutsil ti much'u te chc'o ve'uc yo' bu tspas mantal ti Diose ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ti Jesuse hech lic yalbe: ―Oy ono'ox jun vinic laj yac' ve'elil. Laj yalbe ep crixchanoetic yu'un ac'o tal ve'uc ti q'uin. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","C'alal meltsajem xa ti sve'ele, laj stac batel yabat. Hech laj yalbe batel: “Ba albo yu'un ac'o taluc ti much'utic calojbe xae yu'un meltsambil xa scotol”, xchi batel sc'op ti vinique. Hech c'ot yal ti yabate. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Scotolic lic smaquic ti c'op. Jun laj yal: “Oy jlum jmanoj. Persa jtuc chba jq'uel. Avocoluc pasbun perdón yu'un mu xu' chibat”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yan laj yal: “Jmanoj ho'choj jvacax. Chba jq'uel mi lec oy. Avocoluc pasbun perdón yu'un mu xu' chibat”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yan laj yal: “Ja'to no'ox ninupun hech yu'un mu xu' chibat”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Hech isut tal ti yabate. Hul xcholbe ya'i ti yajvale ti c'utic laj yalic jujun. I'ilin ti yajval ve'elile. Hech lic yalbe ti yabate: “Batan ti ora ti plaza xchi'uc ti calletic li' ti jteclume. Ic'o talel ti me'onetique xchi'uc ti much'utic sicuben yoc sc'obe xchi'uc ti mecanetique xchi'uc ti ma'satetique”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","C'alal laj xa xch'umbe smantal ti yajvale, patil hech tal yalbe: “Cajval, laj xa jch'un scotol ti amantale. Ital xa cu'un, pero oy to mu'yuc yajval ti ve'elile”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ti vinique laj yalbe ti yabate: “Batan, xanavan batel ti bebetic xchi'uc ti sbelal chobtic, ic'o talel ti persa yantic yu'un hech chnoj ti jnae. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yu'un chacalbe, scotol ti much'u laj calbe ti chtal ve'uque, mi junuc mu xa xcac'be spas proval c'u ya'yel ti jve'ele”, xchi ti yajval ve'elile ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ti c'alal yac'oj sba chanav batel ti Jesuse te ts'aclimbil yu'un ep crixchanoetic. Ti Jesuse laj sjoyp'in sba hech lic sc'opon: ");
INSERT INTO tzoNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Ti much'u sc'an chists'acliune ja' tsc'an ti ho'on más tsots sc'opilal ti c'ux chiya'yune. Ja' tsc'an ti ja' yamal c'ux cha'i ti stot sme'e, xchi'uc ti yajnile, xchi'uc ti xnich'nabe, xchi'uc ti sbanquiltaque, xchi'uc ti yits'inabe, xchi'uc ti svixobtaque, xchi'uc ti yixleltaque. Ja' tsc'an uc ti mu tsotsuc sc'opilal ti yo'nton ti c'u che'el chcuxi li' ti balumile. Hech xu' chists'aclinucun. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ti much'u tsc'an chists'acliune mi mu sc'an chich' vocol hech chaj c'u che'el chquich' vocol ho'oni, ja' mu xu' chists'aclinun. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ti c'alal chac'an chapas muc' ana, chanop jbael c'u yepal chlaj ataq'uin ti scotol. Chanop uc mi xu' avu'un chapas hech stoylejal. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yu'un mi muc xanop lec jbael, hech yu'un c'alal laj xa aliques ti ton xchi'uc ti cementoe, hech chlic quechajuc avu'un. Hech chlic slabanot scotol ti much'u tsq'uelic. Hech chlic yalic: ");
INSERT INTO tzoNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Avi vinic li'to laj sliques sna. Q'uelo avil muc xu' yu'un”, xchi ac'opilal. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mi oy jun ajvalil chba spas pleito xchi'uc yan ajvalil, ja' jbael tsnop mi tstsal yu'unic xchi'uc ti lajunmil yajsoldadoe ti jtob ti mil yajsoldado ti yajcontrae. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mi mu xu' yu'un cha'i, c'alal nom to chtal ti yane, tstac batel yabat yu'un ac'o ba slequilc'opon yu'un ac'o lajuc yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hech ono'ox uc, ja' tsc'an ti chanopic mi xu' avu'unic chacomes scotol ti c'utic oy avu'unique, hech xu' chats'aclinucun. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Lec chtun ti ats'ame. Mi mu xa chi'uc ti ats'ame, mu xtun obi yu'un mu stac' chcha'chi'ub nixtoc. ");
INSERT INTO tzoNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ti chi'uc toe, chtun sventa ve'elil, chtun uc yu'un sventa sc'a'al balumil. Xu' ti jcaptic xchi'uc tso' vacax. Yu'un mu xa chi'uc, mu'yuc xa stu cu'untic manchuc mi sc'a'al balumil. Ti jtentic batel o. Ja' no'ox hech ti much'u tsc'an chists'aclinune, mi mu j'ech'eluc chixch'unun, mu'yuc stu cu'un o. Nopilanic lec hech chaj c'u che'el laj xa calboxuc ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Laj stsob sbaic tal ti stojol ti Jesuse ep ti much'utic puquemic sc'opilalic ti tsa' smulique xchi'uc ti jtsobpatanetique ti chlo'lavanique. Sc'an cha'ibeic sc'op ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mu xtun laj yilic ti fariseoetique xchi'uc ti much'utic ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Hech lic yalic: ―Ti vinic li'to chic' ti stojol much'utic c'uc no'ox tspas. Ma'uc no'ox chic' ti stojol, chchi'in ti ve'el uc ―xchiic. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hech yu'un ti Jesuse laj yalbe lo'il. Hech laj yal: ");
INSERT INTO tzoNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―¿C'usi xchi avo'ntonic? Mi oy avu'un ho'vinic ti cot acarnero, mi ich'ay comel avu'un jcot, ¿mi mu xalaman comel ti yan balunlajuneb yo'vinic ti cote ti bu oy sve'ele yu'un persa chba asa' tal ti jcot ti ch'ayem avu'une? ");
INSERT INTO tzoNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","C'alal mi laj ata xae, nichim no'ox avo'nton chacajan ti anequeb, chacuch talel. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","C'alal chahul ti ana, chavic' tal ti avuts avalaltaque xchi'uc ti avecinotaque, hech chavalbe: “Nichimuc me avo'ntonic yu'un laj xa jta ti jcot carneroe ti ich'ay cu'une”, xavut. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ja' no'ox hech uc “ti jnich'one ti jun yo'ntonic ti jtojol ti c'u yepale mi chch'ay junuc chquich' mul. Hech yu'un mi isut talel ti jun ti ich'ay batele, nichim no'ox co'nton yu'un ti isut xa tal ti jtojole xchi'uc ti ch'ul abatetic cu'une”, xchi ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Mi oy jun ants ti oy yu'un lajuneb peso bats'i taq'uin, mi chch'ay yu'un jun, ¿mi mu stsan stoj chlic smes sna yu'un tsa' ti jyalel ti jun peso ti ich'ay yu'une? Ja'to mi laj stae, ja'to chlaj yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mi laj stae, chic' tal ti yuts yalaltaque xchi'uc ti svecinotaque, hech chalbe: “Nichimuc me avo'ntonic yu'un laj xa jta ti jun peso ti ich'ay cu'une”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Chacalbeic, ja' no'ox hech uc ti Diose nichim no'ox yo'nton xchi'uc ti ch'ul abatetic yu'une mi chcha'sut tal ti stojol ti snich'one ti ich'ay ti bee ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ti Jesuse hech laj yalbe uc: ―Oy jun vinic oy cha'vo' xnich'nab. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ti its'inale hech laj yalbe ti stote: “Tote, ac'bun scotol ti c'u yepal anopoj chavac'bune ho'on ti its'inalune”, xut. Hech yu'un ti stote lic xch'acbe jujun ti snich'one ti c'u yepal tsc'an chac'bee. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","C'alal i'ech' chib oxib c'ac'al, patil ti its'inale lic stsob scotol ti c'usi oy yu'une, hech yu'un iloc' batel, ibat ti yan balumil. Te c'ot yixtan scotol ti c'utic oy yu'une yu'un te ibat yo'nton ti c'uc no'ox muliletic. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","C'alal laj xa yixtan scotol ti staq'uine, ital ep vi'nal ti balumil ti bu nacale. Hech itsacat ti vi'nal uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hech yu'un ba xchon sba ti stojol jun vinic ti te nopol nacale. Hech yu'un hech lic pasatuc ti mantal yu'un ti yajvale yu'un ac'o ba chabibatuc xchitom ti yan srancho. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yu'un yan sba vi'nal cha'i ti unen vinique, hech yu'un c'an sve' ti patcheneq'ue, ja' ti sve'el ti chitometique, yu'un hech chnoj xch'ut. Yu'un mi jutuc muc x'ac'bat sve'el yu'un ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","C'alal oy svocol ti vi'nale, hech lic sutes yo'nton: “Oy ep smozotac ti jtote. Scotolic nojem xch'utic. Ti ho'one li' chicham ti vi'nale. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Hech yu'un ja' más lec chisut batel, chba jc'opon ti jtote. Hech chc'o calbe: Tote, laj xa jta jmul ti stojol ti Diose. Laj xa jta jmul ti atojol uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mu xa spas ti anich'on chic'ot. Ja' lec amozo chic'ot xa avu'un, xc'o cut”, xchi tsnop ti yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hech yu'un isut batel, ibat ti stojol ti stote. ’C'alal nom to chtal, i'ilat yu'un ti stote. Hech yu'un ti totile ti c'alal laj yil ti chtal ti snich'one, yu'un nichim no'ox yo'nton yu'un, hech yu'un anil ba sta c'alal nom to xtal. Yu'un ep c'ux ti yo'nton ti snich'one, laj smey, laj sbuts'. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Hech i'albat yu'un ti snich'one: “Tote, laj xa jta jmul ti stojol ti Diose. Laj xa jta jmul ti atojol uc. Mu xa spas ti anich'on chic'ot”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yu'un ti hech i'albat yu'un ti snich'one, mu hechuc tsnop ti totile. Hech lic yalbe ti ora ti smozotaque: “Ich'o tal ti ora c'u'il ti jun no'ox yutsile, ac'bo slap. Ac'bo xoj sc'ob uc xchi'uc sempat. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ic'o tal ti unen vacaxe ja' ti jup'en xa cu'untique. Milic ti ora yu'un ti jti'tic. Yu'un ti jpastic q'uin. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yu'un laj jcuy ti chamen ti jnich'one. Ti ora to icha'cuxi xa ya'yel. Ch'ayem ono'ox. Ti ora to laj xa jta”, xchi. Hech lic spasic q'uin. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’C'alal ital ti its'inale, mu teuc ti banquilale. Yac'oj sba ch-abtej ti bu ti xchobic xchi'uc ti stote. Hech yu'un c'alal ital ti sna, c'alal nopol xa ti snae, laj ya'i ti yac'oj sba tspas q'uin ti stote. Laj ya'i yac'oj sba ch-ac'otajic. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Lic yic' jun smozo yu'un tsjac'be c'usi sventail ti q'uine. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hech i'albat: “Ital xa ti avits'ine. Hech yu'un ti atote laj xa smil ti unen vacaxe, ja' ti jup'en xa cu'untique, yu'un lec isut tal ti avits'ine”, x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","C'alal hech laj ya'i, i'ilin ti banquilale. Muc sc'an ch-och ti sna. C'alal laj ya'i ti stote, hech iloc' tal, tal yalbe vocol yu'un ac'o ochuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Itac'av ti banquilale, hech laj yalbe ti stote: “Ep xa habil ni'abtej avu'un. Ho'oni, mi jutuc muc jp'aj amantal. Mi jutuc mu'yuc c'usi avac'ojbun mi jcotuc chivo yu'un ti jpas q'uin xchi'uc ti much'utic lec ti jc'opon jba xchi'uque. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ja'uque ti ora no'ox laj amil ti unen vacaxe ti jup'en xa cu'untique yu'un chapasbe sq'uinal c'alal ihul ti anich'on lume ti laj xa yixtambot scotol ti c'usi laj avac'bee, ja' ti ep jmulavil antsetic laj xa yajniline. Ja' c'ux ti avo'nton”, xut ti stote. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Hech yu'un hech itac'av ti stote, hech lic yalbe: “Nich'on, ho'oti scotol ora jchi'inoj jbatic. Scotol ti c'usi oy cu'une, ja' avu'un uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ja' lec ti jpastic q'uin. Ja' lec ti nichim no'ox co'ntontic yu'un icha'cuxi xa ya'yel ti avits'ine ti chamen laj jcuytique. Ch'ayem ono'ox pero laj xa jtatic”, xut ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ti Jesuse hech laj yalbe yan lo'il ti yajchanc'opetique: ―Oy jun vinic, jc'ulej. Oy jun yaj'abtel ja' yac'ojbe sventain scotol ti c'utic oy yu'une xchi'uc staq'uin. Ti j'abtele ja' ba tic'batuc smul ti stojol ti yajvale. Ja' ti smul ti itic'bate yu'un laj yixtambe ti c'usitic yu'un ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hech yu'un ti yajvale laj yic' tal yu'un tsc'opon: “Melel ti ac'opilal ti laj xa ca'i, hech yu'un chavac'bun entrecal scotol ti c'utic aventainoje yu'un mu xa xu' chacom ti caj'abtel”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ti j'abtele hech lic snop ti yo'nton: “¿C'usi chcut jba yu'un chiloc' ti abtel yu'un ti cajvale? Mu xu' cu'un chi'abtej ti balumil. Chiq'uexav mi ti jc'an paramote. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ti jna' c'usi chcut jba yu'un c'alal chiloc' ti abtel yu'un hech xu' chixc'uxubinun yantic”, xchi ti yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hech yu'un jujun laj yic' tal ti much'utic oy yilic ti stojol ti yajvale. Hech laj sjac'be ti primero itale: “¿C'u yepal avil yu'un ti cajvale?” xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Hech itac'av: “Ho'vinic tambor aceite ti quile”, xchi. Ti much'u sventainoje hech lic yalbe: “Tuch'o ti sunal ti avile. Naclan, ts'ibao yan. Lajuneb yoxvinic no'ox chap'ejan”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Lic sjac'be yan: “Ti ho'ote ¿c'u yepal avil?” xut. Hech itac'av: “Ho'vinic almud trigo”, xchi. Ti much'u sventainoje hech lic yalbe: “Tuch'o ti sunal ti avile, ts'ibao yan. Chanvinic no'ox chap'ejan”, xut ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hech lic yalbe uc ti yajchanc'opetique ti Jesuse: ―“P'ij ti vinic lume, laj sna' ti c'usi chut sbae yu'un hech xu' chich' c'uxubinel yu'un ti yantique”, xchi sc'opilal yu'un ti yajvale manchuc mi mu tojuc ti c'usi laj spase. Ja' hechic ti much'utic batem yo'ntonic lec ch-ech'ic li' ti balumile, ja' tsots sc'opilal cha'i ti lec ch-ilatic yu'un ti xchi'iltac li' ti balumile. Ja'uc ti much'utic p'ijuben ti sventa ti Diose mu tsotsuc sc'opilal cha'i ti lec ch-ilatic yu'un ti crixchanoetique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Ti crixchanoetique ja' chtun yu'unic ti c'utic oy yu'unic li' ti balumile yu'un tspasic ti c'usi chopole. Ti ho'oxuque hech chacalbeic, ti c'usi oy avu'unic li' ti balumile ac'o tunuc avu'unic yu'un chacoltaic ti crixchanoetique. Hech tsc'an ti Diose. Hech yu'un c'alal mi nachamique, nichim no'ox yo'nton ti Diose chayic'oxuc ochel ti vinajel. “Lequil abatot”, xayutoxuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Ti much'u jun yo'nton tsventain ti bu mu tsotsuc sc'opilale, ja' no'ox hech uc jun yo'nton tsventain ti bu tsots sc'opilale. Ja'uc ti much'u mu junuc yo'nton tsventain ti bu mu tsotsuc sc'opilale, ja' no'ox hech uc mu junuc yo'nton tsventain ti bu tsots sc'opilale. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hech yu'un mi mu junuc avo'ntonic chaventainic ti c'utic oy avu'unic li' ti balumile yu'un hech chapasic ti c'usi leque, hech mu xu' chayac'boxuc aventainic ti Diose ti ja' sventa sbatel osile ti ja' tsots sc'opilale. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ti c'usi oy avu'unic li' ti balumile laj xa yac'boxuc ach'amunic ti Diose. Hech yu'un mi mu xavac' tunuc ti c'utic laj xa yac'boxuc ach'amunique yu'un chapasic ti c'usi leque, mu xa xu' chavich'ic ti ja' sventa sbatel osile. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Mu xtun mi oy cha'vo' avajval. Ti june chavilinta. Ti yane ja' chac'uxubin. Jun no'ox avo'nton ti stojol ti june; mu xtun chavil ti yane. Mu xu' chatun yu'un ti Diose xchi'uc ti c'utic oy avu'un li' ti balumile ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ti fariseoetique ti chbic'taj yo'ntonic yu'un taq'uin, c'alal laj ya'ibeic sc'op ti Jesuse, lic slabanic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ti Jesuse hech lic yalbe: ―Ti stojol crixchanoetic chavaq'uic ti q'uelel ti toj avo'ntonic chacuy abaic. Ti Diose sna' ti mu xtun ti avo'ntonique. Yu'un ti much'u chac' sba ti pasel ti muc' ti stojol crixchanoetic, ja' mu xtun chil ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’C'alal mu to chtal ti Juane, ja' laj stojobtasoxuc ti mantaletique ti laj yal ti Moisese xchi'uc ti sc'op ti j'alc'opetic yu'un ti Diose. Ti patil lic xcholboxuc sc'opilal ti tsc'an tsventaimboxuc avo'ntonic ti Diose ti Juane. Ti ora to ep ti much'utic toyol yo'ntonic tsc'an tspasatic ti mantal yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Manchuc mi laj sjel ti c'u che'el laj yal ti Diose, mu xlaj sc'opilal ti mantaletic yu'un ti Diose. C'alal oy to ti vinajele ti balumile mu xlaj sc'opilal ti mantaletic yu'un ti Diose ja'to mi ic'ot ti pasel scotol. Mi jutuc mu xtup' sc'opilal. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Hech yu'un scotol ti much'u tsutes yajnile, mi chic' yan ants, ja' chmulivaj obi. Scotol ti much'u chic' yu'un chajnilin ti much'u sutesbil yu'un ti smalale, ja' chmulav chc'ot ―xchi ti Jesuse―. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Oy jun vinic lum jc'ulej. Lum lec sc'u' spoc'. Puru pino poc' slapoj. Scotol c'ac'al lequil ve'elil tsve'. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Oy yan vinic, Lázaro sbi. Ja' tsc'an paramote. Te chc'ot smetsan sba ti sti' sna ti jc'ulej vinique. C'a'el staoj ti svinquilel ti Lázaroe. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ti Lázaroe ja' tsc'an tstam sve' ti xch'uch'ulel vaj ti te p'ajem ti yolon smesa ti jc'ulej vinique. Muc x'ac'bat stam. Ti bu yajeme te yac'oj sba chlecat yu'un ts'i'. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ti yan c'ac'al icham ti jc'anparamotee. Ti xch'ulele i'ic'at batel yu'un ti ch'ul abatetique te ba xchi'in ti Abrahame te yo' bu oyic ti much'utic co'ol toj yo'ntonic xchi'uque. Icham uc ti jc'ulej vinique, imucat. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ti xch'ulel ti jc'ulej vinique ibat ti bu oyic ti xch'ulelic ti much'utic mu tojuc yo'ntonique. C'alal yac'oj sba chich' vocol te o, hech laj yil ti Abrahame nom to oy ti Abrahame. Te xchi'uc sbaic xchi'uc ti Lázaroe. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hech yu'un tsots ic'opoj ti jc'ulej vinique, hech laj yavta ti Abrahame: “Tote, c'uxubinun”, xchi. “Taco talel ti Lázaroe. Ac'o sts'aj tal sc'ob ti ho'. Ac'o tal sicubtasbun ti coq'ue yu'un ep chquich' vocol li' ti c'oq'ue”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ti Abrahame hech laj yalbe: “Nich'on, na'o ava'uc c'u che'el na'ech' ti balumil. Oy ac'ulejal atuc. Ti Lázaroe me'on ti jyalel. Ti ora to oy xa ti utsilal stuc ti Lázaroe. Ti ho'ote te chavich' vocol o lume. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mu xu' chtal ti Lázaroe yu'un oy muc'ta ch'en ti o'lol. Mu'yuc much'u xu' ch-ech' batel. Mu'yuc much'u xu' ch-ech' talel li'to”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Hech yu'un itac'av ti jc'ulej vinique ti ep chich' vocole: “Mi mu xu' chtal scoltaun ho'oni, avocoluc me, tacbun batel ti sna ti jtote ");
INSERT INTO tzoNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","yu'un oy ho'vo' quits'inabtac te comen ti jna. Ac'o ba yalbun mu me xtal li'to yu'un puru vocol chquich' li'to”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ti Abrahame hech lic yalbe: “Yich'ojbeic sun ti Moisese xchi'uc ti sun ti yan j'alc'opetic yu'un ti Diose. Xu' tspasbeic ti muc' ti sc'opique”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Itac'av ti vinique: “Mu sc'an xch'unic, tote. Ti oyuc ti ánima tscusesat chilique ja'to chch'unic, ja'to tsutes yo'ntonic”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ti Abrahame hech lic yalbe: “Mi mu sc'an spasbeic ti muc' ti sc'op ti Moisese xchi'uc ti j'alc'opetic yu'un ti Diose, ¡bu ba xch'unic manchuc mi tscusesbat ánima chilique!” xut ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ti Jesuse hech laj yalbe ti yajchanc'opetique: ―Scotol ora oy ti c'usi tsc'an chbolibtasvane. Uts sbaic ti much'u chbolibtasvane. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ja' más lec ac'o chucbatuc ti snuc' cho' ac'o tenatuc ochel ti nab. Te chch'ay batel ti nab. Te tsjic' ti ho'e. Yu'un hech mu me sbolibtasbe yo'ntonic mi junuc ti much'utic li'to ti ololic to ti sventa ti jc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","’P'ijanic me. Mi laj sta smul ti atojol ti avermanoe, ja' tsc'an chataq'ui. Mi laj sutes yo'ntone, ja' tsc'an chapasbe perdón. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mi laj sta smul ti atojol ep vuelta ti jun no'ox c'ac'al, ti c'alal staoj smul ti atojol ti jujun vueltae, mi hech tal yalbot: “Pasbun perdón yu'un jmul”, mi xayutot, ta me xapasilambe perdón ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ti jcholc'opetique lic yalbe ti Cajvaltique: ―Epajesbuntutic ti xch'unojel co'ntontutique ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ti Cajvaltique hech laj yalbe: ―Manchuc mi jutuc no'ox xch'unojel avo'ntonic hech chaj c'u che'el jp'ej sbec' mostazate' ti biq'uit, chc'ot ti pasel avu'unic ti c'usi vocol ti pasel ti mu xu' avu'unic atuquic. Hech chaj c'u che'el mi chavale: “Ac'o buluc loq'uel ti te' li'to, te ac'o ba ch'iuc ti nab”, mi xachiique, ta me xc'ot ti pasel avu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Ti c'alal mi laj yo'nton tsvoc'bot avosil ti amozoe, mi laj yo'nton laj sq'uelbot acarneroe, c'alal tsut tal ti ana, mu yu'unuc chavalbe: “La' me ti ora, la' naclan li' ti mesae”, muc un xavut. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ja' chavalbe: “Chapambun jve'el, ac'o smac ach'ut, mac'linun. Ja'to mi laj ve'ucune, ja'to chave'”, chavut. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","C'alal mi laj xa xch'umbot scotol amantale, “hocol aval”, muc un xavut yu'un ja' yabtel tspas avu'un. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ja' no'ox hech uc ti ho'oxuque, mi laj xa ach'umbeic scotol ti c'utic chayalboxuc ti Diose, hech me xavalic: “Mu yu'unuc lequil abatucutic yu'un ti hech laj xa jpastique. Yu'un ja' ono'ox cabteltic yac'ojbucutic”, xachiic me ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ti c'alal yac'oj sba chanav batel yu'un chbat ti Jerusalén ti Jesuse, ja' laj stam batel ti'ti'mojone yu'un ti estado Galilea xchi'uc ti estado Samaria. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Te i'och ti jun colonia. Te isnup ti be lajunvo' viniquetic ti yich'ojic c'a'el chamele. Nom laj sva'an sbaic ti viniquetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tsots lic c'opojuc, hech laj yalbeic ti Jesuse: ―Jesús, Maestro, c'uxubinuntutic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","C'alal laj yil ti viniquetique ti Jesuse, hech lic yalbe: ―Batanic, ba ac'o abaic ti q'uelel ti stojol ti paleetique ―xut. Laj xch'unic, ibatic, hech ichopic ti xchamelique. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hech yu'un ti june, ti c'alal laj yil sba ti ichop xae, hech isut tal ti stojol ti Jesuse ti ora. Tsots ic'opoj talel ti stojol ti Jesuse chalbe vocol ti Diose yu'un ti ichope. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tal spatan sba ti stojol ti Jesuse, hech laj yalbe: ―Hocol avalbun ti nichop xae ―xchi. Ti vinic ti hech laj yale, ja' liquem tal ti Samaria. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ti Jesuse hech lic yalbe ti much'utic xchi'inoje: ―Lajunvo'ic ti laj jcoltae. Q'uelo avil muc sutic tal yu'un chalbeic vocol ti Diose ti balunvo' ti jchi'iltique. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ja' no'ox stuc isut talel yu'un chalbe vocol ti Diose ti yanlum vinic li'to ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ti Jesuse hech lic yalbe ti vinique: ―Lican, batan me. Chacuxi sbatel osil yu'un laj xa ach'umbun jc'op ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ti Jesuse hech lic jac'batuc yu'un cha'vo' oxvo' ti fariseoetique ti c'usi ora chtal pasvanuc ti mantal ti Diose. Hech itac'av ti Jesuse: ―Mu'yuc señail c'alal chtal pasvanuc ti mantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mu'yuc much'u xu' chal: “Ja' tal spas mantal ti Diose li'to”, mu xu' xchiic. “Ja' tal spas mantal ti Diose lum toi”, mu xu' xchiic. Yu'un ti Diose ja' ch-abtej ti yo'ntonic crixchanoetic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ti Jesuse hech laj yalbe ti yajchanc'opetique: ―Ta me sta yorail hech chlic ac'anic “Taca taluc ti Cajvaltique”, xachiic pero mu to xu' chital, ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Hech chlic ava'ibucun jc'opilal: “Li' xa ti Cajvaltique”, xayutoxuc. “Te xa ti Cajvaltique”, xayutoxuc. Mu me xach'unic, mu me xabatic ti bu chalique. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yu'un hech chaj c'u che'el ti ora no'ox chleblej ti tselove chquiltic jcotoltic ti chlic ti sloq'ueb c'ac'al chleblej batel c'alal ti smaleb c'ac'al, ja' no'ox hechun ti ho'one, ti ora no'ox chital chavilic acotolic, ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Persa jbael chquich' ep vocol yu'un mu xisc'anucun ti jchi'iltic ti li'oyic ti balumil ti ora to. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Hech chaj c'u che'el laj spasic ti crixchanoetique ti vo'one ti c'alal li'oy ti balumil ti Noee, ja' no'ox hech yac'oj sba tspasic uc c'alal po'ot xa tsta yorail chital, ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","C'alal mu to xtal ti nojelal ho'e, yac'oj sba chve'ic, yac'oj sba chnupunic, yac'oj sba chaq'uic ti nupunel stsebic. Ja'to c'alal laj sta yorail i'och ti barco ti Noee, ja'to ipajic. Yu'un ital ti nojelal ho'e, hech itup'ic scotolic. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ja' no'ox hech laj spasic uc ti crixchanoetique ti vo'one c'alal li'oy ti balumil ti Lote. Yac'oj sba chve'ic, yac'oj sba chmanilajic, yac'oj sba chchonilajic, yac'oj sba ch-avolajic, yac'oj sba tsmeltsan snaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ja'to c'alal iloc' batel ti Sodoma ti Lote, ja'to ipajic. Yu'un iyal tal c'oc' ti vinajel xchi'uc azufre, hech itup'ic scotolic. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ja' hech yac'oj sba tspasic uc ti crixchanoetique ti c'alal chicha'sut talele, ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ti c'alal chicha'sut talele, ho'on ti co'ol crixchanoucutique, mu me teuc batem avo'ntonic ti c'utic oy avu'unic li' ti balumile. Yu'un ti much'utic muem ti yamaq'uil sjol sna, c'alal chyal tal, mu xa me c'usi chba stam loq'uel ti c'usi oy yu'un te ti yut sna. Ti much'utic te oyic ti chobtique mu xa me sut batel ti sna. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Na'ic me ti c'u che'el icom ti yajnil ti Lote. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yu'un mi tsots sc'opilal chava'i ti acuxlejal li' ti balumile, ja' chach'ay. Mi mu tsotsuc sc'opilal chava'i ti acuxlejal li' ti balumile, ja' chacuxi. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Chacalbeic, mi ti ac'ubaltic chitale, ti bu cha'vo' xchi'inoj sbaic ti vayel jun ch-ic'at, jun chcom. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mi oy cha'vo' antsetic xchi'inoj sbaic ti juch'nej, jun ch-ic'at, jun chcom. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mi oy cha'vo' viniquetic te ti chobtic, jun ch-ic'at, jun chcom ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hech ijac'bat ti Jesuse: ―¿Bu chc'ot ti pasel? Cajval ―xchiic. Itac'av ti Jesuse: ―Hech chaj c'u che'el ti ora no'ox sna' bu oy ánima ti tanjole, ja' no'ox hech chc'ot ti pasel ti ora no'ox sna'ic ti nital xa ti ho'one scotol ti much'u xch'unojbun jc'ope, hech tstsob sbaic ti jtojol ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ti Jesuse lic yalbe lo'il ti yajchanc'opetique. Ti sjam ti lo'ile ja' tsc'an ti scotol ora ti jc'opontic Dios hech mu xchibaj co'ntontic. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Hech laj yalbe: ―Te ti jun jteclum oy jun juez. Mi jutuc mu xi' ti Diose. Mu'yuc much'u bal ti yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Te nacal uc ti jteclum jun me'on ants. Ep vuelta ital ti antse, hech tal sc'opon ti jueze: “Avocoluc chacoltaun yu'un oy much'u chiscontrainun”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ep c'ac'al ti mu'yuc sc'opilal ti yo'nton ti jueze ti chchapan ti me'on antse. Patil lic snop ti yo'nton: “Mu yu'unuc ti jxi' ti Diose, mu yu'unuc ti jxi' ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ja' no'ox yu'un li' chtuchtuni avi me'on ants li'to, hech yu'un ti jchapan. Yu'un mu xa sts'ic cu'un ti chtal sc'oponilanune”, xchi ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Hech lic yal ti Cajvaltique: ―Ava'i c'u che'el laj yal ti jueze, ja' ti mu tojuc yo'ntone. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ja'uc ti Diose, ti toj yo'ntone, mi hech chac'anilambeic ti c'ac'al ti ac'ubal ti chaxchapanoxuque, ho'oxuc ti t'ujbiloxuc yu'une, jp'el sc'opilal chc'ot ti pasel. Mu xlaj yo'nton chaya'iboxuc ac'opic. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","C'alal mi laj sta yorail, chlic xchapan ti ora. Ti ho'one ti co'ol crixchanoucutique, ta ono'ox chicha'sut tal. Ti c'u yepal xch'unojbucun to ti jc'ope li' ti balumile chul jta ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ti Jesuse hech lic yal lo'il yu'un hech ac'o ya'yic ti much'utic toj yo'nton laj scuy sbaique, ja' ti mu'yuc stu laj yil scotol crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Oy cha'vo' viniquetic i'ochic ti templo yu'un te chba sc'oponic Dios. Fariseo ti june. Ti june jtsobpatan. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Te va'al ti fariseoe tstoy sba ti stojol ti Diose, hech chalbe: “Dios, hocol avalbun ti mu hechuc co'nton hech chaj c'u che'el yan crixchanoetic, ja' ti ch-elc'ajique, ti mu tojuc yo'ntonique, ti chmulivajique. Mu hechuc co'nton hech chaj c'u che'el ti jtsobpatan lume ti chasc'oponote. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Chabchab vuelta jujun semana chquipan jba. Scotol ti c'utic ti jtae, ti jtus ti lajlajuneb. Jun ti jloq'ues ti lajlajuneb yu'un chacac'bot amoton”, xut ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ti jtsobpatane nom to va'al yu'un chi' yu'un ti Diose. Mi jutuc mu sq'uel muel yu'un chi' ti Diose. Yu'un laj sna' ti mu xtun ti yo'ntone hech yu'un lic smajilan sti' yo'nton, hech laj sc'opon Dios: “Dios, c'uxubinun yu'un mu xtun ti co'ntone”, xchi ti stojol ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Chacalbeic, ti jtsobpatane ch'ayem xa smul isut batel ti sna. Ti fariseoe muc xch'ay ti smule. Yu'un scotol ti much'u chac' sba ti pasel ti muc', ja' mu spasat ti muc' yu'un ti Diose. Ti much'u biq'uit chac' sbae, ja' tspasat ti muc' yu'un ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ti judioetique laj yiq'uic tal ti stojol ti Jesuse ti ololetique asta ti nene ololetique yu'un ac'o yac' sc'ob ti Jesuse ac'o yac'be ti sjolic ti ololetique yu'un hech chich'ic bendición. C'alal laj yil ti yajchanc'opetique sc'an spajesic ti crixchanoetique. Tsots laj yalbeic mantal yu'un tspajesic. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ti Jesuse laj yic' tal ti stojol ti ololetique xchi'uc ti stot sme'ique. Hech yu'un hech lic yalbe ti yajchanc'opetique: ―Mu me xapajesic. Ac'o taluc ti jtojol ti ololetique. Yu'un ti much'utic chventaimbat yo'ntonic yu'un ti Diose, ja' hech chc'otic hech chaj c'u che'el olol ―xut―. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Melel ti c'usi chacalbeique, ti much'utic mu sc'an chc'otic hech chaj c'u che'el olol mu xu' chventaimbat yo'ntonic yu'un ti Diose ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Oy jun totil yu'un ti judioetique tal sjac'be ti Jesuse: ―Maestro, ho'ot lequil vinicot. ¿C'usi ti jpas yu'un hech chicuxi sbatel osil? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ti Jesuse hech lic yalbe: ―¿C'u yu'un “lequil vinicot” xavutun? Mi junuc mu'yuc much'u lec, ja' no'ox stuc ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Achanoj ti mantaletique, “mu me xamulivajic, mu me xamilvanic, mu me xa'elc'ajic, mu me xanopbeic smul avecino, paso me ti muc' atot ame'”, ti xchie ―x'utat yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hech itac'av ti vinique: ―Scotol avi to jch'unoj c'alal nich'i tal ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","C'alal laj ya'i ti Jesuse ti hech itac'ave, hech lic yalbe: ―Oy to c'usi tsc'an to avu'un. Ba chono scotol ti c'utic oy avu'une, q'uelambo ti me'onetique. Hech oy ac'ulejal ti vinajel chc'ot. Patil chtal ats'aclinun ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","C'alal laj ya'i ti unen vinique laj yich' mul yu'un ep sc'ulejal li' ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","C'alal laj yil ti Jesuse ti mu xch'un yu'un ti unen vinique, hech laj yal: ―Ti jc'ulejetique ja' vocol chac' sbaic ti ventainel yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Hech chaj c'u che'el mu xjelav jcot camello ti xchac acuxa, ja' no'ox hech uc ti much'u jc'uleje mu xu' chac' sba ti ventainel yu'un ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ti much'utic laj ya'ibeic sc'op ti Jesuse, hech lic sjac'beic: ―¿Much'u cac'tic xu' chcol che'e? ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ti Jesuse hech lic yalbe: ―Ti crixchanoetique mu xu' scolta sba stuc. Ja' no'ox ti sventa ti Diose xu' chcolic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hech yu'un ti Pedroe hech lic yalbe: ―Ho'ontutique laj xa jcomestutic scotol, laj xa jts'acliotutic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ti Jesuse hech lic yalbe: ―Melel ti c'usi chacalbeique, scotol ti much'u yamal sc'opilal cha'i ti snae, ti yajnile, ti sbanquiltaque, ti yits'inabtaque, ti svixobtaque, ti yixleltaque, ti stot sme'e, ti xnich'nabe, yu'un ja' más tsots sc'opilal cha'i ti chac' sba ti abatinel yu'un ti Diose, ");
INSERT INTO tzoNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ja' ep ch-ac'bat xq'uexol li' ti ora to. Ch-ac'bat yich' uc xcuxlejal sbatel osil ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ti Jesuse laj sq'uej sbaic batel xchi'uc ti lajchavo' yajchanc'opetique. Hech lic yalbe: ―A'yo me ava'yic, ta xa xijmu batel ti Jerusalén. Scotol chc'ot ti pasel ti jc'opilale ti laj sts'ibabun comel ti j'alc'opetic yu'un ti Diose, ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chi'ac'at entrecal ti sc'ob yanlum viniquetic yu'un hech chquich' labanel, chquich' ilbajinel, chquich' tubtael. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","C'alal mi laj xa yo'nton yac'bucun aciale, patil chba smilucun ti cruz. Patil oy much'u chlic smucucun. Hech yu'un ti yoxibal c'ac'al chlic cha'cuxiucun ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mu'yuc sc'opilal ti yo'ntonic yu'un ti hech chc'ot ti pasele hech yu'un muc xa'ibeic sjam ti c'u che'el laj yale. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ti c'alal po'ot xa chc'ot ti jteclum Jericó ti Jesuse, te nacal c'ot sta ti ti'be jun ma'sat. Ja' judio vinic. Te tsc'an paramote. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","C'alal laj ya'i ti ma'sate ti oy ep xchi'iltac ch-ech'ic, hech lic sjac'be: ―¿Bu chabatic? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hech i'albat yu'unic: ―Ja' jchi'inojtutic ti Jesuse, ja' ti liquem tal ti Nazarete ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","C'alal hech laj ya'i ti ma'sate, hech tsots lic yavta: ―Jesús, ho'ot ti yelnich'onot ti Davide ti ac'opilal chatale, c'uxubinun ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ti much'utic baejemique: ―Anchan ―xutic. Muc xch'un ti vinique. Más tsots lic yavta: ―Yelnich'onot David, c'uxubinun ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hech yu'un ti Jesuse laj sva'an sba. ―Ba iq'uic tal ti vinique ―xut. C'alal ihul ti stojol, hech lic sjac'be: ");
INSERT INTO tzoNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿C'usi chac'an chajpasbe? ―xchi ti Jesuse. Itac'av ti vinique: ―Avocoluc, Cajval, jambun jsat ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ti Jesuse hech lic yalbe: ―Hechuc, ac'o jamuc asat. Yu'un ti xc'ot xa asate, yu'un laj ach'un ti xu' cu'un ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ti ora ijam ti sate. Laj sts'acli batel ti Jesuse, lic yalilambe vocol ti Diose. C'alal laj yilic scotol ti xchi'iltaque, scotolic lic yalbeic vocol uc ti Diose yu'un ti hech ic'ot ti pasele. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ti bee ti chbat ti Jerusalén te chjelav ti Jericó hech yu'un te ijelav ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Oy jun vinic te ti jteclum, Zaqueo sbi ti vinique. Tsots yabtel yich'oj. Ja' ajvalil yu'un chich' scotol ti patan ti chaq'uic ti xchi'iltaque. Ja' jc'ulej ti jyalel ti Zaqueoe. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ti Zaqueoe sc'an sq'uelbe sat ti Jesuse. Sc'an xojtiquin. Yu'un ep ti jyalel ti crixchanoetique, muc xil ti Jesuse ti Zaqueoe yu'un comcom vinic ti Zaqueoe. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hech yu'un ijelav batel ti anil. Imu ti jtec sicómorote' yu'un hech tsq'uelbe sat ti Jesuse c'alal ch-ech' batel ti be. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ti Jesuse c'alal ic'ot yo' bu ti te'e, laj sq'uel muel. Laj yil ti vinic ti te luchule, hech lic yalbe: ―Zaqueo, yalan tal yu'un persa te chibat ti ana ti ora to ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ti ora iyal tal ti Zaqueoe. Nichim no'ox yo'nton laj yic' batel te ti sna ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mu xtun laj yilic ti crixchanoetique yu'un ti te ibat ti Jesuse yu'un sna'ojic ti mero jlo'lavanej ti Zaqueoe. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ti Zaqueoe laj sva'an sba ti stojol ti Cajvaltique, hech lic yalbe: ―A'yo me ava'i, Cajval, chcac'be o'loluc jc'ulejal ti me'onetique. Mi oy much'u laj jlo'labe staq'uin, ti jsutesbe chanib vuelta ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ti Jesuse hech lic yalbe: ―Ti ora to nacolic xa xchi'uc sjunul ana. Ti ora to mero yelnich'on Abraham nac'ot yu'un co'ol oy xch'unojel avo'nton xchi'uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yu'un ho'on ti co'ol crixchanoucutique, tal jsa' scotol ti much'u ch'ayeme. Tal jcolta ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yu'un te yac'oj sba cha'ibeic sc'op ti Jesuse ti judioetique, hech yu'un ti Jesuse hech lic scaj'albe lo'il ti c'alal mu to chc'ot ti Jerusalén xchi'uc, yu'un tscaj'ac'be sna'ic ti ma'uc to yorail ti ch-och ti ajvalile. Yu'un laj scuyic ti judioetique ti ch-och ti ajvalil yu'unic te ti Jerusalén yu'un ja' xa yorail tspasvan ti mantal li'to ti Diose laj scuyic. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hech yu'un hech lic yalbe: ―Oy jun vinic, ja' snich'on jun rey. Jc'ulej ti vinique. Ibat ti yan balumil. Nom ti balumile. Ba yich' tal yabtel yu'un ch-och ti ajvalil yu'un hech xu' tspas ti mantal ti xchi'iltaque. Patil tsut talel. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","C'alal mu to chbat, laj yic' tal ti stojol lajunvo' ti yabate. Jujun laj yac'be jun libra saquil taq'uin. Hech laj yalbe: “Ba pasic canal xchi'uc. Chul quich' ti c'alal chisut talel ti yan c'ac'al”, xut comel. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Hech yu'un scotol ti crixchanoetique mu xtun laj ya'yic ti ch-och ti ajvalil ti xchi'ile c'alal tsut talel, hech yu'un patil laj staquic batel ti much'utic chba sc'anic parte. Hech chba yalic: “Mu jc'antutic ti ja' chisventainuntutic ti jchi'il lume”, xchiic c'otel. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","C'alal laj xa yich' yabtel ti ajvalil ti vinique, isut tal. Laj stac ti iq'uel ti abatetic ti yac'ojbe ono'ox sventainic ti staq'uine yu'un tsc'an cha'i c'u che'el laj spas canal xchi'uc ti jujune. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ital ti june, hech laj yal: “Cajval, lajuneb libra ijolin cu'un ti ataq'uin ti laj avac'bune”, xchi hulel ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","I'albat yu'un ti yajvale: “Ho'ot lequil abatot cu'un. Yu'un jun avo'nton laj ajolintas ti jtaq'uine hech yu'un lajuneb jteclumetic chacac'bot aventain”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ital yan, hech laj yal: “Cajval, ho'ob libra ijolin cu'un ti ataq'uin ti laj avac'bune”, xchi hulel ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Hech i'albat yu'un ti yajvale: “Ho'ot ho'ob jteclumetic chacac'bot aventain”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ital yan, hech laj yal: “Cajval, ilo ti jun libra saquil taq'uin avu'une ti laj avac'bune. Lec laj jpix ti panuela, lec laj jq'uej. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yu'un laj jna' ti ta ono'ox chavich' sutel xchi'uc ti sjole. Laj jna' ti c'oc' vinicote. Ho'ot chavich'ilan ti bu mu ho'ucot avabtel”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Hech i'albat yu'un ti yajvale: “Ho'ot chopol abatot. Yu'un mu lecuc avo'nton ti jtojol hech yu'un mu xac'an cha'abtej. Chaquich'bot ac'op ti sventa ti c'usi laj avale. Mi yu'un chacuy ti ho'on c'oc' vinicun, ti ho'on chquich' ti bu mu ho'ucun cabtele, ");
INSERT INTO tzoNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","hech yu'un ¿c'u yu'un mu laj avac'be ti much'u tsna' tsjolintase te ti banco? Hech c'alal nital, laj xa quich' sutel xchi'uc ti sjole ti hechuque”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hech lic yalbe ti much'utic te va'ajtique: “Pojbo ti jun libra ti jtaq'uine, ac'bo ti much'u laj yich' tal ti lajuneb librae”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Oy hech laj yalic: “Cajval, yich'oj xa lajuneb libra saquil taq'uin lume”, xutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Hech itac'av ti reye: “Chacalbeic, scotol ti much'u ch-abtej cu'un, tsta ti c'usi oy yu'une. Ja' chlic cac'be yan uc. Ti much'u mu sc'an ch-abtej cu'un, hech mu'yuc c'usi tsta. Ja' chlic jpojbe ti c'usi cac'ojbe ono'oxe. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ti much'utic hech chiscontrainune, ti mu sc'an ti ho'on ti jpas ti mantale, scotolic iq'uic me tal li'to. Milic li' ti jtojole”, xchi ti reye ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","C'alal laj yo'nton laj yal ti lo'ile ti Jesuse, hech lic baejuc batel ti Jesuse yu'un chmu batel ti Jerusalén. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ic'ot nopol chib jteclum, Betfagé sbi ti june, Betania sbi ti yane. Te nopol vits Olivatic sbi. Ti Jesuse lic stac batel cha'vo' ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Hech laj yalbe: ―Toj chabatic ti biq'uit jteclum lum toi. C'alal te cha'ochic oy burro leclec to no'ox sba smuc'ul te chucul chc'o ataic. Mi junuc vuelta mu'yuc much'u scajlebinoj. Coltao, ic'bun talel. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mi chasjac'boxuc ti yajvale: “¿C'u stu avu'un ti jburroe? ¿C'u yu'un chacolta?” mi xayute, “chtun yu'un ti Cajvaltique”, xavut ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hech ibatic ti cha'vo'ique, te c'ot staic hech chaj c'u che'el i'albat yu'un ti Cajvaltique. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","C'alal yac'oj sba tsjitumbeic yaq'uil ti burroe, hech i'albat yu'un ti yajval ti burroe: ―¿C'u stu avu'un chacolta ti jburroe? ―x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hech itac'avic: ―Ja' chtun yu'un ti Cajvaltique ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hech laj yiq'uic tal ti yo' bu oy ti Jesuse. Laj scajambe xchijic ti spat ti burroe. Hech yu'un lic scajlebin ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","C'alal ixanav batel ti Jesuse, ti judioetique laj sq'uiic xchijic te ti be. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","C'alal yeloval xa ti Jerusalene, ja' te ti bu vits Olivatic, scotol ti much'u tsts'acli ti Jesuse, tsots lic c'opojucuc. Nichim no'ox yo'ntonic lic yalbeic vocol ti stojol ti Diose yu'un scotol ti jchop o abteletic ti yilojique. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Hech laj yalic: ―¡Jun no'ox yutsil ti ajvalile ti itacat xa tal ti jtojoltic yu'un ti Cajvaltic Diose! ¡Lec chijyilucutic ti Diose obi! ¡Ac'o spasic ti muc' ti Diose scotolic te ti vinajel uc! ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Oy cha'vo' oxvo' ti fariseoetique ti xchi'inojic. Hech lic yalbeic ti Jesuse: ―Maestro, pajeso ti jch'unojeletic avu'une, mu me xc'opojic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ti Jesuse hech lic yalbe: ―Chacalbeic, taca ch'aniuc ti jch'unojeletic cu'une, ja' chlic c'opojuc ti tonetique ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","C'alal ta xa xc'ot ti Jerusalén ti Jesuse, lic yoc'ta ti xchi'iltaque ti te nacajtique. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Hech laj yal: ―Taca xana'ic ti ora to ti c'u che'el chacolique, ja' lec. Pero mu xana'ic. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ta me sta yorail c'alal chasjoyubtaoxuc avajcontra, chascontrainoxuc, chasmacoxuc ti jujujech. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Chjinat ti jteclum avu'unique. Mi jp'ejuc ton mu'yuc bu chcom ti sba yan ton yu'un scotol chjinat, chasmiloxuc acotolic. Yu'un mu xach'unic ti nihul xa ti atojolic, ho'on ti Diosune ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","I'och ti yamaq'uil templo te ti Jerusalén ti Jesuse. Lic sten loq'uel scotol ti jchonolajeletique te ti yamaq'uil templo. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Hech lic yalbe ya'yic: ―Hech ts'ibabil comel: “Ti jnae ja' sventa ti te chac'oponune”, xchi ti Diose. Ho'oxuque laj xa ac'atajesic ti xch'en j'elec' ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Scotol c'ac'al te ichanubtasvan ti templo te ti Jerusalén ti Jesuse. Ti totil paleetique xchi'uc ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti totiletic yu'un ti judioetique sc'an smilic. ");
INSERT INTO tzoNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yu'un scotol ti crixchanoetique toyol yo'ntonic laj ya'ibeic sc'op ti Jesuse, hech yu'un muc spas c'usi chutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ti yan c'ac'al yac'oj sba chchanubtasvan te ti yut templo te ti Jerusalén ti Jesuse, yu'un chcholbe ya'yic ti lequil ach' c'ope, ital cha'vo' oxvo' ti totil paleetique xchi'uc ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique xchi'uc ti moletique. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Hech tal sjac'beic ti Jesuse: ―Albun ca'itutic, ¿much'u smantal avich'oj ti hech laj aten loq'uel ti jchonolajeletique li' ti yamaq'uil ti temploe? ¿Much'u laj yac'bot avabtel? ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Itac'av ti Jesuse, hech lic yalbe: ―Oy c'usi chajac'be uc. Ti jc'an ti chavalbun ca'i. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ti Juane ¿much'u i'ac'bat yabtel yu'un ti laj yac' ich'ho'e? ¿Mi yu'un Dios i'ac'bat yabtel o mi yu'un crixchanoetic i'ac'bat yabtel? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Hech lic yalbe sbaic: ―“Yu'un Dios”, mi chijchie, “¿c'u yu'un muc xach'unic che'e?” ta me xijyutucutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Yu'un crixchanoetic”, mi chijchie, chijyac'bucutic ton ti jchi'iltique. Yu'un scotolic xch'unojic ti ja' j'alc'op yu'un ti Diose ti Juane ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hech yu'un hech lic yalbeic ti Jesuse: ―Mu jna'tutic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hech yu'un ti Jesuse hech lic yalbe: ―Hechun uc, mu xacalbe much'u smantal quich'oj ti hech ti jpase ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ti Jesuse lic yalbe lo'il ti judioetique. Hech lic yalbe: ―Oy jun vinic oy slum. Te laj sts'un ep uvate'. Hech laj sa'be yajval ti slume yu'un hech chchabibat ti slume, ch-abtej yu'un. Te laj snacan comel. Patil nom ibat ti yajval ti balumile. Te ihalej ep c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","C'alal po'ot xa tsta yorail chtoc'onaj ti sat ti uvate'e, laj stac talel ti smozoe yu'un chc'ot sc'opon ti jchabiejbalumiltique. Chc'ot sc'ambe tal ti sate. C'alal ic'ot ti mozoe, imajvanic ti jchabiejbalumiltique. Mu'yuc c'usi i'ac'bat batel ti mozoe. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ti yajval ti balumile laj xcha'tac talel nixtoc yan smozo. Co'ol ono'ox ilaj ti majel uc, ilaj ti ilbajinel, ilabanat. Mi jutuc mu'yuc c'usi i'ac'bat batel uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ti yajval ti balumile laj stac talel yan smozo. Ja' yoxva'al xa. Ja' iyajesat yu'un ti jchabiejbalumiltique, itenat loq'uel ti bu ts'umbil ti uvate'e. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Hech yu'un hech lic snop ti yajval ti balumile: “¿C'usi chcut? Ja' lec ti jtac batel ti jnich'one ti c'ux ti co'ntone. C'alal chilic ti ja' jnich'on, ja' van chispasbucun ti muc'”, xchi ti yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","C'alal laj yilic ti jchabiejbalumiltique ti ja' snich'on ti yajval ti balumile, hech laj yalbe sbaic: “Ja' yajval balumil chcom avi to. Ba jmiltic. Ho'ucutic chquich'betic comel ti slume”, xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hech yu'un laj stenic loq'uel ti bu ts'umbil ti uvate'e, laj smilic. ’Hech yu'un mi isut tal ti yajval ti uvate'e, ¿c'usi chc'ot spasbe ti jchabiejbalumiltique? ―xchi ti Jesuse―. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chacalbeic, ja' tsmil ti jchabiejbalumiltique. Yan xa much'u chac'be xchabi ti uvate' yu'une ―xchi ti Jesuse. C'alal laj ya'yic, hech lic yalic: ―Mu me hechuc tspas ti Diose ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ti Jesuse laj sq'uelbe satic, hech lic yalbe: ―Nopo mi mu hechuc sjam ti hech ts'ibabil ti sc'op Diose: Hech chaj c'u che'el ti yajval nae ti laj yotes ti chiquina ti tone ti mu xtun laj yilic ti yaj'abtele, ja' no'ox hech laj xa yich' tsots yabtel cu'un ti much'u t'ujbil cu'une ti ja' mu sc'anique, ti xchi ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hech chaj c'u che'el ti p'in ti chp'aj yal tal ti ba ton pedazo chc'ot, o mu'yuc xa stu, ja' no'ox hech uc mu'yuc xa stu cu'un ti much'u mu sc'an chixch'umbun ti jc'ope. Mi mu sutes yo'nton, ja' chc'o quich'be sc'op. Hech chaj c'u che'el ti p'in ti chp'aj yal tal muc'ta ton ti sba ja' tsts'ubilaj, ja' no'ox hech uc mi laj cal ti ch'ayel chbatique, jp'el sc'opilal ch'ayel chbatic o. Laj stu o, ti xchi ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ti totil paleetique xchi'uc ti much'utic ichanubtasvan ti smantal ti Diose ti scuyoj sbaique sc'an stsaquic ti ora ti Jesuse yu'un laj ya'ibeic sjam ti ja' sc'opilalic stuquic ti icholbate. Muc xu' yu'unic ti tstsaquique yu'un ja' ixi'ic yu'un ti xchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hech yu'un laj smalaic yu'un c'u che'el xu' tslo'laic ti c'op ti Jesuse tscuyic. Ti c'alal yorail xu' laj scuyic, ti ora laj staquic batel ti yajchanc'opetique ti chch'umbeic sc'op ti Jesuse x'elan, ti jun yo'ntonic ti stojol x'elan yu'un chba sjac'beic sc'op. Mi mu sjamuc ic'opoj ti Jesuse, laj xa stabeic smul tscuyic. Hech xu' stsaquic yu'un chiq'uic batel ti stojol ti gobernadore. Yu'un te chc'ot stic'beic smul tscuyic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Hech yu'un tal sjac'beic ti Jesuse: ―Maestro, ti jna'tutic ti melel scotol ti c'usi chavale, ti toj chachanubtasvane, ti chavac' ti chanel ti sbe ti Diose ti mero melel. Co'ol chac'opon scotol, manchuc mi tsots yabtel yich'oj, manchuc mi mu'yuc tsots yabtel yich'oj. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Albun ca'itutic ¿mi stac' chcac'betutic jpatantutic ti Césare, mi mu stac'? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ti Jesuse laj sna' ti chlo'lavanique, hech yu'un hech laj yalbe: ");
INSERT INTO tzoNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Ac'bun jq'uel junuc adenariotaq'uin ti ja' sventa yu'un chatoj apatanique ―xchi. Hech yu'un ba yich' tal jun denariotaq'uin. C'alal laj sq'uel ti taq'uine, hech lic sjac'be: ―¿Much'u sloc'tombail ti o'loli? ¿Much'u sbi te oy ti sti'ile? ―xut. Hech itac'avic: ―Ja' ti Césare ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hech yu'un ti Jesuse laj yalbe: ―Oy c'usi stac' chach'umbeic ti Césare yu'un ja' totil ajvalil. Ja' no'ox hech uc ti Diose tsc'an chach'unic ti c'u che'el tsc'an ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Manchuc mi tsc'an tsa'beic smul ti Jesuse te ti stojol ti xchi'iltaque, muc xu' yu'unic. Ich'ay yo'ntonic ti c'u che'el itac'av ti Jesuse. Hech yu'un mu xa xu' c'usi yan chalic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Patil italic cha'vo' oxvo' ti saduceoetique, ja' ti chalic ti mu'yuc much'u chcha'cuxie. Tal sjac'beic ti Jesuse: ");
INSERT INTO tzoNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, hech laj sts'iba comel ti Moisese: “Mi oy much'u mu'yuc yol snich'on chcham, ti its'inale ti mu to oyuc yajnile ac'o yic'be yajnil ti sbanquile yu'un hech c'alal ch-an sba yol snich'on xu' chac'be xq'uexolin ti sbanquile yu'un hech mu xtup' sbi ti sbanquile”, ti xchi ti Moisese. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Oy hucvo' jchi'iltic. Yermano sbaic ti hucvo'ique. Ti banquilale laj yic' yajnil, patil icham. Mu'yuc yol snich'on icom. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hech yu'un ti its'inale laj yic'be yajnil ti ánima sbanquile. Patil icham. Mu'yuc yol snich'on icom uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hech laj spasic scotolic o. Xmelmun laj yiq'uic sucva'alic. Icham scotolic. Mu'yuc yol snich'onic icom mi junuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Patil icham uc ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","C'alal tsta yorail ti chcha'cuxiique, ¿much'u junuc yajnil chc'ot ti antse? Melel ti xmelmun laj yiq'uic scotolic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Itac'av ti Jesuse, hech laj yalbe: ―Ja' no'ox ti c'alal li'oyic ti balumile ja' chnupunic ti xnich'nabe, ja' chaq'uic ti nupunel ti stsebique. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ti much'utic t'ujbilic yu'un chcha'cuxiic loq'uel ti ch'ene yu'un te chba naclucuc ti vinajele, mu xa xnupunic mi vinic mi ants. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yu'un mu xa xchamic. Hech chc'otic hech chaj c'u che'el ti ch'ul abatetique. Ja' yol xnich'nab Dios ic'otic o yu'un icha'cusesatic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ti cuxajtic ti ánimaetique ti chamenic xae, ja' laj sts'ibabe sc'opilal ti Moisese ti bu ts'ibabil ti ic'opoj ti Diose te ti jtec' ch'ix. Manchuc mi ep xa habil chamenic ti Abrahame xchi'uc ti Isaaque xchi'uc ti Jacobe, hech ch-albatic to sc'opilal: “Ho'on Diosun yu'un ti Abrahame xchi'uc ti Isaaque xchi'uc ti Jacobe”, ti xchi ti Cajvaltic Diose, xut ti Moisese. Yu'un cuxajtic sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yu'un ja'uc j'ech'el ichamic oe, mu'yuc xa dios yu'unic. Hech yu'un ti Diose ja' yu'unic ti much'utic cuxajtique. Yu'un ti cuxajtic sbatel osile, hech yu'un pasbil ti muc' sbatel osil ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yan xa ti much'u itac'avique. Ja' itac'avic cha'vo' oxvo' ti much'utic ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Hech laj yalbeic ti Jesuse: ―Maestro, lec ti c'usi chavale ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ti saduceoetique muc xu' yu'unic xa tsjac'beic yan ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hech yu'un ti Jesuse hech lic sjac'be: ―¿C'u yu'un chalic ja' no'ox yelnich'on David ti Cristoe, ja' ti ac'bil yabtel yu'un ti Diose? ");
INSERT INTO tzoNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yu'un ti Davide hech laj yalbe sc'opilal ti sunal ti q'uejojetique: Ti Cajvale hech i'albat yu'un ti Diose: “Chlic naclan li' ti jbats'ic'ob ");
INSERT INTO tzoNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ja'to mi laj jtsalbot scotol avajcontra”, x'utat ti Cajvale, xchi ti Davide. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Hech yu'un ma'uc no'ox yelnich'on yu'un “Cajval”, xchi ti stojol ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","C'alal te yabinoj scotol ti judioetique, ti Jesuse hech lic yalbe ti yajchanc'opetique: ");
INSERT INTO tzoNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―P'ijanic me, mu xtun ti c'usi tspasic ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Ja' tsc'anic pasel ti muc' hech yu'un slapojic ti nat sc'u'ique. Lec cha'yic ti tspasatic ti muc' yu'un ep jchi'iltic te ti plaza. Yu'un ja' tsc'anic pasel ti muc' hech yu'un chba naclucuc ti bu chnaquiic ti más totiletique te ti temploetic xchi'uc mi ch-ic'atic ti q'uin uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tspojbeic ti c'utic oy yu'un ti me'on antsetique. Ti c'u che'el chch'umbatic smantalique yu'un chaq'uic ti q'uelel ti hal tsc'oponic Dios. Hech yu'un jelaven chich'ic castigo stuquic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ti Jesuse laj sq'uel batel, laj yil ti te oy jc'ulejetic yo' bu scajonal ti taq'uine, ja' ti yav ti smoton ti Diose. Te yac'oj sbaic tstiq'uic ochel ti staq'uinique ti bu yav ti smoton ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Te ital jun me'on ants ti uts sba ti jyalel laj yil ti Jesuse. Ti antse laj stic' ochel chib cinco. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ti Jesuse hech lic yalbe ti yajchanc'opetique: ―Melel ti c'usi chacalbeique, ja' más ep laj yac' ti me'on antse chil ti Diose; ja' jutuc no'ox laj yac' scotol ti jc'ulejetique chil ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yu'un ti jc'ulejetique scotolic sobrail xa staq'uinic laj yac'beic ti Diose. Ja'uc ti me'on ants li'to ja' scotol laj yac' ti c'u yepal oy yu'un yu'un tsmac'lin sbae ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Oy cha'vo' oxvo' hech laj yalbeic ti Jesuse, ja' sc'opilal ti templo te ti Jerusalene ti t'ujum ti tonetic ti yich'oje xchi'uc ti sronile ti ja' ti laj yaq'uic staq'uinic ti much'utic toyol yo'ntonic laj yac'beic smoton ti Diose. Hech lic yal ti Jesuse: ");
INSERT INTO tzoNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ti na ti t'ujum chquiltic ti ora to, ta me sta yorail ti chjinat. Mi jp'ejuc ton mu'yuc bu chcom ti sba yan ton yu'un scotol chjinat ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hech lic sjac'beic ti Jesuse: ―Maestro, ¿c'usi ora hech chc'ot ti pasel? ¿Mi oy señail ti jq'ueltutic jbael yu'un hech ti jna'tutic ti po'ot xa chc'ot ti pasele? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ti Jesuse hech laj yalbe: ―P'ijanic me, mu me xalajic ti lo'lael. Yu'un ep chtalic chalic: “Ho'on Jcoltavanejun”, xchiic. Oy chtal yalic: “Yorail xa ti chtal ti Cristoe”, xchiic. Mu me xach'unic. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","C'alal chava'ibeic sc'opilal ti oy ep muc'ta pleito li' ti balumile, chava'ibeic sc'opilal uc ti chlic yan muc'ta pleito, mu me xaxi'ic. Persa scotol hech chc'ot ti pasel jbael. Mu to ja'uc slajebal c'ac'al ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Hech laj yalbe uc: ―Ti crixchanoetic ti jun balumile ja' tscontrain ti crixchanoetic ti yan balumile. Ti ajvaliletique tscontrain sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ep chnic ti balumile, oy bu chtal vi'nal, oy bu chtal ep chamel. Chvinaj muc'ta señailetic ti vinajel. Ep chac' xi'el. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’C'alal mu to chc'ot ti pasel, jbael chastsacoxuc, chayilbajinoxuc, cha'ochic ti chuquel ti templo yu'unique xchi'uc ti chuquele. Chayic'oxuc ti stojol ajvaliletic xchi'uc gobernadoretic ho'on ti jventa. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yu'un ti hech chc'ot ti pasele, más to chpuc jc'opilal avu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Hech yu'un j'ech'el ac'o ti avo'ntonic ti mu xacajnopilan ti avo'ntonic jbael c'usi chc'o avalic. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yu'un ho'on chajcolta ti c'op. Chacac'bot sp'ijil avo'ntonic hech mu xu' yu'unic chtac'avic yu'un hech mu xu' yu'unic stsalvan ti c'op scotol ti much'utic chascontrainoxuque. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Oy atot ame'ic no'ox chayac'boxuc entrecal, oy abanquil avits'in no'ox chayac'boxuc entrecal, oy yan avuts avalal no'ox chayac'boxuc entrecal. Oy ti much'utic lec chac'opon abaic xchi'uque ja' no'ox chayac'boxuc entrecal. C'alal oyoxuc xa ti sc'obic, oy bu chasmiloxuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Scotol crixchanoetic chayilintaoxuc ho'on ti jventa. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ja' no'ox mi hech tsc'an ti Diose hech chc'ot ti pasel ti chasmiloxuque. Mi mu hechuc tsc'an ti Diose mu xc'ot ti pasel. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mi oy lec stsatsal avo'ntonic mi icuch avu'unic, hech chacuxiic sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’C'alal chavilic joyubtabil ti jteclum li'to yu'un yajsoldado yan ajvalil, na'ic me ti ic'ot xa yorail ti chjinate. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hech yu'un scotol ti much'utic li' nacajtic ti estado Judeae anil ac'o batuc ti vits. Scotol ti much'utic li'oyic ti yut ti jteclume ac'o loc'uc batel ti anil. Scotol ti much'utic loq'uemic batel ti jteclume, mu xa me sut ochel talel. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yu'un ja' ic'ot xa yorail ti castigo ti chich'ique ti ts'ibabil ono'ox comel, ja' ti laj sts'iba ti yaj'alc'op ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Uts sbaic ti much'utic slicojic yolique xchi'uc ti much'utic oy yolic chchu'unic toe yu'un ep vocol chtal li' ti jteclum li'to. Ja' cha'ibeic yilintael Dios avi jchi'iltic li' nacajtic ti jteclum li'to. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Chmilatic ti espada. Ti much'u cuxajtic toe chchucatic, hech patil chpucatic batel ti slumal yanlum crixchanoetic. J'ech'el chlaj yipic o ti jchi'iltic ti li' nacajtic ti jteclum li'to. Ja' j'ech'el tsventainic ti yanlum crixchanoetic avi jteclum li'to, chixtanic ja'to mi ista yorail yu'un ti Diose ti tsjelbe yajval stuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Te ti vinajel chjel ti c'u che'el ono'ox ch-abtejic ti c'ac'ale, ti ue, ti c'analetique. Ja' no'ox hech uc li' ti balumile chjel ti c'u che'el ono'ox ch-abtej ti nabe. Más tsots chc'opoj ti nabe, más tsots tsyuques sba ti jyalel hech yu'un chi'ic scotol ti crixchanoetic li' ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mu'yuc xa yip yo'ntonic ti crixchanoetique yu'un ti xi'ele, yu'un chi'ic ti jyalel mi oy c'usi chc'ot ti pasel li' ti balumile. Yu'un chniquic scotol ti c'utic te oy ti vinajele. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ja' yorail chiyal tal ti vinajel xchi'uc toc, ho'on ti co'ol crixchanoucutique. Chiyilucun scotol crixchanoetic. Chilic ti jelaven jp'ijile, ti lum lec ti jquevale. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hech yu'un c'alal chaq'uelic ti chlic ti c'utic laj xa calboxuque, nichimuc me avo'ntonic, oyuc me stsatsal avo'ntonic yu'un chana'ic ti po'ot xa chacolic ―xchi ti Jesuse, xut ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Laj yalbe ya'yic uc lo'il. Hech laj yalbe: ―Na'ic me c'u x'elan chch'i ti igote'e xchi'uc scotol yan te'etic. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","C'alal yac'oj sba ch-ach'ub ti yanale, chana'ic ti ja' yorail xa chtal ho'. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ja' no'ox hech uc c'alal chaq'uelic ti yac'oj sba chc'ot ti pasel scotol ti c'utic laj xa calboxuque, na'ic me ti po'ot xa chistacun talel ti Jtote yu'un chtal jpas mantal li' ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Melel ti c'usi chacalbeique, ho'oxuc ti li'oyoxuc ti balumil ti ora to, ja' chaq'uelic ti chjinat ti jteclum li'to hech chaj c'u che'el laj calboxuque. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Chlaj ti vinajele xchi'uc ti balumile. Ti jc'ope ja' mu xlaj stuc. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","’P'ijanic me, mu me ja'uc te batem avo'ntonic c'u che'el lec cha'ech'ic li' ti balumile, hech mu xa ats'aclinojucun c'alal chul jtaoxuc. Yu'un mi hech chapasique, ch'ayem avo'ntonic chul jtaoxuc ti yorail chcale. Hech chaj c'u che'el ti ts'i' mu sna' c'usi ora chba ochuc ti pets', hech ono'ox uc ti crixchanoetique mu sna'ic c'usi ora chtal ti vocole ti sjoylejal balumil. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hech yu'un ti ho'oxuque q'ueleluc me asatic, scotol c'ac'al c'ambeic vocol ti Diose hech lec chayiloxuc, hech mu xa xavilic ti vocol ti chtale, hech mu'yuc amulic c'alal chac'otic ti jtojol, ho'on ti co'ol crixchanoucutique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ti c'ac'altic te ichanubtasvan ti templo te ti Jerusalén ti Jesuse. Ja'uc ti ac'ubaltique iloc' batel, ba vayuc ti bu vits Olivatic sbi. ");
INSERT INTO tzoNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jujun sob ic'luman italic scotol ti crixchanoetique, tal ya'ibeic sc'op te ti templo. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Po'ot xa tsta yorail q'uin pascua sbi c'alal tsve'ic caxlan vaj ti mu pumesbiluc xch'ute. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ti totil paleetique xchi'uc ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique lic snopilanic c'u che'el xu' tsmilic ti Jesuse yu'un chi'ic yu'un ti xchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ti Satanase i'och ti yo'nton ti Judase, ja' ti Iscariote sjol sbie. Ja' ti yajchanc'op ti Jesuse. Ja' co'ol lajchavo'ic xchi'uc ti yan yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ti Judase ba sc'opon ti totil paleetique xchi'uc ti totiletic ti ja' chchabiic ti templo yu'unique te ti Jerusalén. Ba yalbe ti tspas trato xchi'uc yu'un chac'be entrecal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","C'alal laj ya'yic ti paleetique xchi'uc ti totiletique, hech nichim no'ox yo'ntonic. Hech lec ichapaj yu'unic ti c'u yepal chich' taq'uin ti Judase. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ti c'u che'el ichapaj yu'unique lec laj ya'i ti Judase. Hech lic snop ti yo'nton c'usi ora xu' chac'be entrecal yu'un hech mu xlic c'op yu'un ti xchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Laj sta yorail ti tsve'ic ti caxlan vaje ti mu pumesbiluc xch'ute, ti tsmilic ti ch'iom carneroe ti tsti'ic yu'un ti q'uin Pascuae hech chaj c'u che'el yaloj ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Hech yu'un ti Jesuse laj stac batel ti Pedroe xchi'uc ti Juane. Hech laj yalbe batel: ―Batanic, ba chapambucutic ti ch'iom carnero ti jti'tic sventa ti q'uin pascuae ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hech lic sjac'beic: ―¿Bu chac'an chajmeltsambe ti carnero ti jti'tique? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ti Jesuse hech laj yalbe: ―A'yo me ava'yic. C'alal cha'ochic ti jteclum, chanupic ti be jun vinic scuchoj ya'al ti sq'uib. Ja' chats'acliic batel, chachi'inic ochel ti na ti bu ch-oche. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Hech me chavalbeic ti yajval nae: “Hech chayalbot ti Maestroe: ¿Bu oy ti cuarto ti anae yo' bu xu' jti'tutic ti carnero sventa ti q'uin Pascuae xchi'uc ti cajchanc'opetique? xchi ital sc'op”, xavutic me. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hech chayac'boxuc avilic muc'ta cuarto te ti xcha'cajal sna. Xch'uboj xa ti cuartoe. Te chameltsanic ti carneroe ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hech ibatic, hech c'ot staic hech chaj c'u che'el i'albatic yu'un ti Jesuse. Te laj smeltsanic ti carneroe sventa ti q'uin Pascuae. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","C'alal laj sta yorail chve'ic yu'un ti q'uine, ital ti Jesuse. Tal snacan sba ti mesa xchi'uc ti jcholc'opetic yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hech lic yalbe ya'yic: ―Toyol co'nton yu'un ti chajchi'inoxuc ti sti'el ti carnero sventa ti q'uin Pascuae c'alal mu to chquich' vocol. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yu'un chacalbeic, ja'to mi laj sta yorail ti nacolic xae c'alal te xa oyucutic yo' bu tspas mantal stuc ti Diose, ja'to ti jti'be xq'uexol ti carnero avi to ho'oni ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ti Jesuse ja' i'ac'bat jun taza ya'lel sat uvate' yu'un ti yajchanc'ope. Hech laj stsac ti tazae, lic yalbe vocol ti Diose. Hech lic yalbe ya'yic: ―Ilo, uch'anic acotolic. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yu'un chacalbeic, ja'to mi laj sta yorail laj jtsob jbatic jcotoltic yo' bu tspas mantal ti Jtotic Diose, ja'to chcuch'be xq'uexol ti ya'lel sat uvate'e avi to ho'oni ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Hech lic stam jun caxlan vaj, laj yalbe vocol ti Diose, laj xet' ti caxlan vaje, laj yac'be ti yajchanc'opetique. Hech laj yalbe: ―Ja' jbec'tal li'to yu'un chcac' jba ti milel ti aventaic. Hech me chapasic yu'un chana'ucun ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","C'alal ive'ic xae, co'ol lic stsac yan vuelta ti tazae, hech lic yalbe: ―Ja' jch'ich'el li'to. Chcac' jba ti milel, chloc' ti jch'ich'ele. Ho'ot ti aventaic ti chcac' jba ti milele. Ti ora to ti jch'ich'ele ja' señail ti mu xch'ay ti ach' c'op ti yaloj ti Jtotique ti c'u che'el chacolique. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’A'yo me ava'yic, ti much'u chiyac'un entrecale, ja' li' jchi'inojtic li' ti mesae. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yu'un hech ono'ox xchapanoj ti Diose, hech yu'un chismilucun, ho'on ti co'ol crixchanoucutique. Uts sba ti much'u chiyac'un entrecale ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hech yu'un ti yajchanc'opetique hech lic sjac'be sbaic much'u chac' entrecal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hech lic stsac sbaic ti c'op ti yajchanc'opetique: ―¿Much'u ti más totil chc'ot cu'untique? ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ti Jesuse hech lic yalbe: ―Ti ajvaliletic yu'un yanlum viniquetic chac' sbaic ti pasel ti muc' ti stojol ti svinictaque. Manchuc mi tstoy sbaic ti stojol ti crixchanoetic ti smacojique, ja' tsc'anic ti “ja' chcuxubinvan”, ac'o chiuc sc'opilalic yu'un ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ti ho'oxuque mu me hechuc chapasic. Ti much'u tsc'an ti totil chc'ot avu'unique, ac'o yac' sba ti abatinel avu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nopo ava'yic ti c'u che'el ti much'u totil li' ti balumile ja' no'ox chal mantal. Mu yu'unuc ch-abtej. Ja'uc ti ho'one, mu hechuc ti jpas. Yu'un ho'on avabatun c'otemun. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Ti ho'oxuque jun avo'ntonic laj achi'inucun ti c'alal laj quich'ilan contrainel. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Hech yu'un yu'un yac'ojbun cabtel ti Jtotique yu'un ti jpas mantal, hech chacac'boxuc avabtelic yu'un chapasic mantal uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Hech co'ol chijc'otucutic ti yorail ti jpas mantal. Co'ol oy cabteltic yu'un co'ol ti jpastic ti mantal ti jchi'iltique, ho'ucutic ti co'ol yelnich'onucutic ti Israel xchi'uque ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ti Cajvaltique hech lic yalbe ti Simone: ―Simón, a'yo me ava'i, sc'anoj lisensa ti Satanase yu'un chaspasboxuc proval avo'ntonic ti ora to. Ja' tsc'an ti ac'o chibajuc avo'ntonic o yu'un hech chapuquic batel hech chaj c'u che'el spaxaq'uil trigo. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ho'oti laj xa jc'opombot Dios ti atojol yu'un mu me xchibaj avo'nton o. C'alal chacha'sutes avo'nton, chatsatsubtasbe yo'ntonic ti avermanotaque ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Lic yal ti Pedroe: ―Cajval, manchuc mi chixchucucun, manchuc mi chismilucun, muc chajcomesot ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ti Jesuse hech lic yalbe: ―Pedro, chacalbot ava'i, avi ac'ubal to c'alal tsta yorail ch-oc' quelem, laj xa amucun ti avo'nton oxib vuelta ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ti Jesuse hech lic yalbe scotolic: ―C'alal laj jtacoxuc batel mu'yuc ataq'uin, mu'yuc ave'el, mu'yuc asempat, ¿mi oy c'usi muc xataic? ―xut. Hech itac'avic: ―Mu'yuc palta laj ca'itutic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ti Jesuse hech lic yalbe: ―Hech chaj c'u che'el ti soldadoetique chchapan sbaic yu'un chba spasic pleito, chich'ic batel staq'uinic xchi'uc sve'elic xchi'uc yespadaic, ja' no'ox hech tsc'an uc ti ora to. Tsc'an ti oy xch'unojel avo'ntonique yu'un hech chcuch avu'unic ti chacontrainatique. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hech yu'un ti hech chacalbeic, yu'un ti ora to persa hech chc'ot jc'opilal hech chaj c'u che'el ts'ibabil comel jc'opilal: “Chchapanat hech chaj c'u che'el jmulavil”, ti xchie. Yu'un ti hech ts'ibabil comel ti jc'opilale, persa chc'ot ti pasel ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hech lic yalic: ―Cajval, li'oy cha'ch'ix espada ―xchiic. Hech itac'av ti Cajvaltique: ―Ta yutsil ―xchi. Yu'un ti hech itac'av ti Cajvaltique yu'un ac'o lajuc sc'opilal yu'un muc x'a'ibat sjam ti sc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hech iloc' batel ti Jesuse, ibat ti bu vits Olivatic sbi yu'un te ono'ox chc'otilan. Ichi'inat batel yu'un ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","C'alal ic'otic ti vits Olivatic, hech lic yalbe ti yajchanc'opetique ti Jesuse: ―C'oponic Dios hech mu xasujat ti mulil ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ja' ijelav batel jutuc stuc ti Jesuse. Hech snatil ijelav batel hech chaj c'u che'el ti jtentic batel ton. Laj squejan sba, lic sc'opon Dios. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Hech laj yalbe ti Diose: ―Tote, mi hech tsc'an ti avo'ntone, q'uejbun batel ti vocol li'to. Mu me jpas c'usi tsc'an co'nton. Ja' ac'o jpas ti c'usi sc'an ti avo'nton atuque ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ti Jesuse laj yil ch'ul abat. Ja' tacbil tal yu'un tal yac'bel yip ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mu xa xnel ti vocol laj ya'i hech yu'un más laj yac' persa laj sc'opon Dios. Ep ichiq'uinaj. Ti xchiq'ue hech chaj c'u che'el tsts'uj ch'ich'. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","C'alal laj yo'nton laj sc'opon Dios, isut talel yo' bu oyic ti yajchanc'opetique. Vayajtic c'ot staic yu'un ep chich'ic mul. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Hech lic yalbe: ―Mu xtun ti chavayic. Licanic, c'oponic Dios hech mu xasujat ti mulil ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","C'alal yac'oj sba chc'opoj ti Jesuse, ja' hech yorail ital ep crixchanoetic. Ja' jbaejbe tal ti Judase, ja' co'ol lajchavo'ic xchi'uc ti yan yajchanc'opetique. Ti Judase ihul ti stojol ti Jesuse, hech lic sbuts'. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Hech yu'un ti Jesuse lic yalbe: ―Judás, mu yu'unuc jun avo'nton ti jtojol ti chabuts'une. Ja' no'ox yu'un ti chavac'un entrecale, ho'on ti co'ol crixchanoucutique ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ti yajchanc'opetique ti te xchi'inojic ti Jesuse, c'alal laj sna' ti c'usi sventail ti italique, hech lic yalbeic ti Jesuse: ―Cajval, mi chac'an, chcac'betutic espada ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hech yu'un oy jun laj sloq'ues yespada. Hech laj sbojbe loq'uel jun xchiquin ti yabat ti totil palee. Ti xchiquin ti iloq'ue, ja' ti sbats'ic'ob. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Hech yu'un lic yal ti Jesuse: ―Mu me xapajesic. Ac'o spasic ti c'usi tsc'an yo'ntonique ―xut. Hech yu'un ti Jesuse laj spic ti bu yajem ti abate, ti ora ichop. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ti Jesuse hech lic yalbe ti totil paleetique xchi'uc ti totiletic ti ja' chchabiic ti temploe xchi'uc ti moletique ti te tal tsacvanuque: ―¿C'u yu'un hech tal atsacucun hech chaj c'u che'el j'elec'? Avich'ojic talel avespadaic ate'ic. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Scotol c'ac'al te oyun ti atojolic te ti templo. ¿C'u yu'un mu teuc laj atsacucun? Yu'un ti hech ihu' xa avu'unique ti ora to yu'un ac'bil lisensa ti avajvalique, ja' ti sventainoj ti mulile. Ja' ti Satanase ―xut ti much'utic tal tsacatuc yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hech laj stsaquic, laj yiq'uic batel ti Jesuse ti sna ti totil palee. Ti Pedroe nomtic to xbat. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Te ti yamaq'uil sna ti totil palee laj spasic c'oc' ti abatetique yu'un chc'atinic. Te laj snacan sbaic. Ti Pedroe laj xchi'in ti naclej ti yantic uque. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Oy jun quiara laj yil ti te nacal ti Pedroe. Yu'un chtil ti c'oq'ue, hech yu'un laj yil. Laj sq'uelilambe sat, hech lic yal: ―Avi to ja' xchi'il sbaic xchi'uc ti much'u tsacbile ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ti Pedroe laj smuc ti yo'nton, hech laj yal: ―Ti chavale, me'e, mu hechuc. Mu xcojtiquin ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Li' no'ox ti j'oq'ui i'ojtiquinat yu'un yan ti Pedroe. Hech i'albat: ―Ho'ot laj achi'in uc ―x'utat. Itac'av ti Pedroe: ―Mu ho'ucun, tote ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","I'ech' van jun ora, oy yan hech i'albat sc'opilal ti Pedroe. Hech laj yal: ―Melel cac'tic, ja' xchi'il sbaic avi to yu'un liquem tal ti Galilea uc ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Itac'av ti Pedroe: ―Tote, mu jna' ti c'usi chavale ―xchi. C'alal yac'oj sba chc'opoj ti Pedroe, ja' yorail ti i'oc' quelem. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hech yu'un ti Jesuse laj sjoyp'in sba, laj sq'uelbe sat ti Pedroe. Ti Pedroe it'ab ti yo'nton ti hech ono'ox i'albat yu'un ti Cajvaltique: “C'alal tsta yorail ch-oc' quelem, laj xa amucun ti avo'nton oxib vuelta”, ti x'utate. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hech yu'un iloc' batel ti Pedroe. Ep ba yoc'ta sba. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ti jayvo'ic ti jtsacvanejetique yu'un ti i'ac'batic xa entrecal, hech lic slabanic ti Jesuse, lic smajic. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Laj smacbeic sat ti poc', lic smajbeic sat, hech laj yalbeic: ―Alo ca'itutic, ¿much'u laj smajote? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ep laj slabanic. Ep ti c'usi chopol laj yalbeic. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","C'alal isacub ti osile laj stsob sbaic ti totiletic yu'un ti judioetique, ja' ti totil paleetique xchi'uc ti much'utic ichanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Laj yiq'uic tal ti stojolic ti Jesuse. Hech lic yalbeic: ");
INSERT INTO tzoNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Albun ca'itutic, ¿mi ho'ot ti Cristoote, ti t'ujbilot yu'un ti Diose? ―xchiic. Ti Jesuse hech lic yalbe: ―Mi chacalbeic ti ho'on Cristoune, mu yu'unuc chach'unic. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mi chajac'beic c'usi chanopic, mu xac'an chatac'avic. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ho'on ti co'ol crixchanoucutique yorail xa ti te chba naclucun ti sbats'ic'ob ti Diose yo' bu ti jpas ti mantal scotol ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Scotolic lic yalic: ―¿Mi yu'un ho'ot snich'onot ti Diose chacuy aba? ―xchiic. ―Ho'on ―xchi xtac'av ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Hech yu'un lic yalbe sbaic: ―¿C'u yu'un ti jc'antic yan rextico? Laj xa ca'itic ti c'usi chale ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Hech iliquic scotolic, laj yiq'uic batel ti Jesuse, c'ot sva'anic ti stojol ti Pilatoe. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Te lic sa'beic smul. Hech laj yalic: ―Avi vinic li'to ja' no'ox tstsob svinictac yu'un tsliques c'op li' ti jlumaltutique. Chal ti mu stac' chcac'betutic spatan ti totil ajvalil cu'untique, ja' ti Césare, yu'un ja' ajvalil scuyoj sba. Ja' ti Cristo scuyoj sbae ―xchiic. Ja' ti Cristo sbie ja' sjam ti ac'bil yabtel yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Hech yu'un ti Pilatoe hech lic sjac'be ti Jesuse: ―¿Mi ho'ot ajvalilot yu'un ti achi'iltaque, ho'oxuc ti judiooxuque? ―xut. Itac'av ti Jesuse: ―Ho'on ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ti Pilatoe hech lic yalbe ti totil paleetique xchi'uc scotol ti crixchanoetique: ―Mu jtabe smul avi vinic li'to ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yan vuelta hech lic yalic: ―Mu me xacolta batel yu'un tsoques ti jchi'iltaque. Chchanubtasvan ti scotol jlumal li' ti Judeae. Ti sliqueb te laj xchanubtas ti jchi'iltac te ti Galilea. Ti ora to talem li'to ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hech yu'un c'alal laj ya'i ti Pilatoe, “ti sliqueb te ichanubtasvan te ti Galilea”, ti xchiique, hech yu'un hech lic sjac'be mi te liquem tal ti Galilea ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","C'alal laj ya'i ti liquem tal ti Galilea ti Jesuse, hech laj sna' ti Pilatoe ti ja' oy ti sventa ti Herodese. Hech yu'un laj stac batel ti stojol ti Herodese yu'un tal ya'i paxyal te ti Jerusalén ti Herodese. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","C'alal laj yil ti Jesuse ti Herodese, nichim no'ox yo'nton. Yu'un ep xa c'ac'al tsc'an tsq'uelbe sat yu'un ep ya'yojbe sc'opilal ti Jesuse. “Taca jq'uel ti c'u che'el tspas junuc señail ti Jesuse”, xchi ono'ox ti yo'nton ti Herodese. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hech yu'un lic sjaq'uilambe ti Jesuse ti c'u che'el xu' yu'un tspas ti señailetique. Ti Jesuse mi jp'eluc muc xtac'av. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Te va'ajtic ti totil paleetique xchi'uc ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Liquem sjolic, toyol yo'ntonic tstic'beic smul ti Jesuse te ti stojol ti Herodese. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ti Herodese xchi'uc ti yajsoldadoetique muc spasic ti muc' ti Jesuse. Ja' no'ox laj slabanic, laj slapbeic c'u'il hech chaj c'u che'el tslapic ti ajvaliletique, ja' ti t'ujum no'ox ti jyalel ti c'u'ile. Patil hech lic staquic sut tal ti stojol ti Pilatoe. Slapoj tal ti c'u'ile ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Contra ono'ox yiloj sbaic ti Herodese xchi'uc ti Pilatoe. C'alal laj stac batel ti stojol ti Herodese ti Jesuse, hech lec lic sc'opon sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Hech yu'un ti Pilatoe laj yic' tal ti stojol ti totil paleetique xchi'uc ti yan totiletic te ti templo yu'un ti judioetique xchi'uc scotol ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Hech lic yalbe: ―Yu'un ti laj avaq'uic ti jtojol ti achi'il li'to yu'un “tsoques scotol ti jchi'iltaque”, ti xachiique, laj xa quich'be sc'op ti atojolic. Mi jutuc mu jtabe smul. Mu hechuc hech chaj c'u che'el chavalique. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hech uc ti Herodese muc stabe smul uc. Ti lajuc stabe smule, muc xcha'tac sut tal ti jtojol ti hechuque. A'yo me ava'yic, mu'yuc smul ti achi'il li'to yu'un chmilat. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hech yu'un ja' no'ox chcac'be castigo, patil ti jcolta batel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hech stalel o ti yorail q'uin tscolta batel jun jchuquel ti jujun habil ti gobernadore. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Hech yu'un tsots lic c'opojuc scotol ti crixchanoetique. Hech lic yalic: ―Ac'o chamuc ti cruz lume. Ja' ac'o coluc ti Barrabase ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ti Barrabase itic'at ochel ti chuquel scoj ti laj stsob svinictac, yu'un laj scontrain ti gobiernoe te ti Jerusalén. Imilvan uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ti Pilatoe yan vuelta lic sc'opon ti judioetique yu'un tsc'an tscolta batel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Yan vuelta tsots ic'opojic, hech laj yalic: ―¡Milo ti cruz! ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hech laj sjac'be: ―¿C'usi smul avu'unic? Mu jtabe smul yu'un chmilat. Hech yu'un chcac'be castigo, patil ti jcolta batel ―xut. Ja' yoxibal xa vuelta ti hech laj yalbe. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Más tsots i'avanic. Hech laj yalic: ―¡Milo ti cruz! ―xchiic. Yu'un ti hech isujvanique, hech ich'umbat sc'op ti crixchanoetique xchi'uc ti totil paleetic yu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hech yu'un ti Pilatoe laj yal mantal ti ac'o milatuc ti cruz ti Jesuse hech chaj c'u che'el laj sc'anique. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Hech laj scolta batel ti much'u laj sc'anique, ja' ti Barrabase, ja' ti itic'at ti chuquel yu'un laj stsob svinictac, laj scontrain ti gobiernoe. Imilvan uc. Laj yac' entrecal ti Jesuse yu'un ac'o c'otuc ti pasel ti c'usi tsc'an ti yo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hech yu'un ti soldadoetique laj yiq'uic batel ti Jesuse. C'alal xq'uechoj xa batel scruz ti Jesuse, hech laj stsaquic jun vinic. Ja' ch-och batel ti jteclum. Simón sbi ti vinique. Ja' judiovinic. Ja' liquem tal ti balumil Cirene sbi. Ja' laj yac'beic batel tsq'uech ti scruz ti Jesuse. Ja' baejem ti Jesuse. Patil chtal ti Simone sq'uechojbe tal ti scruz ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Laj sts'acliic batel ti Jesuse ep viniquetic xchi'uc ep antsetic. Ti antsetique ep laj yoc'taic ti Jesuse. Ep laj yich'ic mul yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ti Jesuse laj sjoyp'in sba hech laj yalbe: ―Ho'oxuc antsetic li' nacaloxuc ti Jerusalene, mu me xavoc'taun. Ja' xavoc'ta abaic xchi'uc avol anich'onic. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yu'un ta me sta yorail ti hech chalique: “Ja' lec ti much'utic mu'yuc yolique, hech mu'yuc c'usi chich' mul yu'un”, xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hech yu'un hech chlic yalic: “Taca but'q'uijuc tal ti vitse, hech ac'o sbuti'un”, xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ti ho'one ti jch'un scotol ti c'utic yaloj ti Diose. Pero ep chiyac'bucun quich' vocol. Buc xa ti ho'oxuque ti mu xac'an xach'unic ti c'utic yaloj ti Diose, ¡c'u che'el tsts'ic avu'unic ti vocole ti ta ono'ox xavich'ique! ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","I'ic'at batel uc cha'vo' judioviniquetic ti tsots smulique yu'un co'ol chba milatuc ti cruz xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","C'alal ic'otic ti bu Baquel Jolal sbi ti balumile, te c'ot jipanatuc ti cruz ti Jesuse xchi'uc ti cha'vo' viniquetic ti tsots smulique, jun ti sbats'ic'ob ti Jesuse, jun ti sts'et. Ja' cacal ti o'lol ti scruz ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ti Jesuse hech lic yal: ―Tote, pasbeic perdón yu'un scoj ti mu sna'ic ti c'usi tspasique ―xchi tsc'opon ti Diose. Hech ti soldadoetique lic spasic al chilic ti much'u chc'ot ti sventa ti sc'u' spoc' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Te va'ajtic chq'uelvanic tal ti crixchanoetique. Te va'ajtic uc ti totiletic te ti templo yu'un ti judioetique. Lic slabanic uc ti Jesuse. Hech laj yalic: ―Laj scolta yantic. Hech yu'un mi melel ti ja' ti Cristoe, ti ja' t'ujbil yu'un ti Diose, ac'o scolta sba quitic uc ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ilabanvan uc ti soldadoetique. Inopejic tal, tal yac'beic vinagre yu'un chuch' yu'un mu me xcham ti ora. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Hech laj yalbeic: ―Mi melel ti ho'ot totil ajvalilot yu'un ti achi'iltaque, ho'oxuc ti judiooxuque, coltao aba quitic ―xutic. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Oy jun pac'bil ti sjol scruz ti Jesuse. AVI TO JA' TI TOTIL AJVALIL YU'UN TI JUDIOETIQUE, xchi ts'ibabil. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Te co'ol jipajtic xchi'uc ti Jesuse ti viniquetic ti tsots smulique. Ti june laj stoy sba ti stojol ti Jesuse, hech laj yalbe: ―Mi melel ti Cristoote, ti t'ujbilot yu'un ti Diose, coltao aba quitic. Coltauntutic uc ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Itac'av ti yane, laj spajesbe ye ti xchi'ile. Hech laj yalbe: ―¿Mi mu xaxi' ti Diose? Co'ol chquich'tic vocol xchi'uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ho'ucutic oy jmultic hech yu'un chquich'tic vocol ti ora to yu'un chijyac'bucutic jtojtic ti c'utic laj jpastique. Ti vinic li'to mu'yuc c'usi chopol spasoj ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ti vinique hech lic yalbe ti Jesuse: ―Cajval, na'un me c'alal chtal apas mantal li' ti balumile ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ti Jesuse hech laj yalbe: ―Melel ti c'usi chacalbee, ti ora to chachi'inun batel ti vinajel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","C'alal laj sta o'lol c'ac'al, i'ic'ub ti osile ti sjoylejal balumil. Ic'uben icom oxib ora. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tup'en ti c'ac'ale. Ti velo ti te joc'ol ti yut templo te ti Jerusalene, ja' ijat ti o'lol. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tsots ic'opoj ti Jesuse, hech laj yal: ―Tote, chcac' ti ac'ob ti jch'ulele ―xchi. C'alal laj yal hech ti Jesuse, icham. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","C'alal laj yil ti capitan soldadoe ti hech ic'ot ti pasele, lec ic'opoj yu'un ti Diose. Hech laj yal: ―Melel ti mu'yuc smul avi vinic li'to ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Scotol ti crixchanoetique ti te stsoboj sbaique, c'alal laj yilic ti icham xa ti Jesuse, isutic batel ti snaic. Yu'un ep chich'ic mul, hech yu'un yac'oj sba tsmajilan sti' yo'ntonic ti c'alal isutic batel. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Scotol ti much'utic lec laj sc'opon sbaic xchi'uc ti Cajvaltique xchi'uc ti yajchanc'opetic ti Cajvaltique xchi'uc ti antsetique ti te iloc' tal ti Galilea ichi'inat tal ti Jesuse, nom va'ajtic te tsq'uelic scotol. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Te oy jun vinic José sbi. Ja' liquem tal ti jteclum Arimatea sbi te oy ti estado Judea. Ja' totil te ti templo te ti Jerusalén ti Josee. Lec yo'nton. Ja' yac'oj sba tsmala ti chtal spasucutic ti mantal ti Diose. Toj yo'nton, hech yu'un mu laj stic' sba ti c'op c'alal laj xchapanic ti Jesuse ti yan totiletic te ti templo. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ja' ba sc'opon ti Pilatoe. Laj sc'ambe stacopal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yu'un i'ac'bat lisensa yu'un ti Pilatoe, hech yu'un ba sloq'uesbe ti cruz ti stacopal ti Jesuse. Laj xpix ti saquil poc'. Ja' laj stic' ti ach' ch'en ti bu pasbil yu'une. Jombil ti ton ti ch'ene. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ja' ti mal c'ac'al ti viernes ti imucate. Ja' yorail chchapan sbaic yu'un ti yoc'omal ja' sc'ac'alil chcux yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ti antsetic ti te iloc' tal ti Galilea ichi'inat tal ti Jesuse, te ibatic ti ch'en uc. Laj sq'uelic ti bu itic'at ochel ti stacopale. ");
INSERT INTO tzoNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Isutic batel ti snaic. Hech yu'un ti c'alal ic'otic ti snaique, ti ora lic xchapanic vomoletic xchi'uc perfume yu'un yorail xa chlic ti chcux yo'ntonique hech chaj c'u che'el chal ti mantaletique. Ti vomoletique xchi'uc ti perfumee ja' chba yac'beic ti Cajvaltique yu'un mu me xtuib ti ora. Ja' stalel hech tspasic ti judioetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ti sba c'ac'alil ti semana, ja' ti domingoe, c'alal ta xa sacub xa tal ti osile, tal sq'uelic ti ch'en ti antsetique. Yich'ojic tal ti vomoletique xchi'uc ti perfumee ti laj xchapanique. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Te c'alal ic'otique, balch'umbil xa loq'uel ti tone ti smac ti ti'ch'ene c'ot staic. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","C'alal i'ochic ti yut ch'en, mu'yuc xa te ti sbec'tal ti Cajvaltic Jesuse c'ot staic. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","C'alal yac'oj sba chlo'laj yo'ntonic, laj yilic ti te va'ajtic ti sts'elic cha'vo' viniquetic x'elan. Lum sac ti sc'u'ique chtup' jsatic yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Toj xi'el ic'otic ti antsetique, laj snijan sbaic. Hech ijac'batic: ―¿Mi tal to aq'uelbeic sbec'tal li'i? ¿Mi mu xana'ic ti icha'cuxi xa loq'uel? ");
INSERT INTO tzoNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mu xa li'uqui ti Cajvaltique yu'un cha'cuxem xa loq'uel ti ch'en. Na'ic me ti hech chaj c'u che'el laj yalboxuque c'alal te oyoxuc ti Galilea xchi'uque. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Hech laj yal: “Ja' persa chi'ac'at entrecal ti sc'ob jmulaviletic, ho'on ti co'ol crixchanoucutique. Chismilucun, patil chismucucun. Ti yoxibal c'ac'al chicha'cuxi”, ti xayutoxuque ―xchiic ti viniquetic ti lum sac sc'u'ique. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hech lic sna'ic ti antsetique ti hech ono'ox i'albatique. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Hech iloq'uic ti ch'en, isutic batel, ba xcholbe ya'yic ti buluchvo' yajchanc'opetic ti Jesuse xchi'uc ti yantique scotol ti c'utic i'albatique. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ja' ti antsetique ti ba yalbe ti jcholc'opetique, ja' ti María ti liquem tal ti Magdalae, xchi'uc ti Juanae, xchi'uc ti yan Maríae, ja' ti sme' ti Jacoboe, xchi'uc ti yan antsetic ti xchi'inojic uque. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ti jcholc'opetique laj scuyic ti hech no'ox chalic ti antsetique, muc spasbeic ti muc' ti sc'opique. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ja'uc ti Pedroe ilic ti ora, anil ibat ti yo' bu ti ch'ene. Laj sq'uel ochel ti yut, laj yil ja' xa no'ox te oy ti poq'ue, ja' ti xpix ti sbec'tal ti Cajvaltique. Mu xa teuc ti sbec'tal ti Cajvaltique. Hech yu'un ti Pedroe c'alal isut batel ti sna, ep ilo'laj yo'nton batel yu'un melel ti mu xa teuque. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti yorail iloc' ti ch'en ti Cajvaltique, ti mal c'ac'al oy cha'vo' ti much'u xch'unojbeic sc'op ti Jesuse iloq'uic batel ti Jerusalén hech ixanavic batel ti sbelal Emaús. Ja' biq'uit jteclum ti Emause. Oy van chibuc legua chil sbaic xchi'uc ti Jerusalene. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yac'oj sba tslo'iltabe sbaic batel ja' ti c'u che'el imilat ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","C'alal hech yac'oj sba chlo'lajic, te ital ti spatic ti Jesuse. Hech laj xchi'inic batel ti be. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ti xcha'va'alique ja' macbilic satic yu'un ti Diose hech yu'un muc xojtiquinic ti ja' ti Jesuse ti xchi'inojic batel ti bee. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hech ijac'batic yu'un ti Jesuse: ―¿C'usi ti chalo'iltaique? ―x'utatic yu'un ti Jesuse. Hech iva'iic. Laj yil ti Jesuse ti ep chich'ic mul. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Hech itac'av ti june, ja' ti Cleofas sbie: ―Scotol ti jchi'iltique ti li' talemic ti Jerusalene yu'un tal sq'uelic ti q'uine, ya'yojic ti c'usi ic'ot ti pasel chabje li' ti Jerusalene. ¿C'u yu'un muc xava'i ho'oti? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Hech itac'av ti Jesuse: ―¿C'usi ic'ot ti pasel? ―xchi. Hech itac'avic: ―Ja' ti imilat ti Jesuse, ja' ti liquem tal ti Nazarete. Ja' ti j'alc'op yu'un ti Diose. Yu'un coltabil yu'un ti Diose, hech yu'un lec ichanubtasvan. Oy yip ti sc'ope. Ihu' yu'un laj spas ep jchop o abteletic. Lec i'ilat yu'un scotol ti jchi'iltique. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ja' i'ac'van entrecal ti totil paleetique xchi'uc ti totiletic te ti templo cu'untique. Te ichapaj sc'opilal te ti stojol ti gobernadore ti persa chchame. Hech laj smilic ti cruz. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ti ho'ontutique laj jch'untutic ti ja' Jcoltavanej cu'untic, ho'ucutic ti yelnich'onucutic ti Israele. Ja' its'aqui xa yoxibal c'ac'al o to ti imilate. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nax ich'ay co'ntontutic yu'un ti c'usi laj yalbuntutic ti antsetique, ja' ti co'ol jchi'inojtutic ti Jesuse xchi'uque. Yu'un i'ayic ti ch'en sob ic'luman nax, ba sq'uelic ti stacopal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mu'yuc xa te c'ot staic. Hech yu'un c'alal laj yilic ti mu xa teuque, hech isutic batel ba yalbuntutic. Te oy la ch'ul abatetic laj yilic uc. I'albatic yu'un la ti cha'cuxem xa ti Cristoe. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Oy ibatic ti jchi'iltaque, ba sq'uelic ti ch'ene. Hech chaj c'u che'el laj yalic ti antsetique, hech la oy. Pero mu'yuc bu laj yilic ti Jesuse ―x'utat ti Jesuse yu'un ti cha'vo'ique. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Hech yu'un ti Jesuse hech lic yalbe: ―Mu p'ijucoxuc. Vocol chach'unic scotol ti c'usi yaloj ti j'alc'opetic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mi mu hechuc chal ti j'alc'opetique ti persa chich' vocol ti Cristoe yu'un hech ch-ac'at ti pasel ti muc'? ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ti Jesuse hech xmelmun lic yac'be sna'ic scotol ti butic hech chal ti sc'op ti Diose ti persa ta ono'ox xich' vocole. Ja' ti ts'ibabil yu'un ti Moisese xchi'uc scotol ti yan j'alc'opetic yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hech ic'otic ti Emaús. Hech yu'un ti Jesuse stuc xa no'ox sc'an chjelav batel. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Hech yu'un ti cha'vo' viniquetique laj spajesic ti Jesuse. Hech laj yalbeic: ―Li' no'ox comani yu'un mal xa c'ac'al. Po'ot xa ch-ic'ub ti osile ―xchiic. Hech laj xch'un ochel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","C'alal xchi'inojic ti naclej ti mesae, laj stsac ti caxlan vaje ti Jesuse, laj yalbe vocol Dios, laj xet' ti caxlan vaje, laj yac'be. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hech yu'un ti c'alal hech laj spas ti Jesuse, hech lic ac'batuc yojtiquinic yu'un ti Diose. Ti ora ich'ay ti satic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hech lic yalbe sbaic: ―¿C'u che'el muc sut co'ntontic ti ja' ti Cajvaltique yu'un imuc'ub co'ntontic ti c'alal laj yalbucutic ti sjam ti sc'op Diose ti c'alal jchi'inojtic tal ti be? ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yu'un ti laj xa yilic ti cha'cuxem xa ti Cajvaltique, hech yu'un isutic batel ti ora ti Jerusalén. Yu'un tsc'an chba yalbe ya'yic ti xchi'iltaque ti co'ol xch'unojic xchi'uque. Te stsoboj sbaic ti buluchvo' yajchanc'op ti Jesuse xchi'uc oy yan xchi'iltac c'ot staic. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","C'alal ic'otic ti cha'vo'ique, hech i'albatic yu'un ti xchi'iltac ti te oyic ti Jerusalene: ―Melel ti cha'cuxem xa ti Cajvaltique. Laj xa yac' sba ti q'uelel ti stojol ti Simon Pedroe ―x'utatic yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hech yu'un uc ti cha'vo'ique hech lic xcholbe ya'yic ti c'u che'el ilo'lajic ti be xchi'uc ti Jesuse, ti ja'to c'alal laj xet' ti caxlan vaje ja'to laj yojtiquinic. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","C'alal yac'oj sba tsc'opon sbaic, ti ora va'al ihul ti stojolic ti Jesuse yo' bu stsoboj sbaique. Hech laj yalbe: ―Tal jtoj avo'ntonic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Toj xi'el ic'otic. Laj scuyic ti ch'ulelal ti c'alal laj yilique. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ti Jesuse hech laj yalbe: ―¿C'u yu'un chaxi'ic? ¿C'u yu'un hech chanopic? ");
INSERT INTO tzoNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Q'uelo ti jc'obe, q'uelo ti cacane. Ho'on chavil. La' picucun. Ti ch'ulelalucune, mu'yuc jbec'tal mu'yuc jbaquel ti hechuque ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","C'alal hech laj yal, laj yac' ti q'uelel ti sc'obe, ti yacane. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ti c'alal laj yilique, nichim no'ox yo'ntonic. Ich'ay yo'ntonic uc, hech yu'un mu sna' c'usi chch'unic mi melel ti cha'cuxem xae. Hech yu'un ti Jesuse lic sjac'be: ―¿Mi oy jutuc ve'elil avich'ojic tal? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Hech yu'un laj yac'be jtuch' vobilal choy yu'un tsti'. Laj yac'be jtuch' colomen tslo'. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ti satilal laj stsac ti ve'elil ti Jesuse, lic ve'uc. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Hech lic yalbe: ―Hech ono'ox laj calboxuc ti c'alal jchi'inojoxuque ti persa chc'ot ti pasel scotol ti c'u che'el ts'ibabil comel jc'opilal ti sun ti Moisese xchi'uc ti sun ti yan j'alc'opetic yu'un ti Diose xchi'uc ti sunal ti q'uejojetique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hech yu'un i'ac'bat sp'ijil yo'ntonic yu'un ti Cajvaltique ic'ot ti yo'ntonic ti hech ono'ox ts'ibabil comel sc'opilal te ti sc'op ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Hech lic yalbe uc: ―Hech ts'ibabil uc ti sc'op ti Diose. Persa ch-ech' jvocol ti ho'on ti Jcoltavanejune. Pero persa chicha'cusesat ti yoxibal c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Hech yu'un persa chcholbatic scotol crixchanoetic ti mi tsutes yo'ntonic yu'un ti smulique, mi chch'unic ti ho'on Jcoltavanejun yu'unique, hech chch'aybat smulic. Ja' jbael chcholbatic ti much'utic li' nacajtic ti Jerusalene. Patil xmelmun chcholbatic scotolic ti sjoylejal balumil, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ho'oxuc rexticooxuc yu'un laj xa aq'uelic scotol. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A'yo me ava'yic, chajtacboxuc yal tal ti Ch'ul Espíritue ti ja' yaloj ti Jtotique ti chayac'boxuque. Mu to me xba apuc ti jc'opilale. Li'tono'oxaniqui li' ti Jerusalene ja'to mi iyal xa tal ti Ch'ul Espíritue. Ja' chtal nojuc ti avo'ntonic hech ch-an yip ti avo'ntonique ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ti yan c'ac'al ti Jesuse laj yic' loq'uel ti Jerusalén ti yajchanc'opetique. Ja' laj stamic batel ti sbelal ti biq'uit jteclum Betania sbi. Hech yu'un hech lic stoy sc'ob ti Jesuse, laj yac'be bendición ti yajchanc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","C'alal yac'oj sba chac'be bendición ti yajchanc'opetique, ip'evat ti Jesuse, i'ic'at batel ti vinajel. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","C'alal laj sq'uelic ti imu batel ti vinajel ti Cajvaltique, ech'em laj spasic ti muc'. Hech nichim no'ox yo'ntonic isutic batel ti Jerusalén. ");
INSERT INTO tzoNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Scotol c'ac'al te ibatilanic ti templo te o. Nichim no'ox yo'ntonic hech laj yalilambeic ti Diose: ―Hocol aval ti laj xa acoltauntutique ―xchiic.");
INSERT INTO tzoNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","C'alal mu to oyuc ti vinajele ti balumile, stalel te ono'ox oy ti much'u tal yalbucutic c'u x'elan yo'nton ti Jtotic Diose. Te ono'ox oy xchi'uc ti Jtotic Diose. Ja' Dios ti tal yalbucutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","C'alal mu to oyuc ti vinajele ti balumile, te ono'ox oy xchi'uc ti Jtotic Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Scotol ti c'utic oye ja' yabtel. Mu'yuc much'u yan laj spas ti c'utic oye, stuc laj spas scotol. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Stuc ja' j'ac'cuxlejal. Yu'un laj yac'bucutic jna'tic ti ja' chijcuxiucutic sbatel osil ti sventa, hech yu'un ja' c'oc' ic'ot cu'untic ti ho'ucutic ti li'oyucutic ti balumile ti oyucutic ti ic' osil ti scoj ti mulile. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ja' hech chaj c'u che'el ti c'oq'ue chac' squeval ti ic' osil mu xtup' yu'un ti ic' osile, ja' no'ox hech manchuc mi mu xc'anat yu'un crixchanoetic, ja' yac'oj sba chijyac'bucutic jcuxlejaltic sventa sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Oy to ono'ox jun jchi'iltutic, Juan sbi. Ja' i'ac'bat yabtel yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Lic xcholbe sc'opilal ti c'oq'ue yu'un hech ac'o xch'unic crixchanoetic ti sventa ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ma'uc c'oc' stuc ti Juane. Ja' no'ox yich'oj tsots yabtel chcholbe sc'opilal ti c'oq'ue. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yu'un c'alal yac'oj sba chcholbat sc'opilal yu'un ti Juane, chtal xa ti balumil ti c'oq'ue, ja' ti j'ac'cuxlejale, ja' ti chijp'ijub ti sventae. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","I'ay ti balumil. Ti balumile ja' pasbil yu'un. Muc x'ojtiquinat yu'un ti crixchanoetique ti li'oyic ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tal xchi'inuntutic ti ho'ontutic ti yelnich'onuntutic ti Israele, ti ho'ontutic ti t'ujbiluntutic yu'un ti vo'one. Mu laj jpastutic ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero scotol ti much'u ipasvan ti muq'ue, ja' ti much'utic laj xch'unic ti ja' ac'bil yabtel yu'un ti Diose ti ja' Jcoltavanej cu'untic ic'ot, albil sc'opilal ti yol snich'on Dios ic'otic. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ti much'u hech inich'ontasatic yu'un ti Diose, mu xco'olaj xchi'uc hech chaj c'u che'el ti inich'ontasatic yu'un stot sme'. Yu'un ja' no'ox sventa xcuxlejalic li' ti balumile. Yu'un ja' no'ox hech laj sc'an yo'ntonic, laj sc'an sbec'talic ti stot sme'ique. Ja'uc ti chnich'ontasatic yu'un ti Diose, ja' sventa sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ti much'u tal yalbucutic c'u x'elan yo'nton ti Jtotic Diose laj yich' sbec'tal. Tal xchi'inuntutic, ho'ontutic ti yelnich'onuntutic ti Israele. Ja' ti Jesucristoe. Laj jq'ueltutic ti jelaven sp'ijile. Ja' jelaven sp'ijil yu'un ja' Snich'on ti Jtotic Diose. Jun no'ox Snich'on oy ti Jtotic Diose. Nojem ti yo'nton ti yutsil yo'ntone. Nojem ti yo'nton ti toj chc'opoje. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ti Juane laj xcholbe sc'opilal. Tsots ic'opoj ti Juane, hech laj yal: ―Li'to ja' ti much'u laj calboxuc ava'yic sc'opilal ti much'u patil chtale. Ja' tsots yabtel yich'oj, xichi. Ho'oni mu tsotsuc cabtel quich'oj. Yu'un c'alal mu to oyucun, stalel te oy stuc, xichi ―xchi ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nojem ti yo'nton ti yutsil yo'ntone. Jcotoltic oy quich'ojbetic. Yac'oj sba chijyac'bucutic yutsil co'ntontic. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ho'ontutic ti judiountutique ti sventa ti antiguo jtatamoltutic Moisese laj ca'ibetutic ti smantal ti Diose. Ti sventa ti Jesucristoe laj quiltutic ti oy yutsil yo'nton ti Diose cu'untic jcotoltic. Ja' ti sventa ti Jesucristoe ti hech laj ca'itutic ti sc'op Diose ti ja' melele. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mi junuc mu'yuc much'u sq'uelojbe sat ti Diose. Ti Snich'on ti Diose, jun no'ox snich'on oy, ja' ti lum c'uxubimbil yu'un ti Jtotic Diose, ja' laj xa yac'bucutic cojtiquintic c'u x'elan ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ti jchi'iltutique ti te oyic ti Jerusalén ho'ontutic ti co'ol judiountutic xchi'uque, ja' laj staquic talel paleetic xchi'uc levitaetic, ja' ti oy yabtelic uc te ti templo te ti Jerusalén. Ja' tal sjac'beic ti Juane: ―¿Much'uot ho'oti? ¿Mi ho'ot ti ac'opilal chatale? ―xchi c'otel. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jamal laj yal ti Juane: ―Ho'oni mu Cristoucun, mu ho'ucun jcoltavanejun ti sc'opilal chtale ―xchi xtac'av ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Laj xcha'jac'beic nixtoc: ―¿Much'uot? ¿Mi Eliasot? ―xchiic. Itac'av ti Juane: ―Mu ho'ucun ―xchi xtac'av ti Juane. ―¿Mi mu ho'ucot ti j'alc'opot yu'un ti Diose ti jmalatutique? ―xchi sjaq'uic. ―Mu ho'ucun ―xchi xtac'av ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Laj sjac'beic: ―¿Much'uot che'e? Albun ca'itutic hech chcalbetutic ti much'utic laj stacuntutic talele. ¿C'usi avabtel? Albun ca'itutic che'e ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Itac'av ti Juane: ―Ho'on jc'opilal ti laj yal ti Isaíase ti vo'one. Hech laj yal: Chtal ti much'u tsots chc'opoj ti xocol balumil. Hech chal: “Chtal xa ti Cajvaltique, hech yu'un comesic ti c'usi chasbolibtasoxuque”, xchi, xchi ti Isaíase. Ja' jc'opilal ―xchi ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ti much'u itacatic tale, ja' fariseoetic. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Hech yu'un laj sjac'beic ti Juane: ―¿C'u yu'un chavac' ich'ho' mi mu Cristoucot, mi mu Elíasucot, mi mu j'alc'opucot yu'un ti Diose? ―xchi sjaq'uic. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Itac'av ti Juane: ―Ho'oni ja' no'ox cabtel chcac' ich'ho'. Ja'uc ti much'u tsots yabtel yich'oje te achi'inojic. Mu xavojtiquinic. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ja' ti much'u patil chtale. Ho'oni mu'yuc cabtel ti stojol. Ma mi sjitumbeluc yaq'uil sempat, mu'yuc c'usi xu' ti jcolta mi jutuc ―xchi xtac'av ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hech ic'ot ti pasel ti balumil Betábara sbi te ti jech uc'um Jordán, ja' ti bu laj yac' ich'ho' ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ti yoc'omal laj yil ti Juane ti chtal ti stojol ti Jesuse. Ti Juane hech laj yalbuntutic, ho'ontutic ti te jchi'inojtutique: ―Q'uelo avil, li' chtal ti much'u ac'bil yabtel yu'un ti Diose. Ja' scarnero ti Diose ti chmilat yu'un hech chch'ay ti jmultique jcotoltic xchi'uc ti sjoylejal balumil ―xiyutuntutic―. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Li'to ja' ti laj jcholboxuc sc'opilale. Hech laj cal: “Ja' patil chtal ti much'u baejem cu'une. Yu'un c'alal mu to oyucun, stalel te oy stuc”, xichi ―xiyutuntutic ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Hech laj yal uc ti Juane: ―Ho'on uqui muc xcojtiquin jtuc ti ja' ti Jcoltavanej cu'untic jcotoltique. Ja'to c'alal laj yac'bun quil ti Diose, ja'to laj cojtiquin. Yu'un ti nital ho'oni, ti tal cac' ich'ho'e, yu'un hech chavojtiquinic, ho'ucutic ti yelnich'onucutic ti Israele ―xiyutuntutic ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Hech laj yal uc ti Juane: ―Laj quil iyal tal ti vinajel ti Ch'ul Espíritue. Jun to culajte x'elan te ic'ot ti stojol. Te icom. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ho'oni muc xcojtiquin. Ti Diose ti ja' laj yac'bun cabtele yu'un tal cac' ich'ho', hech laj yalbun: “Ti much'u chc'ot ti stojol ti Ch'ul Espíritue, te chavil chcom ti stojol, ja' ti much'u chayac'boxuc avich'ic ti Ch'ul Espíritue”, xiyutun ―xchi ti Juane―. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ho'on quiloj. Calojboxuc ava'yic ti ja' ti Snich'on ti Diose avi to ―xiyutuntutic ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ti yoc'omal te jchi'inojtutic ti Juane cha'vo'untutic ho'ontutic ti yajchanc'opuntutic ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ti Juane laj yil te chanav ech'el ti Jesuse. Hech laj yalbuntutic ti Juane: ―Q'uelo avil, ja' scarnero ti Diose ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","C'alal laj ca'itutic ti hech laj yal ti Juane, ho'ontutic ti yajchanc'opuntutique laj jts'aclitutic batel ti Jesuse ti cha'vo'untutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ti Jesuse laj sjoyp'in sba. Laj yil te xa xibatutic ti spat. Laj sjac'buntutic: ―¿C'usi chasa'ic? ―xiyutuntutic. Nitac'avtutic: ―Rabí, ¿bu nacalot? ―xichitutic. (Ja' Rabí co'ol sjam xchi'uc Maestro.) ");
INSERT INTO tzoNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ti Jesuse hech laj yalbuntutic: ―La' q'uelo avil ―xiyutuntutic. Laj jchi'intutic batel, ba jq'ueltutic bu nacal ti Jesuse. Te laj jchi'intutic ti vayel yu'un tsc'an xa chib ora ch-ic'ub ti osile. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ti jchi'il ti co'ol laj ca'ibetutic sc'op ti Juane xchi'uque, ti co'ol laj jts'aclitutic batel ti Jesuse xchi'uque, ja' Andrés sbi. Ti Andrese oy sbanquil. Simón Pedro sbi ti sbanquile. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ti ora ba sta ti sbanquile, ja' ti Simone. C'ot yalbe: ―Jtaojtutic xa ti Mesíase ―xchi. (Ja' Mesías co'ol sjam xchi'uc Cristo, ja' ti ac'bil yabtel yu'un ti Diose ti chijcol yu'une.) ");
INSERT INTO tzoNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ti Andrese laj yic' tal ti stojol ti Jesuse ti sbanquile. Ti Jesuse laj sq'uelbe sat ti Simone, hech laj yalbe: ―Ho'ot Simonot, snich'onot Jonás. Cefas chacac'bot abi ―xchi. (Ja' Cefas ti jc'optutique ja' Pedro ti griego-c'op. Ja' ton xchi ti sbi ti i'ac'bate.) ");
INSERT INTO tzoNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ti yoc'omal laj snop ti Jesuse ti chbat ti estado Galilea. C'alal mu to chloc' batel, laj sta jun jchi'iltutic, ho'ontutic ti co'ol judiountutic xchi'uque. Felipe sbi ti vinique. Hech laj yalbe: ―La' chi'inun batel ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ti Felipee liquem tal ti jteclum Betsaida sbi. Co'ol slumal xchi'uc ti Andrese xchi'uc ti Pedroe. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ti Felipee ba sa' ti Natanaele. C'ot yalbe: ―Jtaojtutic xa ti much'u ts'ibabil comel sc'opilal ti sun ti antiguo jtatamoltic Moisese xchi'uc ti sun ti j'alc'opetic yu'un ti Diose. Ja' Jesús ti liquem tal ti Nazarete. Ja' snich'on ti Josee ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Lic tac'avuc ti Natanaele: ―Mu'yuc bu chca'itic ti oy much'u lec chloc' tal ti Nazarete ―xchi. Itac'av ti Felipee: ―La' me, q'uelo avil ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ti Jesuse laj yil ti chtal xa ti stojol ti Natanaele. Hech laj yal ti Jesuse: ―Q'uelo avil, ti jchi'iltic ti chtal xae ja' toj yo'nton mu sna' xlo'lavan ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Hech itac'av ti Natanaele: ―¿C'u che'el chavojtiquinun? ―xchi. Itac'av ti Jesuse: ―Laj quilot te oyot ti yolon igote' c'alal mu to chba yic'ot talel ti Felipee ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Hech i'albat yu'un ti Natanaele: ―Maestro, ho'ot Snich'onot ti Diose. Ho'ot cha'och ti ajvalil cu'untutic, ho'ontutic ti yelnich'onuntutic ti Israele ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ti Jesuse laj yalbe: ―Yu'un ti laj calbot ti laj quilot te oyot ti yolon igote', chach'un ti oy cabtel. Lec ti hech chach'une. Ti yan c'ac'al más chavil ti jelaven jp'ijile ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ti Jesuse hech lic yalbuntutic jcotoltutic: ―Melel ti c'usi chacalboxuque, chavilic chjam ti vinajele. Chavilic xch'ul'abat ti Diose chmuic chyalic ti jtojol, ho'on ti co'ol crixchanoucutique ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","C'alal i'ech' xa chib c'ac'al ti laj sta ti Felipee xchi'uc ti Natanaele ti Jesuse, oy much'u chnupun te ti jun jteclum te ti estado Galilea. Caná sbi ti jteclume. Te tal sq'uel jnupunel uc ti sme' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ni'ic'atutic ti sq'uelel jnupunel uc xchi'uc ti Jesuse ho'ontutic ti yajchanc'opuntutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","C'alal te oyuntutic ti q'uin nupunel, ilaj ti ya'lel sat uvate' yu'unique. Ti sme' ti Jesuse tal yalbe ti yole: ―Ilaj xa ti ya'lel sat uvate' yu'unique ―xchi hulel. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ti Jesuse hech laj yalbe: ―Mu aventaucun, me'e. Mu to tsta yorail cu'un ―xchi xtac'av ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ti sme'e hech ba yalbe ti mozoetique: ―Pasic me scotol ti c'usi chayalboxuque ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Te vaxajtic vaquib muc'tic p'in yav ca'altutic yu'un ti jpoc jc'obtutic cacantutic. Ja' hech jtaleltutic ti jpastutic ho'ontutic ti judiountutique. Chib oxib q'uib ch-och ya'lel ti jujun p'ine. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ti Jesuse hech laj yalbe ti mozoetique: ―Nojeso ti ho' ti p'inetique ―xut. Hech yu'un laj snojes, lec nojem c'alal ti sti'il. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ti Jesuse hech laj yalbe: ―Lupic batel. Ac'bo ti much'u sventainoj scotol sq'uelel ti ve'elile ―xut. Hech yu'un ba yac'beic. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ti much'u sventainoj scotol sq'uelel ti ve'elile, c'alal laj ya'i ti más chi' to nixtoc ti ho' yu'un c'atajesbil ti ya'lel sat uvate'e, mu sna' bu talem ti ya'lel sat uvate'e. Stuc no'ox sna'ojic ti mozoetique ti puru ho' ti c'alal laj slupic loq'uele. Hech yu'un ti much'u sventainoj scotol sq'uelele laj yic' talel ti jnupunele. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Hech laj yalbe: ―Ti yantic crixchanoetique jbael chac' ti uch'el ti lequil ya'lel sat uvate'e. Mi ep yuch'ojique, patil chac' ti ya'lel sat uvate'e mu co'oluc xchi'uc ti leque. Ho'oti aq'uejoj ti lequil ya'lele ja'to ti ora to ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Hech ic'ot ti pasel ti jteclum Caná te ti estado Galilea. Ja' sba vuelta laj yac' svinajeb ti jelaven sp'ijil ti Jesuse. Hech yu'un ti ho'ontutic ti yajchanc'opuntutique laj jch'untutic ti ja' ti Snich'on ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Patil niyaltutic batel ti jteclum Capernaum xchi'uc ti Jesuse. Laj jchi'intutic batel ho'ontutic ti yajchanc'opuntutique xchi'uc ti sme'e xchi'uc ti yits'inabtaque. Chib oxib c'ac'al no'ox te nihalejtutic te ti Capernaum. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Po'ot xa tsta yorail q'uin Pascua sbi. Ja' q'uin ti jpastutic ho'ontutic ti judiountutique yu'un ti jna'tutic ti c'usi ora ijelav ti xch'ul'abat ti Diose ti vo'one te ti balumil Egipto. Nimututic batel ti Jerusalén xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Te ti sjoylejal yamaq'uil ti templo te ti Jerusalén c'ot jtatutic ti jchonvacaxetique xchi'uc ti jchoncarneroetique xchi'uc ti jchonculajteetique. Te c'ot jtatutic uc ti jeltaq'uinetique nacajtic yac'oj sba ch-abtejic. Yu'un ti templo cu'untutic te ti Jerusalene ja' te chismililambuntutic ti smoton ti Diose ti paleetic cu'untutique hech chaj c'u che'el yalojbuntutic ono'ox ti Diose, ho'ontutic ti judiountutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hech yu'un ti lazo laj spas yacial ti Jesuse. Laj snuts loq'uel scotol ti jchoncarneroetique xchi'uc ti jchonvacaxetique ti te oyic ti yamaq'uil ti temploe. Hech nutsbilic iloq'uic batel xchi'uc scarneroic xchi'uc xvacaxic. Ti Jesuse laj sbut'q'uimbe smesaic ti jeltaq'uinetique hech ibusq'uij batel ti staq'uinic ti jeltaq'uinetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Hech laj yalbe ti jchonculajteetique: ―Iq'uic loq'uel ti amute. Ti sna ti Jtote mu me xac'atajesic ti plaza ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","C'alal hech laj spas ti Jesuse, ti ho'ontutic ti yajchanc'opuntutique it'ab ti co'ntontutic ti hech ts'ibabil comel ti sc'op ti Diose: “Yu'un ti toyol co'nton yu'un ti anae, ta ono'ox chlic quich' contrainel”, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hech lic yalbeic ti Jesuse ti totiletic yu'un ti muc'ta temploe: ―¿Much'u laj yac'bot avabtel yu'un chanuts loq'uel ti yamaq'uil templo ti jchonolajeletique? Ac'bun jq'ueltutic jchop o abtel yu'un hech ti jna'tutic ti oy avabtele ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Hech itac'av ti Jesuse: ―Jinic ti templo li'to, ti oxib no'ox c'ac'al ti jcha'pas nixtoc ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hech i'albat yu'un ti totiletique: ―Vaquib yoxvinic habil imeltsaj ti templo li'to. ¿Bu ba hu'uc avu'un chacha'pas nixtoc ti oxib no'ox c'ac'al chavale? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ja' ti templo li'to xchie, ja' laj yalbe sc'opilal ti sbec'tale. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hech yu'un ti c'alal icha'cuxi loq'uel ti ch'en ti Jesuse, ti ho'ontutic ti yajchanc'opuntutique it'ab ti co'ntontutic ti hech ono'ox laj yalbe ti totiletique. Ja' yorail ti laj jch'untutic ti c'u che'el ts'ibabil sc'opilal ti sc'op ti Diose ti chcha'cuxi loq'uel ti ch'ene. Hech laj jna'tutic uc ti melel ti hech ono'ox laj yalbe ti totiletique. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Te nicomtutic ti Jerusalén xchi'uc ti Jesuse ti yorail q'uin Pascua. Ep jchi'iltac laj xch'unic ti ja' ti Jcoltavaneje c'alal laj sq'uelic ti jchop o abteletic ti laj spas ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ti Jesuse laj sna'be yo'ntonic ti jchi'iltaque ti mu scotoluc jun yo'ntonic ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mu persauc ti ch-albat ti Jesuse c'u x'elan yo'nton ti crixchanoetique. Stuc sna'ojbe yo'nton scotol crixchanoetic. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oy to ono'ox jun jchi'iltutic, ja' Nicodemo sbi. Ja' ochem ti fariseo ti Nicodemoe. (Ti fariseoetique ja' tsots sc'opilal c'otem yu'unic tscuyic ti smantal ti Diose.) Ti Nicodemoe yich'oj yabtel te ti templo te ti Jerusalén. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ti ac'ubaltic tal sc'opon ti Jesuse ti Nicodemoe. Hech laj yalbe: ―Maestro, ti jna'tutic ti laj stacot talel ti Diose yu'un chachanubtasuntutic. Yu'un ti manchuc achi'inoj ti Diose, mu xu' chapas ti jchop o abteletic chapase ―xchi ti Nicodemoe. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Itac'av ti Jesuse, hech laj yalbe: ―Melel ti c'usi chacalbee, ti much'u mu cha'anemuc nixtoc, mu xu' sna' ti c'u che'el tspasvan ti mantal ti Diose ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ti Nicodemoe hech laj sjac'be: ―¿C'u che'el chcha'an nixtoc ti much'u mol xae? Mu xu' chcha'och nixtoc ti xch'ut sme' yu'un chcha'an nixtoc ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Itac'av ti Jesuse, hech laj yalbe: ―Melel ti c'usi chacalbee, ma'uc no'ox tsc'an ti chavich'ic ho'e, tsc'an ti chavich'ic uc ti Ch'ul Espíritue, hech xu' chaspasoxuc ti mantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","C'alal na'an li' ti balumile, ja' no'ox sventa jayib c'ac'al chacuxi li' ti balumile. C'alal chacha'an ti sventa ti Ch'ul Espíritue, ja' sventa acuxlejal sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mu me xch'ay avo'nton yu'un ti nacalbe ti persa chacha'anic nixtoc. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Buc no'ox chbat ti iq'ue. Chava'i ti xjinet no'oxe. Mu xana' bu chtal, mu xana' bu chbat. Hech ono'ox scotol ti much'u cha'anem ti sventa ti Ch'ul Espíritue. Jelbil yo'nton chavil pero mu xana' c'u che'el ic'ot ti pasel ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ti Nicodemoe hech laj sjac'be: ―¿C'u che'el chc'ot ti pasel? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Itac'av ti Jesuse, hech laj yalbe: ―Ho'ot jchanubtasvanejot yu'un ti jchi'iltique, ¿mi mu xava'ibe sjam? ");
INSERT INTO tzoNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Melel ti c'usi chacalbee, ti ho'ontutique chcaltutic ti c'usi jna'ojtutic, ti c'usi quilojtutique. Ti ho'oxuque mu xapasic ti muc' jc'optutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mi mu xach'un ti c'utic chc'ot ti pasel yu'un ti Diose li' ti balumile, ¿c'u che'el chach'un ti c'utic chc'ot ti pasel yu'un ti Diose te ti vinajel uc? ");
INSERT INTO tzoNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mi junuc mu'yuc much'u i'ay tal ti vinajel yu'un hech chayalbot c'u x'elan te o. Jtuc no'ox xu' chacalboxuc yu'un niyal tal ti vinajel, ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hech chaj c'u che'el laj sjipambe sloc'tombail chon ti te' te ti xocol balumil ti antiguo jtatamoltic Moisese, ja' no'ox hech chijipanat ti cruz, ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Yu'un mi chch'unic ti ja' sventa scolelic ti chijipanat ti cruze, ja' chcuxiic sbatel osil ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Lum ep laj sc'uxubin scotol crixchanoetic ti Jtotic Diose, hech yu'un laj yac' ti milel ti Snich'one. Jun no'ox Snich'on oy. Scotol ti much'utic xch'unojic ti icoltaat xa yu'une, ja' mu xch'ayic. Ja' cuxul sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ti Jtotic Diose laj stac talel li' ti balumil ti Snich'one. Muc un tal yac'be castigo yu'un smul ti crixchanoetique. Ja' tal scolta scotol crixchanoetic. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ti much'u xch'unoj ti icoltaat xa yu'une, ja' mu x'ac'bat castigo yu'un smul. Ti much'u mu sc'an coltaele, chapal xa sc'opilal yu'un smul yu'un mu xch'unojuc ti ja' Jcoltavanej cu'untic ti Snich'on ti Diose. Jun no'ox Snich'on oy ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Chapal xa sc'opilal yu'un smulic yu'un i'ay xa li' ti balumil ti Snich'on ti Diose. Hech chaj c'u che'el ti c'alal tsacub ti osile chvinaj scotol mi oy c'utic chopol ic'ot ti pasel, ja' no'ox hech uc ti c'alal ital ti Snich'on ti Diose ivinaj uc ti oy jmultic jcotoltic. Ti crixchanoetique mu sc'an chtalic ti stojol ti Snich'on ti Diose yu'un chopol ti yabtelique. Lec cha'yic ti mulile. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Scotol ti much'u mu xtun ti c'usi tspase, mu sc'an ti ac'o vinajuc ti c'u che'el tspase hech yu'un mu sc'an chtal ti stojol ti Snich'on ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ja'uc ti much'u tspasilan ti c'usi yaloj ti Diose, ja' mu xi' yu'un chtal ti stojol ti Snich'one, hech chvinaj ti coltabilic yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Patil nibatutic ti estado Judea xchi'uc ti Jesuse, ho'ontutic ti yajchanc'opuntutique. Te nihalejtutic xchi'uc. Te laj yac'bun cabteltutic ti Jesuse yu'un chcac'be yich'ic ho' scotol ti much'utic te xchi'inojucuntutic xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Hech uc ti Juane te yac'oj sba chac' ich'ho' te ti jteclum Enón sbi. Ti Enone nopol xil sbaic xchi'uc ti jteclum Salim sbi. Te oy lec uc'um. Ti much'utic sts'acliojic ti Juane, te i'ac'bat yich'ic ho' uc. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mu to ch-och ti chuquel ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ti yajchanc'opetic ti Juane mu xtun laj yilic ti chtal yac' sbaic ti ich'ho' ti stojol ti Jesuse ti jchi'iltutique hech yu'un lic stsac sbaic ti c'op xchi'uc jun jchi'iltutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hech yu'un patil ba yalbeic ti Juane: ―Maestro, ti much'u ital ti atojol lum ti hech uc'um Jordán, ti laj acholbe sc'opilale, ja' yac'oj sba chac' ich'ho' ti ora to. Scotol crixchanoetic te bat xchi'inic ―x'utat yu'un ti yajchanc'opetique. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Itac'av ti Juane, hech laj yalbe: ―Stuc smantal ti Diose ti c'utic abtelal chac'be jujun. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ti ho'oxuque laj ava'yic ti hech laj cal: Mu Cristoucun, mu jcoltavanejucun, xcut ti jchi'iltique. Ho'oni ja' no'ox laj yac'bun cabtel ti Diose yu'un chibaej yu'un ti Jcoltavaneje. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Chana'ic ti c'alal chic' yajnil jun vinic, ti antse muc un ja' chba yic' sba xchi'uc ti much'u ch'amumbil yu'un ti jnupunele. Ja' chba sta ti smalale. Ti much'u ch'amumbil yu'un ti jnupunele ja' no'ox te va'al tsq'uel ti jnupunele. C'alal cha'ibe sc'op ti jnupunele, nichim no'ox yo'nton yu'un oy xa yajnil ti xchi'ile. Ja' no'ox hechun ti ho'one, nichim no'ox co'nton yu'un chba xchi'in ti Jesuse ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Persa chpuc sc'opilal ti Jesuse. Ho'oni persa chlaj jc'opilal ―xchi ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ti Jesuse ti itacat yal tal yu'un ti Diose ja' sventainoj scotol. Ti Juane ti li' liquem ti balumile ja' no'ox oy yabtel li' ti balumile. Ja' no'ox chal ti c'usi chil li' ti balumile. Ti Jesuse ti iyal tal ti vinajele ja' jelaven sp'ijil. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ja' chal ti c'usi yiloj te yo' bu oy ti Diose xchi'uc ti c'usi te ya'yoj. Pero mu epuc ti much'u tspasbat ti muc' ti sc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ti much'utic tspasbe ti muc' ti sc'ope ti “niyal tal ti vinajel”, ti xchie, ja' chch'unic ti hech ono'ox albil sc'opilal yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ti Jesuse ti itacat yal tal yu'un ti Diose, ja' sc'op ti Diose chal. Mu p'isbiluc yich'oj ti Ch'ul Espíritue. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ti Jtotic Diose c'ux ti yo'nton ti Snich'one. Yac'ojbe sventain scotol ti c'utic oy yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Scotol ti much'u xch'unoj ti ja' icoltaat xa yu'un ti Snich'on ti Diose, ja' cuxul sbatel osil. Scotol ti much'u mu sc'an coltael yu'un ti Snich'on ti Diose, ja' mu xcuxiic sbatel osil. Ja' ch-ac'batic castigo yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Laj ya'i ti Jesuse ti hech i'albatic ti fariseoetique: ―Ja' más ch-epaj ti yajchanc'opetic ti Jesuse yu'un más ep chac' ich'ho'. Ja' chtup' xa ti yajchanc'opetic ti Juane ―x'utatic ti fariseoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ja' no'ox ti hech sc'opilal ti Jesuse. Mu'yuc bu laj yac' ich'ho' stuc. Ja' no'ox ho'ontutic ti yajchanc'opuntutique ti laj cac'tutic ti ich'ho'e. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yu'un ti laj ya'i ti Jesuse ti mu xtun cha'yic ti fariseoetique ti ja' más ep chch'umbat sc'ope, hech yu'un “batic ti jlumaltic”, xiyutuntutic ti Jesuse. Hech yu'un chisututic batel ti jlumaltutic, ja' ti estado Galileae. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ti bee ti laj jtamtutic batele te chjelav ti estado Samaria sbi. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Te nic'otutic ti jun jteclum te ti estado Samaria. Sicar sbi ti jteclume. Te xa nopol uc ti sbalumil ti antiguo jtatamoltutic Josee ti i'ac'bat ti sventa lume yu'un ti stote, ja' ti Jacobe. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Te oy pozo pasbil ti vo'one yu'un ti jtatamoltutic Jacobe. Ti Jesuse inaqui yo' bu ti pozoe yu'un ilub ti xambal. Po'ot xa tsta o'lol c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Te tal slup ya'al jun samaria ants. Ti Jesuse laj yalbe: ―Jc'antic jlecuc ava'al yu'un chcuch' ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ho'ontutic ti yajchanc'opuntutic ti Jesuse batemuntutic ti yut jteclum yu'un ba jmantutic tal jve'eltutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ti samaria'antse laj sjac'be ti Jesuse: ―¿C'u yu'un chac'ambun ho' yu'un chavuch'? Ti ho'ote judiovinicot. Ho'oni samaria'antsun ―xchi. Yu'un ti hech laj yal ti antse yu'un mu xtun chil sbaic xchi'uc ti samariaetique ti jchi'iltaque ho'ontutic ti judiountutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Itac'av ti Jesuse, hech laj yalbe: ―Ti lajuc ana' ti tsc'an chayac'bot amoton ti Diose, ti lajuc avojtiquinun ti ho'one ti nacalbe: Jc'antic jlecuc ava'al yu'un chcuch', xacute, ho'ot jbael laj ac'ambun ho' ti hechuque. Hech laj cac'bot ti ho'e ti ja' chacuxi sbatel osil yu'une ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hech lic yal ti antse: ―Tote, mu'yuc slupobil avu'un. Nat ti pozoe. ¿C'u che'el chata ti ho'e ti ja' chavac'bune ti chicuxi sbatel osil yu'une chavale? ");
INSERT INTO tzoNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ti antiguo jtatamoltic Jacobe ja' laj yac'buntutic ti pozo li'to. Laj yuch' ti ho' li'to xchi'uc ti xnich'nabe xchi'uc ti xvacaxe xchi'uc ti scarneroe. ¿Mi más tsots avabtel avich'oj ho'oti? ¿Mi más to chlecub avu'un ti ho'e ti chavac'bun cuch' chavale? ―xchi ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Itac'av ti Jesuse, hech laj yalbe: ―Scotol ti much'u chuch' ti ho' li'to ta to xtaquij yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Scotol ti much'u chuch' ti ho' ti chcac'bee ja' mu xa xtaquij yo'ntonic. Ti ho' ti chcac'bee ja' sat ho' chc'ot ch-oq'uilan ti yo'ntonic hech chcuxiic sbatel osil ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Hech lic yal ti antse: ―Tote, ac'bun cuch' ti ho'e ti chavale. Yu'un hech mu xa xtaquij co'nton, yu'un hech mu xa xtal jlup ca'al li'to to yan vuelta ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ti Jesuse hech laj yalbe: ―Batan, ba ic'o tal amalal ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Itac'av ti antse: ―Mu'yuc jmalal ―xchi. Ti Jesuse hech lic yalbe: ―Melel ti mu'yuc jmalal xachie. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yu'un ho'vo' laj avil ti mero amalale. Laj atenilan ti mero amalale. Ja'uc avic'oj abaic xchi'uc ti ora to, ma'uc mero amalal. Melel ti c'u che'el chavalbune yu'un mu amalaluc ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ti antse hech laj yalbe: ―Tote, jun to j'alc'opot yu'un Dios chquil ―xchi―. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ti antiguo jtatamoltique li' laj spasic ti muc' ti Diose li' ti jol vitsi. Ti ho'oxuc ti judiooxuque chavalic ti ora to ti te ti jteclum Jerusalén persa chba jpastutic ti muc' ti Diose ―xchi ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ti Jesuse hech laj yalbe: ―Ch'uno ti c'usi chacalbote. Ta me sta yorail chlaj sc'opilal ti li' chapasic ti muc' ti Jtotic Diose li' ti vitsi. Ja' no'ox hech uc chlaj sc'opilal ti te chba apasic ti muc' ti Jtotic Diose te ti Jerusalén. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ti ho'oxuque ti samariaoxuque mu xavojtiquinic ti Diose. Ti jchi'iltaque chojtiquinic ti Jtotic Diose yu'un albilic yu'un ti chital ho'oni ti Jcoltavanejune, ho'on ti co'ol judioun xchi'uque. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Laj xa sta yorail ti buc no'ox tspasic ti muc' ti Jtotic Diose ti yo'ntonic ti much'utic mero jch'unojeletique. Ti Jtotic Diose tsa' ti much'u hech tspasat ti muc' yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mu'yuc sbec'tal ti Jtotic Diose, hech yu'un mu xavilic. Ja' no'ox hech uc mu xavilic ti much'utic spasojic ti muc' ti Diose yu'un ti yo'ntonic spasojic ti muc'. Ja' hech tsc'an ti Diose ti jpastic ti muq'ue ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Lic yal ti antse: ―Ca'yoj ti chtal ti Cristoe, ja' ti ac'bil yabtel yu'un ti Diose yu'un chijcol yu'une. C'alal chtal, ja' scotol chixchanubtasucutic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ti Jesuse laj yalbe: ―Ho'onun ti chajc'oponote ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Te yac'oj sba chlo'laj xchi'uc ti antse hul jtatutic ti Jesuse, ho'ontutic ti yajchanc'opuntutique. Hech yu'un ich'ay co'ntontutic yu'un scotol ti much'u ochem ti chanubtasvaneje mu stac' chlo'laj xchi'uc ants mi ti be mi ti calle. Muc xjam cu'untutic yu'un ti jac'betutic: ¿C'usi chajac'be? ¿C'u yu'un chalo'laj xchi'uc? muc xichitutic mi junuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hech yu'un ti antse laj scomes sq'uib te ti ti' pozo. Isut batel te ti yut jteclum yu'une. Hech c'ot yalbe ya'yic scotol ti crixchanoetique: ");
INSERT INTO tzoNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―La'meic. La' q'uelo jun vinic laj yalbun scotol ti c'usi jpasoje. Ja' van ti Jcoltavaneje ti sc'opilal chtale ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hech yu'un ti ora iloq'uic tal ti crixchanoetique te ti jteclum. Tal sq'uelic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","C'alal batem ti antse, ho'ontutic ti yajchanc'opuntutique hech laj calbetutic ti Jesuse: ―Maestro, ve'an ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Itac'av ti Jesuse, hech laj yalbuntutic: ―Oy jve'el mu xana' bu talem ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hech laj jac'be jbatutic: ―¿Mi oy van much'u i'ac'bat sve'el? ―xichitutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ti Jesuse hech laj yalbuntutic: ―Ja' jve'el c'otem ti jpas ti c'usi tsc'an yo'nton ti Diose ti laj stacun talele. Ti jts'acubtas ti cabtele ti yac'ojbune. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Hech chavalic: “Chanib to u tsc'an tsta yorail chich' cupel ti trigoe”, xachiic. A'yo me ava'yic ti c'usi chacalbeique: Toyo me asatic, q'uelo avilic ti crixchanoetic ti chtalique. Ja' hech chaj c'u che'el ti trigo ti taquin xae. Ja' yorail xa ti cupel, ja' yorail xa ti tsobel. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ti much'utic tstsobic tal crixchanoetic ti jtojol, ja' chich'ic smotonic. Ti c'u yepal itsob yu'unique, ja' chcuxiic sbatel osil. Hech yu'un co'ol nichim no'ox yo'ntonic ti much'utic laj yalbe ti jc'ope xchi'uc ti much'utic laj yic' tal ti jtojole. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hech chc'ot ti pasel ti c'u che'el chalique: “Yan ch-avolaj, yan chc'ajovaj”, xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Laj xa cac'boxuc avabtelic ti chatsobic tal ti much'utic chixch'umbucun ti jc'ope, ja' ti bu mu avabteluque. Yantic ti much'u laj sts'umbe ti yo'ntonic ti jc'ope. Ti ho'oxuque ja' avabtelic más chachanubtasic yu'un ac'o xch'unic lec ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ep ti samariaetique, ja' ti much'utic te nacajtic ti jteclume, laj xch'unic ti ja' ti Cristoe ti sventa ti sc'op ti antse ti laj yalbee: “Laj yalbun scotol ti c'usi jpasoje”, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hech ital ti samariaetique tal sq'uelic ti Jesuse. Laj yalbeic vocol ti ac'o halejuc yu'un chchi'inic. Hech te nihalejtutic chib c'ac'al xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ep yantic laj xch'unic uc ti sventa sc'op stuc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hech yu'un hech lic yalbeic ti antse: ―Ma'uc no'ox ti sventa ti ac'op ti laj xa jch'untutique. Yu'un laj xa ca'ibetutic sc'op ti stuque, hech yu'un ti jna'tutic ti ja' ti Cristoe, ja' ti Jcoltavanej cu'untic jcotoltic xchi'uc ti sjoylejal balumil ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","C'alal i'ech' xa ti chib c'ac'ale, niloc'tutic batel ti estado Samaria xchi'uc ti Jesuse. Hech nibatutic ti jlumaltutic ja' ti estado Galilea. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yu'un ti nicha'sututic batel ti jlumaltutic xchi'uc ti Jesuse, ja' yu'un ti mu'yuc much'u chcontrainat ti jlumaltutic yu'un mu spasbat ti muc' ti sc'ope. Ja' hech chaj c'u che'el yaloj ono'ox ti Jesuse: Ti much'utic chal sc'op Dios mu spasat ti muc' ti bu ich'ie, xchi ono'ox. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","C'alal nic'otutic ti jlumaltutic xchi'uc ti Jesuse, nichim no'ox yo'ntonic ti jchi'iltutic te o yu'un laj xa sq'uelic scotol ti c'usi laj spas ti Jesuse ti c'alal i'ayic ti q'uin te ti Jerusalén. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Hech yu'un ti Jesuse icha'bat nixtoc ti jteclum Caná te ti estado Galilea yo' bu laj sc'atajes ti ya'lel sat uvate' ti ho'e. Ti jteclum Capernaum oy yabat ti reye. Ja' jchi'iltutic. Ja' jchamel ti snich'one. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ti yabat ti reye laj ya'i ti nic'otutic xa xchi'uc ti Jesuse te ti estado cu'untutique. Hech tal yalbe vocol ti Jesuse ac'o ba coltabatuc comel ti snich'one te ti sna. Yu'un ta xa xcham ti snich'one. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ti Jesuse hech laj yalbe: ―Ti ho'oxuque ja'to chach'unic ti jelaven jp'ijile ti c'alal chaq'uelic ti jchop o abteletic ti jpase ―xut ti jayvo' ti te va'ajtique. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ti yabat ti reye hech laj yalbe ti Jesuse: ―Tote, la' me ti ora yo' to cuxul to ti jnich'one ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ti Jesuse hech laj yalbe: ―Batan, chchop ti anich'one ―xut. Hech yu'un ti jchi'ile laj xch'un ti hech chaj c'u che'el i'albat yu'un ti Jesuse. Hech isut batel ti sna. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","C'alal yac'oj sba chanav batel ti sbelal sna, laj snup ti be ti smozoe. Hech i'albat: ―Ichop xa ti anich'one ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ti jchi'ile hech lic sjac'be ti smozoe: ―¿C'usi ora lic lamajuc ti xchamele ti jnich'one? ―xchi. Hech itac'av ti smozoe: ―Volje jun ora yech'el o'lol c'ac'al ilamaj ti sc'ac'ale ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hech yu'un laj sna' ti stot ti quereme ti hech ono'ox ora i'albat yu'un ti Jesuse: “Chchop ti anich'one”, ti x'utate. Hech laj xch'unic ti ja' Jcoltavanej yu'unic ti Jesuse ti jchi'ile xchi'uc scotolic te ti sna. ");
INSERT INTO tzoNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ja' xchibal vuelta laj yac' svinajeb ti jelaven sp'ijil ti Jesuse. Ja' laj spas c'alal isut xa tal ti estado Judea, ihul xa ti estado Galilea. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Patil ista yorail q'uin cu'untutic, ho'ontutic ti judiountutique. Hech yu'un nimututic batel ti Jerusalén xchi'uc ti Jesuse ho'ontutic ti yajchanc'opuntutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Te ti Jerusalén oy estanque yu'un ho' nopol ti ti'macte'ton yu'un ti jteclume yo' bu ch-ochic ti carneroetique ti chtunic yu'unic te ti templo. Ti estanquee Betesda sbi ti jc'optutic. Te oy ho'ob na te nopol ti sts'el ti estanquee. Mu'yuc sjit' ti nae. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ja' te metsajtic ti yut na ep jchameletic. Oy ma'satetic, oy mecanetic, oy much'u sicuben yacan sicuben sc'ob. Tsmalaic mi chtijat ti ho'e. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yu'un oy chyal talel ti ho' te ti estanque xch'ul abat ti Diose. Baq'uintic no'ox chyal tal yu'un tstij ti ho'e. C'alal tijem xa ti ho'e, ti much'u jbael tstic' sba ochel ti ho' ja' chcol c'usuc no'ox chamelal yich'oj. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Te oy jun jchi'iltutic. Chib habil mu xloc' cha'vinic habil yich'oj ti xchamele ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ti Jesuse laj yil ti te metsel. Laj sna' ti ep habil jchamel ti vinique. Hech yu'un hech laj sjac'be: ―¿Mi chac'an chachop? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hech itac'av ti jchamele: ―Tote, mu'yuc much'u chiyotesun ti ho' c'alal tijem xa ti ho'e. C'alal cac'oj jba chiyal batel, oy much'u i'och xa jbael ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ti Jesuse hech lic yalbe: ―Lican, balo batel apop, xanavan ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ti ora ichop ti vinique. Laj sbal ti spope. Ixanav batel. Ja' sc'ac'alil ti jcux co'ntontutic ho'ontutic ti judiountutique ti c'alal hech icoltaat ti jchi'ile. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hech yu'un ti totiletic cu'untutic ono'oxe laj yalbeic ti vinique ti icol xa ti chamele: ―Ja' sc'ac'alil to ti jcux co'ntontic. Chap'aj mantal yu'un ti chavich' batel ti apope ―x'uti. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hech itac'av ti vinique: ―Ti much'u laj scoltaune ja' laj yalbun: “Balo batel apop, xanavan”, xiyutun ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hech lic sjac'beic ti vinique: ―¿Much'u laj yalbot: “Balo batel apop, xanavan”, ti xayute? ―x'uti. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ti vinique ti colem xae muc sna' ti much'u icoltaat yu'une yu'un ti ora laj sq'uej sba batel ti Jesuse yu'un ep stsoboj sbaic ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Patil itaat te ti yut templo ti vinique yu'un ti Jesuse. Hech i'albat yu'un: ―Yu'un ti ichop xa ti abec'tale, mu xa me xatoy aba yan vuelta naca me jelavenuc chavich' vocol ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hech yu'un ti vinique ba yalbe ti totiletic cu'untutic ono'oxe scuyoj sbaique ti ja' icoltaat yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Scoj ti hech laj scolta ti vinique ti Jesuse ti sc'ac'alil ti jcux co'ntontutic, hech yu'un laj scontrainic ti Jesuse ti totiletique. Ja' sc'an smilic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ti Jesuse hech laj yalbe: ―Ta to x'abtej ti Jtote. Ja' no'ox hechun ti ho'one ta to xi'abtej uc ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hech yu'un sc'an smilic ti Jesuse ti totiletique. Ma'uc no'ox yu'un muc xchabi ti sc'ac'alil ti jcux co'ntontutique. Ja' yu'un ti laj yal ti ja' Jtot ti Diose, xchi. Yu'un laj sco'oltajes sba hech chaj c'u che'el ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ti Jesuse hech laj yalbe: ―Melel ti c'usi chacalbeique, ho'on ti Snich'onun ti Diose, mu'yuc c'usi xu' cu'un ti jpas jtuc. Ja' no'ox ti jpas ti c'usi laj jq'uel tspas ti Jtote. Ti c'usi tspas ti Jtote, ja' ti jpas uc ho'on ti Snich'onune. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ti Jtote c'uxun ti yo'nton ho'on ti Snich'onune. Scotol chiyac'bun jq'uel ti c'usi tspase. Jutuc no'ox aq'uelojic ti ora to. Jelaven ta to xiyac'bun jpas. C'alal mi laj jpase, más to chch'ay avo'ntonic yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Hech chaj c'u che'el chcha'cuses animaetic ti Jtote, ja' no'ox hech uc ti ho'one ti Snich'onune, ti much'u ti jc'an ti jcha'cusese, ti jcha'cuses. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ti Jtote mu xchapambe sc'opilal crixchanoetic yu'un smulic. Ho'on ti Snich'onune scotol yac'ojbun jchapambe sc'opilal crixchanoetic yu'un smulic. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Hech yu'un scotol crixchanoetic chispasucun ti muc', ho'on ti Snich'onune hech chaj c'u che'el tspasic ti muc' ti Jtote. Ti much'u mu xispasun ti muc' ho'on ti Snich'onune, ja' mu spas ti muc' uc ti Jtote, ja' ti laj stacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Melel ti c'usi chacalbeique, ti much'u chiya'ibun ti jc'ope, mi xch'unoj ti ja' laj stacun talel ti Diose, ja' chcuxi sbatel osil. Ja' mu xich' castigo yu'un icom xa yu'un ti ch'ayel chbate. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","’Melel ti c'usi chacalbeique, laj xa sta yorail ti chava'ibucun jc'op ho'on ti Snich'onun ti Diose, ho'oxuc ti animaoxuc c'otem ti jtojol. Ti much'u chch'un ti ho'on Jcoltavanejun yu'unique ja' chcuxiic sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Hech chaj c'u che'el sventainoj cuxlejal sbatel osil ti Jtote, ja' no'ox hechun uc ti ho'one yac'ojbun jventain cuxlejal sbatel osil ho'on ti Snich'onune. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yac'ojbun uc jventain xchapambel sc'opilal smul scotol crixchanoetic yu'un ho'on co'ol crixchanoucutic nic'ot. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mu me xch'ay avo'ntonic yu'un ti hech laj calboxuque. Yu'un ta me sta yorail ti chixch'umbucun jmantal, ho'on ti Snich'onun ti Diose, scotol ti much'utic chamenique. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Scotolic chloq'uic tal ti ch'en. Ti much'utic lec spasojique, ja' chcuxiic sbatel osil. Ti much'utic mu xtun ti c'usi spasojique, ja' ch-ac'batic castigo yu'un smulic. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Ho'oni mu'yuc c'usi xu' cu'un ti jpas jtuc. Hech chaj c'u che'el laj yalbun ti Jtote, ja' no'ox hech ti jchapambe sc'opilal smul scotol crixchanoetic. Toj ti jchapambe sc'opilal smul scotol crixchanoetic yu'un ma'uc ti jpas ti c'usi tsc'an ti co'ntone. Ja' ti jpas c'usi tsc'an ti yo'nton ti Jtote, ja' ti laj stacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yu'un jtuc no'ox chcal jba chacuyic, hech yu'un mu stac' chach'unic chacuyic. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ho'oni oy rextico cu'un ti chiyalbun jc'opilale. Melel ti hech chiyalbun ti jc'opilale. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ti ho'oxuque laj ataquic ti jaq'uel ti stojol ti Juane, ja' ti laj yac' ich'ho'e. Melel ti hech chac c'u che'el laj yalbun jc'opilal ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mu tsotsuc sc'opilal yu'un ti hech laj yalbun jc'opilale. Ja' no'ox yu'un chajt'abesboxuc yu'un hech chc'ot ti avo'ntonic hech chacolic. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ti Juane ja' hech chaj c'u che'el toj c'otem. Laj yac'boxuc aq'uelic ti lequil bee. J'oc' no'ox ti nichim no'ox avo'ntonic yu'un ti hech chaj c'u che'el laj yalboxuque. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ti sventa ti Juane, ja' no'ox laj ava'ibun jc'opilal. Ti c'u x'elan ti cabtele ti chiyac'bun jpas ti Jtote, hech chvinaj ti tacbilun tal yu'un ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ti Jtote ja' ti laj stacun talele, ja' yalojbun jc'opilal, ja' rextico cu'un. Mi jutuc muc bu ava'yoj c'u che'el chc'opoj, muc bu aq'ueloj c'u x'elan. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yu'un mu'yuc ti avo'ntonic ti sc'ope. Hech yu'un mu ach'unojuc ti ho'on Jcoltavanejun avu'unique, ho'on ti tacbilun tal yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yu'un ti chaq'uelilanic ti sc'op ti Diose chacuyic ti hech chacuxiic sbatel osil. Pero mu hechuc chal ti sc'op ti Diose. Ja' te ts'ibabil jc'opilal ti ho'on ti jventa ti chacuxiic sbatel osile. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero mu xac'an chatalic ti jtojol yu'un hech chacuxiic sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Mu yu'unuc ja' mu xtun chca'i yu'un ti muc xapasucun ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yu'un ti jna' c'u x'elan avo'ntonic. Yu'un mu c'uxuc ti avo'ntonic ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ti ho'one ti ja' laj stacun tal ti Jtote, mu xac'an chach'unic ti ho'on Jcoltavanejun avu'unique. Ja'uc ti much'u hech no'ox chtal ti mu tacbiluc tal yu'un ti Jtote, ja' chapasic ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mu xu' avu'unic chach'unic yu'un ja' no'ox chac'an ti lec chayilot ti achi'iltaque. Mu yu'unuc ja' chasa'ic ti lec chayilot ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mu me xacuyic ti ho'on chajsa'be amulic ti stojol ti Jtote. Yu'un ti toyol avo'ntonic chach'unic scotol ti mantaletic ti chacuyique, ja' amul ic'ot o yu'un mu xu' avu'unic xch'unel hech chaj c'u che'el laj yal ti Moisese. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ti ach'unojbuc sc'op ti Moisese, chach'umbucun jc'op ti hechuque yu'un ho'on jc'opilal ti laj sts'ibabune. ");
INSERT INTO tzoNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Yu'un ti mu xu' avu'unic chach'unic hech chaj c'u che'el ts'ibabil yu'un ti Moisese, ja' no'ox hech mu xu' chach'umbucun jc'op uc ho'oni ―x'utatic ti totiletic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Patil nibatutic xchi'uc ti Jesuse lum ti jech nab te ti estado cu'untutic, ja' ti Galileae. Ti nabe ja' nopol xil sbaic xchi'uc ti jteclum, Tibérias sbi. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ep jchi'iltac laj sts'acliuntutic batel xchi'uc ti Jesuse yu'un laj sq'uelic ti jchop o abteletic laj spas ti Jesuse, ja' ti laj scolta ti jchameletique. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nimututic batel ti jun biq'uit vits xchi'uc ti Jesuse. Te ninaquitutic xchi'uc, ho'ontutic ti yajchanc'opuntutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Po'ot xa tsta yorail q'uin cu'untutic ho'ontutic ti judiountutique. Ja' ti q'uin Pascua sbie, ja' ti c'u che'el laj scoltauntutic loq'uel ti mozoil te ti Egipto ti Diose ti vo'one. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ti Jesuse laj yil ti chcha'tal taatuc yan vuelta yu'un ti crixchanoetique. Hech yu'un hech laj sjac'be ti Felipee: ―¿Bu chba jmantic caxlan vaj yu'un chcac'betic sve'ic avi yepal crixchanoetic li'to? ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ti Jesuse hech laj sjac'be ti Felipee yu'un tspasbe proval yo'nton. Stuc sna'oj ti Jesuse c'usi tspas. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Hech itac'av ti Felipee: ―Ti oyuc lajunvinic denariotaq'uin yu'un ti caxlan vaje, mu tauc yutsil chve'ic scotolic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Hech i'albat yu'un yan jchi'il ti abtel, ja' ti Andrese, ja' ti yits'in ti Simon Pedroe: ");
INSERT INTO tzoNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Oy jun querem li'to. Yich'oj tal ho'ob muc'tic caxlan vaj pasbil ti extranjero trigo. Yich'oj uc cha'cot choy. Pero ¡bu c'amba tauc yutsil yu'un ep ti crixchanoetique! ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ti Jesuse hech laj yalbuntutic: ―Albo ac'o nacluc ti crixchanoetique ―xiyutuntutic. Yu'un vomoltic, hech yu'un te inaquiic. Oy ho'mil viniquetic. Ti antsetique ti ololetique mu atabiluc. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ti Jesuse laj stsac ti muc'tic caxlan vaje. Laj yalbe vocol ti Diose. Laj xch'aquilambuntutic batel ho'ontutic ti yajchanc'opuntutique. Ti ho'ontutique laj jpuquilambetutic batel ti much'utic ti te nacajtique. Hech uc ti choye laj caq'uilambetutic ti c'u yepal tsc'anic ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","C'alal inoj xch'utic ti crixchanoetique, ti Jesuse hech laj yalbuntutic ho'ontutic ti yajchanc'opuntutique: ―Tsobic tal ti sobril caxlan vaje xchi'uc ti sobril choye naca me ch'ayuc ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hech yu'un laj jtsobtutic tal. Inoj lajcheb almud ti sobril ti ho'ob muc'tic caxlan vaje ja' ti pasbil ti extranjero trigoe. Ja' ti sobril ti caxlan vaje yu'unic ti much'utic ive'ique. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ti crixchanoetique c'alal laj sq'uelic ti jelaven sp'ijile ti Jesuse, hech laj yalbe sbaic: ―Ja' cac'tic ti j'alc'op yu'un ti Diose li'to ti sc'opilal chtal ti balumile ―xut sbaic ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Laj sna' ti Jesuse ti tsc'an tstsacat yu'un ti crixchanoetique tsujat yu'un chtic'at ti ajvalil cu'untutic, ho'ontutic ti judiountutique, hech yu'un laj sq'uej sba batel ti vits stuc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ti ho'ontutic ti yajchanc'opuntutique ta xa sapeta niyaltutic batel ti ti'nab. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Te ni'ochtutic ti barco, nixanavtutic batel ti baho'. Toj chibatutic ti jteclum Capernaum lum ti jech nab. C'alal ic' xa osil cac'oj jba chixanavtutic batel ti barco. Mu to bu laj quiltutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Toyol ti iq'ue. Tsots tsyuques sba ti ho'e yu'un chnicat yu'un ti iq'ue. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","C'alal nixanavtutic xa ti baho' jun reva, laj quiltutic ti Jesuse. Te chanav talel ti yacan ti baho'. Chnopej tal ti sts'el ti barcoe. Hech yu'un toj xi'el nic'otutic ho'ontutic ti yajchanc'opuntutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ti Jesuse hech laj yalbuntutic: ―Ho'on chavil, mu xaxi'ic ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nichim no'ox co'ntontutic laj quic'tutic ochel ti barco ti Jesuse. Hech yu'un ti ora no'ox nic'otutic ti jech nab ti bu jnopejtutic ti chic'otutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ti jchi'iltaque te comen lum ti jech nab laj yilic ti mu'yuc yan barco, ja' no'ox jun. Laj yilic uc ti muc bu i'och ti barco ti Jesuse. Ja' no'ox jtuctutic ni'ochtutic, ho'ontutic ti yajchanc'opuntutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ti yoc'omal italic ti jteclum Tibérias yan barcoetic. Te i'ech'ic nopol ti bu laj sve'ic volje ti caxlan vaje ti jchi'iltaque c'alal laj yalbe vocol ti Diose ti Cajvaltique. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yu'un laj yilic ti jchi'iltaque ti mu xa teuc ti Jesuse, ti mu xa teucuntutic uc ho'ontutic ti yajchanc'opuntutique, hech yu'un laj stic' sbaic ochel ti barco uc. Italic ti Capernaum, tal sa'ic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","C'alal c'ot stauntutic xchi'uc ti Jesuse li' ti jech nab, hech laj sjac'beic ti Jesuse: ―Maestro, ¿c'usi ora natal li'to? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Hech itac'av ti Jesuse: ―Melel ti c'usi chacalbeique yu'un ti tal asa'ucune mu yu'unuc ja' chach'unic ti jelaven jp'ijile ti ho'onun Snich'onun ti Diose. Ja' no'ox tal asa'ucun yu'un ti inoj ach'utic yu'un ti caxlan vaje. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mu me ja'uc te chbat avo'ntonic chasa' ave'elic ti sna' chlaje. Ja' tsc'an ti chasa'be sve'el avo'ntonic ti mu sna' xlaj sbatel osile. Ho'on chacac'boxuc, ho'on ti co'ol crixchanoucutique, yu'un hech ac'bilun cabtel yu'un ti Jtote ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ti jchi'iltaque hech laj sjac'beic ti Jesuse: ―¿C'usi chcut ti jpasbetutic yabtel ti Diose ti ho'ontutique? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Itac'av ti Jesuse, hech laj yalbe: ―Ja' yabtel Dios ti chach'unic ti ho'on Jcoltavanejun avu'unique, ho'on ti tacbilun talel yu'une ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Hech lic sjaq'uic: ―¿C'usi señail chavac' jq'ueltutic yu'un hech ti jch'untutic ac'op? ¿C'usi abtelal chavac' jq'ueltutic? ");
INSERT INTO tzoNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ti antiguo jtot jme'tutique laj sve'ic manavaj te ti xocol balumil. Yu'un hech ts'ibabil: “Ti Moisese laj yac'be sve'ic vaj talem ti vinajel”, xchi ti sc'op ti Diose. Ac'buntutic hech uc ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ti Jesuse hech laj yalbe: ―Melel ti c'usi chacalbeique, ma'uc Moisés ti laj yac' ti vaje ti laj sve'ic ti atot ame'ique. Ja' no'ox i'ac'bat sventain. Ja' Dios ti laj yac' talel ti vaje. Ti vaj ti laj sve'ic ti atot ame'ique, ja' no'ox sventa xcuxlejalic li' ti balumile. Ja'uc ti ora to ti Jtote chayac'boxuc ti vaje sventa acuxlejalic sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ja' ti vaj ti chac' ti Diose, ja' iyal xa tal ti vinajel. Ja' sventa chacuxiic sbatel osil ho'oxuc ti li'oyoxuc li' ti balumile ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Hech laj yalic: ―Cajval, scotol c'ac'al aq'uilambuntutic ti vaj ti chavale ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ti Jesuse hech laj yalbe: ―Hech chaj c'u che'el cuxuloxuc li' ti balumile ti sventa ti vaj ti chave'ique, ja' no'ox hech ti ho'one hech chaj c'u che'el vaj c'otemun yu'un ho'on ti jventa chacuxiic sbatel osil. Ti much'u chtal ti jtojole, ti xch'unoj ti ho'on Jcoltavanejun yu'une, mu'yuc xa palta cha'yic o yu'un nichim no'ox yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Calojboxuc ti hovil ti avilojucune yu'un mu xac'an chach'unic ti ho'on Jcoltavanejun avu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Scotol ti c'u yepal chiyac'bun ti jventa ti Jtote, ja' chtal ti jtojol. Ti much'u chtal ti jtojole, nichim no'ox co'nton laj quic' o. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yu'un ti niyal tal ti vinajele, ma'uc yu'un tal jpas ti c'usi sc'an ti co'ntone. Ja' tal jpas ti c'usi sc'an yo'nton ti Jtote ti laj stacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ti Jtote ti laj stacun talele, hech sc'an ti yo'ntone ti scotol ti much'u yac'ojbun ti jventae mi junuc mu xch'ay cu'un. Mi ichamique, ja' ti jcha'cuses scotol ti slajebal c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Hech sc'an yo'nton uc ti Jtote ti scotol ti much'u chal ti ho'on Snich'onun ti Diose, ja' ti chch'un ti jcoltae, ja' chcuxi sbatel osil. Mi ichamique, ja' ti jcha'cuses ti slajebal c'ac'al ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hech yu'un ti jchi'iltaque, ho'ontutic ti co'ol judiountutic xchi'uque, laj sp'ajbeic ti sc'op ti Jesuse yu'un ti laj yal: “Ti vaj ti yalem tal ti vinajele, ho'on obi”, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Hech laj yalbe sbaic: ―¿Mi ma'uc ti Jesús li'to, ja' ti snich'on ti Josee? Xcojtiquimbetic ti stot sme'e. Chal ti niyal tal ti vinajel ti xchie, ¡bu ba hechuc! ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Hech itac'av ti Jesuse: ―Mu me xap'ajbun ti jc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mu'yuc much'u xu' yu'un chtal ti jtojol mi mu t'ujbiluc yu'un ti Jtote, ja' ti laj stacun talele. Ti much'u chtal ti jtojole, mi ichame, ja' ti jcha'cuses ti slajebal c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Hech ts'ibabil comel ti sun ti j'alc'opetic yu'un ti Diose: “Scotolic chp'ijubtasat yu'un ti Diose”, ti xchie. Hech yu'un scotol ti much'u laj xa yac' ti yo'ntonic ti sc'op ti Jtote, ja' p'ijubenic xae, hech yu'un chtalic ti jtojol. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Mu'yuc much'u sq'uelojbe sat ti Diose. Jtuc no'ox jq'uelojbe sat yu'un ho'on te loq'uemun tal ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Melel ti c'usi chacalbeique, ti much'u chch'un ti tacbilun tal yu'un ti Diose, ja' cuxul sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ho'on hech chaj c'u che'el vaj c'otemun yu'un ho'on ti jventa chacuxiic sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ti antiguo atot ame'ique ti laj sve'ic ti manavaje te ti xocol balumil, ja' muc sta xcuxlejalic sbatel osil ti yu'un laj sve'ic ti manavaje. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ja' ti vaj ti chcale ja' iyal xa tal ti vinajel yu'un hech chcuxi sbatel osil ti much'u tsve'e. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ho'on ti niyal xa tal ti vinajele hech chaj c'u che'el vaj c'otemun yu'un ho'on ti jventa chacuxiic sbatel osil. Scotol ti much'u tsve' ti vaj ti chcale, ja' cuxul sbatel osil. Ti vaj ti chcaq'ue, ja' ti jbec'tale, chcac' yu'un chcuxiic scotol crixchanoetic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Hech yu'un hech lic yalbe sbaic ti jchi'iltaque, ho'ontutic ti co'ol judiountutic xchi'uque: ―¿C'u che'el chijyac'bucutic ti jve'betic sbec'tal chal lume? ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ti Jesuse hech laj yalbe: ―Melel ti c'usi chacalbeique mi mu ave'ojbucun ti jbec'tale, ho'on ti co'ol crixchanoucutique, mi mu avuch'ojbucun ti jch'ich'ele, mu'yuc acuxlejalic sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ti much'u chisve'bun jbec'tale chiyuch'bun jch'ich'ele ja' cuxul sbatel osil. Mi ichame, ja' ti jcha'cuses ti slajebal c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yu'un ti jbec'tale ja' ve'elil chc'ot. Ti jch'ich'ele ja' ch-uch'at chc'ot hech yu'un chcuxiic sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ti much'u chisve'bun jbec'tale chiyuch'bun jch'ich'ele ja' oy ti jtojol obi. Ho'oni te oyun ti yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ti Jtote ti laj stacun talele, ja' stalel cuxul sbatel osil. Ho'oni ja' cuxulun sbatel osil ti sventa ti Jtote. Ja' no'ox hech uc ti much'u chisve'une ho'on ti jventa ti cuxul sbatel osile. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ja' ti vaj ti chcale iyal xa tal ti vinajel. Mu co'oluc hech chaj c'u che'el laj sve'ic ti manavaje ti atot ame'ique ti vo'one. Mu yu'unuc laj sta xcuxlejalic sbatel osil ti atot ame'ique ti yu'un laj sve'ic ti manavaj ti vo'one. Ja'uc ti ora to ti much'u tsve' ti vaj ti chcale ja' chcuxi sbatel osil ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Hech laj yal ti Jesuse te ti templo te ti Capernaum c'alal ichanubtasvan. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ep c'ac'al laj sts'acliic ti Jesuse ep ti jchi'iltaque. C'alal laj ya'yic ti c'u che'el ichanubtasvan ti Jesuse, hech laj yalic: ―¡Bu ba yaluc tal ti vinajel lume! Mu jc'an chca'itic yan ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ti Jesuse laj sna' ti yo'nton ti oy much'u chp'ajbat ti sc'ope yu'un ti jchi'iltaque. Hech yu'un hech laj sjac'be: ―¿Mi chopol avo'ntonic yu'un ti jc'ope? ");
INSERT INTO tzoNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿C'usi chavalic mi chavilic ti chimu batel ti bu niloc' tal, ho'on ti co'ol crixchanoucutique? ");
INSERT INTO tzoNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ja' ti sventa avo'ntonic chacuxiic sbatel osil. Mu'yuc sc'opilal ti abec'talique. Ti jc'ope ti laj calboxuc ava'yique ja' sventa avo'ntonic, ja' sventa chacuxiic sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mu yu'unuc ach'unojuc acotolic ―x'utatic yu'un ti Jesuse. Yu'un ti Jesuse sna'oj ono'ox ti c'alal lic abtejuc ti much'utic mu xch'umbat ti sc'ope xchi'uc ti much'u ch-ac'at entrecal yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Hech yu'un ti Jesuse hech lic yalbuntutic jcotoltutic: ―Hech yu'un laj calboxuc ava'yic ti mu'yuc much'u xu' chtal ti jtojol mi mu ic'biluc tal yu'un ti Jtote, xacutic ―xiyutuntutic jcotoltutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hech yu'un isutic batel ep ti jchi'iltac ti laj sts'acliic ono'oxe. Muc xchi'inic xa ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ti Jesuse hech laj sjac'buntutic ho'ontutic ti lajchavo'untutique: ―Ho'oxuque ¿c'usi xchi avo'ntonic? ¿Mi chasutic batel uc? ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Hech itac'av ti Simon Pedroe: ―Cajval, mu'yuc much'u yan chba jc'opontutic. Ho'ot no'ox aventainoj ti c'op sventa cuxlejal sbatel osile. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ho'ontutique jch'unojtutic. Ti jna'tutic ti ho'ot Cristoote, ti ac'bilot avabtel yu'un ti Diose yu'un chacoltauntutic. Ho'ot Snich'onot ti Diose ti stalel cuxule ―xchi ti Pedroe. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Hech itac'av ti Jesuse: ―Laj xa jt'ujoxuc ti lajchavo'oxuque. Ti june ochem pucuj ti yo'nton ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ja' laj xcholbe sc'opilal ti Judase, ja' ti snich'on ti Simon Iscariote, yu'un ja' ch-ac'van entrecal. Ti Judase ja' jchi'iltutic ti abtel, ho'ontutic ti co'ol yajchanc'opuntutic ti Jesuse xchi'uc. Ho'ontutic ja' lajchavo'untutic xchi'uc ti Judase. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Patil nixanavtutic batel te ti estado Galilea xchi'uc ti Jesuse. Yu'un ti Jesuse muc sc'an chba xanavuc te ti estado Judea yu'un yac'oj sbaic chchapambat sc'opilal yu'un ti totiletic cu'untutique yu'un chmilat. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Po'ot xa tsta yorail q'uin cu'untutic, ho'ontutic ti judiountutique. C'alal ti yorail q'uin chi'ochtutic ti nail vomol te ti Jerusalén. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hech yu'un hech i'albat ti Jesuse yu'un ti yits'inabtaque: ―Mu me xacom li'to, batic ti Judea. Yu'un hech más ch-an yip yo'ntonic ti much'utic spasojic ti muc' ti ac'ope yu'un hech más chilic ti jchop o abtel ti chc'o apas te ti q'uin. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Yu'un ti much'u tsc'an ti chpuc sc'opilale, mu muculuc ch-abtej. Mi ja' avabtel ti hech chapase, ac'o aba ti q'uelel ti stojol scotol crixchanoetic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ti yits'inabtaque muc xch'unic uc ti ja' Jcoltavanej cu'untic ti sbanquile. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ti Jesuse hech laj yalbe: ―Mu to sta yorail cu'un yu'un chibat ti q'uin. Ti ho'oxuque c'usuc no'ox ora xu' chabatic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ti crixchanoetique li' ti balumile mu xu' chayilintaoxuc ti ho'oxuque. Ho'oni chiyilintaun yu'un ti jcholbe sc'opilal ti chopol ti yabtelique. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Batanic ti q'uin, ho'oxuque. Ho'oni mu to chibat ti q'uin yu'un mu to sta yorail cu'un ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","C'alal hech laj yalbe ya'yic ti yits'inabtac ti Jesuse, te to nihalejtutic ti Galilea xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Batemic xa ti q'uin ti yits'inabtac ti Jesuse c'alal nibatutic ti q'uin uc xchi'uc ti Jesuse. Muc jchi'intutic batel ti crixchanoetique. Jtuctutic no'ox nibatutic yu'un mu sc'an chac' sba ti q'uelel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ti totiletic cu'untutic ono'oxe te ti templo, ho'ontutic ti co'ol judiountutic xchi'uque, te oyic ti q'uin yac'oj sba tsa'ic ti Jesuse. Yac'oj sba tsjaq'uic: ―¿Bu oy? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ti crixchanoetique ja' puru tslo'iltabeic sc'opilal ti Jesuse. Oy much'u laj yalic: ―Lec yo'nton ―xchiic. Yan laj yalic: ―¡Bu ba lecuc! Ja' jlo'lavanej ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mi junuc mu'yuc much'u ilo'laj ti jamal yu'un ixi'ic yu'un ti totiletic cu'untutic ono'oxe. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ti o'lol q'uin nibatutic ti templo xchi'uc ti Jesuse. Te c'ot chanubtasvanuc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Toj ch'ayel yo'ntonic ti jchi'iltaque. Hech laj yalic: ―¿C'u che'el ip'ijub ti lec ti jchi'iltic li'to yu'un mu'yuc much'u ichanubtasat? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hech itac'av ti Jesuse: ―Mu ho'ucun jc'op ti chcac' ti a'yele. Ja' sc'op stuc ti Diose ti laj stacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ti much'u tsc'an tspas ti c'usi tsc'an yo'nton ti Diose, ch-ac'bat sna' ti bu talem ti c'op ti chcac' ti a'yele, mi sc'op ti Diose, mi jc'op jtuc ti jchole. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ti much'u stuc no'ox sc'op ti chchole, yu'un chac' sba ti pasel ti muc' obi. Ti ho'one yu'un chcac' ti pasel ti muc' ti Diose ti laj stacun talele, hech yu'un muc un chilo'lavan. Melel ti c'usi chcale. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Ti Moisese laj xcholboxuc comel ti mantaletique. Mi junuc muc bu ach'unojic spasel hech chaj c'u che'el chal ti mantaletique. Ti ach'unojuque, mu xavalbucun jmilel ti hechuque ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Hech itac'av scotolic: ―Oy pucuj ti avo'nton. ¿Much'u chayalbot amilel? ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Hech itac'av ti Jesuse: ―Jun no'ox vinic laj jcolta ti yorail ti jcux co'ntontic. Hech yu'un toj ch'ayel avo'ntonic acotolic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Laj yalboxuc ti Moisese ti chavaq'uic circuncisione. Ma'uc jbael hech i'albat ti Moisese. Ja' jbael i'albatic ti antiguo jtotique. Ti ho'oxuque manchuc mi ti sc'ac'alil ti jcux co'ntontic chavaq'uic circuncisión. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Lec ti hech chach'umbeic smantal ti Moisese chavaq'uic circuncisión manchuc mi ti yorail ti jcux co'ntontic. Hech yu'un ¿c'u yu'un chavilintaun yu'un ti sc'ac'alil ti jcux co'ntontic ichop cu'un scotol sbec'tal ti jun vinique? ");
INSERT INTO tzoNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mu xtun mi ti ora no'ox chatic'be smul yan. Ja' tsc'an ti chanopic lec mi melel ti chopol ti c'usi laj spase ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hech laj yalic cha'vo' oxvo' ti jchi'iltaque ti te nacajtic te ti Jerusalene: ―Avi vinic to ja' ti tsa'ate, ja' ti sc'opilal chlaj ti milele. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Q'uelo avil, li'to jamal chc'opoj. Mu'yuc c'usi ch-albat yu'un ti totiletic cu'untique. ¿Mi yu'un xch'unojic ti ja' ti Cristoe? ");
INSERT INTO tzoNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ho'ocutique jna'ojtic bu liquem tal ti vinic li'to. C'alal chtal ti Cristoe, ja' ti mero Jcoltavanej cu'untique, mu'yuc much'u tsna' bu chlic tal ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hech yu'un tsots ic'opoj ti Jesuse te ti yut templo te ti Jerusalén c'alal ichanubtasvan. Hech laj yalbe ti crixchanoetique: ―Xavojtiquinucun chacuyic. Ana'ojic ti bu niloc' tal chacuyic. Mu jtucuc no'ox nital. Ja' ti Diose ti melel ti sc'ope, ja' laj stacun talel. Ho'oxuque mu xavojtiquinic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ho'oni xcojtiquin yu'un te niloc' tal ti stojol. Ja' laj stacun talel ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hech yu'un sc'an stiq'uic ti chuquel ti Jesuse. Mu'yuc much'u xu' yu'un stsacvan yu'un mu to staojuc yorail yu'un tstsacat ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Oy ep laj xch'unic ti ja' ti Jcoltavanej cu'untic ti Jesuse. Hech laj yalic: ―Avi jchi'il li'to jelaven tspas señailetic hech chaj c'u che'el sc'opilal ti Cristoe ti c'alal chtale. Hech yu'un ja' ti Cristoe ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Laj ya'yic ti fariseoetique ti hech chlo'lajic ti much'u laj xa xch'unic ti ja' ti Cristoe. Hech yu'un ti totil paleetique xchi'uc ti fariseoetique laj staquic batel yajmayoletic yu'un ac'o stsaquic tal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ti Jesuse hech laj yalbe ti crixchanoetique: ―Yo' j'oc' xa li'uni chajchi'inoxuque. Chibat ti bu oy ti much'u laj stacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ho'oxuque chasa'ucun. Mu xataucun. Ti bu chic'ot ho'oni, te mu xu' chac'otic ho'oxuque ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Hech lic lo'lajuc ti jchi'iltaque, ho'on ti co'ol judiountutic xchi'uque: ―¿Bu chbat ti mu xu' ti jtatic chale? ¿Mi yu'un chbat ti bu oy ti jchi'iltique te puquemic ti slumal greciaetique yu'un ja' chba xchanubtas ti greciaetique? ");
INSERT INTO tzoNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿C'usi sjam ti hech chale: “Chasa'ucun, mu xataucun”, ti xchie? “Ti bu chic'ot ho'oni te mu xu' chac'otic ho'oxuque”, ti xchie ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ti slajeb q'uin ja' tsots sc'opilal. Ja' hech ora laj sva'an sba ti Jesuse. Tsots ic'opoj, hech laj yalbe ti jchi'iltaque: ―Hech chaj c'u che'el ti much'u tsa'ilan ho' yu'un chuch' yu'un taquin ti yo'ntone, ja' no'ox hech ti much'u tsa'ilan yu'un chcol sbatel osil mu sta. Ti much'u hech yo'nton tsa'ilan, ac'o taluc ti jtojol hech chcac'be xcuxlejal sventa sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yu'un scotol ti much'u chch'un ti chcoltaat cu'une, ja' ch-oq'uilan tal ti yo'nton ti yutsil yo'ntone, hech chlic xch'unic yantic uc, xchi ti sc'op ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Hech laj yal ti Jesuse yu'un laj xcholbe sc'opilal ti Ch'ul Espíritue, ti sc'opilal ch-ac'batic ti yo'ntonic ti much'utic chch'unique. Mu to talemuc ti Ch'ul Espíritue yu'un mu to tsut batel ti vinajel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","C'alal laj ya'yic ti jchi'iltaque ti hech laj yal ti Jesuse, oy much'u laj yal: ―Ja' cac'tic ti j'alc'op yu'un ti Diose ti sc'opilal chtale ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Yan laj yalic: ―Ja' ti Cristoe li'to, ja' ti Jcoltavaneje ―xchiic. Yan laj yalic: ―Mu xlic tal ti Galilea ti Cristoe. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Yu'un chal ti sun ti Diose ti ja' ch-an ti Belén ti Cristoe yu'un ja' statamol ti Davide. Ja' te ch-an ti bu i'an ti statamole ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hech yu'un cha'tos ostos ic'otic ti jchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Oy much'u sc'an stsaquic ti Jesuse. Mi junuc mu'yuc much'u xu' yu'un stsacvan. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Hech yu'un ti yajmayoletique isutic talel ti stojol ti totil paleetique xchi'uc ti fariseoetique. Hech ijac'batic yu'unic: ―¿C'u yu'un muc xatsaquic tal? ―x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Hech itac'av ti yajmayoletique: ―Mu'yuc much'u hech chc'opoj hech chaj c'u che'el ti vinic lume ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Hech i'albatic yu'un ti fariseoetique: ―Yu'un nalajic ti lo'lael uc. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mi junuc mu'yuc much'u xch'unoj ti totiletic cu'untique. Ho'ontutic uc mi junuc mu'yuc bu jch'unojtutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ti crixchanoetique ti te stsoboj sbaique, bolic. Mu sna'ic ti mantaletique. Ich'ayic xa ―xchiic ti fariseoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Te oy ti Nicodemoe, ja' ti tal sc'opon ti ac'ubaltic ti Jesuse. Ja' ochem ti fariseo uc ti Nicodemoe. Hech laj yal ti Nicodemoe: ");
INSERT INTO tzoNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Mu xu' chcac'betic castigo jun jchi'iltic mi mu to chca'ibetic sc'op, mi mu to ti jtatic c'usi smul. ¿Mi mu hechuc chal ti mantaletic cu'untique? ―xchi ti Nicodemoe. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Hech lic yalbeic: ―Jun to liquemot tal ti Galilea uc. Q'uelo me ti sc'op ti Diose hech chana' ti mi junuc mu'yuc bu xlic tal ti Galilea j'alc'op yu'un ti Diose ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Hech ibatic ti snaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ti ho'ontutique xchi'uc ti Jesuse nibatutic ti vits Olivatic sbi. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Hech yu'un ti sob ic'luman ti yoc'omal nisututic tal xchi'uc ti Jesuse, ni'ochtutic ti yut templo te ti Jerusalén yan vuelta. Ep crixchanoetic italic ti stojol ti Jesuse. Hech yu'un laj snacan sba ti Jesuse, te lic chanubtasvanuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Italic fariseoetic xchi'uc ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. Laj yiq'uic tal jun ants. Yac'oj sba chmulivaj xchi'uc yan vinic istaic. C'ot yaq'uic ti stojol ti Jesuse te ti o'lol ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Hech laj yalbeic ti Jesuse: ―Maestro, yac'oj sba chmulivaj xchi'uc yan vinic ijta avi ants li'to. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ti Moisese hech laj spasuntutic ti mantal ti ac'o ac'batuc ton ti much'u hech tspase. ¿C'usi chaval ho'oti? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yu'un ti hech laj yalique yu'un tal spasbeic proval yo'nton. Sc'an tsa'beic smul ti Jesuse. Ti Jesuse laj snijan sba, laj sts'iba lum ti sbic'tal sc'ob. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yu'un mu xlaj yo'ntonic tsjaq'uic, toj lic nacluc ti Jesuse. Hech laj yalbe ya'yic: ―Ho'oxuc ti much'u mu'yuc smule ja' jbael ac'o yac'be ton ti antse ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Laj xcha'nijan sba yan vuelta ti Jesuse, laj xcha'ts'iba lum yan vuelta. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","C'alal laj ya'yic ti totiletique ti hech laj yal ti Jesuse, ep ilo'laj yo'ntonic yu'un ti smulique. Jujuntic iloq'uic batel. Ja' jbael iloq'uic batel ti más moletique. Ja' patil iloq'uic batel ti bu unenic toe. Stuc no'ox icom ti Jesuse xchi'uc ti antse te ti o'lol ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Toj lic cha'nacluc yan vuelta ti Jesuse. Yu'un mu xa teuc ti much'u laj yiq'uic tal ti antse, ja' no'ox te oy ti antse, hech yu'un ti Jesuse hech laj yalbe: ―Me'e, ibat xa ti much'utic laj stabot amule. Mu'yuc much'u laj yac'bot ton yu'un ti amule ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Hech itac'av ti antse: ―Mu'yuc, tote ―xchi. Ti Jesuse hech laj yalbe: ―Hechun uc, mu xacac'bot castigo yu'un amul uc. Batan, mu me xasa' yan amul ―xut batel. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yan vuelta lic chanubtasvanuc ti Jesuse. Hech laj yalbe ya'yic: ―Ho'oni luzun avu'unic, ho'oxuc ti mozoimbiloxuc yu'un ti mulile li' ti balumile. Ti much'u chists'acliune ja' chcom yu'un ti mulile, ja' tspasilan ti c'usi leque yu'un ho'on ti jtojobtas batel hech chcuxi sbatel osil ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Hech i'albat yu'un ti fariseoetique: ―Ho'oti atuc no'ox chachol ac'opilal. Mu'yuc rextico avu'un. Hech yu'un mu stac' ti jch'untutic ac'op ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Hech itac'av ti Jesuse: ―Manchuc mi chach'unic ti jtuc no'ox ti jchol jc'opilale, melel ti c'usi chcale. Jna'oj ti bu niloc' talele, jna'oj ti bu chibate. Ho'oxuque mu xana'ic ti bu niloc' talele, mu xana'ic ti bu chibate. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ti ho'oxuque ti ora chach'unic ti oy smul yan. Muc unuc chanopic lec. Ho'oni mu jnopbe smul yan. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mi oy c'usi ti jnope, lec ti jnop. Mu jtucuc no'ox ti jnop. Co'ol ti jnop xchi'uc ti Jtote, ja' ti laj stacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Hech ts'ibabil comel ti mantaletique ti avich'ojique mi co'ol sc'opic cha'vo' rexticoetic hech yu'un stac' chach'unic. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ho'oni ti jchol jc'opilal. Co'ol chixcholbun jc'opilal uc ti Jtote, ja' ti laj stacun talele ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Hech lic sjaq'uic: ―¿Bu oy ti Atote ti chavale? ―xchiic. Hech itac'av ti Jesuse: ―Mu xavojtiquinun, mu xavojtiquin uc ti Jtote. Ti taca avojtiquinucune, chavojtiquin uc ti Jtote ti hechuque ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Hech laj yal ti Jesuse c'alal ichanubtasvan te ti yut templo te ti cuarto yo' bu chaq'uic smoton ti Diose. Mu'yuc much'u xu' yu'un stsacvan yu'un mu to staojuc yorail yu'un tstsacat yu'un ti crixchanoetique ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ti Jesuse hech laj yalbe ya'yic yan vuelta: ―Oy bu chibat. Chasa'ucun, mu xataucun. Acuchoj amul chachamic. Ti bu chibate, te mu xu' chabatic ho'oxuque ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Hech yu'un hech laj yalbe sbaic ti jchi'iltaque, ho'ontutic ti co'ol judiountutique: ―¿Mi yu'un tsmil sba ti hech chale: Ti bu chibat ho'oni, te mu xu' chabatic ho'oxuque, ti xchie? ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ti Jesuse hech laj yalbe: ―Ho'oni mu co'olucutic hech yu'un mu co'oluc ti jnoptic. Yu'un ho'oni sventaun vinajel. Ho'oxuque sventaoxuc balumil. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ja' yu'un ti hech laj calboxuc: Acuchoj amul chachamic, ti xacutique. Yu'un mi mu xach'un ti ho'on Jcoltavanejun avu'unique, ja' acuchoj amul chachamic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Hech yu'un hech lic sjac'beic ti jchi'iltaque: ―¿Much'uot che'e? ―xchiic. Hech itac'av ti Jesuse: ―Ja' no'ox hech chaj c'u che'el laj calilamboxuque. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Oy to ep ac'opilal xu' chacalbeic. Oy to yan xu' chaquich'boxuc ac'opic. Ja' no'ox chacalbeic ti c'usi albilun yu'un ti Jtote ti laj stacun talele. Ti Jtote ti laj stacun talele melel ti sc'ope ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yu'un ti muc sc'an xch'unic ti ja' ti Cristoe hech yu'un muc xa'ibeic sjam ti ja' laj xcholbe sc'opilal ti Jtotic Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hech yu'un ti Jesuse hech laj yalbe: ―C'alal chajipanun ti cruz, ho'on ti co'ol crixchanoucutique, te me chana'ic ti ho'on Jcoltavanejun avu'unique. Te me chana'ic ti ja' no'ox laj calboxuc hech chaj c'u che'el albilun yu'un ti Jtote, ja' ti laj stacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mu xiscomesun yu'un scotol c'ac'al ti jpas ti c'usi tsc'an ti yo'ntone ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","C'alal hech laj yal ti Jesuse, ep laj xch'unic ti ja' ti Jcoltavaneje. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Hech yu'un ti Jesuse hech laj yalbe ti jchi'iltaque, ja' ti much'u xch'unojique: ―Mi j'ech'el chavac' ti avo'ntonic ti jc'ope, mero cajchanc'opoxuc chac'otic cu'un obi. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Chana'ic ti c'op ti ja' melele. Ti c'op ti ja' melele, ja' chayac'oxuc ti libre ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Hech itac'avic ti crixchanoetique: ―Ho'ontutique yelnich'onuntutic ti Abrahame. Mi junucuntutic mu'yuc bu ochemuntutic ti mozoil. ¿C'u yu'un hech chaval: “Libre chac'otic”, xachi? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Hech itac'av ti Jesuse: ―Melel ti c'usi chacalbeique, scotol ti much'u tsa'ilan smule oy ti mozoil yu'un smulic obi. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ti much'u oy ti mozoile mu'yuc c'usi ch-ac'bat yu'un ti yajvale. Ja'uc ti much'u nich'onile ja' scotol ch-ac'bat yu'un ti stote. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hech yu'un mi ho'on chacac'oxuc ti libre, ho'on ti Snich'onun ti Diose, libre chac'otic o ti mero melel. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Hovil chavalic ti ho'oxuc yelnich'onoxuc ti Abrahame. Q'uelo avil chavalbucun jmilel. Yu'un puru milvanej oy ti avo'ntonic hech mu xc'ot ti avo'ntonic ti jc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ho'oni ja' ti jchol ti hech chaj c'u che'el laj xa yac'bun jq'uel ti Jtote. Ho'oxuque ja' chapasic ti c'u che'el chayalboxuc smantal ti atotique ―x'utatic yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Hech itac'avic: ―Ja' jtotutic ti Abrahame ―xchiic. Ti Jesuse hech laj yalbe: ―Ti ja'uc yelnich'onoxuc ti Abrahame, hech chapasic hech chaj c'u che'el laj spas ti Abrahame ti hechuque. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ti ora to chavalbucun jmilel yu'un calojboxuc ava'yic ti c'usi melel ca'yoj ti stojol ti Diose. Mu hechuc laj spas ti Abrahame. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ho'oxuque chapasbeic yabtel ti atotique ―xut. Hech itac'avic: ―Ho'ontutique mu yol snich'onucuntutic jmulavil. Jun no'ox ti totil cu'untutique, ja' jtotutic stuc ti Diose ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ti Jesuse hech laj yalbe: ―Ti ja'uc atotic ti Diose, c'uxun ti avo'ntonic ti hechuque. Yu'un te niloc' tal ti stojol ti Diose. Mu jtucuc no'ox nital. Ja' tacbilun tal yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mu xava'ibeic sjam ti jc'ope yu'un mu xac'an chava'ibeic sjam. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ho'oxuque ja' atotic ti pucuje. Hech oy ti avo'ntonic chapasic c'usi tsc'an ti yo'ntone. Stalel jmilvanej c'alal ti sliqueb ti balumile hech ti ora to. Mu sc'an ti c'usi melele yu'un mu'yuc c'usi melel ti yo'nton. Mi tsnop c'op, stalel ono'ox. Ja' mero jnopc'op. Ja' chac' ti chanel ti nopc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yu'un melel ti c'usi chacalbeique, hech yu'un ti mu xac'an xach'umbucun ti jc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ho'oxuque mu xu' chatabun jmul ti ho'one. Melel ti jc'op ti calojboxuque. ¿C'u yu'un mu xach'umbucun? ");
INSERT INTO tzoNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ti much'utic yu'un ti Diose ja' chch'umbeic sc'op ti Diose. Ja' yu'un ti mu xach'umbeic sc'op ti Diose yu'un mu yu'unucoxuc ti Diose ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Hech i'albat ti Jesuse yu'un ti jchi'iltaque, ho'on ti co'ol judiountutic xchi'uque: ―Hech ono'ox hech chaj c'u che'el laj jnoptutic. Ho'ot liquemot tal ti Samaria. Oy pucuj ti avo'nton ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Hech itac'av ti Jesuse: ―Mu'yuc pucuj ti co'nton. Ja' chcac' ti pasel ti muc' ti Jtote. Ho'oxuque mu xapasucun ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mu jtucuc chcac' jba ti pasel ti muc'. Ja' chiyac'un ti pasel ti muc' ti Jtote. Ti much'u mu xispasun ti muq'ue, ja' stuc chchapan ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Melel ti c'usi chacalbeique, ti much'u chixch'umbun ti jc'ope ja' mu xcham ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Hech i'albat yu'un ti jchi'iltaque: ―Ti jna'tutic xa ti oy pucuj ti avo'nton. Icham ti Abrahame. Icham uc ti j'alc'opetic yu'un ti Diose. Ho'ot chaval: “Ti much'u chixch'umbun ti jc'ope, ja' mu xcham”, xachi. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Caso me tsots avabtel avich'oj ho'oti. Ja' tsots yabtel laj yich' ti jtotic Abrahame ti ichame. Icham uc ti j'alc'opetic yu'un ti Diose. ¿Much'uot chacuy aba? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Hech itac'av ti Jesuse: ―Mi ho'on chcac' jba ti pasel ti muc', mu'yuc sjam. Ti Jtote, ja' ti Dios avu'unic ti chacuyique, ja' chiyac'un ti pasel ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mu xavojtiquinic. Ho'on xcojtiquin. Mu xcojtiquin ti Diose, mi xichie, ti jnop c'op hech chaj c'u che'el ti chanopic c'op ti ho'oxuque. Ho'on xcojtiquin ti Diose. Ti jpasbe ti muc' ti sc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ti atotic Abrahame ti chavalique nichim no'ox yo'nton yu'un ya'yoj jc'opilal ti chitale. Laj xch'un ti chitale, hech yu'un nichim no'ox yo'nton ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Hech yu'un hech i'albat ti Jesuse yu'un ti jchi'iltaque: ―Mu to avich'ojuc lajuneb yoxvinic habil, ¡bu c'amba avil ti Abrahame ti chavale yu'un queremot to! ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ti Jesuse hech laj yalbe: ―Melel ti c'usi chacalbeique, c'alal mu to anemuc ti Abrahame, jtalel te oyun ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hech yu'un bat stamic tal ton ti jchi'iltaque. Sc'an chac'beic ton ti Jesuse. Hech yu'un ti Jesuse laj sq'uej sba. Iloc' batel ti templo. Hech i'ech' batel ti o'lol crixchanoetic. Hech ibat o. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ti bu ni'ech'tutic batel xchi'uc ti Jesuse te laj quiltutic jun jchi'iltutic. Ma'sat c'alal i'an ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ho'ontutic ti yajchanc'opuntutic ti Jesuse hech laj jac'betutic ti Jesuse: ―Maestro, ¿much'u smul ti yu'un ma'sat i'an avi jchi'iltic li'to? ¿Mi ti scoj smul stuc, mi ti scoj smul stot sme'? ―xichitutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Hech itac'av ti Jesuse: ―Mu ti scojuc smul avi jchi'iltic li'to, mu ti scojuc smul stot sme'. Yu'un ti ma'sat i'an ti jchi'iltique, ja' no'ox yu'un hech chvinaj yabtel Dios ti sventa. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","C'alal cuxulun li' ti balumile ja' yorail ti xu' jpasbe yabtel ti Jtote ti laj stacun talele. Mi nichame mu xa xu'. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ti jayib c'ac'al li'oyun li' ti balumile ho'on hech chaj c'u che'el luz c'otemun avu'unic ho'oxuc ti li'oyoxuc li' ti balumile yu'un chacac'bot avil ti lequil bee ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","C'alal laj yal hech ti Jesuse laj stubta ts'ubilum. Laj spas ti ach'el ti ts'ubilume. Laj sbombe ach'el ti sat ti ma'sate. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Hech laj yalbe: ―Batan, ba poco tal asat ti ho' te ti estanque Siloé sbi ―x'utat. Ti Siloe sbie ja' sjam ti ic'bil chtal ti ho'e. Ibat ti ma'sate, ba spoc sat te ti Siloe. C'alal isut tal, chil xa balumil. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hech yu'un laj sjac'be sbaic ti svecinotaque xchi'uc ti much'utic yilojic ti ma'sat ono'oxe: ―¿Mi ma'uc li'to ti much'u laj snacan sba sc'an paramote? ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Oy much'u hech laj yal: ―Ja' lume ―xchiic. Oy yan hech laj yalic: ―Ma'uc, ja' no'ox co'ol x'elan ―xchiic. Hech itac'av ti vinique: ―Ho'on chavile ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hech ijac'bat: ―¿C'u che'el ijam asat? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Hech itac'av ti vinique: ―Ja' ti jchi'iltic Jesús sbi, ja' laj spas ti ach'el ti ts'ubilume. Laj sbombun ti jsat. “Batan ti yo' bu Siloé sbi, ba poco tal asat”, xiyutun. Hech nibat, ba jpoc jsat. Hech yu'un chquil xa balumil ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Hech lic sjac'beic: ―¿Bu oy ti much'u chavale? ―xchiic. ―Mu jna' bu ibat ―xchi xtac'av ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Laj yiq'uic batel sva'anic ti stojol ti fariseoetique ti much'u ma'sat ono'oxe. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ja' sc'ac'alil ti jcux co'ntontutic c'alal laj spas ti ach'el ti ts'ubilum ti Jesuse, c'alal laj sjambe sat ti ma'sate. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Laj sjaq'uic uc ti fariseoetique c'u che'el ijambat ti sate. Hech itac'av ti vinique: ―Laj sbombun ach'el ti jsat. Patil ba jpoc jsat. Hech yu'un chquil xa balumil ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Hech yu'un hech i'albat yu'un cha'vo' oxvo' ti fariseoetique: ―Mu'yuc ti stojol ti Diose ti vinique ti chavale yu'un mu xchabi ti sc'ac'alil ti jcux co'ntontique ―xchiic. Oy yan hech laj yalic: ―¡Bu c'amba hu'uc yu'un tspas avi jchop o abtel li'to ti much'u oy smule! ―xchiic. Hech cha'tos ic'otic ti fariseoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Hech yu'un hech laj sjac'beic yan vuelta ti ma'sate: ―Ho'ot, ¿c'usi xchi avo'nton yu'un ti much'u laj sjambot asate? ―xut. Hech itac'av ti vinique: ―Ho'on chcal ti ja' j'alc'op yu'un ti Diose ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ti jchi'iltaque muc xch'unic ti ja' ma'sat ono'oxe. Ja'to ba yiq'uel tal ti stot sme'e ti much'u ijam xa sate, ja'to laj xch'unic ti ja' ijam xa ti sate. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Hech hul jac'batuc ti stot sme'e: ―¿Mi ja' avol anich'on li'to ti ma'sat ono'ox c'alal i'an ti chavalique? ¿C'u che'el ti chil xa balumil ti ora to? ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Hech itac'av ti stot sme'e: ―Ja' col jnich'on li'to, ti ma'sat c'alal i'ane. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero mu jna'tutic c'u che'el chil xa balumil. Mu jna'tutic uc ti much'u ijambat ti sate. Oy xa yo'nton. Jac'bo ava'yic. Ac'o yal stuc ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yu'un ti hech laj yalic ti stot sme'e, yu'un ixi' yu'un ti totiletic cu'untutique. Yu'un ti totiletique xchapoj xa sc'opic ti j'ech'el mu stac' ch-och ti templo ti much'u jamal chal ti ja' ti Jcoltavaneje ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ja' sventail ti hech laj yalic ti stot sme'e: “Oy xa yo'nton, jac'bo ava'yic”, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hech yu'un laj xcha'iq'uic tal ti much'u ma'sat ono'oxe. Hech hul albatuc: ―Jamal chaval ti stojol Dios ti ja' jp'ajmantal ti vinique. Ti ho'ontutique ti jna'tutic ti ja' jp'ajmantal ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Hech itac'av ti vinique: ―Mu jna' mi jp'ajmantal. Ja' no'ox jna' ti chquil xa balumil ti ora to, ti ma'satun ono'oxe ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Laj xcha'jac'beic yan vuelta: ―¿C'usi laj yutot? ¿C'u che'el laj sjambot ti asate? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hech itac'av ti vinique: ―Laj xa calbot ava'yic. Mu xac'an xach'unic. ¿C'u yu'un chac'an chava'yic yan vuelta? ¿Mi yu'un chac'an cha'ochic ti yajchanc'op uc? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hech yu'un lic slabanic. Hech lic yalbeic: ―Ho'oti yajchanc'opot jmulavil. Ho'ontutique yajchanc'opuntutic ti Moisese jcotoltutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jna'tutic ti laj sc'opon ti Moisese ti Diose. Ti much'u chavale mu jna'tutic bu liquem tal ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Hech itac'av ti vinique: ―Xch'ay co'nton xca'i ti mu xana' bu taleme. Ja' laj sjambun jsat chavil. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ti jna'tic ti mu stsacbe sc'op jmulaviletic ti Diose. Ti much'u chi' ti Diose, ti tspasbe ti c'usi tsc'an ti yo'ntone, ja' tstsacbat sc'op yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","C'alal ilic ti balumile asta ti ora to mu'yuc much'u hech a'ibil sc'opilal ti xu' tsjambe sat ti much'u ma'sat c'alal i'ane. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ti manchuc loq'uem tal ti stojol ti Diose ti much'u chcale, mu xu' yu'un spas ti hechuque ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Hech lic yalbeic: ―¡Bu c'amba achanubtasuntutic ho'ontutique! Yu'un pucujot ono'oxe, hech yu'un ti ma'sat c'alal na'ane ―x'utat. Hech i'albat ti j'ech'el mu stac' ch-och ti templo. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ti Jesuse laj ya'ibe sc'opilal ti j'ech'el mu stac' ch-och ti templo ti vinique. Hech yu'un ital ti Jesuse, tal sc'opon ti vinique. Hech laj sjac'be: ―¿Mi ach'unoj ti jelaven sp'ijil ti Snich'on ti Diose? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Hech itac'av ti vinique: ―¿Much'u? tote. Ti jc'an ti jch'un ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ti Jesuse hech laj yalbe: ―Aq'uelojbe xa sat. Ho'on ti chajc'oponote ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Itac'av ti vinique, hech laj yalbe: ―Chajch'unot, Cajval ―xchi. Hech lic squejan sba ti stojol ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ti Jesuse hech laj yalbe: ―Nital li' ti balumile, tal chapanvanucun. Tal cac'be yojtiquinic ti Diose ti much'utic tsc'an chojtiquinic ti Diose. Hech ma'sat chcomic ti much'utic ti chojtiquinic ti Diose ti scuyojique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Oy fariseoetic te xchi'inojic ti Jesuse. Laj ya'yic ti hech laj yal ti Jesuse. Hech lic sjac'beic: ―¿Mi yu'un ma'satuntutic chacuyuntutic? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Hech itac'av ti Jesuse: ―Ti ja'uc ma'satucoxuque, mu'yuc amulic ti hechuque. Yu'un chcojtiquintutic ti Diose, xachiique, hech yu'un ja' amulic ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ti Jesuse hech laj yalbe ti jchi'iltaque: ―Melel ti c'usi chacalbeique, a'yic me. Ti much'utic ti j'elec'carneroetique mu x'och ti ti'corral, ja' chp'it ochel ti xocon ti ti'corrale. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ja'uc ti mero yajval ti carneroetique ja' ch-och ti ti'corral. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ti jchabiejcorrale tsjambe sti' corral yu'un ch-och batel ti mero jq'uelcarneroe. Ti carneroetique cha'ibeic sc'op ti yajvale. Ti yajvale tsbiiltas ti jaycot ti scarneroe. Tsloq'ues batel. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","C'alal laj xa sloq'ues batel ti jaycot ti scarneroe, ja' jbael chbat ti yajvale. Ti carneroetique ja' sts'acliic batel ti yajvale yu'un ch-ic'at yu'un ti yajvale. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ti much'u mu ti ti'corraluc ch-och talele ja' mu sts'acliic batel. Chjatavic batel ti carneroetique yu'un mu xa'ibeic sc'op ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Hech oy ti lo'il laj yac' ti a'yel ti Jesuse. Ti jchi'iltaque muc xa'ibeic sjam ti c'u che'el i'albat yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ti Jesuse hech laj yalbe uc: ―Ho'on jventainoj ti sti' scorral scarnero ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Scotol ti much'utic jq'uelcarneroetic scuyoj sbaique ti jbael li' ono'ox oyique, ja' jlo'lavanejetic. Ja' hech chaj c'u che'el j'elec'carnero yu'un ja' tsc'an chispojbun ti much'utic chists'acliune. Ti much'utic chists'acliune ja' mu xba spasbeic ti muc' ti sc'opic ti jlo'lavanejetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ho'on jventainoj ti sti' scorral scarnero ti Diose. Ti much'utic chch'unic ti chcolic ti jventae, ja' scarnero ti Diose chc'otic o. Hech chaj c'u che'el ti carneroetique ti lec chabibil chloc' ch-och yu'un hech tsta sve'el, ja' no'ox hech uc ti much'utic i'ochic xa ti scarnero ti Diose, lec chabibil, nichim no'ox yo'ntonic o, mu'yuc xa palta cha'yic. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ti j'elec'carneroe ja' no'ox yabtel ch-elc'aj, chmilvan, chjinvan. Ja'uc ti ho'one tal cac'be xcuxlejalic sbatel osil. Hech jun no'ox yutsil chc'otic o. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Hech chaj c'u che'el ti lequil jq'uelcarnero lec chchabi ti scarneroe mu'yuc sc'opilal mi chti'at yu'un ti bolome, ja' no'ox hechun uc ho'oni lec ti jchabi ti much'utic chch'unic ti ho'on Jcoltavanejun yu'unique. Chcac' jba ti milel yu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ti much'u ja' no'ox tsa' abtel yu'un chchabi ti carneroetique yu'un mu yu'unuc ti carneroetique hech yu'un mi chil chtal bolom, tscomes ti carneroetique. Chjatav batel. Hech oy chlaj ti ti'el yu'un bolom ti carneroetique. Ti yane chpuquic batel. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yu'un ti chjatavic batel ti jsa'abteletique, yu'un mu c'uxuc cha'yic ti carneroetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Hech chaj c'u che'el ti lequil jq'uelcarnero lec chchabi ti scarneroe, ja' no'ox hechun uc ho'oni lec ti jchabi ti much'utic chch'unic ti chcolic ti jventae. Xcojtiquin, xiyojtiquinucun uc. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Xcojtiquin jbatutic xchi'uc hech chaj c'u che'el xcojtiquin jbatutic xchi'uc ti Jtote. Xiyojtiquinun ti Jtote. Ho'oni xcojtiquin uc ti Jtote. Ho'oni chcac' jba ti milel yu'un scotol ti much'utic chists'acliune. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Oy yanlum crixchanoetic chlic xch'umbun jc'op uc. Persa chquic' tal ti jtojol uc. Chiya'ibun jc'op uc hech jtos no'ox chac'otic xchi'uc ti jayiboxuc ti chach'umbun ti jc'ope. Jun no'ox totil avu'unic chc'ot acotolic. Ho'on obi. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Yu'un ti chcac' jba ti milel yu'un ti much'utic chists'acliucune hech yu'un c'uxun ti yo'nton ti Jtote. Patil chlic cha'cuxiucun. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mu'yuc much'u xu' yu'un chismilun. Ho'oni yutsil co'nton chcac' jba ti milel. Xu' cu'un chcac' jba ti milel. Xu' cu'un chicha'cuxi nixtoc. Hech smantal ti Jtote ti quich'oje ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Cha'tos ic'otic ti jchi'iltaque yu'un ti hech laj yal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ep laj yalic: ―Oy pucuj ti yo'nton. Chujuben sjol lume. ¿C'u yu'un chava'ibeic sc'op? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Oy yantic laj yalic: ―Li'to mu hechuc sc'op ti much'u oy pucuj ti yo'ntone. Mu xu' tsjambe sat ma'satetic pucuj ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Te ti jteclum Jerusalén ja' yorail q'uin c'alal ti jna'tutic ti c'u che'el icha'meltsaj ti templo cu'untutic ti vo'one yu'un ac'o tunuc yu'un yan vuelta ti Diose, ho'ontutic ti judiountutique. Ja' yorail taiv. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Te chanav ti yut templo ti Jesuse yo' bu scorredor Salomón sbi. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Hech yu'un ti jchi'iltaque tal sjoyubtaic ti Jesuse. Hech laj sjac'beic: ―¿Jayib to c'ac'al chavac' lo'lajuc co'ntontutic avu'un? Mi ho'ot ti Jcoltavanejote, jamal me xaval ca'itutic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Hech itac'av ti Jesuse: ―Laj xa calboxuc, mu xach'unic. Laj xa aq'uelic uc ti jchop o abteletic ti laj xa jpas ti sventa ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mu xach'unic yu'un mu cu'unucoxuc ti ho'oxuque. Hech laj xa calboxuc ava'yic. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yu'un ti much'u cu'une, ja' chiya'ibun jc'op. Ho'oni xcojtiquin. Ja' chists'acliucun. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Chcac'be xcuxlejalic sbatel osil. Mu xch'ayic sbatel osil. Mu'yuc much'u xu' chispojbun loq'uel ti jc'ob. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ti Jtote laj yac'bun ti jc'ob. Jelaven xu' yu'un tspas scotol. Mu'yuc much'u xu' chpojbat ti sc'ob ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ti Jtote jun oyun xchi'uc ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hech yu'un ti jchi'iltaque ba stamic tal ton yu'un sc'an chac'beic ton yan vuelta ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Hech i'albat yu'un ti Jesuse: ―Oy ep lequil abteletic laj xa jpasboxuc aq'uelic ti sventa ti Jtote. ¿C'usi abtelal mu xtun laj jpas yu'un chavac'bucun ton? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Hech itac'av ti jchi'iltaque: ―Ma'uc chacac'bot ton yu'un ti lec avabtele. Ja' yu'un chatoy aba ti stojol ti Diose. Ho'ot vinicot no'ox. Diosot chacuy aba ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ti Jesuse hech laj yalbe: ―Hech ts'ibabil ti sun ti Diose ti avich'ojique: “Ti ho'oxuque jq'uexoloxuc”, xacutic, xchi ti Diose, xut ti juezetic ti vo'one. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Jq'uexoloxuc”, xchi sc'opilal ti much'utic i'ac'batic yabtel yu'un ti Diose ti vo'one. Mu xu' xch'ay ti hech yaloj ti Diose ti sun. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Lec ti hech i'albatic sc'opilale, xachiic. Hech yu'un ¿c'u yu'un chavalic ti ho'on ti jtoy jba ti stojol ti Diose yu'un ho'on Snich'onun ti Diose ti xichie? Yu'un ho'on ac'bilun cabtel yu'un ti Jtote hech yu'un ti nital li' ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mi ma'uc yabtel ti Jtote ti jpas chacuyique, mu me xach'umbun jc'op che'e. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mi ja' yabtel ti Jtote ti jpas ti chavilique, ch'unic me manchuc mi mu xach'umbun jc'op ho'oni. Yu'un mi chach'unic ti ja' yabtel ti Jtote ti jpase hech chana'ic ti jun oyun xchi'uc ti Jtote ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Hech yu'un yan vuelta c'an stsaquic ti Jesuse. Mu'yuc bu ihu' yu'unic yu'un laj sq'uej sba batel ti ora ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yan vuelta nibatutic xchi'uc ti Jesuse lum ti jech uc'um Jordán ti bu lic yac' ich'ho' ti Juane. Te nihalejtutic xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","C'alal te oyuntutic, ep jchi'iltac ital ti stojol ti Jesuse. Hech laj yalic: ―Manchuc mi muc spas jchop o abtel ti Juane, melel ti c'u che'el laj yalbe sc'opilal ti jchi'iltic li'to ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Hech yu'un ti much'utic italique, oy ep much'utic laj xch'unic ti ja' Jcoltavanej ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Itsaqui ti chamel jun jchi'iltutic, Lázaro sbi. Ja' Betania sbi ti slumal ti Lázaroe. Ja' ti biq'uit jteclum te ti estado Judea, ja' te nacajtic ti cha'vo' antsetique, ja' ti Maríae xchi'uc ti Martae. Yuts yalal sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ja' ono'ox ti María ti patil lic smalbe perfume ti yacan ti Cajvaltique, ti lic scusbe yacan ti stsotsil sjole. Ti much'u tsacbil ti chamele, ja' ti Lázaroe, ja' ximel ti Maríae. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hech yu'un ti yixleltac ti Lázaroe laj stac ti iq'uel ti Jesuse. ―Cajval, tsacbil ti chamel ti Lázaroe ti c'ux ti avo'ntone ―xchi c'otel ti much'u laj stac batele. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","C'alal laj ya'i ti Jesuse, hech laj yal: ―Yu'un ti itsacat ti chamele, mu yu'unuc ja' sventa j'ech'el chcham o. Ja' sventa no'ox ch-ac'at ti pasel ti muc' ti Diose. Ja' no'ox yu'un hech chi'ac'at ti pasel ti muc' ti ho'on ti Snich'onun ti Diose ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Ti Jesuse manchuc mi c'ux ti yo'nton ti Martae xchi'uc ti smuque xchi'uc ti Lázaroe, ti c'alal laj ya'i ti tsacbil ti chamel ti Lázaroe, chib to c'ac'al te nihalejtutic te ti bu ono'ox oyuntutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Patil ti Jesuse hech lic yalbuntutic ho'ontutic ti yajchanc'opuntutique: ―Sutucutic batel ti Judea yan vuelta ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ho'ontutic ti yajchanc'opuntutique hech lic calbetutic: ―Maestro, ja'to no'ox c'an yac'bot ton ti jchi'iltique. ¿Mi te chabat yan vuelta? ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ti Jesuse laj yac'bun jna'tutic ti c'u x'elan yabtel ti Diose. Hech laj yalbuntutic: ―P'isbil lajcheb ora jujun c'ac'al ti yac'oj ti Diose. Ti much'u chanav ti c'ac'altic mu sp'osi yacan yu'un oy to ti squeval ti c'ac'ale. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ja'uc mi i'ic'ub ti osile, ja' laj sta yorail ti tsp'osi yacan yu'un itup' xa ti squeval ti c'ac'ale ―xiyutuntutic. Hech laj yac'bun jna'tutic ti ja'to mi laj sta yorail yu'un ti Diose ti chmilate, ja'to xu' yu'un ti jchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Patil hech laj yalbuntutic uc: ―Ivay xa ti quermanotique, ja' ti Lázaroe. Ho'oni chba jtij liquel yu'un vayal xa ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Hech lic calbetutic, ho'ontutic ti yajchanc'opuntutique: ―Cajval, mi vayale, ja' sna'oj chlic stuc ―xichitutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Hech laj yal ti Jesuse yu'un icham xa ti Lázaroe. Ho'ontutic ti yajchanc'opuntutique laj jcuytutic ti chcux no'ox yo'nton yu'un ti vayale. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hech yu'un ti Jesuse hech jamal laj yalbuntutic: ―Icham xa ti Lázaroe. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nichim no'ox co'nton yu'un mu teucutic. Yu'un ja' sventailuc ti mu teucutique yu'un hech chach'unic. Batic che'e, ba jq'ueltic ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hech yu'un ti jun jchi'iltutic ti abtele ja' ti Tomas sbie, ja' ti vats xcututique, hech lic yalbuntutic: ―Batic, co'ol ac'o chamucutic xchi'uc ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Hech nibatutic xchi'uc ti Jesuse. C'alal nic'otutic, oy xa chanib c'ac'al mucul ti Lázaroe. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ti Betaniae nopol xil sbaic xchi'uc ti Jerusalene. Oy van o'lol reva xil sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ep ti jchi'iltaque ti italic, tal smuc'ubtasbeic yo'ntonic ti Martae xchi'uc ti Maríae yu'un ti icham xa ti ximele. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ti Martae c'alal laj ya'ibe sc'opilal ti chtal ti Jesuse, tal snup ti be. Ti Maríae te nacal icom ti sna. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ti Martae hech hul yalbe ti Jesuse: ―Cajval, ti li'ucoti ti c'alal itsacat ti chamel ti jximele, muc xcham ti hechuque. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Jna' ti scotol ti c'usi chac'ambe ti Diose ti ora to, ja' chayac'bot ti Diose ―xchi ti Martae. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ti Jesuse hech laj yalbe: ―Chcha'cuxi loq'uel ti ch'en ti aximele ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Hech itac'av ti Martae: ―Jna' ti chcha'cuxi loq'uel ti ch'en ti slajebal c'ac'al c'alal chcha'cuxiic scotolic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ti Jesuse hech laj yalbe: ―Oy cha'cusesel ti jventa jtuc. Oy cuxlejal sbatel osil ti jventa jtuc. Ti much'utic chixch'unun ti ho'on Jcoltavanejun yu'une, manchuc mi chlaj yip ti sbec'tale, ja' cuxul sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Scotol ti much'utic chcuxi sbatel osile, ja' ti much'utic chixch'unun ti ho'on Jcoltavanejun yu'une, j'ech'el mu'yuc xa sc'opilal ti ch'ayel chbatique. ¿Mi hech ach'unoj? ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Hech itac'av ti Martae: ―Hech, Cajval. Jch'unoj ti ho'ot ti Jcoltavanejote, ti ho'ot Snich'onot ti Diose, ti ho'ot hech ono'ox ac'opilal ti chatal li' ti balumile ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","C'alal hech laj yal ti Martae, ba yic' tal ti smuque, ja' ti Maríae. Mucul no'ox c'ot yalbe: ―Ital xa ti Maestroe. Ja' chayic'ot ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","C'alal laj ya'i ti Maríae, ilic ti ora. Tal sc'opon ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mu to chihultutic xchi'uc ti Jesuse te ti biq'uit jteclum. Ti Maríae te hul stauntutic ti ora ti bu laj scomesuntutic xchi'uc ti Jesuse ti Martae. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hech yu'un ti jchi'iltaque ti te xchi'inojic ti sna ti Maríae yu'un tal smuc'ubtasbeic yo'ntonic, c'alal laj yilic ti iloc' talel ti ora ti Maríae, laj sts'acliic talel uc. Hech laj yalic: ―Yu'un chba oc'uc ti bu mucul ti ximele ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ti Maríae c'alal ihul ti stojol ti Jesuse, laj sq'uelbe sat, lic spatan sba ti lum te ti stojol. Hech laj yalbe: ―Cajval, ti li'ucoti ti c'alal itsacat ti chamel ti jximele, muc xcham ti hechuque ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","C'alal laj yil ti Jesuse ch-oc' ti Maríae, ch-oq'uic uc ti jchi'iltaque ti te xchi'inojic tale, mu xtun laj ya'i ti hech oy li' ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Hech lic sjac'be: ―¿Bu laj amuquic comel? ―xchi. Hech i'albat yu'unic: ―Ba jq'ueltic, Cajval ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Lic oc'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Hech yu'un hech lic yalbe sbaic ti jchi'iltaque: ―Q'uelo avil, c'ux ti yo'nton ti Lázaroe ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Oy much'utic hech laj yalic: ―Ti lajuc sc'ane, laj scolta ti Lázaroe ti hechuque, hech yu'un muc xcham. Yu'un xu' yu'un tsjambe sat ti much'u ma'sate ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","C'alal nic'otutic xchi'uc ti Jesuse ti bu ti ch'ene, oy palta laj ya'i ti yo'nton yan vuelta yu'un ti hech oye. Ti ch'ene ja' pujul. Ton ti smac sti'e. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ti Jesuse hech laj yal: ―Loq'ueso ti tone ―xchi. Hech i'albat ti Jesuse yu'un ti Martae, ja' ti yixlel ti Lázaro ti ichame: ―Cajval, tu xa yu'un xchanibal xa c'ac'al mucul ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ti Jesuse hech laj yalbe: ―Laj calbot ti mi chach'une, hech chaq'uel ti jelaven sp'ijil ti Diose, xacut ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Hech yu'un laj sloq'uesic ti ton ti smacojbe sti' ti ch'ene yo' bu mucul ti ánimae. Ti Jesuse laj sq'uel muel vinajel. Hech lic sc'opon Dios: ―Tote, hocol avalbun ti chatsacbun jc'op. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Jna' ti scotol c'ac'al chatsacbun jc'op. Hech chcal yu'un ac'o ya'yic ti much'utic nopol va'ajtic li'to yu'un hech chch'unic ti ho'ot laj atacun talele ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","C'alal laj yal hech, tsots ic'opoj ti Jesuse: ―¡Lázaro, loc'an tal! ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hech iloc' tal ti animae. Bech'bil sc'ob yacan ti poc'. Pixbil sjol ti paño. Ti Jesuse hech laj yalbe ti crixchanoetique: ―Jitumbo, ac'o batuc ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Hech yu'un ep ti jchi'iltaque ti te xchi'inojic tal ti Maríae, laj xch'unic ti ja' Jcoltavanej ti Jesuse c'alal laj sq'uelic ti hech laj xcha'cuses ti anima ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ti much'utic muc xch'unique mu xtun laj yilic, ba yalbeic ti fariseoetique ti ep ti much'utic ich'umbat sc'op ti Jesuse yu'un ti laj xcha'cuses ti animae. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hech yu'un ti totil paleetique xchi'uc ti fariseoetique laj stsobic tal scotol ti xchi'iltac ti abtele. Hech laj yalic: ―¿C'usi chcutic? Ep señailetic tspas ti vinic ti chcaltique. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ac'o spas hech, mi xijchie, hech chch'unic scotol jchi'iltic ti ja' Jcoltavanej cu'untique. Hech tstiq'uic ti ajvalil. Hech yu'un chlic sjol ti totil ajvalil ti te ti Romae. Hech tstac talel yajsoldado. Hech chtal spasic pleito li' ti jlumaltique, hech chismilucutic jcotoltic ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Te oy jun xchi'il ti abtel, Caifás sbi. Ja' yorail ochem ti totil pale ti habil lume. Hech laj yal: ―Ho'oxuque, mu xana'ic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mu xava'ibeic sjam ti ja' lec mi chcham cu'untic jun no'ox jchi'iltic. Ja' mu xtun mi chijcham jcotoltic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mu stucuc no'ox hech laj yal. Yu'un ochem ti totil pale ti habil lume, hech yu'un ich'amumbat ye yu'un ti Diose yu'un hech laj yalbe sc'opilal ti Jesuse ti ja' jq'uexoltutic chcham yu'un jcotoltutic, ho'ontutic ti judiountutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma'uc no'ox chcham cu'untutic ho'ontutic ti judiountutique, ja' chcham yu'un scotol yol xnich'nab ti Diose ti buc no'ox oyic ti sjoylejal balumil, hech jun no'ox chijc'otucutic jcotoltic. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Hech yu'un ti totiletique ti ora lic xchapambeic sc'opilal yu'un tsmilic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hech yu'un ti Jesuse muc xac' sba ti q'uelel ti stojol ti jchi'iltaque, ho'ontutic ti co'ol judiountutic xchi'uque. Hech yu'un laj jq'uej jbatutic batel xchi'uc ti Jesuse ti yan balumil nopol xil sbaic xchi'uc ti xocol balumile. Te nic'otutic ti jteclum Efraín sbi. Te nihalejtutic xchi'uc ti Jesuse ho'ontutic ti yajchanc'opuntutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Po'ot xa tsta yorail q'uin cu'untutic. Ja' ti q'uin Pascua sbie c'alal ti jna'tutic ti c'u che'el icoltaat loq'uel ti Egipto ti vo'one ti antiguo jtatamoltutique. Yu'un po'ot xa ti q'uine, oy ep ti jchi'iltaque icajbatic te ti Jerusalén yu'un te chba scaj'ac' sbaic ti lecubtasel yu'un hech lec ac'o ilatuc yu'un ti Diose ti yorail ti q'uine. ");
INSERT INTO tzoNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","C'alal ic'otic ti Jerusalén, laj ya'ibeic smantal ti totil paleetique xchi'uc ti fariseoetique ti mi oy much'u yiloj bu oy ti Jesuse, jamal ac'o yalic ti much'u yiloje yu'un chich' tsaquel ti Jesuse. Hech yu'un lic sa'ic ti Jesuse ti crixchanoetique. Scotolic ti much'utic te xa oyic ti templo te ti Jerusalén, hech lic sjac'be sbaic: ―¿C'usi chanopic? ¿Mi mu xtal ti q'uin xana'? ―xut sbaic. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Vaquib xa c'ac'al tsc'an tsta yorail q'uin Pascua. Nic'otutic xchi'uc ti Jesuse te ti jteclum Betania yo' bu nacal ti Lázaroe, ja' ti icha'cusesat loq'uel ti ch'en yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Laj yic'untutic ti ve'el ti Martae xchi'uc ti Jesuse. Ti Lázaroe laj xchi'inuntutic ti naclej ti mesa xchi'uc ti Jesuse xchi'uc yantic. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ti Maríae laj yich' tal o'lol kilo perfume, nardo sbi. Toyol stojol ti nardoe. Tal smalbe ti yacan ti Jesuse. Ti Maríae laj stsac ti sjole, hech lic scusbe yacan ti stsotsil sjol. Ti sjunul sna ipuc yic' ti perfumee. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Te oy uc ti jun jchi'il ti abtele, ja' ti Judas sbie. Ja' snich'on Simon Iscariote. Ja' ti much'u ta xa xac' entrecal ti Jesuse. Hech laj yal ti Judase: ");
INSERT INTO tzoNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Ti lajuc xchon avi perfume li'to, oxib ciento denariotaq'uin iloc' stojol ti hechuque. Ja' lec ti lajuc yac'be me'onetic ti taq'uine ―xchi ti Judase. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yu'un ti hech laj yale, mu yu'unuc c'ux ti yo'nton ti me'onetique. Ja' no'ox yu'un j'elec'. Ja' sventainoj ti sbolsail jtaq'uintutique xchi'uc ti Jesuse. Ja' laj yelc'anilan jujuti' ti jtaq'uintutique ti te laj jtiq'uilantutic ti sbolsaile. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ti Jesuse hech lic yalbe ti Judase: ―Mu me xaval hech. Ja' sventa yorail jmuquel ti sq'uejojbun perfume avi to. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Scotol c'ac'al achi'inojic ti me'onetique. Ho'oni mu scotoluc c'ac'al chajchi'inoxuc ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ti jchi'iltaque ti te xa stsoboj sbaic ti Jerusalén, laj ya'yic ti te xa nihultutic ti Betania xchi'uc ti Jesuse. Hech yu'un italic. Ma'uc no'ox tal sq'uelic ti Jesuse. Ja' tal sq'uelic uc ti Lázaroe, ja' ti icha'cusesat loq'uel ti ch'en yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ti c'alal italic mu to xch'unic ti ja' Jcoltavanej ti Jesuse. Ti c'alal isutic batele, laj xa xch'unic ti ja' ti Jcoltavaneje yu'un laj yilic ti icuxi xa ti Lázaroe. Hech yu'un ti totil paleetique lic xchapambeic sc'opilal yu'un tsmilic uc ti Lázaroe. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ti yoc'omal ti jchi'iltaque ti te stsoboj sbaic scotolic te ti Jerusalén yu'un italic xa ti q'uin, laj ya'yic ti chtal ti Jerusalén ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Hech yu'un scotolic laj stuch'ic xan. Iloq'uic tal ti jteclum. Stuch'ojic tal ti sc'obic ti xane, tal snupic ti be. Tsots ic'opojic talel. Hech laj yalic: ―Li' xa oy ti Jcoltavanej cu'untique. Jun no'ox yutsil ti itacat xa tal yu'un ti Cajvaltic Diose. Ja' ch-och ti ajvalil cu'untic ho'ucutic ti yelnich'onucutic ti Israele ―xchiic. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Te oy jcot burro. Ti Jesuse laj scajlebin hech chac c'u che'el ts'ibabil comel: ");
INSERT INTO tzoNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ho'oxuc ti te nacaloxuc ti Jerusalene, mu me xaxi'ic. Chtal ti ajvalil avu'unique. Cajal ti burro chtal, ti xchie. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ho'ontutic ti yajchanc'opuntutique, muc xca'ibetutic sjam c'alal hech laj spas ti Jesuse. Ja'to c'alal isut batel ti vinajel ti Jesuse, ja'to laj jna'tutic ti hech ono'ox ts'ibabil comel sc'opilale, hech yu'un ti hech ipasatic ti muc' yu'un ti jchi'iltaque. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Yu'un ti tal nupvanuc ti be ti jchi'iltaque yu'un laj ya'ibeic sc'opilal ti Jesuse ti laj xcha'cuses ti Lázaroe. Ja' i'albatic yu'un ti much'utic laj xchi'inic ti Jesuse c'alal laj xcha'cuses loq'uel ti ch'en ti Lázaroe. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hech yu'un hech lic yalbe sbaic ti fariseoetique: ―Q'uelo avil, mu xu' cu'untic. Ep jchi'iltic tsts'acliic ti Jesuse chavil ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Oy grecia viniquetic chtalilanic ti q'uin uc. Co'ol chch'unic hech chaj c'u che'el jch'unojtutic ono'oxe, ho'ontutic ti judiountutique. Hech yu'un tal yac'beic smoton Dios ti q'uin uc. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ja' laj sc'oponic ti Felipee, ja' jchi'il ti abtel ti liquem tal ti jteclum Betsaida sbi, te oy ti estado Galilea. Hech laj yalbe vocol ti stojol: ―Tote, co'nton jc'opontutic ti Jesuse ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Hech yu'un ti Felipee ba yalbe ti Andrese. Hech yu'un hech xcha'va'alic tal yalbeic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Hech yu'un ti Jesuse hech lic yalbe ti xcha'va'alique: ―Ista xa yorail ti chvinaj ti ac'bilun cabtel sventa scotol crixchanoetic, ho'on ti co'ol crixchanoucutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Melel ti c'usi chacalbeique, persa chimilat yu'un hech ep ti much'utic ch-ac'bat xcuxlejalic sventa sbatel osil. Ja' hech chaj c'u che'el jp'ej sat trigo ti mi mu xich' muquel ti lum, stuc no'ox oy. Ja'uc mi chich' muquel ti lum, ep chlic satinuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ja' no'ox hechoxuc uc ti ho'oxuque. Ti much'u tsots sc'opilal cha'i ti xcuxlejal li' ti balumile, ja' chch'ay. Ti much'u mu tsotsuc sc'opilal cha'i ti xcuxlejal li' ti balumile, ti chich' vocol o chmilat ti jventae, ja' chcuxi sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Scotol ti much'utic tsc'an chtun cu'une, ac'o sts'acliun. Hech chc'o xchi'inucun ti naclej te ti vinajel. Yu'un ti much'u chtun cu'une, ja' tspasat ti muc' yu'un ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Manchuc mi vocol chca'i ti jpas, mu xcalbe ti Diose: Tote, coltaun yu'un hech mu xquich' vocol ti ora to, mu xichi ti stojol. Yu'un ja' sventail ti nital li' ti balumile, yu'un tal chamucun. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tote, ac'o pasatuc ti muc' ti abie ―xchi tsc'opon Dios ti Jesuse. Ti Diose hech lic stac'be sc'op, hech ic'opoj te ti vinajel: ―Cac'oj xa ti pasel ti muc' ti jbie. Yan vuelta chcac' ti pasel ti muc' ti jbie ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ti jchi'iltaque ti te va'ajtique, laj ya'yic ti tsots chc'opoj te ti vinajel. Oy much'u laj yalic: ―Ch-avan chavuc ―xchiic. Oy yan laj yalic: ―Ch'ul'abat ic'oponat yu'un ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ti Jesuse hech laj yalbe: ―Yu'un ti tsots laj sc'oponun ti Jtote, mu yu'unuc ac'o jna' ho'oni yu'un ti laj stsacbun jc'op ti Jtote. Yu'un ac'o xana'ic ti ho'oxuque ti chistsacbun jc'op ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yorail xa ti ora to ti ch-ich'bat sc'op yu'un smulic ti crixchanoetique ti much'utic mu ono'ox sc'an chixch'unune. Yorail xa ti ora to ti chpojbat yabtel ti pucuje ti ja' sventainojbe yo'ntonic scotol crixchanoetic. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ti ho'one yu'un ti chicham ti cruze, hech chtalic scotol crixchanoetic ti jtojol ti much'utic chch'unic ti ho'on Jcoltavanejun yu'unique ti sjoylejal balumil ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hech laj yac' ti na'el ti cruz chmilat. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Hech itac'av ti jchi'iltaque: ―Ca'yojbetutic sc'opilal ti Cristoe te ts'ibabil ti sun ti Diose. Chal ti sbatel osil oy ti Cristoe, ja' ti Jcoltavanej cu'untique. Mi ho'ot Cristoote, ¿c'u yu'un hech chaval: “Persa chimilat ti cruz, ho'on ti co'ol crixchanoucutique”, ti xachie? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Hech itac'av ti Jesuse: ―Hech chaj c'u che'el ti much'u chanav batel ti be yu'un j'oc' xa no'ox sac ti osile hech yu'un chac'be yipal naca me ic'ubuc osil yu'un. Yu'un mi i'ic'ub ti osile mu sna' bu chbat. Ja' no'ox hech uc ho'oni j'oc' xa no'ox li'oyun chajchanubtasoxuc. Hech yu'un ch'umbucun jc'op yu'un yorail to chach'unic. Yu'un hech chacolic sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yo'to li' jchi'inojoxuque ch'unic ti ho'on Jcoltavanejun avu'unic hech yol snich'on Dios chac'otic ti mero melel ―xchi ti Jesuse. C'alal laj yo'nton laj yal hech ti Jesuse, laj sq'uej sba. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hovil laj spas ep jchop o abteletic ti stojolic, muc xch'unic ti ja' Jcoltavanej yu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hech ic'ot sc'op ti Isaíase, ja' ti j'alc'op yu'un ti Diose. Hech ono'ox laj sts'iba: Cajval, ti much'utic laj calbe ac'ope, mu sc'an xch'unic. Mu spas ti muc' ti ho'ot laj xa acoltae, ho'ot ti jelaven ap'ijile, Cajval, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Muc xu' xch'unic yu'un ic'ot ti pasel hech chac c'u che'el laj yal uc ti Isaíase: ");
INSERT INTO tzoNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Macbil satic yu'un ti Diose. Tsatsubtasbil yo'ntonic yu'un ti Diose naca me yilic, naca me c'otuc ti yo'ntonic, naca me sutes yo'ntonic, naca me colucuc cu'un, ti xchie. Ja' sc'opilalic. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Hech laj yal ti Isaíase yu'un i'ac'bat xa sq'uel ti jelaven sp'ijil ti Cristoe. Hech yu'un ti hech laj xcholbe sc'opilale. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Manchuc mi muc xch'unic ep ti jchi'iltaque, oy totiletic cu'untutic laj xch'unic ti ja' Jcoltavanej ti Jesuse. Mu jamaluc laj yalic ti xch'unojique naca me tenatuc loq'uel ti templo yu'un ti xchi'iltac ti abtele. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ma'uc tsots sc'opilal ti yo'ntonic ti lec chc'ot sc'opilalic yu'un ti Diose. Ja' no'ox tsots sc'opilal ti yo'ntonic ti lec chc'ot sc'opilalic yu'un ti xchi'iltac ti abtele. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ti Jesuse lic sc'opon yan vuelta ti jchi'iltaque. Tsots ic'opoj, hech laj yalbe: ―Scotol ti much'u xch'unoj ti ho'on Jcoltavanejun yu'unique xch'unoj ti laj stacun talel ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Scotol ti much'u sq'uelojbun jsate, laj xa sq'uelbe sat uc ti Jtote ti laj stacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ho'oni luz c'otemun avu'unic ho'oxuc ti li'oyoxuc ti balumile. Scotol ti much'u xch'unoj ti ho'on Jcoltavanejun yu'unique, p'ijubenic xa hech chojtiquinic ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ti much'u chiya'ibun jc'ope, mi mu xixch'umbun ti jc'ope, mu xquich'be sc'op ti ora to. Ho'oni mu yu'unuc tal quich'be sc'op crixchanoetic. Ja' tal jcolta ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ti much'u mu xispasucun ti muq'ue ja' chc'ot yorail ti ch-ich'bat sc'op ti slajebal c'ac'al. Ja' ch-ich'bat sc'op yu'un ti jc'ope. Ja' chich'ic castigo yu'un ti muc xch'unique. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mu jtucuc jc'op ti chcale. Ti Jtote ti laj stacun talele, ja' laj yalbun ti c'usi chcale, ti c'usi chitac'ave. ");
INSERT INTO tzoNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ja' sventa cuxlejal sbatel osil ti smantale. Ti c'u che'el chcale, ja' sc'op ti Jtote hech chaj c'u che'el laj spasun ti mantal ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Jutuc xa sc'an tsta yorail q'uin Pascua. Sna' ti Jesuse ti ic'ot xa yorail ti chloc' batel li' ti balumile, ti tsut batel ti stojol ti Jtotic Diose. Ep laj sc'uxubinuntutic ho'ontutic ti laj xa yu'uninuntutic li'i. Mu p'isbiluc c'ux laj ya'yuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Te jtsoboj jbatutic yu'un chive'tutic xchi'uc ti Jesuse. Ti Judase, ja' ti snich'on Simon Iscariotee, i'albat xa ti yo'nton yu'un ti pucuje ti ja' ta xa xac' entrecal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ti Jesuse sna'oj ti ja' ac'bil sventain spasel scotol yu'un ti Jtotic Diose. Sna' ti c'u che'el itacat tal yu'un ti Jtotic Diose, ja' no'ox hech chcha'ic'at sutel ti stojol. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Manchuc mi loq'uem tal ti stojol ti Diose, ilic ti Jesuse, laj sloq'ues jlom ti sc'u'e, hech lic smac xch'ut ti poc'. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Laj sq'ueb ho' ti poquet, lic spocbun cacantutic ho'ontutic ti yajchanc'opuntutique. Laj scusbun cacantutic ti poc', ja' ti smac xch'ute. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Hech yu'un ti c'alal ic'ot ti stojol ti Simon Pedroe, ti Pedroe hech lic yalbe: ―Cajval, mu sjamuc ti chapocbun cacan ho'oti ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Hech itac'av ti Jesuse: ―Ti hech ti jpase, mu ti orauc chava'ibe sjam. Patil chava'ibe sjam ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ti Pedroe hech laj yalbe: ―Mu xcac' ti chapocbun cacan o ―xut. Hech itac'av ti Jesuse: ―Mi muc xajpoque, mu'yucot ti jtojol ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Itac'av ti Simon Pedroe, hech laj yalbe: ―Cajval, mu me ja'uc no'ox cacan chapocbun. Pocbun jc'ob jol uc ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ti Jesuse hech laj yalbe: ―Ti much'u atinem xae mu sc'an ti chpocbat scotol. Ta yutsil mi chpocbat yacane. Pocbil xa scotol chc'ot obi ―xut―. Ho'oxuque pocbil avo'ntonic xa. Ja' no'ox mu acotoluc pocbil avo'ntonic ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sna'oj ti Jesuse ti ja' ch-ac'van entrecal ti Judase. Ja' sventail ti hech laj yalbuntutic: “Mu acotoluc pocbil avo'ntonic”, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","C'alal laj spocbun cacantutic jcotoltutic, laj xcha'lap sc'u'. Inaqui yan vuelta ti mesa ti Jesuse. Hech laj sjac'buntutic: ―¿Mi xana'ic c'u yu'un ti hech laj jpocboxuc avacanique? ―xiyutuntutic―. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Maestro, Cajval, xavutucun ti jtojol. Lec ti hech chavalbucune yu'un melel ti hechun ti atojolique. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ho'on ti Avajvalucune, ho'on ti Maestroun avu'unique laj jpocbot avacanic. Hechucoxuc me uc, mu me xatoy abaic, ac'o abaic ti abatinel ti stojol ti avermanotaque. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ti hech laj jpasboxuc avilic, yu'un hech me xapasilanic o ti ho'oxuque hech chaj c'u che'el laj jpasboxuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Melel ti c'usi chacalbeique, ti much'u abate mu lecuc mi tscuy ti más tsots yabtel yich'oj hech mu xu' tspas hech chaj c'u che'el tspas ti yajvale. Ti much'u chtacat batel ti mantale mu lecuc mi tscuy ti más tsots yabtel yich'oj hech mu xu' tspas hech chac c'u che'el tspas ti much'u itacat batel yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Laj xa ava'yic xa. Mi hech chapasique, hech nichim no'ox avo'ntonic yu'un chayac'bot bendición ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Mu acotoluc hech ac'opilalic. Xacojtiquinoxuc, ho'oxuc ti t'ujbiloxuc cu'un yu'un chacholbucun ti jc'ope. Oy jun achi'uc ti laj jt'uj ti mu xich' ti bendicione. Yu'un ti hech laj jt'uj uque, yu'un hech tsts'aqui ti sc'op ti Diose hech chaj c'u che'el ts'ibabil: “Ti much'u co'ol chive' xchi'uque, ja' chiscontrainun”, ti xchie. Ja' jc'opilal. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ja' yu'un ti chajcaj'alboxuque, ja' yu'un ac'o xana'ic c'alal hech chc'ot ti pasel ti ho'on Jcoltavanejun hech chaj c'u che'el calojboxuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Melel ti c'usi chacalbeique, ti much'u chaspasot ti muc' ho'oxuc ti chajtacoxuc batele, ho'on chispasun ti muc' uc. Yu'un ti chispasun ti muq'ue, ja' tspas ti muc' uc ti Jtote ti laj stacun talele ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","C'alal laj xa yal hech ti Jesuse, vocol ihu' yu'un laj yalbuntutic: ―Melel ti c'usi chacalbeique, oy jun achi'uquic chiyac'un entrecal ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Hech yu'un ho'ontutic ti yajchanc'opuntutique laj jq'uelbe jba jsatutic. Muc jna'tutic much'u sc'opilal. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ho'oni yu'un ep c'uxun ti yo'nton ti Jesuse hech yu'un te ts'eelun ti sts'el ti Jesuse te ti mesa. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ti Simon Pedroe laj yac' señail sc'ob quil yu'un ac'o jac'be ti Jesuse ti much'u hech sc'opilale. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yu'un te oyun ti sts'el ti Jesuse, hech yu'un hech lic jac'be: ―¿Much'u? Cajval ―xcut. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Hech itac'av ti Jesuse: ―Ja' ti much'u ti jts'ajbe vaj chcac'be ―xiyutun. Hech yu'un laj sts'aj ti vaje, laj yac'be ti Judase, ja' ti snich'on Simon Iscariotee. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","C'alal laj stsac ti vaje ti Judase, hech iventaimbat yo'nton yu'un ti Satanase. Ti Jesuse hech lic yalbe ti Judase: ―Ti c'usi chapase, paso me ti ora ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ti jayvo'untutic ti te nacaluntutic ti mesae, mi junuc mu laj jna'tutic c'u yu'un hech laj yalbe. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yu'un ja' sventainoj ti sbolsail ti jtaq'uintutique ti Judase, hech laj jcuytutic ti i'albat yu'un ti Jesuse: Mano c'usi chtun cu'untic yu'un ti yorail ti q'uine, xchi laj jcuytutic. Oy laj jcuytutic ti i'albat yu'un ti Jesuse ti oy c'usi ac'o yac'be ti me'onetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","C'alal laj xa sve' ti vaje ti Judase, ti ora iloc' batel. Ic' xa osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","C'alal iloc' xa batel ti Judase, hech lic yalbuntutic ti Jesuse: ―Ti ora to ti Diose chiyac'un ti pasel ti muc' ho'on ti co'ol crixchanoucutique. Ja' tspasat ti muc' uc ti Diose ti jventa. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yu'un ti tspasat ti muc' ti Diose ti jventae, ja' no'ox hech chi'ac'at ti pasel ti muc' uc yu'un ti Diose. Ti ora to chi'ac'at ti pasel ti muc' yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Col jnich'nab, j'oc' xa no'ox chajchi'inoxuc. Chasa'ucun. Hech chaj c'u che'el laj calbe ti jchi'iltique, ja' no'ox hech chacalbeic. Ti bu chibate, te mu to xu' chachi'inucun batel. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ach' mantal chacalbeic, c'ux me xava'i abaic. Hech chaj c'u che'el c'uxot ti co'nton, ja' no'ox hechoxuc uc, c'ux me xava'i abaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Hech tsna'ic scotol crixchanoetic ti cajchanc'opoxuc ti ho'oxuque mi c'ux xava'i abaique ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ti Simon Pedroe hech lic sjac'be: ―Cajval, ¿bu chabat? ―xchi. Hech itac'av ti Jesuse: ―Ti bu chibate, mu xu' chachi'inun batel ti ora to. Patil to chatal ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ti Pedroe hech laj sjac'be: ―Cajval ¿c'u yu'un mu xu' chajchi'inot batel ti ora to? Mi hech chc'ot ti pasel chichame, hech obi ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Hech itac'av ti Jesuse: ―Mu xac'an chacham. Melel ti c'usi chacalbee, c'alal yorail ch-oc' quelem laj xa amucun ti avo'nton oxib vuelta ―x'utat yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ti Jesuse hech laj yalbuntutic ho'ontutic ti yajchanc'opuntutique: ―Mu me xchibaj avo'ntonic. Ch'uno ti chascoltaoxuc ti Jtote. Ch'uno ti chajcoltaoxuc uc. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Muc' ti sna ti Jtote. Mi mu hechuque, mu hechuc chacalbeic. Chba jcajchapan ti bu chanaquiic te o. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Patil chicha'tal nixtoc, chtal quic'oxuc batel. Te chachi'inucun o. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ti bu chibate, xana'ic xa ti xu' chac'otic uque ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ti Tomase hech lic yalbe: ―Cajval, mu jna'tutic bu chabat. ¡Bu ba c'an jna'tutic c'u che'el xu' chic'otutic ti chavale! ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ti Jesuse hech laj yalbe: ―Mi chac'an chac'otic ti bu oy ti Jtote, ja' tsc'an chach'unic ti ho'on Jcoltavanejun avu'unique. Yu'un ho'on chcojtiquin ti Jtote, hech yu'un melel ti c'u che'el laj xa calboxuc sc'opilal. Yu'un ti much'u chch'un ti ho'on Jcoltavanejun yu'unique, ho'on ti jventa ti chcuxiic sbatel osile. Ti much'u mu xispasucun ti muq'ue mu xu' chojtiquin ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yu'un muc xavojtiquinucun, hech yu'un mu to chavojtiquin ti Jtote. Ti ora to yac'oj sba chavojtiquin yu'un ti laj calboxuque ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ti Felipee hech lic yalbe: ―Cajval, ac'bun jq'uelbetutic sat ti Jtotic Diose hech ti jtoj co'ntontutic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ti Jesuse hech laj yalbe: ―Ep c'ac'al jchi'inojoxuc. ¿Mi mu to chavojtiquinun? Felipe. Ti much'utic laj xa sq'uelbun ti jsate, laj xa sq'uelbe sat uc ti Jtotic Diose. ¿C'u yu'un hech chavalbun: “Ac'bun jq'uelbetutic sat ti Jtotic Diose”, xavutun? ");
INSERT INTO tzoNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Mi mu ach'unojuc ti jun oyun xchi'uc ti Jtote? Ti c'usi chacalbe ava'yique, mu ho'ucun jc'op ti chcale. Ja' yac'oj sba ch-abtej ti co'nton ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ch'uno ti jun oyun xchi'uc ti Jtote. Mi mu xc'ot ti avo'ntonic ti hech chaj c'u che'el laj cal li'to, ch'unic me ti c'utic abtelal cac'oj jba ti jpase. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","’Melel ti c'usi chacalbeique, mi chach'unic ti chajcoltaoxuque, co'ol chapasic jchop o abteletic hech chaj c'u che'el ti jpas ho'oni. Más ech'em to chlic apasic c'alal mi nisut xa batel ti stojol ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yu'un ti ach'unojbun ti jc'ope, hech yu'un hech chac'ambeic ti Diose. Hech yu'un ho'on chacac'boxuc scotol ti c'utic chac'ambee. Hech jun no'ox yutsil chc'ot sc'opilal ti Jtote yu'un ti hech chajcoltaoxuque, ho'on ti Snich'onune. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yu'un ti ach'unojbun ti jc'ope, hech yu'un hech chac'ambucune. Hech yu'un chacac'boxuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Mi c'uxun ti avo'ntonique, chach'umbucun scotol jmantal. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Ti jc'ambe ti Jtote ac'o yac'boxuc ti Ch'ul Espíritue yu'un chascoltaoxuc. Ja' chaxchi'inoxuc sbatel osil. Oy ti sventa uc ti c'op ti ja' melele. Ti crixchanoetique mu xu' chich'ic ti Ch'ul Espíritue yu'un mu xch'unic ti oye yu'un mu sna'ic c'u che'el ch-abtej. Ho'oxuque c'alal chtal ti Ch'ul Espíritue chavojtiquinic yu'un chaxchi'inoxuc. Ja' tsnain avo'ntonic o. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Muc un j'ech'el chajcomesoxuc. Chtal jcha'chi'inoxuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ti crixchanoetic ti li'oyic ti balumile jun chib xa no'ox c'ac'al chisq'uelbucun jsat. Mi jutuc mu xa xisq'uelbun jsat yan vuelta. Ho'oxuque chavililanucun yu'un chavilic ti cabtele. Yu'un ti chicha'cuxi ho'oni, hech chavich'ic ti ach' cuxlejale. Hech yu'un hech xu' chavilun yu'un chavilic ti cabtele. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","C'alal mi i'och xa ti avo'ntonic ti Ch'ul Espíritue, hech chc'ot ti avo'ntonic ti jun oyun xchi'uc ti Jtote, ti oyoxuc ti jtojole, ti oyun ti avo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ti much'u chch'un ti jmantale ti ya'yoje, ja' c'uxun ti yo'nton obi. Ti much'u c'uxun ti yo'ntone hech c'ux x'a'yat yu'un ti Jtote. C'ux xca'i ti co'nton uc. Hech más yac'oj sba chiyojtiquinun ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Hech ijac'bat yu'un ti Judase, ma'uc ti Judas Iscariotee, ja' ti yan Judase: ―Cajval, ¿c'u yu'un ja' no'ox chavac' aba ti q'uelel ti jtojoltutic ti ho'ontutique? ¿C'u yu'un mu xavac' aba ti q'uelel ti stojol scotol crixchanoetic? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Hech itac'av ti Jesuse: ―Ti much'u c'uxun ti yo'ntone, ja' chixch'umbun jc'op. C'ux x'a'yat yu'un ti Jtote. Chtal jchi'intutic. Teuntutic ti yo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ti much'u mu c'uxucun ti yo'ntone, yu'un mu ono'ox xixch'umbun jc'op. Mu ho'ucun jc'op ti yac'oj sba chacalboxuque. Ja' sc'op ti Jtote, ja' ti laj stacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Hech chacalboxuc yu'un li'to jchi'inojoxuqui. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Laj xa jc'ambe ti Jtote yu'un ac'o stac talel ti Ch'ul Espíritue yu'un chascoltaoxuc. Scotol chaxchanubtasoxuc. Scotol chayac'boxuc ana'ic ti hech chaj c'u che'el calojboxuque. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Chajmuc'ubtasboxuc comel avo'ntonic. Mu hechuc chasmuc'ubtasoxuc avo'ntonic ti crixchanoetic li' ti balumile. Chacac'boxuc smuc'ul avo'ntonic hech chaj c'u che'el smuc'ul co'nton ho'oni. Hech yu'un mu me xchibaj avo'ntonic. Mu me xaxi'ic. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Laj xa calboxuc ti chibate. Laj xa calboxuc ti chtal jcha'chi'inoxuc. Ti c'uxucun ti avo'ntonique, nichim no'ox avo'ntonic ti hechuque yu'un chisut batel ti stojol ti Jtote. Más tsots yabtel yich'oj ti Jtote, mu tsotsuc cabtel quich'oj ho'oni. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Laj caj'alboxuc yu'un yo'to mu to chibat. Yu'un hech mu xchibaj avo'ntonic ti jtojol c'alal chibate. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Mu'yuc xa tiempo yu'un ep chajc'oponoxuc. Yu'un j'oc' xa tsc'an chtal staun ti pucuje, ja' ti sventainojbe yo'ntonic scotol crixchanoetic li' ti balumile. Mu xu' yu'un chistsalun. ");
INSERT INTO tzoNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ja' no'ox ti jpas hech chaj c'u che'el laj spasun ti mantal ti Jtote. Hech tsna'ic ti crixchanoetique ti c'ux ti co'nton ti Jtote. Licanic, batic che'e ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ti Jesuse hech laj yalbuntutic uc ho'ontutic ti yajchanc'opuntutique: ―Ho'oni hech chaj c'u che'el jtec uvate'. Ti Jtote hech chaj c'u che'el jchabiej'uvate'. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Scotol ti much'utic chtal ti jtojole ja' hech chac c'u che'el sc'obc'ob ti jtec uvate'e. Ti much'u chtal ti jtojole ti mu spas ti c'usi lec chil ti Jtote, ja' hech chaj c'u che'el sc'ob ti uvate'e ti mu xac' sate. Ti sc'ob ti uvate'e ti mu xac' sate ja' tsp'asat loq'uel yu'un ti jchabiej'uvate'e. Ja' no'ox hech mu xc'anat yu'un ti Jtote ti much'u mu sc'an spas ti c'usi lec chil ti Jtote. Ja'uc ti much'u chtal ti jtojole ti tspas ti c'usi lec chil ti Jtote, más yac'oj sba chlecubtasat yu'un ti Jtote hech chaj c'u che'el chlecubtasat ti sc'ob ti uvate'e yu'un ti jchabiej'uvate'e. Ti jchabiej'uvate'e tsjec loq'uel ti bu mu xtun chile yu'un sc'an ti ech'em ac'o yac' sat. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ho'oxuque lecubtasbiloxuc xa yu'un laj xa apasic ti muc' ti jc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Teanic ti jtojol. Ac'o teucun ti avo'ntonic. Na'ic me, ti manchuc stsacoj sba xchi'uc smuc'ul ti sc'ob ti te'e, mu xu' satin stuc ti sbiq'uitc'ob ti te'e. Hechoxuc uc, mu xu' avu'unic chapasic ti c'usi leque mi mu teucoxuc ti jtojole. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Ho'oni hech chaj c'u che'el smuc'ul ti uvate'e. Ho'oxuque hech chaj c'u che'el ti sbiq'uitc'ob ti uvate'e. Hech yu'un mi chacomic ti jtojole, te oyun ti avo'ntonique, hech xu' chapasilanic ti c'usi lec chil ti Jtote. Yu'un ti manchuc jchi'inojoxuque mu'yuc c'usi xu' avu'unic ti hechuque. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ti much'u mu sc'an xch'un ti jmantale ti mu sc'an chcom ti jtojole, ja' hech chaj c'u che'el sc'ob ti te'e ti mu xac' sate ti chjecat loq'uele. Ti sc'ob ti te'e ti ijecat loq'uele hech yu'un chtaquij. Patil chlic yich' tsobel, chtenatic ochel ti c'oc'. Te chc'ac'. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Mi chacomic ti jtojole, mi chavac' ti avo'ntonic ti jc'ope, xu' chac'ambeic ti Diose scotol ti c'usi tsc'an ti avo'ntonique. Hech cha'ac'batic. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mi chapasilanic ti c'usi leque, ja' tspasat ti muc' ti Jtote. Hech chavaq'uic ti q'uelel ti ho'oxuc cajchanc'opoxuque. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Hech chaj c'u che'el c'uxun ti yo'nton ti Jtote, ja' no'ox hech c'uxoxuc ti co'nton uc. Teanic ti jtojol, hech c'ux chaca'yic. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mi scotol chach'umbun ti jmantale, hech c'ux chaca'yic hech chaj c'u che'el c'ux chiya'yun ti Jtote yu'un scotol jch'unojbe smantal. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Hech yu'un hech laj xa calboxuc yu'un hech nichim no'ox avo'ntonic scotol c'ac'al hech chaj c'u che'el nichim no'ox co'nton ho'oni. Hech lec nichim no'ox avo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","’Hech oy ti jmantale: C'ux me xava'i abaic hech chaj c'u che'el c'ux chaca'i. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ti much'u chac' sba ti milel yu'un ti much'utic más c'ux cha'i sba xchi'uque, ja' ep chc'uxubinvan obi. Ja' hech ti jpas ho'oni. Ja' tsc'an ti hech avo'ntonic uque. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ho'oxuque más c'ux chaca'yoxuc mi chapasic ti c'utic laj xa calboxuque. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ho'oxuque co'ol nijc'otucutic xa, yu'un laj xa cac'boxuc ana'ic scotol ti c'utic ca'yoj ti stojol ti Jtote. Ti much'u abate muc un ch-albat yu'un ti yajvale ti c'u che'el tsnop scotol. Ja'uc ti ho'one laj xa calboxuc scotol hech yu'un mu xa cabatucoxuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ho'oxuque muc xat'ujucun. Ho'oxuque ho'on laj jt'ujoxuc. Hech chaj c'u che'el i'ac'bat yabtel yu'un ti Diose ti uvate'etique yu'un ac'o yac' sat, ja' no'ox hech chacac'boxuc avabtelic yu'un chavaq'uic ti q'uelel ti yabtel Dios ti avo'ntonic. Ti uvate'e oy yorail chac' sat. Ja'uc ti ho'oxuque, mu'yuc yorail ti chavaq'uilan ti q'uelel ti yabtel Dios ti avo'ntonique. Ja' scotol ora. Yu'un ach'unojbun ti jc'ope hech yu'un scotol ti c'usi chac'ambeic ti Jtote, ja' chayac'boxuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hech chajpasoxuc ti mantal: C'ux me xava'i abaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Mi chayilintaoxuc ti crixchanoetique, mu me xchibaj avo'ntonic. Na'ic me ti ho'on jbael laj yilintaun. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ti jtosuc to avo'ntonic xchi'uc ti crixchanoetique c'ux chaya'yoxuc ti hechuque. Ho'oxuque mu xa co'oluc avo'ntonic xchi'uc yu'un laj xa quic'oxuc ti jtojol. Hech yu'un chayilintaoxuc ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Na'ic me ti mu tsotsuc yabtel yich'oj ti abat no'oxe. Ja' tsots yabtel yich'oj ti yajval ti abate, xacutoxuc. Laj yilbajinun ho'oni, hech yu'un ja' no'ox hech chayilbajinoxuc ho'oxuque. Muc xixch'umbun ti jc'ope, hech yu'un ja' no'ox hech mu xaspasboxuc ti muc' ac'opic uc. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ho'on ti jventa ti scotol hech chaspasboxuc yu'un mu xojtiquinic ti Jtote, ja' ti laj stacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Ti manchuc ti nitale ti tal jc'opone, muc xvinaj ti oy smulique ti hechuque. Ja'uque yu'un ti nitale hech yu'un mu xu' chalic ti mu'yuc ti smulique. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yu'un ti much'u chiyilintaune, ja' chilinta uc ti Jtote. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ti manchuc laj cac'be sq'uelic ti jchop o abteletique ti mu'yuc much'u yan xu' tspas heche, muc xvinaj ti oy smulique. Ja'uque yu'un ti laj xa sq'uelbun cabteltutic xchi'uc ti Jtote, mu xu' chalic ti mu'yuc ti smulique. Yu'un ja' no'ox más laj yilintauntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Hech its'aqui ti hech chaj c'u che'el ts'ibabil comel ti sun ti Diose ti yich'ojique: “Hovil ti chiyilintaucune, mu'yuc jmul”, ti xchie. Ja' jc'opilal. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’C'alal mi ihul xa ti Ch'ul Espíritue ti ja' ti jtac yal tal yu'un chascoltaoxuque, ja' melel ti c'u che'el chayalboxuque yu'un te chloc' tal ti stojol ti Jtote. Ja' chixcholbun jc'opilal. ");
INSERT INTO tzoNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ho'oxuque chacholbucun jc'opilal uc yu'un c'alal lic abtejucun laj achi'inucun asta ti ora to. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Laj xa calboxuc ava'yic ti chayilintaoxuc ti crixchanoetique yu'un hech mu xchibaj avo'ntonic ti c'alal mu xa li'ucune. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chastenoxuc loq'uel ti temploetic ti jchi'iltique, ho'ucutic ti co'ol judioucutic xchi'uque. Tsta yorail ti chasmilic yu'un ja' yabtel Dios tspasbeic tscuyic. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hech chaspasboxuc yu'un mu xojtiquinic ti Jtotic Diose. Mu xiyojtiquinun uc. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Hech laj xa calboxuc yu'un ti c'alal chlic yilbajinoxuque chana'ic ti hech laj calboxuc comele. Muc xacalboxuc hech ti c'alal laj quic'oxuc ti jtojole yu'un ta to xajchi'inoxuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","’Ta xa xisut batel ti stojol ti Jtote ja' ti laj stacun talele. Ho'oxuque, mi junuc muc xajac'bun ti c'u yu'un ti chisut batele. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ja' no'ox batem ti avo'ntonic chavich'ic mul yu'un ti hech laj xa calboxuque. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Melel ti c'usi chacalbeique, yu'un ja' avutsilalic ti chisut batel ti vinajele. Yu'un mi mu xisut batele, mu xtal ti Ch'ul Espíritue ti chascoltaoxuque. Pero mi nibate, ja' ti jtac talel ti atojolic. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","C'alal chtal, chac'be sna'ic scotol crixchanoetic ti oy smulique. Chac'be sna'ic ti ho'one ti mu'yuc jmule. Chac'be sna'ic ti toj chchapan scotol ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Chac'be sna'ic ti oy smulique yu'un ja' smul ti mu xch'unic ti ho'on Jcoltavanejun yu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Chac'be sna'ic ti yu'un toj co'nton ti ho'one, hech yu'un ti ni'ic'at xa muel ti stojol ti Jtote, hech mu xa xisq'uelbun jsat li' ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Chac'be sna'ic ti melel ti toj chchapan scotol ti Diose yu'un chapambil xa ti chich' castigo sbatel osil ti totil yu'unique, ja' ti pucuje, ja' ti mozoimbilic yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Oy to ep jc'an chacalboxuc. Ja' yan to vuelta cha'ac'bat ava'yic yu'un mu xlaj c'otuc ti avo'ntonic scotol ti ora to. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero c'alal chtal ti Ch'ul Espíritue ti oy ti sventa uc ti c'op ti ja' melele, ja' chayalboxuc ti c'utic melele. Ma'uc sc'op stuc chchol. Ja' chchol scotol ti c'usi ch-albat yu'un ti Jtote. Chayac'boxuc ana'ic scotol ti c'utic chc'ot ti pasele. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Chiyac'bun ti pasel ti muc'. Ja' sventainoj xcholel jc'opilal. Hech chayac'boxuc ana'ic jc'opilal. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Scotol ti c'usi oy yu'un ti Jtote, ja' co'ol cu'un xchi'uc. Ja' sventail ti laj calboxuc ava'yic ti sventainoj xcholel jc'opilal ti Ch'ul Espíritue. Hech chayac'boxuc ana'ic jc'opilal, xichi. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’J'oc' xa no'ox chaq'uelbun jsat. Jun chib c'ac'al mu xaq'uelbun jsat. Patil chaq'uelbun jsat yan vuelta. Patil chisut batel ti stojol ti Jtote ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Oy cha'vo' oxvo'untutic ho'ontutic ti yajchanc'opuntutique hech laj jac'be jbatutic: ―¿C'usi sjam ti chijyalbucutique: J'oc' xa no'ox chaq'uelbun jsat. Jun chib c'ac'al mu xaq'uelbun jsat. Patil chaq'uelbun jsat yan vuelta. Patil chisut batel ti stojol ti Jtote, ti xijyutucutique? ―xcut jbatutic―. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿C'usi sjam ti “j'oc' xa no'ox”, ti xchie? Mu xca'ibetic sjam ti c'usi chale ―xcut jbatutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Sna'oj stuc ti Jesuse ti hech ti jc'an ti jac'betutique ti c'usi sjame. Hech yu'un hech laj yalbuntutic: ―Jna' ti chajac'be abaic c'u yu'un laj cal: “J'oc' xa no'ox chaq'uelbun jsat. Jun chib c'ac'al mu xaq'uelbun jsat. Patil chaq'uelbun jsat yan vuelta”, ti xacutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Melel ti c'usi chacalbeique, ho'oxuque cha'oq'uic, chavich'ic mul. Ja'uc ti crixchanoetique nichim no'ox yo'ntonic. Ho'oxuque j'oc' no'ox chavich'ic mul, patil nichim no'ox avo'ntonic o. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Chana'ic hech chaj c'u che'el ti ants ti chcol ti alajele. Oy svocol yu'un ista xa yorail. Mi icol xa ti alajel, ich'ay ti yo'nton ti c'ux laj ya'i. Nichim no'ox yo'nton patil yu'un oy xa yol. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ja' no'ox hech ti ho'oxuque chavich'ic mul ti ora to. Li' ti chib oxib c'ac'ali chaq'uelbun jsat yan vuelta, hech nichim no'ox avo'ntonic o. Mu'yuc xa much'u xu' chayac'boxuc ich'mul yan vuelta. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’C'alal chaq'uelbun jsat hech chaj c'u che'el laj xa calboxuque, mu'yuc xa c'usi chajac'bun yu'un ic'ot xa ti pasel ti c'u che'el laj calboxuque. Melel ti c'usi chacalbeique, yu'un ti ach'unojbun ti jc'ope, hech yu'un jun avo'ntonic c'ambeic ti Jtotic Diose ti c'usi chac'anique, hech chayac'boxuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mu to oyuc c'usi chac'ambeic ti Jtotic Diose yu'un ti ach'unojbun xa ti jc'ope. C'ambo, hech cha'ac'batic. Hech nichim no'ox avo'ntonic mu'yuc palta chava'yic. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Mu jamaluc laj jc'oponoxuc. Tsta yorail ti jamal chajc'oponoxuc, ti jamal chacalboxuc ava'yic sc'opilal ti Jtotic Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","C'alal mi laj xa sta yorail ti jamal laj xa ava'yic sc'opilal ti Jtotic Diose, hech yu'un atuquic chac'ambeic c'usi chac'ambeic ti Jtotic Diose yu'un ti ach'unojbun ti jc'ope. Mu persauc ho'on chajc'amboxuc ti stojol ti Jtotic Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Yu'un c'uxoxuc xa ti yo'nton ti Jtotic Diose. C'ux chaya'yoxuc yu'un c'uxun ti avo'ntonic. Yu'un ach'unojic ti niloc' tal ti stojol ti Jtotic Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Melel ti niloc' tal ti stojol ti Jtotic Diose. Nihul li' ti balumile. Hech yu'un tana to ti jcomes ti balumile, yu'un chisut batel ti stojol ti Jtotic Diose ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ho'ontutic ti yajchanc'opuntutique hech laj calbetutic: ―Muc unuc mu jamaluc laj avalbuntutic. Jamal laj xa avalbun ca'itutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Laj xa jna'tutic ti chana' scotol. Yu'un laj ana' ti oy c'usi ti jc'an ti jac'tutic c'alal mu to chajac'botutic. Hech yu'un jch'unojtutic xa ti naloc' tal ti stojol ti Diose ―xcututic. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Hech itac'av ti Jesuse: ―Laj xa ach'unic, pero sc'an to. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yu'un li' xa ti j'oq'ui chacomesucun. Ja' chapuc abaic batel. Pero mu comesbilucun yu'un xchi'inojun ti Jtotic Diose. ");
INSERT INTO tzoNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ti c'u yepal laj xa calboxuque yu'un hech nichim no'ox avo'ntonic ti jventa manchuc mi chavich'ilanic vocol li' ti balumile. Yu'un tsalbil xa cu'un scotol ti c'utic oy li' ti balumile, hech yu'un ja' no'ox hech tstsal avu'unic ti jventa ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","C'alal laj yal hech ti Jesuse, laj sq'uel muel vinajel. Hech laj sc'opon Dios: ―Tote, ista xa yorail ti chc'ot ti pasel cu'un hech chaj c'u che'el achapanoj. Hech yu'un ac'un ti pasel ti muc' yu'un hech chacac'ot ti pasel ti muc' uc, ho'on ti Anich'onune. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yu'un laj xa avac'bun jventain scotol crixchanoetic ti jaylajuntos li' ti balumile, ti c'u yepal ti i'och xa ti jventa avu'une, ja' chcac'be xcuxlejalic sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ja' chcuxiic sbatel osil yu'un xayojtiquinot ti ho'ot no'ox Diosot atuc ti mu'yuc yan, yu'un xiyojtiquinun uc ti ho'on Jcoltavanejun yu'unique ti ho'ot laj atacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Laj xa cac'ot ti pasel ti muc' ti stojol scotol crixchanoetic. Ihu' xa cu'un ti cabtele ti laj avac'bun jpase. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ti ora to, tote, ac'un xa ti pasel ti muc' te ti atojol co'ol hech chaj c'u che'el oyun ono'ox ti pasel ti muc' te ti atojol c'alal mu to pasemuc ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Laj xa cac'be yojtiquinot ti viniquetic li'to ti oyic ti jventa avu'une. Jbael laj at'uj ho'oti, patil laj avac'bun jventain. Hech yu'un laj xa yac' ti yo'ntonic ti ac'ope. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Laj xa sna'ic ti ho'ot ti aventa ti ihu' xa cu'un scotol ti c'usi laj jpase, scotol ti c'usi laj cale. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Laj xa calbe ya'yic scotol ti ac'ope ti laj avalbune. Laj xa sna'ic ti melel ti niloc' tal ti atojole. Xch'unojic xa ti ho'ot laj atacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Chajc'oponot yu'unic. Ma'uc chajc'oponot yu'un scotol crixchanoetic. Ja' chajc'oponot yu'unic scotol ti much'utic ti oyic ti jventa avu'une ti ja' t'ujbilic avu'une yu'un ac'o coluc sbatel osil. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Scotol ti much'utic oyic ti jventae, oyic ti aventa uc. Scotol ti much'utic oyic ti aventae, oyic ti jventa uc. Chiyac'ucun ti pasel ti muc'. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Ja' stuquic chcomic li' ti balumile yu'un ta xa xisut tal ti atojol. Tote, mu'yuc mulil ti atojol. Hech yu'un xu' avu'un chachabibun scotol ti much'utic ti oyic ti jventa avu'une, yu'un hech mu stsalat yu'un ti mulil li' ti balumile. Yu'un ti chachabie, hech yu'un jtos yo'ntonic hech chaj c'u che'el jtos co'ntontic. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","C'alal ti li'to jchi'inoj jba xchi'uc ti jayvo' avac'ojbun ti jventae, laj cac'be xchan hech chaj c'u che'el chac'an. Laj jchabi. Mi junuc muc xch'ay cu'un, ta to xists'acliucun scotolic. Ja' no'ox stuc ti much'u sc'opilal ch'ayel chbate, ja' mu xa xists'acliun. Hech chc'ot ti pasel ti ac'ope hech chaj c'u che'el ts'ibabil comel ti ahun. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Ta xa xital ti atojol, tote. C'alal li'to jchi'uc hech chajc'oponot ti stojolic yu'un hech lec nichim no'ox yo'ntonic hech chaj c'u che'el nichim no'ox co'nton. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Laj xa calbe ya'yic ti ac'ope. Ch-ilintaatic yu'un ti crixchanoetique. Yu'un mu xa co'oluc yo'ntonic hech chaj c'u che'el ti crixchanoetique hech chaj c'u che'el mu co'oluc co'nton xchi'uc ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ma'uc chajc'ambot yu'un ti chavic'bun loq'uel li' ti balumile. Ja' chajc'ambot ti chachabibune yu'un hech mu stsalat yu'un ti pucuje. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yu'un mu xa co'oluc yo'ntonic hech chaj c'u che'el ti crixchanoetique hech chaj c'u che'el mu co'oluc co'nton xchi'uc ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Lecubtasbun yo'ntonic yu'un ti ac'ope yu'un melel ti ac'ope. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hech chaj c'u che'el laj atacun talel li' ti balumile yu'un tal calbe ti ac'ope, ja' no'ox hech ti jtac batel uc yu'un chba yalbe ti ac'ope ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yutsil co'nton ti jpas ti c'usi tsc'an ti avo'ntone yu'un hech xu' yu'unic tspasic ti jventa uc. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ma'uc no'ox chajc'oponot yu'unic. Ja' chajc'oponot uc yu'un scotol ti much'utic chixch'umbucun jc'op ti sventaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Chajc'ambot ti ac'o me jtosuc yo'ntonic scotolic hech chaj c'u che'el jtos co'ntontic. Hech chaj c'u che'el te oyot ti co'nton, te oyun ti avo'nton, ja' no'ox hech ac'o te oyuc ti co'ntontic scotolic. Hech chch'unic scotol crixchanoetic ti ho'ot laj atacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Laj xa cac'be yutsil yo'ntonic hech chaj c'u che'el ti yutsil co'nton laj avac'bune yu'un hech jtos yo'ntonic hech chaj c'u che'el jtos co'ntontic. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ho'on te oyun ti yo'ntonic. Ho'ot te oyot ti co'nton. Hech jtos yo'ntonic chc'otic ti mero melel hech tsna'ic scotol crixchanoetic ti ho'ot laj atacun talele. Hech tsna'ic uc ti c'ux ti avo'nton ti much'utic chaxch'umbot ac'ope hech chaj c'u che'el c'uxun ti avo'nton uc. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tote, ti jc'an ti ac'o xixchi'inucun sbatel osil ti bu oyune ti c'u yepal avac'ojbun ti jventae yu'un hech chisq'uelun ti c'u che'el pasbilun ti muc' avu'un. Melel ti c'uxun ti avo'ntone c'alal mu to pasemuc ti balumile. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Toj avo'nton, tote. Ti crixchanoetique mu xayojtiquinot. Ho'oni xacojtiquin. Ti jayvo' li'to xayojtiquinot uc yu'un xch'unojic xa ti ho'ot laj atacun talele. ");
INSERT INTO tzoNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Laj xa cac'be yojtiquinot. Más ta to xcac'be yojtiquinot yu'un hech chaj c'u che'el lum ep c'uxun ti avo'ntone, ja' no'ox hech ac'o sc'uxubin sbaic uc. Yu'un mi c'ux cha'i sbaic, te oyun ti yo'ntonic ―xchi laj sc'opon Dios ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","C'alal laj yo'nton laj sc'opon Dios ti Jesuse, niloc'tutic batel xchi'uc ti Jesuse xchi'uc ti ho'ontutic ti yajchanc'opuntutique. Nijelavtutic batel ti jech uc'um. Cedrón sbi ti uc'ume. Nic'otutic ti bu ts'umbil olivate'etic. Ja' stac' lo'el. Te ni'ochtutic ti yolon ti olivate'etic xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ti Judase, ja' ti chac' entrecal ti Jesuse, yiloj ti bu oy ti ts'umbil olivate'etique yu'un te nic'otilantutic xchi'uc ti Jesuse jcotoltutic ti yajchanc'opuntutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hech yu'un ti Judase laj yic' tal soldadoetic xchi'uc ti yajmayoletic yu'un ti totil paleetique, xchi'uc fariseoetic. Italic yich'ojic tal stojic xchi'uc sc'oq'uic xchi'uc yespadaic. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Scotol sna'oj ti Jesuse c'usi chc'ot ti pasel ti stojol. Hech yu'un inopej batel. Hech laj sjac'be: ―¿Much'u chasa'ic? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Hech itac'avic: ―Ja' ti jsa'tutic ti Jesuse ti liquem tal ti Nazarete ―xchiic. Ti Jesuse hech laj yalbe: ―Ho'on ―xchi. Te va'al uc ti Judase, ja' ti chac' entrecal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","C'alal laj yal hech ti Jesuse, ho'on ti xchie, hech nacnacchac iloq'uic ti jtsacvanejetique. Hech ip'ajic ti lum. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yan vuelta hech ijac'batic yu'un ti Jesuse: ―¿Much'u chasa'ic? ―xchi. Hech itac'avic: ―Ja' ti jsa'tutic ti Jesuse ti liquem tal ti Nazarete ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ti Jesuse hech laj yalbe: ―Laj xa calboxuc ava'yic: Ho'on, xichi chava'i. Yu'un jtuc no'ox ti chasa'ucune, hech yu'un ac'o batuc avi viniquetic li'to ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ti hech laj yale, yu'un hech chc'ot ti pasel ti hech chaj c'u che'el laj yal ono'oxe: “Ti jayvo' ti avac'ojbun ti jventae, mi junuc muc xch'ay cu'un”, ti xchi ono'oxe. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yich'oj yespada ti Simon Pedroe. Hech yu'un laj sloq'ues, laj syajesbe yabat ti totil palee. Laj sbojbe loq'uel xchiquin ti sbats'ic'ob. Malco sbi ti abate. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ti Jesuse hech laj yalbe ti Pedroe: ―Tic'o ochel ti sna ti avespadae. Mi hech chapase, mu xquich' vocol hech chaj c'u che'el tsc'an ti Jtote ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Hech yu'un ti capitane xchi'uc ti yajsoldadoe xchi'uc ti yajmayoletic ti paleetique laj stsaquic ti Jesuse. Laj xchuquic batel. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jbael laj yiq'uic batel sva'anic ti stojol ti totil pale, Anas sbi. Ti Anase ja' sni' ti Caifase. Ja' ti biq'uit ni'ile ochem ti totil pale ti sventa habil ti c'alal icham ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mu yanuc ti Caifase. Ja' ono'ox ti laj yal ja' lec mi chcham cu'untic jun no'ox vinic. Ja' mu xtun mi chijcham jcotoltic, ti xchi ono'oxe, ti xut ti xchi'iltac ti abtele. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ho'on xchi'uc ti Simon Pedroe laj jts'aclitutic batel ti Jesuse. Ho'oni xiyojtiquinun ti totil palee. Hech yu'un laj jchi'in ochel ti Jesuse te ti yamaq'uil sna ti totil palee. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ti Pedroe va'al icom ti fuera nopol ti'na. Yu'un ojtiquimbilun te ti sna ti totil palee, hech yu'un ba jc'opon ti jchabiejti'nae yu'un ac'o ochuc ti Pedroe. Hech yu'un laj yotes ti Pedroe. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tseb ti jchabiejti'nae. Ja' laj sjac'be ti Pedroe: ―¿Mi ma'uc yajchanc'opot uc ti vinique? ―xchi. ―Mu ho'ucun ―xchi xtac'av ti Pedroe. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Te va'ajtic ti abatetic yu'une xchi'uc ti mayoletic yu'une. Spasojic sc'oc' yu'un oy sic. Ac'al ti sc'oq'uique. Te chc'atinic ti c'oc'. Te va'al uc ti Pedroe. Te chc'atin ti c'oc' uc. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ti Jesuse hech ijac'bat yu'un ti totil palee: ―¿Jayvo' avajchanc'op? ―x'utat―. ¿C'usi c'opal ti chavac' ti a'yele? ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Hech itac'av ti Jesuse: ―Jamal laj jc'opon scotol crixchanoetic. Scotol c'ac'al nichanubtasvan ti biq'uit temploetic xchi'uc ti muc'ta templo yo' bu tstsobilan sbaic scotol ti jchi'iltique. Mu muculuc nichanubtasvan. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿C'u yu'un ho'on chajac'bun? Jac'bo ava'i much'utic ya'yojic c'usi laj jcholbe. Sna'ic c'usi laj calbe ya'yic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","C'alal laj yal hech ti Jesuse, imajvan ti jun abat ti te va'ale. ―¿C'u yu'un hech chatac'be sc'op ti totil palee? ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Hech itac'av ti Jesuse: ―Mi chopol ti jc'ope, alo ca'itic ti bu chopole. Mi lec ti jc'ope, ¿c'u yu'un chamajun? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ti Anase, ja' ti más totil palee, chucul xa laj stac batel ti Jesuse ti stojol ti totil palee ti ja'to no'ox i'och ti habil avi lume, ja' ti Caifase. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ti Pedroe te va'al chc'atin ti c'oc'. Hech ijac'bat yu'un ti much'utic te co'ol chc'atinic xchi'uque: ―¿Mi ma'uc yajchanc'opot uc? ―x'utat. Ti Pedroe laj smuc ti yo'nton: ―Mu ho'ucun ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Te oy jun yabat ti totil palee. Ja' yermano ti ip'asbat loq'uel xchiquin yu'un ti Pedroe. Hech laj sjac'be: ―¿Mi mu ho'ucot ti achi'inoj ti vinique yo' bu ts'umbil ti olivate'etique? ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ti Pedroe yan vuelta laj smuc ti yo'nton. Ja' yorail ch-oc' quelem. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Iloc' ti stojol ti Caifase ti Jesuse. I'ic'at batel ti stojol ti gobernadore yu'un chchapambat sc'opilal te ti sna. Ja' Pretorio sbi. Ja' te chchapambat sc'opilal crixchanoetic scotol c'ac'al. Sob to mu to tsacub ti osile. Ti paleetique xchi'uc ti xchi'iltaque muc x'ochic ti Pretorio. Mu stac' tscap sbaic xchi'uc yanlum crixchano yu'un q'uin xa yu'unic. Yu'un mu to tsti'ic ti ch'iom carnero yu'un ti q'uin Pascuae. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hech yu'un iloc' tal ti Pilatoe, ja' ti gobernadore. Hech laj sjac'be: ―¿C'usi smul avi vinic li'to? ―xchi. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hech itac'avic: ―Ti manchuc oy smule, mu xcac'tutic entrecal ti ac'ob ti hechuque ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ti Pilatoe hech laj yalbe: ―Iq'uic batel ho'oxuque. Ich'bo sc'op yu'un smul ti sventa ti mantaletic avu'unique ―xut. Hech i'albat yu'un ti paleetique: ―Mu xu' chcac'tutic ti milel ho'ontutic. Ja' avabtel ho'oti ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ti hech i'och ti sc'ob ti Pilato ti Jesuse, yu'un hech chc'ot sc'op ti Jesuse ti cruz chmilat. Yu'un ti romaetic ti cruz chmilvanic. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Hech yu'un ti Pilatoe icha'och nixtoc ti bu chchapanvane. Laj yic' tal ti stojol ti Jesuse. Hech laj sjac'be: ―Ti jc'an chca'i mi ho'ot ajvalilot yu'un ti achi'iltaque, ho'oxuc ti judioxuque ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Hech itac'av ti Jesuse: ―¿Mi yu'un atuc hech laj anop, mi yu'un oy much'u laj yalbot yu'un ti hech chajac'bune? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Hech itac'av ti Pilatoe: ―Ho'oni mu jventauc, mu judioucun. Ti achi'iltaque xchi'uc ti totil paleetique ja' laj yac'ot entrecal ti jc'ob. ¿C'usi apasoj? ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Hech itac'av ti Jesuse: ―Ti much'u laj yac'bun cabtel yu'un ti jpas mantal, mu crixchanoticuc. Ti crixchanoticuque, laj xa scoltaucun ti cabate ti hechuque. Hech muc xi'och ti sc'ob ti jchi'iltaque. Hech muc xital ti atojol uc. Ja'uque, mu crixchanouc laj yac'bun cabtel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ti Pilatoe hech laj yalbe: ―Hech yu'un ajvalilot che'e ―xchi. Hech itac'av ti Jesuse: ―Ajvalilun. Ja' sventail ti tal anucun li' ti balumile yu'un ti jchol ti c'op ti ja' melele. Scotol ti much'utic sc'an cha'yic ti c'usi melele, ja' chiya'ibun jc'op ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ti Pilatoe hech laj sjac'be: ―¿C'u che'el ti jna' ti bu melele? ―xchi. C'alal laj xa yal hech ti Pilatoe, iloc' yan vuelta. Ba sc'opon yan vuelta ti paleetique. Hech laj yalbe ya'yic: ―Mu jtabe smul ―xchi―. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yu'un nopen chava'yic ti chajcoltabe loq'uel jun jchuquel ti yorail q'uin Pascua, hech yu'un ¿mi ja' chac'anic ti chajcoltabe batel ti much'u ajvalil avu'unique, ho'oxuc ti judiooxuque? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tsots itac'avic scotolic: ―¡Ma'uc avi to! ¡Coltao ti Barrabase! ―xchiic. Ti Barrabase, ja' j'elec'. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hech yu'un ti Pilatoe laj yal mantal ti ac'o yich' acial ti Jesuse. Hech yu'un ti soldadoetique lic yac'beic acial ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Patil laj spech'ic ch'ix. Laj yac'beic ti sjol. Laj slapbeic nat sc'u'. Yoxyoxtic x'elan ti c'u'ile hech chaj c'u che'el tslapic totil ajvaliletic. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Hech laj slabanic ti Jesuse: ¡Viva! ¡Ho'ot ajvalilot mati yu'un ti judioetique! ―xchiic. Laj yaq'uilambeic majel ti sat. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Yan vuelta iloc' talel ti Pilatoe. Hech laj yalbe ti jchi'iltaque: ―Q'uelo avil chquic' loq'uel tal ti jva'an ti atojolic yu'un chana'ic ti mu jtabe smul ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","C'alal iloc' tal ti Jesuse, oy xa pech'bil ch'ix ti sjol. Slapoj xa loq'uel tal c'u'il. Yoxyoxtic ti c'u'ile. Ti Pilatoe hech laj yalbe ti jchi'iltaque: ―¡Q'uelo avilic c'u x'elan ti vinique! ―xchi. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","C'alal laj yilic ti Jesuse ti totil paleetique xchi'uc ti mayoletique tsots lic yavtaic ti Pilatoe: ―¡Milo ti cruz, milo ti cruz! ―xchiic. Hech itac'av ti Pilatoe: ―Iq'uic batel, milic ti cruz ho'oxuque. Ho'oni mu jtabe smul ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Hech itac'avic ti jchi'iltaque: ―Ho'ontutique oy mantal cu'untutic. Chal ti mantal cu'untutique ti persa chcham ti much'u Snich'on Dios scuyoj sbae ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ti Pilatoe chi' ono'ox yu'un ti c'usi chc'ot ti pasel yu'un ti Jesuse. Hech yu'un más ixi' yu'un laj ya'i ti Snich'on Dios scuyoj sba ti xchiique. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Hech icha'sutic ochel ti Pretorio ti Pilatoe xchi'uc ti Jesuse. Hech lic sjac'be ti Jesuse: ―¿Bu liquemot tal? ―xut. Muc xtac'av ti Jesuse yu'un sna' ti hovil ti tsjaq'uilane. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Hech yu'un ti Pilatoe hech laj yalbe ti Jesuse: ―¿C'u yu'un mu xatac'bun jc'op? ¿Mi yu'un mu xana' ti oy cabtel ho'oni? Xu' chacac' ti milel ti cruz. Xu' chajcolta batel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Hech itac'av ti Jesuse: ―Ti manchuc yac'ojbot avabtel ti Diose ti te oy ti vinajele, mu'yuc avabtel ti jtojol. Hech yu'un ja' más tsots smulic ti totiletic ti laj yac'ucun ti ac'obe ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Hech yu'un ti Pilatoe sc'an tscolta batel ti Jesuse. Hech yu'un ti jchi'iltaque tsots laj yavtaic: ―Mi chacolta batel avi vinic li'to, yu'un mu yabatucot César mi hech chapase. Scotol ti much'u ajvalil tscuy sbae, ja' tscontrain ti Cesare ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hech yu'un ti Pilatoe c'alal laj ya'ibe sc'op ti jchi'iltaque, hech yu'un laj yal mantal ti ac'o ic'atuc loq'uel tal ti amac' ti Jesuse. Oy pasbil snacleb ti gobernadore te ti o'lol amac', pasbil ti ton. Te chal ti c'u che'el chchapanat ti much'utic chich' chapanel yu'une. Ja' Gabata sbi ti hebreo c'op ti bu chnaquie. Hech yu'un te ba nacluc ti Pilatoe. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","C'alal te ba nacluc ti Pilatoe, ista xa van o'lol c'ac'al. Ja' mero sc'ac'alil ti q'uin Pascuae. C'alal inaqui xa ti Pilatoe hech lic yalbe ti jchi'iltaque: ―¡Q'uelo avil ti ajvalil avu'unique! ―xchi. Ja' sc'opilal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ti jchi'iltaque hech laj yavtaic ti Pilatoe: ―¡Ac'o milatuc, ac'o milatuc, ac'o ba milatuc ti cruz! ―xchiic. Ti Pilatoe hech laj sjac'beic: ―¿Mi lec mi chcac' ti milel ti cruz ti ajvalil avu'unique? ―xut. Hech itac'av ti totil paleetique: ―Ma'uc ajvalil cu'untutic lume. Ja' ajvalil cu'untutic stuc ti Cesare ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hech yu'un ti Pilatoe laj xch'un hech chaj c'u che'el laj sc'an ti jchi'iltaque. Laj yal mantal ti ac'o milatuc ti cruz ti Jesuse. Hech yu'un ti soldadoetique laj yiq'uic batel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Hech yu'un ti soldadoetique laj yac'be sq'uech scruz ti Jesuse. Hech ibatic ti bu Baquel Jolal sbi. Gólgota sbi ti hebreo c'op. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hech lic sjipanic ti cruz ti Jesuse xchi'uc yan cha'vo'. Jun ti jujujech xocon scruz ti Jesuse. Te cacal ti o'lol scruz ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ti Pilatoe laj yac' ti ts'ibael te'. Laj yac'be yu'un ac'o spaq'uic ti jol cruz. “JA' JESÚS LI'TO JA' TI LIQUEM TAL TI NAZARETE. JA' TI TOTIL AJVALIL YU'UN TI JUDIOETIQUE”, xchi sbi ts'ibabil. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ep ti jchi'iltaque laj sq'uelic ti c'u che'el ts'ibabile yu'un te no'ox ti ti' jteclum Jerusalén ti bu ijipanat ti cruz ti Jesuse. Ts'ibabil sbi ti hebreo c'op xchi'uc ti griego c'op xchi'uc ti latin c'op. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ti totil paleetic cu'untutique ho'ontutic ti co'ol judiountutic xchi'uque, c'alal laj yilic ti c'u che'el ts'ibabile, hech ba yalbeic ti Pilatoe: ―“Ja' ti totil ajvalil yu'un ti judioetique”, xchi. ¿C'u yu'un hech laj avac' ti ts'ibael? “Ho'on totil ajvalilun yu'un ti judioetique”, xchi laj avac' ti ts'ibael ti hechuque ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Hech itac'av ti Pilatoe: ―Ti c'u che'el laj xa cac' ti ts'ibael, ja' no'ox hech ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","C'alal ijipanat ti cruz ti Jesuse yu'un ti soldadoetique, laj xch'acbe sbaic ti sc'u' spoc' ti Jesuse. Jujulic laj yich'ic ti chanvo'ique. Jlic laj spas sobril, ja' ti sc'u'e, ja' ti túnica sbie, ti mu'yuc sts'isbenale. Jlic no'ox jalbil ti poq'ue. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Hech yu'un hech laj yalbe sbaic ti soldadoetique: ―Mu jatic avi to. Jpastic al ti jq'ueltic much'u chc'ot ti sventa ti sc'u'e ―xchiic. Hech ono'ox ic'ot ti pasel ti sc'op ti Diose hech chaj c'u che'el ts'ibabil comel ti sun. Hech chal: “Chch'acbe sbaic jc'u' jpoc'. Tspasic al tsq'uelic ti much'u chc'ot ti sventa ti jc'u'e”, ti xchi ono'ox sc'opilale. Hech ono'ox laj spasic ti soldadoetique. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Te ti nopol yolon scruz te va'al ti sme' ti Jesuse xchi'uc ti smuc ti sme'e, ja' María sbi uc. Ja' Cleofas sbi ti smalale. Te xchi'uc uc ti Maríae ja' ti liquem tal ti Magdalae. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ho'on ti yajchanc'opun ti Jesuse ti lum c'uxun ti yo'ntone, ja' no'ox hechun uc, te jchi'inoj ti sme' ti Jesuse. Hech yu'un c'alal laj yiluntutic ti Jesuse, hech laj yalbe ti sme'e: ―Me'e, ja' avol chc'ot lume ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Hech lic yalbun ti Jesuse: ―Ja' ame' chc'ot ti jme'e ―xiyutun. Hech yu'un laj quic' batel ti jna ti sme' ti Jesuse. Te ba jchi'in o. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ti Jesuse laj sna' ti scotol ic'ot xa ti pasel hech chaj c'u che'el ts'ibabil ti sc'op ti Diose. Ja' slajeb ti hech iyal: ―Taquin co'nton chca'i ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Te vaxal jun taza vinagre. Poj ti vinagree. Hech yu'un lic sts'ajic ti vinagre esponja. Ti esponjae ja' chuch'. Laj sliquic muel ti hisopote'. Laj stic'be ti ye ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ti Jesuse laj sts'uts'un ti vinagree. Hech laj yal: ―Ihu' xa cu'un ―xchi. Laj snijan sba. Hech iloc' ti xch'ulele. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yu'un ja' ti jcux co'ntontutic ti yoc'omale ho'ontutic ti judiountutique, hech yu'un ti totiletic cu'untutique mu sc'anic ti chcom stacopalic ti cruz. Yu'un hech ono'ox tsots sc'opilal chc'otilan cu'untutic jujun sabado yu'un ja' yorail chc'ot ti muc'ta q'uin Pascua cu'untutique. Hech yu'un laj sc'ambeic ti Pilatoe ac'o yich' c'asbel yacanic, yu'un hech chchamic ti ora, hech xu' chloc' stacopalic ti cruz. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hech yu'un ital ti soldadoetique. C'ot sc'asbe yacan ti june. Ja' no'ox hech laj sc'asbe yacan ti jun xchi'ile, ja' ti co'ol ijoc'anatic ti cruz xchi'uc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Hech ic'otic ti stojol ti Jesuse. Chamen xa laj yilic ti Jesuse hech yu'un muc sc'asbeic yacan. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ti jun soldadoe laj xembe xocon ti lanza ti Jesuse. Ti ora iloc' xch'ich'el xchi'uc ya'lel sbec'tal. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ho'on laj quil ti c'u che'el icham ti Cajvaltique. Melel chcal yu'un hech chana'ic uc ti ho'oxuque. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Hech ic'ot ti pasel yu'un tsts'aqui ti c'u che'el ts'ibabil comel ti sun ti Diose: “Mi jch'ixuc mu xpejbat sbaquel”, ti xchi ono'ox sc'opilale. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Hech ts'ibabil comel uc ti sun ti Diose: “Ta ono'ox xiyilucun ti xembil jxocon yu'unique”, ti xchi ono'ox sc'opilale. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Oy jun jchi'iltutic, José sbi. Liquem tal ti jteclum Arimatea sbi. Mucul no'ox xch'unojbe sc'op ti Jesuse yu'un chi' yu'un ti totiletique. Yu'un laj yil ti c'u che'el icham ti Jesuse, hech yu'un ba sc'opon ti Pilatoe, laj sc'ambe stacopal ti Jesuse. Ti Pilatoe laj yal mantal ti ac'o sloq'uesbe stacopal ti cruz ac'o ba smuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ital uc ti Nicodemoe, ja' ti a sc'opon ti Jesuse ti ac'ubaltic. Laj yich' tal poxil mirra sbi capal ti aloetic. Oy van lajuneb xcha'vinic kilo yalal. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Laj yich'beic batel ti stacopal ti Jesuse. Laj sbech'ic batel ti saquil poc'. Te laj stic'beic batel uc ti mirrae xchi'uc ti aloetique yu'un hech mu xvinaj yic'. Ja' jtaleltutic ti jmuc jbatutic, ho'ontutic ti judiountutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ti bu ijipanat ti cruz ti Jesuse te ts'umbil olivate'etic te nopol. Te yo' bu ti ts'umbil olivate'etique oy ach' ch'en. Jombil ti ton ti ch'ene yu'un ja' sventa te tsmuc sbaic. Ach' to ti ch'ene, mu to oyuc much'u yac'oj te o. ");
INSERT INTO tzoNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yu'un ja' xa yorail chlic xcux yo'ntonic c'alal ch-ic'ub, yu'un nopol no'ox ti ch'ene, hech yu'un ihu' yu'unic laj stiq'uic ochel ti stacopal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ti sba c'ac'al ti semanae, ja' ti domingoe, ic' to ic'ot ti ch'en yo' bu mucul ti Jesuse ti Maríae, ja' ti liquem tal ti Magdalae. Laj yil balch'umbil xa loq'uel ti tone ja' ti smac sti' ti ch'ene. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hech yu'un ital ti anil tal yalbuntutic, ho'on ti lum c'uxun ti yo'nton ti Jesuse xchi'uc ti Simon Pedroe. Hech laj yalbuntutic: ―Laj xa sloq'uesic batel ti stacopal ti Cajvaltique. Mu jna'tutic bu laj yaq'uic batel ―xiyutuntutic ti Maríae. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hech yu'un nibatutic jcha'va'altutic ti ora yo' bu ti ch'ene. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Co'ol ni'anilajtutic batel. Ti ho'one nijelav. Jbael nic'ot yo' bu ti ch'ene. Icom ti Pedroe. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ho'oni ja' no'ox laj jcujan jba ti jq'uel ochel ti yut ch'ene. Laj quil te pochol ti lum ti saquil poq'ue. Muc xi'och ti yut ch'en. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","C'alal ihul ti Simon Pedroe, toj i'och ti yut ch'en. Laj yil te putsq'uijem xa ti lum ti saquil poq'ue, ja' ti xpix ti sbec'tal ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ja' no'ox hech uc ti xpix ti sjole, putsq'uijem xa uc. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Patil ni'och ti yut ch'en uc, ho'on ti jbael nic'ot yo' bu ti ch'ene. C'alal laj quil c'u x'elan ti poq'ue, laj jch'un ti icha'cuxi ti Cajvaltique hech chaj c'u che'el laj yalbuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ja'to lic ca'ibetutic sjam hech chaj c'u che'el ts'ibabil comel ti sc'op ti Diose ti persa chcha'cuxi loq'uel ti ch'en ti Cajvaltique. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hech yu'un hech nisututic batel ti jnatutic ho'ontutic ti yajchanc'opuntutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ti Maríae te va'al icom ti ti'ch'en. Te i'oc'. C'alal yac'oj sba ch-oc' laj scujan sba laj sq'uel ochel ti yut ch'ene. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Laj yil te nacajtic cha'vo' ch'ul abatetic. Sac ti jyalel ti sc'u' spoq'uique. Te nacajtic ti bu i'ac'at comel ti stacopal ti Jesuse, jun ti sjol, jun ti yacan. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Hech i'albat ti Maríae: ―Me'e, ¿c'u yu'un cha'oc'? ―x'utat. Hech itac'av ti Maríae: ―Yu'un laj xa sloq'uesic batel ti sbec'tal ti Cajvale. Mu jna' bu laj yaq'uic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","C'alal laj xa yal hech ti Maríae, laj sjoyp'in sba. Laj yil te va'al jun vinic. Muc xojtiquin ti ja' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ti Jesuse hech laj yalbe: ―Me'e, ¿c'u yu'un cha'oc'? ¿Much'u chasa'? ―xchi. Ti Maríae laj scuy ti ja' ti jchabiej'olivate'etique, hech yu'un hech laj yalbe: ―Tote, mi ho'ot laj avich'bun batel ti sbec'tal ti Cajvale, albun xca'i bu laj avac'bun yu'un chba quich' talel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Hech itac'av ti Jesuse: ―¡María! ―xchi. Hech yu'un laj sjoyp'in sba ti Maríae. Hech laj yalbe ti hebreo c'op: ―¡Raboni! ―xchi. Ho'ot Maestro, xchi c'alal jelavesbil. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ti Jesuse hech laj yalbe: ―Mu me xapajesun yu'un ta ono'ox xibat ti stojol ti Jtote. Batan, ba albo ya'yic ti quermanotique: Chibat ti stojol ti Jtote, ti Atotic uque. Ja' ti stojol ti Dios cu'une, ti Dios avu'unic uque, xiyutun, xavut me ti yantique ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Hech yu'un ti Maríae ti liquem tal ti Magdalae hech tal yalbuntutic ho'ontutic ti yajchanc'opuntutic ti Jesuse: ―Laj xa quil ti Cajvaltique ―xiyutuntutic. Laj yalbuntutic uc scotol ti c'u che'el i'albat yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mal xa c'ac'al ti sba c'ac'al ti semanae, ja' ti domingoe, jmacoj jbatutic ti na ho'ontutic ti yajchanc'opuntutic ti Jesuse. Yu'un nixi'tutic yu'un ti totiletic cu'untutique, ja' ti co'ol judiountutic xchi'uque, hech yu'un lec jmacojtutic ti sti' jnatutique. Ti ora no'ox ivinaj te ti o'lol yut jnatutic ti Jesuse yo' bu jtsoboj jbatutique. Hech laj yalbuntutic: ―Tal jtoj avo'ntonic ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","C'alal hech laj yalbuntutic ti Jesuse, laj yac'bun jq'ueltutic ti sc'obe ti xocone. Laj jna'tutic ti ja' ti Cajvaltique, hech yu'un nichim no'ox co'ntontutic jcotoltutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ti Jesuse yan vuelta laj yalbuntutic: ―Tal jtoj avo'ntonic. Hech chaj c'u che'el laj stacun talel li'i ti Jtote, ja' no'ox hech chajtacoxuc batel uc hech chapasbun cabtel ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","C'alal hech laj yalbuntutic ti Jesuse, laj svuch'ta tal ti jtojoltutic, hech laj yalbuntutic: ―Ich'ic ti Ch'ul Espíritue ―xiyutuntutic―. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ti much'u tsutes yo'nton yu'un ti smule, xu' chavalbe ti ich'ay xa ti smule. Ti much'u mu sc'an sutes yo'nton yu'un ti smule, xu' chavalbe ti mu ch'ayemuc ti smule ―xiyutuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ti Tomase mu teuc ti c'alal ital ti Jesuse. Ja' ti vats sbi cu'untutique. Ja' lajchavo'untutic xchi'uc ti Tomase ho'ontutic ti yajchanc'opuntutic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hech yu'un hech laj calbetutic: ―Laj xa quiltutic ti Cajvaltique ―xcututic. Hech itac'av ti Tomase: ―Ja'to mi laj quil jtuque ti yav lavuxe ti sc'obe, ja'to mi laj jtic' sbic'tal jc'ob ti bu yav lavuxe, ja'to mi laj jtic' jc'ob ti xocone, ja'to ti jch'un ti icha'cuxi xae ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Iloc' vaxaquib c'ac'al ti c'alal laj yac' sba ti q'uelel ti jtojoltutic ti Jesuse. Yan vuelta laj jtsob jbatutic ti na ho'ontutic ti yajchanc'opuntutique. Te jchi'inoj jbatutic xchi'uc ti Tomase. Macal ti ti'nae. Hech no'ox ivinaj ti ora ti Jesuse te ti o'lol yut jnatutic yo' bu jtsoboj jbatutique. Hech laj yalbuntutic: ―Tal jtoj avo'ntonic ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Hech laj yalbe ti Tomase: ―La' tic'o ac'ob li' ti jc'obi. La' q'uelo avil ti jc'obe. Xach'o tal ac'obe, tic'o ti jxocon. Mu me xchibaj avo'nton. Ch'uno me ti nicha'cuxi xae ―x'utat yu'un ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Hech itac'av ti Tomase: ―¡Cajval cu'un, Dios cu'un! ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ti Jesuse hech laj yalbe: ―Tomás, ja'to ti laj avilune, ja'to laj ach'un ti nicha'cuxi xae. Jun no'ox yutsil ti much'u chch'un ti mu yilojucune mi jutuc ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Oy to ep yan jchop o abteletic laj spas ti Jesuse ti jtojoltutic ho'ontutic ti yajchanc'opuntutique muc x'och ti ts'ibael li'to. ");
INSERT INTO tzoNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ja' sventail ti i'och ti ts'ibael avi yepal li'to yu'un chach'unic ti ja' Jcoltavanej cu'untic ti Jesuse, ti ja' Snich'on ti Diose. Yu'un mi hech chach'unic, hech chacuxiic sbatel osil ti sventa. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yan vuelta laj yac' sba ti q'uelel ti jtojoltutic ti Jesuse ho'ontutic ti yajchanc'opuntutique. Te laj yac' sba ti q'uelel te ti ti'nab te ti estado Galilea. Hech laj yac' sba ti q'uelel ti jtojoltutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Te jtsoboj jbatutic xchi'uc ti Simon Pedroe, xchi'uc ti Tomase, ja' ti vats xcututique. Xchi'uc ti Natanaele, ja' ti liquem tal ti jteclum Caná te ti estado cu'untutic, ja' ti Galileae. Xchi'uc ti cha'vo'untutique ti ja' jtotutic ti Zebedeoe. Xchi'uc yan cha'vo' jchi'iltac ti abtel. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ti Simon Pedroe hech laj yalbuntutic: ―Chba jtsac choy ―xiyutuntutic. ―Batic, chajchi'inot batel uc ―xcututic. Hech ba jtic' jbatutic ti barco. Sjunul ac'ubal laj jsa'tutic ti choye. Muc jtatutic mi jcotuc. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","C'alal isacub ti osile, tal sva'an sba ti ti'nab ti Jesuse. Ho'ontutic ti yajchanc'opuntutique muc xcojtiquintutic ti ja' ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ti Jesuse hech laj sjac'buntutic: ―Queremotic, ¿mi oy laj ataic ti choye? ―xiyutuntutic. ―Mu'yuc ―xichitutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ti Jesuse hech laj yalbuntutic: ―Tenic ochel aleb te ti hech barco te ti abats'ic'obic. Te chataic ―xiyutuntutic. Hech yu'un c'alal laj jtentutic ochel ti jlebtutic ti ho', muc xu' cu'untutic ti jnitutic ochel ti barco yu'un nojem ti choy. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ho'oni ti lum c'uxun ti yo'nton ti Jesuse, hech laj calbe ti Pedroe: ―¡Ja' ti Cajvaltique! ―xcut. C'alal laj ya'i ti Simon Pedroe ti ja' ti Cajvaltique, laj slap sc'u' yu'un banal. Laj sten sba ochel ti nab yu'un chba sta ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ho'ontutic nixanavtutic batel ti barco jchochojtutic tal ti jlebtutique ti bu tiq'uil ti choye. Mu nomuc, nopol no'ox ti'nab. Oy van ho'vinicuc metro. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","C'alal niloc'tutic ti barco te ti ti'nab, laj quiltutic pasbil c'oc'. Chacpoman xa ti c'oq'ue. Oy choy yac'oj sba tsvo ti c'oc'. Oy vaj uc. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ti Jesuse hech laj yalbuntutic: ―Ich'ic tal cha'cot oxcot ti choy ti laj atsaquique ―xiyutuntutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Hech yu'un i'och ti barco ti Simon Pedroe. Hech laj snit loq'uel tal ti yut ho' ti jlebtutique. Nojem ti choy. Puru muc'tic choy. Oy ciento cincuenta y tres ti choye. Manchuc mi ep ti choye, muc xtuch' ti jlebtutique. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ti Jesuse hech laj yalbuntutic: ―La' ve'anic ―xiyutuntutic. Ho'ontutic ti yajchanc'opuntutique ¿much'uot? muc xichitutic xa yu'un laj cojtiquintutic xa ti ja' ti Cajvaltique. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ti Jesuse laj stsac ti vaje, laj yac'buntutic ho'ontutic ti yajchanc'opuntutique. Laj yac'buntutic choy uc. Hech nive'tutic. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ja' yoxibal vuelta ti laj yac' sba ti q'uelel ti jtojoltutic ti Jesuse c'alal cha'cuxem xa loq'uel ti ch'en. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","C'alal laj co'nton ve'ucuntutic, ti Jesuse hech laj sjac'be ti Simon Pedroe: ―Simón, snich'onot Jonás, c'ux chiya'yun ti achi'iltac li'to. ¿Mi ech'em c'uxun ti avo'nton ho'oti? ―xchi. Hech itac'av ti Pedroe: ―Cajval, xana' ti c'uxot ti co'ntone ―xchi. Ti Jesuse hech laj yalbe: ―Mac'limbun scotol ti much'utic chixch'umbucun ti jc'ope hech ch-an yip yo'ntonic ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ti Jesuse hech laj xcha'jac'be nixtoc: ―Simón, snich'onot Jonás, ¿mi c'uxun ti avo'nton? ―xchi. Hech itac'av ti Pedroe: ―Cajval, xana' ti c'uxot ti co'ntone ―xchi. Ti Jesuse hech laj yalbe: ―Chabibun scotol ti much'utic chixch'umbucun ti jc'ope ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ti Jesuse hech laj sjac'be ti yoxibal vuelta: ―Simón, snich'onot Jonás, ¿mi c'uxun ti avo'nton? ―xchi. Hech lic yich' mul ti Pedroe yu'un yoxibal xa vuelta ti hech ijac'bate ¿mi c'uxun ti avo'nton? ti xchi chjac'bate. Hech itac'av: ―Cajval, scotol oy ti avo'nton. Xana' ti c'uxot ti co'ntone ―xchi. Ti Jesuse hech laj yalbe: ―Mac'limbun scotol ti much'utic chixch'umbucun ti jc'ope hech ch-an yip yo'ntonic ―xchi―. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Melel ti c'usi chacalbee, c'alal unenot to mu'yuc palta laj ava'i. Ja' atuc laj achuquilan ach'ut buc no'ox nabat. Pero chc'ot yorail c'alal namalub xa chaxchucbot ac'ob abec'tal ti te', hech chamilat ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ti Jesuse hech laj yac'be sna' ti Pedroe ti c'u che'el chchame ti c'u che'el chac' ti pasel ti muc' ti Diose. Hech ono'ox ic'ot ti pasel ti hech icham ti Pedroe. Ti Jesuse hech laj yalbe uc ti Pedroe: ―Ho'on chats'acliun ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ti Pedroe laj sjoyp'in sba. Laj yil ti te xa xital ti spat ho'on ti lum c'uxun ti yo'nton ti Jesuse, ho'on ti te metselun ti sts'el ti Jesuse c'alal nive'tutic c'alal hech laj jac'be ti Jesuse: “Cajval, ¿much'u chayac'ot entrecal?” ti xcute. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ti Pedroe, c'alal laj yilun, hech laj sjac'be ti Jesuse: ―Cajval, ti jchi'il li'to, ¿c'usi sc'opilal chavalbe uc? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ti Jesuse hech laj yalbe: ―Mi ti jc'an ti cuxul chul jtae, mu aventauc. Ho'oti ts'aclinun ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hech yu'un laj ya'yic ti quermanotique ti mu xicham ho'oni. Mu xcham, mu xchiuc jc'opilal yu'un ti Jesuse. Ja' no'ox laj yal: “Mi ti jc'an ti cuxul chul jtae, mu aventauc”, xchi no'ox jc'opilal. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Scotol ti laj xa jts'iba li'to, laj quil laj ca'i ho'on ti Juanune, ho'on ti yajchanc'opun ti Jesuse. Melel ti hech ic'ot ti pasele. ");
INSERT INTO tzoNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Oy to ep c'utic yan lequil abtel laj spas ti Jesuse. Ti taca to ochuc ti ts'ibael ti jujutos ti yabtele, ep ti jyalel ti hunetique ti hechuque. Ja'uque ti c'u yepal i'och ti ts'ibaele, ta yutsil yu'un chijcol.");
INSERT INTO tzoNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, ti hun ti laj xa jtacbot talele, ho'on ti Lucasune, laj jcholbot ava'i scotol ti c'usi lic spas ti Jesuse xchi'uc scotol ti c'usi lic yac' ti a'yele. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ja'to c'alal ista yorail imu batel ti vinajele ja' laj xa calbot scotol obi. Ti ora to yan ti c'usi chacalbote. C'alal mu to chmu batel ti Jesuse, ti sventa ti Ch'ul Espíritue laj spas comel ti mantal ti much'utic tstac batele, ja' ti jcholc'opetique, ja' ti t'ujbilic yu'une. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","C'alal i'ech' xa ti svocole, cuxul laj yac' sba ti q'uelel ti stojolic. Ep vuelta laj yac' señail ti icuxi xae. Cha'vinic c'ac'al laj yac' sba ti q'uelel ti stojolic. Laj xcholbe ya'yic ti c'utic x'elan tspasvan ti mantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","C'alal te stsoboj sbaic xchi'uc ti Jesuse, hech ipasatic ti mantal: ―Mu to me xaloq'uic batel li' ti Jerusalén li'to. Ta me xamalaic ja'to mi laj xa avich'ic ti Ch'ul Espíritue ti yaloj ti Jtotique ti chacac'boxuque hech chaj c'u che'el calojboxuc. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Laj yac'boxuc avich'ic ho' ti Juane. Po'ot xa chacac'boxuc avich'ic ti Ch'ul Espíritue ti ho'one ―xchi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hech yu'un ti c'alal te stsoboj sbaic xchi'uc ti Jesuse, hech lic sjac'beic ti Jesuse: ―Cajval, ¿mi po'ot xa chavac' chi'ochtutic ti ajvalil yu'un hech ti jventain jbatutic jtuctutic yan vuelta? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hech itac'av ti Jesuse: ―Mu persauc chana'ic ti c'usi ora chc'ot ti pasele. Ja' sna' stuc ti Jtotic Diose. Ja'to ti c'usi ora snopoj stuc ti Jtotic Diose, ja'to chc'ot ti pasel. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ti ho'oxuque ja' no'ox aventaic chacholbun jc'opilal li' ti Jerusalén li'to xchi'uc ti sjoylejal jlumaltic xchi'uc ti slumal Samaria xchi'uc ti sjoylejal balumil. Yu'un ch-an yip avo'ntonic ti c'alal ch-och ti avo'ntonic ti Ch'ul Espíritue ―xchi comel ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","C'alal hech laj yal ti Jesuse, ti jcholc'opetique laj sq'uelic ti imu batel ti Jesuse. Sq'uelojic ich'ay batel ti toc ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","C'alal yac'oj sba sq'uelic ti ibat ti vinajel ti Jesuse, ti ora ivinaj jun to cha'vo' viniquetic x'elan te ti sts'elic. Sac sc'u' slapojic ti xcha'va'alique. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Hech i'albatic: ―Galileaetic, ¿c'u yu'un chaq'uelic vinajel? Ja' ti Jesuse ti imu xa batel ti vinajel ti laj avilique, ja' chcha'tal nixtoc. Hech chaj c'u che'el isut batel, ja' no'ox hech chcha'tal nixtoc ―x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ti jcholc'opetique te oyic xchi'uc ti Jesuse te ti vits Olivatic c'alal laj sta yorail imu batel ti vinajel ti Jesuse. O'lol ora xil sbaic ti Jerusalene xchi'uc ti vitse. C'alal ibat xa ti Jesuse hech isutic batel ti Jerusalén ti jcholc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","C'alal ic'otic ti Jerusalén, i'ochic batel ti na. Imuic batel ti cuarto te ti xcha'cajal na ti bu xch'amunojic ti nae. Ja' ti Pedroe xchi'uc ti Juane xchi'uc ti Jacoboe xchi'uc ti Andrese xchi'uc ti Felipee. Xchi'uc ti Tomase xchi'uc ti Bartolomee xchi'uc ti Mateoe xchi'uc ti Jacoboe, ja' ti snich'on ti Alfeoe. Xchi'uc ti Simone, ja' ti xchi'inoj ono'ox ti much'u hech yo'ntonic ti mu me stsalatic yu'un yan ajvalil. Xchi'uc ti Judase, ja' ti snich'on ti Jacoboe. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Scotol c'ac'al jtos yo'ntonic laj sc'oponic Dios. Te stsoboj sbaic xchi'uc antsetic xchi'uc ti Maríae, ja' ti sme' ti Jesuse, xchi'uc ti yits'inabtac ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ja' hech yorail laj sva'an sba ti Pedroe ti c'alal te stsoboj sbaic xchi'uc ti yan quermanotique. Oy van ciento veinte ti vo' te stsoboj sbaic. Hech laj yal ti Pedroe: ");
INSERT INTO tzoNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Quermanotac, persa ic'ot sc'op ti Diose ti ts'ibabil comel ti sune. Ti Ch'ul Espíritue vo'one laj xch'amumbe ye ti Davide yu'un laj yalbe comel sc'opilal ti Judase, ja' ti much'u j'ic'vanej yu'un hech c'ot stsaquic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ja' lajchavo'untutic xchi'uc ti Judase. Ti Diose co'ol laj yac'buntutic cabteltutic xchi'uc ―xchi ti Pedroe. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ti Judase itojat yu'un ba spas ti c'usi chopole. Patil ba sutes ti taq'uine, hech yu'un ti much'u laj yich' ti taq'uine ja' ba sman balumil xchi'uc. Hech yu'un ti Judase ja' te ba smil sba. Ma'uc no'ox yu'un te joc'ol icom hech chaj c'u che'el snopoj. Ja' ip'aj yalel, patal ic'ot. Hech it'om xch'ut, iloc' scotol sbiquil. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ipuc sc'opilal. Scotol laj ya'ibeic sc'opilal ti much'utic te nacajtic ti Jerusalene. Acéldama laj sbiin ti balumile. Ja' ch'ich' balumil sbi c'alal jelavesbil.) ");
INSERT INTO tzoNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Hech laj yal uc ti Pedroe: ―Hech ts'ibabil ti q'uejoj: J'ech'el te jeluc o ti slume ti bu chchame. Mu'yuc much'u chnaqui te o, ti xchie. Hech ts'ibabil uc ti oy much'u tstsacbat yabtel, ti xchie. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Hech yu'un persa ch-och ti t'ujel junuc ti much'utic scotol c'ac'al laj xchi'inuntutic xchi'uc ti Cajvaltic Jesuse c'alal nixanav xchi'uc yu'un hech co'ol ti jpucbetutic sc'opilal ti Jesuse ti icha'cuxie. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Hech yu'un ac'o ochuc ti t'ujel junuc ti much'u scotol laj yil ti c'alal i'ac'bat yich' ho' ti Jesuse yu'un ti Juane ja'to c'alal ista yorail imu batel ti vinajel laj quiltutic xchi'uc ―xchi ti Pedroe. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hech i'och ti t'ujel yu'unic cha'vo' viniquetic. José Barsabás sbi ti june. Justo ja' sjol sbi uc. Matías sbi ti yane. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Hech laj sc'oponic Dios: ―Cajval, ho'ot xavojtiquimbe yo'ntonic scotol crixchanoetic. Ti xcha'va'alic li'to ac'bun jna'tutic ti much'u t'ujbil avu'une, ");
INSERT INTO tzoNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","yu'un ch-och ti abtel ti atojol, yu'un ch-och ti jcholc'op avu'un. Ja' tstsacbe yabtel ti Judase. Yu'un ti Judase laj scomes ti yabtele, ba yich' vocol sbatel osil ―xchiic ti stojol ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Hech yu'un laj spasic al yu'un tsq'uelic ti much'u tstsacbe yabtele. Ic'ot ti sventa ti Matíase. Hech i'och ti jcholc'op uc. Ja' lajchavo' ic'otic xchi'uc obi. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ti judioetique tspasic q'uin chac'beic smoton ti Diose ti c'alal ihu' xa yu'unic ti sc'ajojique. Ja' Pentecostés sbi ic'ot yu'un ti cincuenta c'ac'al xil sbaic xchi'uc ti q'uin pascuae. Hech yu'un c'alal ista yorail ti mero sc'ac'alil q'uin Pentecostese, te stsoboj sbaic ti jcholc'opetique xchi'uc ti jch'unojeletique. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Oy c'usi tsots ic'opoj laj ya'yic iyal tal ti vinajel. Hech chaj c'u che'el x'i'et no'ox chtal ic' laj ya'yic scotolic ti bu nacajtique. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Laj yilic jun to yat c'oc' x'elan hul pucuc ti stojol jujun. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Scotolic inoj ti yo'ntonic ti Ch'ul Espíritue. Lic c'opojuc ti yantic c'opetic, c'usuc no'ox c'opal i'ac'bat ti yo'ntonic yu'un ti Ch'ul Espíritue. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yu'un talemic ti Jerusalén ti judioetique ti buc no'ox puquemic ti jlumaltic, ho'ucutic ti yanlum crixchanoucutique, yu'un tal yaq'uic smoton Dios ti yorail ti q'uine hech chaj c'u che'el yaloj ti Diose. Hech yu'un talemic ti much'utic ti toyol yo'ntonic tsc'an chch'umbeic smantal ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","C'alal oy ic'opoj laj ya'yic scotolic, hech laj stsob sbaic tal. Jujun laj ya'i ic'oponatic ti sc'opic. Ich'ay yo'ntonic. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ep ilo'laj yo'ntonic. Ep laj snopic c'u che'el chc'oponatic ti sc'opic. Lic yalbe sbaic: ―Ja' ti jchi'iltic ti liquemic tal ti Galilea ti li' chc'opojique. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿C'u che'el chisna'bucutic jc'optic ti ho'ocutique ti jchanojtic yan c'opetique? ―xut sbaic―. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ep ti tosucutic ti li' capalucutiqui. Oy talemucutic ti Partia, oy talemic ti Media, oy talemic ti Elam, oy liquemic tal ti Mesopotamia xchi'uc much'utic li' ti Judeae xchi'uc much'utic liquemic tal ti Capadocia xchi'uc ti Ponto xchi'uc ti Asia. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Capalucutic xchi'uc much'utic liquemic tal ti Frigia xchi'uc ti Panfilia xchi'uc ti Egipto. Capalucutic xchi'uc much'utic liquemic tal ti Africa te ti yech'el slumal cireneetic. Capalucutic xchi'uc ti much'utic liquemic tal ti Romae ti co'ol xch'unojic hech chaj c'u che'el ti ho'ocutique. Talem uc ti jchi'iltique ti te nacajtic ti Romae. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Capalucutic xchi'uc cretaetic xchi'uc arabiaetic. Jcotoltic chca'itic ti jc'optic ti chixcholbucutic c'usi lec abtelal laj xa spas ti Diose ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Hech ich'ay yo'ntonic scotolic. Muc sna'ic c'u yu'un hech ic'ot ti pasel. Hech laj sjac'be sbaic: ―¿C'usi sjam xana'? ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Oy yantic hech laj yal: ―Ja' jyacubel ―xchiic. Ja' tslabanic. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Te va'ajtic ti slajchava'alique, ja' ti jcholc'opetique. Tsots lic c'opojuc ti Pedroe. Hech lic yalbe: ―Totetac, ho'oxuc ti li' nacaloxuc ti Judeae xchi'uc ti ho'oxuc ti li' natalic ti Jerusalene, a'ibun jc'op chacalboxuc. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Jyacubeluntutic chacuyic. Mu hechuc yu'un baluneb to no'ox ora sob ic'luman. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Avi to ti ic'ot ti pasel ja' ti c'usi albil comel yu'un ti Joele, ja' ti j'alc'op yu'un ti Diose ti vo'one: ");
INSERT INTO tzoNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Hech laj yalbun ti Diose, xchi ti Joele. Chcac'be yich' ti Espíritu cu'une ti jaylajuntos crixchanoetic ti sjoylejal balumil. Ja' sliqueb batel ti slajebal c'ac'ale. Ti avol anich'onique chlic xcholbucun ti jc'ope. Ti unen viniquetique ja' chcac'be sq'uelic señail ti c'u che'el ti jtojobtas batele. Ti moletique chcac'be sq'uelic ti svaichic. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mi viniquetic, mi antsetic, hech chcac'be yich' ti Espíritu cu'une ti abatetic cu'une. Chixcholbucun ti jc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Chcac' ti q'uelel jchop o abteletic li' ti vinajele. Ja' tsq'uelic scotolic ti much'utic te oyic ti balumil. Chliquic ti xi'el yu'un. Hech chc'ot hech chaj c'u che'el ch'ich' ti vinajele. Oy c'oc' uc, yan sba xch'ayilal. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Hech chtup' ti c'ac'ale scoj ti ch'ayile. Tsoj hech chaj c'u che'el ch'ich' chc'ot ti ue. Hech chc'ot ti pasel c'alal po'ot xa tsta yorail chba chapanvanucun. Melel ti tsta yorail ti chba chapanvanucune. Ja' tsots sc'opilal. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Scotol ti much'u tsc'an coltailanel ti jtojol, ja' mu x'ac'bat castigo. Ja' chcol sbatel osil, xchi ti Diose, xchi ti Joele. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Totetac, a'yo me ava'yic. Ho'ucutic ti yol snich'onucutic ti Israele ac'o jna'tic ti jchop o abteletic laj spas ti Jesuse, ja' ti ilic tal ti Nazarete. Laj spas ti jtojoltic laj jq'ueltic. Ich'ay co'ntontic yu'un. Hech ivinaj ti t'ujbil yu'un ti Diose yu'un ti sventa ti Diose ihu' yu'un scotol. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ja' i'ac'at entrecal ti Jesuse yu'un ti Diose vo'one hech chapal ti yo'nton. Ho'oxuque laj atsaquic ti Jesuse, laj ajipanic ti cruz. Laj avac'beic smil ti much'utic mu'yuc Dios ti yo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ti Diose muc xac' ti j'ech'el chcham ti Jesuse. Laj xcha'cuses loq'uel ti ch'en. Yu'un mu xu' ti j'ech'el chcham ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yu'un ti jtotic Davide vo'one hech laj yal: Scotol c'ac'al achi'inojun. Chamuc'ubtasbun co'nton hech un muc un chixi'. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hech nichim no'ox co'nton. Hech lec chic'opoj avu'un. Yu'un ti achi'inojune hech yu'un manchuc mi chicham, jna' ti chicha'cuxi ti yan c'ac'al xchi'uc ti jbec'tale. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yu'un mu xavac' comuc jch'ulel yo' bu xch'ulelic ti much'utic tsmalaic chapanel. Mi jutuc muc chavac' c'a'uc ti jbec'tale, ho'on ti anich'onune, ho'on ti jtos co'ntontique. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ho'ot laj xa avac'bun jna' ti chicuxi sbatel osil avu'une. Hech yu'un nichim no'ox co'nton ti atojol sbatel osil, xchi ti Davide. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Hech yu'un, totetac, chacalbot ava'yic sjam ti hech chaj c'u che'el laj sc'opon Dios stuc ti jtotic Davide. Ma'uc sc'opilal stuc ti jtotic Davide ti hech laj yale. Ja' ti Cajvaltic Jesuse ti hech laj sc'opon ti Stote. Ja' no'ox yu'un ich'amumbat ye ti jtotic Davide. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ja' j'alc'op yu'un ti Diose ti jtotic Davide. Hech i'albat yu'un ti Diose: Ja' ch-och ti aq'uexol ti avol anich'on yu'un ch-och ti ajvalil yu'un ti achi'iltaque. Ja' ti Cristoe, ja' avol anich'on ti sventa abec'tal, x'utat ti jtotic Davide. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ti jtotic Davide laj sna' ti chc'ot ti pasel. Hech chaj c'u che'el laj yalbe sc'opilal ti Cristoe hech ic'ot ti pasel. Icha'cuxi loq'uel ti ch'en ti Cristoe. Muc xcom xch'ulel te o yo' bu xch'ulelic ti much'utic tsmalaic chapanel. Muc xc'a' ti sbec'tale. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ti Diose laj xcha'cuses loq'uel ti ch'en ti Jesuse. Ho'ontutic laj quiltutic jcotoltutic. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ti sventa sp'ijil ti Diose i'ic'at muel ti vinajel ti Jesuse. Albil ono'ox yu'un ti Jtotic Diose ti Jesuse ti ja' tstac talel ti Ch'ul Espíritue, ja' laj xa quich'tutic ti ora to. Laj xa avilic, laj xa ava'yic. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Manchuc mi muc xmu batel ti vinajel xchi'uc sbec'tal ti Davide, hech laj yal: Ti Jtotic Diose hech laj yalbe ti Cajvale: “Chlic naclan li' ti jbats'ic'ob ");
INSERT INTO tzoNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ja'to mi laj jtsalbot scotol avajcontra”, x'utat ti Cajvale yu'un ti Jtotic Diose, xchi ti Davide. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Ho'ucutic ti yol snich'onucutic ti Israele, hech ac'o jna'tic jcotoltic. Ti Diose laj xa yac' ochuc ti ajvalil sventa scotol crixchanoetic ti Jesuse ti laj amilic ti cruze. Ja' Jcoltavanej cu'untic ―xchi ti Pedroe. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","C'alal laj ya'ibeic sc'op ti Pedroe, ep laj yich'ic mul yu'un smulic ti crixchanoetique. Hech yu'un laj sjac'beic ti Pedroe xchi'uc ti yan jcholc'opetique: ―Quits'in, ¿c'usi chcututic? ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ti Pedroe hech laj yalbe: ―Suteso avo'ntonic yu'un amulic. Ac'o abaic ti ich'ho' ti sventa ti Jesucristoe ti jujunoxuque. Hech chaxch'aybot amulic. Hech chayac'boxuc amotonic uc ti Diose. Ja' chavich'ic uc ti Ch'ul Espíritue. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yalojbucutic ti Diose ti chijyac'bucutic quich'tic ti Ch'ul Espíritue jcotoltic xchi'uc col jnich'ontic xchi'uc scotol ti much'utic mu to sna'ic bu oy ti Diose. Scotol ti much'utic ch-ic'atic yu'un ti Cajvaltique, ja' ti Dios cu'untique, ja' ch-ac'batic ―xchi ti Pedroe. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Oy to ep yan laj yalbe ti Pedroe. Hech itaq'uivan: ―Ac'o abaic ti ventainel yu'un ti Diose hech mu ch'ayeluc chabatic xchi'uc ti jmulaviletic ti li'oyic ti balumil ti ora to ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ti much'utic laj spasbeic ti muc' ti sc'op ti Pedroe laj yich'ic ho'. Oy oxmil ti laj xch'unique ti jun no'ox c'ac'al. Hech i'epaj ti jch'unojeletique. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Toyol yo'ntonic laj xchanic ti c'usi i'albatic yu'un ti jcholc'opetique. Jtos yo'ntonic scotolic hech yu'un nichim no'ox yo'ntonic. Toyol yo'ntonic laj sc'oponic Dios. Toyol yo'ntonic laj spasic hech chaj c'u che'el laj yac' ti q'uelel ti Cajvaltique c'alal laj xet' ti caxlan vaje laj yuch' ti ya'lel sat uvate'e. Ja' hech laj spasic uc yu'un laj sna'ic ti Cajvaltique ti ja' icham yu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Scotolic laj xi'ic ti Diose. Ep jchop o abteletic ihu' yu'unic ti jcholc'opetique. Ja' ti sventa ti Cajvaltique. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Scotol ti much'utic xch'unojic ti ja' Jcoltavanej yu'unic ti Cajvaltique, co'ol laj scolta sbaic scotolic. Laj yac'beic sve'elic ti much'utic mu'yuc sve'elique xchi'uc laj scolta ti me'onetic uque. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","C'alal chilic ti mu'yuc xa c'usi chtun yu'un ti yantique ba xchon slum xchi'uc ti c'usi oy yu'unic jujun. Yu'un ti c'usi oy yu'un ti yantique ja' yu'un ic'ot ya'yel uc ti much'utic mu'yuc yu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Scotol c'ac'al laj stsobilan sbaic ti templo te ti Jerusalén. Laj xet'ic ti caxlan vaje laj yuch'ic ti ya'lel sat uvate'e te ti snaic. Ja' laj sna'ic ti Cajvaltique. Nichim no'ox yo'ntonic ive'ic. Lec yo'nton scotolic. ");
INSERT INTO tzoNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Lec ic'opojic yu'un ti Diose. Lec sc'opilal icholbat yu'un scotol crixchanoetic. Ti sventa ti Cajvaltique scotol c'ac'al i'epaj ti jch'unojeletique. Hech i'epaj ti much'utic icolic yu'un ti smulique. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ti oxib ora mal c'ac'al, ja' yorail tsc'oponic Dios scotolic te ti templo te ti Jerusalén. Te ba sc'oponic Dios ti Pedroe xchi'uc ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","C'alal ta xa xc'otic te cuchbil ital jun vinic. Mecan c'alal i'an ti vinique. Scotol c'ac'al laj yiq'uic tal laj snacanic ti ti'templo ti bu t'ujume. Te nacal ti mecane ja' tsc'an paramote. Tsc'ambe staq'uin ti much'utic ch-ochic te ti temploe. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","C'alal laj yil ti mecane ti ch-ochic ti templo ti Pedroe xchi'uc ti Juane, ic'ambat staq'uinic. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ti Pedroe xchi'uc ti Juane laj sq'uelbeic sat ti mecane. Ti Pedroe hech laj yalbe: ―Q'ueluntutic tal ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ti mecane laj sq'uelbe batel satic. Tsmala mi oy c'usi ch-ac'bat yu'unic. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ti Pedroe hech laj yalbe: ―Mu'yuc jtaq'uin yu'un chacac'be. Ja' no'ox chacac'be ti c'usi oy cu'une. Ti sventa ti Jesucristoe ja' ti much'u ilic tal ti Nazarete, lican, xanavan batel ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ti Pedroe laj stsacbe sbats'ic'ob ti mecane, laj snit liquel. Ti ora i'an yip ti yacane ti mecane. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Toyol ip'it, laj sva'an sba, ixanav batel. Laj xchi'in ochel ti yut templo ti Pedroe xchi'uc ti Juane. Xp'itp'un no'ox batel. Yac'oj sba chalbe vocol ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Scotol crixchanoetic laj yilic ti chanav batel ti vinique, ti yac'oj sba chalbe vocol ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Laj yojtiquinic ti ja' ti much'u laj sc'an paramote ono'oxe ti te nacal ono'ox ti ti'templo ti bu t'ujume. Ich'ay yo'ntonic scotolic yu'un ti ichop xa ti mecane. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Te ti yut templo oy jun corerol, ja' scorerol Salomón ti sbie. Te va'ajtic ti Pedroe xchi'uc ti Juane. Te xchi'inoj ti mecan ti ichop xae, mu scomesvan ti mecane. Toj ch'ayel yo'ntonic ti crixchanoetique yu'un ti ichop xa ti mecane, hech yu'un te laj stsob sbaic tal. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ti Pedroe c'alal laj yil ti te xa laj stsob sbaic tal ti stojol, hech lic sc'opon. Hech laj yalbe: ―Totetac, chch'ay avo'ntonic chquil. Chaq'ueluntutic, chacuyic ti sventa jp'ijiltutic, ti sventa yutsil co'ntontutic ti ihu' xa cu'untutic yu'un ti chanav xa ti vinic avi to. Mu hechuc. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ja' ti Dios yu'unic ti antiguo jtatamoltique, ja' ti Abrahame xchi'uc ti Isaaque xchi'uc ti Jacobe, ja' laj xa yac' ti q'uelel ti tsots yabtel yich'oj ti Snich'one, ja' ti Jesuse. Ja' ti laj avaq'uic entrecal ti stojol ti Pilatoe. Ja' ti laj avalic ti mu xac'anic c'alal c'an scolta batel ti Pilatoe. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ti ho'oxuque muc xac'anic ti much'u mu'yuc smule, ti much'u toj yo'ntone. Ja' laj ac'anic ac'o coluc batel ti much'u jmilvaneje. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ja' laj amilic ti much'u chijyac'bucutic jcuxlejaltic sventa sbatel osile. Ti Diose laj xcha'cuses loq'uel ti ch'en. Ho'ontutic laj quiltutic. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jch'unojtutic ti ja' jelaven sp'ijil ti Jesuse. Hech ti sventa ti Jesuse icol xa avi vinic li'to ti chaq'uelique, ti xavojtiquinic ono'oxe. Yu'un laj xa yac'buntutic xch'unojel co'ntontutic ti Jesuse, hech yu'un icol xa ti vinique ti li' va'al ti atojolic ti chaq'uelic acotolique. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Totetac, jna' ti scoj ti muc xana'ic ti hech laj apasique. Muc sna'ic uc ti totiletic cu'untique. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Hech ono'ox ic'ot sc'op ti Diose ti hech chaj c'u che'el yaloj ono'oxe. Ja' sc'opilal ti Cristoe. Laj xch'amumbe ye scotol ti j'alc'opetic yu'une. Hech laj yalic persa ch-ech' svocol ti Cristoe. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Hech yu'un suteso me avo'ntonic yu'un amulic. Suteso me avo'ntonic ti stojol ti Diose hech chaxch'ayboxuc amulic. Hech chasmuc'ubtasboxuc avo'ntonic ti Cajvaltique. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Hech ti Diose chcha'tac sut tal ti Jesucristoe, ja' ti Jcoltavanej cu'untique, ti hech ono'ox cholbiloxuc ava'yojbeic sc'opilale. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ti Jesucristoe muem xa batel ti vinajel. Ja'to mi laj sta yorail ti tslecubtas scotol ti Diose hech chaj c'u che'el laj yal comel ti j'alc'opetic yu'un ti Diose ti vo'one, ja'to chtal. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Yu'un ti jtatamoltic Moisese hech laj yalbe ti jtatamoltique ti vo'one, ja' sc'opilal ti Jesuse: “Ti Diose, ja' ti Ajvalil cu'untique, ja' chist'ujbucutic j'alc'op. Chic' jun quermanotic hech chaj c'u che'el laj yic'un ho'oni. Ta me jpasbetic ti muc' scotol ti c'usi chijyalbucutique. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mi mu jpasbetic ti muc' ti sc'op ti j'alc'op yu'un ti Diose ti chcale, ja' ch'ayel chijbat”, xchi ti Moisese. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ja' primero laj yal ti jtatamoltic Samuele, ja' ti j'alc'op yu'un ti Diose ti vo'onee, ti chc'ot ti pasel, ja' ti ic'ot xa ti pasel nax. Co'ol laj yalic uc ti much'utic j'alc'opetic ti patil italique. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ti ho'ucutique ja' yol snich'onucutic ti j'alc'opetic yu'un ti Diose ti vo'one, hech yu'un comen ti jventatic ti tratoe ti laj xchapan ti Diose xchi'uc ti jtatamoltique ti vo'one. Ti Diose hech laj yalbe ti jtatamoltic Abrahame ti vo'one: “Ti sventa avol anich'on ch-ac'bat bendición scotol crixchanoetic, ti jaylajuntose ti oyic ti sjoylejal balumil”, x'utat yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ti Diose laj stac talel ti Snich'one. Primero ihul ti jventatic ti ho'ucutique yu'un chijyac'bucutic bendición yu'un chisutesbucutic co'ntontic yu'un jmultic ti jujunucutique ―xchi ti Pedroe. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Yac'oj sba tsc'oponic ti crixchanoetique ti Pedroe xchi'uc ti Juane c'alal italic ti paleetique, xchi'uc ti totil ti ja' chchabi ti temploe xchi'uc ti saduceoetique, ja' ti chch'unic ti mu'yuc much'u chcha'cuxie. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Liquem sjolic yu'un yac'oj sba chchanubtasvan ti Pedroe xchi'uc ti Juane. Ja' chalic ti chcha'cuxiic ti animaetique hech chaj c'u che'el icha'cuxi ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hech c'ot stsaquic ti Pedroe xchi'uc ti Juane. Laj stiq'uic ti chuquel yu'un mal xa c'ac'al. Ja'to oc'om chchapanic. Ti chuquele te ti templo. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ep ti much'utic laj ya'ibeic sc'op ti Diose laj xch'unic. Oy xa ho'mil ti viniquetique ti scotolique ti laj xa xch'unique. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ti yoc'omal laj stsob sbaic te ti Jerusalén ti totiletique xchi'uc ti moletique yu'un ti judioetique xchi'uc ti much'utic chchanubtasvanic ti smantal ti Diose ti scuyoj sbaique. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ital uc ti Anase, ja' ti totil palee, xchi'uc ti Caifase. Xchi'inoj talel yan cha'vo' paleetic. Juan sbi ti june, Alejandro sbi ti yane. Xchi'inoj talel uc scotol yermanotac ti totil paleetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Laj yiq'uic loq'uel tal ti chuquel te ti templo ti Pedroe xchi'uc ti Juane. Laj scacanic ti o'lol yo' bu stsoboj sbaique. Hech laj sjac'beic: ―¿C'u che'el xu' avu'unic ti hech chapasique? ¿Much'u ti sventa ti hech chapasique? ―x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ti Pedroe yu'un nojem ti yo'nton ti Ch'ul Espíritue, hech laj yalbe ya'yic: ―Totetac, ho'oxuc ti oy avabtelique, ");
INSERT INTO tzoNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","chajac'buntutic ti c'u che'el ichop ti mecane, ti c'u che'el laj jcoltatutique. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","A'yo me ava'yic ti acotolique, chacalboxuc. Jcotoltic ti israelucutique hech ac'o jna'tic ti ja' ti sventa ti Jesucristoe ja' ti ilic tal ti Nazarete, ichop xa ti vinic ti li' va'al ti jtojoltique. Ho'oxuc laj amilic ti cruz ti Jesuse. Ti Diose laj xcha'cuses loq'uel ti ch'en. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ti ho'oxuque hech chaj c'u che'el albañiletic ti tstenic loq'uel ti tone ti bu más leque, ja' ti patil chva'anat ti chiquina yu'un ti yajval nae. Ja' hechoxuc ti ho'oxuque yu'un muc xac'anic ti Jesuse. Ja' ti Diose laj xa yac'be tsots yabtel. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yu'un mu xijcolucutic yu'un yan. Ti sjoylejal balumil mu'yuc bu hech yan albil sc'opilal ti chijcolucutic yu'une ―xchi ti Pedroe. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Laj yilic ti oy stsatsal yo'ntonique ti Pedroe xchi'uc ti Juane. Ich'ay yo'ntonic yu'un laj sna'ic ti mu'yuc bu chanubtasbilic ti Pedroe xchi'uc ti Juane. Yilojic ti mu'yuc sp'ijilic ono'ox. Laj sna'ic ti ja' laj xchi'inic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mu'yuc c'usi xu' chalic yu'un te va'al ti sts'elic ti much'u icol yu'unique. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hech yu'un laj yalic mantal ac'o loc'uc batel j'oc'uc ti Pedroe xchi'uc ti Juane. Hech yu'un iloq'uic batel ti bu stsoboj sbaic ti totiletic yu'un ti temploe. Ti totiletique ti comón lic snopic c'usi chutic ti jcholc'opetique. Hech laj yalbe sbaic: ");
INSERT INTO tzoNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","―¿C'usi chcutic ti viniquetique? Melel ti oy jchop o abtel laj spasic. Scotolic ya'yojic xa ti much'utic nacajtic li' ti Jerusalene. Mu xu' ti jmuctic. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ja' no'ox mu me xpuc batel sc'opilal ti scotol jlumaltic. Ja' lec chcalbetic tsots mantal ti viniquetique, mu xa me xcholbeic yan sc'opilal ti Jesuse ―xut sbaic. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Hech yu'un laj yiq'uic ochel tal ti Pedroe xchi'uc ti Juane. Laj spasic ti mantal ti mu me xcholbeic xa yan sc'opilal ti Jesuse, mu me xchanubtasvanic ti sventa ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Itac'avic ti Pedroe xchi'uc ti Juane. Hech laj yalbeic: ―Nopo me ava'yic ¿mi ja' lec chc'ot ti stojol ti Diose ti chajch'umbeic ti amantalique? ¿Mi ma'uc lec ti jch'umbetutic smantal ti Diose? ");
INSERT INTO tzoNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ti ho'ontutique persa ti jcholtutic ti c'usi quilojtutique xchi'uc ti c'usi ca'yojtutique ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Hech yu'un ti totiletic yu'un ti temploe tsots laj spasic ti mantal ti Pedroe xchi'uc ti Juane. Patil laj staquic batel. Ti totiletique ixi' yu'un ti xchi'iltaque, hech muc spas ti chac'beic castigo ti Pedroe xchi'uc ti Juane. Scotol ti xchi'iltaque lec ic'opoj yu'un ti Diose, yu'un lec ti c'usi ic'ot ti pasele ti laj yilique. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yu'un ech'em ti cha'vinic habil yich'oj ti vinique, ja' ti ichop yu'un ti jchop o abtel ti laj spasique. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","C'alal icoltaatic batel ti Pedroe xchi'uc ti Juane ba sc'oponic ti quermanotique. Scotol laj xcholbe ya'yic ti c'usi i'albatic yu'un ti paleetique xchi'uc ti moletique. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","C'alal laj ya'yic, lic sc'oponic Dios: ―Cajval, ho'ot Diosot, ho'ot laj apas ti vinajele, ti balumile, ti nabe, xchi'uc scotol ti c'utic oye. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ho'ot laj ach'amumbe ye ti Davide, ja' ti j'alc'op avu'une. Ti sventa ti Espíritu avu'une, hech laj sts'iba ti Davide ti vo'one: Hovil ti chlic stoy sbaique ti yanlum crixchanoetique. Hovil ti c'usi chlic snopic ti yo'ntonic ti jchi'iltique. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ja' co'ol chc'ot sc'opic ti ajvaliletique xchi'uc ti totiletique. Jtos yo'ntonic chlic scontrainic ti Jtotic Diose xchi'uc ti much'u t'ujbil yu'une, ja' ti Cristoe, xchi ti Davide. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Melel li' ti jteclum li'to co'ol ic'ot sc'opic ti Herodese xchi'uc ti Poncio Pilatoe xchi'uc yan yanlum viniquetic xchi'uc ti jchi'iltaque yu'un ti tsmilic ti Anich'one, ja' ti Jesuse. Mu'yuc smul ti Anich'one, ja' yich'oj yabtel avu'un. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ja' no'ox laj spasbeic ti Jesuse ti c'usi sc'an ti avo'ntone, ja' ti c'usi chapal ti avo'ntone ti vo'onee ti tspasbate. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tana, Cajval, laj xa ava'i ti chispajesuntutique, ho'ontutic ti avabatuntutique. Ac'buntutic stsatsal co'ntontutic. Hech mu xixi' ti jcholtutic ac'op. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ac'o ti q'uelel ti jelaven ap'ijile, ac'o coluc jchameletic. Ac'o pasuc jchop o abteletic ti sventa ti Anich'one, ja' ti toj yo'ntone, ja' ti Jesuse ―xchiic ti stojol ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","C'alal laj yo'ntonic laj sc'oponic Dios, inic laj ya'yic yo' bu stsoboj sbaique. Scotolic inoj ti yo'ntonic ti Ch'ul Espíritue. Hech itsatsub yo'ntonic, hech jamal laj xcholbeic ti sc'op ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ti c'u yepal ti xch'unojique, jtos yo'ntonic. Mu'yuc much'u laj yal: “Ja' cu'un li'to”, muc xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ti jcholc'opetique ja' no'ox laj xcholilambeic sc'opilal ti Jesuse ti icha'cuxi loq'uel ti ch'ene. Oy yip ti sc'opique ti ic'ot ti yo'ntonic ti jch'unojeletique. Hech i'an stsatsal yo'ntonic scotolic. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mi junuc mu'yuc much'u me'on yu'un scotol ti much'utic oy sbalumilic, mi snaic, c'unc'un lic xchonic. Yu'un jujun lic yich'beic tal stojol. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","C'ot yac'beic ti jcholc'opetique. C'alal mi ilaj staq'uin ti much'u me'onetique, lic ac'batuc yu'un ti jcholc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Te oy jun vinic, José sbi. Ja' Bernabé sbi c'otem yu'un ti jcholc'opetique. Ja' chismuc'ubtasbucutic co'ntontic, xchi sjam ti sbie c'alal jelavesbil. Ja' yelnich'on Leví ti Bernabee. Chipre sbi ti slumale. ");
INSERT INTO tzoNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Oy sbalumil laj xchon. Laj yich'be tal stojol ti sbalumile. C'ot yac'be ti jcholc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Oy jun vinic, Ananías sbi. Safira sbi ti yajnile. Ba xchon jtuch' sbalumil. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Hech yu'un hech laj snopic xchi'uc ti yajnile ti mu ts'acaluc chaq'uic ti stojol ti sbalumile. Hech yu'un mu scotoluc laj yich' tal ti Ananíase ti tal yac'be ti jcholc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ti Pedroe hech laj sjac'be: ―Ananías, ¿c'u yu'un laj avac' sbolibtasbot avo'nton ti Satanase, hech yu'un laj anop c'op ti stojol ti Ch'ul Espíritue? ¿C'u yu'un ti mu ts'acaluc chavac' ti stojol ti abalumile? ");
INSERT INTO tzoNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ja' avu'un atuc ti abalumile. Mu persauc ti chachone. C'alal laj achon ja' aventa atuc ti bu chavac'be ti stojole. ¿C'u yu'un hech laj anop ti avo'nton ti laj ach'ac ti stojol ti abalumile? Ma'uc laj anop c'op ti stojol crixchanoetic. Ja' laj anop c'op ti stojol ti Diose ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","C'alal laj ya'i ti Ananíase ti hech i'albat yu'un ti Pedroe, ip'aj ti lum, te icham. Toj xi'el ic'otic scotol ti much'utic laj ya'yic ti hech ichame. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Iliquic ti unen viniquetique. Laj xpixbeic sbec'tal. Laj sq'uechic batel, ba smuquic. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","I'ech' oxib ora, ital uc ti yajnil ti Ananíase. Mu to ya'yojuc ti icham xa ti smalale. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ti Pedroe hech laj sjac'be: ―Albun xca'i ¿mi ja' no'ox hech stojol ti abalumile ti laj achonique? ―xchi. ―Ja' no'ox hech ―xchi xtac'av ti antse. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ti Pedroe hech laj yalbe: ―¿C'u yu'un co'ol laj achapan ac'opic xchi'uc ti amalale ti cha'ech'ic ti stojol ti Espíritu yu'un ti Cajvaltique? A'yo me ava'i, xlomlajanic xtal yacanic ti patna ti much'utic ba smuc ti amalale. Ja' no'ox hech chasq'uechot batel uc ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ti ora ip'aj ti lum ti stojol ti Pedroe ti Safirae, te icham. C'alal isutic tal ti unen viniquetique, chamen xa hul staic ti Safirae. Hech yu'un laj sq'uechic batel uc. Te ba smuquic ti bu nopol mucul ti smalale. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Toj xi'el ic'otic scotol ti jch'unojeletique xchi'uc scotol ti much'utic laj ya'ibeic sc'opilale. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ti sventa ti Diose ihu' yu'unic ti jcholc'opetique ep ti tos jchop o abteletique. Laj spasic ti stojol ti crixchanoetique. Scotol c'ac'al laj stsob sbaic te ti templo ti bu scorerol Salomón. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mi junuc mu'yuc much'u icontrainvan yu'un scotolic lec laj yilic ti c'utic laj spas ti jcholc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Scotol c'ac'al i'epajic ti much'utic laj xch'unic ti ja' Jcoltavanej yu'unic ti Cajvaltique. Ep viniquetic ep antsetic laj xch'unic. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Scotol ti jchameletique laj sloq'uesic tal. Tal yaq'uic ti calle xchi'uc ti svayebique xchi'uc ti spopique yu'un tsc'anic mi ch-ech' coltaatuc yu'un ti Pedroe. Repenta mi mu xpaj ti Pedroe, hech laj snopic mi ta yutsil chchop yu'un mi ch-ech' snac'omal ti sba ti jchameletique. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ep italic ti yan jteclumetic ti nopol xil sbaic xchi'uc Jerusalén. Ic'otic ti Jerusalén. Laj yiq'uic talel jchameletic xchi'uc ti much'utic ch-ilbajinat yu'un ti pucujetic ti te ochem ti yo'ntonique. Scotolic ichopic, iloc' ti pucuj ti yo'ntonique. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Hech yu'un lic spas biq'uit yo'nton ti totil palee xchi'uc scotol ti much'utic xchi'inoje. Ja' ti saduceoetique ti te xchi'inojique. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Laj stsaquic ti jcholc'opetique. Laj stiq'uic ti chuquel te ti cabildo. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ti ac'ubal ital xch'ul abat ti Cajvaltique. C'ot sjam ti ti'chuquele. Laj yic' loq'uel tal ti jcholc'opetique. Hech laj yalbe batel: ");
INSERT INTO tzoNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Batanic, ba va'ano abaic ti yut templo li' ti jteclume. Albo ya'yic ti achi'iltaque scotol sc'opilal ti ach' cuxlejale ti ja' ti sventa ti Jesuse ―x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yu'un hech i'albatic hech yu'un c'alal isacub ti osile i'ochic ti yut templo. C'ot chanubtasvanuc. Patil laj stsob sbaic te ti templo ti totil palee xchi'uc ti saduceoetique. Hech yu'un scotol laj yic' ti totiletique ti yu'un ti temploe xchi'uc uc ti más moletique ti xchi'iltaque. Hech yu'un laj staquic batel ti jchabiejtemplo yu'unique yu'un ac'o ba yiq'uic loq'uel tal ti chuquel te ti cabildo ti jcholc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","C'alal ic'otic ti jchabiejtemploe mu'yuc xa te tiq'uil ti chuquel c'ot staic. Hech isutic tal. Hech hul yalbeic: ");
INSERT INTO tzoNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","―Lec macbil c'o jtatutic ti chuquele. Te va'ajtic ti ti'chuquel ti jchabiejchuqueletique. C'alal laj jamtutic ti chuquele, mi junuc mu'yuc xa much'u te o. Melel ti c'usi chacalbeique ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","C'alal laj ya'yic ti totil ti chchabi ti temploe xchi'uc ti totil paleetique, toj xi'el ic'otic. Ep ilo'laj yo'ntonic yu'un ti hech ic'ot ti pasele. Ixi'ic uc mi oy c'usi chc'ot ti pasel yan. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Oy much'u c'ot albatuc yu'un: ―Ti viniquetique ti laj atiq'uic ti chuquele, te oyic xa ti yut templo. Te yac'oj sba chchanubtasvanic ―x'utatic c'otel. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Hech yu'un ibatic ti ora ti totil ti chchabi ti temploe xchi'uc ti svinictaque. Lec laj yiq'uic tal ti jcholc'opetique muc smajic yu'un ixi'ic yu'un mi ch-ac'batic ton yu'un ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Hech i'ic'atic talel ti jcholc'opetique. C'ot va'anatuc ti stojol ti totiletique yu'un ti temploe ti bu stsoboj sbaique. Ti totil palee hech lic yalbe: ");
INSERT INTO tzoNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Tsots laj jpasoxuc ti mantal. Mu me xachanubtasvanic xa ti sventa ti Jesuse, xacutic. Q'uelo avil, puquem xa avu'unic ti scotol jteclum li'to ti c'usi chavac' ti a'yele. Chacuchinuntutic ti ho'ontutic laj jmiltutic ti vinic chavale ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Itac'av ti Pedroe xchi'uc ti yan jcholc'opetique: ―Persa ti ja' jbael ti jch'umbetutic smantal ti Diose. Ma'uc jbael ti jch'umbetutic smantal viniquetic. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ho'oxuc laj amilic ti Jesuse, laj ajipanic ti cruz. Ti Dios yu'un ti antiguo jtotique ja' laj xcha'cuses loq'uel ti ch'en. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ipasat xa ti muc' ti Jesuse, inacanat xa ti bu ti sbats'ic'ob ti Diose. Ja' Ajvalil ic'ot xa yu'un scotol crixchanoetic. Ja' Jcoltavanej cu'untic jcotoltic ic'ot xa. Ja' chisutesbucutic co'ntontic yu'un jmultic ho'ucutic ti israelucutique. Ja' chixch'aybucutic jmultic uc. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ho'ontutic ti jcholtutic ti hech laj xa yac'be yabtel ti Jesuse ti Diose. Ja' chchol uc ti Ch'ul Espíritue. Yich'ojic xa ti Ch'ul Espíritue scotol ti much'utic xch'unojbeic sc'op ti Cajvaltique. Ja' ac'bilic yu'un ti Diose ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","C'alal laj ya'yic ti hech laj yal ti jcholc'opetique, xtec'tun no'ox i'ilinic. I'albat smilelic. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Hech yu'un laj sva'an sba jun fariseo. Ja' te xchi'uc ti naclej xchi'uc ti yan totiletique. Gamaliel sbi. Ja' jchanubtasvanej yu'un ti mantaletique ti tscuy sbae. Ja' pasbil ti muc' yu'un scotol ti xchi'iltaque. Ja' laj yal mantal ti ac'o loc'uc j'oc'uc ti jcholc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Hech lic yalbe scotol ti totiletic ti te xchi'uque: ―Totetac, ho'ucutic ti israelucutique, persa lec ti jnoptic c'usi chcutic ti viniquetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yu'un vo'one ital jun vinic, Teudas sbi. C'an pasbatuc ti muc' ti sc'ope. Oy chanib ciento svinictac its'aclinat. Ja' milbil icham ti Teudase. Scotol ipuc batel ti svinictaque. Hech itup' o. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Patil ital yan vinic, Judas sbi. Ja' liquem tal ti Galilea. Ital ti yorail laj spas censo ti ajvalile. Ep ti much'utic ich'umbat ti sc'ope ja' its'aclinat. Milbil icham uc. Scotol ipuc batel ti much'utic laj sts'acliique. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hech yu'un chacalbeic. Avi viniquetic li'to mu me jpajestic. Ac'o spasic ti c'usi tsc'an ti yo'ntonique. Mi sventa no'ox viniquetic ti c'usi snopojique xchi'uc ti yabtelique hech no'ox chtup'. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mi sventa ti Diose mu xtup'. Hech yu'un mu me jpajestic naca me jcontraintic ti Diose ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Hech laj xch'umbeic sc'op ti Gamaliele. Laj yiq'uic ochel ti jcholc'opetique. Laj yac'beic majel. Patil laj spasic ti mantal: ―Mu me xacholbeic yan sc'opilal ti Jesuse ―x'utatic. Hech icoltaatic batel. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ti jcholc'opetique hech iloq'uic batel ti stojol ti totiletique te ti yo' bu stsoboj sbaique. C'alal ibatic nichim no'ox yo'ntonic yu'un laj sna'ic ti t'ujbilic yu'un ti Diose yu'un chich'ic vocol ti sventa ti Cajvaltique. ");
INSERT INTO tzoNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Muc xpajic. Scotol c'ac'al ichanubtasvanic. Laj xcholilambeic sc'opilal ti Jesucristoe te ti templo xchi'uc ti naetic. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","C'alal i'epaj ti jch'unojeletique, ti judioetique ti xchanojic griego c'ope chopol laj xcholbe sc'opilal ti xchi'ile ti ja' no'ox chc'opoj ti hebreo c'ope, ja' ti sbats'ic'opique. Laj yalic ti muc xc'uxubinatic ti me'on antsetic yu'unique c'alal oy c'usi ch-ac'batic ti sventa jujun c'ac'al. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ti lajchavo'ique laj stsobic tal scotol ti jch'unojeletique. Hech laj yalbeic: ―Ti ho'ontutique mu lecuc mi muc ti jcholtutic ti sc'op ti Diose. Mi ja' no'ox chimac'linvantutic, mu lecuc obi. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hech yu'un, quermanotac, ja' lec chat'ujic hucvo' viniquetic ti much'utic lec sc'opilalique, ti much'u nojem ti yo'ntonic ti Ch'ul Espíritue, ti much'u oy sp'ijil yo'ntonique. Ja' chcac'betic yabtelic. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ti ho'ontutique ja' cabteltutic ti jc'opontutic Dios, ti jcholtutic ti sc'op ti Diose ―xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Scotolic lec laj ya'yic ti hech i'albatique. Hech yu'un laj st'ujic jun vinic, Esteban sbi. Oy lec xch'unojel yo'nton. Nojem ti yo'nton ti Ch'ul Espíritue. Laj st'ujic yan vacvo' uc. Ja' hech sbiic: Felipe xchi'uc Prócoro xchi'uc Nicanor xchi'uc Timón xchi'uc Parmenas xchi'uc Nicolás. Ja' liquem tal ti Antioquía ti Nicolase. Co'ol yanlum vinicucutic xchi'uc ti Nicolase. Ja' co'ol xch'unoj ono'ox hech chaj c'u che'el ti judioetique ti Nicolase. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ti much'utic it'ujatique c'ot va'anatuc ti stojol ti jcholc'opetique. Ti jcholc'opetique laj sc'opombeic Dios ti stojolic. Hech lic yac' sc'obic ti jcholc'opetique laj yac'be ti sjolic jujun. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ipuc sc'op ti Cajvaltique. Lec i'epaj ti jch'unojeletique ti te nacajtic ti Jerusalene. Oy ep paleetic laj xch'unic uc ti ja' Jcoltavanej yu'unic ti Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ti Estebane i'ac'bat ep yutsil yo'nton, i'ac'bat ep sp'ijil. Hech ihu' yu'un laj spas muc'ta jchop o abteletic ti stojol ti crixchanoetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Te oyic ti xchi'iltaque ti liquemic tal ti templo ja' ti bu tstsob sbaic ti much'utic icolic ti mozoile. Talemic uc ti xchi'iltaque te ti templo te ti jteclum Cirene sbi xchi'uc ti jteclum Alejandría sbi xchi'uc ti estado Cilicia xchi'uc ti slumal Asia. Ja' lic stsaquic ti c'op ti Estebane. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lec itac'av ti Estebane yu'un oy sp'ijil yo'nton yu'un oy ti yo'nton ti Ch'ul Espíritue. Tsalbilic ic'ot yu'un. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hech yu'un laj stojic cha'vo' oxvo' viniquetic yu'un chopol ac'o xcholbeic sc'opilal ti Estebane. Laj xchanubtas ti yajnopc'opetique ti c'usi chalique. ―Hech me xavalic ―xchiic―. Laj ca'ibetutic sc'op. Ja' chopol ic'opoj yu'un ti Moisese. Ja' chopol ic'opoj uc yu'un ti Diose, xachiic me ―x'utatic. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Laj yac'beic c'op ti crixchanoetique xchi'uc ti moletique xchi'uc ti much'utic chchanubtasvan ti smantal ti Diose ti scuyoj sbaique. Hech yu'un mucul italic. Tal stsaquic ti Estebane. Laj yiq'uic tal yu'un tal sva'anic ti stojol ti totiletic yu'unique ti bu stsoboj sbaique. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Laj yiq'uic tal ti jnopc'opetic yu'unique. Hech lic snopbeic smul ti Estebane: ―Ja' ti vinic li'to mu spajes ye. Chopol chc'opoj yu'un ti ch'ul templo li'to. Chopol chc'opoj yu'un ti mantaletique. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Hech laj ca'ibetutic sc'op: “Ti Jesuse, ja' ti ilic tal ti Nazarete, ja' tsjin avi templo li'to. Tsjel ti mantaletique ti quich'ojtic yu'un ti Moisese”, xchi ti vinic avi to ―xchiic. Ja' sc'opilal ti Estebane. ");
INSERT INTO tzoNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Te nacajtic scotol ti totiletique. C'alal laj sq'uelbeic sat ti Estebane sat xch'ul abat Dios x'elan ti sat ti Estebane laj yilic. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ti totil palee hech laj sjac'be ti Estebane: ―¿Mi melel ti c'usi chalique? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Hech itac'av ti Estebane: ―Totetac, a'yo me ava'yic ti c'usi chacalboxuque. Ti Diose, ja' ti much'u oy squevale, laj yac' sba ti q'uelel ti stojol ti jtatamoltic Abrahame c'alal te oy ti slumal Mesopotamia c'alal mu to chc'ot ti jteclum Harán. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ti Diose hech laj yalbe ti Abrahame: “Loc'an batel ti alumal, comeso atot ame' xchi'uc avermanotac, batan ti yan balumil. Chacac'bot avil ti abalumile”, xchi. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hech ti Abrahame iloc' batel te ti slumal ti caldeaetique, c'ot nacluc ti Harán. C'alal icham ti stot ti Abrahame, ipasat ti mantal yan vuelta yu'un ti Diose. Itacat talel li'to. Hech ihul li' ti jlumaltique li'to. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ti Diose muc xac'be yich' ti ora avi balumil li'to. Mi jtuch'uc muc xac'be yich' ti Abrahame. Yu'un ti te inaqui ti Abrahame, laj no'ox xch'amun ti balumile ti Abrahame. Ja' no'ox icaj'albat yu'un ti Diose ti ch-ac'bat yich' comel xchi'uc ti yol snich'one. C'alal hech laj yal ti Diose, mu to oyuc snich'on ti Abrahame. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Icaj'albat uc yu'un ti Diose ti q'uejel chbat nacluc ti yan balumil ti yol snich'one. Chanib ciento habil chbat ochuc ti mozoil, te chich'ic ilbajinel. Ch-abtejic, mi jutuc mu xtojatic. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ti Diose hech laj yalbe ti Abrahame: “Ho'oni chcac'be castigo ti much'u chmozoinvane. Patil chloq'uic talel ti avol anich'onique. Ja'to chul spasucun ti muc' li'to”, xchi ti Diose, x'utat ti Abrahame. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ti Diose laj xchapan xchi'uc ti Abrahame ti tsots sc'opilal ti circuncisione. Hech yu'un ti c'alal inich'naj ti Abrahame, c'alal iloc' vaxaquib c'ac'al yanel ti Isaaque, ja' ti snich'one, laj yac'be yich' circuncisión. Ti Isaaque inich'naj uc. Jacob sbi ti snich'one. Ti Jacobe inich'naj uc. Ja' xnich'nab ti lajchavo' jtatamoltique ti vo'one. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Yu'un laj spas biq'uit yo'ntonic ti jtatamoltique, hech laj yilintaic ti Josee. Hech laj xchonic batel ti Egipto. Ti Josee ichi'inat batel yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","C'alal laj yich' ilbajinel ti Josee icoltaat yu'un ti Diose. Ti Diose laj yac'be sp'ijil yo'nton ti Josee hech lec i'ilat yu'un ti Faraone, ja' ti ajvalil yu'un ti egiptoetique. Hech yu'un ti Josee itic'at ti gobernador te ti Egipto. Hech yu'un laj spas mantal ti scotol slumal Egipto. I'ac'bat yabtel uc yu'un tsventain scotol te ti sna ti ajvalile. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Patil ital vi'nal ti scotol slumal Egipto xchi'uc ti slumal Canaán. Ep laj yich'ic vocol scotolic. Ti jtatamoltique muc sta sve'elic. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Laj ya'i ti Jacobe ti oy trigo te ti Egipto. Hech yu'un laj stac batel ti jtatamoltique. Ja' sba vuelta itacatic batel. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","C'alal ibatic ti xchibal vuelta, ti Josee laj yac' sba ti ojtiquinel ti stojol ti sbanquiltaque. Ti Faraone hech laj yojtiquimbe ti yermanotac ti Josee. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Hech yu'un ti Josee lic yic' tal ti stote, ja' ti Jacobe, xchi'uc scotol ti yermanotaque. Setenta y cinco ti vo' ti yermanotaque ti i'ochic ti Egiptoe. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Hech ic'ot ti Egipto ti Jacobe. Te icham. Te icham uc ti jtatamoltique ti vo'one. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Laj yich'beic tal sbaquel scotolic yu'un mi junuc muc xcom sbaquelic ti Egipto. Li' hul stiq'uic ti pujul ch'en li' ti Siquem yo' bu oy ti balumile ti mambil yu'un ti Abrahame ti ja' ono'ox smanojbe ti yol snich'on ti Hamore, ti li' nacajtic ti Siqueme. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’C'alal po'ot xa tsta yorail chich'ic ti balumile hech chaj c'u che'el laj yalbe ti Abrahame ti Diose, epajemic xa ti jtatamoltique te ti Egipto. Ep p'olemic. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Te ti Egipto i'och yan ajvalil. Muc xojtiquin ti Josee. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ilo'lavan ti ach' ajvalile. Laj yilbajin ti jtatamoltique. Laj yalbe ti ac'o stenic loq'uel ti squeremique. Yu'un ti hech laj yal ti ajvalile yu'un mu laj sc'an ti chp'olic ti jtatamoltique. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Hech yorail i'an ti Moisese. Ti Diose lec laj yil ti Moisese. Oxib u te oy ti sna ti stote ti Moisese. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","C'alal itenat loq'uel ti Moisese, i'ic'at yu'un ti stseb ti ajvalile. Ja' laj yolin, laj xch'ites. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Lec ichanubtasat ti Moisese. Scotol laj xchambe sp'ijil yo'ntonic ti egiptoetique. Oy ep yip ti c'usi laj yale. Ep lequil abtel laj spas ti Moisese. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’C'alal yich'oj xa cha'vinic habil ti Moisese, sc'an sc'opon ti yermanotaque, ja' ti jtatamoltique. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Laj yil ti chlaj ti ilbajinel jun xchi'il, hech ba scolta. Hech ba smil ti much'u ch-ilbajinvane yu'un chc'uxubin ti xchi'ile. Ja' egipto vinic ti ch-ilbajinvane. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Laj scuy ti Moisese ti chna'at yu'un ti yermanotaque ti ja' Jcoltavanej yu'unic c'otem yu'un ti Diose. Muc sna'ic. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yan vuelta ti yoc'omal oy much'u yac'oj sba chut sbaic laj sta ti Moisese. Muc xilic ti ital ti Moisese. Ti Moisese sc'an spajes. Hech laj yalbe: “Quere, ¿c'u yu'un chavut abaic? Avermano abaic”, xut. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ti much'u ch-utvane, ja' laj sjim batel ti Moisese. Hech laj yalbe: “¿Much'u laj yac'bot avabtel? Mu ho'ucot ajvalilot cu'untutic. Mu ho'ucot juezot cu'untutic. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Yu'un chac'an chamilun hech chaj c'u che'el laj amil ti egipto vinic volje”, x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","C'alal laj ya'i ti Moisese ti ivinaj xa ti laj smil ti egipto vinique, ijatav ti Moisese. Laj scomes ti Egiptoe. Te ba nacluc ep habil ti yan balumil, Madián sbi. Te laj sta yajnil. Te i'an cha'vo' snich'on. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’I'ech' cha'vinic habil. Patil i'ay ti vits Sinaí ti Moisese. Ja' te oy ti xocol balumil ti vitse. Te laj yil ivinaj ch'ul abat yo' bu itil jtec biq'uit ch'ix. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ich'ay yo'nton ti Moisese c'alal laj yile. Inopej batel sq'uel. Iya'i ic'opoj ti Cajvaltique. Hech i'albat: ");
INSERT INTO tzoNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ho'on Diosun yu'un ti antiguo atotique, ja' ti Abrahame xchi'uc ti Isaaque xchi'uc ti Jacobe”, xchi ti Cajvaltique. Ixi' ti Moisese. Mu xa sc'an sq'uel yan vuelta. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ti Cajvaltique hech laj yalbe: “Loq'ueso asempat yu'un li' va'alot ti jtojol, ho'on ti Diosune”, x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","“Laj xa quil ti ep chich'ic ilbajinel te ti Egipto ti avermanotaque, ja' ti co'ol t'ujbiloxuc cu'une. Laj xa ca'i ti ch-aquinaje. Hech yu'un niyal tal yu'un tal jcolta. Hech yu'un batic te ti Egipto”, x'utat yu'un ti Cajvaltique. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Ja' ono'ox ti Moisese ti muc spasic ti muq'ue, ti hech i'albate: “¿Much'u laj yac'bot avabtel? Mu ho'ucot ajvalilot cu'untutic. Mu ho'ucot juezot cu'untutic”, ti xutic ono'oxe. Ja' itacat batel yu'un ti Diose yu'un ch-och ti ajvalil yu'unic, yu'un jcoltavanej chc'ot yu'unic. Ja' itacvan batel ti ch'ul abate ti ivinaj te ti jtec biq'uit ch'ix laj yil ti Moisese. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Oy jchop o abteletic xchi'uc señailetic laj spas ti Moisese te ti Egipto, hech itsobatic loq'uel tal te ti Egipto ti jtatamoltique yu'un ti Moisese. Patil laj spas jchop o abtel uc te ti Tsajal Nabe. Patil cha'vinic habil laj spas jchop o abteletic xchi'uc señailetic uc te ti xocol balumil. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ja' ono'ox ti Moisese ti laj yalbe ti jtatamoltique: “Ti Diose chist'ujbucutic j'alc'op. Chic' jun quermanotic hech chaj c'u che'el laj yic'un. Ta me jpasbetic ti muc' ti sc'ope”, ti xchi ono'ox ti Moisese. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ja' ono'ox ti Moisese ti i'ay ti xocol balumil xchi'uc scotol ti jtatamoltique. Ti jtatamoltique laj stsob sbaic te ti vits Sinaí. Ti ch'ul abate te laj sc'opon ti Moisese. Ti Moisese hech lic yalbe ti jtatamoltique ti c'u che'el i'albat yu'un ti ch'ul abate. Ja' laj yalbe ti c'u che'el chcuxiic sbatel osile. Hech yu'un ja' ti sventa ti Moisese ti ca'yojtic ti ora to ti ho'ucutique. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Ti jtatamoltique muc sc'an xch'umbeic sc'op ti Moisese. Muc spasic ti muc'. Sc'an sutic batel ti Egipto. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Hech lic yalbeic ti Aarone: “Pasbuntutic cajsantotutic yu'un ja' chbaej batel cu'untutic. Mu jna'tutic c'usi laj spas ti Moisese ihalej ti vits, ja' ti laj sloq'uesuntutic tal ti Egiptoe”, xchiic. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Hech lic spasic yajsantoic. Ja' sloc'tombail vacax. Laj smilbeic smoton ti yajsantoe. Nichim no'ox yo'ntonic yu'un ti c'usi pasbil ti sc'obique. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Hech yu'un icomesatic yu'un ti Diose. Ti Diose laj yac'be squejan sbaic ti stojol ti c'utic xleblajet ti vinajele hech chaj c'u che'el ts'ibabil comel ti sun ti j'alc'opetic yu'un ti Diose: Israeletic, ti c'alal laj avac'bucun jmoton chacuyique ti vacaxe ti carneroe c'alal naxanavic batel ti xocol balumil cha'vinic habil, hovil ti laj avac'bune yu'un mu junuc avo'ntonic ti jtojol. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ja' laj avich'ic batel ti santo Moloc sbi tiq'uil ti sna pasbil ti nucul. Laj avich'ic batel uc ti sc'anal ti avajsantoe, ja' ti Renfán sbie. Ja' pasbil avu'unic yu'un chach'unic. Hech yu'un chajtenoxuc loq'uel ti alumalic. Chabatic ti yech'el slumal Babilonia, x'utatic yu'un ti Diose c'alal i'ochic xa ti Canaane. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’C'alal i'ay ti xocol balumil ti jtatamoltique, ja' itun yu'un ti templo-nucule yu'un ja' te chc'oponat yu'un ti Diose. Ja' laj spasic hech chaj c'u che'el laj yal mantal ti Diose. Ja' hech chaj c'u che'el ti i'ac'bat yil ti señail ti Moisese. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ti jtatamoltique c'alal i'ic'atic ochel tal li'i yu'un ti Josuee, laj yich'ic tal uc ti templo-nucule. Ja' ti yorail ti tal yich'ic ti slumique, ti yorail uc ti lic tembatuc loq'uel ti yajval ti slumique yu'un ti Diose. Ja'to c'alal i'ay ti balumil ti Davide, ja'to chtun yu'unic ti templo-nucule. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ti Diose lec laj yil ti Davide. Ti Davide laj yalbe vocol ti Diose ac'o ac'batuc lisensa yu'un tspasbe sna ti Diose, ja' ti Dios yu'un ti jtatamoltic Jacobe. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Muc spas ti Davide, ja' lic spas ti snich'one, ja' ti Salomone. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Muc' ti Diose. Mu yu'unuc chnaqui ti naetic ti pasbil ti sc'ob viniquetic. Te nacal ti vinajel. Ja' laj xch'amumbe ye jun j'alc'op, hech laj yal: ");
INSERT INTO tzoNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ho'on li' ti jpas mantal li' ti vinajel xchi'uc ti sjoylejal balumil. ¡Bu c'amba apasbun jna! Mu yu'unuc ti jcux co'nton. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ho'on laj jpas scotol ti c'utic oye, xchi ti Diose, xchi ti j'alc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Ti ho'oxuque tsots avo'ntonic. Mu ventaimbiluc yu'un ti Diose ti avo'ntonique ti achiquinique. Scotol ora chacontrainic ti Ch'ul Espíritue. Ja' no'ox hech chapasic uc hech chaj c'u che'el laj spasic ti jtatamoltique ti vo'one. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ti jtatamoltique laj scontrainic scotol ti j'alc'opetic yu'un ti Diose. Laj smilic ti much'utic jbael laj yalbeic sc'opilal ti chtal ti much'u toj yo'ntone, ja' ti much'u laj avaq'uic entrecale, ti laj amilique. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Manchuc mi ti sventa ch'ul abatetic laj quich'tic ti mantaletique, mu xach'unic ti ho'oxuque ―x'utatic yu'un ti Estebane. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","C'alal laj ya'yic ti hech laj yal ti Estebane, xtec'lajan no'ox i'ilinic. Xjep'et no'ox yeic yu'un chilintaic. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ti Estebane nojem ti yo'nton ti Ch'ul Espíritue. Laj sq'uel muel vinajel. Laj yilbe squeval ti Diose. Laj yil uc ti Jesuse, te oy ti sbats'ic'ob ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Hech laj yal ti Estebane: ―Jamal vinajel chquil. Te oy ti sbats'ic'ob ti Diose ti Jesuse ti co'ol hech chaj c'u che'el ho'ucutic ic'ot ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hech yu'un tsots i'avanic ti xchi'iltaque. Laj smac xchiquinic yu'un tscuyic ti mu xtun cha'i ti Diose ti c'u che'el chc'opoj ti Estebane. Hech yu'un ti comón lic stsaquic ti Estebane. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Hech laj yiq'uic loq'uel ti ti'jteclum. Te c'ot yac'beic ton. Ti much'utic laj yac'beic ti tone laj spochan xchijic ti lum ti stojol jun unen vinic, Saulo sbi. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","C'alal laj yich' ton ti Estebane, hech laj sc'opon ti Diose: ―Cajval Jesús, ic'bun me jch'ulel ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Quejel ic'ot ti lum, tsots ic'opoj. Hech laj yalbe ti Diose: ―Cajval, mu me xavac'be xcuch ti smulique ti laj staic avi to ―xchi. C'alal hech laj yal ti Estebane, icham. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ti Sauloe nichim no'ox yo'nton c'alal laj yil ti icham ti Estebane. Hech yu'un ti ora no'ox lic ilbajinatuc scotol ti jch'unojeletique ti laj stsob sbaique te ti Jerusalén. Scotolic hech ipuquic batel ti scotol estado Judea xchi'uc ti estado Samaria. Ja' no'ox icomic ti Jerusalén ti jcholc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ti much'utic toyol yo'ntonic tsc'an chch'umbeic smantal ti Diose, ja' laj yich'beic batel sbec'tal ti Estebane, ba smuquic. Ep laj yoc'taic. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Hech yu'un ti Sauloe sc'an ti chtup' scotol ti jch'unojeletique. Hech yu'un i'och ti na. Laj stsac loq'uel tal viniquetic xchi'uc antsetic. Laj stic' ti chuquel. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Scotolic ti much'utic ti buc no'ox ipuquic batele, laj xcholic ti lequil ach' c'ope. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Hech ti Felipee ic'ot ti muc'ta jteclum te ti slumal Samaria. Te c'ot yalbe ti crixchanoetique: ―Ital xa ti Jcoltavanej cu'untique, ja' ti Jesuse ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Scotol ti crixchanoetique ti te oyic ti jteclum lume c'alal laj sq'uelic ti jchop o abteletique ti laj spas ti Felipee, hech yu'un scotolic toyol yo'ntonic laj ya'ibeic sc'op. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Yu'un ep ti much'utic oy pucujetic ti yo'ntonique, i'avan loc' tal ti yo'ntonic ti pucujetique. Ep icolic mecanetic xchi'uc ti much'utic sicuben ti yacanique. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Hech yu'un nichim no'ox yo'ntonic scotolic te ti jteclum lume. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Te oy jun vinic, Simón sbi. Ja' jpicch'ich' ono'ox ti Simone. Ep laj slo'la ti samariaetique yu'un stuc laj yal ti oy yip ti sc'ope. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ti much'utic tsots yabtel yich'ojique xchi'uc ti much'utic mu'yuc yabtelique, scotolic laj spasbeic ti muc' ti sc'ope. Hech laj yalic: ―Ja' yich'ojbe yip ti Diose avi to ―xchiic. Ja' sc'opilal ti Simone. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","J'ech'el laj spasbeic ti muc' ti sc'ope scoj ti ep c'ac'al ilo'laatic yu'un ti jpicch'ich'e. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ti Felipee laj xcholbe ya'yic ti lequil ach' c'ope, ja' ti tsc'an chventaimbat yo'ntonic yu'un ti Diose. Laj xcholbe ya'yic uc sc'opilal ti Jesucristoe. Ep viniquetic, ep antsetic laj xch'umbeic sc'op ti Felipee. Hech i'ac'batic yich' ho' yu'un ti Felipee. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hech uc ti Simone laj xch'un uc. Laj yich' ho', laj xchi'in batel ti Felipee. C'alal laj yil ti muc'ta jchop o abteletique ti laj spas ti Felipee, ich'ay yo'nton ti Simone. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ti jcholc'opetique ti te oyic ti Jerusalene, laj ya'yic ti laj spasbeic ti muc' ti sc'op ti Diose ti samariaetique. Hech yu'un laj staquic batel ti Samaria ti Pedroe xchi'uc ti Juane. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","C'alal ic'otic ti xcha'va'alique, laj sc'opombeic Dios ti stojol ti samariaetique ti ac'o ac'batuc yich'ic uc ti Ch'ul Espíritue. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Yu'un mu to oyuc ti yo'ntonic ti Ch'ul Espíritue. Ja' no'ox yich'ojic ho' ti sventa ti Cajvaltic Jesuse. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Hech yu'un ti jcholc'opetique laj yac' sc'obic, laj yac'be ti sjolic ti jch'unojeletique. Hech i'ac'batic yich'ic ti Ch'ul Espíritue. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ti Simone laj yil ti laj yac' sc'obic ti jcholc'opetique. Laj yac'be ti sjol ti jch'unojeletique. Hech laj yich'ic ti Ch'ul Espíritue. Hech yu'un ti Simone sc'an chac'be taq'uin ti jcholc'opetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Hech laj yalbe: ―Ac'bun cabtel uc yu'un chcac'be yich' ti Ch'ul Espíritue scotol ti much'utic chcac' jc'ob ti sjolic ―xchi ti Simone. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ti Pedroe hech laj yalbe: ―Co'ol ch'ayan xchi'uc ti ataq'uine yu'un chacuy ti oy ti manel ti Ch'ul Espíritue ti chijyac'bucutic ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ti ho'ote mu stac' xa'abtej yu'un. Ma'uc aventa li'to yu'un mu tojuc avo'nton ti stojol ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Suteso avo'nton yu'un amul. Albo vocol ti Diose yu'un hech chaxch'aybot amul yu'un anopoj mulil ti avo'nton. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yu'un ep chapas biq'uit avo'nton chquil. Chucbil avo'nton yu'un mulil chquil ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Hech itac'av ti Simone: ―C'opombun Dios ti jtojol che'e yu'un mu me xc'ot ti pasel ti ch'ayel chibate hech chaj c'u che'el laj avalbune ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","C'alal laj yo'ntonic laj yalic scotol ti c'utic x'elan ch-abtej ti Diose ti yilojique, c'alal laj yo'ntonic laj xcholbeic ti sc'op ti Diose, hech isutic batel ti Jerusalén ti Pedroe xchi'uc ti Juane. Hech ech' xcholic ti lequil ach' c'ope ti ep jteclumetic te ti slumal ti samariaetique. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","C'alal hech yac'oj sba ch-epaj ti jch'unojeletique te ti Samariae, hech c'ot sc'opon ti Felipee jun xch'ul abat ti Cajvaltique. Hech i'albat ti Felipee: ―Toj chabat lum toi. Te chc'ot ata ti sbelal ti Gazae, ja' ti chloc' tal ti Jerusalene ―x'utat yu'un ti xch'ul abat ti Diose. Ja' xocol balumil ti bu chc'o sta ti bee, ja' ti sbelal Gazae ti Felipee. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Hech yu'un ibat ti Felipee. Laj yil ital jun etiopía vinic. Eunuco ti vinique. Tsots yabtel yich'oj yu'un ti ajvalil yu'un ti etiopíaetique. Ants ti ajvalil yu'unique, Candace sbi. Ti eunucoe i'ac'bat sventain scotol ti sc'ulejal yu'un ti Candacee. Ti eunucoe ay yac'be smoton Dios ti templo ti Jerusalén. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tsut xa batel ti scarreta. Te nacal yac'oj sba tsq'uelbe sun ti Isaíase, ja' ti j'alc'op yu'un ti Diose. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ti Felipee hech i'albat yu'un ti Ch'ul Espíritue: ―Batan, chi'ino batel ti vinique ti te tiq'uil ti scarretae ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Hech yu'un bat snuts ti anil ti carretae ti Felipee. Laj ya'i ti yac'oj sba tsq'uelbe ti sun ti Isaíase, ja' ti j'alc'op yu'un ti Diose. Ti Felipee hech laj sjac'be: ―¿Mi chava'ibe sjam ti c'usi chaq'uele? ―xut. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Hech itac'av ti vinique: ―¡Bu ba c'an ca'ibe sjam yu'un mu'yuc much'u chiyalbun! ―xchi. Hech i'albat vocol ti Felipee: ―Ochan tal, la' chi'inun ti naclej ―xchi ti vinique. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ti bu tsq'uel ti sun ti Diose, ja' ti bu hech chal: Ch-ic'at batel hech chaj c'u che'el carnero ti chmilate. Hech chaj c'u che'el ch'iom carnero ti chtulbat stsotsile, ja' no'ox hech mu xc'opoj uc. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ep ch-ac'bat yich' vocol yu'un mu tojuc chchapaj yu'un. Mu'yuc yol snich'on ti tscuyique yu'un c'alal tsmilique j'ech'el chtup' ti tscuyique, xchi ts'ibabil. Ja' tsq'uel. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ti eunucoe hech laj sjac'be ti Felipee: ―Albun chca'i much'u sc'opilal comen li'to. ¿Mi ja' chchol sc'opilal stuc ti Isaíase? ¿Mi oy yan chcholbe sc'opilal? ―xchi sjac'. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Hech yu'un ti Felipee lic xcholbe ya'i sjam ti ja' sc'opilal ti Jesuse. Hech lic xcholbe ya'i scotol ti lequil ach' c'ope. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ixanavic batel ti be. Ic'otic ti yo' bu oy ho'. Ti eunucoe hech lic yalbe: ―Q'uelo avil, li'oy ho'. ¿Mi xu' chquich' ho' ho'oni? ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Hech itac'av ti Felipee: ―Mi scotol avo'nton ach'unoj, xu' chavich' ho' ―xchi. Ti eunucoe hech laj yalbe: ―Jch'unoj ti ja' Snich'on ti Diose ti Jesucristoe ―xchi. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Laj yal mantal ti ac'o pajuc ti scarretae. Hech i'och batel ti ho' ti eunucoe xchi'uc ti Felipee. Hech i'ac'bat yich' ho' ti eunucoe yu'un ti Felipee. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","C'alal iloq'uic tal ti ho', licbil ibat ti Felipee. Ilicat batel yu'un ti Espíritu yu'un ti Cajvaltique. Ti eunucoe muc xil ibat ti Felipee. Hech yu'un yu'un laj xa xch'umbe sc'op ti Cajvaltique, nichim no'ox yo'nton isut batel ti slumal. ");
INSERT INTO tzoNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","C'alal ilicat batel ti Felipee, ic'ot c'alal ti jteclum Azoto. Hech lic xanavuc batel ti yacan. Ti scotol jteclumetic ech' xchol ti lequil ach' c'ope ja'to c'alal ic'ot ti jteclum Cesarea sbi. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","C'alal hech chchol sc'op Dios ti Felipee, ja' yorail batem ti yo'nton ti Sauloe chilbajin tscontrain ti much'utic xch'unojic ti ja' Jcoltavanej yu'unic ti Cajvaltique. Chalbe smilelic mi mu scomesique. Ti Sauloe ba sc'opon ti totil palee te ti Jerusalén. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ba sc'ambe tal sunal ti much'utic oy yabtelic te ti temploetic yu'un ti xchi'iltaque te ti jteclum Damasco sbi yu'un sc'an chba xchuc tal scotol ti much'utic xch'unojic ti lequil ach' c'ope, ti chcolic ti sventa ti Jesuse. Mi vinic mi ants chc'ot sta chic' tal ti Jerusalén. C'alal laj xa yich' ti sune, hech yu'un chbat ti Damasco. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","C'alal nopol xa chc'ot ti Damasco, ti ora iquevan tal c'alal ti vinajel yo' bu ixanav batel ti be. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Hech ip'aj ti lum ti Sauloe. Laj ya'i oy much'u chc'oponat: ―Saulo, ¿c'u yu'un chacontrainun? ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Hech itac'av ti Sauloe: ―¿Much'uot, Cajval? ―xchi. ―Ho'on Jesusun. Ho'on ti chacontrainune. Hovil ti hech chapase. Ja' no'ox chlic avich' vocol ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ich'ay yo'nton ti Sauloe. Toj xi'el ic'ot. Hech laj yal: ―Cajval, ¿c'usi chac'an ti jpas? ―xchi. I'albat yu'un ti Cajvaltique: ―Lican, ochan batel ti jteclum. Te chc'ot yalbot ava'i c'usi chapas ―x'utat. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ti viniquetique ti xchi'il ti Sauloe, laj sva'an sbaic. Ich'ay yo'ntonic yu'un oy much'u ic'opoj laj ya'yic, muc xilic. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ilic ti Sauloe. C'alal laj svic' sat, mu xa xil balumil ti Sauloe. Ja' nitbil xa i'och batel ti Damasco. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Oxib c'ac'al tup'en ti sate. Mu'yuc xa c'usi laj sve'. Mu'yuc xa c'usi laj yuch'. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Oy jun jch'unojel te ti Damasco, Ananías sbi. Ti Cajvaltique laj yac' sba ti q'uelel ti stojol ti Ananíase. Hech ic'oponat yu'un: ―¡Ananías! ―x'utat. ―Li'uni, Cajval ―xchi xtac'av ti Ananíase. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Hech i'albat yu'un ti Cajvaltique: ―Batan ti bu Toj Calle sbi. Te ti sna ti Judase chc'ot ata jun achi'il, Saulo sbi. Liquem tal ti jteclum Tarso ti Sauloe. Te yac'oj sba chisc'oponun. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Laj xa cac'be yil ti chc'o avac' ac'ob ti sjol yu'un hech chjam ti sate ―x'utat ti Ananíase. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hech itac'av ti Ananíase: ―Cajval, ca'yojbe sc'opilal ti vinic ti chavale. Ep chilbajin scotol ti much'utic oyic ti atojole te ti Jerusalén. ");
INSERT INTO tzoNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yich'oj mantal yu'un ti totil paleetique yu'un chchuc scotol ti much'utic chasc'oponote ―xchi ti stojol. ");
INSERT 