﻿USE sofia;
DROP TABLE IF EXISTS sofia.tzjNT_vpl;
CREATE TABLE tzjNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tzjNT_vpl WRITE;
INSERT INTO tzjNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ja Jesucristo arja' riy rumam can ja rojer rey David in chakaja' riy rumam can ja rAbraham. Jawa' ja xtintz'ibaj ri' jawa' quebi' ja rati't rmama' ja Jesucristo. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ja rAbraham, tatixel rxin Isaac. Ja rIsaac, tatixel rxin Jacob. Ja Jacob, tatixel rxin Judá e rachbil ja rch'alal. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ja Judá, tatixel quixin ca'i' achi'i' quibina'an Fares in Zara, in ja quete', Tamar rubi'. Ja Fares, tatixel rxin Esrom. Ja Esrom, tatixel rxin Aram. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ja Aram, tatixel rxin Aminadab. Ja Aminadab, tatixel rxin Naasón. Ja Naasón, tatixel rxin Salmón. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ja Salmón, tatixel rxin Booz, in ja rute' ja Booz, Rahab rubi'. Ja Booz, tatixel rxin Obed, in ja rute' Obed, Rut rubi'. Ja Obed, tatixel rxin Isaí. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ja Isaí, tatixel rxin ja rojer rey David. Ja David, tatixel rxin Salomón, in ja rute' ja Salomón jari' ixok ja rxjayil Urías nabey. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ja Salomón, tatixel rxin Roboam. Ja Roboam, tatixel rxin Abías. Ja Abías, tatixel rxin Asa. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ja Asa, tatixel rxin Josafat. Ja Josafat, tatixel rxin Joram. Ja Joram, tatixel rxin Uzías. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ja Uzías tatixel rxin Jotam. Ja Jotam, tatixel rxin Acaz. Ja Acaz, tatixel rxin Ezequías. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ja Ezequías, tatixel rxin Manasés. Ja Manasés, tatixel rxin Amón. Ja Amón, tatixel rxin Josías. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ja Josías, tatixel rxin Jeconías e rachbil ja rch'alal, tokori' xe'oc preso ja raj Israel, xec'amarel chipan ja nación Babilonia. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ja c'a Jeconías, tatixel rxin Salatiel. Ja Salatiel, tatixel rxin Zorobabel. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ja Zorobabel, tatixel rxin Abiud. Ja Abiud, tatixel rxin Eliaquim. Ja Eliaquim, tatixel rxin Azor. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ja Azor, tatixel rxin Sadoc. Ja Sadoc, tatixel rxin Aquim. Ja Aquim, tatixel rxin Eliud. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ja Eliud, tatixel rxin Eleazar. Ja Eleazar, tatixel rxin Matán. Ja Matán, tatixel rxin Jacob. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ja Jacob, tatixel rxin José. Ja José, arja' rchajil María in jari' María rute' ja Jesús ja Cristo nokche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jawa' quebi' ja rati't rmama' ja Jesucristo in tok namajto cajlaxic ruq'uin ja rAbraham in narq'uisa' ruq'uin ja rey David e catorce canojel. In tok namajto chic cajlaxic ruq'uin David in narq'uisa' chipan ja tiempo ja xec'amarel wi' ja raj Israel pa Babilonia e catorce chakaja'. In tok namajto chic cajlaxic chipan ari' tiempo in narq'uisa' ruq'uin ja Cristo e catorce chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ja Jesucristo tok xalaxi quewa' rbanic ri'. Ja María ja rute' arja' rya'on chic ruchi' tre ja José chi nc'ule' ruq'uin. Pro ja tok maja'n tiquec'am qui' chaka jalal tok xotakixi chi yawa' chic ja María chi nq'ueje' jun ti ral. Pro rmal ja rEspíritu Santo samaji chewi' tok queri' xuban. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ja c'a José ja xajalal maja'n toc rchajil arja' utzlaj achi chewi' tok xpokonaj xuya' ta ruq'uix ja María. Rmalc'ari' tok xuch'ob chi pan ekal nuyoj ja c'ulbic. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pro kas c'a queri' rmajon rch'obic ja tok chaka jalal winakar jun ángel rxin ja kajaw Dios pa rwaram in xbij tre: —José ja rat riy rumam can ja rojer rey David, ma taxbej ta awi', tac'ama' ja María como ja tac'al ja c'o pa gracia, Espíritu Santo samajin rxin. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ja María arja' nq'ueje' na jun ti ral tala' in ja rubi' xtabij tre, Jesús xcatche' tre. Como ja bi'aj Jesús tibij tzij To'onel queri' c'a ja rubi' xtabij tre como arja' nto'owi ja rtinamit chipan ja quil quemac, ne'e ja ángel tre ja José. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nojel ja c'a xintz'ibaj kaj ri' ma chaka ta bantaji, rumac chi tri' bantaj wi' cumplir ja rbin can ja kajaw Dios ja tz'ibtal can rmal ja profeta quewari': ");
INSERT INTO tzjNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","—Bien tec'waxaj ja wari', c'o jun k'apoj xtan nyawaj na in rmalari' tok nq'ueje'e jun ti ral tala'. Jari' tala' Emanuel xtibina'ax tre. Queri' ja tz'ibtal can. Emanuel tibij tzij Dios c'o kuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ja c'a tok c'asoji ja José queri' xuban ja cani' bix tre rmal ja ángel rxin ja kajaw Dios, c'ule' ruq'uin ja María. ");
INSERT INTO tzjNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pro ja tre tiempo tok maja'n talaxi ja ti ral ja María ja nabey winak ni majun nak ta queban. Ja c'a José tok xuya' rubi' ja tac'al, Jesús xbina'aj tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ja c'a Jesús, chipan ja tinamit Belén xalax wi' ja c'o pa rcuenta Judea. Jari' tiempo ja Herodes arja' ocnak rey. C'ac'ari' ec'o ca'i' oxi' achi'i' epenak chipan jun nación ja c'o pan oriente, eje'e' xe'urkaj chipan ja tinamit Jerusalén. Jari' achi'i' e magos neche'xi. Eje'e' quemaj rc'axaxic chique ja winak: ");
INSERT INTO tzjNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","—¿Bar c'o wi' ja yaqui' ja c'a xalaxi ja Rey ewxin ja rix aj Israel? Como ja rajoj c'o jun ch'umil katz'atonto pan oriente ja nk'alasan rxin in camic okpenak chi nurkaya'a' ruk'ij, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ja c'a rey Herodes tok xc'axaj chi c'o chic jun rey xalaxi congana junwi' xuna' in canojel ja rec'o pa Jerusalén junwi' quic'axaj chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ja c'a Herodes xerumol canojel ja jefe quixin sacerdote e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios ja tz'ibtal can ojer rmal ja Moisés in quewa' xc'waxaj chique ri': —¿Bar tri' nalax na wi' ja Cristo? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—Chipan ja tinamit Belén nalax wi' ja c'o pa rcuenta Judea, xeche' tre. —Queri' nkabij chawe como queri' tz'ibtal can rmal ja profeta quewari': ");
INSERT INTO tzjNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","—Ja tinamit Belén ja c'o pa rcuenta Judá, janila nim ruk'ij ntz'a̱t cumal ja k'etol tak tzij xin Judá. Queri' rbanic como tri' nwinakar wi' jun k'etol tzij, arja' nuc'an quixin ja ntinamit Israel, ne'e ja Dios. Queri' ja tz'ibtal can rmal ja profeta, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","C'ac'ari' ja Herodes arja' xutak quisiq'uixic ja magos. Ja c'a tok xe'ekaj ruq'uin xuc'ot quechi' chi utz, xc'axaj chique nak k'ij kas winakari ja ch'umil. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","C'ac'ari' xerutakel pa Belén in xbijel chique: —Jix ja pa Belén, jecanoj chi utz ja tac'al bar kas xtewila' wi'. Ja c'a tok xtewila' tetaka'to rbixic chwe utzc'a chi ninbe anin chakaja' chi nenya'a' ruk'ij, ne'el chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ja tok xac'axtaj cumal ja bix chique rmal ja rey c'ac'ari' xebe. Pro ja c'a ch'umil ja quitz'atonto pan oriente jari' c'amo'el quebey. Ja c'a ch'umil tok xekaj pa rujic ja bar c'o wi' ja tac'al ma xbin chi ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ja c'a reje'e' tok quetz'at ja ch'umil chi pe'i congana xequicoti. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","C'ac'ari' xe'oc chipan ja jay in quetz'at ja tac'al rachbil ja María ja rute'. Xexuque' chwach ja tac'al, quemaj rya'ic ruk'ij. C'ac'ari' quiwasajto ja quic'amonel ja nimak rjil in c'oli quisipaj tre. Ja quisipaj tre, oro in nakun je'e ja qui' rxula' cani' tre incienso in mirra. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","C'ac'ari' xebe chic chipan ja quitinamit pro como bix chique pan achic' chi maquemeloj chic ruq'uin ja Herodes chewi' tok junwi' chic bey quec'amel. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ja tok ebenak chic ja magos c'o jun ángel rxin ja kajaw Dios winakar chwach ja José pan achic' in quewa' xbij tre ri': —Catyictaji, tac'ama'el ja tac'al rachbil rute', quixanmaji, jix pan Egipto in tri' nixeq'ueje' wi'. C'a anin na ninbin chawe ja tok xquixmelojpi chic. Queri' nbij chawe como ja Herodes arja' xajalal maja'n tumaj rcanoxic ja tac'al chi ncamsaj, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","C'ac'ari' c'asoji ja José in yictaji, xuc'amel ja tac'al rachbil rute', xebe pan Egipto chak'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tri' c'a xeq'ueje' wi' chijutij, c'a tokori' xemelojpi chic ja tok cami ja Herodes. Ja queban, ma chaka ta queban, rumac chi tri' bantaj wi' cumplir ja rbin can ja kajaw Dios ja tz'ibtal can rmal ja profeta quewari': —Pan Egipto xintak wi' rsiq'uixic ja nc'ajol, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ja c'a Herodes tok xutz'at chi ban can tre ni mta cumal ja magos congana kuluj rmal ja ryewal. Xuya'el jun orden chi necamsaxi ja rac'ala' ja tak ala'i' ja rec'o pa Belén in chakaja' ja rec'o pa tak lugar chinakaj ja Belén. Canojel ja quimajon jujun caca' tak quijuna' necamsaxi. Como ja Herodes bin tre cumal ja magos nak tiempo kas winakarnakto ja ch'umil jari' tiempo xoc rbase jaru' tak quijuna' ja necamsaxi. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Queri' bani, xecamsaxi, in tri' c'a bantaj wi' cumplir ja bitajnak can rmal ja profeta Jeremías quewari': ");
INSERT INTO tzjNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","—C'o jun kulaj c'axax chipan ja tinamit Ramá, janila jun nimlaj bis jun nimlaj ok'ej nuban nc'axaxi. Jari' kulaj rxin ja Raquel nerok'ej ja tak ral. Congana chi ok'ej nuban, ni ma xbochitaj ta wi' rumac chi xecami ja tak ral, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ja c'a tok cami ja Herodes c'o jun ángel rxin ja kajaw Dios winakar chwach ja José pan achic' pan Egipto in quewa' xbij tre ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Catyictaji, tac'ama'el ja tac'al rachbil rute', jix, quixmeloj chipan ja nación Israel como ecamnak chic ja winak ja c'o quigana nquicamsaj ja tac'al, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","C'ac'ari' c'asoji in yictaji, xuc'amel ja tac'al rachbil rute', xebe, xemeloj chipan ja nación Israel. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pro ja José arja' xekaj rbixic ruq'uin chi ja k'etbaltzij rxin ja departamento Judea c'o chic pa ruk'a' ja Arquelao ja rc'ajol Herodes. Ja Arquelao q'ueje' can pa rc'axel ja rtata'. Ja c'a José tok xc'axaj chi queri' xbej ri' rmal, ma xbe ta tri'. Pro como c'oli k'alasax chic chwach pan achic' rmalari' ja tok be chipan ja departamento Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ja c'a tok xe'ekaji ja pa Galilea chipan ja tinamit Nazaret xeq'ueje' wi'. Queri' queban rumac chi tri' bantaj wi' cumplir ja quibin can ja profeta tre ja Cristo quewari': —Xtibina'ax tre chi aj Nazaret, xtiche'x na. Queri' ja quibin can tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Xerila' ja tiempo chi ja Juan Bautista arja' peti, ntajini nuya' rbixic ja rtzobal Dios chipan jun lugar kas talani c'o pa rcuenta Judea. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Quewa' nbij chique ja winak ri': —Teq'uexa' ja rena'oj in teya'a' can ja ritzelal como xa nnakajinto ja gobierno xin chila' chicaj, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ja Juan jari' ja bitajnak can ojer chi npi na, quewa' bitajnak can tre rmal ja profeta Isaías ri': —C'o jun kulaj nc'axax chipan ja lugar ja kas talani, quewa' nbij ri': —Techomarsaj chi utz ja rubey ja kajaw Dios, jic teya'a'. Queri' ja tz'ibtal can tre ja Juan. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ja c'a Juan puro rsamal camello ocnak ja rtziak rcojon in c'o jun cincha rcojon xerupan. Ja rocnak rq'uexwach rway, sac' nerutij in raxcab chakaja' ncanoj pa tak k'ayis. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","In nij ec'o wi' winak ne'ekaj ruq'uin cani' chique ja raj Jerusalén in chique ja rec'o chipan ja jule' chic lugar ja c'o pa rcuenta Judea in chakaja' canojel ja rec'o chinakaj ja binelya' Jordán. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ja c'a tok xe'ekaj ruq'uin xeba̱n bautizar rmal chipan ja binelya' Jordán in tri' quechol wi' ja quil quemac. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","E q'uiy chique ja fariseo e cachbil ja saduceo eje'e' xe'ekaj ruq'uin ja Juan chi neba̱n bautizar rmal pro ja c'a Juan tok xerutz'at arja' xbij chique: —Ixix congana itzel tak na'oj ewc'an, ix cani' jule' itzel tak cumatz. ¿Nak bin chewe chi nixanmaj chwach ja nimlaj juicio ja nnakajinto? ");
INSERT INTO tzjNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ja kas mero rubey chi neban tiwachini ja rutzil pa tak ewanma, nijawari' yatal chewij chi neban ja wi katzij chi eq'uexon chic ja rena'oj. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","In maxta quewa' tech'ob kaj pa tak ewanma ri': —Ajoj ok riy rumam can ja rAbraham rmalari' ok rtinamit Dios, maxta quixche'e. Queri' nbij chewe como ja Dios ni ma c'ayew ta tre nerwinakarsaj jule' riy rumam ja rAbraham trela' jule' abaj le'. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","In chakaja' ja camic ri' xa nakaj c'oto chi wi' ja juicio xin Dios cani' rbanic jun iquiaj chomin chic xajalal maja'n tichoy jule' che' tre. Ja c'a che' ja mta utz rwach nuya' jari' nchoyi nojelal in nporox pa k'ak'. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Anin, ya' ncoj ja nixnbanbej bautizar in tok nixban bautizar jari' retal chi ech'obon chic chi neq'uex ja rena'oj in neya' can ja ritzelal. Pro c'o chi na jun penak ja xajalal maja'n tumaj ja rsamaj, arja' más chi na nim ja poder c'o pa ruk'a' chinwach anin. Anin ma yatal ta chwij xquintiloc ta ruq'uin nixtac'a chi ruc'axic ja rxajab. Arja' nixruban bautizar pro Espíritu Santo in k'ak' ja nixrbanbej bautizar. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Arja' rchomin chic ri' chi nerparti'ij ja re utz chiquicojol ja ma e utz ta cani' nuban jun achi nuq'uiak rwach trigo tre pala, nparti'ij ja trigo chipan ja rmukal. C'ac'ari' nuc'ol ja trigo chipan ja rc'olibal pro ja rmukal nporoj pa k'ak' pro jari' k'ak' mta chupic trij. Queri' xbij ja Juan chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ja c'a Jesús arja' xelto pa Galilea, be ruq'uin ja Juan chuchi' ja binelya' Jordán. Ja rch'obonel chi nbe neba̱n bautizar rmal ja Juan. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pro ja tok xekaji, ja Juan matirajo' nuban bautizar, quewa' xbij tre ri': —Pro ja kas rubey, anin ja quinabana' bautizar, pro jari' taka'an atat nawajo' chi natnuban bautizar, ne'e ja Juan. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","In bix tre rmal ja Jesús: —Camic ni ninaban wi' bautizar como rjawaxic chi nkaban cumplir nojel ja najo'x chake rmal ja Dios chi nkaban, ne'xi ja Juan. C'ac'ari' ja Juan xuban ja bautismo. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ja Jesús tok chaka maril bantaj bautizar xelto pa ya' in chaka jalal tok jaktaji ja caj. C'ac'ari' xutz'at ja rEspíritu Santo xin Dios cani' jun ajsakaxic' kajto ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","In c'o jun kulaj penak chila' chicaj c'axaxi, quewa' xbij ri': —Jawa' wari' jawa' chak'laj Walc'wal, congana ninquicot trij, ne'e ja kulaj xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ja c'a Jesús arja' c'amarel rmal ja rEspíritu Santo, be chipan ja lugar ja kas talani chi ntakchi'ix rmal ja diablo. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ca'winak k'ij ca'winak ak'a' ma xwa' ta. Ja c'a tok tz'akati ja ca'winak k'ij ca'winak ak'a' majtaj rmal rk'ak'anil rupan. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ja c'a diablo ja takchinel arja' xekaj ruq'uin ja Jesús in quewa' xbij tre ri': —Ja wi katzij chi atat ja rat Ralc'wal Dios tabij c'a trewa' ja jule' abaj ri' chi noc way, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ja c'a Jesús xbij tre: —Tz'ibtal can chipan ja rtzobal Dios chi ja winak ma ruyon ta way nc'atzin chique tre ja quic'aslemal pro nojel ja rtzobal Dios jari' nc'atzin chique chakaja', ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","C'ac'ari' ja diablo xuc'amel chic ja Jesús, xebe chipan ja santilaj tinamit Jerusalén. Ja c'a tok xe'ekaji xjotba' parwi' ja nimlaj templo xin Dios ");
INSERT INTO tzjNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","in xbij tre: —Ja wi katzij chi atat ja rat Ralc'wal Dios taq'uiaka'el c'a awi' wawe' como ja chipan ja rtzobal Dios quewa' tz'ibtal can chawe ri': —Ja Dios nerutakto ángel chi naturquichajij, eje'e' netz'amo awxin utzc'a chi matasoc awakan chwach abaj. Queri' tz'ibtal can, ne'e ja diablo. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ja c'a Jesús xbij tre: —Pro tz'ibtal can chakaja' chi ma tac'ambajaj ta ja Dios ja rawajaw, queri' nbij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ja c'a xuban chic ja diablo, xuc'amel chic ja Jesús, xebe parwi' jun nimlaj jayu'. Ja c'a tok xe'ekaji xumaj rc'utic chwach ja gobierno rxin nojel ja tinamit ja c'o chwach'ulew in nojel ja meba'il rxin ");
INSERT INTO tzjNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","in xbij chic tre: —Wi xcatxuque' chinwach wi naya' nuk'ij, anin njach pan ak'a' ja gobierno rxin nojel ja tinamit ja nmajon rc'utic chawach le', ne' chic tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ja c'a Jesús quewa' xbij tre ri': —Jat, catel chinwach Satanás como tz'ibtal can chipan ja rtzobal Dios chi xa ruyon ja Dios ja rawajaw catxuque' chwach, xa ruyon arja' taya'a' ruk'ij, queri' nbij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","C'ac'ari' be ja diablo, xuya' can ja Jesús in ja Jesús chaka jalal tok xepi jule' ángel xurquito'o'. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ja c'a Jesús tok xekaj rbixic ruq'uin chi coji ja Juan Bautista pa che' c'ac'ari' xuya' can ja lugar ja bar c'o wi', be pa Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ja c'a tok xekaji ja pa Nazaret ma xq'ue ta tri', be pa Capernaum in tri' q'ueje' wi'. Ja Capernaum chiya' c'o wi', tri' c'o wi' ja bar c'o wi' ca'i' lugar, jun rbina'an Zabulón in jun chic Neftalí rubi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Queri' bantaji utzc'a chi tri' bantaj wi' cumplir ja bitajnak can ojer rmal ja profeta Isaías tre ja ca'i' lugar quewari': ");
INSERT INTO tzjNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","—C'oli xtibantaj na chipan ja ca'i' lugar Zabulón in Neftalí, jari' lugar tri' c'o wi' ja bar c'o wi' ja ya', chajuparaj binelya' Jordán c'o wi', pa rcuenta Galilea c'o wi' ja bar ec'o wi' ja winak ja ma e aj Israel ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ja winak ja rec'o chipan ari' lugar, nabey xa pa k'ekumal ec'o wi' pro nquetz'at na jun nimlaj luz, ja nabey ec'o chipan jun bey ja xa camíc rc'amonto pro nsakirsax na quebey chiquewach rmal ja luz. Queri' ja bitajnak can. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ja c'a Jesús jari' k'ij xumajel rbixic ja rtzobal Dios chique ja winak in quewa' nbij chique ri': —Ja gobierno xin chila' chicaj xa nnakajinto rmalc'ari' tok nbij chewe, teq'uexa' ja rena'oj, teya'a' can ja ritzelal, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ja c'a Jesús arja' kas rmajon binem chuchi' ja ya' rbina'an Galilea ja tok ec'o ca'i' achi'i' xeruwil e alaxic, jun rbina'an Simón ja c'o chic jun rubi' Pedro ne'xi, in jun chic Andrés rubi'. Eje'e' como e chapol ch'u' kas quimajon rq'uiakic ja c'am pa ya' ja tok xe'iltaji rmal ja Jesús ");
INSERT INTO tzjNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","in quewa' bix chique rmal ri': —Jo' quixtre' chwij, anin nya' na jun samaj chewe pro ma chapoj ch'u' chi ta ja neban, winak chic ne'ecanoj, xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ja c'a reje'e' quich'akila' can ja quec'am in xetre'el trij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kas quimajon binem ja Jesús ja tok ec'o chic e ca'i' achi'i' xeruwil, chakaja' e alaxic, jun rbina'an Jacobo in jun chic Juan rubi', e rc'ajol Zebedeo, ec'o pa jun lancha cachbil ja quitata', quimajon rc'ojoxic ja quec'am. Xesiq'uix pon rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ja c'a reje'e' alnak xe'elto chipan ja lancha, q'ueje' can ja quitata' chipan in xetre'el trij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ja c'a Jesús arja' be nat nakaj chipan ja departamento Galilea, nertijoj ja winak pa tak jay xin molbal ri'il ja bar nquemol wi' qui' chi rc'axaxic ja rtzobal Dios, nuya' rbixic chique ja utzlaj tzij tre ja gobierno xin chila' chicaj in chakaja' ec'oli ja yawa'i' nertzursaj xa nak ta nti'on chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","In be rbixic chipan nojel ja lugar je'e ja c'o pa rcuenta Siria. Xec'amarel ruq'uin ja yawa'i' pro canojelal. Xa nak ta chi yobilal cuc'an, xa nak ta nti'on chique, wi ec'o itzel tak espíritu e'ocnak chique, wi c'ol ataque chique, wi e sica', xec'amarel canojelal ruq'uin in xertzursaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","In congana e q'uiy ja winak xetre'el trij cani' chique ja rec'o chipan ja departamento Galilea in chique ja rec'o chipan ja lugar rbina'an Decápolis in chique ja raj Jerusalén in ja rec'o chipan jule' chic tinamit ja c'o pa rcuenta Judea in chique chakaja' ja rec'o chajuparaj ja binelya' Jordán. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ja c'a Jesús tok xutz'at chi congana e q'uiy ja winak arja' be, jote' chwach jun jayu', xuwil jun lugar in tri' tz'abe' wi'. Ja c'a rdiscípulo eje'e' xe'ekaj ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Xumaj c'a quitijoxic, quewa' xbij chique ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Congana qui'il chique ja winak ja ch'obtajnak cumal chi ni nc'atzin wi' ja rEspíritu Santo chique chi nq'ueje' pa tak canma, congana qui'il chique como quixin c'ari' ja gobierno xin chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Congana qui'il chique ja winak ja netajini ne'ok'i in nebisoni, congana qui'il chique como nyukbax c'a quec'u'x ari'. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Congana qui'il chique ja winak tok c'oli nquewil chipan ja quic'aslemal in eje'e' ni pa ruk'a' Dios wi' nquejach wi', congana qui'il chique como chique nyataj wi' jun herencia. Ja herencia ja nyataj chique jari' ja rwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Congana qui'il chique ja winak ja congana nquiyarij nquetzuk ja canma tre ja rutzil xin Dios, congana qui'il chique como ja rutzil nquiyarij jari' xtinoj na pa tak canma. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Congana qui'il chique ja winak ja nepokonan quewach cach tak winak, congana qui'il chique como eje'e' npokonax c'a quewach ari' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Congana qui'il chique ja winak ja ch'ajch'oj canma, congana qui'il chique como eje'e' nequitz'ata' na c'a rwach ari' ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Congana qui'il chique ja winak ja nechomin quixin winak, nquechup rwach síc' ch'a'oj, congana qui'il chique como eje'e' xque'otakixi chi e ralc'wal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Congana qui'il chique ja winak ja nba̱n itzel chique rumac ja rutzil xin Dios nqueban, congana qui'il chique como quixin c'ari' ja gobierno xin chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Congana qui'il chewe ja tok nixtz'uji nixyok'i in tok nba̱n itzel chewe in tok nojel rwach ja ritzelal nbix chewe ja ma katzij ta pro mwal anin tok nba̱n queri' chewe. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ja tok queri' nqueban chewe quixquicoti pro congana quixquicoti como jari' c'o jun nimlaj rtojbalil ja nyataj na chewe chila' chicaj. Quixquicoti como queri' ban chique ja rojer tak profeta chakaja' ban itzel chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ja rixix ix cani' atz'am, neban qui' tre ja quic'aslemal ja winak cani' nuban ja ratz'am ja nbano qui' tre ja nkati'. Pro ja ratz'am wi xtiyojtaji wi mchita rtzayil ¿nak c'a nchomarsbex chic rxin ari'? Ja wi queri' nuban jari' mchita noc wi', xa nch'akixel in npa̱k' chakan cumal winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ja rixix ix cani' luz, nesakirsaj quebey ja winak chiquewach wawe' chwach'ulew. Cani' tre jun tinamit parwi' jayu' c'o wi' mta moda ja maquita ntz'attaji. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","In cani' chique winak mta jutij xtiquetzij ta jun candil xtiquijupba' ta c'a jun caxon trij. Ja nqueban, nquetzij ja candil in nquijecba' utzc'a ja winak ja rec'o pa jay pa sak neq'ueje' wi' canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","In quirtac'ari' nuban ja luz ja c'o pa tak ewanma ixix chakaja', tisakirsaj quebey ja winak chiquewach utzc'a ja winak tok nquetz'at ja rutzil neban, eje'e' xtiqueya' ta ruk'ij ja Tatixel ewxin ja c'o chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Maxta tech'ob chwij chi anin inpenak chi nunyojo' ja ley xin Dios ja tz'ibtal can rmal ja Moisés nixtac'a ja ta chakaja' ja bin can je'e cumal ja profeta. Ma queri' ta, ma inpenak ta chi nunyojo', anin inpenak chi nunbana' cumplir. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Queri' nbij chewe como jari' ley ni nbantaj wi' cumplir nojelal, nixtac'a c'o ta jutz'it tre ja maquita nbantaj cumplir. Ni katzij wi' ja xtinbij chewe ri', ma c'ayew ta nq'uisi caj nq'uisi rwach'ulew chwach ja c'o jun ti punto tre ja ley ja maquita nbantaj cumplir. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ja winak xa nak ta chi winakil wi c'o jun mandamiento rxin ja ley wi nqueban tre ni mta, masqui jari' mandamiento ma kas ta rjawaxic chi nnimaxi neche' tre, in wi queri' ja nquec'ut chiquewach winak, chakaja' eje'e' ma nimak ta quek'ij chipan ja gobierno xin chila' chicaj. Pro ja winak ja nquinimaj ja mandamiento in wi queri' ja nquec'ut chiquewach winak chakaja', eje'e' nimak quek'ij chipan ja gobierno xin chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Anin nbij chewe, ja rewutzil wi xa junan ja cani' cutzil ja maestro ja netijon quixin ja winak tre ja ley xin Dios, wi xa junan ja cani' cutzil ja fariseo jari' ni maquixoc wi' chipan ja gobierno xin chila' chicaj, ni rjawaxic wi' chi nech'ucla'aj ja rewutzil. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ixix ec'waxan ja bitajnak can ojer chique ja winak chi: —Ma teban ta camíc, ja c'a wi c'o jun xtuban camíc jari' nk'e̱t na tzij trij. Queri' ja bitajnak can. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pro ja ranin nbij chewe, wi c'o jun nuban ryewal tre jun rch'alal jari' nk'e̱t na tzij trij. In wi c'o jun nbij tre jun rch'alal: —Xat nacnic, k'eku'm awi', wi ne' tre jari' nc'amarel chiquewach ja nimak tak k'etol tak tzij chi nk'e̱t tzij trij. In wi c'o jun nbij tre: —Xat itzel winak, majun Dios awq'uin, wi ne' tre jari' ncaje' can jun nimlaj rpokonal chwach pa k'ak'. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Rmalc'ari' nbij chewe, ja tok c'oli ja rofrenda nec'amto wi ech'obon chi neya' chwach altar in netzujuj chwach ja Dios pro wi nurkaj chewe chi c'o jun ewach'alal ebanon ofender ");
INSERT INTO tzjNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mejor, ma tetzujuj ta na ja rofrenda, teya'a' can tri' ja bar c'o wi' ja raltar, jix jechomij na ewi' nabey ruq'uin ja rewach'alal. Ja tok xquixchomtaj ruq'uin quixmelojto, c'a tokori' c'a utz chic netzujuj ja rofrenda. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Cani' tre c'o ta jun nyo' parte chewij, mejor ja neban, tok emajon bey ixbenak pa k'etbaltzij techomij ewi' ruq'uin, nowi ma queri' ta neban, ja nyo' parte chewij arja' nixrujach pa ruk'a' ja ralcalta, ja c'a ralcalta nixrujach chic pa ruk'a' comisario in nixrucoj pa che'. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ni katzij wi' ja xtinbij chewe ri' chi ni maquixelto wi' ja pa che', nixelto c'a pro netoj can na nojel ja rec'as, nixtac'a c'o ta jun ti centavo ja maquita xtetoj can. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","In jun chic ec'waxan ja bitajnak can ojer chi: —Maxta teban rij tak quewi' ja rewixjayilal owi ewachajilal. Queri' ja bitajnak can. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pro ja ranin nbij chewe, wi c'o jun masqui xa xutz'at jun ixok in xyarij kaj pa ranma jari' xuban rij rwi' ja rxjayil pa ranma. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ja c'a panewach ja c'o pan ewiquik'a' wi xa rmal tok nixkaj chipan il mac mejor, tec'oto'el in tech'akijel. Queri' nbij chewe como más na utz netz'ila' jun panewach chwach ja nbe ja recuerpo chi jun pa k'ak'. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","In ja rek'a' ja rewiquik'a' wi xa rmal tok nixkaj chipan il mac mejor, tekupijel in tech'akijel chakaja' como más na utz netz'ila' jun ek'a' chwach ja nbe ja recuerpo chi jun pa k'ak'. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","In jun chic ja bitajnak can ojer quewari': —Ja wi c'o jun xajutij xujach can ja rxjayil rjawaxic chi nuban jun wuj in ntz'ibaj chipan chi xajutij nuya' can, ja c'a wuj tok ntzuri nujach can tre ja rixok. Queri' ja bitajnak can. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pro ja ranin nbij chewe, wi c'o jun xajutij xujach can ja rxjayil in ja rxjayil wi ma macunnak ta ruq'uin jun chic achi, arja' kas k'alawachili numin ja rxjayil chipan ja radulterio. In wi c'o jun achi nuc'am jun ixok jachon can jari' achi adulterio ja nuban. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","In jun chic ec'waxan ja bitajnak can chique ja winak ojer chi: —Maxta ma katzij ta teban ja tok neban jurar pro jari' tebana' cumplir ja netzujuj tre ja kajaw Dios tok neban jurar. Queri' ja bitajnak can. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pro ja ranin nbij chewe, majutij teban jurar. Ma tenataj ta ja caj chi rbanic jurar como ja caj jari' ocnak rtz'ulibal ja Dios ja nimlaj Rey ");
INSERT INTO tzjNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","in nixtac'a nenataj ta rwach'ulew chakaja' chi rbanic jurar como ja rwach'ulew jari' ocnak rc'olbal rkan ja Dios in nixtac'a tinamit ta Jerusalén nenataj chakaja' como ja Jerusalén jari' ocnak ja rtinamit ja Dios ja nimlaj Rey ");
INSERT INTO tzjNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","in nixtac'a nenataj ta ewí' chakaja' chi rbanic jurar como ja rixix maquixcowini xteq'uex ta rcoloril jun ti chirwach rsamal ewí' xteban ta sak tre owi k'ek. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ja tok wi c'o je'e nebij ni tebij rubi', wi can, can quixche'e, nowi ma can ta, ma can ta quixche'e. Ja c'a wi c'o jule' chic tzij nebij ja wi ma ja tari' ja can owi ma can ta jari' jule' tzij xa ruq'uin diablo penak wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","In jun chic ec'waxan ja bitajnak can ojer chi: —Ja wi c'o jun xayoj jun rwach queri' nba̱n chawe atat chakaja', nba̱n rc'axel chawe, nyo̱j jun awach owi c'o jun xawasaj jun rey queri' nba̱n chawe atat chakaja', nba̱n rc'axel chawe, nwasax jun awey. Queri' ja bitajnak can. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pro ja ranin nbij chewe, ma teya' ta rjil rc'axel chique ja nebanowi ja ritzelal chewe. Ja neban, wi c'o jun xuya' jun k'a' xewey teya'a' lugar tre chi nuya' chic jun chajuparaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","In wi c'o chic jun xixruc'amel pa k'etbaltzij chi nrajo' numaj chewe ja recamisa ja neban, teya'a' tre in teya'a' echaqueta tre chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ja wi c'o jun xixruban mandar chi nixoc chuxe' jun ijka'm in nixtre'el trij in nbij chewe chi pa jun kilómetro neya'a' wi', ja c'a neban ixix, tetzujuj tre chi pa ca'i' kilómetro neya'a' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ja wi c'o jun c'oli xc'utuj chewe teya'a' tre in wi c'o jun nrajo' nukaj pwok chewe maxta ma teya' ta tre chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","In jun chic ec'waxan ja bitajnak can ojer chi: —Que'ewajo' ja reprójimo, ja c'a rec'ulel itzel que'etz'ata'. Queri' ja bitajnak can. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pro ja ranin nbij chewe, que'ewajo' ja rec'ulel, ja tok ec'oli nebin itzel tak tzij chewe ja c'a rixix solo utzlaj tak tzij tebij chique, ja tok ec'oli ja xa itzel nixquetz'at ja c'a rixix solo utzil tebana' chique, ja tok ec'oli nixtz'ujuwi nixyok'owi owi nqueban pokon chewe ja c'a rixix tebana' orar pa quicuenta. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Quirtari' neban utzc'a chi ixix nij ix k'alaj wi' chi ix ralc'wal Dios ja Tatixel ewxin ja c'o chila' chicaj, cani' nuban arja' nlasajto k'ij pa quewi' xa nak ta chi winakil chi e itzel tak winak chi e utzlaj tak winak in chakaja' nkajsaj jab pa quewi' canojelal chi nimanel rxin chi ma nimanel ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Queri' nbij chewe como ixix ja wi xa queyon lok' ne'ena' ja lok' ixquina'on ixix ¿la c'o ta c'a jun rtojbalil ari' nyataj chewe nech'ob ixix? Ja wi xa queri' neban xc'a ix junan ari' cuq'uin ja molol tak impuesto como eje'e' lok' nquena' qui' chibil tak qui'. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","In wi xa queyon ja rewach'alal ne'ek'ijla' ja queri' xc'a ix junan ari' cuq'uin ja winak ja xa nak ta chi winakil. Queri' nbij chewe como ja winak masqui ma cotak ta rwach ja Dios pro eje'e' nequik'ijla' ja cach'alal chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Rmalc'ari' nbij chewe, cani' rbanon ja Tatixel ewxin ja c'o chila' chicaj ni majun falta tre ja rajoben ri'il c'o tre queri' c'a chewe ixix chakaja' rjawaxic chi ni majun falta tre ja rajoben ri'il c'o chewe. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ec'oli winak tok c'o je'e nqueban ja chi ya'bal ruk'ij ja Dios nqueban pro xa chiquewach winak nqueban wi' utzc'a chi nya̱' quek'ij cumal ja winak nquech'ob. Pro ja rixix tebana' cuenta, maxta teban queri', nowi queri' neban ni majun rtojbalil nyataj chewe rmal ja Tatixel ja c'o chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Rmalc'ari' nbij chewe, tok c'o jun ti ayuda nesipaj maxta tewasaj ja rtzijoxic ja cani' nqueban ja winak ja xa caca' quipalaj. Eje'e' pa tak jay xin molbal ri'il nquisipaj wi' ja rayuda in pa tak bey chakaja' utzc'a chi nya̱' quek'ij cumal ja winak ja netz'ato quixin. Anin ni katzij wi' ja nbij chewe ri', eje'e' ja tok nya̱' quek'ij cumal ja winak ni xa ruyon wari' ja rtojbalil nquech'ec trij, mchita nak chi ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pro ja c'a rixix tok c'o jun ti ayuda nesipaj mejor ja neban, majun rbixic newasaj, nixtac'a ncotakij ta ja rec'oloc ewq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Quirtari' neban utzc'a majun nak ta notakini. Ja wi queri' neban ja Tatixel ewxin ja nutz'at nojelal masqui awatal chiquewach winak, arja' nuya' chewe jun rtojbalil pro ni chiquewach winak tok nuya' chewe. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","In jun chic, ja tok neban oración maxta queri' teban ja cani' nqueban ja winak ja xa caca' quipalaj. Queri' nbij chewe como eje'e' congana nel quec'u'x trij ja nepe'e pa tak jay xin molbal ri'il chi rbanic oración in pa tak esquina pa bey chakaja'. Queri' nqueban utzc'a chi nya̱' quek'ij cumal ja winak ja netz'ato quixin. Anin ni katzij wi' nbij chewe, ja tok nya̱' quek'ij cumal ja winak ni xa ruyon wari' ja rtojbalil nquech'ec trij, mchita nak chi ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pro ja c'a rixix tok neban oración quixoc chipan ja tak ewochoch chejujunal in tetz'apij ewi' chipan in quixtzijon ruq'uin ja Tatixel ewxin ja matitz'attaji. Ja wi queri' neban ja Tatixel ewxin ja nutz'at nojelal masqui awatal chiquewach winak, arja' nuya' chewe jun rtojbalil pro ni chiquewach winak tok nuya' chewe. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","In jun chic, ja tok neban oración maxta teban ja cani' nqueban ja winak ja ma cotak ta rwach ja Dios. Queri' nbij chewe como eje'e' chaka ja' nquicamuluj rbixic jule' tzij ja mta rc'amonto, ja nquech'ob eje'e' chi rumac ari' ja maxco' chi jule' tzij nquibij chewi' tok nc'axaxi ja coración. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Maxta queri' teban ixix ja cani' nqueban eje'e' como ja Tatixel ewxin arja' rotak chic nak ja nc'atzin chewe masqui maja'n tec'utuj tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Rmalc'ari' nbij chewe, ja tok neban oración quewa' nebij ri': —Katata' Dios ja ratc'o chila' chicaj, lok' ta xtina'i ja rabi' cumal ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Xtikajpi ta ja ragobierno wawe' chwach'ulew, xtinimax ta ja ravoluntad atat wawe' ja cani' ntajini nba̱n chila' chicaj nnimaxi. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Taya'a' chake ja kaway ja nc'atzin chake camic. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tacuyu' ja kil kamac ja cani' nkaban ajoj nekacuy ja winak tok c'oli quibanon chake. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Atat ta xcatchajin kaxin, maxta kokaji tok nokrtakchi'ij ja diablo, ko'ato'o' pa ruk'a'. Jari' nkac'utuj chawe como pan ak'a' atat c'o wi' nojel gobierno in pan ak'a' c'o wi' nojel poder, noc na ya'bal ak'ij nojelal, in nij at quirwari' camic, chwak in chijutij. Amén. Queri' ta rbanic ja roración neban. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ja c'a wi ne'ecuy ja winak tok c'oli nqueban chewe ja Tatixel ewxin ja c'o chila' chicaj arja' nixrucuy ixix chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nowi maque'ecuy jari' maquixrucuy ixix chakaja' ja Tatixel ewxin. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","In jun chic, ja tok neban ayuno chi ryabexic ruk'ij ja Dios maxta teban ixix ja cani' nqueban ja winak ja xa caca' quipalaj como eje'e' ni quigana wi' nqueban nbisoni ja quipalaj, ni lawulo' nqueban tre utzc'a chi netz'ati cumal ja winak chi ayuno ja quimajon rbanic. Anin ni katzij wi' ja xtinbij chewe ri', ja tok nya̱' quek'ij cumal ja winak tok nqueban ja rayuno ni xa ruyon wari' ja rtojbalil nquech'ec trij, mchita nak chi ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pro ja c'a rixix ja tok neban ja rayuno tejica' ewí' in tech'aja' chi utz ja repalaj ");
INSERT INTO tzjNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","utzc'a chi ja winak ma cotak ta chi ayuno ja remajon rbanic, xa jun otakyon jari' ja Tatixel ewxin ja matitz'attaji. Ja wi queri' neban ja Tatixel ewxin ja nutz'at nojelal masqui awatal chiquewach winak, arja' nuya' jun rtojbalil chewe pro ni chiquewach winak tok nuya' chewe. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Maxta xa ja' tibe ec'u'x ruq'uin ja q'uiyirsan meba'il wawe' chwach'ulew como ja meba'il xin rwach'ulew xa ma c'ayew ta nti̱j cumal chicop owi nk'uxari in ma c'ayew ta chakaja' ja ralak'oma' nquejok' chi'jay in nquilak'ajel. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pro ja neban, tibe ec'u'x trij ja q'uiyirsan meba'il xin chila' chicaj como ja meba'il xin chila' chicaj jari' mta moda xtitij ta cumal chicop owi xtik'uxar ta in mta moda chakaja' ja ralak'oma' xque'ekaj ta tri' xtiquilak'aj ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Anin xinbij chewe ja tzij ri' como xa nak ta chi meba'il benak ec'u'x ruq'uin tri' c'o wi' ja rewanma chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ja panewach cani' rbanic jun luz ixrya'on pa sak, ja wi mta rbanon wi ma yojtajnak ta jari' pa luz c'a c'o wari' ja recuerpo pro ni chi jun. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pro ja c'a wi yojtajnak jari' pa k'eku'm c'a c'o wari' ja recuerpo pro ni chi jun. In queri' c'a tre ja luz ja yatajnak chewe pa tak ewanma, ja wi nchupi jari' congana jun nimlaj k'ekumal nixq'ueje' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jun winak xa nak ta chi winakil ni majun moda xqueq'ueje' ta ca'i' rpatrón, ja queri' jun nrajo' in jun xa itzel nutz'at owi jun nnimaj in jun matinimaj. In queri' c'a tre chakaja' mta moda xtiyuke' ta ec'u'x ruq'uin Dios in xtiyuke' chi ta ec'u'x ruq'uin ja meba'il xin rwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Rmalc'ari' ja tok nbij chewe, maxta tek'isaj ewi' tre ja rec'aslemal: —¿Nak nkatij chi c'awa'? maxta quixche'e, in nixtac'a ja nc'atzin tre ja recuerpo chakaja': —¿Nak nkacoj chi c'awa'? maxta quixche'e. Ja Dios arja' nuya' nojelal ja nc'atzin tre ja rec'aslemal in tre ja recuerpo ¿la matuya' c'ari' chewe chakaja' ja netij in ja necoj? ");
INSERT INTO tzjNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","¿La maque'etz'at c'a ja tak tz'iquin ja nerupup chicaj? Eje'e' nixtac'a c'o ta tijco'm nquetic in nixtac'a c'o ta cosecha nquec'ol pro ja Tatixel ewxin ja c'o chila' chicaj arja' ntzuku quixin. Pro ¿la ma ixix ta c'a ja más na ix vale chiquewach ja tak tz'iquin? ");
INSERT INTO tzjNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","In jun chic, ni majun chewe masqui congana nk'isaj ri' ncowin ta ruyon nuya' ta rq'uiybal nel ta más nim rkan. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","In tre ja tziak ¿nak c'a tre tok nek'isaj ewi' rmal ja necoj? Tewasaj mpe' ena'oj trij ja cotz'i'j nak nuban tok nq'uiyi pa tak k'ayis pro matisamaji in matik'inoni. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ja c'a ranin nbij chewe camic, ja rojer rey Salomón masqui congana biyom pro mta rtziak xucoj ta ja más buena ta chwach rcoloril jun trewa' jule' cotz'i'j ri'. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ja cotz'i'j masqui xa ncami, masqui xa nchakiji chanim in nporox pa k'ak' pro ja Dios arja' nuya' rcoloril. Ja wi queri' nuban ¿la matuya' c'ari' chewe chakaja' ja retziak necoj? Xarwari' nbij chewe, ma kas ta yukul ec'u'x ruq'uin ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Rmalc'ari' nbij chewe, ma tek'isaj ta ewi': —¿Nak nkatij c'awa'? maxta quixche'e in: —¿Nak nkacoj c'awa'? maxta quixche'e chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Queri' nbij chewe como ja winak ja ma cotak ta rwach ja Dios eje'e' ri' ja nebano queri'. Ja c'a chewe ixix, ja retata' Dios ja c'o chila' chicaj arja' bien rotak chi nc'atzin chewe nojel awa' wari'. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pro ja kas rjawaxic chi neban nabey, ja gobierno xin Dios ni ta ja wari' nech'ob in ja rutzil xin Dios chakaja'. Ja wi queri' neban nojel awa' ja nc'atzin chewe nyataj chewe. ");
INSERT INTO tzjNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Rmalc'ari' nbij chewe, maxta tek'isaj ewi' rmal ja penak chewach xin chwak cabij. Ja wi c'oli ja problema xin chwak, xin chwak c'ari', maxta tec'am camic. Ja jujun k'ij sobre ja problema chipan. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Maxta quixoc ix cani' k'etol tak tzij chiquij ja winak utzc'a chi ja Dios matuk'et tzij chewij ixix chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Queri' nbij chewe como ja necoj chiquij ja winak chi nek'etbej tzij chiquij jari' noc chewij ixix chakaja'. Cani' neban chique ja winak queri' nuban ja Dios chewe ixix chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Nak tre tok neya' cuenta tre jun ti ril nuban ja rewach'alal pro mateya' cuenta tre jun nimlaj ewil neban ixix? Ja tok neban queri' jari' cani' neya' cuenta tre jun ti rc'utal che' ja c'o parwach ja rewach'alal pro mateya' cuenta tre jun nimlaj che' ja c'o panewach ixix. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","In chakaja' nak moda nebij tre ja rewach'alal: —Wach'alal, taya'a' lugar chake chi nkaya' jun consejo chawe tre ja il mac ja c'o pan ac'aslemal, nixche' tre, pro más na nim ja il mac c'o pan ec'aslemal ixix. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ja queri' xa caca' epalaj ja neban. Ja wi newajo' neya' consejo tre ja rewach'alal rjawaxic nabey chi neya' can ja ritzelal ja c'o chipan ja rec'aslemal ixix utzc'a chi nixcowini neya' utzlaj tak consejo tre ja rewach'alal. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ja xin Dios maxta teya' chiquewach winak ja xa e cani' tz'i'. Ja rtzobal Dios cani' jule' abaj ja congana nimak rjil maxta teya' chiquewach winak ja xa e cani' ak, matzij xa tiqueban tre ni mta, ja queri' cani' nquepak' chi cakan, matzij nebe chewij cani' nqueban tz'i' natqueti'. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tec'utuj tre ja Dios ja nc'atzin chewe in arja' nuya' chewe, tecanoj ja newajo' in newil, tec'onc'o'oc ja chi'jay in nja̱k chewach. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Queri' nbij chewe como canojel ja nec'utuni nyataj chique in ja necanoni nyataj chique chi nquewil in ja nec'onc'onoc ja chi'jay nja̱k chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","O ¿la c'ol on jun tatixel chewe tok nc'utux jun caxlanway tre rmal jun ti rc'ajol la nuya' jun abaj pa ruk'a'? ");
INSERT INTO tzjNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Owi nc'utux jun ch'u' tre ¿la nuya' jun cumatz tre? ");
INSERT INTO tzjNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ixix masqui ix lawulo' pro ewotak neya' utzlaj tak nakun chique ja rewalc'wal pro pior c'a ja Tatixel ewxin ja c'o chila' chicaj arja' nuya' utzlaj tak nakun chique ja nec'utun tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Queri' c'a rbanic, xa nak ta neyarij chique winak chi nqueban chewe queri' c'a tebana' ixix chique chakaja' como queri' nuc'ut chikawach ja rtzobal Dios ja tz'ibtal can chipan ja ley in cumal ja profeta. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","C'o jun pa rchi'jay ja congana ti latz' xarwari' nixerya'a' chipan ja utzlaj c'aslemal ja mta q'uisic trij, jari' pa rchi'jay chipan quixoc wi'. Queri' nbij chewe como c'o chi na jun ja pa rchi'jay congana nim in natruya' chipan jun bey congana nim rwach chakaja', ma c'ayew ta natoc chipan xarwari' nixerya'a' chijutij chipan ja nimlaj rpokonal, jari' pa rchi'jay e q'uiy ja winak ja ne'oc chipan. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Queri' nbij chewe como ja pa rchi'jay ja nixerya'a' chipan ja utzlaj c'aslemal jari' congana ti latz' in natruya' chipan jun bey congana c'ayew in xa ma e q'uiy ta ja newilowi. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tebana' cuenta ewi' chiquewach ja winak ja profeta neche'xi, pro ma katzij ta chi e profeta. Eje'e' tok ne'ekaj ewq'uin nquik'alasaj qui' chewach chi majun nak ta itzel nqueban chewe, e cani' tak carnelo netz'ati pro ja pa tak canma e cani' utiwa' ja maxco' chi camíc nqueban. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Cani' tre jun che', rumac ja rwach nuya' tri' nawotakij wi' nak chi che'al in queri' c'a chique winak chakaja', rumac ja natz'at pa tak quic'aslemal tri' nawotakij wi' nak quibanic. Ta c'a ja q'uix mta moda xtiwachij ta uva nixtac'a rxulquiej xtiwachij ta higo. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Queri' c'a rbanic, nojel ja utzlaj tak che' utz rwach nuya' in nojel ja ritzel tak che' itzel rwach nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ja utzlaj che' mta moda xtuya' ta itzel rwach nixtac'a ja ritzel che' xtuya' ta rwach utz. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nojel ja che' ja ma utz ta rwach nuya' jari' nchoyi in nporox pa k'ak'. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Queri' c'a quibanic ja winak, rumac ja natz'at pa tak quic'aslemal tri' nawotakij wi' nak quibanic. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ja winak ja nebin chwe: —Kajaw, Kajaw, neche' chwe, eje'e' ma canojel ta nyataj chique chi ne'oc chipan ja gobierno xin chila' chicaj pro ja nyataj chique chi ne'oqui eje'e' ri' ja netajini nquinimaj ja Nata' ja c'o chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ja c'a tok xterila' ja nimlaj k'ij xin juicio e q'uiy ja winak quewa' xtiquibij chwe ri': —Kajaw, Kajaw ¿la ma pan abi' ta c'a kaya' rbixic ja rtzobal Dios, la ma pan abi' ta c'a xekawasajel demonio pa tak canma ja winak in la ma pan abi' ta c'a chakaja' kaban nimak tak milagro? xqueche' na chwe. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ja c'a ranin quewa' xtinbij chique ri': —Anin ni ma xinwotakij ta wi' ewach, quixel chinwach ix banol tak itzelal, ninche' na chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Xa nak ta ja nec'axani ja nmajon rbixic in wi nquinimaj ja nbij chique chi nqueban, eje'e' quewa' quibanic ri', e junan ruq'uin jun achi congana rna'oj, xuban jun rochoch in parwi' abaj xtz'uba' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xumaj c'a jun nimlaj k'ekaljab, q'uiyi ja rkan tak ya' in jaktajto jun nimlaj ik'. Ja jay lawulo' ban tre rmal pro ma xbe ta pa tok'ulew como parwi' abaj tz'ubul wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","In xa nak ta nec'axani ja nmajon rbixic in wi matiquinimaj ja nbij, eje'e' quewa' quibanic ri', e junan ruq'uin jun achi xa ma ch'obolic achi ta, xuban jun rochoch in xa parwi' snayi' xtz'uba' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xumaj c'a jun nimlaj k'ekaljab, q'uiyi ja rkan tak ya' in jaktajto jun nimlaj ik'. Ja jay lawulo' ban tre rmal in be pa tok'ulew, xajutij yojtaji ja jay. Queri' xbij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ja Jesús tok bitaj rmal nojelal ja tzij ja c'a winak kas c'asc'o'i quic'axaj ja tijonem nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Queri' queban ja winak como ja tijonem nuya' chique congana nerusil, bien k'alaj chi ruq'uin Dios penak wi' ja nbij, ma junan ta ruq'uin ja tijonem ja nqueya' ja maestro ja netijon quixin ja winak tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ja c'a Jesús xule'to chwach ja jayu', ja c'a tok kajto congana e q'uiy ja winak xetre' trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Chaka jalal tok c'o jun yawa' xekaj ruq'uin ec'o jule' itzel tak ch'a'c trij, xuque' chwach in xbij tre: —Wajaw, ja wi nawajo' ninatzursaj, anin wotak chi natcowini ninatzursaj, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ja c'a Jesús xuyuk pon ja ruk'a', xuchap ja yawa' in xbij tre: —Can nwajo' ja cani' nabij chwe, cattzuri, ne' tre, in ni chanim xeli ja ritzel tak ch'a'c trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","In xbij chic tre: —Majun bar ta tri' nabij wi' ja xinban chawe. Xar ja naban, jat, jac'utu' awi' chwach ja sacerdote in jaya'a' ja rofrenda ja cani' rbin can ja Moisés chipan ja ley xin Dios chi naban. Ja c'a rofrenda naya' jari' noc testimonio chiquewach ja sacerdote chi naban cumplir ja rbin can ja Moisés, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ja Jesús tok xekaj chipan ja tinamit Capernaum c'o jun capitán quixin soldado xekaj ruq'uin in quewa' xbij tre ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Wajaw, c'o jun nmoso c'o chi wochoch, arja' siquirnak in congana lawulo' nuban rmal, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Can ninbe ruq'uin chi nentzursaj, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pro ja capitán arja' xbij chic tre: —Wajaw, atat janila nim ak'ij, ma yatal ta chwij chi xcatoc ta chipan ja wochoch, xar ja nwajo' chawe, tabij chi ntzuri ja nmoso in wotak chi xa ruq'uin ari' ntzuri. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Queri' nbij chawe como anin bien wotak nak rbanic ja tok natban mandar. Ec'oli ja nebano mandar wxin in chakaja' ec'oli soldado pa nuk'a' anin chi nenuban mandar. Ja tok nbij tre jun chi: —Cateli, ninche' tre, jari' ni nel wari'. Ja c'a wi nbij chi: —Catajo', ninche' tre jun chic, jari' ni npi wari'. Ja c'a wi nbij tre ja nmoso chi: —Tabana' ja wari', ninche' tre, jari' ni nuban wi'. Queri' xbij ja capitán. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ja c'a Jesús congana c'asc'o'i xc'axaj ja tzij ja bix tre rmal ja capitán in como ec'o jule' winak ja retran trij quewa' xbij chique ri': —Ni katzij wi' ja xtinbij chewe ri', ja capitán arja' más chi na k'axnak ja yukulbal ruc'u'x wq'uin chewach ixix ja rix wach tak aj Israel, nixtac'a c'o ta jun chewe nwilon ta ja queri' ta ja yukulbal ruc'u'x wq'uin ja cani' rxin arja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Camic nbij chewe chi e q'uiy ja winak ja ma e aj Israel ta nepi na nojel nat nakaj, ne'oc na chipan ja gobierno xin chila' chicaj in netz'abe' chi mesa, junan newa' cuq'uin ja rAbraham, ja rIsaac in ja Jacob. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pro ja c'a ralc'walaxela' ja tzujux chique ja gobierno xin chila' chicaj nabey eje'e' xa neq'uia̱kel chipan ja nimlaj k'ekumal. Ja c'a winak janila chi ok'ej xtiqueban chipan ari' lugar in xtiquicach'ach'ej cak'. Queri' xbij ja Jesús chique ja winak ja retran trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","C'ac'ari' xbij chic tre ja capitán: —Camic jat, in como yukul ac'u'x wq'uin chi nincowini ntzursaj ja ramoso in queri' ja nbantaji, ntzuri, ne' tre. In ni jari' hora tzuri ja moso. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","C'ac'ari' be ja Jesús chi rochoch ja Pedro. Ja c'a tok xekaji xoc pa jay in xutz'at ja rji'te' ja Pedro c'o chwa ch'at yawa', majtajnak rmal c'atan. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xuchap chi ruk'a' in xeli ja c'atan. Yictaji ja rixok in xumaj quilixic ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ja c'a tok xoc ak'a' e q'uiy ja winak xec'amarel ruq'uin ja Jesús, ec'ol itzel tak espíritu e'ocnak pa tak canma. Ja c'a Jesús xa jun ja tzij xbij in jari' tzij xerlasbej ja ritzel tak espíritu pa tak canma in xertzursaj canojel ja yawa'i' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Queri' xuban utzc'a chi tri' bantaj wi' cumplir ja bitajnak can rmal ja profeta Isaías quewari': —Arja' xrijkajel ja nokti'on je'e rmal in xoc chuxe' ja kayobilal, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ja c'a Jesús tok xerutz'at chi congana winak quimolon qui' trij, arja' xbij chique ja rdiscípulo: —Jo' chajuparaj ya', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","C'o c'a jun achi arja' jun chique ja maestro ja netijon quixin ja winak tre ja ley xin Dios, xekaj ruq'uin ja Jesús in quewa' xbij tre ri': —Maestro, anin can ninbe chawij xa bar ta tri' natbe wi', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","In bix tre rmal ja Jesús: —Ja rutiwa' c'o quic'olibal ja bar newar wi' in chakaja' ja tak tz'iquin c'o quesoc pro ja chwe anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak mta wochoch ja ni ta wxin wi' anin ninwar wi', ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","In pi chic jun chique ja rdiscípulo, quewa' xbij tre ri': —Wajaw, taya'a' lugar chwe chi nenmuku' can paki na ja nata' nabey, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","In bix tre rmal ja Jesús: —Jo' cattre' chwij, ja c'a re camnaki' chwach Dios eje'e' na quemuku quixin ja necam je'e chique, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ja c'a Jesús arja' xoquel chipan ja lancha e rachbil ja rdiscípulo in xebe. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","In chaka jalal tok jaktajto jun nimlaj ik' chiquij. Ja c'a lancha lawulo' nba̱n tre rmal ja nimak tak baloj pro ja c'a Jesús kajnak chi waram. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ja c'a rdiscípulo quec'as: —Ko'ato'o' Kajaw, camic nokcami, nokbe pa ya', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","—¿Nak tre tok nexbej ewi'? taka'an xa ma nim ta ja yukulbal ec'u'x wq'uin, xeche'xi rmal ja Jesús. C'ac'ari' yictaji ja Jesús, xuk'il ja ik', xuk'il ja ya' chakaja', ni chanim cami ja ik' in sile'e ja ya'. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ja c'a rdiscípulo congana c'asc'o'i quetz'at ja bantaji in quemaj rbixic chibil tak qui': —¿Nak rbanic c'ala' ja rachi le'? nnimax taka'an rmal ja ik', nnimax taka'an rmal ja ya' chakaja', xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ja c'a Jesús tok xekaji chajuparaj chic ya' tri' xekaj wi' chipan jun lugar ja c'o pa quicuenta ja raj Gadara. Ec'o c'a ca'i' winak, eje'e' e'ocnak itzel tak espíritu pa tak canma, xe'elto pa comsanto, xurquic'ulu' ja Jesús. Eje'e' e xbebel tak ri'il, ni majun winak nk'ax ta tri' ja bar ec'o wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chaka jalal tok quemaj rakic quechi' trij ja Jesús: —Atat ja rat Ralc'wal Dios ¿nak nawajo' chake? ¿La maxta atpenak chi nokarya'a' chipan ja nimlaj rpokonal? pro maja'n wa'an turila' tiempo rxin, xeche' tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ec'o pon c'a jule' ak congana e q'uiy quimajon wa'im. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ja c'a ritzel tak espíritu eje'e' congana quecoj ja Jesús pa ch'a'oj in quewa' quibij tre ri': —Ja wi nokawasajel taya'a' lugar chake chi nokoc pa quicuerpo ja jule' ak le', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Jix, xeche'xi rmal ja Jesús. Queri' queban xe'eli, xe'oc pa quicuerpo ja ak. Ja c'a ak chaka maril xe'oqui ja ritzel tak espíritu chique, eje'e' quemaj c'amc'oj canim, xebe, xexule' chwach jun jayu' congana tiquitic, xebe c'a pa ya' in tri' xejik' wi' canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ja c'a chajil quixin eje'e' xe'anmajel, xebe chipan ja tinamit, xequicholo' nojel ja bantaji in nak queban ja re ca'i' winak ja re'ocnak itzel tak espíritu chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ja c'a tinamit xepeti pro ni canojel, xurquic'ulu' ja Jesús. Ja tok quec'ul quewa' quibij tre ri': —Catelel wawe', taya'a' can ja kalugar, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","C'ac'ari' ja Jesús xoquel chic chipan ja lancha, be chic chajuparaj ya', be chipan ja rtinamit arja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ja c'a tok xekaji chaka c'a jalal tok c'o jun achi xeya̱' chwach siquirnak, cotz'ol chwach jun ch'atan che'. Ja c'a Jesús tok xutz'at ja yukulbal quec'u'x c'o ruq'uin, arja' xbij tre ja siquirnak: —Nc'ajol, ma taxbej ta awi', camic cuytaji ja rawil amac, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ec'o c'a jule' maestro ja netijon quixin ja winak tre ja ley xin Dios, ja tok chaka maril quic'axaj ja xbij ja Jesús quewa' quibij pa tak canma ri': —Ja xbij ja rachi le' jala' xa ofensa rc'amonto tre ja Dios, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pro ja Jesús arja' bien rotak ja netajini nquech'ob kaj pa tak canma in xbij chique: —¿Nak tre tok xa itzel ja nech'ob kaj pa tak ewanma? ");
INSERT INTO tzjNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Camic nwajo' nc'waxaj chewe ¿nak ja más c'ayew tre ja ca'i' ri', la ja' nbij tre ja rachi chi ncuy ja ril rumac o la ja' nbij tre chi nyictaji in nbe? ");
INSERT INTO tzjNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Anin c'oli ja xtinban chewach camic ri' utzc'a chi newotakij chi anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak yatajnak chwe chi ncuy ja quil quemac ja winak wawe' chwach'ulew, ne'e ja Jesús chique. C'ac'ari' xbij tre ja siquirnak: —Catyictaji, tac'ama'el ja rawarbal in jat chi awochoch, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","In queri' xuban, yictaji in be chi rochoch. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ja c'a winak eje'e' congana c'asc'o'i quetz'at ja xuban ja Jesús in quemaj rya'ic ruk'ij ja Dios rmal. Como ja Dios arja' pa ruk'a' jun winak rya'on wi' jawa' nimlaj poder ja quetz'at ri' chewi' tok queya' ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ja Jesús be chic, kas c'a rmajon binem ja tok c'o jun achi xutz'at rbina'an Mateo. Ja c'a Mateo arja' tz'ubul chipan ja lugar ja bar nto̱j can wi' ja rimpuesto pa ruk'a'. Ja Jesús tok xekaj ruq'uin quewa' xbij tre ri': —Jo', cattre' chwij chi natoc ndiscípulo, ne' tre. Ja c'a Mateo yictaji in tre'el trij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ja c'a Jesús arja' c'o pa jay, tz'ubul pa mesa tok chaka jalal e q'uiy ja molol tak impuesto xe'ekaj ruq'uin e cachbil jule' chic aj'il ajmaqui' neche'xi. Eje'e' xetz'abe' ruq'uin ja Jesús pa mesa e rachbil ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ec'o c'a jule' fariseo, eje'e' tok xequetz'at ja winak ja xetz'abe' pa mesa ruq'uin ja Jesús quewa' quibij chique ja rdiscípulo ri': —¿Nak c'a tre tok ja remaestro ixix nwa' cuq'uin ja jule' molol tak impuesto le' in nwa' cuq'uin chakaja' ja jule' chic aj'il ajmaqui' le'? xeche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pro ja c'a Jesús ja tok c'axtaj rmal ja quibij quewa' xbij chique ri': —Ja ma e yawa'i' ta eje'e' matic'atzin jun doctor chique pro ja yawa'i' jari' ni rjawaxic wi' jun doctor chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jix, mejor ja neban, tetijoj ewi' trewa' ja jun rtzobal Dios ja xtinbij chewe ri': —Ja kas nwajo' chewe chi neban, tepokonaj quewach ja winak, jari' más chi na nc'atzini chwach ja netzujuj jule' sacrificio chinwach, queri' nbij ja Dios. Jawa' tzij xinbij chewe como anin inpenak chi ne'uncanoj ja raj'il ajmaqui' utzc'a chi nqueya' can ja quil quemac, ma eje'e' ta ja ch'ajch'oji' chic ja ne'uncanoj. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ja c'a rdiscípulo ja Juan Bautista eje'e' xe'ekaj ruq'uin ja Jesús in quewa' quibij tre ri': —¿Nak tre ja radiscípulo atat taka'an matiqueban ja rayuno? pro ja rajoj ni nkaban wi' ja rayuno in ja fariseo eje'e' nqueban chakaja', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ja c'a Jesús arja' xbij chique: —Cani' chique jule' winak ebanon invitar tre jun c'ulbic, ja tok c'a c'o na ja rachi chiquicojol ja nc'ule'e ¿la yatal chiquij chi nqueban ayuno nech'ob ixix? Pro nerila' na jun k'ij ja tok eje'e' xtilasax chiquicojol ja rachi ja nc'ule'e, c'a tokoc'ari' tok xtiqueban ja rayuno. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mta jun nak ta xtuc'am ta jutz'it chi' tziak c'ac'a xtic'ojbej ta jun tzabuklaj tziak. Ja wixta queri' nbani ja chi' tziak c'ac'a nuc'ol ri' in xa jani' ntak'e' más ja bar tak'al wi' tre ja tzabuklaj tziak. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","In chakaja' cani' tre vino c'ac'a matic'ol pa tzabuklaj tak c'olbal. Ja wixta queri' nbani ja c'ac'a vino nurak ja c'olbal in ntixi in ntz'iloxi ja c'olbal chakaja'. Pro ja nbani, ja c'ac'a vino nc'oli chipan c'ac'a tak c'olbal in nuto' ri' chi ca'i', nixtac'a vino in nixtac'a c'olbal ntz'ilox ta. Queri' xbij ja Jesús chique tre ja c'ac'a tijonem ja rc'amonto. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ja Jesús arja' c'a rmajon na rbixic ja tzij chique ja tok c'o jun jefe xurkaj ruq'uin, xuque' chwach in xbij tre: —C'o jun nme'al c'a cam kaj pro ja c'a nwajo' chawe chi naban, jo' chwij, jaya'a' ak'a' pa rwi' in wotak chi nc'astaj rwach ja nme'al, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yictaji ja Jesús, tre'el trij ja jefe in xerachbilajel ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Chaka c'a jalal tok c'o jun ixok yawa' xekaj ruq'uin. Ja nti'on tre ja rixok tuban cablajuj juna' ni c'o wi' je'e quic' nel tre. Ja c'a xuban ja rixok xa jani' tiloc más trij ja Jesús. Ja c'a tok xekaj ruq'uin xuchapoc jutz'it ruchi' ja rtziak. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Queri' xuban como ja ntajini xbij kaj pa ranma: —Ja wi xtinchap ja rtziak ja Jesús xa ruq'uin ari' wotak chi nintzuri, ne' kaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ja c'a Jesús arja' xuya' vuelta in tok xutz'at ja rixok quewa' xbij tre ri': —Ma taxbej ta awi' nme'al, ja yukulbal ac'u'x wq'uin jari' xattzursani, ne' tre. In ja rixok ni jari' hora tzuri. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ja c'a Jesús tok xekaj pa rochoch ja jefe ec'o jule' winak xerutz'at quimajon rbanic xul e cachbil jule' chic winak congana jun síc' nqueban ");
INSERT INTO tzjNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","in xbij chique: —Quixeli, ja xtan ma camnak ta, xa waram rbanon, ne' chique. Pro ja reje'e' xa quitzebej ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ja c'a Jesús ja tok xelastajto rmal ja winak arja' xoqui ja bar c'o wi' ja camnak, xuchap chi ruk'a' in yictaji ja xtan. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jawa' bantaji ri' xel rbixic nat nakaj chipan ari' lugar. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ja Jesús be chic, rmajon binem. Ec'o c'a ca'i' moya' etran trij, eje'e' quemaj rakic quechi' trij ja Jesús: —Atat ja rat Ralc'wal can ja rojer rey David, tapokonaj jutz'it kawach, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ja Jesús arja' xoc pa jay in xe'ekaji ja moya' ruq'uin in bix chique rmal: —¿La nenimaj chi anin nincowini nixntzursaj? xeche'xi. —Can Kajaw, kotak chi natcowini nokatzursaj, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ja c'a Jesús arja' xuchap ja quewach in xbij chique: —Como c'o yukulbal ec'u'x wq'uin, camic njaktaji ja rewach, ne' chique, ");
INSERT INTO tzjNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","in queri' queban, jaktaji quewach. Ja c'a Jesús xbij chic chique: —Congana nban recomendar chewe, majun bar ta tri' nebij wi', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pro ja c'a reje'e' xe'eli, quemaj rtzijoxic nojel nat nakaj chipan ari' lugar ja ban chique rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kas elem nqueban ja Jesús ja tok chaka jalal c'o jun achi mem xeya̱' chwach, c'o jun itzel espíritu ocnak tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ja c'a Jesús xlasajel ja ritzel espíritu tre ja rachi in ni jari' hora xumaj tzij. Ja c'a winak congana c'asc'o'i quetz'at in quewa' quibij ri': —Ni majutij bantajnak ta ja quewari' chipan ja katinamit Israel, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pro ja c'a fariseo eje'e' quewa' quibij ri': —Xa poder rxin ja jefe quixin ja ritzel tak espíritu xa jari' nucoj chi quilasaxic ja ritzel tak espíritu, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ja Jesús arja' be nojel tinamit in nojel tak aldea chakaja', nertijoj ja winak pa tak jay xin molbal ri'il, nuya' rbixic chique ja utzlaj tzij tre ja gobierno xin chila' chicaj in chakaja' ec'oli ja yawa'i' nertzursaj xa nak ta nti'on chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ja tok xerutz'at chi congana e q'uiy ja winak arja' xpokonaj quewach como eje'e' congana lawulo' quibanon, e cani' jule' tak carnelo echictajnak, mta nyuk'un quixin. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","C'ac'ari' xbij chique ja rdiscípulo: —Ni katzij wi' nbij chewe, ja winak eje'e' e cani' jun nimlaj tijco'm ja k'en chic ja utz chic nba̱n cosechar pro ja rajsamajela' ja nebano cosechar quixin xa ma e nim ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Rmalc'ari' nbij chewe, tebana' orar, tec'utuj tre ja Rajaw ja cosecha chi nerutakto ja rajsamajela' chi ne'urquibana' cosechar ja winak, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ja c'a Jesús arja' xersiq'uij ja cablajuj discípulo in xuya' chique chi c'o quek'a' chique ja ritzel tak espíritu chi necowini nequiwasajel chique ja winak in xuya' chique chakaja' chi necowini nequitzursaj yawa'i' xa nak ta nti'on chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ja quebi' ja cablajuj apóstol quewari', ja nabey, Simón ja c'o chic jun rubi' Pedro, Andrés ja rch'alal Simón, Jacobo ja rc'ajol Zebedeo, Juan ja rch'alal Jacobo, ");
INSERT INTO tzjNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo ja molol impuesto, Jacobo ja rc'ajol Alfeo, Lebeo ja c'o chic jun rubi' Tadeo, ");
INSERT INTO tzjNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, jun chique ja partido rbina'an cananita, in Judas Iscariote ja jachowi ja Jesús pa quek'a' ja xetzelan rxin. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ja c'a Jesús arja' xerutakel ja cablajuj discípulo in bien xuch'obel chiquewach nak ja xtequibana': —Ma tec'amel ta je'e ja bey ja nbe cuq'uin ja winak ja ma e aj Israel ta in chakaja' ni majun tinamit quixin aj Samaria xquixoc ta chipan. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ja nixbe wi', jix cuq'uin ja raj Israel ja re cani' jule' tak carnelo etzaknak. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Chipan ja viaje xteban nijawawa' xteya' rbixic chique ja winak ri': —Xa nnakajinto ja gobierno xin chila' chicaj, quixche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Que'etzursaj yawa'i' in que'etzursaj ja c'o itzel tak ch'a'c chiquij chakaja', que'eyica' camnaki' chipan ja camíc in que'ewasajel itzel tak espíritu chique ja winak. Como ja poder xinya' chewe ri' xa xecochij chwe rmalc'ari' nbij chewe, maxta tec'utuj pwok chique winak tok necoj ja poder chi quito'ic. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ni majun pwok nec'amel tok xquixbe. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nixtac'a nec'amel ta emaleta in ni xa ja wari' ja recamisa nec'amel ja recojon, ma ca'i' ta, in ma ca'i' c'ulaj ta exajab in ma ca'i' ta ech'ame'y. Queri' nbij chewe como jun ajsamajel yatal tre chi nya̱' tre ja ntzukbej ri'. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Xa nak ta chi tinamital nixoc wi' in xa nak ta chi aldea'il, tri' necanoj wi' jun winak ja yatal trij chi ixix nixq'ueje' ruq'uin in tri' nixq'ueje' wi', c'a tokori' nixelel ruq'uin ja tok nixbe chic cha jun chic tinamit. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ja tok nixoc chipan ja jay quewa' nebij ri': —Ja quicotemal xin Dios tiq'ueje' pan ewochoch, quixche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ja winak wi yatal chiquij chi nixq'ueje' cuq'uin xtiq'ueje' ta cuq'uin ja quicotemal xin Dios ja rec'amonel chique. Nowi ma yatal ta chiquij chi nixq'ueje' cuq'uin matiq'ueje' c'ari' chakaja' ja quicotemal xin Dios cuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","In xa nak ta ja maquec'ulu ewxin, xa nak ta ja mta quigana nquic'axaj ja nebij chique, ja c'a tok nixelto pa jay cuq'uin owi pa tinamit tequiraj can ja pokok ja c'o pan ewakan. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ni katzij wi' ja nbij chewe ri', ja tok xterila' ja nimlaj k'ij xin juicio congana lawulo' tre ja tinamit ja maquec'ulu ewxin, más na lawulo' ja rpokonal xtiquetij chwach ja xtiquetij ja ritzel tak winak ja raj Sodoma in Gomorra ojer. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Camic tec'ama'el ja bey, bien tewotakijel chi ixix ix cani' jule' tak carnelo in ja winak ja bar nixnutakel wi' eje'e' e cani' utiwa'. Quixq'ueje' listo cani' nuban jun cumatz ncowini nuto' ri' xarwari' tebana' ix manso cani' nuban jun palomax. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tebana' jutz'it cuenta ewi' chiquewach ja winak como eje'e' nixquec'amel na pa tak k'etbaltzij in nixquirapaj chakaja' pa tak jay xin molbal ri'il quixin. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nixquec'amel chiquewach gobernador, nixquec'amel chiquewach rey pro mwal anin tok xtiban queri' chewe. Queri' xtiban chewe utzc'a chi nel ntzijoxic chiquewach eje'e' in chiquewach ja winak ja ma e aj Israel ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pro ja c'a tok xquixc'amarel chiquewach maxta quixocla' il tre ja nebij ja netobej ewi' chiquewach como jari' hora nyataj chewe nak ja nebij chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Queri' nbij chewe como ma ixix ta nixtzijoni tri' pro ja rEspíritu Santo arja' nyo' chewe nak ja xtebij chique, jari' Espíritu rxin ja Dios ja Tatixel ewxin. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ja xtiqueban ja ralaxic chique ja cach tak alaxic nequejach na pa camíc in queri' xtiqueban ja tatixela' chakaja' chique ja calc'wal in chakaja' ja ralc'walaxela' eje'e' neyictaj na chiquij ja tatixela' in nequejach na pa camíc. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ja c'a rixix xa itzel nixtz'at na cumal canojel ja winak pro mwal anin ja tok xtiban queri' chewe. Pro canojel ja xtiquecoch' quewach chipan ja rpokonal in ni matiqueya' can wi' ja yukulbal quec'u'x wq'uin eje'e' ri' nquewil na ja totajem xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ja c'a tok nba̱n pokon chewe chipan jun tinamit quixanmaji, jix chic cha jun chic tinamit. Queri' nbij chewe como ni katzij wi' ja xtinbij chewe ri', ja tok maja'n quixk'ax chipan nojel ja tinamit ja c'o pa rcuenta Israel can ninpi chic jutij, anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mta jun discípulo nim ta ruk'ij chwach ja rmaestro in chakaja' mta jun ajsamajel nim ta ruk'ij chwach ja rpatrón. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ja c'a nuban ja discípulo mejor, queq'ueje' conforme chi nba̱n chique ja cani' nba̱n tre ja quimaestro, in ja rajsamajela' chakaja' mejor, queq'ueje' conforme chi nba̱n chique ja cani' nba̱n tre ja quipatrón. Anin in Epatrón in como quibij chwe chi anin in jefe quixin ja demonio pior c'a ja chewe ixix, congana nixquitzelaj na chakaja' ja rix ajsamajela' wxin. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Rmalc'ari' nbij chewe, ma texbej ta ewi' chiquewach. Queri' nbij chewe como nojel ja ma k'alajinnak ta je'e jari' nerila' na jun k'ij tok xtik'alajini in nojel ja rawatal je'e jari' nel na pa sakil, notakix na. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nojel ja nbij chewe tok xa kayon kaj jari' tek'alasaj, tewasaj pa sakil, teya'a' rbixic chiquewach ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma texbej ta ewi' chiquewach ja winak ja xa ruyon ecuerpo necowini nquicamsaj pro ja rewanma jari' maquecowini nquicamsaj. Pro ja nexbej wi' ewi', chwach ja ncowini nuya' ja rewanma chipan ja nimlaj rpokonal pa k'ak' rachbil ecuerpo. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ja tak tz'iquin ja tok nec'ayixi xa jun ti centavo neya̱' wi' ja re ca'i'. Pro masqui xa e tak barata pro nixtac'a c'o ta jun chique ja chaka ta ncami, ni maquecam wi' ja maquita rvoluntad Dios chi necami in jari' Dios arja' Tatixel ewxin. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","In ja c'a chewe ixix mta moda xquixrmestaj ta ja Dios, ja rsamal ewí' rajlan chijujunal. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Rmalc'ari' nbij chewe, ma texbej ta ewi', más na ix vale chiquewach jun nimlaj moc tz'iquin. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ja winak xa nak ta chi winakil wi matiquipokonaj nquibij chi wq'uin anin yukul wi' quec'u'x pro wi ni chiquewach ja winak nquibij wi', anin chakaja' can nbij na chique chi ec'o pan ncuenta pro ni chwach ja Nata' ja c'o chila' chicaj xtinbij wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pro ja winak xa nak ta chi winakil wi nquipokonaj nquibij chiquewach ja winak chi wq'uin anin yukul wi' quec'u'x, anin chakaja' nbij na chique chi ma ec'o ta pa ncuenta pro ni chwach ja Nata' ja c'o chila' chicaj xtinbij wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Maxta tech'ob chwij chi anin xa quicotemal nc'amonto wawe' chwach'ulew. Mni, ma rmal tari' tok inpenak. Ma rmal ta chi xa xquequicoti ja winak chibil tak qui' tok inpenak pro rmal chi nqueban ch'a'oj mwal. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ja rala'i' eje'e' nech'ojin na cuq'uin ja quitata' in ja xtani' eje'e' nech'ojin na cuq'uin ja quete' in ja ralibotz eje'e' nech'ojin na cuq'uin ja calite'. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Queri' ja nbantaj na, ja rc'ulel jun winak ni pa rochoch arja' neyictaj wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ja winak ja más na necajo' ja quitata' chinwach anin owi quete', eje'e' ma yatal ta chique xque'oc ta ndiscípulo. Ja winak ja c'o jun calc'wal ja más na ncajo' chinwach anin, eje'e' ma yatal ta chique xque'oc ta ndiscípulo chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ja winak ja nquipokonaj netre'el chwij, ja nquipokonaj nquetij rpokonal ja cani' nutij rpokonal jun achi rmajon rijkaxic jun cruz, eje'e' ma yatal ta chique xque'oc ta ndiscípulo chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ja winak ja nquipokonaj nqueya' can ja quic'aslemal jari' nquitz'ila' ja utzlaj c'aslemal ja mta q'uisic trij. Pro ja winak ja matiquipokonaj nqueya' can ja quic'aslemal mwal anin jari' nquewil na ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ja winak ja nec'ulu ewxin, anin c'ari' ja ninquec'ul in ja winak ja nec'ulu wxin, Nata' c'ari' ja takyonto wxin ja nquec'ul. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ja winak ja c'o jun profeta xin Dios nekaj cuq'uin, wi nquec'ul in wi rumac chi profeta xin Dios chewi' tok nquec'ul, jari' nyataj na chique jun rtojbalil ja cani' nyataj chique ja profeta. In chakaja' ja winak ja c'o jun utzlaj winak nekaj cuq'uin, wi nquec'ul in wi rumac chi utzlaj winak chewi' tok nquec'ul, jari' nyataj na chique jun rtojbalil ja cani' nyataj chique ja utzlaj tak winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","In wi c'o jun winak xa nak ta chi winakil, wi c'o jun chique wa' ja tak ndiscípulo ri' nekaj ruq'uin, wi nsipaj tre jun vaso raxya' in wi rumac chi ndiscípulo chewi' tok nsipaj, jari' ni katzij wi' nbij chewe, arja' mta moda ja maquita xtiyataji ja rtojbalil tre, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ja c'a tok xuq'uis rbixic chique ja cablajuj discípulo nak ja xtequibana' arja' xelel chipan ja lugar, be chipan ja quitinamit je'e, ne'ertijoj ja winak in nerya'a' rbixic chique ja rtzobal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ja c'a Juan Bautista arja' c'o pa che' in xekaj rbixic ruq'uin nojel ja samaj ja rmajon rbanic ja Cristo. Ja c'a xuban, ec'o ca'i' chique ja rdiscípulo arja' xerutakel ruq'uin ja Jesús ");
INSERT INTO tzjNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","in quewa' xbijel chique ri' chi nequic'axaj tre: —¿La atat ja rat Cristo ja bitajnak can chi natpi na owi nkaybej chi na jun? ne'el chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ja c'a discípulo ja tok bitaj cumal ja binel chique rmal ja Juan quewa' bix chique rmal ja Jesús ri': —Jix, jebij tre ja Juan nojel ja nixtajini nec'waxaj in nojel ja nixtajini netz'at tre ja samaj ja nmajon rbanic ri'. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ja moya' neca'y chic. Ja maquecowini nebini nebin chic. Ja rec'o itzel tak ch'a'c chiquij xetzuri. Ja tacona' nquic'axaj chi tzij. Ja camnaki' xec'astaji. Ja meba'i' majtajnak rbixic chique ja utzlaj tzij xin totajem ja rtakonto ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","In tebij tre ja Juan chakaja' chi congana qui'il chique ja winak ja ma junwi' ta nquena' rmal ja samaj ja nintajini nban. Queri' tebij tre, ne'el chique ja discípulo rxin ja Juan Bautista. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ja c'a Jesús kas elem nqueban ja ca'i' discípulo tok xumaj tzij cuq'uin ja winak tre ja Juan Bautista: —Ja Juan ja tok q'ueje' pa tak lugar ja kas talan wi' ¿nak c'a tre tok xixbe ruq'uin chi rtz'atic, la rmal ja Juan chi xa puersa cani' jun aj nsi̱l rmal xcomel? ");
INSERT INTO tzjNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Nak c'a tre tok xixbe ruq'uin chi rtz'atic, la rmal ja Juan chi congana rwekon ri' tre buen tak tziak ja nimak rjil? Pro ixix bien ewotak chi ja winak ja necojo buen tak tziak ja nimak rjil jari' pa nimak tak jay quixin rey neq'ueje' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Nak c'a tre tok xixbe ruq'uin chi rtz'atic, la rmal ja Juan chi arja' jun profeta xin Dios? Jari' ni katzij wi' chi profeta pro ma ruyon ta ja chaka ta profeta ocnak wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Queri' nbij chewe como ja Juan arja' chomarsani ja bey rxin ja Cristo ja cani' tz'ibtal can chipan ja rtzobal Dios quewari': —Anin ntakel ja ntajko'm chi nnabeyaj chawach utzc'a chi arja' nerchomarsaj ja rabey. Queri' bitajnak can rmal ja Dios tre ja Cristo. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ni katzij wi' ja xtinbij chewe ri', mta jun profeta q'uejenak ta wawe' chwach'ulew ja nim ta ruk'ij chwach ja Juan Bautista pro ja chipan ja gobierno xin chila' chicaj jun winak masqui xa ti sencillo pro más chi na nim ruk'ij arja' chwach ja Juan. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ja gobierno xin chila' chicaj congana nqueban ja winak trij in ja winak ja congana quigana ruq'uin eje'e' congana nquetij quichok'ak' utzc'a chi ne'oc chipan. Jari' majtajnakto rbanic ja tok xumajto rsamaj ja Juan Bautista in c'a nnajin na camic. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ja gobierno xin chila' chicaj bitajnakto cumal canojel ja rojer tak profeta chi npi na in queri' bitajnakto chakaja' chipan ja ley xin Dios ja tz'ibtal can rmal ja Moisés pro ja tok peti ja Juan tri' c'a bantaj wi' cumplir ja bitajnakto. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","In wi c'ol egana nec'waxaj tec'waxaj ja xtinbij chewe ri', ja Juan arja' c'ari' ja rElías ja bitajnak can chi npi na. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bien c'a tewasaj ena'oj trij ja c'a xinbij kaj chewe ri'. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Bar c'a nenjunsaj wawa' ja winak ja tinamit Israel? Cuq'uin ca'i' moc ac'ala' nenjunsaj wi' ja quimajon tz'anem pa tak c'aybal. Jun moc nquerak quechi' chiquij ja jun moc chic: ");
INSERT INTO tzjNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","—Ajoj kaban ja música xin quicotemal pro ja rixix mta xajoj xeban, ma xixquicot ta. In kaban chic jun xin bis in nixtac'a xixbison ta chakaja', ni majun nak ta newajo', neche'e ja rac'ala' chique ja jun chic moc. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ja winak nenjunsaj cuq'uin ja rac'ala' ja ni majun nak ta ncajo' como ja Juan Bautista tok arja' peti ma kas ta wa' je'e cuq'uin ja winak in mta vino xutij in rmalari' bix tre cumal ja winak chi c'o jun itzel espíritu ocnak tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","In xinpi chic anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak, xinwa' cuq'uin ja winak in c'oli vino xintij in rmalari' bix chwe cumal ja winak chi xa in mun in xa in tijol vino in xa e wamigo ja molol tak impuesto e cachbil ja jule' chic ajmaqui'. Pro ja c'a ralc'wal Dios eje'e' bien ch'obtajnak cumal chi ja Juan Bautista rna'oj Dios ja nucoj in queri' chwe anin rna'oj Dios ncoj chakaja'. Queri' xbij chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ja c'a Jesús arja' xumaj quinataxic ja winak ja rec'o pa tak tinamit ja bar rbanon wi' je'e nimak tak milagro. Arja' xbij jule' cowlaj tak tzij chique rumac ja ma quiq'uexon ta ja quina'oj in ma quiya'on can ta ja ritzelal. Quewa' xbij chique ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Congana lawulo' chewe ixix ja rix aj Corazín in congana lawulo' chewe ixix chakaja' ja rix aj Betsaida. Queri' nbij chewe como congana nimak tak milagro xinban chewach pro ni ma xeq'uex ta wi' ja rena'oj. Ja nimak tak milagro xinban chewach wixta ban chiquewach ja ritzel tak winak ja raj Tiro in ja raj Sidón ojer queq'uex ta c'ari' ja quina'oj in queya' can ta c'ari' ja ritzelal, queban ta c'ari' ja nquic'utbej qui' chi nti'on chique ja ritzelal ja quibanon chipan ja quic'aslemal. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pro anin nbij chewe, ja tok xterila' ja nimlaj k'ij xin juicio más chi na nim ja rpokonal xtetij ixix chwach ja xtiquetij ja raj Tiro in ja raj Sidón. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","In ixix chakaja' ja rix aj Capernaum, ja nech'ob ixix chi nixbe chila' chicaj chi congana nya̱' ek'ij pro ja neban, xa nixkaji, ja bar ec'o wi' ja camnaki' c'a tri' nixekaj wi'. Queri' nbij chewe como congana nimak tak milagro xinban chewach pro ni ma xeq'uex ta wi' ja rena'oj. Ja nimak tak milagro xinban chewach wixta ban chiquewach ja ritzel tak winak ja raj Sodoma ojer c'o ta c'ari' camic ja quitinamit, maquita c'ati. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pro anin nbij chewe, ja tok xterila' ja nimlaj k'ij xin juicio más chi na nim ja rpokonal xtetij ixix chwach ja xtiquetij ja raj Sodoma. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","C'ac'ari' ja Jesús arja' tzijon ruq'uin ja Tatixel ja c'o chila' chicaj, quewa' xbij tre ri': —Nata', atat at Rajaw caj at Rajaw rwach'ulew, congana nmaltioxij chawe como ja winak ja nquech'ob kaj pa tak canma chi congana cotak in congana quina'oj ma chiquewach ta eje'e' ak'alasan wi' nak rbanic nojel awa' ja nmajon rbanic in nojel ja nmajon rbixic pro ja rak'alasan wi', chiquewach ja winak ja quibanon takno'y chawach. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Queri' abanon chique Nata' como queri' ja ravoluntad, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","In xbij chic chique: —Ni majun nak ta ja maquita jachon pa nuk'a' rmal ja Nata'. Ni majun nak ta otakyon ja kas mero rna'oj ja Ralc'walaxel pro ja rotakyon xa ruyon ja Dios ja Tatixel. In chakaja' ni majun nak ta otakyon ja kas mero rna'oj ja Tatixel pro ja rotakyon xa nuyon anin ja rin Alc'walaxel, in ja rencha'on chi nk'alasaj chiquewach, eje'e' cotak chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ewanojel ja congana nixel c'ay chi rbanic cumplir ja rereligión ja wi cani' cosnak chic ja rewí' ewanma chuxe' jun nimlaj ijka'm nena' kaj, ja wi queri' ebanon mejor ja neban, quixajo' in tiyuke' ec'u'x wq'uin. Ja wi nyuke' ec'u'x wq'uin, anin nya' chewe chi nxula'ni ja rewí' ewanma. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","C'oli nya' anin chi ekul, ja tari' newijkaj in tetijoj ewi' trij ja nc'ut anin chewach como anin c'o npaciencia in c'o jun ch'uch'ujlaj anma wc'an. Ja c'a wi newijkaj ja nya' anin chi ekul jari' nxula'ni ja rewí' ewanma rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Queri' nbij chewe como ja nya' anin chi ekul mta cosem rc'amonto chewe in ja rijka'm wxin nya' chewij ma al ta rc'axic. Queri' xbij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ja c'a Jesús e rachbil ja rdiscípulo, pa jun xula'nbal k'ij quimajon binem chipan jule' trigo. Ja c'a rdiscípulo chaka jalal xemajtaj rmal rk'ak'anil quepan rmalc'ari' tok quemaj rk'olic ja trigo in quetij. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ja c'a fariseo eje'e' tok xequetz'at quibij tre ja Jesús: —Pakasa' radiscípulo le', ja netajini quimajon rbanic jala' xajan nbani pa tak xula'nbal k'ij, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bix chique rmal ja Jesús: —¿La ma esiq'uin ta la'an chipan ja rtzobal Dios ja xuban ja rojer rey David ja tok xuban jutij arja' majtaj rmal rk'ak'anil rupan in ja re rachbil chakaja'? ");
INSERT INTO tzjNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ja c'a xuban, xoc chipan ja rochoch Dios in xutij ja caxlanway ja parti'in chwach ja Dios. Queri' xuban masqui jari' caxlanway tz'ibtal chipan ja ley xin Dios chi xa queyon sacerdote ja netijowi. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","In ¿la ma esiq'uin ta c'a chakaja' ja nbij ja ley chique ja sacerdote tre ja samaj nqueban chipan ja nimlaj templo xin Dios chi eje'e' rjawaxic nesamaji pa tak xula'nbal k'ij, maquexula'ni? Pro xula'nbal k'ij c'a in nesamaji pro ma xajan ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ja c'a ranin nbij chewe chi anin más chi na nim nuk'ij chwach ja nimlaj templo xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","C'o jun tzij rbin can ja Dios quewari': —Ja kas nwajo' chewe chi neban, tepokonaj quewach ja winak, jari' más chi na nc'atzini chwach ja netzujuj jule' sacrificio chinwach, ne'e. Ja wixta ch'obtajnak emwal ja nbij ja tzij ri' maquita xebij ari' chi xajan ja queban ja ndiscípulo tok ma xajan ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Queri' nbij chewe como ja ranin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak, pa nuk'a' anin c'o wi' ja nbani chipan ja xula'nbal tak k'ij. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","C'ac'ari' xeli ja Jesús, be, xoc chipan ja jay xin molbal ri'il quixin ja fariseo. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","C'o c'a jun achi siquirnak jun ruk'a'. Ja c'a fariseo eje'e' quimajon rcanoxic rij rwach ja Jesús nak ja nquichapbej rxin rmalc'ari' tok quewa' quibij tre ri': —¿La nuya' lugar chawe ja ley chi ne'atzursaj yawa'i' pa tak xula'nbal k'ij? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Bix chique rmal ja Jesús: —¿La c'o c'a jun chewe c'o ta jun rcarnelo ntzakel pa jul pa jun xula'nbal k'ij in matuyic chi nlasajto chipan ja jul? ");
INSERT INTO tzjNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pro jun winak más chi na nim ruk'ij chwach jun carnelo rmalc'ari' nbij chewe chi ja ley nuya' lugar chake chi nkaban ja rutzil pa tak xula'nbal k'ij, xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","C'ac'ari' xbij tre ja yawa': —Tayuku' ja rak'a', ne' tre, in xuyuk ja ruk'a' in tzuri, junan chic chi ca'i'. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ja c'a fariseo eje'e' xebe, xequimolo' qui' in quemaj rch'obic nak nqueban tre ja Jesús chi nquicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ja c'a Jesús arja' rotak chi ncajo' nquicamsaj, xelel chipan ja lugar in be. E q'uiy ja winak xetre'el trij. Arja' xertzursaj canojelal ");
INSERT INTO tzjNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","in xbij chique chi majun bar ta tri' nquitzijoj wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jawa' ja xuban ri' utzc'a chi tri' bantaj wi' cumplir ja bitajnak can ojer rmal ja Dios in xoqui ja profeta Isaías chi rbixic quewari': ");
INSERT INTO tzjNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","—Tetz'ata' mpe' ja rajsamajel wxin ja ncha'on ri', arja' congana nwajo', janila nquicot wanma trij. Anin xtinya' tre ja rEspíritu Santo wxin in arja' xtuc'ut ja bey xin Dios chiquewach ja winak ja ma e aj Israel ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ja tok ntzijon cuq'uin ja winak arja' ma xtucoj ta ja tzij ja xa ch'a'oj rc'amonto nixtac'a xturak ta ruchi', matic'axaxi ja rukul chi nat. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ja winak ja congana lawulo' quibanon in capujnak quec'u'x rmal, arja' maqueruyoj más, neruyic in neruto'. Niquirwari' xtuban in rmal arja' tok xtoqui ja rbey Dios pro chijutij xtoqui in nij arja' wi' ja nch'ocmaji. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Arja' nekaj na rbixic cuq'uin ja winak ja ma e aj Israel ta in eje'e' nyuke' na quec'u'x ruq'uin, ne'e ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ja c'a Jesús c'amarel jun achi chwach, ja rachi moy in mem chakaja' in c'o jun itzel espíritu ocnak tre. Xtzursaj ja rachi, nca'y chic in ncowin chic ntzijoni. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ja c'a winak kas c'asc'o'i quetz'at pro ni canojel in quewa' quibij ri': —¿La maxta jala' ja Cristo ja Ralc'wal can ja rojer rey David? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ja c'a fariseo eje'e' quic'axaj ja quibij ja winak in quewa' quibij ri': —Jala' rachi le' ja tok nerlasaj itzel tak espíritu chique ja winak xa poder xin Beelzebú nucoj ja jefe quixin ja ritzel tak espíritu, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pro ja c'a Jesús arja' bien rotak ja quimajon rch'obic ja fariseo in xbij chique: —Ja gobierno xa nak ta chi gobierno'il, wi xa división nuban chibil ri' jari' xa nyojtaji. In queri' tre jun tinamit chakaja' in chique jule' winak ec'o pa jun jay, wi xa división nqueban chibil tak qui' jari' xa neq'uisi. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","In queri' c'a tre ja Satanás chakaja', ja wi nerlasaj ja rach tak demonio jari' xa división nuban kaj tre arja' ruyon. Ja wi queri' nuban, ja gobierno rxin ¿nak moda maquita xtiq'uisi? ");
INSERT INTO tzjNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ja rixix nebij chwe chi xa poder xin Beelzebú ncoj ja tok nenlasaj ja demonio pro ja rediscípulo ixix nequiwasaj wa'an demonio chakaja' ¿la xc'a poder xin Beelzebú nquecoj nech'ob ixix? Ja rediscípulo ixix eje'e' c'ari' xquek'alasani chi ma katzij ta ja xebij chwe. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ja ranin poder rxin ja rEspíritu Santo xin Dios ncoj ja tok nenlasaj ja demonio in wi queri' nban tibij c'a tzij ari' chi ja gobierno xin Dios kajnakto chic checojol. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ja wi natekaj ruq'uin jun achi congana rchok'ak' in wi nach'ob chi nalasaj tre ja rnakun c'o pa rochoch rjawaxic chi nabac' na nabey ja rachi. Ja wi queri' naban jari' natcowini nalasaj tre nojel ja c'o pa rochoch. Queri' xinban anin tre ja Satanás chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ja winak ja matiquecoj qui' wq'uin jari' xa ruq'uin Satanás ja nc'ulel nquecoj wi' qui' in chakaja' ja maqueto'o wxin chi quimolic ja winak jari' xa nequichicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Rmalc'ari' tok anin nbij chewe, ja winak masqui nqueban ja il mac xa nak ta chi il maquil in chakaja' masqui nquibij jule' tzij tre ja Dios ja xa ofensa rc'amonto tre jari' c'o cuytajic trij. Pro ja wi nquibij jule' tzij tre ja rEspíritu Santo in wi: —Xa itzel ja nuban, wi neche' tre, jari' mta cuytajic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ja wi c'o jun winak xa nak ta chi winakil masqui arja' nbij jule' tzij tre ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, jule' tzij ja xa ofensa rc'amonto tre, jari' c'o cuytajic trij pro wi nbij jule' tzij tre ja rEspíritu Santo ja xa ofensa rc'amonto tre jari' ni mta wi' cuytajic trij nixtac'a chipan awa' tiempo ja rokc'o wi' ri' in nixtac'a chipan ja jun chic tiempo ja maja'n tipeti. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ja c'a wi nebij tre jun che' chi xa itzel che' ¿nak c'a tre tok matebij tre chi xa itzel rwach chakaja'? In wi nebij tre jun che' chi utzlaj che' tebij c'a tre chakaja' chi utz ja rwach nuya'. Queri' nbij chewe como ja jun mocaj che', rumac ja rwach nuya' chewi' tok notakixi nak chi che'al. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ixix congana itzel tak na'oj ewc'an, ix cani' jule' itzel tak cumatz. Congana c'ayew xtelpi ta jule' utzlaj tak tzij pan echi' como xa ix itzel tak winak. Queri' nbij chewe como ja nojnak pa tak ewanma jari' nelto pan echi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jun utzlaj achi utzil ja rc'olon pa ranma in tok ntzijoni utzil rc'amonto ja nbij. Jun itzel achi xa itzelal ja rc'olon pa ranma in tok ntzijoni xa itzelal rc'amonto ja nbij. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ja c'a ranin nbij chewe, ja tok xterila' ja nimlaj k'ij xin juicio nojel ja tzij ja quibij ja winak ja chaka quigana quibij nequijacha' na cuenta chwach ja Dios rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Queri' nbij chewe como ja tzij xebij wawe' chwach'ulew jari' tzij noc na chewij chakaja' chi nk'etbex tzij chewij nak xtiban chewe rmal ja Dios, wi xquixrwasajel libre owi xquixrutakel chipan ja rpokonal. Queri' xbij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ec'o c'a jule' maestro ja netijon quixin ja winak tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés e cachbil jule' fariseo, eje'e' quibij tre ja Jesús: —Maestro, ja nkajo' ajoj chawe camic tabana' jun milagro chikawach utzc'a chi natkanimaj, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pro bix chique rmal ja Jesús: —Ja winak ja nec'utun chwe chi nban jun milagro utzc'a chi ninquinimaj eje'e' xa e itzel tak winak, xa quiya'on can ja Dios. Pro ja milagro ja nquic'utuj jari' ni matinban wi' chiquewach xarwari' c'o jun ja milagro nbantaj na chiquewach, jun milagro ja cani' xuban ja rojer profeta Jonás. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Como cani' xuban ja Jonás ojer oxi' k'ij in oxi' ak'a' q'ueje' chupan jun nimlaj ch'u' in queri' c'a chwe anin chakaja' ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak, oxi' k'ij in oxi' ak'a' ninq'ueje' na chipan ja rwach'ulew chipan ja lugar ja bar neq'ueje' wi' ja camnaki'. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ja tok xterila' ja nimlaj k'ij xin juicio ja rachi'i' ja rec'o chipan ja tinamit Nínive ojer eje'e' xqueyictaji ix cachbil ja rix tinamit Israel in eje'e' ne'oc e k'etol tak tzij chewij. Queri' nbij chewe como ja raj Nínive eje'e' tok quic'axaj ja rtzobal Dios ja bix chique rmal ja Jonás ojer q'uextaji ja quina'oj in queya' can ja ritzelal. In ja camic nbij chewe, anin más chi na nim nuk'ij chwach ja Jonás. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ja tok xterila' ja nimlaj k'ij xin juicio ja rixok ja reina rxin ja nación ja c'o pa sur arja' xtiyictaji ix rachbil ja rix tinamit Israel in arja' noc k'etol tzij chewij. Queri' nbij chewe como jari' ixok arja' c'a c'a nat pi wi' chi rc'axaxic ja rna'oj Dios ja yatajnak tre ja rojer rey Salomón. In ja camic nbij chewe, anin más chi na nim nuk'ij chwach ja Salomón. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jun itzel espíritu tok nel pa ranma jun achi arja' nbe pa tak lugar ja bar mta wi' ya', nercanoj jun lugar ja bar nxula'n wi' pro matuwil ja lugar ");
INSERT INTO tzjNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","in quewa' nbij ri': —Ninmeloj chic jutij chipan ja wochoch ja bar inelnakto wi' nabey, ne'e. Ja c'a tok nekaj chic jutij ruq'uin ja rachi nutz'at ja ranma cani' jun jay congana talani, josk'in rpan in wekon chi utz. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","C'ac'ari' nmeloj chic jutij, ne'erc'ama' wuku' rach tak itzel espíritu ja más chi na e itzel chwach arja'. Ja c'a tok ne'urkaj ruq'uin ja rachi ne'oc pa ranma chi e waxaki' in tri' neq'ueje' wi'. Xc'a chewi' tok más chi na lawulo' ja rc'aslemal ja rachi chwach ja nabey. In queri' c'a xtiban ixix chewe chakaja' ja rix tinamit Israel ja congana itzelal ebanon. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ja Jesús c'a rmajon na tzij cuq'uin ja winak, ja c'a rute' in ja re rch'alal ec'o chwa jay in ncajo' netzijon ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","In bix tre ja Jesús: —Pakasa' rate' in ja re awach'alal ec'o chwa jay in ncajo' netzijon awq'uin, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ja c'a Jesús xbij tre: —Camic nch'ob chawach echinatak ja nute' in echinatak ja wach'alal, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","C'ac'ari' xeruc'ut ja rdiscípulo in xbij: —Eje'e' c'awa' e'ocnak nute' in e'ocnak wach'alal. ");
INSERT INTO tzjNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Queri' nbij chawe como xa nak ta ja nbanowi rvoluntad ja Nata' ja c'o chila' chicaj arja' c'ari' ocnak nuchak' owi wana' owi nute', ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chipan ari' k'ij xelel ja Jesús pa jay, be chiya' in tri' xetz'abe' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Congana e q'uiy ja winak xequimolo' qui' ruq'uin rmalc'ari' tok arja' xoc chipan jun lancha in tz'abe' chipan. Ja c'a winak xepe'e can chiya' canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","In xumaj tzij cuq'uin, q'uiy rwach ja xbij chique pa c'ambal tak tzij, quewa' xbij ri': —C'o jun ajticola' be pa ticoj tijco'm pa rchenoj. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ja c'a tok xekaji xumaj rchicaxic ja rija'tz. C'o c'a kaj pa bey in xepeti ja tz'iquin, quetij. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","C'o chic jule' kaji ja bar c'o wi' abaj, xa xax ja rulew in chanim xelto rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pro ja tok xelto ja k'ij, xc'atsaj in tok q'uiswani chakij rmal como mta más ja rc'amal. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","C'o chic jule' kaj pa tak q'uix in tok q'uiswani q'uiyi ja q'uix, xcamsaj ja tijco'm. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pro c'o chic jule' kaj pan utzlaj ulew in wachini chi utz, ja jun chirwach ija'tz c'oli xuya' jun ciento, c'oli xuya' sesenta in c'oli xuya' treinta. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Bien c'a tewasaj ena'oj trij ja c'a xinbij chewe ri', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ja c'a rdiscípulo ja Jesús eje'e' xe'ekaj ruq'uin in quewa' quibij tre ri': —¿Nak tre tok xa c'ambal tak tzij nacoj tok nattzijon cuq'uin ja winak? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ja c'a Jesús arja' xbij chique: —Ja rixix yatajnak chewe chi newotakij nak rbanic ja rawatal je'e tre ja gobierno xin chila' chicaj pro ja chique ja jule' chic winak le' eje'e' ma yatajnak ta chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Queri' nbij chewe como ja winak ja c'o je'e yatajnak chique eje'e' nyataj na más chique in tok nq'uiswani nuban q'uiy cuq'uin. Pro ja c'a winak ja mta yatajnak chique pro nquech'ob chi c'oli jari' nlasax chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Xa chewi' tok ncoj c'ambal tak tzij tok nintzijon cuq'uin ja winak le' como eje'e' c'o quewach pro maticajo' nquetz'at ja nc'u̱t chiquewach, c'o quixquin pro maticajo' nquic'axaj ja nbix chique in ni matich'obtaj wi' cumal. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ja netajini nqueban jari' nbantaj cumplir ja rbin can ja Dios cani' bitajnak can ojer rmal ja profeta Isaías quewari': —Ruq'uin ewxquin nec'waxaj na pro ni matich'obtaj wi' emwal in ruq'uin ewach netz'at na pro ni mta wi' nak ta newasaj trij, ne'e. In jun chic xbij quewari': ");
INSERT INTO tzjNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","—Queri' nbij chique ja winak le' como ja canma cowirnak in ja quixquin c'ayew chi noc chipan ja nbix chique in ja quewach xa quiyupun. Queri' nqueban como mta quigana nquetz'at ja nc'u̱t chiquewach in nixtac'a c'o ta quigana nquic'axaj ja nbix chique in nixtac'a c'o ta quigana nquech'ob pa tak canma ja nch'o̱b chiquewach in nixtac'a c'o ta quigana chakaja' nemeloj wq'uin utzc'a chi ncuy ja quil quemac, ne'e ja Dios. Queri' c'a ja bitajnak can. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pro ja rixix congana qui'il chewe como netz'at ja nc'u̱t chewach in nec'waxaj ja nbix chewe. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Queri' nbij chewe como ni katzij wi' ja nbij chewe ri', e q'uiy ja rojer tak profeta in e q'uiy ja jule' chic winak ja utz xetz'a̱t rmal ja Dios, eje'e' congana quiyarij quetz'at ta ja cani' nixtajini netz'at ixix camic in congana quiyarij quic'axaj ta chakaja' ja cani' nixtajini nec'waxaj ixix camic. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Tec'waxaj c'a camic, anin nch'ob chewach nak rc'amonto ja c'ambal tzij ja xinbij chewe tre ja rajticola'. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ja utzlaj tzij ja nuc'ut chikawach nak rbanic ja gobierno xin chila' chicaj, ja tok nel rbixic in tok c'o jun nc'waxaj pro matich'obtaj rmal ja c'a diablo npeti, nlasajel ja tzij ja ticon pa ranma. Ja c'a ri' tibij tzij ja rija'tz ja kaj pa bey. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ja c'a rija'tz ja kaji ja bar c'o wi' abaj jari' tibij tzij ja winak ja nquic'axaj ja utzlaj tzij in chanim nquinimaj, congana nequicot rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pro eje'e' e cani' jule' tijco'm ja mta rc'amal, xa ti jurata nquinimaj. Ja c'a tok xterila' ja c'ayewalaj tiempo ja tok nmajtaj rbanic pokon chique ja winak rmal ja rtzobal Dios eje'e' chanim nqueya' can. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ja c'a rija'tz ja kaj pa tak q'uix jari' tibij tzij ja winak ja nquic'axaj ja utzlaj tzij pro tok nq'uiswani xa ja' nquibisoj chic ja xin rwach'ulew in xa neba̱n engañar rmal ja meba'il. Rmalc'ari' tok xa ncami ja utzlaj tzij ja c'o pa tak canma, mta rwach nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pro ja rija'tz ja kaj pan utzlaj ulew jari' tibij tzij ja winak ja nquic'axaj ja utzlaj tzij in nch'obtaj cumal in c'oli rwach nuya' pa tak canma. Eje'e' e cani' jule' chirwach ija'tz c'oli xuya' jun ciento, c'oli xuya' sesenta in c'oli xuya' treinta. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","In c'o chic jun ja c'ambal tzij xbij chique quewari': —Ja gobierno xin chila' chicaj queri' rbanic cani' xuban jun achi xutic jule' utzlaj ija'tz xin trigo pa rchenoj. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pro ja winak ja tok ekajnak chic chi waram peti ja rc'ulel ja rachi, xurtica' jule' itzel ija'tz chicojol ja trigo. Ja c'a tok tictaj can rmal meloji. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ja c'a trigo xumaj q'uiyem in tok xumaj k'enaric ja rwach tri' xotakix wi' chakaja' ja jule' chic ja ticon chicojol chi xa itzel tijco'm. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ja c'a rajsamajela' eje'e' xebe ruq'uin ja quipatrón ja ticowi ja utzlaj ija'tz, xequibij tre: —Kajaw ¿la ma utzlaj ija'tz ta c'a ja xatic chipan ja rachenoj? ¿Nak moda tok c'o jule' itzel tijco'm chicojol camic? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","In bix chique: —Jari' c'o jun nc'ulel ticowi, xeche'xi. Ja c'a rajsamajela' eje'e' quibij chic jutij tre: —¿La matawajo' c'a nokbe camic nekaboko'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","In bix chic jutij chique: —Jari' ma can ta, ma tebok ta, matzij tuc'amto ja trigo tok xtebok. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mejor ch'enchila', tiq'uiy na chi ca'i' como ja tok xterila' ja tiempo xin cosecha anin nbij na chique ja xquesamaj chipan ja tiempo xin cosecha: —Temolo' ruchi' nabey ja ritzel tijco'm in texima' rpan pa tak manoja utzc'a chi nporoxi. Pro ja trigo temolo' ruchi' chakaja' in tec'olo', ninche' na chique. Queri' ja c'ambal tzij xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","In c'o chi c'a jun ja c'ambal tzij xbij chique quewari': —Ja gobierno xin chila' chicaj queri' rbanic cani' jun ti chirwach mostaza c'amarel rmal jun achi, xutic pa rchenoj. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jun ti chirwach mostaza más na tino'y chwach ja jule' chic ija'tz pro ja tok nq'uiyi más na nq'uiyi chwach jule' chic tijco'm, noqui cani' jun mocaj che'. Rmalc'ari' ja tak tz'iquin eje'e' nepeti, nurquibana' quesoc pa tak ruk'a'. Queri' ja c'ambal tzij xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","In c'o chic jun ja c'ambal tzij xbij chique quewari': —Ja gobierno xin chila' chicaj queri' rbanic cani' nuban jule' levadura ja nsapoji caxlanway rmal in c'o jun ixok xuc'am, xuya' chipan jule' k'or, oxi' pajbal harina ocnak. Ja c'a tok q'uiswani ja levadura mta ja maquita xekaj wi' tre ja k'or, congana samaj chipan. Queri' ja c'ambal tzij xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ja Jesús, nojel ja tzij xbij chique ja winak xucoj c'ambal tak tzij chi rbixic chique. Ni majun nak ta xbij ta chique ja maquita xucoj c'ambal tak tzij chi rbixic chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Queri' xuban utzc'a chi tri' bantaj wi' cumplir ja bitajnak can ojer rmal ja profeta quewari': —Ja tok xquintzijoni, c'ambal tak tzij ncoj. Ja rawatalto je'e ja tok maja'n titz'ucarto ja rwach'ulew anin nk'alasaj na. Queri' ja bitajnak can. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","C'ac'ari' ja Jesús xeruban can despedir ja winak, be, xoc pa jay. Ja c'a rdiscípulo eje'e' xe'ekaj ruq'uin in quibij tre: —Tach'obo' chikawach nak rc'amonto ja c'ambal tzij ja xabij tre ja ritzel tijco'm ja tic chicojol ja trigo, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ja c'a Jesús quewa' xbij chique ri': —Ja nticowi ja utzlaj ija'tz jari' anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ja chenoj jari' ja rwach'ulew. Ja utzlaj ija'tz jari' ja rec'o pa rcuenta ja gobierno xin chila' chicaj. Ja ritzel tijco'm jari' ja rec'o pa rcuenta ja diablo. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ja ticowi ja ritzel tijco'm ja rc'ulel ja rachi jari' ja diablo. Ja tiempo xin cosecha jari' ja q'uisbal tak k'ij ja tok xquinpi chic jutij. Ja nebanowi ja cosecha jari' ja ángel. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Cani' nba̱n tre ja ritzel tijco'm nmo̱l ruchi' in nporox pa k'ak' queri' c'a xtibantaj chique ja winak chakaja' chipan ja q'uisbal tak k'ij. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ja c'a ranin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak xquenutakto ja ángel wxin, ne'urquichapa' canojel ja winak ja rec'o chipan ja ngobierno ja xa nequitakchi'ij ja cach tak winak chi rbanic ja il mac, ne'urquichapa' chakaja' canojel ja jule' chic winak ja xa e banol tak itzelal. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ja c'a tok nechaptaj cumal nequich'akijel chipan jun nimlaj k'ak'. Ja c'a winak janila chi ok'ej xtiqueban chipan ari' lugar in xtiquicach'ach'ej cak'. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tokoc'ari' ja winak ja utz netz'a̱t rmal ja Dios eje'e' nyataj na chique chi nqueban ja cani' nuban ja k'ij, nech'a'an chipan ja gobierno xin Dios ja Tatixel quixin. Bien c'a tewasaj ena'oj trij ja c'a xinbij chewe ri'. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","In jun chic, ja gobierno xin chila' chicaj queri' rbanic cani' jun nimlaj meba'il wawan, mukun chipan jun chenoj in chaka jalal tok xiltaj rmal jun achi. Ja c'a rachi xumuk can chic jutij, nmeloji, congana nquicoti, nojel ja c'o ruq'uin nc'ayij in nulok' ja chenoj ja bar c'o wi' ja nimlaj meba'il. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","In jun chic, ja gobierno xin chila' chicaj queri' rbanic cani' nuban jun comerciante ntajini ncanoj jule' abaj perla ne'xi, nimak rjil. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ja c'a tok xuwil jun ja perla ja más chi na nim rjil be, in nojel ja c'o ruq'uin xc'ayij in xulok' ja perla. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","In jun chic, ja gobierno xin chila' chicaj queri' rbanic cani' jun c'am nq'uia̱k pa mar in ne'oqui ja ch'u' chipan pro nojel quewach ja ch'u' ne'oc chipan. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ja c'a tok xenoji ja ch'u' chipan lasaxto chiya'. Ja c'a xewasanto eje'e' xetz'abe'e, quemaj quicha'ic ja ch'u'. Ja buen tak ch'u' jari' xequec'ol pro ja mta ne'oc wi' xa xequich'akijel. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","In queri' c'a xtibantaji chakaja' chipan ja q'uisbal tak k'ij, nepeti ja ángel, ne'urquiwasajel ja ritzel tak winak chiquicojol ja re utz ");
INSERT INTO tzjNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","in nequich'akijel chipan ja nimlaj k'ak'. Ja c'a winak janila chi ok'ej xtiqueban chipan ari' lugar in xtiquicach'ach'ej cak', ne'e ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","C'ac'ari' xbij chic chique: —¿La nch'obtaj emwal nojel ja xinbij chewe? ne' chique. —Nch'obtaji Kajaw, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","In xbij chic jutij chique: —Como nch'obtaj emwal rmalc'ari' nbij chewe chi canojel ja maestro ja nquitijoj qui' tre ja gobierno xin chila' chicaj eje'e' e junan ruq'uin jun rajaw jay ja c'oli nojel ruq'uin ja nc'atzini, c'o c'ac'a, c'o ma c'ac'a ta chakaja' in arja' nlasajto xa nak ta nc'atzin tre chi ca'i'. Queri' ja xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ja c'a Jesús ja tok bitaj can rmal nojel awa' ja c'ambal tak tzij ri' arja' xelel ");
INSERT INTO tzjNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","in be chipan ja rtinamit arja'. Ja c'a tok xekaji xoc chipan ja jay xin molbal ri'il in xumaj quitijoxic ja winak. Ja c'a winak congana c'asc'o'i quic'axaj ja tijonem ja xuya' chique in quewa' quibij chibil tak qui' ri': —¿Bar c'a penak wala' ja rocnak tre jala' jun achi le'? congana taka'an rna'oj in congana nimak tak milagro nuban chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pro ¿la ma arja' ta c'ala' ja rc'ajol ja josol che'? In ja rute' ¿la ma arja' ta c'a ja rbina'an María? In ja rch'alal ¿la ma eje'e' ta c'a ja Jacobo, José, Simón in Judas? ");
INSERT INTO tzjNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","In canojel ja rana' ¿la ma ec'o ta c'a chikacojol chakaja'? ¿Bar c'a penak wi' nojel ja ntajini nuban? ");
INSERT INTO tzjNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Queri' quibij, ni majun quigana ruq'uin, xa pokon nquena'. Ja c'a Jesús arja' xbij chique: —Ni majun profeta xin Dios ja maquita lok' nna'i xarwari' ma lok' ta nna'i cumal ja rach aj tinamit in nixtac'a cumal ta ja rec'o pa rochoch chakaja', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","In xa ma nim ta ja milagro xuban tri' rumac ja ma xyuke' ta quec'u'x ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chipan ari' tiempo nojel ja ntajini nuban ja Jesús xekaj rbixic ruq'uin ja gobernador Herodes. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ja c'a Herodes arja' xbij chique ja rajsamajela' ja rec'o ruq'uin: —Ja rachi ja maxco' ntajini nuban arja' Juan Bautista c'astajnakto chiquicojol camnaki' chewi' c'a tok ocnak tre ja nimak tak poder ja ntajini nsamaj ruq'uin camic, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Queri' xbij como bien rotak chi arja' camsan rxin ja Juan Bautista tokori' tok xutak rchapic, baq'ui in coj pa che'. Queri' xuban tre rumac ja bix tre rmal ja Juan Bautista chi: —Ma rubey ta abanon chi ac'amon ja rawixnam, ne'xi. Como ja Herodes arja' rc'amon ja rixnam rbina'an Herodías, rxjayil jun rch'alal rbina'an Felipe. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ja xuban ja Herodes nabey tok maja'n ticamsaj ja Juan Bautista ni c'o wi' rgana ncamsaj pro xa nxbej ri' chiquewach ja winak como ja nquibij ja winak chi ja Juan Bautista arja' jun profeta xin Dios, neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pro tok q'uiswani xcamsaj tokori' tok xerila' ja k'ij ja nc'u̱l wi' rcumpleaños. Ja Herodías arja' c'o jun ral xtan in xajowi ja xtan chiquewach ja winak ja quimolon qui' ruq'uin ja Herodes. Ja c'a Herodes arja' congana xel ruc'u'x trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Rmalc'ari' tok quewa' xbij tre ja xtan ri': —Tac'utuj chwe xa nak ta nawajo', can nya' chawe, ne' tre, in xuban jurar chi ni nuya' wi' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pro ja xtan bix tre rmal ja rute' nak ja xtic'utuj tre ja Herodes in quewa' ja xc'utuj tre ri': —Ja rwi' ja Juan Bautista taya'a' chwe pa jun plato, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pro ja c'a rey Herodes congana junwi' xuna' pro como rbanon chic jurar chiquewach ja rec'o ruq'uin pa mesa chewi' tok xuya' orden chi nya̱' tre ja xtan ja xc'utuj. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Xutak rcamsaxic ja Juan pa che' chi nlasax rwi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ja tok lastaji ja rwi' ya'to chipan jun plato in xurjach tre ja xtan. Ja c'a xtan arja' xuc'amel, xerjacha' chic tre ja rute'. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ja c'a rdiscípulo ja Juan tok quic'axaj chi camsaxi eje'e' xebe, xequic'ama' ja rcuerpo in xequimuku'. C'ac'ari' xebe, xequibij tre ja Jesús ja bantaji. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ja c'a Jesús tok xekaj rbixic ruq'uin ja bantaji arja' xoquel pa jun lancha, xeryonaj ri' chipan jun lugar kas talani ja bar ma ec'o ta wi' winak. Pro ja winak tok xekaj rbixic cuq'uin ja bar nbe wi' congana e q'uiy chique xe'elel pa tak quitinamit, xebe chi cakan chi nequiwila'. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ja c'a Jesús tok xelto chipan ja lancha xerutz'at ja winak chi congana e q'uiy. Arja' xpokonaj quewach in xertzursaj ja yawa'i' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ja c'a tok kaj k'ij ja rdiscípulo ja Jesús eje'e' xebe ruq'uin in quibij tre: —Ja lugar ja rokc'o wi' ri' congana talani in xuban hora, mejor ja naban, que'ataka'el ja winak pa tak aldea chi nequilok'o' ja nquetij, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Mta rjawaxic chique chi nebe, ixix nixyo' chique ja nquetij, xeche'x rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Pro mta nak ta kac'amonto xarwari' jo'o' rkan caxlanway in e ca'i' cakan ch'u', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Que'ec'ama'to, xeche'x chic rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","C'ac'ari' xbij chique ja winak: —C'o buen tak k'ayis le' tetz'ulbej, ne' chique. C'ac'ari' xuc'am ja jo'o' rkan caxlanway e rachbil ja ca'i' cakan ch'u', ca'y chicaj in xmaltioxij tre ja Dios. Xuwech' ja caxlanway, xujach chique ja rdiscípulo in eje'e' queya' chic chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Xewa'i pro ni canojelal in xenoji chi utz. Ja c'a caxlanway rachbil ch'u' mol ruchi' ja totaji, cablajuj chacach xuban. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ja xewa'i ec'o la jo'o' mil pro xa queyon achi'i', aparte ixoki' in ac'ala'. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","C'ac'ari' ja Jesús xbij chique ja rdiscípulo: —Puersa nixoquel chipan ja lancha, nixbe chajuparaj ya', nixnabeyaj chinwach, ne' chique, in xeruban can despedir ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ja tok xebantaj can despedir rmal, arja' jote' chwach jayu' ruyon, xuwil jun lugar ja bar nuban wi' oración. Ja tok xoc ak'a' xa ruyon c'o tri'. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ja c'a lancha kas pa nc'aj ya' c'o chi wi', c'o jun nimlaj ik' jaktajnakto chiquij ja rdiscípulo, matuya' lugar chique chi nebini in ja nimak tak baloj congana nuban tre ja lancha. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ja c'a pa rsakaric rmajon binem parwi' ya' ja Jesús, xekaj chinakaj ja lancha. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ja c'a rdiscípulo tok quetz'at chi rmajon binem parwi' ya' congana quixbej qui' rmal in congana capuj quec'u'x: —C'o taka'an jun xbinel, xeche'e, in quemaj rakic quechi' rmal ja xbeben ri'il. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ja c'a Jesús xbij chique: —Ma ticapuj ta ec'u'x, xwa'n anin, ma texbej ta ewi', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ja c'a Pedro arja' xbij tre: —Wajaw, ja wi katzij chi atat, tabij chwe chi ninbin parwi' ya' chi ninbe awq'uin, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Catajo' c'a, ne'xi rmal ja Jesús. C'ac'ari' ja Pedro xelto chipan ja lancha in xumaj binem parwi' ja ya', be ruq'uin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pro ja tok xutz'at ja ik' chi congana nuban arja' congana xbej ri' rmal, xumaj kajem xe' ya' in xumaj rakic ruchi': —Wajaw, kato'o' ki', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ja c'a Jesús chanim xuyuk pon ruk'a', xuyic ja Pedro in quewa' xbij tre ri': —Achi, xa ma nim ta ja yukulbal ac'u'x wq'uin ¿nak tre tok xuban ca'i' ac'u'x? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ja c'a tok xe'oc chipan ja lancha cami ja ik'. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ja c'a rec'o chipan ja lancha eje'e' quemaj rya'ic ruk'ij, quewa' quibij tre ri': —Ni katzij wi' chi atat ja rat Ralc'wal Dios, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Xe'elel, xe'ekaj chajuparaj ya', pa jun lugar rbina'an Genesaret xe'ekaj wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ja c'a rachi'i' ja rec'o chipan ari' lugar tok queya' cuenta tre chi Jesús ja xekaj cuq'uin eje'e' quitakla' rbixic chique canojel ja jule' chic winak ja rec'o chipan ari' lugar in canojel ja yawa'i' xequec'amel ruq'uin ja Jesús ");
INSERT INTO tzjNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","in quewa' quibij tre ri': —Tabana' jun utzil chake, taya'a' jutz'it lugar chique ja yawa'i' chi nquechapoc jutz'it ja ratziak, mana xa jutz'it ruchi' ja nquechapoc, xeche' tre. In queri' queban, canojel ja xechapowi ja rtziak xetzuri. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ec'o c'a jule' maestro ja netijon quixin ja winak tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés e cachbil jule' fariseo, eje'e' epenak pa Jerusalén, xe'ekaj ruq'uin ja Jesús in quewa' quibij tre ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Nak c'a tre tok ja radiscípulo atat matiquinimaj ja costumbre quixin ja kati't kamama'? como eje'e' tok newa'i matiquinimaj ja cani' nrajo' ja costumbre tre ja ch'ajoj k'abaj, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ja c'a Jesús arja' xbij chique: —Pro ja c'a rixix chakaja' ma eniman ta ja mandamiento xin Dios como c'o jule' costumbre necoj chibil tak ewi' ja xa nuyoj ja mandamiento. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Queri' nbij chewe como ja Dios c'o jun mandamiento rya'on chewe, quewa' nbij ri': —Lok' que'ana'a' ja ratata' ate', ne'e. In jun chic mandamiento rya'on chewe quewa' nbij ri': —Ja wi c'o jun xa itzel ntzijon tre ja rtata' owi rute' jari' puersa ncamsaxi, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pro ja rixix xa ma lok' ta ne'ena' como quewa' ja tijonem neya' ri': —Ja wi nabij tre atata' owi ate': —Camic maquincowini natnuto' tre ja c'o rjawaxic chawe como nbin chic tre ja Dios chi rxin chic arja' ja c'o wq'uin, wi natche' tre, ");
INSERT INTO tzjNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","jari' ma rjawaxic chi ta chi nato' tre ja c'o rjawaxic tre, nixche'e. Queri' ebanon, ja mandamiento xin Dios, ixix ebanon tre ni mta pro xa rumac ja recostumbre. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Caca' epalaj, bien ntake' chewe ja binto chewe ojer rmal ja profeta Isaías, quewa' xbij ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","—Jawa' winak ri' xa chi quechi' c'o wi' tok nqueya' nuk'ij, ja canma c'a c'a nat c'o wi' chwe. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ni majun noc wi' ja tok nqueya' nuk'ij, ja tijonem nqueya' rtzobal Dios neche' tre, pro xa mandamiento quixin winak. Queri' ja binto chewe rmal ja rIsaías, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ja c'a Jesús arja' xumaj chic tzij cuq'uin ja winak, quewa' xbij chique ri': —Tec'waxaj ja xtinbij chewe ri', kas ta xtich'obtaj emwal. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ma ja ta ja noc pan achi' ja ntz'ilorsani ja rawanma pro ja ntz'ilorsan rxin jari' ja nelto pan achi', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ja c'a rdiscípulo eje'e' xetiloc ruq'uin in quibij tre: —¿La awotak chi ja fariseo junwi' quic'axaj ja xabij le'? xa pokon nquena' rmal, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","In bix chique rmal ja Jesús: —Ja tijonem, xa nak ta chi tijonemal, ja Nata' ja c'o chila' chicaj wi ma arja' ta ticyon rxin jari' tijonem xa nyoji cani' nba̱n tre k'ayis xa nboki. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Maxta quixocla' il chiquewach ja fariseo le', eje'e' xa e cani' moya' ja recuc'an chic jule' cach tak moya'. Pro jun moy wi nrc'aj chic jun rach moy xa netzakel pa jul chi e ca'i', queri' ja bix chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ja c'a Pedro xbij tre: —Tach'obo' chikawach ja c'ambal tzij xabij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","In bix chique rmal ja Jesús: —Taka'an matich'obtaj emwal ixix chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿La matich'obtaj c'a emwal chi ja noc pan achi' jari' nkaj chi apan in nelel chic jutij? ");
INSERT INTO tzjNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pro ja nelto pan achi' jari' pan awanma nwinakarto wi' in jari' ntz'ilorsan rxin ja rawanma. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Queri' nbij chewe como pan awanma nwinakarto wi' ja ritzel tak na'oj cani' tre banoj camíc, cani' tre tok c'o jun natoc ruq'uin ja wi ma awixjayil ta owi ma awachajil ta, cani' tre banoj alak', cani' tre ja naya' testigo'il ja ma katzij ta in cani' tre ja tok nabij jule' tzij tre ja Dios ja xa ofensa rc'amonto tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nojel awa' ritzelal ri' jari' ntz'ilorsan rxin ja rawanma no ja mataban ja costumbre tre ja ch'ajoj k'abaj jari' mta moda xtitz'ilorsax ta ja rawanma rmal. Queri' bix chique rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","C'ac'ari' ja Jesús xelel chipan ja lugar, be cha jun lugar chic ja bar c'o wi' ja ca'i' tinamit, jun rbina'an Tiro in jun rbina'an Sidón. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ja c'a tok xekaji chaka jalal tok c'o jun ixok xekaj ruq'uin. Ja rixok cananea ne'xi, in tri' c'o wi' chipan ja lugar ja xekaj wi' ja Jesús. Arja' xurak ruchi' trij ja Jesús in quewa' xbij tre ri': —Wajaw, atat ja rat Ralc'wal can ja rojer rey David, tapokonaj jutz'it nwach, c'o jun wal ocnak jun itzel espíritu tre in congana lawulo' nba̱n tre rmal, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pro ja Jesús ni majun nak ta xbij tre. Xepi c'a ja rdiscípulo in quewa' quibij tre ri': —Tabana' jun utzil, tabij tre ja rixok chi nmeloji, congana nurak ruchi' chakij, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","In bix chique rmal ja Jesús: —Ja Dios xa ruyon cuq'uin ja tinamit Israel inrtakonto wi', eje'e' e cani' tak carnelo etzaknak, xeche'x rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pro peti ja rixok, xuque' chwach in xbij tre: —Wajaw, quinato'o', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ja c'a Jesús quewa' xbij tre ja nc'ambajbej rxin: —Ma rubey ta xtic'am ta queway ja ralc'walaxela' in xtiq'uiakel ta chiquewach tak tz'i', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ja c'a rixok xbij chic jutij tre: —Wajaw, ni katzij wi' ja nabij pro ja tak tz'i' eje'e' nya̱' lugar chique cumal ja cajaw chi nquetij ja rc'utal tak way ja ntzakel xe' mesa, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","In bix chic jutij tre rmal ja Jesús: —Ixok, congana taka'an nim ja yukulbal ac'u'x wq'uin. Camic ntzuri ja rawal ja cani' xac'utuj chwe, ne'xi rmal, in ni jari' hora tzuri ja ral. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ja c'a Jesús xelel chipan ja lugar, be, xekaj chuchi' ja ya' ja bina'an tre Galilea, jote' chwach jayu', xuwil jun lugar ja bar tz'abe' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Congana e q'uiy ja winak xe'ekaj ruq'uin, equic'amonto je'e yawa'i' cani' chique tak cojo, cani' chique moya', cani' chique mema' in cani' chique ja ma tz'akat ta je'e quek'a' owi cakan, in c'a ec'o na más ja yawa'i', xe'equiya'a' chwach ja Jesús in arja' xertzursaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ja winak congana c'asc'o'i quetz'at ja bantaji, ja mema' netzijon chic, ja ma tz'akat ta je'e quek'a' owi cakan xetzuri, ja tak cojo utz chic nebini, ja moya' neca'y chic. Eje'e' congana queya' ruk'ij ja Dios, jari' Dios rxin ja tinamit Israel. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","C'ac'ari' ja Jesús xersiq'uij pon ja rdiscípulo, quewa' xbij chique ri': —Congana npokonaj quewach ja winak, tuban oxi' k'ij queq'ueje' wq'uin in mchita nak chi ta nquetij. Mta ngana nenutakel ja maquita xquewa'el, matzij xa quetujkar pa bey rmal wa'al, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ja c'a rdiscípulo eje'e' quibij tre: —Jawa' lugar ja rokc'o wi' ri' congana talani ¿bar c'a nekac'ama' wi' ja xtiquetij ja winak le'? como congana e q'uiy, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Jaru' rkan ja caxlanway c'ol ewq'uin? xeche'x rmal ja Jesús. —Wuku' rkan rachbil jun ca'i' cakan ch'u' chakaja', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ja c'a Jesús xbij chique ja winak chi netz'abe' kaj pa tok'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","C'ac'ari' xuc'am ja wuku' rkan caxlanway rachbil ch'u', xmaltioxij tre ja Dios, xuwech' in xujach chique ja rdiscípulo. Ja c'a rdiscípulo eje'e' queya' chic chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Xewa'i ja winak pro canojelal in xenoji chi utz. Ja c'a caxlanway rachbil ch'u' mol ruchi' ja totaji, wuku' chacach xuban. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ja xewa'i e quiji' mil pro xa queyon achi'i', aparte ixoki' in ac'ala'. ");
INSERT INTO tzjNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","C'ac'ari' ja Jesús xeruban can despedir ja winak, xoquel chipan ja lancha, be chipan ja lugar rbina'an Magdala. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ec'o c'a jule' fariseo e cachbil jule' saduceo, eje'e' xe'ekaj ruq'uin ja Jesús. C'oli quic'axaj tre pro xa nquic'ambajbej rxin, quewa' quibij tre ri': —Tabana' jun milagro ja nc'utu chikawach chi Dios yoyon chawe ja poder ja c'o pan ak'a', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","In bix chique rmal: —C'oli neban je'e tok noc ak'a' quewa' nebij ri': —Camic buena ja tiempo penak, ja caj nc'utuwi, congana quiak, nixche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","In c'o je'e ja pa tak sakaric quewa' nebij ri': —Ja tre jun k'ij ri' ma buena ta ja tiempo penak, ja caj nc'utuwi, congana quiak in congana mukuli, nixche'e. Caca' epalaj, ixix bien nch'obtaj emwal nak rc'amonto ja netz'at je'e chicaj pro ja ntajini nuban ja Dios chewach chipan ja tiempo ja rokc'o wi' ri' jari' ni matich'obtaj wi' emwal nak rc'amonto. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ja winak ja nec'utun chwe chi nban jun milagro utzc'a chi ninquinimaj eje'e' xa e itzel tak winak, xa quiya'on can ja Dios. Pro ja milagro ja nquic'utuj jari' ni matinban wi' chiquewach xarwari' c'o jun ja milagro nbantaj na chiquewach, jun milagro ja cani' xuban ja rojer profeta Jonás. Queri' bix chique rmal. C'ac'ari' xelel chiquicojol in be. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ja c'a tok xe'ekaji chajuparaj ya' ja c'a rdiscípulo eje'e' queya' cuenta tre chi mta queway quic'amonto, quimestaj can. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ja c'a Jesús xbij chique: —Kas bien tech'obo', kas tebana' cuenta ewi' chwach ja levadura quixin ja fariseo e cachbil ja saduceo, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ja c'a rdiscípulo eje'e' quemaj tzij chibil tak qui', quewa' nquibij ri': —Queri' nbij chake rumac ja mta way kac'ampi ta, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pro ja Jesús arja' rotak ja quimajon rbixic in quewa' xbij chique ri': —Achi'i', taka'an ma nim ta ja yukulbal ec'u'x wq'uin. ¿Nak tre tok nebij: —Taka'an mta way kac'ampi ta, kas nixche'e? ");
INSERT INTO tzjNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Maja'n ek tich'obtaj emwal? ¿La maturkaj c'a chewe ja xinban tre ja jo'o' rkan caxlanway xenutzuk jo'o' mil achi'i' tre? ¿In la maturkaj c'a chewe chakaja' jaru' chacach totaji? ");
INSERT INTO tzjNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿La maturkaj c'a chewe ja xinban chic tre ja wuku' rkan caxlanway xenutzuk quiji' mil achi'i' tre? ¿In la maturkaj c'a chewe chakaja' jaru' chacach totaji? ");
INSERT INTO tzjNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nak c'a tre tok matich'obtaj emwal ja xinbij chewe chi neban cuenta ewi' chwach ja levadura quixin ja fariseo e cachbil ja saduceo? Ma rmal ta wa'an caxlanway xemestaj can ja tok xinbij queri' chewe, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","C'ac'ari' ch'obtaj cumal chi ja xbij ja Jesús chi nqueban cuenta qui' chwach ja tijonem quixin ja fariseo e cachbil ja saduceo, ma ja ta ja levadura xin caxlanway nqueban cuenta qui' chwach. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ja c'a Jesús tok xe'ekaj chinakaj ja tinamit Cesarea ja c'o pa rcuenta Filipo arja' xc'axaj chique ja rdiscípulo: —Anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak ¿nak inocnak wi' ja nquibij chwe ja winak? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ja c'a rdiscípulo eje'e' quibij tre: —Ec'oli nebin chawe chi atat at Juan Bautista, jule' chic nebini chi at Elías in ec'o chic jule' ja nebini chi at Jeremías owi at jun chic chique ja rojer tak profeta, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Ja c'a rixix ¿nak nebij chwe, nak inocnak wi'? ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Peti ja Simón Pedro, xbij tre: —Ja ratat at Cristo at Ralc'wal ja c'aslic Dios, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ja c'a Jesús arja' xbij tre: —Congana qui'il chawe Simón ja rat rc'ajol Jonás como ja c'a xabij kaj chwe ma winak ta xek'alasan ta chawach, ja Nata' ja c'o chila' chicaj arja' k'alasan chawach. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Anin nbij chawe chi atat at Pedro in parwi' awa' ja jun abaj ri' xtintic wi' ja wiglesia in ja camíc ni maticowin wi' trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Anin c'o jule' lawe nya' na chawe rxin ja gobierno xin chila' chicaj. In xa nak ta ja mataban permitir wawe' chwach'ulew jari' ja matiban permitir chila' chicaj. In xa nak ta ja naban permitir wawe' chwach'ulew jari' ja nba̱n permitir chila' chicaj, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","C'ac'ari' xbij chique ja rdiscípulo chi ni majun bar ta tri' nquibij wi' chi arja' ja Cristo. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ja Jesús, chipan ari' tiempo xumajto rk'alasaxic chiquewach ja rdiscípulo chi rjawaxic nbe na pa Jerusalén, quewa' xbij chique ri': —Nentija' na rpokonal pa quek'a' ja principali' e cachbil ja jefe quixin sacerdote e cachbil chakaja' ja maestro ja netijon quixin ja winak tre ja ley xin Dios. Congana lawulo' xtiban na chwe, nincamsax na in chi rox k'ij ninc'astaj na, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ja c'a Pedro arja' xuchap chi ruk'a' in xumaj rch'a'ic tre ja xbij: —Dios ta xtipokonaj awach, ja xabij le' mta moda xtibantaj ta, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ja c'a Jesús xuya' vuelta in xbij tre ja Pedro: —Catel chinwach Satanás, atat xa at cani' jun abaj ninapajsaj chipan ja bey nmajon. Queri' nbij chawe como ma queri' ta nawajo' chwe chi nban ja cani' nrajo' chwe ja Dios chi nban, xa junan ana'oj cuq'uin winak, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","C'ac'ari' ja Jesús xbij chique ja rdiscípulo: —Xa nak ta ja c'o rgana nyuke' ruc'u'x wq'uin rjawaxic chi matuya' rgana ja tzabuklaj c'aslemal rc'an. Rjawaxic chakaja' chi matipokonaj nutij ja rpokonal mwal in ntre'el chwij. Jari' cani' jun cruz nya̱' trij pro matipokonaj nuc'am ja cruz, nrijkajel in nbe ja bar necamsax wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Queri' nbij chewe como xa nak ta ja npokonaj nuya' can ja rc'aslemal jari' ni matuwil wi' ja utzlaj c'aslemal ja mta q'uisic trij. Pro xa nak ta ja matipokonaj nuya' can ja rc'aslemal mwal jari' nuwil ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Como cani' tre jun winak ¿nak c'a nuch'ec trij wi xuch'ec nojel ja meba'il rxin ja rwach'ulew pro wi ma xuwil ta ja utzlaj c'aslemal ja mta q'uisic trij? Ja wi xutzak ja utzlaj c'aslemal ja mta q'uisic trij jari' mta jun meba'il ja xtilok'bej ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Queri' nbij chewe como anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak ninpi chi na jutij e wachbil ja ángel wxin, tokori' ja gloria xin Dios congana nch'a'an chwij in ja winak nunya'a' na rtojbalil chique chiquijujunal ja queban wawe' chwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ni katzij wi' ja xtinbij chewe ri', ec'oli chewe ja rec'o wawe' camic ri' c'a ec'as na ja tok xtiquetz'at ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, arja' ocnak chic Rey in xtumaj rbanic mandar chipan ja rgobierno. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ja c'a chi waki' k'ij ja Jesús xeruc'amel ja Pedro e rachbil Jacobo in Juan ja rch'alal ja Jacobo, xebe, xequiyonaj qui' parwi' jun nimlaj jayu'. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ja c'a rachbal ja Jesús xuq'uex ri' chiquewach in ja rpalaj congana ruch'a' cani' k'ij in ja rtziak congana sak xeli cani' luz. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chaka jalal tok winakar chiquewach ja Moisés rachbil Elías, quimajon tzij ruq'uin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ja c'a Pedro arja' xbij tre ja Jesús: —Wajaw, congana qui'il ja rokc'o wi' ri'. Ja wi c'ol agana atat nak tre makoq'ueje' wawe' in nkaban oxi' tak jay, jun awxin atat, jun rxin Moisés in jun rxin Elías, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","C'a rmajon na tzij ja Pedro tok chaka jalal c'o jule' sutz' congana ruch'a' xermujaj in c'o jun kulaj tzijonto chipan, quewa' xbij chique ri': —Jawa' wari' jawa' chak'laj Walc'wal, congana ninquicot trij, teya'a' ewxquin tre nak ja nbij arja' chewe, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ja c'a rdiscípulo tok c'axtaj cumal ja bix chique rmal ja kulaj eje'e' xejupe' pa tok'ulew, congana quixbej qui'. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ja c'a Jesús arja' tiloc cuq'uin, xeruchap in xbij chique: —Quixyictaji, ma texbej ta ewi', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ja c'a reje'e' tok xeca'y nojoj mchita ja Moisés mchita ja rElías, xa ruyon ja Jesús c'o can chic. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","C'ac'ari' xebe, kas exulanto parwi' ja jayu' ja tok bix chique rmal ja Jesús: —Ni majun bar ta tri' xtebij wi' ja xetz'at, c'a tokori' xtebij ja tok c'astajnak chic chiquicojol camnaki' ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ja c'a rdiscípulo eje'e' quibij tre: —Ja wi queri' nabij ¿nak c'a tre tok ja maestro xin ley eje'e' nquibij chi ja rElías rjawaxic chi arja' npi na nabey chwach ja Cristo? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","—Ni katzij wi' nquibij chi ja' Elías npeti nabey chi nurchomarsaj nojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pro anin nbij chewe chi ja rElías arja' penak chic pro eje'e' xa ma xch'obtaj ta cumal nak ja rocnak wi' in xa queban tre nak c'o quigana queban tre. In queri' xtiban tre chakaja' ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, arja' nutij na ja rpokonal pa quek'a' chakaja', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ja c'a rdiscípulo tok c'axtaj cumal ja xbij chique eje'e' ch'obtaj cumal chi tre ja Juan Bautista ntzijon wi' in ma tre ta ja rElías ja kas ntzijon wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ja c'a tok xe'ekaji ja bar ec'o can wi' ja winak c'o jun achi xurkaj ruq'uin ja Jesús, xuque' chwach in quewa' xbij tre ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Wajaw, anin c'o jun nc'ajol yawa', tapokonaj jutz'it rwach como arja' c'o jun yobil tre nuya' ataque tre in congana lawulo' nuban rmal. Q'uiylaj mul banon tre ch'akin pa k'ak' rmal in q'uiylaj mul ch'akin pa ya' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xinc'amto chiquewach ja radiscípulo pro eje'e' ma xecowin ta quitzursaj ta, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ja c'a Jesús tok c'axtaj rmal ja bix tre rmal ja rachi quewa' xbij ri': —Ixix ja rix tinamit Israel, ni taka'an mta wi' yukulbal ec'u'x wq'uin, taka'an yojtajnak ja rena'oj. Taq'ue titzuri ja nsamaj checojol, c'ayew chwe chi ncoch' más ja matiyuke' ec'u'x wq'uin. Camic tec'ama'to ja rala' wq'uin, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ja c'a Jesús tok c'amarto ja rala' ruq'uin xch'olij ja ritzel espíritu ja rocnak tre. Ni xelel ja ritzel espíritu pa ranma in ja rala' ni jari' hora tzuri. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ja c'a rdiscípulo ja Jesús eje'e' quiyonaj qui' ruq'uin in quewa' quibij tre ri': —¿Nak tre ja rajoj ma xokcowin ta kawasajel ja ritzel espíritu? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Rumac ja yukulbal ec'u'x wq'uin xa ti ma nim ta chewi' tok ma xixcowin ta. Como ni katzij wi' ja xtinbij chewe ri', ja wi c'o yukulbal ec'u'x wq'uin, wi nsamaji ja yukulbal ec'u'x ja cani' nuban jun ti chirwach mostaza nixcowin c'ari' neban jun nimlaj samaj. Cani' trewa' ja jun jayu' ri', nixcowini nebij tre chi neli ja bar c'o wi' in nbe cha jun lugar chic in nixrnimaj in mta nak chi ta ja maquita nixcowini neban. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ja ritzel tak espíritu ja re quitakala' jari' nc'atzin oración in nc'atzin ayuno chi nelasbexi, xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ja c'a Jesús c'o chic pa Galilea e rachbil ja rdiscípulo ja tok arja' xbij chic chique: —Ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak arja' nja̱ch na pa quek'a' ja winak, ");
INSERT INTO tzjNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ncamsax na cumal pro chi rox k'ij nc'astaji, ne' chique. Ja c'a reje'e' congana xebison rmal ja bix chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ja c'a tok xe'ekaj chipan ja tinamit Capernaum ec'oli winak ja nemolowi ja rimpuesto ja nbe chipan ja caja rxin ja nimlaj templo, eje'e' xe'ekaj ruq'uin ja Pedro in quewa' quibij tre ri': —Ja remaestro ixix ¿la matutoj ja rimpuesto? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Nutoj nac'a, ne'e ja Pedro chique. C'ac'ari' be ja Pedro, xoc chipan ja jay ja bar c'o wi' ja Jesús. Ja c'a Jesús arja' k'ilon rxin ja Pedro nabey, quewa' xbij tre ri': —Simón ¿nak ja nach'ob atat, ja rey rxin ja rwach'ulew chok chique nquic'utuj wi' ja rimpuesto, la chique calc'wal o la chique jule' winak chic? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Chique ja jule' chic winak, ne'xi rmal ja Pedro. Ja c'a Jesús xbij chic tre: —Ja wi queri' nqueban ma rjawaxic ta c'ari' chi nquetoj ja ralc'walaxela'. ");
INSERT INTO tzjNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pro como matikajo' nekaban ofender xa chewi' tok nbij chawe, tac'ama'el ja rabak chapbal ch'u', jat chiya'. Ja c'a tok xcatekaji taq'uiaka' ja rabak pa ya'. Ja nabey ch'u' xtachap tajaka' ja pa ruchi' in tri' nawil wi' jun pwok, ca'i' impuesto nutoj, nutoj wxin anin in nutoj awxin atat chakaja'. Xtawasaj ja pwok in najach chique ja molol impuesto, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jari' tiempo ja rdiscípulo ja Jesús eje'e' xe'ekaj ruq'uin in c'oli quic'axaj tre quewari': —¿Nak chake ja más nim ruk'ij ja tok xtoqui ja gobierno xin chila' chicaj? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ja c'a Jesús arja' xsiq'uij pon jun tac'al, xuya' chiquicojol ");
INSERT INTO tzjNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","in quewa' xbij chique ri': —Ni katzij wi' ja xtinbij chewe ri', ja wi mateq'uex ja rena'oj, wi maquixoqui ix cani' tak ac'ala' jari' nixtac'a xquixoc ta chipan ja gobierno xin chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Xa nak ta ja nuban tino'y chi noqui cani' ja jun tac'al ri' ja c'ari' ja más nim ruk'ij chipan ja gobierno xin chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ja tak ac'ala' ja re quitakawa' xa nak ta xtic'ulu jun chique in wi pa nubi' anin tok nuc'ul tibij c'a tzij ari' chi anin ja ninruc'ul. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pro congana lawulo' chique xa nak ta ja xquetakchi'in quixin awa' ja re takno'y ri' ja yukul quec'u'x wq'uin, congana lawulo' chique masqui xa ti jun chique ja nquitakchi'ij chi rbanic ja il mac. Más na mejor nxi̱m jun ca' chi quekul chanim in neq'uia̱k pa ya' in nejik'i chwach ja nquitakchi'ij jun chique wa' ja yukul quec'u'x wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ja winak wawe' chwach'ulew congana npokonaj quewach, congana lawulo' quibanon rumac ja xa netakchi'ixi chi rbanic ja il mac. Queri' nbij chewe como wi ncajo' owi mani ni netakchi'ix wi' pro congana lawulo' chique ja netakchi'in quixin. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Rmalc'ari' nbij chewe, ja wi c'o jun ek'a' owi jun ewakan wi xa nixrtakchi'ij in nixrkajsaj chipan ja il mac mejor ja neban, tekupijel in tech'akijel. Como más na utz ja xa jun ek'a' owi xa jun ewakan nixoc chipan ja utzlaj c'aslemal ja mta q'uisic trij chwach ja ca'i' ek'a' in ca'i' ewakan nixch'akix chipan ja k'ak' ja ni mta wi' chupic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","In chakaja' wi c'o jun panewach xa nixrtakchi'ij in nixrkajsaj chipan ja il mac mejor ja neban, tewasajel in tech'akijel. Como más na utz ja xa jun panewach nixoc chipan ja utzlaj c'aslemal ja mta q'uisic trij chwach ja ca'i' panewach nixch'akix chipan ja k'ak' ja ni mta wi' chupic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kas tebana' cuenta nak neban chique wa' ja re takno'y ri', nixtac'a jun ta chique xteban ta tre ni mta. Como anin nbij chewe chi ja chila' chicaj ec'oli ja ángel quixin in jari' ángel mta ari' ja maquita yatajnak chique chi ne'ekaj chwach ja Nata' ja c'o chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Como ja ranin inpenak chi quito'ic ja retzaknak, anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Nak nech'ob ixix trewa' ja xtinbij chewe ri'? Tzuc'a c'o ta jun achi ec'o ta jun ciento tak rcarnelo in ntzak ta c'a jun chique. ¿Nak nuban ja rachi nech'ob ixix? ¿La maqueruya' can ja re noventinueve in nbe pa tak k'ayis chi rcanoxic ja tzaki? ");
INSERT INTO tzjNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Queri' nuban in anin nbij chewe, ja wi nuwil jari' más na nquicot rmal ja jun xuwil chiquewach ja re noventinueve ja ma xetzak ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","In queri' c'a tre chakaja' ja Tatixel ewxin ja c'o chila' chicaj, ja rvoluntad arja' nixtac'a c'o ta jun chique wa' ja re takno'y ri' xtitz'ilox ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","In jun chic chakaja', wi c'o jun awach'alal xuban jun itzel chawe jat ruq'uin, teyonaj ewi' ruq'uin in tach'obo' chwach ja xuban chawe. Ja c'a wi nch'obtaj rmal ja nabij tre xach'ec c'ari' ja rawach'alal, xixtzur c'ari' ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ja c'a wi matich'obtaj rmal tac'ama'el jun owi e ca'i' awachbil, jat chic jutij ruq'uin. Queri' naban utzc'a chi nojel ja nbixi c'o jun owi e ca'i' testigo ja nec'axani. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ja wi ni mta wi' rgana nuch'ob ja nquibij ja testigo tabij c'a chique ja riglesia. Ja c'a wi ni mta wi' rgana nuch'ob ja nquibij ja riglesia tabana' c'a tre chi ma awachbil chi ta cani' naban chique ja molol tak impuesto e cachbil ja winak ja ma cotak ta rwach ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ni katzij wi' ja xtinbij chewe ri', xa nak ta ja mateban permitir wawe' chwach'ulew jari' ja matiban permitir chila' chicaj in xa nak ta ja neban permitir wawe' chwach'ulew jari' ja nba̱n permitir chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Jutij chic nbij chewe, mana xa e ca'i' chewe wi xa junan nquech'ob tre ja nquic'utuj pan oración jari' nc'axaxi ja coración in ja nquic'utuj jari' nyataj chique rmal ja Nata' ja c'o chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Queri' nbij chewe como ja tok ec'o ca'i' owi e oxi' ja quimolon qui' pro wi pa nubi' anin tok quimolon qui' jari' inc'o chiquicojol. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Peti ja Pedro: —Wajaw, ja wach'alal, wi q'uiylaj mul nuban itzel chwe ¿jaru' mul ncuy? ¿La sobre ari' ja wuku' mul? ne' tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","In bix tre: —Ma ja ta nbij chawe chi wuku' mul ja nacuy pro ja nbij anin chawe, wuku' mul chi setenta ja nacuy. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Rmalc'ari' tok nbij jun c'ambal tzij chewe ri'. Ja gobierno xin chila' chicaj queri' rbanic cani' nuban jun rey tok nchomij cuenta cuq'uin ja nesamaj ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ja rey tok xumaj rbanic ja cuenta cuq'uin c'o jun chique xeya̱' chwach, q'uiylaj mil quetzal ja ruc'as c'o ruq'uin, c'ayew chi naltaji. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ja c'a rajc'as como maticowini nutoj ja ruc'as chewi' tok c'o jun orden xuya' ja rey, quewa' xbij ri': —Mejor, tec'ayij ja rachi e rachbil rxjayil in ralc'wal chakaja', in nojel ja c'o ruq'uin tec'ayij chakaja'. Puersa ntojtaj na ja ruc'as, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ja c'a rajsamajel arja' xuque' chwach ja rey in quewa' xbij tre ri': —Wajaw, tiq'ue jutz'it apaciencia wq'uin, anin ntoj na nojel ja nuc'as, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ja rey congana xpokonaj rwach ja rajsamajel, xsokpijel in xucuy ja ruc'as. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pro jari' ajsamajel tok xelel chaka jalal tok quec'ul qui' ruq'uin jun chic rach ajsamajel in c'o ruc'as ja rach ajsamajel ruq'uin pro xa jun ciento quetzal ja ruc'as. C'ac'ari' xuchap chi rukul: —Tatojo' ja rac'as wq'uin, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ja c'a rach ajsamajel arja' xuque' chwach: —Tiq'ue jutz'it apaciencia wq'uin, anin ntoj na nojel ja nuc'as, ne' tre, ");
INSERT INTO tzjNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","pro arja' ma xrajo' ta. C'ac'ari' xuc'amel, xutak pa che' in xbij tre chi c'a tokori' nelto pa che' ja tok xtucoj ja ruc'as. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ja jule' chic rach tak ajsamajela' tok quetz'at ja bantaji eje'e' congana junwi' quena', xebe ruq'uin ja rey, xequibij tre nojel ja bantaji. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ja c'a rey arja' xutak rsiq'uixic in quewa' xbij tre ri': —Atat congana at itzel ajsamajel, anin xincuy nojel ja rac'as c'o wq'uin como xac'utuj chwe chi npokonaj awach. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Nak c'a tre tok ma xapokonaj ta rwach ja rawach ajsamajel ja cani' xinban anin chawe, xinpokonaj awach? Queri' ja xbij tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Congana yictaj ryewal ja rey, xujach ja ritzel ajsamajel chique jule' chic winak chi nutij pokon pa quek'a' in xbij tre chi tri' nq'ueje' wi', c'a tokori' nel libre ja tok xtutoj nojel ja ruc'as. Queri' nbij ja c'ambal tzij. ");
INSERT INTO tzjNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","In ja Nata' ja c'o chila' chicaj queri' c'a xtuban chewe ixix chakaja' chejujunal ja wi ma nojel ta ec'u'x ma nojel ta ewanma ne'ecuy ja rewach'alal ja nqueban chewe. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ja c'a Jesús tok bitaj can rmal nojel awa' jule' tzij ri' xelel chipan ja departamento Galilea in be cha jun lugar chic chajuparaj binelya' Jordán ja c'o pa rcuenta Judea. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Congana e q'uiy ja winak xetre'el trij, xe'ekaj chipan ja lugar in tri' xertzursaj wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ec'o c'a jule' fariseo xe'urkaj ruq'uin in quewa' quibij tre ri' pro xa nquic'ambajbej rxin: —Ja ley xin Dios ja tz'ibtal can rmal ja Moisés ¿la nuya' lugar tre jun achi chi nujach can ja rxjayil ja tok c'oli xa nak ta ril nuban ja rixok? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","In bix chique rmal ja Jesús: —¿La ma esiq'uin ta la'an chewi' nak quibanic ja winak ja tok kas xewinakarsaxto nabey? Ja Dios ja winakarsan quixin, achi in ixok xerwinakarsaj ");
INSERT INTO tzjNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","in quewa' xbij ri': —Rmalc'ari' ja rachi neruya' can ja rtata' rute', nquexim qui' ruq'uin ja rxjayil in xa jun cuerpo nqueban chi e ca'i', ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Queri' c'a rbanic, ma e ca'i' chi ta, xa jun cuerpo quibanon. Ja Dios como arja' bano jun chique maxta c'o jun winak tijacho quixin. Queri' bix chique rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","In quibij chic tre: —Ja wi queri' nabij ¿nak c'a tre tok xuya' jun mandamiento ja Moisés chi ja rachi nuban jun wuj in ntz'ibaj chipan chi xajutij nujach can ja rixok? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","In bix chic chique rmal ja Jesús: —Como congana cowirnak ja rewanma chi rbanic ja ritzelal xa chewi' tok xuya' lugar chewe ja Moisés chi ne'ejach can ja rewixjayilal. Pro ma queri' ta bantajnakto ja kas nabey. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Anin nbij chewe, jun achi xa nak ta chi achi'al wi nujach can chijutij ja rxjayil in ja rxjayil wi ma macunnak ta ruq'uin jun chic achi in wi nuc'am chic jun chic ixok jari' adulterio ja nuban. In wi c'o jun achi nuc'am jun ixok jachon can jari' achi adulterio ja nuban chakaja'. Queri' bix chic chique rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ja c'a rdiscípulo ja Jesús eje'e' quibij tre: —Ja wi matiya' lugar chique ja rachi'i' chi nequeya' can ja quixjayilal mejor ja nqueban, ma quequicanoj chi ta quixjayilal, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Pro ja Jesús arja' xbij chique: —Pro ja queri' ma canojel ta ja rachi'i' necowini nquinimaj pro ja yatajnak chique chi nquinimaj xa queyon ari' ja nquinimaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Queri' nbij chewe como ec'oli winak ja ni pa calaxic wi' chi ma yatal ta chique chi nec'ule'e in ec'o chic jule' xa c'oli banon chique chewi' tok ma yatal ta chique chi nec'ule'e in ec'o chic jule', rumac ja samaj nqueban pa rcuenta ja gobierno xin chila' chicaj chewi' tok maquec'ule'e. Ja necowini nquinimaj ja c'a xinbij kaj chewe ri' tiquinimaj, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ec'o c'a jule' tak ac'ala' xec'amarel ruq'uin ja Jesús utzc'a chi nuya' ruk'a' pa quewi' in nuban orar pa quicuenta. Pro ja rdiscípulo eje'e' xequich'olij ja rec'amyonel quixin ja rac'ala'. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ja c'a Jesús xbij chique: —Teya'a' lugar chique ja tak ac'ala' quepi na wq'uin, maxta ma teya' ta lugar chique como ja winak ja re'ocnak e cani' tak ac'ala' quixin c'a eje'e' ari' ja gobierno xin chila' chicaj, ne' chique, ");
INSERT INTO tzjNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","in xuya' ruk'a' pa quewi' ja tak ac'ala'. C'ac'ari' xelel chipan ja lugar. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ja Jesús chaka jalal tok c'o jun c'ajol ala' xekaj ruq'uin in quewa' xbij tre ri': —Maestro, atat congana at utzlaj achi ¿nak chi utzilal nban anin utzc'a chi nyataj chwe ja utzlaj c'aslemal ja mta q'uisic trij? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—¿Nak tre tok nabij chwe chi in utzlaj achi? Xa jun ja utz, jari' Dios. Ja c'a wi nawajo' chi nyataj chawe ja utzlaj c'aslemal ja mta q'uisic trij tanimaj c'a ja mandamiento xin Dios, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Nak chi mandamiento'il? ne'e ja rala' tre. In bix chic tre rmal ja Jesús: —Ma taban ta camíc, ma taban ta rij rwi' ja rawixjayil owi awachajil, ma taban ta alak', ma taya' ta testigo'il ja ma katzij ta, ");
INSERT INTO tzjNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","que'animaj atata' ate'. In jun chic, ja cani' nawajo' kaj awi' ayon queri' c'a tabana' chique ja winak, que'awajo' chakaja', ne'xi ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","In xbij chic tre ja Jesús: —Jala' nabij le' ni nmajonto wi' rnimaxic ja tok c'a in tino'y na. ¿La c'a c'o na ja ma nbanon ta? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Ja wi nawajo' nawc'aj jun c'aslemal ja ni majun nak ta ja maquita tz'akat tre, ja naban, jat, tac'ayij can nojel ja c'ol awq'uin, ja c'a rjil taya'a' can chique ja tak meba'i'. Ja wi queri' naban jari' c'oli ja rameba'il nyataj na chawe chila' chicaj. In jun chic, catoc ndiscípulo, jo' cattre' chwij, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ja tok xc'axaj chi queri' bix tre meloji, congana nbisoni. Queri' xuban como congana jun nimlaj meba'il ja c'o ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","C'ac'ari' ja Jesús xbij chique ja rdiscípulo: —Ni katzij wi' ja xtinbij chewe ri', jun biyom congana c'ayew tre chi noc chipan ja gobierno xin chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","In jun chic nbij chewe ri', ja camello arja' nimlaj chicop in congana c'ayew chi noc'o pa rchak jun bak diso'mbal pro jari' ma c'ayew ta chwach ja noqui jun biyom chipan ja gobierno xin Dios, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ja c'a rdiscípulo tok quic'axaj ja bix chique congana junwi' quena' in quic'axaj tre: —Jun biyom wi c'ayew chi noc chipan ja gobierno xin Dios ¿echinatak c'ari' ja newilowi ja totajem xin Dios? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ja c'a Jesús arja' xertz'elwachij in quewa' xbij chique ri': —Ja winak ni maquecowin wi' xtiquecoj ta qui' queyon chipan ja totajem xin Dios pro ja Dios arja' ni majun nak ta ja maquita ncowini nuban, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ja c'a Pedro arja' xbij tre: —Ja c'a chake ajoj, nojel ja c'o kuq'uin kaya'on can, okocnak adiscípulo, nij oktran wi' chawij ¿nak c'a nkach'ec ari' trij? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","C'ac'ari' ja Jesús xbij chique: —Ni katzij wi' ja xtinbij chewe ri', ixix nixoc na wach k'etol tak tzij chipan ja c'ac'a rwach'ulew. Tokori' tok xquinpi chic anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak in c'o jun trono ja nintz'abe' chipan ja nc'utu wxin chi congana nim nuk'ij. In ixix chakaja' ja nij ixtran wi' chwij c'o cablajuj trono nixtz'abe' chipan in nyataj chewe chi nixoc k'etol tak tzij pa quewi' ja winak ja cablajuj tribu rxin ja tinamit Israel. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","In ja winak xa nak ta chi winakil ja wi c'oli quiya'on can cani' tre cochoch owi cani' chique quinimal owi quechak' owi cana' owi cani' chique quitata' quete' owi cani' chique quixjayilal owi calc'wal owi cani' tre culew, ja c'a wi mwal anin ja tok quiya'on can jari' más chi na q'uiy ja xtiyataj na chique chwach ja cani' quiya'on can. In chakaja' c'o jun herencia nyataj chique jari' ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Xarwari' e q'uiy ja winak ja rec'amol tak bey nabey pro jari' xa necanaj can pa rq'uisbal in ja re tak q'uisbal eje'e' nec'amo chic bey como cani' nuc'ut ja c'ambal tzij ja xtinbij chic chewe ri'. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ja gobierno xin chila' chicaj queri' rbanic cani' xuban jun tatixel jutij, pa jun ak'abil chanim xelel, be chi quicanoxic jule' rmoso chi nesamaj chipan ja rtijco'm. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ja trata xuban cuq'uin ja rmoso, jun quetzal nuya' chique ja jun k'ij. Ja c'a tok tzur trata rmal xerutak chipan ja rtijco'm. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A las nueve chi lari' xelel, be pa c'aybal in tri' xeruwil chi wi' jule' achi'i', mta nak ta nqueban ");
INSERT INTO tzjNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","in xbij chique: —Ixix chakaja' jix, quixesamaj chipan ja ntijco'm in wotak ja nixntojbej, ni utz wi' nban chewe, ne' chique, in xebe. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pa tak nc'ajk'ij lari' xelel chic jutij in cani' xuban nabey ni queri' xuban chic. Ja c'a tok a las tres chi la xelel chic jutij ni queri' xuban chic chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ja c'a tok a las cinco chi la chakaja' xelel chic jutij in xeruwil chic jule' ja rachi'i', mta nak ta nqueban in xbij chique: —¿Nak tre tok wawe' ixc'o wi' chi jun k'ij, ni majun nak ta neban? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","—Como mta nak ta nbin samaj chake, xeche' tre. —Ixix chakaja' jix, quixesamaj chipan ja ntijco'm in wotak ja nixntojbej, ni utz wi' nban chewe, ne' chic chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ja c'a tok xoc ak'a' ja rajaw tijco'm arja' xbij tre ja rajsamajel ja pa'l chiquij ja moso: —Que'asiq'uij ja moso in que'atojo'. Ja xe'urkaji pa rq'uisbal eje'e' ri' ne'atoj nabey, ja c'a xe'urkaji nabey pa q'uisbal ne'atoj, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ja xe'urkaji pa rq'uisbal ja ra las cinco chi la xe'urkaji, ja tok xepeti jujun quetzal ja ya' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ja kas e'urkajnak nabey, tok xepeti, ja quech'ob eje'e' más na nim netojbexi pro xa jujun quetzal ya' chique chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ja tok jachtaj chique ja quijil quemaj wixwotem trij ja rajaw tijco'm: ");
INSERT INTO tzjNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","—Ja xe'urkaji pa rq'uisbal xa jun hora xesamaji pro xa junan xokatojbej cuq'uin pro ja rajoj makana' maquita jun k'ij xoksamaji, janila xokcosi in katij rpokonal chwa k'ij, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","C'o c'a jun chique quewa' bix tre ri': —Amigo, anin ma itzel ta nban chawe, ja trata kaban awq'uin jun quetzal ja rak'ij. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Camic tac'ama'el ja rawajil in jat. Anin nwajo' chi jun quetzal nya' trewa' jun achi ri' ja xurkaji pa rq'uisbal ja cani' xinya' chawe atat. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿La ma yatal ta c'a chwij nach'ob atat ja nban tre ja npwok nak c'o ngana nban tre? O ¿la maxta xa quiakir awanma chiquij ja jule' rumac ja xinban jun utzil chique? ne'xi ja moso rmal ja rajaw tijco'm. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Queri' rbanic cani' nbij ja c'ambal tzij, ja re c'amol tak bey nabey eje'e' xquecanaj can pa rq'uisbal in ja re tak q'uisbal eje'e' nec'amo chic bey como e q'uiy ja nesiq'uixi pro xa ma e nim ta ja necha'taj chiquicojol. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ja c'a Jesús arja' rmajon bey, benak pa Jerusalén, quiyonaj qui' cuq'uin ja cablajuj discípulo in quewa' xbij chique ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Bien tec'waxaj ja xtinbij chewe ri', camic okbenak pa Jerusalén in ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak tri' ncamsax wi', nja̱ch na pa quek'a' ja jefe quixin sacerdote e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés. Ja c'a reje'e' nquek'et tzij trij chi ncamsaxi. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nquejach na pa quek'a' ja winak ja ma e aj Israel ta utzc'a chi nyok'i, nrapaxi in ncamsax chwa cruz, in chi rox k'ij nc'astaj rwach, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","C'ac'ari' peti ja rxjayil Zebedeo erachbilanto ja ral, xuque' chwach ja Jesús. Queri' xuban como c'oli nrajo' nc'utuj tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—¿Nak nawajo' chwe? ne'xi rmal ja Jesús. —Ja tok xtoqui ja ragobierno atat xtaya' ta jun orden chi eje'e' awa' ca'i' wal ri', jun ntz'abe' pan awiquik'a' in jun chic ntz'abe' pan awixcon, ne'e ja rixok tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ja c'a Jesús arja' xbij chique ja ral ja rixok: —Ixix xa ma ewotak ta ja nixtajini nec'utuj chwe. ¿La nixcowini xtetij ja rpokonal ja cani' xtintij anin? Como ja xtiban anin chwe cani' ninban bautizar chipan jun nimlaj rpokonal. Ja c'a rixix ¿la necoch' nixk'ax chipan? ne' chique. —Nokcowini, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","In xbij chic chique: —Jari' ni katzij wi' chi netij na ja rpokonal ja cani' xtintij anin in nixk'ax na chipan ja rpokonal ja cani' xquink'ax anin chipan chakaja'. Pro ja xec'utuj chwe le' chi nixtz'abe' pa wiquik'a' in pa wixcon jari' ma wq'uin ta anin c'o wi' como jari' chomarsan chic rmal ja Nata' chok chique xtiyataj wi', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ja c'a lajuj chic discípulo tok quic'axaj ja nquic'utuj ja ca'i' ral ja rixok tre ja Jesús eje'e' congana pi quiyewal chiquij. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ja c'a Jesús arja' xersiq'uij pon in quewa' xbij chique ri': —Ixix bien ewotak jani' nqueban ja winak ja rec'o pa tak nación je'e ja c'o gobierno pa quek'a', congana e nimak nquena' in nqueban chique ja winak xa e cani' quimoso. Ja nimak quek'ij eje'e' xa congana nequeban mandar ja winak ja rec'o pa quek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pro ja chewe ixix mta moda ja queri' ta xteban. Ja c'a neban, xa nak ta chewe ja c'o rgana chi noc nim ruk'ij checojol rjawaxic chi noc jun ilinel ewxin. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Xa nak ta chewe ja c'o rgana noc jefe ewxin rjawaxic chi noc emoso. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Cani' xuban ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, arja' pi wawe' chwach'ulew pro ma rmal ta chi nilix cumal winak pro jari' peti chi arja' noc jun ilinel quixin ja winak. In peti chakaja' utzc'a chi arja' nuya' ri' pa camíc in ja rcamic e janila ja winak nerlok'bej chipan ja quil quemac. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kas quimajon elem chipan ja tinamit Jericó, congana chi winak etran trij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ec'o c'a ca'i' achi'i' e moya', etz'ubul chi' bey. Ja c'a tok quic'axaj chi Jesús ja nk'ax pa bey eje'e' quemaj rakic quechi' trij: —Kajaw, atat ja rat Ralc'wal can ja rojer rey David, tapokonaj jutz'it kawach, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pro ja winak quemaj quich'olixic: —Xa jun quixq'ue wi', ma terak ta echi', xeche'xi. Pro ja reje'e' xa más chi na querak quechi' trij ja Jesús: —Kajaw, atat at Ralc'wal can ja rojer rey David, tapokonaj jutz'it kawach, xeche' chic jutij tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ja c'a Jesús arja' pe'i, xersiq'uij pon in xbij chique: —¿Nak newajo' chwe chi nban chewe? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Kajaw, ja nkajo' chi njaktaj ta ja kawach, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ja Jesús arja' xpokonaj quewach, xuchap ja quewach in ni jari' hora jaktaji. Ja c'a tok jaktaj quewach rmal be in ja reje'e' xetre'el trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Quimajon bey ebenak, xa chinakaj ja tinamit Jerusalén ec'o chi wi' in xe'ekaj chuchi' ja tinamit Betfagé ja bar c'o wi' ja jayu' rbina'an Rjayu'al Olivo. Ja c'a Jesús ec'o ca'i' chique ja rdiscípulo xerutak ");
INSERT INTO tzjNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","in quewa' xbijel chique ri': —Jix ja pa tinamit le', chila' newil wi' jun ti bur ximili rachbil ti ral. Que'equira'to in que'ec'ama'to. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ja wi c'oli nak xquixk'iloni quewa' tebij tre ri': —Ja kajaw nec'atzin tre, quixche' tre, in alnak nerya'la'to. Queri' xbijel ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nojel ari' ma chaka ta bantaji, rumac chi tri' bantaj wi' cumplir ja bitajnak can rmal ja profeta quewari': ");
INSERT INTO tzjNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","—Ja winak ja rec'o chipan ja tinamit Sión quewa' tebij chique ri': —Tetz'ata' mpe' le', peti ja Rey ewxin, arja' matuya' ruk'ij, xa trij jun ti bur tz'ubulto wi'. Ja ti bur c'a ti co'l na, ral jun bur banol ijka'm, catche' chique. Queri' bitajnak can rmal ja profeta. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ja c'a rdiscípulo ja Jesús eje'e' xebe, xequibana' ja bixel chique rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Quec'amto ja ti bur rachbil ja ti ral. Ja quitziak jari' xequiwekbej, tz'abe'e ja Jesús trij in xumaj binem. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Congana e q'uiy ja winak quesocla' ja quitziak pa rubey ja Jesús in ec'o chic jule' xequikupla'to rxak tak palma in queya' pa rubey chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ja c'a re nabeyal chwach e cachbil ja retran trij eje'e' congana nquerak quechi' in quewa' nquibij ri': —Dios, ko'ato'o' camic, peti ja Ralc'wal can ja rojer rey David, arja' bendecido amwal, arja' ja Cristo ja penak pan abi' atat ja rat kajaw Dios. Ko'ato'o' camic Dios ja ratc'o chila' chicaj. Queri' ja nquibij. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ja c'a tok xoc chipan ja tinamit Jerusalén xeyictaji ja tinamit pro canojel in quewa' nquibij ri': —¿Nak c'a chi achi'al ala' ja xurkaji le'? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","—Jala' Jesús ja profeta ja raj Nazaret ja c'o pa rcuenta Galilea, xeche'xi cumal ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ja c'a Jesús arja' xoc chipan ja nimlaj templo xin Dios in xumajto quilasaxic canojel ja rec'o chipan ja quimajon c'ayinem e cachbil chakaja' ja quimajon lok'oj tak nakun. Ja quimesa ja q'uexol tak pwok xch'akij pa tok'ulew in queri' xuban tre chakaja' ja quich'acat ja nec'ayin tak palomax. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","In xbij chique: —Ja rtzobal Dios quewa' tz'ibtal chipan ri': —Ja wochoch anin jari' banbal oración, ne'e ja Dios tre ja rtemplo pro ja rebanon ixix tre xa jun lugar ja bar neq'ueje' wi' alak'oma', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ec'o c'a tak moya' in tak cojo, eje'e' xe'ekaj ruq'uin ja Jesús chipan ja templo, ja c'a rarja' xertzursaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ja c'a jefe quixin sacerdote e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés eje'e' quetz'at nojel ja xuban ja Jesús ja congana nc'asc'o'i natz'at in ec'o jule' ac'ala' xequic'axaj chakaja', quimajon rakic quechi' chipan ja templo in quewa' nquibij ri': —Dios, ko'ato'o' camic, peti ja Ralc'wal can ja rojer rey David, neche'e. In congana pi quiyewal rmal ja quetz'at in ja quic'axaj ");
INSERT INTO tzjNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","in quibij tre ja Jesús: —¿La matac'waxaj c'a ja quimajon rbixic chawe ja rac'ala' le'? xeche' tre. —Nc'waxaj nac'a pro ja rixix ¿la mta c'a jutij esiq'uin awa' ja tz'ibtal can chipan ja rtzobal Dios ri'? —Dios, ja tak ac'ala' e cachbil ja tak yaqui'a', atat aya'on pa quechi' ja nquiyabej ak'ij in ni majun nak ta falta tre ja nquiyabej ak'ij. Queri' ja tz'ibtal can, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","C'ac'ari' xeruya' can, be, xelel chipan ja tinamit, be c'a pa Betania in tri' xewar wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ja c'a chi rcab k'ij ak'abil ntajini nmeloji ja Jesús chipan ja tinamit Jerusalén, majtaj rmal rk'ak'anil rupan. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","In xutz'at pon jun mocaj higuera, chinakaj chi' bey tiquil wi' in be ruq'uin. Ja che' ni majun rwach, xa ruyon ruxak in rmalc'ari' tok ja Jesús quewa' xbij tre ja che' ri': —Majutij xcatwachin ta, ne' tre, in jari' hora chakiji ja che'. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ja c'a rdiscípulo eje'e' congana c'asc'o'i quetz'at in quibij tre: —¿Nak tre c'ala', ni taka'an chakiji chanim ja che'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","—Ni katzij wi' ja xtinbij chewe ri', ja wi c'o yukulbal ec'u'x ruq'uin ja Dios in wi matuban ca'i' ac'u'x jari' nixcowini neban ixix ja cani' xinban anin tre ja che' ri'. In ma ruyon tari' pro nixcowini chakaja' nebij trela' ja jun jayu' le' chi neli, nerq'uiaka' ri' pa ya' in nbe, nixrnimaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Xa nak ta ja nec'utuj pan oración wi yukul ec'u'x ruq'uin ja Dios chi rc'utuxic jari' nyataj chewe, xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ja c'a tok xe'ekaj chipan ja tinamit xoqui ja Jesús chipan ja nimlaj templo xin Dios in xumaj quitijoxic ja winak. Kas rmajon quitijoxic ja tok xe'ekaji ja jefe quixin sacerdote e cachbil ja principali' xin tinamit in quibij tre: —¿Nak atocnak wi' chewi' tok amajon rbanic nojel awa' ja kamajon rtz'atic in nak yoyon chawe chi naban? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","—Anin chakaja' c'oli nc'waxaj chewe. Ja wi xtebij chwe ja xtinc'waxaj chewe ri' anin chakaja' nbij chewe nak inocnak wi' chi nmajon rbanic nojel awa' ja remajon rtz'atic. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Camic tebij chwe, ja Juan Bautista ¿nak yo' tre ja rsamaj chi neruban bautizar ja winak, la ja' Dios ja c'o chila' chicaj ja yo' tre owi xa winak? xeche'xi rmal ja Jesús. Ja c'a reje'e' quemaj tzij chibil tak qui': —Ja wi xtikabij tre chi Dios yo' tre, arja' nbij chake: —Ja wi queri' ¿nak c'a tre tok ma xenimaj ta? ne' ala' chake. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","In wi xtikabij tre chi xa winak xeyo' tre jari' nak la xtiban chake cumal ja winak como ja chiquewach eje'e' ja Juan arja' jun profeta xin Dios, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","In quibij tre ja Jesús: —Ma kotak ta nak yo' tre, xeche' tre. —In nixtac'a anin ta chakaja' xtinbij ta chewe nak inocnak wi' chi nmajon rbanic nojel awa' ja remajon rtz'atic. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ja c'a camic ¿nak nech'ob trij awa' ja c'ambal tzij ja xtinbij chewe ri'? C'o jun achi ec'o ca'i' rc'ajol, arja' be ruq'uin jun chique ja rc'ajol in quewa' xbij tre ri': —Nc'ajol, camic jat, catesamaj chipan ja ntijco'm, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","—Ma can ta, mta ngana ninbe, ne' tre ja rtata'. Pro tok q'uiswani ti'on tre in rmalari' xuq'uex ja rna'oj in be pa samaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ja c'a tatixel arja' be chic ruq'uin ja jun chic rc'ajol in cani' xbij tre ja jun rc'ajol nabey queri' xbij tre chakaja' ja jun chic. In xbij ja rala' tre ja rtata': —Utz c'ari' ta', can ninbe, ne' tre, pro ma xbe ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Camic tebij c'a chwe ¿nak chique ja re ca'i' alc'walaxela' ja banowi ja rvoluntad ja rtata'? ne'e ja Jesús chique. —Jari' ja tzijon wi' nabey, xeche' tre. In bix chic chique rmal ja Jesús: —Ni katzij wi' ja xtinbij chewe ri', ja molol tak impuesto e cachbil ja rixoki' ja xa itzel quic'aslemal eje'e' ne'oc chipan ja gobierno xin Dios nabey chewach ixix. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Queri' nbij chewe como ja Juan Bautista arja' peti, xuc'ut chewach ja mero rbey Dios pro ja rixix ma xenimaj ta. Pro ja molol tak impuesto e cachbil ja rixoki' ja xa itzel quic'aslemal eje'e' quinimaj. Ja c'a rixix masqui xetz'at chi queri' queban pro ni ma xti'on ta wi' chewe ja rewil emac, ma xeq'uex ta ja rena'oj, ni ma xenimaj ta wi' ja Juan. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Camic tec'waxaj chic jun ja c'ambal tzij ja xtinbij chewe ri'. C'o jun tatixel c'o jun rchenoj, uva rticon chwach. Xucoj pa q'uexton, xuc'ot jun jul chipan ja bar nlasax wi' ja riya'l uva. Ja c'a chenoj xuyic jun torre chipan ja nq'ueje' chajinel parwi'. C'ac'ari' xuya' pa kajonem chique jule' ajchonla'i' in be chipan jun tinamit congana nat. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ja tok nakajinto ja tiempo ja xtiwachin wi' ja rtijco'm, arja' ec'o jule' rmoso xerutakel cuq'uin ja rajchonla'i' chi nequic'ama' ja renta. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ja rajchonla'i' tok xe'ekaji ja moso cuq'uin xequechap, jun quesoc, jun quicamsaj in jun chic queq'uiak tza'n abaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ja c'a rajaw chenoj arja' ec'o chic jule' rmoso xerutak pro más chi na e q'uiy xerutak chiquewach ja cani' xebe nabey, in cani' ban chique ja xebe nabey ni queri' chic ban chique eje'e' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ja rajaw chenoj tok q'uiswani c'o jun rc'ajol xutak cuq'uin in xbij kaj pa ranma: —Como jawa' nc'ajol nqueban respetar awa', ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pro ja rajchonla'i' ja tok xekaji ja ralc'walaxel cuq'uin quewa' quibij chibil tak qui' ri': —Jala' ja rachi le' noc na pa ruk'a' ja rulew ri' como herencia. Camic kacamsaj in noc pa kak'a' ajoj ja herencia rxin, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","C'ac'ari' quechap, quiwasajto chipan ja chenoj in quicamsaj. Queri' nbij ja c'ambal tzij. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Camic tebij c'a chwe, ja rajaw chenoj ja tok xtipeti ¿nak nuban c'ari' chique ja rajchonla'i' nech'ob ixix? xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","—Arja' ni ma jutz'it npokonaj quewach ala' ja ritzel tak winak nabij le', nercamsaj, ja c'a rchenoj nuya' chic jutij pa kajonem chique jule' chic ajchonla'i' ja cotak nquetoj ja renta tok nerila' ja tiempo chi nquetoj, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ja c'a Jesús arja' xbij chic chique: —¿La mta c'a jutij esiq'uin chipan ja rtzobal Dios jawa' jun tzij ri'? —Ja banol jay c'o jun abaj ja mta quigana ruq'uin in quech'a' pro jari' abaj cojon chic chi rbanic ja jay, arja' ja más nim ruk'ij como arja' nchapowi ja resquina'il. Jari' samaj kajaw Dios banowi in kas nc'asc'o'i nkatz'at, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Rmalc'ari' anin nbij chewe, ja gobierno xin Dios nlasax na pan ek'a' ixix in nco̱j chic pa quek'a' jun chic tinamit ja cotak nquisamajij utzc'a chi c'oli ja rutzil xin Dios nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Xa nak ta ja xa junwi' nutz'at ja rabaj ja xinbij chewe in xa nuban ofender ri' rmal jari' cani' nuban jun achi nuchok' rkan chwach jun abaj in nk'aji. In xa nak ta ja nk'e̱t tzij trij rmal ja rabaj ja xinbij chewe jari' cani' nuban jun achi ntzakto jun abaj trij in nchictaj rmal, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ja c'a jefe quixin sacerdote e cachbil ja fariseo ja tok quic'axaj ja c'ambal tak tzij ja xbij ja Jesús bien ch'obtaj cumal chi eje'e' ja xebixi. ");
INSERT INTO tzjNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Laj quechap chi nquecoj preso pro xa nquixbej qui' chiquewach ja winak como ja nquibij ja winak chi ja Jesús arja' jun profeta xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ja c'a Jesús xumaj chic jutij tzij cuq'uin, xumaj chic rbixic jun c'ambal tzij chique quewari': ");
INSERT INTO tzjNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ja gobierno xin chila' chicaj queri' rbanic cani' xuban jun rey, c'o jun rc'ajol c'ule'e in xuban jun nimlaj wa'im rxin ja c'ulbic. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Xerutak ja rmoso chi quisiq'uixic ja winak ja rerbanon chic invitar tre ja wa'im pro eje'e' ma xcajo' ta, mta quigana xepeti. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ja c'a rey xerutak jule' chic chique ja rmoso in quewa' xbijel chique ri': —Quewa' nebij chique ja winak ja renbanon chic invitar tre ja wa'im: —Jo', ja kapatrón nbij chi xuban hora rxin ja wa'im. Xerupoch' ja wacax in jule' chic chicop ja congana e chak' chic, listo chic nojelal, jo' ja pa wa'im, quixche' chique, ne'el ja rey chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pro ja c'a winak ja rebanon invitar, ja tok xe'ekaji ja moso cuq'uin, eje'e' ma xqueya' ta caso chique in junwi' xebe wi'. Jun be, nertz'ata' rchenoj in jun chic be, nerbana' ja rnegocio. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ja c'a jule' chic xequechap ja moso, lawulo' queban chique in xequicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ja c'a rey tok xekaj rbixic ruq'uin ja bantaji arja' congana pi ryewal, xerutakel ja rsoldado, xequicamsaj ja camsanela' in quiporoj ja quitinamit. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","C'ac'ari' xbij chique ja rmoso: —Xurwila' ja hora chi nbani ja c'ulbic, chomtajnak chic nojel. Ja winak ja xenuban invitar xa ma yatal ta chique ja xquepi ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ja c'a neban camic, jix pa tak bey, xa nak ta chi winakil ne'ewil que'ebana'to invitar chipan ja c'ulbic, ne'el chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Xe'elel ja moso, xebe pa tak bey, xequemol ja winak xa nak ta chi winakil wi utz ja quic'aslemal owi xa itzel. Queri' queban, ja c'a winak ja xeba̱n invitar xenoji chipan ja lugar ja bar nba̱n wi' ja c'ulbic. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pro tok peti ja rey chi nerutz'at ja winak ja rerbanon invitar c'o jun achi chiquicojol ma ja ta tziak xin c'ulbic rcojon ");
INSERT INTO tzjNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","in bix tre rmal ja rey: —Amigo ¿nak tre tok xatocto wawe' pro mta wa'an tziak acojon rxin ja c'ulbic? ne'xi, in ma xcanoy ta rmal nak ta xbij. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ja c'a rey arja' xbij chique ja ne'ilin quixin ja rinvitados: —Techapa' ja rachi le', texima' ruk'a' rkan in teq'uiaka' chipan ja nimlaj k'ekumal. Ja xquebe chipan ari' lugar janila chi ok'ej xtiqueban in xtiquicach'ach'ej cak', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Queri' rbanic como e q'uiy ja winak ja nesiq'uixi pro xa ma e nim ta ja necha'taj chiquicojol. Queri' ja c'ambal tzij ja xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ja c'a fariseo eje'e' xebe, quech'ob rij rwach nak nqueban tre ja Jesús utzc'a chi c'o jun tzij nelto pa ruchi' in jari' tzij nquichapbej rxin. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","In xequetak ja quidiscípulo eje'e', xecachbilajel jule' chic winak ja rec'o chipan ja partido rxin Herodes, xebe ruq'uin ja Jesús. Ja c'a tok xe'ekaj ruq'uin quewa' quibij tre ri': —Maestro, ajoj kotak chi atat majutij natz'ak ta tzij in chakaja' ja rbey Dios amajon rc'utic chikawach ni utz wi' naban chi rbixic. Ajoj kotak chi majun nak ta nacoj wi' awi' como atat mta jun utz in mta jun itzel natz'at. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Camic tabij chake nak nach'ob trij ja xtikabij chawe ri'. Ja rimpuesto ja nc'utux chake rmal ja César ja nimlaj rey aj Roma ¿la rubey c'ari' chi nkatoj owi ma rubey ta? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pro ja Jesús arja' bien rotak ja ritzelal ja ncajo' nqueban tre in quewa' xbij chique ri': —Caca' epalaj ¿nak tre tok newajo' ninec'ambajaj? ");
INSERT INTO tzjNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tec'utu' chinwach jun pwok ja ntojbexi rimpuesto, ne' chique. In quec'ut ja pwok chwach. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","—¿Chok xin ja wi'aj c'o chwach ja pwok ri' in nak chok xin ja bi'aj tz'ibtal chwach chakaja'? ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Rxin César, xeche' tre. —Ja rxin César tre César teya'a' wi', ja c'a rxin Dios tre Dios teya'a' wi', xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Congana c'asc'o'i quic'axaj ja bix chique, queya' can ja Jesús in xebe. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jari' mismo k'ij chakaja' ec'o jule' saduceo xebe ruq'uin ja Jesús. Ja saduceo eje'e' matiquinimaj chi nec'astaji ja camnaki'. Ja c'a tok xe'ekaj ruq'uin quewa' quibij tre ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, ja Moisés arja' rbin can chake chipan ja rtzobal Dios, ja wi c'o jun achi ncami in mta jun ti ralc'wal nq'ueje' can, ja wi c'o jun ruchak' owi rnimal rjawaxic chi nc'ule' ruq'uin ja rxjayil nq'ueje' can. Ja c'a reje'e' tok nq'ueje' jun ti calc'wal nquibij tre chi ja tac'al ralc'wal ja camnak. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Queban c'a jutij ec'o wuku' alaxic chikacojol, ja nabey winak c'ule'e pro cami in majun ti ralc'wal q'ueje' can. Ja c'a rch'alal c'ule' chic ruq'uin ja rixok ja q'ueje' can. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ja cani' xuban ja nabey winak queri' chic xuban ja rucab, cam chic chwach ja rixok in queri' xuban ja rox in queri' queban chi e wuku', xecam chwach ja rixok, ni majun calc'wal q'ueje' can. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ja c'a tok q'uiswani cami ja rixok chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Camic ¿nak c'a nabij atat tre? Ja re wuku' alaxic tok xterila' ja k'ij chi nec'astaj chipan ja camíc ¿nak c'a rchajil ari' ja rixok chique ja wuku' alaxic como xec'ule' ruq'uin chi e wuku'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","—Jala' ja nebij le' ma rubey ta como ixix xa ma ch'obtajnak ta emwal nak ja kas mero nuc'ut ja rtzobal Dios in nixtac'a ch'obtajnak ta emwal chakaja' nak rbanic ja poder rxin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Queri' nbij chewe como ja tok nec'astaji ja camnaki' jari' mchita c'ulbic chiquij tri', e cani' ángel chic xin Dios ja rec'o chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ja Dios arja' c'oli rbin can chewe chipan ja rtzobal tre ja quic'astajic ja camnaki' ¿la ma esiq'uin ta c'a? quewa' rbin can ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","—Anin in Dios rxin Abraham, in Dios rxin Isaac, in Dios rxin Jacob, queri' ja rbin can. Ja tok queri' nbij jari' nc'utbej chewach chi eje'e' masqui ecamnak chic pro ja chwach Dios ec'asli, xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ja c'a winak eje'e' quic'axaj ja xbij ja Jesús in congana c'asc'o'i quic'axaj ja tijonem nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ja c'a fariseo tok xekaj rbixic cuq'uin chi tz'apix quechi' ja saduceo rmal ja Jesús eje'e' quemol qui' in xebe ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ja c'a tok xe'ekaj ruq'uin c'o jun chique arja' bien rtijon ri' tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés in c'oli xc'axaj tre ja Jesús ja nc'ambajbej rxin quewari': ");
INSERT INTO tzjNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro ¿nak ja mandamiento xin Dios ja más na nim ruk'ij chipan ja ley? queri' xbij tre. In bix tre rmal ja Jesús: ");
INSERT INTO tzjNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","—Tawajo' ja Dios ja rawajaw pro nojel ac'u'x tawajo', in nojel awanma in nojel ana'oj tawajo' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ja c'awa' ja nabey mandamiento in chakaja' ja más nim ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ja c'a rcab mandamiento xa junan ruq'uin, quewa' nbij ri': —Ja cani' nawajo' kaj awi' ayon queri' c'a tabana' chique ja winak que'awajo' chakaja', ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jawa' ca'i' mandamiento ja xinbij chawe ri' jari' ocnak base rxin nojel ja tz'ibtal can chipan ja ley in nojel ja quitz'iban can ja profeta. Queri' ja bix tre rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ja c'a fariseo eje'e' quimolon qui' chwach ja Jesús in c'oli c'axax chique rmal quewari': ");
INSERT INTO tzjNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Nak nech'ob ixix trij ja Cristo, chok alc'walaxel nech'ob ixix? xeche'x rmal. —Ralc'wal can ja rojer rey David, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ja c'a Jesús xbij chic chique: —Ja wi queri' nebij ¿nak c'a tre tok ja David Wajaw ne' tre ja Cristo? Tokori' xbij ja tok xuban jutij uc'an rmal ja rEspíritu Santo in quewa' xbij ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","—Ja kajaw Dios quewa' xbij tre ja Wajaw ri': —Cattz'abe'e wawe' pa wiquik'a', wawe' natq'ueje' wi' in nenucoj na pan awakan ja netzelan awxin, ne' tre. Queri' rbin can ja David. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ja c'a David wi —Wajaw, ne' tre ja Cristo, tebij c'a chwe camic ¿nak c'a tre tok nbix tre ja Cristo chi xa ralc'wal can ja David? Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","In ni majun chique canoy ta rmal nak chi tzijal xbij chi ta tre. In chakaja' jari' k'ij xumajto mchita nak chi ta quic'axaj chi ta tre como xa nquixbej qui' ja nak chi ta xtiquic'axaj chi ta tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","C'ac'ari' ja Jesús xumaj chic tzij cuq'uin ja winak in cuq'uin ja rdiscípulo chakaja', quewa' xbij chique ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Ja maestro e cachbil ja fariseo eje'e' yatajnak chique chi nquech'ob chewach ja ley xin Dios ja tz'ibtal can rmal ja Moisés. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ja wi ley xin Dios ja nquec'ut chewach teya'a' ewxquin tre nojelal ja nquibij chewe in tenimaj. Pro maxta queri' ja rec'aslemal ixix ja cani' quic'aslemal eje'e' como eje'e' congana netzijon tre ja ley xin Dios pro xa matiqueban cumplir ja nbij. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Queri' nbij chewe como ja nqueban tre ja tijonem ja nqueya' cani' nimak tak ijka'm nquichomij ja congana rajlal, congana c'ayew chi rijkaxic in nqueya' chiquij ja winak pro ja reje'e' nixtac'a nquechap ta jutz'it ja rijka'm tre jun rwi' quek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pro xa nak ta ja nqueban xa por interés, ja kas ncajo' chi utz netz'a̱t cumal ja winak. Cani' tre ja nqueya' chi quipalaj in chi quek'a' ja tz'ibtali ja rtzobal Dios chwach jari' más chi na nimak nqueban tre. Queri' nqueban tre utzc'a chi nquic'utbej qui' chiquewach winak chi más chi na e utzlaj tak winak. In jun chic nqueban, congana nqueban rbanic ja ruchi' quitziak, más chi na nimak tak pleca nquecoj tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","In cani' tre tok neba̱n invitar pa nimak tak wa'im congana nel quec'u'x trij ja tz'ulbal je'e ja más nimak ruk'ij in queri' nqueban chakaja' ja tok nebe pa tak jay xin molbal ri'il ja bar nc'axax wi' ja rtzobal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","In cani' tre ja tok nebin pa tak c'aybal congana nel quec'u'x trij ja neba̱n saludar in tok —Maestro, Maestro, neche'x cumal ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pro ja rixix maxta congana tel ec'u'x trij ja nbix maestro chewe como xa jun ja Maestro ewxin jari' ja Cristo, ja c'a rixix ix alaxic ewanojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","In como xa jun Tatixel ewxin ja c'o chila' chicaj chewi' tok nbij chewe chakaja' chi mta jun xtebij ta Tatixel tre wawe' chwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","In chakaja' maxta congana tel ec'u'x trij ja nbix jefe chewe como xa jun ja Jefe ewxin jari' ja Cristo. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ja checojol ixix ja noc ilinel ewxin jari' ja más nim ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Xa nak ta ja xa ruk'ij nuya' kaj ruyon jari' nerila' na jun k'ij tok xtikaji in xa nak ta ja nuban tino'y jari' nerila' na jun k'ij tok xtiya' na ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Pro congana lawulo' chewe ixix ja rix maestro rxin ja ley xin Dios ja tz'ibtal can rmal ja Moisés in chewe ixix ja rix fariseo, caca' epalaj como ixix nixtajini netz'apij quebey ja winak chiquewach utzc'a chi maque'oc chipan ja gobierno xin chila' chicaj. Nixtac'a ixix ta ixocnak ta chipan in nixtac'a neya' ta lugar chique ja winak ja c'o quigana ne'oc chipan. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Congana lawulo' chewe ixix ja rix maestro in chewe ixix ja rix fariseo, caca' epalaj como ixix kas k'alawachili nemaj chique ja malca'n tak ixoki' ja tak cochoch, neban nimak tak oración pro xa por interés tok neban. Rmalc'ari' nbij chewe, ja tok xtik'et tzij chewij más chi na jun nimlaj rpokonal xtetij na. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Congana lawulo' chewe ixix ja rix maestro in chewe ixix ja rix fariseo, caca' epalaj como ixix congana netij ek'ij nixbe nat nakaj chi rch'aquic jun winak chi noc ewachbil chipan ja rereligión pro ja c'a tok ewachbil chic xa más chi na ralc'wal diablo chewach ixix rumac ja tijonem neya' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Congana lawulo' chewe como ixix ix c'amol tak bey quixin ja winak pro xa ix moya' como ixix quewa' ja tijonem neya' chique ri': —Ja tok naban jun juramento wi nanataj ja nimlaj templo xin Dios chi rbanic cumplir jari' ma rjawaxic ta chi naban cumplir ja nabij pro ja wi nanataj ja oro ja c'o chipan ja templo jari' puersa naban cumplir ja nabij, taka'an nixche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ixix xa ix moya', xa ix nacnak tak winak ¿la ma ewotak ta c'a chi ja templo jari' más chi na nim ruk'ij chwach ja oro ja c'o chipan ja templo? como ja oro wixta ma chipan ta ja templo c'o wi' xta c'a junan ari' ruq'uin xa nak ta chi oro'il. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","In jun chic ja nebij chakaja' quewari': —Ja wi nanataj ja raltar chi rbanic jun juramento jari' ma rjawaxic ta chi naban cumplir ja nabij pro ja wi nanataj ja rofrenda ja nya̱' parwi' ja raltar jari' puersa naban cumplir ja nabij, taka'an nixche'e chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Xa ix moya', xa ix nacnak tak winak ¿la ma ewotak ta c'a chi ja raltar jari' más chi na nim ruk'ij chwach ja rofrenda ja nya̱' parwi'? como ja rofrenda wixta ma parwi' altar ta nya̱' wi' xta c'a junan ruq'uin nakun je'e ari'. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Rmalc'ari' anin nbij chewe, ja wi nanataj ja raltar chi rbanic jun juramento jari' ma ruyon ta altar nanataj pro ni rachbil ja rofrenda nanataj ja c'o parwi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","In chakaja' ja wi nanataj ja templo chi rbanic jun juramento jari' ma ruyon ta templo nanataj pro ni rachbil ja Dios nanataj ja rbanon rochoch tre ja templo. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","In chakaja' ja wi nanataj ja chila' chicaj chi rbanic jun juramento jari' ma ruyon ta ja chila' chicaj nanataj pro ni rachbil ja rtz'ulibal ja Dios ja nimlaj Rey nanataj in ni rachbil ja Dios nanataj chakaja' ja ntz'abe' chipan ja rtz'ulibal. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Congana lawulo' chewe ixix ja rix maestro in chewe ixix ja rix fariseo, caca' epalaj como ixix congana nixocla' il chi rya'ic ja reprimisia pro c'a c'o na más nbij ja ley xin Dios chi neban ja más chi na rjawaxic chi neban pro jari' ni ma ebanon ta. Congana ix conforme chi neya' eprimisia, neya' jule' ichaj cani' tre menta, cani' tre anís in cani' tre comino, pro ja banoj utzil jari' ni ma ebanon ta wi', matepokonaj quewach winak in mateban cumplir ja netzujuj chakaja'. Pro jari' ni rjawaxic wi' chi neban cumplir in ni rjawaxic wi' chakaja' chi matetanba' rya'ic ja reprimisia. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ixix ix c'amol tak bey quixin ja winak pro xa ix moya'. Ja remajon rbanic cani' nuban jun achi rmajon wa'im, ec'o c'a jule' tak us chaka jalal xekaj chipan ja nuti' cachbil jun nimlaj chicop. Ja c'a rachi arja' nerlatz'uj can ja tak us pro xa matocla' il chi rlasaxic ja nimlaj chicop in xa matuna' nbe chi rukul. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Congana lawulo' chewe ixix ja rix maestro in chewe ixix ja rix fariseo, caca' epalaj como congana nixocla' il chi rch'ajic rij tak eplato in rij tak evaso chakaja' pro pa tak ewanma cani' rbanic jun vaso ja congana tz'il c'o chipan como nojnak tre ja nakun je'e ja xa ewalak'anto como congana ix muna'. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo, ixix xa ix moya', ja kas rjawaxic chi neban nabey, ma tewalak'aj chi ta nakun ja neya' chipan ja revaso in chipan ja replato utzc'a chi ja rij ni katzij wi' chi ch'ajch'oj chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Lawulo' chewe ixix ja rix maestro xin ley in chewe ixix ja rix fariseo, caca' epalaj como ixix ix junan ruq'uin ja quipanteón camnaki' ja bien chuman rij in congana buena ntz'ati pro xa nojnak quibakil camnaki' chipan in congana rchuwil. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","In ni c'a queri' ja rebanic ixix chakaja', nek'alasaj ewi' chiquewach winak chi congana ix utzlaj tak winak pro ja c'a rewanma jari' nojnak ja ritzelal chipan in mta ari' ja maquita neban caca' epalaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Lawulo' chewe ixix ja rix maestro in chewe ixix ja rix fariseo, caca' epalaj como ixix neban rbanic ja quipanteón ja rojer tak profeta in newek ja lugar je'e ja bar nenatax wi' ja jule' chic utzlaj tak winak ");
INSERT INTO tzjNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","in quewa' nebij ri': —Ja kati't kamama' ojer eje'e' xequicamsaj ja profeta pro wixta okc'ol ajoj tri' mta moda xekachbilaj ta chi quicamsaxic, nixche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ja tok nebij: —Kati't kamama', tok nixche'e, jari' noc testigo'il chewij chi ixix ix calc'wal can ja xecamsan quixin ja profeta. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Camic nbij chewe, teq'uisa' c'a rbanic ja quiticon can ja rewati't emama' ojer. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Congana ix itzel tak winak, ix cani' jule' itzel tak cumatz ¿nak moda xteto' ewi' maquita xquixban condenar chi nixtakel pa k'ak'? ");
INSERT INTO tzjNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Rmalc'ari' ja tok nbij chewe chi ec'oli winak nenutakel checojol cani' chique profeta in cani' chique jule' chic ja solo rna'oj Dios nquecoj in cani' chique maestro. Ja c'a neban ixix chique, ec'oli chique ne'erip chwach cruz, ne'ecamsaj in ec'oli chique ne'erapaj pa tak jay xin molbal ri'il ja bar nemol wi' ewi' chi rc'axaxic ja rtzobal Dios in ne'esaluj. Q'uiy ja tinamit nek'ax wi' emwal in nij ixtran wi' chiquij chi quisaluxic. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Queri' ja nbantaji utzc'a chi chewij ixix nkaj wi' ja rtojbalil ja quicamic canojel ja utzlaj tak winak ja recamsanto chwach ja rwach'ulew. Ja kas nabey Abel ja camsaxi, congana utzlaj winak ja rAbel. In ja c'a q'uisbex rcamsaxic Zacarías ja rc'ajol Berequías. Ja Zacarías arja' camsax cumal ja rewati't emama' in ja camsax wi', chicojol ja templo in ja raltar ja c'o chwach ja templo. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ni katzij wi' ja xtinbij chewe ri', nojel ja c'a xinbij chewe, ja rtojbalil chewij ixix nkaj wi' ja rix tinamit Israel. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ixix ja rix aj Jerusalén, anin congana ninbison emwal. Ja profeta xin Dios xa ne'ecamsaj. Ja c'a jule' chic ajsamajela' rxin Dios ja neta̱k ewq'uin xa ne'eq'uiak tza'n abaj. Anin q'uiylaj mul xinwajo' ta xixnuto' ta ja cani' nuban jun ac' nermutzej ja tak ral xe' rupan pro ja rixix ma xewajo' ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Camic bien tec'waxaj ja xtinbij chewe ri', ja retinamit rachbil ja templo c'o chipan jari' ya'on can chic rmal ja Dios, lawulo' xtiban na tre in xa ntale' can. ");
INSERT INTO tzjNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Queri' nbij chewe como ja camic matutz'at chic ri' kawach ewq'uin, c'a tokori' nutz'at chic jutij ri' kawach ewq'uin ja tok xterila' ja k'ij tok quewa' nebij chic chwe ri': —Bendecido ja Cristo ja penak pa rubi' ja kajaw Dios, xquixche' chwe. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","C'ac'ari' xelto ja Jesús chipan ja nimlaj templo xin Dios, kas rmajon binem ja tok xetiloc ja rdiscípulo ruq'uin in quewa' quibij tre ri': —Tatz'ata' can mpe' ja templo le', congana banon rbanic, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pro bix chique rmal ja Jesús: —Ja rixix nixtajini netz'at ja lale' pro anin nbij chewe, jala' templo le' nerila' na jun k'ij ja tok xtiyoji nojelal, ni majun abaj xtirikla' chi ta ri', xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ja c'a Jesús arja' tz'ubul parwi' ja ti jayu' rbina'an Rjayu'al Olivo in ec'oli chique ja rdiscípulo quiyonaj qui' ruq'uin in quibij tre: —Tabij chake ¿nak k'ij xtibantaji jala' ja c'a xabij kaj chake le'? In chakaja' ¿nak chi retalil nwinakari ja nc'utu rxin chi xajalal maja'n catmelojpi chic jutij in ja tok xtiq'uis awa' ja rwach'ulew ri'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ja c'a Jesús quewa' xbij chique ri': —Kas tebana' jutz'it cuenta ewi', maxta c'o jun quixbano engañar. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Queri' nbij chewe como e q'uiy ja winak nepi na je'e in xa queyon nquecoj qui' chi e Cristo, quewa' nquibij chique ja winak ri': —Anin in Cristo, neche' na chique, in e q'uiy ja winak ja xquequeban engañar. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","C'o nimak tak ch'a'oj xtiban na nojel nat nakaj pro ja tok xtekaj rbixic ewq'uin maxta texbej ewi' rmal como ni rjawaxic wi' chi nbantaj cumplir nojel awa' wari' pro jari' ma q'uisbal rwach'ulew ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Queri' nbij chewe como c'o je'e tinamit xtiyictaj na trij jule' chic tinamit in chakaja' ja gobierno je'e nyictaj trij jule' chic gobierno. In chakaja' c'o nimak tak rc'ayewal xtiwinakar na pa tak lugar je'e cani' tre nimak tak wa'al, nimak tak yobil in cubarkan. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nojel awa' wari' xa majbal rxin ja nimak tak rpokonal. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ja c'a rixix nixjach na pa quek'a' winak chi nba̱n pokon chewe in nixcamsax na. Xa itzel nixtz'at na cumal ja winak ja rec'o nojel tak nación pro mwal anin ja tok xtiban queri' chewe. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chipan ari' tiempo e q'uiy ja winak ja xtiqueya' can ja yukulbal quec'u'x ja c'o wq'uin in ec'oli ja cachbil xa nequejach pa quek'a' ja netzelan quixin, xa itzel xtiquetz'at chic qui' chibil tak qui'. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","In e q'uiy ja winak ja newinakar na e profeta neche'xi, pro ma katzij ta chi e profeta in e q'uiy ja winak ja xquequeban engañar. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ja c'a ritzelal janila xtibe más pa nim in rmal ja congana itzelal nbani xa chewi' ja tok e q'uiy ja winak xa nchupi ja rajoben ri'il ja c'o pa tak canma, xa nq'uisi. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pro canojel ja xtiquecoch' quewach chipan ja rpokonal in ni matiqueya' can wi' ja yukulbal quec'u'x wq'uin eje'e' ri' nquewil na ja totajem xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ja c'a utzlaj tzij ja nc'amonto tre ja gobierno xin chila' chicaj jari' nel na rbixic nojel nat nakaj, nojel rwach'ulew nekaj wi'. Nojel nekaj wi' rbixic utzc'a chi nquic'axaj ja winak ja rec'o nojel tak nación. C'a tokoc'ari' xtipeti ja q'uisbal rwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Rmalc'ari' nbij chewe, kas turkaj chewe ja bitajnak can rmal ja rojer profeta Daniel. Ja xbij ja Daniel chi nerila' na jun k'ij ja tok c'oli ja npeti ja más chi na itzel ntz'a̱t rmal ja Dios. Ja c'a tok npeti arja' npe'e chipan ja lugar santo in congana camíc nuban. (Ja nesiq'uin awa' jule' tzij ri' kas tiquiwasaj jutz'it quina'oj trij.) ");
INSERT INTO tzjNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jari', tok xtetz'at chi pa'l chic chipan ja lugar santo, ja c'a neban, ja rixc'o chipan ja departamento Judea mejor quixanmaji, tewawaj ewi' pa tak c'achelaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ja rixc'o parwi' terraza tri' mejor quixanmaji chakaja', ma quixkajpi chi ta pa tak ewochoch chi rlasaxic ja remeba'il pa jay, ");
INSERT INTO tzjNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","in ja rixc'o pa tak chenoj tri' mejor quixanmaji chakaja', ma quixmelojpi chi ta chi ewochoch chi rc'amaric echaqueta. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Anin congana npokonaj quewach ja rixoki' ja xajalal maja'n queq'ueje' tak cal tri' in chakaja' ja rec'o chic tak yaqui'a' chwaquek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tec'utuj tre ja Dios chi ma pa rtiempo tew ta ja tok xterila' ja k'ij chi nixanmaji in ma pa jun xula'nbal k'ij ta chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Queri' nbij chewe como c'o jun nimlaj rpokonal npi na pro janila nim. Jaru' pa tiempo tz'ucarnakto ja rwach'ulew mta jun rpokonal penak ta ja más chi ta nim chwach awa' ja nintajini nbij chewe ri' in ni mchita wi' jun xtipi chi ta ja más chi ta nim chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Xarwari', xa pajtali ja rtiempo. Ja c'a wixta maquita pajtali ja rtiempo ni ta majun winak xtuto' ta ri' chipan. Pro cumal ja winak ja recha'on rmal ja Dios chewi' tok pajtali ja rtiempo. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ja c'a wi c'o jun xtibij chewe chi: —Peti ja Cristo, wawe' c'o wi' ri', wi ne'e, ma tenimaj ta. Owi nbij chewe chi: —Quela' c'o wi' le', wi ne'e, chakaja' ma tenimaj ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Queri' nbij chewe como ec'oli winak ja nepi na, jule' xtiquecoj qui' chi e Cristo in jule' xtiquecoj qui' chi e profeta xin Dios pro ma katzij ta ja nquibij. Eje'e' c'o nimak tak milagro xtiqueban, jutz'it laj nequeban engañar ja winak ja recha'on rmal ja Dios pro jari' mta moda xquequech'ec ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bien tebana' cuenta ewi' chwach ja wari' como xinya' pon rbixic chewe. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Rmalc'ari' nbij chewe, ja c'a wi ec'oli nebin chewe chi: —Jo' mpe', peti ja Cristo, c'o jun lugar kas talani, tri' c'o wi', wi neche'e, ma quixbe ta. Owi nquibij chewe chi: —Jo' mpe', c'o jun cuarto ja rwawan wi' ri', wi neche'e, ma tenimaj ta chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Queri' nbij chewe como cani' nuban ja cayipa' tok nuq'uiak ri' chicaj chaka bar ta tri' ntz'a̱t wi' in queri' c'a tre chakaja' ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, ja tok xtipi chic jutij wawe' chwach'ulew jari' mta bar ta tri' ja maquita ntz'a̱t wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ja juicio puersa nkajto na ja cani' nqueban ja c'uch, xa bar ta tri' c'o wi' ja camnak tak cuerpo tri' nekajto wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ja tok chaka maril xtoc'owi jawa' nimlaj rpokonal ri' c'ac'ari' matica'y chic ja k'ij, nk'ekumiri in matica'y chic ja ic' chakaja'. Ja c'a ch'umil jari' netzakto in ja nimak tak poder rxin ja caj nsi̱l na. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","C'ac'ari' c'o jun retal nwinakar chicaj jari' retal ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak chi xajalal maja'n tipi chic jutij wawe' chwach'ulew. Ja c'a winak ja rec'o nojel tinamit wawe' chwach'ulew eje'e' nquemaj na jun nimlaj bis, nquetz'at na ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, arja' penak c'amonto rmal jule' sutz', janila jun nimlaj poder c'o chic pa ruk'a' in congana nim chic ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","C'o c'a jun trompeta nc'axax na congana nim rukul, jari' nertakbejel ja ángel rxin chi nebe, ne'equimolo' ja winak ja recha'on rmal pro nojel rwach'ulew nebe wi' chi quimolic, mta ja maquita xque'ekaj wi' chi quimolic. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Camic tewasaj c'a ena'oj tre jun che' higuera jari' nc'ambej tzij chewach. Ja higuera ja tok npulani c'o tak ruk'a' nwinakari in ruxak chakaja' jari' retal nuc'ut chewach chi xa nnakajinto ja rtiempo c'atan. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","In queri' c'a tre chakaja' ja tok xtemaj rtz'atic nojel ja c'a xinbij chewe jari' retal nuc'ut chewach chi ma nat chi ta c'o wi' ja k'ij ja xec'waxaj chwe, congana nakaj c'oto chi wi' tri'. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ni katzij wi' ja xtinbij chewe ri', ja tinamit Israel eje'e' c'a ec'o na ja tok nbantaj cumplir nojel awa' wari', ma chupnak ta quewach. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ja caj in rwach'ulew jari' xa nchup na rwach pro ja ntzobal anin jari' ni matichup wi' rwach, mta ari' ja maquita nbantaj cumplir. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pro majun winak otakyon ja mero k'ij in ja mero hora ja xtibantaji in nixtac'a ángel ta chakaja' ja rec'o chila' chicaj pro ja nata' Dios xa ruyon arja' ja rotakyon. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Xarwari', ja cani' bantaji ja pa rtiempo ja Noé ojer queri' c'a xtibantaj chic chakaja' ja tok xtipi chic jutij wawe' chwach'ulew ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Queri' nbij chewe como ja pa rtiempo ja Noé, ja tok maja'n tipeti ja nimlaj k'ekaljab ja winak xa banoj tak wa'im ne'ocla' wi' il in banoj tak c'ulbic in nijawari' quimajon rbanic ja tok xoqui ja Noé chipan ja nimlaj lancha. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ja c'a winak ni ma xquech'ob ta wi' ja penak chiquij, c'a tokori' ch'obtaj cumal ja tok peti ja nimlaj k'ekaljab chiquij, congana lawulo' ban chique rmal ja ya' in xejik'i canojelal. In queri' c'a tre chakaja' ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak ja tok xtipi chic jutij wawe' chwach'ulew, c'a ja' xtiquena' ja winak tok xtipeti. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ja c'a tok xterila' ri' tiempo e ca'i' achi'i' xa jun ec'o wi' pa chenoj tri', jun xtic'amarel in jun xticanaj can chipan ja rpokonal. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","In chakaja' e ca'i' ixoki' ja xa jun ec'o wi' quimajon que'em tri', jun xtic'amarel in jun xticanaj can. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Rmalc'ari' nbij chewe, quixc'asc'oti como anin in ewajaw in ma ewotak ta nak k'ij xquinmelojpi chic jutij. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pro bien teya'a' ewxquin tre ja xtinbij chewe ri', jun rajaw jay ja tok nba̱n alak' ruq'uin, ja wixta rotak nak hora chi nekaji ja ralak'om ruq'uin chak'a' nchajij ta c'ari' rochoch, nc'asc'ot ta c'ari' in maquita nuya' lugar tre ja ralak'om chi noc ta pa rochoch. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Rmalc'ari' nbij chewe, ni rjawaxic wi' chi nixc'asc'ot ixix chakaja' como ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak arja' chaka jalal tok xtipi chic jutij chipan jun hora ja ni ma ech'obon ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tech'obo' c'a chi utz ja xtinbij chewe ri', ja rajsamajela' ¿echinatak ja nebano cumplir ja nbix chique cumal ja quipatrón, echinatak ja buena quina'oj? Cani' tre jun patrón tok c'o jun ajsamajel ruq'uin in nuya' rsamaj chi arja' npe'e chiquij ja jule' chic rach tak ajsamajela' chi neruban cuenta in nuya' queway ja tok nc'atzin chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Congana qui'il tre ja rajsamajel ja wi ntajini nuban cumplir ja rsamaj ja tok xturkaji ja rpatrón ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","¿Nak nuban ja patrón? Seguro chi nojel ja meba'il c'o ruq'uin nujach pa ruk'a' awa' jun ajsamajel ri' chi arja' npe'e trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pro ja rajsamajel wi xa itzel rna'oj in wi xa nbij kaj pa ranma chi: —Na la k'ij npit ari' ja npatrón, wi ne' kaj, ");
INSERT INTO tzjNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","in wi numaj quich'ayic ja rach tak ajsamajela', wi xa banoj tak wa'im in tijoj tak ya' nuban cuq'uin k'abarela', ");
INSERT INTO tzjNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ja wi xa queri' ntajini nuban nerila' na jun k'ij tok c'a ja' xtuna' xturkaji ja rpatrón, ni majun nak ta rnaben. ");
INSERT INTO tzjNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ja c'a rajsamajel janila jun nimlaj rpokonal xtutij pa ruk'a' ja rpatrón in nta̱kel rmal chipan ja lugar ja bar ec'o wi' ja winak ja xa caca' quipalaj. Ja c'a winak janila chi ok'ej xtiqueban chipan ari' lugar in xtiquicach'ach'ej cak'. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ja c'a chipan ari' tiempo ja gobierno xin chila' chicaj queri' rbanic cani' queban e lajuj xtani' k'apoja'. Eje'e' como c'o jun c'ulbic nbani quec'amel quicandil chiquijujunal, xebe chi rc'ulic ja rachi ja nc'ule'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E jo'o' chique congana quina'oj pro ja re jo'o' chic ma e queri' ta, xa ma ch'obol ta ja queban ");
INSERT INTO tzjNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","como mta más aceite quec'amel ja nutij ja candil chi ntzije'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pro ja xtani' ja congana quina'oj eje'e' quec'amel chi na jule' ja raceite rxin ja quicandil. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ja rachi ja nc'ule'e como ma xpi ta chanim rmalc'ari' xemajtaj ma waram chi e lajuj in xewari. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pro ja pa tak nc'ajak'a' c'o jun kulaj c'axaxi, quewa' nbij ri': —Camic peti ja rachi ja nc'ule'e, quixelto, terc'ulu', ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Xeyictaji ja xtani' chi e lajuj, quemaj rchomarsaxic ja quicandil. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ja c'a xtani' ja mta más aceite cuq'uin eje'e' c'oli quibij chique ja cach tak xtani' ja congana quina'oj quewari': —Taka'an nchupi ja kacandil, teya'a' jule' kaxin ja raceite, xeche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","—Ma can ta, matzij ma koruban ta ajoj ja xtikaya' ta jalal tak ewxin. Mejor ja neban, jix ja bar nc'ayix wi', tri' jelok'o' wi' ewxin, xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Queri' queban, xebe chi rlok'ic ja raceite. Kas c'a ebenak ja tok xurkaji ja rachi ja nc'ule'e, xoc pa jay ja bar nba̱n wi' ja wa'im xin c'ulbic e rachbil ja xeq'ueje' listo chi rc'ulic in tz'apixi ja chi'jay. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ja c'a jule' chic xtani' ja rebenak eje'e' xemelojto. Ja c'a tok xe'urkaji quewa' quibij ri': —Kajaw, Kajaw, tajaka' chi'jay chikawach, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pro bixto chique rmal ja rachi: —Ni katzij wi' nbij chewe chi ma wotak ta ewach, xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Rmalc'ari' nbij chewe, quixc'asc'oti como ma ewotak ta nak k'ij in nak hora xtipi chic jutij ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","In jun chic, ja gobierno xin chila' chicaj queri' rbanic cani' xuban jun achi tok xajalal maja'n tibe pa viaje, arja' xersiq'uij ja rmoso. Ja c'a tok xe'ekaj ruq'uin xumaj rjachic ja rmeba'il pa quek'a' ja nquibanbej can rnegocio. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jun, jo'o' mil quetzal xuya' can tre, jun chic, ca'i' mil xuya' can tre in jun chic, jun mil xuya' can tre. Jani' necowini nquisamajij xa jari' xuya' can chique chiquijujunal. C'ac'ari' be pa viaje. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ja ya'on can jo'o' mil quetzal tre, arja' be, xumaj rsamajixic ja pwok, xumaj negocio tre in jo'o' mil quetzal xuch'ec trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","In queri' xuban chic chakaja' ja ya'on ca'i' mil quetzal tre, ca'i' mil xuch'ec trij chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pro ja c'a ya'on jun mil quetzal tre, arja' be, xuc'ot jun jul pa tok'ulew in tri' xwawaj wi' ja pwok ja ya'on can tre rmal ja rpatrón. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ja tok be jun tiempo tre pro jun tiempo nim, jari' moso melojto ja quipatrón in xumaj rbanic cuenta cuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ja c'a ya'on can jo'o' mil quetzal tre, arja' peti, rc'amonto chic jo'o' mil quetzal in xbij tre ja rpatrón: —Wajaw, atat jo'o' mil quetzal aya'on can chwe, tatz'ata' mpe', xinch'ec jo'o' mil trij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","In bix tre rmal ja rpatrón: —Utz xaban tre ja samaj, atat at jun utzlaj moso, janila naban cumplir ruq'uin ja rasamaj. Xa ti ma nim ta ja xinya' can chawe pro xaban cumplir. Camic, más chi na q'uiy xtinya' chawe chi nasamajij. Camic catajo', ninawachbilaj chipan ja quicotemal, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ja c'a ya'on can ca'i' mil quetzal tre, arja' peti chakaja' in xbij tre ja rpatrón: —Wajaw, atat ca'i' mil quetzal aya'on can chwe, tatz'ata' mpe', xinch'ec ca'i' mil quetzal trij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","In bix tre rmal ja rpatrón: —Utz xaban tre ja samaj, atat at jun utzlaj moso, janila naban cumplir ruq'uin ja rasamaj. Xa ti ma nim ta ja xinya' can chawe pro xaban cumplir. Camic, más chi na q'uiy xtinya' chawe chi nasamajij. Camic catajo', ninawachbilaj chipan ja quicotemal, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","In chakaja' ja ya'on can jun mil quetzal tre, arja' peti in xbij tre ja rpatrón: —Wajaw, anin bien ch'obtaj mwal chi atat at jun achi at c'a'n in wotak chi xa ch'ecoj nawajo' tre ja rapwok pro mta samaj naban. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Rmalc'ari' xinxbej wi', ja jun mil quetzal aya'on chwe, xinbe, xenmuku' can pa tok'ulew. Camic nc'amonto ja rapwok ri', tac'ama' pon, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pro bix tre rmal ja rpatrón: —Atat xa at jun itzel moso, xa at sak'or. Ja wi queri' xach'ob chwij chi anin xa ch'ecoj nwajo' tre ja npwok in mta samaj nban ");
INSERT INTO tzjNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ja ta c'a xaban xaya' ta ja npwok pa banco. Ja wixta queri' xaban, ja c'a tok xinpeti jach ta c'ari' ja npwok chwe rachbil ta ral, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","C'ac'ari' ja patrón xbij chique jule' chic rmoso: —Camic, temaja' ja jun mil quetzal tre in teya'a' tre ja c'o lajuj mil quetzal ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Queri' neban tre como ja winak ja c'o je'e yatajnak chique in wi nquisamajij jari' xa jani' nyataj más chique in tok xtiq'uiswani congana nq'uiyi, nuban q'uiy cuq'uin. Pro ja winak ja matiquisamajij ja yatajnak chique eje'e' nlasax chique ja yatajnak chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jala' jun moso le' xa mta noc wi', camic techapa', teq'uiakel chipan ja nimlaj k'ekumal. Ja c'a winak janila chi ok'ej xtiqueban chipan ari' lugar in xtiquicach'ach'ej cak'. Queri' xbij ja patrón chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak arja' npi chi na jutij, janila nim chic ruk'ij, erachbilanto canojel ja ángel. Tokoc'ari' xtitz'abe' chipan ja rtz'ulibal, jari' tz'ulbal xin Rey in janila nim ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","In nojel tinamit nemo̱l chwach, c'ac'ari' nuban ca'i' chique cani' nuban jun yuk'ul carnelo, junwi' neruya' wi' ja tak carnelo in junwi' neruya' wi' ja tak q'uisic'. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ja re cani' tak carnelo eje'e' pa riquik'a' neruya' wi', ja c'a re cani' tak q'uisic' pa rxcon neruya' wi'. Queri' xtuban ja Rey. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ja c'a rec'o pa riquik'a' quewa' xtibij chique ri': —Ixix utz ixtz'aton rmal ja nata' Dios, camic quixajo' c'a, quixoc chipan ja gobierno xin chila' chicaj, jari' ja herencia ewxin chominto ojer ja tok maja'n titz'ucarsaxi ja rwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Queri' nbij chewe como ja tok xinmajtaj ma wa'al xeya' nway in tok chakij nuchi' xeya' nuya'. Ja tok xinq'ueje' checojol xinec'ul pa tak ewochoch masqui ma ewotak ta nwach. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ja tok lawulo' chic ntziak chwij xeya' wxin chi ncoj in tok xinyawaji xinek'ijla'. Ja tok xinq'ueje' pa che' xinetz'ata'. Queri' ja nbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ja c'a utz netz'a̱t rmal ja Dios eje'e' tok nquic'axaj chi queri' nbix chique quewa' xtiquibij tre ri': —Kajaw ¿nak k'ij xatkatz'at atmajtajnak ma wa'al in kaya' away owi nak k'ij xatkatz'at atmajtajnak ma chakichi' in kaya' aya'? ");
INSERT INTO tzjNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","In ¿nak k'ij xatkatz'at ja ma kotak ta awach in xatkac'ul owi nak k'ij xatkatz'at ja lawulo' chic atziak chawij in kaya' awxin chi xacoj? ");
INSERT INTO tzjNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","In ¿nak k'ij xatkatz'at at yawa' owi atc'o pa che' in xatekak'ijla'? Queri' ja xtiquibij tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ja c'a Rey quewa' xtibij chic chique ri': —Ni katzij wi' ja xtinbij chewe ri', ja tok xe'eto' ja tak wach'alal, anin c'ari' ja xineto'. Queri' rbanic masqui xa más sencillo jun ti wach'alal ja xeto'. Queri' ja xtibij chic chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ja c'a rec'o pa rxcon quewa' xtibij chique ri': —Ixix ja xa itzel ixtz'aton rmal ja Dios quixel chinwach, camic nixbe chipan ja k'ak' ja mta q'uisic trij, jari' k'ak' xa rmal ja diablo tok chomin chi nta̱kel arja' chipan e rachbil ja ángel rxin. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Camic, quixel chinwach como ja tok xinmajtaj ma wa'al ma xeya' ta nway in tok chakij nuchi' ma xeya' ta nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ja tok xinq'ueje' checojol xa ma ewotak ta nwach in ma xinec'ul ta pa tak ewochoch. Ja tok lawulo' chic ntziak chwij ma xeya' ta wxin chi xincoj ta in tok xinyawaji in tok xinq'ueje' pa che' ma xinek'ijla' ta. Queri' ja nbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ja c'a reje'e' tok nquic'axaj chi queri' nbix chique quewa' xtiquibij tre ri': —Kajaw ¿nak k'ij xatkatz'at atmajtajnak ma wa'al owi rmal chakichi' owi atc'o chikacojol owi lawulo' chic atziak chawij owi at yawa' owi atc'o pa che' in ma xatkato' ta? Queri' ja xtiquibij tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ja c'a rarja' quewa' xtibij chic chique ri': —Ni katzij wi' ja xtinbij chewe ri', ja tok ma xe'eto' ta ja tak wach'alal, anin c'ari' ja ma xineto' ta. Queri' rbanic masqui xa más sencillo jun ti wach'alal ja ma xeto' ta. Queri' ja xtibij chic chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Eje'e' ri' nebe na chipan ja nimlaj rpokonal ja mta q'uisic trij pro ja utz netz'a̱t rmal ja Dios eje'e' nebe na chipan ja utzlaj c'aslemal ja mta q'uisic trij. Queri' xbij ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ja Jesús ja tok bitaj rmal nojel awa' jule' tzij ri' c'ac'ari' xbij chic chique ja rdiscípulo: ");
INSERT INTO tzjNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Ixix ewotak chi xa ca'i' k'ij chic nrajo' ja nc'u̱l wi' ja nmak'ij pascua in anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak ninjach na pa quek'a' ja netzelan wxin chi ninrip chwach cruz, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ja c'a jefe quixin sacerdote e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios e cachbil chakaja' ja principali' xin tinamit eje'e' xequimolo' qui' chwach ja nimlaj jay rxin ja Caifás ja lok'laj sacerdote. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Quemaj rcanoxic rij rwach nak nqueban tre ja Jesús chi nquechap pan ekal in nquicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pro quewa' quibij ri': —Ma chipan ta ja nmak'ij nkachap wi' matzij queyictaji ja winak rmal, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ja c'a Jesús arja' c'o chipan ja tinamit Betania pa rochoch jun achi rbina'an Simón ja rec'ol itzel tak ch'a'c trij nabey. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","C'oli ja Jesús pa mesa ja tok be jun ixok ruq'uin rc'amonel jule' ak'om ja qui' rxula' in congana nim rjil, rc'amonel chipan jun rc'olibal ja banon rbanic, alabastro ocnak. Ja c'a rixok tok xekaj ruq'uin ja Jesús xuya' ja rak'om pa rwi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pro ja c'a rdiscípulo eje'e' junwi' quetz'at ja xuban ja rixok: —¿Nak tre tok xa xtz'ila' ja rak'om le'? ");
INSERT INTO tzjNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ja ta ban tre c'ayix ta, congana ta q'uiy ja pwok xuya', ja c'a rjil ya' ta chique ja tak meba'i'. Queri' ja quibij. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ja c'a Jesús arja' bien rotak ja quimajon rbixic in quewa' xbij chique ri': —¿Nak tre tok nenak ja rixok? Jawa' xuban chwe ri' congana utz. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ja c'a tak meba'i' eje'e' nij ec'o wi' checojol ja wi c'ol egana neban utzil chique pro ja chwe anin maquinq'ueje' ewq'uin nojel tiempo, ninwasaxel na checojol. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Arja' tok xuya' ja rak'om chwij jari' xchomarsbej pon ja ncuerpo chi nmuki. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ni katzij wi' ja xtinbij chewe ri', jawa' utzlaj tzij ja nc'amonto ri', xa bar ta tri' xtekaj wi' rbixic nojel nat nakaj tre ja rwach'ulew tri' xtinatax wi' chakaja' ja rutzil ja xuban chwe jawa' rixok ri', jari' nnatbex rxin, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","C'ac'ari' c'o jun chique ja cablajuj discípulo ja bina'an tre Judas Iscariote, arja' be cuq'uin ja jefe quixin sacerdote. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ja c'a tok xekaj cuq'uin quewa' xbij chique ri': —¿Nak neya' chwe can njach pan ek'a' ja Jesús? ne' chique. Xa treinta rkan pwok plata ocnak ja quichomij ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ja c'a Judas ni jari' hora xumaj rcanoxic nak nuban tre ja Jesús chi nujach pa quek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ja tok xerila' ja nabey k'ij rxin ja nmak'ij ja tok ntiji ja caxlanway ja mta levadura ruq'uin, ja c'a Jesús xe'ekaji ja rdiscípulo ruq'uin in quewa' quibij tre ri': —Ja xtati' ja xin nmak'ij pascua tabij chake bar tri' xtikachomij wi', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","In bixel chique rmal ja Jesús: —Jix chipan ja tinamit Jerusalén. Tri' c'o wi' jun achi, nixbe ruq'uin in quewa' nebij tre ri': —Ja Maestro quewa' rbinto ri': —Xajalal maja'n terila' ja tiempo chi nincamsaxi. Ja wa'im ja xin nmak'ij pascua, pan awochoch nkaban wi' e wachbil ja ndiscípulo. Queri' ja rbinto chake, quixche' tre, xeche'xel rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ja c'a discípulo queri' queban ja cani' bixel chique rmal ja Jesús, xebe, xequichomij ja wa'im ja xin nmak'ij pascua. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ja c'a tok xoc ak'a' tz'abe' ja Jesús pa mesa e rachbil ja cablajuj discípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kas quimajon wa'im ja tok arja' xbij chique: —Ni katzij wi' ja xtinbij chewe ri', c'o jun chewe ja ninrujach na pa quek'a' ja netzelan wxin, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ja c'a reje'e', ja tok quic'axaj ja bix chique quemaj jun nimlaj bis: —¿La maxta anin Wajaw, la maxta anin? xeche'e chiquijujunal. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","In bix chique rmal ja Jesús: —Ja rachi ja wachbil tre wa'im in xa junan nokwa' ruq'uin pa plato, arja' c'ari' ja njacho wxin pa quek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak arja' ncamsax na cani' tz'ibtal can tre chipan ja rtzobal Dios pro congana lawulo' tre ja xtijacho rxin pa quek'a' ja necamsan rxin, makana' maquita Alc'walaxel ja xoc alaxic cuq'uin ja winak. Ja xtijacho rxin más ta utz ja maquita xalax chwach'ulew. Queri' bix chique rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ja c'a Judas arja' xbij tre: —Maestro ¿la maxta anin? ne' tre. —Atat nac'a, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ja c'a tok quimajon wa'im ja Jesús xuc'am ja caxlanway, xmaltioxij tre ja Dios, xuwech' in xujach chique ja rdiscípulo in quewa' xbij chique ri': —Jawa' wari' ncuerpo, tec'ama' in tetija', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","In xuc'am chic jun vaso vino, xmaltioxij tre ja Dios in xujach chique chakaja' in quewa' xbij chic chique ri': —Tetija' ewanojelal ");
INSERT INTO tzjNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","como jawa' wari' jawa' nquiq'uel ocnak rseguro ja c'ac'a chominem ja rchomin ja Dios. Ja nquiq'uel e q'uiy ja winak nti̱x na pa quicuenta utzc'a chi ncuytaji ja quil quemac. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Anin nbij chewe camic chi jawa' riya'l uva ri' ni matintij chi wi' wawe', c'a tokori' xtintij chic ja tok xterila' ja k'ij chi nkatij chic ewq'uin chipan ja gobierno rxin ja nata' Dios xarwari' c'ac'a chic nojelal tri', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","C'o c'a jun himno rxin ja nmak'ij pascua quibixaj. Ja c'a tok tzuri ja himno cumal xe'elel, xebe chipan ja lugar rbina'an Rjayu'al Olivo. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ja c'a Jesús arja' xbij chique: —Rmal ja xtiban chwe chipan awa' jun tucwak'abil ri' ixix nineya' can, nixanmaji pro ewanojelal. Queri' nbij chewe como tz'ibtal can chipan ja rtzobal Dios quewari': —Anin xtincamsaj ja yuk'ul quixin ja tak carnelo, ja c'a tak rcarnelo ja rerbanon cuenta, eje'e' nechictaji. Queri' ja tz'ibtal can. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pro ja tok xtic'astaj nwach ninnabeyaj chewach, ninbe chipan ja departamento Galilea, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ja c'a Pedro arja' xbij tre: —Masqui canojel xcatqueya' can pro ja c'a chwe anin mta moda xcatnuya' can ta, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","In bix tre rmal ja Jesús: —Ni katzij wi' ja xtinbij chawe ri', ja chipan awa' jun tucwak'abil ri' maja'n tok'i ja ac' ja tok oxmul xtabij chwe chi: —Anin ma wotak ta rwach ja Jesús, natche' na chwe, ne'xi ja Pedro. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Masqui ok ca'i' awq'uin xkocamsaxi pro ni ma xcatnuya' can ta wi', ne'e ja Pedro tre. In canojel ja discípulo queri' quibij tre chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","C'ac'ari' ja Jesús xerachbilajel ja rdiscípulo, xebe chipan jun lugar rbina'an Getsemaní. Ja c'a tok xe'ekaji quewa' xbij chique ri': —Quixtz'abe' can wawe' ri', ja c'a ranin nenbana' paki na oración quelale', ne' can chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pro xeruc'amel ja Pedro e rachbil ja re ca'i' rc'ajol Zebedeo. C'ac'ari' xumaj jun nimlaj bis in xumaj ti'onem ja ranma. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","In xbij chique: —Camic, congana nbisoni ja wanma, ja nna' anin camíc rc'amonto chwe. Ixix quixq'ueje' can wawe', quixc'asc'ot wq'uin, ne' can chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","C'ac'ari' junwi' xyonaj pon wi' ri' ruyon, xuque'e in xumaj rbanic oración: —Nata', anin nwajo' nabij ta chwe chi maquita nink'ax chipan awa' rpokonal ja penak chinwach ri' xarwari' ni ta c'a xquink'ax wi' chipan ja wi queri' nawajo' chwe chi nban, ne' tre ja Tatixel. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ja c'a tok tzuri ja roración rmal be cuq'uin ja discípulo. Ja tok xe'erwila' ekajnak chi waram. Xbij tre ja Pedro: —¿La matecoch' ek xquixc'asc'ot ta jun hora wq'uin? ");
INSERT INTO tzjNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Quixc'asc'oti in tebana' orar utzc'a ja Satanás tok xquixrtakchi'ij maquita xquixruch'ec. Ja rewanma jari' ni katzij wi' chi c'o rgana nc'asc'oti pro como xa ix winak ja recuerpo npokonaj nuban queri', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","C'ac'ari' meloj chic jutij chi rbanic ja roración: —Nata', ja wi ni mta wi' moda ja maquita xquink'ax chipan ja rpokonal ri' xtibantaj ta c'a ja ravoluntad, ne' chic tre ja Tatixel. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Meloj chic jutij cuq'uin in tok xe'erwila' chic ewarnak chic chakaja'. Queri' quibanon como congana jun nimlaj waram chique, ma xquecoch' ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","In meloj chic jutij chakaja' chi rbanic ja roración in queri' xbij chic ja cani' rbin nabey chipan ja roración. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","C'ac'ari' melojpi chic jutij cuq'uin ja discípulo in quewa' xbij chique ri': —Camic quixwar c'a, quixxula'n c'a. Bien tec'waxaj chi xurwila' ja hora, ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, camic nja̱ch pa quek'a' ja raj'il ajmaqui' chi nquicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jo', quixyictaji, que'ekac'ulu'. Tetz'ata' mpe' le', xa nakajinto ja njacho wxin pa quek'a', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kas c'a rmajon na tzij ja Jesús cuq'uin ja rdiscípulo ja tok peti ja Judas. Jari' Judas arja' jun chique ja cablajuj apóstol. Arja' e q'uiy ja winak erachbilanto in c'oli banbal ch'a'oj quic'amonto cani' tre espada in che', etakonto cumal ja jefe quixin sacerdote in cumal ja principali' xin tinamit chi nurquichapa' ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ja c'a Judas ja njacho rxin ja Jesús arja' c'oli xchomij cuq'uin ja winak nak xtuban tre ja Jesús chi jari' njachbej rxin pa quek'a': —Ja tok xtetz'at ja rachi ja xtintz'ubaj ruchi' chewach ja c'ariri', techapa'. Queri' rbanic ja xchomij cuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Be c'a alnak ja Judas ruq'uin ja Jesús, ja c'a tok xekaj chwach xuban saludar: —Xoc ak'a' Maestro, ne' tre, in xtz'ubaj ruchi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ja c'a Jesús xbij tre: —Amigo ¿nak narbana' wawe? ne' tre. C'ac'ari' ja winak xebe trij ja Jesús, quechap in quecoj preso. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","C'o c'a jun chique ja rachbil ja Jesús chaka jalal tok xlasaj ja respada in c'o jun moso rxin ja lok'laj sacerdote xusoc tre, xkupijel jun rxquin. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ja c'a Jesús arja' xbij tre: —Tac'olo' ja respada pa rc'olibal como xa nak ta ncojowi ja respada, espada ncamsbex arja' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿La ma awotak ta c'a chi anin ja wixta c'o ngana nc'utuj nto'ic tre ja nata' Dios arja' chanim nerutakto jule' ángel chi nto'ic? Pro congana e q'uiy nerutakto, e cani' cablajuj ejército soldado ja nerutakto. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pro ja wixta maquita nink'ax chipan ja rinc'o wi' camic ri' matibantaj c'a cumplir ari' ja tz'ibtal can chipan ja rtzobal Dios chi c'o rjawaxic chi nink'ax chipan, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ja c'a ri' hora ja Jesús arja' xbij chique ja winak: —¿La in alak'om la'an chewi' tok ec'amonto espada ec'amonto che' chwij chi nchapic? Pro xinq'ueje' wa'an chipan ja nimlaj templo xin Dios in k'ij k'ij xentijoj ja winak chipan pro ma xinechap ta wa'an tri'. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pro nojel awa' wari' ma chaka ta nbantaji, rumac chi nbantaj cumplir ja tz'ibtal can chwe ojer cumal ja rojer tak profeta xin Dios, ne' chique. C'ac'ari' ja rdiscípulo queya' can, xe'anmajel. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ja c'a winak ja xechapo rxin ja Jesús eje'e' quec'amel chwach ja Caifás ja lok'laj sacerdote. Tri' quimolon wi' qui' ja maestro ja netijon quixin ja winak tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés e cachbil ja principali' xin tinamit. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ja c'a Pedro arja' rtrarben ja Jesús pro c'a c'a nat nutzu' pon chic wi'. Arja' xekaji ja bar c'o wi' ja nimlaj jay rxin ja lok'laj sacerdote, xococ chwa jay in tz'abe' cuq'uin ja pulisiya', nrajo' nutz'at nak ja xtibantaji. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ja c'a jefe quixin sacerdote e cachbil ja principali' xin tinamit in e cachbil chakaja' ja jule' chic ja rec'o chipan ja k'etbaltzij quixin ja raj Israel eje'e' quemaj quicanoxic jule' winak chi nqueya' testigo'il trij ja Jesús pro xa tz'akbal tak tzij ja xtiquibij tre. Queri' nqueban utzc'a chi nkaji camíc trij. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pro ni majun nak ta quichapbej ta rxin ja Jesús, ni mta wi' masqui e q'uiy ja testigo ja xa e tz'akol tak tzij. Ja tok q'uiswani ec'o ca'i' ja testigo e tz'akol tak tzij ");
INSERT INTO tzjNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","quewa' quibij ri': —Jala' rachi le' rbin chi ncowini nuyoj ja nimlaj templo xin Dios pro xa oxi' k'ij nrajo' chi nuyic chi wi' jutij, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ja c'a lok'laj sacerdote arja' pe'i in xbij tre ja Jesús: —¿La matac'ulba' c'a ja bix chawe le'? Camic, tabij c'a chwe nak rbanic ja testigo'il ja ya' chawij cumal ja rachi'i' le', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pro ja Jesús ni matic'ulba' wi' ja nbix tre. In bix chic tre rmal ja lok'laj sacerdote: —Chwach ja c'aslic Dios tabij chake ¿la atat ja rat Cristo ja rat Ralc'wal Dios? ne'x rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ja c'a Jesús arja' xbij tre: —Queri' nac'a ja cani' nabij le'. In bien tec'waxaj ja xtinbij chewe ri', camic nemajel rtz'atic ja xtuban ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, arja' pa riquik'a' ja Dios ntz'abe' wi' ja bar c'o wi' ja nimlaj poder rxin in netz'at chakaja' ja tok xtipi chic jutij c'amonto rmal jule' sutz' xin chicaj, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ja c'a lok'laj sacerdote c'o jun tziak rcojon xurak como xa itzel xc'axaj ja bix tre rmal ja Jesús in xbij chique ja quimolon qui' ruq'uin: —Jala' xbij le' xa ofensa rc'amonto tre ja Dios, taka'an njunsaj ri' ruq'uin. Camic, mchita ne'oc wi' más ja testigo como bien xec'waxaj ja xbij le', ja Dios janila nuban ofender ri' rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Camic ¿nak nebij ixix tre? ne' chique. —Mta, ni yatal wi' trij chi ncamsaxi, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","C'ac'ari' quichubaj rpalaj, quesoc in ec'oli chique queya' k'a' chi rpalaj, ");
INSERT INTO tzjNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","quewa' quibij tre ri': —Cristo, tabij c'a chake camic ¿nak yowi k'a' chi apalaj? Queri' ja quibij tre pro xa nquiyok'bej rxin. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ja c'a Pedro arja' tz'ubul chwa jay, c'o c'a jun aj'ic' xekaj ruq'uin in quewa' xbij tre ri': —Atat jun chakaja' xawachbilaj ja Jesús ja raj Galilea, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pro ja Pedro arja' ma xuya' ta trij ja bix tre, quewa' xbij chique ri' pro ni chiquewach canojelal: —Anin ni ma wotak ta ja nabij le', ne' tre ja rixok. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Yictaji, be ja bar c'o wi' puerta pro c'o chic jun ja raj'ic' tz'ato rxin in xbij chique ja rec'o tri': —Jawa' jun achi ri' arja' rachbilaj ja Jesús ja raj Nazaret, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pro ja Pedro arja' ma xuya' chi ta trij ja bix tre: —Chwach Dios nbij chi anin ma wotak ta rwach ja Jesús ja nabij le', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","C'a co'l ari' ja tok ec'o jule' winak ja rec'o tri' xe'ekaj ruq'uin in quibij tre: —Bien k'alaj chi atat at cachbil ja raj Galilea ja xerachbilaj ja Jesús como ja nattzijoni jari' natc'utuwi, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","—Chwach Dios nbij chewe chi anin ma wotak ta rwach ja Jesús in xta itzel xquinrutz'at ja Dios ja wi ma katzij ta ja nbij, ne'e ja Pedro chique. In chaka maril bitaj rmal ja tzij ri' xok'i ja ac'. ");
INSERT INTO tzjNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","C'ac'ari' xurkaj tre ja Pedro ja bin tre rmal ja Jesús, quewa' bin tre ri': —Ja tok maja'n tok'i ja ac', oxmul xtabij na chwe chi: —Anin ma wotak ta rwach ja Jesús, natche' na chwe. Queri' ja bin tre. C'ac'ari' xelto, congana jun nimlaj bis ok'ej nuban. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ja c'a tok sakari canojel ja jefe quixin sacerdote e cachbil ja principali' xin tinamit eje'e' quemaj rch'obic nak nqueban tre ja Jesús chi nquicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Quebaq'uel, xebe, xequijacha' pa ruk'a' ja Poncio Pilato ja gobernador. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ja c'a Judas ja jacho rxin ja Jesús pa quek'a' ja xetzelan rxin arja' tok xutz'at chi ncamsaxi ja Jesús congana xumaj ti'onem ja ranma. Be, xermeloj ja treinta rkan pwok ja plata ocnak, xermeloj pa quek'a' ja jefe quixin sacerdote in pa quek'a' ja principali' xin tinamit. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ja c'a tok xekaj cuq'uin quewa' xbij chique ri': —Camic, xinban jun il mac, xinjach pa camíc jun achi pro mta ril, ne' chique. —Jala' nabij le', ajoj ni majun nak ta nkabij tre, kas atat wala' nak ja xtaban ruq'uin, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","C'ac'ari' ja Judas xch'akij can ja pwok chipan ja templo, xelel in be, xerjitz'aj ri' ruyon. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ja c'a jefe quixin sacerdote eje'e' quemol ja pwok in quewa' quibij ri': —Jawa' pwok ri' rjil quic' chewi' xajan ja xtibe ta pa caja xin templo, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","In quemaj rch'obic nak nqueban tre ja pwok. Ja c'a tok ch'obtaj cumal quelok' jun ulew tre ja rachi ja banol bojo'y. Ja c'a xoc wi' ja rulew, chipan nemu̱k wi' ja winak ja necami ja repenak chipan jule' chic tinamit. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Xc'a rmalari' bina'ax tre ja rulew rjil quic' ne'xi, in niquirwari' nbix tre camic chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tri' bantaj wi' cumplir ja tzij ja bitajnak can rmal ja rojer profeta Jeremías quewari': —Ja winak ja raj Israel ec'oli chique xa treinta rkan pwok ja plata ocnak xa jari' rjil quibij. Ja c'ari' pwok quec'am ");
INSERT INTO tzjNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","quilok'bej jun ulew tre ja banol bojo'y cani' bin anin chwe rmal ja kajaw Dios. Queri' ja bitajnak can ojer. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ja c'a Jesús arja' pa'l chwach ja Pilato ja gobernador in quewa' bix tre rmal ri': —¿La atat ja rat rey quixin ja tinamit Israel? ne'xi ja Jesús. —Queri' nac'a ja cani' nabij le', ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pro ja jefe quixin sacerdote e cachbil ja principali' xin tinamit eje'e' tok quemaj rbixic ja ril ja Jesús arja' ni majun nak ta xbij. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","C'ac'ari' ja Pilato xbij chic tre: —¿La matac'waxaj c'a ja nquibij chawe le', congana taka'an jule' awil nquibij chawe? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pro ja Jesús nixtac'a c'o ta jun tzij xbij, ni ma xc'ulba' ta wi'. Ja c'a Pilato congana junwi' xutz'at ja queri' xuban. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ja c'a gobernador ni c'amonnak wi' tre chi ni c'o wi' jun preso nsokpij pa tak nmak'ij pascua pro nuya' lugar tre ja tinamit chi eje'e' nec'utuni nak chi preso'il ja nsokpixel. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ja c'ari' tiempo c'o jun preso rbina'an Barrabás, nojel ja rbanon benak rbixic nat nakaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ja c'a Pilato tok quimolon chic qui' ja winak arja' xbij chique: —¿Nak newajo' ixix, la Barrabás ja nsokpijel owi Jesús ja Cristo ne'xi? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Queri' xbij chique como arja' bien rotak chi congana quiakirnak canma trij ja Jesús in xa rmal ja raquiakarem tok quijachon pa ruk'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ja Pilato arja' tz'ubul chipan ja lugar ja bar nuban wi' ja k'etoj tzij ja tok chaka c'a jalal tak rbixic jule' tzij tre rmal ja rxjayil quewari': —Ma tacoj ta awi' atat chi rcamsaxic ja rachi, arja' utzlaj achi. Ma tacoj ta awi' como ni ja' rachi xinwachc'aj camic in ja rachic' congana lawulo' xuban chwe. Queri' ja takonel rbixic tre rmal ja rxjayil. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pro ja jefe quixin sacerdote e cachbil ja principali' xin tinamit eje'e' quibij chique ja winak chi nquic'utuj ja Barrabás chi nsokpixel in ja c'a Jesús ncamsaxi. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ja c'a gobernador arja' xbij chic jutij chique: —¿Nak newajo' ixix, nak chique ja ca'i' achi'i' nsokpijel? ne' chique. —Barrabás ja tasokpijel, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—Ja wi queri' newajo' ¿nak c'a nban tre nech'ob ixix ja Jesús ja Cristo ne'xi? ne'e ja Pilato chique. —Ticamsax chwach cruz, xeche'e canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Nak c'a tre, nak c'a ritzelal rbanon? ne' chic ja Pilato chique. Pro ja reje'e' más chi na quemaj rakic quechi': —Ticamsax chwach cruz, xeche' chic jutij tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ja c'a Pilato arja' xutz'at chi ja winak ni ma e conforme ta wi' ruq'uin ja nbij arja' chique chi nsokpixel ja Jesús in xerutz'at chi xa jani' neyictaj más. C'ac'ari' xuc'am jule' ya', xuch'aj ruk'a' chiquewach in quewa' xbij chique ri': —Anin ma wil ta ja ncamsaxi ja utzlaj achi ri', kas ixix wala' nak ja xteban tre, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","—Ajoj c'a nokijkalen ari' ja ncamsaxi in tak kalc'wal chakaja', xeche'e canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ja c'a Pilato arja' xuya' quigana, xsokpijel ja Barrabás in xuya' orden chi nrapaxi ja Jesús. Ja c'a tok raptaji xujach pa quek'a' ja nec'amo'el rxin chi ncamsax chwach cruz. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","C'ac'ari' ja soldado rxin ja gobernador eje'e' quec'amel ja Jesús chipan ja jay ja bar nq'ueje' wi' ja gobernador in xequemol canojel ja jule' chic cach tak soldado. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Quejal ja rtziak ja Jesús in c'o chic jun tziak quiak quecoj tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Quichomij jun corona, q'uix quecoj in quecoj pa rwi' in queya' jun aj pa ruk'a' riquik'a'. Xexuque' chwach in queban saludar ja cani' nba̱n saludar jun rey pro xa nquiyok'bej rxin: —Atat at rey quixin ja tinamit Israel, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Quichubaj, quemaj ja aj tre in quesoc rij tak rwi' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ja tok tzuri yok'onem cumal c'ac'ari' quejal ja tziak quiak tre in quecoj chic tre ja ni rtziak wi' arja'. C'ac'ari' quec'amel chi nequiripa' chwach cruz. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ja tok xebe c'o jun achi quewil aj Cirene, Simón rubi', puersa queban tre chi nrijkajel ja cruz rxin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Xebe pa jun lugar rbina'an Gólgota. Gólgota tibij tzij lugar xin rwi' camnak. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ja c'a tok xe'ekaj chipan ja lugar Gólgota quitzujuj vino tre chi nutij. Ja vino c'oli ja yujun ruq'uin congana c'ay. Ja c'a Jesús tok xuna' chi c'ay ma xutij ta. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ja c'a tok riptaj cumal chwach cruz quemaj rbanic suerte trij ja rtziak nak xtich'eco chique in quejach chiquewach. Queri' bantaji utzc'a chi tri' bantaj wi' cumplir ja bitajnak can rmal ja profeta quewari': —Queban suerte trij ja ntziak in quejach chiquewach, queri' ja bitajnak can ojer. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","C'ac'ari' xetz'abe'e in quemaj rchajixic ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tz'ibaxi ja ril ja nbix tre in parwi' queya' wi' chwach ja cruz, quewa' rbanic ja ril nbixi ri': —Jawa' Jesús, arja' rey quixin ja tinamit Israel, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","In ec'o c'a ca'i' alak'oma' xeri̱p chwach cruz chakaja', jun pa riquik'a' ja Jesús in jun pa rxcon. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ja c'a winak ja nek'axi ja tok nquetz'at ja Jesús xa nquitzebej xa nqueyok' in quewa' nquibij tre ri': ");
INSERT INTO tzjNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Atat xatbini chi nayoj ja templo in xa oxi' k'ij nrajo' chi nayic chi wi' jutij, camic tato'o' c'a awi' ayon. Ja c'a wi katzij chi atat ja rat Ralc'wal Dios catkajpi c'a chwach ja cruz, neche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","In ja jefe quixin sacerdote eje'e' xa nqueyok' chakaja' e cachbil ja maestro ja netijon quixin ja winak tre la ley xin Dios e cachbil chakaja' ja principali' xin tinamit: ");
INSERT INTO tzjNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Arja' To'onel quixin winak ne'xi, pro ja camic xna' maticowini nuto' ri' arja'. Ja wi katzij chi arja' Rey kaxin ja rok aj Israel tikajto c'a camic chwach ja cruz in wi nkajto nyuke' c'a kac'u'x ari' ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Arja' yukul ruc'u'x ruq'uin ja Dios ne'xi, pro wi c'o rgana ja Dios ruq'uin tito'o' c'a camic como arja' xucoj ri' chi Ralc'wal Dios. Queri' ja nquiyok'bej rxin. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","In queri' queban ja re ca'i' alak'oma' ja xeri̱p chwach cruz pa rxquin ja Jesús, eje'e' queyok' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ja pa nc'ajk'ij c'o jun nimlaj k'eku'm xoqui nojel chwach'ulew, c'a a las tres xin takak'ij sakar chic jutij. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ja c'a Jesús a las tres chi la xin takak'ij arja' congana xurak ruchi', quewa' xbij ri': —Elí, Elí ¿lama sabactani? ne'e. Jari' tzij xbij quewa' nbij ri': —Nata' Dios, nata' Dios ¿nak tre tok inaya'on can? ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ec'o c'a jule' chique ja winak ja rec'o tri', eje'e' tok quic'axaj ja xbij quewa' quibij ri': —Jala' rachi le' camnak profeta Elías ja nsiq'uij, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","C'o c'a jun chique xerc'amla'to jun esponja, xch'akba' tre jule' ch'amlaj vino, xuxim chutza'm jun aj in xuya' nojoj tre ja Jesús chi nutij. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pro ja c'a jule' chic eje'e' quibij: —Ch'enchila', katz'ata' na c'a ja wi xtipeti ja rElías chi nurto'o', xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ja c'a Jesús arja' xurak chic jutij ruchi', xujach ranma tre ja Dios in cam kaj. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","In chaka jalal tok raktaji ja manta ja tasben rpan ja nimlaj templo xin Dios ja bar c'o wi' ja santilaj lugar, chaka ca'i' xuban. Raktaji, xelto chicaj, kajto c'a pa tok'ulew. Ja c'a rwach'ulew congana xusil ri' in c'oli nimak tak abaj xepak'taj rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","C'o je'e jul jaktaji quixin camnaki' in ja camnaki' ja re xin Dios e q'uiy chique xec'astaji. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ja c'a reje'e' tok c'astajnak chic ja Jesús xe'elto chipan ja jul ja bar ec'o wi' in xebe chipan ja tinamit Jerusalén ja tinamit xin Dios in e q'uiy ja xetz'ato quixin. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ja capitán e rachbil ja rec'o ruq'uin chi rchajixic ja Jesús eje'e' quetz'at ja cubarkan xuban, quetz'at nojel ja bantaji in congana quixbej qui' rmal: —Jala' rachi le' ni katzij wi' chi Ralc'wal Dios, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","In e q'uiy ja rixoki' ja rec'o tri' chakaja' nquetzu' pon ja nbantaji. Eje'e' etranel trij ja Jesús ja tok xelel pa Galilea in queto' chipan nak ja c'o rjawaxic tre. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jun chique ja rixoki' María Magdalena, in jun chic, María ja quete' Jacobo in José, in jun chic, ja quete' ja rc'ajol Zebedeo. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ja c'a tok xoc ak'a' c'o jun achi peti, arja' biyom, aj Arimatea, José rubi'. Arja' rdiscípulo ja Jesús chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Be ruq'uin ja Pilato chi rc'utuxic ja cuerpo rxin ja Jesús. Ja c'a tok xekaji, ja Pilato xuya' orden chi nja̱ch tre ja cuerpo. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Be ja José, xerc'ama' ja cuerpo in xubar pa jun tziak ch'ajch'oj. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ja c'a tok bartaj rmal xerya'a' chipan jun panteón c'ac'a rxin arja' ja rc'oton chwach jun portales in xtz'apij ruchi' tre jun nimlaj abaj. C'ac'ari' be. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ja c'a María Magdalena rachbil ja jun chic María eje'e' ec'o tri', etz'ubuloc chwach ja panteón. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ja tok xoc'owi ja k'ij ja nchomarsbex wi' nakun je'e rxin ja nmak'ij, ja c'a chi rcab k'ij chic xebe ja jefe quixin sacerdote e cachbil ja fariseo, xequimolo' qui' chwach ja Pilato ");
INSERT INTO tzjNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","in quewa' quibij tre ri': —Señor gobernador, ajoj bien nurkaj chake, ja rachi Jesús ja banol engaño, ja tok c'a c'as na c'o jun tzij xbij can quewari': —Pro ja chi rox k'ij nc'astaj nwach. Queri' ja xbij can. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Rmalc'ari' nkabij chawe, taya'a' jun orden chi nchajix oxi' k'ij ja panteón, matzij xquebe ja rdiscípulo chak'a', xtiquilak'ajel ja rcuerpo chipan ja panteón in tok xtic'amtajel cumal xtiquibij chique ja winak chi c'astaj rwach ja rachi chiquicojol camnaki'. Ja wi queri' xtiqueban jari' más chi na jun nimlaj engaño chwach ja cani' xuban ja Jesús nabey, xeche' tre ja Pilato. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","In bix chique: —Ec'oli ja guardia le', ixix c'ol ek'a' chique, que'ec'ama'el, seguro tebana' tre ja panteón como ixix ewotak nak xteban tre, xeche'x rmal ja Pilato. ");
INSERT INTO tzjNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","C'ac'ari' xebe, quichomij ja rabaj ja tz'apben ruchi' ja panteón, bien seguro queban tre in xequeya' can ja guardia chi rchajixic. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Xoc'owi ja xula'nbal k'ij, ja c'a pa rsakaric xin domingo be ja María Magdalena rachbil ja jun chic María, xequitz'ata' ja panteón. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Chaka c'a jalal c'o jun nimlaj cubarkan xuban rumac jun ángel rxin ja kajaw Dios kajto chila' chicaj, xlasaj ja rabaj ja tz'apben ruchi' ja panteón in tz'abe' parwi'. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ja nca'yi ja ángel cani' nca'y k'ak' xin jab tok nuq'uiak ri' in ja rtziak rcojon congana sak. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ja c'a guardia eje'e' congana quixbej qui' rmal, congana nebirbot rmal ja xbeben ri'il, xekaj chi tok'ulew in matiquena' chic. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pro ja c'a ángel xbij chique ja rixoki': —Ma texbej ta ewi' como anin wotak chi Jesús ja nixtajini necanoj, ja camsax chwach cruz. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Camic, ma wawe' chi ta c'o wi', c'astaj wa'an rwach ari', bantaj cumplir ja cani' rbin can. Quixajo', tetz'ata' mpe' ja lugar ja bar q'ueje' wi' ja cuerpo rxin ja Kajaw. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ja c'a tok xtitz'attaj can emwal nixbe alnak, nebij chique ja rdiscípulo chi c'astajnak chic rwach chiquicojol camnaki'. In quewa' nebij chique ri': —Tec'waxaj mpe', ja Jesús arja' nnabeyaj chewach, nbe pa Galilea in tri' netz'ata' wi', xquixche' chique. Xtetz'ata' mpe' como xinbij chewe, ne'e ja ángel chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ja c'a rixoki' eje'e' xe'elel alnak ruq'uin ja panteón, xebe, xequibij chique ja discípulo, congana quixben qui' in congana nequicoti chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kas ebenak chi rbixic chique ja discípulo ja bixel chique tok chaka jalal quec'ul qui' ruq'uin ja Jesús. Ja c'a Jesús xuya' pon jun saludo chique. Ja c'a reje'e' tok xe'ekaj ruq'uin quechap ja rkan in quemaj rya'ic ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ja c'a Jesús arja' xbij chique: —Ma texbej ta ewi', jix cuq'uin ja wach'alal, jebij chique chi nebe pa Galilea, tri' ninequitz'ata' wi', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ja rixoki' kas ebenak chi rbixic ja bixel chique ja tok ec'o jule' chique ja guardia xebe chipan ja tinamit, xebe cuq'uin ja jefe quixin sacerdote. Ja c'a tok xe'ekaj cuq'uin quibij chique nojel ja bantaji. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ja c'a jefe quixin sacerdote eje'e' quemol qui' cuq'uin ja principali' xin tinamit in quemaj rch'obic nak nqueban. Ja c'a tok ch'obtaj cumal, eje'e' q'uiy pwok queya' chique ja soldado ");
INSERT INTO tzjNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","in quewa' quibij chique ri': —Quewa' tebij chique ja winak ri': —Ja rdiscípulo ja Jesús xepeti chak'a', xurquilak'ajel ja rcuerpo, ja c'a rajoj okwarnak, xquixche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ja c'a wi xtekaj rbixic ruq'uin ja gobernador chi queri' xeban, ajoj nkachomij ruq'uin, ni majun nak ta xtuban ta chewe, xeche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ja c'a soldado eje'e' quec'am ja pwok in queri' queban ja cani' bix chique. In jari' tz'akoj tzij c'a majtajnak na rbixic chique ja kach tak aj Israel camic. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ja c'a julajuj discípulo eje'e' xebe ja pa Galilea, xebe parwi' ja jayu' ja bar bin wi' chique rmal ja Jesús chi nebe. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ja c'a tok quetz'at ja Jesús quemaj rya'ic ruk'ij pro ec'oli ja ma kas ta nquinimaj chi Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Peti ja Jesús in quewa' xbij chique ri': —Nojel ja poder xin chila' chicaj jachon pa nuk'a' rachbil nojel ja poder xin rwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Rmalc'ari' nbij chewe, jix cuq'uin ja winak ja rec'o nojel tak nación, que'etijoj utzc'a chi ne'oc ndiscípulo, que'ebana' bautizar pa rubi' ja Tatixel, ja Ralc'walaxel in ja rEspíritu Santo. ");
INSERT INTO tzjNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tech'obo' chiquewach nak nqueban chi rnimaxic nojel ja mandamiento ja nya'on chewe. In bien turkaj chewe chi anin ni mta wi' jun k'ij ja maquita inc'ol ewq'uin in nij inc'o wi' ewq'uin ja tok xterila' ja q'uisbal k'ij rxin ja rwach'ulew. Amén.");
INSERT INTO tzjNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Quewa' rbanic ja tok majtaj rk'alasaxic ja utzlaj tzij ja nuc'ut chikawach nak rbanic ja Jesucristo ja Ralc'wal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Cani' tz c'o jun ntajko'm ntakel, arja' nnabeyaj chawach chi rchomarsaxic ja rabey. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ja tajko'm arja' nc'axaxi ja rukul chipan ja lugar ja kas talani, quewa' nbij ri': —Techomarsaj chi utz ja rubey ja kajaw Dios, jic teya'a'. Queri' ja tz'ibtal can. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","In queri' bantaji, peti ja tajko'm, Juan rubi', arja' neruban bautizar ja winak. Arja' chipan ja lugar ja kas talan wi' tri' nq'ueje' wi' in quewa' nbij chique ja winak ri': —Teq'uexa' ja rena'oj, teya'a' can ja ritzelal in quixban bautizar, quirtari' neban utzc'a chi ncuytaji ja rewil emac, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Canojel ja winak ja rec'o pa Jerusalén e cachbil canojel ja rec'o chipan ja jule' chic lugar ja c'o pa rcuenta Judea eje'e' xebe ruq'uin ja Juan, xeba̱n bautizar rmal chipan ja binelya' Jordán in tri' quechol wi' ja quil quemac. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ja c'a Juan ja rtziak rcojon puro rsamal camello ocnak in rximon rupan chi jun tz'um. Ja rocnak rq'uexwach rway, sac' nerutij in raxcab chakaja' ncanoj pa tak k'ayis. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Quewa' nbij chique ja winak ri': —C'o chi na jun penak ja xajalal maja'n tumaj ja rsamaj, arja' más chi na nim ja poder c'o pa ruk'a' chinwach anin. Anin ma yatal ta chwij xquintiloc ta ruq'uin nixtac'a chi rquiric rc'amal rxajab. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Anin ya' xincoj tok xixnuban bautizar pro arja' Espíritu Santo nixrbanbej bautizar, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jari' tiempo xelto ja Jesús chipan ja tinamit Nazaret ja c'o pa rcuenta Galilea, be ruq'uin ja Juan in ban bautizar rmal chipan ja binelya' Jordán. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Chaka maril xelto ja Jesús pa ya' xutz'at ja caj jaktaji in xutz'at ja rEspíritu Santo cani' jun ajsakaxic' ja tok kajto ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","In c'o jun kulaj penak chila' chicaj c'axaxi, quewa' xbij ri': —Atat ja rat chak'laj Walc'wal, congana ninquicot chawij, ne'e ja Dios tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ja c'a rEspíritu Santo arja' xutakel ja Jesús chipan ja lugar ja kas talani. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ca'winak k'ij q'ueje' chipan ja lugar in xekaji ja Satanás ruq'uin, xumaj rtakchi'ixic. Ja lugar c'o wi' tri' ec'o wi' jule' itzel tak chicop in xepeti ja ángel xin Dios, xurquito'o'. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ja tok coji ja Juan Bautista pa che' ja c'a Jesús arja' be chipan ja departamento Galilea. Ja c'a tok xekaji xumaj rbixic ja utzlaj tzij tre ja gobierno xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Quewa' nbij ri': —Camic xurtz'akati ja tiempo, ja gobierno xin Dios xa nnakajinto rmalc'ari' tok nbij chewe, teq'uexa' ja rena'oj in teya'a' can ja ritzelal, tenimaj ja utzlaj tzij ja rc'amonto ja totajem xin Dios, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ja Jesús arja' kas rmajon binem chuchi' ja ya' rbina'an Galilea ja tok ec'o ca'i' achi'i' xeruwil e alaxic, jun rbina'an Simón in jun chic Andrés rubi'. Eje'e' como e chapol ch'u' kas quimajon rq'uiakic ja c'am pa ya' ja tok xe'iltaji rmal ja Jesús ");
INSERT INTO tzjNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","in quewa' bix chique rmal ri': —Jo' quixtre' chwij, anin nya' na jun samaj chewe pro ma chapoj ch'u' chi ta ja neban, winak chic ja ne'ecanoj, xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ja c'a reje'e' quich'akila' can ja quec'am in xetre'el trij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ja c'a Jesús c'a ma nim ta rbinben ja tok ec'o chic ca'i' achi'i' xeruwil, chakaja' e alaxic, jun rbina'an Jacobo in jun chic Juan rubi', e rc'ajol Zebedeo, eje'e' chakaja' ec'o pa jun lancha quimajon rc'ojoxic ja quec'am. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","In chanim xesiq'uix pon rmal ja Jesús. Queya' can pa lancha ja Zebedeo ja quitata' e rachbil ja moso in xetre'el trij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","In xebe, xe'ekaj chipan ja tinamit Capernaum. Ja c'a Jesús arja' xoc chipan ja jay xin molbal ri'il ja bar nquemol wi' qui' ja winak chi rc'axaxic ja rtzobal Dios in xumaj quitijoxic pa jun xula'nbal k'ij. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ja c'a winak kas c'asc'o'i nquic'axaj ja tijonem nuya' como ja tijonem nuya' chique congana nerusil, bien k'alaj chi ruq'uin Dios penak wi' ja nbij, ma junan ta ruq'uin ja tijonem ja nqueya' ja maestro ja netijon quixin ja winak tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ja c'a chipan ja jay ja xin molbal ri'il tri' c'o wi' jun achi ocnak jun itzel espíritu tre, arja' xumaj rakic ruchi': ");
INSERT INTO tzjNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús ja rat aj Nazaret ¿nak narbana' wawe' kuq'uin, la maxta atpenak chi nokaryojo'? Anin bien wotak nak atocnak wi', atat ja rat Santilaj Ralc'wal Dios, ne' tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ja c'a Jesús arja' xch'olij ja ritzel espíritu: —Tacajba' in catel pa ranma ja rachi, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ja c'a ritzel espíritu arja' xuya' jun ataque tre ja rachi in congana nurak ruchi', xel pa ranma in be. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ja c'a winak canojelal congana c'asc'o'i quetz'at in quewa' quibij chibil tak qui' ri': —¿Nak c'awa' wari', nak chi c'ac'a tijonemal ja wari'? Como jawa' ja rachi ri' masqui e itzel tak espíritu pro c'o taka'an ruk'a' chique chi neruban mandar in nnimax taka'an cumal, neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","In chanim be nat nakaj rtzijoxic ja Jesús chipan ja jule' chic lugar ja c'o pa rcuenta Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ja c'a Jesús e rachbil ja Jacobo in Juan eje'e' tok xe'elel chipan ja jay xin molbal ri'il xebe cuq'uin ja Simón in Andrés pa cochoch. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ja c'a rjite' ja Simón arja' c'o chwa ch'at yawa', majtajnak rmal c'atan, ja c'a Jesús tok xe'ekaji bix tre chi yawa'. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Arja' tiloc ruq'uin, xuchap chi ruk'a', xuyic in ni jari' hora xeli ja c'atan. Ja c'a rixok arja' xumaj quilixic ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ja c'a tok xoc ak'a' canojel ja yawa'i' xec'amarel chwach ja Jesús e cachbil ja re'ocnak itzel tak espíritu chique, ");
INSERT INTO tzjNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ja c'a tinamit emulan chi'jay canojel ja bar c'o wi' ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ja c'a winak q'uiy rwach ja yobil e'uc'ayon in ja Jesús arja' e q'uiy chique ja xertzursaj in e q'uiy chique chakaja' ja xerlasaj itzel tak espíritu chique. Arja' xeruk'il chi maquetzijon más como eje'e' cotak chi arja' ja Cristo ja cha'on rmal ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ja c'a chi rcab k'ij c'a rc'ulun na, c'a k'eku'm na ja tok yictajel ja Jesús xelel chipan ja tinamit, be chipan jun lugar ja bar kas talan wi' chi nerbana' oración. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ja c'a Simón in ja re rachbil eje'e' xebe chi rcanoxic. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ja c'a tok quewil quewa' quibij tre ri': —Ja winak canojel quimajon acanoxic, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","In bix chique rmal ja Jesús: —Jo' chipan ja jule' lugar chic ja c'o chikanakaj chi tri' nenya'a' wi' rbixic ja utzlaj tzij chakaja' como xa rmalari' tok inpenak, xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Queri' xuban ja Jesús be nojel lugar ja c'o pa rcuenta Galilea, noqui pa tak jay xin molbal ri'il in tri' nuya' wi' rbixic ja utzlaj tzij chique ja winak in nerlasaj itzel tak espíritu chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xuban jun yawa' jutij ec'o jule' itzel tak ch'a'c trij, arja' xekaj ruq'uin ja Jesús, xuque' chwach in congana xc'utuj rto'ic tre: —Ja wi nawajo' ninatzursaj, anin wotak chi natcowini ninatzursaj, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ja c'a Jesús arja' xpokonaj rwach ja yawa', xuyuk pon ja ruk'a', xuchap in xbij tre: —Can nwajo' ja cani' nabij chwe, cattzuri, ne' tre, ");
INSERT INTO tzjNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","in ni chanim xeli ja ritzel tak ch'a'c trij, tzuri. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","C'ac'ari' ja Jesús xbij tre: —Congana nban recomendar chawe chi majun bar ta tri' nabij wi' ja xinban chawe. Xar ja naban, jat, jac'utu' awi' chwach ja sacerdote in como xattzuri jaya'a' ja rofrenda ja cani' rbin can ja Moisés chipan ja ley xin Dios chi naban. Ja c'a rofrenda naya' jari' noc testimonio chiquewach ja sacerdote chi naban cumplir ja rbin can ja Moisés, ne' tre. C'ac'ari' xubanel despedir. ");
INSERT INTO tzjNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pro ja rachi tok be ma xuban ta ja cani' bix tre rmal ja Jesús, congana xlasaj rbixic chi Jesús ja tzursan rxin. Rmalc'ari' ja Jesús congana c'ayew chic tre ja ni ta chiquewach winak noc chic chipan ja tinamit pro ja xuban, be in tri' q'ueje' wi' ja bar ma ec'o ta wi' winak, in nij ec'o wi' winak ja ne'ekaj ruq'uin, nojel tinamit epenak wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ja c'a tok xuban pon quiji' jo'o' k'ij meloji ja Jesús chipan ja tinamit Capernaum. Ja tok c'o chic chipan ja tinamit ja winak quic'axaj chi arja' ocnak chipan jun jay. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chanim xequimolola' qui' ja winak ruq'uin, congana e q'uiy pro ni xepitz'e'e ja pa jay, xe'elto c'a pa rchi'jay, majun chic neq'ueje' wi'. Ja c'a Jesús arja' ntajini rmajon rbixic ja rtzobal Dios chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ec'o c'a quiji' achi'i' xe'urkaji, quic'amonto jun achi siquirnak, ncajo' nquecoj chwach ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eje'e' ma xecowin ta xe'ekaji ja bar kas c'o wi' ja Jesús como ja winak congana enojnak pa jay. Rmalc'ari' ja tok xejote' parwi' ja jay, quitak'ba' rwi' in tri' quikajsaj wi' ja yawa', cotz'ol chwach jun ch'atan che'. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ja c'a Jesús tok xutz'at ja yukulbal quec'u'x c'o ruq'uin, arja' xbij tre ja siquirnak: —Nc'ajol, camic cuytaji ja rawil amac, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ec'o c'a jule' maestro ja netijon quixin ja winak tre ja ley xin Dios etz'ubul tri' pa jay, eje'e' tok chaka maril quic'axaj ja xbij ja Jesús quewa' quemaj rch'obic pa tak canma ri': ");
INSERT INTO tzjNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Nak c'a trela' tok nbij quela' ja rachi le'? Ja nbij le' jala' xa ofensa rc'amonto tre ja Dios como mchita nak chi ta ncuyuwi ja il mac, xa ruyon ja Dios ncuyuwi, xeche' kaj ja pa tak canma. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pro ja Jesús arja' bien rotak ja quimajon rch'obic pa tak canma in quewa' xbij chique ri': —¿Nak tre tok queri' nech'ob kaj pa tak ewanma? ");
INSERT INTO tzjNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Camic nwajo' nc'waxaj chewe ¿nak ja más c'ayew tre ja ca'i' ri' chi nbij tre ja rachi siquirnak, la ja' nbij tre chi ncuy ja ril rumac o la ja' nbij tre chi nyictaji in nuc'amel ja rwarbal in numaj binem? ");
INSERT INTO tzjNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Anin c'oli ja xtinban chewach camic ri' utzc'a chi newotakij chi anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak yatajnak chwe chi ncuy ja quil quemac ja winak wawe' chwach'ulew, ne'e ja Jesús chique. C'ac'ari' xbij tre ja siquirnak: ");
INSERT INTO tzjNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Anin nbij chawe camic, catyictaji, tac'ama'el ja rawarbal in jat chi awochoch, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chaka maril bitaji queri' rmal c'ac'ari' yictaji ja rachi in xumaj rc'olic ja rwarbal. Ja c'a tok c'oltajel rmal be, xelel chiquicojol pro ni chiquewach canojelal. Ja c'a winak eje'e' congana c'asc'o'i quetz'at ja bantaji in quemaj rya'ic ruk'ij ja Dios rmal, quewa' nquibij ri': —Jawa' ja bantaji ri' ma jutij katz'aton ta, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","C'ac'ari' be chic jutij ja Jesús chuchi' ja ya'. Ja tok xekaji chiya' canojel ja winak xequimolo' chic qui' ruq'uin in arja' xumaj quitijoxic tre ja rtzobal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ja c'a tok melojto ja chiya' kas rmajon binem ja tok c'o jun achi xutz'at rbina'an Leví rc'ajol Alfeo. Ja Leví arja' tz'ubul chipan ja lugar ja bar nto̱j can wi' ja rimpuesto pa ruk'a' in bix tre rmal ja Jesús: —Jo', cattre' chwij chi natoc ndiscípulo, ne'xi. Ja c'a Leví yictaji in tre'el trij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ja c'a Jesús arja' c'o pa rochoch ja Leví, tz'ubul pa mesa e rachbil ja rdiscípulo in ec'o jule' molol tak impuesto e cachbil jule' chic aj'il ajmaqui' neche'xi, eje'e' etz'ubul pa mesa cuq'uin pro congana e q'uiy como e q'uiy ja retranel trij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ec'o c'a jule' maestro ja netijon quixin ja winak tre ja ley xin Dios e cachbil jule' fariseo, eje'e' tok quetz'at ja Jesús chi cuq'uin molol tak impuesto nwa' wi' e cachbil jule' chic aj'il ajmaqui' neche' chique, quewa' quibij chique ja rdiscípulo ri': —¿Nak c'a trela' tok xa cuq'uin molol tak impuesto nwa' wi' e cachbil jule' chic aj'il ajmaqui'? xeche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pro ja c'a Jesús ja tok c'axtaj rmal ja quibij quewa' xbij chique ri': —Ja ma e yawa'i' ta eje'e' matic'atzin jun doctor chique pro ja yawa'i' jari' ni rjawaxic wi' jun doctor chique. Anin inpenak chi ne'uncanoj ja raj'il ajmaqui' utzc'a chi nqueya' can ja quil quemac, ma eje'e' ta ja ch'ajch'oji' chic ja ne'uncanoj. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ja c'a rdiscípulo ja Juan Bautista eje'e' quimajon rbanic ja rayuno in queri' quimajon rbanic ja discípulo quixin ja fariseo chakaja'. Ec'o c'a jule' winak xe'ekaj ruq'uin ja Jesús in quewa' quibij tre ri': —¿Nak tre ja radiscípulo atat taka'an matiqueban ja rayuno pro ja rdiscípulo ja Juan eje'e' ni nqueban wi' ja rayuno in queri' nqueban ja discípulo quixin ja fariseo chakaja'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ja c'a Jesús arja' xbij chique: —Cani' chique jule' winak ebanon invitar tre jun c'ulbic, ja tok c'a c'o na ja rachi chiquicojol ja nc'ule'e ¿la yatal chiquij chi nqueban ja rayuno nech'ob ixix? Jaru' pa tiempo nq'ueje' chiquicojol ja rachi ja nc'ule'e jari' mta moda xtiqueban ta ja rayuno. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pro nerila' na jun k'ij ja tok eje'e' xtilasax chiquicojol ja rachi ja nc'ule'e, c'a tokoc'ari' tok xtiqueban ja rayuno. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mta jun nak ta xtuc'am ta jutz'it chi' tziak c'ac'a xtic'ojbej ta jun tzabuklaj tziak. Ja wixta queri' nbani ja chi' tziak c'ac'a nuc'ol ri' in xa jani' ntak'e' más ja bar tak'al wi' tre ja tzabuklaj tziak. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","In chakaja' cani' tre vino c'ac'a mta jun nak ta xtuc'ol ta pa tzabuklaj tak c'olbal. Ja wixta queri' nbani ja c'ac'a vino nurak ja c'olbal, ntz'iloxi vino in ntz'iloxi ja c'olbal chakaja'. Pro ja rjawaxic chi nbani, ja c'ac'a vino nc'oli chipan c'ac'a tak c'olbal. Queri' xbij ja Jesús tre ja c'ac'a tijonem ja rc'amonto. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Xuban c'a jutij pa jun xula'nbal k'ij arja' rmajon binem chipan jule' trigo e rachbil ja rdiscípulo. Kas netajini nek'ax chipan ja trigo ja tok quemaj rk'olic ja trigo ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ec'o c'a jule' fariseo, eje'e' quibij tre ja Jesús: —Pakasa' radiscípulo le', ja netajini quimajon rbanic jala' xajan nbani pa tak xula'nbal k'ij ¿nak tre tok nqueban quela'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ja c'a Jesús xbij chique: —¿La ma esiq'uin ta la'an chipan ja rtzobal Dios ja xuban ja rojer rey David tokori' tok ocnak lok'laj sacerdote ja rAbiatar? Ja c'a David arja' c'o rjawaxic tre tri' in majtaj rmal rk'ak'anil rupan in queri' queban ja rachbil chakaja'. Tokoc'ari' xuban ja David xoc chipan ja rochoch Dios in xutij ja caxlanway ja parti'in chwach ja Dios in xuya' quixin ja rachbil chakaja'. Queri' xuban masqui jari' caxlanway tz'ibtal chipan ja ley xin Dios chi xa queyon sacerdote ja netijowi. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","In xbij chic chique: —Ja winak tok xewinakarsax rmal ja Dios ma rmal ta chi chaka ta nquec'ul ruk'ij ja xula'nbal k'ij pro jari' winakarsaxi ja xula'nbal k'ij chi quito'ic ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Rmalc'ari' tok nbij chewe chi anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak, pa nuk'a' anin c'o wi' ja nbani chipan ja xula'nbal tak k'ij chakaja', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ja c'a Jesús arja' xoc chic jutij chipan ja jay xin molbal ri'il in tri' c'o wi' jun achi siquirnak jun ruk'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ec'o c'a jule' winak e c'ambajal rxin ja Jesús, eje'e' ncajo' nquetz'at ja wi ntzursaj ja rachi pa jun xula'nbal k'ij. Queri' nqueban utzc'a chi nquewil jun ril ja nquichapbej rxin. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","C'ac'ari' ja Jesús xbij tre ja rachi ja siquirnak ruk'a': —Catyictaji in catpe'e wawe' chikacojol, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","C'ac'ari' xbij chique ja winak: —¿Nak nuya' lugar chake ja ley chi nkaban pa tak xula'nbal k'ij, la ja' chi nkaban ja rutzil owi itzelal? ¿La ja' nuya' lugar chake chi nekato' ja winak owi nekacamsaj? ne' chique. Pro ja reje'e' ni majun nak ta quibij ta tre, ma xquic'ulba' ta. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","C'ac'ari' pi ryewal ja Jesús chiquij in xertz'elwachij, congana bison cumal rumac ja ni mta wi' quigana nch'obtaj cumal ja xbij chique. In xbij chic tre ja rachi ja siquirnak jun ruk'a': —Tayuku' ja rak'a', ne' tre. Ja c'a rachi xumaj ryukic ja ruk'a' in tzuri. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ja c'a fariseo eje'e' xebe, xequimolo' qui' e cachbil ja rec'o chipan ja partido rxin ja Herodes in quemaj rch'obic nak nqueban tre ja Jesús chi nquicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ja c'a Jesús arja' xelel chipan ja lugar in be chiya' e rachbil ja rdiscípulo in congana e q'uiy ja winak ja raj Galilea xetre'el trij. In ec'o na más ja xe'ekaj ruq'uin cani' chique ja raj Jerusalén in chique ja rec'o chipan ja jule' chic tinamit ja c'o pa rcuenta Judea in chique ja raj Idumea in chique ja rec'o chajuparaj binelya' Jordán in chique ja raj Tiro in ja raj Sidón pro congana e q'uiy ja winak xe'ekaj ruq'uin. Queri' queban como ekajnak rbixic cuq'uin nojel ja ntajini nuban ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ja c'a Jesús xbij chique ja rdiscípulo: —Tiq'ueje'to listo jun lancha matzij ja winak xa congana tiquepitz' qui' chwij, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Queri' xbij chique como arja' e q'uiy ja winak ertzursan chic in rmalari' tok canojel ja c'o yobil chique congana nquemin qui' trij, ncajo' nquechapoc chi netzursaxi. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ja c'a ritzel tak espíritu ja rec'o chique ja winak eje'e' tok quetz'at ja Jesús xexuque' chwach, quemaj rakic quechi' in quewa' quibij tre ri': —Atat ja rat Ralc'wal Dios, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ja c'a Jesús congana cow xeruchap in xbij chique chi majun bar ta tri' nquik'alasaj wi' chi arja' ja Cristo. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","C'ac'ari' jote'e ja Jesús chwach jun jayu', xuwil jun lugar ja bar q'ueje' wi'. Ec'oli chiquicojol ja winak ja c'o rgana ja Jesús chi netre'el trij, arja' xersiq'uij pon in xebe ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","In ec'o cablajuj ja xerucha' chique utzc'a chi eje'e' neq'ueje' ruq'uin chijutij in chakaja' chi nebe nequiya'a' rbixic ja rtzobal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","In chakaja' xuya' chique ja poder chi necowini nequitzursaj yawa'i' in nequiwasajel itzel tak espíritu chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Quewa' quebi' ja cablajuj ri', Simón ja canox chic jun rubi' bina'ax tre Pedro, ");
INSERT INTO tzjNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo ja rc'ajol Zebedeo, Juan ja rch'alal Jacobo, ja c'a Jacobo in Juan eje'e' canox chic jun quebi' rmal ja Jesús bina'ax chique Boanerges. Boanerges tibij tzij alc'walaxela' ja congana quichok'ak' e cani' quiakolijay. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ja rAndrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo ja rc'ajol Alfeo, Tadeo, Simón, jun chique ja partido rbina'an cananita, ");
INSERT INTO tzjNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","in Judas Iscariote ja jachowi ja Jesús pa quek'a' ja xetzelan rxin. Ja c'a Jesús xoc chic chipan jun jay e rachbil ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ja c'a winak xequimolo' chic qui' cuq'uin in rmalari' nixtac'a c'o ta tiempo chique ja Jesús chi newa'i. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ja c'a rch'alal ja Jesús tok quic'axaj ja ntajini nuban eje'e' xepeti, ncajo' nquec'amel. Queri' queban como ja pa quetzij eje'e' ch'ujari ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","In chakaja' ec'o jule' maestro ja netijon quixin ja winak tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés, eje'e' epenak pa Jerusalén in quewa' quibij chique ja winak ri': —Jala' rachi le' Beelzebú uc'ayon rxin, xa poder rxin ja jefe quixin ja ritzel tak espíritu xa jari' nucoj chi quilasaxic ja ritzel tak espíritu, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ja c'a Jesús xersiq'uij pon in quewa' jun c'ambal tzij ja xbij chique ri': —Mta moda ja Satanás xquerlasaj ta ja rach tak demonio. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jun gobierno wi xa división nuban chibil ri' jari' xa nyojtaji. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","In queri' chique jule' winak ja rec'o pa jun jay chakaja', wi xa división nqueban chibil tak qui' jari' xa neq'uisi. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","In queri' c'a tre ja Satanás chakaja', ja wi xa nch'ojin kaj ruq'uin arja' ruyon, wi nerlasaj ja rach tak demonio jari' xa nyojtaji in nq'uisi. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ja wi natekaj ruq'uin jun achi ja congana rchok'ak' in wi nach'ob chi nalasaj tre ja rnakun ja c'o pa rochoch rjawaxic chi nabac' na nabey ja rachi. Ja wi queri' naban jari' natcowini nalasaj tre nojel ja c'o pa rochoch. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Anin ni katzij wi' ja xtinbij chewe ri', ja winak masqui nqueban ja il mac xa nak ta chi il maquil jari' c'o cuytajic trij in chakaja' masqui nquibij jule' tzij tre ja Dios ja xa ofensa rc'amonto tre jari' c'o cuytajic trij chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pro wi c'o jun winak xa nak ta chi winakil wi arja' nbij jule' tzij tre ja rEspíritu Santo ja xa ofensa rc'amonto tre jari' ni mta wi' cuytajic trij jari' il mac nrijkalej pro ni chijutij, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Queri' xbij chique rumac ja quibij tre chi c'o jun itzel espíritu uc'ayon rxin. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","C'ac'ari' xe'urkaji ja rch'alal ja Jesús cachbil rute', eje'e' ec'o chwa jay in quetakoc rsiq'uixic. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ja c'a winak ja retz'ubuloc chinakaj ja Jesús eje'e' quibij tre: —Pakasa' rate' in ja re awach'alal ec'o chwa jay in ncajo' netzijon awq'uin, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ja c'a Jesús xbij chique: —Camic nch'ob chewach echinatak ja nute' in echinatak ja wach'alal, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","C'ac'ari' xeruc'ut ja retz'ubuloc chinakaj in quewa' xbij ri': —Eje'e' c'awa' e'ocnak nute' in e'ocnak wach'alal. ");
INSERT INTO tzjNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Queri' nbij chewe como xa nak ta ja nbanowi rvoluntad ja Dios arja' c'ari' ocnak nuchak' owi wana' owi nute', ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jutij chic ja Jesús xumaj quitijoxic ja winak chiya' in congana e q'uiy ja winak xurquimolo' qui' ruq'uin rmalc'ari' tok arja' xoc chipan jun lancha ja c'o parwi' ya' in tz'abe' chipan. Ja c'a winak xemule' can chiya' canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","In xumaj tzij ja Jesús cuq'uin, q'uiy rwach ja xbij chique pa c'ambal tak tzij, quewa' ja tijonem ja xuya' chique ri': ");
INSERT INTO tzjNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Tec'waxaj ja xtinbij chewe ri' pro bien teya'a' ewxquin tre. C'o jun ajticola' be pa ticoj tijco'm pa rchenoj. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ja c'a tok xekaji xumaj rchicaxic ja rija'tz. C'o c'a kaj pa bey in xepeti ja tz'iquin, quetij. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","C'o chic jule' kaji ja bar c'o wi' abaj, xa xax ja rulew in chanim xelto rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pro ja tok xelto ja k'ij xc'atsaj in tok q'uiswani chakij rmal como mta más ja rc'amal. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","C'o chic jule' kaj pa tak q'uix in tok q'uiswani q'uiyi ja q'uix, xcamsaj ja tijco'm. Queri' xuban ni majun rwach xuya'. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pro c'o chic jule' kaj pan utzlaj ulew in wachini chi utz, congana q'uiyi, be pa nim, ja jun chirwach ija'tz c'oli xuya' treinta, c'oli xuya' sesenta in c'oli xuya' jun ciento. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bien c'a tewasaj ena'oj trij ja c'a xinbij chewe ri', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ja c'a tok quipaxijel qui' ja winak xecanaj can ja rachbil ja Jesús ruq'uin e cachbil ja cablajuj apóstol in c'oli quic'axaj tre ja Jesús tre ja c'ambal tzij. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ja c'a Jesús quewa' xbij chique ri': —Ja rixix yatajnak chewe chi newotakij nak rbanic ja rawatal je'e tre ja gobierno xin Dios pro ja chique jule' chic winak nojel ja nbij chique ncoj c'ambal tak tzij chi rbixic. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Queri' nban utzc'a chi eje'e' nquetz'at ja nc'u̱t chiquewach pro matikaj pa quewi' utzc'a chakaja' chi nquic'axaj ja nbix chique pro matich'obtaj cumal utzc'a chakaja' chi matiqueq'uex ja quina'oj chi ncuytaji ja quil quemac. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","In xbij chic chique: —¿La ni c'a matich'obtaj wi' emwal ja c'ambal tzij ja c'a xinbij kaj? Ja wi maquixcowini nech'ob ja c'ambal tzij tre ja rajticola' ¿nak moda xquixcowini xtech'ob ja jule' chic c'ambal tak tzij? Pro ja camic nch'ob chewach nak tibij ja c'ambal tzij. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ja rajticola' ja chicani ja rija'tz jari' ja nyowi rbixic ja rtzobal Dios chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ja kaj pa bey jari' tibij tzij chi ec'oli winak ja nquic'axaj ja rtzobal Dios pro chanim npeti ja Satanás, nlasajel ja rtzobal Dios ja ticon pa tak canma. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ja kaji ja bar c'o wi' abaj jari' tibij tzij chi ec'oli winak ja nquic'axaj ja rtzobal Dios in nquinimaj chanim, congana nequicot rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pro eje'e' e cani' jule' tijco'm ja mta rc'amal, xa ti jurata nquinimaj. Ja c'a tok xterila' ja c'ayewalaj tiempo ja tok nmajtaj rbanic pokon chique ja winak rmal ja rtzobal Dios eje'e' chanim nqueya' can. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ja kaj pa tak q'uix jari' tibij tzij chi ec'oli winak ja nquic'axaj ja rtzobal Dios ");
INSERT INTO tzjNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pro tok nq'uiswani xa ja' nquibisoj chic ja xin rwach'ulew in xa neba̱n engañar rmal ja meba'il in chaka benak chi nquiyarij nakun je'e. Rmalc'ari' tok xa ncami ja utzlaj tzij ja c'o pa tak canma, mta rwach nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pro ja c'a rija'tz ja kaj pan utzlaj ulew jari' tibij tzij chi ec'oli winak ja nquic'axaj ja rtzobal Dios in nquinimaj in c'oli rwach nuya' pa tak canma. Eje'e' e cani' jule' chirwach ija'tz c'oli xuya' treinta, c'oli xuya' sesenta in c'oli xuya' jun ciento. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","C'ac'ari' xbij chic jun c'ambal tzij chique: —¿La c'o ta c'a jun nbanowi nerc'ama'to jun candil nutzij in xtijupba' ta c'a jun caxon trij owi xtuya' ta xe' ch'at? Ja queri' ni majun nbanowi. Ja c'a nba̱n tre ja candil njecbaxi utzc'a chi nsakirsaj ja pa jay. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nojel ja ma k'alajinnak ta je'e jari' nerila' na jun k'ij tok xtik'alajini in nojel ja rawatal je'e jari' nel na pa sakil, notakix na. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bien c'a tewasaj ena'oj trij ja c'a xinbij kaj chewe ri', ne'e ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","In xbij chic chique: —Bien teya'a' ewxquin tre ja remajon rc'axaxic. Ja wi congana neya' ewxquin tre jari' q'uiy xtiyataj chewe chi newotakij nowi ma kas ta neya' ewxquin tre jari' ma kas ta c'oli xtiyataj chewe chi newotakij. In ja c'a chewe ixix ja remajon rc'axaxic camic más chi na q'uiy xtiyataj chewe chi newotakij. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Queri' nbij chewe como ja winak ja c'o je'e yatajnak chique eje'e' c'o chi na más ja nyataj chique pro ja c'a winak ja mta yatajnak chique pro nquech'ob chi c'oli jari' nlasax chique. Queri' xbij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Xumaj chic tzij ja Jesús: —Ja gobierno xin Dios queri' rbanic cani' nuban jun achi ja tok nbe pa rchenoj, nertica' jule' ija'tz chipan. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ja c'a tok noc ak'a' c'o chic ja rachi pa rochoch in nwari, ja c'a tok nsakari nyictaji in queri' nuban nojel tak k'ij. Ja c'a rija'tz ja rticon pa rchenoj ekal nelto ruyon in numaj q'uiyem. Pro ja rachi arja' ma rotak ta nak nuban ja rija'tz tok nelto in tok nq'uiyi. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Como ja rwach'ulew arja' nsamajini chi nelto ja rija'tz in nwachini. Ja nuban nabey nq'uiyi in npi ruxak, c'ac'ari' nwinakari och' trij c'ac'ari' nq'uiyi ja och' noc áj. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ja c'a tok nchakiji ja c'a rachi nerbana' jach' como xerila' ja tiempo xin cosecha. Queri' xbij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","In xbij chic: —¿Bar c'a njunsaj wi' ja gobierno xin Dios in nak chi c'ambal tzijal ncoj chi rjunsaxic? ");
INSERT INTO tzjNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ja gobierno xin Dios queri' rbanic cani' rbanic jun ti chirwach mostaza tok ntiqui pan ulew. Jun ti chirwach mostaza masqui más na tino'y chwach ja jule' chic ija'tz ja c'o chwach'ulew ");
INSERT INTO tzjNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","pro ja tok ntiqui in tok nq'uiyi más na nq'uiyi chwach jule' chic tijco'm, nwinakar nimak tak ruk'a' in tok nq'uiswani nepeti ja tak tz'iquin, nurquibana' quesoc pa tak ruk'a' in nemujax rmal ja ruxak. Queri' xbij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Q'uiy rwach ja c'ambal tak tzij xbij ja Jesús ja quitakawari' ja nertijobej ja winak tre ja rtzobal Dios, jani' necowini nch'obtaj cumal jari' xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ni majun nak ta xbij ta chique ja maquita xucoj c'ambal tak tzij chi rbixic chique. Pro ja xuban chique ja rdiscípulo arja', xeryonaj in xk'alasaj chiquewach nojel ja nbij ja c'ambal tak tzij. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jari' k'ij ja tok xoc ak'a' ja Jesús arja' xbij chique ja rdiscípulo: —Jo' chajuparaj ya', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Eje'e' xequeban can despedir ja winak. Ja c'a Jesús arja' c'o chipan ja lancha in quec'amel in c'o chic jule' ja lancha tre'el trij. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pro chaka c'a jalal tok jaktajto jun nimlaj ik' chiquij. Ja c'a nimak tak baloj congana npowij ri' trij ja lancha ja rec'o wi' ja Jesús in ntajini nnoji ja ya' chipan. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ja c'a Jesús arja' pa rchak lancha c'o wi', kajnak chi waram in c'oli rcanon ocnak rq'uexwach rch'acat rwi'. Ja c'a rdiscípulo quec'as: —Maestro ¿la macatocla' il ja wi nokcami? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yictaji ja Jesús in xbij tre ja ik' chi ncaje'e in xbij tre ja ya' chi nsile'e. C'ac'ari' cami ja ik' in ni sile'e ja ya'. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","C'ac'ari' xbij chique: —¿Nak c'a tre tok congana xexbej ewi'? ¿Bar c'a xoc wari' ja yukulbal ec'u'x wq'uin? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ja c'a reje'e' congana c'asc'o'i quetz'at ja bantaji in quemaj rbixic chibil tak qui': —¿Nak rbanic c'ala' ja rachi le'? nnimax taka'an rmal ja ik', nnimax taka'an rmal ja ya' chakaja', xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ja c'a tok xe'ekaji chajuparaj chic ya' tri' xe'ekaj wi' chipan jun lugar ja c'o pa quicuenta ja raj Gadara. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ja c'a Jesús tok chaka maril xeli ja pa lancha c'o jun achi xekaj ruq'uin ocnak jun itzel espíritu tre, arja' pa comsanto elnakto wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ni tri' wi' nq'ueje' wi' pa comsanto in majun nak ta ncowin ta trij masqui nquebac' pa cadena. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Como arja' q'uiylaj mul banon tre bac'on ruk'a' rkan pa cadena pro ni ma c'ayew ta nuban tre nq'uiokpij. Ni majun nak ta ncowin ta trij ja nchapbex ta rxin ja xta jun nq'ueje' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chi pa k'ij chi chak'a' ni rmajon wi' binem pa tak k'ayis in pa comsanto, congana nurak ruchi' in ruyon nusoc ri' tre abaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ja c'a tok xutz'at pon ja Jesús c'amc'ol ranim be ruq'uin, ja c'a tok xekaj ruq'uin xuque' chwach ");
INSERT INTO tzjNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","in xumaj rakic ruchi': —Jesús, atat ja rat Ralc'wal ja nimlaj Dios ¿nak nawajo' chwe? Chwach Dios nbij chawe, maxta taban pokon chwe, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Queri' xbij tre como ja Jesús arja' c'a xbij tre ja ritzel espíritu ja rocnak tre ja rachi chi nelel pa ranma. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","C'ac'ari' ja Jesús xbij tre ja rachi: —¿Nak c'a abi'? ne' tre. —Anin in Legión. Queri' nubi' como ok q'uiy, ne'xi ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","In congana xucoj ja Jesús pa ch'a'oj chi ma xquerwasajel ta ja ritzel tak espíritu in ma xquerutakel ta chipan jun chic lugar. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ec'o pon c'a jule' ak quimajon wa'im pa tak k'ayis. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ja c'a ritzel tak espíritu canojel congana quecoj ja Jesús pa ch'a'oj in quewa' quibij tre ri': —Ko'ataka'el cuq'uin ja jule' ak le', taya'a' lugar chake chi nokoc pa quicuerpo, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ja c'a Jesús xuya' lugar chique in queri' queban xe'eli, xe'oc pa tak quicuerpo ja ak. Ja c'a ak ec'o la ca'i' mil canojel in chaka maril xe'oqui ja ritzel tak espíritu chique, eje'e' quemaj c'amc'oj canim, xebe, xexule' chwach jun jayu' congana tiquitic, xebe c'a pa ya' in tri' xejik' wi' canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ja c'a chajinel quixin ja ak eje'e' xe'anmajel, xebe chipan ja tinamit in pa tak aldea chakaja', xequicholo' nojel ja bantaji. Ja c'a winak tok quic'axaj eje'e' xepeti chi nurquitz'ata' ja bantaji. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ja tok xe'urkaji ja bar c'o wi' ja Jesús quetz'at ja rachi ja congana e q'uiy ja ritzel tak espíritu e'ocnak tre nabey, arja' tri' tz'ubul wi', c'o chic ja rtziak rcojon, tz'akat chic ja rpensar. Ja c'a winak tok quetz'at congana quixbej qui' rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","C'ac'ari' ja xetz'atowi ja bantaji eje'e' quemaj rcholic chiquewach ja jule' chic winak nak xuban ja rachi tok xelasaxi ja ritzel tak espíritu tre in nak queban ja ak chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","C'ac'ari' ja winak quewa' quibij tre ja Jesús ri': —Catelel wawe', taya'a' can ja kalugar, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ja c'a Jesús kas rmajon oquem pa lancha ja tok bix tre rmal ja rachi ja xelasaxel ja ritzel tak espíritu tre: —Tabana' jun utzil, taya'a' lugar chwe chi nintre' chawij chijutij, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pro ja Jesús arja' ma xuya' ta lugar tre chi nbe trij, quewa' xbij tre ri': —Mejor ja naban, jat chi awochoch, jabij chique ja rawach'alal chi janila jun nimlaj samaj xuban ja Dios chipan ja rac'aslemal in janila xpokonaj awach, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","C'ac'ari' be ja rachi pa tak tinamit ja c'o pa rcuenta Decápolis, xumaj rbixic ja nimlaj samaj ja xuban ja Jesús chipan ja rc'aslemal in canojel ja winak congana c'asc'o'i quic'axaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ja Jesús xemeloj chic jutij pa lancha chajuparaj ya'. Ja c'a tok xe'ekaji congana e q'uiy ja winak xequimolo' qui' ruq'uin in tri' q'ueje' wi' chiya' cuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","C'ac'ari' c'o jun achi peti rbina'an Jairo, arja' jun chique ja jefe rxin ja jay xin molbal ri'il ja bar nc'axax wi' ja rtzobal Dios. Ja c'a Jairo tok xurkaj ruq'uin ja Jesús xuque' chwach ");
INSERT INTO tzjNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","in quewa' xbij tre ri': —C'o jun nme'al camíc nuban, tabana' jun utzil jo' chwij, jaya'a' ak'a' pa rwi' utzc'a chi ntzuri in wotak chi maticami, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ja c'a Jesús rachbilajel ja rachi, congana e q'uiy ja winak xetre'el trij, congana nquepitz' qui' trij ebenak pa rochoch ja Jairo. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","C'o c'a jun ixok yawa' ja c'o chiquicojol ja winak, tuban cablajuj juna' ni c'o wi' je'e quic' nel tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ja rixok e q'uiy ja doctori' congana rtijon pokon pa quek'a' in nojel ja c'o ruq'uin xuq'uis rmal ja yobil. Pro majun xoc wi' ja xuban como ja yobil xa jani' benak más pa nim. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Como arja' ekajnak chic rbixic ruq'uin nojel ja ntajini nuban ja Jesús rmalc'ari' tok xa jani' tiloc más trij. Ja c'a tok xekaj ruq'uin xuchapoc jutz'it ja rtziak. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Queri' xuban como ja ntajini xbij kaj pa ranma: —Ja wi xtinchap ja rtziak ja Jesús xa ruq'uin ari' wotak chi nintzuri, ne' kaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chaka maril xuchapoc rtziak ja Jesús ni caje'e ja quic' tre in xuna' chi tzuri, xeli ja yobil tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ja c'a Jesús arja' xuna' chi c'oli ja poder xel tre, ni quipitz'on wi' qui' ja winak trij, xuya' vuelta in quewa' xbij ri': —¿Nak chapowi ja ntziak? ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","C'ac'ari' ja rdiscípulo eje'e' quewa' quibij tre ri': —¿La matatz'at la'an chi congana winak quipitz'on qui' chawij chewi' nak tre tok nabij: —Nak xinchapowi, taka'an natche'e? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pro ja Jesús kas cholaj nbe wi' rwach, arja' ncanoj nak chapowi ja rtziak. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ja c'a rixok congana nbirboti rumac xben ri' como arja' bien rotak chi xeli ja yobil tre, peti xuque' chwach ja Jesús, xuchol chwach nojelal nak rbanon pa ruk'a' ja yobil. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bix tre rmal ja Jesús: —Nme'al, ja yukulbal ac'u'x wq'uin jari' xattzursani. Camic utz chic natbe, catquicoti, xattotaji chijutij pa ruk'a' ja yobil, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ja Jesús c'a rmajon na tzij ja tok ec'o jule' winak xe'urkaji, e'elnakto pa rochoch ja jefe rxin ja jay xin molbal ri'il, quewa' quibij tre ja jefe ri': —Jairo, ja rame'al cami ¿nak noc wi' ja naban molestar más ja Maestro? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ja c'a Jesús tok chaka maril xc'axaj ja quibij arja' xbij tre ja jefe rxin ja jay xin molbal ri'il: —Ma taxbej ta awi', ja naban, tiyuke' ac'u'x wq'uin, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","C'ac'ari' be ja Jesús, mta nak chi ta xeruc'amel, xa queyon ja Pedro, ja Jacobo in Juan ja rch'alal Jacobo. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ja c'a tok xe'ekaji ja chi rochoch ja jefe ja Jesús xerutz'at ja winak ja rec'o pa jay chi congana lawulo' nqueban, quimajon ok'ej in congana síc' nqueban. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ja tok xoc pa jay quewa' xbij chique ri': —¿Nak tre tok neban quela'? congana taka'an síc' ok'ej neban. Ja xtan ma camnak ta, xa waram rbanon, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pro ja reje'e' xa quitzebej. C'ac'ari' ja Jesús xerlasajto pro canojelal. Ja c'a tok xelastajto rmal c'ac'ari' xeruc'amel chic ja rtata' rute' ja camnak e rachbil ja retran trij chakaja', xe'oqui ja bar c'o wi' ja cuerpo rxin ja xtan. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ja c'a Jesús xuchap chi ruk'a' ja camnak in quewa' xbij tre ri': —Talita, cumi, ne' tre. Jawa' tzij xbij tre ri' tibij tzij: —Xtan, camic anin nbij chawe catyictaji, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chaka maril bitaj queri' rmal ja Jesús yictaj nojoj ja xtan in xumaj binem. Ja xtan cablajuj chic ja rjuna'. Ja rec'o ruq'uin ja Jesús congana c'asc'o'i quetz'at ja bantaj chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ja c'a Jesús congana xuban recomendar chique chi majun bar ta tri' nquibij wi' ja bantaji in xbij chique: —Teya'a' rway ja xtan, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ja c'a Jesús xelel, be chipan ja rtinamit arja', xerachbilajel ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ja c'a tok xerila' ja xula'nbal k'ij xoc chipan ja jay xin molbal ri'il, xumaj quitijoxic ja winak. E q'uiy ja winak ja xec'axani ja tijonem xuya' in congana c'asc'o'i quic'axaj in quewa' quibij chibil tak qui' ri': —¿Bar c'a penak wala' ja rocnak tre jala' jun achi le'? congana taka'an rna'oj yatajnak tre in congana taka'an nimak tak milagro nuban chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pro ¿la ma arja' ta c'ala' ja josol che' ja ral María? In ja rch'alal ¿la ma eje'e' ta c'a ja Jacobo, ja José, ja Judas in Simón? In ja rana' ¿la ma ec'o ta c'a chikacojol chakaja'? xeche'e. Queri' quibij, ni majun quigana ruq'uin ja Jesús, xa pokon nquena' rmal ja nbij. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ja c'a Jesús arja' xbij chique: —Ni majun profeta xin Dios ja maquita lok' nna'i xarwari' ma lok' ta nna'i cumal ja rach aj tinamit nixtac'a cumal ta ja rch'alal in nixtac'a cumal ta ja rec'o pa rochoch chakaja', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","In ma xcowin ta xuban ta nimak tak milagro tri' xarwari' ec'o jujun ja yawa'i' xuya' ruk'a' pa quewi' in xertzursaj can. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Arja' kas junwi' xuna' rumac ja mta yukulbal quec'u'x ja winak ruq'uin. C'ac'ari' xelel, be pa tak aldea ja c'o chinakaj in xumaj quitijoxic ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ja c'a Jesús arja' xersiq'uij ja cablajuj discípulo in xuya' chique chi c'o quek'a' chique ja ritzel tak espíritu chi necowini nequiwasajel chique ja winak. Pa caca' xerutakel in bien xuch'obel chiquewach nak ja xtequibana': ");
INSERT INTO tzjNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","—Ni majun nak ta nec'amel ja tok xquixbe chipan ja viaje xarwari' xa ruyon ech'ame'y nec'amel. Mta emaleta nec'amel nixtac'a way, nixtac'a pwok ta chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","In xa perpak tak xajab necojel in ni xa ja wari' ecamisa nec'amel ja recojon, ma ca'i' ta. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Xa nak ta chi jayil nixoc wi' tri' nixq'ueje' wi', c'a tokori' neya' can ja tok nixbe chic cha jun chic tinamit. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","In xa nak ta ja maquec'ulu ewxin, xa nak ta ja mta quigana nquic'axaj ja nebij chique, ja c'a tok nixelto chipan ja quitinamit tequiraj can ja pokok ja c'o pan ewakan. Queri' neban jari' retal chi eje'e' nquetij na rpokonal rmal ja matiqueya' quixquin tre ja nebij chique. Ni katzij wi' ja nbij chewe ri', ja tok xterila' ja nimlaj k'ij xin juicio janila jun nimlaj rpokonal xtiquetij na ja tinamit ja maquec'ulu ewxin. Más na lawulo' ja rpokonal xtiquetij chwach ja xtiquetij ja ritzel tak winak ja raj Sodoma in ja raj Gomorra ojer. Queri' xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ja c'a cablajuj discípulo eje'e' xe'elel, xebe cuq'uin ja winak in quewa' nquibij chique ri': —Teq'uexa' ja rena'oj in teya'a' can ja ritzelal, neche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","E q'uiy ja ritzel tak espíritu xequiwasaj chique winak in e q'uiy ja yawa'i' quecoj aceite pa quewi', xequitzursaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ja Jesús nojel ja ntajini nuban xekaj rbixic ruq'uin ja rey rbina'an Herodes como benak nat nakaj ja rtzijoxic. Ja c'a Herodes quewa' xbij ri': —Ja rachi ja maxco' ntajini nuban arja' Juan Bautista c'astajnakto chiquicojol camnaki' chewi' c'a tok ocnak tre ja nimak tak poder ja ntajini nsamaj ruq'uin camic, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pro ec'o chic jule' quewa' quibij ri': —Ja rachi arja' Elías, xeche'e. In ec'o chic jule' quewa' quibij ri': —Ja rachi arja' jun profeta, queri' rbanic ja cani' quibanic ja rojer tak profeta, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pro ja Herodes tok xc'axaj ja nquibij ja winak arja' quewa' xbij chic ri': —Mni, ma queri' ta. Ja rachi arja' Juan ja xinya' orden chi lasax rwi', arja' c'ari' ja c'astaj chiquicojol camnaki', ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Queri' xbij como bien rotak chi arja' yowi ja orden chi camsaxi ja Juan Bautista tokori' tok xutak rchapic ja Juan, baq'ui in coj pa che'. Queri' xuban tre rumac ja bix tre rmal ja Juan Bautista chi: —Ma rubey ta abanon chi ac'amon ja rawixnam, ne'xi. Como ja Herodes arja' rc'amon ja rixnam rbina'an Herodías, rxjayil jun rch'alal rbina'an Felipe. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ja c'a Herodías arja' congana penak ryewal trij ja Juan, nrajo' ta ncamsaj pro maticowini ");
INSERT INTO tzjNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","como ja Herodes xa nxbej ri' chwach ja Juan como arja' rotak chi ja Juan utzlaj achi, jun achi xin Dios, in bien xuban cuenta utzc'a chi maticamsaxi. Ja Herodes tok nc'waxaj ja nbij ja Juan c'o je'e nc'waxaj ja matich'obtaj rmal, xa nxbej ri' rmal pro ni c'o wi' rgana nc'waxaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pro xerila' c'a jun k'ij tok cowini ja Herodías trij ja Juan chi ncamsaxi. Tokori' bantaji camíc ja tok Herodes xuban jun nmak'ij rxin rcumpleaños, xchomij jun nimlaj wa'im. Erbanon invitar ja winak ja nimak quek'ij ja nesamaj chipan ja rgobierno e cachbil ja jefe quixin soldado e cachbil chic ja principali' xin Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ja Herodes e rachbil ja rerbanon invitar ec'o pa mesa ja tok xekaj jun xtan chiquewach, ral ja Herodías, in xumaj xajoj ja xtan chiquewach. Ja c'a Herodes in ja rachbil congana xel quec'u'x trij. C'ac'ari' ja rey Herodes quewa' xbij tre ja xtan ri': —Tac'utuj chwe xa nak ta ja nawajo', can nya' chawe, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","In xuban jurar, xbij tre ja xtan: —Xa nak ta xtac'utuj chwe can nya' chawe masqui nic'aj tre ja gobierno xtac'utuj ja c'o pa nuk'a' can nya' chawe, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ja c'a xtan xelto, be ruq'uin ja rute', xerbij tre nojel ja bix tre rmal ja Herodes: —Camic ¿nak c'a nc'utuj tre ja rey nach'ob atat? ne' tre ja rute'. —Tabij tre chi nuya' rwi' ja Juan Bautista chawe, ne'xi rmal ja rute'. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chaka c'a maril bitaj queri' tre ja xtan congana nuban, be chic jutij ruq'uin ja rey in xbij tre: —Camic ja nc'utuj chawe pro ni chanim ri', ja rwi' ja Juan Bautista taya'a' chwe pa jun plato, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pro ja c'a rey Herodes congana junwi' xuna' pro como rbanon chic jurar chiquewach ja rec'o ruq'uin pa mesa chewi' tok ma xrajo' ta maquita nuya' tre ja xtan ja xtzujuj. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ja rey alnak xuya' orden tre jun soldado chi nbe, nerlasaj rwi' ja Juan Bautista in nuc'amto. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","C'ac'ari' be ja soldado ruq'uin ja Juan ja bar c'o wi' pa che' in xlasaj rwi'. Ja tok lastajto rmal xuc'amto pa jun plato, xujach tre ja xtan in ja xtan xujach tre ja rute'. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ja c'a rdiscípulo ja Juan tok quic'axaj chi camsaxi eje'e' xebe, xequic'ama' ja rcuerpo in xequimuku'. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Xemelojto ja cablajuj apóstol, xurquimolo' qui' ruq'uin ja Jesús, quechol chwach nojel ja xequibana' in nojel ja tijonem ja queya' chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ja c'a Jesús arja' xbij chique: —Jo', kayonaj ki' chipan jun lugar ja bar kas talan wi' chi tri' nixexula'n wi' jalal, ne' chique. Queri' xbij chique como congana chi winak nquijalala' qui' cuq'uin nixtac'a c'o ta tiempo chique xquewa' ta cumal. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","C'ac'ari' xe'oquel pa jun lancha, xequiyonaj qui' chipan ja lugar kas talani ja bar ma ec'o ta wi' winak. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pro ja tok xebe e q'uiy ja winak xetz'ato'el quixin, bien ch'obtaj cumal chi Jesús ja be. Xe'elel ja winak pa tak quitinamit pro nojel tinamit, xebe chi cakan c'amc'ol canim, eje'e' xe'ekaji nabey ja bar xque'ekaj wi' ja Jesús in tri' quemol wi' qui' chi rc'ulic. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ja c'a Jesús tok xelto chipan ja lancha xerutz'at ja winak chi congana e q'uiy. Arja' xpokonaj quewach como eje'e' e cani' jule' tak carnelo ja mta nyuk'un quixin. C'ac'ari' xumaj quitijoxic, q'uiy rwach ja tijonem xuya' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ja c'a tok xuban hora xepeti ja discípulo in quewa' quibij tre ri': —Ja lugar ja rokc'o wi' ri' congana talani in xuban hora, ");
INSERT INTO tzjNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","mejor ja naban, que'ataka'el ja winak pa tak tinamit in pa tak aldea ja c'o chikanakaj in tabij chique chi tri' nequilok'o' wi' ja nquetij, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Ixix nixyo' chique ja nquetij, xeche'x rmal ja Jesús. —Xtikalok' ta ca'i' ciento quetzal caxlanway ¿la neruban ta c'ala' winak le' chi nquetij? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—Jetz'ata' nac'a jaru' rkan caxlanway ja rec'amonto, xeche'x chic rmal ja Jesús. Ja c'a tok quetz'at quewa' quibij tre ri': —Jo'o' rkan ja caxlanway in e ca'i' cakan ch'u', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","C'ac'ari' ja Jesús xbij chique: —C'o rax tak k'ayis le', tebij chique canojel ja winak chi quetz'abe'e parwi' pro pa tak moc ncuc'aj qui', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ja c'a winak xekaji chi tz'ubulem, pa tak moc cuc'aj qui'. Ec'oli jujun ciento cuc'aj qui' in ec'oli pa tak cincuenta cuc'aj qui'. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ja c'a Jesús xuc'am ja jo'o' rkan caxlanway e rachbil ja ca'i' cakan ch'u', ca'y chicaj in xmaltioxij tre ja Dios. Xuwech' ja caxlanway, xujach chique ja rdiscípulo chi eje'e' nqueya' chic chique ja winak. In queri' xuban chique ja ca'i' cakan ch'u' chakaja', xerujach chiquewach canojel ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Xewa'i pro ni canojelal in xenoji chi utz. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ja c'a caxlanway rachbil ch'u' mol ruchi' ja totaji, cablajuj chacach xuban. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ja xewa'i e jo'o' mil pro xa queyon achi'i'. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","C'ac'ari' ja Jesús xbij chique ja rdiscípulo: —Puersa nixoquel chipan ja lancha, nixbe chajuparaj ya' chipan ja tinamit Betsaida, ne' chique, in xeruban can despedir ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ja tok xebantaj can despedir rmal, arja' jote' chwach jayu', xuwil jun lugar ja bar nuban wi' oración. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ja tok xoc ak'a' xa ruyon c'o tri', ja c'a lancha kas pa nc'aj ya' c'o chi wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Arja' xerutz'at pon chi congana etujkarnak chic tre ja si'oj como c'o jun nimlaj ik' jaktajnakto chiquij. Ja c'a pa rsakaric rmajon binem parwi' ya' ja Jesús, xekaj chinakaj ja lancha. Arja' laj k'ax chiquewach ja rdiscípulo ");
INSERT INTO tzjNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","pro tok quetz'at chi rmajon binem parwi' ya', ja nquech'ob eje'e' chi jun xbinel ja netajini nquetz'at in congana quemaj rakic quechi' rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Como canojel quetz'at in congana quixbej qui' rmal. Ja c'a Jesús xbij chique: —Ma ticapuj ta ec'u'x, xwa'n anin, ma texbej ta ewi', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","C'ac'ari' xoc cuq'uin pa lancha in cami ja ik'. Ja c'a discípulo eje'e' congana c'asc'o'i quetz'at ja xuban ja Jesús chiquewach in sach quina'oj rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Queri' queban como eje'e' ma xch'obtaj ta cumal ja poder ja c'o ruq'uin ja Jesús masqui quitz'aton chic ja nimlaj milagro xuban tre ja caxlanway tok xerutzuk ja jo'o' mil achi'i'. Congana c'ayew chique chi nquech'ob nak rbanic ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Xe'elel, xe'ekaj chajuparaj ya', pa jun lugar rbina'an Genesaret xe'ekaj wi' chiya'. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Chaka c'a maril xe'elto ja pa lancha, ja winak chanim queya' cuenta tre chi Jesús ja xekaj cuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","C'ac'ari' xebe cuq'uin canojel ja winak ja rec'o chipan ari' lugar in majtajto quic'amaric ja yawa'i' ruq'uin ja Jesús. Xa nak ta lugar nekaj wi' ja Jesús, ja winak tok nquic'axaj, tri' nequemel wi' ja yawa'i', nequitelejel rachbil tak quiwarbal. ");
INSERT INTO tzjNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Xa bar ta tri' nekaj wi' ja Jesús, wi pa nimak tak tinamit, wi pa co'cojlaj tak tinamit owi pa tak aldea, ja winak ja rec'o yawa'i' cuq'uin eje'e' xequilasajto, xequeya'to chi tak bey ja bar nk'ax wi' ja Jesús in quewa' quibij tre ri': —Tabana' jun utzil chake, taya'a' jutz'it lugar chique ja yawa'i' chi nquechapoc jutz'it ja ratziak, mana xa jutz'it ruchi' ja nquechapoc, xeche' tre. In queri' queban, canojel ja xechapowi ja rtziak xetzuri. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ec'o c'a jule' fariseo xequimolo' qui' ruq'uin ja Jesús e cachbil jule' maestro ja netijon quixin ja winak tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés, eje'e' epenak pa Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Eje'e' queya' cuenta chique ja rdiscípulo ja Jesús chi ec'oli chique ja tok quemaj wa'im ma xqueban ta ja cani' nrajo' ja costumbre tre ja ch'ajoj k'abaj pro ja tok quech'aj quek'a' ma costumbre ta ja queban. Rmalc'ari' tok ja fariseo e cachbil ja maestro eje'e' quemaj quitzijoxic ja discípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Como ja fariseo in canojel ja cach tak aj Israel eje'e' ni maquewa' wi' ja wi ma congana ta nqueban tre ja ch'ajoj k'abaj, jari' costumbre ja c'utun can chiquewach cumal ja cati't quimama'. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","In tok nemelojto ja pa tak c'aybal ni maquewa' wi' chakaja' ja wi matiqueban ja costumbre ja nquich'ach'ojirsbej qui'. In c'a c'o na más ja costumbre quiniman je'e, nqueban costumbre tre ja ch'ajoj tak vaso in tre ch'ajoj tak xaro in tre ch'ajoj tak tzacbal nakun je'e ja ch'ich' ocnak in tre ch'at chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ja c'a fariseo e cachbil ja maestro quic'axaj tre ja Jesús: —¿Nak c'a tre ja radiscípulo taka'an matiquinimaj ja costumbre quixin ja kati't kamama'? Newa' taka'an pro matiqueban ja costumbre tre ja ch'ajoj k'abaj, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Bix chique rmal ja Jesús: —Caca' epalaj, bien ntake' chewe ja binto chewe ojer rmal ja profeta Isaías in tz'ibtal can quewari': —Jawa' winak ri' xa chi quechi' c'o wi' ja tok nqueya' nuk'ij, ja canma c'a c'a nat c'o wi' chwe. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ni majun noc wi' ja tok nqueya' nuk'ij, ja tijonem ja nqueya' rtzobal Dios neche' tre, pro xa mandamiento quixin winak. Queri' ja binto chewe rmal ja rIsaías. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ja rebanon, eya'on can ja mandamiento xin Dios pro ja costumbre quixin winak jari' emajon rnimaxic cani' tre ja costumbre tre ja ch'ajoj tak xaro, ch'ajoj tak vaso in jule' chic costumbre ja junan ruq'uin ja wari', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","In xbij chic chique: —Ixix congana ix listo chi rq'uexic ja mandamiento xin Dios utzc'a chi ja recostumbre ixix necoj pa rq'uexwach. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Como ja Moisés arja' c'o jun mandamiento xin Dios ja rtz'iban can quewa' nbij ri': —Lok' que'ana'a' ja ratata' ate', ne'e. In jun chic ja rtz'iban can quewa' nbij ri': —Ja wi c'o jun xa itzel ntzijon tre ja rtata' owi rute' jari' puersa ncamsaxi, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Pro ja rixix xa ma lok' ta ne'ena' como quewa' ja tijonem neya' ri': —Ja wi nabij tre atata' owi ate': —Camic maquincowini natnuto' tre ja c'o rjawaxic chawe como nbin chic tre ja Dios chi rxin chic arja' ja c'o wq'uin, wi natche' tre, jari' ma rjawaxic chi ta chi nato' tre ja c'o rjawaxic tre, nixche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Queri' ebanon, ja mandamiento xin Dios, ixix ebanon tre ni mta pro xa rumac ja recostumbre in jari' costumbre nec'ut chiquewach jule' chic winak chi nquinimaj eje'e' chakaja'. In q'uiy rwach ja neban ja junan ruq'uin ja wari'. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ja c'a Jesús arja' xumaj chic tzij cuq'uin ja winak, quewa' xbij chique ri': —Tec'waxaj ewanojelal ja xtinbij chewe ri', kas ta xtich'obtaj emwal. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ma ja ta ja noc pan achi' ja ntz'ilorsani ja rawanma pro ja ntz'ilorsan rxin jari' ja nwinakar pan awanma in nelto pan achi'. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Bien c'a tewasaj ena'oj trij ja c'a xinbij kaj chewe ri', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","C'ac'ari' xeruban can despedir ja winak in xoc pa jay. Ja c'a rdiscípulo quic'axaj tre nak rbanic ja c'ambal tzij ja xbij. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","In quewa' xbij chique ri': —Taka'an matich'obtaj emwal ixix chakaja'. ¿La matich'obtaj c'a emwal chi ja noc pan achi' jari' mta moda xtitz'ilorsaj ta ja rawanma? ");
INSERT INTO tzjNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Queri' nbij chewe como ja noc pan achi' jari' nkaj chi apan in nelel chic jutij, ne' chique. Ja xbij ja Jesús chi matitz'ilori ja rawanma xta rmal ja nati' xa nak ta ja nati' je'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","In xbij chic jutij chique: —Ja ritzelal ja nelto pan awanma jari' ntz'ilorsan rxin ja rawanma. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Queri' nbij chewe como pan awanma nwinakarto wi' ja ritzel tak na'oj cani' tre tok c'o jun natoc ruq'uin ja wi ma awixjayil ta owi ma awachajil ta, cani' tre banoj camíc, ");
INSERT INTO tzjNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","cani' tre banoj alak', cani' tre tok chaka benak chi nayarij quinakun winak, cani' tre banoj itzelal in banoj engaño, cani' tre banoj nakun ja congana chuw chwach ja Dios, cani' tre aquiakarem, ne'atzijoj winak, naya' ak'ij in banoj nakun ja xa ma ch'obol ta. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nojel c'awa' wari' pa tak canma ja winak nalaxto wi' in jari' ntz'ilorsan rxin ja canma. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","C'ac'ari' yictajel, xelel chipan ja lugar in be cha jun lugar chic ja bar c'o wi' ja ca'i' tinamit, jun rbina'an Tiro in jun rbina'an Sidón. Ja c'a tok xekaji xoc chipan jun jay, arja' matirajo' chi notakixi chi tri' c'o wi' pro ja winak puersa cotakij chi c'o tri'. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","C'o c'a jun ixok ma aj Israel ta, arja' alaxnak chipan ja lugar rbina'an Sirofenicia, c'o jun ti ral ti xtan ocnak jun itzel espíritu tre. Ja rixok tok xc'axaj ja bar c'o wi' ja Jesús be ruq'uin. Ja c'a tok xekaj ruq'uin xuque' chwach in congana xuban recomendar tre chi nbe ruq'uin chi nerlasaj ja ritzel espíritu tre ja ti ral. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ja c'a Jesús xc'ambej tzij chwach ja rixok, quewa' xbij tre ri': —Nenuto' na nabey ja wach tak aj Israel como ma rubey ta xtic'am ta queway ja ralc'walaxela' in xtiq'uiakel ta chiquewach tak tz'i', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ja c'a rixok chakaja' xc'ambej tzij chwach ja Jesús, quewa' xbij tre ri': —Wajaw, ni katzij wi' ja nabij le' pro ja tak tz'i' ja neq'ueje' xe' mesa, eje'e' nya̱' lugar chique chi nquetij ja rc'utal tak queway ja ralc'walaxela' ja ntzakel xe' mesa, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Bix tre rmal ja Jesús: —Congana buena xabij chwe le' rmalc'ari' nbij chawe, jat, catmeloj chi awochoch, camic xeli ja ritzel espíritu tre ja rawal, ne'xi ja rixok. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","C'ac'ari' meloji ja rixok chi rochoch. Ja tok xekaj ruq'uin ja ral cotz'ol chwa ch'at, mchita ja ritzel espíritu tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","C'ac'ari' be ja Jesús, xelel chipan ja lugar je'e ja c'o pa rcuenta Tiro, k'axi pa tak lugar ja c'o pa rcuenta Sidón in k'axi chakaja' pa tak lugar ja c'o pa rcuenta Decápolis, xekaji c'a chuchi' ja ya' rbina'an Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","C'o c'a jun achi xeya̱' chwach, arja' tacon in ma kas ta ncowini ntzijoni chakaja'. Ja rec'amyonel rxin quic'utuj jun utzil tre ja Jesús chi nuya' ruk'a' pa rwi' ja rachi chi ntzursaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ja c'a Jesús arja' xlasajel ja rachi chiquicojol ja winak, quiyonaj qui' ruq'uin. C'ac'ari' xuya'oc rwi' ruk'a' pa tak rxquin ja rachi, chubani in xuchap rak' ja rachi chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","C'ac'ari' ca'y chicaj, congana njik'joti in quewa' xbij tre ri': —Efata, ne' tre. Ja pa rtzobal ja rachi efata tibij tzij tijaktaji ja rawxquin, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ja tok bitaji ja queri' rmal ni jaktaji rxquin ja rachi in tzuri ja rak' in ncowini ntzijon chic. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ja c'a Jesús arja' xbij chique ja winak chi majun bar ta tri' nquibij wi' ja xuban tre ja rachi. Pro ja winak ma xquinimaj ta tzij, masqui congana xek'ili rmal ja Jesús chi matiquilasaj rbixic pro eje'e' más chi na quilasaj rbixic. ");
INSERT INTO tzjNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Eje'e' congana c'asc'o'i quetz'at ja milagro ja xuban ja Jesús chiquewach in quewa' nquibij ri': —Ja Jesús congana buena nojelal ja rbanon. Nuya' taka'an quixquin ja tacona' in nuya' taka'an quechi' ja mema' chakaja', neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jari' tiempo congana e q'uiy ja winak quimolon qui' ruq'uin ja Jesús in mta queway quic'amonto. Ja c'a Jesús arja' xersiq'uij pon ja rdiscípulo in quewa' xbij chique ri': ");
INSERT INTO tzjNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Congana npokonaj quewach ja winak, tuban oxi' k'ij queq'ueje' wq'uin in mchita nak chi ta ja nquetij. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ja wi xquenutakel chi tak cochoch, wi mta way xtiquetijel jari' wotak chi netujkar pa bey. Ec'oli chique congana nat epenak wi', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ja c'a rdiscípulo eje'e' quibij tre: —Jawa' lugar ja rokc'o wi' ri' congana talani ¿bar c'a nekac'ama' wi' ja xtiquetij ja winak le'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Jaru' rkan ja caxlanway c'ol ewq'uin? xeche'x rmal ja Jesús. —Wuku' rkan, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ja c'a Jesús xbij chique ja winak chi netz'abe' kaj pa tok'ulew. C'ac'ari' xuc'am ja wuku' rkan caxlanway, xmaltioxij tre ja Dios, xuwech' in xujach chique ja rdiscípulo chi eje'e' nqueya' chic chique ja winak in queri' queban queya' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","In chakaja' ec'o jun ca'i' cakan ch'u' e takno'y. Ja c'a Jesús xermaltioxij tre ja Dios in xuya' orden chi neya'i ja ch'u' chique ja winak chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Xewa'i ja winak in xenoji chi utz. Ja c'a caxlanway rachbil ch'u' mol ruchi' ja totaji, wuku' chacach xuban. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ja xewa'i ec'o la quiji' mil. C'ac'ari' ja Jesús xeruban can despedir, ");
INSERT INTO tzjNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","xoquel ja pa lancha e rachbil ja rdiscípulo, xebe pa tak lugar ja c'o pa rcuenta Dalmanuta. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ja tok xe'ekaji ec'o jule' fariseo xe'ekaj ruq'uin ja Jesús. Eje'e' quemaj tzij ruq'uin pro xa ch'a'onem nqueban tre. C'oli quic'axaj tre pro xa nquic'ambajbej rxin quewari': —Tabana' jun milagro ja nc'utu chikawach chi Dios yoyon chawe ja poder ja c'o pan ak'a', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ja c'a Jesús tok xc'axaj ja bix tre, arja' congana bison cumal in quewa' xbij chique ri': —¿Nak tre tok ixix ja rixc'o chipan awa' tiempo ri' nec'utuj jun milagro chwe ja xa nec'ambajbej wxin? Ni katzij wi' ja xtinbij chewe ri', ja rixix ja rixc'o chipan awa' tiempo ri' mta jun milagro xtinban ta chewach ja cani' nec'utuj chwe, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ja c'a tok bitaji ja queri' rmal, ja Jesús xeruya' can, xe'oquel chic jutij chipan ja lancha, xebe chic chajuparaj ya'. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ec'o chic pa lancha ebenak. Ja c'a rdiscípulo ja Jesús eje'e' mta queway quic'amonto, quimestaj can, xa jun rkan ja caxlanway ja cuc'an. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ja c'a Jesús quewa' xbij chique ri': —Kas bien tech'obo', kas bien tebana' cuenta ewi' chwach ja levadura quixin ja fariseo in chwach chakaja' ja levadura rxin ja Herodes, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ja c'a rdiscípulo eje'e' quemaj tzij chibil tak qui', quewa' nquibij ri': —Queri' nbij chake rumac ja mta way kac'ampi ta, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ja c'a Jesús arja' bien rotak chi ja nquech'ob eje'e' chi levadura xin caxlanway ja nnatax chique rmal pro ja nnatax chique jari' ja tijonem quixin ja fariseo in rxin ja Herodes, quewa' xbij chique ri': —¿Nak tre tok nebij: —Taka'an mta way kac'ampi ta, kas nixche'e? ¿Maja'n ek tich'obtaj emwal? ¿Maja'n taka'an tikaj pan ewi' nak rbanic? ¿La congana c'ayew chi nech'ob nak rbanic? ");
INSERT INTO tzjNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","C'o panewach pro ¿la matetz'at ja nc'u̱t chewach? In chakaja' c'ol ewxquin pro ¿la matoc pan ewxquin ja nbix chewe? In chakaja' ¿la maturkaj chewe ");
INSERT INTO tzjNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ja tok xinwech' ja jo'o' rkan caxlanway in xenutzuk jo'o' mil winak tre? ¿Jaru' chacach ja totaji ja xemol ruchi'? ne' chique. —Cablajuj chacach, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ja c'a Jesús xbij chic chique: —In tok xenutzuk chic ja quiji' mil winak tre ja wuku' rkan caxlanway ¿jaru' chacach ja totaji ja xemol ruchi'? ne' chique. —Wuku' chacach, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—Pro ¿nak c'a tre tok maja'n tich'obtaj emwal nak rbanic? xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ja tok xe'ekaji chajuparaj ya' pa jun tinamit rbina'an Betsaida xe'ekaj wi'. C'o c'a jun achi moy xeya̱' chwach ja Jesús. Ja rec'amyonel rxin ja moy eje'e' congana quic'utuj tre ja Jesús chi nuchap ja moy chi ntzursaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","C'ac'ari' ja Jesús xuchap ja moy chi ruk'a', xyukejel, xlasajel chipan ja tinamit. Ja c'a tok lastajel rmal chipan ja tinamit xuya' ruchub chi tak rwach, xuya' ruk'a' trij tak rwach in quewa' xbij tre ri': —¿La nca'y chic jutz'it ja rawach? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ja c'a rachi xumaj ca'yem in xbij tre ja Jesús: —Ec'o jule' achi'i' nenutz'at pro ja nenutz'at pon le' xa e cani' jule' che', quimajon binem, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","C'ac'ari' ja Jesús xuya' chic jutij ja ruk'a' trij rwach ja rachi. Ja c'a rachi xumaj rtz'elwachixic ja nutz'at in tzuri ja rwach, utz chic nutz'at nojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ja c'a Jesús xbij tre: —Jat chi awochoch pro maxta catoc chipan ja tinamit nixtac'a c'o ta jun ja c'o chipan ja tinamit xtabij wi' ja xinban chawe, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","C'ac'ari' ja Jesús e rachbil ja rdiscípulo xebe pa tak aldea ja c'o chinakaj ja tinamit Cesarea ja c'o pa rcuenta Filipo, kas c'a quimajon bey ja tok quewa' xc'axaj chique ri': —Anin ¿nak inocnak wi' ja nquibij chwe ja winak? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","—Ec'oli nebin chawe chi atat at Juan Bautista, jule' chic nebini chi at Elías in ec'o chic jule' ja nebini chi at jun chic chique ja rojer tak profeta, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Ja c'a rixix ¿nak nebij chwe, nak inocnak wi'? ne'e ja Jesús chique. Peti ja Pedro, xbij tre: —Ja ratat at Cristo ja ratcha'on rmal ja Dios, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ja c'a Jesús congana xuban recomendar chique chi ni majun bar ta tri' nquibij wi' chi arja' ja Cristo. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","C'ac'ari' xumaj rk'alasaxic chiquewach ja rdiscípulo nak xtiban na tre, quewa' xbij chique ri': —Anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak q'uiy rwach ja rpokonal ntij na, xa itzel ninquetz'at na ja principali' xin tinamit e cachbil ja jefe quixin sacerdote e cachbil chakaja' ja maestro ja netijon quixin ja winak tre ja ley xin Dios, nincamsax na in chi rox k'ij ninc'astaj na, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Arja' bien xuch'ob chiquewach chi nba̱n na queri' tre. Ja c'a Pedro arja' xuchap chi ruk'a' in xumaj rch'a'ic tre ja xbij. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pro ja c'a Jesús tok xc'axaj ja bix tre rmal ja Pedro arja' xuya' vuelta, xertz'elwachij pon ja rdiscípulo in xumaj rch'a'ic tre ja Pedro ja xbij: —Catel chinwach Satanás. Queri' nbij chawe como ma queri' ta nawajo' chwe chi nban ja cani' nrajo' chwe ja Dios chi nban, xa junan ana'oj cuq'uin winak, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","C'ac'ari' ja Jesús xersiq'uij pon ja rdiscípulo e cachbil ja jule' chic winak ja rec'o tri', quewa' xbij chique ri': —Xa nak ta ja c'o rgana nyuke' ruc'u'x wq'uin rjawaxic chi matuya' rgana ja tzabuklaj c'aslemal rc'an. Rjawaxic chakaja' chi matipokonaj nutij ja rpokonal mwal in ntre'el chwij. Jari' cani' jun cruz nya̱' trij pro matipokonaj nuc'am ja cruz, nrijkajel in nbe ja bar necamsax wi'. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Queri' nbij chewe como xa nak ta ja npokonaj nuya' can ja rc'aslemal jari' matuwil c'ari' ja utzlaj c'aslemal ja mta q'uisic trij. Pro xa nak ta ja matipokonaj nuya' can ja rc'aslemal mwal anin in rmal ja utzlaj tzij ja nc'amonto jari' can nuwil ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Como cani' tre jun winak ¿nak c'a nuch'ec trij wi xuch'ec nojel ja meba'il rxin ja rwach'ulew pro wi ma xuwil ta ja utzlaj c'aslemal ja mta q'uisic trij? ");
INSERT INTO tzjNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ja wi xutzak ja utzlaj c'aslemal ja mta q'uisic trij jari' mta jun meba'il ja xtilok'bej ta. ");
INSERT INTO tzjNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Queri' nbij chewe como ja winak ja rec'o chipan awa' tiempo ri' xa nak ta chi winakil wi xa q'uixbal nquena' nquecoj qui' wq'uin in wi xa q'uixbal nquena' rmal ja ntzobal, anin chakaja' q'uixbal nna' chi xquenucoj ta pa ncuenta. Anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak xa q'uixbal nna' chi xquenucoj ta pan ncuenta tokori' tok xquinpi chic jutij e wachbil ja ángel xin Dios ja tok congana nch'a'an chic chwij ja gloria xin Dios. Ja winak ja rec'o chipan awa' tiempo ri' eje'e' xa quiya'on can ja Dios in junwi' chi na yukul wi' quec'u'x, congana il mac ja netajini nqueban, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","In xbij chic chique: —Ni katzij wi' ja xtinbij chewe ri', ec'oli chewe ja rec'o wawe' camic ri' c'a ec'as na ja tok xtiquetz'at ja gobierno xin Dios chi npeti in congana poder rc'an, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ja c'a chi waki' k'ij ja Jesús xeruc'amel ja Pedro e rachbil ja Jacobo in Juan, xebe, xequiyonaj qui' parwi' jun nimlaj jayu'. Ja c'a rachbal ja Jesús xuq'uex ri' chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ja rtziak congana nc'ac'ot chic, congana sak sak, ni majun ch'ajol tziak wawe' chwach'ulew xticowin ta xtuban ta sak tre ja cani' xeli rtziak ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chaka jalal tok winakar chiquewach ja rElías rachbil ja Moisés, quimajon tzij ruq'uin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ja c'a Pedro arja' xbij tre ja Jesús: —Maestro, congana qui'il ja rokc'o wi' ri'. Kabana' oxi' tak jay wawe', jun awxin atat, jun rxin Moisés in jun rxin Elías, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ja Pedro como xa matich'obtaj rmal chewi' tok queri' xbij como arja' in ja re rachbil congana quixben qui'. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chaka jalal tok c'o jule' sutz' xermujaj in c'o jun kulaj tzijonto chipan, quewa' xbij chique ri': —Jawa' wari' jawa' chak'laj Walc'wal, teya'a' ewxquin tre nak ja nbij arja' chewe, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chaka maril tzuri tzij rmal ja kulaj, ja rapóstol tok quetz'at mchita ja rElías mchita ja Moisés, xa ruyon ja Jesús c'o can chic. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","C'ac'ari' xebe, kas exulanto parwi' ja jayu' ja tok bix chique rmal ja Jesús: —Ni majun bar ta tri' xtebij wi' ja xetz'at, c'a tokori' xtebij ja tok c'astajnak chic chiquicojol camnaki' ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","In queri' queban, xa pa tak canma q'ueje' wi', majun bar ta tri' quibij wi'. Pro eje'e' quemaj rc'axaxic chibil tak qui' ja bix chique: —¿Nak rbanic c'ari' ja xbij tre ja Ralc'walaxel chi nc'astaji chiquicojol camnaki'? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","C'ac'ari' quic'axaj tre ja Jesús: —¿Nak c'a tre ja maestro xin ley eje'e' nquibij chi ja rElías rjawaxic chi arja' npi na nabey chwach ja Cristo? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","—Ni katzij wi' nquibij chi ja' Elías npeti nabey chi nurchomarsaj nojelal. In camic c'oli nc'waxaj anin chewe, ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak ¿nak tre tok tz'ibtal can tre chi q'uiy rwach ja rpokonal nutij na in xa itzel ntz'a̱t na cumal ja winak? ");
INSERT INTO tzjNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pro anin nbij chewe chi ja rElías arja' penak chic pro eje'e' xa queban tre nak c'o quigana queban tre. Ni queri' bantaji ja cani' tz'ibtal can chipan ja rtzobal Dios chi nbantaj na, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ja c'a tok xekajto ja bar ec'o can wi' ja jule' chic discípulo congana chi winak xequetz'at, quimolon qui' chiquij ja discípulo. Ec'o jule' maestro xequetz'at chakaja' quimajon tzij cuq'uin ja discípulo pro xa ch'a'onem nqueban chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ja c'a winak ja tok chaka maril quetz'at pon chi peti ja Jesús congana c'asc'o'i quetz'at in c'amc'ol canim xebe, xequic'ulu' in queban saludar. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ja c'a Jesús xc'axaj chique: —¿Nak ja remajon rtzijoxic cuq'uin? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","C'o c'a jun achi chiquicojol ja winak quewa' xbij tre ja Jesús ri': —Maestro, anin c'o jun nc'ajol nc'amonto chi nunya'a' chawach, arja' ocnak jun itzel espíritu tre in rmalari' ocnak mem. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Xa nak ta lugar c'o wi' ja nc'ajol, arja' nch'akix pa tok'ulew rmal ja ritzel espíritu. Nel rpuluw ruchi' in congana ncach'ach' rey pa ruchi' rmal. Camic lawulo' chic, majun chic rpuersa. In xinc'utuj jun utzil chique ja radiscípulo chi nquiwasaj ja ritzel espíritu pro eje'e' ma xecowin ta quiwasaj ta, ne'e ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ja c'a Jesús tok c'axtaj rmal ja bix tre rmal ja rachi quewa' xbij ri': —Ixix ja rix aj Israel ni taka'an mta wi' ja yukulbal ec'u'x wq'uin. Taq'ue titzuri ja nsamaj checojol, c'ayew chwe chi ncoch' más ja matiyuke' ec'u'x wq'uin. Camic tec'ama'to ja rala' wq'uin, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","C'ac'ari' c'amarel ja rala' chwach ja Jesús. Ja c'a ritzel espíritu chaka maril tok xutz'at ja Jesús xuya' chic jun ataque tre ja rala' in xch'akij pa tok'ulew. Ja c'a rala' congana xumaj rjukic ri' pa tok'ulew in nel rpuluw ruchi'. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ja c'a Jesús xc'axaj tre ja rtata' ja rala': —¿Nak tiempo ocnak tre ja ritzel espíritu? ne' tre. —C'a tino'y na ja tok ocnakto tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Q'uiylaj mul ja ritzel espíritu rbanon tre ja nc'ajol rminon pa k'ak' in rminon pa ya' chakaja', nrajo' ncamsaj. Atat, wi natcowini nato' ja ti nc'ajol tapokonaj jutz'it kawach, ko'ato'o' paki, ne'e ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—Jari' awq'uin atat c'o wi' xarwari' ja wi natcowini nyuke' ac'u'x wq'uin. Ja c'a wi c'oli ja yukulbal ac'u'x wq'uin jari' nojel nincowini nban xa nak ta ja nawajo' chwe chi nban, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ja c'a tatixel chaka maril tok bitaji tzij tre rmal ja Jesús arja' xumaj jun nimlaj ok'ej in quewa' xbij tre ja Jesús ri': —Anin yukul nuc'u'x awq'uin pro ja yukulbal nuc'u'x xa ma nim ta, quinato'o' paki utzc'a chi nq'uiy más, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ja c'a Jesús chaka maril tok xerutz'at ja winak chi e q'uiy xepeti chi nurquimolo' qui' ruq'uin, arja' xch'olij ja ritzel espíritu, quewa' xbij tre ri': —Itzel espíritu, xa atbanol mem xa atbanol tacon chique winak, camic anin natnuban mandar, jat, cateli, taya'a' can ja rala' in majutij xcatoc chi ta jutij chipan ja ranma, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ja c'a ritzel espíritu tok xc'axaj ja bix tre xurak ruchi' in xuya' chic jutij ataque tre ja rala'. C'ac'ari' xelel pa ranma pro ja rala' pune' can cani' cami ntz'ati. Ja c'a winak e q'uiy chique quibij chi cami ja rala', xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pro ja Jesús xuchap chi ruk'a' in xuyic. Queri' xuban pe'i ja rala'. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ja Jesús tok xoc pa jay ja c'a rdiscípulo eje'e' quiyonaj qui' ruq'uin in quewa' quibij tre ri': —¿Nak tre tok ajoj ma xokcowin ta kawasajel ja ritzel espíritu? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Ja ritzel tak espíritu ja re quitakala' jari' nc'atzin oración in nc'atzin ayuno chi nelasbexi, xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","C'ac'ari' ja Jesús xe'elel chipan ja lugar, xebe, xek'ax pa tak lugar ja c'o pa rcuenta Galilea. Ja c'a nrajo' ja Jesús chi mta nenabexi ja tok nek'ax pa tak lugar je'e ");
INSERT INTO tzjNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","como arja' rmajon quitijoxic ja rdiscípulo. Quewa' ja rmajon rbixic chique ri': —Ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak arja' nja̱ch na pa quek'a' ja winak, ncamsax na cumal pro ja tok xticamstaji nc'astaj na rwach chi rox k'ij, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pro ja reje'e' ma xch'obtaj ta cumal ja xbij chique in xa nquixbej qui' xtiquic'axaj ta tre nak rbanic. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ja c'a Jesús tok xe'ekaj chipan ja tinamit Capernaum in tok ec'o chic pa jay arja' xc'axaj chique: —Ja tok kamajon binem okpenak wawe' ¿nak ja remajon rch'a'ic chibil tak ewi'? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pro eje'e' ni majun nak ta quibij ta tre como ja quimajon rtzijoxic pa bey jari' nak ja más nim ruk'ij chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ja c'a Jesús tz'abe' kaj, xersiq'uij pon ja cablajuj apóstol in quewa' xbij chique ri': —Ja wi c'o jun chewe ja c'o rgana chi arja' noqui ja más nim ruk'ij, ja rjawaxic tre chi nuban, nuban tino'y in noc emoso ewanojel, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","C'ac'ari' xuc'am pon jun tac'al, xuya' chiquicojol, xch'elej in quewa' xbij chique ri': ");
INSERT INTO tzjNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ja tak ac'ala' ja re quitakawa' xa nak ta xtic'ulu jun chique in wi pa nubi' anin tok nuc'ul tibij c'a tzij ari' chi anin ja ninruc'ul. In xa nak ta xtic'ulu wxin jari' ma nuyon ta anin ja ninruc'ul, nata' Dios ari' ja nuc'ul chakaja' ja takyonpi wxin, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","In bix tre rmal ja Juan: —Maestro, c'o jun achi katz'at, arja' pan abi' atat rmajon quilasaxic ja ritzel tak espíritu chique ja winak pro arja' ma kachbil ta. Ajoj kabij tre chi maquerlasaj chic como ma kachbil ta, ne'xi ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","—Ma tek'il chi ta ja rachi como jun winak xa nak ta chi winakil wi nuban jun milagro pa nubi' anin jari' mta moda ja ni ta chanim itzel ta xtitzijon ta chwe. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","In chakaja' jun winak xa nak ta chi winakil wi ma itzel ta nokrutz'at jari' kachbil ari'. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","In jun chic, wi c'o na jun masqui xa jun vaso ti raxya' nsipaj chewe, wi rumac chi ix rachbil ja Cristo tok nsipaj chewe jari' ni katzij wi' nbij chewe, arja' mta moda ja maquita xtiyataji ja rtojbalil tre, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","In xbij chic chique: —Congana lawulo' chique xa nak ta ja xquetakchi'in quixin awa' ja re takno'y ri' ja yukul quec'u'x wq'uin, congana lawulo' chique masqui xa ti jun chique ja nquitakchi'ij chi rbanic ja il mac. Más na mejor nxi̱m jun ca' chi quekul chanim in neq'uia̱k pa ya' chwach ja nquitakchi'ij jun chique wa' ja yukul quec'u'x wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ja wi c'o jun ek'a' wi xa nixrtakchi'ij in nixrkajsaj chipan ja il mac mejor ja neban, tekupijel. Como más na utz ja xa jun ek'a' nixoc chipan ja utzlaj c'aslemal ja mta q'uisic trij chwach ja ca'i' ek'a' nixbe pa k'ak' pro jun k'ak' ja ni mta wi' chupic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tri' nquetij wi' rpokonal ja winak pro jun rpokonal ja ni mta wi' q'uisic trij in ja k'ak' ni mta wi' chupic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","In chakaja' wi c'o jun ewakan wi xa nixrtakchi'ij chi nixrkajsaj chipan ja il mac mejor ja neban, tekupijel. Como más na utz ja xa jun ewakan nixoc chipan ja utzlaj c'aslemal ja mta q'uisic trij chwach ja ca'i' ewakan nixbe pa k'ak' pro jun k'ak' ja ni mta wi' chupic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tri' nquetij wi' rpokonal ja winak pro jun rpokonal ja ni mta wi' q'uisic trij in ja k'ak' ni mta wi' chupic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","In jun chic, wi c'o jun panewach xa nixrtakchi'ij in nixrkajsaj chipan ja il mac mejor ja neban, tec'oto'el. Como más na utz ja xa jun panewach nixoc chipan ja gobierno xin Dios chwach ja ca'i' panewach nixbe pa k'ak'. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tri' nquetij wi' rpokonal ja winak pro jun rpokonal ja ni mta wi' q'uisic trij in ja k'ak' ni mta wi' chupic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Cani' nba̱n tre ja sacrificio je'e ja ntzujux chwach ja Dios ni c'o wi' atz'am nya̱' trij queri' c'a xtiban na chique canojel ja winak, ne'oc cani' jun sacrificio, cani' k'ak' nch'ach'ojirsbexi ja quic'aslemal. ");
INSERT INTO tzjNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ja ratz'am buena samaj nuban pro ja wi xtiyojtaji wi mchita rtzayil ¿nak c'a nchomarsbex chic rxin ari'? Cani' tre ja ratz'am nuban jun utzlaj samaj queri' ta c'a chewe ixix chakaja' teya'a' lugar tre ja Dios chi nsamaji pa tak ewanma utzc'a chi matiyojtaji ja rec'aslemal in maxta xa ch'a'oj teban chibil tak ewi'. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","C'ac'ari' ja Jesús xe'elel chipan ja lugar, xek'ax pa tak lugar ja c'o pa rcuenta Judea in xebe c'a chajuparaj chic ja binelya' rbina'an Jordán. Jutij chic congana e q'uiy ja winak xurquimolo' qui' ruq'uin in jutij chic chakaja' arja' xumaj quitijoxic como nijawari' ja rcostumbre. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ec'o c'a jule' fariseo xe'urkaj ruq'uin in quewa' quibij tre ri' pro xa nquic'ambajbej rxin: —Ja ley xin Dios ja tz'ibtal can rmal ja Moisés ¿la nuya' lugar tre jun achi chi nujach can ja rxjayil? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—¿Nak nbij ja mandamiento ja ya'on can chewe rmal ja Moisés? xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—Ja Moisés xuya' lugar tre ja rachi chi nujach can ja rixok xarwari' wi nuban jun wuj in ntz'ibaj chipan chi xajutij nujach can, xeche'e ja fariseo tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—Como congana cowirnak ja rewanma chi rbanic ja ritzelal xa chewi' tok ja Moisés rya'on can awa' chewe ja jun mandamiento ja xebij chwe ri'. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pro ja quibanic ja winak ja tok kas xewinakarsaxi nabey, ja Dios arja' winakarsan quixin, achi in ixok xerwinakarsaj ");
INSERT INTO tzjNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","in quewa' xbij ri': —Rmalc'ari' ja rachi neruya' can ja rtata' rute', nquexim qui' ruq'uin ja rxjayil ");
INSERT INTO tzjNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","in xa jun cuerpo nqueban chi e ca'i', ne'e. Queri' c'a rbanic, ma e ca'i' chi ta, xa jun cuerpo quibanon. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ja Dios como arja' bano jun chique maxta c'o jun winak tijacho quixin. Queri' bix chique rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ja c'a discípulo tok ec'o chic pa jay ruq'uin ja Jesús eje'e' quic'axaj chi na tre nak rbanic ja xbij chique ja fariseo. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Arja' quewa' xbij chique ri': —Jun achi xa nak ta chi achi'al wi nujach can chijutij ja rxjayil in wi nuc'am chic jun chic ixok jari' adulterio ja nuban. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","In wi c'o jun ixok chakaja' nujach can ja rchajil in nuc'am chic jun chic achi jari' adulterio ja nuban ja rixok, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ec'o c'a jule' tak ac'ala' xec'amarel ruq'uin ja Jesús utzc'a chi nuya' ruk'a' pa quewi'. Pro ja rdiscípulo eje'e' xequich'olij ja rec'amyonel quixin ja rac'ala'. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pro ja Jesús arja' pokon xuna' ja queban ja rdiscípulo in quewa' xbij chique ri': —Teya'a' lugar chique ja tak ac'ala' quepi na wq'uin, maxta ma teya' ta lugar chique como ja winak ja re'ocnak e cani' tak ac'ala' quixin c'a eje'e' ari' ja gobierno xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Anin ni katzij wi' ja xtinbij chewe ri', xa nak ta ja matuban tino'y chi rnimaxic ja gobierno xin Dios ja cani' nuban jun ac'al jari' nixtac'a xtoc ta chipan ja gobierno xin Dios, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","C'ac'ari' xerch'elej ja rac'ala' chiquijujunal, xuya' ruk'a' pa quewi' in xuya' rutzil chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ja Jesús kas elem nuban chi numajel chic jutij rubey ja tok c'o jun achi c'amc'ol ranim peti, xuque' chwach in quewa' xbij tre ri': —Maestro, atat congana at utzlaj achi. ¿Nak nban utzc'a chi nyataj chwe ja utzlaj c'aslemal ja mta q'uisic trij? ne'e ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—¿Nak tre tok nabij chwe chi in utzlaj achi? Xa jun ja utz, jari' Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Atat awotak ja mandamiento xin Dios ja tz'ibtal can quewari': —Ma taban ta rij rwi' awixjayil owi awachajil, ma taban ta camíc, ma taban ta alak', ma taya' ta testigo'il ja ma katzij ta, ma que'aban ta engañar ja winak xtaban ta itzel chique in que'animaj atata' ate' chakaja'. Queri' nbij ja rtzobal Dios, ne'xi ja rachi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Maestro, jala' ja nabij le' ni nmajonto wi' rnimaxic tok c'a in tino'y na, ne' chic ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ja c'a Jesús kas xtz'elwachij ja rachi in congana nrajo' in quewa' xbij tre ri': —Pro c'a c'o na ja ma abanon ta. Camic jat, tac'ayij can nojel ja c'ol awq'uin, ja c'a rjil taya'a' can chique ja tak meba'i'. Ja wi queri' naban jari' c'oli ja meba'il ja nyataj na chawe chila' chicaj. Ja tok xtibantaj amwal ja c'a xinbij chawe ri' catmelojto wq'uin in cattre'el chwij pro maxta tapokonaj natij rpokonal mwal cani' nuban jun achi rijkan jun cruz, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ja c'a rachi tok xc'axaj ja bix tre rmal ja Jesús chi nuban kas junwi' xuna', xumaj bis rmal in meloji. Queri' xuban como congana jun nimlaj meba'il ja c'o ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ja c'a Jesús xertz'elwachij ja rdiscípulo in quewa' xbij chique ri': —Ja biyoma' congana c'ayew chique chi ne'oc chipan ja gobierno xin Dios, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ja c'a discípulo congana c'asc'o'i quic'axaj ja tzij ja bix chique rmal ja Jesús pro arja' xbij chic jutij chique: —Nc'ajol, anin nbij chewe camic, ja winak ja xa ruq'uin meba'il yukul wi' quec'u'x congana c'ayew chi ne'oc chipan ja gobierno xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tzuc'a jun camello arja' nimlaj chicop in congana c'ayew chi noc'o pa rchak jun bak diso'mbal pro jari' ma c'ayew ta chwach ja noqui jun biyom chipan ja gobierno xin Dios, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Eje'e' más chi na junwi' quena' in quic'axaj tre: —Jun biyom wi c'ayew chi noc chipan ja gobierno xin Dios ¿echinatak c'ari' ja newilowi ja totajem xin Dios? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ja c'a Jesús arja' xertz'elwachij in quewa' xbij chique ri': —Ja winak ni maquecowin wi' xtiquecoj ta qui' queyon chipan ja totajem xin Dios pro ja Dios arja' ncowini neruto' como ja Dios ni majun nak ta ja maquita ncowini nuban, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ja c'a Pedro arja' xbij tre: —Ja c'a chake ajoj, nojel ja c'o kuq'uin kaya'on can, okocnak adiscípulo, nij oktran wi' chawij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ja c'a Jesús quewa' xbij ri': —Ni katzij wi' ja xtinbij chewe ri', ja winak xa nak ta chi winakil ja wi c'oli quiya'on can cani' tre cochoch owi cani' chique quinimal owi quechak' owi cana' owi cani' chique quitata' quete' owi cani' chique quixjayilal owi calc'wal owi cani' tre culew, ja c'a wi mwal anin ja tok quiya'on can in wi rmal ja utzlaj tzij ja nc'amonto ");
INSERT INTO tzjNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","jari' más chi na q'uiy ja xtiyataj na chique wawe' chwach'ulew chwach ja cani' quiya'on can. Más chi na q'uiy ja cochoch ja xtiyataj na chique in más chi na e q'uiy ja quinimal, quechak', cana', quete', calc'wal in culew chakaja'. Xarwari' c'o na je'e ja rpokonal nba̱n chique mwal. Pro ja c'a chipan ja jun chic tiempo ja xtipi na c'o jun utzlaj c'aslemal ja xtiyataj na chique ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Xarwari' e q'uiy ja winak ja rec'amol tak bey nabey pro xa xquecanaj can pa rq'uisbal in ja re tak q'uisbal eje'e' nec'amo chic bey. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ja Jesús e rachbil ja rdiscípulo quimajon bey ebenak pa Jerusalén, arja' rc'amon quebey. Ja rdiscípulo congana c'asc'o'i quetz'at ja Jesús chi matixbej ri' pro eje'e' congana quixben chic qui' etran trij. Ja c'a Jesús arja' quiyonaj qui' cuq'uin ja cablajuj apóstol in xumaj rbixic chique nak ja xtiban na tre pa Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Quewa' xbij chique ri': —Bien tec'waxaj ja xtinbij chewe ri', camic okbenak pa Jerusalén in ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak tri' ncamsax wi', nja̱ch na pa quek'a' ja jefe quixin sacerdote e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés. Ja c'a reje'e' nquek'et tzij trij chi ncamsaxi. Nquejach na pa quek'a' ja winak ja ma e aj Israel ta. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","C'ac'ari' nqueyok', nquirapaj, nquichubaj rpalaj in nquicamsaj in chi rox k'ij nc'astaj rwach, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","C'ac'ari' ja re ca'i' rc'ajol ja Zebedeo ja quibina'an Jacobo in Juan eje'e' xetiloc ruq'uin ja Jesús in quewa' quibij tre ri': —Maestro, xtaban ta jun utzil chake, xtawajo' ta jutz'it ja xtikabij chawe ri', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Nak rbanic ja rutzil chi newajo' nban chewe? xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Ja tok xtoqui ja ragobierno atat xtaya' ta jun orden chi jun chake ntz'abe' pan awiquik'a' in jun chic ntz'abe' pan awixcon, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Ixix xa ma ewotak ta ja nixtajini nec'utuj chwe. ¿La nixcowini xtetij ja rpokonal ja cani' xtintij anin? Como ja xtiban anin chwe cani' ninban bautizar chipan jun nimlaj rpokonal. Ja c'a rixix ¿la necoch' nixk'ax chipan? xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Nokcowini, xeche' tre. In xbij chic chique: —Jari' ni katzij wi' chi netij na ja rpokonal ja cani' xtintij anin in nixk'ax na chipan ja rpokonal ja cani' xquink'ax anin chipan chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pro ja xec'utuj chwe le' chi nixtz'abe' pa wiquik'a' in pa wixcon jari' ma wq'uin ta anin c'o wi' como jari' chomarsan chic chok chique xtiyataj wi', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ja c'a lajuj chic discípulo tok quic'axaj ja nquic'utuj ja Jacobo in Juan tre ja Jesús eje'e' congana pi quiyewal chiquij. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ja c'a Jesús arja' xersiq'uij pon in quewa' xbij chique ri': —Ixix bien ewotak jani' nqueban ja winak ja rec'o pa tak nación je'e ja c'o gobierno pa quek'a' neche'xi, eje'e' congana e nimak nquena' in nqueban chique ja winak xa e cani' quimoso. Ja nimak quek'ij xa congana nequeban mandar ja winak ja rec'o pa quek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pro ja chewe ixix mta moda ja queri' ta xteban. Ja c'a neban, xa nak ta chewe ja c'o rgana chi noc nim ruk'ij checojol rjawaxic chi noc jun ilinel ewxin. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Xa nak ta chewe ja c'o rgana noc jefe ewxin rjawaxic chi noc emoso ewanojel. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Cani' xuban ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, arja' pi wawe' chwach'ulew pro ma rmal ta chi nilix cumal winak pro jari' peti chi arja' noc jun ilinel quixin ja winak. In peti chakaja' utzc'a chi arja' nuya' ri' pa camíc in ja rcamic e janila ja winak nerlok'bej chipan ja quil quemac. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","C'ac'ari' xe'ekaji ja Jesús chipan ja tinamit rbina'an Jericó. Kas rmajon elem chipan ja tinamit e rachbil ja rdiscípulo in congana chi winak etran trij. In c'o jun ti moy tz'ubul chi' bey, rmajon rc'utuxic limosna chique winak. Ja ti moy Bartimeo rubi', rc'ajol jun achi Timeo rubi'. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ja c'a tok xc'axaj chi Jesús ja raj Nazaret ja nk'ax pa bey xumaj rakic ruchi' trij: —Jesús, atat ja rat Ralc'wal can ja rojer rey David, tapokonaj jutz'it nwach, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pro e q'uiy ja winak quemaj rch'olixic: —Xa jun catq'ue wi', ma tarak ta achi', ne'xi ja ti moy. Pro arja' xa más chi na xurak ruchi' trij ja Jesús: —Atat ja rat Ralc'wal can ja rojer rey David, tapokonaj jutz'it nwach, ne' chic jutij tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ja c'a Jesús arja' pe'i, xutak rsiq'uixic ja ti moy. Xebe chi nequisiq'uijto in tok xe'ekaj ruq'uin quewa' bix tre cumal ri': —Camic catquicoti, catyictaji, natsiq'uix rmal ja Jesús, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Arja' c'o jun tziak rcojon trij ja rtziak jari' xch'akla' can, yictaji in be ruq'uin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ja c'a tok xekaj ruq'uin quewa' bix tre ri': —¿Nak nawajo' chwe chi nban chawe? ne'xi rmal ja Jesús. —Wajaw, ja nwajo' chawe chi njaktaj ta ja nwach, ne'e ja ti moy. C'ac'ari' bix tre rmal ja Jesús: ");
INSERT INTO tzjNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Camic xattzuri, utz chic natbe, ja yukulbal ac'u'x wq'uin jari' xattzursani, ne'xi. Chaka maril tok bitaj queri' tre ni jari' hora jaktaji ja rwach in tre'el trij ja Jesús pa bey. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Quimajon bey ebenak, xa chinakaj ja tinamit Jerusalén ec'o chi wi' in xe'ekaj chuchi' ja ca'i' tinamit, jun Betfagé in jun Betania ja bar c'o wi' ja jayu' rbina'an Rjayu'al Olivo. Ja c'a Jesús ec'o ca'i' chique ja rdiscípulo xerutak ");
INSERT INTO tzjNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","in quewa' xbijel chique ri': —Jix ja pa tinamit le', chila' newil wi' jun ti ral bur ximili ja ni mta wi' jutij tz'ulben ta cumal winak. Tequira'to in tec'ama'to. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ja wi c'oli nak xtibin chewe: —¿Nak tre tok nequir ja ti bur? wi xtiche' chewe, quewa' xtebij tre ri': —Ja kajaw nc'atzin tre, quixche' tre, in alnak nya'la'to chewe. Queri' xbijel ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Xebe ja re ca'i' discípulo. Ja c'a tok xe'ekaji chipan ja tinamit quewil ja ti bur ximil chuchi' jun puerta ja bar nuc'ul wi' ri' ca'i' bey in quemaj rquiric. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Kas c'a quimajon rquiric ja tok xek'ilox cumal ja winak ja rec'o tri': —¿Nak ja neban, nak tre tok nequir ja ti bur le'? xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","C'ac'ari' quemaj rbixic chique ja binel chique rmal ja Jesús in ya' lugar chique chi nquec'amto ja ti bur. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Quec'amto ja ti bur. Ja quitziak jari' quiwekbej, tz'abe'e ja Jesús trij in xumaj binem. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Congana e q'uiy ja winak quisocla' ja quitziak pa rubey ja Jesús in ec'o chic jule' xequikupla'to rxak tak palma in queya' pa rubey chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ja c'a re nabeyal chwach e cachbil ja retran trij eje'e' congana nquerak quechi' in quewa' nquibij ri': —Dios, ko'ato'o' camic, bendecido amwal ja Cristo le' ja penak pan abi' atat ja rat kajaw Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bendecido amwal ja gobierno ja penak chikawach ja rxin ja kamama' David. Ko'ato'o' camic Dios ja ratc'o chila' chicaj. Queri' ja nquibij. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ja c'a Jesús tok xekaji chipan ja tinamit Jerusalén xoc chipan ja nimlaj templo xin Dios. Ja c'a tok tz'attaj can rmal nojelal ja ntajini nba̱n chipan ja templo c'ac'ari' be. Como kaj k'ij xelel chipan ja tinamit Jerusalén, be chic chipan ja tinamit Betania e rachbil ja cablajuj apóstol. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ja c'a chi rcab k'ij tok xe'elto ja Jesús pa Betania arja' majtaj rmal rk'ak'anil rupan. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","In xutz'at pon jun mocaj higuera. Ja che' c'o ruxak in be ja Jesús ruq'uin, nertz'ata' ja wi c'o rwach. Pro ja tok xekaj ruq'uin ni majun rwach, xa ruyon ruxak como maja'n terila' tiempo rxin ja cosecha xin higo. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ja c'a Jesús quewa' xbij tre ja che' ri': —Majutij xcatwachin ta xtitij chi ta higo chawe, ne' tre. Ja c'a rdiscípulo eje'e' quic'axaj ja xbij tre ja che'. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ja c'a tok xe'ekaj chipan ja tinamit Jerusalén xoc chipan ja nimlaj templo xin Dios in xumajto quilasaxic canojel ja rec'o chipan ja quimajon c'ayinem e cachbil chakaja' ja quimajon lok'oj tak nakun. Ja quimesa ja q'uexol tak pwok xch'akij pa tok'ulew in queri' xuban tre chakaja' ja quich'acat ja nec'ayin tak palomax. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","In chakaja' ma xuya' ta lugar chique ja winak chi xtiqueram chi ta ja templo cuc'an ta ja quinakun. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","C'ac'ari' xumaj quitijoxic, quewa' xbij chique ri': —Ja rtzobal Dios quewa' tz'ibtal chipan ri': —Ja wochoch anin jari' banbal oración quixin ja winak ja rec'o nojel tak nación, ne'e ja Dios tre ja rtemplo, pro ja rebanon ixix tre xa jun lugar ja bar neq'ueje' wi' alak'oma', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ja c'a maestro ja netijon quixin ja winak tre ja ley xin Dios e cachbil ja jefe quixin sacerdote eje'e' tok xekaj rbixic cuq'uin ja xbij ja Jesús congana quixbej qui' rmal in rmalari' quemaj rcanoxic rij rwach nak nqueban tre chi nquicamsaj. Eje'e' quixbej qui' como ja tijonem ja ntajini nuya' ja Jesús kas c'asc'o'i nquic'axaj canojel ja winak in nqueya' quixquin tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ja c'a tok xoc chic ak'a' be chic ja Jesús, xelel chic chipan ja tinamit Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ja c'a chi rcab k'ij chic ak'abil xek'ax chic jutij ja Jesús ja bar c'o wi' ja che' higuera rubi'. Ja tok quetz'at ja che' chakijnak chic pro ni rachbil rc'amal. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ja c'a Pedro arja' xurkaj tre ja bin can tre ja che' rmal ja Jesús: —Maestro, tatz'ata' mpe' le', chakijnak chic taka'an ja che' ja xabij tre chi majutij xtiwachin chi ta, ne' tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","In bix chique rmal ja Jesús: —Tiq'ueje'e ja yukulbal ec'u'x ruq'uin ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Anin ni katzij wi' ja xtinbij chewe ri', jun achi xa nak ta chi achi'al ncowini nbij trela' ja jun jayu' le' chi neli, nerq'uiaka' ri' pa ya' in ja jayu' nbe, nnimaj. Ja rachi ncowini nuban ja wari' xarwari' wi matuban ca'i' ruc'u'x in wi c'o rseguro chi nbantaji ja nbij. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Rmalc'ari' nbij chewe xa nak ta ja nec'utuj pan oración, ja ta neban c'o ta eseguro chi chomarsan chic rmal ja Dios chi nuya' chewe ja nec'utuj. Ja wi queri' neban jari' nyataj chewe. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","In tok c'o je'e oración neban, wi c'o jun xa nak ta ja rbanon pokon chewe rjawaxic chi necuy utzc'a chi ja Tatixel ewxin ja c'o chila' chicaj arja' nixrucuy ixix chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nowi matecuy jari' maquixrucuy ixix chakaja' ja Tatixel ewxin ja c'o chila' chicaj, xeche'xi ja discípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ja c'a tok xe'urkaj chic chipan ja tinamit Jerusalén xoqui ja Jesús chipan ja nimlaj templo xin Dios. Kas c'a rmajon binem chipan ja tok xe'ekaji ja jefe quixin sacerdote e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios e cachbil chakaja' ja principali' xin tinamit ");
INSERT INTO tzjNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","in quewa' quibij tre ri': —¿Nak atocnak wi' chewi' tok amajon rbanic nojel awa' ja kamajon rtz'atic in nak yoyon chawe chi naban? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","—Anin chakaja' c'oli ja nc'waxaj chewe. Ja wi xtebij chwe ja xtinc'waxaj chewe ri' anin chakaja' nbij chewe nak inocnak wi' chi nmajon rbanic nojel awa' ja remajon rtz'atic. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Camic tebij chwe, ja Juan Bautista ¿nak yo' tre ja rsamaj chi neruban bautizar ja winak, la ja' Dios ja c'o chila' chicaj ja yo' tre owi xa winak? xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ja c'a reje'e' quemaj tzij chibil tak qui': —Ja wi xtikabij tre chi Dios yo' tre, arja' nbij chake: —Ja wi queri' ¿nak c'a tre tok ma xenimaj ta? ne' ala' chake. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pro ja wi xtikabij tre chi xa winak xeyo' tre nak la xtiqueban ja winak chake como ja chiquewach eje'e' ja Juan arja' jun profeta ja ni katzij wi' chi profeta xin Dios. Queri' nquech'ob pro ni canojelal, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","In quibij tre ja Jesús: —Ma kotak ta nak yo' tre, xeche' tre. —In nixtac'a anin ta chakaja' xtinbij ta chewe nak inocnak wi' chi nmajon rbanic nojel awa' ja remajon rtz'atic, xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","C'ac'ari' xumaj chic tzij cuq'uin pro pa tak c'ambal tzij ntzijon chic wi' cuq'uin. Quewa' jun c'ambal tzij xbij chique ri': —C'o jun achi c'o jun rchenoj, uva rticon chwach. Ja tok tictaj rmal xucoj pa q'uexton, xuc'ot jun jul chipan ja bar nlasax wi' ja riya'l uva. Ja c'a chenoj xuyic jun torre chipan ja nq'ueje' chajinel parwi'. Ja c'a rchenoj xuya' pa kajonem chique jule' ajchonla'i' in be chipan jun tinamit congana nat. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ja tok xerila' ja tiempo ja nwachin wi' ja rtijco'm, arja' c'o jun rmoso xutakel cuq'uin ja rajchonla'i' chi nerc'ama' ja renta. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ja rajchonla'i' tok xekaji ja moso cuq'uin quechap, quesoc in tok melojto ni majun nak ta queya'pi tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ja c'a rajaw chenoj c'o chi na jun rmoso xutakel cuq'uin in tok xekaj chic ari' jun cuq'uin queq'uiak tza'n abaj, quesoc rwi', melojto, ni lawulo' quebanpi tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ja c'a rajaw chenoj xutakel chi na jun pro tok xekaj cuq'uin quicamsaj. In c'a ec'o na más xerutakel, ec'oli chique tok xe'ekaj cuq'uin ja rajchonla'i' xesocto in ec'o chic jule' tok xe'ekaji xecamsaxi. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tok q'uiswani ja rajaw chenoj c'o jun rc'ajol ja congana nrajo' jari' xutakel chic in xbij kaj pa ranma: —Como jawa' nc'ajol nqueban respetar awa', ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pro ja rajchonla'i' ja tok xekaji ja ralc'walaxel cuq'uin quewa' quibij chibil tak qui' ri': —Jala' ja rachi le' noc na pa ruk'a' ja rulew ri' como herencia. Camic kacamsaj in noc pa kak'a' ajoj ja herencia rxin, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","C'ac'ari' quechap, quicamsaj in quiwasajto chipan ja chenoj. Queri' nbij ja c'ambal tzij. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Camic tebij c'a chwe, ja rajaw chenoj ¿nak nuban c'ari'? Ja nuban, arja' npeti, ne'urcamsaj ja rajchonla'i', ja c'a rchenoj nuya' chic jutij pa kajonem chique jule' chic ajchonla'i'. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿La mta c'a jutij esiq'uin chipan ja rtzobal Dios jawa' jun tzij ri'? —Ja banol jay c'o jun abaj ja mta quigana ruq'uin in quech'a' pro jari' abaj cojon chic chi rbanic ja jay, arja' ja más nim ruk'ij como arja' nchapowi ja resquina'il. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jari' samaj kajaw Dios banowi in kas c'asc'o'i nkatz'at, ne'e. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ja tok quic'axaj ja c'ambal tzij ja xbij ja Jesús bien ch'obtaj cumal chi eje'e' ja xebixi. Rmalc'ari' cajo' ta quechap, quecoj ta preso pro xa nquixbej qui' chiquewach ja winak. Ja queban, queya' can ja Jesús in xebe. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","C'ac'ari' ja Jesús xeta̱kel jule' fariseo ruq'uin e cachbil jule' winak ja rec'o chipan ja partido xin Herodes, xeta̱kel chi netzijon ruq'uin utzc'a chi c'o jun tzij nelto pa ruchi' in jari' tzij nquichapbej rxin. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ja c'a tok xe'ekaj ruq'uin quewa' quibij tre ri': —Maestro, ajoj kotak chi atat majutij natz'ak ta tzij. Kotak chi majun nak ta nacoj wi' awi' como atat mta jun utz in mta jun itzel natz'at pro ja rbey Dios amajon rc'utic chikawach ni utz wi' naban chi rbixic. Camic tabij chake, ja rimpuesto ja nc'utux chake rmal ja César ja nimlaj rey aj Roma ¿la rubey c'ari' chi nkatoj owi ma rubey ta? ¿La nkaya' owi ma can ta? ¿Nak nabij atat tre? Queri' quibij tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pro ja Jesús arja' bien rotak chi xa ca'i' quipalaj in quewa' xbij chique ri': —¿Nak tre tok newajo' ninec'ambajaj? Tec'ama'pi nac'a jun ja pwok, ntz'at nac'a, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","In quec'ut ja pwok chwach. —¿Chok xin ja wi'aj c'o chwach ja pwok ri' in nak chok xin ja bi'aj tz'ibtal chwach chakaja'? ne'e ja Jesús chique. —Rxin César, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Ja rxin César tre César teya'a' wi', ja c'a rxin Dios tre Dios teya'a' wi', xeche'xi rmal ja Jesús. In congana c'asc'o'i quic'axaj ja bix chique rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ec'o c'a jule' saduceo xebe ruq'uin ja Jesús. Ja saduceo eje'e' matiquinimaj chi nec'astaji ja camnaki'. Ja c'a tok xe'ekaj ruq'uin quewa' quibij tre ri': ");
INSERT INTO tzjNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, ja Moisés arja' rbin can chake chipan ja rtzobal Dios, ja wi c'o jun achi ncam jun ruchak' owi rnimal in mta jun ti ralc'wal nq'ueje' can jari' achi rjawaxic chi nc'ule' ruq'uin ja rixok ja cam rchajil. Ja c'a reje'e' tok nq'ueje' jun ti calc'wal nquibij tre chi ja tac'al ralc'wal ja camnak. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Queban c'a jutij ec'o wuku' alaxic, ja nabey winak c'ule'e pro cami in majun ti ralc'wal q'ueje' can. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ja c'a rucab c'ule' chic ruq'uin ja rixok ja q'ueje' can. Ja cani' xuban ja nabey winak queri' chic xuban ja rucab, cam chic chwach ja rixok, ni majun calc'wal q'ueje' can. In queri' xuban ja rox chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Queri' queban chi e wuku', xec'ule' ruq'uin ja rixok in xecam chwach, ni majun calc'wal q'ueje' can. Ja c'a tok q'uiswani cami ja rixok chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Camic ¿nak c'a nabij atat tre? Ja re wuku' alaxic tok xterila' ja k'ij chi nec'astaj chipan ja camíc ¿nak c'a rchajil ari' ja rixok chique como xec'ule' ruq'uin chi e wuku'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","—Jala' ja nebij le' ma rubey ta como ixix xa ma ch'obtajnak ta emwal nak ja kas mero nuc'ut ja rtzobal Dios in nixtac'a ch'obtajnak ta emwal chakaja' nak rbanic ja poder rxin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Queri' nbij chewe como ja tok nec'astaji ja camnaki' jari' mchita c'ulbic chiquij tri', e cani' ángel chic xin Dios ja rec'o chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","C'oli ja tz'ibtal can chipan ja rtzobal Dios rmal ja Moisés tre ja quic'astajic ja camnaki' ¿la ma esiq'uin ta c'a? Jari' tok xutz'at jule' rxulquiej ja Moisés in ntzijonto ja Dios chipan, quewa' bix tre rmal ja Dios ri': —Anin in Dios rxin Abraham, in Dios rxin Isaac, in Dios rxin Jacob, ne'xi ja Moisés. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tri' netz'at wi' chi ja rAbraham masqui ecamnak chic pro ja chwach Dios ec'asli. Rmalc'ari' tok nbij chewe, ni ma rubey ta wi' ja nebij chi mta c'astajic chiquij ja camnaki', xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","C'o c'a jun chique ja maestro ja netijon quixin ja winak tre ja ley xin Dios, arja' xurkaji ja bar netzijon wi' ja Jesús cuq'uin ja saduceo in xc'axaj ja nquibij. Arja' utz xc'axaj ja xbij ja Jesús chique in quewa' xbij tre ri': —¿Nak ja mandamiento xin Dios ja más na nim ruk'ij tre nojel ja mandamiento? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","—Ja mandamiento ja más na nim ruk'ij tre nojelal quewa' nbij ri': —Tec'waxaj ewanojelal ja rix aj Israel. Ja kajaw Dios arja' xa jun, mchita jun Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","In tewajo' ja Dios ja rewajaw pro nojel ec'u'x tewajo', in nojel ewanma in nojel ena'oj in nojel ja rewachok'ak' tewajo' chakaja'. Ja c'awa' ja mandamiento ja más na nim ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ja c'a rcab mandamiento xa junan ruq'uin, quewa' nbij ri': —Ja cani' nawajo' kaj awi' ayon queri' c'a tabana' chique ja winak, que'awajo' chakaja', ne'e. Jawa' ca'i' mandamiento ja xinbij chawe ri' mchita jun mandamiento ja más chi ta nim ruk'ij chwach, ne'e ja Jesús tre ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","—Maestro, ja c'a xabij le' jala' ni rubey wi'. Ni katzij wi' ja nabij chi ja Dios arja' xa jun in mchita jun Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","In más na vale ja nawajo' ja Dios pro tok nojel awanma nawajo' in nojel ana'oj in nojel awachok'ak' nawajo' chakaja'. In más na vale ja ne'awajo' ja winak cani' nawajo' kaj awi' ayon. Ja wi queri' nkaban jari' más na vale chiquewach canojel ja chicop ja nekatzujuj tre ja Dios ja neporox parwi' altar, más na vale chwach xa nak ta ja jule' chic ja nkatzujuj je'e tre ja Dios parwi' altar, ne'xi ja Jesús rmal ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ja c'a Jesús arja' utz xc'axaj ja bix tre rmal ja rachi in rmalari' quewa' xbij tre ri': —Atat ma nat ta atc'o wi' tre chi natoc chipan ja gobierno xin Dios, ne' tre. Ja tok tzuri tzij rmal ja Jesús mta nak chi ta c'axax chi ta tre como canojel ja winak xa nquixbej qui' ja c'o ta nquic'axaj chic tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ja Jesús rmajon quitijoxic ja winak chipan ja nimlaj templo xin Dios in quewa' xbij chique ri': —Ja maestro ja netijon ewxin tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés ¿nak tre tok eje'e' nquibij chi ja Cristo ralc'wal can ja rojer rey David? ");
INSERT INTO tzjNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Queri' nbij chewe como ja David xuban jutij uc'an rmal ja rEspíritu Santo in quewa' xbij ri': —Ja kajaw Dios quewa' xbij tre ja Wajaw ri': —Cattz'abe'e wawe' pa wiquik'a', wawe' natq'ueje' wi' in nenucoj na pan awakan ja netzelan awxin, ne' tre. Queri' rbin can ja David. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ja c'a David —Wajaw, ne' tre ja Cristo, tebij c'a chwe camic ¿nak tre tok nbix tre ja Cristo chi ralc'wal can ja David? Queri' xbij ja Jesús chique. Ja winak congana e q'uiy netajini nquic'axaj ja nbij ja Jesús in congana nel quec'u'x trij ja tijonem nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ja Jesús tok rmajon quitijoxic ja winak c'oli xbij chique quewari': —Tebana' cuenta chique ja maestro ja netijon ewxin tre ja ley xin Dios. Eje'e' congana nel quec'u'x trij ja nec'astan chiquewach winak, quicojon nimak tak tziak ja nc'utu quixin chi e nimak tak maestro. In c'a c'o na más ja congana nel quec'u'x trij cani' tre ja neba̱n saludar pa tak c'aybal ");
INSERT INTO tzjNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","in cani' tre tok nebe pa tak jay xin molbal ri'il ja bar nc'axax wi' ja rtzobal Dios congana nel quec'u'x trij ja tz'ulbal je'e ja más nimak ruk'ij in queri' nqueban chakaja' tok neba̱n invitar pa nimak tak wa'im. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eje'e' kas k'alawachili nquemaj cochoch tak malcani' ja e camnak chic cachajilal. C'o nimak tak oración nqueban pro xa chi quechi' c'o wi'. Pro ja tok xtik'et tzij chiquij rmal ja Dios más chi na jun nimlaj rpokonal nquetij na. Queri' xbij ja Jesús chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","C'ac'ari' be, xetz'abe'e chinakaj ja bar nc'o̱l wi' ja rofrenda rxin ja templo. Arja' rmajon quitz'atic ja winak ja quimajon rya'ic ja cofrenda chipan ja rc'olbal tak ofrenda. E q'uiy ja winak ja biyoma' xerutz'at pon, eje'e' congana nimak tak ofrenda nqueya' can chipan. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","C'o c'a jun ixok ti malca'n xutz'at in ti meba', arja' c'o ca'i' tak pwok rc'an in xuya' chipan ja rc'olbal ofrenda. Ja ca'i' tak pwok xuya' xa ma nim ta nulok'. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ja c'a Jesús xersiq'uij pon ja rdiscípulo in quewa' xbij chique ri': —Tetz'ata' mpe' ja ti malca'n ixok le', arja' más na nim ruk'ij chwach Dios ja xuya' chipan ja rc'olbal ofrenda chwach ja queya' canojelal ja jule' chic. ");
INSERT INTO tzjNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Queri' nbij chewe como ja jule' chic xa jari' queya' ja totajnak pro arja' masqui xa ti meba' pro xuya' nojel ja c'o ruq'uin ja ntzukbej ti ri', ne' chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","C'ac'ari' xelto ja Jesús chipan ja nimlaj templo xin Dios, kas rmajon binem ja tok c'o jun chique ja rdiscípulo tiloc ruq'uin in xbij tre: —Maestro, tatz'ata' can mpe' ja templo le', congana buen tak abaj ocnak in congana banon rbanic ja tak jay rc'an, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Bix tre rmal ja Jesús: —¿La natz'at ja nimak tak jay rxin ja templo le'? Pro anin nbij chewe chi nerila' na jun k'ij ja tok xtiyojtaji nojelal, ni majun abaj xtirikla' chi ta ri', ne'xi ja discípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ja c'a Jesús arja' tz'ubul parwi' ja ti jayu' rbina'an Rjayu'al Olivo in nutz'at pon ja nimlaj templo xin Dios. Ja c'a Pedro e rachbil ja Jacobo, ja Juan in Andrés, eje'e' quiyonaj qui' ruq'uin in quibij tre: ");
INSERT INTO tzjNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Tabij chake ¿nak k'ij xtibantaji jala' ja c'a xabij kaj chake le'? In chakaja' ¿nak chi retalil nwinakari ja nc'utu rxin chi xajalal maja'n tibantaj cumplir nojelal ja c'a xabij chake? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ja c'a Jesús xumaj rbixic chique quewari': —Kas tebana' jutz'it cuenta ewi', maxta c'o jun quixbano engañar. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Queri' nbij chewe como e q'uiy ja winak nepi na je'e in xa queyon nquecoj qui' chi e Cristo, quewa' nquibij chique ja winak ri': —Anin in Cristo, neche' na chique, in e q'uiy ja winak xquequeban engañar. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","C'o nimak tak ch'a'oj xtiban na nojel nat nakaj pro ja tok xtekaj rbixic ewq'uin maxta texbej ewi' rmal como ni rjawaxic wi' chi nbantaj cumplir nojel awa' wari' pro jari' ma q'uisbal rwach'ulew ta. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Queri' nbij chewe como c'o je'e tinamit xtiyictaj na trij jule' chic tinamit in chakaja' ja gobierno je'e nyictaj trij jule' chic gobierno. In chakaja' c'o nimak tak cubarkan nbantaj na in nimak tak wa'al in cani' chique winak neyojtaj na in neyictaji rmal ja quiyewal. Nojel awa' wari' xa majbal rxin ja nimak tak rpokonal. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pro tebana' jutz'it cuenta ewi' chiquewach ja winak como eje'e' nixquec'amel na pa tak k'etbaltzij in nixquirapaj chakaja' pa tak jay xin molbal ri'il. Nixquec'amel chiquewach gobernador, nixquec'amel chiquewach rey pro mwal anin tok xtiban queri' chewe. Queri' xtiban chewe utzc'a chi nel ntzijoxic chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ja tok maja'n tipeti ja q'uisbal rwach'ulew rjawaxic nabey chi ja utzlaj tzij ja nc'amonto nekaj na rbixic cuq'uin ja winak ja rec'o nojel tak nación. C'a tokoc'ari' xtipeti ja q'uisbal rwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ja c'a tok xquixc'amarel chiquewach chi nixjach pa quek'a' maxta quixocla' il tre ja nebij ja netobej ewi' chiquewach. Pro como chipan ari' hora c'oli xtiyataj chewe ja xtebij chique, ja ta c'ari' xtebij chique. Queri' nbij chewe como ma ixix ta ja nixtzijoni tri' pro ja rEspíritu Santo arja' nyo' chewe nak ja xtebij chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ja xtiqueban ja ralaxic chique ja cach tak alaxic nequejach na pa camíc in queri' xtiqueban ja tatixela' chakaja' chique ja calc'wal in chakaja' ja ralc'walaxela' eje'e' neyictaj na chiquij ja tatixela' in nequejach na pa camíc. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ja c'a rixix xa itzel nixtz'at na cumal canojel ja winak pro mwal anin ja tok xtiban queri' chewe. Pro canojel ja xtiquecoch' quewach chipan ja rpokonal in ni matiqueya' can wi' ja yukulbal quec'u'x wq'uin eje'e' ri' nquewil na ja totajem xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pro kas turkaj chewe ja bitajnak can rmal ja rojer profeta Daniel. Ja xbij ja Daniel chi nerila' na jun k'ij ja tok c'oli ja npeti ja más chi na itzel ntz'a̱t rmal ja Dios. Ja c'a tok npeti arja' npe'e chipan ja lugar ja ma yatal ta trij chi npe'e tri' in congana camíc nuban. (Ja nesiq'uin awa' jule' tzij ri' kas tiquiwasaj jutz'it quina'oj trij.) Jari', tok xtetz'at chi pa'l chic chipan ja lugar, ja c'a neban, ja rixc'o chipan ja departamento Judea mejor quixanmaji, tewawaj ewi' pa tak c'achelaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ja rixc'o parwi' terraza tri' mejor quixanmaji chakaja', ma quixkajpi chi ta pa tak ewochoch chi rlasaxic ja remeba'il pa jay, ");
INSERT INTO tzjNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","in ja rixc'o pa tak chenoj tri' mejor quixanmaji chakaja', ma quixmelojpi chi ta chi ewochoch chi rc'amaric echaqueta. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Anin congana npokonaj quewach ja rixoki' ja xajalal maja'n queq'ueje' tak cal tri' in chakaja' ja rec'o chic tak yaqui'a' chwaquek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tec'utuj tre ja Dios chi ma pa rtiempo tew ta ja tok xterila' ja k'ij chi nixanmaji. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Queri' nbij chewe como c'o jun nimlaj rpokonal npi na pro janila nim. Jaru' pa tiempo tz'ucarsanto ja rwach'ulew rmal ja Dios mta jun rpokonal penak ta ja más ta nim chwach awa' ja nintajini nbij chewe ri' in ni mchita wi' jun xtipi chi ta ja más chi ta nim chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Xarwari' xa pajtali ja rtiempo como ja Dios queri' ja rchomin. Ja c'a wixta maquita pajtali ja rtiempo ni ta majun winak xtuto' ta ri' chipan. Pro cumal ja winak ja recha'on rmal ja Dios chewi' tok pajtali ja rtiempo. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ja c'a wi c'o jun xtibij chewe chi: —Peti ja Cristo, wawe' c'o wi' ri', wi ne'e, ma tenimaj ta. Owi nbij chewe chi: —Quela' c'o wi' le', wi ne'e, chakaja' ma tenimaj ta. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Queri' nbij chewe como ec'oli winak ja nepi na, jule' xtiquecoj qui' chi e Cristo in jule' xtiquecoj qui' chi e profeta xin Dios pro ma katzij ta ja nquibij. Eje'e' c'o nimak tak milagro xtiqueban, jutz'it laj nequeban engañar ja winak ja recha'on rmal ja Dios pro jari' mta moda xquequech'ec ta. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Bien tebana' cuenta ewi' chwach ja wari' como xinya' pon rbixic chewe. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ja tok chaka maril xtoc'owi jawa' nimlaj rpokonal ri' c'ac'ari' matica'y chic ja k'ij, nk'ekumiri in matica'y chic ja ic' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ja c'a ch'umil jari' netzakto in ja nimak tak poder rxin ja caj nsi̱l na. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","C'ac'ari' ja winak eje'e' nquetz'at na ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, arja' c'amonto rmal jule' sutz', janila jun nimlaj poder c'o chic pa ruk'a' in congana nim chic ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","In ec'oli ja ángel rxin nerutakel chi nebe, ne'equimolo' ja winak ja recha'on rmal pro nojel rwach'ulew nebe wi' chi quimolic, mta ja maquita xque'ekaj wi' chi quimolic. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Camic tewasaj c'a ena'oj trij jun che' higuera jari' nc'ambej tzij chewach. Ja higuera ja tok npulani c'o tak ruk'a' nwinakari in ruxak chakaja' jari' retal nuc'ut chewach chi xa nnakajinto ja rtiempo c'atan. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","In queri' c'a tre chakaja' ja tok xtemaj rtz'atic nojel ja c'a xinbij chewe jari' retal nuc'ut chewach chi ma nat chi ta c'o wi' ja k'ij ja xec'waxaj chwe, congana nakaj c'oto chi wi' tri'. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ni katzij wi' ja xtinbij chewe ri', ja tinamit Israel eje'e' c'a ec'o na ja tok nbantaj cumplir nojel awa' wari', ma chupnak ta quewach. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ja caj in rwach'ulew jari' xa nchu̱p na rwach pro ja ntzobal anin jari' ni matichup wi' rwach, mta ari' ja maquita nbantaj cumplir. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pro majun winak otakyon ja mero k'ij in ja mero hora ja xtibantaji in nixtac'a ángel ta chakaja' ja rec'o chila' chicaj in nixtac'a ja Ralc'walaxel ta chakaja' pro ja nata' Dios xa ruyon arja' ja rotakyon. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kas tebana' cuenta, quixc'asc'oti in chijutij temaja' rbanic ja roración como ma ewotak ta nak k'ij tok xquinmelojpi chic jutij chwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ja xtinban anin chewe queri' ja cani' nuban jun achi ja tok nbe pa jun viaje nat in ja rnakun nujach can pa quek'a' ja rmoso chi nqueban cuenta. Arja' nuya' can ja quisamaj chiquijujunal in nbij can tre ja chajil jay chi nc'asc'oti. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","In queri' c'a chewe ixix chakaja', quixc'asc'oti como anin in junan ruq'uin ja rajaw jay in ma ewotak ta nak hora tok xquinmelojpi chic jutij, maxla pa rocbal ak'a', maxla pa nc'ajak'a', maxla pa rsakaric owi tok nsakari. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ja tok chaka jalal xquinpi chic jutij maxta ixwarnak tri'. ");
INSERT INTO tzjNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","In ma ruyon ta chewe ixix nbij wi' chi nixc'asc'oti pro queri' nbij chique canojelal chi nec'asc'oti, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xa ca'i' k'ij chic c'o wi' ja nmak'ij pascua ja tok ntiji ja caxlanway ja mta levadura ruq'uin. Ja c'a jefe quixin sacerdote e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios eje'e' quimajon rcanoxic rij rwach nak nqueban tre ja Jesús chi nquechap pan ekal in nquicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pro quewa' quibij ri': —Ma chipan ta ja nmak'ij nkachap wi' matzij queyictaji ja winak rmal, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ja c'a Jesús arja' c'o chipan ja tinamit rbina'an Betania pa rochoch jun achi rbina'an Simón ja rec'ol itzel tak ch'a'c trij nabey. C'oli ja Jesús pa mesa ja tok be jun ixok ruq'uin rc'amonel jule' ak'om ja qui' rxula'. Ja rak'om puro nardo ne'xi, in congana nim rjil. Ja rixok rc'amonel chipan jun rc'olibal ja banon rbanic, alabastro ocnak. Ja c'a tok xekaj ruq'uin ja Jesús xuk'ip rwi' ja rc'olbal ak'om in xuya' ja rak'om pa rwi'. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ec'oli ja rec'o pa jay, eje'e' junwi' quetz'at ja xuban ja rixok in quewa' quibij chibil tak qui' ri': —¿Nak tre tok xa xtz'ila' ja rak'om le'? ");
INSERT INTO tzjNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ja ta ban tre c'ayix ta, más ta oxi' ciento quetzal xuya', ja c'a rjil ya' ta chique ja tak meba'i', xeche'e. In quemaj rch'olixic ja rixok. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pro ja Jesús xbij chique: —Ma tech'olij ta. ¿Nak tre tok nenak ja rixok? Jawa' xuban chwe ri' congana utz. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ja tak meba'i' eje'e' nij ec'o wi' checojol in xa nak ta tiempo c'ol egana neban utzil chique jari' ix libre chi ne'eto' pro ja chwe anin maquinq'ueje' ewq'uin nojel tiempo, ninwasaxel na checojol. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ja xuban ja rixok chwe ri' xuya' chwe ja c'o ruq'uin. Arja' tok xuya' ja rak'om chwij jari' xchomarsbej pon ja ncuerpo chi nmuki. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ni katzij wi' ja xtinbij chewe ri', ja utzlaj tzij ja nc'amonto, xa bar ta tri' xtekaj wi' rbixic nojel nat nakaj tre ja rwach'ulew tri' xtinatax wi' chakaja' ja rutzil ja xuban chwe jawa' rixok ri', jari' nnatbex rxin. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","C'ac'ari' c'o jun chique ja cablajuj discípulo ja bina'an tre Judas Iscariote, arja' be cuq'uin ja jefe quixin sacerdote, rch'obonel chi nujach ja Jesús pa quek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ja c'a tok xekaj cuq'uin xuch'ob chiquewach ja rch'obonel. Ja c'a reje'e' congana xequicot rmal ja bix chique rmal ja Judas in queya' quechi' chi nqueya' pwok tre. C'ac'ari' ja Judas xumaj rcanoxic nak nuban tre ja Jesús chi nujach pa quek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Xerila' ja nabey k'ij rxin ja nmak'ij ja tok ntiji ja caxlanway ja mta levadura ruq'uin in tok necamsaxi ja tak carnelo xin pascua ja netzujux tre ja Dios como sacrificio. Xepeti ja rdiscípulo ja Jesús in quewa' quic'axaj tre ri': —Ja xtati' xin nmak'ij pascua tabij chake bar tri' xtikachomij wi', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ja c'a Jesús ec'o ca'i' chique ja rdiscípulo xerutakel in quewa' xbijel chique ri': —Jix chipan ja tinamit Jerusalén. Ja c'a tok xquixoc chipan c'o jun achi nec'ul, arja' rc'an jun cura' ya', quixtre'el c'a trij. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ja tok xquixoqui ja bar xtoc wi' ja rachi pa jay tebij c'a tre ja rajaw jay quewari': —Ja Maestro okrtakonto awq'uin chi nurkac'axaj chawe: —¿Nak chi cuarto'il ja nkaban wi' ja wa'im xin pascua e wachbil ja ndiscípulo? Queri' ja binto chake, quixche' tre ja rajaw jay. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ja c'a rarja' nuc'ut chewach jun nimlaj cuarto chomin chic, chicaj c'o wi' pa ca'i' piso. Tri' nechomij wi' ja nkati' ja xin nmak'ij pascua ri'. Queri' xbijel ja Jesús chique ja re ca'i' discípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Xebe ja discípulo in tok xe'oc chipan ja tinamit ni queri' bantaji ja cani' bixel chique rmal ja Jesús. C'ac'ari' quemaj rchomarsaxic ja wa'im ja xin nmak'ij pascua. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ja c'a tok xoc ak'a' ja Jesús e rachbil ja cablajuj discípulo xe'ekaji ja bar nqueban wi' ja wa'im. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kas c'a etz'ubul pa mesa, quimajon wa'im ja tok Jesús quewa' xbij chique ri': —Ni katzij wi' ja xtinbij chewe ri', c'o jun chewe ja kamajon wa'im ruq'uin, arja' njacho na wxin pa quek'a' ja netzelan wxin, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ja c'a reje'e' ja tok quic'axaj ja bix chique quemaj jun nimlaj bis: —¿La maxta anin? ne' jun. ¿La maxta c'a anin? ne' chic jun. In queri' quibij chiquijujunal. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","In bix chique rmal ja Jesús: —C'o jun chewe ja rix cablajuj ndiscípulo ja xa junan nokwa' ruq'uin pa plato, arja' c'ari' ja njacho wxin pa quek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak arja' ncamsax na cani' tz'ibtal can tre chipan ja rtzobal Dios pro congana lawulo' tre ja xtijacho rxin pa quek'a' ja necamsan rxin, makana' maquita Alc'walaxel ja xoc alaxic cuq'uin ja winak. Ja xtijacho rxin más ta utz ja maquita xalax chwach'ulew. Queri' bix chique rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ja c'a tok quimajon wa'im ja Jesús xuc'am ja caxlanway, xmaltioxij tre ja Dios, xuwech' in xujach chique in quewa' xbij chique ri': —Jawa' wari' ncuerpo, tec'ama' in tetija', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","In xuc'am chic jun vaso vino, xmaltioxij tre ja Dios in xujach chique chakaja' in quetij canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","C'ac'ari' xbij chic chique: —Jawa' vino ri' jawa' nquiq'uel ocnak rseguro ja c'ac'a chominem ja rchomin ja Dios. Ja nquiq'uel e q'uiy ja winak nti̱x na pa quicuenta. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Anin ni katzij wi' ja xtinbij chewe ri', ja riya'l uva ni matintij chi wi' wawe', c'a tokori' xtintij chic ja tok xterila' ja k'ij chi ntij chipan ja gobierno xin Dios xarwari' c'ac'a chic nojelal tri', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","C'o c'a jun himno rxin ja nmak'ij pascua quibixaj. Ja c'a tok tzuri ja himno cumal xe'elel, xebe chipan ja lugar rbina'an Rjayu'al Olivo. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ja c'a Jesús arja' xbij chique: —Rmal ja xtiban chwe chipan awa' jun tucwak'abil ri' ixix nineya' can, nixanmaji pro ewanojelal. Queri' nbij chewe como tz'ibtal can chipan ja rtzobal Dios quewari': —Anin xtincamsaj ja yuk'ul quixin ja tak carnelo, ja c'a tak carnelo eje'e' nechictaji. Queri' ja tz'ibtal can. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pro ja tok xtic'astaj nwach ninnabeyaj chewach, ninbe chipan ja departamento Galilea, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ja c'a Pedro arja' xbij tre: —Masqui canojel xcatqueya' can pro ja chwe anin mta moda xcatnuya' can ta, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","In bix tre rmal ja Jesús: —Ni katzij wi' ja xtinbij chawe ri', ja chipan awa' jun tucwak'abil ri' ja tok maja'n tok' ca'mul ja ac' oxmul xtabij chwe chi: —Anin ma wotak ta rwach ja Jesús, natche' na chwe, ne'xi ja Pedro. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","—Masqui ok ca'i' awq'uin xkocamsaxi pro ni ma xcatnuya' can ta wi', ne'e ja Pedro tre. In canojel queri' quibij tre chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","C'ac'ari' ja Jesús xerachbilajel ja rdiscípulo, xebe chipan jun lugar rbina'an Getsemaní. Ja c'a tok xe'ekaji quewa' xbij chique ri': —Quixtz'abe' can wawe' ri', ja c'a ranin nenbana' paki na oración, ne' can chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Be, xeruc'amel ja Pedro e rachbil ja Jacobo in Juan. C'ac'ari' xumaj jun nimlaj bis in xumaj ti'onem ja ranma. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","In xbij chique: —Camic, congana nbisoni ja wanma, ja nna' anin camíc rc'amonto chwe. Ixix quixq'ueje' can wawe', quixc'asc'oti, ne' can chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","C'ac'ari' junwi' xyonaj pon wi' ri' ruyon, xuque'e in xumaj rbanic oración: —Padre, Nata', anin nwajo' nabij ta chwe chi maquita nink'ax chipan awa' rpokonal ja penak chinwach ri'. Atat majun ja maquita natcowini naban, quinawasaj chipan ja rpokonal ja penak chinwach ri', maquita nink'ax chipan xarwari' ni ta c'a xquink'ax wi' chipan ja wi queri' nawajo' chwe chi nban, ne' tre ja Tatixel. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ja c'a tok tzuri ja roración rmal be cuq'uin ja rdiscípulo. Ja tok xe'erwila' ekajnak chi waram. Xbij tre ja Pedro: —Simón ¿nak tre tok xa waram naban? ¿La matacoch' ek xcatc'asc'ot ta jun hora? ");
INSERT INTO tzjNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Quixc'asc'oti in tebana' orar utzc'a ja Satanás tok xquixrtakchi'ij maquita xquixruch'ec. Ja rewanma jari' ni katzij wi' chi c'o rgana nc'asc'oti pro como xa ix winak ja recuerpo npokonaj nuban queri', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","C'ac'ari' meloj chic jutij chi rbanic ja roración. Cani' xbij tre ja Tatixel nabey queri' chic xbij ja pa rca'mul. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ja c'a tok tzur chic ja roración rmal meloj chic jutij cuq'uin in tok xe'erwila' chic ewarnak chic chakaja'. Queri' quibanon como congana jun nimlaj waram chique, ma xquecoch' ta. Ja tok quena' nojoj ni maticanoy cumal nak ta nquibij tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ja c'a Jesús be chic chi rbanic ja roración. Ja c'a tok melojpi chic pa roxmul xbij chique ja rdiscípulo: —Camic quixwar c'a, quixxula'n c'a, camic tzuri. Bien tec'waxaj chi xurwila' ja hora, ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, camic nja̱ch na pa quek'a' ja raj'il ajmaqui' chi nquicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jo', quixyictaji, que'ekac'ulu'. Tetz'ata' mpe' le', xa nnakajinto ja njacho wxin pa quek'a', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kas c'a rmajon na tzij ja Jesús cuq'uin ja rdiscípulo ja tok chaka jalal peti ja Judas. Jari' Judas jun chique ja cablajuj apóstol. Arja' e q'uiy ja winak erachbilanto in c'oli banbal tak ch'a'oj quic'amonto cani' tre espada in che', etakonto cumal ja jefe quixin sacerdote in cumal ja maestro ja netijon quixin ja winak tre ja ley xin Dios in cumal chakaja' ja principali' xin tinamit. Etakonto cumal chi nurquichapa' ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ja c'a Judas ja njacho rxin ja Jesús arja' c'oli xchomij cuq'uin ja winak nak xtuban tre ja Jesús chi jari' njachbej rxin pa quek'a': —Ja tok xtetz'at ja rachi ja xtintz'ubaj ruchi' chewach ja c'ariri', techapa' in tec'ama'el pro bien tebana' cuenta. Queri' rbanic ja xchomij cuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Be c'a alnak ja Judas ruq'uin ja Jesús, ja c'a tok xekaj chwach xuban saludar: —Maestro, Maestro, ne' tre, in xtz'ubaj ruchi'. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","C'ac'ari' ja winak quechap ja Jesús in quecoj preso. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","C'o c'a jun chique ja rachbil ja Jesús chaka jalal tok xwasajto ja respada in c'o jun moso rxin ja lok'laj sacerdote xusoc tre, xkupijel jun rxquin. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ja c'a Jesús arja' chapon chic cumal ja winak in quewa' xbij chique ri': —¿La in alak'om la'an chewi' tok ec'amonto espada ec'amonto che' chwij chi nchapic? ");
INSERT INTO tzjNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pro xinq'ueje' wa'an checojol chipan ja nimlaj templo xin Dios in k'ij k'ij xentijoj ja winak chipan pro ma xinechap ta wa'an tri'. Pro nojel awa' wari' ma chaka ta nbantaji, rumac chi nbantaj cumplir ja tz'ibtal can chwe ojer chipan ja rtzobal Dios, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","C'ac'ari' ja rdiscípulo queya' can, xe'anmajel. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","C'o c'a jun ja rala' rtrarben ja Jesús, arja' mta rtziak rcojonel, xa jun sábana rbaron ri' chipan pro chaka jalal tok chapi cumal ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pro ja xuban, xch'akij can ja sábana, xanmajel ch'anali. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ja c'a winak ja xechapo rxin ja Jesús eje'e' quec'amel chwach ja lok'laj sacerdote. Tri' quimolon wi' qui' ja jefe quixin sacerdote e cachbil ja principali' xin tinamit in e cachbil chakaja' ja maestro ja netijon quixin ja winak tre ja ley xin Dios ja tz'ibtal can rmal ja Moisés. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ja c'a Pedro arja' rtrarben ja Jesús pro c'a c'a nat nutzu' pon chic wi'. Arja' tok xekaji ja bar c'o wi' ja nimlaj jay rxin ja lok'laj sacerdote xococ chwa jay in tz'abe' chi k'ak' cuq'uin ja pulisiya', xumaj rmak'ic ri'. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ja c'a jefe quixin sacerdote e cachbil ja jule' chic ja rec'o chipan ja k'etbaltzij quixin ja raj Israel eje'e' quemaj quicanoxic jule' winak chi nqueya' testigo'il trij ja Jesús. Queri' nqueban utzc'a chi nkaji camíc trij. Pro ni majun nak ta quichapbej ta rxin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","E q'uiy ja winak ja queya' testigo'il trij pro ma katzij ta ja nquibij tre, xa tz'akoj tzij nqueban. Junwi' nbij jun in junwi' nbij chic jun, ni matuc'am wi' ri' ja nquibij. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","In ec'o chic jule' chique, eje'e' xepe'i quemaj rbixic jule' ril ja Jesús pro xa tz'akbal tak tzij queban: ");
INSERT INTO tzjNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Jala' jun achi le', ajoj kac'axan quewa' rbin ri': —Anin nyoj na jawa' nimlaj templo xin Dios ri' ja xa winak ebanyon in nyic chi na jun templo ja ma winak ta ebanyon in xa oxi' k'ij nrajo' chi nyictaj wi'. Queri' rbin, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pro nixtac'a eje'e' ta chakaja' nuc'am ta ri' ja nquibij. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ja c'a lok'laj sacerdote arja' pe'i chiquicojol ja winak in xbij tre ja Jesús: —¿La matac'ulba' c'a ja bix chawe le'? Camic, tabij c'a chwe nak rbanic ja testigo'il ja ya' chawij cumal ja rachi'i' le', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pro ja Jesús ni matic'ulba' wi' ja nbix tre. In bix chic tre rmal ja lok'laj sacerdote: —Tabij chake ¿la atat ja rat Cristo ja rat Ralc'wal ja nimlaj Dios? ne'xi ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ja c'a Jesús arja' xbij tre: —Anin nac'a. In netz'at na chakaja' ja xtuban ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, arja' pa riquik'a' ja Dios ntz'abe' wi' ja bar c'o wi' ja nimlaj poder rxin in netz'at chakaja' ja tok xtipi chic jutij c'amonto rmal jule' sutz' xin chicaj, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ja c'a lok'laj sacerdote c'o jun tziak rcojon xurak como xa itzel xc'axaj ja bix tre rmal ja Jesús in xbij chique ja quimolon qui' ruq'uin: —Camic, mchita ne'oc wi' más ja testigo ");
INSERT INTO tzjNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","como bien xec'waxaj ja xbij le', ja Dios janila nuban ofender ri' rmal. Camic ¿nak nebij ixix tre? ne' chique. —Mta, ni yatal wi' trij chi ncamsaxi, xeche'e canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ec'o c'a jule' chique quemaj rchubaxic ja Jesús. In chakaja' quitz'apij rwach chi su't in tok tz'aptaj cumal quemaj rsoquic in quewa' quibij tre ri': —Tabij c'a chake camic ¿nak yowi k'a' chi apalaj? Queri' ja quibij tre pro xa nquiyok'bej rxin. Ja c'a pulisiya' chakaja' quemaj rya'ic k'a' chi rpalaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ja c'a Pedro arja' tz'ubul chwa jay, c'o c'a jun aj'ic' ja nsamaj ruq'uin ja lok'laj sacerdote xekaj ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ja raj'ic' tok xutz'at ja Pedro chi rmajon rmak'ic ri' chi k'ak' xtz'elwachij in quewa' xbij tre ri': —Atat jun chakaja' xawachbilaj ja Jesús ja raj Nazaret, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pro ja Pedro arja' ma xuya' ta trij ja bix tre: —Anin ni ma wotak ta ja nabij le', nak la nabij chwe, ne' tre ja rixok. Yictaji, be ja bar c'o wi' ja puerta in ja ac' chaka jalal tok xok'i. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pro ja raj'ic' arja' xtz'elwachij chic jutij ja Pedro in xbij chique ja rec'o tri': —Jawa' jun achi ri' arja' rachbilaj ja Jesús, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pro ja Pedro arja' ma xuya' chi ta trij ja bix tre. In c'a co'l ari' tok bix chic jutij tre ja Pedro cumal ja rec'o tri': —Bien k'alaj chi atat at cachbil ja xerachbilaj ja Jesús como bien k'alaj chi at aj Galilea in ja nattzijon atat ni junan ruq'uin ja cani' netzijon eje'e', ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","—Chwach Dios nbij chewe chi anin ma wotak ta rwach ja Jesús ja nixtajini nebij chwe in xta itzel xquinrutz'at ja Dios ja wi ma katzij ta ja nbij, ne'e ja Pedro chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","In chaka maril bitaj rmal ja tzij ri' xok' chic jutij ja ac'. C'ac'ari' xurkaj tre ja Pedro ja bin tre rmal ja Jesús, quewa' bin tre ri': —Ja tok maja'n tok' ca'mul ja ac', oxmul xtabij na chwe chi: —Anin ma wotak ta rwach ja Jesús, natche' na chwe. Queri' ja bin tre. Ja c'a tok xumaj rch'obic ja bin tre rmal ja Jesús xumaj jun nimlaj ok'ej. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ja c'a tok sakari quemol qui' canojel ja jefe quixin sacerdote chi rchomarsaxic nak nqueban tre ja Jesús e cachbil ja principali' xin tinamit e cachbil chakaja' ja maestro ja netijon quixin ja winak tre ja ley xin Dios in canojel ja jule' chic k'etol tak tzij quixin ja tinamit Israel. Quebaq'uel ja Jesús, quec'amel, xequijacha' pa ruk'a' ja Pilato ja gobernador. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ja Pilato tok pa'l chic ja Jesús chwach arja' xc'axaj tre: —¿La atat ja rat rey quixin ja tinamit Israel? ne' tre. —Queri' nac'a cani' nabij le', ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ja c'a jefe quixin sacerdote q'uiy rwach ja ril ja Jesús quemaj rbixic tre ja Pilato. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","C'ac'ari' ja Pilato xc'axaj chic tre ja Jesús: —¿La matac'ulba' ja nbix chawe le'? Congana taka'an jule' awil nquibij chawe, ne' chic tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pro ja Jesús nixtac'a c'o ta jun tzij xbij, ni ma xc'ulba' ta wi'. Ja c'a Pilato congana junwi' xutz'at ja queri' xuban. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ja c'a Pilato ni c'amonnak wi' tre chi ni c'o wi' jun preso nsokpij pa tak nmak'ij pascua pro nuya' lugar tre ja tinamit chi eje'e' nec'utuni nak chi preso'il ja nsokpixel. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ec'o c'a jule' preso, eje'e' e'ocnak pa che' rumac ja xeyictaj trij ja gobierno in ec'o jule' winak equicamsan. C'o c'a jun chique ja preso rbina'an Barrabás. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","C'ac'ari' xe'ekaji ja winak ruq'uin ja Pilato in quewa' quibij tre ri': —Tasokpij jun preso como niquirwari' abanonto chake pa tak nmak'ij pascua, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","—¿Nak newajo', la c'ol egana chi nsokpijel ja rey ewxin ja rix aj Israel? ne'e ja Pilato chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Queri' xbij chique como arja' bien rotak chi ja jefe quixin sacerdote congana quiakirnak canma trij ja Jesús in xa rmal ja raquiakarem tok quijachon pa ruk'a'. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pro ja jefe quixin sacerdote eje'e' xa xequeyoj ja winak in quibij chique chi nquic'utuj ja Barrabás chi nsokpixel in ma ja ta ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ja c'a Pilato arja' xbij chic jutij chique: —Ja wi queri' newajo' ¿nak c'a nban tre nech'ob ixix ja rachi ja rey ewxin ja rix aj Israel nixche' tre? ne'e ja Pilato chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Eje'e' quemaj chic jutij rakic quechi': —Tacamsaj chwach cruz, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Nak c'a tre, nak c'a ritzelal rbanon? ne' chic ja Pilato chique. Pro ja reje'e' más chi na quemaj rakic quechi': —Tacamsaj chwach cruz, xeche' chic jutij tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ja c'a Pilato como arja' matirajo' chi neyojtaj más ja winak rmalari' tok xuya' quigana, xsokpijel ja Barrabás in xuya' orden chi nrapaxi ja Jesús. Ja c'a tok raptaji xujach pa quek'a' ja nec'amo'el rxin chi necamsax chwach cruz. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","C'ac'ari' ja soldado eje'e' quec'amel ja Jesús chwa jay ja bar nq'ueje' wi' ja gobernador in xequemol canojel ja jule' chic cach tak soldado. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","C'o jun tziak morada quecoj tre in quichomij jun corona, q'uix quecoj in quecoj pa rwi'. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","C'ac'ari' quemaj rbanic saludar ja cani' nba̱n saludar jun rey pro xa nquiyok'bej rxin: —Atat at rey quixin ja tinamit Israel, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","C'o jun aj quesoc rij tak rwi' tre in quichubaj. C'ac'ari' xexuque' chwach cani' ruk'ij nqueya' pro xa yok'bal rxin ja nqueban. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ja tok tzuri yok'onem cumal c'ac'ari' quejal ja tziak morada tre in quecoj chic tre ja ni rtziak wi' arja'. C'ac'ari' quec'amel chi nequiripa' chwach cruz. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ja tok xebe c'o jun achi quewil, Simón rubi', arja' c'a melojto pa tak k'ayis in tri' k'ax wi' ja bar ec'o wi' in puersa queban tre chi nrijkajel ja cruz rxin ja Jesús. Ja Simón arja' aj Cirene in ec'o ca'i' rc'ajol, jun rbina'an Alejandro in jun rbina'an Rufo. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","C'ac'ari' xebe, quec'amel ja Jesús pa jun lugar rbina'an Gólgota. Gólgota tibij tzij lugar xin rwi' camnak. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ja tok xe'ekaj chipan ja lugar Gólgota quitzujuj vino tre chi nutij. Ja vino c'oli mirra yujun ruq'uin pro ja Jesús ma xuc'am ta chique. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ja c'a tok riptaj cumal chwach cruz quemaj rbanic suerte trij ja rtziak. Queri' queban utzc'a chi nquetz'at nak chi tziakil xtiquec'am chiquijujunal. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ja hora ja querip wi' chwach cruz a las nueve xin ak'abil. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ja Jesús tz'ibaxi ja ril ja nbix tre, quewa' rbanic ja ril nbixi ri': —Jawa' rachi ri' arja' rey quixin ja tinamit Israel, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","In ec'o c'a ca'i' alak'oma' xeri̱p chwach cruz chakaja', jun pa riquik'a' ja Jesús in jun pa rxcon. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tri' c'a bantaj wi' cumplir ja tz'ibtal can ojer chipan ja rtzobal Dios tre ja Cristo, quewa' nbij ri': —Arja' queri' nba̱n na tre ja cani' nba̱n chique ja ritzel tak winak, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ja c'a winak ja nek'axi ja tok nquetz'at ja Jesús xa nquitzebej xa nqueyok' in quewa' nquibij tre ri': —Atat xatbini chi nayoj ja templo in xa oxi' k'ij nrajo' chi nayic chi wi' jutij, ");
INSERT INTO tzjNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","camic tato'o' c'a awi' ayon, catkajpi c'a chwach ja cruz, neche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","In ja jefe quixin sacerdote eje'e' xa nqueyok' chakaja' e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios: —Arja' To'onel quixin winak ne'xi, pro ja camic xna' maticowini nuto' ri' arja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ja wi katzij chi arja' ja Cristo ja Rey kaxin ja rok aj Israel tikajto c'a camic chwach ja cruz. Ja wi xtikatz'at chi xtikajto nyuke' c'a kac'u'x ari' ruq'uin, neche'e. In queri' queban ja xeri̱p chwach cruz pa rxquin ja Jesús, eje'e' queyok' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ja pa nc'ajk'ij c'o jun nimlaj k'eku'm xoqui nojel rwach'ulew, c'a a las tres xin takak'ij sakar chic jutij. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ja c'a Jesús tok xuban a las tres xin takak'ij arja' congana xurak ruchi', quewa' xbij ri': —Eloi, Eloi ¿lama sabactani? ne'e. Jari' tzij xbij quewa' nbij ri': —Nata' Dios, nata' Dios ¿nak tre tok inaya'on can? ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ec'o c'a jule' chique ja winak ja rec'o tri', eje'e' tok quic'axaj ja xbij quewa' quibij ri': —Jala' rachi le' camnak profeta Elías ja nsiq'uij, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","C'o c'a jun chique xerc'amla'to jun esponja, xch'akba' tre jule' vinagre, xuxim chutza'm jun aj in xuya' nojoj tre ja Jesús chi nutij in xbij: —Ch'enchila', katz'ata' na c'a ja wi xtipeti ja rElías chi nurkajsaj chwach cruz, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ja c'a Jesús arja' xurak chic jutij ruchi' in ni cam kaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","In chaka jalal tok raktaji ja manta ja tasben rpan ja nimlaj templo xin Dios ja bar c'o wi' ja santilaj lugar, chaka ca'i' xuban. Raktaji, xelto chicaj, kajto c'a pa tok'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","C'o c'a jun capitán pa'l chwach ja Jesús arja' tok xutz'at nak xuban ja tok cam kaj quewa' xbij ri': —Jala' rachi le' ni katzij wi' chi Ralc'wal Dios, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ec'o c'a jule' ixoki' ja rec'o tri' chakaja' nquetzu' pon ja nbantaji. Jun chique ja rixoki' María Magdalena, in jun chic María ja rec'o ca'i' ral, jun José in jun chic Jacobo ja ch'ip ne'xi. In jun chic chique ja rixoki' Salomé. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jawa' rixoki' ri' tok q'ueje'e ja Jesús pa Galilea eje'e' nij etran wi' trij in queto' chipan nak ja c'o rjawaxic tre. In c'a ec'o na más ja rixoki' ja xetre'el trij ja Jesús ja tok be pa Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","C'o c'a jun achi José rubi' aj Arimatea, arja' nim ruk'ij chipan ja k'etbaltzij quixin ja tinamit Israel in chakaja' nojel ruc'u'x rayben ja k'ij ja tok xtoqui ja gobierno xin Dios. Ja c'a José como xuban hora in como jari' k'ij ja nchomix wi' nakun rxin ja nmak'ij in c'uluto pispra rxin ja xula'nbal k'ij chakaja' chewi' tok be ruq'uin ja Pilato xerc'utuj tre ja cuerpo rxin ja Jesús, arja' ma xbej ta ri'. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ja c'a Pilato tok xc'axaj chi camnak chic ja Jesús arja' quewa' xbij kaj pa ranma ri': —¿Nak moda c'ari' tok camnak chic? ne' kaj. In xsiq'uij pon ja capitán, xc'axaj tre wi ni katzij wi' chi camnak chic ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ja c'a tok bix tre rmal ja capitán chi ni katzij wi' chi cami c'ac'ari' xuya' orden chi njachi ja cuerpo tre ja José. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","C'ac'ari' ja José xulok' jun tziak, be xerkajsaj ja cuerpo rxin ja Jesús chwach cruz in xubar pa jun utzlaj tziak. Ja c'a tok bartaj rmal xerya'a' chipan jun panteón ja c'oton chwach jun portales in xtz'apij ruchi' tre jun nimlaj abaj. ");
INSERT INTO tzjNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ja c'a María Magdalena rachbil ja jun chic María ja rute' José eje'e' ec'o tri' in nquetzu' pon ja bar q'ueje' can wi' ja cuerpo rxin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ja c'a tok xoc'owi ja xula'nbal k'ij ja María Magdalena rachbil ja jun chic María ja rute' Jacobo rachbil chakaja' ja Salomé eje'e' quelok' jule' ak'om ja qui' rxula' utzc'a chi nebe nequiya'a' trij ja cuerpo rxin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ja c'a xin domingo pa rsakaric xebe ja bar c'o wi' ja panteón, kas nelto k'ij ja tok xe'ekaj chipan ja lugar: ");
INSERT INTO tzjNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","—¿Nak la c'a xtilasani ja rabaj ja tz'apben ruchi' ja panteón utzc'a chi nokcowini nokoc chipan? neche'e chibil tak qui'. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pro ja tok quetz'at pon lasan chic ja rabaj, bien xecowini quetz'at como ja rabaj congana nim. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ja c'a tok xe'ococ chipan ja panteón c'o jun ala' quetz'at, pa quiquik'a' tz'ubul wi', c'o jun nimlaj tziak sak rcojon. Eje'e' congana quixbej qui' rmal. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pro ja c'a ángel xbij chique: —Ma texbej ta ewi'. Anin wotak chi Jesús ja raj Nazaret ja nixtajini necanoj, ja camsax chwach cruz. Pro arja' c'astaj wa'an rwach ari', ma wawe' chi ta c'o wi'. Quixajo', tetz'ata' mpe' ja lugar ja bar q'ueje' wi' ja rcuerpo. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pro ja camic jix, jebij tre ja Pedro in chique ja jule' chic discípulo chi: —Ja Jesús arja' nnabeyaj chewach, nbe pa Galilea in tri' netz'ata' wi' ja cani' bin can chewe rmal. Queri' tebij chique, ne'e ja ángel. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ja c'a rixoki' alnak xe'elto chipan ja panteón, queri' queban como congana nebirboti rumac ja xbeben ri'il. In ni majun bar ta tri' quibij wi' ja quetz'at rumac ja congana quixben qui'. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ja Jesús tok c'astaji chiquicojol camnaki' pa jun domingo pa rsakaric. Ja c'a kas xuc'ut wi' ri' nabey, chwach María Magdalena. Jari' María ja rec'o wuku' itzel tak espíritu e'ocnak tre nabey in xelasaxel tre rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Arja' be cuq'uin ja rachi'i' ja nij etran wi' trij ja Jesús tok maja'n ticami, nerbij chique chi c'astaji ja Jesús. Ja c'a tok xekaj cuq'uin congana bis ok'ej nqueban. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","In xbij chique: —C'astajnak chic ja Jesús, xintz'at wa'an rwach, ne' chique, pro eje'e' ma xquinimaj ta. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ja c'a Jesús ec'o chic ca'i' rdiscípulo, eje'e' quimajon binem ebenak pa jun aldea tok chaka jalal xuc'ut ri' chiquewach pro junwi' na nca'yi chewi' tok ma xch'obtaj ta cumal chanim chi Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pro ja tok ch'obtaj cumal xebe cuq'uin ja jule' chic cachbil, xequibij chique: —C'astajnak chic ja Jesús, xeche' chique, pro ma xnimax ta ja quibij. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ja c'a tok be jutz'it tiempo tre xuc'ut chic jutij ri' ja Jesús chiquewach ja julajuj rdiscípulo, eje'e' kas e'ocnak pa mesa. Ja Jesús arja' xumaj quich'olixic rmal ja ma kas ta yukul quec'u'x ruq'uin in rmal ja kas maril nquinimaj chi c'astaji. Queri' xuban chique como eje'e' ma xquinimaj ta ja bix chique cumal ja xetz'ato rxin chi c'astajnak chic. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","C'ac'ari' xbij chic chique: —Jix nojel nat nakaj chwach ja rwach'ulew, jeya'a' rbixic ja utzlaj tzij ja nc'amonto, jeya'a' rbixic chique ja winak pro ni canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Canojel ja winak ja xtiyuke' quec'u'x wq'uin in neba̱n bautizar eje'e' nquewil ja totajem xin Dios. Ja c'a ma xtiyuke' ta quec'u'x wq'uin eje'e' nk'e̱t tzij chiquij in neta̱kel chipan ja nimlaj rpokonal. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ja xtiyuke' quec'u'x wq'uin c'o je'e ja xtiyataj na chique ja nc'utuwi ja poder xin Dios quewari', jun, pa nubi' anin nequilasajel itzel tak espíritu chique winak, in jun chic, netzijon chipan jule' chic tzobal ja ma cotakin ta, ");
INSERT INTO tzjNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","in jun chic, wi chaka jalal nequechap itzel tak cumatz pro mta nba̱n chique cumal in wi chaka jalal nquetij veneno mta nuban chique chakaja'. In chakaja' wi nqueya' quek'a' pa quewi' ja yawa'i' netzuri. Queri' xbij chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ja c'a kajaw Jesús tok tzuri tzij rmal cuq'uin ja rdiscípulo arja' c'amarel chila' chicaj, xetz'abe' pa riquik'a' ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ja c'a rdiscípulo eje'e' xe'elel, quemaj rbixic ja Jesucristo nojel nat nakaj. Ja kajaw Jesús arja' cachbilaj chi rbanic ja samaj, xuya' chique chi c'o nimak tak milagro nqueban jari' nc'utuwi chi ni katzij wi' nojel ja quimajon rbixic chique ja winak. Amén.");
INSERT INTO tzjNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Honorable Señor Teófilo, anin c'o jun wuj xintz'ibaj ri' in camic nwajo' ntak awq'uin. E q'uiy ja winak ja bien quich'obon can nak rbanon can ja Dios chikawach in jari' quitz'iban chic. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ja quitz'iban ni junan ruq'uin ja bix chake ajoj cumal ja xetz'atowi nojel ja nimlaj samaj ja xuban can ja Jesús in chakaja' eje'e' quech'ob chiquewach ja winak ja utzlaj tzij xin Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ja c'a ranin xenmaja'to rch'obic ja bar winakarnakto wi' nojel ja rbanon can ja Dios chikawach in xunq'uisa' ja bar c'o wi' camic. Bien xinch'ob rij rwach in xinchomarsaj chi utz in xintz'ibaj nojel in camic nwajo' ntak awq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Queri' nban utzc'a chi bien nawotakij chi ni katzij wi' ja utzlaj tzij xin Jesucristo ja c'utun chic chawach. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ja pa rtiempo ja Herodes ja rey xin Judea c'o jun sacerdote, Zacarías rubi'. Ja c'a Zacarías arja' jun chique ja jun moc sacerdote ja bina'an chique e xin Abías. C'o rxjayil, Elisabet rubi'. Ja c'a rElisabet arja' chakaja' riy rumam can ja rojer lok'laj sacerdote Aarón. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ja c'a Zacarías rachbil ja rElisabet eje'e' utz quic'aslemal ntz'a̱t rmal ja Dios, nquinimaj ja mandamiento in nquinimaj ja jule' chic ja tz'ibtal can chipan ja rtzobal ja kajaw Dios, mta nechapbexi. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pro ni majun ti calc'wal como ja rElisabet ni mta wi' alanem trij in c'uluto xa e tak rija' chic chi e ca'i'. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Xuban jutij ja Zacarías e rachbil ja jule' chic sacerdote ja re xin Abías eje'e' ec'o chipan ja quisemana, quimajon ja samaj xin Dios chipan ja nimlaj templo. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ja sacerdote ni quicostumbre wi' chi nqueban suerte chok trij nkaj wi' chi noc chipan ja lugar santo rxin ja kajaw Dios chi rporoxic ja rincienso. Queri' c'a queban in tok tzuri ja suerte cumal trij ja Zacarías kaj wi' chewi' tok xoqui ja Zacarías chipan ja lugar santo chi rporoxic ja rincienso. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kas rmajon c'atem ja rincienso, congana e q'uiy ja winak quimolon qui' chwach ja lugar santo, quimajon rbanic ja roración. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chaka c'a jalal tok c'o jun ángel rxin ja kajaw Dios winakar ruq'uin ja Zacarías. C'o jun altar ja bar nporox wi' ja rincienso, tri' pa'l wi' ja ángel pa riquik'a' ja raltar. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ja c'a Zacarías tok xutz'at ja ángel congana junwi' xuna', congana xbej ri' rmal. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pro ja ángel quewa' xbij tre ri': —Zacarías, ma taxbej ta awi' como ja Dios arja' rc'axan ja raworación, ja c'a rElisabet ja rawixjayil arja' c'o jun ti ral tala' nq'ueje' na chwiruk'a'. Ja c'a tok xtalaxi ja tala' Juan rubi' xtabina'aj tre ");
INSERT INTO tzjNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","in janila xtiquicoti ja rawanma rmal in e q'uiy ja winak ja queri' xtiqueban eje'e' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Como ja tala' arja' congana nim ruk'ij ntz'a̱t na rmal ja Dios. Ni majun vino xtutij ta nixtac'a xtutij ta nak chi ta ja natk'abar rmal. Maja'n talaxi ja tok xtinoji ja rEspíritu Santo pa ranma. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Rmal arja' tok e q'uiy ja winak ja rawach tak aj Israel eje'e' nqueq'uex na quina'oj in nquinimaj chic ja kajaw Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ja tok xtoc achi nnabeyaj chwach ja Cristo chi rchomarsaxic ja rubey, ni queri' ranma ja cani' ranma ja rojer profeta Elías in queri' rpoder chakaja' ja cani' rpoder ja rElías. Jari' nyataj na tre ja rac'ajol utzc'a chi nerchomarsaj ja tatixela' cuq'uin ja tak calc'wal utzc'a chakaja' chi ja winak ja ma e nimanela' ta ncotakij ncuc'aj jun utzlaj c'aslemal. Queri' c'a xtuban, nerchomij pon ja winak utzc'a chi quichomin chic qui' chi rc'ulic ja kajaw Cristo. Queri' xbij ja ángel tre ja Zacarías. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","—Pro ¿nak moda nwotakij ja wi katzij ja nabij le'? como anin xa in ti ri'j chic in queri' tre wixjayil chakaja', xa ok tak rija' chic chi ok ca'i', ne'e ja Zacarías tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ja c'a ángel quewa' xbij chic tre ri': —Anin in Gabriel, mero chwach Dios inelnakto wi'. Ja c'a Dios arja' inrtakonto chi ak'iloxic, inrtakonto chi rbixic chawe ja utzlaj tzij ja c'a xinbij kaj chawe ri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pro bien tac'waxaj ja xtinbij chic chawe ri', como ma xanimaj ta ja utzlaj tzij ja xinbij chawe chewi' tok natoc can mem camic. Ja c'a tok xtibantaj cumplir ja xinbij chawe c'a tokori' xcatcowini xcattzijon chic jutij. Atat ma xanimaj ta ja utzlaj tzij ja xinbij chawe pro ja tok xterila' tiempo rxin tokori' nbantaj na cumplir, ne' tre ja Zacarías. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ja c'a winak eje'e' ec'o can chwach ja lugar santo, cayben ja Zacarías: —¿Nak tre c'awa', congana taka'an nyeloji ja Zacarías chipan ja lugar santo? xeche' kaj pa tak canma. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ja c'a tok xelto ja Zacarías maticowin chic ntzijon cuq'uin ja winak. Ja c'a winak eje'e' ch'obtaj cumal chi c'oli ja xutz'at chipan ja lugar santo como arja' xa ruk'a' chic nuban chiquewach, ni majun tzij xbij chi ta chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ja tok xuq'uis ja rsemana be ja Zacarías chi rochoch. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Xerila' ja k'ij tok yawaji ja rElisabet rmal jun ti ral c'o pa gracia. Jo'o' ic' ja ni ma xelpi ta wi' pa rochoch, quewa' xbij kaj pa ranma ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Quewa' rbanon chwe ja kajaw Dios, c'o chic ti wal rya'on in rmalari' ma q'uixbal chi ta nna' chiquewach ja winak ja nelasan ntzijoxic chi mta wal, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ja rElisabet waki' c'o chi wi' ja tok Dios arja' xutakto chic jutij ja ángel Gabriel. Chipan ja tinamit Nazaret xutak wi' ja c'o pa rcuenta ja departamento Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Xutak ruq'uin jun k'apoj xtan, María rubi'. Ja c'a María arja' rya'on chic ruchi' tre jun achi, José rubi', chi nc'ule' ruq'uin. Ja c'a José arja' riy rumam can ja rojer rey David. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ja c'a tok xekaji ja ángel ja bar c'o wi' ja María quewa' xbij tre ri': —María, ja Dios camic congana utz rbanon chawe, arja' c'ol awq'uin. Camic más na utzil ya'on chawe atat rmal ja Dios chiquewach canojelal ja rixoki', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ja c'a María tok xutz'at ja ángel sach rna'oj rmal ja tzij ja bix tre rmal: —¿Nak tre c'awa' tok nbij queri' chwe? ne' kaj pa ranma. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ja c'a ángel quewa' xbij chic tre ri': —María, ma taxbej ta awi' como atat awilon ja rutzil xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ja camic nq'ueje' na c'aslemal chawij, c'o jun tawal tala' nq'ueje' na. Ja c'a tok xtalaxi ja tala' Jesús rubi' xtabina'aj tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ja tok xtiq'uiy nojoj janila nim ruk'ij, Ralc'wal ja nimlaj Dios xtibina'ax tre. Arja' riy rumam can ja rojer rey David in ja kajaw Dios xticojo rxin como rey ja cani' xuban tre ja David ojer. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Chijutij xtoc rey pan ewi' ja rix riy rumam can ja Jacob in ja gobierno rxin arja' ni mta wi' q'uisic trij. Queri' xbij ja ángel tre ja María. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","—¿Nak moda tok xtibantaj cumplir ja nabij le'? pro makana' inc'ulan ta c'a, ne'e ja María tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Quewa' bix chic tre rmal ja ángel ri': —Ja rEspíritu Santo arja' nkajto na awq'uin in ja poder rxin ja nimlaj Dios jari' nsamaj na awq'uin rmalc'ari' tok ja santilaj ac'al ja xtiq'ueje' chwiak'a' Ralc'wal Dios xtibina'ax tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Camic tawotakij chi ja rElisabet ja rawach'alal masqui xa ti ri'j chic pro c'o chic ti ral pa gracia chakaja'. Ja winak eje'e' nquibij tre chi ni mta wi' alanem trij pro camic waki' c'o chi wi' ");
INSERT INTO tzjNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","como ja Dios arja' mta nak ta ja maquita ncowini nuban, ne'xi ja María. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","—Anin inc'o pa ruk'a' ja wajaw Dios. Tibana' c'a chwe ja cani' c'a xabij kaj chwe, ne'e ja María. C'ac'ari' be ja ángel, xuya' can ja María. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ja c'a María arja' ma xuya' ta tiempo tre, xchomla' ri', be pa jun tinamit ja c'o chwajayu' ja c'o pa rcuenta ja departamento Judea. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ja c'a tok xekaj chipan ja tinamit xoc pa rochoch ja Zacarías in xuya' rutzil rwach ja rElisabet. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ja c'a rElisabet ja tok xc'axaj ja rutzil rwach ya' rmal ja María chaka jalal tok xuna' ja ti ral ja c'o pa gracia chi congana xusil ri' in noji ja rEspíritu Santo pa ranma ja rElisabet. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Arja' cow tzijoni, quewa' xbij tre ja María ri': —Camic más na utzil ya'on chawe atat rmal ja Dios chiquewach canojelal ja rixoki' in janila utzil ya'on tre ja tawal chakaja' ja c'o pa gracia. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Nak c'a inocnak wi' anin chi ja Dios rya'on chwe camic chi atpenak wq'uin? pro makana' maquita at rute' ja Cristo ja wajaw. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Queri' nbij chawe como anin ja tok chaka maril xaya' rutzil nwach xinna' ja ti wal ja c'o pa gracia congana xusil ri' rumac quicotemal. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Congana qui'il chawe como xanimaj chi nbantaj na cumplir ja bix chawe rmal ja ángel ja takto rmal ja kajaw Dios, ne'e ja rElisabet tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ja c'a María quewa' xbij ri': —Ja camic nojel nuc'u'x nojel wanma nya' ruk'ij ja kajaw Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Congana nquicoti ja wanma como ja Dios arja' To'onel wxin. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ninquicoti como ja Dios inrcha'on camic pro makana' nim ta c'a nuk'ij pro xa in ti jun ajsamajel rxin. Ja winak ja rec'o chipan awa' tiempo ja okc'o wi' ri' e cachbil ja winak ja maja'n que'alaxi xa nak ta tiempo xqueq'ueje' wi' eje'e' quewa' xtiquibij chwe ri': —Ja Dios rya'on ja rutzil tre ja María, xqueche' na chwe. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Como ja Dios congana nimak tak utzil ja rbanonpi chwe camic, janila poder c'o pa ruk'a' in ja c'a rubi' santilaj Dios ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ni npokonaj wi' kawach ja wi nkaxbej ki' chwach, niquirwari' nuban chake ja rok winak xa nak ta tiempo nokq'ueje' wi' wawe' chwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bien xk'alasaj chikawach chi congana poder c'o pa ruk'a', xerkajsaj ja winak ja nquena' kaj chi congana nimak quek'ij. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Xerlasajel ja nimak tak rey pa k'etbal tak tzij pro xuya' quek'ij ja winak ja ma nimak ta quek'ij. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Congana utzlaj tak nakun xuya' chique ja winak ja nk'ak'an quepan pro ja c'a biyoma' eje'e' xbij chique chi ne'eli in ni majun nak ta xuya'el ta chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Xokruto' ja rok aj Israel ja rokcha'on rmal chi nkaban ja rsamaj, xoknataj rmal in xpokonaj kawach. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Queri' xuban como queri' rtzujun can chique ja kati't kamama' ojer cani' tre ja rAbraham in cani' chake ja rok riy rumam can ja rAbraham xa nak ta tiempo nokq'ueje' wi' wawe' chwach'ulew. Queri' xbij ja María. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Q'ueje' chi na oxi' ic' ja María ruq'uin ja rElisabet c'ac'ari' meloj chi rochoch. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ja c'a tok tz'akati rtiempo ja rElisabet q'ueje'e ja ti ral tala'. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ja c'a rch'alal e cachbil ja rvecino xekaj rbixic cuq'uin chi ja Dios congana rpokonan rwach in c'o jun ti ral rya'on, janila xequicot ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Eje'e' tok xuban waxaki' ruk'ij ja tala' xebe ruq'uin como jari' k'ij nba̱n wi' circuncidar ja cani' nrajo' ja quireligión. Cajo' ta quicanoj ta rubi' ja tac'al, Zacarías ja ti rubi' laj quibij tre, ti rc'axel ta ja rtata'. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pro peti ja rute': —Ma can ta, Juan rubi' xtikabij tre, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—Pro makana' c'o ta c'a jun awach'alal Juan rubi' xa chewi' tok queri' rubi' nabij, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","C'ac'ari' quemaj rbanic quek'a' chwach ja Zacarías como arja' xa ti mem chic: —¿Nak rubi' ja tac'ajol nbixi? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ja c'a Zacarías c'oli xc'utuj ja bar ntz'ibaj wi' rubi': —Juan rubi', queri' ja xtz'ibaj chiquewach. Congana sach quina'oj rmal pro ni canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chaka c'a jalal tok tzuri ja Zacarías, ma mem chi ta, xumaj chic jutij tzij in congana xumaj rya'ic ruk'ij ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ja c'a vecino eje'e' congana quixbej qui' rmal pro ni canojelal. Nojel c'a ja bantaji ri' xel rbixic nat nakaj nojel chwitakjayu' ja c'o pa rcuenta ja departamento Judea. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Canojel ja winak ja xec'axani ja bantaji ri' eje'e' quec'ol pa tak canma, quewa' nquibij ri': —¿Nak la c'a chi samajil ja xtuban awa' ja tac'al ri'? xeche' tre ja ti yaqui'. Bien k'alaj chi ja kajaw Dios c'o ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ja c'a Zacarías ja rtata' ja ti yaqui' arja' noji ja rEspíritu Santo pa ranma in xumaj rbixic jule' tzij ja yataj tre rmal ja Dios chi nbij tre ja Cristo ja xajalal maja'n talaxi, quewa' xbij ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Kas ta xtiya' ruk'ij ja kajaw Dios ja Dios kaxin ja rok aj Israel como arja' xoknataj rmal in camic okrwasanel libre ja rok tinamit rxin. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Como c'o jun To'onel rtakonto kuq'uin janila nim ja poder c'o pa ruk'a'. Ja c'a To'onel arja' riy rumam can ja rojer rey David ja rajsamajel rxin ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ni queri' rbanon ja Dios ja cani' rtzujun can ojer como ja rojer tak profeta xin Dios eje'e' quitz'iban can chi c'o jun To'onel ja npi na ");
INSERT INTO tzjNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","utzc'a chi noktotaj pa quek'a' ja kac'ulel utzc'a chi noktotaj pa quek'a' canojel ja winak ja xa itzel nokquetz'at. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ja Dios arja' rtakonto ja To'onel jari' xbanbej cumplir ja rtzujun can chique ja kati't kamama' ojer chi ni npokonaj wi' quewach in jari' xbanbej cumplir chakaja' ja santilaj chominem ja xchomij ruq'uin ja rAbraham. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tokori' xchomij ja tok c'o jun juramento xuban, xbij tre ja rAbraham ja kamama' ");
INSERT INTO tzjNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","chi noktotaj na pa quek'a' ja netzelan kaxin utzc'a chi matikaxbej chic ki' nkaban ja nkayabej je'e ruk'ij ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Queri' xuban ja Dios utzc'a chi chwach arja' nkaban wi' ja samaj rxin jaru' pa tiempo nkabanel chwach ja rwach'ulew pro ruq'uin jun ch'ajch'ojlaj anma, ruq'uin jun utzlaj c'aslemal. Queri' xbij ja Zacarías. C'ac'ari' xumaj chic jutij tzij, tre ja ti rc'ajol tzijon chi wi' quewari': ");
INSERT INTO tzjNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","—Nc'ajol, atat xtibina'ax chawe chi at profeta rxin ja nimlaj Dios como atat natnabeyaj na chwach ja Cristo ja kajaw utzc'a chi nachomarsaj na rubey chwach ja tok xajalal maja'n tumaj ja rsamaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Natnabeyaj na chwach utzc'a chi nach'ob chikawach ja rok tinamit rxin chi ja tok ncuytaji ja kil kamac tri' nkawil wi' ja totajem xin Dios ");
INSERT INTO tzjNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","in xa rmal ja congana npokonaj kawach ja Dios xa chewi' tok nuban queri' chake. Rmalc'ari' ja tok c'o jun To'onel rtakonto kuq'uin chila' chicaj ja nsakirsan kabey chikawach. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ja c'a To'onel arja' neruya' na pa sakil ja winak ja rec'o pa k'ekumal ja nquixbej qui' chwach ja camíc in nokruc'aj na chipan jun bey ja rc'an quicotemal. Queri' xbij ja Zacarías. ");
INSERT INTO tzjNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Queri' c'a xuban, q'uiyi ja ti calc'wal ja Zacarías in Elisabet, congana cowir más ranma chi rbanic ja rutzil. Pa tak lugar ja bar kas talan wi' tri' nq'ueje' wi'. Ja c'a tok xerila' ja k'ij rxin be, xumaj rbixic ja rtzobal Dios chique ja rach tak aj Israel. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jari' tiempo c'o jun censo bani. C'o jun nimlaj rey tri', César Augusto rubi', arja' xuya' jun orden chi nba̱n censo chique ja winak ja rec'o pa tak nación pro ni canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jawa' censo ri' jawa' ja kas nabey censo bani tokori' tok c'o jun achi, Cirenio rubi', arja' ocnak gobernador xin Siria tri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Canojel ja winak xebe na pa tak quitinamit ja cati't quimama' utzc'a chi tri' neba̱n wi' censo chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","C'o c'a jun achi, José rubi', arja' aj Nazaret ja c'o pa rcuenta Galilea. Ja c'a José arja' be chakaja' utzc'a chi neba̱n censo tre. Rmalc'ari' ja tok xelel chipan ja tinamit Nazaret in be chipan ja tinamit Belén ja c'o pa rcuenta Judea ja bar xalax wi' ja rojer rey David. Tri' be wi' ja José como ja rey David arja' sepo quixin ja rati't rmama'. Ja José arja' riy rumam can ja rey David. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Arja' c'o jun xtan rachbilajel, María rubi', e utz chic ruq'uin chi nec'ule'e. Ja c'a María arja' yawa' chic, xa nnakajinto ja k'ij ja xtiq'ueje' wi' ti ral. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kas c'a tri' pa Belén ec'o wi' ja tok tz'akati ja k'ij rxin. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tri' c'a xalax wi' ja ti ral tala', ti nabey winak. Xubar pa tziak. Ja c'a tok bartaj rmal c'o jun quiwabal chicop xcanoj in xcotz'ba' chipan. Queri' c'a xuban, pa quic'olibal chicop xeq'ueje' na wi' como enojnak chic ja winak chipan ja posada. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ec'o c'a jule' yuk'ul tak carnelo, tri' ec'o wi' chinakaj ja tinamit Belén, quimajon quichajixic ja tak carnelo chak'a' pa tak k'ayis. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chaka c'a jalal ja tok c'o jun ángel winakar chiquewach takonto rmal ja kajaw Dios in c'oli ja gloria rxin ja kajaw Dios quetz'at, ntajini nuq'uiak ri' chiquij, congana quixbej qui' rmal. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pro bix chique rmal ja ángel: —Ma texbej ta ewi', tec'waxaj mpe' ja xtinbij chewe ri' como anin c'o jun utzlaj tzij ja nc'amonto chewe, jun utzlaj tzij janila quicotemal rc'amonto chique ja winak pro ni canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Quewa' ja utzlaj tzij ja nc'amonto chewe ri', ja camic c'o jun To'onel ewxin c'a xalaxi, pa Belén xalax wi' ja bar xalax wi' ja rojer rey David. Ja c'a To'onel arja' ja Cristo ja kajaw. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ja tok xtewila' ja ti yaqui' quewa' banon tre ri', baron pa tziak in cotz'ban pa quiwabal chicop jari' retal ja nbij can chewe, ne'e ja ángel chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chaka c'a jalal tok ec'o jule' rachbil ja ángel xewinakari e xin chila' chicaj pro congana e q'uiy. Congana quimajon rya'ic ruk'ij ja Dios, quewa' nquibij ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Ja camic janila majtajnak chic rya'ic ruk'ij ja Dios chila' chicaj in ja wawe' chwach'ulew c'o chic ja quicotemal, c'o chic ja rutzil xin Dios cuq'uin ja winak, neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ja c'a yuk'ul tak carnelo tok xemeloji ja ángel chila' chicaj eje'e' quewa' quibij chibil tak qui' ri': —Jo' c'a ja pa Belén tekatz'ata' ja bantajnak ja takonto rbixic kuq'uin rmal ja kajaw Dios, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Queri' c'a queban, xebe alnak. Ja c'a tok xe'ekaji quewil ja María rachbil José in quetz'at ja ti yaqui' cotz'ban pa quiwabal chicop. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ja tok quetz'at ja ti yaqui' c'ac'ari' quemaj rcholic chiquewach ja winak ja bin can chique rmal ja ángel trewa' ja jun tac'al ri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ja c'a winak kas c'asc'o'i quic'axaj canojelal ja bix chique cumal ja yuk'ul tak carnelo. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pro ja María arja' xuc'ol pa ranma nojel ja tzij ja rc'axan, congana nuch'ob rij rwach nak rc'amonto. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ja c'a yuk'ul tak carnelo eje'e' xemeloji, congana quimajon rya'ic ruk'ij ja Dios rmal ja quic'axan in rmal ja quitz'aton, ni bantaj wi' cumplir ja cani' bin can chique rmal ja ángel. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ja c'a ti yaqui' ja tok xuban waxaki' ruk'ij ja tok ban circuncidar tokori' canox rubi'. Ja ti rubi' bix tre Jesús como queri' rubi' ja canox rmal ja ángel ja tok maja'n tiq'ueje' pa gracia. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Xerila' c'a ja k'ij chi nebe nequich'ach'ojirsaj qui' ja cani' nbij ja ley xin Dios ja tz'ibtal can rmal ja Moisés c'ac'ari' xebe ja pa Jerusalén, quec'amel ja tac'al utzc'a chi nequibana' presentar chipan ja nimlaj templo xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Queri' queban como ja ley rxin ja kajaw Dios quewa' tz'ibtal can chipan ri': —Ja tak ala'i' ja nabey tak winak eje'e' e rxin ja Dios pro canojelal, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ec'o ca'i' tak tz'iquin nequitzujuj chwach ja Dios como sacrificio ja cani' nbij ja ley rxin ja kajaw Dios quewari': —Jun c'ulaj tak xtruc'uc' ja netzujuxi owi e ca'i' tak palomax ja re tak co'coj, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","C'o c'a jun achi pa Jerusalén, Simeón rubi'. Ja c'a Simeón arja' congana utzlaj achi, ni nuban wi' respetar ja Dios in ni rayben wi' ja k'ij ja tok xtipeti ja To'onel chi quito'ic ja tinamit Israel. C'oli ja rEspíritu Santo ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ja c'a rEspíritu Santo arja' c'oli rk'alasan chic chwach, quewa' rbin tre ri': —Simeón, atat c'a atc'as na ja tok xtitakto ja Cristo rmal ja Dios ja rawajaw, natz'at can na rwach, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ja c'a Simeón arja' xuc'ax rmal ja rEspíritu Santo, be chipan ja nimlaj templo xin Dios in ni jari' hora tok tri' c'amarel wi' chakaja' ja ti yaqui' Jesús cumal ja rtata' rute' utzc'a chi neba̱n tre ja cani' nbij ja ley xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ja c'a Simeón tok xe'ekaj ruq'uin xch'elej ja ti yaqui' in xumaj rya'ic ruk'ij ja Dios, quewa' xbij tre ja Dios ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Wajaw, camic utz chic ninac'amel, qui' chic nuc'u'x ja nincami como camic xaban cumplir ja xatzujuj chwe. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Como camic xintz'at ruq'uin nwach ja To'onel ");
INSERT INTO tzjNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ja ratakonto pro jun To'onel kaxin kanojelal ja rok winak xa nak ta chi ok winakil, ");
INSERT INTO tzjNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","jun To'onel ja racojon como jun luz ja nsakirsan quebey ja winak ja ma e aj Israel ta in chakaja' acojon como ya'bal kak'ij ajoj ja rok aj Israel ja rok tinamit awxin. Queri' xbij ja Simeón. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ja c'a José rachbil María ja rute' ja ti Jesús eje'e' kas c'asc'o'i quic'axaj ja xbij ja Simeón tre ja ti yaqui'. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","C'ac'ari' ja Simeón arja' xc'utuj ja rutzil xin Dios pa quewi' in quewa' xbij tre ja María ri': —Tac'waxaj mpe' ja xtinbij chawe ri', jawa' jun tac'al ri' arja' cha'on rmal ja Dios utzc'a chi rmal arja' ja tok e q'uiy chique ja kach tak aj Israel nekajsax na in e q'uiy chique chakaja' netotaj na rmal. In jun chic, arja' nc'utu na chikawach ja kas mero rbey Dios pro jari' xa nch'a̱' na tre cumal ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ja c'a xtaban atat, c'oli ja xtana' cani' jun cuchilo xtimin ruq'uin ja rawanma. Rmal c'a ja tawal ri' tok e q'uiy ja winak bien nk'alajin na nak ja nquech'ob kaj pa tak canma, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","C'o c'a jun ti nan tri', Ana rubi', rme'al jun achi Fanuel rubi', arja' riy rumam can ja rAser. Ja c'a rAser arja' jun chique ja cablajuj rc'ajol Jacob. Ja c'a Ana arja' profeta xin Dios, congana ti ri'j chic. C'a k'apoj na ja tok c'ule'e in xa wuku' juna' cuc'aj qui' ruq'uin ja rchajil ");
INSERT INTO tzjNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","como chanim cami ja rchajil, xoc can ti malca'n in ma xc'ule' chic ta. Ochenticuatro chic rjuna'. K'ij k'ij ni matel wi' chipan ja nimlaj templo xin Dios, nuban ja rayuno in nuban ja roración jari' nyabej ruk'ij ja Dios chi pa k'ij chi chak'a'. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ja c'a ti yaqui' Jesús ch'elen rmal ja Simeón in ni jari' hora peti ja Ana, xmaltioxij tre ja Dios ja c'o chic ja To'onel in xlasaj rbixic ja tac'al chique canojel ja winak ja quimajon raybexic ja totajem xin Dios tri' ja pa Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ja c'a tatixela' tok bantaj cumplir cumal nojelal ja cani' nbij ja ley rxin ja kajaw Dios chi nqueban c'ac'ari' xemeloj chic jutij chipan ja tinamit Nazaret ja bar ec'o wi' ja c'o chipan ja departamento Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ja c'a tac'al arja' xumaj q'uiyem, winakar más rchok'ak', congana tz'akat ja rna'oj in c'oli ja rutzil xin Dios ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ja c'a rtata' rute' eje'e' nojel tak juna' tok nerila' ja nmak'ij pascua ni nepi wi' pa Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","In queri' queban chakaja' ja tok cablajuj chic rjuna' ja Jesús, xebe ja pa Jerusalén como ni quicostumbre wi' ja raj Israel chi nequic'ulu' ja nmak'ij. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ja c'a tok xoc'owi ja nmak'ij netajini nemeloji pa Nazaret pro ja c'a Jesús ja tala' arja' q'ueje' can pa Jerusalén xarwari' mta rnaben ja José chi q'ueje' can nixtac'a rute' ta chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ja nquech'ob eje'e' chi c'oli ja Jesús chiquicojol ja jule' chic winak ja recachbilanto pa bey. Kaj jun k'ij chi binem cumal. Ja tok quetz'at chi mta ja Jesús c'ac'ari' quemaj rcanoxic chiquicojol ja cach'alal in chiquicojol ja winak ja cotak quewach chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ja c'a tok ma xcanoy ta cumal c'ac'ari' xemeloji ja pa Jerusalén chi rcanoxic. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","C'a chi oxi' k'ij xequiwila' wi', chipan ja nimlaj templo xin Dios c'o wi', tz'ubul chiquicojol ja maestro ja netijon quixin ja winak tre ja rtzobal Dios. Kas nuya' rxquin tre ja nquibij ja maestro in c'oli ja nc'axaj je'e chique chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kas nc'asc'o'i nquic'axaj ja nbij pro canojelal como congana tz'akat ja rna'oj in tok c'oli nquic'axaj tre congana utz ja nbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Peti rute' rachbil ja José: —¿Wawe' ek atc'o wi' nta'? ¿Nak tre tok xaban quewa' chake? Ok ca'i' in atata' congana okelnak c'ay amwal chi acanoxic, ne'x rmal ja rute'. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","—¿Nak tre ja tok ninecanoj? ¿La ma ewotak ta chi anin ni rjawaxic wi' chwe chi nban cumplir ja rsamaj ja nata' Dios? ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pro eje'e' ma xch'obtaj ta cumal ja xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","C'ac'ari' xerachbilajel chic ja Jesús, xemeloj chic jutij pa Nazaret. Arja' ni nnimaj wi' ja nquibij tre. Ja c'a rute' arja' xuc'ol ja pa ranma nojel ja bantaji ja pa Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ja c'a Jesús juna' juna' xa jani' penak más ja rna'oj, ni rchapon wi' q'uiyem in más chi na utz ntz'a̱t rmal ja Dios in cumal ja winak chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ja c'a Juan ja rc'ajol Zacarías arja' xerila' ja k'ij ja tok tzijoni ja Dios ruq'uin pa jun lugar ja kas talan wi' tokori' pa rtiempo ja nimlaj rey rbina'an Tiberio César. Ja c'a Tiberio César olajuj juna' toqui ja pa k'etbaltzij ja tok tzijoni ja Dios ruq'uin ja Juan. In jule' chic ja rachi'i' ja re'ocnak k'etol tak tzij chipan ari' tiempo quewa' quebi' ri'. Jun, Poncio Pilato rubi', arja' ocnak gobernador xin Judea. Jun chic, Herodes rubi', pa ruk'a' arja' c'o wi' ja departamento Galilea. Jun chic, Felipe rubi' rch'alal ja Herodes, pa ruk'a' arja' c'o wi' ja ca'i' lugar Iturea in Traconite. In jun chic, Lisanias rubi', pa ruk'a' arja' c'o wi' ja lugar Abilinia. Ja rachi ja rocnak lok'laj sacerdote tri' Anás rubi' rachbil Caifás. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ja c'a Juan tok xc'axaj ja bix tre rmal ja Dios c'ac'ari' be, xa bar ta tri' nk'ax wi' ja binelya' Jordán tri' nbe wi' in tok ec'oli winak ja ne'ekaj ruq'uin quewa' nbij chique ri': —Teq'uexa' ja rena'oj, teya'a' can ja ritzelal in quixban bautizar, quirtari' neban utzc'a chi ncuytaji ja rewil emac, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tri' bantaj wi' cumplir ja tz'ibtal can chipan ja rtzobal Dios ojer rmal ja profeta Isaías, quewa' nbij ri': —C'o jun kulaj nc'axax chipan ja lugar ja kas talani, quewa' nbij ri': —Techomarsaj chi utz ja rubey ja kajaw Dios, jic teya'a'. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ja siwan xtinojsax na pro nojel tak siwan. Ja c'a jayu' ni majun tre ja maquita xtikajsax na. Ja loclak tak bey xtiya' na pa jic, ja c'a wi c'ototajnak je'e rwach jari' nmu̱k na. Congana xtiban na rbanic chi utz ja bey ");
INSERT INTO tzjNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","in ja winak eje'e' xtiquetz'at na ja totajem xin Dios. Queri' ja tz'ibtal can. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ja c'a Juan tok ne'ekaji ja winak ruq'uin chi neruban bautizar quewa' nbij chique ri': —Ixix congana itzel tak na'oj ewc'an, ix cani' jule' itzel tak cumatz. ¿Nak bin chewe chi nixanmaj chwach ja nimlaj juicio ja nnakajinto? ");
INSERT INTO tzjNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ja mero rubey chi neban tiwachini ja rutzil pa tak ewanma, nijawari' yatal chewij chi neban ja wi katzij chi eq'uexon chic ja rena'oj. In maxta quewa' tebij kaj pa tak ewanma ri': —Ajoj ok riy rumam can ja rAbraham rmalari' ok rtinamit Dios, maxta quixche'e. Queri' nbij chewe como ja Dios ni ma c'ayew ta tre nerwinakarsaj jule' riy rumam ja rAbraham trela' jule' abaj le'. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","In chakaja' ja camic ri' xa nakaj c'oto chi wi' ja juicio xin Dios cani' rbanic jun iquiaj chomin chic xajalal maja'n tichoy jule' che' tre. Ja c'a che' ja mta utz rwach nuya' jari' nchoyi nojelal in nporox pa k'ak'. Queri' nbij ja Juan chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","—¿Nak nkaban c'awa'? kas neche'e ja winak tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","—Xa nak ta chewe ja c'o ca'i' camisa ruq'uin tiya'a' jun tre ja mta rxin owi c'o way ruq'uin tiya'a' rxin ja mta nutij, ne'e ja Juan chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ec'o jule' molol tak impuesto xe'ekaj ruq'uin chakaja' chi neba̱n bautizar rmal, eje'e' quewa' quibij tre ri': —Maestro, ja c'a rajoj ¿nak nkaban? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Ja rimpuesto tok nto̱j pan ek'a' cumal ja winak xta nijawari' nec'am chique ja bin chewe rmal ja k'etbaltzij, ma teya' ta rwi' ja nec'utuj chique, ne'e ja Juan chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ec'oli soldado chakaja' c'oli quic'axaj tre quewari': —Ja c'a rajoj ¿nak nkaban? xeche' tre. —Ma que'epuersa'ij ta ja winak chi nqueya' quinakun chewe. In jun chic, ma tetz'ak ta tzij chiquij winak. In jun chic, quixq'ueje' conforme ruq'uin ja rewajil ja nech'ec. Queri' xbij ja Juan chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ja c'a winak eje'e' congana quigana ncotakij nak ocnak wi' ja Juan, ni cayben wi' nak ja xtibix chique rmal. Ja quimajon rch'obic pa tak canma chi ja Juan maxla arja' ja Cristo pro queri' quech'ob canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Rmalc'ari' ja tok quewa' xbij ja Juan chique canojelal: —Anin, ya' ncoj ja nixnbanbej bautizar pro c'o chi na jun penak ja xajalal maja'n tumaj ja rsamaj, arja' más chi na nim ja poder c'o pa ruk'a' chinwach anin. Anin ma yatal ta chwij xquintiloc ta ruq'uin nixtac'a chi rquiric ja rxajab. Arja' nixruban bautizar pro Espíritu Santo in k'ak' ja nixrbanbej bautizar. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Arja' rchomin chic ri' chi nerparti'ij ja re utz chiquicojol ja ma e utz ta cani' nuban jun achi nuq'uiak rwach trigo tre pala, nparti'ij ja trigo chipan ja rmukal. C'ac'ari' nuc'ol ja trigo chipan ja rc'olibal pro ja rmukal jari' nporoj pa k'ak' pro jari' k'ak' mta chupic trij. Queri' xbij ja Juan chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Q'uiy ja tzij ja quitakari' ja xerpaxbabej ja winak ja tok xuya' rbixic chique ja utzlaj tzij xin totajem. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pro c'oli ja xuch'a' tre ja gobernador Herodes como ja Herodes c'o jun rixnam rc'amon, Herodías rubi'. Ja c'a Herodías arja' rxjayil ja Felipe rch'alal ja Herodes. In ja Herodes c'o chi na jule' ja ritzelal rbanon ja ch'a' tre rmal ja Juan. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Q'uiy rwach ja ma utz ta xuban ja Herodes in c'uluto xucoj ja Juan pa che'. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ja c'a Jesús tok xebantaj bautizar canojel ja winak in tok bantaj bautizar arja' chakaja' c'ac'ari' kas rmajon rbanic oración ja tok jaktaji ja caj ");
INSERT INTO tzjNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","in kajto ja rEspíritu Santo ruq'uin. Ja c'a rEspíritu Santo cani' jun ajsakaxic' ja tok kajto ruq'uin. C'ac'ari' c'o jun kulaj penak chila' chicaj c'axaxi, quewa' xbij tre ja Jesús ri': —Atat ja rat chak'laj Walc'wal, congana ninquicot chawij, ne'e ja kulaj xin Dios tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ja Jesús tok xumajel ja rsamaj c'o chi la treinta rjuna' in ja chiquewach ja winak arja' ralc'wal ja José. Ja c'a José arja' ralc'wal Elí. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ja Elí ralc'wal Matat. Ja Matat ralc'wal Leví. Ja Leví ralc'wal Melqui. Ja Melqui ralc'wal Jana. Ja Jana ralc'wal José. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ja José ralc'wal Matatías. Ja Matatías ralc'wal Amós. Ja Amós ralc'wal Nahum. Ja Nahum ralc'wal Esli. Ja Esli ralc'wal Nagai. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ja Nagai ralc'wal Maat. Ja Maat ralc'wal Matatías. Ja Matatías ralc'wal Semei. Ja Semei ralc'wal José. Ja José ralc'wal Judá. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ja Judá ralc'wal Joana. Ja Joana ralc'wal Resa. Ja Resa ralc'wal Zorobabel. Ja Zorobabel ralc'wal Salatiel. Ja Salatiel ralc'wal Neri. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ja Neri ralc'wal Melqui. Ja Melqui ralc'wal Adi. Ja Adi ralc'wal Cosam. Ja Cosam ralc'wal Elmodam. Ja Elmodam ralc'wal Er. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ja Er ralc'wal Josué. Ja Josué ralc'wal Eliezer. Ja Eliezer ralc'wal Jorim. Ja Jorim ralc'wal Matat. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ja Matat ralc'wal Leví. Ja Leví ralc'wal Simeón. Ja Simeón ralc'wal Judá. Ja Judá ralc'wal José. Ja José ralc'wal Jonán. Ja Jonán ralc'wal Eliaquim. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ja Eliaquim ralc'wal Melea. Ja Melea ralc'wal Mainán. Ja Mainán ralc'wal Matata. Ja Matata ralc'wal Natán. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ja Natán ralc'wal David. Ja David ralc'wal Isaí. Ja Isaí ralc'wal Obed. Ja Obed ralc'wal Booz. Ja Booz ralc'wal Salmón. Ja Salmón ralc'wal Naasón. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ja Naasón ralc'wal Aminadab. Ja Aminadab ralc'wal Aram. Ja Aram ralc'wal Esrom. Ja Esrom ralc'wal Fares. Ja Fares ralc'wal Judá. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ja Judá ralc'wal Jacob. Ja Jacob ralc'wal Isaac. Ja Isaac ralc'wal Abraham. Ja Abraham ralc'wal Taré. Ja Taré ralc'wal Nacor. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ja Nacor ralc'wal Serug. Ja Serug ralc'wal Ragau. Ja Ragau ralc'wal Peleg. Ja Peleg ralc'wal Heber. Ja Heber ralc'wal Sala. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ja Sala ralc'wal Cainán. Ja Cainán ralc'wal Arfaxad. Ja Arfaxad ralc'wal Sem. Ja Sem ralc'wal Noé. Ja Noé ralc'wal Lamec. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ja Lamec ralc'wal Matusalén. Ja Matusalén ralc'wal Enoc. Ja Enoc ralc'wal Jared. Ja Jared ralc'wal Mahalaleel. Ja Mahalaleel ralc'wal Cainán. ");
INSERT INTO tzjNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ja Cainán ralc'wal Enós. Ja Enós ralc'wal Set. Ja Set ralc'wal Adán. Ja Adán ralc'wal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ja c'a Jesús arja' nojnak ja rEspíritu Santo pa ranma, xelel chipan ja binelya' Jordán, c'amarel rmal ja rEspíritu Santo chipan ja lugar ja kas talani. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ca'winak k'ij q'ueje' tri', majtaj rtakchi'ixic rmal ja diablo. Tre ja tiempo ja q'ueje' tri' ni majun nak ta xutij. Ja c'a tok tz'akati ja ca'winak k'ij majtaj rmal rk'ak'anil rupan. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Peti ja diablo: —Ja wi katzij chi atat ja rat Ralc'wal Dios tabij c'a trewa' ja jun abaj ri' chi noc way, ne'e ja diablo tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","—Tz'ibtal can chipan ja rtzobal Dios chi ja winak ma ruyon ta way nc'atzin chique tre ja quic'aslemal pro nojel ja rtzobal Dios jari' nc'atzin chique chakaja', ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","C'ac'ari' ja diablo xuc'amel chic ja Jesús, xebe parwi' jun nimlaj jayu'. Ja c'a tok xe'ekaji xa jurata xuc'ut chwach ja gobierno rxin nojel ja tinamit ja c'o chwach'ulew ");
INSERT INTO tzjNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","in xbij chic tre: —Wi xcatxuque' chinwach wi naya' nuk'ij, anin njach pan ak'a' ja gobierno rxin nojel ja tinamit ja nmajon rc'utic chawach le' in ncoj pan ak'a' nojel ja meba'il rxin chakaja'. Como anin c'o nuk'a' tre nojel ja natz'at le' in nincowini xa nak ta chi achi'al nya' wi', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ja c'a Jesús quewa' xbij tre ri': —Jat, catel chinwach Satanás como tz'ibtal can chipan ja rtzobal Dios chi xa ruyon ja Dios ja rawajaw catxuque' chwach, xa ruyon arja' taya'a' ruk'ij, queri' nbij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","C'ac'ari' ja diablo xuc'amel chic ja Jesús, xebe chipan ja tinamit Jerusalén. Ja c'a tok xe'ekaji xjotba' parwi' ja nimlaj templo xin Dios in xbij tre: —Ja wi katzij chi atat ja rat Ralc'wal Dios taq'uiaka'el c'a awi' wawe' ri' ");
INSERT INTO tzjNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","como ja chipan ja rtzobal Dios quewa' tz'ibtal can chawe ri': —Ja Dios nerutakto ángel chi naturquichajij, ");
INSERT INTO tzjNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","eje'e' netz'amo awxin utzc'a chi matasoc awakan chwach abaj. Queri' tz'ibtal can, ne'e ja diablo. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ja c'a Jesús xbij tre: —Pro tz'ibtal can chakaja' chi ma tac'ambajaj ta ja Dios ja rawajaw, queri' nbij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ja c'a diablo arja' ni majun ncanoy chic rmal ja ntakchibej rxin ja Jesús c'ac'ari' xuya' can jun tiempo. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ja c'a Jesús arja' meloj chipan ja departamento Galilea, nojnak chic ja poder rxin ja rEspíritu Santo pa ranma. Be c'a rtzijoxic cumal ja winak nojel nat nakaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Xumaj quitijoxic ja winak pa tak jay xin molbal ri'il ja bar nquemol wi' qui' chi rc'axaxic ja rtzobal Dios, congana nya̱' ruk'ij cumal ja winak pro ni canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Be c'a chipan ja tinamit Nazaret ja bar q'uiy wi'. Ja c'a tok xerila' ja xula'nbal k'ij be chipan ja jay xin molbal ri'il como niquirwari' ja rcostumbre. Ja c'a tok xekaji pe'e nojoj utzc'a chi nsiq'uij ja rtzobal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","C'o jun libro ja tz'ibtal can rmal ja rojer profeta Isaías jari' jach pa ruk'a'. C'ac'ari' xujak ja libro, xuwil ja tzij ja nsiq'uij chiquewach ja winak, quewa' nbij ja tzij ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—Ja rEspíritu Santo rxin ja kajaw Dios arja' c'o wq'uin como arja' inrtakonto utzc'a chi nya' rbixic ja utzlaj tzij ja rc'amonto totajem xin Dios chique ja tak meba'i', inrtakonto chi nenuto' ja winak ja kas nti'on canma pa ruk'a' ja il mac, inrtakonto chi nya' rbixic chique ja winak ja re'ocnak preso pa ruk'a' ja il mac chi ne'el na libre, in nbij chique ja moya' chi nja̱k na quewach, in nbij chique ja quimajon rtijic ja rpokonal chi netotaj na. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Inrtakonto utzc'a chi nya' rbixic chique ja winak chi ja camic xurwila' ja tiempo chi nquewil ja totajem rxin ja kajaw Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Queri' ja tzij ja xsiq'uij chiquewach. Ja c'a tok siq'uitaj rmal c'ac'ari' xtz'apij ja libro, xujach chic jutij tre ja rachi ja jachyon rxin pa ruk'a' in tz'abe'e. Kas majtajnak rtz'elwachixic cumal ja winak pro ni canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","C'ac'ari' xumaj chic tzij cuq'uin: —Ja camic bantaj cumplir ja rtzobal Dios ja c'a xinsiq'uij kaj chewach ri', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Canojel ja winak quemaj tzij tre, quewa' quibij chibil tak qui' ri': —Congana buena ja jun achi le', congana taka'an buen tak tzij nbij pro ¿la ma ja ta c'ala' ralc'wal José? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ja c'a Jesús quewa' xbij chique ri': —Anin c'o nseguro chi quewa' nebij chwe camic ri': —Como ne'atzursaj ja winak que'atzursaj c'a chakaja' ja rawach tak aj tinamit. Como c'o jule' milagro xaban chipan ja tinamit Capernaum tabana' c'a chakaja' wawe' chipan ja ratinamit atat, nixche' chwe. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pro ni katzij wi' ja xtinbij chewe ri', ja profeta xin Dios eje'e' ni maquenimax wi' cumal ja cach tak aj tinamit, niquirwari' nba̱n chique canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pro bien turkaj chewe nak ja bantaji ja pa rtiempo ja rojer profeta Elías. Oxi' juna' in nic'aj sak'ij xuban tri' in c'o jun nimlaj wa'al peti nojel nat nakaj chipan ja lugar. E q'uiy ja malca'n tak ixoki' ja rec'o wawe' pan Israel tri' ");
INSERT INTO tzjNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","pro ja c'a rElías tok xuban jutij takel rmal ja Dios chi rto'ic jun malca'n ixok ma ruq'uin ta jun aj Israel takel wi' pro takel chi rto'ic jun malca'n ixok ja c'o chipan ja raldea Sarepta ja c'o pa rcuenta Sidón. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","In queri' bantaji chakaja' ja pa rtiempo ja rojer profeta Eliseo tokori' tok e q'uiy chique ja raj Israel emajtajnak rmal ja ritzel tak ch'a'c pro ni majun nak ta tzursax ta chique xarwari' c'o jun aj Siria tri' Naamán rubi', ruyon arja' tzursax tre ja yobil. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ja c'a raj Israel ja rec'o chipan ja jay xin molbal ri'il chaka maril quic'axaj ja bix chique rmal ja Jesús congana xekuluj rmal pro ni canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","C'ac'ari' xeyictaj trij, quechap, quilasajto chipan ja tinamit. Ja tinamit chwach jun jayu' c'o wi' in tok xe'ekaj chuchi' jun siwan laj queq'uiakel ja Jesús chipan. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pro ja c'a Jesús arja' k'ax chiquicojol, be. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","C'ac'ari' be ja Jesús chipan ja tinamit Capernaum ja c'o pa rcuenta Galilea. Ja c'a tok xekaji xumaj quitijoxic ja winak pa tak xula'nbal k'ij. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ja c'a winak kas c'asc'o'i nquic'axaj ja tijonem nuya' como ja rtzobal congana nerusil, bien k'alaj chi ruq'uin Dios penak wi' ja nbij. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Xuban jutij c'o jun achi chipan ja jay xin molbal ri'il, ocnak jun itzel espíritu tre. Ja c'a rachi xumaj rakic ruchi', quewa' xbij tre ja Jesús ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús ja rat aj Nazaret ¿nak narbana' wawe' kuq'uin, la maxta atpenak chi nokaryojo'? Anin bien wotak nak atocnak wi', atat ja rat Santilaj Ralc'wal Dios, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ja c'a Jesús arja' xch'olij ja ritzel espíritu: —Tacajba' in catel pa ranma ja rachi, ne' tre. Ja c'a xuban ja ritzel espíritu tre ja rachi xch'akij can pa tok'ulew chiquewach ja winak c'ac'ari' xel pa ranma in be, ni majun itzel nak ta xuban can tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ja c'a winak congana c'asc'o'i quetz'at canojelal in quewa' quibij chibil tak qui' ri': —Jawa' rachi ri' ¿nak chi tzijal nucoj? C'o taka'an ruk'a' chique ja ritzel tak espíritu, congana taka'an rchok'ak' ja rtzobal como neruban mandar chi ne'eli in nnimax taka'an cumal, neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Be c'a rtzijoxic ja Jesús nojel nat nakaj pa tak lugar ja c'o chinakaj ja tinamit Capernaum. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ja c'a Jesús arja' xelel chipan ja jay xin molbal ri'il, be chi rochoch ja Simón. Ja tok xekaji c'oli rjite' ja Simón yawajnak, majtajnak rmal jun nimlaj c'atan. C'utux jun utzil tre chi nuto' ja yawa'. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ja c'a Jesús arja' tiloc chi ch'at ruq'uin ja yawa', xuban mandar ja c'atan chi neli in ni chanim xeli. Chaka c'a jalal tok yictaji ja rixok in xumaj quilixic ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ja c'a tok xoc ak'a' canojel ja winak ja rec'o yawa'i' cuq'uin eje'e' xequec'amel ruq'uin ja Jesús. Congana q'uiy rwach ja yobil e'uc'ayon. Ja c'a Jesús arja' xuya' ruk'a' pa quewi' chiquijujunal, xertzursaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","In chakaja' e q'uiy chique ja winak ec'ol itzel tak espíritu xe'el pa tak canma. Ja c'a ritzel tak espíritu tok xe'eli querak quechi' in quewa' quibij tre ja Jesús ri': —Atat ja rat Ralc'wal Dios, xeche' tre. Pro ja c'a Jesús arja' xeruk'il chi maquetzijon más como eje'e' cotak chi arja' ja Cristo ja cha'on rmal ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ja c'a chi rcab k'ij ja tok sakar kaj xelel chipan ja tinamit, be chic chipan jun lugar ja bar kas talan wi'. Ja c'a winak eje'e' quemaj rcanoxic in tok xequiwila' congana quecoj pa ch'a'oj chi nq'ueje' chi na más cuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pro arja' quewa' xbij chique ri': —Anin c'o rjawaxic chwe chi ninbe chic chipan jule' chic tinamit utzc'a chi tri' nenya'a' wi' rbixic chakaja' ja utzlaj tzij tre ja gobierno xin Dios como xa rmalari' ja tok intakonto, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Queri' c'a xuban, be pa tak tinamit je'e ja c'o pa rcuenta Galilea, noc pa tak jay xin molbal ri'il in nuya' rbixic ja rtzobal Dios chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Xuban c'a jutij ja Jesús c'o chuchi' ja ya' ja bina'an tre Lago Genesaret, congana e q'uiy ja winak netajini nquemin qui' trij utzc'a chi nquic'axaj ja rtzobal Dios ja nbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ja c'a Jesús c'o ca'i' lancha xutz'at pon c'o chiya'. Ma ec'o ta ja chapol tak ch'u' chipan ja lancha como eje'e' e'elnakel, quimajon rch'ajic ja quec'am ja chapbal ch'u'. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jun tre ja ca'i' lancha rxin Simón in chipan ari' lancha xoc wi' ja Jesús: —Jo' kojote' nojoj jutz'it asic, ne'e ja Jesús tre ja Simón. Ja c'a tok ejotol nojoj chic c'ac'ari' ja Jesús tz'abe' chipan ja lancha in xumajto quitijoxic ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ja c'a tok tzuri tzij rmal xbij chic tre ja Simón: —Camic jo', tac'ama'el chic ja lancha ja bar más pos wi' rpan ja ya' in tri' teq'uiaka' chi wi' ja rec'am chipan ja ya' utzc'a ec'oli ch'u' ne'echap, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","—Pro Maestro, ni jun ak'a' xoksamaji pro bar ta tri' kachap wi' jun ti rkan ja ch'u'. Pro como atat natbini chi queri' nkaban nokbe c'ari', nenq'uiaka' c'ari' ja c'am chipan ja ya', ne'xi rmal ja Simón. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Queri' c'a queban, xebe, xequiq'uiaka' ja c'am ja bar más pos wi' rpan ja ya'. Ja tok q'uiaktaj cumal congana jun ch'u' xe'oc chipan, xumaj q'uiokoptajem ja c'am cumal. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","C'ac'ari' xequisiq'uij pon ja cachbil ja rec'o chic cha jun lancha chi ne'urto' cumal. Ja tok xe'urkaji quemaj c'a quilasaxic ja ch'u' chipan ja c'am, ni xenoji chi ca'i' lancha ja ch'u', jutz'it laj be xe' ya' ja lancha cumal ja ch'u'. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ja c'a Simón Pedro ja tok xutz'at ja milagro ja bantaji c'ac'ari' xuque' chwach ja Jesús in quewa' xbij tre ri': —Wajaw, mejor natbe quinaya'a' can como anin xa in jun achi in aj'il in ajmac, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Queri' xbij ja Simón como arja' e rachbil canojel ja rec'o ruq'uin congana c'asc'o'i quetz'at chi congana jun ch'u' xequechap. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ec'oli chakaja' ja Jacobo in Juan ja re rc'ajol jun achi Zebedeo rubi', eje'e' quic'amon qui' ruq'uin ja Simón tre ja chapoj ch'u' in congana c'asc'o'i quetz'at ja bantaji chakaja'. Ja c'a Jesús quewa' xbij tre ja Simón ri': —Ma taxbej ta awi', c'o chi na jun samaj ja xtamajel chic rbanic camic ri', winak chic ja xque'acanoj utzc'a chi ne'acoj pa ruk'a' ja Dios, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","C'ac'ari' quec'amto ja ca'i' lancha, xekajto ja chiya'. Chijutij queya' can nojelal in xetre'el trij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Xuban jutij ja Jesús c'o chipan jun tinamit, c'o jun achi xekaj ruq'uin majtajnak rmal jule' itzel tak ch'a'c. Ja c'a rachi ja tok xutz'at ja Jesús xuque' chwach in tique'e: —Wajaw, ja wi nawajo' ninatzursaj, anin wotak chi natcowini ninatzursaj, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ja c'a Jesús xuyuk pon ja ruk'a', xuchap ja yawa' in xbij tre: —Can nwajo' ja cani' nabij chwe, cattzuri, ne' tre, in ni chanim xeli ja ritzel tak ch'a'c trij. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","In xbij chic tre: —Congana nban recomendar chawe chi majun bar ta tri' nabij wi' ja xinban chawe. Xar ja naban, jat, jac'utu' awi' chwach ja sacerdote in jaya'a' ja rofrenda ja cani' rbin can ja Moisés chipan ja ley xin Dios chi naban. Ja c'a rofrenda naya' jari' noc testimonio chiquewach ja sacerdote chi naban cumplir ja rbin can ja Moisés. Queri' xbij tre ");
INSERT INTO tzjNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","pro más chi na be rtzijoxic in congana e q'uiy ja winak nurquimolo' qui' ruq'uin chi rc'axaxic ja tijonem nuya' in ja yawa'i' chique, eje'e' ncajo' chi netzursax rmal. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ja c'a rarja' nbe chipan jun lugar ja bar kas talan wi' in tri' nerbana' wi' oración. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Xuban c'a jutij ja Jesús arja' rmajon quitijoxic ja winak. Ec'o c'a jule' fariseo etz'ubul chirnakaj e cachbil jule' maestro ja netijon quixin ja winak tre ja ley xin Dios, eje'e' nojel tak tinamit epenak wi' ja c'o pa rcuenta Galilea in pa rcuenta Judea in ec'oli chique pa Jerusalén epenak wi'. Ja c'a Jesús c'oli ja poder xin Dios ruq'uin utzc'a chi nertzursaj ja yawa'i'. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chaka c'a jalal tok ec'o jule' achi'i' xe'urkaji, c'o jun achi quic'amonto siquirnak, cotz'ol chwach jun ch'atan che'. Ja c'a rachi'i' eje'e' cajo' ta xe'oc ta ja pa jay xequiya'a' ta ja yawa' c'a chwach ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pro ma xecowin ta quecoj ta ja pa jay como ja winak congana enojnak chipan. Ja c'a queban, xejote' parwi' ja jay, quiwasaj jule' xot in tri' quikajsaj wi' ja yawa', cotz'ol chwach ja ch'atan che'. Ja c'a yawa' c'a chwach ja Jesús xekaj kaj wi' ja bar quimolon wi' qui' ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ja c'a Jesús tok xutz'at ja yukulbal quec'u'x c'o ruq'uin, arja' xbij tre ja siquirnak: —Achi, camic cuytaji ja rawil amac, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ja c'a maestro e cachbil ja fariseo ja tok chaka maril quic'axaj ja xbij ja Jesús quewa' quemaj rch'obic pa tak canma ri': —¿Nak ocnak wi' ja jun achi le' chewi' tok nbij jule' tzij ja xa ofensa rc'amonto tre ja Dios? Como mchita nak chi ta ncuyuwi ja il mac, xa ruyon ja Dios ncuyuwi, xeche' kaj pa tak canma. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pro ja Jesús arja' bien rotak ja netajini nquech'ob kaj pa tak canma in xbij chique: —¿Nak tre tok queri' nech'ob kaj pa tak ewanma? ");
INSERT INTO tzjNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Camic nwajo' nc'waxaj chewe ¿nak ja más c'ayew tre ja ca'i' ri', la ja' nbij tre ja rachi chi ncuy ja ril rumac o la ja' nbij tre chi nyictaji in nbe? ");
INSERT INTO tzjNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Anin c'oli ja xtinban chewach camic ri' utzc'a chi newotakij chi anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak yatajnak chwe chi ncuy ja quil quemac ja winak wawe' chwach'ulew, ne'e ja Jesús chique. C'ac'ari' xbij tre ja siquirnak: —Anin nbij chawe camic, catyictaji, tac'ama'el ja rawarbal in jat chi awochoch, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chaka maril bitaj queri' rmal c'ac'ari' yictaji ja rachi chiquewach, xumaj rc'olic ja rwarbal in be chi rochoch, janila nuya' ruk'ij ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ja c'a winak eje'e' congana c'asc'o'i quetz'at ja bantaji canojelal, quemaj rya'ic ruk'ij ja Dios, congana quixben qui' in quewa' quibij ri': —Ja camic c'oli katz'at ja majutij katz'aton ta, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","C'ac'ari' xelel ja Jesús tri', be. C'o jun achi xutz'at molol impuesto, Leví rubi'. Ja c'a Leví arja' tz'ubul chipan ja lugar ja bar nto̱j can wi' ja rimpuesto pa ruk'a'. Ja Jesús tok xekaj ruq'uin quewa' xbij tre ri': —Jo', cattre' chwij chi natoc ndiscípulo, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ja c'a Leví yictaji, xuya' can nojelal in tre'el trij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ja c'a Leví c'o jun nimlaj wa'im xchomij pa rochoch rxin ja Jesús. Ja c'a Jesús e rachbil ja rdiscípulo eje'e' etz'ubul pa mesa. Congana e q'uiy ja molol tak impuesto etz'ubul pa mesa cuq'uin in ec'o jule' chic winak chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ec'o c'a jule' maestro ja netijon quixin ja winak tre ja ley xin Dios e cachbil jule' fariseo eje'e' c'oli quech'a' chique ja rdiscípulo ja Jesús quewari': —¿Nak c'a tre tok nixwa' cuq'uin ja jule' molol tak impuesto le' in cuq'uin chakaja' ja jule' chic aj'il ajmaqui' le'? xeche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pro peti ja Jesús, quewa' xbij chique ri': —Ja ma e yawa'i' ta eje'e' matic'atzin jun doctor chique pro ja yawa'i' jari' ni nc'atzin wi' jun doctor chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Anin inpenak chi ne'uncanoj ja raj'il ajmaqui' utzc'a chi nqueya' can ja quil quemac, ma eje'e' ta ja ch'ajch'oji' chic ja ne'uncanoj. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","C'ac'ari' quibij chic tre: —Ja c'a discípulo rxin ja Juan Bautista eje'e' tri' tri' nqueban ja rayuno rachbil oración in queri' nqueban ja discípulo kaxin ajoj chakaja' ja rok fariseo pro ¿nak c'a tre tok ma queri' ta nqueban ja radiscípulo atat? ");
INSERT INTO tzjNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ja c'a Jesús arja' xbij chique: —Cani' chique jule' winak ebanon invitar tre jun c'ulbic, ja tok c'a c'o na ja rachi chiquicojol ja nc'ule'e ¿la c'o ta c'a moda ari' xtebij ta chique chi tebana' ayuno, xquixche' ta chique? ");
INSERT INTO tzjNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pro nerila' na jun k'ij ja tok eje'e' xtilasax chiquicojol ja rachi ja nc'ule'e, c'a tokoc'ari' tok xtiqueban ja rayuno. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","C'ac'ari' c'o jun c'ambal tzij xbij chique quewari': —Mta jun nak ta xtilasaj ta jun c'ojbal tre jun tziak c'ac'a xtic'ojbej ta jun tzabuklaj tziak como jari' xa ntz'ila' ja c'ac'a tziak in jun chic, xa ma utz ta neli ja c'ac'a c'ojbal ruq'uin ja tzabuklaj tziak. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","In chakaja' cani' tre vino c'ac'a mta jun nak ta xtuc'ol ta pa tzabuklaj tak c'olbal. Ja wixta queri' nbani ja c'ac'a vino nurak ja c'olbal in ntixi in ntz'iloxi ja c'olbal chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pro ja rjawaxic chi nbani, ja c'ac'a vino nc'oli chipan c'ac'a tak c'olbal in nuto' ri' chi ca'i', nixtac'a vino in nixtac'a c'olbal ntz'ilox ta. ");
INSERT INTO tzjNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jun achi wi nutij ja vino ja ma c'ac'a ta c'ayew chi nel ruc'u'x trij ja c'ac'a vino chanim: —Más na utz ja ma c'ac'a ta, ne'e. Queri' xbij ja Jesús chique tre ja c'ac'a tijonem rc'amonto. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Xuban jutij ja Jesús pa jun xula'nbal k'ij arja' rmajon binem chipan jule' trigo e rachbil ja rdiscípulo. Kas netajini nek'ax chipan ja trigo ja tok quemaj rk'olic rwach ja trigo ja rdiscípulo, quebak pa quek'a' in quetij. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ec'o c'a jule' fariseo, eje'e' quibij chique: —Ja nixtajini emajon rbanic jala' xajan nbani pa tak xula'nbal k'ij. ¿Nak tre tok neban quela'? xeche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ja c'a Jesús quewa' xbij chique ri': —¿La ma esiq'uin ta la'an chipan ja rtzobal Dios ja xuban ja rojer rey David ja tok xuban jutij arja' majtaj rmal rk'ak'anil rupan in ja re rachbil chakaja'? ");
INSERT INTO tzjNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ja c'a xuban, xoc chipan ja rochoch Dios, xuc'am ja caxlanway ja parti'in chwach ja Dios, xutij arja' in xuya' quixin ja rachbil chakaja'. Queri' xuban masqui jari' caxlanway tz'ibtal chipan ja ley xin Dios chi xa queyon sacerdote ja netijowi, ne' chique ja fariseo. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","C'ac'ari' xbij chic chique: —Anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak, pa nuk'a' anin c'o wi' ja nbani chipan ja xula'nbal tak k'ij. Queri' xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pa jun chic xula'nbal k'ij xoqui ja Jesús chipan ja jay xin molbal ri'il in xumaj quitijoxic ja winak. C'o c'a jun achi siquirnak jun ruk'a' riquik'a'. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ja c'a maestro e cachbil ja fariseo eje'e' quimajon rc'ambajaxic ja Jesús, ncajo' nquetz'at ja wi ntzursaj ja rachi pa jun xula'nbal k'ij. Queri' nqueban utzc'a chi nquewil jun ril ja nquichapbej rxin. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pro ja Jesús arja' rotak ja quimajon rch'obic in xbij tre ja rachi ja siquirnak ruk'a': —Catyictaji in catpe'e wawe' chikacojol, ne' tre. Ja c'a rachi yictaji in pe'i chiquicojol. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","C'ac'ari' ja Jesús xbij chique: —Anin c'oli nwajo' nc'waxaj chewe camic. ¿Nak nuya' lugar chake ja ley chi nkaban pa tak xula'nbal k'ij, la ja' chi nkaban ja rutzil owi itzelal? ¿La ja' nuya' lugar chake chi nekato' ja winak owi nekacamsaj? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kas xertz'elwachij canojelal c'ac'ari' xbij tre ja rachi: —Tayuku' ja rak'a', ne' tre, in xuyuk ja ruk'a' in tzuri. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ja c'a reje'e' congana xekuluj rmal, quemaj tzij chibil tak qui', quemaj rcanoxic rij rwach ja Jesús nak nqueban tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chipan ari' tiempo be ja Jesús, jote' chwach jun jayu', xuwil jun lugar ja bar nuban wi' oración. Ni jun ak'a' tzijon ruq'uin ja Dios pan oración. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ja c'a tok sakari xersiq'uij ja rdiscípulo. Ec'o cablajuj xerucha' chique in xbina'aj chique chi e apóstol. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Eje'e' awa' ja rapóstol ri', Simón ja canox chic jun rubi' rmal ja Jesús bina'ax tre Pedro, Andrés ja rch'alal Simón, Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO tzjNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo ja rc'ajol Alfeo, Simón, jun chique ja partido rbina'an Zelote, ");
INSERT INTO tzjNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ja rc'ajol Jacobo, in Judas Iscariote ja jachowi ja Jesús pa quek'a' ja xetzelan rxin. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","C'ac'ari' ja Jesús arja' xule'to chwach ja jayu' e rachbil ja rapóstol. Ja c'a tok kajto chwach ja rwatak'aj tri' pe'e wi' cuq'uin ja rdiscípulo e cachbil jule' chic winak pro congana e q'uiy. Ec'oli ja re aj Jerusalén in ec'oli ja repenak chipan ja jule' chic tinamit ja rec'o pa rcuenta Judea. Ec'oli chakaja' ja repenak chi' tak mar ja c'o pa rcuenta Tiro in pa rcuenta Sidón. Epenak canojel utzc'a chi nquic'axaj ja nbij ja Jesús utzc'a chakaja' chi netzursax tre ja quiyobilal. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ec'oli xetzursaxi chakaja' ja remajtajnak cumal ja ritzel tak espíritu. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Canojel ja winak quimajon rtijic quek'ij chi nquechapoc jutz'it ja Jesús como arja' c'o poder ruq'uin in ja poder nelto ruq'uin in nertzursaj ja winak pro ni canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","C'ac'ari' ja Jesús xertz'elwachij ja rdiscípulo in quewa' xbij ri': —Ixix ja rix tak meba'i' congana qui'il chewe como ewxin c'ari' ja gobierno xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ixix ja nk'ak'an epan congana qui'il chewe como xquixnoj na chi utz. Ixix ja nixtajini nixok'i congana qui'il chewe como xquixtzeben na. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Congana qui'il chewe ixix ja nixtzelax cumal ja winak in maquixc'ul cumal in xa nixtz'uj cumal in nbix chewe cumal chi xa ix itzel tak winak pro congana qui'il chewe ja wi mwal anin tok nba̱n queri' chewe, anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ja tok queri' nqueban chewe quixquicoti pro congana quixquicoti como jari' c'o jun nimlaj rtojbalil ja nyataj na chewe chila' chicaj. Como ja cati't quimama' queri' queban chique chakaja' ja rojer tak profeta ja re xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pro ja c'a rixix ja rix biyoma' jari' congana lawulo' chewe como nixquicoti camic pro jari' jun quicotemal ja xa noc'owi. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ixix ja ni c'o wi' nimak tak wa'im neban camic jari' congana lawulo' chewe como xtetij na wa'al. Ixix ja solo tzeb neban camic jari' congana lawulo' chewe como xquixbison na, xquixok' na. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ja tok nya̱' ek'ij cumal canojel ja winak jari' congana lawulo' chewe como ja cati't quimama' eje'e' queya' quek'ij chakaja' ja rojer tak profeta ja ma e xin Dios ta. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pro ja rixix ja nixtajini neya' ewxquin chwe camic quewa' nbij chewe ri', que'ewajo' ja rec'ulel, ja tok ec'oli ja xa itzel nixquetz'at ja c'a rixix solo utzil tebana' chique, ");
INSERT INTO tzjNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ja tok ec'oli nebin itzel tak tzij chewe ja c'a rixix solo utzlaj tak tzij tebij chique, ja tok ec'oli nixtz'ujuwi nixyok'owi ja c'a rixix tebana' orar pa quicuenta. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ja wi c'o jun xuya' jun k'a' xewey teya'a' lugar tre chi nuya' chic jun chajuparaj. In wi c'o chic jun xumaj chewe ja recamisa ja neban, teya'a' echaqueta tre chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ja wi c'o jun c'oli xc'utuj chewe teya'a' tre in wi na c'o jun c'oli ja xuc'amel chewe ma tech'ojij ta tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","In jun chic, xa nak ta neyarij chique winak chi nqueban chewe queri' c'a tebana' ixix chique chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Como ja wi ixix xa queyon lok' ne'ena' ja lok' ixquina'on ixix ¿la c'o ta c'a jun premio xin Dios ari' nyataj chewe nech'ob ixix? Como ja ritzel tak winak eje'e' chakaja' lok' nequena' ja ne'ajo'n quixin. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","In jun chic, wi xa queyon neban utzil chique ja rebanyon utzil chewe ixix ¿la c'o ta c'a jun premio xin Dios ari' nyataj chewe nech'ob ixix? Como ja ritzel tak winak eje'e' chakaja' nqueban utzil chique ja rebanyon utzil chique eje'e'. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","In jun chic, ja tok c'oli neya' pa kajonem in wi ewotak chi nya̱' rc'axel ¿la c'o ta c'a jun premio xin Dios ari' nyataj chewe nech'ob ixix? Como ja ritzel tak winak eje'e' chakaja' c'oli nqueya' pa kajonem ja tok cotak chi nya̱' rc'axel. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pro ja c'a rixix que'ewajo' ja rec'ulel, tebana' ja rutzil, teya'a' kajonem pro maxta quixocla' il tre ja rc'axel. Ja wi queri' neban jari' c'o jun nimlaj rtojbalil nyataj na chewe in tri' nixk'alajin wi' chi ix ralc'wal ja nimlaj Dios como ja Dios arja' nuban utzil chique ja winak masqui eje'e' ni matiquimaltioxij wi' tre, masqui xa e itzel tak winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ja cani' nuban ja Dios ja retata' arja' congana npokonaj quewach ja winak queri' ta c'a neban ixix, tepokonaj quewach chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Maxta quixoc ix cani' k'etol tak tzij chiquij ja winak utzc'a chi ja Dios matuk'et tzij chewij ixix chakaja'. Maxta tec'utuj chiquij ja winak chi nquetoj na ja il mac ja nqueban utzc'a chi ja Dios matibij chewe chi netoj na ja il mac ja neban ixix. Que'ecuyu' ja winak. Ja wi ne'acuy ja c'a Dios arja' nixrucuy ixix chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tesipaj chique ja winak ja nc'atzin chique. Ja wi nesipaj chique jari' nya̱' rjil rc'axel chewe. Pro ja rjil rc'axel ja xtiya' chewe queri' rbanic ja cani' nuban jun c'ayinel ja tz'akat npajoni, bien nuyic, bien nupitz', congana npulsaj chi utz ja rpajbal. Queri' nbij chewe como ja wi q'uiy ja nesipaj jari' q'uiy ja necochij ixix tre ja Dios owi xa ma q'uiy ta ja nesipaj jari' xa ma q'uiy ta ja necochij ixix tre chakaja'. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","C'ac'ari' xbij jun c'ambal tzij chique: —Jun moy wi nrc'aj chic jun rach moy xa netzakel pa jul chi e ca'i'. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mta jun discípulo ja más ta na nrotakij chwach ja cani' rotak ja rmaestro. Pro jun discípulo xa nak ta chi discipulo'al ja tok bien rtijon chic ri' xa queri' rna'oj neli ja cani' rna'oj ja rmaestro. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Nak tre tok neya' cuenta tre jun ti ril nuban ja rewach'alal pro mateya' cuenta tre jun nimlaj ewil neban ixix? Ja tok neban queri' jari' cani' neya' cuenta tre jun ti rc'utal che' ja c'o parwach ja rewach'alal pro mateya' cuenta tre jun nimlaj che' ja c'o panewach ixix. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","In chakaja' ¿nak moda nebij tre ja rewach'alal: —Wach'alal, taya'a' lugar chake chi nkaya' jun consejo chawe tre ja il mac ja c'o pan ac'aslemal, nixche' tre, pro xa mateya' cuenta tre chi más na nim ja il mac c'o pan ec'aslemal ixix? Ja queri' xa caca' epalaj ja neban. Ja wi newajo' neya' consejo tre ja rewach'alal rjawaxic nabey chi neya' can ja ritzelal ja c'o chipan ja rec'aslemal ixix utzc'a chi nixcowini neya' utzlaj tak consejo tre ja rewach'alal. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Queri' nbij chewe como mta jun utzlaj che' xtuya' ta itzel rwach nixtac'a ja ritzel che' xtuya' ta rwach utz. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Como ja che' chijujunal rumac ja rwach nuya' chewi' tok notakixi nak chi che'al. Ta c'a ja q'uix mta moda xtiwachij ta higo nixtac'a rxulquiej xtiwachij ta uva. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jun utzlaj achi utzil ja rc'olon pa ranma in tok ntzijoni utzil rc'amonto ja nbij. Jun itzel achi xa itzelal ja rc'olon pa ranma in tok ntzijoni xa itzelal rc'amonto ja nbij. Queri' nbij chewe como ja nojnak pa ranma jun winak jari' nelto pa ruchi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Nak tre tok quewa' nebij chwe ri': —Kajaw, Kajaw, kas nixche' chwe, pro xa mateban ja nbij chewe chi neban? ");
INSERT INTO tzjNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Xa nak ta ja nepi wq'uin ja wi nquic'axaj ja nmajon rbixic in wi nquinimaj ja nbij chique chi nqueban eje'e' quewa' quibanic ri', ");
INSERT INTO tzjNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","e junan ruq'uin jun achi xuban jun rochoch, xuc'ot na ja bar nutic wi' rsimiento'il in parwi' abaj xtz'uba' wi'. Ja c'a tok xumaj jun nimlaj k'ekaljab q'uiyi ja rkanya', lawulo' ban tre ja jay rmal pro ma xbe ta pa tok'ulew como utz rtiquic banon. ");
INSERT INTO tzjNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pro ja c'a winak ja chaka nquic'axaj ja ntzobal in wi matiqueban ja nbij chique chi nqueban eje'e' e junan ruq'uin jun achi xuban jun rochoch pro mta rsimiento'il, xa parwi' ulew xtz'uba' wi'. Ja c'a tok q'uiyi ja rkanya' lawulo' ban tre ja jay rmal, chanim be pa tok'ulew, xajutij yojtaji ja jay. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ja Jesús tok tzuri tzij rmal cuq'uin ja winak be pa Capernaum. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","C'o c'a jun capitán quixin soldado, c'o jun rmoso yawa'. Ja c'a moso arja' congana lok' nna̱' rmal ja capitán in xajalal maja'n ticami. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ja c'a capitán arja' tok xekaj rbixic ja Jesús ruq'uin ec'o jule' anciano e aj Israel xerutakel chi nequic'utuj jun utzil tre ja Jesús chi npeti nurtzursaj ja rmoso. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ja c'a tok xe'ekaj ruq'uin ja Jesús congana quemaj rc'utuxic jun utzil tre: —Ja capitán ni yatal wi' tre chi nabana' ja rutzil tre ja kamajon rc'utuxic chawe. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Como arja' congana nokrajo' ja rok tinamit Israel. Arja' banyon ja jay xin molbal ri'il ja bar nkamol wi' ki' chi rc'axaxic ja rtzobal Dios, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","C'ac'ari' xebe, cachbilajel ja Jesús. Ja c'a capitán tok ec'o chic ja Jesús chinakaj ja rochoch arja' xerutakel jule' ramigo chi rc'ulic, quewa' xbijel tre ri': —Wajaw, ma taban ta molestar awi' mwal, atat janila nim ak'ij, ma yatal ta chwij chi xcatoc ta chipan ja wochoch ");
INSERT INTO tzjNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","in nixtac'a yatal ta chwij chakaja' ja xinbe ta awq'uin, xar ja nwajo' chawe, tabij chi ntzuri ja nmoso in wotak chi xa ruq'uin ari' ntzuri. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Queri' nbij chawe como anin bien wotak nak rbanic ja tok natban mandar. Ec'oli ja nebano mandar wxin anin in chakaja' ec'oli soldado pa nuk'a' anin chi nenuban mandar. Ja tok nbij tre jun chi: —Cateli, ninche' tre, jari' ni nel wari'. Ja c'a wi nbij chi: —Catajo', ninche' tre jun chic, jari' ni npi wari'. Ja c'a wi nbij tre ja moso ja c'o pa nuk'a' chi: —Tabana' ja wari', ninche' tre, jari' ni nuban wi'. Queri' ja xbijel ja capitán tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ja c'a Jesús congana c'asc'o'i xc'axaj ja tzij ja bixel tre rmal ja capitán. Ja tok c'axtaj rmal xuya' vuelta in como ec'oli winak ja retran trij quewa' xbij chique ri': —Anin nbij chewe, ja capitán arja' más chi na k'axnak ja yukulbal ruc'u'x wq'uin chewach ixix ja rix wach tak aj Israel, nixtac'a c'o ta jun chewe nwilon ta ja queri' ta ja yukulbal ruc'u'x wq'uin ja cani' rxin arja', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ja c'a winak ja retakonel rmal ja capitán eje'e' xemelojto. Ja tok quetz'at ja moso ma yawa' chi ta, utz chic. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ja c'a pa jun chic k'ij ja Jesús be chipan jun tinamit Naín rubi'. E q'uiy chique ja rdiscípulo xerachbilajel in congana e q'uiy ja winak xetre'el trij. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ja c'a Jesús tok xekaj chinakaj ja bar natoc wi' chipan ja tinamit ec'o jule' winak xerutz'at, c'o jun camnak nequimuku'. Ja nemuki ral jun ixok ti malca'n in ni xarwari' jun ti ral pro cami. Ja rixok e q'uiy ja rach tak aj tinamit erachbilan tre ja mukuninem. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ja c'a kajaw Jesús tok xutz'at ja rixok congana xpokonaj rwach: —Ma catok' ta, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","C'ac'ari' xuchap ja ch'atan che' ja bar telen wi' ja camnak. Ja c'a winak ja retelyon rxin ja camnak eje'e' xepapo'i. C'ac'ari' ja Jesús quewa' xbij tre ja camnak ri': —Joven, camic nbij chawe, catyictaji. Queri' xbij tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ja c'a rala' c'astaji, tz'abe' nojoj in xumaj tzij. C'ac'ari' ja Jesús xujach can tre ja rute'. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ja c'a winak congana quixbej qui' rmal ja bantaji pro canojelal in quemaj rya'ic ruk'ij ja Dios: —Jala' jun nimlaj profeta xin Dios ja winakarnak chikacojol camic. Ja Dios camic rtakonto jun To'onel chikacojol ja rok tinamit rxin, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ja milagro ja xuban ja Jesús jari' xel rbixic nojel nat nakaj chipan ja departamento Judea in xel rbixic chakaja' nojel tinamit ja c'o chinakaj ja departamento. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nojel c'awa' ja bantaji ri' xecho̱l chwach ja Juan Bautista rmal ja rdiscípulo arja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ja c'a Juan Bautista arja' ec'o ca'i' chique ja rdiscípulo xersiq'uij, xerutakel ruq'uin ja Jesús in quewa' xbijel chique ri' chi nequic'axaj tre: —¿La atat ja rat Cristo ja bitajnak can chi natpi na owi nkaybej chi na jun? ne'el chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ja c'a tok xe'ekaj ruq'uin ja Jesús quewa' quibij tre ri': —Ja Juan Bautista arja' okrtakonto awq'uin, quewa' rbinto chawe ri': —¿La atat ja rat Cristo ja bitajnak can chi natpi na owi nkaybej chi na jun? ne'to chawe, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ja c'a Jesús ni jari' hora xumaj quitzursaxic jule' winak ja rec'o tri' pro e q'uiy ja winak. Xertzursaj ja yawa'i' masqui emajtajnak rmal c'ayewalaj tak yobil, xeruto' ja rec'o pa quek'a' itzel tak espíritu in e q'uiy ja moya' xujak quewach chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","C'ac'ari' xbij chique ja ca'i' discípulo ja re xin Juan Bautista: —Jix, jebij tre ja Juan nojel ja retz'aton camic in nojel ja rec'waxan. Ja moya' neca'y chic. Ja maquecowini nebini nebin chic. Ja rec'o itzel tak ch'a'c chiquij xetzuri. Ja tacona' nquic'axaj chi tzij. Ja camnaki' xec'astaji. Ja meba'i' majtajnak rbixic chique ja utzlaj tzij xin totajem ja rtakonto ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","In tebij tre ja Juan chakaja' chi congana qui'il chique ja winak ja ma junwi' ta nquena' rmal ja samaj ja nintajini nban. Queri' tebij tre, ne'el ja Jesús chique ja discípulo rxin ja Juan Bautista. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ja c'a Jesús tok ebenak chic ja ca'i' discípulo c'ac'ari' xumaj tzij cuq'uin ja winak tre ja Juan Bautista: —Ja Juan ja tok q'ueje' pa tak lugar ja kas talan wi' ¿nak c'a tre tok xixbe ruq'uin chi rtz'atic, la rmal ja Juan chi xa puersa cani' jun aj nsi̱l rmal xcomel? ");
INSERT INTO tzjNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Nak c'a tre tok xixbe ruq'uin chi rtz'atic, la rmal ja Juan chi congana rwekon ri' tre buen tak tziak ja nimak rjil? Pro ixix bien ewotak chi ja winak ja necojo buen tak tziak ja nimak rjil in nquelok' xa nak ta c'o quigana nquelok' jari' pa nimak tak jay quixin rey neq'ueje' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Nak c'a tre tok xixbe ruq'uin chi rtz'atic, la rmal ja Juan chi arja' jun profeta xin Dios? Jari' ni katzij wi' chi profeta pro ma ruyon ta ja chaka ta profeta ocnak wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Queri' nbij chewe como ja Juan arja' chomarsani ja bey rxin ja Cristo ja cani' tz'ibtal can chipan ja rtzobal Dios quewari': —Anin ntakel ja ntajko'm chi nnabeyaj chawach utzc'a chi arja' nerchomarsaj ja rabey. Queri' bitajnak can rmal ja Dios tre ja Cristo. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Anin nbij chewe chi mta jun profeta q'uejenak ta wawe' chwach'ulew ja nim ta ruk'ij chwach ja Juan Bautista pro ja chipan ja gobierno xin Dios jun winak masqui xa ti sencillo pro más chi na nim ruk'ij arja' chwach ja Juan, ne'e ja Jesús chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","E q'uiy ja winak e cachbil ja molol tak impuesto tok quic'axaj ja xbij ja Jesús quemaj rya'ic ruk'ij ja Dios como eje'e' ebanon bautizar rmal ja Juan. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pro ja c'a fariseo e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios eje'e' ma xcajo' ta xeba̱n ta bautizar rmal ja Juan, jari' xa nquech'a' ja rvoluntad Dios pa tak quic'aslemal. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","C'ac'ari' xumaj chic jutij tzij ja kajaw Jesús: —¿Bar c'a nixnjunsaj wawa' ja rix tinamit Israel? ");
INSERT INTO tzjNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cuq'uin ca'i' moc ac'ala' nixnjunsaj wi' ja quimajon tz'anem pa tak c'aybal. Jun moc nquerak quechi' chiquij ja jun moc chic: —Ajoj kaban ja música xin quicotemal pro ja rixix mta xajoj xeban, ma xixquicot ta. In kaban chic jun xin bis in nixtac'a xixbison ta chakaja', ni majun nak ta newajo', neche'e ja rac'ala' chique ja jun chic moc. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ja c'a rixix nixnjunsaj cuq'uin ja rac'ala' ja ni majun nak ta ncajo' como ja Juan Bautista tok arja' peti ma kas ta wa' je'e cuq'uin ja winak in mta vino xutij in rmalari' tok xebij tre chi c'o jun itzel espíritu ocnak tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","In xinpi chic anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak, xinwa' cuq'uin ja winak in c'oli vino xintij in rmalari' xebij chwe chi xa in mun in xa in tijol vino in xa e wamigo ja molol tak impuesto e cachbil ja jule' chic ajmaqui'. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pro ja c'a ralc'wal Dios eje'e' bien nch'obtaj cumal canojelal chi ja Juan Bautista rna'oj Dios ja nucoj in queri' chwe anin, rna'oj Dios ncoj chakaja', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","C'o c'a jun achi arja' fariseo xuban invitar ja Jesús pa rochoch chi newa' ruq'uin. Ja c'a Jesús be ruq'uin in tok xekaji xe'oc pa mesa. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chipan c'a ri' tinamit tri' c'o wi' jun ixok itzel rc'aslemal. Ja c'a rixok tok xc'axaj chi ja Jesús rmajon wa'im pa jay ruq'uin ja fariseo be ruq'uin, rc'amonel jule' ak'om qui' rxula', rc'amonel chipan jun rc'olibal ja banon rbanic, alabastro ocnak. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ja c'a tok xekaj ruq'uin ja Jesús xuque'e in xumaj ok'ej. Ja c'a riya'l rwach congana kaj chi rkan ja Jesús in ja rsamal rwi' jari' xsubej. Ja tok sutaj rmal c'ac'ari' xtz'ubaj ja rkan in xuya' ja rak'om trij. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ja c'a fariseo ja banyon invitar rxin ja Jesús tok xutz'at ja xuban ja rixok quewa' xuch'ob kaj pa ranma ri': —Ja Jesús wixta katzij chi profeta xin Dios rotak ta c'ari' nak rbanic ja jun ixok le' ja ntajini nuchap rkan. Como jala' jun ixok le' xa itzel rc'aslemal. Queri' xuch'ob kaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","C'ac'ari' bix tre rmal ja Jesús: —Simón, camic c'o jun tzij nwajo' nbij chawe ri', ne'xi. —Utz c'ari' Maestro, tabij c'a chwe, ne'e ja Simón. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","C'ac'ari' bix chic tre rmal ja Jesús: —C'o jun achi ec'o ca'i' achi'i' ja c'o quec'as ruq'uin. Jun, jo'o' ciento ja ruc'as, ja c'a jun chic cincuenta. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ja c'a tok ma xecowin ta quetoj ja quec'as mta ban chique, xecuyi rmal ja rajaw pwok. Camic Simón, tabij c'a chwe ¿nak chique ja ca'i' achi'i' ja más najo'n chic rxin ja rajaw pwok? ne'xi ja Simón. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Ja nbij anin jari' ja más nim ruc'as, ne' tre. —Queri', ne'x rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","C'ac'ari' ja Jesús xuya' vuelta, nutz'at ja rixok in quewa' xbij chic tre ja Simón ri': —Tatz'ata' mpe' ja rixok ri'. Atat tok xinocto pan awochoch mta ch'ajbal wakan xaya' chwe chi nc'ulic pro jawa' ixok ri' arja' xuch'aj wakan chi riya'l rwach in rsamal rwi' xsubej. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Atat ma xatz'ubaj ta nuchi' chi nc'ulic pro jawa' ixok ri' arja' chijutij rmajon rtz'ubaxic ja wakan. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Atat nixtac'a aceite xaya' ta pa nwi' chi nc'ulic pro jawa' ixok ri' arja' xuji' wakan chipan jun ak'om ja congana qui' rxula'. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Rmalc'ari' ja tok nbij chawe, ja rixok masqui congana il mac rbanon pro bien k'alaj chi cuytajnak chic nojelal como congana ninrajo'. Pro ja wi xa ma q'uiy ta ja rawil amac ja cuytajnak jari' ma kas ta nwinakari ja rajoben ri'il pan awanma, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","C'ac'ari' xbij tre ja rixok: —Cuytaji ja rawil amac, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ja c'a jule' chic invitado ja rec'o pa mesa ruq'uin ja Jesús eje'e' quemaj tzij chibil tak qui': —¿Nak c'a ocnak wi' ja Jesús le' chewi' tok nbij chi nucuy ja il mac chakaja'? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ja c'a Jesús xbij chic tre ja rixok: —Ja yukulbal ac'u'x ja c'o wq'uin jari' xatto'owi. Camic utz chic natbe, catquicoti, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Xuban jun ca'i' k'ij xumaj chic jutij bey ja Jesús, be pa tak tinamit in pa tak aldea chijujunal, nuya' rbixic ja rtzobal Dios in nuch'ob chiquewach ja winak ja utzlaj tzij ja nuc'ut chikawach nak rbanic ja gobierno xin Dios. Xerachbilajel ja cablajuj apóstol. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ec'o jule' ixoki' xerachbilajel chakaja'. Ja c'a rixoki' eje'e' nabey emajtajnak rmal yobil in ec'o pa quek'a' itzel tak espíritu pro etzursan chic rmal ja Jesús. Jun ja rixok María rubi' ja c'o chic jun rubi' Magdalena ne'xi. Ja c'a María Magdalena arja' e wuku' itzel tak espíritu ja xelasax tre rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jun chic, Juana rubi', rxjayil Chuza. Ja c'a Chuza arja' nbano cuenta rxin ja meba'il rxin ja rey Herodes. Jun chic, Susana rubi', in c'a ec'o na más chakaja'. C'oli quimeba'il ja nquitobej ja Jesús chipan nak ja c'o rjawaxic tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Congana e q'uiy ja winak xurquimolo' qui' ruq'uin ja Jesús, nojel tak tinamit epenak wi', tokori' c'o jun c'ambal tzij xbij chique quewari': ");
INSERT INTO tzjNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—C'o jun ajticola' be pa ticoj tijco'm pa rchenoj. Ja c'a tok xekaji xumaj rchicaxic ja rija'tz. C'o c'a kaj pa bey jari' pak' can chakan cumal winak in tij cumal tz'iquin. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","C'o chic jule' kaji ja bar c'o wi' abaj. Ja c'a tok xelto chakiji chanim como mta rch'abakil rpan ja rulew. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","C'o chic jule' kaj pa tak q'uix in tok xelto xumaj q'uiyem rachbil ja q'uix. Ja c'a tok q'uiswani camsaxi ja tijco'm rmal q'uix. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pro c'o chic jule' kaj pan utzlaj ulew in wachini chi utz, ja jujun chirwach ija'tz xuya' jujun ciento rwach, ne'e ja Jesús chique. Ja c'a tok bitaj rmal ja tzij ri' cow tzijoni: —Bien c'a tewasaj ena'oj trij ja c'a xinbij kaj chewe ri', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","C'ac'ari' ja rdiscípulo quibij tre: —Tach'obo' chikawach nak rbanic ja jun c'ambal tzij ja c'a xabij kaj, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ja c'a Jesús quewa' xbij chique ri': —Ja rixix yatajnak chewe chi newotakij nak rbanic ja rawatal je'e tre ja gobierno xin Dios pro ja c'a jule' chic winak pa c'ambal tak tzij nintzijon wi' cuq'uin utzc'a masqui c'o quewach pro matiquetz'at ja nc'u̱t chiquewach in masqui c'o quixquin pro matich'obtaj cumal ja nbix chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Camic nch'ob c'a chewach nak rbanic ja c'ambal tzij. Ja rija'tz jari' tibij tzij ja rtzobal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ja kaj pa bey jari' tibij tzij chi ec'oli winak ja nquic'axaj ja rtzobal Dios pro npeti ja diablo nlasajel ja rtzobal Dios pa tak canma utzc'a matiquinimaj utzc'a matiquewil ja totajem xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ja kaji ja bar c'o wi' abaj jari' tibij tzij chi ec'oli winak ja nquic'axaj ja rtzobal Dios in nquinimaj, congana nequicot rmal. Pro eje'e' e cani' jule' tijco'm ja mta rc'amal, xa ti jurata nquinimaj. Ja c'a tok xterila' ja c'ayewalaj tiempo xa nqueya' can. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ja kaj pa tak q'uix jari' tibij tzij chi ec'oli winak ja nquic'axaj ja rtzobal Dios pro tok nq'uiswani xa ja' nquibisoj chic ja xin rwach'ulew cani' tre meba'il in cani' tre quicotemal, cani' nejik' chipan. Eje'e' xa e cani' jule' tijco'm ja mta rwach nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pro ja c'a rija'tz ja kaj pan utzlaj ulew jari' tibij tzij chi ec'oli winak ja nquic'axaj ja rtzobal Dios in nquec'ol pa tak canma pro jun utzlaj anma ja mta engaño rc'an. Eje'e' nquecoch' ja npi chiquij in tok nq'uiswani buena nwachini ja rutzil pa tak quic'aslemal. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ni majun nak ta nbanowi xtutzij ta jun candil in xtijupba' ta c'a jun bojo'y parwi' nixtac'a xtuya' ta xe' ch'at chakaja'. Pro ja c'a nbani, ja tok ntzijtaji jun candil ncanox jun rc'olibal ja bar nya̱' wi' utzc'a pa sak neq'ueje' wi' ja winak ja ne'oc pa jay. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Queri' nbij chewe como nojel ja rawatal je'e jari' nel na pa sakil in nojel ja ma k'alajinnak ta je'e jari' nerila' na jun k'ij tok xtik'alajini, notakix na. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Rmalc'ari' tok nbij chewe, bien teya'a' ewxquin tre ja remajon rc'axaxic como ja winak ja c'o je'e yatajnak chique eje'e' nyataj na más chique. Ja c'a winak ja mta yatajnak chique pro nquech'ob chi c'oli jari' nlasax chique. Queri' xbij ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","C'ac'ari' xe'urkaji ja rch'alal ja Jesús cachbil rute' pro maquecowini ne'oqui ja bar c'o wi' arja' como congana e q'uiy ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","C'ac'ari' bix tre ja Jesús: —Pakasa' rate' in ja re awach'alal ec'o chwa jay, natquisiq'uij, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ja c'a Jesús quewa' xbij chique ri': —Ja nec'axani ja rtzobal Dios in nquinimaj ja nbij chique chi nqueban eje'e' c'ari' e'ocnak nute' in e'ocnak wach'alal, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Xuban jutij ja Jesús xoc pa lancha e rachbil ja rdiscípulo: —Jo' chajuparaj ya', ne' chique, in xebe. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kas quimajon binem parwi' ja ya' ja tok kaj chi waram ja Jesús. Chaka c'a jalal ja tok jaktajto jun nimlaj ik' chiquij. Ja c'a lancha ntajini nnoji ja ya' chipan, ec'o chic pa rc'ayewal. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ja c'a discípulo eje'e' quec'as ja Jesús: —Maestro, Maestro, camic nokcami, nokbe pa ya', xeche' tre. Yictaji ja Jesús, xuk'il ja ik', xuk'il ja ya' chakaja'. C'ac'ari' cami ja ik' in ni sile'e ja ya'. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","C'ac'ari' xbij chique: —¿Bar c'a xoc wari' ja yukulbal ec'u'x wq'uin? ne' chique. Ja c'a reje'e' congana quixben qui', congana c'asc'o'i quetz'at ja bantaji in quemaj rbixic chibil tak qui': —¿Nak rbanic c'ala' ja rachi le'? Como arja' nuban mandar ja ik', nuban mandar ja ya' in nnimax taka'an rmal, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Xe'ekaj c'a chipan jun lugar Gadara rubi' ja c'o chajuparaj ya' tre ja departamento Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ja c'a Jesús tok xeli ja pa lancha c'o jun achi xekaj ruq'uin. Ja c'a rachi c'o chic tiempo e'ocnak jule' itzel tak espíritu tre. Ni mta wi' rtziak nucoj in matiq'ueje' pa rochoch chakaja', xa pa comsanto nq'ueje' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ja c'a tok xutz'at ja Jesús xumaj rakic ruchi', xuque' chwach in cow tzijoni, quewa' xbij tre ri': —Jesús, atat ja rat Ralc'wal ja nimlaj Dios ¿nak nawajo' chwe? Tabana' jun utzil, maxta taban pokon chwe, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Queri' xbij tre como ja Jesús arja' ntajini nuban mandar ja ritzel espíritu ja rocnak tre ja rachi chi nelel pa ranma. Ja c'a rachi q'uiylaj mul q'uejenak pa ruk'a' ja ritzel espíritu in c'o je'e bac'on ruk'a' rkan pa cadena pro ni ma c'ayew ta nuban tre nq'uiokpij in nc'amarel rmal ja ritzel espíritu chipan ja chakijlaj ulew. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ja c'a Jesús xbij tre: —¿Nak c'a abi'? ne' tre. —Anin in Legión, ne'xi rmal ja rachi. Queri' rubi' xbij como congana e q'uiy jule' itzel tak espíritu e'ocnak tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ja c'a ritzel tak espíritu eje'e' congana quecoj ja Jesús pa ch'a'oj chi maquerutakel chipan ja nimlaj jul ja c'a c'a nat nekaj wi' xe' ulew chipan ja nimlaj k'ekumal. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ec'o pon c'a jule' ak congana e q'uiy quimajon wa'im pa tak k'ayis. Ja c'a ritzel tak espíritu congana quecoj ja Jesús pa ch'a'oj chi nuya' lugar chique chi ne'oc pa quicuerpo ja ak. Ja c'a Jesús xuya' lugar chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","In queri' queban, xe'el pa ranma ja rachi, xe'oc pa tak quicuerpo ja ak. Ja c'a ak chaka maril xe'oqui ja ritzel tak espíritu chique, eje'e' quemaj c'amc'oj canim, xebe, xexule' chwach jun jayu' congana tiquitic, xebe c'a pa ya' in tri' xejik' wi' canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ja c'a chajinel quixin ja ak tok quetz'at ja bantaji xe'anmaji, xebe chipan ja tinamit in pa tak aldea chakaja', xequicholo' nojel ja bantaji. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ja c'a winak tok quic'axaj eje'e' xepeti chi nurquitz'ata' ja bantaji. Ja tok xe'urkaji ja bar c'o wi' ja Jesús quetz'at ja rachi ja xelasaxel ja ritzel tak espíritu tre, arja' tri' tz'ubul wi' chwach ja Jesús, c'o chic ja rtziak rcojon, tz'akat chic ja rpensar. Ja c'a winak tok quetz'at congana quixbej qui' rmal. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","C'ac'ari' ja xetz'atowi ja bantaji eje'e' quemaj rcholic chiquewach ja jule' chic winak nak rbanic ja tok tzuri ja rachi ja rec'o jule' itzel tak espíritu tre nabey. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Canojel ja winak ja raj Gadara eje'e' congana quic'utuj tre ja Jesús chi matiq'ueje' chic más chiquicojol como congana quixben qui'. Ja c'a Jesús xoc chic chipan ja lancha chi nmeloji. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ja c'a rachi ja xelasaxel ja ritzel tak espíritu tre xbij tre ja Jesús: —Tabana' jun utzil, taya'a' lugar chwe chi nintre' chawij chijutij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Mejor ja naban, jat chi awochoch, jabij chique ja winak chi janila jun nimlaj samaj xuban ja Dios chipan ja rac'aslemal, ne'xi rmal ja Jesús. C'ac'ari' be ja rachi cuq'uin ja rach tak aj tinamit in xumaj rbixic chique canojelal ja nimlaj samaj ja xuban ja Jesús chipan ja rc'aslemal. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ja c'a Jesús tok meloj chic jutij ja chajuparaj ya' congana qui'il rc'ulic bani cumal ja winak como ayben cumal canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","C'ac'ari' c'o jun achi peti, Jairo rubi', arja' jun chique ja jefe rxin ja jay xin molbal ri'il ja bar nc'axax wi' ja rtzobal Dios. Ja c'a Jairo tok xurkaj ruq'uin ja Jesús xuque' chwach in congana xc'utuj jun utzil tre chi nbe chi rochoch ");
INSERT INTO tzjNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","como c'o jun rme'al camíc nuban in ni xarwari' ti jun, c'o la cablajuj rjuna'. Be c'a ja Jesús pro congana e q'uiy ja winak nquepitz' qui' trij ebenak pa rochoch ja Jairo. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","C'o c'a jun ixok yawa' ja c'o chiquicojol ja winak, tuban cablajuj juna' ni c'o wi' je'e quic' nel tre. Ja rixok rq'uison chic nojel ja c'o ruq'uin chi rk'omaxic ri' cuq'uin doctori' pro majun nak ta cowin ta tzursan ta rxin. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ja c'a xuban ja rixok xa jani' tiloc más trij ja Jesús. Ja c'a tok xekaj ruq'uin xuchapoc jutz'it ruchi' ja rtziak. Chaka maril xuchapoc rtziak ja Jesús ni caje'e ja quic' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ja c'a Jesús xbij: —¿Nak xinchapowi? ne'e. —Ma anin ta, ma anin ta, xeche'e ja winak canojelal. Ja c'a Pedro in ja re rachbil eje'e' quibij tre ja Jesús: —Pro Maestro ¿la matatz'at la'an chi congana winak quipitz'on qui' chawij in nquemin qui' chawij chakaja' chewi' nak tre tok nabij: —Nak xinchapowi, taka'an natche'e? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","—Wotak chi c'o jun xinchapowi como xinna' chi c'oli ja poder xel chwe, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ja c'a rixok tok xutz'at chi maticowin chic nwawaj ja xuban peti, congana nbirboti rumac ja xbeben ri'il, xuque' chwach ja Jesús in xumaj rbixic tre nak tre tok xuchapoc ja rtziak, pro ni chiquewach canojel ja winak xbij wi' tre. In xbij tre chakaja' nak rbanic ja tok ni jari' hora tzuri. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Bix tre rmal ja Jesús: —Nme'al, ja yukulbal ac'u'x wq'uin jari' xattzursani. Camic utz chic natbe, catquicoti, ne'xi ja rixok. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ja Jesús c'a rmajon na tzij ja tok c'o jun xurkaji, elnakto pa rochoch ja jefe rxin ja jay xin molbal ri'il, quewa' xbij tre ja jefe ri': —Jairo, ja rame'al cami, ma taban chi ta molestar más ja Maestro, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ja c'a Jesús tok chaka maril xc'axaj ja bix tre ja Jairo quewa' xbij chic tre ri': —Ma taxbej ta awi', ja naban, tiyuke' ac'u'x wq'uin in ja rame'al can nc'astaji, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ja tok xe'ekaj chi rochoch ja Jairo ja Jesús arja' ma xuya' ta lugar chique ja winak chi xe'oc ta pa jay ruq'uin. Ja xe'oc chipan xa queyon ja Pedro, ja Jacobo in Juan e cachbil ja rtata' rute' ja xtan. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Canojel ja winak quimajon ok'ej in congana síc' nqueban. Ja c'a Jesús xbij chique: —Ma quixok' ta como ja xtan ma camnak ta, xa waram rbanon, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pro ja reje'e' xa quitzebej como bien cotak chi cami ja xtan. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","C'ac'ari' ja Jesús xuchap chi ruk'a' ja camnak in quewa' xbij tre ri': —Catyictaji xtan, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ja c'a xtan melojto in ni jari' hora yictaji. C'ac'ari' ja Jesús xbij chique chi nqueya' rway. ");
INSERT INTO tzjNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ja c'a rtata' rute' eje'e' congana c'asc'o'i quetz'at ja milagro ja xuban ja Jesús pro arja' xbij chique: —Ni majun bar ta tebij wi' ja c'a bantaji ri', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","C'ac'ari' xersiq'uij ja cablajuj discípulo in xuya' chique chi c'o quek'a' chique canojel ja ritzel tak espíritu chi necowini nequiwasajel chique ja winak in xuya' chique chakaja' chi necowini nequitzursaj yawa'i'. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","In xerutakel chi nequiya'a' rbixic ja gobierno xin Dios utzc'a chakaja' chi ne'equitzursaj ja yawa'i'. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Quewa' xbijel chique ri': —Ni majun nak ta nec'amel ja tok nixbe, nixtac'a nec'amel ta ech'ame'y, nixtac'a emaleta, nixtac'a eway, nixtac'a epwok in ni xa ja wari' ja recamisa nec'amel ja recojon, ma ca'i' ta. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Xa nak ta chi jayil xquixoc wi' tri' nixq'ueje' wi', c'a tokori' neya' can ja tok nixbe chic cha jun chic tinamit. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","In xa nak ta ja maquec'ulu ewxin, ja c'a tok nixelto chipan ja quitinamit tequiraj can ja pokok ja c'o pan ewakan. Queri' neban jari' retal chi eje'e' nquetij na ja rpokonal rmal ja matiqueya' quixquin tre ja nebij chique. Queri' xbijel chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ja c'a cablajuj discípulo eje'e' xe'elel, xebe pa tak aldea pro nojel tak aldea, quemaj rbixic ja utzlaj tzij xin Jesucristo in quemaj quitzursaxic ja yawa'i' chakaja'. Queri' queban xa bar ta tri' xe'ekaj wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ja Jesús nojel ja ntajini nuban xekaj rbixic ruq'uin ja gobernador Herodes. Ja c'a Herodes arja' kas nk'isaj ri' chi rch'obic nak ja kas mero nbanowi nojel awa' wari' ja nekaj rbixic ruq'uin. Como ec'oli nebini chi Juan Bautista ja nbanowi como eje'e' nquibij chi c'astajnakto chic ja Juan Bautista chiquicojol camnaki'. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ec'o chi c'a jule' nebini chi ja camnak Elías ja nbanowi como eje'e' nquibij chi rc'utun chic ri' ja rElías chiquewach ja winak. In ec'o chic jule' nebini chi c'o jun chique ja rojer tak profeta ja c'astajnakto chic in arja' nbanowi, neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pro ja Herodes arja' quewa' xbij ri': —Ja Juan jari' anin wa'an xinyo' orden chi lasax rwi' pro nak la chi achi'al ja nbanowi nojel awa' wari' ja nurkaj rbixic wq'uin. Queri' xbij in xumaj rch'obic nak nuban utzc'a chi nutz'at ri' quewach ruq'uin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ja c'a cablajuj apóstol tok xemelojto quechol chwach ja Jesús nojel ja xequibana'. Ja c'a Jesús xeruc'amel, xequiyonaj qui' pa jun lugar ja kas talani ja bar ma ec'o ta wi' winak. Jari' lugar pa rcuenta ja tinamit Betsaida c'o wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ja c'a winak tok xekaj rbixic cuq'uin chi be ja Jesús xebe eje'e' chakaja', xequiwila'. Ja c'a Jesús tok xe'ekaj ruq'uin arja' xeruc'ul, xuya' rbixic chique nak rbanic ja gobierno xin Dios in xertzursaj ja yawa'i' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ja c'a tok xuban hora xepeti ja cablajuj apóstol in quewa' quibij tre ja Jesús ri': —Mejor, que'ataka'el ja winak pa tak tinamit in pa tak aldea ja c'o chikanakaj utzc'a chi nequicanoj quiposada in nequilok'o' queway como ja lugar ja rokc'o wi' ri' congana talani, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","—Ixix nixyo' chique ja nquetij, xeche'x rmal. —Pro mta nak ta kac'amonto xarwari' jo'o' rkan caxlanway in e ca'i' cakan ch'u'. ¿La nokbe ta na c'a ajoj chi rlok'ic queway ala' winak canojel le'? ");
INSERT INTO tzjNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Queri' quibij tre como ja xa queyon achi'i' ec'o la jo'o' mil. —Tebij chique ja winak chi quetz'abe'e pro pa tak moc ncuc'aj qui', e cincuenta ja jujun moc, ne' chique ja rapóstol. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Queri' queban, xekaji canojelal chi tz'ubulem. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","C'ac'ari' xuc'am ja jo'o' rkan caxlanway e rachbil ja ca'i' cakan ch'u', ca'y chicaj in xmaltioxij tre ja Dios. Xuwech' ja caxlanway, xujach chique ja rdiscípulo chi eje'e' nqueya' chic chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Xewa'i pro ni canojelal in xenoji chi utz. Ja c'a caxlanway rachbil ch'u' mol ruchi' ja totaji, cablajuj chacach xuban. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Xuban jutij ja Jesús ruyon ryonan ri', ntajini nuban ja roración. Ec'oli ja rdiscípulo ruq'uin in quewa' xbij chique ri': —Anin ¿nak inocnak wi' ja nquibij chwe ja winak? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—Ec'oli nebin chawe chi atat at Juan Bautista, jule' chic nebini chi at Elías in ec'o chic jule' ja nebini chi at jun chique ja rojer tak profeta in camic atc'astajnakto chic chiquicojol camnaki', neche' chawe, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Ja c'a rixix ¿nak nebij chwe, nak inocnak wi'? ne'e. Peti ja Pedro, xbij tre: —Ja ratat at Cristo ja ratcha'on rmal ja Dios, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pro ja Jesús quewa' xbij chique ri': —Ni majun bar ta tri' xtebij wi' chi anin ja rin Cristo. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak q'uiy rwach ja rpokonal ntij na, xa itzel ninquetz'at na ja principali' xin tinamit e cachbil ja jefe quixin sacerdote e cachbil chakaja' ja maestro ja netijon quixin ja winak tre ja ley xin Dios, nincamsax na in chi rox k'ij ninc'astaj na, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","C'ac'ari' xumaj chic tzij cuq'uin canojelal, quewa' xbij chique ri': —Xa nak ta ja c'o rgana nyuke' ruc'u'x wq'uin rjawaxic chi matuya' rgana ja tzabuklaj c'aslemal rc'an. Rjawaxic chakaja' chi k'ij k'ij ni matipokonaj wi' nutij ja rpokonal mwal in ntre'el chwij. Jari' cani' jun cruz nya̱' trij pro matipokonaj nuc'am ja cruz, nrijkajel in nbe ja bar necamsax wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Queri' nbij chewe como xa nak ta ja npokonaj nuya' can ja rc'aslemal jari' matuwil c'ari' ja utzlaj c'aslemal ja mta q'uisic trij. Pro xa nak ta ja matipokonaj nuya' can ja rc'aslemal mwal anin in rmal ja utzlaj tzij ja nc'amonto jari' can nuwil ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Como cani' tre jun winak ¿nak c'a nuch'ec trij wi xuch'ec nojel ja meba'il rxin ja rwach'ulew pro wi xa ntz'ila' ja rc'aslemal in wi ma xuwil ta ja utzlaj c'aslemal ja mta q'uisic trij? ");
INSERT INTO tzjNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Queri' nbij chewe como ja winak xa nak ta chi winakil wi xa q'uixbal nquena' nquecoj qui' wq'uin in wi xa q'uixbal nquena' rmal ja ntzobal, anin chakaja' q'uixbal nna' chi xquenucoj ta pa ncuenta. Anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak xa q'uixbal nna' chi xquenucoj ta pa ncuenta tokori' tok xquinpi chic jutij, congana nim chic nuk'ij tri' in congana nch'a'an chic chwij ja gloria xin Dios in chakaja' ewachbilanto ja santilaj tak ángel xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ni katzij wi' ja xtinbij chewe ri', ec'oli chewe ja rec'o wawe' camic ri' c'a ec'as na ja tok xtiquetz'at ja gobierno xin Dios. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","C'o la waxaki' k'ij rbin awa' jule' tzij ri' ja tok be parwi' jun jayu' chi nerbana' oración e rachbil ja Pedro, ja Jacobo in Juan. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kas rmajon oración ja tok xuq'uex ri' ja rachbal in ja rtziak kas sak xeli, congana nc'ac'oti. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chaka c'a jalal tok xewinakar e ca'i' achi'i', quemaj tzij ruq'uin, jun Moisés in ja jun chic Elías. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ja c'a Moisés in Elías eje'e' congana nch'a'an chic chiquij ja gloria xin Dios, quimajon rtzijoxic ja rcamic ja Jesús como ja Jesús nbe pa Jerusalén in tri' nerjacha' wi' ri' pa camíc. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ja c'a Pedro arja' congana majtajnak ma waram in queri' chique ja rachbil chakaja' pro quecoch'. Quetz'at ja Jesús chi ja gloria xin Dios ntajini nch'a'an trij in xequetz'at ja ca'i' achi'i' chakaja' ja rec'o ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ja c'a Pedro kas elem nqueban ja ca'i' achi'i' ja tok quewa' xbij tre ja Jesús ri': —Maestro, congana qui'il ja rokc'o wi' ri'. Kabana' oxi' tak jay wawe', jun awxin atat, jun rxin Moisés in jun rxin Elías, ne' tre. Pro ja Pedro xa ma xuch'ob ta ja xbij. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","C'a rmajon na tzij ja Pedro tok c'o jule' sutz' xermujaj in kaj chiquij. Ja c'a roxi' apóstol congana quixbej qui' tok quetz'at chi ec'o chic chipan ja sutz'. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","C'o c'a jun kulaj tzijonto chipan ja sutz', quewa' xbij chique ri': —Jawa' wari' jawa' chak'laj Walc'wal, teya'a' ewxquin tre nak ja nbij arja' chewe, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ja tok tzuri tzij rmal ja kulaj, ja rapóstol tok quetz'at mchita ja rElías, mchita ja Moisés, xa ruyon ja Jesús c'o can chic. Nojel awa' ja quetz'at ri' xa pa tak canma quec'ol wi', q'uiylaj tiempo ja ni majun bar ta tri' quibij wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ja c'a chi rcab k'ij tok xemelojto ja Jesús parwi' jayu' congana e q'uiy ja winak xebe chi rc'ulic. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","C'o c'a jun achi chiquicojol cow tzijoni, quewa' xbij tre ri': —Maestro, tabana' jun utzil, anin c'o jun nc'ajol in ni xarari' ti jun, tatz'ata' paki jutz'it. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","C'o jun itzel espíritu nchapo rxin in chaka jalal tok nuya' síc', c'ol ataque nya̱' tre in nel rpuluw ruchi'. Congana ncamsax pa tok'ulew, kas maril nsokpix rmal ja ritzel espíritu. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","In xinc'utuj jun utzil chique ja radiscípulo chi nquiwasaj ja ritzel espíritu pro eje'e' ma xecowin ta quiwasaj ta, ne'e ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ja c'a Jesús tok c'axtaj rmal ja bix tre rmal ja rachi quewa' xbij ri': —Ixix ja rix tinamit Israel, ni taka'an mta wi' yukulbal ec'u'x wq'uin, taka'an yojtajnak ja rena'oj. Taq'ue titzuri ja nsamaj checojol, c'ayew chwe chi ncoch' más ja matiyuke' ec'u'x wq'uin, ne'e. C'ac'ari' xbij tre ja tatixel: —Camic tac'ama'to ja rac'ajol wq'uin, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ja c'a rala' xajalal maja'n tekaj chwach ja Jesús ja tok ya' chic jun ataque tre rmal ja ritzel espíritu in ch'akix pa tok'ulew rmal. Ja c'a Jesús arja' xch'olij ja ritzel espíritu, xuto' ja rala' pa ruk'a' in xujach can tre ja rtata'. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ja c'a winak congana c'asc'o'i quetz'at canojelal ja nimlaj poder xin Dios ja c'o pa ruk'a' ja Jesús. Ja c'a Jesús kas majtajnak rtzijoxic nojel ja nuban cumal canojel ja winak ja tok quewa' xbij chique ja rdiscípulo ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Kas toc pan ewxquin ja xtinbij chewe ri'. Ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak arja' nja̱ch na pa quek'a' ja winak, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pro ja reje'e' xa ma xch'obtaj ta cumal ja xbij chique, xa wawan chiquewach utzc'a chi matich'obtaj cumal nak rbanic. Ja reje'e' xa nquixbej qui' xtiquic'axaj ta tre nak rbanic. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","C'ac'ari' quemaj rch'a'ic chibil tak qui' nak ja más nim ruk'ij chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ja c'a Jesús arja' bien rotak nak ja netajini nquech'ob kaj pa tak canma. C'o c'a jun tac'al xuc'am pon, xuya' pa rxquin ");
INSERT INTO tzjNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","in quewa' xbij chique ri': —Jawa' jun tac'al ri' xa nak ta xtic'ulu rxin in wi pa nubi' anin tok nuc'ul tibij c'a tzij ari' chi anin ja ninruc'ul. In xa nak ta xtic'ulu wxin tibij c'a tzij ari' chi nata' Dios ja nuc'ul chakaja' ja takyonpi wxin. Queri' nbij chewe como ja wi c'o jun checojol ja matuya' kaj ruk'ij ruyon jari' ja más nim ruk'ij chewe, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","C'ac'ari' bix tre rmal ja Juan: —Maestro, ajoj c'o jun achi katz'at ja pan abi' atat ntajini nerlasaj itzel tak espíritu chique winak pro como ma kachbil ta chewi' tok kabij tre chi: —Ma que'awasaj chi ta, xokche' tre, ne'xi ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","—Ma tek'il chi ta ja rachi como jun winak xa nak ta chi winakil wi ma itzel ta nokrutz'at jari' kachbil ari', ne' tre ja Juan. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ja c'a Jesús tok nakajinto ja k'ij ja xtic'amarel wi' chila' chicaj arja' xujic ja rviaje chi nbe ja pa Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ec'o jule' rachbil xerutakel chi nenabeyajel chwach, eje'e' xebe chipan jun aldea quixin ja raj Samaria chi nquichomij pon ja nc'atzin tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pro ja c'a winak ja rec'o chipan ja raldea eje'e' ma xquec'ul ta ja Jesús como pa Jerusalén nbe wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ja c'a ca'i' discípulo Jacobo in Juan tok quetz'at chi ma xc'ul ta cumal ja winak quewa' quibij tre ja Jesús ri': —Kajaw ¿la maxta c'ol agana nkac'utuj k'ak' chila' chicaj ja cani' xuban ja rojer profeta Elías utzc'a chi ne'urq'uisa' jala' jule' winak le'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ja c'a Jesús arja' xuya' vuelta in xumaj quich'olixic: —Ixix xa matich'obtaj emwal jani' rna'oj ja rEspíritu ja ruc'ayon ewxin. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Queri' nbij chewe como anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin winak ma inpenak ta chi quicamsaxic winak, inpenak chi quito'ic, ne' chique. C'ac'ari' xebe chic cha jun aldea. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kas c'a quimajon chic bey ja tok c'o jun achi peti in quewa' xbij tre ja Jesús ri': —Wajaw, anin can ninbe chawij xa bar ta tri' natbe wi', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","In bix tre rmal ja Jesús: —Ja rutiwa' c'o quic'olibal ja bar newar wi' in chakaja' ja tak tz'iquin c'o quesoc pro ja chwe anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak mta wochoch ja ni ta wxin wi' anin ninwar wi', ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","C'o c'a jun chic achi, quewa' bix tre rmal ja Jesús ri': —Jo', cattre' chwij, catoc ndiscípulo, ne'xi. —Wajaw, taya'a' lugar chwe chi nenmuku' can paki na ja nata' nabey, ne'e ja rachi tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","—Ja camnaki' chwach Dios eje'e' na quemuku quixin ja camnaki'. Ja c'a ratat jat cuq'uin ja winak, jaya'a' rbixic ja gobierno xin Dios chique, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","C'o chi na jun ja rachi quewa' xbij tre ja Jesús ri': —Wajaw, anin in conforme chi nintre'el chawij chi ninoc adiscípulo pro taya'a' lugar chwe chi ne'enk'ijla' can na nabey ja rec'o pa wochoch, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","—Jun ajchonla' ma utz ta neli ja banoj chenoj rmal ja wi xa trij nca'y can wi' in queri' c'a tre jun winak chakaja' xa nak ta chi winakil ja wi xa trij nca'y can wi' jari' ma yatal ta tre chi nsamaj pa rcuenta ja gobierno xin Dios, ne'xi ja rachi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","C'ac'ari' ja kajaw Jesús ec'o chic setenta achi'i' ja xerucha', pa caca' xerutakel chi nenabeyaj chwach, nebe chipan nojel tak tinamit in chipan ja jule' chic lugar ja bar xtekaj wi' arja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Quewa' xbijel chique ri': —Ni katzij wi' nbij chewe, ja winak eje'e' e cani' jun nimlaj tijco'm ja k'en chic ja utz chic nba̱n cosechar pro ja rajsamajela' ja nebano cosechar quixin xa ma e nim ta. Rmalc'ari' nbij chewe, tebana' orar, tec'utuj tre ja Rajaw ja cosecha chi nerutakto ja rajsamajela' chi ne'urquibana' cosechar ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Camic tec'ama'el ja bey, bien tewotakijel chi ixix ix cani' jule' tak carnelo in ja winak ja bar nixnutakel wi' eje'e' e cani' utiwa'. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ma tec'amel ta epwok, nixtac'a nec'amel ta emaleta in nixtac'a exajab ta chakaja'. Ja tok emajon awa' ja jun viaje ri' maxta quixpe'e cuq'uin winak chi quik'iloxic ja tok nec'ul ewi' cuq'uin pa bey. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ja tok nixoc chipan jun jay, tok ne'ek'ijla' ja winak quewa' ja kas nebij chique nabey ri': —Ja quicotemal xin Dios tiq'ueje' pan ewochoch, quixche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ja wi c'o jun winak chipan ja jay ja congana qui'il ec'ulic nuban jari' nq'ueje'e ja quicotemal xin Dios chipan ja rochoch nowi ma queri' ta nuban chewe jari' mta quicotemal xin Dios nq'ueje' ta chipan ja rochoch. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ja jay ja bar nixc'ul wi' tri' nixq'ueje' wi' jaru' pa tiempo nixq'ueje' chipan ja tinamit. Tetija' ja nquisipaj chewe como yatal chewe chi nixtzuki cani' tre jun ajsamajel yatal tre chi ntoji. Maxta quixeli quixoqui chi tak jay tre ja bar nixq'ueje' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ja tok nixoc chipan ja jun tinamit xa nak ta chi tinamital ja wi qui'il ec'ulic nbani tetija' ja nsipax chewe. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Que'etzursaj ja yawa'i' ja rec'o chipan ja tinamit in quewa' nebij chique ja winak ri': —Ja gobierno xin Dios xa nnakajinto ewq'uin, quixche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ja c'a wi maquixc'uli quixelto c'a pa tak bey in quewa' nebij chique ja winak ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","—Ja pokok rxin ja retinamit ja c'o pa kakan, camic nkaquiraj can jari' retal chi netij na rpokonal rmal ja mta egana xteya' ta ewxquin tre ja nkabij chewe pro tewotakij chi ja gobierno xin Dios xa nnakajinto ewq'uin, quixche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Camic nbij chewe, ja tok xterila' ja nimlaj k'ij xin juicio congana lawulo' tre ja tinamit ja maquec'ulu ewxin, más na lawulo' ja rpokonal xtiquetij chwach ja xtiquetij ja raj Sodoma, ne'e ja Jesús chique ja setenta discípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","C'ac'ari' xumaj chic jutij tzij, quewa' xbij chique jule' tinamit ri': —Congana lawulo' chewe ixix ja rix aj Corazín in congana lawulo' chewe ixix chakaja' ja rix aj Betsaida. Queri' nbij chewe como congana nimak tak milagro xinban chewach pro ni ma xeq'uex ta wi' ja rena'oj. Ja nimak tak milagro xinban chewach wixta ban chiquewach ja ritzel tak winak ja raj Tiro in ja raj Sidón ojer queq'uex ta c'ari' ja quina'oj in queya' can ta c'ari' ja ritzelal, queban ta c'ari' ja nquic'utbej qui' chi nti'on chique ja ritzelal ja quibanon chipan ja quic'aslemal. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pro ja tok xterila' ja nimlaj k'ij xin juicio más chi na nim ja rpokonal xtetij ixix chwach ja xtiquetij ja raj Tiro in ja raj Sidón. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","In ixix chakaja' ja rix aj Capernaum, ja nech'ob ixix chi nixbe chila' chicaj chi congana nya̱' ek'ij pro ja neban, xa nixkajsaxi, ja bar ec'o wi' ja camnaki' c'a tri' nixekaj wi'. Queri' xbij chique ja tinamit. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","In xumaj chic jutij tzij cuq'uin ja setenta discípulo: —Ja winak ja neniman rxin ja xtebij chique, anin c'ari' ja ninquinimaj. Ja c'a winak ja maquec'ulu ewxin, anin c'ari' ja maquinquec'ul in ja winak ja maquec'ulu wxin, Nata' c'ari' ja takyonto wxin ja matiquec'ul. Queri' xbijel ja Jesús chique ja setenta discípulo in xebe, xequibana' ja bixel chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ja c'a tok xemelojto congana nequicoti, xe'urkaj ruq'uin ja Jesús in quewa' quibij tre ri': —Kajaw, ja ritzel tak espíritu tok kabij chique chi pan abi' ne'eli eje'e' xokquinimaj chakaja', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ja c'a Jesús xbij chique: —Anin xintz'at ja Satanás kajsaxi, tzakto chicaj cani' nuban k'ak'. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Bien tec'waxaj ja xtinbij chewe ri', camic anin nya' poder chewe in wi ec'oli ja cumatz xque'epak' owi sina'y jari' mta nak ta xteban ta cumal. In chakaja' nya' chewe chi nixcowini nekajsaj nojel ja poder ja c'o pa ruk'a' ja Satanás. Ni majun nak ta xtibano ta pokon chewe. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Camic ja ritzel tak espíritu nixquinimaj pro maxta xa rmalari' quixquicoti. Mejor ja neban, como tz'ibtali ja rebi' chila' chicaj rmal tari' nixquicoti, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ni jari' hora congana jun nimlaj quicotemal winakar pa ranma rmal ja rEspíritu Santo in xumaj tzij ruq'uin ja Tatixel ja c'o chila' chicaj, quewa' xbij tre ri': —Nata', atat at Rajaw caj at Rajaw rwach'ulew, congana nmaltioxij chawe como ja winak ja nquech'ob kaj pa tak canma chi congana cotak in congana quina'oj ma chiquewach ta eje'e' ak'alasan wi' nak rbanic nojel awa' ja nmajon rbanic in nojel ja nmajon rbixic pro ja rak'alasan wi', chiquewach ja winak ja quibanon takno'y chawach. Queri' abanon chique Nata' como queri' ja ravoluntad, ne'e ja Jesús tre ja Tatixel. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","C'ac'ari' xbij: —Ni majun nak ta ja maquita jachon pa nuk'a' rmal ja Nata'. Ni majun nak ta otakyon ja kas mero rna'oj ja Ralc'walaxel pro ja rotakyon xa ruyon ja Dios ja Tatixel. In chakaja' ni majun nak ta otakyon ja kas mero rna'oj ja Tatixel pro ja rotakyon xa nuyon anin ja rin Alc'walaxel, in ja rencha'on chi nk'alasaj chiquewach, eje'e' cotak chakaja', ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","C'ac'ari' xumaj tzij cuq'uin ja rdiscípulo pro xa queyon: —Ixix congana qui'il chewe rmal ja nixtajini netz'at ruq'uin ewach. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Como anin nbij chewe chi e q'uiy ja rojer tak profeta in e q'uiy ja rojer tak rey eje'e' congana quiyarij quetz'at ta ja cani' nixtajini netz'at ixix camic in congana quiyarij quic'axaj ta chakaja' ja cani' nixtajini nec'waxaj ixix camic, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","C'o c'a jun achi peti, arja' jun chique ja maestro ja netijon quixin ja winak tre ja ley xin Dios. Ja c'a rachi c'o rgana nc'ambajaj ja Jesús in xa rmalari' tok quewa' xbij tre ri': —Maestro ¿nak nban utzc'a chi nyataj chwe ja utzlaj c'aslemal ja mta q'uisic trij? ne' tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","—Tabij chwe ¿nak tz'ibtal can chipan ja ley xin Dios? ¿Nak nawasaj atat trij? ne'xi ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","—Quewa' nbij ri': —Tawajo' ja Dios ja rawajaw pro nojel ac'u'x tawajo', in nojel awanma in nojel awachok'ak' in nojel ana'oj tawajo' chakaja'. Ja cani' nawajo' kaj awi' ayon queri' c'a tabana' chique ja raprójimo, que'awajo' chakaja'. Queri' nbij, ne'e ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Ni katzij wi' ja nabij le'. Ja c'a wi xtaban cumplir ja ley ja c'a xabij le' jari' nyataj chawe ja utzlaj c'aslemal ja mta q'uisic trij, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ja c'a rachi arja' nrajo' nuto' ri' rmalari' tok xbij chic tre ja Jesús: —Pro ¿echinatak c'ari' ja nprójimo? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ja c'a Jesús arja' xumaj rbixic jun c'ambal tzij tre, quewa' xbij tre ri': —C'o jun achi xuban jutij xelel pa Jerusalén, xule' chipan ja tinamit Jericó. Ec'o c'a jule' alak'oma' quechap ja rachi, quilak'ajel ja c'o ruq'uin pro ni nojelal, quesoc can, quipunba' can pa bey, jutz'it laj quicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","C'o c'a jun sacerdote penak pa bey. Ja c'a sacerdote tok xutz'at chi punuli ja rachi pa bey xusol rubey, ma xk'ax ta ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pi chi c'a jun ajsamajel xin Dios ja levita ne'xi. Ja c'a levita tok xurkaj chipan ja lugar xutz'at ja rachi, xusol chic rubey, ma xk'ax ta ruq'uin chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pro c'o c'a jun achi aj Samaria, arja' rmajon rviaje in xurkaj chipan ja lugar. Ja c'a raj Samaria tok xutz'at pon ja rachi congana xpokonaj rwach, ");
INSERT INTO tzjNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","be ruq'uin. Ja tok xekaj ruq'uin c'o jule' aceite rachbil vino xuya' chwach ja bar soctajnak wi' jari' xk'ombej. Ja tok k'omtaj rmal c'ac'ari' xubatz'. Como c'o ruquiej rc'amonto xtz'uba'el ja rachi trij, xuc'amel pa jun pensión, bien xuban cuenta. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ja c'a chi rcab k'ij ja raj Samaria benam nuban, c'o ca'i' quetzal pwok xlasaj, xutoj can pa ruk'a' ja rajaw pensión in quewa' xbij tre ri': —Tabana' paki jutz'it cuenta ja rachi, taya'a' tre xa nak ta ja nc'atzin tre. Ja tok xquinmelojto anin wotak chi nuntojo' ja ruc'as awq'uin nojelal, ne' can tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ja tok bitaji ja c'ambal tzij rmal ja Jesús quewa' xbij chic tre ja maestro ri': —Camic tabij chwe, ja chawe atat ¿nak chique ja roxi' achi'i' ja xoc rprójimo ja rachi ja chap cumal ja ralak'oma'? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Ja pokonan rwach, ne'xi rmal ja maestro. —Camic jat, tabana' atat ja cani' xuban ja raj Samaria, ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","C'ac'ari' xumaj chic jutij rubey, xekaj pa jun aldea. Tri' c'o wi' jun ixok, Marta rubi', arja' c'ulu rxin pa rochoch. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ja c'a Marta c'o jun ruchak', María rubi'. Ja c'a María arja' tz'abe'oc chwach ja Jesús in xumaj rc'axaxic nojel ja tijonem ja ntajini nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pro ja Marta congana nk'isaj ri' chi rbanic ja samaj pa jay rmalc'ari' tok be ruq'uin ja Jesús in quewa' xbij tre ri': —Wajaw ¿la macatocla' il tre ja nuchak' nuyon inrya'on can chwach ja samaj? Tabij paki jutz'it tre chi ninruto', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","—Marta, atat q'uiy rwach ja ramajon rbanic in xa nak'isaj awi' rmal in nti'on chawe chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pro c'o jun ja más na nc'atzin chawe chi naban ja más na utz jari' ja ntajini nuban ja María camic in majun nak ta xtilasan ta tre ja tijonem ja ntajini nc'axaj, ne'xi ja Marta rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Xuban jutij ja Jesús arja' c'o pa jun lugar, rmajon rbanic oración. Ja c'a tok tzuri ja roración rmal pi jun chique ja rdiscípulo in quewa' xbij ja discípulo tre ri': —Wajaw, ko'atijoj tre ja banoj oración ja cani' xuban ja Juan Bautista xertijoj ja discípulo rxin arja', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ja c'a Jesús xbij chique: —Ja tok neban oración quewa' nebij ri': —Katata' Dios ja ratc'o chila' chicaj, lok' ta xtina'i ja rabi' cumal ja winak. Xtikajpi ta ja ragobierno wawe' chwach'ulew, xtinimax ta ja ravoluntad atat wawe' ja cani' ntajini nba̱n chila' chicaj nnimaxi. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","K'ij k'ij ni ta naya' wi' ja kaway ja nc'atzin chake. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tacuyu' ja kil kamac ja cani' nkaban ajoj nekacuy ja winak tok c'oli nqueban chake. Atat ta xcatchajin kaxin, maxta kokaji tok nokrtakchi'ij ja diablo, ko'ato'o' pa ruk'a'. Queri' ta rbanic ja roración neban, ne' chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","C'ac'ari' xbij chic chique: —Tac'a c'o ta jun chewe nbe ta ruq'uin jun ramigo pa tak nc'ajak'a' in nerbij ta tre: —Wamigo, maxta c'o caxlanway awq'uin, taya'a' oxi' rkan wxin pro can nya' rc'axel. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Xa c'o jun wamigo c'a xurkaj wq'uin, penak pa viaje in ni majun nya' tre, ne' ta tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","In quewa' ta c'a nc'ulba'to ja ramigo pa jay ri': —Ma quinaban ta molestar como ntz'apin chic ja chi'jay, okcotz'ol chic cuq'uin tak walc'wal. Maquincowini ninyictaji, maquincowini nya' chawe ja nac'utuj chwe, ne'to ta tre, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","C'ac'ari' xbij chic chique: —Camic nbij chewe, ja rachi wi chijutij numaj rc'utuxic ja caxlanway, wi ni matitanba' wi' rc'utuxic jari' nyictaji ja ramigo in nuya' tre nojel ja nc'atzin tre pro ma rmal ta chi camigo qui' ruq'uin tok nuya' pro rmal ja ni matitanba' wi' chi rc'utuxic chewi' tok nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Rmalc'ari' tok nbij chewe, tec'utuj tre ja Dios ja nc'atzin chewe in arja' nuya' chewe, tecanoj ja newajo' in newil, tec'onc'o'oc ja chi'jay in nja̱k chewach. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Queri' nbij chewe como canojel ja nec'utuni nyataj chique in ja necanoni nyataj chique chi nquewil in ja nec'onc'onoc ja chi'jay nja̱k chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","O ¿la c'ol on jun tatixel chewe tok nc'utux jun caxlanway tre rmal jun ti rc'ajol la nuya' jun abaj pa ruk'a'? Owi nc'utux jun ch'u' tre ¿la nuya' jun cumatz tre? ");
INSERT INTO tzjNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Owi nc'utux jun sakmolo' tre ¿la nuya' jun sina'y? ");
INSERT INTO tzjNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ixix masqui ix lawulo' pro ewotak neya' utzlaj tak nakun chique ja rewalc'wal pro pior ta c'a ja Tatixel ewxin ja c'o chila' chicaj arja' nuya' ja rEspíritu Santo chique ja nec'utun tre. Queri' xbij ja Jesús chique ja rdiscípulo tre ja banoj oración. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","C'o c'a jun achi memirnak rmal jun itzel espíritu. Ja c'a Jesús arja' ntajini nlasaj ja ritzel espíritu tre. Ja tok lastajel rmal ni jari' hora xumaj tzij ja rachi. Ja c'a winak congana c'asc'o'i quetz'at. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pro ec'o jule' chique quewa' quibij ri': —Xa poder xin Beelzebú ja jefe quixin ja ritzel tak espíritu xa jari' nucoj chi quilasaxic ja ritzel tak espíritu, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ec'o chi c'a jule' quemaj rc'ambajaxic: —Tabana' jun milagro ja nc'utu chikawach chi Dios yoyon chawe ja poder ja c'o pan ak'a', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pro ja c'a Jesús arja' bien rotak ja quimajon rch'obic in xbij chique: —Jun gobierno xa nak ta chi gobierno'il, wi xa división nuban chibil ri' jari' xa nyojtaji. In queri' chique jule' winak chakaja' ec'o pa jun jay, wi xa división nqueban chibil tak qui' jari' xa neq'uisi. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","In queri' c'a tre ja Satanás chakaja', ja wi xa división nuban cuq'uin rach tak demonio ¿nak moda ja maquita xtiq'uisi ja rgobierno? Queri' nbij chewe como ixix nebij chwe chi poder xin Beelzebú ncoj chi quilasaxic ja demonio. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ja c'a ranin wi xa poder xin Beelzebú ncoj ja tok nenlasaj ja demonio ¿nak nebij chique ja rediscípulo ixix? Como eje'e' nequiwasaj demonio chakaja' ¿la xc'a poder xin Beelzebú nquecoj nech'ob ixix? Ja rediscípulo ixix eje'e' c'ari' xquek'alasani chi ma katzij ta ja xebij chwe. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ja ranin poder xin Dios ncoj ja tok nenlasaj ja demonio in wi queri' nban tibij c'a tzij ari' chi ja gobierno xin Dios kajnakto chic checojol. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ja tok c'o jun achi ja congana rchok'ak' rmajon rchajixic rochoch in tok c'oli ja banbal ch'a'oj ruq'uin jari' c'ayew chi xtilasax ta tre ja c'o ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pro ja c'a tok npi chic jun achi ja más k'axnak chi na rchok'ak' in nuch'ec ja rachi ja rajaw jay jari' numaj tre nojel ja banbal ch'a'oj ja bar yukul wi' ruc'u'x, nlasaj tre ja c'o ruq'uin in numaj rjachic chique ja rachbil. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ja winak ja matiquecoj qui' wq'uin jari' xa ruq'uin Satanás ja nc'ulel nquecoj wi' qui' in chakaja' ja maqueto'o wxin chi quimolic ja winak jari' xa nequichicaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jun itzel espíritu tok nel pa ranma jun achi arja' nbe pa tak lugar ja bar mta wi' ya', nercanoj jun lugar ja bar nxula'n wi' pro matuwil ja lugar in quewa' nbij ri': —Ninmeloj chic jutij chipan ja wochoch ja bar inelnakto wi' nabey, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ja c'a tok nekaj chic jutij ruq'uin ja rachi nutz'at ja ranma cani' jun jay josk'in rpan in wekon chi utz. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","C'ac'ari' nmeloj chic jutij, ne'erc'ama' wuku' rach tak itzel espíritu ja más chi na e itzel chwach arja'. Ja c'a tok ne'urkaj ruq'uin ja rachi ne'oc pa ranma chi e waxaki' in tri' neq'ueje' wi'. Xc'a chewi' tok más chi na lawulo' ja rc'aslemal ja rachi chwach ja nabey. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kas rmajon rbixic ja tzij ri' ja tok c'o jun ixok chiquicojol ja winak quewa' xbij tre ri': —Congana qui'il tre ja rate' ja q'uittzin awxin, ne' tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pro ja c'a Jesús quewa' xbij tre ri': —Más na qui'il chique ja winak ja nec'axani ja rtzobal Dios in nqueban cumplir ja nbij chique chi nqueban, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ja c'a tok congana e q'uiy ja winak quimolon chic qui' trij xumaj tzij cuq'uin quewari': —Ja winak trewa' tiempo ja rokc'o wi' ri' xa e itzel tak winak. Eje'e' nquic'utuj chwe chi nban jun milagro utzc'a chi ninquinimaj. Pro ja milagro ja nquic'utuj ni matinban wi' chiquewach xarwari' c'o jun ja milagro nbantaj na chiquewach, jun milagro ja cani' xuban ja rojer profeta Jonás. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Como cani' xuban ja Jonás ojer arja' xoc retal chiquewach ja winak ja rec'o chipan ja tinamit Nínive ojer in queri' c'a chwe anin chakaja' ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak, ninoc na retal chiquewach ja winak ja rec'o chipan awa' tiempo ja rokc'o wi' ri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ja tok xterila' ja nimlaj k'ij xin juicio ja rixok ja reina rxin ja nación ja c'o pa sur arja' xtiyictaji ix rachbil ja rix tinamit Israel in arja' noc k'etol tzij chewij. Queri' nbij chewe como jari' ixok arja' c'a c'a nat pi wi' chi rc'axaxic ja rna'oj Dios ja yatajnak tre ja rojer rey Salomón. In ja camic nbij chewe, anin más chi na nim nuk'ij chwach ja Salomón. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ja tok xterila' ja nimlaj k'ij xin juicio ja rachi'i' ja rec'o chipan ja tinamit Nínive ojer eje'e' xqueyictaji ix cachbil ja rix tinamit Israel in eje'e' ne'oc e k'etol tak tzij chewij. Queri' nbij chewe como ja raj Nínive eje'e' tok quic'axaj ja rtzobal Dios ja bix chique rmal ja Jonás ojer q'uextaji ja quina'oj in queya' can ja ritzelal. In ja camic nbij chewe, anin más chi na nim nuk'ij chwach ja Jonás. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ni majun nak ta nbanowi xtutzij ta jun candil xtiwawaj ta c'a pa jun latz'laj lugar nixtac'a xtijupba' ta jun caxon trij. Pro ja c'a nbani, ja tok ntzijtaji jun candil ncanox jun rc'olibal ja bar nya̱' wi' utzc'a pa sak neq'ueje' wi' ja winak ja ne'oc pa jay. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ja panewach cani' rbanic jun luz ixrya'on pa sak, ja wi mta rbanon wi ma yojtajnak ta jari' pa luz c'a c'o wari' ja recuerpo pro ni chi jun. Pro ja c'a wi yojtajnak jari' pa k'eku'm c'a c'o wari' ja recuerpo. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Rmalc'ari' tok nbij chewe, tebana' cuenta, maxta tichupi ja luz ja yatajnak chewe pa tak ewanma utzc'a chi maquixq'ueje' pa k'ekumal. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ja wi pa luz atc'o wi' pro ni chi at jun, ja wi majun k'ekumal awc'an jari' nnojsaxi ja luz pan awi' pan awanma cani' nuban jun candil natruya' pa sak, ne'e ja Jesús chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ja c'a tok tzuri tzij rmal c'o jun fariseo xubanel invitar chi newa' ruq'uin. Ja c'a Jesús tok xekaj chi rochoch ja fariseo xoc pa jay in tz'abe' pa mesa. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ja c'a fariseo arja' junwi' xutz'at como ja Jesús rmajon chic wa'im pro ma xuban ta ja costumbre xin ch'ajoj k'abaj nabey. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ja c'a kajaw Jesús quewa' xbij tre ri': —Ixix ja rix fariseo ix cani' jule' plato rachbil jule' vaso ja bien ch'ajch'oj rij pro ja rpan congana tz'ilornak. Queri' c'a ebanic ixix como ja rewanma nojnak ja ritzelal chipan, congana alak' ebanon. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Xa ix nacnak tak winak. ¿La ma ewotak ta c'a chi ja Dios arja' winakarsyon ja rewanma chakaja' in ma ruyon ta ecuerpo rwinakarsan? ");
INSERT INTO tzjNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pro ja rjawaxic chi neban, ja c'ol ewq'uin jari' que'etobej ja winak ja c'o rjawaxic chique. Ja wi queri' neban jari' ch'ajch'oj nixeli pro ni chi ix jun. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Congana lawulo' chewe ja rix fariseo como ixix congana nixocla' il chi rya'ic ja reprimisia pro c'oli ja más chi na rjawaxic chi neban pro jari' ni ma ebanon ta. Congana ix conforme chi neya' eprimisia, neya' nojel rwach ja richaj cani' tre menta in cani' tre ruda pro ja banoj utzil jari' ni ma ebanon ta wi' in mta ja rajoben ri'il xin Dios chewe. Pro jari' ni rjawaxic wi' chi neban cumplir in ni rjawaxic wi' chakaja' chi matetanba' rya'ic ja reprimisia. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Congana lawulo' chewe ja rix fariseo como ixix tok nixbe pa tak jay xin molbal ri'il ja bar nc'axax wi' ja rtzobal Dios congana nel ec'u'x trij ja tz'ulbal je'e ja más nimak ruk'ij in chakaja' tok nixbin pa tak c'aybal congana nel ec'u'x trij ja nixban saludar. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Congana lawulo' chewe ja rix maestro xin ley in chewe ja rix fariseo, caca' epalaj como ixix ix junan ruq'uin ja rulew ja bar mukun wi' jun camnak pro jun ulew ja ma k'alaj chi ta chi c'o jun camnak chuxe' in rmalari' ja winak tok nek'ax parwi' ja rulew mta nquinabej chi parwi' jun camnak nek'ax wi'. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","C'o c'a jun chique ja maestro rxin ja ley xin Dios quewa' xbij tre ja Jesús ri': —Maestro, ja c'a xabij le' xa nokaban ofender ajoj tre chakaja', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ja c'a Jesús quewa' xbij chic ri': —Congana lawulo' chewe ixix chakaja' ja rix maestro rxin ja ley xin Dios como ja tijonem neya' cani' nimak tak ijka'm neya' chiquij ja winak pro jule' ijka'm ja congana c'ayew chi rijkaxic pro ja rixix nixtac'a nechap ta jutz'it ja rijka'm tre jun rwi' ek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Congana lawulo' chewe como neban rbanic quipanteón ja rojer tak profeta xin Dios pro ewati't emama' ixix wa'an ja xecamsan quixin. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ja tok queri' neban jari' bien k'alaj chi ix conforme ruq'uin ja queban ja rewati't emama' ojer como eje'e' xecamsan quixin ja profeta in ixix nixbano rbanic ja quipanteón. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Rmalc'ari' tok ja Dios ojer quewa' rbin can ri': —Ja winak ec'oli profeta nenutakel na cuq'uin e cachbil jule' apóstol. Ja c'a profeta in apóstol jule' chique necamsax na cumal ja winak in jule' chic chique nesalux na cumal. Queri' xbij ja Dios ja rotakyon nojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Queri' ja nbantaji utzc'a ja winak ja rec'o chipan awa' tiempo ja okc'o wi' ri' chiquij eje'e' nkaj wi' ja rtojbalil ja quicamic canojel ja profeta ja recamsanto chwach ja rwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ja kas nabey Abel ja camsaxi in ja c'a q'uisbex rcamsaxic Zacarías. Chicojol ja templo in ja raltar ja c'o chwach ja templo tri' camsax wi' ja Zacarías. Rmalc'ari' tok nbij chewe, ja winak ja rec'o chipan awa' tiempo ja rokc'o wi' ri' chiquij eje'e' nkaj wi' ja rtojbalil ja quicamic ja profeta canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Congana lawulo' chewe ja rix maestro rxin ja ley xin Dios ja tz'ibtal can rmal ja Moisés como ixix etz'apin quebey ja winak chiquewach utzc'a chi maticotakij nak ja kas mero rbanic ja rtzobal Dios. Xa ma ewotak ta ixix nak ja kas mero rbanic in nixtac'a neya' ta lugar chique ja winak ja c'o quigana ncotakij, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ja tok bitaj rmal nojel awa' jule' tzij ri' ja c'a maestro xin ley e cachbil ja fariseo eje'e' congana xeyictaj trij. Congana quemaj rc'otic ruchi' ");
INSERT INTO tzjNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","jari' nquic'ambajbej rxin como c'o quigana nquicanoj rij rwach nak nqueban tre chi nquechap. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ec'oli ja winak quimolon chic qui' tri' pro congana e q'uiy, quimajon rminic qui' rmal. Ja c'a Jesús arja' xumaj tzij cuq'uin ja rdiscípulo nabey, quewa' xbij chique ri': —Tebana' cuenta ewi' chwach ja levadura quixin ja fariseo. Jari' tibij tzij chi maxta xa caca' epalaj ixix como cani' eje'e'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Queri' nbij chewe como nojel ja ma k'alajinnak ta je'e jari' nerila' na jun k'ij tok xtik'alajini in nojel ja rawatal je'e jari' nel na pa sakil, notakix na. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Rmalc'ari' ja tok nbij chewe, xa nak ta chi tzijal ja rebin kaj pa tak k'eku'm nel na rbixic pa sak in chakaja' nojel ja tzij ja rebin kaj pan ekal pa tak ewochoch nel na rbixic chiquewach ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Camic nbij chewe ja rix wamigo, ma texbej ta ewi' chiquewach ja winak ja xa ruyon ecuerpo necowini nquicamsaj como ja tok nixcamstaj cumal mchita nak chi ta necowini nqueban chewe. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pro anin nbij chewe chok chwach ja nexbej wi' ewi'. Texbej ewi' chwach ja ncowini nercamsaj winak in ja tok necamstaj rmal c'o ruk'a' chique chi neruya' pa k'ak'. Chwach c'a ri' texbej wi' ewi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ja tak tz'iquin ja tok nec'ayixi xa ca'i' tak centavo neya̱' wi' ja re jo'o'. Pro masqui xa e tak barata pro nixtac'a c'o ta jun chique xtimestax ta rmal ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","In ja c'a chewe ixix mta moda xquixrmestaj ta ja Dios, ja rsamal ewí' rajlan chijujunal. Rmalc'ari' nbij chewe, ma texbej ta ewi', más na ix vale chiquewach jun nimlaj moc tz'iquin. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ja winak xa nak ta chi winakil wi matiquipokonaj nquibij chi wq'uin anin yukul wi' quec'u'x pro wi ni chiquewach ja winak nquibij wi', anin chakaja' can nbij na chique chi ec'o pa ncuenta pro ni chiquewach ja ángel xin Dios xtinbij wi', anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pro ja wi c'o jun npokonaj nbij chiquewach ja winak chi wq'uin yukul wi' ruc'u'x, anin chakaja' nbij na tre chi arja' ma c'o ta pa ncuenta pro ni chiquewach ja ángel xin Dios xtinbij wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ja wi c'o jun winak xa nak ta chi winakil masqui arja' nbij jule' tzij tre ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, jule' tzij ja xa ofensa rc'amonto tre, jari' c'o cuytajic trij pro wi nbij jule' tzij tre ja rEspíritu Santo ja xa ofensa rc'amonto tre jari' ni mta wi' cuytajic trij. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ja tok xquixchap cumal ja winak, tok nixquec'amel pa tak jay xin molbal ri'il in tok nixquec'amel chiquewach ja k'etol tak tzij maxta quixocla' il tre ja nebij ja netobej ewi' chiquewach ");
INSERT INTO tzjNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","como ja rEspíritu Santo arja' ni jari' hora xtuya' chewe nak rjawaxic chi nebij chique, ne'e ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","C'o c'a jun achi chiquicojol ja winak quewa' xbij tre ja Jesús ri': —Maestro, tabij paki jutz'it tre ja nnimal chi nujach chwe ja herencia ja c'o nuk'a' tre, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","—Achi ¿la in juez la'an chewi' ja tok anin xquinchomin ewxin tre ja herencia? ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","C'ac'ari' ja Jesús xbij chique ja winak: —Tebana' cuenta ewi', maxta quixban engañar rmal ja yarin meba'il. Queri' nbij chewe como ni majun winak masqui congana meba'il c'o ruq'uin pro ma ja tari' ja meba'il nyowi rc'aslemal, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","C'ac'ari' xbij jun c'ambal tzij chique quewari': —C'o jun achi biyom, c'oli ja rulew in congana cosecha nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ja c'a biyom arja' xumaj kaj rch'obic pa ranma: —¿Nak nban c'awa'? como camic mchita bar ta xtinc'ol wi' ja ncosecha, ne' kaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ja c'a tok ch'obtaj rmal quewa' xbij chic ri': —Mejor ja nban, can nyoj ja ntroja nojelal in nban chic jule' ja más chi na nimak. Ja c'a tok xtibantaj mwal chipan xtinc'ol wi' nojel ja ncosecha rachbil ja jule' chic meba'il ja c'o wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ja tok xtic'oltaj mwal nojelal quewa' xtinbij kaj chic pa wanma ri': —Camic sobre ja nmeba'il, jawa' q'uiylaj juna' nuban wq'uin. Mejor, solo xula'nem chic ja nmajel rbanic camic, solo wa'im, solo quicotemal. Queri' ja xtinban, ne' kaj ja biyom pa ranma. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pro quewa' bix tre rmal ja Dios ri': —Nacnic achi, chipan awa' jun ak'a' ri' puersa natcami in nojel ja meba'il ja rac'olon jari' xa nq'ueje' can, ne'xi ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Queri' c'a rbanic jun winak ja tok xa nq'uiyirsaj ja meba'il xin rwach'ulew pro mta ja meba'il xin Dios c'o ruq'uin. Queri' ja c'ambal tzij ja xbij chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","C'ac'ari' xumaj tzij cuq'uin ja rdiscípulo, quewa' xbij chique ri': —Rmalc'ari' ja tok nbij chewe, maxta tek'isaj ewi' tre ja rec'aslemal: —¿Nak nkatij c'awa'? maxta quixche'e, in nixtac'a ja nc'atzin tre ja recuerpo chakaja': —¿Nak nkacoj chi c'awa'? maxta quixche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ja Dios arja' nuya' nojelal ja nc'atzin tre ja rec'aslemal in tre ja recuerpo ¿la matuya' c'ari' chewe chakaja' ja netij in ja necoj? ");
INSERT INTO tzjNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","¿La maque'etz'at c'a ja tak tz'iquin? Eje'e' nixtac'a c'o ta tijco'm nquetic in nixtac'a c'o ta cosecha nquec'ol, mta quitroja pro ja Dios arja' ntzuku quixin. Pro ja rixix más na ix vale chiquewach ja tak tz'iquin. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","In jun chic, ni majun chewe masqui congana nk'isaj ri' ncowin ta ruyon nuya' ta rq'uiybal nel ta más nim rkan. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Como maquixcowini neban ja wari' ¿nak c'a tre tok nek'isaj ewi' rmal ja jule' chic ja nc'atzin chewe? ");
INSERT INTO tzjNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tewasaj mpe' ena'oj trij ja cotz'i'j nak nuban tok nq'uiyi pro matisamaji in matik'inoni. Ja c'a ranin nbij chewe camic, ja rojer rey Salomón masqui congana biyom pro mta rtziak xucoj ta ja más buena ta chwach rcoloril jun trewa' jule' cotz'i'j ri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ja cotz'i'j masqui xa ncami, masqui xa nchakiji chanim in nporox pa k'ak' pro ja Dios arja' nuya' rcoloril. Ja wi queri' nuban ¿la matuya' c'ari' chewe chakaja' ja retziak necoj? Xarwari' nbij chewe, ma kas ta yukul ec'u'x ruq'uin ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Rmalc'ari' nbij chewe, ma tek'isaj ta ewi': —¿Nak nkatij c'awa'? maxta quixche'e in: —¿Nak nkacoj c'awa'? maxta quixche'e chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Queri' nbij chewe como ja winak ja ma cotak ta rwach ja Dios eje'e' ri' ja nebano queri'. Ja c'a chewe ixix, ja retata' Dios arja' bien rotak chi nc'atzin chewe nojel awa' wari'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pro ja kas rjawaxic chi neban, ja gobierno xin Dios ni ta ja wari' nech'ob. Ja wi queri' neban nojel awa' ja nc'atzin chewe nyataj chewe. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ixix ix cani' jun ti moc tak carnelo pro ma texbej ta ewi' como ja retata' Dios arja' rchomin chic chi nixrucoj chipan ja gobierno rxin. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ja c'o je'e ewq'uin tec'ayij in tesipaj ja rjil chique tak meba'i'. Ja wi queri' neban jari' c'oli cani' jun c'olbal emeba'il nyataj na chewe pro mta yojtajic trij in c'oli chakaja' ja meba'il ewxin xin chila' chicaj pro jun meba'il ja ni mta wi' q'uisic trij. Ni majun alak'om xtoc ta tri' nixtac'a c'o ta jun chicop ja xtitijo ta ja meba'il. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Anin xinbij chewe ja tzij ri' como xa nak ta chi meba'il benak ec'u'x ruq'uin tri' c'o wi' ja rewanma chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Quixc'asc'oti in maxta tichupi ja recandil. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tebana' ixix ja cani' nqueban jule' ajsamajela' ja cayben ja quipatrón benak pa jun c'ulbic in chaka jalal tok nmelojto ja quipatrón, nc'onc'o'oc ja chi'jay in eje'e' como ec'asc'otnak nquejakla' chwach chanim. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Congana qui'il chique ja rajsamajela' ja rec'asc'otnak chi raybexic ja quipatrón ja tok xturkaji. Ni katzij wi' nbij chewe, ja patrón arja' nchomarsla' ri' chanim, nertz'uba' pa mesa in numaj quilixic. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ja c'a wi nmelojto pa tak nc'ajak'a' owi pa rsakaric congana qui'il chique ja wi ec'asc'otnak chi raybexic tri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pro bien teya'a' ewxquin tre ja xtinbij chewe ri', jun rajaw jay ja tok nba̱n alak' ruq'uin, ja wixta rotak nak hora chi nekaji ja ralak'om ruq'uin chak'a' nchajij ta c'ari' rochoch, nc'asc'ot ta c'ari' in maquita nuya' lugar tre ja ralak'om chi noc ta pa rochoch. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Rmalc'ari' nbij chewe, ni rjawaxic wi' chi nixc'asc'ot ixix chakaja' como ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak arja' chaka jalal tok xtipi chic jutij chipan jun hora ja ni ma ech'obon ta, ne'e ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","C'ac'ari' ja Pedro xbij tre: —Wajaw ¿la xa ruyon chake ajoj xabij wi' ja c'ambal tzij o la xabij chique canojelal? ne' tre. Ja c'a Jesús quewa' xbij ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","—Tech'obo' c'a chi utz ja xtinbij chewe ri', ja rajsamajela' ¿echinatak ja nebano cumplir ja nbix chique cumal ja quipatrón, echinatak ja buena quina'oj? Cani' tre jun patrón tok c'o jun ajsamajel ruq'uin in nuya' rsamaj chi arja' npe'e chiquij ja jule' chic rach tak ajsamajela' chi neruban cuenta in nuya' queway ja tok nc'atzin chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Congana qui'il tre ja rajsamajel ja wi ntajini nuban cumplir ja rsamaj ja tok xturkaji ja rpatrón ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","¿Nak nuban ja patrón? Seguro chi nojel ja meba'il c'o ruq'uin nujach pa ruk'a' jawa' jun ajsamajel ri' chi arja' npe'e trij. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pro ja rajsamajel wi xa nbij kaj pa ranma chi: —Nak la k'ij npit ari' ja npatrón, wi ne' kaj, in wi numaj quich'ayic ja rach tak ajsamajela' e cachbil ja raj'ic'a', wi xa banoj tak wa'im nuban, wi numaj tijoj tak ya' in wi xa nk'abari, ");
INSERT INTO tzjNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ja wi xa queri' ntajini nuban nerila' na jun k'ij tok c'a ja' xtuna' xturkaji ja rpatrón, ni majun nak ta rnaben. Ja c'a rajsamajel janila jun nimlaj rpokonal xtutij pa ruk'a' ja rpatrón in nta̱kel rmal chipan ja lugar ja bar ec'o wi' ja winak ja xa maquenimani. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ja rajsamajel ja rotak nak ja najo'x tre rmal ja rpatrón chi nuban in wi c'a matichomarsaj ri' chi rbanic ja samaj in wi matuban rvoluntad ja rpatrón jari' congana jun nimlaj rpokonal nutij na rmal. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ja c'a rajsamajel ja ma rotak ta nak ja najo'x tre rmal ja rpatrón chi nuban in wi c'oli nuban in wi yatal trij chi nba̱n castigar rmal jari' ma kas ta nim ja rpokonal nutij. Ja tok q'uiy ja nsipax chawe rmal ja Dios jari' q'uiy ja xtic'utux chawe rmal chakaja' chi naban. Ja tok q'uiy ja nja̱ch pan ak'a' jari' más na q'uiy ja xtic'utux chawe. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Anin c'oli cani' jun k'ak' ntzijel wawe' chwach ja rwach'ulew, xinpeti chi rtzijic jari' k'ak' in ja ta nwajo' rmajonel chi ta c'atem camic ri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pro nabey c'oli ja nba̱n na chwe cani' ninban bautizar chipan jun nimlaj rpokonal in ja kas ngana anin k'axnak chi ta na chwij ja bautismo ri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿La xa ruyon quicotemal ja nc'amonto wawe' chwach'ulew nech'ob ixix? Ma queri' ta. Anin nbij chewe chi ec'oli winak ja xa división xtiqueban mwal. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Queri' nbij chewe como numajel ja banoj división mwal camic. Ja wi e jo'o' winak ja rec'o pa jun jay xa división xtiqueban mwal, e oxi' chique neyictaj chiquij ja re ca'i' chic in ja re ca'i' neyictaj chiquij ja re oxi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ja tatixel nyictaj trij ja rc'ajol in ja c'ajolaxel nyictaj trij ja rtata'. Ja te'ej nyictaj trij ja ral in ja xtan nyictaj trij ja rute'. Ja rixok nyictaj trij ja rali' in ja ralibotz nyictaj trij ja ralite'. Queri' xbij ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","In chakaja' c'oli xbij chique ja winak quewari': —Ja tok c'oli ja sutz' netz'at ja nwinakari pan oeste chanim nebij chi c'o jab penak in ni katzij wi' chi nkaji ja jab. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","In jun chic, ja tok numaj xcomel nebij chi c'o jun c'atan nuc'amto in ni katzij wi' chi npeti ja c'atan. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Caca' epalaj, ixix bien nch'obtaj emwal nak rc'amonto ja netz'at je'e chicaj in ja netz'at je'e chwach ja rwach'ulew pro ¿nak c'a tre ja tok matich'obtaj emwal nak rc'amonto ja ntajini nuban ja Dios chewach chipan ja tiempo ja rokc'o wi' ri'? ");
INSERT INTO tzjNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Nak tre tok matech'ob ixix eyon nak ja rubey chi neban? ");
INSERT INTO tzjNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ta c'a c'o ta jun nyo' parte chewij, mejor ja neban, tok emajon bey ixbenak pa k'etbaltzij techomij ewi' ruq'uin, nowi ma queri' ta neban, ja nyo' parte chewij arja' nixrujach pa ruk'a' ja ralcalta, ja c'a ralcalta nixrujach chic pa ruk'a' comisario in nixrucoj pa che'. ");
INSERT INTO tzjNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Anin nbij chewe chi ni maquixelto wi' ja pa che', nixelto c'a pro netoj can na nojel ja rec'as, nixtac'a c'o ta jun ti centavo ja maquita xtetoj can. Queri' xbij ja Jesús chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ec'o c'a jule' winak tri' eje'e' quemaj rcholic chwach ja Jesús ja queban jule' achi'i' ja raj Galilea ja xecamsax rmal ja gobernador Pilato. Ja quiquiq'uel ja rachi'i' jari' xeryuju' ri' ruq'uin ja quiquiq'uel jule' chicop ja netajini netzujux chwach ja Dios cumal ja rachi'i' como sacrificio. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ja c'a Jesús tok xc'axaj ja tzij ri' quewa' xbij chique ri': —Ja raj Galilea ja xecamsaxi ¿la más na e aj'il la más na e ajmaqui' chiquewach ja jule' chic cach tak aj Galilea nech'ob ixix ja tok ban queri' chique? ");
INSERT INTO tzjNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ma queri' ta. Tzuc'a chewe ixix chakaja' wi mateq'uex ja rena'oj, wi mateya' can ja ritzelal jari' camíc nesiq'uij chewij chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","In jun chic, turkaj chewe ja re dieciocho winak ja tok tzakto ja torre xin Siloé chiquij in xercamsaj. ¿La más na e aj'il la más na e ajmaqui' chiquewach ja jule' chic winak ja rec'o tri' pa Jerusalén nech'ob ixix? ");
INSERT INTO tzjNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma queri' ta. Tzuc'a ixix chakaja' wi mateq'uex ja rena'oj, wi mateya' can ja ritzelal jari' camíc nesiq'uij chewij chakaja', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","C'o jun c'ambal tzij xbij chique chakaja', quewa' xbij chique ri': —C'o jun achi c'o jun mocaj higo rticon pa rchenoj. Ja c'a rachi arja' be ruq'uin ja che' nertz'ata' ja wi c'o rwach pro ja tok xekaji ni majun rwach ja che'. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","C'o jun ajsamajel ja nchajin rxin ja chenoj quewa' xbij tre ri': —Jawa' jun mocaj higo ri' juna' juna' ni nuntz'ata' wi' ja wi c'o rwach nuya'. Oxi' juna' nbanon quewa' in nixtac'a c'o ta jun ti rwach ntz'aton ta. Mejor tachoyo', chaka queri' nuq'uis rchok'ak' ja rulew, ne' tre ja rajsamajel. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","—Ch'enchila' ta', tiq'ueje' chi na jun juna'. Anin nchak' na ruxe' in ncoj abono chuxe' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Matzij xa xtiwachini nowi mani tokoc'ari' xtachoy, ne'xi ja rajaw chenoj. Queri' ja c'ambal tzij ja xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ja c'a pa jun xula'nbal k'ij ja Jesús arja' rmajon quitijoxic ja winak chipan jun jay xin molbal ri'il. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","C'o c'a jun ixok tri' yawa', tuban dieciocho juna' toqui ja yobil tre rmal jun itzel espíritu. Rmalc'ari' tok luclic rij ja rixok, maticowini jic ta xtipe'i nixtac'a jutz'it ta. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ja c'a Jesús tok xutz'at ja rixok xsiq'uij pon. Ja tok xurkaj ruq'uin quewa' xbij tre ri': —Camic ixok, ma atc'o chi ta pa ruk'a' ja yobil, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","C'ac'ari' xuya' ruk'a' pa rwi' in ni jari' hora tzuri, ma luclic chi ta rij, congana xumaj rya'ic ruk'ij ja Dios rmal. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pro peti ja jefe rxin ja jay xin molbal ri'il, arja' congana penak ryewal como ja Jesús pa jun xula'nbal k'ij xtzursaj wi' ja rixok in quewa' xbij chique ja winak ri': —Ja chipan jun semana waki' k'ij ja yatal chake chi noksamaji. Tre ja waki' k'ij jari' utz nixpeti xa nak ta chi k'ijal chi nixtzuri pro ma quixpi ta jutz'it pa tak xula'nbal k'ij, ne'e ja jefe chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ja c'a kajaw Jesús tok xc'axaj ja xbij ja jefe quewa' xbij tre ri': —Ca'i' apalaj. Ixix ja pa tak xula'nbal k'ij ¿la mta c'a jun chewe ja maquita nuquirel ja rwacax owi ruquiej in maquita nuc'amel nerya'a' ruya'? ");
INSERT INTO tzjNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ja c'awa' jun ixok ri' arja' riy rumam can ja rAbraham. Ja camic tuban dieciocho juna' ximtal chipan ja yobil rmal ja Satanás. ¿La ma yatal ta c'a tre chi nel libre pa ruk'a' ja yobil camic masqui xula'nbal k'ij nach'ob atat? ne' tre ja jefe. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ja c'a winak ja xetzelan rxin tok quic'axaj ja tzij ri' congana q'uixbal quena' rmal. Ja c'a jule' chic winak eje'e' congana xequicot rmal ja nimak tak samaj xin Dios ja rbanon. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","C'ac'ari' xumaj chic jutij tzij ja Jesús, quewa' xbij chic ri': —¿Nak c'a rbanic ja gobierno xin Dios, bar c'a njunsaj wi'? ");
INSERT INTO tzjNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ja gobierno xin Dios queri' rbanic cani' rbanic jun ti chirwach mostaza c'amarel rmal jun achi, xutic pa rchenoj. Xumaj q'uiyem ja mostaza, xoqui cani' jun mocaj che'. Xepeti ja tak tz'iquin, xurquibana' quesoc pa tak ruk'a'. Queri' xbij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","C'ac'ari' xbij chic jutij: —¿Bar c'a njunsaj chi wi' ja gobierno xin Dios? ");
INSERT INTO tzjNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Queri' rbanic cani' nuban jule' levadura ja nsapoji caxlanway rmal in c'o jun ixok xuc'am, xuya' chipan jule' k'or, oxi' pajbal harina ocnak. Ja c'a tok q'uiswani ja levadura mta ja maquita xekaj wi' tre ja k'or, congana samaj chipan, ne'e ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","C'ac'ari' xumajel chic rubey, benak pa Jerusalén. Ja tok nekaj pa jun tinamit owi pa jun aldea numaj quitijoxic ja winak ja rec'o chipan. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","C'o c'a jun chique ja winak c'oli xc'axaj tre ja Jesús quewari': —Wajaw ¿la xa ma e nim ta ja newilowi ja totajem xin Dios? Ja c'a Jesús arja' xumaj tzij cuq'uin ja winak, quewa' xbij chique ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—C'oli cani' jun pa rchi'jay ja congana ti latz' ja bar natoc wi' chi rilic ja totajem xin Dios. Tetija' c'a ek'ij utzc'a chi tri' xquixoc wi' ixix. Pro tecojo' ewachok'ak' como e q'uiy ja winak ja ma xque'oc ta masqui c'o quigana ne'oqui. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Como ja rajaw jay arja' xtiyictaji in ntz'apij ruchi' ja jay. Ja c'a rixix wi maja'n quixoqui tri' jari' xtemaj rc'onc'oxic ja puerta in quewa' xtebijoc ri': —Kajaw, Kajaw, tajaka' chi'jay chikawach, xquixche'oc tre. Ja c'a rajaw jay quewa' xtibijto chewe ri': —Anin ma wotak ta ba la ixpenak wi' ixix, xtiche'to chewe. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","—Pro ajoj okwa'nak wa'an awq'uin in xe'atijoj wa'an ja winak pa tak bey chipan ja katinamit, xquixche'oc chic tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","—Anin nbij chewe chi ma wotak ta ba la ixpenak wi'. Camic quixel chinwach ewanojel ja rix banol tak itzelal, xtiche'to chic chewe. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tokoc'ari' tok xtetz'at ja rAbraham chi arja' c'o chipan ja gobierno xin Dios e rachbil ja rIsaac in Jacob e rachbil chakaja' canojel ja rojer tak profeta xin Dios pro ja c'a rixix ma xtiyataj ta chewe chi nixoc ta chiquicojol. Rmalc'ari' ja tok xtemaj jun nimlaj bis ok'ej in xtecach'ach'ej ewak' rmal. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","In chakaja' ec'oli winak ja ma e aj Israel ta eje'e' nepi na nojel nat nakaj tre ja rwach'ulew, ne'oc na chipan ja gobierno xin Dios in netz'abe' chi mesa. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pro bien tewotakij chi ec'oli winak ja rec'amol tak bey nabey ja xquecanaj can pa rq'uisbal in ec'oli ja re tak q'uisbal ja nec'amo chic bey. Queri' xbij ja Jesús chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jari' mismo k'ij ec'o jule' fariseo xe'ekaj ruq'uin in quewa' quibij tre ri': —Jat, catanmajel como ja gobernador Herodes arja' c'o rgana natrcamsaj, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ja c'a Jesús quewa' xbij chique ri': —Ja Herodes arja' xa banol engaño. Camic jix ruq'uin in quewa' nebij tre ri': —Ja Jesús nbij chi c'a ec'o na ja winak ja nerlasaj na itzel tak espíritu chique in c'a ec'o na ja yawa'i' ja nertzursaj na chakaja'. Queri' nuban camic in chwak in c'a chi rox k'ij xtuq'uis wi' ja rsamaj, ne'e, queri' ja nebij tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pro camic puersa nmajel chic jutij nubey. Ninbini camic, chwak in cabij, puersa ninbe pa Jerusalén in tri' nincamsax wi' como jun profeta xin Dios mta moda ja maquita pa Jerusalén xticamsax wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ixix ja rix aj Jerusalén, anin congana ninbison emwal. Ja profeta xin Dios xa ne'ecamsaj. Ja c'a jule' chic ajsamajela' rxin Dios ja neta̱k ewq'uin xa ne'eq'uiak tza'n abaj. Anin q'uiylaj mul xinwajo' ta xixnuto' ta ja cani' nuban jun ac' nermutzej ja tak ral xe' rupan pro ja rixix ma xewajo' ta. ");
INSERT INTO tzjNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Camic bien tec'waxaj ja xtinbij chewe ri', ja retinamit rachbil ja templo c'o chipan jari' ya'on can chic rmal ja Dios, lawulo' xtiban na tre in xa ntale' can. Queri' nbij chewe como camic matutz'at chic ri' kawach ewq'uin, c'a tokori' nutz'at chic jutij ri' kawach ewq'uin ja tok xterila' ja k'ij tok quewa' nebij chic chwe ri': —Bendecido ja Cristo ja penak pa rubi' ja kajaw Dios, xquixche' chwe. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ja c'a pa jun xula'nbal k'ij be ja Jesús chi rochoch jun fariseo ja nim ruk'ij chi newa' ruq'uin. Ja c'a tok xekaji majtaj rc'ambajaxic cumal ja winak ja quimolon qui' tri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","C'o c'a jun achi yawa' majtajnak rmal sapoj. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ja c'a Jesús arja' xumaj tzij cuq'uin ja maestro ja netijon quixin ja winak tre ja ley xin Dios e cachbil ja fariseo: —Tebij chwe, nak nbij ja ley ¿la nuya' lugar chwe chi nentzursaj ja yawa'i' pa tak xula'nbal k'ij? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pro ja c'a reje'e' ni majun quibij tre. C'ac'ari' xuchap ja yawa' in xtzursaj: —Utz chic natbe, ne' tre, in be ja yawa'. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ja c'a Jesús arja' xumaj chic jutij tzij cuq'uin ja maestro e cachbil ja fariseo, quewa' xbij chic chique ri': —¿La c'o c'a jun chewe c'o ta jun ruquiej owi rwacax ntzakel ta pa jul pa jun xula'nbal k'ij in matilasajto c'a chanim chipan ja jul? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pro ja reje'e' ni ma xcanoy ta wi' cumal nak ta nquibij tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ja c'a Jesús xerutz'at ja winak ja rebanon invitar pa wa'im chi eje'e' netajini nquecha' ja tz'ulbal ja más nimak ruk'ij rmalc'ari' tok c'o jun c'ambal tzij xbij chique quewari': ");
INSERT INTO tzjNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ja tok natban invitar pa jun wa'im xin c'ulbic maxta tacanoj jun tz'ulbal ja más nim ruk'ij matzij turkaj chic jun ja rinvitado ja más chi na nim ruk'ij chawach atat ");
INSERT INTO tzjNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","in chaka jalal tok xtibix chawe rmal ja rachi ja banyon invitar ewxin chi ix ca'i': —Taya'a' can ja tz'ulbal ri', c'o jun achi ja nc'amonto ri' arja' ntz'abe' chwach, xtiche' chawe. Ja wi queri' xtibix chawe jari' congana q'uixbal xtana' in puersa natetz'abe' chwach ja q'uisbal tz'ulbal. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mejor ja naban, ja tok natban invitar cattz'abe' chwach ja q'uisbal tz'ulbal. Ja c'a rachi ja xatbano invitar tok xturkaj awq'uin quewa' xtibij chawe ri': —Jo' amigo, catetz'abe' chwach jun tz'ulbal ja más chi na nim ruk'ij, xtiche' chawe. Ja wi queri' xtibix chawe jari' canojel ja rinvitado ja retz'ubul awq'uin pa mesa eje'e' natquetz'at chi nim ak'ij. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Queri' c'a rbanic como xa nak ta chi winakil ja xtuya' kaj ruk'ij ruyon jari' xtikajsax na. Ja c'a wi naban tino'y jari' xtiya' na ak'ij, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","C'oli chakaja' ja xbij tre ja rachi ja banyon invitar rxin, quewa' xbij tre ri': —Ja tok ec'oli winak ja ne'aban invitar chi nurquibana' jun almuerzo awq'uin owi jun cena maxta xa queyon awamigo que'aban invitar owi e animal owi e achak' owi ja jule' chic awach'alal owi ja ravecino ja re biyoma'. Ja wi eje'e' ri' ja ne'aban invitar jari' xa natqueban chic invitar atat pa jun chic wa'im, xa nqueya' rc'axel chawe. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pro ja naban, tok ec'oli winak ja ne'aban invitar chi nurquibana' jun wa'im awq'uin que'abana' invitar ja tak meba'i' e cachbil ja winak ja ma tz'akat ta je'e quek'a' e cachbil chakaja' ja tak cojo in tak moya'. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ja wi queri' naban jari' c'o jun quicotemal xin Dios xtiyataj na chawe como ja winak ja c'a xennataj ri' eje'e' maquecowini xtiqueya' ta rc'axel chawe. Natquicoti como c'o jun rtojbalil ja xtiyataj na chawe, tokori' xtiyataji ja tok xquec'astaji ja winak ja utz netz'a̱t rmal ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","C'o c'a jun ja tz'ubul pa mesa tok xc'axaj ja xbij ja Jesús quewa' xbij tre ri': —Congana qui'il chique ja winak ja xquebano wa'im chipan ja gobierno xin Dios, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ja c'a Jesús c'o jun c'ambal tzij xbij tre quewari': —C'o jun achi c'o jun nimlaj wa'im xuban in e q'uiy ja winak ja xeruban invitar. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ja c'a tok xuban hora xin wa'im c'o jun rmoso xutakel chi quisiq'uixic ja rinvitado. Ja c'a moso tok xe'ekaj cuq'uin ja rinvitado quewa' xbij chique ri': —Jo', chomtajnak chic ja wa'im nojelal, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ja c'a rinvitado eje'e' xa junan queban, quemaj rbixic tre ja moso nak tre tok maquecowini nebe ja pa wa'im. Ja nabey quewa' xbij tre ri': —Anin xa c'o jun ulew xinlok' in puersa nentz'ata' na. Chanumac, maquincowini ninbe, catche' tre ja rapatrón, ne' tre ja moso. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","C'o chic jun ja rinvitado quewa' xbij tre ja moso ri': —Anin xa ec'o jo'o' c'ulaj wacax xin careta xenulok'. Ja camic ninbe cuq'uin chi ne'enc'ambajaj na. Chanumac, maquincowini ninbe, catche' tre ja rapatrón, ne'e ja rucab. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","In c'o chi c'a jun quewa' xbij tre ri': —Anin c'a xinc'ule'e chewi' tok maquincowini ninbe ja pa wa'im, ne' tre ja moso. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ja c'a moso arja' melojto. Ja tok xurkaj ruq'uin ja rpatrón xuchol chwach nojel ja bixto tre. Ja c'a rajaw jay arja' pi ryewal chiquij ja rinvitado in quewa' xbij chic tre ja rmoso ri': —Catmeloj chic jutij chanim ri', jat pa tak bey rxin ja tinamit in jat pa tak solbal bey chakaja', que'acanoj ja tak meba'i' e cachbil ja winak ja ma tz'akat ta je'e quek'a' e cachbil chakaja' ja tak cojo in tak moya', que'ac'ama'to wawe'. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Queri' c'a xuban ja moso ja cani' bixel tre. Ja c'a tok melojto chic quewa' xbij tre ja rpatrón ri': —Ta', xenbana' ja cani' xabij chwe pro ja tz'ulbal c'a c'o na ja mta rajaw, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ja c'a patrón quewa' xbij chic tre ja moso ri': —Catmeloj chic jutij pro ja camic natel chipan ja tinamit chi quicanoxic ja winak, ne'acanoj pa tak bey chi nimak tak bey chi co'cojlaj tak bey in ne'acoj pa ch'a'oj chi puersa nepeti utzc'a chi xquenoji ja winak pa wochoch, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Como camic nbij chewe chi ja winak ja xeba̱n invitar nabey ni majun nak ta chique xtiyataj ta tre xtuban ta ja wa'im ja xtinchomij anin. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Xumaj chi c'a jutij rubey, congana jun winak etran trij. Arja' xuya' vuelta in quewa' xbij chique ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Xa nak ta ja c'o rgana noc ndiscípulo rjawaxic chi más na ninrajo' anin chwach ja rtata' owi rute' owi rxjayil owi chiquewach tak ralc'wal owi rnimal owi tak ruchak' owi tak rana'. Rjawaxic chi más na ninrajo' anin chwach ja nrajo' kaj ri' arja' ruyon. Ja wi más na nerajo' eje'e' chinwach anin jari' mta moda xtoc ta ndiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Xa nak ta ja npokonaj ntre'el chwij in npokonaj nutij rpokonal ja cani' nutij rpokonal jun achi rmajon rijkaxic jun cruz jari' mta moda xtoc ta ndiscípulo chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Queri' nbij chewe como ¿la c'o ta c'a jun chewe xtuban ta jun nimlaj jay in maquita ntz'abe'e nabey in numaj rch'obic pan ekal jani' ja pwok nrajo' utzc'a chi nrotakij ja wi ntzur rmal chi nuq'uis rbanic ja jay owi mani? ");
INSERT INTO tzjNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ja c'a wi matuch'ob chi utz matzij xa ma xticowin ta xtuq'uis rbanic ja jay in xa ruyon ja rsimiento'il ja xtutic can. Ja c'a winak tok xtiquetz'at xtiquemaj ryok'ic canojelal, ");
INSERT INTO tzjNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","quewa' xtiquibij ri': —Jala' jun achi le' xumaj rbanic ja jay pro ma xcowin ta xuq'uis ta rbanic, xqueche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","In jun chic, tac'a jun rey e rachbil ta lajuj mil soldado in c'o chi ta c'a jun ja rey ja nurbana' ch'a'oj ruq'uin pro e veinte mil soldado ec'o ruq'uin. Ja rey ja xa e lajuj mil soldado ec'o ruq'uin ¿la nuban ta c'a ch'a'oj ruq'uin ari' ja jun chic rey in maquita c'a ntz'abe' ari' nabey in numaj rch'obic ja wi ncowin trij? ");
INSERT INTO tzjNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ja wi nuch'ob chi maticowin trij quewa' nuban ri'. Ja tok c'a c'a nat c'opi wi' ja jun chic rey nerutakel jule' tajko'm ruq'uin chi nerchomij ruq'uin utzc'a chi matiqueban ja ch'a'oj. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Queri' c'a rbanic, xa nak ta chewe ja npokonaj nuya' can nojelal ja c'o ruq'uin jari' mta moda xtoc ta ndiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ja ratz'am buena samaj nuban pro ja wi xtiyojtaji wi mchita rtzayil ¿nak c'a nchomarsbex chic rxin ari'? ");
INSERT INTO tzjNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ja wi queri' nuban jari' mchita noc wi', mta rsamaj xtacoj ta pan ulew nixtac'a xtayuj ta ruq'uin k'ayis como abono pro ja nba̱n chic tre xa nch'akixel. Bien c'a tewasaj ena'oj trij ja c'a xinbij chewe ri'. Queri' xbij ja Jesús chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ja c'a molol tak impuesto e cachbil ja jule' chic winak ja raj'il ajmaqui' neche'xi eje'e' xetiloc más ruq'uin ja Jesús canojelal utzc'a chi nquic'axaj nak ja ntajini nbij. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ec'o c'a jule' fariseo e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios eje'e' quemaj rtzijoxic ja Jesús: —Jala' jun achi le' xa ma utz ta ja nuban, taka'an neruc'ul ja raj'il ajmaqui' in nwa' taka'an cuq'uin chakaja', xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ja c'a Jesús arja' xumaj rbixic jun c'ambal tzij chique quewari': ");
INSERT INTO tzjNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿La c'o ta c'a jun chewe ec'o ta jun ciento tak rcarnelo in ntzak ta c'a jun chique in maquita neruya' can ja noventinueve pa tak k'ayis in maquita nercanoj chi puersa ja tzaki? ");
INSERT INTO tzjNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ja tok ncanoy rmal nch'elejto, congana nquicot rmal. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ja tok nekaj chi rochoch nutak quisiq'uixic ja ramigo e cachbil ja rvecino in quewa' nbij chique ri': —Camic quixquicot wq'uin como canoy mwal ja ti ncarnelo ja tzaki. Queri' nbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","In queri' c'a nbij anin chewe chakaja', jun aj'il ajmac tok nuq'uex rna'oj in nuya' can ja ritzelal jari' más chi na nequicoti ja rec'o chila' chicaj chwach ja tok ec'o noventinueve ja re utzlaj tak winak neche'xi ja mta rjawaxic chique chi nqueq'uex quina'oj. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","In jun chic ¿la c'o ta c'a jun ixok c'o ta lajuj tak pwok ruq'uin in ntzak ta c'a jun tre in maquita nutzij jun candil in maquita nuban mes pa jay in maquita ncanoj chi puersa? ");
INSERT INTO tzjNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ja tok ncanoy rmal nutak quisiq'uixic ja ramigo e cachbil ja rvecino in quewa' nbij chique ri': —Camic quixquicot wq'uin como canoy mwal ja npwok ja ntzakon, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","In queri' c'a nbij anin chewe chakaja', jun aj'il ajmac tok nuq'uex rna'oj in nuya' can ja ritzelal jari' congana nequicoti ja ángel trij xin Dios. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","C'ac'ari' c'o chic jun ja c'ambal tzij xbij chique quewari': —C'o jun achi ec'o ca'i' rc'ajol. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Peti ja rcabal, quewa' xbij tre ja rtata' ri': —Ta', camic tajacha' ja herencia, taya'a' chwe ja wxin anin, ne' tre. In queri' xuban ja tatixel, xujach ja herencia chique chi e ca'i'. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ja tok xuban jun ca'i' k'ij xchomarsaj ri' ja rcabal, xumol ruchi' nojel ja jachon tre. Ja tok moltaj rmal c'ac'ari' xumajel rubey be pa jun natlaj tinamit. Ja tok xekaj chipan ja tinamit xumaj rsachic ja rpwok, xuban xa nak ta ja c'o rgana chi nuban, xa ma ch'obol ta xuban tre rsachic. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ja tok sachtaj rmal ja rpwok nojelal pi c'a jun nimlaj wa'al ja bar c'o wi' in rmalari' ja tok majtaj rmal jun nimlaj wa'al. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","C'ac'ari' be xercanoj rsamaj ruq'uin jun achi ja c'o chila' chipan ja tinamit. Ja c'a rachi arja' c'o jun rulew pa tak k'ayis ja bar erya'on wi' jule' ak, tri' xutakel wi' ja rala' chi quiyuk'uxic ja ak. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ja c'a rala' congana majtajnak rmal wa'al hasta c'o rgana nutij queway ja ak. Ni majun winak nyo' ta rway. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ja tok ch'obtaj rmal ja rbanon quewa' xbij kaj pa ranma ri': —Ja moso ja nesamaj ruq'uin ja nata' e jaru' la ja sobre queway pro ja ranin inmajtajnak rmal wa'al. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Camic ninmeloj ruq'uin ja nata' in quewa' nenbij tre ri': —Nata', ja xinban, xinmacun chwach ja Dios in xinmakun chawach atat chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ja camic ma yatal chi ta chwe chi xtabij chi ta chwe chi in ac'ajol, quinacojo' como jun amoso, nineche' na tre, ne' kaj ja rala'. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","C'ac'ari' xumajto rubey, melojto ruq'uin ja rtata'. Ja c'a tatixel xutz'at pon ja rc'ajol penak pro c'a c'a nat c'opi wi'. Congana xpokonaj rwach, c'amc'oj ranim be xerc'ulu', xk'etej in xtz'ubaj ruchi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ja c'a rala' xbij tre ja rtata': —Nata', ja xinban, xinmacun chwach ja Dios in xinmacun chawach atat chakaja'. Ja camic ma yatal chi ta chwe chi xtabij chi ta chwe chi in ac'ajol, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pro ja c'a tatixel arja' xersiq'uij ja rmoso in quewa' xbij chique ri': —Tewasajto ja tziak ja más na buena jari' newekbej ja nc'ajol. In jun chic, tecojo' jun nopk'a' chwiruk'a' in tecojo' rxajab chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","In jun chic, tec'ama'to ja wacax ja más na chak' chic in tepoch'o'. Kabana' jun wa'im, kabana' jun nmak'ij. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Queri' ta c'a nkaban como camic xurkaji ja nc'ajol ja rojer titzaki. Ja xinch'ob anin camnak chic pro c'a c'as na ek, ne'e ja tatixel. C'ac'ari' quemaj rbanic ja nmak'ij. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ja c'a nabey winak arja' benak pa chenoj. Ja tok melojto xajalal maja'n turkaji ja chi rochoch ja tok xc'axaj pon chi c'o jun nimlaj quicotemal majtajnak rbanic. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Xsiq'uij pon jun moso: —¿Nak c'a rbanic ala' ja nc'waxaj le'? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","—Camic melojto ja rachak'. Ja c'a ratata' arja' xutak rpoch'ic ja wacax ja más na chak' chic. Queri' xuban como c'a c'as na ja rachak', ti utz rwach xurkaji, ne'xi rmal ja moso. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ja tok xc'axaj ja tzij ri' congana yictaj ryewal rmal, ni mchita wi' rgana noc pa jay. Rmalc'ari' tok xelto na ja rtata' in xumaj rbochi'ixic utzc'a chi noc pa jay. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pro quewa' xbij tre ja rtata' ri': —Bien turkaj chawe chi anin q'uiylaj juna' insamajnak awq'uin in chakaja' mta ari' ja maquita xinnimaj ja xabij chwe chi nban. Pro atat ni mta wi' ja raya'on ta chwe ja nbanben ta jun nmak'ij cuq'uin wamigo nixtac'a jun ti q'uisic' ta. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pro jala' jun ac'ajol le' ja tok xurkaj wawe' rmal arja' xatakla' rpoch'ic ja wacax ja más na chak' chic pro makana' maquita xerq'uisa' can ja rameba'il cuq'uin itzel tak ixoki'. Queri' xbij ja nabey winak tre ja rtata'. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ja c'a tatixel quewa' xbij chic tre ri': —Nc'ajol, atat nij atc'o wi' wq'uin, awxin atat ja c'o wq'uin pro ni nojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pro ja camic mta moda ja maquita nkaban jun nmak'ij, mta moda ja maquita nokquicoti como camic xurkaji ja rachak' le' ja rojer titzaki. Ja xinch'ob anin camnak chic pro c'a c'as na ek, ne'e ja tatixel tre ja nabey winak. Queri' ja c'ambal tzij ja xbij ja Jesús chique ja fariseo e cachbil ja maestro. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","C'ac'ari' c'o jun c'ambal tzij xbij chique ja rdiscípulo quewari': —C'o jun achi biyom c'o jun ajsamajel ruq'uin ja nchajin rxin ja rmeba'il. Xebix tre ja biyom chi ja rajsamajel xa ntajini nuq'uis ja rmeba'il, xa ma ch'obol ta nuban tre, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ja c'a biyom arja' xutak rsiq'uixic ja rajsamajel in tok xekaji quewa' xbij tre ri': —Anin xurkaj rbixic wq'uin chi xa nattajini naq'uis ja nmeba'il. ¿Nak tre ja tok xaban queri'? Camic tajacha' ja racuenta nak abanon tre ja nmeba'il como matinya' chic lugar chawe chi xcatsamaj chi ta más wq'uin, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ja c'a rajsamajel quewa' xbij kaj pa ranma ri': —¿Nak nban c'awa' camic como ja npatrón xa nwasaj chwe ja nsamaj? Como anin matincoch' chic ja xtinban ta samaj ja nrajo' awachok'ak', in jun chic, xa q'uixbal nna' ja xtinmaj ta rc'utuxic limosna. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Camic ch'obtaj mwal nak ja nban utzc'a chi ec'oli ja nec'ulu wxin pa tak cochoch ja tok mchita nsamaj, ne' kaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","C'ac'ari' xutak quisiq'uixic ja winak chiquijujunal ja c'o quec'as ruq'uin ja rpatrón. Ja tok xe'ekaji quewa' xbij tre jun ri': —¿Jaru' ac'as ruq'uin ja npatrón? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","—Anin jun ciento tonel aceite ja nuc'as, ne'xi rmal ja rajc'as. Ja c'a rajsamajel xbij tre: —Ji', rwujal ja rac'as ri', tac'ama'. Camic catz'abe'e, tabanla' chic jun ja wuj chanim ri' pro xa cincuenta tonel aceite ac'as natz'ibaj chic chipan, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","C'ac'ari' xbij tre jun chic ja rajc'as: —¿Jaru' ac'as atat? ne' tre. —Anin jun ciento quintal trigo ja nuc'as, ne'xi. In xbij chic tre: —Tac'ama' rwujal ja rac'as ri'. Tabana' chic jun pro xa ochenta quintal natz'ibaj chic chipan, ne'e ja rajsamajel tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ja c'a patrón tok xuya' cuenta tre ja rajsamajel ja ma utz ta xuban quewa' xbij ri': —Ja rajsamajel le' congana listo ja xuban chwe, congana rna'oj. Queri' xbij ja patrón in c'o razón ja tok xbij queri' como ja winak ja xa ruq'uin ja rwach'ulew yukul wi' quec'u'x eje'e' congana e listo tre ja banoj negocio cuq'uin ja cach banol tak negocio. Más chi na e listo chiquewach ja ralc'wal Dios ja sakirsan chic quebey. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ja meba'il xin rwach'ulew congana itzelal nqueban ja winak rmal. Pro camic nbij chewe, quixoc listo ixix chakaja', tecojo' ja meba'il xin rwach'ulew pro ja ta neban ixix tre ne'etobej ta ja c'o rjawaxic chique. Quirtari' neban utzc'a tok xtiq'uisi ja meba'il xin rwach'ulew c'ac'ari' ja rewamigo ja xe'eto' eje'e' nec'ulu ewxin chila' chicaj pa tak cochoch ja ni mta wi' q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ja meba'il xin rwach'ulew wi utz rcojic neban jari' utz rcojic xteban tre ja meba'il xin Dios chakaja' ja wi nyataj chewe. Ja c'a wi xa ma utz ta rcojic neban ja meba'il xin rwach'ulew jari' xa ma utz ta xteban tre ja meba'il xin Dios chakaja' ja wi nyataj chewe. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Rmalc'ari' tok nbij chewe, ja wi xa ma utz ta rcojic ebanon ja meba'il xin rwach'ulew jari' mta jun c'o ta rconfianza ewq'uin xtujach ta pan ek'a' ja meba'il xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","In jun chic, ja wi c'oli ja meba'il xin rwach'ulew jachon pan ek'a' chi nechajij pro wi xa ma utz ta rcojic neban jari' mta jun xtiyo' ta chewe ja herencia xin Dios ja ni katzij wi' chi ewxin. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Jun winak xa nak ta chi winakil ni majun moda xqueq'ueje' ta ca'i' rpatrón, ja queri' jun nrajo' in jun xa itzel nutz'at owi jun nnimaj in jun matinimaj. In queri' c'a tre chakaja' mta moda xtiyuke' ta ec'u'x ruq'uin ja Dios in xtiyuke' chi ta ec'u'x ruq'uin ja meba'il xin rwach'ulew. Queri' xbij ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ja c'a fariseo eje'e' quic'axaj chakaja' nojel ja xbij ja Jesús tre ja meba'il. Rmalc'ari' tok quemaj ryok'ic como eje'e' chaka benak chi nquiyarij ja meba'il xin rwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ja c'a Jesús quewa' xbij chique ri': —Ixix quewa' ebanic ri', nek'alasaj ewi' chiquewach ja winak chi congana ix utzlaj tak winak pro ja Dios arja' bien rotak nak ja c'o pa tak ewanma. Ec'oli winak ja xa itzel netz'a̱t rmal ja Dios masqui congana utz netz'a̱t cumal winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ja ley xin Dios rachbil ja tz'ibtal can cumal ja rojer tak profeta xin Dios jari' ocnak chipan ja tiempo ja tok Juan Bautista maja'n tumaj ja rsamaj. Pro ja tok xurwila' ja rtiempo ja Juan Bautista tri' xumajto wi' rbixic ja gobierno xin Dios in canojel ja winak netajini nquetij quichok'ak' utzc'a chi ne'oc chipan ari' gobierno. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pro mta moda ja maquita xtibantaj cumplir ja ley xin Dios nojelal. Ni ma c'ayew ta xtichup rwach ja caj in rwach'ulew chwach ja maquita xtibantaj cumplir jun ti punto tre ja ley. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jun achi xa nak ta chi achi'al wi nujach can chijutij ja rxjayil in wi nuc'am chic jun chic ixok jari' adulterio ja nuban. In wi c'o jun achi nuc'am jun ixok jachon can rmal ja rchajil jari' achi adulterio ja nuban, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","C'ac'ari' xbij chic chique: —C'o jun achi biyom, congana buen tak tziak nucoj ja nimak rjil. K'ij k'ij ni c'o wi' nimak tak wa'im nuban. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","In c'o jun ti meba' c'utul limosna, Lázaro rubi'. Ja c'a Lázaro arja' xeya̱' can chuchi' ja xoral rxin ja biyom. Ja rcuerpo c'o jule' itzel tak ch'a'c trij pro ni chi jun. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kas nyarij nutij ja rc'utal tak way ja ntzakel xe' tak mesa ruq'uin ja biyom. In c'uluto ec'oli tz'i' ja nebe ruq'uin, nquerak' ja ch'a'c ja c'o trij. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ja c'a tok q'uiswani cami ja ti meba' ja c'utul limosna, ruq'uin ja rAbraham c'amarel wi' cumal ángel ja bar ec'o wi' ja camnaki' ja quimajon quicotemal. Cami ja biyom chakaja' in xemuki. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ja c'a tok xuna' nojoj congana majtajnak rmal ja rpokonal chipan ja lugar ja bar ec'o wi' ja camnaki' ja quimajon bis ok'ej. Ja tok ca'y chicaj xutz'at pon ja rAbraham pro c'a c'a nat c'o wi', c'oloc ja Lázaro pa rxquin. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","C'ac'ari' xumaj rakic ruchi': —Tapokonaj nwach nata' Abraham. Tataka'to paki jutz'it ja Lázaro wq'uin, timu'u'to jun ti rwiruk'a' pa ya' chi nurxuc'ursaj ja wak' como anin c'o jun k'ak' wawe' in congana nmajon rtijic pokon chipan, ne' tre ja rAbraham. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ja c'a rAbraham quewa' xbij tre ri': —Turkaj chawe nc'ajol, ja tok xatq'ueje' chwach'ulew atat xattijowi ayon ja rameba'il pro ja c'a Lázaro arja' xa rpokonal xutij. Pro ja c'a camic congana qui' chi ruc'u'x ja Lázaro wawe' pro atat amajon chic rtijic ja rpokonal. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","In c'uluto c'o jun nimlaj siwan ya'on chikacojol utzc'a ja wi c'o jun wawe' ja c'o rgana nk'ax ewq'uin pro maticowini nk'axi owi c'o jun chewe ixix ja c'o rgana nk'axto kuq'uin pro maticowini nk'axto chakaja', ne'xi rmal ja rAbraham. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","C'ac'ari' xbij chic tre: —Ja wi queri' rbanic nata', tabana' jun utzil, tataka'el paki c'a jutz'it ja Lázaro cuq'uin wach'alal ja rec'o pa rochoch nata'. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Como e jo'o' ja wach'alal ja rec'o tri' in nwajo' nbe ta jutz'it ja Lázaro cuq'uin chi nerch'obo' chiquewach nak rbanic ja wawe' utzc'a chi maquepit eje'e' wawe' chakaja' chipan awa' jun lugar xin tijoj rpokonal ri', ne' tre ja rAbraham. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","In bix chic tre rmal ja rAbraham: —Pro c'o wa'an cuq'uin ja rtzobal Dios ja tz'ibtal can rmal ja Moisés in cumal ja jule' chic profeta, tiquiya'a' c'a quixquin tre ja quitz'iban can eje'e', ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","—Mni nata' Abraham, pro wi c'o jun camnak nelel chiquicojol ja camnaki' in nekaj cuq'uin jari' nqueq'uex quina'oj, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ja c'a rAbraham quewa' xbij chic tre ri': —Ja wi matiqueya' quixquin tre ja rtzobal Dios ja tz'ibtal can rmal ja Moisés in cumal ja jule' chic profeta jari' ni maqueniman wi' chakaja' masqui c'o jun camnak xtic'astaj chiquicojol ja camnaki', ne' tre. Queri' ja c'ambal tzij ja xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","C'ac'ari' xumaj tzij cuq'uin ja rdiscípulo, quewa' xbij chique ri': —Ja winak mta moda ja maquita netakchi'ixi chi rbanic ja il mac pro congana nutij na rpokonal xa nak ta ja ntakchi'in quixin. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Más na mejor nxi̱m jun ca' chi rukul chanim in neq'uia̱k pa ya' in njik'i chwach ja ntakchi'ij jun chique wa' ja yukul quec'u'x wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ja c'a rixix tebana' cuenta. Ja wi c'o jun ewach'alal xuban jun itzel chewe, ja neban, tech'a'a' tre, in wi nc'utuj sachbal rumac chewe tecuyu'. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Masqui wuku' mul nuban itzel chewe ja jun k'ij pro wi wuku' mul nurc'utuj sachbal rumac chewe jari' ni necuy wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ja c'a rapóstol quewa' quibij tre ja kajaw Jesús ri': —Camic naya' ta más ja yukulbal kac'u'x awq'uin, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ja c'a kajaw Jesús xbij chique: —Ja wi c'o yukulbal ec'u'x wq'uin, wi nsamaji ja yukulbal ec'u'x ja cani' nuban jun ti chirwach mostaza nixcowin c'ari' neban jun nimlaj samaj. Cani' trewa' ja jun mocaj che' ri', nixcowini nebij tre chi nboktajel rachbil rc'amal utzc'a chi netique'e pa mar in nixrnimaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ja wi c'o jun emoso c'a melojto pa chenoj owi pa yuk'un tak carnelo ¿la quewa' nebij tre ri': —Catocto, cattz'abe' pa mesa in catwa'i, la nixche' tre? ");
INSERT INTO tzjNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma queri' ta nebij tre pro ja nebij tre quewari': —Tachomarsaj ja nti' kaj camic, tacojo' ja ratziak ja xin ilinem in ninawilij pa mesa. Ja c'a tok xtincolbej wa'im c'a tokori' xcatwa' atat, nixche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ja rilinel wi xuban cumplir nojel ja xebij tre chi nuban ¿la nemaltioxij tre? Ja nch'ob anin matemaltioxij tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ja cani' rbanic ja rilinel queri' c'a ebanic ixix chakaja'. Ja tok xtibantaj cumplir emwal nojel ja nbij ja Dios chewe chi neban quewa' tebij ri': —Ajoj ok tak moso. Ja samaj kabanon jari' ma favor ta kaban ta tre ja Dios, ni chi kakul wi' c'o wi' chi kaban, mta kak'a' tre ja xtimaltioxij ta chake, quixche'e, ne'e ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","C'ac'ari' xumaj chic jutij rubey, benak pa Jerusalén. Ja bey xuc'am jari' ja nk'ax pa mojon rxin ja ca'i' departamento Samaria in Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ja tok xoc chipan jun tinamit ec'o lajuj achi'i' quec'ul qui' ruq'uin. Ja c'a rachi'i' eje'e' emajtajnak rmal ja ritzel tak ch'a'c chewi' tok c'a c'a nat xepe'eto wi' ruq'uin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Quemaj rakic quechi' trij: —Tapokonaj kawach Maestro Jesús, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ja c'a Jesús tok xerutz'at quewa' xbij chique ri': —Jix, jec'utu' ewi' chiquewach ja sacerdote, ne' chique. Xebe, kas c'a quimajon bey ja tok xetzuri, mchita ja ritzel tak ch'a'c chiquij. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","C'o c'a jun chique ja tok xutz'at chi tzuri meloji, congana nuban xumaj rya'ic ruk'ij ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ja tok xekaj ruq'uin ja Jesús xuque' chwach, tique'e in congana xmaltioxij tre. Aj Samaria ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ja c'a Jesús xbij: —¿La ma e lajuj ta c'a ja xetzuri? ¿Bar c'a ec'o wi' ja beleje' chic? ");
INSERT INTO tzjNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿La xa ruyon awa' ja rachi ri' ja melojto chi nurya'a' ruk'ij ja Dios? Makana' kach aj Israel ta c'a, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","C'ac'ari' xbij tre ja rachi: —Camic catyictaji, utz chic natbe. Ja yukulbal ac'u'x wq'uin jari' xattzursani, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ja c'a fariseo eje'e' c'oli quic'axaj tre quewari': —¿Nak k'ij xtoqui ja gobierno xin Dios? xeche' tre. Ja c'a Jesús quewa' xbij chique ri': —Ja gobierno xin Dios jari' matatz'at ruq'uin awach. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ja winak mta moda xtiquibij ta chi: —Tetz'ata' mpe', wawe' c'o wi' ja gobierno xin Dios ri', xqueche' ta, owi —Tetz'ata' mpe', quela' c'o wi' ja gobierno xin Dios le', xqueche' ta chakaja'. Queri' nbij chewe como kas mpe' bien tech'obo', ja gobierno xin Dios jari' c'o chic checojol camic, ne'e ja Jesús chique ja fariseo. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ja c'a chique ja rdiscípulo quewa' xbij ri': —Ja c'a rixix nerila' na jun k'ij ja tok congana egana xtutz'at chic jutij jurata ewach ruq'uin ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak pro jari' matetz'at chic. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ec'oli winak ja quewa' xtiquibij chewe ri': —Tetz'ata' mpe', wawe' c'o wi' ja Cristo ri', xqueche' na chewe, owi —Tetz'ata' mpe', quela' c'o wi' ja Cristo le', xqueche' na chewe chakaja'. Pro ja tok queri' xtiquibij chewe maxta quixbe cuq'uin, maxta quixtre'el chiquij. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Queri' nbij chewe como cani' nuban ja cayipa' tok nuq'uiak ri' chicaj chaka bar ta tri' ntz'a̱t wi' in queri' c'a tre chakaja' ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, ja tok xtipi chic jutij wawe' chwach'ulew jari' mta bar ta tri' ja maquita ntz'a̱t wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pro ja Ralc'walaxel rjawaxic chi congana nutij na ja rpokonal nabey, rjawaxic chi ntzelax na nabey cumal ja winak ja rec'o chipan awa' tiempo ja rokc'o wi' ri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ja cani' bantaji ja pa rtiempo ja Noé ojer queri' c'a xtibantaj chic chakaja' ja tok xtipi chic jutij wawe' chwach'ulew ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Como ja winak ja pa rtiempo ja Noé xa banoj tak wa'im ne'ocla' wi' il in banoj tak c'ulbic in nijawari' quimajon rbanic ja tok xoqui ja Noé chipan ja nimlaj lancha. Chaka c'a jalal tok peti ja nimlaj k'ekaljab chiquij, congana lawulo' ban chique rmal ja ya' in xejik'i canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","In queri' bantaji chakaja' ja pa rtiempo ja Lot. Ja winak xa banoj tak wa'im ne'ocla' wi' il, xa lok'oninem in c'ayinem nqueban, xa ticoj tak tijco'm owi banoj tak jay xa nijawari' ja benak quec'u'x trij chi rbanic. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pro ja tok xelto ja Lot chipan ja tinamit Sodoma jari' mismo k'ij c'oli kajto chicaj cani' k'ol rmajon c'atem, xercamsaj ja winak ja rec'o can chipan ja tinamit pro ni canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ja cani' queban ja winak ja pa rtiempo ja Lot queri' c'a quimajon rbanic ja winak chakaja' ja tok xtipi chic jutij wawe' chwach'ulew ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ja c'a tok xterila' ja k'ij ja xtipi chi wi' ja Ralc'walaxel ja wi ec'oli chewe ja rec'o parwi' terraza tri' in wi c'oli ja quimeba'il pa jay mejor que'anmaji, ma quekajpi chi ta pa tak cochoch chi rlasaxic ja quimeba'il. Ja wi ec'oli chewe ja rec'o pa tak chenoj tri' mejor que'anmaji chakaja', ma quemelojpi chi ta pa tak cochoch. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Bien turkaj chewe ja xuban ja rxjayil ja Lot. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Xa nak ta ja npokonaj nuya' can ja rc'aslemal jari' matuwil c'ari' ja utzlaj c'aslemal ja mta q'uisic trij. Pro xa nak ta ja matipokonaj nuya' can ja rc'aslemal jari' nuwil ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Anin nbij chewe, ja tok xtipi chic jutij wawe' chwach'ulew ja Ralc'walaxel ec'o ca'i' ja rewarnak chwa ch'at tri' chak'a', jun xtic'amarel rmal in jun xticanaj can. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ec'o ca'i' ixoki' ja xa jun ec'o wi' quimajon que'em tri', jun xtic'amarel in jun xticanaj can. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ec'o ca'i' achi'i' ja xa jun ec'o wi' pa chenoj tri', jun xtic'amarel in jun xticanaj can, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","—¿Bar c'a tri' nbantaj wala' ja nabij le'? xeche' tre. Ja c'a Jesús xbij chique: —Ja juicio puersa nkajto na ja cani' nqueban ja c'uch, xa bar ta tri' c'o wi' ja camnak tak cuerpo tri' nekajto wi'. Queri' xbij ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","C'ac'ari' c'o jun c'ambal tzij xbij chique ja nc'utbej chiquewach chi c'o rjawaxic chique chi ni matiquitanba' wi' rbanic ja roración, rjawaxic chi maticapuj quec'u'x. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Quewa' ja c'ambal tzij ja xbij chique ri': —C'o jun juez c'o pa jun tinamit, arja' matixbej ri' chwach ja Dios in nixtac'a nxbej ta ri' chiquewach winak chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","C'o c'a jun ixok chipan ja tinamit ti malca'n, arja' c'o jun ja rmajon rbanic ch'a'oj ruq'uin. Ja c'a ti malca'n tri' tri' ni nekaj wi' ruq'uin ja juez nerc'utuj ja rto'ic tre chi nto̱' pa ruk'a' ja nbano ch'a'oj ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ja c'a juez c'o jun tiempo ja ni ma xuto' ta wi' ja ti malca'n pro ja tok q'uiswani quewa' xbij kaj pa ranma ri': —Masqui matinxbej wi' chwach ja Dios in nixtac'a nxbej ta wi' chiquewach winak chakaja' ");
INSERT INTO tzjNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pro como ni matel wi' wq'uin ala' jun ixok le' mejor nto' na pa ruk'a' ja nbano ch'a'oj ruq'uin. Ja c'a wi matinto' maxla ni maquinruya' can wi' in xa noc'o nuc'u'x pa ruk'a', ne' kaj ja juez. Queri' nbij ja c'ambal tzij. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bien teya'a' cuenta tre ja xbij ja juez. Arja' ma utzlaj juez ta pro xbij chi nuto' na ja ti malca'n. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pior c'a ja Dios ¿la maqueruto' c'ari' ja tinamit ja rercha'on ja netajini nquic'utuj quito'ic tre chi pa k'ij chi chak'a'? ¿La nuya' tiempo tre ja quito'ic? ");
INSERT INTO tzjNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Anin nbij chewe chi neruto' chanim. Pro ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, ja tok xtipi chic jutij wawe' chwach'ulew ¿la c'a ec'o na c'a winak tri' ja c'o yukulbal quec'u'x ruq'uin? Queri' xbij ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ec'o c'a jule' winak ja xa cuq'uin eje'e' mismo yukul kaj wi' quec'u'x queyon, congana e utzlaj tak winak ja nquech'ob kaj in xa itzel nequetz'at ja jule' chic winak. Ja c'a Jesús c'o jun c'ambal tzij xbij chique quewari': ");
INSERT INTO tzjNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ec'o ca'i' achi'i' queban jutij xebe chipan ja nimlaj templo xin Dios chi rbanic ja roración. Jun, fariseo ocnak wi', ja c'a jun chic arja' molol impuesto. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ja c'a tok xe'ekaj chipan ja templo ja fariseo arja' pe'i in xumaj rbanic jun oración pro xa ya'bal ruk'ij arja' xuban kaj ruyon, quewa' ja roración ja xuban ri': —Anin nmaltioxij chawe Dios ja ma in junan ta cuq'uin ja jule' chic achi'i' cani' chique alak'oma' in chique ja matiquinimaj ja ley in chique ja nebano rij tak quewi' ja quixjayilal. Nmaltioxij chawe chakaja' ja ma in junan ta ruq'uin ala' jun achi ja molol impuesto le'. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Anin ca'mul ayuno nban ja jujun semana, in jun chic, nojel ja meba'il ja noc pa nuk'a' nlasan ja ndiezmo tre in nya'on chawe. Queri' xbij ja fariseo. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ja c'a molol impuesto arja' c'a c'a nat q'ueje' pon wi', tique'e, nixtac'a ca'y ta chicaj. Xumaj c'a jun nimlaj bis, quewa' ja roración ja xuban ri': —Tapokonaj nwach Dios como anin xa in jun aj'il xa in jun ajmac. Queri' xbij ja molol impuesto. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ja camic nbij chewe, ja molol impuesto arja' meloj chi rochoch, utz chic ntz'a̱t rmal ja Dios, ma ja ta ja fariseo ja utz tz'ati. Queri' c'a rbanic como xa nak ta chi winakil ja xtuya' kaj ruk'ij ruyon jari' xtikajsax na. Ja c'a wi naban tino'y jari' xtiya' na ak'ij, ne'e ja Jesús chique ja winak ja xa ya'bal quek'ij eje'e' nqueban kaj queyon. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ec'o c'a jule' tak yaqui'a' xec'amarel ruq'uin utzc'a chi nuya' ruk'a' pa quewi'. Pro ja rdiscípulo eje'e' xequich'olij ja rec'amyonel quixin. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ja c'a Jesús arja' xeruc'ul ja tak yaqui'a', quewa' xbij ri': —Teya'a' lugar chique ja tak ac'ala' quepi na wq'uin, maxta ma teya' ta lugar chique como ja winak ja re'ocnak e cani' tak ac'ala' quixin c'a eje'e' ari' ja gobierno xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Anin ni katzij wi' ja xtinbij chewe ri', xa nak ta ja matuban tino'y chi rnimaxic ja gobierno xin Dios ja cani' nuban jun ac'al jari' nixtac'a xtoc ta chipan ja gobierno xin Dios, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","C'o c'a jun achi nim ruk'ij, quewa' xbij tre ja Jesús ri': —Maestro, atat congana at utzlaj achi. ¿Nak nban utzc'a chi nyataj chwe ja utzlaj c'aslemal ja mta q'uisic trij? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","—¿Nak tre tok nabij chwe chi in utzlaj achi? Xa jun ja utz, jari' Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Atat awotak ja mandamiento xin Dios ja tz'ibtal can quewari': —Ma taban ta rij rwi' awixjayil owi awachajil, ma taban ta camíc, ma taban ta alak', ma taya' ta testigo'il ja ma katzij ta in que'animaj atata' ate' chakaja'. Queri' nbij ja rtzobal Dios, ne'xi ja rachi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Jala' ja nabij le' ni nmajonto wi' rnimaxic tok c'a in tino'y na, ne' chic ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ja c'a Jesús tok xc'axaj ja xbij ja rachi quewa' xbij chic tre ri': —Pro c'a c'o na ja ma abanon ta. Tac'ayij can nojel ja c'ol awq'uin, ja c'a rjil taya'a' can chique ja tak meba'i'. Ja wi queri' naban jari' c'oli ja meba'il ja nyataj na chawe chila' chicaj. Ja tok xtibantaj amwal ja c'a xinbij chawe ri' catmelojto c'a wq'uin in cattre'el chwij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ja c'a rachi tok xc'axaj ja bix tre rmal ja Jesús xumaj jun nimlaj bis como congana jun nimlaj meba'il ja c'o ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ja c'a Jesús tok xutz'at chi congana nbisoni quewa' xbij ri': —Ja biyoma' congana c'ayew chique chi ne'oc chipan ja gobierno xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tzuc'a tre jun nimlaj chicop cani' tre jun camello, arja' congana c'ayew chi noc'o pa rchak jun bak diso'mbal pro jari' ma c'ayew ta chwach ja noqui jun biyom chipan ja gobierno xin Dios, ne'e ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ja c'a xec'axan rxin quewa' quibij tre ri': —Jun biyom wi c'ayew chi noc chipan ja gobierno xin Dios ¿echinatak c'ari' ja newilowi ja totajem xin Dios? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ja c'a Jesús xbij chique: —C'o je'e ja c'ayew rbanic chiquewach ja winak pro ja chwach Dios ma c'ayew ta, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ja c'a Pedro arja' xbij tre: —Ja c'a chake ajoj, nojel ja c'o kuq'uin kaya'on can, okocnak adiscípulo, nij oktran wi' chawij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ja c'a Jesús quewa' xbij chique ri': —Ni katzij wi' ja xtinbij chewe ri', ja winak xa nak ta chi winakil ja wi c'oli quiya'on can cani' tre cochoch owi cani' chique quitata' quete' owi cani' chique quinimal owi quechak' owi cana' owi cani' chique quixjayilal owi calc'wal, ja c'a wi rmal ja gobierno xin Dios ja tok quiya'on can ");
INSERT INTO tzjNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","jari' más chi na q'uiy ja xtiyataj na chique wawe' chwach'ulew chwach ja cani' quiya'on can. In chakaja' ja tok xterila' ja jun chic tiempo ja xtipi na c'o jun utzlaj c'aslemal ja xtiyataj na chique ja mta q'uisic trij. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","C'ac'ari' xeryonaj ri' cuq'uin ja cablajuj apóstol in quewa' xbij chique ri': —Bien tec'waxaj ja xtinbij chewe ri', camic okbenak pa Jerusalén. Tri' nbantaj wi' cumplir nojel ja tz'ibtal can cumal ja rojer profeta xin Dios tre ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Como ja Ralc'walaxel arja' nja̱ch na pa quek'a' ja winak ja ma e aj Israel ta, nyo̱k' na, ntz'u̱j na, nchubax na rpalaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","C'ac'ari' xtiquirapaj. Ja tok xtiraptaj cumal nquicamsaj, in chi rox k'ij nc'astaj rwach, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ja c'a rapóstol eje'e' nixtac'a ch'obtaj ta jutz'it cumal ja jule' tzij ri', xa wawan chiquewach, ma xoc ta pa tak quixquin. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Xajalal maja'n que'ekaji ja Jesús chipan ja tinamit Jericó ja tok c'o jun achi ti moy xuwil, tz'ubul chi' bey, rmajon rc'utuxic limosna chique winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ja c'a ti moy tok xc'axaj chi congana jun winak nek'axi pa bey quewa' xbij ri': —¿Nak c'a nbani? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Peti ja Jesús ja raj Nazaret, ne'xi cumal ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","C'ac'ari' xumaj rakic ruchi': —Jesús, atat ja rat Ralc'wal can ja rojer rey David, tapokonaj jutz'it nwach, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ja c'a winak ja renabeyali pa bey eje'e' quemaj rch'olixic: —Xa jun catq'ue wi', ma tarak ta achi', ne'xi ja ti moy. Pro arja' xa más chi na xurak ruchi' trij ja Jesús: —Atat ja rat Ralc'wal can ja rojer rey David, tapokonaj jutz'it nwach, ne' chic jutij tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ja c'a Jesús arja' pe'i, xutak rsiq'uixic ja ti moy. Ja tok xekaji ja ti moy ruq'uin quewa' xbij tre ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Nak nawajo' chwe chi nban chawe? ne' tre. —Wajaw, ja nwajo' chawe chi njaktaj ta nwach, ne'xi rmal ja ti moy. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Camic catca'yi. Ja yukulbal ac'u'x wq'uin jari' xattzursani, ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chaka maril tok bitaj queri' tre ni jaktaji chanim ja rwach, tre'el trij ja Jesús, congana nuya' ruk'ij ja Dios. Ja c'a winak tok quetz'at ja milagro ja bantaji eje'e' quemaj rya'ic ruk'ij ja Dios chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","C'ac'ari' xe'oqui ja Jesús chipan ja tinamit Jericó in quemaj k'axem chipan. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","C'o c'a jun achi biyom, Zaqueo rubi', arja' jefe quixin ja rach tak molol impuesto. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ja c'a Zaqueo arja' congana xutij ruk'ij nak nuban utzc'a chi nutz'at rwach ja Jesús pro maticowini como xa ti co'l rkan in c'uluto congana e q'uiy ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ja xuban, c'amc'ol ranim be, nabeyaji, xejote' parwi' jun che' utzc'a chi nutz'at rwach ja Jesús como ja Jesús c'o rjawaxic tre chi tri' nk'ax wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ja c'a Jesús tok xekaj tri', xutz'at nojoj ja Zaqueo parwi' ja che' in quewa' xbij tre ri': —Catkajto alnak Zaqueo como anin puersa nineq'ueje' awq'uin pan awochoch chipan awa' jun k'ij ja rokc'o wi' ri', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ja c'a Zaqueo kajto alnak, xuc'ul ja Jesús pa rochoch pro congana nquicoti. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ja c'a winak tok quetz'at chi xoqui ja Jesús pa rochoch jun molol impuesto c'ac'ari' quemaj rtzijoxic canojel: —Xa pa rochoch jun aj'il ajmac nq'ueje' wi', xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ja c'a Zaqueo arja' pe'i in xbij tre ja kajaw Jesús: —Ja camic Wajaw, c'a xinch'ob chi ca'i' nban tre ja nmeba'il in nsipaj nic'aj chique ja tak meba'i'. In jun chic, c'o je'e ja xoc'o rwi' ja rimpuesto ja xinc'utuj chique ja winak pro ja camic can nmeloj quiji' chiquitakari' ja cani' nwalak'an chique, ne'e ja Zaqueo. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ja c'a Jesús quewa' xbij tre ri': —Ja camic xawil ja totajem xin Dios e awachbil ja rec'o pan awochoch como atat at ralc'wal can ja rAbraham chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Xattotaji como ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak arja' penak chi quicanoxic ja winak ja retzaknak chipan ja il mac utzc'a chi nquewil ja totajem xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ja c'a winak eje'e' quimajon rc'axaxic nak ja ntajini nbij ja Jesús. Ja c'a Jesús como xa chinakaj ja tinamit Jerusalén c'o chi wi' in como ja winak nquech'ob chi xajalal maja'n toqui ja gobierno xin Dios rmalc'ari' ja tok xbij jun c'ambal tzij chique quewari': ");
INSERT INTO tzjNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—C'o jun achi nim ruk'ij arja' be chipan jun chic nación ja nat c'o wi' utzc'a chi nja̱chto pa ruk'a' ja gobierno, nocto rey. Ja tok xtijachtaji ja gobierno pa ruk'a' c'ac'ari' nmelojpi chic jutij. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ja tok maja'n tibe ec'o lajuj chique ja rmoso xersiq'uij, xujach can jalal pwok pa quek'a', jujun ja pwok xuya' chique chiquijujunal in quewa' xbij chique ri': —Temajel rsamajixic ja npwok in ni ta emajon wi' rsamajixic ja tok xquinpi chic jutij, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pro ja rachi arja' xa itzel ntz'a̱t cumal ja rach aj tinamit rmalc'ari' tok eje'e' quetakel rbixic chipan ja nación ja bar xtijachto wi' pa ruk'a' ja gobierno: —Ajoj ni majun kagana ruq'uin ala' ja jun achi le' chi xtoc ta rey pa kawi', xeche'el. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ja tok q'uiswani melojto ja rachi, ocnakpi chic rey. Xutak quisiq'uixic ja moso ja rjachon can pwok pa quek'a' como c'o rgana nrotakij jani' quich'econ chic trij ja pwok chiquijujunal. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pi jun ja moso: —Wajaw, ja pwok ja xajach can pa nuk'a' lajuj chiquitakari' xinch'ec can trij ja cani' xajach can chwe, ne' tre ja rey. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ja c'a rey quewa' xbij tre ri': —Utz xaban tre ja samaj, atat at jun utzlaj moso, janila naban cumplir ruq'uin ja rasamaj. Xa ti ma nim ta ja xinya' can chawe pro xaban cumplir. Rmalc'ari' tok lajuj tinamit ja ncoj chic pan ak'a' camic chi natoc k'etol tzij parwi', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pi chi c'a jun ja moso: —Wajaw, ja pwok ja xajach can pa nuk'a' jo'o' chiquitakari' xinch'ec can trij ja cani' xajach can chwe, ne' tre ja rey. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","—Atat chakaja', jo'o' tinamit ja ncoj chic pan ak'a' camic chi natoc k'etol tzij parwi', ne'e ja rey tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","C'o c'a jun ja moso peti in quewa' xbij tre ja rey ri': —Ji' apwok ri' wajaw. Ja tok xajach can chwe xinxim chipan jun ti su't in ni chipan wi' nc'olon wi' camic. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Queri' xinban tre como anin xa nxbej wi' chawach como at jun achi at c'a'n. Atat xa ch'ecoj natocla' wi' il pro ni majun samaj naban, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ja c'a rey xbij tre: —Atat xa at jun itzel moso. Ja tzij ja c'a xabij kaj le' jala' nk'etbej tzij chawij camic. Ja wi awotak chi in c'a'n, wi awotak chi xa ch'ecoj ninocla' wi' il in majun samaj nban ");
INSERT INTO tzjNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿nak c'a tre tok ma xaya' ta ja npwok pa banco? Ja wixta queri' xaban, ja c'a tok xinpeti jach ta c'ari' ja npwok chwe rachbil ta ral, ne' tre ja moso. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ec'o c'a jule' ajsamajela' ja repa'loc pa rxquin, quewa' xbij chique ri': —Camic temaja' tre ja pwok, teya'a' chic tre ja c'ayon lajuj, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","—Pro kajaw, jari' c'o chic lajuj ruq'uin, ne'x cumal. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","—Ja c'a camic nbij chewe chi canojel ja winak ja c'o je'e yatajnak chique, eje'e' nyataj na más chique. Pro ja c'a winak ja mta yatajnak chique pro nquech'ob chi c'oli jari' nlasax chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ja c'a winak ja xa itzel ninquetz'at ja mta quigana chi xinoc rey pa quewi' que'ec'ama'to camic, ni chinwach que'ecamsaj wi', ne'e ja rey chique ja rajsamajela'. Queri' ja c'ambal tzij ja xbij ja Jesús chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ja c'a tok bitaj rmal c'ac'ari' xumajel chic jutij rubey be pa Jerusalén, arja' nabeyaj chiquewach ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ja tok xe'ekaj chinakaj ja ca'i' tinamit Betfagé in Betania ja bar c'o wi' ja jayu' rbina'an Rjayu'al Olivo ec'o ca'i' chique ja rdiscípulo xerutak ");
INSERT INTO tzjNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","in quewa' xbijel chique ri': —Jix ja pa tinamit le', chila' newil wi' jun ti bur ximili ja ni mta wi' jutij tz'ulben ta cumal winak. Tequira'to in tec'ama'to. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ja wi c'oli nak xtibin chewe: —¿Nak tre tok nequir ja ti bur? wi xtiche' chewe, quewa' xtebij tre ri': —Ja kajaw nc'atzin tre, quixche' tre. Queri' xbijel ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ja c'a ca'i' discípulo ja xeta̱kel eje'e' xebe in tok xe'ekaji ni queri' xeli ja cani' bixel chique rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kas c'a quimajon rquiric ja ti bur ja tok xek'ilox cumal ja rajaw: —¿Nak tre tok nequir ja ti bur le'? xeche'x cumal. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Ja kajaw nc'atzin tre, xeche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","C'ac'ari' quec'amto ja ti bur. Ja quitziak jari' quiwekbej, quitz'uba' ja Jesús trij ");
INSERT INTO tzjNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","in xumaj binem. Ja c'a winak eje'e' quisocla' ja quitziak pa rubey ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ja c'a tok xa nakaj ec'o chi wi' tre ja tinamit Jerusalén ja bar nxule' wi' ja bey chwach ja Rjayu'al Olivo canojel ja discípulo quemaj rakic quechi' rumac ja quicotemal, congana quemaj rya'ic ruk'ij ja Dios rmal nojel ja nimak tak milagro ja quitz'aton, ");
INSERT INTO tzjNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","quewa' nquibij ri': —Bendecido ja Rey ja penak pa rubi' ja kajaw Dios. Ja camic congana quicotemal c'o chila' chicaj, janila ntajini nya̱' ruk'ij ja nimlaj Dios, queri' nquibij. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ec'o c'a jule' fariseo chiquicojol ja winak quewa' quibij tre ja Jesús ri': —Maestro, tabij chique ja radiscípulo chi nquicajba', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","—Camic nbij chewe, ja wi eje'e' nquitanba' rya'ic nuk'ij ja c'a rabaj jari' puersa xtumaj rya'ic nuk'ij, ne'e ja Jesús chique ja fariseo. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Xc'a jani' xenakajin más tre ja Jerusalén. Ja c'a Jesús tok xutz'at pon ja tinamit xumaj ok'ej rmal, ");
INSERT INTO tzjNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","quewa' xbij ri': —Ja rix aj Jerusalén, congana ta qui'il ja wixta nch'obtaj emwal ixix chakaja' bar newil wi' ja quicotemal xin Dios ja ntzujuj chewe chipan awa' jun k'ij ja rokc'o wi' ri'. Pro ja camic matich'obtaj emwal como xa wawan chewach. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Congana ninbison emwal como nerila' na jun tiempo ja tok xquepi chewij ja rec'ulel. Ja c'a tok xque'urkaji nqueyic na jun nimlaj tabia trij ja tinamit xin banbal ch'a'oj, nquisutij qui' chewij, nquitz'apij ja bey nojelal utzc'a chi maquixcowini nixanmajel. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nquikajsaj na pa tok'ulew ja tinamit pro ni chi jun, congana lawulo' nqueban chewe ja rixc'o chipan, nixtac'a c'o ta jun jay ja maquita nqueyoj. Queri' c'a ja xtiban chewe como xa matich'obtaj emwal chi ja Dios xurq'ueje' ewq'uin chi eto'ic. Queri' xbij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ja c'a tok xekaj chipan ja tinamit Jerusalén xoc chipan ja nimlaj templo xin Dios in xumajto quilasaxic ja winak ja rec'o chipan ja quimajon c'ayinem e cachbil chakaja' ja quimajon lok'oj tak nakun. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","In xbij chique: —Ja rtzobal Dios quewa' tz'ibtal chipan ri': —Ja wochoch anin jari' banbal oración, ne'e ja Dios tre ja rtemplo pro ja rebanon ixix tre xa jun lugar ja bar neq'ueje' wi' alak'oma', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","K'ij k'ij ni nertijoj wi' ja winak chipan ja templo. Pro ja c'a maestro ja netijon quixin ja winak tre ja ley xin Dios e cachbil ja jefe quixin sacerdote eje'e' quemaj rcanoxic rij rwach nak nqueban tre chi nquicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pro ni maticanoy wi' cumal nak nqueban tre como ja winak congana nqueya' quixquin tre pro ni canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kas c'a rmajon quitijoxic ja winak tre ja utzlaj tzij ja rc'amonto totajem xin Dios ja tok xe'urkaji ja jefe quixin sacerdote e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios e cachbil chakaja' ja principali' xin tinamit. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Quewa' quibij tre ri': —Tabij c'a chake ¿nak atocnak wi' chewi' tok amajon rbanic nojel awa' ja kamajon rtz'atic in nak yoyon chawe chi naban? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","—Anin chakaja' c'oli ja nc'waxaj chewe. Camic tebij chwe, ");
INSERT INTO tzjNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ja Juan Bautista ¿nak yo' tre ja rsamaj chi neruban bautizar ja winak, la ja' Dios ja c'o chila' chicaj ja yo' tre owi xa winak? xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ja c'a reje'e' quemaj tzij chibil tak qui': —Ja wi xtikabij tre chi Dios yo' tre, arja' nbij chake: —Ja wi queri' ¿nak c'a tre tok ma xenimaj ta? ne' ala' chake. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","In wi xtikabij tre chi xa winak xeyo' tre jari' xa nokquicamsaj tz'an abaj ja winak como ja chiquewach eje'e' ja Juan arja' jun profeta xin Dios, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","In quibij tre ja Jesús: —Ma kotak ta nak yo' tre, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","—In nixtac'a anin ta chakaja' xtinbij ta chewe nak inocnak wi' chi nmajon rbanic nojel awa' ja remajon rtz'atic, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","C'ac'ari' xumaj rbixic jun c'ambal tzij chique ja winak quewari': —C'o jun achi c'o jun rchenoj, uva rticon chwach, xuya' pa kajonem chique jule' ajchonla'i' in be chipan jun tinamit congana nat in tri' q'ueje' wi' jun tiempo. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ja tok xerila' ja tiempo ja nwachin wi' ja rtijco'm, arja' c'o jun rmoso xutakel cuq'uin ja rajchonla'i' chi nerc'ama' ja renta. Ja rajchonla'i' tok xekaji ja moso cuq'uin quesoc in tok melojto ni majun nak ta queya'pi tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ja c'a rajaw chenoj c'o chi na jun rmoso xutakel cuq'uin in tok xekaj chic ari' jun cuq'uin quesoc chakaja', ni lawulo' quebanpi tre in tok melojto ni majun nak ta queya'pi tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ja c'a rajaw chenoj xutakel chi na jun in tok xekaj cuq'uin congana pokon queban chic ari' tre chakaja' in queminto. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ja tok q'uiswani quewa' xbij ja rajaw chenoj ri': —¿Nak nban c'awa' camic? Como c'o jun nc'ajol ja congana nwajo' jari' ntakel chic cuq'uin. Ja tok xtiquetz'at chi nc'ajol matzij xtiqueban respetar, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pro ja rajchonla'i' ja tok xekaji ja ralc'walaxel cuq'uin quewa' quibij chibil tak qui' ri': —Jala' jun achi le' noc na pa ruk'a' ja rulew ri' como herencia. Camic kacamsaj utzc'a chi pa kak'a' ajoj noc wi' ja herencia rxin, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","C'ac'ari' quiwasajto chipan ja chenoj in quicamsaj. Queri' nbij ja c'ambal tzij, ne'e ja Jesús chique. C'ac'ari' xbij chic chique: —Camic tebij c'a chwe, ja rajaw chenoj ¿nak nuban c'ari'? ");
INSERT INTO tzjNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ja nuban, arja' npeti ne'urcamsaj ja rajchonla'i', ja c'a rchenoj nuya' chic jutij pa kajonem chique jule' chic ajchonla'i', ne' chique. Ja c'a winak tok quic'axaj ja xbij ja Jesús quewa' quibij tre ri': —Ja c'a xabij kaj le' congana c'ayew, maquita xtibantaj cumplir, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ja c'a Jesús kas xertz'elwachij in quewa' xbij chique ri': —¿Nak moda ja maquita xtibantaj cumplir como quewa' tz'ibtal can chipan ja rtzobal Dios ri': —Ja banol jay c'o jun abaj ja mta quigana ruq'uin in quech'a' pro jari' abaj cojon chic chi rbanic ja jay, arja' ja más nim ruk'ij como arja' nchapowi ja resquina'il, queri' nbij ja rtzobal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Xa nak ta ja xa junwi' nutz'at ja rabaj ja xinbij chewe in xa nuban ofender ri' rmal jari' cani' nuban jun achi nuchok' rkan chwach jun abaj in nk'aji. In xa nak ta ja nk'e̱t tzij trij rmal ja rabaj ja xinbij chewe jari' cani' nuban jun achi ntzakto jun abaj trij in nchictaj rmal, ne'e ja Jesús chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ja c'a jefe quixin sacerdote e cachbil ja maestro xin ley tok quic'axaj ja c'ambal tzij bien ch'obtaj cumal chi eje'e' ja xebixi. Rmalc'ari' tok ni jari' hora laj quechap ja Jesús quecoj ta preso pro xa nquixbej qui' chiquewach ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Quemaj rcanoxic rij rwach nak nqueban tre. Ec'o jule' winak xequetakel ruq'uin chi rc'ambajaxic pro jule' winak nquik'alasaj qui' chwach chi e utzlaj tak winak utzc'a chi c'o jun tzij nelto pa ruchi' in jari' tzij nquichapbej rxin como c'o quigana nquejach pa ruk'a' ja gobernador utzc'a chi nk'e̱t tzij trij. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ja c'a tok xe'ekaj ruq'uin quewa' quibij tre ri': —Maestro, ajoj kotak chi ni rubey wi' ja nattajini nabij, ni rubey wi' ja tijonem ja ramajon rya'ic. Ajoj kotak chi atat mta jun utz in mta jun itzel natz'at pro ja rbey Dios amajon rc'utic chikawach ni utz wi' naban chi rbixic. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Camic tabij chake, ja rimpuesto ja nc'utux chake rmal ja César ja nimlaj rey aj Roma ¿la rubey c'ari' chi nkatoj owi ma rubey ta? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pro ja Jesús arja' bien rotak chi xa banoj engaño ja nqueban in quewa' xbij chique ri': —¿Nak tre tok newajo' ninec'ambajaj? ");
INSERT INTO tzjNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tec'utu' jun ja pwok chinwach, ne' chique. Ja c'a tok quec'ut ja pwok chwach quewa' xbij chic chique ri': —¿Chok xin ja wi'aj c'o chwach ja pwok ri' in nak chok xin ja bi'aj tz'ibtal chwach chakaja'? ne' chic chique. —Rxin César, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Ja rxin César tre César teya'a' wi', ja c'a rxin Dios tre Dios teya'a' wi', xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ni majun tzij xelpi ta pa ruchi' ja nquichapbej ta rxin chiquewach ja winak. Congana c'asc'o'i quic'axaj ja bix chique rmal, mchita nak chi ta quibij ta tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","C'ac'ari' ec'o jule' saduceo xebe ruq'uin. Ja saduceo eje'e' matiquinimaj chi nec'astaji ja camnaki'. Ja c'a tok xe'ekaj ruq'uin quewa' quibij tre ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestro, ja Moisés arja' rbin can chake chipan ja rtzobal Dios, ja wi c'o jun achi ncam jun ruchak' owi rnimal in mta jun ti ralc'wal nq'ueje' can jari' achi rjawaxic chi nc'ule' ruq'uin ja rixok ja cam rchajil. Ja c'a reje'e' tok nq'ueje' jun ti calc'wal nquibij tre chi ja tac'al ralc'wal ja camnak. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Queban c'a jutij ec'o wuku' alaxic, ja nabey winak c'ule'e pro cami in majun ti ralc'wal q'ueje' can. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ja cani' xuban ja nabey winak queri' chic xuban ja rucab, cam chic chwach ja rixok, ni majun calc'wal q'ueje' can. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","In queri' xuban ja rox chakaja'. Queri' queban chi e wuku', xec'ule' ruq'uin ja rixok in xecam chwach, ni majun ti calc'wal q'ueje' can. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ja c'a tok q'uiswani cami ja rixok chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Camic ¿nak c'a nabij atat tre? Ja re wuku' alaxic tok xterila' ja k'ij chi nec'astaj chipan ja camíc ¿nak c'a rchajil ari' ja rixok chique como xec'ule' ruq'uin chi e wuku'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ja c'a Jesús xbij chique: —Ja wawe' chwach'ulew ja winak nec'ule'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pro ja winak ja xtiyataj na chique chi nec'astaj chiquicojol camnaki' ja xtiyataj na chique chi nebe chila' chicaj jari' mchita c'ulbic xtiqueban ta tri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Maquec'ule' chic como mchita camíc chiquij tri'. Mchita camíc chiquij como e cani' chic ángel tri'. E ralc'wal Dios como ec'astajnak chic tri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","In jun chic nbij chewe, c'oli ja tz'ibtal can chipan ja rtzobal Dios rmal ja Moisés chakaja' tre ja quic'astajic ja winak. Jari' tok xutz'at jule' rxulquiej ja Moisés in ntzijonto ja Dios chipan, quewa' bix tre rmal ja kajaw Dios ri': —Anin in Dios rxin Abraham, in Dios rxin Isaac, in Dios rxin Jacob, ne'xi ja Moisés. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ja tok queri' nbij jari' nc'utbej chewach chi eje'e' masqui ecamnak chic pro ja chwach Dios ec'asli. Ja chwach Dios ec'asli canojelal, ne'e ja Jesús chique ja saduceo. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ec'o c'a jule' maestro xin ley quewa' quibij tre ri': —Maestro, ja c'a xabij kaj le' jala' ni rubey wi', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ja c'a Jesús mta nak chi ta c'axax chi ta tre cumal como xa nquixbej chic qui' ja c'o ta nquic'axaj chic tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","C'ac'ari' xbij chique: —¿Nak tre tok nbix tre ja Cristo chi arja' ralc'wal can ja rojer rey David? ");
INSERT INTO tzjNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Queri' nbij chewe como ja David c'o jun salmo rbin can chipan ja rtzobal Dios quewari': —Ja kajaw Dios quewa' xbij tre ja Wajaw ri': —Cattz'abe'e wawe' pa wiquik'a', wawe' natq'ueje' wi' ");
INSERT INTO tzjNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","in nenucoj na pan awakan ja netzelan awxin, ne' tre. Queri' rbin can ja David. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ja c'a David: —Wajaw, ne' tre ja Cristo, tebij c'a chwe camic ¿nak tre tok nbix tre ja Cristo chi ralc'wal can ja David? Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","C'ac'ari' xumaj tzij cuq'uin ja rdiscípulo pro ni chiquewach ja winak tzijon wi': ");
INSERT INTO tzjNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Tebana' cuenta chique ja maestro ja netijon quixin ja winak tre ja ley xin Dios. Eje'e' congana nel quec'u'x trij ja nec'astan chiquewach winak, quicojon nimak tak tziak ja nc'utu quixin chi e nimak tak maestro. In c'a c'o na más ja congana nel quec'u'x trij cani' tre ja neba̱n saludar pa tak c'aybal in cani' tre tok nebe pa tak jay xin molbal ri'il ja bar nc'axax wi' ja rtzobal Dios, eje'e' nquicanoj ja nabey tak tz'ulbal ja nimak ruk'ij in queri' nqueban chakaja' tok neba̱n invitar pa nimak tak wa'im. ");
INSERT INTO tzjNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eje'e' kas k'alawachili nquemaj cochoch tak malcani' ja e camnak chic cachajilal. C'o nimak tak oración nqueban pro xa chi quechi' c'o wi'. Pro ja tok xtik'et tzij chiquij rmal ja Dios más chi na jun nimlaj rpokonal nquetij na. Queri' xbij ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","C'ac'ari' ec'o jule' biyoma' xerutz'at pon, eje'e' quimajon rya'ic ja cofrenda chipan ja rc'olbal tak ofrenda. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","C'o c'a jun ixok ti malca'n xutz'at in ti meba', arja' c'o ca'i' tak pwok rc'an in xuya' chipan ja rc'olbal ofrenda. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ja c'a Jesús xbij: —Tetz'ata' mpe' ja ti malca'n ixok le', arja' más na nim ruk'ij chwach Dios ja xuya' chipan ja rc'olbal ofrenda chwach ja queya' canojelal ja jule' chic. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Queri' nbij chewe como ja jule' chic xa jari' queya' tre ja Dios ja totajnak pro arja' masqui xa ti meba' pro xuya' nojel ja c'o ruq'uin ja ntzukbej ti ri', ne'e ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ec'o c'a jule' ja quimajon rtz'atic ja nimlaj templo xin Dios, quewa' netajini nquibij ri': —Congana banon rbanic ja templo le', congana buen tak abaj ocnak in c'oli buen tak nakun rc'an chakaja' ja sipan cumal ja winak, neche'e. Ja c'a Jesús quewa' xbij chique ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ja remajon rtz'atic le' nerila' na jun k'ij ja tok xtiyojtaji nojelal, ni majun abaj xtirikla' chi ta ri', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","—Pro tabij chake Maestro ¿nak k'ij xtibantaji jala' ja c'a xabij kaj chake le'? In chakaja' ¿nak chi retalil nwinakari ja nc'utu rxin chi xajalal maja'n tibantaj cumplir nojelal ja c'a xabij chake? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","In xbij chic chique: —Kas tebana' jutz'it cuenta ewi', maxta c'o jun quixbano engañar. Queri' nbij chewe como e q'uiy ja winak nepi na je'e in xa queyon nquecoj qui' chi e Cristo, quewa' nquibij chique ja winak ri': —Anin in Cristo, neche' na chique, owi: —Xurwila' ja tiempo chi npeti ja Cristo, xqueche'e. Pro ixix maxta tenimaj ja nquibij. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","C'o nimak tak ch'a'oj xtiban na in chakaja' e q'uiy ja winak xqueyictaj na trij ja quigobierno je'e pro ja tok xtekaj rbixic ewq'uin maxta texbej ewi' rmal como ni rjawaxic wi' chi nbantaj cumplir nojel awa' wari' nabey pro jari' ma q'uisbal rwach'ulew ta como c'a después na ja q'uisbal rwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","C'o je'e tinamit xtiyictaj na trij jule' chic tinamit in chakaja' ja gobierno je'e nyictaj trij jule' chic gobierno. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","C'o nimak tak cubarkan xtibantaj na in chakaja' c'o nimak tak rc'ayewal xtiwinakar na pa tak lugar je'e cani' tre nimak tak wa'al in nimak tak yobil. C'o nimak tak retal ja xtiwinakar na chicaj ja congana nquixbej qui' ja winak rmal. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pro ja tok maja'n tibantaj cumplir nojel awa' ja c'a xinbij chewe ri' c'o je'e rpokonal netij na pa quek'a' ja winak. Nixquechap na, nixquec'amel pa tak jay xin molbal ri'il, nixquecoj pa tak che', nixquec'amel chiquewach rey, nixquec'amel chiquewach gobernador pro mwal anin tok xtiban queri' chewe. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pro ma chaka ta queri' ja tok nixc'amarel chiquewach rey in chiquewach gobernador como tokori' nixcowini nemaj ntzijoxic anin chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pro bien tech'obo' kaj pa tak ewanma camic chi ma rjawaxic ta chewe chi xtech'ob pon ta nak chi tzijal ja xtetobej ewi' chiquewach ");
INSERT INTO tzjNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","como anin xquinyo' chewe nak chi tzijal ja xtebij chique, anin xquinyo' chewe ja rena'oj tri'. Rmalc'ari' tok ja rec'ulel ma xticanoy chi ta cumal nak ja xtiquibij chic chewe, xtetz'apij quechi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nixjach na pa quek'a' ja rec'ulel cumal etata' ete', cumal ewach'alal in cumal ewamigo chakaja'. Ec'oli necamsax na chewe. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Xa itzel nixtz'at na cumal canojel ja winak pro mwal anin ja tok xtiban queri' chewe. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pro jari' nixtac'a c'o ta jun ti rsamal ewi' xtitzak ta chwach ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ja c'a wi necoch' ja npi chewij jari' newil ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ja c'a tinamit Jerusalén tok xtetz'at chi sutin chic rij cumal jule' soldado ja nurquibana' ja ch'a'oj, tri' tewotakij wi' chi xa nnakajinto ja tiempo ja nyojtaj wi' ja tinamit. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ja c'a neban tri', ja rixc'o chipan ja departamento Judea mejor quixanmaji, tewawaj ewi' pa tak c'achelaj. Ja c'a rixc'o chipan ja tinamit Jerusalén tri' mejor quixelel chipan. Ja c'a rixc'o pa tak k'ayis tri' mejor ma quixmelojpi chi ta chipan ja tinamit Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Queri' nbij chewe como ja tok xterila' ari' tiempo ja c'a xinbij chewe ri' tokoc'ari' c'o jun nimlaj juicio nkajto na parwi' ja tinamit Jerusalén utzc'a chi nbantaj cumplir nojel ja tz'ibtal can tre chipan ja rtzobal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Anin congana npokonaj quewach ja rixoki' ja xajalal maja'n queq'ueje' tak cal tri' in chakaja' ja rec'o chic tak yaqui'a' chwaquek'a'. Npokonaj quewach como ja raj Israel tri' congana npi ryewal ja Dios chiquij, congana jun nimlaj tijoj rpokonal nkajto parwi' ja quitinamit. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ec'oli chique necamsax na tza'n tak espada in jule' chic chique ne'oquel preso in nec'amarel chipan nojel tak nación. Ja c'a tinamit Jerusalén jari' noc na pa quek'a' ja nación je'e ja ma e aj Israel ta, c'a tokori' xtel pa quek'a' ja tok xtoc'owi ja tiempo je'e ja xtiyataj tre ja nación rmal ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","C'o je'e retal ja xtiwinakar chicaj chipan ja k'ij, chipan ja ic' in chique ch'umil chakaja'. Ja c'a chwach'ulew ja winak ja rec'o pa tak nación ma xticanoy chi ta cumal nak la nqueban, xa nsach quina'oj rmal ja nimak tak baloj pa mar congana nteneni. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ja tok xtiquemaj rch'obic ja nimak tak rc'ayewal ja penak chwach ja rwach'ulew xa ncapuj na quec'u'x in congana nquixbej na qui' rmal. Queri' xtiqueban como ja nimak tak poder rxin ja caj nusil na ri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","C'ac'ari' nquetz'at na ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, arja' c'amonto rmal jule' sutz', janila jun nimlaj poder c'o chic pa ruk'a' in congana nim chic ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ja tok xtimajtaj rbanic cumplir nojel awa' ja c'a xinbij kaj chewe ri' quixca'y chicaj in quixquicoti como tri' nnakajinto wi' ja tiempo ja tok xquixwasaxel libre chijutij chipan ja tijoj rpokonal. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","C'ac'ari' c'o jun c'ambal tzij xbij chique quewari': —Bien tewasaj ena'oj trij ja jun che' higuera owi xa nak ta chi che'al, ");
INSERT INTO tzjNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ja tok npulani jari' bien nch'obtaj emwal eyon chi xa nnakajinto ja rtiempo c'atan. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","In queri' c'a tre chakaja' ja tok xtemaj rtz'atic chi majtajnak rbanic cumplir nojel awa' ja c'a xinbij chewe ri' jari' retal nuc'ut chewach chi xa nnakajinto ja gobierno xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ni katzij wi' ja xtinbij chewe ri', ja tinamit Israel eje'e' c'a ec'o na ja tok nbantaj cumplir nojel awa' wari', ma chupnak ta quewach. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ja caj in rwach'ulew jari' xa nchup na rwach pro ja ntzobal anin jari' ni matichup wi' rwach, mta ari' ja maquita nbantaj cumplir. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Tebana' jutz'it cuenta ewi', maxta xa ja' tibe ec'u'x trij nimak tak wa'im in tijoj tak ya', maxta xa ja' tebisoj ja xin rwach'ulew. Maxta c'a ja' tena' ja tok xterila' ja k'ij ja tok xtipi chic jutij ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Queri' nbij chewe como ja k'ij ja c'a xinbij chewe ri' njunsaj ruq'uin jun trampa chapbal chicop como ja tok xterila' ja k'ij necha̱p na ja winak rmal pro canojel ja winak ja rec'o nojel nat nakaj chwach ja rwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Quixc'asc'ot c'a, xajutij temaja' rbanic ja roración utzc'a chi Dios nuya' chewe chi neto' ewi' chwach nojel awa' ja xinbij kaj chewe ri' ja penak chwach ja rwach'ulew utzc'a chakaja' chi nixc'uli ja tok nixekaj chwach ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ja pa k'ij nertijoj ja winak chipan ja nimlaj templo xin Dios. Ja c'a chak'a' nbe chipan ja lugar ja bar c'o wi' ja jayu' rbina'an Rjayu'al Olivo in tri' nq'ueje' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ja pa tak ak'abil chanim ne'ekaji canojel ja winak ruq'uin chipan ja templo chi rc'axaxic ja tijonem nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Xc'a nnakajinto ja nmak'ij ja tok ntiji ja caxlanway ja mta levadura ruq'uin jari' nmak'ij pascua ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ja c'a jefe quixin sacerdote e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios eje'e' quimajon rcanoxic rij rwach nak nqueban tre ja Jesús chi nquicamsaj. Queri' queban como xa nquixbej qui' chiquewach ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","C'ac'ari' xoqui ja Satanás pa ranma ja Judas ja bina'an tre Iscariote. Ja c'a Judas arja' jun chique ja cablajuj discípulo rxin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Be cuq'uin ja jefe quixin sacerdote in cuq'uin ja jefe quixin ja nechajin rxin ja nimlaj templo xin Dios. Ja c'a tok xekaj cuq'uin xumaj tzij cuq'uin nak nuban chi nujach ja Jesús pa quek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ja c'a reje'e' congana xequicot rmal ja bix chique in queya' quechi' chi nqueya' pwok tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","—Utz c'ari', ne'e ja Judas chique. C'ac'ari' xumaj rcanoxic nak nuban tre chi nujach ja Jesús pa quek'a' pro xcanoj na jun hora ja tok mta nquinabej ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Xerila' c'a ja k'ij rxin ja nmak'ij ja tok ntiji ja caxlanway ja mta levadura ruq'uin in tok necamsaxi ja tak carnelo xin pascua ja netzujux tre ja Dios como sacrificio. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ja c'a Jesús arja' xerutakel ja Pedro in Juan, quewa' xbijel chique ri': —Camic nixbe, nechomij ja xtikati' chipan ja nmak'ij pascua ri', ne'el chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—Tabij chake bar tri' xtikachomij wi', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ja c'a Jesús quewa' xbijel chic chique ri': —Ja tok xquixoc chipan ja tinamit Jerusalén c'o jun achi nec'ul, arja' rc'an jun cura' ya'. Ja c'a neban, quixoc chipan ja jay ja bar xtoc wi' arja' ");
INSERT INTO tzjNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","in quewa' nebij tre ja rajaw jay ri': —Ja Maestro okrtakonto awq'uin chi nurkac'axaj chawe: —¿Nak chi cuarto'il ja nkaban wi' ja wa'im xin pascua e wachbil ja ndiscípulo? Queri' ja binto chake, quixche' tre ja rajaw jay. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ja c'a rarja' nuc'ut chewach jun nimlaj cuarto chomin chic, chicaj c'o wi' pa ca'i' piso. Tri' nechomij wi' ja nkati' ja xin nmak'ij pascua ri'. Queri' xbijel ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ja c'a Pedro rachbil Juan eje'e' xebe in tok xe'ekaji ni queri' bantaji ja cani' bixel chique rmal ja Jesús. C'ac'ari' quemaj rchomarsaxic ja nqueti' xin nmak'ij pascua. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ja c'a tok xerila' ja hora xin wa'im tz'abe'e ja Jesús pa mesa e rachbil ja cablajuj apóstol ");
INSERT INTO tzjNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","in xumaj tzij cuq'uin, quewa' xbij chique ri': —Anin congana nyarinto chi xa junan nkaban ewq'uin jawa' jun wa'im xin pascua ri'. Nincamsax na pro congana ngana nkaban ja wa'im xin pascua ewq'uin nabey. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Queri' nbij chewe como anin matinban chic ja wa'im xin pascua wawe', c'a tokori' xtinban chic ja tok xtibantaj cumplir chipan ja gobierno xin Dios, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","C'ac'ari' xuc'am jun vaso vino, xmaltioxij tre ja Dios in xbij chic chique: —Tec'ama' ja vino ri', tetija' chejujunal. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ja camic nbij chewe chi ja riya'l uva ni matintij chi wi' wawe', c'a tokori' xtintij chic ja tok xtipeti ja gobierno xin Dios, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","C'ac'ari' xuc'am ja caxlanway, xmaltioxij tre ja Dios, xuwech' in xujach chique, quewa' xbij chic chique ri': —Jawa' wari' ncuerpo ja nja̱ch na pa camíc pan ecuenta, tetija'. Ja c'a tok netij jari' nenatbej wxin, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","In queri' xuban chic tre jun chic vaso vino chakaja', ja tok colbetaji ja wa'im cumal xbij chic chique: —Jawa' vino ri' jawa' nquiq'uel ocnak rseguro ja c'ac'a chominem ja rchomin ja Dios. Ja nquiq'uel jari' nti̱x na pan ecuenta. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pro bien tec'waxaj camic, c'o jun achi ja xtijacho wxin pa quek'a' ja winak ja netzelan wxin in ja rachi arja' tz'ubul wq'uin pa mesa camic. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak ni katzij wi' chi ncamsax na ja cani' chominto rmal ja Dios pro congana lawulo' tre ja xtijacho rxin pa quek'a' ja necamsan rxin, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ja c'a rapóstol eje'e' quemaj rc'axaxic chibil tak qui' nak chique ja xtijacho rxin. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","In chakaja' c'o jun ch'a'oj winakar chiquicojol, nak ja más nim ruk'ij chique jari' nquich'ojij. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ja c'a Jesús quewa' xbij chique ri': —Ja rey ja rec'o pa tak nación je'e congana e nimak nquena' in nqueban chique ja winak xa e cani' quimoso. Ja nebano mandar quixin ja winak congana quigana chi nbix chique chi e banol tak utzil. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pro maxta teban ixix ja cani' nqueban eje'e'. Ja c'a neban, ja más nim ruk'ij chewe mejor tibana' kaj chi más ti co'li chiquewach ja rachbil. In chakaja' ja nbano mandar chewe mejor querilij ja rachbil. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ja tok c'o jun achi rmajon wa'im in tok c'o jun moso ja nilin rxin ¿nak ja más nim ruk'ij chique nech'ob ixix? ¿La ma ja ta c'a ja rachi ja nilix rmal ja rmoso ja más nim ruk'ij? Pro bien turkaj chewe nak ja nbanon anin checojol, nbanon ja samaj ja cani' nuban jun ilinel. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ja c'a rixix nij inewachbilanto wi' chipan ja rpokonal ja ntijonto. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ja camic anin nya' chewe chi c'o k'etbaltzij pan ek'a' ja cani' yatajnak anin chwe rmal ja nata' Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Queri' nban chewe utzc'a chi nyataj chewe chi xa junan xkowa' wi' ewq'uin pa mesa chipan ja ngobierno utzc'a chakaja' chi nyataj chewe chi nixoqui ix k'etol tak tzij pa quewi' ja cablajuj tribu rxin ja tinamit Israel, ne'e ja Jesús chique ja rapóstol. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","C'ac'ari' xumaj tzij ja kajaw Jesucristo ruq'uin ja Simón Pedro, quewa' xbij tre ri': —Simón, bien tac'waxaj ja xtinbij chawe ri', ja Satanás arja' ixrc'utun tre ja Dios in ya' lugar tre chi nixq'ueje' na jurata pa ruk'a' in nixrkajsaj na chipan jun nimlaj prueba. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pro anin nbanon orar pan acuenta utzc'a chi matiq'uisi chijutij ja yukulbal ac'u'x wq'uin. Atat ja tok xcatmelojpi chic jutij pa nuk'a' tacowirsaj chic quec'u'x ja rawach'alal, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ja c'a Simón Pedro xbij tre: —Mni Wajaw, ni ninbe wi' chawij masqui anin jun nincoj pa che' awq'uin owi nincamsax awq'uin chakaja', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ja c'a Jesús xbij chic tre: —Camic nbij chawe Pedro, ja chipan awa' jun tucwak'abil ri' maja'n tok'i ja ac' ja tok oxmul xtabij chwe chi: —Anin ma wotak ta rwach ja Jesús, natche' na chwe, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","C'ac'ari' xumaj tzij cuq'uin canojel ja rapóstol, quewa' xbij chique ri': —Ja tok xixnutakel chipan ja viaje, tok mta epwok xec'amel in nixtac'a xec'amel ta emaleta in nixtac'a exajab ta chakaja' ¿la c'oli ja ma xtz'akat ta chewe tri'? ne' chique. —Ni majun xuban ta falta chake, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","C'ac'ari' xbij chic chique: —Pro ja camic chic nbij chewe, ja c'o rpwok mejor tic'ama'el in tic'ama'el rmaleta chakaja'. Ja c'a mta jun espada ruq'uin mejor tic'ayij ja rchaqueta in tilok'o' jun espada. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Queri' nbij chewe como anin puersa nink'ax na chipan ja tz'ibtal can chwe chipan ja rtzobal Dios, quewa' tz'ibtal can chwe ri': —Arja' xa junan ban tre ja cani' nba̱n chique ja ritzel tak winak. Queri' ja tz'ibtal can chwe in puersa nbantaj na cumplir como nojel ja tz'ibtal can chwe jari' ntajini nbantaj cumplir, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ja c'a reje'e' quibij tre: —Tetz'ata' mpe' Kajaw, c'o ca'i' espada kuc'an ri', xeche' tre. —Mejor ch'enchila', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","C'ac'ari' xel chipan ja tinamit, be pa jun lugar rbina'an Rjayu'al Olivo como nijawari' lugar neq'ueje' wi'. Ja c'a rdiscípulo eje'e' etran trij. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ja c'a tok xe'ekaj chipan ja lugar quewa' xbij chique ri': —Tebana' orar utzc'a ja Satanás tok xquixrtakchi'ij maquita xquixruch'ec, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","C'ac'ari' junwi' xyonaj pon wi' ri', ruyon q'ueje' pon chiquinakaj, xuque'e in xumaj rbanic oración, quewa' ja roración xuban ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Nata', anin nwajo' nabij ta chwe chi maquita nink'ax chipan awa' rpokonal ja penak chinwach ri' xarwari' ni ta c'a xquink'ax wi' chipan ja wi queri' nawajo' chwe chi nban, ne' tre ja Tatixel. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","C'ac'ari' c'o jun ángel winakar chwach penak chila' chicaj, xurya'a' kaj más rchok'ak'. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Como majtajnak rmal jun nimlaj rpokonal xa chewi' tok más chi na xuban ja roración. C'oli ja ya' nel chi rpalaj cani' nimak tak jutz'uj quic' nkaj pa tok'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ja c'a tok tzuri ja roración rmal yictaji in be cuq'uin ja rdiscípulo. Ja tok xekaj cuq'uin ekajnak chi waram como congana ecosnak rmal bis. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","—¿Nak tre tok xa waram neban? Camic quixyictaji in tebana' oración utzc'a ja Satanás tok xquixrtakchi'ij maquita xquixruch'ec, ne'e ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kas c'a rmajon na tzij cuq'uin ja rdiscípulo ja tok congana e q'uiy ja winak xe'urkaj ruq'uin. C'o jun achi rc'amonto quebey, Judas rubi', arja' jun chique ja cablajuj apóstol. Ja c'a Judas arja' tiloc ruq'uin ja Jesús utzc'a chi ntz'ubaj ruchi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pro ja c'a Jesús quewa' xbij tre ri': —¿La ninatz'ubaj Judas? ¿La ruq'uin jun tz'uban chi'ij najachbej ja Ralc'walaxel pa quek'a' ja netzelan rxin? ¿La queri' naban tre ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ja c'a rachbil ja Jesús eje'e' tok ch'obtaj cumal chi c'o rc'ayewal penak trij quewa' quibij tre ri': —¿Nak nabij tre Kajaw, la utz nkacoj ja respada chiquij? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pi c'a jun chique, xlasaj ja respada in c'o jun moso rxin ja lok'laj sacerdote xusoc tre, xkupijel jun rxquin ja c'o pa riquik'a'. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ja c'a Jesús xbij chique ja rachbil: —Ma teban ta más ja ch'a'oj, ne' chique. C'ac'ari' xuchap ja rxquin ja moso in xtzursaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ec'o c'a ja jefe quixin sacerdote e cachbil ja jefe quixin ja nechajin rxin ja nimlaj templo xin Dios e cachbil chic ja principali' xin tinamit, eje'e' epenak chi rchapic ja Jesús. Ja c'a Jesús quewa' xbij chique ri': —¿La in alak'om la'an chewi' tok ec'amonto espada ec'amonto che' chwij chi nchapic? ");
INSERT INTO tzjNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pro anin k'ij k'ij xinq'ueje' checojol chipan ja nimlaj templo xin Dios pro ma xinechap ta wa'an tri'. Pro jawa' hora ja rokc'o wi' ri' jawa' yatajnak chewe chi nixban mandar rmal ja diablo ja nbano mandar chipan ja k'ekumal, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","C'ac'ari' quechap, quec'amel chi rochoch ja lok'laj sacerdote. Ja c'a Pedro arja' rtrarben ja Jesús pro c'a c'a nat nutzu' pon chic wi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ja tok xe'ekaji quebox jun k'ak' chwa jay in xetz'abe' chuchi'. Ja c'a Pedro arja' tz'abe' cuq'uin chi k'ak'. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kas tz'ubul chi k'ak' ja tok pi jun aj'ic', congana xtz'elwachij in quewa' xbij ri': —Jawa' jun achi ri' arja' rachbilaj ja Jesús chakaja', ne'e ja raj'ic'. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pro ja Pedro arja' ma xuya' ta trij ja bix tre, quewa' xbij tre ja raj'ic' ri': —Nbij chawe ixok chi anin ma wotak ta rwach ja Jesús, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","C'a co'l ari' ja tok c'o chic jun tz'ato rxin ja Pedro in quewa' xbij tre ri': —Atat at cachbil chakaja' ja rachi'i' ja xe'acachbilan rxin ja Jesús, ne' tre. —Nbij chawe achi chi ma in cachbil ta, ne'e ja Pedro tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","C'o la jun hora ari' ja tok pi chic jun ja bano asegurar chi ni katzij wi' chi ja Pedro rachbilaj ja Jesús, quewa' xbij ri': —Bien k'alaj chi jawa' jun achi ri' rachbilaj ja Jesús chakaja' como arja' aj Galilea, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pro ja Pedro xbij tre: —Nbij chawe achi chi anin ni ma wotak ta ja nabij le', ne' tre. Kas c'a rmajon na tzij ja Pedro ja tok xok'i ja ac'. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ja c'a kajaw Jesucristo arja' xuya' vuelta in xtz'elwachij ja Pedro. Ja c'a Pedro xurkaj tre ja bin tre rmal ja Jesús, quewa' bin tre ri': —Ja tok maja'n tok'i ja ac', oxmul xtabij na chwe chi: —Anin ma wotak ta rwach ja Jesús, natche' na chwe. Queri' ja bin tre rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","C'ac'ari' xelto, congana jun nimlaj bis ok'ej nuban. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ja c'a rachi'i' ja rechapyon rxin ja Jesús eje'e' quemaj ryok'ic in quemaj rch'ayic chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Quitz'apij rwach chi su't in tok tz'aptaj cumal queya' k'a' chi rpalaj in quewa' quibij tre ri': —Tabij c'a chake camic ¿nak yowi k'a' chi apalaj? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","In c'a c'o na más ja pokonlaj tak tzij quibij tre ja nquiyok'bej rxin. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ja c'a tok sakari quemol qui' ja principali' xin tinamit e cachbil ja jefe quixin sacerdote e cachbil chic ja maestro ja netijon quixin ja winak tre ja ley xin Dios. Quec'amel ja Jesús chipan ja k'etbaltzij quixin. Ja tok xe'ekaji quewa' quibij tre ri': ");
INSERT INTO tzjNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Camic tabij chake ¿la atat ja rat Cristo ja ratcha'on rmal ja Dios? xeche' tre. Ja c'a Jesús quewa' xbij chique ri': —Pro ixix xa matenimaj masqui nbij chewe. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","In chakaja' wi c'oli nc'waxaj anin chewe wotak chi matec'ulba' in wotak chakaja' chi maquinesokpijel. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pro camic nbij chewe, chipan ja tiempo ja penak chikawach nbe ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak netz'abe'e pa riquik'a' ja Dios ja bar c'o wi' ja nimlaj poder xin Dios, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","—¿La atat c'a ja rat Ralc'wal Dios? xeche' tre. —Queri' ja cani' nebij le', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ja c'a reje'e' quibij: —Camic mchita ne'oc wi' más ja testigo como ajoj mismo kac'axaj ja xbij le', xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","C'ac'ari' xeyictaji canojelal, quec'amel ja Jesús chwach ja gobernador Pilato. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ja c'a tok xe'ekaji quemaj rbixic jule' ril ja Jesús: —Ajoj katz'aton ja nuban ala' jun achi le', xa ntajini nuyoj quina'oj ja kach tak aj Israel. Arja' nbij chique ja winak chi ma rubey ta ja nquetoj ja rimpuesto pa ruk'a' ja César ja nimlaj rey. In jun chic, nucoj ri' como Cristo, tibij c'a tzij ari' chi nucoj ri' como jun rey, xeche' tre ja Pilato. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ja c'a Pilato quewa' xbij tre ja Jesús ri': —¿La atat ja rat rey quixin ja tinamit Israel? ne' tre. —Queri' ja cani' nabij le', ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ja c'a Pilato arja' tzijon chic cuq'uin ja jefe quixin sacerdote in cuq'uin ja jule' chic winak, quewa' xbij chique ri': —Ja ntz'at anin ni majun ril ja rachi, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pro más chi na xeyictaj trij ja Jesús, quewa' quibij chic tre ja Pilato ri': —Pro ja rachi arja' xa ntajini nuyoj quina'oj ja winak, ntajini nertijoj nojel nat nakaj chipan ja departamento Judea, xumajto rya'ic ja tijonem chipan ja departamento Galilea in camic rmajon rya'ic chique ja winak wawe' chakaja', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ja c'a Pilato tok xc'axaj chi pa Galilea rya'on wi' ja tijonem ja Jesús rmalc'ari' tok quewa' xbij chic chique ri': —¿La maxta aj Galilea ja rachi ri'? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ja c'a tok bix tre chi aj Galilea ja Jesús c'ac'ari' xutakel ruq'uin ja Herodes ja gobernador xin Galilea como ja Herodes arja' c'o pa Jerusalén tri' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ja c'a Herodes tok xekaji ja Jesús ruq'uin congana quicoti como arja' c'o chic tiempo ja congana rgana nutz'at ri' quewach ruq'uin como ekajnak chic rbixic ruq'uin nojel ja ntajini nuban ja Jesús in c'o rgana nutz'at ja tok nuban jun milagro. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Congana pregunta xuban tre pro nixtac'a c'o ta jun ti tzij bix ta tre rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ec'o c'a ja jefe quixin sacerdote e cachbil ja maestro ja netijon quixin ja winak tre ja ley xin Dios, eje'e' congana nqueban, quemaj rbixic ril ja Jesús chwach ja Herodes. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ja c'a Herodes e rachbil ja rsoldado eje'e' ni ma vale ta chiquewach ja Jesús, quemaj ryok'ic, quecoj jun tziak tre ja cani' nquecoj rey pro jari' xa nquiyok'bej rxin. C'ac'ari' ja Herodes xutakel chic jutij ruq'uin ja Pilato. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jari' mismo k'ij xetzuri ja Pilato ruq'uin ja Herodes, xe'oc chic amigo como ja nabey xa quic'ulel qui'. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ja c'a Pilato arja' xerumol ja jefe quixin sacerdote e cachbil ja k'etol tak tzij quixin ja tinamit Israel e cachbil chic ja jule' chic winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ja tok xemoltaj rmal quewa' xbij chique ri': —Camic ec'amonto ja rachi chinwach ri', ja ril nebij chi xa neruyoj ja tinamit. Pro bien tech'obo', chewach ixix xinc'ot ruchi' in ja ntz'at anin ni majun ril ja cani' nebij tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ja Herodes chakaja' ni majun ril xuwil como xutakpi chic jutij pa kak'a' ajoj. Mta rbanon ja rachi ja yatal ta trij chi xtikacamsaj ta. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Rmalc'ari' mejor ja nban tre, xa nya' jun orden chi nrapaxi in tok xtiraptaji c'ac'ari' nsokpijel, ne'e ja Pilato chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Queri' xbij chique como ja pa tak nmak'ij pascua arja' puersa nsokpijel jun cach aj tinamit ja rocnak preso. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ja c'a reje'e' xa junan queban, quemaj rakic quechi' canojelal: —Tacamsaj ja rachi le'. Ja c'a Barrabás jari' tasokpijel, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ja Barrabás arja' jun achi xuban jutij yictaj trij ja gobierno chipan ja tinamit in ec'oli ja winak xercamsaj xa chewi' ja tok ocnak preso. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ja c'a Pilato como c'o rgana nsokpijel ja Jesús rmalc'ari' tok tzijon chic jutij cuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pro ja reje'e' xa más chi na quemaj rakic quechi': —Tacamsaj chwach cruz, tacamsaj chwach cruz, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ja c'a Pilato pa roxmul xbij chique: —Pro ¿nak c'a tre tok nec'utuj rcamic, nak rbanon chewi'? Ja ntz'at anin ni majun rbanon ja yatal ta trij chi xtikacamsaj ta. Rmalc'ari' mejor nya' jun orden chi nrapaxi in tok xtiraptaji c'ac'ari' nsokpijel, ne' chic chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pro ja c'a winak e cachbil ja jefe quixin sacerdote xajutij quimajon rakic quechi', congana nquecoj ja Pilato pa ch'a'oj chi ncamsaxi ja Jesús chwach cruz in tok q'uiswani eje'e' xech'ocmaji. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ja c'a Pilato xuya' jun orden chi queri' nba̱n tre ja Jesús ja cani' ncajo' eje'e'. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Xsokpijel ja rachi ja rocnak pa che' ja yictaj trij ja gobierno ja rec'o jule' winak xercamsaj. Jari' ja rachi ja quic'utuj tre. Ja c'a Jesús jari' xujach pa quek'a' jule' soldado utzc'a chi queri' nba̱n tre ja cani' ncajo' ja winak chi nba̱n tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ja c'a soldado eje'e' kas quic'amonel ja Jesús pa bey ja tok c'o jun achi quewil, Simón rubi', aj Cirene. Ja c'a Simón arja c'a melojto pa tak k'ayis in trij arja' queya'el chi wi' ja cruz, puersa queban tre chi ntre'el trij ja Jesús in nrijkajel ja cruz. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ja c'a Jesús congana e q'uiy ja winak etran trij in chakaja' ec'o jule' ixoki', eje'e' congana ncok'ej rwach, congana nquibisoj. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pro ja Jesús arja' xuya' vuelta in quewa' xbij chique ri': —Ma quinewok'ej ta ixoki' ja rix aj Jerusalén. Mejor ja neban, tewok'ej ewi' ixix in tewok'ej quewach ja tak ewal chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Queri' nbij chewe como nerila' na jun c'ayewalaj tiempo ja tok quewa' xtiquibij ja winak ri': —Ja camic congana qui'il chique ja rixoki' ja ni mta wi' alanem chiquij, congana qui'il chique ja rixoki' ja ni mta wi' tak cal eq'uejenak ta, xqueche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ja tok xterila' ja c'ayewalaj tiempo quewa' xtiquemaj rbixic ja winak ri': —Mejor ta titzakto chakij ja nimak tak jayu', ta korumuk ja cocojlaj tak jayu' chakaja', xqueche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Queri' nbij chewe como anin wi quewa' nqueban chwe ja tok in cani' jun che' rax ja ma yatal ta tre chi nc'ati in janila jun nimlaj rpokonal ja xtiban chique ja winak ja re cani' jule' chakijlaj tak che'. Queri' xbij ja Jesús chique ja rixoki'. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ec'o chi c'a ca'i' achi'i', eje'e' c'oli ja quil quibanon in junan xec'amarel ruq'uin ja Jesús chi ne'ecamsaxi. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ja c'a tok xe'ekaj chipan ja lugar rbina'an Rwi'camnak tri' querip wi' ja Jesús chwach cruz in queri' queban chique ja re ca'i' achi'i' ja c'o quil chakaja', jun pa riquik'a' in jun pa rxcon. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ja c'a Jesús arja' c'o jun oración xuban quewari': —Nata', que'acuyu' como eje'e' ma cotak ta ja netajini nqueban, ne' tre ja Tatixel. C'ac'ari' quemaj rbanic suerte trij ja rtziak nak xtich'eco chique in quejach chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ja c'a winak ja quimajon rtz'atic ja nbantaji e cachbil ja k'etol tak tzij eje'e' quemaj rtz'ujic ja Jesús, quewa' quibij ri': —Arja' To'onel quixin winak ne'xi, ja c'a wi ni katzij wi' chi arja' ja Cristo ja cha'on rmal ja Dios tito'o' c'a ri' ruyon camic, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ja c'a soldado eje'e' quemaj ryok'ic chakaja', xetiloc más ruq'uin ja Jesús, c'o jule' ch'amlaj vino quitzujuj tre ");
INSERT INTO tzjNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","in quewa' quibij tre ri': —Atat wi ni katzij wi' chi at Rey quixin ja tinamit Israel tato'o' c'a awi' ayon, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","C'o jule' tz'ibanem bani in parwi' ja Jesús ya'on wi' chwach ja cruz, oxi' rwach ja tzobal ja tz'ibax wi', jun pa griego, jun pa latín, in jun chic pan hebreo, quewa' nbij ri': —Jawa' rachi ri' arja' rey quixin ja tinamit Israel, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","C'o c'a jun chique ja re ca'i' achi'i' ja c'o quil quibanon ja reripon chwach cruz arja' xumaj rbixic jule' itzel tak tzij tre ja Jesús, quewa' xbij tre ri': —Ja wi ni katzij wi' chi atat ja rat Cristo tato'o' c'a awi' camic in ko'ato'o' ajoj chakaja', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pro ja c'a jun chic achi ja c'o ril rbanon arja' xumaj rch'olixic ja jun chic: —¿La mataxbej awi' chwach ja Dios como atat k'eton chic tzij chawij chi natcamsaxi chakaja'? ");
INSERT INTO tzjNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ja rajoj ni yatal wi' chakij chi nokcamsaxi como jari' nkatojbej ja ritzelal kabanon pro ja jun chic achi le' arja' mta nak ta itzelal rbanon, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","C'ac'ari' tzijon chic ruq'uin ja Jesús, quewa' xbij tre ri': —Kas xquinurkaj chawe ja tok xcatpi chic jutij ja tok atocnak chic Rey chipan ja ragobierno, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ja c'a Jesús xbij tre: —Ni katzij wi' ja xtinbij chawe ri', chipan awa' jun k'ij ja rokc'o wi' ri' ok ca'i' awq'uin nokbe chipan ja utzlaj lugar ja bar c'o wi' quicotemal, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ja pa tak nc'ajk'ij c'o jun nimlaj k'eku'm xoqui nojel chwach'ulew, c'a a las tres xin takak'ij sakar chic jutij. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ja k'ij ma xca'y chi ta. In chaka jalal tok raktaji ja manta ja tasben rpan ja nimlaj templo xin Dios ja bar c'o wi' ja santilaj lugar, chaka ca'i' xuban. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ja c'a Jesús arja' xurak ruchi', xuban jun oración quewari': —Nata', pan ak'a' atat njach wi' ja wanma, ne' tre ja Tatixel. Ja c'a tok bitaj queri' rmal ni cam kaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","C'o c'a jun capitán pa'l tri', arja' tok xutz'at ja bantaji xumaj rya'ic ruk'ij ja Dios, quewa' xbij ri': —Jala' jun achi le' ni katzij wi' chi mta ril rbanon, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Congana e q'uiy ja winak quimolon qui' chi rtz'atic ja nbantaji. Pro ja tok quetz'at nojel ja bantaji congana nqueban, congana nebisoni xebe. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ja c'a rixoki' ja retranel trij ja Jesús ja tok xelel pa Galilea e cachbil canojel ja winak ja cotak rwach eje'e' c'a c'a nat xepe'eto chic wi', quimajon rtz'atic nojel ja nbantaji. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","C'o c'a jun achi José rubi', arja' aj Arimatea ja c'o pa rcuenta Judea. Ja c'a José arja' jun chique ja k'etol tak tzij quixin ja tinamit Israel pro jun utzlaj achi rbanon utz chwach Dios. Arja' nojel ruc'u'x rayben ja k'ij ja tok xtoqui ja gobierno xin Dios. Ma junan ta xuch'ob cuq'uin ja rach tak k'etol tzij como xa ma utz ta xutz'at ja queban tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Be c'a ja José ruq'uin ja Pilato chi rc'utuxic ja cuerpo rxin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ja tok yataj lugar tre rmal ja Pilato c'ac'ari' be xerkajsaj ja cuerpo rxin ja Jesús chwach cruz in xubar pa jun utzlaj tziak. Ja c'a tok bartaj rmal xerya'a' chipan jun panteón ja c'oton chwach jun portales pro jun panteón ja mta jutij cojon ta jun camnak chipan. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jawa' bantaji chipan ja k'ij ja nchomarsbex wi' nakun je'e rxin ja nmak'ij in xajalal maja'n tirili ja hora ja numajel wi' ja xula'nbal k'ij. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ja c'a rixoki' ja retranel trij ja Jesús ja tok xelel pa Galilea eje'e' xebe trij ja José, xequitz'ata' ja panteón in quetz'at chakaja' nak ban tre ja cuerpo rxin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ja c'a tok tz'attaj cumal c'ac'ari' xemeloji ja pa tak cochoch, xequichomij jule' ak'om ja qui' rxula' ja nquecoj trij rcuerpo ja Jesús. Ja pa xula'nbal k'ij xexula'ni ja cani' nbij ja ley xin Dios chi nqueban. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ja c'a xin domingo kas nsamuke'e xebe chic jutij ja rixoki', xequitz'ata' ja panteón, cuc'an ja rak'om ja quichominel. Ec'o chic jule' ixoki' ja recachbilanel. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ja tok xe'ekaji quetz'at chi lasan chic ja rabaj ja tz'apben ruchi' ja panteón. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Xe'oc c'a chipan ja panteón pro ja tok quetz'at mchita ja cuerpo rxin ja Jesús chipan. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Congana sachnak quina'oj rmal ja tok chaka jalal ec'o ca'i' achi'i' xequetz'at epa'l pa tak quixquin, congana nc'ac'oti ja quitziak. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Congana quixben qui' ja rixoki', xetique'e. Ja c'a ca'i' achi'i' quewa' quibij chique ri': —¿Nak tre ja tok chiquicojol camnaki' necanoj wi' ja c'asli? ");
INSERT INTO tzjNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Camic, ma wawe' chi ta c'o wi' ja Jesús, arja' c'astaj wa'an rwach ari'. Turkaj chewe ja xbij can chewe ja tok c'a c'o na ewq'uin pa Galilea, ");
INSERT INTO tzjNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","quewa' xbij can chewe ri': —Ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak rjawaxic chi nja̱ch na pa quek'a' ja rajmaqui', rjawaxic chi ncamsax na chwach cruz pro ja chi rox k'ij nc'astaj na, ne' can chewe, xeche'e ja ca'i' achi'i' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ja c'a rixoki' eje'e' xurkaj chique ja bin can chique rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","C'ac'ari' xe'elel chipan ja panteón, xemeloji, xebe cuq'uin ja julajuj apóstol ja bar quimolon wi' qui' cuq'uin ja jule' chic cachbil, xequicholo' chiquewach nojel awa' ja quitz'aton ri'. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ja rixoki' ja xecholo chiquewach ja rapóstol quewa' quebi' ri', jun María Magdalena, in jun chic Juana, in jun chic María ja rute' ja Jacobo in c'a ec'o na más ja cachbil. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ja c'a rapóstol eje'e' ma xquinimaj ta ja bix chique cumal ja rixoki', xa jule' tzij ma ch'obol ta ja bix chique ja nquech'ob eje'e'. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pro ja c'a Pedro arja' yictaji, c'amc'ol ranim be ruq'uin ja panteón. Ja tok xekaji cayoc chipan ja panteón, xutz'atoc ja utzlaj tak tziak rxin ja camnak chi xa ruyon chic c'o can. C'ac'ari' meloji ja chi rochoch, kas rmajon kaj rch'obic pa ranma nojel ja bantaji como congana c'asc'o'i xutz'at. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ec'o c'a ca'i' rdiscípulo ja Jesús jari' mismo k'ij quimajon binem, ebenak pa jun aldea rbina'an Emaús. Ja raldea c'o la oxi' legua rcojol ruq'uin ja tinamit Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ja c'a ca'i' discípulo eje'e' quimajon rtzijoxic chibil tak qui' nojel ja bantaj chipan ja jun ca'i' k'ij ja k'axnak can chic. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kas c'a quimajon tzij in c'oli ja quimajon rc'axaxic chibil tak qui' ja tok xekaji ja mismo Jesús cuq'uin in xerachbilajel pa bey. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pro ja reje'e' ma xyataj ta chique chi ncotakij rwach chi Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ja c'a Jesús quewa' xbij chique ri': —¿Nak c'a ja remajon rtzijoxic chibil tak ewi' pa bey in nak tre ja tok nixbisoni? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","C'o c'a jun chique Cleofas rubi', arja' xbij tre: —¿La ma awotak ta c'a ja bantaj chipan ja tinamit Jerusalén chipan ja jun ca'i' k'ij ja k'axnak can? Pro ja jule' chic winak ja xeq'ueje' pa Jerusalén eje'e' bien cotak ja bantaji pro ni canojelal. ¿La xc'a ayon atat ja ma awotak ta? ne'e ja Cleofas tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Nak c'a ja bantaji? ne'e ja Jesús chique. Ja c'a reje'e' quewa' quibij tre ri': —Noktzijon tre ja Jesús ja raj Nazaret. Ja Jesús arja' jun profeta xin Dios, congana nimak tak milagro xuban in congana poder rc'an ja rtzobal, jari' bien k'alaj chwach ja Dios in bien k'alaj chiquewach canojel ja winak chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ja c'a jefe quixin sacerdote e cachbil ja k'etol tak tzij rxin ja katinamit eje'e' quejach ja Jesús pa ruk'a' ja Pilato utzc'a chi nk'e̱t tzij trij chi ncamsaxi in queri' queban quicamsaj chwach cruz. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pro ja rajoj congana yuke' kac'u'x ruq'uin chi arja' nto'o kaxin ja rok aj Israel pa quek'a' ja kac'ulel pro camsaxi in c'uluto tuban oxi' k'ij ticamsaxi. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","In jun chic, ec'o jule' ixoki' e kachbil c'oli quibij chake ja congana c'asc'o'i kac'axaj. Eje'e' kas nsamuke'e xebe ja bar c'o wi' ja panteón. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ja c'a tok xe'ekaji quetz'at chi mchita ja cuerpo rxin ja Jesús chipan. C'ac'ari' xemelojto kuq'uin, xurquibij chake chi ec'o ángel xewinakar chiquewach in bix chique cumal ja ángel chi c'astajnak chic ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ec'o c'a jule' achi'i' e kachbil, eje'e' xebe chic ruq'uin ja panteón in tok xe'ekaji quetz'at chi ni katzij wi' ja bix chique cumal ja rixoki'. Pro ja Jesús jari' ni mta wi' rwach quetz'at ta tri'. Queri' c'a ja bantaji, xeche'e ja ca'i' discípulo tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ja c'a Jesús quewa' xbij chique ri': —Ixix xa matich'obtaj emwal nojel ja quibin can ja rojer tak profeta xin Dios, ma nojel ta ec'u'x ma nojel ta ewanma eniman nojel ja tz'ibtal can cumal chipan ja rtzobal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ja Cristo arja' bien k'alaj chi ni rjawaxic wi' tre nabey chi xurtija' nojel awa' ja rpokonal ja c'a xebij chwe ri' in c'a después na nbe pa gloria ja bar nk'alajin wi' chi congana nim ruk'ij, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","C'ac'ari' xumaj rch'obic chiquewach nojel ja tz'ibtal can tre chipan ja rtzobal Dios, xumajto rch'obic chiquewach ja tz'ibtal can rmal ja Moisés c'ac'ari' xuch'ob chic chiquewach ja tz'ibtal can cumal ja jule' chic profeta. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ja c'a tok xe'ekaj chipan ja raldea ja bar ebenak wi' ja c'a Jesús xuban cani' laj xeruya' can. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pro ja c'a reje'e' congana quecoj pa ch'a'oj chi nq'ueje' kaj cuq'uin: —Xuban wa'an k'ij, xajalal maja'n toc ak'a'. Mejor catq'ueje' kaj kuq'uin, xeche' tre. In queri' xuban, xoc pa jay utzc'a chi nqu'eje' cuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ja c'a tok tz'ubul chic pa mesa cuq'uin c'oli ja caxlanway xuc'am, xmaltioxij tre ja Dios, xuwech' in xuya' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chaka c'a jalal ja tok yataj chique chi cotakij rwach chi Jesús. Ja c'a Jesús ni jari' hora sach chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ja c'a reje'e' quemaj chic tzij chibil tak qui', quewa' quibij ri': —Ja tok arja' rmajon tzij kuq'uin pa bey in tok rmajon rch'obic chikawach ja rtzobal Dios jari' ni katzij wi' chi congana jun nimlaj quicotemal xuna' ja kanma rmal, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ni jari' hora xeyictaji, xemeloj chic jutij pa Jerusalén. Ja tok xe'ekaji xequewil ja julajuj apóstol ja quimolon qui' cuq'uin jule' chic cachbil. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Quewa' bix chique cumal ja rapóstol ri': —C'astajnak chic wa'an ja kajaw Jesús, xuc'ut wa'an ri' chwach ja Simón, xeche'xi ja ca'i' discípulo. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","C'ac'ari' quemaj rcholic chiquewach nojel ja bantaji ja tok ebenak chipan ja raldea Emaús in quech'ob chiquewach chakaja' nak rbanic ja tok yataj chique chi cotakij rwach ja Jesús tokori' tok xuwech' ja caxlanway chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kas c'a quimajon tzij ja tok chaka jalal winakari ja Jesús chiquicojol in quewa' xbij chique ri': —Ja quicotemal xin Dios tiq'ueje' checojol, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pro ja c'a reje'e' congana nqueban rmal ja xbeben ri'il como ja nquech'ob eje'e' ranma jun camnak ja nquetz'at. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ja c'a Jesús xbij chique: —¿Nak tre ja tok sachnak ena'oj? ¿Nak tre tok matenimaj chi anin ja rin Jesús? ");
INSERT INTO tzjNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tetz'ata' mpe' ja pa nuk'a', tetz'ata' mpe' ja pa wakan, kas bien mpe' tech'obo' chi anin in Jesús. Quinechapa' mpe' in bien quinetz'ata' como ja ranma jun camnak jari' mta rch'acul nixtac'a c'o ta rbakil chakaja' pro bien netz'at chi anin c'o nch'acul in c'o nbakil chakaja', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ja c'a tok bitaj queri' rmal c'ac'ari' xuc'ut chiquewach ja pa ruk'a' in pa rkan. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ja c'a reje'e' quewa' quimajon kaj rch'obic pa tak canma ri': —Congana taka'an qui'il ja wari' pro ma katzij la, xeche'e. Ja c'a Jesús xbij chique: —¿La c'oli neya' chwe can ntij? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","C'o c'a jalal ch'u' sa'on jari' queya' tre rachbil jalal raxcab. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ja c'a rarja' xuc'am chique in xumaj rtijic pro ni chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","C'ac'ari' xbij chique: —Camic bantaj cumplir ja tzij ja xinbij chewe tokori' tok maja'n quincami como ja xinbij chewe chi puersa nbantaj na cumplir nojel ja tz'ibtal can chwe chipan ja rtzobal Dios cani' tre ja tz'ibtal can rmal ja Moisés in cumal ja jule' chic profeta xin Dios in chakaja' ja tz'ibtal can chwe chipan ja libro xin salmo, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","C'ac'ari' xuch'ob más chiquewach ja rtzobal Dios, ");
INSERT INTO tzjNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","quewa' xbij chique ri': —Tz'ibtal can chipan ja rtzobal Dios chi ja Cristo arja' nurtija' na ja rpokonal in ncamsax na in chi rox k'ij nc'astaj na chiquicojol camnaki', queri' nbij. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","In tz'ibtal can chakaja' chi pa rubi' ja Cristo nekaj na rbixic cuq'uin canojel ja winak ja rec'o pa tak nación je'e chi rjawaxic chi nqueq'uex ja quina'oj in nqueya' can ja ritzelal utzc'a chi ncuytaji ja quil quemac, jari' pa Jerusalén nmajtajel wi' rbixic. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ixix etz'aton nojel awa' ja c'a xinbij chewe ri', ixix nixk'alasan na chiquewach ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Bien tec'waxaj ja xtinbij chic chewe ri', anin ntakto na ja rEspíritu Santo ewq'uin ja cani' tzujunto rmal ja nata' Dios. Pro quixq'ueje' wawe' chipan ja tinamit Jerusalén, c'a tokori' nixel chipan ja tok xtiyataj chewe ja poder rxin ja rEspíritu Santo ja xtikajto chila' chicaj, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","C'ac'ari' xeruc'amel, xebe c'a pa Betania. Ja c'a tok xe'ekaji xuyic chicaj ja ca'i' ruk'a' in xc'utuj ja rutzil xin Dios pa quewi'. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kas c'a rmajon rc'utuxic ja rutzil pa quewi' ja tok chaka jalal be, c'amarel chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ja c'a reje'e' congana queya' ruk'ij c'ac'ari' xemeloj chipan ja tinamit Jerusalén, congana jun nimlaj quicotemal c'o pa tak canma. ");
INSERT INTO tzjNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","K'ij k'ij ni nepi wi' chipan ja nimlaj templo, xajutij quimajon rya'ic ruk'ij ja Dios. Amén.");
INSERT INTO tzjNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ja kas nabey tok ni majun nak ta tz'ucarsan ni c'o chi wi' tri' ja Ralc'walaxel ja nk'alasani jani' rna'oj ja Dios. Xa jun quibanon ruq'uin ja Dios in ni Dios wi' arja' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ja tok majun nak ta tz'ucarsan ni xa jun wi' quibanon ruq'uin ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","In yataj tre rmal ja Dios chi arja' tz'ucarsani ja caj in rwach'ulew. Ni majun nak ta ja tz'ucarsan ja maquita arja' tz'ucarsani. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Arja' Yo'l c'aslemal in ja c'aslemal nuya' jari' cani' jun nimlaj luz. Jari' luz ni rsakirsanto wi' quebey ja winak ojer ");
INSERT INTO tzjNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","in camic rmajon rsakirsaxic quewi' canma ja winak chipan ja k'ekumal in ni ma cowinnak ta wi' ja k'ekumal trij ja luz chi rchupun ta. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","C'o c'a jun achi tak rmal ja Dios, Juan rubi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ja samaj ja yataj tre ja Juan chi nuya' rbixic nak rbanic ja Ralc'walaxel ja nsakirsan quebey ja winak utzc'a chi canojel ja winak tok xtiquic'axaj nyuke' quec'u'x ruq'uin ja Ralc'walaxel. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ja Juan ma arja' ta ja luz pro xarwari' tak rmal ja Dios chi nuya' rbixic nak rbanic ja luz. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jari' luz ja kas mero luz xin Dios pi wawe' chwach'ulew, arja' ja nsakirsani quewi' canma ja winak canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Xurq'ueje'e ja Ralc'walaxel wawe' chwach'ulew in masqui arja' tz'ucarsani ja rwach'ulew pro ja winak ja rec'o chwach ja rwach'ulew ma xquinimaj ta chi arja' ja luz xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Xurq'ueje' chiquicojol ja rtinamit pro eje'e' ma xquinimaj ta. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pro kanojelal ja xokniman rxin, kanojelal ja yuke' kac'u'x ruq'uin, arja' xuya' chake chi xokoc ok ralc'wal Dios, ");
INSERT INTO tzjNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","xuya' chake chi xokalax chic jutij pro ja c'ac'a c'aslemal ja yatajnak chic chake jari' ma c'amonpi ta chake cumal ja kati't kamama', ma xyataj ta chake cumal ja katata' kate', ni majun winak yo' ta chake, solo Dios yowi. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ja Ralc'walaxel ja nk'alasani jani' rna'oj ja Dios arja' kajto, xoc kach winak, q'ueje' chikacojol. Katz'at ruq'uin kawach chi ja rc'aslemal arja' mero rc'aslemal ja Dios, junan ruq'uin ja rc'aslemal Dios Tatixel, mchita jun ralc'wal ja Tatixel ja queri' chi ta. Arja' nojnak ja rutzil xin Dios pa ranma, nojel ja nuch'ob, nojel ja nbij in nojel ja nuban ni katzij wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Arja' ya' rbixic rmal ja Juan, quewa' xbij ja Juan chique ja winak ri': —Jari' achi xinbij chewe ja tok quewa' xinbij chewe ri', c'o na jun ja maja'n tumaj rsamaj, arja' más na nim ruk'ij chinwach anin. Queri' nbij chewe como arja' ni c'o chi wi' ja tok maja'n quinalaxi masqui anin in nabey winak chwach, xinche' chewe, ne'e ja Juan. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ja Ralc'walaxel janila nojnak ja rutzil xin Dios pa ranma in jari' utzil ocnak chic chake ajoj in xa jani' npi más npi más pa tak kanma in xa sipan chake. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ja Moisés arja' yowi ja ley xin Dios pro ja Jesucristo arja' c'amyonto ja rutzil ja nsipaj ja Dios, arja' c'amyonto ja totajem ja ni katzij wi' chi totajem. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni majutij c'o ta jun winak tz'atyon ta rwach ja Dios pro ja Ralc'wal Dios ja ni xarwari' jun arja' c'o pa ranma ja Tatixel, xa jun quibanon ruq'uin in arja' rk'alasan chikawach jani' rna'oj ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ja Juan arja' xeta̱kel jule' achi'i' ruq'uin cumal ja raj Israel chi nec'axax tre nak ja rocnak wi'. Pa Jerusalén xe'elel wi' ja rachi'i', jule' chique e sacerdote in jule' chic chique e levita. Ja tok xe'ekaj ruq'uin ja Juan quewa' quibij tre ri': —¿Nak chi at achi'al? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Arja' bien xk'alasaj chiquewach chi ma arja' ta ja Cristo. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","In quibij chic tre: —¿Nak c'a atocnak wi', la maxta c'a atat ja rat Elías? xeche' chic tre. —Mni, ne'e ja Juan chique. In quibij chic tre: —¿La maxta c'a atat ja rat profeta ja bitajnak can chake chi natpi na? xeche' chic tre. —Mni, ma anin ta chakaja', ne' chic chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","In quibij chic jutij tre: —¿Nak c'a ja kas atocnak wi'? Tabij chake nak abanic utzc'a chi c'oli nekabij chique ja retakyonto kaxin awq'uin, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ja c'a Juan xbij chique: —Ja nbanic anin jari' rtz'iban can ja profeta Isaías ojer quewari': —C'o jun achi nurak na ruchi' pa jun lugar ja bar kas talan wi' in quewa' nbij chique ja winak ri': —Techomarsaj ja rec'aslemal chi raybexic ja kajaw Dios, ne' chique. Jawa' ja tz'ibtajnak can, anin c'ari' ja nrak nuchi', ne'e ja Juan chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ja rachi'i' ja retakonel ruq'uin ja Juan ec'o jule' fariseo etakyonel quixin. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","In quibij chic tre: —Ja wi ma atat ta ja rat Cristo in wi ma at Elías ta in nixtac'a at profeta ta ja kayben chi npi na ¿nak c'a tre tok ne'aban bautizar ja winak? xeche' chic tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ja c'a Juan xbij chique: —Ja ranin ya' ncoj ja tok nenuban bautizar ja winak pro ja camic c'o jun checojol jari' más chi na nim ruk'ij xarwari' mta enaben chi queri'. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Anin xa rbixic nya' ja samaj xin Dios ja xtumaj rbanic arja' como más chi na nim ruk'ij arja' chinwach anin, nixtac'a yatal ta chwij xquintiloc ta ruq'uin chi rquiric ja rc'amal rxajab. Queri' xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jawa' tzij bantaji ri' chipan jun lugar rbina'an Betábara ja c'o chic chajuparaj binelya' rbina'an Jordán, tri' ntajin wi' ja Juan chi neruban bautizar ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ja c'a chi rcab k'ij ja Juan xutz'at pon ja Jesús chi xajalal maja'n turkaj ruq'uin in quewa' xbij chique ja winak ri': —Tetz'ata' mpe' ja rachi le', arja' noc na cani' jun carnelo ja nba̱n sacrificar chwach ja Dios, arja' takonto wawe' chwach'ulew rmal ja Dios chi nurchupu' kaj ja kil kamac kanojelal ja rok winak. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ja c'ala' ja nbin chic chewe chi nurbana' na ja samaj xin Dios in más chi na nim ruk'ij arja' chinwach anin. Anin in nabey winak chwach pro arja' ni c'o chi wi' tri' ja tok maja'n quinalaxi. Queri' nbin chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Anin nabey mta nnaben chi arja' ja To'onel ja takonto rmal ja Dios pro rmal arja' tok inpenak camic, rmal arja' tok nmajon quibanic bautizar ja winak tre ya'. Queri' nmajon rbanic utzc'a chi ajoj ja rok aj Israel nkotakij chi arja' ja To'onel ja takonto rmal ja Dios, ne'e ja Juan chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","In xbij chic chique: —Anin xintz'at ja rEspíritu Santo penak chicaj cani' jun ajsakaxic' kajto trij in q'ueje' ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Pro ja nabey mta nnaben chi arja' ja To'onel ja takonto rmal ja Dios pro jari' k'alasax chinwach rmal ja Dios. Ja c'a Dios arja' intakyonto chi nenuban bautizar ja winak tre ya' in quewa' xbij chwe ri': —Ja tok xtatz'at ja rachi ja xtikajto ja rEspíritu Santo trij in xtiq'ueje' ruq'uin, arja' c'ari' xtibano bautizar quixin ja winak tre ja rEspíritu Santo. Queri' xbij chwe, ");
INSERT INTO tzjNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","in cani' xbij chwe ni queri' xintz'at in camic nbij chewe chi jala' jun achi le' arja' ja Ralc'wal Dios. Queri' xbij ja Juan chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ja c'a chi rcab k'ij c'o chic jutij ja Juan chipan ja lugar e rachbil e ca'i' rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Peti ja Jesús, k'ax cuq'uin ja winak. Ja c'a Juan tok xutz'at ja Jesús quewa' xbij chique ja winak ri': —Tetz'ata' mpe' ja rachi le', arja' noc na cani' jun carnelo ja nba̱n sacrificar chwach ja Dios. Queri' xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ja c'a re ca'i' discípulo rxin ja Juan eje'e' tok quic'axaj chi queri' xbij xetre'el trij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ja c'a Jesús tok ca'y can trij xerutz'at chi etran trij: —¿Nak necanoj? ne' chique. —Rabí ¿bar atc'o wi'? xeche' tre. (Rabí tibij tzij Maestro.) ");
INSERT INTO tzjNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","In bix chique rmal ja Jesús: —Jo', quixtre' chwij, tekatz'ata' ja bar inc'o wi', xeche'xi. Queri' queban xetre'el trij. Xe'ekaji ja bar c'o wi' in jari' k'ij xeq'ueje' ruq'uin, a las cuatro chi lari' xin takak'ij. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ja re ca'i' achi'i' ja xec'axani ja xbij ja Juan in xetre'el trij ja Jesús, jun chique rbina'an Andrés ja rch'alal ja Simón Pedro. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Be chanim ja rAndrés ruq'uin ja Simón ja rch'alal in quewa' xbij tre ri': —Camic kawil ja Mesías, ne' tre. (Mesías tibij tzij Cristo.) ");
INSERT INTO tzjNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","C'ac'ari' xuc'amel ruq'uin ja Jesús. Ja c'a tok xe'ekaji kas tz'elwachixi ja Simón rmal ja Jesús in quewa' bix tre ri': —Atat at Simón, at rc'ajol ja Jonás pro nyataj chi na jun ja bi'aj chawe Cefas natche'xi. (Cefas tibij tzij Pedro owi abaj.) ");
INSERT INTO tzjNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ja c'a chi rcab k'ij chic ja Jesús nuch'ob chi nbe chipan ja departamento Galilea. C'ac'ari' be ruq'uin ja Felipe in xbij tre: —Jo', cattre'el chwij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ja Felipe arja' aj Betsaida. Ja Betsaida jari' quitinamit ja rAndrés in Pedro, pa rcuenta Galilea c'o wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Be ja Felipe ruq'uin ja Natanael in quewa' xbij tre ri': —Camic kawilon chic ja To'onel ja tz'ibtal can chi npi na, ja tz'ibtal can chipan ja ley xin Dios rmal ja Moisés in tz'ibtal can chakaja' cumal ja jule' chic profeta. Ja wa'an ari' ja Jesús ja raj Nazaret ja rc'ajol ja José, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ja c'a Natanael arja' xbij: —¿La c'ol ek jun achi nwinakar na tri' pa Nazaret ja congana buena? ne'e. —Jo' mpe', tekatzata', ne'xi rmal ja Felipe in xebe. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ja c'a tok xe'ekaji tz'ati ja Natanael rmal ja Jesús in quewa' xbij ja Jesús ri': —Tetz'ata' mpe' ja Natanael le', arja' jun achi aj Israel pro ni katzij wi' chi aj Israel, arja' jun utzlaj achi in ni mta wi' jun engaño nuban. Queri' xbij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ja c'a Natanael tok xc'axaj ja bix tre rmal ja Jesús quewa' xbij tre ri': —¿Nak tre awotak taka'an nwach? ne' tre. —Atat tok maja'n catesiq'uixto rmal ja Felipe tokori' xatnutz'at chi at tz'ubul chuxe' jun che' higuera, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Rabí, camic bien ch'obtaj mwal chi atat ja rat Ralc'wal Dios, atat ja rat Rey kaxin ja rok aj Israel, ne'e ja Natanael tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","—Taka'an jurata xinanimaj rmal ja xinbij chawe chi xatnutz'at chi attz'ubul chuxe' ja che'. Pro c'o na nimak tak milagro natz'at na ja más chi na nimak chwach ja cani' xatz'at camic ri', ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","C'ac'ari' xbij chic chique: —Ni katzij wi' ja xtinbij chewe ri', netz'at na ja caj jakali, ne'etz'at na ja ángel xin Dios chi nejote'e in nexule'to pro mwal anin nyataj chique chi nqueban queri', mwal anin ja rin Alc'walaxel ja xinoc alaxic cuq'uin ja winak, queri' xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ja c'a chi rox k'ij c'o jun c'ulbic bantaji, ja c'a rute' ja Jesús c'o tri'. Jari' c'ulbic bantaj chipan ja tinamit Caná ja c'o pa rcuenta Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","In chakaja' banon invitar ja Jesús e rachbil ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pro chaka jalal tok q'uisi ja vino in bix tre ja Jesús rmal ja rute': —Pakasa' vino q'uisi, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—Ixok, taka'an ma junan ta nkach'ob awq'uin, maja'n wa'an terila' ja tiempo chi ja winak xticotakij nak nbanic, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","C'ac'ari' ja rute' xbij chique ja ilinela': —Xa nak ta nbij ja Jesús chewe tebana', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tri' c'o wi' waki' rc'olbal tak ya', abaj ocnak, ja jujun c'o la wuku' waxaki' cucu' ya' nbe chipan. Ja rsamaj noc wi' ja ya' jari' banbal quicostumbre ja raj Israel ja nquich'ach'ojirsbej nakun je'e ja cani' nrajo' ja quireligión chi nqueban. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ja c'a Jesús quewa' xbij chique ja ilinela' ri': —Tenojsaj ja rc'olbal tak ya' le', ne' chique. In queri' queban, xequic'ama'to ja ya', quinojsaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ja c'a tok nojstaj cumal c'ac'ari' bix chic chique rmal ja Jesús: —Camic tepulu'el jule', jec'utu' chwach ja rachi ja pa'l trij ja wa'im xin c'ulbic, xeche'xi. In queri' queban, quepulel. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ja ilinela' ja xepulu'el ja ya' eje'e' cotak chi q'uextaji ja ya' in xoc vino pro ja rachi ja pa'l trij ja wa'im xin c'ulbic arja' ma rotak ta. Tok xuna' ja vino chi congana buena c'ac'ari' xsiq'uij ja rachi ja c'ule'e ");
INSERT INTO tzjNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","in quewa' xbij tre ri': —Canojel ja winak ja nechomini ja nimak tak wa'im eje'e' utzlaj vino ja nquecoj nabey tok nmajtaji ja wa'im. Ja c'a tok q'uiy chic ja vino quitijon chic ja winak c'ac'ari' nya̱' chic chique ja vino ja ma kas ta buena. Pro ja ratat camic c'a pa rq'uisbal taka'an xacoj ja vino ja más chi na utz. Queri' xbij tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jawa' nabey milagro xuban ja Jesús, pa Caná xuban wi' ja c'o pa rcuenta Galilea, jawa' xc'utbej chiquewach ja rdiscípulo chi congana nim ruk'ij in yuke' quec'u'x ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ja Jesús tok tzur can rmal awa' wari' c'ac'ari' be chipan ja tinamit rbina'an Capernaum rachbil ja rute' e rachbil chakaja' ja rch'alal in ja rdiscípulo. Ja c'a tok xe'ekaji, tri' xeq'ueje' wi' jun ca'i' k'ij. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ja tok nnakajinto ja nmak'ij pascua quixin ja raj Israel be ja Jesús pa Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ja c'a tok xekaji xoc chipan ja nimlaj templo xin Dios. Chipan ja templo ec'o jule' winak quimajon quic'ayixic wacax, carnelo, palomax in ec'o jule' q'uexol tak pwok chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ja Jesús xbanla' jun asial in tok tzur rmal xe'erlasajto ja winak chipan ja templo, majun xuto' ta ri', in xe'erlasajto chakaja' ja carnelo e cachbil ja wacax. Ja c'a q'uexol tak pwok eje'e' chicax chiquewach ja quipwok rmal in ch'akix pa tok'ulew ja quimesa chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","C'ac'ari' xbij ja Jesús chique ja rajc'ay tak palomax: —Que'ewasajel jutz'it ja wari', ma teban ta tre ja rochoch ja nata' Dios cani' jun mercado, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ja c'a rdiscípulo tok quic'axaj ja xbij xurkaj chique ja tzij ja tz'ibtal can chipan ja rtzobal Dios quewa' nbij ri': —Congana nti'on chwe ja tok matiban respetar ja rawochoch in xa rmalari' tok xtiqueban pokon chwe ja winak, ne'e ja Cristo tre ja Tatixel. Queri' ja tz'ibtal can. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ja c'a raj Israel quibij tre ja Jesús: —¿Nak c'a nac'utbej chikawach chi c'ol ak'a' tre ja c'a xaban chipan ja templo ri'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","—Teyojo' mpe' ja templo ri' in ja ranin xa chi oxi' k'ij nyic chi wi' jutij, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ja c'a raj Israel quibij tre: —Jawa' templo ri' tuban cuarentiséis juna' majtajnakto rbanic in ¿nak moda c'ari' chi xa chi oxi' k'ij nayic chi wi' jutij atat? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pro ja templo ja xnataj ja Jesús jari' ja rcuerpo arja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ja c'a tok c'astajnak chic chiquicojol camnaki' bien xurkaj chique ja rdiscípulo ja rbin can tre ja templo chi xa chi oxi' k'ij nuyic chi wi' jutij. Quinimaj ja tz'ibtal can chipan ja rtzobal Dios ojer in quinimaj chakaja' ja tzij ja rbin can ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ja c'a tok majtaji ja wa'im rxin ja nmak'ij pascua chipan ja tinamit Jerusalén tri' q'ueje' wi' ja Jesús in e q'uiy chique ja winak yuke' quec'u'x ruq'uin rmal ja milagro ja xuban je'e chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pro ja Jesús arja' ma xyuke' ta ruc'u'x cuq'uin como bien rotak jani' quina'oj canojelal ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Arja' ma rjawaxic ta tre xtich'ob ta na chwach jani' quina'oj como bien rotak ja c'o pa tak canma ja winak xa nak ta chi winakil. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","C'o c'a jun achi Nicodemo rubi', arja' fariseo in chakaja' arja' jun chique ja k'etol tak tzij quixin ja tinamit Israel. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Xuban c'a jutij xekaji ja Nicodemo ruq'uin ja Jesús chak'a' in xumaj tzij ruq'uin, quewa' xbij tre ri': —Rabí, ajoj kotak chi atat at jun tijonel attakonto rmal ja Dios como anin wotak chi majun winak xticowin ta xtuban ta ja nimak tak milagro ja ramajon rbanic atat ja wi mta ja Dios ruq'uin, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ja c'a Jesús xbij tre: —Ni katzij wi' ja xtinbij chawe ri', ja winak rjawaxic chique chi ne'alax chic jutij nowi maque'alax chic jutij jari' ni matich'obtaj wi' cumal nak rbanic ja natoc chipan ja gobierno xin Dios, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—Pro ¿nak moda jun achi ri'j chic in nalax chic jutij? ¿La c'o c'a moda ari' nq'ueje' chic jutij pa gracia in nalax chic jutij? ne'e ja Nicodemo tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ja c'a Jesús xbij chic tre: —Ni katzij wi' ja xtinbij chawe ri', rjawaxic chi natalax tre ya' in tre ja rEspíritu nowi ma queri' ta naban jari' macatcowini natoc chipan ja gobierno xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ja c'aslemal ja yatajnak chique ja winak cumal ja quitata' quete' jari' xa ni junan wi' ruq'uin ja cani' quixin ja quitata' quete'. Ja c'a c'aslemal ja nyataj chawe rmal ja rEspíritu Santo jari' ni junan wi' ruq'uin ja cani' rc'aslemal ja rEspíritu Santo. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Maxta junwi' tac'waxaj ja xinbij chawe chi rjawaxic chi natalax chic jutij. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Cani' tre ik' cani' tre xcomel xa bar ta tri' nbe wi' nsamaji in nac'waxaj ja nuban pro ma awotak ta bar penak wi' in nixtac'a bar nbe wi' chakaja'. Queri' c'a chique canojel ja winak ja ne'alax rmal ja rEspíritu Santo como nsamaji ja rEspíritu Santo in rmal arja' tok ne'alax chic jutij, ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—Pro ¿nak c'a ja kas mero rbanic ja ramajon rbixic chwe? ne' chic jutij ja Nicodemo. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ja c'a Jesús xbij chic tre: —At maestro wa'an quixin ja tinamit Israel ja rtinamit Dios pro taka'an matich'obtaj amwal ja nbij chawe. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pro ajoj bien kotak nak rbanic ja kamajon rbixic, bien katz'aton ja kamajon rk'alasaxic chewach pro ja rixix xa matenimaj ja nkabij chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Anin nmajon rch'obic je'e chawach ja nbantaji wawe' chwach'ulew pro wi matanimaj pior c'a ja tok xtinch'ob chic je'e chawach ja nbantaji chila' chicaj ¿nak moda c'ari' xtanimaj chakaja'? ");
INSERT INTO tzjNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ni majun nak ta ekajnak ta chila' chicaj rtz'aton ta nak rbanic ja chila' chicaj, xa jun ja tz'atyon nak rbanic, arja' ja Ralc'walaxel ja kajto chila' chicaj ja xoc alaxic cuq'uin ja winak, arja' ja c'o pa ranma ja Tatixel chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Cani' xuban ja Moisés ojer chipan ja chakijlaj ulew, arja' c'o jun rachbal cumatz xjotba' chwach jun che' in xetotaji ja winak rmal in queri' c'a xtiban na tre ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak, arja' njotbax na chwach jun che'. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Queri' nba̱n na tre utzc'a chi canojelal ja winak ja xtiyuke' quec'u'x ruq'uin eje'e' maquetakel chipan ja rpokonal, nyataj jun utzlaj c'aslemal chique pro jun c'aslemal ja ni mta wi' q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ja Dios congana nerajo' canojelal ja winak rmalc'ari' tok xutakto wawe' chwach'ulew ja Ralc'wal, xarari' jun. Queri' xuban utzc'a chi canojelal ja winak ja xtiyuke' quec'u'x ruq'uin eje'e' maquetakel chipan ja rpokonal, nyataj na chique jun utzlaj c'aslemal ja ni mta wi' q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Queri' nbij como ja Dios tok xutakto ja Ralc'wal wawe' chwach'ulew ma rmal ta chi xquerutakel ta ja winak chipan ja rpokonal. Pro jari' xutakto utzc'a chi rmal ja Ralc'wal nquewil na ja totajem xin Dios canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Canojelal ja winak ja nyuke' quec'u'x ruq'uin ja Ralc'wal Dios eje'e' mchita k'etoj tzij xin Dios chiquij pro ja c'a matiyuke' quec'u'x ruq'uin eje'e' k'eton chic tzij chiquij rmal ja Dios chi neta̱kel chipan ja rpokonal. Como matiyuke' quec'u'x ruq'uin ja Ralc'wal Dios chewi' tok nba̱n queri' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Como eje'e' mta quigana ruq'uin ja luz ja penak chila' chicaj ja nsakirsan quebey chiquewach xa chewi' tok k'eton chic tzij chiquij. Como ja Ralc'wal Dios arja' cani' jun luz peti wawe' chwach'ulew pro ja winak más na xel quec'u'x trij ja k'ekumal. Queri' queban como xa itzelal ja quimajon rbanic. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ja wi amajon rbanic ja ritzelal jari' xa itzel natz'at ja luz, ni majun agana xcatekaj ta ja bar c'o wi' ja luz. Queri' naban utzc'a chi matotakixi ja ritzelal ja ramajon rbanic. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pro ja c'a wi amajon rbanic ja rutzil xin Dios jari' matapokonaj natekaji ja bar c'o wi' ja luz. Matapokonaj como c'ol agana chi natquetz'at ja winak chi ja Dios uc'ayon awxin chi rbanic nojel ja nattajini naban. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","C'ac'ari' ja Jesús xerachbilajel ja rdiscípulo xebe chipan jun lugar ja c'o pa rcuenta Judea. Ja c'a tok xekaji, tri' q'ueje' wi' in ec'oli winak neruban bautizar. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","In queri' nuban ja Juan chakaja', arja' ntajini neruban bautizar ja winak chipan ja lugar rbina'an Enón ja c'o chinakaj Salim como ja tri' sobre ya'. Tri' xe'ekaj wi' ja winak in xeba̱n bautizar. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Maja'n ticoj pa che' tri' ja Juan rmal ja rey Herodes. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ja discípulo rxin ja Juan eje'e' quemaj tzij cuq'uin jule' chic aj Israel in c'oli quech'a' chibil tak qui' tre ja bautismo. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ja c'a discípulo rxin ja Juan xebe ruq'uin in quewa' xequibij tre ri': —Rabí, pakasari' ja rachi ja xaban bautizar chajuparaj binelya' Jordán ja xaya' rbixic chi arja' ja To'onel ja takonto rmal ja Dios, camic arja' ntajini neruban bautizar ja winak in canojel ja winak nebe ruq'uin, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Pro ja Juan xbij chique: —Ja ranin ninquicoti chi netajini nebe ja winak ruq'uin ja Jesús. Ja samaj nkaban chikajujunal chila' chicaj penak wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ixix bien xec'waxaj ja tok xinbij chique ja winak chi ma anin ta ja rin Cristo xarwari' intakonto chi nya' rbixic ja Cristo chi npi na. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ja Jesús yatal trij chi nebe ja winak ruq'uin chi ncachbilaj. Cani' tre jun ala' tok nc'ule'e yatal trij chi ja rxjayil nrachbilaj. No anin xa in cani' ramigo jun ala' tok nc'ule'e. Pro ja ramigo pa'loc pa rxquin ja rala' ja nc'ule'e in rmajon rc'axaxic ja nbij in congana nquicoti chi rc'axaxic. Queri' c'a chwe anin camic chakaja' ninquicoti, nojnak ja quicotemal pa wanma. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ja rjawaxic camic chi ni xtimajtajel wi' rya'ic ruk'ij ja Jesús chijutij cumal ja winak, ja c'a chwe anin rjawaxic chi xtiban chwe cani' ma inc'o ta chwach ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ja Ralc'walaxel ja penak chila' chicaj xa ruyon arja' ja más nim ruk'ij chiquewach canojelal. Pro ja rajoj ja rok winak ma katz'aton ta nak rbanic ja chila' chicaj, xa ok rxin ja rwach'ulew, xa jari' nkatzijoj ja kotakin wawe' chwach'ulew. Pro ja penak chila' chicaj xa ni ruyon wi' arja' ja más nim ruk'ij chiquewach canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ja rtz'aton in ja rc'axan chila' chicaj jari' rmajon rbixic pro ja winak xa matiquinimaj ja nbij. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ja c'a nenimani ja nbij quewa' nquibij ri': —Ja Dios ni katzij wi' nojelal ja nbij, neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dios takyonto rxin ja Ralc'walaxel in como ruq'uin ja Dios penak wi' chewi' tok tzij xin Dios ja nbij. Queri' nuban como ja Dios nutakto ja rEspíritu Santo ruq'uin in ni nojnak wi' ja rEspíritu Santo pa ranma, majutij ja maquita uc'an rmal. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ja Ralc'walaxel janila najo'x rmal ja Tatixel in ni majun nak ta ja maquita jachon pa ruk'a' rmal. ");
INSERT INTO tzjNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ja wi nyuke' ac'u'x ruq'uin ja Ralc'walaxel jari' awc'an chic ja utzlaj c'aslemal ja ni mta wi' q'uisic trij. Pro ja wi matanimaj ja Ralc'walaxel jari' ni matawil wi' ja utzlaj c'aslemal in ni c'o wi' ryewal ja Dios chawij. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ja c'a fariseo xekaj rbixic ja Jesús cuq'uin quewari': —Ja Jesús más na e q'uiy ja winak netajini ne'oc rdiscípulo chwach ja ne'oc ruq'uin ja Juan in más na e q'uiy neruban bautizar chakaja', xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pro ma ja ta ja Jesús nbanowi ja bautismo, rdiscípulo ja nebanowi. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ja kajaw Jesús tok xc'axaj chi xekaj rbixic ja tzij cuq'uin ja fariseo c'ac'ari' xel chipan ja departamento Judea, be chic chipan ja departamento Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pro rjawaxic chi nk'ax na chipan ja departamento Samaria. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Queri' xuban be, xekaj chipan jun lugar ja c'o chinakaj ja tinamit rbina'an Sicar c'o pa rcuenta Samaria. Ja tinamit Sicar chinakaj jun ulew c'o wi' ja rxin Jacob ojer, jun ulew ja xuya' can ja Jacob tre ja José ja rc'ajol. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","In tri' c'o wi' jun ya' c'oton rxin ja Jacob ojer chakaja'. Congana cosnak ja Jesús rmal ja binem xa chewi' tok tz'abe' chuchi' ja jul xin ya'. Pa tak nc'ajk'ij chi lari' ja tok xekaj tri'. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","C'o c'a jun ixok aj Samaria pulul ya' xurkaji ja bar tz'ubul wi' ja Jesús. Ja c'a Jesús xbij tre ja rixok: —Tasipaj jutz'it nuya', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ja c'a rdiscípulo ja Jesús eje'e' ebenak pa tinamit pa lok'oj way. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ja c'a rixok xbij tre ja Jesús: —Pro atat at aj Israel wa'an, ja c'a ranin in jun ixok in aj Samaria, taka'an nac'utuj ya' chwe, ne' tre. Queri' xbij ja rixok como ja raj Israel xa itzel quitz'aton qui' cuq'uin ja raj Samaria. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ja c'a Jesús xbij chic tre: —Ja wixta ch'obtajnak amwal nak rbanic ja cochinem ja nsipaj ja Dios chawe, wixta ch'obtajnak amwal nak inocnak wi' anin ja nintajini nintzijon awq'uin camic ri' ja nmajon rc'utuxic nuya' chawe, atat xac'utuj ta ya' ari' chwe chakaja' in xinya' ta jun ya' chawe pro jun ya' ja rc'amonto jun c'ac'a c'aslemal chawe, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Pro mta napulbej ja ya' in congana pos rpan ja jul ¿bar c'a c'o wari' ja ya' ja c'a xabij chwe? ");
INSERT INTO tzjNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ja kamama' Jacob arja' yoyon can chake awa' ja ya' ri' ojer, jawa' xutij arja' in quetij ralc'wal in quetij rwacax chakaja'. ¿La atat la'an ja más na nim ak'ij chwach arja'? ne'e ja rixok. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ja c'a Jesús xbij chic jutij: —Xa nak ta ntijowi ja ya' ri' arja' ni nuna' wi' chakichi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pro ja ntijowi ja ya' ja nya' anin jari' ni mchita wi' jutij nchakij ta ruchi'. Pro ja ya' ja nya' anin tre jari' congana npulinto pa ranma cani' nuban jun tz'uquel ya' in rc'amonto tre ja utzlaj c'aslemal pro jun c'aslemal ja ni mta wi' q'uisic trij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Ja ya' ja nabij le' taya'a' jutz'it wxin utzc'a majutij xtichakij chi ta nuchi' utzc'a ma rjawaxic chi ta xquinpi chi ta wawe' xtunpulu' chi ta ja ya' ri', ne'e ja rixok. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Camic jat, jasiq'uijto ja rawachajil, tawachbilajto, ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Pro ja ranin mta wachajil, ne'e ja rixok. —Ni katzij wi' ja nabij le' chi mta awachajil ");
INSERT INTO tzjNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","como e jo'o' ja rawachajil ejachon ewi' cuq'uin in ja rachi ja nq'ueje' awq'uin camic jari' ma awachajil ta. Ni katzij wi' ja xabij chwe chi mta awachajil, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Ja nch'ob anin maxla at jun profeta xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ja kati't kamama' ajoj ojer parwi' ja jun jayu' le' queya' wi' ruk'ij ja Dios pro ja rixix nebij chi rjawaxic chi pa Jerusalén nya̱' wi' ruk'ij ja Dios, nixche'e, ne'e ja rixok. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—Tanimaj ja xtinbij chawe camic ri', xa nnakajinto ja tiempo tok ma ruyon chi ta parwi' ja jun jayu' le' neya' wi' ruk'ij ja Tatixel in ma ruyon chi ta pa Jerusalén chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ixix ja rix aj Samaria neya' ruk'ij jun Dios pro ma ch'obtajnak ta emwal nak rbanic. Pro ja rajoj ja rok aj Israel nkaya' ruk'ij ja Dios in bien ch'obtajnak kumal nak rbanic como ja totajem xin Dios jari' chipan ja tinamit Israel nwinakar wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pro xa nnakajinto ja tiempo tok ja winak pa tak canma xtiwinakar wi' ja nquiyabej ruk'ij ja Tatixel in ni katzij wi' ja xtiqueban tre, ma chaka ta costumbre. Queri' xtiqueban ja winak ja ni katzij wi' chi nqueya' ruk'ij como queri' nrajo' ja Tatixel chi nba̱n tre in arja' rmajon quicanoxic ja nebano queri' tre. In ja camic ec'o jujun ja queri' chic nqueban tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ja Dios arja' Espíritu, matitz'attaji chewi' tok rjawaxic chi ja winak pa tak canma nwinakar wi' ja nquiyabej ruk'ij in rjawaxic chakaja' chi ni katzij wi' ja nqueban, ma chaka ta costumbre. Queri' xbij ja Jesús tre ja rixok. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","—Anin wotak chi npi na ja Mesías chi nurch'obo' chikawach nojelal nak rbanic, ne'e ja rixok. (Mesías tibij tzij Cristo.) ");
INSERT INTO tzjNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Pro anin c'ari' ja rin Mesías ja nmajon tzij awq'uin camic ri', ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kas quimajon tzij tok xe'urkaji ja rdiscípulo ja Jesús. Eje'e' kas junwi' quetz'at chi ntajini ntzijon ruq'uin jun ixok. Pro ni majun chique xbij ta tre: —¿Nak nawajo' tre owi nak netzijoj ruq'uin? xche' ta tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ja c'a rixok arja' xuya' can ja rcucu', be chipan ja tinamit. Ja c'a tok xekaji quewa' xbij chique ja winak ri': ");
INSERT INTO tzjNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—C'o jun achi xoktzijon ruq'uin, arja' xbij chwe nojel ja nbanon chipan ja nc'aslemal. Jo' mpe', tekatz'ata', maxla arja' ja Cristo, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","C'ac'ari' xe'el chipan ja tinamit in xebe ruq'uin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Maja'n que'ekaji ja tok bix tre ja Jesús cumal ja rdiscípulo: —Rabí catwa'i, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Anin c'oli ja nway pro ixix xa ma ewotak ta nak rbanic, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ja c'a rdiscípulo quewa' quibij chiquibil tak qui' ri': —Maxla c'o jun c'amyonto rway, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pro ja Jesús xbij chic chique: —Anin c'oli ja rocnak rq'uexwach nway. Anin ja tok nban rvoluntad ja Dios ja takyonpi wxin in tok nban cumplir ja samaj ja rya'on chwe chi nban jari' ja rocnak rq'uexwach ja nway. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ja nebij ixix c'a chi quiji' ic' nelto wi' ja cosecha, nixche'e. Pro anin nbij chewe, que'etz'ata' mpe' ja winak le' epenak, eje'e' e cani' jule' tijco'm ja k'en chic, utz chic nba̱n cosechar. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ja nebano cosechar quixin jari' c'o jun rtojbalil nyataj chique. Ja cosecha xtiqueban quewa' rbanic ri', nequecoj ja winak chipan ja gobierno xin Dios in jari' winak nyataj chique ja utzlaj c'aslemal ja ni mta wi' q'uisic trij. Queri' rbanic utzc'a chi nequicoti ja neticowi ja samaj in ja nebano cosechar ja samaj eje'e' nequicot cuq'uin chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Queri' rbanic cani' nbij ja jun tzij kac'axan quewari': —C'oli nticowi ja rija'tz in c'oli ja nbano cosechar rwach, queri' nbij. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Anin xixnutakel cuq'uin ja winak chi ne'ebana' cosechar pro ma ixix ta ja rixtijyonto rpokonal chi rbanic ja samaj pro ec'o jule' chic ja retijyonto rpokonal chi rbanic ja samaj in ixix camic nixtajini neban cosechar ja quiticonto eje'e'. Queri' xbij ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ja raj Samaria tok quic'axaj ja bix chique rmal ja rixok ja cach aj tinamit chi ja Jesús xbij tre nojelal ja rbanon chipan ja rc'aslemal e q'uiy chique yuke' quec'u'x ruq'uin ja Jesús rmal. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Rmalari' tok xe'ekaji ja raj Samaria ruq'uin ja Jesús quibij tre chi nq'ueje' cuq'uin in queri' xuban q'ueje' ca'i' k'ij cuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","In tok xumaj tzij ja Jesús cuq'uin ec'o na más chique yuke' quec'u'x ruq'uin rmal ja xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","In quibij tre ja rixok: —Ja nabey yuke' kac'u'x ruq'uin ja Jesús rmal ja xabij chake pro ja camic más chi na yukul kac'u'x ruq'uin como kac'axaj ja xbij chake in bien kotak chi arja' ja Cristo ja To'onel kaxin kanojelal ja rok winak, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ja Jesús tok tz'akati ja ca'i' k'ij rmal c'ac'ari' xe'elel tri', xebe chic chipan ja departamento Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Arja' c'o jun tzij rbin chic chique jule' winak, quewa' rbin chique ri': —Jun profeta xin Dios ma lok' ta nna'i cumal ja rach aj tinamit, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ja c'a tok xekaji kas qui'il rc'ulic bani cumal ja raj Galilea. Queri' queban tre como quitz'aton chic nojel ja xuban ja Jesús pa Jerusalén chipan ja nmak'ij pascua como eje'e' jun xepi chipan ja nmak'ij. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Xekaj chic jutij chipan ja tinamit Caná ja c'o pa rcuenta Galilea ja bar xuban wi' vino tre jule' ya'. C'o c'a jun oficial xin gobierno, arja' aj Capernaum in c'o jun rc'ajol yawa'. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ja c'a roficial tok xc'axaj chi elnakto ja Jesús pa Judea in tok xc'axaj chi c'o chic pa Galilea arja' be ruq'uin. Ja tok xekaji ruq'uin ja Jesús quewa' xbij tre ri': —Jo' paki jutz'it wq'uin, jatzursaj paki jutz'it ja nc'ajol, xajalal maja'n ticami, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","—Ixix taka'an ni ma xquinenimaj ta wi' ja maquita c'o jule' milagro nban chewach, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pro ja roficial xbij chic jutij tre: —Jo' paki jutz'it wq'uin, ja nc'ajol xajalal maja'n ticami, ne' chic tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Jat, mchita camíc nuban ja rac'ajol, ntzuri, ne'xi rmal ja Jesús. Ja roficial xnimaj ja bix tre in be. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kas rmajon bey tok xeruc'ul ja rmoso in bix tre cumal chi: —Tzuri ja rac'ajol, mchita camíc nuban, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—¿Nak hora xurkaj rwach pa sak? ne' chique. —Iwir a la una xin takak'ij xpaxij ri' ja c'atan trij, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ja tatixel bien ch'obtaj rmal chi jari' misma hora tok bix tre rmal ja Jesús chi mchita camíc nuban ja rc'ajol in ntzuri. Arja' más chi na yuke' ruc'u'x ruq'uin ja Jesús in ja rec'o pa rochoch eje'e' yuke' quec'u'x ruq'uin chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Quirc'awa' xuban ja Jesús tok xelpi chic ja pa Judea in tok xekaj chic pa Galilea, ja c'awa' rcab milagro xuban. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Xerila' chic jun ja nmak'ij ja nc'u̱l cumal ja raj Israel in be ja Jesús pa Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tri' pa Jerusalén c'o wi' jun ya'. C'o rubi' ja ya', ja pa quitzobal ja raj Israel Betesda nbix tre. Ja ya' chinakaj jun puerta c'o wi', jari' puerta ja bar natoc wi' chipan ja tinamit. C'o rubi' ja puerta, puerta quixin carnelo nbix tre. C'o jo'o' galera ja bar c'o wi' ja ya'. Jari' galera quixin yawa'i' chi neq'ueje' chuxe'. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","E q'uiy ja yawa'i' ec'o tri' cani' chique moya', cani' chique ja tak cojo in cani' chique ja resiquirnak chakaja'. Ja yawa'i' cayben jun tiempo ja tok xtursil can ja ya' rmal jun ángel. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Como c'o jun ángel nursila' can je'e ja ya'. Ja tok nsiltaj can ja ya' nebe ja yawa'i' chipan, ja c'a kas nkaji nabey chipan jari' ntzuri xa nak ta chi yobilal c'o tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","C'o c'a jun ja rachi tri' yawa', tuban treintiocho juna' tiyawaji. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ja c'a Jesús xutz'at ja yawa' in bien rotak chi congana tiempo cotz'ol tri' in quewa' xbij tre ri': —¿La nawajo' nattzuri? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Anin ni majun nak ta ninc'amo'el chipan ja ya' le' tok nursil can in tok ninbe nuyon junwi' nekaj chinwach nabey chipan, ne'xi rmal ja yawa'. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—Catyictaji, tac'ama'el ja rawarbal in catbini, ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","In jari' misma hora tzuri ja rachi, xuc'ol ja rwarbal in xumaj binem. Ja tok tzuri ja yawa' jari' pa jun xula'nbal k'ij. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Como xula'nbal k'ij rmalc'ari' tok quewa' bix tre cumal ja raj Israel ri': —Camic xula'nbal k'ij, xajan chi nawc'aj ja rawarbal, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—Pro ja rachi ja xintzursani arja' bin chwe chi nc'ol ja nwarbal in ninbini, ne'e ja rachi chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—¿Nak c'a chi achi'al ari' ja bin chawe chi queri' naban? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pro ja rachi arja' ma rotak ta rwach ja tzursan rxin como elnakel chic ja Jesús in c'uluto congana e q'uiy ja winak ec'o tri'. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","C'a co'l ari' tok xiltaji ja rachi rmal ja Jesús chipan ja templo. Quewa' xbij ja Jesús tre ri': —Camic xattzuri pro macatmacun chi ta, matzij xa c'oli xtipi chic chipan ja rac'aslemal ja más chi na lawulo', ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","C'ac'ari' be ja rachi cuq'uin ja raj Israel, xerbij chique chi Jesús ja tzursan rxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Como ja Jesús ec'oli winak nertzursaj pa tak xula'nbal k'ij rmalc'ari' tok ja raj Israel quemaj rcanoxic rij rwach nak nqueban tre chi nquicamsaj: —Taka'an nsamaji ja Jesús pa tak xula'nbal k'ij, neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pro ja Jesús xbij chique: —Ja Nata' arja' ni rmajonto wi' samaj camic in anin ni nmajon wi' samaj chakaja', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Rmalc'ari' ja tok más chi na quemaj rch'obic nak nqueban tre chi nquicamsaj como ca'i' chic ja ril ja Jesús nquibij. Jun, xuban ja pa xula'nbal k'ij ja ch'a'oj rij chi nbani, in jun chic, xucoj ja Dios como rtata' in jari' xa njunsbej ri' ruq'uin ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","C'ac'ari' ja Jesús xbij chique: —Ni katzij wi' ja xtinbij chewe ri', ja Ralc'walaxel arja' mta moda ja chaka ta ruyon xtuban kaj ja c'o rgana nuban, ni ja wi' ja rejemplo rxin ja Tatixel nuc'am. Cani' nuban ja Tatixel jari' nban anin chakaja' ja rin Alc'walaxel. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ja Tatixel como arja' nrajo' ja Ralc'walaxel chewi' tok nuc'ut chwach nojel rwach ja samaj ja nuban. In c'a c'o na jule' chic ja samaj ja maja'n tuc'ut chwach ja más chi na nimak tak samaj chwach ja cani' emajon rtz'atic camic ri'. Queri' c'a xtuban utzc'a chi ixix kas xtic'asc'o'i xtetz'at. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ja Tatixel neruyic camnaki' in nuya' c'ac'a c'aslemal chique in queri' c'a nuban ja Ralc'walaxel chakaja', arja' nuya' c'ac'a c'aslemal chique ja winak xa nak ta chi winakil ja c'o rgana nuya' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ja Tatixel ma arja' ta xtik'eto tzij chiquij ja winak como pa ruk'a' ja Ralc'walaxel rjachon wi' chi ja' Ralc'walaxel xtik'eto tzij chiquij ja winak canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Queri' rbanon ja Tatixel utzc'a chi xtiya' na ruk'ij ja Ralc'walaxel cumal canojelal ja winak ja cani' nba̱n arja' tre ja Tatixel. Ja wi mataya' ruk'ij ja Ralc'walaxel jari' mataya' ruk'ij ja Tatixel chakaja' como ja Tatixel arja' takyonto rxin ja Ralc'walaxel. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Bien tec'waxaj ja xtinbij chewe ri', ja wi c'o jun winak nuya' rxquin tre ja ntzobal in wi yukul ruc'u'x ruq'uin ja Tatixel ja takyonpi wxin jari' rc'an chic ja utzlaj c'aslemal ja ni mta wi' q'uisic trij in matitakel chipan ja nimlaj rpokonal, arja' k'axnakpi chic chipan ja camíc, jari' rwilon chic ja utzlaj c'aslemal. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Bien tec'waxaj ja xtinbij chewe ri', c'o jun tiempo nnakajinto, jari' tiempo ni chwach chic okc'o wi' ri' in chipan ari' tiempo ja winak ja recamnak chwach ja Dios eje'e' nquic'axaj na rukul ja Ralc'wal Dios. Ja nec'axani ja rukul eje'e' nyataj chique ja utzlaj c'aslemal. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Queri' rbanic como ja Tatixel Yo'l c'aslemal in rya'on tre ja Ralc'walaxel chi arja' Yo'l c'aslemal chakaja' ");
INSERT INTO tzjNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","in rjachon pa ruk'a' chi arja' xtik'eto tzij chiquij ja winak. Queri' rbanon tre como arja' ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Maxta junwi' tec'waxaj ja c'a xinbij kaj chewe ri' como nerila' na jun k'ij chi canojelal ja remukun pa tak comsanto nquic'axaj na rukul ja Ralc'walaxel ");
INSERT INTO tzjNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","in tok xtiquic'axaj ja rukul nec'astaji canojelal rmal. Ja re banol utzil eje'e' nec'astaj chipan ja utzlaj c'aslemal ja ni mta wi' q'uisic trij, ja c'a re banol itzelal eje'e' nec'astaji chakaja' pro neta̱kel chipan ja nimlaj rpokonal. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Anin mta moda ja xta nna'oj anin xtincoj kaj ta nuyon, ja tzij ja nbix chwe rmal ja Tatixel jari' nk'etbej tzij chiquij ja winak. Anin ni rubey wi' ja k'etoj tzij nban como ma nvoluntad ta anin nban kaj nuyon pro rvoluntad ja Tatixel ja takyonpi wxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ja wixta xa nuyon anin ninyo' testigo'il chewach tre nak inocnak wi' c'o ta c'a moda ari' xtebij ta chwe chi ma katzij ta ja nbij chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pro c'o chi na jun ja rocnak testigo chwij in bien wotak chi ni katzij wi' ja testigo'il nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ixix xetak rc'axaxic tre ja Juan in arja' xoc testigo chwij chi ja Dios takyonpi wxin in ni katzij wi' ja xbij chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pro anin ma rjawaxic ta chwe chi c'o ta jun winak xtoc ta testigo chwij xarwari' nnataj chewe ja testigo'il xuya' ja Juan chwij utzc'a chi ixix newil ja totajem xin Dios rmal. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ja Juan arja' xoqui cani' jun k'ak' pro jun k'ak' tzijili ja congana ruch'a'. Ja c'a rixix xixq'ueje' conforme chi rc'axaxic ja xbij ja Juan chewe in xixquicot rmal pro xa jurata, xa xoc'o ec'u'x rmal chi rc'axaxic. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pro c'o chi na jun nyo' testigo'il chwij in ja testigo'il nuya' arja' más chi na nim ruk'ij chwach ja xuya' ja Juan. Ja samaj ja nmajon rbanic jari' ocnak testigo'il chwij, jari' samaj yatajnak chwe rmal ja Tatixel chi nban in jari' samaj nc'utuwi chi ja Tatixel intakyonto. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","In jun chic, ja mismo Tatixel ja takyonto wxin arja' ni rya'onto wi' testigo'il chwij chakaja'. Pro ixix ni majutij eya'on ta ewxquin tre ja nbix chewe rmal ja Dios nixtac'a eya'on ta caso tre ja tok arja' xk'alasaj je'e ri' chewach. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","In chakaja' ma eya'on ta lugar tre ja rtzobal chi ocnak ta pa tak ewanma. Ni k'alaj wi' chi ma eya'on ta lugar tre como arja' takyonto wxin in ixix ni majun egana xtiyuke' ta ec'u'x wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ja rixix congana nesiq'uij ja rtzobal Dios: —Chipan ja rtzobal Dios nkawil wi' ja utzlaj c'aslemal ja ni mta wi' q'uisic trij, nixche' kaj. Pro ja rtzobal Dios, anin ja ninrtzijoj, ja rtzobal Dios jari' nk'alasani nak inocnak wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pro ja rixix ni majun egana xtiyuke' ta ec'u'x wq'uin, xa nech'a' ja utzlaj c'aslemal ja ntzujuj chewe ja ni mta wi' q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ma ja ta nwajo' ja xtiya' ta nuk'ij cumal winak ");
INSERT INTO tzjNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","pro xarwari' bien wotak chi mta ja rajoben ri'il xin Dios pa tak ewanma. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ja nata' Dios arja' intakyonto pro ixix ni majun egana xtiyuke' ta ec'u'x wq'uin. Pro ja tok c'o jun achi xa ruyon nuban mandar ri' chi nbe ewq'uin jari' nyuke' ec'u'x ruq'uin ixix. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ja newajo' ixix xa neya' ek'ij chibil tak ewi' pro ni majun nbij ec'u'x tre ja xteban ta ja rutzil xin Dios ja ni xarwari' jun chi Dios. Ja tok xa queri' neban jari' congana c'ayew ja xtiyuke' ta ec'u'x wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Pro maxta tech'ob chi anin xquinyo' parte chewij chwach ja Tatixel. Ja nyo' parte chewij jari' ja Moisés in ixix nebij chi congana yukul ec'u'x ruq'uin ja Moisés. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ja wixta katzij chi xenimaj ja Moisés xinenimaj ta c'a anin ari' chakaja' como ja rtz'iban can ja Moisés, chwe anin rtz'iban can wi' chi bien nk'alajini nak inocnak wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pro wi matenimaj ja rtz'iban can ja Moisés ¿nak moda c'ari' xtenimaj ja ntzobal anin? Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","C'ac'ari' be chic ja Jesús chajuparaj mar xin Galilea ja c'o chic jun rubi' mar xin Tiberias ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Congana e q'uiy ja winak xetre' trij rmal ja nimak tak milagro xuban chiquewach como ec'oli ja yawa'i' xertzursaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jote' chwach jun jayu' in xuwil jun lugar ja bar tz'abe' wi' e rachbil ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Xa nnakajinto ja nmak'ij pascua ja nc'u̱l cumal ja raj Israel. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ja Jesús tok xutz'at chi congana winak xe'ekaj ruq'uin xbij tre ja Felipe: —¿Bar nekalok'o' wi' queway ja winak le'? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pro jawa' tzij xbij xa nc'ambajbej rxin ja Felipe como ja Jesús arja' bien rotak nak xtuban ja nertzukbej ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ja c'a Felipe xbij tre: —Ja wixta c'o ca'i' ciento quetzal caxlanway maqueruban ja winak le' xtiquetij ta tak tz'it chiquijujunal, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","C'o jun chique ja discípulo rbina'an Andrés, arja' rch'alal ja Simón Pedro in quewa' xbij tre ja Jesús ri': ");
INSERT INTO tzjNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—C'o jun tala' wawe' ri', arja' c'o jo'o' rkan caxlanway ruq'uin cebada ocnak in e ca'i' tak cakan ch'u' pro ¿la neruban ta c'ala' winak le'? congana e q'uiy, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ja c'a Jesús xbij chique ja rdiscípulo: —Que'etz'uba' canojel ja winak le', ne' chique. Como chipan ari' lugar ja rec'o wi' c'o buen tak k'ayis netz'abe' chipan. In canojel ja winak xekaj chi tz'ubulem, ec'o la jo'o' mil ja xa queyon achi'i'. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ja c'a Jesús xuc'am ja caxlanway, xmaltioxij tre ja Dios in xujach chique ja discípulo. Ja c'a discípulo quemaj rjachic chique canojel ja winak ja retz'ubuli in queri' queban chique ja ch'u' chakaja'. Ja winak quetij jani' ja kas c'o quigana quetij. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ja tok tzuri wa'im cumal xenoji chi utz in quewa' xbij ja Jesús chique ja discípulo ri': —Temolo' ruchi' nojelal ja totaji, matinwajo' xtitz'ilox ta, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ja c'a discípulo quemaj rmolic ruchi' nojelal. Ja c'a tok moltaj cumal cablajuj chacach xuban pro ni noji chi cablajuj. Jari' totaji tre ja jo'o' rkan caxlanway ja ma xecowin ta ja winak trij chi rtijic. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ja winak tok quetz'at ja milagro ja xuban ja Jesús chiquewach quewa' quibij ri': —Jala' jun achi le' ni katzij wi' chi arja' ja profeta xin Dios ja tz'ibtal can chi npi na, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ja c'a Jesús bien ch'obtaj rmal chi ncajo' nqueban puersa tre chi arja' noc rey pa quewi' rmalc'ari' xelel chipan ja lugar, jote' chic jutij chwach jun jayu' ruyon in xuwil jun lugar ja bar q'ueje' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ja c'a tok xuban hora tok kas nmalal chic xexule'e ja discípulo chi' mar. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ja c'a tok xe'ekaji xe'oquel chipan jun lancha, xebe pa Capernaum ja c'o chajuparaj chic mar. Ocnak chic ak'a' pro maja'n tekaji ja Jesús cuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pro chaka jalal tok jaktajto jun nimlaj ik' chiquij, congana nimak tak baloj chic chipan ja mar. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","C'o la jo'o' waki' kilómetro quiya'on can chic ja chi' mar ja tok chaka jalal quetz'at ja Jesús, arja' rmajon binem parwi' ya' in xekaj chinakaj ja lancha ja rec'o chipan. Ja c'a reje'e' congana quixbej qui' rmal. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pro ja Jesús xbij chique: —Ma texbej ta ewi', xwa'n anin, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Congana xequicoti, quecojel chic ja Jesús cuq'uin pa lancha in c'a ja' quena' ec'o chic chipan ja lugar ja bar nebe wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ja c'a chi rcab k'ij ec'o can ja winak chi' mar. Quetz'at chi ma xoquel ta ja Jesús pa lancha cuq'uin ja rdiscípulo tok xebe pa Capernaum, xa queyon xebe in mchita jun ja lancha, xa ni xarwari' jun. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pro c'o jule' ja lancha xelel pa Tiberias, be k'ax chic chajuparaj chic mar. Ja lugar ja bar xekaj wi' chinakaj ja mismo lugar ja bar q'ueje' wi' ja Jesús tokori' tok xmaltioxij tre ja Dios in xerutzuk ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ja c'a winak ja rec'o can chi' mar tok quetz'at chi mchita ja Jesús in nixtac'a rdiscípulo chi ta chakaja' c'ac'ari' xe'oquel pa tak lancha, xebe pa Capernaum chi rcanoxic ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ja c'a tok xe'ekaji ja chajuparaj chic mar pa Capernaum tri' quewil wi' in quewa' quibij tre ri': —Rabí ¿nak hora xaturkaji ja wawe'? xeche' tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ja c'a Jesús xbij chique: —Ixix ninecanoj pro ma rmal ta chi ch'obtaj emwal nak ja kas mero rc'amonto ja jule' milagro ja xinban chewach. Ninecanoj pro xa rmal chi xixnutzuk tre ja caxlanway in xixnoji chi utz. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ixix congana samaj neban chi rcanoxic ja reway pro jule' way ja xa noc'owi pro ma xar tawa' samaj teban. Pro ja neban, congana ta nixsamaji chi rcanoxic ja way ja ni mta wi' oc'owem nuban, jule' way ja rc'amonto ja utzlaj c'aslemal ja mta q'uisic trij. Ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak arja' nsipan chewe ja way ja c'a xinbij chewe ri'. Como Dios ja Tatixel arja' bien rk'alasan chic chi arja' takyonto rxin ja Ralc'walaxel, xeche'xi ja winak rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","—¿Nak c'a chi samajil nkaban utzc'a chi samaj xin Dios ja nkaban? xeche' chic tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Tiyuke' ec'u'x ruq'uin ja Ralc'walaxel ja takonto rmal ja Dios in tok nyuke' ec'u'x ruq'uin ja c'ari' samaj xin Dios, xeche'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","In quibij chic tre: —¿Nak c'a chi milagro'il naban ja nac'utbej chikawach chi ni katzij wi' chi Dios attakyonto? ¿Nak c'a nac'ut chikawach utzc'a chi nkatz'at in rmalari' xcatkanimaj? ¿Nak c'a chi samajil naban atat chewi'? ");
INSERT INTO tzjNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ja kati't kamama' eje'e' tok xeq'ueje' chipan ja lugar chakijlaj ulew ojer c'o jule' maná quetij ja takto chicaj cani' tz'ibtal can quewari': —Way xin chicaj xuya' chique chi nquetij, queri' nbij, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Bix chic chique rmal ja Jesús: —Ni katzij wi' ja xtinbij chic chewe ri', ja way ja pi chicaj ma ja ta Moisés yowi, ja nata' Dios arja' yowi in ja way xin chila' chicaj ja ni katzij wi' chi way ni ja wi' nata' Dios nyowi chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Queri' nbij chewe como ja way ja nuya' ja Dios jari' ja penak chila' chicaj jari' ja nuya' utzlaj c'aslemal chique ja winak pro canojelal, xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Kajaw ¿nak tre mataya' chake la' ja way ja nabij le' pro ni ta ja wi' naya' chake nojel tak k'ij? xeche' tre. Ja c'a Jesús xbij chic jutij chique: ");
INSERT INTO tzjNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","—Anin c'ari' ja rin way, anin ninyowi ja utzlaj c'aslemal ja mta q'uisic trij. Ja winak ja nyuke' quec'u'x wq'uin jari' ni mchita wi' wa'al xtiquetij ta nixtac'a chakichi' ta chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pro cani' nbin chic chewe chi ixix masqui inetz'aton chic pro ni matiyuke' wi' ec'u'x wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Canojel ja winak ja neyataj chwe rmal ja Tatixel eje'e' ne'urkaj wq'uin in tok ne'urkaji mta ari' ja maquita nenuc'ul canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Anin xinkajto chila' chicaj, inpenak chi rbanic ja rvoluntad ja rintakyonto, ma nvoluntad ta anin nunbana' kaj ta nuyon. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ja Tatixel ja takyonpi wxin quewa' rvoluntad ri', chi canojel ja reya'on chwe rmal ni majun chique xtintz'ila' ta in tok xterila' ja q'uisbal tiempo nenuyic canojelal chipan ja camíc. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ja Tatixel ja takyonpi wxin quewa' rvoluntad ri', chi canojel ja winak ja ncotakij rwach ja Ralc'walaxel in nyuke' quec'u'x ruq'uin eje'e' nyataj chique ja utzlaj c'aslemal ja mta q'uisic trij. Ja c'a tok xterila' ja q'uisbal tiempo anin ninyico quixin chipan ja camíc. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ja c'a raj Israel eje'e' quemaj rtzijoxic ja Jesús como mta quigana ruq'uin ja xbij chique chi arja' ja way kajnakto chila' chicaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—Jala' jun achi le' xwa'n Jesús ja rc'ajol José, kotak wa'an quewach rtata' rute' ala'. ¿Nak tre tok nbij chi kajnakto chila' chicaj? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ja c'a Jesús xbij chique: —Ma quinetzijoj ta. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Canojel ja winak ja ne'urkaj wq'uin chi nyuke' quec'u'x wq'uin ni majun chique ja xta ruyon nurkaji, ni rjawaxic wi' chi nec'a̱mto rmal ja Tatixel ja takyonpi wxin. Pro ja ne'urkaj wq'uin, ja tok xterila' ja q'uisbal tiempo anin ninyico quixin chipan ja camíc canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Cani' tz'ibtal can chipan ja libro quixin profeta quewa' nbij ri': —Nerila' na jun tiempo chi canojelal netijox na rmal ja Dios, ne'e. Rmalc'ari' nbij chewe chi canojel ja winak ja quiya'on quixquin tre ja Tatixel in wi cotakin ja c'utun chiquewach rmal eje'e' ri' ja ne'urkaj wq'uin chi nyuke' quec'u'x wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pro ma ja ta nbij chewe chi ec'oli winak ja retz'atyon rwach ja Tatixel. C'o nac'a jun tz'atyon rwach pro xa ni xarwari' jun jari' ja Ralc'walaxel ja mero in Dios penak wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ni katzij wi' ja xtinbij chic chewe ri', ja winak ja c'o yukulbal quec'u'x wq'uin eje'e' cuc'an chic ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Anin ja rin way, anin ninyowi ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ja rewati't emama' ojer eje'e' tok xeq'ueje' chipan ja lugar chakijlaj ulew masqui quetij ja maná pro ja maná ma xeruto' ta chipan ja camíc. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pro ja way ja nmajon rbixic anin chewe camic ri' jari' ja kajnakto chila' chicaj utzc'a chi nak xtitijo rxin jari' maticami. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ja way ja nyowi c'ac'a c'aslemal, ja way ja kajnakto chila' chicaj, anin c'ari'. Jawa' way ja c'a xinbij kaj chewe ri', xa nak ta xtitijo rxin jari' nc'ase'e pro ni chijutij. C'oli way ja xtinya' chique ja winak wawe' chwach'ulew utzc'a chi c'o jun c'ac'a c'aslemal nyataj chique. Ja way xtinya' jari' ncuerpo anin. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ja c'a raj Israel eje'e' quemaj chic tzij chibil tak qui', junwi' nquibij jule' in junwi' chi na nquibij jule': —¿Nak rbanic c'ala' nbij ja jun achi le' chi nuya' ja rcuerpo chake chi nkatij? neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ja c'a Jesús xbij chic chique: —Ni katzij wi' ja xtinbij chic chewe ri', ja wi matetij ja cuerpo rxin ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak in wi matetij ja rquiq'uel chakaja' jari' ma ewc'an ta ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pro xa nak ta netijowi ja ncuerpo rachbil ja nquiq'uel jari' cuc'an chic ja utzlaj c'aslemal ja mta q'uisic trij in tok xterila' ja q'uisbal tiempo anin ninyico quixin chipan ja camíc. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Como ja ncuerpo anin jari' ja mero way in ja nquiq'uel jari' ja mero camsbal chakichi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ja netijowi ja ncuerpo rachbil ja nquiq'uel eje'e' neq'ueje' pa wanma anin in anin chakaja' ninq'ueje' pa tak canma eje'e'. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ja c'aslic Tatixel arja' inrtakonto in rmal arja' tok nij inc'as wi' in queri' c'a chique ja winak ja xquetijowi ja ncuerpo rachbil nquiq'uel eje'e' nec'ase' na chijutij mwal anin. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ja way ja nmajon rbixic chewe camic ri' jari' ja kajnakto chila' chicaj, ma junan ta ruq'uin ja maná ja tij cumal ewati't emama' ojer pro ma xeruto' ta chipan ja camíc. Jawa' way ja nmajon rbixic chewe ri' xa nak ta netijowi nec'ase' na pro ni chijutij. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jawa' tijonem ri' xuya' ja Jesús pa Capernaum chipan ja jay xin molbal ri'il quixin ja raj Israel. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ja c'a rdiscípulo ja Jesús eje'e' tok quic'axaj ja xbij e q'uiy chique quewa' quibij ri': —Congana taka'an c'ayew ja nbij le' ¿nak ta wi' xtel ruc'u'x chi rc'axaxic? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pro ja Jesús arja' bien rotak chi eje'e' quimajon rch'a'ic ja xbij chique in xbij chic chique: —¿La pokon xena' ja tijonem ja c'a xinya' chewe ri'? ");
INSERT INTO tzjNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pro ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak wi nerila' na jun k'ij tok xtetz'at chi arja' njote' chila' chicaj ja bar c'o wi' nabey ¿nak c'a nech'ob chic ari' trij? ");
INSERT INTO tzjNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ja rEspíritu arja' nyowi ja utzlaj c'aslemal ja mta q'uisic trij, ma ja ta ja cuerpo xin jun winak nyowi. Ja tijonem xinya' chewe jari' xin ewanma, jun tijonem ja nuya' chewe ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pro ec'oli chewe ja mta yukulbal quec'u'x wq'uin. Queri' xbij ja Jesús como arja' ni rotakinto wi' echinatak ja matiyuke' quec'u'x ruq'uin in ni rotakinto wi' chakaja' nak xtijacho rxin pa quek'a' ja winak ja netzelan rxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","In xbij chic chique: —Rmalari' ja tok xinbij chewe chi mta moda xturkaji jun winak wq'uin chi nyuke' ruc'u'x wq'uin ja wi matiyataj tre rmal ja Tatixel chi nyuke' ruc'u'x wq'uin. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ja c'a rdiscípulo ja Jesús tok quic'axaj ja tijonem xuya' e q'uiy chique xemeloj can chiquij rmal, ma xetre' chi ta trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ja c'a Jesús xbij chic chique ja cablajuj apóstol: —Ja c'a rixix ¿nak neban camic, la nixmeloj ixix chakaja'? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ja c'a Simón Pedro quewa' xbij tre ri': —Wajaw ¿bar c'a nokbe chi wi'? como xa ayon atat natyowi ja tijonem ja rc'amonto ja utzlaj c'aslemal ja mta q'uisic trij ");
INSERT INTO tzjNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","como ja rajoj yukul kac'u'x awq'uin in kotak chi atat ja rat Cristo, kotak chi at Ralc'wal ja c'aslic Dios, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ja c'a Jesús xbij chic chique: —Ix cablajuj ja rixncha'on pro c'o jun chewe ja xa uc'an rmal ja diablo, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jawa' tzij xbij ri', tre ja Judas Iscariote tzijon wi', rc'ajol jun achi rbina'an Simón como ja Judas arja' njachowi ja Jesús pa quek'a' ja winak ja netzelan rxin, arja' jun chique ja cablajuj apóstol. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","C'ac'ari' be ja Jesús chipan jule' chic lugar ja c'o chipan ja departamento Galilea, matirajo' nbe pa tak lugar ja c'o chipan ja departamento Judea como tri' ec'o wi' jule' aj Israel quimajon rch'obic nak nqueban tre chi nquicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jari' tiempo c'o jun nmak'ij nnakajinto quixin ja raj Israel, ja rubi' ja nmak'ij xin tabernáculo ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Rmalc'ari' tok quewa' bix tre ja Jesús cumal ja rch'alal ri': —¿Nak tre tok macatel wawe' in natbe pa Judea utzc'a chi ja radiscípulo ja rec'o chila' eje'e' necowini nquetz'at nojel ja ramajon rbanic wawe'? ");
INSERT INTO tzjNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Como jun achi wi c'o rgana chi bien notakixi nojel ja samaj nuban mta moda xta pan awatali nsamaji. Como atat amajon rbanic wawe' nojel awa' wari' ¿nak c'a tre tok matac'ut chiquewach ja jule' chic winak chakaja' pro ni chiquewach canojelal? ");
INSERT INTO tzjNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Queri' bix tre cumal ja rch'alal como nixtac'a eje'e' ta yukul ta quec'u'x ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ja c'a Jesús xbij chique: —Ja ranin maja'n terila' ja ntiempo chi ninbe pro ja chewe ixix nixcowini nixbe xa nak ta chi tiempo'al. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Como ja chewe ixix, ja winak mta moda itzel ta xquixquetz'at pro ma queri' ta chwe anin, xa itzel ninquetz'at rmal ja nmajon rk'alasaxic chiquewach ja ritzelal nqueban. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pro ja rixix jix, jebana' ja nmak'ij, ja ranin c'a ninbe na como maja'n terila' ja ntiempo. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Queri' xbij chique in q'ueje' can pa Galilea. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ja c'a tok ebenak chic ja rch'alal ja pa nmak'ij c'ac'ari' be chic arja' pro xa ruyon be, xa pan awatali xekaji. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pro ja c'a raj Israel eje'e' quimajon rcanoxic ja Jesús chipan ja nmak'ij ja ntajini nbani: —¿Bar c'a c'o wi'? neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","E q'uiy ja winak chipan ja nmak'ij quimajon tzij tre ja Jesús pro kas pan ekal netzijoni. Ec'oli chique quewa' nquibij ri': —Congana utzlaj achi ja Jesús, neche'e, pro junwi' chi na nquibij jule' chic chique: —Xa neruyoj ja winak, xa neruban engañar, neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pro como ni majun chique ja maquita nxbej ri' chiquewach ja cach tak aj Israel ja nimak quek'ij chewi' tok kas pan ekal netzijoni. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kas c'a nc'ajarnak ja nmak'ij, c'o la quiji' k'ij majtajnak tok be ja Jesús chipan ja nimlaj templo xin Dios in xumaj quitijoxic ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ja raj Israel congana c'asc'o'i quic'axaj ja tijonem xuya': —¿Nak tre c'ala' ja rachi le' congana taka'an rotak pro mta wa'an rtijon wi' ri'? neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ja c'a Jesús xbij chique: —Ja tijonem nya' anin ma anin ta inwinakarsyon, ja winakarsyon jari' ja Tatixel ja takyonpi wxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ja winak ja c'o quigana nqueban ja rvoluntad Dios eje'e' bien ncotakij na ja wi Dios winakarsyon ja tijonem nya' owi chaka ngana anin nwinakarsan nojoj nuyon. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ja wi c'o jun achi nuya' jun tijonem in wi xa arja' winakarsyon nojoj ruyon jari' bien k'alaj chi nrajo' nya̱' ruk'ij cumal ja winak pro wi c'o jun nrajo' chi nya̱' ruk'ij ja takyonpi rxin jari' k'alaj chi ni katzij wi' ja nbij in ni majun engaño nuban. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ja rixix ¿la ma yatajnak ta c'a chewe ja ley xin Dios rmal ja Moisés chi nenimaj? pro ja ley ni majun chewe rmajon ta rnimaxic ja nbij. Queri' nbij chewe como nixtajini necanoj wij nwach nak neban chwe chi ncamsaxic. Queri' xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Atat xa jun demonio atch'ujarsyon ¿nak bin chawe chi ec'oli necamsan awxin? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ja c'a Jesús xbij chic chique: —Ja xinban jutij chipan jun xula'nbal k'ij, ixix kas junwi' xetz'at. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pro c'o c'a ebanon je'e ixix chakaja' masqui pa tak xula'nbal k'ij pro e'ebanon circuncidar ja winak. Ne'eban circuncidar como ja Moisés tz'ibyon can chi queri' neban chique in ja re nabey tak ewati't emama' cuq'uin eje'e' ja kas winakarsaxto wi' ja circuncisión, ma ruq'uin ta ja Moisés. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ja c'a rixix c'oli ebanon je'e masqui pa tak xula'nbal k'ij pro e'ebanon circuncidar ja winak como queri' nrajo' ja ley xin Moisés chi neban. Ja wi queri' ebanon ixix ¿nak c'a tre tok pit ewayewal chwij tok xintzursaj jun achi pa jun xula'nbal k'ij? ");
INSERT INTO tzjNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Maxta tebila' ril jun winak ja tok ma ewotak ta bien ja wi ril ja xuban owi ma ril ta. Bien tech'obo' rij rwach nabey ja wi katzij chi ril ja xuban. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ec'o c'a jule' chique ja winak ja raj Jerusalén tok quic'axaj quewa' quibij ri': —¿La ma ja ta c'ala' ja rachi le' ja majtajnak rcanoxic rij rwach chi ncamsaxi? ");
INSERT INTO tzjNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pro ja camic ni taka'an chiquewach ja winak ntzijon wi' in ni majun nak ta nk'ilo ta rxin chi matitzijoni. Ja k'etol tak tzij ¿la maxta c'a quiniman chic eje'e' chi arja' ja Cristo? ");
INSERT INTO tzjNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pro jala' ja rachi le' kotak ja bar penak wi' pro ja Cristo ja tok xtipeti jari' majun otakyon bar xtipi wi'. Queri' quibij. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ja c'a Jesús rmajon quitijoxic ja winak chipan ja nimlaj templo xin Dios in quewa' xbij chique ri': —Ixix ewotak nwach in ewotak chakaja' ja bar inpenak wi'. Pro c'o jun ja rintakyonto, arja' ni katzij wi' chi c'aslic Dios pro jari' ma ewotak ta rwach. Ja ranin ma chaka ta xinban mandar wi' nuyon chi xinpeti. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pro ja ranin wotak rwach como ruq'uin arja' inpenak wi' in arja' takyonto wxin, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Rmalc'ari' ja xbij chique xa chewi' ja tok laj quechap chi nquecoj preso pro majun nak ta chique chapo ta rxin como maja'n terila' ja hora rxin chi nchapi. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pro e q'uiy ja winak yuke' quec'u'x ruq'uin, quewa' quibij ri': —¿La ma Cristo ta c'awa' wari', la c'o chi ta na c'a jun ja maja'n tipeti ja más chi na nimak tak milagro nuban chwach awa' wari'? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ja c'a fariseo eje'e' quic'axaj chi ja winak kas pan ekal quimajon rbixic chi ja Jesús arja' ja Cristo. Rmalc'ari' tok quec'am qui' cuq'uin ja jefe quixin sacerdote, xequetak jule' soldado chi nquechap ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ja c'a Jesús arja' tzijon más cuq'uin ja winak, quewa' xbij chic chique ri': —Anin xa jun ti tiempo chic ninq'ueje' checojol como ninmeloj ruq'uin ja rintakyonto. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ninecanoj chi na pro maquinewil chic, ja bar xquineq'ueje' chi wi' maquixcowin ixix nixekaj chic tri', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ja c'a raj Israel eje'e' quemaj chic tzij tre ja c'a bix chique rmal ja Jesús: —¿Bar c'a xtibe wi' ja rachi le' in makocowini nkawil chic? ¿La nbe cuq'uin ja kach tak aj Israel ja rec'o pa tak tinamit quixin ja winak ja ma e aj Israel ta, la tri' nbe wi' chi ne'ertijoj ja ma e aj Israel ta? ");
INSERT INTO tzjNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nak tibij c'ari' ja xbij chake chi nkacanoj pro matikawil in chakaja' ja bar c'o wi' arja' makocowin ajoj nokekaj chic tri'? queri' quibij. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ja tok xerila' ja q'uisbal k'ij rxin ja nmak'ij jari' k'ij ja más nim ruk'ij, pe'i ja Jesús chiquewach ja winak in quewa' xbij chique ri': —Ja wi c'o jun chewe nuna' chakichi' tipeti wq'uin camic, turtija' ja ya' ja c'o wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Cani' nbij ja rtzobal Dios, ja winak ja nyuke' quec'u'x wq'uin c'oli rkan tak ya' ja congana xtipulinto pa tak canma pro jule' ya' ja rc'amonto ja utzlaj c'aslemal ja mta q'uisic trij. Queri' nbij, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Queri' xbij chique como jari' nnatbej rxin ja rEspíritu Santo ja nyataj na chique ja winak ja yukul quec'u'x ruq'uin ja Jesús. Pro ja rEspíritu Santo maja'n titakto tri' como ja Jesús maja'n tibe ruq'uin ja Tatixel pa gloria. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ja winak tok quic'axaj ja xbij ja Jesús ec'oli chique quibij: —Jala' jun achi le' ni katzij wi' chi jala' ja profeta xin Dios ja bitajnak can chi npi na, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jule' chic chique quibij: —Jala' ja Cristo ja Rey ja tzujunto ojer rmal ja Dios, xeche'e. Pro jule' chic chique quewa' quibij ri': —¿La pa Galilea la'an npi wi' ja Cristo chewi'? ");
INSERT INTO tzjNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿La ma tz'ibtal can ta c'a chipan ja rtzobal Dios chi pa Belén npi wi' ja Cristo como ja Belén jari' rtinamit ja rojer rey David in ja Cristo arja' riy rumam can ja David? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Queri' queban ja winak, quemaj rch'a'ic chibil tak qui' rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ec'oli chique cajo' ta quechap ja Jesús quecoj ta preso pro majun nak ta chique chapo ta rxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ja rachi'i' ja xetaki chi nequichapa' ja Jesús eje'e' xemelojto cuq'uin ja sacerdote ja nimak quek'ij in cuq'uin ja fariseo. Ja c'a tok xe'ekaji quewa' bix chique ri': —¿Nak c'a tre tok ma xechappi ta ja rachi? xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Cani' ntzijoni ja rachi le' ni majun achi ja queri' ta tzijonnak cani' arja', xeche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ja c'a fariseo quibij chic chique: —¿La maxta c'a xixban engañar ixix rmal ja rachi chakaja'? ");
INSERT INTO tzjNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ma ec'o ta wa'an ja k'etol tak tzij ja yukul ta quec'u'x ruq'uin in nixtac'a jun ta chake ajoj ja rok fariseo chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jala' jule' winak le' ja yukul quec'u'x ruq'uin eje'e' xa ma cotak ta ja ley xin Dios, mta quisamaj, majun ne'oc wi' tre ja Dios, xeche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pro c'o c'a jun chique ja fariseo rbina'an Nicodemo, jari' ja xuban jutij be ruq'uin ja Jesús chak'a'. Ja c'a Nicodemo arja' xbij chique ja rachbil: ");
INSERT INTO tzjNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿La queri' ta c'a nrajo' ja ley ja yatajnak chake rmal ja Dios nech'ob ixix chi nk'e̱t tzij trij jun achi pro matiya' lugar tre chi ntzijoni in matotakixi nabey wi c'o ril owi mta? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ja c'a reje'e' quemaj ryok'ic ja Nicodemo in quewa' quibij tre ri': —¿La maxta c'a at aj Galilea atat chakaja'? Bien tatz'ata' chipan ja rtzobal Dios chi ni mta wi' jun profeta xtiwinakar ta pa Galilea, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","C'ac'ari' quipaxijel qui', xebe chi tak cochoch canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ja c'a Jesús arja' be parwi' ja ti jayu' rbina'an Rjayu'al Olivo. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ja c'a chi rcab k'ij be chic jutij chanim chipan ja nimlaj templo pa Jerusalén. Ja c'a winak xebe ruq'uin. Arja' tz'abe'e in xumaj quitijoxic. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ja maestro ja netijon quixin ja winak tre ja ley xin Dios e cachbil ja fariseo eje'e' c'o jun ixok quic'amonto, xiltaji macunnak ruq'uin jun achi ja ma rchajil ta. Xequiya'a' ja rixok chiquicojol ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","C'ac'ari' quibij tre ja Jesús: —Maestro, jawa' rixok ri' xiltaji macun ruq'uin jun achi ja ma rchajil ta. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","In bin can chake rmal ja Moisés chipan ja ley xin Dios chi necamsax tza'n abaj ja rixoki' ja re quitakawari'. Ja c'a ratat ¿nak nabij tre? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ja quic'axaj tre xa nquic'ambajbej rxin, nquicanoj nak nquichapbej rxin. Ja c'a Jesús ch'uque' kaj chwi rkan, xumaj tz'ibanem pa tok'ulew, rwiruk'a' xucoj. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pro eje'e' como xajutij quimajon rc'axaxic tre pe'e nojoj in quewa' xbij chique ri': —Ja ni majun ril rumac chewe jari' tiyowi ja nabey abaj tre ja rixok le', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ja tok bitaj queri' rmal ch'uque' kaj chic jutij chwi rkan in xumaj chic jutij tz'ibanem pa tok'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ja tok quic'axaj ja bix chique rmal ja Jesús quena' kaj chi c'o quil quemac eje'e' chakaja' rmalc'ari' pa jujunal pa jujunal xebe. Ja c'a rija' eje'e' ri' ja kas xe'elel nabey in tok q'uiswani xebe canojelal. Xa ruyon chic ja Jesús q'ueje' can, ja c'a rixok arja' pe'e can chwach. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ja c'a Jesús tok pe'e nojoj chic jutij tok xerutz'at ja winak ba la xe'oc wi', ti ruyon chic ja rixok c'o can in xbij tre: —¿Bar c'a xe'oc wi' ja winak ja nebini ja rawil? ¿La mta jun chique xuk'et ta tzij chawij xatruq'uiak ta tza'n abaj? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Ni majun, ne'e ja rixok. —In nixtac'a anin ta xtink'et ta tzij chawij. Camic jat xarwari' macatmacun chi ta, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","C'ac'ari' tzijon chic jutij ja Jesús cuq'uin ja winak in xbij chique: —Anin ja rin luz, nenuya' pa sakil canojelal ja winak ja rec'o chwach'ulew. Canojel ja winak ja nyuke' quec'u'x wq'uin eje'e' maqueq'ueje' chipan ja k'ekumal, nyataj chique ja sakil pro jun sakil ja nuya' chique ja utzlaj c'aslemal ja mta q'uisic trij. Queri' xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pro ja fariseo eje'e' quech'a' tre ja xbij: —Atat como xa naya' kaj testigo'il chawij ayon chewi' tok matikanimaj ja nabij le', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—Masqui xa nuyon nya' kaj testigo'il chwij pro ni katzij wi' ja nbij como anin wotak nak rbanic ja bar inpenak wi' in tri' ninmeloj chi wi' chakaja'. Pro ja rixix ma ewotak ta ja bar inpenak wi' in bar xquinmeloj chi wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Xa ena'oj ixix necoj ja nek'etbej tzij chwij, ma xin Dios ta, pro ja chwe anin ni majun nak ta nk'et ta tzij trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pro wi c'oli ja k'etoj tzij nban jari' ni rubey wi' ja k'etoj tzij nban. Queri' nbij chewe como ma nuyon ta anin nink'etowi ja tzij, ok ca'i' ruq'uin ja Tatixel ja takyonto wxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ja chipan ja ley xin Dios ja c'ol ewq'uin c'oli tz'ibtal can chipan quewari', ja tok ec'o ca'i' achi'i' ja xa junan ja testigo'il nqueya' jari' seguro chi ni katzij wi' ja testigo'il nqueya', queri' tz'ibtal can. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Queri' c'a chwe anin chakaja', anin jun in testigo chwij nak ja rinocnak wi' in ja Tatixel ja takyonpi wxin arja' jun chakaja'. Queri' xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—¿Bar c'a c'o wari' ja ratata'? xeche' tre. —Ja rixix ni ma ch'obtajnak ta wi' emwal nak inocnak wi' in nixtac'a ja ta ja Nata' chakaja' ch'obtajnak ta emwal nak rbanic. Ja wixta ch'obtajnak emwal nak nbanic anin ch'obtajnak ta c'ari' emwal nak rbanic ja Nata' chakaja', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Queri' c'a rbanic ja jule' tzij xuban ja Jesús chipan ja nimlaj templo xin Dios ja tok arja' rmajon quitijoxic ja winak. Tri' pa'l wi' ja bar nqueya' can wi' ja qui'ofrenda ja winak pro ni majun nak ta chapo ta rxin como maja'n terila' ja hora chi nchapi. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Xumaj chic jutij tzij cuq'uin: —Anin ninmeloji ja bar inpenak wi'. Ja c'a rixix ninecanoj chi na pro maquinewil chic, chipan ja rewil emac nixcam wi'. Ja bar xquinbe chi wi' maquixcowin ixix nixekaj ta tri'. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ja c'a raj Israel eje'e' quemaj tzij chibil tak qui': —¿La ncamsaj kaj ri' ruyon xa chewi' tok makocowini nokekaji ja bar xtibe wi' arja'? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ja c'a Jesús xbij chic jutij chique: —Ixix xa ix xin wawe', ja c'a ranin in xin chila' chicaj, xa ix xin rwach'ulew pro ja chwe anin ma in queri' ta. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Rmalc'ari' xinbij chewe chi chipan ja rewil emac nixcam wi'. Ja rinocnak wi' anin nij in quirwari' ja cani' nbin chic chewe, ja c'a wi matenimaj chi queri' nbanic jari' ni nixcam wi' chipan ja rewil emac. Queri' xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Nak c'a ja ratat? xeche' tre. —Ja rinocnak wi' anin nij in quirwari' ja cani' nbinto chewe nabey. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","C'a c'o na ja rebanon ja maja'n tinch'a' chewe ja nixbanbex condenar. Pro ja takyonto wxin arja' ni katzij wi' nojel ja nbij in ja rbin arja' chwe jari' nmajon rbixic anin chique ja winak wawe' chwach'ulew, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pro ja xbij ja Jesús eje'e' matich'obtaj cumal chi tre ja Tatixel ntzijon wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","C'ac'ari' xbij chic jutij chique: —Ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak tok xtejotba' chwach jun cruz tokori' newotakij na nak inocnak wi' chi nij in quirwari' ja cani' nbinto chewe in newotakij na chakaja' chi nojel ja nmajon rbanic ma chaka ta nuyon kaj nban como nojel ja nmajon rbixic, ja Nata' arja' c'utyon chinwach. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ja takyonpi wxin arja' c'o wq'uin camic, ja Nata' ni ma inrya'on can ta wi'. Queri' rbanon chwe como anin ni nmajon wi' rbanic ja nrajo' chwe chi nban, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ja tok xbij ja tzij ri' e q'uiy chique ja winak yuke' quec'u'x ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","C'ac'ari' xumaj tzij cuq'uin ja raj Israel ja yuke' quec'u'x ruq'uin, quewa' xbij chique ri': —Ja wi xajutij nixq'ueje' chipan ja ntzobal jari' ni katzij wi' chi ix ndiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ja wi queri' neban newotakij na jani' ja nna'oj in newotakij na chakaja' chi ni katzij wi' ja ntzobal in tok xtewotakij jari' nixwasanel libre, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","—Pro ja rajoj ok riy rumam can ja rAbraham, majutij okq'uejenak ta pa quek'a' winak okquibanon ta mandar ¿la ok preso la'an chewi' tok nabij chake chi nokwasaxel libre? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ja c'a Jesús xbij chic chique: —Ni katzij wi' ja xtinbij chewe ri', canojel ja winak ja nemacuni eje'e' xa e esclavo pa ruk'a' ja il mac como ja' il mac nbano mandar quixin. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jun esclavo arja' mta ruk'a' tre chi xtiq'ueje' ta chijutij chipan ja jay rxin ja rajaw pro jun alc'walaxel jari' c'o ruk'a' tre chi nq'ueje'e chijutij. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Rmalc'ari' nbij chewe chi ja Ralc'wal Dios wi arja' nixwasanel libre jari' ni katzij wi' chi ix libre. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Anin wotak chi ix riy rumam can ja rAbraham pro masqui ix riy rumam can pro emajon rcanoxic wij nwach nak neban chwe chi ninecamsaj. Queri' c'a neban como mateya' lugar tre ja ntzobal chi nq'uiy más pa tak ewanma. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nojel ja nmajon rbixic anin jari' ruq'uin Nata' ntz'aton wi'. Pro nojel ja remajon rbanic ixix jari' etata' ixix biyon chewe chi neban. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Pro ja katata' ajoj jari' ja rAbraham, xeche' tre. —Ja wixta katzij chi ix riy rumam can ja rAbraham ja ta c'ari' emajon rbanic ja cani' xuban ja rAbraham. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Anin nojel ja nbin chewe jari' ni katzij wi' como ja Dios arja' biyon chwe pro masqui queri' rbanic pro ixix necanoj wij nwach nak neban chwe chi ninecamsaj pro ja rAbraham ma queri' ta xuban ja cani' nixtajini neban ixix chwe camic. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ja c'a retata' ixix, ja cani' nuban arja' jari' emajon rbanic ixix chakaja', ne'e ja Jesús chique. —Ajoj tok xokalaxi ma ok alak'an tak ac'ala' ta, ajoj xa jun Tatixel kaxin jari' ja Dios, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ja c'a Jesús xbij chic chique: —Ja wixta katzij chi ja Dios arja' Tatixel ewxin ninewajo' ta c'a anin ari' chakaja'. Queri' nbij chewe como anin pa ranma ja Dios inelnakto wi', ruq'uin arja' inpenak wi'. Ma chaka ta ngana inpenak, arja' takyonto wxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Nak c'a tre tok matich'obtaj emwal ja nbij chewe? Matich'obtaji como ja ntzobal mta egana nec'waxaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ixix ix ralc'wal ja diablo in nak c'o rgana ja diablo chi nuban nijawari' c'ol egana ixix neban chakaja'. Ja diablo arja' ni camsanel wi' ja tok winakarto ja rwach'ulew. Nojelal ja nbij ja Dios xa rc'ulel ja diablo como ja diablo arja' ni majutij ja katzij ta nbij. Ja tok nutz'ak tzij ja diablo jari' ni rxin wi' como arja' ni tz'akol tzij wi', arja' kas nwinakarsani ja tz'akoj tak tzij. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pro anin ja nmajon rbixic chewe jari' ni katzij wi' pro como ni katzij wi' xa chewi' ja tok maquinenimaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿La c'o ta c'a jun chewe ncowini nbij chi c'o wil nbanon? Pro ja nmajon rbixic chewe, ja wi ni katzij wi' ¿nak c'a tre tok maquinenimaj? ");
INSERT INTO tzjNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ja ralc'wal Dios eje'e' nqueya' quixquin tre ja nbix chique rmal ja Dios pro ja rixix mateya' ewxquin tre ja nbix chewe rmal como ma ix ralc'wal Dios ta chewi'. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ja c'a raj Israel quemaj chic ryok'ic, quewa' quibij tre ri': —Ajoj ni rubey wi' tok kabij chawe chi xa at cani' jun aj Samaria in c'o jun demonio uc'ayon awxin chakaja', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ja c'a Jesús xbij chic chique: —Anin mta jun demonio inc'ayon ta como anin nmajon rya'ic ruk'ij ja nata' Dios pro ja rixix xa nineyok'. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pro anin ma ja ta ncanoj chi nya̱' nuk'ij cumal winak pro ja Nata' arja' ntajini nchomarsaj nak nuban chi nya̱' nuk'ij cumal ja winak, arja' c'a xtibini bar c'o wi' ja kas katzij, wi wq'uin anin owi ewq'uin ixix. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ni katzij wi' ja xtinbij chewe ri', ja wi c'o jun nnimaj ja ntzobal jari' ni mta wi' camíc trij, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ja c'a raj Israel eje'e' quibij chic jutij tre: —Camic bien k'alaj chi c'o jun demonio uc'ayon awxin como atat nabij chi ni mta wi' camíc trij jun winak wi arja' nnimaj ja ratzobal pro ¿la ma xcam ta la'an ja rAbraham ojer in la ma xecam ta la'an ja rojer tak profeta chakaja'? ");
INSERT INTO tzjNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿La tibij an tzij ari' chi atat más nim ak'ij chwach ja katata' Abraham ja tok arja' cami? In ja rojer tak profeta xecam na ari' chakaja'. ¿Nak c'a atocnak wi' nana' kaj atat? ");
INSERT INTO tzjNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ja c'a Jesús xbij chique: —Ja ranin wixta xa nya' nojoj nuk'ij nuyon jari' mta noc wi' pro ja Nata' arja' nyo' nuk'ij in ixix nebij tre ja Nata' chi arja' Dios ewxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pro xa ma ewotakin ta rwach ja Nata' pro anin bien wotak rwach. Ja wixta xinbij chewe chi ma wotak ta rwach jari' xta c'a in junan ewq'uin ari' ja rix tz'akol tak tzij. Pro jari' wotak rwach, ni nnimaj wi' ja rtzobal. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ja rAbraham ja retata' nixche' tre, arja' janila quicoti ojer ja tok ch'obtaj rmal chi nutz'at na ja k'ij ja tok xquinpit anin in jari' xutz'at, congana quicot rmal, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","—¿Nak moda c'ari' pro maja'n wa'an taban cincuenta ajuna', la atz'aton c'ari' ja rAbraham? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ja c'a Jesús xbij chic chique: —Ni katzij wi' ja xtinbij chewe ri', anin nij inc'o chi wi' ja tok maja'n talaxi ja rAbraham, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ja tok xbij queri' chique eje'e' quisic'la' abaj, laj queq'uiak tza'n abaj pro ja Jesús arja' xrawaj ri', xelel chipan ja templo in be. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ja Jesús arja' rmajon binem tok xutz'at jun achi ti moy ja ni pa ralaxic wi' chi moy. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ja c'a rdiscípulo quic'axaj tre: —Rabí ¿nak tre c'ala' tok ni moy wi' tok xalaxi ja rachi le', nak c'o ril chewi', la ril arja' owi quil rtata' rute'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ja c'a Jesús xbij chique: —Ma queri' ta, ma ril ta arja' chewi' tok rbanon quela' nixtac'a quil rtata' rute' chakaja'. Quela' rbanon ja rachi le' utzc'a chi c'o jun nimlaj samaj xin Dios nk'alajin na ja tok xtitzuri. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ja tok c'a inc'o na wawe' chwach'ulew rjawaxic chi nban ja rsamaj ja takyonpi wxin. Cani' tre ja tok noc ak'a' macatcowini natsamaj chic. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Jaru' pa tiempo xquinq'ueje' wawe' chwach'ulew anin inocnak in cani' k'ij rxin ja rwach'ulew, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ja tok tzuri tzij rmal c'ac'ari' chuban kaj pa tok'ulew in xumaj rbanic ch'abak tre ja ruchub, c'ac'ari' xuc'am, xuya' chi rwach ja ti moy ");
INSERT INTO tzjNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","in xbij tre: —Jat, jach'aja' rawach pa ya' ja rbina'an Siloé, ne' tre. (Ja bi'aj Siloé tibij tzij nta̱kel.) In queri' xuban ja rachi be. Ja tok xekaji xuch'aj ja rwach. Ja c'a tok ch'ajtajto rmal melojto, nca'y chic. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ja c'a rvecino ja rachi e cachbil jule' chic winak ja bien quitz'aton chi moy nabey eje'e' quibij: —¿La ma ja ta c'ala' ja rachi le' ja ni ntz'abe' wi' chi rc'utuxic limosna? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ec'oli chique quibij: —Arja' nac'a, xeche'e. In jule' chic quibij: —Mni, ni quela' nca'yi pro ma arja' ta, xeche'e. Pro ja rachi arja' xbij chique: —Anin nac'a, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—¿Pro nak c'a xaban, natca'y chic taka'an? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—C'o jun achi rbina'an Jesús, arja' xchomij jule' ch'abak in tok chomtaj rmal xuya' chi nwach in xbij chwe: —Jat, jach'aja' rawach pa ya' rbina'an Siloé, ne' chwe. In queri' xinban xinbe. Ja c'a tok xinekaji xinch'aj ja nwach in queri' xuban jaktaji, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Bar c'a c'o wi' ja Jesús camic? xeche' tre. —Jari' ma wotak ta ba la c'o wi', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","C'ac'ari' c'amarel ja rachi ja jaktaj rwach, xeya' chiquewach ja fariseo. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ja Jesús tok xchomij ja ch'abak in tok xujak rwach ja rachi jari' pa jun xula'nbal k'ij xuban wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ja c'a rachi c'axax chic tre cumal ja fariseo: —¿Nak xaban tok jaktaji ja rawach? xeche' tre. —Ja rachi xchomij jule' ch'abak in tok chomtaj rmal xuya' chi nwach. C'ac'ari' xinch'aj ja nwach in queri' xuban jaktaji, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ec'oli chique ja fariseo quibij: —Ja rachi rbina'an Jesús ma Dios ta takyonto rxin como arja' matuban respetar ja xula'nbal k'ij como c'o samaj nuban chipan, xeche'e. Pro jule' chic chique quewa' quibij ri': —¿Pro nak moda c'ari' jun achi wi xa il mac ja nuban in nuban jun milagro ja cani' nkatz'at camic ri'? xeche'e. In queri' queban, ma junan ta quech'ob trij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","In quibij chic tre ja rachi ja jaktaj rwach: —In atat ¿nak nabij tre ja rachi rbina'an Jesús? como arja' xujak awach. ¿Nak ocnak wi' nach'ob atat? xeche' tre. —Arja' jun profeta xin Dios, xeche'x rmal ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ja c'a raj Israel eje'e' ma xquinimaj ta chi ni moy wi' ja rachi nabey, ma xquinimaj ta chi c'a jaktaji ja rwach xa chewi' tok quetak quisiq'uixic ja rtata' rute'. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ja tok xe'ekaji ja rtata' rute' ja rachi c'axax chique: —¿La ewalc'wal ixix jawa' jun achi ri', la arja' ja nebij chi ni moy wi' tok xalaxi? ¿Nak c'a tre tok nca'y chic camic? xeche'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Ajoj kotak chi jala' kalc'wal in kotak chakaja' chi arja' ni moy wi' tok xalaxi. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pro ma kotak ta nak tre tok nca'y chic camic nixtac'a kotak ta chakaja' nak jakowi ja rwach. Mejor, tre arja' tec'waxaj wi' como c'o chic rjuna', ri'j chic, arja' c'a nbin ala' chewe nak ja xuban, xeche'e ja rtata' rute'. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Queri' quibij chique ja raj Israel como nquixbej qui' chiquewach como ja raj Israel eje'e' quichomin chic chi xa nak ta nbini chi ja Jesús arja' ja Cristo wi ne'e, jari' matic'ul chic chipan ja jay xin molbal ri'il ja bar nquemol wi' qui' ja raj Israel chi rc'axaxic ja rtzobal Dios, nch'akixel chijutij. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Rmalc'ari' ja tok quibij: —Mejor, tre arja' tec'waxaj wi' como c'o chic rjuna', ri'j chic wa'an, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","C'ac'ari' xec'amar chic jutij ja rachi ja moy nabey in quewa' quibij tre ri': —Chwach Dios tabij ja kas mero rubey como ajoj kotak chi ja rachi rbina'an Jesús arja' xa il mac ja nuban, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Ja wi xa il mac ja nuban jari' ma wotak ta anin xarwari' ja wotak chi anin in moy nabey pro ja camic ninca'y chic, xeche'x rmal ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—Pro ¿nak c'a xuban chawe? ¿Nak c'a xuban tok xujak awach? xeche' chic tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Pro jari' nbin chi wa'an chewe pro ixix mta egana nec'waxaj. ¿Nak c'a tre tok nec'waxaj chic jutij chwe? ¿La maxta c'a newajo' ixix chakaja' nixoc rdiscípulo? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Eje'e' congana pi quiyewal trij in quewa' quibij tre ri': —Ja ratat ni k'alaj chi at discípulo rxin arja' pro ja rajoj ok discípulo rxin ja Moisés. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ajoj kotak chi tzijoni ja Dios ruq'uin ja Moisés pro ja rachi rbina'an Jesús jari' ba la penak wi', nak la takyonto rxin, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—Pro nak moda taka'an matich'obtaj emwal nak takyonto rxin pro xujak c'a nwach, ne'e ja rachi chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bien kotak chi ja Dios arja' matic'axaj ja tok c'oli nc'utux tre rmal jun achi ja wi xa il mac nuban ja rachi. Pro jun achi wi nuya' ruk'ij ja Dios in wi nnimaj ja najo'x tre rmal ja Dios chi nuban jari' nc'axaxi ja nc'utuj tre ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jaru' pa tiempo winakarnakto ja rwach'ulew ni majun kac'axan ta chi c'o ta jun achi rjakon ta rwach jun achi ja ni pa ralaxic wi' chi moy. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ja Jesús wixta ma in Dios ta penak wi' ni ta c'a majun nak ta ncowini nuban ari', queri' xbij ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ja c'a reje'e' quemaj chic ryok'ic ja rachi, quewa' quibij tre ri': —Ja ratat xa rmal il mac tok nij at moy wi' xatalaxi ¿in atat nawajo' nokatijoj ajoj? Queri' quibij tre in quiwasajel chiquicojol chijutij in ma xquec'ul chi ta. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ja c'a Jesús tok xc'axaj chi wasaxto ja rachi in matic'ul chic arja' be, xerila' in quewa' xc'axaj tre ri': —¿La yukul chic ac'u'x ruq'uin ja Ralc'wal Dios? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Anin nwajo' nyuke' nuc'u'x ruq'uin pro tac'utu' chinwach nak chi achi'al c'ari' ja Ralc'wal Dios, ne'e ja rachi. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ja c'a Jesús xbij chic tre: —Pro jari' atz'aton chic, anin c'ari' ja rin Ralc'wal Dios ja nmajon tzij awq'uin camic ri', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","C'ac'ari' ja rachi xbij: —Wajaw, anin camic nyuke' nuc'u'x awq'uin. Queri' xbij tre ja Jesús, xuque' chwach in xumaj rya'ic ruk'ij. C'ac'ari' ja Jesús xbij: ");
INSERT INTO tzjNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","—Anin inpenak wawe' chwach'ulew utzc'a chi bien nk'alajin na nak quibanic ja winak. Inpenak utzc'a ja moya' njaktaj quewach utzc'a chakaja' ja winak ja nebini chi neca'yi eje'e' nek'alajin na chi xa e moya', ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ec'oli ja fariseo ec'o chinakaj ja Jesús tok quic'axaj ja xbij congana pi quiyewal trij in quewa' quibij tre ri': —¿La ok moya' la'an ajoj chakaja' chewi' tok nabij queri'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—Ja wixta xeya' chewij chi pa k'ekumal ixc'o wi' jari' mta nixchapbexi pro como nebij chi: —Ajoj bien kotak chic ja rbey Dios, nixche'e, jari' nixchapbexi. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","C'ac'ari' xbij chic: —Ja tzij xtinbij chewe ri' ni katzij wi', tok c'o jun nrajo' noc chipan jun corral quixin tak carnelo pro wi ma tri' ta noc wi' ja bar wasan can wi' ruchi' ja corral, ja wi xa junwi' njote' wi' in nkaj chipan jari' xa jun alak'om in camsanel chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pro ja noqui ja bar wasan can wi' ruchi' ja corral jari' ni katzij wi' chi arja' yuk'ul quixin ja tak carnelo. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ja tok nekaji ja rajyuk' chuchi' ja corral nja̱k chwach rmal ja jakol chi' corral. Ja c'a tok noc chipan nc'axax rukul cumal ja tak carnelo, ja c'a tak rxin arja' nerk'ijla', nbij quebi' chiquijujunal in numajto quilasaxic chipan ja corral. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ja c'a tok nelastajpi rmal nuc'amel quebey in ja tak carnelo eje'e' netre'el trij como eje'e' bien cotak rukul chi arja' yuk'ul quixin. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pro wi c'o jun nsiq'uin quixin ja tak carnelo pro wi ma cotak ta rwach jari' maquetre' trij, ja nqueban ne'anmajel chwach como ma cotak ta quekul ja winak ja re junwi' chi na. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jawa' c'ambal tzij ri' xbij ja Jesús pro ja fariseo eje'e' xa matich'obtaj cumal. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ja c'a Jesús xbij chic jutij chique: —Anin c'ari' ja rin rchi' corral ja bar ne'oc wi' ja tak carnelo. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Canojel ja xepeti ja tok maja'n quinpit anin in ma pa rchi' corral ta xe'oc wi' eje'e' ari' xa e alak'oma' in xa e camsanela' pro ma xya' ta caso chique cumal ja tak carnelo. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Anin c'ari' ja rin rchi' corral, xc'a nak ta ja xturkaj wq'uin jari' ntotaji in nyataj tre xa nak ta ja nc'atzin tre, cani' chique ja tak carnelo eje'e' nyataj chique chi ne'eli ne'oqui chipan ja quicorral, tok ne'elto nquewil ja buen tak k'ayis in nquetij. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ja ralak'om tok nbe cuq'uin ja tak carnelo bien rch'obonel chi ne'erlak'ajto, nercamsaj in neruyoj. Pro ja ranin inpenak cuq'uin nunya'a' jun c'ac'a c'aslemal chique in ma ruyon tari' pro nnoji chakaja' jun nimlaj quicotemal chipan ja quic'aslemal. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Anin in ajyuk' ja ni katzij wi' chi in utzlaj ajyuk'. Ja utzlaj ajyuk' arja' matipokonaj ncam pa quicuenta ja tak carnelo. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pro ma queri' ta nqueban ja xa etojon ja ma katzij ta chi e ajyuk'a', eje'e' ma e quixin ta ja tak carnelo in wi quetz'at chi pi jun itzel chicop eje'e' nequeya' can ja tak carnelo in ne'anmajel. Ja c'a ritzel chicop arja' neruchap ja tak carnelo in nerchicaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ne'anmaji como matel quec'u'x chiquij ja tak carnelo, ja quijil ja netojbexi xa jari' ja elnak quec'u'x trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Anin in jun ajyuk' ja ni katzij wi' chi in utzlaj ajyuk', nenwajo' ja tak ncarnelo in bien wotak jani' quina'oj in queri' quibanon chwe anin chakaja', ");
INSERT INTO tzjNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","cani' kabanon ruq'uin ja Tatixel, arja' ninrajo' in bien rotak jani' nna'oj in queri' nbanon anin tre chakaja', in anin matinpokonaj nincam pa quicuenta ja tak ncarnelo. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","In chakaja' ec'o chi na jule' tak ncarnelo ja ma ec'o ta chipan awa' corral ri'. Jari' ne'enc'ama' na, ja c'a tok xtiquic'axaj ja nukul eje'e' nqueya' caso chwe in xa jun moc xtinban chique canojelal in xa jun ajyuk' nyuk'un quixin. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Como anin matinpokonaj nincam pa quicuenta ja tak ncarnelo chewi' tok ninrajo' ja Tatixel. Anin nya' wi' pa camíc cumal in ninc'astaj chi na chipan ja camíc. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ja wixta mta ngana nincami maquincami, majun nak ta ncowin ta chwij chi ninrcamsaj ta pro jari' ni ngana wi' chi nya' wi' chipan ja camíc. Wq'uin anin c'o wi' como nincowini nya' wi' chipan ja camíc in nincowini ninc'astaj chic chipan chakaja'. Jari' bin chwe rmal ja Nata' chi queri' nban. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ja tok bitaji tzij ri' rmal ja Jesús ja raj Israel eje'e' quemaj chic jutij rch'a'ic chibil tak qui'. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ec'oli chique quewa' quibij ri': —Xa jun demonio uc'ayon rxin ja rachi le', xa ch'ujarnak. ¿Nak tre tok neya' caso tre? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","In jule' chic chique quewa' quibij ri': —Pro ma quela' ta ntzijon jun winak ja tok c'o jun demonio uc'ayon rxin. ¿La ncowin la'an jun demonio xtujak quewach moya' nech'ob ixix? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Xerila' ja nmak'ij ja c'o rubi' dedicación ne'xi, chi nc'uli chipan ja tinamit Jerusalén. Jari' tiempo rtiempo tew. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ja c'a Jesús arja' rmajon binem chipan ja nimlaj templo xin Dios. C'o c'a jun pa rkan jay ja rubi' nbixi xin Salomón ne'xi, tri' c'a rmajon wi' binem. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ja c'a raj Israel xequimolo' qui' trij in quibij tre: —¿Nak tre tok matabij rubi' chake? Ja wi atat ja rat Cristo ni tak'alasaj jutz'it chikawach, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","—Pro jari' nbin chic chewe pro ja rixix xa maquinenimaj. Nojel ja samaj ja nmajon rbanic ja bin chwe rmal ja Nata' jari' nc'utuwi nak inocnak wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pro ixix xa maquinenimaj como ma ix tak ncarnelo ta cani' nbin chic chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ja tak ncarnelo eje'e' nquic'axaj ja nukul in ninquinimaj, anin nenwajo', bien wotak jani' quina'oj in eje'e' netre' chwij. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Anin nya' chique ja utzlaj c'aslemal ja mta q'uisic trij, ni maquebe wi' chipan ja nimlaj rpokonal in majun nak ta xquelasan ta pa nuk'a'. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ja Nata' arja' xeyo' chwe in arja' más k'axnak chi na rchok'ak' chiquewach canojelal in majun nak ta xquelasan ta pa ruk'a'. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Anin xa ok junan ruq'uin ja Tatixel, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ja c'a raj Israel jutij chic quisic'la' abaj, laj queq'uiak chic ja Jesús tza'n abaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ja c'a Jesús xbij chique: —Anin q'uiy rwach ja samaj ja utzlaj samaj nbanon chewach ja yatajnak chwe rmal ja Nata' chi xinban. ¿La xa rumac on jun utzlaj samaj xinban xa chewi' tok newajo' ninecamsaj? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Ma rmal ta jun samaj utz xaban chewi' tok natkaq'uiak tza'n abaj, rumac chi xacoj awi' como at Dios pro xwa'n at winak in ja neli xa naban ofender ja Dios, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ja c'a Jesús xbij chic chique: —¿La ma tz'ibtal can ta c'a chipan ja ley xin Dios ja c'ol ewq'uin chi ja Dios arja' quewa' xbij chique jule' winak ri'? —Anin xinbij chewe chi ix dios, ne'e ja Dios chique, queri' tz'ibtal can. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Queri' rbanic, ja Dios arja' xbij chique chi e dios, queri' ja rtzobal Dios quic'axaj in bien kotak chi ja rtzobal Dios mta moda xtiq'uextaj ta. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ja c'a chwe anin, Dios xinrucha' in xinrutakto wawe' chwach'ulew. Ja c'a reje'e' wi bix chique chi e dios ¿nak c'a tre tok nebij ixix chwe chi xa ofensa rc'amonto tre ja Dios ja tok xinbij chi anin ja rin Ralc'wal Dios? ");
INSERT INTO tzjNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ja samaj ja nmajon rbanic, ja wi ma xin Nata' ta ni c'a utz wari' ja wi maquinenimaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pro wi xin nata' Dios ja samaj ja nmajon rbanic tenimaj c'a chi rxin arja' masqui matiyuke' ec'u'x wq'uin anin. Queri' nwajo' chewe utzc'a chi newotakij na chi ja Tatixel xa jun rbanon wq'uin in anin chakaja' xa jun nbanon ruq'uin utzc'a chi nyuke' ec'u'x wq'uin. Queri' xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jutij chic cajo' ta quechap quecoj ta preso pro arja' xuto'el ri' pa quek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","C'ac'ari' be chic jutij ja Jesús chajuparaj ja binelya' Jordán. Ja c'a tok xekaji tri' q'ueje' wi'. Jari' lugar tri' xeba̱n wi' bautizar ja winak nabey rmal ja Juan. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","E q'uiy ja winak xe'ekaj ruq'uin ja Jesús in quewa' quibij ri': —Ja Juan masqui mta milagro xuban can arja' pro ni katzij wi' nojel ja rbin can tre ja Jesús le', xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","In e q'uiy chique ja yuke' quec'u'x ruq'uin tri'. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","C'o c'a jun achi rbina'an Lázaro aj Betania, arja' yawajnak. Ja Lázaro arja' c'o jun rana' rbina'an María in tri' c'o wi' ja María pa Betania chakaja' rachbil ja Marta ja rnimal. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jari' María ja xuban jutij xuc'am jule' ak'om qui' rxula', xucoj chi rkan ja kajaw Jesús in xusu' chi rsamal rwi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ja c'a María rachbil Marta eje'e' quetakel rbixic tre ja Jesús, quewa' quibijel tre ri': —Kajaw, ja kaxibal ja congana newajo' ewi' ruq'uin, arja' yawajnak, queri' quibijel tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ja c'a Jesús tok xc'axaj ja xebix tre quewa' xbij ri': —Ja yobil tre ja Lázaro ma camíc ta rc'amonto pro ja rc'amonto quewari', tri' nk'alajin na wi' chi ja Dios arja' congana rchok'ak' in congana nim ruk'ij, in jun chic, congana nya̱' na ruk'ij ja Ralc'wal Dios rmal, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ja Jesús congana nerajo' chi e oxi' Marta in María ja ruchak' in ja Lázaro chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ja c'a tok xekaj rbixic ruq'uin chi yawa' ja Lázaro arja' q'ueje' chi na ca'i' k'ij ja bar c'o wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ja tok tz'akati ja ca'i' k'ij c'ac'ari' xbij chic chique ja rdiscípulo: —Jo' chic jutij chipan ja departamento Judea, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ja c'a rdiscípulo eje'e' quibij tre: —Rabí, ja raj Israel ja rec'o tri' laj wa'an xatqueq'uiak tza'n abaj in ¿nawajo' c'a natbe chic jutij tri'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ja c'a Jesús xc'ambej jun tzij chiquewach, quewa' xbij chique ri': —¿La mta c'a cablajuj hora nca'yi ja k'ij chipan jun k'ij? Ja wi pa k'ij natbini jari' matachok' awakan como ja k'ij nsakirsan abey chawach. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ja c'a wi chak'a' natbini jari' nachok' awakan como mta luz pan awanma ja nsakirsan abey chawach, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","C'ac'ari' xbij chic chique: —Warnak chic ja Lázaro ja kamigo pro can ninbe ruq'uin chi nenc'asa', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Kajaw, pro wi warnak chic ch'enchila', ntzur ala', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pro ja Jesús tok xbij chi warnak ja Lázaro jari' tibij tzij chi cami pro ja nquech'ob ja discípulo xa jic chi waram rbanon ja Lázaro, xula'nnak. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","C'ac'ari' ja Jesús ni xk'alasaj chiquewach chi utz: —Camnak chic ja Lázaro, ne' chique. In xbij chic chique: ");
INSERT INTO tzjNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","—Anin ninquicoti ja ma inc'o ta tri' ja tok cami pro emwal ixix tok nbij queri' chewe como jari' c'oli rc'amonto chewe utzc'a chi nyuke' más ec'u'x wq'uin. Pro camic jo' tekatz'ata', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ja c'a Tomás ja yo'x ne'xi, arja' xbij chique ja rach tak discípulo: —Jo' trij ja Jesús utzc'a chi ajoj jun nokcamsax ruq'uin chakaja', ne' chique, in xebe. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ja c'a tok xe'ekaji bix tre ja Jesús chi quiji' k'ij mukun chic ja Lázaro pa jul. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ja tinamit Betania xa chinakaj Jerusalén c'o wi', c'o la oxi' kilómetro rcojol ruq'uin, ");
INSERT INTO tzjNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","in e q'uiy ja raj Israel e'urkajnak cuq'uin ja Marta in María chi nurquiyukba' quec'u'x rmal ja cami ja quixibal. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ja Marta tok xc'axaj chi peti ja Jesús xerc'ulu' pro ja María tz'ubul can pa jay. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ja c'a Marta tok xuc'ul ja Jesús quewa' xbij tre ri': —Wajaw, ja wixta atc'o kuq'uin maquita cami ja nxibal. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pro anin wotak chi ja camic xa nak ta nac'utuj tre ja Dios nuya' chawe, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Ja raxibal can nc'astaj rwach, ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ja c'a Marta xbij chic tre: —Anin wotak chi nc'astaj na pro tokori' tok xquec'astaji ja camnaki' chipan ja q'uisbal k'ij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ja c'a Jesús xbij tre: —Pro nij anin wi' ninyico quixin ja winak chipan ja camíc, nij anin wi' ninyowi ja utzlaj c'aslemal ja mta q'uisic trij. Xa nak ta ja yukul ruc'u'x wq'uin arja' masqui cami pro jari' ma chijutij ta, nc'ase' chi na jutij. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","In chakaja' xa nak ta ja c'a c'as na camic ja wi yukul ruc'u'x wq'uin jari' ni mta wi' camíc trij chijutij. ¿La nanimaj ja c'a xinbij chawe ri'? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Can nnimaj Wajaw, anin nnimaj chi atat ja rat Cristo, atat ja rat Ralc'wal Dios ja bitajnak can ojer chi natpi na wawe' chwach'ulew, ne'e ja Marta tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ja Marta tok bitaj can rmal ja tzij ri' be chi rsiq'uixic ja María ja ruchak'. Ja c'a tok xekaj ruq'uin pan ekal tzijon ruq'uin, quewa' xbij tre ri': —Xurkaji ja Maestro, natrsiq'uij, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ja c'a María tok xc'axaj yictaji alnak in be ruq'uin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ja Jesús arja' maja'n toc chipan ja tinamit, tri' c'o can wi' ja bar c'ul wi' rmal ja Marta. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ja c'a raj Israel ja rec'o pa jay ruq'uin ja María chi ryukbaxic ruc'u'x tok quetz'at chi yictaji alnak ja María in be eje'e' xetre'el trij chakaja' in quewa' quibij chibil tak qui' ri': —Tri' nbe wi' ja bar mukun wi' ja camnak, tri' ne'ok' chi wi', xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ja María tok xekaji ja bar c'o wi' ja Jesús tok xutz'at xuque' chwach in xbij tre: —Wajaw, ja wixta atc'o kuq'uin maquita cami ja nxibal, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ja c'a Jesús tok xutz'at ja María chi rmajon ok'ej in ja jule' chic aj Israel e rachbil chakaja' quimajon ok'ej arja' congana junwi' xuna', congana xk'ututuj ri' ja ranma rmal bis ");
INSERT INTO tzjNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","in xc'axaj chique: —¿Bar c'a emukun wi'? ne' chique. —Kajaw, jo' mpe' tekatz'ata', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ja c'a Jesús xumaj ok'ej. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ja c'a raj Israel tok quetz'at chi rmajon ok'ej quewa' quibij ri': —Tetz'ata' mpe' le', ni k'alaj chi congana nrajo' ja Lázaro, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pro ec'oli chique quewa' quibij ri': —Ja wi xujak rwach ja rachi ja moy ¿la maquita c'a cowin ari' xtzursaj ja Lázaro in maquita cami? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jutij chic ja Jesús congana junwi' xuna' rumac bis in be ja bar mukun wi' ja Lázaro. C'o jun jul c'oton chwach jun jayu', chipan mukun wi' in tz'apin ruchi' tre jun nimlaj abaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Tewasaj ja rabaj le', ne'e ja Jesús chique. Ja c'a Marta ja rana' ja camnak arja' xbij tre: —Wajaw, jala' chuw chic como tuban quiji' k'ij ticami, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—¿La ma xinbij ta c'a chawe ja wi nyuke' ac'u'x wq'uin natz'at na chi ja Dios congana rchok'ak' in congana nim ruk'ij? ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","C'ac'ari' quiwasaj ja rabaj chuchi' ja jul ja bar mukun wi' ja camnak. Ja c'a Jesús ca'y chicaj in quewa' xbij ri': —Nata', anin nmaltioxij chawe chi xac'waxaj ja xinc'utuj chawe. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Pro anin bien wotak chi ni nac'waxaj wi' ja nc'utuj chawe xarwari' quewa' nbij chawe camic utzc'a ja winak ja quimolon qui' ri' eje'e' nquic'axaj ja nintajini nbij chawe in nquinimaj chi atat attakyonpi wxin, ne' tre ja Tatixel. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ja tok bitaji tzij ri' rmal ja Jesús arja' tzijon chic jutij pro ni cow tzijoni, quewa' xbij ri': —Lázaro, catelto, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","C'ac'ari' xelto ja Lázaro pro ma camnak chi ta. Ja ruk'a' rkan batz'on pa tziak in batz'on rpalaj tre jun su't. Ja c'a Jesús xbij chique: —Tequira', teya'a' lugar tre chi nbe, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ja c'a raj Israel ja cachbilanel ja María eje'e' tok quetz'at ja xuban ja Jesús e q'uiy chique yuke' chic quec'u'x ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pro ec'o chic jule' chique, eje'e' xebe cuq'uin ja fariseo, xequibij chique ja milagro ja xuban ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ja c'a jefe quixin sacerdote e cachbil ja fariseo eje'e' xequemol ja jule' chic cach k'etol tak tzij in quewa' quibij chique ri': —¿Nak nkaban c'awa'? Congana taka'an milagro nuban ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ja wi xtikaya' lugar tre chi nuban más jari' ma c'ayew ta chi nyuke' quec'u'x ja winak ruq'uin pro ni canojelal. Jari' neyictajto ja raj Roma, nurquiyojo' ja katemplo rachbil ja katinamit chakaja', xeche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","C'o c'a jun chique rbina'an Caifás, arja' ocnak lok'laj sacerdote chipan ari' juna'. Quewa' xbij ja Caifás chique ri': —Ixix taka'an majun nixcowini nechomij. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Xa matich'obtaj emwal chi más na utz nokeli ja xa jun ncam pa kaq'uexwach ja rok aj Israel chwach ja nq'uisi chi jun ja tinamit, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ja Caifás arja' majun rnaben chi Dios yo' tre ja tzij xbij. Como arja' ocnak lok'laj sacerdote chipan ari' juna' chewi' tok Dios xuya' tre chi xbij pon nak ja maja'n tiban tre ja Jesús chi arja' ncam na pa quicuenta ja tinamit Israel. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pro ma queyon ta ja raj Israel ncam pa quicuenta, arja' nerumol na chakaja' canojel ja winak ja ne'oc na e ralc'wal Dios ja rec'o nojel rwach'ulew utzc'a xa jun nuban chique canojelal. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jari' k'ij quemajto rch'obic ja k'etol tak tzij nak nqueban tre ja Jesús chi nquicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rmalc'ari' tok ja Jesús arja' ma kas ta q'ueje' chic chiquicojol ja raj Israel pro be chipan jun tinamit rbina'an Efraín ja c'o chinakaj jun lugar ja kas talani. Ja tok xekaji, tri' q'ueje' wi' e rachbil ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Xa nnakajinto ja nmak'ij quixin ja raj Israel rbina'an pascua. E q'uiy ja winak ja tok xajalal maja'n terila' ja nmak'ij xe'elto pa tak quitinamit, xebe pa Jerusalén chi rbanic jule' costumbre ja nquich'ach'ojirsbej pon qui' cani' nrajo' ja quireligión. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ja c'a winak quimajon rcanoxic ja Jesús, ec'o chipan ja nimlaj templo xin Dios in quemaj rc'axaxic chibil tak qui': —¿Nak nech'ob ixix tre ja Jesús, la npeti, la nurbana' ja nmak'ij owi ma can ta? neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ja c'a jefe quixin sacerdote e cachbil ja fariseo c'o chic jun orden quiya'on, quewa' nbij ja orden ri': —Xa nak ta xtotakini bar c'o wi' ja Jesús tiya'a' rbixic chake. Queri' queban utzc'a chi nquechap ja Jesús in nquecoj preso. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Waki' k'ij c'o chi wi' ja nmak'ij pascua tok be chic jutij ja Jesús pa Betania ja bar c'o wi' ja Lázaro. Jari' mismo Lázaro ja yataj tre rmal ja Jesús chi c'astaj chiquicojol camnaki'. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","C'o jun nimlaj wa'im chomixi ja pa Betania rumac ja xekaji ja Jesús cuq'uin. Ja Marta arja' rmajon ilinem, ja c'a Lázaro arja' jun tz'ubul chiquicojol ja winak ja retz'ubul ruq'uin ja Jesús pa mesa. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ja c'a María arja' xuc'am nc'aj litro ak'om nardo ne'xi, congana qui' rxula' in congana nim rjil chakaja'. Ja c'a xuban, xutix ja rak'om trij rkan ja Jesús c'ac'ari' xusu' chi rsamal rwi'. Ja rak'om ni noji rxula' pa jay. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","C'o c'a jun chique ja rdiscípulo ja Jesús rbina'an Judas Iscariote, arja' rc'ajol jun achi rbina'an Simón, arja' njacho na ja Jesús pa quek'a' ja winak ja netzelan rxin. Ja Judas tok xutz'at ja xuban ja María quewa' xbij ri': ");
INSERT INTO tzjNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Ja rak'om le' ¿nak tre tok ma xuya' ta chake kac'ayij ta chi oxi' ciento quetzal, ja c'a rjil kaya' ta chique ja tak meba'i'? ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Queri' xbij pro ma rmal ta chi npokonaj quewach ja tak meba'i' como arja' xa alak'om xa chewi' tok nlak'aj kaj ja pwok pa caja como pa ruk'a' c'o wi' ja pwok quixin ja Jesús e rachbil ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ja c'a Jesús xuch'a' tre ja xbij, quewa' xbij tre ri': —Ma tanak ta ja María como arja' rc'olon ja rak'om chi nucoj chwij jari' nnatbej ja ncamic. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ja tak meba'i' eje'e' nij ec'o wi' checojol ja wi c'ol egana neban utzil chique pro ja chwe anin maquinq'ueje' ewq'uin nojel tiempo, ninwasaxel na checojol, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Congana e q'uiy chique ja raj Israel tok quic'axaj chi c'o chic pa Betania ja Jesús, tri' xebe wi' nequitz'ata' rwach pro ma ruyon ta ja Jesús como c'o quigana nequitz'ata' rwach ja Lázaro chakaja'. Jari' mismo Lázaro ja yataj tre rmal ja Jesús chi c'astaji chiquicojol ja camnaki'. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ja c'a jefe quixin sacerdote eje'e' quemol qui' chi rchomarsaxic nak nqueban tre ja Lázaro chi nquicamsaj arja' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Queri' queban como rumac ja Lázaro chewi' tok e q'uiy chique ja cach tak aj Israel xe'elel cuq'uin eje'e' in yuke' chic quec'u'x ruq'uin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ja c'a chi rcab k'ij ja winak ja re'ekajnak chi rc'ulic ja nmak'ij e q'uiy chique tok quic'axaj chi benak ja Jesús pa Jerusalén ");
INSERT INTO tzjNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","eje'e' quec'am rxak tak palma, xepeti chi nurquic'ulu'. C'ac'ari' quemaj rakic quechi', quewa' quibij ri': —Dios, ko'ato'o' camic, peti ja To'onel janila nim ruk'ij, arja' ja Rey kaxin ja rok aj Israel ja penak pa rubi' ja kajaw Dios, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ja c'a Jesús arja' xcanoj jun bur ja c'a ti co'l na. Ja tok contaj rmal c'ac'ari' tz'abe'el trij. Queri' xuban ja cani' tz'ibtal can ojer chipan ja rtzobal Dios chi nbantaj na, quewa' nbij ri': ");
INSERT INTO tzjNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","—Ja rix aj Sión ma texbej ta ewi' camic, tetz'ata' mpe' le' peti ja Rey ewxin, tz'ubulto trij jun bur ja c'a ti co'l na. Queri' ja tz'ibtal can ojer. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pro ja c'a rdiscípulo ja Jesús eje'e' xa matich'obtaj cumal nabey nojel awa' wari' ja ntajini nuban ja Jesús. Ja tok c'astaji ja Jesús chiquicojol ja camnaki' in tok jote' chila' chicaj c'a tokoc'ari' ch'obtaj cumal in xurkaj chique chi tz'ibtal can ojer chipan ja rtzobal Dios nojel awa' wari' ja xuban ja Jesús in cani' tz'ibtal can ni queri' ja ban tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tri' ec'o wi' jule' winak ja xetz'ato rxin ja Jesús tok xuyic ja Lázaro chiquicojol ja camnaki', eje'e' quetz'at ja xuban ja tok xbij tre ja Lázaro chi nelto chipan ja jul ja bar mukun wi'. Jawa' winak ri' eje'e' quimajon rbixic chique ja jule' chic winak ja quetz'at. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Rmalc'ari' tok xepeti ja winak chi rc'ulic ja Jesús como quic'axaj ja milagro xuban tre ja Lázaro. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ja c'a fariseo xa pokon quena' rmal in quemaj rbixic chibil tak qui': —Que'etz'ata' mpe' ja winak le' xebe ruq'uin ja Jesús pro ni canojelal, camic majun nokcowini nkaban chic tre, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ec'o c'a jule' winak aj Grecia, eje'e' e'urkajnak pa Jerusalén, epenak chi rya'ic ruk'ij ja Dios chipan ja nmak'ij pascua. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Xebe ruq'uin ja Felipe ja raj Betsaida ja c'o pa rcuenta Galilea. Ja tok xe'ekaj ruq'uin quewa' quibij tre ri': —Ajoj nkajo' nkotakij rwach ja Jesús, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ja c'a Felipe arja' xerbij tre ja rAndrés c'ac'ari' xebe chi e ca'i' xequibij tre ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ja c'a Jesús tok xc'axaj ja bix tre quewa' xbij chique ri': —Camic ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak xurwila' ja tiempo chi congana nya̱' ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ni katzij wi' ja xtinbij chewe ja nc'ambej tzij chewach ri'. Ja jun chirwach trigo ja wi napokonaj namuk pa tok'ulew jari' majun nelto in majun cosecha nuya' pro ja wi matapokonaj namuk pa tok'ulew jari' nelto in congana rwach nuya'. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ja wi napokonaj naya' can ja rac'aslemal wawe' chwach'ulew jari' natz'ila' ja utzlaj c'aslemal pro wi matapokonaj naya' can ja rac'aslemal wawe' chwach'ulew jari' nij awc'an wi' ja utzlaj c'aslemal in jari' c'aslemal ni mta wi' q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ja winak ja neniman wxin rjawaxic chi tri' nek'ax wi' ja bar nink'ax wi' anin in chakaja' tri' ne'eq'ueje' wi' ja bar inc'o wi' anin. Xa nak ta ja neniman wxin eje'e' nya̱' na quek'ij rmal ja Nata'. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Camic congana nti'oni ja wanma, ni lawulo' nban rmal pro ¿nak c'a nban? ¿La xtinbij ta c'a tre ja Nata' chi arja' ninruto' utzc'a chi maquita nink'ax chipan ja rpokonal ja penak chinwach ri'? Jari' ma can ta como ja penak chinwach ri' xa rmalari' tok inpenak anin wawe' chi nink'ax chipan. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Xarwari' nbij chawe Nata', tak'alasaj chiquewach ja winak chi congana nim ak'ij atat. Queri' xbij ja Jesús. C'ac'ari' c'o jun kulaj c'axaxi penak chila' chicaj quewa' xbij ri': —Jari' nk'alasan chic in nk'alasaj chi na más chakaja', ne'e ja kulaj rxin ja Tatixel. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ja winak ja rec'o tri' ec'oli chique tok quic'axaj ja kulaj eje'e' quibij chi xuban quiakolijay, xeche'e. In jule' chic quibij: —Jun ángel tzijonto ruq'uin, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pro ja Jesús arja' xbij chique: —Ja kulaj ja c'a xec'waxaj jari' ma mwal ta anin tzijoni, emwal ixix. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Camic xurwila' ja tiempo chi nk'alajini nak rbanic ja ritzelal ja c'o pa tak canma ja winak wawe' chwach'ulew, xurwila' ja tiempo chi nkajsax rchok'ak' ja Satanás ja nbano mandar wawe' chwach'ulew in nbatataxel. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pro ja chwe anin ja tok xquinjecbaxi jari' nenujic' canojelal ja winak xa nak ta chi winakil utzc'a chi nyuke' quec'u'x wq'uin. Queri' xbij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ja tok xbij queri' jari' xc'utbej nak xtiban tre ja tok xticamsaxi chi chwach jun cruz njecbax wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ja c'a winak quewa' quibij tre ri': —Pro kac'axan wa'an chipan ja rtzobal Dios chi tok xtipeti ja Cristo arja' ni mta wi' camíc trij ¿nak c'a tre tok nabij atat chi ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak chi rjawaxic chi njecbax na chicaj? ¿Nak c'a ja ralc'walaxel ja nabij le'? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ja c'a Jesús xbij chic chique: —Ja nsakirsan ebey camic arja' xa jun ca'i' k'ij nq'ueje' chi na checojol rmalc'ari' nbij chewe, como c'a c'o na ja luz checojol teya'a' lugar tre chi noc pa tak ewanma utzc'a chi matoqui ja k'ekumal pa tak ewanma. Ja winak ja xa pa k'ekumal nebin wi' eje'e' ma cotak ta bar xque'ekaj wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Como maja'n tel checojol ja nsakirsan ebey chewi' tok nbij chewe, tiyuke' ec'u'x ruq'uin camic utzc'a chi ni ja wi' ja sakil nuc'an ewxin, ne'e ja Jesús chique. Ja tok bitaj awa' tzij rmal ri' c'ac'ari' be, rawaj ri' chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ja Jesús masqui congana q'uiy ja milagro rbanon chic ja rc'utben chiquewach nak ja rocnak wi' pro eje'e' ni ma xyuke' ta wi' quec'u'x ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Queri' queban utzc'a chi nbantaj cumplir ja bitajnak can rmal ja profeta Isaías ojer quewari': —Wajaw, xa ma e nim ta ja xenimani ja ratzobal ja kaya' rbixic, xa ma e nim ta ja ch'obtaj cumal nak rbanic ja nimak tak milagro naban chiquewach. Queri' tz'ibtal can. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Rmalc'ari' ma xecowin ta ja winak yuke' ta quec'u'x ruq'uin ja Jesús. Queri' queban como c'o chic jule' tzij bitajnak can rmal ja rIsaías quewari': ");
INSERT INTO tzjNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","—Ja xuban ja Dios chique cani' xermoyirsaj in xcowirsaj ja canma. Queri' xuban chique utzc'a chi matiquetz'at ja nc'u̱t chiquewach chi matich'obtaj cumal ja nbix chique in matiqueq'uex quina'oj chi netzuri. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Queri' rbin can ja rIsaías, tokori' xbij ja tok xutz'at ja gloria ja rc'an ja Kajaw in tok tzijon tre nak rbanic. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pro e q'uiy chique ja k'etol tak tzij eje'e' quinimaj ja Jesús pro xa nquipokonaj nquibij chi yukul quec'u'x ruq'uin como nquixbej qui' chiquewach ja fariseo: —Maxla nokquich'akijto chipan ja jay xin molbal ri'il ja bar nc'axax wi' ja rtzobal Dios in makoquec'ul chic chipan, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Queri' queban como más na nqueya' caso tre ja nbix chique cumal ja winak chwach ja nbix chique rmal ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Xumaj chic jutij tzij ja Jesús, cow tzijoni in quewa' xbij ri': —Ja winak ja yukul quec'u'x wq'uin jari' yukul c'a quec'u'x ari' chakaja' ruq'uin ja rintakyonto, ma ruyon ta wq'uin anin. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ja winak ja retz'atyon nwach quitz'aton c'a rwach ari' chakaja' ja rintakyonto. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Anin inpenak wawe' chwach'ulew chi nsakirsaj quebey ja winak chiquewach utzc'a xa nak ta chi winakil ja xtiyuke' quec'u'x wq'uin eje'e' maqueq'ueje' más chipan ja k'ekumal. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Anin inpenak wawe' chwach'ulew ma rmal ta chi nk'et ta tzij chiquij ja winak pro inpenak chi quito'ic. Rmalc'ari' nbij chewe, ja wi ec'oli winak ja nec'axani ja nbij chique pro wi matiquinimaj jari' ma anin ta nink'eto tzij chiquij. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ja wi maticajo' nyuke' quec'u'x wq'uin in wi maticajo' nquinimaj ja nbin chique jari' c'oli ja nk'etbex tzij chiquij como ja tzij ja xinbij chique jari' nk'etbex tzij chiquij tokori' tok xterila' ja nimlaj juicio xin q'uisbal k'ij. ");
INSERT INTO tzjNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Queri' nbij chewe como ja tijonem ja nc'utun chewach jari' ya'on chwe rmal ja Tatixel ja rintakyonto, ma chaka ta nwinakarsan nojoj nuyon, ");
INSERT INTO tzjNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","in ja tijonem ja ya'on chwe rmal ja Tatixel bien wotak chi jari' c'amyonto ja utzlaj c'aslemal ja mta q'uisic trij. Queri' rbanic, nojel ja tzij nbij, xa nak ta chi tzijal, ja' Tatixel biyon chwe. Queri' xbij ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Xerila' ja pispra rxin ja nmak'ij pascua. Ja c'a Jesús arja' rotak chi xurwila' ja hora chi nuya' can ja rwach'ulew in nmeloj ruq'uin ja Tatixel. Cani' rbanonto chique ja rdiscípulo wawe' chwach'ulew nij erajo'onto wi' in niquirwari' xuban can chic chique, c'oli ja xc'utbej chic chiquewach chi ni nerajo' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Arja' rmajon wa'im cuq'uin ja rdiscípulo. Ja c'a diablo arja' rbanon chic ja samaj pa ranma ja Judas Iscariote ja rc'ajol Simón, rtakchi'in chic chi nujach ja Jesús pa quek'a' ja winak ja netzelan rxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ja c'a Jesús arja' bien rotak chi jachon pa ruk'a' nojelal rmal ja Tatixel in bien rotak chakaja' chi arja' ruq'uin ja Dios penak wi' in ruq'uin nmeloj chi wi' jutij. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","C'ac'ari' yictajto pa mesa, ja c'a tziak ja rcojon trij ja rtziak jari' xlasaj can, xuc'am chic jun tziak ja cani' nquecoj ja rilinela' in jari' xucoj chic xe' rupan. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","C'ac'ari' xchomij jun palangana ya' in xumaj rch'ajic cakan ja rdiscípulo. Ja c'a tok nch'ajtaji nusu' tre ja tziak ja rcojon xe' rupan. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ja c'a tok xekaj ruq'uin ja Simón Pedro chi nuch'aj ja rkan quewa' bix tre rmal ja Pedro ri': —Wajaw, taka'an nach'aj wakan, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Xa matich'obtaj amwal camic ja nmajon rbanic chawe pro nerila' na jun k'ij tok nch'obtaj na amwal, ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Ma can ta, atat ni ma yatal ta wi' chawij chi xtach'aj ta wakan, ne'e ja Pedro tre. —Ja wi matinch'aj jari' ma at wachbil chi ta c'ari', ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","C'ac'ari' ja Pedro xbij tre: —Wajaw, ja wi queri' rbanic, ma ruyon ta c'a wakan nach'aj ari', tach'aja' c'a nuk'a' in tabaka' nwi' chakaja', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ja c'a Jesús xbij chic tre: —Jun achi wi rtijon chic atinem jari' ch'ajch'oj chic, ma rjawaxic chi ta tre chi njosk'ix chic, xa ruyon chic rkan nch'aji, in queri' chewe ixix, ix ch'ajch'oji' chic pro ma ewanojelal ta, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Como arja' bien rotak nak ja njacho na rxin pa quek'a' ja netzelan rxin chewi' tok xbij chi: —Ma ewanojelal ta ix ch'ajch'oji', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ja tok ch'ajtaji ja cakan rmal c'ac'ari' xucoj chic ja rtziak ja rwasan can in tz'abe' chic jutij pa mesa in quewa' xbij chic chique ri': —¿La nch'obtaj emwal ja c'a xinban chewe ri'? ");
INSERT INTO tzjNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ixix nebij chwe Maestro, nixche' chwe, in Kajaw, nixche' chwe, in jari' ni rubey wi' ja nebij como ni katzij wi' chi in Emaestro, in Ewajaw chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Anin in Ewajaw, in Emaestro chakaja' pro ma xinpokonaj ta xinch'aj ja rewakan in queri' c'a chewe ixix chakaja' rjawaxic chi matepokonaj nech'aj ja rewakan chibil tak ewi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Jun ejemplo awa' xinya' chewach ri' chi queri' neban ixix chibil tak ewi' ja cani' xinban anin chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ni katzij wi' ja xtinbij chewe ri', jun ilinel ¿la nim ta c'a ruk'ij chwach ja rajaw in jun banol takquil la nim ta c'a ruk'ij chwach ja takyonel rxin? ");
INSERT INTO tzjNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ja wi nch'obtaj emwal ja c'a xinbij chewe ri' jari' congana qui'il chewe pro ja wi nenimaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Pro ma ewanojelal ta ja qui'il chewe como anin wotak jani' ena'oj ja rixncha'on. In ni rjawaxic wi' chi nbantaj na cumplir ja tz'ibtal can chwe ojer chipan ja rtzobal Dios, quewa' nbij ri': —C'o jun xinwachbilaj chi wa'im jari' xoc nc'ulel, yictaj chwij. Queri' tz'ibtal can. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ja xinbij chewe ri' masqui maja'n tibantaji pro nbij chewe camic chi ni nbantaj na wi'. Queri' nbij chewe utzc'a ja tok xtibantaji tokori' bien nch'obtaj emwal nak inocnak wi' utzc'a nenimaj chi nij in quirwari' ja cani' nbinto chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ni katzij wi' ja xtinbij chewe ri', xa nak ta xquec'ulu quixin ja rajsamajela' ja nenutakel, anin c'ari' ninquec'ul chakaja', in xa nak ta xquec'ulu wxin nquec'ul c'ari' chakaja' ja takyonto wxin. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ja tok bitaji tzij ri' rmal c'ac'ari' xumaj jun nimlaj bis, congana lawulo' nuban ranma rmal in xbij chic chique: —Ni katzij wi' ja xtinbij chewe ri', c'o jun chewe, arja' njacho na wxin pa quek'a' ja winak ja netzelan wxin, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ja c'a rdiscípulo eje'e' quemaj rtz'atic qui', matich'obtaj cumal chok tre bix wi' ja tzij. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","C'o jun chique ja rdiscípulo ja congana najo'x rmal, arja' k'eloc ruq'uin ja Jesús pa mesa. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ja c'a Simón Pedro arja' xuban pon ruk'a' chwach ja jun chic discípulo chi nc'axaj tre chok tre bix wi' ja tzij rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ja c'a discípulo como arja' k'eloc chwa ruc'u'x ja Jesús chewi' tok xc'axaj tre: —Kajaw ¿nak chake ja njacho awxin? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—Ja bar xtinya' wi' ja caxlanway ja mu'un, arja' c'ari', ne'e ja Jesús tre. C'ac'ari' xumu' ja caxlanway in tre ja Judas Iscariote xuya' wi', ja rc'ajol Simón. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ja c'a Judas arja' tok c'amtaj rmal ja caxlanway c'ac'ari' xoqui ja Satanás pa ranma in bix tre rmal ja Jesús: —Ja ramajon rch'obic chi naban jat, tabana' chanim, ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pro ja rec'o pa mesa ni majun chique ch'obtaj ta cumal nak tre tok bix queri' tre ja Judas rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ec'oli chique, eje'e' quech'ob kaj chi ja Judas bix tre chi nbe, nerlok'o' ja nc'atzin tre ja wa'im xin nmak'ij owi nta̱kel chi nersipaj jun ti ayuda chique ja tak meba'i' como ja Judas ruq'uin arja' c'o wi' caja xin pwok. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Queri' xuban ja Judas tok chaka maril c'amtaj rmal ja caxlanway be, xelel chiquicojol, ocnak chic ak'a'. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ja c'a tok elnakel chic ja Judas xumaj chic jutij tzij ja Jesús, quewa' xbij chic ri': —Camic ni k'alaj wi' chi congana nim ruk'ij ja Ralc'walaxel ja xoc alaxic cuq'uin ja winak. In jun chic, rmal ja rc'aslemal ja Ralc'walaxel tri' ntz'a̱t wi' chi congana nim ruk'ij ja Dios chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Como ja Dios arja' nya̱' ruk'ij rmal ja rc'aslemal ja Ralc'walaxel rmalc'ari' ja Dios nk'alasaj na chi congana nim ruk'ij ja Ralc'walaxel chakaja', nk'alasaj na chi xa jun quibanon ruq'uin in jari' nk'alasaj chanim. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Chak'laj walc'wal, anin xa jun ti tiempo chic ninq'ueje' checojol. Ninecanoj chi na pro cani' xinbij chique ja jule' chic aj Israel queri' nbij chic chewe ixix camic quewari', ja bar xquinbe chi wi' maquixcowin ixix nixekaj tri'. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","C'o jun c'ac'a mandamiento nbij can chewe ri', tewajo' ewi'. Cani' nbanonto anin chewe nij ixnwajo'onto wi' queri' c'a tebana' ixix chakaja' ni tewajo' wi' ewi'. Jari' ja c'ac'a mandamiento nya' can chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ja wi queri' neban wi newajo' ewi' tri' c'a nixtz'a̱t wi' cumal canojelal ja winak chi ni katzij wi' chi ix ndiscípulo, ne'e ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ja c'a Simón Pedro arja' xbij tre: —Kajaw ¿bar c'a tri' natbe wi'? ne' tre. —Ja bar xquinbe wi', atat macatcowini nattre' chwij camic pro nerila' na jun k'ij ja tok xcattre' na chwij, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—Wajaw ¿nak tre tok ma xquincowin ta xquintre' chawij camic? Anin matinpokonaj nincamsax amwal, ne'e ja Pedro. ");
INSERT INTO tzjNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—¿La ni katzij wi' nabij chi matapokonaj natcamsax mwal? Pro ja xtinbij anin chawe ri' ni katzij wi', ja tok maja'n tok'i ja ac', atat oxmul xtabij chwe chi ma awotak ta nwach, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","C'ac'ari' xbij chic chique: —Maxta ticapuj ec'u'x, ni tiyuke' wi' ec'u'x ruq'uin ja Dios in wq'uin anin chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ja chi rochoch ja Nata' sobre ja lugar c'o chila'. Ja wixta ma queri' ta xinbij ta c'ari' chewe chakaja'. Anin ninbe camic nenchomarsaj na ja lugar ewxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","In como xinbij chewe chi ninbe chi nenchomarsaj ja relugar pro ninmelojpi chic jutij nixunc'ama' kaj utzc'a chi nixq'ueje' chic wq'uin. Queri' nban utzc'a ja bar xquinq'ueje' wi' anin tri' nixq'ueje' wi' ixix chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ixix ewotak ja bar xquinbe wi' in ewotak ja bey chakaja', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ja c'a Tomás arja' xbij tre: —Wajaw, ajoj ma kotak ta ja bar natbe wi' ¿nak moda c'ari' tok nabij chake chi kotak ja bey? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","—Pro anin c'a ja rin bey, wq'uin anin niltaj wi' nojelal ja ni katzij wi' ja ni majun engaño rc'an in anin ninyowi ja utzlaj c'aslemal ja mta q'uisic trij. Mta jun nak ta xtekaj ta ruq'uin ja Tatixel ja maquita yukul ruc'u'x wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ja wixta ch'obtajnakto emwal nabey nak ja kas mero nbanic ch'obtajnak ta c'ari' emwal chakaja' nak rbanic ja Nata' pro ja camic ri' xtich'obtajel emwal nak rbanic ja Nata' in etz'aton chic rwach chakaja', ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ja c'a Felipe arja' xbij tre: —Wajaw, tac'utu' chikawach ja Tatixel in xa ruq'uin ari' nokquicoti, mta nak chi ta nkajo' chawe, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ja c'a Jesús xbij tre: —Felipe ¿nak tre tok nabij queri' chwe chi anin nc'ut chewach ja Tatixel pro tuban wa'an q'uiylaj tiempo inc'ol ewq'uin, la maja'n c'a tich'obtaj amwal ari' nak nbanic? pro ja re'otakyon nwach jari' cotak c'a rwach ari' ja Tatixel. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿La matanimaj chi anin xa jun nbanon ruq'uin ja Tatixel in ja Tatixel arja' xa jun rbanon wq'uin chakaja'? Nojel ja tzij ja nbij chewe ma chaka ta nwinakarsan nojoj nuyon, ja Tatixel ja c'o pa wanma arja' nsamaj pa wanma chi rbanic nojel ja nmajon rbanic. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tenimaj ja nbij chewe chi anin xa jun nbanon ruq'uin ja Tatixel in ja' Tatixel xa jun rbanon wq'uin anin chakaja'. Owi matenimaj ja chaka tzij nban ewq'uin como c'o c'a ja nimak tak milagro nbanon chewach rmaltari' xtenimaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ni katzij wi' ja xtinbij chewe ri', ja winak ja nyuke' quec'u'x wq'uin eje'e' xtiyataj na chique chakaja' chi nqueban ja nimak tak milagro ja cani' nban anin. Xtiyataj na chique chi más chi na nimak tak milagro xtiqueban chwach ja cani' nbanon anin. Queri' nbij chewe como anin ninbe ruq'uin ja Tatixel rmalc'ari' tok xtiyataj na chique chi queri' nqueban. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","In jun chic, nojel ja xtec'utuj tre ja Nata' in wi yukul ec'u'x wq'uin chi rc'utuxic, anin nya' chewe ja nec'utuj. Queri' rbanic utzc'a chi nya̱' na ruk'ij ja Tatixel pro rmal ja Ralc'walaxel tok nya̱' ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","In jutij chic nbij chewe, xa nak ta ja xtec'utuj in wi yukul ec'u'x wq'uin chi rc'utuxic, anin ninyo' chewe ja nec'utuj. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ja wi ni katzij wi' chi ninewajo' jari' nenimaj ja nbij chewe chi neban. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ja c'a ranin nc'utuj na tre ja Tatixel chi arja' nutakto jun chic ja nto'o ewxin ja nq'ueje' ewq'uin pro ni chijutij. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ja nta̱kto chic ewq'uin jari' ja rEspíritu Santo ja ni katzij wi' nojel ja nbij. Ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x eje'e' maquecowini nquech'ob nak rbanic ja rEspíritu Santo in matiquec'ul. Como eje'e' matiquetz'at rwach in nixtac'a cotak ta rwach chewi' tok queri' nqueban. Pro ja rixix ewotak rwach como arja' c'ol ewq'uin in nq'ueje' na pa tak ewanma. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Anin ninbe pro matinban can chewe ix cani' tak ac'ala' ja chaka nemalataji, can ninmelojpi chic jutij ewq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Xajalal maja'n quinbe. Ja c'a tok xquinbe maquinquetz'at chic ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x pro ja rixix ninetz'at chi na. Como anin wc'an ja utzlaj c'aslemal ja mta q'uisic trij rmalari' newc'aj na ixix chakaja' ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ja c'a tok xtipeti ja rEspíritu Santo jari' bien nch'obtaj chic emwal chi anin xa jun kabanon ruq'uin ja Tatixel, bien nch'obtaj chic emwal tri' chi ixix xa jun ebanon wq'uin in anin chakaja' xa jun nbanon ewq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ja winak ja nec'olowi ja ntzobal pa tak canma in wi nquinimaj ja ntzobal tri' netz'a̱t wi' chi ni katzij wi' chi nincajo'. Ja winak ja ne'ajo'n wxin ne'ajo'x c'a eje'e' ari' rmal ja Nata' in ne'ajo'x mwal anin chakaja' in xtink'alasaj wi' chiquewach. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","C'ac'ari' c'oli ja bix tre rmal ja Judas pro ma ja ta ja Judas Iscariote, quewa' bix tre ri': —¿Nak c'a rbanic ari' ja nabij le' chi nak'alasaj awi' chikawach ajoj pro matak'alasaj awi' chiquewach ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x? ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","—Ja winak wi ni katzij wi' chi nincajo' nquinimaj c'ari' ja ntzobal. Ja wi queri' nqueban ne'ajo'x c'ari' rmal ja Nata', ok ca'i' ruq'uin ja Nata' nokekaj cuq'uin in noqui ja canma como kochoch in nokq'ueje' chipan. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ja winak ja maque'ajo'n wxin matiquinimaj c'ari' ja ntzobal. Ja c'a ntzobal ja remajon rc'axaxic camic ma anin ta inwinakarsyon nojoj nuyon, ja Tatixel ja takyonpi wxin arja' biyon chwe. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nojel awa' nbin chewe como c'a inc'o na checojol. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pro ja c'a tok ma inc'o chi ta checojol tokoc'ari' c'o chi na jun nta̱kpi na ewq'uin chi eto'ic jari' ja rEspíritu Santo. Arja' nta̱kto na rmal ja Nata' in pa nubi' anin tok xtitakto. Arja' xtic'utu chic chewach nojelal, arja' nnatan chic chewe nojel ja nbin can chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Anin ninbe pro kas tiquicot can ja rewanma. Anin c'o jun quicotemal wq'uin jari' nya' can chewe pro jari' ma junan ta ruq'uin ja quicotemal ja xa xin rwach'ulew. Maxta ticapuj ec'u'x in maxta texbej ewi' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ixix xec'waxaj ja tok quewa' xinbij chewe ri': —Anin ninbe pro ninmelojpi chi na jutij ewq'uin. Ruq'uin ja Nata' ninbe wi', xinche' chewe. Ja wixta congana ninewajo' xixquicot ta c'ari' ja tok xinbij chewe chi ruq'uin ja Nata' ninbe wi' como ja Nata' arja' más na nim ruk'ij chinwach anin. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Camic nya'on pon chic rbixic chewe nak ja maja'n tiban chwe utzc'a tok xtibantaji tokori' nyuke' ec'u'x wq'uin pro ni chijutij. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Xa jurata chic inc'o checojol chi noktzijon ewq'uin. Queri' nbij chewe como ja Satanás ja nbano mandar wawe' chwach'ulew arja' xajalal maja'n turkaji chi ninurchapa' pro arja' mta ruk'a' chwe, majun nak ta ninrchapbej. ");
INSERT INTO tzjNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Xarwari' anin nya' wi' pa ruk'a' utzc'a chi ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x eje'e' bien ncotakij na chi congana nwajo' ja Tatixel utzc'a bien ncotakij na chi nnimaj ja bin chwe rmal ja Tatixel chi nunbana' kaj. Camic quixyictaji, jo', ko'el chipan ja lugar ri', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","C'ac'ari' xc'ambej tzij chiquewach, quewa' xbij chique ri': —Wq'uin anin nelto wi' ja c'aslemal ja katzij chi c'aslemal, anin in junan ruq'uin ja rkan jun mocaj uva. Ja c'a Nata' arja' junan ruq'uin ja nbano cuenta ja uva in njosk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Arja' nkupijel ja rk'a' uva nojelal ja mta rwach nuya', eje'e' c'ari' ja winak ja chaka ec'oloc wq'uin. Pro ja rk'a' uva ja nwachini jari' njosk'ix rmal ja Nata' utzc'a chi nwachin más. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Pro ja rixix ixjosk'in chic como nojel ja tzij xinbij chewe jari' xixjosk'bexi. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xa jun tebana' wq'uin in xa jun nban anin ewq'uin chakaja'. Cani' tre ja rk'a' uva ja wixta ma jun ta rbanon ruq'uin ja rkan jari' mta moda xtiwachin ta. In queri' chewe ixix chakaja', ja wi ma jun ta neban wq'uin jari' mta moda xtiwachin ta ja rutzil xin Dios pa tak ewanma. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Anin in rkan ja jun mocaj uva, ja c'a rixix ix tak ruk'a'. Xa nak ta chewe wi xa jun nuban wq'uin in wi anin xa jun nban ruq'uin jari' junan ruq'uin ja rk'a' uva ja buena nwachini. Queri' nbij chewe como majun nak ta nixcowini neban ja wi ma jun ta neban wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ja winak ja ma jun ta nqueban wq'uin queri' nba̱n na chique ja cani' nba̱n tre ja rk'a' uva, nkupixel in nchakiji c'ac'ari' nmo̱l ruchi' in nporox pa k'ak'. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ja wi xa jun neban wq'uin wi nq'ueje'e ja ntzobal pa tak ewanma jari' tec'utuj tre ja Dios xa nak ta newajo' in nyataj na chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ja wi buena nwachini ja rutzil xin Dios pa tak ec'aslemal jari' nya̱' ruk'ij ja Nata' cumal ja winak emwal in tri' nixtz'at wi' chi ni katzij wi' chi ix ndiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Cani' rbanon anin chwe ja Tatixel arja' nij inrajo'on wi' in queri' nbanon anin chewe chakaja' nij ixnwajo'on wi' in camic nbij chewe, quixq'ueje' chipan ja rajoben ri'il wxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ja wi ni nenimaj wi' ja nbij chewe chi neban jari' ni nixq'ueje' wi' chipan ja rajoben ri'il wxin, cani' nbanon anin, ni nniman wi' ja bin chwe rmal ja Nata' chi nban in nij inc'o wi' chipan ja rajoben ri'il rxin ja Nata'. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nojel ja c'a xinbij kaj chewe ri' utzc'a chi xtiq'ueje' ta pa tak ewanma ja quicotemal ja c'o pa wanma anin. Xinbij chewe utzc'a chi xtinoj ta ja quicotemal pa tak ewanma. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Cani' nbanon anin chewe nij ixnwajo'on wi' queri' c'a tebana' ixix chakaja' tewajo' ewi', jawa' jun mandamiento nya' can chewe chi neban. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ja tok matapokonaj natcam pa quicuenta ja rawamigo jari' bien k'alaj chi congana ne'awajo', mta jun ajoben ri'il ja queri' chi ta. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ja c'a rixix ix wamigo ja wi nenimaj ja nbij chewe chi neban. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nojel ja nc'waxan ja bin chwe rmal ja Nata' jari' nk'alasan chic chewach in rmalari' nbij chewe chi ix wamigo. Camic ma ja ta nbij chewe chi xa ix nmoso como jun moso arja' ma rotak ta nak ntajini nuch'ob ja rpatrón. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ma ixix ta xixcanon wxin, ja xinban, anin xincanon ewxin chi xixoc apóstol, xinbij chewe chi nixbe nebana' ja nsamaj. Queri' xinban chewe utzc'a chi ja samaj ja nebana' c'oli ja rutzil xin Dios nwachij utzc'a chi ja rutzil ja newachij jari' mta q'uisic trij. Queri' rbanic utzc'a ja Tatixel arja' nuya' na chewe xa nak ta nec'utuj tre ja wi yukul ec'u'x wq'uin chi rc'utuxic. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nojel awa' ja c'a xinbij chewe ri' utzc'a chi newajo' ewi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x ja wi eje'e' xa itzel nixquetz'at bien tech'obo' chi queri' queban anin chwe nabey, itzel xinquetz'at chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ja wixta ix cachbil ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x jari' lok' ta nixquena' ari'. Pro jari' ma ix cachbil ta como anin xixnucha' chiquicojol in xixnparti'ij rmalc'ari' tok itzel nixquetz'at. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Turkaj chewe jun tzij ja xinbij chewe quewari': —Jun moso arja' ma nim ta ruk'ij chwach ja rpatrón, xinche' chewe. Tibij c'a tzij ari' ja wi c'o pokon quibanon anin chwe c'o c'a pokon xtiqueban ari' chewe ixix chakaja'. Ja c'a wi quinimaj ja ntzobal ja xinbij chique jari' xtiquinimaj ja xtebij ixix chique chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pro mwal anin ja tok xtetij pokon pa quek'a'. Eje'e' nqueban na pokon chewe como ma cotak ta jani' rna'oj ja Dios ja takyonto wxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ja wixta maquita xinpeti wixta maquita xink'alasaj chiquewach jani' rna'oj ja Dios jari' mta nechapbexi pro ja camic mta nquitobej qui' xtiquibij ta chi ma quemac ta. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ja winak ja xa itzel ninquetz'at jari' xa itzel nquetz'at ja Nata' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ja wixta maquita xinban ja nimak tak milagro chiquewach, pro jule' milagro ja ni majun nak chi ta banyon, jari' mta nechapbexi pro jari' quetz'at in camic xa itzel ninquetz'at in xa itzel nquetz'at ja Nata' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Queri' nqueban utzc'a chi nbantaj cumplir ja tz'ibtal can chwe chipan ja ley xin Dios ja c'o cuq'uin, quewa' nbij ri': —Eje'e' xa itzel xinquetz'at pro chaka queri' mta wil, mta xinban chique. Queri' ja tz'ibtal can. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pro ja jun chic To'onel ja c'o ruq'uin ja Nata' arja' nkajto na ewq'uin como anin xquintakoto rxin. Arja' ja rEspíritu Santo pro jun Espíritu ja ni katzij wi' nojel ja nbij, jun Espíritu ja ruq'uin Nata' npi wi'. Ja tok xturkaj ewq'uin arja' nk'alasaj na chiquewach ja winak nak inocnak wi' anin. ");
INSERT INTO tzjNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ja c'a rixix chakaja' nek'alasaj na chiquewach ja winak nak inocnak wi' como ixix nij ixc'o wi' wq'uin ja tok xinmajto ja nsamaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nojel awa' ja c'a xinbij kaj chewe ri' utzc'a chi mateya' can ja yukulbal ec'u'x wq'uin ja tok c'oli nak xtipi chewij. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Como ja winak eje'e' nixquich'akijto na pa tak jay xin molbal ri'il ja bar nc'axax wi' ja rtzobal Dios in maquixc'ul chic chipan. In c'uluto, nerila' na jun k'ij ja tok nixquicamsaj in ja pa quetzij eje'e' rvoluntad Dios nqueban ja nixquicamsaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Queri' xtiqueban chewe como eje'e' xa ma cotak ta jani' rna'oj ja Tatixel in nixtac'a cotak ta ja nna'oj anin chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nojel awa' ja xinya' pon rbixic chewe ri' utzc'a tok xtibantaji quewa' nebij ri': —Ja c'awa' bin can chake rmal ja Jesús, xquixche' na. Ma xinbij ta chewe nabey nojel awa' wari' como c'a inc'o na checojol. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pro ja camic como ninbe chewi' tok nbij can chewe. Camic ninmeloj ruq'uin ja takyonto wxin pro ni majun chewe nc'waxaj ta chwe: —¿Bar c'a natbe wi'? ne' ta chwe. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pro ja rebanon, nojnak ja bis pa tak ewanma rmal ja xinbij chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pro nojel ja nmajon rbixic chewe ni katzij wi'. Ja ninel checojol jari' c'oli rc'amonto chewe. Ja wixta maquinbe maquita nkajto ari' ewq'uin ja jun chic To'onel pro ja wi ninbe, anin ninetakoto rxin ewq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Ja c'a tok xtikajto ja jun chic To'onel quewa' ja samaj ja nurbana' kaj ri'. Jun, bien nk'alasaj na chiquewach ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x chi c'oli ja quil quemac quibanon. Como eje'e' ma yukul ta quec'u'x wq'uin chewi' tok xtuch'ob chiquewach chi e aj'il e ajmaqui'. In jun chic ja samaj nurbana' kaj, bien nk'alasaj na chiquewach chi ja Tatixel arja' ni utz wi' ninrutz'at como arja' nuya' na chwe chi tri' ninbe wi' ja bar c'o wi' arja' in maquinetz'at chic. In c'o chic jun ja samaj ja nurbana' kaj, bien nk'alasaj na chiquewach chi ja Dios arja' nuk'et tzij chiquij ja banol tak itzelal como arja' rk'eton chic tzij trij ja Satanás ja nbano mandar wawe' chwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Anin c'a c'o na ja maja'n tinbij chewe pro matich'obtaj emwal ja xtinbij ta chewe camic. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ja tok xtipeti ja rEspíritu Santo ja nk'alasani jani' ja Dios ja ni katzij wi' chi Dios arja' nuc'an ewxin in bien nk'alasaj na chewach nojelal nak ja kas mero rbanic ja Dios. Queri' xtuban como arja' ma chaka ta ruyon xtiwinakarsaj nojoj ja xtibij, ja nbix tre rmal ja Tatixel jari' nbij arja'. In jun chic, arja' nk'alasaj na je'e chewach ja maja'n tibantaji. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ja c'a tok xtipeti jari' nuk'ij anin nurya'a' como arja' nuc'amto na ja c'o pa nuk'a' anin chi nurk'alasaj chewach nak rbanic. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nojel ja c'o ruq'uin ja Tatixel c'o nuk'a' anin tre chakaja' rmalc'ari' tok xinbij chewe chi ja rEspíritu Santo arja' nuc'amto na ja c'o pa nuk'a' anin chi nurk'alasaj chewach nak rbanic. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Xa jurata chic ninq'ueje' checojol in maquinetz'at chic pro xa ma nim ta ja tiempo ja maquinetz'at c'ac'ari' ninetz'at chi na jutij. Queri' nbij chewe como ninbe ruq'uin ja Tatixel. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","C'ac'ari' ec'oli chique ja rdiscípulo quemaj tzij chibil tak qui', quewa' quibij ri': —¿Nak tibij c'awa' ja nbij chake chi: —Xa jurata chic ninq'ueje' checojol in maquinetz'at chic pro xa ma nim ta ja tiempo ja maquinetz'at c'ac'ari' ninetz'at chi na jutij, taka'an ne' chake, in ja jun chic nbij chakaja' chi: —Queri' nbij chewe como ninbe ruq'uin ja Tatixel? taka'an ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Nak tibij c'awa' ja nbij xa jurata? taka'an matich'obtaj kumal ja nbij, neche'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ja c'a Jesús arja' rotak chi ncajo' nquic'axaj tre nak rbanic in xbij chique: —¿La ja' nec'waxaj chibil tak ewi' ja xinbij chewe chi xa jurata chic ninq'ueje' checojol in maquinetz'at chic pro xa ma nim ta ja tiempo ja maquinetz'at c'ac'ari' ninetz'at chi na jutij? ");
INSERT INTO tzjNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ni katzij wi' ja xtinbij chewe ri', ixix nixok' na, nixbison na pro ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x eje'e' nequicot na. Pro masqui xquixbisoni pro jari' bis chaka jalal tok xtoc'owi in nwinakar chi na jun quicotemal pa tak ewanma. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Cani' nuban jun ixok ja tok xajalal maja'n tiq'ueje'e jun ti ral, arja' lawulo' nuban rmal ja rti'obal como xurwila' ja hora chi nq'ueje'e ja ti ral. Pro ja te'ej tok c'o chic ja tac'al jari' matinataj chic rmal ja ti'onem ja k'ax trij. Matinataj chic pro rumac ja quicotemal ja c'o chic pa ranma como c'o chic jun ti yaqui' xuya' chwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Queri' c'a chewe ixix chakaja' camic, emajon bis pro nutz'at chi na jutij ri' kawach ewq'uin, janila xquixquicot rmal pro jun quicotemal ja majun nak ta xtiwasan ta chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ja c'a tok xterila' ri' k'ij tokori' ma rjawaxic chi ta chewe chi c'o chi ta xtec'waxaj chi ta chwe. Ni katzij wi' ja xtinbij chewe ri', xa nak ta ja xtec'utuj tre ja Tatixel wi pa nubi' anin nec'utuj wi yukul ec'u'x wq'uin chi rc'utuxic arja' nuya' chewe. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ja cani' ebanonto mta ec'utun pan oración ja pa nubi' ta anin. Pro ja camic anin nbij chewe, tec'utuj in nyataj chewe. Quirtari' neban utzc'a chi xtinoj ta ja quicotemal xin Dios pa tak ewanma. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nojel awa' ja nbin chewe ri' c'o je'e c'ambal tak tzij xincoj chi rbixic ja ma xel ta claro chewach. Pro nerila' na jun k'ij tok ma rjawaxic chi ta xkotzijon chi ta ewq'uin pa c'ambal tak tzij tokoc'ari' bien nk'alasaj na chewach nak rbanic ja Tatixel. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ja c'a tok xterila' ja k'ij tokori' tok pa nubi' anin nec'utuj tre ja Tatixel nak ja kas newajo'. Pro ma rjawaxic ta ja kas ta na nbochi'ij ja Tatixel chi nuya' chewe ja nec'utuj tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Arja' nuya' chewe como nixrajo' xa chewi' tok nuya' chewe. Queri' nuban chewe como ixix ninewajo' in chakaja' nenimaj chi ruq'uin ja Dios inpenak wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ruq'uin ja Tatixel inelnakto wi', inpenak wawe' chwach'ulew in camic nya' can ja rwach'ulew, ninmeloj chic jutij ruq'uin ja Tatixel. Queri' xbij ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ja c'a rdiscípulo eje'e' quibij tre: —Camic bien taka'an claro xel chikawach ja c'a xabij le', jala' ma c'ambal tzij ta. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ja camic bien ch'obtajnak chic kumal chi atat nojel awotak, ma rjawaxic ta chawe chi nac'waxaj ta na ja nkac'axaj chawe como jari' awotak chic tok maja'n tikac'axaj chawe rmalc'ari' nkanimaj chi ruq'uin ja Dios atpenak wi', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ja c'a Jesús xbij chique: —¿La ni katzij wi' chi nenimaj chi ruq'uin ja Dios inpenak wi'? ");
INSERT INTO tzjNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pro nerila' na wa'an jun hora ja tok nineya' can ti nuyon in jari' xajalal nrajo' chi nbantaj cumplir. Jari' hora nixchicaxi, nixanmaji in nixbe chi ewochoch chejujunal. Pro masqui nineya' can pro ma nuyon ta anin ja ninq'ueje' can como ja Tatixel arja' ni c'o wi' wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nojel awa' ja xinbij chewe chipan awa' jun tucwak'abil ri' utzc'a chi nyataj na chewe ja quicotemal xin Dios ja tok xa jun chic ebanon wq'uin. Ja chipan awa' rwach'ulew ri' congana rpokonal xtetij na pro quixquicoti como ja ritzelal rxin ja rwach'ulew jari' ni ma cowinnak ta wi' chwij, nij anin wi' inch'ocmajnak. Queri' xbij ja Jesús chique ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ja Jesús tok bitaj rmal ja tzij ri' ca'y chicaj in xumaj chic rbanic oración, quewa' xbij tre ja Tatixel ri': —Nata', camic xurwila' ja hora, tabana' c'a chwe ja nak'alasbej chiquewach ja winak chi congana nim nuk'ij ja rin Alc'walaxel, queri' ta naban chwe utzc'a chi anin natnk'alasaj chic atat chiquewach chakaja' chi congana nim ak'ij. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Como atat aya'on chwe chi c'o nuk'a' chique canojelal ja winak. Queri' abanon chwe utzc'a chi anin c'oli ja utzlaj c'aslemal nya' chique canojel ja winak ja re'aya'on chwe pro jun utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ja utzlaj c'aslemal ja mta q'uisic trij quewa' rbanic ri', ja winak tok cotak jani' ja rana'oj atat ja xa ayon chi ni katzij wi' chi at Dios in tok cotak jani' nna'oj anin ja rin Jesucristo ja rinatakonto wawe' chwach'ulew jari' cuc'an ja utzlaj c'aslemal ja mta q'uisic trij. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Anin nya'on ak'ij wawe' chwach'ulew, xinq'uis rbanic nojel ja samaj ja raya'on chwe chi nban. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Camic Nata', taya'a' chwe chi queri' nkaban chic awq'uin pa gloria ja cani' kabanon nabey ja tok maja'n titz'ucarsaxi ja rwach'ulew, congana nim nuk'ij tri'. Taya'a' chwe chi ninbe chic jutij awq'uin pa gloria ja bar nk'alajin wi' chi congana nim nuk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ec'oli ja rachi'i' ja re'acha'on chiquicojol ja winak wawe' chwach'ulew, eje'e' e'aya'on chwe. Anin bien xink'alasaj chiquewach jani' ja rana'oj. Eje'e' nij e awxin wi' in camic e'aya'on chwe, quiniman ja ratzobal. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Eje'e' cotak chic camic chi awq'uin atat penak wi' nojel ja xinban ja raya'on chwe chi xinban. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Como anin nbin chic chique nojel ja rabin chwe. Eje'e' quiniman chic ja nbin chique in camic bien cotak chi awq'uin atat inpenak wi', nquinimaj chi atat attakyonto wxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ja camic nintajini nban orar pa quicuenta eje'e', ma pa quicuenta ta ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x. Nintajini nban orar pa quicuenta ja re'aya'on chwe como e awxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Canojel ja re wxin anin e awxin atat chakaja', canojel ja re awxin atat e wxin anin chakaja'. Como xa jun kabanon cuq'uin chewi' tok ruq'uin ja quic'aslemal ntz'attaj wi' chi janila nim nuk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Padre Santo, camic maquinq'ueje' chic más wawe' chwach'ulew pro ja reje'e' neq'ueje' na pro ja ranin ninmeloj chic jutij awq'uin. Pan abi' atat que'achajij can que'awaraj can ja re'aya'on chwe utzc'a xta jun xtiqueban ja cani' kabanon ajoj awq'uin xa jun kabanon. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Anin tok xinq'ueje' cuq'uin wawe' chwach'ulew pan abi' atat xenuban cuenta, majun nak ta chique xtz'ila' ta ri', xa jun chique ja xtz'ila' ri' pro jari' ja ni yatal wi' trij chi nutij pokon chipan ja juicio. Queri' xuban utzc'a chi nbantaj cumplir ja tz'ibtal can ojer chipan ja rtzobal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Pro ja camic anin ninmeloj awq'uin in nojel awa' ja nintajini nbij chawe camic ri' ni chiquewach eje'e' nbij can wi' wawe' chwach'ulew utzc'a chi xtinoj ta pa tak canma ja quicotemal ja c'o wq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Anin bien xink'alasaj chiquewach ja ratzobal ja rabin chwe in camic xa itzel netz'a̱t cumal ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x como eje'e' ma ruq'uin ta rwach'ulew yukul wi' quec'u'x in cani' chwe anin chakaja' ma ruq'uin ta rwach'ulew yukul wi' nuc'u'x. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ma ja ta nc'utuj chawe chi ne'awasajel wawe' chwach'ulew xquebe ta awq'uin camic ri', ja nwajo' chawe chi ne'aban cuenta wawe' chwach'ulew utzc'a chi maquech'ac rmal ja ritzelal. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Eje'e' ma ruq'uin ta rwach'ulew yukul wi' quec'u'x cani' chwe anin chakaja' ma ruq'uin ta rwach'ulew yukul wi' nuc'u'x. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Camic que'aparti'ij, tach'ach'ojirsaj ja canma tre ja ratzobal como ruq'uin ja ratzobal nkatz'at wi' nak ja kas mero abanic ja katzij chi at Dios. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Cani' abanon chwe xinatakto wawe' chwach'ulew queri' c'a nban anin chique chakaja' nchomarsan chic chi nenutakel chwach ja rwach'ulew chi nequibana' ja rasamaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Camic anin nparti'ij wi' chi solo avoluntad atat nban pro cumal eje'e' ja tok nban queri'. Queri' nban utzc'a chi neparti'ix chic eje'e' chakaja' chi solo avoluntad atat nqueban pro rumac ja neq'ueje' chipan ja ratzobal ja nk'alasan chiquewach nak ja kas mero abanic ja ni katzij wi' chi at Dios. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Pro ma queyon ta eje'e' nmajon rbanic oración pa quicuenta como eje'e' nqueya' na nbixic chique jule' chic in rmal ja xtiquibij ec'o chi na jule' ja xtiyuke' na quec'u'x wq'uin in camic nban orar pa quicuenta eje'e' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Camic nban pon orar pa quicuenta utzc'a chi xta jun xtiqueban canojelal ja winak ja nyuke' quec'u'x wq'uin cani' kabanon ajoj awq'uin Nata' como atat xa jun abanon wq'uin in xa jun nbanon anin awq'uin chakaja'. Ja kas ngana anin xta jun xtiqueban kuq'uin canojelal utzc'a ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x eje'e' xtiquinimaj chi atat attakyonto wxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Cani' aya'on chwe chi bien k'alaj chi atat atc'ayon ja nc'aslemal in queri' nbanon anin chakaja', nya'on chique chi bien k'alaj chi atat atc'ayon ja quic'aslemal eje'e' chakaja'. Queri' nbanon chique utzc'a chi xta jun xtiqueban ja cani' kabanon ajoj awq'uin como xa jun kabanon. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Quewa' neli ri', anin xa jun nban cuq'uin in atat chakaja' xa jun naban wq'uin utzc'a tok xtiq'uiswani mta ari' ja maquita jun nqueban. Queri' nwajo' utzc'a ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x eje'e' xticotakij na chi atat attakyonto wxin utzc'a chi xticotakij na chakaja' chi congana ne'awajo' ja winak ja xa jun quibanon wq'uin ja cani' abanon chwe como congana ninawajo'. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Nata', ja winak ja re'aya'on chwe c'o ngana chi tri' ne'eq'ueje' wi' ja bar xquineq'ueje' wi' anin. Queri' nwajo' chique utzc'a chi necowini nquetz'at ja nimlaj gloria xin Dios wc'an ja cani' aya'on chwe. Como atat nij inawajo'onto wi' ja tok maja'n titz'ucarsaxto ja rwach'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nata', atat nij at utzlaj k'etol tzij wi' pro ja winak ja xa ruq'uin rwach'ulew yukul wi' quec'u'x eje'e' xa ma cotak ta jani' ja rana'oj pro ja ranin wotak in chakaja' ja winak ja rec'o wq'uin ja re'aya'on chwe eje'e' cotak chi atat attakyonto wxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Anin nk'alasan chic chiquewach jani' ja rana'oj in can nk'alasaj na más chiquewach chakaja'. Queri' xtinban chique utzc'a chi nq'ueje' pa tak canma ja mismo ajoben ri'il ja cani' inawajoben anin utzc'a chi ninq'ueje' anin pa tak canma chakaja'. Queri' xbij ja Jesús tre ja Tatixel. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ja tok bitaji tzij ri' rmal ja Jesús c'ac'ari' xerachbilajel ja rdiscípulo. C'o jun siwan rbina'an Cedrón xebe chajuparaj. Tri' c'o wi' jun lugar ticon jule' che' chwach. Ja c'a tok xe'ekaji xe'oc chipan ja lugar. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ja Jesús e rachbil ja rdiscípulo eje'e' q'uiylaj mul quimolon qui' chipan ari' lugar in xa rmalari' ja Judas arja' bien rotak ja lugar. Jari' mismo Judas ja rchomarsan chic chi nujach ja Jesús pa quek'a' ja winak ja netzelan rxin. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ja c'a Judas arja' xe'erc'ama' jule' soldado e rachbil jule' pulisiya' ja nesamaj pa quicuenta ja jefe quixin sacerdote in pa quicuenta ja fariseo. Ja tok xec'amtaj rmal c'ac'ari' xuc'amel chic quebey, xebe chipan ja lugar. C'o k'ak' quec'amel ja nquitz'atbej quebey in c'oli banbal tak ch'a'oj quec'amel chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ja c'a tok xe'ekaji xelto ja Jesús xe'urc'ulu' como arja' bien rotak chic nojel ja maja'n tiban tre. Quewa' xbij ja Jesús chique ri': —¿Nak necanoj? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesús ja raj Nazaret nkacanoj, xeche' tre. —Anin, ne' chic ja Jesús chique. C'oli ja Judas chiquicojol ja njacho rxin ja Jesús pa quek'a'. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ja c'a tok bix chique rmal ja Jesús chi: —Anin, xeche'xi, c'ac'ari' xemeloj chiquij in xebe pa tok'ulew. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ja c'a Jesús arja' xc'axaj chic jutij chique: —¿Nak necanoj? ne' chic chique. —Jesús ja raj Nazaret nkacanoj, xeche' chic tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Nbin chic chewe chi anin. Pro wi anin ja ninecanoj teya'a' lugar chique ja wachbil ja rec'o wq'uin chi nebe, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Queri' xbij chique utzc'a chi nbantaj cumplir ja tzij ja xbij tre ja Tatixel quewari': —Ja re'aya'on chwe ni majun nak ta chique xinban ta perder, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Peti ja Simón Pedro rc'an jun espada, xwasajto ja respada in xusoc jun achi tre, xkupijel jun rxquin ja c'o pa riquik'a'. Ja rachi ja soqui Malco rubi', arja' jun moso rxin ja lok'laj sacerdote. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pro ja Jesús arja' xbij tre ja Pedro: —Tac'olo' ja respada pa rc'olibal como c'o jun rpokonal chomin rmal ja Nata' chi ntij in ni rjawaxic wi' chi nink'ax chipan, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","C'ac'ari' chapi ja Jesús cumal ja soldado e cachbil ja capitán ja pa'l chiquij e cachbil chakaja' ja pulisiya' quixin ja raj Israel. Ja tok chaptaj cumal quebac'. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ja c'a tok bac'taj cumal c'ac'ari' quec'amel. Chwach Anás quec'amel wi' nabey, ja rji'nam ja Caifás. Chipan ari' juna' ocnak lok'laj sacerdote ja Caifás. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jari' mismo Caifás ja biyon chique ja rach tak aj Israel chi: —Más na utz nokeli ja xa jun ncam pa kaq'uexwach ja rok aj Israel chwach ja nq'uisi chi jun ja tinamit. Queri' ja rbin chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ja c'a Simón Pedro rachbil jun chic discípulo eje'e' quitrarbejel ja Jesús. Ja jun chic discípulo arja' otakin rwach rmal ja lok'laj sacerdote in tok xoqui ja Jesús chwa jay ruq'uin ja lok'laj sacerdote xoc arja' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pro ja Pedro arja' q'ueje' can, ma xoc ta. Ja c'a discípulo ja otakin rwach rmal ja lok'laj sacerdote arja' meloji ja bar ocnakto wi'. Tri' c'o wi' jun xtan ja nchajini ja ruchi' ja bar natoc wi'. Ja discípulo xbij tre ja xtan chi nucojto ja Pedro c'ac'ari' xocto ja Pedro. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ja c'a tok ocnakto chic ja Pedro bix tre rmal ja xtan: —¿La maxta atat jun chakaja' at discípulo rxin ja rachi le' ja rbina'an Jesús? ne'xi. —Mni wa'an, ne'e ja Pedro. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ec'o jule' moso ja nesamaj pa jay e cachbil ja pulisiya' ja nechajin rxin ja Jesús, c'o jun k'ak' quiboxon como congana tew quimajon rmak'ic qui' epa'l chuchi'. Ja c'a Pedro arja' jun pa'loc cuq'uin chuchi' ja k'ak', rmajon rmak'ic ri'. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ja c'a Jesús arja' majtaj rc'otic ruchi' rmal ja lok'laj sacerdote, quewa' c'axax tre ri': —¿Echinatak ja radiscípulo in nak rbanic ja tijonem naya'? ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ja c'a Jesús xbij tre: —Pro ma pan awatal ta wa'an tok xinya' ja tijonem, ni chiquewach ja winak xintzijon wi'. Xentijoj pa tak jay xin molbal ri'il, xentijoj chipan ja nimlaj templo xin Dios como ni tri' wi' nquemol wi' qui' ja raj Israel in ni majun nak ta ja chaka ta pan awatali xinbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Nak tre tok chwe anin nac'waxaj wi' nak rbanic? Como ja winak ja xentijoj eje'e' bien cotak ja tijonem xinya', mejor chique c'a tac'waxaj wi' nak rbanic ja nbin chique, ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ja Jesús tok bitaj rmal ja tzij ri' c'o jun chique ja pulisiya' ja rec'o tri' xuya' jun k'a' chi rpalaj in xbij tre: —¿La rubey ta c'a ja chaka quela' nac'ulba'? Makana' maquita lok'laj sacerdote ja ntzijon awq'uin, ne'xi rmal ja pulisi'y. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ja c'a Jesús quewa' xbij tre ri': —Ja wi ma utz ta ja xinbij tabij c'a chwe nak ja ma utz ta xinbij nowi rubey ja xinbij ¿nak c'a tre tok xinach'ay? Queri' xbij tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","C'ac'ari' ja Anás xutakel chic ja Jesús chwach ja Caifás ja lok'laj sacerdote, ni c'a bac'on na wi' ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ja c'a Simón Pedro arja' kas pa'loc chi' k'ak', rmajon rmak'ic ri' ja tok c'axax tre: —¿La maxta atat jun chakaja' at discípulo rxin ja Jesús? ne'xi. Pro ja Pedro ma xuya' ta trij: —Ma anin ta, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","C'o c'a jun chique ja moso rxin ja lok'laj sacerdote, arja' rch'alal ja rachi ja kupixel rxquin rmal ja Pedro, arja' xc'axaj tre: —¿La ma atat ta c'a xatnutz'at chipan ja lugar ja bar chaptaj wi' ja Jesús, la ma awachbilan ta c'a tri'? ne' tre ja Pedro. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pro ja Pedro arja' ni ma xuya' ta wi' trij in chaka jalal ja tok xok'i ja ac'. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","C'ac'ari' quec'amel chic jutij ja Jesús, xe'elel ruq'uin ja Caifás xebe chic ja bar c'o wi' ja jay rxin ja gobernador. Kas nsakari xebe. Ja c'a tok xe'ekaji ma xe'oc ta chipan ja jay como c'o jun costumbre quiniman chi jun aj Israel xajan wi noc pa jay ruq'uin jun winak ja ma rach aj Israel ta. In jun chic quiniman, wi xatoqui pa jay ruq'uin jari' xajan chic nati' ja nti'i cumal ja raj Israel chipan ja nmak'ij pascua. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Xelto ja gobernador Pilato chipan ja jay in quewa' xbij chique ri': —Ja rachi ja rec'amonto ¿la c'o ril nebij? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Ja wixta maquita itzel achi maquita c'a nurkajacha' ari' pan ak'a', xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","—Mejor tec'ama'el ixix. Como c'oli ja ley ewxin jari' tecojo' chi nek'etbej tzij trij, ne'e ja Pilato chique. —Pro jari' ch'a'oj rij ajoj ta xtikak'et ta tzij trij jun winak chi nkacamsaj, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ja tok quibij chi ma eje'e' ta nek'eto tzij trij ja Jesús chi nquicamsaj, tri' bantaj wi' cumplir ja rbin chic ja Jesús como arja' rbin pon chic nak xtiban na tre ja tok xticamsaxi. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","C'ac'ari' xoc chic jutij ja Pilato chipan ja jay, xutak rsiq'uixic ja Jesús in quewa' xc'axaj tre ri': —¿La atat ja rat rey quixin ja tinamit Israel? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ja c'a Jesús xbij tre: —¿La nach'ob atat chi in rey quixin xa chewi' tok nac'waxaj chwe owi la xa rmal ja bin chawe cumal jule' chic winak? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—¿La in aj Israel la'an anin chewi' tok nabij queri' chwe? Ja jefe quixin sacerdote e cachbil jule' chic awach tak aj Israel eje'e' atquijachon pa nuk'a' camic ¿nak c'a awil abanon? ne' chic ja Pilato tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ja c'a Jesús quewa' xbij chic tre ri': —Anin c'o jun gobierno pa nuk'a' pro jari' ma xin rwach'ulew ta. Ja wixta xin rwach'ulew neyictaj ta c'ari' ja rajsamajela' ja rec'o pa ncuenta utzc'a chi maquinjach pa quek'a' ja raj Israel. Pro ma xin rwach'ulew ta ja ngobierno anin, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—¿La katzij chi at rey? ne'e ja Pilato tre. Ja c'a Jesús xbij chic tre: —In rey nac'a cani' c'a xabij kaj, xc'a rmalari' tok inpenak wawe' chwach'ulew, xc'a rmalari' chakaja' tok xinalaxi. Inpenak chi rk'alasaxic chiquewach ja winak nak ja kas mero rbey Dios. Canojel ja winak ja c'o quigana ruq'uin ja rbey Dios eje'e' nqueya' quixquin tre chi rc'axaxic ja nmajon rbixic chique, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—Pro nak la ja rbey Dios, ne'e ja Pilato tre. Ja Pilato tok bitaji tzij ri' rmal xelto chic jutij chipan ja jay in quewa' xbij chique ja raj Israel ri': —Ja ntz'at anin ni majun ril ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pro ixix c'amonnak chewe chi c'o jun preso ewach aj tinamit nsokpijel pa tak nmak'ij pascua. Camic tebij chwe ¿la c'ol egana chi nsokpijel ja rey ewxin ja rix aj Israel? ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pro ja reje'e' quemaj chic jutij rakoj quechi', quewa' quibij ri': —Mejor, Barrabás ja nasokpijel, ma Jesús ta, xeche'e. Pro ja Barrabás arja' xa jun alak'om. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ja c'a Pilato arja' xuc'amel ja Jesús in xuya' orden chi rapaxi. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ja c'a soldado c'o jun corona quichomarsaj, q'uix quecoj. Ja tok chomarstaj cumal quecoj pa rwi' ja Jesús. In c'o jun tziak morada quecoj tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","C'ac'ari' queya' jun saludo tre pro jari' xa nquiyok'bej rxin: —Atat at rey quixin ja tinamit Israel, queri' quibij tre in queya' k'a' chi rpalaj chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Xelto chic jutij ja Pilato chipan ja k'etbaltzij in xbij chique ja raj Israel: —Tetz'ata' mpe' ri', camic npaba' chewach ja Jesús utzc'a chi newotakij chi anin ni majun ril nak ta xinwil, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","C'ac'ari' xelto ja Jesús, rcojon ja corona ja q'uix ocnak in chakaja' rcojon ja tziak ja morada. —Tetz'ata' mpe' ja rachi ri', ne'e ja Pilato chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ja c'a jefe quixin sacerdote e cachbil ja pulisiya' eje'e' tok quetz'at ja Jesús quemaj rakoj quechi': —Tacamsaj chwach cruz, tacamsaj chwach cruz, xeche'e. —Pro ja ntz'at anin ni majun ril, mejor tec'ama'el ixix, ixix c'ala' nixripo rxin chwach cruz, ne'e ja Pilato chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","—Ajoj c'o jun ley kaxin in jari' ley nbini chi yatal trij ala' jun achi le' chi ncamsaxi como arja' xbij: —Anin ja rin Ralc'wal Dios, kas ne'e, queri' quibij tre ja Pilato. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ja c'a Pilato arja' tok xc'axaj chi queri' rbin ja Jesús más chi na xbej ri' rmal. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Xoc chic jutij chipan ja jay in xc'axaj chic tre ja Jesús: —¿Bar c'a kas atpenak wi'? ne' tre. Pro ja Jesús arja' ma xc'ulba' ta ja c'axax tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ja c'a Pilato xbij chic tre: —¿Nak tre tok matac'ulba' ja nc'waxaj chawe? ¿La ma awotak ta c'a chi anin c'o nuk'a' chawe ja wi natnsokpijel owi nya' orden chi natrip chwach cruz? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—Ja wixta maquita yatajnak chawe rmal ja Dios ja c'o chila' chicaj ni ta c'a majun ak'a' ari' chwe. Rmalc'ari' nbij chawe camic, más chi na nim ja ril ja jacho wxin pan ak'a', ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ja c'a Pilato tok xc'axaj ja bix chic tre congana xutij ruk'ij chi nsokpijel ja Jesús pro ja raj Israel eje'e' quemaj chic jutij rakoj quechi', quewa' quibij tre ri': —Atat, wi nasokpijel ja rachi le' jari' ma at ramigo ta ja nimlaj rey César. Como ja rachi le' arja' xucoj ri' como rey in xa nak ta ja nucoj kaj ri' ruyon como rey arja' rc'ulel ja César, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ja c'a Pilato tok xc'axaj ja quibij tre c'ac'ari' xerc'ama'pi chic jutij ja Jesús. C'ac'ari' tz'abe' chipan ja lugar ja bar nbij wi' tre jun preso ja wi c'o ril owi mta. Jari' lugar c'o rubi' nbixi, Ja Lugar Empedrado ne'xi, ja c'a chipan ja tzobal hebreo Gabata ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pa jun pispra rxin nmak'ij pascua bantaj wi' ja wari', pa nc'ajk'ij lari' ja tok bantaji. Tzijon chic jutij ja Pilato cuq'uin ja raj Israel, quewa' xbij chique ri': —Tetz'ata' mpe' ri', wawe' c'o wi' ja rey ewxin, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","—Tacamsaj, tacamsaj, chwach cruz tacamsaj wi'. Queri' quibij. Ja c'a Pilato xbij chic chique: —¿La c'ol egana chi nrip chwa cruz ja rey ewxin? ne' chique. Ja c'a jefe quixin sacerdote eje'e' quibij tre: —Mchita jun rey ja c'o chi ta ruk'a' chake, xa ni ruyon wi' ja César, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","C'ac'ari' jachi ja Jesús pa quek'a' rmal ja Pilato chi ncamsax chwach cruz. Ja tok jachtaj rmal c'ac'ari' c'amarel. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Queri' xuban ja Jesús, be. C'o jun cruz rijkajel, be chipan jun lugar rbina'an Rwi'camnak. Ja c'a chipan ja tzobal hebreo Gólgota ne'xi ja lugar. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ja c'a tok xe'ekaji tri' querip wi' ja Jesús chwach cruz. Ec'o chi na ca'i' achi'i' xequerip chwach jujun cruz chakaja', e jujun pa tak rxquin ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ja Pilato arja' c'o jule' tz'ibanem xuban in xuya' parwi' ja cruz, quewa' nbij ja tz'ibanem ri': —Jesús aj Nazaret, rey quixin ja tinamit Israel, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","E q'uiy chique ja raj Israel ja xetz'atowi ja tz'ibanem como ja lugar ja bar rip wi' ja Jesús chwach cruz xa chinakaj ja tinamit c'o wi'. Ja tz'ibanem oxi' rwach ja tzobal tz'ibax wi', jun pan hebreo, jun pa griego in jun pa latín. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pro ja jefe quixin sacerdote quixin ja raj Israel eje'e' quibij tre ja Pilato: —Ajoj ma ok conforme ta ruq'uin ja tzij ja xatz'ibaj chi arja' rey kaxin ja rok aj Israel. Mejor ja naban, quewa' tatz'ibaj ri' chi arja' nbini chi: —In rey quixin ja raj Israel, ne'e, xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Ja xintz'ibaj, xintz'ibaj ari', xeche'xi rmal ja Pilato. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ja c'a re quiji' soldado tok quiripon chic ja Jesús chwach cruz c'ac'ari' quejal ja rtziak in quejach chiquewach, jujun quixin ja tziak. Pro c'o chi na jun ja tziak ja ni majun dison wi', xa jun chi quiemic. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Rmalc'ari' ja soldado quewa' quibij chibil tak qui' ri': —Mejor matikarak ja wari', kabana' suerte trij nak xtikajben chake, xeche'e. Queri' queban in tri' bantaj wi' cumplir ja tz'ibtal can ojer chipan ja rtzobal Dios, quewa' nbij ri': —Quejach ja ntziak chiquewach in c'o jun ja ntziak queban suerte trij, queri' ja tz'ibtal can in ni queri' queban ja soldado. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ja c'a rute' ja Jesús rachbil jun ruchak' ec'o chinakaj ja cruz e rachbil chic ca'i' ixoki', jun María ja rxjayil Cleofas in jun chic María Magdalena rubi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ja Jesús xutz'at ja rute' in c'oli ja discípulo xutz'at chakaja' ja congana nrajo'. Ja c'a tok xutz'at chi ec'o chirnakaj quewa' xbij tre ja rute' ri': —Jala' jun ndiscípulo le' jala' noc chic awal, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","C'ac'ari' xbij tre ja rdiscípulo: —Ja nute' le' jala' noc chic ate' atat, ne' tre. Ja c'a discípulo tok meloji xuc'amel ja rute' ja Jesús in xuc'ul chijutij pa rochoch. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ja Jesús arja' rotak chi tzurnak chic rmal nojelal ja samaj ja yatajnak tre chi nurbana' c'ac'ari' xbij: —Chakichi' nna', ne'e. Ja tok xbij awa' tzij ri' tri' bantaj wi' cumplir ja tz'ibtal can ojer chipan ja rtzobal Dios. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tri' c'o wi' jule' vinagre c'olon pa rc'olibal. Ja c'a soldado eje'e' quec'am jun esponja, quexim chutza'm jun che', quich'akba' tre ja vinagre c'ac'ari' queya' nojoj chwa rey ja Jesús in xutij. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ja c'a tok titaj rmal quewa' xbij ri': —Camic xinq'uis rbanic ja nsamaj nojelal, ne'e. C'ac'ari' k'ochk'o' kaj ja rwi', xujach ja ranma pa ruk'a' ja Dios in cam kaj. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Como jari' k'ij pispra rxin ja nmak'ij pascua in pispra rxin ja xula'nbal k'ij chakaja' rmalc'ari' tok ja raj Israel eje'e' quic'utuj tre ja Pilato chi nk'i̱p cakan ja rec'o chwach cruz utzc'a chi necami chanim in newasaxel. Queri' queban utzc'a ja quicuerpo matiq'ueje' chwach cruz chipan ja xula'nbal k'ij como jari' xula'nbal k'ij nmak'ij pascua chakaja' in congana nim ruk'ij. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ja c'a soldado eje'e' xe'ekaj cuq'uin ja re ca'i' achi'i' ja reripon chwach cruz pa tak rxquin ja Jesús in quek'ip cakan. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pro ja tok quetz'at ja Jesús chi camnak chic ma xquek'ip chi ta ja rkan. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pro c'o jun chique ja soldado, arja' xumin jun lanza pa rupox ja Jesús in chanim xelto jule' quic' rachbil ya'. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jawa' ja bantaji ri' anin xintz'at ruq'uin nwach in ja xintz'at jari' nya'on chic rbixic in bien wotak chi ni katzij wi' in camic nbij chic chewe utzc'a chi nenimaj ixix chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Queri' bantaji como ni rjawaxic wi' chi bantaj cumplir ja tz'ibtal can tre ja Cristo chipan ja rtzobal Dios ojer como quewa' nbij ri': —Ni majun rbakil xtik'ip ta, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","In jun chic ja tz'ibtal can tre quewa' nbij ri': —Eje'e' nquetz'at na rwach ja c'o jun ch'ich' min pa rupox cumal, ne'e. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","C'o c'a jun achi José rubi' aj Arimatea, arja' jun discípulo rxin ja Jesús, be ruq'uin ja Pilato chi nerc'utuj tre ja cuerpo rxin ja Jesús. Pro xa pan awatali tok be como arja' nxbej ri' chiquewach ja rach tak aj Israel. Ja c'a tok xekaji ruq'uin ja Pilato ya' lugar tre rmal chi nuc'amel ja cuerpo in queri' xuban xuc'amel. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","In xekaji ja Nicodemo chakaja', jari' mismo Nicodemo ja xuban jutij be ruq'uin ja Jesús chak'a' xerk'ijla'. Arja' c'o la jun quintal ak'om rc'amonto congana qui' rxula', ca'i' rwach ja rak'om, jule' mirra ne'xi, in jule' chic áloes ne'xi. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ja Nicodemo rachbil ja José eje'e' quec'am ja cuerpo rxin ja Jesús, quecoj ja rak'om trij jule' tziak in quebar ja cuerpo rxin ja Jesús chipan. Niquirwari' ja quicostumbre ja raj Israel tok c'o jun mukuninem nbani. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ja bar rip wi' ja Jesús chwach cruz tri' c'o wi' jun lugar c'o jule' tijco'm ticon chwach. C'o jun jul xin camnak chipan ja lugar. Ja jul jari' c'oton chwach jun portales pro c'a rc'otic wi', ni mta wi' jutij cojon ta jun camnak chipan. ");
INSERT INTO tzjNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Como xa nakaj c'o pon wi' ja jul rmalc'ari' tok queya' can ja cuerpo rxin ja Jesús chipan. Queri' queban como xa nnakajinto ja hora ja numajel wi' ja nmak'ij pascua. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ja c'a xin domingo be ja María Magdalena ja bar mukun wi' ja Jesús, chanim be, c'a k'eku'm na. Ja c'a tok xekaji xutz'at ja nimlaj abaj ja tz'apben ruchi' ja panteón, junwi' ya'on pon chi wi'. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","C'amc'ol ranim be ja bar ec'o wi' ja Simón Pedro rachbil ja jun chic discípulo ja congana najo'x rmal ja Jesús. Ja c'a tok xekaji quewa' xbij chique ri': —Ja kajaw Jesús taka'an mchita chipan ja panteón, c'amarel pro ba la quiya'on chi wi', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ja c'a Pedro rachbil ja jun chic discípulo eje'e' xebe ja bar c'o wi' ja panteón. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","C'amc'ol canim xebe chi e ca'i' pro ja jun más na xutij ruk'ij chwach ja Pedro chewi' tok arja' xekaji nabey ja bar c'o wi' ja panteón. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ja c'a tok xekaji luque' kaj, cayoc chipan ja panteón, xutz'atoc ja utzlaj tak tziak rxin ja camnak chi xa ruyon chic c'o can pro ma xoc ta chipan ja panteón. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ja c'a Simón Pedro arja' c'a tran can na pro ja tok xekaji xoc chipan ja panteón. Arja' xutz'at ja tziak rxin ja camnak chi xa ruyon chic c'o can. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","In xutz'at chakaja' ja tziak ja barben rpalaj ja camnak pro ma ruq'uin chi ta c'o wi' ja jule' chic tziak, junwi' c'o pon chi wi', botol can ruyon. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","C'ac'ari' xoc chipan ja panteón chakaja' ja jun chic discípulo ja xekaji nabey in tok xutz'at ja tziak arja' xnimaj chi c'astajnak chic ja Jesús chiquicojol camnaki'. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Como eje'e' nabey matich'obtaj cumal ja tz'ibtal can chipan ja rtzobal Dios chi rjawaxic chi nc'astaj na ja Cristo chiquicojol ja camnaki'. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","C'ac'ari' xemeloji ja discípulo chi cochoch. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ja c'a María arja' pa'l can chuchi' ja panteón, rmajon ok'ej. Kas c'a rmajon ok'ej ja tok luque' kaj, cayoc chipan ja panteón. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ec'o ca'i' ángel xerutz'atoc chipan. Congana sak quitziak ja ángel, jun tz'ubuli ja bar q'ueje' wi' rwi' ja Jesús in jun chic tz'ubuli ja bar q'ueje' wi' rkan. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Quewa' quibij tre ja María ri': —Ixok ¿nak tre tok natok'i? xeche' tre. —C'amarel ja Wajaw in ma wotak ta ba la xeya̱' chi wi', ne'e ja María chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ja tok bitaji tzij rmal xuya' vuelta in xutz'at ja Jesús pa'l chwach pro ma rotak ta chi Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ja c'a Jesús xbij tre: —Ixok ¿nak tre tok natok'i, nak nacanoj? ne' tre. Ja xuch'ob kaj ja María chi chajil tijco'm ja ntzijon ruq'uin in quewa' xbij tre ri': —Ja wi atat xatc'amo'el rxin tabij jutz'it chwe bar xaya' wi', anin ninc'amo'el rxin, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","C'ac'ari' ja Jesús xbij tre: —María, ne' tre. Ja c'a María be ruq'uin in quewa' xbij tre ri': —Raboni, ne' tre. Jari' tzij xbij tre, pan hebreo xbij wi' in tibij tzij Maestro. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ja c'a Jesús xbij tre: —Ma quinachap ta, quinasokpij como maja'n quinjote'e ruq'uin ja Nata'. Pro ja naban, jat cuq'uin ja wach'alal, jabij chique chi ninjote' na ruq'uin ja Nata'. Arja' Etata' ixix chakaja'. Arja' Dios wxin anin in chakaja' Dios ewxin ixix, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","C'ac'ari' be ja María Magdalena cuq'uin ja discípulo xerbij chique chi: —Anin xintz'at rwach ja kajaw Jesús, ne' chique, in xbij chique chakaja' nojel ja binel tre rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jari' k'ij domingo, ja c'a discípulo como eje'e' nquixbej qui' chiquewach ja cach tak aj Israel chewi' tok quimolon qui' pa jay, quitz'apinto quechi'. Ja c'a tok xoc ak'a' xekaji ja Jesús cuq'uin, pe'i chiquicojol in quewa' xbij chique ri': —Ja quicotemal xin Dios tiq'ueje' checojol, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ja c'a tok bitaji tzij rmal c'ac'ari' xuc'ut chiquewach ja pa ruk'a' in ja pa rupox chakaja'. Congana xequicoti ja discípulo ja tok quetz'at chi ni katzij wi' chi ja kajaw Jesús ja c'o cuq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ja c'a Jesús xbij chic jutij chique: —Ja quicotemal xin Dios tiq'ueje' checojol. Ja Nata' arja' xinrutakto wawe' chwach'ulew in queri' c'a nban chic chewe ixix chakaja', nixnutakel chi nebana' ja nsamaj, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ja c'a tok bitaji tzij rmal c'ac'ari' xerxupuj in quewa' xbij chique ri': —Camic, tec'ulu' ja rEspíritu Santo. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ja wi nebij tre jun winak xa nak ta chi winakil chi cuytaji ja ril rumac cuytaj c'ari' owi nebij tre chi ma xcuytaj ta ma xcuytaj ta c'ari'. Queri' xbij chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pro c'o jun chique ja cablajuj apóstol rbina'an Tomás ja yo'x ne'xi, arja' mta ja tok xekaji ja Jesús cuq'uin ja jule' chic discípulo. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ja c'a tok xekaji ja Tomás bix tre cumal ja jule' chic: —Katz'at rwach ja kajaw Jesús, ne'xi. Pro ja Tomás xbij chique: —Jari' matinnimaj chi c'astaji. Ja wi xtintz'at ja pa ruk'a' ja bar soctajnak wi' rmal ja clawux in wi xtinmin ja rwinuk'a' tri' in wi xtinmin nuk'a' pa rupox ja bar soctajnak wi' chakaja' c'a tokori' xtinnimaj, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ja c'a cha jun domingo chic quimolon chic jutij qui' ja discípulo chipan ja jay cachbil ja Tomás. Tz'apali ja chi'jay pro chaka jalal tok xekaji ja Jesús, pe'i chiquicojol in quewa' xbij chique ri': —Ja quicotemal xin Dios tiq'ueje' checojol, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","C'ac'ari' xbij tre ja Tomás: —Tamina' ja rwiak'a' wawe' ri', tatz'ata' mpe' ja pa nuk'a' ri' in tamina' ja rak'a' pa nupox. Maxta ma catniman chi ta pro ni catniman wi', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","—Atat at Wajaw, atat at nDios, ne'e ja Tomás tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ja c'a Jesús xbij tre: —Tomás, atat natz'at nwach camic chewi' tok natnimani pro congana na qui'il chique ja nenimani masqui matiquetz'at nwach, ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ja Jesús c'o chi na jule' milagro ja xuban ja xk'alasbej ri' chiquewach ja rdiscípulo pro jari' ma xintz'ibaj ta chipan awa' jun libro ri'. ");
INSERT INTO tzjNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pro c'oli ja xintz'ibaj chipan awa' jun libro ri' utzc'a chi nenimaj ja Jesús chi arja' ja Cristo ja Ralc'wal Dios in tok queri' nenimaj jari' nyataj chewe ja utzlaj c'aslemal ja mta q'uisic trij como jari' nyataj chake ja tok xa jun nkaban ruq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ja c'a tok bantajnak chic nojel awa' wari' c'ac'ari' ja Jesús xuc'ut chic jutij ri' chiquewach ja discípulo tokori' tok ec'o chuchi' ja mar ja rbina'an Tiberias in quewa' rbanic ri'. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ec'o c'a jule' rdiscípulo quimolon qui', quewa' quebi' ri', jun Simón Pedro, jun chic Tomás ja yo'x ne'xi, jun chic Natanael ja raj Caná c'o pa rcuenta Galilea. Ec'oli chakaja' ja rc'ajol Zebedeo in ec'o chi na ca'i' ja discípulo. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ja c'a Simón Pedro arja' xbij chique: —Can ninbe anin pa chapoj ch'u', ne' chique. —Nokbe ajoj chawij chakaja', xeche' tre. Queri' queban xebe, xe'oc chipan ja lancha pro jari' ak'a' ni majun ja ch'u' xequechap. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ja c'a tok pi rsakaric pa'li ja Jesús chiya' ja bar ec'o wi' ja discípulo pro eje'e' ma cotak ta chi Jesús ja pa'l tri'. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ja c'a Jesús quewa' xbij chique ri': —Walc'wal ¿la ma ec'o ta ch'u' e'echapon nekati'? ne' nojoj chique. —Ni majun, xeche'pi tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Camic pan ewiquik'a' teq'uiaka' wi' ja rec'am in ec'oli ja ch'u' ne'echap, ne' nojoj chic jutij chique. Queri' queban queq'uiak ja c'am pro congana jun ch'u' xe'oc chipan, maquecowin chic nquiwasajto pa ya'. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","C'oli ja discípulo ja congana najo'x rmal ja Jesús, arja' xbij tre ja Pedro: —Jala' lale' kajaw Jesús, ne' tre. Ja c'a Simón Pedro arja' tok xc'axaj chi queri' xcojla' ja rtziak in xuq'uiakto ri' pa ya' in xule'to. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pro ja jule' chic discípulo eje'e' xexule'to pa lancha, quichararanto ja c'am ja renojnak ch'u' chipan. Ma bien ta nat ec'o wi', xla jun cien metro quiya'on can ja chiya'. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ja c'a tok xekajto ja chiya' quetz'at jule' rchak'ak' sa'on jun ch'u' parwi' in c'o jule' caxlanway chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ja c'a Jesús xbij chique: —Que'ec'ama'to jule' chique ja ch'u' ja c'a xe'echapto, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","C'ac'ari' be ja Simón Pedro, xoc chipan ja lancha, xerlasajto ja c'am pa ya' enojnak ja nimak tak ch'u' chipan, e jun ciento in cincuentitrés ja ch'u'. Pro masqui congana e q'uiy ja ch'u' pro ma xraktaj ta ja c'am. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ja c'a Jesús xbij chic chique: —Quixajo', quixwa'i, ne' chique. Canojel ja discípulo nquixbej qui' nquic'axaj tre: —¿Nak abi'? xeche' ta tre como cotak chi ja kajaw Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Peti ja Jesús tri', xuc'am ja caxlanway, xuya' chique in queri' xuban tre ja ch'u' chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Quewa' c'a xuban ja Jesús ja tok c'astaji chiquicojol camnaki', roxmul c'awa' wari' ja tuc'ut ri' chiquewach ja rdiscípulo. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ja c'a tok colbetaji wa'im cumal c'ac'ari' c'axax tre ja Simón Pedro rmal ja Jesús: —Simón ja rat rc'ajol Jonás ¿la ni katzij wi' chi atat ja más na natajo'n wxin chiquewach ja jule' chic awachbil ri'? ne'xi. —Queri' Wajaw, atat awotak chi congana nel nuc'u'x chawij, ne'e ja Pedro. —Que'ayuk'uj c'a ja yukul quec'u'x wq'uin como eje'e' e cani' tak ncarnelo, ne'xi rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","C'ac'ari' ja Jesús xc'axaj chic jutij tre: —Simón ja rat rc'ajol Jonás ¿la ninawajo'? ne' tre. —Queri' Wajaw, atat awotak chi congana nel nuc'u'x chawij, ne'x chic jutij rmal ja Pedro. —Que'achajij c'a ja ncarnelo, ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Pa roxmul c'axax chic tre ja Pedro: —Simón ja rat rc'ajol Jonás ¿la congana nel ac'u'x chwij? ne'xi rmal ja Jesús. Ja c'a Pedro arja' xumaj bis rmal ja c'axax oxmul tre ja wi congana nel ruc'u'x trij ja Jesús: —Wajaw, atat ni majun nak ta ja maquita awotak, awotak chi congana nel nuc'u'x chawij, ne'e ja Pedro tre. —Que'ayuk'uj c'a ja ncarnelo, ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","In xbij chic jutij tre: —Ni katzij wi' ja xtinbij chawe ri', ja tok c'a at c'ajol na xacoj ja ratziak, xaxim xe' apan in xatbe xa bar ta c'o wi' agana chi xatbe wi'. Pro ja tok xcatraji'xi narip na ak'a' in junwi' chic nximo awxin in natruc'amel ja bar mta wi' agana natbe wi', ne'e ja Jesús tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ja tok queri' xbij jari' xc'utbej nak xtiban na tre ja Pedro tok xticamsaxi, jari' xc'utbej chi ja rcamic ja Pedro noc na ya'bal ruk'ij ja Dios. C'ac'ari' ja Jesús xbij chic tre ja Pedro: —Jo', ni quinawachbilaj wi', ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ja c'a Pedro arja' ca'y can trij in xutz'at chi tran chiquij ja discípulo ja congana najo'x rmal ja Jesús. Jari' mismo discípulo ja k'e'oc chwaruc'u'x ja Jesús tokori' tok queban ja q'uisbal wa'im ruq'uin ja tok c'o jun pregunta xc'axaj tre ja Jesús quewari': —Wajaw ¿nak xtijacho awxin pa quek'a' ja netzelan awxin? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ja c'a Pedro arja' tok xutz'at ja discípulo chi tran chiquij quewa' xbij tre ja Jesús ri': —Wajaw, jala' jun kachbil le' ¿nak c'a xtiban na tre arja' chakaja'? ne' tre. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","—Ja wi c'o ngana chi c'a c'as na arja' ja tok xquinmeloj chic jutij jari' mta ak'a' atat tre pro xar ja naban atat, ni quinawachbilaj wi', ne'xi ja Pedro rmal ja Jesús. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jari' tzij ja xbij ja Jesús be rtzijoxic chiquicojol ja kach'alal pro queq'uex rbixic: —Ni maticam wi' ja discípulo, xeche'e, pro ma queri' ta xbij ja Jesús como arja' xbij: —Ja wi c'o ngana chi c'a c'as na arja' ja tok xquinmeloj chic jutij jari' mta ak'a' atat tre, queri' xbij. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jari' mismo discípulo arja' ntajini nk'alasaj nojel awa' ja bantaji ri', arja' tz'ibyon nojel ja c'o chipan awa' jun libro ri' in bien kotak chi ni katzij wi' ja nbij. ");
INSERT INTO tzjNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Pro ja Jesús arja' c'a c'o na más ja xuban wawe' chwach'ulew. Nojel ja xuban ja Jesús wixta tz'ibtali chijujunal pa tak libro maquita nuban ari' ja rwach'ulew xtic'ol ta ja libro chwach. Amén.");
INSERT INTO tzjNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, ja nabey libro ja xintak awq'uin xintz'ibaj chipan nojel ja samaj ja xuban ja Jesús in xintz'ibaj chipan chakaja' nojel ja xuc'ut chiquewach ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Xintz'ibaj ja bar xumajto wi' ja rsamaj in bar xerq'uisa' wi' tokori' tok jote' chila' chicaj. Ja tok maja'n tibe chila' chicaj xerucha' ja rapóstol in xuch'ob chiquewach nak nqueban can ja tok xtibe. Ja xbij chique ja' Espíritu Santo uc'ayon rxin chi rbixic. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ja c'a tok cami in tok c'astaji c'ac'ari' xuc'ut ri' chiquewach ja rapóstol. Ca'winak k'ij q'ueje' chi na chwach'ulew in q'uiylaj mul xuc'ut ri' chiquewach ja rapóstol in c'o chi na más ja xuban chiquewach utzc'a chi c'o quiseguro chi ni katzij wi' chi c'astajnak chic. Arja' ntzijon cuq'uin in nuch'ob chiquewach nak rbanic ja gobierno xin Dios. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ja tok c'a c'o na chiquicojol ja rapóstol quewa' xbij chique ri': —Ma quixel ta na chipan ja tinamit Jerusalén. Ja Nata' arja' rtzujun chwe chi ntakpi na ja rEspíritu Santo ewq'uin ja cani' nbin chic chewe, ja c'ari' ja tewaybej chipan ja tinamit Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ja Juan Bautista arja' ya' xucoj chi quibanic bautizar ja winak pro ja rixix xajalal maja'n terila' ja tiempo ja tok nixban bautizar tre ja rEspíritu Santo, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ja c'a rapóstol eje'e' quimolon qui' ruq'uin ja Jesús in quewa' quibij tre ri': —Kajaw ¿la trewa' tiempo ri' ja tok nacoj chic jutij ja gobierno pa kak'a' ja rok aj Israel? xeche' tre. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","—Ixix ma yatal ta chewe chi newotakij nak k'ij xtibantaji. Ja Tatixel arja' otakyon ari' in xa ruyon arja' c'o ruk'a' tre nak k'ij xtichomij. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pro ja tok xtikajto ja rEspíritu Santo ewq'uin tokori' c'oli poder xin Dios ja xtecochij tre. Tokoc'ari' nixbe in nemaj rbixic chique ja winak nojel ja retz'aton in nojel ja rec'waxan ja xinban chewach. Nemajel rbixic pa Jerusalén in nixbe chi rbixic chipan nojel tinamit ja c'o pa rcuenta Judea in nixbe chi rbixic chipan ja departamento Samaria chakaja'. C'ac'ari' nixbe chi rbixic nojel nat nakaj tre ja rwach'ulew, ne'e ja Jesús chique. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ja c'a tok tzuri tzij rmal c'ac'ari' jote' chicaj pro ni chiquewach in wawax chiquewach rmal jule' sutz'. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kas c'a eca'ynak nojoj chicaj chi rtz'atic ja tok ec'o ca'i' achi'i' xewinakar cuq'uin, sak quitziak quicojon. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ja c'a rachi'i' quibij chique ja rapóstol: —Achi'i' ja rix aj Galilea ¿nak tre ja tok nixca'y chicaj? Ja Jesús arja' jote' chewach chila' chicaj pro nmelojpi chi na jutij. Ja cani' xetz'at tok jote' chicaj ni c'a queri' nuban chic ja tok xtimelojto chic jutij, xeche' chique. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","C'ac'ari' ja rapóstol xe'elto parwi' ja ti jayu' rbina'an Olivo, xemeloji ja pa Jerusalén. Ja ti jayu' xa jun ca'i' kilómetro ja rcojol ruq'uin ja Jerusalén. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ja c'a tok xe'ekaji ja pa Jerusalén xe'oc chipan ja jay ja bar ec'o wi' in xejote' pa ca'i' piso. Quewa' quebi' ja rapóstol ri', ja Pedro, ja Jacobo, ja Juan, ja rAndrés, ja Felipe, ja Tomás, ja Bartolomé, ja Mateo, ja Jacobo ja rc'ajol Alfeo, ja Simón jun chique ja partido rbina'an Zelote in Judas ja rch'alal Jacobo. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Eje'e' xa jun quibanon chi rbanic oración e cachbil ja rixoki'. C'oli María rute' ja Jesús in ec'oli rch'alal ja Jesús chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Jari' tiempo pe'i ja Pedro chiquewach ja jule' chic kach'alal ja quiniman chic ja Jesús, ec'o la jun ciento veinte chi canojelal. Quewa' xbij ja Pedro chique ri': ");
INSERT INTO tzjNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Wach'alal, ni rjawaxic wi' chi nbantaj cumplir ja rtzobal Dios. Ja Judas arja' c'amo quebey ja winak ja xechapo rxin ja Jesús in quecoj preso. Ja c'a David c'o jun rtzobal Dios ja yataj tre ojer rmal ja rEspíritu Santo tre nak xtuban ja Judas in mta moda ja maquita nbantaj cumplir. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Como ja Judas arja' kach apóstol, yataj tre chi xoc kachbil chipan ja samaj xin Dios ja kamajon. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pro ja xuban be, xulok' jun ulew tre ja pwok ja toj tre rmal ja ritzelal ja xuban. C'ac'ari' xerq'uiaka'to ri', ni rwi' xurkajbej kaj, chictaji ja rxcolo', ni xelto nojelal. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ja winak ja rec'o pa Jerusalén eje'e' tok cotakij nak xuban ja Judas quicanoj rubi' ja rulew ja xulok'. Acéldama quibij tre. Ja pa quitzobal eje'e' Acéldama tibij tzij jun ulew rjil quic'. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Como ja rtzobal Dios ja tz'ibtal can chipan ja salmo quewa' nbij tre ja Judas ri': —Ja rochoch nq'ueje' can na ruyon, majun nak chi ta xtiq'ueje' ta chipan, ne'e. In jun chic nbij chakaja' quewari': —Ja rsamaj junwi' chic nq'uisowi. Queri' ja tz'ibtal can. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","In camic ec'oli ja rachi'i' chikacojol ja nij ec'o wi' kuq'uin ja tok kamajto ja samaj. Ja tok q'ueje'e ja kajaw Jesús kuq'uin nij e kachbil wi'. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ja c'a tok ban bautizar ja Jesús rmal ja Juan Bautista ec'o kuq'uin tri' in tok jote' chila' chicaj nij ec'o wi' kuq'uin chakaja'. Ja camic rjawaxic chi c'o jun chique ncha'i chi noc kach apóstol in nel chi rbixic nak rbanic ja rc'astajic ja Jesús. Queri' xbij ja Pedro chique. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","C'ac'ari' ec'o ca'i' chique xequipaba', jun José Barsabás rubi' in bina'an tre chakaja' Justo, in jun chic Matías rubi'. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","C'ac'ari' quemaj rbanic oración, quewa' ja roración queban ri': —Kajaw, atat bien awotak nojel ja c'o pa tak kanma kanojelal. Atat ta xcatc'utuwi nak chique ja re ca'i' achi'i' ri' ja racha'on ");
INSERT INTO tzjNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ja xtoc kach apóstol pa rc'axel ja Judas. Como ja Judas arja' xuya' can ja rsamaj rmal ja ritzelal ja xuban in be chipan ja lugar ja ni yatal wi' trij chi tri' nbe wi'. Queri' ja roración queban. ");
INSERT INTO tzjNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","C'ac'ari' quemaj rbanic suerte chi rcha'ic jun chic apóstol. Ja tok tzuri ja suerte cumal trij ja Matías kaj wi'. In ni jari' hora ja Matías xoc cachbil ja julajuj apóstol. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ja c'a tok xerila' ja nmak'ij rbina'an Pentecostés canojel ja rdiscípulo ja Jesús eje'e' xa jun quibanon, xa jun quimolon wi' qui'. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Chaka c'a jalal ja tok c'oli quic'axaj penak chicaj cani' jun nimlaj ik' tok njaktajto. Ja c'a rukul c'axax cumal canojel ja retz'ubul pa jay. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","C'ac'ari' c'oli winakar chiquewach cani' rxak tak k'ak', xuq'uiak ri' chiquij chiquijujunal. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","C'ac'ari' noji ja rEspíritu Santo pa tak canma canojelal in quemaj tzij chipan chic jule' tzobal ja cani' yataj chique chiquijujunal rmal ja rEspíritu Santo. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jari' tiempo ec'oli winak ja raj Israel nojel nación epenak wi', quimolon qui' pa Jerusalén, congana nqueban respetar ja quireligión. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ja c'a tok quic'axaj ja bantaji xebe xequimolo' qui'. Congana sach quina'oj como pa quitzobal eje'e' netzijon wi' ja rdiscípulo ja Jesús, queri' quic'axaj chiquijujunal. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Congana c'asc'o'i quic'axaj in quewa' quibij chibil tak qui' ri': —¿Nak tre c'ala'? ¿La ma e aj Galilea ta c'a ja winak le' ja quimajon tzij? ");
INSERT INTO tzjNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Nak tre tok netzijon taka'an pa tak katzobal chikajujunal? ");
INSERT INTO tzjNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Como ec'o jule' chake Partia epenak wi' in jule' chic chake e aj Media, ec'oli epenak Elam, ec'oli epenak Mesopotamia, ec'oli epenak pa Judea, ec'oli epenak pa Capadocia, ec'oli epenak Ponto, ec'oli epenak Asia, ");
INSERT INTO tzjNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ec'oli epenak Frigia, ec'oli epenak Panfilia, ec'oli epenak pan Egipto in ec'oli epenak pa tak lugar ja c'o pa rcuenta Africa ja c'o chinakaj Cirene. Ec'oli ja raj Roma wawe' chakaja', jule' chique wawe' pan Israel e'alaxnak wi' in jule' chic chique ja xa quiniman ja religión kaxin ja rok aj Israel. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","In ec'oli chakaja' ja raj Creta in jule' chic aj Arabia pro kanojel nkac'axaj ja nimlaj samaj xin Dios ja quimajon rch'obic chikawach pa tak katzobal chikajujunal, xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Canojel congana c'asc'o'i quic'axaj in sach quina'oj como eje'e' matich'obtaj cumal nak rbanic ja bantaji in quewa' quibij chibil tak qui' ri': —¿Nak tibij c'awa' wari' ja bantaji? xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pro ec'o jule' chique xa neyok'oni in quewa' quibij ri': —Jala' winak le' xa e k'abarela', xeche'e. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ja c'a Pedro arja' c'o chiquicojol ja re julajuj chic apóstol, xumaj tzij cuq'uin ja winak, cow tzijoni in quewa' xbij chique ri': —Achi'i' ja rix wach tak aj Israel in ixix chakaja' ewanojel ja rixc'o pa Jerusalén, bien tec'waxaj ja xtinbij chewe ri' in bien tech'obo'. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ajoj ma ok k'abarela' ta ja cani' nebij chake como c'a xuban a las nueve xin ak'abil. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ja xetz'at camic jari' bitajnak can ojer rmal ja profeta Joel quewari': ");
INSERT INTO tzjNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","—Ja pa rq'uisbal tak k'ij ntakel na ja rEspíritu Santo cuq'uin ja winak xa nak ta chi winakil, ne'e ja Dios. Ja c'a rewalc'wal chi ala'i' chi xtani' eje'e' nqueya' na rbixic ja nk'alasaj chiquewach. In chakaja' ja c'ajola' chewe anin nya' na chique chi c'oli nquetz'at je'e ja maja'n tibantaji. In ja rija' chewe nya' na chique chi c'oli ncachc'aj je'e ja maja'n tibantaji chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jari' tiempo chakaja' ntakel na ja rEspíritu Santo cuq'uin ja rajsamajela' wxin chi achi chi ixok in eje'e' nqueya' na rbixic ja nk'alasaj chiquewach. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","In c'o je'e nwinakarsaj na chwach ja caj ja ni majutij quitz'aton ta ja winak. In ja chwach'ulew chakaja' c'o retal je'e ja nwinakarsaj na cani' tre quic' cani' tre k'ak' in cani' tre sib. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","In matica'y chic ja k'ij in ja ic' chakaja' noqui cani' quic'. Nojel awa' wari' nbantaj na cumplir tokori' tok maja'n terila' ja nimlaj k'ij xin juicio. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","In canojel ja winak ja nquic'utuj ja quito'ic tre ja Dios eje'e' netotaji. Queri' rbin can ja Dios ja cani' tz'ibtal can chipan ja rtzobal rmal ja profeta Joel, ne'e ja Pedro chique ja winak. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","In xbij chic chique: —Achi'i' ja rix wach tak aj Israel, tec'waxaj ja xtinbij chic chewe ri'. Ja Dios arja' xuya' tre ja Jesús ja raj Nazaret chi xuban jun nimlaj samaj checojol in bien ewotak ja jule' milagro ja xuban chewach. Tri' c'a nkatz'at wi' chi ja Jesús arja' jun achi utz tz'at rmal ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ja Dios xuya' lugar chewe chi xecamsaj ja Jesús como xejach pa quek'a' ja winak ja ma cotakin ta ja rtzobal Dios in eje'e' querip chwach cruz. Ja Dios ni rotak wi' ojer chi ja Jesús nja̱ch na pa quek'a' ja netzelan rxin como arja' ni rchominto wi' ojer chi niquirwari' nba̱n tre. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pro ja Dios to'o rxin chipan ja camíc in xuya' tre chi c'astaji como ja Jesús mta moda q'ueje' ta chijutij pa ruk'a' ja camíc. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mta moda como ja rey David ojer quewa' rtz'iban can tre ja Jesús ri': —Anin wotak chi ja wajaw Dios ni c'o wi' wq'uin, c'o pa wiquik'a' in ninruto' utzc'a ni majun nxbej wi' wi'. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Rmalc'ari' tok congana nquicoti ja wanma in nya' rbixic ja quicotemal ja c'o wq'uin. Ja c'a tok xquincami wotak chi c'a c'o na ja rawutzil nwaybej tri' ");
INSERT INTO tzjNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","como atat mta moda xquinaya' can ta chijutij chiquicojol ja camnaki'. Ja cuerpo rxin ja Santilaj Awalc'wal wotak chi mataya' lugar tre chi xtak'ay ta. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Atat ach'obon chinwach nak rbeyal ja utzlaj c'aslemal. Ja tok xquineq'ueje' na awq'uin chijutij jari' congana nnoji ja quicotemal pa wanma. Queri' rtz'iban can ja David ojer, ne'e ja Pedro. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","In xbij chic chique: —Ixix ja rix wach tak aj Israel, bien kotak chi cami ja David ja kamama' in xemuki in ja rpanteón c'a c'o na kuq'uin camic. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pro ja David arja' jun profeta xin Dios in xurkaj tre ja juramento ja rbanon ja Dios quewari': —David, anin quewa' ntzujuj chawe ri', c'o jun chique ja rawiy amam ja maja'n talaxi, arja' ari' ja Cristo in xtincoj como Rey pan ac'axel. Queri' tzujun can tre ja David rmal ja Dios. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Rmalc'ari' ja tok c'oli ja xtz'ibaj can ja David tre rc'astajic ja Cristo tokori' tok maja'n titakto ja Cristo chwach'ulew como bien rotak chic chi nc'astaj na. Quewa' ja xtz'ibaj can ri', ja Cristo arja' matiya' can chijutij chiquicojol ja camnaki' in matak'ayi ja rcuerpo chakaja'. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ja Dios arja' xuya' tre ja Jesús chi c'astaji in jari' kotak kanojel in kamajon rbixic. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","C'ac'ari' jotbax chila' chicaj rmal ja Dios in yataj tre rmal ja Tatixel chi xutakto ja rEspíritu Santo wawe' chwach'ulew ja cani' tzujun tre ojer. Ja c'a rixix, ja remajon rtz'atic camic in ja remajon rc'axaxic jari' Espíritu Santo banowi. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ma ja ta David ja jotbax chila' chicaj pro quewa' nbij ja David ri': —Ja kajaw Dios quewa' xbij tre ja Wajaw ri': —Cattz'abe' pa wiquik'a' como congana nim ak'ij, ");
INSERT INTO tzjNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","wawe' natq'ueje' wi' in nenucoj na pan awakan ja netzelan awxin, atat natch'eco quixin, ne'e. Queri' rbin can ja David. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Rmalc'ari' tok nbij chewe, ja Jesús arja' rip chwa cruz como ixix xixc'utuni ja camíc trij pro jari' mismo Jesús cojon chic rmal ja Dios como Rajaw nojelal, cojon chic rmal como Cristo. Bien tewotakij ja c'a xinbij chewe ri' in bien ticotakij chakaja' ja kach tak aj Israel pro ni canojelal. Queri' xbij ja Pedro chique. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ja c'a winak tok quic'axaj ja xbij ja Pedro chique congana xk'ututuj ri' ja canma. Quewa' quibij ri': —Ixix ja rix kach tak aj Israel ¿nak c'a c'o rjawaxic chake chi nkaban camic? xeche' tre ja Pedro in chique ja jule' chic apóstol. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ja c'a Pedro xbij chique: —Teq'uexa' ja rena'oj in teya'a' can ja ritzelal in chakaja' quixban bautizar chejujunal pa rubi' ja Jesucristo utzc'a chi ncuytaji ja rewil emac. Ja wi queri' neban ja Dios arja' nutakto na ja rEspíritu Santo ewq'uin. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Jari' Espíritu Santo ja rtzujun can ja Dios ojer como arja' nrajo' nutakto ewq'uin in cuq'uin ewalc'wal in cuq'uin chakaja' canojel ja winak ja rec'o pa natlaj tak tinamit. Ja rEspíritu Santo arja' nta̱kto cuq'uin canojel ja winak ja nesiq'uix rmal ja Dios chi nquinimaj ja rtzobal, ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jawa' tzij xbij ja Pedro chique ja winak in jule' chic paxbanem xuya' chique chakaja', quewa' xbij chique ri': —Quixtotaji, maxta teban ja ritzelal ja cani' nqueban ja ritzel tak winak trewa' tiempo ri', ne' chique. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ja winak ja utz quic'axaj ja xbij ja Pedro eje'e' xeba̱n bautizar in jari' mismo k'ij ec'o la oxi' mil ja xe'oc cachbil ja kach'alal. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eje'e' congana quetij quek'ij chi rotakixic ja tijonem ja nc'u̱t chiquewach cumal ja rapóstol, xa jun quibanon. Ni nquemol wi' qui' chi rtijic ja caxlanway jari' nquinatbej rxin ja Jesús. Chijutij quimajon rbanic ja roración. ");
INSERT INTO tzjNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ja winak congana quixbej qui' canojelal como ja rapóstol eje'e' yataj chi