﻿USE sofia;
DROP TABLE IF EXISTS sofia.tzjE_vpl;
CREATE TABLE tzjE_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tzjE_vpl WRITE;
INSERT INTO tzjE_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo arja' riy rumam ja ojer rey David, chka' riy rumam Abraham. Jawra je xtentz'ibaj ra jawa' quebi' rti't remma' ja' Jesucristo. ");
INSERT INTO tzjE_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham, ttixel rxin Isaac. Isaac, ttixel rxin Jacob. Jacob, ttixel rxin Judá e rexbil je' rch'alal. ");
INSERT INTO tzjE_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá, ttixel cxin e c-e' ach-i' jquebi' Fares ruq'uin Zara, y jquete' Tamar rubi'. Fares, ttixel rxin Esrom. Esrom, ttixel rxin Aram. ");
INSERT INTO tzjE_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram, ttixel rxin Aminadab. Aminadab, ttixel rxin Naasón. Naasón, ttixel rxin Salmón. ");
INSERT INTO tzjE_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón, ttixel rxin Booz, jrute' ja' Booz, Rahab rubi'. Booz, ttixel rxin Obed, jrute' Obed, Rut rubi'. Obed, ttixel rxin Isaí. ");
INSERT INTO tzjE_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí, ttixel rxin ja ojer rey David. David, ttixel rxin Salomón, jrute' Salomón jara' ixak jrexkayil Urías nabey. ");
INSERT INTO tzjE_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón, ttixel rxin Roboam. Roboam, ttixel rxin Abías. Abías, ttixel rxin Asa. ");
INSERT INTO tzjE_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa, ttixel rxin Josafat. Josafat, ttixel rxin Joram. Joram, ttixel rxin Uzías. ");
INSERT INTO tzjE_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías, ttixel rxin Jotam. Jotam, ttixel rxin Acaz. Acaz, ttixel rxin Ezequías. ");
INSERT INTO tzjE_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías, ttixel rxin Manasés. Manasés, ttixel rxin Amón. Amón, ttixel rxin Josías. ");
INSERT INTO tzjE_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías, ttixel rxin Jeconías e rexbil je' rch'alal, y wawe' ra tak xe'oca preso aj Israel y xec'mar ela chpam nación Babilonia. ");
INSERT INTO tzjE_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jeconías, ttixel rxin Salatiel. Salatiel, ttixel rxin Zorobabel. ");
INSERT INTO tzjE_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel, ttixel rxin Abiud. Abiud, ttixel rxin Eliaquim. Eliaquim, ttixel rxin Azor. ");
INSERT INTO tzjE_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor, ttixel rxin Sadoc. Sadoc, ttixel rxin Aquim. Aquim, ttixel rxin Eliud. ");
INSERT INTO tzjE_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud, ttixel rxin Eleazar. Eleazar, ttixel rxin Matán. Matán, ttixel rxin Jacob. ");
INSERT INTO tzjE_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob, ttixel rxin José. José, jara' rechjil María, jara' María jrute' Jesús je Cristo nbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","J-ewra quebi' rti't remma' Jesucristo, tak namaj ta quelxic ruq'uin Abraham y narec'sa' ruq'uin David ec'ola e catorce che conjelal. Tak namaj pchic quelxic ruq'uin David y narec'sa' chpam tiemp tak xec'mar ela aj Israel chpam nación Babilonia e catorce quebnon chka'. Y tak namaj pchic quelxic chpam jara' tiemp y narec'sa' ruq'uin Cristo e catorce chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Cawra rbanic tak xalexa Jesucristo. María jrute', arja' c'utun chic rmal José chnec'le'a ruq'uin. Per tak q'uemjana tquec'om qui' chek q'uenjlal xutkixa che m-utz tchic María, xnec'je'a jun ral. Per Espíritu Santo xesmaja rmal c'ara' tak cara' xuban. ");
INSERT INTO tzjE_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José jc'utyuna rxin che noca rexkayil, arja' jun acha rc'an rbeyal rxin Dios, rmal c'ara' xpoknaj xuya' ruq'uix María. Rmal c'ara' tak xuch'ob pnejkal nutur cana c'ulbic. ");
INSERT INTO tzjE_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Per kas cara' remjon rch'obic tak chek q'uenjlal xwankera jun ángel rxin Kajaw Dios pe rwaram y cawra xbij tzra: —José ja at riy rumam ja ojer rey David, mtaxibej ta awi', tec'ma' María com ac'al jc'ola pe gracia Espíritu Santo xesmajina rxin. ");
INSERT INTO tzjE_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María nec'je' na jun ch'it ral ala' y jrubi' je xtaya' jara' Jesús. Com jbi'aj Jesús nbij tzij Dios To'onel, cara' c'a rubi' xtabij com arja' net-owa retnamet chpam quil quemac, cara' xbij ángel tzra José. ");
INSERT INTO tzjE_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Njelal jawra xbantaja mchek tcara' xbantaja, tzra' xbantaj wa' cumplir je rbin cana Kajaw Dios jtz'ibtanak cana rmal profeta jcawra nbij: ");
INSERT INTO tzjE_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","—Bien tewc'axaj jawrara, c'ola jun k'poj xtan neywaj na y rmal ra' nec'je'a jun ral ala'. Jara' ala' Emanuel nbix na tzra. Cara' tz'ibtanak cana. Emanuel nbij tzij Dios c'ola kuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tak xc'astaja José cara' xuban ajni' xbixa tzra rmal ángel rxin Kajaw Dios, xec'le'a ruq'uin María. ");
INSERT INTO tzjE_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Per chpam njelal tiemp tak q'uemjana talexa ral María jnabey ac'al nmajo'n nak ta xqueban. José tak xuya' rubi' ac'al, Jesús rubi' xuya'. ");
INSERT INTO tzjE_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús, chpam tnamet Belén xalex wa' jc'ola precwent Judea. Jara' tiemp Herodes ocnak rey. C'jara' ec'ola e c-e' oxi' ach-i' epenak chpam nación jc'ola pnoriente, arj-e' xerkaja chpam tnamet Jerusalén. J-era' ach-i' nmak tak cna'oj. Arj-e' xquemaj rc'axic chca wnak cawrara: ");
INSERT INTO tzjE_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","—¿Abar c'o wa' ac'al je c'ja' xalexa jRey ewxin ixix ja ix aj Israel? Com ajoj c'ola jun ch'umil katz'ton ta pnoriente je nk'alsana rxin y camic okpenak che nekrey-a' ruk'ij, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Rey Herodes tak xc'axaj chc'ola jun chic rey xalexa congan junwa' xuna' y conjelal jec'ola pJerusalén junwa' xecc'axaj chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ja' Herodes xerumol conjelal cjefe sacerdote e quexbil maestro je nquetijona cxin wnak tzrij rley Dios jtz'ibtanak cana ojer rmal Moisés y cawra xc'axaj chca ra: —¿Abar tzra' nalex wa' Cristo? cara' xc'axaj chca. ");
INSERT INTO tzjE_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—Chpam tnamet Belén nalex wa' jc'ola precwent Judea, cara' xecbij tzra. —Cara' nekbij chawa com cara' tz'ibtanak cana rmal profeta jcawra nbij: ");
INSERT INTO tzjE_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","—Je tnamet Belén jc'ola precwent Judá, ajni'la nim ruk'ij ntz'e'ta cmal ja e k'toy tak tzij rxin Judá. Cara' nba'na tzra com tzra' nwanker wa' jun k'toy tzij, arja' nc'ana cxin netnamet Israel, cara' xbij Dios. Cara' tz'ibtanak cana rmal profeta. Cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","C'jara' ja' Herodes pnalak' xutak quesic'sic ach-i' je nmak tak cna'oj. Tak xe'ekaja ruq'uin kas congan xuc'ot quechi', xc'axaj chca nak k'ij kas xwankera ch'umil. ");
INSERT INTO tzjE_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","C'jara' xerutak ela pBelén y cawra xbij ela chca: —Jix pBelén kas bien ecanoj ac'al abar tzra' kas xtewil wa'. Tak xtewla' tetka' ta rbixic wq'uin ch-utz c'ara' quenba anen chka' che cney-a' ruk'ij, cara' xbij ela chca. ");
INSERT INTO tzjE_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tak xc'axtaja cmal je xbixa chca rmal rey c'jara' xeba. Per jch'umil jquetz'ton ta pnoriente jara' xec'mow ela quebey. Jch'umil tak xekaja nmer pe rwá' abar c'ol wa' ac'al majo'n chic xbin ta. ");
INSERT INTO tzjE_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Arj-e' tak xquetz'et ch'umil che xpe'a congan xequicota. ");
INSERT INTO tzjE_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","C'jara' xe'oca chpam jay y xquetz'et ac'al rexbil María jrute'. Xexque'a chwech ac'al, xquemaj rya'ic ruk'ij. C'jara' xquelsaj ta jquec'mon ela je' achnak nmak rejlal y xecsipaj tzra. Ja xecsipaj jara' oro y je' achnak jcongan qui' rexla' ajni' incienso ruq'uin mirra. ");
INSERT INTO tzjE_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","C'jara' xeba chic chpam quetnamet per xbixa chca pnachic' chmajo'n chic nquemloj ta ruq'uin Herodes, rmal c'ara' jun chwa' bey xquec'om ela. ");
INSERT INTO tzjE_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tak ebnak chic j-e' ach-i' c'ola jun ángel rxin Kajaw Dios xwankera chwech José pnachic' y cawra xbij tzra: —Catyictaja, tec'ma' ela ac'al rexbil rute' y quixnanmaj ela, jax chpam nación Egipto y tzra' nquixec'je' wa'. C'a anen na quenbina chewa tak xtquixemloj pchic. Cara' quenbij chewa com Herodes xyamer numaj rconxic ac'al che ncamsaj, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","C'jara' xc'astaja José y xyictaja, xuc'om ela ch'tac'al rexbil rute', xeba pnEgipto chak'a'. ");
INSERT INTO tzjE_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tzra' c'a xec'je' wa' junlic, c'jara' xemloj ta tak xcoma Herodes. Ja xqueban mchek ta xqueban, tzra' xbantaj wa' cumplir je rbin cana Kajaw Dios jtz'ibtanak cana rmal profeta jcawrara: —Chpam Egipto xentak wa' rsic'sic wlec'wal. Cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ja' Herodes tak xutz'et chmajo'n ruk'ij xya' ta cmal ach-i' je nmak tak cna'oj congan xuk'ut ri' ranm rmal ryiwal. Xuya' ela jun orden che nquecomsasa ac'ala' ch'tak al-i' jec'ola pBelén, chka' chpam je' lwar jc'ola chenkaj Belén. Conjelal jquemjon jujun caca' cjuna' nquecomsasa. Com ja' Herodes bin tzra cmal ach-i' je nmak cna'oj nak tiemp kas xwanker ta ch'umil jara' tiemp xoca rbase ajru' tak cjuna' je nquecomsasa. ");
INSERT INTO tzjE_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Cara' xba'na, xecomsasa, tzra' c'a xba'n wa' cumplir jbitanak cana rmal profeta Jeremías jcawra nbij: ");
INSERT INTO tzjE_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","—C'ola jun kul nc'axaxa chpam tnamet Ramá, ajni'la jun nimlaj bis y jun nimlaj ok'ej nuban je nc'axaxa. Jara' kul rxin Raquel nquerok'ej ch'tak ral. Congan ok'ej nuban, nmajo'n xbochtaj ta rmal che xecoma ch'tak ral. ");
INSERT INTO tzjE_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tak xcoma Herodes c'ola jun ángel rxin Kajaw Dios xwankera chwech José pnachic' pnEgipto y cawra xbij tzra: ");
INSERT INTO tzjE_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Catyictaja, tec'ma' ela ch'tac'al rexbil rute', jax quixemloja chpam nación Israel com ecomnak chic wnak je ncajo' neccomsaj jac'al. Cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","C'jara' xc'astaja y xyictaja, xuc'om ela ac'al rexbil rute', xeba, xemloja chpam nación Israel. ");
INSERT INTO tzjE_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Per José xekaja rbixic ruq'uin che k'atbaltzij rxin departamento Judea c'o chic pruk'a' Arquelao rlec'wal Herodes. Ja' Arquelao xec'je'a prec'xiwach redta'. Tak José xc'axaj jara' xxibej ri' rmal, majo'n xba ta tzra'. Per xk'alsas chic chwech pnachic' rmal c'ara' xba pdepartamento Galilea. ");
INSERT INTO tzjE_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tak xe'ekaja pGalilea chpam tnamet Nazaret xec'je' wa'. Cara' xqueban rmal che tzra' xbantaj wa' cumplir je cbin cana profeta tzrij Cristo jcawrara: —Aj Nazaret nbix na tzra. Cara' cbin cana. ");
INSERT INTO tzjE_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Xerla' tiemp che Juan Bautista xpeta, ntajina nuya' rbixic rtzojbal Dios chpam jun tenlic lwar jc'ola precwent Judea. ");
INSERT INTO tzjE_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Cawra nbij chca wnak: —Tec'xa' ena'oj y tey-a' cana rtzilal com xyamer npeta jgobierno rxin chcaj, cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan arja' bitanak cana ojer che npe na, cawra bitanak cana tzrij rmal profeta Isaías: —C'ola jun kul nc'axax na chpam tenlic lwar, cawra nbij ra: —Tchumsaj rubey Kajaw Dios, jic tey-a', cara' tz'ibtanak cana tzrij Juan. ");
INSERT INTO tzjE_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ja' Juan resmal camello ocnak retziak jrecsan y c'ola jun tz'um rximben xe' rpam. Jocnak rway jara' je' sac' ruq'uin ri'al che' je ncanoj ptak k'ayis. ");
INSERT INTO tzjE_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Y nec'ol wa' wnak nque'ekaja ruq'uin ajni' chca aj Jerusalén ajni' jec'ola chpam jle' chic lwar jc'ola precwent Judea, chka' conjelal jec'ola chenkaj binel ya' Jordán. ");
INSERT INTO tzjE_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tak xe'ekaja ruq'uin Juan xeba'na bautizar chpam binel ya' Jordán y tzra' xquechol wa' quil quemac. ");
INSERT INTO tzjE_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","E q'uiy chca aj fariseo e quexbil aj saduceo arj-e' xe'ekaja ruq'uin Juan che nqueba'na bautizar per Juan tak xerutz'et arja' cawra xbij chca: —Ixix congan itzel tak na'oj ewc'an, ixix ix ajni' ix itzel tak cmetz. ¿Nak nbina chewa che nquixnanmaja chwech nimlaj juicio je ntajin ta? ");
INSERT INTO tzjE_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Per kas mer rubey neban, xtwachin ta utzil rxin Dios ptak ewanm, njawara' yatanak chewij chneban we ktzitzij che ec'xon chic ena'oj. ");
INSERT INTO tzjE_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Y mex cawra tech'ob kaja ptak ewanm: —Ajoj ok riy rumam Abraham rmal c'ara' ok retnamet Dios, mex cara' tech'ob. Cara' quenbij chewa com Dios majo'n pen ta tzra nquerwankersaj jle' riy rumam Abraham tzra jle' abaj la. ");
INSERT INTO tzjE_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chka' camic ra chenkaj c'o chwa' juicio rxin Dios ajni' rbanic jun icaj chumin chic che ncho'ya jle' che' tzra. Je' che' jmajo'n wen ta rwech nuya' jara' ncho'ya njelal y nporoxa pk'ak'. ");
INSERT INTO tzjE_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Anen ya' quencsaj che quixnbanbej bautizar y tak nquixba'na bautizar jara' rital che ech'bon chic che neq'uex ena'oj y neya' cana rtzilal. Per c'o chna jun penak xjara' jlal q'uemjana tumaj rij rsamaj, arja' más chna nim poder c'ola pruk'a' que chenwech anen. Anen me tyataja chwij xtenki'l oc ta ruq'uin nexte che rc'axic nara' rexjab. Arja' nquixruban bautizar per Espíritu Santo ruq'uin k'ak' nquixrbanbej bautizar. ");
INSERT INTO tzjE_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Arja' rchumin chic ri' che nyonaj jwen y jmajo'n wen ta ajni' nuban jun acha nuq'uiek rwech trigo tzra pala, nyonaj trigo chpam je rtz'ilol. C'jara' nuc'ol trigo chpam rc'olibal per je rtz'ilol npuroj pk'ak' per jara' k'ak' majo'n nchuptaj ta. Cara' xbij Juan chca. ");
INSERT INTO tzjE_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús arja' xel ta pGalilea, xba ruq'uin Juan chuchi' binel ya' Jordán. Jrech'bon ela nba che neba'na bautizar rmal Juan. ");
INSERT INTO tzjE_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Per tak xekaja, ja' Juan majo'n nrajo' ta nuban bautizar, cawra xbij tzra: —Per kas rbeyal, anen cnabna' bautizar, per atet tak wan nawajo' catnuban bautizar, cara' xbij Juan. ");
INSERT INTO tzjE_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Y cawra xbixa tzra rmal Jesús: —Camic quenaban wa' bautizar com nc'atzina che nkaban njelal rbeyal je njo'xa chka rmal Dios che nkaban, cara' xbixa tzra Juan. C'jara' Juan xuban bautismo. ");
INSERT INTO tzjE_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ja' Jesús chek xbantaja bautizar xel ta pya' y chek q'uenjlal xjaktaja caj. C'jara' xutz'et Espíritu Santo rxin Dios ajni' jun paloma xkaj ta ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Y c'ola jun kul xc'axaxa penak chcaj y cawra xbij: —Ja c'a wa' quilaj Wlec'wal, congan quenquicota tzrij, cara' xbij rukul Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","C'jara' ja' Jesús xec'mar ela rmal Espíritu Santo, xba chpam tenlic lwar che nba'na tentar rmal diablo. ");
INSERT INTO tzjE_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Cawnak k'ij cawnak ak'a' majo'n xwa' ta. Tak xetz'kata cawnak k'ij cawnak ak'a' xmajtaja rmal k'ak'nic rpam. ");
INSERT INTO tzjE_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ja itzel wnak xba ruq'uin Jesús chnerebna' tentar y cawra xbij tzra: —We ktzitzij at Rlec'wal Dios tbij c'a tzra nic'aj abaj jawra che noca way, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús cawra xbij tzra: —Cawra tz'ibtanak cana chpam rtzojbal Dios: —Je' wnak mruyon ta way nc'atzina chca tzra cc'aslemal per njelal rtzojbal Dios jara' nc'atzina chca chka', cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","C'jara' ja' diablo xuc'om el chic Jesús, xba chpam santlaj tnamet Jerusalén. Tak xe'ekaja xjotba' pe rwá' nimlaj templo rxin Dios ");
INSERT INTO tzjE_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","y cawra xbij tzra: —We ktzitzij che at Rlec'wal Dios tec'ka' ela awi' wawe' com chpam rtzojbal Dios cawra tz'ibtanak cana chawij: —Ja' Dios nquerutak ta ángel che ncatquechjalbej, j-e' nquetz'mowa awxin ch-utz c'ara' majo'n nasoc ta awkan chwech abaj, cara' tz'ibtanak cana, cara' nbij ja' diablo. ");
INSERT INTO tzjE_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ja' Jesús cawra xbij chic tzra: —Cawra tz'ibtanak cana chpam rtzojbal Dios: —Mtaban ta probar Awajaw Dios, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jxuban chic diablo, xuc'om el chic Jesús y xeba pe rwá' jun nimlaj jyu'. Tak xe'ekaja xumaj rc'utic chwech je' gobierno rxin njelal tnamet jc'ola chwech ruch'lew y njelal mibil jc'ola chwech, ");
INSERT INTO tzjE_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","y cawra xbij chic tzra: —We xtcatexque'a chenwech y naya' nuk'ij, anen quenjach pnak'a' je' gobierno rxin njelal tnamet jnemjon rc'utic chawech, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús cawra xbij tzra: —Jat Satanás, catel ela chenwech, com cawra tz'ibtanak cana chpam rtzojbal Dios: —Xruyon Dios Awajaw ncatexque'a chwech, xruyon arja' naya' ruk'ij, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","C'jara' xba ja' diablo xuya' cana Jesús, y chek q'uenjlal xepeta nic'aj ángel xecret-o' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tak xekaja rbixic ruq'uin Jesús che Juan Bautista xecsasa pcars c'jara' xuya' cana lwar abar c'o wa' y xba pGalilea. ");
INSERT INTO tzjE_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tak xekaja pNazaret majo'n xec'je' ta tzra', xba pCapernaum y tzra' xec'je' wa'. Capernaum chiya' c'o wa', tzra' c'o wa' abar c'o wa' c-e' lwar, jun Zabulón rubi' y jun chic Neftalí rubi'. ");
INSERT INTO tzjE_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Cara' xbantaja ch-utz c'ara' tzra' nbantaj wa' cumplir jbitanak cana ojer rmal profeta Isaías tzrij c-e' lwar jcawrara: ");
INSERT INTO tzjE_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","—C'ola nbantaj na chpam c-e' lwar Zabulón ruq'uin Neftalí, jara' lwar tzra' c'o wa' abar c'o wa' mar, pjupraj binel ya' Jordán c'o wa', precwent Galilea c'o wa' jabar ec'o wa' je' wnak jme aj Israel ta. ");
INSERT INTO tzjE_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Je' wnak jec'ola chpam jara' lwar xe pk'ejku'm ec'o wa' nabey mul per nquetz'et na jun nimlaj luz, ec'ola chpam jun bey xe cmic rec'mon ta nabey mul per camic nsakersas na quebey chquewech rmal luz. Cara' bitanak cana. ");
INSERT INTO tzjE_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jesús jara' k'ij xumaj ela rbixic rtzojbal Dios chca wnak y cawra nbij chca: —Jgobierno rxin chcaj xyamer nerkaja rmal c'ara' tak quenbij chewa, tec'xa' ena'oj, tey-a' cana rtzilal, cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ja' Jesús kas remjon binem chuchi' ya' rbin-an Galilea tak ec'ola e c-e' ach-i' xeruwil e alxic, jun Simón rubi', chka' Pedro nbixa tzra, y jun chic Andrés rubi'. Arj-e' com e chpoy ch'u' kas quemjon rq'uiekxic quec'am pya' tak xe'iltaja rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Y cawra xbixa chca: —Jo' quixetre' ta chwij, anen quenya' jun samaj chewa per me chpoj ch'u' xta neban, wnak chic nque'echap, cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Arj-e' xecch'akla' cana quec'am y xetre' ela tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kas quemjon binem ja' Jesús ec'ol chic e c-e' ach-i' xeruwil, chka' e alxic, jun rbin-an Jacobo y jun chic Juan rubi', e rlec'wal Zebedeo, ec'ola chpam jun lanch quexbil quedta', quemjon rchumsic quec'am. Xesiq'uis pona rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Arj-e' alnak xe'el ta chpam lanch, xec'je' cana quedta' chpam y xetre' ela tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús arja' xba nat nkaj chpam departamento Galilea, nquertijoj wnak ptak jay rxin molbal ri'il jabar nquemol wa' qui' che rc'axic rtzojbal Dios, nuya' rbixic chca utzlaj tzij tzrij gobierno je rxin chcaj y chka' ec'ola yuw-i' nquerchumsaj chka bechnak opech nti'ona chca. ");
INSERT INTO tzjE_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Y xba rbixic chpam njelal lwar jc'ola precwent Siria. Xec'mar ela conjelal yuw-i' ruq'uin. Chka bechnak opech yubil cc'an, chka bechnak opech nti'ona chca, wc'ola itzel tak espíritu e'ocnak pcanm, wc'ola rex cmic cc'an, we sic, xec'mar ela conjelal ruq'uin y nquerchumsaj. ");
INSERT INTO tzjE_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Y congan e q'uiy wnak xetre' ela tzrij ajni' chca jec'ola chpam departamento Galilea, jec'ola chpam lwar rbin-an Decápolis y chca aj Jerusalén y jec'ola chpam jle' chic tnamet jc'ola precwent Judea, chka' jec'ola pjupraj binel ya' Jordán. ");
INSERT INTO tzjE_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ja' Jesús tak xutz'et che congan e q'uiy wnak arja' xba, xojte'a chwech jun jyu', xuwil jun lwar y tzra' xetz'be' wa'. Je' rdiscípulo xe'ekaja ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Xumaj c'a ctojxic y cawra xbij chca: ");
INSERT INTO tzjE_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Congan quicotemal rxin Dios nyataja chca wnak jcutkin che nc'atzin wa' Espíritu rxin Dios chca ch-utz c'ara' ja' nwankersana rmibil Dios ptak canm com cxin c'ara' jgobierno rxin chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Congan quicotemal rxin Dios nyataja chca wnak je nque'ok'a y nquebisona com nyukbax na quec'u'x. ");
INSERT INTO tzjE_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Congan quicotemal rxin Dios nyataja chca wnak tak nquewil je' achnak chpam cc'aslemal tak arj-e' ne pruk'a' Dios nquejach wa' com chca nyataj wa' jun herencia. Ja herencia je nyataja chca jara' rwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Congan quicotemal rxin Dios nyataja chca wnak jcongan necyarij nquetzuk canm che rbanic rbeyal je nrajo' Dios com je rbeyal jnecyarij jara' xtnoj na ptak canm. ");
INSERT INTO tzjE_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Congan quicotemal rxin Dios nyataja chca wnak jnecpoknaj quewech wnak com arj-e' npoknax na quewech chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Congan quicotemal rxin Dios nyataja chca wnak jch'ajch'oj rwech canm com arj-e' nquetz'et na rwech Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Congan quicotemal rxin Dios nyataja chca wnak je nquechumina je' wnak che qui'il nquec'je'a chbil tak qui' com tzra' nque'otkix wa' che e rlec'wal Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Congan quicotemal rxin Dios nyataja chca wnak je nba'na lowlo' chca rmal je nqueban rbeyal rxin Dios com cxin c'ara' jgobierno rxin chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Congan quicotemal rxin Dios nyataja chewa tak nquixtz'u'ja y nquixyo'k'a y tak nba'na njelal rwech lowlo' chewa y tak nbixa njelal rwech rtzilal chewa jme ktzij ta y xe nmal anen tak cara' nba'na chewa. ");
INSERT INTO tzjE_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tak cara' nqueban chewa quixquicot c'a, per ncongan quixquicota, com jara' c'ola jun nimlaj rtojbalil nyataj na chewa chcaj. Quixquicota com cara' xba'na chca ojer tak profeta, congan lowlo' xba'na chca. ");
INSERT INTO tzjE_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ixix ix atz'am rxin jawra rwech ruch'lew, kas wen retzyil cc'aslemal wnak neban. Per atz'am we xk'axa, jara' majo'n chic retzyil y ¿nak nchomrsbex chic rxin? We xk'axa, jara' majo'n chic rc'atzil, xe nch'akix ela y npa'k' cana chakan cmal wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ixix ix luz wawe' chwech ruch'lew che nesakersaj quebey wnak. Ajni' tzra jun tnamet pe rwá' jun jyu' c'o wa', mesquier necwina niwaj ri'. ");
INSERT INTO tzjE_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ajni' nqueban wnak majo'n nquetzaj ta jun candil y xtecjupba' ta jun cjon tzrij. Per je nqueban, nquetzaj jcandil y chcaj nectzakba' wa' ch-utz c'ara' je' wnak jec'ola pjay psak nquec'je' wa' che conjelal. ");
INSERT INTO tzjE_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Cara' tc'a nuban jluz jc'ola ptak ewanm ixix chka', xtsakersaj ta quebey wnak chquewech ch-utz c'ara' je' wnak tak xtquetz'et utzil jneban chca, arj-e' xtqueya' ta ruk'ij Ttixel ewxin jc'ola chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mexte tech'ob chwij che anen enpenak che quenreyjo' kaja ley jtz'ibtanak cana rmal Moisés ruq'uin tijonem jtz'ibtanak cana cmal profeta. Per mcara' ta, me enpenak ta che quenreyjo', anen enpenak che quenrebna' cumplir. ");
INSERT INTO tzjE_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cara' quenbij chewa com jara' ley ne nbantaj wa' cumplir njelal, per nexte jtz'it tzra mquita xtbantaja cumplir. Ne ktzij wa' je xtenbij chewa ra, majo'n pen ta nq'uis wa' caj ruq'uin rwech ruch'lew que chwech jun ch'it punto rxin ley mquita xtbantaja cumplir. ");
INSERT INTO tzjE_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Je' wnak chka bechnak wnak opech wc'ola jun mandamiento rxin ley, we nqueban tzra com ajni' majo'n y necbij tzra chjawra mandamiento majo'n kas ta nc'atzina nnimaxa, y wcara' nquec'ut chquewech wnak, arj-e' chka' majo'n nmak ta quek'ij chpam gobierno je rxin chcaj. Per je' wnak necnimaj mandamiento y ncara' nquec'ut chquewech wnak chka', arj-e' nmak quek'ij chpam gobierno je rxin chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Anen quenbij chewa, je rbeyal rxin Dios jneban we xjunam ajni' rbeyal je nqueban maestro je nquetijona cxin wnak tzrij rley Dios, we xjunam ajni' rbeyal nqueban aj fariseo, jara' majo'n nquixoc ta chpam gobierno je rxin chcaj, ne nc'atzin wa' che ixix neban más rbeyal rxin Dios que chwech je nqueban j-e'. ");
INSERT INTO tzjE_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ixix ewc'axan jbitanak cana ojer chca wnak jcawrara: —Mteban ta cmic, wc'ola jun xtuban cmic jara' nk'a't na tzij tzrij. Cara' bitanak cana. ");
INSERT INTO tzjE_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Per anen quenbij chewa, wc'ola jun nuban ryiwal tzra jun rch'alal jara' nk'a't na tzij tzrij. Wc'ola jun nbij tzra rch'alal: —Tak at necnic, wcara' nbij tzra, jara' nec'mar ela chquewech nmak tak k'atbaltzij che nk'e'ta tzij tzrij. Wc'ola jun nbij tzra rch'alal: —Xat itzel wnak, majo'n Dios awq'uin, wcara' nbij tzra, jara' nec'je' cana chpam jun nimlaj lowlo' je chpam k'ak'. ");
INSERT INTO tzjE_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Rmal c'ara' quenbij chewa, tak c'ola ofrenda nec'om pa, wech'bon neya' chwech altar y netzujuj chwech Dios, per xerkaja pnewá' che ebnon lowlo' tzra jun ewch'alal, ");
INSERT INTO tzjE_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jneban camic, mtetzujuj tna e'ofrenda, tey-a' cana abar tzra' c'o wa' altar, jax echumij ewi' nabey mul ruq'uin ewch'alal. Tak xtquixchumtaja ruq'uin quixemloj ta, c'jara' c'a utz chic netzujuj e'ofrenda. ");
INSERT INTO tzjE_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Wc'ola jun nyowa part chewij, per jneban camic tak emjon binem che nquixba pk'atbaltzij tchumsla' ewi' ruq'uin. We mcara' ta neban, je nyowa part chewij arja' nquixrujach pruk'a' juez y ja' juez nquixrujach pruk'a' policía y nquixrucsaj pcars. ");
INSERT INTO tzjE_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ne ktzij wa' je xtenbij chewa ra, nmajo'n nquixel ta pcars, c'jara' nquixel ta tak netoj cana njelal ec'as, per next jun centavo mquita xtetoj cana. ");
INSERT INTO tzjE_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Chka' ewc'axan jbitanak cana ojer jcawrara: —Mtquixoc ta cuq'uin ixki' jme ewexkilal ta, ruq'uin je ixki' mtque'oc ta cuq'uin ach-i' jme e quechjilal ta. Cara' bitanak cana. ");
INSERT INTO tzjE_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Per anen quenbij chewa, wc'ola jun xutz'et jun ixak y xyarij kaja pranm jara' junam ruq'uin che xoca ruq'uin ixak je xyarij kaja pranm. ");
INSERT INTO tzjE_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","We ek'awech jc'ola pnewejquenk'a' xe nquixerchajtij y nquixerkasaj chpam il mac, jneban camic tewsaj ela y tch'akij ela. Cara' quenbij chewa com más na utz netz'ila' jun ek'awech que chwech njelal ecuerpo nba pk'ak'. ");
INSERT INTO tzjE_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","We ek'a' jc'ola pnewejquenk'a' xe rmal tak nquixkaja chpam il mac, jneban camic tch'upuj ela y tch'akij ela chka' com más na utz netz'ila' jun ek'a' que chwech njelal ecuerpo nba pk'ak'. ");
INSERT INTO tzjE_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Cawra bitanak cana ojer chka': —Wc'ola jun junlic xujach cana rexkayil nc'atzina nuban cana jun wuj y ntz'ibaj cana chpam che junlic nujach cana, y tak xec'choja wuj nujach cana tzra ixak. Cara' bitanak cana. ");
INSERT INTO tzjE_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Per anen quenbij chewa, jun acha chka bechnak acha opech, wnujach cana junlic rexkayil y ja' rexkayil majo'n majcunnak ta ruq'uin jun chic acha jara' xnumin rexkayil chnuban adulterio. Y wc'ola jun acha nuc'om jun ixak xe jchon cana jara' acha adulterio nuban chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jun chic jewc'axan jbitanak cana chca wnak ojer jcawrara: —Mexte me ktzij ta teban tak neban jurar, per achnak netzujuj tzra Kajaw Dios y jneban jurar tzra tebna' c'a cumplir. ");
INSERT INTO tzjE_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Per anen quenbij chewa, nexte wjic teban ta jurar. Mteban ta jurar prubi' caj com jcaj jara' ocnak rtz'ulibal Dios jnimlaj Rey. ");
INSERT INTO tzjE_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mteban ta jurar prubi' ruch'lew chka' com ruch'lew jara' ocnak rpalibal rkan Dios. Mteban ta jurar prubi' tnamet Jerusalén chka' com Jerusalén jara' ocnak retnamet Dios jnimlaj Rey. ");
INSERT INTO tzjE_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nexte tecsaj ewá' chka' che nebanbej jurar com ixix mtquixecwina neq'uex rcolor jun ch'it resmal ewá' xteban ta sak tzra o k'ak. ");
INSERT INTO tzjE_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tak c'ola jun achnak nebij, wxebij j-e, j-e c'ara', wxebij mne', mne' c'ara'. Wc'ola jle' chic tzij je mja' ta j-e, owe mne', jara' xe rxin diablo. ");
INSERT INTO tzjE_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jun chic jewc'axan jbitanak cana ojer: —Wc'ola jun xatz'ila' jun rk'arwech cara' nba'na chawa atet chka', ncara' rec'xel nba'na chawa, ntz'iloxa jun ak'awech. Wc'ola jun xawsaj jun réy cara' nba'na chawa atet chka', nba'na rec'xel chawa, newsas na jun awéy. Cara' bitanak cana. ");
INSERT INTO tzjE_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Per anen quenbij chewa, mteya' ta rec'xel chca je nquebnowa lowlo' chewa. Jneban camic, wc'ola jun xuya' jun k'a' chaplaj tey-a' c'as tzra chnuya' jun chic pjupraj aplaj. ");
INSERT INTO tzjE_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Wc'ola jun xixruc'om ela pk'atbaltzij y nrajo' numaj ecmis, jneban jara' tey-a' tzra y tey-a' echump tzra chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wc'ola jun xixruban mandar che nquixoca xuxe' jun ejka'n y nquixetre' ela tzrij y nbij chewa q'ue pjun kilómetro ney-a' wa', per jneban ixix jara' q'ue pe c-e' kilómetro ney-a' wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wc'ola jun xc'utuj jun achnak chawa tey-a' tzra, y wc'ola jun nrajo' nukaj pak chawa tey-a' tzra chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jun chic jewc'axan jbitanak cana ojer: —Que'ewaj-o' eprójimo y itzel que'etz'ta' je nquetzelana ewxin. Cara' bitanak cana. ");
INSERT INTO tzjE_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Per anen quenbij chewa, que'ewaj-o' je nquetzelana ewxin. Wec'ola nquebina itzel tak tzij chewa per ixix xruyon utzlaj tak tzij nebij chca, y wec'ola xitzel nquixquetz'et per ixix xutzil tebna' chca, y tak ec'ola nquetz'juwa ewxin y pkan je' tzij necbij chewa per ixix tebna' orar pquecwent. ");
INSERT INTO tzjE_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Cara' ta neban ch-utz c'ara' ne ix k'alaj wa' che ix rlec'wal Dios Ttixel jc'ola chcaj, ajni' nuban ja' nelsaj ta k'ij pquewá' wnak chka bechnak wnak opech, che e itzel tak wnak o we e utzlaj tak wnak, y chka' nkasaj jab pquewá' conjelal je nquebnowa rbeyal rxin Dios y chka' jmajo'n nqueban ta rbeyal. ");
INSERT INTO tzjE_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cara' quenbij chewa com wex queyon j-era' lok' nque'ena' jlok' ixquen-on ixix ¿lc'ola rtojbalil nyataja chewa nech'ob ixix tak cara' neban? Tak wex cara' neban ix junam ra cuq'uin e mloy tak impuesto com arj-e' lok' nquena' chbil tak qui'. ");
INSERT INTO tzjE_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Y wex queyon ewch'alal nque'ek'ijla' xjunam ebanic ra cuq'uin wnak chka bechnak wnak opech. Cara' quenbij chewa com je' wnak majo'n opech cutkin ta rwech Dios arj-e' nqueck'ijla' cch'alal chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Rmal c'ara' quenbij chewa, ajni' rebnon Edta' Dios jc'ola chcaj nmajo'n mquita nojnak ojben ri'il pranm cara' c'a chewa ixix chka' nc'atzina che nnoja ptak ewanm ojben ri'il rxin Dios chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ec'ola je' wnak tak nqueya' ruk'ij Dios per xe chquewech wnak nqueban wa' ch-utz c'ara' nya'a quek'ij nquech'ob j-e'. Per ixix tebna' cwent, mteban ta cara', wex cara' neban nmajo'n achnak nech'ec che nyataja chewa rmal Ttixel jc'ola chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Rmal c'ara' quenbij chewa, tak c'ola jun ayuda nesipaj mtewsaj ta rtzojxic ajni' nqueban wnak xcaca' queplaj. Arj-e' xe chpam jay rxin molbal ri'il necsipaj wa' ayuda ruq'uin ptak bey ch-utz c'ara' nya'a quek'ij cmal wnak je nquetz'towa cxin. Anen ne ktzij wa' quenbij chewa, tak nya'a quek'ij cmal wnak, ruyon oca jara' nquech'ec y majo'n chic nak. ");
INSERT INTO tzjE_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Per ixix tak c'ola jun ayuda nesipaj nmajo'n ta rbixic newsaj y nmajo'n xtcutkij ta jec'ola ewq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Cara' ta neban ch-utz c'ara' majo'n achnak notkina. Wcara' neban, je Ttixel ewxin jnutz'et njelal mesque wewtanak chquewech wnak, arja' nuya' chewa jun rtojbal per ne chquewech wnak nuya' wa' chewa. ");
INSERT INTO tzjE_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jun chic, tak neban oración mteban ta cara' ajni' nqueban wnak xcaca' queplaj. Cara' quenbij chewa com arj-e' congan nel ta quec'u'x tzrij tak nquepe'a ptak jay rxin molbal ri'il che rbanic oración ruq'uin ptak je' esquina rxin bey. Cara' nqueban ch-utz c'ara' nya'a quek'ij cmal wnak je nquetz'towa cxin. Anen ne ktzij wa' quenbij chewa, tak nya'a quek'ij cmal wnak ne xruyon oca jara' nquech'ec tzrij y majo'n chic jun achnak. ");
INSERT INTO tzjE_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Per ixix tak neban jun oración quixoca ptak ewuchoch y ttz'apij echi' y quixtzijon c'a ruq'uin Ttixel ewxin jmajo'n ntz'ettaj ta y rutkin njelal achnak mesque wewtanak chquewech wnak, y arja' nuya' chewa jun rtojbal per ne chquewech wnak nuya' wa' chewa. ");
INSERT INTO tzjE_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Jun chic, tak neban oración mteban ta ajni' nqueban wnak jmajo'n cutkin ta rwech Dios. Cara' quenbij chewa com arj-e' chek carat neccamluj rbixic je' quetzij jmajo'n noc wa', nquech'ob j-e' tak chek carat neccamluj quetzij nc'axaxa c-oración. ");
INSERT INTO tzjE_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mteban ta cara' ixix ajni' nqueban j-e' com Ttixel ewxin arja' rutkin chic nak nc'atzina chewa mesque q'uemjana tec'utuj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Rmal c'ara' quenbij chewa, tak neban oración cawra nebij: —Kadta' Dios jatc'ola chcaj, lok' ta xtna'a abi' cmal wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tkaj pc'a agobierno wawe' chwech ruch'lew, xtbantaj ta wawe' ajni' nrajo' awanm ajni' nba'na chawa tzra' chcaj ne ncatnimax wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","K'ij k'ij xtaya' ta kaway je nc'atzina chka. ");
INSERT INTO tzjE_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tecyu' kil kamac ajni' nkaban ajoj nquekacuy je' wnak tak nqueban je' lowlo' tak achnak chka. ");
INSERT INTO tzjE_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Atet ta xtcatchajina kxin y mquita xtokkaja pruk'a' diablo, ko'at-o' pruk'a'. Jawra nekc'utuj chawa com pnak'a' atet c'o wa' njelal gobierno, y pnak'a' c'o wa' njelal poder, y noc na yabal ak'ij njelal achnak, y at cara' rxin junlic chpam je' tiemp jpenak. Amén. Cara' ta rbanic oración neban. ");
INSERT INTO tzjE_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tak nque'ecuy je' wnak tak nqueban lowlo' chewa ja' Ttixel ewxin jc'ola chcaj nquixrucuy chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wmajo'n nque'ecuy ta, chka' ja' Ttixel majo'n nquixrucuy ta. ");
INSERT INTO tzjE_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jun chic, tak ixix neban jun ayuno chneyabej ruk'ij Dios mteban ta ajni' nqueban je' wnak xcaca' queplaj com j-e' xjic necyarij tak nbis nqueban tzra queplaj, per nlowlo' bis nqueban ch-utz c'ara' nquetz'e'ta cmal wnak che ayuno quemjon rij. Anen ne ktzij wa' je xtenbij chewa, tak nya'a quek'ij cmal wnak tak nqueban ayuno njara' oca nquech'ec tzrij y nmajo'n chic jun achnak. ");
INSERT INTO tzjE_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Per ixix tak neban ayuno kas bien tchumsaj ewi', tejca' ewá' y bien tech'ja' eplaj ");
INSERT INTO tzjE_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ch-utz c'ara' je' wnak majo'n ncutkij ta che ayuno emjon rbanic, y xjun oca ojtakyona jara' Ttixel ewxin jmajo'n ntz'ettaj ta. Wcara' neban, Ttixel ewxin jnutz'et njelal achnak mesque wewtanak chquewech wnak, arja' nuya' na chewa jun rtojbal per ne chquewech wnak nuya' wa' chewa. ");
INSERT INTO tzjE_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Me tba ta ec'u'x tzrij q'uiyersan mibil wawe' chwech ruch'lew com mibil rxin rwech ruch'lew xe nchecpina o xe nc'uxara, y mpen ta chka' nque'oca elk'oma' ruq'uin y nquelk'aj ela. ");
INSERT INTO tzjE_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Per jneban, tba ec'u'x tzrij q'uiyersan mibil rxin chcaj com mibil rxin chcaj jara' majo'n nchecpin ta y majo'n xtc'uxar ta, y majo'n nque'ekaj ta elk'oma' tzra' che xtquelk'aj ta. ");
INSERT INTO tzjE_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Anen xenbij jawra tzij chewa com achnak mibil bnak wa' ec'u'x, tzra' c'a c'o wa' ewanm chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ja ek'awech cara' rbanic ajni' jun luz je ixrey-on psak, wmajo'n yojtanak ta y majo'n achnak rebnon jara' psak c'ara' c'o wa' njelal ecuerpo. ");
INSERT INTO tzjE_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Per we xyojtanak ek'awech jara' pk'ejku'm c'ara' c'o wa' njelal acuerpo. Y cara' c'a tzra luz jyatanak chewa ptak ewanm, we nchu'pa jara' congan jun nimlaj k'ejku'm nquixec'je' wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jun wnak chka bechnak wnak opech majo'n xtec'je' ta e c-e' rpatrón, wcara' nuban jara' jun wen nutz'et y jun chic xitzel nutz'et, o we nnimaj jun y jun chic mtnimaj. Cara' c'a chka', mesquier xteyke' ta ac'u'x ruq'uin Dios y xteyke' ta ac'u'x ruq'uin mibil rxin rwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Rmal c'ara' tak quenbij chewa, mtek'aysaj ta ewi' chpam ec'aslemal y xtech'ob ta: —¿Nak nkataj chc'a wa'? y xtech'ob ta tzrij etziak: —¿Nak nkacsaj chc'a wa'? Mtech'ob ta cara'. Dios nuya' njelal je nc'atzina tzra ec'aslemal ruq'uin tzra ecuerpo. ¿Le mtuya' c'ara' chewa chka' nak netaj ruq'uin etziak? ");
INSERT INTO tzjE_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","¿Le mtque'etz'et c'a ch'tak tz'quin je nquerupina chcaj? Arj-e' nmajo'n jun ctejco'n quetcon ta y nmajo'n jun csech xtquemol ta per Edta' jc'ola chcaj arja' netzkuwa cxin. Per ¿lme ixix tc'a más ix vale que chquewech tz'quin? ");
INSERT INTO tzjE_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Jun chic, per nmajo'n jun chewa mesque ncongan xtk'aysaj ri' xtecwin ta ruyon xtuwik ta rq'uiybal y xtel ta más nim rkan. ");
INSERT INTO tzjE_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Y tzrij tziak ¿nak tzra tak nek'aysaj ewi' tzrij che rconxic? Tewsaj ena'oj tzrij ctz'e'j nak nuban tak nq'uiya ptak k'ayis, nmajo'n nesmaj ta y nmajo'n nk'inon ta. ");
INSERT INTO tzjE_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Anen quenbij chewa camic, ja ojer rey Salomón mesque ncongan byom per nmajo'n tziak xucsaj ta ntk'axnak wen je' retz'balil ajni' retz'balil je' ctz'e'j. ");
INSERT INTO tzjE_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Je' ctz'e'j mesque xe ncoma, mesque xnechkija chanim y nporoxa pk'ak', per Dios nuya' retz'balil. Wcara' nuban ¿le mtuya' c'ara' chewa chka' je' etziak jnecsaj? Xerwara' quenbij chewa, majo'n kas ta ykula ec'u'x ruq'uin Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Rmal c'ara' quenbij chewa, mtek'aysaj ta ewi': —¿Nak nkataj chc'a wa'? mtebij ta cara', chka' mtebij ta: —¿Nak tziak nkacsaj chc'a wa'? ");
INSERT INTO tzjE_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Cara' quenbij chewa com je' wnak jmajo'n cutkin ta rwech Dios j-era' nquebnowa cara'. Jchewa ixix, ja Edta' Dios jc'ola chcaj arja' bien rutkin njelal je' achnak jawrara je nc'atzina chewa. ");
INSERT INTO tzjE_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Per kas nc'atzina neban, rgobierno Dios tech'bo' nabey mul y chka' tebna' rbeyal je rxin ja' Dios. Wcara' neban, njelal achnak je nc'atzina chewa jara' nyataja chewa. ");
INSERT INTO tzjE_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Rmal c'ara' quenbij chewa, mtek'aysaj ta ewi' rmal jpenak chewech je rxin chwak cabij. Wc'ola je' problema rxin chwak ne rxin chwak wc'ara', mteban ta camic. Jujun k'ij nq'uiy wa' je' reproblema rec'mon ta. ");
INSERT INTO tzjE_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mtquixoc ta ix k'toy tak tzij chquij wnak ch-utz c'ara' ja' Dios majo'n nuk'at ta tzij chewij chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Cara' quenbij chewa com nak necsaj chquij wnak che nek'atbej tzij chquij jara' nucsasa chewij ixix chka'. Ajni' neban chca wnak cara' nuban Dios chewa ixix chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Nak tzra tak nech'ulchin tak nuban jun ch'it ril ewch'alal per majo'n nena' kta ixix je' nmak tak ewil jneban? Tak neban cara' jara' junam ruq'uin tak nach'ulchij jun rc'utal che' jc'ola chi' rk'arwech ewch'alal per majo'n netzu' kta jun nimlaj che' jc'ola pnek'awech ixix. ");
INSERT INTO tzjE_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Chka' nak tzra tak nebij tzra ewch'alal cawrara: —Wch'alal, ko'awc'axaj jun rmaj, nkajo' nkaya' ana'oj tzrij il mac jc'ola chpam ac'aslemal, cara' nebij tzra, per chpam ec'aslemal ixix más na q'uiy il mac c'ola chpam. ");
INSERT INTO tzjE_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jara' xcaca' eplaj neban. Wnewajo' neya' rna'oj ewch'alal nc'atzina nabey mul neya' cana rtzilal jc'ola chpam ec'aslemal ixix ch-utz c'ara' nquixecwina neya' utzlaj na'oj tzra ewch'alal. ");
INSERT INTO tzjE_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Je' achnak rxin Dios mteya' ta chquewech tz'e' y je rmibil mteq'uiek el ta chquewech a'k, jara' xe nquepak' kaja pe ckan y c'jara' nqueba chawij y ncatquexil. ");
INSERT INTO tzjE_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tc'utuj tzra Dios je nc'atzina chewa y arja' nuya' chewa, tcanoj jnewajo' y newil, ttarij chijay y nja'ka chewech. ");
INSERT INTO tzjE_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Cara' quenbij chewa com conjelal je nquec'utuna nyataja chca, je nquecanona nyataja chca che nquewil y je nquetarina chijay nja'ka chquewech. ");
INSERT INTO tzjE_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","O ¿lc'ola jun ttixel chewa ixix tak nc'utuxa jun xquelway tzra rmal jun rlec'wal y jun abaj nuya' pruk'a'? ");
INSERT INTO tzjE_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O we nc'utuxa jun ch'u' tzra ¿lnuya' jun cmetz tzra? ");
INSERT INTO tzjE_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ixix mesque ix lowlo' per ewutkin neya' utzlaj tak achnak chca ewlec'wal, peor c'ara' Edta' ixix jc'ola chcaj, arja' nuya' utzlaj tak achnak chca je nquec'utuna tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Cara' c'a rbanic, nak neyarij ixix che nba'na chewa cmal wnak cara' c'a tebna' ixix chka' chca j-e'. Com cara' nuc'ut chkawech rtzojbal Dios jtz'ibtanak cana chpam ley y cmal je' profeta. ");
INSERT INTO tzjE_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","C'ola jun pe rchijay congan co'la per xerwara' nquixrey-a' chpam utzlaj c'aslemal je rxin Dios, jara' pe rchijay chpam quixoc wa'. Cara' quenbij chewa com c'o chna jun pe rchijay congan nim y ncatruya' chpam jun bey congan nim rwech chka', mpen ta ncatoca chpam per xerwara' xe chpam nimlaj lowlo' ncaterc'aj wa', jara' pe rchijay e q'uiy je' wnak nque'oca chpam. ");
INSERT INTO tzjE_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Cara' quenbij chewa com pe rchijay je nquixrey-a' chpam utzlaj c'aslemal je rxin Dios jara' ch'it co'l rwech y ncatruya' chpam jun bey congan pen y xme q'uiy ta nquewlowa. ");
INSERT INTO tzjE_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tebna' cwent ewi' chquewech wnak je profeta nquechexa per me ktzij ta che e profeta. Arj-e' tak nque'ekaja ewq'uin neck'alsaj qui' chewech chmajo'n nak itzel nqueban chewa, e ajni' ch'tak carne'l nquetz'e'ta per ptak canm e ajni' utiwa', xe cmic nqueban. ");
INSERT INTO tzjE_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ajni' tzra jun che', rmal rwech jnuya' tzra' nawutkij wa' nak che'al, y cara' c'a chca wnak chka', rmal jnatz'et chpam cc'aslemal tzra' nawutkij wa' nak cbanic. Ta q'uix majo'n xtwachij ta uva nexte xulquiej xtwachij ta higo. ");
INSERT INTO tzjE_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Cara' c'a rbanic, njelal utzlaj tak che' kas wen rwech nuya' y njelal itzel tak che' itzel rwech nuya'. ");
INSERT INTO tzjE_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ja utzlaj che' majo'n xtuya' ta itzel rwech nexte itzel che' xtuya' ta wen rwech. ");
INSERT INTO tzjE_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Njelal che' jmajo'n wen ta rwech nuya' jara' ncho'ya y nporoxa pk'ak'. ");
INSERT INTO tzjE_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Cara' c'a cbanic wnak, rmal je ntz'e'ta chpam cc'aslemal tzra' nawutkij wa' nak cbanic. ");
INSERT INTO tzjE_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Je' wnak je nquebina chwa: —Kajaw, Kajaw, arj-e' mconjelal ta nyataja chca che nque'oca chpam gobierno je rxin chcaj, per achnak nquebnowa ajni' nrajo' ranm Nedta' jc'ola chcaj j-era' nyataja chca che nque'oca chpam gobierno je rxin chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tak xterla' nimlaj k'ij rxin juicio e q'uiy wnak cawra necbij chwa: —Kajaw, Kajaw ¿le me pnabi' tc'a atet xkaya' wa' rbixic rtzojbal Dios? ¿Le me pnabi' tc'a atet xekawsaj el wa' je' itzel tak espíritu ptak canm wnak? ¿Lme pnabi' tc'a atet chka' xkaban nmak tak milagro? ");
INSERT INTO tzjE_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Y anen cawra quenbij chca: —Anen majo'n xenwutkij ta ewech, quixel ela chenwech ix bnoy itzel tak achnak. Cara' quenbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nak nquec'axana jnemjon rbixic y we necnimaj jquenbij chca che nqueban, arj-e' cawra cbanic, e junam ruq'uin jun acha congan rna'oj, xuban jun ruchoch y pe rwá' abaj xutic wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xumaj c'a rij jun nimlaj k'jaljab y congan xq'uiya rkan tak ya' y xjaktaj ta jun nimlaj k'ek'. Congan lowlo' xba'na tzra jay per majo'n xba ta penlew com pe rwá' abaj c'o wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nak nquec'axana je nemjon rbixic y majo'n necnimaj ta jquenbij, arj-e' cawra cbanic, e junam ruq'uin jun acha jmajo'n rna'oj jxutic jun ruchoch y psenyi' xtz'uba' wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xumaj c'a rij jun nimlaj k'jaljab y congan xq'uiya rkan tak ya' y xjaktaj ta jun nimlaj k'ek'. Congan lowlo' xba'na tzra jay y xc'axa ptak ulew y che njelal xyojtaja. Cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tak xbitaja njelal tzij rmal Jesús j-e' wnak kas xel ta quec'u'x tzrij jtijonem nuya'. ");
INSERT INTO tzjE_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Cara' xqueban wnak com jtijonem nuya' chca congan nqueruchap, bien k'alaj chruq'uin Dios penak wa' je nbij, mjunam ta ruq'uin tijonem je nqueya' je' maestro je nquetijona cxin wnak tzrij rley Dios jtz'ibtanak cana rmal Moisés. ");
INSERT INTO tzjE_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ja' Jesús xexle' ta chwech jyu', tak xkaj ta congan e q'uiy wnak xetre'a tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Chek q'uenjlal tak c'ola jun yawa' xekaja ruq'uin c'ola itzel yubil lepra rc'an, xexque'a chwech y cawra xbij tzra: —Wajaw, wnawajo' cnachumsaj, anen wutkin che ncatecwina cnachumsaj, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ja' Jesús xuyuk pona ruk'a', xuchap yawa' y cawra xbij tzra: —Quenwajo' ajni' nac'utuj chwa, catchumtaja, cara' xbij tzra, y nalnak xel ela jyubil lepra tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Cawra xbij chic tzra: —Majo'n abar nabij wa' jxenban chawa. Jnaban, jat ac'tu' awi' chwech sacerdote y ay-a' awofrenda ajni' rbin cana Moisés chpam rley Dios chnaban. Ja ofrenda naya' jara' nac'utbej chquewech sacerdote chnaban cumplir je rbin cana Moisés, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ja' Jesús tak xekaja chpam tnamet Capernaum c'ola jun capitán cxin soldado xekaja ruq'uin y cawra xbij tzra: ");
INSERT INTO tzjE_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Wajaw, c'ola jun nmos c'ola chwuchoch, arja' squirnak y congan lowlo' nuban rmal, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Anen quenba ruq'uin y cnechumsaj, cara' xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Per ja' capitán cawra xbij tzra: —Wajaw, atet najni'la nim ak'ij, me tyataja chawij che xcatoc ta chpam wuchoch. Jquenwajo' chawa, tbij che nec'choja nmos y wutkin che xruq'uin ra nchumtaja. ");
INSERT INTO tzjE_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Cara' quenbij chawa com anen wutkin nak rbanic tak ncatba'na mandar. Ec'ola nquebnowa mandar wxin y chka' ec'ola soldado pnuk'a' anen chquenuban mandar. Tak quenbij tzra jun: —Catel ela, jara' nel wara'. Tak quenbij tzra jun chic: —Catjo', ne npet wara'. Tak quenbij tzra nmos che: —Tebna' jawrara, arja' nuban wara'. Cara' xbij capitán. ");
INSERT INTO tzjE_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ja' Jesús congan xel ta ruc'u'x tak xc'axaj je xbixa tzra rmal capitán. Com ec'ola nic'aj wnak etrena tzrij cawra xbij chca: —Ne ktzij wa' je xtenbij chewa ra, jcapitán arja' más na ykula ruc'u'x wq'uin que chewech ixix ix aj Israel, next jun chewa newlon ta cara' yukbal ruc'u'x wq'uin ajni' rxin ja'. ");
INSERT INTO tzjE_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Camic quenbij chewa che e q'uiy wnak jme aj Israel ta nquepe na nat nkaj, nque'oc na chpam gobierno je rxin chcaj y nquetz'be'a chwech mes y junam nquewa'a ruq'uin Abraham ruq'uin Isaac y ruq'uin Jacob. ");
INSERT INTO tzjE_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Per alc'walxela' je ntzujuxa gobierno je rxin chcaj chca, arj-e' xe nqueq'uie'k ela chpam nimlaj k'ejku'm. J-e' wnak ajni'la ok'ej xtqueban chpam jara' lwar y xteccach'ch'ej na rkan cak'. Cara' xbij Jesús chca wnak jetrena tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","C'jara' xbij chic tzra capitán: —Camic jat, com ykula ac'u'x wq'uin che quencwina quenchumsaj amos y cara' c'a nbantaja, nchumtaja, cara' xbij. Y jara' hor xchumtaja mos. ");
INSERT INTO tzjE_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","C'jara' xba Jesús chruchoch Pedro. Tak xekaja xoca pjay y xutz'et rjite' Pedro c'ola chwech ch'at yawa', majtanak rmal c'ten. ");
INSERT INTO tzjE_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xuchap chuk'a' y xela c'ten tzrij. C'jara' xyictaja y xumaj quelxic Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tak xoca ak'a' e q'uiy wnak xec'mar ela chwech Jesús, ec'ola itzel tak espíritu e'ocnak ptak canm. Ja' Jesús xjun tzij xbij y jara' tzij xerlasbej itzel tak espíritu ptak canm y xerchumsaj conjelal yuw-i' chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Cara' xuban ch-utz c'ara' tzra' nbantaj wa' cumplir jbitanak cana rmal profeta Isaías jcawra nbij: —Arja' xrejkaj ela njelal achnak je nti'ona chka y xoca chuxe' je' kyubil. ");
INSERT INTO tzjE_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ja' Jesús tak xerutz'et chcongan je' wnak quemlon qui' tzrij cawra xbij chca rdiscípulo: —Jo' pjupraj ya', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","C'ol c'a jun acha arja' jun chca jmaestro je nquetijona cxin wnak tzrij rley Dios, xekaja ruq'uin Jesús y cawra xbij tzra: —Maestro, anen quenba chawij xabar tzra' ncatba wa' atet. ");
INSERT INTO tzjE_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús cawra xbij tzra: —Je' chcop c'ola cc'olibal abar nquewar wa', chka' je' ch'tak tz'quin c'ola quesoc, per chwa anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak majo'n wuchoch nte wxin ja abar quenwar wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Xpe chic jun rdiscípulo y cawra xbij tzra: —Wajaw, tey-a' c'as chwa che cnemku' cana nedta' nabey mul, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Cawra xbixa tzra rmal Jesús: —Jo' catetre' ta chwij, je cnomki' chwech Dios arj-e' nquemuk kaja je' qui' queyon. Cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ja' Jesús xoc ela chpam lanch e rexbil rdiscípulo y xeba. ");
INSERT INTO tzjE_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Chek q'uenjlal tak xjaktaj ta jun nimlaj k'ek' chquij. Jlanch nlowlo' nba'na tzra rmal nmak tak bloj per Jesús kanak chuwram. ");
INSERT INTO tzjE_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Je rdiscípulo xquec'as: —Ko'at-o' Kajaw, camic nokcoma, nokba pya', cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","—¿Nak tzra tak nexibej ewi'? Tak nmajo'n nim ta yukbal ec'u'x wq'uin, cara' xbixa chca rmal Jesús. C'jara' xyictaja, xuk'il k'ek', chka' xuk'il nmak tak bloj, y xcoma k'ek' y rwá' ya' xetz'le'a. ");
INSERT INTO tzjE_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","J-e' discípulo congan xel ta quec'u'x tzrij tak xquetz'et je xbantaja y cawra xquemaj rbixic chbil tak qui': —¿Nak rbanic c'ala' jala' acha? Nnimax tak wan rmal k'ek' y nnimaxa rmal ya' chka', cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ja' Jesús tak xekaja pjupraj chic ya' tzra' xekaj wa' chpam jun lwar jc'ola pquecwent je aj Gadarenos. Ec'ol c'a e c-e' wnak, arj-e' e'ocnak itzel tak espíritu ptak canm, xe'el ta pcomsant, xecrec'lu' Jesús. Arj-e' nxibexa ri'il chquewech y nmajo'n jun wnak xtk'ax ta tzra' jabar ec'o wa' j-e'. ");
INSERT INTO tzjE_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chek q'uenjlal tak xquemaj rakic quechi' tzrij Jesús: —Atet at Rlec'wal Dios ¿nak nawajo' chka? ¿Atpenak wawe' ra che nko'arey-a' chpam nimlaj lowlo' tak q'uemjana terla' tiemp rxin? cara' xecc'axaj tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ec'o pon c'a jle' a'k tzra' per ncongan e q'uiy, quemjon w-im. ");
INSERT INTO tzjE_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jitzel tak espíritu congan xquecsaj cchuk'a' y cawra xecbij tzra Jesús: —We nko'alsaj ela per tey-a' c'as chka che nokoca chquepam j-ela a'k, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Jix c'a, cara' xbixa chca rmal Jesús. Cara' xqueban xe'el ela, xe'oca chquepam a'k. Je' a'k chek xe'oca itzel tak espíritu chquepam, arj-e' nalnak xeba, xexle'a chwech jun jyu' per ncongan tectic y q'ue pya' xe'ekaj wa', y tzra' xq'uis wa' quexla' conjelal. ");
INSERT INTO tzjE_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Je chjalbey cxin a'k arj-e' xenanmaj ela y xeba pe tnamet, xequechlo' njelal je xbantaja y nak xqueban ja e c-e' wnak ja e'ocnak itzel tak espíritu pcanm. ");
INSERT INTO tzjE_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Per tnamet xepeta conjelal, xecrec'lu' Jesús y tak xquec'ul cawra xecbij tzra: —Catel ela wawe' ra, tey-a' cana jawra lwar, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","C'jara' Jesús xoc ela chpam lanch, xba chic pjupraj ya', xba chpam retnamet. ");
INSERT INTO tzjE_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tak xekaja c'ola jun acha squirnak xeya'a chwech, ctz'ela chwech warbal ch'at. Ja' Jesús tak xutz'et yukbal quec'u'x jc'ola ruq'uin cawra xbij tzra squirnak: —Wlec'wal, mtaxibej ta awi', camic ncuytaja awil amac, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ec'ol c'a jle' maestro je nquetijona cxin wnak tzrij rley Dios, tak chek xc'axtaja cmal je xbij Jesús cawra xecbij ptak canm: —Je xbij jala acha xitzel nc'axaj Dios, cara' xecbij kaja. ");
INSERT INTO tzjE_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Per Jesús arja' rutkin nak nquech'ob kaja ptak canm y cawra xbij chca: —¿Nak tzra tak xitzel tak achnak nech'ob kaja ptak ewanm? ");
INSERT INTO tzjE_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Camic quenwajo' quenc'axaj chewa ¿nak más majo'n pen ta tzra c-e' jawrara, jquenbij tzra jawra acha che quencuy ril rumac, o wquenbij tzra che nyictaja y nba? ");
INSERT INTO tzjE_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Anen quenwajo' quenban jun achnak chewech camic ch-utz c'ara' newutkij che Rlec'walxel jxoca alxic cuq'uin wnak yatanak tzra chnucuy quil quemac je' wnak wawe' chwech ruch'lew, cara' xbij Jesús chca. —Catyictaja, tec'ma' ela awarbal, jat pnawuchoch, cara' xbij tzra acha sic. ");
INSERT INTO tzjE_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Cara' xuban, xyictaja y xba chruchoch. ");
INSERT INTO tzjE_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Je' wnak congan xel ta quec'u'x tak xquetz'et jxuban Jesús y xquemaj rya'ic ruk'ij Dios rmal. Com Dios arja' pruk'a' jun wnak rey-on wa' jawra nimlaj poder je xquetz'et rmal c'ara' tak xqueya' ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús xba chic, kas remjon binem tak c'ola jun acha xutz'et, Mateo rubi'. Ja' Mateo tz'bula tzra' abar nto'j wa' impuesto pruk'a'. Tak xekaja Jesús ruq'uin cawra xbixa tzra: —Jo' catetre' ta chwij che ncatoca ndiscípulo, cara' xbixa tzra. Ja' Mateo xyictaj ela y xba tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesús arja' c'ola pjay, tz'bula chwech mes tak chek q'uenjlal e q'uiy ja e mloy tak impuesto xe'ekaja ruq'uin e quexbil jle' chic wnak aj-il ajmac nbixa chca. Arj-e' xetz'be'a tzrij mes ruq'uin Jesús e rexbil e rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ec'ol c'a jle' fariseo, arj-e' tak xequetz'et je' wnak jxetz'be'a tzrij mes ruq'uin Jesús cawra xecbij chca rdiscípulo: —¿Nak tzra tak emaestro nwa'a cuq'uin e mloy tak impuesto y nwa'a cuq'uin jle' chic aj-il ajmac chka'? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Per Jesús tak xc'axtaja rmal jxecbij cawra xbij chca: —Nak majo'n e yuw-i' ta majo'n nc'atzin ta doctor chca per e yuw-i' jara' ne nc'atzin wa' doctor chca. ");
INSERT INTO tzjE_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jix, jneban camic ttijoj ewi' tzrij rtzojbal Dios je xtenbij chewa ra: —Kas quenwajo' chewa chneban, tpoknaj quewech je' wnak, jara' más nc'atzina que chwech netzujuj jle' sacrificio chenwech, cara' nbij Dios. Jawra tzij xenbij chewa com anen enpenak che que'encanoj aj-il ajmac ch-utz c'ara' nqueya' cana quil quemac, me j-e' tara' e bnoy rbeyal que'encanoj. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Je rdiscípulo Juan Bautista arj-e' xe'ekaja ruq'uin Jesús y cawra xecc'axaj tzra: —¿Nak tzra je' adiscípulo majo'n nqueban ta ayuno? Per ajoj ne nkaban wa' ayuno, chka' nqueban aj fariseo, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús cawra xbij chca: —Ajni' chca jle' wnak jebnon invitar tzra jun c'ulbic, tak c'c'o na acha chquecjol jnec'le'a ¿tkal c'ara' chquij nqueban ayuno nech'ob ixix? Per nerla' na jun k'ij tak arj-e' xtelsasa chquecjol acha jnec'le'a, c'jara' c'a tak xtqueban ayuno. ");
INSERT INTO tzjE_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Majo'n jun wnak xtuc'am ta jtz'it c'ac' tziak y xtucsaj ta tesbal tzra jun tzbuklaj tziak. Wexte cara' nba'na, je tzbuklaj tziak chkajni' netk'e'a com jc'ac' tesbal xnuc'ol ri'. ");
INSERT INTO tzjE_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Chka' ajni' tzra c'ac'laj vino, majo'n nc'o'l ta chpam tzbuklaj tak c'olbal. Wexte cara' nba'na jc'ac' vino nurak rc'olibal y nti'xa y ntz'iloxa c'olbal chka'. Per je nba'na, jc'ac' vino nya'a chpam c'ac' tak c'olbal y cara' nuto' ri' che c-e', next vino next c'olbal ntz'ilox ta. Cara' xbij Jesús chca tzrij jc'ac' tijonem jrec'mon ta. ");
INSERT INTO tzjE_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús arja' remjon na rbixic tzij chca tak c'ola jun jefe xekaja ruq'uin, xexque'a chwech y cawra xbij tzra: —C'ola jun nmi'al c'ja' xcom kaja per quenwajo' chawa, jo' chwij, ay-a' ak'a' pe rwá' y anen wutkin che nc'astaja rwech nmi'al, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Xyictaja Jesús, xetre' ela tzrij jefe y xerexbilaj ela rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Chek q'uenjlal tak c'ola jun ixak yawa' xekaja ruq'uin, xuban c'a cbeljuj juna' rkajben jun yubil chcongan quic' nela tzra. Jxuban ja' ixak xki'l oca más ruq'uin Jesús. Tak xekaja ruq'uin xuchap oca jtz'it ruchi' retziak. ");
INSERT INTO tzjE_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Cara' xuban com cawra nbij kaja pranm: —We xtenchap retziak Jesús xruq'uin ra quenchumtaja, cara' nbij kaja. ");
INSERT INTO tzjE_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús arja' xuya' volt y tak xutz'et ixak cawra xbij tzra: —Mtaxibej ta awi' nmi'al, jyukbal ac'u'x wq'uin jara' xatchumsana, cara' xbij tzra. Ja' ixak njara' hor xchumtaja. ");
INSERT INTO tzjE_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ja' Jesús tak xekaja pruchoch jefe ec'ola jle' wnak xerutz'et quemjon rbanic xul e quexbil jle' chic wnak congan rkala quechi' tzan ok'ej. ");
INSERT INTO tzjE_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Y cawra xbij chca: —Quixel ela, je xtan majo'n comnak ta, xwarnak, cara' xbij chca. Per j-e' xe xectzebej Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ja' Jesús tak xelestaj ta wnak rmal xoca abar c'o wa' camnak, xuchap chuk'a' y xyictaja xtan. ");
INSERT INTO tzjE_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jawra je xbantaja xela rbixic nat nkaj chpam jara' lwar. ");
INSERT INTO tzjE_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ja' Jesús xba chic. Ec'ol c'a e c-e' moya' etren tzrij, arj-e' xquemaj rakic quechi' tzrij Jesús: —Atet at Rlec'wal ja ojer rey David, tpoknaj jtz'it kawech, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ja' Jesús arja' xoca pjay y xe'ekaja moya' ruq'uin y cawra xc'axaj chca. —¿Lnenimaj che anen quencwina quixnchumsaj? cara' xc'axaj chca. —Neknimaj Kajaw, kutkin che ncatecwina nokachumsaj, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ja' Jesús xuchap ck'awech y cawra xbij chca: —Ajni' yukbal ec'u'x wq'uin cara' c'ara' nbantaja. ");
INSERT INTO tzjE_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Y xjaktaja ck'awech. Jesús cawra xbij chic chca: —Per kas quenwajo' quenbij chewa, majo'n abar tzra' nebij wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Per arj-e' xe'el ela, xquemaj rtzojxic njelal nat nkaj chpam jara' lwar je xba'na chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kas nque'el ela Jesús tak chek q'uenjlal c'ola jun acha mem xeya'a chwech, c'ola jun itzel espíritu ocnak pranm. ");
INSERT INTO tzjE_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ja' Jesús xelsaj ela itzel espíritu pranm acha, njara' hor xumaj tzij. Je wnak congan xel ta canm tzrij je xquetz'et y cawra xecbij ra: —Nexte wjic bantanak cawrara chpam ketnamet Israel. ");
INSERT INTO tzjE_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Per aj fariseo arj-e' cawra necbij ra: —Xe rpoder cjefe je' itzel tak espíritu nucsaj che clasic itzel tak espíritu. ");
INSERT INTO tzjE_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús arja' xba chpam njelal tnamet y njelal tak aldea, nquertijoj je' wnak ptak jay rxin molbal ri'il, nuya' rbixic chca utzlaj tzij tzrij gobierno je rxin chcaj, chka' ec'ola yuw-i' nquerchumsaj chka bechnak opech nti'ona chca. ");
INSERT INTO tzjE_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tak xerutz'et chcongan e q'uiy wnak arja' xpoknaj quewech com arj-e' congan lowlo' quebnon, e ajni' jle' carne'l cpaxlon je' qui', majo'n nak nyuk'una cxin. ");
INSERT INTO tzjE_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","C'jara' cawra xbij chca rdiscípulo: —Ne ktzij wa' quenbij chewa, je' wnak e ajni' jun nimlaj tejco'n k'an chic, utz chic nch'u'pa, per ajsmajma' je nquech'puwa rxin xme q'uiy ta. ");
INSERT INTO tzjE_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Rmal c'ara' quenbij chewa, tebna' orar, tc'utuj tzra Rjawal tejco'n che nquerutak ta ajsmajma' che necrech'pu' rwech tejco'n jara' je' wnak, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ja' Jesús xersiq'uij ja e cbeljuj discípulo y xuya' chca chc'ola quek'a' chquij itzel tak espíritu che nquecwina nquequelsaj ela ptak canm wnak, y xuya' chca chka' che nquecwina nquecchumsaj yuw-i' chka bechnak opech nti'ona chca. ");
INSERT INTO tzjE_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jquebi' ja e cbeljuj apóstol jara' jawrara: nabey mul, Simón jc'o chic jun rubi' Pedro, Andrés je rch'alal Simón, Jacobo rlec'wal Zebedeo, Juan rch'alal Jacobo, ");
INSERT INTO tzjE_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo je mloy impuesto, Jacobo je rlec'wal Alfeo, Lebeo jc'o chic jun rubi' Tadeo, ");
INSERT INTO tzjE_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, jun chca e rxin partido rbin-an cananita, y Judas Iscariote jxejchowa Jesús pquek'a' wnak je nquetzelana rxin. ");
INSERT INTO tzjE_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ja' Jesús xerutak ela e cbeljuj discípulo y xuch'ob ela chquewech nak xtequebna': —Mtec'om el ta bey je nba cuq'uin wnak jme aj Israel ta, chka' nmajo'n jun tnamet rxin Samaria xtquixoc ta chpam. ");
INSERT INTO tzjE_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Je nquixba wa', jara' cuq'uin aj Israel je ajni' jle' carne'l etzaknak. ");
INSERT INTO tzjE_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Chpam viaje je xteban jawra neya' rbixic chca wnak ra: —Jgobierno rxin chcaj ne nkajin ta, cara' tbij. ");
INSERT INTO tzjE_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Que'echumsaj yuw-i', que'echumsaj je' leproso, que'eyca' cnomki' chpam cmic y que'elsaj itzel tak espíritu ptak canm wnak. Com jpoder jxenya' chewa xecochij chwa rmal c'ara' quenbij chewa majo'n nec'utuj ta pak chca wnak tak necsaj poder che cto'ic. ");
INSERT INTO tzjE_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Majo'n pak nec'om ela tak xtquixba. ");
INSERT INTO tzjE_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nexte nec'om ela emlet, xruyon jara' ecmis nec'om ela ja ecsan, majo'n xtewc'aj ta c-e'. Majo'n newc'aj ta c-e' c'laj xjab nexte ch'me'y xtewc'aj ta c-e'. Cara' quenbij chewa com jun ajsmajma' yatanak tzra che nya'a tzra jnak ntzukbej ri'. ");
INSERT INTO tzjE_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Chka bechnak opech tnamet nquixoc wa', chka bechnak aldea, tzra' necanoj wa' jun wnak jyatanak tzrij che nquixec'je'a ruq'uin y tzra' nquixec'je' wa', c'jara' nquixel ela ruq'uin tak nquixba chpam jun chic tnamet. ");
INSERT INTO tzjE_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tak nquixoca chpam jun jay cawra nebij: —Qui'il tec'je'a rwech ewanm chwech Dios pnewuchoch, cara' tbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Je' wnak wyatanak chquij che nquixec'je'a cuq'uin qui'il tc'a xtec'je'a rwech canm chwech Dios jec'mon ela chca. Wmajo'n yatanak ta chquij che nquixec'je'a cuq'uin mtec'je' tc'ara' qui'il rwech canm chwech Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Y nak majo'n xtquixquec'ul ta, nak jmajo'n cgan necc'axaj jnebij chca, tak nquixel ta pjay cuq'uin o we nquixel ta pe tnamet, tquiraj cana pkok jc'ola pnewkan. ");
INSERT INTO tzjE_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ne ktzij wa' jquenbij chewa ra, tak xterla' jnimlaj k'ij rxin juicio congan lowlo' neretja' tnamet jmajo'n xixquec'ul ta, más lowlo' nequetja' chwech je xtquetaj wnak je aj Sodoma y Gomorra ojer. ");
INSERT INTO tzjE_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Camic tec'ma' ela ebey, bien twutkij ela che ixix ix ajni' jle' ch'tak carne'l y je' wnak abar quixnutak el wa' arj-e' e ajni' utiwa'. Quixec'je'a list ajni' nuban jun cmetz tak nuto' ri' xerwara' chka' tebna' sencillo ajni' jun tz'quin jpaloma. ");
INSERT INTO tzjE_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tebna' cwent ewi' chquewech wnak com arj-e' nquixquec'om el na ptak k'atbaltzij y nquixquech'ay na chka' ptak jay rxin molbal ri'il cxin j-e'. ");
INSERT INTO tzjE_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nquixquec'om ela chquewech gobernador, nquixquec'om ela chquewech rey, per nmal anen tak cara' xtba'na chewa. Cara' xtba'na chewa ch-utz c'ara' nela ntzojxic chquewech j-e' ruq'uin chquewech wnak jme aj Israel ta. ");
INSERT INTO tzjE_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Per tak nquixec'mar ela chquewech mtquixbison ta tzrij nak nebij che netobej ewi' chquewech com jara' hor nyataja chewa nak nebij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Cara' quenbij chewa com me ixix ta nquixtzijona tzra', Espíritu Santo nyowa chewa nak xtebij chca, jara' Espíritu rxin Dios je Ttixel ewxin. ");
INSERT INTO tzjE_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Je' e alxic nquequejach quechak' ruq'uin quenmal pe cmic, y cara' xtqueban je' ttixel chka', nquequejach clec'wal, y chka' je' alc'walxela' arj-e' nqueyictaj na chquij ttixela' y nquequejach pe cmic. ");
INSERT INTO tzjE_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Y ixix xitzel nquixtz'e'ta cmal conjelal wnak per nmal anen tak xtba'na cara' chewa. Per conjelal je xtquecoch' quewech chpam jlowlo' y majo'n xtqueya' cta yukbal quec'u'x wq'uin arj-e' nquewil na totanem rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tak nba'na lowlo' chewa chpam jun tnamet quixnanmaja, jix chic chpam jun tnamet. Cara' quenbij chewa com ne ktzij wa' je xtenbij chewa ra, tak q'uemjana tquixk'axa chpam njelal tnamet jc'ola precwent Israel, je Rlec'walxel jxoca alxic cuq'uin wnak nemloj pchic jmul. ");
INSERT INTO tzjE_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Majo'n jun discípulo nim ta ruk'ij chwech rmaestro, chka' majo'n jun ajsmajma' nim ta ruk'ij chwech rpatrón. ");
INSERT INTO tzjE_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mejor jnuban discípulo, tec'je'a conform che nba'na cara' tzra ajni' nba'na tzra rmaestro, y ja ajsmajma' chka' tec'je'a conform che nba'na cara' tzra ajni' nba'na tzra rpatrón. Anen en Epatrón, y com xbixa chwa che anen en cjefe je' demonio peor c'ara' chewa ixix, congan nquixctzelaj na chka' je ix ajsmajma' wxin. ");
INSERT INTO tzjE_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Rmal c'ara' quenbij chewa, mtexibej ta ewi' chquewech. Cara' quenbij chewa com njelal jmajo'n k'aljennak ta jara' nerla' na jun k'ij tak xtek'aljina, y njelal jwewtanak je'a nel na psak y notkix na. ");
INSERT INTO tzjE_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Njelal jquenbij chewa je xkayon, ixix telsaj rbixic psak, tey-a' rbixic chquewech wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mtexibej ta ewi' chquewech wnak je xruyon oca ecuerpo nquecwina neccamsaj per ewanm jara' mesquier nquecwina neccamsaj. Per txibej ewi' chwech jara' jnecwina nuya' ewanm rexbil ecuerpo chpam nimlaj k'ak'. ");
INSERT INTO tzjE_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Je' tz'quin tak nquec'ayixa xjun centavo nya'a chquewech e c-e'. Per mesque xe brat per next jun chca chek tcara' ncoma we mcara' ta nrajo' ranm Dios che ncoma, jara' Dios je Edta'. ");
INSERT INTO tzjE_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Y jchewa ixix majo'n nquixrmestaj ta Dios, jresmal ewá' rejlan che jujnel. ");
INSERT INTO tzjE_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Rmal c'ara' quenbij chewa, mtexibej ta ewi', ixix más ix val que chquewech e jun nimlaj moc tz'quin. ");
INSERT INTO tzjE_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Je' wnak chka bechnak wnak opech wmajo'n necpoknaj ta necbij che wq'uin anen ykul wa' quec'u'x per ne chquewech wnak necbij wa', anen chka' quenbij na chca che ec'ola pnecwent per ne chwech Nedta' quenbij wa' jc'ola chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Per je' wnak chka bechnak wnak opech we necpoknaj necbij chquewech wnak che wq'uin anen ykul wa' quec'u'x, anen chka' quenbij na chca che e majo'n pnecwent per ne chwech Nedta' quenbij wa' jc'ola chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mtech'ob ta chwij che anen enpenak che qui'il nquec'je'a je' wnak wawe' chwech ruch'lew. Mcara' ta, me rmal ta ra' enpenak. Me rmal ta che qui'il nquec'je'a wnak chbil tak qui' tak enpenak per enpenak rmal che nqueban ch'oj nmal. ");
INSERT INTO tzjE_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Je' ach-i' nquech'ojin na cuq'uin quedta', y je' ixki' nquech'ojin na cuq'uin quete', y je' elbetz nquech'ojin na cuq'uin clite'. ");
INSERT INTO tzjE_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Cara' nbantaj na, jrec'lel jun wnak ne pruchoch wa' arja' nyictaj wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Je' wnak jmás na nquecajo' e quedta' o quete' que chenwech anen, arj-e' majo'n yatanak ta chca xque'oc ta ndiscípulo. Je wnak jc'ola jun clec'wal jmás na ncajo' que chenwech anen, arj-e' majo'n yatanak ta chquij che nque'oca ndiscípulo chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Je' wnak jnecpoknaj qui' nquetre' ela chwij y necpoknaj nquetaj pen ajni' pen nutaj jun acha jremjon rejkxic jun cruz, arj-e' majo'n yatanak ta chquij che nque'oca ndiscípulo chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Je' wnak jnecpoknaj nqueya' cana cc'aslemal jara' nectz'ila' utzlaj c'aslemal je rxin junlic. Per je' wnak jmajo'n necpoknaj ta nqueya' cana cc'aslemal nmal anen jara' nquewil utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Je' wnak je nquec'luwa ewxin, anen c'ara' quenquec'ul, y je' wnak je nquec'luwa wxin, Nedta' c'ara' jtakyon pa wxin nquec'ul. ");
INSERT INTO tzjE_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Je' wnak jc'ola jun profeta rxin Dios nekaja cuq'uin, we nquec'ul xe rmal che arja' profeta rxin Dios jara' nyataj na chca jun rtojic je ajni' nyataja chca profeta. Chka' je' wnak tak nquec'ul jun wnak je bnoy rbeyal rxin Dios y we nquec'ul xe rmal bnoy rbeyal jara' nyataj na chca jun rtojic ajni' nyataja chca je bnoy rbeyal rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wc'ola jun wnak chka bechnak wnak opech nekaja jun chca j-ewra ndiscípulo ruq'uin y nsipaj jun vas ya' tzra y xe rmal che ndiscípulo tak nsipaj, jara' ne ktzij wa' quenbij chewa, arja' nmajo'n ra mquita xtyataja rtojic tzra, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tak xuq'uis rbixic chca e cbeljuj rdiscípulo nak xtequebna' xel ela chpam lwar y xba che nquertijoj wnak y nerey-a' rbixic chca rtzojbal Dios ptak quetnamet. ");
INSERT INTO tzjE_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan Bautista arja' c'ola pcars y xekaja rbixic ruq'uin njelal samaj jremjon rbanic Cristo. Jxuban, ec'ola e c-e' chca rdiscípulo xerutak ela ruq'uin Jesús ");
INSERT INTO tzjE_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","y cawra xbij ela chca che necc'axaj tzra: —¿La atet at Cristo jbitanak cana che ncatpet na owe nkeybej chna jun? cara' xbij ela chca. ");
INSERT INTO tzjE_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","J-e' discípulo tak xbitaja cmal jbin ela chca rmal Juan cawra xbixa chca rmal Jesús: —Jix, ebij tzra Juan njelal je nquixtajina newc'axaj y njelal je nquixtajina netz'et tzrij jsamaj jnemjon rij. ");
INSERT INTO tzjE_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Je' moya' nqueca'y chic. Jch'e'y nquebina jara' jic chic nquebina. Je' leproso xechumtaja. Ja e tcon necc'axaj chic tzij. Je' cnomki' xec'astaja. Je' mibi' majtanak rbixic chca utzlaj tzij rxin totanem jretkon ta Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tbij tzra Juan chka' chcongan qui' quec'u'x wnak jmajo'n jun twa' nquena' rmal jsamaj jnemjon rbanic. Cara' tbij tzra, cara' xbij ela chca rdiscípulo Juan Bautista. ");
INSERT INTO tzjE_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kas xe'el ela e c-e' discípulo, Jesús xumaj tzij cuq'uin wnak tzrij Juan Bautista: —Juan tak xec'je'a ptak tenlak lwar ¿nak tzra tak xixba ruq'uin che rtz'etic, le rmal Juan chek remril ajni' jun aj njech'loxa rmal xecmel? ");
INSERT INTO tzjE_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Nak tzra tak xixba ruq'uin che rtz'etic, le rmal Juan chcongan rewkon ri' tzra wen tak tziak je nmak rjel? Per ixix ewutkin je' wnak je nquecsana wen tak tziak je nmak rejlal jara' chpam nmak tak jay cxin rey nquec'je' wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Nak tzra tak xixba ruq'uin che rtz'etic, le rmal Juan che arja' jun profeta rxin Dios? Jara' ne ktzij wa' che profeta per mruyon ta profeta ocnak wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Cara' quenbij chewa com Juan arja' xchumsana rubey Cristo ajni' tz'ibtanak cana chpam rtzojbal Dios jcawrara nbij: —Anen quentak ela nmensajero che nnabyeja chawech ch-utz c'ara' ja' nchumsana abey. Cara' bitanak cana rmal Dios tzrij Cristo. ");
INSERT INTO tzjE_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ne ktzitzij wa' je xtenbij chewa, next jun profeta c'jenak ta wawe' chwech ruch'lew jnim ta ruk'ij chwech Juan Bautista per chpam gobierno je rxin chcaj jun wnak mesque sencillo per más chna nim ruk'ij chwech Juan. ");
INSERT INTO tzjE_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jgobierno rxin chcaj congan wnak tzrij y je' wnak congan nquecsaj cchuk'a' tzrij ch-utz c'ara' nque'oca chpam. Jawrara majtanak ta rij tak xumaj ta rsamaj Juan Bautista y nnajina camic. ");
INSERT INTO tzjE_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jgobierno rxin chcaj bitanak ta cmal ja e ojer tak profeta che npe na y ncara' bitanak ta chka' chpam rley Dios jtz'ibtanak cana rmal Moisés, per tak xpeta Juan tzra' c'a xbantaj wa' cumplir jbitanak ta. ");
INSERT INTO tzjE_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Wc'ola egan newc'axaj tewc'axaj c'a je xtenbij chewa ra, Juan ja' c'ara' Elías jbitanak cana che npe na. ");
INSERT INTO tzjE_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Achnak c'ola rexquin tc'axaj c'a jquenbij. ");
INSERT INTO tzjE_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Nak quenjumsaj wa' je' wnak je rxin tnamet Israel? Cuq'uin e c-e' moc ac'ala' quenjumsaj wa' jquemjon tz'anem pq'uebal. Jun moc nquerak quechi' chquij jun moc chic: ");
INSERT INTO tzjE_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","—Ajoj xkaban k'jom rxin quicotemal per ixix majo'n xixexjow ta, majo'n xixquicot ta. Xkaban chic rxin bis y next c'a xixbisona chka', nmajo'n nak newajo', cara' necbij ac'ala' chca jmoc chic. ");
INSERT INTO tzjE_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Je' wnak quenjumsaj cuq'uin ac'ala' je nmajo'n nak ncajo', com Juan Bautista tak arja' xpeta majo'n xwa' ta cuq'uin wnak y majo'n vino xutaj ta, rmal c'ara' xbixa tzra cmal wnak chc'ola jun itzel espíritu pranm. ");
INSERT INTO tzjE_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Xenpet chic anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak, xenwa'a cuq'uin wnak y xentaj vino, rmal c'ara' xbixa chwa cmal wnak che en ajmund, xen tjoy vino, xe e wexbil e mloy tak impuesto e quexbil aj-il ajmac. Per e rlec'wal Dios arj-e' bien ch'obtanak cmal che Juan Bautista rna'oj Dios rucsan y bien cutkin che anen chka' rna'oj Dios necsan. Cara' xbij chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ja' Jesús xumaj cnatxic wnak jec'ola ptak tnamet jabar rebnon wa' nmak tak milagro. Arja' xbij jle' cowlaj tak tzij chca perc majo'n quec'xon ta cna'oj y majo'n quey-on cta rtzilal. Cawra xbij chca: ");
INSERT INTO tzjE_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Congan lowlo' chewa ixix ja ix aj Corazín y congan lowlo' chewa ixix chka' ja ix aj Betsaida. Cara' quenbij chewa com congan nmak tak milagro xenban chewech per nmajo'n xeq'uex ta ena'oj. Je nmak tak milagro jxenban chewech wexte xba'na chquewech jitzel tak wnak aj Tiro ruq'uin aj Sidón ojer arj-e' xqueq'uex ta cna'oj y xqueya' cta njelal itzel tak achnak, xqueban ta je' achnak che necc'utbej che nti'ona canm rmal rtzilal jquebnon chpam cc'aslemal. ");
INSERT INTO tzjE_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Per anen quenbij chewa, tak xterla' jnimlaj k'ij rxin juicio más na nim lowlo' xtetaj ixix que chwech je xtquetaj aj Tiro ruq'uin aj Sidón. ");
INSERT INTO tzjE_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ixix chka' ja ix aj Capernaum, jnech'ob ixix che nquixba chcaj xe rmal chcongan nya'a ek'ij, per jneban jara' xe nquixkaja, abar ec'o wa' cnomki' q'ue tzra' nquixekaj wa'. Cara' quenbij chewa com congan nmak tak milagro xenban chewech per nmajo'n xeq'uex ta ena'oj. Je nmak tak milagro jxenban chewech wexte xba'na chquewech jitzel tak wnak je aj Sodoma ojer c'o ta quetnamet camic ra, mquita xc'atsasa. ");
INSERT INTO tzjE_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Per anen quenbij chewa, tak xterla' jnimlaj k'ij rxin juicio más na nim lowlo' xtetaj ixix que chwech je xtquetaj aj Sodoma. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","C'jara' ja' Jesús xtzijona ruq'uin Ttixel jc'ola chcaj, cawra xbij tzra: —Nedta', atet at Rajaw caj ruq'uin ruch'lew, quenmeltioxij chawa com je' wnak je nquech'ob kaja ptak canm chcongan cutkin y congan cna'oj me chquewech ta arj-e' ak'alsan wa' nak rbanic njelal jawra jnemjon rbanic y njelal jnemjon rbixic, per ja ak'alsan wa' jara' chquewech wnak jquebnon e ch'tak no'y chawech. ");
INSERT INTO tzjE_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Cara' abnon chca Nedta', com cara' nawajo' atet. ");
INSERT INTO tzjE_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Cawra xbij chic chca wnak: —Nmajo'n achnak mquita jchon pnuk'a' rmal Nedta'. Nmajo'n nak ojtakyona kas mer rna'oj Rlec'walxel, per ja ojtakyona jara' xruyon Dios Ttixel. Chka' nmajo'n nak ojtakyona kas mer rna'oj Ttixel per ja ojtakyona xnuyon anen ja en Rlec'walxel ruq'uin ja enech-on chquenk'alsaj chquewech. ");
INSERT INTO tzjE_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Quixjo' wq'uin ixconjelal jcongan ecsan echuk'a' che rconxic nak neban che nexle'na ewanm chuxe' je' rejlal achnak je nti'ona chewa. Quixjo' c'a y anen quenya' chewa che nexle'na ewanm. ");
INSERT INTO tzjE_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xjun tebna' wq'uin che quixnewc'aj y ttijoj ewi' tzrij jquenc'ut chewech com anen pruk'a' Dios quenjach wa' njelal y co'l quenban. We xjun neban wq'uin jara' nexle'na rwech ewanm rmal. ");
INSERT INTO tzjE_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Cara' quenbij chewa com jquenya' anen chekul majo'n cosem rec'mon ta chewa y jwejka'n jquenya' chewij majo'n a'l ta rc'axic. Cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ja' Jesús erexbil rdiscípulo, chpam jun xlanbal k'ij quemjon binem chpam jle' trigo. J-e' rdiscípulo xemajtaja rmal k'ak'nic quepam rmal c'ara' tak xquemaj rk'upxic rwá' je' trigo y nquetaj. ");
INSERT INTO tzjE_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","J-e' c'a aj fariseo tak xquetz'et cawra xecbij tzra Jesús: —Que'atz'ta' mpa' adiscípulo, jala' jquemjon rbanic xjan nba'na ptak xlanbal k'ij, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Cawra xbixa chca rmal Jesús: —¿Lmesiq'uin tc'a chpam rtzojbal Dios jxuban ojer rey David tak xuban jmul tak majtanak rmal k'ak'nic pamaj y e rexbil cara' quebnon chka'? ");
INSERT INTO tzjE_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jxuban, xoca chpam ruchoch Dios y xutaj xquelway jyonan chic chwech Dios. Cara' xuban mesque jara' xquelway tz'ibtanak cana chpam rtzojbal Dios che xqueyon sacerdote nquetjowa. ");
INSERT INTO tzjE_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Chka' ¿lmesiq'uin tc'a je nbij ley chca sacerdote tzrij jsamaj je nqueban chpam nimlaj templo rxin Dios che arj-e' nc'atzina nquesmaja ptak xlanbal k'ij, majo'n nquexle'n ta? Per xlanbal k'ij c'a y nquesmaja per majo'n xjan ta. ");
INSERT INTO tzjE_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Anen quenbij chewa che anen más chna nim nuk'ij chwech jnimlaj templo rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","C'ola jun tzij rbin cana Dios cawrara: —Kas quenwajo' chewa chneban, tpoknaj quewech wnak, jara' más nc'atzina que chwech netzujuj jle' sacrificio chenwech anen, cara' nbij. Wexte ch'obtanak ewmal je nbij tzij jara' mquita xebij che xjan nqueban ndiscípulo tak majo'n xjan ta. ");
INSERT INTO tzjE_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Cara' quenbij chewa com Rlec'walxel jxoca alxic cuq'uin wnak, pruk'a' c'o wa' je nba'na chpam xlanbal k'ij. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","C'jara' xel ela Jesús y xba, xoca chpam jay rxin molbal ri'il cxin aj fariseo. ");
INSERT INTO tzjE_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","C'ol c'a jun acha squirnak jun ruk'a'. J-e' c'a aj fariseo quemjon rconxic rij rwech Jesús nak necchapbej rxin rmal c'ara' cawra xecbij tzra: —¿Lnuya' c'as ley chawa che nque'achumsaj je' yuw-i' ptak xlanbal k'ij? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Cawra xbixa chca rmal Jesús: —¿Lc'o c'a jun chewa c'o ta jun rcarne'l ntzak ela pjul pjun xlanbal k'ij y majo'n nelsaj ta chpam jul? ");
INSERT INTO tzjE_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Per jun wnak más chna nim ruk'ij que chwech jun carne'l rmal c'ara' quenbij chewa, jley nuya' c'as chka che nkaban utzil ptak xlanbal k'ij, cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","C'jara' cawra xbij tzra yawa': —Teyku' ak'a'. Xuyuk ruk'a' y xchumtaja, junam chic xuban che c-e'. ");
INSERT INTO tzjE_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","J-e' c'a aj fariseo xeba, xequemlo' qui' y xquemaj rch'obic nak nqueban tzra Jesús che neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ja' Jesús rutkin chic che ncajo' neccamsaj, xel ela chpam jara' lwar y xba. E q'uiy wnak xetre' ela tzrij. Y ja' Jesús xerchumsaj conjelal yuw-i', ");
INSERT INTO tzjE_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","y congan xbij chca chmajo'n abar nquelsaj wa' rtzojxic. ");
INSERT INTO tzjE_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jawra xuban ch-utz c'ara' tzra' nbantaj wa' cumplir jbitanak cana ojer rmal Dios tak profeta Isaías cawra xbij: ");
INSERT INTO tzjE_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","—Tetz'ta' mpa' ajsmajma' wxin jnech-on, arja' congan quenwajo', ajni'la nquicota wanm tzrij. Anen quenya' wEspíritu tzra y arja' xtuc'ut bey rxin Dios chquewech wnak jme aj Israel ta. ");
INSERT INTO tzjE_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tak ntzijona cuq'uin wnak majo'n xtucsaj ta je' tzij ja xch'oj rec'mon ta next c'a xturak ta ruchi', majo'n nc'axax ta rukul c'nat. ");
INSERT INTO tzjE_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Je' wnak jcongan lowlo' quebnon y congan yojtanak chic rwech canm, arja' majo'n nqueruyoj ta más, nqueruyic y nqueruto'. Ncawara' xtuban y rmal ja' tak xtoca rubey Dios, per njunlic noca y nja' nch'ecmaja. ");
INSERT INTO tzjE_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Arja' nekaj na rbixic cuq'uin wnak jme aj Israel ta y j-e' qui'il nec'je'a canm che reybxic, cara' nbij ja' Dios chca. ");
INSERT INTO tzjE_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chwech ja' Jesús xec'mar ela jun acha moy y mem chka', y c'ola jun itzel espíritu ocnak pranm. Xchumsaj acha, nca'y chic y necwin chic ntzijona. ");
INSERT INTO tzjE_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Je' wnak xel ta canm tzrij per ne conjelal y cawra necbij ra: —¿Lja' c'a wa' je Cristo je Rlec'wal ja ojer rey David? Cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","J-e' aj fariseo xecc'axaj jxecbij wnak y cawra xecbij: —Jala acha tak nquerelsaj itzel tak espíritu pcanm wnak xe rpoder Beelzebú nucsaj je cjefe je' itzel tak espíritu, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Per Jesús arja' bien rutkin jquemjon rch'obic aj fariseo y cawra xbij chca: —Jun gobierno chka bechnak gobierno opech, wex división nuban jara' xe nyojtaja. Cara' c'a tzra jun tnamet chka' y cara' chca wnak jec'ola ptak jay, wex división nuban jara' xe nqueq'uisa. ");
INSERT INTO tzjE_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Cara' c'a tzra Satanás chka', wxe nquerelsaj ela rdemonio jara' xnuch'or kaja ri' ruyon. Wcara' nuban ¿lme tq'uis c'ara' rgobierno? ");
INSERT INTO tzjE_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ixix nebij chwa che rpoder Beelzebú necsan tak quenelsaj je' itzel tak espíritu, per ediscípulo ixix chka' nquequelsaj wan itzel tak espíritu ¿le rpoder Beelzebú quecsan nech'ob ixix? J-e' c'a ediscípulo xquek'alsana che me ktzij ta jxebij chwa. ");
INSERT INTO tzjE_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Anen rEspíritu Dios quencsaj tak quenelsaj je' itzel tak espíritu y wcara' quenban nbij tzij c'ara' je rgobierno Dios kanak pchic checjol. ");
INSERT INTO tzjE_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tak ncatekaja ruq'uin jun acha congan rchuk'a' y nach'ob chnalsaj je' rachnak jc'ola pruchoch, nc'atzina chnabac' nabey mul acha. Wcara' naban jara' ncatecwina nalsaj njelal rachnak jc'ola pruchoch. Cara' xenban anen tzra Satanás chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Je' wnak jmajo'n neyke' ta quec'u'x wq'uin jara' xquenctzelaj, y chka' jmajo'n nquesmaj ta pnecwent che cmolic wnak che quenuto' jara' xjic nquecchicaj ela wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Rmal c'ara' tak anen quenbij chewa, je' wnak mesque nqueban njelal rwech il mac y chka' mesque necbij je' tzij tzra Dios ja xitzel nc'axaj jara' ncuytaja. Per wnecbij je' tzij tzra rEspíritu Dios jxitzel nc'axaj jara' majo'n ncuytaj ta. ");
INSERT INTO tzjE_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wc'ola jun wnak chka bechnak wnak opech, mesque arja' nbij jle' lowlo' tak tzij tzra Rlec'walxel jxoca alxic cuq'uin wnak, jara' ncuytaja per we nbij jle' lowlo' tak tzij tzra Espíritu Santo jara' majo'n ncuytaj ta nexte chpam jawra tiemp rxin rwech ruch'lew nexte chpam tiemp jpenak. ");
INSERT INTO tzjE_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Wnebij tzra jun che' che itzel che' ¿nak tzra mtebij c'ara' chka' che itzel rwech nuya'? Wnebij tzra jun che' che utzlaj che' tbij c'a chka' che utzlaj rwech nuya'. Cara' quenbij chewa com jun moc che' rmal rwech jnuya' tak notkixa nak ch-che'al. ");
INSERT INTO tzjE_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ixix congan itzel tak na'oj ewc'an, ix ajni' jle' itzel tak cmetz. Congan pen xtel pta jle' utzlaj tak tzij pnechi' com xe ix itzel tak wnak. Cara' quenbij chewa com jnojnak ptak ewanm jara' nel ta pnechi'. ");
INSERT INTO tzjE_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jun utzlaj acha utzlaj tak achnak rec'lon pranm y tak ntzijona utzlaj tak achnak rec'mon ta je nbij. Jun itzel acha xitzel tak achnak rec'lon pranm y tak ntzijona xitzel tak achnak rec'mon ta je nbij. ");
INSERT INTO tzjE_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Anen quenbij chewa, tak xterla' jnimlaj k'ij rxin juicio njelal jnecbij wnak jchek ruq'uin cgan necbij, jara' nequejcha' na cwent chwech Dios rmal. ");
INSERT INTO tzjE_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Cara' quenbij chewa com jtzij jxebij wawe' chwech ruch'lew jara' tzij noc na chewij chka' che nk'atbexa tzij chewij jnak xtba'na chewa rmal Dios, we nbij chewa che ewc'an rbeyal rxin Dios o we nquixrutak ela chpam nimlaj lowlo'. Cara' xbij ja' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ec'ol c'a jle' maestro je nquetijona cxin wnak tzrij rley Dios jtz'ibtanak cana rmal Moisés e quexbil jle' fariseo, arj-e' cawra xecbij tzra Jesús: —Maestro, je nkajo' ajoj chawa camic, tebna' jun milagro chkawech ch-utz c'ara' ncateknimaj, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Per Jesús cawra xbij chca: —Je' wnak je nquec'utuna chwa chquenban jun milagro ch-utz c'ara' quencnimaj, arj-e' xjunwa' ykul wa' quec'u'x y mruq'uin ta Dios. Per jmilagro jnecc'utuj jara' majo'n quenban ta chquewech xerwara' c'ola jun milagro nbantaj na chquewech, jun milagro ajni' xuban ojer profeta Jonás. ");
INSERT INTO tzjE_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Com ajni' xuban Jonás ojer oxi' k'ij oxi' ak'a' xec'je'a chpam nimlaj ch'u', y cara' c'a chwa anen chka' ja en Rlec'walxel jxenoca alxic cuq'uin wnak, oxi' k'ij oxi' ak'a' quenc'je' na chuxe' ruc'u'x ruch'lew chpam lwar abar nquec'je' wa' cnomki'. ");
INSERT INTO tzjE_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tak xterla' jnimlaj k'ij rxin juicio je' ach-i' jec'ola chpam tnamet Nínive ojer arj-e' nqueyictaja ix quexbil ixix ja ix tnamet Israel y j-e' nque'oca e k'toy tak tzij chewij. Cara' quenbij chewa com aj Nínive arj-e' tak xecc'axaj rtzojbal Dios je xbixa chca rmal Jonás ojer xq'uextaja cna'oj y xqueya' cana rtzilal. Y camic quenbij chewa, anen más chna nim nuk'ij que chwech Jonás. ");
INSERT INTO tzjE_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tak xterla' jnimlaj k'ij rxin juicio ja ixak jreina rxin nación jc'ola psur nyictaja ix rexbil ja ix tnamet Israel y arja' noca k'toy tzij chewij. Cara' quenbij chewa com jara' ixak q'ue c'nat penak wa' che rc'axic rna'oj Dios jyatanak tzra ja ojer rey Salomón. Y camic quenbij chewa, anen más chna nim nuk'ij que chwech Salomón. ");
INSERT INTO tzjE_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jun itzel espíritu tak nel pa pranm jun acha arja' nba ptak lwar jabar majo'n wa' ya', nercanoj jun lwar abar nexle'n wa' per mtuwil lwar, ");
INSERT INTO tzjE_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","y cawra nbij ra: —Quenmloj chna jmul chpam wuchoch jabar enelnak twa' nabey. Tak nekaj chic jmul ruq'uin acha nutz'et ranm najni' jun jay congan tlana, mson rpam y kas wkon. ");
INSERT INTO tzjE_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","C'jara' nemloj pchic jmul, nquerec'ma' pchic e wku' e itzel tak espíritu jmás chna e itzel chwech arja'. Tak nquerkaja ruq'uin acha nque'oca pranm che e waxki' y tzra' nquec'je' wa'. Rmal c'ara' tak más chna lowlo' rc'aslemal acha nela chwech nabey. Y cara' c'a xtba'na chewa ixix chka' ja ix tnamet Israel jcongan itzel tak achnak ebnon. ");
INSERT INTO tzjE_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ja' Jesús remjon na tzij cuq'uin wnak, jrute' ruq'uin je rch'alal ec'ola chujay y ncajo' nquetzijona ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Y xbixa tzra Jesús: —Tetz'ta' mpa' ate' ruq'uin awch'alal ec'ola chujay y ncajo' nquetzijona awq'uin, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ja' Jesús cawra xbij: —Camic quench'ob chawech e achnak nute' y e achnak wch'alal. ");
INSERT INTO tzjE_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","C'jara' xeruc'ut rdiscípulo y cawra xbij: —J-e' c'a wa' e'ocnak nute' y e'ocnak wch'alal. ");
INSERT INTO tzjE_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Cara' quenbij chawa com achnak nebnowa je nrajo' ranm Nedta' jc'ola chcaj ja' c'ara' ocnak nuchak', o wana' o wnute', cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chpam jara' k'ij xel ela Jesús pjay, xba chiya' y tzra' xetz'be' wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Congan e q'uiy wnak xequemlo' qui' ruq'uin rmal c'ara' tak arja' xoca chpam jun lanch y xetz'be'a chpam. Je' wnak xepe' cana chiya' conjelal. ");
INSERT INTO tzjE_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Y xumaj tzij cuq'uin, q'uiy rwech xbij chca chpam c'ambal tak tzij y cawra xbij ra: —C'ola jun tcoy tejco'n xba pe rchinoj chneretca' rtejco'n. ");
INSERT INTO tzjE_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tak xekaja xumaj rch'akxic ija'tz, c'ola nic'aj pbey xkaj wa', xepeta tz'quin, xquetaj ela. ");
INSERT INTO tzjE_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","C'o chic jle' xkaja abar c'o wa' abaj, congan xax ulew tzra' rmal c'ara' chanim xel ta ija'tz rmal. ");
INSERT INTO tzjE_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Per tak xel ta k'ij xc'atsaj y tak xq'uisbena xechkij rmal com majo'n xetque' ta bien ruxe'. ");
INSERT INTO tzjE_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","C'o chic jle' xkaja ptak q'uix y tak xq'uisbena xq'uiya q'uix y xk'ok'aj tejco'n y xcamsaj. ");
INSERT INTO tzjE_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Per c'o chic jle' xkaja chpam utzlaj ulew y congan xwachina, jun rk'arwech ija'tz c'ola xuya' jun cient, c'ola xuya' sesenta y c'ola xuya' treinta. ");
INSERT INTO tzjE_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Achnak c'ola rexquin tc'axaj c'a jquenbij. ");
INSERT INTO tzjE_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Je e rdiscípulo Jesús arj-e' xe'ekaja ruq'uin y cawra xecc'axaj tzra: —¿Nak tzra c'ambal tak tzij nacsaj tak ncatzijona cuq'uin wnak? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús cawra xbij chca: —Ixix yatanak chewa chnewutkij nak rbanic jwewtanak tzrij gobierno je rxin chcaj, per jle' chic wnak majo'n yatanak ta chca. ");
INSERT INTO tzjE_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Cara' quenbij chewa com je' wnak jc'ola yatanak chca arj-e' nyataj na más chca y tak nq'uisbena nuban q'uiy cuq'uin. Per je' wnak jmajo'n achnak yatanak chca per we nquech'ob j-e' chc'ola yatanak chca jara' nelsasa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Rmal c'ara' tak quencsaj c'ambal tzij tak quentzijona cuq'uin wnak com arj-e' c'ola ck'awech per majo'n nquetz'et ta je nc'u'ta chquewech, y c'ola quexquin per majo'n necc'axaj ta je nbixa chca y nmesquier nch'obtaja cmal. ");
INSERT INTO tzjE_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jquemjon rij camic ra jara' che nbantaja cumplir je rbin cana Dios ajni' rbin cana profeta Isaías jcawrara: —Newc'axaj na ruq'uin ewexquin per mesquier nch'obtaja ewmal, netz'et na ruq'uin ek'awech per nmajo'n achnak newsaj tzrij, cara' nbij. Y jun chic je rbin cana cawrara: ");
INSERT INTO tzjE_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","—Cawra quenbij chca j-ela wnak com canm cwernak y congan pen noc wa' pquexquin je nbixa chca, y xe cyupun ck'awech. Cara' nqueban ch-utz c'ara' majo'n nquetz'et ta je nc'u'ta chquewech, y nexte c'ola cgan necc'axaj je nbixa chca nexte c'ola cgan nquech'ob ptak canm je nch'o'ba chquewech nexte c'ola cgan chka' nquemloj ta wq'uin ch-utz c'ara' quencuy quil quemac, cara' nbij Dios. Cara' c'a bitanak cana. ");
INSERT INTO tzjE_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Per ixix kas congan wen chewa com netz'et je nc'u'ta chewech y newc'axaj je nbixa chewa. ");
INSERT INTO tzjE_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cara' quenbij chewa com ne ktzij wa' je xtenbij chewa, e q'uiy ja e ojer tak profeta y e q'uiy jle' chic wnak je xqueban rbeyal chwech Dios, arj-e' congan xecyarij xquetz'et ta ajni' nquixtajina netz'et ixix camic y congan xecyarij xecc'axaj ta chka' ajni' nquixtajina newc'axaj ixix camic. ");
INSERT INTO tzjE_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Tewc'axaj c'a camic, anen quench'ob chewech nak rec'mon ta jc'ambal tzij jxenbij chewa tzrij je tcoy tejco'n. ");
INSERT INTO tzjE_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ja utzlaj tzij jnuc'ut chkawech nak rbanic jgobierno rxin chcaj, tak nela rbixic y tak c'ola jun nc'axaj per mesquier nch'obtaja rmal, npeta diablo y nelsaj ela tzij jtcon pranm. Ja c'ara' nbij tzij ja ija'tz xkaja pbey. ");
INSERT INTO tzjE_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jq'ue ija'tz xkaja ptak abaj jara' nbij tzij je' wnak jnecc'axaj ja utzlaj tzij y alnak necnimaj y congan nquequicota rmal. ");
INSERT INTO tzjE_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Per arj-e' e ajni' tejco'n jmajo'n rc'amal ruxe', njurmaj oca necnimaj. Per tak xterla' jlowlo' tiemp tak nmajtaja rbanic lowlo' chca wnak rmal rtzojbal Dios arj-e' alnak nqueya' cana yukbal quec'u'x. ");
INSERT INTO tzjE_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ija'tz je xkaja ptak q'uix jara' nbij tzij je' wnak jnecc'axaj utzlaj tzij per tak nq'uisbena xnecbisoj chic je' achnak rxin jawra tiemp rxin rwech ruch'lew y xe nqueba'na engañar rmal mibil. Rmal c'ara' tak ncoma utzlaj tzij jc'ola ptak canm, majo'n rwech nuya' ta. ");
INSERT INTO tzjE_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Per ja ija'tz je xkaja chpam utzlaj ulew jara' nbij tzij je' wnak je nquec'axana utzlaj tzij y nch'obtaja cmal y c'ola rwech nuya' ptak canm. Arj-e' e ajni' jle' rk'arwech ija'tz c'ola xuya' jun cient, c'ola xuya' sesenta, c'ola xuya' treinta. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","C'o chic jun c'ambal tzij xbij chca cawrara: —Jgobierno rxin chcaj cara' rbanic ajni' xuban jun acha xutic jle' utzlaj ija'tz rxin trigo pe rchinoj. ");
INSERT INTO tzjE_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Per je' wnak tak ekanak chic che wram xpeta jun je ntzelana rxin acha, xretca' jle' itzel tak ija'tz checjol trigo. Tak xtictaj cana rmal xemloja. ");
INSERT INTO tzjE_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jtrigo xumaj c'yinem y tak xumaj rek'neric rwech tzra' xutkix wa' chka' jle' chic je tcon checjol ja itzel k'ayis. ");
INSERT INTO tzjE_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Je ajsmajma' arj-e' xeba ruq'uin cpatrón jxetcowa utzlaj ija'tz, cawra xecbij tzra: —Kajaw ¿lme utzlaj ija'tz tc'a xatic chpam achinoj? ¿Nak tzra c'ara' tak c'ola itzel tak k'ayis checjol camic? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Cawra xbixa chca: —Jara' je ntzelana wxin xetcowa, cara' xbixa chca. J-e' ajsmajma' cawra xecbij chic tzra: —¿Le mtawajo' c'a nokba camic nekabko'? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Cawra xbix chic chca: —Mcara' ta, mtebok ta, mal-il nuc'om ta trigo tak xtebok. ");
INSERT INTO tzjE_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Je nkaban camic kay-a' tzra', tq'uiy na che c-e', tak xterla' tiemp rxin csech anen quenbij na chca je xtquesmaja chpam tiemp rxin csech cawrara: —Temlo' ruchi' nabey mul jitzel tejco'n, texma' rpam ptak mnoj ch-utz c'ara' nporoxa. Per je trigo temlo' ruchi' chka' y tec'lo', cara' xtenbij chca. Cara' c'ambal tzij xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","C'o chic jun c'ambal tzij xbij chca cawrara: —Jgobierno rxin chcaj cara' rbanic ajni' jun ch'it rk'arwech mostaza jnec'mar ela rmal jun acha y xutic pe rchinoj. ");
INSERT INTO tzjE_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jun ch'it rk'arwech mostaza jara' más na ch'it no'y chwech jle' chic ija'tz per tak nq'uiya más na nq'uiya chwech jle' chic tejco'n, cara' nuban ajni' jun che'. Rmal c'ara' ch'tak tz'quin nquepeta, necrebna' quesoc ptak ruk'a'. Cara' c'ambal tzij xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","C'o chic jun c'ambal tzij xbij chca cawrara: —Jgobierno rxin chcaj cara' rbanic ajni' nuban jle' levadura jnespoja xquelway rmal, xpeta jun ixak xuc'am, xuya' chpam jle' k'or, oxi' pajbal harina ocnak. Tak xq'uisbena jlevadura xba chpam njelal k'or, congan xesmaja chpam. Cara' jc'ambal tzij xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Njelal tzij je xbij Jesús chca wnak, chpam c'ambal tak tzij xbij wa' chca. Nmajo'n achnak xbij chca mquita xucsaj c'ambal tak tzij che rbixic. ");
INSERT INTO tzjE_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Cara' xuban ch-utz c'ara' tzra' nbantaj wa' cumplir jbitanak cana ojer rmal profeta jcawrara nbij: —Tak xtquentzijona, chpam c'ambal tak tzij quentzijon wa'. Ja wewtanak ta tak q'uemjana twankera rwech ruch'lew anen quenk'alsaj na. Cara' bitanak cana. ");
INSERT INTO tzjE_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","C'jara' ja' Jesús xbij cana rubi' chca je' wnak y xoca pjay. J-e' rdiscípulo xe'ekaja ruq'uin y cawra xecbij tzra: —Tech'bo' chkawech nak rec'mon ta jc'ambal tzij jxabij kaja tzrij tejco'n je xti'ca checjol trigo, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús cawra xbij chca: —Anen c'ara' jquentcowa utzlaj ija'tz, anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Je chnoj jara' rwech ruch'lew. Ja utzlaj ija'tz jara' alc'walxela' jec'ola precwent jgobierno rxin chcaj. Ja itzel tejco'n jara' alc'walxela' jec'ola precwent diablo. ");
INSERT INTO tzjE_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jxetcowa itzel tejco'n je ntzelana rxin acha jara' diablo. Je tiemp rxin csech jara' tak xtetz'kata tiemp rxin rwech ruch'lew. Je nquemlowa csech j-era' ángel. ");
INSERT INTO tzjE_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ajni' nba'na tzra itzel tejco'n nmo'la ruchi' y nporoxa pk'ak' cara' c'a xtba'na chca wnak chka' tak xtetz'kata tiemp rxin rwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak xquenutak ta ángel wxin, nquequerchpa' conjelal wnak jec'ola chpam ngobierno ja xe nquecchajtij je' wnak che rbanic il mac, nquequerchpa' chka' conjelal jle' chic wnak xe e bnoy itzel tak achnak. ");
INSERT INTO tzjE_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tak nquechaptaja cmal nquecch'akij ela chpam nimlaj k'ak'. Je' wnak ajni'la ok'ej xtqueban chpam jara' lwar y xteccach'ch'ej rkan cak'. ");
INSERT INTO tzjE_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","C'jara' je' wnak jquebnon rbeyal chwech Dios arj-e' nyataj na chca che nqueban cara' ajni' nuban k'ij, nwankera quech'ab chpam rgobierno Dios je Ttixel cxin. Achnak c'ola rexquin tc'axaj c'a jquenbij. ");
INSERT INTO tzjE_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jun chic, jgobierno rxin chcaj cara' rbanic ajni' jun nimlaj mibil wiwan, mkun chpam jun chnoj y chek q'uenjlal xiltaja rmal jun acha. Y ja' acha xumuk chic jmul y xemloja, congan nquicota, njelal achnak jc'ola ruq'uin nc'ayij y nulok' chnoj jabar c'o wa' nimlaj mibil. ");
INSERT INTO tzjE_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jun chic, jgobierno rxin chcaj cara' rbanic ajni' nuban jun comerciante ntajina ncanoj jle' abaj perla rubi', congan nmak rjel. ");
INSERT INTO tzjE_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tak xuwil jun perla jmás nim rjel xba y xerc'ayij njelal achnak jc'ola ruq'uin y xulok' jperla. ");
INSERT INTO tzjE_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jun chic, jgobierno rxin chcaj cara' rbanic ajni' jun trasmay nch'akixa pya' y nque'oca ch'u' chpam per nq'uiy quewech je' ch'u' nque'oca chpam. ");
INSERT INTO tzjE_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tak xenoja ch'u' chpam xelsas ta chiya'. Jxelsan ta arj-e' xetz'be'a, xquemaj ccha'ic ch'u'. Jwen tak ch'u' jara' xec'o'la, jmajo'n cc'atzil jara' xecch'akij ela. ");
INSERT INTO tzjE_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Cara' c'a xtbantaja chka' tak xtetz'kata tiemp je rxin rwech ruch'lew, nquepeta je' ángel nquequerlsaj ela itzel tak wnak chquecjol jquebnon rbeyal chwech Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Y nquecch'akij ela chpam nimlaj k'ak'. J-e' wnak ajni'la ok'ej xtqueban chpam jara' lwar y xteccach'ch'ej rkan cak', cara' xbij Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","C'jara' xbij chic chca: —¿Le nch'obtaja ewmal njelal jxenbij chewa? —Nch'obtaja Kajaw, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Cawra xbij chic jmul chca: —Com nch'obtaja ewmal rmal c'ara' quenbij chewa che conjelal maestro jnectijoj qui' tzrij jgobierno rxin chcaj arj-e' e junam ruq'uin jun rajaw jay nc'ola njelal ruq'uin je nc'atzina tzra, c'ola je' achnak c'ac', c'ola majo'n c'ac' ta chka', y arja' nelsaj ta jachnak nc'atzina tzra wc'ac' we mc'ac' ta. Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ja' Jesús tak xbitaja rmal njelal jawra c'ambal tzij xel ela ");
INSERT INTO tzjE_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","y xba chpam retnamet. Tak xekaja xoca chpam jay rxin molbal ri'il y xumaj ctojxic wnak. J-e' wnak congan xel ta canm tzrij tijonem jxuya' chca y cawra xecbij chbil tak qui': —¿Abar rec'mon wala' njelal jc'ola ruq'uin jun acha jala? Congan tak wan rna'oj y congan nmak tak milagro nuban chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Per ¿le mja' tc'ala' rlec'wal jsoy che'? Y jrute' ¿le mja' tc'ara' María? Y je rch'alal ¿lme j-e' tc'ara' Jacobo, José, Simón ruq'uin Judas? ");
INSERT INTO tzjE_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Y conjelal rana' ¿lmec'o tc'a chkacjol chka'? ¿Abar c'a rec'mon wa' njelal jremjon rij camic? ");
INSERT INTO tzjE_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Cara' necbij per nmajo'n cgan tzrij, xe pkan nquena'. Ja' Jesús cawra xbij chca: —Nmajo'n profeta rxin Dios mquita lok' xtna'a xerwara' mlok' ta nna'a cmal rwinak nexte cmal rch'alal chka', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Y xe mq'uiy ta milagro xuban tzra' rmal jmajo'n xeyke' ta quec'u'x ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chpam jara' tiemp njelal je ntajina nuban Jesús xekaja rbixic ruq'uin gobernador Herodes. ");
INSERT INTO tzjE_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ja' Herodes cawra xbij chca ajsmajma' jec'ola ruq'uin: —Jala' acha jcongan q'uiy achnak remjon rij jala' Juan Bautista c'astanak ta chquecjol cnomki' rmal c'ara' tak c'ola nmak tak poder jnesmaja ruq'uin camic, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Cara' xbij com bien rutkin chja' xcamsana Juan Bautista tak xutak rchapic, xxi'ma y xucsasa pcars. Cara' xuban tzra com cawra xbixa tzra rmal Juan Bautista: —Mrubey ta abnon jac'mon kaja awexnam, cara' xbij. Com ja' Herodes rec'mon kaja rexnam, Herodías rubi', rexkayil jun rch'alal, Felipe rubi'. ");
INSERT INTO tzjE_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jxuban ja' Herodes nabey tak q'uemjana tcamsaj Juan Bautista xrajo' ta ncamsaj per xe nxibej ri' chquewech wnak com je' wnak necbij che Juan Bautista arja' jun profeta rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Per tak xq'uisbena xcamsaj tak xerla' k'ij je nc'u'la rcumpleaño. Ja Herodías c'ola jun ral q'ue k'poj xtan y ja' k'poj nexjowa chquewech wnak jquemlon qui' ruq'uin ja' Herodes. Ja' Herodes congan xel ta ruc'u'x tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Rmal c'ara' tak cawra xbij tzra k'poj: —Tc'utuj chwa achnak nawajo' y anen quenya' chawa, cara' xbij tzra, y xuban jurar chnuya' tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Per ja' k'poj cawra xbixa tzra rmal rute': —Jnac'utuj tzra Herodes jara' jawrara: —Je rwá' Juan Bautista tey-a' chwa chwech jun plat, cara' xtac'utuj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Per ja' rey Herodes congan junwa' xuna' per com rebnon chic jurar chquewech jec'ola ruq'uin tzrij mes rmal c'ara' xuya' jun orden che nya'a tzra k'poj je xc'utuj. ");
INSERT INTO tzjE_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Xutak rcamsic Juan pcars che nelsasa rwá'. ");
INSERT INTO tzjE_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tak xlestaja rwá' xya' ta chwech jun plat y xerja'cha tzra xtan. Je k'poj xuc'am ela, xerejcha' tzra rute'. ");
INSERT INTO tzjE_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Je rdiscípulo Juan tak xecc'axaj che xcamsasa arj-e' xeba, xequec'ma' recuerpo y xequemku'. C'jara' xeba, xecbij tzra Jesús je xbantaja. ");
INSERT INTO tzjE_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ja' Jesús tak xekaja rbixic ruq'uin je xbantaja arja' xoc ela planch, xeryonaj ri' chpam jun tenlic lwar abar e majo'n wa' wnak. Per wnak tak xekaja rbixic cuq'uin jabar nba wa' congan e q'uiy chca xe'el ela ptak quetnamet, xeba che ckan chnequewla'. ");
INSERT INTO tzjE_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ja' Jesús tak xel ta chpam lanch xerutz'et wnak ncongan e q'uiy. Arja' xpoknaj quewech y xerchumsaj yuw-i'. ");
INSERT INTO tzjE_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tak xkaja k'ij je rdiscípulo Jesús arj-e' xeba ruq'uin y cawra xecbij tzra: —Je' lwar abar okc'o wa' congan tlana y xba hor. Jnaban camic que'atka' ela wnak ptak aldea chnequelk'o' je nquetaj, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Majo'n nc'atzin ta che nqueba, ixix nquixyowa chca nak xtquetaj, cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Per majo'n achnak kac'mon ta, ruyon oca j-o' rkan xquelway ruq'uin c-e' ckan ch'u', cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Tec'ma' ta, cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","C'jara' cawra xbij chca wnak: —C'ola nic'aj wen tak k'ayis quixetz'be'a tzrij, cara' xbij chca. C'jara' xuc'om j-o' rkan xquelway rexbil c-e' rkan ch'u', xca'ya chcaj y xmeltioxij tzra Dios. Xuwech' xquelway, xujach chca rdiscípulo y j-e' xqueya' chic chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Xewa'a conjelal y congan xnoja quepam. Je xquelway rexbil ch'u' xmo'la ruchi' je xcoltaja, cbeljuj chquech xuban, per nnojnak. ");
INSERT INTO tzjE_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jxewa'a ec'o la la' e j-o' mil per xqueyon ach-i', apart ixki' ruq'uin ac'ala'. ");
INSERT INTO tzjE_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","C'jara' ja' Jesús cawra xbij chca rdiscípulo: —Npors nquixoc ela chpam lanch, nquixba pjupraj chic ya', nquixnabyeja chenwech, cara' xbij chca, y xbij cana rubi' chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tak xbitaj cana rubi' rmal xojte'a ruyon chwech jun jyu', xuwil jun lwar abar nuban wa' oración. Tak xoca ak'a' xruyon c'ola tzra'. ");
INSERT INTO tzjE_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jlanch kas pe nc'aj ya' c'o chwa' tak c'ola jun nimlaj k'ek' jaktanak ta chquij rdiscípulo y nmesquier nquebina rmal, y je nmak tak bloj congan lowlo' nuban tzra lanch. ");
INSERT INTO tzjE_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jpe rsakric remjon binem pe rwá' ya' ja' Jesús y xekaja chenkaj ruq'uin lanch. ");
INSERT INTO tzjE_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","J-e' rdiscípulo tak xquetz'et chremjon binem pe rwá' ya' congan xecxibej qui' rmal y congan xturtaja quec'u'x: —Jala' jun xbinel, cara' necbij y xquemaj rakic quechi' rmal xben ri'il. ");
INSERT INTO tzjE_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ja' Jesús cawra xbij chca: —Me tturtaj ta rwech ec'u'x, xanen, mtexibej ta ewi', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro cawra xbij tzra: —We ktzij chatet Wajaw tbij chwa chquenbina pe rwá' ya' y quenba awq'uin, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Catjo' c'a, cara' xbixa tzra rmal Jesús. C'jara' Pedro xel ta chpam lanch y xumaj binem pe rwá' ya' y xba ruq'uin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Per tak xutz'et k'ek' chcongan lowlo' nuban arja' congan xxibej ri' rmal y xba xe' ya' y xumaj rakic ruchi': —Wajaw kat-o' ki', cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ja' Jesús alnak xuchap Pedro y xelsaj pya' y cawra xbij tzra: —Acha, xe mnim ta yukbal ac'u'x wq'uin. ¿Nak tzra tak xaban c-e' ac'u'x? cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tak xe'oca chpam lanch xcoma k'ek'. ");
INSERT INTO tzjE_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jec'ola chpam lanch arj-e' xquemaj rya'ic ruk'ij y cawra xecbij tzra: —Ne ktzij wa' chatet at Rlec'wal Dios, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Xeba, xe'ekaja pjupraj ya' chpam jun lwar rbin-an Genesaret. ");
INSERT INTO tzjE_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Je' wnak jec'ola chpam jara' lwar tak xquetzu' chJesús xekaja cuq'uin, arj-e' xectakla' rbixic chca conjelal wnak jec'ola chpam jara' lwar y conjelal yuw-i' xequec'om ela ruq'uin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Y cawra xecbij tzra: —Tebna' jun utzil chka, tey-a' c'as chca yuw-i' che nquechap oca jtz'it atziak, jtz'it ruchi' opech nquechap oca, cara' xecbij tzra. Y cara' xqueban, conjelal jxechpowa retziak xechumtaja. ");
INSERT INTO tzjE_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ec'ol c'a jle' maestro je nquetijona cxin wnak tzrij rley Dios jtz'ibtanak cana rmal Moisés e quexbil jle' fariseo, arj-e' epenak pJerusalén, xe'ekaja ruq'uin Jesús y cawra xecbij tzra: ");
INSERT INTO tzjE_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Nak tzra je' adiscípulo majo'n necnimaj ta costumbre cxin kti't kawma'? Com j-e' tak nquewa'a majo'n necnimaj ta ajni' nrajo' kcostumbre tzrij ch'joj k'baj, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ja' Jesús cawra xbij chca: —Per ixix chka' majo'n eniman ta rmandamiento Dios com c'ola nic'aj costumbre neban chbil tak ewi' xnuyoj mandamiento. ");
INSERT INTO tzjE_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Cara' quenbij chewa com Dios c'ola jun mandamiento rey-on chewa jcawra nbij: —Lok' que'en-a' edta' ete', cara' nbij. Y jun chic mandamiento jrey-on chewa cawra nbij: —Wc'ola jun xitzel ntzijona tzrij redta' o rute' jara' pors ncomsasa. ");
INSERT INTO tzjE_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per ixix xmajo'n lok' ta nque'ena' com xcawra tijonem neya': —Wnabij tzra adta' o ate': —Camic mesquier quencwina catnuto' tzrij je' achnak je nc'atzina chawa com nbin chic tzra Dios che rxin chic arja' njelal jc'ola wq'uin, wcara' nabij tzra, ");
INSERT INTO tzjE_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","jara' majo'n chic nc'atzin ta chnato' tzrij je nc'atzina tzra, cara' nebij. Cara' ebnon, je rmandamiento Dios, ixix ebnon tzra com ajni' majo'n, per xe rmal ecostumbre. ");
INSERT INTO tzjE_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Caca' eplaj, bien tkala chewij jbin ta chewa ojer rmal profeta Isaías, cawra nbij: ");
INSERT INTO tzjE_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","—J-ewra wnak ne chquechi' oca nqueya' wa' nuk'ij, jcanm q'ue c'nat c'o wa' chenwech. ");
INSERT INTO tzjE_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nmajo'n noc wa' tak nqueya' nuk'ij, jtijonem nqueya' rtzojbal Dios necbij tzra, per xmandamiento cxin wnak. Cara' bin ta chewa rmal Isaías, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ja' Jesús xumaj chic tzij cuq'uin wnak y cawra xbij chca: —Tewc'axaj je xtenbij chewa, xtch'obtaj ta ewmal. ");
INSERT INTO tzjE_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mjara' ta jnoca pnachi' je ntz'ilorsana rwech awanm, per je ntz'ilorsana rxin jara' je nel ta pnachi', cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","J-e' c'a rdiscípulo xeki'l oca ruq'uin y cawra xecbij tzra: —¿Le awutkin c'a che aj fariseo junwa' necc'axaj jxabij kaja? Xe pkan nquena' rmal, c'ara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús cawra xbij chca: —Jtijonem chka bechnak opech tijonem wmajo'n tcon ta rmal Nedta' jc'ola chcaj jara' tijonem xe nyo'ja y nbo'ka ajni' nba'na tzra k'ayis. ");
INSERT INTO tzjE_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Que'ay-a' tzra' j-ela aj fariseo, arj-e' xe ajni' moya' je ecc'an chic jle' moya'. Per jun moy we rc'an chic jun moy xe nquetza'k ela pjul che c-e', cara' c'a xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro cawra xbij tzra: —Tech'bo' chkawech jc'ambal tzij jxabij, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús cawra xbij chca: —Tak mesquier nch'obtaja ewmal ixix chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Le mtch'obtaj c'a ewmal jnoca pnachi' jara' chapam nekaj wa' y nel chic jmul? ");
INSERT INTO tzjE_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per je nel ta pnachi' jara' pnawanm nwanker twa' y jara' ntz'ilorsana rxin awanm. ");
INSERT INTO tzjE_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Cara' quenbij chawa com pnawanm nwanker twa' jitzel tak na'oj ajni' bnoj cmic, ajni' ncatoca ruq'uin jun ixak jmawexkayil ta, o ajni' tzra jun ixak noca ruq'uin jun acha we mrechjil ta, ajni' bnoy alak', ajni' tzra tak naya' testig-il jme ktzitzij ta, ajni' tak nabij jle' tzij tzra Dios jxitzel nc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Njelal jawra rtzilal ja c'a wa' ntz'ilorsana rxin awanm, per we mtaban costumbre ajni' ch'joj k'baj jara' majo'n ntz'ilorsas ta awanm rmal. Cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","C'jara' ja' Jesús xel ela chpam lwar, xba chic chpam jun lwar abar c'o wa' c-e' tnamet, jun rbin-an Tiro y jun chic Sidón rubi'. ");
INSERT INTO tzjE_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tak xekaja chek q'uenjlal tak c'ola jun ixak xekaja ruq'uin. Ja' ixak aj cananea nbixa tzra y tzra' c'o wa' chpam lwar abar xekaj wa' Jesús. Arja' xurak ruchi' tzrij Jesús y cawra xbij tzra: —Wajaw, at Rlec'wal ja ojer rey David, tpoknaj jtz'it nwech, c'ola jun wal xtan ocnak jun itzel espíritu pranm y congan lowlo' nba'na tzra, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Per Jesús nmajo'n achnak xbij tzra. Xepeta rdiscípulo y cawra xecbij tzra: —Tebna' jun utzil, tbij tzra ixak chnemloja, congan nurak ruchi' chkij, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús cawra xbij chca: —Dios xruyon cuq'uin tnamet Israel enretkon twa', arj-e' e ajni' jle' carne'l etzaknak cana, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Per xpeta ixak, xexque'a chwech y cawra xbij tzra: —Wajaw cnat-o', cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús cawra xbij tzra: —Mrubey tc'ara' xtenc'am ta queway alc'walxela' y xtench'akij ta chquewech ch'tak ral tz'e', cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ja' ixak cawra xbij chic tzra: —Wajaw, ne ktzij wa' jnabij per je' ch'tak ral tz'e' arj-e' nya'a c'as chca cmal cajaw che nquetaj je' ruc'aj tak way je ntza'k ela xuxe' mes, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Cawra xbix chic jmul tzra rmal Jesús: —Ixak, congan tak nim yukbal ac'u'x wq'uin. Camic nec'choja awal ajni' xac'utuj chwa, cara' xbixa tzra y njara' hor xec'choja ral. ");
INSERT INTO tzjE_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ja' Jesús xel ela chpam lwar, xba xekaja chuchi' ya' Galilea rubi', xojte'a chwech jyu', xuwil jun lwar abar xetz'be' wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Congan e q'uiy wnak xe'ekaja ruq'uin, equec'mon ta je' yuw-i' ajni' je' ch'e'y nquebina, ajni' moya', ajni' mema', ajni' jmajo'n tz'kat ta je' quek'a' o ckan, y ec'o na más yuw-i' xequey-a' chwech Jesús y arja' xerchumsaj. ");
INSERT INTO tzjE_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Je' wnak congan xel ta quec'u'x tzrij je xbantaja. Je' mema' nquetzijon chic, jme tz'kat ta quek'a' ruq'uin ckan xechumtaja, je' ch'e'y nquebina arj-e' jic chic xebina, je' moya' nqueca'y chic. Arj-e' congan xqueya' ruk'ij Dios, jara' Dios rxin tnamet Israel. ");
INSERT INTO tzjE_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","C'jara' ja' Jesús xersiq'uij pona rdiscípulo y cawra xbij chca ra: —Congan quenpoknaj quewech wnak, xuban oxi' k'ij quec'je'a wq'uin y xq'uisa je' achnak je nquetaj. Majo'n quenwajo' ta quenutak ela je mquita xtquewa' ela, mxe rmal wyejal xtquetke'a ptak bey, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","J-e' rdiscípulo cawra xecbij tzra: —Jawra lwar abar okc'o wa' congan tlana. ¿Abar c'a nekac'ma' wa' je xtquetaj wnak? com congan e q'uiy, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Ajru' rkan xquelway c'ola ewq'uin? xc'axaxa chca rmal Jesús. —Wku' rkan rexbil e c-e' oxi' rkan ch'u', cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ja' Jesús xbij chca wnak che nquetz'be'a ptak ulew. ");
INSERT INTO tzjE_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","C'jara' xuc'am wku' rkan xquelway rexbil ch'u', xmeltioxij tzra Dios, xuwech' y xujach chca rdiscípulo. J-e' c'a rdiscípulo xqueya' chic chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Che conjelal j-e' wnak xewa'a y congan xnoja quepam. Je xquelway rexbil ch'u' xmo'la ruchi' je xcoltaja, wku' chquech xuban, per nnojnak. ");
INSERT INTO tzjE_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Xewa'a e cji' mil per xqueyon ach-i', apart ixki' ruq'uin ac'ala'. ");
INSERT INTO tzjE_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","C'jara' ja' Jesús xbij cana rubi' chca wnak, xoc ela chpam lanch, xba chpam lwar rubi' Magdala. ");
INSERT INTO tzjE_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ec'ol c'a jle' fariseo e quexbil jle' saduceo, arj-e' xe'ekaja ruq'uin Jesús, xecc'axaj je' achnak tzra chnecbanbej probar y cawra xecbij tzra: —Tebna' jun milagro per nq'ue tzra' chcaj npe wa' chnuc'ut chkawech che Dios yoyona chawa jpoder c'ola awq'uin, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Y cawra xbixa chca: —Tak noca ak'a' ixix cawra nebij: —Camic wen tiemp penak, caj nec'tuwa, congan quiek, cara' nebij. ");
INSERT INTO tzjE_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y c'ola nebij ptak rsakric cawrara: —Tzra jawra k'ij majo'n wen ta tiemp penak, caj nec'tuwa, congan quiek y congan mkula, cara' nebij. Caca' eplaj, ixix bien nch'obtaja ewmal nak rec'mon ta jnetz'et chcaj per je ntajina nuban Dios chewech chpam jawra tiemp ja okc'o wa' jara' mtch'obtaja ewmal nak rec'mon ta. ");
INSERT INTO tzjE_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Je' wnak je nquec'utuna chwa chquenban jun milagro ch-utz c'ara' quencnimaj, arj-e' xjunwa' ykul wa' quec'u'x y mruq'uin ta Dios. Per jmilagro jnecc'utuj jara' majo'n quenban ta chquewech per xerwara' c'ola jun milagro nbantaj na chquewech, jun milagro ajni' xbantaj ta tzra ojer profeta Jonás. Cara' xbixa chca rmal Jesús. C'jara' xel ela chquecjol y xba. ");
INSERT INTO tzjE_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tak xe'ekaja pjupraj ya' j-e' c'a rdiscípulo xquetzu' chmajo'n queway quec'mon ta, xecmestaj cana. ");
INSERT INTO tzjE_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús cawra xbij chca: —Kas bien tech'bo', kas tebna' cwent ewi' chwech levadura cxin aj fariseo e quexbil aj saduceo, cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","J-e' c'a rdiscípulo xquemaj tzij chbil tak qui', cawra necbij ra: —Cara' nbij chka rumac majo'n way kac'mon pta, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Per Jesús arja' rutkin nak quemjon rbixic y cawra xbij chca: —Ach-i', ntak majo'n yukbal ec'u'x wq'uin. ¿Nak tzra tak nebij: —Tak nmajo'n way xkac'om pa? ");
INSERT INTO tzjE_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Le mja'n c'a tch'obtaj ewmal? ¿Le mterkaj c'a pnewá' jxenban tzra j-o' rkan xquelway jxentzukbej e j-o' mil ach-i'? ¿Le mterkaj c'a pnewá' ajru' chquech xcoltaj cana? ");
INSERT INTO tzjE_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Le mterkaj c'a pnewá' jxenban chic tzra wku' rkan xquelway jxentzukbej e cji' mil ach-i'? ¿Le mterkaj c'a pnewá' chka' ajru' chquech xcoltaj cana? ");
INSERT INTO tzjE_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nak tzra tak mesquier nch'obtaja ewmal jxenbij chewa che tebna' cwent ewi' chwech levadura cxin aj fariseo e quexbil aj saduceo? Me rmal ta xquelway xemestaj cana tak xenbij cara' chewa, cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","C'jara' xch'obtaja cmal je xbij Jesús che nqueban cwent qui' chwech tijonem cxin aj fariseo e quexbil aj saduceo, mja' ta levadura rxin xquelway nqueban cwent qui' chwech. ");
INSERT INTO tzjE_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ja' Jesús tak xe'ekaja chenkaj tnamet Cesarea jc'ola precwent Filipo cawra xc'axaj chca rdiscípulo: —Anen en Rlec'walxel jxenoca alxic cuq'uin wnak ¿nak nbanic anen necbij wnak chwa? ");
INSERT INTO tzjE_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","J-e' rdiscípulo cawra xecbij tzra: —Ec'ola nquebina chawa chatet at Juan Bautista, jle' chic nquebina chawa che at Elías, ec'ola nic'aj necbij chawa che at Jeremías owe at jun chca e ojer tak profeta, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ixix ¿nak nebij chwa, nak nbanic nech'ob? ");
INSERT INTO tzjE_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Xpeta Simón Pedro y cawra xbij tzra: —Atet at Cristo at Rlec'wal c'aslic Dios, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ja' Jesús cawra xbij tzra: —Kas congan quicotemal chawa Simón rlec'wal Jonás, com jxabij kaja chwa me wnak ta xk'alsana chawech, jNedta' jc'ola chcaj jara' xk'alsana chawech. ");
INSERT INTO tzjE_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Anen quenbij chawa che atet at Pedro y pe rwá' jawra abaj xtentic wa' wiglesia y je rchuk'a' cmic majo'n necwin ta tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Anen c'ola jle' llave quenya' na chawa rxin jgobierno rxin chcaj. Y achnak mtaya' c'as tzra wawe' chwech ruch'lew jara' majo'n nya' ta c'as tzra chcaj. Y achnak naya' c'as tzra wawe' chwech ruch'lew jara' nya'a c'as tzra chcaj, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","C'jara' congan xbij chca rdiscípulo chmajo'n abar tzra' necbij wa' chja' Cristo. ");
INSERT INTO tzjE_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ja' Jesús, chpam jara' tiemp xumaj ta rk'alsaxic chquewech rdiscípulo che nc'atzina nba na pJerusalén, cawra xbij chca: —Cnetja' na lowlo' pquek'a' principal-i' e quexbil cjefe sacerdote, chka' e quexbil maestro je nquetijona cxin wnak tzrij rley Dios. Y congan lowlo' xtba'na chwa, quencamsax na y chrox k'ij quenc'astaj na, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ja' Pedro xkubsaj ta Jesús ruq'uin y congan cow xuchap tzan rutzij, cawra xbij tzra: —Dios ta xtpoknaj awech, jxabij kaja jara' majo'n nbantaj ta, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ja' Jesús xuya' volt y cawra xbij tzra Pedro: —Catel ela chenwech Satanás, atet xat ajni' jun achnak xe cnapajsaj chpam bey jnemjon rij. Cara' quenbij chawa com mcara' ta nawajo' chwa chquenban ajni' nrajo' Dios chwa chquenban, xjunam ana'oj cuq'uin wnak, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","C'jara' ja' Jesús cawra xbij chca rdiscípulo: —Wc'ola jun nrajo' neyke'a ruc'u'x wq'uin nc'atzina chmajo'n nuya' ta rgan je tzbuklaj c'aslemal rc'an. Nc'atzina chka' chmajo'n npoknaj ta ri' nutaj pen nmal anen y netre' ta chwij. Jara' ajni' jun cruz nya'a tzrij per nmajo'n npoknaj ta ri' nuc'am ela cruz, ntelej ela y nba abar ncamsas wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Cara' quenbij chewa com nak wnak npoknaj nuya' cana rc'aslemal jara' majo'n nuwil ta utzlaj c'aslemal je rxin junlic. Per nak wnak majo'n npoknaj ta nuya' cana rc'aslemal nmal anen jara' nuwil utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Com ajni' tzra jun wnak ¿nak nuch'ec tzrij wxuch'ec njelal mibil rxin rwech ruch'lew per majo'n xuwil ta utzlaj c'aslemal je rxin junlic? Wxutzak cana utzlaj c'aslemal je rxin junlic jara' next jun mibil xtlok'bej ta. ");
INSERT INTO tzjE_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Cara' quenbij chewa com anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak quenpe chna jmul e wexbil je' n-ángel, tzra' c'ara' regloria Dios congan nch'a'ana chwij y je' wnak quenrey-a' na rtojbalil chca chejujnel je xqueban wawe' chwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ne ktzij wa' je xtenbij chewa ra, ec'ola chewa jec'ola wawe' camic ra ec'as na tak xtquetz'et Rlec'walxel jxoca alxic cuq'uin wnak penak chpam rgobierno. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Je pwajki' k'ij ja' Jesús xeruc'om ela Pedro, Jacobo ruq'uin Juan je rch'alal Jacobo, xeba xecyonaj qui' pe rwá' jun nimlaj jyu'. ");
INSERT INTO tzjE_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jruplaj Jesús xuq'uex ri' chquewech, congan ruch'a' xwankera cara' ajni' k'ij y retziak congan sak xela ajni' luz. ");
INSERT INTO tzjE_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chek q'uenjlal xwankera chquewech Moisés ruq'uin Elías, quemjon tzij ruq'uin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ja' Pedro cawra xbij tzra Jesús: —Wajaw, kas congan qui'il okc'ola wawe' ra. Wnawajo' atet, nak tzra mtkoc'je'a wawe' y nkaban oxi' jay lona nkacsaj, jun awxin atet, jun rxin Moisés y jun rxin Elías, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","C'remjon tzij Pedro tak chek q'uenjlal c'ola jle' sutz' congan ruch'a' xermujaj y c'ola jun kul xtzijon ta chpam, cawra xbij ra: —Ja c'a wa' quilaj Wlec'wal, congan quenquicota tzrij, tey-a' ewexquin tzrij nak nbij chewa, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","J-e' rdiscípulo tak xc'axtaja cmal je xbixa chca rmal jkul arj-e' xejpe'a ptak ulew, congan xecxibej qui'. ");
INSERT INTO tzjE_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús arja' xki'l oca cuq'uin, xeruchap y cawra xbij chca: —Quixyictaja, mtexibej ta ewi', cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Arj-e' tak xeca'ya e majo'n chic Moisés ruq'uin Elías, xruyon chic Jesús c'o cana. ");
INSERT INTO tzjE_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","C'jara' xeba, kas exlen ta pe rwá' jyu' tak cawra xbixa chca rmal Jesús: —Nmajo'n abar tzra' xtebij wa' jxetz'et, c'jara' xtebij tak c'astanak chic chquecjol cnomki' je Rlec'walxel jxoca alxic cuq'uin wnak, cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","J-e' c'a rdiscípulo cawra xecbij tzra: —Wcara' nabij ¿nak tzra c'ara' je' maestro rxin ley arj-e' necbij che Elías nc'atzina npeta nabey mul chwech Cristo? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ne ktzij wa' necbij che Elías npeta nabey mul che nerchumsaj njelal rubey Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Per anen quenbij chewa che Elías arja' penak chic per arj-e' xmesquier xch'obtaj ta cmal nak wnak ocnak wa' y xqueban tzra ajni' kas xrajo' cgan. Y cara' xteba'na tzra chka' Rlec'walxel jxoca alxic cuq'uin wnak, arja' neretja' na lowlo' pquek'a' chka', cara' xbij ja' Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","J-e' rdiscípulo tak xc'axtaja cmal je xbixa chca, arj-e' xch'obtaja cmal che tzrij Juan Bautista ntzijon wa' y me tzrij ta Elías ntzijon wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tak xe'ekaja abar ec'o can wa' wnak c'ola jun acha xerkaja ruq'uin Jesús, xexque'a chwech y cawra xbij tzra: ");
INSERT INTO tzjE_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Wajaw, anen c'ola jun wlec'wal yawa', tpoknaj jtz'it nwech com c'ola jun ryubil rex cmic y congan lowlo' nuban rmal. Q'uiylaj mul ch'akin pk'ak' rmal y q'uiylaj mul ch'akin pya' chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xenc'om ta chquewech adiscípulo per j-e' mxecwin ta xecchumsaj, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ja' Jesús tak xc'axtaja rmal je xbixa tzra rmal acha cawra xbij ra: —Ixix ja ix tnamet Israel, ntak majo'n yukbal ec'u'x wq'uin, tak nmajo'n wen ta ena'oj. Quenwajo' nec'choja nsamaj checjol, congan pen chwa chquencoch' más tak mteyke'a ec'u'x wq'uin. Camic tec'ma' ta ala' wq'uin, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ja' Jesús tak xec'mar ta ala' ruq'uin xuchap bien tzan rutzij jitzel espíritu jocnak pranm. Y xel ela jitzel espíritu pranm ala' y njara' hor xchumtaja. ");
INSERT INTO tzjE_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Je rdiscípulo Jesús arj-e' xecyonaj qui' ruq'uin y cawra xecc'axaj tzra: —¿Nak tzra c'ara' ajoj mesquier xokocwin ta xkalsaj jitzel espíritu? Cara' xecc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Rmal je mnim ta yukbal ec'u'x wq'uin rmal c'ara' tak mxixecwin ta. Com ne ktzij wa' je xtenbij chewa ra, wc'ola yukbal ec'u'x wq'uin, y wnesmaja yukbal ec'u'x ajni' nuban jun ch'it rk'arwech mostaza, nquixecwin c'ara' neban jun nimlaj samaj. Ajni' tzra jun jyu' ra, nquixecwina nebij tzra che nel ela abar tzra' c'o wa' y nk'axa chpam jun lwar chic y nquixernimaj, y majo'n c'o ta jun achnak mquita nquixecwina neban. ");
INSERT INTO tzjE_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ja itzel tak espíritu ja e ctakla jara' nc'atzina oración y nc'atzina ayuno che nquelasbexa, cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ja' Jesús c'o chic pGalilea e rexbil rdiscípulo tak cawra xbij chca: —Ja Rlec'walxel jxoca alxic cuq'uin wnak arja' nja'ch na pquek'a' wnak ");
INSERT INTO tzjE_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","y neccamsaj na per prox k'ij nc'astaja, cara' nbij chca. Arj-e' congan xebisona rmal je xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tak xe'ekaja chpam tnamet Capernaum ec'ola wnak je nquemlowa impuesto je nba chpam caja rxin nimlaj templo, arj-e' xe'ekaja ruq'uin Pedro y cawra xecbij tzra: —Ja emaestro ixix ¿lnutoj c'a impuesto? ");
INSERT INTO tzjE_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Nutoj nc'a, cara' xbij Pedro chca. C'jara' xba ja' Pedro, xoca chpam jay abar c'o wa' Jesús. Ja' Jesús xk'ijlona rxin Pedro nabey mul, cawra xbij tzra: —Simón ¿nak nach'ob atet, je' reyes rxin rwech ruch'lew, nak che chca wnak necc'utuj wa' impuesto, le chca clec'wal o chca jle' chic wnak? cara' xc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Chca jle' chic wnak, cara' xbixa tzra rmal Pedro. Ja' Jesús cawra xbij chic tzra: —Ja wcara' nqueban majo'n nc'atzin tc'ara' nquetoj alc'walxela'. ");
INSERT INTO tzjE_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Com majo'n nkajo' ta nquekaban ofender rmal c'ara' tak quenbij chewa, tec'ma' ela abak rxin chapbal ch'u', jat chiya'. Tak xtcatekaja tec'ka' ela abak pya'. Jnabey ch'u' xtachap tejka' pruchi' y tzra' nawil wa' jun pak, c-e' impuesto nutoj, nutoj wxin anen y nutoj awxin atet chka'. Xtawsaj pak y najach chca ja e mloy impuesto, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jara' tiemp je' rdiscípulo Jesús arj-e' xe'ekaja ruq'uin y cawra xecc'axaj tzra: —¿Nak jun chka más nim ruk'ij chpam jgobierno rxin chcaj? cara' xecc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ja' Jesús xsiq'uij pona jun ch'tac'al y xuya' chquecjol, ");
INSERT INTO tzjE_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","y cawra xbij chca: —Ne ktzij wa' xtenbij chewa ra, we mteq'uex ena'oj, we mtquixoca ix ajni' ch'tak ac'ala' jara' nexte nquixoca chpam gobierno rxin chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Achnak nuban ch'it no'y y noca ajni' jun ac'al ja c'ara' más nim ruk'ij chpam gobierno rxin chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Je' ac'ala' ectakwra, achnak jun xtquec'ul cuq'uin jun chca j-ewra pnubi' anen, jara' nbij tzij anen quenquec'ul. ");
INSERT INTO tzjE_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Per congan lowlo' chca nak xtquechajtina j-ewra ch'tak e cocoj je ykula quec'u'x wq'uin, congan lowlo' chca mesque xjun chca nquectajchij ela che rbanic il mac. Más na mejor nxi'ma jun ca' chquekul y nquerukix ela pya' y nq'uis kaja quexla' tzra' que chwech nquectajchij jun chca je ykula quec'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Je' wnak wawe' chwech ruch'lew congan quenpoknaj quewech, congan lowlo' quebnon rmal je nquechajtixa che rbanic il mac. Cara' quenbij chewa com we ncajo' we mni ne nquechajtix wa', per congan lowlo' chca je nquechajtina cxin. ");
INSERT INTO tzjE_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Rmal c'ara' quenbij chewa, wc'ola jun ek'a' o wjun ewkan we xe nquixerchajtij y xe nquixerkasaj chpam il mac, mejor jneban tch'upuj y tch'akij ela com más na wen xjun ek'a' o we xjun ewkan nquixoca chpam utzlaj c'aslemal je rxin Dios que chwech che c-e' ek'a' ruq'uin che c-e' ewkan nquixch'akixa chpam k'ak' je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Chka' wc'ola jun ek'awech xe nquixerchajtij y nquixerkasaj chpam il mac, mejor jneban tewsaj ela y tch'akij ela. Com más na utz xjun ek'awech nquixoca chpam utzlaj c'aslemal je rxin Dios que chwech che c-e' ek'awech nquixch'akixa chpam lwar jabar nporox wa' je' chuwlaj tak achnak. ");
INSERT INTO tzjE_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kas tebna' cwent nak neban chca j-ewra e ch'tak cocoj, next jun chca xteban ta tzra com ajni' majo'n rc'atzil. Com anen quenbij chewa, je chcaj ec'ola je' ángel cxin y j-era' ángel ne nquetz'et ruplaj Nedta' tzra' chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Com anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak enpenak che cto'ic ja etzaknak. ");
INSERT INTO tzjE_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Nak nech'ob ixix tzrij jawra je xtenbij chewa ra? C'o ta jun acha ec'o ta jun cient ch'tak rcarne'l y ntzak ta jun chca. ¿Nak nuban jara' acha nech'ob ixix? ¿Lmajo'n c'ara' nqueruya' cta e noventinueve y nba ptak k'ayis che rconxic je xtza'ka? ");
INSERT INTO tzjE_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cara' nuban y anen quenbij chewa, je wnuwil jara' más na nquicota rmal que chquewech e noventinueve jmajo'n xetza'k ta. ");
INSERT INTO tzjE_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Y cara' c'a chka' tzra Edta' jc'ola chcaj, je nrajo' ranm arja' nexte c'o ta jun chca j-ewra e cocoj xtetz'ilox ta. ");
INSERT INTO tzjE_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jun chic chka', wc'ola jun awch'alal xuban jun lowlo' chawa jat ruq'uin, tyonaj ewi' ruq'uin y tech'bo' chwech jxuban chawa. We nch'obtaja rmal jnabij tzra xach'ec c'ara' awch'alal, xixchumtaj c'ara' ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","We nmesquier nch'obtaja rmal tec'ma' ela jun we c-e' awexbil, jat chic ruq'uin. Cara' naban ch-utz c'ara' je njelal je nbixa c'ola e c-e' o e oxi' testig je nquec'axana, ajni' nbij ley. ");
INSERT INTO tzjE_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","We nmajo'n rgan nuch'ob jnecbij testig tbij c'a chca iglesia. We nmajo'n rgan nuch'ob jnecbij iglesia tebna' tzra chma awexbil ta ajni' nba'na chca e mloy tak impuesto ruq'uin wnak jme rtnamet ta Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ne ktzij wa' je xtenbij chewa ra, achnak mteya' c'as tzra che nba'na wawe' chwech ruch'lew jara' majo'n nya' ta c'as tzra chcaj chka', y achnak neya' c'as tzra wawe' chwech ruch'lew jara' nya'a c'as tzra chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Jmul chic quenbij chewa, wec'ola e c-e' chewa we xjunam nquech'ob tzrij jnecc'utuj pnoración jara' oración nc'axaxa, y jnecc'utuj jara' nyataja chca rmal Nedta' jc'ola chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Cara' quenbij chewa com tak ec'ola e c-e' owe e oxi' quemlon qui' per pnubi' anen quemlon wa' qui', jara' enc'ola chquecjol. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Xpeta Pedro y cawra xc'axaj: —Wajaw, we wch'alal we nq'uiylaj mul nuban lowlo' chwa ¿ajru' mul quencuy? ¿Lnuban ra wku' mul? cara' xbij tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Cawra xbixa tzra: —Mjara' ta quenbij chawa che wku' mul jnacuy, per anen quenbij chawa wku' mul setenta nacuy. ");
INSERT INTO tzjE_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Rmal c'ara' quenbij jun c'ambal tzij chewa ra. Jgobierno rxin chcaj cara' rbanic ajni' nuban jun rey tak nerchumij quec'as je nquesmaja ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jrey tak xumaj rij cwent cuq'uin c'ola jun chca xeya'a chwech, q'uiylaj mil ctzal ruc'as c'ola ruq'uin y nmesquier neltaja. ");
INSERT INTO tzjE_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ja ajc'as com mesquier necwina nutoj ruc'as rmal c'ara' tak c'ola jun orden xuya' ja' rey y cawra xbij ra: —Jneban camic, tc'ayij ja' acha rexbil rexkayil ruq'uin je' rlec'wal chka', y njelal achnak jc'ola ruq'uin tc'ayij chka', pors ntojtaj na ruc'as, cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Je ajsmajma' arja' xexque'a chwech rey y cawra xbij tzra: —Wajaw, tec'je'a jtz'it apaciencia wq'uin, anen quentoj na njelal nuc'as, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jrey congan xpoknaj rwech ajsmajma', xsak'pij ela y xucuy ruc'as. ");
INSERT INTO tzjE_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Per jara' ajsmajma' tak xel ela chek q'uenjlal xquec'ul qui' ruq'uin jun chic ajsmajma' y c'ola ruc'as jara' ajsmajma' ruq'uin per xjun cient ruc'as. Xuchap chukul y cawra xbij tzra: —Tetjo' ac'as jc'ola wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ja' ajsmajma' xexque'a chwech y cawra xbij tzra: —Tec'je'a jtz'it apaciencia wq'uin, anen quentoj na njelal nuc'as awq'uin. Cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Per arja' majo'n xrajo' ta. C'jara' xuc'om ela, xutak pcars y xbij tzra che nutoj na nabey mul ruc'as, c'jara' nel ta pcars. ");
INSERT INTO tzjE_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jle' chic ajsmajma' tak xquetz'et je xbantaja arj-e' junwa' xquena', xeba ruq'uin rey xecbij tzra njelal je xbantaja. ");
INSERT INTO tzjE_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ja' rey xutak rsic'sic y cawra xbij tzra: —Atet at itzel ajsmajma', anen xencuy njelal ac'as jc'ola wq'uin com xac'utuj chwa chquenpoknaj awech. ");
INSERT INTO tzjE_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Nak q'ue tzra tak mxapoknaj ta rwech ajsmajma' ajni' xenban anen chawa, xenpoknaj awech? cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Congan xyictaja ryiwal rey, xujach jitzel ajsmajma' chca jle' chic wnak chnutaj pen pquek'a' y xbij tzra che tzra' nec'je' wa', tak xtutoj njelal ruc'as c'jara' nela libre. Cara' nbij jc'ambal tzij. ");
INSERT INTO tzjE_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ja' Nedta' jc'ola chcaj cara' c'a xtuban chewa ixix chka' chixjujnel we me njelal ta ec'u'x y me njelal ta ewanm nque'ecuy ewch'alal je nqueban lowlo' chewa. ");
INSERT INTO tzjE_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ja' Jesús tak xbitaj cana njelal jawra tzij rmal xel ela chpam departamento Galilea y xba chpam jun lwar chic jc'ola pjupraj binel ya' Jordán jc'ola precwent Judea. ");
INSERT INTO tzjE_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Congan e q'uiy wnak xetre' ela tzrij, xe'ekaja chpam jara' lwar y tzra' xerchumsaj wa' yuw-i'. ");
INSERT INTO tzjE_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ec'o c'a jle' fariseo xe'erkaja ruq'uin y cawra xecbij tzra, per xjic probar nqueban tzra: —Jley rxin Dios jtz'ibtanak cana rmal Moisés ¿lnuya' c'as tzra jun acha nujach cana rexkayil chka bechnak opech ril nuban ja' ixak? ");
INSERT INTO tzjE_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús cawra xbij chca: —¿Lmajo'n c'a esiq'uin ta nak cbanic wnak tak kas xewankersas ta nabey? Dios je xwankersana cxin, acha ruq'uin ixak xerwankersaj, ");
INSERT INTO tzjE_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","y cawra xbij ra: —Rmal c'ara' ja' acha nqueruya' cana redta' rute' y xjun nqueban ruq'uin rexkayil, xjun cuerpo nqueban che c-e', cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Cara' c'a rbanic, me c-e' xta, xjun chic quebnon. Com Dios xebnowa jun chca next jun c'a wnak xtejchow ta cxin. Cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Cawra xecbij chic tzra: —Wcara' nabij ¿nak tzra c'ara' xuya' jun mandamiento Moisés che ja' acha nuban jun wuj y ntz'ibaj chpam chjunlic nujach cana ixak? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Cawra xbixa chca rmal Jesús: —Com congan cwernak ewanm che rbanic itzel tak achnak rmal c'ara' tak xuya' c'as Moisés chewa che nejach cana ewexkilal. Per mcara' ta bantanak nabey mul. ");
INSERT INTO tzjE_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Anen quenbij chewa, jun acha chka bechnak acha opech wnujach cana junlic rexkayil y ja' rexkayil majo'n majcunnak ta ruq'uin jun chic acha, y wnuc'om chic jun ixak jara' adulterio nuban. Y wc'ola jun acha nuc'om jun ixak jchon cana jara' acha adulterio nuban chka'. Cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","J-e' rdiscípulo Jesús cawra xecbij tzra: —We mtya'a c'as chca ach-i' che nqueya' cana quexkilal nok más wen nara' majo'n ncatec'le' ta, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Per Jesús cawra xbij chca: —Per cara' mconjelal ta ach-i' nquecwina nqueban, per jyatanak chca che nqueban cara' xqueyon wa' j-e' nquecwina nqueban. ");
INSERT INTO tzjE_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Cara' quenbij chewa com ec'ola wnak ne pcalxic yatanak pwa' chmajo'n nec'je' ta clec'wal y rmal c'ara' chmajo'n nquec'le' ta. Y ec'o chic jle' xe echumsan chmajo'n nec'je' ta clec'wal rmal c'ara' me tyataja chquij che nquec'le'a. Ec'o chic jle', rmal samaj je nqueban precwent jgobierno rxin chcaj chmajo'n nquec'le' ta. Nak necwina nuban je c'ja' xenbij kaja chewa ra tebna' c'a, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","C'jara' ec'ol c'a jle' ac'ala' xec'mar ela ruq'uin Jesús ch-utz c'ara' nuya' ruk'a' pquewá' y nuban orar pquecwent. Per je' rdiscípulo arj-e' xecch'ojquij chca jec'amyon pa cxin ac'ala'. ");
INSERT INTO tzjE_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ja' Jesús xbij chca: —Tey-a' c'as chca ac'ala' nquepeta wq'uin y mtque'ech'ojquij ta com je' wnak je e'ocnak ajni' ch'tak ac'ala', cxin c'a arj-e' jgobierno rxin chcaj, cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Y xuya' ruk'a' pquewá' ch'tak ac'ala'. C'jara' xel ela chpam lwar. ");
INSERT INTO tzjE_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chek q'uenjlal xekaja ruq'uin Jesús jun c'jol ala' y cawra xbij tzra: —Maestro, atet at congan utzlaj acha ¿nak utzil quenban anen che nyataja chwa utzlaj c'aslemal je rxin junlic? cara' nbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—¿Nak tzra tak nabij chwa che en utzlaj acha? Xjun oca kas utz, jara' Dios. Wnawajo' che nyataja chawa utzlaj c'aslemal je rxin junlic tnimaj c'a je rmandamiento Dios, cara' xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Nak chmandamiento? cara' xc'axaj ja' c'jol. Cawra xbix chic tzra rmal Jesús: —Mtaban ta cmic, me tcatoc ta ruq'uin ixak wmawexkayil ta, mtaban ta alak', mtaya' ta testig-il wme ktzij ta, ");
INSERT INTO tzjE_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","que'animaj adta' ate'. Chka' jun chic, ajni' nawajo' kaja awi' ayon cara' c'a tebna' chca aprójimo, que'awaj-o' chka', cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Cawra xbij chic tzra Jesús: —Jala jnabij q'uen co'l na nemjon ta rbanic. ¿Le c'c'o na jmajo'n nebnon ta? cara' xbij chic tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Wnawajo' nawc'aj jun tz'katlaj c'aslemal, jnaban jat, tc'ayij cana njelal jc'ola awq'uin, je rjel tey-a' chca mibi'. Wcara' naban nyataja chawa mibil rxin chcaj. Chka' jun chic, catoca ndiscípulo y jo' catetre' ta chwij, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tak xc'axaj chcara' xbixa tzra xemloja y congan xbisona. Cara' xuban com congan jun nimlaj mibil c'ola ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","C'jara' ja' Jesús cawra xbij chca rdiscípulo: —Ne ktzitzij wa' je xtenbij chewa ra, jun byom congan pen noc wa' chpam gobierno rxin chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Jmul chic quenbij chewa, jcamello jara' jun nimlaj chcop y congan pen noc wa' pe rchak jun dsonbal bak, per majo'n kas tpen que chwech jun byom noca chpam rgobierno Dios, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","J-e' rdiscípulo tak xecc'axaj je xbixa chca cawra xecbij: —Cawra oka rbanic. Y cawra xecc'axaj tzra: —Jun byom wcongan pen noc wa' chpam rgobierno Dios ¿e achnak c'ara' nquewlowa totanem rxin Dios? cara' xecc'caxaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ja' Jesús xertz'ulchij y cawra xbij chca: —Je' wnak mesquier nquecwina xtquecsaj ta qui' queyon chpam totanem rxin Dios, per ja' Dios nmajo'n jun achnak mquita necwina nuban, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro cawra xbij tzra: —Je chka ajoj, njelal achnak jc'ola kuq'uin kay-on cana che okocnak adiscípulo y nokotren wa' chawij ¿nak nkach'ec c'ara' tzrij? cara' xc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","C'jara' ja' Jesús cawra xbij chca: —Ne ktzij wa' je xtenbij chewa ra, ixix nquixoc na ix k'toy tak tzij chpam c'ac' ruch'lew tak xtenpet chic anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak, y c'ola jun netrono quentz'be'a chwech jnec'tuwa wxin chcongan nim nuk'ij. Ixix chka' jixetrena chwij c'ola cbeljuj trono nquixetz'be'a chwech y nyataja chewa che nquixoca ix k'toy tak tzij chquij wnak ja e cbeljuj tribu rxin tnamet Israel. ");
INSERT INTO tzjE_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y je' wnak chka bechnak wnak opech wc'ola je' achnak quey-on cana ajni' cuchoch, equey-on cana quenmal, quechak', cana', o equey-on cana e quedta' quete' o quexkilal, clec'wal o quey-on cana je' culew, y nmal anen tak quey-on cana jara' más chna q'uiy nyataj na chca que chwech ajni' quey-on cana. Chka' c'ola jun herencia nyataj na chca jara' utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Xerwara' e q'uiy je' wnak jquec'mon ela bey nabey per j-era' xe nquecanaj cana pe rq'uisbal, y jec'o cana rq'uisbal arj-e' nquec'mow chic bey, com ajni' nuc'ut jc'ambal tzij je xtenbij chic chewa camic. ");
INSERT INTO tzjE_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jgobierno rxin chcaj cara' rbanic ajni' xuban jun ttixel jmul, pjun xenak'a' chanim xel ela, xba che rconxic jle' rmos che nquesmaja chpam rtejco'n. ");
INSERT INTO tzjE_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Je trat xuban cuq'uin rmos, jun ctzal nuya' chca jun k'ij. Tak xec'choja trat rmal xerutak ela chpam rtejco'n. ");
INSERT INTO tzjE_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A las nueve chlara' xel ela, xba pparque y tzra' xeruwil chwa' jle' ach-i', majo'n achnak nqueban. ");
INSERT INTO tzjE_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Cawra xbij chca: —Ixix chka' jax, quixesmaja chpam ntejco'n, anen wutkin quixentojbej, per wen quenban chewa che etojic, cara' xbij chca y xeba. ");
INSERT INTO tzjE_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ptak nc'aj k'ij lara' xel chic jmul ajni' xuban nabey mul y ncara' xuban chic. Y ptak a las tres chic xel chic jmul y ncara' xuban chic chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Je ptak a las cinco chic xel chic jmul chka' y xeruwil chic jle' ach-i', majo'n achnak nqueban y cawra xbij chca: —¿Nak tzra tak wawe' ixc'o wa' chjun k'ij, lmajo'n achnak neban? cara' xc'axaj chca. ");
INSERT INTO tzjE_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","—Com next jun nbina samaj chka, cara' xecbij tzra. —Ixix chka' jax, quixesmaja chpam ntejco'n y anen wutkin quixentojbej y nwen quenban chewa, cara' xbij chic chca. ");
INSERT INTO tzjE_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tak xoca ak'a' ja' rajaw tejco'n xbij tzra jun rmos jpa'la chquij je' mos: —Que'asiq'uij je' mos y que'atjo' ela. Jxe'erkaja q'uisbal arj-e' nque'atoj ela nabey, jxe'erkaja nabey mul arj-e' q'ue rq'uisbal nque'atoj, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jxe'erkaja q'uisbal a las cinco lara' xe'erkaja, tak xepeta jujun ctzal xya'a chca. ");
INSERT INTO tzjE_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jerkanak nabey mul, tak xepeta xquech'ob che más chna nim ntojbexa quek'ij per xjujun ctzal xya'a chca chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tak xjachtaja chca quejlal xquemaj tzij pnejkal tzrij rajaw tejco'n y cawra xecbij tzra: ");
INSERT INTO tzjE_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","—Jxe'erkaja rq'uisbal xjun hor xesmaja per xjunam xokatojbej cuq'uin, per ajoj njun k'ij xokosmaja, congan xokcosa y congan pen xkataj chwech k'ij. Cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","C'o c'a jun cawra xbixa tzra: —Amigo, anen majo'n itzel ta quenban chawa, je trat xkaban awq'uin jara' jun ctzal ak'ij. ");
INSERT INTO tzjE_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Camic tec'ma' ela awjel y jat. Anen quenwajo' jun ctzal quenya' tzra jawra acha jxerkaja q'uisbal ajni' xenya' chawa atet. ");
INSERT INTO tzjE_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Le myatanak tc'a chwij nach'ob atet achnak kas ngan quenban tzra npak? o ¿xnuk'ut ri' awanm chquij jle' chic rmal jxenban utzil chca? Cara' xbixa tzra ja' mos rmal rajaw tejco'n. ");
INSERT INTO tzjE_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Cara' c'a rbanic ajni' nbij jc'ambal tzij, ja e c'moy bey arj-e' xe nquecanaj cana pe rq'uisbal y je aj q'uisbal arj-e' nquec'mow chic bey, com e q'uiy nquesiq'uisa per xme q'uiy ta nquechataja chquecjol. Cara' xbij ja' Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ja' Jesús remjon binem, bnak pJerusalén, xecyonaj qui' cuq'uin e cbeljuj rdiscípulo y cawra xbij chca ra: ");
INSERT INTO tzjE_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Bien tewc'axaj je xtenbij chewa ra, camic okobnak pJerusalén y je Rlec'walxel jxoca alxic cuq'uin wnak tzra' ncamsas wa', nja'ch na pquek'a' cjefe sacerdote e quexbil maestro je nquetijona cxin wnak tzrij rley Dios jtz'ibtanak cana rmal Moisés. Arj-e' nquek'at tzij tzrij che ncamsasa. ");
INSERT INTO tzjE_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nquejach na pquek'a' wnak jme aj Israel ta, nqueyok' na, nquech'ay na y neccamsaj chwech jun cruz, y chrox k'ij nc'astaja rwech, cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","C'jara' xpeta rexkayil Zebedeo, quec'mon ta qui' cuq'uin ral, y xexque'a chwech Jesús. Cara' xuban com xc'ola jun achnak nrajo' nc'utuj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—¿Nak nawajo' chwa? cara' nbixa tzra rmal Jesús. —Tak xtoca agobierno, xtaya' ta jlal jun orden che j-ewra e c-e' wal, jun netz'be'a pnawejquenk'a' y jun chic netz'be'a pnawexquen, cara' xbij ja' ixak. ");
INSERT INTO tzjE_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ja' Jesús cawra xbij chca ral ixak: —Ixix majo'n ewutkin ta nak nec'utuj chwa. ¿Le nquixecwina netaj pen ajni' xtentaj anen? Com ja xtba'na chwa anen quenba'na bautizar chpam jun nimlaj lowlo'. Per ixix ¿lnecoch' nquixk'axa chpam? cara' nbij chca. —Nokocwina, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Cawra xbij chic chca: —Jara' ne ktzij wa' chnetaj na lowlo' ajni' xtentaj anen y nquixk'ax na chpam lowlo' ajni' xtenk'axa chpam anen chka'. Per jxec'utuj chwa che nquixetz'be'a pwejquenk'a' ruq'uin pwexquen jara' me wq'uin ta anen c'o wa' com jara' chumsan chic rmal Nedta' nak chu chca xtyataj wa', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Je ljuj chic discípulo tak xecc'axaj jxecc'utuj ja e c-e' ral ixak tzra Jesús arj-e' congan xpeta cyiwal chquij. ");
INSERT INTO tzjE_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ja' Jesús xersiq'uij pona y cawra xbij chca: —Ixix bien ewutkin ajni' nqueban wnak jec'ola ptak nación j-era' jc'ola gobierno pquek'a', congan nmak nquena' y nqueban chca wnak xe e ajni' cmos. Je nmak quek'ij arj-e' xcongan nquequeban mandar wnak jec'ola pquek'a'. ");
INSERT INTO tzjE_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Per chewa ixix m-utz ta cara' xteban. Per jneban, achnak jun chewa wc'ola rgan noca nim ruk'ij checjol nc'atzina che noca ilinel ewxin. ");
INSERT INTO tzjE_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Chka bechnak jun chewa c'ola rgan nja' npe'a chewech nc'atzina chja' noca emos. ");
INSERT INTO tzjE_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ajni' xuban Rlec'walxel jxoca alxic cuq'uin wnak, arja' xpeta wawe' chwech ruch'lew per me rmal ta che nilixa cmal wnak per ja' xpeta che noca jun ilinel cxin wnak. Xpeta chka' ch-utz c'ara' arja' nuya' ri' pe cmic, y jrecmic e ajni'la wnak nquerulok' chpam quil quemac. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kas nque'el ta chpam tnamet Jericó, congan chic wnak etrena tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ec'ol c'a e c-e' ach-i' e moya', etz'bula chibey. Tak xecc'axaj chJesús xk'axa tzra' arj-e' xquemaj rakic quechi' tzrij: —Kajaw, atet je at Rlec'wal rey David, tpoknaj jtz'it kawech, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Per je' wnak xquemaj rch'ajic pquewá' moya': —Xjun quixec'je' wa', mterak ta echi', cara' xbixa chca. Per arj-e' más chna xquerak quechi' tzrij Jesús: —Kajaw, atet je at Rlec'wal rey David, tpoknaj jtz'it kawech, cara' xecbij chic jmul tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ja' Jesús xpe'a, xersiq'uij pona y cawra xbij chca: —¿Nak newajo' chwa chquenban chewa? ");
INSERT INTO tzjE_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Kajaw, nkajo' che njaktaja kk'awech, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ja' Jesús xpoknaj quewech, xuchap ck'awech y njara' hor xjaktaja. Tak xjaktaja ck'awech rmal xba y arj-e' xetre' ela tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Quemjon binem ebnak, xchenkaj chic tnamet Jerusalén ec'o wa' y xe'ekaja chuchi' tnamet Betfagé abar c'o wa' jun jyu' rubi' Olivo. Ja' Jesús xerutak e c-e' chca rdiscípulo ");
INSERT INTO tzjE_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","y cawra xbij ela chca: —Jax pe tnamet, tzra' newil wa' jun ch'it bur xmila rexbil ral. Que'ecra' ta y que'ec'ma' ta. ");
INSERT INTO tzjE_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Wc'ola jun wnak xtquixertzojbej, ixix cawra nebij tzra: —Nquec'atzina tzra Kjawal, cara' tbij tzra y alnak nqueryala' ta. Cara' xbij ela Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Njelal jawra majo'n chek tcara' xbantaja, tzra' nbantaj wa' cumplir jbitanak cana rmal profeta jcawra nbij: ");
INSERT INTO tzjE_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","—Je' wnak jec'ola chpam tnamet Sion cawra tbij chca: —Tetz'ta' mpa', xpeta eRey, arja' nujach njelal pruk'a' Dios y majo'n nuya' kta ruk'ij, xe tzrij jun ch'it bur tz'bul wa'. Jch'it bur c'co'l na, ral jun bur iray ejka'n, cara' tbij chca. Cara' bitanak cana rmal profeta. ");
INSERT INTO tzjE_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","J-e' c'a rdiscípulo Jesús xeba, xequebna' je xbix ela chca. ");
INSERT INTO tzjE_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xequec'ma' ta ch'it bur rexbil ral. Jquetziak jara' xecwakbej, xetz'be'a Jesús tzrij y xumaj binem. ");
INSERT INTO tzjE_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Congan e q'uiy wnak xecsocla' quetziak prubey Jesús y ec'o chic jle' xectomla' pa ruxak tak palma y xqueya' prubey chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Je e nabyela chwech rexbil ja etren cana tzrij arj-e' congan nquerak quechi' y cawra necbij ra: —Dios ko'at-o' camic, xpeta Rlec'wal ja ojer rey David, arja' abnon bendecir, ja' Cristo jpenak pnabi' atet ja at Kajaw Dios. Ko'at-o' camic Dios jatc'ola chcaj. Cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tak xoca chpam tnamet Jerusalén xeyictaja tnamet per conjelal y cawra necbij ra: —¿Nak rbanic c'ala' jacha xerkaja? cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","—Jala Jesús je profeta ja aj Nazaret jc'ola precwent Galilea, cara' xbixa chca cmal wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ja' Jesús xoca chpam nimlaj templo rxin Dios y xumaj ta clasic conjelal jec'ola chpam jquemjon c'yinem e quexbil chka' je lk'oy tak je' achnak. Je cmes je c'xoy tak pak xch'akij ptak ulew y cara' xuban tzra chka' je' cch'acat je nquec'ayina je' tz'quin rxin pjay. ");
INSERT INTO tzjE_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Cawra xbixa chca: —Chpam rtzojbal Dios cawra tz'ibtanak chpam: —Jwuchoch anen jara' banbal oración, cara' nbij ja' Dios tzrij rtemplo, per ixix ebnon tzra xe cc'olibal elk'oma', cara' xbij ja' Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ec'ol c'a je' moya' y je' wnak e ch'e'y xe'ekaja ruq'uin Jesús chpam templo y arja' xerchumsaj. ");
INSERT INTO tzjE_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Je cjefe sacerdote e quexbil maestro je nquetijona cxin wnak tzrij rley Dios jtz'ibtanak cana rmal Moisés, arj-e' xquetz'et njelal jxuban Jesús jcongan nel ta awanm tzrij natz'et, y ec'ola jle' ac'ala' xecc'axaj chka' jquemjon rakic quechi' chpam templo, cawra necbij ra: —Dios ko'at-o' camic, xpeta Rlec'wal ja ojer rey David, cara' necbij. Y congan xpeta cyiwal rmal je xquetz'et y jxecc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Y cawra necbij chic tzra Jesús: —¿Le mtawc'axaj c'a quemjon rbixic ac'ala' chawa? cara' xecbij tzra. —Quenwc'axaj nc'a per ixix ¿lmajo'n c'a jmul esiq'uin ta jawra jtz'ibtanak cana chpam rtzojbal Dios? —Dios, je' ac'ala' e quexbil ch'tak ch'uch'a', atet ay-on pquechi' jnecyabej ak'ij y kas tz'kat nqueban tzra, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","C'jara' xeruya' cana y xba, xel ela chpam tnamet, xba pBetania y tzra' xwar wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jche rcab k'ij rxin xinak'a' xemloja Jesús chpam tnamet Jerusalén y xmajtaja rmal k'ak'nic rpam. ");
INSERT INTO tzjE_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Y xutz'et pona jun mcaj higuera, chenkaj chibey c'o wa' y xba ruq'uin. Jche' nmajo'n rwech, nruyon oca ruxak, rmal c'ara' tak cawra xbij Jesús tzra che': —Nmajo'n xtcatwachin ta rxin junlic, cara' xbij tzra y njara' hor xechkij kaja che'. ");
INSERT INTO tzjE_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","J-e' rdiscípulo congan xel ta canm tzrij je xquetz'et y cawra xecc'axaj tzra: —¿Nak tzra c'ala', ntak xechkija alnak jche'? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","—Ne ktzij wa' je xtenbij chewa ra, wc'ola yukbal ec'u'x ruq'uin Dios y wmajo'n nuban ta c-e' ec'u'x jara' nquixecwina neban ixix ajni' xenban anen tzra che'. Y mruyon ta jara' per nquixecwina chka' nebij tzra jun jyu' la che nel ela y nerec'ka' ri' pya' y ncara' nuban, nquixernimaj. ");
INSERT INTO tzjE_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Chka bechnak opech nec'utuj chpam oración we ykula ec'u'x ruq'uin Dios che rc'utxic jara' nyataja chewa, cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tak xe'ekaja chpam tnamet xoca Jesús chpam nimlaj templo rxin Dios y xumaj ctojxic wnak. Kas remjon ctojxic tak xe'ekaja cjefe sacerdote e quexbil principal-i' rxin tnamet y cawra xecc'axaj tzra: —¿Nak abanic atet tak amjon rbanic njelal jawrara jkamjon rtz'etic y nak yoyona chawa chnaban cara'? ");
INSERT INTO tzjE_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","—Anen chka' c'ola quenwajo' quenc'axaj chewa. We xtebij chwa je xtenc'axaj chewa, anen chka' quenbij chewa nak nbanic anen jnemjon rbanic njelal jawrara je emjon rtz'etic. ");
INSERT INTO tzjE_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Camic tbij chwa, je Juan Bautista ¿nak xyowa tzra jsamaj che nqueruban bautizar wnak, le Dios jc'ola chcaj xyowa tzra o wxe wnak? cara' xc'axaxa chca rmal Jesús. Arj-e' xquemaj tzij chbil tak qui': —We xtekbij tzra che Dios xyowa tzra, arja' nbij chka: —Wcara' ¿nak tzra c'ara' mxenimaj ta? cara' nbij chka ra. ");
INSERT INTO tzjE_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y we xtekbij tzra che wnak xyowa tzra jara' nachquila xtbixa chka cmal wnak com chquewech arj-e' Juan arja' jun profeta rxin Dios, cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Cawra xecbij tzra Jesús: —Majo'n kutkin ta nak xyowa tzra. —Anen chka' majo'n quenbij ta chewa nak nbanic jnemjon rbanic njelal jawrara je emjon rtz'etic. ");
INSERT INTO tzjE_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jcamic ¿nak nech'ob tzrij jawra c'ambal tzij je xtenbij chewa ra? C'ola jun acha ec'ola e c-e' rlec'wal, arja' xba ruq'uin jun rlec'wal y cawra xbij tzra: —Wlec'wal, camic jat catesmaja chpam ntejco'n, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","—Mne', majo'n ngan quenba, cara' xbij tzra redta'. Per tak xq'uisbena xti'ona ranm rmal, xuq'uex rna'oj y xba psamaj. ");
INSERT INTO tzjE_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ja' ttixel xba chic ruq'uin jun rlec'wal, ajni' xbij tzra jun chic rlec'wal nabey mul cara' xbij chic tzra jun. Y ja' rlec'wal cawra xbij tzra redta': —Utz c'ara' nedta', quenba, cara' xbij tzra per majo'n xba ta. ");
INSERT INTO tzjE_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Camic tbij chwa ¿nak chca ja e c-e' alc'walxela' xebnowa je nrajo' ranm ttixel? cara' xc'axaj Jesús chca. —Jara' je xtzijona ruq'uin nabey mul, cara' xecbij tzra. Cawra xbix chic chca rmal Jesús: —Ne ktzij wa' je xtenbij chewa ra, ja e mloy tak impuesto rexbil ixki' jlowlo' cc'aslemal arj-e' nque'oca chpam rgobierno Dios nabey mul chewech ixix. ");
INSERT INTO tzjE_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Cara' quenbij chewa com Juan Bautista arja' xpeta, xuc'ut chewech nak kas mer rbeyal rxin Dios per ixix mxenimaj ta. Per e mloy tak impuesto rexbil ixki' jlowlo' cc'aslemal arj-e' xecnimaj. Ixix mesque xetz'et chcara' xqueban per nmajo'n xti'on ta ewanm rmal jewil emac, majo'n xeq'uex ta ena'oj, nmajo'n xenimaj ta Juan. ");
INSERT INTO tzjE_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Camic tewc'axaj chic jun c'ambal tzij je xtenbij chewa ra. C'ola jun ttixel c'ola jun rchinoj, uva retcon chwech. Xuk'at rij pq'uixton, xuc'ot jun jul chpam jabar nelsax wa' j-ri'al uva. Chpam chnoj xuyic jun torre chnec'je'a chajinel per rwá'. C'jara' xuya' pe kjonem chca jle' ajsmajma' y ja' xba chpam jun tnamet c'nat. ");
INSERT INTO tzjE_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tak xe nnajin pchic tiemp je xtwachin wa' tejco'n, arja' ec'ola jle' rmos xerutak ela cuq'uin ajsmajma' ja ekajyona ulew che nequec'ma' rent. ");
INSERT INTO tzjE_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Je ekajyona ulew tak xe'ekaja mos cuq'uin xequechap, jun xquech'ay, jun xeccamsaj y jun chic xqueq'uiek tzan abaj. ");
INSERT INTO tzjE_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jrajaw chnoj arja' ec'o chic jle' rmos xerutak per más chna e q'uiy xerutak que chwech ajni' xeba nabey mul, y ajni' xba'na chca jxeba nabey mul cara' xba'n chic chca arj-e' chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Jrajaw chnoj tak xq'uisbena c'ola jun rlec'wal xutak cuq'uin y cawra xbij kaja pranm: —Com jawra wlec'wal nqueban c'a wa' respetar, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tak xekaja rlec'wal cuq'uin jekajyona ulew j-e' cawra xecbij chbil tak qui': —Jala acha noca pruk'a' julew com reherencia. Camic kcamsaj y noca pkak'a' ajoj ja reherencia, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","C'jara' xquechap, xquelsaj ta chpam chnoj y xeccamsaj. Cara' nbij jc'ambal tzij. ");
INSERT INTO tzjE_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Camic tbij c'a chwa, jrajaw chnoj tak xtpeta ¿nak nuban c'ara' chca je ekajyona chnoj nech'ob ixix? cara' xc'axaxa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","—Arja' nmajo'n npoknaj ta jtz'it quewech jitzel tak wnak jnabij la, nquercamsaj y je rchinoj nuya' chic jmul pe kjonem chca jle' chic ajsmajma' jcutkin nquetoj rent tak nerla' tiemp che nquetoj, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ja' Jesús cawra xbij chic chca: —¿Lmajo'n c'a jmul esiq'uin ta chpam rtzojbal Dios jawra tzij? —Je bnoy jay c'ola jun abaj majo'n cgan tzrij y necch'ojquij per jara' abaj csan che rbanic jay, arja' más nim ruk'ij com arja' nechpowa je' esquin-al. Jara' samaj Kajaw Dios xebnowa y kas nel ta kanm tzrij tak nkatz'et, cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Rmal c'ara' anen quenbij chewa, jgobierno rxin Dios nelsas na pnek'a' ixix y nya'a pquek'a' jun chic tnamet jcutkin nquesmajij ch-utz c'ara' necwachij na utzlaj tak achnak rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Chka bechnak wnak xjunwa' nutz'et abaj jxenbij chewa y xitzel ntzijona tzrij, jara' cara' nuban ajni' jun acha nchak'ij rkan chwech jun abaj y nk'aja. Y achnak je nk'e'ta tzij tzrij rmal abaj jxenbij chewa, jara' cara' nuban ajni' jun acha ntza'k ta jun abaj tzrij y nchicaj ri' rmal, cara' xbij ja' Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Je cjefe sacerdote e quexbil fariseo tak xecc'axaj jc'ambal tzij je xbij Jesús bien xch'obtaja cmal che j-e' xebixa. ");
INSERT INTO tzjE_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Xcajo' ta xquechap che nquecsaj pcars per xecxibej qui' chquewech wnak com wnak necbij chJesús arja' profeta rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ja' Jesús xumaj chic jmul tzij cuq'uin, xumaj chic rbixic jun c'ambal tzij chca cawrara: ");
INSERT INTO tzjE_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Jgobierno rxin chcaj cara' rbanic ajni' xuban jun rey, c'ola jun rlec'wal xec'le'a y xuban jun nimlaj nimk'ij rxin c'ulbic. ");
INSERT INTO tzjE_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Xerutak je' rmos che csic'sic wnak je erebnon chic invitar tzra nimk'ij per arj-e' majo'n xcajo' ta, majo'n cgan xepeta. ");
INSERT INTO tzjE_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ja' rey xerutak jle' chic rmos y cawra xbij ela chca: —Cawra nebij chca wnak je enebnon chic invitar tzra nimk'ij: —Quixjo'. Xencamsaj wajquex y jle' chic chcop jcongan e chak' chic, nchumsan chic w-im rxin nc'aj k'ij, cara' tbij chca, cara' xbij ela ja' rey chca. ");
INSERT INTO tzjE_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Per je' wnak je erebnon invitar, tak xe'ekaja mos cuq'uin, arj-e' majo'n xequeya' ta cas y jwer xeba wa'. Jun xba pe tz'toy rchinoj y jun chic xba chnerebna' jun rnegocio. ");
INSERT INTO tzjE_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Je jle' chic xequechap mos y nlowlo' tak tzij xecbij chca y xeccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jrey tak xekaja rbixic ruq'uin je xbantaja arja' congan xpeta ryiwal, xerutak ela rsoldado, xeccamsaj je camsanela' y xecporoj quetnamet. ");
INSERT INTO tzjE_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","C'jara' xbij chca rmos: —Xerla' hor che nba'na c'ulbic, chomtanak chic njelal. Je' wnak jxenuban invitar xmajo'n yatanak ta chca che nquepeta. ");
INSERT INTO tzjE_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jneban camic, jax ptak bey, chka bechnak wnak opech newil que'ebna' ta invitar chpam c'ulbic, cara' xbij ela chca. ");
INSERT INTO tzjE_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Xe'el ela rmos, xeba ptak bey, xequemol wnak, chka bechnak wnak opech, w-utz cc'aslemal o wmajo'n utz ta cc'aslemal. Cara' xqueban, je wnak jxeba'na invitar xenoja chpam lwar jabar nba'n wa' c'ulbic. ");
INSERT INTO tzjE_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Per tak xpeta rey che nquerutz'et wnak je erebnon invitar c'ola jun acha chquecjol mjara' ta tziak rxin c'ulbic rucsan. ");
INSERT INTO tzjE_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Cawra xbixa tzra rmal rey: —Amigo ¿nak tzra tak xatoc ta wawe' per nmajo'n acsan ta atziak rxin c'ulbic? Cara' xbixa tzra, y nmajo'n xecney ta rutzij nak nbij. ");
INSERT INTO tzjE_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ja' rey xbij chca je nque'ilina cxin invitado: —Techpa' ja' acha, texma' ruk'a' rkan y tec'ka' ela chpam nimlaj k'ejku'm. Nak xtqueba chpam jawra lwar ajni'la ok'ej xtqueban y neccach'ch'ej na rkan cak', cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Cara' rbanic com e q'uiy wnak nquesiq'uisa per xme q'uiy ta nquechataja chquecjol. Cara' jc'ambal tzij xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","J-e' c'a aj fariseo xeba, xquech'ob rij rwech nak nqueban tzra Jesús ch-utz c'ara' chc'ola jun tzij nel ta pruchi' y jara' tzij necchapbej rxin. ");
INSERT INTO tzjE_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Y xequetak ta je' cdiscípulo e quexbil jle' chic wnak jec'ola chpam partido rxin Herodes, xeba ruq'uin Jesús. Tak xe'ekaja ruq'uin cawra xecbij tzra: —Maestro, ajoj kutkin chatet nexte wjic natz'ak tzij y chka' rubey Dios amjon rc'utic chkawech y nwen naban tzra rbixic. Ajoj kutkin jatet nmajo'n abar napitz' wa' awi'com atet majo'n jun utz y majo'n jun itzel ta natz'et. ");
INSERT INTO tzjE_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Camic tbij chka nak nach'ob tzrij je xtekbij chawa ra: —Ja impuesto je nc'utuxa chka rmal César jnimlaj rey rxin Roma ¿lrubey c'ara' che nkatoj owe mrubey ta? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Per Jesús bien rutkin jlowlo' je ncajo' nqueban tzra y cawra xbij chca: —Caca' eplaj ¿nak tzra tak newajo' cneban probar? ");
INSERT INTO tzjE_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tec'tu' chenwech jun pak je ntojbexa impuesto, cara' xbij chca. Y j-e' xquec'ut jun pak chwech. ");
INSERT INTO tzjE_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","—¿Nak chuxin plaj c'ola chwech jawra pak y nak chuxin bi'aj tz'ibtanak chwech chka'? cara' xc'axaj ja' Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Rxin César, cara' xecbij tzra. —Nak je rxin César tzra César tey-a' wa', je rxin Dios tzra Dios tey-a' wa', cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Congan xel ta canm tak xecc'axaj je xbixa chca, xqueya' cana Jesús y xeba. ");
INSERT INTO tzjE_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jara' mism k'ij chka' ec'ola jle' saduceo xeba ruq'uin Jesús. J-e' saduceo majo'n necnimaj ta che nquec'astaja cnomki'. Tak xe'ekaja ruq'uin cawra xecbij tzra: ");
INSERT INTO tzjE_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, Moisés arja' rbin cana chka chpam rtzojbal Dios, wc'ola jun acha ncoma y nmajo'n jun rlec'wal nec'je' cana, per wc'ola jun ruchak' o wrenmal nc'atzina che nec'le'a ruq'uin jrexkayil jnec'je' cana. Arj-e' tak nec'je'a jun clec'wal necbij tzra ch'tac'al che rlec'wal jcamnak. ");
INSERT INTO tzjE_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Xqueban c'a jmul ec'ola e wku' alxic chkacjol, jnabey wnak xec'le'a per xcoma y nmajo'n jun rlec'wal xec'je' cana. Je rcabal xec'le'a ruq'uin ixak jxec'je' cana. ");
INSERT INTO tzjE_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ajni' xuban nabey wnak cara' xuban chic rcabal, xcam chic chwech ja' ixak, cara' xuban rox y ncara' xqueban che wku', xecoma chwech ixak, nmajo'n clec'wal xec'je' cana. ");
INSERT INTO tzjE_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tak xq'uisbena xcoma ja' ixak chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Camic ¿nak nabij tzra atet? Tak xterla' k'ij rxin che nquec'astaja chpam cmic ¿nak rechjil c'ara' ja' ixak chca e wku' alxic com xec'le'a ruq'uin che wku'? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","—Jala jnebij mrubey ta com ixix mch'obtanak ta ewmal nak kas mer nuc'ut rtzojbal Dios y nmajo'n ch'obtanak ta ewmal chka' nak rbanic rpoder Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Cara' quenbij chewa com tak nquec'astaja cnomki' jara' majo'n chic c'ulbic chquij tzra', e ajni' chic ángel rxin Dios jec'ola chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ja' Dios c'ola rbin cana chewa chpam rtzojbal tzrij c'astajic cxin cnomki' ¿lmesiq'uin tc'a? cawra rbin cana: ");
INSERT INTO tzjE_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","—Anen en Dios rxin Abraham, en Dios rxin Isaac, en Dios rxin Jacob, cara' rbin cana. Tak cara' nbij jara' nc'utbej chewech che arj-e' mesque ecamnak chic per chwech Dios ec'asla, cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","J-e' c'a wnak xecc'axaj je xbij Jesús y congan xel ta quec'u'x tzrij tijonem jnuya'. ");
INSERT INTO tzjE_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tak xekaja rbixic cuq'uin aj fariseo che xtz'apixa quechi' aj saduceo rmal Jesús arj-e' xquemol qui' y xeba ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tak xe'ekaja ruq'uin c'ola jun chca bien rtijon ri' tzrij rley Dios jtz'ibtanak cana rmal Moisés y c'ola je' achnak xc'axaj tzra Jesús che nbanbej probar rxin, cawrara xc'axaj: ");
INSERT INTO tzjE_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro ¿nak mandamiento rxin Dios jmás na nim ruk'ij chpam ley? cara' xc'axaj. Cawra xbixa tzra rmal Jesús: ");
INSERT INTO tzjE_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","—Twaj-o' Awajaw Dios tzra njelal ac'u'x, twaj-o' tzra njelal awanm y twaj-o' chka' tzra njelal ana'oj. ");
INSERT INTO tzjE_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ja c'a wa' nabey mandamiento y chka' más nim ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jrucab mandamiento xjunam ruq'uin, cawra nbij ra: —Ajni' nawajo' kaja awi' ayon atet, cara' c'a tebna' chca aprójimo que'awaj-o' chka', cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jawra c-e' mandamiento jxenbij chawa jara' kas mer ruc'u'x njelal jtz'ibtanak cana chpam ley y je njelal je ctz'iban cana je' profeta. Cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Je aj fariseo jquemlon qui' chwech Jesús cawra xc'axaj chca: ");
INSERT INTO tzjE_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Nak nech'ob ixix tzrij Cristo, nak che alc'walxel nech'ob ixix? cara' xc'axaj chca. —Rlec'wal ja ojer rey David, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús cawra xbij chic chca: —Wcara' nebij ¿nak tzra c'ara' ja' David, Wajaw nbij tzra Cristo? Jawra xbij tak xuban jmul rc'an rmal Espíritu Santo y cawra xbij ra: ");
INSERT INTO tzjE_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","—Ja' Kajaw Dios cawra xbij tzra Wajaw ra: —Catetz'be'a wawe' pwejquenk'a', wawe' ncatec'je' wa' y quenuya' na pnak'a' je nquetzelana awxin, cara' xbij tzra. Cara' rbin cana ja' David. ");
INSERT INTO tzjE_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ja' David, Wajaw nbij tzra Cristo, tbij c'a chwa camic ¿nak tzra tak nbixa tzra Cristo che rlec'wal David? cara' xc'axaj Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Next jun chca xecney ta rutzij, nmajo'n achnak xecbij tzra. Chka' jara' k'ij xquemaj ta rij chmajo'n chic achnak necc'axaj tzra com xnecxibej qui' necc'axaj chic je' achnak tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","C'jara' ja' Jesús xumaj chic tzij cuq'uin wnak y cuq'uin rdiscípulo chka', cawra xbij chca ra: ");
INSERT INTO tzjE_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Je' maestro e quexbil fariseo arj-e' yatanak chca che nquech'ob chewech jley rxin Dios jtz'ibtanak cana rmal Moisés. ");
INSERT INTO tzjE_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Wley rxin Dios nquec'ut chewech tey-a' ewexquin tzrij je njelal necbij chewa y tnimaj. Per mteban ta cara' tzra ec'aslemal ixix ajni' cc'aslemal j-e' com j-e' congan nquetzijona tzrij rley Dios per majo'n necnimaj ta je nbij. ");
INSERT INTO tzjE_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Cara' c'a quenbij chewa com je nqueban tzra jtijonem je nqueya' cara' ajni' nmak tak ejka'n necchomij y congan rejlal, congan pen rejkxic y nqueya' chquij wnak, per j-e' next c'a nquechap jtz'it ejka'n tzra rwá' quek'a'. ");
INSERT INTO tzjE_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Per jachnak nqueban xpor interés nqueban wa', je ncajo' kas utz nquetz'e'ta cmal wnak. Ajni' tzra je nqueya' chqueplaj ruq'uin chquek'a' jtz'ibtanak rtzojbal Dios chwech jara' más chna nmak nqueban tzra. Cara' nqueban tzra ch-utz c'ara' necc'utbej chquewech wnak chmás chna e utzlaj tak wnak. Y jun chic je nqueban, kas congan retz'balil ruchi' quetziak, más chna nmak tak fleco nqueya' chuchi'. ");
INSERT INTO tzjE_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ajni' tzra chka' tak nqueba'na invitar chpam nmak tak w-im congan nel ta quec'u'x tzrij je' tz'ulbal jmás nmak tak ruk'ij y cara' nqueban chka' tak nqueba ptak jay rxin molbal ri'il jabar nc'axax wa' rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ajni' tzra tak nquebina ptak q'uebal congan nel ta quec'u'x tzrij che nqueba'na saludar y tak —Maestro, Maestro, nbixa chca cmal wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Per ixix mteban ta cara' jcongan xte'l ta ec'u'x tzrij je nbixa maestro chewa com xjun ja' Maestro ewxin jara' Cristo, y ixix ix alxic ixconjelal. ");
INSERT INTO tzjE_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Com xjun Ttixel ewxin jc'ola chcaj rmal c'ara' tak quenbij chewa chka' che next jun xtbij ta Ttixel tzra jun wnak wawe' chwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Chka' mtel pta congan ec'u'x tzrij je nbixa jefe chewa com xjun Jefe ewxin jara' Cristo. ");
INSERT INTO tzjE_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jchecjol ixix, je noca ilinel ewxin jara' más nim ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nak jun xruk'ij nuya' kaja ruyon jara' nerla' na jun k'ij tak xtekaja, y achnak jun nuban ch'it co'l jara' nerla' na jun k'ij tak xtiya' na ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Per congan lowlo' chewa ixix je ix maestro rxin rley Dios jtz'ibtanak cana rmal Moisés, y chewa ixix je ix aj fariseo, caca' eplaj com ixix nquixtajina netz'apij quebey wnak chquewech ch-utz c'ara' mtque'oca chpam gobierno je rxin chcaj. Next c'a ixix ta ixocnak ta chpam y nexte neya' c'as chca wnak jc'ola cgan nque'oca chpam. ");
INSERT INTO tzjE_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Congan lowlo' chewa ixix je ix maestro y chewa ixix je ix aj fariseo, caca' eplaj com ixix kas bien k'alaj chewech tak nemaj chca melcani' tak ixki' ch'tak je' cuchoch, neban nmak tak oración per xpor interés tak neban. Rmal c'ara' tak quenbij chewa, tak xtek'a'ta tzij chewij más chna jun nimlaj lowlo' xtetaj na. ");
INSERT INTO tzjE_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Congan lowlo' chewa ixix je ix maestro y chewa ixix je ix fariseo, caca' eplaj com ixix congan necsaj echuk'a' nquixba nat nkaj che rch'aquic jun wnak che noca ewexbil chpam ereligión, per tak ewexbil chic xmás chna rlec'wal diablo noc wa' que chewech ixix rmal jtijonem neya' tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Congan lowlo' chewa com ixix ix c'moy tak bey cxin wnak per xe ix moya' com ixix cawra tijonem neya' chca: —Tak naban jun juramento, wnanataj santlaj rtemplo Dios che rbixic jara' majo'n nc'atzin ta chnaban cumplir jnatzujuj chpam juramento, per wnanataj oro jc'ola chpam santlaj templo jara' pors naban cumplir jnatzujuj, cara' tak wan nebij. ");
INSERT INTO tzjE_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ixix je ix moya', xe ix necnak tak wnak. ¿Lme wutkin tc'a jsantlaj templo jara' más chna nim ruk'ij chwech oro jc'ola chpam templo? Com j-oro we mquita chpam santlaj templo c'o wa' xjunam tara' ruq'uin chka bechnak oro. ");
INSERT INTO tzjE_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jun chic chka' jnecbij cawrara: —Wnanataj altar che rbixic jun juramento jara' majo'n kas ta nc'atzina chnaban cumplir jnatzujuj, per wnanataj ofrenda je nya'a pe rwá' altar jara' npors naban cumplir jnatzujuj, cara' tak wan nebij chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Xe ix moya', xe ix necnak tak wnak. ¿Lmajo'n c'a ewutkin ta je altar jara' más chna nim ruk'ij chwech ofrenda je nya'a pe rwá'? Com ofrenda che mquita pe rwá' altar nya' wa' xjunam tara' ruq'uin chic je' nic'aj. ");
INSERT INTO tzjE_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Rmal c'ara' anen quenbij chewa, wnanataj altar che rbixic jun juramento jara' mruyon ta altar nanataj per nrexbil ofrenda nanataj jc'ola pe rwá'. ");
INSERT INTO tzjE_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Chka' wnanataj santlaj templo che rbixic juramento jara' mruyon ta santlaj templo nanataj per nrexbil Dios nanataj jrebnon ruchoch tzra santlaj templo. ");
INSERT INTO tzjE_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Chka' wnanataj caj che rbixic jun juramento jara' mruyon ta caj nanataj per nrexbil rtz'ulibal Dios jnimlaj Rey nanataj, y chka' nrexbil Dios nanataj jnetz'be'a chwech rtz'ulibal. ");
INSERT INTO tzjE_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Congan lowlo' chewa ixix je ix maestro y chewa ixix ix aj fariseo, caca' eplaj com ixix congan necsaj echuk'a' che rya'ic eprimicia per c'c'o na más nbij rley Dios chneban jmás nc'atzina chneban per jara' majo'n ebnon ta. Congan neyke'a ewanm chneya' eprimicia, neya' jle' ichaj ajni' menta, ajni' anís y ajni' comino, per je rbeyal rxin Dios jara' majo'n ebnon ta, majo'n nepoknaj ta quewech wnak y majo'n neban ta cumplir jnetzujuj chka'. Per jara' ne nca'tzin wa' chneban cumplir y ne nc'atzina chka' chmajo'n netenba' ta rya'ic eprimicia. ");
INSERT INTO tzjE_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ixix je ix c'moy tak bey cxin wnak per xe ix moya'. Je emjon rbanic ajni' nuban jun acha remjon w-im y c'ola jun ch'it us xekaja chpam jremjon rtijic, y xekaja chpam chka' jun camello. Jara' acha xlatz'uj cana ch'it us per nmajo'n nara' xbij ta ranm che nelsaj ela jnimlaj camello, y nmajo'n xuna' ta xba chukul. ");
INSERT INTO tzjE_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Congan lowlo' chewa ixix je ix maestro y chewa ixix je ix fariseo, caca' eplaj com congan necsaj echuk'a' che rch'ajic rij tak plato y rij tak vas chka' per ptak ewanm ncara' rbanic ajni' jun vas ncongan tz'il c'ola chpam com nojnak je' achnak chpam jxewelk'an ta com ix ajmund. ");
INSERT INTO tzjE_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseos, ixix xe ix moya', kas nc'atzina neban nabey mul mtewelk'aj xta je' achnak jneya' chpam vas y chpam je' plato ch-utz c'ara' jrij ne ktzij wa' chch'ajch'oj. ");
INSERT INTO tzjE_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Lowlo' chewa ixix je ix maestro rxin ley y chewa ixix je ix fariseo, caca' eplaj com ixix ix junam ruq'uin panteón cxin cnomki' ne bien k'oman rij y ncongan wen ntz'e'ta, per xnojnak cbakil cnomki' chpam y congan rechwil. ");
INSERT INTO tzjE_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ncara' c'a ebanic ixix chka', nek'alsaj ewi' chquewech wnak chcongan ewc'an rbeyal chwech Dios per jewanm jara' nojnak rtzilal chpam che mquita cara' mquita neban caca' eplaj. ");
INSERT INTO tzjE_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Lowlo' chewa ixix je ix maestro y chewa ixix je ix fariseo, caca' eplaj com ixix neban rbanic je cpanteón e ojer tak profeta y newek je' lwar abar nquenatax wa' jle' chic wnak je xqueban rbeyal chwech Dios ");
INSERT INTO tzjE_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","y cawra nebij ra: —Je' kti't kawma' ojer arj-e' xeccamsaj je' profeta per wexte okc'ola ajoj tzra' mquita xokotre'a chquij che ccamsic, cara' nebij. ");
INSERT INTO tzjE_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tak nebij: —Kti't kawma' xecamsana je' profeta, jara' c'a nyowa testig chewij che ix calc'wal jxecamsana cxin je' profeta. ");
INSERT INTO tzjE_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Camic quenbij chewa, tec'sa' c'a rbanic jquetcon cana ewti't ewma' ojer. ");
INSERT INTO tzjE_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Congan ix itzel tak wnak, ix ajni' ix itzel tak cmetz. ¿Nak tzra xteto' ewi' jche mquita xtk'e'ta tzij chewij che nquixta'k ela pk'ak'? ");
INSERT INTO tzjE_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Rmal c'ara' tak quenbij chewa che ec'ola wnak quenutak ta checjol ajni' chca je' profeta y ajni' chca jle' chic wnak je xruyon rna'oj Dios nquecsaj y ajni' chca je' maestro. Jneban chca ixix, ec'ola chca nque'erip chwech cruz, nque'ecamsaj, y ec'ola chca nque'ech'ay ptak jay rxin molbal ri'il jabar nemol wa' ewi' che rc'axic rtzojbal Dios y nque'esaluj ela. Q'uiy tnamet nquek'ax wa' ewmal y nquixetrena chquij che nque'esaluj. ");
INSERT INTO tzjE_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Cara' xtbantaja ch-utz c'ara' chewij ixix nekaj wa' rtojic quecmic conjelal je' wnak je xqueban rbeyal chwech Dios je ecamsan ta chwech ruch'lew. Kas nabey mul Abel xcamsasa, jxuban rbeyal chwech Dios, y je xq'uisbena je xcamsasa jara' Zacarías, rlec'wal Berequías. Ja' Zacarías xcamsasa cmal ewti't ewma' y je xcamsas wa' checjol santlaj templo y altar. ");
INSERT INTO tzjE_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ne ktzij wa' je xtenbij chewa ra, njelal je c'ja' xenbij kaja chewa, je rtojic chewij ixix nkaj wa' je ix tnamet Israel. ");
INSERT INTO tzjE_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ixix je ix tnamet Jerusalén, anen congan quenbisona ewmal. Je' profeta rxin Dios xe nque'ecamsaj. Je jle' chic ajsmajma' rxin Dios je nqueta'ka ewq'uin xe nque'eq'uiek tzan abaj. Anen q'uiylaj mul xenwajo' ta xixnuto' ta ajni' nuban jun ec' nquerumol ch'tak ral xe' rpam per ixix majo'n xewajo' ta. ");
INSERT INTO tzjE_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Camic bien tewc'axaj je xtenbij chewa ra, je etnamet rexbil etemplo jc'ola chpam, jara' y-on cchic rmal Dios, lowlo' neba'n na tzra y netle' cana. ");
INSERT INTO tzjE_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cara' quenbij chewa com camic majo'n chic nutz'et ta ri' kawech ewq'uin, c'jara' nutz'et chic jmul ri' kawech ewq'uin tak xterla' k'ij tak cawra nebij chic chwa ra: —Bendecido Cristo jpenak prubi' Kajaw Dios, cara' nebij chwa. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","C'jara' xel ta Jesús chpam nimlaj templo rxin Dios, kas remjon binem tak xeki'l oca rdiscípulo ruq'uin y cawra xecbij tzra: —Tetz'ta' mpa' je' jay rxin templo, kas k'axnak wen rbanic bnon, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús cawra xbij chca: —Je emjon rtz'etic camic ixix, jala' templo nerla' na jun k'ij tak nyojtaj na njelal, per nmajo'n chic abaj xtrekla' xta ri', cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ja' Jesús tz'bula pe rwá' ch'it jyu' rbin-an Olivo y ec'ola nic'aj rdiscípulo xecyonaj qui' ruq'uin y cawra xecc'axaj tzra: —Tbij chka ¿nak k'ij nbantaja jxabij kaja chka? Chka' ¿nak rital nwankera je nc'utbej che xyamer ncatemloj pchic jmul y tak xtetz'kata tiemp je rxin rwech ruch'lew? cara' xecc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús cawra xbij chca: —Kas tebna' cwent ewi', majo'n jun xtquixebnowa engañar. ");
INSERT INTO tzjE_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Cara' quenbij chewa com e q'uiy wnak nquepe na je'a, xqueyon kaja nquecsaj qui' che e Cristo, cawra necbij chca wnak: —Anen en Cristo, cara' necbij chca y e q'uiy wnak nquequeban engañar. ");
INSERT INTO tzjE_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","C'ola nmak tak ch'oj xtba'na njelal nat nkaj per tak xtekaja rbixic ewq'uin mtexibej ta ewi' rmal com ne nc'atzin wa' che nbantaja cumplir njelal jawrara, per jara' me rq'uisbal ta rwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Cara' quenbij chewa com c'ola je' tnamet xtyictaj na tzrij jle' chic tnamet, chka' je' gobierno nyictaja tzrij jle' chic gobierno. Chka' c'ola nmak tak lowlo' xtwanker na ptak je' lwar ajni' nmak tak wyejal, nmak tak yubil y je' nmak tak cbarkan. ");
INSERT INTO tzjE_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Njelal jawrara xe nmajbexa rij nmak tak lowlo'. ");
INSERT INTO tzjE_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ixix nquixja'ch na pquek'a' wnak che nba'na lowlo' chewa y nquixcamsas na. Xitzel nquixtz'e'ta cmal wnak jec'ola chpam njelal nación per nmal anen tak cara' xtba'na chewa. ");
INSERT INTO tzjE_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chpam jara' tiemp e q'uiy wnak xtqueya' cana yukbal quec'u'x jc'ola wq'uin y ec'ola je' quexbil nquequejach pquek'a' je nquetzelana cxin, xitzel chic nquetz'et je' chbil tak qui'. ");
INSERT INTO tzjE_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Y e q'uiy wnak newanker na e profeta nbixa chca, per me ktzij ta che e profeta y e q'uiy wnak nquequeban engañar. ");
INSERT INTO tzjE_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Je rtzilal ajni'la xtba más pnim y rmal jcongan rtzilal nba'na xe rmal c'ara' tak e q'uiy wnak nq'uisa ojben ri'il jc'ola ptak canm. ");
INSERT INTO tzjE_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per conjelal je xtquecoch' quewech chpam jlowlo' y nmajo'n nqueya' cta yukbal quec'u'x wq'uin arj-e' nquewil totanem rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jutzlaj tzij jnec'mon ta tzrij gobierno rxin chcaj jara' nel na rbixic njelal nat nkaj y njelal rwech ruch'lew nekaj wa'. Njelal nekaj wa' rbixic ch-utz c'ara' necc'axaj wnak jec'ola chpam njelal nación. C'jara' xtpeta rq'uisbal rwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Rmal c'ara' quenbij chewa, kas terkaja pnewá' jbitanak cana ojer rmal profeta Daniel. Je xbij Daniel chnerla' na jun k'ij tak npeta jun jmás chna itzel ntz'e'ta rmal Dios. Tak npeta jara' npe'a chpam lwar santo y congan cmic nuban. (Je nquesiq'uina jawra tzij kas tquewsaj bien cna'oj tzrij.) ");
INSERT INTO tzjE_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jara' tak xtetz'et chpa'l chic chpam lwar santo, jneban jixc'ola chpam departamento Judea quixnanmaja, twiwaj ewi' ptak c'chelaj. ");
INSERT INTO tzjE_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jixc'ola pe rwá' terraza quixnanmaja chka', mtquixkaj pe chta ptak ewuchoch che rlisic emibil. ");
INSERT INTO tzjE_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Y jixc'ola ptak echinoj quixnanmaja chka', mtquixemloj pe chta pnewuchoch che rc'amric echquet. ");
INSERT INTO tzjE_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Anen congan quenpoknaj quewech ixki' jq'uemjana tec'je'a ch'tak cal tzra', chka' jec'ola quech'uch' chquek'a'. ");
INSERT INTO tzjE_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tc'utuj tzra Dios che me pretiemp ta tew tak xterla' k'ij che nquixnanmaja y me chpam ta xlanbal k'ij chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Cara' quenbij chewa com c'ola jun nimlaj lowlo' npe na per ncongan nim. Ajru' tiemp wankersan ta rwech ruch'lew per nmajo'n jun lowlo' penak ta más ta nim que chwech jawrara jnemjon rbixic chewa y nmajo'n chic jun xtpe xta más chta nim. ");
INSERT INTO tzjE_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Xerwara', xpajtala tiemp. Je che mquita pajtala tiemp nmajo'n wnak xtuto' ta ri' chpam. Per cmal wnak jerech-on Dios rmal c'ara' tak pajtala tiemp. ");
INSERT INTO tzjE_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Wc'ola jun xtbij chewa che: —Xpeta Cristo, wawe' c'o wa', wcara' nbij, mtenimaj ta. Owe nbij chewa: —Cala' c'o wa', wcara' nbij, chka' mtenimaj ta. ");
INSERT INTO tzjE_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Cara' quenbij chewa com ec'ola wnak nquepe na, jle' necbij che e Cristo, jle' chic necbij che e profeta rxin Dios per me ktzij ta necbij. Arj-e' c'ola nmak tak milagro xtqueban, xe jtz'it ncajo' che nquequeban engañar wnak jech-on rmal Dios per jara' mesquier xtquequech'ec ta. ");
INSERT INTO tzjE_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bien tebna' cwent ewi' chwech jawra com xenya' pona rbixic chewa. ");
INSERT INTO tzjE_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Rmal c'ara' quenbij chewa, wec'ola nquebina chewa: —Jo', xpeta Cristo, chpam jun tenlic lwar c'o wa', wcara' necbij me tquixba ta. O wnecbij chewa: —Jo', chpam jun cuarto rwiwan wa' ri', wcara' necbij mtenimaj ta chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Cara' quenbij chewa com ajni' nuban caypa', tak nuq'uiek ri' chcaj chkabar tzra' ntz'e't wa', y cara' c'a tzra Rlec'walxel jxoca alxic cuq'uin wnak tak xtpet chic jmul wawe' chwech ruch'lew, jara' majo'n che mquita xttz'e'ta njelal lwar. ");
INSERT INTO tzjE_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Je juicio npors nkaj tna ajni' nqueban c'uch, xabar tzra' c'o wa' je' camnak chcop tzra' nque'ekaj wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Chek xtk'axa njelal jawra lowlo' c'jara' majo'n chic nca'y ta rwech k'ij, noca k'ejku'm y majo'n chic chka' nca'y ta rwech ic'. Je' ch'umil nquetza'k tna y je' nmak tak poder rxin caj nsi'l na. ");
INSERT INTO tzjE_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","C'jara' c'ola jun rital nwankera chcaj, jara' rital Rlec'walxel jxoca alxic cuq'uin wnak. Je wnak jec'ola chpam njelal tnamet wawe' chwech ruch'lew arj-e' nquemaj na jun nimlaj bis, nquetz'et na je Rlec'walxel jxoca alxic cuq'uin wnak, arja' penak c'mon ta rmal jle' sutz', najni'la jun nimlaj poder c'o chic pruk'a' y congan nim chic ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","C'o c'a jun trompeta nc'axax na congan nim rukul, jara' nquertakbej ela je' r-ángel che nqueba, nque'equemlo' je' wnak jerech-on, per ne chwech njelal ruch'lew nqueba wa' che cmolic y next jun lwar mquita xtque'ekaj wa' che cmolic. ");
INSERT INTO tzjE_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Camic tewsaj c'a ena'oj tzrij jun che' higuera, jara' nc'ambej tzij chewech. Ja' higuera tak npulina ruxak c'ola ch'tak ruk'a' nwankera ruq'uin je' ruxak chka', jara' rital nuc'ut chewech che xyamer retiemp c'ten. ");
INSERT INTO tzjE_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Cara' c'a tzra chka' tak xtemaj rtz'etic njelal je c'ja' xenbij kaja chewa, jara' rital nuc'ut chewech che xchenkaj chic c'o wa' k'ij jxewc'axaj chwa, me c'nat ta c'o chwa'. ");
INSERT INTO tzjE_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ne ktzij wa' je xtenbij chewa ra, je tnamet Israel arj-e' q'uec'o na tak nbantaja cumplir njelal jawrara, majo'n chuptanak ta quewech. ");
INSERT INTO tzjE_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Jcaj ruq'uin rwech ruch'lew jara' xe nchuptaja rwech per ntzojbal anen jara' majo'n nchuptaj ta rwech, majo'n ra mquita xtbantaja cumplir. ");
INSERT INTO tzjE_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Per nmajo'n jun wnak ojtakyona kas mer k'ij y kas mer hor je xtbantaja next c'a je' ángel chka' jec'ola chcaj, xruyon Nedta' Dios ojtakyona. ");
INSERT INTO tzjE_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Xerwara', ajni' xbantaja pretiemp Noé ojer cara' c'a xtbantaj chic chka' tak xtpet chic jmul wawe' chwech ruch'lew je Rlec'walxel jxoca alxic cuq'uin wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Cara' quenbij chewa com pretiemp Noé, tak q'uemjana tpeta nimlaj k'jaljab je' wnak xe w-im elnak ta quec'u'x tzrij ruq'uin je' c'ulbic y njara' quemjon rbanic tak xoca Noé chpam barc. ");
INSERT INTO tzjE_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","J-e' c'a wnak nmajo'n xquech'ob ta jpenak chquij, c'jara' xch'obtaja cmal tak xpeta nimlaj k'jaljab chquij, congan lowlo' xba'na chca rmal ya' y xq'uis kaja quexla' conjelal. Y cara' c'a tzra chka' Rlec'walxel jxoca alxic cuq'uin wnak tak xtpet chic jmul wawe' chwech ruch'lew, c'jara' nquena' wnak tak xtpeta. ");
INSERT INTO tzjE_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tak xterla' ri' tiemp e c-e' ach-i' xjun ec'o wa' pe chnoj, jun nec'mar ela y jun ncanaj cana. ");
INSERT INTO tzjE_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chka' e c-e' ixki' xjun ec'o wa' quemjon rij c-em, jun nec'mar ela y jun ncanaj cana. ");
INSERT INTO tzjE_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Rmal c'ara' quenbij chewa, quixc'asc'ata com anen je en Ewajaw, majo'n ewutkin ta nak k'ij xtquenmloj pchic jmul. ");
INSERT INTO tzjE_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Per bien tey-a' ewexquin tzrij je xtenbij chewa ra, jun rajaw jay tak nba'na alak' ruq'uin, wext rutkin nak hor nekaja elk'om ruq'uin chak'a' jara' nechjalbej ruchoch, nc'asc'ata y majo'n nuya' ta c'as tzra elk'om che noca pruchoch. ");
INSERT INTO tzjE_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Rmal c'ara' quenbij chewa, ne nc'atzin wa' che nquixc'asc'ata ixix chka' com je Rlec'walxel jxoca alxic cuq'uin wnak arja' chek q'uenjlal xtpet chic jmul chpam hor jmajo'n ech'bon ta ixix. ");
INSERT INTO tzjE_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tech'bo' c'a bien je xtenbij chewa, je chca je' ajsmajma' ¿achnak nebnowa cumplir je nbixa chca cmal cpatrón, e achnak wen cna'oj? Ajni' tzra jun patrón tak c'ola jun ajsmajma' ruq'uin y nuya' rsamaj che npe'a chquij jle' chic ajsmajma' chneruban cwent y nuya' queway tak nc'atzina chca. ");
INSERT INTO tzjE_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ajni'la quicotemal tzra ajsmajma' remjon rij samaj jbin cana tzra tak xterkaja rpatrón ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","¿Nak nuban patrón? Jara' nnujach wa' pruk'a' njelal rmibil jc'ola ruq'uin che npe'a tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Per we ajsmajma' xitzel rna'oj y we xcawra nbij kaja pranm: —Nak lk'ij npeta npatrón, ");
INSERT INTO tzjE_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","y wnumaj cch'ayic je' ajsmajma', y wxe w-im y ruq'uin tjoj ya' nuban cuq'uin k'abrela', ");
INSERT INTO tzjE_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","wex cara' nuban nerla' na jun k'ij tak q'ue xtuna' xterkaja rpatrón y nmajo'n nak rnaben. ");
INSERT INTO tzjE_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Je ajsmajma' ajni'la jun nimlaj lowlo' xtutaj pruk'a' rpatrón y nta'k ela chpam lwar abar ec'o wa' wnak xcaca' queplaj. J-era' wnak ajni'la ok'ej xtqueban chpam jara' lwar y neccach'ch'ej na rkan cak'. ");
INSERT INTO tzjE_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Je chpam jara' tiemp jgobierno rxin chcaj cara' rbanic ajni' nqueban e ljuj k'poja'. Arj-e' com c'ola jun c'ulbic nba'na xquec'om ela ccandil che jujnel, xeba che rc'ulic acha jnec'le'a. ");
INSERT INTO tzjE_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E j-o' congan cna'oj per e j-o' chic me cara' ta. Arj-e' xmajo'n nquech'ob ta ");
INSERT INTO tzjE_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","com mq'uiy ta aceite quec'mon ela jnutaj candil chnetzje'a. ");
INSERT INTO tzjE_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Per je' k'poja' jcongan cna'oj arj-e' xquec'om ela jle' chic aceite rxin candil. ");
INSERT INTO tzjE_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Jacha jnec'le'a majo'n xpeta chanim rmal c'ara' xemajtaja rmal wram che ljuj y xewara. ");
INSERT INTO tzjE_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Per ptak nc'aj ak'a' c'ola jun kul xecc'axaj cawra nbij: —Camic xpeta jacha jnec'le'a, quixel ta trec'lu', cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Xeyictaja che ljuj k'poja', xquemaj rchumsic ccandil. ");
INSERT INTO tzjE_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","J-e' k'poja' jmajo'n q'uiy ta aceite cuq'uin arj-e' cawra xecbij chca k'poja' jcongan cna'oj: —Ntak ncoma rwech kcandil, tey-a' jle' kaceite, cara' xecbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","—Mne', mal-il majo'n xtokruban ta ajoj we tkaya' jtz'it ewxin. Jneban camic, jax abar nc'ayix wa', tzra' elk'o' wa' ewxin, cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Cara' xqueban, xeba che rlok'ic aceite. Kas ebnak tak xerkaja jacha jnec'le'a, xoca pjay jabar nba'n wa' w-im rxin c'ulbic e rexbil jec'ola list che rc'ulic y xtz'apixa chijay. ");
INSERT INTO tzjE_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Je jle' chic k'poja' jebnak arj-e' xemloj ta. Tak xe'erkaja cawra xecbij ra: —Kajaw, Kajaw, tejka' chijay chkawech, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Per cawra xbixa chca rmal acha: —Ne ktzij wa' quenbij chewa, majo'n wutkin ta ewech, cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Rmal c'ara' quenbij chewa, quixc'asc'ata com majo'n ewutkin ta nak k'ij y nak hor xtpet chic jmul Rlec'walxel jxoca alxic cuq'uin wnak. ");
INSERT INTO tzjE_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Quixc'asc'ata perc jgobierno rxin chcaj cara' rbanic ajni' xuban jun acha tak q'uemjana tba pe viaje, arja' xersiq'uij je rmos. Tak xe'ekaja ruq'uin xumaj rjachic rmibil pquek'a' jnecbanbej cana rnegocio. ");
INSERT INTO tzjE_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jun, j-o' mil ctzal xuya' cana tzra, jun chic, c-e' mil xuya' cana tzra y jun chic jun mil xuya' cana tzra. Ajni' nquecwina necsmajij xjara' xuya' cana chca che jujnel. C'jara' xba pe viaje. ");
INSERT INTO tzjE_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Je y-on cana j-o' mil ctzal tzra, arja' xba, xumaj rsamajxic pak y xuch'ec j-o' mil ctzal tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Y cara' xuban chka' je y-on c-e' mil ctzal tzra, c-e' mil xuch'ec tzrij chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Per je y-on jun mil ctzal tzra, arja' xba, xuc'ot jun jul y tzra' xwiwaj wa' pak je y-on cana tzra rmal rpatrón. ");
INSERT INTO tzjE_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tak xba jun tiemp tzra per jun tiemp nim, j-era' mos xemloj ta cpatrón y xumaj rbanic cwent cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Je y-on cana j-o' mil ctzal tzra arja' xpeta, rec'mon pchic j-o' mil ctzal y cawra xbij tzra rpatrón: —Wajaw, atet j-o' mil ctzal ay-on cana chwa, tetz'ta' mpa', xench'ec j-o' mil tzrij, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Cawra xbixa tzra rmal rpatrón: —Wen xaban tzra asamaj, atet at jun utzlaj mos, ajni'la naban cumplir asamaj. Xe mnim ta xenya' cana chawa per xaban cumplir. Camic, más chna q'uiy xtenya' chawa che nasmajij. Camic catjo', cnawexbilaj chpam quicotemal, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Je y-on c-e' mil ctzal tzra, arja' xpeta y cawra xbij tzra rpatrón: —Wajaw, atet c-e' mil ctzal ay-on chwa, tetz'ta' mpa', xench'ec c-e' mil ctzal tzrij, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Cawra xbixa tzra rmal rpatrón: —Wen xaban tzra asamaj, atet at jun utzlaj mos, ajni'la xaban cumplir asamaj. Xe mnim ta xenya' cana chawa per xaban cumplir. Camic, más chna q'uiy xtenya' chawa chnasmajij. Camic catjo', cnawexbilaj chpam quicotemal, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Chka' je y-on cana jun mil ctzal tzra, arja' xpeta y cawra xbij tzra rpatrón: —Wajaw, anen bien ch'obtanak nmal che atet at jun acha jmajo'n nawajo' ta ntz'iloxa apak y wutkin che xe ch'coj nawajo' tzrij apak per majo'n samaj naban. ");
INSERT INTO tzjE_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Rmal c'ara' xenxibej wi', je jun mil ctzal ay-on chwa, xenba xnemku' cana pnulew. Camic nec'mon ta apak ra, tec'ma' pona, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Cawra xbixa tzra rmal rpatrón: —Atet xat jun itzel mos, xa at sak'orlaj mos. Wcara' xach'ob chwij che anen xe ch'coj quenwajo' tzrij npak y majo'n samaj quenban, ");
INSERT INTO tzjE_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","jxaban ta xaya' ta pak pbanco. Wext cara' xaban, tak xenpeta anen xja'ch tc'ara' npak chwa nrexbil ral, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","C'jara' ja' patrón xbij chca jle' chic rmos: —Camic, temja' jun mil ctzal tzra y tey-a' tzra jc'ola ljuj mil ctzal ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Cara' neban tzra com je' wnak jc'ola yatanak chca y we nquesmajij jara' nyataj na más chca y tak xtq'uisbena congan nq'uiya y nuban q'uiy cuq'uin. Per je' wnak jmajo'n necsmajij ta jyatanak chca arj-e' nelsasa chca jyatanak chca. ");
INSERT INTO tzjE_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jmos necnic, techpa', tec'ka' ela chpam nimlaj k'ejku'm. Je' wnak ajni'la ok'ej xtqueban chpam jara' lwar y neccach'ch'ej na rkan cak'. Cara' xbij patrón chca. ");
INSERT INTO tzjE_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Je Rlec'walxel jxoca alxic cuq'uin wnak arja' npe chna jmul per ajni'la nim chic ruk'ij, erexbilan ta conjelal je' e santlaj tak ángel. C'jara' c'a xtetz'be'a chpam rtz'ulibal, jara' tz'ulbal rxin Rey y ajni'la nim ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Y njelal tnamet rxin rwech ruch'lew nquemo'la chwech, c'jara' nuban c-e' chca ajni' nuban jun yk'ul carne'l, junwa' nqueruya' wa' je' carne'l y junwa' nqueruya' wa' je' cabra. ");
INSERT INTO tzjE_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Je' carne'l arj-e' prejquenk'a' nqueruya' wa', je' cabra prexquen nqueruya' wa'. Cara' c'a xtuban ja' Rey. ");
INSERT INTO tzjE_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jec'ola prejquenk'a' cawra xtbij chca ra: —Ixix kas k'axnak wen bnon chewa rmal Kadta' Dios, camic quixjo' c'a, quixoca chpam gobierno je rxin chcaj, jara' herencia ewxin chomin ta ojer tak mja'na twankersasa rwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Cara' quenbij chewa com tak xenmajtaja rmal wyejal xeya' nway y tak xechkija nuchi' xeya' nuya'. Tak xenc'je'a checjol xnec'ul ptak ewuchoch mesque majo'n ewutkin ta nwech. ");
INSERT INTO tzjE_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tak lowlo' chic netziak chwij xeya' wxin chquencsaj y tak xenywaja xnerk'ijla'. Tak xenc'je'a pcars ixix xneretz'ta'. Cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jnak xqueban rbeyal chwech Dios arj-e' tak xtecc'axaj chcara' nbixa chca cawra necbij tzra: —Kajaw ¿nak k'ij xatkatz'et atmajtanak rmal wyejal y xkaya' away, o nak k'ij xatkatz'et atmajtanak rmal chkichi' y xkaya' aya'? ");
INSERT INTO tzjE_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Nak k'ij xatkatz'et jmajo'n xkutkij ta awech y xatkac'ul kuq'uin, o nak k'ij xatkatz'et nlowlo' chic atziak chawij y xkaya' awxin che xacsaj? ");
INSERT INTO tzjE_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Nak k'ij xatkatz'et at yawa' o atc'ola pcars y xatkk'ijla'? Cara' xtecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ja' Rey cawra xtbij chic chca: —Ne ktzij wa' je xtenbij chewa ra, tak xeto' jun chca ch'tak wch'alal, anen c'ara' xneto'. Cara' xtbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jec'ola prexquen cawra xtbij chca: —Ixix jxitzel ixetz'ton rmal Dios quixel ela chenwech. Camic nquixba chpam k'ak', jara' k'ak' rxin junlic y xe rmal diablo chumin ta che nta'k ela arja' chpam e rexbil je' r-ángel. ");
INSERT INTO tzjE_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Camic, quixel ela chenwech, com tak xenmajtaja rmal wyejal mxeya' ta nway, tak xechkija nuchi' mxeya' ta nuya'. ");
INSERT INTO tzjE_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tak xenc'je'a checjol majo'n ewutkin ta nwech y majo'n xnec'ul ta ptak ewuchoch. Tak lowlo' chic netziak chwij majo'n xeya' ta wxin chxencsaj. Tak xenywaja y tak xenc'je'a pcars majo'n xnerk'ijla' ta. Cara' nbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Arj-e' tak necc'axaj chcara' nbixa chca cawra necc'axaj tzra: —Kajaw ¿nak k'ij xatkatz'et atmajtanak rmal wyejal, o rmal chkichi', o atc'ola chkacjol, o lowlo' chic atziak chawij, o at yawa', o atc'ola pcars, y majo'n xatkato' ta? Cara' xtecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Arja' cawra nbij chic chca: —Ne ktzij wa' je xtenbij chewa ra, tak majo'n xeto' ta jun chca e ch'tak wch'alal, anen c'ara' jmajo'n xneto' ta. Cara' xtbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Arj-e' nqueba na chpam lowlo' je rxin junlic per je xqueban rbeyal chwech Dios arj-e' nqueba na chpam utzlaj c'aslemal je rxin junlic. Cara' xbij Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tak xbitaja njelal jawra tzij rmal Jesús c'jara' cawra xbij chic chca rdiscípulo: ");
INSERT INTO tzjE_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Ixix ewutkin xe c-e' k'ij chic nrajo' je nc'u'la nimk'ij pascua, y anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak quenja'ch na pquek'a' je nquetzelana wxin chquenri'pa chwech cruz, cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Je cjefe sacerdote e quexbil maestro je nquetijona cxin wnak tzrij rley Dios e quexbil chka' principal-i' rxin tnamet arj-e' xequemlo' qui' chwech nimlaj jay rxin Caifás jnimlaj sacerdote. ");
INSERT INTO tzjE_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Xquemaj rconxic rij rwech nak nqueban tzra Jesús che nquechap pnejkal y neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Per cara' necbij ra: —Me chpam ta nimk'ij nkachap wa' perc xmal-il nqueyictaja wnak rmal, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús arja' c'ola chpam tnamet Betania pruchoch jun acha Simón rubi' je rc'an yubil lepra ojer. ");
INSERT INTO tzjE_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ja' Jesús tz'bula tzrij mes tak xpona jun ixak ruq'uin rec'mon ela jle' ak'om qui' rexla' y congan nim rejlal, rec'mon ela chpam jun rc'olibal je bnon rbanic, alabastro ocnak. Ja' ixak tak xekaja ruq'uin Jesús xuya' jara' ak'om pe rwá'. ");
INSERT INTO tzjE_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Per je rdiscípulo arj-e' junwa' xquetz'et jxuban ixak: —¿Nak tzra tak xtz'ila' ak'om? ");
INSERT INTO tzjE_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kas tkala xba'n ta tzra xc'ayix ta, congan q'uiy ta pak xuya', je rjel xya' ta chca mibi'. Cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ja' Jesús rutkin bien jquemjon rbixic y cawra xbij chca: —¿Nak tzra tak nenak ixak? Jawra jxuban chwa congan wen. ");
INSERT INTO tzjE_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Je' ch'tak mibi' arj-e' nec'ol wa' checjol wc'ola egan neban utzil chca per chwa anen majo'n quenc'je' ta ewq'uin njelal tiemp, quenlsas na checjol. ");
INSERT INTO tzjE_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Arja' tak xuya' ak'om chwij jara' nchumsbej pona nbakil che nmu'ka. ");
INSERT INTO tzjE_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ne ktzij wa' je xtenbij chewa, jawra utzlaj tzij jnec'mon ta, xabar tzra' xtekaj wa' rbixic njelal nat nkaj chwech ruch'lew tzra' nnatax wa' utzil jxuban chwa jawra ixak, jara' nnatbexa rxin. Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","C'jara' c'ola jun chca ja e cbeljuj discípulo, Judas Iscariote rubi', arja' xba cuq'uin cjefe sacerdote. ");
INSERT INTO tzjE_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tak xekaja cuq'uin cawra xbij chca: —¿Nak neya' chwa quenjach pnek'a' Jesús? cara' xbij chca. Y xjuwnak ljuj rkan pak plat ocnak jxecchumbej ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ja' Judas jara' hor xumaj rconxic nak nuban tzra Jesús chnujach pquek'a'. ");
INSERT INTO tzjE_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tak xerla' nabey k'ij rxin nimk'ij tak nti'ja xquelway jmajo'n levadura ruq'uin, xe'ekaja rdiscípulo ruq'uin ja' Jesús y cawra xecbij tzra: —Je xtataj rxin nimk'ij pascua tbij chka abar tzra' xtekchumij wa', cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Cawra xbix ela chca rmal Jesús: —Jax chpam tnamet Jerusalén. Tzra' c'o wa' jun acha, nquixba ruq'uin y cawra nebij tzra: —Ja' Maestro cawra rbin ta: —Xyamer nerla' tiemp chquencamsasa. Je w-im rxin nimk'ij pascua, pnawuchoch nkaban wa' e wexbil ndiscípulo. Cara' rbin ta chka, cara' tbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","J-e' discípulo cara' xqueban ajni' xbix ela chca rmal Jesús, xeba xecchumij w-im je rxin nimk'ij pascua. ");
INSERT INTO tzjE_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tak xoca ak'a' xetz'be'a Jesús tzrij mes e rexbil e cbeljuj rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kas quemjon w-im tak cawra xbij chca: —Ne ktzij wa' je xtenbij chewa, c'ola jun chewa jquenrujach na pquek'a' je nquetzelana wxin, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Arj-e', tak xecc'axaj je xbixa chca xquemaj jun nimlaj bis: —¿Mex c'a anen Wajaw, mex anen Wajaw? Cara' xecbij tzra che jujnel. ");
INSERT INTO tzjE_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Cawra xbixa chca rmal Jesús: —Ja acha jwexbil tzra w-im y xjun plat nokwa' wa' ruq'uin, ja' c'ara' nejchowa wxin pquek'a'. ");
INSERT INTO tzjE_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Je Rlec'walxel jxoca alxic cuq'uin wnak arja' ncamsas na ajni' tz'ibtanak cana tzrij chpam rtzojbal Dios, per ncongan lowlo' tzra je xtejchowa rxin pquek'a' je nquecamsana rxin, utz tc'ara' per che mquita Alc'walxel jxoca alxic cuq'uin wnak. Je xtejchowa rxin utz ta mquita xalexa chwech ruch'lew. Cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas cawra xbij tzra: —Maestro ¿mex anen? —Atet nc'a, cara' xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tak quemjon w-im ja' Jesús xuc'om xquelway, xmeltioxij tzra Dios, xuwech' y xujach chca rdiscípulo y cawra xbij chca: —Ja c'a wa' necuerpo, tec'ma' y tetja', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Y xuc'om chic jun cop vino, xmeltioxij tzra Dios y xujach chca chka' y cawra xbij chca: —Tetja' ixconjelal. ");
INSERT INTO tzjE_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Com jawra vivo ja c'a wa' necq'uiel jara' rseguro jc'ac'laj chuminem je rchumin Dios. Jnecq'uiel e q'uiy wnak nti'x na pquecwent ch-utz c'ara' ncuytaja quil quemac. ");
INSERT INTO tzjE_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Anen quenbij chewa camic, jawra ri'al uva majo'n chic quentaj xta wawe', c'jara' xtentaj chic tak xterla' k'ij che nkataj chic ewq'uin chpam gobierno rxin Nedta' Dios xerwara' c'ac' chic njelal tzra', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","C'ol c'a jun bix rxin nimk'ij pascua xecbixaj. Tak xec'choja bix cmal xe'el ela, xeba chpam jun lwar rubi' jyu' rxin Olivo. ");
INSERT INTO tzjE_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús cawra xbij chca: —Rmal je xtba'na chwa chpam jawra chak'a' ixix cneya' cana, nquixnanmaja ixconjelal. Cara' quenbij chewa com tz'ibtanak cana chpam rtzojbal Dios cawrara: —Anen xtencamsaj je yk'ul cxin ch'tak carne'l je erebnon cwent y arj-e' necpaxla' qui'. Cara' tz'ibtanak cana. ");
INSERT INTO tzjE_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Per tak xtc'astaja nwech quenabyej chna chewech, quenba na chpam departamento Galilea, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro cawra xbij tzra: —Mesque conjelal xtcatqueya' cana per chwa anen jara' majo'n catnuya' cta, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Cawra xbixa tzra rmal Jesús: —Ne ktzij wa' je xtenbij chawa, chpam jawra chak'a' tak q'uemjana tetrekena pre'y, oxmul abin chic chwa cawrara: —Anen majo'n wutkin ta rwech Jesús, cara' nabij chwa, cara' xbixa tzra Pedro. ");
INSERT INTO tzjE_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Mesque nok c-e' awq'uin xtokcamsasa per nmajo'n catnuya' cta, cara' xbij ja' Pedro tzra. Y conjelal rdiscípulo cara' xecbij tzra chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","C'jara' ja' Jesús xerexbilaj ela rdiscípulo, xeba chpam jun lwar Getsemaní rubi'. Tak xe'ekaja cawra xbij chca: —Quixetz'be' cana wawe' ra', anen cnebna' pekna oración calala, cara' xbij cana chca. ");
INSERT INTO tzjE_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Per xeruc'om ela Pedro e rexbil e c-e' rlec'wal Zebedeo. C'jara' xumaj jun nimlaj bis y xumaj t-onem ranm. ");
INSERT INTO tzjE_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Y cawra xbij chca: —Camic, congan nbisona wanm, jquena' kaja anen cmic rec'mon ta chwa. Ixix quixec'je' cana wawe', quixc'asc'ata wq'uin, cara' xbij cana chca. ");
INSERT INTO tzjE_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","C'jara' jwer xyonaj pon wa' ri' ruyon, xexque'a y xumaj rbanic oración: —Nedta', anen c'ola quenwajo' quenc'utuj chawa. Wnuc'om ri' ruq'uin jachomin ta chwij mquita quenk'axa chpam jawra poknal jpenak chenwech xerwara' quenk'ax nc'ara' chpam wcara' nrajo' awanm, cara' xbij tzra Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tak xec'choja oración rmal xba cuq'uin rdiscípulo. Tak xeruwla' ekanak chuwram. Cawra xbij tzra Pedro: —¿Le mtecoch' nquixc'asc'ata jun hor wq'uin? ");
INSERT INTO tzjE_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","—Quixc'asc'ata y tebna' oración ch-utz c'ara' Satanás tak xtquixrchajtij mquita xtquixruch'ec. Jewanm jara' ne ktzij wa' chc'ola rgan nc'asc'ata per com xa ix wnak ecuerpo npoknaj nuban cara', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","C'jara' xemloj chic jmul che rbanic oración: —Nedta', wmajo'n jun rbeyal che mquita xquenk'axa chpam rpoknal, xtbantaj tc'a achnak nrajo' awanm atet, cara' xbij chic tzra Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Xemloj pchic jmul cuq'uin y tak xeruwla' ewarnak chic chka'. Cara' quebnon com congan jun nimlaj wram emajyona, mesquier xquecoch' ta. ");
INSERT INTO tzjE_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Y xemloj chic jmul chka' che rbanic oración y cara' xbij chic ajni' rbin chic chpam oración. ");
INSERT INTO tzjE_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","C'jara' xemloj pchic jmul cuq'uin rdiscípulo y cawra xbij chca: —Camic quixwar c'a, quixexla'n c'a. Tewc'axaj bien che xerla' hor, je Rlec'walxel jxoca alxic cuq'uin wnak, camic nja'cha pquek'a' je aj il aj mac che neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jo' quixyictaja, jo' que'ekac'lu'. Tetz'ta' mpa', xyamer nerkaja jnejchowa wxin pquek'a'. ");
INSERT INTO tzjE_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kas remjon na tzij Jesús cuq'uin rdiscípulo tak xpeta Judas. Jara' Judas jun chca ja e cbeljuj apóstol. Arja' e q'uiy wnak erexbilan ta y c'ola je' achnak rxin banbal ch'oj quec'mon ta ajni' espada ruq'uin je' che', etkon ta cmal cjefe sacerdote y cmal principal-i' rxin tnamet che necrechpa' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ja' Judas jnejchowa rxin Jesús arja' rchumin ta cuq'uin wnak nak xtuban tzra Jesús che njachbej pquek'a': —Tak xtetz'et acha je xtentz'ubaj ruchi' chewech, jara' c'a techpa'. Cara' rchumsan ta cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Xba c'a alnak Judas ruq'uin Jesús, tak xekaja chwech xk'ijla': —Xoc ak'a' Maestro, cara' xbij y xtz'ubaj ruchi'. ");
INSERT INTO tzjE_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús cawra xbij tzra: —Amigo ¿nak narebna' wawe'? cara' xbij tzra. C'jara' je' wnak xeba tzrij Jesús, xquechap y xquecsaj preso. ");
INSERT INTO tzjE_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","C'ol c'a jun chca rexbil Jesús chek q'uenjlal tak xelsaj jun espada y c'ola jun mos rxin nimlaj sacerdote xusoc tzan espada y xch'upuj ela jun rexquin. ");
INSERT INTO tzjE_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús cawra xbij tzra: —Tecsaj awespada chpam rc'olibal com nak xtecsana espada, tzan espada ncamsbex wa' chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Lmajo'n c'a ewutkin ta che anen wexte c'ola ngan quenc'utuj nto'ic tzra Nedta' Dios arja' chanim nquerutak ta jle' ángel che nto'ic? Per congan e q'uiy nquerutak ta, e ajni' e cbeljuj ejército soldado je nquerutak ta. ");
INSERT INTO tzjE_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Per che mquita quenk'axa chpam ja enc'o wa' camic majo'n c'ara' nbantaj ta cumplir jtz'ibtanak cana chpam rtzojbal Dios che nc'atzina quenk'ax na chpam, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jara' hor ja' Jesús cawra xc'axaj chca wnak: —¿Le en elk'om anen rmal c'ara' tak ec'mon ta espada ec'mon ta che' chwij che nchapic? Per xenc'je' wan chpam nimlaj templo rxin Dios y k'ij k'ij xentijoj wnak chpam per majo'n wan xnechap ta tzra'. ");
INSERT INTO tzjE_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Per njelal jawra majo'n chek ta xbantaja, rmal che nbantaja cumplir jtz'ibtanak cana chwij ojer cmal ja e ojer tak profeta rxin Dios, cara' nbij chca. C'jara' je' rdiscípulo xqueya' cana y xenanmaj ela. ");
INSERT INTO tzjE_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Je' wnak jxechpowa rxin Jesús arj-e' xquec'om ela chwech Caifás jnimlaj sacerdote. Tzra' quemlon wa' qui' je' maestro je nquetijona cxin wnak tzrij rley Dios jtz'ibtanak cana rmal Moisés e quexbil principal-i' rxin tnamet. ");
INSERT INTO tzjE_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ja' Pedro rtreben Jesús per q'ue c'nat nutzu' pon wa'. Arja' xekaja abar c'o wa' jnimlaj jay rxin nimlaj sacerdote, xoc oca chujay y xetz'be'a cuq'uin policía, nrajo' nutz'et nak xtbantaja. ");
INSERT INTO tzjE_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Je cjefe sacerdote e quexbil principal-i' rxin tnamet e quexbil chka' jle' chic jec'ola chpam k'atbaltzij cxin aj Israel, arj-e' xquemaj rconxic jle' wnak che nqueya' testig-il tzrij Jesús per xe tz'koj tak tzij je xtecbij tzra. Cara' xqueban ch-utz c'ara' nkaja cmic tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Per nmajo'n achnak necchapbej Jesús mesque e q'uiy testigo ja e tz'koy tak tzij. Tak xq'uisbena ec'ola e c-e' testigo ja e tz'koy tzij ");
INSERT INTO tzjE_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","cawra xecbij ra: —Jala' acha rbin che necwina nuyoj santlaj rtemplo Dios per xe oxi' k'ij nrajo' chnuyic chic jmul, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jnimlaj sacerdote arja' xpe'a y cawra xbij tzra Jesús: —¿Le mtac'ulba' c'a je xbixa chawa? Camic, tbij c'a chwa nak rbanic testig-il je xya'a chawij cmal j-ela' ach-i', cara' xc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Per Jesús majo'n xc'ulba' ta je xc'axaxa tzra. Cawra xc'axax chic tzra rmal nimlaj sacerdote: —Chwech c'aslic Dios tbij wa' chka ¿le atet at Cristo je Rlec'wal Dios? ");
INSERT INTO tzjE_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús cawra xbij tzra: —Cara' nc'a ajni' nabij la'. Y bien tewc'axaj je xtenbij chewa ra, camic nemaj ela rtz'etic je xtuban Rlec'walxel jxoca alxic cuq'uin wnak, arja' prejquenk'a' Dios netz'be' wa' jabar c'o wa' nimlaj poder rxin y netz'et chka' tak xtpet chic jmul c'mon ta rmal jle' sutz' rxin chcaj, cara' nbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jnimlaj sacerdote c'ola jun tziak recsan xurak com xitzel xc'axaj je xbixa tzra rmal Jesús y cawra xbij chca jquemlon qui' ruq'uin: —Jala je xbij xitzel nc'axaxa rmal Dios com ne njumsaj ri' ruq'uin. Camic, majo'n chic nquec'atzin ta más testig com bien xewc'axaj je xbij, congan itzel nc'axaxa rmal Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Camic ¿nak nebij ixix tzra? cara' nbij chca. —Majo'n achnak, ne nyataj wa' tzrij che ncamsasa, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","C'jara' xecchubaj ruplaj, xquech'ay, y ec'ola nic'aj xqueya' k'a' chuplaj. ");
INSERT INTO tzjE_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Cawra xecbij ra: —Cristo, tbij c'a chka camic ¿nak xyowa k'a' chaplaj? Cara' xecbij tzra per xyok'bal rxin xqueban. ");
INSERT INTO tzjE_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro arja' tz'bula chijay, c'ol c'a jun aj ic' xekaja ruq'uin, cawra xbij tzra: —Atet jun chka' xawexbilaj Jesús je aj Galilea, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Per ja' Pedro majo'n xuya' ta tzrij je xbixa tzra, cawra xbij chca per ne chquewech conjelal: —Anen majo'n wutkin ta jnabij la, cara' xbij tzra ixak. ");
INSERT INTO tzjE_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Xyictaja, xba abar c'o wa' chijay per c'o chic jun aj ic' xetz'towa rxin y xbij chca jec'ola tzra': —Jawra acha arja' rexbil Jesús je aj Nazaret, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Per ja' Pedro majo'n xuya' ta tzrij je xbixa tzra: —Chwech Dios quenbij che anen majo'n wutkin ta rwech Jesús jnabij la, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","C'aj co'l kaja tak ec'ola jle' wnak jec'ola tzra' xe'ekaja ruq'uin y cawra xecbij tzra: —Bien k'alaj che atet at quexbil aj Galilea jxerexbilaj Jesús com atzij nec'tuwa awxin, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","—Chwech Dios quenbij wa' chewa che anen majo'n wutkin ta rwech Jesús y itzel ta xquenrutzu' Dios wme ktzij ta quenbij, cara' xbij ja' Pedro chca. Chek xbitaja tzij rmal xtrekena pre'y. ");
INSERT INTO tzjE_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","C'jara' xerkaja pe rwá' Pedro jbin tzra rmal Jesús jcawrara: —Tak q'uemjana tetrekena pre'y, oxmul abin chwa: —Anen majo'n wutkin ta rwech Jesús, cara' nabij chwa. C'jara' xel ta Pedro y congan jun nimlaj bis ok'ej nuban. ");
INSERT INTO tzjE_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tak xeskara, conjelal cjefe sacerdote e quexbil principal-i' rxin tnamet arj-e' xquemaj rch'obic nak nqueban tzra Jesús che neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Xquexim ela, xeba xequejcha' pruk'a' Poncio Pilato jgobernador. ");
INSERT INTO tzjE_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas je xejchowa rxin Jesús pquek'a' je nquetzelana rxin arja' tak xutz'et che ncamsasa Jesús congan xumaj t-onem ranm. Xba xermeloj juwnak ljuj rkan pak plata ocnak, xermeloj pquek'a' cjefe sacerdote y principal-i' rxin tnamet. ");
INSERT INTO tzjE_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tak xe'ekaja cuq'uin cawra xbij chca ra: —Camic xenban jun il mac, xenjach pe cmic jun acha jmajo'n ril, cara' xbij. —Jala jnabij, ajoj majo'n achnak nekbij tzra, kas atet wala' nak kas xtaban ruq'uin, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","C'jara' ja' Judas xch'akij oca pak chpam santlaj templo, xel ela y xba xjitz'aj kaja rukul ruyon. ");
INSERT INTO tzjE_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Je cjefe sacerdote arj-e' xquemol pak y cawra xecbij ra: —Jawra pak rjel quic' rmal c'ara' xjan xtba ta chpam caj rxin templo, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Y xquemaj rch'obic nak nqueban tzra pak. Tak xch'obtaja cmal xquelok' jun ulew tzra jun acha bnoy bjo'y. Jxoc wa' jara' ulew, tak nquecoma je' wnak jepenak chpam chic jle' tnamet, chpam nquemu'k wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Rmal c'ara' xbixa tzra jara' ulew rjel quic', y ncara' nbixa tzra camic chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tzra' xbantaj wa' cumplir jtzij jbitanak cana rmal ja ojer profeta Jeremías jcawrara nbij: —Y xquec'om treinta rkan pak plata ocnak je xjara' rjel xqueya' aj Israel ");
INSERT INTO tzjE_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","che xeclok'bej jun ulew tzra jun bnoy bjo'y ajni' bin chwa anen rmal Kajaw Dios. ");
INSERT INTO tzjE_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ja' Jesús arja' pa'la chwech Pilato jgobernador y cawra xbixa tzra: —¿La atet at rey cxin tnamet Israel? cara' xc'axaxa tzra. —Cara' nc'a ajni' xabij kaja. Cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Per cjefe sacerdote e quexbil principal-i' rxin tnamet arj-e' tak xquemaj rbixic jril Jesús per arja' nmajo'n achnak xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","C'jara' cawra xbij Pilato tzra: —¿Lnawc'axaj c'a jnecbij chawa, congan awil necbij? cara' nbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per Jesús next jun tzij xbij, nmajo'n xc'ulba' ta. Ja' Pilato congan xel ta ranm tak xutz'et jxuban. ");
INSERT INTO tzjE_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jgobernador ne c'mannak wa' tzra chc'ola jun preso nsak'pij ptak nimk'ij pascua per nuya' c'as chca tnamet che arj-e' nec'utuna nak preso nsak'pij ela. ");
INSERT INTO tzjE_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jara' tiemp c'ola jun preso Barrabás rubi', njelal jrebnon bnak rbixic nat nkaj. ");
INSERT INTO tzjE_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ja' Pilato tak quemlon chic qui' wnak cawra xc'axaj chca: —¿Nak newajo' ixix, Barrabás nsak'pix ela o Jesús je Cristo nbixa tzra? cara' xc'axaj chca. ");
INSERT INTO tzjE_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Cara' xc'axaj chca com arja' bien rutkin che congan nk'utluja canm tzrij Jesús y xe rmal jcongan nk'utluja canm tak quejchon pruk'a'. ");
INSERT INTO tzjE_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ja' Pilato tz'bula chpam lwar jabar nuk'at wa' tzij tak chek q'uenjlal xta'ka rbixic jle' tzij tzra rmal rexkayil cawrara: —Mtacsaj ta awi' atet che rcamsic acha, arja' jun acha jrebnon rbeyal. Mtacsaj ta awi' com ja' acha la xenwechc'aj camic y jachic' congan lowlo' xuban chwa. Cara' tkon ela rbixic tzra rmal rexkayil. ");
INSERT INTO tzjE_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per cjefe sacerdote e quexbil principal-i' rxin tnamet arj-e' xecbij chca wnak che necc'utuj Barrabás che nsak'pix ela y Jesús ncamsasa. ");
INSERT INTO tzjE_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jgobernador cawra xc'axaj chic jmul chca: —¿Nak newajo' ixix, nak chca e c-e' ach-i' wra quensak'pij ela? cara' xc'axaj chca. —Barrabás tsak'pij ela, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Wcara' newajo' ¿nak c'a quenban tzra Jesús je Cristo nbixa tzra? cara' xbij ja' Pilato. —Tcamsaj chwech cruz, cara' xecbij conjelal. ");
INSERT INTO tzjE_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Nak tzra, nak c'a lowlo' rebnon? cara' xc'axaj chic Pilato chca. Per arj-e' más xquemaj rakic quechi': —Tcamsaj chwech cruz, cara' xecbij chic jmul tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ja' Pilato xerutz'et wnak chmajo'n ncajo' ta je nbij ja' chca che nsak'pix ela Jesús y xerutz'et chkajni' xeyictaja más. C'jara' xuc'om jle' ya' y xuch'aj ruk'a' chquewech y cawra xbij chca: —Anen mnuma'c ta we ncamsasa jala acha com majo'n ril, ixix c'ara' nak xteban tzra, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","—Ajoj nokejklena recmic ruq'uin je' ch'tak klec'wal chka', cara' xecbij conjelal. ");
INSERT INTO tzjE_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ja' Pilato xuya' c'as chca je ncajo', xsak'pij Barrabás y xuya' orden che nch'aya Jesús. Tak xch'aytaja xujach pquek'a' je nquec'mow ela rxin che ncamsasa chwech cruz. ");
INSERT INTO tzjE_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","C'jara' je' soldado rxin gobernador, arj-e' xquec'om ela Jesús chpam jay abar nec'je' wa' gobernador y xequemol conjelal jle' chic soldado chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xquejal retziak Jesús y xquecsaj chic jun quiek tziak tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Xecchumij jun corona, q'uix xquecsaj y xqueya' pe rwá', y xqueya' jun aj pruk'a' ja rejquenk'a'. Xexque'a chwech y nqueya' rsaludo ajni' nba'na tzra jun rey tak nba'na saludar per xyok'bal rxin nqueban. —Atet at rey cxin tnamet Israel, cara' necbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Xecchubaj, xquemaj aj tzra y xecwak'la' rwá' tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tak xyok'taja cmal c'jara' xquejal retziak quiek y xquecsaj chic jretziak ja'. C'jara' xquec'om ela che nequerpa' chwech cruz. ");
INSERT INTO tzjE_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tak xeba c'ola jun acha xquewil aj Cirene, Simón rubi', npors xqueban tzra chnejkaj ela cruz rxin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Xeba pjun lwar rbin-an Gólgota. Gólgota nbij tzij lwar rxin rwá' comnak. ");
INSERT INTO tzjE_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tak xe'ekaja chpam lwar Gólgota xectzujuj vino tzra chnutaj. Jvino c'ola nic'aj achnak congan q'uey yjun ruq'uin. Ja' Jesús tak xuna' chq'uey majo'n xutaj ta. ");
INSERT INTO tzjE_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tak xriptaja cmal chwech cruz xquemaj rbanic suert tzrij retziak nak kas xtech'cowa chca y nquejach chquewech. Cara' xbantaja ch-utz c'ara' tzra' nbantaj wa' cumplir jbitanak cana rmal profeta jcawrara nbij: —Xqueban suert tzrij netziak y xquejach chquewech, cara' bitanak cana ojer. ");
INSERT INTO tzjE_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","C'jara' xetz'be'a y xquemaj rchajic Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Xtz'ibaxa ril je nbixa tzra y pe rwá' recruz xqueya' wa', cawra ril xqueya': —Jawra Jesús, arja' rey cxin tnamet Israel, cara' xectz'ibaj. ");
INSERT INTO tzjE_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ec'ol c'a e c-e' elk'oma' xeri'pa chwech cruz chka', jun prejquenk'a' Jesús y jun prexquen. ");
INSERT INTO tzjE_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Je' wnak tak nquek'axa y tak nquetz'et cana Jesús xnectzebej y xe nqueyok' y cawra necbij tzra: ");
INSERT INTO tzjE_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Atet xatbina chnatur santlaj rtemplo Dios y xe oxi' k'ij nrajo' chnayic chic jmul, camic tet-o' c'a awi' ayon. We ktzij che atet at rlec'wal Dios catkaj pc'a chwech cruz, cara' necbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Je cjefe sacerdote arj-e' xe nqueyok' chka' e quexbil je' maestro je nquetijona cxin wnak tzrij rley Dios e quexbil chka' je' principal-i' rxin tnamet. ");
INSERT INTO tzjE_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Arja' To'onel cxin wnak, cara' nbixa tzra, per camic xe mtecwin nara' nuto' ri' ruyon. We ktzij che arja' Rey kxin ja ok aj Israel tkaj tc'a camic chwech cruz, y we xtkaj ta neyke'a c'ara' kac'u'x ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Arja' ykula ruc'u'x ruq'uin Dios nchexa, per wcongan wen ntz'e'ta rmal Dios tet-o' c'a camic com arja' xucsaj ri' che Rlec'wal Dios. Cara' necbij che necyok'bej rxin. ");
INSERT INTO tzjE_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Y cara' xqueban elk'oma' jxeri'pa chwech cruz prexquin Jesús, arj-e' xqueyok' chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jpe nc'aj k'ij c'ola jun nimlaj k'ejku'm xec'je'a chwech njelal ruch'lew, c'a las tres rxin tk'ak'ij xeskara chic jmul. ");
INSERT INTO tzjE_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ja' Jesús a las tres chlara' rxin tk'ak'ij arja' congan xurak ruchi', cawra xbij ra: —Elí, Elí, ¿lama sabactani? cara' xbij. Jara' tzij je xbij cawra nbij: —Nedta' Dios, Nedta' Dios ¿nak tzra tak xenaya' cana? cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ec'ol c'a chca jle' wnak jec'ola tzra', arj-e' tak xecc'axaj je xbij cawra xecbij ra: —Jala acha comnak profeta Elías nsiq'uij, cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","C'ol c'a jun chca xerc'amla' ta jun esponja, xch'akba' chpam jle' ch'amlaj vinagre, xuxim chutza'm jun aj y xuya' pona tzra Jesús chnutaj. ");
INSERT INTO tzjE_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Per jle' chic cawra xecbij: —Tey-a' tzra', katz'ta' nc'a k'alaj we xtpeta Elías che nret-o', cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ja' Jesús xurak chic jmul ruchi', xujach ranm tzra Dios y xcom kaja. ");
INSERT INTO tzjE_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Y chek q'uenjlal xraktaja mant jk'otben rpam santlaj rtemplo Dios, chek c-e' xuban. Xraktaj ta, nq'ue chcaj xe'el twa' y xerkaja penlew. Jruch'lew congan xusil ri' y c'ola nmak tak abaj xuch'or ri' rmal. ");
INSERT INTO tzjE_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","C'ola je' jul cxin cnomki' xjaktaja y je' cnomki' je rxin Dios e q'uiy chca xec'astaja. ");
INSERT INTO tzjE_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Arj-e' tak c'astanak chic Jesús xe'el ta chpam jul abar ec'o wa' y xeba chpam santlaj tnamet Jerusalén, y e q'uiy xetz'towa cxin. ");
INSERT INTO tzjE_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jcapitán e rexbil jec'ola ruq'uin che necchajij Jesús arj-e' xquetz'et cbarkan jxuban, xquetz'et njelal je xbantaja y congan xecxibej qui' rmal: —Jala acha ne ktzij wa' che Rlec'wal Dios, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Y e q'uiy ixki' jec'ola tzra' xquetzu' pona chka' je xbantaja. Arj-e' etren ela tzrij Jesús tak xe'el ta pGalilea y xqueto' chpam jnak nc'atzina tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jun chca ixki' María Magdalena, jun chic María jquete' Jacobo ruq'uin José, jun chic jquete' rlec'wal Zebedeo. ");
INSERT INTO tzjE_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tak xoca ak'a' c'ola jun acha xpeta, arja' byom aj Arimatea, José rubi'. Arja' rdiscípulo Jesús chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Xba ruq'uin Pilato che rc'utxic recuerpo Jesús. Tak xekaja, ja' Pilato xuya' orden che nja'cha recuerpo tzra. ");
INSERT INTO tzjE_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Xba ja' José, xerec'ma' recuerpo Jesús y xubar chpam jun ch'ajch'oj tziak. ");
INSERT INTO tzjE_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tak xbartaja rmal xerey-a' chpam jun panteón c'ac' rxin ja' jrec'ton chwech jun tz'lem abaj, y xtz'apij ruchi' tzra jun tz'lem abaj. C'jara' xba. ");
INSERT INTO tzjE_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ja' María Magdalena rexbil jun chic María arj-e' ec'ola tzra', etz'bul oca chwech panteón. ");
INSERT INTO tzjE_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Rcab k'ij tak xk'axa k'ij je nchumsasa je' achnak rxin nimk'ij xeba je' cjefe sacerdote e quexbil fariseo, xequemlo' qui' chwech Pilato. ");
INSERT INTO tzjE_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Cawra xecbij tzra: —Señor Gobernador, ajoj bien nerkaja pkawá', ja acha Jesús jnetz'kowa tzij, tak c'c'as na c'o jun tzij xbij cana cawrara: —Per prox k'ij nc'astaja nwech. Cara' xbij cana. ");
INSERT INTO tzjE_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Rmal c'ara' nekbij chawa, tey-a' jun orden che nchajixa oxi' k'ij jpanteón, mal-il xtqueba rdiscípulo chak'a' xtequelk'aj ta recuerpo chpam panteón y tak xtc'amtaj ela cmal xtecbij chca wnak che xc'astaja rwech jara' acha chquecjol cnomki'. Wcara' xtqueban jara' más chna jun nimlaj tz'koj tzij que chwech ajni' xuban Jesús nabey, cara' xecbij tzra Pilato. ");
INSERT INTO tzjE_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Cawra xbixa chca: —Ec'ola je' guardia, ixix c'ola je' ek'a' chca che nque'ec'om ela, seguro tebna' tzra panteón com ixix ewutkin nak xteban tzra, cara' xbixa chca rmal Pilato. ");
INSERT INTO tzjE_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","C'jara' xeba, xecchumij abaj je tz'apben ruchi' jpanteón, bien seguro xqueban tzra y xequeya' cana guardia che rechjalbxic. ");
INSERT INTO tzjE_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Xk'axa xlanbal k'ij, jpe rsakric rxin domingo xba María Magdalena rexbil jun chic María xequetz'ta' panteón. ");
INSERT INTO tzjE_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Chek q'uenjlal c'ola jun nimlaj cbarkan xuban com jun ángel rxin Kajaw Dios xkaj ta chcaj, xelsaj abaj je tz'apben ruchi' panteón y xetz'be'a pe rwá'. ");
INSERT INTO tzjE_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Je nca'ya ja' ángel ajni' nca'ya queypa' tak nuq'uiek ri', y jretziak recsan congan sak. ");
INSERT INTO tzjE_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Je' guardia arj-e' congan xecxibej qui' rmal, congan nqueberbeta rmal xben ri'il y nmajo'n xquena' ta xekaja ptak ulew. ");
INSERT INTO tzjE_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Per ja ángel cawra xbij chca ixki': —Mtexibej ta ewi' com anen wutkin Jesús nquixtajina necanoj je xcamsasa chwech cruz. ");
INSERT INTO tzjE_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Camic mwawe' xta c'o wa', c'astanak chic rwech, bantanak chic cumplir ajni' rbin cana. Quixjo', tetz'ta' mpa' je lwar abar xec'je' wa' recuerpo Kajaw. ");
INSERT INTO tzjE_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tak xttz'ettaj cana ewmal nquixba alnak, nebij chca rdiscípulo che c'astanak chic rwech chquecjol cnomki'. Y cawra nebij chca ra: —Tewc'axaj mpa', ja' Jesús nnabyeja chewech, nba pGalilea y tzra' netz'ta' wa' ewi', cara' tbij chca. Xtetz'ta' mpa' com xenbij chewa. Cara' xbij ja' ángel chca. ");
INSERT INTO tzjE_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","J-e' ixki' xe'el ela alnak ruq'uin panteón y xeba xecbij chca discípulo, congan cxiben qui' y congan nquequicota chka'. ");
INSERT INTO tzjE_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kas ebnak che rbixic chca discípulo je xbix ela chca tak chek q'uenjlal xquec'ul qui' ruq'uin Jesús. Ja' Jesús xerk'ijla' pona. Arj-e' tak xe'ekaja ruq'uin xquechap rkan y xquemaj rya'ic ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ja' Jesús cawra xbij chca: —Mtexibej ta ewi', jax cuq'uin wch'alal, ebij chca che nqueba pGalilea, tzra' cnequetz'ta' wa', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","J-e' ixki' kas ebnak che rbixic je xbix ela chca, je jle' chca guardia xeba chpam tnamet, xeba cuq'uin cjefe sacerdote. Tak xe'ekaja cuq'uin xecbij chca njelal je xbantaja. ");
INSERT INTO tzjE_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Je cjefe sacerdote arj-e' xquemol qui' cuq'uin principal-i' rxin tnamet y xquemaj rch'obic nak nqueban. Tak xch'obtaja cmal, arj-e' q'uiy pak xqueya' chca soldado ");
INSERT INTO tzjE_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","y cawra xecbij chca: —Cawra tbij chca wnak ra: —Je' rdiscípulo Jesús xepeta chak'a', xerquelk'aj ela recuerpo tak okwarnak ajoj, cara' xtebij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","We xtekaja rbixic ruq'uin gobernador chcara' xeban, ajoj nokchumsana ruq'uin, nmajo'n nak xtuban chewa, cara' xecbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","J-e' soldado xquec'om pak y cara' xqueban ajni' xbixa chca. Y jara' tz'koj tzij majtanak na rbixic chca aj Israel camic. ");
INSERT INTO tzjE_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Je ljuj discípulo arj-e' xeba pGalilea, xeba pe rwá' jyu' abar bin wa' chca rmal Jesús che nqueba wa'. ");
INSERT INTO tzjE_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tak xquetz'et Jesús xquemaj rya'ic ruk'ij per ec'ola majo'n kas ta xecnimaj chJesús. ");
INSERT INTO tzjE_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Xpeta Jesús, cawra xbij chca: —Njelal poder rxin chcaj jchon pnuk'a' rexbil njelal poder rxin rwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Rmal c'ara' quenbij chewa, jax cuq'uin wnak jec'ola chpam njelal nación, que'etijoj ch-utz c'ara' nque'oca ndiscípulo, que'ebna' bautizar prubi' Ttixel, Rlec'walxel y Espíritu Santo. ");
INSERT INTO tzjE_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Que'etijoj che nqueban chpam cc'aslemal njelal je nbij mandamiento jney-on cana chewa. Y bien terkaja pnewá' che anen nmajo'n jun k'ij mquita enc'ola ewq'uin, y ne enc'ola ewq'uin tak xtetz'kata tiemp je rxin rwech ruch'lew. Amén.");
INSERT INTO tzjE_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Cawra rbanic tak xmajtaja rk'alsic utzlaj tzij jnuc'ut chkawech nak rbanic Jesucristo je Rlec'wal Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ajni' tz'ibtanak cana chpam rtzojbal Dios ojer rmal profeta Isaías jcawra xbij Ttixel tzra Rlec'walxel: —Tewc'axaj bien, anen c'ola jun nmensajero quentak ela, arja' nnabyej ela chawech che rchumsic abey. ");
INSERT INTO tzjE_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jmensajero nc'axaxa rukul chpam tenlic lwar y cawra nuchol ra: —Tchumsaj rubey Kajaw Dios, jic tey-a'. Cara' tz'ibtanak cana. ");
INSERT INTO tzjE_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Y cara' xbantaja, xpeta mensajero, Juan rubi', arja' nqueruban bautizar je' wnak. Arja' chpam tenlic lwar nec'je' wa' y cawra nbij chca wnak: —Tec'xa' ena'oj y tey-a' cana rtzilal y quixba'na bautizar, cara' ta neban ch-utz c'ara' ncuytaja ewil emac, cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Conjelal wnak jec'ola pJerusalén e quexbil jle' chic jec'ola chpam jle' chic lwar jc'ola precwent Judea arj-e' xeba ruq'uin Juan y xeba'na bautizar rmal ja' Juan chpam binel ya' Jordán, y tzra' xquechol wa' quil quemac. ");
INSERT INTO tzjE_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jretziak Juan recsan jara' resmal camello ocnak y rexmon xe' rpam tzra jun tz'um. Jocnak rway jara' je' sac' ruq'uin ri'al che' je ncanoj ptak k'ayis. ");
INSERT INTO tzjE_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Cawra nbij chca wnak ra: —C'o chna jun penak xjarlal q'uemjana tumaj rsamaj, arja' más chna nim poder c'ola pruk'a' que chenwech anen. Anen me tyataja chwij chquenki'l oca ruq'uin nexte chquenquir nara' rc'amal rexjab. ");
INSERT INTO tzjE_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Anen ya' xencsaj tak xixnuban bautizar per ja' Espíritu Santo nquixrbanbej bautizar. Cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jara' tiemp xel ta Jesús pNazaret jc'ola precwent Galilea, xba ruq'uin Juan y xba'na bautizar rmal Juan chpam binel ya' Jordán. ");
INSERT INTO tzjE_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Chek xel ta Jesús pya' xutz'et caj jaktanak y xutz'et Espíritu Santo ajni' jun paloma xkaj ta ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Y c'ola jun kul xc'axaxa penak chcaj y cawra nbij: —Atet at quilaj Wlec'wal, congan quenquicota chawij, cara' xbij Dios tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ja' Espíritu Santo xutak ela Jesús chpam tenlic lwar. ");
INSERT INTO tzjE_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cawnak k'ij xec'je'a chpam lwar y tak xekaja Satanás ruq'uin xrajo' nuban tentar. Y je lwar abar tzra' ec'o wa' ec'ol je' itzel tak chcop, y xepeta je' ángel rxin Dios che xecrilij. ");
INSERT INTO tzjE_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tak xucsasa Juan Bautista pcars Jesús xba chpam departamento Galilea. Tak xekaja xumaj rbixic utzlaj tzij tzrij rgobierno Dios ");
INSERT INTO tzjE_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","y cawra nbij ra: —Camic xetz'kata tiemp y rgobierno Dios xyamer nerkaja rmal c'ara' quenbij chewa, tec'xa' ena'oj y tey-a' cana rtzilal, tnimaj jutzlaj tzij jrec'mon ta totanem rxin Dios. Cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús remjon binem chuchi' ya' rbin-an Galilea tak ec'ola e c-e' ach-i' xeruwil, j-era' ach-i' e alxic, jun Simón rubi' y jun chic Andrés rubi'. J-e' com e chpoy ch'u' kas quemjon rq'uiekxic quec'am pya' tak xe'iltaja rmal Jesús, ");
INSERT INTO tzjE_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","y cawra xbixa chca: —Jo' quixetre' ta chwij, anen quenya' jun samaj chewa per me chpoj ch'u' xta neban, wnak chic nque'echap, cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","J-e' xecch'akla' cana quec'am y xetre' ela tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ja' Jesús q'ue mnim ta rbinben tak ec'o chic e c-e' ach-i' xeruwil, chka' e alxic, jun Jacobo rubi' y jun chic Juan rubi', e rlec'wal Zebedeo. Arj-e' chka' ec'ola chpam jun lanch, quemjon rchumsic quec'am. ");
INSERT INTO tzjE_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Alnak xesiq'uis pona rmal Jesús. Xqueya' cana planch Zebedeo jquedta' ruq'uin je' mos y xetre' ela tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Y xeba xe'ekaja chpam tnamet Capernaum. Ja' Jesús xoca chpam jay rxin molbal ri'il abar nquemol wa' qui' wnak che rc'axic rtzojbal Dios y xumaj ctojxic chpam jun xlanbal k'ij. ");
INSERT INTO tzjE_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","J-e' wnak xel ta quec'u'x tzrij tijonem jnuya' com jtijonem nuya' chca congan nqueruchap, bien k'alaj chruq'uin Dios penak wa' je nbij, mjunam ta ruq'uin tijonem je nqueya' je' maestro je nquetijona cxin wnak tzrij rley Dios jtz'ibtanak cana rmal Moisés. ");
INSERT INTO tzjE_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Je chpam jay rxin molbal ri'il tzra' c'o wa' jun acha ocnak jun itzel espíritu pranm, arja' xumaj rakic ruchi' ");
INSERT INTO tzjE_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","y cawra nbij: —Jesús aj Nazaret ¿nak narebna' wawe' kuq'uin, mex atpenak che nko'areyjo'? Anen wutkin nak abanic, atet at Santlaj Rlec'wal Dios, cara' nbij tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús cow xtzijona tzra itzel espíritu: —Catetne'a y catel ela pranm jawra acha, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jitzel espíritu arja' xuya' jun ataque tzra acha y congan nurak ruchi', xel ela pranm acha y xba. ");
INSERT INTO tzjE_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Conjelal je' wnak congan xel ta canm tak xquetz'et y cawra xecbij chbil tak qui': —¿Nak rbanic c'a wa', nak che c'ac'laj tijonem c'a wa'? Com jawra acha mesque itzel tak espíritu per nc'ola ruk'a' che nqueruban mandar y nnimaxa cmal chka'. Cara' necbij je'a. ");
INSERT INTO tzjE_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Y nalnak xba nat nkaj rtzojxic Jesús chpam jle' chic lwar jc'ola precwent Galilea. ");
INSERT INTO tzjE_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ja' Jesús e rexbil Jacobo ruq'uin Juan arj-e' tak xe'el ela chpam jay rxin molbal ri'il xeba pcuchoch Simón ruq'uin Andrés. ");
INSERT INTO tzjE_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Je rjite' Simón arja' c'ola chwech ch'at yawa', majtanak rmal c'ten. Jesús tak xekaja xbixa tzra chyawa'. ");
INSERT INTO tzjE_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Arja' xki'l oca ruq'uin, xuchap chuk'a', xuyic y njara' hor xela c'ten tzrij. Ja' ixak xumaj quelxic Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tak xoca ak'a' conjelal yuw-i' xec'mar ela chwech Jesús e quexbil jocnak itzel tak espíritu pcanm. ");
INSERT INTO tzjE_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Je tnamet emlen chijay abar c'o wa' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","J-e' wnak q'uiy rwech yubil cc'an y ja' Jesús e q'uiy chca xerchumsaj y e q'uiy chca chka' xelsaj itzel tak espíritu pcanm. Arja' xeruk'il itzel tak espíritu chmajo'n nquetzijon ta más com j-e' cutkin che arja' Cristo je ch-on rmal Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jche rcab k'ij q'ue samakmuj na xyictaj ela Jesús, xel ela chpam tnamet, xba chpam jun tenlic lwar chnerebna' oración. ");
INSERT INTO tzjE_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón ruq'uin je' rexbil arj-e' xeba che rconxic. ");
INSERT INTO tzjE_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tak xquewil cawra xecbij tzra: —Conjelal wnak quemjon aconxic. ");
INSERT INTO tzjE_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús cawra xbij chca: —Jo' chpam jle' chic lwar jc'ola chenkaj, tzra' cney-a' chwa' rbixic utzlaj tzij chka' com xe rmal c'ara' enpenak, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Cara' xuban Jesús xba chpam njelal lwar jc'ola precwent Galilea, noca ptak jay rxin molbal ri'il y tzra' nuya' wa' rbixic utzlaj tzij chca wnak y nquerelsaj ela itzel tak espíritu ptak canm. ");
INSERT INTO tzjE_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xuban jmul jun acha c'ola itzel yubil lepra rc'an, arja' xekaja ruq'uin Jesús, xexque'a chwech y congan xc'utuj rto'ic: —Wnawajo' cnachumsaj, anen wutkin che ncatecwina cnachumsaj, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ja' Jesús xpoknaj rwech yawa', xuyuk pona ruk'a', xuchap y cawra xbij tzra: —Quenwajo' ajni' nac'utuj chwa, catchumtaja, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Y alnak xel ela itzel yubil tzrij y xec'choja. ");
INSERT INTO tzjE_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","C'jara' Jesús congan xbij tzra: —Kas quenwajo' quenbij chawa, majo'n abar nabij wa' jxenban chawa. Per jnaban, ac'tu' awi' chwech sacerdote. Com xatec'choja ay-a' awofrenda ajni' rbin cana Moisés chpam rley Dios chnaban. Je awofrenda naya' jara' nac'utbej chquewech sacerdote chnaban cumplir je rbin cana Moisés, cara' xbij ela tzra acha. ");
INSERT INTO tzjE_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Xba ja' acha per majo'n xuban ta ajni' xbixa tzra rmal Jesús, arja' congan xelsaj rbixic chJesús xchumsana rxin. Rmal c'ara' Jesús mesquier chic necwina noca chpam tnamet chquewech wnak, per jxuban xec'je'a chpam je' tenlak tak lwar, per nec'ola wnak nque'ekaja ruq'uin, chpam njelal tnamet epenak wa'. ");
INSERT INTO tzjE_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tak xuban cji' j-o' k'ij xemloja Jesús chpam tnamet Capernaum. Tak c'ol chic chpam tnamet je' wnak xecc'axaj che arja' ocnak chpam jun jay. ");
INSERT INTO tzjE_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chanim xecmolla' qui' je' wnak ruq'uin, congan e q'uiy y nxeptz'e'a pjay y nxe'el ta pe rchijay y nmajo'n chic nquec'je' wa'. Jesús arja' ntajina remjon rbixic rtzojbal Dios chca. ");
INSERT INTO tzjE_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ec'ol c'a e cji' ach-i' xerkaja, quec'mon ta jun acha squirnak, ncajo' nqueya' chwech Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","J-e' mxecwin ta xe'ekaja abar c'o wa' Jesús com je' wnak congan enojnak pjay. Rmal c'ara' tak xejte'a pe rwá' jay, xectak'ba' rwá' y tzra' xeckasaj wa' yawa', ctz'ela chwech rwarbal. ");
INSERT INTO tzjE_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús tak xutz'et yukbal quec'u'x ach-i' jc'ola ruq'uin, arja' cawra xbij tzra squirnak: —Wlec'wal, camic xcuytaja awil amac, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ec'ol c'a jle' maestro je nquetijona cxin wnak tzrij rley Dios etz'bula tzra' pjay, arj-e' chek xc'axtaja cmal je xbij Jesús cawra xquemaj rch'obic ptak canm: ");
INSERT INTO tzjE_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Nak tzra tak nbij cala' jala acha? Je nbij jala' xitzel nc'axaxa rmal Dios com majo'n chic jun xtecyuw ta il mac, xruyon Dios necyuwa, cara' necbij kaja ptak canm. ");
INSERT INTO tzjE_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Per Jesús arja' bien rutkin nak quemjon rch'obic ptak canm y cawra xbij chca: —¿Nak tzra tak cara' nech'ob kaja ptak ewanm? ");
INSERT INTO tzjE_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Camic quenwajo' quenc'axaj chewa ¿nak más majo'n pen ta tzra c-e' jawrara chquenbij tzra jawra acha sic, chquencuy ril rumac, o wquenbij tzra che nyictaja y nuc'om ela rwarbal y numaj binem? ");
INSERT INTO tzjE_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Anen quenwajo' quenban jun achnak chewech camic ra ch-utz c'ara' newutkij che Rlec'walxel jxoca alxic cuq'uin wnak yatanak tzra chnucuy quil quemac je' wnak wawe' chwech ruch'lew, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Anen quenbij chawa camic catyictaja, tec'ma' ela awarbal y jat pnawuchoch, cara' xbij tzra acha sic. ");
INSERT INTO tzjE_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chek xbitaja cara' rmal xyictaj ela acha y xumaj rc'olic rwarbal. Tak xc'oltaja rmal xba, xel ela chquecjol per ne chquewech conjelal. J-e' c'a wnak congan xel ta quec'u'x tzrij je xbantaja y xquemaj rya'ic ruk'ij Dios rmal, cawra necbij ra: —Jawra je xbantaja nexte wjic katz'ton ta, cara' xecbij je'a. ");
INSERT INTO tzjE_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","C'jara' xba chic jmul Jesús chiya'. Tak xekaja conjelal wnak xequemlo' chic qui' ruq'uin y arja' xumaj ctojxic tzra rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tak xemloj ta chiya' kas remjon binem tak c'ola jun acha xutz'et, rubi' Leví, rlec'wal Alfeo. Leví arja' tz'bula chpam lwar abar nto'j wa' impuesto pruk'a' y cawra xbixa tzra rmal Jesús: —Jo' catetre' ta chwij che ncatoca ndiscípulo, cara' xbixa tzra. Ja' Leví xyictaj ela y xba tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesús c'ola pruchoch Leví, tz'bula tzrij mes e rexbil rdiscípulo y ec'ola e q'uiy e mloy tak impuesto ruq'uin jle' chic e aj-il ajmac nbixa chca, arj-e' e q'uiy xetz'be'a tzrij mes cuq'uin perc congan e q'uiy etren ela tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ec'ola jle' maestro je nquetijona cxin wnak tzrij rley Dios e quexbil jle' fariseo, arj-e' tak xquetz'et Jesús xcuq'uin e mloy tak impuesto nwa' wa' e quexbil jle' chic aj-il ajmac nbixa chca, cawra xecbij chca rdiscípulo: —¿Nak tzra c'ara' xcuq'uin mloy tak impuesto nwa' wa' y chka' cuq'uin jle' chic aj-il ajmac? cara' xecbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Per Jesús tak xc'axaj jxecbij cawra xbij chca: —Nak majo'n e yawa' ta majo'n nc'atzin ta doctor chca, per je yuw-i' nc'atzin wa' jun doctor chca. Anen enpenak che cconxic aj-il ajmac ch-utz c'ara' nqueya' cana quil quemac, me j-e' ta ra' e bnoy rbeyal que'encanoj. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Je rdiscípulo Juan Bautista arj-e' quemjon rbanic ayuno y cara' quemjon rbanic je' cdiscípulo fariseo chka'. Ec'ola jle' wnak xe'ekaja ruq'uin Jesús y cawra xecbij tzra: —¿Nak tzra adiscípulo atet majo'n nqueban ta ayuno per je' rdiscípulo Juan arj-e' nqueban wan ayuno, y cara' nqueban cdiscípulo aj fariseo chka'? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús cawra xbij chca: —Ajni' chca jle' wnak ebnon invitar tzra jun c'ulbic, tak c'c'o na acha chquecjol jnec'le'a ¿tkal c'ara' chquij nqueban ayuno nech'ob ixix? Ajru' tiemp xtec'je'a acha chquecjol jnec'le'a jara' mesquier nquecwina nqueban ayuno. ");
INSERT INTO tzjE_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per nerla' jun k'ij tak xtelsasa acha chquecjol jnec'le'a, c'jara' c'a xtqueban ayuno. ");
INSERT INTO tzjE_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Majo'n jun wnak xtuc'om ta jtz'it c'ac' tziak y xtucsaj ta tesbal tzra jun tzbuklaj tziak. Wexte cara' nba'na je tzbuklaj tziak chkajni' netk'e'a com jc'ac' tesbal xnuc'ol ri'. ");
INSERT INTO tzjE_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Chka' ajni' tzra c'ac'laj vino, next jun xtuc'ol ta chpam tzbuklaj tak c'olbal. Wexte cara' nba'na jc'ac' vino nurak rc'olibal, ntz'iloxa vino y ntz'iloxa rc'olibal chka'. Per nc'atzina che nya'a c'ac' vino chpam c'ac' tak c'olbal. Cara' xbij Jesús tzrij jc'ac' tijonem jrec'mon ta. ");
INSERT INTO tzjE_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Xuban c'a jmul chpam jun xlanbal k'ij arja' remjon binem chpam jle' trigo e rexbil rdiscípulo. Kas nquek'axa chpam trigo je' discípulo xquemaj rk'upxic rwá' je' trigo. ");
INSERT INTO tzjE_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ec'ol c'a jle' aj fariseo arj-e' xecbij tzra Jesús: —Kas adiscípulo ntajina quemjon rbanic jala je xjan nba'na chpam xlanbal k'ij. ¿Nak tzra tak nqueban cara'? ");
INSERT INTO tzjE_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Cawra xbij Jesús chca: —¿Lmajo'n c'a esiq'uin ta chpam rtzojbal Dios jxuban ojer rey David tak ocnak nimlaj sacerdote Abiatar? Ja' David congan nk'ak'ana rpam y cara' quebnon rexbil chka'. Rmal c'ara' David xoca chpam ruchoch Dios y xutaj xquelway jyonan cana chwech Dios, y xuya' cxin rexbil chka'. Cara' xuban mesque jara' xquelway ajni' tz'ibtanak chpam rley Dios che xqueyon sacerdote nquetjowa. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Y cawra xbij chic chca: —Je' wnak jxewankersasa rmal Dios me rmal ta che nqueyic xlanbal k'ij per xwankersasa xlanbal k'ij che cto'ic wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Rmal c'ara' quenbij chewa che Rlec'walxel jxoca alxic cuq'uin wnak, pruk'a' c'o wa' je nba'na chpam xlanbal k'ij chka', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ja' Jesús xoc chic chpam jay rxin molbal ri'il y tzra' c'o wa' jun acha squirnak jun ruk'a'. ");
INSERT INTO tzjE_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ec'ol c'a nic'aj wnak nquechajina Jesús, j-e' ncajo' nquetz'et we nchumsaj acha chpam xlanbal k'ij. Cara' nqueban ch-utz c'ara' nquewil jun ril che necchapbej rxin. ");
INSERT INTO tzjE_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","C'jara' ja' Jesús xbij tzra acha je squirnak ruk'a': —Catyictaja y catpe'a wawe' chkacjol, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","C'jara' cawra xbij chca wnak: —¿Nak nuya' c'as ley chka ptak xlanbal k'ij, we nkaban utzil o we nkaban rtzilal? ¿Lnuya' c'as chka che nquekato' wnak o nquekcamsaj? cara' nbij chca. Per j-e' majo'n achnak xecbij tzra, majo'n xecc'ulba' ta. ");
INSERT INTO tzjE_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","C'jara' xpeta ryiwal Jesús chquij y xerch'ulchij, congan bis xuban cmal rmal jcongan cow canm y mesquier nch'obtaja cmal je nbixa chca. Y cawra xbij chic tzra acha je squirnak jun ruk'a': —Teyku' ak'a', cara' xbij tzra. Xuyuk ruk'a' y xec'choja. ");
INSERT INTO tzjE_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","J-e' aj fariseo xeba, xequemlo' qui' e quexbil jec'ola chpam partido rxin Herodes y xquemaj rch'obic nak nqueban tzra Jesús che neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ja' Jesús xel ela chpam lwar y xba chiya' e rexbil rdiscípulo, y congan e q'uiy wnak aj Galilea xetre' ela tzrij. Ec'o chna más xe'ekaja ruq'uin ajni' aj Jerusalén, chka' jec'ola chpam jle' chic tnamet jc'ola precwent Judea, xe'ekaja aj Idumea, chka' jec'ola pjupraj binel ya' Jordán, chka' aj Tiro ruq'uin aj Sidón, per congan e q'uiy wnak xe'ekaja ruq'uin. Cara' xqueban com ponnak chic rbixic cuq'uin njelal achnak je ntajina nuban Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesús cawra xbij chca rdiscípulo: —Tchumsaj pona jun lanch ch-utz c'ara' je' wnak majo'n quenquepitz' ta. ");
INSERT INTO tzjE_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Cara' xbij chca com e q'uiy chic wnak erchumsan rmal c'ara' conjelal wnak jc'ola cyubil congan nquepitz' qui' y ncajo' nquechap oca ch-utz c'ara' nquechumtaja. ");
INSERT INTO tzjE_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jitzel tak espíritu cc'an wnak tak xquetz'et Jesús xexque'a chwech, xquemaj rakic quechi' y cawra necbij tzra: —Atet at Rlec'wal Dios, cara' necbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Per Jesús congan xbij chca chmajo'n abar tecbij wa' che arja' Cristo. ");
INSERT INTO tzjE_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","C'jara' xojte'a Jesús chwech jun jyu', xuwil jun lwar abar xec'je' wa'. Chquecjol wnak ec'o wa' nic'aj jc'ola rgan Jesús chquij che nquetre' ela tzrij, arja' xersiq'uij pona y j-e' xeba ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","E cbeljuj xerucha' chca ch-utz c'ara' nquec'je'a junlic ruq'uin y chnequey-a' rbixic rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Y xuya' chca chka' poder che nquecwina nquecchumsaj yuw-i' y nquequelsaj itzel tak espíritu chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jawra quebi' je cbeljuj xerucha': Simón je xcanox chic jun rubi' Pedro, ");
INSERT INTO tzjE_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo rlec'wal Zebedeo, Juan je rch'alal Jacobo, j-e' c'a Jacobo ruq'uin Juan xcanox chic jun quebi' rmal Jesús y xbixa chca Boanerges. (Boanerges nbij tzij alc'walxela' rxin queypa'). ");
INSERT INTO tzjE_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo rlec'wal Alfeo, Tadeo, Simón jun chca rxin partido rbin-an cananita ");
INSERT INTO tzjE_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ruq'uin Judas Iscariote jxejchowa Jesús pquek'a' wnak je nquetzelana rxin. Ja' Jesús xoc chic chpam jun jay e rexbil rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","J-e' wnak xequemlo' chic qui' cuq'uin y rmal c'ara' nmajo'n tiemp tzra ja' ruq'uin je' rdiscípulo che nquewa'a. ");
INSERT INTO tzjE_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Je rch'alal Jesús tak xecc'axaj jremjon rij, arj-e' xepeta, ncajo' nquec'om ela. Cara' nqueban com xquech'ob j-e' che xch'ujara Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Chka' ec'ola nic'aj maestro je nquetijona cxin wnak tzra rley Dios jtz'ibtanak cana rmal Moisés, arj-e' epenak pJerusalén y cawra necbij chca wnak: —Jala acha xBeelzebú c'ayona rxin, xe rpoder cjefe itzel tak espíritu nucsaj che clasic itzel tak espíritu, cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ja' Jesús xersiq'uij pona y cawra jun c'ambal tzij xbij chca: —Mesquier c'ara' Satanás xquerelsaj ta rdemonio. ");
INSERT INTO tzjE_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jun gobierno wex división nuban chbil ri' jara' xe nyojtaja. ");
INSERT INTO tzjE_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Cara' chca wnak jec'ola pjay chka', wex división nqueban chbil tak qui' jara' xe nqueq'uisa. ");
INSERT INTO tzjE_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Cara' c'a tzra Satanás chka', wex nch'ojin kaja ruq'uin ruyon, o wex nquerelsaj ela rdemonio, jara' nyojtaja y nq'uisa. ");
INSERT INTO tzjE_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tak ncatekaja ruq'uin jun acha congan rchuk'a' y wnach'ob chnalsaj ela njelal achnak jc'ola pruchoch nc'atzina nabey mul nabac' jara' acha. Wcara' naban jara' ncatecwina nalsaj njelal achnak jc'ola pruchoch. ");
INSERT INTO tzjE_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ne ktzij wa' je xtenbij chewa camic, je' wnak mesque nqueban il mac chka bechnak opech il mac, jara' c'ola cuytajic tzrij. Chka' mesque nbij jle' tzij tzra Dios jxitzel nc'axaj jara' ncuytaja chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Per wc'ola jun wnak chka bechnak wnak opech nbij jle' tzij tzra Espíritu Santo jxitzel nc'axaj, jara' majo'n ncuytaj ta rxin junlic y nejklej jun juicio rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Cara' xbij chca com necbij j-e' chc'ola jun itzel espíritu c'ayona rxin. ");
INSERT INTO tzjE_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","C'jara' xerkaja rch'alal Jesús rexbil rute', arj-e' ec'ola chujay y xquetak ela rsic'sic. ");
INSERT INTO tzjE_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Je' wnak jetz'bul oca chenkaj ruq'uin Jesús arj-e' cawra xecbij tzra: —Tetz'ta' mpa' ate' ruq'uin awch'alal ec'ola chujay y ncajo' nquetzijona awq'uin, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ja' Jesús cawra xbij chca: —Camic quench'ob chewech nak nute' y e achnak wch'alal. ");
INSERT INTO tzjE_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","C'jara' xeruc'ut jetz'bula chenkaj ruq'uin y cawra xbij: —J-e' c'a wa' e'ocnak nute' y e'ocnak wch'alal. ");
INSERT INTO tzjE_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Cara' quenbij chewa com achnak nebnowa je nrajo' ranm Dios ja' c'ara' ocnak nuchak' o wana' o wnute', cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wjic chic Jesús xumaj ctojxic wnak chiya' y congan e q'uiy wnak xequemlo' qui' ruq'uin rmal c'ara' xoca chpam lanch jc'ola pe rwá' ya' y xetz'be'a chpam. Je' wnak xemle' cana chiya' conjelal. ");
INSERT INTO tzjE_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Xumaj tzij ja' Jesús cuq'uin, q'uiy rwech xbij chca pc'ambal tzij y cawra tijonem xuya' chca: ");
INSERT INTO tzjE_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Tewc'axaj je xtenbij chewa per bien tey-a' ewexquin tzrij. C'ola jun ajsmajma' xba pe tcoy rtejco'n pe rchinoj. ");
INSERT INTO tzjE_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tak xekaja xumaj rch'akxic ija'tz. C'ola nic'aj xkaja pbey y xepeta tz'quin, xquetaj ela. ");
INSERT INTO tzjE_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","C'o chic jle' xkaja abar c'o wa' abaj, congan xax ulew tzra' rmal c'ara' chanim xel ta. ");
INSERT INTO tzjE_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Per tak xel ta k'ij xc'atsaj y tak xq'uisbena xechkija rmal com majo'n xetque' ta bien ruxe'. ");
INSERT INTO tzjE_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","C'o chic jle' xkaja ptak q'uix y tak xq'uisbena xq'uiya jara' q'uix, xk'ok'aj tejco'n y xcamsaj njelal. Cara' xuban nmajo'n rwech xuya'. ");
INSERT INTO tzjE_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Per c'ola jle' xkaja chpam utzlaj ulew y congan xwachina, congan xq'uiya y xba pnim, xjun rk'arwech ija'tz c'ola xuya' treinta, c'ola xuya' sesenta y c'ola xuya' jun cient. ");
INSERT INTO tzjE_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Achnak c'ola rexquin tc'axaj c'a jquenbij, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tak xecpaxij ela qui' je' wnak xecanaj cana rexbil Jesús ruq'uin e quexbil e cbeljuj apóstol y xecc'axaj tzra Jesús tzrij jc'ambal tzij. ");
INSERT INTO tzjE_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús cawra xbij chca: —Ixix yatanak chewa chnewutkij nak rbanic jwewtanak tzrij rgobierno Dios per chca jle' chic wnak njelal jquenbij chca quencsaj na c'ambal tzij che rbixic. ");
INSERT INTO tzjE_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Cara' quenban ch-utz c'ara' che j-e' nquetz'et je nc'u'ta chquewech per majo'n nekaj ta pquewá', ch-utz c'ara' chka' che necc'axaj je nbixa chca per majo'n nch'obtaj ta cmal, ch-utz c'ara' chka' che mtqueq'uex cna'oj che ncuytaja quil quemac. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Cawra xbij chic chca: —¿Lmajo'n c'a nch'obtaj ta ewmal jc'ambal tzij jxenbij kaja chewa? Wex majo'n nquixecwin ta nech'ob jc'ambal tzij tzrij je tcoy tejco'n ¿nak tzra c'ara' xtch'obtaja ewmal nic'aj chic c'ambal tzij? Per camic quench'ob chewech nak nbij jc'ambal tzij. ");
INSERT INTO tzjE_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Je tcoy tejco'n jxutic ija'tz jara' nyowa rbixic rtzojbal Dios chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ija'tz je xkaja pbey jara' nbij tzij ec'ola wnak necc'axaj rtzojbal Dios per chanim npeta Satanás, nelsaj ela rtzojbal Dios je tcon ptak canm. ");
INSERT INTO tzjE_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ija'tz je xkaja ptak abaj jara' nbij tzij ec'ola wnak necc'axaj rtzojbal Dios y necnimaj chanim, congan nquequicota rmal. ");
INSERT INTO tzjE_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Per arj-e' e ajni' jle' tejco'n jmajo'n rc'amal ruxe', njurmaj oca necnimaj. Tak nerla' lowlo' tiemp, o tak nmajtaja rbanic lowlo' chca wnak rmal rtzojbal Dios, arj-e' chanim nqueya' cana yukbal quec'u'x. ");
INSERT INTO tzjE_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ija'tz je xkaja ptak q'uix jara' nbij tzij che ec'ola wnak necc'axaj rtzojbal Dios ");
INSERT INTO tzjE_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","per tak nq'uisbena xnecbisoj chic je' achnak rxin jawra tiemp je rxin rwech ruch'lew, neba'na engañar rmal mibil y ne chkajni' necyarij je' achnak. Rmal c'ara' tak ncoma utzlaj tzij jc'ola ptak canm y majo'n rwech nuya' ta. ");
INSERT INTO tzjE_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Per ija'tz je xkaja chpam utzlaj ulew jara' nbij tzij che ec'ola wnak necc'axaj rtzojbal Dios y necnimaj y congan rwech nuya' ptak canm. Arj-e' e ajni' jle' rk'arwech ija'tz c'ola xuya' treinta, c'ola xuya' sesenta y c'ola xuya' jun cient. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","C'jara' xbij chic jun c'ambal tzij chca: —¿Lc'ola jun wnak nebnowa nerec'ma' ta jun candil y nutzaj, y tak xtzajtaja rmal nuya' cana chuxe' jun cjon, o wnuya' cana chuxe' jun ch'at? Jara' next jun nebnowa. Je nba'na tzra candil, chcaj nya' wa' ch-utz c'ara' sak nuban tzra pjay. ");
INSERT INTO tzjE_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Njelal achnak jmajo'n k'alaj ta jara' nerla' na jun k'ij tak nk'aljina. Njelal jwewtanak jara' nel na psak, nutkix na. ");
INSERT INTO tzjE_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Achnak c'ola rexquin tc'axaj c'a jquenbij. ");
INSERT INTO tzjE_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Bien tey-a' ewexquin tzrij jemjon rc'axic camic. Wcongan neya' ewexquin tzrij jara' q'uiy nyataja chewa chnewutkij. Wmajo'n kas ta neya' ewexquin tzrij jara' majo'n kas ta nyataja chewa che newutkij. Y chewa ixix jemjon rc'axic camic q'uiy nyataj na chewa chnewutkij. ");
INSERT INTO tzjE_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Cara' quenbij chewa com je' wnak jc'ola yatanak chca arj-e' c'o chna más nyataja chca, per je' wnak jmajo'n achnak yatanak chca per nquech'ob chc'ola yatanak chca jara' nelsasa chca. Cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Xumaj chic tzij Jesús y cawra xbij: —Je rgobierno Dios cara' rbanic ajni' nuban jun acha tak nba pe rchinoj, neretca' jle' ija'tz chpam. ");
INSERT INTO tzjE_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tak noca ak'a' c'o chic ja' acha pruchoch y nwara. Tak neskera nyictaj ela, y ncara' nuban njelal k'ij. Ija'tz jretcon cana pe rchinoj ejkal nel ta ruyon y remjon c'yinem. Per acha majo'n rutkin ta nak nuban ija'tz tak nel ta y nq'uiya. ");
INSERT INTO tzjE_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jruch'lew arja' nesmaja che ntz'u'c ta ija'tz y nwachina. Jnuban nabey mul ntz'u'c ta, ejkal nwankera ruxak, c'jara' nwankera och' tzrij y nq'uiya och' y noca áj. ");
INSERT INTO tzjE_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tak nechkija, ja' acha nerebna' jach' com xerla' tiemp rxin csech. Cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Cawra xbij chic: —¿Abar c'a njumsas wa' rgobierno Dios y nak c'ambal tzij quencsaj che rjumsic? ");
INSERT INTO tzjE_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Je rgobierno Dios cara' rbanic ajni' rbanic jun rk'arwech mostaza tak nti'ca pnulew. Jun ch'it rk'arwech mostaza mesque ne ch'it no'y chwech jle' chic ija'tz jc'ola chwech ruch'lew ");
INSERT INTO tzjE_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","per tak nti'ca y tak nq'uiya per nmás nq'uiya que chwech jle' chic tejco'n, nwankera nmak tak ruk'a' y tak nq'uisbena nquepeta je' tz'quin, necrebna' quesoc ptak ruk'a' y nquemujaxa rmal ruxak. Cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Q'uiy rwech je' c'ambal tzij xbij Jesús ajni' jawrara che xertojbej je' wnak tzrij rtzojbal Dios. Ajni' nquecwina nch'obtaja cmal jara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Majo'n achnak xbij chca mquita pc'ambal tzij xbij wa'. Per jxuban chca rdiscípulo xeryonaj y xk'alsaj chquewech njelal je nbij c'ambal tzij. ");
INSERT INTO tzjE_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jara' k'ij tak xoca ak'a' cawra xbij Jesús chca rdiscípulo: —Jo' pjupraj ya'. ");
INSERT INTO tzjE_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Arj-e' xecbij cana quebi' chca wnak. Jesús arja' c'ola chpam lanch y xquec'om ela, y c'ola jle' lanch xetre' ela tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Per chek q'uenjlal tak xkaj ta jun nimlaj k'ek' chquij. Je nmak tak bloj congan npuwij ri' tzrij lanch abar c'o wa' Jesús y congan ya' noca chpam. ");
INSERT INTO tzjE_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús arja' pe rchak lanch c'o wa', kanak chuwram y rcanon jun rch'quetwi'. J-e' rdiscípulo xquec'as: —Maestro ¿tak majo'n cas ay-on chka xyamer nokba pya'? Cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús xyictaja y xbij tzra k'ek' chnetne'a y xbij tzra ya' chjun nec'je' wa'. C'jara' xcoma k'ek' y xjun xec'je' wa' ya'. ");
INSERT INTO tzjE_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","C'jara' xbij chca: —¿Nak tzer c'a tak congan xexibej ewi'? ¿Abar tzra' xoc wa' yukbal ec'u'x wq'uin? cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Arj-e' congan cxiben qui' y cawra xquemaj rbixic chbil tak qui': —¿Nak rbanic c'ala' jala acha? Nnimax tak wan rmal k'ek', nnimax tak chka' rmal ya', cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tak xe'ekaja pjupraj chic ya', tzra' xe'ekaj wa' chpam jun lwar jc'ola pquecwent aj Gadarenos. ");
INSERT INTO tzjE_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","C'xel ela Jesús chpam lanch c'ola jun acha xekaja ruq'uin ocnak itzel espíritu pranm, arja' pnexti' elnak el wa'. ");
INSERT INTO tzjE_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ne tzra' c'o wa' pnexti' per next jun wnak necwina tzrij mesque nquebac' tzra cadena. ");
INSERT INTO tzjE_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Com arja' q'uiylaj mul bnon tzra bc'on ruk'a' rkan pcadena per nmajo'n pen nutaj ta che nq'uiekpij ela. Nmajo'n nak necwina tzrij che nchapbexa rxin ch-utz c'ara' jun nec'je' wa'. ");
INSERT INTO tzjE_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Che pk'ij chak'a' nbina ptak k'ayis ruq'uin pnexti', congan nurak ruchi' y ruyon nusoc ri' tzra abaj. ");
INSERT INTO tzjE_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tak xutz'et pona Jesús xba alnak ruq'uin, tak xekaja ruq'uin xexque'a chwech, ");
INSERT INTO tzjE_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","xumaj rakic ruchi' y cawra xbij tzra Jesús: —Jesús, atet je at Rlec'wal nimlaj Dios ¿nak nawajo' chwa? Chwech Dios quenbij chawa, mtaban ta lowlo' chwa, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Cara' xbij tzra com Jesús xbij tzra itzel espíritu jocnak ruq'uin acha che nel ela pranm. ");
INSERT INTO tzjE_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","C'jara' Jesús xc'axaj tzra acha: —¿Nak abi'? Ja' cawra xbij tzra Jesús: —Anen en Legión. Cara' nubi' com ok q'uiy. ");
INSERT INTO tzjE_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Y congan xucsaj rchuk'a' che nc'utuj tzra Jesús chmajo'n nquerelsaj el ta itzel tak espíritu y mtquerutak el ta chpam jun chic lwar. ");
INSERT INTO tzjE_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ec'ol c'a jle' a'k quemjon w-im ptak k'ayis. ");
INSERT INTO tzjE_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jitzel tak espíritu congan xquecsaj cchuk'a' che xecc'utuj tzra Jesús jawrara: —Ko'atka' ela cuq'uin jle' a'k la, tey-a' c'as chka che nokoca chquepam, cara' xecc'utuj. ");
INSERT INTO tzjE_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ja' Jesús xuya' c'as chca chcara' nqueban, xe'el ela y xe'oca chquepam je' a'k. Ec'ola la e c-e' mil quebnon che conjelal a'k, y xe'oca itzel tak espíritu chquepam. Arj-e' nalnak xeba, xexle'a chwech jun jyu' per congan tectic, y q'ue pya' xeba wa' y xq'uis kaja quexla' pya'. ");
INSERT INTO tzjE_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Je chajinel cxin a'k arj-e' xenanmaj ela y arj-e' xequechlo' pe tnamet y ptak aldea je xbantaja. Je' wnak tak xecc'axaj arj-e' xepeta che rtz'etic je xbantaja. ");
INSERT INTO tzjE_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tak xerkaja abar c'o wa' Jesús xquetz'et acha jcongan itzel tak espíritu e'ocnak pranm jxuban cana, arja' tzra' tz'bul wa', chka' c'o chic retziak recsan, kas tz'kat chic rna'oj. J-e' wnak tak xquetz'et congan xecxibej qui' rmal. ");
INSERT INTO tzjE_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","C'jara' je xetz'towa je xbantaja arj-e' xquemaj rcholic chquewech nic'aj chic wnak nak xuban acha tak xelsasa je' itzel tak espíritu pranm y nak xqueban a'k chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","C'jara' je' wnak cawra xecbij tzra Jesús: —Catel ela wawe', tey-a' cana jawra lwar, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kas noca Jesús chpam lanch tak xpeta acha jxelsasa itzel espíritu pranm, cawra xbij tzra Jesús: —Tebna' jun utzil, tey-a' c'as chwa chquentre' ela chawij junlic. ");
INSERT INTO tzjE_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per Jesús majo'n xrajo' ta chnetre' ela tzrij, y cawra xbij tzra: —Jnaban camic jat pnawuchoch, abij chca awch'alal che ajni'la nimlaj samaj xuban Dios chpam ac'aslemal y ajni'la xpoknaj awech, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","C'jara' xba ja' acha ptak tnamet jc'ola precwent Decápolis, xumaj rbixic nimlaj samaj jxuban Jesús chpam rc'aslemal, y conjelal wnak congan xel ta canm tak xecc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ja' Jesús xemloj chic jmul planch pjupraj ya'. Tak xekaja congan e q'uiy wnak xequemlo' qui' ruq'uin y tzra' xec'je' wa' chiya' cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","C'jara' c'ola jun acha xpeta Jairo rubi', arja' jun chca jefe rxin jay rxin molbal ri'il jabar nc'axax wa' rtzojbal Dios. Ja' Jairo tak xerkaja ruq'uin Jesús xexque'a chwech, ");
INSERT INTO tzjE_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","cawra xbij tzra: —C'ola jun nmi'al cmic nuban, tebna' jun utzil jo' chwij, ay-a' ak'a' pe rwá' ch-utz c'ara' nec'choja, y wutkin chmajo'n ncom ta. ");
INSERT INTO tzjE_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ja' Jesús xexbilaj ela acha y congan e q'uiy wnak xetre' ela tzrij, congan nquepitz' qui' ebnak tzrij pruchoch Jairo. ");
INSERT INTO tzjE_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","C'ol c'a jun ixak yawa' jc'ola chquecjol wnak, xuban c'a cbeljuj juna' rkajben jun yubil chcongan quic' nela tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ja' ixak bnak chic cuq'uin e q'uiy doctor, congan pen retjon com xuq'uis njelal achnak jc'ola ruq'uin rmal yubil. Per nmajo'n xoc wa' jxuban com yubil chkajni' bnak pnim. ");
INSERT INTO tzjE_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Com ja' ixak kanak chic rbixic ruq'uin njelal jnuban Jesús rmal c'ara' chkajni' xki'l oca ruq'uin. Tak xekaja ruq'uin xuchap oca jtz'it retziak. ");
INSERT INTO tzjE_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Cara' xuban com cawra nuch'ob kaja pranm: —We xtencwina xtenchap jtz'it retziak Jesús xruq'uin ra' quenc'choja. ");
INSERT INTO tzjE_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Njara' hor xuchap oca retziak Jesús xetne'a quic' tzra y xuna' che xchumtaja, xela yubil tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús xuna' chc'ola poder xel ela ruq'uin. Je' wnak ncongan queptz'on qui' tzrij per ja' xuya' volt y cawra xc'axaj: —¿Nak wnak xechpowa netziak? ");
INSERT INTO tzjE_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","C'jara' e rdiscípulo cawra xecbij tzra: —Per congan wnak queptz'on qui' chawij. ¿Nak tzer c'a xawc'axaj nak wnak xechpowa atziak? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per Jesús kas chulaj xba rk'arwech, ncanoj nak xechpowa retziak. ");
INSERT INTO tzjE_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ixak congan nberbeta rmal xben ri'il com arja' rutkin che xel ela yubil je rc'an, xpeta y xexque'a chwech Jesús, xuchol tzra njelal jrebnon pruk'a' yubil. ");
INSERT INTO tzjE_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Cawra xbixa tzra rmal Jesús: —Nmi'al, jyukbal ac'u'x wq'uin jara' xchumsana awxin. Camic utz chic ncatba y catquicota, xattotaja junlic pruk'a' yubil, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ja' Jesús c'remjon na tzij tak ec'ola jle' wnak xerkaja, e'elnak ta pruchoch jefe rxin jay rxin molbal ri'il, cawra xecbij tzra jefe: —Jairo, jami'al xcoma. ¿Nak noc chwa' chnaban molestar Maestro? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ja' Jesús chek xc'axaj jxecbij ach-i' arja' xbij tzra jefe rxin jay je rxin molbal ri'il cawra: —Mtaxibej ta awi', jnaban camic teyke'a ac'u'x wq'uin, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","C'jara' xba Jesús y xqueyon Pedro, Jacobo ruq'uin Juan je rch'alal Jacobo xeruc'om ela tzrij y majo'n xeruc'om el ta nic'aj chic. ");
INSERT INTO tzjE_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tak xekaja Jesús chruchoch jefe xerutz'et je' wnak congan lowlo' nqueban, quemjon ok'ej y congan nquerak quechi'. ");
INSERT INTO tzjE_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tak xoca pjay cawra xbij chca: —¿Nak tzra tak neban cara'? Congan nerak echi' y congan ok'ej neban. Je xten majo'n comnak ta, xwarnak. ");
INSERT INTO tzjE_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Per j-e' wnak xetzebena tzrij Jesús. C'jara' ja' Jesús xerelsaj ela conjelal wnak. Tak xelestaja rmal c'jara' xeruc'om ela redta' rute' comnak e rexbil jetrena tzrij, xe'oca abar c'o wa' comnak. ");
INSERT INTO tzjE_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ja' Jesús xuchap chuk'a' xten jcamnak y cawra xbij tzra: —Talita, cumi, cara' xbij tzra. Jawra tzij je xbij cawra nbij: —Xten, camic quenbij chawa che catyictaja. ");
INSERT INTO tzjE_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chek xbitaja rmal Jesús xyictaja xten y xumaj binem. Ja' xten cbeljuj chic rjuna'. Je c'ola ruq'uin Jesús congan xel ta canm tzrij je xbantaja chquewech. ");
INSERT INTO tzjE_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ja' Jesús congan xbij chca chmajo'n abar necbij wa' je xbantaja y cawra xbij chic chca: —Tey-a' rway xten. ");
INSERT INTO tzjE_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ja' Jesús xel ela xba chpam retnamet y xeba rdiscípulo tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tak xerla' xlanbal k'ij xoca chpam jay rxin molbal ri'il, xumaj ctojxic wnak. E q'uiy wnak xec'axana tijonem jxuya' y congan xel ta canm tak xecc'axaj, cawra xecbij chbil tak qui': —¿Abar tzra' xrutkij wa' jala' acha q'uiy tak achnak? Congan tak wan na'oj yatanak tzra y congan tak wan nmak tak milagro nuban chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Per ¿mja' tc'ala' jsoy che' jral María? Y je' rch'alal ¿lme j-e' tc'ara' Jacobo, José, Judas ruq'uin Simón? Y je' rana' ¿lmec'o tc'a wawe' chkacjol chka'? Cara' xecbij com nmajo'n cgan tzrij Jesús, xe pkan nquena' rmal je nbij. ");
INSERT INTO tzjE_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús cawra xbij chca: —Nmajo'n jun profeta rxin Dios mquita lok' ntz'e'ta, per xerwara' majo'n lok' ta ntz'e'ta cmal rwinak next c'a cmal rch'alal next c'a jec'ola pruchoch chka', cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nmajo'n xecwin ta xuban nmak tak milagro tzra', xerwara' ec'ola jujun yuw-i' xuya' ruk'a' pquewá' y xec'choj cana. ");
INSERT INTO tzjE_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ja' junwa' xuna' rmal jmajo'n yukbal quec'u'x rwinak ruq'uin. C'jara' xel ela, xba ptak aldea jc'ola chenkaj y xumaj ctojxic wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ja' Jesús xersiq'uij e cbeljuj rdiscípulo y xuya' chca chc'ola quek'a' chquij itzel tak espíritu che nquequelsaj ela pcanm wnak. Pcaca' xerutak ela y xuch'ob ela chquewech nak nequebna': ");
INSERT INTO tzjE_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","—Tak xtquixba majo'n achnak nec'om ela, xruyon ech'me'y newc'aj. Majo'n eway majo'n emlet nec'om el ta, next pak chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Xperpak je' xjab necsaj ela, majo'n newc'aj xta jle' ecmis, xruyon jara' newc'aj jecsan. ");
INSERT INTO tzjE_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Chka bechnak opech jay nquixoc wa', tzra' nquixec'je' wa' y c'jara' neya' cana tak nquixba chpam jun chic tnamet. ");
INSERT INTO tzjE_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nak wnak majo'n xtquixruc'ul ta, nak wnak majo'n cgan tzrij jnebij chca, tak nquixel ta chpam quetnamet tquiraj cana pkok jc'ola pnewkan. Cara' neban chneyabej rital chnequetja' na lowlo' rmal jmajo'n nqueya' ta quexquin tzrij jnebij chca. Ne ktzij wa' je xtenbij chewa, tak xterla' nimlaj k'ij rxin juicio ajni'la jun nimlaj pen xtequetja' na tnamet je mtec'luwa ewxin. Más na lowlo' pen xtquetaj que chquewech ajni' xtquetaj jitzel tak wnak aj Sodoma ruq'uin aj Gomorra ojer. Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Je cbeljuj rdiscípulo arj-e' xe'el ela, xeba cuq'uin wnak y cawra necbij chca: —Tec'xa' ena'oj y tey-a' cana rtzilal, cara' necbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","E q'uiy jitzel tak espíritu xequelsaj pcanm wnak y e q'uiy yuw-i' xqueya' aceite pquewá' y xec'choja cmal. ");
INSERT INTO tzjE_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Njelal achnak je ntajina nuban Jesús xekaja rbixic ruq'uin rey Herodes com bnak nat nkaj rtzojxic. Ja' Herodes cawra xbij: —Juan Bautista xc'astaja chquecjol cnomki' rmal c'ara' c'ola nmak tak poder je ntajina nesmaja ruq'uin camic. ");
INSERT INTO tzjE_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Per ec'ola jle' chic cawra necbij: —Jala acha jala' Elías, cara' necbij. Jle' chic cawra necbij: —Jala acha jun profeta, cara' rbanic ajni' cbanic ojer tak profeta, cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Per Herodes tak xc'axaj jnecbij wnak arja' cawra xbij chic ra: —Mcara' ta, jala acha Juan jxenya' orden che nelsasa rwá', ja' c'ara' xc'astaja chquecjol cnomki', cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Cara' xbij com arja' rutkin chja' xyowa orden che xcamsasa Juan Bautista tak xutak rchapic Juan, xxi'ma y xucsasa pcars. Cara' xuban tzra rmal je xbixa tzra rmal Juan Bautista cawrara: —Mrubey ta abnon ac'mon kaja awexnam, cara' xbij. Com ja' Herodes arja' rec'mon rexnam rbin-an Herodías, rexkayil jun rch'alal rbin-an Felipe. ");
INSERT INTO tzjE_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ja' Herodías congan penak ryiwal tzrij Juan, nrajo' ta ncamsaj per mtecwina ");
INSERT INTO tzjE_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","com ja' Herodes xe nxibej ri' chwech Juan com rutkin che Juan jun acha bnoy rbeyal, jun acha rxin Dios, y congan xuban cwent ch-utz c'ara' che mtcamsasa. Ja' Herodes tak nc'axaj je nbij Juan c'ola achnak nc'axaj per mesquier nekaja pe rwá' y nxibej ri' rmal, per nc'ola rgan nc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Per xerla' c'a jun k'ij tak xecwina Herodías tzrij Juan che ncamsasa. Tak ja' Herodes xuban jun nimlaj nimk'ij rxin rcumpleaño xchumij jun nimlaj w-im. Erebnon invitar je' wnak nmak quek'ij je nquesmaja chpam rgobierno e quexbil cjefe soldado, chka' e quexbil principal-i' rxin Galilea. ");
INSERT INTO tzjE_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ja' Herodes e rexbil jerebnon invitar ec'ola tzrij mes tak xekaja jun xten chquewech, ral Herodías, y xumaj xjoj chquewech. Ja' Herodes ruq'uin je' rexbil congan xel ta quec'u'x tzrij. C'jara' rey Herodes cawra xbij tzra xten: —Tc'utuj chwa nak kas nawajo' y anen quenya' chawa. ");
INSERT INTO tzjE_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Xuban jurar y cawra xbij chic tzra xten: —Chka bechnak opech xtac'utuj chwa, anen quenya' chawa y mesque nnim nic'aj ngobierno xtac'utuj jc'ola pnuk'a' quenya' chawa, cara' nbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ja' xten xel ta, xba ruq'uin rute', xerbij njelal tzra ajni' xbixa tzra rmal Herodes: —Camic ¿nak quenc'utuj tzra rey nach'ob atet? cara' xc'axaj tzra rute'. —Tbij tzra chnuya' rwá' Juan Bautista chawa, cara' xbixa tzra rmal rute'. ");
INSERT INTO tzjE_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chek xbitaja cara' tzra xten xba alnak xemloj chic jmul ruq'uin rey y cawra xbij tzra: —Camic quenc'utuj chawa per ncamic ra, tey-a' rwá' Juan Bautista chwa per tey-a' pa chwech jun plat, cara' xc'utuj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ja' rey Herodes congan junwa' xuna' per com rebnon chic jurar chquewech jec'ola ruq'uin je tz'bula tzrij mes rmal c'ara' c'o ta xrajo' mquita nuya' je xtzujuj tzra xten. ");
INSERT INTO tzjE_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Alnak xuya' orden tzra jun soldado che nerelsaj rwá' Juan Bautista y nuc'om ta. ");
INSERT INTO tzjE_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Xba ja' soldado abar tzra' c'o wa' Juan pcars y xkupij rwá'. Tak xkuptaja rwá' xuc'om ta chwech jun plat y xrejcha' tzra xten y ja' xten xujach tzra rute'. ");
INSERT INTO tzjE_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Je rdiscípulo Juan tak xecc'axaj che xcamsasa, arj-e' xeba xequec'ma' ta recuerpo y xquemuk. ");
INSERT INTO tzjE_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Xemloj ta je cbeljuj apóstol xecremlo' qui' ruq'uin Jesús, xquechol tzra njelal jxequebna' y njelal tijonem je xqueya' chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús arja' cawra xbij chca: —Jo' kyonaj ki' chpam jun lwar kas tlena y quixexle'na jun rmaj. Cara' xbij chca com congan je' wnak nque'epona y nquejal qui' cuq'uin y nmajo'n nqueya' ta c'as che nquewa'a. ");
INSERT INTO tzjE_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","C'jara' xe'oc ela chpam jun lanch, xecyonaj qui' chpam jun lwar kas tlena abar e majo'n wa' wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Per tak xeba e q'uiy wnak xetz'tow ela cxin, xch'obtaja cmal che Jesús xba. Xe'el ela wnak ptak quetnamet per ne njelal tnamet, xeba che ckan per nalnak xeba y xe'ekaja nabey mul abar tzra' nque'ekaj wa' Jesús, tzra' quemlon chwa' qui' che rc'ulic. ");
INSERT INTO tzjE_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ja' Jesús tak xel ta chpam lanch xerutz'et wnak chcongan e q'uiy. Arja' xpoknaj quewech com j-e' e ajni' jle' carne'l jmajo'n nyuk'una cxin. C'jara' xumaj ctojxic, q'uiy rwech tijonem xuya' chca. ");
INSERT INTO tzjE_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tak xba hor xepeta rdiscípulo y cawra xecbij tzra: —Je lwar abar okc'o wa' congan tlena y xba hor. ");
INSERT INTO tzjE_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Je nkaban camic, quekatka' ela wnak ptak tnamet ruq'uin ptak aldeas jc'ola chenkaj y tbij chca che tzra' nequelk'o' wa' je' achnak je xtquetaj, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Ixix nquixyowa chca nak xtquetaj, cara' xbixa chca rmal Jesús. —Xtkalok' ta c-e' cient ctzal way ¿le nqueruban c'ara' conjelal wnak? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—Etz'ta' nc'a ajru' rkan xquelway ec'mon ta, cara' xbixa chca rmal Jesús. Tak xquetz'et cawra xecbij tzra Jesús: —J-o' rkan xquelway ruq'uin c-e' rkan ch'u'. ");
INSERT INTO tzjE_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","C'jara' Jesús cawra xbij chca: —Tbij chca conjelal wnak quetz'be'a pe rwá' rex tak k'ayis y ptak mocaj cc'aj qui', cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","J-e' wnak xetz'be'a y ptak mocaj xec'je'a, c'ola mocaj xec'je'a jun cient y c'ola e cincuenta xecc'aj qui'. ");
INSERT INTO tzjE_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ja' Jesús xuc'om j-o' rkan xquelway ruq'uin c-e' rkan ch'u', xca'ya chcaj y xmeltioxij tzra Dios. Xuwech' xquelway, xujach chca rdiscípulo che j-e' nqueya' chic chca wnak. Cara' xuban tzra c-e' rkan ch'u' chka', xujach chquewech conjelal wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Xewa'a per ne che conjelal xnoja quepam. ");
INSERT INTO tzjE_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Je xquelway rexbil ch'u' xmol ruchi' je xcoltaj cana, cbeljuj chquech xuban, per nnojnak. ");
INSERT INTO tzjE_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jxewa'a e j-o' mil per xqueyon ach-i'. ");
INSERT INTO tzjE_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","C'jara' Jesús cawra xbij chic chca rdiscípulo: —Npors nquixoc ela chpam lanch, nquixba pjupraj ya' chpam tnamet Betsaida, cara' xbij. Y xbij cana rubi' chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tak xbitaj cana rubi' rmal, arja' xojte'a chwech jyu' y xuwil jun lwar abar nuban wa' oración. ");
INSERT INTO tzjE_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tak xoca ak'a' xruyon c'ola tzra' y jlanch xepona pe nc'aj ya'. ");
INSERT INTO tzjE_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Arja' xerutz'et pona chcongan xetaktu'a rmal s-oj com c'ola jun nimlaj k'ek' kanak ta chquij. Je pe rsakric remjon binem pe rwá' ya' ja' Jesús y xekaja chenkaj ruq'uin lanch. Arja' xrajo' ta xk'axa chquewech rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Per tak xquetz'et chremjon binem pe rwá' ya' xquech'ob j-e' xjun xbinel quemjon rtz'etic y congan xquemaj rakic quechi', ");
INSERT INTO tzjE_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","com conjelal xquetz'et y congan xecxibej qui' rmal. Ja' Jesús cawra xbij chca: —Tyukba' ec'u'x, xanen, mtexibej ta ewi', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","C'jara' xoca cuq'uin planch y xcoma k'ek'. J-e' c'a discípulo congan xel ta quec'u'x tzrij je xquetz'et jxuban Jesús chquewech y xsa'cha cna'oj rmal. ");
INSERT INTO tzjE_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Cara' xqueban com j-e' majo'n xch'obtaj ta cmal jpoder jc'ola ruq'uin ja' Jesús mesque quetz'ton chic jnimlaj milagro jxuban tzra xquelway tak xerutzuk e j-o' mil ach-i'. Congan pen chca nquech'ob nak rbanic Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Xeba y xekaja pjupraj ya' chpam jun lwar rbin-an Genesaret. ");
INSERT INTO tzjE_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Chek xe'el ta planch, je' wnak alnak xquetzu' che Jesús xekaja cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","C'jara' xeba cuq'uin conjelal wnak jec'ola chpam jara' lwar y xmajtaj ta cc'omric je' yuw-i' chwech Jesús. Chka bechnak lwar opech nekaj wa' Jesús, je' wnak tak necc'axaj nquequec'om ela je' cyuw-i', nquectelej ela rexbil cwarbal. ");
INSERT INTO tzjE_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Chkabar opech nekaj wa' Jesús, we chpam nmak tak tnamet, we pcocoj tak tnamet, we ptak aldea, je' wnak jec'ola yuw-i' cuq'uin arj-e' xequelsaj ta, xequeya' ta chi' tak bey jabar nk'ax wa' Jesús, y cawra necbij tzra: —Tebna' jun utzil chka, tey-a' c'as chca yuw-i' che nquechap oca jtz'it atziak, xe jtz'it opech ruchi' nquechap oca, cara' xecbij tzra. Y cara' xqueban, conjelal je nquechpowa retziak nquechumtaja. ");
INSERT INTO tzjE_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ec'ol c'a jle' aj fariseo xequemlo' qui' ruq'uin Jesús e quexbil jle' maestro je nquetijona cxin wnak tzrij rley Dios jtz'ibtanak cana rmal Moisés, arj-e' epenak pJerusalén. ");
INSERT INTO tzjE_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Arj-e' xequetzu' rdiscípulo Jesús che ec'ola chca tak xquemaj w-im majo'n xquech'aj ta quek'a' ajni' nrajo' ccostumbre che nqueban. Rmal c'ara' j-e' aj fariseo e quexbil maestro arj-e' xquemaj ctzojsic discípulo. ");
INSERT INTO tzjE_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Com aj fariseo y conjelal aj Israel wmajo'n nqueban ta costumbre tzrij ch'joj k'baj je c'tun cana chquewech cmal cti't quewma' jara' majo'n nquewa' ta. ");
INSERT INTO tzjE_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tak nquemloj ta ptak q'uebal nmajo'n nquewa' ta chka' wmajo'n nqueban ta ccostumbre je nquech'ach'jorsbej qui'. Y c'c'o na más ccostumbre cniman j-e', c'ola costumbre rxin ch'joj vas, ch'joj tak xar, ch'joj tak tzacbal je' achnak ch'ech' ocnak y tzra je' ch'at chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","J-e' c'a aj fariseo e quexbil maestro cawra xecc'axaj tzra Jesús: —¿Nak tzra tak je' adiscípulo majo'n necnimaj ta costumbre cxin kti't kawma'? Nquewa' tak wan per nmajo'n nqueban ta costumbre rxin ch'joj k'baj, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús cawra xbij chca: —Caca' eplaj, tkala chewij jbin ta chewa ojer rmal profeta Isaías jcawra tz'ibtal cana: —J-ewra wnak ra nquechi' oca necyabej nuk'ij per canm q'ue c'nat c'o wa' chenwech. ");
INSERT INTO tzjE_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nmajo'n noc wa' jnecyabej nuk'ij, jtijonem nqueya' rtzojbal Dios cara' necbij tzra, per xmandamiento cxin wnak. Cara' bin ta chewa rmal Isaías. ");
INSERT INTO tzjE_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jebnon, ey-on cana rmandamiento Dios y xe ccostumbre wnak ey-on ruk'ij, je' costumbre ajni' tzra ch'joj tak xar, ch'joj tak vas ruq'uin jle' chic costumbre je junam ruq'uin jawrara, cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Cawra xbij chic chca: —Ixix congan ix list che rq'uexic rmandamiento Dios ch-utz c'ara' ecostumbre ixix necsaj kaja prec'xiwach. ");
INSERT INTO tzjE_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Com Moisés arja' c'ola jun rmandamiento Dios rtz'iban cana jcawra nbij: —Lok' que'an-a' adta' ate'. Jun chic je rtz'iban cana jcawra nbij: —Wc'ola jun itzel ntzijona tzrij redta' o rute' jara' pors ncomsasa, cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Per ixix xmajo'n lok' ta nque'ena' com xcawra tijonem neya': —Wnabij tzra adta' o wate': —Camic mesquier quencwina catnuto' tzrij je' achnak je nc'atzina chawa com nbin chic tzra Dios che rxin chic arja' jc'ola wq'uin, wcara' nabij tzra, jara' majo'n chic nc'atzin ta chnato' tzrij je' achnak je nc'atzina tzra, cara' nebij. ");
INSERT INTO tzjE_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Cara' ebnon, je rmandamiento Dios ebnon tzra com ajni' majo'n per xe rmal ecostumbre, y jara' costumbre nec'ut chic chquewech jle' chic wnak che necnimaj chka'. Y cara' neban tzra nic'aj chic achnak. Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ja' Jesús xumaj chic tzij cuq'uin wnak y cawra xbij chic chca: —Tewc'axaj che ixconjelal je xtenbij chewa ra, xtch'obtaj ta ewmal. ");
INSERT INTO tzjE_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mjara' ta noc ela pnachi' je ntz'ilorsana rwech awanm per je ntz'ilorsana rxin jara' je nwanker ta chpam awanm y nel ta pnachi'. ");
INSERT INTO tzjE_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wc'ola ewexquin tewc'axaj c'a jquenbij, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","C'jara' xbij cana rubi' chca wnak y xoca pjay. Je' rdiscípulo xecc'axaj tzra nak rbanic jc'ambal tzij je xbij kaja. ");
INSERT INTO tzjE_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Cawra xbij chca: —Tak mesquier nch'obtaja ewmal ixix chka'. ¿Le mtch'obtaj c'a ewmal che je' achnak jnoca pnachi' jara' majo'n xtitz'ilorsaj ta awanm? ");
INSERT INTO tzjE_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Cara' quenbij chewa com je' achnak je noca pnachi' jara' chapam nkaj wa' y nel el chic jmul, cara' xbij chca. Je xbij Jesús chmajo'n ntz'ilor ta awanm rmal je' achnak jnataj chka bechnak opech nataj. ");
INSERT INTO tzjE_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Cawra xbij chic jmul chca: —Je rtzilal je nel ta pnawanm jara' ntz'ilorsana rxin awanm. ");
INSERT INTO tzjE_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Cara' quenbij chewa com pnawanm nwanker twa' je' itzel tak na'oj ajni' tzra tak ncatoca ruq'uin jun ixak jme awexkayil ta o ajni' tzra jun ixak noca ruq'uin jun acha je mrechjil ta, ajni' bnoj cmic, ");
INSERT INTO tzjE_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ajni' tzra bnoj alak', ajni' tak nayarij je' achnak cxin nic'aj chic wnak, ajni' bnoy tak rtzilal, ajni' bnoj engaño, ajni' naban je' achnak jcongan chuw chwech Dios, ajni' nk'utlina awanm tzrij jun wnak, ajni' tzra mloy tak tzij, ajni' tzra ajni'la nana' kaja, ajni' tzra tak naban je' achnak y majo'n nach'ob ta ruq'uin Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Njelal jawra ptak canm wnak nalex wa' y jawra ntz'ilorsana rxin canm. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","C'jara' xyictaj ela, xel ela chpam lwar y xba chpam jun lwar chic abar c'o wa' c-e' tnamet, jun Tiro rubi' y jun chic Sidón rubi'. Tak xekaja xoca chpam jun jay y me trajo' che notkixa che tzra' c'o wa' per je' wnak npors xcutkij chc'ola tzra'. ");
INSERT INTO tzjE_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","C'o c'a jun ixak jme aj Israel ta, arja' alexnak chpam jun lwar rbin-an Sirofenicia, c'ola jun ch'it ral xten ocnak jun itzel espíritu pranm. Ja' ixak tak xc'axaj abar c'o wa' Jesús xba ruq'uin. Tak xekaja ruq'uin xexque'a chwech y congan xc'utuj che nba ruq'uin y nerelsaj jitzel espíritu jc'ola pranm ch'it ral. ");
INSERT INTO tzjE_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús xucsaj c'ambal tzij chwech ixak y cawra xbij: —Nabey mul quenuto' na je' nwinak aj Israel com me rbeyal ta xtenc'om ta queway alc'walxela' y xtench'akij ta chquewech ch'tak ral tz'e', cara' xbij Jesús tzra ixak. ");
INSERT INTO tzjE_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ja' ixak chka' chek xec'choja tzij rmal Jesús cawra xbij tzra: —Wajaw, ne ktzij wa' nabij per chka' je' ch'tak ral tz'e' je nquec'je' oca xe' mes, arj-e' nya'a c'as chca che nquetaj ruc'aj tak way cxin alc'walxela' je ntzak ela xe' mes, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Cawra xbixa tzra rmal Jesús: —Congan wen xabij chwa, camic quenbij chawa, catemloja pnawuchoch, camic xel ela itzel espíritu pranm awal, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","C'jara' xemloja ja' ixak chruchoch. Tak xekaja ruq'uin ral ctz'ela chwech ch'at y majo'n chic itzel espíritu pranm. ");
INSERT INTO tzjE_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","C'jara' xba Jesús, xel ela chpam je' lwar jc'ola precwent Tiro y xk'axa ptak lwar jc'ola precwent Sidón y xk'axa chka' ptak lwar jc'ola precwent Decápolis, xekaja chuchi' ya' rbin-an Galilea. ");
INSERT INTO tzjE_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","C'ol c'a jun acha xeya'a chwech, jara' acha tcon y majo'n kas ta necwina ntzijona chka'. Jec'amyon ela rxin xecc'utuj jun utzil tzra Jesús chnuya' ruk'a' pe rwá' acha che nchumsaj. ");
INSERT INTO tzjE_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ja' Jesús xelsaj ela acha chquecjol wnak, xecyonaj qui' ruq'uin. C'jara' xuya' oca ruruk'a' ptak rexquin acha, xchubana y xuchap rkan rak' acha chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","C'jara' xca'ya chcaj, congan njek'jota y cawra xbij tzra: —Efata, cara' xbij tzra. Je pe rtzojbal acha efata nbij tzij tjaktaja awexquin. ");
INSERT INTO tzjE_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tak xbitaja cara' rmal xjaktaja rexquin acha y xec'choja rkan rak' y necwin chic ntzijona. ");
INSERT INTO tzjE_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ja' Jesús congan xbij chca wnak chmajo'n abar necbij wa' jxuban tzra acha. Per je' wnak majo'n xecnimaj ta tzij mesque congan xek'i'la rmal Jesús che mtquelsaj ta rbixic. ");
INSERT INTO tzjE_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Arj-e' congan xel ta quec'u'x tak xquetz'et milagro jxuban Jesús chquewech y cawra necbij ra: —Ja' Jesús congan wen njelal jrebnon. Nujak tak wan quexquin tcon y nuya' quetzij mema' chka', cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jara' tiemp congan e q'uiy wnak quemlon qui' ruq'uin Jesús y majo'n queway quec'mon ta. Jesús arja' xersiq'uij pona rdiscípulo y cawra xbij chca: ");
INSERT INTO tzjE_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Congan quenpoknaj quewech wnak, xuban oxi' k'ij ec'ola wq'uin y majo'n chic achnak nquetaj. ");
INSERT INTO tzjE_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","We xtquenutak ela ptak cuchoch y majo'n achnak nquetaj ela jara' bien wutkin che nquetke'a pbey. Ec'ola nic'aj chca congan c'nat epenak wa', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Je rdiscípulo cawra xecbij tzra: —Jawra lwar abar okc'o wa' congan tlena ¿abar c'a nekac'ma' wa' je xtquetaj wnak? cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","¿Ajru' rkan xquelway c'ola ewq'uin? cara' xc'axaxa chca rmal Jesús. —Wku' rkan, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ja' Jesús xbij chca wnak che nquetz'be'a ptak ulew. C'jara' xuc'om wku' rkan xquelway, xmeltioxij tzra Dios, xuwech' y xujach chca rdiscípulo che nqueya' chca wnak y cara' xqueban xqueya' chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Chka' ec'ola c-e' oxi' rkan ch'u' e ch'tak no'y. Ja' Jesús xmeltioxij tzra Dios y xbij che nya'a ch'u' chca wnak chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Xewa'a wnak y xnoja quepam. Je xquelway rexbil ch'u' xmo'la ruchi' je xcoltaj cana, wku' chquech xuban per nnojnak. ");
INSERT INTO tzjE_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jxewa'a ec'ola la e cji' mil. C'jara' Jesús xbij cana rubi' chca. ");
INSERT INTO tzjE_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Xoc ela planch e rexbil rdiscípulo, xeba ptak lwar jc'ola precwent Dalmanuta. ");
INSERT INTO tzjE_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tak xe'ekaja ec'ola jle' fariseo xe'ekaja ruq'uin ja' Jesús. Arj-e' xquemaj tzij ruq'uin per xe nquech'ojquina ruq'uin. C'ola je' achnak necc'axaj tzra per xa probar nqueban tzra y cawra necbij tzra: —Tebna' jun milagro rxin chcaj jnac'utbej chkawech che Dios yoyona chawa jpoder c'ola awq'uin, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ja' Jesús tak xc'axaj je xbixa tzra, arja' congan xbisona cmal y cawra xbij chca: —¿Nak tzra ixix jixc'ola chpam jawra tiemp nec'utuj jun milagro chwa y xa probar neban chwa? Ne ktzij wa' je xtenbij chewa, ixix jixc'ola chpam jawra tiemp majo'n milagro xtenban ta chewech ajni' nec'utuj chwa, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tak xbitaja cara' rmal xeruya' cana, xe'oc el chic jmul chpam lanch, xeba chic pjupraj ya'. ");
INSERT INTO tzjE_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ebnak chic planch. Je rdiscípulo Jesús arj-e' majo'n queway cc'an ta, xecmestaj cana, xjun rkan xquelway cc'an. ");
INSERT INTO tzjE_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ja' Jesús cawra xbij chca: —Kas bien tech'bo', kas tebna' cwent ewi' chwech levadura cxin aj fariseo y chwech chka' levadura rxin Herodes, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Je' rdiscípulo xquemaj je' tzij chbil tak qui' y cawra xecbij: —Cara' nbij chka rmal jmajo'n way xkac'om ta, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ja' Jesús rutkin chic je nquech'ob j-e' che xlevadura rxin xquelway nnataxa chca per je nnataxa chca jara' tijonem cxin aj fariseo y rxin Herodes, cawra xbij chca: —¿Nak tzra tak nebij: —Tak majo'n way xkac'om ta? ¿Mja'n c'ara' tch'obtaja ewmal? ¿Mja'n c'ara' tekaj pnewá' nak rbanic? ¿Lcongan pen rch'obic nak rbanic? ");
INSERT INTO tzjE_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","C'ola ek'awech. ¿Le mtetz'et c'a je nc'u'ta chewech? Chka' c'ola ewexquin. ¿Le mtoc c'a chpam ewexquin je nbixa chewa? Chka' ¿le mterkaj c'a pnewá' tak xenwech' j-o' rkan xquelway y xenutzuk e j-o' mil wnak tzra? ¿Ajru' chquech xcoltaj cana jxemol ruchi'? cara' xc'axaj chca. —Cbeljuj chquech, cara' xecbij j-e'. ");
INSERT INTO tzjE_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ja' Jesús cawra xbij chic chca: —Tak xenutzuk chic e cji' mil wnak tzra wku' rkan xquelway ¿ajru' chquech xcoltaj cana jxemol ruchi'? cara' xc'axaj chca. —Wku' chquech, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—Per ¿nak tzer c'a q'uemjana tch'obtaja ewmal nak rbanic? cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tak xe'ekaja pjupraj ya' chpam jun tnamet rbin-an Betsaida c'ol c'a jun moy xeya'a chwech Jesús. Jec'amyon ela rxin moy arj-e' congan xecc'utuj tzra Jesús chnuchap moy ch-utz c'ara' nchumsaj. ");
INSERT INTO tzjE_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","C'jara' ja' Jesús xuchap kaja chruk'a' moy, xuc'om ela y xelsaj ela chpam tnamet. Tak xlestaj ela rmal chpam tnamet xuya' ruchub chi' tak rk'arwech y xuya' ruk'a' tzrij rk'arwech y cawra xc'axaj tzra: —¿Le nca'y chic jtz'it ak'awech? ");
INSERT INTO tzjE_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ja' acha xca'ya y cawra xbij tzra Jesús: —Ec'ola jle' ach-i' quenutz'et per quenutz'et pona xe ajni' jle' che' quemjon binem, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","C'jara' ja' Jesús xuya' chic jmul ruk'a' tzrij rk'arwech acha. Ja' acha xera' xch'ulchij je' achnak y xca'ya junlic, nutzu' chic njelal achnak. ");
INSERT INTO tzjE_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ja' Jesús cawra xbij tzra: —Jat pnawuchoch per mtcatoc ta chpam tnamet y majo'n abar nabij wa' jxenban chawa, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","C'jara' ja' Jesús e rexbil rdiscípulo xeba ptak aldea jc'ola chenkaj tnamet Cesarea jc'ola precwent Filipo, kas quemjon binem tak cawra xc'axaj chca: —Anen ¿nak nbanic necbij wnak chwa? cara' xc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ec'ola nquebina chawa che atet at Juan Bautista, jle' chic necbij che atet at Elías, ec'ola jle' chic necbij chawa che atet at jun chca e ojer tak profeta, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Jixix ¿nak nbanic nech'ob? cara' xc'axaj chca. Pedro cawra xbij tzra: —Atet at Cristo je atch-on rmal Dios, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ja' Jesús congan xbij chca chmajo'n abar necbij wa' chja' Cristo. ");
INSERT INTO tzjE_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","C'jara' xumaj rk'alsic chquewech rdiscípulo nak xteba'na tzra, cawra xbij chca: —Anen en Alc'walxel jxenoca alxic cuq'uin wnak, q'uiy rwech pen quentaj na, xitzel quenquetz'et principal-i' rxin tnamet e quexbil cjefe sacerdote, chka' e quexbil maestro je nquetijona cxin wnak tzrij rley Dios, quencamsas na y chrox k'ij quenc'astaja, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Arja' bien xuch'ob chquewech che nba'n na cara' tzra. Pedro arja' xkubsaj ta Jesús ruq'uin y congan cow xuchap tzan rutzij. ");
INSERT INTO tzjE_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Per Jesús tak xc'axaj je xbixa tzra rmal Pedro arja' xuya' volt, xertz'ulchij pona je' rdiscípulo y cow xuchap Pedro tzan rutzij y cawra xbij: —Catel ela chenwech Satanás. Cara' quenbij chawa com mcara' ta nawajo' chwa chquenban ajni' nrajo' Dios chwa chquenban, xjunam ana'oj cuq'uin wnak, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","C'jara' ja' Jesús xersiq'uij pona rdiscípulo e quexbil jle' chic wnak jec'ola tzra', cawra xbij chca: —Nak wnak nrajo' neyke'a ruc'u'x wq'uin nc'atzina majo'n nuya' ta rgan je tzbuklaj c'aslemal je rc'an. Nc'atzina chka' majo'n npoknaj ta ri' tzra nutaj pen nmal anen y netre' ela chwij. Jara' ajni' jun cruz nya'a tzrij per majo'n npoknaj ta ri' nuc'am ela cruz, ntelej ela y nba abar ncamsas wa'. ");
INSERT INTO tzjE_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Cara' quenbij chewa com nak wnak npoknaj nuya' cana rc'aslemal jara' ntz'ila' rc'aslemal je rxin junlic. Per nak wnak majo'n npoknaj ta nuya' cana rc'aslemal nmal anen y rmal utzlaj tzij jnec'mon ta jara' majo'n ntz'ila' ta rc'aslemal. ");
INSERT INTO tzjE_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Com ajni' tzra jun wnak ¿nak nuch'ec tzrij wxuch'ec njelal mibil rxin rwech ruch'lew per xtz'ila' rc'aslemal? ");
INSERT INTO tzjE_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","We xtz'ila' rc'aslemal ¿lnecwin c'ara' nlok'bej tzra rmibil? ");
INSERT INTO tzjE_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Cara' quenbij chewa com je' wnak jec'ola chpam jawra tiemp chka e bechnak wnak opech, we xq'uixbal nquena' nquetre' ela chwij y we xq'uixbal nquena' rmal ntzojbal, anen chka' q'uixbal quenna' xtquetre' ta chwij. Anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak xq'uixbal quenna' xtquetre' ta chwij tak xtenpet chic jmul e wexbil je' ángel rxin Dios y tak congan chic ruch'ab regloria Dios chwij. Je' wnak jec'ola chpam jawra tiemp arj-e' xjunwa' ykul wa' quec'u'x y mruq'uin ta Dios y congan il mac nqueban, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Cawra xbij chic chca: —Ne ktzij wa' je xtenbij chewa, ec'ola chewa jec'ola wawe' camic ra ec'as na tak xtquetz'et rgobierno Dios tak xtpeta per congan poder rc'an, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pwajki' k'ij chic ja' Jesús xeruc'om ela Pedro rexbil Jacobo ruq'uin Juan, xeba, xecyonaj qui' pe rwá' jun jyu'. Y xq'ue'xa chquewech. ");
INSERT INTO tzjE_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Retziak congan nc'ac'ot chic, congan sak sak per next jun ch'joy tziak wawe' chwech ruch'lew xtecwin ta xtuban sak tzra jun tziak ajni' xela retziak Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chek q'uenjlal tak xwankera chquewech Elías rexbil Moisés, quemjon tzij ruq'uin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro cawra xbij tzra Jesús: —Maestro, congan qui'il jokc'o wa'. Kabna' oxi' tak jay wawe' ra, jun awxin atet, jun rxin Moisés y jun chic rxin Elías, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedro com mesquier nch'obtaja rmal, rmal c'ara' tak cara' xbij com arja' ruq'uin rexbil congan cxiben qui'. ");
INSERT INTO tzjE_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Y xpeta jle' sutz' y xermujaj y c'ola jun kul xtzijon ta chpam, cawra xbij chca: —Ja c'a wa' quilaj Wlec'wal, tey-a' ewexquin tzrij nak nbij chewa, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chek xec'choja tzij rmal ja kul, j-e' apóstol xquetz'et majo'n chic Elías y majo'n chic Moisés, xruyon Jesús c'o can chic. ");
INSERT INTO tzjE_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","C'jara' xemloj ta, kas exlen ta pe rwá' jyu' tak Jesús congan xbij chca jawrara: —Nmajo'n abar nebij wa' jxetz'et, c'jara' xtebij tak c'astanak chic chquecjol cnomki' je Rlec'walxel jxoca alxic cuq'uin wnak, cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Cara' xqueban, xe ptak canm xec'je' wa', majo'n abar xecbij wa'. Per j-e' xquemaj rc'axic chbil tak qui' rmal je xbixa chca: —¿Nak rbanic c'ara' je xbij tzrij je Rlec'walxel che nc'astaja chquecjol cnomki'? cara' necc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","C'jara' xecc'axaj tzra Jesús: —¿Nak tzer c'a je' maestro rxin ley arj-e' necbij che Elías nc'atzina che arja' npeta nabey mul chwech Cristo? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ne ktzij wa' che Elías npeta nabey mul che nerchumsaj njelal rubey Dios. Camic quenwajo' quenc'axaj chewa, je Rlec'walxel jxoca alxic cuq'uin wnak ¿nak tzra tak tz'ibtanak cana tzrij chq'uiy rwech lowlo' nutaj na y xitzel ntz'e't na cmal wnak? ");
INSERT INTO tzjE_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Per anen quenbij chewa, ja' Elías arja' penak chic per j-e' nlowlo' xqueban tzra, ajni' cgan njara' xqueban tzra. Ncara' xbantaja ajni' tz'ibtanak cana chpam rtzojbal Dios che nbantaj na, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tak xemloj ta abar ec'o cwa' jle' chic discípulo congan e q'uiy wnak xequetz'et quemlon qui' chquij discípulo. Ec'ola jle' maestro xequetz'et chka' quemjon tzij cuq'uin discípulo per xch'ojquinem quemjon rij. ");
INSERT INTO tzjE_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Je' wnak chek xquetz'et tak xpona Jesús congan xel ta quec'u'x xquetz'et y alnak xeba, xequec'lu' y xeck'ijla'. ");
INSERT INTO tzjE_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús xc'axaj chca: —¿Nak emjon rcholic cuq'uin? ");
INSERT INTO tzjE_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","C'ol c'a jun acha chquecjol je' wnak cawra xbij tzra Jesús: —Maestro, anen c'ola jun wlec'wal nec'mon ta che quenrey-a' chawech, arja' ocnak jun itzel espíritu pranm rmal c'ara' ocnak mem. ");
INSERT INTO tzjE_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Chka bechnak lwar opech c'ol wa' wlec'wal arja' nch'akixa ptak ulew rmal itzel espíritu. Nela rupluw chuchi' y congan ncach'ch'ej rey rmal. Camic nlowlo' chic, majo'n chic rchuk'a'. Xenc'utuj jun utzil chca adiscípulo che nquelsaj ela itzel espíritu per j-e' majo'n xecwin ta xquelsaj ela, cara' xbij acha. ");
INSERT INTO tzjE_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ja' Jesús tak xc'axtaja rmal je xbij acha cawra xbij: —Ixix je ix tnamet Israel ntak majo'n yukbal ec'u'x wq'uin. ¿Ajru' tiemp quenc'je'a checjol? Congan pen chwa chquencoch' más tak majo'n yukbal ec'u'x wq'uin. Camic tec'ma' ta ala' wq'uin, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","C'jara' xec'mar ela ala' chwech Jesús. Jitzel espíritu chek xutz'et Jesús xuya' chic jun ataque tzra ala' y xch'akij penlew. Ja' ala' congan xumaj rjukic ri' ptak ulew y nepluwa rec'xaj chuchi'. ");
INSERT INTO tzjE_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ja' Jesús cawra xc'axaj tzra redta' ala': —¿Nak tiemp ocnak ta itzel espíritu pranm? —C'co'l tak xoca pranm. ");
INSERT INTO tzjE_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Q'uiylaj mul rebnon ja' itzel espíritu remnon wlec'wal pk'ak' y chka' remnon pya', nrajo' ncamsaj. Atet we ncatecwina nato' wlec'wal ko'at-o' pka, tpoknaj jtz'it kawech, cara' xbij ja' acha. ");
INSERT INTO tzjE_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—Jara' awq'uin atet c'o wa' we ncatecwina neyke'a ac'u'x wq'uin. Wc'ola yukbal ac'u'x wq'uin jara' njelal quencwina quenban chka bechnak opech nawajo' chwa, cara' xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ja' ttixel chek xec'choja tzij rmal Jesús arja' xumaj jun nimlaj ok'ej y cawra xbij tzra Jesús: —Anen ykula nuc'u'x awq'uin per jyukbal nuc'u'x xe mnim ta, per cnat-o' ch-utz c'ara' nq'uiya más, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ja' Jesús chek xerutz'et wnak che e q'uiy xepeta chnecremlo' qui' ruq'uin, arja' xuchap bien tzan rutzij jitzel espíritu y cawra xbij tzra: —Itzel espíritu, atet je nque'acsaj mem wnak, je nque'acsaj tcon wnak, camic catnuban mandar, jat, catel ela, tey-a' cana ala' y nmajo'n chic xtcatoc xta pranm, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jitzel espíritu tak xc'axaj je xbixa tzra xurak ruchi' y xuya' chic jmul ataque tzra ala'. C'jara' xel ela pranm y xepne' cana ala', ajni' comnak chic ntz'e'ta. Je' wnak e q'uiy chca necbij che xcoma ala'. ");
INSERT INTO tzjE_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Per Jesús xuchap chuk'a' y xuyic. Cara' xuban xpe'a ala'. ");
INSERT INTO tzjE_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ja' Jesús tak xoca pjay je rdiscípulo arj-e' xecyonaj qui' ruq'uin y cawra xecc'axaj tzra: —¿Nak tzra ajoj majo'n xokocwin ta xkalsaj ela itzel espíritu? ");
INSERT INTO tzjE_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Itzel tak espíritu e ctakla nc'atzina oración ruq'uin ayuno che nquelasbesa, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","C'jara' Jesús xel ela chpam lwar, xba y xek'axa ptak lwar jc'ola precwent Galilea. Je nrajo' Jesús mquita nnabexa tak nk'axa ptak je' lwar ");
INSERT INTO tzjE_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","com arja' remjon ctojxic rdiscípulo. Cawra remjon rbixic chca: —Je Rlec'walxel jxoca alxic cuq'uin wnak arja' nja'ch na pquek'a' wnak y neccamsaj na per tak xtcamstaja nc'astaj na rwech prox k'ij, cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Per j-e' majo'n xch'obtaj ta cmal je xbix chca y xnecxibej qui' necc'axaj tzra nak rbanic. ");
INSERT INTO tzjE_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ja' Jesús tak xe'ekaja chpam tnamet Capernaum y tak ec'o chic pjay arja' cawra xc'axaj: —Tak kamjon binem ja okpenak wawe' ra ¿nak xech'ojquij chbil tak ewi'? ");
INSERT INTO tzjE_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Per j-e' nmajo'n achnak xecbij tzra com jnecch'ojquij pbey tak epenak jara' nak jun más nim ruk'ij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ja' Jesús xetz'be' kaja, xersiq'uij pona e cbeljuj rapóstol y cawra xbij chca: —Wc'ola jun chewa nrajo' noca más nim ruk'ij nc'atzina che arja' nuban ch'it co'l y noca ilinel ewxin chixconjelal, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","C'jara' xuc'om pona jun ch'tac'al y xuya' chquecjol, xch'elej y cawra xbij chca: ");
INSERT INTO tzjE_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Je' ac'ala' e ctakwra nak wnak xtec'luwa jun y pnubi' anen nuc'ul wa' jara' nbij tzij anen xenruc'ul. Nak wnak xtec'luwa wxin anen jara' mnuyon ta anen quenruc'ul, nuc'ul chka' jNedta' Dios jtakyon pa wxin. ");
INSERT INTO tzjE_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan cawra xbij tzra: —Maestro, c'ola jun acha xkatz'et, arja' pnabi' atet remjon wa' clasic je' itzel tak espíritu pcanm wnak per arja' mkexbil ta. Ajoj xekbij tzra che mtelsaj xta com mkexbil ta, cara' xbixa tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","—Mtek'il xta jara' acha com jun wnak chka bechnak wnak opech wnuban jun milagro pnubi' anen jara' majo'n itzel ta xtzijona chwij alnak. ");
INSERT INTO tzjE_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Chka' jun wnak chka bechnak wnak opech wmajo'n itzel ta nokrutz'et jara' kexbil ra'. ");
INSERT INTO tzjE_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jun chic, wc'ola jun, mesque xjun vas ya' nsipaj chewa y xe rmal ix rexbil Cristo tak nsipaj chewa, jara' ne ktzitzij wa' quenbij chewa che nyataj na rtojbalil tzra, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Cawra xbij chic chca: —Congan lowlo' chca nak xtquechajtina cxin j-ewra e cocoj je ykula quec'u'x wq'uin, congan lowlo' chca mesque xjun chca necchajtij ela che rbanic il mac. Más wen nxi'm ela jun ca' chquekul y nquerukix ela pya' que chwech necchajtij ela jun chca j-ewra je ykula quec'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Wc'ola jun ek'a' nquixerchajtij che nquixerkasaj chpam il mac, jneban camic tch'upuj ela. Com más na utz xjun ek'a' nquixoca chpam utzlaj c'aslemal je rxin junlic que chwech che c-e' ek'a' nquixba pk'ak' per jun k'ak' jmajo'n xtchuptaj ta. ");
INSERT INTO tzjE_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tzra' nquetaj wa' lowlo' je' wnak rxin junlic y jk'ak' nmajo'n xtchuptaj ta. ");
INSERT INTO tzjE_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Chka' wc'ola jun ewkan nquixerchajtij che nquixerkasaj chpam il mac, jneban camic tch'upuj ela. Com más na utz xjun ewkan nquixoca chpam utzlaj c'aslemal je rxin junlic que chwech che c-e' ewkan nquixba pk'ak' per jun k'ak' nmajo'n xtchuptaj ta. ");
INSERT INTO tzjE_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tzra' nquetaj wa' lowlo' je' wnak rxin junlic y jk'ak' nmajo'n xtchuptaj ta. ");
INSERT INTO tzjE_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jun chic, wc'ola jun ek'awech nquixerchajtij che nquixerkasaj chpam il mac, jneban camic, tewsaj ela. Com más na utz xjun ek'awech nquixoca chpam rgobierno Dios que chwech c-e' ek'awech nquixba pk'ak'. ");
INSERT INTO tzjE_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tzra' nquetaj wa' lowlo' je' wnak rxin junlic y jk'ak' nmajo'n xtchuptaj ta. ");
INSERT INTO tzjE_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ajni' nba'na tzra sacrificio je ntzujuxa chwech Dios nc'ola atz'am nya'a tzrij, cara' c'a xteba'na chca conjelal wnak, nque'oca ajni' jun sacrificio, ajni' k'ak' je nch'ach'jorsbexa cc'aslemal. ");
INSERT INTO tzjE_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jatz'am wenlaj samaj nuban, per we xk'axa jara' majo'n chic retzyil ¿nak nchumbex chic rxin ra'? Ajni' tzra atz'am nuban utzlaj samaj cara' c'a chewa ixix chka' tey-a' c'as tzra Dios chnesmaja ptak ewanm ch-utz c'ara' mtyojtaja ec'aslemal y majo'n ch'oj teban chbil tak ewi'. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","C'jara' xel ela Jesús chpam lwar y xek'axa ptak lwar jc'ola precwent Judea y xeba c'a pjupraj binel ya' rbin-an Jordán. Jmul chic congan e q'uiy wnak xecremlo' qui' ruq'uin y arja' chka' xumaj chic ctojxic com njawara' rcostumbre. ");
INSERT INTO tzjE_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ec'ol c'a jle' fariseo xerkaja ruq'uin y cawra xecc'axaj tzra per xa probar nqueban tzra: —¿L-utz c'ara' chwech rley Dios jun acha nujach cana rexkayil? cara' xecc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—¿Nak nbij mandamiento je y-on cana chewa rmal Moisés? cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—Moisés xuya' c'as tzra acha chnujach cana rexkayil xerwara' nuban cana jun wuj y ntz'ibaj cana chpam che junlic nujach cana rexkayil, cara' xecbij tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—Com congan cwernak ewanm che rbanic itzel tak achnak rmal c'ara' tak Moisés rtz'iban cana jawra mandamiento. ");
INSERT INTO tzjE_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Per je cbanic wnak tak xewanker ta nabey, Dios xwankersana cxin, acha ruq'uin ixak xerwankersaj. ");
INSERT INTO tzjE_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Y cawra xbij: —Rmal c'ara' jacha neruya' cana redta' rute' y xjun wnak nqueban ruq'uin rexkayil ");
INSERT INTO tzjE_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","y xjun nqueban che c-e', cara' tz'ibtanak cana. Cara' c'a rbanic, me c-e' xta, xjun chic quebnon. ");
INSERT INTO tzjE_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Com Dios xebnowa jun chca next jun c'a wnak xtejchow ta cxin. Cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","J-e' c'a discípulos tak ec'ol chic pjay ruq'uin Jesús arj-e' xecc'axaj chna tzra nak rbanic je xbij chca aj fariseo. ");
INSERT INTO tzjE_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Arja' cawra xbij chca: —Jun acha, chka bechnak acha opech, wnujach cana rexkayil y nuc'om chic jun ixak jara' adulterio nuban. ");
INSERT INTO tzjE_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wc'ola jun ixak chka' nujach cana rechjil y nuc'om chic jun acha jara' adulterio nuban ja' ixak chka'. Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ec'ol c'a jle' ac'ala' xec'om ela ruq'uin Jesús ch-utz c'ara' nuya' ruk'a' pquewá'. Per je' rdiscípulo arj-e' xecch'ojquij jec'amyon ela cxin ac'ala'. ");
INSERT INTO tzjE_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Per Jesús pkan xuna' je xqueban rdiscípulo y cawra xbij chca ra: —Tey-a' c'as chca ch'tak ac'ala' quepeta wq'uin, mtque'ech'ojquij ta com je' wnak je e'ocnak e ajni' ch'tak ac'ala' cxin c'a arj-e' je rgobierno Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Anen ne ktzij wa' je xtenbij chewa, nak wnak mtuban ajni' jun ch'it no'y ac'al che rnimaxic je rgobierno Dios jara' majo'n xtoc ta chpam rgobierno Dios, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","C'jara' xerch'elej ac'ala' chejujnel y xuya' ruk'a' pquewá' y xuya' utzil chca. ");
INSERT INTO tzjE_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ja' Jesús kas benam nuban chnumaj el chic rubey tak c'ola jun acha retjon concrer penak, xexque'a chwech y cawra xbij tzra: —Maestro, atet congan at utzlaj acha. ¿Nak quenban ch-utz c'ara' nyataja chwa utzlaj c'aslemal je rxin junlic? cara' xc'axaj acha. ");
INSERT INTO tzjE_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","¿Nak tzra tak nabij chwa che en utzlaj acha? Xjun oca kas utz, jara' Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Atet awutkin rmandamiento Dios jtz'ibtanak cana jcawra nbij: —Mtcatoc ta ruq'uin jun ixak wme awexkayil ta y jun ixak mtoc ta ruq'uin jun acha jme rechjil ta, mtaban ta cmic, mtaban ta alak', mtaya' ta testig wme ktzij ta nabij, mtatz'ak ta tzij chquij wnak y xtaban ta lowlo' chca, ruq'uin que'animaj adta' ate'. Cara' nbij rtzojbal Dios, cara' xbixa tzra acha rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Maestro, jala jxabij kaja nemjon wa' rnimaxic, q'uen co'la nemjon ta rij, cara' xbij ja' acha. ");
INSERT INTO tzjE_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ja' Jesús xch'ulchij acha y ncongan xrajo' y cawra xbij tzra: —Per c'o na jmajo'n abnon ta. Camic jat, tc'ayij cana njelal jc'ola awq'uin, je rjel tey-a' chca mibi'. Wcara' naban jara' c'ola amibil nyataja chawa chcaj. Tak xtbantaja awmal jxenbij kaja chawa catemloj ta wq'uin y catetre' ta chwij per mtapoknaj ta awi' nataj pen nmal anen ajni' nuban jun acha tak ntelej jun cruz, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ja' acha tak xc'axaj je xbixa tzra rmal Jesús chnuban kas junwa' xuna' rmal, xumaj bis y xemloja. Cara' xuban com congan jun nimlaj mibil ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ja' Jesús xertz'ulchij rdiscípulo y cawra xbij chca ra: —Je' byoma' congan pen chca che nque'oca chpam rgobierno Dios, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Je' rdiscípulo congan xel ta quec'u'x tak xecc'axaj tzij je xbixa chca rmal Jesús y ja' Jesús cawra xbij chic chca: —Wlec'wal, anen quenbij chewa camic, je' wnak je xruq'uin mibil ykul wa' quec'u'x congan pen chca che nque'oca chpam rgobierno Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jun camello arja' nimlaj chcop y congan pen noca pe rchak jun dsonbal bak, per jara' majo'n kas tpen noc wa' que chwech noca jun byom chpam rgobierno Dios, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Arj-e' más chna junwa' xquena' y cawra xecc'axaj tzra: —Jun byom wcongan pen noca chpam rgobierno Dios ¿e achnak c'ara' newlowa totanem rxin Dios? ");
INSERT INTO tzjE_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ja' Jesús xertz'ulchij y cawra xbij chca: —Je' wnak mesquier xtecwin ta xtquecsaj ta qui' queyon chpam totanem rxin Dios per Dios arja' necwina nqueruto' com Dios nmajo'n achnak mquita xtecwina xtuban, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro cawra xumaj rbixic tzra: —Je chka ajoj, njelal achnak jc'ola kuq'uin kay-on cana y okocnak adiscípulo, nokotren wa' chawij. ");
INSERT INTO tzjE_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús cawra xbij: —Ne ktzij wa' je xtenbij chewa, je' wnak, chka bechnak wnak opech, wquey-on cana cuchoch, equey-on cana quenmal ruq'uin quechak' o cana' o quedta' quete' o quexkilal ruq'uin clec'wal o quey-on cana je' culew, y we nmal anen tak quey-on cana y rmal utzlaj tzij jnec'mon ta, ");
INSERT INTO tzjE_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","jara' nyataj na más chna q'uiy chca wawe' chwech ruch'lew que chwech ajni' quey-on cana. Nyataj na más q'uiy cuchoch, nyataja más e q'uiy quenmal ruq'uin quechak', cana', quete', clec'wal chka' ruq'uin je' culew. Xerwara' c'ola je' lowlo' nquetaj na nmal anen. Per chpam tiemp jpenak nyataj na chca utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Xerwara' e q'uiy wnak je c'moy tak bey nabey q'ue rq'uisbal nquecanaj can wa', y jec'ola rq'uisbal j-era' nquec'mow el chic bey. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ja' Jesús e rexbil rdiscípulo quemjon binem ebnak pJerusalén, ja' c'amyon pa quebey. J-e' rdiscípulo congan xel ta quec'u'x tak xquetz'et Jesús chmajo'n nxibej ta ri' per arj-e' congan cxiben chic qui' jetrena tzrij. Ja' Jesús xeryonaj e cbeljuj apóstol y xumaj rbixic chca nak xteba'na tzra pJerusalén. ");
INSERT INTO tzjE_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Cawra xbij chca: —Bien tewc'axaj je xtenbij chewa, camic okbnak pJerusalén y je Rlec'walxel jxoca alxic cuq'uin wnak tzra' ncamsas wa', nja'ch na pquek'a' je' cjefe sacerdote e quexbil je' maestro je nquetijona cxin wnak tzrij rley Dios jtz'ibtanak cana rmal Moisés. Arj-e' nquek'at tzij tzrij che ncamsasa. Nquejach na pquek'a' wnak jme aj Israel ta. ");
INSERT INTO tzjE_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","C'jara' nqueyok', nquech'ay, necchubaj ruplaj y neccamsaj, y prox k'ij nc'astaja rwech, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","C'jara' e c-e' rlec'wal Zebedeo, Jacobo ruq'uin Juan, arj-e' xeki'l oca ruq'uin Jesús y cawra xecbij tzra: —Maestro, xtaban ta jun utzil chka, xtawajo' ta jlal je xtekc'utuj chawa. ");
INSERT INTO tzjE_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Nak rbanic utzil newajo' chwa chquenban? ");
INSERT INTO tzjE_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Tak xtoca agobierno atet xtaya' ta c'as chka, jun chka netz'be'a pnawejquenk'a' y jun chic netz'be'a pnawexquen, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Ixix majo'n ewutkin ta nak nec'utuj chwa. ¿Le nquixecwina netaj pen ajni' pen xtentaj anen? Com je xteba'na chwanen quenba'na bautizar chpam jun nimlaj lowlo'. Per ixix ¿lnecoch' nixk'axa chpam? ");
INSERT INTO tzjE_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Nokocwina, cara' xecbij tzra. Cawra xbix chic chca: —Jara' ne ktzij wa' chnetaj na lowlo' ajni' xtentaj anen y nquixba'na bautizar chpam lowlo' ajni' xtenk'axa chpam anen chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Per jxec'utuj chwa che nquixetz'be'a pe wejquenk'a' ruq'uin pwexquen jara' manen ta quenbnowa mandar com jara' chumsan chic nak kas chca xtyataj wa'. ");
INSERT INTO tzjE_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Je ljuj chic discípulo tak xecc'axaj jnecc'utuj Jacobo ruq'uin Juan tzra Jesús arj-e' congan xpeta cyiwal chquij. ");
INSERT INTO tzjE_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ja' Jesús xersiq'uij pona y cawra xbij chca: —Ixix ewutkin nak nqueban wnak jec'ola ptak je' nación j-era' je y-on gobierno pquek'a', arj-e' congan e nmak nquena' y nqueban chca wnak com xe ajni' cmos. Je nmak quek'ij congan nquequeban mandar je' wnak jec'ola pquek'a'. ");
INSERT INTO tzjE_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Per chewa ixix majo'n cara' ta xteban. Per jneban, nak jun chewa nrajo' noca nim ruk'ij checjol nc'atzina che noca ilinel ewxin. ");
INSERT INTO tzjE_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nak wnak chewa nrajo' nuc'om bey chewech nc'atzina che nquixrilij. ");
INSERT INTO tzjE_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ajni' xuban Rlec'walxel jxoca alxic cuq'uin wnak, arja' xpeta wawe' chwech ruch'lew per me xpe ta che nilixa cmal wnak per arja' xpe ta che noca jun ilinel cxin wnak. Y xpeta chka' ch-utz c'ara' che arja' nuya' ri' pe cmic y jrecmic ajni'la je' wnak nquerulok' chpam quil quemac. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","C'jara' xe'ekaja chpam tnamet rbin-an Jericó. Kas nel ela chpam tnamet e rexbil rdiscípulo y e congan wnak etren ela tzrij. C'ola jun ch'it moy tz'bula chibey, remjon rc'utxic limosna chca wnak. Jmoy Bartimeo rubi', rlec'wal jun acha Timeo rubi'. ");
INSERT INTO tzjE_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tak xc'axaj chJesús aj Nazaret jremjon binem pbey xumaj rakic ruchi' tzrij: —Jesús, atet je at Rlec'wal rey David, tpoknaj nwech, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Per e q'uiy wnak nquech'aj pe rwá' y cawra necbij tzra: —Xjun catec'je' wa', mtarak ta achi', cara' necbij tzra moy. Per arja' xmás nurak ruchi' tzrij Jesús: —Atet je at Rlec'wal rey David, tpoknaj jtz'it nwech, cara' xbij chic jmul. ");
INSERT INTO tzjE_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ja' Jesús xpe'a, xutak rsic'sic moy. Xeba che necsiq'uij ta y tak xe'ekaja ruq'uin cawra xecbij tzra: —Camic catquicota, catyictaja, ncatsiq'uisa rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Arja' c'ola jun tziak recsan tzrij y jara' tziak xch'akla' cana, xyictaj ela y xba ruq'uin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tak xekaja ruq'uin cawra xbixa tzra: —¿Nak nawajo' chwa chquenban chawa? cara' xc'axaxa tzra rmal Jesús. —Wajaw, jquenwajo' chawa njaktaj ta nk'anwech. Cara' xbij ja' moy. ");
INSERT INTO tzjE_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús cawra xbij: —Camic xatec'choja, utz chic ncatba, jyukbal ac'u'x wq'uin jara' xatchumsana, cara' xbixa tzra. Chek xbitaja cara' tzra njara' hor xjaktaja rk'arwech y xetre' ela tzrij Jesús pbey. ");
INSERT INTO tzjE_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Quemjon binem ebnak y xchenkaj tnamet Jerusalén ec'o chwa' y xe'ekaja chuchi' c-e' tnamet, jun Betfagé y jun chic Betania rubi' jabar c'o wa' jun jyu' Olivo rubi'. Ja' Jesús xerutak ela e c-e' chca rdiscípulo, ");
INSERT INTO tzjE_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","cawra xbij ela chca: —Jax chpam tnamet jc'ola chewech, tzra' newil wa' jun ral bur xmila per nexte wjic tz'ulben cmal wnak. Tecra' ta y tec'ma' ta. ");
INSERT INTO tzjE_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Wc'ola jun wnak xtc'axana chewa: —¿Nak tzra tak nequir ela bur? ixix cawra xtebij tzra: —Nc'atzina tzra Kjawal, cara' xtebij y alnak nya'la' ta chewa. Cara' xbij ela Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Xeba j-era' e c-e' discípulo. Tak xe'ekaja chpam tnamet xquewil jbur xmila chuchi' jun chijay abar nuc'ul wa' ri' c-e' bey y xquemaj rquiric. ");
INSERT INTO tzjE_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Kas quemjon rquiric tak xetzojbexa cmal nic'aj wnak jec'ola tzra': —¿Nak neban, nak tzra tak nequir bur? cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","C'jara' xquemaj rbixic jbin ela chca rmal Jesús y xya'a c'as chca che nquec'om ta bur. ");
INSERT INTO tzjE_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Y xquec'om pa bur tzra Jesús. Xqueya' quetziak tzrij bur y ja' Jesús xetz'be' ta tzrij y xumaj binem. ");
INSERT INTO tzjE_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Congan e q'uiy wnak xquesoc quetziak prubey Jesús y ec'o chic jle' xequetmo' ta ruxak palma y xqueya' prubey chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jenabyela chwech ruq'uin jetren cana tzrij arj-e' congan nquerak quechi' y cawra necbij ra: —Dios, ko'at-o' camic, abnon ta bendecir Cristo jpenak pnabi' atet je at Kajaw Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bendecido awmal jgobierno penak chkawech je rxin kawma' David. Ko'at-o' camic Dios jatc'ola chcaj. Cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ja' Jesús tak xekaja chpam tnamet Jerusalén xoca chpam nimlaj templo rxin Dios. Tak xtz'ettaj cana rmal je njelal je nba'na chpam templo c'jara' xba. Com xkaja k'ij xel ela chpam tnamet Jerusalén y xba chic chpam tnamet Betania e rexbil je cbeljuj apóstol. ");
INSERT INTO tzjE_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Rcab k'ij tak xe'el ta pBetania ja' Jesús xk'ak'ana rpam. ");
INSERT INTO tzjE_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Xutz'et pona jun mcaj higuera c'o ruxak y xba Jesús ruq'uin chneretz'ta' wc'ola rwech. Per tak xekaja ruq'uin nmajo'n rwech, xruyon ruxak com q'uemjana terla' tiemp rxin csech rxin higo. ");
INSERT INTO tzjE_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ja' Jesús cawra xbij tzra che': —Nmajo'n xtcatwachin ta rxin junlic y xtti'j xta ahigo, cara' xbij. J-e' rdiscípulo xecc'axaj je xbixa tzra che'. ");
INSERT INTO tzjE_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tak xe'ekaja chpam tnamet Jerusalén Jesús xoca chpam nimlaj ruchoch Dios y xumaj ta clasic conjelal wnak jec'ola chpam jquemjon c'yinem chpam e quexbil chka' je nquelk'owa je' achnak. Je' cmes je c'xoy tak pak xch'akij ela ptak ulew, cara' xuban tzra chka' je' cch'acat je nquec'ayina je' tz'quin rxin pjay. ");
INSERT INTO tzjE_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Y chka' majo'n nuya' ta c'as chca wnak che nqueram ptemplo cc'an ta je' cachnak. ");
INSERT INTO tzjE_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","C'jara' xumaj ctojxic y cawra xbij chca: —Cawra tz'ibtanak cana chpam rtzojbal Dios: —Jwuchoch anen jara' banbal oración cxin conjelal wnak jec'ola chpam njelal nación, cara' xbij Dios tzrij rtemplo, per jebnon tzra ixix xe cc'olibal elk'oma', cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Je' maestro je nquetijona cxin wnak tzrij rley Dios e quexbil je' cjefe sacerdote arj-e' tak xekaja rbixic cuq'uin je xbij Jesús congan xecxibej qui' rmal y rmal c'ara' xquemaj rconxic rij rwech nak nqueban tzra che neccamsaj. Arj-e' xecxibej qui' com jtijonem jnuya' Jesús kas xel ta quec'u'x conjelal wnak tak xecc'axaj y nqueya' quexquin tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tak xoc chic ak'a' xba chic Jesús, xel el chic chpam tnamet Jerusalén. ");
INSERT INTO tzjE_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Che rcab k'ij chic xenak'a' xek'ax chic jmul Jesús abar c'o wa' che' higuera. Tak xquetz'et che' chkij chic per ne njelal ruxe'. ");
INSERT INTO tzjE_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro xerkaja pe rwá' jbin cana tzra che' rmal Jesús: —Maestro, tetz'ta' mpa', chkij xtak wan jche' jxabij tzra che nexte wjic xtwachin xta, cara' xbij tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Cawra xbixa chca rmal Jesús: —Tec'je'a yukbal ec'u'x ruq'uin Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ne ktzij wa' je xtenbij chewa, jun wnak chka bechnak wnak opech necwina nbij tzra jawra jyu' che nel ela y nerec'ka' ri' pya' y ja' jyu' nnimaj y nba. Jara' wnak necwina nuban wmajo'n c-e' ta ruc'u'x nuban y nc'ola yukbal ruc'u'x chcara' nbantaja ajni' nbij. ");
INSERT INTO tzjE_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Rmal c'ara' quenbij chewa nak nec'utuj pnoración c'o ta yukbal ec'u'x che chumsan chic rmal Dios y nuya' chewa jnec'utuj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tak neban oración, wc'ola jun wnak lowlo' rebnon chewa nc'atzina chnecuy ch-utz c'ara' ja' Edta' jc'ola chcaj nquixrucuy ixix chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Wmajo'n necuy ta jara' majo'n nquixrucuy ta chka' Edta' jc'ola chcaj, cara' xbixa chca j-e' rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tak xerkaj chic chpam tnamet Jerusalén xoca Jesús chpam nimlaj ruchoch Dios. Kas remjon binem chpam tak xe'ekaja cjefe sacerdote e quexbil je' maestro je nquetijona cxin wnak tzrij rley Dios e quexbil chka' je' principal-i' rxin tnamet. ");
INSERT INTO tzjE_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Cawra xecc'axaj tzra: —¿Nak abanic atet tak amjon rbanic njelal jawrara jkamjon rtz'etic y nak yoyona chawa che amjon rbanic? cara' xecc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","—Anen chka' c'ola quenc'axaj chewa. We xtebij chwa je xtenc'axaj chewa, anen chka' quenbij chewa nak nbanic anen y nak rbanic njelal jnemjon rij je emjon rtz'etic. ");
INSERT INTO tzjE_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Camic tbij chwa, Juan Bautista ¿nak xyowa tzra jsamaj che nqueruban bautizar je' wnak, le Dios jc'ola chcaj xyowa tzra o wxe wnak? cara' xc'axaxa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Arj-e' xquemaj tzij chbil tak qui': —We xtekbij tzra che Dios xyowa tzra arja' cawra nbij chka: —Wcara' ¿nak tzra tak majo'n xenimaj ta? cara' nbila' chka. ");
INSERT INTO tzjE_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Per we xtekbij tzra xe wnak xyowa tzra nak la xtqueban wnak chka com chquewech arj-e' je Juan arja' jun profeta jne ktzij wa' che profeta rxin Dios com cara' nquech'ob conjelal. Cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Y cawra xecbij tzra Jesús: —Majo'n kutkin ta nak la xyowa tzra, cara' xecbij. —Nexte anen chka' xtenbij ta chewa nak nbanic anen y nak rbanic njelal jnemjon rij je emjon rtz'etic, cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","C'jara' xumaj tzij cuq'uin per ptak c'ambal tak tzij ntzijon wa'. Cawra jun c'ambal tzij xbij chca: —C'ola jun acha c'ola jun rchinoj, uva retcon chwech. Tak xtictaja rmal xuk'at, xuc'ot jun jul chpam abar nelsas wa' ri'al uva. Chpam chnoj xuyic jun torre y pe rwá' xec'je' wa' chajinel. Je rchinoj xuya' pe kjonem chca jle' ajchental y ja' xba chpam jun tnamet c'nat. ");
INSERT INTO tzjE_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tak xerla' tiemp rxin che nwachina rtejco'n arja' xutak ela jun rmos cuq'uin ajchental jekajyona rulew chnerec'ma' rent. ");
INSERT INTO tzjE_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tak xekaja mos cuq'uin j-e' ajchental xquechap y congan xquech'ay, xemloj pa per nmajo'n achnak xqueya' pa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jrajaw chnoj xutak el chic jun rmos cuq'uin y tak xekaj chic jawra mos cuq'uin xqueq'uiek tzan abaj y xquesoc rwá', xemloj pa per ncongan lowlo' xqueban pa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ja' rajaw chnoj xutak chna jun per tak xekaja cuq'uin xeccamsaj. Y ec'ol na más xerutak, ec'ola chca tak xe'ekaja cuq'uin ajchental jekajyona ulew, xeso'c ta y ec'ola jle' tak xe'ekaja xecamsasa. ");
INSERT INTO tzjE_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tak xq'uisbena jrajaw chnoj c'ola jun rlec'wal jcongan nrajo' jara' xutak el chic y cawra xbij kaja pranm: —Com jawra wlec'wal nqueban c'ara' respetar. ");
INSERT INTO tzjE_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Per j-e' ajchental tak xekaja rlec'walxel cuq'uin cawra xecbij chbil tak qui': —Jala acha noc na pruk'a' jawra ulew com reherencia. Camic kcamsaj y noca pkak'a' ajoj ja reherencia, cara' xecbij je'a. ");
INSERT INTO tzjE_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","C'jara' xquechap, xeccamsaj y xquelsaj ta chpam rchinoj. Cara' nbij jc'ambal tzij. ");
INSERT INTO tzjE_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Camic tbij c'a chwa ¿nak nuban c'ara' je rjawal chnoj? Jnuban jara' nquercamsaj ajchental jekajyona ulew y je rchinoj nuya' chic jmul pe kjonem chca jle' chic ajchental. ");
INSERT INTO tzjE_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Lmajo'n c'a esiq'uin ta chpam rtzojbal Dios jawra tzij jcawra nbij? —Je bnoy jay c'ola jun abaj xitzel xquetzu' y nmajo'n cgan tzrij y necch'ojquij, per jara' abaj csan chic che rbanic jay y jara' más nim ruk'ij com arja' chapyona resquin-il jay. ");
INSERT INTO tzjE_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jara' samaj Kjawal Dios xebnowa y kas nel ta kanm tzrij tak nkatz'et. Cara' nbij rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tak xecc'axaj jc'ambal tzij je xbij Jesús xch'obtaja cmal che j-e' nquebixa. Rmal c'ara' xcajo' ta xquechap y xquecsaj ta pcars per xecxibej qui' chquewech wnak. Je xqueban, xqueya' cana Jesús y xeba. ");
INSERT INTO tzjE_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","C'jara' xeta'k ela ruq'uin Jesús jle' aj fariseo e quexbil jle' wnak jec'ola chpam partido rxin Herodes, xeta'k ela che nquetzijona ruq'uin ch-utz c'ara' tak xte'l ta jun tzij pruchi' je m-utz ta jara' necchapbej. ");
INSERT INTO tzjE_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tak xe'ekaja ruq'uin cawra xecbij tzra: —Maestro, ajoj kutkin chatet majo'n natz'ak ta tzij. Kutkin nmajo'n abar napitz' wa' awi' com atet majo'n jun utz y majo'n jun itzel ta xtatz'et per rubey Dios amjon rc'utic chkawech y kas wen rbixic naban. Camic tbij chka, jimpuesto nc'utux chka rmal César jnimlaj rey rxin Roma ¿le rbeyal c'ara' nkatoj o me rbeyal ta? ¿Le nkatoj o wmajo'n? ¿Nak nabij atet? Cara' xecc'axaj tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Per Jesús rutkin xe c-e' queplaj y cawra xbij chca: —¿Nak tzra tak newajo' cneban probar? Tec'ma' ta jun pak quentz'et na, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Y xquec'ut pak chwech —¿Nak chuxin plaj c'ola chwech jawra pak y nak chuxin bi'aj chka' tz'ibtanak chwech? Cara' xc'axaj Jesús chca. —Rxin César, cara' xecbij j-e'. ");
INSERT INTO tzjE_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Nak rxin César tzra c'ara' César tey-a' wa', nak rxin Dios tzra Dios tey-a' wa', cara' xbixa chca rmal Jesús. Y congan xel ta quec'u'x tzrij jxecc'axaj je xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ec'ol c'a jle' saduceo xeba ruq'uin Jesús. J-e' saduceo majo'n necnimaj ta che nquec'astaja cnomki'. Tak xe'ekaja ruq'uin cawra xecbij tzra: ");
INSERT INTO tzjE_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, Moisés rbin cana chka chpam rtzojbal Dios, wc'ola jun acha ncoma jun ruchak' o renmal y nmajo'n jun rlec'wal xec'je' cana jara' acha nec'le'a ruq'uin ixak je xcoma rechjil. Arj-e' tak nec'je'a jun clec'wal jara' ac'al necbij tzra che rlec'wal camnak. ");
INSERT INTO tzjE_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Xqueban c'a jmul ec'ola e wku' alxic, jnabey-al xec'le'a per xcoma y majo'n rlec'wal xec'je' cana. ");
INSERT INTO tzjE_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Je rcabal arja' xec'le'a ruq'uin ixak jxec'je' cana. Ajni' xuban nabey-al cara' xuban chic rcabal, xcom chic chwech jara' ixak y nmajo'n clec'wal xec'je' ta. Y ncara' xuban rox chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Cara' xqueban che wku', xec'le'a ruq'uin ixak y xecoma chwech y nmajo'n clec'wal xec'je' cana. Y xq'uisbena xcoma ja' ixak chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Camic ¿nak nabij atet tzra jawra? Je wku' alxic tak xterla' k'ij che nquec'astaja chpam cmic ¿nak rechjil c'ara' nuc'om jara' ixak com xec'le'a ruq'uin che wku'? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","—Jala jnebij me rbeyal ta com ixix majo'n ch'obtanak ta ewmal nak kas mer nuc'ut rtzojbal Dios y majo'n ch'obtanak ta ewmal chka' nak rbanic jpoder rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cara' quenbij chewa com tak nquec'astaja cnomki' jara' majo'n chic c'ulbic chquij tzra', e ajni' chic ángel rxin Dios jec'ola chcaj. ");
INSERT INTO tzjE_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","C'ola tz'ibtanak cana chpam rtzojbal Dios rmal Moisés tzrij jc'astajic cxin cnomki' ¿lmajo'n c'a esiq'uin ta? Jara' tak xutz'et jle' xulquiej Moisés y xtzijon ta Dios chpam y cawra xbixa tzra rmal Dios: —Anen en Dios rxin Abraham, en Dios rxin Isaac, en Dios rxin Jacob, cara' xbixa tzra Moisés. ");
INSERT INTO tzjE_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tzra' netz'et wa' che j-e' mesque e cnomki' chic per chwech Dios ec'asla. Rmal c'ara' tak quenbij chewa che me rbeyal ta nebij chmajo'n nquec'astaj ta cnomki'. Cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","C'ol c'a jun chca maestro je nquetijona cxin wnak tzrij rley Dios, arja' xerkaja abar ntzijon wa' Jesús cuq'uin aj saduceo y xc'axaj je xecbij. Arja' wen xc'axaj je xbij Jesús chca rmal c'ara' cawra xc'axaj tzra: —¿Nak mandamiento rxin Dios más nim ruk'ij chwech je njelal? ");
INSERT INTO tzjE_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","—Jmandamiento más nim ruk'ij tzra njelal cawra nbij ra: —Tewc'axaj ixconjelal je ix aj Israel. Kajaw Dios arja' xjun y majo'n chic jun Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Y twaj-o' Ewajaw Dios per ne tzra njelal ewanm twaj-o', tzra njelal ena'oj y tzra njelal echuk'a' twaj-o' chka'. Ja c'a wa' mandamiento más nim ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jrucab mandamiento xjunam ruq'uin y cawra nbij: —Ajni' nawajo' kaja awi' ayon cara' c'a tebna' chca je' aprójimo, que'awaj-o' chka', cara' nbij. Jawra c-e' mandamiento jxenbij chawa majo'n chic jun mandamiento más nim chta ruk'ij chwech, cara' xbij ja' Jesús tzra acha. ");
INSERT INTO tzjE_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","—Maestro, jxabij kaja ne ktzij wa'. Ne ktzij wa' nabij che Dios arja' xjun y majo'n chic jun Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Y más na utz nawajo' Dios per tak ne njelal awanm nawajo' y njelal ana'oj y tzra njelal achuk'a' nawajo' chka'. Y más na utz nque'awajo' je' aprójimo ajni' nawajo' kaja awi' ayon. Wcara' nkaban jara' más na utz que chwech conjelal chcop je nquetzujuxa tzra Dios je nqueporoxa chwech altar, más na utz que chwech njelal je' achnak chic je ntzujuxa tzra Dios chwech altar, cara' xbixa tzra Jesús rmal acha. ");
INSERT INTO tzjE_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ja' Jesús wen xc'axaj je xbixa tzra rmal acha y rmal c'ara' cawra xbij: —Atet me c'nat ta atc'o wa' che ncatoca chpam rgobierno Dios, cara' xbij tzra. Tak xec'choja tzij rmal Jesús majo'n chic achnak nc'axaxa tzra com conjelal wnak xecxibej qui' necc'axaj je' achnak tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ja' Jesús remjon ctojxic wnak chpam nimlaj rtemplo Dios y cawra xbij chca: —Je' maestro je nquetijona ewxin tzrij rley Dios jtz'ibtanak cana rmal Moisés ¿nak tzra tak arj-e' necbij che Cristo jara' rlec'wal rey David? ");
INSERT INTO tzjE_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Cara' quenbij chewa com ja' David xuban jmul c'an rmal Espíritu Santo cawra xbij: —Kajaw Dios cawra xbij tzra Wajaw: —Catetz'be'a wawe' pe wejquenk'a', wawe' ncatec'je' wa' y quenuya' na pnawkan je nquetzelana awxin, cara' xbij tzra. Cara' rbin cana ja' David. ");
INSERT INTO tzjE_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David, Wajaw nbij tzra Cristo, tbij c'a chwa camic ¿nak tzra tak nbixa tzra Cristo che rlec'wal David? Cara' xc'axaj Jesús chca. Je' wnak congan e q'uiy nquec'axana je nbij Jesús y congan qui' quec'u'x tzrij tijonem jnuya'. ");
INSERT INTO tzjE_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ja' Jesús tak remjon ctojxic wnak cawra xbij chca: —Tebna' cwent ewi' chquewech maestro je nquetijona ewxin tzrij rley Dios. Arj-e' congan qui' quec'u'x tak nquec'astana chquewech wnak, quecsan nmak tak tziak jnec'tuwa cxin che e nmak tak maestro. Y c'c'o na más jcongan nel ta quec'u'x tzrij ajni' tzra tak nquek'ijloxa ptak q'uebal. ");
INSERT INTO tzjE_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ajni' tzra tak nqueba ptak jay rxin molbal ri'il jabar nc'axax wa' rtzojbal Dios, arj-e' congan qui' quec'u'x tzrij tz'ulbal jmás nim ruk'ij, cara' nqueban chka' tak nqueba'na invitar chpam nmak tak w-im. ");
INSERT INTO tzjE_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Arj-e' nquemaj cuchoch je' melcani' je camnak chic quechjilal. Ne nmak tak oración nqueban per nquechi' oca nbina. Per tak xtek'a'ta tzij chquij rmal Dios más na lowlo' nequetja'. Cara' xbij Jesús chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","C'jara' xba y xetz'be'a chenkaj abar nya' wa' ofrenda rxin templo. Remjon ctz'etic wnak jquemjon rya'ic cofrenda chpam rc'olibal je' ofrenda. E q'uiy wnak e byoma' xerutz'et pona, arj-e' congan nmak tak ofrenda nqueya' cana chpam. ");
INSERT INTO tzjE_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","C'o c'a jun ixak melca'n y miba' xutz'et pona, arja' c'ola c-e' pak rc'an y xuya' chpam rc'olibal ofrenda. Je c-e' pak xuya' mnim ta rjel. ");
INSERT INTO tzjE_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ja' Jesús xersiq'uij pona rdiscípulo y cawra xbij chca: —Tetz'ta' mpa' jch'it melca'n ixak, arja' más na nim ruk'ij rofrenda chwech Dios jxuya' chpam rc'olibal ofrenda chwech je xqueya' conjelal. ");
INSERT INTO tzjE_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Cara' quenbij chewa com jle' chic xjara' xqueya' jcoltanak cana per ja' mesque xmiba' per xuya' njelal jc'ola ruq'uin je ntzukbej ri', cara' xbij chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","C'jara' xel ta Jesús chpam nimlaj templo rxin Dios. Kas remjon binem tak c'ola jun chca rdiscípulo xki'l oca ruq'uin y cawra xbij tzra: —Maestro tetz'ta' mpa' templo, congan wen tak abaj ocnak y congan wen rbanic je' jay bnon. ");
INSERT INTO tzjE_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Cawra xbixa tzra rmal Jesús: —¿Lnatz'et nmak tak jay rxin templo? per anen quenbij chewa chnerla' na jun k'ij tak nyojtaj na njelal, majo'n chic abaj xtrejkla' xta ri'. Cara' xbixa tzra ja' discípulo. ");
INSERT INTO tzjE_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ja' Jesús xetz'be'a pe rwá' jun jyu' rbin-an Olivo y nutz'et pona nimlaj templo rxin Dios. Ja' Pedro e rexbil Jacobo, Juan ruq'uin Andrés, arj-e' xecyonaj qui' ruq'uin y cawra xecc'axaj tzra: ");
INSERT INTO tzjE_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Tbij chka ¿nak k'ij nbantaja jala jxabij kaja chka? Chka' ¿nak rital nwankera je nc'utbexa rxin che xyamer nbantaja cumplir njelal jxabij kaja chka? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús cawra xumaj rbixic chca: —Kas tebna' cwent ewi', majo'n jun xtquixebnowa engañar. ");
INSERT INTO tzjE_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Cara' quenbij chewa com e q'uiy je' wnak nquepe na y necbij che j-e' e Cristo, cawra necbij chca wnak: —Anen en Cristo, cara' necbij chca y e q'uiy wnak nquequeban engañar. ");
INSERT INTO tzjE_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","C'ol c'a je' nmak tak ch'oj xtba'na nat nkaj per tak xtekaja rbixic ewq'uin mtexibej ta ewi' rmal, com nc'atzina che nbantaja cumplir njelal jawrara, per jawra mjara' ta rq'uisbal ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Cara' quenbij chewa com je' tnamet nyictaja tzrij jle' chic tnamet, chka' jle' gobierno nyictaja tzrij jle' chic gobierno. Chka' c'ola nmak tak cbarkan nbantaj na, congan nmak tak wyejal npet na, je' wnak nqueyojtaj na y nqueyictaja rmal cyiwal. Njelal jawrara ja c'a wa' nmajbexa rij nimlaj lowlo'. ");
INSERT INTO tzjE_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tebna' cwent ewi' chquewech je' wnak com arj-e' nquixquec'om ela ptak k'atbaltzij y nquixquech'ay ptak jay rxin molbal ri'il. Nquixquec'om ela chquewech gobernador, nquixquec'om ela chquewech rey per xe nmal anen tak xtba'na cara' chewa. Cara' xtba'na chewa ch-utz c'ara' nela ntzojxic chquewech. ");
INSERT INTO tzjE_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tak mja'na tpeta rq'uisbal ruch'lew nc'atzina nabey mul jutzlaj tzij jnec'mon ta nekaj na rbixic cuq'uin je' wnak jec'ola chpam njelal tak nación. C'jara' tak xtpeta rq'uisbal ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tak nquixec'mar ela chquewech che nquixja'cha pquek'a' majo'n xtquixbison ta tzrij nak xtebij che netobej ewi' chquewech. Per chpam jara' hor nyataja chewa nak xtebij chca, ajni' xtyataja chewa ja c'ara' xtebij chca. Cara' quenbij chewa com me ixix ta nquixtzijona com ja' Espíritu Santo nyowa chewa nak xtebij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Je' e alxic nquequejach quechak' ruq'uin quenmal pe cmic, cara' nqueban chka' ttixela', nquequejach clec'wal, y chka' je' alc'walxela' arj-e' nqueyictaja chquij ttixela' y nquequejach pe cmic. ");
INSERT INTO tzjE_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ixix xitzel nquixtz'e't na cmal conjelal wnak per xe nmal anen tak cara' xtba'na chewa. Per conjelal je xtquecoch' quewech chpam lowlo' y nmajo'n xtqueya' cta yukbal quec'u'x wq'uin arj-e' nquewil totanem rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Per terkaja pnewá' je rbin cana ojer profeta Daniel. Daniel xbij chnerla' na jun k'ij tak npeta jun jxitzel ntz'e'ta rmal Dios. Tak xtpeta arja' npe'a chpam lwar je myatanak ta tzrij che npe'a tzra' y congan cmic nuban. (Je nquesiq'uina jawra jle' tzij kas quelsaj jle' cna'oj tzrij.) Jara' tak xtetz'et jpa'l chic chpam lwar, jneban, jixc'ola chpam departamento Judea utz nquixnanmaja, ewiwaj ewi' ptak c'chelaj. ");
INSERT INTO tzjE_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jixc'ola pe rwá' terraza utz nquixnanmaja chka', me tquixkaj pta ptak ewuchoch che rlasic emibil ptak jay. ");
INSERT INTO tzjE_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jixc'ola ptak echinoj utz chka' nquixnanmaj ela, mtquixemloj pe xta ptak ewuchoch che rc'amric echquet. ");
INSERT INTO tzjE_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Anen congan quenpoknaj quewech ixki' jq'uemja'na tec'je'a ch'tak cal chpam jara' tiemp y chka' jc'ola ch'tak quech'uch' chquek'a'. ");
INSERT INTO tzjE_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tc'utuj tzra Dios che mpretiemp ta tew tak xterla' k'ij che nquixnanmaja. ");
INSERT INTO tzjE_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Cara' quenbij chewa com c'ola jun nimlaj lowlo' npe na per najni'la nim. Ajru' tiemp wankersan ta rwech ruch'lew rmal Dios majo'n jun lowlo' penak ta más ta nim chwech jawrara jnemjon rbixic chewa y majo'n chic jun xtpe ta más chta nim. ");
INSERT INTO tzjE_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Xerwara' xpajtala tiemp com Dios cara' rchumin. Jche mquita pajtala tiemp nmajo'n jun wnak xtuto' ta ri' chpam. Per cmal wnak jerech-on Dios tak pajtala tiemp. ");
INSERT INTO tzjE_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Wc'ola jun wnak xtbij chewa: —Xpeta Cristo, wawe' c'o wa', wcara' nbij, mtenimaj ta. Owe nbij chewa: —Cala' c'o wa' Cristo, chka' mtenimaj ta. ");
INSERT INTO tzjE_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Cara' quenbij chewa com ec'ola wnak nquepe na y necbij che j-e' e Cristo y jle' chic necbij che e profeta rxin Dios per me ktzij ta necbij. Arj-e' c'ola nmak tak milagro xtqueban, xyamer nara' nquequeban engañar je' wnak jerech-on Dios, per jara' majo'n nquequech'ec ta. ");
INSERT INTO tzjE_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Bien tebna' cwent ewi' chwech jawrara com xenya' pona rbixic chewa. ");
INSERT INTO tzjE_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Chek xtk'axa nimlaj lowlo' c'jara' majo'n chic nca'y xta rwech k'ij, congan noca k'ejku'm y majo'n nca'y xta rwech ic' chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Y je' ch'umil nquetza'k tna y je' nmak tak poder rxin chcaj nsi'l na. ");
INSERT INTO tzjE_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","C'jara' je' wnak arj-e' nquetz'et na je Rlec'walxel jxoca alxic cuq'uin wnak, arja' c'mon ta rmal jle' sutz' y jun nimlaj poder c'o chic pruk'a' y congan chic nim ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Y ec'ola je' r-ángel nquerutak ela che nqueba che cmolic je' wnak jerech-on per ne che njelal chwech rwech ruch'lew nqueba wa' che cmolic, mc'o tjun lwar mquita xtque'ekaj wa' che cmolic. ");
INSERT INTO tzjE_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Telsaj c'a ena'oj tzrij jun che' higuera jara' quenc'ambej tzij chewech. Ja' higuera tak npulina ruxak c'ola ch'tak tiern ruk'a' nwankera ruq'uin ch'tak ruxak jara' rital nuc'ut chewech che xyamer nerkaja retiemp c'ten. ");
INSERT INTO tzjE_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Cara' c'a tzra chka' tak xtemaj rtz'etic njelal jxenbij chewa jara' rital chnuc'ut chewech che xchenkaj chic c'o wa' k'ij jxewc'axaj chwa. ");
INSERT INTO tzjE_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ne ktzij wa' je xtenbij chewa, je tnamet Israel arj-e' q'uec'o na tak xtbantaja cumplir njelal jawrara, majo'n chuptanak ta quewech. ");
INSERT INTO tzjE_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Jcaj ruq'uin ruch'lew jara' xe nk'axa rwech per ntzojbal anen jara' majo'n nk'ax ta rwech. ");
INSERT INTO tzjE_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Per majo'n jun wnak ojtakyona nak kas mer k'ij y jmer hor je xtbantaja, next c'a je' ángel chka' jec'ola chcaj, next c'a Rlec'walxel chka', xruyon Nedta' Dios ojtakyona. ");
INSERT INTO tzjE_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kas tebna' cwent, quixc'asc'ata y tebna' je' oración, com majo'n ewutkin ta nak k'ij tak xtquenmloj ta wjic chic chwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Je xtenban anen chewa cara' ajni' nuban jun acha tak nba pjun viaje nat y je' rachnak nujach cana pquek'a' rmos che nqueban cwent. Arja' nuya' cana csamaj chejujnel y nbij cana tzra chajil jay che nc'asc'ata. ");
INSERT INTO tzjE_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Y cara' c'a chewa ixix chka', quixc'asc'ata com anen en junam ruq'uin jrajaw jay, majo'n ewutkin ta nak hor tak xtquenmloj pchic jmul, mexla noca ak'a', mexla pe nc'aj ak'a', mexla pe rsakric o wsak chic. ");
INSERT INTO tzjE_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tak xtquenmloj pchic jmul mquita ixwarnak xtquixenruwla'. ");
INSERT INTO tzjE_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Per mruyon ta chewa ixix quenbij wa' che nquixc'asc'ata, cara' quenbij chca conjelal che nquec'asc'ata, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xe c-e' k'ij chic c'o wa' nimk'ij pascua tak nti'ja xquelway jmajo'n levadura ruq'uin. Je cjefe sacerdote e quexbil je' maestro je nquetijona cxin wnak tzrij rley Dios, arj-e' quemjon rconxic rij rwech nak nqueban tzra Jesús che nquechap pnejkal y neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Per cawra necbij ra: —Me chpam ta nimk'ij nkachap wa' ch-utz c'ara' mtqueyictaja wnak rmal, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ja' Jesús arja' c'ola chpam tnamet rbin-an Betania, pruchoch jun acha c'o wa', Simón rubi', jc'ola itzel yubil lepra tzrij nabey. Jesús c'ola tzrij mes tak xpona jun ixak ruq'uin rec'mon ela jle' ak'om jcongan qui' rexla', jak'om nardo rubi' y congan nim rejlal. Ja' ixak rec'mon ela chpam rc'olibal je bnon rbanic, alabastro ocnak. Tak xekaja ruq'uin Jesús xelsaj rwá' rc'olibal ak'om y xuya' ak'om pe rwá' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Je' wnak jec'ola pjay ec'ola junwa' xquetz'et jxuban ixak y cawra xecbij chbil tak qui': —¿Nak tzra tak xtz'ila' ak'om? ");
INSERT INTO tzjE_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jxuban ta tzra xc'ayij ta, más ta oxi' cient ctzal xba twa', je rjel xya' ta chca je' mibi', cara' xecbij. Y xquemaj rch'ajic pe rwá' ixak. ");
INSERT INTO tzjE_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Per Jesús cawra xbij chca: —Mtech'aj ta pe rwá'. ¿Nak tzra tak nenak ixak? Jawra jxuban chwa congan wen xuban. ");
INSERT INTO tzjE_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Je' mibi' arj-e' nec'ol wa' checjol y chka bechnak tiemp wc'ola egan neban utzil chca jara' ix libre che nque'eto' per chwa anen majo'n quenc'je' ta ewq'uin njelal tiemp, quenlsax el na checjol. ");
INSERT INTO tzjE_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jxuban ixak chwa xuya' chwa jc'ola ruq'uin. Arja' tak xuya' ak'om chwij jara' xchumarsbej pona necuerpo che nmu'ka. ");
INSERT INTO tzjE_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ne ktzij wa' je xtenbij chewa, jutzlaj tzij jnec'mon ta, xabar tzra' xtekaj wa' rbixic njelal nat nkaj chwech ruch'lew tzra' nnatax wa' chka' jutzil jxuban chwa jawra ixak, jara' nnatbexa rxin. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","C'jara' c'ola jun chca e cbeljuj discípulo je rbin-an Judas Iscariote, xba cuq'uin cjefe sacerdote, xuch'ob ela chnerejcha' Jesús pquek'a'. ");
INSERT INTO tzjE_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tak xekaja cuq'uin xuch'ob chquewech jrech'bon ela. Arj-e' congan xequicota rmal je xbixa chca rmal Judas y xqueya' quechi' che nqueya' pak tzra. C'jara' ja' Judas xumaj rconxic nak nuban tzra Jesús chnujach pquek'a'. ");
INSERT INTO tzjE_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Xerla' jnabey k'ij rxin nimk'ij tak nti'ja xquelway jmajo'n levadura ruq'uin y tak nquecamsasa ch'tak carne'l rxin pascua je nquetzujuxa tzra Dios, jsacrificio. Xpeta rdiscípulo Jesús y cawra xecc'axaj tzra: —Je xtataj rxin nimk'ij pascua tbij chka abar tzra' xtekchumij wa'. ");
INSERT INTO tzjE_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesús ec'ola e c-e' chca rdiscípulo xerutak ela y cawra xbij ela chca: —Jax chpam tnamet Jerusalén. Tak xtquixoca chpam c'ola jun acha nec'ul, arja' rc'an jun chnaw ya', quixetre' ela tzrij. ");
INSERT INTO tzjE_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tak xtquixoca abar xtoc wa' acha pjay, tbij c'a tzra jrajaw jay cawrara: —Ja' Maestro okretkon ta awq'uin che nekerc'axaj chawa: —¿Abar nkaban wa' w-im rxin pascua e wexbil ndiscípulo? Cara' rbin ta chka. Cara' tbij tzra rajaw jay. ");
INSERT INTO tzjE_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Arja' nuc'ut chewech jun nimlaj cuarto chumin chic, chcaj c'o wa' pe c-e' piso. Tzra' nechomij wa' je nkataj rxin nimk'ij pascua. Cara' xbij ela Jesús chca e c-e' rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Xeba je rdiscípulo y tak xe'oca chpam tnamet ncara' xbantaja ajni' xbix ela chca rmal Jesús. C'jara' xquemaj rchumsic w-im je rxin nimk'ij pascua. ");
INSERT INTO tzjE_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tak xoca ak'a' ja' Jesús e rexbil e cbeljuj rdiscípulo xe'ekaja abar nqueban wa' w-im. ");
INSERT INTO tzjE_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Etz'bul chic tzrij mes, quemjon w-im tak Jesús cawra xbij chca: —Ne ktzij wa' je xtenbij chewa, c'ola jun chewa jkamjon w-im ruq'uin, arja' nejchowa wxin pquek'a' je nquetzelana wxin, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Arj-e' tak xecc'axaj je xbixa chca xquemaj jun nimlaj bis: —¿Mex anen? cara' nbij jun, y —¿Mex c'a anen? nbij chic jun, y cara' xqueban che jujnel. ");
INSERT INTO tzjE_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús cawra xbij chic chca: —C'o jun chewa je ix cbeljuj ndiscípulo je xjunam nokwa'a ruq'uin pe plat, ja' c'ara' nejchowa wxin pquek'a'. ");
INSERT INTO tzjE_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Je Rlec'walxel jxoca alxic cuq'uin wnak arja' ncamsax na ajni' tz'ibtanak cana tzrij chpam rtzojbal Dios per congan lowlo' xtba'na tzra je xtejchowa rxin pquek'a' je necamsana rxin. Je xtejchowa rxin más na utz mquita xalexa chwech ruch'lew. Cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tak quemjon w-im ja' Jesús xuc'om xquelway y xmeltioxij tzra Dios, xuwech' y xujach chca y cawra xbij chca: —Ja c'a wa' necuerpo, tec'ma' y tetja', cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Y xuc'om chic jun cop vino, xmeltioxij tzra Dios y xujach chca chka' y xquetaj conjelal. ");
INSERT INTO tzjE_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","C'jara' xbij chic chca: —Jawra vino ja c'a wa' necq'uiel jara' rseguro jc'ac'laj chuminem je rchumin Dios. Jnecq'uiel e q'uiy na wnak nti'x na pquecwent. ");
INSERT INTO tzjE_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Anen ne ktzij wa' je xtenbij chewa, jri'al uva majo'n chic quentaj xta wawe', c'jara' xtentaj chic tak xterla' k'ij chquentaj chpam rgobierno Dios xerwara' c'ac' chic njelal tzra', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","C'ol c'a jun himno rxin nimk'ij pascua xecbixaj. Tak xec'choja himno cmal xe'el ela, xeba chpam jun lwar rbin-an jyu' rxin olivo. ");
INSERT INTO tzjE_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús cawra xbij chca: —Rmal je xtba'n na chwa chpam jawra chak'a' ixix queneya' cana, nquixnanmaja chixconjelal. Cara' quenbij chewa com tz'ibtanak cana chpam rtzojbal Dios jcawrara nbij: —Anen xtencamsaj ajyuk'la' cxin ch'tak carne'l, y arj-e' ch'tak carne'l necpaxij je' qui'. Cara' tz'ibtanak cana. ");
INSERT INTO tzjE_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Per tak xtec'astaja nwech quennabyej na chewech y quenba chpam departamento Galilea, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro cawra xbij tzra: —Mesque conjelal xtcatqueya' cana per anen majo'n catnuya' cta, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Cawra xbixa tzra rmal Jesús: —Ne ktzij wa' je xtenbij chawa, je chpam jawra ak'a' tak q'uemjana tetrekena camul pre'y, oxmul nabij cawra chwa: —Anen majo'n wutkin ta rwech Jesús, cara' nabij chwa, cara' xbixa tzra Pedro. ");
INSERT INTO tzjE_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","—Mesque ok c-e' awq'uin xtokcamsasa per majo'n catnuya' cta, cara' xbij Pedro tzra. Y conjelal cara' xecbij tzra chka'. ");
INSERT INTO tzjE_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","C'jara' Jesús xerexbilaj ela rdiscípulo, xeba chpam jun lwar rbin-an Getsemaní. Tak xe'ekaja cawra xbij chca: —Quixetz'be' cana wawe' ra, y anen cnebna' pek na oración, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Xba, xeruc'om ela Pedro, Jacobo ruq'uin Juan. C'jara' xumaj jun nimlaj bis y xumaj t-onem ranm. ");
INSERT INTO tzjE_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Cawra xbij chca: —Camic, congan nbisona wanm, jquenna' anen cmic rec'mon ta chwa. Ixix quixec'je' cana wawe' ra, quixc'asc'ata, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","C'jara' xyonaj pona ri' ruyon, xexque'a y xumaj rbanic oración: —Abba, Nedta', anen c'ola quenwajo' quenc'utuj chawa. Wnuc'om ri' ruq'uin jachumin ta chwij, mquita quenk'axa chpam jawra lowlo' jpenak chenwech. Atet majo'n achnak mquita ncatecwina naban, quenwajo' che cnawsaj chpam lowlo' jpenak chenwech, xerwara' nquenk'ax wa' chpam wcara' nrajo' awanm, cara' nbij tzra Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tak xec'choja oración rmal xba cuq'uin rdiscípulo. Tak xe'erewla' ekanak chuwram. Cawra xbij tzra Pedro: —Simón ¿nak tzra tak xe wram naban? ¿Le mtacoch' xtcatc'asc'ata jun hor? ");
INSERT INTO tzjE_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Quixc'asc'ata y tebna' orar ch-utz c'ara' Satanás tak xtquixrchajtij mquita nquixruch'ec. Jewanm ne ktzij wa' chc'ola rgan nc'asc'ata, per jecuerpo npoknaj ri' nuban cara' com xix wnak, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","C'jara' xemloj chic jmul che rbanic oración. Ajni' xbij tzra Ttixel nabey mul cara' xbij chic pe rcamul. ");
INSERT INTO tzjE_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tak xec'choj chic oración rmal xemloj pchic jmul cuq'uin y tak xeruwla' chic ewarnak chic chka'. Cara' quebnon com congan jun wram majyona cxin, majo'n nquecoch' ta. Tak xquena' qui' mesquier chic necneya cmal nak necbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ja' Jesús xba chic jmul che rbanic oración. Tak xemloj pchic proxmul cawra xbij chca rdiscípulo: —Camic quixwar c'a, quixexle'n c'a, camic xec'choja. Tewc'axaj bien, xerla' c'a hor, je Rlec'walxel jxoca alxic cuq'uin wnak, camic nja'ch na pquek'a' je aj il aj mac che neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jo', quixyictaja, que'ekac'lu'. Tetz'ta' mpa', xyamer nerkaja jnejchowa wxin pquek'a', cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kas remjon na tzij Jesús cuq'uin rdiscípulo tak chek q'uenjlal xpeta Judas. Jara' Judas jun chca e cbeljuj apóstol. E q'uiy wnak erexbilan ta y quec'mon ta je' achnak rxin banbal ch'oj ajni' tzra espada ruq'uin je' che', etkon ta cmal cjefe sacerdote y cmal maestro je nquetijona cxin wnak tzrij rley Dios y cmal chka' je' principal-i' rxin tnamet. Etkon ta che necrechpa' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ja' Judas jnejchowa rxin Jesús arja' xchumij ta cuq'uin wnak nak xtuban tzra Jesús che njachbej rxin pquek'a': —Tak xtetz'et acha je xtentz'ubaj ruchi' chewech ja c'ara', techpa' y tec'ma' ela per bien tebna' cwent. Cara' xchumsaj cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Xba c'a alnak ja' Judas ruq'uin Jesús, tak xekaja ruq'uin xk'ijla': —Maestro, Maestro, cara' xbij y xtz'ubaj ruchi'. ");
INSERT INTO tzjE_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","C'jara' je' wnak xquechap Jesús y xquecsaj preso. ");
INSERT INTO tzjE_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","C'ol c'a jun chca e rexbil Jesús chek q'uenjlal xerelsaj ta jun espada y c'ola jun mos rxin nimlaj sacerdote xch'upuj ela jun rexquin. ");
INSERT INTO tzjE_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ja' Jesús chpon chic cmal wnak y cawra xbij chca: —¿Le en elk'om anen tak rmal ra' ec'mon ta espada ruq'uin je' che' chwij che nchapic? ");
INSERT INTO tzjE_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Per xenc'je' wan checjol chpam nimlaj templo rxin Dios y k'ij k'ij xentijoj wnak chpam per majo'n wan xenechap ta tzra'. Per njelal jawrara majo'n chek ta nbantaja, rumac che nbantaja cumplir jtz'ibtanak cana chwij ojer chpam rtzojbal Dios. Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","C'jara' je' rdiscípulo xqueya' cana y xenanmaj ela. ");
INSERT INTO tzjE_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","C'ol c'a jun ala' retreben Jesús, arja' majo'n retziak y xjun sábana rebron ri' chpam per xcha'pa cmal wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Per jxuban, xch'akij cana sábana y nsensic xnanmaj ela. ");
INSERT INTO tzjE_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Je' wnak jxechpowa rxin Jesús arj-e' xquec'om ela chwech nimlaj sacerdote. Tzra' quemlon wa' qui' cjefe sacerdote e quexbil principal-i' rxin tnamet e quexbil chka' je' maestro je nquetijona cxin wnak tzrij rley Dios jtz'ibtanak cana rmal Moisés. ");
INSERT INTO tzjE_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ja' Pedro retreben Jesús per q'ue c'nat c'o wa'. Arja' tak xekaja abar c'o wa' jnimlaj jay rxin nimlaj sacerdote xoc oca chujay y tzra' xetz'be' wa' chuchi' jun k'ak' cuq'uin policía, xumaj rmak'ric ri'. ");
INSERT INTO tzjE_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Je' cjefe sacerdote e quexbil jle' chic jec'ola chpam k'atbaltzij cxin aj Israel arj-e' xquemaj cconxic jle' wnak che nqueya' testig-il tzrij Jesús. Cara' nqueban ch-utz c'ara' nkaja cmic tzrij. Per nmajo'n achnak necchapbej rxin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","E q'uiy wnak xqueya' testig tzrij per me ktzij ta necbij tzrij, xe tz'koj tzij nqueban, junwa' nbij jun y jun chwa' nbij chic jun, ne mjunam ta necbij. ");
INSERT INTO tzjE_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ec'o chic jle' chca, arj-e' xepe'a y xquemaj rbixic jle' ril Jesús per xe tz'koj tak tzij xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Jala acha, ajoj kc'axan cawra nbij ra: —Anen quenyoj na jawra santlaj rtemplo Dios jxe wnak banyona y x-oxi' k'ij quenyic wa' jun chic per me wnak ta nebnowa. Cara' rbin, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Per nexte j-e' chka' junam ta necbij. ");
INSERT INTO tzjE_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jnimlaj sacerdote arja' xpe'a chquecjol wnak y cawra xbij tzra Jesús. —¿Le mtac'ulba' c'a je nbixa chawa? Camic, tbij c'a chwa nak rbanic testig-il je xya'a chawij cmal ach-i'. ");
INSERT INTO tzjE_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Per Jesús majo'n nc'ulba' ta je nbixa tzra. Cawra xbix chic tzra rmal jnimlaj sacerdote: —Tbij chka ¿le atet at Cristo je at Rlec'wal jnimlaj Dios? ");
INSERT INTO tzjE_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús cawra xbij tzra: —Anen nc'a. Y netz'et na chka' je xtuban Rlec'walxel jxoca alxic cuq'uin wnak, arja' pe rejquenk'a' Dios netz'be' wa' jabar c'o wa' jnimlaj poder rxin Dios, y netz'et chka' tak xtpet chic jmul c'mon ta rmal jle' sutz' rxin chcaj, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jnimlaj sacerdote c'ola jun tziak rucsan xurak com congan itzel xc'axaj je xbixa rmal Jesús y cawra xbij chca jquemlon qui' ruq'uin: —Camic, majo'n chic más testigo nquekajo' ta. ");
INSERT INTO tzjE_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Com bien xewc'axaj je xbij, najni'la itzel nc'axaj Dios je xbij. Camic ¿nak nebij ixix tzra? cara' xc'axaj chca. Conjelal cawra xecbij: —Ne nyataj wa' tzrij che ncamsasa. ");
INSERT INTO tzjE_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ec'ol jle' chca xquemaj rchubxic Jesús. Chka' xectz'apij rwech tzan sut y tak xtz'aptaja cmal xquech'ay y cawra necbij tzra: —Tbij chka camic ¿nak xyowa k'a' chaplaj? cara' necc'axaj tzra per xe yk'onem nqueban tzra. Je' policía chka' xquemaj rya'ic k'a' chruplaj. ");
INSERT INTO tzjE_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro arja' tz'bula chujay, c'ol c'a jun aj-ic' jnesmaja ruq'uin nimlaj sacerdote xekaja ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Jara' aj-ic' tak xutz'et Pedro che remjon rmak'ic ri' chi k'ak' xtz'ulchij y cawra xbij tzra: —Atet at jun chka' xawexbilaj Jesús aj Nazaret. ");
INSERT INTO tzjE_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro majo'n xuya' ta tzrij je xbixa tzra: —Anen majo'n wutkin ta jamjon rbixic, nak la nabij chwa, cara' xbij tzra ixak. Xyictaj ela, xba abar c'ol wa' chijay y jpre'y chek q'uenjlal xtrekena. ");
INSERT INTO tzjE_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Per aj ic' arja' xtz'ulchij chic jmul Pedro y cawra xbij chca jec'ola tzra': —Jawra jun acha rexbilan Jesús, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Per ja' Pedro majo'n xuya' ta tzrij je xbix tzra. Y q'ue nc'aj co'l bitanak kaja tzra xbix chic jmul tzra Pedro cmal jec'ola tzra': —Bien k'alaj che atet at quexbil jerexbilan Jesús com bien k'alaj che at aj Galilea y jatzij njunam ruq'uin ajni' nquetzijona arj-e', cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chwech Dios quenbij chewa che anen majo'n wutkin ta rwech Jesús jnebij chwa y itzel ta xtquenrutz'et Dios wme ktzij ta quenbij, cara' xbij Pedro chca. ");
INSERT INTO tzjE_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Chek xbitaja tzij rmal, xtreken chic jmul pre'y. C'jara' xerkaja pe rwá' Pedro jbin tzra rmal Jesús. —Tak q'uemjana tetrekena camul pre'y, oxmul nabij na chwa cawrara: —Anen majo'n wutkin ta rwech Jesús. Cara' bin cana tzra. Tak xumaj rch'obic jbin tzra rmal Jesús xumaj jun nimlaj ok'ej. ");
INSERT INTO tzjE_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tak xeskara xquemol qui' conjelal je' cjefe sacerdote che rchumsic nak nqueban tzra Jesús, e quexbil je' principal-i' rxin tnamet, e quexbil chka' je' maestro je nquetijona cxin wnak tzrij rley Dios y conjelal jle' chic e k'toy tak tzij cxin tnamet Israel. Xquebac' ela Jesús, xquec'om ela, xequejcha' pruk'a' Pilato jgobernador. ");
INSERT INTO tzjE_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato tak pa'l chic Jesús chwech arja' xc'axaj tzra: —¿Le atet ra at Rey cxin tnamet Israel? —Cara' ajni' nabij kaja, cara' xbij Jesús tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Je cjefe sacerdote q'uiy rwech ril Jesús xquemaj rbixic tzra Pilato. ");
INSERT INTO tzjE_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","C'jara' ja' Pilato xc'axaj chic tzra Jesús: —¿Le mtac'ulba' je nbixa chawa? congan q'uiy awil necbij chawa, cara' nbij chic tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Per Jesús next jun tzij xbij, nmajo'n xc'ulba' ta. Ja' Pilato congan junwa' xutz'et tak cara' xuban. ");
INSERT INTO tzjE_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ja' Pilato ne c'mannak wa' tzra chc'ola jun preso nsak'pij ptak nimk'ij pascua per nuya' c'as tzra tnamet che arj-e' nquec'utuna nak preso nsak'pix ela. ");
INSERT INTO tzjE_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ec'o c'a jle' preso arj-e' e'ocnak pcars rmal xeyictaja tzrij gobierno y ec'ola jle' wnak xeccamsaj. C'o c'a jun chca rubi' Barrabás. ");
INSERT INTO tzjE_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","C'jara' xe'ekaja wnak ruq'uin Pilato y cawra xecbij tzra: —Tsak'pij ela jun preso com ncawara' abnon chka ptak nimk'ij pascua, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","—¿Nak newajo', lc'ola egan che nsak'pix ela jrey ewxin ixix ix aj Israel? cara' xc'axaj ja' Pilato chca. ");
INSERT INTO tzjE_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Cara' xc'axaj chca com arja' rutkin che je' cjefe sacerdote congan nk'utluna canm tzrij Jesús y xe rmal je nk'utluna canm tak quejchon pruk'a'. ");
INSERT INTO tzjE_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Per je' cjefe sacerdote xequeyoj wnak y xecbij chca che necc'utuj Barrabás che nsak'pix ela y mJesús ta. ");
INSERT INTO tzjE_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ja' Pilato xbij chic jmul chca: —Wcara' newajo' ¿nak c'a quenban tzra nech'ob ixix jawra acha jrey cxin tnamet Israel nebij tzra? Cara' xbij ja' Pilato chca. ");
INSERT INTO tzjE_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Arj-e' xquemaj chic jmul rakic quechi' y cawra necbij: —Tcamsaj chwech cruz. ");
INSERT INTO tzjE_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Nak q'ue tzra, nak rtzilal rebnon? cara' xc'axaj ja' Pilato chca. Per arj-e' más xquemaj rakic quechi': —Tcamsaj chwech cruz, cara' xecbij chic jmul tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ja' Pilato majo'n nrajo' ta che nqueyojtaja más je' wnak rmal c'ara' xuban ajni' necc'utuj j-e' wnak, xsak'pij ela Barrabás y xuya' orden che nch'a'ya Jesús. Tak xch'aytaja xujach pquek'a' je nquec'mow ela rxin che necamsasa chwech cruz. ");
INSERT INTO tzjE_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","C'jara' j-e' soldado xquec'om ela Jesús chujay abar nec'je' wa' gobernador y xequemol conjelal jle' chic soldado. ");
INSERT INTO tzjE_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","C'ola jun tziak mrad xquecsaj tzrij y xecchumsaj jun rcorona, q'uix xquecsaj y xqueya' pe rwá'. ");
INSERT INTO tzjE_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","C'jara' nqueya' rsaludo ajni' nba'na tzra jun rey per xjic necyok'bej rxin: —Atet at rey cxin tnamet Israel, cara' necbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","C'ola jun aj necwak'ij rwá' tzra y necchubaj y nquexque'a chwech ajni' ruk'ij nqueya' per xyok'bal rxin nqueban. ");
INSERT INTO tzjE_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tak xec'choja yk'onem cmal c'jara' xquejal retziak mrad y xquecsaj retziak c'jara' xquec'om ela che nequirpa' chwech cruz. ");
INSERT INTO tzjE_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tak xeba c'ola jun acha xquewil, Simón rubi', arja' c'xemloj ta ptayu' y tzra' xk'ax wa' abar ec'o wa', y npors xqueban tzra che ntelej ela cruz rxin Jesús. Ja' Simón arja' aj Cirene, ec'ola e c-e' rlec'wal, jun Alejandro rubi' y jun chic Rufo rubi'. ");
INSERT INTO tzjE_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","C'jara' xeba, xquec'om ela Jesús pjun lwar rbin-an Gólgota. Gólgota nbij tzij lwar rxin rwá' camnak. ");
INSERT INTO tzjE_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tak xe'ekaja chpam lwar Gólgota xectzujuj vino tzra chnutaj. Jvino c'ola nic'aj k'ayis mirra rubi' yjun ruq'uin per Jesús majo'n xuc'om ta chca. ");
INSERT INTO tzjE_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tak xriptaja cmal chwech cruz xquemaj rbanic suert tzrij retziak. Cara' xqueban ch-utz c'ara' che nquetz'et nak che tziak xtquec'om ela che jujnel. ");
INSERT INTO tzjE_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jhor je xquerip chwech cruz a las nueve rxin xinak'a'. ");
INSERT INTO tzjE_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ja' Jesús xtz'ibaxa ril je nbixa tzra, cawra rbanic ril je nbixa: —Jawra acha, arja' rey cxin tnamet Israel. ");
INSERT INTO tzjE_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ec'o c'a e c-e' elk'oma' xeri'pa chwech cruz chka', jun prejquenk'a' Jesús y jun prexquen. ");
INSERT INTO tzjE_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tzra' c'a xbantaj wa' cumplir jtz'ibtanak cana ojer chpam rtzojbal Dios tzrij Cristo jcawra nbij: —Arja' cara' nba'na tzra ajni' nba'na chca itzel tak wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Je' wnak tak nquek'axa y tak nquetz'et Jesús xnectzebej y xe nqueyok' y cawra necbij tzra: —Atet xatbina chnayoj santlaj templo y xe oxi' k'ij nrajo' chnayic chic jmul. ");
INSERT INTO tzjE_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Camic tet-o' c'a awi' ayon, catkaj tc'a chwech cruz, cara' necbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Chka' je' cjefe sacerdote arj-e' nqueyok' chka' e quexbil maestro je nquetijona cxin wnak tzrij rley Dios. —Arja' To'onel cxin wnak nbixa tzra per camic xmesquier nara' nuto' ri' ruyon. ");
INSERT INTO tzjE_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","We ktzij che arja' Cristo jRey kxin ja ok aj Israel tkaj tc'a camic chwech cruz. We xtkatz'et xtkaj ta neyke' c'ara' kac'u'x ruq'uin, cara' xecbij. Ncara' xqueban jxeri'pa chwech cruz prexquin Jesús, arj-e' chka' xqueyok'. ");
INSERT INTO tzjE_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jpe nc'aj k'ij c'ola jun nimlaj k'ejku'm xpeta chwech njelal ruch'lew, c'a las tres rxin tk'ak'ij xeskar chic jmul. ");
INSERT INTO tzjE_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ja' Jesús tak xuban a las tres rxin tk'ak'ij arja' congan xurak ruchi' y cawra xbij ra: —Eloi, Eloi ¿lama sabactani? cara' xbij. Jtzij xbij cawra nbij: —Nedta' Dios, Nedta' Dios ¿nak tzra tak xenaya' cana? ");
INSERT INTO tzjE_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ec'o c'a jle' chca wnak jec'ola tzra', arj-e' tak xecc'axaj je xbij cawra xecbij: —Jala' acha camnak profeta Elías nsiq'uij. ");
INSERT INTO tzjE_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","C'o c'a jun chca xerc'amla' ta jun esponja, xch'akba' chpam jle' vinagre, xuxim chutza'm jun aj y xuya' pona tzra Jesús chnutaj y xbij: —Keybej na, katz'ta' na k'alaj we xtpeta Elías chnerkasaj chwech cruz. ");
INSERT INTO tzjE_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ja' Jesús xurak chic jmul ruchi' y xcom kaja. ");
INSERT INTO tzjE_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Y chek q'uenjlal xraktaja mant jk'otben rpam santlaj rtemplo Dios, chek c-e' xuban. Xraktaj ta q'ue chcaj y xkaja penlew. ");
INSERT INTO tzjE_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","C'o c'a jun capitán pa'la chwech Jesús, arja' tak xutz'et nak xuban tak xcoma cawra xbij: —Jala acha ne ktzitzij wa' che Rlec'wal Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ec'o c'a jle' ixki' jec'ola tzra' chka' nquetzu' pona je xbantaja. Jun chca María Magdalena, jun chic María jec'ola e c-e' ral, jun José y jun chic Jacobo ch'ip nbixa tzra. Y jun chic chca ixki' Salomé rubi'. ");
INSERT INTO tzjE_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","J-ewra ixki' tak xec'je'a Jesús pGalilea arj-e' netrena tzrij Jesús y xqueto' tzrij je' achnak jnak nc'atzina tzra. Y q'ue c'o na más ixki' jxetre' ela tzrij Jesús tak xba pJerusalén. ");
INSERT INTO tzjE_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","C'o c'a jun acha José rubi' aj Arimatea, arja' nim ruk'ij chpam k'atbaltzij cxin tnamet Israel y chka' njelal ranm reyben k'ij tak xtoca rgobierno Dios. Ja' José com xuban hor y com jara' k'ij nchomix wa' je' achnak rxin nimk'ij y xvíspera chic rxin xlanbal k'ij chka', rmal c'ara' tak xba ruq'uin Pilato xerc'utuj recuerpo Jesús y majo'n xxibej ta ri'. ");
INSERT INTO tzjE_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ja' Pilato tak xc'axaj che camnak chic Jesús arja' cawra xbij kaja pranm: —¿Nak tzra c'ara' tak camnak chic? Y xsiq'uij pona jun capitán, xc'axaj tzra we ktzitzij wa' camnak chic Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tak xbixa tzra rmal capitán che ktzij wa' camnak chic c'jara' xuya' órden che nja'cha recuerpo tzra José. ");
INSERT INTO tzjE_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","C'jara' José xulok' jun tziak, xberkasaj ta recuerpo Jesús chwech cruz y xubor pjun utzlaj tziak. Tak xbortaja rmal xerey-a' cana chpam jun panteón je c'ton chwech jun tz'lem abaj y xtz'apij ruchi' tzra jun tz'lem abaj. ");
INSERT INTO tzjE_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ja' María Magdalena rexbil chic jun María jrute' José arj-e' ec'ola tzra' y xquetzu' pona jabar xec'je' can wa' recuerpo Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tak xk'axa xlanbal k'ij ja' María Magdalena rexbil jun chic María jrute' Jacobo, rexbil chka' Salomé, arj-e' xquelok' jle' ak'om jqui' rexla' ch-utz c'ara' nqueba y nequey-a' tzrij recuerpo Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Je rxin domingo pe rsakric xeba abar c'o wa' panteón, kas nel ta k'ij tak xe'ekaja chpam lwar. ");
INSERT INTO tzjE_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","—¿Nak lc'a xtelsana abaj jtz'apben ruchi' panteón ch-utz c'ara' nokocwina nok-oc chpam? cara' necbij chbil tak qui'. ");
INSERT INTO tzjE_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Per tak xquetz'et pona lsan chic abaj, bien xquetzu' pona com abaj congan nim. ");
INSERT INTO tzjE_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tak xe'oca chpam panteón c'ola jun c'jol xquetz'et, pe jquenk'a' tz'bul wa', c'ola jun nimlaj tziak sak rucsan. Arj-e' congan xecxibej qui' rmal. ");
INSERT INTO tzjE_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Per ángel cawra xbij chca: —Mtexibej ta ewi'. Anen wutkin chJesús je aj Nazaret necanoj, je xcamsasa chwech cruz, arja' xc'astaja rwech, mwawe' xta c'o wa'. Quixjo', tretz'ta' mpa' lwar abar xec'je' wa' recuerpo. ");
INSERT INTO tzjE_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Per camic jax ebij tzra Pedro y chca jle' chic discípulo cawrara: —Jesús arja' nnabyeja chewech nba pGalilea y tzra' netz'et wa' ewi' ruq'uin ajni' rbin cana chewa. Cara' tbij chca, cara' xbij ja' ángel. ");
INSERT INTO tzjE_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","J-e' ixki' alnak xe'el ta chpam panteón, cara' xqueban com congan nqueberbeta rumac xben ri'il. Y nmajo'n abar ta tzra' xecbij wa' je xquetz'et rmal jcongan xecxibej qui'. ");
INSERT INTO tzjE_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ja' Jesús tak xc'astaja chquecjol cnomki' pjun domingo pe rsakric. Kas xuc'ut wa' ri' nabey mul jara' chwech María Magdalena. Jara' María jec'ola e wku' itzel tak espíritu e'ocnak pranm nabey y xelsas ela rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Arja' xba cuq'uin ach-i' j-era' jnetren wa' tzrij Jesús tak q'uemjana tcoma, nerbij chca che xc'astaja Jesús. Tak xekaja cuq'uin congan bis ok'ej nqueban. ");
INSERT INTO tzjE_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Cawra xbij chca: —C'astanak chic Jesús, xentz'et rwech anen, cara' xbij chca, per j-e' majo'n xecnimaj ta. ");
INSERT INTO tzjE_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ja' Jesús ec'o chic e c-e' rdiscípulo, arj-e' quemjon binem ebnak pjun aldea tak chek q'uenjlal xuc'ut ri' chquewech per junwa' nca'ya rmal c'ara' mesquier xch'obtaj ta cmal alnak chJesús. ");
INSERT INTO tzjE_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Per tak xch'obtaja cmal xeba cuq'uin jle' chic quexbil, xecbij chca: —C'astanak chic Jesús, cara' xecbij, per me xnimax ta jxecbij. ");
INSERT INTO tzjE_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tak xba jtz'it tiemp tzra xuc'ut chic jmul ri' Jesús chquewech je juljuj rdiscípulo, j-e' kas etz'bula tzrij mes. Ja' Jesús arja' cow xtzijona cuq'uin rmal jmajo'n yukbal quec'u'x ruq'uin y rmal jmesquier necnimaj che xc'astaja. Cara' xuban chca com j-e' majo'n xecnimaj ta je xbixa chca cmal jxetz'towa rxin che c'astanak chic. ");
INSERT INTO tzjE_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","C'jara' xbij chic chca: —Jax nat nkaj chwech ruch'lew, ey-a' rbixic utzlaj tzij jnec'mon ta, ey-a' rbixic chca conjelal wnak. ");
INSERT INTO tzjE_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Conjelal wnak je xteyke'a quec'u'x wq'uin y nqueba'na bautizar arj-e' nquewil totanem rxin Dios. Wme xteyke' ta quec'u'x wq'uin arj-e' nk'a't na tzij chquij y nqueta'k ela chpam nimlaj lowlo'. ");
INSERT INTO tzjE_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jawra rital nbantaj na cuq'uin je xteyke'a quec'u'x wq'uin: jun, pnubi' anen nquequelsaj wa' itzel tak espíritu pcanm wnak, jun chic, nquetzijona chpam jle' chic tzojbal jmajo'n cutkin ta, ");
INSERT INTO tzjE_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","jun chic, chek q'uenjlal nquequechap itzel tak cmetz per majo'n achnak nba'na chca, y chka' we chek q'uenjlal xquetaj venen majo'n achnak nuban chca chka'. Chka' we nqueya' quek'a' pquewá' je' yuw-i' arj-e' nquechumtaja. Cara' xbij chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ja' Kajaw Jesús tak xec'choja tzij rmal cuq'uin rdiscípulo arja' xec'mar ela chcaj, xetz'be'a pe rejquenk'a' Dios. ");
INSERT INTO tzjE_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Je rdiscípulo arj-e' xe'el ela, xquemaj rbixic Jesucristo nat nkaj. Ja' Kajaw Jesús nquerexbilaj che rbanic samaj, xuya' chca chc'ola nmak tak milagro nqueban jara' nec'tuwa che ne ktzitzij wa' njelal jquemjon rbixic chca wnak. Amén.");
INSERT INTO tzjE_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nimlaj acha Teófilo, anen c'ola jun wuj xentz'ibaj y camic quenwajo' quentak ela awq'uin. E q'uiy wnak je bien quech'bon cana nak rebnon cana Dios chkawech y jara' ctz'iban chic. ");
INSERT INTO tzjE_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Je ctz'iban njunam ruq'uin je xbixa chka ajoj cmal jxetz'towa njelal nimlaj samaj jxuban cana Jesús, chka' arj-e' xquech'ob chquewech wnak utzlaj tzij je rxin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Anen xenmaj ta rch'obic jabar wankernak twa' njelal jrebnon Dios chkawech y xnec'sa' abar c'o wa' camic. Bien xench'ob rij rwech y kas wen rchumic xenban, xentz'ibaj njelal y camic quenwajo' quentak awq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Quentak ela awq'uin ch-utz c'ara' bien nawutkij che ne ktzij wa' utzlaj tzij rxin Jesucristo je c'tun chic chkawech. ");
INSERT INTO tzjE_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pretiemp Herodes rey rxin Judea c'ola jun sacerdote Zacarías rubi'. Ja' Zacarías arja' jun chca e jmoc sacerdote jbin-an chca e rxin Abías. Elizabet rubi' rexkayil. Ja' Elizabet arja' chka' riy rumam ja ojer nimlaj sacerdote Aarón. ");
INSERT INTO tzjE_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías rexbil Elizabet arj-e' rbeyal quebnon chwech Dios, necnimaj mandamiento y necnimaj jle' chic jtz'ibtanak cana chpam rtzojbal Kajaw Dios, nmajo'n nquechapbexa. ");
INSERT INTO tzjE_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Per majo'n clec'wal com ja' Elizabet majo'n alanem tzrij y xe e ch'tak rija' chic che c-e'. ");
INSERT INTO tzjE_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Xuban jmul ja' Zacarías e rexbil jle' chic sacerdote e rxin Abías arj-e' ec'ola chpam quesman, quemjon rsamaj Dios chpam nimlaj templo. ");
INSERT INTO tzjE_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","J-e' sacerdote ne ccostumbre wa' che nqueban suert nak chu tzrij nkaj wa' che noca chpam santlaj rtemplo Kajaw Dios che rporxic incienso. Cara' c'a xqueban y tak xec'choja suert cmal, tzrij Zacarías xkaj wa' rmal c'ara' tak xoca Zacarías chpam santlaj lwar che rporxic incienso. ");
INSERT INTO tzjE_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kas remjon c'atem incienso, congan e q'uiy wnak quemlon qui' chwech santlaj templo, quemjon rij oración. ");
INSERT INTO tzjE_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chek q'uenjlal tak c'ola jun ángel rxin Kajaw Dios xwankera ruq'uin Zacarías. C'ola jun altar abar nporox wa' incienso, tzra' pa'l wa' ángel prejquenk'a' altar. ");
INSERT INTO tzjE_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ja' Zacarías tak xutz'et j-ángel congan junwa' xuna', congan xxibej ri' rmal. ");
INSERT INTO tzjE_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Per ja' ángel cawra xbij tzra: —Zacarías, mtaxibej ta awi' com Dios rc'axan aworación, Elizabet jawexkayil arja' c'ola jun ral ala' nec'je' na chruk'a'. Tak xtalexa je ch'tala' Juan rubi' xtaya', ");
INSERT INTO tzjE_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","y ajni'la xtquicota awanm rmal y e q'uiy wnak cara' nqueban chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Com ja' ala' congan nim ruk'ij ntz'e't na rmal Dios. Nmajo'n vino xtutaj ta nexte xtutaj ta jle' chic achnak xe ncatek'bara rmal. Q'uemjana talexa tak xtnoja Espíritu Santo pranm. ");
INSERT INTO tzjE_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Rmal arja' tak e q'uiy wnak aj Israel arj-e' nqueq'uex cna'oj y necnimaj chic Kajaw Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tak xtoca acha nnabyeja chwech Cristo che rchumsic rubey, ncara' ranm ajni' ranm ojer profeta Elías y ncara' rpoder chka' ajni' rpoder Elías. Jara' nyataj na tzra awlec'wal ch-utz c'ara' nquerchumsaj ttixela' cuq'uin clec'wal, ch-utz c'ara' chka' che je' wnak jmajo'n nqueniman ta ncutkij necc'aj je rbeyal rxin Dios. Cara' c'a xtuban, nquerchumij pona wnak ch-utz c'ara' cchumin pon chic qui' che rc'ulic Kajaw Cristo. Cara' xbij ángel tzra Zacarías. ");
INSERT INTO tzjE_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Per ¿nak nac'utbej chenwech che ktzitzij nabij la? Com anen xen ri'j chic y cara' wexkayil chka', xok rija' chic chok c-e', cara' xbij Zacarías tzra ángel. ");
INSERT INTO tzjE_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ja' ángel cawra xbij chic tzra: —Anen en Gabriel, ne chwech Dios enelnak twa'. Ja' Dios enretkon ta che quenrtzijona awq'uin, enretkon ta chquenrbij chawa utzlaj tzij je c'ja' xenbij kaja chawa. ");
INSERT INTO tzjE_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Per bien tewc'axaj je xtenbij chic chawa. Com majo'n xanimaj ta utzlaj tzij jxenbij chawa rmal c'ara' tak ncatoca mem camic. Tak xtbantaja cumplir jxenbij chawa c'jara' xtcatzijon chic jmul. Atet majo'n xanimaj ta utzlaj tzij jxenbij chawa per tak xterla' tiemp rxin tzra' c'ara' nbantaj wa' cumplir, cara' xbij tzra Zacarías. ");
INSERT INTO tzjE_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Je' wnak arj-e' ec'o cana chwech santlaj templo, queyben Zacarías: —¿Nak tzra c'a wa' ntak congan xeyloja Zacarías chpam santlaj templo? cara' necbij kaja ptak canm. ");
INSERT INTO tzjE_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tak xel ta Zacarías majo'n chic necwin ta ntzijona cuq'uin wnak. J-e' wnak xch'obtaja cmal chc'ola jun achnak xutzu' chpam santlaj templo com arja' xruk'a' chic nusil chquewech, nmajo'n chic tzij xbij ta chca. ");
INSERT INTO tzjE_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tak xuq'uis resman xba ja' Zacarías chruchoch. ");
INSERT INTO tzjE_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Xerla' k'ij tak yawa' chic Elizabet rmal ral jc'ola pe gracia. J-o' ic' nmajo'n xel pta pruchoch, cawra xbij kaja pranm ra: ");
INSERT INTO tzjE_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Cawra rebnon Kajaw Dios chwa, c'o chic wal rey-on y rmal c'ara' majo'n chic q'uixbal ta quenna' chquewech wnak je nquelsana ntzojxic chmajo'n wal, cara' nbij kaja. ");
INSERT INTO tzjE_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ja' Elizabet wajki' c'o chwa' tak Dios xutak pchic jmul ángel Gabriel. Chpam tnamet Nazaret xutak wa' jc'ola precwent departamento Galilea. ");
INSERT INTO tzjE_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ruq'uin jun k'poj xtan xutak wa', María rubi'. Ja' María c'utun chic rmal jun c'jol, José rubi', chnec'le'a ruq'uin. Ja' José arja' riy rumam ojer rey David. ");
INSERT INTO tzjE_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tak xekaja ángel jabar c'o wa' María cawra xbij tzra ra: —María, camic Dios kas wen rebnon chawa, arja' c'ola awq'uin. Camic más na utzil rsipan Dios chawa atet que chquewech conjelal ixki', cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ja' María tak xutz'et ángel y tak xc'axaj je xbixa tzra xsa'cha rna'oj rmal: —¿Nak tzra c'a wa' tak nbij cara' chwa? cara' nbij kaja pranm. ");
INSERT INTO tzjE_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ja' ángel cawra xbij chic tzra: —María, mtaxibej ta awi' com atet awlon utzil je nsipaj Dios chawa. ");
INSERT INTO tzjE_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Camic ncatoca yawa', com c'ola jun awal ch'tala' naya'. Tak xtalexa ch'tala' Jesús rubi' naya'. ");
INSERT INTO tzjE_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tak xtoca nim ajni'la nim ruk'ij, Rlec'wal nimlaj Dios nbixa tzra. Arja' riy rumam ojer rey David, y ja' Kajaw Dios xtucsana rxin rey ajni' xuban tzra David ojer. ");
INSERT INTO tzjE_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Noca rey pnewá' je ix riy rumam Jacob y nquixerc'aj rxin junlic chpam je' tiemp jpenak, y je rgobierno nmajo'n nq'uis ta. Cara' xbij ángel tzra María. ");
INSERT INTO tzjE_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","—¿Nak tzra c'ara' xtbantaja cumplir jnabij la per q'uemjana tenc'le'a? cara' xbij María. ");
INSERT INTO tzjE_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Cawra xbix chic tzra rmal ángel: —Espíritu Santo arja' nkaj ta awq'uin y jpoder rxin nimlaj Dios jara' nesmaja awq'uin rmal c'ara' jsantlaj ac'al je xtec'je'a chwak'a' Rlec'wal Dios nbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Camic twutkij che Elizabet jawch'alal mesque nri'j chic per c'ol chic ch'it ral pe gracia chka'. Je' wnak arj-e' necbij tzra chmajo'n alanem tzrij per camic wajki' c'o chwa', ");
INSERT INTO tzjE_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","com ja' Dios majo'n achnak je mquita necwina nuban, cara' xbixa tzra María. ");
INSERT INTO tzjE_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","—Anen enc'ola pruk'a' Wajaw Dios. Tebna' c'a chwa ajni' xabij kaja chwa, cara' xbij ja' María. C'jara' xba ja' ángel, xuya' cana María. ");
INSERT INTO tzjE_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ja' María nalnak xchumla' ri' xba chpam jun tnamet jc'ola chwech jun jyu' jc'ola precwent departamento Judea. ");
INSERT INTO tzjE_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tak xekaja chpam tnamet xoc oca pruchoch Zacarías y xk'ijla' Elizabet. ");
INSERT INTO tzjE_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ja' Elizabet tak xc'axaj je xk'ijloxa rmal María chek q'uenjlal tak xuna' ch'it ral jc'ola pe gracia congan xusil ri' y xnoja Espíritu Santo pranm Elizabet, ");
INSERT INTO tzjE_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Arja' cow xtzijona y cawra xbij tzra María: —Camic más wen yatanak chawa rmal Dios que chquewech conjelal ixki' y najni'la wen yatanak tzra ch'tawal chka' jc'ola pe gracia. ");
INSERT INTO tzjE_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Nak c'a nbanic anen che Dios rey-on chwa camic che atpenak wq'uin? Utz tc'ara' per che mquita at rute' Wajaw. ");
INSERT INTO tzjE_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Cara' quenbij chawa com anen chek xnak'ijla', xenna' ch'it wal jc'ola pe gracia congan xusil ri' rmal quicotemal. ");
INSERT INTO tzjE_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Congan quicotemal chawa com xanimaj che nbantaj na cumplir je xbixa chawa rmal ángel je xta'k ta rmal Kajaw Dios, cara' xbij ja' Elizabet. ");
INSERT INTO tzjE_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ja' María cawra xbij ra: —Jcamic njelal nuc'u'x y njelal wanm quenya' ruk'ij Kajaw Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Congan nquicota wanm com Dios arja' To'onel wxin. ");
INSERT INTO tzjE_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Quenquicota com Dios enrech-on camic per nmajo'n nara' nim ta nuk'ij, per xe en jun ajsmajma' rxin. Je' wnak jec'ola chpam jawra tiemp jokc'o wa', ruq'uin je' wnak jq'uemjana tque'alexa chka bechnak opech tiemp xtquec'je' wa', arj-e' cawra xtecbij chwa ra: —Ja' Dios ajni'la quicotemal rey-on tzra María, cara' necbij na chwa. ");
INSERT INTO tzjE_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Com Dios congan nmak tak achnak rey-on chwa camic, ajni'la poder c'ola pruk'a' y jrubi' jara' Santlaj Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ne npoknaj wa' kawech we nekxibej ki' chwech, ncawara' nuban chka ja ok wnak chka bechnak tiemp opech xtokoc'je' wa' wawe' chwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bien xk'alsaj chkawech chcongan poder c'ola pruk'a', xerkasaj wnak je nquena' kaja chcongan nim quek'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Xerelsaj ela e nmak tak rey ptak k'atbaltzij per xuya' quek'ij wnak jmajo'n nmak ta quek'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Congan utzlaj tak achnak xuya' chca wnak je nk'ak'ana quepam per je' byoma' arj-e' xbij chca che nque'ela y nmajo'n achnak xuya' ela chca. ");
INSERT INTO tzjE_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Xokruto' ja ok aj Israel jokrech-on che nkaban rsamaj, xokrnataj y xpoknaj kawech. ");
INSERT INTO tzjE_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Xbij chca kti't kawma' ojer chcara' nuban na chka. Xbij che npoknaj rwech Abraham ruq'uin je' rjatzul y ncara' nuban chca rxin junlic. Cara' xuban com cara' rtzujun cana chca kti't kawma' ojer ajni' tzra Abraham y ajni' chka ajoj ja ok riy rumam cana Abraham chka bechnak opech tiemp nokoc'je' wa' wawe' chwech ruch'lew. Cara' xbij ja' María. ");
INSERT INTO tzjE_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Xec'je' chna oxi' ic' María ruq'uin Elizabet c'jara' xemloja chruchoch. ");
INSERT INTO tzjE_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tak xetz'kata retiemp Elizabet xec'je'a ch'it ral ala'. ");
INSERT INTO tzjE_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Je' rch'alal e quexbil rebcin xekaja rbixic cuq'uin che Dios congan rpoknan rwech y c'ola ch'it ral rey-on, ajni'la xequicota ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Arj-e' tak xuban waxki' ruk'ij ch'tala' xeba ruq'uin com jara' k'ij nba'n wa' circuncidar je ajni' nrajo' ley rxin Moisés. Xeccanoj rubi' ac'al, Zacarías xcajo' ta rubi' xqueya', rec'xel redta'. ");
INSERT INTO tzjE_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Per xpeta rute': —Mcara' ta, Juan rubi' nkaya', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—Per majo'n c'a jun awch'alal Juan rubi'. ¿Nak tzra tak cara' nabij? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","C'jara' xquemaj rbanic quek'a' chwech Zacarías com arja' xmem chic: —¿Nak rubi' awlec'wal nbixa? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ja' Zacarías xc'utuj jun achnak chca abar ntz'ibaj wa' rubi' ac'al: —Juan rubi', cara' xtz'ibaj chquewech. Congan xsa'cha cna'oj rmal per ne che conjelal. ");
INSERT INTO tzjE_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chek q'uenjlal xec'choja Zacarías, majo'n chic mem xta, xumaj chic rij tzij y congan xumaj rya'ic ruk'ij Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Je' bcin arj-e' ne conjelal congan xecxibej qui' rmal, njelal je xbantaja xela rbixic nat nkaj njelal chutakyu' jc'ola precwent departamento Judea. ");
INSERT INTO tzjE_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Conjelal wnak jxec'axana je xbantaja arj-e' xqueyic ptak canm y cawra necbij ra: —¿Nak lc'a samaj xtuban jawra ac'al ra? cara' xecbij tzra ch'tac'al. Bien k'alaj chc'ola Kajaw Dios ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ja' Zacarías jredta' ch'tac'al arja' xnoja Espíritu Santo pranm y xumaj rbixic jle' tzij je xyataja tzra rmal Dios, y tzrij Cristo ntzijon wa' jq'uemjana talexa, cawra xbij ra: ");
INSERT INTO tzjE_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Kas ta xtya'a ruk'ij Kajaw Dios je Dios kxin ajoj ja ok aj Israel com arja' xokrnataj y camic okrelsan chic libre jok retnamet. ");
INSERT INTO tzjE_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Com c'ola jun To'onel retkon ta kuq'uin ajni'la nim poder c'ola pruk'a'. Je To'onel arja' riy rumam ojer rey David je ajsmajma' rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ncara' rebnon Dios ajni' rtzujun cana ojer com je' santlaj tak profeta jxec'je'a chpam ojer tiemp arj-e' ctz'iban cana chc'ola jun To'onel npe na ");
INSERT INTO tzjE_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ch-utz c'ara' noktotaja pquek'a' kac'lel, ch-utz c'ara' noktotaja pquek'a' conjelal wnak jxitzel nokquetz'et. ");
INSERT INTO tzjE_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ja' Dios retkon ta To'onel jara' nbanbej cumplir je rtzujun cana chca kti't kawma' ojer che npoknaj wa' quewech, y jara' xbanbej cumplir chka' jsantlaj chuminem je xchumij ruq'uin Abraham. ");
INSERT INTO tzjE_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tzra' xchumsaj wa' tak c'ola jun juramento xuban je xbij tzra Abraham jkawma' ");
INSERT INTO tzjE_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","che noktotaj na pquek'a' je nquetzelana kxin ch-utz c'ara' majo'n chic nekxibej ta ki' nkaban jnekyabej ruk'ij Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Cara' xuban Dios ch-utz c'ara' chwech arja' nkaban wa' rsamaj ajru' tiemp xtkaban ela chwech ruch'lew, y jnekbanbej rsamaj jara' nekc'aj jun ch'ajch'ojlaj anm y nekc'aj rbeyal chwech. Cara' xbij ja' Zacarías. C'jara' xumaj chic rij tzij, tzrij rlec'wal xtzijon wa' y cawrara xbij: ");
INSERT INTO tzjE_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","—Wlec'wal, atet nbix na chawa che at profeta rxin nimlaj Dios com atet ncatnabyeja chwech Cristo jKajaw ch-utz c'ara' nachumsaj rubey chwech tak xyamer numaj rij rsamaj. ");
INSERT INTO tzjE_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ncatnabyej na chwech ch-utz c'ara' nach'ob chkawech ja ok rtnamet che ncuytaja kil kamac y tzra' nkawil wa' totanem rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Y xe rmal congan npoknaj kawech Dios rmal c'ara' tak cara' nuban chka. Rmal c'ara' tak c'ola jun To'onel retkon ta kuq'uin chcaj je nsakersana kabey chkawech. ");
INSERT INTO tzjE_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ja' To'onel nqueruya' na psak je' wnak jec'ola pje' k'ejku'm jnecxibej qui' chwech cmic, y nokerc'aj na chpam jun bey je rc'an quicotemal. Cara' xbij Zacarías. ");
INSERT INTO tzjE_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Cara' c'a xuban, xq'uiya clec'wal Zacarías ruq'uin Elizabet, congan xecwera más ranm che rbanic utzil. Ptak je' lwar abar je' tlan wa', tzra' nec'je' wa'. Tak xerla' k'ij rxin, xba xumaj rbixic rtzojbal Dios chca aj Israel. ");
INSERT INTO tzjE_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jara' tiemp c'ola jun censo xba'na. C'ola jun nimlaj rey tzra', César Augusto rubi', arja' xuya' jun orden che nqueba'na censar conjelal wnak jec'ola ptak njelal nación. ");
INSERT INTO tzjE_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jawra censo jawa' kas nabey censo xba'na, jara' tiemp c'ola jun acha Cirenio rubi', arja' ocnak gobernador rxin Siria. ");
INSERT INTO tzjE_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Conjelal wnak xeba ptak quetnamet e cti't quemma' ch-utz c'ara' tzra' nba'n wa' censo chca. ");
INSERT INTO tzjE_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","C'ol c'a jun acha José rubi', arja' aj Nazaret jc'ola precwent Galilea. Ja' José xba chka' chnerebna' censar ri'. Rmal c'ara' xel ela chpam tnamet Nazaret y xba chpam tnamet Belén jc'ola precwent Judea jabar xalex wa' ojer rey David. Tzra' xba wa' José, com rey David arja' xespowa cxin e rti't remma'. José arja' riy rumam ojer rey David. ");
INSERT INTO tzjE_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Arja' xetre' ela María tzrij, jara' jnec'le'a ruq'uin. Ja' María arja' yawa' chic y xyamer nec'je'a ch'it ral. ");
INSERT INTO tzjE_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kas tzra' pBelén ec'o wa' tak xetz'kata k'ij rxin. ");
INSERT INTO tzjE_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tzra' c'a xalex wa' ch'it ral ch'tala', jara' nabey ac'al, y xubar pe tziak. Tak xbartaja rmal c'ola jun cwibal chcop xcanoj y xcutz'ba' chpam. Cara' c'a xuban, pquec'olibal chcop xec'je' wa' com enojnak chic wnak chpam je' psad. ");
INSERT INTO tzjE_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ec'ol c'a jle' yk'ul tak carne'l, chenkaj tnamet Belén ec'o wa', equechjalben ch'tak carne'l ptak k'ayis chak'a'. ");
INSERT INTO tzjE_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chek q'uenjlal tak c'ola jun ángel xwankera chquewech tkon ta rmal Kajaw Dios, y xquetzu' regloria Kajaw Dios je ntajina nuq'uiek ri' chquij, congan xecxibej qui' rmal. ");
INSERT INTO tzjE_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Cawra xbixa chca rmal ángel: —Mtexibej ta ewi', tewc'axaj mpa' je xtenbij chewa ra com anen c'ola jun utzlaj tzij nec'mon ta chewa, jun utzlaj tzij ajni'la quicotemal rec'mon ta chca wnak per ne che conjelal. ");
INSERT INTO tzjE_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Jawra utzlaj tzij nec'mon ta chewa ra: jcamic c'ola jun To'onel ewxin c'xalexa, pBelén xalex wa' jabar xalex wa' ojer rey David. To'onel jara' Cristo jKajaw. ");
INSERT INTO tzjE_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tak xtewla' ch'it ch'uch' cawra bnon tzra, bron pe tziak y cutz'ban chpam jun cwibal chcop, jara' rital jquenbij cana chewa, cara' xbij ja' ángel chca. ");
INSERT INTO tzjE_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chek q'uenjlal ec'ol chic jle' rexbil ángel rxin chcaj xewankera per ncongan e q'uiy. Congan quemjon rya'ic ruk'ij Dios, cawra necbij ra: ");
INSERT INTO tzjE_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Jcamic ajni'la majtanak chic rya'ic ruk'ij Dios chcaj, y wawe' chwech ruch'lew yatanak chic chca wnak che qui'il nec'je'a canm chwech Dios, j-era' je ncajo' nqueban achnak nrajo' ranm Dios, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Je yk'ul carne'l tak xemloja ángel chcaj arj-e' cawra xecbij chbil tak qui': —Jo' c'a pBelén ekatz'ta' jbantanak je tkon ta rbixic rmal Kajaw Dios, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Cara' c'a xqueban, xeba alnak. Tak xe'ekaja xquewil María rexbil José, y xquetz'et ch'tac'al cutz'ban chpam cwibal chcop. ");
INSERT INTO tzjE_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tak xquetz'et ch'tac'al c'jara' xquemaj rcholic chquewech wnak jbin cana chca rmal ángel tzrij jawra ac'al. ");
INSERT INTO tzjE_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Je' wnak kas xel ta canm tak xecc'axaj je njelal je xbixa chca cmal je yk'ul carne'l. ");
INSERT INTO tzjE_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Per María arja' xuyic pranm njelal tzij je rc'axan, congan nuch'ob rij rwech nak rec'mon ta. ");
INSERT INTO tzjE_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Je yk'ul tak carne'l arj-e' xemloja, congan quemjon rya'ic ruk'ij Dios rmal je cc'axan y rmal jquetz'ton, ncara' xbantaja ajni' bin cana chca rmal ángel. ");
INSERT INTO tzjE_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jch'it ch'uch' tak xuban waxki' ruk'ij xba'na circuncidar, c'jara' xcanoxa rubi'. Jrubi' xbixa jara' Jesús com cara' xcanoxa rmal ángel tak q'uemjana tec'je'a pe gracia. ");
INSERT INTO tzjE_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Xerla' c'a k'ij che nqueba necch'ach'jorsaj qui' ajni' nbij rley Dios jtz'ibtanak cana rmal Moisés, c'jara' xeba pJerusalén, xquec'om ela ch'tac'al chnequebna' presentar chpam nimlaj templo rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Cara' xqueban com rley Kajaw Dios cawra tz'ibtanak cana chpam ra: —Je' ch'tak al-i' je e nabey tak al arj-e' e rxin Dios per nche conjelal. ");
INSERT INTO tzjE_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ec'ol c'a e c-e' ch'tak tz'quin nquectzujuj chwech Dios com jsacrificio ajni' nbij rley Kajaw Dios jcawra nbij: —Jun c'laj ch'tak xmucur je nquetzujuxa, owe c-e' ch'tak cal tz'quin rxin pjay nquetzujuxa. Cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","C'o c'a jun acha pJerusalén Simeón rubi'. Ja' Simeón arja' jun acha rebnon rbeyal chwech Dios y nuban wa' respetar Dios, nreyben wa' k'ij tak xtpeta To'onel che cto'ic tnamet Israel. C'ola Espíritu Santo ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Espíritu Santo c'ola rk'alsan chic chwech y cawra rbin tzra: —Simeón, atet c'atc'as na tak xtatz'et rwech Cristo je xtta'k ta rmal Dios ja Awajaw, natz'et na rwech, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ja' Simeón xc'axa rmal Espíritu Santo, xba chpam nimlaj templo rxin Dios y njara' hor chka' tak xec'mar ela ch'it ch'uch' Jesús cmal redta' rute' ch-utz c'ara' nba'na tzra ajni' nbij rley Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tak xe'ekaja ruq'uin, ja' Simeón xch'elej ch'it ch'uch' y xumaj rya'ic ruk'ij Dios, cawra xbij tzra Dios ra: ");
INSERT INTO tzjE_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Wajaw, camic utz chic quenac'om ela, qui' chic nuc'u'x chquencoma com camic xaban cumplir jxatzujuj chwa. ");
INSERT INTO tzjE_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Com camic xentz'et ruq'uin nk'anwech To'onel ");
INSERT INTO tzjE_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","jatkon ta per jun To'onel kxin konjelal ajoj ja ok wnak chka bechnak opech kbanic, ");
INSERT INTO tzjE_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","jun To'onel jacsan ajni' jun luz je nsakersana quebey wnak jme aj Israel ta, y chka' acsan com yabal kak'ij ja ok aj Israel ja ok tnamet awxin. Cara' xbij ja' Simeón. ");
INSERT INTO tzjE_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ja' José rexbil María jrute' Jesús arj-e' xel ta canm tak xecc'axaj je xbij Simeón tzra ch'uch'. ");
INSERT INTO tzjE_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","C'jara' ja' Simeón xc'utuj utzil rxin Dios pquewá' y cawra xbij tzra María: —Tewc'axaj je xtenbij chawa ra, jawra ac'al ra arja' ch-on rmal Dios ch-utz c'ara' rmal ja' tak e q'uiy chca aj Israel nekasax na y e q'uiy chca chka' nquetotaja rmal. Jun chic, ja' nec'tuwa chkawech kas mer rubey Dios per jara' xe nch'ojquixa tzra cmal wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Je xtaban atet, nana' na ajni' jun espada xtmi'na ruq'uin awanm. Rmal ja' awal tak e q'uiy wnak bien nk'aljina nak nquech'ob kaja ptak canm, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tzra' c'a c'ola jun rilaj ixak Ana rubi', rmi'al jun acha Fanuel rubi', arja' riy rumam Aser. Aser arja' jun chca je cbeljuj rlec'wal Jacob. Ja' Ana arja' profeta rxin Dios, congan ri'j chic. Q'ue k'poj na tak xec'le'a y xe wku' juna' xecc'aj qui' ruq'uin rechjil ");
INSERT INTO tzjE_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","com chanim xcoma rechjil, xoc cana melca'n y majo'n xec'le' xta. Ochenticuatro chic rjuna'. K'ij k'ij nc'ola chpam templo rxin Dios, nuban ayuno y nuban oración jara' nyabej ruk'ij Dios che pk'ij chak'a'. ");
INSERT INTO tzjE_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Je ch'tac'al Jesús ch'elen rmal Simeón, njara' hor xpeta Ana, xmeltioxij tzra Dios chc'o chic To'onel y xelsaj rbixic ch'tac'al chca conjelal wnak jquemjon reybxic jtotanem rxin Dios tzra' pJerusalén. ");
INSERT INTO tzjE_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","J-e' ttixela' tak xbantaja cumplir cmal njelal je ajni' nbij rley Kajaw Dios che nqueban c'jara' xemloj chic jmul chpam tnamet Nazaret jabar ec'o wa', jc'ola chpam departamento Galilea. ");
INSERT INTO tzjE_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jtac'al arja' xumaj c'yinem, xwankera más rchuk'a', kas congan tz'kat rna'oj y rc'an utzil je nsipaj Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Je redta' rute' arj-e' njelal juna' tak nerla' nimk'ij pascua ne nquepe wa' pJerusalén. ");
INSERT INTO tzjE_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Y cara' xqueban chka' tak cbeljuj chic rjuna' Jesús, xeba pJerusalén com ne ccostumbre wa' aj Israel chnequec'lu' nimk'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tak xec'choja nimk'ij xemloja pNazaret per Jesús ch'tala' xec'je' cana pJerusalén, per majo'n rnaben José che xec'je' cana next c'a rute' chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Je xquech'ob arj-e' chc'ola Jesús chquecjol jle' chic wnak ja erexbilan ta pbey. Xkaja jun k'ij binem cmal. Tak xquetz'et chmajo'n Jesús c'jara' xquemaj rconxic chquecjol cch'alal y chquecjol wnak jcutkin quewech. ");
INSERT INTO tzjE_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tak majo'n xecney ta cmal c'jara' xemloja pJerusalén che rconxic. ");
INSERT INTO tzjE_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pnoxi' k'ij xequewla' wa', chpam nimlaj templo rxin Dios c'o wa', tz'bula chquecjol maestro je nquetijona cxin wnak tzrij rtzojbal Dios. Kas nuya' rexquin tzrij jnecbij maestro y c'ola nc'axaj chca chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kas nel ta canm tzrij tak necc'axaj je nbij per nche conjelal, com congan tz'kat rna'oj y tak c'ola achnak necc'axaj tzra, ja' kas wen rchumilal nbij ela chca. ");
INSERT INTO tzjE_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Xpeta rute' rexbil José: —¿Wawe' oka atc'o wa' wal? ¿Nak tzra tak xaban cawra chka? Ok c-e' ruq'uin adta' congan okelnak ch'u'j chawij che aconxic, cara' xbixa tzra rmal rute'. ");
INSERT INTO tzjE_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","—¿Nak tzra tak cnecanoj? ¿Lmewutkin tc'a che anen nc'atzina chwa chquenban ajni' nrajo' ranm Nedta' chwa? cara' nbij ja' Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Per j-e' majo'n xch'obtaj ta cmal je xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","C'jara' ja' Jesús xerexbilaj ela, xemloj chic jmul pNazaret y nnimaj wa' jnecbij tzra. Jrute' arja' xuyic pranm njelal je xbantaja pJerusalén. ");
INSERT INTO tzjE_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ja' Jesús juna' juna' chkajni' wankernak más rna'oj, congan remjon c'yinem y más na wen ntz'e'ta rmal Dios y cmal wnak chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Juan je rlec'wal Zacarías arja' xerla' k'ij tak ntzijona Dios ruq'uin chpam jun lwar kas tlana, jara' chpam retiemp nimlaj rey rbin-an Tiberio César. Ja' Tiberio César oljuj juna' c'ola k'atbaltzij pruk'a' tak xtzijona Dios ruq'uin Juan. Jle' chic ach-i' je e'ocnak e k'toy tak tzij chpam jara' tiemp cawra quebi' ra: jun, Poncio Pilato rubi', arja' ocnak gobernador rxin Judea, y jun chic, Herodes rubi', pruk'a' arja' c'o wa' departamento Galilea, y jun chic, Felipe rubi', je rch'alal Herodes, pruk'a' arja' c'o wa' c-e' lwar Iturea ruq'uin Traconite, y jun chic, Lisanias rubi', pruk'a' arja' c'o wa' lwar Abilinia. Acha jocnak nimlaj sacerdote tzra' Anás rubi' ruq'uin Caifás. ");
INSERT INTO tzjE_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ja' Juan tak xc'axaj je xbixa tzra rmal Dios c'jara' xba, abar tzra' nk'ax wa' binel ya' Jordán tzra' xk'ax wa' ja', y tak ec'ola wnak nque'ekaja ruq'uin cawra nbij chca ra: —Tec'xa' ena'oj, tey-a' cana rtzilal y nquixba'na bautizar, cara' ta neban ch-utz c'ara' ncuytaja ewil emac. Cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tzra' xbantaj wa' cumplir jtz'ibtanak cana chpam rtzojbal Dios ojer rmal profeta Isaías jcawra nbij: —C'ola jun kul nc'axaxa chpam tenlic lwar y cawra nbij ra: —Tchumsaj rubey Kajaw Dios, jic tey-a'. ");
INSERT INTO tzjE_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Je' siwan xtnojsax na per ne njelal siwan. Je' jyu' nmajo'n mquita xtkasas na, je' loclak tak bey njic nya' na, wc'ottanak je rwech jara' nmu'k na. Congan wen rbanic jbey xtba'n na. ");
INSERT INTO tzjE_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y conjelal je' wnak arj-e' xtquetz'et na jtotanem rxin Dios. Cara' tz'ibtanak cana. ");
INSERT INTO tzjE_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Juan tak nque'ekaja wnak ruq'uin che nqueruban bautizar cawra nbij chca ra: —Ixix congan itzel tak na'oj ewc'an, ix ajni' ix itzel tak cmetz. ¿Nak xbina chewa che nquixnanmaja chwech jnimlaj juicio je nnajin ta? ");
INSERT INTO tzjE_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Twachin c'a utzil ptak ewanm, njawara' yatanak chewij chneban we ktzij che ec'xon chic ena'oj. Mtebij ta cawra ptak ewanm: —Ajoj ok riy rumam Abraham rmal ra ok rtnamet Dios, mtebij ta cara'. Cara' quenbij chewa com Dios nmajo'n pen ta tzra nwankersaj jle' riy rumam Abraham tzra jle' abaj jala. ");
INSERT INTO tzjE_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chka' camic ra xchenkaj chic c'o wa' juicio rxin Dios ajni' rbanic jun icaj chumin chic xjarlal q'uemjana tcho'ya jle' che' tzra. Nak che' jmajo'n wen ta rwech nuya' jara' ncho'ya y nporoxa pk'ak'. Cara' nbij Juan chca. ");
INSERT INTO tzjE_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","—¿Nak nkaban c'a wa'? cara' necc'axaj wnak tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","—Achnak chewa c'ola c-e' recmis tey-a' jun tzra jmajo'n rxin, wc'ola way ruq'uin tey-a' rxin jmajo'n nutaj, cara' nbij ja' Juan chca. ");
INSERT INTO tzjE_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ec'ola jle' e mloy tak impuesto xe'ekaja ruq'uin chka' che nqueba'na bautizar rmal, arj-e' cawra xecbij tzra: —Maestro ¿nak c'a nkaban ajoj? cara' xecc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Jimpuesto tak nto'ja pnek'a' cmal wnak xjara' ta nec'om chca ajni' bin chewa rmal k'atbaltzij, mtec'utuj ta más chca, cara' nbij Juan chca. ");
INSERT INTO tzjE_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ec'ola jle' soldado chka' cawra xecc'axaj tzra: —Ajoj ¿nak c'a nkaban? —Me tque'epors-ij ta wnak che nqueya' je cachnak chewa. Jun chic, mtetz'ak ta tzij chquij wnak. Jun chic, quixc'je'a conform ruq'uin ewjel jnech'ec. Cara' xbij Juan chca. ");
INSERT INTO tzjE_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Je' wnak congan necyarij ncutkij nak rbanic Juan, nqueyben nak xtbixa chca. Jquemjon rch'obic ptak canm che Juan mex arja' Cristo per ncara' nquech'ob conjelal. ");
INSERT INTO tzjE_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Rmal c'ara' tak cawra xbij Juan chca conjelal: —Anen ya' quencsaj che nquixbanbej bautizar per c'o chna jun penak xjara' jlal q'uemjana tumaj rsamaj, arja' más chna nim poder c'ola pruk'a' que chenwech anen. Anen majo'n yatanak ta chwij xtenki'l ta ruq'uin nexte chquenquir nara' rc'amal rexjab. Arja' nquixruban bautizar per Espíritu Santo ruq'uin k'ak' nquixrbanbej bautizar. ");
INSERT INTO tzjE_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Arja' rchumin chic ri' che nyonaj jwen checjol jme wen ta ajni' nuban jun acha nuq'uiek rk'arwech trigo tzan pala, nyonaj trigo chpam je' rtz'ilol. C'jara' nuc'ol trigo chpam rc'olibal per je rtz'ilol jara' npuroj pk'ak', per jara' k'ak' majo'n chupic tzrij. Cara' xbij Juan chca. ");
INSERT INTO tzjE_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Q'uiy je' tzij ctak ra xerpaxbej wnak tak xuya' rbixic chca utzlaj tzij je rxin totanem. ");
INSERT INTO tzjE_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Per xch'ojquij nic'aj achnak tzra gobernador Herodes com ja' Herodes c'ola jun rexnam rec'mon, Herodías rubi'. Herodías arja' rexkayil Felipe je rch'alal Herodes. Y ja' Herodes c'o chna jle' rtzilal rebnon je xch'ojquixa tzra rmal Juan. ");
INSERT INTO tzjE_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Q'uiy rwech je m-utz ta xuban ja' Herodes y xq'uisbena xucsaj Juan pcars. ");
INSERT INTO tzjE_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tak xebantaja bautizar conjelal wnak y xbantaja bautizar ja' Jesús chka', njara' hor kas remjon rbanic oración tak xjaktaja caj ");
INSERT INTO tzjE_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","y xkaj ta Espíritu Santo ruq'uin. Ja' Espíritu Santo ajni' jun paloma xkaj ta ruq'uin. C'jara' c'ola jun kul penak chcaj xc'axaxa y cawra xbij tzra Jesús: —Atet at quilaj Wlec'wal, congan quenquicota chawij, cara' nbij rukul Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ja' Jesús tak xumaj ela rsamaj c'o la la' treinta rjuna', y chquewech wnak arja' rlec'wal José. Ja' José arja' rlec'wal Elí. ");
INSERT INTO tzjE_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ja' Elí rlec'wal Matat. Ja' Matat rlec'wal Leví. Ja' Leví rlec'wal Melqui. Ja' Melqui rlec'wal Jana. Ja' Jana rlec'wal José. ");
INSERT INTO tzjE_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ja' José rlec'wal Matatías. Ja' Matatías rlec'wal Amós. Ja' Amós rlec'wal Nahum. Ja' Nahum rlec'wal Esli. Ja' Esli rlec'wal Nagai. ");
INSERT INTO tzjE_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ja' Nagai rlec'wal Maat. Ja' Maat rlec'wal Matatías. Ja' Matatías rlec'wal Semei. Ja' Semei rlec'wal José. Ja' José rlec'wal Judá. ");
INSERT INTO tzjE_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ja' Judá rlec'wal Joana. Ja' Joana rlec'wal Resa. Ja' Resa rlec'wal Zorobabel. Ja' Zorobabel rlec'wal Salatiel. Ja' Salatiel rlec'wal Neri. ");
INSERT INTO tzjE_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ja' Neri rlec'wal Melqui. Ja' Melqui rlec'wal Adi. Ja' Adi rlec'wal Cosam. Ja' Cosam rlec'wal Elmodam. Ja' Elmodam rlec'wal Er. ");
INSERT INTO tzjE_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ja' Er rlec'wal Josué. Ja' Josué rlec'wal Eliezer. Ja' Eliezer rlec'wal Jorim. Ja' Jorim rlec'wal Matat. ");
INSERT INTO tzjE_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ja' Matat rlec'wal Leví. Ja' Leví rlec'wal Simeón. Ja' Simeón rlec'wal Judá. Ja' Judá rlec'wal José. Ja' José rlec'wal Jonán. Ja' Jonán rlec'wal Eliaquim. ");
INSERT INTO tzjE_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ja' Eliaquim rlec'wal Melea. Ja' Melea rlec'wal Mainán. Ja' Mainán rlec'wal Matata. Ja' Matata rlec'wal Natán. ");
INSERT INTO tzjE_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ja' Natán rlec'wal David. Ja' David rlec'wal Isaí. Ja' Isaí rlec'wal Obed. Ja' Obed rlec'wal Booz. Ja' Booz rlec'wal Salmón. Ja' Salmón rlec'wal Naasón. ");
INSERT INTO tzjE_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ja' Naasón rlec'wal Aminadab. Ja' Aminadab rlec'wal Aram. Ja' Aram rlec'wal Esrom. Ja' Esrom rlec'wal Fares. Ja' Fares rlec'wal Judá. ");
INSERT INTO tzjE_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ja' Judá rlec'wal Jacob. Ja' Jacob rlec'wal Isaac. Ja' Isaac rlec'wal Abraham. Ja' Abraham rlec'wal Taré. Ja' Taré rlec'wal Nacor. ");
INSERT INTO tzjE_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ja' Nacor rlec'wal Serug. Ja' Serug rlec'wal Ragau. Ja' Ragau rlec'wal Peleg. Ja' Peleg rlec'wal Heber. Ja' Heber rlec'wal Sala. ");
INSERT INTO tzjE_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ja' Sala rlec'wal Cainán. Ja' Cainán rlec'wal Arfaxad. Ja' Arfaxad rlec'wal Sem. Ja' Sem rlec'wal Noé. Ja' Noé rlec'wal Lamec. ");
INSERT INTO tzjE_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ja' Lamec rlec'wal Matusalén. Ja' Matusalén rlec'wal Enoc. Ja' Enoc rlec'wal Jared. Ja' Jared rlec'wal Mahalaleel. Ja' Mahalaleel rlec'wal Cainán. ");
INSERT INTO tzjE_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ja' Cainán rlec'wal Enós. Ja' Enós rlec'wal Set. Ja' Set rlec'wal Adán. Ja' Adán rlec'wal Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ja' Jesús nojnak Espíritu Santo pranm, xel ela chpam binel ya' Jordán, xec'mar ela rmal Espíritu Santo chpam jun tenlic lwar. ");
INSERT INTO tzjE_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Cawnak k'ij xec'je'a tzra' y tak xekaja diablo ruq'uin xrajo' nuban tentar. Jara' tiemp jxec'je'a tzra' nmajo'n achnak xutaj. Tak xetz'kata cawnak k'ij rmal xmajtaja rmal k'ak'nic pamaj. ");
INSERT INTO tzjE_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Xpeta diablo y cawra xbij: —We ktzij che at Rlec'wal Dios tbij tzra jun abaj jawra che noca way, cara' xbij tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","—Tz'ibtanak cana chpam rtzojbal Dios che je' wnak mruyon ta way nc'atzina chca tzra cc'aslemal per njelal rtzojbal Dios jara' nc'atzina chca chka', cara' xbij ja' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","C'jara' ja' diablo xuc'om el chic Jesús, xeba pe rwá' jun nimlaj jyu'. Tak xe'ekaja, alnak xuc'ut chwech jgobierno rxin njelal tnamet jc'ola chwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Y cawra xbij tzra: —We xtcatexque'a chenwech y xtaya' nuk'ij, anen quenjach pnak'a' jgobierno rxin njelal tnamet jnemjon rc'utic chawech y quenya' pnak'a' njelal mibil jc'ola chwech chka'. Com anen c'ola nuk'a' tzrij njelal jnatz'et la y quencwina quenya' tzra chka bechnak wnak, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ja' Jesús cawra xbij tzra: —Jat catel ela chenwech Satanás, com tz'ibtanak cana chpam rtzojbal Dios che xruyon Dios Awajaw ncatexque'a chwech y xruyon arja' tey-a' ruk'ij, cara' tz'ibtanak cana, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","C'jara' ja' diablo xuc'om el chic Jesús, xeba chpam tnamet Jerusalén. Tak xe'ekaja xjotba' pe rwá' nimlaj templo rxin Dios y cawra xbij tzra: —Jwe ktzij che at Rlec'wal Dios tec'ka' ela awi' wawe' ra ");
INSERT INTO tzjE_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","com chpam rtzojbal Dios cawra tz'ibtanak cana chawij: —Ja' Dios nquerutak ta r-ángel che ncatquechjalbej, ");
INSERT INTO tzjE_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","arj-e' nquetz'mowa awxin ch-utz c'ara' majo'n nasoc ta awkan chwech abaj. Cara' tz'ibtanak cana, cara' xbij ja' diablo. ");
INSERT INTO tzjE_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús cawra xbij tzra: —Per tz'ibtanak cana chka' che mtaban ta probar Dios je Awajaw, cara' tz'ibtanak cana, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ja' diablo nmajo'n xecney xta rmal nak nbanbej chic tentar Jesús, c'jara' xuya' cana jun tiemp. ");
INSERT INTO tzjE_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ja' Jesús xemloja chpam departamento Galilea, nojnak chic rpoder Espíritu Santo pranm. Xba rtzojxic cmal wnak njelal nat nkaj. ");
INSERT INTO tzjE_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Xumaj ctojxic wnak ptak jay rxin molbal ri'il jabar nquemol wa' qui' che rc'axic rtzojbal Dios, per nconjelal wnak ncongan nqueya' ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Xba chpam tnamet Nazaret jabar xq'uiy wa'. Tak xerla' xlanbal k'ij xba chpam jay rxin molbal ri'il com ncawara' nuban. Tak xekaja xpe'a ch-utz c'ara' nsiq'uij rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","C'ola jun libro jtz'ibtanak cana rmal profeta Isaías jara' xja'cha pruk'a'. Xujak libro y xuwil jabar c'o wa' je nsiq'uij chquewech wnak jcawra nbij ra: ");
INSERT INTO tzjE_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—Je Espíritu Santo rxin Kajaw Dios arja' c'o chic wq'uin. Arja' enretkon ta ch-utz c'ara' quenya' rbixic utzlaj tzij jrec'mon ta totanem rxin Dios chca ch'tak mibi', enretkon ta chquenuto' wnak jkas nti'ona canm pruk'a' il mac, enretkon ta chquenya' rbixic chca wnak je e'ocnak preso pruk'a' il mac che nque'el ela libre, y quenbij chca moya' che nja'k na quewech, quenbij na chca jquemjon rtijic lowlo' che nquetotaj na. ");
INSERT INTO tzjE_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Enretkon ta ch-utz c'ara' quenya' rbixic chca wnak chcamic xerla' retiemp che nquewil totanem rxin Kajaw Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Cara' xsiq'uij chquewech. Tak xsic'taja rmal xtz'apij libro, xujach chic jmul tzra acha jxejchowa pruk'a' y xetz'be'a. Kas xer netz'e'ta cmal conjelal wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","C'jara' xumaj chic tzij cuq'uin: —Camic xbantaja cumplir rtzojbal Dios jxensiq'uij chewech, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Conjelal wnak xquemaj je' tzij y cawra necbij chbil tak qui' ra: —Jala acha congan wen, congan wen tak tzij nbij per ¿mja' tc'ala' rlec'wal José? cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ja' Jesús cawra xbij ra: —Anen wutkin bien chcawra nebij chwa camic ra: —Com nque'achumsaj wnak que'achumsaj c'ara' chka' je' awinak atet. Com c'ola jle' milagro xaban chpam tnamet Capernaum tebna' c'a chka' wawe' chpam atnamet atet, cara' nebij chwa. ");
INSERT INTO tzjE_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Per ne ktzij wa' je xtenbij chewa ra, je' profeta rxin Dios arj-e' nmajo'n nquenimax ta cmal cwinak, ncawara' nba'na chca conjelal. ");
INSERT INTO tzjE_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Per bien terkaja pnewá' nak xbantaja pretiemp profeta Elías. Oxi' juna' ruq'uin nic'aj sk'ij xuban tzra', y c'ola jun nimlaj wyejal xpeta njelal nat nkaj chpam jara' lwar. E q'uiy melca'n tak ixki' ec'ola wawe' chpam tnamet Israel jara' k'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Per ja' Elías xuban jmul xta'k ela rmal Dios che rto'ic jun melca'n ixak per mruq'uin ta jun aj Israel xta'k el wa', per xta'k ela che rto'ic jun melca'n ixak jc'ola chpam aldea Sarepta jc'ola precwent Sidón. ");
INSERT INTO tzjE_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Y cara' xbantaja chka' pretiemp profeta Eliseo tak e q'uiy chca aj Israel emajtanak rmal jitzel yubil lepra, per nmajo'n jun xchumsas ta chca xerwara' c'ola jun aj Siria tzra', Naaman rubi', xruyon arja' xchumsasa tzra jara' yubil. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Je aj Israel jec'ola chpam jay rxin molbal ri'il chek xecc'axaj je xbixa chca rmal Jesús congan xpeta cyiwal conjelal. ");
INSERT INTO tzjE_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","C'jara' xeyictaja tzrij, xquechap, xquelsaj ta chpam tnamet. Je tnamet chwech jun jyu' c'o wa' y tak xe'ekaja chuchi' jun siwan xyamer xecch'akij ela Jesús chpam. ");
INSERT INTO tzjE_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Per Jesús arja' xk'ax ela chquecjol y xba. ");
INSERT INTO tzjE_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","C'jara' xba Jesús chpam tnamet Capernaum jc'ola precwent Galilea. Tak xekaja xumaj ctojxic wnak ptak xlanbal k'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","J-e' wnak kas nel ta quec'u'x tak necc'axaj tijonem jnuya' com rtzojbal congan nqueruchap, bien k'alaj chruq'uin Dios penak wa' je nbij. ");
INSERT INTO tzjE_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Xuban jmul c'ola jun acha chpam jay rxin molbal ri'il, ocnak jun itzel espíritu pranm. Ja' acha xumaj rakic ruchi' y cawra xbij tzra Jesús: ");
INSERT INTO tzjE_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús je at aj Nazaret ¿nak narebna' wawe' kuq'uin, atpenak che nokareyjo'? Anen wutkin nak abanic, atet at Santlaj Rlec'wal Dios, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ja' Jesús ncow xtzijona tzra itzel espíritu: —Catetne'a y catel ela pranm acha, cara' xbij tzra. Jxuban itzel espíritu tzra acha xch'akij cana pnulew chquewech wnak, c'jara' xela pranm y xba, nmajo'n achnak lowlo' xuban cta tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Je' wnak congan xel ta canm conjelal tak xquetz'et y cawra xecbij chbil tak qui': —Jawra acha ¿nak chtzij xucsaj? C'o tak ruk'a' chquij itzel tak espíritu, congan tak wan rchuk'a' rtzojbal com nqueruban mandar che nque'ela y nnimax tak wan chka', cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Xba c'a rtzojxic Jesús njelal nat nkaj ptak je' lwar jc'ola chenkaj tnamet Capernaum. ");
INSERT INTO tzjE_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ja' Jesús xel ela chpam jay rxin molbal ri'il, xba chruchoch Simón. Tak xekaja, rjite' ja' Simón ywajnak, majtanak rmal jun nimlaj c'ten. Xc'utuxa jun utzil tzra chnuto' yawa'. ");
INSERT INTO tzjE_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ja' Jesús xki'l oca chuchi' ch'at ruq'uin yawa', xbij tzra c'ten che nel ela y nalnak xel ela. Y chek q'uenjlal xyictaja ja' ixak y xumaj quilxic Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tak xoca ak'a' conjelal wnak jec'ola yuw-i' cuq'uin arj-e' xequec'om ela ruq'uin Jesús. Congan q'uiy rwech je' yubil ec'ayona. Ja' Jesús xuya' ruk'a' pquewá' chejujnel y xerchumsaj. ");
INSERT INTO tzjE_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Chka' e q'uiy chca wnak ec'ola itzel tak espíritu xe'el ela ptak canm. Jitzel tak espíritu tak xe'el ela xquerak quechi' y cawra xecbij tzra Jesús: —Atet at Rlec'wal Dios, cara' xecbij tzra. Per Jesús xeruk'il chmajo'n nquetzijon xta más com arj-e' cutkin chja' Cristo je ch-on rmal Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jche rcab k'ij tak xeskara xel ela chpam tnamet, xba chic chpam jun lwar jabar tlan wa'. J-e' wnak xquemaj rconxic y tak xequewla' mtcajo' nqueya' c'as tzra com ncajo' nec'je' na cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Per arja' cawra xbij chca ra: —Anen nc'atzina chwa chquenba chic chpam jle' chic tnamet ch-utz c'ara' tzra' cney-a' wa' rbixic chka' utzlaj tzij je rxin rgobierno Dios com xe rmal ra entkon ta, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Cara' xuban, xba ptak tnamet jc'ola precwent Galilea, noca ptak jay rxin molbal ri'il y nuya' rbixic rtzojbal Dios chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Xuban c'a jmul Jesús c'o chuchi' ya' rbin-an lago Genesaret, congan e q'uiy wnak ntajina nquemin qui' tzrij ch-utz c'ara' necc'axaj rtzojbal Dios je nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ja' Jesús c'ola c-e' lanch xutz'et c'o pona chuchi' ya'. E majo'n e chpoy ch'u' chpam jlanch com arj-e' e'elnak ela, quemjon rch'ajic quec'am je rxin chapbal ch'u'. ");
INSERT INTO tzjE_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jun tzra c-e' lanch rxin Simón y chpam jara' lanch xoc wa' Jesús: —Jo' kojte' pona jtz'it ajsic', cara' xbij ja' Jesús tzra Simón. Tak ejtal chic c'jara' xetz'be'a chpam lanch, xumaj ta ctojxic wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tak xec'choja tzij rmal xbij chic tzra Simón: —Camic jo', tec'ma' el chic lanch jabar nim wa' rpam ya' y tzra' tec'ka' wa' ac'am chpam ya' ch-utz c'ara' c'ola ch'u' nque'achap, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","—Per Maestro, njun ak'a' xokosmaja per next jun rkan ch'u' xkachap. Per com atet ncatbina chcara' nkaban nokba c'ara', quenec'ka' c'ara' c'am chpam ya', cara' xbixa tzra rmal Simón. ");
INSERT INTO tzjE_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Cara' c'a xqueban xeba, xequec'ka' c'am jabar nim wa' rpam ya'. Tak xq'uiektaja cmal congan e q'uiy ch'u' xe'oca chpam y xerkaptaja je' c'am rmal. ");
INSERT INTO tzjE_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","C'jara' xecsiq'uij pon chic jle' quexbil jec'ola chpam jun lanch chic che nquerto'a. Tak xe'ekaja xquemaj clasic je' ch'u' chpam c'am, nxenoja che c-e' lanch ch'u', xe jtz'it xba xe' ya' jlanch cmal ch'u'. ");
INSERT INTO tzjE_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ja' Simón Pedro tak xutz'et jmilagro je xbantaja c'jara' xexque'a chwech Jesús y cawra xbij tzra: —Wajaw, jat cnay-a' cana com anen xe en jun acha en aj-il en aj mac, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Cara' xbij Simón com arja' y conjelal e rexbil jec'ola ruq'uin congan xel ta quec'u'x tzrij chcongan ch'u' xquechap. ");
INSERT INTO tzjE_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ec'ola chka' Jacobo ruq'uin Juan je e rlec'wal jun acha Zebedeo rubi', arj-e' quec'mon ta qui' ruq'uin Simón tzra chpoj ch'u', y congan xel ta canm tzrij je xquetzu' je xbantaja. Ja' Jesús cawra xbij tzra Simón: —Mtaxibej ta awi', c'o chna jun samaj xtamaj el chic rbanic camic ra, wnak chic nque'acanoj ch-utz c'ara' nque'acsaj pruk'a' Dios, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","C'jara' xquec'om ta c-e' lanch, xekaj ta chiya'. Junlic xqueya' cana njelal y xetre' ela tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Xuban jmul Jesús c'ola chpam jun tnamet, c'ola jun acha xekaja ruq'uin majtanak rmal itzel yubil lepra. Ja' acha tak xutz'et Jesús xexque'a chwech y xkasaj ruplaj penlew: —Wajaw, wnawajo' cnachumsaj, anen wutkin che ncatecwina cnachumsaj, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ja' Jesús xuyuk pona ruk'a', xuchap yawa' y cawra xbij tzra: —Quenwajo' ajni' nac'utuj chwa, catchumtaja, cara' xbij tzra, y alnak xel ela lepra tzrij. ");
INSERT INTO tzjE_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Y congan xbij tzra: —Kas quenwajo' quenbij chawa chmajo'n abar nabij wa' jxenban chawa. Per jnaban, jat ac'tu' awi' chwech sacerdote y ay-a' awofrenda ajni' rbin cana Moisés chpam rley Dios chnaban. Je ofrenda jnaya' jara' noca testimonio chquewech sacerdote chnaban cumplir je rbin cana Moisés. Cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Per nmás xba rtzojxic y congan e q'uiy wnak necremlo' qui' ruq'uin che rc'axic tijonem nuya', y je' yuw-i' arj-e' ncajo' che nquechumsasa. ");
INSERT INTO tzjE_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Arja' nba ptak lwar kas tlana y tzra' nerebna' wa' oración. ");
INSERT INTO tzjE_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Xuban jmul Jesús remjon ctojxic wnak. Ec'ola jle' fariseo etz'bula chenkaj e quexbil jle' maestro je nquetijona cxin wnak tzrij rley Dios, arj-e' njelal tnamet epenak wa' jc'ola precwent Galilea ruq'uin precwent Judea, y ec'ola chca pJerusalén epenak wa'. Ja' Jesús c'ola rpoder Dios ruq'uin che nquerchumsaj yuw-i'. ");
INSERT INTO tzjE_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chek q'uenjlal tak ec'ola jle' ach-i' xe'erkaja, c'ola jun acha squirnak quec'mon ta, ctz'ela chwech rwarbal. J-e' ach-i' xcajo' ta xe'oca pjay xequey-a' ta yawa' nq'ue chwech Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Per majo'n xecwin ta xquecsaj pjay com congan enojnak wnak chpam. Je xqueban, xejte'a pe rwá' jay, xquelsaj nic'aj rwá' jay y tzra' xeckasaj wa' yawa', ctz'ela chwech rwarbal. Y ja' yawa' c'a chwech Jesús xekaj wa' jabar quemlon wa' qui' wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ja' Jesús tak xutz'et yukbal quec'u'x jc'ola ruq'uin, arja' cawra xbij tzra squirnak: —Acha, camic xcuytaja awil amac, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Je' maestro e quexbil fariseo tak chek xecc'axaj je xbij Jesús cawra xquemaj rch'obic ptak canm: —¿Nak rbanic jala acha tak nbij jle' tzij jxitzel nc'axaj Dios? Com majo'n chic nak xtecyuw ta il mac, xruyon Dios necyuwa, cara' xecbij kaja pcanm. ");
INSERT INTO tzjE_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Per Jesús arja' bien rutkin nak nquech'ob kaja ptak canm y cawra xbij chca: —¿Nak tzra tak cara' nech'ob kaja ptak ewanm? ");
INSERT INTO tzjE_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Camic quenwajo' quenc'axaj chewa ¿nak más majo'n pen ta tzra c-e' jawrara chquenbij tzra jawra acha sic chquencuy ril rumac, o wquenbij tzra che nyictaj ela y nba? ");
INSERT INTO tzjE_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Anen quenban jawra chewech camic ra ch-utz c'ara' newutkij che Rlec'walxel jxoca alxic cuq'uin wnak yatanak tzra chnucuy quil quemac je' wnak wawe' chwech ruch'lew, cara' xbij ja' Jesús chca. C'jara' cawra xbij chic ja' Jesús tzra squirnak: —Anen quenbij chawa camic, catyictaja, tec'ma' ela awarbal y jat pnawuchoch, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chek xbitaja rmal, xyictaj ela acha chquewech, xumaj rc'olic rwarbal y xba chruchoch, y ajni'la nuya' ruk'ij Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Je' wnak congan xel ta canm tak xquetz'et je xbantaja per nche conjelal, y xquemaj rya'ic ruk'ij Dios, congan cxiben qui' y cawra necbij ra: —Camic xkatz'et jnexte wjic katz'ton ta, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","C'jara' xel ela Jesús tzra' y xba. C'ola jun acha xutz'et mloy impuesto, Leví rubi'. Ja' Leví tz'bula chpam lwar abar nto'j wa' impuesto pruk'a'. Ja' Jesús tak xekaja ruq'uin cawra xbij tzra: —Jo' catetre' ta chwij che ncatoca ndiscípulo, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ja' Leví xyictaja, xuya' cana njelal y xetre' ela tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ja' Leví c'ola jun nimlaj w-im xchumsaj pruchoch rxin Jesús. Ja' Jesús e rexbil rdiscípulo arj-e' etz'bula tzrij mes. Congan e q'uiy e mloy tak impuesto etz'bula tzrij mes cuq'uin y ec'ola jle' chic wnak chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ec'ol c'a jle' maestro je nquetijona cxin wnak tzrij rley Dios e quexbil jle' fariseo arj-e' xecch'ojquij chca rdiscípulo Jesús y cawra xecbij: —¿Nak tzra tak nquixwa'a cuq'uin e mloy tak impuesto, chka' cuq'uin jle' chic aj-il ajmac? ");
INSERT INTO tzjE_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Xpeta Jesús, cawra xbij chca: —Nak majo'n e yawa' ta arj-e' majo'n nc'atzin ta doctor chca, per je yuw-i' arj-e' nc'atzina doctor chca. ");
INSERT INTO tzjE_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Anen enpenak che que'encanoj aj-il ajmac ch-utz c'ara' nqueya' cana quil quemac, me j-e' ta ra' que'encanoj je bnoy rbeyal. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","C'jara' cawra xecbij chic tzra: —Je rdiscípulo Juan Bautista arj-e' q'uiy mul nqueban ayuno ruq'uin oración y cara' nqueban je' kdiscípulo ajoj chka' ja ok aj fariseo per ¿nak q'ue tzra mcara' ta nqueban adiscípulo atet? ");
INSERT INTO tzjE_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús cawra xbij chca: —Ajni' chca jle' wnak ebnon invitar chpam jun c'ulbic, tak c'c'o na acha chquecjol jnec'le'a ¿l-utz c'ara' xtebij ta chca che nqueban ayuno? ");
INSERT INTO tzjE_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per nerla' na jun k'ij tak arj-e' xtelsasa chquecjol acha jxec'le'a, c'jara' c'a xtqueban ayuno. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","C'jara' c'ola jun c'ambal tzij xbij chca cawrara: —Majo'n jun wnak xtelsaj ta jun tesbal tzra jun tziak c'ac' y xtucsaj ta tzra jun tzbuklaj tziak com jara' xe ntz'ila' c'ac' tziak y chka' m-utz ta nela c'ac' tesbal ruq'uin tzbuklaj tziak. ");
INSERT INTO tzjE_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Chka' ajni' tzra vino c'ac' majo'n jun xtuc'ol ta chpam tzbuklaj tak c'olbal. Wext cara' nba'na jc'ac' vino nurak c'olbal y nti'xa, y ntz'iloxa c'olbal chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Per kas nc'atzina nba'na, jc'ac' vino nc'o'la chpam c'ac'laj tak c'olbal y nuto' ri' che c-e', nexte vino y nexte c'olbal ntz'iloxa. ");
INSERT INTO tzjE_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jun acha we c'mannak tzra nutaj vino je mc'ac' ta jara' c'am-an nec'mana tzra jc'ac' vino, y cawra nbij: —Más na utz je mc'ac' ta. Cara' xbij Jesús chca tzrij jc'ac' tijonem jrec'mon ta. ");
INSERT INTO tzjE_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Xuban jmul Jesús pjun xlanbal k'ij remjon binem chpam jle' trigo e rexbil rdiscípulo. Kas quemjon binem chpam trigo tak xquemaj rk'upxic rwá' je' trigo je rdiscípulo, tzan quek'a' nquelsaj wa' ch'tak rwech y nquetaj. ");
INSERT INTO tzjE_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ec'ol c'a jle' fariseo cawra xecbij chca: —Jemjon rbanic camic ra jala xjan nba'na ptak xlanbal k'ij. ¿Nak tzra tak neban cara'? Cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ja' Jesús cawra xbij chca: —¿Lmajo'n c'a esiq'uin ta chpam rtzojbal Dios jxuban ojer rey David tak xuban jmul majtanak rmal k'ak'nic pamaj y cara' quebnon e rexbil chka'? ");
INSERT INTO tzjE_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jxuban, xoca chpam ruchoch Dios, xuc'om xquelway jyonan chwech Dios, xutaj y xuya' cxin rexbil chka'. Cara' xuban mesque jara' xquelway tz'ibtanak cana chpam rley Dios che xqueyon sacerdote nquetjowa, cara' nbij chca aj fariseo. ");
INSERT INTO tzjE_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","C'jara' cawra xbij chic chca: —Je Rlec'walxel jxoca alxic cuq'uin wnak, pruk'a' c'o wa' je nba'na chpam xlanbal k'ij. Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pjun chic xlanbal k'ij xoca Jesús chpam jay rxin molbal ri'il y xumaj ctojxic wnak. C'ol c'a jun acha tzra' squirnak jun ruk'a' jrejquenk'a'. ");
INSERT INTO tzjE_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Je' maestro e quexbil aj fariseo arj-e' ctz'ulchin Jesús, ncajo' nquetz'et we nchumsaj acha chpam xlanbal k'ij. Cara' nqueban ch-utz c'ara' nquewil jun ril che necchapbej rxin. ");
INSERT INTO tzjE_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Per Jesús rutkin jquemjon rch'obic y cawra xbij tzra acha je squirnak ruk'a': —Catyictaja y catpe'a chkacjol, cara' xbij tzra. Ja' acha xyictaja y xpe'a chquecjol. ");
INSERT INTO tzjE_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","C'jara' Jesús cawra xbij chca: —Anen quenwajo' quenc'axaj chewa jawrara camic. ¿Nak nuya' c'as ley chka che nkaban chpam xlanbal k'ij, we nkaban utzil o we rtzilal? ¿Lnuya' c'as chka che nquekato' wnak owe nquekcamsaj? cara' xc'axaj chca. ");
INSERT INTO tzjE_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kas xerch'ulchij conjelal c'jara' cawra xbij tzra acha: —Teyku' ak'a', cara' xbij tzra. Xuyuk ruk'a' y xec'choja. ");
INSERT INTO tzjE_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Arj-e' congan xpeta cyiwal, xquemaj tzij chbil tak qui', xquemaj rconxic rij rwech Jesús nak nqueban tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chpam jara' tiemp xba Jesús, xojte'a chwech jun jyu', xuwil jun lwar abar nuban wa' oración y njelal ak'a' xtzijona ruq'uin Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tak xeskara xersiq'uij rdiscípulo. Ec'ol c'a e cbeljuj xerucha' y xbin-aj chca che e apóstol. ");
INSERT INTO tzjE_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","J-ewra e apóstol: Simón je xcanox chic jun rubi' rmal Jesús y xbixa tzra Pedro, Andrés je rch'alal Simón, Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO tzjE_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo je rlec'wal Alfeo, Simón jun chca je rxin partido rbin-an Zelote, ");
INSERT INTO tzjE_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas je rlec'wal Jacobo, ruq'uin Judas Iscariote jxejchowa Jesús pquek'a' je nquetzelana rxin. ");
INSERT INTO tzjE_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","C'jara' ja' Jesús xexle' ta chwech jyu' e rexbil apóstol. Tak xkaj ta chwech rutk'aj, tzra' xpe' wa' cuq'uin rdiscípulo e quexbil jle' chic wnak per congan e q'uiy. Ec'ola aj Jerusalén y ec'ola epenak chpam jle' chic tnamet jc'ola precwent Judea. Ec'ola chka' jepenak chi' tak mar jc'ola precwent Tiro y precwent Sidón. Epenak conjelal che necc'axaj je nbij Jesús y chka' che nquerchumsaj tzra je' cyubil. ");
INSERT INTO tzjE_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ec'ola xechumsasa chka' jemajtanak cmal e itzel tak espíritu. ");
INSERT INTO tzjE_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Conjelal wnak congan nquecsaj cchuk'a' che nquechap oca jtz'it Jesús com arja' c'ola poder ruq'uin y jpoder nel ta ruq'uin nquerchumsaj wnak per ne che conjelal. ");
INSERT INTO tzjE_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","C'jara' ja' Jesús xertz'ulchij rdiscípulo y cawra xbij ra: —Ixix je ix mibi' congan quicotemal rxin Dios nyataja chewa com ewxin rgobierno Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ixix je nk'ak'ana epam congan quicotemal rxin Dios nyataja chewa com congan nquixnoj na. Ixix je nquixok'a camic congan quicotemal rxin Dios nyataja chewa com nquixtzeben na. ");
INSERT INTO tzjE_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Congan quicotemal rxin Dios nyataja chewa je nquixtzelaxa cmal wnak, jmajo'n nquixquec'ul ta y xe nquixquetz'uj y xe ix itzel tak wnak necbij chewa, per congan quicotemal nyataja chewa tak nmal anen tak cara' nba'na chewa, anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tak cara' nqueban chewa quixquicot c'a per congan quixquicota com jara' c'ola jun nimlaj rtojbalil je nyataj na chewa tzra' chcaj. Com je' cti't quemma' cara' xqueban chca chka' e ojer tak profeta rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Per ixix je ix byoma' jara' congan lowlo' chewa com nquixquicota camic per jara' jun quicotemal xe nk'axa. ");
INSERT INTO tzjE_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ixix jc'ola nmak tak w-im neban camic, jara' congan lowlo' chewa com netaj na wyejal. Ixix je kas congan tzeb neban camic jara' congan lowlo' chewa com nquixbison na y nquixok' na. ");
INSERT INTO tzjE_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tak nya'a ek'ij cmal conjelal wnak jara' congan lowlo' chewa com je' cti't quemma' j-e' xqueya' quek'ij chka' e ojer tak profeta jme e rxin ta Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Per ixix je cnewc'axaj camic cawra quenbij chewa ra, que'ewaj-o' je nquebnowa lowlo' chewa. Tak ec'ola xitzel nquixquetz'et, ixix utzil tebna' chca. ");
INSERT INTO tzjE_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tak ec'ola nquebina itzel tak tzij chewa, ixix xruyon utzlaj tak tzij tbij chca. Tak ec'ola nquixetz'juwa, ixix tebna' orar pquecwent. ");
INSERT INTO tzjE_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wc'ola jun xuya' jun k'a' chaplaj tey-a' c'as tzra chnuya' chic jun pjupraj chic aplaj. Wc'ola jun chic xumaj acmis chawa tey-a' ela achump tzra chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wc'ola jun xc'utuj jun achnak chawa tey-a' tzra, y wc'ola jun xuc'om ela jun achnak chawa mtach'ojquij ta tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jun chic, nak neyarij chca wnak che nqueban chewa cara' c'a tebna' ixix chca chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","We ixix xqueyon j-era' lok' nque'ena' jlok' ixquen-on ixix ¿lc'o tc'ara' jun sip rxin Dios nyataja chewa nech'ob ixix? Com je' e itzel tak wnak arj-e' lok' nquequena' je nquejona cxin. ");
INSERT INTO tzjE_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Jun chic, wex queyon j-era' neban utzil chca je nquebnowa utzil chewa ixix ¿lc'o tc'ara' jun sip rxin Dios nyataja chewa nech'ob ixix? Com je e itzel tak wnak arj-e' chka' nqueban utzil chca jebanyona utzil chca j-e'. ");
INSERT INTO tzjE_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jun chic, tak c'ola neya' pe kjonem y ewutkin che nya'a rec'xel ¿lc'o tc'ara' jun sip rxin Dios nyataja chewa nech'ob ixix? Com je e itzel tak wnak arj-e' chka' c'ola nqueya' pe kjonem jcutkin che nya'a rec'xel. ");
INSERT INTO tzjE_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Per ixix que'ewaj-o' je nquebnowa lowlo' chewa, tsipaj ewutzil chca, tey-a' pe kjonem jc'ola ewq'uin per mteya' ta cas rec'xel. Wcara' neban jara' c'ola jun nimlaj rtojbalil nyataj na chewa y tzra' nquixk'aljen wa' che ix rlec'wal nimlaj Dios, com Dios arja' nsipaj utzil chca wnak mesque majo'n necmeltioxij ta tzra, mesque xe e itzel tak wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ajni' nuban Edta' Dios congan npoknaj quewech wnak cara' c'a tebna' ixix, tpoknaj quewech chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mtquixoc ta ix k'toy tak tzij chquij wnak ch-utz c'ara' Dios majo'n nuk'et ta tzij chewij ixix chka'. Mtec'utuj ta chquij wnak che nquetoj na il mac je nqueban ch-utz c'ara' Dios majo'n nbij ta chewa che netoj na il mac jneban ixix. Que'ecyu' je' wnak. We nque'ecuy, Dios chka' nquixrucuy ixix. ");
INSERT INTO tzjE_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tsipaj chca wnak je nc'atzina chca. Wnesipaj chca jara' nya'a rjel rec'xel chewa. Per je rjel rec'xel je xtya'a chewa cara' rbanic ajni' nuban jun c'yil tak achnak tz'kat npajona, kas bien jic nuya' rlipr y nuya' rsobr. Cara' quenbij chewa com wq'uiy nesipaj jara' q'uiy necochij tzra Dios, o wxe mq'uiy ta nesipaj jara' mq'uiy ta necochij ixix tzra Dios chka'. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","C'jara' xbij jun c'ambal tzij chca: —Jun moy wnuchap ela chuk'a' jun moy chic jara' xe nquetza'k ela pjul che c-e'. ");
INSERT INTO tzjE_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Majo'n jun discípulo xtrutkij ta más chwech ajni' rutkin rmaestro. Per jun discípulo chka bechnak opech discípulo we bien ntijoj ri' jara' cara' nela rna'oj ajni' rxin rmaestro. ");
INSERT INTO tzjE_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Nak tzra tak nech'ulchin tak nuban jun ch'it ril ewch'alal per majo'n nena' kta ixix je' nmak tak ewil jneban? Tak neban cara' jara' ajni' nech'ulchij jun rc'utal che' jc'ola chi' rk'arwech ewch'alal per majo'n neya' kta cwent ixix tzrij jun nimlaj che' jc'ola chi' ek'awech. ");
INSERT INTO tzjE_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Chka' ¿nak tzra tak nebij tzra ewch'alal: —Kch'alal, tey-a' c'as chka che nkaya' ana'oj rmal il mac jc'ola chpam ac'aslemal, cara' nebij tzra, per xe mtena' kaja ixix xmás chna nim il mac c'ola chpam ec'aslemal ixix? Tak cara' neban xcaca' eplaj. Wnewajo' neya' rna'oj ewch'alal nc'atzina nabey mul che neya' cana rtzilal jc'ola chpam ec'aslemal ixix ch-utz c'ara' nquixecwina neya' utzlaj tak na'oj tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Cara' quenbij chewa com majo'n jun utzlaj che' xtuya' ta itzel rwech next c'a itzel che' xtuya' wen rwech. ");
INSERT INTO tzjE_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Che njelal che' xe rmal rwech nuya' tak notkixa nak chche'al. Ajni' tzra q'uix mesquier necwina xtwachij ta higo next c'a xulquiej xtwachij ta uva. ");
INSERT INTO tzjE_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jun utzlaj acha utzil rec'lon pranm y tak ntzijona utzil rec'mon ta je nbij. Jun itzel acha xitzel tak achnak rec'lon pranm y tak ntzijona xitzel tak achnak rec'mon ta je nbij. Cara' quenbij chewa com jnojnak pranm jun wnak jara' nel ta pruchi'. ");
INSERT INTO tzjE_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Nak tzra tak cawra nebij chwa ra: —Kajaw, Kajaw, per xmajo'n neban ta jquenbij chewa chneban? ");
INSERT INTO tzjE_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Chka bechnak wnak npeta wq'uin we nc'axaj jnemjon rbixic y nuban jquenbij tzra arja' cawra rbanic: ");
INSERT INTO tzjE_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","arja' e junam ruq'uin jun acha xuban jun ruchoch, xuc'ot na jabar nutic wa' cimiento y pe rwá' abaj xtz'uba' wa'. Tak xumaj rij jun k'jaljab xq'uiya rkanya', nlowlo' xba'na tzra jay rmal rkan ya' per majo'n xba ta penlew com wen rtiquic bnon. ");
INSERT INTO tzjE_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Per jun wnak chek jic nc'axaj ntzojbal y majo'n nuban ta jquenbij tzra chnuban, arja' junam ruq'uin jun acha xuban jun ruchoch per majo'n rcimient, xpe rwá' ulew xtz'uba' wa'. Tak xq'uiya rkan ya' nlowlo' xba'na tzra jay y nalnak xba penlew, ne xtz'ila' jay junlic. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús tak xec'choja tzij rmal cuq'uin wnak xba pCapernaum. ");
INSERT INTO tzjE_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","C'ol c'a jun capitán cxin soldado, c'ola jun rmos yawa'. Ja' mos congan lok' nna'a rmal capitán y xyamer ncoma. ");
INSERT INTO tzjE_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ja' capitán tak xekaja rbixic Jesús ruq'uin ec'ola jle' anciano e aj Israel xerutak ela che necc'utuj jun utzil tzra Jesús che npeta y nerchumsaj rmos. ");
INSERT INTO tzjE_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tak xe'ekaja ruq'uin Jesús congan xquemaj rc'utxic jun utzil tzra: —Jcapitán nyatanak wa' tzra chnabna' utzil tzra jkamjon rc'utxic chawa ");
INSERT INTO tzjE_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","com arja' congan nokrajo' ja ok tnamet Israel. Ja' banyona jay rxin molbal ri'il jabar nkamol wa' ki' che rc'axic rtzojbal Dios, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","C'jara' xeba, xequexbilaj ela Jesús. Ja' capitán tak c'o chic Jesús chenkaj ruq'uin ruchoch arja' xerutak ela jle' ramigo che rc'ulic, cawra xbij ela tzra Jesús: —Wajaw, mtcatel ta ch'u'j nmal anen, atet ajni'la nim ak'ij, mtyataja chwij che xcatoc ta chpam wuchoch. ");
INSERT INTO tzjE_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Y nexte yatanak chwij chka' xenba ta awq'uin, y jquenwajo' chawa, tbij che nec'choja nmos y wutkin che xruq'uin ra' nec'choja. ");
INSERT INTO tzjE_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Cara' quenbij chawa com anen wutkin nak rbanic tak ncatba'na mandar. Ec'ola nquebnowa mandar wxin anen y chka' ec'ola soldado pnuk'a' anen chquenuban mandar. Tak quenbij tzra jun acha: —Catel ela, y jara' acha nel ela. Wquenbij tzra jun chic: —Catjo', jara' ne npe wa'. Tak quenbij tzra nmos jc'ola pnuk'a': —Tebna' jawrara, y ja' nuban. Cara' xbij ela capitán tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ja' Jesús congan xel ta ruc'u'x tzrij je xbixa tzra rmal capitán. Tak xc'axtaja rmal xuya' volt, y com ec'ola wnak etrena tzrij cawra xbij chca ra: —Anen quenbij chewa, jcapitán arja' más chna k'axnak wen ryukbal ruc'u'x wq'uin anen que chewech ixix je ix aj Israel, nexte c'o ta jun chewa newlon cara' ta yukbal ruc'u'x wq'uin ajni' rxin ja', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Je' wnak jetkon ela rmal capitán arj-e' xemloj ta. Y tak xquetz'et mos majo'n chic yawa' ta, utz chic. ");
INSERT INTO tzjE_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Je pjun k'ij chic ja' Jesús xba chpam jun tnamet Naín rubi'. E q'uiy chca rdiscípulo xerexbilaj ela y congan e q'uiy wnak xetre' ela tzrij. ");
INSERT INTO tzjE_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ja' Jesús tak xekaja chenkaj abar ncatoc el wa' chpam tnamet ec'ola jle' wnak xerutz'et, c'ola jun comnak nequemku'. Jnemu'ka jara' ral jun ixak melca'n y nxer oca jun ral, y xcoma. Ja' ixak e q'uiy rwinak etren ela tzrij che rmukic comnak. ");
INSERT INTO tzjE_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ja' Kajaw Jesús tak xutz'et ixak congan xpoknaj rwech: —Mtcatok' ta, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","C'jara' xuchap rwarbal jabar telen wa' jcomnak. Je' wnak jetelyon ela rxin comnak arj-e' xepapo'a. C'jara' Jesús cawra xbij tzra comnak ra: —C'jol, camic quenbij chawa, catyictaja. Cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ja' c'jol xc'astaja, xetz'be'a y xumaj tzij. C'jara' ja' Jesús xujach cana tzra rute'. ");
INSERT INTO tzjE_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Je' wnak congan xecxibej qui' rmal je xbantaja per ne che conjelal, y xquemaj rya'ic ruk'ij Dios: —Jala' jun nimlaj profeta rxin Dios je xwankera chkacjol camic. Dios camic retkon ta jun To'onel chkacjol ja ok tnamet rxin, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jmilagro jxuban Jesús jara' xel ela rbixic njelal nat nkaj chpam departamento Judea y xela rbixic chka' njelal tnamet jc'ola chenkaj ruq'uin departamento. ");
INSERT INTO tzjE_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Njelal jawra je xbantaja xecho'la tzra Juan Bautista cmal je rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ja' Juan ec'ola e c-e' chca rdiscípulo xersiq'uij, xerutak ela ruq'uin Jesús y cawra xbij ela chca ra che necc'axaj: —¿Le atet at Cristo jbitanak cana che ncatpet na, owe nkeybej chna jun? cara' xbij ela chca. ");
INSERT INTO tzjE_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tak xe'ekaja ruq'uin Jesús cawra xecbij tzra: —Juan Bautista arja' okretkon ta awq'uin, cawra rbin ta che nekc'axaj chawa: —¿Le atet at Cristo jbitanak cana che ncatpet na, owe nkeybej chna jun? Cara' rbin ta. ");
INSERT INTO tzjE_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ja' Jesús njara' hor xumaj cchumsic jle' wnak jec'ola tzra' per ne q'uiy j-e' wnak. Xerchumsaj je' yuw-i' mesque emajtanak rmal cowlaj tak yubil, xeruto' jec'ola pquek'a' itzel tak espíritu y e q'uiy moya' xujak quewech chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","C'jara' cawra xbij chca je c-e' rdiscípulo Juan: —Jax ebij tzra Juan njelal jetz'ton camic y njelal jewc'axan. Je' moya' nqueca'y chic. Jch'e'y nquebina jara' jic chic nquebina. Nak jc'ola itzel yubil jlepra chquij arj-e' xechumtaja. Je' tcon necc'axaj chic tzij camic. Je' cnomki' xec'astaja. Je' mibi' majtanak rbixic chca utzlaj tzij je rxin totanem jretkon ta Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Chka' tbij tzra Juan chcongan qui' quec'u'x wnak jmajo'n jun twa' nquena' rmal samaj jnemjon rbanic. Cara' tbij tzra, cara' xbij ela ja' Jesús chca rdiscípulo Juan Bautista. ");
INSERT INTO tzjE_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tak ebnak chic e c-e' discípulo ja' Jesús xumaj chic tzij cuq'uin wnak tzrij Juan Bautista. —Ja' Juan tak xec'je'a chpam je' tenlak tak lwar ¿nak tzra tak xixba ruq'uin che rtz'etic, le rmal ja' Juan chek remril ajni' jun aj je njech'loxa rmal xecmel? ");
INSERT INTO tzjE_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Nak tzra tak xixba ruq'uin che rtz'etic, le rmal Juan chcongan rewkon ri' tzra wen tak tziak y congan nmak rjel? Per ixix bien ewutkin che je' wnak je nquecsana wen tak tziak je nmak rejlal y nquelok' jachnak c'ola cgan tzrij che nquelok', arj-e' chpam nmak tak jay cxin rey nquec'je' wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Nak tzra tak xixba ruq'uin che rtz'etic, le rmal Juan che arja' jun profeta rxin Dios? Jara' ne ktzij wa' che profeta per mruyon ta profeta ocnak wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Cara' quenbij chewa com ja' Juan xchumsana rubey Cristo ajni' tz'ibtanak cana chpam rtzojbal Dios jcawrara nbij: —Anen quentak ela nmensajero che nnabyeja chawech ch-utz c'ara' arja' nchumsana abey. Cara' tz'ibtanak cana rmal Dios tzrij Cristo. ");
INSERT INTO tzjE_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Anen quenbij chewa che majo'n jun profeta c'jenak ta wawe' chwech ruch'lew jnim ta ruk'ij chwech Juan Bautista, per chpam rgobierno Dios jun wnak mesque ch'it sencillo per más chna nim ruk'ij que chwech Juan, cara' xbij Jesús chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Conjelal wnak e quexbil e mloy tak impuesto tak xecc'axaj je xbij Jesús xquemaj rya'ic ruk'ij Dios com arj-e' ebnon bautizar rmal Juan. ");
INSERT INTO tzjE_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Per aj fariseo e quexbil maestro je nquetijona cxin wnak tzrij rley Dios arj-e' majo'n xcajo' ta xeba'na bautizar rmal Juan, jara' xecch'ojquij je nrajo' ranm Dios ptak cc'aslemal. ");
INSERT INTO tzjE_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","C'jara' ja' Kajaw Jesús xumaj chic rij tzij: —¿Abar c'a wa' quixenjumsaj wa' ixix jix tnamet Israel? ");
INSERT INTO tzjE_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cuq'uin c-e' moc ac'ala' quixenjumsaj wa' jquemjon tz'anem ptak q'uebal. Jun moc nquerak quechi' chquij jun moc chic: —Ajoj xkaban nic'aj bix rxin quicotemal per ixix majo'n xjoj xeban ta, majo'n xixquicot ta. Y xkaban jun chic rxin bis y nmajo'n xixbison ta chka'. Nmajo'n nak newajo', cara' xecbij ac'ala' chca e jmoc chic. ");
INSERT INTO tzjE_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ixix quixenjumsaj cuq'uin ac'ala' je nmajo'n nak ncajo', com Juan Bautista tak arja' xpeta majo'n kas ta nwa'a cuq'uin wnak y majo'n vino xutaj ta, rmal c'ara' tak xebij tzra chc'ola jun itzel espíritu pranm. ");
INSERT INTO tzjE_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Y xenpet chic anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak, xenwa'a cuq'uin wnak y xentaj vino, y rmal ra' xebij chwa che en ajmund, xe en tjoy vino y xe e wamigo e mloy tak impuesto ruq'uin jle' chic aj-il aj mac. ");
INSERT INTO tzjE_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Per conjelal je' rlec'wal Dios arj-e' bien nch'obtaja cmal che Juan Bautista rna'oj Dios rucsan y cutkin chka' che anen rna'oj Dios nucsan. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","C'o c'a jun acha aj fariseo xuban invitar Jesús pruchoch che newa'a ruq'uin. Ja' Jesús xba ruq'uin y tak xekaja xetz'be'a tzrij mes. ");
INSERT INTO tzjE_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chpam jara' tnamet tzra' c'o wa' jun ixak itzel rc'aslemal. Ja' ixak tak xc'axaj chJesús remjon w-im pjay ruq'uin aj fariseo xba ruq'uin, rec'mon ela jle' ak'om qui' rexla', rec'mon ela chpam jun rc'olibal je bnon rbanic, alabastro ocnak. ");
INSERT INTO tzjE_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tak xekaja ruq'uin Jesús xexque'a y xumaj ok'ej. Jri'al rwech congan xkaja tzrij rkan Jesús y tzra resmal rwá' xsubej. Tak xsutaja rmal c'jara' xtz'ubaj rkan y xuya' ak'om tzrij. ");
INSERT INTO tzjE_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fariseo jbanyona invitar rxin Jesús, tak xutz'et jxuban ixak cawra xuch'ob kaja pranm: —Ja' Jesús wext ktzij che profeta rxin Dios rutkin tc'ara' nak rbanic jun ixak je ntajina nuchap rkan. Com jala' jun ixak xitzel rc'aslemal. Cara' xuch'ob kaja. ");
INSERT INTO tzjE_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","C'jara' Jesús cawra xbij tzra: —Simón, camic c'ola jun tzij quenwajo' quenbij chawa: —Utz c'ara' Maestro, tbij chwa, cara' xbij ja' Simón. ");
INSERT INTO tzjE_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","C'jara' cawra xbix chic tzra rmal Jesús: —C'ola jun acha ec'ola e c-e' ach-i' c'ola quec'as ruq'uin. Jun, j-o' cient ruc'as, jun chic cincuenta. ");
INSERT INTO tzjE_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tak mxecwin ta xquetoj quec'as majo'n achnak xba'na chca, xecu'ya rmal rajaw pak. Camic Simón, tbij c'a chwa ¿nak chca e c-e' ach-i' más njo'na rxin rajaw pak? cara' xbixa tzra Simón. ");
INSERT INTO tzjE_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Jquenbij anen jara' más nim ruc'as, cara' xbij tzra. —Cara', xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","C'jara' ja' Jesús xuya' volt, nutz'et ixak y cawra xbij chic tzra Simón: —Tetz'ta' mpa' jawra ixak. Atet, tak xenoc ta chpam awuchoch majo'n xaya' ta ch'ajbal wkan che nc'ulic, per jawra ixak arja' xuch'aj wkan tzan ri'al rk'arwech y tzra resmal rwá' xsubej. ");
INSERT INTO tzjE_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Atet majo'n xatz'ubaj ta nuchi' che nc'ulic, per jawra ixak njunlic remjon rtz'ubxic wkan. ");
INSERT INTO tzjE_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Atet nexte aceite xaya' pe nwá' che nc'ulic, per jawra ixak xujic wkan chpam jun ak'om jcongan qui' rexla'. ");
INSERT INTO tzjE_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Rmal c'ara' tak quenbij chawa, jawra ixak mesque congan il mac rebnon per bien k'alaj che cuytanak chic njelal com congan quenrajo'. Per we mq'uiy ta awil amac cuytanak jara' majo'n kas ta nwankera ojben ri'il chpam awanm, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","C'jara' cawra xbij tzra ixak: —Xcuytaja awil amac, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jle' chic invitado jec'ola tzrij mes ruq'uin Jesús arj-e' xquemaj tzij chbil tak qui': —¿Nak rbanic ja' Jesús tak nbij che nucuy il mac chka'? ");
INSERT INTO tzjE_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ja' Jesús cawra xbij chic tzra ixak: —Jyukbal ac'u'x jc'ola wq'uin jara' xatet-owa. Camic utz chic ncatba y catquicota, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Xuban jun c-e' k'ij xumaj chic rubey Jesús, xba chpam njelal tnamet y chpam je' aldea, nuya' rbixic rtzojbal Dios y nuch'ob chquewech wnak utzlaj tzij jnuc'ut chkawech nak rbanic je rgobierno Dios. Xerexbilaj je cbeljuj apóstol. ");
INSERT INTO tzjE_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ec'ola jle' ixki' xerexbilaj chka'. J-ewra ixki' nabey emajtanak rmal yubil y ec'ola pquek'a' itzel tak espíritu per echumsan chic rmal Jesús. Jun ixak María rubi', jc'o chic jun rubi' Magdalena. Ja' María Magdalena e wku' itzel tak espíritu xelsasa pranm rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jun chic, Juana rubi', rexkayil Chuza, administrador rxin Herodes. Jun chic Susana rubi', y ec'o na más chka'. C'ola cmibil jnectobej Jesús chpam jnak nc'atzina tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Congan e q'uiy wnak xecremlo' qui' ruq'uin Jesús, njelal tnamet epenak wa'. C'jara' c'ola jun c'ambal tzij xbij chca cawrara: ");
INSERT INTO tzjE_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—C'ola jun ajsmajma' xba pe tcoj rtejco'n pe rchinoj. Tak xekaja xumaj rch'akxic ija'tz. C'ola nic'aj xkaja pbey, xpa'k' cana cmal wnak y xti'ja cmal tzq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","C'o chic jle' xkaja abar c'o wa' abaj. Tak xel ta xechkija alnak com majo'n rex ta ulew. ");
INSERT INTO tzjE_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","C'o chic jle' xkaja ptak q'uix y tak xel ta xumaj c'yinem, per njunam xq'uiya ruq'uin q'uix. Tak xq'uisbena xcamsasa tejco'n rmal q'uix. ");
INSERT INTO tzjE_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Per c'o chic jle' xkaja chpam utzlaj ulew y congan xwachina, jujun rk'arwech ija'tz xuya' jujun cient rwech, cara' xbij Jesús chca. Tak xbitaja tzij rmal congan cow xtzijona. —Achnak c'ola rexquin tc'axaj c'a jquenbij. Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","C'jara' je' rdiscípulo cawra xecbij tzra: —Tech'bo' chkawech nak rbanic jc'ambal tzij je c'ja' xabij kaja, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ja' Jesús cawra xbij chca ra: —Ixix yatanak chewa chnewutkij nak rbanic jwewtanak tzrij rgobierno Dios per jle' chic wnak pc'ambal tzij quentzijon wa' cuq'uin ch-utz c'ara' mesque c'ola ck'awech per majo'n nquetz'et ta je nc'u'ta chquewech, mesque nc'ola quexquin per majo'n nch'obtaj ta cmal je nbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Camic quench'ob chewech nak rbanic jc'ambal tzij. Ija'tz jara' nbij tzij rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Je xkaja pbey jara' nbij tzij che ec'ola wnak je nquec'axana rtzojbal Dios per npeta diablo nelsaj ela rtzojbal Dios ptak canm ch-utz c'ara' majo'n necnimaj ta y che mtquewil totanem rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Je xkaja abar c'o wa' abaj jara' nbij tzij che ec'ola wnak je necc'axaj rtzojbal Dios y necnimaj, congan nquequicota rmal. Per arj-e' e ajni' jle' tejco'n majo'n rc'amal ruxe', njun rmaj oca necnimaj. Tak nerla' lowlo' tiemp xe nqueya' cana. ");
INSERT INTO tzjE_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Je xkaja ptak q'uix jara' nbij tzij che ec'ola wnak necc'axaj rtzojbal Dios per tak nq'uisbena xe nquek'oysas chic rmal je' achnak rxin rwech ruch'lew ajni' mibil, ajni' quicotemal, ajni' njunlic nba quec'u'x tzrij je' achnak. Arj-e' e ajni' jle' tejco'n je nmajo'n rwech nuya'. ");
INSERT INTO tzjE_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Per ija'tz je xkaja chpam utzlaj ulew jara' nbij tzij che ec'ola wnak je necc'axaj rtzojbal Dios y nqueyic pcanm per jun utzlaj anm je rc'an rbeyal. Arj-e' nquecoch' je npeta chquij y tak nq'uisbena wen nwachina utzil ptak cc'aslemal. ");
INSERT INTO tzjE_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Majo'n jun wnak xtebnowa xtutzaj ta jun candil y xtjupba' ta jun bjoy pe rwá' next c'a xtuya' ta chuxe' jun ch'at chka'. Per je nba'na, tak ntza'ja jun candil ncanoxa jun rc'ulibal jabar nya' wa' ch-utz c'ara' psak nquec'je' wa' wnak je nque'oca pjay. ");
INSERT INTO tzjE_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Cara' quenbij chewa com njelal jwewtanak jara' nel na psak y je njelal jmajo'n k'aljennak ta jara' nerla' na jun k'ij tak xtk'aljina, notkix na. ");
INSERT INTO tzjE_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Rmal c'ara' tak quenbij chewa, bien tey-a' ewexquin tzrij jemjon rc'axic com je' wnak jc'ola yatanak chca arj-e' nyataj na más chca. Je' wnak je nmajo'n yatanak chca per j-e' nquech'ob chc'ola jara' nelsasa chca. Cara' xbij Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","C'jara' xe'erkaja rch'alal Jesús rexbil rute' per mesquier nquecwina nque'oca abar c'o wa' ja' com congan e q'uiy wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","C'jara' xbixa tzra Jesús: —Tetz'ta' mpa' ate' ruq'uin je' awch'alal ec'ola chujay, ncatecsiq'uij, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ja' Jesús cawra xbij chca ra: —Je nquec'axana rtzojbal Dios y nqueban je nbij chca che nqueban arj-e' c'ara' e'ocnak nute' ruq'uin e'ocnak wch'alal, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Xuban jmul Jesús xoc planch e rexbil je' rdiscípulo: —Jo' pjupraj ya', cara' xbij chca y xeba. ");
INSERT INTO tzjE_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kas quemjon binem pe rwá' ya' tak xkaja che wram Jesús. Chek q'uenjlal tak xkaj ta jun nimlaj k'ek' chquij. Jlanch ntajina nnoja ya' chpam, ec'o chic chpam jun lowlo'. ");
INSERT INTO tzjE_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","J-e' discípulo xquec'as Jesús: —Maestro, Maestro, camic nokcoma, nokba pya', cara' xecbij tzra. Xyictaja Jesús, xuk'il k'ek', xuk'il ya' chka'. C'jara' xcoma k'ek' y xjun xec'je' wa' ya'. ");
INSERT INTO tzjE_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","C'jara' cawra xbij chca: —¿Abar c'a xoc wa' yukbal ec'u'x wq'uin? cara' xbij chca. Arj-e' congan cxiben qui', congan xel ta quec'u'x tzrij tak xquetz'et je xbantaja y cawra xquemaj rbixic chbil tak qui': —¿Nak rbanic c'ala' jala acha? Com arja' nuban mandar k'ek', nuban mandar ya', y nnimax tak wan chka', cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Xe'ekaja chpam jun lwar jc'ola pquecwent aj Gadarenos jc'ola pjupraj ya' chwech departamento Galilea. ");
INSERT INTO tzjE_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ja' Jesús tak xel ela planch c'ola jun acha xekaja ruq'uin. Ja' acha c'o chic tiemp e'ocnak jle' itzel tak espíritu pranm. Nmajo'n retziak rucsan y nmajo'n nec'je' ta pruchoch chka', xe pcomsant nec'je' wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tak xutz'et Jesús xumaj rakic ruchi', xexque'a chwech y ncow xtzijona ruq'uin, cawra xbij tzra: —Jesús, atet at Rlec'wal nimlaj Dios. ¿Nak nawajo' chwa? Tebna' jun utzil, mtaban ta lowlo' chwa, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Cara' xbij tzra com Jesús arja' ntajina nuban mandar itzel espíritu jocnak pranm acha che nel ela. Ja' acha q'uiylaj mul c'jenak pruk'a' itzel espíritu, y c'ola bc'on je' ruk'a' rkan pcadena per nmajo'n pen nutaj ta che nq'uiekpij ela y nec'mar ela rmal itzel espíritu chpam chkilaj tak lwar. ");
INSERT INTO tzjE_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ja' Jesús cawra xc'axaj tzra: —¿Nak abi'? —Anen en Legión, cara' xbij ja' acha. Cara' rubi' xbij com congan e q'uiy jle' itzel tak espíritu e'ocnak pranm. ");
INSERT INTO tzjE_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","J-e' c'a itzel tak espíritu congan nquecsaj cchuk'a' che necc'utuj tzra Jesús chmajo'n nquerutak el ta chpam nimlaj jul je nq'ue c'nat nekaj wa' xuxe' ulew chpam nimlaj k'ejkumal. ");
INSERT INTO tzjE_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ec'o pon c'a jle' a'k per congan e q'uiy y quemjon w-im ptak k'ayis. J-e' c'a itzel tak espíritu ne nquecsaj cchuk'a' che necc'utuj tzra Jesús chnuya' c'as chca che nque'oca chquepam je' a'k. Ja' Jesús xuya' c'as chca. ");
INSERT INTO tzjE_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Cara' xqueban, xe'el ela pranm acha y xe'oca chquepam je' a'k. J-e' a'k chek xe'oca je' itzel tak espíritu chquepam nalnak xexle'a chwech jun tectic jyu' y nq'ue pya' xe'ekaj wa' conjelal, y xq'uis kaja quexla'. ");
INSERT INTO tzjE_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Je chajinel cxin a'k tak nquetz'et je xbantaja xenanmaj ela, xeba chpam tnamet ruq'uin je' ptak aldea chka', xequechlo' njelal je xbantaja. ");
INSERT INTO tzjE_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Je' wnak tak xecc'axaj, arj-e' xepeta che necretz'ta' je xbantaja. Tak xe'erkaja abar c'o wa' Jesús xquetz'et acha jxelsasa itzel espíritu pranm, arja' chwech Jesús tz'bul wa', c'o chic retziak recsan y tz'kat chic rna'oj. J-e' c'a wnak tak xquetz'et congan xecxibej qui' rmal. ");
INSERT INTO tzjE_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","C'jara' jxetz'towa je xbantaja arj-e' xquemaj rcholic chquewech jle' chic wnak nak xuban tak xchumtaja acha jc'ola jle' itzel tak espíritu pranm. ");
INSERT INTO tzjE_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Conjelal wnak aj Gadarenos arj-e' xecc'utuj tzra Jesús che mtec'je' xta más chquecjol com congan cxiben qui'. Jesús xoc chic chpam lanch che nemloja. ");
INSERT INTO tzjE_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Acha jxelsasa e itzel espíritu pranm cawra xbij tzra Jesús: —Tebna' jun utzil, tey-a' c'as chwa chquentre'a chawij junlic, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Mejor jnaban, jat pnawuchoch abij chca wnak che ajni'la jun nimlaj samaj xuban Dios chpam ac'aslemal, cara' xbixa tzra rmal Jesús. C'jara' xba ja' acha chpam tnamet y xumaj rbixic chca conjelal wnak jnimlaj samaj xuban Jesús chpam rc'aslemal. ");
INSERT INTO tzjE_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ja' Jesús tak xemloj chic jmul pjupraj ya' congan qui'il rc'ulic xba'na cmal wnak com yben cmal conjelal. ");
INSERT INTO tzjE_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","C'jara' c'ola jun acha xpeta, Jairo rubi', arja' jun chca jefe rxin jay je rxin molbal ri'il jabar nc'axax wa' rtzojbal Dios. Ja' Jairo tak xerkaja ruq'uin Jesús xexque'a chwech y congan xc'utuj jun utzil tzra che nba chruchoch, ");
INSERT INTO tzjE_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","com c'ola jun rmi'al cmic nuban chic, y njun oca. C'o lala' cbeljuj rjuna'. Xba ja' Jesús per congan e q'uiy wnak nquepitz' qui' tzrij ebnak chruchoch Jairo. ");
INSERT INTO tzjE_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","C'ol c'a jun ixak yawa' c'ola chquecjol wnak, xuban cbeljuj juna' c'ola quic' nela tzra. Ja' ixak rec'son chic njelal jc'ola ruq'uin che rk'omxic ri' cuq'uin je' doctor per next jun cwennak ta chumsyona rxin. ");
INSERT INTO tzjE_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jxuban ixak chkajni' xki'l oca más ruq'uin Jesús. Tak xekaja ruq'uin xuchap oca jtz'it ruchi' retziak. Chek xuchap oca retziak Jesús xetne'a quic' tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ja' Jesús cawra xbij: —¿Nak xenchpowa? cara' xc'axaj. —Manen ta, manen ta, cara' xecbij conjelal wnak. Pedro ruq'uin je' rexbil cawra xecbij tzra Jesús: —Maestro, per e congan wnak queptz'on qui' chawij y nquemin qui' chawij chka'. ¿Nak tzra tak nabij: —Nak xenchpowa? ");
INSERT INTO tzjE_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Anen wutkin chc'ola jun xenchpowa com xenna' chc'ola poder xel ela wq'uin, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ja' ixak tak xutz'et mesquier chic necwina nwiwaj jxuban xpeta, congan nberbeta rmal xben ri'il, xexque'a chwech Jesús y xumaj rbixic tzra nak tzra tak xuchap oca retziak, per ne chquewech conjelal wnak xbij wa' tzra. Xbij tzra chka' che njara' hor xec'choja. ");
INSERT INTO tzjE_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Cawra xbixa tzra rmal Jesús: —Nmi'al, jyukbal ac'u'x wq'uin jara' xatchumsana. Camic utz chic ncatba, catquicota, cara' xbixa tzra ixak. ");
INSERT INTO tzjE_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ja' Jesús c'remjon na tzij tak c'ola jun wnak xerkaja, elnak ta pruchoch jefe rxin jay rxin molbal ri'il, cawra xbij tzra jefe: —Jairo, ami'al xcoma, mtaban xta molestar Maestro, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ja' Jesús chek xc'axtaja rmal je xbixa tzra Jairo cawra xbij tzra: —Mtaxibej ta awi'. Jnaban camic, teyke'a ac'u'x wq'uin y ami'al nchumtaja, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tak xe'ekaja chruchoch Jairo ja' Jesús mxuya' ta c'as chca wnak che xe'oc ta pjay ruq'uin. Jxe'oca chpam xqueyon Pedro, Jacobo, ruq'uin Juan e quexbil redta' rute' xten. ");
INSERT INTO tzjE_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Conjelal wnak quemjon ok'ej y congan rkala quechi'. Jesús cawra xbij chca: —Mtquixok' ta com xten majo'n comnak ta, xe wram rebnon, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Per arj-e' xe xectzebej com arj-e' bien cutkin che comnak chic xten. ");
INSERT INTO tzjE_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","C'jara' Jesús xuchap chuk'a' comnak y cawra xbij tzra: —Catyictaja xten, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ja' xten xemloj ta rwech y njara' hor xyictaja. C'jara' ja' Jesús xbij chca che nqueya' rway. ");
INSERT INTO tzjE_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jredta' rute' arj-e' congan xel ta quec'u'x tak xquetz'et milagro jxuban Jesús per cawra xbij chca: —Nmajo'n abar tebij wa' je xbantaja, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","C'jara' xersiq'uij e cbeljuj rdiscípulo y xuya' chca chc'ola quek'a' chquij conjelal e itzel tak espíritu che nquecwina nquequelsaj ela pcanm wnak y xuya' chca chka' che nquecwina nquecchumsaj yuw-i'. ");
INSERT INTO tzjE_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Y xerutak ela chnequey-a' rbixic rgobierno Dios y ch-utz c'ara' chka' che nquecchumsaj yuw-i'. ");
INSERT INTO tzjE_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Cawra xbij ela chca: —Nmajo'n achnak nec'om ela tak xtquixba, nexte ech'me'y nec'om ela, nexte emlet nec'om ela, nexte eway, nexte epak nec'om ela, y ne xjara' ecmis ecsan nec'om ela, me c-e' ta newc'aj. ");
INSERT INTO tzjE_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Chka bechnak opech jay nquixoc wa' tzra' nquixec'je' wa', c'jara' neya' cana tak nquixba chic chpam jun chic tnamet. ");
INSERT INTO tzjE_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Y nak mxtec'luw ta ewxin, tak nquixel ta chpam quetnamet tquiraj cana pkok jc'ola pnewkan. Cara' neban y jara' rital che arj-e' nquetaj na lowlo' rmal jmajo'n nqueya' ta quexquin tzrij jnebij chca, cara' xbij ela chca. ");
INSERT INTO tzjE_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Je cbeljuj discípulo arj-e' xe'el ela, xeba ptak aldea per ne njelal aldea, xquemaj rbixic ja utzlaj tzij rxin Jesucristo y xquemaj cchumsic je yuw-i' chka'. Cara' xqueban chkabar opech xe'ekaj wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Njelal jnuban Jesús xekaja rbixic ruq'uin gobernador Herodes. Ja' Herodes kas nk'aysaj ri' che rch'obic nak kas mer nebnowa njelal jawrara jnekaja rbixic ruq'uin. Com ec'ola nquebina che Juan Bautista nebnowa com arj-e' necbij che c'astanak chic Juan Bautista chquecjol cnomki'. ");
INSERT INTO tzjE_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ec'o chic jle' nquebina che camnak Elías nebnowa com arj-e' necbij che rec'tun chic ri' Elías chquewech wnak. Y ec'ol chic jle' nquebina chc'ola jun chca ja e ojer tak profeta jc'astanak ta y jara' nebnowa, cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Per Herodes cawra xbij ra: —Je Juan, anen wan xenyowa orden che xelsasa rwá' per nak la acha jnebnowa njelal jawrara jnerkaja rbixic wq'uin. Cara' xbij, y xumaj rch'obic nak nuban ch-utz c'ara' nutz'et ri' quewech ruq'uin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Je cbeljuj apóstol tak xemloj ta xquechol tzra Jesús njelal jxequebna'. Ja' Jesús xeruc'om ela, xecyonaj qui' pjun lwar kas tlena abar e majo'n wa' wnak. Jara' lwar c'ola precwent tnamet Betsaida. ");
INSERT INTO tzjE_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Je' wnak tak xekaja rbixic cuq'uin che xba Jesús xeba j-e' chka', xequewla'. Tak xe'ekaja ruq'uin Jesús arja' xeruc'ul, xuya' rbixic chca nak rbanic rgobierno Dios y xerchumsaj yuw-i'. ");
INSERT INTO tzjE_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tak xuban hor xepeta e cbeljuj apóstol y cawra xecbij tzra Jesús: —Mejor, que'atka' ela wnak ptak tnamet y ptak aldea jc'ola chenkaj ch-utz c'ara' neccanoj quepsad y nequelk'o' queway com je lwar jokc'o wa' congan tlena, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","—Ixix nquixyowa chca nak xtquetaj, cara' xbixa chca. —Per majo'n achnak kac'mon ta, ne j-o' oca rkan xquelway ruq'uin c-e' rkan ch'u'. We xtokba ajoj che rconxic queway j-ela wnak per nak neklok'bej. ");
INSERT INTO tzjE_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Cara' xecbij tzra com ec'ola la e j-o' mil xqueyon ach-i'. —Tbij chca wnak che nquetz'be'a, ptak mocaj necc'aj qui', e cincuenta e jujun moc, cara' xbij chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Cara' xqueban xekaja conjelal chtz'ublem. ");
INSERT INTO tzjE_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","C'jara' xuc'om j-o' rkan xquelway rexbil c-e' rkan ch'u', xca'ya chcaj y xmeltioxij tzra Dios. Xuwech' xquelway, xujach chca rdiscípulo che j-e' nqueya' chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Per ne conjelal xewa'a y xnoja quepam. Je xquelway rexbil ch'u' xmo'la ruchi' y xcoltaja cbeljuj chquech. ");
INSERT INTO tzjE_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Xuban jmul Jesús ruyon ryonan ri', remjon rij oración. Ec'ola rdiscípulo ruq'uin y cawra xbij chca: —Anen ¿nak nbanic necbij wnak? cara' xc'axaj chca. ");
INSERT INTO tzjE_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—Ec'ola nquebina chawa che at Juan Bautista, jle' chic necbij che at Elías, ec'o chic jle' nquebina che at jun chca e ojer tak profeta y camic atc'astanak ta chquecjol cnomki', cara' necbij chawa, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Ixix ¿nak nbanic nech'ob? Xpeta Pedro cawra xbij tzra: —Atet at Cristo je atch-on rmal Dios, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús congan xbij chca: —Nmajo'n abar tebij wa' che anen en Cristo. ");
INSERT INTO tzjE_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak q'uiy rwech lowlo' quentaj na, xitzel quenquetz'et na je' principal-i' rxin tnamet e quexbil je' cjefe sacerdote e quexbil chka' je' maestro je nquetijona cxin wnak tzrij rley Dios, quencamsas na y chrox k'ij quenc'astaja, cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","C'jara' xumaj chic tzij cuq'uin conjelal y cawra xbij chca ra: —Nak jun nrajo' neyke'a ruc'u'x wq'uin nc'atzina chmajo'n nuya' ta rgan tzbuklaj c'aslemal je rc'an. Nc'atzina chka' chk'ij k'ij majo'n npoknaj ta ri' nutaj lowlo' nmal anen y netre' ela chwij. Jara' ajni' jun cruz nya'a tzrij per nmajo'n pkan ta nuna' nuc'am ela cruz, ntelej ela y nba abar necamsas wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Cara' quenbij chewa com nak wnak npoknaj nuya' cana rc'aslemal jara' ntz'ila' rc'aslemal je rxin junlic. Per nak wnak majo'n npoknaj ta nuya' cana rc'aslemal nmal anen jara' majo'n ntz'ila' ta rc'aslemal. ");
INSERT INTO tzjE_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Com ajni' tzra jun wnak ¿nak nuch'ec tzrij wxuch'ec njelal mibil rxin rwech ruch'lew per we xtz'ila' rc'aslemal y majo'n xuwil ta utzlaj c'aslemal je rxin junlic? ");
INSERT INTO tzjE_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Cara' quenbij chewa com je' wnak chka bechnak wnak opech we xq'uixbal nquena' nquetre' ta chwij y we xq'uixbal nquena' chka' rmal ntzojbal, anen chka' q'uixbal quenna' che xtquetre ta chwij. Anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak q'uixbal quenna' xtquetre' ta chwij tak xtenpet chic jmul y tak congan nim chic nuk'ij tzra' tak xtenpeta pnegloria, pregloria Ttixel y pregloria e santlaj tak ángel. ");
INSERT INTO tzjE_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ne ktzij wa' je xtenbij chewa ra, ec'ola chewa jec'ola wawe' camic ra ec'as na tak xtquetz'et rgobierno Dios. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","C'ola waxki' k'ij rbin jawra jle' tzij ra tak xba pe rwá' jun jyu' chnerebna' oración e rexbil Pedro, Jacobo ruq'uin Juan. ");
INSERT INTO tzjE_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kas remjon oración tak xuq'uex ri' ruplaj y retziak kas sak xela, congan nc'ac'ota. ");
INSERT INTO tzjE_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chek q'uenjlal xewanker ta e c-e' ach-i', xquemaj tzij ruq'uin, jun Moisés y jun chic Elías. ");
INSERT INTO tzjE_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ja' Moisés ruq'uin Elías arj-e' congan chic ruch'ab regloria Dios chquij, quemjon tzij tzrij recmic Jesús com ja' Jesús nba pJerusalén y tzra' nerejcha' wa' ri' pe cmic. ");
INSERT INTO tzjE_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro arja' congan majtanak rmal wram y cara' chca rexbil chka' per xquecoch'. Xquetz'et regloria Jesús y xequetz'et e c-e' ach-i' chka' jec'ola ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kas benam nqueban ela je c-e' ach-i', ja' Pedro cawra xbij tzra Jesús: —Maestro, congan qui'il okc'ola wawe' ra. Kabna' oxi' tak jay wawe' ra, jun awxin atet, jun rxin Moisés y jun rxin Elías, cara' xbij tzra. Per ja' Pedro majo'n xuch'ob ta je xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","C'remjon na tzij Pedro tak c'ola jle' sutz' xermujaj y xkaja chquij. Je oxi' apóstol congan xecxibej qui' tak xquetz'et che ec'ol chic chpam sutz'. ");
INSERT INTO tzjE_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","C'ol c'a jun kul xtzijon ta chpam sutz', cawra xbij: —Ja c'a wa' quilaj Wlec'wal, tey-a' ewexquin tzrij nak nbij chewa, cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tak xec'choja tzij rmal kul, j-e' apóstol xquetz'et che e majo'n chic Elías ruq'uin Moisés, xruyon chic Jesús c'o cana. Njelal jawra je xquetz'et xe ptak canm xquec'ol wa', q'uiylaj tiemp xqueyic, nmajo'n abar xecbij wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jche rcab k'ij tak xemloj ta Jesús pe rwá' jyu' congan e q'uiy wnak xeba che rc'ulic. ");
INSERT INTO tzjE_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","C'ol c'a jun acha chquecjol cow ntzijona y cawra xbij: —Maestro, tebna' jun utzil, anen c'ola jun wlec'wal je njun oca, tetz'ta' pka jtz'it. ");
INSERT INTO tzjE_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","C'ola jun itzel espíritu nechpowa rxin y chek q'uenjlal numaj rakic ruchi'. C'ola ataque nya'a tzra y congan rupluw nela pruchi'. Congan ncamsasa ptak ulew, nmesquier nsak'pixa rmal itzel espíritu. ");
INSERT INTO tzjE_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Xenc'utuj jun utzil chca adiscípulo che nquelsaj ela itzel espíritu per j-e' majo'n xecwin ta xquelsaj ela, cara' xbij ja' acha. ");
INSERT INTO tzjE_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tak xc'axtaja rmal Jesús je xbixa tzra rmal acha cawra xbij ra: —Ixix je ix tnamet Israel, ntak majo'n yukbal ec'u'x wq'uin, ntak yojtanak ena'oj. Ajru' la tiemp enc'ola checjol y congan quenbisona com mesquier neyke'a ec'u'x wq'uin, cara' xbij chca. C'jara' xbij tzra ttixel: —Camic tec'ma' ta awlec'wal wq'uin, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ja' ala' xyamer nekaja chwech Jesús tak xya'a jun ataque tzra rmal itzel espíritu y xch'akixa penlew rmal. Ja' Jesús xuch'aj pe rwá' itzel espíritu, xuto' ala' pruk'a' y ja' ala' xja'ch cana pruk'a' redta' rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Conjelal wnak congan xel ta canm tzrij je xquetz'et jnimlaj rpoder Dios jc'ola pruk'a' Jesús. Ja' Jesús kas majtanak rtzojxic cmal conjelal wnak tzrij je njelal nuban tak cawra xbij chca rdiscípulo: ");
INSERT INTO tzjE_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Kas toca chpam ewexquin je xtenbij chewa ra. Je Rlec'walxel jxoca alxic cuq'uin wnak arja' nja'ch na pquek'a' wnak, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Per arj-e' majo'n xch'obtaj ta cmal je xbixa chca, xwiwan chquewech ch-utz c'ara' me tch'obtaja cmal nak rbanic. Per arj-e' xnecxibej qui' necc'axaj tzra achnak rbanic. ");
INSERT INTO tzjE_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","C'jara' xquemaj rij che necch'ojquij chbil tak qui' nak más nim ruk'ij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Per Jesús bien rutkin nak quemjon rch'obic ptak canm. C'ol c'a jun ch'tac'al xuc'om pona y xuya' prexquin. ");
INSERT INTO tzjE_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Cawra xbij chca ra: —Jawra ac'al ra nak jun xtec'luwa rxin y pnubi' anen nuc'ul wa', nbij tzij ra che anen xenruc'ul. Y nak xtec'luwa wxin anen nbij tzij ra che Nedta' Dios xuc'ul chka' jtakyon pa wxin. Cara' quenbij chewa com wc'ola jun checjol majo'n nuya' kta ruk'ij ruyon jara' más chna nim ruk'ij chewech. Cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","C'jara' cawra xbixa tzra rmal Juan: —Maestro, ajoj c'ola jun acha xkatz'et pnabi' atet nquerelsaj wa' itzel tak espíritu pcanm wnak per com mkaxbil ta rmal c'ara' ajoj xekbij tzra: —Mtque'awsaj chta, cara' xekbij tzra, cara' xbixa tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","—Mtek'il xta acha com jun wnak chka bechnak wnak opech wmajo'n itzel ta nokrutz'et jara' kexbil, cara' xbij tzra Juan. ");
INSERT INTO tzjE_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ja' Jesús tak xyamer nerkaja k'ij tak xtec'mar ela chcaj arja' xujic ela che nba pJerusalén. ");
INSERT INTO tzjE_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ec'ol c'a jle' rexbil xerutak ela che nquenabyej ela chwech, arj-e' xeba chpam jun aldea cxin aj Samaria che necchomij pona je nc'atzina tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Per je' wnak jec'ola chpam aldea arj-e' majo'n xquec'ul ta Jesús com ja' rech'bon pJerusalén nba wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Je c-e' discípulo Jacobo ruq'uin Juan tak xquetz'et che me xc'u'l ta cmal wnak cawra xecbij tzra Jesús: —Kajaw ¿mex nawajo' nekc'utuj k'ak' rxin chcaj ajni' xuban ojer profeta Elías ch-utz c'ara' nquerec'sa' conjelal j-ela wnak? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ja' Jesús xuya' volt y xumaj rch'ajic pquewá': —Ixix mtch'obtaja ewmal ajni' rna'oj Espíritu jc'ayona ewxin. ");
INSERT INTO tzjE_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Cara' quenbij chewa com anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak me enpenak ta che ccamsic wnak, enpenak che cto'ic, cara' nbij chca. C'jara' xeba chic pjun aldea. ");
INSERT INTO tzjE_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kas quechpon chic quebey tak c'ola jun acha xpeta y cawra xbij tzra Jesús: —Wajaw, quenba chawij xabar tzra' opech ncatba wa', cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Cawra xbixa tzra rmal Jesús: —Je' utiwa' c'ola cc'olibal abar nquewar wa', chka' ch'tak tz'quin c'ola quesoc, per anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak majo'n wuchoch nte wxin anen abar quenwar wa', cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","C'o chic jun cawra xbixa tzra rmal Jesús: —Jo' catetre' ta chwij, catoca ndiscípulo, cara' xbij tzra. —Wajaw, tey-a' c'as chwa che cnemku' cana nedta' nabey mul, cara' xbij ja' acha. ");
INSERT INTO tzjE_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","—Je cnomki' chwech Dios arj-e' nquemuk kaja je' qui' queyon. Atet jat cuq'uin wnak, ay-a' rbixic rgobierno Dios chca, cara' xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","C'o chic jun acha cawra xbij tzra Jesús ra: —Wajaw, anen quenwajo' quentre' ela chawij che quenoca adiscípulo per tey-a' c'as chwa che cnebij cana nubi' chca jec'ola pwuchoch, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","—Jun ajchental mwen ta nela wremjon chic rij samaj y xe tzrij nca'y can wa', y cara' tzra jun wnak chka' chka bechnak wnak opech wxe tzrij nca'y can wa' jara' me tkal ta tzrij chnesmaja precwent rgobierno Dios, cara' xbixa tzra acha rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","C'jara' Kajaw Jesús ec'ol chic e setenta ach-i' xerucha', pcaca' xerutak ela, nquenabyeja chwech, nqueba chpam njel tak tnamet y chpam jle' chic lwar jabar xtekaj wa' ja'. ");
INSERT INTO tzjE_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Cawra xbij ela chca ra: —Ne ktzij wa' je xtenbij chewa, je' wnak e ajni' jun nimlaj tejco'n congan chic e k'an, utz chic nch'u'pa, per je e ajsmajma' je nquebnowa cosechar cxin xme q'uiy ta. Rmal c'ara' quenbij chewa, tebna' orar, tc'utuj tzra Rajaw csech che nquerutak ta ajsmajma' che necrebna' cosechar wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Camic tec'ma' ela bey, bien twutkij ela che ixix ix ajni' jle' carne'l y je' wnak jabar quixnutak el wa' arj-e' e ajni' utiwa'. ");
INSERT INTO tzjE_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mtec'om el ta epak, majo'n nec'om el ta emalet, nexte exjab chka'. Tak emjon rij jawra viaje majo'n nquixpe' ta cuq'uin wnak che nque'ek'ijla' tak nec'ul ewi' cuq'uin pbey. ");
INSERT INTO tzjE_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tak nquixoca chpam jun jay, tak nek'ijla' jun wnak cawra nebij chca nabey mul: —Qui'il tec'je'a rwech ewanm chwech Dios pnewuchoch, cara' tbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wc'ola jun wnak chpam jay wen ec'ulic nuban jara' qui'il nec'je'a rwech ranm chwech Dios pruchoch, owe mcara' ta nuban chewa jara' majo'n qui'il ta nec'je'a. ");
INSERT INTO tzjE_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jay jabar nquixc'u'l wa' tzra' nquixec'je' wa' ajru' kas tiemp xtquixec'je'a chpam tnamet. Tetja' jnecsipaj chewa com yatanak chewa che nquixtzu'ka ajni' tzra jun ajsmajma' yatanak tzra che nto'ja. Mchek tquixela nquixoca chi' tak jay che rconxic ewuchoch abar nquixec'je' wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tak nquixoca chpam jun tnamet chka bechnak opech tnamet, we qui'il ec'ulic nba'na tetja' je nsipasa chewa. ");
INSERT INTO tzjE_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Que'echumsaj yuw-i' jec'ola chpam tnamet y cawra nebij chca wnak ra: —Je rgobierno Dios xchenkaj chic c'o pwá' ewq'uin, cara' tbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wmajo'n nquixc'u'l ta quixel ta pbey y cawra nebij chca wnak: ");
INSERT INTO tzjE_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","—Je pkok rxin etnamet jc'ola pe kkan, camic nekquiraj cana jara' rital che netaj na lowlo' rmal jmajo'n egan newc'axaj jnekbij chewa, per twutkij che rgobierno Dios xyamer nerkaja ewq'uin, cara' tbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Camic quenbij chewa, tak xterla' nimlaj k'ij rxin juicio congan lowlo' tzra tnamet jmajo'n xtquixquec'ul ta, más na lowlo' xtquetaj que chwech ajni' xtquetaj aj Sodoma, cara' xbij Jesús chca e setenta rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","C'jara' xumaj chic rij tzij, cawra xbij chca jle' tnamet ra: —Congan lowlo' chewa ixix je ix tnamet Corazín y congan lowlo' chewa ixix chka' je ix tnamet Betsaida. Cara' quenbij chewa com congan nmak tak milagro xenban chewech per majo'n xeq'uex ta ena'oj. Je nmak tak milagro xenban chewech wexte xba'na chquewech je e itzel tak wnak je aj Tiro ruq'uin aj Sidón ojer, arj-e' xqueq'uex ta cna'oj y xqueya' can ta je' rtzilal jquemjon rij, xqueban ta je' achnak che necc'utbej chcongan nti'ona canm rmal rtzilal jquebnon chpam cc'aslemal. ");
INSERT INTO tzjE_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Per tak xterla' nimlaj k'ij rxin juicio más chna nim jlowlo' xtetaj ixix que chwech ajni' xtquetaj aj Tiro ruq'uin aj Sidón. ");
INSERT INTO tzjE_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ixix chka' je ix tnamet Capernaum, jnech'ob ixix che nquixba chcaj y congan nya'a ek'ij per je nba'na chewa, xe nquixkasasa. Jabar ec'o wa' cnomki' q'ue tzra' nquixkasas wa', cara' xbij chca tnamet. ");
INSERT INTO tzjE_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Xumaj chic jmul tzij Jesús cuq'uin e setenta discípulo: —Je' wnak je nquenimana je xtenbij chca, anen c'ara' quencnimaj. Je' wnak jmajo'n xtquixquec'ul ta, anen c'ara' jmajo'n quenquec'ul ta, y je' wnak jmajo'n quenquec'ul ta Nedta' c'ara' jtakyon pa wxin je mtquec'ul. Cara' xbij ela Jesús chca e setenta discípulo, y xeba xequebna' je xbix ela chca. ");
INSERT INTO tzjE_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tak xemloj ta congan nquequicota xe'erkaja ruq'uin Jesús y cawra xecbij tzra: —Kajaw, jitzel tak espíritu tak xekbij chca che pnabi' atet nque'el wa' xokcnimaj, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús cawra xbij chca: —Anen xentz'et Satanás xkasas ta chcaj cara' ajni' jun queypa'. ");
INSERT INTO tzjE_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Bien tewc'axaj je xtenbij chewa ra, anen camic quenya' chewa poder che nquixbina chquij cmetz, che nque'epak' je' xca', y majo'n achnak nqueban chewa. Chka' nquixecwina nekasaj njelal poder jc'ola pruk'a' Satanás. Nmajo'n nak xtebnowa lowlo' chewa. ");
INSERT INTO tzjE_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Camic je' itzel tak espíritu nquixcnimaj per me mtquixquicota rmal jara'. Quixquicota per rmal jtz'ibtanak ebi' chcaj. ");
INSERT INTO tzjE_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Njara' hor congan jun nimlaj quicotemal xwankera pranm rmal Espíritu Santo y xumaj tzij ruq'uin Ttixel jc'ola chcaj y cawra xbij tzra: —Nedta', atet at Rajaw caj ruq'uin rwech ruch'lew, ajni'la quenmeltioxij chawa com je' wnak je nquech'ob kaja ptak canm chcongan achnak cutkin y congan cna'oj, me chquewech ta arj-e' ak'alsan wa' nak rbanic njelal jawra jnemjon rbanic y njelal jnemjon rbixic, per ak'alsan wa' chquewech j-era' wnak jquebnon e ch'tak cocoj chawech. Cara' abnon chca Nedta' com cara' nawajo' atet, cara' xbij Jesús tzra Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","C'jara' cawra xbij chic: —Nmajo'n achnak mquita jchon pnuk'a' rmal Nedta'. Nmajo'n jun ojtakyona kas mer rna'oj Rlec'walxel, ruyon oca Dios jTtixel ojtakyona. Chka' nmajo'n jun ojtakyona kas mer rna'oj Ttixel per nuyon oca anen ja en Rlec'walxel enojtakyona, y chka' jenech-on chquenk'alsaj chquewech arj-e' cutkin chka', cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","C'jara' xumaj tzij cuq'uin rdiscípulo per xqueyon, cawra xbij chca: —Ixix congan quicotemal chewa rmal jemjon rtz'etic ruq'uin ek'awech. ");
INSERT INTO tzjE_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Anen quenbij chewa che e q'uiy e ojer tak profeta y e q'uiy e ojer tak rey congan xecyarij xquetz'et ta ajni' emjon rtz'etic ixix camic y congan xecyarij xecc'axaj ta chka' ajni' newc'axaj ixix camic, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","C'ol c'a jun acha xpeta, jun chca maestro je nquetijona cxin wnak tzrij rley Dios. Jara' acha nyarij nuban probar Jesús rmal c'ara' tak cawra xbij tzra: —Maestro ¿nak quenban ch-utz c'ara' nyataja chwa utzlaj c'aslemal je rxin junlic? cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","—Tbij chwa ¿nak tz'ibtanak cana chpam rley Dios? ¿Nak nawsaj tzrij atet? cara' xbixa tzra acha. ");
INSERT INTO tzjE_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","—Cawra nbij ra: —Twaj-o' Awajaw Dios per ne njelal ac'u'x twaj-o', ne njelal awanm y ne njelal achuk'a' y tzra njelal ana'oj twaj-o'. Ajni' nawajo' kaja awi' ayon cara' c'a tebna' chca aprójimo, que'awaj-o' chka'. Cara' nbij, cara' xbij ja' acha. ");
INSERT INTO tzjE_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Ne ktzij wa' nabij. We xtaban cumplir jley jxabij kaja jara' nyataja chawa utzlaj c'aslemal je rxin junlic, cara' xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ja' acha nrajo' nuto' ri' rmal c'ara' cawra xbij chic tzra Jesús: —Per ¿e achnak c'ara' neprójimo? cara' xc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ja' Jesús xumaj rbixic jun c'ambal tzij y cawra xbij tzra ra: —Xuban jmul jun acha xel ela pJerusalén, xexle'a chpam tnamet Jericó. Ec'ol jle' elk'oma' xquechap acha, xquelk'aj ela njelal achnak jc'ola ruq'uin, xquech'ay cana y xecpunba' cana pbey, xatra xeccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","C'ol c'a jun sacerdote penak chbey. Ja' sacerdote tak xutz'et acha pnula pbey xutzol rubey, majo'n xk'ax ta ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Xpet chic jun ajsmajma' rxin Dios, levita nbixa tzra. Ja' aj levita tak xerkaja chpam lwar xutz'et acha y xutzol rubey chka', majo'n xk'ax ta ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Per c'ola jun acha aj Samaria remjon rij viaje y xerkaja chpam jara' lwar. Tak xutz'et pona acha congan xpoknaj rwech, ");
INSERT INTO tzjE_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","xba ruq'uin. Tak xekaja ruq'uin c'ola nic'aj aceite rexbil vino xuya' chwech jabar cuynak wa' che nk'ombej. Tak xk'omtaja rmal c'jara' xuxim jabar cuytanak wa'. C'ola ruquiej rec'mon ta, xtz'uba' ela acha tzrij, xuc'om ela chpam jun pensión, bien xuban cwent. ");
INSERT INTO tzjE_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jche rcab k'ij ja' aj Samaria benam nuban, xelsaj rpak rjel c-e' k'ij samaj y xutoj cana pruk'a' rajaw pensión, cawra xbij tzra: —Tebna' jlal cwent jawra acha, tey-a' tzra achnak nc'atzina tzra. Tak xtquemloj pa anen quenretjo' njelal ruc'as awq'uin, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tak xbitaja c'ambal tzij rmal Jesús cawra xc'axaj chic tzra jmaestro: —Camic tbij chwa, jchawa atet ¿nak chca j-ewra e oxi' ach-i' xoca reprójimo acha je xcha'pa cmal elk'oma'? cara' xc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Jara' je xpoknana rwech, cara' xbixa tzra rmal maestro. —Camic jat abna' atet cara' ajni' xuban aj Samaria, cara' xbij ja' Jesús tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","C'jara' xumaj chic rubey, xekaja pjun aldea. Tzra' c'o wa' jun ixak, Marta rubi', ja' xec'luwa rxin pruchoch. ");
INSERT INTO tzjE_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ja' Marta c'ola jun ruchak' María rubi'. Ja' María xetz'be' oca chwech Jesús y xumaj rc'axic njelal tijonem jnuya'. ");
INSERT INTO tzjE_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Per Marta congan nk'aysaj ri' che rbanic samaj rxin pjay rmal c'ara' tak xba ruq'uin Jesús y cawra xbij tzra ra: —Wajaw ¿l-utz c'ara' jnuchak' nmajo'n cas rey-on tzra samaj y xnuyon enrpaban chwech? Tbij pka jlal tzra chquenruto', cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","—Marta, atet q'uiy je' rwech amjon rbanic y congan nak'aysaj awi' tzrij y nti'ona awanm rmal chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Per c'ola jun más na nc'atzina chawa chnaban y ja' María más na k'axnak wen nuban camic, nmajo'n nak ta xtelsana tzra jtijonem je nc'axaj, cara' xbixa tzra Marta rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Xuban jmul Jesús c'ola chpam jun lwar, remjon rbanic oración. Tak xec'choja oración rmal xpeta jun chca rdiscípulo y cawra xbij: —Wajaw, ko'atijoj tzrij rbanic oración ajni' xuban Juan Bautista xertijoj je' rdiscípulo, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús cawra xbij chca: —Tak neban oración cawra nebij ra: —Kadta' Dios atc'ola chcaj, lok' ta xtna'a abi'. Xtkaj pta agobierno wawe' chwech ruch'lew, xtnimax ta je nrajo' awanm atet wawe' ajni' nba'na chcaj nnimaxa. ");
INSERT INTO tzjE_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","K'ij k'ij xtaya' ta kaway je nc'atzina chka. ");
INSERT INTO tzjE_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tecyu' kil kamac ajni' nkaban ajoj nquekacuy wnak tak c'ola lowlo' nqueban chka. Atet ta xtcatc'ana kxin, mquita xtokkaja tak nokrchajtij itzel wnak, ko'at-o' pruk'a'. Cara' ta rbanic oración neban, cara' xbij chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","C'jara' cawra xbij chic chca: —C'o ta jun chewa nba ta ruq'uin jun ramigo pe nc'aj ak'a' y cawra nerbij tzra: —Wamigo, mex c'ola xquelway awq'uin tey-a' oxi' rkan wxin per quenya' rec'xel. ");
INSERT INTO tzjE_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Xc'ola jun wamigo c'xerkaja wq'uin, penak pe viaje y nmajo'n achnak quenya' tzra, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Cawra nbij ta ramigo pjay: —Me cnaban ta molestar com ntz'apin chic chijay, okoctz'el chic cuq'uin ch'tak wlec'wal. Mesquier quencwina quenyictaja, mesquier quencwina quenya' jnac'utuj chwa, cara' nbij ta ja' acha, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","C'jara' xbij chic chca: —Camic quenbij chewa, ja' acha we chek carat nc'utuj oca xquelway y majo'n ntenba' ta rc'utxic jara' nyictaja ramigo y nuya' tzra njelal je nc'atzina tzra, per me rmal ta che camigo qui' ruq'uin tak nuya' per xe rmal majo'n ntenba' ta rc'utxic, rmal c'ara' nuya' na. ");
INSERT INTO tzjE_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Rmal c'ara' tak quenbij chewa, tc'utuj tzra Dios je nc'atzina chewa y ja' nuya' chewa, tcanoj jnewajo' y newil, ttarij chijay y nja'ka chewech. ");
INSERT INTO tzjE_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Cara' quenbij chewa com conjelal je nquec'utuna nyataja chca y je nquecanona nyataja chca che nquewil y je nquetarina chijay nja'ka chquewech. ");
INSERT INTO tzjE_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","O ¿c'ol c'a jun ttixel tak nc'utuxa jun xquelway tzra rmal jun ch'it rlec'wal y ja' nuya' jun abaj pruk'a'? Owe nc'utuxa jun ch'u' tzra ¿lnuya' jun cmetz tzra? ");
INSERT INTO tzjE_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Owe nc'utuxa jun samulo' tzra ¿lnuya' jun xca' tzra? ");
INSERT INTO tzjE_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ixix mesque ix lowlo' per ewutkin neya' utzlaj tak achnak chca ewlec'wal, peor c'ara' Edta' jc'ola chcaj arja' nuya' Espíritu Santo chca je nquec'utuna tzra. Cara' xbij Jesús chca rdiscípulo tzrij oración. ");
INSERT INTO tzjE_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","C'ol c'a jun acha ocnak mem rmal jun itzel espíritu. Ja' Jesús ntajina nelsaj itzel espíritu pranm acha. Tak xlastaja rmal njara' hor xumaj tzij ja' acha. Je' wnak congan xel ta quec'u'x tak xquetz'et. ");
INSERT INTO tzjE_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Per ec'ola jle' cawra xecbij ra: —Xe rpoder Beelzebú je cjefe itzel tak espíritu xjara' recsan che clasic itzel espíritu, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ec'o chic jle' xjic nqueban probar y cawra necbij tzra: —Tebna' jun milagro jnuc'ut chkawech che Dios yoyona chawa jpoder c'ola pnak'a', cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Per Jesús bien rutkin jquemjon rch'obic y cawra xbij chca: —Jun gobierno chka bechnak gobierno opech, wex división nuban chbil ri' jara' xe nyojtaja. Y cara' chca jle' wnak chka' jec'ola pjun jay, wex división nqueban chbil tak qui' jara' xe nqueq'uisa. ");
INSERT INTO tzjE_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Y cara' c'a tzra Satanás chka', wex división nuban cuq'uin rdemonio ¿le mtq'uis c'ara' rgobierno? Cara' quenbij chewa com ixix nebij chwa che rpoder Beelzebú necsan che clasic je' demonio. ");
INSERT INTO tzjE_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Wex rpoder Beelzebú necsan anen tak quenelsaj itzel espíritu ¿nak nebij chca ediscípulo ixix? Com arj-e' nquequelsaj itzel espíritu chka' ¿le rpoder Beelzebú nquecsaj nech'ob ixix? Ediscípulo ixix nquek'alsana che me ktzij ta xebij chwa. ");
INSERT INTO tzjE_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Anen rpoder Dios quencsaj tak quenelsaj itzel tak espíritu, wcara' quenban nbij tzij c'ara' che rgobierno Dios kanak ta checjol. ");
INSERT INTO tzjE_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tak c'ola jun acha congan rchuk'a' remjon rechjalbxic ruchoch y c'ola je' achnak rxin banbal ch'oj ruq'uin jara' congan pen xtelsas ta je'a achnak jc'ola ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Per tak npeta jun acha más chna rchuk'a' y nuch'ec jara' acha je rjawal jay, jara' numaj tzra njelal achnak rxin banbal ch'oj jabar ykul wa' ruc'u'x, nelsaj tzra jc'ola ruq'uin y numaj rjachic chca rexbil. ");
INSERT INTO tzjE_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Je' wnak je e majo'n wq'uin jara' xruq'uin Satanás ec'o wa' je ntzelana wxin. Chka' jmajo'n quenqueto' ta che cmolic wnak jara' xe nquecchicaj ela. ");
INSERT INTO tzjE_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jun itzel espíritu tak nel ela pranm jun acha arja' nba ptak lwar abar majo'n wa' ya' y nercanoj jun lwar abar nexle'n wa', per mtuwil lwar y cawra nbij ra: —Quenmloj chna jmul chpam wuchoch jabar enelnak twa' nabey, cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tak nekaj chic jmul ruq'uin acha nutz'et ranm ajni' jun jay josk'in rpam y kas wen rwekic bnon. ");
INSERT INTO tzjE_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","C'jara' nemloj pchic jmul, nquerec'ma' el chic e wku' e itzel tak espíritu y e más chna e lowlo' que chwech ja'. Tak nque'erkaja ruq'uin acha nque'oca pranm che waxki' y tzra' nquec'je' wa'. Rmal c'ara' más chna lowlo' rc'aslemal acha nela que chwech nabey. ");
INSERT INTO tzjE_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kas remjon rbixic jawra tzij ra tak c'ola jun ixak chquecjol wnak cawra xbij tzra ra: —Ajni'la quicotemal tzra ate' je xq'uetzin ta awxin, cara' xbij tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Per Jesús cawra xbij tzra ra: —Más na quicotemal chca wnak je nquec'axana rtzojbal Dios y nqueban cumplir je nbij chca che nqueban, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tak congan e q'uiy wnak quemlon chic qui' tzrij xumaj tzij cuq'uin y cawra xbij chca: —Je' wnak je e rxin jawra tiemp jokc'o wa' xe e itzel tak wnak. Arj-e' necc'utuj chwa chquenban jun milagro ch-utz c'ara' quencnimaj. Per jmilagro jnecc'utuj majo'n quenban ta chquewech xerwara' c'ola jun milagro nbantaj na chquewech, jun milagro ajni' xk'ax pa chpam ojer profeta Jonás. ");
INSERT INTO tzjE_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ajni' xuban Jonás ojer arja' xoca rital chquewech wnak jec'ola chpam tnamet Nínive y cara' c'a chwa anen chka' ja en Rlec'walxel jxenoca alxic cuq'uin wnak, quenoc na rital chquewech wnak jec'ola chpam jawra tiemp jokc'o wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tak xterla' nimlaj k'ij rxin juicio, ixak jreina rxin nación jc'ola psur arja' xtyictaj ta ix rexbil ixix je ix tnamet Israel y arja' noca k'toy tzij chewij. Cara' quenbij chewa com jara' ixak q'ue c'nat npe wa' che rc'axic rna'oj Dios jyatanak tzra ojer rey Salomón. Y camic quenbij chewa, anen más chna nim nuk'ij que chwech Salomón. ");
INSERT INTO tzjE_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tak xterla' nimlaj k'ij rxin juicio je' ach-i' jec'ola chpam tnamet Nínive ojer arj-e' xtqueyictaj ta ix quexbil je ix tnamet Israel y arj-e' nque'oca e k'toy tzij chewij. Cara' quenbij chewa com aj Nínive arj-e' tak xecc'axaj rtzojbal Dios je xbixa chca rmal Jonás ojer xq'uextaja cna'oj y xqueya' cana rtzilal. Y camic quenbij chewa, anen más chna nim nuk'ij que chwech Jonás. ");
INSERT INTO tzjE_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nmajo'n jun wnak xtebnow ta xtutzaj ta jun candil y xtwiwaj ta pjun latz' lwar next c'a xtjupba' ta jun cjon pe rwá'. Per je nba'na tzra, tak ntzi'ja jun candil ncanoxa jun rc'olibal jabar nya' wa' ch-utz c'ara' psak nquec'je' wa' wnak jec'ola pjay. ");
INSERT INTO tzjE_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jek'awech cara' rbanic ajni' jun luz ixrey-on psak, wmajo'n achnak rebnon, wmajo'n yojtanak ta, jara' pluz c'o wa' njelal ecuerpo. Per wyojtanak jara' pk'ejku'm c'o wa' ecuerpo. ");
INSERT INTO tzjE_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Rmal c'ara' tak quenbij chewa, tebna' cwent, mtechup ta eluz je y-on chewa ptak ewanm ch-utz c'ara' majo'n nquixec'je' ta pk'ejku'm. ");
INSERT INTO tzjE_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","We pluz c'o wa' njelal abanic y wmajo'n k'ejku'm awc'an jara' nnojsasa luz pnawanm ajni' nuban jun candil ncatruya' psak, cara' nbij Jesús chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tak xec'choja tzij rmal c'ola jun aj fariseo xuban ela invitar Jesús che newa'a ruq'uin. Ja' Jesús tak xekaja chruchoch aj fariseo xoca pjay y xetz'be'a tzrij mes. ");
INSERT INTO tzjE_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Je aj fariseo junwa' xutz'et com Jesús remjon chic w-im per majo'n xuban ta costumbre rxin ch'joj k'baj nabey mul. ");
INSERT INTO tzjE_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ja' Kajaw Jesús cawra xbij tzra: —Ixix je ix aj fariseo ix ajni' jle' plat rexbil jle' vas kas bien ch'ajch'oj rij, per rpam congan lowlo' tz'il. Cara' c'a ebanic ixix com jewanm nojnak rtzilal chpam, congan alak' ebnon. ");
INSERT INTO tzjE_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ix necnak tak wnak. ¿Lmewutkin tc'a che Dios wankersyona ewanm, y mruyon ta ecuerpo rwankersan? ");
INSERT INTO tzjE_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Per je nc'atzina neban, jc'ola ewq'uin jara' que'etobej wnak jc'ola cnecesidad. Wcara' neban jara' kas ch'ajch'oj nela ecuerpo ruq'uin ewanm chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Congan lowlo' chewa ixix je ix aj fariseo com ixix congan necsaj echuk'a' che rya'ic eprimicia per c'o na kas más nc'atzina chneban per jara' majo'n ebnon ta. Congan neyke'a ec'u'x chneya' eprimicia, neya' njelal rwech ichaj ajni' menta, ajni' ruda, per majo'n ebnon ta rbeyal rxin Dios y nmajo'n ojben ri'il rxin Dios ptak ewanm. Per jara' más nc'atzina chneban cumplir, y ne nc'atzin wa' chka' che mtetenba' ta rya'ic eprimicia. ");
INSERT INTO tzjE_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Congan lowlo' chewa ixix je ix aj fariseo com ixix tak nquixba chpam jay rxin molbal ri'il jabar nc'axax wa' rtzojbal Dios xe tzrij tz'ulbal je nmak ruk'ij nel twa' ec'u'x. Chka' tak nquixbina ptak q'uebal congan nel ta ec'u'x tzrij tak nquixk'ijloxa. ");
INSERT INTO tzjE_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Congan lowlo' chewa ixix je ix maestro rxin ley y chewa ixix je ix fariseo, caca' eplaj com ix junam ruq'uin ulew abar emkun wa' cnomki', per jun ulew jmajo'n k'alaj xta chc'ola jun comnak chuxe', y rmal c'ara' tak je' wnak nquek'axa pe rwá' julew majo'n necnabej che pe rwá' jun comnak nquek'ax wa'. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","C'ol c'a chca jun maestro je rxin rley Dios cawra xbij tzra Jesús: —Maestro, jtzij jxabij kaja congan itzel chka ajoj chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ja' Jesús cawra xbij chic ra: —Congan lowlo' chewa ixix chka' je ix maestro rxin rley Dios com jtijonem jneya' ncara' ajni' nmak tak ejka'n neya' chquij wnak jcongan pen rejkxic per ixix nmajo'n nechap ta jtz'it ejka'n tzra rwá' tak ek'a'. ");
INSERT INTO tzjE_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Congan lowlo' chewa ixix com kas wen rbanic cpanteón e ojer tak profeta rxin Dios neban per xe ewti't ewma' xecamsana cxin y xjunam ena'oj cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tak cara' neban jara' bien k'alaj che ix conform ruq'uin je xqueban ewti't ewma' ojer com arj-e' xecamsana cxin profeta y ixix nquixebnowa rbanic cpanteón. ");
INSERT INTO tzjE_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Rmal c'ara' tak cawra rbin cana Dios ojer: —Cuq'uin wnak ec'ola jle' profeta quenutak ela e quexbil jle' apóstol. J-e' profeta ruq'uin apóstol jle' chca nquecamsasa cmal wnak y jle' nquesalux ela. Cara' xbij Dios je ojtakyona njelal. ");
INSERT INTO tzjE_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Cara' xbantaja ch-utz c'ara' chewij ixix jix tnamet Israel nkaj wa' rtojic jquecmic conjelal profeta jecamsan ta chwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Jnabey mul jxecamsasa jara' Abel, y je xq'uisbena jara' tak xcamsasa Zacarías. Checjol templo y ruq'uin altar, tzra' xcamsas wa' Zacarías. Rmal c'ara' quenbij chewa, je' wnak jec'ola chpam jawra tiemp jokc'o wa', chquij j-e' nkaj wa' rtojic jquecmic conjelal profeta. ");
INSERT INTO tzjE_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Congan lowlo' chewa ixix je ix maestro rxin rley Dios jtz'ibtanak cana rmal Moisés com ixix etz'apin quebey wnak chquewech ch-utz c'ara' mtcutkij nak kas mer rbanic rtzojbal Dios. Majo'n ewutkin ta ixix nak kas mer rbanic y nexte neya' c'as chca wnak je ncajo' ncutkij, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tak xbitaja njelal jawra tzij rmal, je' maestro rxin ley e quexbil aj fariseo arj-e' xeyictaja tzrij. Congan xquemaj rc'otic ruchi', ");
INSERT INTO tzjE_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","jara' necbanbej probar rxin com neccanoj rij rwech nak nqueban tzra che nquechap. ");
INSERT INTO tzjE_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ec'ola wnak quemlon qui' tzra' per ne ajru' la mil, ncongan nquemin je' qui'. Ja' Jesús xumaj tzij cuq'uin rdiscípulo nabey mul y cawra xbij chca ra: —Tebna' cwent ewi' chwech levadura cxin aj fariseo. Jara' nbij tzij mteban ta caca' eplaj com e ajni' j-e'. ");
INSERT INTO tzjE_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Cara' quenbij chewa com njelal jmajo'n k'aljennak ta jara' nerla' na jun k'ij tak xtek'aljina y njelal jwewtanak jara' nel na psak, nutkix na. ");
INSERT INTO tzjE_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Rmal c'ara' tak quenbij chewa, chka bechnak je' tzij jebin kaja ptak k'ejku'm nel na rbixic psak. Chka' njelal je' tzij jebin kaja pnejkal ptak ewuchoch nel na rbixic chquewech wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Camic quenbij chewa je ix wamigo, mtexibej ta ewi' chquewech wnak je xruyon ecuerpo nquecwina neccamsaj com tak nquixcamstaja cmal majo'n chic achnak nquecwina nqueban chewa. ");
INSERT INTO tzjE_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Per anen quenbij chewa nak chu chwech nexibej wa' ewi'. Txibej ewi' chwech jnecwina nquercamsaj wnak y tak nquecamstaja rmal necwina nqueruya' pk'ak'. Chwech c'a ja' txibej wa' ewi'. ");
INSERT INTO tzjE_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Je' tz'quin tak nquec'ayixa xe c-e' centavo nya'a chquewech e j-o'. Mesque xe e brat per next jun chca xtemestaj ta rmal Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Y chewa ixix chka' nmajo'n xquixermestaj ta Dios, rejlan chejujnel resmal ewá'. Rmal c'ara' quenbij chewa, mtexibej ta ewi', más nim ek'ij que chquewech e jmoc tz'quin. ");
INSERT INTO tzjE_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Je' wnak chka bechnak je' wnak opech, wmajo'n necpoknaj ta qui' necbij che wq'uin anen ykul wa' quec'u'x per ne chquewech wnak necbij wa', anen chka' ja en Rlec'walxel jxenoca alxic cuq'uin wnak quenbij na chca che e wxin per ne chquewech r-ángel Dios quenbij wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Per wc'ola jun xjunwa' nuna' nbij chquewech wnak che wq'uin anen ykul wa' ruc'u'x, anen chka' quenbij na tzra che me wxin ta per ne chquewech r-ángel Dios xtenbij wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Wc'ola jun wnak chka bechnak wnak opech, we nbij jle' tzij tzra Rlec'walxel jxoca alxic cuq'uin wnak, jle' tzij jxitzel nc'axaxa rmal Dios, jara' c'ola cuytajic tzrij, per we tzra Espíritu Santo xbij wa' jara' majo'n cuytajic tzrij. ");
INSERT INTO tzjE_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Tak xtquixcha'pa cmal wnak, tak xtquixelsas ela ptak jay rxin molbal ri'il y tak nquixquec'om ela chquewech e k'toy tak tzij, mtquixbison ta tzrij nak nebij jnetobej ewi' chquewech ");
INSERT INTO tzjE_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","com Espíritu Santo njara' hor nuya' chewa nak nc'atzina chnebij chca, cara' xbij ja' Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","C'ol c'a jun acha chquecjol wnak cawra xbij tzra Jesús: —Maestro, tbij pka jlal tzra nenmal chnujach wherencia, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","—Acha ¿le en juez anen tak xtquixenchumsaj tzrij ewherencia? cara' xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","C'jara' ja' Jesús cawra xbij chca wnak: —Tebna' cwent ewi', mquita xtquixba'na engañar rmal yarin mibil. Cara' quenbij chewa com nmajo'n jun wnak mesque ncongan mibil ruq'uin per mjara' ta mibil nyowa rc'aslemal, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","C'jara' xbij jun c'ambal tzij chca cawrara: —C'ola jun acha byom, c'ola rulew y congan csech nuya'. ");
INSERT INTO tzjE_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ja' byom cawra xumaj kaja rch'obic pranm: —¿Nak quenban c'a wa'? Com camic majo'n chic abar quenyic wa' necsech, cara' nbij kaja. ");
INSERT INTO tzjE_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tak xch'obtaj kaja rmal cawra xbij chic ra: —Jquenban camic, quenyoj njelal rc'olibal necsech y quenban chic jle' más chna nmak. Tak xtbantaja nmal, chpam quenyic wa' njelal necsech rexbil jle' chic nmibil jc'ola wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tak xtc'oltaja njelal nmal, cawra xtenbij kaja pwanm chic: —Camic congan chic nmibil, jawra q'uiylaj juna' nuban wq'uin. Camic quenxle'n c'a, quenwa'a y pquicotemal quenc'je' wa'. Cara' xtenban c'a, cara' nbij kaja byom pranm. ");
INSERT INTO tzjE_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Per cawra xbixa tzra rmal Dios: —Necnic acha, jawra chak'a' ncatcoma y njelal amibil jac'lon jara' nec'je' cana, cara' xbixa tzra ja' acha. ");
INSERT INTO tzjE_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Cara' rbanic jun wnak tak nec'yersaj rmibil rxin rwech ruch'lew per nmajo'n rmibil Dios ruq'uin. Cara' c'ambal tzij xbij chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","C'jara' xumaj tzij cuq'uin rdiscípulo y cawra xbij chca ra: —Rmal c'ara' tak quenbij chewa, mtek'aysaj ta ewi' tzrij ec'aslemal y xtebij ta ¿nak nkataj c'a wa'? Chka' mtek'aysaj ta ewi' tzrij nak nc'atzina tzra ecuerpo y xtebij ta: —¿Abar nkac'om wa' tziak je nkacsaj chic? Mtebij ta cara'. ");
INSERT INTO tzjE_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ja' Dios nuya' njelal je nc'atzina tzra kc'aslemal ajni' tzra nak nc'atzina tzra kacuerpo. ¿Le mtuya' c'ara' chewa chka' nak netaj y nak necsaj? ");
INSERT INTO tzjE_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","¿Le mque'etz'et c'a je' tz'quin? Arj-e' nmajo'n nara' tejco'n nquetic y nmajo'n nara' je' csech nqueyic ta, per Dios netzkuwa cxin. Per ixix más chna ix vale chquewech e ch'tak tz'quin. ");
INSERT INTO tzjE_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Jun chic, nmajo'n jun chewa mesque ncongan nk'aysaj ri' xtecwin ta ruyon kaja xtuya' jtz'it chic rq'uiybal y xte'l ta nim rkan. ");
INSERT INTO tzjE_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Com mesquier nquixecwina neban jawrara ¿nak tzra c'ara' tak nek'aysaj ewi' tzrij chic nic'aj achnak je nc'atzina chewa? ");
INSERT INTO tzjE_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tewsaj mpa' ena'oj tzrij je' ctz'e'j nak nuban tak nq'uiya per majo'n nesmaj ta, majo'n nk'inon ta. Anen quenbij chewa camic, ojer rey Salomón mesque ncongan rebyomal per majo'n tziak xucsaj ta más ta k'axnak wen rcolor que chwech jle' ctz'e'j ra. ");
INSERT INTO tzjE_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Je' ctz'e'j mesque xe ncoma, mesque xnechkija chanim y nporoxa pk'ak' per Dios nyowa rcolor-il. Wcara' nuban ¿le mtuya' c'ara' chewa chka' je' etziak je nc'atzina chewa? Xerwara' quenbij chewa, majo'n kas ta ykula ec'u'x ruq'uin Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Rmal c'ara' quenbij chewa, mtek'aysaj ta ewi' y xtebij ta ¿nak nkataj c'a wa'? o xtebij ta ¿nak el c'a xtkacsaj chic? Mtebij ta cara'. ");
INSERT INTO tzjE_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Cara' quenbij chewa com je' wnak jmajo'n cutkin ta rwech Dios arj-e' nquebnowa cara'. Je chewa ixix, ja Edta' Dios rutkin bien nak nc'atzina chewa tzrij njelal jawrara. ");
INSERT INTO tzjE_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Per je nc'atzina neban, tzrij ta rgobierno Dios nech'ob wa'. Wcara' neban jara' nyataja chewa njelal je nc'atzina chewa. ");
INSERT INTO tzjE_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ixix ix ajni' jun moc carne'l per mtexibej ta ewi' com Edta' Dios rchumin chic che nquixrecsaj chpam rgobierno. ");
INSERT INTO tzjE_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nak c'ola je' ewq'uin tc'ayij y tsipaj rjel chca mibi'. Wcara' neban jara' nsipasa jun rc'ulibal emibil per nmajo'n nyojtaj ta y c'ola emibil chcaj, per jun mibil je nmajo'n nq'uis ta. Nmajo'n jun elk'om xtoc ta tzra' y nmajo'n jun chcop xtetjow ta jmibil. ");
INSERT INTO tzjE_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Anen xenbij chewa jawra tzij ra com achnak mibil bnak wa' ec'u'x tzrij tzra' c'ara' c'o wa' ewanm chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Quixc'asc'ata y mtechup ta ecandil. ");
INSERT INTO tzjE_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tebna' ixix ajni' nqueban jle' ajsmajma' jqueyben cpatrón je bnak pjun c'ulbic y chek q'uenjlal ner-ula, y tak xtc'ojc'a chijay arj-e' com ec'astanak necjakla' alnak chijay chwech. ");
INSERT INTO tzjE_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Congan quicotemal chca ajsmajma' je nquec'asc'ata che reybxic cpatrón tak xterkaja. Ne ktzij wa' je xtenbij chewa, jpatrón arja' nchumsla' ri' chanim, nquertz'uba' tzrij rmes y numaj quelxic. ");
INSERT INTO tzjE_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wnemloj ta ptak nc'aj ak'a' o pe rsakric congan quicotemal chca we nquec'asc'ata che reybxic. ");
INSERT INTO tzjE_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Per bien tey-a' ewexquin tzrij je xtenbij chewa ra, jun rajaw jay tak nba'na alak' ruq'uin, per wext rutkin nak hor nerkaja elk'om ruq'uin jara' nechjalbej ruchoch, nc'asc'ata y majo'n nuya' ta c'as tzra elk'om che noca pruchoch. ");
INSERT INTO tzjE_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Rmal c'ara' quenbij chewa, ne nc'atzin wa' che nquixc'asc'ata ixix chka' com Rlec'walxel jxoca alxic cuq'uin wnak arja' chek q'uenjlal npet chic jmul chpam jun hor nmajo'n ech'bon ta, cara' xbij ja' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","C'jara' ja' Pedro cawra xbij tzra: —Wajaw ¿le xruyon chka ajoj xabij wa' jc'ambal tzij o xabij chca conjelal? cara' xc'axaj tzra. Ja' Jesús cawra xbij ra: ");
INSERT INTO tzjE_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","—Tech'bo' c'a bien je xtenbij chewa ra: —¿E achnak nquebnowa cumplir je nbixa chca rmal cpatrón, e achnak wen cna'oj? Ajni' tzra jun patrón tak c'ola jun ajsmajma' ruq'uin y nuya' rsamaj che arja' npe'a chquij jle' chic ajsmajma' che nqueruban cwent y nuya' queway tak nc'atzina chca. ");
INSERT INTO tzjE_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jara' ajsmajma' ajni'la quicotemal tzra tak ntajina nuban cumplir rsamaj tak xterkaja rpatrón ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","¿Nak nuban c'ara' rpatrón? Jara' njelal rmibil jc'ola ruq'uin nujach pruk'a' jawra ajsmajma' che arja' npe'a tzrij. ");
INSERT INTO tzjE_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per je ajsmajma' wex cawra nbij kaja pranm: —Nak la k'ij npeta npatrón, y wnumaj cch'ayic je' ajsmajma' quexbil je' aj ic', y xe w-im kas nuya' cas y numaj tjoj ya' y nek'bara, ");
INSERT INTO tzjE_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","y tak cara' ntajina nuban nerla' na jun k'ij tak c'nuna' nerkaja rpatrón y nmajo'n rnaben. Jara' ajsmajma' ajni'la jun nimlaj lowlo' xtutaj pruk'a' rpatrón y nta'k ela chpam lwar jabar ec'o wa' wnak jmajo'n ykul ta quec'u'x ruq'uin Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Je ajsmajma' wrutkin nak njo'xa tzra rmal rpatrón chnuban y nmajo'n nchumsaj ta ri' che rbanic rsamaj y nmajo'n nuban ta je nyarij ranm rpatrón jara' congan jun nimlaj lowlo' nutaj. ");
INSERT INTO tzjE_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Je ajsmajma' jmajo'n rutkin ta nak njo'xa tzra rmal rpatrón chnuban y wnuban je' achnak je xc'ola castigo rec'mon ta jara' majo'n kas ta nim rpoknal nutaj. Tak q'uiy nsipasa chawa rmal Dios jara' q'uiy nc'utuj chawa chka' chnaban. Tak q'uiy nja'cha pnak'a' jara' más chna q'uiy nc'utuxa chawa. ");
INSERT INTO tzjE_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Anen c'ola ajni' jun k'ak' nec'mon ta wawe' chwech ruch'lew, xenpeta che rya'ic jara' k'ak' y quenwajo' remjon xta c'atem camic ra. ");
INSERT INTO tzjE_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Per nabey mul nba'na chwa quenba'na bautizar chpam jun nimlaj lowlo', y kas quenyarij anen k'axnak xta chwij jawra bautismo. ");
INSERT INTO tzjE_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Le xruyon qui'il nquixec'je'a jnec'mon ta wawe' chwech ruch'lew nech'ob ixix? Mcara' ta. Anen quenbij chewa che ec'ola wnak xe nquech'or qui' nmal anen. ");
INSERT INTO tzjE_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cara' quenbij chewa com camic nmal anen nmajtaja división. We j-o' wnak ec'ola chpam jun jay xdivisión xtqueban nmal anen, e oxi' chca xtqueyictaja chquij e c-e' chic, y j-e' e c-e' nqueyictaja chquij e oxi'. ");
INSERT INTO tzjE_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ttixel nyictaja tzrij rlec'wal y ja' alc'walxel nyictaja tzrij redta'. Te'ej nyictaja tzrij ral y ja' xten nyictaja tzrij rute'. Ja' ixak nyictaja tzrij rli' y ja' elbetz nyictaja tzrij rlite'. Cara' xbij Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chka' cawra xbij chca wnak: —Tak c'ola sutz' netz'et je nwankera abar nkaj wa' k'ij nebij chc'ola jab nkaja, y ne ktzij wa' nkaja jab. ");
INSERT INTO tzjE_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Jun chic, tak nkaj ta xecmel nebij chc'ola jun c'ten nuc'om ta, y ne ktzij wa' npeta c'ten. ");
INSERT INTO tzjE_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Caca' eplaj, ixix bien nch'obtaja ewmal nak rec'mon ta jnetz'et chcaj y jnetz'et chwech ruch'lew per ¿nak tzer c'a mesquier nch'obtaja ewmal nak rec'mon ta je ntajina nuban Dios chewech chpam jawra tiemp jokc'o wa'? ");
INSERT INTO tzjE_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Nak tzra tak mtech'ob kaja ixix eyon che rconxic je rbeyal? ");
INSERT INTO tzjE_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Quenbij cara' chewa com más na utz nquixela ruq'uin je nyowa part chewij nechumij ewi' ruq'uin pbey que chwech nquixba pk'atbaltzij. We mcara' ta neban, je nyowa part chewij arja' nquixrujach pruk'a' juez, y ja' juez nquixrujach pquek'a' policía y nquixquecsaj pcars. ");
INSERT INTO tzjE_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Anen quenbij chewa, nmajo'n nquixel ta pcars wmajo'n etjon ta ec'as, per next jun centavo mquita xtetoj cana. Cara' xbij Jesús chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ec'ol c'a jle' wnak tzra' arj-e' xquemaj rcholic chwech Jesús je xqueban jle' ach-i' aj Galilea je xecamsasa rmal gobernador Pilato. Jquecq'uiel jara' ach-i' xerejyu' ri' ruq'uin quecq'uiel jle' chcop je rxin sacrificio je nquetajina nquetzujuxa chwech Dios cmal ach-i'. ");
INSERT INTO tzjE_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ja' Jesús tak xc'axaj jawra tzij cawra xbij chca ra: —Je aj Galilea jxecomsasa ¿le e más na aj-il ajmac chquewech jle' chic aj Galilea nech'ob ixix tak xba'na cara' chca? ");
INSERT INTO tzjE_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mcara' ta. Tetz'ta' mpa' ec'aslemal ixix, we mteq'uex ena'oj, we mteya' cana rtzilal jara' cmic nesiq'uij chewij chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Jun chic, terkaja pnewá' e dieciocho wnak je xtzaka torre rxin Siloé chquij y xercamsaj. ¿Le más na aj-il ajmac chquewech jle' chic wnak jec'ola tzra' pJerusalén nech'ob ixix? ");
INSERT INTO tzjE_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mcara' ta. Tetz'ta' mpa' ec'aslemal ixix chka', we mteq'uex ena'oj, we mteya' cana rtzilal jara' cmic nesiq'uij chewij chka', cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","C'ola jun c'ambal tzij xbij chka' cawrara: —C'ola jun acha c'ola jun mcaj higo retcon pe rchinoj. Ja' acha xba ruq'uin higo chneretz'ta' wc'ola rwech y majo'n rwech xuwil. ");
INSERT INTO tzjE_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","C'ola jun ajsmajma' je nchajina rxin chnoj cawra xbij tzra: —Jawra jun mcaj higo ra juna' juna' quentz'et wc'ola rwech nuya'. Oxi' juna' nebnon cawrara per nmajo'n rwech netz'ton. Mejor techyo', chek cara' nuq'uis kaja rchuk'a' ulew, cara' xbij tzra ajsmajma'. ");
INSERT INTO tzjE_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","—Tey-a' tzra', tec'je' chna jun juna'. Anen quenchumsaj na y quenya' abono chuxe' chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mal-il xtwachina, per we nmajo'n, c'jara' c'a xtachoy, cara' xbixa tzra rajaw chnoj. Cara' jc'ambal tzij xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Chpam jun xlanbal k'ij ja' Jesús remjon ctojxic wnak chpam jun jay rxin molbal ri'il. ");
INSERT INTO tzjE_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","C'ol c'a tzra' jun ixak yawa', xuban dieciocho juna' c'ola chpam yubil rmal jun itzel espíritu. Rmal c'ara' luclic chic rij ja' ixak, mesquier necwina jic npe'a per nexte jtz'it. ");
INSERT INTO tzjE_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ja' Jesús tak xutz'et ixak xsiq'uij pona. Tak xerkaja ruq'uin cawra xbij tzra: —Camic ixak, at majo'n chic pruk'a' yubil, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","C'jara' xuya' ruk'a' pe rwá' y njara' hor xchumtaja, njic xec'je'a rij y congan xumaj rya'ic ruk'ij Dios rmal. ");
INSERT INTO tzjE_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Per xpeta jefe rxin jay je rxin molbal ri'il, arja' congan penak ryiwal com Jesús chpam jun xlanbal k'ij xchumsaj wa' ixak y cawra xbij chca wnak ra: —Chpam jun sman wajki' k'ij yatanak chka che nokosmaja. Chpam jawra wajki' k'ij utz nquixpeta che nquixchumsasa per me tquixpeta ptak xlanbal k'ij, cara' xbij ja' jefe chca. ");
INSERT INTO tzjE_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ja' Kajaw Jesús tak xc'axaj je xbij jefe cawra xbij ra: —C-e' aplaj. Ixix ptak xlanbal k'ij ¿lmajo'n c'a jun chewa mquita nuquir rwajcax o wruquiej, nuc'om ela y nerey-a' ruya'? ");
INSERT INTO tzjE_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Jawra ixak ra arja' riy rumam Abraham. Y camic xuban dieciocho juna' ximtala chpam yubil rmal Satanás. ¿Le myatanak tc'a tzra che nela libre pruk'a' yubil camic mesque xlanbal k'ij nach'ob atet? cara' xbij tzra jefe. ");
INSERT INTO tzjE_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Je' wnak jxetzelana rxin, tak xecc'axaj tzij xquena' kaja queq'uix. Jle' chic wnak arj-e' xequicota rmal je nmak tak samaj rxin Dios jrebnon. ");
INSERT INTO tzjE_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","C'jara' xumaj chic jmul tzij Jesús, cawra xbij chic ra: —¿Nak rbanic rgobierno Dios, abar c'a wa' quenjumsaj wa'? ");
INSERT INTO tzjE_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Je rgobierno Dios cara' rbanic ajni' jun ch'it rk'arwech mostaza, nec'mar ela rmal jun acha y xutic pe rchinoj. Xumaj c'yinem mostaza, xoca ajni' jun mcaj che'. Xepeta ch'tak tz'quin, xecrebna' quesoc ptak ruk'a'. Cara' xbij ja' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Cawra xbij chic jmul Jesús: —¿Abar quenjumsaj wa' rgobierno Dios? ");
INSERT INTO tzjE_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Cara' rbanic ajni' nuban jle' levadura jnespoja xquelway rmal, c'ola jun ixak xuc'om levadura, xuya' chpam jle' k'or, oxi' pajbal harina ocnak. Tak xq'uisbena, jlevadura ne xba chpam njelal k'or, congan xesmaja, cara' xbij ja' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","C'jara' xumaj el chic rubey nba pJerusalén. Tak remjon binem y tak nk'axa chpam jun tnamet owe chpam jun aldea numaj ctojxic wnak jec'ola chpam. ");
INSERT INTO tzjE_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","C'ola jun chca wnak cawra xc'axaj tzra Jesús: —Wajaw ¿xme q'uiy ta nquewlowa totanem rxin Dios? Ja' Jesús xumaj tzij cuq'uin wnak y cawra xbij chca: ");
INSERT INTO tzjE_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—C'ola jun chijay congan co'l y xruyon tzra' ncatecwina ncatoca chnawil totanem rxin Dios. Tetja' c'a ek'ij ch-utz c'ara' ne tzra' nquixoc wa' ixix. Com e q'uiy wnak jwer neccanoj wa' che nque'oca per mesquier nquecwina. ");
INSERT INTO tzjE_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Com rajaw jay nyictaja y ntz'apij ruchi' chijay. Ixix wq'uemjana nquixoca tzra', c'jara' netarij oca chijay y cawra xtebij oca: —Kajaw, Kajaw, tejka' chijay chkawech, cara' xtebij oca tzra. Ja' rajaw jay cawra xtbij ta chewa: —Anen majo'n wutkin ta abar le tzra' ixpenak wa' ixix, cara' xtbij ta chewa. ");
INSERT INTO tzjE_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","—Per ajoj okwanak wan awq'uin y xe'atijoj wan wnak ptak bey chpam ketnamet, cara' xtebij oc chic tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","—Anen quenbij chewa chmajo'n wutkin ta abar le tzra' ixpenak wa'. Camic quixel ela chixconjelal chenwech jme ix bnoy ta rbeyal rxin Dios, cara' xtbij pchic chewa. ");
INSERT INTO tzjE_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tak xtetz'et Abraham che arja' c'ola chpam rgobierno Dios e rexbil Isaac ruq'uin Jacob e rexbil chka' conjelal e ojer tak profeta rxin Dios, per chewa ixix majo'n nyataj ta che nquixoca chquecjol. Rmal c'ara' tak xtemaj jun nimlaj bis ruq'uin ok'ej y xtecach'ch'ej rkan ewak' rmal. ");
INSERT INTO tzjE_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Chka' ec'ola wnak jme aj Israel ta arj-e' nquepe na nat nkaj chwech ruch'lew, nque'oc na chpam rgobierno Dios y nquetz'be' na tzrij mes. ");
INSERT INTO tzjE_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Per bien twutkij che ec'ola wnak e c'moy tak bey nabey xe nquecanaj cana pe rq'uisbal, y ec'ola jec'ola pe rq'uisbal arj-e' nquec'mow chic bey. Cara' xbij Jesús chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jara' mism k'ij ec'ola jle' fariseo xe'ekaja ruq'uin y cawra xecbij tzra ra: —Jat catnanmaj ela com jgobernador Herodes arja' nrajo' ncatercamsaj, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ja' Jesús cawra xbij chca ra: —Ja' Herodes xjun mañoslaj acha. Camic jax ruq'uin y cawra nebij tzra: —Ja' Jesús nbij che ec'o na wnak nelsaj na itzel tak espíritu pcanm y q'uec'o na yuw-i' nquerchumsaj chka'. Cara' nuban camic, cara' nuban chwak, y q'ue prox k'ij xtuq'uis wa' rsamaj, cara' nebij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Per camic npors quenmaj el chic jmul nubey. Quenbina camic, chwak ruq'uin cabij, pors quenba pJerusalén y tzra' quencamsas wa' com jun profeta rxin Dios majo'n ra mquita pJerusalén xtcamsas wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ixix jix tnamet Jerusalén, anen congan quenbisona ewmal. Je' profeta rxin Dios xe nque'ecamsaj. Jle' chic ajsmajma' rxin Dios je nqueta'k ewq'uin xe nque'eq'uiek tzan abaj. Anen q'uiylaj mul xenwajo' ta xixnuto' ajni' nuban jun ec' nermulej ch'tak ral xe' rpam per ixix majo'n xewajo' ta. ");
INSERT INTO tzjE_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Camic bien tewc'axaj je xtenbij chewa ra, je etnamet rexbil etemplo jc'ola chpam jara' y-on cchic rmal Dios, lowlo' xteba'n na tzra y netle' cana. Cara' quenbij cana chewa com camic majo'n chic nutz'et ta ri' kawech ewq'uin, c'jara' nutz'et chic jmul ri' kawech ewq'uin tak xterla' k'ij tak cawra xtebij chwa: —Bendecido Cristo jpenak prubi' Kajaw Dios. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Je pjun xlanbal k'ij xba Jesús chruchoch jun fariseo nim ruk'ij chnewa'a ruq'uin. Tak xekaja nch'ulchin cmal wnak jquemlon qui' tzra' ch-utz c'ara' neccanoj jun ril. ");
INSERT INTO tzjE_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","C'ol c'a jun acha chwech congan spojnak rmal yubil. ");
INSERT INTO tzjE_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ja' Jesús xumaj tzij cuq'uin maestro je nquetijona cxin wnak tzrij rley Dios e quexbil aj fariseo y cawra xbij: —Tbij chwa, nak nbij ley ¿lnuya' c'as chwa che quenchumsaj yuw-i' ptak xlanbal k'ij? ");
INSERT INTO tzjE_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Per arj-e' nmajo'n achnak xecbij tzra. C'jara' xuchap yawa' y xchumsaj, y cawra xbij tzra: —Utz chic ncatba. Ja' yawa' xba. ");
INSERT INTO tzjE_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ja' Jesús xumaj chic jmul tzij cuq'uin maestro e quexbil aj fariseo y cawra xbij chic chca: —¿Lc'o tc'a jun chewa c'o ta jun ruquiej owe rwajcax ntza'k ela chpam jun jul pjun xlanbal k'ij le mtelsaj c'a alnak chpam jul? Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Per j-e' nmajo'n xecney ta cmal nak necbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ja' Jesús xerutz'et wnak jebnon invitar tzra w-im che arj-e' ntajina necch'ojquij qui' tzrij tz'ulbal nmak ruk'ij rmal c'ara' tak c'ola jun c'ambal tzij xbij chca cawrara: ");
INSERT INTO tzjE_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Tak ncatba'na invitar tzra jun w-im rxin c'ulbic mtacanoj ta jun tz'ulbal jmás nim ruk'ij perc mal-il nerkaj chic jun wnak jsiq'uin tzra w-im más chna nim ruk'ij que chawech atet, ");
INSERT INTO tzjE_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","y chek q'uenjlal tak xtebixa chawa rmal acha jsic'yona awxin tzra w-im cawrara: —Tey-a' cana jawra tz'ulbal, c'ola jun acha nebnon invitar, ja' netz'be'a chwech, cara' xtbij chawa. Wcara' xtbixa chawa jara' congan q'uixbal xtana' y npors ncatetz'be' na chwech jq'uisbal tz'ulbal. ");
INSERT INTO tzjE_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mejor jnaban, tak ncatba'na invitar catetz'be'a chwech q'uisbal tz'ulbal. Acha jsic'yona awxin, tak xterkaja awq'uin cawra nbij chawa ra: —Jo' amigo, catetz'be'a chwech jun tz'ulbal jmás chna nim ruk'ij. Wcara' xtbixa chawa conjelal je esiq'uin tzra w-im jetz'bula awq'uin tzrij mes arj-e' ncatquetz'et chnim ak'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Cara' c'a rbanic com nak wnak xruyon kaja nuya' ruk'ij jara' xe nkasas na. Wnaban ch'it no'y jara' nya' na ak'ij, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Cawra xbij tzra acha chka' jsic'yona rxin: —Tak ec'ola wnak nque'aban invitar che necrebna' w-im awq'uin rxin nc'aj k'ij owe rxin tk'ak'ij, per mtaban ta cara' je xqueyon awamigo nque'aban invitar, owe anmal, owe achak', owe jle' chic awch'alal, owe abcin je byoma'. Wxe j-era' nque'aban invitar jara' xe ncatqueban chic invitar atet pjun chic w-im, xe nqueya' rec'xel chawa. ");
INSERT INTO tzjE_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Per kas rbeyal naban, tak ec'ola wnak nque'aban invitar che necrebna' jun w-im awq'uin que'abna' invitar ch'tak mibi', e quexbil jmajo'n tz'kat ta quek'a', e quexbil chka' je' e ch'e'y nquebina, y je' ch'tak moya'. ");
INSERT INTO tzjE_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wcara' naban jara' c'ola jun quicotemal rxin Dios nyataj na chawa com je' wnak je xennataj kaja arj-e' mesquier nquecwina xtqueya' ta rec'xel chawa. Ncatquicota com c'ola jun rtojbalil nyataj na chawa, tzra' nyataj wa' tak xtquec'astaja wnak je cc'an rbeyal rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","C'ol c'a jun tz'bula tzrij mes tak xc'axaj je xbij Jesús cawra xbij tzra ra: —Ajni'la quicotemal chca wnak je xtewa'a chpam rgobierno Dios, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús c'ola jun c'ambal tzij xbij tzra cawrara: —C'ola jun acha c'ola jun nimlaj w-im rxin tk'ak'ij xuban y e q'uiy wnak xeruban invitar. ");
INSERT INTO tzjE_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tak xerla' hor rxin w-im c'ola jun rmos xutak ela che csic'sic je' invitado. Ja' mos tak xe'ekaja cuq'uin invitado cawra xbij chca ra: —Jo' chumtanak chic njelal w-im, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Je' invitado arj-e' xjunam xqueban, xquemaj rbixic tzra mos nak rmal tak mesquier nquecwina nqueba pe w-im. Jun nabey mul cawra xbij tzra: —Anen xc'ola jun ulew xenlok' y npors cnetz'ta' na. Tecyu' numac, mesquier quencwina quenba, cara' tbij pona jlal tzra apatrón, cara' xbij tzra mos. ");
INSERT INTO tzjE_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","C'o chic jun invitado cawra xbij tzra mos: —Anen xe ec'ola e j-o' c'laj wajquex rxin cret xenulok'. Camic quenuc'om ela che quenebna' probar. Tecyu' numac, mesquier quencwina quenba, cara' tbij pona tzra apatrón, cara' xbij rucab. ");
INSERT INTO tzjE_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","C'o chic jun cawra xbij tzra: —Anen c'ja' xenc'le'a rmal c'ara' mesquier quencwina quenba pe w-im, cara' xbij tzra mos. ");
INSERT INTO tzjE_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jmos arja' xemloj ta. Tak xerkaja ruq'uin rpatrón xuchol njelal je xbix ta tzra. Ja' rajaw jay xpeta ryiwal chquij invitado y cawra xbij chic tzra mos: —Catemloj chic jmul alnak, jat ptak bey rxin tnamet y ptak rumbal tak bey chka', que'acanoj ch'tak mibi' e quexbil wnak jmajo'n tz'kat ta quek'a', je' wnak e ch'e'y nquebina, je' ch'tak moya', y que'ac'ma' ta wawe'. ");
INSERT INTO tzjE_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Cara' c'a xuban mos ajni' xbix ela tzra. Tak xemloj ta cawra xbij chic tzra rpatrón: —Ta', xnebna' ajni' xabij chwa per jtz'ulbal c'c'o na y majo'n rajaw, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ja' patrón cawra xbij chic tzra mos: —Catemloj chic jmul per camic ncatela chpam tnamet che cconxic wnak, nque'acanoj ptak bey che nmak y cocoj tak bey, y nabij chca che npors nquepeta ch-utz c'ara' nquenoja wnak pwuchoch, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Camic quenbij chewa che je' wnak je xeba'na invitar nabey mul arj-e' nmajo'n xtyataj ta chca che xtquetaj ta jawra w-im je xtenchumsaj. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Xumaj chic jmul rubey, e congan wnak etrena tzrij. Arja' xuya' volt y cawra xbij chca ra: ");
INSERT INTO tzjE_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Nak jun c'ola rgan noca ndiscípulo nc'atzina chquenrajo' más anen que chquewech e redta' rute', owe rexkayil, owe chquewech ch'tak rlec'wal, owe renmal, owe ruchak', owe rana'. Nc'atzina chmás quenrajo' anen que chwech ajni' nrajo' kaja ri' ruyon. Wmás nquerajo' jle' chic que chenwech anen jara' mesquier necwina noca ndiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nak npoknaj ri' netre' ta chwij y npoknaj ri' nutaj pen, cara' pen ajni' jun acha rtelen jun cruz, jara' mesquier necwina noca ndiscípulo chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Cara' quebij chewa com ¿lc'o tc'a jun chewa xtuban ta jun nimlaj jay y mquita netz'be'a nabey mul y numaj rch'obic pnejkal ajni' pak nrajo' ch-utz c'ara' nrutkij wnec'choja rmal chnuq'uis rbanic o wmajo'n? ");
INSERT INTO tzjE_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wmajo'n nuch'ob ta, mal-il majo'n necwin ta nuq'uis rbanic jay y xruyon rcimient necwina nuban. Je' wnak tak xtquetz'et conjelal nquemaj ryok'ic ");
INSERT INTO tzjE_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","y cawra necbij ra: —Jala acha xumaj rbanic jun jay per mesquier xecwin ta xuq'uis rbanic, cara' xtecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jun chic, jun rey ec'ola e ljuj mil soldado ruq'uin y c'o chic jun rey nerebna' ch'oj ruq'uin per e veinte mil rsoldado jawra rey. Jrey jxe ljuj mil rsoldado ec'ola ruq'uin ¿lnuban tc'ara' ch'oj ruq'uin jara' jun chic rey we mquita netz'be'a nabey mul y numaj rch'obic wnecwina tzrij? ");
INSERT INTO tzjE_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wnuch'ob che mtecwina tzrij cawrara nuban, tak q'ue c'nat c'o wa' jun chic rey nerutak ela jle' wnak ruq'uin che necchumij ruq'uin ch-utz c'ara' me tqueban ta ch'oj. ");
INSERT INTO tzjE_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Cara' c'a rbanic, nak jun chewa npoknaj nuya' cana njelal jc'ola ruq'uin jara' mesquier noca ndiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jatz'am wen samaj nuban per we xyojtaja y majo'n chic retzyil ¿nak nchumbex chic rxin? ");
INSERT INTO tzjE_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","We xcara' xuban jara' majo'n chic noc wa', majo'n rsamaj xtaya' ta penlew nexte xtayuj ta ruq'uin k'ayis jabono, per jnaban tzra jara' xnach'akij ela. Achnak c'ola rexquin tc'axaj c'a jquenbij. Cara' xbij Jesús chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Je e mloy tak impuesto e quexbil jle' chic wnak je aj-il ajmac nbixa chca, xeki'l oca más ruq'uin Jesús ch-utz c'ara' necc'axaj nak remjon rcholic. ");
INSERT INTO tzjE_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ec'ol c'a jle' fariseo e quexbil je' maestro je nquetijona cxin wnak tzrij rley Dios arj-e' xquemaj rtzojxic Jesús: —Jala acha xe m-utz ta remjon rij, ntak nqueruc'ul aj-il ajmac y nwa'a tak wan cuq'uin chka', cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ja' Jesús xumaj rbixic jun c'ambal tzij chca cawrara: ");
INSERT INTO tzjE_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Lc'o tc'a jun chewa ec'o ta e jun cient ch'tak rcarne'l y ntzak tc'a jun chca, le mtqueruya' cc'ara' je e noventinueve ptak k'ayis chnercanoj pors je xtzaka? ");
INSERT INTO tzjE_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tak necneya rmal nch'elej ta y congan nquicota rmal. ");
INSERT INTO tzjE_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tak nekaja chruchoch nutak csic'sic ramigo e rexbil rebcin y cawra nbij chca: —Camic quixquicota wq'uin com xecneya nmal ch'it ncarne'l je xtzaka. Cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Cara' quenbij chewa anen chka', jun aj-il ajmac tak nuq'uex rna'oj y nuya' cana rtzilal jara' más nquequicota jec'ola chcaj que chwech je noventinueve jquebnon rbeyal rxin Dios jmajo'n nc'atzin ta chca nqueq'uex cna'oj. ");
INSERT INTO tzjE_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jun chic ¿lc'o tc'a jun ixak c'o ta ljuj rpak y ntzak tc'a jun tzra, le mquitc'ara' nutzij jun candil y le mtuban c'ara' mes che ncanoj? ");
INSERT INTO tzjE_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y tak necneya rmal nutak csic'sic ramigo e rexbil rebcin y cawra nbij chca ra: —Camic quixquicota wq'uin com xecneya nmal je npak jnetzkon, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Y cara' quenbij chewa anen chka', jun aj-il ajmac tak nuq'uex rna'oj y nuya' cana rtzilal jara' congan nquequicota je' ángel rxin Dios. Cara' xbij ja' Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","C'jara' c'o chic jun c'ambal tzij xbij chca cawrara: —C'ola jun acha ec'ola e c-e' rlec'wal. ");
INSERT INTO tzjE_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Xpeta rcabal, cawra xbij tzra redta': —Nedta', camic tejcha' wherencia, tey-a' chwa je wxin anen, cara' xbij tzra. Y cara' xuban ttixel, xujach herencia chquewech che c-e'. ");
INSERT INTO tzjE_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tak xuban c-e' oxi' k'ij xchumsaj ri' rcabal, xumol ruchi' njelal je jchon tzra. Tak xmoltaja rmal c'jara' xumaj ela rubey xba pjun c'nat tnamet. Tak xekaja chpam tnamet xumaj rsachic rpak, xuban tzra achnak c'ola rgan chnuban, nchek jic xsachla' rpak. ");
INSERT INTO tzjE_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tak xsachtaja njelal rpak rmal xpet c'a jun nimlaj wyejal abar c'o wa' y rmal c'ara' xmajtaja rmal wyejal. ");
INSERT INTO tzjE_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","C'jara' xba xercanoj rsamaj ruq'uin jun acha jc'ola tzra' chpam tnamet. Acha jc'ola jun rulew ptayu' abar erey-on wa' jle' a'k, tzra' xutak el wa' ala' che nqueryuk'uj a'k. ");
INSERT INTO tzjE_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ja' ala' congan majtanak rmal wyejal, congan nyarij nutaj queway a'k. Nmajo'n wnak nyowa rway. ");
INSERT INTO tzjE_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tak xch'obtaja rmal jremjon rij cawra xbij kaja pranm: —Je' mos je nquesmaja ruq'uin nedta' ne ajru'la nq'uiy queway rebnon sobr, per kas c'a anen congan enmajtanak rmal wyejal. ");
INSERT INTO tzjE_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Camic quenmloja ruq'uin nedta' y cawra cnebij tzra: —Nedta', jxenban xenmajcuna chwech Dios y xenmajcuna chawech chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Camic majo'n chic yatanak xta chwij che nbixa chwa che en awlec'wal, tebna' chwa com en ajni' jun amos, cara' cnebij tzra, cara' nbij kaja ja' ala'. ");
INSERT INTO tzjE_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","C'jara' xumaj ta binem, xemloj ta ruq'uin redta'. Ja' ttixel xutz'et pona rlec'wal penak per q'ue c'nat c'o pon wa'. Congan xpoknaj rwech, xba alnak y xerec'lu', xk'etej y xtz'ubaj ruchi'. ");
INSERT INTO tzjE_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ja' ala' cawra xbij tzra redta': —Nedta', jxenban xenmajcuna chwech Dios y xenmajcuna chawech chka'. Camic myatanak xta chwij che nbixa chwa che en awlec'wal, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Per ttixel xersiq'uij rmos y cawra xbij chca ra: —Tewsaj tziak k'axnak wen, jara' newekbej wlec'wal. Jun chic, tecsaj jun pk'a' chuk'a' y tey-a' rexjab chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jun chic, tec'ma' ta wajquex jmás chak' chic y tepch'o'. Kabna' jun w-im, kabna' jun nimk'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Cara' c'a kabna' com camic xemloj ta wlec'wal ojer ttzaka. Xench'ob anen camnak chic per c'c'as noka, cara' xbij ja' ttixel. C'jara' xquemaj rbanic nimk'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Jnabey-al arja' bnak psamaj. Tak xemloj ta y xyamer nerkaja chruchoch xc'axaj pona chc'ola jun nimlaj nimk'ij majtanak rij. ");
INSERT INTO tzjE_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Xsiq'uij pona jun mos: —¿Nak rbanic c'ala' jmajtanak rij? cara' xc'axaj. ");
INSERT INTO tzjE_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","—Camic xemloj ta achak'. Ja' adta' xutak rpoch'ic wajquex jmás chak' chic. Cara' xuban com c'c'as na achak', utz rwech xerkaja, cara' xbixa tzra rmal mos. ");
INSERT INTO tzjE_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tak xc'axaj tzij congan xpeta ryiwal rmal y nmajo'n chic rgan noca pjay. Rmal c'ara' xel tna redta' y xumaj rbuchxic ch-utz c'ara' che noca pjay. ");
INSERT INTO tzjE_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Per cawra xbij tzra redta': —Bien terkaja pnawá' che anen q'uiylaj juna' ensmajnak awq'uin, chka' ne nniman jnabij chwa chquenban. Per atet nmajo'n achnak ay-on chwa xquenbanbej jun nimk'ij cuq'uin wamigo per next jun cabra ay-on chwa. ");
INSERT INTO tzjE_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Per jala awlec'wal tak xerkaja wawe' nxatakla' rpoch'ic wajquex jmás chak' chic per xerec'sa' cnara' amibil cuq'uin itzel tak ixki'. Cara' xbij ja' nabey-al tzra redta'. ");
INSERT INTO tzjE_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ja' ttixel cawra xbij chic tzra: —Wlec'wal, atet natc'o wa' wq'uin, awxin atet njelal achnak jc'ola wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Per camic m-utz tc'ara' mquita nkaban jun nimk'ij, m-utz tc'ara' mquita nokquicota, com camic xerkaja achak' je ojer ttzaka. Jxench'ob anen camnak chic per c'c'as noka, cara' xbij ja' ttixel tzra nabey-al. Cara' c'ambal tzij xbij Jesús chca aj fariseo e quexbil je' maestro. ");
INSERT INTO tzjE_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","C'jara' c'ola jun c'ambal tzij xbij chca rdiscípulo cawrara: —C'ola jun acha byom c'ola jun ajsmajma' ruq'uin je nechjalbena rxin rmibil. Xebixa tzra byom che ajsmajma' xe ntajina nuq'uis rmibil y chka bechnak nuban tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ja' byom xutak rsic'sic ajsmajma' y tak xekaja cawra xbij tzra: —Anen xerkaja rbixic wq'uin xamjon rq'uisic nmibil. ¿Nak tzra tak xaban cara'? Camic tejcha' cwent nak abnon tzra nmibil com anen majo'n chic quenwajo' ta ncatesmaja wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ja' ajsmajma' cawra xbij kaja pranm: —¿Nak quenban c'a wa' camic com npatrón nelsaj nsamaj? Com anen congan pen chic chwa xtenban ta samaj je nrajo' chuk'a' y xq'uixbal quenna' xtenmaj ta rc'utxic limosna. ");
INSERT INTO tzjE_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Camic xch'obtaja nmal nak quenban ch-utz c'ara' ec'ola nquec'luwa wxin ptak cuchoch tak jmajo'n chic nsamaj, cara' xuch'ob kaja. ");
INSERT INTO tzjE_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","C'jara' xutak csic'sic wnak chejujnel jc'ola quec'as ruq'uin patrón. Tak xe'ekaja cawra xbij tzra jun ra: —¿Ajru' ac'as ruq'uin npatrón? cara' xc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","—Anen jun cient tonel aceite nuc'as, cara' xbixa tzra rmal ajc'as. Ja' ajsmajma' cawra xbij tzra: —Je rwujal ac'as, tec'ma' ela. Camic catetz'be'a y tbanla' chic jun awuj alnak per xcincuenta tonel aceite ac'as natz'ibaj chpam, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","C'jara' cawra xbij chic tzra jun ajc'as: —¿Ajru' ac'as atet? cara' xc'axaj tzra. —Anen jun cient quintal trigo nuc'as, cara' xbij. Cawra xbij chic tzra: —Tec'ma' ela rwujal ac'as. Tebna' chic jun per xe ochenta quintal natz'ibaj chpam, cara' xbij ja' ajsmajma' tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ja' patrón tak xuya' cwent tzrij ajsmajma' jmajo'n xuban ta rbeyal cawra xbij ra: —Ja' ajsmajma' congan list y congan rna'oj. Cara' xbij patrón y ne ktzij wa' xbij com je' wnak xruq'uin jawra tiemp rxin rwech ruch'lew ykul wa' quec'u'x arj-e' congan e list tzrij negocio cuq'uin e bnoy negocio. Más chna e list que chquewech e rlec'wal Dios jsakersan chic quebey. ");
INSERT INTO tzjE_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jmibil rxin rwech ruch'lew congan lowlo' nqueban wnak rmal. Per camic quenbij chewa, quixoca list ixix chka', tecsaj je' mibil rxin rwech ruch'lew per jneban ixix, tzra' necsaj wa' jc'ola cnecesidad. Cara' ta neban ch-utz c'ara' tak nq'uisa mibil rxin rwech ruch'lew c'jara' je' ewamigo jxe'eto' arj-e' nquec'luwa ewxin chcaj ptak cuchoch je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","We rbeyal naban che rcusic jtz'it rmibil apatron, tzra' ntz'e't wa' che rbeyal naban chka' che rcusic q'uiy rmibil tak nujach pnak'a'. Per wme rbeyal ta naban tzra jtz'it rmibil, tzra' ntz'e't wa' che me rbeyal ta naban tzra tak nuya' q'uiy chawa. ");
INSERT INTO tzjE_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Rmal c'ara' tak quenbij chewa, wxe m-utz ta ecsan wa' mibil rxin rwech ruch'lew jara' nmajo'n jun ykul ta ruc'u'x ewq'uin xtujach ta pnek'a' rmibil Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jun chic, wc'ola mibil rxin jun chic wnak jchon pnek'a' che nechjalbej per wxe m-utz ta rcusic neban, jara' nmajo'n xtyowa chewa ja herencia rxin Dios jne ktzij wa' che ewxin ixix. ");
INSERT INTO tzjE_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Jun wnak chka bechnak wnak opech mesquier necwina nec'je'a pquek'a' e c-e' rajaw che nesmaja cuq'uin, jara' jun wen nutzu' y jun xitzel nutz'et, o wjun nnimaj y majo'n nnimaj xta jun. Cara' c'a chka', mesquier ncatecwina naban rsamaj Dios y xteyke' ta ac'u'x ruq'uin mibil rxin rwech ruch'lew. Cara' xbij Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","J-e' aj fariseo xecc'axaj njelal je xbij Jesús tzrij mibil. Rmal c'ara' xquemaj ryok'ic com arj-e' bnak quec'u'x tzrij mibil rxin rwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ja' Jesús cawra xbij chca: —Ixix cawra ebanic ra, nek'alsaj ewi' chquewech wnak che ebnon rbeyal per Dios bien rutkin nak c'ola ptak ewanm. Ec'ola wnak itzel nquetz'e'ta rmal Dios mesque ncongan wen nquetz'e'ta cmal wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Je rley Dios rexbil jtz'ibtanak cana cmal e ojer tak profeta rxin Dios jara' y-on rbixic chpam jara' tiemp tak q'uemjana tumaj rsamaj Juan Bautista. Per tak xerla' retiemp Juan Bautista, tzra' xumaj twa' rbixic rgobierno Dios y conjelal wnak nquetajina nquetaj cchuk'a' ch-utz c'ara' nque'oca chpam jara' gobierno. ");
INSERT INTO tzjE_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Per npors nbantaj na cumplir njelal rley Dios. Nmajo'n pen ta nq'uis wa' rwech caj ruq'uin rwech ruch'lew que chwech mquita xtbantaja cumplir jun ch'it punto rxin ley. ");
INSERT INTO tzjE_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jun acha chka bechnak acha opech nujach cana junlic rexkayil y wnuc'om chic jun ixak jara' adulterio nuban. Y wc'ola jun acha nuc'om chic jun ixak jchon cana rmal rechjil jara' adulterio nuban, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","C'jara' cawra xbij chic chca: —C'ola jun acha byom, congan wen tak tziak nucsaj je nmak rjel. K'ij k'ij nc'ola nmak tak w-im nuban. ");
INSERT INTO tzjE_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","C'ola jun miba' c'tuy limosna, Lázaro rubi'. Ja' Lázaro xeya' cana chuchi' ruchoch byom. Jrecuerpo nojnak pch'ac njelal. ");
INSERT INTO tzjE_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kas nyarij nutaj ruc'aj tak way je ntzak ela xuxe' tak mes ruq'uin byom. Per nquepeta je' tz'e' tzrij y nquerak' ch'a'c jc'ola tzrij. ");
INSERT INTO tzjE_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tak xq'uisbena xcoma miba' jc'utuy limosna y ruq'uin Abraham xec'mar el wa' cmal ángel jabar ec'o wa' cnomki' jec'ola chpam quicotemal. Xcoma byom chka' y xemu'k cana. ");
INSERT INTO tzjE_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tak xuna' ri' congan majtanak rmal lowlo' chpam lwar abar ec'ol wa' cnomki' jquemjon rij bis ok'ej. Tak xca'ya chcaj xutz'et pona Abraham per q'ue c'nat c'o wa' y prupox c'o wa' Lázaro. ");
INSERT INTO tzjE_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","C'jara' xumaj rakic ruchi': —Tpoknaj nwech nedta' Abraham. Tetka' pa Lázaro wq'uin, tem-u' ta jun rwá' ruk'a' pya' che nxuc'ursaj rkan wak', com anen chpam jun k'ak' enc'ol wa' y congan nemjon rtijic lowlo' chpam, cara' xbij tzra Abraham. ");
INSERT INTO tzjE_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ja' Abraham cawra xbij tzra: —Wlec'wal, terkaja pnawá', tak xatec'je'a chwech ruch'lew, ayon xataj kaja njelal amibil per jLázaro arja' xpoknal xutaj. Per camic congan chic qui' ruc'u'x Lázaro wawe' per atet amjon rtijic lowlo'. ");
INSERT INTO tzjE_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Chka' c'ola jun nimlaj siwan y-on chkacjol ch-utz c'ara' wc'ola jun wawe' nrajo' nk'axa ewq'uin jara' mesquier necwina nk'axa, o wc'ola jun chewa ixix nrajo' nk'ax ta kuq'uin jara' mesquier necwina chka', cara' xbixa tzra rmal Abraham. ");
INSERT INTO tzjE_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ja' acha cawra xbij chic tzra: —Wcara' rbanic nedta' tebna' c'a jun utzil, tetka' el pka Lázaro cuq'uin wch'alal jec'ola pruchoch nedta'. ");
INSERT INTO tzjE_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Com ec'ola e j-o' wch'alal tzra' y quenwajo' nba Lázaro cuq'uin chnerech'bo' chquewech nak rbanic wawe' ch-utz c'ara' majo'n nquepeta j-e' wawe' ra chka' chpam jawra lwar rxin tjoj rpoknal, cara' xbij tzra Abraham. ");
INSERT INTO tzjE_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Cawra xbixa tzra rmal Abraham: —Per c'ol wan cuq'uin rtzojbal Dios jtz'ibtanak cana rmal Moisés y cmal jle' chic profeta, quey-a' c'a quexquin tzrij je ctz'iban cana arj-e', cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","—Mcara' ta nedta' Abraham, per wc'ola jun comnak nel ela chquecjol cnomki' y nekaja cuq'uin jara' nqueq'uex cna'oj, cara' xbij chic tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ja' Abraham cawra xbij chic tzra: —Wmajo'n nqueya' ta quexquin tzrij rtzojbal Dios jtz'ibtanak cana rmal Moisés y cmal jle' chic profeta jara' nmajo'n wa' ra' necnimaj ta mesque nc'ola jun comnak nc'astaj ela chquecjol cnomki', cara' xbij tzra. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","C'jara' xumaj tzij cuq'uin rdiscípulo y cawra xbij chca: —Je' wnak npors nqueba'na tentar che rbanic il mac per congan lowlo' nutaj na jnebnowa tentar cxin. ");
INSERT INTO tzjE_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Más na utz nxi'ma jun ca' chukul y nq'uie'k ela pya' che nq'uis kaja rexla' que chwech nuban tentar jun chca je ykula ruc'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Per ixix tebna' cwent. Wc'ola jun ewch'alal xuban jun lowlo' chewa, jneban tbij tzra jxuban chewa y we xc'utuj sachbal rumac chewa tecyu'. ");
INSERT INTO tzjE_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mesque wku' mul nuban lowlo' chewa pjun k'ij per wku' mul nc'utuj sachbal rumac chewa jara' necuy wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","J-e' apóstol tak xecc'axaj je xbixa chca cawra xecbij tzra Kajaw Jesús: —Camic tey-a' c'a más yukbal kac'u'x awq'uin, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ja' Kajaw Jesús cawra xbij chca: —Wc'ola yukbal ec'u'x wq'uin, wnesmaja yukbal ec'u'x ajni' nuban jun ch'it rk'arwech mostaza nquixecwin c'ara' neban jun nimlaj samaj. Ajni' tzra jun che' jawrara, nquixecwina nebij tzra che nboktaj ela rexbil rc'amal ruxe' y neretca' ri' pmar, y nquixernimaj. ");
INSERT INTO tzjE_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Wc'ola jun emos c'ja' xemloj ta psamaj, o pe yk'un tak carne'l ¿lcawra nebij tzra: —Ctoc ta, catetz'be'a tzrij mes y catwa'a, lcara' nebij tzra? ");
INSERT INTO tzjE_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mcara' ta nebij tzra. Jnebij jara' cawrara: —Tchumsaj je nti'ja camic ra, tecsaj atziak rxin ilinem y cnawilij. Tak xtec'choja w-im nmal anen c'jara' xtcatwa'a atet, cara' nebij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ja' ilinel wxuban cumplir njelal jxebij tzra chnuban ¿lnemeltioxij tzra? Jquench'ob anen majo'n nemeltioxij ta tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ajni' rbanic ilinel cara' ebanic ixix chka'. Tak xtbantaja cumplir njelal ewmal je nbij Dios chewa chneban cawra tbij ra: —Ajoj ok mos. Jsamaj kabnon jara' mjun ta favor nkaban tzra Dios, ne chkakul wa' c'o wa' che nkaban, majo'n kak'a' tzra che nmeltioxixa chka, cara' tbij, cara' xbij Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","C'jara' xumaj chic rubey je nba pJerusalén. Jbey xuc'om ela jara' je nk'axa pe rmonjon rxin c-e' departamento Samaria ruq'uin Galilea. ");
INSERT INTO tzjE_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tak xoca chpam jun tnamet ec'ola e ljuj ach-i' xquec'ul qui' ruq'uin. J-e' ach-i' lepra cyubil rmal c'ara' q'ue c'nat xe'epe' twa' chwech Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Xquemaj rakic quechi' tzrij: —Jesús, Maestro, tpoknaj kawech, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ja' Jesús tak xerutz'et cawra xbij chca ra: —Jix ec'tu' ewi' chquewech sacerdote, cara' xbij chca. Xeba, kas quemjon binem tak xec'choja, xela lepra chquij. ");
INSERT INTO tzjE_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","C'ol jun chca tak xutz'et che xec'choja xemloj ta y congan xumaj rakic ruchi' che rya'ic ruk'ij Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tak xekaja ruq'uin Jesús xexque'a chwech, xtcomyij ruplaj y congan nmeltioxij tzra. Aj Samaria ja' acha. ");
INSERT INTO tzjE_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ja' Jesús cawra xbij: —¿Lme e ljuj tc'a xec'choja? ¿Abar c'a ec'ol wa' je belje' chic? ");
INSERT INTO tzjE_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Le xruyon jawra acha xemloj ta che nerey-a' ruk'ij Dios? Utz tc'ara' che aj Israel ta. ");
INSERT INTO tzjE_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","C'jara' cawra xbij tzra acha: —Camic catyictaja, utz chic ncatba. Jyukbal ac'u'x wq'uin jara' xchumsana awxin, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","J-e' aj fariseo cawra xecc'axaj tzra: —¿Nak k'ij xtoca rgobierno Dios? Ja' Jesús cawra xbij chca ra: —Je rgobierno Dios jara' mtetz'et ruq'uin ek'awech. ");
INSERT INTO tzjE_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Je' wnak majo'n xtecbij ta: —Tetz'ta' mpa', wawe' c'o wa' rgobierno Dios, o we xtecbij ta: —Tetz'ta' mpa', cala c'o wa' rgobierno Dios. Cara' quenbij chewa com kas bien tech'bo', je rgobierno Dios jara' c'o chic checjol camic, cara' xbij ja' Jesús chca aj fariseo. ");
INSERT INTO tzjE_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Je chca rdiscípulo cawra xbij: —Ixix nerla' na jun k'ij tak neyarij na nutz'et ri' ewech ruq'uin Rlec'walxel jxoca alxic cuq'uin wnak per jara' majo'n netz'et ta. ");
INSERT INTO tzjE_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ec'ola wnak cawra necbij chewa ra: —Tetz'ta' mpa', wawe' c'o wa' Cristo, cara' xtecbij chewa, o cawrara: —Tetz'ta' mpa', cala c'ola Cristo. Per tak cara' xtecbij chewa mtquixba ta cuq'uin, mtquixetre' el ta chquij. ");
INSERT INTO tzjE_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Cara' quenbij chewa com ajni' nuban jun queypa' tak nuq'uiek ri' chcaj chka bar tzra' ntz'e't wa', y cara' c'a chka' tzra Rlec'walxel jxoca alxic cuq'uin wnak, tak xtpet chic jmul wawe' chwech ruch'lew jara' ne njelal part ntz'ettaj wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Per je Rlec'walxel nc'atzina chcongan nutaj na lowlo' nabey mul, nc'atzina che ntzelax na nabey mul cmal wnak jec'ola chpam jawra tiemp jokc'o wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ajni' xbantaja pretiemp Noé ojer cara' c'a xtbantaja chic chka' tak xtpet chic jmul wawe' chwech ruch'lew je Rlec'walxel jxoca alxic cuq'uin wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Com je' wnak pretiemp Noé xe tzrij bnoj tak w-im elnak wa' quec'u'x y xje' c'ulbic quemjon je' rij tak xoca Noé chpam barc. Y chek q'uenjlal tak xpeta nimlaj k'jaljab chquij, congan lowlo' xba'na chca rmal ya' y xq'uisa quexla' conjelal. ");
INSERT INTO tzjE_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Y cara' xbantaja chka' pretiemp Lot. Je' wnak xe tzrij bnoj tak w-im elnak wa' quec'u'x, xe tzrij negocio más ebnak wa', xe tzrij je' tejco'n y xe tzrij bnoj tak jay bnak wa' quec'u'x. ");
INSERT INTO tzjE_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Per tak xel ta Lot chpam tnamet Sodoma jara' mism k'ij xkaj ta nimlaj k'ak' ruq'uin je' asufre y xercamsaj conjelal wnak jec'ola chpam tnamet. ");
INSERT INTO tzjE_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ajni' xqueban wnak pretiemp Lot cara' c'a quemjon rbanic wnak chka' tak xtpet chic jmul wawe' chwech ruch'lew je Rlec'walxel jxoca alxic cuq'uin wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tak xterla' k'ij je xtpet chic jmul Rlec'walxel, nak jec'ola pe rwá' terraza y je' cmibil pjay c'o wa', je nqueban jara' quenanmaj ela y me tquekaj pta ptak cuchoch che rlasic cmibil. Nak ec'ola ptak chnoj quenanmaj ela chka', me tquemloj pe chta ptak cuchoch. ");
INSERT INTO tzjE_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Terkaja bien pnewá' jxuban rexkayil Lot. ");
INSERT INTO tzjE_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nak jun npoknaj nuya' cana rc'aslemal jara' majo'n nuwil ta utzlaj c'aslemal je rxin junlic. Per nak jun majo'n npoknaj ta nuya' cana rc'aslemal jara' nuwil utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Anen quenbij chewa, chpam jara' chak'a' tak xtpet chic jmul wawe' chwech ruch'lew je Rlec'walxel ec'ola e c-e' ewarnak chwech ch'at chak'a', jun nec'mar ela y jun ncanaj cana. ");
INSERT INTO tzjE_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ec'ola e c-e' ixki' xjunam ec'o wa' quemjon rij c-em, jun nec'mar ela y jun ncanaj cana. ");
INSERT INTO tzjE_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ec'ol c'a e c-e' ach-i' xjunam ec'o wa' pe chnoj, jun nec'mar ela y jun ncanaj cana, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","—¿Abar tzra' nbantaj wa' jala jxabij chka? Cara' xecc'axaj tzra. Jesús cawra xbij chca: —Je juicio npors nkaj tna ajni' nqueban c'uch, xabar opech ec'o wa' camnak tak chcop tzra' nque'ekaj wa'. Cara' xbij Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","C'jara' c'ola jun c'ambal tzij xbij chca je nc'utbej chquewech che nc'atzina chca chmajo'n nectenba' ta rbanic oración, nc'atzina chmajo'n nturtaj ta quec'u'x. ");
INSERT INTO tzjE_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Cawra jc'ambal tzij xbij chca ra: —C'ola jun juez c'ola chpam jun tnamet, arja' majo'n nxibej ta ri' chwech Dios y nmajo'n nxibej ta ri' chquewech wnak chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","C'ola jun ixak melca'n chpam jara' tnamet, arja' c'ola jun wnak remjon rij ch'oj ruq'uin. Ja' melca'n tzra' y ne tzra' nekaj wa' ruq'uin juez nerc'utuj rto'ic tzra che nto'a pruk'a' jnebnowa ch'oj ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ja' juez c'ola jun tiemp nmajo'n xuto' ta melca'n per tak xq'uisbena cawra xbij kaja pranm: —Mesque nmajo'n quenxibej ta wi' chwech Dios y next quenxibej wi' chquewech wnak chka' ");
INSERT INTO tzjE_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","per com ne mtela wq'uin jala ixak mejor quento' na pruk'a' jnebnowa ch'oj ruq'uin. Je wmajo'n xtento' ta mexla nmajo'n xtquenruya' cta y xe nc'owa nuc'u'x pruk'a', cara' xbij kaja ja' juez. Cara' nbij jc'ambal tzij. ");
INSERT INTO tzjE_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bien tech'bo' rij rwech je xbij juez. Arja' jun juez jmajo'n nuban ta rbeyal rxin Dios per xbij chnuto' na jmelca'n. ");
INSERT INTO tzjE_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Peor c'ara' Dios ¿le mtqueruto' c'ara' tnamet jrech-on je ntajina necc'utuj cto'ic tzra che pk'ij y chak'a'? ¿Lnuya' más tiemp chca che cto'ic? ");
INSERT INTO tzjE_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Anen quenbij chewa che nqueruto' alnak. Per je Rlec'walxel jxoca alxic cuq'uin wnak, tak xtpet chic jmul wawe' chwech ruch'lew ¿le c'o nc'ara' wnak ykula quec'u'x ruq'uin? cara' xbij Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ec'ol c'a jle' wnak xcuq'uin kaja j-e' ykul wa' quec'u'x, kas quebnon rbeyal rxin Dios nquech'ob kaja y xitzel nquequetz'et jle' chic wnak. Ja' Jesús c'ola jun c'ambal tzij xbij chca cawrara. ");
INSERT INTO tzjE_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ec'ol c'a e c-e' ach-i' xqueban jmul xeba chpam nimlaj templo rxin Dios che rbanic oración. Jun aj fariseo, jun chic arja' mloy impuesto. ");
INSERT INTO tzjE_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tak xe'ekaja chpam templo xpe'a aj fariseo y xumaj rbanic oración per xyabal ruk'ij xuban kaja ruyon, cawra oración xuban kaja: —Anen quenmeltioxij chawa neDios jme ok junam ta cuq'uin chic nic'aj wnak, ajni' elk'oma', ajni' jmajo'n nqueban ta rbeyal rxin Dios, ajni' chca je nque'oca cuq'uin ixki' jme e quexkilal ta. Quenmeltioxij chawa chka' jme ok junam ta ruq'uin jala acha je mloy impuesto. ");
INSERT INTO tzjE_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Anen camul ayuno quenban jun sman, chka' njelal mibil je noca pnuk'a' nelsan nediezmo tzrij y ney-on chawa. Cara' xbij aj fariseo. ");
INSERT INTO tzjE_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Je mloy impuesto arja' q'ue c'nat xec'je' pon wa', xtquemyij ruplaj, nexte xca'y nara' chcaj. Xumaj c'a jun nimlaj bis y cawra oración xuban: —Tpoknaj nwech Dios com anen xe en jun aj-il aj mac. Cara' xbij mloy impuesto. ");
INSERT INTO tzjE_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Camic quenbij chewa, je mloy impuesto arja' xemloja chruchoch y Dios nbij tzra che xuban rbeyal y mja' ta aj fariseo jxuban rbeyal. Cara' rbanic com nak wnak xruyon nuya' kaja ruk'ij jara' nkasax na. Wnaban ch'it co'l jara' nya' na ak'ij, cara' xbij Jesús chca wnak je xqueyon j-e' nqueya' kaja quek'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ec'ol c'a nic'aj ch'tak ac'ala' xec'mar ela ruq'uin ch-utz c'ara' nuya' ruk'a' pquewá'. Per je' rdiscípulo arj-e' xquech'aj pquewá' jec'amyon ela cxin. ");
INSERT INTO tzjE_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ja' Jesús xeruc'ul ch'tak ac'ala' y cawra xbij ra: —Tey-a' c'as chca ac'ala' nquepeta wq'uin, mtque'ech'ojquij ta com je' wnak je e'ocnak e ajni' ch'tak ac'ala' cxin c'a arj-e' je rgobierno Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Anen ne ktzij wa' je xtenbij chewa, nak jun majo'n xtuban ta ch'it co'l che rnimaxic rgobierno Dios ajni' nuban jun ac'al jara' majo'n noc ta chpam rgobierno Dios, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","C'ol c'a jun acha nim ruk'ij cawra xbij tzra Jesús: —Maestro, atet congan at utzlaj acha. ¿Nak quenban ch-utz c'ara' nyataja chwa utzlaj c'aslemal je rxin junlic? cara' xc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","—¿Nak tzra tak nabij chwa che en utzlaj acha? Xjun oca kas utz, jara' Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Atet awutkin rmandamiento Dios jtz'ibtanak cana jcawrara nbij: —Me tcatoc ta ruq'uin jun ixak wmawexkayil ta, y jun ixak mtoc ta ruq'uin jun acha je mrechjil ta, mtaban ta cmic, mtaban ta alak', mtaya' ta testig we xme ktzij ta nabij, que'animaj adta' ate' chka'. Cara' nbij rtzojbal Dios, cara' xbixa tzra ja' acha rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Jala jxabij kaja nemjon wa' rnimaxic, q'uen co'l nemjon pa rij, cara' xbij ja' acha. ");
INSERT INTO tzjE_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ja' Jesús tak xc'axaj je xbij acha cawra xbij chic tzra: —Per c'c'o na jmajo'n abnon ta. Tc'ayij cana njelal jc'ola awq'uin, je rjel tey-a' cana chca ch'tak mibi'. Wcara' naban jara' c'ola amibil nyataja chawa chcaj. Tak xtbantaja awmal jxenbij chawa catemloj ta wq'uin y catetre' ta chwij, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ja' acha tak xc'axaj je xbixa tzra rmal Jesús xumaj jun nimlaj bis com congan jun nimlaj mibil ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ja' Jesús tak xutz'et chcongan nbisona cawra xbij: —Je' byoma' congan pen chca che nque'oca chpam rgobierno Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ajni' tzra jun nimlaj chcop jcamello, arja' congan pen noc wa' pe rchak jun dsonbal bak, per jara' mpen ta noc wa' que chwech jun byom noca chpam rgobierno Dios, cara' xbij ja' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jxec'axana rxin cawra xecbij tzra ra: —Jun byom wcongan pen noc wa' chpam rgobierno Dios ¿e achnak c'ara' nquewlowa totanem rxin Dios? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús cawra xbij chca: —C'ola je' achnak congan pen rbanic chquewech wnak per chwech Dios majo'n pen ta. ");
INSERT INTO tzjE_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro cawra xbij tzra: —Je chka ajoj, njelal jc'ola kuq'uin kay-on cana y okocnak adiscípulo, nokotren wa' chawij, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús cawra xbij chca: —Ne ktzij wa' je xtenbij chewa, je' wnak chka bechnak wnak opech wquey-on cana cuchoch, quey-on cana quedta' quete', o quenmal, o quechak', o cana', o wquey-on cana quexkilal, o clec'wal, we rmal rgobierno Dios tak quey-on cana, ");
INSERT INTO tzjE_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","jara' más chna q'uiy nyataja chca chpam jawra tiemp jokc'o wa' que chwech ajni' quey-on cana. Y chpam tiemp jpenak nyataj na chca utzlaj c'aslemal je rxin junlic. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","C'jara' xeryonaj ri' cuq'uin e cbeljuj apóstol y cawra xbij chca: —Bien tewc'axaj je xtenbij chewa, camic okobnak pJerusalén. Tzra' nbantaj wa' cumplir njelal jtz'ibtanak cana cmal e ojer tak profeta rxin Dios tzrij Rlec'walxel jxoca alxic cuq'uin wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Com je Rlec'walxel arja' nja'ch na pquek'a' wnak jme aj Israel ta, nyo'k' na, ntz'u'j na, nchubax na ruplaj. ");
INSERT INTO tzjE_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","C'jara' xtquech'ay. Tak xtch'aytaja cmal neccamsaj, y chrox k'ij nc'astaja rwech, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","J-e' apóstol nmajo'n xch'obtaj ta cmal je xbixa chca, xwiwan chquewech, majo'n xoc ta ptak quexquin. ");
INSERT INTO tzjE_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Xyamer nekaja ja' Jesús chpam tnamet Jericó tak c'ola jun acha moy xuwil, tz'bula chi' bey, remjon rc'utxic limosna chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ja' moy tak xc'axaj chcongan wnak nquek'axa pbey cawra xbij: —¿Nak xbantaja? ");
INSERT INTO tzjE_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Xpeta Jesús je aj Nazaret, cara' xbixa tzra cmal wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","C'jara' xumaj rakic ruchi': —Jesús, atet je at Rlec'wal ojer rey David, tpoknaj jtz'it nwech, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Je' wnak je e nabyela chwech nquech'aj pe rwá': —Xjun catec'je' wa', mtarak ta achi', cara' nbixa tzra ja' moy. Per arja' más chna xurak ruchi' tzrij Jesús: —Atet je at Rlec'wal ojer rey David, tpoknaj jtz'it nwech, cara' xbij chic jmul. ");
INSERT INTO tzjE_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ja' Jesús xpe'a, xutak rsic'sic moy. Tak xekaja ch'it moy ruq'uin cawra xbij tzra: ");
INSERT INTO tzjE_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Nak nawajo' chwa chquenban chawa? —Wajaw, quenwajo' chawa che njaktaja nk'anwech, cara' xbixa tzra rmal moy. ");
INSERT INTO tzjE_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Camic catca'ya. Jyukbal ac'u'x wq'uin jara' xatchumsana, cara' xbij Jesús tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chek xbitaja cara' tzra ne xjaktaja alnak rk'arwech y xetre' ela tzrij Jesús, congan nuya' ruk'ij Dios. Je' wnak tak xquetz'et milagro je xbantaja arj-e' xquemaj rya'ic ruk'ij Dios chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","C'jara' xoca Jesús chpam tnamet Jericó y xek'axa chpam. ");
INSERT INTO tzjE_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","C'ol c'a jun acha byom, Zaqueo rubi', arja' cjefe e mloy tak impuesto. ");
INSERT INTO tzjE_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ja' Zaqueo congan xutaj ruk'ij ch-utz c'ara' nutz'et rwech Jesús per mesquier necwina com congan e q'uiy wnak y ja' xch'it co'l rkan. ");
INSERT INTO tzjE_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jxuban xba alnak, xnabyej ela y xojte'a per rwá' jun che' ch-utz c'ara' necwina nutz'et rwech Jesús com ja' Jesús npors nk'ax na xuxe' che'. ");
INSERT INTO tzjE_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ja' Jesús tak xekaja tzra' xutz'et pona Zaqueo pe rwá' che' y cawra xbij tzra: —Catkaj ta alnak Zaqueo, nc'atzina che anen quenba pnawuchoch camic ra, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ja' Zaqueo xkaj ta alnak, xuc'ul Jesús pruchoch y congan nquicota. ");
INSERT INTO tzjE_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Je' wnak tak xquetz'et che xoca Jesús pruchoch jun mloy impuesto c'jara' conjelal xquemaj rtzojxic: —Xe pruchoch jun aj-il ajmac xoc wa', cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ja' Zaqueo xpe'a y cawra xbij tzra Kajaw Jesús: —Jcamic Wajaw, xench'ob che c-e' quenban tzra nmibil y quensipaj nic'aj chca ch'tak mibi'. Chka' c'ola je' xenk'axaj rwá' impuesto jxenc'utuj chca wnak per camic quenmeloj cji' ctak ra' ajni' xenwelk'aj chca, cara' xbij Zaqueo. ");
INSERT INTO tzjE_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ja' Jesús cawra xbij tzra: —Camic xawil totanem rxin Dios, chka' conjelal jec'ola pnawuchoch, com atet at rlec'wal Abraham chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Xattotaja com Rlec'walxel jxoca alxic cuq'uin wnak arja' penak che cconxic je' wnak jetzaknak chpam il mac ch-utz c'ara' nquewil totanem rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Je' wnak arj-e' quemjon rc'axic nak nbij Jesús. Ja' Jesús com xchenkaj tnamet Jerusalén c'o chwa' y com je' wnak nquech'ob che xyamer noca rgobierno Dios rmal c'ara' tak xbij jun c'ambal tzij cawrara: ");
INSERT INTO tzjE_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—C'ola jun acha nim ruk'ij arja' xba chpam jun chic nación q'ue c'nat c'o wa' ch-utz c'ara' nja'ch ta gobierno pruk'a' y noca rey. Tak xtjachtaj ta gobierno pruk'a' c'jara' nemloj pchic jmul. ");
INSERT INTO tzjE_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tak q'uemjana tba ec'ola e ljuj chca rmos xersiq'uij, xujach cana nic'aj pak pquek'a', jujun pak xuya' cana chca chejujnel y cawra xbij chca: —Temja' rsamajxic pak, y emjon ta rsamajxic tak xtquenpet chic jmul, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Per ja' acha xitzel ntz'e'ta cmal retnamet rmal c'ara' arj-e' xquetak ela rbixic chpam nación abar xteja'ch twa' pruk'a' jgobierno: —Ajoj majo'n kgan ruq'uin jala acha che noca krey, cara' xecbij ela. ");
INSERT INTO tzjE_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tak xq'uisbena xemloj ta acha, ocnak pchic rey. Xutak csic'sic rmos jrejchon cana pak pquek'a' com nrajo' nrutkij ajni' quech'con chic tzrij pak chejujnel. ");
INSERT INTO tzjE_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Xpeta jun mos y cawra xbij: —Wajaw, jpak jxajach cana pnuk'a' xench'ec ljuj ctakra' tzrij ajni' xaya' cana chwa, cara' xbij tzra rey. ");
INSERT INTO tzjE_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ja' rey cawra xbij tzra ra: —Utz xaban tzra asamaj, atet at jun utzlaj mos, ajni'la naban cumplir asamaj. Xe mnim ta xenya' cana chawa per xaban cumplir. Rmal c'ara' ljuj tnamet quenya' pnak'a' camic che ncatoca k'toy tzij chquij, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Xpet chic jun mos: —Wajaw, jpak jxajach cana pnuk'a' j-o' chic ctakra' xench'ec tzrij je ajni' xaya' cana chwa, cara' xbij tzra rey. ");
INSERT INTO tzjE_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","—Atet chka', j-o' tnamet quenya' pnak'a' camic che ncatoca k'toy tzij chquij, cara' xbij rey tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","C'ol c'a jun mos xpeta y cawra xbij tzra rey ra: —Apak c'awra Wajaw. Tak xajach cana chwa xenxim chpam jun su't y chpam neycon wa' camic. ");
INSERT INTO tzjE_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Cara' xenban tzra com anen xenxibej wi' chawech com atet at jun acha c'a'n. Atet xe tzrij ch'coj pak elnak twa' ac'u'x y majo'n samaj naban, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Rey cawra xbij tzra: —Atet xat jun itzel mos. Jtzij je c'ja' xabij kaja jara' quenk'etbej tzij chawij camic. We awutkin che en c'a'n, we awutkin xe tzrij ch'coj pak elnak twa' nuc'u'x y majo'n samaj quenban ");
INSERT INTO tzjE_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿nak tzra c'ara' mxaya' ta npak pbanco? Wext cara' xaban, tak xenpeta xja'ch tc'ara' npak chwa rexbil ral, cara' xbij tzra mos. ");
INSERT INTO tzjE_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ec'o c'a jle' ajsmajma' epa'l oca prexquin, cawra xbij chca ra: —Camic temja' pak tzra, tey-a' tzra jc'ayona ljuj, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","—Per Kajaw, arja' c'o chic ljuj ruq'uin, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","—Camic quenbij chewa che conjelal wnak jc'ola yatanak chca, arj-e' nyataj na más chca. Je' wnak jmajo'n achnak yatanak chca per j-e' nquech'ob chc'ola jara' nelsasa chca. ");
INSERT INTO tzjE_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Je' wnak xitzel quenquetz'et y majo'n cgan chquenoca crey que'ec'ma' ta camic, nchenwech que'ecamsaj wa', cara' nbij ja' rey chca ajsmajma'. Cara' c'ambal tzij xbij ja' Jesús chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tak xbitaja rmal c'jara' xumaj el chic rubey xba pJerusalén, ja' xnabyej ela chquewech wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tak xe'ekaja chenkaj c-e' tnamet Betfagé ruq'uin Betania abar c'o wa' jyu' je rbin-an Olivo ec'ola e c-e' chca rdiscípulo xerutak ela. ");
INSERT INTO tzjE_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Y cawra xbij ela chca: —Jax chpam jala tnamet, tzra' newil wa' jun ch'it bur xmila y nexte wjic tz'ulben cmal wnak. Tecra' ta y tec'ma' ta. ");
INSERT INTO tzjE_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Wc'ola jun nak xtc'axana chewa: —¿Nak tzra tak nequir bur? cara' xtc'axaj chewa, ixix cawra nebij tzra: —Nc'atzina tzra Kajaw, cara' tbij tzra. Cara' xbij ela Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Je c-e' discípulo jxeta'k ela xeba, y tak xe'ekaja ncara' xela ajni' bin ela chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kas quemjon rquiric ch'it bur tak xek'ijloxa cmal rajaw: —¿Nak tzra tak nequir ch'it bur? cara' xc'axaxa chca. ");
INSERT INTO tzjE_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Nc'atzina tzra Kajaw, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","C'jara' xquec'om pa ch'it bur. Jquetziak jara' xecwekbej y xectz'uba' pa Jesús tzrij. ");
INSERT INTO tzjE_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Xumaj binem. Je' wnak arj-e' xecsocla' quetziak prubey Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tak chenkaj ec'o chwa' che nque'ekaja chpam tnamet Jerusalén abar nexle' wa' bey chwech jyu' Olivo conjelal discípulo xquemaj rakic quechi' rmal quicotemal, congan xquemaj rya'ic ruk'ij Dios rmal njelal nmak tak milagro jquetz'ton, ");
INSERT INTO tzjE_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","cawra necbij ra: —Bendecido jRey jpenak prubi' Kajaw Dios. Chcaj camic congan qui'il, ajni'la ntajina nya'a ruk'ij nimlaj Dios, cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ec'o c'a jle' fariseo chquecjol wnak cawra xecbij tzra Jesús ra: —Maestro, tbij chca adiscípulo che quetne'a, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","—Camic quenbij chewa, we j-e' nquetne'a che rya'ic nuk'ij, je' abaj pors c'ara' nquemaj rya'ic nuk'ij, cara' xbij ja' Jesús chca aj fariseo. ");
INSERT INTO tzjE_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Xyamer nque'ekaja pJerusalén. Ja' Jesús tak xutz'et pona tnamet xumaj rij ok'ej tzrij. ");
INSERT INTO tzjE_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Cawra xbij ra: —Ixix jix tnamet Jerusalén, ne tcongan quicotemal chewa chpam jawra k'ij jokc'o wa' wexte nch'obtaja ewmal abar newil wa' je qui'il nec'je'a awanm chwech Dios. Per camic mtch'obtaja ewmal com xwiwan chewech. ");
INSERT INTO tzjE_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Congan quenbisona ewmal com nerla' jun tiemp tak xtquepeta chewij je' wnak je nquetzelana ewxin. Tak xtquerkaja nqueyic na jun nimlaj tz'ak tzrij njelal tnamet rxin banbal ch'oj, necsutij qui' chewij, nectz'apij njelal bey ch-utz c'ara' mesquier nquixecwina nquixnanmaj ela. ");
INSERT INTO tzjE_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Neckasaj na ptak ulew je tnamet per nche njelal, congan lowlo' nqueban na chewa jixc'ola chpam, per next jun jay mquita xtqueyoj. Cara' c'a xtba'na chewa com mesquier nch'obtaja ewmal che Dios xrec'je' kaja ewq'uin che cto'ic. Cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tak xekaja chpam tnamet Jerusalén xoca chpam nimlaj templo rxin Dios y xumaj ta clasic wnak jquemjon c'yinem chpam y chka' e quexbil jquemjon lk'oj tak achnak. ");
INSERT INTO tzjE_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Cawra xbij chca: —Chpam rtzojbal Dios cawra tz'ibtanak cana: —Jwuchoch anen jara' banbal oración, cara' nbij Dios tzrij templo, per je ebnon ixix tzra xjun lwar abar nquec'je' wa' elk'oma', cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","K'ij k'ij nquertijoj wnak chpam templo. Per je' maestro je nquetijona cxin wnak tzrij rley Dios e quexbil cjefe sacerdote arj-e' xquemaj rconxic rij rwech nak nqueban tzra che neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Per mesquier necneya cmal nak nqueban tzra com conjelal wnak congan quey-on oca quexquin tzrij je nbij. ");
INSERT INTO tzjE_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kas remjon ctojxic wnak tzrij utzlaj tzij jrec'mon ta totanem rxin Dios tak xe'erkaja cjefe sacerdote e quexbil maestro je nquetijona cxin wnak tzrij rley Dios e quexbil chka' principal-i' rxin tnamet. ");
INSERT INTO tzjE_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Cawra xecbij tzra: —Tbij chka ¿nak abanic atet tak amjon rbanic njelal jawrara jkamjon rtz'etic y nak yoyona chawa chnaban? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","—Anen chka' quenwajo' quenc'axaj jawra chewa. Camic tbij chwa, ");
INSERT INTO tzjE_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","je Juan Bautista ¿nak xyowa tzra jsamaj che nqueruban bautizar wnak, lja' Dios jc'ola chcaj je xyowa tzra, o wxe wnak? cara' xc'axaxa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Arj-e' xquemaj tzij chbil tak qui': —We xtekbij tzra che Dios xyowa tzra, arja' nbij chka: —Wcara' ¿nak tzra c'ara' tak mxenimaj ta? cara' nbij chka la'. ");
INSERT INTO tzjE_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y we xtekbij tzra che xe wnak xyowa tzra jara' xnokcomsasa tzan abaj cmal wnak com chquewech arj-e' je Juan arja' jun profeta rxin Dios, cara' xecbij kaja. ");
INSERT INTO tzjE_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Cawra xecbij tzra Jesús: —Majo'n kutkin ta nak la xyowa tzra, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","—Nexte anen chka' xtenbij ta chewa nak nbanic jnemjon rij njelal jawrara je emjon rtz'etic, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","C'jara' xumaj rbixic jun c'ambal tzij chca wnak cawrara: —C'ola jun acha c'ola jun rchinoj, uva retcon chwech. Xuya' pe kjonem chca jle' ajchental, xba chpam jun chic tnamet y tzra' xec'je' wa' jun tiemp. ");
INSERT INTO tzjE_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tak xerla' tiemp je nwachina tejco'n arja' xutak ela jun rmos cuq'uin ajchental che nerec'ma' jrent. J-e' ajchental tak xekaja mos cuq'uin xquech'ay pa, y tak xemloj ta nmajo'n achnak xqueya' pa tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jrajaw chnoj c'o chic jun mos xutak ela cuq'uin y tak xekaj chic arja' cuq'uin xquech'ay pa chka', nlowlo' xqueban pa tzra, y tak xemloj ta nmajo'n achnak xqueya' pa tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jrajaw chnoj xutak el chna jun y tak xekaja cuq'uin congan lowlo' xqueban pchic tzra chka', xquesoc y xecbettaj ta. ");
INSERT INTO tzjE_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tak xq'uisbena cawra xbij rajaw chnoj: —¿Nak quenban c'a wa' camic? Com c'ola jun wlec'wal jcongan quenwajo' jara' quentak ela cuq'uin chic. Tak xtquetz'et che wlec'wal mal-il xtqueban respetar, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Per j-e' ajchental tak xekaja rlec'walxel cuq'uin cawra xecbij chbil tak qui': —Jala acha noc na pruk'a' julew com reherencia. Camic kcamsaj ch-utz c'ara' pkak'a' ajoj noc wa' reherencia, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","C'jara' xquewsaj ta chpam chnoj y xeccamsaj. Cara' nbij c'ambal tzij, cara' xbij Jesús chca. C'jara' cawra xbij chic chca: —Camic tbij c'a chwa, jrajaw chnoj ¿nak nuban c'ara'? ");
INSERT INTO tzjE_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Jnuban, arja' npeta y nquercamsaj ajchental, y je rchinoj nuya' chic jmul pe kjonem chca jle' chic ajchental, cara' xbij chca. Je' wnak tak xecc'axaj je xbij Jesús cawra xecbij tzra ra: —Jxabij kaj la congan lowlo', mquita xtba'n ta cumplir, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ja' Jesús xera' xertz'ulchij y cawra xbij chca ra: —Nak tzra mquita xtbantaja cumplir com cawra tz'ibtanak cana chpam rtzojbal Dios: —Je e bnoy jay c'ola jun abaj majo'n cgan tzrij y xecch'ojquij, per jara' abaj csan chic che rbanic jay, arja' más na nim ruk'ij com arja' nechpowa resquin-il jay, cara' nbij rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nak jun xitzel nutz'et jara' abaj jxenbij chewa jara' xe ntz'ila' ri' rmal ajni' nuban jun acha nchak'ij rkan chwech jun abaj y nk'aja. Y nak nk'e'ta tzij tzrij rmal abaj jxenbij chewa jara' ajni' nuban jun acha ntzak ta jun abaj tzrij y nchicaj ri' rmal, cara' xbij Jesús chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Je cjefe sacerdote e quexbil maestro rxin ley, tak xecc'axaj c'ambal tzij bien xch'obtaja cmal che arj-e' nquebixa. Rmal c'ara' tak njara' hor xcajo' ta xquechap Jesús y xquecsaj ta preso per xecxibej qui' chquewech wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Xquemaj rconxic rij rwech nak nqueban tzra. Ec'ola jle' wnak xequetak ela ruq'uin chnequebna' rij rwech y j-ewra wnak xeck'alsaj qui' chwech che e utzlaj tak wnak ch-utz c'ara' c'o ta jun tzij nel ta pruchi' y njara' tzij necchapbej rxin, com ncajo' nquejach pruk'a' gobernador ch-utz c'ara' nk'e'ta tzij tzrij. ");
INSERT INTO tzjE_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tak xe'ekaja ruq'uin cawra xecbij tzra: —Maestro, ajoj kutkin ne rbeyal wa' jamjon rbixic, ne rbeyal wa' jtijonem jamjon rya'ic. Ajoj kutkin che atet nmajo'n jun utz y nmajo'n jun itzel ta natz'et, per nrubey Dios amjon rc'utic chkawech y nwen naban tzra che rbixic. ");
INSERT INTO tzjE_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Camic tbij chka, jimpuesto je nc'utuxa chka rmal César jnimlaj rey rxin Roma ¿lrubey c'ara' nkatoj, o we mrubey ta? Cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Per Jesús arja' bien rutkin che xe engaño quemjon rij y cawra xbij chca ra: —¿Nak tzra tak newajo' cneban probar? ");
INSERT INTO tzjE_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tec'tu' jun pak chenwech, cara' xbij chca. Tak xquec'ut pak chwech cawra xbij chca: —¿Nak chuxin plaj jc'ola chwech pak y nak chuxin bi'aj tz'ibtanak chwech chka'? cara' xbij chca. —Rxin César, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nak rxin César tzra c'ara' César tey-a' wa', nak rxin Dios tzra Dios tey-a' wa', cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nmajo'n jun tzij xel ta pruchi' jnecchapbej rxin chquewech wnak. Congan xel ta canm tzrij tak xecc'axaj je xbixa chca, nmajo'n chic achnak xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","C'jara' ec'ola jle' saduceo xeba ruq'uin. J-e' aj saduceo majo'n necnimaj ta che nquec'astaja cnomki'. Tak xe'ekaja ruq'uin cawra xecbij tzra: ");
INSERT INTO tzjE_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestro, Moisés rbin cana chka chpam rtzojbal Dios wc'ola jun acha ncoma ruchak', o renmal, y nmajo'n jun rlec'wal nec'je' cana, jara' acha nc'atzina che nec'le'a ruq'uin ixak je xcoma rechjil. Arj-e' wxec'je'a jun clec'wal necbij tzra jara' ac'al che rlec'wal comnak. ");
INSERT INTO tzjE_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Xuban c'a jmul ec'ola e wku' alxic, jnabey-al xec'le'a per xcoma y majo'n rlec'wal xec'je' cana. ");
INSERT INTO tzjE_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ajni' xuban nabey-al cara' xuban chic rcabal, xcom chic chwech ixak, nmajo'n rlec'wal xec'je' cana. ");
INSERT INTO tzjE_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Cara' xuban rox chka'. Y cara' xqueban che wku', xec'le'a ruq'uin ixak y xecoma chwech, nmajo'n clec'wal xec'je' cana. ");
INSERT INTO tzjE_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tak xq'uisbena xcoma ixak chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Camic ¿nak nabij atet tzrij jawra? J-ewra e wku' alxic tak xterla' k'ij che nquec'astaja chpam cmic ¿nak jun chca ra rechjil jixak com xec'le'a cuq'uin che wku'? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ja' Jesús cawra xbij chca: —Je' wnak je nquec'je'a chpam jawra tiemp rxin rwech ruch'lew arj-e' nquec'le'a. ");
INSERT INTO tzjE_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Per je' wnak je xtec'je'a chpam jun chic tiemp jpenak tak xtyataja chca che nquec'astaj na chquecjol cnomki' arj-e' majo'n chic c'ulbic nqueban ta. ");
INSERT INTO tzjE_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Majo'n chic nquec'le' ta com majo'n chic cmic chquij. Majo'n chic cmic chquij com e ajni' chic e ángel, e rlec'wal chic Dios com ec'astanak chic. ");
INSERT INTO tzjE_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Chka' jun chic jquenwajo' quenbij chewa, tz'ibtanak cana chpam rtzojbal Dios rmal Moisés chka' tzrij c'astajic cxin wnak. Jara' tak xutz'et jle' xulquiej Moisés y xtzijon ta Dios chpam, cawra xbixa tzra rmal Kajaw Dios: —Anen en Dios rxin Abraham, en Dios rxin Isaac, en Dios rxin Jacob, cara' xbixa tzra Moisés. ");
INSERT INTO tzjE_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tak cara' nbij jara' nc'utbej chewech che j-e' mesque ecomnak chic per chwech Dios ec'asla. Chwech Dios ec'asla conjelal, cara' xbij ja' Jesús chca aj Saduceo. ");
INSERT INTO tzjE_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ec'ol c'a jle' maestro rxin ley cawra xecbij tzra ra: —Maestro, jxabij kaja jala nrubey wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Majo'n chic achnak xecc'axaj tzra Jesús com necxibej chic qui' necc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","C'jara' cawra xc'axaj chca: —¿Nak tzra tak nbixa tzra Cristo che arja' rlec'wal ojer rey David? ");
INSERT INTO tzjE_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Cara' quenbij chewa com David c'ola jun salmo rbin cana chpam rtzojbal Dios cawrara: —Ja' Kajaw Dios cawra xbij tzra Wajaw: —Catetz'be'a wawe' pwejquenk'a', wawe' ncatec'je' wa' ");
INSERT INTO tzjE_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","y quenuya' na pnawkan je nquetzelana awxin, cara' xbij tzra. Cara' rbin cana ja' David. ");
INSERT INTO tzjE_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ja' David: —Wajaw, cara' xbij tzra Cristo, camic tbij c'a chwa ¿nak tzra tak xbixa tzra Cristo che rlec'wal David? Cara' xc'axaj Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","C'jara' xumaj tzij cuq'uin rdiscípulo per ne chquewech wnak xtzijon wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Tebna' cwent ewi' chquewech maestro je nquetijona cxin wnak tzrij rley Dios. Com arj-e' congan nel ta quec'u'x tzrij tak nquebina chquewech wnak, quecsan nmak tak tziak jnec'tuwa cxin che e nmak tak maestro. Y c'o na más jcongan nel ta quec'u'x tzrij ajni' tzra tak nquek'ijloxa cmal wnak ptak q'uebal, ajni' tzra tak nqueba ptak jay rxin molbal ri'il jabar nc'axax wa' rtzojbal Dios arj-e' neccanoj nabey tak tz'ulbal je nmak ruk'ij y cara' nqueban chka' tak nqueba'na invitar chpam nmak tak w-im. ");
INSERT INTO tzjE_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Arj-e' nk'alaj bien je nquemaj cuchoch ch'tak melcani' je comnak quechjilal. C'ola nmak tak oración nqueban per nquechi' oca nbina. Per tak xtek'e'ta tzij chquij rmal Dios nquetaj na jun nimlaj lowlo'. Cara' xbij Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","C'jara' ec'ola jle' byoma' xerutz'et pona, arj-e' quemjon rya'ic ofrenda chpam rc'olibal tak ofrenda. ");
INSERT INTO tzjE_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","C'ol c'a jun ixak melca'n xutz'et y ch'it miba', arja' c'ola c-e' ch'tak pak rc'an y xuya' chpam rc'olibal ofrenda. ");
INSERT INTO tzjE_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús cawra xbij: —Tetz'ta' mpa' jala melca'n ixak, jxuya' chpam rc'olibal ofrenda jara' más na nim ruk'ij chwech Dios que chwech ajni' xqueya' conjelal jle' chic. ");
INSERT INTO tzjE_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Cara' quenbij chewa com jle' chic xjara' xqueya' tzra Dios jcoltanak cana per ja' mesque xmiba' per xuya' njelal jc'ola ruq'uin je ntzukbej ri' tzra, cara' xbij ja' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ec'ol c'a jle' quemjon rtz'etic nimlaj templo rxin Dios y cawra necbij ra: —Congan wen rbanic jala templo, congan wen tak abaj ocnak y c'ola wen tak achnak rc'an chka' jsipan cmal wnak, cara' necbij. Ja' Jesús cawra xbij chca ra: ");
INSERT INTO tzjE_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Jemjon rtz'etic nerla' na jun k'ij tak nyojtaja njelal y nmajo'n chic abaj xtrejkla' xta ri', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","—Maestro, tbij chka ¿nak k'ij nbantaja jxabij kaja chka? Chka' ¿nak rital nwankera je nc'utbej rxin che xyamer nbantaja njelal jxabij kaja chka? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Cawra xbij chic chca: —Kas tebna' cwent ewi', majo'n jun xtquixebnowa engañar. Cara' quenbij chewa com e q'uiy wnak nquepe na y xqueyon j-e' necbij kaja che j-e' e Cristo, cawra necbij chca wnak ra: —Anen en Cristo, cara' necbij chca, o wcawra: —Xerla' tiemp che npeta Cristo, cara' xtbixa chewa. Per ixix mtenimaj ta jnecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","C'ola nmak tak ch'oj xtba'n na, chka' e q'uiy wnak xtqueyictaj na tzrij cgobierno per tak xtekaja rbixic ewq'uin mtexibej ta ewi' rmal com ne nc'atzin wa' che nbantaja cumplir njelal jawrara nabey mul, per jawra me rq'uisbal ta rwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","C'ola je' tnamet nyictaj na tzrij jle' chic tnamet, chka' je' gobierno nyictaj na tzrij jle' chic gobierno. ");
INSERT INTO tzjE_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","C'ola nmak tak cbarkan xtbantaj na, chka' c'ola nmak tak lowlo' nwankera chpam je' lwar ajni' nmak tak wyejal y nmak tak yublal. C'ola je' rital xtwanker na chcaj congan necxibej na qui' wnak rmal. ");
INSERT INTO tzjE_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Per tak q'uemjana tbantaja cumplir njelal jawrara jxenbij kaja chewa c'ola lowlo' netaj na pquek'a' wnak. Nquixquechap na, nquixc'ax na ptak jay rxin molbal ri'il y nquixquecsaj pcars, nquixquec'om ela chquewech rey y chquewech je' gobernador, per nmal anen tak xtba'na cara' chewa. ");
INSERT INTO tzjE_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Per mchek tcara' nquixec'mar ela chquewech rey ruq'uin chquewech je' gobernador com tzra' nquixecwin wa' nemaj nbixic chquewech. ");
INSERT INTO tzjE_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Per bien tech'bo' kaja ptak ewanm camic chmajo'n nc'atzin ta chewa che xtech'ob pon ta nak chtzij xtetobej ewi' chquewech. ");
INSERT INTO tzjE_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Com anen quenyowa chewa nak chtzij xtebij chca, anen quenyowa ena'oj tzra'. Rmal c'ara' tak je nquetzelana ewxin majo'n chic necney ta cmal nak xtecbij chic chewa, netz'apij quechi'. ");
INSERT INTO tzjE_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nquixja'ch na pquek'a' je nquetzelana ewxin cmal edta' ete', cmal ewch'alal y cmal ewamigo chka', ec'ola nquecamsasa chewa. ");
INSERT INTO tzjE_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Xitzel nquixtz'e't na cmal conjelal wnak per nmal anen tak cara' xtba'na chewa. ");
INSERT INTO tzjE_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Per jara' nexte c'o ta jun resmal ewá' xttzak ta chwech Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","We xtecoch' je xtpeta chewij jara' newil utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Je tnamet Jerusalén tak xtetz'et sutin chic rij cmal soldado jnecrebna' ch'oj, tzra' twutkij wa' che ne nkajin ta tiemp che ntu'ra tnamet. ");
INSERT INTO tzjE_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jneban jixc'ola tzra', jixc'ola chpam departamento Judea quixnanmaj ela, twiwaj ewi' ptak c'chelaj. Jixc'ola chpam tnamet Jerusalén quixel ela chpam. Jixc'ola ptayu' mtquixemloj pe chta chpam tnamet Jerusalén. ");
INSERT INTO tzjE_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Cara' quenbij chewa com tak xterla' jara' tiemp rxin jxenbij kaja chewa, tzra' c'ara' c'ola jun nimlaj juicio nkaj ta pe rwá' tnamet Jerusalén ch-utz c'ara' che nbantaja cumplir njelal jtz'ibtanak cana chpam rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Anen congan quenpoknaj quewech ixki' jq'uemjana talexa je' cal chpam jara' tiemp, chka' jec'ola ch'tak ch'uch'a' chquek'a'. Quenpoknaj quewech com aj Israel tzra' congan npeta ryiwal Dios chquij, congan jun nimlaj lowlo' npeta pe rwá' quetnamet. ");
INSERT INTO tzjE_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ec'ola chca nquecamsasa tzan espada, jle' chic chca nque'oc ela preso y nquec'mar ela chpam njelal tak nación. Je tnamet Jerusalén jara' noca pquek'a' nación jme aj Israel ta, c'jara' xtela pquek'a' tak xtq'uisa quetiemp je xtyataja chca nación rmal Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","C'ola je' rital xtwankera chpam k'ij, chpam ic' y chpam je' ch'umil chka'. Je chwech ruch'lew je' wnak jec'ola ptak nación majo'n chic necney ta cmal nak nqueban, xe nsa'cha cna'oj rmal nmak tak bloj rxin mar jcongan netnina. ");
INSERT INTO tzjE_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tak xtquemaj rch'obic je nmak tak lowlo' jpenak chwech ruch'lew nturtaj na quec'u'x y congan necxibej na qui' rmal. Cara' nqueban com je nmak tak poder rxin caj nsi'l na. ");
INSERT INTO tzjE_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","C'jara' nquetz'et na Rlec'walxel jxoca alxic cuq'uin wnak c'mon ta rmal jle' sutz', c'o chic jun nimlaj poder pruk'a' y congan nim chic ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tak xtmajtaja cumplir njelal jawra jxenbij kaja chewa ra quixca'y c'a chcaj y quixquicota com nkajin ta tiemp tak xtquixelsasa libre junlic chpam lowlo'. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","C'jara' c'ola jun c'ambal tzij xbij chca cawrara: —Bien tewsaj ena'oj tzrij jun che' higuera, o chka bechnak che'. ");
INSERT INTO tzjE_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tak npulina ruxak jara' bien nch'obtaja ewmal eyon che xyamer nerkaja ruk'ij c'ten. ");
INSERT INTO tzjE_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Cara' c'a tzra chka' tak xtemaj rtz'etic che majtanak chic rbanic njelal jawra jxenbij kaja chewa jara' rital jnuc'ut chewech che xe nkajin ta rgobierno Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ne ktzij wa' je xtenbij chewa ra, je tnamet Israel arj-e' q'uec'o na tak xtbantaja cumplir njelal jawrara, majo'n chuptanak ta quewech. ");
INSERT INTO tzjE_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Jcaj ruq'uin rwech ruch'lew jara' xe nk'axa per ntzojbal anen jara' majo'n nk'ax ta, majo'n ra' che mquita xtbantaja cumplir. ");
INSERT INTO tzjE_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Tebna' cwent ewi', me tba ta ec'u'x tzrij nmak tak w-im ruq'uin tjoj tak ya', mtebisoj ta rwech ruch'lew. Mex q'ue xtena' tak xterla' k'ij tak xtpet chic jmul Rlec'walxel jxoca alxic cuq'uin wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Cara' quenbij chewa com jk'ij jxenbij kaja chewa quenjumsaj ruq'uin jun tramp rxin chapbal chcop com tak xterla' k'ij nquecha'p na wnak rmal per ne conjelal wnak jec'ola nat nkaj chwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Quixc'asc'at c'a, njelal tiemp tebna' oración ch-utz c'ara' Dios nuya' chewa che neto' ewi' chwech njelal jawrara jxenbij kaja chewa jpenak chwech ruch'lew, ch-utz c'ara' chka' nquixc'u'la tak xtquixekaja chwech Rlec'walxel jxoca alxic cuq'uin wnak. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Je pk'ij nquertijoj wnak chpam nimlaj templo rxin Dios. Jchak'a' nba abar tzra' c'o wa' jyu' rbin-an Olivo y tzra' nec'je' wa'. ");
INSERT INTO tzjE_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ptak xenak'a' nchanim nque'ekaja conjelal wnak ruq'uin chpam templo che rc'axic tijonem jnuya'. ");
INSERT INTO tzjE_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Xe nnajin ta nimk'ij pascua tak nti'ja xquelway jmajo'n levadura ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Je cjefe sacerdote e quexbil maestro je nquetijona cxin wnak tzrij rley Dios arj-e' quemjon rconxic rij rwech nak nqueban tzra Jesús che neccamsaj. Cara' nqueban com xnecxibej qui' chquewech wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","C'jara' xoca Satanás pranm Judas je rbin-an Iscariote. Ja' Judas jun chca je cbeljuj rdiscípulo Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Xba cuq'uin cjefe sacerdote y cuq'uin cjefe je nquechjalbena rxin nimlaj templo rxin Dios. Tak xekaja cuq'uin xumaj tzij tzrij nak nuban chnujach Jesús pquek'a'. ");
INSERT INTO tzjE_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Arj-e' congan xequicota rmal je xbixa chca y xqueya' quechi' che nqueya' pak tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","—Utz c'ara', cara' xbij ja' Judas chca. C'jara' xumaj rconxic nak nuban chnujach Jesús pquek'a' per xcanoj na jun hor tak majo'n necnabej wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Xerla' c'a k'ij rxin nimk'ij tak nti'ja xquelway jmajo'n levadura ruq'uin y tak ncamsasa carne'l jnoca sacrificio rxin pascua je ntzujuxa chwech Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ja' Jesús xerutak ela Pedro ruq'uin Juan y cawra xbij el chca: —Camic nquixba, nbechumij je xtkataj chpam nimk'ij pascua, cara' xbij ela chca. ");
INSERT INTO tzjE_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—Tbij chka abar tzra' nekchumij wa', cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús cawra xbij el chic chca: —Tak xtquixoca chpam tnamet Jerusalén c'ola jun acha nec'ul rc'an jun chnaw ya'. Jneban quixoca chpam jay abar xtoc wa' ja'. ");
INSERT INTO tzjE_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Y cawra nebij tzra rajaw jay: —Ja' Maestro okretkon ta awq'uin che nekerc'axaj chawa: —¿Nak cuarto nkaban wa' w-im rxin pascua e wexbil ndiscípulo? Cara' rbin ta chka, cara' tbij tzra rajaw jay. ");
INSERT INTO tzjE_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Arja' nuc'ut chewech jun nimlaj cuarto chumin chic, chcaj c'o wa' prucab piso. Tzra' nechumij wa' je nkataj rxin nimk'ij pascua. Cara' xbij ela Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ja' Pedro rexbil Juan arj-e' xeba y tak xe'ekaja cara' xbantaja ajni' xbix ela chca rmal Jesús. C'jara' xquemaj rchumsic je nquetaj rxin nimk'ij pascua. ");
INSERT INTO tzjE_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tak xerla' hor rxin w-im xetz'be'a Jesús tzrij mes e rexbil e cbeljuj apóstol. ");
INSERT INTO tzjE_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Xumaj tzij cuq'uin y cawra xbij chca ra: —Anen congan nyarin ta che xjunam nkaban ewq'uin jawra w-im rxin pascua. Quencomsas na per kas quenwajo' nkaban jawra w-im rxin pascua ewq'uin nabey mul. ");
INSERT INTO tzjE_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cara' quenbij chewa com anen majo'n chic quenban ta w-im rxin pascua wawe', c'jara' xtenban chic tak xtbantaja cumplir chpam rgobierno Dios jnuc'ut jawra w-im chkawech, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","C'jara' xuc'om jun cop vino, xmeltioxij tzra Dios y cawra xbij xbij chic chca: —Tec'ma' jawra vino, tetja' chixjujnel. ");
INSERT INTO tzjE_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Camic quenbij chewa che ri'al uva majo'n chic quentaj ta wawe', c'jara' xtentaj chic tak xtpeta rgobierno Dios, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","C'jara' xuc'om xquelway, xmeltioxij tzra Dios, xuwech' y xujach chca, cawra xbij chca ra: —Ja c'a wa' necuerpo je nja'ch na pe cmic pnecwent, tetja'. Jtak netaj jara' nenatbej wxin, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Y cara' xuban chic tzra jun cop vino chka', tak xec'choja w-im cmal cawra xbij chic chca: —Jawra vino, ja c'a wa' necq'uiel rseguro jc'ac' chuminem je rchumin Dios. Jnecq'uiel jara' nti'x na pnecwent. ");
INSERT INTO tzjE_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Per bien tewc'axaj camic, c'ola jun acha je xtejchowa wxin pquek'a' wnak je nquetzelana wxin y jara' acha tz'bula wq'uin tzrij mes camic. ");
INSERT INTO tzjE_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Je Rlec'walxel jxoca alxic cuq'uin wnak ne ktzij wa' che ncamsas na ajni' chumin ta rmal Dios per congan lowlo' tzra je xtejchowa rxin pquek'a' je nquecamsana rxin, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","J-e' apóstol xquemaj rc'axic chbil tak qui' nak jun chca je xtejchowa rxin. ");
INSERT INTO tzjE_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chka' c'ola jun ch'oj xwankera chquecjol, nak jun más nim ruk'ij chca, jara' necch'ojquij. ");
INSERT INTO tzjE_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ja' Jesús cawra xbij chca ra: —Je' rey jec'ola ptak je' nación arj-e' congan nmak nquena' y nqueban chca wnak xe e ajni' cmos. Jnebnowa mandar cxin wnak congan necyarij che nbixa chca che e bnoy tak utzil. ");
INSERT INTO tzjE_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Per mteban ta ixix ajni' nqueban j-e'. Per jneban, nak jun más nim ruk'ij chewa tebna' kaja más ch'it co'l chquewech rexbil. Chka' nak nebnowa mandar mejor querilij rexbil. ");
INSERT INTO tzjE_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tak c'ola jun acha remjon w-im y c'ola jun rmos nilina rxin ¿nak jun más nim ruk'ij chca nech'ob ixix? ¿Le mja' tc'ara' ja' acha jnilixa rmal rmos jmás nim ruk'ij? Per bien terkaja pnewá' nak nebnon checjol, nebnon samaj ajni' nuban jun ilinel. ");
INSERT INTO tzjE_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ixix ne enewexbilan wa' chpam lowlo' jnetjon ta. ");
INSERT INTO tzjE_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jcamic anen quenya' k'atbaltzij pnek'a' ajni' yatanak chwa anen rmal Nedta' Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Cara' quenban chewa ch-utz c'ara' nyataja chewa che xjunam xtokwa' wa' ewq'uin tzrij mes je chpam ngobierno, ch-utz c'ara' chka' che nyataja chewa che nquixetz'be'a chwech je' trono chka' y nquixoca ix k'toy tak tzij chquij e cbeljuj tribu rxin tnamet Israel, cara' xbij ja' Jesús chca rapóstol. ");
INSERT INTO tzjE_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","C'jara' xumaj tzij ja' Kajaw Jesucristo ruq'uin Simón Pedro, cawra xbij tzra ra: —Simón, bien tewc'axaj je xtenbij chawa ra, Satanás arja' ixrc'utun tzra Dios y nya'a c'as tzra che nquixec'je'a jurat pruk'a' y nquixerkasaj na chpam jun nimlaj prueba. ");
INSERT INTO tzjE_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Per anen nebnon orar pnacwent ch-utz c'ara' majo'n nq'uis ta junlic yukbal ac'u'x wq'uin. Atet tak xtcatemloj pchic jmul pnuk'a' tecwersaj chic quec'u'x awch'alal, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ja' Simón Pedro cawra xbij tzra: —Wajaw, anen quentre'a chawij mesque en jun anen quencsasa pcars awq'uin, owe quencomsasa awq'uin chka', cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ja' Jesús cawra xbij chic tzra: —Camic quenbij chawa Pedro, chpam jawra ak'a' q'uemjana tetrekena pre'y tak oxmul abin chic cawrara chwa: —Anen majo'n wutkin ta rwech Jesús, cara' nabij na chwa, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","C'jara' xumaj tzij cuq'uin conjelal rapóstol y cawra xbij chca ra: —Tak xixnutak ela chpam je' viaje tak majo'n epak xec'om ela nexte xec'om ela emalet nexte exjab chka' ¿lc'o na je achnak xewajo' jmajo'n xixruban ta? cara' xc'axaj chca. —Nmajo'n achnak xuban falta chka, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","C'jara' cawra xbij chic chca: —Per camic quenbij chic chewa, nak c'ola rpak tec'ma' ela y tec'ma' ela rmalet chka'. Nak jun majo'n jun espada ruq'uin, jnuban tc'ayij rechquet y telk'o' jun espada. ");
INSERT INTO tzjE_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Cara' quenbij chewa com anen npors quenk'ax na chpam jtz'ibtanak cana chwij chpam rtzojbal Dios, cawra tz'ibtanak cana chwij ra: —Arja' xjunam nba'na tzra ajni' nba'na chca jitzel tak wnak. Cara' tz'ibtanak cana chwij y pors nbantaj na cumplir com njelal jtz'ibtanak cana chwij jara' ntajina nbantaja cumplir, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Arj-e' cawra xecbij tzra: —Tetz'ta' mpa' Kajaw, c'ola c-e' espada kc'an ra, cara' xecbij tzra. —Quixetne'a, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","C'jara' xel ela chpam tnamet, xba chpam jun lwar abar c'o wa' jun jyu' Olivo rubi' com ne tzra' nec'je' wa' je'a. Etrena rdiscípulo tzrij. ");
INSERT INTO tzjE_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tak xe'ekaja chpam lwar cawra xbij chca ra: —Tebna' orar ch-utz c'ara' Satanás tak xtquixerchajtij mquita xtquixruch'ec, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","C'jara' xyonaj pona ri' ruyon, chenkaj xec'je' pon wa', xexque'a y xumaj rbanic oración, cawra oración xuban ra: ");
INSERT INTO tzjE_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Nedta', anen quenwajo' nabij ta chwa che mquita quenk'axa chpam lowlo' jpenak chenwech. Cara' ta nabij chwa wnuc'om ri' ruq'uin jachumin ta chwij. Per xerwara' nquenk'ax na chpam wcara' nrajo' awanm chquenban, cara' xbij tzra Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","C'jara' c'ola jun ángel xwanker ta chwech penak chcaj, xrey-a' kaja más rchuk'a'. ");
INSERT INTO tzjE_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Com majtanak rmal jun nimlaj lowlo' rmal c'ara' más chna xuban oración. Congan ya' nela chuplaj ajni' nmak tak c'aj quic' je nkaja ptak ulew. ");
INSERT INTO tzjE_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tak xec'choja oración xyictaja y xba cuq'uin rdiscípulo. Tak xekaja cuq'uin congan ekanak chuwram com congan ecosnak rmal bis. ");
INSERT INTO tzjE_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","—¿Nak tzra xe wram neban? Camic quixyictaja y tebna' oración ch-utz c'ara' Satanás tak xtquixerchajtij mquita xtquixruch'ec, cara' xbij ja' Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kas remjon na tzij cuq'uin rdiscípulo tak e congan e q'uiy wnak xe'erkaja ruq'uin. C'ola jun acha rec'mon ta quebey, Judas rubi', arja' jun chca je cbeljuj apóstol. Ja' Judas xki'l oca ruq'uin Jesús ch-utz c'ara' ntz'ubaj ruchi'. ");
INSERT INTO tzjE_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Per Jesús cawra xbij tzra ra: —¿Lruq'uin jun tz'uban chi'ij najachbej Rlec'walxel pquek'a' je nquetzelana rxin? ¿Lcara' naban tzra Rlec'walxel jxoca alxic cuq'uin wnak? Cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Je rexbil Jesús tak xch'obtaja cmal chc'ola lowlo' penak tzrij cawra xecbij tzra ra: —¿Nak nabij atet Kajaw, l-utz nkalsaj espada chquij? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Xpet c'a jun chca, xelsaj espada y c'ola jun rmos nimlaj sacerdote xusoc, xch'upuj ela jun rexquin jc'ola prejquenk'a'. ");
INSERT INTO tzjE_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús cawra xbij chca rexbil: —Mteban ta más ch'oj. C'jara' xuchap rexquin mos y xchumsaj. ");
INSERT INTO tzjE_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ec'ol c'a cjefe sacerdote e quexbil cjefe je nquechjalbena rxin nimlaj templo rxin Dios e quexbil chic principal-i' rxin tnamet, arj-e' epenak che rchapic Jesús. Jesús cawra xbij chca: —¿Le en elk'om c'a rmal c'ara' tak ec'mon ta espada y ec'mon ta che' chwij che nchapic? ");
INSERT INTO tzjE_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Per anen k'ij k'ij xenc'je'a checjol chpam nimlaj templo rxin Dios per majo'n wan xnechap ta tzra'. Per jawra hor jokc'o wa' jawa' yatanak chewa che nquixba'na mandar rmal diablo jnebnowa mandar chpam k'ejku'm. Cara' xbij ja' Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","C'jara' xquechap, xquec'om ela pruchoch nimlaj sacerdote. Ja' Pedro retreben Jesús per q'ue c'nat nutzu' pon chwa'. ");
INSERT INTO tzjE_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tak xe'ekaja xquebox jun k'ak' chujay y xetz'be'a chuchi'. Pedro xetz'be'a cuq'uin chuchi' k'ak'. ");
INSERT INTO tzjE_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kas tz'bula chi' k'ak' tak xpeta jun aj-ic', xera' xtz'ulchij y cawra xbij ra: —Jawra acha ra rexbil Jesús chka', cara' xbij ja' aj-ic'. ");
INSERT INTO tzjE_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro majo'n xuya' ta tzrij je xbixa tzra y cawra xbij tzra aj-ic' ra: —Anen quenbij chawa che anen majo'n wutkin ta rwech Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","C'aj co'l ara' tak c'ol chic jun xetz'towa rxin Pedro y cawra xbij tzra: —Atet chka' at quexbil jxe'exbilana rxin Jesús, cara' xbij tzra. —Anen quenbij chawa che me en quexbil ta, cara' xbij ja' Pedro tzra acha. ");
INSERT INTO tzjE_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","C'ola ra' jun hor tak xpeta chic jun y xbij che ne ktzij wa' jPedro rexbil Jesús, cawra xbij ra: —Bien k'alaj chjawra acha rexbil Jesús chka' com arja' aj Galilea, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro cawra xbij tzra: —Quenbij chawa che anen majo'n wutkin ta jnabij la, cara' xbij tzra. Kas remjon na tzij Pedro tak xtrekena pre'y. ");
INSERT INTO tzjE_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ja' Kajaw Jesucristo xuya' volt y xtz'ulchij Pedro. Ja' Pedro xerkaja pe rwá' jbin tzra rmal Jesús jcawrara: —Tak q'uemjana tetrekena pre'y, oxmul nabij na chwa cawrara: —Anen majo'n wutkin ta rwech Jesús, cara' nabij na chwa. ");
INSERT INTO tzjE_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","C'jara' xel ta, congan jun nimlaj bis ok'ej nuban. ");
INSERT INTO tzjE_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jechapyona rxin Jesús arj-e' xquemaj ryok'ic Jesús y xquemaj rch'ayic chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Xectz'apij rwech tzan su't y tak xtz'aptaja cmal xqueya' k'a' chuplaj y cawra xecbij tzra: —Tbij chka camic ¿nak xyowa k'a' chaplaj? cara' necbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Y c'c'o na más lowlo' tak tzij xecbij tzra jnecyok'bej rxin. ");
INSERT INTO tzjE_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tak xeskara xquemol qui' principal-i' rxin tnamet e quexbil cjefe sacerdote e quexbil chic je' maestro je nquetijona cxin wnak tzrij rley Dios. Xquec'om ela Jesús chpam k'atbaltzij je cxin j-e'. Tak xe'ekaja cawra xecbij tzra ra: ");
INSERT INTO tzjE_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Camic tbij chka ¿le atet at Cristo je atch-on rmal Dios? cara' xecc'axaj tzra. Jesús cawra xbij chca: —Per ixix majo'n nenimaj ta mesque xtenbij chewa. ");
INSERT INTO tzjE_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Anen chka' c'ola quenc'axaj chewa per wutkin chmajo'n cnec'ulba' ta y wutkin chka' chmajo'n cnesak'pij ta. ");
INSERT INTO tzjE_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Per camic quenbij chewa, je chpam tiemp jpenak chkawech nba Rlec'walxel jxoca alxic cuq'uin wnak y netz'be'a prejquenk'a' Dios jabar c'o wa' nimlaj rpoder Dios, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","—¿Le atet c'a at Rlec'wal Dios? cara' xecc'axaj tzra. —Cara' ajni' xebij kaja, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Arj-e' cawra xecbij: —Camic majo'n chic nquec'atzin más testig com ajoj mism xekc'axaj je xbij la, cara' xecbij je'a. ");
INSERT INTO tzjE_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","C'jara' xeyictaj ela conjelal, xquec'om ela Jesús chwech gobernador Pilato. ");
INSERT INTO tzjE_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tak xe'ekaja xquemaj rbixic jle' ril Jesús: —Ajoj katz'ton jnuban jala acha, xe ntajina nuyoj cna'oj tnamet Israel. Arja' nbij chca wnak che mrubey ta nqueban tak nquetoj impuesto pruk'a' César jnimlaj rey. Jun chic, nbij chja' Cristo, nbij tzij ra chja' jun rey chic, cara' xecbij tzra Pilato. ");
INSERT INTO tzjE_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ja' Pilato cawra xc'axaj tzra Jesús: —¿La atet at rey cxin tnamet Israel? —Cara' nc'a ajni' xabij kaja, cara' xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ja' Pilato xtzijon chic cuq'uin cjefe sacerdote y cuq'uin jle' chic wnak y cawra xecbij chca ra: —Jquentz'et anen majo'n ril jawra acha, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Per más xeyictaja tzrij Jesús y cawra xecbij chic tzra Pilato: —Per jawra acha xe ntajina nuyoj cna'oj wnak, ntajina nquertijoj njelal nat nkaj chpam departamento Judea, xumaj ta rya'ic tijonem chpam departamento Galilea y camic remjon rya'ic chca wnak wawe' chka', cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ja' Pilato tak xc'axaj che pGalilea rey-on wa' tijonem Jesús rmal c'ara' tak cawra xbij chic chca: —¿Mex aj Galilea jawra acha? cara' xc'axaj chca. ");
INSERT INTO tzjE_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tak xbixa tzra che aj Galilea Jesús c'jara' xutak ela ruq'uin Herodes jgobernador rxin Galilea com ja' Herodes c'ola pJerusalén chka' chpam jara' k'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ja' Herodes tak xekaja Jesús ruq'uin congan xquicota com arja' c'o chic tiemp nyarij nutz'et ri' quewech ruq'uin com kanak chic rbixic ruq'uin njelal je ntajina nuban Jesús y nrajo' nutz'et tak nuban jun milagro. ");
INSERT INTO tzjE_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Q'uiy je' achnak xc'axaj tzra per next jun tzij xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ec'ol c'a cjefe sacerdote e quexbil maestro je nquetijona cxin wnak tzrij rley Dios, arj-e' congan nqueban xquemaj rbixic ril Jesús chwech Herodes. ");
INSERT INTO tzjE_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ja' Herodes e rexbil rsoldado nmajo'n val ta Jesús chquewech, xquemaj ryok'ic, xquecsaj jun tziak tzra ajni' nucsaj jun rey per xjic necyok'bej rxin. C'jara' Herodes xutak el chic jmul ruq'uin Pilato. ");
INSERT INTO tzjE_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jara' mism k'ij xec'choja Pilato ruq'uin Herodes, xe'oc chic amigo com nabey quec'lel qui'. ");
INSERT INTO tzjE_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ja' Pilato xerumol cjefe sacerdote e quexbil e k'toy tak tzij rxin tnamet Israel e quexbil chic jle' chic wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tak xemoltaja rmal cawra xbij chca ra: —Camic ec'mon ta acha chenwech ra, jril nebij xnuyoj tnamet. Per bien tech'bo', chewech ixix xenc'ot ruchi' y jquentz'et anen nmajo'n ril ajni' nebij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ja' Herodes chka' nmajo'n ril xuwil com xutak pchic jmul pkak'a' ajoj. Majo'n achnak rebnon jawra acha che xtyataj ta tzrij che ncamsasa. ");
INSERT INTO tzjE_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Rmal c'ara' mejor je nba'na tzra, quenya' jun orden che nch'aya y tak xtch'aytaja c'jara' quensak'pij ela, cara' xbij Pilato chca. ");
INSERT INTO tzjE_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Cara' xbij chca com ptak nimk'ij pascua arja' pors nsak'pij ela jun preso. ");
INSERT INTO tzjE_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Arj-e' xjunam nqueban xquemaj rakic quechi' conjelal y cawra necbij: —Tcamsaj jala acha. Jc'a Barrabás jara' tsak'pij ela, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás jara' jun acha xuban jmul xyictaja tzrij gobierno chpam tnamet y ec'ola wnak xercamsaj rmal c'ara' tak ocnak preso. ");
INSERT INTO tzjE_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ja' Pilato com nyarij nsak'pij ela Jesús rmal c'ara' tak xtzijon chic jmul cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Per arj-e' xmás chna xquemaj rakic quechi': —Tcamsaj chwech cruz, tcamsaj chwech cruz, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ja' Pilato proxmul cawra xbij chca: —Per ¿nak q'ue tzra nec'utuj recmic, nak rebnon tak nebij cara'? Jquentz'et anen nmajo'n achnak rebnon che nyataja tzrij che ncamsasa. Rmal c'ara' mejor quenya' jun orden che nch'a'ya y tak xtch'aytaja c'jara' quensak'pij ela, cara' xbij chic chca. ");
INSERT INTO tzjE_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Per je' wnak e quexbil cjefe sacerdote njunam quemjon rakic quechi', congan necch'ojquij tzra Pilato che ncamsasa Jesús chwech cruz, y tak xq'uisbena arj-e' xech'ecmaja. ");
INSERT INTO tzjE_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ja' Pilato xuya' jun orden chcara' nba'na tzra Jesús ajni' ncajo' j-e'. ");
INSERT INTO tzjE_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Xsak'pix ela ja' acha jocnak pcars je xyictaja tzrij gobierno y jec'ola jle' wnak xercamsaj. Jara' acha xecc'utuj tzra. Ja' Jesús xja'cha pquek'a' jle' soldado ch-utz c'ara' nba'na tzra ajni' ncajo' wnak che nba'na tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","J-e' soldado kas quec'mon ela Jesús pbey tak c'ola jun acha xquewil, Simón rubi', aj Cirene. Ja' Simón arja' xemloj ta ptayu' y ntzrij ja' xqueya' el chwa' cruz, npors xqueban tzra che netre' ela tzrij Jesús y ntelej ela cruz. ");
INSERT INTO tzjE_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ja' Jesús congan e q'uiy wnak etren ela tzrij y chka' ec'ola jle' ixki', arj-e' congan ncok'ej rwech y congan necbisoj. ");
INSERT INTO tzjE_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Per Jesús arja' xuya' volt y cawra xbij chca ra: —Me cnewok'ej ta ixki' je ix aj Jerusalén. Jneban camic, twok'ej kaja ewi' ixix y twok'ej quewech ch'tak ewal chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Cara' quenbij chewa com nerla' na jun tiemp lowlo' tak cawra xtecbij wnak ra: —Camic ajni'la quicotemal chca ixki' jmajo'n alanem chquij, congan quicotemal chca ixki' jmajo'n je' cal, cara' nebij na. ");
INSERT INTO tzjE_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tak xterla' jlowlo' tiemp cawra xtquemaj rbixic wnak ra: —Mejor ttza'k ta chkij nmak tak jyu' y nokrumuk ta chka' je' cocoj tak jyu', cara' necbij na. ");
INSERT INTO tzjE_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Cara' quenbij chewa com wcongan lowlo' nba'na chwa camic y wcara' nba'na tzra c'aslic che' rex, peor c'ara' nba'na tzra jun chkilaj che'. ");
INSERT INTO tzjE_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ec'ol c'a e c-e' chic ach-i', arj-e' c'ola quil quebnon y junam xec'mar ela ruq'uin Jesús che nquecamsasa. ");
INSERT INTO tzjE_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tak xe'ekaja chpam lwar rbin-an Rwá' Comnak tzra' xquerip wa' Jesús chwech cruz y cara' xqueban chca e c-e' ach-i' jc'ola quil chka', jun prejquenk'a' y jun prexquen. ");
INSERT INTO tzjE_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ja' Jesús cawra jun oración xuban: —Nedta', que'acyu' com arj-e' majo'n cutkin ta je nqueban, cara' xbij tzra Ttixel. C'jara' xquemaj rbanic suert tzrij retziak nak jun xtech'cowa chca y nquejach chquewech. ");
INSERT INTO tzjE_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Je' wnak jquemjon rtz'etic je xbantaja e quexbil e k'toy tak tzij arj-e' xquemaj rtz'ujic Jesús y cawra xecbij tzra: —To'onel cxin wnak nbixa tzra, we ktzij che arja' Cristo je ch-on rmal Dios tet-o' c'a ri' ruyon camic, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Je' soldado xquemaj ryok'ic chka', xeki'l oca más ruq'uin Jesús y c'ola jle' vinagre xectzujuj tzra ");
INSERT INTO tzjE_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","y cawra xecbij tzra: —Atet we ktzij che at Rey cxin tnamet Israel tet-o' c'a awi' ayon, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","C'ola jle' letr xba'na xtzakbaxa chwech cruz jpe rwá' Jesús, oxi' rwech tzojbal xtz'ibax wa', jun pe griego, jun platín y jun chic chpam hebreo, cawra nbij ra: —Jawra acha rey cxin tnamet Israel. cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","C'ol c'a jun chca e c-e' ach-i' jc'ola quil quebnon erpon chwech cruz arja' xumaj rbixic jle' itzel tak tzij tzra Jesús y cawra xbij tzra ra: —We ktzij che at Cristo tet-o' c'a awi' camic y ko'at-o' ajoj chka', cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Per jun chic acha jc'ola ril rebnon arja' xumaj rch'ajic pe rwá' jun chic: —¿Le mtaxibej awi' chwech Dios com atet k'ton chic tzij chawij che ncatcamsasa chka'? ");
INSERT INTO tzjE_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ajoj ne yatanak wa' chkij che nokcamsasa com jara' nektojbej je rtzilal kabnon, per jun chic acha la arja' majo'n achnak lowlo' rebnon, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","C'jara' xtzijon chic ruq'uin Jesús y cawra xbij tzra ra: —Kas xquenrkaja pnawá' tak xtcatpet chic jmul tak atocnak chic rey chpam agobierno. ");
INSERT INTO tzjE_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús cawra xbij tzra: —Ne ktzij wa' je xtenbij chawa ra, chpam jawra jun k'ij jokc'o wa' ok c-e' awq'uin nokba chpam utzlaj lwar jabar c'o wa' quicotemal, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Je pe nc'aj k'ij c'ola jun nimlaj k'ejku'm xoca chwech njelal ruch'lew, c'a las tres rxin tk'ak'ij xeskar chic jmul. ");
INSERT INTO tzjE_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jk'ij majo'n chic xca'y ta. Chka' xraktaja jmant jk'otben rpam santlaj templo, chek c-e' xuban. ");
INSERT INTO tzjE_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ja' Jesús xurak ruchi', xuban jun oración cawrara: —Nedta', pnak'a' atet quenjach wa' wanm, cara' xbij tzra Ttixel. Tak xbitaja cara' rmal xcom kaja. ");
INSERT INTO tzjE_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","C'ol c'a jun capitán pa'l tzra', arja' tak xutz'et je xbantaja xumaj rya'ic ruk'ij Dios y cawra xbij ra: —Jala jun acha ne ktzij wa' rbeyal rxin Dios rc'an. ");
INSERT INTO tzjE_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Congan e q'uiy wnak quemlon qui' che rtz'etic je xbantaja. Per tak xquetz'et njelal je xbantaja congan xebisona xeba. ");
INSERT INTO tzjE_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ixki' je tren ela tzrij Jesús, tak xe'el ela pGalilea e quexbil conjelal wnak jcutkin rwech, arj-e' q'ue c'nat xe'epe' twa', quemjon rtz'etic njelal je xbantaja. ");
INSERT INTO tzjE_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","C'ol c'a jun acha José rubi', arja' aj Arimatea jc'ola precwent Judea. Ja' José arja' jun chca je k'toy tak tzij cxin tnamet Israel, per jun utzlaj acha y rbeyal rebnon chwech Dios. Arja' njelal ruc'u'x reyben k'ij tak xtoca rgobierno Dios. Mjunam ta nuch'ob cuq'uin rexbil je k'toy tzij com m-utz ta xutz'et je xqueban tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Xba ja' José ruq'uin Pilato che rc'utxic recuerpo Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tak xya'a c'as tzra rmal Pilato c'jara' xba xerkasaj recuerpo Jesús chwech cruz y xubar pjun utzlaj tziak. Tak xbartaja rmal xerey-a' chpam jun panteón je c'ton chwech jun tz'lem abaj y nexte wjic csan ta jun camnak chpam. ");
INSERT INTO tzjE_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jawra xbantaja chpam k'ij tak nchumsasa je' achnak je rxin nimk'ij, xyamer nerla' hor jnumaj ela rij xlanbal k'ij. ");
INSERT INTO tzjE_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ixki' jetren ela tzrij Jesús, tak xe'el ela pGalilea arj-e' xeba tzrij José, xequetz'ta' panteón y xquetz'et chka' nak xba'na tzra recuerpo Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tak xtz'ettaja cmal c'jara' xemloja ptak cuchoch, xecchumij jle' ak'om jqui' rexla' je nqueya' tzrij recuerpo Jesús. Jpe xlanbal k'ij xexle'na ajni' nbij rley Dios che nqueban. ");
INSERT INTO tzjE_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Je rxin domingo kas samakmuj xeba chic jmul ixki', xequetz'ta' panteón, cc'an ak'om je cchumin ela. Ec'o chic nic'aj ixki' equexbilan ela. ");
INSERT INTO tzjE_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tak xe'ekaja xquetz'et che lsan chic abaj je tz'apben ruchi' panteón. ");
INSERT INTO tzjE_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Xe'oc c'a chpam panteón per tak xquetz'et majo'n chic recuerpo Jesús chpam. ");
INSERT INTO tzjE_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Congan xsa'cha cna'oj rmal, tak chek q'uenjlal ec'ola e c-e' ach-i' xequetz'et epa'la ptak quexquin, congan nc'ac'ota quetziak. ");
INSERT INTO tzjE_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Congan cxiben qui' j-e' ixki', xequetquemyij queplaj penlew. Je c-e' ach-i' cawra xecbij chca: —¿Nak tzra tak chquecjol cnomki' necanoj wa' jc'asla? ");
INSERT INTO tzjE_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Camic, mwawe' chta c'o wa' Jesús, arja' c'astanak chic rwech. Terkaja pnewá' je xbij cana chewa tak c'c'o na ewq'uin pGalilea, ");
INSERT INTO tzjE_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","cawra xbij cana chewa: —Je Rlec'walxel jxoca alxic cuq'uin wnak nc'atzina che nja'ch na pquek'a' aj-il ajmac, nc'atzina che ncamsas na chwech cruz, per prox k'ij nc'astaj na, cara' xbij cana chewa, cara' xecbij e c-e' ach-i' chca. ");
INSERT INTO tzjE_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","J-e' ixki' xerkaja pquewá' jbin cana chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","C'jara' xe'el ela chpam panteón, xemloja xeba cuq'uin e juljuj apóstol jabar quemlon wa' qui' cuq'uin e jle' chic quexbil, xequechlo' chquewech njelal jquetz'ton ta. ");
INSERT INTO tzjE_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Je ixki' jxequechlo' chquewech apóstol cawra quebi' ra: jun María Magdalena, jun chic Juana, jun chic María jrute' Jacobo, y q'ue c'o na más quexbil. ");
INSERT INTO tzjE_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Je' apóstol majo'n xecnimaj ta je xbixa chca cmal ixki', arj-e' xquech'ob je xbixa chca xme ktzij ta. ");
INSERT INTO tzjE_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Per Pedro arja' xyictaja y xba alnak abar c'o wa' panteón. Tak xe'ekaja xca'y oca chpam panteón, xutz'et oca utzlaj tziak rxin comnak xruyon chic c'o cana. C'jara' xemloja chruchoch, kas remjon rch'obic pranm njelal je xbantaja y congan xel ta ruc'u'x jxutz'et. ");
INSERT INTO tzjE_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ec'ol c'a e c-e' rdiscípulo Jesús jara' mism k'ij quemjon binem, ebnak pjun aldea rbin-an Emaús. Jara' aldea c'ola la cbeljuj kilómetro recjol ruq'uin tnamet Jerusalén. ");
INSERT INTO tzjE_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","J-ewra e c-e' discípulo quemjon tzij chbil tak qui' tzrij je njelal xbantaja chpam je c-e' oxi' k'ij k'axnak cana. ");
INSERT INTO tzjE_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kas quemjon tzij y c'ola je' achnak quemjon rc'axic chbil tak qui' tak xekaja Jesús cuq'uin y xerexbilaj ela. ");
INSERT INTO tzjE_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Per arj-e' majo'n xyataj ta chca che ncutkij rwech Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús cawra xbij chca: —¿Nak chtzij emjon rij chbil tak ewi' pbey y nak tzra tak nquixbisona? cara' xc'axaj chca. ");
INSERT INTO tzjE_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","C'ol c'a jun chca Cleofas rubi', arja' cawra xbij tzra: —¿Lmawutkin tc'a je xbantaja chpam tnamet Jerusalén chpam c-e' oxi' k'ij jk'axnak cana? Per jle' chic wnak jxec'je' cana pJerusalén arj-e' bien cutkin je xbantaja per ne che conjelal. ¿Lxayon c'a atet jmajo'n awutkin ta? cara' xbij Cleofas tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Nak c'a xbantaja? cara' xc'axaj ja' Jesús chca. Arj-e' cawra xecbij tzra: —Ajoj noktzijona tzrij Jesús je aj Nazaret. Ja' Jesús arja' jun profeta rxin Dios, congan nmak tak milagro xuban y congan poder rc'an rtzojbal, ne bien k'alaj chwech Dios y bien k'alaj chquewech conjelal wnak chka'. ");
INSERT INTO tzjE_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Je cjefe sacerdote e quexbil e k'toy tak tzij rxin ketnamet arj-e' xquejach Jesús pruk'a' Pilato ch-utz c'ara' nk'e'ta tzij tzrij che ncamsasa, y cara' xqueban xeccamsaj chwech cruz. ");
INSERT INTO tzjE_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Per ajoj congan xeyke'a kac'u'x ruq'uin che arja' net-owa kxin ajoj ja ok aj Israel pquek'a' je nquetzelana kxin per xcamsasa, y camic xuban oxi' k'ij tcamsasa. ");
INSERT INTO tzjE_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Jun chic, ec'ola jle' ixki' e kaxbil c'ola nic'aj achnak xecbij chka y congan xel ta kac'u'x tzrij tak xekc'axaj. Arj-e' kas samakmuj xeba abar c'o wa' panteón. ");
INSERT INTO tzjE_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tak xe'ekaja xquetz'et chmajo'n chic recuerpo Jesús chpam. C'jara' xemloj ta kuq'uin, xquerbij chka che ec'ola ángel xewanker ta chquewech y xbixa chca rmal ángel che c'astanak chic Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ec'ol c'a jle' ach-i' e kaxbil, arj-e' xeba chic ruq'uin panteón y tak xe'ekaja xquetz'et che ne ktzij wa' je xbixa chca cmal ixki'. Per majo'n xquetz'et ta rwech Jesús tzra'. Cara' c'a xbantaja, cara' xecbij je c-e' discípulo tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ja' Jesús cawra xbij chca: —Ixix majo'n ch'obtanak ta ewmal njelal je cbin cana e ojer tak profeta rxin Dios, me njelal ta ec'u'x me njelal ta ewanm eniman njelal jtz'ibtanak cana cmal chpam rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Je Cristo bien k'alaj che nc'atzina neretja' nabey mul njelal jawra lowlo' je c'ja' xebij kaja chwa y c'jara' nba pe gloria jabar nk'aljin wa' chcongan nim ruk'ij, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","C'jara' xumaj rch'obic chquewech njelal jtz'ibtanak cana chpam rtzojbal Dios, xumaj ta rch'obic chquewech jtz'ibtanak cana rmal Moisés c'jara' xuch'ob chic chquewech jtz'ibtanak cana cmal jle' chic profeta. ");
INSERT INTO tzjE_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tak xe'ekaja chpam aldea jabar ebnak wa', ja' Jesús xuban com ajni' numaj na rij más binem. ");
INSERT INTO tzjE_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Per arj-e' xquecsaj cchuk'a' che nec'je' kaja cuq'uin: —Xkaj k'ij, xyamer noca ak'a', mejor catec'je'a kuq'uin, cara' xecbij tzra. Y cara' xuban xoca pjay che nec'je'a cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tak tz'bul chic tzrij mes cuq'uin xuc'om xquelway, xmeltioxij tzra Dios, xuwech' y xuya' chca. ");
INSERT INTO tzjE_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chek xyataja chca xcutkij rwech Jesús. Ja' Jesús njara' hor xsa'cha chquewech. ");
INSERT INTO tzjE_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Arj-e' xquemaj chic tzij chbil tak qui', cawra xecbij ra: —Tak arja' remjon tzij kuq'uin pbey y tak remjon rch'obic chkawech rtzojbal Dios jara' ne ktzij wa' chcongan jun nimlaj quicotemal xuna' kanm rmal, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Njara' hor xeyictaja, xemloj chic jmul pJerusalén. Tak xe'ekaja xequewil je juljuj apóstol jquemlon qui' cuq'uin jle' chic quexbil. ");
INSERT INTO tzjE_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Cawra xbixa chca cmal apóstol: —C'astanak chic Kajaw Jesús y xuc'ut ri' chwech Simón, cara' xbixa chca e c-e' discípulo. ");
INSERT INTO tzjE_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","C'jara' xquemaj rchulic chquewech njelal je xbantaja tak ebnak chpam aldea Emaús, y xquechol chquewech chka' nak xuban tak xcutkij rwech Jesús, jara' tak xuwech' xquelway chquewech. ");
INSERT INTO tzjE_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kas quemjon tzij tak chek q'uenjlal xwankera Jesús chquecjol y cawra xbij chca ra: —Qui'il ta nec'je'a ewanm chwech Dios, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Per arj-e' congan xecxibej qui' com xquech'ob j-e' ranm jun comnak xquetz'et. ");
INSERT INTO tzjE_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ja' Jesús cawra xbij chca: —¿Nak tzra tak sachnak ena'oj? ¿Nak tzra tak majo'n nenimaj ta che anen en Jesús? ");
INSERT INTO tzjE_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tetz'ta' mpa' pnuk'a', tetz'ta' mpa' pe wkan, kas bien tech'bo' che anen en Jesús. Cnechpa' mpa', bien cnetz'ta' com jranm jun comnak jara' majo'n recuerpo nexte c'o ta rbakil chka', per bien netz'et che anen c'ola necuerpo y c'ola nbakil chka', cara' nbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tak xbitaja cara' rmal, c'jara' xuc'ut chquewech pruk'a' y pe rkan. ");
INSERT INTO tzjE_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Arj-e' cawra quemjon kaja rch'obic ptak canm: —Tak congan quicotemal rc'an jawrara per me ktzij la, cara' xquech'ob kaja. Jesús cawra xbij chca: —¿Lc'ola neya' chwa chquentaj? cara' xc'axaj chca. ");
INSERT INTO tzjE_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","C'c'o na jle' ch'u' s-on jara' xqueya' tzra rexbil ri'al che'. ");
INSERT INTO tzjE_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Xuc'om chca y xumaj rtijic per ne chquewech. ");
INSERT INTO tzjE_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","C'jara' cawra xbij chca: —Camic xbantaja cumplir jtzij jxenbij chewa chpors nbantaj na cumplir njelal jtz'iban cana chwij chpam rtzojbal Dios ajni' tzra jtz'iban cana rmal Moisés ruq'uin cmal jle' chic profeta rxin Dios, chka' jtz'iban cana chwij chpam libro rxin salmo, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","C'jara' xuch'ob chquewech más rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Cawra xbij chca ra: —Tz'ibtanak cana chpam rtzojbal Dios che Cristo arja' neretja' na lowlo' y ncamsas na, y chrox k'ij nc'astaj na chquecjol cnomki', cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tz'ibtanak cana chka' che prubi' Cristo nekaj na rbixic cuq'uin conjelal wnak jec'ola ptak nación che nc'atzina nqueq'uex cna'oj y nqueya' cana rtzilal ch-utz c'ara' ncuytaja quil quemac, jara' pJerusalén nmajtaj el wa' rbixic. ");
INSERT INTO tzjE_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ixix etz'ton njelal jxenbij kaja chewa ra, ixix nquixk'alsana chquewech wnak. ");
INSERT INTO tzjE_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Bien tewc'axaj je xtenbij chewa ra, anen quentak tna Espíritu Santo ewq'uin ajni' tzujun ta rmal Nedta' Dios. Per quixec'je'a wawe' chpam tnamet Jerusalén, c'jara' nquixel ela chpam tak xtyataja chewa je rpoder Espíritu Santo je xtkaj ta chcaj, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","C'jara' xeruc'om ela, xeba pBetania. Tak xe'ekaja xuyic chcaj c-e' ruk'a' y xc'utuj utzil rxin Dios pquewá'. ");
INSERT INTO tzjE_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kas c'remjon rc'utxic utzil pquewá' tak chek q'uenjlal xba xec'mar ela chcaj. ");
INSERT INTO tzjE_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Arj-e' congan xqueya' ruk'ij. C'jara' xemloja chpam tnamet Jerusalén, congan jun nimlaj quicotemal c'ola ptak canm. ");
INSERT INTO tzjE_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","K'ij k'ij nquepeta chpam nimlaj templo, njunlic quemjon rya'ic ruk'ij Dios. Amén.");
INSERT INTO tzjE_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ojer tak majo'n achnak wankersan c'o chic Rlec'walxel je Rtzojbal Dios. Arja' xjun quebnon ruq'uin Dios, y Dios ja' chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tak majo'n achnak wankersan xjun quebnon ruq'uin Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Xya' c'a tzra rmal Dios chja' nwankersana caj ruq'uin ruch'lew, majo'n achnak wankersan mquita ja' wankersyona. ");
INSERT INTO tzjE_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ja' nyowa utzlaj c'aslemal, y je rc'aslemal jara' luz je xsakersan ta quebey wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Camic remjon rsakersic canm je' wnak chpam k'ejku'm, ja' k'ejku'm mxecwin ta xuchup jawra luz. ");
INSERT INTO tzjE_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","C'o c'a jun acha xta'k ta rmal Dios, Juan rubi'. ");
INSERT INTO tzjE_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Rsamaj je xya' tzra, jara' nuya' rbixic nak rbanic Rlec'walxel je nsakersana quebey je' wnak ch-utz c'ara' conjelal j-e' wnak tak xtecc'axaj neyke'a quec'u'x ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mja' ta luz, xerwara' xta'k ta rmal Dios chnuya' rbixic nak rbanic luz. ");
INSERT INTO tzjE_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Je ktzitzij luz rxin Dios xpeta wawe' chwech ruch'lew, arja' nsakersana canm conjelal wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ja' xerc'je'a wawe' chwech ruch'lew. Ja' wankersyona ruch'lew per je' wnak jec'ola chwech mxecnimaj ta chja' luz. ");
INSERT INTO tzjE_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Xerc'je'a chquecjol rtnamet per j-e' majo'n xquec'ul ta. ");
INSERT INTO tzjE_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Per konjelal ajoj je xkac'ul pkanm y xeyke'a kac'u'x ruq'uin, arja' xuya' chka che xok-oca rlec'wal Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Jara' xokalex chic wjic y jawra c'aslemal yatanak chic chka me c'mon pta cmal kti't kawma', myatanak ta chka cmal kadta' kate', y mjun ta wnak xyowa chka, ruyon Dios xyowa chka. ");
INSERT INTO tzjE_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Je Rlec'walxel je Rtzojbal Dios arja' xkaj ta, xoca wnak, xec'je'a chkacjol. Xkatz'et regloria y nmajo'n chic jun gloria cara' ta, com ja' Ttixel majo'n chic jun Rlec'wal cara' ta, arja' nnojnak utzil rxin Dios pranm. Njelal jnuch'ob, njelal je nbij, y njelal jnuban ne ktzitzij wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Xya'a rbixic rmal Juan y cawra xbij Juan chca wnak: —Ja c'a wa' acha jxenbij chewa tak cawrara xenbij, c'o jun mja'na tumaj rsamaj, arja' más nim na ruk'ij chenwech anen. Cara' quenbij perc arja' c'o chic tak mja'na quenalexa mesque anen en nabey wnak chwech, cara' xenbij chewa. Cara' xbij Juan. ");
INSERT INTO tzjE_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Je Rlec'walxel arja' ajni'la nojnak utzil rxin Dios pranm y jara' utzil xya'a chka ajoj, y chkajni' nq'uiya ptak kanm y xsipan chka. ");
INSERT INTO tzjE_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Je rley Dios tzra Moisés xya' wa' che ntz'ibaj cana, per utzil je nsipaj Dios y jtotanem che ktzitzij wa' chtotanem jara' Jesucristo c'amyon ta. ");
INSERT INTO tzjE_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Next jun wnak tz'etyon ta rxin Dios per je Rlec'wal Dios arja' nk'alsana chkawech ajni' rna'oj Dios. Ruyon oca ja' c'ola pranm Ttixel, xjun quebnon ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juan xeta'k ela jle' ach-i' ruq'uin cmal aj Israel che necc'axaj tzra nak rbanic. J-ewra ach-i' pJerusalén xe'el el wa', jle' chca e sacerdote y jle' chic e levita. Tak xe'ekaja ruq'uin cawra xecbij tzra: —¿Nak abanic atet? ");
INSERT INTO tzjE_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan xk'alsaj chquewech che mja' ta Cristo. ");
INSERT INTO tzjE_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Y xecc'axaj chic tzra: —¿Nak atocnak wc'a? ¿Mex c'a atet at Elías? Cara' xecc'axaj tzra. —Manen ta, cara' xbij Juan. Xecc'axaj chic tzra: —¿Mex c'a atet at profeta je ncatpet na jbin cana chka? —Manen ta chka', xbij chic Juan. ");
INSERT INTO tzjE_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Xecc'axaj chic jmul tzra: —¿Nak c'a abanic? Tbij chka nak abanic ch-utz c'ara' nbekbij chca nak etakyon ta kxin awq'uin, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan cawrara xbij chca: —Nbanic anen jara' ajni' rtz'iban cana ojer profeta Isaías jcawra nbij: —C'ola jun kul nc'axaxa chpam jun tenlic lwar y cawra nbij ra: —Tchumsaj rubey Kajaw Dios, jic tey-a'. Cara' tz'iban cana. Anen c'ara' quenrbij je rtz'iban cana Isaías, cara' xbij Juan chca. ");
INSERT INTO tzjE_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","J-era' ach-i' jetkon ela ruq'uin Juan, fariseo etakyon ela cxin. ");
INSERT INTO tzjE_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Y cawra xecc'axaj chic tzra: —Wmatet ta at Cristo, next at Elías, next at profeta jkeyben che npe na ¿nak tzra c'ara' nque'aban bautizar wnak? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan xbij chca: —Per anen xya' quencsaj tak quenuban bautizar wnak, per camic c'ola jun checjol más na nim ruk'ij, xerwara' majo'n ewutkin ta rwech. ");
INSERT INTO tzjE_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Anen xe rbixic rsamaj Dios quenya' je xtumaj rbanic. Arja' más na nim ruk'ij que chenwech anen, next yatala chwij xtenki'l ta ruq'uin y nexte xtenquir tnara' rc'amal rexjab, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jawra tzij xbantaja chpam jun lwar rubi' Betábara, c'ola pjupraj rbeya' rbin-an Jordán, tzra' c'a nuban wa' bautismo Juan. ");
INSERT INTO tzjE_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Rcab k'ij chic Juan xutz'et pona Jesús per q'uemja'na terkaja ruq'uin y cawra xbij chca wnak: —Tetz'ta' mpa' jala acha, ja c'ala' noca ajni' jun carne'l je nba'na sacrificar chwech Dios, arja' tkon ta rmal Dios wawe' chwech ruch'lew che nerechpu' njelal quil quemac conjelal wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ja c'ala' nbin chic chewa chnerebna' na rsamaj Dios y más nim ruk'ij que chenwech anen. Anen en nabey wnak chwech per ja' c'o chic tak q'uemja'na quenalexa anen, cara' nbin chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Anen nabey majo'n wutkin ta chja' To'onel je tkon ta rmal Dios per rmal ja' enpenak camic, nemjon bautismo cxin wnak tzra ya'. Cara' nemjon rbanic ch-utz c'ara' chajoj ok aj Israel nkutkij chja' To'onel je tkon ta rmal Dios, cara' xbij Juan chca. ");
INSERT INTO tzjE_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Y xbij chic chca: —Anen xentz'et Espíritu Santo penak chcaj ajni' jun tz'quin jpaloma xkaj ta y xec'je'a junlic ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Per nabey majo'n wutkin ta chja' To'onel je tkon ta rmal Dios per Dios xk'alsaj chenwech. Dios enretkon ta chquenuban bautizar je' wnak tzra ya' y cawra rbin chwa: —Tak xtatz'et acha tak xtkaj ta Espíritu Santo ruq'uin, y Espíritu junlic nec'je'a ruq'uin, ja c'a ra' xtebnowa bautizar cxin je' wnak tzra Espíritu Santo. Cara' xbij chwa. ");
INSERT INTO tzjE_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ajni' xbij chwa cara' xentz'et, y camic quenbij chewa chja' Rlec'wal Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Rcab k'ij chic Juan c'o chic jmul tzra' chpam lwar, ec'ola e c-e' rdiscípulo rexbil. ");
INSERT INTO tzjE_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ja' Jesús xk'axa chquecjol wnak y tak xtz'e'ta rmal Juan cawra xbij: —Tetz'ta' mpa' jala acha noca ajni' jun carne'l je nba'na sacrificar chwech Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Je c-e' rdiscípulo Juan tak xecc'axaj je xbij, j-e' xetre' ela tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ja' Jesús tak xca'ya tzrij xerutz'et ch-etrena tzrij: —¿Nak necanoj? cara' xc'axaj chca. —Rabí ¿abar atc'o wa'? (Rabí nbij tzij tijonel.) ");
INSERT INTO tzjE_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Cawra xbij Jesús chca: —Jo' quixtre' ta chwij, ekatz'ta' abar enc'o wa', y xetre' ela tzrij. Xe'ekaj c'a abar c'o wa' y jara' tk'ak'ij xec'je'a ruq'uin, com a las cuatro rxin tk'ak'ij chic. ");
INSERT INTO tzjE_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jun chca e c-e' ach-i' jxec'axana je xbij Juan y xetre' ela tzrij Jesús, arja' Andrés rubi', rch'alal Simón Pedro. ");
INSERT INTO tzjE_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ja' Andrés xba alnak ruq'uin rch'alal Simón y cawra xbij tzra: —Camic xkawil Mesías, cara' xbij tzra. (Mesías nbij tzij Cristo.) ");
INSERT INTO tzjE_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","C'jara' xuc'om ela ruq'uin Jesús. Tak xekaja Simón xer xtz'e'ta rmal Jesús y cawra xbixa tzra: —Atet at Simón at rlec'wal Jonás per camic nyataja jun bi'aj chic chawa, nbixa chawa Cefas. (Cefas nbij tzij Pedro, o abaj.) ");
INSERT INTO tzjE_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Rcab k'ij chic Jesús xuch'ob nba chpam departamento Galilea, xuwil Felipe y xbij tzra: —Jo' catetre'a chwij, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe arja' aj Betsaida, jara' rtnamet Andrés ruq'uin Pedro, c'ola precwent Galilea. ");
INSERT INTO tzjE_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ja' Felipe xba ruq'uin Natanael y xbij tzra: —Camic kawlon chic ajoj jara' acha To'onel jtz'iban cana chpam rley Dios rmal Moisés che npe na, y tz'iban cana chka' cmal nic'aj chic profeta, jara' Jesús aj Nazaret, rlec'wal José. ");
INSERT INTO tzjE_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael xbij: —¿Lc'ola jun acha nwankera pNazaret utzlaj acha? cara' xc'axaj. —Jo' ekatz'ta', cara' xbij Felipe, y xeba. ");
INSERT INTO tzjE_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tak xekaja Natanael xer xtz'e'ta rmal Jesús y cawra xbij ja' Jesús: —Tetz'ta' mpa' Natanael penak, arja' aj Israel per ne ktzitzij wa' aj Israel, arja' kas utzlaj acha y majo'n tz'koj tzij nuban ta, cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ja' Natanael xc'axaj nak xbixa tzra rmal Jesús y cawra xc'axaj tzra: —¿Nak tzer c'ara' awutkin chic nwech? —Tak q'uemja'na tcatsiq'uisa rmal Felipe xatnutz'et atetz'bula chuxe' jun che' higuera, cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Rabí, camic xch'obtaja nmal chatet at Rlec'wal Dios, atet at Rey kxin ja ok tnamet Israel, cara' xbij Natanael tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","—Alnak xnanimaj rmal jxenbij chawa che xatnutz'et atetz'bula chuxe' jun che', per c'o na nmak tak milagro natz'et na y más na nmak chwech ajni' xatzu' camic, cara' xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","C'jara' Jesús xbij cawra chca: —Ne ktzitzij wa' jawra je xtenbij chewa, netz'et na rwech caj jkala, nque'etz'et na je ángel rxin Dios nquejte'a y nquexle'a, per nmal anen tak nyataja chca chcara' nqueban, nmal anen ja en Rlec'walxel jxenoca alxic cuq'uin wnak, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Rox k'ij c'ola jun c'ulbic xbantaja, rute' Jesús c'ola tzra'. Jara' c'ulbic xbantaja chpam tnamet Caná jc'ola precwent Galilea. ");
INSERT INTO tzjE_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chka' siq'uin Jesús chpam jara' c'ulbic e rexbil rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Y xjurat xq'uisa vino, y xbixa tzra rmal rute': —Majo'n chic vino, xq'uisa junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—Ixak, mjunam ta nkach'ob awq'uin. Q'uemja'na terla' k'ij wxin tak xtutkixa nwech nak nbanic, cara' xbij Jesús tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","C'jara' jrute' xbij chca je' wnak je nque'ilina: —Nak xtbij Jesús chewa jara' c'a tebna', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tzra' c'ola wajki' rc'olibal ya' abaj ocnak, chpam jujun nba c-e' o oxi' chnaw ya', per ne nmak tak chnaw. Je rsamaj noc wa' jawra rc'olibal ya' jara' necbanbej ccostumbre aj Israel ch-utz c'ara' ch'ajch'oj nqueban com cara' nrajo' creligión che nqueban. ");
INSERT INTO tzjE_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús xbij chca je nque'ilina: —Tnojsaj rc'olibal ya'. Y cara' xqueban, xbequec'ma' ta ya' y xecnojsaj. ");
INSERT INTO tzjE_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tak xnojstaja cmal c'jara' cawra xbix chic chca rmal Jesús: —Camic teplu' ela, ec'tu' chwech acha jpa'la tzrij jawra c'ulbic. Y cara' xqueban, xquepul ela. ");
INSERT INTO tzjE_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Je nque'ilina jxepluw ela ya' j-e' bien cutkin chjara' ya' xq'uextaja y xoca vino. Per ja acha jpa'la tzrij w-im rxin c'ulbic majo'n rutkin ta. Tak xuna' vino chcongan wen xsiq'uij acha jxec'le'a ");
INSERT INTO tzjE_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","y cawra xbij tzra: —Conjelal wnak jnechumsaj nmak tak w-im arj-e' utzlaj tak vino nqueya' nabey mul tak nmajtaja w-im. Je' wnak tak ntitaja q'uiy cmal c'jara' nya'a chca vino mkas twen, per atet camic xer q'uisbal xaya' wa' utzlaj vino, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jawra nabey milagro xuban Jesús, tzra' xuban wa' chpam tnamet Caná jc'ola precwent Galilea. Jawa' xc'utbej chquewech rdiscípulo chajni'la nim ruk'ij y j-e' xeyke'a quec'u'x ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jesús tak xec'choj cana jawra rmal xba chpam tnamet Capernaum rexbil rute' ruq'uin je rch'alal y je rdiscípulo chka'. Tak xe'ekaja xec'je' na c-e' oxi' k'ij tzra'. ");
INSERT INTO tzjE_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tak xyamer nimk'ij pascua cxin aj Israel Jesús xba chpam tnamet Jerusalén. ");
INSERT INTO tzjE_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tak xekaja xoca chpam nimlaj rtemplo Dios. Y chpam templo ec'ola wnak quemjon rc'ayxic wajquex, carne'l ruq'uin ch'tak je' tz'quin rxin pjay, y ec'ola e c'xoy tak pak chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesús xbanla' jun asiar. Tak xec'choja rmal xerelsaj ta chpam rtemplo Dios conjelal wnak, next jun xec'je' cana. Xerelsaj ta carne'l ruq'uin wajquex chka', y je e c'xoy tak pak xch'akixa chquewech je' cpak, y je' cmes xch'akixa ptak ulew chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","C'jara' xbij chca e c'yil tak tz'quin: —Que'elsaj ela jlal jawrara, mteban ta tzra rtemplo Dios ajni' jun q'uebal, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Y je' rdiscípulo xerkaja pquewá' ajni' tz'ibtala chpam rtzojbal Dios tzrij Cristo y cawra nbij: —Je' wnak je nqueban tzra awuchoch, anen congan nti'ona wanm rmal. Camic quenc'ut chquewech che m-utz ta je nqueban, lowlo' opech xtqueban chwa. ");
INSERT INTO tzjE_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","J-e' aj Israel xecc'axaj tzra: —¿Nak nac'utbej chkawech chc'ola ak'a' tzra ajni' xaban kaja chpam rtemplo Dios? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","—Tetru' mpa' jawra santlaj rtemplo Dios y pnoxi' k'ij quenyic wa', cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","J-e' aj Israel xecbij tzra: —Jawra santlaj templo xuban cuarentiséis juna' majtanak rbanic. ¿Nak tzra c'ara' xe pnoxi' k'ij nayic wa' atet? Cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per Jesús, jsantlaj templo xnataj jara' recuerpo. ");
INSERT INTO tzjE_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tak xc'astaja Jesús chquecjol cnomki' je' rdiscípulo xerkaja pquewá' je rbin tzra santlaj rtemplo Dios che choxi' k'ij nuyic wa', xecnimaj jtz'iban cana chpam rtzojbal Dios ojer y xecnimaj chka' je rbin cana Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús tak xec'je' cana pJerusalén y tak xba'na w-im rxin nimk'ij pascua e q'uiy je' wnak xeyke'a quec'u'x ruq'uin rmal je' milagro jxuban chquewech. ");
INSERT INTO tzjE_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per ja' mxeyke' ta ruc'u'x cuq'uin com rutkin nak cbanic conjelal wnak, ");
INSERT INTO tzjE_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","y majo'n jun xtbin ta tzra nak cbanic wnak com ja' bien rutkin canm conjelal wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","C'o jun acha aj fariseo rubi' Nicodemo, y jara' jun nimlaj acha cxin aj Israel. ");
INSERT INTO tzjE_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Xuban jmul xekaja ruq'uin Jesús chak'a', xumaj tzij ruq'uin y cawra xbij: —Rabí, ajoj kutkin at jun tijonel atetkon ta rmal Dios com anen wutkin majo'n jun xtecwin ta xtuban nmak tak milagro ajni' naban atet we mquita Dios c'ola ruq'uin, cara' xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús xbij tzra: —Ne ktzij wa' quenbij chawa, je' wnak nc'atzina chca che nque'alexa wjic chic, o wxmajo'n xtque'alax ta majo'n nquecwina nquetzu' rgobierno Dios, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—¿Lnecwin c'a jun rilaj acha nalex chic jmul? ¿Lnecwin chc'ara' nalex chic jmul chuk'a' rute'? ");
INSERT INTO tzjE_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús xbij: —Ktzitzij wa' quenbij chawa, wmajo'n xtcatalex ta tzra ya' y tzra Espíritu mesquier ncatecwina ncatoca chpam rgobierno Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Je cc'aslemal wnak jyatanak cmal quedta' y quete' ncara' ajni' cc'aslemal quedta' y quete'. Jc'aslemal jnuya' Espíritu ncara' ajni' rc'aslemal Espíritu. ");
INSERT INTO tzjE_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mex junwa' xawc'axaj jxenbij chawa je nc'atzina ncatalex chic jmul. ");
INSERT INTO tzjE_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ajni' tzra k'ek', tzra xecmel, chka abar nba wa' per nawc'axaj tak nk'axa per mawutkin ta abar penak wa' y abar tzra' nba wa'. Cara' chca conjelal wnak tak nque'alaxa rmal Espíritu, numaj samaj Espíritu rmal ra' tak ncatalex chic jmul, cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","¿Nak c'a kas mer rbanic ja amjon rbixic chwa? xc'axaj chic jmul Nicodemo. ");
INSERT INTO tzjE_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús xbij tzra: —Atet wan ncattijona cxin aj Israel jretnamet Dios, per mtekaja pnawá' y mesquier nch'obtaja awmal jquenbij chawa. ");
INSERT INTO tzjE_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Per ajoj bien kutkin jnekbij chewa y bien katz'ton jnekk'alsaj chewech, per ixix majo'n nenimaj ta jnekbij chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Anen nemjon rch'obic chawech je nbantaja wawe' chwech ruch'lew per mtanimaj, peor c'ara' tak xtench'ob chawech nak nbantaja chcaj, majo'n nanimaj ta chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Majo'n jun kanak ta chcaj retz'ton ta nak rbanic tzra', xjun tz'etyon ta, jtz'etyon ta jara' Rlec'walxel je xkaj ta chcaj, xoca alxic cuq'uin wnak y c'ola pranm Ttixel chcaj. ");
INSERT INTO tzjE_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ajni' xuban Moisés ojer chpam chkilaj lwar, xjotba' rechbal cmetz chwech jun che' y xetotaja wnak rmal, cara' c'a xtba'na tzra Rlec'walxel jxoca alxic cuq'uin wnak, chka' njotbax na chwech jun che'. ");
INSERT INTO tzjE_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Cara' nba'na tzra ch-utz c'ara' conjelal je xteyke'a quec'u'x ruq'uin majo'n nqueba ta chpam nimlaj lowlo' y nyataja chca utzlaj c'aslemal rxin Dios je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dios ajni'la nquerajo' conjelal wnak rmal c'ara' xutak ta wawe' chwech ruch'lew Rlec'wal je njun oca, cara' xuban ch-utz c'ara' che conjelal je xteyke'a quec'u'x ruq'uin majo'n nqueba ta chpam nimlaj lowlo' y nyataja chca utzlaj c'aslemal rxin Dios je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Cara' quenbij com Dios mxutak pta Rlec'wal che nquerutak ela wnak chpam lowlo', je rbanic jxutak ta ch-utz c'ara' rmal Rlec'wal nquetotaja conjelal wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Conjelal wnak je xteyke'a quec'u'x ruq'uin majo'n xtk'e't xta tzij chquij, per ja c'a wmajo'n xteyke' ta quec'u'x ruq'uin jara' yatanak chic chca che nqueba chpam nimlaj lowlo'. Com majo'n xeyke' ta quec'u'x ruq'uin Rlec'wal Dios rmal c'ara' nba'na cara' chca. ");
INSERT INTO tzjE_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","J-e' majo'n xcajo' ta luz jpenak chcaj je nsakersana quebey y rmal c'ara' k'ton chic tzij chquij. Com Rlec'wal Dios arja' luz jpenak wawe' chwech ruch'lew per j-e' wnak más ncajo' k'ejku'm que chwech luz. Cara' xqueban com xitzel tak achnak quemjon rbanic. ");
INSERT INTO tzjE_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nak nquebnowa lowlo' tak achnak xitzel nquetzu' luz, majo'n cgan nquepona abar c'o wa' luz. Cara' nqueban ch-utz c'ara' majo'n nutkix ta chlowlo' tak achnak quemjon rbanic. ");
INSERT INTO tzjE_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Per nak nquebnowa rbeyal chwech Dios j-era' nquepona abar c'o wa' luz. Cara' nqueban ch-utz c'ara' nk'aljina che Dios c'ayona cxin che rbanic njelal achnak jquemjon rbanic. ");
INSERT INTO tzjE_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","C'jara' Jesús xerexbilaj ela rdiscípulo, xeba chpam jun lwar c'ola precwent Judea. Tak xekaja, tzra' xec'je' wa' y ec'ola wnak nqueruban bautizar. ");
INSERT INTO tzjE_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Cara' nuban Juan chka' nqueruban bautizar je' wnak chpam jun lwar rubi' Enón jc'ola chenkaj Salim, com tzra' sowr ya'. Xepeta je' wnak y xeba'na bautizar. ");
INSERT INTO tzjE_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jara' tiemp Juan q'uemja'na tya'a pcars rmal rey Herodes. ");
INSERT INTO tzjE_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Per je rexbil Juan y jle' chic aj Israel necch'ojquij qui' tzrij rch'obic bautismo. ");
INSERT INTO tzjE_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","J-e' rdiscípulo Juan xeba ruq'uin y cawra xecbij tzra: —Rabí, ja acha xaban bautizar jupraj rkanya' Jordán jxaya' rbixic che arja' To'onel tkon ta rmal Dios, camic arja' nqueruban bautizar je' wnak y conjelal ebnak ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan xbij chca: —Anen kas ajni'la qui' nuc'u'x ebnak wnak ruq'uin Jesús. Jsamaj nkaban chokjujnel xruyon chcaj penak wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ixix bien xewc'axaj tak xenbij chca wnak che manen ta en Cristo, anen entkon ta chquenya' rbixic che npe na. ");
INSERT INTO tzjE_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jesús yatanak tzra che nqueba conjelal wnak tzrij. Ajni' tzra jun c'jol tak nec'le'a yatanak tzra che nba rexkayil tzrij. Nbanic anen ajni' en jun amigo rxin jun c'jol tak nec'le'a. Per jara' amigo pa'l oca prupox c'jol jnec'le'a y remjon rc'axic nak nuchol, per kas congan nquicota tzan rc'axic. Cara' c'a camic chwa anen chka', congan qui' nuc'u'x, congan nojnak quicotemal ruq'uin wanm. ");
INSERT INTO tzjE_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yatanak tzra Jesús che nya' na ruk'ij más cmal wnak, y anen yatanak chwa com ajni' en majo'n. ");
INSERT INTO tzjE_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jpenak chcaj xruyon arja' nim ruk'ij chquewech conjelal wnak per ajoj ok wnak mkatz'ton ta nak rbanic chcaj, xok rxin ruch'lew, xjara' katz'ton jkutkin wawe' chuch'lew. Per jpenak chcaj xruyon ja' nim ruk'ij que chquewech conjelal wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ja' retz'ton y rc'axan ajni' rbanic chcaj y jara' remjon rbixic, per majo'n nnimax ta. ");
INSERT INTO tzjE_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Per achnak nquenimana rxin j-era' cawra necbij: —Ja' Dios ne ktzitzij wa' njelal je nbij. ");
INSERT INTO tzjE_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Com Dios takyon ta rxin Rlec'walxel rmal c'ara' rutzij Dios nbij. Cara' nuban com Espíritu je xyataj tzra rmal Dios congan nojnak pranm, next wjic mquita c'an rmal. ");
INSERT INTO tzjE_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ja' Rlec'walxel najni'la njo'xa rmal Ttixel. Chka' njelal achnak jchon pruk'a' rmal Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nak xeyke'a quec'u'x ruq'uin Rlec'walxel j-era' cc'an chic utzlaj c'aslemal rxin Dios je rxin junlic. Per nak majo'n ncajo' ta necnimaj Rlec'walxel j-era' majo'n nquewil ta utzlaj c'aslemal y q'uec'o na chpam ryiwal Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","J-e' fariseo xekaja rbixic cuq'uin cawrara: —Jesús congan e q'uiy wnak e'ocnak rdiscípulo que chwech Juan y congan e q'uiy nqueruban bautizar chka', cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Per mja' ta Jesús nebnowa bautismo, xe rdiscípulo nquebnowa. ");
INSERT INTO tzjE_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Je Kjawal Jesús tak xc'axaj chcara' xekaja rbixic cuq'uin fariseo c'jara' xel ela chpam departamento Judea y nk'axa chpam departamento Galilea. ");
INSERT INTO tzjE_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Per nc'atzina nk'ax na chpam departamento Samaria. ");
INSERT INTO tzjE_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Xekaja chenkaj jun tnamet rbin-an Sicar c'ola precwent Samaria. Jara' tnamet c'ola chenkaj ruq'uin rulew Jacob je xsipaj cana ojer tzra José je rlec'wal. ");
INSERT INTO tzjE_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tzra' c'o wa' jun ya' c'ton rmal Jacob ojer. Jesús congan cosnak rmal binem, xetz'be'a chuchi' poz rxin ya'. Jara' hor ptak nc'ajk'ij tak xekaja tzra'. ");
INSERT INTO tzjE_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","C'o c'a jun ixak aj Samaria xerkaja pe plun ya' abar tz'bul wa' Jesús. Jesús xbij tzra: —Tsipaj jtz'it ya'. ");
INSERT INTO tzjE_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Je rdiscípulo Jesús ebnak ptnamet e lk'oy way. ");
INSERT INTO tzjE_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Y ja' ixak xbij tzra Jesús: —Per at aj Israel wan y anen en jun ixak en aj Samaria. ¿Nak tzra nac'utuj ya' chwa? cara' xbij ja' ixak com j-e' aj Israel y ruq'uin aj Samaria itzel quetz'ton qui'. ");
INSERT INTO tzjE_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús xbij tzra: —Per wext nch'obtaja awmal jcochinem je nsipaj Dios chawa, y wext nch'obtaj awmal nak rbanic je ntzijona awq'uin camic ra je nc'utuj ya' chawa, atet nac'utuj ta ya' tzra y ja' nuya' chawa jun ya' rec'mon ta jun c'ac'laj c'aslemal. ");
INSERT INTO tzjE_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Per majo'n achnak napulbej wa' ya' y congan nim rpam jul. ¿Abar c'o wa' ya' jxabij chwa? ");
INSERT INTO tzjE_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kawma' Jacob arja' yoyon cana jawra ya' chka ojer. Jawra ya' xquetaj chka' je rlec'wal ruq'uin je' rwajcax. ¿Latet c'a más nim ak'ij que chwech ja'? cara' xbij ixak tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús xbij tzra: —Nak nquetjowa jawra ya' majo'n nquetotaj ta tzan chkij chi'ij. ");
INSERT INTO tzjE_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Per achnak xtetjowa ya' jquentzujuj anen jara' ntotaja rxin junlic tzan chkij chi'ij. Jya' jquenya' chca najni'la npulin ta ptak canm, cara' nuban ajni' jun tz'ucnel ya' rec'mon ta chca utzlaj c'aslemal rxin Dios je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Jya' nabij tey-a' jtz'it wxin ch-utz c'ara' quentotaja tzan chkij chi'ij junlic ch-utz c'ara' majo'n quenpet xta wawe' xtenreplu' xta jawra ya', cara' xbij ja' ixak. ");
INSERT INTO tzjE_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Camic jat asiq'uij awechjil che nquixpeta wawe' ruq'uin, cara' xbij Jesús tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Per anen majo'n wechjil, cara' xbij ja' ixak tzra Jesús. —Ne ktzij wa' nabij majo'n awechjil. ");
INSERT INTO tzjE_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Com ec'ola e j-o' awechjil ejchon ewi' cuq'uin y ja acha jcongan qui' ac'u'x ruq'uin camic mawechjil tc'ara'. Ne ktzij wa' xabij chwa, cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Quench'ob kanen mex c'a at jun profeta rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kti't kawma' ajoj ojer pe rwá' jala jun jyu' nqueya' wa' ruk'ij Dios per nebij ixix camic chpam Jerusalén nya' wa' ruk'ij, cara' nbij ja' ixak. ");
INSERT INTO tzjE_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—Tnimaj c'a je xtenbij chawa camic, ntajina nerkaja tiemp tak me xruyon ta pe rwá' jala jun jyu' neya' wa' ruk'ij Ttixel y me xruyon ta pJerusalén chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ixix ix aj Samaria neya' ruk'ij jun Dios per mch'obtanak ta ewmal nak rbanic. Per ajoj ok aj Israel nkaya' ruk'ij Dios y ch'obtanak kmal nak rbanic com ja' To'onel nta'k ta rmal Dios y chkacjol ajoj nwanker wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Per xyamer nerkaja tiemp tak je' wnak ne pcanm nalex wa' che necyabej ruk'ij Ttixel, per ne ktzitzij wa' nqueban y mchek tcostumbre. Cara' rbanic com cara' nrajo' Ttixel che nba'na tzra y nquercanoj nak nquebnowa cara' tzra. Camic ra ec'o chic jujun cara' nqueban chic. ");
INSERT INTO tzjE_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios arja' Espíritu, majo'n ntz'ettaj ta. J-e' wnak nc'atzina chca ne pcanm nalex wa' jnecyabej ruk'ij. Chka' nc'atzina chca che ne ktzitzij wa' nqueya' ruk'ij y mcostumbre ta nqueban, cara' xbij Jesús tzra ixak. ");
INSERT INTO tzjE_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ja' ixak xbij tzra Jesús: —Anen wutkin che npe na Mesías y arja' nuch'ob chkawech nak rbanic njelal je' achnak, cara' xbij. (Mesías nbij tzij Cristo.) ");
INSERT INTO tzjE_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Anen c'ara' en Mesías jnemjon tzij awq'uin camic ra, cara' xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kas quemjon tzij tak xe'erkaja rdiscípulo Jesús. J-e' kas junwa' xquetz'et tak remjon tzij ruq'uin jun ixak. Per next jun chca xecwin ta xc'axaj tzra: —¿Nak nawajo' tzra? o: —¿Nak natzijoj ruq'uin? ");
INSERT INTO tzjE_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ja' ixak xuya' cana rechnaw y xba chpam tnamet. Tak xekaja xbij chca conjelal wnak cawrara: ");
INSERT INTO tzjE_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—C'o jun acha xoktzijona ruq'uin, arja' xbij chwa njelal nak nebnon chpam nc'aslemal. Jo' mpa' ekatz'ta', mex jara' Cristo, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","C'jara' xe'el ela chpam tnamet y xeba abar c'o wa' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tak q'uemja'na que'ekaja, je' rdiscípulo xecbij tzra Jesús: —Rabí, catwa'a. ");
INSERT INTO tzjE_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Per Jesús xbij chca: —Anen c'ola nway quentaj per ixix majo'n ewutkin ta nak rbanic, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Je rdiscípulo xecbij je' chbil tak qui': —Mex c'ola jun c'amyon ta rway, cara' xquech'ob. ");
INSERT INTO tzjE_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús xbij chca: —Anen jocnak nway jara' quenban jachnak nrajo' ranm Dios jtakyon ta wxin, y chka' che quenq'uis rsamaj jrey-on chwa. ");
INSERT INTO tzjE_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jnebij ixix che cji' ic' nel twa' cosecha per anen quenbij chewa, que'etz'ta' mpa' je' wnak je epenak, j-e' c'a e jun tejco'n k'an chic, utz chic nch'u'pa. ");
INSERT INTO tzjE_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nak xtquech'puwa jawra tejco'n nto'j na quek'ij. Jtejco'n jara' nquecsasa wnak chpam utzlaj c'aslemal rxin Dios je rxin junlic. Cara' rbanic, nak netcowa tejco'n congan nquicota y nak nebnowa cosechar chka' nquicota ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Cara' rbanic ajni' nbij jun tzij je kc'axan: —C'ola jun netcowa ija'tz y c'ola nebnowa cosechar, cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Anen xixnutak ela cuq'uin wnak che nque'ebna' cosechar per me ixix ta xixtjowa pen che rbanic samaj, per ixix camic nquixtajina neban cosechar jquetcon ta j-e', cara' xbij Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tak aj Samaria xecc'axaj je xbixa chca rmal ixak chJesús xbij tzra njelal jrebnon chpam rc'aslemal, e q'uiy chca xeyke'a quec'u'x ruq'uin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Rmal c'ara' tak xe'ekaja aj Samaria ruq'uin Jesús xecbij tzra chnec'je'a cuq'uin, y cara' xuban xec'je'a c-e' k'ij cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tak xumaj tzij Jesús cuq'uin e q'uiy je' wnak xeyke'a quec'u'x ruq'uin rmal jxuchol chca. ");
INSERT INTO tzjE_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Y xecbij tzra ixak: —Nabey mul xeyke'a kac'u'x ruq'uin jxachol chka per camic más xeyke'a kac'u'x ruq'uin com xekc'axaj je xbij y xkutkij che ktzij wa' ja' Cristo, To'onel kxin konjelal ok wnak, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jesús tak xetz'kata c-e' k'ij rmal xe'el ela tzra' y xba chpam departamento Galilea. ");
INSERT INTO tzjE_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","C'ola jun tzij rbin Jesus cawrara: —Jun profeta rxin Dios majo'n nya' ta ruk'ij cmal je' rwinak. ");
INSERT INTO tzjE_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tak xe'ekaj chic kas qui'il rc'ulic xba'na cmal aj Galilea. Cara' xqueban com xquetz'et njelal jxuban Jesús pJerusalén chpam nimk'ij pascua com j-e' xjun xepe wa' chpam nimk'ij. ");
INSERT INTO tzjE_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Xekaj chic jmul chpam tnamet Caná jc'ola precwent Galilea jabar xuban wa' vino tzra ya'. C'ola jun oficial rxin rey jc'ola chpam tnamet Capernaum, c'o c'a jun rlec'wal yawa'. ");
INSERT INTO tzjE_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ja' oficial tak xc'axaj chJesús elnak ta pJudea y c'o chic pGalilea arja' xba ruq'uin. Tak xekaja xbij tzra: —Jo' pka jurmaj wq'uin, achumsaj wlec'wal, xyamer ncoma, cara' xbij tzra Jesús. Jesús xbij tzra: ");
INSERT INTO tzjE_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","—Che mquita milagro quenban chewech majo'n cnenimaj ta. ");
INSERT INTO tzjE_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ja' oficial xbij chic jmul: —Jo' pka jurmaj wq'uin, wlec'wal xyamer ncoma. ");
INSERT INTO tzjE_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Jat, awlec'wal chumtanak chic, majo'n ncom xta, cara' xbix tzra rmal Jesús. Ja' oficial xnimaj y xba. ");
INSERT INTO tzjE_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kas xemloja pruchoch xeruc'ul je' rmos y cawra xbixa tzra: —Awlec'wal chumtanak chic, majo'n chic ncom ta. ");
INSERT INTO tzjE_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—¿Nak hor xula rwech? cara' xc'axaj chca. —Iwir a la una rxin tk'ak'ij xpaxij ri' c'ten tzrij, cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ja' ttixel xerkaja pe rwá' chjara' hor xbixa tzra rmal Jesús che: —Awlec'wal majo'n ncom xta, y congan xeyke'a ruc'u'x ruq'uin, y cara' chka' xqueban conjelal jec'ola pruchoch. ");
INSERT INTO tzjE_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ja c'a wa' rucab milagro xuban Jesús tak xel ta pJudea y xekaj chic pGalilea. ");
INSERT INTO tzjE_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Xerla' chic jun k'ij c'ola jun nimk'ij cxin aj Israel y xba Jesús pJerusalén. ");
INSERT INTO tzjE_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tzra' pJerusalén c'ola jun ya', jrubi' jara' ya' nbixa pe ctzojbal aj Israel, Betesda. Chenkaj chuchi' jun portón c'ol wa' ja' ya' abar ncatoc el wa' chpam tnamet. Jara' portón rubi' nbixa, portón cxin carne'l. Abar c'o wa' ya' tzra' c'o wa' j-o' jay cxin yuw-i' che nquec'je'a chuxe'. ");
INSERT INTO tzjE_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","E q'uiy je' yuw-i' ec'ola tzra', ajni' chca moya', je' wnak ch'e'y nquebina, y je' sic chka'. J-e' queyben che nkaj ta jun ángel che neresla' ya'. ");
INSERT INTO tzjE_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Com c'ola jun ángel nkaj ta che neresla' ya'. Tak nusil chic ri' ya' j-e' yuw-i' nque'oca chpam. Nak xtpona nabey mul chpam jara' ya' nchumtaja chka bechnak opech yubil rc'an. ");
INSERT INTO tzjE_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","C'ola jun acha tzra' yawa' xuban treintiocho juna' teywaja. ");
INSERT INTO tzjE_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús tak xutz'et yawa' ctz'ela rutkin chic che c'o chic tiemp c'ola tzra' y cawra xbij tzra: —¿Nawajo' ncatchumtaja? ");
INSERT INTO tzjE_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Per nmajo'n nak nc'ana wxin chpam ya' tak nusil ri', y tak quenba jun chwa' npona nabey mul chenwech. ");
INSERT INTO tzjE_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—Catyictaja, tec'ma' ela awarbal y ncatba, cara' xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Y jara' hor xchumtaja jara' acha, xuc'ol ela rwarbal y xba. Jk'ij je xchumsasa jara' jun k'ij rxin xlanbal. ");
INSERT INTO tzjE_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Rmal c'ara' xbixa tzra cmal aj Israel cawrara: —Camic xlanbal k'ij, xjan nawc'aj awarbal. ");
INSERT INTO tzjE_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—Per ja' acha je xchumsana wxin jara' xbina chwa chquenc'ol ela nwarbal y quenba, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—¿Nak acha c'ara' xbina chawa chcara' naban? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Per jara' acha mrutkin ta rwech nak xchumsana rxin com Jesús elnak el chic y xoca chquecjol e q'uiy wnak jec'ola tzra'. ");
INSERT INTO tzjE_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Xe'iltaj c'a jara' acha chpam templo rmal Jesús y xbixa tzra: —Camic xatchumtaja, mtaban xtc'a lowlo' ch-utz c'ara' me tpe ta chpam ac'aslemal jun chic achnak más lowlo', cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","C'jara' jara' acha xba y xerbij chca aj Israel che Jesús xchumsana rxin. ");
INSERT INTO tzjE_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Com Jesús nquerchumsaj wnak chpam xlanbal k'ij rmal c'ara' aj Israel nqueban rij rwech nak nqueban tzra che neccamsaj: —¿Nak tzra c'ara' nesmaja chpam xlanbal k'ij? cara' necbij. ");
INSERT INTO tzjE_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús xbij chca: —Nedta' remjon samaj camic y anen chka' nquensmaj wa', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Rmal c'ara' aj Israel más xquemaj rch'obic nak nqueban tzra che neccamsaj com c-e' ril Jesús necbij chic. Jun ril jxuban, xchumsaj acha chpam xlanbal k'ij, y jun chic, xbij che Dios redta' y xjumsaj ri' ruq'uin Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","C'jara' Jesús cawra xbij chca: —Ne ktzij wa' je xtenbij chewa ra', je Rlec'walxel majo'n xtuban ta mandar ri' ruyon kaja, xtuban ta je' achnak je nrajo'. Ja' ejemplo rxin Ttixel nuban. Ajni' nuban Ttixel jara' quenban anen chka' en Rlec'walxel. ");
INSERT INTO tzjE_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ttixel com ajni'la nrajo' Rlec'walxel rmal c'ara' nuc'ut njelal samaj chwech jremjon rbanic. Y c'o na samaj nuc'ut na chwech más na nmak chwech jawra jemjon rtz'etic camic. Cara' nuban ch-utz c'ara' ixix kas junwa' nena' tak xtetzu'. ");
INSERT INTO tzjE_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ja' Ttixel nquerc'asba' cnomki' y nuya' chic wjic cc'aslemal. Y cara' nuban Rlec'walxel chka', nuya' c'aslemal chca wnak chka bechnak cbanic tak nrajo' nuya' chca. ");
INSERT INTO tzjE_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ja' Ttixel majo'n xtuk'at ta tzij tzrij jun per jrebnon, rejchon pruk'a' Rlec'walxel chja' nek'towa njelal je' tzij. ");
INSERT INTO tzjE_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Cara' rebnon ch-utz c'ara' Rlec'walxel nya'a ruk'ij cmal wnak ajni' nba'na tzra Ttixel je nya'a ruk'ij. Wc'ola jun mtuya' ruk'ij Rlec'walxel tzra' ntz'e't wa' majo'n nuya' ta ruk'ij Ttixel com ja' takyon ta Rlec'walxel. ");
INSERT INTO tzjE_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ne ktzitzij wa' je xtenbij chewa, wc'ola jun nuya' rexquin tzrij ntzojbal y ykula ruc'u'x ruq'uin Ttixel jtakyon ta wxin jara' rc'an chic utzlaj c'aslemal rxin Dios je rxin junlic, majo'n nba xta chpam nimlaj lowlo', xel ta chpam cmic y xuwil utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ne ktzitzij wa' je xtenbij chic chewa, je' cnomki' chwech Dios c'ola jun tiemp chumin tak xtecc'axaj rukul Rlec'wal Dios, y tiemp jara' camic je xmajtaj ela, y nak xtquec'axana rxin nquec'se' na chpam utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Cara' rbanic com jc'aslemal jnalax ta ruq'uin Ttixel jara' yatanak tzra Rlec'walxel rmal Ttixel chruq'uin arja' nalax twa' chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Chka' ja' Ttixel rejchon pruk'a' Rlec'walxel chja' nek'towa tzij chquij wnak com ja' xoca wnak wawe' rmal ra' yatanak tzra chja' nek'towa tzij. ");
INSERT INTO tzjE_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mex junwa' xewc'axaj jxenbij chewa com nerla' na jun k'ij tak conjelal cnomki' jemkun necc'axaj na rukul Rlec'walxel. ");
INSERT INTO tzjE_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Tak xtecc'axaj nquec'astaja conjelal. Nak xebnowa utzlaj tak achnak j-era' nquec'astaja chpam utzlaj c'aslemal je rxin junlic, y nak xebnowa lowlo' nquec'astaja y nqueta'k ela chpam nimlaj lowlo'. ");
INSERT INTO tzjE_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Anen majo'n quencsaj ta nna'oj, achnak nbij Ttixel jara' quencsaj chquenk'atbej tzij. Y ne rbeyal k'toj tzij quenban perc mjara' ta quenban je nrajo' kaja wanm anen, je nrajo' ranm Ttixel jtakyon ta wxin jara' quenban. ");
INSERT INTO tzjE_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Wext nuyon kaja quenya' testig-il chwij nquixcwin tc'ara' nebij che me ktzij ta ntestimonio. ");
INSERT INTO tzjE_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Per c'o chna jun jnuya' testimonio chwij y ne ktzij wa' testimonio jnuya'. ");
INSERT INTO tzjE_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ixix xetak rc'axic tzra Juan y arja' xoc testig chwij che ja' Dios takyon pa wxin, y ne ktzij wa' je xbij chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Per anen me nc'atzin ta chwa c'o ta jun wnak xtoc ta testig chwij, ixix ewutkin chic testimonio jxuya' Juan chwij, jawra quenbij ch-utz c'ara' newil totanem rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ja' Juan xoca ajni' jun nimlaj k'ak' jcongan nc'ata y nim rluz xpojcaj. Ixix xixec'je'a conform che rc'axic nak xuchol chewa y congan xixquicota rmal per njurmaj oca, xjurat xc'owa ec'u'x rmal. ");
INSERT INTO tzjE_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Per c'o chna jun je nyowa testimonio chwij y arja' más na nim ruk'ij que chwech jxuya' Juan. Jsamaj jnemjon rbanic jara' ocnak testig chwij, jawra samaj Ttixel yoyona chwa y jawra samaj nuc'ut chja' Ttixel takyon ta wxin. ");
INSERT INTO tzjE_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Y jun chic, ja' mism Ttixel jtakyon ta wxin rey-on ta testig-il chwij chka'. Per ixix next wjic ey-on ta ewexquin tzrij je nbixa chewa rmal Dios, majo'n ey-on ta cas tak arja' xk'alsaj ri' chewech. ");
INSERT INTO tzjE_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Y chka' majo'n ey-on ta c'as tzra che ocnak rtzojbal ptak ewanm y nk'alaj chmajo'n ocnak ta com ja' takyon ta wxin y ixix majo'n egan xtiyke' ta ec'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Bien tetz'ta' chpam rtzojbal Dios. Com ixix nech'ob che chpam rtzojbal Dios newil wa' utzlaj c'aslemal rxin Dios je rxin junlic. Per rtzojbal Dios anen quenrbij, ja' rtzojbal Dios nk'alsana nak nbanic anen. ");
INSERT INTO tzjE_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Per ixix majo'n egan xteyke' ta ec'u'x wq'uin che xtewil ta utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mjara' ta quenwajo' anen xtya' ta nuk'ij cmal wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Per xerwara' wutkin che ixix majo'n newajo' ta Dios ptak ewanm. ");
INSERT INTO tzjE_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ja' Nedta' Dios arja' takyon ta wxin per ixix majo'n egan xteyke' ta ec'u'x wq'uin, per wext c'ola jun acha ruyon nuban kaja mandar ri' y nba ewq'uin jara' neyke'a ec'u'x ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Jnewajo' ixix, neban utzlaj tak achnak ch-utz c'ara' nya'a ek'ij cmal ewexbil per majo'n xtbij ta ewanm xteban ta utzil rxin Dios, per xruyon Dios necwina nbij w-utz tak achnak emjon rij. Tak xcara' neban mesquier neyke'a ec'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Per mtech'ob ta xanen quenyowa ewil chwech Ttixel. Je nyowa ewil jara' Moisés, y ixix nebij congan ykula ec'u'x ruq'uin Moisés. ");
INSERT INTO tzjE_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wext ktzij nenimaj Moisés xnenimaj tc'ara' anen chka'. Je rtz'iban cana Moisés, anen c'ara' enrtz'iban cana ch-utz c'ara' nk'aljina nak nbanic anen. ");
INSERT INTO tzjE_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Per we xmajo'n nenimaj ta je rtz'iban cana Moisés ¿atbij xtenimaj c'ara' ntzojbal anen? cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","C'jara' xba chic Jesús pjupraj mar rxin Galilea, y nbixa tzra chka' mar Tiberias. ");
INSERT INTO tzjE_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Congan e q'uiy wnak xetre'a tzrij rmal nmak tak milagro jxuban chquewech com ec'ola je' yuw-i' xerchumsaj. ");
INSERT INTO tzjE_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Xojte'a chwech jun jyu' y xuwil jun rc'olibal, tzra' xetz'be' wa' e rexbil rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Y jara' k'ij xyamer nimk'ij pascua je nc'u'la cmal aj Israel. ");
INSERT INTO tzjE_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ja' Jesús tak xutz'et che congan wnak xe'ekaja ruq'uin xbij tzra Felipe: —¿Abar nkalok' wa' queway j-e' la' wnak? ");
INSERT INTO tzjE_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Cara' xc'axaj Jesús tzra Felipe perc ja' nrajo' nrutkij nak nuch'ob Felipe, com Jesús rutkin chic nak xtuban tak xtuya' queway wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ja' Felipe xbij: —Per wext c'ola c-e' cient denario way majo'n nqueruban ta xtquetaj ta jch'ap chejujnel. ");
INSERT INTO tzjE_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","C'ola jun discípulo rubi' Andrés, arja' rch'alal Simón Pedro, cawra xbij tzra Jesús: ");
INSERT INTO tzjE_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—C'o jun ch'it ala' wawe' ra, c'ola j-o' rkan xquelway ruq'uin, cebada ocnak, y c-e' rkan ch'tak ch'u'. ¿Nqueruban c'ala' che conjelal wnak? Congan e q'uiy. ");
INSERT INTO tzjE_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ja' Jesús xbij chca rdiscípulo: —Que'etz'uba' conjelal wnak. Com chpam jara' lwar abar ec'o wa' congan wen k'ayis abar nquetz'be' wa' chpam. Y conjelal wnak xetz'be'a, ec'o lala' e j-o' mil xqueyon ach-i'. ");
INSERT INTO tzjE_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ja' Jesús xuc'om xquelway, xmeltioxij tzra Dios y xujach chca rdiscípulo. J-e' c'a rdiscípulo xquemaj rjachic chca conjelal wnak je etz'bula y cara' xqueban tzra ch'u' chka'. Y je' wnak xquetaj ajni' xcajo' y congan xnoja quepam. ");
INSERT INTO tzjE_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tak xec'choja w-im cmal conjelal wnak xnoja quepam y Jesús cawra xbij chca rdiscípulo: —Temlo' ruchi' njelal je xcoltaj cana, mtenwajo' ntz'ilosa. ");
INSERT INTO tzjE_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","J-e' c'a rdiscípulo xquemaj rmolic njelal. Tak xmoltaja cmal xuban c'a cbeljuj chquech y congan xnoja che cbeljuj. Jara' xcoltaj cana tzra j-o' rkan xquelway y c-e' rkan ch'u' je mxecwin ta j-e' wnak xquetaj. ");
INSERT INTO tzjE_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","J-e' wnak tak xquetz'et milagro jxuban Jesús chquewech cawrara xecbij: —Jala acha ne ktzij wa' jun profeta rxin Dios jtz'iban cana chpam rtzojbal Dios che npe na. ");
INSERT INTO tzjE_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ja' Jesús xch'obtaja rmal che j-e' ncajo' nquecsaj pors rey pquewá' rmal c'ara' xel ela abar tzra' c'o wa' y xba ruyon pe rwá' jun jyu' y tzra' xec'je' wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tak xyamer noca k'ejku'm xexle'a j-e' discípulo chuchi' mar. ");
INSERT INTO tzjE_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tak xe'ekaja xe'oc ela chpam jun lanch y xeba chpam jun tnamet, Capernaum rubi', jc'ola pjupraj mar. Ocnak chic ak'a' per majo'n ponnak ta Jesús cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Per chek q'uenjlal xkaj ta jun nimlaj k'ek' chquij y congan nmak tak bloj xpeta pe rwá' mar. ");
INSERT INTO tzjE_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","C'o lala' j-o' o wajki' kilómetro quey-on cana chiya' tak chek q'uenjlal xquetz'et pona Jesús remjon binem pe rwá' ya'. Xekaja chenkaj ruq'uin lanch abar ec'o wa' chpam y j-e' congan xecxibej qui' rmal. ");
INSERT INTO tzjE_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Per Jesús cawra xbij chca: —Xanen, mtexibej ta ewi'. ");
INSERT INTO tzjE_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","C'jara' congan qui' quec'u'x y xquecsaj ela Jesús cuq'uin chpam lanch, y q'ue nquena' ec'o pon chic chpam tnamet abar nqueba wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Je rcab k'ij je' wnak jec'o cana chuchi' mar xquetz'et chmajo'n xoc el ta Jesús cuq'uin rdiscípulo chpam lanch tak xeba chpam tnamet Capernaum. Xqueyon j-e' discípulo xeba y majo'n chnara' jun lanch chic c'o ta chiya', xruyon jara' jun jxecc'aj. ");
INSERT INTO tzjE_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","C'o jle' lanch xe'el ela chpam tnamet Tiberias, xe'ekaja pjupraj mar. Je lwar abar xe'ekaj wa' jawra lanch jara' chenkaj abar xmeltioxij wa' way Jesús tzra Kadta' Dios y xerutzuk e q'uiy wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","J-e' c'a wnak jec'o cana chuchi' mar, tak xquetzu', majo'n chic Jesús y next c'a rdiscípulo chka'. C'jara' xe'oc ela ptak lanch y xeba chpam tnamet Capernaum che rconxic Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tak xe'ekaja pjupraj mar chpam tnamet Capernaum tzra' xquewil wa' Jesús y cawra xecbij tzra: —Maestro ¿nak hor xaterkaja wawe' ra? ");
INSERT INTO tzjE_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús cawra xbij chca: —Ixix cnecanoj me rmal ta che xch'obtaja ewmal nak kas mer rc'atzil jrec'mon ta jle' milagro jxenban chewech. Cnecanoj per xe rmal tak xixnutzuk tzra way y congan xnoja epam. ");
INSERT INTO tzjE_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ixix congan nquixsmaja che rconxic eway per je' way jxe nq'uisa ruk'ij. Per mxer tc'a wa' samaj neban, per quixesmaj c'a chka' che rconxic way jmajo'n nq'uis ta ruk'ij y rec'mon ta utzlaj c'aslemal rxin Dios je rxin junlic. Je Rlec'walxel jxoca alxic cuq'uin wnak jara' nsipana chewa jway jxenbij kaja chewa com Dios je Ttixel arja' rk'alsan chic chja' takyon ta Rlec'walxel, cara' xbixa chca wnak rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","—¿Nak chsamaj c'a nkaban ch-utz c'ara' rsamaj Dios nkaban? cara' xecc'axaj j-e' wnak tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Teyke'a ec'u'x ruq'uin Rlec'walxel je tkon ta rmal Dios, y tak neyke'a ec'u'x ruq'uin ja c'a ra' rsamaj Dios, cara' xbixa chca rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Y cawra xecc'axaj chic tzra: —¿Nak milagro c'a naban chnac'utbej chkawech che ktzij Dios attakyon ta? ¿Nak nac'utbej chkawech ch-utz c'ara' ncatknimaj? ¿Nak samaj amjon rij atet camic? ");
INSERT INTO tzjE_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Je kti't kawma' ojer tak xec'je'a chpam chkilaj lwar c'o jle' maná xquetaj je xta'k ta chcaj ajni' tz'ibtanak cana, y cawra nbij: —Way rxin chcaj xuya' chca che nquetaj, cara' nbij. ");
INSERT INTO tzjE_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús cawra xbij chic chca: —Jawra je xtenbij chewa ne ktzitzij wa', jway je xpeta chcaj mja' ta Moisés xyowa, per ja' Nedta' nyowa way jne ktzitzij wa' ch-way rxin chcaj. ");
INSERT INTO tzjE_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Cawra quenbij chewa perc jway jnuya' Nedta' Dios jara' jxutak ta chcaj y nuya' utzlaj c'aslemal je rxin junlic chca wnak wawe' chwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Kajaw ¿nak tzra mtaya' chka jala' way jnabij per nche njelal k'ij tey-a' chka? Cara' xecc'utuj j-e' wnak tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Y Jesús cawra xbij: —Anen c'ara' en way, anen c'ara' quenyowa utzlaj c'aslemal je rxin junlic. Je' wnak jneyke'a quec'u'x wq'uin majo'n chic wyejal xtquetaj ta y majo'n chic chkichi' xtquetaj ta chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Per ajni' nbin chic chewa, mesque enetz'ton chic per mesquier neyke'a ec'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Conjelal wnak je nqueyataja chwa rmal Ttixel j-e' c'ara' nquerkaja wq'uin. Y tak xtquerkaja wq'uin majo'n xtquench'akij el ta, conjelal quenuc'ul wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Anen xenkaj ta chcaj, enpenak en bnoy rxin je nrajo' ranm jtakyon ta wxin y mjara' ta je nyarij wanm anen quenban. ");
INSERT INTO tzjE_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Je Ttixel jtakyon ta wxin jawra nrajo' ranm: conjelal wnak jerey-on chwa majo'n jun chca xtentz'ila' ta, y tak xterla' jq'uisbal tiemp quenuyic conjelal chpam cmic. ");
INSERT INTO tzjE_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Je Ttixel jtakyon pa wxin cawra nrajo' ranm ra': che conjelal wnak je ncutkij rwech Rlec'walxel y neyke'a quec'u'x ruq'uin, j-e' c'ara' nyataja chca utzlaj c'aslemal rxin Dios je rxin junlic, y tak xterla' q'uisbal tiemp anen quenycowa cxin chpam cmic, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","J-e' c'a aj Israel xquemaj rtzojxic Jesús, majo'n qui' ta quec'u'x ruq'uin com xbij chca chja' way kanak ta chcaj. ");
INSERT INTO tzjE_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—Jala' acha wax Jesús rlec'wal José, kutkin wan quewech redta' rute'. ¿Nak tzra nbij chja' kanak ta chcaj? Cara' xecbij je'a. ");
INSERT INTO tzjE_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús cawra xbij chic chca: —Me cnetzijoj ta. ");
INSERT INTO tzjE_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Conjelal wnak je nquerkaja wq'uin chneyke'a quec'u'x wq'uin next jun chca queyon ta xtquerkaja, ne nc'atzin wa' chnec'mar ta rmal Ttixel jtakyon pa wxin. Per je nquerkaja wq'uin, tak xterla' q'uisbal tiemp anen quenycowa cxin chpam cmic che conjelal. ");
INSERT INTO tzjE_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ajni' tz'ibtanak cana chpam libro cxin profeta cawra nbij ra: —Nerla' na jun tiemp che conjelal wnak nquetijox na rmal Dios, cara' nbij. Rmal c'ara' quenbij chewa che conjelal wnak jquey-on quexquin tzrij rtzojbal Ttixel y xcutkij jrec'tun chquewech, j-e' c'ara' wnak nquerkaja wq'uin ch-utz c'ara' neyke'a quec'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Per mjara' ta quenbij chewa che ec'ola je' wnak etz'etyona rwech Ttixel. Per c'ola jun tz'etyona rwech Ttixel y jara' Rlec'walxel perc nmer ruq'uin Dios penak wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Y ne ktzitzij wa' je xtenbij chic chewa ra, je' wnak je ykul chic quec'u'x wq'uin j-e' ra' cc'an chic utzlaj c'aslemal rxin Dios je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Anen ra en way, anen quenyowa utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Je' ewti't ewma' ojer tak xec'je'a chpam chkilaj lwar xquetaj maná per jmaná majo'n xeruto' ta chpam cmic. ");
INSERT INTO tzjE_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Per jway jnemjon rbixic chewa camic jara' way kanak ta chcaj y nak xtetjowa rxin majo'n ncom xta. ");
INSERT INTO tzjE_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Jway je nyowa c'ac'laj c'aslemal, jway kanak ta chcaj, anen c'ara'. Jawra way jxenbij kaja chewa, nak xtetjowa rxin jara' nec'se'a rxin junlic. Jway je xtenya' chca wnak jec'ola wawe' chwech ruch'lew jnuya' c'ac'laj c'aslemal jara' necuerpo anen. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","J-e' c'a aj Israel xquemaj chic tzij chbil tak qui', junwa' necbij jle' y jun chwa' necbij jle' chic: —¿Nak rbanic c'ara' nbij jala' acha chnuya' recuerpo chka che nkataj? cara' necbij kaja. ");
INSERT INTO tzjE_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Y ja' Jesús cawra xbij chic chca: —Ne ktzitzij wa' je xtenbij chic chewa ra, we mtetaj recuerpo Rlec'walxel jxoca alxic cuq'uin wnak, y we mtetaj recq'uiel chka', jara' majo'n ewc'an ta utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Per nak xtetjowa necuerpo ruq'uin necq'uiel jara' rc'an chic utzlaj c'aslemal rxin Dios je rxin junlic, y tak xterla' q'uisbal tiemp anen quenycowa rxin chpam cmic. ");
INSERT INTO tzjE_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Com jnecuerpo anen jara' kas mer way y jnecq'uiel ne ktzitzij wa' ncamsbej chkichi'. ");
INSERT INTO tzjE_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nak xtquetjowa necuerpo ruq'uin necq'uiel j-e' c'ara' nquec'je'a pwanm y anen chka' quenc'je'a ptak canm. ");
INSERT INTO tzjE_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jc'aslic Ttixel arja' enretkon ta y rmal ja' tak enc'asla, y cara' chca wnak chka' je xtquetjowa necuerpo ruq'uin necq'uiel, j-e' c'ara' nquec'se' na nmal anen. ");
INSERT INTO tzjE_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jway jnemjon rbixic chewa camic jara' kanak ta chcaj, mjunam ta ruq'uin maná je xquetaj ewti't ewma' ojer per majo'n xeruto' ta chpam cmic. Jawra way jnemjon rbixic chewa ra, nak xtetjowa nec'se'a rxin junlic, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jawra tijonem xuya' Jesús chpam tnamet Capernaum chpam jay abar nquemol wa' qui' aj Israel. ");
INSERT INTO tzjE_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","J-e' c'a discípulo tak xecc'axaj je xbij Jesús e q'uiy chca cawra xecbij: —Jawra congan tak wan pen nbij. ¿Nak tjun xtecwin ta xtc'axaj? cara' xecbij je'a. ");
INSERT INTO tzjE_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Per ja' Jesús rutkin nak quemjon rch'obic y cawra xbij chca: —¿Le pkan xena' jtijonem je c'ja' xenbij kaja chewa? ");
INSERT INTO tzjE_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Per je Rlec'walxel jxoca alxic cuq'uin wnak nerla' na jun k'ij tak xtetz'et nojte'a chcaj jabar c'o wa' nabey. ¿Nak nech'ob chic tzrij jawrara? ");
INSERT INTO tzjE_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ja Espíritu jara' nyowa utzlaj c'aslemal je rxin junlic y mrecuerpo ta jun wnak nyowa. Jtijonem xenya' chewa jara' rxin ewanm, jun tijonem jnuya' chewa utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per ec'ola chewa jmajo'n yukbal quec'u'x wq'uin, cara' xbij Jesús com rutkin pchic nak me ykul ta quec'u'x ruq'uin, y rutkin chic chka' nak xtejchowa rxin pquek'a' wnak je nquetzelana rxin. ");
INSERT INTO tzjE_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Y cawra xbij chic chca: —Rmal c'ara' xenbij chewa, mesquier nerkaja jun wnak wq'uin che neyke'a ruc'u'x wq'uin we mtyataja tzra rmal Ttixel che neyke'a ruc'u'x wq'uin, cara' xbij chic Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","J-e' c'a rdiscípulo tak xecc'axaj jtijonem xuya' e q'uiy chca xemloja chquij, majo'n chic xetre' ta tzrij. ");
INSERT INTO tzjE_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ja' Jesús cawra xbij chic chca e cbeljuj apóstol: —Ixix ¿nak neban camic? ¿Le nquixemloja chka'? ");
INSERT INTO tzjE_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro cawra xbij tzra: —Wajaw ¿abar c'a nkoba chwa'? Xayon c'a atet ncatyowa utzlaj c'aslemal rxin Dios je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Com ajoj ykul kac'u'x awq'uin y kutkin che atet at Cristo, kutkin chka' che atet at Rlec'wal jc'aslic Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús cawra xbij chca: —Ix cbeljuj ixnech-on per c'ola jun chewa xc'an rmal diablo. ");
INSERT INTO tzjE_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jawra tzij xbij per xJudas Iscariote xnataj, je rlec'wal jun acha rbin-an Simón, com ja' Judas nejchowa Jesús pquek'a' wnak je nquetzelana rxin, y ja' jun chca e cbeljuj apóstol. ");
INSERT INTO tzjE_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","C'jara' xba Jesús chpam jle' chic lwar jc'ola precwent departamento Galilea, mtrajo' nba ptak tnamet rxin departamento Judea com tzra' ec'ol wa' jle' aj Israel quemjon rch'obic nak nqueban tzra che neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jara' tiemp xyamer nmajtaja jun nimlaj nimk'ij cxin wnak aj Israel, rubi' jara' nimk'ij, rxin tabernáculo. ");
INSERT INTO tzjE_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Rmal c'ara' tak xbixa cawra tzra Jesús cmal rch'alal: —¿Nak tzra mtcatel ela wawe' y ncatba chpam departamento Judea ch-utz c'ara' je' adiscípulo jec'ola tzra' nquetz'et njelal achnak amjon rbanic wawe' ra? ");
INSERT INTO tzjE_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Com jun acha wc'ola rgan bien nutkixa njelal rsamaj m-utz ta xe pnalak' nesmaja. Com atet amjon rbanic njelal jawrara ¿nak tzra mtac'ut chquewech jle' chic wnak per ne chquewech conjelal wnak? ");
INSERT INTO tzjE_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Cara' xbixa tzra cmal rch'alal com next j-e' ykul ta quec'u'x ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ja' Jesús cawra xbij chca: —Ja anen mja'na terla' netiemp chquenba per ixix nquixcwina nquixba chka bechnak tiemp. ");
INSERT INTO tzjE_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Com chewa ixix je' wnak mesquier itzel ta xtquixquetz'et per mcara' ta chwa anen, xe itzel quenquetz'et rmal jnemjon rk'alsic chquewech je rtzilal je nqueban. ");
INSERT INTO tzjE_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Per ixix jax ebna' jnimk'ij, per anen quenban c'a perc q'uemja'na terla' netiemp. ");
INSERT INTO tzjE_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Cara' xbij chca y xec'je' cana chpam departamento Galilea. ");
INSERT INTO tzjE_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tak ebnak chic rch'alal chpam nimk'ij c'jara' xba chic ja' per xruyon xba, per xpnalak' xekaj wa' chpam nimk'ij. ");
INSERT INTO tzjE_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Per j-e' aj Israel quemjon rconxic Jesús chpam nimk'ij je ntajina nba'na: —¿Abar tzra' c'o wa'? cara' necbij je' wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","E q'uiy je' wnak chpam nimk'ij quemjon je' tzij tzrij Jesús per kas pnejkal nquetzijona, ec'ola nic'aj cawra necbij: —Kas congan utzlaj acha ja' Jesús, y nic'aj chic wnak jun chwa' necbij: —Xe nqueruyoj wnak, xtz'koj tzij nuban chca. ");
INSERT INTO tzjE_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Per conjelal wnak necxibej qui' chquewech aj Israel je nmak quek'ij rmal c'ara' pnejkal nquetzijona. ");
INSERT INTO tzjE_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kas nec'jarnak nimk'ij, c'o lala' cji' k'ij majtanak tak xba Jesús chpam nimlaj rtemplo Dios y xumaj ctojxic je' wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","J-e' aj Israel congan xel ta quec'u'x tzrij tijonem jxuya' Jesús. —¿Nak tzra c'ala' jala' acha congan je' achnak rutkin y majo'n c'a rtijon ta ri'? ");
INSERT INTO tzjE_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús cawra xbij chca: —Jtijonem jquenya' manen ta enwankersyona, jwankersyona jara' Ttixel jtakyon pa wxin. ");
INSERT INTO tzjE_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Je' wnak jc'ola cgan nqueban je nrajo' ranm Dios, j-e' bien ncutkij wDios wankersyona jtijonem jquenya', o wxanen enwankersyon kaja nuyon. ");
INSERT INTO tzjE_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wjun acha nuya' jun tijonem je xja' wankersyona jara' bien k'alaj che nrajo' nya'a ruk'ij cmal wnak, per wc'ola jun nrajo' che nya'a ruk'ij jtakyon pa rxin jara' k'alaj che ne ktzij wa' jnuc'ut y nmajo'n je mquita rc'an rbeyal rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Per ixix ¿le myatanak tc'a chewa ley rxin Moisés chnenimaj? Per jara' ley next jun chewa rniman ta je nbij. Cara' quenbij chewa com ixix necanoj nak neban chwa che cnecamsaj, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Atet xjun itzel espíritu ch'jorsyona awxin. ¿Nak nbina chawa che ec'ola nquecamsana awxin? cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús cawra xbij chic chca: —Jxenban jmul chpam jun xlanbal k'ij, ixix junwa' xetz'et. ");
INSERT INTO tzjE_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Per c'ola je' achnak ebnon ixix chka', mesque ne chpam xlanbal k'ij per e'ebnon circuncidar je' wnak. Nque'eban circuncidar com ja' Moisés tz'ibyon cana chcara' neban chca. Y chka' cuq'uin ojer tak ttixel xwankersas twa' circuncisión y mruq'uin ta Moisés. ");
INSERT INTO tzjE_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ixix c'ola jantak e'ebnon circuncidar je' wnak mesque chpam xlanbal k'ij neban wa' com cara' nrajo' ley rxin Moisés chneban. Wcara' ebnon ixix ¿nak tzra tak npeta ewyiwal chwij tak xenchumsaj jun acha chpam xlanbal k'ij? ");
INSERT INTO tzjE_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mchek tebila' ril jun wnak wmewutkin ta bien che ril o we mril ta xuban nabey mul, bien tech'bo' rij rwech we ktzitzij ril xuban, cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ec'ol c'a jle' wnak aj Jerusalén tak xecc'axaj cawra xecbij: —¿Le mja tc'ala' acha majtanak rconxic che ncamsasa? ");
INSERT INTO tzjE_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Per camic ntak chquewech je' wnak ntzijon wa' y majo'n nak nek'lowa rxin che mttzijona. Je e k'toy tak tzij mex cniman chic chja' Cristo. ");
INSERT INTO tzjE_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Per jala' acha kutkin abar penak wa', per je Cristo tak xtpeta jara' majo'n ojtakyona abar xtpe wa'. Cara' xecbij je'a. ");
INSERT INTO tzjE_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ja' Jesús remjon ctojxic wnak chpam nimlaj rtemplo Dios y cawra nbij chca: —Ixix ewutkin nwech y ewutkin chka' abar enpenak wa'. Per c'ola jun entakyon ta y arja' ne ktzij wa' che c'aslic Dios, per jara' majo'n ewutkin ta rwech. Anen mnuyon ta xenban mandar wi' chxenpeta. ");
INSERT INTO tzjE_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Per anen wutkin rwech nak takyon pa wxin com ruq'uin enpenak wa' y ja' takyon pa wxin, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Xe rmal c'ara' je xbixa chca xyamer xquechap y nquecsaj pcars, per next jun xechpowa rxin perc q'uemja'na terla' hor rxin che ncha'pa. ");
INSERT INTO tzjE_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Per e q'uiy je' wnak xeyke'a quec'u'x ruq'uin y cawra necbij: —¿Le mja' tc'a wa' Cristo? ¿Lc'o ch-an jun mja'na tpeta y más chna nmak tak milagro nuban chkawech que chwech jawrara? ");
INSERT INTO tzjE_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","J-e' c'a fariseo xecc'axaj je' wnak kas pnejkal quemjon rbixic che Jesús jara' Cristo. Rmal c'ara' tak xquec'om pa qui' y xepeta cuq'uin je' cjefe sacerdote y xequetak jle' soldado chnequechpa' Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Y ja' Jesús remjon más tzij cuq'uin je' wnak, cawra xbij chic chca: —Anen xjurmaj quenc'je'a checjol com xquenmloja ruq'uin jtakyon pa wxin. ");
INSERT INTO tzjE_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Cnecanoj chna per majo'n chic cnewil ta. Abar xtenc'je' wa' anen mesquier nquixecwina ixix nquixekaja tzra', cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","J-e' c'a aj Israel xquemaj chic tzij tzrij je xbixa chca rmal: —¿Abar nba wa' jala' acha y majo'n nkocwin ta nkawil? ¿Le nba cuq'uin nic'aj chic kwinak aj Israel jec'ola ptak tnamet cxin je' wnak jme aj Israel ta? ¿Le tzra' nba wa' y nquertijoj je' wnak jme aj Israel ta? ");
INSERT INTO tzjE_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nak nbij tzij c'ara' tak nbij chka che nekcanoj per majo'n nkawil ta, y chka' abar c'o wa' majo'n nkocwin ta ajoj nokekaj tzra'? cara' xecbij je'a. ");
INSERT INTO tzjE_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tak xerla' q'uisbal k'ij rxin nimk'ij, jara' k'ij jmás nim ruk'ij, xpe'a Jesús chquewech wnak y cawra xbij: —Wc'ola jun chewa congan chkichi' majyona tpeta wq'uin y tertja' ya' jc'ola wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ajni' nbij rtzojbal Dios, je' wnak jneyke'a quec'u'x wq'uin congan rkan tak ya' xtpulin ta ptak canm per jle' ya' jrec'mon ta c'ac'laj c'aslemal, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Cara' xbij chca per xe Espíritu Santo xbij je nyataj na chca wnak je ykula quec'u'x ruq'uin. Per Espíritu Santo q'uemja'na tta'k ta com Jesús q'uemja'na tba ruq'uin Ttixel pe gloria. ");
INSERT INTO tzjE_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Je' wnak tak xecc'axaj Jesús ec'ola nic'aj chca cawra xecbij: —Jala' acha ne ktzitzij wa' che profeta rxin Dios jbitanak cana che npe na, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Y jle' chic chca cawra xecbij: —Jala' Cristo Rey jtzujun cana ojer chka rmal Dios, cara' xecbij. Y nic'aj chic wnak cawra xecbij: —¿Le chpam Galilea c'a npe wa' Cristo? ");
INSERT INTO tzjE_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Le mtz'ibtanak tc'a chpam rtzojbal Dios che chpam tnamet Belén npe wa' Cristo? Com Belén rtnamet ojer rey David, y Cristo arja' riy rumam David. Cara' xecbij je'a. ");
INSERT INTO tzjE_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Cara' xqueban je' wnak, xquech'or je' qui' rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ec'ola nic'aj xcajo' ta xquechap Jesús y xquecsaj ta pcars per next jun xechpowa rxin. ");
INSERT INTO tzjE_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nic'aj ach-i' etkon ela chnequechpa' Jesús, tak xemloj ta cuq'uin sacerdote je nmak quek'ij y chka' aj fariseo cawra xbixa chca: ");
INSERT INTO tzjE_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—¿Nak tzra tak mxechap ta acha? Y j-e' cawra xecbij: —Ajni' ntzijona jawra acha next jun chic acha xtecwin ta xttzijon ta cara'. ");
INSERT INTO tzjE_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","J-e' aj fariseo cawra xecbij chca: —¿Mex xixba'na engañar ixix chka' rmal jara' acha? ");
INSERT INTO tzjE_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Per next jun wan chca e k'toy tak tzij ykul ta quec'u'x ruq'uin y chka' next jun chka ajoj ok aj fariseo. ");
INSERT INTO tzjE_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jle' wnak jala' je ykula quec'u'x ruq'uin xe mcutkin ta rley Dios, majo'n nquec'atzin wa' ruq'uin Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Per c'ola jun chca aj fariseo rubi' Nicodemo, jara' je xtzijona jmul ruq'uin Jesús chak'a', cawra xbij chca rexbil: ");
INSERT INTO tzjE_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Lcara' c'a nrajo' ley jyatanak chka rmal Dios nech'ob ixix? ¿L-utz c'ara' nkak'at tzij tzrij jun acha y mtya'a c'as tzra che ntzijona y mtutkixa nabey mul lc'o ril o wmajo'n? ");
INSERT INTO tzjE_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Per j-e' xquemaj ryok'ic Nicodemo y cawra xecbij tzra: —¿Mex at aj Galilea atet chka'? Bien tetz'ta' chpam rtzojbal Dios chmajo'n jun profeta xtwanker ta chpam tnamet Galilea, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","C'jara' xecpaxij ela qui' y xeba ptak cuchoch. ");
INSERT INTO tzjE_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ja' Jesús xojte'a pe rwá' jun jyu' rbin-an Olivo. ");
INSERT INTO tzjE_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Y rcab k'ij xba chic jmul chanim chpam nimlaj ruchoch Dios jc'ola chpam tnamet Jerusalén. E q'uiy je' wnak xe'ekaja ruq'uin y ja' xetz'be'a y xumaj ctojxic. ");
INSERT INTO tzjE_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Je' maestro je nquetijona cxin je' wnak tzra rley Dios e quexbil aj fariseo j-e' c'a quec'mon ta jun ixak je xquewil nmajcuna ruq'uin jun acha jmrechjil ta, y xqueya' chquecjol je' wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Y cawra xecbij tzra Jesús: —Maestro, jawra ixak xwiltaja nmajcuna ruq'uin jun acha mrechjil ta. ");
INSERT INTO tzjE_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Y bin cana chka rmal Moisés chpam rley Dios che nquecamsasa tzan abaj je' ixki' cawra cbanic. Atet ¿nak nabij tzra? ");
INSERT INTO tzjE_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Cara' xecc'axaj tzra perc j-e' ncajo' nqueban tentar y neccanoj nak nqueban tzra che necchapbej rxin. Y ja' Jesús xumaj tz'ibanem chwech ulew tzan ruruk'a'. ");
INSERT INTO tzjE_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Per j-e' wnak congan quemjon rc'axic tzra Jesús rmal c'ara' xpe'a y cawra xbij chca: —Nak jun chewa nmajo'n ril rumac rebnon ta, ja' tyowa nabey abaj tzra jawra ixak. ");
INSERT INTO tzjE_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tak xbitaja jawra rmal xumaj chic jmul tz'ibanem chwech ulew. ");
INSERT INTO tzjE_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tak xecc'axaj je xbixa chca rmal Jesús xquena' kaja chc'ola quil quemac rmal c'ara' chjujnel chjujnel xeba. Kas xeba nabey mul j-era' rija' y xq'uisbena xeba che conjelal. Xruyon chic Jesús xec'je' cana y ja' ixak xpe' cana chwech. ");
INSERT INTO tzjE_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tak xpe'a chic jmul Jesús xutz'et e majo'n chic je' wnak, abar le tzra' xe'oc wa', xruyon chic ixak c'o cana y cawra xbij tzra: —¿Abar xe'oc wa' je' wnak je nqueyowa awil? ¿Lc'o jun xuk'at tzij chawij y xatruq'uiek tzan abaj? cara' xc'axaj tzra ixak. ");
INSERT INTO tzjE_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Next jun, cara' xbij ja' ixak. —Next c'a anen chka' xtenk'at ta tzij chawij. Camic jat, xerwara' mtaban xta jmul awil amac. ");
INSERT INTO tzjE_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","C'jara' Jesús xtzijon chic cuq'uin je' wnak y cawra xbij chca: —Anen c'ara' en luz y je' wnak jec'ola chwech ruch'lew quenuya' psak. Conjelal wnak jneyke'a quec'u'x wq'uin j-e' c'ara' majo'n nquec'je' ta chpam k'ejku'm per psak nquec'je' wa', y jara' sak nuya' chca utzlaj c'aslemal je rxin junlic, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Per aj fariseo junwa' xecc'axaj y cawra xecbij tzra: —Atet naya' kaja testig-il chawij ayon rmal c'ara' majo'n ncatknimaj ta, cara' xecbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—Mesque quenya' kaja testig-il chwij nuyon per je njelal jquenbij ne ktzitzij wa' com anen wutkin nak rbanic abar enpenak wa', y tzra' quenmloj wa' chka'. Per ixix majo'n ewutkin ta abar enpenak wa' y abar quenmloj wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ixix xe ena'oj necsaj jnek'atbej tzij chwij y me rxin ta Dios, per chwa anen majo'n nak quenk'at ta tzij tzrij. ");
INSERT INTO tzjE_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Per wc'ola k'toj tzij quenban per pe rbeyal quenban. Cawra quenbij chewa com mnuyon ta anen quenk'towa tzij, ok c-e' ruq'uin Ttixel jtakyon ta wxin nkak'at tzij. ");
INSERT INTO tzjE_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chpam rley Dios jyatanak chewa cawra tz'ibtanak cana chpam: tak ec'ola e c-e' ach-i' xjunam testig nqueya' jara' ne ktzitzij wa' jnecbij, cara' tz'ibtanak cana. ");
INSERT INTO tzjE_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Cara' c'a chwa anen chka', anen en jun testig chwij nak nbanic, y Ttixel jtakyon pa wxin jara' jun chic testig chwij. Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—¿Abar tzra' c'o wa' adta'? Cara' xecc'axaj tzra. —Ixix majo'n ch'obtanak ta ewmal nak nbanic anen, next Nedta' chka' ch'obtanak ta ewmal nak rbanic. Per wext ch'obtanak ewmal nak nbanic anen ch'obtanak ta ra' chka' nak rbanic Nedta', cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Cawra tzij xbij Jesús chpam nimlaj ruchoch Dios tak remjon ctojxic wnak. Tzra' pa'l wa' abar nqueya' wa' cofrenda je' wnak, per next jun nechpowa rxin com q'uemja'na terla' hor rxin che ncha'pa. ");
INSERT INTO tzjE_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Xumaj chic rij tzij cuq'uin y cawra xbij chca: —Anen quenmloja abar enpenak wa'. Ixix cnecanoj na per majo'n cnewil ta y chpam ewil emac nquixcom wa'. Abar xtenba wa' anen mesquier nquixecwina nquixekaja ixix tzra'. ");
INSERT INTO tzjE_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","J-e' aj Israel xquemaj je' tzij chbil tak qui': —¿Le ncamsaj ri' ruyon rmal c'ara' majo'n nkocwin ta nokekaja tzra' abar nba wa'? ");
INSERT INTO tzjE_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús cawra xbij chic chca: —Ixix ix rxin wawe' per anen en rxin chcaj, ix rxin rwech ruch'lew per anen mcara' ta chwa. ");
INSERT INTO tzjE_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Rmal c'ara' xenbij chewa chpam ewil emac nquixcom wa'. Per je nbanic anen ncara' ajni' nbin chewa, per wmajo'n nenimaj ta chcara' nbanic jara' nquixcoma chpam ewil emac, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Nak c'a abanic atet? cara' xecc'axaj tzra. —Je nbanic anen ncara' ajni' nbin ta chewa nabey. ");
INSERT INTO tzjE_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","C'c'o na je' tzij jq'uemjana tenbij chewa nak nquixbanbexa condenar. Per jtakyon ta wxin ne ktzitzij wa' njelal je nbij, y je rbin chwa jara' nemjon rbixic chca je' wnak wawe' chwech ruch'lew, cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Per je xbij Jesús mesquier nch'obtaja cmal che tzrij Ttixel ntzijon wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","C'jara' xbij chic jmul chca: —Je Rlec'walxel jxoca alxic cuq'uin wnak, tak xtejotba' chwech jun cruz tzra' c'ara' newutkij wa' nak nbanic, y ncara' ajni' nbin ta chewa. Y newutkij na chka' njelal jnemjon rbanic mchek tnuyon quenban kaja com njelal jnemjon rbixic ja' Nedta' c'utyuna chenwech. ");
INSERT INTO tzjE_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ja takyon pa wxin c'ola wq'uin camic, ja' Nedta' majo'n enrey-on cta. Cara' rebnon chwa com anen nemjon rbanic je nrajo' chwa chquenban, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tak xbij jawra tzij e q'uiy je' wnak xeyke'a quec'u'x ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","C'jara' xumaj tzij cuq'uin aj Israel jxeyke'a quec'u'x ruq'uin y cawra xbij chca: —Per wjunlic nquixc'je'a chpam ntzojbal jara' ne ktzitzij wa' ix ndiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Wcara' neban newutkij na ajni' nna'oj y newutkij chka' che ntzojbal ne ktzitzij wa', y tak xtewutkij jawra jara' nquixrelsaj ela libre. ");
INSERT INTO tzjE_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","—Per ajoj ok riy rumam cana Abraham, next jmul okocnak ta pquek'a' wnak y okquebnon ta mandar. ¿L-ok preso natzu' atet tak nabij chka nokalsaj libre? ");
INSERT INTO tzjE_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús cawra xbij chca: —Ne ktzitzij wa' je xtenbij chewa, conjelal wnak je nquemajcuna xe esclavo pruk'a' il mac com il mac nebnowa mandar cxin. ");
INSERT INTO tzjE_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jun esclavo majo'n ruk'a' tzra xtec'je' ta rxin junlic chpam ruchoch rajaw, per jun alc'walxel jara' c'ola ruk'a' tzra che nec'je'a rxin junlic chpam. ");
INSERT INTO tzjE_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Rmal c'ara' quenbij chewa, we Rlec'wal Dios nquixrelsaj ela libre jara' ne ktzitzij wa' che ix libre. ");
INSERT INTO tzjE_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Anen wutkin che ix riy rumam cana Abraham. Mesque ix riy rumam cana per ixix emjon rconxic rij nwech nak neban chwa che cnecamsaj. Cara' c'a neban com majo'n neya' ta c'as tzra ntzojbal che nq'uiya ptak ewanm. ");
INSERT INTO tzjE_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Njelal jnemjon rbixic jara' ruq'uin Nedta' netz'ton pwa' per je njelal jemjon rbanic ixix jara' edta' ixix biyona chewa chneban. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Per jkadta' ajoj jara' Abraham, cara' xecbij j-e' wnak tzra Jesús. —Per wext ktzij che ix riy rumam cana Abraham jara' tc'a emjon rbanic ra' ajni' xuban cana Abraham. ");
INSERT INTO tzjE_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Njelal jxenbij chewa jara' ne ktzitzij wa' com ja' Dios biyona chwa. Mesque ncara' rbanic per ixix necanoj rij nwech nak neban chwa che cnecamsaj. Per Abraham mcara' ta xuban ajni' neban ixix chwa camic. ");
INSERT INTO tzjE_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ajni' nuban edta' ixix jara' emjon rbanic ixix chka', cara' xbij chca wnak. —Ajoj tak xokalexa me c-e' oxi' ta kadta', ajoj xjun Ttixel kxin y jara' Dios, cara' xecbij j-e' wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús cawra xbij chca: —Wext ktzitzij che Dios jara' Ttixel ewxin cnewajo' tc'ara' chka'. Cawra quenbij chewa com anen pranm Dios enelnak twa'. Ruq'uin ja' Dios enpenak wa'. Mchek ta ngan enpenak, ja' takyon pa wxin. ");
INSERT INTO tzjE_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Nak tzra tak mesquier nch'obtaja ewmal jquenbij chewa? Mesquier nc'a nch'obtaja ewmal perc majo'n egan newc'axaj ntzojbal. ");
INSERT INTO tzjE_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ixix ix rlec'wal diablo, y nak nrajo' diablo nuban y njara' c'ola egan tzrij ixix chka'. Ja' diablo ncamsanel wa' chek xwanker ta rwech ruch'lew. Njelal je nbij Dios xitzel nc'axaj diablo com ja' diablo xe tz'koy tzij. Tak nutz'ak tzij diablo jara' ne rxin wa' com ja' ne tz'koy tzij wa', y ja' nwankersana je' tz'koj tak tzij. ");
INSERT INTO tzjE_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Anen ne ktzitzij wa' njelal achnak quenbij chewa rmal c'ara' ixix majo'n cnenimaj ta. ");
INSERT INTO tzjE_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Lc'o jun chewa necwina nbij chwa nak wil nebnon? Per jnemjon rbixic chewa ne ktzitzij wa'. ¿Nak c'a tzra tak majo'n cnenimaj ta? ");
INSERT INTO tzjE_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Je rlec'wal Dios j-e' nqueya' quexquin tzrij nak nbixa chca rmal Dios, per ixix majo'n neya' ta ewexquin tzrij je nbixa chewa rmal Dios com ixix mix rlec'wal ta Dios. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","J-e' aj Israel xquemaj chic ryok'ic y cawra xecbij chic tzra: —Ajoj ne rbeyal wa' nekbij chawa chatet at ajni' at jun Samaritano, y c'ola jun itzel espíritu c'ayona awxin. Jesús cawra xbij chic chca: ");
INSERT INTO tzjE_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Anen majo'n jun itzel espíritu c'ayon ta wxin com anen nemjon rya'ic ruk'ij Nedta' Dios, per ixix xe cneyok'. ");
INSERT INTO tzjE_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Per anen mjara' ta quencanoj che nya'a nuk'ij cmal wnak, per Nedta' remjon rchumsic nak nuban che nqueya' nuk'ij wnak, ja' c'a ra' xtbina abar c'o wa' ktzitzij, wq'uin anen o ewq'uin ixix. ");
INSERT INTO tzjE_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ne ktzitzij wa' je xtenbij chewa, wc'ola jun nnimaj ntzojbal jara' majo'n cmic tzrij com nec'se'a rxin junlic, cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","J-e' aj Israel cawra xecbij chic tzra: —Camic bien k'alaj chc'ola jun itzel espíritu c'ayona awxin com atet nabij che jun wnak je nnimaj atzij majo'n cmic tzrij y nec'se'a rxin junlic. ¿Le me xcom tc'a Abraham ojer, y chka' mxecom tc'a je' profeta ojer? ");
INSERT INTO tzjE_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Nbij tzij ra' che atet más nim ak'ij chwech kadta' Abraham com arja' xcoma ojer? Y xecom nara' chka' e ojer tak profeta. ¿Nak abanic nana' kaja atet? ");
INSERT INTO tzjE_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús cawra xbij chic chca: —Anen wext quenya' kaja nuk'ij nuyon jara' majo'n quenoc wa', per jNedta' jara' nyowa nuk'ij y ixix nebij tzra Nedta' chja' Dios ewxin. ");
INSERT INTO tzjE_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Per ixix majo'n ewutkin ta rwech Nedta' per anen bien wutkin rwech. Wext xenbij chewa chmajo'n wutkin ta rwech jara' xjunam ta kbanic ewq'uin ix tz'koy tak tzij. Per wutkin rwech y nniman rtzojbal. ");
INSERT INTO tzjE_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham ja edta' nebij tzra ixix, arja' najni'la xquicota ojer tak xch'obtaja rmal che nutz'et na k'ij tak xtenpe ta anen, y njara' xutz'et y congan xquicota rmal. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","—¿Nak tzer c'a atz'ton chic Abraham y q'uemja'na taban cincuenta ajuna'? Cara' xbixa tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Ne ktzitzij wa' je xtenbij chic chewa, anen enc'ol chic tak q'uemja'na talexa Abraham, cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tak xbixa cara' chca xecsic'la' abaj y nqueq'uiek Jesús tzra ncajo', per ja' Jesús xiwaj ri' y xel ela chpam nimlaj ruchoch Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ja' Jesús remjon binem tak xutz'et jun acha ch'it moy prelxic. ");
INSERT INTO tzjE_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","J-e' rdiscípulo cawra xecc'axaj tzra: —Maestro ¿nak tzer c'ara' ch'it moy xalexa jala' acha? ¿Nak c'ola ril, lja' o redta' rute'? ");
INSERT INTO tzjE_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús cawra xbij: —Mcara' ta, mril ta ja' next ril redta' rute'. Jala' acha rebnon cala' ch-utz c'ara' c'ola jun nimlaj samaj rxin Dios nk'aljina tak xtjaktaja rk'arwech. ");
INSERT INTO tzjE_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tak wenc'o na wawe' chwech ruch'lew nc'atzina quenban rsamaj jtakyon pa wxin. Tak xtoca k'ejku'm mesquier chic ncatecwina ncatesmaja. ");
INSERT INTO tzjE_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ajru' tiemp xtenc'je'a wawe' chwech ruch'lew, anen en luz rxin. ");
INSERT INTO tzjE_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tak xec'choja tzij rmal xchubaj kaja rec'xaj chwech ruch'lew y xumaj rbanic ch'bak tzra rec'xaj, y xuc'om xuya' chuchi' rk'arwech moy. ");
INSERT INTO tzjE_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Y cawra xbij tzra: —Jat ach'ja' ak'awech pya' rubi' Siloé. (Siloé nbij tzij tkon ta.) Y cara' xuban jara' acha. Tak xekaja xuch'aj rk'arwech. Tak xch'ajtaja rmal xemloj ta y nca'y chic. ");
INSERT INTO tzjE_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Je rebcin y jle' chic wnak jquetz'ton jawra moy cawra xecbij: —¿Mja' tc'ala' acha netz'be'a ptak bey y nc'utuj pak? ");
INSERT INTO tzjE_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ec'ola nic'aj cawra xecbij: —Ja' nc'a. Y jle' chic cawra xecbij: —Mja' ta, ncala' nca'ya per mja' ta. Per ja' acha cawra xbij chca: —Anen nc'a. ");
INSERT INTO tzjE_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—¿Per nak xaban, ncatca'y xtakwan? ");
INSERT INTO tzjE_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—C'o jun acha Jesús rubi', arja' xchumij jle' ch'bak y tak xchumtaja rmal xuya' chi' nk'anwech y cawra xbij chwa: —Jat ach'ja' ak'awech pya' Siloé. Y cara' xenban anen xenba. Tak xnekaja xench'aj nk'anwech y cara' xenban xjaktaja. ");
INSERT INTO tzjE_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Abar tzra' c'o wa' Jesús camic? —Jara' majo'n wutkin ta abar le tzra' c'o wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","C'jara' xec'mar ela ja' acha je xjaktaja rk'arwech, q'ue chquewech aj fariseo xc'ax wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ja' Jesús tak xchumij ch'bak y xujak rk'arwech jara' acha, chpam jun xlanbal k'ij xuban wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","J-e' aj fariseo xecc'axaj chic tzra acha: —¿Nak xaban tak xjaktaja ak'awech? —Ja' acha xchumij jle' ch'bak y tak xchumtaja rmal xuya' chi' nk'anwech, c'jara' xench'aj nk'anwech y xjaktaja. ");
INSERT INTO tzjE_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ec'ola nic'aj aj fariseo cawra xecbij: —Ja acha rbin-an Jesús, me Dios ta takyon pa rxin com ja' mtuya' ruk'ij xlanbal k'ij com xnesmaja chpam. Per jle' chic cawra xecbij: —¿Nak tzer c'ara' jun acha we xril rumac nuban y nuban jun milagro ajni' nkatz'et camic? Y cara' xqueban, mjunam ta xquech'ob tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Y cawra xecbij chic tzra acha je xjaktaja rk'arwech: —Atet ¿nak nabij tzra Jesús? Com arja' xujak ak'awech. ¿Nak rbanic nach'ob atet? —Arja' jun profeta rxin Dios. Cara' xbij ja' acha chca. ");
INSERT INTO tzjE_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Per j-e' aj Israel majo'n xecnimaj ta chmoy ja' acha nabey. Majo'n necnimaj ta che c'ja' xjaktaja rk'arwech rmal c'ara' xecsiq'uij na redta' y rute' acha. ");
INSERT INTO tzjE_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tak xe'ekaja redta' y rute' cawra xecc'axaj chca. —¿Ewlec'wal jawra acha? ¿Le ktzij c'ara' moy tak xalexa? ¿Nak tzer c'ara' nca'y chic camic? ");
INSERT INTO tzjE_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Ajoj kutkin che klec'wal, y kutkin chka' tak xalexa majo'n nca'y ta. ");
INSERT INTO tzjE_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Per majo'n kutkin ta nak tzra tak nca'y chic camic, y majo'n kutkin ta chka' nak xejkowa rk'arwech. ¿Nak tzer c'a mtewc'axaj tzra ja' com c'o chic rjuna' y ri'j chic chka'? Ja' c'a ra' nbina chewa nak xuban. ");
INSERT INTO tzjE_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Cara' xecbij chca aj Israel com j-e' congan necxibej qui' chquewech aj Israel com j-e' aj Israel quech'bon chic nak wnak xtbina che Jesús jara' Cristo majo'n nc'u'l xta chpam jay abar nquemol wa' qui', abar ncho'l wa' rtzojbal Dios, per junlic nch'akix ela. ");
INSERT INTO tzjE_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Rmal c'ara' tak xecbij: —Tzra ja' tewc'axaj wa' com c'o chic rjuna' y ri'j chic chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","C'jara' xec'mar chic jmul ja' acha jmoy ojer y cawra xecbij tzra: —Chwech Dios tbij wa' kas mer rbeyal com ajoj kutkin ja acha rbin-an Jesús x-il mac nuban. ");
INSERT INTO tzjE_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—We x-il mac nuban jara' majo'n wutkin ta tzra anen, xerwara' xjara' wutkin che anen en moy nabey per camic quenca'y chic. ");
INSERT INTO tzjE_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—Per ¿nak xuban chawa? ¿Nak xuban tak xujak ak'awech? ");
INSERT INTO tzjE_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Per jara' nbin chic chewa per ixix majo'n egan newc'axaj. ¿Nak tzer c'a newc'axaj chic jmul chwa? ¿Mex newajo' ixix chka' nquixoca rdiscípulo? ");
INSERT INTO tzjE_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","J-e' congan xpeta cyiwal y cawra xecbij tzra: —Atet at k'alaj che at rdiscípulo, per ajoj ok rdiscípulo Moisés. ");
INSERT INTO tzjE_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ajoj kutkin che xtzijona Dios ruq'uin Moisés per ja acha rbin-an Jesús abar le tzra' penak wa' y nak la takyon pa rxin. ");
INSERT INTO tzjE_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—Per ¿nak tzer c'ara' mesquier nch'obtaja ewmal nak takyon pa rxin per xujak c'a nk'anwech? ");
INSERT INTO tzjE_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ajoj kutkin che Dios majo'n nc'axaj ta nak nc'utux tzra rmal jun bnoy il mac. Per jun wnak wnuya' ruk'ij Dios y nnimaj nak nrajo' ranm ja', jara' nc'axaxa y nyataja tzra je nc'utuj tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ajru' la tiemp wankernak ta rwech ruch'lew per majo'n c'axan ta chc'ola jun acha xujak ta rk'arwech jun moy prelxic. ");
INSERT INTO tzjE_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ja' Jesús wext mquita ruq'uin Dios penak wa' majo'n ta achnak necwina nuban ra', cara' xbij ja' acha. ");
INSERT INTO tzjE_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Xquemaj chic ryok'ic acha y cawra xecbij chic tzra: —Atet xe rmal il mac at moy xatalexa. ¿Lnawajo' c'a atet nokatijoj? C'jara' xquelsaj ela chquecjol rxin junlic y majo'n xquec'ul xta. ");
INSERT INTO tzjE_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ja' Jesús tak xc'axaj che xelsas ta acha y majo'n nc'u'l xta, xba y xerla' acha y cawra xc'axaj tzra: —¿Le ykul chic ac'u'x ruq'uin Rlec'wal Dios? ");
INSERT INTO tzjE_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Anen quenwajo' neyke'a nuc'u'x ruq'uin per tec'tu' chenwech nak acha c'ara' Rlec'wal Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús cawra xbij chic tzra: —Per jara' acha atz'ton chic, anen c'ara' en Rlec'wal Dios jnemjon tzij awq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","C'jara' ja' acha cawra xbij: —Wajaw, anen camic neyke'a nuc'u'x awq'uin, cara' xbij tzra Jesús. Xexque'a chwech y xumaj rya'ic ruk'ij. Ja' Jesús cawra xbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","—Anen enpenak wawe' chwech ruch'lew ch-utz c'ara' nk'aljina nak cbanic je' wnak. Enpenak ch-utz c'ara' je' moya' njaktaja je' ck'awech, y chka' je' wnak je nquebina che nqueca'ya nk'aljina che j-e' xe e moya'. ");
INSERT INTO tzjE_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ec'ola nic'aj fariseo chenkaj ruq'uin Jesús, tak xecc'axaj je xbixa congan xpeta cyiwal tzrij Jesús y cawra xecbij tzra: —¿L-ok moya' ajoj chka' tak nabij cara' chka? ");
INSERT INTO tzjE_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—Wext xeya' chewij che chpam k'ejku'm ixc'ol wa' jara' majo'n nquixchapbexa, per com nebij che ewutkin chic rubey Dios jara' c'a nquixchapbexa. Cara' xbij Jesús chca. ");
INSERT INTO tzjE_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","C'jara' xbij chic: —Ne ktzitzij wa' je' tzij xtenbij chewa camic ra. Tak c'ola jun nrajo' noca chpam cc'olibal ch'tak carne'l per me tzra' ta noc wa' abar lsan wa' ruchi' y xjic nojte'a pe rwá' y nkaj kaja, jara' jun acha xe elk'om y xcamsanel chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Per jnoca abar lsan wa' ruchi' cc'olibal carne'l jara' ne ktzitzij wa' chja' ajyuk'la' cxin. ");
INSERT INTO tzjE_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tak nekaja ajyuk'la' cuq'uin carne'l nja'ka ruchi' cc'olibal chwech rmal jnechjalbena rxin. Tak noca chpam cc'olibal nc'axaxa rukul cmal rcarne'l, nquerk'ijla' y nbij quebi' chejujnel y numaj clasic chpam cc'olibal. ");
INSERT INTO tzjE_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tak nquelastaj pa rmal nuc'om ela quebey je' carne'l y nquetre' ela tzrij com cutkin chic rwech chja' ajyuk'la' cxin. ");
INSERT INTO tzjE_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Per wc'ola jun nsiq'uina cxin je' carne'l per mcutkin ta rwech majo'n nquetre' el ta tzrij. Je nqueban, jara' nquenanmaj ela chwech perc mcutkin ta rukul next rwech jara' wnak. ");
INSERT INTO tzjE_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jawra c'ambal tzij xbij Jesús per je' aj fariseo mesquier nch'obtaja cmal. ");
INSERT INTO tzjE_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús cawra xbij chic wjic chca: —Anen c'ara' en ruchi' cc'olibal carne'l abar nque'oc wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Conjelal jxepeta tak q'uemja'na quenpeta anen mxe'oc ta tzra' abar c'o wa' ruchi' cc'olibal carne'l, mxe'oc ta tzra' perc j-e' xe elk'oma' y xe e camsanel, per me xya' ta cas chca cmal je carne'l. ");
INSERT INTO tzjE_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Anen c'ara' en ruchi' cc'olibal carne'l. Nak wnak xterkaja wq'uin jara' ntotaja y nyataja tzra nak nc'atzina tzra. Ajni' yatanak chca carne'l nque'ela y nque'oca chpam cc'olibal, tak nque'el ta nquewil utzlaj tak k'ayis y jara' nquetaj. ");
INSERT INTO tzjE_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Jelk'om tak nba cuq'uin carne'l rech'bon el chic che nquerelk'aj ela, we nquercamsaj o we nquertz'ila' cana. Per anen enpenak cuq'uin chquenya' jun utzlaj c'aslemal chca. Y mex ruyon tjara' nyataja chca, chka' nyataja jun nimlaj quicotemal chpam cc'aslemal. ");
INSERT INTO tzjE_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Anen en ajyuk'la' per ne ktzitzij wa' che en utzlaj ajyuk'la'. Ja utzlaj ajyuk'la' majo'n npoknaj ta ri' ncoma pquecwent ch'tak rcarne'l. ");
INSERT INTO tzjE_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Per mcara' ta nqueban tak xpak necyarij, xe tjon quek'ij, me ktzij ta che ajyuk'la' perc j-e' me cxin ta carne'l. Y tak nquetz'et chpenak jun itzel chcop j-e' nqueya' cana ch'tak carne'l y nquenanmaja, y npeta itzel chcop nquertrebej carne'l y nquerchicaj. ");
INSERT INTO tzjE_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nquenanmaja com majo'n nel ta quec'u'x chquij ch'tak carne'l, xtzrij cjel je nquetojbexa nel wa' quec'u'x. ");
INSERT INTO tzjE_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Anen en jun ajyuk'la' per ne ktzitzij wa' che en utzlaj ajyuk'la', congan quenwajo' ch'tak ncarne'l y wutkin nak cna'oj y cara' quebnon chwa anen chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ajni' kabnon ruq'uin Ttixel arja' congan quenrajo' y chka' rutkin nna'oj y cara' nebnon tzra anen chka', y anen majo'n quenpoknaj ta wi' quencoma pquecwent ch'tak ncarne'l. ");
INSERT INTO tzjE_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Chka' ec'o chna nic'aj ncarne'l je majo'n chpam jawra c'olbal, j-era' cnec'ma' na. Tak xtecc'axaj nukul j-e' quencnimaj y xjun quenban chca che conjelal, y xjun ajyuk' je nyuk'una cxin. ");
INSERT INTO tzjE_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Com anen majo'n quenpoknaj ta wi' quencoma pquecwent ch'tak carne'l rmal c'ara' tak quenrajo' Ttixel. Anen quenya' wi' pe cmic cmal y quenc'astaj na chpam cmic. ");
INSERT INTO tzjE_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wext majo'n ngan quencoma majo'n quencom ta, next jun necwina chwij xtenrcamsaj ta. Per anen ne ngan quenya' wi' chpam cmic. Wq'uin anen c'o wa', quencwina quenya' wi' chpam cmic y quencwina quenc'astaja chpam chka'. Jawra bin chwa rmal Nedta' chcara' quenban. ");
INSERT INTO tzjE_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tak xec'choja tzij rmal Jesús j-e' aj Israel xquech'or je' qui'. ");
INSERT INTO tzjE_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ec'o nic'aj cawra xecbij: —Xjun itzel espíritu c'ayon rxin acha jala', xe ch'jurnak. ¿Nak tzra tak neya' cas? ");
INSERT INTO tzjE_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jle' chic cawra xecbij: —Per mcara' ta ntzijona jun wnak tak xitzel espíritu c'ayona rxin. ¿Lnecwina jun itzel espíritu nujak quewech moya' nech'ob ixix? ");
INSERT INTO tzjE_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Xerla' jun nimk'ij, dedicación necbij tzra, nc'u'la chpam tnamet Jerusalén. Jara' retiemp tew. ");
INSERT INTO tzjE_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ja' Jesús remjon binem chpam nimlaj ruchoch Dios. Y c'ol c'a jun corredor tzra', corredor rxin Salomón rubi' canon, tzra' c'a remjon wa' binem. ");
INSERT INTO tzjE_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Y j-e' aj Israel xbequemlo' qui' tzrij Jesús y cawra xecbij tzra: —¿Nak tzra mtabij chka? Watet at Cristo tk'alsaj chkawech. ");
INSERT INTO tzjE_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","—Per jara' nbin chic chewa per ixix majo'n cnenimaj ta. Njelal samaj jnemjon rbanic jbin chwa rmal Nedta' jara' nec'tuwa wxin nak nbanic. ");
INSERT INTO tzjE_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Per ixix majo'n cnenimaj ta perc ixix mix ncarne'l ta ajni' nbin chic chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","J-e' ch'tak ncarne'l necc'axaj nukul y quencnimaj. Anen congan quenwajo', wutkin ajni' cna'oj y j-e' nquetre'a chwij. ");
INSERT INTO tzjE_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Anen quenya' chca utzlaj c'aslemal rxin Dios je rxin junlic y nmajo'n nqueba ta chpam nimlaj lowlo' com nquetotaja rxin junlic y next jun xtquelsana pnuk'a'. ");
INSERT INTO tzjE_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Conjelal j-e' ja' Nedta' xyowa chwa y congan rchuk'a' chquewech conjelal y next jun xtquelsana pruk'a'. ");
INSERT INTO tzjE_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Anen xjun kabnon ruq'uin Ttixel. Cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","J-e' c'a aj Israel xquesic' chic abaj y ncajo' neccamsaj Jesús tzra abaj. ");
INSERT INTO tzjE_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Per Jesús cawra xbij chca: —Anen q'uiy utzlaj tak samaj nebnon chewech je y-on chwa rmal Nedta' chquenban. ¿Nak jun samaj nebnon chewech tak rmal ra newajo' cnecamsaj? ");
INSERT INTO tzjE_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Me rmal ta utzlaj samaj abnon je nkajo' ncatkaq'uiek tzan abaj, xe rmal jxabij atet at Dios, per xat wnak c'a, xitzel nc'axaxa rmal Dios jxabij. ");
INSERT INTO tzjE_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús cawra xbij: —¿Le mtz'ibtanak tc'a chpam rtzojbal Dios jyatanak chewa jcawra xbij Dios chca nic'aj wnak? —Anen xenbij chewa che ixix ix dios, cara' xbij ja' Ttixel y cara' tz'ibtanak cana. ");
INSERT INTO tzjE_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Cara' c'a xbij Dios che j-e' e dios, cara' nbij rtzojbal, y kutkin che rtzojbal Dios mesquier nq'uextaja. ");
INSERT INTO tzjE_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Per chwa anen, Dios xenryonaj y xenrutak ta wawe' chwech ruch'lew. J-e' c'a wnak xbixa chca che e dios. ¿Nak tzer c'ara' tak nebij ixix chlowlo' xenban chwech Dios tak xenbij chanen en Rlec'wal Dios? ");
INSERT INTO tzjE_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Jsamaj jnemjon rbanic wme rxin ta Nedta' utz wara' majo'n cnenimaj ta. ");
INSERT INTO tzjE_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Per we rxin Nedta' Dios jsamaj nemjon rbanic, tnimaj c'a che rxin ja' majo'n opech neyke' ta ec'u'x wq'uin. Cara' quenwajo' chewa ch-utz c'ara' chnewutkij na chja' Ttixel xjun rebnon wq'uin y anen chka' xjun nebnon ruq'uin ch-utz c'ara' chka' chneyke'a ec'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wjic chic xcajo' ta xquechap y xquecsaj ta pcars per Jesús xecwina xel ela chquecjol. ");
INSERT INTO tzjE_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","C'jara' Jesús xba chic pjupraj binelya' Jordán y tak xekaja, tzra' xec'je' wa'. Jara' lwar abar xeba'n wa' bautizar je' wnak nabey mul rmal Juan. ");
INSERT INTO tzjE_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","E q'uiy wnak xe'ekaja ruq'uin y cawra xecbij: —Juan majo'n opech milagro xuban ta per ne ktzitzij wa' njelal je xbij cana tzrij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y e q'uiy xeyke'a quec'u'x ruq'uin tzra'. ");
INSERT INTO tzjE_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","C'ol c'a jun acha Lázaro rubi', c'ola chpam tnamet Betania y lowlo' yawa'. Lázaro c'ola e c-e' rana', jun María rubi' y jun chic Marta rubi', ec'ola chka' chpam tnamet Betania. ");
INSERT INTO tzjE_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jara' María je xjupij perfume tzrij rkan Jesús y tzra resmal rwá' xusu' wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","J-e' c'a María ruq'uin Marta jrenmal xquetak ela rbixic tzra Jesús y cawra xecbij ela: —Kjawal, je kxibal jnewajo' ewi' ruq'uin camic congan lowlo' yawa'. ");
INSERT INTO tzjE_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ja' Jesús tak xc'axaj jxebixa tzra cawra xbij: —Jyubil rc'an Lázaro majo'n cmic rec'mon ta, jrec'mon ta jara' che tzra' ntz'e't wa' che Dios congan rchuk'a' y nim ruk'ij, y chka' congan nya' na ruk'ij Rlec'wal Dios rmal. ");
INSERT INTO tzjE_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús congan nquerajo' Marta ruq'uin María, chka' cxibal Lázaro. ");
INSERT INTO tzjE_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tak xekaja rbixic ruq'uin chcongan yawa' Lázaro xec'je' na c-e' k'ij tzra' abar c'ol wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tak xetz'kata c-e' k'ij rmal cawra xbij chca rdiscípulo: —Jo' komloj chic jmul chpam departamento Judea. ");
INSERT INTO tzjE_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","J-e' rdiscípulo cawra xecbij tzra: —Maestro, j-e' wnak aj Israel xtzan abaj xcajo' ta xatccamsaj. ¿Nawajo' ncatemloj chic jmul tzra'? ");
INSERT INTO tzjE_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús xuya' jun c'ambal tzij chquewech y cawra xbij chca: —¿Me cbeljuj tc'a hor sak nuya' k'ij? Tak pk'ij ncatbina majo'n nachak'ij ta awkan com k'ij sak rebnon tzra rwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tak chak'a' ncatbina jara' nachak'ij awkan. Nbij tzij tak majo'n luz chpam awanm majo'n ncatecwin ta natzu' abey. ");
INSERT INTO tzjE_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tak xbitaja jawra rmal cawra xbij chic chca: —Kexbil Lázaro warnak chic per quenwajo' quenba ruq'uin y cnec'sa'. ");
INSERT INTO tzjE_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Kjawal, we xwarnak jara' nbij tzij chnec'choja. Cara' xecbij rdiscípulo tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Per Jesús tak xbij chwarnak Lázaro nbij tzij che xcoma, per j-e' rdiscípulo xquech'ob xjic wram rebnon y xlannak jurmaj. ");
INSERT INTO tzjE_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","C'jara' Jesús xk'alsaj njelal chquewech: —Lázaro comnak chic. ");
INSERT INTO tzjE_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Anen congan quenquicota tak en majo'n tzra' tak xcoma Lázaro per ewmal ixix tak quenbij cawra chewa. Jo' ekatz'ta' Lázaro perc chewa ixix c'ola utzlaj tak achnak rec'mon ta chewa chneyke'a más ec'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás jyu'x nbixa tzra, cawra xbij chca rexbil je rdiscípulo Jesús: —Jo' tzrij Jesús ch-utz c'ara' chajoj chka' nkocoma ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tak xe'ekaja pe rtnamet Lázaro xbixa tzra Jesús che cji' k'ij mkun Lázaro chpam tuj. ");
INSERT INTO tzjE_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Je tnamet Betania xchenkaj Jerusalén c'o wa', c'ol lala' jun oxi' kilómetro recjol ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","E q'uiy je' aj Israel e'ulnak cuq'uin Marta y María che nercyukba' quec'u'x rmal recmic cxibal. ");
INSERT INTO tzjE_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta tak xc'axaj che xpeta Jesús xerec'lu', per María tz'bul cana pjay. ");
INSERT INTO tzjE_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta tak xuc'ul Jesús cawra xbij tzra: —Wajaw, wext atc'ola kuq'uin mquita xcoma kxibal. ");
INSERT INTO tzjE_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Per anen wutkin nak nac'utuj tzra Dios, Dios nuya'. ");
INSERT INTO tzjE_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús cawra xbij: —Axibal nc'astaja rwech. ");
INSERT INTO tzjE_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta cawra xbij tzra: —Anen wutkin che nc'astaj na tak xtquec'astaja cnomki' pe rq'uisbal k'ij. ");
INSERT INTO tzjE_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús cawra xbij tzra: —Per anen quenycowa cxin wnak chpam cmic, anen quenyowa utzlaj c'aslemal je rxin junlic. Nak ykula ruc'u'x wq'uin, mesque ncoma per jara' mjunlic ta, nec'se' chna jmul. ");
INSERT INTO tzjE_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Y chka' nak c'c'as na camic y ykula ruc'u'x wq'uin jara' majo'n cmic tzrij, y nec'se'a rxin junlic. ¿Nanimaj njelal jxenbij chawa? ");
INSERT INTO tzjE_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Quennimaj Wajaw, anen nniman chka' chatet at Cristo, at Rlec'wal Dios jbitanak cana ojer che npe na wawe' chwech ruch'lew. Cara' xbij Marta. ");
INSERT INTO tzjE_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ja' Marta tak xbitaja tzij rmal xba siq'uiy María jruchak'. Tak xekaja ruq'uin pnejkal xtzijona ruq'uin y cawra xbij tzra: —Xerkaja Maestro, ncatersiq'uij. ");
INSERT INTO tzjE_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ja' María tak xc'axaj xyictaj ela alnak y xba ruq'uin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ja' Jesús q'uemja'na toca chpam tnamet, q'ue tzra' c'ol wa' abar xc'u'l wa' rmal Marta. ");
INSERT INTO tzjE_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","J-e' c'a aj Israel jec'ola pjay ruq'uin María eponnak chnecyukba' quec'u'x, tak xquetz'et che xyictaj ela alnak María j-e' chka' xeyictaj ela alnak y xetre'a tzrij, y cawra necbij chbil tak qui': —Tzra' nba wa' abar mkun wa' comnak, tzra' nbe'ok' wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María tak xekaja abar c'ol wa' Jesús y tak xutz'et, xexque'a chwech y cawra xbij tzra: —Wajaw, wext atc'ola kuq'uin mquita xcoma nxibal. ");
INSERT INTO tzjE_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ja' Jesús tak xutzu' María chcongan ok'ej remjon rij, y chka' jle' chic aj Israel je rexbil jetrena tzrij congan nque'ok'a, junwa' xuna' y congan xuk'ut ri' ranm rmal bis. ");
INSERT INTO tzjE_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Y cawra xc'axaj chca: —¿Abar c'a emkun wa'? —Kajaw, jo' mpa', ekatz'ta'. ");
INSERT INTO tzjE_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús xok'a. ");
INSERT INTO tzjE_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","J-e' c'a aj Israel tak xquetzu' Jesús remjon ok'ej cawra xecbij: —Tetz'ta' mpa', nk'alaj chcongan nrajo' Lázaro. ");
INSERT INTO tzjE_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Per ec'ola nic'aj cawra necbij: —Wxecwina xujak rwech jun acha moy ¿le mxecwin tc'ara' xchumsaj Lázaro che mquita xcoma? ");
INSERT INTO tzjE_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Wjic chic ja' Jesús junwa' xuna' rmal bis y xba abar mkun wa' Lázaro. C'ola jun jul c'ton chwech jun jyu', chpam mkun wa' y tz'apin ruchi' tzan jun nimlaj abaj. ");
INSERT INTO tzjE_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Telsaj abaj, cara' xbij Jesús chca. Ja' Marta rana' comnak cawra xbij: —Wajaw, jala' chuw chic perc xuban cji' k'ij comnak. ");
INSERT INTO tzjE_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—¿Le mxenbij tc'a chawa, wneyke'a ec'u'x wq'uin netz'et che Dios congan rchuk'a' y nim ruk'ij? ");
INSERT INTO tzjE_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","C'jara' xquelsaj abaj chuchi' jul abar mkun wa' comnak. Ja' Jesús xca'y chcaj y cawra xbij: —Nedta', anen quenmeltioxij chawa che xawc'axaj jxenc'utuj chawa. ");
INSERT INTO tzjE_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Per anen wutkin che cnawc'axaj nak quenc'utuj chawa. Cawra quenbij chawa camic ch-utz c'ara' je' wnak jquemlon qui' camic necc'axaj nak nemjon rbixic chawa ch-utz c'ara' quencnimaj chatet attakyon ta wxin. Cara' xbij tzra Ttixel jc'ola chcaj. ");
INSERT INTO tzjE_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tak xbitaja tzij rmal Jesús xtzijon chic jmul, per ncow xtzijona y cawra xbij: —Lázaro, catel ta. ");
INSERT INTO tzjE_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","C'jara' Lázaro xel ta per mcomnak xta. Je' ruk'a' y rkan btz'on pe tziak y ruplaj btz'on pjun su't. Y Jesús xbij: —Tecra' y tey-a' c'as tzra che nba. ");
INSERT INTO tzjE_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","J-e' c'a aj Israel e quexbil María tak xquetz'et jxuban Jesús e q'uiy chca xeyke'a quec'u'x ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Per ec'ola jle' chca xeba cuq'uin aj fariseo, xecbij chca jmilagro xuban Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","J-e' c'a sacerdote e quexbil fariseo xecsiq'uij jle' chic e k'atbaltzij y cawra xecbij chca: —¿Nak nkaban camic? Jesús congan je' milagro remjon rij. ");
INSERT INTO tzjE_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","We xtkaya' c'as tzra chnuban más milagro jara' mpen ta neyke'a quec'u'x che conjelal wnak ruq'uin. Tak xtbantaja cara' nyictaj ta nimlaj tnamet Roma, nretru' ktemplo ruq'uin ketnamet. ");
INSERT INTO tzjE_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","C'ola nimlaj sacerdote ocnak jara' juna', rubi' Caifás, arja' cawra xbij: —Ixix tak majo'n achnak nquixecwina nechumij. ");
INSERT INTO tzjE_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Xe mtch'obtaja ewmal che más na utz nko'ela xjun ncoma pkec'xiwach jara ajoj ok aj Israel que chwech nq'uisa nimlaj ketnamet, cara' xbij chca k'atbaltzij. ");
INSERT INTO tzjE_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ja' Caifás majo'n rnaben che Dios xbina tzra jtzij je xbij. Com arja' ocnak nimlaj sacerdote chpam jara' juna' rmal c'ara' xya'a tzra rmal Dios chxuya' pona rbixic chJesús ncom na pquecwent tnamet Israel. ");
INSERT INTO tzjE_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Per mruyon ta precwent Israel ncom wa', arja' nquerumol na conjelal rlec'wal Dios je cchican qui' chwech ruch'lew ch-utz c'ara' xjun nuban chca conjelal. ");
INSERT INTO tzjE_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jara' k'ij xquemaj rch'obic je k'atbaltzij nak nqueban tzra Jesús che neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rmal c'ara' Jesús majo'n kas txec'je' chic chquecjol aj Israel. Xba chpam jun tnamet chic, rubi' Efraín, chenkaj pona chuchi' chkilaj tak lwar. Tzra' xec'je' wa' e rexbil rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Y xyamer nerla' k'ij rxin jun nimlaj nimk'ij, pascua rubi'. Tak q'uemja'na terla' k'ij rxin nimk'ij e q'uiy je' wnak xe'el ta chpam quetnamet, xeba chpam tnamet Jerusalén e bnoy jle' ccostumbre ch-utz c'ara' nque'oca e ch'ajch'oj ajni' nrajo' creligión. ");
INSERT INTO tzjE_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Je' wnak jec'ola chpam nimlaj templo rxin Dios quemjon rconxic Jesús. Y quemjon rc'axic chbil tak qui': —¿Nak nech'ob ixix tzrij Jesús, le npeta bnoy nimk'ij o wmajo'n? ");
INSERT INTO tzjE_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","J-e' c'a cjefe sacerdote e quexbil aj fariseo quey-on chic jun orden jcawra nbij: —Nak wnak rutkin abar c'ol wa' Jesús tey-a' rbixic chka. Cara' xqueban ch-utz c'ara' nquechap Jesús y nquecsaj pcars. ");
INSERT INTO tzjE_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wajki' k'ij c'ol wa' nimk'ij pascua tak xba chic jmul Jesús chpam tnamet Betania abar c'ol wa' Lázaro. Jara' mism Lázaro je xc'a'sa chquecjol cnomki' rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","C'ola jun nimlaj w-im xchomixa pBetania rmal jxekaja Jesús cuq'uin. Marta remjon rya'ic recbal way chwech mes, Lázaro arja' tz'bula chquecjol wnak jec'ola ruq'uin Jesús chwech mes. ");
INSERT INTO tzjE_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María arja' xuc'om pa nic'aj litro perfume kas qui' rexla', nardo ocnak, y chka' congan nim rejlal, y xutix jara' perfume tzrij rkan Jesús. Tak xtixtaja xumaj c'a rsu'ic tzan resmal rwá'. Jara' perfume congan xnoja rexla' pjay. ");
INSERT INTO tzjE_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","C'ol c'a jun chca rdiscípulo rubi' Judas Iscariote, rlec'wal jun acha rubi' Simón, jara' jnejchowa rxin Jesús pquek'a' je nquetzelana rxin. Judas tak xutz'et jxuban María cawra xbij: ");
INSERT INTO tzjE_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Jala' perfume ¿nak tzra mxuya' ta chka, xekc'ayij ta che oxi' cient denario y jara' pak xkaya' ta chca je' mibi'? ");
INSERT INTO tzjE_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Cara' xbij per me rmal ta che npoknaj quewech mibi' com arja' xe elk'om y nelk'aj pak jc'ola pcaj, com xpruk'a' ja' y-on wa' pak rxin Jesús y je' rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús xcanoj rutzij y cawra xbij tzra: —Mtanak ta María, arja' remlon perfume chnuya' chwij y jara' nnatbej necmic. ");
INSERT INTO tzjE_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Je' mibi' ne ec'ol wa' checjol y nquec'je' na checjol wc'ola egan neban utzil chca, per chwa anen majo'n quenc'je' ta ewq'uin njelal tiemp, quenlsas na checjol. ");
INSERT INTO tzjE_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Congan e q'uiy je' wnak aj Israel tak xecc'axaj chc'ola Jesús chpam tnamet Betania tzra' xeba wa' chnequetz'ta', y chka' ncajo' nequetz'ta' rwech Lázaro, jara' Lázaro je xc'astaja chquecjol cnomki' rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","J-e' c'a cjefe sacerdote xquemol qui' che rchumsic nak nqueban tzra Lázaro che neccamsaj chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Cara' nqueban com xe rmal Lázaro tak e q'uiy je' wnak aj Israel xeyke'a quec'u'x ruq'uin Jesús, majo'n chic xecnimaj ta sacerdote. ");
INSERT INTO tzjE_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Rcab k'ij je' wnak je eponnak che bnoy nimk'ij congan e q'uiy chca xecc'axaj che npona Jesús pe tnamet Jerusalén. ");
INSERT INTO tzjE_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Arj-e' xquec'om pa ruxak tak che' palma, y xepeta che rc'ulic. C'jara' xquemaj rakic quechi' y cawra xecbij: —Dios ko'at-o' camic, xpeta To'onel, najni'la nim ruk'ij, arja' Rey kxin ok aj Israel, penak prubi' Kajaw Dios. Cara' necbij je'a. ");
INSERT INTO tzjE_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ja' Jesús xcanoj jun ch'it co'l bur. Tak xcontaja rmal xetz'be' pa tzrij. Cara' xuban ajni' tz'ibtal cana ojer chpam rtzojbal Dios che nbantaj na y cawra nbij: ");
INSERT INTO tzjE_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","—Je ixix aj Sion, mtexibej ta ewi' camic, tetz'ta' mpa', xpeta Rey ewxin, tz'bul ta tzrij jun ch'it co'l bur. ");
INSERT INTO tzjE_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Per je rdiscípulo Jesús mesquier nch'obtaja cmal nabey njelal jawrara je ntajina nuban Jesús. Tak xc'astaja Jesús chquecjol cnomki' y tak xojte'a chcaj c'jara' xch'obtaja cmal y xerkaja pquewá' jtz'iban cana ojer chpam rtzojbal Dios je njelal jxuban Jesús, ajni' tz'iban cana y ncara' xba'na tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tzra' ec'ol wa' jle' jxetz'towa rxin Jesús tak xuyic Lázaro chquecjol cnomki' y j-e' xecc'axaj nak xbij tzra Lázaro che nel ta chpam jul abar mkun wa'. J-ewra wnak xquemaj rbixic chca jle' chic wnak njelal je xquetz'et. ");
INSERT INTO tzjE_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Rmal c'ara' tak xepeta je' wnak che rc'ulic Jesús com xecc'axaj milagro jxuban tzra Lázaro. ");
INSERT INTO tzjE_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","J-e' c'a aj fariseo congan pkan quen-on rmal c'ara' xquemaj rbixic chbil tak qui' y cawra necbij: —Que'etz'ta' mpa' je' wnak la', xeba ruq'uin Jesús per nche conjelal, camic majo'n chic achnak nkaban tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ec'ola nic'aj wnak epenak chpam nación Grecia, erkanak pJerusalén, epenak e y-ol ruk'ij Dios chpam nimk'ij pascua. ");
INSERT INTO tzjE_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Xeba ruq'uin Felipe jc'ola chpam tnamet Betsaida jc'ola precwent Galilea. Tak xe'ekaja ruq'uin cawra xecbij tzra: —Ajoj nkajo' nkutkij rwech Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe xerbij tzra Andrés, c'jara' xeba che c-e', xecbij tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tak Jesús xc'axaj je xbixa tzra cawra xbij: —Camic Rlec'walxel jxoca alxic cuq'uin wnak xerla' retiemp che nya' na ruk'ij congan. ");
INSERT INTO tzjE_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ne ktzitzij wa' je xtenbij chewa tzra jun c'ambal tzij jawra. Jun rk'arwech trigo wxnapoknaj namuk pnulew jara' majo'n ntz'uc ta y majo'n rwech nuya'. Per wmajo'n napoknaj ta namuk pnulew jara' congan ntz'uc ta y congan rwech nuya'. ");
INSERT INTO tzjE_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wnapoknaj naya' cana ac'aslemal wawe' chwech ruch'lew jara' natz'ila' ac'aslemal, per wmajo'n napoknaj ta naya' cana ac'aslemal rxin wawe' chuch'lew jara' awc'an utzlaj c'aslemal rxin Dios je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Je' wnak je nquenimana wxin nc'atzina nquek'axa tzra' abar enk'axnak wa' anen, y chka' tzra' nquec'je' wa' abar enc'ol wa' anen. Je' wnak xtquenimana wxin ajni'la nya'a quek'ij rmal Nedta'. ");
INSERT INTO tzjE_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Camic congan nti'ona wanm, nlowlo' nba'na chwa. ¿Per nak xtenban? ¿Xtenbij tc'a tzra Nedta' xtquenruto' ta ch-utz c'ara' mquita xtenk'axa chpam nimlaj lowlo' jpenak chenwech? Jara' mesquier xtencwin ta xtenban. Perc lowlo' jpenak chenwech, xe rmal c'ara' enpenak wawe' chwech ruch'lew che quenk'axa chpam. ");
INSERT INTO tzjE_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Xerwara' quenbij chawa Nedta', tk'alsaj chquewech wnak chatet nim ak'ij. Tak xbitaja rmal Jesús jawra tzij xk'aljin tc'a jle' tzij penak chcaj, cawra xbij: —Jara' nk'alsan chic y quenk'alsaj chna más chka', cara' xbij ta ja' Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Je' wnak jec'ola tzra' ec'ola nic'aj xecc'axaj jara' tzij y necbij chxuban jun c'koljay, y nic'aj necbij: —Jun ángel xtzijon ta ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús cawra xbij chca: —Jtzij jxewc'axaj me nmal ta anen je xpeta, ewmal ixix xpeta. ");
INSERT INTO tzjE_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Camic xerla' k'ij rxin che nk'aljina nak rbanic rtzilal jc'ola ptak canm je' wnak jec'ola wawe' chwech ruch'lew. Camic xerla' k'ij rxin diablo jnebnowa mandar wawe' chwech ruch'lew, camic nbattax ela. ");
INSERT INTO tzjE_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Per chwa anen, tak xtenjotbaxa, conjelal wnak quenjik'aj canm chka bechnak opech cbanic ch-utz c'ara' neyke'a quec'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tak xbij jawra tzij jara' xc'utbej nak xtba'na tzra tak xtcamsasa chwech jun cruz. ");
INSERT INTO tzjE_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Je' wnak cawra xecbij ra': —Per kc'axan wan chpam rtzojbal Dios, tak xtpeta Cristo jara' majo'n cmic tzrij y nec'se'a rxin junlic. ¿Nak tzra c'ara' tak nabij che njotbax na Rlec'walxel jxoca alxic cuq'uin wnak? ¿Nak wnak c'ara' rlec'walxel jnabij kaja? ");
INSERT INTO tzjE_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús cawra xbij chic chca: —Je nsakersana ebey camic arja' xjun c-e' k'ij c'ol chic ewq'uin rmal c'ara' quenbij chewa, c'ol na luz ewq'uin y tey-a' c'as tzra che noca ptak ewanm ch-utz c'ara' majo'n noc ta k'ejku'm ptak ewanm. Je' wnak xe chpam k'ejku'm nebin wa' arj-e' majo'n cutkin ta abar xtque'ekaj wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Com q'uemja'na tela checjol je nsakersana ebey rmal c'ara' tak quenbij chewa, teyke'a ec'u'x ruq'uin camic ch-utz c'ara' nja' sak nc'ana ewxin. Tak xbitaja jawra tzij rmal xba y xiwaj ri' chquewech. ");
INSERT INTO tzjE_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ja' Jesús mesque q'uiy milagro rebnon chic je rc'utben chquewech wnak nak rbanic per j-e' nmajo'n xeyke' ta quec'u'x ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Cara' xqueban ch-utz c'ara' nbantaja ajni' tz'ibtanak cana rmal profeta Isaías ojer jcawra nbij: —Wajaw, me q'uiy ta xenimana atzojbal je xkaya' rbixic, me q'uiy ta je xch'obtaja cmal nak rbanic nmak tak milagro naban chquewech. Cara' tz'ibtanak cana. ");
INSERT INTO tzjE_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Rmal c'ara' mxecwin ta je' wnak xeyke'a quec'u'x ruq'uin Jesús. Cara' xqueban com c'o chic jle' tzij bitanak cana rmal Isaías y cawra nbij: ");
INSERT INTO tzjE_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","—Xuban Dios chca ajni' xermoyirsaj y chka' xcowersaj canm, cara' xuban chca ch-utz c'ara' majo'n nquetz'et ta jnak nc'u'ta chquewech y majo'n nch'obtaj ta cmal je nbixa chca, y majo'n nqueq'uex ta cna'oj che nquechumtaja. ");
INSERT INTO tzjE_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Cara' rbin cana ja' Isaías tak xutz'et nimlaj gloria rxin Kajaw y tak xtzijona tzrij nak rbanic. ");
INSERT INTO tzjE_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Per e q'uiy chca e k'toy tak tzij xecnimaj Jesús per majo'n ncajo' ta necbij che ykula quec'u'x ruq'uin com xnecxibej qui' chquewech aj fariseo. —Mex tokch'akix ta chpam jay rxin molbal ri'il abar nekc'axaj wa' rtzojbal, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Cara' xqueban com más na nqueya' ruk'ij nak xbixa chca cmal wnak que chwech je nbixa chca rmal Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Xumaj chic tzij Jesús, cow xtzijona y cawra xbij: —Je' wnak je ykula quec'u'x wq'uin jara' ykul c'ara' quec'u'x chka' ruq'uin jtakyon ta wxin, mruyon ta wq'uin anen ykul wa' quec'u'x. ");
INSERT INTO tzjE_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Je' wnak jquetz'ton nwech quetz'ton c'a rwech jtakyon ta wxin, mnuyon ta anen quetz'ton nwech. ");
INSERT INTO tzjE_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Anen enpenak wawe' chwech ruch'lew che quensakersaj quebey je' wnak chquewech ch-utz c'ara' chka bechnak wnak xteyke'a quec'u'x wq'uin arj-e' majo'n chic nquec'je' ta chpam k'ejku'm. ");
INSERT INTO tzjE_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Anen enpenak wawe' chwech ruch'lew me rmal ta chquenk'at tzij chquij wnak per enpenak che cto'ic rmal c'ara' quenbij chewa, wec'ola wnak nquec'axana jquenbij chca y majo'n necnimaj ta jara' manen ta quenk'towa tzij chquij. ");
INSERT INTO tzjE_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Per wmajo'n ncajo' ta neyke'a quec'u'x wq'uin y wmajo'n necnimaj ta jquenbij chca jara' c'ola nk'atbexa tzij chquij, com jtzij jxenbij chca jara' nk'atbexa tzij chquij tak xterla' jnimlaj juicio rxin q'uisbal k'ij. ");
INSERT INTO tzjE_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Cawra quenbij chewa com jtijonem jnec'tun chewech jara' y-on chwa rmal Ttixel, ja' takyon pa wxin, me nna'oj ta anen nwankersan nuyon kaja. ");
INSERT INTO tzjE_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Y jtijonem je y-on chwa rmal Ttixel wutkin chja' c'amyon ta utzlaj c'aslemal je rxin junlic. Cara' rbanic, njelal tzij jquenbij, ja' Ttixel biyona chwa, cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Xerla' bispr rxin nimk'ij pascua. Ja' Jesús rutkin chic che xerla' hor rxin chnuya' cana rwech ruch'lew y nemloja ruq'uin Ttixel. Ajni' rebnon chca rdiscípulo wawe' chwech ruch'lew ncongan nquerajo' y ne nquerajo' wa' tak xcoma. ");
INSERT INTO tzjE_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ja' Jesús remjon w-im cuq'uin rdiscípulo y diablo rebnon chic samaj pranm Judas Iscariote, rlec'wal Simón, rtajchin el chic chnujach Jesús pquek'a' je' wnak je nquetzelana rxin. ");
INSERT INTO tzjE_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ja' Jesús rutkin chic che jchon chic pruk'a' njelal achnak rmal Ttixel y rutkin chic chka' ruq'uin Dios penak wa' y ruq'uin nemloj chwa'. ");
INSERT INTO tzjE_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","C'jara' xyictaj ta tzrij mes, xelsaj rtziak jnim tziak jc'ola tzrij y xuc'om jun toay, xuya' xe' rpam. ");
INSERT INTO tzjE_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","C'jara' xchumij jun plangan ya' y xumaj rch'ajic ckan rdiscípulo. Tak nch'ajtaja akan rmal nusu' tzan toay jrey-on xe' rpam. ");
INSERT INTO tzjE_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tak xekaja ruq'uin Simón Pedro chnuch'aj rkan cawra xbixa tzra rmal Pedro: —Wajaw, me tkal ta chawij nach'aj wkan. ");
INSERT INTO tzjE_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Camic mtch'obtaja awmal jnemjon rbanic chawa. Per nerla' na jun k'ij tak nch'obtaja awmal, cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Mcara' ta, atet me tkal twa' chawij nach'aj wkan. —Me xtench'aj ta awkan mat wexbil tc'ara'. ");
INSERT INTO tzjE_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","C'jara' Pedro cawra xbij: —Wajaw, wcara' rbanic mruyon tc'ara' wkan xtach'aj, tech'ja' chka' nuk'a' ruq'uin nwá'. ");
INSERT INTO tzjE_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús cawra xbij: —Jun acha wrech'jon chic rij ch'ajch'oj chc'ara', majo'n chic rilaj nach'aj chic wjic rij, xruyon chic rkan nach'aj, y cara' chewa ixix, ix ch'ajch'oj chic per mix conjelal ta. ");
INSERT INTO tzjE_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Com ja' rutkin chic nak nejchowa rxin pquek'a' je' wnak je nquetzelana rxin rmal c'ara' tak xbij cawra: —Mix conjelal ta ixch'ajch'oj. ");
INSERT INTO tzjE_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tak xch'ajtaja je' akan rmal c'jara' xecsaj chic rtziak jrelsan y xetz'be'a tzrij mes y cawra xbij chic chca: —¿Le nch'obtaja ewmal jxenban chewa? ");
INSERT INTO tzjE_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ixix nebij chwa Maestro, chka' nebij chwa Kajaw, y jara' ne rbeyal wa' nebij com ne ktzij wa' nebij che anen en Emaestro, en Ewajaw chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Anen en Ewajaw, en Emaestro chka', per mxenpoknaj ta wi' xench'aj ewkan. Cara' c'a chewa ixix chka', nc'atzina majo'n nepoknaj ta ewi' nech'aj ewkan chbil tak ewi'. ");
INSERT INTO tzjE_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Jun rbeyal c'a wa' xenya' chewech chcara' neban ixix chka' chbil tak ewi' ajni' xenban anen chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ne ktzitzij wa' jawra je xtenbij chewa, jun ilinel nmajo'n nim ta ruk'ij chwech rajaw, y jun bnoy mandad nmajo'n nim ta ruk'ij chwech jtakyon ela rxin. ");
INSERT INTO tzjE_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","We nch'obtaja ewmal jxenbij kaja chewa jara' congan qui' ac'u'x nuban per wnenimaj. ");
INSERT INTO tzjE_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Per mix conjelal ta qui' ec'u'x com anen wutkin ajni' ena'oj jixnech-on. Nc'atzina nbantaja cumplir rtzojbal Dios jtz'ibtanak cana ojer chwij anen jcawra nbij: —C'ola jun xoc wexbil, junam xokwa'a ruq'uin, jara' xenrc'ullaj y xyictaja chwij, cara' tz'iban cana. ");
INSERT INTO tzjE_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jawra jxenbij chewa q'uemja'na tbantaja per quenbij pona chewa che nbantaj na. Quenbij pona chewa ch-utz c'ara' tak xtbantaja bien nch'obtaja ewmal nak nbanic anen y nenimaj ajni' nbin cana chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ne ktzij wa' je xtenbij chewa, nak xtec'luwa cxin ajsmajma' je xtquenutak ela, anen c'ara' quenquec'ul, y nak xtec'luwa wxin anen nquec'ul c'ara' chka' jtakyon ta wxin. ");
INSERT INTO tzjE_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tak xbitaja jawra tzij rmal xumaj c'a jun nimlaj bis, congan xbisona ranm rmal c'ara' cawra xbij chic chca: —Ne ktzij wa' je xtenbij chewa, c'o jun chewa jara' nejchowa wxin pquek'a' wnak je nquetzelana wxin. ");
INSERT INTO tzjE_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Je rdiscípulo xquemaj rtz'etic je' qui', mesquier nch'obtaja cmal nak chu tzra xbix wa' tzij. ");
INSERT INTO tzjE_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","C'o jun chca discípulo congan njo'xa rmal Jesús, arja' tz'bul oca prupox Jesús tzrij mes. ");
INSERT INTO tzjE_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro xuban pona señas chwech che nc'axaj pona tzra Jesús nak chu tzra xbij wa' tzij. ");
INSERT INTO tzjE_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ja' discípulo xki'l oca chwech ruc'u'x Jesús y cawra xc'axaj tzra: —Kajaw ¿nak jun chka nejchowa awxin? ");
INSERT INTO tzjE_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—Abar xtenya' wa' xquelway je xtenmu', ja' c'ara'. C'jara' xumu' xquelway y xuya' tzra Judas Iscariote rlec'wal Simón. ");
INSERT INTO tzjE_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas tak xc'amtaja xquelway rmal xoca Satanás pranm y cawra xbixa tzra rmal Jesús: —Nak amjon rch'obic chnaban jat abna' chanim. ");
INSERT INTO tzjE_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Conjelal jec'ola tzrij mes next jun xch'obtaja rmal nak tzra tak xbixa cara' tzra Judas rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ec'ola xquech'ob kaja je xbixa tzra Judas che nba nberelk'o' nak nc'atzina tzra nimlaj w-im je rxin nimk'ij, o xta'k ela che nberey-a' jun ayuda chca mibi' com ruq'uin ja' Judas c'o wa' njelal cpak. ");
INSERT INTO tzjE_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Cara' xuban Judas, xc'amtaja xquelway rmal, xel ela chquecjol, ocnak chic k'ejku'm. ");
INSERT INTO tzjE_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tak elnak el chic Judas xumaj chic wjic tzij Jesús, cawra xbij: —Camic k'alaj chic chcongan nim ruk'ij Rlec'walxel jxoca alxic cuq'uin wnak. Y jun chic, rmal rc'aslemal Rlec'walxel tzra' ntz'e't wa' chcongan nim ruk'ij Dios chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Com Dios nya'a ruk'ij rmal rc'aslemal Rlec'walxel rmal c'ara' Dios nk'alsaj na chcongan nim ruk'ij Rlec'walxel chka', nk'alsaj na che xjun quebnon ruq'uin y jara' nk'alsaj chanim. ");
INSERT INTO tzjE_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ch'tak wlec'wal, anen majru' xta k'ij enc'ola checjol. Ixix cnecanoj chna per abar xtenba wa' anen mesquier nquixecwina nquixekaja tzra', jawra tzij ajni' xenbij chca jle' aj Israel. ");
INSERT INTO tzjE_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","C'ola jun c'ac'laj mandamiento quenbij cana chewa, twaj-o' je' ewi' chbil tak ewi'. Ajni' nebnon ta anen chewa ixnwaj-on ta, cara' c'a tebna' ixix chka', twaj-o' je' ewi'. Ja c'awa' c'ac' mandamiento quenya' cana chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wcara' neban, wnewajo' chbil tak ewi', tzra' c'a ntz'e't wa' cmal conjelal wnak che ktzij wa' ix ndiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro cawra xbij: —Kajaw ¿abar q'ue tzra' ncatba wa'? —Jesús cawra xbij: —Abar xtenba wa', atet mesquier ncatecwina ncatetre'a chwij camic, per nerla' na jun k'ij tak xtcatetre'a chwij. ");
INSERT INTO tzjE_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—Wajaw ¿nak tzra mesquier quencwina quentre'a chawij camic? Anen majo'n quenpoknaj ta wi' quencamsasa opech awmal. ");
INSERT INTO tzjE_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—¿Le ktzitzij nabij chwa chmajo'n napoknaj ta awi' ncatcamsasa wmal? Per jawra je xtenbij chawa ne ktzitzij wa', tak q'uemja'na trekena pre'y, atet oxmul abin chic majo'n awutkin ta nwech, cara' xbixa tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","C'jara' xbij chic chca: —Me tyojtaj ta ewanm, teyke'a ec'u'x ruq'uin Dios y wq'uin anen chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Pruchoch Nedta' congan q'uiy je' lwar tzra', per che mquita cara' mquita xenbij chewa. Anen quenba camic cnechumsaj jun elwar. ");
INSERT INTO tzjE_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ajni' xenbij chewa, quenba cnechumsaj elwar per quenmloj pchic jmul quixenrec'ma' kaja ch-utz c'ara' nquixec'je'a wq'uin. Cara' quenban ch-utz c'ara' abar xtenc'je' wa' anen tzra' nquixec'je' wa' ixix chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ixix ewutkin abar xtenba wa', ewutkin bey chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás cawra xc'axaj tzra: —Wajaw, ajoj majo'n kutkin ta abar tzra' ncatba wa'. ¿Nak tzer c'ara' nabij chka chajoj kutkin bey? ");
INSERT INTO tzjE_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","—Anen c'ara' en bey, wq'uin anen neltaj wa' njelal ktzitzij, majo'n tz'koj tzij wq'uin, anen c'ara' quenyowa utzlaj c'aslemal je rxin junlic. Next jun xtepon ta ruq'uin Ttixel mquita ykul ela ruc'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Per wext ch'obtanak ewmal ojer nak nbanic anen ch'obtanak tc'ara' ewmal chka' nak rbanic Nedta', per camic xtch'obtaj c'a ewmal nak rbanic Nedta' y etz'ton chic rwech chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe cawra xbij tzra: —Wajaw, tec'tu' chkawech Ttixel, xruq'uin ra' nokquicota y majo'n chic achnak nkajo' chawa. ");
INSERT INTO tzjE_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","—Felipe ¿nak tzra tak nabij chwa chquenc'ut Ttixel? Per najru'la tiemp enc'ola ewq'uin. ¿Lq'uemja'n c'ara' tch'obtaja awmal nak nbanic? Nak wnak rutkin nwech rutkin c'ara' rwech Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Le mtanimaj c'a chanen xjun kabnon ruq'uin Ttixel y ja' Ttixel xjun rebnon wq'uin anen chka'? Njelal tzij jquenbij chewa manen ta enwankersyona, ja' Ttixel c'ola pwanm y nesmaja che rbanic njelal samaj jquenban. ");
INSERT INTO tzjE_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tnimaj jquenbij chewa chanen xjun kabnon ruq'uin Ttixel y ja' Ttixel xjun rebnon wq'uin chka', o wmtenimaj che ktzitzij quenbij chewa c'o c'a nmak tak milagro nebnon chewech, rmal tc'ara' xtenimaj. ");
INSERT INTO tzjE_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ne ktzitzij wa' je xtenbij chewa, je' wnak je xteyke'a quec'u'x wq'uin j-e' c'ara' nyataja chca che nqueban nmak tak milagro ajni' xenban anen, y xtyataj na chca che más na nmak tak milagro xtqueban que chwech ajni' xenban anen. Cara' quenbij chewa com anen quenba ruq'uin Ttixel rmal c'ara' tak nyataja chca chcara' nqueban. ");
INSERT INTO tzjE_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Y jun chic, njelal je xtec'utuj tzra Nedta' y we ykul ec'u'x wq'uin che rc'utxic, anen quenya' chewa jnec'utuj. Cara' rbanic ch-utz c'ara' nya'a ruk'ij Ttixel, per rmal Rlec'walxel tak nya'a ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Jmul chic quenbij chewa, nak xtec'utuj y ykula ec'u'x wq'uin che rc'utxic, anen quenya' chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","We ktzitzij cnewajo' nenimaj c'ara' nak quenbij chewa chneban. ");
INSERT INTO tzjE_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Y anen quenc'utuj tzra Ttixel che arja' nutak ta jun chic To'onel ewxin y nec'je'a ewq'uin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Je nta'k pchic ewq'uin jara' Espíritu Santo, ne ktzitzij njelal je nbij. Je' wnak xruq'uin rwech ruch'lew ykul wa' quec'u'x j-e' c'ara' mesquier nquecwina nquech'ob nak rbanic Espíritu Santo y majo'n nquec'ul ta, com j-e' mesquier nquetz'et rwech y majo'n cutkin ta rwech rmal c'ara' tak nqueban cara'. Per ixix ewutkin rwech com arja' c'ola ewq'uin y nec'je' na ptak ewanm. ");
INSERT INTO tzjE_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Anen quenba per majo'n quenban cta chewa ix ajni' ch'tak mibi', quenmloj pe chna jmul ewq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Xjarlal q'uemja'na quenba, per tak xtenba majo'n quenquetz'et chta je' wnak xruq'uin rwech ruch'lew ykul wa' quec'u'x, per ixix cnetz'et na. Com anen newc'an utzlaj c'aslemal je rxin junlic rmal c'ara' newc'aj na ixix chka' utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tak xtpeta Espíritu Santo jara' bien nch'obtaj chic ewmal chanen xjun kabnon ruq'uin Ttixel, y nch'obtaja ewmal chka' xjun chic ebnon wq'uin y anen xjun nebnon ewq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Je' wnak jnecnimaj ntzojbal y nqueyic ptak canm, tzra' nquetz'e't wa' che ktzitzij quencajo'. Je' wnak jquencajo' nquejo'x c'a arj-e' chka' rmal Nedta', y quenwajo' anen chka' y quenk'alsaj wi' chquewech. ");
INSERT INTO tzjE_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","C'jara' cawra xbixa tzra rmal Judas, per mjara' ta Judas Iscariote: —¿Nak rbanic c'ara' nabij atet che nak'alsaj awi' chkawech y majo'n nak'alsaj ta awi' chquewech je' wnak je xe chwech ruch'lew ykul wa' quec'u'x? ");
INSERT INTO tzjE_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","—Je' wnak ne ktzitzij quencajo' necnimaj c'ara' ntzojbal. Wcara' nqueban nquejo'x c'ara' rmal Nedta' y ok c-e' ruq'uin Nedta' nokekaja cuq'uin y jcanm noca kuchoch y chpam nokq'ue' wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Je' wnak jmajo'n quencajo' ta majo'n necnimaj ta ntzojbal, y jtzij je emjon rc'axic camic manen ta enwankersyona, ja' Ttixel jtakyon pa wxin jara' biyona chwa. ");
INSERT INTO tzjE_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Njelal jawra quenchol cana chewa perc q'uenc'o na ewq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Per tak xtquenel ela checjol c'jara' nta'k pchic jun ewq'uin tzan eto'ic y jara' Espíritu Santo, arja' nta'k ta rmal Nedta' y pnubi' anen nta'k twa'. Arja' nec'tuwa chewech njelal achnak y nnataj na njelal achnak je nbin cana chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Anen quenba per quenya' cana chewa che qui'il nec'je'a ewanm chwech Dios ajni' nebnon anen. Per jara' mjunam ta ruq'uin ajni' nuya' rwech ruch'lew. Me tyo'j ta ec'u'x y mtexibej ta ewi' chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ixix xewc'axaj tak xenbij cawra chewa: —Anen quenba per quenmloj pe chna jmul ewq'uin. Ruq'uin Nedta' quenba wa', cara' xenbij chewa. Per wext congan cnewajo' xixquicot tc'ara' tak xenbij chewa chruq'uin Nedta' quenba wa' com Nedta' más nim ruk'ij chenwech anen. ");
INSERT INTO tzjE_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Camic ney-on pon chic rbixic chewa nak q'uemja'na tba'na chwa ch-utz c'ara' tak xtbantaja neyke'a junlic ec'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Xjurat chic enc'ola checjol che noktzijona, cara' quenbij chewa com diablo jnebnowa mandar rxin rwech ruch'lew arja' xyamer nerkaja che nchapic. Per arja' majo'n ruk'a' chwa, majo'n achnak quenrchapbej. ");
INSERT INTO tzjE_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Xerwara' anen quenya' wi' pruk'a' ch-utz c'ara' je' wnak xruq'uin rwech ruch'lew ykul wa' quec'u'x ncutkij bien che anen congan quenwajo' Ttixel ch-utz c'ara' bien ncutkij che nniman jbin chwa rmal ja' Ttixel. Camic quixyictaja, jo' ko'el ela chpam jawra lwar. ");
INSERT INTO tzjE_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","C'jara' xbij jun c'ambal tzij y cawra xbij: —Wq'uin anen nel twa' c'aslemal che ktzitzij c'aslemal, anen en rkan jumlaj uva y Nedta' arja' jnebnowa cwent uva y njosk'ij. ");
INSERT INTO tzjE_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Arja' nch'upuj ela njelal ruk'a' uva jmajo'n rwech nuya' ta. Per jruk'a' uva je nwachina jara' njosk'ixa rmal Nedta' ch-utz c'ara' che nwachina más. ");
INSERT INTO tzjE_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Per ixix ixjosk'in chic tzan njelal tzij jxenbij chewa, jara' xixjosk'bexa. ");
INSERT INTO tzjE_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xjun tebna' wq'uin y xjun quenban ewq'uin chka', ajni' tzra ruk'a' uva che mquita jun rebnon ruq'uin rkan mquita nuya' rwech. Y cara' chewa ixix chka', wme xjun ta xteban wq'uin majo'n nwachin ta utzil rxin Dios ptak ewanm. ");
INSERT INTO tzjE_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Anen en rkan jumlaj uva, ixix ix ruk'a'. Chka bechnak chewa xjun nuban wq'uin y anen xjun quenban ruq'uin jara' junam ruq'uin ruk'a' uva congan nwachina. Cara' quenbij chewa com majo'n achnak nquixecwina neban we mjun ta neban wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Je' wnak xe mjun ta nqueban wq'uin cara' nba'na chca ajni' nba'na tzra ruk'a' uva, nch'upux ela y nechkija, c'jara' nmo'la ruchi' y nporoxa pk'ak'. ");
INSERT INTO tzjE_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","We xjun neban wq'uin, wnec'je'a ntzojbal ptak ewanm, c'jara' tc'utuj tzra Dios nak newajo' y nyataja chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","We k'axnak wen nwachina utzil rxin Dios ptak ec'aslemal jara' nya'a ruk'ij Nedta' cmal wnak y tzra' nquixtz'e't wa' che ktzitzij wa' ix ndiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ttixel congan quenrajo' y cara' nebnon chewa ixix chka' congan quixnwajo'. Camic quenbij chewa, quixc'je' c'a chpam ojben ri'il wxin. ");
INSERT INTO tzjE_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wnenimaj nak quenbij chewa che neban jara' nquixc'je'a chpam ojben ri'il wxin ajni' nebnon anen nniman jbin chwa rmal Nedta' y enc'ola chpam ojben ri'il rxin Nedta'. ");
INSERT INTO tzjE_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Njelal jawra jxenbij kaja chewa ch-utz c'ara' xtec'je' tc'a ptak ewanm jquicotemal rxin Dios jc'ola pwanm anen. Xenbij chewa ch-utz c'ara' xtnoj ta quicotemal rxin Dios ptak ewanm. ");
INSERT INTO tzjE_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ajni' nebnon anen chewa congan quixnwajo' cara' c'a tebna' ixix chka', twaj-o' je' ewi' chbil tak ewi'. Jawra jun mandamiento quenya' cana chewa chneban. ");
INSERT INTO tzjE_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tak majo'n napoknaj ta awi' ncatcoma precwent jun awamigo jara' nac'utbej chcongan nawajo', majo'n chjun nawajo' ta awi' cara'. ");
INSERT INTO tzjE_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ixix ix wamigo wnenimaj nak quenbij chewa chneban. ");
INSERT INTO tzjE_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Njelal je nc'axan jbin chwa rmal Nedta' jara' nk'alsan chic chewech rmal c'ara' quenbij chewa ix wamigo. Camic mjara' ta quenbij chewa che ix mos com jun mos mrutkin ta nak nuch'ob rpatrón. ");
INSERT INTO tzjE_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Me ixix ta xixcanona wxin per anen xencanona ewxin che xixoca apóstol, xenbij chewa che nquixba nebna' nsamaj. Cara' xenban chewa ch-utz c'ara' jsamaj nebna' c'ola utzil rxin Dios nwachij y jara' utzil jnewachij majo'n npu'k ta. Cara' rbanic ch-utz c'ara' je Ttixel nuya' chewa nak nec'utuj tzra we ykula ec'u'x wq'uin che rc'utxic. ");
INSERT INTO tzjE_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Njelal jawra xenbij chewa ch-utz c'ara' newajo' ewi'. ");
INSERT INTO tzjE_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Je' wnak xruq'uin rwech ruch'lew ykul wa' quec'u'x y xe itzel nquixquetz'et bien tech'bo' chcara' xqueban chwa anen nabey, itzel xenquetz'et chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Wext ix quexbil wnak je ykula quec'u'x ruq'uin rwech ruch'lew jara' kas ta nquixclok'k'oj ta, per mix quexbil ta com anen xench-owa ewxin chquecjol y xixnyonaj rmal c'ara' kas itzel nquixquetz'et. ");
INSERT INTO tzjE_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Terkaja pnewá' jun tzij jxenbij chewa cawrara: —Jun mos jara' mnim ta ruk'ij chwech rpatrón, cara' xenbij chewa. Nbij tzij c'ara' wc'ola lowlo' quebnon chwa c'o c'ara' lowlo' nqueban chewa ixix chka'. Wxecnimaj ntzojbal jxenbij chca necnimaj c'ara' chka' je xtebij chca ixix. ");
INSERT INTO tzjE_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Per nmal c'ara' anen tak xtetaj pen pquek'a'. J-e' nqueban na lowlo' chewa com majo'n cutkin ta rna'oj Dios jtakyon pa wxin. ");
INSERT INTO tzjE_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Per we mquita xenpeta y mquita xenk'alsaj chquewech ajni' rna'oj Dios jara' majo'n nquechapbexa, per camic majo'n nectobej qui' mesque ne xtecbij majo'n quemac. ");
INSERT INTO tzjE_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Je' wnak xitzel quenquetz'et jara' itzel nquetz'et Nedta' chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Per mquita xenban nmak tak milagro chquewech per jle' milagro next jun banyona jara' majo'n nquechapbexa, per jara' xquetz'et per camic xe itzel quenquetz'et y itzel nquetz'et Nedta' chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Cara' nqueban ch-utz c'ara' nbantaja cumplir jtz'ibtanak cana chwij anen chpam rley Dios jyatanak chca jcawra nbij: —J-e' xitzel xenquetz'et per majo'n wil y majo'n achnak xenban chca chka', cara' tz'ibtanak cana. ");
INSERT INTO tzjE_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Per jun chic To'onel jc'ola ruq'uin Nedta' jara' nkaj tna ewq'uin com anen quentkow ta rxin. Jara' Espíritu Santo, per jun Espíritu ne ktzitzij wa' njelal achnak nbij, jun Espíritu jruq'uin Nedta' npe wa'. Tak xterkaja ewq'uin nk'alsaj na chquewech wnak nak nbanic anen. ");
INSERT INTO tzjE_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Chka' ixix nek'alsaj na chquewech wnak nak nbanic anen com ixix ixc'ola wq'uin tak xenmaj ta nsamaj. ");
INSERT INTO tzjE_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Njelal jawra jxenbij kaja chewa rmal che mteya' cana yukbal ec'u'x wq'uin tak xtpeta je' lowlo' chewij. ");
INSERT INTO tzjE_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Com j-e' wnak nquixcch'akij ta chpam je' jay abar nc'axax wa' rtzojbal Dios y majo'n nquixquec'ul xta. Chka' nerla' na jun k'ij tak xtquixccamsaj per j-e' wnak nquech'ob che jara' nrajo' ranm Dios tak nquixccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Cara' nqueban chewa com j-e' majo'n cutkin ta nak rna'oj Ttixel y majo'n cutkin ta nna'oj anen chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Njelal jawra xenya' pona rbixic ch-utz c'ara' tak xtbantaja cawra nebij: —Njelal jawra ja c'awa' rbin cana Jesús chka. Majo'n xenbij ta chewa jawra ojer com q'uenc'o na ewq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Per camic com xquenba rmal c'ara' quenbij cana chewa. Camic quenmloja ruq'uin jtakyon pa wxin per next jun chewa ixix nc'axaj ta chwa: —¿Abar q'ue tzra' ncatba wa'? ");
INSERT INTO tzjE_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Per jebnon ixix nojnak bis ruq'uin ewanm rmal jxenbij chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Njelal jnemjon rbixic chewa ne ktzitzij wa'. Tak xtenel ela checjol c'ola utzlaj tak achnak nuc'om pa chewa. Perc che mquita quenba majo'n nkaj ta ewq'uin jun chic To'onel, per wquenba, anen quentkow ta rxin ewq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Tak xtkaj ta jun chic To'onel, bien nk'alsaj na chquewech wnak je ykula quec'u'x ruq'uin rwech ruch'lew chc'ola quil quemac quebnon. Com j-e' majo'n ykul ta quec'u'x wq'uin rmal c'ara' nuch'ob na chquewech che e aj-il e ajmac. Y jun chic samaj jnerebna' kaja, jara' nk'alsaj na bien chquewech wnak che anen ne rbeyal wa' nebnon chwech Ttixel com ja' Ttixel nuya' chwa chquenba tzra' abar c'ol wa' ja' y majo'n chic cnetz'et ta. Y c'o chna jun samaj nerebna' kaja To'onel, jara' bien nk'alsaj na chquewech wnak che Dios nuk'at na tzij chquij je e bnoy tak rtzilal com ja' rek'ton chic tzij tzrij diablo jnebnowa mandar wawe' chwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Anen c'o na je' achnak quenbij chewa per mesquier nch'obtaja ewmal xtenbij ta camic. ");
INSERT INTO tzjE_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tak xtpeta Espíritu Santo je nk'alsana ajni' ja' Dios jne ktzitzij wa' che Dios, ja' nc'ana ewxin y nk'alsaj bien chewech njelal nak kas mer rbanic Dios. Cara' xtuban com arja' mruyon ta nwankersaj nak xtbij, per nak nbixa tzra rmal Ttixel jara' nbij ja'. Y jun chic, nk'alsaj na chewech je' achnak jq'uemjana tbantaja. ");
INSERT INTO tzjE_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tak xtpeta Espíritu Santo jara' nuk'ij anen nerey-a' com arja' nuc'om pa nak c'ola nuk'a' tzra chnerk'alsaj chewech ixix. ");
INSERT INTO tzjE_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Njelal achnak jc'ola ruq'uin Ttixel c'ola nuk'a' anen tzra, rmal c'ara' tak xenbij chewa che Espíritu Santo arja' nuc'om pa njelal nak c'ola nuk'a' tzra y nerk'alsaj chewech ixix nak je rbanic. ");
INSERT INTO tzjE_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Xjurat chic quenc'je'a checjol y majo'n chic cnetz'et xta per mnim ta tiemp jmajo'n cnetz'et ta y cnetz'et na jmul chic. Cara' quenbij chewa com anen quenba ruq'uin Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","C'jara' je' rdiscípulo xquemaj je' tzij chbil tak qui' y cawra necbij je'a: —¿Nak nbij tzij c'awa' je nbij chka che: —Xjurat chic quenc'je'a checjol y majo'n cnetz'et chic per mnim ta tiemp jmajo'n cnetz'et ta y cnetz'et na jmul chic, catak ra' nbij? Y jun chic nbij: —Cara' quenbij chewa com anen quenba ruq'uin Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Nak nbij c'awa' tak nbij xjurat? Tak mesquier nch'obtaja kmal nak nbij. ");
INSERT INTO tzjE_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ja' Jesús rutkin chic che ncajo' necc'axaj tzra nak rbanic tzij je nbij y xuya' rbeyal chquewech: —¿Ljara' newc'axaj chbil tak ewi' jxenbij chewa che xjurat chic quenc'je'a checjol y majo'n cnetz'et chic per mnim ta tiemp y cnetz'et na jmul chic? ");
INSERT INTO tzjE_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ne ktzij wa' je xtenbij chewa, ixix nquixok' na nquixbison na per je wnak xruq'uin rwech ruch'lew ykul wa' quec'u'x arj-e' nquequicot na. Per mesque xquixbison na jara' bis chek q'uenjlal nq'uisa y nwanker na jun quicotemal rxin Dios ptak ewanm. ");
INSERT INTO tzjE_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Cara' ajni' nuban jun ixak tak q'uemjana tec'je'a jun ch'it ral, arja' nutaj na pen rmal ruquiy com xerla' hor rxin che nec'je'a ral. Per jte'ej tak c'ol chic ral jara' majo'n chic nerkaj ta ruquiy pe rwá' je xk'axa tzrij. Mterkaj chic pe rwá' rmal quicotemal jc'o chic pranm com c'ol chic jun ch'it ch'uch' xuya' chwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Cara' c'a chewa ixix chka' camic, emjon bis per nkatz'et chna jmul kawech ewq'uin y ajni'la xtquixquicota rmal, per jun quicotemal next jun xtelsana chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tak xterla' k'ij c'jara' majo'n chic je' achnak xtewc'axaj ta chwa. Ne ktzitzij wa' je xtenbij chewa, nak xtec'utuj tzra Ttixel, we pnubi' anen nec'utuj wa' y ykula ec'u'x wq'uin che rc'utxic, arja' nuya' chewa. ");
INSERT INTO tzjE_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ajni' ebnon ta, majo'n ec'utun ta chpam oración pnubi' anen, per camic quenbij chewa, tc'utuj y nyataja chewa, cara' ta xteban ch-utz c'ara' xtnoj ta quicotemal rxin Dios ptak ewanm. ");
INSERT INTO tzjE_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Njelal jawra jxenbij chewa c'ola je' c'ambal tzij xencsaj che rbixic jmajo'n xk'aljin ta chewech. Per nerla' na jun k'ij tak majo'n chic nc'atzin ta noktzijona chpam c'ambal tzij, c'jara' bien quenk'alsaj chewech nak rbanic Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tak xterla' k'ij, pnubi' anen nec'utuj wa' tzra Ttixel nak kas newajo'. Per majo'n quenbochij ta Ttixel chnuya' chewa nak nec'utuj tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Arja' nuya' chewa com nquixrajo' rmal c'ara' nak nec'utuj nuya' chewa. Cara' nuban chewa com ixix cnewajo' y nenimaj chruq'uin Dios enpenak wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ruq'uin Ttixel enelnak twa' je enpenak wawe' chwech ruch'lew y camic quenya' cana ruch'lew, quenmloja chic wjic ruq'uin Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Je' rdiscípulo cawra xecbij tzra: —Camic xekaja pkawá' nak xabij chka, jawra mjun c'ambal tzij ta. ");
INSERT INTO tzjE_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Camic ch'obtanak chic kmal chatet awutkin njelal achnak, majo'n rilaj nekc'axaj je' achnak chawa com atet awutkin chic nak nkajo' nekc'axaj tak q'uemjana tekbij, rmal c'ara' neknimaj chruq'uin Dios atpenak wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús cawra xbij chca: —¿Le ktzitzij nenimaj chruq'uin Dios enpenak wa'? ");
INSERT INTO tzjE_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Per nerla' na jun hor tak nuyon cneya' cana y jara' xyamer nerla' hor rxin che nbantaja. Jara' hor nech'or ewi', nquixnanmaja y nquixba ptak ewuchoch chixjujnel. Mesque cneya' cana, mnuyon ta quenc'je' cana com Ttixel arja' nc'ola wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Njelal jawra xenbij chewa pjun chak'a' ch-utz c'ara' nyataja chewa quicotemal rxin Dios tak xjun ebnon wq'uin. Chwech jawra ruch'lew congan pen xtetaj na, per quixquicota com rtzilal rxin rwech ruch'lew arja' majo'n cwennak ta chwij, nanen wa' ench'ecmanak, cara' xbij Jesús chca rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ja' Jesús tak xbitaja tzij rmal xca'ya chcaj y xumaj rij oración y cawra xbij tzra Ttixel: —Nedta', camic xerla' hor, tebna' c'a chwa jnak'alsbej chquewech wnak chcongan nim nuk'ij je en Rlec'walxel. Cara' tebna' chwa ch-utz c'ara' anen catnk'alsaj chquewech che atet chka' congan nim ak'ij. ");
INSERT INTO tzjE_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Com atet ay-on chwa chc'ola nuk'a' chca conjelal wnak. Cara' abnon chwa ch-utz c'ara' anen quenya' chca conjelal wnak je'ay-on chwa utzlaj c'aslemal rxin Dios je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Je utzlaj c'aslemal je rxin junlic cawra rbanic, je' wnak ncutkij ajni' ana'oj atet jxa ayon che at Dios, chka' ncutkij ajni' nna'oj anen jenatkon ta wawe' chwech ruch'lew. Tak cara' nqueban jara' cc'an chic utzlaj c'aslemal je rxin junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Anen ney-on ak'ij wawe' chwech ruch'lew, xenq'uis rbanic njelal asamaj jay-on chwa chquenban. ");
INSERT INTO tzjE_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Camic Nedta', tey-a' chwa chcara' nkaban awq'uin pnagloria ajni' kabnon nabey tak q'uemjana twankera ruch'lew, congan nim nuk'ij tzra'. Tey-a' chwa chquenba wjic chic awq'uin pnagloria abar nk'aljin wa' chcongan nim nuk'ij. ");
INSERT INTO tzjE_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nak xe'acha' chquecjol wnak wawe' chuch'lew je ay-on chwa, anen xenk'alsaj chquewech ajni' ana'oj atet. J-e' ne awxin wa' y camic xe'aya' c'a chwa y j-e' congan necnimaj atzojbal. ");
INSERT INTO tzjE_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Camic cutkin chic che njelal jxenban jay-on chwa chquenban jara' awq'uin atet penak wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Com anen nbin chic chca njelal jabin chwa. J-e' cniman chic je nbin chca y camic cutkin chic che awq'uin atet enpenak wa' y necnimaj che atet attakyon ta wxin. ");
INSERT INTO tzjE_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Camic nemjon oración pquecwent per me pquecwent ta je' wnak xruq'uin rwech ruch'lew ykul wa' quec'u'x. Anen quenban orar pquecwent je ay-on chwa com e awxin. ");
INSERT INTO tzjE_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Conjelal je wxin anen e awxin atet chka', conjelal e awxin atet e wxin anen chka'. Com xjun kabnon cuq'uin rmal c'ara' ruq'uin cc'aslemal ntz'ettaj wa' che ajni'la nim nuk'ij. ");
INSERT INTO tzjE_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Santlaj Ttixel, camic majo'n quenc'je' xta chwech ruch'lew per j-e' nquec'je' cana y anen quenmloj chic wjic awq'uin. Pnabi' atet que'achajij y que'awaraj je ay-on chwa ch-utz c'ara' xjun ta xtqueban ajni' kabnon ajoj awq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Anen tak xenc'je'a cuq'uin wawe' chwech ruch'lew, pnabi' atet xenuban wa' cwent, next jun xtz'ila' ta ri' chca. Per c'ola jun xtz'ila' ri' per jara' nyatanak tzrij chnutaj pen chpam nimlaj juicio. Cara' xuban ch-utz c'ara' nbantaja cumplir jtz'iban cana ojer chpam atzojbal. ");
INSERT INTO tzjE_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Per camic anen quenmloja awq'uin y njelal jawra jnemjon rbixic chawa ne chquewech j-e' quenbij cwa' wawe' chwech ruch'lew ch-utz c'ara' xtnoj ta quicotemal ptak canm jc'ola wq'uin anen. ");
INSERT INTO tzjE_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Anen bien xenk'alsaj atzojbal chquewech jabin chwa y camic xitzel nquetz'e'ta cmal wnak je xruq'uin rwech ruch'lew ykul wa' quec'u'x com j-e' mruq'uin ta rwech ruch'lew ykul wa' quec'u'x, ajni' nebnon anen, mruq'uin ta rwech ruch'lew ykul wa' nuc'u'x. ");
INSERT INTO tzjE_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mjara' ta quenc'utuj chawa che nque'alsaj ela wawe' chwech ruch'lew y xqueba ta awq'uin camic. Jquenwajo' anen chawa che nque'aban cwent wawe' chwech ruch'lew ch-utz c'ara' majo'n nquech'a'c ta rmal diablo. ");
INSERT INTO tzjE_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","J-e' mruq'uin ta rwech ruch'lew ykul wa' quec'u'x, ajni' nebnon anen, mruq'uin ta rwech ruch'lew ykul wa' nuc'u'x. ");
INSERT INTO tzjE_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Camic que'ayonaj c'a, tech'ja' c'a canm tzan atzojbal, com ruq'uin atzojbal atet nkatz'et wa' nak kas mer abanic che ktzitzij at Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ajni' xaban chwa anen xenatak ta wawe' chwech ruch'lew cara' c'a quenban anen chca chka', enchumsan chic che quenutak ela chwech ruch'lew chnequebna' asamaj. ");
INSERT INTO tzjE_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Camic anen quenyonaj wi' che rbanic je nrajo' awanm atet. Cmal j-e' tak cawra quenban ch-utz c'ara' j-e' chka' nqueyonaxa che rbanic je nrajo' awanm atet je at ktzitzij Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Per mqueyon ta j-e' nemjon rbanic oración pquecwent com j-e' nqueya' na nbixic chca jle' chic wnak y rmal jara' tak xtqueya' nbixic ec'o chna jle' jneyke'a na quec'u'x wq'uin, y camic quenban orar pquecwent arj-e' chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Quenban orar pquecwent ch-utz c'ara' xjun ta xtqueban conjelal je' wnak jneyke'a quec'u'x wq'uin ajni' kabnon awq'uin atet Nedta', com atet xjun abnon wq'uin y xjun nebnon awq'uin atet chka'. Kas quenwajo' anen kas xtjun xtqueban kuq'uin conjelal ch-utz c'ara' je' wnak xruq'uin rwech ruch'lew ykul wa' quec'u'x arj-e' xtecnimaj ta chatet attakyon ta wxin. ");
INSERT INTO tzjE_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ajni' abnon chwa anen chk'alaj che atet atc'ayona nc'aslemal y cara' nebnon anen chka', ney-on chca chk'alaj chatet atc'ayona cc'aslemal. Cara' nebnon chca ch-utz c'ara' xjun ta xtqueban ajni' kabnon awq'uin xjun kabnon. ");
INSERT INTO tzjE_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Cawra nela, anen xjun quenban cuq'uin j-e' y atet xjun naban wq'uin ch-utz c'ara' xjun ta xtbequebna' rq'uisbal k'ij. Cara' quenwajo' ch-utz c'ara' je' wnak xruq'uin rwech ruch'lew ykul wa' quec'u'x arj-e' xtcutkij ta che atet attakyon pa wxin y xtcutkij ta chka' che atet congan nque'awajo' je' wnak xjun quebnon wq'uin ajni' abnon chwa anen chcongan cnawajo'. ");
INSERT INTO tzjE_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Nedta', je' wnak je'ay-on chwa kas quenwajo' quenc'utuj chawa, abar xtenq'ue' wa' anen, tzra' ta xtec'je' wa' j-e' chka'. Cara' quenwajo' chca ch-utz c'ara' nquecwina nquetz'et nimlaj agloria jay-on chwa, com atet enawaj-on ta tak q'uemjana twankersasa ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nedta', awq'uin atet c'o wa' rbeyal per je' wnak xruq'uin rwech ruch'lew ykul wa' quec'u'x majo'n cutkin ta ajni' ana'oj, per anen wutkin y chka' conjelal wnak jec'ola wq'uin je ay-on chwa j-e' cutkin che atet attakyon pa wxin. ");
INSERT INTO tzjE_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Anen nk'alsan chic chquewech ajni' ana'oj y quenk'alsaj na más chquewech. Cara' xtenban chca ch-utz c'ara' nec'je'a ptak canm jara' ojben ri'il jquenawojbej, ch-utz c'ara' chka' quenc'je'a anen ptak canm. Cara' xbij Jesús tzra Ttixel. ");
INSERT INTO tzjE_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tak xec'choja oración rmal Jesús c'jara' xba xerexbilaj ela rdiscípulo y xek'axa pjupraj jun siwan rbin-an Cedrón. Tzra' xe'oc wa' chpam jun lwar abar tcon wa' nic'aj che'. ");
INSERT INTO tzjE_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ja' Jesús ruq'uin je' rdiscípulo arj-e' q'uiylaj mul quemlon qui' tzra', rmal ra' ja' Judas bien rutkin jara' lwar. Jara' Judas je rchumsan chic chnujach Jesús pquek'a' wnak je nquetzelana rxin. ");
INSERT INTO tzjE_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas xberec'ma' jle' soldado e quexbil nic'aj policía je nquesmaja pquecwent aj fariseo y pquecwent cjefe sacerdote chka'. Tak xec'amtaja rmal xuc'om ela quebey, xeba chpam lwar abar ec'o wa' Jesús ruq'uin je' rdiscípulo. Xquec'om ela quek'ak' jnectz'etbej quebey y c'ola je' achnak rxin je' banbal tak ch'oj xquec'om ela. ");
INSERT INTO tzjE_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tak xe'ekaja xel ta Jesús che c'luy cxin com arja' rutkin chic njelal jq'uemjana tba'na tzra, y cawra xbij chca: —¿Nak necanoj? ");
INSERT INTO tzjE_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesús aj Nazaret nekcanoj, cara' xecbij. —Anen c'ara', xbij Jesús. Chquecjol wnak bnak Judas jnejchowa rxin Jesús pquek'a'. ");
INSERT INTO tzjE_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tak xbij Jesús chanen, j-e' wnak congan xemloja chquij y xeba ptak ulew. ");
INSERT INTO tzjE_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Y Jesús xc'axaj wjic chic chca: —¿Nak necanoj? —Jesús aj Nazaret nekcanoj, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Nbin chic chewa chanen. Per wanen cnecanoj tey-a' c'as chca wexbil che nqueba. ");
INSERT INTO tzjE_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Cara' xbij chca ch-utz c'ara' nbantaja cumplir je xbij tzra Ttixel jcawrara: —Je e'ay-on chwa majo'n jun xtz'ila' ta ri'. ");
INSERT INTO tzjE_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedro rc'an jun espada, xelsaj jara' espada y xch'upuj ela rexquin jun acha prejquenk'a'. Jara' acha Malco rubi', mos rxin nimlaj sacerdote. ");
INSERT INTO tzjE_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Per Jesús cawra xbij tzra Pedro: —Tec'lo' awespada y tecsaj pe rc'olibal com c'ola jun lowlo' rchumin Nedta' y nc'atzina chquenk'axa chpam. ");
INSERT INTO tzjE_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","C'jara' xcha'pa Jesús cmal soldado y ccapitán y cmal je' policía. Tak xchaptaja cmal xquexim. ");
INSERT INTO tzjE_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tak ximtaja cmal xquec'om ela y chwech Anás xecc'aj wa' nabey mul, je rjinam Caifás. Chpam jara' juna' Caifás ocnak nimlaj sacerdote. ");
INSERT INTO tzjE_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jara' mism Caifás jbiyona chca aj Israel jcawrara: —Más na k'axnak wen nok-ela xjun ncoma pkec'xiwach ok aj Israel que chwech nq'uisa ketnamet. ");
INSERT INTO tzjE_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro ruq'uin jun chic discípulo arj-e' xectrebej ela Jesús. Jun chic discípulo arja' ojtkin chic rwech rmal nimlaj sacerdote, tak xoca Jesús ruq'uin nimlaj sacerdote xoca arja' chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro arja' xec'je' cana, majo'n xoc ta. Jdiscípulo jotkin rwech rmal nimlaj sacerdote arja' xemloj ta abar ocnak el wa' y tzra' c'o wa' jun xtan jnechjalbena chibey abar ncatoc wa'. Ja' discípulo xbij tzra xtan chnecsaj ta Pedro, y xoca Pedro. ");
INSERT INTO tzjE_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tak ocnak chic Pedro cawra xbixa tzra rmal xtan: —¿Mex c'a atet chka' at jun discípulo rxin acha rbin-an Jesús? —Majo'n, manen ta, cara' xbij Pedro. ");
INSERT INTO tzjE_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ec'ola jle' mos je nquechajina rxin Jesús, c'ola jle' k'ak' quebxon, quemjon rmak'ic qui' com congan tew. Y ja' Pedro pa'l oca cuq'uin chuchi' k'ak', remjon rmak'ic ri'. ");
INSERT INTO tzjE_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ja' nimlaj sacerdote xumaj rc'otic ruchi' Jesús, cawra xc'axaj je' tzra: —¿E achnak adiscípulo y nak rbanic tijonem jnac'ut? ");
INSERT INTO tzjE_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús cawra xbij: —Per tak xenya' je' tijonem me pnalak' ta xenya' wa' per ne chquewech je' wnak xentzijon wa'. Xentijoj ptak jay abar nba'n wa' mlon ri'il, xentijoj chpam nimlaj rtemplo Dios com tzra' nquemol wa' qui' aj Israel y majo'n achnak pnalak' ta xenbij wa' chca. ");
INSERT INTO tzjE_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Nak tzra tak chwa anen nawc'axaj wa' nak rbanic? Com je' wnak jxentijoj, arj-e' bien cutkin jtijonem xenya' chca, jnaban camic, chca j-e' tewc'axaj wa' nak rbanic tijonem jxenya'. ");
INSERT INTO tzjE_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tak xbitaja jawra tzij rmal Jesús c'o jun soldado xuya' jpak' k'a' chuplaj Jesús y cawra xbij tzra: —¿Lrubey c'ala' naban chek cala' naban nac'ulba'? ¿Mtatzu' c'a nimlaj sacerdote ntzijona awq'uin? ");
INSERT INTO tzjE_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús cawra xbij tzra: —We mrubey ta y we m-utz ta xenbij, tbij c'a chwa nak m-utz ta xenbij. Wrubey xenbij ¿nak q'ue tzra xnach'ey? ");
INSERT INTO tzjE_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","C'jara' Anás xutak el chic Jesús chwech Caifás jnimlaj sacerdote, y ne bc'on tak xc'axa Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ja' Simón Pedro pa'l oca chi' k'ak', remjon rmak'ic ri' tak cawra xc'axaxa tzra: —¿Mex c'a atet at jun rdiscípulo Jesús chka'? Ja' Pedro majo'n xuya' ta tzrij: —Manen ta, cara' xbij. ");
INSERT INTO tzjE_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","C'ola jun rmos nimlaj sacerdote je rch'alal acha je xkupix ela rexquin rmal Pedro, arja' cawra xc'axaj tzra: —Ajni' tak xatnutz'et chpam lwar abar xchaptaj wa' Jesús. ¿Mawexbil tc'ara'? cara' xbij tzra Pedro. ");
INSERT INTO tzjE_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Per ja' Pedro mxuya' ta tzrij, y chek q'uenjlal xtrekena jun pre'y. ");
INSERT INTO tzjE_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","C'jara' xquec'om el chic Jesús, xe'el ela ruq'uin Caifás, xeba chic abar c'o wa' ruchoch gobernador, chek xeskara xeba. Tak xe'ekaja majo'n xe'oc ta alnak pjay com c'ola jun ccostumbre j-e' aj Israel, xjan nque'oca pjay ruq'uin jun wnak jme aj Israel ta, y chka' cniman tak xatoca pjay ruq'uin jun wnak jme aj Israel ta xjan nataj chic je' achnak je nquetaj aj Israel chpam nimk'ij pascua. ");
INSERT INTO tzjE_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Xel ta gobernador Pilato y cawra xbij chca: —Jala' acha ec'mon ta ¿c'ola ril nebij? ");
INSERT INTO tzjE_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Che mquita itzel acha mquita nerkajcha' pnak'a'. ");
INSERT INTO tzjE_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","—Utz tec'ma' ela ixix com c'ola eley, jara' tecsaj jnek'atbej tzij tzrij, cara' xbij Pilato. —Per ch'oj rij xajoj xtkok'towa tzij tzrij jun acha che nekcamsaj, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tak xecbij me j-e' ta nquek'towa tzij tzrij Jesús che neccamsaj, tzra' xbantaj wa' cumplir je rbin cana Jesús nak xtba'na tzra tak xtcamsasa. ");
INSERT INTO tzjE_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","C'jara' xoca Pilato pruchoch, xutak rsic'sic Jesús y cawra xc'axaj tzra: —¿Atet at rey cxin tnamet Israel? ");
INSERT INTO tzjE_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús xbij tzra: —¿Lnach'ob atet en rey cxin tak rmal ra' nawc'axaj chwa, o xe rmal bin chawa cmal jle' chic wnak? ");
INSERT INTO tzjE_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—¿En aj Israel c'a anen tak cara' nabij chwa? Je' cjefe sacerdote e quexbil jle' chic aj Israel atquejchon pnuk'a' camic. ¿Nak c'a awil abnon? cara' nbij ja' Pilato tzra Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús cawra xbij tzra: —Anen c'ola jun gobierno pnuk'a' per jara' me rxin ta rwech ruch'lew. Per wext rxin ruch'lew nqueyictaj tc'ara' conjelal ajsmajma' jec'ola wq'uin ch-utz c'ara' majo'n quenja'ch ta pquek'a' aj Israel. Per ngobierno me rxin ta rwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—¿Le ktzitzij che at rey? —En Rey nc'a ajni' xabij kaja, rmal c'ara' tak xenalexa y enpenak wawe' chuch'lew, enpenak che rk'alsic chquewech wnak nak kas mer rubey Dios, conjelal wnak jc'ola cgan tzrij rubey Dios j-e' c'ara' nqueya' quexquin che rc'axic nak quenchol anen, cara' xbij Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—¿Nak rbanic rubey Dios? xc'axaj Pilato. Tak xc'axtaja rmal xel pchic y cawra xbij chca aj Israel: —Jquentz'et anen majo'n ril Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Per ixix c'mannak chewa chc'ola jun preso nsak'pix ela pnimk'ij pascua. Camic tbij chwa ¿c'ola egan che neksak'pij ela erey ix aj Israel? ");
INSERT INTO tzjE_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","J-e' xquemaj rakic quechi', cawra xecbij: —Utz Barrabás nsak'pix ela, majo'n nkajo' ta nsak'pixa Jesús. Barrabás arja' jun elk'om. ");
INSERT INTO tzjE_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato xuc'om ela Jesús y xuya' orden che nch'aya. ");
INSERT INTO tzjE_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Je' soldado c'ola jun corona cchumsan, q'uix quecsan. Tak xchumtaja cmal xqueya' pe rwá' Jesús y xquecsaj jun tziak mrad tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","C'jara' nqueya' rsaludo Jesús per xyok'bal rxin nqueban. —Atet at Rey cxin aj Israel, cara' necbij tzra, y nqueya' k'a' chuplaj. ");
INSERT INTO tzjE_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Xel pchic Pilato pk'atbaltzij y cawra xbij chca aj Israel: —Tetz'ta' mpa', camic quenpaba' chewech Jesús ch-utz c'a newutkij che anen majo'n ril xenwil ta. ");
INSERT INTO tzjE_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","C'jara' xel ta Jesús, mrad tziak recsan y jun q'uixlaj corona y-on pe rwá'. —Tetz'ta' mpa' jala' acha, xbij Pilato. ");
INSERT INTO tzjE_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Je' cjefe sacerdote e quexbil je' policía, tak xquetz'et Jesús xquemaj rkoj chi'ij: —Tcamsaj chwech cruz, tcamsaj chwech cruz. —Per quentz'et anen majo'n ril, mejor tcamsaj ixix. Ixix c'ara' quixerpowa rxin chwech cruz, xbij Pilato. ");
INSERT INTO tzjE_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","—Ajoj c'ola jun ley kxin, jara' ley nbina che yatanak tzrij jala' acha che ncamsasa com ja' nbij che Rlec'wal Dios, cara' xecbij tzra Pilato. ");
INSERT INTO tzjE_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ja' Pilato tak xc'axaj chcara' rbin Jesús más congan xxibej ri'. ");
INSERT INTO tzjE_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Xoc chic wjic pjay y cawra xc'axaj tzra Jesús: —¿Abar c'a kas atpenak wa'? Per Jesús majo'n xc'ulba' ta. ");
INSERT INTO tzjE_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","—¿Nak tzra tak majo'n cnac'ulba' ta? ¿Mawutkin tc'a xe pnuk'a' atc'o wa' che catnsak'pij ela, o catnujach che ncatri'pa chwech cruz? ");
INSERT INTO tzjE_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—Che mquita yatanak chawa rmal Dios jc'ola chcaj majo'n ta ak'a' chwa. Rmal c'ara' quenbij chawa, más chna nim ril acha jxejchowa wxin pnak'a'. ");
INSERT INTO tzjE_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato tak xc'axaj je xbixa tzra xutaj ruk'ij che nsak'pij ela Jesús per aj Israel xquemaj rakic quechi' y cawra necbij: —Atet wnasak'pij ela jala acha mat ramigo ta nimlaj rey César, com jala' acha xecsaj ri' rey y nak wnak necsaj kaja ri' rey ruyon kaja arja' rec'lel César. ");
INSERT INTO tzjE_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tak xc'axaj Pilato je nbixa tzra xerc'ma' pa Jesús. C'jara' xetz'be'a chpam jun lwar abar nuk'at wa' tzij tzrij jun wnak chc'ola ril o majo'n, jara' lwar nbixa tzra Lwar Empedrado, pnhebreo nbij tzij Gabata. ");
INSERT INTO tzjE_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pjun bispr rxin nimk'ij pascua xbantaj wa', pe nc'ajk'ij lara' xbantaja. Pilato xtzijon chic jmul cuq'uin aj Israel y cawra xbij chca: —Tetz'ta' mpa', wawe' c'ol wa' erey. ");
INSERT INTO tzjE_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","—Tcamsaj, tcamsaj chwech cruz, cara' xecbij j-e' wnak. Pilato cawra xbij: —¿C'ola egan quenrip erey chwech cruz? Je' cjefe sacerdote cawra xecbij: —Majo'n chic jun rey c'ol ta ruk'a' chka, xruyon César. ");
INSERT INTO tzjE_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","C'jara' xja'cha Jesús pquek'a' rmal Pilato che ncamsasa chwech cruz, y xquec'om ela. ");
INSERT INTO tzjE_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Cara' xuban Jesús, xtelej ela jun cruz y xba pjun lwar rubi' Rwá' Comnak. Chpam tzojbal hebreo nbixa tzra Gólgota. ");
INSERT INTO tzjE_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tak xe'ekaja chpam jara' lwar, tzra' xquerip wa' Jesús chwech cruz, y ec'ola e c-e' ach-i' chka' xeri'pa, e jujun ptak rexquin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato c'o nic'aj letr xuban y cawra nbij: —Jesús aj Nazaret, rey rxin tnamet Israel, y xuya' pe rwá' cruz. ");
INSERT INTO tzjE_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","E q'uiy je' aj Israel xecsiq'uij jawra letr com abar xri'p wa' Jesús xchenkaj tnamet. Jawra letr oxi' rwech tzojbal xtz'ibax wa', jun pnhebreo, jun pe griego y jun platín. ");
INSERT INTO tzjE_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","J-e' cjefe sacerdote cawra xecbij tzra Pilato: —Ajoj majo'n nkajo' ta tzij jala' jxatz'ibaj chrey kxin ok tnamet Israel. Nkajo' ttz'ibaj ajni' nbij ja': —En rey rxin tnamet Israel. ");
INSERT INTO tzjE_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Nak xentz'ibaj, xentz'ibaj wc'ara', xbij Pilato. ");
INSERT INTO tzjE_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Je cji' soldado tak querpon chic Jesús chwech cruz xquec'om rtziak, xquejach chquewech, jujun xpona chquewech. Y c'o jun jmajo'n dson ta, xjun rquemic bnon. ");
INSERT INTO tzjE_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Rmal c'ara' j-e' soldado cawra xecbij: —Me tkarak ta jawra tziak, kabna' suert tzrij nak kas tech'cowa chka. Cara' xqueban y tzra' xbantaj wa' cumplir jtz'ibtanak cana ojer chpam rtzojbal Dios jcawra nbij: —Xquejach netziak chquewech y c'ola jun xqueban suert tzrij. Y ncara' xqueban soldado. ");
INSERT INTO tzjE_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Rute' Jesús rexbil jun ruchak' ec'ola chenkaj ruq'uin cruz e rexbil e c-e' chic ixki', jun María rexkayil Cleofas, y jun chic María Magdalena rubi'. ");
INSERT INTO tzjE_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús xutz'et pona rute' ruq'uin rdiscípulo jcongan nrajo' y cawra xbij tzra rute': —Jala' jun ndiscípulo jala' noc chic awal. ");
INSERT INTO tzjE_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Y cawra xbij tzra rdiscípulo: —Nute' noc chic ate' atet, cara' xbij. Tak xemloja discípulo xuc'om ela rute' Jesús pruchoch junlic. ");
INSERT INTO tzjE_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ja' Jesús rutkin chic che c'chonak chic njelal samaj rmal je bin tzra chnuban y xbij: —Xechkija nuchi'. Tak xbij jawra tzij, tzra' xbantaj wa' cumplir jtz'iban cana chpam rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tzra' c'ol wa' nic'aj vinagre, j-e' soldado xquec'om jun esponja, xquexim chutza'm jun che' y xecmuba' chpam vinagre, c'jara' xqueya' pona pruchi' Jesús chnutaj. ");
INSERT INTO tzjE_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tak xtitaja rmal cawra xbij: —Camic xentz'katsaj njelal samaj je y-on chwa rmal Nedta'. C'jara' xuk'och rwá' y xujach ranm tzra Dios y xcoma. ");
INSERT INTO tzjE_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Com jara' bispr rxin nimk'ij pascua rmal c'ara' j-e' aj Israel xecc'utuj tzra Pilato che nk'i'pa ckan jerpon chwech cruz ch-utz c'ara' nquecoma chanim y nquelsax ela. Cara' nqueban ch-utz c'ara' jquecuerpo majo'n nec'je' ta chwech cruz chpam xlanbal k'ij com jawra k'ij más nim ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","C'jara' xe'ekaja je' soldado e k'poy ckan ach-i' jec'ola prupox Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Per tak xquetzu' Jesús comnak chic, majo'n xquek'ip ta rkan. ");
INSERT INTO tzjE_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Per c'ola jun soldado xumin jun lanza prupox y c'ola quic' xel ta ruq'uin ya'. ");
INSERT INTO tzjE_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jawra je xbantaja xentzu' ruq'uin nk'anwech y jara' ney-on chic rbixic y wutkin che ktzitzij, y camic quenbij chic chewa ch-utz c'ara' nenimaj ixix chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Cara' xbantaja che nba'na cumplir rtzojbal Dios jtz'ibtanak cana ojer tzrij ja' Cristo jcawra nbij: —Majo'n rbakil xtk'i'p ta. ");
INSERT INTO tzjE_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Y jun chic cawra nbij: —J-e' nquetz'et na rwech acha je xpitz'a jun ch'ech' prupox. ");
INSERT INTO tzjE_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","C'ol c'a jun acha José rubi', penak chpam tnamet Arimatea, arja' jun discípulo rxin Jesús, xba ruq'uin Pilato c'utuy recuerpo Jesús. Per xe pnalak' xba wa' com ja' nxibej ri' chquewech aj Israel. Tak xekaja ruq'uin Pilato xc'utuj recuerpo Jesús y xya'a tzra. Y cara' xuban xuc'om ela. ");
INSERT INTO tzjE_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Xekaja Nicodemo chka', jara' je xtzijona ruq'uin Jesús chak'a'. Arja' rec'mon ta jun quintal mirra reyjun ruq'uin áloes, y kas qui' rexla'. ");
INSERT INTO tzjE_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ja' Nicodemo ruq'uin José xquec'om ela mirra ruq'uin áloes, xqueya' tzrij rtziak Jesús y xquebar recuerpo Jesús chpam. Y ncara' ccostumbre aj Israel tak ncoma jun cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Abar xri'p wa' Jesús chwech cruz tzra' tcon wa' jle' tejco'n. Y chka' c'ola jun panteón rxin comnak chpam jara' lwar. Jara' panteón c'ton oca chpam jun nimlaj abaj y ne c'c'ac', next jun mkun chpam. ");
INSERT INTO tzjE_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Com xchenkaj c'ol wa' jara' panteón rmal c'ara' xqueya' cana recuerpo Jesús chpam. Cara' xqueban com xyamer nerla' hor rxin nimk'ij pascua. ");
INSERT INTO tzjE_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Rxin domingo xinak'a' xba María Magdalena abar mkun wa' Jesús, k'ejku'm na tak xekaja. Tak xutz'et jnimlaj abaj je tz'apben ruchi' panteón jwer y-on pon chwa'. ");
INSERT INTO tzjE_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Xemloj ta alnak y xba abar c'ol wa' Simón Pedro ruq'uin jdiscípulo jcongan njo'xa rmal Jesús. Tak xekaja cawra xbij: —Kajaw Jesús majo'n chic chpam panteón, xec'mar ela y abar le tzra' y-on wa'. ");
INSERT INTO tzjE_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro ruq'uin rexbil xeba abar c'ol wa' panteón. ");
INSERT INTO tzjE_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Concrer xeba che c-e' per jun más xutaj ruk'ij chwech Pedro rmal c'ara' xekaja nabey mul abar c'ol wa' panteón. ");
INSERT INTO tzjE_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tak xekaja xca'y oca, xutz'et xruyon rtziak Jesús c'o cana per mxoc ta chpam panteón. ");
INSERT INTO tzjE_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simón Pedro tren cana per tak xerkaja xoc ela junlic chpam panteón, arja' xutz'et utzlaj tziak rxin comnak chpam panteón xruyon c'o cana. ");
INSERT INTO tzjE_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Chka' xutz'et je tziak jbarben ruplaj jwer c'o chwa', rebton ri' ruyon. ");
INSERT INTO tzjE_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ejkal xoc chic jun discípulo chpam panteón je xpona nabey mul, tak xutz'et tziak arja' xnimaj che xc'astaja Jesús chquecjol cnomki'. ");
INSERT INTO tzjE_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Com j-e' nabey mesquier nch'obtaja cmal jtz'ibtanak cana chpam rtzojbal Dios che nc'atzina nc'astaja Cristo chquecjol cnomki'. ");
INSERT INTO tzjE_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","C'jara' xemloja discípulo pcuchoch. ");
INSERT INTO tzjE_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María pa'l cana chuchi' panteón, remjon ok'ej, chek q'uenjlal xca'y oca chpam panteón. ");
INSERT INTO tzjE_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Xerutz'et e c-e' ángel chpam, congan sak quetziak, jun tz'bula abar xq'ue' wa' rwá' Jesús y jun chic pe rkan. ");
INSERT INTO tzjE_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Cawra xecbij tzra María. —Ixak ¿nak tzra tak ncatok'a? —Xec'mar ela Wajaw y majo'n wutkin ta abar xbeya' wa', cara' xbij María. ");
INSERT INTO tzjE_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tak xbitaja tzij rmal xuya' volt y xutz'et Jesús pa'l chwech per majo'n xrutkij ta chJesús. ");
INSERT INTO tzjE_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús cawra xbij tzra: —Ixak ¿nak tzra tak ncatok'a y nak nacanoj? Xuch'ob ja' María jun tcol tejco'n ntzijona ruq'uin y cawra xbij tzra: —Watet xatec'mow ela rxin tbij c'a chwa abar tzra' xaya' wa' y anen quenc'om ela. ");
INSERT INTO tzjE_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús cawra xbij tzra: —María. Ja' María xba ruq'uin y cawra xbij tzra: —Raboni. Jawra tzij hebreo y nbij Maestro. ");
INSERT INTO tzjE_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús cawra xbij tzra: —Me cnachap ta, cnasak'pij com q'uemja'na quenjte'a ruq'uin Nedta'. Per jnaban camic jat cuq'uin wch'alal, abij chca chquenjte'a ruq'uin Nedta', y Edta' ixix chka'. Jara' Dios wxin anen y ewxin ixix chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","C'jara' xba María Magdalena y xerbij chca discípulo: —Anen xentz'et rwech Kajaw Jesús, cara' xbij, y xbij njelal je xcho'la tzra rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jara' k'ij domingo. Com je' discípulo necxibej qui' chquewech aj Israel rmal ra' tak quemlon qui' pjay y quetz'apin quechi'. Tak xoca ak'a' xekaja Jesús cuq'uin, xpe'a chquecjol y cawra xbij chca: —Qui'il tec'je'a ewanm chwech Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tak xbitaja tzij rmal, c'jara' xuc'ut chquewech pruk'a' ruq'uin prupox. Congan xequicota j-e' rdiscípulo tak xquetz'et che ktzij wa' ja' Kajaw Jesús c'ola cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús xbij chic jmul: —Qui'il tec'je'a ewanm chwech Dios. Nedta' xenrutak ta wawe' chwech ruch'lew y cara' c'a quenban chewa ixix chka', quixnutak ela chnebna' nsamaj. ");
INSERT INTO tzjE_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tak xbitaja tzij rmal, c'jara' xerxupuj y cawra xbij chca: —Camic tec'lu' c'a Espíritu Santo. ");
INSERT INTO tzjE_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Wnebij tzra jun wnak ncuytaja ril rumac ncuytaj c'ara', o wnebij majo'n ncuytaj ta majo'n c'ara' ncuytaj ta. ");
INSERT INTO tzjE_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Per c'o jun chca e cbeljuj apóstol rubi' Tomás, yu'x nbixa tzra, arja' majo'n tak xekaja Jesús cuq'uin jle' chic discípulo. ");
INSERT INTO tzjE_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tak xekaja Tomás xbixa tzra cmal jle' chic: —Xkatz'et rwech Kajaw Jesús. Per Tomás xbij: —Jara' majo'n quennimaj ta che xc'astaja. Wxtentz'et rpam ruk'a' je tk'ala rmal claws y xtenmin rwá'nuk'a' chpam y xtencsaj nuk'a' prupox abar tk'al wa' chka', c'jara' xtennimaj. ");
INSERT INTO tzjE_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jun domingo chic quemlon chic qui' je' discípulo chpam jay, jun ja' Tomás. Tz'pala chijay per chek q'uenjlal xekaja Jesús, xpe'a chquecjol y cawra xbij: —Qui'il tec'je'a ewanm chwech Dios. ");
INSERT INTO tzjE_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","C'jara' xbij tzra Tomás: —Tetz'ta' mpa' pnuk'a' y temna' rwá'ak'a' abar tk'al wa'. Chka' temna' ak'a' pnupox. Atet majo'n xnanimaj ta che xenc'astaja per camic teyke' c'a ac'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","—Atet at Wajaw, atet at neDios, cara' xbij Tomás. ");
INSERT INTO tzjE_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús xbij: —Tomás, atet cnatz'et camic rmal c'ara' cnanimaj, per más na nim quek'ij jmajo'n nwech quetz'ton ta y xeyke'a quec'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús q'uiy je' milagro xuban chquewech rdiscípulo je xk'alsbej ri' per jara' majo'n xentz'ibaj ta chpam jawra libro. ");
INSERT INTO tzjE_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Per jxentz'ibaj chpam jawra libro ch-utz c'ara' nenimaj ja' Jesús che arja' Cristo, Rlec'wal Dios, y tak nenimaj nyataja chewa utzlaj c'aslemal je rxin junlic, com jara' nyataja chka tak xjun kabnon ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tak xbantaja njelal jawra c'jara' xuc'ut chic ri' Jesús chquewech rdiscípulo tak ec'ola chuchi' mar Tiberias, y cawra xuban. ");
INSERT INTO tzjE_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ec'ol c'a jle' rdiscípulo quemlon qui' y j-ewra: Simón Pedro, Tomás yu'x nbixa tzra, Natanael aj Caná jc'ola precwent Galilea, je rc'ajol Zebedeo, y ec'o chna e c-e' rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro cawra xbij chca: —Anen quenba pe chpoj ch'u'. —Nokba ajoj chawij chka'. Cara' xqueban xeba, xe'oc ela chpam lanch per jara' ak'a' majo'n ch'u' xquechap. ");
INSERT INTO tzjE_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tak xpeta rsakric pa'la Jesús chiya' abar ec'ol wa' rdiscípulo. Per j-e' majo'n cutkin ta che Jesús pa'l tzra'. ");
INSERT INTO tzjE_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús cawra xbij chca: —Wlec'wal ¿me c'o ta ch'u' echpon che nquekataj? —Majo'n achnak xkachap, cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Camic pnewejquenk'a' tch'akij wa' ec'am, ec'ola ch'u' nque'echap. Cara' xqueban y e q'uiy ch'u' xequechap, y nmesquier chic nel ta cmal pya'. ");
INSERT INTO tzjE_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tzra' c'ol wa' jdiscípulo jcongan njo'xa rmal Jesús. Arja' xbij tzra Pedro: —Jala' Kajaw Jesús. Ja' Simón Pedro tak xc'axaj chcara' xcosla' ta rtziak y xel ta alnak pya'. ");
INSERT INTO tzjE_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Per jle' chic discípulo planch xexle' pwa', ccherren pa c'am, enojnak ch'u' chpam. Xjun cient metro quey-on cana chiya'. ");
INSERT INTO tzjE_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tak xekaj ta chiya' xquetz'et rchak k'ak' s-on chic jun ch'u' pe rwá' y c'ola jle' xquelway chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús cawra xbij: —Que'ec'ma' ta jle' ch'u' je c'ja' xe'echpa' ta. ");
INSERT INTO tzjE_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","C'jara' xba Simón Pedro, xoca chpam lanch, xerelsaj ta c'am pya', enojnak nmak tak ch'u' chpam y ec'ola jun cient ruq'uin cincuentitres ch'u' chpam. E congan e q'uiy ch'u' per majo'n xraktaj ta quec'am. ");
INSERT INTO tzjE_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús cawra xbij chca. —Quixjo' quixwa'a. Conjelal discípulo necxibej qui' necc'axaj tzra: —¿At achnak wnak c'a atet? Cutkin c'a chja' Kajaw Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Xpeta Jesús tzra', xuc'om jun xquelway, xuya' chca, y cara' xuban chca ch'u' chka'. ");
INSERT INTO tzjE_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Cawra c'a xuban Jesús tak xc'astaja chquecjol cnomki', rox mul jawra tak xuc'ut ri' chquewech rdiscípulo. ");
INSERT INTO tzjE_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tak xec'choja w-im cmal xc'axaxa tzra Simón Pedro rmal Jesús: —Simón, at rlec'wal Jonás ¿le ktzitzij cnawajo' congan que chquewech nic'aj chic awexbil? —Cara' Wajaw, atet awutkin chcatnwajo', cara' xbij Pedro. —Que'atzku' c'a je' ch'tak carne'l je ykul quec'u'x wq'uin. ");
INSERT INTO tzjE_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","C'jara' Jesús xc'axaj chic tzra: —Simón, rlec'wal Jonás ¿le cnawajo'? —Cara' Wajaw, atet awutkin chcatnwajo', xbij chic jmul Pedro. —Que'ayuk'uj c'a ncarne'l. ");
INSERT INTO tzjE_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Xc'axax chic jmul tzra Pedro, jawra rox mul: —Simón, at rlec'wal Jonás ¿le cnawajo'? Ja' Pedro xumaj bis rmal je xc'axaxa oxmul tzra wcongan nrajo' Jesús. —Wajaw, atet majo'n nak mquita awutkin, awutkin chcatnwajo', xbij Pedro. —Que'atzku' c'a ncarne'l. ");
INSERT INTO tzjE_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Cawra xbij chic jmul tzra: —Ne ktzitzij wa' je xtenbij chawa camic ra', tak c'at c'jol xacsaj tak atziak, xatba abar tzra' c'o wa' agan che ncatba wa' per tak xtcaterji'xa nxi'ma ak'a', ncatec'mar ela y ncatc'axa abar majo'n wa' agan. ");
INSERT INTO tzjE_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tak cara' xbij jara' xc'utbej nak xtba'na tzra Pedro tak xtcamsasa, jara' xc'utbej chrecmic Pedro nc'atzina che nyabexa ruk'ij Dios. C'jara' Jesús xbij chic tzra Pedro: —Jo', cnawexbilaj ela. ");
INSERT INTO tzjE_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ja' Pedro xca'y cana tzrij, xutz'et trena jun discípulo chquij, jara' jcongan njo'xa rmal Jesús. Jara' mism discípulo jxuya' rwá' chwech ruc'u'x Jesús tak xqueban q'uisbal w-im ruq'uin tak xc'axaj tzra Jesús: —Wajaw ¿nak nejchowa awxin pquek'a' je nquetzelana awxin? ");
INSERT INTO tzjE_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ja' Pedro tak xutz'et che tren ela jara' discípulo chquij cawra xbij tzra Jesús: —Wajaw, jala' jun kexbil ¿nak xteba'na tzra? ");
INSERT INTO tzjE_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","—Wc'ola ngan c'as na quenruwla' tak xtquenmloj pchic jmul per jawra majo'n ak'a' tzra, xerwara' quenbij chawa, cnawexbilaj, cara' xbixa tzra Pedro rmal Jesús. ");
INSERT INTO tzjE_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jara' tzij je xbij Jesús xba rtzojxic chquecjol kch'alal per xqueq'uex rbixic: —Majo'n ncom ta discípulo, cara' xecbij. Per mcara' ta xbij Jesús com arja' xbij: —Wc'ola ngan c'as na quenruwla' tak xtquenmloj pchic wjic per jawra majo'n ak'a' tzra. ");
INSERT INTO tzjE_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jara' mism discípulo ntajina nk'alsaj njelal jawra xbantaja. Ja' tz'ibyona njelal jc'ola chpam jawra libro y kutkin che ktzitzij nbij. ");
INSERT INTO tzjE_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Per ja' Jesús c'o na je' achnak xuban wawe' chwech ruch'lew. Njelal jxuban Jesús wexte ntz'ibaxa chpam je' libro jara' je' libro mesquier nuban rwech ruch'lew. Amén.");
INSERT INTO tzjE_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, jnabey libro jxentak ela awq'uin xentz'ibaj chpam njelal samaj jxuban Jesús y xentz'ibaj chpam chka' njelal jxuc'ut chquewech wnak. ");
INSERT INTO tzjE_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Xentz'ibaj abar xumaj twa' rsamaj y abar xerec'sa' wa' tak xojte'a chcaj. Tak q'uemjana tojte'a chcaj xerucha' je' rapóstol y xuch'ob chquewech nak xtqueban cana tak xtba. Njelal jxuchol cana, Espíritu Santo xbina tzra. ");
INSERT INTO tzjE_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tak xcoma y xc'astaja c'jara' xuc'ut ri' chquewech je' rapóstol. Cawnak k'ij xec'je' na chwech ruch'lew y q'uiylaj mul xuc'ut ri' chquewech y q'uiy je' achnak xuban chquewech ch-utz c'ara' necnimaj che ne ktzitzij wa' c'astanak chic. Chka' xtzijona cuq'uin y xuch'ob chquewech nak rbanic rgobierno Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tak c'o na chquecjol rapóstol cawra xbij chca: —Me quixel tna chpam tnamet Jerusalén. Nedta' rtzujun chnutak pna Espíritu Santo ewq'uin ajni' nbin cana chewa, jara' c'a teybej chpam jawra tnamet Jerusalén. ");
INSERT INTO tzjE_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan Bautista, ya' xucsaj tak xeruban bautizar je' wnak per ixix xyamer nerla' k'ij tak xtquixba'na bautizar rmal Espíritu Santo. ");
INSERT INTO tzjE_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","J-e' apóstol quemlon qui' ruq'uin Jesús y cawra xecbij tzra: —Kajaw ¿ljawra tiemp nacsaj chic jmul gobierno pkak'a' ajoj ja ok tnamet Israel? cara' xecc'axaj tzra. ");
INSERT INTO tzjE_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","—Ixix me tyataja chewa chnewutkij nak k'ij xtbantaja. Ja' Ttixel ojtakyona y xruyon ja' c'ola ruk'a' tzra nak k'ij xtchumij. ");
INSERT INTO tzjE_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Per tak xtkaj ta Espíritu Santo ewq'uin, tzra' c'ara' nyataj wa' chewa rpoder Dios. Tak xtyataja chewa c'jara' nquixba y nemaj rbixic chca wnak njelal achnak etz'ton y ewc'axan jxenban chewech. Nemaj ela rbixic chpam tnamet Jerusalén y nquixba che rbixic chpam njelal tnamet jc'ola precwent Judea, y nquixba chpam departamento Samaria chka'. C'jara' nquixba che rbixic che c'nat nkaj chwech ruch'lew. ");
INSERT INTO tzjE_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tak xec'choja jawra tzij rmal xojte'a chcaj y xwiwax ela chquewech rmal jle' sutz' y majo'n xquetzu' xta. ");
INSERT INTO tzjE_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tak quemjon na rtz'etic chcaj xewanker ta e c-e' ach-i', sak quetziak quecsan. ");
INSERT INTO tzjE_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","J-e' ach-i' cawra xecbij chca apóstol: —Ach-i' ix aj Galilea ¿nak tzra tak nquixca'ya chcaj? Jesús xojte'a chewech chcaj per nemloj pe chna jmul. Ajni' xetz'et tak xojte'a chcaj cara' nuban tak xtemloj pchic jmul. ");
INSERT INTO tzjE_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","C'jara' j-e' apóstol xe'el ta pe rwá' jyu' Olivo rubi' y xemloja pJerusalén. Je jyu' Olivo xjun c-e' kilómetro recjol ruq'uin Jerusalén. ");
INSERT INTO tzjE_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tak xe'ekaja pJerusalén xeba pjay abar ec'o wa' y xejte'a prucab piso. Y cawra quebi' j-e' apóstol: Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo rlec'wal Alfeo, Simón jun acha jc'ola chquecjol jun partido rbin-an Zelote, ruq'uin Judas rch'alal Jacobo. ");
INSERT INTO tzjE_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","J-e' xjun quebnon tzan rbanic oración e quexbil jle' ixki'. C'ola María rute' Jesús y ec'ola je rch'alal Jesús chka'. ");
INSERT INTO tzjE_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Jara' tiemp xpe'a Pedro chquewech jle' chic kch'alal je cniman chic Jesús. Che conjelal quebnon jun cient ruq'uin juwnak. Pedro cawra xbij chca: ");
INSERT INTO tzjE_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Wch'alal, ne ktzitzij wa' che nbantaj na cumplir rtzojbal Dios ajni' tz'iban ta tzrij Judas rmal David je xbixa tzra rmal Espíritu Santo nak xtuban Judas, y xbantaj na cumplir, xujach Jesús pquek'a' wnak y xquecsaj pcars. ");
INSERT INTO tzjE_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Com Judas xyataja tzra che noca apóstol y kexbil chpam nimlaj samaj rxin Dios jkamjon rij. ");
INSERT INTO tzjE_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Per jxuban ja' xulok' jun ulew tzra pak je xtojbexa ruk'ij rmal rtzilal jxuban. Tak xlok'taja rmal xerq'uiekbej ta ri' y ne rwá' xkasaj chwech abaj y xel ta njelal rexculo'. ");
INSERT INTO tzjE_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Je' wnak jec'ola chpam tnamet Jerusalén tak xcutkij nak xuban Judas xeccanoj rubi' jara' lwar jxulok', Acéldama rubi' xqueya'. Pe ctzojbal j-e' Acéldama nbij tzij lwar rxin quic'. ");
INSERT INTO tzjE_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Com chpam rtzojbal Dios tz'ibtanak cana chpam liwr rxin salmos jcawra nbij: —Ruyon ruchoch nec'je' cana y next jun wnak nec'je'a chpam. Y jun chic cawra nbij: —Je rsamaj jun chwa' nec'sowa. Cara' tz'ibtanak cana. ");
INSERT INTO tzjE_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Y camic ec'ola je' wnak chkacjol jnec'ola kuq'uin tak xkamaj ta ksamaj. Tak xec'je'a Kjawal Jesús kuq'uin ec'ola j-e' chka'. ");
INSERT INTO tzjE_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Tak xba'na bautizar Jesús rmal Juan Bautista ec'ola j-e' tzra', y tak xojte'a Jesús chcaj ec'ola j-e' kuq'uin chka'. Rmal c'ara' camic nc'atzina nekcanoj jun chquecjol che noca apóstol y nela che rbixic nak rbanic c'astajic rxin Jesús. Cara' xbij Pedro. ");
INSERT INTO tzjE_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Xequecha' c'a e c-e' ach-i', jun José Barsabás rubi', Justo nbixa tzra chka', y jun chic Matías rubi'. ");
INSERT INTO tzjE_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","C'jara' xquemaj rbanic oración y cawra xecbij: —Kjawal, atet awutkin njelal achnak jc'ola ptak kanm. Atet ta xtcatec'tuwa chkawech nak jun chca e c-e' ach-i' j-ewra ach-on ");
INSERT INTO tzjE_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","je xtoca awapóstol prec'xel Judas. Com ja' Judas xuya' cana rsamaj rmal rtzilal jxuban y xba chpam lwar abar yatanak wa' tzrij che nba wa'. Cara' oración xqueban. ");
INSERT INTO tzjE_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","C'jara' xquemaj rbanic suert che rcha'ic jun chic apóstol. Tak xec'choja cmal, tzrij Matías xkaj wa' y njara' hor Matías xoca quexbil e juljuj apóstol. ");
INSERT INTO tzjE_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tak xerla' nimk'ij rbin-an Pentecostés conjelal rdiscípulo Jesús xjun quebnon y xjun quemlon wa' qui'. ");
INSERT INTO tzjE_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Chek q'uenjlal xecc'axaj jun achnak ajni' rukul jun nimlaj k'ek' tak xkaj ta, y jawra xecc'axaj conjelal wnak jetz'bula pjay. ");
INSERT INTO tzjE_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","C'jara' xwankera chquewech ajni' ruxak k'ak' y xuq'uiek ri' chquij che jujnel. ");
INSERT INTO tzjE_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","C'jara' xnoja Espíritu Santo ptak canm conjelal y xquemaj tzij chpam jle' chic tzojbal ajni' xyataja chca che jujnel rmal Espíritu Santo. ");
INSERT INTO tzjE_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jara' tiemp ec'ola aj Israel jepenak chpam njelal nación, quemlon qui' pJerusalén y congan quey-on ruk'ij creligión. ");
INSERT INTO tzjE_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tak xecc'axaj je xbantaja xquemol je' qui' y congan xsa'cha cna'oj com pe ctzojbal j-e' nquetzijon wa' je' rdiscípulo Jesús, y ncara' xecc'axaj che jujnel. ");
INSERT INTO tzjE_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Congan xel ta quec'u'x y cawra xecbij chbil tak qui': —¿Nak tzra c'ala'? ¿Me aj Galilea tc'ala' je' wnak je nquetzijona? ");
INSERT INTO tzjE_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Nak tzra c'ara' tak nquetzijona ptak je' ktzojbal? ");
INSERT INTO tzjE_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Com ec'ola jle' chka e aj Partia, jle' chic e aj Media, ec'ola epenak chpam tnamet Elam, ec'ola e aj Mesopotamia, ec'ola e aj Judea, ec'ola e aj Capadocia, ec'ola epenak Ponto, ec'ola epenak Asia. ");
INSERT INTO tzjE_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ec'ola epenak Frigia, ec'ola epenak Panfilia, ec'ola epenak chpam Egipto, ec'ola epenak ptak lwar jc'ola precwent Africa jc'ola chenkaj Cirene. Ec'ola e aj Roma, jle' chca wawe' chpam Israel elexnak wa' y jle' cniman kreligión ja ok aj Israel. ");
INSERT INTO tzjE_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ec'ola chka' e aj Creta y jle' chic e aj Arabia, per konjelal nekc'axaj nimlaj samaj rxin Dios jquemjon rch'obic chkawech ptak ktzojbal che kjujnel. ");
INSERT INTO tzjE_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Conjelal congan xel ta quec'u'x tak xecc'axaj y xsa'cha cna'oj com j-e' mesquier nch'obtaja cmal nak rbanic je xbantaja, y cawra xecbij chbil tak qui': —¿Nak rbanic c'a wa' je xbantaja? ");
INSERT INTO tzjE_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Per ec'ola nic'aj xjic nqueyok'ona y cawra necbij: —J-e' la wnak xe e k'abrela'. ");
INSERT INTO tzjE_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ja' Pedro c'ola chquecjol e juljuj apóstol, xumaj tzij cuq'uin wnak y cawra xbij chca: —Ach-i' ix aj Israel, ixix chka' ixconjelal jixc'ola chpam tnamet Jerusalén, tewc'axaj jawra je xtenbij chewa y tech'bo' rij rwech. ");
INSERT INTO tzjE_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ajoj majo'n ok k'abrela' ta ajni' nebij chka com camic c'a a las nueve rxin xinak'a'. ");
INSERT INTO tzjE_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Jxetz'et camic jara' bitanak cana rmal profeta Joel jcawra nbij: ");
INSERT INTO tzjE_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","—Pe rq'uisbal k'ij quentak ela Espíritu Santo cuq'uin wnak chka bechnak cbanic. Je' ewlec'wal che al-i' ruq'uin je xtni' nqueya' na rbixic jquenk'alsaj chquewech, y chka' je' ewlec'wal je c'jola' quenya' na chca che nquetz'et je' achnak jq'uemjana tbantaja. Y chca je' rija' jec'ola ewq'uin c'ola je' achic' nquech'c'aj na jq'uemjana tbantaja. ");
INSERT INTO tzjE_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jara' tiemp chka' quentak ela Espíritu Santo cuq'uin ajsmajma' wxin che ach-i' y che ixki', y j-e' nqueya' na rbixic nak xtenk'alsaj chquewech. ");
INSERT INTO tzjE_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Y c'ola je' achnak quenwankersaj chwech caj per nexte wjic quetz'ton ta je' wnak, y chka' chwech ruch'lew c'ola je' rital quenya' ajni' tzra quic', ajni' tzra k'ak', y ajni' tzra seb. ");
INSERT INTO tzjE_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Chka' majo'n chic nca'y xta k'ij y noca ic' ajni' quic'. Njelal jawra nbantaj na cumplir tak q'uemjana terla' nimlaj k'ij rxin juicio. ");
INSERT INTO tzjE_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Conjelal je' wnak jnecc'utuj cto'ic tzra Dios j-e' c'ara' nquetotaja. Cara' rbin cana Dios ajni' tz'ibtanak cana chpam rtzojbal rmal profeta Joel. ");
INSERT INTO tzjE_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Cawra xbij chic Pedro chca: —Ach-i' ix aj Israel, tewc'axaj je xtenbij chic chewa. Ja' Dios arja' xuya' tzra Jesús je aj Nazaret che xuban jun nimlaj samaj checjol, y ixix ewutkin jle' nmak tak milagro xuban chewech. Tzra' c'a nkatz'et wa' che Jesús jara' utzlaj acha y najni'la utz ntz'e'ta rmal Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Per Dios xuya' c'as chewa che xecamsaj ela Jesús com xejach pquek'a' wnak jmajo'n cutkin ta rtzojbal Dios, y j-era' wnak xquerip chwech cruz. Dios rutkin chic ojer che Jesús nja'ch na pquek'a' jnetzelana rxin com ja' rchumin ta ojer chcara' nba'na tzra. ");
INSERT INTO tzjE_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Per Dios xet-owa rxin chpam cmic y xuya' tzra che xc'astaja, com je cmic mxecwin ta tzrij Jesús xuchap ta junlic. ");
INSERT INTO tzjE_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Majo'n xecwin ta com rey David cawra rtz'iban cana ojer tzrij Jesús: —Anen wutkin che Wajaw Dios nc'o wa' wq'uin, pe wejquenk'a' c'o wa' y quenruto' ch-utz c'ara' majo'n quenxibej ta wi'. ");
INSERT INTO tzjE_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Rmal c'ara' congan nquicota wanm y quenya' rbixic quicotemal jc'ola wq'uin. Tak xtencoma wutkin chc'o na nc'aslemal y congan utzil quenwil na. ");
INSERT INTO tzjE_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Com atet majo'n quenaya' cta junlic chquecjol cnomki'. Jrecuerpo Santlaj Awlec'wal wutkin chmajo'n naya' ta c'as che nk'oya. ");
INSERT INTO tzjE_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Atet ach'bon chenwech nak rbeyal utzlaj c'aslemal. Tak xtnec'je'a awq'uin junlic jara' congan nnoja quicotemal pwanm. Cara' rtz'iban cana ojer rey David. ");
INSERT INTO tzjE_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ixix wch'alal je ix aj Israel, kutkin bien che xcoma rey David jkawma' y xmu'ka, rpanteón camic c'c'o na kuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Per David arja' jun profeta rxin Dios y rutkin nak tzujun tzra rmal Dios chpam jun juramento jcawra nbij: —David, jawra quentzujuj chawa. C'ola jun chca awiy amam jq'uemjana talexa jara' quencsaj rey jnec'je' cana pnac'xel. Jawra c'a rtzujun cana Dios tzra David. ");
INSERT INTO tzjE_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David xtz'ibaj cana tzrij Cristo tak q'uemjana tpeta wawe' chwech ruch'lew, xbij cana che nc'astaj na y xbij che majo'n nya' cta junlic chquecjol cnomki' y chka' majo'n nk'oy ta recuerpo. ");
INSERT INTO tzjE_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios xuya' tzra Jesús che xc'astaja y jara' kutkin konjelal, y kamjon rbixic. ");
INSERT INTO tzjE_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","C'jara' xojte'a chcaj rmal Dios y xya'a tzra rmal Ttixel che xutak ta Espíritu Santo wawe' chwech ruch'lew ajni' tzujun ta tzra ojer. Ixix camic, jemjon rtz'etic y je emjon rc'axic jara' Espíritu Santo nebnowa. ");
INSERT INTO tzjE_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Per mja' ta David xojte'a chcaj per David cawra xbij cana: —Ja' Kajaw Dios cawra xbij tzra Wajaw: —Catetz'be'a pwejquenk'a' com atet congan nim ak'ij. ");
INSERT INTO tzjE_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Wawe' catec'je' wa' y quenuya' na pnak'a' nak nquetzelana awxin, y atet ncatech'cowa cxin. Cara' rbin cana David. ");
INSERT INTO tzjE_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Rmal c'ara' tak quenbij chewa, Jesús xri'pa chwech cruz com ixix xixc'utuna cmic tzrij. Per jara' Jesús xya'a tzra rmal Dios che xoca Cristo y xoca Rjawal njelal achnak. Twutkij c'a bien jxenbij chewa y tcutkij bien chka' conjelal e aj Israel. Cara' xbij Pedro. ");
INSERT INTO tzjE_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Conjelal wnak tak xecc'axaj je xbixa chca rmal Pedro congan junwa' xquena', kas xuk'ut ri' canm y cawra xecbij: —Ixix ix kwinak aj Israel ¿nak nkaban c'ara' camic? cara' xecc'axaj tzra Pedro y chca nic'aj chic apóstol. ");
INSERT INTO tzjE_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro cawra xbij chca: —Tec'xa' ena'oj y tey-a' cana rtzilal. Y nquixba'na bautizar chixjujnel prubi' Jesucristo ch-utz c'ara' ncuytaja ewil emac. Wcara' neban nkaj ta Espíritu Santo ewq'uin je nsipaj Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Jara' Espíritu Santo je rtzujun cana Dios ojer y ja' Espíritu ntzujux chewa y chca ewlec'wal, y ntzujux chca chka' conjelal wnak jec'ola chpam c'nat tak tnamet. Ja' Espíritu Santo nkaj ta cuq'uin conjelal wnak je nquesiq'uisa rmal Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jawra tzij xbij chic Pedro y xuya' nic'aj paxbanem chca wnak cawrara: —Tey-a' cana rtzilal je nqueban je' wnak chpam jawra tiemp y quixtotaj c'a pruk'a' Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Je' wnak j-utz xecc'axaj je xbij Pedro j-e' c'ara' xeba'na bautizar. Jara' k'ij ec'ola la' e oxi' mil che conjelal jxe'oca kch'alal. ");
INSERT INTO tzjE_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","J-e' congan xectijoj qui' tzrij rtzojbal Dios je nc'u'ta chquewech cmal je' apóstol y xjun quebnon che conjelal che rtijic xquelway y che necnatbej Jesús, y congan oración nqueban. ");
INSERT INTO tzjE_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Conjelal wnak congan xecxibej qui' com j-e' apóstol xyataja chca chcongan milagro xqueban. ");
INSERT INTO tzjE_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Conjelal jxenimana Jesucristo xjun xuban cna'oj y njelal cmibil jc'ola cuq'uin xjun xquech'ob tzrij. ");
INSERT INTO tzjE_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","J-e' necc'ayij cmibil y nqueya' rjel chca kch'alal jcongan nc'atzina chca. ");
INSERT INTO tzjE_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","K'ij k'ij nequemlo' qui' chpam nimlaj rtemplo Dios y xjun quebnon conjelal. Y nquemol qui' ptak jay y xjun nqueban nquewa'a y congan nquequicota, y njelal quec'u'x ruq'uin njelal canm necmeltioxij tzra Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Congan nqueya' ruk'ij Dios y wen nquetz'e'ta cmal wnak. Ja' Kjawal Dios xuya' chca k'ij k'ij che ec'ola je' wnak nquewil totanem rxin Dios y je iglesia xba pnim. ");
INSERT INTO tzjE_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Xqueban jmul Pedro ruq'uin Juan xeba chpam nimlaj rtemplo Dios a las tres rxin tk'ak'ij, jara' hor rxin oración. ");
INSERT INTO tzjE_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Y njelal k'ij nec'je'a tzra' jun acha sic rkan, y prelxic ocnak pwa' sic. C'mon ela ja' sic y y-on chuchi' jun chijay rxin templo, rubi' jara' chijay La Hermosa. Tzra' nya' cwa' jara' sic ch-utz c'ara' nc'utuj pak chca wnak je nque'oca chpam templo. ");
INSERT INTO tzjE_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tak xerutz'et Pedro ruq'uin Juan je nque'oca chpam templo xc'utuj pak chca. ");
INSERT INTO tzjE_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Y j-e' xera' xquetzu' ch'it sic y Pedro cawra xbij tzra: —Ko'atz'ta' ta. ");
INSERT INTO tzjE_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ja' ch'it sic xuya' rexquin tzrij je xbixa tzra y xuch'ob chc'ola jun achnak nsipasa tzra. ");
INSERT INTO tzjE_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Per ja' Pedro cawra xbij chic tzra: —Anen majo'n pak wq'uin per y-on chwa rmal Dios che anen quencwina catnchumsaj. Camic quenbij chawa, prubi' Jesucristo je aj Nazaret catyictaja y catbina. ");
INSERT INTO tzjE_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","C'jara' Pedro xuchap kaja ruk'a' rxin rejquenk'a' y xusic' acha, y jara' hor xchumtaja rkan sic. ");
INSERT INTO tzjE_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Y ja' sic congan xuq'uiek ri' chcaj, xpe'a y xumaj binem. Xerexbilaj ela Pedro ruq'uin Juan y xe'oca chpam templo, congan nuq'uiek ri' y congan nuya' ruk'ij Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Conjelal wnak xquetz'et che necwin chic nbina y xquetz'et chka' remjon rya'ic ruk'ij Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Congan xsa'cha cna'oj rmal y nxel ta ck'awech tak xquetz'et milagro je xbantaja. Cara' xqueban com cutkin rwech acha sic jnetz'be'a chuchi' templo abar c'o wa' ruchi' jun chijay La Hermosa rubi', abar nc'utuj wa' pak. ");
INSERT INTO tzjE_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Jara' acha majo'n nrajo' ta nqueruya' cana Pedro ruq'uin Juan. J-e' ec'ola chpam nimlaj templo, tzra' ec'o wa' abar c'o wa' jun nimlaj rkan jay rbin-an rxin Salomón. J-e' wnak mesquier nch'obtaja cmal je xbantaja y conjelal xeba alnak abar ec'o wa' Pedro. ");
INSERT INTO tzjE_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro tak xerutz'et wnak cawra xbij chca: —Ach-i' ix aj Israel ¿nak tzra tak mesquier nch'obtaja ewmal je xbantaja? ¿Nak tzra tak xera' noketzu'? ¿La ajoj xokchumsana jawra acha nech'ob ixix? Jawra acha necwin chic nbina me rmal ta kchuk'a' ajoj, chka' me xchumtaj ta rmal ta che ok utzlaj tak wnak ta ajoj. ");
INSERT INTO tzjE_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Je Dios rxin Abraham, rxin Isaac, chka' rxin Jacob, Dios cxin e kti't kawma', arja' xk'alsaj che Jesucristo je Rlec'wal congan nim ruk'ij. Per ixix xejach Jesús pquek'a' e k'toy tak tzij. Pilato xrajo' ta xsak'pij ela per ixix majo'n xewajo' ta. ");
INSERT INTO tzjE_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesús arja' ch-on rmal Dios, arja' majo'n ril rumac, per ixix majo'n xewajo' ta che nsak'pix ela, y xjun acha comsanel xec'utuj che nsak'pix ela. ");
INSERT INTO tzjE_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Xecamsaj c'a Jesús je nyowa utzlaj c'aslemal rxin Dios, per Dios xuya' tzra che xc'astaja chquecjol cnomki'. Jara' xkatz'et ruq'uin kk'awech y jara' c'a kamjon rbixic camic. ");
INSERT INTO tzjE_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Camic emjon rtz'etic acha je xchumtaja y ixix ewutkin rwech, y prubi' Jesucristo xchumtaj wa'. Ja' Dios xchumsana rxin y com ajoj c'ola yukbal kac'u'x ruq'uin Jesucristo y ja' Jesús yoyona chka chc'ola yukbal kac'u'x ruq'uin, y rmal yukbal kac'u'x jc'ola ruq'uin tak xchumtaja jawra acha, majo'n chic achnak nti'ona tzra y chewech ixix xchumtaj wa'. ");
INSERT INTO tzjE_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ixix je ix nwinak, tak xec'utuj recmic Jesús wutkin che ixix majo'n ewutkin ta nak emjon rbanic, y cara' chca e k'toy tak tzij chka' jec'ola checjol. ");
INSERT INTO tzjE_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Per jxeban ixix chumin pchic rmal Dios y cara' xbantaja ajni' rbin cana chpam rtzojbal. Com conjelal profeta rxin Dios ctz'iban cana ojer che Cristo nutaj na pen. ");
INSERT INTO tzjE_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Rmal c'ara' quenbij chewa, tec'xa' ena'oj y tey-a' cana itzel tak achnak chpam ec'aslemal. Quixemloj ta ruq'uin Dios ch-utz c'ara' nchuptaja ewil emac. Cara' tc'a neban ch-utz c'ara' newla' pjun k'ij chnec'je'a Kjawal Dios checjol y congan nquixquicot na rmal. ");
INSERT INTO tzjE_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Cara' ta neban ch-utz c'ara' Dios xtutak pchic jmul Jesús je Cristo je To'onel jbitanak cana chewa che npet na. ");
INSERT INTO tzjE_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ja' Jesús nec'je' na tzra' chcaj camic per nerla' na jun k'ij tak xtpet chic jmul erchumsay njelal jyojtanak wawe' chwech ruch'lew ajni' bin cana cmal santlaj tak profeta ojer chpam rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ajni' rbin cana Moisés ojer chca kti't kawma' jcawra nbij: —Kjawal Dios nutak tna jun profeta ewq'uin ajni' xuban chwa anen tak xenrutak ta. Jara' profeta aj Israel y tey-a' ewexquin tzrij nak xtbij chewa. ");
INSERT INTO tzjE_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nak je' wnak majo'n cgan necc'axaj je nbij jara' profeta j-e' c'ara' wnak c'ola jun nimlaj juicio npeta chquij y nquelsas ela chpam rtnamet Dios. Cara' rbin cana Moisés. ");
INSERT INTO tzjE_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Chka' cawra xbij chic Pedro: —Conjelal profeta rxin Dios cbin cana ojer nak xtbantaja chpam jawra k'ij jokc'o wa' camic, xmajtaj ta rbixic rmal profeta Samuel y junam cbin cana jle' chic profeta chka'. ");
INSERT INTO tzjE_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ixix ix quiy quemam cana je' profeta rxin Dios, ewxin ixix chka' utzil je rtzujun cana Dios ojer. Tak xtzujuj cana c'ola jun chuminem xuban cuq'uin e kti't kawma' y cawra xbij cana tzra Abraham: —Njelal tnamet jc'ola chwech ruch'lew nyataj na utzil rxin Dios chca per rmal ajatzul jq'uemjana talexa tak cara' nba'na chca. Cara' xbij ja' Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ja' Dios xutak ta Jesús je Rlec'wal y ewq'uin ixix ix aj Israel xutak twa' nabey. Cara' xuban com arja' nrajo' nuya' utzil chewa ch-utz c'ara' chixjujnel neya' cana itzel tak achnak jc'ola chpam ec'aslemal. Cara' xbij Pedro. ");
INSERT INTO tzjE_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro ruq'uin Juan quemjon tzij cuq'uin wnak tak xe'epona jle' sacerdote cuq'uin, quexbil cjefe e chjalbey templo y chka' ebnak je' saduceo. ");
INSERT INTO tzjE_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Congan penak cyiwal chquij Pedro ruq'uin Juan rmal tak quemjon ctojxic wnak, y cawra tijonem quemjon rya'ic: —Com xc'astaja Jesús rmal c'ara' nquec'astaj na je cnomki' chka'. ");
INSERT INTO tzjE_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","C'jara' xecha'p ela Pedro ruq'uin Juan y xec'axa pcars. Y q'ue rcab k'ij xk'a'ta tzij chquij com xtk'ak'ij chic xe'oca pcars. ");
INSERT INTO tzjE_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Per je' wnak jxecc'axaj rtzojbal Dios e q'uiy chca xeyke'a quec'u'x ruq'uin Jesús. Ec'ola la' e j-o' mil quebnon che conjelal, y xqueyon ach-i'. ");
INSERT INTO tzjE_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Jpe rcab k'ij je k'toy tak tzij cxin aj Israel xquemol qui' pJerusalén e quexbil je' principal-i' rxin tnamet, chka' e quexbil je' maestro je nquetijona cxin wnak tzra rley Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","C'ola chka' Anás jnimlaj sacerdote y chka' ec'ola Caifás, Juan, Alejandro y conjelal je' rch'alal nimlaj sacerdote. ");
INSERT INTO tzjE_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","C'jara' xquetak rc'amric Pedro ruq'uin Juan, y tak ec'ol chic chquewech cawra xecbij chca: —¿Nak tzra tak xixcwina xechumsaj acha? ¿Nak xbina chewa tak xechumsaj? ");
INSERT INTO tzjE_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ja' Pedro xnoja Espíritu Santo pranm, cawra xbij chca: —Ixix je ix k'toy tak tzij, ixix je ix principal-i' rxin ketnamet Israel, ");
INSERT INTO tzjE_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","camic emjon rc'axic chka nak rbanic utzil jxuwil acha jsic nabey. Newajo' newutkij nak xuban tak xchumtaja. ");
INSERT INTO tzjE_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Utz c'ara' twutkij c'a, y chka' tcutkij c'a conjelal aj Israel, prubi' Jesucristo aj Nazaret xchumtaj wa' y rmal Jesucristo tak pa'la chewech camic. Ixix xixc'utuna che nri'pa Jesucristo chwech cruz per Dios xuya' tzra che xc'astaja chquecjol cnomki'. ");
INSERT INTO tzjE_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ja' Jesús ajni' jun abaj nim ruk'ij com jara' abaj nechpowa resquina-il jay, per ixix itzel xetz'et y camic jara' abaj más na nim ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Xruyon ruq'uin Jesús nkawil wa' totanem rxin Dios y majo'n chic jun retkon ta Dios wawe' chwech ruch'lew jnet-owa kxin. Cara' xbij Pedro. ");
INSERT INTO tzjE_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","J-e' e k'toy tak tzij tak xquetz'et chmajo'n necxibej ta qui' Pedro ruq'uin Juan y xquetzu' chka' che j-e' majo'n estudio quebnon ta y xe ch'tak sencillo wnak cbanic, rmal c'ara' xel ta quec'u'x chquij y xch'obtaja cmal che j-e' xec'je'a ruq'uin Jesús. ");
INSERT INTO tzjE_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Y nquetz'et chka' che chumtanak chic acha sic y pa'la pquexquin Pedro ruq'uin Juan, rmal c'ara' majo'n achnak nquecchapbej. ");
INSERT INTO tzjE_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","C'jara' xequelsaj ela chpam jay abar quemlon wa' qui' y xeq'ue' cana queyon j-e' ch-utz c'ara' nquech'ob kaja queyon nak nqueban chca. ");
INSERT INTO tzjE_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","¿Nak nkaban chca j-e' la ach-i'? Com conjelal wnak jec'ola pJerusalén k'alaj chic chquewech chc'ola jun nimlaj milagro xqueban y ajoj mesquier nkocwina nekwiwaj. ");
INSERT INTO tzjE_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Je nkaban camic, nquekxibej ela y cawra nekbij chca: —Majo'n nenataj xta rubi' Jesús chquewech wnak, per we xtenataj jara' netaj na pen y lowlo' nkaban chewa. Cara' kbij chca ch-utz c'ara' majo'n nba ta pnim rbixic jmilagro je xqueban. ");
INSERT INTO tzjE_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","C'jara' xecsiq'uij chic jmul y cawra xecbij chca: —Mtenataj xta rubi' Jesús chquewech wnak y me tque'etijoj xta tzrij nak rbanic Jesús. ");
INSERT INTO tzjE_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Per Pedro ruq'uin Juan cawra xecbij chca: —Kas tech'bo' na ejkal nak nebij. ¿Lrubey c'ara' nech'ob ixix jmajo'n neknimaj xta Dios y xe ixix nquixknimaj? ");
INSERT INTO tzjE_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ajoj majo'n nkaya' cta rbixic jkatz'ton y je kc'axan, cara' xecbij chca. ");
INSERT INTO tzjE_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","J-e' c'a e k'toy tak tzij xecbij chca che nquetaj pen y lowlo' pquek'a' we xtquemaj chic rbixic rubi' Jesús. Tak xbitaja tzij cmal c'jara' xesak'pix ela. Mesquier xecwin ta xqueban lowlo' chca com conjelal wnak congan nqueya' ruk'ij Dios rmal milagro je xbantaja. ");
INSERT INTO tzjE_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Cara' xqueban wnak com ja acha je xba'na milagro tzra, arja' más chic cuarenta rjuna'. ");
INSERT INTO tzjE_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tak xesak'pix ela Pedro ruq'uin Juan xeba cuq'uin quexbil. Tak xe'ekaja xquemaj rcholic chquewech njelal je xbixa chca cmal je' cjefe sacerdote ruq'uin je' principal-i' rxin tnamet. ");
INSERT INTO tzjE_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tak xc'axtaja cmal quexbil xquemaj c'a rbanic oración y cawra xecbij: —Kajaw, atet jc'ola pnak'a' njelal jxawankersaj ajni' tzra caj ruq'uin ruch'lew, chka' nimlaj mar, y njelal achnak jc'ola wawe' atet c'a atwankersyona y pnak'a' c'a c'ol wa'. ");
INSERT INTO tzjE_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Cawra c'a xabij cana ojer chpam atzojbal jtz'iban cana rmal David je ajsmajma' awxin jcawra nbij: —Je' wnak jme aj Israel ta ¿nak tzra xch'oj ncajo'? Y j-e' aj Israel ¿nak tzra tak xitzel tak na'oj nquech'ob jmajo'n rc'atzil? ");
INSERT INTO tzjE_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Je' reyes y je' e k'toy tak tzij rxin rwech ruch'lew nquemol je qui' che nquech'ojina wq'uin y chka' ruq'uin Cristo jnech-on. Cara' abin cana. ");
INSERT INTO tzjE_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Y cara' xbantaja ajni' abin cana. Com cara' xqueban Herodes ruq'uin Poncio Pilato, arj-e' xjun xqueban wawe' pJerusalén che rcamsic Jesús jSantlaj Awlec'wal jxacha' che noca To'onel kxin ajoj ja ok wnak, y chka' xjun xqueban cuq'uin je' wnak jme aj Israel ta y je' aj Israel. ");
INSERT INTO tzjE_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Njelal je xqueban nachumin pwa' ojer che nbantaj na. ");
INSERT INTO tzjE_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kajaw Dios, camic natz'et chcongan cyiwal chka, per ajoj ok ajsmajela' awxin nekc'utuj chawa che naya' kchuk'a' ch-utz c'ara' majo'n nekxibej ta ki' che nkaya' rbixic atzojbal. ");
INSERT INTO tzjE_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Atet tc'a xtcatchumsana cxin je' yuw-i' y xtaban ta nmak tak milagro prubi' Jesús jSantlaj Awlec'wal. Cara' oración xqueban. ");
INSERT INTO tzjE_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tak xec'choja oración cmal congan xusil ri' lwar abar tzra' quemlon wa' qui', xnoja Espíritu Santo ptak canm che conjelal y xquemaj rbixic rtzojbal Dios per majo'n xben ri'il chca. ");
INSERT INTO tzjE_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Conjelal je cniman chic Jesús xjun quebnon y xjun na'oj quecsan y njelal cmibil xjun quebnon tzra, next jun xtbij ta tzrij rmibil: —Wxin wanen, xnuyon tzrij. ");
INSERT INTO tzjE_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","J-e' apóstol njelal k'ij nqueya' rbixic njelal jquetz'ton tzrij tak xc'astaja Jesús, y congan rpoder Dios c'ola cuq'uin y c'ola utzil rxin Dios pquewá' conjelal. ");
INSERT INTO tzjE_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Next jun c'ola chquecjol c'o ta rnecesidad com je' kch'alal wc'ola je' culew o cuchoch necc'ayij cana y nquec'om ela rjel, ");
INSERT INTO tzjE_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","y nquejach pquek'a' apóstol, y j-e' apóstol nquejach pquek'a' jc'ola cnecesidad. ");
INSERT INTO tzjE_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Cara' c'a xuban jun kch'alal José rubi', riy rumam cana Leví, pChipre penak wa'. J-e' apóstol xeccanoj chic jun rubi', Bernabé xecbij tzra. Bernabé nbij tzij jun acha nyukba' quec'u'x wnak. ");
INSERT INTO tzjE_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bernabé c'ola jun ulew xc'ayij y rjel xuc'om ela y xujach pquek'a' apóstol. ");
INSERT INTO tzjE_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Per c'o chna jun acha Ananías rubi' y rexkayil Safira rubi', j-e' c'ola jun ulew xecc'ayij chka'. ");
INSERT INTO tzjE_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ja' Ananías xqueya' chquewech ruq'uin rexkayil che nquelsaj cana nic'aj rjel ulew chnec'je' cana cuq'uin y nic'aj chic xuc'om ela y xujach pquek'a' apóstol y xbij chca: —Xerwa' njelal rejlal ulew jxekc'ayij. ");
INSERT INTO tzjE_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tak xjachtaja njelal rmal, cawra xbixa tzra rmal Pedro: —Ananías, c'ola nic'aj rjel ulew xec'je' cana awq'uin. ¿Nak tzra tak xaban cara'? ¿Nak tzra tak xaya' c'as tzra Satanás xoca pnawanm y xaterchajtij che xatz'ak tzij chwech Espíritu Santo? ");
INSERT INTO tzjE_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Lma awxin tc'a ulew? C'ola ak'a' tzra che xac'ayij y rjel pnak'a' atet c'ol wa'. Atet c'ara' nak kas naban tzra per jara' m-utz ta xaban xatz'ak tzij. ¿Nak tzra tak xaban cara'? Chwech Dios xatz'ak wa' tzij, me chquewech ta wnak, cara' xbixa tzra Ananías. ");
INSERT INTO tzjE_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ja' Ananías tak xc'axaj je xbixa tzra xba chuch'lew y xcoma. J-e' wnak tak xecc'axaj che xcoma Ananías congan xecxibej qui' rmal. ");
INSERT INTO tzjE_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ec'o c'a jle' c'jola' xquebutz comnak y xqueban ela rchumsic, tak xec'choja cmal xectelej ela y xequemku' cana. ");
INSERT INTO tzjE_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","C'ola la oxi' hor comnak Ananías tak xekaja rexkayil cuq'uin apóstol, arja' majo'n rutkin ta che comnak chic rechjil. ");
INSERT INTO tzjE_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ja' Pedro cawra xbij tzra: —Tbij chwa, tak xec'ayij ulew ¿le xjara' rjel njelal ajni' xejach pkak'a'? —Xjala' rejlal njelal, cara' xbij ixak. ");
INSERT INTO tzjE_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","¿Nak tzra tak xjunam xech'ob ruq'uin awechjil? ¿Nak tzra tak xewajo' xeban probar Espíritu Santo rxin Kajaw Dios? Tetz'ta' mpa', camic xemloj ta jxemkuwa rxin awechjil, y camic ncatc'om el chic atet, ncattelex ela y ncatemu'k cana. Cara' xbij Pedro tzra. ");
INSERT INTO tzjE_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tak xbitaja tzij ja' Safira xba penlew chwech Pedro, xepne' kaja y xcoma. J-e' c'jola' tak xerkaja y xquetz'et che comnak chic c'jara' xectelej ela y xequemku' cana. Y prexquin rechjil xequemku' cwa'. ");
INSERT INTO tzjE_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iglesia congan xecxibej qui' conjelal y cara' xqueban conjelal jle' chic wnak chka' tak xecc'axaj je xbantaja. ");
INSERT INTO tzjE_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","J-e' c'a apóstol c'ola jle' nmak tak milagro nqueban chquewech je' wnak y je' kch'alal xjun quebnon che conjelal. C'o jun rkan jay c'ola chuchi' rtemplo Dios, rubi' rkan jay rxin Salomón, tzra' quemlon wa' qui' conjelal kch'alal. ");
INSERT INTO tzjE_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Je jle' chic wnak necxibej qui' che nque'oca chquecjol kch'alal per j-e' kch'alal ajni'la utz xetz'e'ta cmal tnamet. ");
INSERT INTO tzjE_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Y más e q'uiy wnak xeyke'a quec'u'x ruq'uin Jesucristo, ach-i' ruq'uin je' ixki', y xjun xqueban cuq'uin je' kch'alal. ");
INSERT INTO tzjE_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ec'ola je yuw-i' xelsas ta ptak bey, ey-on ta chwech cwarbal. Cara' xba'na chca ch-utz c'ara' Pedro tak xtpeta xe rnatu' opech nk'axa chquij, nquerchumsaj cana. ");
INSERT INTO tzjE_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Chka' e q'uiy je' wnak jec'ola ptak tnamet chenkaj ruq'uin Jerusalén arj-e' xequec'om pa je yuw-i' jec'ola cuq'uin, xequec'om pa jemajtanak cmal itzel tak espíritu y xechumtaj ela conjelal. ");
INSERT INTO tzjE_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Per xyictaja jnimlaj sacerdote y xeyictaja conjelal jec'ola ruq'uin, arj-e' aj saduceo y congan nk'utluja canm chquij apóstol. ");
INSERT INTO tzjE_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Xequechap y xequecsaj pcars. ");
INSERT INTO tzjE_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Per c'ola jun ángel rxin Dios xerkaja chak'a', xujak ruchi' cars y xerelsaj ta apóstol. Tak xelestaj ela cawra xbixa chca rmal ángel: ");
INSERT INTO tzjE_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Camic jax chpam nimlaj templo rxin Dios ey-a' rbixic chca wnak nak rbanic jc'ac'laj c'aslemal jnuya' Jesucristo. ");
INSERT INTO tzjE_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tak xbitaja chca xeba c'a, kas samakmuj xe'ekaja chpam templo y xquemaj ctojxic je' wnak. Jnimlaj sacerdote y chka' jec'ola ruq'uin arj-e' xquemol qui' cuq'uin e k'toy tak tzij rxin tnamet Israel y xequetak ela cc'omric apóstol jec'ola pcars. ");
INSERT INTO tzjE_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tak xe'ekaja je' policía abar ec'o wa' pcars xquetz'et che e majo'n chic j-e' apóstol. C'jara' xemloj ta y xecrey-a' rbixic je xbantaja. ");
INSERT INTO tzjE_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Cawra xecbij: —Tak xokekaja chuchi' cars bien tz'pala y bien chjalben cmal soldado chka'. Per tak xkajak ruchi' next jun wnak c'ola chpam. ");
INSERT INTO tzjE_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Jnimlaj sacerdote rexbil cjefe e chjalbey templo e quexbil jle' chic sacerdote je nmak quek'ij, congan xsa'cha cna'oj rmal je xbixa chca y cawra xecbij chbil tak qui': —¿Nak lc'a xtuban je xbantaja? ");
INSERT INTO tzjE_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","C'jara' c'ola jun acha xekaja cuq'uin y cawra xbij chca: —Ach-i' jxecsaj pcars, camic quemjon ctojxic wnak chpam nimlaj templo rxin Dios. Cara' xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Je cjefe e chjalbey templo e rexbil je' policía xeba che cc'omric apóstol. Tak xe'ekaja cuq'uin xequechap per majo'n lowlo' xqueban ta chca com necxibej qui' chquewech wnak: —Mal-il xtokqueq'uiek tzan abaj. Cara' xquech'ob. C'jara' xequec'om pa apóstol. ");
INSERT INTO tzjE_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tak xerkaja xequejach pquek'a' e k'toy tak tzij. Jnimlaj sacerdote cawra xbij chca apóstol: ");
INSERT INTO tzjE_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Ajoj cow xixkachap y xekbij chewa che mtenataj xta rubi' Jesús chquewech wnak. ¿Nak q'ue tzra mtenimaj jxekbij chewa? Com jtijonem jneya' congan bnak pnim camic wawe' chpam tnamet Jerusalén y ixix newajo' neya' chkij che ajoj xokcamsana rxin Jesús. Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro e rexbil jle' chic apóstol cawra xecbij chca: —Ajoj pors neknimaj je nbij Dios chka che nkaban que chwech nquixknimaj ixix. ");
INSERT INTO tzjE_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ixix xec'utuj recmic Jesús, xec'utuj che nri'pa chwech cruz, per Kadta' Dios, Dios rxin kti't kawma', arja' xuc'as chquecjol cnomki'. ");
INSERT INTO tzjE_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ja' Dios congan xucsaj rchuk'a' y xuya' tzra Jesús che más nim na ruk'ij y camic rucsan Jefe chkawech y rucsan To'onel kxin. Cara' xuban Dios com kas nrajo' chewa ixix ix aj Israel che neq'uex ena'oj y neya' cana itzel tak achnak ch-utz c'ara' ncuytaja njelal ewil emac. ");
INSERT INTO tzjE_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Njelal jawra jxekbij kaja chewa jara' katz'ton ta y kc'axan chka', y Espíritu Santo arja' remjon rk'alxic chkawech che ne ktzitzij wa'. Ja' Dios retkon ta Espíritu Santo kuq'uin konjelal ajoj jnoknimana rxin. Cara' xecbij apóstol chca. ");
INSERT INTO tzjE_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tak xc'axtaja cmal je xbixa chca congan xpeta cyiwal y ncajo' nqueccamsaj apóstol. ");
INSERT INTO tzjE_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Per tzra' c'o wa' jun fariseo Gamaliel rubi', arja' jun maestro chca je nquetijona cxin wnak tzrij rley Dios y congan utz ntz'e'ta cmal conjelal tnamet. Gamaliel xpe'a y xbij chca apóstol che nque'el ela jurat chquecjol. ");
INSERT INTO tzjE_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tak e'elnak chic xumaj tzij Gamaliel cuq'uin e k'toy tak tzij: —Ach-i' ix aj Israel, kas tech'bo' na bien nak neban chca ach-i'. ");
INSERT INTO tzjE_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Terkaja pnewá' nak xbantaja tak c'ola jun acha xyictaja Teudas rubi', arja' xucsaj ri' com jun nimlaj acha y ec'ola e cji' cient ach-i' xetre'a tzrij. Per ja' Teudas xcamsasa y xenanmaja conjelal rexbil, cara' xqueban y ejkal xqueq'uis qui' conjelal y majo'n chic achnak xqueban. ");
INSERT INTO tzjE_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Y c'o chic jun acha cara' xuban, jrubi' jara' Judas aj Galilea, arja' xyictaja tak c'ola jun censo xba'na y e q'uiy je' wnak xetre'a tzrij. Per ja' Judas xcamsasa chka' y xqueq'uis qui' conjelal rexbil. ");
INSERT INTO tzjE_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Rmal c'ara' tak quenbij chewa camic, majo'n nak teban chca j-e' la ach-i' y más na wen neban camic que'esak'pij ela. Cara' quenbij chewa com njelal jquemjon rbanic we xtijonem cxin wnak jara' nq'uis kaja ruyon. ");
INSERT INTO tzjE_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Per wtijonem rxin Dios nqueya' jara' mtquixecwina neyoj ixix. Kas tebna' na cwent, mex ruq'uin Dios xtquixch'ojin wa'. Cara' xbij Gamaliel chca rexbil. ");
INSERT INTO tzjE_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Arj-e' xch'obtaja cmal je xbixa chca, xquetak cc'omric apóstol. Tak xe'erkaja apóstol xmajtaja cch'ayic y cawra xecbij chca: —Mtenataj xta rubi' Jesús chquewech wnak. Y xesak'pix ela. ");
INSERT INTO tzjE_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Xeba j-e' apóstol, congan nquequicota com xyataja chca che xba'na lowlo' chca prubi' Jesucristo. ");
INSERT INTO tzjE_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","K'ij k'ij nectijoj je' wnak chpam templo y chka' ptak je' jay y nqueya' rbixic Jesucristo chca. ");
INSERT INTO tzjE_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jara' k'ij xwankera problema chquecjol kch'alal com congan e q'uiy chic. K'ij k'ij q'uiy way nja'cha per je kch'alal je nquetzijona pe griego cawra xecbij: —Je' melcani' tak ixki' jec'ola kuq'uin majo'n q'uiy ta way nya'a chca tak nja'cha way que chwech je nquetzijona chpam tzojbal hebreo. ");
INSERT INTO tzjE_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","J-e' e cbeljuj apóstol xequemol conjelal kch'alal y cawra xecbij chca: —Kch'alal, ajoj majo'n yatanak ta chkij xtektenba' ta rbixic rtzojbal Dios y xtkamaj ta rjachic way. ");
INSERT INTO tzjE_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Rmal c'ara' tak nekbij chewa camic, que'ecanoj e wku' ach-i' checjol j-utz nquetz'e'ta cmal kch'alal y nojnak Espíritu Santo ptak canm y congan utzlaj tak cna'oj. Tak xtquecontaja ewmal, ajoj nkaya' chca che j-e' nquejchow way. ");
INSERT INTO tzjE_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Je nkaban ajoj camic junlic nkamaj rij oración y chka' ctojxic je' wnak tzan rtzojbal Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","J-e' c'a kch'alal utz xecc'axaj je xbixa chca cmal apóstol. Xeccanoj c'a e wku' ach-i', jun Esteban rubi' y arja' congan ykula ruc'u'x ruq'uin Jesucristo y nojnak Espíritu Santo pranm. E wajki' chic cawra quebi': Felipe, Prócoro, Nicanor, Timón, Parmenas ruq'uin Nicolás. Nicolás arja' aj Antioquía, y nabey tak q'uemjana tnimaj Jesucristo xnimaj creligión tnamet Israel. ");
INSERT INTO tzjE_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","J-e' c'a wa' e wku' ach-i' xepabaxa chquewech apóstol. J-e' c'a apóstol xqueban oración pquecwent y xqueya' quek'a' pquewá'. ");
INSERT INTO tzjE_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Je rtzojbal Dios chkajni' xba pnim y congan xeq'uiya je' kch'alal pJerusalén. Congan e q'uiy chca sacerdote xecnimaj rtzojbal Dios y xeyke'a quec'u'x ruq'uin Jesucristo. ");
INSERT INTO tzjE_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban nojnak pranm utzil je nsipaj Dios y congan rpoder Dios c'ola ruq'uin, y c'ola jle' nmak tak milagro nuban chquewech je' wnak. ");
INSERT INTO tzjE_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","C'ola jun jay rxin molbal ri'il je nbixa tzra molbal ri'il cxin je' wnak je e'elnak chic libre. Ec'ola je' wnak chpam e aj Cirene e quexbil jle' aj Alejandría, jle' chic aj Cilicia y jle' chic aj Asia, j-e' c'a xeyictaja y xquemaj ch'oj ruq'uin Esteban tzrij jremjon rbixic. ");
INSERT INTO tzjE_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Per tak xtzijona Esteban j-e' mesquier chic necneya quetzij nak necbij tzra com rna'oj Dios necsaj y Espíritu Santo c'ayona rxin che rbixic je' tzij. ");
INSERT INTO tzjE_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Je xqueban, ec'ola jle' ach-i' xeccanoj, xqueya' pak chca y cawra xecbij chca: —Camic telsaj rtzojxic che Esteban cawra nbij chca wnak: —Ja' Esteban xitzel ntzijona tzrij Moisés y chka' xitzel ntzijona tzrij Dios, cara' xtechol. ");
INSERT INTO tzjE_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Cara' xqueban j-era' ach-i', xquetz'ak tzij tzrij Esteban y rmal c'ara' je tnamet e quexbil principal-i' e quexbil chka' je' maestro rxin ley xeyictaja tzrij. J-e' c'a ach-i' tak xe'ekaja ruq'uin Esteban xquechap ela y xquec'om ela chquewech e k'toy tak tzij. ");
INSERT INTO tzjE_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ec'o chic jle' ach-i' xeccanoj je nque'oca testigo che nquetz'ak tzij tzrij. J-e' c'a testigo cawra xecbij chca e k'toy tak tzij: —Jala acha remjon rbixic jle' tzij tzrij jawra lwar santo y tzrij ley rxin Moisés per xe m-utz ta nbij tzra. ");
INSERT INTO tzjE_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Com ajoj kc'axan je nbij che Jesús aj Nazaret nuyoj na templo ruq'uin je' kcostumbre jyatanak chka rmal Moisés. Cara' nbij jala acha. ");
INSERT INTO tzjE_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","J-e' c'a e k'toy tak tzij conjelal xectz'ulchij ruplaj Esteban, cara' nca'ya ruplaj ajni' jun ángel rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","C'jara' jnimlaj sacerdote cawra xbij tzra Esteban: —¿Le ktzitzij jnecbij jtestig chawa? Esteban xumaj rij tzij cuq'uin e k'toy tak tzij y cawra xbij chca: ");
INSERT INTO tzjE_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","—Ach-i' je ix nwinak ruq'uin ixix je ix principal-i', ixconjelal je ix aj Israel, tewc'axaj je xtenbij chewa. Jnimlaj Dios arja' xuc'ut ri' chwech kawma' Abraham ojer tak c'c'o na pMesopotamia tak q'uemjana tba chpam tnamet Harán. ");
INSERT INTO tzjE_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Cawra xbij ja' Dios tzra Abraham: —Tey-a' cana atnamet y que'ay-a' cana awch'alal perc c'ola jun tnamet quenc'ut chawech, tzra' jat wa'. ");
INSERT INTO tzjE_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ja' Abraham xel ta pMesopotamia abar ec'ol wa' je' wnak aj Caldeos nbixa chca, y xba chpam tnamet Harán y tzra' xec'je' chwa'. Tak xcoma redta' Abraham xta'k ta ja' Abraham rmal Dios wawe' chpam tnamet abar okc'ol wa' camic ajoj ok tnamet Israel. ");
INSERT INTO tzjE_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Per next jun ulew xuya' ta tzra wawe' per nexte jtz'it. Per Dios c'ola xtzujuj cana tzra y cawra xbij: —Abraham, nerla' na jun k'ij tak anen xtenjach tnamet pnak'a' y pquek'a' awiy amam chka'. Cara' xbij ja' Dios tzra mesque jara' tiemp ja' Abraham majo'n rlec'wal. ");
INSERT INTO tzjE_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Y cawra xbij tzra chka': —Je' awiy amam nquec'je' na cji' cient juna' chpam jun tnamet y tzra' nquetaj wa' pen y lowlo' pquek'a' jle' chic wnak jme e cwinak ta. ");
INSERT INTO tzjE_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Per anen c'ola jun nimlaj juicio quentak ela chquij j-e' wnak je nquebnowa lowlo' chca. C'jara' nquesak'pix ta awiy amam y nquerkaja chpam tnamet je xtenjach pquek'a', y wawe' ra' nqueya' wa' nuk'ij. Cara' xbij ja' Dios tzra. ");
INSERT INTO tzjE_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ja' Dios c'ola jun chuminem xchumsaj ruq'uin Abraham, chuminem rxin circuncisión cara' nbixa tzra. Ja' Abraham c'ola jun ch'it rlec'wal xec'je'a, Isaac rubi'. Tak xuban waxki' k'ij alexnak ac'al xuban circuncidar. Y cara' xuban chic Isaac chka' tak xoca acha, c'ola jun rlec'wal xec'je'a Jacob rubi', chka' xuban circuncidar. Y cara' xuban chic Jacob chka' tak xoca acha, xeq'ue'a e cbeljuj rlec'wal, j-e' c'ara' xe'oca ttixel kxin ajoj ok tnamet Israel. ");
INSERT INTO tzjE_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Xqueban jmul j-e' rlec'wal Jacob congan xk'utluja canm tzrij jun quechak' rubi' José rmal c'ara' tak xecc'ayij ela pquek'a' jle' chic wnak. Ja' José xec'mar ela chpam tnamet Egipto per Dios c'ola ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Dios xet-owa rxin chpam je' lowlo' je xk'ax wa', xuya' rna'oj rmal c'ara' tak congan wen xtz'e'ta ja' José rmal Faraón rey rxin Egipto. Ja' Faraón xucsaj José gobernador rxin Egipto y xuya' tzra chka' ch-ja' npe'a tzrij njelal rmibil jc'ola pruchoch. ");
INSERT INTO tzjE_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Jara' k'ij c'ola jun nimlaj wyejal xwankera ptak tnamet jc'ola precwent Egipto y chka' jc'ola precwent Canaán, congan quetjon pen wnak rmal. J-e' kti't kawma' mesquier chic necneya cmal nak nquetaj. ");
INSERT INTO tzjE_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tak xerkaja rbixic ruq'uin Jacob chc'ola trigo chpam tnamet Egipto arja' xerutak ela rlec'wal che nequelk'o' trigo. Jara' tak xeba nabey mul. ");
INSERT INTO tzjE_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tak xeba chic pe rcamul, tak xe'ekaja cawra xbixa chca rmal José: —Anen c'ara' en echak'. Jrey rxin Egipto tzra' xutkij wa' che aj Israel ja' José. ");
INSERT INTO tzjE_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","C'jara' José xutak rc'amric Jacob jredta' ruq'uin je rch'alal chka', e setenticinco che conjelal. ");
INSERT INTO tzjE_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Cara' c'a rbanic tak xec'je'a Jacob chpam tnamet Egipto, y tzra' chpam tnamet Egipto xcom wa' y tzra' xecom wa' conjelal rlec'wal jxe'oca ttixel kxin ajoj ok tnamet Israel. ");
INSERT INTO tzjE_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tak xk'axa q'uiylaj tiemp xec'mar ta cbakil y xe'ermu'ka chpam panteón jc'ola chpam tnamet Siquem. Jara' panteón je lk'on cana rmal comnak Abraham, com ja' Abraham relk'on cana panteón tzan pak chca rlec'wal jun acha Hamor rubi'. ");
INSERT INTO tzjE_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Tak xyamer nerla' k'ij tak nbantaja cumplir je rtzujun cana Dios tzra Abraham congan xeq'uiya j-e' aj Israel chpam tnamet Egipto. ");
INSERT INTO tzjE_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jara' tiemp gobierno rxin Egipto xoca pruk'a' jun chic rey jmajo'n rutkin ta njelal nak rebnon cana José. ");
INSERT INTO tzjE_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Jara' rey xuch'ob jun mellaj na'oj chquij tnamet Israel jec'ola chpam tnamet Egipto perc xelsaj jun orden cawra nbij: —Tak nque'alexa clec'wal aj Israel ch'tak al-i' pors nqueya' cana queyon ch-utz c'ara' nquecoma. Cara' nbij jara' orden. ");
INSERT INTO tzjE_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Chpam jara' tiemp xalex wa' Moisés. Ja' Moisés jun ac'al ajni'la xtz'e'ta rmal Dios. Je redta' rute' x-oxi' ic' xecq'uettzij pcuchoch. ");
INSERT INTO tzjE_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","C'jara' mtcajo' chumni xqueya' cana. Per c'ola jun rmi'al rey rxin Egipto arja' xusic' ela Moisés y xuc'om ela pruchoch. Arja' xq'uettzina rxin, xuban tzra ajni' ch'it ral. ");
INSERT INTO tzjE_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ja' Moisés xtijoj ri' tzrij njelal tijonem cxin aj Egipto. Tak ntzijona congan nbekaja pnawá' je nbij y njelal achnak necwina nuban. ");
INSERT INTO tzjE_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Tak cawnak chic rjuna' Moisés xuban jmul xuch'ob che nquerk'ijla' ch'tak aj Israel y cara' xuban. ");
INSERT INTO tzjE_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tak xekaja cuq'uin c'ola jun aj Israel xutz'et congan lowlo' nba'na tzra rmal jun aj Egipto. C'jara' xuto' aj Israel y xuya' rec'xel tzra aj Egipto y xcamsaj. ");
INSERT INTO tzjE_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Y cawra xuch'ob kaja pranm: —Conjelal aj Israel nch'obtaj c'ala' cmal che Dios entakyon ta che que'enelsaj ela libre pquek'a' aj Egipto. Per j-e' aj Israel mesquier nch'obtaja cmal. ");
INSERT INTO tzjE_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pe rcab k'ij chic ec'ola e c-e' aj Israel xerutz'et quemjon ch'oj. Ja' nrajo' nquerujach y cawra xbij chca: —¿Nak tzra tak neban ch'oj? Per xe ewinak c'a ewi'. Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Per acha kas nnakona xumin Moisés y cawra xbij tzra: —¿Nak xbina chawa che atet ncatebnowa mandar kxin? ¿Nak xbina chawa che atet ncatek'towa tzij chkij? ");
INSERT INTO tzjE_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Lnawajo' cnacamsaj chic anen ajni' xaban tzra aj Egipto iwir? ");
INSERT INTO tzjE_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ja' Moisés tak xc'axaj chcara' xbixa tzra, xnanmaj ela y q'ue c'nat xba wa' chpam jun tnamet Madián rubi'. Chpam jara' tnamet Madián xec'je' wa', chquecjol jle' wnak jme aj Israel ta xec'je' wa'. Chpam jara' tnamet xec'le' wa' y tzra' xe'alex wa' e c-e' rlec'wal. ");
INSERT INTO tzjE_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Cawnak juna' tekaja Moisés chpam tnamet Madián tak pjun k'ij xwankera jun ángel chwech chpam jun chkilaj ulew jc'ola chenkaj ruq'uin jyu' rbin-an Sinaí. Tzra' c'ol wa' jmoc xulquiej congan nebc'owa chpam k'ak' y chpam xwanker wa' ángel. ");
INSERT INTO tzjE_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ja' Moisés congan xel ta ranm tzrij. Com c'ola rgan nutzu' rmal c'ara' xki'l pona más ruq'uin. Tak chek q'uenjlal xc'axaj rukul Dios y cawra xbixa tzra rmal Dios: ");
INSERT INTO tzjE_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","—Anen en Dios cxin awti't awma', en Dios rxin Abraham, en Dios rxin Isaac, en Dios rxin Jacob. Cara' nbixa tzra, congan xberbeta y nxibej chic ri' nutz'et. ");
INSERT INTO tzjE_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Cawra xbix chic jmul tzra rmal Kajaw Dios: —Telsaj axjab com ulew apalben jara' santlaj ulew rxin Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Anen netz'ton bien jlowlo' jquemjon rtijic netnamet pquek'a' aj Egipto y newc'axan ok'ej jquemjon rbanic. Camic enkanak ta wawe' che cto'ic. Camic tchumij awi' com catnutak ela chpam tnamet Egipto. Cara' xbixa tzra Moisés rmal Dios. Cara' xbij Esteban y xumaj chic rbixic nic'aj tzij y cawra xbij: ");
INSERT INTO tzjE_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","—Ja' Moisés majo'n cgan aj Israel tzrij com j-e' xcawra necbij tzra: —¿Nak xbina chawa che atet ncatebnowa mandar kxin? ¿Nak xbina chawa che atet ncatek'towa tzij chkij? Per ja' Moisés, Dios xetkowa rxin ch-utz c'ara' ja' nebnowa mandar cxin y ch-utz c'ara' chka' ja' net-owa cxin pquek'a' aj Egipto. Ja' Dios c'ola jun ángel xutak ta che rto'ic Moisés jara' xwankera chpam k'ak' tak c'ola jmoc xulquiej congan nebc'owa. ");
INSERT INTO tzjE_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ja' Moisés xelsan ta cxin kti't kawma' chpam Egipto y congan nmak tak milagro xuban che clasic. C'ola milagro xuban chpam Egipto, c'ola milagro xuban tzra nimlaj mar rbin-an quiek mar y c'ola milagro xuban tzra cawnak juna' tak xerc'aj tnamet rxin Dios chpam chkilaj lwar. ");
INSERT INTO tzjE_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ja' mism Moisés cawra xbij chca rtnamet Dios: —Kajaw Dios nutak tna jun profeta che nquixruto' ajni' xuban chwa anen tak xenrutak ta ewq'uin. Jara' profeta aj Israel, kas tey-a' c'a ewexquin tzrij nak xtbij chewa. Cara' xbij ja' Moisés chca. ");
INSERT INTO tzjE_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ja' mism Moisés c'ola chquecjol rtnamet Dios tak xquemol qui' chpam chkilaj lwar abar ec'o wa', y tzra' c'ola jun ángel xtzijona ruq'uin pe rwá' jyu' rbin-an Sinaí. Je xbixa tzra Moisés rmal ángel jara' xbixa chca kti't kawma' chka'. C'ola jle' tzij xbixa tzra rec'mon ta utzlaj c'aslemal rxin Dios jara' xtz'ibaj cana ch-utz c'ara' ajoj nokocwina nekc'axaj camic. ");
INSERT INTO tzjE_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Per j-e' kti't kawma' majo'n xecnimaj ta Moisés, j-e' c'ola cgan xemloj pe chta jmul chpam Egipto. ");
INSERT INTO tzjE_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Com cawra xecbij tzra Aarón: —Que'abna' jle' tioxa' je nquec'an chic kxin, com Moisés jxelsan ta kxin chpam Egipto abar le tzra' xoc wa' camic. Cara' xecbij. ");
INSERT INTO tzjE_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","C'jara' xquemaj rbanic jun rechbal wajquex. Tak xec'choja cmal xectzujuj jle' chcop chwech, jara' jun sacrificio. Congan jun nimlaj quicotemal xqueban rmal jxecwankersaj ruq'uin quek'a'. ");
INSERT INTO tzjE_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Per Dios xeruya' cana rmal c'ara' tak xeyojtaja, xe chwech ch'umil nquexque' chwa'. Cara' xqueban ajni' ctz'iban cana ojer je' profeta rxin Dios jcawra nbij: —Ixix ix tnamet Israel, tak xixc'je'a cawnak juna' chpam chkilaj lwar ¿le chenwech anen xetzujuj wa' chcop rxin sacrificio? ");
INSERT INTO tzjE_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Per mcara' ta xeban, per jxeban ixix xruk'ij je' tioxa' xeya' jxewankersaj ruq'uin ek'a'. Xe rc'ulibal Moloc xetelej ruq'uin rechbal jun ch'umil je rbin-an Renfán. Rmal c'ara' tak quenbij chewa, c'ola jun lwar quixnutak el wa' jmás na c'nat chwech Babilonia. Cara' xbij Dios tzra retnamet. ");
INSERT INTO tzjE_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Je kti't kawma' tak xebina chpam chkilaj lwar, j-e' xec'ana ruchoch Dios tz'um ruq'uin tziak ocnak. Chpam quey-on wa' tz'lem tak abaj abar tz'iban wa' rley Dios. Tak xqueban ruchoch Dios ncara' xqueban tzra ajni' c'tun chwech Moisés rmal Dios. Com Moisés xyataja tzra che xutz'et nabey mul nak nba'na tzra ruchoch Dios tak q'uemjana tumaj rij. ");
INSERT INTO tzjE_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","J-e' kti't kawma' tak xe'oc ta wawe' chpam tnamet jtzujun chca rmal Dios ne cc'an chquij ruchoch Dios tak Josué c'ayona cxin. Tak xe'oca chpam tnamet ec'o chic jle' wnak chpam per ja' Dios xelsan ela cxin ch-utz c'ara' j-e' kti't kawma' nec'je' cana chpam. Cara' c'a xqueban y ruchoch Dios wawe' xec'je' cwa' q'ue pe rtiemp rey David. ");
INSERT INTO tzjE_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David congan utz xtz'e'ta rmal Dios, ja' xrajo' ta xuban jun rtemplo Dios je Dios rxin Jacob. ");
INSERT INTO tzjE_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Per mja' ta David xebnowa rtemplo Dios com c'ola jun rlec'wal rubi' Salomón jara' xebnowa. ");
INSERT INTO tzjE_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Per nimlaj Dios majo'n nca'tzin ta tzra xtec'je' ta chpam je' templo je bnon cmal wnak. Com ajni' tz'ibtanak cana rmal jun profeta jcawra nbij: ");
INSERT INTO tzjE_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","—Ja' caj ocnak ntz'ulibal y rwech ruch'lew rexlanbal wkan. ¿Le nc'atzina neban jun wuchoch nech'ob ixix? ¿Le nc'atzina chwa anen che nechumij jun lwar abar quenxle'n wa'? ");
INSERT INTO tzjE_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Manen tc'a xenwankersana caj ruq'uin ruch'lew? Cara' nbij ja' Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ixix majo'n egan ruq'uin je nrajo' ranm Dios, xe ix junam cuq'uin wnak jmajo'n cutkin ta rwech Dios com majo'n neya' ta c'as tzra rtzojbal noca ptak ewanm next c'a ptak ewexquin chka'. Y majo'n neya' ta c'as che Espíritu Santo nc'ana ewxin. Ajni' xqueban ewti't ewma' ojer ncara' neban chic ixix camic chka'. ");
INSERT INTO tzjE_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Com j-e' next jun chca mquita xqueban lowlo' chca je' profeta. Xeccamsaj je' profeta jxeyowa rbixic che npe na Cristo je bnoy rbeyal rxin Dios. Y tak xpeta Cristo ixix xejach pquek'a' wnak je nquetzelana rxin y xec'utuj cmic tzrij. ");
INSERT INTO tzjE_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Cara' c'a xeban, je rley Dios, mesque n-ángel xyowa chewa per majo'n nenimaj ta. Cara' xbij Esteban chca e k'toy tak tzij. ");
INSERT INTO tzjE_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tak xecc'axaj je xbixa chca rmal Esteban congan xek'utluja rmal, kas neccach'ch'ej quey rmal cyiwal. ");
INSERT INTO tzjE_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Per Esteban nojnak Espíritu Santo pranm, kas xch'ulchij caj y xuc'ut ri' Dios chwech, xutz'et Jesús chka' prejquenk'a' Dios pa'l wa'. ");
INSERT INTO tzjE_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","—Tetz'ta' mpa', camic quentz'et caj jaktanak y quentz'et Jesucristo Rlec'walxel jxoca alxic kuq'uin pa'la prejquenk'a' Dios. Cara' xbij Esteban. ");
INSERT INTO tzjE_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Per congan xquemaj rakic quechi', xectz'apij quexquin y xeyictaja tzrij Esteban per ne che conjelal. ");
INSERT INTO tzjE_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Xquechap ela, xquelsaj ela chpam tnamet y xquemaj rcamsic tzan abaj. J-e' testigo jxetz'kowa tzij tzrij xecjalla' cana quetziak ch-utz c'ara' nquecwina nqueq'uiek abaj. Je' quetziak xechjalbex cana rmal jun c'jol rubi' Saulo. ");
INSERT INTO tzjE_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Esteban kas majtanak rq'uiekxic tzan abaj xumaj rij jun oración: —Wajaw Jesús, pnak'a' quenjach wa' wanm. ");
INSERT INTO tzjE_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","C'jara' xexque'a, xurak ruchi' y cawra xbij: —Wajaw, kas quenwajo' anen mquita xtaya' rec'xel je nqueban chwa. Tak xbitaja rmal xwar kaja. ");
INSERT INTO tzjE_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ja' Saulo utz xutz'et che xcamsasa Esteban. Jara' mism k'ij xmajtaja rbanic lowlo' chca kch'alal jec'ola pJerusalén y che conjelal kch'alal xquech'or je' qui'. Ec'ola nic'aj chca xeba chpam tak lwar jc'ola precwent Judea y nic'aj chic xeba precwent Samaria. Per j-e' apóstol majo'n xeba ta, xec'je' cana chpam tnamet Jerusalén. ");
INSERT INTO tzjE_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ec'ola nic'aj ach-i' congan ncajo' Dios j-era' xemkuwa rxin Esteban, congan ok'ej nqueban rmal je xba'na tzra. ");
INSERT INTO tzjE_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ja' Saulo xumaj rij lowlo' chca iglesia, jnuban jara' noca je' ptak jay abar ec'o wa' je' kch'alal, nquercherrej ta che ixki' ruq'uin ach-i' y nquerecsaj pcars. ");
INSERT INTO tzjE_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Je' kch'alal jxe'el ela pJerusalén y xeba chic pjun tnamet, tzra' xquemaj wa' rbixic utzlaj tzij je rxin Jesucristo. ");
INSERT INTO tzjE_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","C'ola jun chca Felipe rubi', arja' xba chpam jun tnamet jc'ola precwent Samaria. Tak xe'ekaja xumaj rbixic chca wnak nak rbanic Jesucristo. ");
INSERT INTO tzjE_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","J-e' c'a wnak tak xecc'axaj je xbij Felipe y tak xquetz'et nmak tak milagro xuban, che conjelal xqueya' quexquin tzrij je xbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Com e q'uiy je' wnak xechumtaja jec'ola itzel tak espíritu cc'an y j-e' itzel tak espíritu congan nquerak quechi' tak nque'el ela. Chka' xechumtaja je' sic ruq'uin je' wnak ch'e'y nquebina. ");
INSERT INTO tzjE_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Cara' c'a xbantaja y congan xquicota tnamet rmal. ");
INSERT INTO tzjE_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Per c'ola jun acha Simón rubi', arja' c'ola chpam jara' tnamet. Ja' Simón arja' aj-itz nabey, congan tz'koj tak tzij rebnon chca wnak aj Samaria y cawra nbij chca wnak: —Anen congan nim nuk'ij. ");
INSERT INTO tzjE_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","J-e' wnak congan necc'axaj je nbixa chca per ne che conjelal rija' ruq'uin ac'ala', y cawra necbij: —Ja' Simón c'ola nimlaj rpoder Dios ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","J-e' congan necc'axaj je nbixa chca com q'uiylaj tiemp tz'kon tzij chquewech rmal itz jnuban. ");
INSERT INTO tzjE_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Per ja' Felipe xuya' rbixic chca utzlaj tzij je' tzrij nak rbanic rgobierno Dios y tzrij Jesucristo. Tak xecnimaj je xbixa chca rmal Felipe c'jara' xeba'na bautizar che ixki' y che ach-i'. ");
INSERT INTO tzjE_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Chka' ja' mism Simón xnimaj je xbixa tzra rmal Felipe y xba'na bautizar. Tak xbantaja bautizar xbilaj ela Felipe. C'ola nmak tak milagro xba'na chwech y congan xel ta ranm tzrij tak xutz'et. ");
INSERT INTO tzjE_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","J-e' apóstol ec'o cana pJerusalén. Tak xerkaja rbixic cuq'uin che aj Samaria xecnimaj rtzojbal Dios c'jara' xquetak ela Pedro ruq'uin Juan cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pedro ruq'uin Juan tak xe'ekaja xqueban jun oración pquecwent aj Samaria ch-utz c'ara' nkaj ta Espíritu Santo cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Cara' xqueban com next jun kanak ta Espíritu Santo ruq'uin xerwara' ebnon chic bautizar prubi' Kajaw Jesús. ");
INSERT INTO tzjE_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pedro ruq'uin Juan xqueya' quek'a' pquewá' aj Samaria y xkaj ta Espíritu Santo cuq'uin. ");
INSERT INTO tzjE_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ja' Simón xutz'et che cmal apóstol tak xkaj ta Espíritu Santo cuq'uin aj Samaria tak xqueya' quek'a' pquewá'. Rmal je xbantaja ja' Simón xtzujuj jle' pak chca apóstol. ");
INSERT INTO tzjE_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Cawra xbij chca: —Tey-a' poder chwa anen ajni' c'ola ewq'uin ixix ch-utz c'ara' tak c'ola jun quenya' nuk'a' pe rwá' nkaj ta Espíritu Santo ruq'uin chka'. ");
INSERT INTO tzjE_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Per cawra xbixa tzra rmal Pedro: —Xjun ta xtba'na chawa ruq'uin apak xtquixrukix ta pk'ak' com nach'ob atet che ncatecwina nalok' tzan apak nak nsipaj Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Jawra samaj rxin Dios kamjon rbanic majo'n ak'a' tzra atet com xe m-utz ta awanm chwech Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ja itzel tak na'oj jamjon rch'obic pnawanm tey-a' cana y tc'utuj tzra Dios xtcatrucuy ta. ");
INSERT INTO tzjE_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Com anen nch'obtaja nmal che awanm congan lowlo' elnak chwech Dios y congan atrechpon itzel tak achnak. Cara' xbixa tzra ja' Simón. ");
INSERT INTO tzjE_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","—Tebna' jun nimlaj utzil, tebna' orar pnecwent, tc'utuj tzra Kajaw Dios ch-utz c'ara' mquita xtbantaja cara' chwa ajni' xabij kaja chwa. ");
INSERT INTO tzjE_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","J-e' c'a apóstol xquemaj rbixic chca wnak njelal jquetz'ton tzrij rc'aslemal Jesucristo y xqueya' rbixic rtzojbal Dios chka'. C'jara' xemloj pchic pJerusalén. Xek'axa chpam jle' chic tnamet cxin aj Samaria y xqueya' rbixic utzlaj tzij rxin Jesucristo. ");
INSERT INTO tzjE_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","C'ol c'a jun ángel xta'k ta rmal Kajaw Dios y ruq'uin Felipe xekaj wa' y cawra xbij tzra: —Felipe, catyictaja, jat tec'ma' ela bey je nba pJerusalén y nexle'a chpam tnamet Gaza. Cara' xbij ángel. Jara' jun bey je nk'axa chpam jun nimlaj chkilaj lwar. ");
INSERT INTO tzjE_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Xyictaja Felipe y xba. Kas remjon binem tak c'ola jun caret xutzu' pona cherren cmal quiej y tz'bula jun acha chpam. Jara' acha aj Etiopía, jun acha eunuco. Jara' acha congan nim ruk'ij com ja' ocnak tesorero chpam rgobierno Candace jreina rxin Etiopía. Ja' acha pJerusalén penak wa' abar xuya' wa' ruk'ij Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Y camic nemloja chpam rtnamet Etiopía. Tz'bula chpam caret y remjon rsic'sic rtzojbal Dios je rtz'iban cana profeta Isaías. ");
INSERT INTO tzjE_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Felipe cawra xbixa tzra rmal Espíritu Santo: —Jat awla' caret y catki'l oca ruq'uin. ");
INSERT INTO tzjE_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Xba alnak Felipe, tak xekaja ruq'uin caret xc'axaj acha remjon rsic'sic je rtz'iban cana profeta Isaías y cawra xc'axaj tzra: —¿Le nch'obtaja awmal jamjon rsic'sic? ");
INSERT INTO tzjE_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","—¿Nak tzra tak xtch'obtaja nmal tak next jun nech'bowa chenwech? Catojte' ta wq'uin, xbixa tzra ja' Felipe. ");
INSERT INTO tzjE_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Je rtzojbal Dios jremjon rsic'sic ja' acha cawra nbij: —Cara' xba'na tzra ajni' nba'na tzra jun carne'l tak nec'mar ela che ncomsasa, arja' majo'n achnak nbij chca je nquebnowa lowlo' tzra, cara' nuban ajni' jun carne'l tak nch'upuxa rlan je rc'an. ");
INSERT INTO tzjE_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Xruq'uix nqueya', me pril ta je nba'na tzra cmal e k'toy tak tzij. Je' wnak jec'ola pretiemp, arj-e' congan lowlo' xqueban com xeccamsaj. Cara' rtz'iban cana profeta Isaías. ");
INSERT INTO tzjE_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ja' acha cawra xbij tzra Felipe: —Tebna' jun utzil, tbij chwa ¿nak chu tzra nbij wa' tzij profeta, le tzra ja' kaja, o tzrij jun acha chic? ");
INSERT INTO tzjE_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ja' Felipe arja' xumaj rch'obic chwech nak rbanic tzij y xuch'ob chwech nak rbanic Jesús. ");
INSERT INTO tzjE_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kas quemjon binem chpam caret tak xequewla' jun ya'. —Tetz'ta' mpa' jun ya' la. ¿Mex utz quenba'na bautizar camic? Cara' xbij ja' acha. ");
INSERT INTO tzjE_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—Wneyke'a ac'u'x ruq'uin Jesucristo per ne che njelal ac'u'x y che njelal awanm jara' utz ncatba'na bautizar. Cara' xbixa tzra rmal Felipe. —Anen ykula nuc'u'x ruq'uin Jesucristo che arja' Rlec'wal Dios. Cara' xbij tzra Felipe. ");
INSERT INTO tzjE_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","C'jara' xuya' jun orden che npe'a caret y xekaj ta chpam y xe'oca chpam ya' che c-e'. C'jara' xba'na bautizar ja' acha rmal Felipe. ");
INSERT INTO tzjE_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tak xe'el ta pya' chek q'uenjlal xec'mar ela Felipe rmal Espíritu Santo. Ja' acha majo'n chic xutz'et xta rwech Felipe, xumaj chic wjic rubey y congan nquicota. ");
INSERT INTO tzjE_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ja' Felipe c'xuna' c'o pon chic chpam tnamet Azoto. Xumaj chic rubey y tak nk'axa ptak je' tnamet nuya' rbixic utzlaj tzij rxin Jesucristo. Cara' xuban y xekaja chpam tnamet Cesarea. ");
INSERT INTO tzjE_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ja' Saulo congan ryiwal chca kch'alal y remjon rconxic nak nuban chca che nquercamsaj. Rmal c'ara' tak xba ruq'uin nimlaj sacerdote. ");
INSERT INTO tzjE_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Tak xekaja ruq'uin cawra xbij tzra: —Ttz'ibaj nic'aj carta y naya' ela chwa che cnebna' presentar ptak jay rxin molbal ri'il jc'ola chpam tnamet Damasco ch-utz c'ara' quencwina cnecanoj je' wnak je cniman chic Jesús, y tak xtquenuwil quenucsaj pcars che ach-i' y che ixki' y quenuc'om pa wawe' pJerusalén. Cara' xbij ja' Saulo. ");
INSERT INTO tzjE_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Y cara' xuban xba chpam tnamet Damasco. Kas remjon binem y xchenkaj chic c'o wa' tnamet tak chek q'uenjlal c'ola jun luz xkaj ta chcaj y xuq'uiek ri' ruch'ab tzrij. ");
INSERT INTO tzjE_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Xkaja chuch'lew rmal luz y c'ola jun kul xtzijon ta y cawra xbij: —Saulo, Saulo ¿nak tzra tak naban lowlo' chwa? Cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","—¿At achnak wnak c'a atet wajaw? xbij ja' Saulo. —Anen en Jesús, chwa anen amjon wa' rij lowlo'. Xayon nacamsaj kaja awi' ajni' nuban jun chcop tak ruyon nerquiraj rwá' chwech jun che' ch'ut rutza'm, cara' naban atet. Cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ja' Saulo congan nberbeta y congan xel ta ranm je xbixa tzra: —Wajaw ¿nak nawajo' chwa chquenban? Cara' xbij tzra Jesús. —Catyictaja, jat chpam tnamet jc'ola chenkaj, tzra' nbix wa' chawa nak xtaban. Cara' xbixa tzra rmal Kajaw Jesús. ");
INSERT INTO tzjE_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","E rexbil Saulo congan xecxibej qui' com xecc'axaj jun kul je xtzijona per majo'n xecwin ta xquetz'et nak xtzijona. ");
INSERT INTO tzjE_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ja' Saulo xyictaja pnulew per majo'n chic nca'y ta, xoca moy. Rmal c'ara' xcha'p ela ruk'a' y xec'mar ela chpam tnamet Damasco. ");
INSERT INTO tzjE_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Oxi' k'ij xoca moy y majo'n achnak xutaj. ");
INSERT INTO tzjE_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","C'ola jun kch'alal chpam tnamet Damasco Ananías rubi'. Ja' Kjawal Jesucristo xuc'ut ri' chwech Ananías ajni' pnachic', cawra xbij tzra: —Ananías. —Wajaw ¿nak nawajo' chwa chquenban? Cara' xbixa tzra rmal Ananías. ");
INSERT INTO tzjE_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","—Camic jat tec'ma' ela bey je nbixa tzra Derecha y ncatba chruchoch Judas. Tak xtcatekaja, tzra' nacanoj wa' jun acha aj Tarso, Saulo rubi'. Ja' Saulo remjon rbanic oración camic. ");
INSERT INTO tzjE_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Y nutzu' ajni' pnachic' che atet xatba ruq'uin y xaya' ak'a' pe rwá' y xca'y chic jmul rk'arwech. Cara' xbij ja' Jesucristo. ");
INSERT INTO tzjE_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","—Per Wajaw, e q'uiy wnak nquebina chwa nak rebnon Saulo, congan lowlo' rebnon chca atnamet jec'ola pJerusalén. ");
INSERT INTO tzjE_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Y camic ulnak wawe' ra', y-on ta tzra cmal cjefe sacerdote che nokruchap y nokrucsaj pcars konjelal ajoj jneknataj abi'. ");
INSERT INTO tzjE_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","—Jat ruq'uin com arja' ocnak jun ajsmajma' jnech-on che nerey-a' nbixic chca wnak jme aj Israel ta, chka' chca je' reyes je nquebnowa mandar cxin, y chka' chca tnamet Israel. ");
INSERT INTO tzjE_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Y anen quenc'ut na chwech ajni' lowlo' xtutaj rmal nubi'. ");
INSERT INTO tzjE_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ja' Ananías xba. Tak xekaja xoca pjay y xuya' ruk'a' pe rwá' Saulo y cawra xbij tzra: —Wch'alal Saulo, ja' Kajaw Jesús xuc'ut ri' chawech tak amjon binem tak atpenak. Ja' takyon ta wxin awq'uin ch-utz c'ara' njaktaja ak'awech, y chka' nnoja Espíritu Santo pnawanm. ");
INSERT INTO tzjE_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tak xbitaja jawra tzra Saulo xtzak ta chuchi' rk'arwech ajni' rsojlal ch'u' y xca'y chic jmul c'jara' xyictaja y xba'na bautizar. ");
INSERT INTO tzjE_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","C'jara' xumaj w-im y xwanker chic jmul rchuk'a'. Y xec'je' na jun tiemp cuq'uin kch'alal tzra' chpam tnamet Damasco. ");
INSERT INTO tzjE_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","C'jara' xumaj rij che noca chpam je' jay rxin molbal ri'il cxin aj Israel y cawra rbixic xuya': —Ja' Jesús arja' Rlec'wal Dios. ");
INSERT INTO tzjE_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Conjelal wnak tak xecc'axaj je nbij Saulo congan xsa'cha cna'oj rmal y cawra xecbij chbil tak qui': —¿Le mja' tc'a wa' Saulo jcongan lowlo' xuban chca wnak pJerusalén jnecnataj rubi' Jesucristo? ¿Me rkanak tc'a wawe' ra' che nquerechpa' ela conjelal wnak jnecnataj rubi' Jesucristo che nquerecsaj pcars y nquerujach pquek'a' cjefe sacerdote? ");
INSERT INTO tzjE_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Per ja' Saulo congan chic nuya' rbixic rtzojbal Dios y congan k'alaj nuch'ob chquewech wnak che Jesús arja' Cristo je ch-on rmal Dios. J-e' c'a aj Israel jec'ola tzra' chpam tnamet Damasco arj-e' xsa'cha cna'oj com mesquier nch'obtaja cmal nak remjon rbixic Saulo. ");
INSERT INTO tzjE_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Xeyloja Saulo c'ola chpam tnamet Damasco tak j-e' aj Israel xecchumsaj che neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Per xekaja rbixic ruq'uin ja' Saulo nak nch'o'ba tzrij. J-e' che pk'ij y chak'a' queyben Saulo chuchi' nmak tak chibey jabar ncatel wa' chpam tnamet com ncajo' neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Per j-e' kch'alal c'ola jun nimlaj chquech xeccanoj, xqueya' Saulo chpam y chak'a' xeckasaj tzrij nimlaj tz'ak jk'otben rij tnamet, cara' xqueban tzra che xtotaja Saulo. ");
INSERT INTO tzjE_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","C'jara' xba Saulo pJerusalén. Tak xekaja, ja' xrajo' ta xec'je' ta cuq'uin kch'alal per arj-e' xecxibej qui' chwech com arj-e' majo'n necnimaj ta che ykul chic ruc'u'x ruq'uin Jesucristo. ");
INSERT INTO tzjE_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Per ja' Bernabé xc'ana rxin chquewech apóstol, xumaj rcholic chquewech nak xuban Saulo tak xutz'et Kjawal Jesús pbey tak xtzijona ruq'uin. Y xuchol chquewech chka' che ja' Saulo majo'n xxibej ta ri' xuya' rbixic rtzojbal Jesús chquewech wnak jec'ola chpam tnamet Damasco. ");
INSERT INTO tzjE_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","C'jara' ja' Saulo xc'u'la cmal kch'alal y xoca quexbil pJerusalén. ");
INSERT INTO tzjE_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Arja' majo'n nxibej ta ri' nuya' rbixic rtzojbal Kjawal Jesús. Tak xuya' rbixic chca aj Israel je nquetzijona pe griego arj-e' xecch'ojquij je nbixa chca y xquemaj rconxic rij rwech nak nqueban tzra che neccamsaj. ");
INSERT INTO tzjE_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","J-e' kch'alal tak xerkaja rbixic cuq'uin che njo'xa ncomsasa Saulo arj-e' xquec'om ela chpam tnamet Cesarea. Tak xekaja pCesarea xquetak el chic chpam tnamet Tarso. ");
INSERT INTO tzjE_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Je' iglesia jec'ola chpam Judea, jec'ola chpam Galilea, y chka' jec'ola pSamaria arj-e' qui'il chic ec'ola. Congan xeq'uiya chpam rtzojbal Dios y congan necxibej qui' chwech Kjawal. Y Espíritu Santo congan eret-on che xeba pnim. ");
INSERT INTO tzjE_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro arja' congan binem nuban che nquerk'ijla' je' kch'alal. Xuban jmul xba cuq'uin rtnamet Dios jec'ola chpam tnamet Lida. ");
INSERT INTO tzjE_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tak xe'ekaja, tzra' xuwil wa' jun acha Eneas rubi'. Ja' Eneas xuban waxki' juna' c'ola chwech rwarbal com xsic. ");
INSERT INTO tzjE_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ja' Pedro cawra xbij tzra: —Eneas, camic Jesucristo ncaterchumsaj, catyictaja, tchumij awarbal. Y cara' xuban ja' Eneas xchumtaja y xyictaj ela. ");
INSERT INTO tzjE_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Conjelal jec'ola chpam tnamet Lida e quexbil chka' jun chic tnamet Sarón, arj-e' xquetz'et che xchumtaja Eneas rmal c'ara' xqueq'uex cna'oj y xeyke'a quec'u'x ruq'uin Jesucristo. ");
INSERT INTO tzjE_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","C'o c'a jun kch'alal ixak chpam tnamet Jope, Tabita rubi'. Je chpam tzojbal griego Dorcas nbixa tzra. Ja' Dorcas c'ola utzlaj tak achnak rebnon, congan eret-on mibi'. ");
INSERT INTO tzjE_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ja' Pedro c'ola chpam tnamet Lida tak xeywaja Dorcas y xcoma. Xch'aja rij cmal kch'alal, tak xch'ajtaja rij xqueya' pjun jay jc'ola prucab wik. ");
INSERT INTO tzjE_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Je tnamet Lida xe mnim ta recjol ruq'uin tnamet Jope. Je' kch'alal jec'ola pJope cutkin che chpam tnamet Lida c'o wa' Pedro y xequetak ela e c-e' ach-i' ruq'uin che necsiq'uij. Tak xe'ekaja ruq'uin Pedro cawra xecbij tzra: —Camic okpenak ok siq'uiy awxin che ncatba alnak chpam tnamet Jope. ");
INSERT INTO tzjE_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ja' Pedro xetre' ela chquij ach-i' y xeba chpam tnamet Jope. Tak xe'ekaja xec'mar ela chpam jay abar c'o wa' comnak. Tzra' ec'o wa' jle' ixki' melcani' quemjon ok'ej y xquemaj rc'utic chwech Pedro njelal tziak jrebnon ja' Dorcas. ");
INSERT INTO tzjE_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ja' Pedro xerelsaj ela conjelal wnak jec'ola pjay abar c'o wa' comnak. Tak xe'el ela conjelal wnak xexque'a y xuban jun oración. C'jara' xba ruq'uin comnak y cawra xbij tzra: —Tabita, catyictaja. Ja' Dorcas xujak rk'arwech y tak xutz'et Pedro xetz'be'a. ");
INSERT INTO tzjE_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ja' Pedro xuchap chuk'a' y xuyic. C'jara' xersiq'uij ixki' je e melcani' e quexbil jle' chic kch'alal y xuc'ut Dorcas chquewech per c'astanak chic. ");
INSERT INTO tzjE_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Je xbantaja congan xela rbixic chpam tnamet Jope y e q'uiy wnak xeyke'a quec'u'x ruq'uin Kjawal Jesucristo. ");
INSERT INTO tzjE_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ja' Pedro xec'je' chna c-e' oxi' k'ij pJope. Ruq'uin jun acha tzcoy tz'um Simón rubi', tzra' xec'je' wa'. ");
INSERT INTO tzjE_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","C'o c'a jun acha chpam tnamet Cesarea, Cornelio rubi', arja' capitán cxin jle' soldado aj Italia nbixa chca. ");
INSERT INTO tzjE_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ja' Cornelio congan nuya' ruk'ij Dios y conjelal jec'ola pruchoch nqueya' ruk'ij Dios chka'. Ja' congan nqueruto' wnak y nuban oración chka'. ");
INSERT INTO tzjE_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Xuban jmul Cornelio com a las tres rxin tk'ak'ij nxutzu' bien jun ángel rxin Dios xerkaja ruq'uin, ajni' pnachic' xutz'et wa'. —Cornelio, cara' xbixa tzra rmal ángel. ");
INSERT INTO tzjE_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ja' Cornelio xera' xutzu' ángel, congan xxibej ri' y cawra xbij tzra: —Wajaw ¿nak nawajo' chwa? Ja' ángel cawra xbij chic tzra: —Ja' Dios rc'axan njelal aworación abnon, rutkin njelal to'ic ay-on chca wnak y jara' majo'n nmestaj ta. ");
INSERT INTO tzjE_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Camic que'atka' ela jle' ach-i' chpam tnamet Jope che necsiq'uij jun acha rubi' Simón y chka' nbixa tzra Pedro. ");
INSERT INTO tzjE_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ruq'uin jun acha tzcoy tz'um c'o wa', Simón rubi' chka'. Chuchi' mar c'o wa' ruchoch. Tak xterkaja Pedro awq'uin arja' nbina chawa nak xtaban. Cara' xbij cana tzra Cornelio. ");
INSERT INTO tzjE_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Xba ja ángel. Ja' Cornelio alnak xersiq'uij e c-e' ach-i' ajsmajma' y jun soldado. Jara' jun chca soldado jnuto' Cornelio y junlic c'ola ruq'uin y congan nuya' ruk'ij Dios chka'. ");
INSERT INTO tzjE_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tak xe'erkaja ruq'uin, ja' Cornelio xuchol chca njelal je xbixa tzra rmal ángel c'jara' xerutak ela chpam tnamet Jope. ");
INSERT INTO tzjE_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tak xuban nic'aj k'ij rxin rcab k'ij j-e' quemjon binem y q'uemjana te'ekaja chpam tnamet Jope. Jara' hor xojte'a Pedro pe rwá' terraza rxin jay abar c'o wa' che bnoy oración. ");
INSERT INTO tzjE_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Y xmajtaja rmal jun k'ak'nic rpam. Tak majtanak rchumsic rway rxin almuerzo xutz'et ajni' pnachic' jun achnak penak chcaj. ");
INSERT INTO tzjE_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Jxutz'et, xjaktaja caj chwech y xutz'et jun nimlaj mant xkaj ta chcaj ruyon penak y jtela che cji' rutza'm chcaj. ");
INSERT INTO tzjE_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","E congan e q'uiy chcop chpam y che njelal quewech chcop c'ola chpam. Ec'ola cajcaj ckan chcop chpam, ec'ola chcop jic necjuccuj qui' penlew, ec'ola chcop c'ola quexic'. ");
INSERT INTO tzjE_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tak xerutz'et jawra chcop c'ola nic'aj tzij penak chcaj y cawra xbixa tzra: —Pedro catyictaja, que'acamsaj j-ewra chcop y que'atja'. ");
INSERT INTO tzjE_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","—Wajaw, m-utz ta quenutaj j-ela chcop y nexte wjic enetjon ta, xjan nquekataj ajoj ok tnamet Israel com cara' nbij ley. Cara' xbij Pedro. ");
INSERT INTO tzjE_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Cawra xbix chic tzra Pedro y ja' tzij q'ue chcaj penak wa': —Per jara' chumsan chic rmal Dios, camic majo'n xjan xta. Per wmajo'n chic xjan ta chwech Dios mtabij xtc'a che xjan nataj. ");
INSERT INTO tzjE_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Oxmul xbixa cara' tzra Pedro c'jara' xojte'a jara' mant chcaj. ");
INSERT INTO tzjE_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","—¿Nak nbij c'a wa' jxentz'et? Cara' nbij kaja Pedro pranm. J-e' c'a ach-i' jetkon ela rmal Cornelio quemjon rc'axic abar c'o wa' ruchoch Simón. Ja' Pedro kas remjon rch'obic tak xe'ekaja j-e' ach-i' chijay. ");
INSERT INTO tzjE_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Cawra xecc'axaj: —¿Lwawe' c'o wa' jun acha Simón jc'o chic jun rubi' Pedro nbixa tzra? ");
INSERT INTO tzjE_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Tak c'remjon rch'obic Pedro cawra xbixa tzra rmal Espíritu Santo: —Ec'ola e oxi' ach-i' ncatccanoj. ");
INSERT INTO tzjE_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Camic catyictaja, catkaja cuq'uin. Jat chquij y mtaxibej ta awi' com anen entakyon ta cxin. Cara' xbixa tzra. ");
INSERT INTO tzjE_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ja' Pedro xkaj ta y xba cuq'uin ach-i', cawra xbij chca: —Anen c'ara' en Pedro jnecanoj ¿Nak newajo' chwa? ");
INSERT INTO tzjE_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","—Ajoj oktkon ta awq'uin rmal jun capitán Cornelio rubi'. Arja' jun acha bnoy rbeyal y nxibej ri' chwech Dios, y congan utz ntz'e'ta cmal conjelal aj Israel. C'ola jun ángel rxin Dios xbij tzra chnutak ta asic'sic ch-utz c'ara' ncatba ruq'uin che nc'axaj nak xtabij tzra. Rmal c'ara' okpenak awq'uin camic. ");
INSERT INTO tzjE_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","J-e' ach-i' xecsasa pjay rmal Pedro, tzra' xewar wa'. Pe rcab k'ij xba Pedro chquij y xetre' ela nic'aj kch'alal chquij jec'ola chpam tnamet Jope. ");
INSERT INTO tzjE_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Rox k'ij xekaja chpam tnamet Cesarea. Ja' Cornelio ereyben, ec'o chic jle' rch'alal ersiq'uin ruq'uin y chka' ec'ola jle' ramigos. Quemlon qui' queyben Pedro. ");
INSERT INTO tzjE_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ja' Cornelio tak xekaja Pedro chuchi' ruchoch xel ta pjay che rc'ulic. Tak xekaja ruq'uin xexque'a chwech Pedro y xumaj rya'ic ruk'ij. ");
INSERT INTO tzjE_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Per ja' Pedro xuyic y cawra xbij tzra: —Catyictaja, mtcatexque' ta chenwech com anen xen wnak, xok junam awq'uin, cara' xbij tzra Cornelio. ");
INSERT INTO tzjE_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kas remjon tzij ruq'uin Cornelio tak xoc oca pjay y e q'uiy wnak xerutz'et quemlon qui' pjay. ");
INSERT INTO tzjE_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Xumaj tzij cuq'uin y cawra xbij chca: —Ixix ewutkin che kreligión ajoj ja ok tnamet Israel nuc'ut chkawech che xjan nok-oca ewexbil jme ix aj Israel ta, o wnok-oca ptak ewuchoch. Per Dios xuc'ut chenwech che me tkal xta chwij xtenbij ta tzra jun wnak che xjan quenxbilaj chka bechnak wnak opech. ");
INSERT INTO tzjE_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Rmal c'ara' anen tak xta'ka nsic'sic majo'n nak xenbij chca jxesiq'uina wxin y xenpeta alnak. Camic tbij chwa nak rmal tak xnesiq'uij. Cara' xbij chca. ");
INSERT INTO tzjE_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ja' Cornelio cawra xbij tzra Pedro: —Camic xuban cji' k'ij ctakwra hor nemjon rbanic ayuno, y ptak a las tres rxin tk'ak'ij tak nemjon rij oración chpam wuchoch chek q'uenjlal xwankera jun acha chenwech, rucsan jun tziak congan nyic'loja y chka' congan ruch'ab. ");
INSERT INTO tzjE_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Xumaj tzij wq'uin y cawra xbij chwa: —Cornelio, Dios rc'axan aworación jabnon y chka' majo'n rmestan ta njelal to'ic jay-on chca wnak. ");
INSERT INTO tzjE_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Camic que'atka' ela jle' ach-i' chpam tnamet Jope che necsiq'uij jun acha Simón jc'o chic jun rubi' Pedro nbixa tzra, ruq'uin jun acha tzcoy tz'um c'o wa', Simón rubi' chka' y chuchi' mar c'o wa' ruchoch. Tak xterkaja, ja' 