﻿USE sofia;
DROP TABLE IF EXISTS sofia.tyx_vpl;
CREATE TABLE tyx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tyx_vpl WRITE;
INSERT INTO tyx_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Musyi a dzumu li Yiisu-Kriste, Dabvide, li nkagha-kwuru a Yiisu, Abarahame li nkagha-kwuru a Dabvide. ");
INSERT INTO tyx_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abarahame áburu Idzake, Idzake áburu Dzakobe, Dzakobe áburu Yuda ya bambwee ya banaana ba nde ba babaghala. ");
INSERT INTO tyx_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda áburu Faredze ya Dzara mu Tamare. Faredze áburu Eserõ, Eserõ áburu Arame. ");
INSERT INTO tyx_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arame áburu Aminadabe, Aminadabe áburu Naasõ, Naasõ áburu Salamone, ");
INSERT INTO tyx_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamone áburu Bohese mu Rahabe. Bohese áburu Obede mu Rute, Obede áburu Yese, ");
INSERT INTO tyx_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese áburu mukogho Dabvide. Dabvide áburu Salomõ mu mukala a Uri, ");
INSERT INTO tyx_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomõ áburu Roboame, Roboame áburu Abiya, Abiya áburu Adzafe, ");
INSERT INTO tyx_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Adzafe áburu Dzodzafate, Dzodzafate áburu Dzorame, Dzorame áburu Odzyase, ");
INSERT INTO tyx_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Odzyase áburu Yohatame, Yohatame áburu Akadze, Akadze áburu Edzekyase, ");
INSERT INTO tyx_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Edzekyase áburu Manase, Manase áburu Amose, Amose áburu Dzodzyase, ");
INSERT INTO tyx_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Dzodzyase áburu Dzekonya ya bambwee ya banaana ba nde ba babaghala mu ena ki bábiri baara mu minsunughu ku Babilone. ");
INSERT INTO tyx_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ŋa mbihi a ŋa bábiri baara mu minsunughu ku Babilone, Dzekonya áburu Salatyele, Salatyele áburu Dzorobabele, ");
INSERT INTO tyx_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Dzorobabele áburu Abiwude, Abiwude áburu Elyakime, Elyakime áburu Adzore, ");
INSERT INTO tyx_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Adzore áburu Sadoke, Sadoke áburu Akime, Akime áburu Eliwude, ");
INSERT INTO tyx_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliwude áburu Eleyadzare, Eleyadzare áburu Matane, Matane áburu Dzakobe, ");
INSERT INTO tyx_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Dzakobe áburu Dzodzefe mulumu a Mari, me mu nde báburu Yiisu wu baakata Kriste. ");
INSERT INTO tyx_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mu obo, mu obaana Abarahame tee Dabvide, biseene bili kwumu ya bina (14). Mu obaana Dabvide tee mu ena ki bábiri baara mu minsunughu ku Babilone, biseene bili kwumu ya bina (14). Ya mu obaana matala mamo tee etsughu ki báburu Kriste biseene bili kwumu ya bina (14). ");
INSERT INTO tyx_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bu me bu báburu Yiisu-Kriste: Ngughu a nde Mari áli mukaha wu ógwi Dzodzefe bilyimi. Lo nsomo bakala nzo mo, Mari ákeghele mu lileene li Mufulu a Ngili. ");
INSERT INTO tyx_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Dzodzefe mulumu a nde, áli mbwuru wu bunsumu. Ya nde bu ágwene odzyi otwuhu Mari budzwa ŋa mihi mi baara, nde ábagha bitsimi bii okahaba bala mu ensweghe. ");
INSERT INTO tyx_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mu matala ma ákabulutsimi nde obo, ngye-yulu a Mfumu áyamoŋono a nde mu nzolo ya ályele kundaa nde ti: «Dzodzefe mwana a Dabvide, ka bara nzalamweẽ mu ogwolo Mari, mukala a we mu nzo a we o. Mu kuulu, mu lileene li Mufulu a Ngili nde aakeghele. ");
INSERT INTO tyx_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nde sa aburu mwana wu baghala ya we sa gwa nde nkwumu Yiisu, mu kuulu nde sa abvwuhu baara ba nde mu masumu ma bo.» ");
INSERT INTO tyx_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mandagha mwohono mamo mámoŋono mu kuulu mi ólyele Mfumu mu mubighili mikeele: ");
INSERT INTO tyx_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Mono, mutughu wu munkyini sa akeghele. Nde sa aburu mwana wu baghala, ya sa bata nde mu nkwumu yi a Emanwele.» Mbaala ti: «Nzaami ŋa kara li bihi-a-be.» ");
INSERT INTO tyx_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bu asighili kunsa ensama, Dzodzefe ási bwunu a bu ótumu nde ngye-yulu a Mfumu, ya ágwolo mukala a nde álo nde mu nzo. ");
INSERT INTO tyx_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Lo nde ka ábvughu mbughu ya Mari o, tee matala ma áburu nde mwana wu baghala wu ágwi nde nkwumu Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Báburu Yiisu ku Beteleeme, mu nsie yi a Yude, mu matala ma óli Erode mukogho. Mono, banga-a-mayele báfi ku ookapala tala, ya báyato ŋa Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ya bákabulufwulu ti: «Mukogho a ba-Dzwife wu baaburu kunu ali? Mu kuulu bihi liimono ŋomaŋomo a nde ku ookapala tala, ya bihi liigyi mu oyagwa nde baana.» ");
INSERT INTO tyx_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mukogho Erode bu agyughu obo, nde ya baara ba Yerusaleme bwohono, mikolo mi bo míkala maã-maã. ");
INSERT INTO tyx_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nde ábvughu bakwuru ba bangaa ba nzaami bwohono ya baluo-mikyene ba báli ŋa kara li ekaana, ya áfwulu bo kunu-ako bafaana oburu Kriste. ");
INSERT INTO tyx_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ya bo bályele kundaa nde ti: «Ku Beteleeme, lili Yude, mu kuulu mubighili ásono bu: ");
INSERT INTO tyx_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“We Beteleeme, mu nsie yi a Yude, We ka li ebvu-bvulu ŋa kara li mabvulu mama Yude o. Mu kuulu, me mu we akala oopala mfumu, Wu aabiri Isarayele, baara ba me.”» ");
INSERT INTO tyx_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mu obo, Erode bu ati banga-a-mayele mbili mu ensweghe, ásagha ogyighili ogyahaba kundaa bo munsa matala ŋomaŋomo aamoŋono. ");
INSERT INTO tyx_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ya nde ágweghe bo ku Beteleeme ya ályele ti: «Ligye ligyighili ofwulu baara mu mi mitala mwana, ya be limana omono nde, liyalyele me, mu kuulu mehe si ngye yingwa nde baana.» ");
INSERT INTO tyx_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bo bu bamana ogyughu mi ólyele mukogho, bágyene. Ya bo báfirimono ŋomaŋomo wu bámono bo ku ookapala tala, ákatswama ku nkulu a bo, tee ku áyitemene nde mu engye-angye ŋa ebini ki óli mwana. ");
INSERT INTO tyx_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bu bamono ŋomaŋomo, bo básomo kunsa muyayaã wu alagha. ");
INSERT INTO tyx_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bu basomo munsa nzo, bámono mwana ya Mari, ngughu a nde. Bo bábwi masu mu nsie mu ogwa nde baana. Bádzubulu bimpogholo bi bo, ya bágwi nde bikaba: Oore, muyiri ya mananaase mama miire. ");
INSERT INTO tyx_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ŋa mbihi, Nzaami ágyehe bo mu nzolo, banyaã obvughuru kundaa Erode. Bo bábvughuru ku nsie a bo mu nzili nkimi. ");
INSERT INTO tyx_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Banga-a-mayele bu babvughuru, ngye-yulu a Mfumu áyamoŋono kundaa Dzodzefe mu nzolo ya ályele nde ti: «Temene, gwolo mwana ya ngughu a nde, bara a bo ku Edzipite. Yikala oko tee mu matala ma akala aandyele me we ti bvughuru. Mu kuulu, Erode sa asagha mwana mu kuulu adzwa nde.» ");
INSERT INTO tyx_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mu mpyibi gyini oyo, Dzodzefe átemene, ágwolo mwana ya ngughu a nde, ya áyisweme ku Edzipite. ");
INSERT INTO tyx_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nde ákala oko tee matala ma ókpi Erode. Myehene mimye, mu kuulu mandagha ma ólyele Mfumu mu muŋma a mubighili makeele: «Me aanti mwana a me mbili, apala mu Edzipite.» ");
INSERT INTO tyx_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Erode bu amono ti banga-a-mayele baapfiri nde, nde ákolo nkehe yi alagha. Ya nde ágweghe bambumbulu ku Beteleeme ya mu bitsulu bi nsie bi nde byehene, mu kuulu bayidzwa biba-baana bibi babaghala byehene bibi bamvulu buolo, ya ku nsie, embe-embe ya matala ma ólyele nde banga-a-mayele. ");
INSERT INTO tyx_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Oŋo me ŋa ótswughu ndagha yi ólyele mubighili Dzeremi ti: ");
INSERT INTO tyx_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Likyi li lili mu ofa ku Rama, Likyi li bilili ya minyoõ mi milagha. Rasyele li mu olili baana ba nde. Ya nde aabihi babuono nde, mu kuulu baana ba nde ka baafirisyili o.» ");
INSERT INTO tyx_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erode bu akpi, ngye-yulu a Mfumu áyimoŋono kundaa Dzodzefe mu nzolo ku Edzipite, ");
INSERT INTO tyx_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ya ályele kundaa nde ti: «Temene, gwolo mwana ya ngughu a nde, ya bvughuru ku nsie yi a Isarayele, mu kuulu babo ba baakasagha odzwa mwana baakpi». ");
INSERT INTO tyx_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dzodzefe átemene, ágwolo mwana ya ngughu a nde, ya ábvughuru ku nsie yi a Isarayele. ");
INSERT INTO tyx_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lo nde bu agyughu ti Arakelaose li mu okatumu nsie a Yude ŋa ebini e taara a nde Erode, Dzodzefe ámono nzalamweẽ mu ogye oko. Nzaami bu agyehe nde mu nzolo, nde áyisweme ku bitsulu bi nsie bibi ku Ngalile. ");
INSERT INTO tyx_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Bu ato, nde áyikala mu bvulu lili Nadzarete, mu kuulu mandagha ma ólyele mibighili magye mu mana: «Sa balyele nde ti nde musi Nadzarete.» ");
INSERT INTO tyx_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mu bitsughu bibye, Dzã Muboghoro ámoŋono ku syehe lili Yude, ákabuluta mukwughu wu: ");
INSERT INTO tyx_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Ligyiŋi mayele, mu kuulu Emfumu ki Mayulu eebehene!» ");
INSERT INTO tyx_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Wu me munde wu ókabighili mubighili Edzayi, ŋa ályele ti: «Likyi li munde wu li mu okakehe engumbu ku syehe: Ligyighili nzili a Mfumu, lisa mankwulu ma nde makala nsumu!» ");
INSERT INTO tyx_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Dzã, áli a enkuru ki bátwu mu mfu a nyama wu a nkwumu syamo, ya ákuru musili wu a mu nkobo a nyama mu bala li nde. Nde ákabuludza bansense ya nyuŋu wu ebiri. ");
INSERT INTO tyx_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Baara baba Yerusaleme, baba Yude lwohono, ya baba etsulu e nsie kyehene kii Dzurudẽ, bákagye kundaa nde, ");
INSERT INTO tyx_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ya nde ákaboghoro bo mu nzala yi a Dzurudẽ bu bákakihi masumu ma bo ŋa mihi mi baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bu amono ba-Faridzyẽ balagha ya ba-Saduseyẽ ba bákagya kundaa nde mu kuulu nde aboghoro bo, nde ályele kundaa bo ti: «Etswumu ki bampili! Nande aasuo be bu liibara nkehe a Nzaami yili mu ogya? ");
INSERT INTO tyx_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Liikasuo mu bigyighili ti be liigyiŋi mayele. ");
INSERT INTO tyx_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ya ka likakala a bitsimi bi mu beme o ti: “Taara a bihi Abarahame!” Mu kuulu, me ndyele be ti: Nzaami kughu okirili mameẽ ma makala baana kundaa Abarahame! ");
INSERT INTO tyx_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ekwu ayi baatwulu mu otsyiri midza mi miti. Mu obo, nswe muti wu aagwene okaburu bimburu bi bibwe, sa bakpaa nde ya batsili nde ku mbaa. ");
INSERT INTO tyx_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Me ndi mu okaboghoro be mu madza mu nkooro a ogyiŋi mayele. Lo munde wu li mu ogya ŋa mbihi a me, bvulu me mpini, me ka nkughu onyana misyi mi bikoghoro bi nde o. Nde sa aboghoro be mu Mufulu a Ngili ya mu mbaa. ");
INSERT INTO tyx_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nde li a nkwogho yi mampala ŋa kwogho e nde mu okabala bimburu ya bisagha, sa akwomo mbala a nde, sa akwu bimburu bi bele bi nde kunsa etaghala, lo sa atsughu bisagha ku mbaa yi aagwene okadzimi.» ");
INSERT INTO tyx_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ŋa mbihi oŋo, Yiisu fi ku Ngalile, gyi ku Dzurudẽ kundaa Dzã mu kuulu aboghoro nde. ");
INSERT INTO tyx_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lo Dzã ka ákadzyi o, ya ályele kundaa nde ti: «Me ndi a nzala ati baboghoro me kundaa we, lo we firigya kundaa me!» ");
INSERT INTO tyx_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yiisu ábvuhulu kundaa nde ti: «Mu matala ma, nyaã okala obo. Mu kuulu ofaana okala obo kundaa bihi a we mu kuulu likuhu myehene mi ookatumu Nzaami.» Oŋo Dzã ákihi. ");
INSERT INTO tyx_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bu basaaboghoro nde, ŋaana oŋo Yiisu ápala mu madza. Ya mono, mayulu mádzubulu kundaa nde, ya nde ámono Mufulu a Nzaami mu okayakumunu ti beeme, ya gyi ŋa yulu a nde. ");
INSERT INTO tyx_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ya ndagha yífi mu mayulu ya yílyele ti: «Wu me Mwana a me wu mukolo. Mu nde me aankamono esee.» ");
INSERT INTO tyx_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ŋa mbihi oŋo, Mufulu ábiri Yiisu ku syehe, mu kuulu dyabulu agyeele nde. ");
INSERT INTO tyx_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yiisu bu akuru nswele mu bala mu bitsughu makwumu mana (40) ya mampyibi makwumu mana (40), ku masini, nzala yífuru nde. ");
INSERT INTO tyx_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nga-a-bigyeele áyasele ya ályele kundaa nde ti: «Kala ti we li Mwana a Nzaami, sa ti mameẽ ma makighiri mampa.» ");
INSERT INTO tyx_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Lo Yiisu ábvuhulu kundaa nde ti: Básono ti: Mbwuru ka akala mweẽ yini a mu mampa o, lo mu mandagha mwohono ma maakapala mu muŋma a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Oŋo dyabulu ábiri nde ku Yerusaleme, bvulu lili ngili, átwulu nde ku yulu a nsweẽ a Nzo a Nzaami, ");
INSERT INTO tyx_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ya ályele kundaa nde ti: Kala ti we li Mwana a Nzaami, bwa ku nsie, mu kuulu básono ti: Nde sa agwa litumu kundaa bangye-yulu ba nde mu nkooro a we, ya bo sa bagyagha we mu myaã mi bo, mu kuulu kwulu e we enyaã okubu limeẽ. ");
INSERT INTO tyx_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yiisu ábvuhulu kundaa nde ti: Básono si ti: Ka agyeele Mfumu Nzaami a we o. ");
INSERT INTO tyx_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Dyabulu áfiribiri nde ku yulu a munguo wu a nkara mutele. Nde ásuo nde bimfumu bi nsie byehene ya nsia a bye, ");
INSERT INTO tyx_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ya ályele kundaa Yiisu ti: «Me sa ngwa we bilogho byehene bi, kala ti we kunu mabuo ŋa nkulu a me mu ogwa me baana.» ");
INSERT INTO tyx_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mu obo Yiisu ályele kundaa nde ti: «Satana, mara ŋa bele a me! Mu kuulu básono ti: We Mfumu Nzaami a we faana obuono, ya yini a nde we faana osamana». ");
INSERT INTO tyx_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Oŋo dyabulu ányaã nde, ya mono, bangye-yulu báyabehene ya nde ya bábaana osalala nde. ");
INSERT INTO tyx_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yiisu bu agyughu ti baalo Dzã mu boloko, nde ágyene ku Ngalile. ");
INSERT INTO tyx_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nde ásihi Nadzarete ya áyikala ku Kaperenawume, mu bele a mubu, mu etsulu e nsie kii Dzabulõ ya Nefetali, ");
INSERT INTO tyx_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","mu kuulu mandagha ma ólyele mubighili Edzayi makeele: ");
INSERT INTO tyx_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Etsulu e nsie kii Dzabulõ, etsulu e nsie kii Nefetali, nzili yi a mubu, ku ngulu a Dzurudẽ, Ngalile lili baara baala ka bali ba-Dzwife o! ");
INSERT INTO tyx_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Baara ba báli kunsa mpyibi yi a laŋa-laŋa, baamono otsyeme ku onene, ya kundaa babo ba bali kunsa edzwunu kii lipfu, otsyeme omoŋono! ");
INSERT INTO tyx_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Obaana matala mamo, Yiisu ábaana oluo ya ákabululyele ti: «Ligyiŋi mayele mu kuulu Emfumu ki Mayulu eeyabehene!» ");
INSERT INTO tyx_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Bu ákabuludzye mu mukogho a mubu a Ngalile, Yiisu ámono baana buolo ba taara mumõ, Simõ wu baakata ti Piere ya Andere mbwee a nde, mu okatere likoho mu mubu, mu kuulu bo báli bilebe banswi. ");
INSERT INTO tyx_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nde ályele kundaa bo ti: «Linama me, ya me sa nsa be bilebe baara.» ");
INSERT INTO tyx_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ŋaana oŋo, bo basaabulunyaã nkoho a bo, ya banama nde. ");
INSERT INTO tyx_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bu afirisehe ŋa nkulu, nde áfirimono baana buolo bakimi ba taara mumõ: Dzake ya Dzã, baana ba Nzebede ba babaghala munsa bwara bu bunene. Bo báli ya taara a bo Nzebede mu okagyighili nkoho. Yiisu áti bo mbili. ");
INSERT INTO tyx_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ŋaana oŋo, bo básaabulunyaã bwara bu bunene ya taara a bo ya bánama nde. ");
INSERT INTO tyx_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yiisu ákabulugye mu etsulu e nsie kii Ngalile kyehene, mu okabululuo munsa manzo mama lisamana ma ba-Dzwife, ya ákabulutsala Nsia yi Mbwe yi a Emfumu. Nde ákabuludzuhu mabyele mwohono ya bipfwumu byehene ŋa kara li baara. ");
INSERT INTO tyx_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nsia a nde yítsaŋama mu Siiri lwohono. Ya bákayabiri kundaa a nde baara bwohono ba báli a mabyele mama mawa-mawa ya ba bákamono mpara: banga a mifulu mi mibi, banga a nzyere, ba ópki binama, ya nde ákadzuhu bo. ");
INSERT INTO tyx_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ya mampwumu ma baara ma máfi ku Ngalile, ku etsulu e nsie kii mabvulu-kwumu, ku Yerusaleme, ku Yude, ya ku ngulu a Dzurudẽ, mábwi onama nde. ");
INSERT INTO tyx_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yiisu bu amono mampwumu ma baara, ákumu ku yulu a munguo, ya bu abwi nsini, binduono bi nde bísele kundaa nde. ");
INSERT INTO tyx_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Bu atsughu ndagha, nde ábwi oluo ya olyele bo ti: ");
INSERT INTO tyx_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Esee kundaa bawele mu Mufulu, mu kuulu Emfumu ki Mayulu eli kii ndaa bo! ");
INSERT INTO tyx_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Esee kundaa ba bali mu okalili, mu kuulu Nzaami sa abuono bo! ");
INSERT INTO tyx_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Esee kundaa babo ba bali badzuunu, mu kuulu bo sa babagha pfa li nsie yi ósiini a bo Nzaami! ");
INSERT INTO tyx_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Esee kundaa babo ba bali a nzala ya nyoro a bunsumu, mu kuulu bo sa bagyughuru! ");
INSERT INTO tyx_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Esee kundaa babo ba baakamono bana nyiĩ, mu kuulu sa bamono bo si nyiĩ! ");
INSERT INTO tyx_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Esee kundaa babo ba bali a mikolo mimi tse-tsee, mu kuulu bo sa bamono Nzaami! ");
INSERT INTO tyx_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Esee kundaa babo ba baakasa ti edzuunu ekala, mu kuulu sa bata bo baana ba Nzaami! ");
INSERT INTO tyx_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Esee kundaa babo baala bali mu okamwehẽ bo kimini mu nkooro a bunsumu, mu kuulu Emfumu ki Mayulu eli kii ndaa bo! ");
INSERT INTO tyx_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Esee kundaa be kala ti baara batughu be, bamwehẽ be kimini, ya babili mandagha mwohono ma mabi mama mpya mu be, mu nkooro a me. ");
INSERT INTO tyx_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Likala a emiini ya likala kunsa muyayaã! Mu kuulu mufuru a be mu mayulu li munene. Me obo si bákamwehẽ mibighili mi mítswama nsomo ya be kimini.» ");
INSERT INTO tyx_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Be lili munbga a nsie. Lo, kala ti munbga ka afirisyili a ese o, lo mu ema bakughu ofiribvurulu nde kye? Lo nde ka afirisyili a esala o. Bafaana otsili nde ku mbala ya baara badzyara nde. ");
INSERT INTO tyx_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Be lili otsyeme o nsie nsyini. Bvulu li bátwu ŋa yulu a munguo ka likughu osweme o. ");
INSERT INTO tyx_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ka baakanahaba mwindi ya bafughu nde nkuru o, lo baakatwulu nde ŋa yulu a ebini ki baakwulu mwindi, ya nde aakagwa otsyeme kundaa baara bwohono ba bali munsa nzo. ");
INSERT INTO tyx_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mu obo, nyaã otsyeme o be omoŋono ŋa mihi mi baara bwohono, mu kuulu bo bamono bigyighili bi be bi bibwe, ya basyighi Taara a be wu li mu mayulu.» ");
INSERT INTO tyx_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Ka litsimi o ti me aangyi mu oyatsala Mikyene mi Moyidze bwunu we maluo ma mibighili. Me ka aangyi mu otsala o, lo mu osa kuulu ti mye mikeele. ");
INSERT INTO tyx_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mu engaŋma me ndyele kundaa be ti, tee mu matala ma ooluru yulu ya nsie, lo ti esono kii nkwumu i, bwunu we empi-mpiri ki esono nga-emõ, ka bamaha kye mu Mikyene o, tee ŋa ookeele mandagha mwohono. ");
INSERT INTO tyx_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mu obo, nswe munde wu aatsala mukyene si mumõ mu mi mibvulu busala mi, ya luo baara mu osa bumõ, sa bata nde wu bvulu busala mu Emfumu ki Mayulu. Lo munde wu aasalala mye ya aaluo mye, sa balyele ti nde mbwuru wu munene mu Emfumu ki Mayulu. ");
INSERT INTO tyx_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Me ndyele kundaa be ti, kala ti bunsumu bu be ka bubvulu bubu ndaa baluo-mikyene ya bubu ndaa ba-Faridzyẽ o, lo be akala ka lisomo mu Emfumu ki Mayulu o.» ");
INSERT INTO tyx_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Be áli liigyughu bályele kundaa bakwuru ti: “Ka dzwa o”. Munde wu aadzwa bafaana osa nde muyala. ");
INSERT INTO tyx_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lo me, me ndyele kundaa be ti: Nswe munde wu aakolo nganda-mbwuru a nde nkehe, bafaana osa nde muyala. Munde wu aalyele nganda-mbwuru a nde ti: “Ewulu!” Bafaana osa nde muyala kundaa Ekwuru ki ba-Dzwife. Munde wu aalyele ti: “Nga-a-lala!” Lo bafaana otubu nde ku mungele a mbaa. ");
INSERT INTO tyx_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Lo kala ti we li mu ogwa ekaba ŋa ebini ki baakagwa bikaba, ya we libili mweẽ ti nganda-mbwuru li a ndagha ya we, ");
INSERT INTO tyx_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","lo nyaã ekaba e we oŋo, matswama yigwihini ya nde, ŋa nseele sa yabvughuru ya gwa ekaba e we. ");
INSERT INTO tyx_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Sa maswa mu ogwihini ya mbwuru wu liibaŋana ya we, ŋaala be ya nde nkini lili mu nzili. Kala pele, nde sa atyeghe we kundaa nsughu a lamana, nsughu a lamana sa agwa we ŋa myaã mi bambumbulu, ya bambumbulu sa balo we munsa boloko. ");
INSERT INTO tyx_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mu engaŋma me ndyele kundaa we ti: We ka apala omo o, tee ŋa aamana ofiri we mupara wu masini mu ebyimi ki li a we.» ");
INSERT INTO tyx_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Be áli líigyughu bályele ti: “Ka bvughu mbughu ya mulumu bwunu we ya mukala a nganda-mbwuru o.” ");
INSERT INTO tyx_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lo, me ndyele kundaa be ti: Nswe mbwuru wu aatala mukaha ya sughu mukolo mu nde, nde maabvughu mbughu ya nde munsa mukolo a nde. ");
INSERT INTO tyx_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kala ti lihi li we lili ku ngo-kwogho liikabwihi we mu masumu, sogholo lo ya tsili lo la ya we. Mu kuulu, obvulu bubwe kundaa we mu opfihili esighi emõ mu bisighi bi nyuru a we, ya banyaã otsili nyuru a we yohono ku mungele a mbaa. ");
INSERT INTO tyx_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kala ti ngo-kwogho e we eekabwihi we mu masumu, tsyiri kye ya tsili kye la ya we. Mu kuulu, obvulu bubwe kundaa we mu opfihili esighi emõ mu bisighi bi nyuru a we, mu kuulu nyuru a we yohono yinyaã ogye ku mungele a mbaa.» ");
INSERT INTO tyx_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Báfirilyele si ti: “Kala ti mbwuru byi mukala a nde, lo agwa nde mukaana wu ookpi bala.” ");
INSERT INTO tyx_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lo me, me ndyele kundaa be ti: “Nswe munde wu aabyi mukala a nde, kala ti ka oli mu nkooro a enkwunu o, lo nde sa atsiini nde mu obwa mu bukala. Ya kala ti mbwuru kye mukaha wu baabyi ku bala, lo nde bwi mu bukala.”» ");
INSERT INTO tyx_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Be áli líifirigyughu bályele kundaa bakwuru ti: “Ka laba mukihi wu a mpya o, lo we faana ogyighili ndagha yi álaba we mukihi kundaa Mfumu”. ");
INSERT INTO tyx_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lo me, me ndyele kundaa be ti, si okala a bunu, ka likalaba mukihi o, ngu okala mu nkwumu a yulu, mu kuulu lilo likubu li Nzaami. ");
INSERT INTO tyx_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ngu okala mu nkwumu a nsie, mu kuulu yo yili ebini ki ookatwulu Nzaami myili, ngu okala mu nkwumu a Yerusaleme. Mu kuulu lo lili bvulu li Mukogho wu Munene. ");
INSERT INTO tyx_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ka laba mukihi mu mutswi a we si o, mu kuulu we ka kughu osa ti lifu si limõ lipeŋeme bwunu we lipyini o. ");
INSERT INTO tyx_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nyaã mbiili a we yikala kala “heẽ” lo “heẽ”, kala “pele”, lo “pele”. Mandagha mwohono ma baakabwehe ŋa yulu kundaa Nga-a-bubi maakafa.» ");
INSERT INTO tyx_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Be áli liigyughu bályele ti: “Lihi mu lihi, ya lyini mu lyini”. ");
INSERT INTO tyx_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lo me, me ndyele kundaa be ti: Kala ti mbwuru si be bubi, ka libvurulu nde etere o. Lo, kala ti mbwuru kaha we limpala mu tama lili ku ngo-kwogho, taama nde si tama li like. ");
INSERT INTO tyx_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kala ti mbwuru dzyi osa we mumfwunu mu kuulu agwolo enkuru e we kii butulu, gwa nde si enkuru e we ki ela kii kobo. ");
INSERT INTO tyx_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kala ti mbwuru si we enkwili mu odzyara mankpaã pfwunu (1 000) mu myili ya nde, lidzyara mapfwunu mwolo (2 000) ma mankpaã ya nde. ");
INSERT INTO tyx_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Gwa kundaa munde wu aaluomo we. Kundaa munde wu dzyi osuomo kundaa we, ka bihi o.» ");
INSERT INTO tyx_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Be áli líigyughu bályele ti: “Dzyi nganda-mbwuru a we ya bele mutaara a we.” ");
INSERT INTO tyx_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lo me, me ndyele kundaa be ti: Liikadzyi mitaara mi be, ya liikasamana mu babo ba baakamwehẽ be kimini. ");
INSERT INTO tyx_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Me obo be liikala baana ba Taara a be wu li mu mayulu, mu kuulu nde aakapaha tala li nde mu baara ba babwe ya ba babi. Ya aakanohõ mvulu mu banga-a-bunsumu ya mu ba bagwene a bunsumu. ");
INSERT INTO tyx_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mu obo, kala ti be okadzyi yini a ba baakadzyi be, nsa mufuru be liibagha? Mintolo-mpagha ka oli bumõ mye si miikasa o? ");
INSERT INTO tyx_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ya kala ti be mboro okagwa yini a kundaa bankele ba be ba babaghala ya ba bakaha, lo nsa ndagha yi okiŋimi be liikagyighili? Baala ka bali ba-Dzwife o, bo ka baakasa bumõ o? ");
INSERT INTO tyx_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Be me baala likala baara ba bakughu, ti bu oli Taara a be mukughu mu mayulu.» ");
INSERT INTO tyx_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Lisa mayele mu ogwene osuo bunsumu bu be ŋa mihi mi baara mu nzala a omoŋono kundaa bo. Kala pele, be ka libagha mufuru kundaa Taara a be wu li mu mayulu o. ");
INSERT INTO tyx_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mu matala ma aakakaba we kundaa bawele, ka fulu mvulu-a-mvulu o, ti bu ookasa bampibi mu manzo ma lisamana ma ba-Dzwife, ya mu manzili, mu kuulu baara basyighi bo. Mu engaŋma, me ndyele kundaa be ti: Bo áyi babagha mufuru a bo. ");
INSERT INTO tyx_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lo we, mu matala ma aakakaba we kundaa bawele, kwogho e we kii engbambogho enyaã osoolo mi ookasa ngo-kwogho e we, ");
INSERT INTO tyx_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","mu kuulu ekaba e we ekala kii ensweghe, ya Taara a we wu aakamono mu ensweghe, sa abvurulu we kye.» ");
INSERT INTO tyx_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ŋa liikasamana be, ka likakala ti anga bampibi ba baakadzyi okasamana mu mukiri mu manzo mama lisamana mama ba-Dzwife o, ya mu mapfulu ma minsagha, mu kuulu baara bamono bo. Mu engaŋma, me ndyele be ti: Bo áyi babagha mufuru a bo. ");
INSERT INTO tyx_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lo we, mu matala ma dzyi we osamana, somo munsa ngwumu a we, dzughubu muŋma a nzo, ya samana Taara a we mu ensweghe. Ya Taara a we wu aakamono mu ensweghe sa agwa we mvuru.» ");
INSERT INTO tyx_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Mu matala ma liikasamana be, ka likapaha mandagha malagha o ti bu ookasa baala ka bali ba-Dzwife o, ba baakatsimi ti Nzaami sa agyughu bo kala ti babili ku olagha. ");
INSERT INTO tyx_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ka likapaha mandagha malagha ti bo o. Nzaami a be soolo bi lili a be nzala bye nsomo be liluomo. ");
INSERT INTO tyx_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mu obo, be lifaana okasamana bu: “Taara a bihi wu li mu mayulu! Nyaã nkwumu a we yikala yi a ngili. ");
INSERT INTO tyx_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nyaã emfumu e we egya, nyaã dzyi li we likala ŋa nsie ti bu oli ku yulu. ");
INSERT INTO tyx_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gwa bihi lolo li, bi-odza bi bihi bibi nswe etsughu. ");
INSERT INTO tyx_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Sa bubi bu bihi kolokolo, ti bu liikasa bihi si kolokolo kundaa babo ba baakasa bihi bubi. ");
INSERT INTO tyx_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ka nyaã bihi libwa mu bigyeele o, Lo kwulu bihi mu bubi.” Mu kuulu emfumu, lileene ya nsia bili bibi we, mu mibvu nswe mibvu. Aamene.» ");
INSERT INTO tyx_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Kala ti be lisi bubi bu baara kolokolo, Taara a be wu li ku mayulu sa asa be si kolokolo. ");
INSERT INTO tyx_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lo, kala ti be ka lisi baara kolokolo o, Taara a be si ka asa masumu ma be kolokolo o.» ");
INSERT INTO tyx_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Ŋa liikakuru be nswele mu bala, ka likakala a bidzili bibi nyiĩ o, ti bu ookasa bampibi. Bidzili bi bo biikakighiri mu kuulu bagyighili osuo kundaa baara ti bo baakuru nswele mu bala. Mu engaŋma, me ndyele kundaa be ti: Bo áyi bábagha mufuru a bo. ");
INSERT INTO tyx_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lo we, ŋa aakakuru we nswele mu bala, aakaswagha busu bu we, ya aakagyogho mutswi a we mananaase. ");
INSERT INTO tyx_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mu kuulu nyaã omoŋono kundaa baara ti we aakuru nswele mu bala, ya Taara a we wu aakamono mu ensweghe, sa agwa we mvuru.» ");
INSERT INTO tyx_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Ka likakwu busini mu beme ŋa nsie yi o, mu kuulu minkeghere ya bansiele biikabyihi bo, ya banga-a-pfyibi baakabulu bidzughubu ya baakaturu. ");
INSERT INTO tyx_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lo liikakwu busini bu be ku yulu, oko kuulu minkeghere ya bansiele ka biikabyihi bo o, ya banga-a-pfyibi ka baakabulu bidzughubu ya baakaturu o. ");
INSERT INTO tyx_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mu kuulu ŋa oli busini bu we, me oŋo si ŋa ookala mukolo a we.» ");
INSERT INTO tyx_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Lihi lili mwindi a nyuru. Kala ti lihi li we lili nsiili, lo nyuru a we yohono sa yikala kunsa otsyeme. ");
INSERT INTO tyx_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lo, kala ti lihi li we libyele, lo nyuru a we yohono sa yikala kunsa mpyibi. Kala ti otsyeme ku oli mu we oli ti mpyibi, lo mpyibi oyo yili nkara yi a laŋa-laŋa.» ");
INSERT INTO tyx_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Ka oli a mbwuru wu kughu osalala bamfumu buolo o. Mu kuulu nde sa abele mumõ ya sa adzyi wu muke, bwunu we nde sa anabara mu mumõ ya sa atsaala wu muke. Be ka likughu osalala Nzaami emõ ya Nzi o.» ");
INSERT INTO tyx_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Mu obo me ndyele kundaa be ti: Ka likanyoõ mu nkooro a laama li be o, mu mi mitala bi liidza, bwunu we bi liiŋma, ya mu nkooro a nyuru, mu bi liilaha. Laama ka libvulu mupfunu ya bi-odza o? Ya nyuru ka yibvulu binkuru o? ");
INSERT INTO tyx_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Litala baŋmini ba yulu: Bo ka baakakunu o, ya ka baakatolo o, bo ka baakakwu mu bitaghala o, ya Taara a be wu li ku yulu, aakabuŋunu bo. Lo bunu, be ka libvulu bo mupfunu o? ");
INSERT INTO tyx_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nande ŋa kara li be kughu obwehe bitsughu mu laama li nde mu minyoõ?» ");
INSERT INTO tyx_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Mu emakye be lili mu okabulunyoõ mu nkooro a binkuru? Litala bu ookamene bifulu mu ebiri: Bye ka biikasala o, ya ka biikatwu biko o. ");
INSERT INTO tyx_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Me ndyele kundaa be ti: Si kala Salomõ ndeme, kunsa nsia a nde yo yohono, ka ábululaha enkuru ki ebvulu bubwe ti efulu nga-emõ mu bye o. ");
INSERT INTO tyx_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kala ti Nzaami aakalaha bisagha bibi manseghe obo, biili lolo li bye bili, ya mbala-tsughu sa batsili bye ku mbaa, lo bunu, nde ka kughu obvululaha be o, baara baala kana li lisala? ");
INSERT INTO tyx_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ka likakala a minyoõ ya ka likabulubili o ti: “Emakye liidza? Bwunu we emakye liiŋma? Bwunu we emakye liilaha?” ");
INSERT INTO tyx_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mu kuulu bye byehene bibye, baara bwohono ba bagwene osoolo Nzaami baakabulusagha bye ku ogwene a okolo. Taara a be wu a ku yulu soolo ti be lili a nzala a bilogho byehene bibye. ");
INSERT INTO tyx_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nsomo, litswama sagha Emfumu e Nzaami ya bunsumu bu nde, sa babwehe be bye byehene bibye ŋa yulu. ");
INSERT INTO tyx_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mu obo, ka likakala a minyoõ o mu mi mitala etsughu kii mbala, mu kuulu etsughu kii mbala sa ekala a minyoõ mu kyeme. Nswe etsughu eli ya mpara a kye.» ");
INSERT INTO tyx_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Ka likalamana o, mu kuulu banyaã olamana be si. ");
INSERT INTO tyx_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mu kuulu, bwunu a bu liikalamana be banganda-baara, me bwunu obo si akala baalamana be, ya eteese ki liikateese be banganda-baara, me mu kyini ekye si akala baateese be. ");
INSERT INTO tyx_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mu emakye we li mu okatala lisele li lili mu lihi li nganda-mbwuru a we, lo we ka li mu okamono mubaa wu li mu lihi li weme o? ");
INSERT INTO tyx_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bwunu we, bunu we kughu olyele kundaa nganda-mbwuru a we ti: “Nyaã me maha lisele mu lihi li we”, ŋaala weme li a mubaa mu lihi li we? ");
INSERT INTO tyx_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mpibi, matswama maha mubaa mu lihi li weme, ya we bu gyighili omono, we sa bagha bu omaha lisele mu lihi li nganda-mbwuru a we.» ");
INSERT INTO tyx_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Ka ligwa bilogho bibi ngili kundaa bambwa o, ya ka litsili nsia kundaa bangubulu o, kala pele, bo sa badzyara yo, ya bo bakaala mihi kundaa be, bakaghala be.» ");
INSERT INTO tyx_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Liluomo, ya sa bagwa be, lisagha, ya be sa libagha, likoboro, ya sa badzubulu be, ");
INSERT INTO tyx_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","mu kuulu, nswe munde wu aakaluomo, baakagwa nde, wu aakasagha aakabagha, ya baakadzubulu kundaa munde wu aakakoboro. ");
INSERT INTO tyx_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nande ŋa kara li be kughu ogwa mwana a nde limeẽ, kala ti nde luomo limpa? ");
INSERT INTO tyx_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bwunu we, kala ti nde luomo nswi, nde gwi nde ntaala? ");
INSERT INTO tyx_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kala ti be baara ba babi lisoolo ogwa bilogho bi bibwe kundaa baana ba be, lo Taara a be wu li ku mayulu, bunu akughu ogwene ogwa bilogho bi bibvulu bubwe kundaa babo ba baaluomo nde bye?» ");
INSERT INTO tyx_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Mu obo, myehene mi lidzyi ti baara basa mu be, be si lisa bumõ mu bo. Mu kuulu, mimye me Mikyene mi Moyidze ya Mibighili.» ");
INSERT INTO tyx_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Lisomo mu muŋma a nzo wu asala, mu kuulu muŋma a nzo wu munene ya nzili yi nene biikabiri ku obyihi ya baara balagha baakasomo mu yo. ");
INSERT INTO tyx_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Muŋma a nzo li asala, ya nzili yi aakabiri ku laama yili yi aaswele, ya babo ba baakamono yo ka bali balagha o.» ");
INSERT INTO tyx_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Lisa mayele mu mibighili mimi mpya! Mye mili mu okagya kundaa be mu efaana ki bindoomo, lo kunsa kara mye mili bango baba nsihi. ");
INSERT INTO tyx_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Be sa ligyahaba mye mu bigyighili bi bo. Mu munsene-a-nsene ka bakughu oka bimburu bi bviini o, bwunu we mu mungaama ka bakughu oka mburu a finge o. ");
INSERT INTO tyx_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Muti wu mubwe aakaburu bimburu bi bibwe, ya muti wu mubi, aakaburu bimburu bi bibi. ");
INSERT INTO tyx_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Muti wu mubwe ka kughu oburu bimburu bi bibi o, ya muti wu mubi ka kughu oburu bimburu bi bibwe o. ");
INSERT INTO tyx_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nswe muti wu aagwene oburu bimburu bi bibwe, nde wu okpaa ya wu otsili ku mbaa. ");
INSERT INTO tyx_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Me mu obo, be sa lisoolo mibighili mu bimburu bi bo.» ");
INSERT INTO tyx_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Ka oli nswe munde wu aakalyele kundaa me ti: “Mfumu, Mfumu!” Aasomo mu Emfumu ki Mayulu o, lo munde wu aakagyighili waa li Taara a me wu li mu mayulu. ");
INSERT INTO tyx_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mu etsughu ekye, baara balagha akala baalyele kundaa me ti: “Mfumu, Mfumu, bihi ka líkabighili mu nkwumu a we o? Bihi ka líkabyi mifulu mi mibi mu nkwumu a we o? Bihi, ka líkasa bimamaã mu nkwumu a we o?” ");
INSERT INTO tyx_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Oŋo me sa ndyele kundaa bo ti: “Me ka nsoolo be si mu tala limõ o! Limara ŋa bele a me, be ba liikasa bubi!”» ");
INSERT INTO tyx_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Mu obo, nswe mbwuru wu aagyughu mandagha ma ndyele me ma ya salala mo, nde li efaana kii baghala nga-a-mayele wu aatwu nzo a nde ŋa yulu a limeẽ. ");
INSERT INTO tyx_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mvulu bu anoõ, ndwuru yigyi, efulu egyi ya enyihi nzo oyo, lo yo ka yibwi o, mu kuulu batwu bitsini bi nzo oyo ŋa yulu a limeẽ. ");
INSERT INTO tyx_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Lo nswe wu aagyughu mandagha ma me ma, ya ka asalala mo o, nde li ti baghala wu ewulu wu aatwu nzo a nde ŋa yulu a dzyele. ");
INSERT INTO tyx_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mvulu bu anoõ, ndwuru yi gyi, efulu egyi ya enyihi nzo oyo. Nzo yibwi, ya yisaatsaŋama.» ");
INSERT INTO tyx_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ankoho, mu matala ma ómana Yiisu oluo mandagha mamo, mampwumu ma baara mákiŋimi mu maluo ma nde, ");
INSERT INTO tyx_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","mu kuulu nde ka ákaluo ti bu ookaluo baluo-mikyene o, lo nde ákaluo ti mbwuru wu li ya litumu. ");
INSERT INTO tyx_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mu matala ma ófi Yiisu ku yulu a munguo, mampwumu ya mampwumu ma baara máyanama nde. ");
INSERT INTO tyx_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ya, nga-a-buala mutsyini áyasele kundaa nde, ya ákunu mabuo mu nsie ŋa nkulu a nde ya ályele nde ti: «Mfumu, kala we dzyi, lo we kughu otsehebe me.» ");
INSERT INTO tyx_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yiisu bu alabala kwogho, ábyeme nde ya ályele kundaa nde ti: «Me ndzyi, kala wu atsyeme!» Ya ŋaana oŋo, nde átsyeme mu buala bu nde. ");
INSERT INTO tyx_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yiisu áfirilyele kundaa nde ti: «Yughu! Ka lyele kundaa mbwuru ti mumõ o, lo gye yisuo nyuru kundaa ngaa a nzaami, ya yigwa ekaba ki ótumu Moyidze, mu osuo kundaa baara bwohono ti we aadzughu.» ");
INSERT INTO tyx_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mu matala ma ókasomo Yiisu mu bvulu lili Kaperenawume, mfumu a ekuru ki bambumbulu nkama (100) mumõ áyasele kundaa nde ya ábuono nde ");
INSERT INTO tyx_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","mu olyele bu: «Mfumu, musala a me baakwoho ku nzo, binama bi nde biikpi, ya nde li mu okamono mpara yi alagha.» ");
INSERT INTO tyx_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yiisu ályele kundaa nde ti: «Me sa ngya ya me sa ndzuhu nde.» ");
INSERT INTO tyx_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Lo mukwuru a bambumbulu nkama ábvuhulu kundaa nde ti: «Mfumu, me ka ndi wu a kughu o kuulu we somo mu nzo a me. Lo tsughu yini a ndagha mõ, ya musala a me sa adzughu. ");
INSERT INTO tyx_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mu kuulu, meme si ndi kunsa litumu li bakwuru ba me, ya me ndi a bambumbulu ba aakantumu me. Kala ti me ndyele kundaa mumõ ti: “Gye!”, Lo nde gyene, kala ti me ndyele kundaa wu muke ti: “Gya!”, Lo nde gyi, ya kala ti me ndyele kundaa musala a me ti: “Sa esala ki!”, Lo nde si kye.» ");
INSERT INTO tyx_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yiisu bu agyughu obo, nde ákiŋimi ya ályele kundaa ba bákabulunama nde ti: «Mu engaŋma me ndyele kundaa be ti, me nkini aamono mbwuru wu li a kana li linene lili bu mu Isarayele o. ");
INSERT INTO tyx_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Me ndyele be yo, balagha sa bamara ku ookapala ya ku ookadzyama tala mu oyadza kyiri ebini emõ ya Abarahame, Idzake ya Dzakobe mu Emfumu ki Mayulu. ");
INSERT INTO tyx_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lo baana ba Emfumu ki Mayulu sa batsili bo kunsa mpyibi yi a laŋa-laŋa yi a ku mbala. Oko sa okala a bilili ya odza myini.» ");
INSERT INTO tyx_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ya Yiisu ályele kundaa mukwuru a bambumbulu nkama ti: «Bvughuru ku nzo a we, ya nyaã okala bwunu a bu aasi we kana.» Mu matala maana mamo, musala a nde ádzughu. ");
INSERT INTO tyx_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yiisu bu asomo ku nzo a Piere, nde ámono buko bu Piere wu mukaha ágyoŋomo mu nkooro a mukaama. ");
INSERT INTO tyx_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yiisu ábyeme kwogho e nde, ya mukaama áfi. Nde átemene ya ábwi osalala Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nkonkolo bu yito, báyabiri kundaa Yiisu baara balagha banga a mifulu mi mibi. Ya mu ndagha a nde, Yiisu ábyi mifulu mimye ya ádzuhu babyele bwohono, ");
INSERT INTO tyx_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","mu kuulu mandagha ma, ma áli ólyele mubighili Edzayi makeele: «Nde aagwolo bipfwumu bi bihi ya aabiri leme li mabyele ma bihi-a-be.» ");
INSERT INTO tyx_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yiisu bu amono mpwumu a baara yi áadzyi nde, nde ágwi litumu kundaa binduono bagye ya nde mu ngulu yinke yi a mubu. ");
INSERT INTO tyx_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Muluo-mikyene mumõ áyasele ya ályele kundaa nde ti: «Muluo, nswe ku aagye we, me sa nama we.» ");
INSERT INTO tyx_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yiisu ályele kundaa nde ti: «Mibagha mili a miŋma mi baakasweme, ya baŋmini ba mayulu bali a manzo, lo Mwana a mbwuru ka li a ŋa aasiili mutswi o.» ");
INSERT INTO tyx_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mukimi mu binduono bi nde ályele kundaa nde ndiri: «Mfumu, gwa me muswa me mangye yindzyighi taara a me.» ");
INSERT INTO tyx_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lo Yiisu ábvuhulu kundaa nde ti: «Nama me ya nyaã ba bákpi badzyighi bibyimi bi bo.» ");
INSERT INTO tyx_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ya Yiisu bu asomo mu bwara bu bunene, binduono bi nde bínama nde. ");
INSERT INTO tyx_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ensihibi, efulu ki enene ébwi ofulu ŋa yulu madza ma mubu. Mampo ma madza mábaana oluhu bwara. Lo Yiisu áli mu ensama. ");
INSERT INTO tyx_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Binduono bígyi ŋa bele a nde, bísiili nde ya bílyele ti: «Mfumu, bvwuhu bihi! Bihi likpi!» ");
INSERT INTO tyx_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nde ályele kundaa bo ti: «Mu emakye be lili a nzalamweẽ? Be baara baba kana li lisala!» Mu obo, nde átemene, áfyeẽ efulu ya madza ma mubu mu ebaghala, ya edzuunu ki enene ékala. ");
INSERT INTO tyx_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Baara bákiŋimi ya bákalyele ti: «Nsa mbwuru wu, wuulu bifulu ya mubu biikagyughu nde!» ");
INSERT INTO tyx_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ya Yiisu bu ato mu ngulu a mubu yinke, mu nsie yi a basi Ngadara, baara buolo banga a mifulu mi mibi bápala kunsa mampyeme ya báyabwana nde. Bo báli a ebaghala ki elagha, me mu obo mbwuru ti mumõ ka ákaluru mu nzili oyo o. ");
INSERT INTO tyx_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bo bábaana okehe bingubu ti: «Mwana a Nzaami! Nki ndagha yili ŋa kara a bihi ya we? We bu aagyi ŋa mu oyamwehẽ bihi mpara nsomo matala mato?» ");
INSERT INTO tyx_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ankoho, la-la ya bo óli a mukaã a bangubulu wu munene wu áakabuludza. ");
INSERT INTO tyx_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mifulu mi mibi míbuono Yiisu ya mílyele kundaa nde ti: «Kala ti we bihi aabyi, lo gweghe bihi mu mukaã a bangubulu.» ");
INSERT INTO tyx_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yiisu ályele kundaa mye ti: «Ligye!» Mifulu mimye mípala ya míyisomo mu bangubulu. Ya mono, mukaã a bangubulu ábwi okumunu ku nsie a munguo mu ntyini, bo báyibwa mu mubu ya bákpi mu madza. ");
INSERT INTO tyx_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bankyele ba bangubulu básuru a ntyini ya bábvughuru kunsa bvulu, ya bályele mandagha mwohono mamõ bu máluru, ya mi óbwana a baara banga a mifulu mi mibi. ");
INSERT INTO tyx_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mu obo, baara ba bvulu lwohono bápala mu oyibwana Yiisu, ya bu bamono nde, bábuono nde amara mu etsulu e nsie e bo. ");
INSERT INTO tyx_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yiisu bu asomo mu bwara bu bunene, ápala mubu ya ágyene ku bvulu lili ndaa ndeme. ");
INSERT INTO tyx_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Baara báyabiri mbwuru wu ókpi binama kundaa nde wu bálaha ŋa yulu a laba. Yiisu bu amono kana li bo, ályele kundaa nde ti: «Kala a bukyini mwana a me! Masumu ma we basi mo kolokolo.» ");
INSERT INTO tyx_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ankoho, ndaama a baluo-mikyene bákatsimi kunsa mikolo mi bo ti: «Mbwuru wu li mu okatsaala Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yiisu bu abaghala bitsimi bi bo, ályele ti: «Mu emakye be lili a bitsimi bi bibi mu mikolo mi be? ");
INSERT INTO tyx_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nsa ndagha yibvulu oleŋe? Olyele ti: “Masumu ma we basi mo kolokolo”, bwunu we olyele ti: “Temene ya dzyara”? ");
INSERT INTO tyx_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mu kuulu be ligyahaba ti Mwana a mbwuru li a litumu lii osa masumu kolokolo ŋa yulu a nsie.» Mu obo nde ályele kundaa mbwuru wu ókpi binama ti: «Temene, gwolo laba li we ya bvughuru ku nzo a we.» ");
INSERT INTO tyx_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Baghala átemene ya ágyene ku nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mampwumu ma baara bu mamono obo, mábagha nzalamweẽ, ya mábwi osyighi Nzaami wu aagwi kundaa baara litumu lili obo. ");
INSERT INTO tyx_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yiisu ámara oŋo ágyene. Nde bu ákagye, ámono baghala mumõ, nkwumu a nde Matye, wu áabwi nsini ŋa ebini ki baakatolo mpagha. Nde ályele kundaa nde ti: «Nama me!» Matye átemene ya ánama nde. ");
INSERT INTO tyx_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yiisu bu ákadza mu nzo a Matye, mintolo-mpagha milagha ya banga-a-masumu bágyi mu odza emõ ya nde ya binduono bi nde. ");
INSERT INTO tyx_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ba-Faridzyẽ bu bamono obo, bályele kundaa binduono bi nde ti: «Mu emakye Muluo a be ali mu okadza ya mintolo-mpagha ya banga-a-masumu?» ");
INSERT INTO tyx_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yiisu bu agyughu obo, ályele ti: «Ka oli baara baba nsiili bali a nzala a ngaa-libughu o, lo babo ba bali babyele. ");
INSERT INTO tyx_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ligye ligyighi ndagha yi: “Mukolo wu a nyiĩ me ndzyi, lo ka otsughu me banyama mu mikaba o”. Mu kuulu, me ka aangyi mu ota baara baba bunsumu mbili o, lo mu babo banga-a-masumu.» ");
INSERT INTO tyx_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Binduono bi Dzã bígyene kundaa Yiisu ya bífwulu nde ndiri: «Mu emakye bihi ya ba-Faridzyẽ liikakuru nswele mu bala, lo binduono bi we ka biikakuru nswele mu bala o?» ");
INSERT INTO tyx_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yiisu ábvuhulu kundaa bo ti: «Bandughu ba wu aakye bakughu okala kunsa nyiĩ mu matala maala wu aakye li nkini ya bo? Lo bitsughu sa bigya biili sa bamaha wu aakye ŋa kara li bo, me oŋo bo akala baakuru nswele mu bala.» ");
INSERT INTO tyx_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Ka oli a mbwuru wu kughu olo epighi mu enkuru ki ekulu mu mupa wu munyaghara o. Kala pele mupa munde wu baabwehe sa akaghala enkuru ekye ku oluru. ");
INSERT INTO tyx_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ka baakaloŋono si bviini li linyaghara mu manduru ma makulu mama mu bibaana bi banyama o, kala pele manduru sa makagha, bviini litsaŋama ya manduru mapfighili. Lo bviini li linyaghara okaloŋono mu manduru ma manyaghara mama mu bibaana bi banyama, me obo bakughu okele bye binsa byele.» ");
INSERT INTO tyx_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ŋaala Yiisu nkini áli mu okalyele bo mandagha mamo, mu-Dzwife mumõ wu áali mfumu áyabehene, ákunu mabuo ŋa nsie ŋa nkulu a nde, ya ályele kundaa nde ti: «Mwana a me wu mukaha maakpa, lo ya naã kwogho ŋa yulu a nde, ya nde sa akala mweẽ». ");
INSERT INTO tyx_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yiisu ya binduono bi nde bu batemene, bánama nde. ");
INSERT INTO tyx_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mukaha mutsyini wu ókabulupala makili mu bamvulu kwumu ya buolo (12) ágyi ku mbihi a Yiisu ya ábyeme nto a enkuru e nde. ");
INSERT INTO tyx_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mu kuulu nde ákatsimi kunsa mukolo a nde ti: «Kala me mbagha bu obyeme enkuru e nde, me sa mbvwughu.» ");
INSERT INTO tyx_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Lo, Yiisu bu akaghala, ámono mukaha munde, ya ályele kundaa nde ti: «Kala a bukyini, mwana a me! Kana li we liibvwuhu we.» Ya mu matala maana mamo, mukaha ásaabvwughu. ");
INSERT INTO tyx_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yiisu bu ayato ku nzo a mfumu munde, ámono ba baakafulu bilue bi bifaana ti biwebe-a-webe ya mpwumu a baara yi áakalili mu mpini. ");
INSERT INTO tyx_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nde ályele kundaa bo ti: «Lipala ku mbala be bwohono, mutughu ka aakpi o, nde ensama aagyoŋomo.» Lo bo bábwi osebe nde. ");
INSERT INTO tyx_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mpwumu a baara bu yipala ku mbala, Yiisu ásomo mu nzo, ákwara kwogho ki mutughu, ya mutughu ásighili. ");
INSERT INTO tyx_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nsia yítsaŋama mu etsulu e nsie kyehene. ");
INSERT INTO tyx_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mu matala ma ómara Yiisu ŋa ebini ekye, binkpa-mihi byele bíbwi onama nde ya bíkabulukehe bingubu ti: «Mwana a Dabvide, mono bihi nyiĩ!» ");
INSERT INTO tyx_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yiisu bu ato ku nzo, binkpa-mihi bíyasele ŋa bele a nde, nde áfwulu kundaa bo ti: «Be lili a kana ti me nkughu ogyighili obo?» Bo bábvuhulu kundaa nde ti: «Eẽ, Mfumu!» ");
INSERT INTO tyx_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Obo me buulu, nde ábyeme mihi mi bo ya ályele kundaa bo ndiri: «Nyaã okala kundaa be bwunu a bu oli kana li be.» ");
INSERT INTO tyx_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mihi mi bo mímono. Ŋa nseele, mu ebaghala, Yiisu ályele kundaa bo ti: «Liyighili ogyughu, kparaa, mbwuru si mumõ anyaã osoolo ndagha yi!» ");
INSERT INTO tyx_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lo bo bu bapala, báyitsala nde nsia mu etsulu e nsie kyehene. ");
INSERT INTO tyx_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mu matala ma ópala binkpa-mihi, báyabiri nkini wu áali a mufulu wu mubi kundaa Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yiisu bu abyi mufulu wu mubi munde, nkini ábaana obili. Mampwumu ma baara mákiŋimi ya mályele ndiri: «Bihi nkini límaamono yi a bu mu Isarayele o!» ");
INSERT INTO tyx_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lo ba-Faridzyẽ bákalyele ti: «Mu mpaana a mukwuru a mifulu mi mibi nde ali mu okapaha mifulu mi mibi.» ");
INSERT INTO tyx_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yiisu ákabulugye mu mabvulu ya mala mwohono. Nde ákabululuo mu manzo ma lisamana, ákabulutsala Nsia yi Mbwe yi a Emfumu ki Mayulu, ya ákabuludzuhu mabyele mwohono ya bipfwumu byehene. ");
INSERT INTO tyx_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yiisu bu amono mampwumu ma baara, nde ámono mo nyiĩ kunsa mukolo, mu kuulu mo máli makolo, ya ka máli a bukyini o, ti anga bindoomo bi bigwene a munkaala bibuolo. ");
INSERT INTO tyx_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mu obo Yiisu ályele kundaa binduono bi nde ti: «Bi-otolo bilagha mu nseghe, lo ba baatolo bali basala. ");
INSERT INTO tyx_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mu obo, libuono mfumu nga-a-nseghe agweghe basala ba balagha ba baatolo mu nseghe a nde.» ");
INSERT INTO tyx_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yiisu bu ati binduono bi nde kwumu ya byele (12) mbili, nde ágwi bo litumu lili obyi mifulu mi mibi ya odzuhu mabyele mwohono ya bipfwumu byehene. ");
INSERT INTO tyx_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ma me mankwumu ma bantumu kwumu ya buolo (12): Wu a nsomo Simõ ya Andere mbwee a nde, Dzake ya Dzã mbwee a nde, baana ba Nzebede ");
INSERT INTO tyx_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipe ya Baretelemi, Toma ya Matye muntolo-mpagha, Dzake mwana a Alafe ya Tade, ");
INSERT INTO tyx_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simõ mu-Nzelote ya Yuda Isikaryote, munde wu átyeghe Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ba me baara kwumu ya buolo (12) ba ógweghe Yiisu ya ba ályele nde ti: «Ka ligye kundaa baara baala ka bali ba-Dzwife o, ya ka lisomo mu bvulu si limõ lili basi Samari o. ");
INSERT INTO tyx_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Lo ligye ku oli bindoomo bi nzo a Isarayele bi bídzimini. ");
INSERT INTO tyx_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bu lili mu okabulugye, likabululuo ya okabululyele ti: “Emfumu ki Mayulu eeyabehene!” ");
INSERT INTO tyx_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lidzuhu babyele, lisiili ba bákpi mu lipfu, litsehebe banga-a-buala, libyi mifulu mi mibi. Be liibagha kuu ogwene ogwa nzi, ligwa si kuu ogwene oluomo nzi. ");
INSERT INTO tyx_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ka ligwolo si oore o, ngu okala ngele, ngu okala nzi mu miswele mi bala mi be, ");
INSERT INTO tyx_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ngu okala empogholo, ngu okala binkuru byele bi bila, ngu okala bikoghoro, ngu okala mukaana. Mu kuulu musala faana obagha bi-odza bi nde.» ");
INSERT INTO tyx_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Ŋa liisomo be mu bvulu bwunu we mu bula, lifwulu kala ti oli a mbwuru wu a kughu mu ogyagha be, ya likala mu nzo a nde tee matala ma liimara be oŋo. ");
INSERT INTO tyx_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ŋa liisomo be munsa nzo a baara, ligwa bo mboro. ");
INSERT INTO tyx_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kala ti nzo oyo yili yi a kughu, lo nyaã edzuunu e be ekala mu yo. Lo kala ti yo ka yili yi a kughu o, lo nyaã edzuunu e be ebvughuru kundaa beme. ");
INSERT INTO tyx_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nswe munde wu agwene ogyagha be ya wu agwene ogyughu mandagha ma be, lipala munsa nzo oyo, bwunu we bvulu lilo, likubulu lifufunu li myili mi be. ");
INSERT INTO tyx_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mu engaŋma me ndyele kundaa be ti: Mu etsughu kii Muyala, baara ba bvulu lilo sa babagha masyeme ma mabvulu mama baara ba Sodome ya Ngomore.» ");
INSERT INTO tyx_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Ligyughu, me ngweghe be ti bindoomo ŋa kara li bango. Likala yeelee ti bantaala, ya likala a mikolo mi mitsyeme ti anga mabeeme. ");
INSERT INTO tyx_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Lisa mayele mu baara, mu kuulu bo sa batyeghe be ku mambala ma miyala ya bo sa bakaha be nswa-nswa munsa manzo ma bo mama lisamana. ");
INSERT INTO tyx_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sa babiri be ŋa nkulu a bamfumu ba bitsulu bi mansie ya mikogho, mu nkooro a me, me oŋo be liikala bumpughulu bu me ŋa nkulu a bo, ya kundaa baala ka bali ba-Dzwife o. ");
INSERT INTO tyx_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ŋa akala baatyeghe be, ka likala a nzalamweẽ o ti bunu liibili bwunu we mayo liilyele, mu kuulu mu matala mamo, sa bagwa be mandagha ma akala liibili. ");
INSERT INTO tyx_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ka be akala liibili o, lo Mufulu a Taara a be akala aabili mu be. ");
INSERT INTO tyx_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mwana a taara sa atyeghe mwana a taara mu lipfu, ya taara sa atyeghe mwana a nde. Baana sa bakala mitaara mi bataara ya bangughu ba bo, ya sa batumu baara badzwa bo. ");
INSERT INTO tyx_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Baara bwohono sa babele be mu nkooro a nkwumu a me. Lo munde wu aasa mukama tee ku masini, nde sa abvwughu. ");
INSERT INTO tyx_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mu matala ma akala baamwehẽ be mpara mu bvulu limõ, libara mu bvulu li like. Mu engaŋma, me ndyele kundaa be ti, be ka limana odzeŋene mabvulu ma Isarayele mwohono o, nsomo-a-nsomo Mwana a mbwuru agya.» ");
INSERT INTO tyx_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Enduono ka eluru muluo a kye o, ya nkana si mumõ ka luru mfumu a nde o. ");
INSERT INTO tyx_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ofaana okala ti enduono ekala ti muluo a kye ya nkana akala ti mfumu a nde. Kala ti bati mfumu a nzo Beledzebule, lo mayo baagwene olyele mu ba bali munsa nzo a nde?» ");
INSERT INTO tyx_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Mu obo ka libara bo o! Mandagha mwohono ma másweme sa mamoŋono, mansweghe mwohono sa basoolo mo. ");
INSERT INTO tyx_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mandagha ma aandyele me be kunsa mpyibi, be lilyele mo mu mwiĩ wu ebala. Mandagha ma liikagyughu be mu mamfwunu, be lita mo mukwughu ku yulu a see li nzo lili eyala. ");
INSERT INTO tyx_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ka likabara baara ba baakadzwa nyuru o, lo ka bakughu odzwa muwumunu o. Lo liikabara munde wuulu kughu odzihibi muwumunu ya nyuru ku mungele a mbaa. ");
INSERT INTO tyx_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ka baakatyeghe binswini-a-nswini byele mu mupara mumõ. Lo emõ mu bye ka ekughu obwa ŋa nsie o, kala ti Taara a be ka gwi muswa o. ");
INSERT INTO tyx_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ya kundaa be, si okala mfu a be, Nzaami soolo mutala a yo yohono. ");
INSERT INTO tyx_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mu obo, ka likala a nzalamweẽ o! Be libvulu binswini-a-nswini bi bilagha mu mupfunu.» ");
INSERT INTO tyx_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Mu obo, nswe munde wu aakihi ŋa nkulu a baara ti nde li wu a me, lo mehe si sa nkihi ti nde li wu a me ŋa nkulu a Taara a me wu li ku mayulu. ");
INSERT INTO tyx_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lo nswe munde wu aatunu me ŋa nkulu a baara, lo mehe si sa ntunu nde ŋa nkulu a Taara a me wu li ku mayulu.» ");
INSERT INTO tyx_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Ka litsimi o ti me aayambiri edzuunu ŋa nsie. Me ka aangyi mu oyabiri edzuunu o, lo lipee. ");
INSERT INTO tyx_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Me aangyi mu okabala mumpala ya taara a nde, mutughu ya ngughu a nde, mukala a mwana ya buko bu nde wu mukaha. ");
INSERT INTO tyx_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ya mitaara mi mbwuru, sa mikala baara ba bali ya nde munsa nzo a ndeme». ");
INSERT INTO tyx_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Nswe munde wu dzyi taara a nde, bwunu we ngughu a nde ku obvulu me, nde ka faana mu okala wu a me o. Nswe munde wu dzyi mwana a nde wu baghala bwunu we wu mukaha ku obvulu me, nde ka faana okala wu a me o. ");
INSERT INTO tyx_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nswe munde wu aagwene obiri kuruwa li nde ya onama me, ka faana okala wu a me o. ");
INSERT INTO tyx_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Munde wu aakele laama li nde, sa apfihili lo, ya munde wu aapfihili laama li nde mu nkooro a me, sa afiribagha lo.» ");
INSERT INTO tyx_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Nswe munde wu aabwana a be, lo meme nde abwana, ya munde wu aabwana a me bwana a munde wu áagweghe me. ");
INSERT INTO tyx_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nswe munde wu aabwana a mubighili mu kuulu nde li mubighili, sa abagha mufuru wu baakagwa mubighili. Ya nswe munde wu aabwana a mbwuru wu li nsumu mu kuulu nde li nsumu, nde sa abagha mufuru wu a mbwuru wu li nsumu. ");
INSERT INTO tyx_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nswe munde wu aagwa si ebaha ki madza mama mudzili kundaa mumõ mu bike-bike bi mu kuulu kye eli enduono e me, mu engaŋma me ndyele be ti, nde ka apfihili mufuru a nde o.» ");
INSERT INTO tyx_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yiisu bu amana ogwa mikyene mimye kundaa binduono bi nde kwumu ya byele (12), nde ámara oŋo, áyiluo ya áyitsala nsia yi mbwe mu mabvulu ma bo. ");
INSERT INTO tyx_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ya Dzã, munsa boloko mu áli nde, ágyughu bu bákabili mu bigyighili bi Kriste. Nde ágweghe binduono bi nde, ");
INSERT INTO tyx_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","mu oyifwulu kundaa nde ti: «We me munde wu li mu ogya, bwunu we mukimi bihi lifaana okebe?» ");
INSERT INTO tyx_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yiisu ábvuhulu kundaa bo ti: «Ligye lilyele kundaa Dzã mi lili mu ogyughu ya omono: ");
INSERT INTO tyx_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Binkpa-mihi bili mu omono, bikara bili mu odzyara, banga-a-buala bali mu otsyeme, binkpa-matswi bili mu ogyughu, ba bákpi bali mu osighili mu lipfu, ya bali mu otsala Nsia yi Mbwe kundaa bawele. ");
INSERT INTO tyx_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Esee kundaa munde wu aagwene obwihi kana li nde mu nkooro a me!» ");
INSERT INTO tyx_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Binduono bibye bu bibvughuru, Yiisu ábwi obili kundaa mampwumu mu mi mitala Dzã: «Emakye be liiyitala ku syehe? Edzyara ki oli mu okanyihi efulu? ");
INSERT INTO tyx_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bu be emakye liiyimono? Baghala wu aalaha binkuru bibi ntala? Bu tala babo ba baakalaha binkuru bi bibwe mu manzo ma mikogho baakakala. ");
INSERT INTO tyx_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Emakye be liiyimono? Mubighili, eẽ? Me ndyele kundaa be ti, nde bvulu ku oluru ya mubighili. ");
INSERT INTO tyx_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Me mu mi mitala nde básono bu: Mono, me ntswahaba ntumu a me ku nkulu a we, mu ogyighili nzili a we. ");
INSERT INTO tyx_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mu engaŋma, me ndyele be yo: Ŋa kara li ba báburu mu mukaha, ka oli a mbwuru wu áli wu bvulu Dzã Muboghoro o. Lo wu bvulu bugye mu Emfumu ki Mayulu bvulu nde mu bukwuru. ");
INSERT INTO tyx_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Obaana mu matala ma Dzã Muboghoro tee mu matala ma, bali mu odzwana a Emfumu ki Mayulu mu mpini. Me banga-a-ngirini bali mu okagwohono kye. ");
INSERT INTO tyx_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mu kuulu mibighili myehene, ya Mukyene a Moyidze míkabighili tee mu matala ma Dzã. ");
INSERT INTO tyx_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kala ti be likughu okihi yo, me nde, Eli wu áakaagya. ");
INSERT INTO tyx_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nyaã nga-a-matswi, agyughu! ");
INSERT INTO tyx_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ya nande me nkughu obvughu eseene ki? Kye efaana ti anga bike-bike bi biibwi nsini ŋa mbala a baara bwohono, ya bili mu okalyele mu mpini kundaa bambaala bike-bike ti: ");
INSERT INTO tyx_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Bihi liifulu be bilue bi bifaana ti biwebe-a-webe, lo be ka liikini o. Bihi liigyimi ekwumu kii lipfu, lo be ka liilili o!” ");
INSERT INTO tyx_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mu kuulu Dzã aagyi, nde ka akadza ya okaŋma o, ya baara baalyele ti: “Nde li a mufulu wu mubi!” ");
INSERT INTO tyx_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana a mbwuru aagyi, nde li mu okabuludza ya okabuluŋma, ya bo bali mu okalyele ti: “Nde li nga-a-elyili ya enkolo-mala, ndughu a mintolo-mpagha ya banga-a-masumu!” Lo Bunsughu buumoŋono bubu nsumu mu bigyighili bi nde.» ");
INSERT INTO tyx_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ŋa mbihi oŋo, Yiisu ábwi ofyeẽ mabvulu mamo mu ási nde emvulu-ngughu ki bimamaã bi nde, mu kuulu mo ka mágyiŋi mayele o. ");
INSERT INTO tyx_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Nyiĩ kundaa we bvulu lili Koradzine! Nyiĩ kundaa we, bvulu lili Betesayida! Mu kuulu kala ti bimamaã bi bási ŋa kara li be mu mabvulu mama Tire ya Sidõ bási bye, nkini li edzighi baara baba oko bakaalaha mangooro ya ogyogho lifuru a mbaa mu osuo ti bo baagyiŋi mayele. ");
INSERT INTO tyx_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mu obo me ndyele be ti: Mu etsughu kii mumfwunu a baara, ebili e be sa ebvulu kii Tire ya Sidõ. ");
INSERT INTO tyx_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ya we bvulu lili Kaperenawume, sa bakuhubu we tee ku yulu? Pele! Sa basurulu we tee ku nsie a ba bákpi! Mu kuulu kala ti bimamaã bi bási ŋa kara li we, áli ku Sodome bási bye, nkini bvulu lilo lili tee lolo bu. ");
INSERT INTO tyx_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Me obo me ndyele be ti: Mu etsughu kii mumfwunu a baara, ebili kii nsie a Sodome sa ebvulu busala ya kii we». ");
INSERT INTO tyx_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mu matala mamo Yiisu ályele ti: «Me nsyighi we Taara, Mfumu a yulu ya nsie, mu kuulu we aasweghe mandagha mamo ŋa mihi mi bansughu ya banga-a-mayele, lo we aasuo mo kundaa bike-bike. ");
INSERT INTO tyx_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eẽ, Taara, we aadzyi ti okala obo.» ");
INSERT INTO tyx_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Taara a me ágwi me byehene. Ka oli a mbwuru si mumõ wu soolo Mwana o, kala ka oli yini a Taara o. Ya ka oli a munde wu soolo Taara o, kala ka oli yini a Mwana o ya munde wu odzyi Mwana osuo kundaa Taara.» ");
INSERT INTO tyx_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Ligya kundaa me, be bwohono ba liikolo mu obiri maleme, ya me sa ngwa be bumpoholo. ");
INSERT INTO tyx_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Lilaha nkogholo a me ya ligyighi kundaa me, mu kuulu me ndi wu adzuunu ya me ndi a mukolo wu a bunya-nyaã, ya be sa libagha ogwumu ku miwumunu mi be. ");
INSERT INTO tyx_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mu kuulu nkogholo a me ka yili a mpara mu obiri o, ya leme lili ndaa me lileŋe.» ");
INSERT INTO tyx_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mu matala mamo, Yiisu ákaluru munsa manseghe ma bele, mu etsughu kii sabate. Binduono bi nde bífuru nzala ya bíbwi oka binsia bi bimburu ya odza bye. ");
INSERT INTO tyx_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ba-Faridzyẽ bu bamono obo bályele kundaa nde ti: «Mono, binduono bi we bili mu ogyighili mi bálighi ogyighili mu etsughu kii sabate». ");
INSERT INTO tyx_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Lo Yiisu ábvuhulu kundaa bo ti: «Bunu, be kálitaã mi ógyighili Dabvide o, mu matala ma ófuru nde nzala ya ba bákakala ya nde? ");
INSERT INTO tyx_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bunu-abo nde ásomo mu Nzo a nzaami, ya áli mampa ma bágwi ekaba kundaa Nzaami, maala nde ya ba bákakala ya nde ka báli a muswa mu odza o, lo yini a bangaa ba nzaami? ");
INSERT INTO tyx_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bwunu we be ka lítaã mu Mukyene o ti, mu etsughu kii sabate, munsa Nzo a nzaami, bangaa ba nzaami baakatsumunu ngili a etsughu kii sabate ku ogwene a obagha ebili? ");
INSERT INTO tyx_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Lo me ndyele kundaa be ti: Oli ŋa, yibvulu Nzo a nzaami. ");
INSERT INTO tyx_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kala ti áli liigyahaba mbaala a bisono bi: Me ki ndzyi mukolo wu a nyiĩ, lo ka okadzwa banyama mu bikaba o, nkini be ka likaakagwa ebili kundaa baara ba bagwene osoolo ndagha o. ");
INSERT INTO tyx_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Buulu Mwana a mbwuru li Mfumu a sabate.» ");
INSERT INTO tyx_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yiisu bu amara oŋo, ágyene munsa nzo a bo yi lisamana. ");
INSERT INTO tyx_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mu nsa omo, óli a baghala wu áali a kwogho ki ekee. Ba-Faridzyẽ bu bákasagha ndagha yi baaburulu nde, bágwi nde efwulu ki: «Bunu, oli a muswa mu odzuhu mubyele mu etsughu kii sabate?» ");
INSERT INTO tyx_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ya Yiisu ábvuhulu kundaa bo ti: «Nande ŋa kara li be wuulu kala ti nde li a endoomo etsyini, ya kye ebwi mu dzunu mu etsughu kii sabate, nde ka ayipaha kye o? ");
INSERT INTO tyx_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Buta mbwuru bvulu mupfunu ya endoomo! Mu obo, oli a muswa mu ogyighili bubwe mu etsughu kii sabate.» ");
INSERT INTO tyx_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Oŋo nde ályele kundaa baghala ti: «Labala kwogho e we». Nde álabala kye ya kye ébvughuru nsiili ti kwogho ki eke. ");
INSERT INTO tyx_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ba-Faridzyẽ bu bapala, bákuru mfwunu yi osagha bunu baadzwa Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yiisu bu asoolo obo, ámara oŋo. Ya mampwumu ma baara malagha mákanama nde, ya nde ádzuhu bo bwohono. ");
INSERT INTO tyx_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yiisu átswi bo mukele, banyaã otsala nde nsia ti nde na ali, ");
INSERT INTO tyx_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","mu kuulu mandagha ma ólyele mubighili Edzayi matswighi: ");
INSERT INTO tyx_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Mono musala a me wu aanswolo me, wu ndzyi me, ya mu nde me aankamono esee. Me sa ntwulu Mufulu a me mu nde, ya nde sa alyele bunsumu kundaa baara ba mansie. ");
INSERT INTO tyx_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nde ka baŋana ya mbwuru o, ka akehe bingubu o, ka bagyughu likyi li nde mu minsagha o. ");
INSERT INTO tyx_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nde ka abogholo edzyara ki bamaafuru o, nde ka adzihibi musyi a mwindi wu li nkini mu okatsuru o, tee ŋa aasa nde ti bunsumu bulughulu. ");
INSERT INTO tyx_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ya bikaana byehene sa bisa emiini mu nkwumu a nde.» ");
INSERT INTO tyx_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Báyabiri kundaa Yiisu mbwuru mumõ wu áali a mufulu wu mubi, nde áli enkpa-mihi ya nkini. Yiisu ádzuhu nde. Mbwuru wu áali nkini ábwi obili ya ábwi omono. ");
INSERT INTO tyx_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mampwumu ma baara mwohono mákiŋimi ya mályele ti: «Wu ka Mwana a Dabvide o?» ");
INSERT INTO tyx_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lo ba-Faridzyẽ bu bagyughu obo, bályele ti: «Mbwuru wu mu lileene li Beledzebule, mfumu a mifulu mi mibi, ali mu okabyi mifulu mi mibi.» ");
INSERT INTO tyx_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yiisu bu agyahaba bitsimi bi bo, ályele kundaa bo ti: «Kala ti baara ba bali a emfumu baakadzwana bo-a-bo, lo emfumu ekye sa ebwa. Ya baara baba bvulu bwunu we baba dzumu limõ kala ti bakaghaba, bvulu lilo bwunu we dzumu lilo ka lilaama o. ");
INSERT INTO tyx_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kala ti Satana byi Satana, lo nde li mu okaghaba ya ndeme, bunu-a-bo emfumu e nde ekughu olaama? ");
INSERT INTO tyx_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kala ti me mu lileene li Beledzebule ndi mu okabyi mifulu mi mibi, lo baana ba be mu lili nande baakabyi mye? Mu obo, bomo sa bakala bansunghu-a-lamana ba be. ");
INSERT INTO tyx_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Lo, kala ti mu Mufulu a Nzaami me ndi mu okabyi mifulu mi mibi, lo Emfumu e Nzaami ayi eeyato kundaa be. ");
INSERT INTO tyx_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Bwunu we, bunu-a-bo mbwuru akughu osomo mu nzo a nga-a-mpini ya ogwolo bilogho bi nde byehene, kala ti nde ka tswama okuru nde misyi o? Lo, nde amana osa obo, nde kughu ogwohono byehene bi bili mu nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nswe munde wuulu ka ali ya me o, li mutaara a me, ya munde wu aagwene obvughu baara ya me, nde li mu otsala. ");
INSERT INTO tyx_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Me mu obo me ndyele kundaa be ti: Sa basa baara kolokolo mu masumu ma bo mwohono ya otsaala kwohono, lo munde wu aatsaala Mufulu a Ngili ka bakughu osa nde kolokolo o. ");
INSERT INTO tyx_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ya kala ti mbwuru lyele ndagha yi mbi mu Mwana a mbwuru, sa basa nde kolokolo. Lo munde wu aabili bubi mu Mufulu a Ngili, ka basa nde kolokolo o, ngu okala mu matala ma, ngu okala mu matala ma maagya.» ");
INSERT INTO tyx_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Kala ti muti li mubwe, lo bimburu bi nde si bili bi bibwe. Ya kala ti muti li mubi, lo bimburu bi nde si bili bi bibi. Mu kuulu muti okagyahaba nde mu bimburu bi nde. ");
INSERT INTO tyx_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Etswumu ki bampili ki! Bunu-abo be likughu olyele mandagha ma mabwe, ŋaala be lili baara ba babi? Mu kuulu mandagha ma maakapala mu muŋma, me ma maalwulu mu mukolo. ");
INSERT INTO tyx_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mbwuru wu mubwe aakapaha bilogho bi bibwe bi bili mu nkiri-mbughu a nde yi mbwe. Mbwuru wu mubi aakapaha bilogho bi bibi bi bili mu nkiri-mbughu a nde yi mbi. ");
INSERT INTO tyx_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Me ndyele kundaa be ti: Mu etsughu kii Muyala, nswe mbwuru sa agwa mvuru mu mandagha ma magwene a mupfunu ma ápaha mu muŋma a nde. ");
INSERT INTO tyx_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Me mu mbiili a we, we akala alughulu, ya me mu mbiili a we, we akala abwa.» ");
INSERT INTO tyx_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ŋaana oŋo, baluo-mikyene bana ya ba-Faridzyẽ babake bályele kundaa Yiisu ndiri: «Muluo, bihi lidzyi ti we, we suo bihi elyimi nga-emõ.» ");
INSERT INTO tyx_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nde ábvuhulu kundaa bo ti: «Eseene kii lolo, ki eli ebi ya ki eegwene okanama Nzaami eli mu oluomo elyimi! Lo ka oli a elyimi ki baasuo kundaa be o, kala ti ka oli yini a elyimi kii mubighili Dzonase o. ");
INSERT INTO tyx_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bwunu a bu ósi Dzonase bitsughu bitere ya mampyibi matere munsa mweẽ a nswi wu munene, bwunu obo si Mwana a mbwuru aasa bitsughu bitere ya mampyibi matere ku nsini a nsie. ");
INSERT INTO tyx_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mu etsughu kii muyala, baara baba bvulu li Ninibve sa batemene ya bafwunu baara baba eseene ki. Bo sa babwihi eseene ki, buulu baara ba Ninibve bágyiŋi mayele mu maluo ma Dzonase. Lo oli ŋa, wu bvulu Dzonase. ");
INSERT INTO tyx_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mu etsughu kii muyala, Ngasa wu a nsie yi a Sude, sa atemene ya afwunu eseene ki, ya sa abwihi kye, mu kuulu Ngasa ámara ku bitsulu bi nsie bi bibvulu la mu oyagyughu bunsughu bu Salomõ. Lo oli ŋa, wu bvulu Salomõ!» ");
INSERT INTO tyx_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Ŋa ookapala mufulu wu mubi mu nyuru a mbwuru, nde aakagye mu bibini bibi syehe mu okabulusagha ŋa aagwumu. Lo kala ti nde ka abagha kye o, ");
INSERT INTO tyx_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","oŋo nde aalyele bu: “Me mbvughuru ku nzo a me yi nkulu, omo mu áampala me”. Ya nde bu ayabvughuru, nde sa ayabagha yo mukaŋana, yi bagyighili okuomo ya bunkere. ");
INSERT INTO tyx_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Oŋo nde aayigwolo ya nde mifulu nsaama mikimi mi mibvulu nde mu bubi, mye myehene misomo ya mibagha bibini omo. Bunsiili bu mbwuru munde bubu masini sa bubvulu bubi ya bubu nsomo. Bwunu obo si ookala mu eseene ki ebi ki.» ");
INSERT INTO tyx_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yiisu áli nkini mu okabili kundaa mampwumu ma baara, ngughu ya bambwee ba nde bátemene ku mbala ya bákasagha obili ya nde. ");
INSERT INTO tyx_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mbwuru mumõ áyalyele kundaa nde ti: «Ngughu a we ya bambwee ba we bali ku mbala ya badzyi obili ya we.» ");
INSERT INTO tyx_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yiisu ábvuhulu kundaa munde wu áakabili ya nde ndiri: «Nande li ngughu a me? Ya bana bali bambwee ba me?» ");
INSERT INTO tyx_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ŋa nseele nde álabala kwogho kundaa binduono bi nde ya ályele ti: «Limono ngughu a me ya bambwee ba me. ");
INSERT INTO tyx_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nswe munde wu aasa waa li Taara a me wu li mu mayulu, me munde li mbwee bwunu we naana a me wu baghala, nkele a me, ya ngughu a me.» ");
INSERT INTO tyx_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mu etsughu ekye, Yiisu bu apala mu nzo, áyabwa nsini ŋa mukogho a mubu. ");
INSERT INTO tyx_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mampwumu ma baara malagha máyabvuŋunu ŋa bele a nde, ya mu obo, nde ásomo munsa bwara ya ábwi nsini, ya mpwumu a baara yohono yísyili mu mukogho a madza. ");
INSERT INTO tyx_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mu mankumu, nde ályele mandagha malagha kundaa bo ti: «Mukunu ápala mu oyikunu. ");
INSERT INTO tyx_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mu matala ma ákanyahala nde nsia, ndaama a nsia yíbwi mu mukogho a nzili. Baŋmini bágyi ya bátooro yo yohono. ");
INSERT INTO tyx_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yinke yíbwi mu oli mameẽ, ŋaala nsie ka yíli yi alagha o. Yo yímene mu maswa, lo mu nkooro a nsie yiili ka yíli a mubighi o, ");
INSERT INTO tyx_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","mwiĩ bu abala ya buulu misumunu ka míli a midza o, mye mídzighi ya míkee. ");
INSERT INTO tyx_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yinke yíbwi kunsa mingaama, ya mingaama bu mikulu mísi yo mpiŋi. ");
INSERT INTO tyx_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yinke yíbwi mu nsie yi mbwe ya yíburu bimburu: Yini bimburu nkama (100), yinke bimburu makwumu masemene (60), ya yimõ bimburu makwumu matere (30). ");
INSERT INTO tyx_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Munde wu li a matswi, agyughu!» ");
INSERT INTO tyx_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Binduono bu biyasele kundaa nde, bífwulu nde ti: «Mu emakye we li mu okabulubili ya bo mu mankumu?» ");
INSERT INTO tyx_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nde ábvuhulu kundaa bo ti: «Kundaa be baagwi bwehe ba osoolo mpaana a Emfumu ki Mayulu, lo ka kundaa bo o. ");
INSERT INTO tyx_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mu kuulu, kundaa munde wu li a elogho, sa bafirigwa nde, ya sa akala a bye bi bilagha, lo kundaa munde wu gwene a elogho, sa bamaha nde ekye ki ali a nde. ");
INSERT INTO tyx_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Me mu obo me ndi mu okabulubili ya bo mu mankumu, mu kuulu si kala ti bo batala, lo bo omono we, ya si kala ti bo banama, lo bo ogyughu we ya obaghala we, ");
INSERT INTO tyx_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ya mpaala mandagha ma ma ólyele mubighili Edzayi makeele mu bo: Be sa ligyighili ogyughu, lo ka libaghala o, Be sa ligyighili otala, lo ka limono o. ");
INSERT INTO tyx_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mu kuulu mukolo a ekaana ki ayi aakubu, bo baakuru matswi ma bo ya baadzwi mihi mi bo. Mu kuulu banyaã omono mu mihi mi bo, ya banyaã ogyughu mu matswi ma bo, ya banyaã obaghala mu mikolo mi bo. Ya bakwono ogyiŋi mayele, ya me ndzuhu bo.» ");
INSERT INTO tyx_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Esee kundaa be mu kuulu mihi mi be mili mu omono, ya matswi ma be mali mu ogyughu. ");
INSERT INTO tyx_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mu engaŋma, me ndyele kundaa be ti: Mibighili milagha ya baara baba bunsumu balagha bákasagha omono mi lili mu omono be, lo bo ka bámono mye o, bákasagha ogyughu mi lili mu ogyughu be, lo ka bágyughu mye o.» ");
INSERT INTO tyx_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Be me baala ligyughu mbaala a nkumu yi a mukunu: ");
INSERT INTO tyx_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ba baakagyughu ndagha a Emfumu e Nzaami ya bakwono obaghala, bo bali efaana kii mukogho a nzili munde wu oobwi mburu. Wu Mubi agwolo gyi ya gwohono byehene bi baakunu mu mikolo mi bo. ");
INSERT INTO tyx_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nsie yi a mameẽ mu oobwi mburu, me munde wuulu bu agyughu ndagha a Nzaami, gyagha yo maswa-maswa ya esee. ");
INSERT INTO tyx_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Lo, nde ka li a midza mu ndeme o, nde mbwuru wu gwene a mukama. Ya ŋa oogya mpara bwunu we makimini mu nkooro a Ndagha a Nzaami, ŋaana-oŋo nde bwi. ");
INSERT INTO tyx_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nsie yi a mingaama mu oobwi mburu, me munde wu gyughu Ndagha a Nzaami, lo minyoõ mi nsie ya ntono a busini biikasa Ndagha a Nzaami mpiŋi ya yo ka yiikaburu bimburu o. ");
INSERT INTO tyx_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nsie yi mbwe mu oobwi mburu, me munde wuulu bu agyughu Ndagha a Nzaami, baghala yo. Nde aakaburu bimburu, limõ ligwi nkama (100) a bimburu, lini ligwi bimburu makwumu-masemene (60), li like ligwi bimburu makwumu-matere (30).» ");
INSERT INTO tyx_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yiisu áfirita bo nkumu nkimi. Nde ti: «Emfumu ki Mayulu efaana ya mbwuru wu aakunu nsia yimbwe mu nseghe a nde. ");
INSERT INTO tyx_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mu matala maala baara baagyoŋomo ensama, mutaara a nde gyi, kunu nsia a esagha ki ebi ŋa kara li bele ya gyene. ");
INSERT INTO tyx_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Bele limene ya liburu binsia, esagha ki ebi si epala. ");
INSERT INTO tyx_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Basala ba mfumu nga-a-nzo bagyi ya balyele kundaa nde ndiri: “Mfumu, bunu, we ka oli nsia yimbwe aakanu mu nseghe a we o? Bu esagha ki ebi ki kunu-ako eefi?” ");
INSERT INTO tyx_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nde bvuhulu kundaa bo ti: “Me mutaara aasi obo.” Basala balyele kundaa nde ti: “Bunu, we dzyi ti bihi liyitumunu esagha ekye?” ");
INSERT INTO tyx_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nde lyele kundaa bo ti: “Pele! Mara bu litolo esagha ki ebi, be litumunu si bele nzili mõ ya kye. ");
INSERT INTO tyx_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Linyaã bye binsa byele bikulu tee ku baatolo bimburu. Ya mu matala ma baatolo, me sa ndyele kundaa ba baatolo ti: Limatswama otolo bisagha bi bibi, likuru bye mu biko ya litsughu bye mbaa. Ŋa nseele be likwu bele kunsa etaghala e me.”» ");
INSERT INTO tyx_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yiisu áfirita bo nkumu nkimi ti: «Emfumu ki Mayulu efaana ti nsia a muti wu a nkwumu mutaade yi ogwolo mbwuru ya akunu mu nseghe a nde. ");
INSERT INTO tyx_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yo yibvulu busala mu nsia yo yohono. Lo ŋa yiikapala yo, yo yiikabvulu miswoho myehene mimi mu ebwa mutele. Yo yiikakala muti wuulu baŋmini ba yulu baakayatwu manzo ma bo mu mampala ma nde.» ");
INSERT INTO tyx_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yiisu áfirita bo nkumu nkimi ti: «Emfumu ki Mayulu efaana a pfini li oogwolo mukaha ya atwulu mu mankpaã matere ma farine, tee ku oofuulu mankpaã ma farine mwohono.» ");
INSERT INTO tyx_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Mandagha mwohono mamo Yiisu ákalyele mo kundaa mampwumu ma baara bwohono mu mankumu. Ya nde ka ákabili ya bo ku ogwene a ma mankumu o. ");
INSERT INTO tyx_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mu kuulu mandagha ma áli olyele mubighili makeele: Me sa ndzubulu muŋma a me mu obili mu mankumu, me sa ndyele bo mandagha mama ensweghe obaana mu ebaana e nsie. ");
INSERT INTO tyx_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yiisu bu abulusihi mampwumu ma baara, áyisomo mu nzo, ya binduono bi nde bíyasele kundaa nde, ya bílyele kundaa nde ti: «Gwa bihi mbaala a nkumu yi a esagha ki ebi mu nseghe.» ");
INSERT INTO tyx_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nde ábvuhulu kundaa bo ti: «Munde wu aakanyahala nsia yi mbwe me Mwana a Mbwuru. ");
INSERT INTO tyx_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nseghe me nsie, nsia yi mbwe me baana ba Emfumu ki Mayulu, esagha ki ebi me baana ba Nga-a-bubi. ");
INSERT INTO tyx_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mutaara wu aakanyahala nsia a esagha ki ebi me dyabulu, otolo bimburu me masini ma nsie, ba baakatolo bimburu me bangye-yulu. ");
INSERT INTO tyx_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mu obo, bwunu a bu baakatumunu esagha ki ebi ya otsughu kye kyehene ku mbaa, me obo si akala ookala ku etsughu kii masini ma nsie. ");
INSERT INTO tyx_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana a mbwuru sa agweghe bangye-yulu ba nde. Bo sa bapaha mu Emfumu e nde, byehene bi biikabwihi baara mu masumu, ya ba baakagyighili bubi. ");
INSERT INTO tyx_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ya sa batsili bo kunsa mungele a mbaa, oko ku ookala bilili ya odza myini. ");
INSERT INTO tyx_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Oŋo banga-a-bunsumu sa basehene ti anga tala mu Emfumu e Taara a bo. Nyaã nga-a-matswi, agyughu!» ");
INSERT INTO tyx_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Emfumu ki Mayulu efaana ti busini bu básweghe kunsa nseghe, buulu mbwuru ámono bo, áfirisweghe bo. Mu emiini kyehene, nde sa ayityeghe bilogho bi nde byehene ya ayaswumu nseghe oyo.» ");
INSERT INTO tyx_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Emfumu ki Mayulu efirifaana ti munta-nkaala wu li mu okabulusagha nsia a bolo yi mbwe. ");
INSERT INTO tyx_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bu amono lisia limõ lili ntala yi alagha, nde yityeghe bye byehene bi ali a bye, ya yaswumu lisia lilo.» ");
INSERT INTO tyx_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Emfumu ki Mayulu efaana ti likoho li batubu mu mubu li likogho banswi baba mawa-mawa. ");
INSERT INTO tyx_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bu lilwulu, bilebe-banswi bidzuru lo mu mukogho a madza, ya baara bu babwi nsini mu mukogho, babwi osuolo banswi ba babwe ba baalo mu mankuru ya batsili ba bagwene a mupfunu. ");
INSERT INTO tyx_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Bwunu obo si ookala mu etsughu ki masini ma nsie. Bangye-yulu sa bagya, sa bakabala ba babi ya ba banga-a-bunsumu, ");
INSERT INTO tyx_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ya sa batsili ba babi ku mungele a mbaa. Oko ku ookala bilili ya odza myini.» ");
INSERT INTO tyx_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","«Bunu, be liibaghala mandagha mwohono ma?» Bo bakihi ti: «Eẽ.» ");
INSERT INTO tyx_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nde ályele kundaa bo ti: «Obo me buulu, nswe muluo-mikyene wu báluo mu mi mitala Emfumu ki Mayulu, faana ti mfumu nga-a-nzo wu paha munsa nkiri-mbughu a nde, bilogho bi binyaghara ya bi bikulu.» ");
INSERT INTO tyx_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yiisu bu amana ota mankumu mamo, ámara oŋo. ");
INSERT INTO tyx_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bu agyi ku etsulu e nsie e ndeme, ku Nadzarete nde ábwi oluo bo mu nzo a lisamana a bomo ya bo bwohono ba bákagyughu nde bákiŋimi ya bályele ti: «Kunu oofi nde bunsughu bu ya bimaã bi? ");
INSERT INTO tyx_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bunu, wu ka li mwana a munkomo-manzo o? Ngughu a nde ka Mari o? Ya Dzake, Dzodzefe, Simõ ya Yude ka bali bambwee ba nde o? ");
INSERT INTO tyx_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ya bankele ba nde bwohono ka ba bali ŋa kara li bihi o? Kunu-ako nde aabagha myehene mi?» ");
INSERT INTO tyx_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bo bákakubu makya mu nkooro a nde. Yiisu ályele kundaa bo ti: «Mubighili, ka baakagwa nde budiziri bibini byehene, lo ka mu nsie a ndeme ya mu dzumu li ndeme o.» ");
INSERT INTO tyx_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ya oko Yiisu ka ási bimaã bilagha o, mu kuulu bo ka báli a kana o. ");
INSERT INTO tyx_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mu matala mamo, Erode mfumu a Ngalile, ágyughu nsia a Yiisu, ");
INSERT INTO tyx_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ya ályele kundaa basala ba nde ti: «Munde Dzã Muboghoro aasighili ŋa kara li ba bápki! Ya me mu obo nde ali a lileene lili okabulusa bimaã». ");
INSERT INTO tyx_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mu kuulu, Erode áli agwi litumu basyimi Dzã, bakuru nde misyi ya balo nde mu boloko mu nkooro a Erodyade, mukala a Filipe, mbwee a nde. ");
INSERT INTO tyx_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Mu kuulu Dzã ákalyele kundaa nde ti: «We ka li a muswa wu ogwolo mukaha munde o!» ");
INSERT INTO tyx_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erode ákadzyi odzwa Dzã, lo nde ákabara mpwumu a baara mu kuulu yo yíkamono ti Dzã li mubighili. ");
INSERT INTO tyx_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lo etsughu kii kyiri ki ndibili-a-mweẽ a etsughu ki báburu Erode bu eto, mwana a Erodyade wu mukaha áyakini ŋa nkulu a baara ba ógwi Erode mampighi, ya Erode ámono esee mu nde. ");
INSERT INTO tyx_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mu obo Erode ágwi nde misiini ya álaba mukihi ti: «Nswe elogho ki aaluomo we me, me sa ngwa we kye». ");
INSERT INTO tyx_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mu luo li ngughu a nde, nde ályele kundaa Erode ti: «Gwa me ŋa munsa ndoõ mutswi a Dzã Muboghoro!» ");
INSERT INTO tyx_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mukogho ányoõ, lo mu nkooro a mukihi wu aalaba ya mu nkooro a baara ba aagwi nde mpighi, nde ágwi litumu bayabiri nde mutswi a Dzã. ");
INSERT INTO tyx_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Erode átumu baara munsa boloko bayikehe Dzã bolo. ");
INSERT INTO tyx_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Báyabiri mutswi a Dzã munsa ndoõ ya bágwi nde kundaa mutughu, ya mutughu ágyene a nde kundaa ngughu a nde. ");
INSERT INTO tyx_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Binduono bi Dzã bígyi, bígwolo ebyimi e nde ya bídzyighi kye. Ŋa mbihi oŋo, bo báyitwoho nsia kundaa Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yiisu bu agyughu nsia oyo, nde ámara oŋo mu bwara ya ágyene ngasighi ku nkolo yi gwene a baara. Lo mampwumu ma baara bu masoolo obo, mápala mu mabvulu mamo ya mánama nde mu myili. ");
INSERT INTO tyx_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nde bu apala mu bwara, ámono mpwumu a baara yi nene ya nde ámono bo nyiĩ, ya ábwi odzuhu babyele ba bo. ");
INSERT INTO tyx_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nkonkolo bu yito, binduono bi Yiisu bíyasele ku bele a nde ya bílyele kundaa nde ti: «Ebini ki eli ki e nkeẽ ya bwihi ayi ku ogyili. Bvurulu mampwumu ma baara magye mu mala mu oyiswumu bi-odza.» ");
INSERT INTO tyx_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Lo Yiisu ábvuhulu kundaa bye ti: «Bo ka bali a nzala a obvughuru o, ligwa bo bi-odza beme.» ");
INSERT INTO tyx_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bye bílyele kundaa nde ti: «Bihi ki lili a kye ŋa, yini a mampa mataana ya banswi buolo.» ");
INSERT INTO tyx_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mu obo, nde ályele kundaa binduono ti: «Ligya a me bye ŋa.» ");
INSERT INTO tyx_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ya nde átumu mampwumu ma baara mabwa nsini ŋa yulu a nsele. Nde ágwolo mampa mataana ya banswi buolo, átala ku yulu, áseme bye, átsyiri bye ya ágwi kundaa binduono bi nde, ya binduono bíkaba bye kundaa mampwumu ma baara. ");
INSERT INTO tyx_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bo bwohono báli, bágyughuru. Ya bábiri bitubu kwumu ya byele (12) bi bílwulu mu bitsulu bi bísyili. ");
INSERT INTO tyx_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Babo ba báli bye áli bakughu oto mapfwunu mataana (5 000) ma babaghala, gwene otala bakaha ya baana ba basala. ");
INSERT INTO tyx_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ya ŋaana oŋo, Yiisu ásini binduono bi nde bisomo munsa bwara ya bitswama ku nkulu a nde ku ngulu a mubu, mu edzighi ki ákabvurulu nde mampwumu ma baara. ");
INSERT INTO tyx_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ya bu amana obvurulu mampwumu ma baara, nde ákumu ku yulu a munguo, mu oyisamana ngasighi. Ŋa ogyili bwihi, nde áli oŋo, ngasighi. ");
INSERT INTO tyx_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bwara áli ayi la ya mukogho a mubu. Mampo ma madza ma manene mákabwa mu bo mu nkooro a efulu kii mpini ki ékagya. ");
INSERT INTO tyx_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ku bele a ku ookya bwihi, Yiisu ágyene kundaa bo mu okabuludzyara mu yulu a mubu. ");
INSERT INTO tyx_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Binduono bu bimono nde mu okadzyara ŋa yulu a madza ma mubu, enkwughu ki enene ésughuru mu bo ya bályele ti: «Ekye etoomo!» Ya mu nzalamweẽ, bo bábwi okehe bingubu. ");
INSERT INTO tyx_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ŋaana oŋo, Yiisu átsughu ndagha kundaa bo ti: «Likala a bukyini, wu me me, ka likala a nzalamweẽ o!» ");
INSERT INTO tyx_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piere ályele kundaa nde ti: «Mfumu, kala ti wu me we, lo gwa litumu mu kuulu me ngya kundaa we mu yulu a madza.» ");
INSERT INTO tyx_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yiisu ályele nde ti: «Gya!» Piere ásughuru mu bwara, ábwi odzyara mu yulu a madza ya ábaana ogye kundaa Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lo bu amono efulu kii mpini, Piere ábagha nzalamweẽ, ya nde ábaana odzyama. Nde ákehe engubu ya ályele ti: «Mfumu, bvwuhu me!» ");
INSERT INTO tyx_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ya ŋaana oŋo, Yiisu bu alabala kwogho, ákwara nde ya ályele kundaa nde ti: «Mbwuru nga a kana li lisala, mu emakye we aasi mikeme?» ");
INSERT INTO tyx_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ya bu basomo mu bwara, efulu édzuunu. ");
INSERT INTO tyx_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ba báli mu bwara bákunu mabuo mu nsie ŋa nkulu a nde ya bályele ti: «Mu engaŋma we li Mwana a Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bu bapala mu ngulu a mubu, bo báto mu etsulu e nsie kii Ngenedzarete. ");
INSERT INTO tyx_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Baara baba ebini ekye bu bagyahaba Yiisu, bátsala nsia a nde mu etsulu e nsie kyehene, ya báyabiri babyele bwohono kundaa nde. ");
INSERT INTO tyx_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bábuono nde mu kuulu nde anyaã bo babyeme yini a nto a enkuru e nde. Baara bwohono ba bábyeme kye bádzughu. ");
INSERT INTO tyx_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ba-Faridzyẽ ya baluo-mikyene báfi ku Yerusaleme ya bágyi kundaa Yiisu, ya báfwulu kundaa nde ti: ");
INSERT INTO tyx_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Mu emakye binduono bi we biigwene okanama ekulu ki bakwuru? Mu kuulu bo ka baakaswagha myaã mu matala mama odza o.» ");
INSERT INTO tyx_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yiisu ábvuhulu kundaa bo ti: «Be mu emakye liigwene okanama mandagha ma ookatumu Nzaami ya be okasalala ekulu ki bakwuru ba be? ");
INSERT INTO tyx_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mu kuulu Nzaami ályele ti: Gwa taara ya ngughu a we budziri, ya ályele si ti: Munde wu aabiili taara a nde bwunu we ngughu a nde epwolo, bafaana odzwa nde. ");
INSERT INTO tyx_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lo be, be liikalyele ti nswe munde wu aalyele kundaa taara a nde bwunu we kundaa ngughu a nde ti: “Bibye bi kaangwa me we mu obaha we, bili ekaba ki aangwa me kundaa Nzaami”, ");
INSERT INTO tyx_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","lo mbwuru wu obo, ka li a nzala a ogwa taara bwunu we ngughu a nde budziri o. Obo me bu liikakahaba be Ndagha a Nzaami mu nkooro a ekulu ki bakwuru ba be. ");
INSERT INTO tyx_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bampibi! Mubighili Edzayi ágyighili obighili mu be ŋa ályele nde ti: ");
INSERT INTO tyx_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ekaana ki okasyighi me yini a mu bibolo, lo mikolo mi bo mili la ya me. ");
INSERT INTO tyx_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nsamana a bo mu me yi a bwunu, mu kuulu maluo ma bali mu okabululuo bo yini a mandagha ma ookatumu embwuru baakanama.» ");
INSERT INTO tyx_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ŋa mbihi oŋo, bu ati mpwumu a baara mbili, nde ályele kundaa bo ti: «Ligyughu ya libaghala! ");
INSERT INTO tyx_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ka oli ki eekasomo mu muŋma eekasumunu mbwuru o, lo me mimye mi miikapala mu muŋma, miikasumunu mbwuru.» ");
INSERT INTO tyx_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Oŋo binduono bíyasele ku bele a Yiisu ya bílyele kundaa nde ti: «We gyahaba ti ba-Faridzyẽ baamono mpara mu mikolo ŋa baagyughu bo mandagha ma we mamo?» ");
INSERT INTO tyx_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yiisu ábvuhulu kundaa bo ti: «Nswe muti wuulu ka oli Taara a me mu yulu aakunu nde o, sa batumunu nde. ");
INSERT INTO tyx_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Linyaã bo! Bo bali binkpa-mihi bi biikabulubiri bambaala binkpa-mihi. Kala ti enkpa-mihi eekabulubiri mbaala enkpa-mihi, bye binsa byele sa biyibwa mu dzunu.» ");
INSERT INTO tyx_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piere ályele kundaa nde ti: «Gwa bihi mbaala a nkumu yi.» ");
INSERT INTO tyx_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yiisu ábvuhulu ti: «Behe si nkini ka lili a mayele ma obaghala o? ");
INSERT INTO tyx_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bunu, be ka lisoolo o ti bye byehene bi biikasomo mu muŋma, biikasughuru mu mweẽ, ya baakatsili bye ku nto a nkwulu? ");
INSERT INTO tyx_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lo mandagha ma maakapala mu muŋma ku mukolo maakafa, ya me mo maakasumunu mbwuru. ");
INSERT INTO tyx_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mu kuulu mu mukolo ookapala bitsimi bi bibi, odzwa baara, obvughu mbughu ya mukala bwunu we mulumu a nganda-mbwuru, enkwunu, pfyibi, bumpughulu bubu mpya, otsaala babake. ");
INSERT INTO tyx_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Bibye biikasumunu mbwuru! Lo odza kuulu myaã oswagha we, ka okughu osumunu mbwuru o.» ");
INSERT INTO tyx_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ŋa nseele Yiisu ámara oŋo, ágyene ku etsulu e nsie kii Tire ya Sidõ. ");
INSERT INTO tyx_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mukaha mutsyini wu musi kaana wu áakakala mu etsulu e nsie ekye, ágyi kundaa Yiisu, ákakehe bingubu kundaa nde ti: «Mfumu, Mwana a Dabvide, mono me nyiĩ! Mufulu wu mubi li mu okamwehẽ mwana a me wu mukaha kimini.» ");
INSERT INTO tyx_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yiisu ka ábvuhulu nde si ndagha mo o. Binduono bi nde bíyasele ya bílyele kundaa nde ti: «Bvurulu mukaha wu, mu kuulu nde li mu okayakehe bingubu ŋa mbihi a bihi-a-be.» ");
INSERT INTO tyx_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yiisu ábvuhulu kundaa bo ti: «Yini a kundaa bindoomo bi basi Isarayele bi bídzimini baagweghe me.» ");
INSERT INTO tyx_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Lo mukaha munde ágyi, ákunu mabuo ŋa nkulu a nde ya ályele ti: «Mfumu, baha me!» ");
INSERT INTO tyx_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yiisu ábvuhulu ndiri: «Ka oli bubwe o mu ogwolo mampa ma baana ya otsili mo kundaa baana ba bambwa.» ");
INSERT INTO tyx_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mukaha ályele ti: «Bwunu obo Mfumu! Lo baana ba bambwa baakadza mfi-mfihini yi aakabwa ku nsie a tabele li bamfumu ba bo.» ");
INSERT INTO tyx_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Oŋo Yiisu ábvuhulu kundaa mukaha ti: «Mukaha, kana li we lili li linene! Nyaã okala kundaa we bwunu a bu dzyi we.» Ya mwana a nde wu mukaha ádzughu mu matala maana mamo. ");
INSERT INTO tyx_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yiisu bu amara oŋo, ágyene ku mukogho a mubu wu a Ngalile. Nde ákumu ku yulu a munguo ya ábwi nsini oko. ");
INSERT INTO tyx_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mampwumu ma baara balagha mágyi kundaa nde, báyabiri banga a bipfwumu, binkpa-mihi, bikara, bankini ya babyele balagha bakimi. Bo bátwulu bo ŋa myili mi nde, ya nde ádzuhu bo. ");
INSERT INTO tyx_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Baara bákiŋimi mu omono bankini mu obili, banga-a-bipfwumu mu odzughu, bikara mu odzyara, binkpa-mihi mu omono. Ya bo bákasyighi Nzaami a Isarayele. ");
INSERT INTO tyx_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yiisu áti binduono bi nde mbili, ya ályele kundaa bo ti: «Me ndi a nyiĩ a mpwumu a baara yi, mu kuulu bitsughu bitere ayi bamaasa ŋa ya me, ya bo ka bali a bi-odza o. Me ka ndzyi obvurulu bo ya nzala o, mara bayibwa-kulu mu nzili.» ");
INSERT INTO tyx_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Binduono bílyele kundaa nde ti: «Kunsa syehe kunu, kunu-ako liibagha mampa ma malagha ma oogyughuru mpwumu a baara yi alagha yi?» ");
INSERT INTO tyx_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yiisu ályele kundaa bo ti: «Mampa kpe be lili a mo?» Bo bábvuhulu nde ti: «Nsaama, ya mana a binswi-nswi.» ");
INSERT INTO tyx_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yiisu átumu mpwumu a baara yibwa nsini ŋa nsie, ");
INSERT INTO tyx_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ágwolo mampa nsaama ya banswi, bu abvuhulu matuono kundaa Nzaami, nde átsyiri mo ya ágwi mo kundaa binduono bi nde. Ya binduono bi nde bíkaba mo kundaa mampwumu ma baara. ");
INSERT INTO tyx_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bo bwohono báli ya bágyughuru. Ya bábiri bitubu nsaama bi bilwulu mu bitsulu bi bísyili. ");
INSERT INTO tyx_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Babo ba báli bye báli mapfwunu mana (4 000) ma babaghala, gwene a otala bakaha ya baana ba basala. ");
INSERT INTO tyx_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ŋa mbihi, bu abvurulu mampwumu ma baara, nde ásomo munsa bwara ya ágyene ku etsulu e nsie kii Mangandane. ");
INSERT INTO tyx_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ba-Faridzyẽ ya ba-Saduseyẽ báyabehene kundaa Yiisu, ya bátsihi nde. Bo báluomo nde asuo bo elyimi ki eefa ku yulu. ");
INSERT INTO tyx_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yiisu ábvuhulu kundaa bo ti: «Ŋa ookadzyama tala, be liikalyele ti: “Sa okala a matala ma mabwe, buulu yulu libie.” ");
INSERT INTO tyx_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ya mu epala be liikalyele ti: “Lolo mvulu sa anoõ, mu kuulu yulu lipyini.” Be lisoolo obaghala bifa bi mayulu, lo be ka likughu obaghala bilyimi bibi matala o! ");
INSERT INTO tyx_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Eseene ki ebi ya kii gwene a mukama mu Nzaami ki eli mu okasagha elyimi! Ka basuo kye elyimi o, kala ti ka kii Dzonase o.» Ya nde ábulusihi bo oŋo ya ágyene. ");
INSERT INTO tyx_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Binduono bi Yiisu bu bipala mu ngulu yinke yi mubu, bye bídzimini ogwolo mampa. ");
INSERT INTO tyx_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yiisu ályele kundaa bye ti: «Limono ya lisa mayele mu pfini li ba-Faridzyẽ ya ba-Saduseyẽ!» ");
INSERT INTO tyx_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bo bábwi otsimi bomo ya bályele ti: «Ampe mu kuulu bihi ka liigwolo mampa o.» ");
INSERT INTO tyx_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Lo Yiisu bu asoolo bitsimi bi bo, nde ályele kundaa bo ti: «Baara baba kana li lisala, mu emakye be liitsimi ti mu nkooro a bu ligwene a mampa? ");
INSERT INTO tyx_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Be nkini liibaghala o? Be limaadzimini nsimi a mampa mataana ma liikaba kundaa mapfwunu mataana (5 000) ma babaghala. Ya mutala a bitubu bi liitolo? ");
INSERT INTO tyx_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ngu okala mampa nsaama ma liikaba kundaa mapfwunu mana (4 000) ma babaghala. Ya mutala a bitubu bi liitolo? ");
INSERT INTO tyx_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bunu, be ka liibaghala o ti me ka aambili kundaa be mu nkooro a mampa o, ŋa aandyele me be ti: “Limono ya lisa mayele mu pfini li ba-Faridzyẽ ya ba-Saduseyẽ!”» ");
INSERT INTO tyx_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Oŋo bo bághala ti Yiisu ka ákabili mu osa mayele mu pfini li mampa o, lo mu maluo ma ba-Faridzyẽ ya ba-Saduseyẽ. ");
INSERT INTO tyx_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yiisu bu ato mu etsulu e nsie ki eli bele ya bvulu lili Sedzare lili Filipe, nde áfwulu kundaa binduono bi nde ti: «Mu mbiili a baara, Mwana a mbwuru nande ali?» ");
INSERT INTO tyx_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bo bábvuhulu nde ti: «Mu bana ti me Dzã Muboghoro, babake ti me Eli, bakimi ti me Dzeremi bwunu we mumõ ŋa kara li mibighili». ");
INSERT INTO tyx_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yiisu áfwulu bo ti: «Lo mu be, me nande ndi?» ");
INSERT INTO tyx_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simõ Piere ábvuhulu ti: «We li Kriste, Mwana a Nzaami wu a mweẽ.» ");
INSERT INTO tyx_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Mu obo, Yiisu ályele kundaa nde ti: «Esee kundaa we, Simõ mwana a Dzonase, buulu ka oli musunu ya makili biisuo we ndagha oyo o, lo Taara a me wu li mu mayulu. ");
INSERT INTO tyx_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ya mehe si me ndyele kundaa we ti: We li limeẽ, ya ŋa yulu a limeẽ li me sa ntwu Libwunu li me. Ya lileene li lipfu ka libvulu lili lo mu mpini o. ");
INSERT INTO tyx_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Me sa ngwa we mankogholo ma Emfumu ki mayulu. Mamo ma aakuru we ŋa nsie, sa bakuru mo mu mayulu. Ya mamo ma akala aanyana we ŋa nsie, sa banyana mo mu mayulu.» ");
INSERT INTO tyx_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mu obo nde átswi binduono bi nde mukele binyaã olyele kundaa mbwuru si mumõ ti nde me Kriste. ");
INSERT INTO tyx_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Obaana mu matala mamo, Yiisu ábwi osuo epankala kundaa binduono bi nde ti: «Me mfaana okumu ku Yerusaleme ya omono mpara yi alagha ŋa myaã mi bakwuru, bakwuru ba bangaa ba nzaami ya baluo-mikyene, bafaana odzwa me, ya mu etsughu kii bitere, me sa nsighili mu lipfu.» ");
INSERT INTO tyx_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piere ábiri Yiisu mu libee, ábwi ofyẽ nde ya ályele kundaa nde ti: «Mfumu, nyaã Nzaami akala we mu mimye! Pele, mandagha mamo manyaã obwa mu we!» ");
INSERT INTO tyx_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Lo nde bu akaghala, ályele kundaa Piere ti: «Satana, mara ŋa nkulu a me! We li kya mu nzili a me, mu kuulu bitsimi bi we ka bili bitsimi bi Nzaami o, lo bili bibi baara.» ");
INSERT INTO tyx_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ŋaana oŋo, Yiisu ályele kundaa binduono bi nde ti: «Kala ti mbwuru dzyi onama me, lo atunu nyuru a ndeme, agwolo kuruwa li nde ya anama me. ");
INSERT INTO tyx_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mu kuulu, nswe munde wu dzyi obvwuhu laama li nde, sa apfihili lo. Lo munde wu aapfihili laama li nde mu nkooro a me, nde sa afiribagha lo. ");
INSERT INTO tyx_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nsa ndaana mbwuru aakala a yo, kala ti nde bagha busini bu nsie nsyini ya pfihili laama li nde? Bwunu we, emakye mbwuru akughu ogwa ki eli a mupfunu mu oswumu laama li nde? ");
INSERT INTO tyx_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mu kuulu, Mwana a mbwuru li mu ogya ya bangye-yulu ba nde kunsa nsia a Taara a nde. Ya oŋo nde sa agwa kundaa mbwuru-mbwuru bwunu a bu oli bigyighili bi nde. ");
INSERT INTO tyx_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mu engaŋma me ndyele be ti: Babake ŋa kara li ba lili ŋa, ka bakpa o nsomo bamono Mwana a mbwuru mu ogya mu Emfumu e nde.» ");
INSERT INTO tyx_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Bitsughu bisemene bu biluru, Yiisu ágwolo Piere, Dzake ya Dzã mbwee a Dzake, ya ábiri bo mu libee ku yulu a munguo wu mula. ");
INSERT INTO tyx_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nde ákighiri ŋa nkulu a bo: Edzili e nde ébwi osehene ti tala, binkuru bi nde bípeŋeme ti otsyeme. ");
INSERT INTO tyx_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mono, Moyidze ya Eli báyamoŋono kundaa bo, mu okabili ya nde ");
INSERT INTO tyx_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piere ályele kundaa Yiisu ti: «Mfumu! Oli bubwe ti bihi-a-be likala ŋa. Kala ti we dzyi, lo me ntwu bibvulu bitere ŋa, emõ kii we, emõ kii Moyidze, ya emõ kii Eli.» ");
INSERT INTO tyx_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nde áli nkini mu okabili, mono, edzi kii otsyeme éfughu bo, ya mono, likyi lífi kunsa edzi ya lílyele ti: «Wu me Mwana a me wu mukolo, mu nde me aankamono esee, ligyughu nde!» ");
INSERT INTO tyx_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Binduono bu bigyughu obo, bíbwi mapfumunu masu mu nsie, bye bíli a nzalamweẽ yi alagha. ");
INSERT INTO tyx_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yiisu áyasele, bu aberene bo ályele ti: «Litemene! Ka likala a nzalamweẽ o.» ");
INSERT INTO tyx_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bu basiili masu ma bo, bo bámono yini a Yiisu ngasighi. ");
INSERT INTO tyx_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ŋaala bo mu okakumunu munguo, Yiisu átswi bo mukele wu: «Ka lilyele kundaa mbwuru si mumõ o, mandagha ma liimono be, tee etsughu ki oosighili Mwana a mbwuru ŋa nsa ba bákpi.» ");
INSERT INTO tyx_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Binduono bífwulu kundaa nde ti: «Mu emakye baluo-mikyene baakalyele ti Eli faana ogya nsomo?» ");
INSERT INTO tyx_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nde ábvuhulu kundaa bo ti: «Ngaŋma! Eli faana ogya mu obvurulu bilogho byehene nsumu. ");
INSERT INTO tyx_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lo me ndyele kundaa be ti Eli maagya, ya baara ka baasoolo nde o, lo baasi nde nswe mimye mi baadzyi bo. Bwunu obo si, bo sa bamwehẽ Mwana a mbwuru mpara.» ");
INSERT INTO tyx_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ŋaana oŋo binduono bíbaghala ti nde mu Dzã Muboghoro ákabili kundaa bo. ");
INSERT INTO tyx_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bu bato ŋa bele a mpwumu a baara, mbwuru mumõ áyakunu mabuo ŋa nkulu a Yiisu, ");
INSERT INTO tyx_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ya ályele ti: «Mfumu, mono mwana a me wu baghala nyiĩ, mu kuulu nde li a ebyele ki nzyere ya li mu okamono mpara yi alagha. Emvulu-gughu nde aakabwa ku mbaa bwunu we mu madza. ");
INSERT INTO tyx_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Me aambiri nde kundaa binduono bi we, lo bye ka biileene odzuhu nde o.» ");
INSERT INTO tyx_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yiisu ábvuhulu ti: «Aa! Eseene ki egwene a kana ya ki egwuŋumu! Tee nki matala me aankuru mukolo mu be? Ligya a me nde ŋa.» ");
INSERT INTO tyx_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yiisu áŋaã mufulu wu mubi ebaghala, nde ápala mu mwana ya mu matala maana mamo, mwana ádzughu. ");
INSERT INTO tyx_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mu obo binduono bíyasele kundaa Yiisu, bífwulu nde ŋa ebini kii bo ngasighi ti: «Mu emakye bihi liikwono obyi mufulu wu mubi munde?» ");
INSERT INTO tyx_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nde ábvuhulu kundaa bo ti: «Mu nkooro a kana li be li lisala. Mu engaŋma me ndyele kundaa be ti, kala ti be lili a kana li linene ti liburu li muti a mutaade, be sa lilyele kundaa munguo wu ti: “Mara ŋa. Gye kunii”, ya nde sa agye. Ka oli a ndagha yi liikuono a be o.»  ");
INSERT INTO tyx_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Lo yini a mu lisamana ya mu okuru nswele mu bala be likughu obyi mufulu wu obo. ");
INSERT INTO tyx_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Etsughu nga-emõ, bu babvuŋunu ku Ngalile, Yiisu ályele kundaa bo ti: «Sa batyeghe Mwana a mbwuru ŋa myaã mi baara, ");
INSERT INTO tyx_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bo sa badzwa nde, ya mu etsughu kii bitere, nde sa asighili mu lipfu.» Binduono bísomo kunsa minyoõ mi milagha. ");
INSERT INTO tyx_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Bu bato ku Kaperenawume, mintolo-mpagha míyasele kundaa Piere ya mífwulu kundaa nde ti: «Bunu, Muluo a be ka aakafiri mpagha a Nzo a nzaami o?» ");
INSERT INTO tyx_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nde ábvuhulu ti: «Nde aakafiri yo.» Piere bu abvughuru ku nzo, Yiisu átswama olyele kundaa nde ti: «Simõ, we bunu tsimi, mikogho mi nsie, kundaa bana miikaluomo mi bátsyiri ya mpagha? Kundaa baana ba bomo bwunu we kundaa banzyi?» ");
INSERT INTO tyx_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piere ábvuhulu ti: «Kundaa banzyi». Yiisu ályele ti: «Mu obo, baana ka baakafiri o. ");
INSERT INTO tyx_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mu kuulu bihi a we linyaã okala makya kundaa baara, gye yitubu ndobo mu mubu. Gwolo nswi wu a nsomo wu aalobo we, dzubulu muŋma a nde, we sa mono mupara. Gwolo nde ya gye yigwa bo nde mu nkooro a me ya we.» ");
INSERT INTO tyx_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mu matala mamo, binduono bi Yiisu bíyasehe kundaa nde ya bifwulu nde ti: «Nande bvulu bukwuru mu Emfumu ki mayulu?» ");
INSERT INTO tyx_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nde bu ati mwana wu asala mbili, átwulu nde ŋa kara-a-kara li bo ");
INSERT INTO tyx_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ya ályele ti: «Mu engaŋma me ndyele kundaa be ti, kala ti be ka ligyiŋi mayele ya likala ti anga baana ba basala o, lo be ka lisomo mu Emfumu ki mayulu o. ");
INSERT INTO tyx_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mu obo, nswe munde wu akughulu ti anga mana mwana wu, me munde wu bvulu bukwuru mu Emfumu ki mayulu. ");
INSERT INTO tyx_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ya munde wu aagyagha mwana ti anga wu mu nkwumu a me, lo meme nde agyagha.» ");
INSERT INTO tyx_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Nswe munde wu aabwihi mu lisumu, mumõ mu bike-bike bi biikasa kana mu me bi, lo bubwe bakuru nde limeẽ li linene mu nkyighi, batsili nde ku nsie a mubu. ");
INSERT INTO tyx_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nyiĩ kundaa baara ba nsie yi, mu kuulu mi miikasa ti baara bakubu makya, mili milagha! Mu engaŋma, okubu makya ofaana okala, lo nyiĩ kundaa mbwuru wu aakasa ti babake bakubu makya! ");
INSERT INTO tyx_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kala ti kwogho bwunu we kwulu e we eekabwihi we mu masumu, tsyiri kye tsili, kye la ya we. Obvulu bubwe kundaa we mu osomo mu laama li engaŋma ya kwogho bwunu we kwulu etsyini, ya bu kala a myaã ya myili minsa myele ya batsili we ku mbaa yi a mibvu ya mibvu. ");
INSERT INTO tyx_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ya kala ti lihi li we liikabwihi we mu masumu, lo sorolo lo, tsili lo la ya we. Obvulu bubwe kundaa we mu osomo mu laama lili engaŋma ya lihi limõ, ya bu kala a mihi minsa myele ya batsili we ku mungele a mbaa.» ");
INSERT INTO tyx_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Lisa mayele! Ka libele mwana si mumõ mu bike-bike bi o, mu kuulu me ndyele kundaa be ti, mu mayulu, bangye-yulu ba bo baakatemene matala mwohono ŋa nkulu a Taara a me wu li mu mayulu.  ");
INSERT INTO tyx_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mu kuulu Mwana a mbwuru aagyi mu obvwuhu babo ba bádzimini. ");
INSERT INTO tyx_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Be bunu litsimi? Kala ti mbwuru li a bindoomo nkama (100), ya emõ mu bye egwuŋumu, nde ka asihi bindoomo makwumu-wa ya wa (99) ku yulu a munguo mu oyisagha ekye ki eegwuŋumu o? ");
INSERT INTO tyx_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ya kala ti nde mono kye, mu engaŋma me ndyele kundaa be ti, nde sa akala a esee ki ebvulu mu kye, ya ki ali a nde mu bindoomo makwumu-wa ya wa (99) bi biigwene ogwuŋumu. ");
INSERT INTO tyx_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bwunu obo si, Taara a be wu li mu mayulu dzyi ti si mumõ mu bike-bike bi ka dzimini o.» ");
INSERT INTO tyx_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Kala ti nganda-mbwuru gyighili we ndagha yi mbi, gye yimono nde ya syeme nde ŋa o be buolo. Kala ti nde gyughu we, lo we aafiribagha nde. ");
INSERT INTO tyx_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Lo, kala ti nde ka gyughu we o, gwolo mbwuru mumõ bwunu we baara buolo bakimi bakala ya we, mu kuulu ligyighili ndagha oyo ŋa nkulu a bampughulu buolo bwunu we batere. ");
INSERT INTO tyx_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kala ti nde bihi ogyughu bo, lo lyele ndagha oyo ŋa nkulu a emvuŋunu e nzaami. Ya kala ti nde bihi ogyughu emvuŋunu e nzaami, lo nyaã nde akala kundaa we ti anga mbwuru wu aagwene okasa kana mu Nzaami, bwunu we muntolo-mpagha.» ");
INSERT INTO tyx_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Mu engaŋma, me ndyele kundaa be ti: Nswe ndagha yi akala liikuru be ŋa nsie sa bakuru yo mu mayulu, ya nswe ndagha yi akala liinyana be ŋa nsie, sa banyana yo mu mayulu.» ");
INSERT INTO tyx_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Me firindyele be ti: «Kala ti baara buolo ŋa kara li be bagwihini ŋa nsie mu oluomo ndagha nswe ndagha mu lisamana, lo Taara a me wu li mu mayulu sa agyighili bo yo. ");
INSERT INTO tyx_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mu kuulu, oŋo ŋa oobvuŋunu baara buolo bwunu we batere mu nkwumu a me, me ndi ŋa kara li bo.» ");
INSERT INTO tyx_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Oŋo, Piere áyasele ŋa ndaa Yiisu ya áfwulu nde ti: «Mfumu! Mansa kpe me mfaana osa nganda-mbwuru kolokolo, kala ti nde gyighili me ndagha yi mbi? Tee mansa nsaama?» ");
INSERT INTO tyx_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yiisu ábvuhulu kundaa nde ti: «Me ka ndyele kundaa we ti tee mansa nsaama o, lo tee mansa makwumu nsaama (70) mbala nsaama. ");
INSERT INTO tyx_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Me mu obo Emfumu ki mayulu efaana ti bu: Mukogho mutsyini ádzyi ti basala ba nde basuo nde bu basalala bo nzi a nde. ");
INSERT INTO tyx_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mu obaana, báyabiri kundaa nde munde wu áli a ebyimi ya nde kii mafwunu mwolo (10 000) ma mipara. ");
INSERT INTO tyx_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Buulu nde ka áli a nzi yi ofiri ebyimi ekye o, mfumu a nde ágwi litumu batyeghe nde, mukala a nde, baana ba nde ya bilogho bi nde byehene, mu kuulu bafiri ebyimi e nde. ");
INSERT INTO tyx_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mu obo, musala ábwi ŋa nsie a myili mi mfumu a nde, ákunu mabuo ŋa nsie ya ályele ti: “Makuru mukolo a we mu okebe, ya sa me mfiri ebyimi e we kyehene.” ");
INSERT INTO tyx_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mfumu bu ámono musala a nde nyiĩ, nde ányaghala ebyimi e nde, ya ányaã nde agye. ");
INSERT INTO tyx_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Musala munde bu apala, ábwana a mumõ mu banganda ba nde baba esala wu áli a ebyimi ya nde kii nkama (100) a mipara mimi bisyeẽ. Nde ábwirili nde, ápyere nde ŋa bolo, ya ályele kundaa nde ti: “Firi ebyimi ki ásuomo we kundaa me.” ");
INSERT INTO tyx_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nganda a nde ákunu mabuo ŋa nsie ŋa nkulu a nde, ya ábuono nde ti: “Makuru mukolo a we mu okebe, ya me sa mfiri ebyimi e we kyehene.” ");
INSERT INTO tyx_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lo wu muke ábihi, nde ágyene áyilo nde mu boloko tee mu matala ma áfiri nde ebyimi ekye. ");
INSERT INTO tyx_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Basala babake bu bamono mi míluru, basomo kunsa minyoõ mi milagha ya báyitwoho myehene mi míluru kundaa mfumu a bo. ");
INSERT INTO tyx_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mu obo, mfumu áti nde mbili ya ályele kundaa nde ti: “We li musala wu mubi! Me aanyaghala ebyimi e we kyehene mu nkooro a bu aabuono we me. ");
INSERT INTO tyx_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wehe si, we áli faana omono nganda a we nyiĩ ti bu aamono me we nyiĩ.” ");
INSERT INTO tyx_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ya mu nkehe, mfumu ágweghe nde mu oyisala engaama tee ŋa aamana nde ebyimi kyehene ofiri». ");
INSERT INTO tyx_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yiisu áfiribwehe ndiri: «Bwunu obo si Taara a me wu li mu mayulu akala aasa mu be, kala ti mbwuru-mbwuru mu be ka si nganda kolokolo mu mukolo a nde mumõ o.» ");
INSERT INTO tyx_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yiisu bu amana ogwa maluo mamo, nde ámara ku Ngalile, ya ágyene ku etsulu e nsie kii Yude, ku ngulu a mwele wu a Dzurudẽ. ");
INSERT INTO tyx_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mampwumu ma baara mánama nde, ya oko nde ádzuhu babyele balagha. ");
INSERT INTO tyx_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ba-Faridzyẽ báyasele kundaa Yiisu mu otsihi nde. Bo báfwulu nde ti: «Mu mikyene mi bihi-a-be, mbwuru li a muswa mu obyi mukala a nde mu nswe ebili?» ");
INSERT INTO tyx_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yiisu ábvuhulu kundaa bo ti: «Be nkini lítala mandagha ma básono mu mukaana a Nzaami o ti: “Mu ebaana, Mugyighili ámyene bo baghala ya mukaha?” ");
INSERT INTO tyx_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ya Nzaami ályele ti: “Me mu obo, baghala faana osihi nzo a taara ya ngughu a nde mu oyikala emõ ya mukala a nde, ya bo bansa buolo sa bakala mbwuru mumõ”. ");
INSERT INTO tyx_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mu obo, bo ka bafirikala baara buolo o, lo bo ayi mbwuru mumõ. Nyaã mbwuru ka kabala ba óbvughu Nzaami o!» ");
INSERT INTO tyx_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ba-Faridzyẽ báfwulu nde ti: «Mu emakye Moyidze ágwi baghala muswa wu ogwa mukala a nde mukaana wu odzwa mabala, ŋa ali mu okabyi nde?» ");
INSERT INTO tyx_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yiisu ábvuhulu kundaa bo ti: «Mu nkooro a mikolo mi be mi mikubu Moyidze ágwi be muswa mu obyi bakala ba be. Lo ku ebaana, ka óli obo o. ");
INSERT INTO tyx_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Lo me ndyele kundaa be ti: Nswe munde wu aabyi mukala a nde, kala ti ka oli mu enkwunu o, ya nde kye mukaha mukimi, lo nde bukala asi.» ");
INSERT INTO tyx_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Binduono bi nde bílyele kundaa nde ti: «Kala ti leme me lilo mulumu afaana okala a lo ŋa nkulu a mukala a nde, lo ka oli mupfunu mu okye o.» ");
INSERT INTO tyx_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yiisu ábvuhulu kundaa bo ti: «Ka oli baara bwohono baabaghala maluo ma o. Lo yini a babo ba ógwi Nzaami muswa mu obaghala mo. ");
INSERT INTO tyx_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Baara bana ka bakye o, mu kuulu bo bali bamfi obaana emburu-ngughu. Ba bake, bákala bamfi mu ku bágwogholo bo. Ba bake si bákala bamfi mu nkooro a Emfumu ki mayulu. Nyaã wu kughu obaghala, abaghala!» ");
INSERT INTO tyx_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Baara báyabiri bike-bike kundaa Yiisu, kuulu nde anaã bye myaã ya asamana mu nkooro a bye. Lo binduono bísyeme baara babo. ");
INSERT INTO tyx_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mu obo, Yiisu ályele ti: «Linyaã bike-bike bigya, ka likahaba bye mu ogya kundaa me o, mu kuulu Emfumu ki mayulu eli kii ba bali ti anga bye.» ");
INSERT INTO tyx_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ya bu amana onaã bye myaã, nde ámara ŋa ebini ekye. ");
INSERT INTO tyx_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ya mono, baghala mutsyini áyasele kundaa Yiisu, ya ályele nde ti: «Muluo, emakye ki ebwe me mfaana osa mu obagha laama lili mibvu ya mibvu?» ");
INSERT INTO tyx_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yiisu ályele kundaa nde ti: «Mu emakye we li mu ogwa me efwulu mu mi mibwe? Yini a mumõ li mubwe. Kala ti we dzyi osomo mu laama lili mibvu ya mibvu, kebe mikyene.» ");
INSERT INTO tyx_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Baghala munde áfwulu kundaa Yiisu ti: «Nki mikyene?» Yiisu ábvuhulu nde ti: «Ka dzwa o, ka bvughu mbughu ya mukala bwunu we mulumu a nganda-mbwuru o, ka kala mpughulu wu a mpya o, ka turu o, ");
INSERT INTO tyx_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","gwa taara a we ya ngughu a we budziri, ya Dzyi nganda-mbwuru ti anga weme.» ");
INSERT INTO tyx_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mumpala munde ályele kundaa nde ti: «Mye myehene mimye me aakansalala mye. Emakye me nkughu ofirisa?» ");
INSERT INTO tyx_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yiisu ályele kundaa nde ti: «Kala ti we dzyi okala mukughu, lo gye, tyeghe bi li a we ya gwa nzi kundaa bawele, ya we sa bagha busini mu mayulu. Ŋa mbihi oŋo, gya, nama me!» ");
INSERT INTO tyx_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lo, mumpala munde bu agyughu ndagha oyo, ágyene kunsa minyoõ, mu kuulu nde áli a busini bulagha. ");
INSERT INTO tyx_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yiisu ályele kundaa binduono bi nde ti: «Mu engaŋma me ndyele yo kundaa be, oli mpara kundaa esini mu osomo mu Emfumu ki mayulu. ");
INSERT INTO tyx_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Me firindyele kundaa be ti, ka oli a mpara o kundaa nyama wu baakata Syamo mu oluru mu kuhu li nyoõ, lo obvulu a mpara kundaa esini mu osomo mu Emfumu e Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Binduono bi Yiisu bu bigyughu ndagha oyo, bíkiŋimi ku olagha ya bílyele ti: «Lo nande kughu obvwughu?» ");
INSERT INTO tyx_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yiisu bu atala kundaa bo, ályele ti: «Kundaa baara, ka okughu okala o, lo kundaa Nzaami myehene mikughu okala.» ");
INSERT INTO tyx_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Mu obo, Piere ályele kundaa Yiisu ti: «Mono, bihi liisihi byehene mu onama we. Bunu ookala kundaa bihi?» ");
INSERT INTO tyx_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yiisu ábvuhulu kundaa bo ti: «Mu engaŋma, me ndyele kundaa be ti, mu matala ma obwa Mwana a mbwuru nsini ŋa likubu li nde lili nsia mu nsie yi nyaghara, be ba liinama me, behe si sa libwa nsini ŋa makubu kwumu ya mwolo (12) mu osa madzumu kwumu ya mwolo (12) mama Isarayele muyala. ");
INSERT INTO tyx_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ya nswe munde wu aasihi manzo, bankele ba nde ba babaghala ya ba bakaha, taara, ngughu, baana, bwunu we manseghe mu nkooro a nkwumu a me, lo nde sa abagha bye ku obvulu mansa nkama (100), ya sa abagha pfa lili laama lili mibvu ya mibvu. ");
INSERT INTO tyx_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Balagha ba bali ba bansomo mu matala ma, sa bakala binsiele-mbihi, ya balagha ba bali binsiele-mbihi sa bakala ba bansomo.» ");
INSERT INTO tyx_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Emfumu ki mayulu eli ti anga mfumu a nzo wu pala mu epala-epala, mu kuulu agwolo basala ba baayisala mu nseghe a nde yi a bviini. ");
INSERT INTO tyx_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nde ágwihini ya basala babo mu ofiri bo mupara mumõ mu etsughu, ya nde ágweghe bo ku nseghe a nde yi a bviini. ");
INSERT INTO tyx_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mu tala lili wa, nde bu afiripala mu nzo, ámono baara bakimi ba bátemene ŋa ebini emõ gwene a ki baasa. ");
INSERT INTO tyx_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nde ályele kundaa bo ti: “Behe si ligye ku nseghe a me yi a bviini, ya me sa ngwa be mufuru wu a kughu.” ");
INSERT INTO tyx_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bo bágyene. Ya nde bu áfiripala mu tala lili embehe, ya mu lili kwumu ya mataana (15), nde ási bwunu obo. ");
INSERT INTO tyx_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ku bele a tala lili kwumu ya nsaama (17), nde bu afiripala, ámono babake bátemene oŋo ya nde ályele kundaa bo ti: “Mu emakye be liitemene ŋa bwihi butsyini, ku ogwene a elogho osa?” ");
INSERT INTO tyx_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bo bábvuhulu kundaa nde ti: “Mu kuulu ka oli a mbwuru wu aagwolo bihi mu osala o.” Nde ályele kundaa bo ti: “Behe si ligye ku nseghe a me yi a bviini.” ");
INSERT INTO tyx_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nkonkolo bu yito, nga-a-nseghe a bviini ályele kundaa wu aakatumu basala ba nde ti: “Ta basala mbili, ya gwa bo mufuru a bo, obaana mu ba aangwolo me nseele ya mana mu baba nsomo.” ");
INSERT INTO tyx_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Baba tala lili kwumu ya nsaama (17) bágyi, ya mbwuru-mbwuru ábagha mupara mumõ-mumõ. ");
INSERT INTO tyx_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ŋa masini, ba bansomo bágyi, ya bo bákatsimi ti bo sa babagha mufuru wu bvulu, lo boho si bábagha mupara mumõ-mumõ mu mbwuru. ");
INSERT INTO tyx_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bu bagyagha mufuru, bo bábwi oŋuŋunu mu nga-a-nzo. ");
INSERT INTO tyx_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bo bályele ti: “Baba nsiele ba baasala yini a tala limõ, lo we ofuru bo mutala mumõ ya bihi ba liimono mpara mu osala bwihi bu mpwuŋu kunsa kyaŋana kii mpini!” ");
INSERT INTO tyx_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nga-a-nseghe ábvuhulu kundaa mumõ mu bo ti: “Ndughu a me, me ka ndi a epfwumu kundaa we o, bihi a we ka liigwihini mu mupara mumõ o? ");
INSERT INTO tyx_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Gwolo mufuru a we ya mara ŋa. Me ndzyi ogwa kundaa wu aagyi nsiele wu ti bu aangwi me we. ");
INSERT INTO tyx_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Me ka ndi a muswa wu ogyighili mi ndzyi mu nzi a me o? Bunu, we mukolo mubi mu kuulu me ndi mbwuru wu mubwe?” ");
INSERT INTO tyx_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mu obo, baba nsiele sa bakala baba nsomo, ya baba nsomo sa bakala baba nsiele.» ");
INSERT INTO tyx_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mu matala ma ókagye Yiisu ku Yerusaleme, mu nzili nde ábiri binduono kwumu ya byele (12) mu libee, ya ályele kundaa bo ti: ");
INSERT INTO tyx_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Mono! Bihi-a-be lili mu okakumu ku Yerusaleme, ya sa bagwa Mwana a mbwuru ŋa myaã mi bakwuru ba bangaa ba nzaami ya baluo-mikyene. Bo sa bagwolo mukakana wu odzwa nde, ");
INSERT INTO tyx_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ya sa bagwa nde ŋa myaã mi baala ka bali ba-Dzwife o. Bo sa basa nde munsensehẽ, bakaha nde nswa-nswa, bakomo nde ŋa kuruwa, ya mu etsughu kii bitere, nde sa asighili mu lipfu.» ");
INSERT INTO tyx_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ŋaana oŋo, ngughu a baana ba Nzebede ásele kundaa Yiisu ya baana ba nde ba babaghala. Ya nde ákunu mabuo mu nsie mu oluomo ndagha mõ kundaa nde. ");
INSERT INTO tyx_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yiisu áfwulu nde ti: «We emakye dzyi?» Nde ábvuhulu kundaa Yiisu ti: «Sa kuulu ti, ŋa aakala we mukogho, baana ba me buolo ba babwa nsini ya we, mumõ ku ngo-kwogho, ya wu muke ku engbambogho.» ");
INSERT INTO tyx_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yiisu ábvuhulu ti: «Be ka lisoolo mi lili mu okaluomo be o. Bunu, be likughu oŋma ebaha kii kimini ki aaŋma me?» Bo bábvuhulu kundaa nde ndiri: «Bihi likughu.» ");
INSERT INTO tyx_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yiisu ályele kundaa bo ti: «Ebaha e me, be sa liŋma kye. Lo mu mi mitala obwa nsini ku ngo-kwogho e me ya ku engbambogho e me, me ka ndi a litumu lilo o, bibini bibye bili bibi babo ba ogyighili Taara a me bye.» ");
INSERT INTO tyx_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Binduono kwumu bibike bu bigyughu obo, ka bámono esee mu naana ya mbwee o. ");
INSERT INTO tyx_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yiisu áti bo mbili ya ályele kundaa bo ti: «Be lisoolo ti bitumu bi mansie biikamwehẽ baara mpara mu litumu li bo, ya baara baba mupfunu baakasuo leme li emfumu e bo ŋa yulu a babake. ");
INSERT INTO tyx_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ka ofaana okala obo ŋa kara li be o. Lo, munde wu dzyi okala mukwuru ŋa kara li be, nyaã nde akala esala e be. ");
INSERT INTO tyx_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ya kala ti mbwuru mu be dzyi okala wu a nsomo, nyaã nde akala nkana a be. ");
INSERT INTO tyx_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Me mu obo Mwana a mbwuru ka agyi mu kuulu baara basalala nde o, lo mu osalala ya ogwa laama li nde mu ofiri ekolo mu baara balagha.» ");
INSERT INTO tyx_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yiisu ya binduono bi nde bu bakapala mu bvulu lili Dzeriko mpwumu a baara yi nene yíluono nde. ");
INSERT INTO tyx_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ya, binkpa-mihi byele bíbwi nsini mu mukogho a nzili. Bo bu bagyughu ti Yiisu li mu okaluru, bábwi okehe bingubu: «Mfumu, Mwana a Dabvide, mono bihi nyiĩ!» ");
INSERT INTO tyx_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mpwumu a baara yífyeẽ bo mu ebaghala mu kuulu bo bakala pii. Lo bo bábvulu ofirikakehe bingubu mu mpini: «Mfumu, Mwana a Dabvide, mono bihi nyiĩ!» ");
INSERT INTO tyx_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yiisu bu atemene, áti bo mbili ya ályele kundaa bo ti: «Emakye be lidzyi ti me nsa mu be?» ");
INSERT INTO tyx_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bo bábvuhulu nde ti: «Mfumu, nyaã we dzubulu bihi mihi!» ");
INSERT INTO tyx_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yiisu ámono bo nyiĩ, áberene a mihi mi bo, ya ŋaana oŋo, bo bábwi omono ya bánama nde. ");
INSERT INTO tyx_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bu bayabehene ya Yerusaleme ya bato ŋa Betefadze, ŋa bele a Munguo wu a mi-Olibve, Yiisu ágweghe binduono byele. ");
INSERT INTO tyx_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Nde ályele kundaa bo ti: «Ligye ku bula bu buli ŋa nkulu a be, ya oŋo, be sa limono eburu e aane ki baakuru ya mwana a nde. Linyana ya liyabiri me bye. ");
INSERT INTO tyx_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ya kala ti mbwuru lyele be ndagha, be libvuhulu kundaa nde ti: “Mfumu li a nzala a bye.” Ya nde sa anyaã bye bigye.» ");
INSERT INTO tyx_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mandagha ma mábwi mu kuulu mi ólyele mubighili mitswighi: ");
INSERT INTO tyx_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Lilyele kundaa mutughu wu a Siyõ ti: Mono mukogho a we li mu ogya kundaa we, nga-a-edzuunu, ya nde aakumu ŋa yulu a eburu e aane, ŋa yulu a pulu li aane, mwana a nyama wu akabiri bi biri.» ");
INSERT INTO tyx_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Binduono bígyene ya bísi bwunu a bu ótumu bo Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bo bágyene a eburu e aane ya pulu li aane, bátwulu ŋa yulu a biko bi bo, ya Yiisu ábwi nsini ŋa yulu a nde. ");
INSERT INTO tyx_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mpwumu a baara yi alagha yíkagyala binkuru mu nzili, baara babake bátsyiri matsyiri ma miti ya bágyala mo mu nzili. ");
INSERT INTO tyx_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mampwumu ma máli ku nkulu ya ma máli ku mbihi a nde mákabulubiili bingubu: «Odzaana kundaa Mwana a Dabvide! Liseme kundaa munde wu li mu ogya mu nkwumu a Mfumu! Odzaana mu bibini bi bili ku nkara a yulu!» ");
INSERT INTO tyx_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yiisu bu asomo mu Yerusaleme, bvulu lwohono línyiŋi ya baara bákalyele ti: «Wu nande?» ");
INSERT INTO tyx_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mampwumu mákabvuhulu ti: «Wu me Yiisu, mubighili wu a ku Nadzarete, mu Ngalile.» ");
INSERT INTO tyx_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yiisu bu asomo mu nzo a Nzaami, nde ábyi bo bwohono ba bákatyeghe ya ba bákaswumu munsa nzo a Nzaami, átsili batabele ba baakasobo nzi ya bipehe bi minta-nkaala a mabeeme ku mbala. ");
INSERT INTO tyx_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ya nde ályele kundaa bo ti: «Básono ti: “Nzo a me sa bata yo nzo yi a lisamana”. Lo be liikirili yo ngala a bantwumu!» ");
INSERT INTO tyx_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Binkpa-mihi ya banga-a-bipfwumu báyasele kundaa nde munsa nzo a Nzaami, ya nde ádzuhu bo. ");
INSERT INTO tyx_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bakwuru ba bangaa ba nzaami ya baluo-mikyene ka bámono esee o, bu bamono mandagha mama okiŋimi ma ókagyighili Yiisu, ya bike-bike bi bíkabiili bingubu munsa Nzo a nzaami ti: «Odzana kundaa Mwana a Dabvide!» ");
INSERT INTO tyx_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bo bályele kundaa nde ti: «Bunu, we li mu ogyughu bu bali mu okalyele bo?» Yiisu ábvuhulu kundaa bo ti: «Eẽ! Bunu, be nkini ka lítala o ti: “We ási kuulu ti miŋma mi mana bike-bike ya mimi ba bali mu okaŋma mabyene, miwa we masyighi?”» ");
INSERT INTO tyx_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ya bu abulusihi bo oŋo, nde ápala mu bvulu ya ágyene ku Betani, ku áluhu nde mpyibi. ");
INSERT INTO tyx_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mu minkya-nkya, Yiisu bu akayabvughuru ku bvulu, nzala yifuru nde. ");
INSERT INTO tyx_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yiisu bu ataala mufinge mu mukogho a nzili, áyabehene ya nde, lo nde ka ámono elogho o, yini a matsyiri. Nde ályele kundaa nde ti: «Si okala ka bunu, we ka kughu ofiriburu bimburu o!» Ya mufinge ásaakee. ");
INSERT INTO tyx_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Binduono bu bimono obo, bíkiŋimi ya bílyele ti: «Bunu-abo mufinge aasaakee?» ");
INSERT INTO tyx_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yiisu ályele kundaa bo ti: «Mu engaŋma me ndyele kundaa be ti, kala ti be lili a kana ya ka lisi mikeme o, be ka ligyighili yini a mi nsi me mu mufinge o, lo be lilyele kundaa munguo wu ti: “Mara oŋo ya yibwa mu mubu”, lo sa okala obo. ");
INSERT INTO tyx_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nswe ki akala liiluomo be mu lisamana, bu lisi kana, be sa libagha kye.» ");
INSERT INTO tyx_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yiisu ásomo mu nzo a Nzaami. Mu matala ma ákaluo nde, bakwuru ba bangaa ba nzaami ya bakwuru ba ba-Dzwife báyasele ya bályele kundaa nde ti: «Mu nsa litumu we li mu okabulugyighili mamo? Ya na aagwi we litumu lilo?» ");
INSERT INTO tyx_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yiisu ábvuhulu kundaa bo ti: «Mehe si ndi a efwulu, yini a emõ ki aangwa me be, kala ti be ligwi me mvuru, mehe si sa ndyele kundaa be munsa litumu me ndi mu okabulugyighili mamo. ");
INSERT INTO tyx_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","“Nande áagweghe Dzã mu oboghoro baara? Nzaami bwunu we baara?” Bo báfuhunu bo-a-bo ndiri: Kala lilyele ti: “Nzaami”, nde sa alyele kundaa bihi-a-be ti: “Bu mu emakye be liigwene okasa kana mu nde?” ");
INSERT INTO tyx_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ya limana olyele ti: “Baara”, bihi-a-be lifaana osa mayele mu mpwumu a baara, mu kuulu baara bwohono baakagwolo Dzã ti mubighili.» ");
INSERT INTO tyx_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mu obo, bo bábvuhulu kundaa Yiisu ti: «Bihi ka lisoolo.» Ya ndehe si ályele kundaa bo ti: «Mehe si ka andyele be munsa litumu me ndi mu okabulugyighili mamo o.» ");
INSERT INTO tyx_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yiisu áfirilyele ti: «Be bunu litsimi mu ndagha yi? Baghala mumõ áli a baana buolo. Bu ayasele kundaa wu a nsomo, ályele kundaa nde ti: “Mwana me, gye yisala lolo ku nseghe a bviini.” ");
INSERT INTO tyx_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mwana ábvuhulu kundaa nde ti: “Me ka ndzyi o”. Ya mana matala bu maluru, mwana ásobo bitsimi ya ágyene ku nseghe a bviini. ");
INSERT INTO tyx_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nde bu ayasele kundaa wu a buolo, ályele kundaa nde bwunu obo. Mwana ábvuhulu kundaa nde ti: “Mfumu, me ndi mu ogye”. Lo, ka ágyene o. ");
INSERT INTO tyx_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mu bo buolo nande aasi waa li taara a nde?» Bo bábvuhulu ndiri: «Wu a nsomo». Yiisu ályele kundaa bo ti: «Mu engaŋma, me ndyele kundaa be ti, mintolo-mpagha ya bakaha banga-a-enkwunu sa batswama nkulu ya be mu Emfumu e Nzaami. ");
INSERT INTO tyx_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Buulu Dzã ali aagyi kundaa be mu nzili yi a bunsumu, ya be ka liisi kana mu nde o, lo mintolo-mpagha ya bakaha banga-a-enkwunu baasi kana mu nde. Ya ku nkulu, be bu limono obo, be ka liigyiŋi mayele o mu osa kana mu nde.» ");
INSERT INTO tyx_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Ligyughu nkumu yinke. Óli a nga-a-nzo wu ákunu nseghe a bviini. Nde ási yo ekagha, átsimi dzunu li baakakamana mala ya átwu nzo yi mutele wu mula. Ya ŋa mbihi, nde ágwihini ya binkamana bi bviini bikasalala o bo yo, ya nde ágyene midzye.» ");
INSERT INTO tyx_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Matala mama otolo bimburu bu mato, nde ágweghe basala ba nde kundaa binkamana bi bviini mu ogwolo kaba lili ndaa nde. ");
INSERT INTO tyx_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Lo binkamana bi bviini bíbwirili basala ba nde, mumõ bákaha nde nswa-nswa, wunu bádzwi nde, wu muke bádzwi nde mu mameẽ. ");
INSERT INTO tyx_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nde áfirigweghe basala babake ba babvulu olagha ya baba nsomo, ya bágyighili bumõ kundaa bo si. ");
INSERT INTO tyx_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ŋa masini, nde ágweghe bo mwana a nde, ya ályele ti: «Bo sa bagwa mwana a me budziri.» ");
INSERT INTO tyx_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lo binkamana bi bviini bu bimono mwana, bíbili bo-a-bo ti: «Wu me wu aagwolo pfa li taara a nde! Ligya, litswe lidzwa nde ya ligwolo pfa li nde.» ");
INSERT INTO tyx_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bu babwirili nde, bátsili nde ku mbala a nseghe a bviini ya bádzwi nde. ");
INSERT INTO tyx_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Obo me buulu, ŋa akala oogya mfumu a nseghe a bviini, nde bunu aasa mu binkamana bi bviini bi? ");
INSERT INTO tyx_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bo bábvuhulu kundaa nde ti: «Nde sa adzwa ba babi babo ku ogwene a nyiĩ, ya nde sa agwihini ya binkamana bi bviini bikimi bikasalala o bo yo, bi akala bikagwa nde bimburu mu matala ma bye.» ");
INSERT INTO tyx_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ya Yiisu ályele kundaa bo ti: «Bunu, be nkini ka lítala mi básono o: “Limeẽ li ootsili ba baakatwu, me lo ayi lili li linsomo ŋa mutswunu, ndagha oyo yifi kundaa Mfumu, ya ŋa mihi mi bihi, yili ndagha yi okiŋimi!”» ");
INSERT INTO tyx_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Me mu obo me ndyele kundaa be ti: Emfumu e Nzaami, sa bamaha be kye, mu ogwa kye kundaa ekaana ekimi ki eeburu bimburu mu kye. ");
INSERT INTO tyx_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44"," Nswe munde wu akala aabwa ŋa yulu a limeẽ li sa atsaŋama, ya nswe munde wu liibwirili lo, sa apweẽ.» ");
INSERT INTO tyx_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bakwuru ba bangaa ba nzaami ya ba-Faridzyẽ bu bagyughu mankumu mamo, bábaghala ti Yiisu me mu bo ákabili. ");
INSERT INTO tyx_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bo bákasagha bunu baasyimi nde, lo bábara nzalamweẽ a mampwumu ma baara, mu kuulu mo mákagwolo Yiisu ti mubighili. ");
INSERT INTO tyx_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yiisu áfiribili kundaa bo mu mankumu, ya ályele ti: ");
INSERT INTO tyx_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Emfumu ki mayulu efaana ya mukogho mutsyini wu áagyighili kyiri ki mabala ma mwana a nde. ");
INSERT INTO tyx_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nde ágweghe basala ba nde mu oyita ba bágwi mpighi a kyiri kii mabala mbili, lo bo ka bádzyi ogya o. ");
INSERT INTO tyx_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nde áfirigweghe basala bakimi ya ályele bo mu otuoho mukyene wu kundaa ba bágwi mpighi: “Mu matala ma, baamana onaã bi-odza, baadzwi bangoomo ya bibuolo bi me bibi maala, byehene biikughu, ligya ku odza!” ");
INSERT INTO tyx_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lo babo ba bágwi mpighi, bágyene obo ku ogwene okihi mbili, mumõ ku manseghe ma ndeme, wu muke ku nkaala a nde, ");
INSERT INTO tyx_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","bana bu babwirili basala ba nde, bátughu bo ya bádzwi bo. ");
INSERT INTO tyx_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mukogho ákolo nkehe. Nde ágweghe bambumbulu ba nde mu oyidzwa babo ba baadzwi basala ba nde ya otsughu bvulu li bo mbaa. ");
INSERT INTO tyx_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ŋa nseele, nde ályele kundaa basala ba nde ti: “Byehene bibi kyiri kii mabala biikughu, lo ba baagwi mpighi ka baakakala ba bafaana o. ");
INSERT INTO tyx_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ligye mu mapfulu, ya lita baara bwohono ba liimono be mbili bagya ku kyiri.” ");
INSERT INTO tyx_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Basala ba nde bápala, bágyene mu manzili ya bábvughu baara bwohono ba bámono bo, ba babi ya ba babwe. Mbala a kyiri yílwulu mu baara. ");
INSERT INTO tyx_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mukogho bu agyi mu okabulutala ba baagyi ku kyiri, nde ámono mbwuru wuulu ka álaha enkuru kii kyiri o. ");
INSERT INTO tyx_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nde áfwulu kundaa nde ti: “Ndughu a me, we bunu aasi mu osomo mu kuu ogwene a enkuru kii kyiri?” Lo mbwuru munde ka ábvuhulu nde ndagha o. ");
INSERT INTO tyx_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mu obo mukogho ályele kundaa basala ba nde ti: “Likuru nde misyi mu myili ya mu myaã, litsili nde ku mbaala ku oli mpyibi, oko ku ookala bilili ya odza myini.” ");
INSERT INTO tyx_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Baara balagha báti mbili, lo ba básuolo bali ndaama.» ");
INSERT INTO tyx_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mu obo, ba-Faridzyẽ báyikuru mfwunu bunu baaleghebe Yiisu mwere mu mi aabili nde. ");
INSERT INTO tyx_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ŋa mbihi bo bágweghe kundaa nde binduono bi bo, emõ ya baara baba emvuŋunu ki Erode mu olyele ti: «Muluo, bihi ligyahaba ti we nga a engaŋma ya ti we li mu okabululuo baara nzili a Nzaami mu engaŋma, ku ogwene a obara mbwuru, mu kuulu we ka aakatala baara mu bidzili o. ");
INSERT INTO tyx_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Lo lyele bihi, we bunu tsimi mu ndagha yi: Oli a muswa mu ofiri mpagha kundaa Sedzare bwunu we pele?» ");
INSERT INTO tyx_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lo Yiisu bu asoolo bitsimi bi bo bi bibi, ályele kundaa bo ndiri: «Bampibi! Mu emakye be lidzyi otsihi me? ");
INSERT INTO tyx_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Lisuo me mupara wu baakafiri mpagha.» Bo básuo nde denye mumõ. ");
INSERT INTO tyx_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nde áfwulu kundaa bo ti: «Edzili ki ya bisono bi bibi na?» ");
INSERT INTO tyx_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bo bábvuhulu kundaa nde ti: «Bibi ndaa Sedzare.» Mu obo, nde ályele kundaa bo ti: «Libvurulu bibi Sedzare kundaa Sedzare, ya bibi Nzaami kundaa Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bo, bu bagyughu mandagha mamõ, bákiŋimi, bábulusihi nde ya bágyene. ");
INSERT INTO tyx_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mu etsughu ekye, ba-Saduseyẽ ba baakalyele ti osighili mu lipfu ka oli o, báyabehene ku bele a Yiisu ya bo báfwulu nde ti: ");
INSERT INTO tyx_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Muluo, Moyidze ályele ti: “Kala ti baghala kpi ku ogwene oburu baana, mbwee a nde sa akie mupfiili, mu oburu nde baana”. ");
INSERT INTO tyx_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ku bula bu bihi óli a baana nsaama ba baghala baba taara mumõ. Wu a nsomo, kie mukala, kpi ku ogwene a baana, ya sihi mukala a nde kundaa mbwee wu aanama nde. ");
INSERT INTO tyx_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bumõ si kundaa wu a buolo, kundaa wu batere ya tee mu bo bwohono nsaama. ");
INSERT INTO tyx_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ŋa nseele, ŋa mbihi a bo bwohono, mukaha kpi. ");
INSERT INTO tyx_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Lo ŋa akala oosighili baara mu lipfu, nde mukala a na aakala, buulu bo bansa nsaama áli balumu ba nde?» ");
INSERT INTO tyx_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yiisu ábvuhulu kundaa bo ti: «Be liigwuŋumu, mu kuulu ngu okala Bisono, ngu okala lileene li Nzaami, be ka lisoolo bye o. ");
INSERT INTO tyx_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ŋa akala oosighili baara mu lipfu, ka okala a balumu o, bwunu we bakala o, lo bo sa bakala ti anga bangye-yulu mu yulu. ");
INSERT INTO tyx_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ya, mu mi mitala osighili o ba bákpi, be ka lítala ndagha yi ólyele be Nzaami o ti: ");
INSERT INTO tyx_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Me ndi Nzaami a Abarahame, Nzaami a Idzake, ya Nzaami a Dzakobe?” Nde ka li Nzaami a ba bákpi o, lo nde li Nzaami a baba mweẽ.» ");
INSERT INTO tyx_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mampwumu ma baara mákiŋimi ŋa mágyughu mo maluo ma nde. ");
INSERT INTO tyx_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ba-Faridzyẽ bu bagyughu ti Yiisu aakuru miŋma mi ba-Saduseyẽ, bo bábvuŋunu ŋa ebini kyini ekye. ");
INSERT INTO tyx_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ya mumõ mu bo, muluo-mikyene bu adzyi otsihi Yiisu, áfwulu nde ti: ");
INSERT INTO tyx_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Muluo, nsa mukyene bvulu bunene mu Mikyene?» ");
INSERT INTO tyx_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yiisu ályele kundaa nde ti: « “Dzyi Mfumu Nzaami a we mu mukolo a we wohono, mu mugwumu a we wohono ya mu mayele ma we mwohono”. ");
INSERT INTO tyx_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Munde me mukyene wu bvulu bunene ya wu a nsomo. ");
INSERT INTO tyx_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wu a myele wu a faana a nde me wu: “Dzyi nganda-mbwuru a we ti budzyi weme”. ");
INSERT INTO tyx_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mikyene myehene ya mibighili mili kunsa mikyene myele mi.» ");
INSERT INTO tyx_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Buulu ba-Faridzyẽ áli bábvuŋunu, Yiisu áfwulu kundaa bo ti: ");
INSERT INTO tyx_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Etsimi e be bunu eli mu nkooro a Kriste? Nde mwana a na ali?» Bo bábvuhulu kundaa nde ti: «Wu a Dabvide.» ");
INSERT INTO tyx_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nde ályele kundaa bo ti: «Lo bunu-a-bo, mu Mufulu, Dabvide áti nde “Mfumu”, ŋa ályele ti: ");
INSERT INTO tyx_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Mfumu aalyele kundaa Mfumu a me ti: Bwa nsini ŋa kwogho e me kii babaghala tee ŋa aantwulu me mitaara mi we ŋa nsie a myili mi we? ");
INSERT INTO tyx_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kala ti Dabvide li mu ota nde “Mfumu”, lo bunu nde akughu ofirikala mwana a nde?» ");
INSERT INTO tyx_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mbwuru si mumõ ka ákughu ogwa Yiisu mvuru mu ndagha nsyini o. Ya obaana etsughu ekye, ka oli a mbwuru wu áafirikabagha bukyini mu ogwa nde bifwulu o. ");
INSERT INTO tyx_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mu obo Yiisu ábili kundaa mampwumu ma baara ya kundaa binduono bi nde ti: ");
INSERT INTO tyx_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Esala ki Baluo-mikyene ya ba-Faridzyẽ me mu okabaala Mikyene mi Moyidze. ");
INSERT INTO tyx_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Be, liikagyighili ya liikakebe mandagha mwohono ma baakalyele bo be, lo ka likanama bigyighili bi bo o, mu kuulu bo baakabili, lo ka baakagyighili mi baakabili o. ");
INSERT INTO tyx_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bo baakakuru matsulu mama leme ya mpara mu obiri ya baakanaã mo ŋa yulu a bisaŋama bi baara. Lo bomo, ka baakaberene a mo mu mulyeme o. ");
INSERT INTO tyx_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bigyighili bi bo byehene bili mu nzala a omoŋono ŋa mihi mi baara. Bo baakagyighili mipa mi minene mu básono mandagha ma Nzaami mi baakalaha ŋa yulu a mbwi bwunu we ŋa kwogho mu matala ma baakasamana bo, ya baakalabala manto ma binkuru bi bo. ");
INSERT INTO tyx_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bo badzyi bibini bi binsomo mu byiri bibi odza ya bibini bi binsomo mu manzo ma lisamana ma ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ya bo badzyi ti bakagwa bo mamboro mu bibini bibi baara bwohono, ya badzyi ti baara bakata bo Muluo . ");
INSERT INTO tyx_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lo be, banyaã okata be Muluo, mu kuulu be lili a Muluo yini a mumõ, ya be bwohono lili bakulu ya bambwee. ");
INSERT INTO tyx_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ka likata mbwuru si mumõ “Taara” a be ŋa nsie o. Mu kuulu be lili a nde yini a mumõ, Taara wu li ku yulu. ");
INSERT INTO tyx_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Banyaã si okata be “Mugyihi wu munene”, mu kuulu be lili a mugyihi yini a mumõ, ngu Kriste. ");
INSERT INTO tyx_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wu bvulu bukwuru ŋa kara li be akala musala a be. ");
INSERT INTO tyx_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Munde wu aakumu sa basurulu nde, ya munde wu aasughuru sa bakuhubu nde.» ");
INSERT INTO tyx_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Nyiĩ kundaa be Baluo-mikyene ya ba-Faridzyẽ! Be lili bampibi, mu kuulu be liikakahaba baara osomo mu Emfumu ki mayulu. Beme ka liikasomo omo o, ya be ka liikagwa baara ba badzyi osomo omo nzili o!»  ");
INSERT INTO tyx_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nyiĩ kundaa be Baluo-mikyene ya ba-Faridzyẽ! Be lili bampibi, mu kuulu be liikagwolo busini bwohono bubu bapfiili baba bakaha ya be liikasa nsamana yi nda mu kuulu baara bamono be. Me mu obo, Nzaami sa alamana be mu nkehe. ");
INSERT INTO tyx_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nyiĩ kundaa be Baluo-mikyene ya ba-Faridzyẽ, be lili bampibi! Mu kuulu be liikadzye mu bibini byehene bibi ŋa nsie ya mu mibu mu obagha mbwuru mumõ wu aakihi osomo mu emvuŋunu e be. Ya be bu libagha nde, be likirili nde mwana wu a mungele a mbaa, wu bvulu be mansa mwolo. ");
INSERT INTO tyx_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nyiĩ kundaa be, mimbiri mi binkpa-mihi mi miikalyele ti: «Munde wu aalaba mukihi mu nzo a Nzaami, ka li a ndagha o. Lo munde wu aalaba mukihi mu oore li nzo a Nzaami, nde faana okuhu mukihi a nde.» ");
INSERT INTO tyx_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Be lili biwulu ya binkpa-mihi! Emakye ebvulu mupfunu: Oore bwunu we nzo a Nzaami yi aakagwa lo bungili? ");
INSERT INTO tyx_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ya be liifirikalyele ti: «Munde wu aalaba mukihi mu ebini ki baakatsughu bikaba ka li a ndagha o. Lo munde wu aalaba mukihi mu ekaba ki baatwulu ŋa yulu a ebini ekye, nde faana okuhu mukihi a nde.» ");
INSERT INTO tyx_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Binkpa-mihi! Emakye ebvulu mupfunu: Ekaba bwunu we ebini ki baakatsughu bikaba eekasa ti ekaba ekala kii ngili? ");
INSERT INTO tyx_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Munde wu aalaba mukihi mu ebini ki baakatsughu bikaba aakalaba nde mu ebini e kye ya mu bilogho byehene bi bili ŋa yulu a kye. ");
INSERT INTO tyx_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ya munde wu aakalaba mukihi mu nzo a Nzaami aakalaba nde mu yo ya mu munde wu aakakala munsa yo. ");
INSERT INTO tyx_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Munde wu aalaba mukihi mu nkwumu a yulu, aakalaba mukihi mu likubu li Nzaami ya mu munde wu aakabwa nsini ŋa yulu a lo. ");
INSERT INTO tyx_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nyiĩ kundaa be baluo-mikyene ya ba-Faridzyẽ baara baba bampibi! Mu kuulu be liikagwa kaba lili kwumu lili mampihi-a-mpihi ya lili miswoho mimi nkwumu anete ya kumine, ya be liikameŋene bi bibvulu mupfunu mu mikyene: Bunsumu, mukolo wu a nyiĩ ya kana. Me mimye be likaakasa ya ogwene a omeŋene mi mike si. ");
INSERT INTO tyx_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mimbiri mi ókpi mihi, be liikakele mala ma be mu omaha bimpimpi, lo be liikamini nyama wu baakata syamo wu mutsyini! ");
INSERT INTO tyx_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nyiĩ kundaa be baluo-mikyene ya ba-Faridzyẽ, be lili bampibi! Mu kuulu be liikatsehebe mbihi a ebaha ya mbihi a ndoŋo, lo kunsa kara bilwulu mu bilogho bibi pfyibi ya mu nzala a mandagha ma mabi. ");
INSERT INTO tyx_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","We mu-Faridzyẽ wu enkpa-mihi! Matswama otsehebe ebaha mu kara, mu kuulu ebaha ekala si ki etsyeme ku mbala. ");
INSERT INTO tyx_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nyiĩ kundaa be baluo-mikyene ya ba-Faridzyẽ be lili bampibi! Mu kuulu be lili ti anga mampyeme ma bágyogho mpeeme. Ku mbala mo maakamoŋono ma mabwe. Lo kunsa kara mo malwulu mu miwehe mi ba bákpi ya nyara yi alagha. ");
INSERT INTO tyx_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bumõ si kundaa be, ku mbala be liikamoŋono ti baba bunsumu, lo kunsa kara be lili bampibi ya liilwulu mu bubi. ");
INSERT INTO tyx_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nyiĩ kundaa be baluo-mikyene ya ba-Faridzyẽ be lili bampibi! Be ba liikatwu mampyeme ma mibighili ya be liikabwehe mampyeme ma baba bunsumu, ");
INSERT INTO tyx_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ya be liikalyele ti: «Kala ti bihi áli liili mu matala mama bataara ba bihi, nkini bihi ka líkaakala mfwunu mõ ya bo mu otsala makili ma mibighili o.» ");
INSERT INTO tyx_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mu obo, be lili bampughulu ba beme ti be lili baana ba babo ba bádzwi mibighili. ");
INSERT INTO tyx_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lo be, limana esala ki óbaana bataara ba be! ");
INSERT INTO tyx_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Be lili bantaala, etswumu kii bampili! Bunu-abo be likughu ogweŋẽ masyeme ma mungele a mbaa? ");
INSERT INTO tyx_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Me mu obo, me ngweghe mibighili, bansughu ya baluo-mikyene kundaa be. Be sa lidzwa bana mu bo ya likomo bo ŋa kuruwa, be sa likaha babake nswa-nswa mu manzo mama lisamana ma ba-Dzwife, ya be sa libyi bo mu mabvulu ya mabvulu. ");
INSERT INTO tyx_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mu kuulu makili ma baba bunsumu mwohono ma mátsaŋama ŋa nsie, obaana makili ma Abele, wu a bunsumu tee mu Dzakari mwana a Baraki, wu lídzwi be ŋa kara li ebini ki baakatsughu bikaba ya ngwumu yi a ngili, mabwa ŋa yulu a be. ");
INSERT INTO tyx_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mu engaŋma me ndyele kundaa be ti: «Masyeme mwohono mamo sa mabwa ŋa yulu a eseene ki!» ");
INSERT INTO tyx_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Yerusaleme, Yerusaleme, we wu aakadzwa mibighili ya wu aakadzwa bantumu ba baakagweghe we mu mameẽ. Matala malagha me aakansagha obvughu baana ba we ti anga bu ookakogho nsuhu baana ba nde kunsa mapaba. Lo we ka dzyi o. ");
INSERT INTO tyx_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mono! Nzo a be sa yisyili mukaŋana. ");
INSERT INTO tyx_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mu kuulu, me ndyele kundaa be ti be akala ka liifirimono me o, tee mu matala ma liilyele be ti: Munde wu aagya mu nkwumu a Mfumu, li wu liseme!» ");
INSERT INTO tyx_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yiisu ápala mu Nzo a Nzaami, ya bu abaana ogye, binduono bi nde bíyasele kundaa nde mu osuo nde bu bátwu Nzo a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nde ábvuhulu kundaa bo ti: «Be lili mu okamono bilogho byehene bi? Mu engaŋma me ndyele be, ka akala osyili limeẽ ŋa yulu a limeẽ ŋa ebini ki o, byehene sa bitsaŋama.» ");
INSERT INTO tyx_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Bu abwi nsini ŋa Munguo wu a mi-Olibve, binduono bíyasele kundaa nde mu libee, ya bílyele nde ndiri: «Lyele bihi, munsa matala mandagha mamo akala maamoŋono, ya nsa elyimi eesuo ogya o we ya masini ma nsie.» ");
INSERT INTO tyx_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yiisu ábvuhulu kundaa bo ti: «Lisa mayele, mbwuru anyaã odzihibi be. ");
INSERT INTO tyx_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mu kuulu, balagha akala baagya mu nkwumu a me, ya sa balyele ti: “Me ngu Kriste!” Ya sa badzihibi baara balagha. ");
INSERT INTO tyx_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Be sa ligyughu bakabili mu mamvulu ya mu nsia a mamvulu mama ku la. Likala yeelee! Ka likala a nzalamweẽ o, mu kuulu mandagha mamo mafaana ogya, lo mamo nkini ka mali masini o. ");
INSERT INTO tyx_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mu kuulu baara ba nsie mõ sa batemene mu oyidzwana a baara baba nsie yinke, ya mukogho mumõ sa atemene mu oyidzwana a mukogho wu muke, sa okala a munzyala, ya nsie sa yinyiŋi mansa malagha. ");
INSERT INTO tyx_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Myehene mimye ngu ebaana ki misuo mii oburu. ");
INSERT INTO tyx_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mu matala mamõ sa batara be mu kuulu bamwehẽ be kimini, ya sa badzwa be, sa babele be kundaa bikaana byehene mu nkooro a nkwumu a me. ");
INSERT INTO tyx_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ya mu matala mamo, balagha akala baabwa, bo-a-bo sa batara bambaala ya sa babele bambaala. ");
INSERT INTO tyx_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mibighili milagha mimi mpya sa mipala ya sa midzihibi baara balagha. ");
INSERT INTO tyx_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mu nkooro a bubi ba buubvulu, dzyi li baara balagha sa liwolo. ");
INSERT INTO tyx_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lo munde wu asa mukama tee ku masini, sa abvwughu. ");
INSERT INTO tyx_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sa batsala Nsia yi Mbwe yi a Emfumu yi mu nsie yohono, mu kuulu yo yisuo bumpughulu kundaa bikaana byehene. Me oŋo akala masini maagya.» ");
INSERT INTO tyx_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Ŋa akala liimono be mu ebini kii ngili Ngughu a bubi ba buukabyihi, bu áli ólyele mubighili Danyele, nyaã wu li mu otala abaghala. ");
INSERT INTO tyx_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mu matala mamo, babo ba baakala mu Yude, nyaã babara ku yulu a minguo. ");
INSERT INTO tyx_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Munde wu aakala ku yulu a see li nzo lili eyala, anyaã osughuru mu otolo bilogho bi bili munsa nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Munde wu aakala ku manseghe, anyaã obvughuru ku mbihi mu oyigwolo enkuru ki ela kii kobo. ");
INSERT INTO tyx_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nyiĩ kundaa bakaha ba baakala a mayimi ya ba baakala mu otsyaha baana mu bitsughu bibye! ");
INSERT INTO tyx_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lisamana Nzaami mu kuulu be linyaã obara mu ndo yi a mpie yi alagha, ya mu etsughu kii sabate. ");
INSERT INTO tyx_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mu kuulu oŋo sa okala a mpara yi alagha, yiili nkini ka yimaabwa o, obaana ku ebaana e nsie tee mu matala ma, ya kimini lii obo ka lifirikala o. ");
INSERT INTO tyx_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ya kala ti mutala a bitsughu bibye ka bási nde wu a sala o, nkini mbwuru si mumõ ka ákaabvwughu o. Lo mu nkooro a ba ósuolo Nzaami, bitsughu bibye sa bikala bi bisala. ");
INSERT INTO tyx_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Me mu obo, kala ti mbwuru lyele kundaa be ti: “Kriste li ŋa!” Bwunu we: “Nde li ŋanii!” Ka lisa nde kana o. ");
INSERT INTO tyx_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mu kuulu, bakriste baba mpya ya mibighili mimi mpya sa batemene. Bo sa basa bilyimi bi binene ya mandagha mama okiŋimi mu eteese kii odzihibi, ngu oli ba básuolo kala ti okughu okala. ");
INSERT INTO tyx_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Me aangyehe be! ");
INSERT INTO tyx_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Lo kala balyele kundaa be ti: “Limono, nde li ku syehe”, ka ligye oko o. Bwunu we balyele ti: “Limono nde aasweme ŋa”, ka lisa nde kana o. ");
INSERT INTO tyx_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mu kuulu, bwunu a bu ookasehene musehene a nzele ku ookapala tala tee ku ookadzyama tala, bwunu obo si ogya o Mwana a mbwuru akala ookala. ");
INSERT INTO tyx_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ŋa ebini ki ookala ebyimi, me oŋo bango-mbimi akala baabvuŋunu.» ");
INSERT INTO tyx_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Ŋaana oŋo, ŋa mbihi a bitsughu bibye bibi kimini lili lagha, tala sa likala mpyibi, mweele wu a ngoono ka afirigwa otsyeme o, baŋomaŋomo sa babwa ŋa nsie, ya lileene lili mayulu sa linyiŋi. ");
INSERT INTO tyx_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Oŋo elyimi e Mwana a mbwuru sa epala mu yulu, ya baara baba bitswumu byehene bi bili ŋa nsie sa basyama mu bilili, ya sa bamono Mwana a mbwuru bu aagya mu bidzi bi mayulu mu lileene ya mu nsia yi nene. ");
INSERT INTO tyx_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ya nde sa agweghe bangye-yulu ba nde ya mvulu-a-mvulu yi nene, ya bo sa babvughu baba ndaa nde ba ásuolo mu manto ma nsie mansa mana, tee mu nto ya nto yi a mayulu.» ");
INSERT INTO tyx_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Libaghala nkumu yi a mufinge: Manto ma mampala ma nde kala ayi mineŋe ya kala ti matsyiri maafulu, lo be lisoolo ti dzwa liibehene. ");
INSERT INTO tyx_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bumõ si, ŋa akala liimono be mandagha mwohono mamo, lo be lisoolo ti Mwana a mbwuru ayi aayabehene, nde ayi be-bele. ");
INSERT INTO tyx_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mu ngaŋma me ndyele kundaa be ti, eseene ki ka eluru o, nsomo mandagha mwohono mamo maakughu. ");
INSERT INTO tyx_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yulu ya nsie sa biluru, lo mandagha ma me ka maluru o.» ");
INSERT INTO tyx_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Mu mi mitala etsughu ekye ya matala mamo, mbwuru si mumõ ka soolo bye o, ngu okala bangye-yulu ba mayulu, ngu okala Mwana, yini a Taara nde ngasighi. ");
INSERT INTO tyx_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bwunu a bu óli mu bitsughu bi Nowe, bwunu obo si ogya o Mwana a mbwuru ookala. ");
INSERT INTO tyx_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bwunu a bu óli baara babo mu bitsughu bi bítswama ndwuru a madza yi nene, bo bákadza ya bákaŋma, bo bákakie ya bákakwehe, tee mu etsughu ki ósomo Nowe mu bwara ba bunene. ");
INSERT INTO tyx_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bo ka bákasoolo o, tee ŋa ógyi ndwuru a madza yi nene yi áabiri bo bwohono. Me bwunu obo si ookala ogya o Mwana a mbwuru. ");
INSERT INTO tyx_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mu obo, mu baara buolo ba baakala mu nseghe, sa bagwolo mumõ, ya sa basihi wu muke. ");
INSERT INTO tyx_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mu bakaha buolo ba bali mu okasighi mburu ŋa yulu a limeẽ li baakasighi mburu, sa bagwolo mumõ, ya sa basihi wu muke. ");
INSERT INTO tyx_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mu obo, be likahala mihi, mu kuulu be ka lisoolo o nsa etsughu Mfumu a be akala aagya. ");
INSERT INTO tyx_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Be lisoolo ti kala nga-a-nzo áli gyahaba matala mama mpyibi ma oogya muturu, nkini nde ákaakahala mihi, ya ka ákaatala o ti babulu nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Me mu obo, behe si, likala yeelee, mu kuulu Mwana a mbwuru sa agya mu matala maala be ka likala a etsimi o.» ");
INSERT INTO tyx_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Nande li musala wu bunsumu ya wu li a mayele, wuulu mfumu aagwi nde litumu ŋa yulu a baara ba nzo a nde mu ogwa bo bi-odza mu matala ma mafaana? ");
INSERT INTO tyx_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Esee kundaa musala munde, wuulu mfumu a nde bu agyi yabagha nde ŋa yulu a esala ekye. ");
INSERT INTO tyx_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mu ngaŋma, me ndyele kundaa be ti, nde sa agwa nde emfumu ŋa yulu a bilogho bi nde byehene. ");
INSERT INTO tyx_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lo, kala ti musala li wu mubi ya etsimi kunsa mukolo a nde ti: “Mfumu a me ka ali mu obaagya o”, ");
INSERT INTO tyx_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ya bwi okaha banganda ba nde baba esala, bwi odza ya oŋma ya binkolo-mala, ");
INSERT INTO tyx_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","mfumu a musala munde sa agya mu etsughu kiili nde ka ali mu okakebe nde o, ya mu matala maala nde ka agyahaba o. ");
INSERT INTO tyx_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mfumu sa abyi nde ya musala munde sa ebagha masyeme emõ ya bampibi, oko ku ookala bilili ya odza myini.» ");
INSERT INTO tyx_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Emfumu ki mayulu efaana a batughu baba nkyini kwumu, baala bu bagwolo miindi mi bo, bápala mu oyibwana mulumu. ");
INSERT INTO tyx_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bataana mu bo báli biwulu, ya bataana babake báli ya mayele. ");
INSERT INTO tyx_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Batughu baba biwulu, bu bagwolo miindi, ka bágwolo maala o. ");
INSERT INTO tyx_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Lo batughu baba mayele bágwolo miindi mi bo ya maala mu mana a mambwara. ");
INSERT INTO tyx_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mulumu bu ágwene obaagya, bo bwohono bátuo ensama ya bágyoŋomo tolo. ");
INSERT INTO tyx_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mu kara-a-kara li mpyibi, engubu ébwi: “Mulumu ndeghe! Lipala liyibwana a nde.” ");
INSERT INTO tyx_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mu obo batughu bwohono básighili ya bábwi ogyighili miindi mi bo. ");
INSERT INTO tyx_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Batughu baba biwulu bályele kundaa batughu baba mayele ti: “Ligwa bihi mana ndaama a maala ma be, mu kuulu miindi mi bihi mili mu okagye ku odzimi.” ");
INSERT INTO tyx_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lo babo baba mayele bábvuhulu kundaa bo ti: “Pele! Mo ka makughu mu bihi ya mu be o. Ligye kundaa minta-nkaala ya liswumu maala mama ndaa beme.” ");
INSERT INTO tyx_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mu matala ma bágyene bo ku oyiswumu maala, mulumu áyato, ya batughu ba báli yeelee básomo munsa nzo a kyiri kii mabala, ya bákuru muŋma a nzo. ");
INSERT INTO tyx_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ŋa mbihi oŋo, batughu bataana babake bágyi, ya bákalyele ti: “Mfumu, mfumu, dzubulu bihi nzo!” ");
INSERT INTO tyx_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lo nde ábvuhulu ti: “Mu engaŋma me ndyele kundaa be ti, me ka nsoolo be o.”» ");
INSERT INTO tyx_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«Me mu obo, likahala mihi, mu kuulu be ka lisoolo o, ngu okala etsughu, ngu okala matala.» ");
INSERT INTO tyx_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Sa okala ti anga mbwuru wu li mu okagye ku midzye, nde áti basala ba nde mbili ya ágwi bo busini bu nde. ");
INSERT INTO tyx_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kundaa mumõ nde ágwi batalanta bataana, kundaa wunu nde ágwi buolo, kundaa wu muke nde ágwi mumõ, bwunu a bu oli mpini a mbwuru-mbwuru, ya nde ágyene midzye. ");
INSERT INTO tyx_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Musala wu áabagha batalanta bataana áyisalala mu bo ya ábagha bataana bakimi ŋa yulu. ");
INSERT INTO tyx_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bwunu obo si, wu bágwi batalanta buolo ábagha batalanta buolo bakimi. ");
INSERT INTO tyx_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lo munde wu bágwi talanta mumõ, áyitsimi dzunu mu nsie ya ásweghe nzi a mfumu a nde omo. ");
INSERT INTO tyx_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Matala malagha bu maluru, mfumu a basala áyabvughuru. Ya nde áfwulu bo bunu-a-bo básalala nzi a nde. ");
INSERT INTO tyx_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Munde wu bágwi batalanta bataana áyasele ya ásuo batalanta bataana bakimi ya ályele ndiri: “Mfumu, we áli aagwi me batalanta bataana, mono batalanta bataana bakimi ba aafirimbagha me.” ");
INSERT INTO tyx_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mfumu a nde ályele kundaa nde ndiri: “Bubwe! We li musala wu mubwe ya wu a bunsumu. We aasuo bunsumu mu bi bisala, me sa ngwa we litumu mu bi bibvulu mupfunu. Gya, ya kala mu esee ya mfumu a we.” ");
INSERT INTO tyx_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ŋa mbihi, munde wu bágwi batalanta buolo áyasele ya ályele ti: “Mfumu, we áli aagwi me batalanta buolo, mono batalanta buolo bakimi ba aambagha me.” ");
INSERT INTO tyx_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mfumu a nde ályele kundaa nde ndiri: “Bubwe! We li musala wu mubwe ya wu a bunsumu. We aasuo bunsumu bu we mu bi bisala, me sa ngwa we litumu mu bi bibvulu mupfunu. Gya, ya kala mu esee ya mfumu a we.” ");
INSERT INTO tyx_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ŋa masini, wu bágwi talanta mumõ bu ayasele si, nde ályele ti: “Mfumu, me nsoolo ti we li mbwuru nga-a-mukolo mpini, we aakatolo mburu ŋa ebini kiili ka oli we aakunu o, we aakakwu mburu ŋa ebini kiili ka we aanyahala o. ");
INSERT INTO tyx_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mu nzalamweẽ, me áayindzyighi talanta a we ku nsini a nsie. Gwolo talanta a we!” ");
INSERT INTO tyx_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Lo mfumu a nde ábvuhulu kundaa nde ti: “We li musala wu mubi ya mubolo! We gyighili osoolo ti me aakantolo mburu ŋa ebini kiili ka oli me aankunu o, ya me aakankwu mburu ŋa ebini kiili ka me aanyahala o. ");
INSERT INTO tyx_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nkini áli we aatwulu nzi a me ku banke, mu kuulu ŋa aayamvughuru me, me ngwolo yo ya ndaana ŋa yulu. ");
INSERT INTO tyx_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ligwolo nde talanta wu ali a nde ya ligwa nde kundaa munde wu li a batalanta kwumu. ");
INSERT INTO tyx_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mu kuulu, kundaa munde wu li a elogho, sa bafirigwa nde bi bibvulu, ya nde sa akala a bye bi bilagha. Lo, kundaa munde wuulu ka ali a elogho o, sa bamaha nde si okala enda-ndaama ki ali a nde. ");
INSERT INTO tyx_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Musala wu gwene a mupfunu wu, litsili nde kunsa mpyibi yi a ku mbala, oko ku ookala bilili ya odza myini.”» ");
INSERT INTO tyx_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Ŋa akala oogya Mwana a mbwuru munsa nsia a nde, nzili mõ ya bangye-yulu bwohono, nde sa abwa nsini ŋa likubu li nde lili nsia. ");
INSERT INTO tyx_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bikaana byehene sa bibvuŋunu ŋa nkulu a nde, ya nde sa akabala baara mu makaba mwolo, ti bu ookakabala munkaala-bibuolo bindoomo ya bantaba. ");
INSERT INTO tyx_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nde sa atwulu bindoomo ku ngo-kwogho e nde ya bantaba ku engbambogho e nde. ");
INSERT INTO tyx_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Oŋo mukogho sa alyele kundaa ba baakala ku ngo-kwogho e nde ti: “Ligya, be ba óseme Taara a me, libyala pfa li Emfumu ki bágyighili mu be obaana ku ebaana e nsie. ");
INSERT INTO tyx_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mu engaŋma me aandi a nzala, ya be liigwi me bi-odza, me aandi a nyoro, ya be liigwi me bi-oŋma, me aandi munzyi, ya be liibwana a me. ");
INSERT INTO tyx_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Me aandi mpene, ya be liigwi me binkuru, me aandi mubyele ya be liiyatala me, me aandi mu boloko, ya be liiyatala me.” ");
INSERT INTO tyx_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mu obo, baara baba bunsumu sa babvuhulu kundaa nde ti: “Mfumu, bu nki matala bihi ali liimono we ya nzala ya bihi liigwi we bi-odza, we ya nyoro, ya bihi liigwi we madza? ");
INSERT INTO tyx_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Bu nki matala bihi ali liimono we munzyi ya bihi liibwana a we, mpene ya bihi liigwi we binkuru? ");
INSERT INTO tyx_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nki matala bihi ali liimono we mubyele bwunu we mu boloko, ya bihi liigyi kundaa we?”» ");
INSERT INTO tyx_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ya mukogho sa abvuhulu kundaa bo ti: «Mu engaŋma, me ndyele kundaa be ti: Nswe ŋa liikasa be obo kundaa mumõ mu ba babvulu osala ba, ba bali bambwee ya banaana ba me, me kundaa me be liikasa obo!» ");
INSERT INTO tyx_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Ŋa nseele, mfumu sa alyele kundaa ba bali ku engbambogho e nde ti: “Be ba bágwi epwolo, ligye la ya me, ku mbaa yi aagwene okadzimi yi bágyighili mu nkooro a dyabulu ya bangye-yulu ba nde. ");
INSERT INTO tyx_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mu kuulu me aandi ya nzala ya be ka liigwi me bi-odza o, me aandi ya nyoro ya be ka liigwi me madza o. ");
INSERT INTO tyx_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Me aandi munzyi ya be ka liibwana a me o, me aandi mpene ya be ka liigwi me binkuru o, me aandi mubyele ya mu boloko, ya be ka liiyamono me o.” ");
INSERT INTO tyx_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mu obo, boho si sa babvuhulu kundaa nde ti: “Mfumu, nki matala bihi áli liimono we ya nzala bwunu we ya nyoro, munzyi bwunu we mpene, mubyele bwunu we mu boloko, ya bihi liikwono oyabaha we?”» ");
INSERT INTO tyx_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nde sa abvuhulu kundaa bo ti: «Mu engaŋma, me ndyele kundaa be ti: “Nswe ŋa liikwono osa be obo kundaa mumõ mu ba babvulu osala ba, me kundaa mehe si be liikwono osa obo!” ");
INSERT INTO tyx_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ya, bo sa bagye ku masyeme mama mibvu ya mibvu, ya baara baba bunsumu ku laama lili mibvu ya mibvu.» ");
INSERT INTO tyx_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yiisu bu amana ogwa maluo mwohono mamo, nde ályele kundaa binduono bi nde ti: ");
INSERT INTO tyx_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Be lisoolo ti, bitsughu byele bisyili mu oto kyiri kii Paake, ya Mwana a mbwuru sa bagwa nde ŋa myaã mi baara mu kuulu bakomo nde ŋa kuruwa.» ");
INSERT INTO tyx_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mu obo, bakwuru ba bangaa ba nzaami ya bakulu baba ekaana ki ba-Dzwife bábvuŋunu ku mbala nzo a mfumu a bangaa ba nzaami wu a nkwumu a Kayife. ");
INSERT INTO tyx_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bo bákuru mfwunu mu osyimi Yiisu mu mayele mu kuulu badzwa nde. ");
INSERT INTO tyx_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lo bo bákalyele ti: «Ka ŋa kara li kyiri o, mu kuulu mpaatsala yinyaã obwa ŋa nsa baara.» ");
INSERT INTO tyx_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ya Yiisu bu áli ku Betani, ku nzo a Simõ nga-a-bwala, ");
INSERT INTO tyx_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mukaha mumõ áyasele kundaa nde ya mbwara yi a mu alabatere yi áalwulu mu mananaase mama ntala. Nde ágyiri mo ŋa yulu a mutswi a Yiisu ŋaala bo bábwi nsini ŋa tabele. ");
INSERT INTO tyx_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Binduono bu bimono obo, ka bímono esee o ya bílyele ti: «Mu emakye bapfihili mananaase ma? ");
INSERT INTO tyx_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mu kuulu, ali bakughu otyeghe mo mu ntala yi alagha, ya ogwa nzi oyo kundaa bawele!» ");
INSERT INTO tyx_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yiisu bu asoolo ndagha oyo, nde ályele kundaa bo ti: «Mu emakye be lili mu omweẽ mukaha wu mpara? Nde aagyighili ndagha yimbwe mu me. ");
INSERT INTO tyx_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mu kuulu bawele, be sa likala ya bo mu matala mwohono. Lo me ka ankala ya be mu matala mwohono o. ");
INSERT INTO tyx_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nde bu agyiri mananaase ma mu nyuru a me, nde aasi me mansagha ma baadzyighi me. ");
INSERT INTO tyx_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mu engaŋma me ndyele kundaa be ti: Nswe ebini ki akala baatsala Nsia yi Mbwe mu nsie nsyini, sa babili si mu yo, bu balibili nde mweẽ mu ndagha yi aagyighili nde.» ");
INSERT INTO tyx_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mu obo, mumõ mu kwumu ya buolo (12) wu a nkwumu Yuda Isikaryote, ágyene kundaa bakwuru ba bangaa ba nzaami, ");
INSERT INTO tyx_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ya ályele kundaa bo ti: «Be emakye liigwa me mu kuulu me ntyeghe nde kundaa be?» Bo bágwi nde makwumu matere (30) ma mipara mimi bisyeẽ. ");
INSERT INTO tyx_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Obaana oŋo, nde ábwi osagha matala ma mabwe mu kuulu nde atyeghe bo Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mu etsughu kii nsomo kii mampa ma magwene a pfini, binduono bíyalyele kundaa Yiisu ti: «Kunu-ako we dzyi ti bihi linaã we bi-odza bibi kyiri kii Paake?» ");
INSERT INTO tyx_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nde ályele ti: «Ligye ku bvulu kundaa mfu-nga-empele ya lilyele nde ti: “Muluo bu alyele ti: Matala ma me maabehene, ku nzo a we me aandza kyiri kii Paake ya binduono bi me.”» ");
INSERT INTO tyx_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Binduono bísi bwunu a bu ótumu bo Yiisu ya bábwehẽ kyiri kii Paake. ");
INSERT INTO tyx_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nkonkolo bu yito, nde ábwi nsini ŋa tabele ya binduono kwumu ya byele (12). ");
INSERT INTO tyx_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mu matala ma bákadza bo, Yiisu ályele ti: «Mu engaŋma me ndyele be, mumõ ŋa kara li be sa atyeghe me.» ");
INSERT INTO tyx_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bo bányoõ ku olagha, bábaana olyele kundaa nde mumõ-mumõ ti: «Mfumu, me?» ");
INSERT INTO tyx_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nde ábvuhulu ti: «Munde wu aalo kwogho mu ndoõ sa limõ ya me, me nde aatyeghe me. ");
INSERT INTO tyx_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana a mbwuru li mu ogye bwunu a bu básono mu nde, lo nyiĩ kundaa munde wu li nzili yi baatyeghe Mwana a mbwuru! Ali bubwe banyaã oburu mbwuru munde!» ");
INSERT INTO tyx_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda wu aatyeghe nde ályele kundaa nde ti: «Muluo, me?» Yiisu ábvuhulu kundaa nde ti: «Weme lyele yo!» ");
INSERT INTO tyx_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mu matala ma bákadza bo, Yiisu ágwolo limpa, ya bu aseme lo, nde átsyiri lo, nde ágwi lo kundaa binduono bi nde, ya nde ályele ti: «Ligwolo, lidza, yi me nyuru a me.» ");
INSERT INTO tyx_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bu agwolo ebaha ya bu abvurulu matuono, ágwi bo kye ya ályele ti: «Liŋma kye be bwohono, ");
INSERT INTO tyx_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","mu kuulu ma me makili ma me, makili mama ogwihini ma maatsaŋama mu nkooro a baara ba balagha, mu kolokolo a masumu. ");
INSERT INTO tyx_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Me ndyele kundaa be ti: Me ka amfiriŋma mala ma bviini ma o tee mu etsughu ki akala aamfiriŋma me mo ma manyaghara emõ ya be mu Emfumu e Taara a me.» ");
INSERT INTO tyx_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bu bamana ogyimi bikwumu bibi masyighi, bo bápala mu ogye ku Munguo wu a mi-Olibve. ");
INSERT INTO tyx_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mu obo Yiisu ályele kundaa bo ti: «Mu mpyibi yiyi, be bwohono sa libwa mu nkooro a me. Mu kuulu básono ti: Me sa nkaha munkaala-bibuolo, ya bindoomo bibi mukaã a bibuolo sa bitsaŋama ");
INSERT INTO tyx_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lo, ŋa akala aansighili me mu lipfu, me sa nswama ku Ngalile.» ");
INSERT INTO tyx_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piere ábvuhulu kundaa nde ti: «Ngu okala ti bwohono sa babwa mu nkooro a we, si okala ka bunu, me ka ambwa o.» ");
INSERT INTO tyx_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yiisu ályele kundaa nde ti: «Mu engaŋma, me ndyele kundaa we, mu mpyibi yi, nsomo mulumu a nsuhu akuolo, we sa tunu me mansa matere.» ");
INSERT INTO tyx_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piere ályele kundaa nde ti: «Ngu okala ti me mfaana okpa emõ ya we, si okala ka bunu, me ka ntunu we o.» Ya binduono byehene bílyele bwunu obo si. ");
INSERT INTO tyx_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yiisu bu ayato ya bo ŋa ebini kii nkwumu Ngetesemane, nde ályele kundaa binduono ti: «Libwa mansini ŋa, mu matala ma aayinsamana me Nzaami ŋanii.» ");
INSERT INTO tyx_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Bu abiri Piere ya baana ba Nzebede bansa buolo, nde ábaana omono nyiĩ ya mukolo maã-maã. ");
INSERT INTO tyx_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mu obo, nde ályele kundaa bo ti: «Muwumunu a me ayi ya nyiĩ tee mu eteese kii lipfu. Likala ŋa ya likahala mihi ya me.» ");
INSERT INTO tyx_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nde bu agyene mana etiiri ki ela, ábwi edzili ŋa nsie, ábuono Nzaami ya ályele ti: «Taara a me, kala ali bukughu okala, nyaã ebaha ki eluru la ya me! Lo, ka bu ndzyi me o, lo bu dzyi we!» ");
INSERT INTO tyx_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nde áyabvughuru kundaa binduono ya nde ámono bye bigyoŋomo ensama. Nde ályele kundaa Piere ti: «Bu me buulu be ka liibagha mpini yi okeele ya me mu tala limõ o!» ");
INSERT INTO tyx_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","«Likahala mihi ya lisamana mu kuulu be linyaã obwa mu bigyeele. Mufulu li a mpini, lo nyuru yikolo.» ");
INSERT INTO tyx_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nde áfirigye la mu sa lili ywolo, ásamana ya ályele ti: «Taara a me, kala ti ebaha ki ekughu oluru kuulu me kye oŋma we, nyaã waa li we likala!» ");
INSERT INTO tyx_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ŋa mbihi, nde áfiriyabvughuru ya áyabagha bo mu ensama, mu kuulu mihi mi bo áli míleme. ");
INSERT INTO tyx_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nde bu asihi bo, áfirigye la ya bo ya ásamana Nzaami mu sa lili tere. Nde áfirilyele mandagha maana mamõ. ");
INSERT INTO tyx_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mu obo nde ábvughuru kundaa binduono ya lyele kundaa bo ti: «Mu matala ma, ligyoŋomo ya ligwumu o be! Mono, tala liibehene, ya Mwana a mbwuru sa bagwa nde ŋa myaã mi banga-a-masumu. ");
INSERT INTO tyx_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Litemene! Liyatswe! Limono, munde wu aatyeghe me maayabehene!» ");
INSERT INTO tyx_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nde áli nkini mu okabili, mono, Yuda, mumõ mu binduono kwumu ya byele (12), áyato ya mpwumu a baara yi nene yi áali a mapee ya mankwogho, ba ógweghe bakwuru ba bangaa ba nzaami ya bakulu baba ekaana ki ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ya munde wu aakatyeghe nde ágwi bo elyimi, ályele ti: «Munde wu aanyuburu me, me munde, lisyimi nde!» ");
INSERT INTO tyx_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ŋaana oŋo, nde áyasele kundaa Yiisu ya ályele ti: «Muluo, mboro a we!» Ya nde ányuburu nde. ");
INSERT INTO tyx_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yiisu ályele kundaa nde ti: «Ndughu a me, esala ki aayasa we, sa kye!» Bu bayasele, bábwirili Yiisu ya básyimi nde. ");
INSERT INTO tyx_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ya mono, mumõ mu ba bali ya Yiisu, bu apaha lipee li nde, átini musala a mfumu a bangaa ba nzaami, átsyiri nde tswi. ");
INSERT INTO tyx_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mu obo, Yiisu ályele kundaa nde ti: «Bvurulu lipee li we ŋa likukuru li lo, mu kuulu babo ba baakagwolo lipee, sa bakpa mu lipee. ");
INSERT INTO tyx_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","We bunu tsimi, ti me ka nkughu obuono Taara a me o, mu kuulu nde agwa me ŋa-ŋa mikaã mi bangye-yulu kwumu ya myele (12)? ");
INSERT INTO tyx_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lo bunu-abo Bisono bi biilyele ti ofaana okala obo biikeele?» ");
INSERT INTO tyx_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ŋa nseele, Yiisu ályele kundaa mampwumu ti: «Be liipala ya mapee ya mangbala mu osyimi me ti anga ntwumu! Nswe etsughu me aakambwa nsini munsa nzo a Nzaami mu okaluo, lo be ka liisyimi me o. ");
INSERT INTO tyx_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lo myehene mimye miimoŋono mu kuulu mi básono ya mi ólyele mibighili mikeele.» Oŋo binduono byehene bíbulusihi nde ya bíbara. ");
INSERT INTO tyx_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ba básyimi Yiisu bábiri nde kundaa Kayife mfumu a bangaa ba nzaami, oko ku óbvuŋunu baluo-mikyene ya bakulu ba ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piere ákanama nde la-la tee kunsa mbala a nzo a Mukwuru a bangaa ba nzaami. Bu asomo kunsa kara, ábwi nsini ya bankyele ba Kayife mu omono bunu ndagha yi yiisughu. ");
INSERT INTO tyx_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bakwuru ba bangaa ba nzaami ya ekwuru ki ba-Dzwife kyehene bákasagha bumpughulu bubu mpya mu Yiisu mu kuulu batsyiri nde mukakana wu lipfu. ");
INSERT INTO tyx_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lo bo ka bábagha o, ngu okala ti bampughulu baba mpya balagha báyamoŋono. Ŋa masini, babaghala buolo bágyi ");
INSERT INTO tyx_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ya bályele ti: «Mbwuru wu aakalyele ti: “Me nkughu otsala nzo a Nzaami ya ofiritwu yo mu bitsughu bitere.”» ");
INSERT INTO tyx_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mukwuru a bangaa ba nzaami bu atemene, ályele kundaa nde ti: «We ka li a ndagha yi aabvuhulu mu bumpughulu bu baara ba mu we o?» ");
INSERT INTO tyx_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lo Yiisu ka átsughu ndagha o. Mukwuru a bangaa ba nzaami ályele kundaa nde ti: «Mu nkwumu a Nzaami wu a mweẽ, me nduomo we mu olyele bihi, kala ti we me Kriste, Mwana a Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yiisu ábvuhulu kundaa nde ti: «Weme lyele yo. Lo me ndyele kundaa be ti, obaana matala ma, be sa limono Mwana a mbwuru ábwi nsini ŋa ngo-kwogho ki Nga-a-lileene ya li mu okagya mu bidzi mu mayulu.» ");
INSERT INTO tyx_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mu obo mfumu a bangaa ba nzaami ákaghala binkuru bi ndeme ya ályele ti: «Nde aatsaala Nzaami. Mu emakye bihi liifirikala a nzala a bampughulu? Be liigyughu bu aatsaala nde Nzaami. ");
INSERT INTO tyx_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Be bunu litsimi?» Bo bábvuhulu ti: «Nde faana okpa!» ");
INSERT INTO tyx_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Oŋo bo bábwi otswulu nde manteẽ ku edzili ya okaha nde minkono, bana bákaha nde mampala, ");
INSERT INTO tyx_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ya bákalyele ti: «Kriste, bighili, nande mu bihi aakaha we?» ");
INSERT INTO tyx_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piere áli ábwi nsini ku mbala a nzo. Musala mumõ wu mukaha bu ayasele kundaa nde, ályele ti: «Wehe si aakakala ya Yiisu wu a ku Ngalile!» ");
INSERT INTO tyx_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lo nde átunu ŋa nkulu a baara bwohono, ya ályele ti: «Me ka nsoolo ndagha yi dzyi we olyele o.» ");
INSERT INTO tyx_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ŋa nseele, Piere bu ákagye ku bele a edzughubu ki enene ki ekagha, musala mukimi wu mukaha ámono nde ya ályele kundaa ba báli oŋo ti: «Mbwuru wu aakakala ya Yiisu musi Nadzarete.» ");
INSERT INTO tyx_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nde áfiritunu ya ályele ti: «Me ndaba mukihi, me ka nsoolo mbwuru wu o!» ");
INSERT INTO tyx_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ŋa mbihi a edzighi ebi, ba báli oŋo báyasele ya bályele kundaa Piere ti: «Mu engaŋma, wehe si li wu a ndaa bo! Mu kuulu mbiili a we yi li mu ofwunu we.» ");
INSERT INTO tyx_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mu obo nde álaba mukihi mu okabiili mpwoho ti: «Me ka nsoolo mbwuru wu o!» Ya ŋaana oŋo mulumu a nsuhu ákuolo. ");
INSERT INTO tyx_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ya Piere álibili mweẽ mu ndagha yi ólyele nde Yiisu: «Nsomo mulumu a nsuhu akuolo, we sa tunu me mansa matere.» Ya nde bu apala ku mbala, ábuulu mukaba a elili kii minyoõ. ");
INSERT INTO tyx_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bwihi bu buki, bakwuru ba bangaa ba nzaami bwohono ya bakulu ba ekaana ki ba-Dzwife bákuru mfwunu yi otsyiri Yiisu mukakana wu lipfu. ");
INSERT INTO tyx_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ya bu bakuru nde misyi, bábiri nde ya bágwi nde ŋa myaã mi Pilate, mfumu a etsulu e nsie. ");
INSERT INTO tyx_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yuda wu aatyeghe Yiisu, bu amono ti baatsyiri nde mukakana wu lipfu, ásobo bitsimi, ya áyibvurulu makwumu matere ma mipara (30) mimi bisyeẽ kundaa bakwuru ba bangaa ba nzaami ya bakulu ba ekaana ki ba-Dzwife, ");
INSERT INTO tyx_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ya ályele kundaa bo ti: «Me aansi masumu bu aantyeghe makili mama wu gwene osoolo ndagha!» Lo bo bályele ti: «Ka mitala bihi o! Oyo ndagha a we!» ");
INSERT INTO tyx_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nde ábulutsili mipara mimi bisyeẽ mu nzo a Nzaami, ápala ya áyilele swe. ");
INSERT INTO tyx_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bakwuru ba bangaa ba nzaami bágwolo mipara mimi bisyeẽ mimye ya bályele ti: «Ka oli a muswa mu olo mye mu baakabunu nzi a nzo a Nzaami o, mu kuulu mye mili mutala a makili.» ");
INSERT INTO tyx_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bo bákuru mfwunu, báswumu nseghe a wu aakagyighili bilogho bi bámyene mu mubweẽ mu mipara mimye mu kuulu yikala mampyeme ma banzyi. ");
INSERT INTO tyx_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Me mu obo tee mu matala ma, baakata nseghe oyo «nseghe a makili». ");
INSERT INTO tyx_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Obo me bu ókeele mi áli ólyele mubighili Dzeremi: «Bo baagwolo makwumu matere (30) ma mipara mimi bisyeẽ, munde me mutala wu ólyele baana ba Isarayele, wu bákehe mu mbwuru munde, ");
INSERT INTO tyx_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ya bo baagwi mipara mimye mu nseghe a wu wu aakagyighili bilogho bi bámyene mu mubweẽ, bwunu a bu ógwi me Mfumu litumu.» ");
INSERT INTO tyx_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bábiri Yiisu ŋa nkulu a Mfumu a etsulu e nsie. Nde áfwulu nde ti: «Bunu, we me mukogho a ba-Dzwife?» Yiisu ályele ti: «Weme lyele yo.» ");
INSERT INTO tyx_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lo mu matala ma ókafwulu nde bakwuru ba bangaa ba nzaami ya bakulu ba ekaana ki ba-Dzwife, nde ka ábvuhulu ndagha o. ");
INSERT INTO tyx_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mu obo, Pilate ályele kundaa nde ti: «Bunu, we ka li mu okagyughu mandagha mwohono ma bali mu okakwighi we o?» ");
INSERT INTO tyx_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lo Yiisu ka ábvuhulu nde mvuru o, ya mfumu a etsulu e nsie ákiŋimi ku olagha. ");
INSERT INTO tyx_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mu nswe kyiri kii Paake, mfumu a etsulu e nsie ekye áli a epfu kii okapaha mbwuru a boloko mumõ, wu odzyi mpwumu a baara. ");
INSERT INTO tyx_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mu matala mamo óli a mbwuru a boloko mumõ wu a nsia, nkwumu a nde Yiisu Barabase. ");
INSERT INTO tyx_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilate áfwulu kundaa mpwumu yi áabvuŋunu ti: «Nande be lidzyi ti me nyaã, Yiisu Barabase, bwunu we Yiisu wu baakata Kriste?» ");
INSERT INTO tyx_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mu kuulu, nde ásoolo ti bo baatyeghe Yiisu mu nkooro a ebaa e bo. ");
INSERT INTO tyx_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mu matala ma ábwi nde nsini ŋa epehe kii muyala, mukala a Pilate ágweghe mbwuru alyele kundaa nde ti: «Ka somo mu ndagha a mbwuru wu bunsumu wu o! Mu kuulu lolo mu nzolo me aamono mpara alagha mu nkooro a nde.» ");
INSERT INTO tyx_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bakwuru ba bangaa ba nzaami ya bakulu ba ekaana ki ba-Dzwife bápeene a mampwumu ma baara mu kuulu mo maluomo Barabase ya badzwa Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Bu afiribili, mfumu a etsulu e nsie áfwulu kundaa bo ti: «Mu bo buolo, be na lidzyi me nyaã?» Bo bábvuhulu ti: «Barabase!» ");
INSERT INTO tyx_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate áfwulu kundaa bo ti: «Emakye me aansa mu Yiisu, wu baakata ti Kriste?» Bo bwohono bábvuhulu ti: «Bakomo nde ŋa kuruwa!» ");
INSERT INTO tyx_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nde áfirifwulu bo ti: «Nde nsa bubi aagyighili?» Lo bo bákakehe bingubu mu mpini ya bákalyele ti: «Bakomo nde ŋa kuruwa!» ");
INSERT INTO tyx_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilate bu amono ti nswe yi aalyele nde ka yifirikala a mupfunu o, lo mpaatsala yiikabvulu, nde ágwolo madza ya áswagha myaã ŋa nkulu a mpwumu a baara, ya ályele ti: «Me ka nsoolo ndagha mu makili ma o. Mitala beme!» ");
INSERT INTO tyx_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Baara bwohono bábvuhulu ti: «Nyaã makili ma nde mabwa ŋa yulu a bihi, ya ŋa yulu a baana ba bihi!» ");
INSERT INTO tyx_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Oŋo, nde ányaã bo Barabase. Lo Yiisu, bu bamana okaha nde nswa-nswa, Pilate ágwi nde ŋa myaã mi bo mu kuulu bakomo nde ŋa kuruwa. ");
INSERT INTO tyx_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mpwumu yohono yi a bambumbulu ba mfumu a etsulu e nsie yíbiri Yiisu mu nzo a emfumu, ya yídzyi nde. ");
INSERT INTO tyx_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bo bádzwulu nde binkuru ya bálaha nde enkuru ki ela kii mungala. ");
INSERT INTO tyx_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bátwu ebara kii mansiene ya bákwighi nde kye ŋa yulu a mutswi. Bágwi nde edzyara akwara ŋa ngo-kwogho. Bu bakunu mabuo ŋa nkulu a nde, bábwi osa nde munkulu ya bákalyele ti: «Mukogho a ba-Dzwife, mboro a we!» ");
INSERT INTO tyx_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bo bátswulu nde manteẽ, bágwolo edzyara ya bábwi okakaha nde ŋa mutswi. ");
INSERT INTO tyx_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ya bu bamana osa nde munsensehẽ, bádzwulu nde enkuru ki ela ya báfirilaha nde binkuru bi ndeme. Ya bábiri nde mu okomo nde ŋa yulu a kuruwa. ");
INSERT INTO tyx_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bo bu bapala mu bvulu, bámono mbwuru mumõ wu a ku Sirene, nkwumu a nde Simõ, bákwighi nde kuruwa li Yiisu obiri. ");
INSERT INTO tyx_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bo báto ŋa ebini ki baakata ti, «Ngolongota», mbaala ti, «etye ki mutswi a mbwuru». ");
INSERT INTO tyx_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Báŋmihi nde mala ma bviini li bábvughu ya nsogho-ŋmeẽ. Bu alyini lo, nde ábihi oŋma. ");
INSERT INTO tyx_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bu bamana okomo nde ŋa yulu a kuruwa, bákaba binkuru bi nde mu empa kiili nga-a-bwehe me wu aagwolo. ");
INSERT INTO tyx_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ya bo bábwi nsini mu okakebe nde oŋo. ");
INSERT INTO tyx_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bo bátwulu liyu-yulu li mutswi a nde ebili ki lipfu li nde, básono ti: «Wu me Yiisu, mukogho a ba-Dzwife.» ");
INSERT INTO tyx_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mu matala maana mamo, bambumbulu bákomo emõ ya nde ŋa yulu a makuruwa, bantwumu buolo, mumõ ku ngo-kwogho, wu muke ku engbambogho. ");
INSERT INTO tyx_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Baara ba bákaluru bákatughu nde ya bákanyihi mitswi mi bo, ");
INSERT INTO tyx_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ya bákalyele ti: «We wu aatsala nzo yi a ngili ya ofiritwu yo mu bitsughu bitere, bvwuhu nyuru a we weme. Kala ti we li Mwana a Nzaami, sughuru ŋa kuruwa!» ");
INSERT INTO tyx_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bumõ si bakwuru ba bangaa ba nzaami, Baluo-mikyene ya bakulu ba ekaana ki ba-Dzwife, bákasa nde munsensehẽ ya bákalyele ti: ");
INSERT INTO tyx_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Nde aabvwuhu babake, lo ka kughu obvwuhu nyuru a ndeme o! Nde li mukogho a Isarayele, mu bu nyaã asughuru ŋa kuruwa, ya bihi sa lisa kana mu nde! ");
INSERT INTO tyx_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nde ási mukolo a nde mu Nzaami, nyaã Nzaami akwulu nde mu matala ma, kala ti nde dzyi nde, mu kuulu nde aalyele ti: “Me ndi Mwana a Nzaami!”» ");
INSERT INTO tyx_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bantwumu ba bákomo ŋa yulu a makuruwa emõ ya nde bákatughu nde bwunu obo si. ");
INSERT INTO tyx_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Obaana mu tala lili embehe tee mu tala lili matere, mpyibi yíbwi ŋa yulu a nsie yohono. ");
INSERT INTO tyx_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ku bele a tala lili matere, Yiisu ásyama mu likyi lili mpini ya ályele ti: «Eli, Eli, lema sabakatani?» Mbaala ti: «Nzaami a me, Nzaami a me, mu emakye we aanyaghala me?» ");
INSERT INTO tyx_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mu ba báli oŋo, bu bagyughu, bana bályele ti: «Ligyughu, nde li mu ota Eli mbili!» ");
INSERT INTO tyx_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ŋaana oŋo, mumõ mu bo ábara áyigwolo nsana, átsubu mu bviini lili ŋeẽ, ya bu akuru yo mu edzyara, ágwi nde aŋma. ");
INSERT INTO tyx_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Lo babake bályele ti: «Makebe, litswe limono kala ti Eli sa ayabvwuhu nde!» ");
INSERT INTO tyx_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Lo Yiisu áfirisyama mu likyi lili mpini, ya átaghaba. ");
INSERT INTO tyx_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ya mono, nkpaŋa eko yi aakakabala nzo yi a ngili yíkagha mu bipa byele, obaana ku yulu tee ku nsie. Nsie yínyiŋi, mameẽ ma manene mábaghala. ");
INSERT INTO tyx_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mampyeme mádzubulu, baara balagha baba ngili baala áli bákpi, básighili mu lipfu. ");
INSERT INTO tyx_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bo bápala mu mampyeme, ya ŋa mbihi a osighili o Yiisu mu lipfu, bo básomo mu bvulu lili ngili ya bámoŋono kundaa baara balagha. ");
INSERT INTO tyx_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mukwuru a bambumbulu nkama (100) ya ba bákakebe Yiisu, bu bamono bu ónyiŋi nsie ya mi míbwi, bábagha nzalamweẽ yi alagha ya bályele ti: «Ngaŋma, wu ali Mwana a Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Oŋo óli a bakaha balagha ba bákatala la-la. Bo bákanama Yiisu obaana ku Ngalile, ya bákabulusalala nde. ");
INSERT INTO tyx_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mu bo oli a Mari musi Mangadala, Mari ngughu a Dzake ya Dzodzefe, ya ngughu a baana ba Nzebede. ");
INSERT INTO tyx_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nkonkolo bu yito, baghala mumõ wu esini wu a nkwumu a Dzodzefe, musi Arimate, ágyi. Ndehe si áli enduono e Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nde áyimono Pilate ya áluomo nde nyuru a Yiisu. Pilate ágwi litumu ti bagwa nde yo. ");
INSERT INTO tyx_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dzodzefe bu agwolo nyuru a Yiisu, ádzyi yo kunsa nkpaŋa yi a lino li linyaghara. ");
INSERT INTO tyx_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nde átwulu yo mu dzunu li ndeme li linyaghara li átsimi kunsa limeẽ, ákimini limeẽ li linene mu okyi dzunu ya ágyene o nde. ");
INSERT INTO tyx_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari musi Mangadala ya Mari wu muke áli bábwi nsini ŋa nkulu a mpyeme. ");
INSERT INTO tyx_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Etsughu ki eluono áli etsughu ki ékanama etsughu ki baakabwehẽ sabate. Bakwuru ba bangaa ba nzaami ya ba-Faridzyẽ bágyene mu emvuŋunu kundaa Pilate, ");
INSERT INTO tyx_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","bo bályele ti: «Mfumu, bihi liilibili mweẽ ti nga-a-mpya munde, ŋa aali nde mweẽ, nde ályele ti: “Ŋa mbihi a bitsughu bitere, me sa nsighili mu lipfu.” ");
INSERT INTO tyx_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mu obo, gwa litumu mu kuulu bakebe mpyeme tee mu bitsughu bitere, mfangolo binduono bi nde biyaturu nde ya bilyele kundaa baara ti: “Aasighili ŋa kara li ba bákpi!” Ya mpya yi masini oyo sa yibvulu yi a nsomo.» ");
INSERT INTO tyx_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate ályele kundaa bo ti: «Be lili a babo ba baakakebe. Ligye likebe mpyeme bwunu a bu lidzyi be.» ");
INSERT INTO tyx_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ya bo bu bagyene, bákebe mpyeme, bu bakuru yo mu limeẽ ya basi yo bilyimi, bátwulu ba baakakebe oŋo. ");
INSERT INTO tyx_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ŋa mbihi a etsughu kii sabate, mu epala-epala kii etsughu kii nsomo mu limiŋi, Mari musi Mangadala ya Mari wu muke, báyitala mpyeme. ");
INSERT INTO tyx_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ya mono, nsie yínyiĩ ku olagha. Ngye-yulu a Mfumu áfi ku yulu, áyakimini limeẽ ya ábwi nsini ŋa yulu a lo. ");
INSERT INTO tyx_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nde ákasehene ti anga musehene a nzele ya enkuru e nde éli kii buŋu lili nkara olagha. ");
INSERT INTO tyx_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bambumbulu ba bákakebe mpyeme bu bamono nde, bábwi oteghere mu nzalamweẽ ya bákala ti anga bibyimi. ");
INSERT INTO tyx_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lo ngye-yulu átsughu ndagha ya ályele kundaa bakaha ti: «Be ka likala a nzalamweẽ o, mu kuulu me nsoolo ti be Yiisu wu baakomo lili mu okabulusagha. ");
INSERT INTO tyx_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nde ka li ŋa o, mu kuulu nde aasighili mu lipfu bwunu a bu áli ályele nde. Ligya, limono ebini ki ali baalaha nde. ");
INSERT INTO tyx_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ya lisa maswa liyilyele kundaa binduono ti: “Nde aasighili ŋa kara li ba bákpi, ya mono, nde aatswama ku Ngalile, oko be liimono nde.” Limono, me ndyele be yo.» ");
INSERT INTO tyx_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bo bámara ku mpyeme mu maswa, ya nzalamweẽ ya esee ki elagha, bábara ntyini báyilyele nsia kundaa binduono. ");
INSERT INTO tyx_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lo mono, Yiisu áyibwana a bo ya ályele kundaa bo ti: «Mboro a be!» Bo báyasele kundaa nde, bákunu mabuo ŋa nsie ŋa nkulu a nde ya bákwara myili mi nde. ");
INSERT INTO tyx_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Oŋo Yiisu ályele kundaa bo ti: «Ka likala a nzalamweẽ o. Ligye, liyitwoho nsia kundaa banaana ya bambwee ba me, bagye ku Ngalile, me oko bo baamono me.» ");
INSERT INTO tyx_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bo áli nkini mu nzili, mono, ndaama mu bankyele bágyi ku bvulu ya bátwoho nsia yi a mandagha mwohono ma mábwi kundaa bakwuru ba bangaa ba nzaami. ");
INSERT INTO tyx_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bakwuru ba bangaa ba nzaami ya bakulu baba ekaana ki ba-Dzwife bábvuŋunu ya bákuru mfwunu. Bu bagwi mutala a nzi wu afaana kundaa bambumbulu ");
INSERT INTO tyx_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bátswi bo mukele wu: «Liyilyele bu: “Binduono bi nde biigyi mu mpyibi ya biituru nde, mu matala ma liikagyoŋomo bihi.” ");
INSERT INTO tyx_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ya kala ti mfumu a etsulu e nsie gyughu ndagha yi, bihi akala liibwihi nde mukolo, bihi liisa ti be linyaã okala mu mpara.» ");
INSERT INTO tyx_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bo bágwolo nzi ya bágyighili bwunu a bu báluo bo. Ndagha oyo yítsaŋama kundaa ba-Dzwife tee mu etsughu kii lolo. ");
INSERT INTO tyx_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Binduono kwumu ya emõ (11) bígyene ku Ngalile, ku munguo wu áli ólyele bo Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bo bu bamono nde, bákunu mabuo ŋa nsie ŋa nkulu a nde, lo babake báli a mikeme. ");
INSERT INTO tyx_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yiisu bu ayasele, ályele kundaa bo ti: «Litumu lwohono bágwi me lo ku yulu ya ŋa yulu a nsie. ");
INSERT INTO tyx_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mu obo, bu liigye, lisa ti bikaana byehene bikala binduono bi me, liboghoro bo mu nkwumu yi a Taara, ya yi a Mwana, ya yi a Mufulu a Ngili. ");
INSERT INTO tyx_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Liluo bo bakakebe mandagha mwohono ma aantumu me be. Ya mono, me ndi ya be bitsughu byehene, tee ku masini ma matala.»");
INSERT INTO tyx_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ki me ebaana ki Nsia yi Mbwe yi a Yiisu-Kriste, Mwana a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ti bu básono mu mukaana a mubighili Edzayi: «Tala, me sa ngweghe ntumu a me ku nkulu a we mu kuulu nde agyighili we nzili. ");
INSERT INTO tyx_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Likyi li munde wu li mu okakehe engubu ku syehe: Ligyighili nzili a Mfumu, lisa mankwulu ma nde makala nsumu!» ");
INSERT INTO tyx_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Dzã ágyi, me nde áakaboghoro baara ku syehe, ya áakatsala nsia yi a oboghoro kuu ogyiŋi mayele, mu obagha kolokolo a masumu. ");
INSERT INTO tyx_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Baara bwohono mu etsulu e nsie kii Yude ya baba bvulu lili Yerusaleme bákagye kundaa nde ya bákakihi masumu ma bo ŋa nkulu a baara bwohono. Mu obo Dzã ákaboghoro bo mu nzala wu a Dzurudẽ. ");
INSERT INTO tyx_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Dzã áli alaha eko ki batwu mu mfu a nyama wu baakata ti syamo ya álaha musili wu a mu nkobo a nyama mu bala. Nde ákadza bansense ya nyuŋu wu musuru. ");
INSERT INTO tyx_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nde ákatsala nsia yi: «Mbwuru wu li mu ogya ŋa mbihi a me luru me mu lileene. Me bu mfuŋumu, me ka mfaana si eke mu onyana misyi mi bikoghoro bi nde o. ");
INSERT INTO tyx_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Me ndi mu okaboghoro be mu madza, lo nde sa aboghoro be mu Mufulu a Ngili.» ");
INSERT INTO tyx_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mu bitsughu bibye, Yiisu áfi ku bvulu lili Nadzarete mu etsulu e nsie kii Ngalile, ya Dzã áboghoro nde mu nzala yi a Dzurudẽ. ");
INSERT INTO tyx_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ŋa ósaapala Yiisu mu madza, nde ámono mayulu mu obaghala ya Mufulu áfi ku yulu ya ásughuru ŋa yulu a nde mu efaana kii beeme. ");
INSERT INTO tyx_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Likyi líbili mu mayulu ti: «We li Mwana a me wu mukolo, me aakamono esee ki elagha mu we.» ");
INSERT INTO tyx_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ŋaana oŋo, Mufulu ábiri Yiisu ku syehe. ");
INSERT INTO tyx_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Oko, Satana ágyeele nde mu bitsughu makwumu-mana (40). Nde áli ŋa kara li banyama baba musuru, ya bangye-yulu bákasalala nde. ");
INSERT INTO tyx_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ŋa mbihi a ŋa bátyeghe Dzã, Yiisu ágyene ku Ngalile ya ábaana oluo Nsia yi Mbwe yi a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nde ákalyele ti: «Matala maato ya Emfumu e Nzaami eeyabehene. Ligyiŋi mayele, ya lisa kana mu Nsia yi Mbwe.» ");
INSERT INTO tyx_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mu matala ma ókaluru Yiisu mu mukogho a mubu wu a Ngalile, nde ámono Simõ ya Andere mbwee a nde, mu okatubu nkoho a bo mu madza ma mubu, mu kuulu bo báli bilebe banswi. ");
INSERT INTO tyx_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yiisu ályele kundaa bo ti: «Linama me! Me sa nkirili be bilebe bibi baara.» ");
INSERT INTO tyx_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ŋaana oŋo, bo bábulunyaã nkoho a bo ya bánama nde. ");
INSERT INTO tyx_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bu afirisehe ela-la, nde ámono Dzake mwana a Nzebede wu baghala, ya Dzã mbwee a nde, ba báli si munsa bwara ya ba bákabaama nkoho. ");
INSERT INTO tyx_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ŋaana oŋo, nde áti bo mbili, bo bábulusihi taara a bo Nzebede ya basala ba nde munsa bwara, ya bánama Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bo báyato ŋa bvulu lili Kaperenawume. Mu etsughu kii Sabate, Yiisu ásomo mu nzo a lisamana a ba-Dzwife, ya ábaana oluo. ");
INSERT INTO tyx_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Baara bákakiŋimi mu nduo-nduo yi ákaluo nde, mu kuulu nde ka ákaluo ti bu ókaluo baluo-mikyene o, lo ti mbwuru wu li a litumu. ");
INSERT INTO tyx_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Munsa nzo a lisamana a ba-Dzwife óli a baghala mumõ wu áali a mufulu wu mubi wu áakehe engubu ti: ");
INSERT INTO tyx_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Yiisu musi Nadzarete, we ya bihi ndagha ma? We bu aagyi mu osa kuulu ti bihi lipfighili? Me ngyahaba we na nde li: We li Wu a Ngili wu oogweghe Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yiisu áfyẽ nde ya ályele ti: «Kuru muŋma a we ya pala mu baghala wu.» ");
INSERT INTO tyx_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mufulu wu mubi ányihi nde mu mpini ya ákehe mungili wu munene. Ŋa mbihi oŋo nde ábulupala mu baghala munde. ");
INSERT INTO tyx_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Baara bwohono bákiŋimi. Mu obo bákafuhunu bo-a-bo ti: «Yi ma yo? Ma maluo ma manyaghara! Nde li mu otumu si mifulu mi mibi ya litumu, ya mye mili mu ogyughu nde!» ");
INSERT INTO tyx_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mu obo nsia a Yiisu yítsaŋama mu etsulu e nsie kii Ngalile kyehene. ");
INSERT INTO tyx_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yiisu bu apala mu nzo a lisamana a ba-Dzwife, ŋa mbihi oŋo ágyene ya Dzake ya Dzã ku nzo a Simõ ya Andere. ");
INSERT INTO tyx_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Buko bu Simõ wu mukaha áli ágyoŋomo mu nkooro a mukaama. Yiisu bu asaayato, bályele nde ndagha oyo. ");
INSERT INTO tyx_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yiisu áyasele ŋa bele a nde ya bu akwara nde mu kwogho, átehebe nde. Mukaama áfi nde ya nde ábwi osalala bo. ");
INSERT INTO tyx_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mu nkonkolo, ŋa mbihi a ŋa ódzyama tala, bágyi a nde babyele balagha ya banga a mifulu mi mibi. ");
INSERT INTO tyx_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Baara ba bvulu bwohono báyabvuŋunu ŋa nkulu a muŋma a nzo yi áli nde. ");
INSERT INTO tyx_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nde ádzuhu baara balagha ba báli a mabyele mama mawa-mawa ya ábyi mifulu mi mibi milagha. Ka ágwi muswa kundaa mifulu mi mibi ti mibili o, mu kuulu mye mígyahaba nde. ");
INSERT INTO tyx_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mu minkya-nkya, ŋaala nkini áli ya mpyibi, Yiisu átemene ya ápala mu ogye ku ebini ki egwene a baara ya ábwi osamana. ");
INSERT INTO tyx_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simõ ya baara ba báli ya nde bábaana osagha nde. ");
INSERT INTO tyx_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mu matala ma bámono bo nde, bo bályele kundaa nde ti: «Baara bwohono bali mu okabulusagha we.» ");
INSERT INTO tyx_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nde ábvuhulu bo ndiri: «Litswe nkolo nkimi, ku mala ma mali bitaataa bi, mpaala me nduo si oko, mu kuulu me mu obo me aangyi ŋa nsie.» ");
INSERT INTO tyx_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mu obo nde ágyene mu etsulu e nsie kii Ngalile kyehene ya ákabululuo mu manzo mama lisamana ma ba-Dzwife, ya ákabyi mifulu mi mibi mu baara. ");
INSERT INTO tyx_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nga-a-buala mutsyini ágyi kundaa Yiisu. Bu akunu mabuo ŋa nsie ŋa nkulu a nde, ábuono nde bu: «Kala ti we dzyi, we kughu osa me wu a tse-tse.» ");
INSERT INTO tyx_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yiisu ámono nde nyiĩ. Bu alabala ekee, ábyeme nde ya ályele ti: «Me ndzyi, kala wu a tse-tse.» ");
INSERT INTO tyx_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ŋaana oŋo buala búfi ya nde ásaatsyeme. ");
INSERT INTO tyx_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ŋaana oŋo Yiisu ábvurulu nde ku bula bu nde, átswi nde mukele mu ebaghala ");
INSERT INTO tyx_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ya ályele nde ti: «Yighili ogyughu: Ka lyele mbwuru si mumõ o, lo gye yisuo nyuru a we kundaa ngaa a nzaami, ya gwa mu otsehebe o nyuru a we ekaba ki ótumu Moyidze. Obo sa osuo bumpughulu bu otsyeme o we kundaa baara bwohono.» ");
INSERT INTO tyx_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lo baghala munde bu agyene, ábwi otsala nsia a ndagha oyo mu mpini ya mu yulu. Mu obo Yiisu ka áfiribagha bu aasomo epankala mu nswe bvulu o. Nde ákabulukala yini a ku mbala a bvulu, mu bibini bi bigwene a baara. Ya baara ba bákafa mu mankolo mwohono bákagya kundaa nde. ");
INSERT INTO tyx_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ŋa mbihi a mana bitsughu, Yiisu áyabvughuru ku Kaperenawume. Baara básoolo ti nde áli ku nzo. ");
INSERT INTO tyx_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mpwumu a baara yi nene yíbvuŋunu ya ka ófirisyili a ebini munsa nzo o, ngu okala ŋa muŋma a nzo. Yiisu ákaluo bo Ndagha a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Baara bágyi a nde mbwuru wu óneŋene binama wu óbiri babaghala bana. ");
INSERT INTO tyx_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mu kuulu ka bákakughu obiri nde tee ŋa óli Yiisu o, mu nkooro a mpwumu a baara, bo bákumu ku yulu a see li nzo lili eyala, ŋa yulu a ebini ki áli bátemene bo, bátobolo lo ya básurulu laba li bálaha baghala wu óneŋene binama. ");
INSERT INTO tyx_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yiisu bu amono kana li bo, ályele kundaa baghala wu óneŋene binama ndiri: «Mwana a me, masumu ma we baasi mo kolokolo.» ");
INSERT INTO tyx_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Oŋo óli a ndaama a baluo-mikyene ba bábwi-nsini ba bákatsimi bu mu mikolo mi bo: ");
INSERT INTO tyx_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Mu emakye nde ali mu okabili bu? Nde li mu okatsaala Nzaami. Nande kughu osa masumu kolokolo, kala ka yini a Nzaami o?» ");
INSERT INTO tyx_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ŋaana oŋo, Yiisu ágyahaba bitsimi bi bo mu mufulu a nde ya ályele bo ndiri: «Mu emakye be lili a bitsimi bibi obo? ");
INSERT INTO tyx_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Emakye egwene a mpara, olyele baghala wu óneŋene binama ti: “Baasi masumu ma we kolokolo”, bwunu we olyele ti: “Temene, gwolo laba li we ya dzyara?” ");
INSERT INTO tyx_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Lo me ndzyi ti be ligyahaba ti Mwana a mbwuru li a litumu ŋa yulu a nsie mu osa masumu kolokolo.» Nde ályele mbwuru wu óneŋene binama ti: ");
INSERT INTO tyx_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Me ndyele we yo, temene, gwolo laba li we ya bvughuru ku nzo a we.» ");
INSERT INTO tyx_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Baghala átemene, ŋaana oŋo ágwolo laba li nde ya ápala mu nzo ŋa mihi mi baara bwohono. Mu obo baara bwohono bákiŋimi ya bákasyighi Nzaami bu bakalyele ndiri: «Kaala bihi nkini límaamono ndagha yi a bu yi o!» ");
INSERT INTO tyx_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yiisu áfirigye ku mukogho a mubu wu a Ngalile. Mpwumu a baara yohono yíkagya kundaa nde, ya nde ákaluo bo. ");
INSERT INTO tyx_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bu ákaluru, nde ámono Lebvi mwana a Alafe wu baghala wu áabwi-nsini ŋa nzo yi baakafiri mpagha. Yiisu ályele nde ti: «Nama me!» Lebvi átemene, ya ánama nde. ");
INSERT INTO tyx_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bu báli ŋa tabele ku nzo a Lebvi, mintolo-mpagha milagha ya banga-a-masumu bákadza ebini emõ ya Yiisu, ya binduono bi nde. Mu kuulu bo báli balagha ba bákanama nde. ");
INSERT INTO tyx_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mu matala ma ómono baluo-mikyene mi míli mu emvuŋunu kii ba-Faridzyẽ Yiisu mu okadza ya mintolo-mpagha ya banga-a-masumu, bo bályele kundaa binduono bi nde ti: «Mu emakye nde ali mu okadza ya mintolo-mpagha, ya banga-a-masumu?» ");
INSERT INTO tyx_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yiisu bu agyughu obo, ályele bo ndiri: «Ka oli baara ba bali nsiili baakakala a nzala a ngaa-libughu o, lo babyele. Me ka aangyi mu ota baara ba bali nsumu mbili o, lo mu ota banga-a-masumu mbili.» ");
INSERT INTO tyx_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Etsughu emõ, binduono bi Dzã ya ba-Faridzyẽ bákakuru nswele mu bala. Baara báyafwulu Yiisu ti: «Binduono bi Dzã ya bibi ba-Faridzyẽ biikakuru nswele mu bala, lo mu emakye binduono bi we ka biikasa obo o?» ");
INSERT INTO tyx_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yiisu ábvuhulu bo ti: «Bandughu ba baghala wu aakie bakughu okuru nswele mu bala mu matala maala wu aakie li nkini ya bo? Matala mwohono ma baakala bo ya wu aakie, bo ka bakughu okuru nswele mu bala o. ");
INSERT INTO tyx_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bitsughu sa bigya biili sa bamaha wu aakie. Mu obo, mu bitsughu bibye bo sa akala bakuru nswele mu bala». ");
INSERT INTO tyx_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Ka oli a mbwuru wu aakabaama mupa a eko wu munyaghara ŋa yulu a enkuru ki ekulu o. Amana osa obo, mupa a eko wu munyaghara sa akaghala wu mukulu ya dzunu sa likala li libvulu bunene. ");
INSERT INTO tyx_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ya ka oli a mbwuru wu aakalo bviini li linyaghara munsa manduru mama mu bibaana bi banyama ma makulu o. Kala pele, bviini sa libulu manduru ya nde sa apfihili bviini ya manduru. Bviini li linyaghara bafaana olo lo mu manduru ma manyaghara.» ");
INSERT INTO tyx_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mu etsughu etsyini kii sabate, Yiisu ákaluru munsa manseghe ma bele ya binduono bi nde bíkabuluka binsia mu nzili-a-nzili. ");
INSERT INTO tyx_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mu obo, ba-Faridzyẽ bályele Yiisu ndiri: «Mu emakye binduono bi we bili mu okagyighili ndagha yiili ka bágwi muswa mu etsughu kii sabate o?» ");
INSERT INTO tyx_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yiisu ábvuhulu bo bu: «Be nkini áli litaã ndagha yi ósi Dabvide ŋa ákeghele nde ya ófuru nde nzala, nde ya baara ba báli ya nde? ");
INSERT INTO tyx_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Bunu-abo nde ásomo munsa nzo a Nzaami mu matala ma óli Abyatare mukwuru a bangaa ba Nzaami. Nde áli mampa ma bágwi Nzaami mukaba, maala yini a bangaa ba Nzaami bali a muswa mu odza mo. Nde ágwi mo si kundaa ba báli ya nde?» ");
INSERT INTO tyx_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ya Yiisu áfirilyele bo ndiri: «Bási sabate mu nkooro a mbwuru, lo ka bási mbwuru mu nkooro a sabate o. ");
INSERT INTO tyx_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mu obo Mwana a mbwuru li mfumu a sabate.» ");
INSERT INTO tyx_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yiisu áfiriyisomo mu nzo a lisamana a ba-Dzwife. Omo óli ya baghala mutsyini wu óneŋene kwogho. ");
INSERT INTO tyx_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Baara bákatala Yiisu mu omono kala ti nde ákaadzuhu nde mu etsughu kii sabate mpaala babagha ndagha yi baafwunu nde. ");
INSERT INTO tyx_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mu obo Yiisu ályele kundaa baghala wu óneŋene kwogho ti: «Temene ŋa, ŋa kara li baara bwohono!» ");
INSERT INTO tyx_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ŋa mbihi oŋo nde áfwulu bo ti: «Nki ndagha bágwi muswa mu etsughu kii sabate? Osa bubwe bwunu we osa bubi, obvwuhu bwunu we odzwa?» Lo bo ka bátsughu ndagha o. ");
INSERT INTO tyx_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mu obo, Yiisu átala bo bwohono ya nkehe, ya ámono nyiĩ yi alagha mu nkooro a mikolo ngyi mi bo ya ályele baghala munde ti: «Labala kwogho e we!» Nde álabala kye ya kwogho e nde ébvughuru bu éli nsomo. ");
INSERT INTO tyx_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bu basaapala, ba-Faridzyẽ bábvuŋunu ya baara baba emvuŋunu ki Erode mu osagha mayele ma baadzwa nde. ");
INSERT INTO tyx_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yiisu ágyene ku bele a mubu wu a Ngalile ya binduono bi nde. Mpwumu a baara yi nene yínama nde. Yo yífi ku bitsulu bi mansie bibi Ngalile ya Yude, ");
INSERT INTO tyx_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ku bvulu lili Yerusaleme, ku etsulu e nsie kii Idume, ku mala mama mu ngulu a nzala yi a Dzurudẽ, ya ku bitsulu bi mansie bibi ku bele a mabvulu mama ku Tire ya Sidõ. Mpwumu a baara yi nene bu yigyughu mandagha mwohono ma ákagyili nde, yígyi kundaa nde. ");
INSERT INTO tyx_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nde ályele kundaa binduono bi nde bitwulu nde bwara, mu kuulu mpwumu a baara yinyaã osa nde mpiŋi. ");
INSERT INTO tyx_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mu kuulu, buulu Yiisu ákadzuhu baara balagha, babyele bwohono bákagyighiri mu nyuru a nde ya bákasagha obyeme nde. ");
INSERT INTO tyx_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ŋa ókamono nde mifulu mi mibi, mye míkabwa mu nsie ŋa nkulu nde ya míkakehe engubu ti: «We, we li Mwana a Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lo nde ákatswa mye mukele mu ebaghala mpaala minyaã olyele nde na ali. ");
INSERT INTO tyx_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ŋa mbihi oŋo, Yiisu ákumu ku yulu a munguo. Nde áti babo ba ásuolo nde mbili ya bo bágyi kundaa nde. ");
INSERT INTO tyx_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nde ásuolo kwumu ya buolo (12) ŋa kara li bo ya ágwi bo nkwumu yi a bantumu mpaala bakala ya nde ya mpaala nde agweghe bo bayiluo Nsia yi Mbwe. ");
INSERT INTO tyx_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nde ágwi bo lileene lili obyi mifulu mi mibi. ");
INSERT INTO tyx_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ba me bantumu kwumu ya buolo (12) ba ásuolo nde: Simõ wu ágwi nde nkwumu yi a Piere, ");
INSERT INTO tyx_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","baana ba Nzebede: Dzake ya Dzã mbwee a nde. Yiisu ágwi bo nkwumu yi a Bowanerengese, yidzyi olyele ti «baana ba nganzele», ");
INSERT INTO tyx_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andere, Filipe, Baretelemi, Matye, Toma, Dzake mwana a Alafe, Tade, Simõ musi kana, ");
INSERT INTO tyx_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ya Yuda Isikaryote munde wu áatyeghe Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ŋa mbihi oŋo Yiisu ábvughuru ku nzo ya mpwumu a baara yífiribvuŋunu, mu obo Yiisu ya binduono bi nde ka bábagha bu baadza o. ");
INSERT INTO tyx_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Badzighi ba Yiisu bu bagyughu obo, bágyi mu oyasyimi nde, mu kuulu bo bákalyele: «Nde ka li mu ofirikasoolo mandagha ma ali mu okagyighili o.» ");
INSERT INTO tyx_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Baluo-mikyene ba báfi ku Yerusaleme bákalyele ti: Nde li a «Beledzebule. Me mu lileene li mfumu a mifulu mi mibi nde ali mu okabyi mifulu mi mibi.» ");
INSERT INTO tyx_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yiisu áti bo mbili ya ábwi obili ya bo mu mankumu: «Bunu-abo Satana akughu ofiribyi Satana? ");
INSERT INTO tyx_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kala ti baara ba empu emõ bakaghaba mu odzwana mvulu bo-a-bo, empu ekye ka egyili o. ");
INSERT INTO tyx_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ya kala ti baara ba dzumu limõ badzwana bo-a-bo, dzumu lilo ka ligyili o. ");
INSERT INTO tyx_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mu obo kala ti Satana temene nsumu ya ndeme, nde li wu aakaghaba ya nde ka kughu ogyili o, lileene li nde liifi. ");
INSERT INTO tyx_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ka oli a mbwuru wu kughu osomo mu nzo a mbwuru nga-a-mpini ya gwolo bilogho bi nde, kala ti ka tswama kuru nde misyi o. Kala ti nde kuru nde misyi, nde kughu obiri bilogho byehene bi bili munsa nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mu engaŋma me ndyele be ti: Nzaami sa asa mandagha mwohono ma osa baara kolokolo, ngu okala masumu ngu okala otsaala. ");
INSERT INTO tyx_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Lo nswe mbwuru wu aatsaala Mufulu a Ngili si okala ka bunu, ka kughu obagha kolokolo o. Nde li a ebili mu lisumu lili mibvu ya mibvu.» ");
INSERT INTO tyx_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yiisu ábili obo mu kuulu bo bákalyele ti nde li a mufulu wu mubi. ");
INSERT INTO tyx_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ŋa mbihi oŋo ngughu ya bambwee ba Yiisu báyato. Bo báli ku mbala ya bágweghe mbwuru mu oyita nde mbili. ");
INSERT INTO tyx_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mpwumu a baara yíbwi nsini ya yísi Yiisu ŋa kara, ya bályele nde ndiri: «Ngughu a we, bambwee ba we ya bankele ba we bali ku mbala, bo bali mu okasagha we». ");
INSERT INTO tyx_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yiisu ábvuhulu ndiri: «Nande li ngughu ya bana bali banaana bwunu we bambwee ba me?» ");
INSERT INTO tyx_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bu atala baara ba bási nde ŋa kara, nde ályele ti: «Ba me bangughu ya bambwee ba me. ");
INSERT INTO tyx_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mu kuulu, nswe munde wu aasa waa li Nzaami, munde me naana bwunu we mbwee a me, nkele a me ya ngughu a me.» ");
INSERT INTO tyx_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yiisu áfirikaluo ŋa mukogho a mubu. Mpwumu a baara yi alagha yíyabvuŋunu ŋa bele a nde. Mu obo nde ásomo munsa bwara ba búli mu madza ma mubu ya ábwi nsini omo. Mpwumu a baara yíbwi nsini ŋa nsie mu mukogho a mubu. ");
INSERT INTO tyx_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nde ákaluo bo mandagha malagha mu mankumu. Kunsa mandagha ma ákaluo nde, nde ákalyele bo ndiri: ");
INSERT INTO tyx_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Ligyughu! Etsughu nga-emõ, mukunu mutsyini ápala mu oyikunu. ");
INSERT INTO tyx_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mu matala ma ákanyahala nde nsia, ndaama a nsia yíbwi mu mukogho a nzili. Baŋmini bágyi ya báli yo. ");
INSERT INTO tyx_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ndaama yinke yíbwi ŋa ebini ki éli a mameẽ, ŋaala nsie ka yili a mubighi o. Mburu yímene mu maswa-maswa, mu kuulu nsie áli yi asala. ");
INSERT INTO tyx_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lo mwiĩ bu abala, mye mídzighi ya míkee mu kuulu misumunu ka míli a midza o. ");
INSERT INTO tyx_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nsia yinke yíbwi kunsa mingaama, ya mingaama bu mikulu mísi yo mpiŋi ya yo yíkwono oburu bimburu. ");
INSERT INTO tyx_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Lo ndaama a nsia yinke yíbwi mu nsie yi mbwe. Yo yímene, yíkulu ya yíburu mburu. Miti mi mike miburu mburu makwumu-matere (30), yinke mburu makwumu-masemene (60), yinke mburu nkama (100)». ");
INSERT INTO tyx_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ŋa mbihi oŋo Yiisu ályele ti: «Nyaã munde wu li a matswi mu ogyughu, agyughu!» ");
INSERT INTO tyx_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mu matala ma ágyene nde mu libee, babo ba bádzyi nde emõ ya ba Kwumu ya buolo (12) bábwi ofwulu nde mu mi mitala mankumu. ");
INSERT INTO tyx_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nde ályele bo ti: «Kundaa be baagwa mansweghe ma Empu e Nzaami, lo kundaa baara baba ku mbala mandagha mwohono okaluru mu mankumu, ");
INSERT INTO tyx_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","mu efaana kiili, “ngu okala ti bapana mihi, bo ka bamono elogho o, ngu okala ti bo bagyighili ogyughu, lo bo ndagha obaghala we, kala pele sa bagyiŋi mayele ya Nzaami sa asa bo kolokolo.”» ");
INSERT INTO tyx_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yiisu áfirilyele bo ti: «Kala ti be ka liibaghala nkumu yi o, lo bunu-abo be likughu obaghala mankumu mwohono ma make? ");
INSERT INTO tyx_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mukunu aakakunu Ndagha a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ba bali mu mukogho a nzili me babo baala mu bo baakakunu Ndagha a Nzaami, lo ŋa baakagyughu bo yo, Satana aakayamaha Ndagha yi baakunu mu bo. ");
INSERT INTO tyx_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Babo ba baakunu mu bibini bi bili a mameẽ, me babo baala bu bagyughu Ndagha a Nzaami, basaakihi yo mu esee, ");
INSERT INTO tyx_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","lo ka bali a midza mu bomo o. Bo baakasa kana yini a mu mana matala. Ŋa ookagya mpara bwunu we kimini mu nkooro a Ndagha a Nzaami, oŋo bo ka baafirikasa kana o. ");
INSERT INTO tyx_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Babake ba baakunu kunsa mingaama, me babo ba baakagyughu Ndagha a Nzaami, ");
INSERT INTO tyx_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","lo minyoõ mi nsie, ntono a busini bubu mpya ya nzala bilogho bibike bu yisomo mu mikolo mi bo, biikasa Ndagha a Nzaami mpiŋi ya yo ka yiburu mburu o. ");
INSERT INTO tyx_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Babake ba bákunu mu nsie yimbwe, babo me ba baakagyughu Ndagha a Nzaami, bo baakakihi yo ya baakaburu mburu: Mumõ mburu makwumu-matere (30), wu muke mburu makwumu-masemene (60), mukimi mburu nkama (100).» ");
INSERT INTO tyx_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yiisu áfirilyele bo ti: «Baakatwulu mwindi kunsa nkuru, bwunu we ku nsini a mbughu? Ka ŋa yulu a ebini ki baakatwulu mwindi o? ");
INSERT INTO tyx_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mu kuulu, ka oli a ndagha si mõ yi ensweghe yi aagwene omoŋono ŋa otsyeme o. ");
INSERT INTO tyx_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kala ti mbwuru li a matswi mu ogyughu, agyughu.» ");
INSERT INTO tyx_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yiisu áfirilyele bo ti: «Lisa mayele mu mi liikagyughu be. Eteese ki liikateese be bambaala, me mu kyini ekye si akala baateese be, ya sa bafiribwehe be bi biluru. ");
INSERT INTO tyx_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mu kuulu, kundaa munde wu li a elogho, sa bafirigwa nde, lo kundaa munde wu gwene a elogho, sa bamaha nde si ekye ki ali a nde.» ");
INSERT INTO tyx_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yiisu áfirilyele ti: «Emfumu e Nzaami efaana a mburu yi onyahala baghala munsa nseghe. ");
INSERT INTO tyx_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ngu okala ti yoŋomo, ngu okala ti nde kahala mihi, mwiĩ ya mpyibi, mburu yiikalughubu ya yiikakulu, lo nde ka aakagyahaba bunu-a-bo o. ");
INSERT INTO tyx_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nsie yiikamyehẽ mburu yomo. Nsomo musumunu aakapala, ŋa mbihi oŋo ensia ya ŋa nseele bele li ligyighili ogyele mu ensia. ");
INSERT INTO tyx_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ya mburu bu yiisaagyele, batsyiri yo mu mukpere wu a furunu mu kuulu matala mama otolo mburu maato». ");
INSERT INTO tyx_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yiisu áfirilyele ndiri: «Nki efaana likughu ogwolo mu mi mitala Emfumu e Nzaami? Mu nki nkumu likughu osuo kye? ");
INSERT INTO tyx_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kye efaana a liburu li mutaade liili ŋa baakakunu lo mu nsie, lo liluru osala mu mburu yohono yili ŋa busu bu nsie. ");
INSERT INTO tyx_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lo, kala bakunu lo, limene ya liluru miswoho myehene mutele ya lipaha mampala ma manene. Mu obo baŋmini ba mayulu baakatwu manzo ma bo mu mampala ma nde.» ");
INSERT INTO tyx_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Me mu mankumu malagha mama bu Yiisu ákaluo baara Ndagha a Nzaami bwunu a bu bákughu bo ogyughu nde. ");
INSERT INTO tyx_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nde ákabili ya bo yini a mu mankumu, lo nde ákabaala binduono bi nde mankumu mwohono ŋa áli nde ngasighi ya bo. ");
INSERT INTO tyx_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Etsughu kyini ekye mu nkonkolo, Yiisu ályele kundaa binduono bi nde ti: «Litswe lisaghaba ku ngulu a mubu yinke». ");
INSERT INTO tyx_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bu bamana obvurulu mpwumu a baara, binduono bi Yiisu bígyene ya nde mu bwara mu áli nde. Óli si ya mabwara makimi ya nde. ");
INSERT INTO tyx_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Efulu kii mpini ébwi ofulu ya mampo ma madza mákabwa mu bwara ya bwara búkalwulu mu madza. ");
INSERT INTO tyx_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yiisu ákayoŋomo ku masini ma bwara ya ásiili mutswi mu tsulu li biko. Binduono bísiili nde ya bílyele ti: «Muluo, bihi lili mu okapfighili ya we ka li mu okamono mukolo mpara o?» ");
INSERT INTO tyx_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yiisu bu asighili, áfyẽ efulu ya ályele madza ma mubu ti: «Dzuunu! Kala pii!» Efulu éfi, ya edzuunu ki enene égyi. ");
INSERT INTO tyx_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ya nde ályele kundaa bo ti: «Mu emakye be lili a nzalamweẽ? Be nkini ka lili a kana o?» ");
INSERT INTO tyx_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Enkwughu ki enene ésughuru bo ya bákabili bo-a-bo ti: «Nde nande ali, mbwuru wu, wuulu efulu ya mubu biikagyughu nde?» ");
INSERT INTO tyx_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yiisu ya binduono bi nde báto ku ngulu yinke yi a mubu mu etsulu e nsie ki ba-Ngerasenyeẽ. ");
INSERT INTO tyx_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yiisu bu asaapala mu bwara, baghala mutsyini wu áali a mufulu wu mubi ápala kunsa mampyeme ya áyabwana nde. ");
INSERT INTO tyx_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nde kunsa mampyeme ákakala ya ka óli a mbwuru wu áakughu ofirikuru nde misyi o, ngu okala basyene. ");
INSERT INTO tyx_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mu kuulu, mansa malagha bákatwulu nde myili kunsa edzu ya bákakuru nde mu basyene, lo nde ákabulu edzu ya ákatsyiri basyene. Ya ka óli a mbwuru nga-a-mpini mu odzarala nde o. ");
INSERT INTO tyx_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Matala mwohono, mpyibi ya mwiĩ, nde áli kunsa mampyeme ya ku yulu a minguo. Nde ákabulukehe bingubu ya ákabuludzwaha nyuru a ndeme mu mameẽ. ");
INSERT INTO tyx_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nde átaala Yiisu, áyabara, ákunu mabuo mu nsie ŋa nkulu a nde, ");
INSERT INTO tyx_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ya ákehe engubu ti: «Yiisu, Mwana a Nzaami, Nzaami wu a Ensoõ-yulu, nki ndagha li ŋa kara li bihi a we? Me mbuono we mu nkwumu a Nzaami, ka mwehẽ me kimini o!» ");
INSERT INTO tyx_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nde ábili obo mu kuulu Yiisu ákalyele nde ti: «Mufulu wu mubi, pala mu baghala wu!» ");
INSERT INTO tyx_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yiisu áfwulu nde ti: «Nkwumu a we na?» Nde ábvuhulu ti: «Nkwumu a me Mpwumu, mu kuulu bihi balagha lili.» ");
INSERT INTO tyx_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ya nde ábuono Yiisu ku olagha ti nde anyaã ogweghe mifulu mi mibi ku nsie nkimi. ");
INSERT INTO tyx_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ankoho, óli a mukaã a bangubulu wu munene ŋa bele a munguo ba báli mu okabuludza. ");
INSERT INTO tyx_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mifulu mi mibi míbuono Yiisu ti: «Gweghe bihi mu bangubulu banii, nyaã bihi lisomo mu bo.» ");
INSERT INTO tyx_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nde ágwi bo muswa ya mifulu mi mibi mípala, míyisomo munsa bangubulu ya bangubulu bwohono básughu ku nsie a munguo ya báyibwa mu mubu. Bo áli bakughu oto mapfwunu-muolo (2 000), ya bangubulu bwohono bákpi mu madza ma mubu. ");
INSERT INTO tyx_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Baara ba bákakebe bangubulu bábara ya báyitsala nsia kunsa bvulu ya mu mala, ya baara báyitala nki ndagha áaluru. ");
INSERT INTO tyx_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bo báyato kundaa Yiisu ya bo bámono baghala wu áali a mpwumu a mifulu mi mibi, wu áabwi nsini, wu áalaha binkuru ya wu áali a embwuru e nde kyehene. Bo bábagha nzalamweẽ. ");
INSERT INTO tyx_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Baara ba bámono mandagha ma máluru bályele bo mi míbwi mu baghala wu áali a mifulu mi mibi ya mu bangubulu. ");
INSERT INTO tyx_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mu obo, bo bábwi obuono Yiisu mpaala amara mu etsulu e nsie e bo. ");
INSERT INTO tyx_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mu matala ma ókasomo Yiisu munsa bwara, baghala wu áali a mifulu mi mibi ábuono nde mu okala ya nde. ");
INSERT INTO tyx_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lo Yiisu ka ágwi nde muswa o ya ályele nde ndiri: «Gye ku nzo a we, kundaa baara ba we ya lyele bo mandagha mwohono ma oogyighili Mfumu mu we, bunu-abo nde aamono we nyiĩ.» ");
INSERT INTO tyx_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nde ágyene ya ábaana otsala nsia a mandagha mwohono ma ogyighili nde Yiisu mu etsulu e nsie ki baakata Mabvulu-kwumu, ya baara bwohono bákiŋimi. ");
INSERT INTO tyx_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yiisu áfiribvughuru ku ngulu a mubu yinke mu bwara, ya mpwumu a baara yíyabvuŋunu ŋa áli nde ŋa mukogho a mubu. ");
INSERT INTO tyx_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mfumu a nzo a lisamana a ba-Dzwife mumõ, nkwumu a nde Dzayiruse, áyato. Bu amono Yiisu, nde ábwi ŋa nsie a myili mi nde, ");
INSERT INTO tyx_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ya ábuono nde ku olagha ti: «Mwana a me wu asala wu mukaha li kunsa lipfu. Gya, naã nde myaã mpaala nde abvwughu ya akala mweẽ!» ");
INSERT INTO tyx_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yiisu ágyene ya nde. Mpwumu a baara yi nene yínama nde ya yíkasa nde mpiŋi. ");
INSERT INTO tyx_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ankoho óli a mukaha mutsyini ŋa nsa baara babo wu áali a ebyele kii okapala makili ki ési bamvulu kwumu ya buolo (12). ");
INSERT INTO tyx_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nde ámono mpara yi alagha ŋa myaã mi bangaa-libughu balagha, ya ámana nzi a nde yohono wene a omono bubwe, ŋa yulu a yini a mpara yíikabvulu. ");
INSERT INTO tyx_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Bu agyughu bákabili mu Yiisu, nde ágyi ŋa nsa baara, ŋa mbihi a nde ya ábyeme enkuru e nde. ");
INSERT INTO tyx_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mu kuulu nde ákalyele ti: «Kala me mbyeme yini a enkuru e nde, me sa ndzughu.» ");
INSERT INTO tyx_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ŋaana oŋo, makili ma mákapala nde mákaŋama, ya nde ámono mu nyuru a nde ti ádzughu mu bubyele bu nde. ");
INSERT INTO tyx_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yiisu ásoolo ŋaana oŋo ti lileene lípala mu nde. Nde ákaghala ŋa nsa baara ya áfwulu ti: «Nande aabyeme binkuru bi me?» ");
INSERT INTO tyx_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Binduono bi nde bílyele nde ndiri: «We li mu okamono mpwumu a baara ba bali mu okasa we mpiŋi, ya we firifwulu ti: “Nande aabyeme me?”» ");
INSERT INTO tyx_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lo Yiisu átala ŋa kara li baara mu omono mbwuru wu áabyeeme nde. ");
INSERT INTO tyx_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mukaha bu agyahaba mi míbwi mu nde, ábwi oteghere mu nzalamweẽ, ábwi ŋa myili mi Yiisu ya ályele nde engaŋma kyehene. ");
INSERT INTO tyx_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Lo Yiisu ályele nde ndiri: «Mwana a me wu mukaha, kana li we liibvwuhu we. Gye mu edzuunu, nyaã we dzughu mu bubyele bu we.» ");
INSERT INTO tyx_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yiisu áli nkini mu okabili ŋa óyato baara ba báfi ku nzo a mfumu a nzo a lisamana a ba-Dzwife, ba bályele ndiri: «Mwana a we aakpi. Mu emakye we aafirisa Muluo enkwili mu mwana a we?» ");
INSERT INTO tyx_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Lo Yiisu wu áagyughu mandagha mamo ályele kundaa mfumu a nzo a lisamana a ba-Dzwife ti: «Ka kala a nzalamweẽ o, sa yini a kana.» ");
INSERT INTO tyx_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ya nde ka ákihi ti baara bagye nzili mõ ya nde o, kala ti ka yini a Piere, Dzake, ya Dzã mbwee a Dzake. ");
INSERT INTO tyx_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bu bato ŋa nzo a mfumu a nzo a lisamana a ba-Dzwife, Yiisu ámono mpwumu a baara yi áali kunsa kyaã. Baara bákalili ya bákakehe bingubu. ");
INSERT INTO tyx_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bu asomo munsa nzo, nde ályele bo ti: «Kyaã ki kii ema ya bilili bi bii ema? Mwana ka aakpi o, lo nde ogyoŋomo aagyoŋomo.» ");
INSERT INTO tyx_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bo bákasebe nde. Bu apaha baara bwohono ku mbala, Yiisu ágwolo taara ya ngughu, ya ba báli ya nde, ásomo ku óli mwana. ");
INSERT INTO tyx_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nde ákwara mwana mu kwogho ya ályele nde ndiri: «Talita kume», mbaala ti, «Mutughu, me ndyele we ti: Sighili!» ");
INSERT INTO tyx_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ŋaana oŋo, mutughu átemene ya ábwi odzyara. Nde áli a bamvulu kwumu ya buolo (12). Bo bákiŋimi ku olagha. ");
INSERT INTO tyx_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yiisu átswi bo mikele mu kuulu mbwuru si mutsyini anyaã osoolo ndagha oyo, ya nde ályele bo bagwa mutughu bi-odza. ");
INSERT INTO tyx_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yiisu ámara oŋo ya ágyene ku bvulu li nde, ya binduono bi nde bínama nde. ");
INSERT INTO tyx_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Etsughu kii sabate bu eto, nde ábwi oluo mu nzo a lisamana a ba-Dzwife. Baara balagha ba bákagyughu nde bákiŋimi ya bályele ndiri: «Mbwuru wu mandagha ma kunu-ako aabagha mo? Nande aagwi nde munzeele wu ya bimaã bi ali mu okasa mu myaã mi nde? ");
INSERT INTO tyx_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nde ka li munkomo-manzo o, mwana a Mari, naana a Dzake, Yose, Yude ya Simõ? Ya bankele ba nde ka ŋa bali o, ŋa kara li bihi?» Bo ka bási kana mu nde o. ");
INSERT INTO tyx_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Lo Yiisu ákalyele bo ndiri: «Yini a mu nsie a nde baakabihi ogwa mubighili budziri, ŋa kara li baara ba dzumu li ndeme ya baba nzo a nde.» ");
INSERT INTO tyx_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Oko nde ka ákughu osa emaã si etsyini o, nde yini a ndaama a babyele ádzuhu, babo ba ánaã nde myaã ŋa yulu mitswi mi bo. ");
INSERT INTO tyx_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yiisu ákiŋimi mu kuulu bo ka báli a kana o. Ŋa mbihi oŋo, Yiisu ákabulugye mu mala ma máli be-bele ya Nadzarete ya ákabululuo. ");
INSERT INTO tyx_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Bu ati bantumu ba nde kwumu ya buolo (12) mbili, ábwi ogweghe bo bagye buolo-buolo ya ágwi bo lileene lili obyi mifulu mi mibi. ");
INSERT INTO tyx_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Átswi bo mukele ti banyaã obiri elogho si emõ, ngu okala limpa, ngu okala empogholo bwunu we nzi mu muswele kala ka yini a mukaana o. ");
INSERT INTO tyx_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Lo nde ályele bo ti: «Lilaha bikoghoro mu myili ya ka lilaha binkuru bi bila byele o.» ");
INSERT INTO tyx_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yiisu áfirilyele bo ti: «Ŋa akala liisomo be munsa nzo nga-mõ, likala omo tee mu matala ma akala liimara be oŋo. ");
INSERT INTO tyx_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ya kala ti mu ebini nga-emõ baara babihi obwana be bwunu we ogyughu be, mu matala ma liimara be oŋo, likubulu lifufunu li myili mi be, obo sa osuo bumpughulu mu bo.» ");
INSERT INTO tyx_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Binduono bígyene ya bítsala nsia ti baara báfaana ogyiŋi mayele. ");
INSERT INTO tyx_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bye bíkabyi mifulu mi mibi kyele, bíkakili babyele balagha maala ya bíkadzuhu bo. ");
INSERT INTO tyx_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mukogho Erode ágyughu mi ókasa Yiisu. Mu kuulu nkwumu a Yiisu yíkadzumu nsia ya baara bákalyele ti: «Mbwuru wu Dzã Muboghoro aasighili ŋa kara li ba bákpi. Me mu obo nde ali a lileene mu okasa bimaã.» ");
INSERT INTO tyx_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Babake bákalyele ti: «Munde Eli.» Bakimi bákalyele ti: «Nde li mubighili ti anga mumõ mu mibighili mi bihi.» ");
INSERT INTO tyx_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lo Erode bu agyughu mandagha mamo, ályele ti: «Dzã wu aantumu me ti bakehe nde bolo, me nde aasighili ŋa kara li ba bákpi!» ");
INSERT INTO tyx_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mu kuulu, Erode ndeme áli aagweghe baara bayisyimi Dzã ya balo nde mu boloko, mu nkooro a Erodyade mukala a Filipe mwana a taara a nde, wu ákie nde. ");
INSERT INTO tyx_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Mu kuulu Dzã ákalyele Erode ti: «We ka li a muswa mu ogwolo mukala a mwana a taara a we o.» ");
INSERT INTO tyx_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erodyade áli a mbele a Dzã ya ákasagha odzwa nde. Lo ka ákakughu o, ");
INSERT INTO tyx_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","mu kuulu Erode áli a nzalamweẽ a Dzã, bu ábaghala ti Dzã áli mbwuru wu a nsumu ya wu a ngili. Mu obo Erode ákakala nde. Ŋa ákagyughu nde Dzã, bitsimi bi nde bíkagwimi, lo nde ákagyughu Dzã ya esee. ");
INSERT INTO tyx_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lo Erodyade ábagha mpeene yi odzwa Dzã etsughu ki ósi Erode malagha mama ndibili a mweẽ a etsughu ki báburu nde. Erode áti mbili mu oyadza basala ba nde baba budziri, bamfumu ba bambumbulu ya bansughu baba etsulu e nsie kii Ngalile. ");
INSERT INTO tyx_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mwana a Erodyade wu mukaha áyasomo munsa mu bákadza malagha ya ákakini. Makini ma nde mágwi Erode ya baara ba ágwi nde mpighi esee. Mu obo mukogho ályele kundaa mutughu mukaha ndiri: «Luomo me nswe elogho ki dzyi we, me sa ngwa we kye.» ");
INSERT INTO tyx_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nde álaba mukihi: «Ki aaluomo we me, me sa ngwa we kye, ngu okala ti epa ki empu e me.» ");
INSERT INTO tyx_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mutughu mukaha ápala ya áfwulu ngughu a nde: «Emakye me aanduomo?» Ngughu a nde ábvuhulu ti: «Mutswi a Dzã Muboghoro.» ");
INSERT INTO tyx_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mutughu mukaha ábvughuru maswa-maswa kundaa mukogho ya ályele nde ndiri: «Me ndzyi we gwa me mutswi a Dzã Muboghoro mu ndoŋõ lili.» ");
INSERT INTO tyx_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mukogho ányoõ ku olagha, lo mu nkooro a mikihi mi álaba ŋa nkulu ba bákadza, nde ka áli a bu ofiribihi o. ");
INSERT INTO tyx_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ŋaana oŋo nde ábiŋini nkyele mutsyini ya litumu lili ogya a nde mutswi a Dzã. Nkyele áyikehe Dzã bolo munsa boloko, ");
INSERT INTO tyx_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ya áyabiri mutswi a nde mu ndoŋõ. Nde ágwi mutswi kundaa mutughu ya mutughu ágwi nde kundaa ngughu a nde. ");
INSERT INTO tyx_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Binduono bi Dzã bu bigyughu ndagha oyo, bíyagwolo ebyimi e nde ya bálo kye kunsa mpyeme. ");
INSERT INTO tyx_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bu bayabvuŋunu kundaa Yiisu, bantumu bályele nde mandagha mwohono ma bágyighili ya ma baluo bo. ");
INSERT INTO tyx_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yiisu ályele bo ndiri: «Liyatswe mu libee, ku ebini ki egwene a baara, ya limagwumu.» Mu kuulu baara balagha báakagya ya báakabvughuru, ya bo ka bákabagha si matala mama odza o. ");
INSERT INTO tyx_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mu obo bo básomo mu bwara mu ogye ku libee, ku ebini ki egwene a baara. ");
INSERT INTO tyx_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Baara balagha bámono bo mu okagye ya básoolo bo. Mu obo, bo bákafa mu mabvulu mwohono mu myili, bábvuŋunu ya bátswama oyito ku okagye Yiisu ya bantumu ba nde. ");
INSERT INTO tyx_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yiisu bu apala mu bwara, ámono mpwumu a baara yi nene ya nde ámono bo nyiĩ, mu kuulu bo báli ti anga bindoomo bi bigwene a munkaala-bibuolo. Mu obo nde ábwi oluo bo mandagha malagha. ");
INSERT INTO tyx_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Buulu bwihi ali ayi ku ogyili, binduono bi Yiisu bíyalyele nde ti: «Ebini ki ka eli a baara o, ya bwihi buugyili. ");
INSERT INTO tyx_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bvurulu baara ba ku mala ma bo mpaala bayiswumu bi-odza mu mala ma masala ya ma manene ma mali bitaa-taa bi.» ");
INSERT INTO tyx_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Lo Yiisu ábvuhulu bo ti: «Be beme, ligwa bo bi-odza!» Bo bályele nde ndiri: «We dzyi ti bihi liyiswumu mampa ma makughu mu nkama-gyolo yi a denye ya bihi ligwa bo mo?» ");
INSERT INTO tyx_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yiisu áfwulu bo ti: «Mampa kpe be lili a mo? Ligye limatala.» Bu bayitala, bályele nde ndiri: «Mampa mataana ya banswi buolo lili a bye.» ");
INSERT INTO tyx_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mu obo, Yiisu ágwi bo litumu mu obwihi baara nsini mu yulu a nsele yi a maŋeẽ mu mampwumu. ");
INSERT INTO tyx_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Baara bábwi-nsini mu miluo mini baara nkama (100), mi mike baara makwumu-mataana (50). ");
INSERT INTO tyx_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nde bu agwolo mampa mataana mamo ya banswi buolo babo, átala ku yulu ya ábvurulu matuono. Ŋa mbihi oŋo, ákehe mampa ya ágwi mo kundaa binduono bi nde mpaala bo bakaba mo. Yiisu ákaba si banswi buolo kundaa baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Baara bwohono báli ya bágyughuru ya ");
INSERT INTO tyx_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","binduono bítolo bitsulu bi mampa ya bibi banswi bi bísyili. Bo báluhu bitubu kwumu ya byele (12). ");
INSERT INTO tyx_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Baara ba báli mampa báli babaghala mapfwunu mataana (5 000). ");
INSERT INTO tyx_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ŋaana oŋo, Yiisu ásini binduono bi nde mu osomo mu bwara ya mu otswama ku ngulu yinke yi a mubu, ku nkolo yi a bvulu lili Betesayida, edzighi ki aabvurulu ndeme baara ku manzo ma bo. ");
INSERT INTO tyx_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mu obo nde ásihi bo ya ágyene ku yulu a munguo mu oyisamana. ");
INSERT INTO tyx_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mpyibi bu yibwi, bwara búto kara-a-kara li mubu ya nde ábulusyili ngasighi ŋa yulu a nseghe. ");
INSERT INTO tyx_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yiisu ámono ti binduono bi nde bíkamono mpara mu odzughu bwara, mu kuulu bo báli ku mfulu a efulu. Ku bele a ku ookya bwihi, nde ágyene kundaa bo mu myili ŋa yulu a madza ya ákaabululuru bo. ");
INSERT INTO tyx_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bu bamono nde mu okayadzyara ŋa yulu a madza ma mubu, bo bátsimi ti ekye etoomo éeli ya bákehe bingubu. ");
INSERT INTO tyx_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mu kuulu bo bwohono bákamono nde ya báli a mikolo maã-maã. Ŋaana oŋo Yiisu ábili ya bo ya ályele ti: «Likala a bukyini! Wu me, ka likala a nzalamweẽ o!» ");
INSERT INTO tyx_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ya nde ásomo mu bwara ya efulu éfi. Bo bákiŋimi ku olagha, ");
INSERT INTO tyx_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mu kuulu bo ka bábaghala ndagha yi a mampa o: mu kuulu bo báli a mikolo ngyi. ");
INSERT INTO tyx_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bu bamana opala mubu, bo báto ŋa mbwuu yi a etsulu e nsie kii Ngenedzarete. ");
INSERT INTO tyx_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bo bu basaapala mu bwara, baara básoolo ti munde Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Baara bágyene mu etsulu e nsie kyehene ya bákayabiri babyele ŋa yulu a malaba mu nswe ebini ki bákasoolo ti nde li oŋo. ");
INSERT INTO tyx_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mu nswe ebini ki ókato Yiisu, mu mala, mu mabvulu, mu manto ma mala, baara bákatwulu babyele mu mambala ya bákabuono nde mu kuulu bo babyeme yini a mufuru a enkuru e nde. Bo bwohono ba bákabyeme nde bákadzughu. ");
INSERT INTO tyx_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ba-faridzyẽ ya ndaama a baluo-mikyene ba báfi ku Yerusaleme bábvuŋunu ya Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bo bámono binduono bi nde bibike bi bíkadza myaã mpii, gwene a oswagha myaã. ");
INSERT INTO tyx_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ankoho ba-Faridzyẽ ya ba-Dzwife bwohono ka baakadza o kala ti bo ka bagyighili oswagha myaã o, mu kuulu bo baakasalala ekulu ki bankagha-kwuru ba bo. ");
INSERT INTO tyx_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ya mu matala ma baakafa bo ku mbala yi a baara bwohono, bo bafaana otswama otsehebe manyuru nsomo badza. Bo baakasalala mikyene mikimi mimi ekulu e bo ti anga oswagha bibaha, mayughu, bibeŋene bibi boronze ya mambughu. ");
INSERT INTO tyx_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mu obo ba-Faridzyẽ ya baluo-mikyene báfwulu Yiisu ti: «Mu emakye binduono bi we biikadza ya myaã mimi mubviini ŋa ebini kii onama ekulu ki bankagha-kwuru?» ");
INSERT INTO tyx_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yiisu ábvuhulu bo ndiri: «Edzayi ágyighili obili bu ookabili mubighili mu be, bampibi, bwunu a bu básono ti: “Ekaana ki okasyighi me yini a mu bibolo, lo mikolo mi bo mili la ya me. ");
INSERT INTO tyx_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ku obwunu baakabuono me, mu kuulu maluo ma bo mali yini a mikyene mi baara.” ");
INSERT INTO tyx_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Be liikanyaghala mikyene mi Nzaami, ya liikanama ekulu e baara.» ");
INSERT INTO tyx_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nde áfirilyele bo ndiri: «Be liikatsili mukyene a Nzaami ya liikatwulu ekulu e be. ");
INSERT INTO tyx_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mu kuulu Moyidze ályele ti: “Gwa taara ya ngughu a we budziri” ya “sa badzwa munde wu aatughu taara ya ngughu a nde.” ");
INSERT INTO tyx_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lo be, be liikalyele ti: Kala mbwuru lyele taara bwunu we ngughu a nde ndiri: “Bibye bi kaangwa me we mu obaha we, bili Korobane, mbaala ti, ekaba kii ngili”, ");
INSERT INTO tyx_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","be ka lili mu ogwa nde nzili yi ofiribaha taara bwunu we ngughu a nde o. ");
INSERT INTO tyx_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Obo me bu lili mu okakahaba be Ndagha a Nzaami mu nkooro a ekulu ki lili mu okaluo be. Ya be liikasa mandagha makimi mama obo.» ");
INSERT INTO tyx_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ŋa mbihi oŋo, bu afirita mpwumu a baara mbili, Yiisu ályele bo ndiri: «Be bwohono ligyughu ya libaghala! ");
INSERT INTO tyx_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ka oli a elogho ki eli ku mbala a mbwuru kiili bu esomo mu nde esumunu nde o. Lo ngu ki eekapala mu mukolo a nde ki eekasumunu nde.»  ");
INSERT INTO tyx_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kala ti mbwuru li a matswi mu ogyughu, agyughu. ");
INSERT INTO tyx_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mu matala ma ógyene Yiisu ku nzo, ŋa mbihi a ŋa abulusihi nde mpwumu a baara, binduono bi nde bífwulu nde mu mi mitala nkumu oyo. ");
INSERT INTO tyx_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nde ályele bo ndiri: «Behe si ka lili a mayele o? Be ka liibaghala o ti ka oli a elogho kii ku mbala kiili bu esomo mu mbwuru ekughu osumunu nde o? ");
INSERT INTO tyx_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mu kuulu kye ka eekasomo mu mukolo a nde o, lo mu mila mi nde. Ŋa mbihi oŋo kye eekagye ku nto-a-nkwulu.» Obo Yiisu ásuo ti bi-odza byehene bili bitsyeme. ");
INSERT INTO tyx_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nde áfirilyele ti: «Ngu bi biikapala mu mukolo a mbwuru biikasumunu nde. ");
INSERT INTO tyx_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mu kuulu me ku kara, mu mukolo a baara, ookapala bitsimi bi bibi: enkwunu, pfyibi, odzwa baara, ");
INSERT INTO tyx_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","obvughu mbughu ya mukala bwunu we mulumu a nganda, nzala a obagha, mukolo mubi, mayele mabi, esighi, nta-ntala yi mbi, oburulu mandagha mu babake, mubili a nyuru, lala. ");
INSERT INTO tyx_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mandagha mwohono ma mabi mamo maakapala mu mukolo a mbwuru ya maakasumunu nde.» ");
INSERT INTO tyx_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yiisu ámara oŋo ya ágyene ku etsulu e nsie kii bvulu lili Tire. Oko nde ásomo mu nzo nsyini, nde ka akadzyi o ti mbwuru si mumõ asoolo, lo nde ka ákughu osweme o. ");
INSERT INTO tyx_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mukaha mutsyini wu áali a mwana wu mukaha wu áali a mufulu wu mubi ágyughu nsia a Yiisu ya áyabwa ŋa baana a myili mi nde. ");
INSERT INTO tyx_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mukaha munde áli mu-Ngereke, wu báburu ku Siri, mu etsulu e nsie kii Fenisi. Nde abuono Yiisu mu obyi mufulu wu mubi wu áali mu mwana a nde. ");
INSERT INTO tyx_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Lo Yiisu ályele nde ndiri: «Nyaã baana bamatswama ogyughuru, mu kuulu ka oli bubwe mu ogwolo mampa ma baana ya otsili mo kundaa bimbwa-mbwa o.» ");
INSERT INTO tyx_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lo mukaha ábvuhulu nde ti: «Ngaŋma Mfumu! Lo bimbwa-mbwa bi bili ku nsie a tabele biikadza mpfi-mpfihini yi ookabwihi baana.» ");
INSERT INTO tyx_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yiisu ályele nde ndiri: «Mu nkooro a mvuru oyo, gye, mufulu wu mubi aapala mu mwana a we wu mukaha.» ");
INSERT INTO tyx_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nde bu ato ku nzo a nde, áyibaha mwana wu aagyoŋomo ŋa yulu a mbughu, mufulu wu mubi áli ápala mu nyuru a nde. ");
INSERT INTO tyx_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ŋa mbihi oŋo, Yiisu ámara mu etsulu e nsie kii Tire. Nde ábululuru mu bvulu lili Sidõ mu ogye ku nkolo a mubu wu a Ngalile, ya ábulusaghaba etsulu e nsie kii Mabvulu-Kwumu. ");
INSERT INTO tyx_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bagyi a nde enkpa-matswi ki ékabili mu mpara, ya bábuono nde anaã nde myaã ŋa yulu a mutswi. ");
INSERT INTO tyx_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yiisu bu ábiri nde mu libee, mana la ya mpwumu a baara, álo nde milyeme kunsa matswi, átswulu manteẽ mu mulyeme ya ábyeme nde nzalisogho ya manteẽ ma nde. ");
INSERT INTO tyx_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ŋa mbihi oŋo, nde átala ku yulu, ágwumunu ya ályele ti: «Efata», mbaala ti, «we dzubulu!» ");
INSERT INTO tyx_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ŋaana oŋo, matswi ma nde mádzubulu, nzalisogho yíleẽ ya ábaana obili ku obwe. ");
INSERT INTO tyx_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yiisu átswi bo mukele wu ogwene olyele ndagha oyo kundaa mbwuru si mumõ. Lo nswe matala ma ákalighi nde bo banyaã otsala nde nsia, baara bákatsala nsia yiluru. ");
INSERT INTO tyx_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Baara bákakiŋimi ku olagha ya bákalyele ti: «Nde aakagyili mandagha mwohono ma mabwe. Nde li mu okasa kuulu si okala binkpa-matswi bigyughu ya bankini babili.» ");
INSERT INTO tyx_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mu bitsughu bibye, mpwumu a baara yífiribvuŋunu. Mu kuulu yo nkini ka yíli o, Yiisu áti binduono bi nde mbili ya ályele bo ndiri: ");
INSERT INTO tyx_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Mpwumu a baara yi yili mu ogwa me nyiĩ, mu kuulu bitsughu bitere bo bali ya me, ya ka bali a bi-odza o. ");
INSERT INTO tyx_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kala me mbvurulu bo ku mala ma bo nzala, sa bakolo mu nzili, mu kuulu ŋa kara li bo, babake la baafi.» ");
INSERT INTO tyx_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Binduono bi nde bíbvuhulu nde ti: «Kunu-ako bakughu obagha mampa mpaala bo bagyughuru ŋa ebini kiili baara we yi?» ");
INSERT INTO tyx_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yiisu áfwulu bo ti: «Be mampa kpe lili a mo?» Bo bábvuhulu nde ti: «Nsaama.» ");
INSERT INTO tyx_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Oŋo nde átumu mpwumu a baara babwa-mansini mu nsie. Bu agwolo mampa nsaama mamo, ábvurulu matuono kundaa Nzaami, ákehe mo ya ágwi binduono bi nde mu kuulu bakaba mo, ya bo bákaba mo kundaa mpwumu a baara. ");
INSERT INTO tyx_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bo báli si ya mana binswi-nswi. Yiisu bu amana oseme bye, ályele binduono bi nde bikaba byehe si. ");
INSERT INTO tyx_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Baara báli ya bágyughuru, ya bátolo mankuru nsaama bi bitsulu bi bísyili. ");
INSERT INTO tyx_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bo áli bakughu oto mapfwunu-mana (4 000). Ŋa nseele, Yiisu ábvurulu bo ku mala ma bo. ");
INSERT INTO tyx_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ŋaana oŋo Yiisu ásomo mu bwara ya binduono bi nde, ya bágyene ku etsulu e nsie kii Dalamanuta. ");
INSERT INTO tyx_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ba-Faridzyẽ bágyi kundaa Yiisu, bábaana otsoho ya nde, ya mu otsihi nde, bo báluomo nde elyimi ki eefa ku yulu. ");
INSERT INTO tyx_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yiisu ágwumu mu mpini mu mufulu a nde ya ályele ndiri: «Mu emakye baara baba eseene ki bali mu oluomo elyimi? Mu engaŋma me ndyele be yo, ka bagwa elyimi si emõ kundaa baara baba eseene ki o.» ");
INSERT INTO tyx_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ŋa mbihi oŋo, Yiisu ámara oŋo ya ásomo mu bwara mu ogye ku ngulu a bana yinke. ");
INSERT INTO tyx_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Binduono bi Yiisu bídzinimi ogwolo mampa. Bo báli yini a limpa litsyini munsa bwara. ");
INSERT INTO tyx_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yiisu átswi bo mukele wu: «Lidzubulu mihi ya lisa mayele mu pfini li ba-Faridzyẽ ya lili Erode.» ");
INSERT INTO tyx_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Binduono bi Yiisu bíkatsimi bye a bye ti Yiisu bu ábili obo mu kuulu bo ka báli a mampa o. ");
INSERT INTO tyx_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nde ábaghala mi bákatsoho bo-a-bo ya áfwulu bo ti: «Mu emakye be lili mu okatsoho ya lili mu okalyele be a be ti be ka lili a mampa o? Be nkini liibaghala o? Be nkini liikwara o? Mikolo mi be nkini mikubu? ");
INSERT INTO tyx_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Be lili a mihi, lo ka lili mu okamono o? Be lili a matswi, lo ka lili mu okagyughu o? Be ka lili mu okalibili mweẽ o ");
INSERT INTO tyx_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ŋa aantsyiri me mampa mataana mu ogwa kundaa baara mapfwunu-mataana (5 000), bitubu bi bilwulu mu bitsulu bi mampa kpe be liibiri?» Bo bábvuhulu: «Kwumu ya byele (12).» ");
INSERT INTO tyx_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Ya ŋa aantsyiri me mampa nsaama mu baara mapfwunu-mana (4 000), bitubu bi bilwulu kpe be liibiri?» Bo bábvuhulu ndiri: «Nsaama» ");
INSERT INTO tyx_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yiisu ályele bo ti: «Be nkini liibaghala o?» ");
INSERT INTO tyx_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yiisu ya binduono bi nde bíto ku Betesayida. Baara bágyi a nde enkpa-mihi ya bábuono nde abyeme kye. ");
INSERT INTO tyx_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yiisu ákwara enkpa-mihi mu kwogho ya ábiri nde ku mbala a bula. Bu atswulu manteẽ ŋa yulu a mihi mi nde, ánaã nde myaã ya áfwulu nde ti: «We li mu omono elogho?» ");
INSERT INTO tyx_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Enkpa-mihi édzubulu mihi ya élyele ndiri: «Me ndi mu okamono baara, me ndi mu okamono bo ti anga miti, lo bo bali mu okabulugye.» ");
INSERT INTO tyx_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yiisu áfiritwulu nde myaã ŋa yulu a mihi, ya enkpa-mihi bu epana mihi, kye édzughu ya ékamono bubwe. ");
INSERT INTO tyx_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Oŋo Yiisu abvurulu nde ya ályele nde ti: «Ka somo kunsa bula o.» ");
INSERT INTO tyx_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yiisu ya binduono bi nde bágyene ku mala ma máli mu etsulu e nsie kii Sedzare lili Filipe. Mu nzili nde ábwi okafwulu binduono bi nde ti: «Mu mbiili a baara, me nande ndi?» ");
INSERT INTO tyx_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bo bályele nde ndiri: «Baara bana ti we li Dzã Muboghoro, babake ti we li Eli, bakimi si ti we li mumõ mu mibighili.» ");
INSERT INTO tyx_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yiisu áfwulu bo ti: «Lo mu be, me nande ndi?» Piere ábvuhulu nde ti: «We, we li Kriste.» ");
INSERT INTO tyx_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yiisu átswi bo mukele banyaã olyele ndagha oyo kundaa mbwuru. ");
INSERT INTO tyx_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mu obo, nde ábaana oluo bo ti Mwana a mbwuru áli faana omono mpara yi alagha. Bakwuru, bakwuru ba bangaa ba Nzaami ya baluo-mikyene báfaana obihi nde ya odzwa nde. Ya ŋa mbihi a bitsughu bitere, nde faana osighili ŋa kara li ba bákpi. ");
INSERT INTO tyx_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nde ákalyele bo mandagha mamo epankala. Mu obo Piere ábiri nde mu libee ya áfyẽ nde. ");
INSERT INTO tyx_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lo Yiisu bu akaghala, átala binduono bi nde ya áfyẽ Piere ya ályele nde ti: «We Satana! Mara ŋa nkulu a me, mu kuulu we ka li mu okatsimi ti anga Nzaami o, lo ti anga baara.» ");
INSERT INTO tyx_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ŋa mbihi oŋo, nde áti mpwumu a baara ya binduono bi nde mbili, ya ályele bo ndiri: «Kala ti mbwuru dzyi onama me, lo atunu nyuru a ndeme, agwolo kuruwa li nde ya anama me. ");
INSERT INTO tyx_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mu kuulu, nswe munde wu dzyi obvwuhu laama li nde, sa apfihili lo. Lo, nswe munde wu aapfihili laama li nde mu nkooro a me ya mu nkooro a Nsia yi mbwe, sa abvwuhu lo. ");
INSERT INTO tyx_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nsa ndaana mbwuru aakala a yo kala ti nde bagha bupfulu bu nsie nsyini ya pfihili laama li nde? ");
INSERT INTO tyx_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nki elogho mbwuru akughu ogwa mu ogyiŋi ŋa ebini kii laama li nde? ");
INSERT INTO tyx_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mu kuulu, munde wu akala aamono budzwa mu me ya mu mandagha ma me ŋa kara li eseene kii enkwunu ya kii banga-a-masumu ki, Mwana a mbwuru si sa amono nde budzwa ŋa akala aayabvughuru nde ya bangye-yulu baba ngili kunsa nsia a Taara a nde.» ");
INSERT INTO tyx_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yiisu áfirilyele binduono bi nde ya mpwumu a baara ndiri: «Mu engaŋma, me ndyele be ti, babake mu baara ba bali ŋa ka bakpa o nsomo-a-nsomo bamono Emfumu e Nzaami ki eegya mu lileene.» ");
INSERT INTO tyx_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ŋa mbihi a bitsughu bisemene, Yiisu ábiri Piere, Dzake ya Dzã bo ngasighi mu libee, ku yulu a munguo wu mula. Nde ákighiri ŋa nkulu a bo. ");
INSERT INTO tyx_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Binkuru bi nde bíbwi osehene ya bípeŋeme mu buŋu liili ka oli a laã lili kughu ogwa buŋu lili obo ŋa nsie o. ");
INSERT INTO tyx_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eli ya Moyidze bámoŋono kundaa bo. Bo bákabili ya Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piere ályele kundaa Yiisu ndiri: «Muluo, Oli bubwe ti bihi-a-be likala ŋa. Litswe litwu bibvulu bitere: etsyini kii we, etsyini kii Moyidze ya etsyini kii Eli» ");
INSERT INTO tyx_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piere ka ákasoolo ndagha yi obili o, mu kuulu bo báli a nzalamweẽ. ");
INSERT INTO tyx_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Edzi égyi ya edzyimi-a-dzyimi e kye éfughu bo, ya ndagha yípala kunsa kye: «Wu me Mwana a me wu mukolo, ligyughu nde!» ");
INSERT INTO tyx_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ŋaana oŋo bo bátala nkolo ya nkolo, lo bo ka bámono mbwuru mukimi o ŋa yulu a yini a Yiisu ngasighi ya bo. ");
INSERT INTO tyx_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ŋa bákasughuru bo munguo, Yiisu átswi bo mukele banyaã olyele mbwuru mi bámono bo tee ŋa akala oosighili Mwana a mbwuru mu lipfu. ");
INSERT INTO tyx_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bo bási ndagha oyo nsimi, lo bakafumunu bo-a-bo ti: «Osighili mu lipfu bunu-a-bo odzyi olyele?» ");
INSERT INTO tyx_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ya binduono bi Yiisu bífwulu nde ti: «Mu emakye baluo-mikyene baakalyele ti Eli faana otswama ogya?» ");
INSERT INTO tyx_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nde ábvuhulu bo ti: «Eli tswama ogya mu obvurulu mandagha mwohono bwunu a bu máli. Bunu-abo bakughu osono mu Mwana a mbwuru ti nde faana omono mpara yi alagha ya sa babele nde? ");
INSERT INTO tyx_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lo me ndi mu olyele be ti Eli ágyi, ya baara bási nde bu bádzyi bo, bwunu a bu oli mandagha ma básono mu nde.» ");
INSERT INTO tyx_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mu matala ma báyato bo ŋa óli binduono bibike, bo bámono mpwumu a baara yi nene yi áasi binduono ŋa kara-a-kara ya baluo-mikyene ba bákatsoho ya bo. ");
INSERT INTO tyx_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mpwumu a baara bu yisaamono Yiisu, yíkiŋimi ya yíyabwana nde mu ntyini mu ogwa nde mboro. ");
INSERT INTO tyx_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yiisu áfwulu binduono bi nde ndiri: «Be mu nsa ndagha lili mu okatsoho ya bo?» ");
INSERT INTO tyx_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Baghala mumõ ŋa kara li mpwumu a baara ábvuhulu nde ti: «Muluo, me aayambiri mwana a me wu baghala wu li a mufulu wu a nkini kundaa we. ");
INSERT INTO tyx_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nswe ebini ki ookasyimi mufulu mwana, agwolo tsili nde mu nsie. Fulu liikapala mwana mu muŋma, aakakwere myini ya nyuru a nde yiikatighili. Me aambuono binduono bi we bibyi mufulu me, lo bye ka biileene o.» ");
INSERT INTO tyx_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yiisu ályele bo ndiri: «Eseene ki egwene a kana, tee nki matala me akala aankala ya be? Tee nki matala me aankuru mukolo mu be? Ligya a me nde ŋa!» ");
INSERT INTO tyx_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bágyi a nde mwana. Mu matala ma ómono mwana Yiisu, mufulu wu mubi ányihi nde mu mpini. Nde ábwi ŋa nsie ya ákakiŋimi, ya fulu líkapala nde mu muŋma. ");
INSERT INTO tyx_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yiisu áfwulu taara a mwana ti: «Obaana nki matala nde aakasa bu?» Nde ábvuhulu ndiri: «Obaana bugye bu nde. ");
INSERT INTO tyx_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ya mansa malagha mufulu aakatsili nde ku mbaa ya mu madza mu odzwa nde. Lo kala we kughu ogyighili ndagha nga-mõ, mono bihi nyiĩ ya baha bihi!» ");
INSERT INTO tyx_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yiisu ályele nde ndiri: «“Kala we kughu!” Munde wu aasa kana kughu ogyghili mandagha mwohono.» ");
INSERT INTO tyx_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ŋaana oŋo taara a mwana ákehe engubu ti: «Me nsi kana! Gya baha ogwene o kana o me!» ");
INSERT INTO tyx_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yiisu bu amono mpwumu a baara yi aakagya mu ntyini, áfyẽ mufulu wu mubi ályele nde bu: «Mufulu wu a nkini ya wu enkpa-matswi, me ngwi we litumu, pala mu mwana wu, ya ka afiriyasomo mu nde o!» ");
INSERT INTO tyx_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mufulu wu mubi ákehe mingili ya ányihi mwana mu mpini ya ábulupala. Mwana áli ayi ti anga mbwuru wu aakpi. Mu obo baara balagha bákalyele ti nde aakpi. ");
INSERT INTO tyx_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lo Yiisu, bu akwara mwana mu kwogho, ásiili nde ya mwana átemene. ");
INSERT INTO tyx_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mu matala ma obvughuru Yiisu ku nzo, binduono bi nde bífwulu nde ŋa báli bo ngasighi ti: «Mu emakye bihi bameme liikuono obyi mufulu munde?» ");
INSERT INTO tyx_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yiisu ábvuhulu bo ti: «Yini a mu lisamana be likughu okapaha efa ki mufulu wu obo.» ");
INSERT INTO tyx_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bu bamara oŋo, Yiisu ya binduono bi nde basaghaba etsulu e nsie kii Ngalile, ya nde ka ákadzyi o ti baara bagyahaba ku áli nde. ");
INSERT INTO tyx_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mu kuulu nde ákaluo binduono bi nde ya ákalyele bo ti: «Sa batyeghe Mwana a mbwuru ŋa myaã mi baara. Bo sa badzwa nde, ya bitsughu bitere ŋa mbihi a lipfu li nde, nde sa asighili ŋa kara li ba bákpi.» ");
INSERT INTO tyx_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lo binduono ka bíkabaghala ndagha oyo o, ya bo báli a nzalamweẽ mu ofwulu nde. ");
INSERT INTO tyx_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yiisu ya binduono bi nde báyato ŋa bvulu lili Kaperenawume. Bu basomo mu nzo, Yiisu ábwi ofwulu bo ti: «Be mu nsa ndagha liikatsoho mu nzili?» ");
INSERT INTO tyx_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lo bo ka bátsughu ndagha o, mu kuulu mu nzili, bo bákatsoho bo-a-bo mu osoolo nande mu bo bvulu mupfunu. ");
INSERT INTO tyx_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mu obo Yiisu ábwi-nsini, áti Bakwumu ya buolo (12) mbili ya ályele bo ti: «Kala mbwuru dzyi okala wu a nsomo, nde faana okala wu ensiele-mbihi mu baara bwohono ya musala a baara bwohono.» ");
INSERT INTO tyx_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nde ágwolo muke-muke, átwulu nde ŋa kara li bo, ya bu abwumu nde, ályele bo ti: ");
INSERT INTO tyx_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Munde wu aagyagha mu nkwumu a me muke-muke ti anga wu, meme nde agyagha. Ya munde wu gyagha me, ka oli me nde agyagha o, lo munde wu aagweghe me nde agyagha.» ");
INSERT INTO tyx_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dzã ályele nde ti: «Muluo, bihi liimono baghala mutsyini wu li mu okabyi mifulu mi mibi mu nkwumu a we. Bihi liisagha nde okahaba mu osa obo, mu kuulu nde ka aakanama bihi-a-be o.» ");
INSERT INTO tyx_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yiisu ábvuhulu ti: «Ka likahaba nde o, mu kuulu ka oli a mbwuru wuulu bu asi emaã mu nkwumu a me, ŋaana oŋo bwi obili bubi mu me o. ");
INSERT INTO tyx_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mu kuulu, wu gwene bele bihi-a-be, li wu a bihi-a-be. ");
INSERT INTO tyx_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ya munde wu akala aagwa be ebaha ki madza mu kuulu be lili baara ba Kriste, mu engaŋma me ndyele be ti, si okala ka bunu, nde ka apfihili mufuru a nde o.» ");
INSERT INTO tyx_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Lo, kala mbwuru bwihi mu masumu mumõ ŋa kara li bike-bike bi biikasa kana mu me bi, obvulu bubwe bakuru nde mu bolo limeẽ li linene li baakasighi bimburu ya batsili nde mu mubu. ");
INSERT INTO tyx_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kala ti kwogho e we eekabwihi we mu masumu, tsyiri kye. Oluru bubwe kundaa we mu osomo mu laama ya ekee etsyini ya bu gyene ku mungele-a-mbaa ya bikee bi we binsa byele, ku mbaa yi aagwene okadzimi.  ");
INSERT INTO tyx_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kala ti kwulu e we eekabwihi we mu masumu, tsyiri kye. Oluru bubwe kundaa we mu osomo mu laama ekara ya bu batsili we ku mungele-a-mbaa ya myili mi we minsa myele.  ");
INSERT INTO tyx_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ya kala ti lihi li we lili mu okabwihi we mu masumu, sorolo lo. Oluru bubwe kundaa we mu osomo mu Emfumu e Nzaami ya lihi litsyini, ya bu batsili we ku mungele-a-mbaa ya mihi minsa myele, ");
INSERT INTO tyx_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","oko bantuŋu ka baakakpa o, ya mbaa ka yiikadzimi o.» ");
INSERT INTO tyx_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Mu kuulu sa bagyeele kana li nswe mbwuru mu mbaa, mpaala nswe mbwuru akala a esee ki mungba mu be. ");
INSERT INTO tyx_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mungba li elogho ki ebwe. Lo kala ti mungba pfihili makwene ma nde, mu nki elogho baabvurulu nde makwene? Likala a mungba mu beme, ya likala kunsa edzuunu be a be.» ");
INSERT INTO tyx_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bu amara oŋo, Yiisu ágyene ku etsulu e nsie kii Yude mu ngulu a mwele wu a Dzurudẽ. Mampwumu ma baara máfiriyabvuŋunu ŋa bele a nde, ya bwunu a bu óli epfu e nde, Yiisu áfiribaana oluo bo. ");
INSERT INTO tyx_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ba-Faridzyẽ báyafwulu nde, mu otsihi nde, kala ti baghala li a muswa mu obyi mukala a nde. ");
INSERT INTO tyx_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yiisu ábvuhulu bo ti: «Nsa ndagha Moyidze átumu be?» ");
INSERT INTO tyx_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bo bályele ti: «Moyidze ágwi baghala muswa wu osono mukaana wu odzwa bala ya obyi mukala a nde.» ");
INSERT INTO tyx_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yiisu ályele bo ti: «Mu nkooro a mikolo ngyi mi be Moyidze ásono mukyene munde. ");
INSERT INTO tyx_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Lo ku ebaana ŋa ógyighili Nzaami bilogho byehene, nde ágyighili bo baghala ya mukaha. ");
INSERT INTO tyx_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mu obo baghala sa asihi a taara ya ngughu a nde ya sa akala emõ ya mukala a nde. ");
INSERT INTO tyx_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Bo bansa buolo sa bakala nyuru mõ. Mu obo, ka bafirikala baara buolo o, lo nyuru mõ. ");
INSERT INTO tyx_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mbwuru anyaã okabala baara ba óbvughu Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ŋa bábvughuru bo ku nzo, binduono bi Yiisu si bífwulu nde ndagha oyo. ");
INSERT INTO tyx_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nde ályele bo ti: «Mbwuru wu byi mukala a nde ya kie mukaha mukimi, nde si lisumu lili obvughu mbughu ya mukaha mukimi ŋa nkulu a mukala a nde wu a nsomo. ");
INSERT INTO tyx_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ya kala ti mukaha byi mulumu a nde ya kie baghala mukimi, nde si lisumu lili obvughu mbughu ya baghala mukimi.» ");
INSERT INTO tyx_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Baara bágyi a bike-bike kundaa Yiisu mu kuulu nde abyeme bye. Lo binduono bi bífyẽ baara babo. ");
INSERT INTO tyx_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yiisu bu amono obo, ákolo nkehe ya ályele kundaa binduono ti: «Linyaã bike-bike bigya kundaa me. Ka likahaba bo o, mu kuulu Emfumu e Nzaami eli kii babo ba bali ti anga bo. ");
INSERT INTO tyx_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mu engaŋma me ndyele be ti, munde wu akala aagwene ogyagha Emfumu e Nzaami ti anga muke-muke akala ka somo mu kye o.» ");
INSERT INTO tyx_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ŋa mbihi oŋo, Yiisu ábwumu bye, áseme bye mu okanaã bye myaã. ");
INSERT INTO tyx_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yiisu bu abwi-nzili mu ogye, baghala mutsyini ágyi kundaa nde mu ntyini ya ákunu mabuo mu nsie ŋa nkulu a nde. Nde áfwulu Yiisu ndiri: «Muluo wu mubwe, emakye me mfaana osa mu obagha laama lili mibvu ya mibvu?» ");
INSERT INTO tyx_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yiisu ályele nde ti: «Mu emakye we lyele ti me mbwuru wu mubwe? Ka oli a mbwuru wu mubwe o, yini a Nzaami li mubwe. ");
INSERT INTO tyx_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","We soolo mikyene mi Nzaami: Ka dzwa o, ka bvughu mbughu ya mulumu bwunu we mukala a nganda-mbwuru o, ka turu o, ka sa bumpughulu bubu mpya o, ka sa mbwuru bubi o, gwa taara ya ngughu a we budziri.» ");
INSERT INTO tyx_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Baghala munde ábvuhulu ti: «Muluo, me aankebe mikyene mimye obaana bufulu bu me.» ");
INSERT INTO tyx_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yiisu átala nde ya ádzyi nde, ya ályele nde ndiri: «We gwene a elogho etsyini: Gye, tyeghe bilogho bi we byehene, gwa nzi kundaa bawele, ya we sa kala a busini mu mayulu. Ŋa mbihi oŋo, gya ya nama me!» ");
INSERT INTO tyx_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Lo nde bu agyughu obo, ámono mukolo mpara ya ágyene kunsa minyoõ, mu kuulu nde áli a busini bulagha. ");
INSERT INTO tyx_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yiisu bu atala nkolo ya nkolo, ályele binduono bi nde ndiri: «Oli mpara kundaa bisini mu osomo mu Emfumu e Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Binduono bi nde bíkiŋimi mu mandagha mamo. Lo Yiisu áfirilyele ti: «Baana ba me, oli mpara mu osomo mu Emfumu e Nzaami! ");
INSERT INTO tyx_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ka oli mpara kundaa nyama wu baakata ti syamo mu osomo mu lihi li ntuumu o, lo obvulu mpara kundaa esini mu osono mu Emfumu e Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Binduono bífirikiŋimi ku oluru ya bíkafuhunu bo-a-bo: «Mu obo, nande kughu obvwughu?» ");
INSERT INTO tyx_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yiisu átala bo ya ályele ti: «Kundaa baara ndagha oyo ka yikughu okala o, lo ka kundaa Nzaami o, mu kuulu Nzaami kughu osa mandagha mwohono.» ");
INSERT INTO tyx_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piere ábwi-olyele nde ti: «Bihi, bihi liisihi byehene mu onama we.» ");
INSERT INTO tyx_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yiisu ábvuhulu ti: «Me ndyele be engaŋma, kala oli a mbwuru wu sihi nzo a nde, banaana, bambwee, bankele, ngughu, taara, baana bwunu we manseghe ma nde mu nkooro a me ya Nsia yi Mbwe ");
INSERT INTO tyx_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ya wu gwene obagha mutala a manzo, banaana, bambwee, bankele, bangughu, baana ya manseghe nkama (100), ya kimini, mu matala ma maagya ya laama lili mibvu ya mibvu. ");
INSERT INTO tyx_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Balagha ba bali baba nsomo sa bakala binsiele-mbihi, ya binsiele-mbihi sa bikala baba nsomo.» ");
INSERT INTO tyx_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bo báli mu nzili mu okakumu ku Yerusaleme, ya Yiisu átswama ku nkulu a binduono. Binduono bíli a enkwughu, ya ba bákanama nde báli a nzalamweẽ. Yiisu áfirigye a Bakwumu ya buolo (12) mu libee ya ábwi-olyele bo mandagha ma akala aabwana a nde ku nkulu: ");
INSERT INTO tyx_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Bihi-a-be lili mu okakumu ku Yerusaleme. Sa batyeghe Mwana a mbwuru kundaa bakwuru ba bangaa ba Nzaami ya baluo-mikyene. Bo sa batsyiri nde mukakana wu lipfu, sa batyeghe nde kundaa baara baala ka bali ba-Dzwife o, ");
INSERT INTO tyx_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","bo sa basa nde munsensehẽ, sa batswulu nde manteẽ, sa bakaha nde nswanswa ya sa badzwa nde. Lo ŋa mbihi a bitsughu bitere, nde sa asighili ŋa kara li ba bápki.» ");
INSERT INTO tyx_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Baana ba Nzebede buolo, Dzake ya Dzã, báyalyele Yiisu ndiri: «Muluo, bihi lidzyi ti we sa bihi mimye mi liiluomo bihi we.» ");
INSERT INTO tyx_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nde ályele kundaa bo ti: «Emakye be lidzyi ti me nsa mu be?» ");
INSERT INTO tyx_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bo bályele ti: «Sa kuulu ti ŋa akala we kunsa nsia a we bihi libwa-nsini, mumõ ku kwogho-a-kwogho e we, wu muke ku engbambogho e we kii bakaha.» ");
INSERT INTO tyx_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yiisu ályele bo ti: «Be ka ligyahaba ndagha yi lili mu okaluomo be o. Be likughu oŋma ebaha kii kimini ki aaŋma me bwunu we liboghoro li aambagha me?» ");
INSERT INTO tyx_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bo bábvuhulu nde ndiri: «Bihi likughu.» Yiisu ábvuhulu bo ti: «Ebaha kii kimini aaŋma me, be sa liŋma kye ya be sa libagha liboghoro li aambagha me. ");
INSERT INTO tyx_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Lo mu mi mitala obwa nsini ku kwogho-a-kwogho e me bwunu we ku engbambogho e me, ka me nkughu ogwa bibini bibye o. Bibini bibye bili bibi ndaa babo ba ogwaa Nzaami bye.» ");
INSERT INTO tyx_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ŋa ógyughu binduono kwumu bibike obo, bye bíkolo Dzake ya Dzã nkehe. ");
INSERT INTO tyx_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yiisu áti bo bwohono mbili ya ályele ndiri: «Be lisoolo ti ba baakatumu ma nsie baakatumu mo ti anga bamfumu ya baara baba mupfunu baakasuo litumu li bo. ");
INSERT INTO tyx_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ka oli bumõ ŋa kara li be o. Mbwuru wu dzyi okala mupfunu ŋa kara li be sa akala musala a be. ");
INSERT INTO tyx_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ya munde wu dzyi okala wu a nsomo ŋa kara li be nde sa akala nkana a be. ");
INSERT INTO tyx_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mu kuulu Mwana a mbwuru ka aagyi mu kuulu baara basalala nde o, lo mu osalala baara ya mu ogwa laama li nde mu ofiri ekolo mu baara balagha.» ");
INSERT INTO tyx_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yiisu ya binduono bi nde báyato ŋa bvulu lili Yeriko. Mu matala ma ókapala Yiisu mu Yeriko ya binduono bi nde ya mpwumu a baara yi nene, baghala mutsyini wu aakaluomo baara nzi wu áali enkpa-mihi, ábwi-nsini mu mukogho a nzili. Nkwumu a nde Baretime, mwana a Time wu baghala. ");
INSERT INTO tyx_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nde ágyughu ti Yiisu musi Nadzarete áakaluru ya ábwi-okehe bingubu: «Yiisu Mwana a Dabvide, mono me nyiĩ!» ");
INSERT INTO tyx_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Baara balagha bákafyeẽ nde mpaala akala pii, lo nde áakakehe bingubu kuu oluru: «Mwana a Dabvide, mono me nyiĩ!» ");
INSERT INTO tyx_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yiisu átemene ya ályele ndiri: «Lita nde mbili!» Báti enkpa-mihi mbili ya bályele nde ti: «Kala a bukyini, temene! Nde li mu okata we mbili.» ");
INSERT INTO tyx_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Enkpa-mihi etsili enkuru e nde, ékubu-mana étemene ya égyi kundaa Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yiisu áfwulu nde ti: «Emakye we dzyi me nsa mu we?» Enkpa-mihi ébvuhulu nde ndiri: «Muluo, nyaã me mfirimono!» ");
INSERT INTO tyx_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yiisu ályele nde ti: «Gye, kana li we liibvwuhu we.» Ŋaana oŋo, nde ábaana ofirimono ya ábwi onama Yiisu mu nzili. ");
INSERT INTO tyx_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mu matala ma báyabehene bo ya Yerusaleme, ku bele a mala mama Betefadze ya Betani, be-bele ya munguo wu a miti mi Olive, Yiisu ágweghe binduono byele. ");
INSERT INTO tyx_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nde ályele bo ndiri: «Ligye ku bula ba buli ku nkulu a be. Ŋa liisaasomo be kunsa bo, be sa limono mwana a aane wu bákuru. Mbwuru nkini amaabwa-nsini ŋa yulu a nde o. Linyana nde ya ligya a nde. ");
INSERT INTO tyx_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kala ti mbwuru fwulu be ti: “Mu emakye be lili mu okasa bubo?” Be libvuhulu nde bu: “Mfumu li ya nzala a nde”. Mu obo nde sa agweghe nde kunu maswa-maswa.» ");
INSERT INTO tyx_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bo bágyene ya bámono mwana a aane wu bákuru ŋa mbala, ŋa bele a muŋma a nzo mutsyini mu munsagha. Bo básurulu nde. ");
INSERT INTO tyx_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ndaama a baara mu ba báli oŋo bályele bo ti: «Be ema lili mu okasa? Mu emakye be lili mu okasurulu mwana a aane?» ");
INSERT INTO tyx_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Binduono bíbvuhulu bo bwunu a bu ólyele bo Yiisu. Mu obo bo bányaã bo bagye. ");
INSERT INTO tyx_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bágyi a mwana a aane kundaa Yiisu, bágyala biko bi bo ŋa yulu a nde. Yiisu ábwi-nsini ŋa yulu a nde. ");
INSERT INTO tyx_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Baara balagha bágyala biko bi bo mu nzili, ya babake bágyala mampala ma miti ma mali a matsyiri ma bátsyiri munsa manseghe. ");
INSERT INTO tyx_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ba báli ku nkulu ya ba bákanama Yiisu bákakehe bingubu: «Odzaana! Liseme kundaa munde wu li mu ogya mu nkwumu a Mfumu! ");
INSERT INTO tyx_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nyaã Nzaami aseme emfumu ki eli mu ogya, emfumu e Dabvide taara a bihi! Odzaana mu bibini bibi ku ensoõ yulu!» ");
INSERT INTO tyx_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yiisu ásomo mu Yerusaleme, munsa nzo a Nzaami. Bu amana otala bibini byehene, ágyene ku Betani ya Bakwumu ya buolo (12) mu kuulu áli ayi nkonkolo. ");
INSERT INTO tyx_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mu etsughu ki énama, ŋa bákapala bo kunsa Betani, nzala yífuru Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bu ataala ku la mufinge wu áali ya matsyiri, Yiisu áyitala kala ti ákughu omono liburu mu nde. Lo bu ayato, nde ámono yini a matsyiri, mu kuulu ka yíli ndo yi a bafinge o. ");
INSERT INTO tyx_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mu obo, nde ályele ti: «Mu matala mwohono, mbwuru si mumõ ka afiridza mburu a we o!» Binduono bígyughu bu óbili Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bo báyato ŋa Yerusaleme. Bu asomo mu nzo a Nzaami, Yiisu ábwi obyi minta-nkaala ya ba bákaswumu munsa nzo a nzaami, ápfumunu batabele ba ba baakasohobo nzi ya bipehe bi minta-nkaala a mabeeme. ");
INSERT INTO tyx_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ya nde ka anyaã baara bakabulubiri bilogho munsa nzo a nzaami o. ");
INSERT INTO tyx_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nde ákaluo bo ya ákalyele bo ti: «Buta básono mu Mandagha ma Nzaami ti: “Nzo a me sa bata yo nzo yi a lisamana kundaa baara ba bikaana byehene”. Lo be liikirili yo ngala a bantwumu.» ");
INSERT INTO tyx_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bakwuru ba bangaa ba nzaami ya baluo-mikyene bágyughu ndagha oyo. Bo bákasagha bunu-a-bo baadzwa nde. Bo báli a nzalamweẽ a nde mu kuulu mpwumu a baara yohono yíkakiŋimi ku olagha mu maluo ma nde. ");
INSERT INTO tyx_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nkonkolo bu yito, Yiisu ya binduono bi nde bápala mu bvulu. ");
INSERT INTO tyx_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mu epala, ŋa bákaluru bo, binduono bi nde bímono mufinge wu aakee tee ku midza. ");
INSERT INTO tyx_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piere bu alilibi-mweẽ mandagha ma máluru, ályele Yiisu ndiri: «Muluo, tala, mufinge wu aabiili we epwolo aakee.» ");
INSERT INTO tyx_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yiisu ályele bo ti: «Likala a kana mu Nzaami! ");
INSERT INTO tyx_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mu engaŋma me ndyele be ti, mbwuru munde wu akala aalyele munguo wu ti: “Mara ŋa ya gye yibwa mu mubu”, gwene a okeŋe mu mukolo a nde o, lo si kana ti mandagha ma alyele nde sa makeele, nde sa amono mo. ");
INSERT INTO tyx_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Me mu obo me ndi mu olyele be ti: Nswe ndagha yi akala liiluomo be mu lisamana, lisa kana ti be liibagha yo ya sa bagwa be yo.» ");
INSERT INTO tyx_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","«Ya, ŋa liikatemene be mu lisamana, kala ti be lili a ndagha ya mbwuru, lisa kolokolo, mpaala Taara a be wu li mu mayulu asa masumu ma behe si kolokolo  ");
INSERT INTO tyx_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26",".» ");
INSERT INTO tyx_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yiisu ya binduono bi nde bábvughuru ku Yerusaleme. Mu matala ma ákabulugye nde munsa nzo a nzaami, bakwuru ba bangaa ba nzaami, baluo-mikyene ya bakwuru báyamono nde ");
INSERT INTO tyx_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","mu ofwulu nde ti: «Mu nki litumu we li mu okagyighili mandagha ma? Ya na aagwi we litumu lilo?» ");
INSERT INTO tyx_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yiisu ábvuhulu bo ti: «Me efwulu yini a etsyini aangwa be. Ligwa me mvuru, ya me sa ndyele be mu nki litumu me ndi mu okasa mandagha ma. ");
INSERT INTO tyx_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Liboghoro li Dzã ku yulu lífi bwunu we kundaa baara? Ligwa me mvuru.» ");
INSERT INTO tyx_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bo bágyili ofuhunu bo-a-bo bu: «Limana obvuhulu “ku yulu”, nde sa alyele ti: “Mu emakye be liigwene osa kana mu nde?” ");
INSERT INTO tyx_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ya kala bihi libvuhulu ti: “Kundaa baara”. Bo báli a nzalamweẽ a baara, mu kuulu baara bwohono bákatsimi ti Dzã ali mubighili wu a ngaŋma.» ");
INSERT INTO tyx_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mu obo, bo bábvuhulu Yiisu ti: «Bihi ka lisoolo o.» Oŋo Yiisu ályele bo ndiri: «Mehe si ka ndyele be mu litumu li na me ndi mu okagyili mandagha ma o.» ");
INSERT INTO tyx_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ŋa mbihi oŋo, Yiisu ábwi obili ya bo mu mankumu bu: «Mbwuru mutsyini ákunu nseghe a bviini ya ási yo kunsa ekagha. Nde átsimi dzunu li baakakamana mburu a bviini ya átwu nzo yi mutele wu mula, ya ŋa mbihi, nde ágwihini ya binkamana bi bviini bákafiri nde nzi mu okasalala yo, ya ágyene midzye. ");
INSERT INTO tyx_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Matala mama oka mburu bu mato, nde ágweghe musala mutsyini kundaa binkamana bi bviini bibye, mu oyigwolo kaba li mburu a bviini yi báki bo. ");
INSERT INTO tyx_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lo bo bu basyimi nde, badzwi nde mudzyighi ya babvurulu nde myaã mpẽ-a-mpẽ. ");
INSERT INTO tyx_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nga-a-nseghe áfirigweghe musala mukimi kundaa bo, bo bákaha nde ku mutswi, ya bátwuhu nde budzwa. ");
INSERT INTO tyx_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nde ágweghe musala mukimi, bo bádzwi nde. Ŋa mbihi oŋo bo bádzwi basala balagha bakimi ba bágweghe mudzyighi, bwunu we bádzwi bo. ");
INSERT INTO tyx_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nga-a-nseghe ásyili yini a ya mwana a nde wu mukolo. Nde ágweghe nde ku masini mu kuulu ákatsimi bu: “Sa bagwa mwana a me budziri.” ");
INSERT INTO tyx_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lo basala babo báfuhunu bo-a-bo ti: “Wu me munde wu akala aagwolo pfa li taara a nde. Ligya, litswe lidzwa nde ya pfa sa likala lili ndaa bihi-a-be!” ");
INSERT INTO tyx_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mu obo, bo básyimi nde, bádzwi ya bátsili nde ku mbala a ekagha e nseghe a bviini. ");
INSERT INTO tyx_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Emakye nga a nseghe a bviini akala aasa? Nde sa agya, sa adzwa basala ba nseghe a bviini, ya nde sa agwa nseghe a bviini kundaa baara bakimi. ");
INSERT INTO tyx_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Be nkini limaatala Bisono bi Nzaami bi o: “Limeẽ li ootsili mitwu-manzo me lo ayi li libvulu mupfunu ŋa mutswunu. ");
INSERT INTO tyx_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ndagha oyo yiifi kundaa Mfumu, yo yili ndagha yi okiŋimi ŋa mihi mi bihi.”» ");
INSERT INTO tyx_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bamfumu ba ba-Dzwife básagha osyimi Yiisu, lo bo báli a nzalamweẽ a mpwumu a baara. Mu kuulu bo bághala ti mu bo Yiisu áti nkumu oyo. Bo bányaã nde agye. ");
INSERT INTO tyx_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ŋa mbihi oŋo bamfumu ba ba-Dzwife bágweghe ndaama a ba-Faridzyẽ ya baara baba emvuŋunu ki Erode kundaa Yiisu mpaala babwihi nde mu mwere mu mbiili a nde. ");
INSERT INTO tyx_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bo báyalyele Yiisu ti: «Muluo, bihi ligyahaba ti we aakalyele ngaŋma, ya we ka aakabara mbwuru o, mu kuulu we ka li a munkaghaba o. We aakaluo nzili a Nzaami mu engaŋma. Mu obo, bihi lili a muswa bwunu we pele mu ofiri mpagha kundaa Sedzare?» ");
INSERT INTO tyx_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lo Yiisu bu asoolo ti bo báli bampibi, nde ábvuhulu bo ti: «Mu emakye be lili mu okatsihi me? Ligya a me mupara wu a denye mumõ, me ntala nde!» ");
INSERT INTO tyx_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bo bágyi a nde denye mumõ ya Yiisu áfwulu bo ti: «Edzili ya bisono bi, bibi na?» Bo babvuhulu ndiri: «Bibi ndaa Sedzare.» ");
INSERT INTO tyx_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mu obo Yiisu ályele bo ndiri: «Libvurulu kundaa Sedzare bibi ndaa Sedzare, ya kundaa a Nzaami, bibi ndaa Nzaami.» Bo bakiŋimi ku olagha mu nkooro a Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ba-Saduseyẽ ba baakalyele ti osighili o baara ŋa kara li ba bákpi ka oli o, bágyi kundaa Yiisu ya báfwulu nde ti: ");
INSERT INTO tyx_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Muluo, Moyidze ágwi bihi mukyene wu: “Kala ti mbwuru kpi wene a mwana ya sihi mupfiili, mwana a taara a nde sa agwolo mupfiili mpaala aburu sagha li mwana a taara a nde baana.” ");
INSERT INTO tyx_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Lo, óli a baana ba taara nsaama. Wu a nsomo ákie mukaha, ákpi ya ka ásihi mwana o. ");
INSERT INTO tyx_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mbwee wu áanama nde ágwolo mukaha ya ákpi wene a osihi mwana. Bumõ si mu wu batere. ");
INSERT INTO tyx_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ya si mumõ mu bo bansa nsaama ka áburu mwana o. Bo bwohono bu bakpi, mukaha si ákpi. ");
INSERT INTO tyx_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mu matala ma akala oosighili baara bwohono ŋa kara li ba bákpi, nde mukala a nande aakala? Mu kuulu bo bansa nsaama áli bákie nde!» ");
INSERT INTO tyx_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yiisu ábvurulu bo ti: «Bu me bu lili be kunsa nzi-nzimini, be ka lili mu okabaghala o, ngu okala Bisono bwunu we lileene li Nzaami. ");
INSERT INTO tyx_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mu kuulu, mu matala ma akala oosighili baara ŋa kara li ba bákpi, baara ka bakie bakala bwunu we balumu o, lo sa bakala ti bangye-yulu mu mayulu. ");
INSERT INTO tyx_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mu mi mitala osighili o baara ŋa kara li ba bákpi, be ka lítaã mu mukaana a Moyidze o, mandagha ma ólyele nde Nzaami ŋa bele a eti-ti: “Me ndi Nzaami a Abarahame, Nzaami a Idzake, ya Nzaami a Dzake!” ");
INSERT INTO tyx_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nde ka li Nzaami a ba bákpi o, lo Nzaami a baba mweẽ. Be lili nkara ba bagwuŋumu ku olagha.» ");
INSERT INTO tyx_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mumõ mu baluo-mikyene, wu áagyughu bu bákatsoho bo ya bu ámono ti Yiisu ágwi bo mvuru yi mbwe, áyafwulu Yiisu ndiri: «Nsa mukyene wu li wu a nsomo mu mikyene myehene?» ");
INSERT INTO tyx_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yiisu ábvuhulu ti: «Wu a nsomo me wu: “Ligyughu, be basi Isarayele! Mfumu Nzaami a bihi, Mfumu li mumõ, ");
INSERT INTO tyx_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ya we sa dzyi Mfumu, Nzaami a we, mu mukolo a we wohono, mu muwumunu a we ndehene, mu mayele ma we mwohono, ya mu mpini a we yohono.” ");
INSERT INTO tyx_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mukyene wu a buolo me: “We sa dzyi nganda-mbwuru ti budzyi we nyuru a weme.” Ka oli a mukyene mukimi wu luru mimye mu mupfunu o.» ");
INSERT INTO tyx_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mu obo, muluo-mikyene ályele Yiisu ndiri: «Muluo, we aabili bubwe. We aalyele ngaŋma ti Nzaami li mumõ, ya ka oli a Nzaami mukimi o ŋa yulu a yini a nde. ");
INSERT INTO tyx_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ya ti odzyi nde mu mukolo wohono, mu mayele mwohono, mu makpa mwohono, ya odzyi nganda-mbwuru ti bu dzyi nyuru a weme, oluru bikaba bi biikadzighi byehene ya mikaba byehene.» ");
INSERT INTO tyx_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yiisu bu amono ti nde ábili mu mayele, ályele nde ti: «We ka li la ya Empu e Nzaami o.» Ŋa mbihi oŋo, mbwuru si mumõ ka áfiribagha bukyini mu ogwa nde bifwulu o. ");
INSERT INTO tyx_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yiisu ákaluo munsa nzo a nzaami: «Bunu-abo baluo-mikyene baakalyele ti Kriste li mwana a Dabvide? ");
INSERT INTO tyx_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dabvide ndeme, mu Mufulu a Ngili, ályele ti: “Mfumu aalyele kundaa Mfumu a me ti: Bwa-nsini ku kwogho-a-kwogho e me tee ŋa aantwulu me mitaara mi we ku nsini a myili mi we.” ");
INSERT INTO tyx_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kala ti Dabvide ndeme ti nde Mfumu, bunu-abo Kriste akughu okala mwana a nde?» Mpwumu a baara yi nene yi áali oŋo yíkagyughu nde ya esee. ");
INSERT INTO tyx_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yiisu ákaluo baara bu: «Lisa mayele mu baluo-mikyene. Bo badzyi okabuludzye ya binkuru bi bila. Bo badzyi ti baara bakagwa bo mamboro mu bibini bi ookabvuŋunu baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bo baakadzyi bibini bibi nsomo mu manzo mama lisamana ma ba-Dzwife, ya bibini bibi ku nkulu mu byiri bii odza. ");
INSERT INTO tyx_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bo baakagwolo bilogho bi bapfiili, ya baakasa nsamana yi nda mu kuulu baara bakamono bo. Bo sa babagha masyeme ma maluru.» ");
INSERT INTO tyx_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yiisu bu abwi-nsini ŋa nkulu a ebini ki baakalo bikaba, ákatala bu ókalo mpwumu a baara nzi yi mu boronze omo. Bisini bilagha bíkalo nzi yi alagha. ");
INSERT INTO tyx_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mupfiili mutsyini wu muwele ágyi si, ya álo mana mipara myele mi mili a mutala wu luru osala. ");
INSERT INTO tyx_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mu obo Yiisu áti binduono bi nde mbili ya ályele bo ndiri: «Mu engaŋma me ndyele be ti, mupfiili wu muwele wu aalo oluru baara bwohono ba baalo munsa ebini ki baakalo bikaba. ");
INSERT INTO tyx_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mu kuulu bo bwohono baagwi nzi yi bagwene a bo esala, lo nde, kunsa maweene ma nde, aalo nzi yohono yi aakakala a yo, yohono yi akaasalala mu olaama.» ");
INSERT INTO tyx_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mu matala ma ókapala Yiisu mu nzo a nzaami, enduono e nde etsyini élyele nde ti: «Muluo, tala ati mameẽ ma, nzo yi bátwu yo bubwe!» ");
INSERT INTO tyx_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yiisu ábvuhulu nde ti: «We li mu omono nzo yi nene yi? Ka osyili limeẽ ŋa yulu a limeẽ likimi o, sa batsala mo mwohono.» ");
INSERT INTO tyx_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yiisu áli abwi-nsini ku yulu a Munguo wu a mi-Olibve wu áali nkolo ya nkolo ya nzo a nzaami. Piere, Dzake, Dzã ya Andere bábwi ogwa nde bifwulu ŋa engasighi: ");
INSERT INTO tyx_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Malyele ati bihi, mu nki matala mandagha mamo maatswighi, ya nki elyimi eesuo masini ma bilogho byehene bibye?» ");
INSERT INTO tyx_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mu obo Yiisu ábwi olyele bo ti: «Lisa mayele mbwuru anyaã opfiri be. ");
INSERT INTO tyx_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Baara balagha sa bagya ya basalala nkwumu a me, bu balyele ti: “Ngu me Kriste!” Ya sa bapfiri baara balagha. ");
INSERT INTO tyx_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ŋa akala liigyughu be baara mu okabili mu mamvulu ya mansia mama mamvulu, ka likala a nzalamweẽ o, mu kuulu mandagha mwohono mamo mafaana ogya. Lo mamo ka mali masini ma nsie o. ");
INSERT INTO tyx_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mansie sa madzwana ya mansie, ya empu sa edzwana ya empu. Nsie sa yinyiĩ mu mpini mu mambughu malagha, ya sa okala a minzyala. Ekye sa ekala ebaana ki misuo mii oburu». ");
INSERT INTO tyx_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Lisa mayele mu beme. Sa batyeghe be ŋa mambala ma miyala ya sa bakaha be nswanswa mu manzo mama lisamana ma ba-Dzwife. Sa bafwunu be ŋa nkulu a bamfumu ba bitsulu bi mansie ya mikogho mu nkooro a me. Be sa lisuo bampughulu kundaa bo. ");
INSERT INTO tyx_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nsomo a nsomo, bafaana oluo baara ba mansie mwohono Nsia yi Mbwe. ");
INSERT INTO tyx_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ŋa akala baabiri be ya baatyeghe be, ka likala a mikolo maã-maã mu mi liibili be o. Lo lilyele mi akala baagwa be mu matala maana mamo, mu kuulu ka oli be akala liibili o, lo Mufulu a Ngili». ");
INSERT INTO tyx_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Mwana a taara sa atyeghe mwana a taara mu lipfu, ya taara sa atyeghe mwana a nde. Baana sa babihi okala mu litumu li biburu bi bo, ya sa badzwa bo. ");
INSERT INTO tyx_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Baara bwohono sa babele be mu nkooro a nkwumu a me, lo munde wu akala aasa mukama tee ku masini sa abvwughu». ");
INSERT INTO tyx_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Ŋa akala liimono be Ngughu a bubi ba buukabyihi ŋa ebini kiili bo ka bufaana okala o – nyaã munde wu li mu otaã abaghala – oŋo, baara ba baakala ku Yude babara ku minguo. ");
INSERT INTO tyx_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mbwuru wu aakala ku yulu a see li nzo lili eyala, anyaã osughuru, anyaã osomo mu nzo mu ogwolo elogho munsa nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ya munde wu aakala ku manseghe anyaã obvughuru ku nzo mu oyigwolo enkuru e nde. ");
INSERT INTO tyx_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mu bitsughu bibye, nyiĩ yi alagha kundaa bakaha ba baakala a mayimi ya basuomo!» ");
INSERT INTO tyx_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lisamana mu kuulu mandagha mamo manyaã obwa mu ndo yi a mpie yi alagha! ");
INSERT INTO tyx_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mu kuulu bitsughu bibye sa bikala bitsughu bibi mpara yi alagha, mpara yiili obaana ku ebaana e nsie yi ógyighili Nzaami tee mu matala ma, baara nkini bámaamono yo o. Ya si okala ka bunu, mpara yi obo ka yifirikala mu bitsughu bibi nkulu o. ");
INSERT INTO tyx_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kala ti Mfumu ka ási kuulu bitsughu bibye bikala bipfi o, mbwuru si mutsyini ka ákaabvwughu o. Lo nde aasi bye bipfi mu nkooro a babo ba aasuolo nde. ");
INSERT INTO tyx_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Mu obo, kala mbwuru lyele be ti: “Kriste li ŋa”, bwunu we “Kriste li kunii”, ka lisa kana mu nde o. ");
INSERT INTO tyx_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mu kuulu bakeretyẽ baba mpya ya mibighili mimi mpya sa bagya. Bo sa basa bilyimi ya mandagha mama okiŋimi mu opfiri babo ba osuolo Nzaami kala ti okughu okala. ");
INSERT INTO tyx_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Likala yeelee! Me ntswama ndyele be mandagha mwohono.» ");
INSERT INTO tyx_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Lo mu bitsughu bibye, ŋa mbihi a mpara yi alagha oyo, Tala sa lipyini, mwele wu a ngoono ka afirigwa otsyeme o nde o, ");
INSERT INTO tyx_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Baŋomaŋomo sa babwa ŋa nsie, ya lileene lili ku mayulu sa linyiŋi. ");
INSERT INTO tyx_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ŋa mbihi oŋo baara sa bamono Mwana a mbwuru mu okagya ŋa yulu a bidzi ya lileene lili lagha ya nsia. ");
INSERT INTO tyx_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Oŋo nde sa agweghe bangye-yulu ya sa abvughu mu manto ma nsie mansa mana, obaana ku ósini nsie tee ku ósini yulu, baara bwohono ba ásuolo nde.» ");
INSERT INTO tyx_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Nyaã nkumu yi a mufinge yiluo be: Ŋa osaakadzughu mampala ma nde ya matsyiri maafulu, be liikasoolo ti dzwa liibehene. ");
INSERT INTO tyx_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bumõ behe si, ŋa akala liimono be mandagha mamo mu omoŋono, lisoolo ti matala maabehene, mo ayi ŋa muŋma a nzo. ");
INSERT INTO tyx_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mu engaŋma me ndyele be, eseene ki ka eluru o, mandagha mwohono ma sa mamoŋono. ");
INSERT INTO tyx_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yulu ya nsie sa biluru, lo mandagha ma me ka maluru o.» ");
INSERT INTO tyx_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Mu mi mitala etsughu ya matala, mbwuru si mumõ ka asoolo o, ngu okala bangye-yulu mu mayulu, bwunu we Mwana, lo yini a Taara soolo. ");
INSERT INTO tyx_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Lisa mayele, likahala mihi, mu kuulu be ka lisoolo ŋa ooto matala ma mo o. ");
INSERT INTO tyx_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sa okala ti anga mbwuru munde wuulu bu agyene ku midzye, bulusihi nzo a nde, gwi litumu kundaa basala ba nde. Nde sa agwa esala kundaa nswe musala a nde, ya sa atumu nkyele a muŋma a nzo mu okahala mihi. ");
INSERT INTO tyx_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mu obo, likahala mihi, mu kuulu be ka lisoolo ŋa akala oogya mfumu a nzo o. Nde kughu ogya mu nkonkolo, bwunu we mu kara-a-kara a mpyibi, bwunu we ŋa ookwolo nsuhu-a-nsomo, bwunu we mu epala. ");
INSERT INTO tyx_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Likala a nzalamweẽ ti nde anyaã ogya ensihibi ya nde anyaã oyabagha be liigyoŋomo ensama. ");
INSERT INTO tyx_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ndagha yi ndyele me be, me ndyele yo kundaa baara bwohono: likahala mihi!» ");
INSERT INTO tyx_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bitsughu byele bíisyili mu osomo mu kyiri kii Paake ya kii Mampa ma magwene a pfini. Bakwuru ba bangaa ba nzaami ya baluo-mikyene bákasagha bunu-a-bo baasyimi Yiisu mu mayele ya baadzwa nde. ");
INSERT INTO tyx_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bo bákalyele ti: «Ka kunsa kyiri o, mfangolo okala a kyaã ŋa kara li baara.» ");
INSERT INTO tyx_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yiisu áli ku Betani, mu nzo a Simõ nga-a-buala – lo nde áli ádzughu – Mu matala ma ákadza nde ŋa tabele, mukaha mutsyini áyasomo mu nzo. Nde áli a mbwara yi a mu alabatere yi áalwulu mu mananaase mama nare mama nkara a tse-tse, mama ntala yi nene. Bu abulu mbwara, nde ágyiri mananaase ŋa yulu a mutswi a Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Baara babake bákolo nkehe ya bábili bo-a-bo ti: «Mu emakye nde aasi mananaase ma mfini? ");
INSERT INTO tyx_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ali bakughu otyeghe mananaase ma mu nkama-tere (300) yi a badenye, ya ogwa nzi oyo kundaa bawele!» Ya bo bákolo mukaha munde nkehe. ");
INSERT INTO tyx_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lo Yiisu ályele ndiri: «Linyaã nde! Mu emakye be liimwehẽ nde mukolo mpara? Nde aagyighili ndagha yimbwe mu me. ");
INSERT INTO tyx_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mu kuulu, be sa likala a bawele mu nswe matala, ya be likughu osa bo bubwe ŋa lidzyi be. Lo me, be ka likala ya me mu matala mwohono o. ");
INSERT INTO tyx_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mukaha wu aasi mi aakughu nde, nde aatswaama ogyogho nyuru a me mananaase nsomo badzyighi yo. ");
INSERT INTO tyx_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mu engaŋma me ndyele be ti, nswe ebini ki akala baaluo Nsia yi Mbwe mu nsie nsyini, sa balyele si mu olibili mweẽ, mandagha ma oosi mukaha wu.» ");
INSERT INTO tyx_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yuda Isikaryote, mumõ mu Bakwumu ya Buolo (12), áyimono bakwuru ba bangaa ba nzaami mpaala atyeghe bo Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bo bu bagyughu nde, básomo kunsa esee, ya basiini ogwa nde nzi. Mu obo, Yuda ákasagha matala ma mafaana mu otyeghe Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mu etsughu kii nsomo kii kyiri kii Mampa ma magwene a pfini, etsughu ki bákadzwa mu mukaba mwana a endoomo wu baakadza mu Paake, binduono bi Yiisu bífwulu nde ndiri: «Kunu-ako we dzyi ti bihi liyigyighili we bi-odza bibi Paake?» ");
INSERT INTO tyx_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nde ágweghe byele mu binduono bi nde ya ályele bye ti: «Ligye ku bvulu, baghala mutsyini sa ayabwana a be ya yughu li madza. Be linama nde ");
INSERT INTO tyx_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ya omo mu aasomo nde, lilyele kundaa mfumu a nzo bu: “Muluo bu aalyele: Ngwumu a nzo yi aandza me kyiri kii Paake ya binduono bi me yini-ayo?” ");
INSERT INTO tyx_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nde sa asuo be ngwumu yi a ku yulu a nzo yi nene muulu bilogho byehene bikughu. Ngu omo be liigyighili bihi bilogho bibi kyiri.» ");
INSERT INTO tyx_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Binduono bígyene, bíto ŋa bvulu, bíbwana a mandagha ti bwunu a bu ólyele bo Yiisu ya bye bígyighili bi-odza bibi kyiri kii Paake. ");
INSERT INTO tyx_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nkonkolo bu yito, Yiisu áyato ya Bakwumu a Buolo (12). ");
INSERT INTO tyx_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mu matala ma báli bo ŋa tabele mu odza, Yiisu ályele ti: «Mu engaŋma me ndyele be, mumõ ŋa kara li be, wu li mu okadza ya me, sa atyeghe me.» ");
INSERT INTO tyx_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bantumu bányoõ, ya bábwi ofwulu nde mumõ-mumõ ti: «Me?» ");
INSERT INTO tyx_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yiisu ábvuhulu bo ndiri: «Mumõ mu Bakwumu a buolo (12), munde wu aalo kwogho mu ndoõ emõ ya me. ");
INSERT INTO tyx_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwana a mbwuru li mu ogye, bwunu a bu básono mu nde. Lo nyiĩ yi alagha kundaa mbwuru munde wu aakala nzili yi baatyeghe Mwana a mbwuru! Áli obvulu bubwe banyaã oburu mbwuru munde.» ");
INSERT INTO tyx_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mu matala ma bákadza bo, Yiisu ágwolo limpa, bu amana olyele mandagha mama liseme, átsyiri lo ya ágwi bo lo ya ályele ndiri: «Ligwolo, yi nyuru a me.» ");
INSERT INTO tyx_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ŋa mbihi oŋo, Yiisu ágwolo ebaha, bu amana obvurulu matuono, ágwi bo kye ya bo bwohono báŋmi kye. ");
INSERT INTO tyx_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nde ályele bo ti: «Ma me makili ma me, makili mama ogwihini, ma maatsaŋama mu nkooro a baara balagha. ");
INSERT INTO tyx_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mu engaŋma me ndyele be ti, me ka amfiriŋma bviini o tee mu etsughu ki amfiriŋma me lo, li linyaghara, mu Emfumu e Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bo bu bamana ogyimi Nzaami bikwumu bibi masyighi, bo bágyene ku Munguo wu a mi-Olibve. ");
INSERT INTO tyx_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yiisu ályele bo ndiri: «Kana li be bwohono mu me sa libwa, mu kuulu básono ti: “Me sa nkaha munkaala-bibuolo, ya bindoomo sa bitsaŋama.” ");
INSERT INTO tyx_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lo ŋa mbihi a ŋa aansighili me ŋa kara li ba bákpi, me sa nswama be ku Ngalile.» ");
INSERT INTO tyx_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piere ályele nde ndiri: «Ngu okala ti baara bwohono sa babwa mu nkooro a we, lo me ka mbwa o.» ");
INSERT INTO tyx_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yiisu ábvuhulu nde ndiri: «Mu engaŋma, me ndyele we, mu mpyibi yi a lolo li, nsomo mulumu a nsuhu akuolo nsa ywolo, we sa tunu me mu mansa matere.» ");
INSERT INTO tyx_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lo Piere ási minkaŋana mi nyuru mu mpini ti: «Si okala ti me nfaana okpa ya we, me ka ntunu we o!» Ya binduono byehene bíbili bwunu obo. ");
INSERT INTO tyx_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yiisu ya binduono bi nde báto ŋa ebini kii nkwumu Ngetesemane. Nde ályele bo ndiri: «Libwa-nsini ŋa, mu matala ma aansamana me.» ");
INSERT INTO tyx_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nde ábiri Piere, Dzake ya Dzã, ya ábaana omono nzalamweẽ yi alagha ya mukolo maŋa-maŋa. ");
INSERT INTO tyx_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mu obo, nde ályele bo ti: «Me ndi a nyiĩ mu muwumunu a me tee ku lipfu. Likala ŋa ya likahala mihi!» ");
INSERT INTO tyx_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Bu asehe linku-nkulu eke, ábwi mu nsie ya ábuono Nzaami kala okughu okala ti matala ma mampara ma mamara ŋa busu bu nde. ");
INSERT INTO tyx_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nde ákalyele ti: «Aba! Taara! We aakaleene mandagha mwohono, maha ebaha kii mpara ki ŋa bele a me! Lo ka bwunu a bu ndzyi me o, lo bu dzyi we.» ");
INSERT INTO tyx_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yiisu áyabvughuru ya áyabagha bo kunsa ensama. Mu obo nde ályele kundaa Piere ndiri: «Simõ, we aagyoŋomo! We ka aaleene okahala mihi si mu tala litsyini o! ");
INSERT INTO tyx_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Likahala mihi ya lisamana, mu kuulu be linyaã osomo kunsa bigyeele. Mufulu li a mbaa, lo nyuru yikolo.» ");
INSERT INTO tyx_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yiisu áfirigye la ya bo ya ábuono Nzaami bwunu a bu ábuono nde nsomo. ");
INSERT INTO tyx_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ya áyabvughuru ya nde áfiriyabaha bo bagyoŋomo ensama, mu kuulu mihi mi bo áli míleme mu ensama. Bo ka bábagha yi obvuhulu nde o. ");
INSERT INTO tyx_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yiisu áfiriyabvughuru mu sa lili tere ya ályele bo ti: «Be nkini ensama lili, be nkini ogwumu liikagwumu! Mandagha mwohono maakeele. Matala maato, Mwana a mbwuru baatyeghe nde ŋa myaã mi banga-a-masumu. ");
INSERT INTO tyx_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Litemene, litswe! Munde wu aatyeghe me aayabehene.» ");
INSERT INTO tyx_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ŋaana oŋo, ŋaala nde nkini mu okabili, Yuda, mumõ mu Bakwumu a buolo (12), áyapala ya mpwumu a baara yi áali a mapee ya mankwogho ba ógweghe bakwuru ba bangaa ba nzaami, baluo-mikyene ya bakwuru. ");
INSERT INTO tyx_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Munde wu áakatyeghe nde ágwi bo elyimi ki: «Mbwuru munde wu aanyuburu me, me nde. Lisyimi nde ya ligye a nde ya baara ba baagyili okebe nde.» ");
INSERT INTO tyx_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda bu asaayato, ásele kundaa Yiisu ya ályele ndiri: «Muluo!» Ŋa mbihi oŋo nde ányuburu Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Oŋo bo bábwirili Yiisu ya básyimi nde. ");
INSERT INTO tyx_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mumõ mu ba báli oŋo ádzuru lipee li nde, átini musala a mukwuru a bangaa ba nzaami ya ákehe nde tswi. ");
INSERT INTO tyx_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yiisu ályele bo ndiri: «Be liiyasyimi me ya mapee ya mankwogho, ti anga be liiyasyimi ntwumu! ");
INSERT INTO tyx_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Bitsughu byehene me aakankala ŋa kara li be ya aakanduo mu nzo a nzaami ya be ka liiyasyimi me o. Lo mu kuulu Bisono bibi ngili bikeele.» ");
INSERT INTO tyx_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mu obo binduono bi Yiisu byehene bínyaghala nde ya bíbara. ");
INSERT INTO tyx_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Munkuru-mbala mutsyini ákanama Yiisu. Nde ali álaha yini a nkpaã a eko yi a lino. Baara bu basagha osyimi nde, ");
INSERT INTO tyx_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nde ábulunyaã nkpaã a eko ya ábara mpene. ");
INSERT INTO tyx_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bábiri Yiisu kundaa mukwuru a bangaa ba nzaami. Bakwuru ba bangaa ba nzaami bwohono, bakwuru ya baluo-mikyene bábvuŋunu oko. ");
INSERT INTO tyx_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piere ákanama Yiisu la-la tee munsa mbala a mfumu a bakwuru ba bangaa ba nzaami. Munsa omo, nde ábwi-nsini ya bankyele ba mfumu a bakwuru ba bangaa ba nzaami, ya ákagyoro mbaa. ");
INSERT INTO tyx_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bakwuru ba bangaa ba nzaami ya ekwuru ki ba-Dzwife kyehene básagha bampughulu ba bámono Yiisu kunsa epfwumu mpaala badzwa nde, lo ka bábagha o. ");
INSERT INTO tyx_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mu kuulu baara balagha baakasuo bumpughulu bubu mpya mu nde, lo bumpughulu bu bo ka búkagye mu nzili o. ");
INSERT INTO tyx_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mu obo, ndaama a baara babake bátemene, ya báburulu nde ndagha yi: ");
INSERT INTO tyx_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Bihi liigyughu nde mu okalyele ndiri: “Me sa ntsala nzo a nzaami yi yi ótwu myaã mi baara ya mu bitsughu bitere me sa ntwu nkimi yiili ka myaã mi baara miigyighili yo o.”» ");
INSERT INTO tyx_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Si okala mu ndagha oyo, bumpughulu bu baara ka bukagye nzili mõ o. ");
INSERT INTO tyx_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mu obo, mukwuru a bangaa ba nzaami átemene ŋa kara li mfwunu a baara bwohono áfwulu Yiisu ti: «We ka li a ndagha yi aabvuhulu o? Nki ndagha we lyele mu bumpughulu bu osuo baara ba mu we?» ");
INSERT INTO tyx_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yiisu ka átsughu ndagha o, nde ka ábvuhulu ndagha o. Mukwuru a bangaa ba nzaami áfirifwulu nde ti: «Me we li Kriste, Mwana a Nzaami wu Liseme?» ");
INSERT INTO tyx_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yiisu ábvuhulu ti: «Ngu me. Ya be sa limono Mwana a mbwuru ábwi-nsini ku kwogho-a-kwogho ki Lileene li Nzaami, ya bu aakagya nde ya bidzi bi mayulu.» ");
INSERT INTO tyx_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mu obo, mukwuru a bangaa ba nzaami ákaghala binkuru bi ndeme ya ályele ndiri: «Bihi-a-be nzala a bampughulu liifirisyili a yo? ");
INSERT INTO tyx_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Be liigyughu bu aatsaala nde Nzaami. Bitsimi bi be bima?» Baara bwohono bágwi nde ebili ya bátsyiri nde mukakana wu lipfu. ");
INSERT INTO tyx_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ndaama a baara ŋa kara li bo bábaana otswulu nde manteẽ. Báfughu nde busu, bákakaha nde minkono ya bákalyele ti: Bighili! Ya bankyele bágyagha nde ya bákaha nde mampala. ");
INSERT INTO tyx_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mu matala ma óli Piere ku nsie, ŋa mbala, musala wu mukaha mumõ mu basala ba mukwuru a bangaa ba Nzaami áyato oŋo. ");
INSERT INTO tyx_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nde bu amono Piere mu okagyoro mbaa, átala nde ya ályele ti: «Wehe si aakakala ya Yiisu musi Nadzarete.» ");
INSERT INTO tyx_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piere átunu bu ályele ti: «Me ka nsoolo o, me ka ndi mu obaghala mi dzyi we olyele o.» Ŋa mbihi oŋo, nde ápala mu ogye ku nkulu a muŋma a nzo. Mu matala mamo, nsuhu ákwolo. ");
INSERT INTO tyx_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Musala wu mukaha ámono nde ya áfirilyele kundaa ba báli oŋo: «Wuhu si li mumõ mu bo.» ");
INSERT INTO tyx_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piere áfiritunu Yiisu. Bu basi mana edzighi ebi, ba báli oŋo báfirilyele Piere ti: «Mu engaŋma, we li mumõ mu baara ba, mu kuulu wehe si li musi Ngalile.» ");
INSERT INTO tyx_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Oŋo nde ábwi olaba mikihi mu okabiili mpwoho mu ndeme ti: «Me ka nsoolo mbwuru wu lili mu okalyele be o.» ");
INSERT INTO tyx_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yini a mu matala maana mamo, mulumu a nsuhu ákwolo mu sa lili muolo. Piere álibili mweẽ ndagha yi ólyele nde Yiisu: «Nsomo-a-nsomo nsuhu akwolo nsa ywolo, we sa tunu me nsa tere.» Mu obo Piere ágwubulu elili. ");
INSERT INTO tyx_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mu epala-epala, bakwuru ba bangaa ba nzaami, bákuru mfwunu ya bakwuru, baluo-mikyene ya ekwuru ki ba-Dzwife kyehene. Bu bamana okuru Yiisu binkana, bábiri nde ya bágwi nde kundaa Pilate. ");
INSERT INTO tyx_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate áfwulu nde ti: «We, we li mukogho a ba-Dzwife?» Yiisu ábvuhulu nde ti: «Me we lyele yo». ");
INSERT INTO tyx_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bakwuru ba bangaa ba nzaami báburulu nde mandagha malagha. ");
INSERT INTO tyx_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilate áfirifwulu nde ti: «We ka bvuhulu ndagha o? Yughu ati mandagha ma bali mu okaburulu we!» ");
INSERT INTO tyx_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lo Yiisu ka áfiribvuhulu ndagha o, obo Pilate ákiŋimi. ");
INSERT INTO tyx_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mu nswe kyiri kii Pake, Pilate ákapaha bo mbwuru mutsyini mu boloko, munde wu ókaluomo mpwumu a baara. ");
INSERT INTO tyx_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mbwuru mutsyini, wu a nkwumu Barabase, áli mu boloko ya banganda ba nde mu kuulu bo bádzwi mbwuru ŋa bákasa bo ngirini ya ba baakatumu bula. ");
INSERT INTO tyx_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mpwumu a baara yígyene ku nzo a Pilate ya yíbaana oluomo nde apaha bo mbwuru mutsyini mu boloko ti bu óli epfu e nde. ");
INSERT INTO tyx_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilate ábvuhulu bo ndiri: «Be lidzyi ti me nyaã be mukogho a ba-Dzwife?» ");
INSERT INTO tyx_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mu kuulu nde ásoolo ti mu nkooro a mukolo bubi bakwuru ba bangaa ba nzaami bátyeghe nde Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lo bakwuru ba bangaa ba nzaami bágwi mpwumu a baara mutswi mpini mu kuulu baluomo Pilate apaha bo Barabase. ");
INSERT INTO tyx_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate áfirilyele ti: «Emakye be lidzyi me nsa mu munde wu lili mu okata be ti mukogho a ba-Dzwife?» ");
INSERT INTO tyx_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bo báfirikehe bingubu ti: «Komo nde ŋa kuruwa!» ");
INSERT INTO tyx_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate ákalyele bo ndiri: «Bu nde nsa ndagha yi mbi aasi?» Lo bo báfirikehe bingubu bi biluru ti: «Komo nde ŋa kuruwa!» ");
INSERT INTO tyx_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate ágwolo munkaana wu ogwa mpwumu esee. Nde ányaã Barabase ya nde átumu bakaha Yiisu nswanswa. Ŋa mbihi oŋo nde ágwi bo nde mu kuulu bakomo nde ŋa kuruwa. ");
INSERT INTO tyx_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bambumbulu bábiri Yiisu ku kara-a-kara a mbala a nzo a Pilate ya bo báti mpwumu a bambumbulu yohono mbili. ");
INSERT INTO tyx_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bo bálaha Yiisu enkuru kii mungala, ya bátwulu ŋa yulu a mutswi a nde muburu wu mansiene. ");
INSERT INTO tyx_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ŋa mbihi oŋo, bo bábwi ogwa nde mboro ndiri: «Mukogho a ba-Dzwife, mboro a we!» ");
INSERT INTO tyx_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bo bákakaha nde edzyara ŋa yulu a mutswi, bákatswulu nde manteẽ ya bákakunu mabuo mu nsie mu obuono nde. ");
INSERT INTO tyx_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bu bamana osebe nde, bádzwulu nde enkuru kii mungala ya báfirilaha nde binkuru bi nde. Ŋa mbihi oŋo, bo bágyene a Yiisu mu oyikomo nde ŋa kuruwa. ");
INSERT INTO tyx_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bambumbulu bákwighi baghala mutsyini wu áafi ku manseghe ya áakaluru mu obiri kuruwa li nde. Nkwumu a nde Simõ, musi bvulu li Sirene, taara a Alesandere ya Rufuse. ");
INSERT INTO tyx_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bo bábiri Yiisu ku ebini ki bakata nkwumu «Ngolongota», mbaala ti, «Ebini kii etyee ki mutswi». ");
INSERT INTO tyx_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Básagha ogwa Yiisu bviini li bábvughu ya miire, lo nde ábihi oŋma lo. ");
INSERT INTO tyx_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bákomo Yiisu ŋa kuruwa ya bambumbulu bu bati empa kii nga a bwehe me wu aagwolo, mpaala bakaba binkuru bi nde . ");
INSERT INTO tyx_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mu tala lili matere ŋa mbihi a makya-mabwihi bo bákomo Yiisu ŋa kuruwa. ");
INSERT INTO tyx_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bisono bi bíli a ebili ki lipfu li nde bíli a ndagha yi: «Mukogho a ba-Dzwife.» ");
INSERT INTO tyx_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ebini emõ ya Yiisu bákomo ŋa kuruwa bantwumu buolo, mumõ ku kwogho-a-kwogho, wu muke ku engbambogho. ");
INSERT INTO tyx_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Obo me bu ótswughu bisono bi nzaami bi biikalyele ti: «Baasi nde mu muluo a baara ba babi.» ");
INSERT INTO tyx_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Baara ba bákaluru mu nzili bákatughu Yiisu ya bákanyihi mitswi. Bo bákalyele ti: «Eẽ! We wu aatsala nzo a nzaami ya ofiritwu yo mu bitsughu bitere, ");
INSERT INTO tyx_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","bvwuhu nyuru a we weme ya sughuru ŋa kuruwa!» ");
INSERT INTO tyx_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bakwuru ba bangaa ba nzaami si ya baluo-mikyene bákasebe bo-a-bo ya bákalyele ndiri: «Nde aabvwuhu babake, lo nde ka kughu obvwuhu ndeme o! ");
INSERT INTO tyx_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nyaã Kriste, Mukogho a Isarayele, asughuru ŋa kuruwa mu matala ma, mu kuulu bihi limono ya lisa kana!» Ba bákomo ŋa yulu a makuruwa ya nde bákatughu nde si. ");
INSERT INTO tyx_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mu matala ma ntaã a minsene, bwihi búsi mpyibi ŋa yulu a nsie yohono, tee mu matala mama matere ŋa mbihi a ntaã a minsene. ");
INSERT INTO tyx_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mu matala mamo, Yiisu ákehe engubu: «Eli, Eli, lema sabakatani?» Mbaala ti, «Nzaami a me, Nzaami a me, mu emakye we aanyaghala me?» ");
INSERT INTO tyx_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ndaama a baara ba báli oŋo bágyughu nde, bo bákalyele ti: «Ligyughu, nde li mu okata Eli mbili!» ");
INSERT INTO tyx_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mbwuru mumõ ábara ntyini mu oyitsubu munsana mu bviini lili ŋeẽ. Nde ákuru nde ku nto a edzyara mpaala agwa Yiisu aŋma ya ályele ndiri: «Linyaã, litswe limono kala ti Eli sa ayasurulu nde ŋa kuruwa.» ");
INSERT INTO tyx_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Lo Yiisu ákehe engubu ki enene ya átaghaba. ");
INSERT INTO tyx_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nkpaŋa eko yi a mu nzo a Nzaami yíkagha ŋa kara-a-kara, obaana ku yulu tee ku nsie. ");
INSERT INTO tyx_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mfumu a ekuru ki bambumbulu nkama (100) wu áali oŋo bu amono bu ótaghaba Yiisu ályele ndiri: «Ngaŋma baghala wu áli Mwana a Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Óli si a bakaha ba bákatala la-la. Ŋa kara li bo óli Mari musi bvulu lili Mangadala, Mari ngughu a Dzake wu mu Mumpala ya Dzodze, ya Salome. ");
INSERT INTO tyx_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bo bákabulugye ya Yiisu ya bakasalala nde ŋa áli nde ku Ngalile. Óli si a bakaha bakimi ba bayakumu ya Yiisu ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Áli ayi nkonkolo, ya buulu áli etsughu ki baakabwehẽ Sabate (etsughu ki eekatswama etsughu kii Sabate), ");
INSERT INTO tyx_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Dzodzefe wu a bvulu lili Arimate, mbwuru wu bákagwa budziri mu mfwunu a ekwuru ki ba-Dzwife, ágyi oko. Nde si ákakebe ogya ku Emfumu e Nzaami. Nde ási bukyini ágyene kundaa Pilate mu oluomo ebyimi e Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate ákiŋimi mu ogyughu ti Yiisu áli ayi ákpi. Mu obo nde áti mfumu a ekuru ki bambumbulu nkama (100) mbili, ya áfwulu nde kala ti Yiisu edzighi elagha ákpi. ");
INSERT INTO tyx_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mfumu a ekuru ki bambumbulu nkama (100) bu alyele nde ti Yiisu aakpi, Pilate ágwi Dzodzefe nzili yi ogwolo ebyimi e Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Dzodzefe áswumu embwunu ki eko kii lino ya ámaha ebyimi e Yiisu ŋa kuruwa, ádziŋi kye kunsa embwunu ki eko ekye, ya álo kye munsa mpyeme yi bátsimi kunsa limeẽ. Ŋa mbihi oŋo, nde ákyi muŋma a mpyeme mu limeẽ. ");
INSERT INTO tyx_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari musi Mangadala, ya Mari wu ngughu a Dzodze, bákatala ebini ki bádzyighi Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabate bu liluru, Mari musi Mangadala, Mari ngughu a Dzake, ya Salome báswumu malyimi mama mpihi yi mbwe mu osa mansagha mu ebyimi e Yiisu. ");
INSERT INTO tyx_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mu etsughu ki limiŋi kii nsomo, bo bágyene ku mpyeme epala-epala ŋa ookapala tala. ");
INSERT INTO tyx_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bo bákalyele bo-a-bo ti: «Nande aakimini bihi-a-be limeẽ li liikyi muŋma a mpyeme?» ");
INSERT INTO tyx_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Lo bu baseene mihi, bo bámono ti limeẽ li líli li linene, áli ayi bákimini. ");
INSERT INTO tyx_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bu basomo munsa mpyeme, bámono munkuru-mbala mumõ ábwi-nsini mu kwogho-a-kwogho e bo ya álaha enkuru ki ela ya kii buŋu. Bo bámono nzalamweẽ. ");
INSERT INTO tyx_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nde ályele bo ti: «Ka likala a nzalamweẽ o! Be Yiisu musi Nadzarete wu baakomo ŋa kuruwa lili mu okasagha. Nde aasighili ŋa kara li ba bákpi. Ka li ŋa o. Limono ebini ki ali baatwulu nde. ");
INSERT INTO tyx_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lo liyilyele binduono bi nde ya Piere ti: “Yiisu aatswama be ku Ngalile. Oko be liimono nde ti bu áli ályele nde be.”» ");
INSERT INTO tyx_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bo bápala munsa mpyeme, bábara mu okateghere, báli a nzalamweẽ ya bákiŋimi. Ya bo ka bályele ndagha si mõ kundaa mbwuru o mu kuulu bo báli a nzalamweẽ. ");
INSERT INTO tyx_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yiisu bu asighili mu lipfu mu epala ki etsughu ki limiŋi kii nsomo, nde átswama moŋono kundaa Mari musi Mangadala, mu nde Yiisu áli ápaha mifulu mi mibi nsaama. ");
INSERT INTO tyx_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mari áyitwoho nsia kundaa babo ba bákakala ya Yiisu mu matala ma báli bo kunsa pfiili ya bákalili. ");
INSERT INTO tyx_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ŋa bágyughu bo ti Yiisu áli mweẽ, ya ti Mari ámono nde, bo ka bási kana o. ");
INSERT INTO tyx_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ŋa mbihi oŋo, Yiisu ámoŋono mu efa ekimi kundaa binduono byele bi bíkagye ku bula. ");
INSERT INTO tyx_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Boho si báyabvughuru ya bágwi nsia kundaa binduono bibike. Lo binduono si ka bási bo kana o. ");
INSERT INTO tyx_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ŋa nseele, Yiisu ámoŋono kundaa Bakwumu ya Mumõ, mu matala ma bákadza bo, ya nde afyeẽ bo mu ebaghala mu kuulu bo ka bási kana o ya mikolo ngyi mi bo, mu kuulu bo ka bási kana mu ba bámono nde ŋa mbihi a ŋa ásighili nde ŋa kara li ba bákpi o. ");
INSERT INTO tyx_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ŋa masini, nde ályele bo ndiri: «Ligye mu nsie nsyini ya litsala nsia a Nsia yi Mbwe kundaa baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Munde wu akala aasa kana ya aabagha liboghoro sa abvwughu, lo munde wu akala aagwene osa kana sa abagha ebili. ");
INSERT INTO tyx_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bi me bilyimi bibi okiŋimi bi akala biimoŋono kundaa babo ba akala baasa kana: Mu nkwumu a me, bo sa babyi mifulu mi mibi, bo sa babili mandiŋi ma manyaghara. ");
INSERT INTO tyx_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bo sa bakwara bantaala, kala ti bo baŋmi mbagha, si okala ka bunu, bo ka bamono mpara o. Bo sa batwulu myaã ŋa yulu a babyele, ya babyele sa badzughu.» ");
INSERT INTO tyx_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mfumu Yiisu, bu amana obili kundaa bo, bágyene a nde ku yulu ya nde ábwi-nsini ku kwogho-a-kwogho e Nzaami. ");
INSERT INTO tyx_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ya binduono bíyitsala nsia yi mbwe mu bibini byehene. Mfumu ákasala ya bo ya akasa enyeme mu Ndagha mu bilyimi bibi okiŋimi bi bíkanama.");
INSERT INTO tyx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ta Teofile, baara balagha baagyeele osono mandagha ma máluru ŋa kara li bihi-a-be. ");
INSERT INTO tyx_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bo básono mo bwunu a bu ólyele bihi bampughulu ba bámono mandagha mamo obaana mu ebaana, ya ba bágwi litumu lili oluo mandagha ma Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Me mu obo, mehe si aansagha ogyighili ogyahaba mandagha mwohono ma máluru obaana ku ebaana, ya me aamono ti me mfaana osono mo ya bunkere. ");
INSERT INTO tyx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Me ndi mu osa obo mu kuulu we baghala engaŋma ki mandagha ma báluo we. ");
INSERT INTO tyx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mu matala ma óli Erode mukogho wu a etsulu e nsie kii Yude, óli ya ngaa a Nzaami mutsyini nkwumu a nde Dzakari. Nde áli mumõ ŋa kara li emvuŋunu ki bangaa ba Nzaami baba dzumu li Abiya. Ya Elidzabete mukala a nde áli musi dzumu li Aarõ. ");
INSERT INTO tyx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bo bansa buolo báli baara baba bunsumu ŋa busu bu Nzaami, ya bo bákagyighili onama mikyene ya mikele mi Mfumu myehene. ");
INSERT INTO tyx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lo bo ka báli a mwana o, mu kuulu Elidzabete áli etini, ya bo bansa buolo áli ayi biŋmini. ");
INSERT INTO tyx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Etsughu etsyini, Dzakari ákasala esala ki bungaa bu Nzaami munsa nzo a Nzaami yi nene mu kuulu bibye bíli bitsughu bibi mukubu a emvuŋunu e bo mu osala. ");
INSERT INTO tyx_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ti bu óli epfu ki bangaa ba Nzaami, bo báti empa ki nga-a-bwehe ya básuolo Dzakari mu osomo mu ngwumu a Mfumu yi a ngili mu oyitsughu malyimi mama mpihi yi mbwe. ");
INSERT INTO tyx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mpwumu a baara yohono yíli ku mbala mu okasamana, mu matala mama otsughu malyimi mama mpihi yi mbwe ");
INSERT INTO tyx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ngye-yulu a Mfumu ayamoŋono kundaa Dzakari, ya atemene mu kwogho kii babaghala, ŋa bele a ebini ki baakatsughu malyimi mama mpihi yi mbwe. ");
INSERT INTO tyx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Bu amono ngye-yulu munde, nde ápaŋama ya ámono nzalamweẽ. ");
INSERT INTO tyx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lo ngye-yulu ályele kundaa nde ti: «Dzakari ka amono nzalamweẽ o! Nzaami aagyughu lisamana li we. Mukala a we Elidzabete sa aburu we mwana wu baghala. We sa gwa nde nkwumu Dzã. ");
INSERT INTO tyx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","We sa kala kunsa esee ki elagha ya baara balagha sa baŋene mu oburu o nde, ");
INSERT INTO tyx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","mu kuulu nde sa akala mbwuru wu munene ŋa busu bu Mfumu. Nde akala ka aŋma bviini bwunu we mala ma maakolo o. Nde sa akala wu alwulu mu Mufulu a Ngili obaana matala ma aakala nde munsa mweẽ a ngughu a nde. ");
INSERT INTO tyx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nde sa abvurulu basi Isarayele balagha kundaa Mfumu, Nzaami a bo. ");
INSERT INTO tyx_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nde sa atswama ku nkulu, ŋa busu bu Nzaami, mu mufulu ya mu lileene li Eli. Mu obo nde sa abvurulu eyeŋẽ ŋa kara li bataara ya baana ba bo, ya osa kuulu ti babo ba baagwene okagyughu Nzaami babagha munzeele wu a baara banga-a-bunsumu. Obo nde sa asa kuulu ti baara bakala a dzyi li likughu mu okihi Mfumu.» ");
INSERT INTO tyx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mu obo Dzakari ályele kundaa ngye-yulu ti: «Bunu-abo me aangyahaba ti mandagha mamo sa matswighi? Buulu me ayi eŋmini ya mukala a me si maaŋmini.» ");
INSERT INTO tyx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ngye-yulu ábvuhulu kundaa nde ti: «Me ndi Ngabiryele, me ndi ŋa busu bu Nzaami mu osalala nde. Nde aatumu me mu oyabili ya we, ya oyagwa we Nsia yi Mbwe yi. ");
INSERT INTO tyx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Buulu we aabihi osa kana mu mi aandyele me we, we sa kala nkini ya we ka afiritsughu ndagha o tee matala ma ootswughu mandagha ma. Mandagha ma sa mamoŋono mu matala ma ógwaa Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mu matala mamo mpwumu a baara yíkakebe Dzakari yíkiŋimi mu kuulu nde ákagyili munsa nzo yi a ngili. ");
INSERT INTO tyx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bu ayapala, nde ka áfirikaleene obili ya bo o, ya bo bábaghala ti nde ndagha ábwana a yo munsa nzo yi a ngili. Nde ákabili ya bo mu bilyimi ya ákala nkini. ");
INSERT INTO tyx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bitsughu bi nde bibi esala bu bikughu, Dzakari ábvughuru ku nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ŋa mbihi oŋo, Elidzabete mukala a nde ákeghele. Mu obo nde ási bangoono bataana baala nde ásweme. Nde ákabili bu: ");
INSERT INTO tyx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Litala ndagha yi oosi Mfumu mu me! Nde aamono ti ma matala ma omaha me budzwa ŋa mihi mi baara bwohono.» ");
INSERT INTO tyx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ŋa óto yimi li Elidzabete mu bangoono basemene, Nzaami ágweghe Ngye-yulu Ngabiryele ku bvulu lili Nadzarete mu etsulu e nsie kii Ngalile, ");
INSERT INTO tyx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kundaa mutughu mutsyini wu ógwi Dzodzefe, musi dzumu li mukogho Dabvide bilyimi. Nkwumu a nde Mari. ");
INSERT INTO tyx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ngye-yulu bu asomo munsa nzo a nde, ályele kundaa nde ti: «Kala ya esee, we li a bwehe, Mfumu li ya we!» ");
INSERT INTO tyx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari ákiŋimi ku olagha bu agyughu mandagha mamo. Nde ka ábaghala bunu-a-bo mboro oyo yíkadzyi olyele o. ");
INSERT INTO tyx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ngye-yulu ályele kundaa nde ti: «Mari, ka mono nzalamweẽ o, mu kuulu we aabagha bwehe kundaa Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","We sa keghele ya we sa buru mwana wu baghala, we sa gwa nde nkwumu Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nde sa akala mbwuru wu munene ya sa bata nde Mwana a Nzaami wu a Ensoõ-Yulu. Nzaami sa agwa nde likubu li Dabvide, nkagha-kwuru a nde. ");
INSERT INTO tyx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nde sa akala mfumu a dzumu li Dzakobe mu mibvu ya mibvu. Emfumu e nde ka ekala a masini o.» ");
INSERT INTO tyx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari áfwulu kundaa ngye-yulu ti: «Me nkini aangyahaba babaghala o. Bunu-abo ndagha oyo yikughu okala?» ");
INSERT INTO tyx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ngye-yulu ábvuhulu kundaa nde ti: «Mufulu a Ngili sa agya mu we ya mpaana a Nzaami wu a Ensoõ-Yulu sa yifughu we ti edzwunu. Me mu obo mwana wu akala aaburu we sa akala wu a ngili, ya sa bata nde Mwana a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ya mono, Elidzabete, musi dzumu li we edzi-dzighi sa aburu si mwana wu baghala munsa buŋmini bu nde, nde wuulu baara baakalyele ti nde li etini, mu li yimi li nde ayi bangoono basemene, ");
INSERT INTO tyx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","buulu, Nzaami ka aakakuono a ndagha o.» ");
INSERT INTO tyx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ya Mari ályele ti: «Me ndi musala a Mfumu, nyaã myehene mikala kundaa me ti bwunu a bu lyele we.» Ŋa mbihi oŋo ngye-yulu ábulusihi nde. ");
INSERT INTO tyx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mu bitsughu bibye, Mari ágyene mu maswa-maswa ku bvulu limõ lili etsulu e nsie kii minguo mimi Yude. ");
INSERT INTO tyx_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Bu ato oko, nde ásomo munsa nzo a Dzakari ya ágwi Elidzabete mboro. ");
INSERT INTO tyx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ŋa ogyughu Elidzabete mboro yi ógwi nde Mari, mwana a nde ányiŋi munsa mweẽ. Elidzabete álwulu mu Mufulu a Ngili, ");
INSERT INTO tyx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ya ákehe engubu mu likyi lili mpini ti: «Mu bakaha bwohono, Nzaami aabvulu oseme we, ya liseme li nde lili mu mwana wu aaburu we! ");
INSERT INTO tyx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Me nande ndi mu kuulu ngughu a Mfumu a me agya kundaa me? ");
INSERT INTO tyx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mu matala ma aangyughu me mboro a we, mwana aanyiŋi mu esee munsa mweẽ a me. ");
INSERT INTO tyx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Esee kundaa munde wu si kana ti mandagha ma oolyele Mfumu mu nde, sa makeele.» ");
INSERT INTO tyx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mu obo Mari ályele ti: «Endwu e me esyighi Mfumu. ");
INSERT INTO tyx_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ya mukolo a me aalwulu mu esee mu nkooro a Nzaami, mubvwuhu a me. ");
INSERT INTO tyx_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mu engaŋma mu kuulu nde aakaala mihi mi nde kundaa me musala a nde wu gwene a mupfunu. Obaana mu matala ma, biseene byehene sa bilyele ti me nga-a-esee, ");
INSERT INTO tyx_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mu kuulu Nzaami nga a Lileene aagyighili mandagha ma manene kundaa me. Nkwumu a nde yili yi a ngili. ");
INSERT INTO tyx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nde aakamono babo ba baakagwa nde budziri nyiĩ mu biseene ya biseene. ");
INSERT INTO tyx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nde aasala mu mpini a myaã mi nde, litumu li kwogho e nde ya aatsala baara ba bali a limpampana. ");
INSERT INTO tyx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nde aamaha mikogho mu bimfumu, ya akuhubu baara ba bagwene a limpampana. ");
INSERT INTO tyx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nde aaluhu bupfulu bulagha kundaa babo ba bali a nzala, ya aabvurulu bisini myaã-a-myaã. ");
INSERT INTO tyx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nde aayabaha baara ba Isarayele basala ba nde, ya nde aalibili mweẽ mu osuo ngebe a nde, ");
INSERT INTO tyx_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Bwunu a bu ályele nde kundaa bataara ba bihi, mu nkooro a Abarahame ya dzumu li nde mu matala nswe matala.» ");
INSERT INTO tyx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari ási ku bele a bangoono batere mu nzo a Elidzabete. Ŋa mbihi oŋo, nde ábvughuru ku bula bu nde. ");
INSERT INTO tyx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Matala ma ooburu Elidzabete máto, ya nde áburu mwana wu baghala. ");
INSERT INTO tyx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Baara ba báli bitaa-taa bibye ya basi dzumu li nde bagyughu nsia yi a bubwe ba ósi nde Mfumu. Mu obo bákala mu esee ya nde. ");
INSERT INTO tyx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mwana bu akuhu bitsughu mpuomo, bo bágyi mu osohobo nde nzo a mbaa. Baara bwohono bákadzyi ogwa nde nkwumu a taara a nde Dzakari. ");
INSERT INTO tyx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Lo ngughu a nde ályele ti: «Pele, sa bagwa nde kwumu Dzã.» ");
INSERT INTO tyx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bo bályele nde ti: «Mu dzumu li we ka oli ya nkwumu oyo o.» ");
INSERT INTO tyx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mu obo bafwulu Dzakari mu bilyimi nsa nkwumu nde adzyi ogwa mwana a nde. ");
INSERT INTO tyx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dzakari bu aluomo mana baya, ásono: «Nkwumu a nde Dzã.» Baara bwohono bákiŋimi. ");
INSERT INTO tyx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ya ŋaana oŋo, Dzakari áleene ofiribili ya nde ábwi oseme Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mu obo, baara bwohono ba báli bitaa-taa bibye bámono nzalamweẽ, ya mu etsulu e nsie kii minguo mimi Yude, baara bákabulubili mu mandagha mo mwohono mamo. ");
INSERT INTO tyx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Baara bwohono ba bákagyughu ndagha oyo bákatsimi ya bákagwa bifwulu kunsa mukolo ti: «Mwana wu nande àakala? Mu engaŋma, Mfumu li ya nde.» ");
INSERT INTO tyx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Dzakari, taara a mwana, áli alwulu mu Mufulu a Ngili ya ábighili mandagha ma: ");
INSERT INTO tyx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Nyaã masyighi makala kundaa Mfumu, Nzaami a Isarayele, mu kuulu nde aayabaha baara ba nde ya okwulu bo. ");
INSERT INTO tyx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nde aagwi bihi Mubvwuhu wu a mpini ŋa kara li bateghele ba mukogho Dabvide, musala a nde. ");
INSERT INTO tyx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ti bu átswama olyele nde mu matala ma makulu mu miŋma mi mibighili mi nde mimi ngili. ");
INSERT INTO tyx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nde ali ágwi misiini ti sa ákwulu bihi-a-be ŋa myaã mi bataara ya ŋa myaã mi babo bwohono ba baakabele bihi-a-be. ");
INSERT INTO tyx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Me mu obo nde aamono bankagha ba bihi nyiĩ ya aalibili ogwihini o nde kuu ngili mweẽ. ");
INSERT INTO tyx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mu engaŋma Nzaami áli álaba mukihi kundaa Abarahame, nkagha a bihi-a-be, ");
INSERT INTO tyx_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ti sa akwulu bihi-a-be ŋa myaã mi bataara mpaala lisalala nde ku ogwene a nzalamweẽ. ");
INSERT INTO tyx_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mu kuulu bihi likala baba bungili ya baba bunsumu ŋa mihi mi nde, mu bitsughu byehene bibi bumweẽ bu bihi. ");
INSERT INTO tyx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ya we, mwana a me, we sa kala mubighili a Wu a Nkara Yulu, mu kuulu we sa dzyara ŋa nkulu a Mfumu mu obwehẽ nzili a nde. ");
INSERT INTO tyx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ya mu osuo kundaa baara ba nde bunu-a-bo bakughu obvwughu bu babagha kolokolo a masumu ma bo. ");
INSERT INTO tyx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mu nkooro a mukolo wu a nyiĩ wu a Nzaami a bihi, otsyeme o nde sa osehene ŋa yulu a bihi, ti anga tala lili ku yulu, ");
INSERT INTO tyx_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","mu otsehebe babo ba bali kunsa mpyibi, ya kunsa edzwunu kii lipfu ya mu obiri myili mi bihi-a-be mu nzili yi a edzuunu.» ");
INSERT INTO tyx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwana ákakulu ya ákabagha mpini mu mufulu. Nde ákabulukala kunsa syehe tee mu matala ma áyapala nde ŋa busu bu basi Isarayele. ");
INSERT INTO tyx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mu bitsughu bibye, Sedzare Ongusute ágwi litumu bataã mutala a baara bwohono ba bali ku nsie a emfumu e Rome. ");
INSERT INTO tyx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Otaã mutala a baara oko kuu nsomo, bási ko mu matala ma óli Kirinyuse mfumu a etsulu e nsie kii Siiri. ");
INSERT INTO tyx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Baara bwohono bákayisono mankwumu ma bo, mbwuru mbwuru, mu bvulu li ndeme. ");
INSERT INTO tyx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Dzodzefe si ámara ku bvulu lili Nadzarete mu etsulu e nsie kii Ngalile ya ágyene ku Beteleeme, bvulu li báburu mukogho Dabvide mu etsulu e nsie kii Yude, mu kuulu nde áli musi dzumu li Dabvide. ");
INSERT INTO tyx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nde áyisono nkwumu a nde ya Mari, ndughu a nde wu ágwi nde bilyimi. Nde áli a yimi. ");
INSERT INTO tyx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ŋaala bo nkini ku Beteleeme matala ma oburu máto nde. ");
INSERT INTO tyx_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nde áburu mwana wu baghala, mwana a nde wu a nsomo. Ádzyiŋi nde kunsa misyene mi biko ya álaha nde ŋa ebini ki baakatwulu bilogho bi ookadza banyama, mu kuulu mu nzo yi baakabwana bandzyi, bo ka bábagha ebini ki baagyeŋeme o. ");
INSERT INTO tyx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mu etsulu e nsie ekye, óli a minkaala bibuolo mi míkaluhu mpyibi ku ebiri mu ókabulukebe bibuolo bi bo. ");
INSERT INTO tyx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ngye-yulu a Mfumu mutsyini ámoŋono ŋa nkulu a bo, ya otsyeme ku onene ófi kundaa Nzaami óyadzyi bo. Bo bámono nzalamweẽ yi alagha. ");
INSERT INTO tyx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Lo ngye-yulu ályele kundaa bo ti: «Ka likala a nzalamweẽ o, mu kuulu me aayandyele be mukyene wu mubwe, wu akala aagwa etswumu e be kyehene esee ki elagha. ");
INSERT INTO tyx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lolo li, mu bvulu lili Dabvide, baaburu mu nkooro a be, mubvwuhu. Nde me Kriste, Mfumu. ");
INSERT INTO tyx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ki me elyimi ki liigyahaba be nde: Sa limono mwana wu badzyiŋi kunsa mipa mi biko ya baalaha nde ŋa ebini ki ookadza banyama.» ");
INSERT INTO tyx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ŋaana oŋo mu ensihibi, mpwumu a bangye-yulu baba mikaã mi bambumbulu baba mayulu, yíyabvuŋunu ya ngye-yulu munde. Ya bo bábwi osyighi Nzaami ti: ");
INSERT INTO tyx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Nsia kundaa Nzaami mu ensoõ-yulu, ya edzuunu ŋa nsie, kundaa baara ba adzyi nde.» ");
INSERT INTO tyx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bangye-yulu bu bábulusihi bo mu obvughuru ku yulu, minkaala bibuolo míbili bo-a-bo: «Litswe ku Beteleeme, mpaala liyitala mandagha ma maabwi, ma oolyele bihi-a-be Mfumu.» ");
INSERT INTO tyx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ya bo bágyene maswa-maswa ya bámono Mari, Dzodzefe ya emwa-mwana ki bálaha munsa ebini ki ookadza banyama. ");
INSERT INTO tyx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bu bamono nde, bo bályele mandagha mamo ma bályele kundaa bo mu nkooro a mwana munde. ");
INSERT INTO tyx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bo bwohono ba bágyughu mandagha ma ólyele minkaala bibuolo bákiŋimi ku olagha. ");
INSERT INTO tyx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari ákabunu mandagha mo mwohono ma ya ákatsimi mo munsa mukolo a nde. ");
INSERT INTO tyx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ya minkaala bibuolo, míbvughuru, mikabulusyighi Nzaami ya ogwa nde baana, mu myehene mi bágyughu ya bámono bo, mu kuulu myehene míli bwunu a bu ólyele bo ngye-yulu. ");
INSERT INTO tyx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bitsughu mpuomo bu bikughu, matala mama osohobo mwana nzo a mbaa máto, bágwi nde nkwumu Yiisu, yi ólyele ngye-yulu, nsomo ngughu a nde akeghele. ");
INSERT INTO tyx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Bitsughu bibi otsehebe nyuru bu bikughu, bwunu a bu ókatumu Mikyene mi Moyidze, bo bágyene a mwana ku Nzo a nzaami ku Yerusaleme mu osuo nde kundaa Mfumu. ");
INSERT INTO tyx_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bwunu a bu básono mu Mikyene mi Mfumu ti: Nswe mwana wu a nsomo wu baghala wu baaburu sa bagwaghala nde kundaa Mfumu. ");
INSERT INTO tyx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ya bo bágwi ekaba, bwunu a bu ókalyele Mikyene mi Mfumu, bidzu-dzughu byele, bwunu we mabeeme mwolo, maala nkini ka maayele o . ");
INSERT INTO tyx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ku Yerusaleme áli oli ya baghala mutsyini nkwumu a nde áli Simeõ. Nde áli mbwuru wu bunsumu ya wu aakagwa Nzaami budziri, wu áakakebe obuono o Isarayele, ya Mufulu a Ngili áli ŋa yulu a nde. ");
INSERT INTO tyx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mufulu a Ngili ályele kundaa nde ti nde ka kpa o tee ku aamono nde Kriste Mfumu. ");
INSERT INTO tyx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mu obo, Mufulu a Ngili ágyene a nde ku Nzo a nzaami, mu matala ma óyasomo taara ya ngughu a emwa-mwana e bo Yiisu mu Nzo a nzaami, mu osa mimye mi ókatumu Mikyene mu nkooro a nde, ");
INSERT INTO tyx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeõ ágwolo mwana, ásyighi Nzaami ya ályele ti: ");
INSERT INTO tyx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Mfumu, mu matala ma, nyaã musala e we agye mu edzuunu, ti bu áli alyele we. ");
INSERT INTO tyx_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mu kuulu mihi mi me miimono obvwughu o we, ");
INSERT INTO tyx_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ku átswama ogyighili we ŋa busu bu baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Oko me otsyeme ku akala oosuo omoŋono kundaa bikaana, ya nsia kundaa baara ba we, Isarayele.» ");
INSERT INTO tyx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Taara ya ngughu a Yiisu bákiŋimi bu bagyughu mi ókalyele Simeõ mu nde. ");
INSERT INTO tyx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeõ áseme bo, ya ályele kundaa Mari, ngughu a Yiisu ti: «Mono, mwana wu li ŋa mu nkooro a obwa ya otemene kuu baara balagha mu Isarayele, ya mu okala elyimi kiili baara balagha akala baagwene odzyi kye. ");
INSERT INTO tyx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nde sa asuo mansweghe ma mali kunsa kara li mikolo mi baara balagha. Mu mi mitala weme, lipee sa litobolo we mukolo, mpaala mi ookatsimi baara balagha kunsa mikolo, baara basoolo mye.» ");
INSERT INTO tyx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Óli si mubighili wu mukaha, nkwumu a nde Ane, mwana a Fanwele, mu dzumu lili Asere. Nde áli ayi eŋmini, ya bamvulu yini a nsaama ási ku bala. ");
INSERT INTO tyx_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ŋa mbihi oŋo, nde ásomo bupfiili, tee ŋa áto nde bamvulu makwumu-mpuomo ya bana (84). Nde ka ákagye la ya Nzo a nzaami o. Nde ákasalala Nzaami mpyibi ya mwiĩ, mu okakuru muswele mu bala ya mu okasamana. ");
INSERT INTO tyx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mu matala maana mamo, nde si áli oŋo, mu okabvurulu matuono kundaa Nzaami, ya mu okabulubili mu mwana munde, kundaa bo bwohono ba bákakebe okwulu o Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Dzodzefe ya Mari bu bamana ogyighili myehene mi ookatumu Mikyene mi Mfumu, bo bábvughuru ku bvulu li bo ku Nadzarete, mu etsulu e nsie kii Ngalile. ");
INSERT INTO tyx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Emwa-mwana ékakulu ya ékabagha mpini, ékalwulu mu bunsughu ya bwehe bu Nzaami búli mu kye. ");
INSERT INTO tyx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nswe mvulu, taara ya ngughu a Yiisu bákagye ku Yerusaleme ku kyiri kii Paake. ");
INSERT INTO tyx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yiisu bu ato bamvulu kwumu ya buolo (12), nde ágyene ya bo, bwunu a bu óli epfu e kyiri. ");
INSERT INTO tyx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bitsughu bi kyiri bu bifi, mu matala ma bákabvughuru bo, mwana Yiisu ábulusyili ku Yerusaleme, kuulu taara ya ngughu osoolo we. ");
INSERT INTO tyx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bo bákatsimi ti nde áli munsa mpwumu. Bu badzyara etsughu etsyini mu nzili, ya babaana okabulusagha nde kundaa basi dzumu li bo, ya kundaa ba basoolo bo. ");
INSERT INTO tyx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Lo, bu bagwene omono nde, bo bábvughuru ku Yerusaleme mu okabulusagha nde. ");
INSERT INTO tyx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bitsughu bitere bu bikughu, bo báyabagha nde mu Nzo a Nzaami, ábwi nsini ŋa kara-a-kara li baluo-mikyene, mu okagyughu bo ya mu okagwa bo bifwulu. ");
INSERT INTO tyx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Baara bwohono ba bákagyughu nde bákakiŋimi mu mayele ma nde, ya mu mamvuru ma nde. ");
INSERT INTO tyx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Taara ya ngughu bu bamono nde, bákiŋimi, ya ngughu a nde ályele kundaa nde ti: «Mwana a me, mu emakye we aasi bihi bu? Mono ati, me ya taara a we liikpi mu okabulusagha we.» ");
INSERT INTO tyx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Lo nde ábvuhulu kundaa bo ti: «Mu emakye be lili mu okabulusagha me? Bunu, be ka ligyahaba o ti me mfaana okanama mandagha ma Taara a me?» ");
INSERT INTO tyx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lo bo ka bábaghala ndagha yi ályele nde kundaa bo o. ");
INSERT INTO tyx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ŋa nseele, nde ákumunu ya bo ku Nadzarete. Nde ákagyughu taara ya ngughu a nde. Ya ngughu a nde ákagyighili okebe mandagha mwohono mamo munsa mukolo a nde. ");
INSERT INTO tyx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ya Yiisu ákakulu mu bunsughu, mu nyuru ya mu bwehe ŋa nkulu a Nzaami ya ŋa nkulu a baara. ");
INSERT INTO tyx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mu mvulu wu a kwumu ya bataana (15) wu a emfumu kii Tibere Sedzare mukogho wu a nsie yi a Rome, Ponse Pilate áli mfumu wu a etsulu e nsie kii Yude, Erode mfumu wu a etsulu e nsie kii Ngalile, Filipe mwana a taara a nde mfumu wu a etsulu e nsie kii Iture ya kii Tarakonitide, ya Lisanyase áli mfumu wu a etsulu e nsie kii Abilene. ");
INSERT INTO tyx_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ane ya Kayife báli bakwuru ba bangaa ba nzaami baba nsomo. Me mu matala mamo Nzaami ályele mandagha ma nde kundaa Dzã, mwana a Dzakari, ku syehe. ");
INSERT INTO tyx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Dzã ákadzye mu etsulu e nsie ki eli be-bele a mwele wu a Dzurudẽ. Nde ákabuluta mukwughu wu: «Ligyiŋi mayele, libagha oboghoro kuu ogyiŋi mayele mu kolokolo a masumu.» ");
INSERT INTO tyx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ti bu básono mu mukaana a mubighili Edzayi ti: «Likyi li munde wu li mu okakehe engumbu ku syehe: Ligyighili nzili a Mfumu, lisa mankwulu ma nde makala nsumu! ");
INSERT INTO tyx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nswe mbye sa badzyighi yo Nswe munguo ya nswe nkwighi sa bakirili bye bipere, Mafuru ma manzili sa basa mo nsumu, Manzili ma mali bikumu-bikumu sa basa mo elehe ");
INSERT INTO tyx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ya baara bwohono sa bamono obvwughu o Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nde ákalyele kundaa mpwumu a baara yi áakagya kundaa nde mu oyaboghoro ndiri: «Etswumu kii bampili! Nande aasuo be bu obara nkehe a Nzaami yi li mu ogya? ");
INSERT INTO tyx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mu obo, lisuo bigyighili bi bifaana ya ogyiŋi mayele, ya ka libaana okabululyele mu beme o ti: “Taara a bihi Abarahame”, buulu me ndyele ti: mu mameẽ ma, Nzaami kughu otehebe baana kundaa Abarahame! ");
INSERT INTO tyx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ekwu ayi bamaatwulu ŋa yulu a midza mi muti: nswe muti wu gwene oburu bimburu bi bibwe, lo nde wu okpaa ya wu otsili ku mbaa.» ");
INSERT INTO tyx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mpwumu a baara yífwulu nde ti: «Lo bihi emakye lifaana osa?» ");
INSERT INTO tyx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nde ábvuhulu kundaa bo ti: «Munde wu li a binkuru byele, agwa etsyini kundaa munde wu gwene a kye, ya munde wu li a bi-odza, asa bumõ si.» ");
INSERT INTO tyx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mintolo-mpagha si mígyi mpaala baboghoro bo, ya bályele kundaa nde ti: «Muluo, bihi emakye lifaana osa?» ");
INSERT INTO tyx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nde ábvuhulu kundaa bo ti: «Ŋa liikatolo mpagha, ka likaluhu mutala wu bátumu o.» ");
INSERT INTO tyx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bambumbulu si báfwulu nde ti: «Lo bihi emakye lifaana osa?» Nde ályele kundaa bo ti: «Ka ligwohono kii mbwuru mu mpini o, ya ka lipfiri mpya o, lo liikakala a esee mu mufuru wu a ndaa-beme. Ya likala a esee mu nzi yi baakafiri be mu ngoono.» ");
INSERT INTO tyx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Baara bákabulukebe ya bákabulugwa bifwulu kunsa mikolo mi bo mu nkooro a Dzã, ti ampe nde me Kriste. ");
INSERT INTO tyx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mu obo Dzã ábvuhulu kundaa bo bwohono ti: «Me ndi mu okaboghoro be mu madza, lo munde wu bvulu me mu mpini li mu ogya. Munde wu bvulu me, ya me ka nkughu onyana musyi a bikoghoro bi nde o. Nde sa aboghoro be mu Mufulu a Ngili ya mu mbaa. ");
INSERT INTO tyx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nde aakwara mukele mu kwogho e nde mu okabala bimburu ya nsele. Nde sa akwu bimburu kunsa etaghala e nde, lo nde sa atsughu nsele ku mbaa yi aagwene okadzimi.» ");
INSERT INTO tyx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mu maluo ma malagha mama ogwa mpama, Dzã ákabulutsala Nsia yi Mbwe kundaa baara. ");
INSERT INTO tyx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lo Dzã áfyeẽ Erode, mfumu a etsulu e nsie, mu nkooro a Erodyade, mukala a mbwee a nde, ya mu mandagha mwohono ma mabi ma ási nde. ");
INSERT INTO tyx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ŋa yulu a mandagha mwohono, Erode ásyimi Dzã ya álo nde mu boloko. ");
INSERT INTO tyx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bu bamana oboghoro baara bwohono, Yiisu si báboghoro nde. Mu matala ma ákabuono nde, yulu lídzubulu, ");
INSERT INTO tyx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ya Mufulu a Ngili áyasughuru ŋa yulu a nde mu efaana kii beeme, ya ndagha yídzumu mu yulu: «We li mwana a me wu mukolo, me aankamono esee mu we.» ");
INSERT INTO tyx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yiisu áli a bamvulu bele makwumu-matere (30) ŋa ábaana nde esala e nde. Nde áli bwunu a bu ókabulutsimi baara ti mwana a Dzodzefe, wu áali mwana a Eli, ");
INSERT INTO tyx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Mwana a Matate, mwana a Lebvi, mwana a Meleki, mwana a Yanayi, mwana a Dzodzefe, ");
INSERT INTO tyx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mwana a Matatyase, mwana a Amose, mwana a Nawume, mwana a Eseli, mwana a Nangayi, ");
INSERT INTO tyx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nangayi mwana a Maate, Maate mwana a Matatyase, Matatyase mwana a Semeyi, Semeyi mwana a Yoseke, Yoseke mwana a Yoda, ");
INSERT INTO tyx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda mwana a Dzãanane, Yowanane mwana a Resa, Resa mwana a Dzorobabele, Dzorobabele mwana a Salatyele, Salatyele mwana a Neri, ");
INSERT INTO tyx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mwana a Meleki, Meleki mwana a Adi, Adi mwana a Kosame, Kosame mwana a Elemadame, Elemadame mwana a Ere, ");
INSERT INTO tyx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere mwana a Yiisu, Yiisu mwana Elyedzere, Elyedzere mwana a Yorime, Yorime mwana a Matate, Matate mwana a Lebvi, ");
INSERT INTO tyx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lebvi mwana a Simeõ, Simeõ mwana a Yuda, Yuda mwana a Dzodzefe, Dzodzefe mwana a Yoname, Yoname mwana a Elyakime, ");
INSERT INTO tyx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakime mwana a Meleya, Meleya mwana a Mena, Mena mwana a Matata, Matata mwana a Natã, Natã mwana a Dabvide, ");
INSERT INTO tyx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dabvide mwana a Dzese, Dzese mwana a Obede, Obede mwana a Boadze, Boadze mwana a Sala, Sala mwana a Naasõ, ");
INSERT INTO tyx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasõ mwana a Aminadabe, Aminadabe mwana a Adimine, Adimine mwana a Arani, Arani mwana a Eserõ, Eserõ mwana a Farese, Farese mwana a Yuda, ");
INSERT INTO tyx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda mwana a Dzakobe, Dzakobe mwana a Idzake, Idzake mwana a Abarahame, Abarahame mwana a Tera, Tera mwana a Nahore, ");
INSERT INTO tyx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahore mwana a Seruke, Seruke mwana a Rangawu, Rangawu mwana a Faleke, Faleke mwana a Ebere, Ebere mwana a Sala, ");
INSERT INTO tyx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala mwana a Kayiname, Kayiname mwana a Arafakade, Arafakade mwana a Seme, Seme mwana a Nowe, Nowe mwana a Lameke, ");
INSERT INTO tyx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameke mwana a Matusaleme, Matusaleme mwana a Enoke, Enoke mwana a Yarede, Yarede mwana a Maleleele, Maleleele mwana a Kename, ");
INSERT INTO tyx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kename mwana a Enose, Enose mwana a Sete. Sete mwana a Adã, Adã mwana a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mu matala ma ófi Yiisu ku Dzurudẽ, nde áli alwulu mu Mufulu a Ngili, ya Mufulu a Ngili biri nde ku syehe. ");
INSERT INTO tyx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mu bitsughu makwumu-mana (40) Satana ágyeele nde. Nde ka ali áli elogho si etsyini o. Ŋa bihi a bitsughu bi bye, nzala yifuru nde. ");
INSERT INTO tyx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satana lyele kundaa nde ti: «Kala ti we li mwana a Nzaami, lyele kundaa limeẽ li likighiri limpa.» ");
INSERT INTO tyx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yiisu bvuhulu kundaa nde ti: «Basono bu, mbwuru ka li mweẽ mu yini a mampa o.» ");
INSERT INTO tyx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satana biri nde ku nkara a yulu, ya mu mana tala, suo nde bimfumu bi nsie byehene, ");
INSERT INTO tyx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ya lyele kundaa nde ndiri: «Me sa ngwa we litumu lwohono li, ya nsia a lo, mu kuulu kundaa me bágwi bye, ya me nkughu ogwa bye kundaa munde wu ndzyi me bye ogwa. ");
INSERT INTO tyx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kala ti we kunu mabuo ŋa nkulu a me, lo lwohono tumu likala lili we.» ");
INSERT INTO tyx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yiisu bvuhulu kundaa nde ti: «Basono bu: “Yini a ŋa nkulu a Mfumu Nzaami a we, we faana okunu mabuo ŋa nsie, ya yini a nde we faana osamana.”» ");
INSERT INTO tyx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ŋa nseele, Satana biri nde ku Yerusaleme, twulu nde ku yulu a nzo a Nzaami ya lyele nde ti: «Kala ti we li mwana a Nzaami, bwa ku nsie», ");
INSERT INTO tyx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","mu kuulu básono ti: «Nde sa awa litumu kundaa bangye-yulu ba nde mu nkooro a we, Mpaala bo bakebe we. ");
INSERT INTO tyx_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ya ti: Sa baseene we mu myaã, Mpaala kwulu e we enyaã okubu kya mu limeẽ.» ");
INSERT INTO tyx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yiisu bvuhulu kundaa nde ti: «Básono si ti: “Ka gyeele Mfumu Nzaami a we o”.» ");
INSERT INTO tyx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satana amana ogyeele Yiisu mu bifaana byehene, bulusihi nde mu mana matala. ");
INSERT INTO tyx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yiisu bvughuru ku Ngalile ya mpini a Mufulu a Ngili, ya nsia yitsaŋama mu etsulu e nsie kyehene mu nkooro a nde. ");
INSERT INTO tyx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nde ákabululuo mu manzo ma ba-Dzwife mama lisamana, ya baara bwohono bákasa nde nsia. ");
INSERT INTO tyx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yiisu bvughuru ku bvulu li Nadzarete ku ákulu nde. Mu etsughu kii Sabate, nde somo nzo a lisamana a ba-Dzwife ti bu óli epfu e nde. Nde temene mu otala mandagha ma Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ya bagwi nde mukaana wu a mubighili Edzayi. Bu adzubulu nde, mono ebini ki básono ti: ");
INSERT INTO tyx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Mufulu a Mfumu li mu me, Buulu nde aakili me maala, Mu ogye a Nsia yi Mbwe kundaa bawele. Nde aaweghe me Mu ota mukwughu wu okwulu kundaa ba bali mu manzo ma boloko, Ya kundaa binkpa-mihi ti sa bamono, Obvuhulu kunsa bumpoholo babo ba bali kunsa kimini. ");
INSERT INTO tyx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ota mukwughu mu mubvu wu a bwehe bu Mfumu.» ");
INSERT INTO tyx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bu adzyi mukaana, bvurulu nde kundaa esala ya bwi nsini. Bo bwohono ba báli munsa nzo a lisamana babwi okatala nde. ");
INSERT INTO tyx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Oŋo nde baana olyele kundaa bo ti: «Lolo li, bisono bi bi liigyughu be, biikeele.» ");
INSERT INTO tyx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Baara bwohono báli bampughulu mu nde, ya bákakiŋimi mu mandagha mama bwehe ma mákapala mu muŋma a nde, ya bákalyele ti: «Bunu, wu ka li mwana a Dzodzefe o?» ");
INSERT INTO tyx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nde lyele kundaa bo ti: «Me ngyahaba ti be sa lita me nkumu yi: “Ngaa, saha nyuru a weme.” Ya be sa lifirilyele me si ti: “Myehene mi liigyughu bihi mi aasi we ku Kaperenawume, yighili mye si mu etsulu e nsie e weme ki”.» ");
INSERT INTO tyx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ŋa mbihi oŋo, nde firilyele ti: «Mu engaŋma, me ndyele be ti: Ka oli a mubighili ti mumõ wu bákihi mu etsulu e nsie e ndeme. ");
INSERT INTO tyx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mu ngaŋma me ndyele kundaa be ti: Bapfiili ba bakaha báli balagha mu matala ma Eli mu Isarayele, ŋa odzughubu yulu mu bamvulu batere ya bangoono basemene, ya munzyala ágyi mu nsie nsyini. ");
INSERT INTO tyx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Lo ka bágweghe Eli kundaa mupfiili si mumo mu bo o, yini a ku Sarepeta, mu etsulu e nsie kii Sidõ, kundaa mupfiili wu mukaha wu áali omo bágweghe nde. ");
INSERT INTO tyx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Banga-a-buala si áli balagha mu Isarayele, mu matala mama mubighili Elidze, lo ka oli a si mumõ mu bo o wu bátsehebe, ŋa yulu a yini a Naamane musi Siri.» ");
INSERT INTO tyx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bo bwohono ba báli munsa nzo a lisamana bu bagyughu mandagha mamo, bakolo nkehe. ");
INSERT INTO tyx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Batemene, bapaha nde ku mbala a bvulu ya babiri nde ku bele a mbye yi a munguo wu bátwu bvulu, mpaala batsili nde munsa mbye. ");
INSERT INTO tyx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lo Yiisu ábululuru ŋa kara-a-kara li bo, ágyene o nde. ");
INSERT INTO tyx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ŋa mbihi oŋo, Yiisu ákumunu ku bvulu lili Kaperenawume mu etsulu e nsie Kii Ngalile. Oko nde ákaluo baara mu etsughu kii Sabate. ");
INSERT INTO tyx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Baara bákakiŋimi mu nduo-nduo yi ákaluo nde, mu kuulu nde ákaluo ti mbwuru wu li a litumu. ");
INSERT INTO tyx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mu nzo a lisamana óli ya baghala mutsyini wu áali a mufulu wu mubi. Nde ákehe engubu mu yulu ti: ");
INSERT INTO tyx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Aa! Nsa ndagha yili ŋa kara li bihi ya we, Yiisu musi Nadzarete? Bunu, we bu aagyi mu oyapfihili bihi? Me nsoolo we na nde li: We li wu a ngili wu oogweghe Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yiisu áfulu mufulu munde epama ya ályele ti: «Kuru muŋma a we, ya pala mu baghala wu!» Mufulu wu mubi ábwihi mbwuru munde mu nsie ŋa kara-a-kara li baara, ya ápala mu nde ku ogwene a omweẽ nde mpara. ");
INSERT INTO tyx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Baara bwohono bámono nzalamweẽ ya bákabili bo-a-bo ti: «Yi nki ndagha? Mbwuru li mu okabili mu litumu ya mu lileene kundaa mifulu mi mibi, ya mye mili mu okapala!» ");
INSERT INTO tyx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ya nsia yítsaŋama mu nkooro a nde mu etsulu e nsie kyehene. ");
INSERT INTO tyx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ŋa mbihi oŋo, Yiisu bu apala mu nzo a lisamana, yene ku nzo a Simõ. Oko, buko bu Simõ wu mukaha áli a mukaama wu a mpini. Baara basyama kundaa Yiisu mu nkooro a nde. ");
INSERT INTO tyx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Bu apfuŋumu ŋa bele a nde, Yiisu fulu mukaama epama ya mukaama pala mu nde. Ŋaana oŋo, mukaha munde, temene, bwi osalala bo. ");
INSERT INTO tyx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bwihi bu buyili, baara bwohono ba báli a mabyele mama mawa-mawa, bayabiri mo kundaa Yiisu. Nde naã bo myaã ya dzuhu bo. ");
INSERT INTO tyx_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mifulu mi mibi si mipala mu babyele balagha ya mu okabulukehe bingubu ti: «We me Mwana a Nzaami!» Lo Yiisu ákafulu mye bipama, ya ka ágwi mye muswa mu obili o, mu kuulu mye míyahaba ti nde me Kriste. ");
INSERT INTO tyx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bwihi bu buki, Yiisu bulupala mu bvulu ya yene ku syehe. Mpwumu a baara yibaana osagha nde tee bagyene ku áli nde. Bu bamono nde, bayeele osa myehene kuulu nde anyaã osihi bo. ");
INSERT INTO tyx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Lo nde lyele kundaa bo ti: «Me mfaana oyiluo si Nsia yi Mbwe yi a Emfumu e Nzaami ku mabvulu ma make, kuulu me mu obo baaweghe me.» ");
INSERT INTO tyx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Oŋo nde yene mu okabululuo mu manzo ma lisamana mu etsulu e nsie kii Yude. ");
INSERT INTO tyx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yiisu áli átemene mu mukogho a bana lili Ngenedzarete. Mpwumu a baara yíyasa nde mpiŋi mu ogyughu Ndagha a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nde ámono mabwara mwolo ma bátwulu ŋa yulu a nseghe mu mukogho a bana. Ka óli a mbwuru mumo o, mu kuulu bilebe-banswi bísughuru ya bíkaswagha nkoho a bo. ");
INSERT INTO tyx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yiisu ákumu mu bwara butsyini bu búli bu bundaa Simõ, ya áluomo kundaa nde ti: «Sehe eke mu kara a madza.» Ya nde ábwi nsini ya ábaana oluo mampwumu ma baara. ");
INSERT INTO tyx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bu amana obili, nde ályele kundaa Simõ ndiri: «Sehe a bwara ku oli madza yighi, ya litubu nkoho a be mu olebe banswi.» ");
INSERT INTO tyx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simõ ábvuhulu nde ti: «Muluo, bihi liimono mpara mu mpyibi yi nsyini, lo ka liibagha elogho o. Lo buulu we lyele, me likoho aafirintubu.» ");
INSERT INTO tyx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bu batubu likoho mu madza, bábagha banswi balagha, ya likoho li bo líbaana okagha. ");
INSERT INTO tyx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bo bákoro banganda ba bo ba báli mu bwara bubuke mu oyabaha bo. Bo bágyi ya báluhu mabwara mansa mwolo, kuulu mo mábaana odzyama. ");
INSERT INTO tyx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simõ Piere bu amono obo, ákunu mabuo mu nsie ŋa nkulu a Yiisu ya ályele ti: «Mfumu, mara o we ŋa bele a me, mu kuulu me ndi mbwuru nga-a-masumu.» ");
INSERT INTO tyx_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simõ, ya bwohono ba báli ya nde bámono nzalamweẽ mu bubi ba bágyighili bo. ");
INSERT INTO tyx_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Óli bumõ si kundaa Dzake ya Dzã, baana ba Nzebede, bambaala ba Simõ. Yiisu ályele kundaa Simõ ti: «Ka amono nzalamweẽ o! Obaana lolo li, we sa kala elebe kii baara.» ");
INSERT INTO tyx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bu bayabvughuru a mabwara ŋa yulu a nseghe, bo bábulusihi bilogho byehene ya bánama Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Etsughu nga-emõ, Yiisu áli mu bvulu litsyini. Omo óli ya baghala mutsyini wu áali a bubyele bu buala. Baghala munde bu amono Yiisu, ábwi busu mu nsie ŋa nkulu a nde, ya ábuono nde bu: «Mfumu, kala we dzyi, we kughu otsehebe me.» ");
INSERT INTO tyx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yiisu álabala kwogho, ábyeme nde ya ályele ti: «Me ndzyi, kala wu a tse-tse.» Ya ŋaana oŋo, buala bu nde búfi. ");
INSERT INTO tyx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ŋa mbihi oŋo, Yiisu átswi nde mukele wu: «Ka lyele kundaa mbwuru si mumõ o. Lo gye yimoŋono weme kundaa ngaa a nzaami, ya gwa ekaba kii otsyeme ki ótumu Moyidze, mpaala okala elyimi kii bumpughulu kundaa baara.» ");
INSERT INTO tyx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lo nsia a Yiisu yíbvulu otsaŋama mu nkooro a nde, ya mampwumu ma baara malagha mákagya mu ogyughu nde, ya mu kuulu madzughu mu mabyele ma bo. ");
INSERT INTO tyx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lo nde, nde ágyene ku syehe ku ákabuono. ");
INSERT INTO tyx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Etsughu etsyini, Yiisu bu ákaluo, ba-Faridzyẽ ya baluo-mikyene áli babwi nsini oŋo. Bo báfi mu mabvulu mwohono mama ku Ngalile, ku Yude ya bvulu lili Yerusaleme. Lileene li Mfumu li líli mu nde, límoŋono mu libughu. ");
INSERT INTO tyx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ya mono, baara bágyi a mbwuru mutsyini wu ópki binama ŋa yulu a mbughu. Bo basagha bu baasohobo nde munsa nzo, ya bu otwulu nde ŋa nkulu a Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Lo bo ka bábagha bu baasohobo nde o, mu nkooro a mpwumu a baara. Bo bákumu ku yulu a see li nzo lili eyala, bátobolo see, ya básurulu nde mu mbughu ŋa mihi mi baara bwohono ŋa nkulu a Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yiisu bu amono kana li bo, ályele kundaa baghala wu ópki binama ti: «Baghala, masumu ma we baasi mo kolokolo.» ");
INSERT INTO tyx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Oŋo, baluo-mikyene ya ba-Faridzyẽ bábaana otsimi ya bályele ti: «Mbwuru wu aatsaala Nzaami wu, nde nande ali? Nande kughu osa masumu kolokolo kala ka oli yini a Nzaami o?» ");
INSERT INTO tyx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yiisu bu abaghala bitsimi bi bo, ábvuhulu kundaa bo ti: «Mu emakye be lili a bitsimi bibye kunsa mikolo mi be? ");
INSERT INTO tyx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nki ndagha yi gwene a mpara, olyele ti: “Masumu ma we baasi mo kolokolo”, bwunu we: “Temene ya dzyara”»? ");
INSERT INTO tyx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mu kuulu be ligyahaba ti Mwana a mbwuru li a litumu lii osa masumu kolokolo ŋa yulu a nsie – Nde ályele kundaa mbwuru wu ókpi binama ti: «Temene, gwolo laba li we ya bvughuru ku nzo a we». ");
INSERT INTO tyx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ŋaana oŋo, mbwuru munde átemene ŋa mihi mi bwohono, ágwolo mbughu yi bálaha nde, ya ágyene ku nzo a nde, mu okabulusyighi Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Baara bwohono bákiŋimi ku olagha ya bákasyighi Nzaami. Bo báli a nzalamweẽ ya bákabili bu: «Lolo liimono ndagha yi okiŋimi.» ");
INSERT INTO tyx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ŋa mbihi oŋo, Yiisu ápala ya nde ámono muntolo-mpagha mutsyini wu ábwi nsini ŋa nzo a mpagha. Nkwumu a nde Lebvi. Yiisu ályele kundaa nde ti: «Nama me!» ");
INSERT INTO tyx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lebvi átemene, ábulusihi bilogho byehene, ya ánama nde. ");
INSERT INTO tyx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lebvi ási Yiisu kyiri ki enene mu nzo a nde. Mintolo-mpagha ya baara babake báli oŋo, ya bákadza emõ ya bo. ");
INSERT INTO tyx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ba-Faridzyẽ ya baluo-mikyene ba báli omo bákaŋuŋunu ya bályele kundaa binduono bi Yiisu bu: «Mu emakye be lili mu okadza ya oŋma emõ ya mintolo-mpagha ya banga-a-masumu?» ");
INSERT INTO tyx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yiisu ábvuhulu kundaa bo bu: «Ba bali nsiili ka bali a nzala a ngaa o, Lo babyele. ");
INSERT INTO tyx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Me ka aangyi mu oyata baba bunsumu mbili o, lo banga-a-masumu mpaala bagyiŋi mayele.» ");
INSERT INTO tyx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bo bályele kundaa nde ti: «Binduono bi Dzã biikakuru muswele mu bala matala mwohono ya biikabuono Nzaami, binduono bi ba-Faridzyẽ bumõ si. Lo bibi ndaa we yini a okadza ya okaŋma.» ");
INSERT INTO tyx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yiisu ábvuhulu bo ti: «Bunu, be likughu oluomo bandughu baba mulumu bakuru muswele mu bala, mu matala maala nde nkini li ya bo? ");
INSERT INTO tyx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lo bitsughu bili mu ogya, ya mbala-tsughu ŋa akala baamaha bo mulumu la ya bo, bo sa akala bakuru muswele mu bala.» ");
INSERT INTO tyx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yiisu áfirita bo nkumu yi: «Ka oli a mbwuru wu kughu okaghala mupa a eko mu enkuru ki enyaghara mu obaama enkuru ki ekulu o. Buulu, nde sa akaghala enkuru ki enyaghara, ya mupa enkuru wu aamaha nde mu kye, ka li nsihi ya enkuru ki ekulu o. ");
INSERT INTO tyx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Bumõ si, ka oli a mbwuru wu kughu oloŋono mala ma manyaghara mu nduru yi a mu ebaana kii nyama yi nkulu o, buulu mala ma manyaghara sa mabaala mamfulu. Lo mala sa matsaŋama ya mamfulu sa mabyi. ");
INSERT INTO tyx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lo, mala ma manyaghara okaloŋono mu manduru mama mu bibaana bi banyama ma manyaghara. ");
INSERT INTO tyx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ya ka oli a mbwuru o wu kughu osa nzala a mala ma manyaghara, kala ti nde maaŋma ma mayele. Buulu nde sa alyele ti: “Mala ma mayele mabvulu bubwe.”» ");
INSERT INTO tyx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ya mu etsughu etsyini kii Sabate, Yiisu ákaluru munsa manseghe mama bele. Binduono bi nde bíbwi okabuluka binsia bi mburu, bíkanyoõ ya bíkadza yo. ");
INSERT INTO tyx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ba-Faridzyẽ babake bályele bo ti: «Mu emakye be lili mu okasa mandagha maala ka bágwi muswa mu etsughu kii Sabate o?» ");
INSERT INTO tyx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yiisu ábvuhulu bo bu: «Be ka liikataã ndagha yi ósi Dabvide o, mu matala ma ófuru nde nzala, nde ya ba báli ya nde? ");
INSERT INTO tyx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bunu nde ásomo mu nzo a Nzaami, ágwolo mampa mama ekaba, áli mo ya ágwi si kundaa ba báli ya nde. Mampa mamo, bo ka báli a muswa mu odza mo o, ŋa yulu a yini a bangaa ba nzaami.» ");
INSERT INTO tyx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nde áfirilyele kundaa bo ti: «Mwana a mbwuru li mfumu a Sabate.» ");
INSERT INTO tyx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mu etsughu ekimi kii Sabate, Yiisu ásomo mu nzo a lisamana a ba-Dzwife, ya ábaana oluo. Óli a baghala mutsyini omo wu bágwolo kwogho. ");
INSERT INTO tyx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Baluo-mikyene ya ba-Faridzyẽ bákabulutala Yiisu mu omono kala ti nde kughu odzuhu mubyele mu etsughu kii Sabate, mpaala bo babagha ndagha yi baafwunu nde. ");
INSERT INTO tyx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lo Yiisu bu ágyahaba bitsimi bi bo, ályele kundaa baghala munde wu bágwolo kwogho ti: «Temene ya kala ŋa kara-a-kara ŋa.» Nde átemene ya ákala mu mukiri. ");
INSERT INTO tyx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yiisu ályele kundaa bo ti: «Me mfwulu kundaa be kala ti oli muswa mu ogyighili ma mabwe bwunu we ma mabi, mu obvwuhu bwunu we mu odzwa mbwuru mu etsughu kii Sabate?» ");
INSERT INTO tyx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yiisu átala ngulu ya ngulu, nde ályele kundaa baghala munde ti: «Labala kwogho e we!» Nde álabala kye, ya kwogho e nde ébvughuru bu éli nsomo. ");
INSERT INTO tyx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lo baluo-mikyene ya ba-Faridzyẽ bákolo nkehe yi alagha ya bákabili bo-a-bo, bunu-a-bo bakughu osa Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mu bitsughu bibye, Yiisu ágyene ku yulu a munguo mu oyisamana. Nde áluhu mpyibi yohono mu okasamana Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bwihi bu buki, nde áti binduono bi nde mbili, ya ásuolo kwumu ya byele (12), ya ágwi bye nkwumu yi bantumu. ");
INSERT INTO tyx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ma me mankwumu ma bo: Simõ, wu ágwi nde nkwumu yi a Piere, Andere mbwee a nde, Dzake, Dzã, Filipe, Baretelemi, ");
INSERT INTO tyx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matye, Toma, Dzake mwana a Alafe, Simõ wu baakata ti mu-Nzelote, ");
INSERT INTO tyx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana a Dzake, ya Yuda Isikaryote wu aatyeghe nde. ");
INSERT INTO tyx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Bu akumunu munguo emõ ya bo, Yiisu átemene ŋa epere, ŋa óli mpwumu yi nene yi a binduono bi nde, ya mpwumu yi nene yi a baara baba ku Yude lwohono, baba ku Yerusaleme, baba ku mukogho a mubu, baba Tire ya baba Sidõ. ");
INSERT INTO tyx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bo bwohono bágyi mu ogyughu nde ya mu kuulu nde adzuhu bo mu mabyele mabo. Babo ba ókamwehẽ mifulu mi mibi kimini badzughu. ");
INSERT INTO tyx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mpwumu a baara yohono yíkasagha obyeme nde mu kuulu lileene líkapala munde ya líkadzuhu bo bwohono. ");
INSERT INTO tyx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mu obo, Yiisu bu akaala mihi mi nde kundaa binduono bi nde, ályele ti: «Esee kundaa be bawele, Mu kuulu Emfumu e Nzaami eli Kii ndaa be. ");
INSERT INTO tyx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Esee kundaa be ba lili mu okpa nzala mu matala ma, mu kuulu be sa ligyughuru. Esee kundaa be ba lili mu okalili mu matala ma, mu kuulu be sa lisebe. ");
INSERT INTO tyx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Esee kundaa be, kala ti baara babele be, babihi be, batughu be ya balyele mandagha ma mabi mu be, mu nkooro a Mwana a mbwuru». ");
INSERT INTO tyx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","«Limono emiini mu etsughu ekye, ya likala kunsa muyayaã, mu kuulu embwaã e be eli ki enene mu yulu. Bwunu obo si bataara ba be bákasa kundaa mibighili.» ");
INSERT INTO tyx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Lo, nyiĩ kundaa be bisini, mu kuulu be limaabagha libuono li be! ");
INSERT INTO tyx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nyiĩ kundaa be ba lili kunsa bupfulu mu matala ma, mu kuulu mbala-tsughu be tumu likpa nzala. Nyiĩ kundaa be ba lili mu okasebe mu matala ma, etsughu eli ki liisomo be pfiili ya liilili. ");
INSERT INTO tyx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nyiĩ mu matala ma obili baara bwohono mu bubwe bu be, mu kuulu me obo si bataara ba be bákasa kundaa mibighili mimi mpya.» ");
INSERT INTO tyx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Lo kundaa be ba lili mu okagyughu me, me ndyele be ti: Liikadzyi mitaara mi be, liikasa bubwe kundaa ba baakabele be. ");
INSERT INTO tyx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Liikaseme babo ba baakabiili be bipwolo. Liikabuono Nzaami mu babo ba baakabuulu mpya mu be. ");
INSERT INTO tyx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kala ti mbwuru kaha we limpala mu tama, lo taama nde si tama lilike, ya kala ti nde gwohono we enkuru e we ki ela kii kobo, nyaã nde si agwolo enkuru kii mu ntulu. ");
INSERT INTO tyx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nswe munde wu aaluomo we elogho, lo gwa nde kye. Ya kala ti mbwuru gwohono elogho e we, ka firiluomo nde kye o. ");
INSERT INTO tyx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mandagha ma lidzyi be ti baara bagyighili be mo, behe si ligyighili bumõ kundaa bo. ");
INSERT INTO tyx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kala ti be okadzyi babo ba baakadzyi be, lo mu emakye baatuono be? Banga-a-masumu si ti baakadzyi babo ba baakadzyi bo! ");
INSERT INTO tyx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mu kuulu, kala ti be bubwe okasa kundaa babo ba baakasa be bubwe, lo mu emakye baatuono be? Banga-a-masumu si ti baakasa bumõ. ");
INSERT INTO tyx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kala ti be okasohobo kundaa babo ba lili a be bitsimi ti sa babvurulu, lo emakye baatuono be? Banga-a-masumu si ti baakasohobo kundaa banga-a-masumu, mpaala babvurulu bo bwunu obo si!» ");
INSERT INTO tyx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","«Lo be, liikadzyi mitaara mi be, liikasa bubwe, ya liikasohobo wene a okala a etsimi kiili ti sa babvurulu be. Mufuru a be sa akala wu munene, ya be sa likala baana ba Nzaami wu a Ensoõ-Yulu, mu kuulu nde li a mukolo mubwe kundaa ba baagwene okabvurulu matuono, ya kundaa banga-a-mukolo bubi. ");
INSERT INTO tyx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Liikakala ya mukolo wu a nyiĩ bwunu a bu oli a Taara a behe si mukolo wu a nyiĩ.» ");
INSERT INTO tyx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Ka likalamana banganda o, mpaala banyaã olamana behe si. Ka likabwihi banganda o, mpaala banyaã obwihi behe si. Lisa babake kolokolo, ya sa basa behe si kolokolo. ");
INSERT INTO tyx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Likakaba banganda, ya sa bakaba behe si. Sa batsogho bilogho bi biluru mu mankuru ma be, ya sa bakomo bye ku oluru. Mu kuulu, sa bakateese be mu eteese ekye ki liikateese be bambaala.» ");
INSERT INTO tyx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yiisu áfirita bo nkumu yi: «Enkpa-mihi ka ekughu osuo nganda enkpa-mihi nzili o. Kala pele, bo bansa buolo sa bayibwa munsa dzunu. ");
INSERT INTO tyx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Enduono ka eluru muluo a kye o, ya nkana si mumõ ka luru mfumu a nde o. Lo, nswe munde wu baaluo bubwe, nde sa akala ti muluo a nde. ");
INSERT INTO tyx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mu ema we li mu okatala mana lisele li lili mu lihi li nganda, ŋaala we li a mubaa a muti mu lihi li weme? ");
INSERT INTO tyx_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bwunu we bunu-a-bo we kughu olyele nganda ti: “Ngee a me, nyaã me maha we lisele mu lihi”, ŋaala we mubaa a muti wu li mu lihi li weme omono we? We li mbwuru wu a bifa byele. Matswama maha a ti mubaa a muti wu li mu lihi li we. Ŋa mbihi oŋo, we sa gyighili omono bubwe mu omaha lisele mu lihi li nganda.» ");
INSERT INTO tyx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Muti wu mubwe ka kughu oburu bimburu bi bibi o, ya muti wu mubi ka kughu oburu bimburu bi bibwe o. ");
INSERT INTO tyx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nswe muti okagyahaba mu bimburu bi nde. Ka bakughu oka finge mu munsene-a-nsene o, ya ka bakughu oka bimburu bi bviini mu mungaama o. ");
INSERT INTO tyx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mbwuru wu mubwe li a bitsimi bi bibwe mu mukolo a nde. Mbwuru wu mubi li a bitsimi bi bibi mu mukolo a nde. Mu engaŋma, muŋma a mbwuru okapaha mi milwulu kunsa mukolo a nde.» ");
INSERT INTO tyx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Mu emakye be liikata me “Mfumu, Mfumu”, lo be liigwene okagyighili mandagha ma aakandyele me be? ");
INSERT INTO tyx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Me sa nsuo be efaana ki mbwuru wu gyi kundaa me, gyughu mandagha ma me ya salala mo. ");
INSERT INTO tyx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nde li efaana kii baghala wu aatwu nzo. Nde tsimi miwaghala mi mila ya twu bitsini bi bibagha bi nzo ŋa yulu a limeẽ. Mvulu bu anoõ, ndwuru yigyi mu mwele ya madza mayisiŋi mu nzo oyo ya eturu kyehene, lo yo obwa we, mu buulu bágyighili otwu yo. ");
INSERT INTO tyx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lo munde wu gyughu mandagha ma me ya kuono osalala mo, nde li efaana kii baghala wu aatwu nzo mu yulu a dzyele, ku ogwene a bitsini bi bibagha. Mvulu bu anoõ, ndwuru yigyi mu mwele ya madza mayisiŋi mu nzo ya eturu kyehene, mabwihi nzo ya mabiri yo nkwu-nkwughu.» ");
INSERT INTO tyx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yiisu bu amana olyele mandagha mwohono mamo kundaa baara ba bákagyughu nde, nde ágyene ku Kaperenawume. ");
INSERT INTO tyx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Oko óli a mfumu a ekuru ki bambumbulu ba Rome nkama. Nde áli a musala wu ákadzyi nde ku olagha. Musala me ábyele ya ákadzwana ya lipfu. ");
INSERT INTO tyx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mfumu munde bu agyughu ti Yiisu aayato ŋa Kaperenawume, nde ágweghe ndaama a bakwuru ba ba-Dzwife bayilyele Yiisu ayabvwuhu nkana a nde. ");
INSERT INTO tyx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bo bágyene kundaa Yiisu ya bábuono nde ku olagha ti: «Wu aagweghe bihi li mbwuru wu mubwe ya we faana obaha nde, ");
INSERT INTO tyx_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Mu kuulu nde dzyi baara ba nsie a bihi-a-be, ya me nde aatwuhu bihi nzo a lisamana.» ");
INSERT INTO tyx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mu obo Yiisu ágyene ya bo. Nde ato ŋa bele a nzo a mfumu munde, mfumu a bambumbulu ágweghe ndaama a bandughu ba nde kundaa Yiisu mu olyele nde bu: «Mfumu, nyaã omono oko mpara yi ogya ku nzo a me! Me ka nkughu mu ogyagha we munsa nzo a me o. ");
INSERT INTO tyx_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Me obo me aamono si ti me ka mfaana oyabwana a we o. Lo tsughu yini a ndagha, ya musala a me sa adzughu. ");
INSERT INTO tyx_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Me ndi mu litumu li bamfumu ba me, ya meme si ndi a bambumbulu ba aakantumu me. Kala me ndyele mutsyini ti: “Gye!” Nde sa agye. Kala me ndyele wu muke ndiri: “Gya!” Nde sa agya. Kala me ndyele musala a me ti: “Sa bu!” Nde sa asa obo.» ");
INSERT INTO tyx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yiisu ayughu obo, nde ákiŋimi. Nde ákaghala kundaa baara ba báyanama nde, ya ályele bo ti: «Mu engaŋma, me ndyele kundaa be, ngu okala mu Isarayele, me nkini amaamono mbwuru wu li a kana li linene lili bu o.» ");
INSERT INTO tyx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bandughu ba mfumu a bambumbulu bábvughuru kundaa nde ya bámono musala wu áali mubyele ádzughu. ");
INSERT INTO tyx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ŋa mbihi oŋo, Yiisu ágyene ku bvulu lili Nayine. Binduono bi nde ya mpwumu a baara yi nene bágyene ya nde. ");
INSERT INTO tyx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mu matala ma ákasomo nde kunsa bvulu, nde ámono ebyimi ki bákayidzyighi ku mampyeme: Mwana nga mumõ wu a baghala mu mweẽ ngughu a nde, ya ngughu a nde áli mupfiili. Mpwumu a baara baba bvulu lilo báli ya mupfiili. ");
INSERT INTO tyx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mfumu bu amono mupfiili munde, nde ámono nyiĩ yi alagha. Mu obo nde ályele kundaa nde ti: «Ka lili o!» ");
INSERT INTO tyx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bu asele, Yiisu ábyeme lwana ya baara ba bákabiri lo bátemene. Nde átsughu ndagha ti: «Munkuru-mbala, me bu ndyele we, temene!» ");
INSERT INTO tyx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mvwumu ásighili, ábwi nsini ya ábaana obili. Yiisu ágwi nde kundaa maama a nde. ");
INSERT INTO tyx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Baara bámono nzalamweẽ. Bo básyighi Nzaami ya bákalyele ti: «Nzaami aagweghe bihi mubighili wu munene!» Ya báfiribwehe ti: «Nzaami aayamoŋono kundaa baara ba nde!» ");
INSERT INTO tyx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mu obo nsia a Yiisu yítsaŋama mu etsulu e nsie kii Yude kyehene, ya mu bitsulu bi nsie bi bili be-bele a Yude. ");
INSERT INTO tyx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Binduono bi Dzã Muboghoro bílyele nde mandagha mwohono mamo. Mu obo, nde áti binduono bi nde byele mbili ");
INSERT INTO tyx_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ya ágweghe bye kundaa Yiisu mu ofwulu nde ti: «We me mbwuru wu liikakyele, bwunu we mukimi liikyele?» ");
INSERT INTO tyx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bo bato kundaa Yiisu bályele nde bu: «Dzã gweghe bihi mu ofwulu we, “kala we me mbwuru wu liikakyele, bwunu we mukimi liikyele?”» ");
INSERT INTO tyx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mu matala maana mamo, Yiisu ádzuhu babyele balagha, ya ba báli a mpara yi a mawa-mawa. Nde ábyi mifulu mi mibi mi míli ya bo, ya ádzubulu mihi mi babo ba áli ókpi mihi. ");
INSERT INTO tyx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ŋa mbihi oŋo, nde ályele kundaa baara ba ógweghe Dzã ti: «Ligye lilyele kundaa Dzã myehene mi liimono ya mi liigyughu be» «Binkpa-mihi bili mu omono, bikara bili mu odzyara, bangaa buala ayi tse-tse, Binkpa-matswi bili mu ogyughu, Ba bakpi bali mu osighili mu lipfu, ya bawele bali mu ogyughu Nsia yi Mbwe. ");
INSERT INTO tyx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Esee kundaa munde wu aagwene obwihi kana li nde mu nkooro a me!» ");
INSERT INTO tyx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ŋa bihi a ŋa óbvughuru baara ba ógweghe Dzã, Yiisu ábaana obili mu nyuru a Dzã kundaa mpwumu a baara. Nde ályele bo ti: «Emakye be liiyitala ku syehe? Libaŋana li okanyihi efulu? ");
INSERT INTO tyx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bu lo be emakye liiyitala? Mbwuru wu aalaha binkuru bibi ntala? Lo, ba baakalaha binkuru bibi ntala ya ba bali kunsa busini okakala mu manzo ma mikogho. ");
INSERT INTO tyx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lo emakye be liiyitala? Mubighili? Heẽ, me ndi mu olyele be, nde bvulu mubighili». ");
INSERT INTO tyx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mu kuulu Dzã me munde Bisono biikalyele ti: «Me sa ntswahaba ntumu a me ku nkulu a we. Mu ogyighili we nzili.» ");
INSERT INTO tyx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","«Me ndyele be bu: Ŋa kara li baara bwohono ba báburu mu bakaha, ka oli ya mbwuru wu bvulu Dzã o. Lo munde wu bvulu nde busala mu Emfumu e Nzaami bvulu nde bukwuru. ");
INSERT INTO tyx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ya baara bwohono ba bagyughu nde, ya mintolo-mpagha, bo bábaghala ti Nzaami li wu a bunsumu, ya bákihi ti Dzã aboghoro bo. ");
INSERT INTO tyx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lo ba-Faridzyẽ ya Baluo-mikyene bu babihi mi okadzyi Nzaami osa mu bo, bábihi ti Dzã aboghoro bo.» ");
INSERT INTO tyx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yiisu áfirilyele ti: «Ya na me aambvughu baara baba eseene ki? Bo efaana kii na bali? ");
INSERT INTO tyx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bo bafaana ya bike-bike bi biibwi nsini ŋa ebini ki ookabvuŋunu baara bwohono, ya bali mu okalyele mu yulu kundaa babake ti: “Bihi liifulu mamvulu-a-mvulu, lo be ka liikini o! Bihi liigyimi bikwumu bibi minyoõ, lo be ka liilili o.”» ");
INSERT INTO tyx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","«Dzã Muboghoro aagyi, nde ka ákadza mampa ya ka ákaŋma mala o. Mu obo, be liilyele ti: “Nde li a mufulu wu mubi.” ");
INSERT INTO tyx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana a mbwuru aagyi. Nde li mu okadza ya okaŋma, ya be lili mu okalyele ti: “Mbwuru wu ki agyahaba nde yini a odza ya oŋma mala. Nde li mbaala a mintolo-mpagha ya banga-a-masumu.” ");
INSERT INTO tyx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Lo bunsughu bu Nzaami buumoŋono bubu bunsumu kundaa baana ba nde.» ");
INSERT INTO tyx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mu-Faridzyẽ mutsyini áti Yiisu mbili mu oyidza ya nde, ya Yiisu ágyene ku nzo a nde ya ábwi nsini mu odza. ");
INSERT INTO tyx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ŋa bula bubo óli a mukaha mutsyini nga-a-masumu. Ŋa ágyughu nde ti Yiisu ákadza mu nzo a Mu-Faridzyẽ munde, nde áli a mbwara yi alwulu mu mananaase. ");
INSERT INTO tyx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nde ágyene ŋa myili mi Yiisu, ábaana olili ya ábwoho myili mi Yiisu mu mansaŋa ma nde. Ŋa mbihi oŋo, nde akakwono mye mu mfu a nde. Nde ákanyuburu myili mi Yiisu, ya ákagyogho mye mananaase. ");
INSERT INTO tyx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mu-Faridzyẽ wu áati Yiisu mbili amono obo, nde ábili kunsa mukolo a nde ti: «Kala ti mbwuru wu mubighili ali, mu engaŋma, nkini nde aagyahaba ti mukaha wu li mbwuru nga-a-masumu.» ");
INSERT INTO tyx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ŋa mbihi oŋo, Yiisu ályele kundaa mu-Faridzyẽ munde ti: «Simõ, me ndi a ndagha yi aandyele we.» Simõ ábvuhulu nde ti: «Bili o we Muluo!» ");
INSERT INTO tyx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yiisu átsughu ndagha ndiri: «Baara buolo áli basomo nzi kundaa wu aakasohobo nzi. Mutsyini mipara nkama, ya wu muke mipara makwumu mataana. ");
INSERT INTO tyx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Buulu bo bansa buolo ka báleene ofiri ebyimi ekye o, nde ányaghala bo ebyimi kyehene. Mu we, ŋa kara li bo buolo, nande aabvulu dzyi nde?» ");
INSERT INTO tyx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simõ ábvuhulu nde bu: «Mu bitsimi bibi me, munde wu ányaghala nde ebyimi ki eluru olagha.» Yiisu ályele nde ti: «We aabili ku bwe.» ");
INSERT INTO tyx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ŋa nseele, nde bu akaghala mihi kundaa mukaha munde, ályele kundaa Simõ ti: «We aamono mukaha wu? Me aayansomo mu nzo a we ya we ka aagwi me madza ma oswagha myili o. Lo nde aabwoho me mye mu mansaŋa ma nde, ya aakwono mye mu mfu a nde. ");
INSERT INTO tyx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","We ka aanyuburu me o, lo, obaana bu aayansomo me mu, nde ka aakolo mu okanyuburu myili mi me o. ");
INSERT INTO tyx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","We ka aagyirili me maala ku yulu a mutswi o, lo nde aagyirili mananaase mu myili mi me. ");
INSERT INTO tyx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Me mu obo, me ndi mu olyele we ti: Buulu nde aasuo dzyi li lilagha, mu olyele ti Nzaami aasi masumu ma nde ma malagha kolokolo. Lo munde wu baasi masumu ma nde ma masala kolokolo aakasuo si dzyi li lisala.» ");
INSERT INTO tyx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ŋa mbihi oŋo, Yiisu ályele kundaa mukaha munde ndiri: «Masumu ma we baasi mo kolokolo.» ");
INSERT INTO tyx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Baara ba bákadza ya Yiisu bábwi okabili mu bomo ti: «Mbwuru wu nande ali mu osa masumu ma baara kolokolo?» ");
INSERT INTO tyx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Lo Yiisu ályele mukaha munde ndiri: «Kana li we liibvwuhu we. Gye mu edzuunu.» ");
INSERT INTO tyx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ŋa mbihi oŋo, Yiisu ágyene mu mabvulu ya mala mu okabulutsala nsia yi a Emfumu e Nzaami ya okabululuo. Bantumu ba nde kwumu a buolo (12) bákakala ya nde emõ ");
INSERT INTO tyx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ya ndaama a bakaha ba ádzuhu ya ba ábyi nde mifulu mi mibi mu bo. Óli Mari wu baakata ti musi Mangadala, wu óbyi Yiisu mifulu nsaama mi mibi, ");
INSERT INTO tyx_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Dzaane mukala a Syudza wu ali musala a Erode, Sudzane ya bakaha balagha bakimi. Bo bwohono bákasalala bilogho bi bo mu obaha Yiisu ya binduono bi nde. ");
INSERT INTO tyx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mu obo mpwumu a baara yi nene yígyi kundaa Yiisu, ya nde áti bo nkumu yi: ");
INSERT INTO tyx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Etsughu etsyini, mbwuru mutsyini ágyene ku manseghe mu oyinyahala mburu. Mu matala ma ákabulunyahala nde yo, ndaama yíbwi mu mukogho a nzili. Baara bádzyara yo ya baŋmini báli yo. ");
INSERT INTO tyx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ndaama yinke yíbwi mu nsie yi a mameẽ. Bu yilughubu, yo yíkee mu kuulu oŋo nsie ka yíli a madza o. ");
INSERT INTO tyx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ndaama yinke yíbwi mu nsie yi áli a mingaama. Mingaama bu mílughubu, míkulu emõ ya mburu oyo, mísi mburu mpiŋi. Yo yíkwono okulu. ");
INSERT INTO tyx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ndaama yinke yíbwi mu nsie yi mbwe. Yo yíkulu, yíkulu, ya nswe liburu líburu mburu nkama.» Bu amana obili obo, Yiisu áfiribili mu mpini ti: «Nyaã wu li a matswi, agyughu!» ");
INSERT INTO tyx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ŋa mbihi oŋo, binduono bi Yiisu bífwulu nde ti nkumu oyo bunu-a-bo yidzyi olyele. ");
INSERT INTO tyx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nde ágwi bo mvuru yi: «Nzaami aasuo kundaa be mansweghe ma Empu e Nzaami. Lo kundaa baara babake, myehene okaluru mu mankumu, mu kuulu, “si bapana mihi, banyaã omono. Si bagyughu, banyaã obaghala.”» ");
INSERT INTO tyx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Nkumu oyo bu yidzyi olyele: mburu me Ndagha a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Baara ba báli mu mukogho a nzili, me baara ba baakagyughu Ndagha a Nzaami, ŋa mbihi dyabulu gyi yamaha yo mu mikolo mi bo mu kuulu banyaã osa kana, ya banyaã obvwughu. ");
INSERT INTO tyx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Baara ba bali mu nsie yi a mameẽ yi obwi mburu, me babo baala bu bagyughu Ndagha a Nzaami, bakihi yo ya esee. Lo ka bali a midza o. Bo baakasa kana mu mana a matala. Ŋa ookagya bigyeele, bo baakabwa. ");
INSERT INTO tyx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ndaama yi aakabwa ŋa kara li mingaama, me babo baala bu bagyughu Ndagha a Nzaami, bagyene ya banyaã minyoõ ya bisee bi nsie bisi yo mpiŋi, ya bimburu bi yo ka biikakulu o. ");
INSERT INTO tyx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mburu yi aakabwa mu nsie yi mbwe, me baara babo baala bu bagyughu Ndagha a Nzaami, bakebe yo mu mukolo wu a bunsumu ya wu mubwe, ya baakakwara yo ya baakaburu bimburu ya mukama.» ");
INSERT INTO tyx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Ka oli ya mbwuru wu aakanahaba mwindi mu ofughu nde nkuru o, bwunu we mu otwulu nde ku nsini a mbughu. Lo mu otwulu nde ŋa yulu a ebini ki baakatwulu nde, mu kuulu baara ba baasomo mu nzo bamono otsyeme. ");
INSERT INTO tyx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mandagha mwohono ma másweme sa magyighili omoŋono, ya mansweghe mwohono sa bagyighili ogyahaba mo ya opaha mo ku mbala. ");
INSERT INTO tyx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mu obo, lisa mayele mu ngyu-ngyughu a be! Mu kuulu sa babwehe elogho kundaa munde wu li a kye, lo kundaa munde wu aagwene a elogho o, sa bamaha ki aakatsimi nde ti li a kye.» ");
INSERT INTO tyx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ŋa mbihi oŋo, ngughu ya bambwee ba Yiisu báyatala nde, lo bo ka báleene oto ŋa áli nde o mu nkooro a mpwumu a baara. ");
INSERT INTO tyx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mbwuru mutsyini ályele nde ndiri: «Ngughu ya bambwee ba we bali ku mbala. Bo bali ya nzala a we.» ");
INSERT INTO tyx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lo Yiisu ágwi bo mvuru yi: «Ngughu a me ya bambwee ba me, me babo ba baakagyughu Ndagha a Nzaami, ya ba baakasalala yo.» ");
INSERT INTO tyx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Etsughu etsyini, Yiisu ásomo munsa bwara ya binduono bi nde, ya ályele bo ti: «Litswe lisaghaba mu ngulu a mubu.» Mu obo, bo bágyene. ");
INSERT INTO tyx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bu bákadzughu bwara, Yiisu ábwi tolo. Mu matala maana mamo, efulu kii mpini ébaana osa mu yulu a madza ma bana, ya bwara búbaana olwulu mu madza. Mu obo, lipfu lígyele bo. ");
INSERT INTO tyx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Binduono bísiili Yiisu ya bílyele nde ti: «Mfumu! Mfumu! Bihi-a-be lifi ekulu!» Yiisu bu asighili, áfyeẽ efulu ya mimpaŋa mi madza mu mpini. Efulu éfi ya edzuunu éyabvughuru. ");
INSERT INTO tyx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ŋa mbihi oŋo nde áfwulu bo ndiri: «Kana li be kunu lili?» Enkwughu ésughuru bo ya bákiŋimi. Bo bábili bo-a-bo ti: «Wu nsa mbwuru wu aakatumu efulu ya madza, ya bye biikagyughu nde?» ");
INSERT INTO tyx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yiisu ya binduono bi nde bápala mu ngulu a bana ya básomo mu etsulu e nsie kii ba-Ngerasenyeẽ, ki eli nkolo ya nkolo ya Ngalile. ");
INSERT INTO tyx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ŋa ópala Yiisu munsa bwara, baghala mutsyini wu áali musi bvulu áyabwana a nde. Baghala munde áli a mifulu mi mibi. Edzighi nde áli átsili binkuru. Nde ka áli a nzo o, lo kunsa mampyeme ákabulugyoŋomo. ");
INSERT INTO tyx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bu amono Yiisu, nde ákehe mungili, ákunu mabuo ŋa nkulu a nde, ya ályele mu mpini yohono ti: «Nsa ndagha yili ŋa kara li me ya we Yiisu Mwana a Nzaami Wu Ensoõ-Yulu? Yoboo, ka mwehẽ me mpara o!» ");
INSERT INTO tyx_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nde ábili obo mu kuulu Yiisu ákalyele mufulu wu mubi ndiri: «We, mufulu wu mubi, pala mu baghala wu!» Nsa alagha mufulu ákasomo mu nde, ya bákakuru nde myaã mu bukolo ya bákatwulu nde myili munsa edzu, lo nde ákatsyiri bye. Mufulu wu mubi ákabulubiri nde kunsa syehe. ");
INSERT INTO tyx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yiisu áfwulu nde ndiri: «Nkwumu a we na?» Nde ábvuhulu ndiri: «Mpwumu». Mu kuulu mifulu mi mibi milagha míisomo mu nde. ");
INSERT INTO tyx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mifulu mi mibi míbuono Yiisu bu: «Ka tumu bihi ligye ku nsini a mbie yi a nda yi a laŋa-laŋa o.» ");
INSERT INTO tyx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ŋa bele oŋo óli a mukaã a bangubulu wu munene wu áakabuludza ŋa yulu a munguo. Mifulu mi mibi míbuono Yiisu agwa bo muswa wu oyisomo mu bangubulu. Nde ágwi bo muswa munde. ");
INSERT INTO tyx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mu obo, mifulu mípala mu baghala munde, míyisomo mu bangubulu. Bangubulu bwohono bákumunu ku nsini a munguo, báyibwa mu bana ya báfi ekulu. ");
INSERT INTO tyx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Baara ba bákabulukebe bo bámono mi miluru. Mu obo bo bábara ya báyitsala nsia yi a ndagha oyo kunsa bvulu ya mu mala. ");
INSERT INTO tyx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Baara báyatala mi míluru. Ŋa báyato bo ku óli Yiisu, bámono baghala wu áali a mifulu mi mibi ábwi nsini ŋa myili mi Yiisu. Nde álaha ku obwe ya embwuru éyabvughuru nde. Nzalamweẽ yíbagha bo. ");
INSERT INTO tyx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Baara ba bámono mi miluru balyele bo bunu-a-bo baghala munde ábvwughu. ");
INSERT INTO tyx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ŋa mbihi oŋo baara bwohono ba báli mu etsulu e nsie kii ba-Ngerasenyeẽ bályele Yiisu ndiri: «Mara mu nsie a bihi!» Bo bályele obo mu kuulu báli a nzalamweẽ yi alagha. Mu obo Yiisu si ásomo mu bwara ya ágyene. ");
INSERT INTO tyx_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Baghala wu áali a mifulu mi mibi áluomo Yiisu muswa wu okala ya nde. Lo Yiisu ábihi ya ályele nde ti: ");
INSERT INTO tyx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Bvughuru ku nzo a we, ya yilyele baara mandagha mwohono ma oogyighili Nzaami mu we.» Nde ágyene ya átsala nsia munsa bvulu lwohono yi a mi ósi Yiisu mu nde. ");
INSERT INTO tyx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ŋa óyabvughuru Yiisu mu ngulu a bana, mpwumu a baara yíbwana a nde mu kuulu bo bwohono bákakebe nde. ");
INSERT INTO tyx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ŋa mbihi oŋo, mukwuru mutsyini wu a nzo a lisamana yi a ba-Dzwife áyato. Nkwumu a nde áli Dzayiruse. Nde ákunu mabuo mu nsie ŋa nkulu a Yiisu ya ábuono nde agye ku nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nde áli a mwana wu mukaha mumõ wu a mvulu kwumu ya ywolo (12). Nde ákadzwana ya lipfu. Yiisu bu ákagye, mpwumu a baara yínama nde ya yísi nde mpiŋi. ");
INSERT INTO tyx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ŋa nsa mpwumu a baara oyo óli a mukaha mutsyini. Nde áli a ebyele kii okapala makili ki ési mvulu kwumu ya ywolo (12). Nde ámana nzi a nde yohono kundaa bangaa-libughu, lo mbwuru si mumõ ka ási ti nde amono bubwe o. ");
INSERT INTO tyx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bu agyi ku mbihi a Yiisu, ábyeme mubele a enkuru e nde ya makili másaakaŋama. ");
INSERT INTO tyx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mu obo Yiisu áfwulu ndiri: «Nande byeme me?» Baara bwohono bátunu ya Piere ályele ti: «Mfumu, we li mu omono ti mpwumu a baara yiidzyi we ya yili mu osa we mpiŋi.» ");
INSERT INTO tyx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lo Yiisu ályele bu: «Mbwuru aabyeme me, mu kuulu me mono ti mpini yiipala mu nyuru a me.» ");
INSERT INTO tyx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ŋa ómono mukaha munde ti Yiisu agyahaba ndagha oyo, nde áyabwa ŋa myili mi Yiisu ya enkwughu kyehene. Ŋa mbihi oŋo, nde ályele ŋa mihi mi baara bwohono mu emakye nde aabyeme enkuru e Yiisu, ya bu aadzughu nde mu matala maana mamo. ");
INSERT INTO tyx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yiisu ályele kundaa nde ndiri: «Ma mwana, kana li we liibvwuhu we. Gye mu edzuunu!» ");
INSERT INTO tyx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ŋaala Yiisu nkini mu okabili, mbwuru mutsyini wu áafi ku nzo a Dzayiruse, mfumu a nzo a lisamana a ba-Dzwife ályele nde ti: «Mwana a we aakpi. Muluo ka li a ki aafiriyisa oko o.» ");
INSERT INTO tyx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Lo Yiisu bu agyughu obo, ályele Dzayiruse ndiri: «Ka kala a nzalamweẽ o, sa yini a kana, nde sa adzughu.» ");
INSERT INTO tyx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yiisu bu áyato ŋa nzo a Dzayiruse, nde ka ágwi baara muswa wu osomo ya nde o. Yini a Piere, Dzake, Dzã, taara ya maama a mwana báasomo ya nde. ");
INSERT INTO tyx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Baara bwohono bákalili ya bákanyoõ mu nkooro a lipfu li mwana. Mu obo Yiisu ályele ndiri: «Ka lili o! Nde ka aakpi o, lo nde ogyoŋomo aagyoŋomo.» ");
INSERT INTO tyx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bo bákasebe nde mu kuulu bo bágyahaba ti mwana aakpi. ");
INSERT INTO tyx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lo, Yiisu bu akwara mwana mu kwogho, ályele kundaa nde mu mpini ndiri: «Mwana, temene!» ");
INSERT INTO tyx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mu matala maana mamo, ewumu e mwana éyabvughuru, ya maswa-maswa nde átemene. Yiisu ályele bo bagwa nde bi-odza. ");
INSERT INTO tyx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Taara ya maama a mwana bákiŋimi ku olagha. Lo Yiisu átswi bo mukele banyaã olyele mbwuru ndagha oyo. ");
INSERT INTO tyx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yiisu áti bantumu ba nde kwumu ya buolo (12) mbili ya ágwi bo emfumu ya mpaana yi obyi mifulu mi mibi ya odzuhu babyele. ");
INSERT INTO tyx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ŋa nseele, nde ágweghe bo bayitsala nsia yi a Emfumu e Nzaami, ya badzuhu babyele. ");
INSERT INTO tyx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nde ályele kundaa bo ti: «Ka libiri elogho si emõ mu nzili o, ngu okala mukaana, empogholo, bi-odza, nzi, bwunu we enkuru kii byele. ");
INSERT INTO tyx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mu nswe nzo yi bagyagha be, likala omo tee matala ma liimara be oŋo. ");
INSERT INTO tyx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kala ti baara babihi be ogyagha, lipala mu bvulu lilo, ya likubulu lifufunu mu myili mi be mpaala okala bumpughulu mu bo.» ");
INSERT INTO tyx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bantumu bágyene, bátsala nsia yi a Emfumu e Nzaami mu bula nswe bula, ya bádzuhu babyele mu bibini byehene. ");
INSERT INTO tyx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erode, mfumu a etsulu e nsie kii Ngalile, ágyughu myehene mi míkaluru, nde ka ábagha yi obili o, mu kuulu bana bákalyele ti: «Munde ngu Dzã Muboghoro aasighili mu lipfu.» ");
INSERT INTO tyx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Babake bákalyele ti: «Munde ngu Eli aayabvughuru». Ya babake si ti: «Mumõ ŋa kara li mibighili mi mikulu aasighili mu lipfu.» ");
INSERT INTO tyx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Lo Erode ályele ndiri: «Me aantumu bakehe Dzã bolo. Lo mbwuru wu li mu okabulusa mandagha ma ndi mu ogyughu me nande?» Mu obo nde ákasagha omono Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bantumu kwumu ya buolo (12) bu bayabvughuru, bályele Yiisu myehene mi bási bo. Yiisu ábiri bo ku ebini ki egwene a baara, mu nkolo yi a bvulu lili Betesayida. ");
INSERT INTO tyx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Baara balagha bagyughu ti Yiisu ákagye ku bvulu lilo, bo bánama nde. Nde ágyagha bo, áluo bo mu mi mitala Empu e Nzaami, ya ádzuhu babyele. ");
INSERT INTO tyx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bwihi bu bugyili, bantumu ba Yiisu kwumu ya buolo (12) bágyi kundaa nde ya bályele ti: «Lyele baara bagye ku mala ma masala ya ma manene ma mali bitaa-taa bi mu kuulu bayisagha bi-odza ya ebini ki ogyoŋomo. Bihi-a-be ŋa kara-a-kara a syehe lili.» ");
INSERT INTO tyx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lo Yiisu ályele bo bu: «Ligwa bo bi-odza beme.» Lo bo bábvuhulu nde bu: «Bihi bi lili a bye yini a mampa mataana ya banswi buolo. We budzyi ti bihi ligye liswumu bilogho bi okughu odza mpwumu a baara yi?» ");
INSERT INTO tyx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mutala a babaghala ba báli oŋo áli ku bele a mapfwunu mataana (5 000). Yiisu ályele kundaa binduono bi nde ndiri: «Libwihi baara nsini mu makaba mama baara makwumu mataana (50).» ");
INSERT INTO tyx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Binduono bi nde bísi obo, ya bílyele baara bwohono babwa nsini. ");
INSERT INTO tyx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ŋa mbihi oŋo, Yiisu ágwolo mampa mataana ya banswi buolo, átala ku yulu, ábvurulu matuono kundaa Nzaami, ákehe mampa ya banswi, ágwi kundaa binduono bi nde mu kuulu bakaba bye kundaa baara. ");
INSERT INTO tyx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Baara bwohono báli ya bágyughuru. Binduono bítolo bitsulu bi mampa ya ndaama a banswi bi bísyili, ya báluhu bitubu kwumu a byele. ");
INSERT INTO tyx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Etsughu etsyini Yiisu ákasamana ŋa ebini kiili baara we, ya binduono bi nde bíli ya nde. Nde áfwulu bo ti: «Mu mbiili a baara, me nande ndi?» ");
INSERT INTO tyx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bye bíbvuhulu nde bu: «Bitsimi bi baara bana ti we li Dzã Muboghoro, babake ti we li Eli, babake si ti we li mumõ ŋa kara li mibighili mi mikulu wu aasighili mu lipfu.» ");
INSERT INTO tyx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yiisu ályele kundaa bo ti: «Lo, mu be, me nande ndi?» Piere ábvuhulu ti: «We li Kriste a Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yiisu átswi bo mukele banyaã olyele mbwuru ndagha oyo. ");
INSERT INTO tyx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yiisu áfirilyele kundaa binduono bi nde ti: «Mwana a mbwuru faana omono mpara yi alagha. Bakwuru, bakwuru ba bangaa ba Nzaami ya Baluo-mikyene sa babihi nde. Sa badzwa nde, ya bitsughu bitere biluru, nde sa asighili mu lipfu.» ");
INSERT INTO tyx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ŋa mbihi oŋo, Yiisu ályele kundaa baara bwohono ti: «Kala ti mbwuru dzyi onama me, nde faana otunu nyuru a ndeme. Lo nde faana obiri kuruwa li nde nswe etsughu ya onama me. ");
INSERT INTO tyx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mu kuulu wu dzyi obvwuhu laama li nde, sa apfihili lo. Lo munde wu aapfihili lo mu nkooro a me, sa abvwuhu lo. ");
INSERT INTO tyx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nsa ndaana mbwuru aabagha kala ti bagha bupfulu bu nsie nsyini, lo pfihili laama li nde? ");
INSERT INTO tyx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nswe munde wu akala aamono budzwa mu me ya mu mandagha ma me, Mwana a mbwuru sa amono nde budzwa ŋa ayabvughuru nde kunsa nsia a nde, nsia a Taara a nde, ya yi a bangye-yulu. ");
INSERT INTO tyx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mu engaŋma, me ndyele be, ndaama a baara mu ba bali ŋa ka bakpa o, nsomo-a-nsomo bamono Emfumu e Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bitsughu mpuomo bu biluru ŋa mbihi a ŋa ályele nde mandagha mamo, Yiisu ágwolo Piere, Dzã ya Dzake, ya ákumu ku yulu a munguo mu oyisamana. ");
INSERT INTO tyx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mu matala maala nde mu okasamana, busu bu nde búkighiri ya biko bi nde bígyighili opeŋeme kuu oluru. ");
INSERT INTO tyx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mu matala maana mamo, babaghala buolo, Moyidze ya Eli, bákabili ya Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bo báyapala kunsa nsia ya bámoŋo ya Yiisu mu mi mitala bunu-a-bo nde ali afaana omana esala e nde mu oyikpa ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piere ya bantumu buolo babake bábwi mukaba a tolo, lo bu babulusighili, bámono nsia a Yiisu ya babaghala buolo ba báli ya nde. ");
INSERT INTO tyx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mu matala ma óbaana Moyidze ya Eli ogye, Piere ályele Yiisu ndiri: «Muluo, bubwe buulu bihi lili ŋa. Bihi bibvulu bitere liitwu: Etsyini kii we, etsyini kii Moyidze ya etsyini kii Eli.» Piere ka ákasoolo mi ákabili nde o. ");
INSERT INTO tyx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ŋaala nde nkini mu okabili obo, edzi égyi ya edzyimi-a-dzyimi ekye éfughu bo. Nzalamweẽ yíbagha bantumu ŋa básomo bo kunsa edzi. ");
INSERT INTO tyx_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ŋa mbihi oŋo, likyi lífi kunsa edzi lídzumu ti: «Wu me mwana a me, wu aansuolo me, ligyughu nde.» ");
INSERT INTO tyx_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bu bamana ogyughu ndagha oyo, bantumu bámono yini a Yiisu ngasighi. Bo ka bátsughu ndagha o mu myehene mimye, ya mu matala mamo, bo ka bályele mbwuru mi bámono bo o. ");
INSERT INTO tyx_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Etsughu etsyini bu eluru, Yiisu ya binduono bi nde bitere bákumunu ku nsie a munguo, ya mpwumu a baara yi nene yíyabwana a Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ŋa kara li mpwumu a baara, baghala mutsyini ákehe engubu ndiri: «Muluo, yoboo, mono mwana a me nyiĩ! Yini a mumõ wu me ndi a nde. ");
INSERT INTO tyx_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nswe matala, mufulu wu mubi aakasomo mu nde. Mu obo, mu matala maana mamo, mwana agwolo baana okehe mingili. Nde bwi elogho, ya fulu lipala mu muŋma. Mufulu munde li mu osuo nde kimini ya ka dzyi onyaã nde o. ");
INSERT INTO tyx_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Me aambuono binduono bi we bibyi mufulu munde, lo bye ka biileene o.» ");
INSERT INTO tyx_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yiisu ágwi mvuru yi: «Ekaana ki egwene a kana, ya ki egwuŋumu! Tee nki matala me aankala ya be? Ya tee nki matala me aankuru mukolo mu be?» Mu obo Yiisu ályele baghala munde ndiri: «Yabiri mwana a we ŋa!» ");
INSERT INTO tyx_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mu matala ma ókayabehene mwana kundaa Yiisu, mufulu wu mubi ábwihi nde mu nsie ya ányihi nde mu mpini yohono. Lo Yiisu áfulu mufulu wu mubi epama, ádzuhu mwana ya ábvurulu nde kundaa taara a nde. ");
INSERT INTO tyx_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Baara bwohono bákiŋimi mu omono mpaana a Nzaami. Ŋaala baara nkini mu okakiŋimi mu mandagha ma ókasa Yiisu, nde ályele kundaa binduono bi nde ndiri: ");
INSERT INTO tyx_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Be, ligyighili otyeghe matswi mu mandagha ma: Bafaana otyeghe Mwana a mbwuru ŋa myaã mi baara.» ");
INSERT INTO tyx_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lo binduono bi nde ka bábaghala ndagha oyo o. Nzaami átwulu bo kunsa nzi-nzimini mu kuulu banyaã ogyahaba mambaala ma ndagha oyo, ya bye bíbara nzalamweẽ mu ofwulu Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Binduono bítsoho bo-a-bo mu ogyahaba nande luru bunene ŋa kara li bo. ");
INSERT INTO tyx_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Lo Yiisu bu agyahaba bitsimi bi bo, ágwolo muke-muke, átwulu nde ŋa bele a nde ");
INSERT INTO tyx_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ya ályele bo ndiri: «Nswe mbwuru wu gyagha muke-muke wu, mu nkwumu a me, meme nde agyagha. Ya nswe mbwuru wu gyagha me, wu aagweghe mehe si nde agyagha. Mu kuulu munde wu luru busala ŋa kara li be bwohono, me munde bvulu bunene.» ");
INSERT INTO tyx_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ŋa mbihi oŋo, Dzã ályele Yiisu ndiri: «Muluo, bihi liimono baghala mutsyini wu li mu okabyi mifulu mi mibi mu nkwumu a we. Bihi liisagha okahaba nde mu kuulu nde ka li mu okanama we ya bihi o.» ");
INSERT INTO tyx_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lo Yiisu ályele nde ndiri: «Ka likahaba nde o, mu kuulu munde wu gwene bele be, ya be ali.» ");
INSERT INTO tyx_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yiisu ámono ti matala maa osihi nsie mu ogye ku yulu maabehene. Nde ágwolo munkaana wu ogye ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nde átswahaba baara ba bágyene ku bula butsyini baba etsulu e nsie kii Samari mu ogyighili nde ebini kii ogyoŋomo. ");
INSERT INTO tyx_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lo baara ba bula bubo bábihi ogyagha nde, mu kuulu bagyahaba ti nde ku Yerusaleme ákagye. ");
INSERT INTO tyx_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bu bágyughu obo, binduono bi nde byele, Dzake ya Dzã bályele ti: «Mfumu, we dzyi ti bihi liluomo mbaa yi mayulu yisughuru yiyadzwa bo?» ");
INSERT INTO tyx_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yiisu ákaghala kundaa bo ya áfyeẽ bo. ");
INSERT INTO tyx_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mu obo, Yiisu ágyene ku bula bukimi ya binduono bi nde. ");
INSERT INTO tyx_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ŋa báli bo mu nzili, baghala mutsyini ályele Yiisu ti: «Me sa nama we ku nswe ebini ki aagye we.» ");
INSERT INTO tyx_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yiisu ályele nde ndiri: «Mibagha mili a miŋma, ya baŋmini bali a manzo, lo Mwana a mbwuru ka li a ebini kii ogwumu bwunu we kii ogyoŋomo o.» ");
INSERT INTO tyx_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nde ályele kundaa baghala mukimi ti: «Nama me!» Lo baghala munde ábvuhulu nde ti: «Mfumu, nyaã me manswama oyidzyighi taara a me.» ");
INSERT INTO tyx_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yiisu ágwi nde mvuru yi: «Nyaã ba bákpi badzyighi bo-a-bo. Lo we gye yitsala Nsia yi a Emfumu e Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Baghala wu muke ályele ndiri: «Mfumu, me sa nama we, lo nsomo-a-nsomo nyaã me ngye yingwa basi dzumu li me mboro yi masini.» ");
INSERT INTO tyx_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yiisu ábvuhulu nde ti: «Mbwuru wu kwara teme mu obaana osala nseghe, ya tala ku mbihi ka li a esala o mu mi mitala Emfumu e Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ŋa mbihi oŋo, Mfumu ásuolo babaghala makwumu-nsaama ya buolo (72) bakimi ya ágweghe buolo-buolo mu nswe bvulu ya nswe ebini ki ágwaa nde ogye. ");
INSERT INTO tyx_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nde ályele bo ndiri: «Esala kii otolo bimburu mu manseghe elagha, lo baara ba baasala basala. Liluomo kundaa Mfumu a nseghe agweghe basala bakimi mu otolo bimburu. ");
INSERT INTO tyx_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ligye! Me ndi mu ogweghe be ti anga baana ba bindoomo ŋa kara li bango. ");
INSERT INTO tyx_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ka libiri nzi, empogholo, bwunu we bikoghoro o. Ka liluhu matala mu nzili mu okabulugwa baara mamboro o. ");
INSERT INTO tyx_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nswe nzo yi liisomo be, nsomo lilyele ndiri: “Nyaã edzuunu ekala mu nzo yi!” ");
INSERT INTO tyx_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kala mbwuru wu edzuunu li omo, edzuunu e be sa ekala ya nde. Kala pele, kye sa ebvughuru kundaa beme. ");
INSERT INTO tyx_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mu obo, likala mu nzo oyo, lidza ya liŋma nswe elogho ki baagwa be, mu kuulu musala faana obagha mufuru mu esala e nde. Ka lipala mu nzo oyo mu oyigyoŋomo mu nzo nswe nzo o. ");
INSERT INTO tyx_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kala ti be lisomo mu bvulu litsyini ya baara bagyagha be, lidza bi baagwa be. ");
INSERT INTO tyx_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Lidzuhu babyele ba bali mu bvulu lilo, ya lilyele baara ndiri: “Emfumu e Nzaami eeyabehene ya be.” ");
INSERT INTO tyx_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lo, kala be lisomo mu bvulu litsyini ya baara babihi ogyagha be, ligye mu minsagha ya lilyele ti: ");
INSERT INTO tyx_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bihi likubulu si lifufunu li bvulu li be li liinabara mu myili mi bihi. Lo ligyahaba yo ti Emfumu e Nzaami ali eeyabehene ya be.” ");
INSERT INTO tyx_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Me ndi mu olyele be engaŋma, mu etsughu ki oosa Nzaami muyala a basi nsie, masyeme ma basi Sodome sa maluru osala ya mama bvulu lilo.» ");
INSERT INTO tyx_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Nyiĩ mu be, baara ba bvulu lili Koradzine, ya behe si baba bvulu lili Betesayida! Kala ti bimamaã bi oosi Nzaami mu mabvulu ma be, ku mama Tire ya Sidõ nde ási bye, baara baa oko nkini edzighi ekye ali bakaagyiŋi mayele, bakaalaha mangooro, ya bakaagyogho lifuru a mbaa mu nyuru mu osuo ti bo baagyiŋi mayele. ");
INSERT INTO tyx_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mu obo, mu etsughu ki oosa Nzaami muyala a basi nsie, masyeme ma oobagha Tire ya Sidõ sa maluru osala ya ma liibagha be. ");
INSERT INTO tyx_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Behe si, baara baba bvulu lili Kaperenawume! Be bu liikatsimi ti Nzaami sa akuhubu be tee ku mayulu? Pele, be sa libwa ku nsini a ebini ki oli mu okakebe ba bákpi masyeme.» ");
INSERT INTO tyx_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yiisu áfirilyele binduono bi nde ti: «Nswe mbwuru wu gyughu be, me agyughu. Nswe wu bihi be, me abihi, ya nswe mbwuru wu bihi me, mbwuru wu aagweghe me abihi.» ");
INSERT INTO tyx_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Binduono makwumu-nsaama ya byele (72) bíyabvughuru ya esee kyehene ya bílyele ti: «Mfumu, si okala mifulu mi mibi miikagyughu bihi, ŋa liikatumu bihi mye mipala mu baara mu nkwumu a we!» ");
INSERT INTO tyx_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yiisu ágwi bo mvuru yi: «Me áli aankamono ŋa ófi Satana ku yulu ya ábwi ti bu ookabwa ngayulu. ");
INSERT INTO tyx_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ligyughu! Me aangwi be mpaana yi odzyara mu yulu a bantaala ya bangie, ya mu odzyara lileene lwohono li mutaara, ya ka oli a elogho ki ekughu osa be bubi o. ");
INSERT INTO tyx_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lo ka liŋene mu kuulu mifulu mi mibi mili mu okagyughu be o. Likala a esee mu kuulu mankwumu ma be baasono mo mu mayulu.» ");
INSERT INTO tyx_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mu matala mamo, Mufulu a Ngili áluhu Yiisu mu esee ki elagha, mu obo Yiisu ályele ti: «Taara, Mfumu a yulu ya nsie! Me mvurulu we matuono, mu kuulu we aasweghe mandagha ma kundaa banga-a-munzeele ya banga-a-mayele, lo we aasuo mo kundaa bike-bike. Mu engaŋma, Taara, weme aadzyi ti okala obo. ");
INSERT INTO tyx_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Taara a me, we aatwulu bilogho byehene ŋa myaã mi me. Ka oli a mbwuru wu gyahaba Mwana nande ali o, kala ka oli yini a Taara o, ya ka oli a mbwuru wu gyahaba Taara nande ali o, kala ka oli Mwana. Mwana dzyi osuo bo Taara mu kuulu boho si basoolo nde.» ");
INSERT INTO tyx_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ŋa nseele, Yiisu ákaghala kundaa binduono bi nde ya ályele yini a kundaa bo ti: «Esee mu be ba lili mu okamono mandagha ma! ");
INSERT INTO tyx_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mu engaŋma, me ndi mu olyele be, mimono ya mikogho milagha miikadzyi omono mi lili mu okamono be, lo ka miimono mye o. Boho si báli a nzala ogyughu mi lili mu okagyughu be, lo ka baagyughu mye o.» ");
INSERT INTO tyx_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Muluo-mikyene mutsyini ágyi kundaa Yiisu mu osagha obwihi nde, nde átsughu ndagha ti: «Muluo! Emakye me mfaana osa mu obagha laama lii mibvu ya mibvu?» ");
INSERT INTO tyx_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yiisu ágwi nde mvuru yi: «Bunu-abo básono mu mikyene mi Nzaami? We bunu-a-bo li mu obaghala mye?» ");
INSERT INTO tyx_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Baghala munde ábvuhulu bu: «Dzyi Mfumu Nzaami a we mu mukolo a we wohono, mu muwumu a we wohono, mu mpini a we yohono ya mu bitsimi bi we byehene. Ya Dzyi nganda-mbwuru ti budzyi we nyuru a weme.» ");
INSERT INTO tyx_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mu obo, Yiisu ályele nde ti: «We aagwi mvuru yi mbwe. Sa obo, ya we sa bagha laama.» ");
INSERT INTO tyx_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lo baghala munde bu ádzyi osuo ti efwulu e nde éli mu nzili, nde áfwulu Yiisu ndiri: «Nande li nganda-mbwuru a me?» ");
INSERT INTO tyx_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yiisu ábvuhulu bu: «Etsughu etsyini baghala mutsyini ámara Yerusaleme ya ákakumunu ku Dzeriko. Mu nzili, bantwumu bábwirili nde, bátwulu nde mpene, bágwyini a nde mpaana, átaghaba ngaama ya bo bábulusihi nde. ");
INSERT INTO tyx_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ngaa a nzaami mutsyini áluru mu nzili oyo. Bu amono baghala munde, nde ábululuru o nde mu mukogho a nzili wu muke. ");
INSERT INTO tyx_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ŋa mbihi oŋo, mu-Lebvite áyato oŋo. Bu amono baghala munde, ndehe si áluru mu mukogho a nzili wu muke. ");
INSERT INTO tyx_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lo musi Samari mutsyini áluru si mu nzili oyo. Bu amono baghala munde, nyiĩ yíbagha nde. ");
INSERT INTO tyx_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mu obo, nde ásele ŋa bele a nde, ási nde maala ya bviini mu mambaala ya ákuru mo. Ŋa mbihi oŋo, nde ákuhubu nde ŋa yulu a syevale a nde, ábiri nde ku nzo a banzyi, ya ábughu nde. ");
INSERT INTO tyx_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bwihi bu buki, nde ágwolo badenye buolo, ágwi kundaa musala a nzo a banzyi, ya ályele nde ti: “Gyighili oyabughu nde, ya ŋa ayamvughuru me, me sa mvurulu we nzi yi aagyehe we mu nde ŋa yulu.”» ");
INSERT INTO tyx_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yiisu áfirilyele nde ndiri: «Ŋa kara li baara batere babo, nande li nganda-mbwuru a baghala munde wu ogwyini a bantwumu mpaana?» ");
INSERT INTO tyx_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Muluo-mikyene ábvuhulu ti: «Me mbwuru munde wu aamono nde nyiĩ». Mu obo Yiisu ályele ti: «Gye, ya wehe si sa bumõ». ");
INSERT INTO tyx_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mu matala maala Yiisu áli mu nzili ya binduono bi nde, nde ásomo mu bula butsyini, mukaha mutsyini wu a nkwumu Marete agyagha nde mu nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nde áli a mbwee wu mukaha, nkwumu a nde Mari. Nde áyibwa nsini ŋa myili mi Mfumu ya ákagyughu maluo ma nde. ");
INSERT INTO tyx_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bisala bi nzo áli bígwolo Marete nyuru. Mu obo nde ásele ŋa ndaa Yiisu ya ályele nde ti: «Mfumu, we ka li mu otsimi ti mbwee a me bubi aasi mu onyaã me ngasighi ya esala kyehene ki o? Lyele nde ayabaha me.» ");
INSERT INTO tyx_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mfumu ábvuhulu nde bu: «Marete, Marete, we li mu onyoõ ya omono mukolo mpara mu mandagha malagha. ");
INSERT INTO tyx_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Lo yini a elogho etsyini eli a mupfunu. Mari aasuolo kaba li libwe, ya ka oli ya mbwuru wu aagwohono nde lo o.» ");
INSERT INTO tyx_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Etsughu etsyini, Yiisu ákasamana ŋa ebini etsyini. Bu amana, mumõ ŋa kara li binduono bi nde ályele nde ti: «Mfumu, luo bihi bu lifaana osamana, ti bu óluo Dzã binduono bi nde». ");
INSERT INTO tyx_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yiisu ályele bo ndiri: «Ŋa liikasamana be, liikalyele bu: “Taara, nyaã nkwumu a we yikala yi a ngili, nyaã Emfumu e we egya! ");
INSERT INTO tyx_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gwa bihi bi-odza bibi faana mu nswe etsughu. ");
INSERT INTO tyx_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Sa masumu ma bihi kolokolo, mu kuulu bihi si liikasa babo ba baakasa bihi bubi kolokolo. Ya ka atala bihi libwa mu bigyeele o.”» ");
INSERT INTO tyx_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yiisu áfirilyele bo ndiri: «Kala mumõ ŋa kara li be gyene yitala ndughu a nde kara-a-kara a mpyibi mu olyele nde ti: “Ndughu a me, sohobo me mampa matere. ");
INSERT INTO tyx_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Mu kuulu me mumõ mu bandughu ba me wu li mu dzwe maayato ku nzo a me, ya me ka ndi a elogho ki aangwa nde o.” ");
INSERT INTO tyx_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kala ti ndughu a we wu li munsa nzo bvuhulu: “Nyaã me pii, me nzo aankuru ofi, ya me ya baana ba me liigyoŋomo. Me ka nkughu ofirisighili mu ogwa we mampa o.” ");
INSERT INTO tyx_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Me ndi mu olyele be yo: “Si kala ti nde ka sighili o ya ogwa we mampa mu kuulu we li ndughu a nde, nde sa asighili ya sa agwa we byehene bi li a we nzala bye, mu kuulu we ka aabara budzwa o mu oluomo ya we aasi epini.” ");
INSERT INTO tyx_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mu obo, me ndyele be ti: “Liluomo, ya sa bagwa be, lisagha, ya sa libagha, likoboro, ya sa badzubulu be. ");
INSERT INTO tyx_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mu engaŋma, munde wu luomo sa bagwa nde, munde wu sagha, sa abagha, ya sa badzubulu kundaa munde wu aakoboro. ");
INSERT INTO tyx_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nki Taara wu kughu ogwa mwana a nde ntaala kala ti mwana luomo nde nswi? ");
INSERT INTO tyx_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bwunu we ngie, kala ti mwana luomo nde bi? ");
INSERT INTO tyx_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kala ti be baara ba babi lisoolo ogwa bilogho bi bibwe kundaa baana ba be, lo Taara a be wu li ku mayulu, bunu akughu ogwene ogwa Mufulu a Ngili kundaa babo ba baaluomo nde nde?”» ");
INSERT INTO tyx_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Etsughu etsyini, Yiisu ábyi mufulu wu mubi wu áasi ti mbwuru akala nkini. Mufulu munde bu apala, baghala munde ábaana obili ya mpwumu a baara yíkiŋimi ku olagha. ");
INSERT INTO tyx_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lo baara bana bályele ti: «Me mu nkwumu a Beledzebule, mukwuru a mifulu mi mibi nde ali mu okabyi mifulu mimye.» ");
INSERT INTO tyx_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ya babake, bu bádzyi ogyeele Yiisu, báluomo nde asa elyimi ki eefa ku yulu. ");
INSERT INTO tyx_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lo Yiisu bu ágyahaba bitsimi bi bo, ályele ndiri: «Nswe nsie yiili baara bali kunsa etaara ka yilaama o, ya manzo ma yo sa maakabwa mana ŋa yulu a mamake. ");
INSERT INTO tyx_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mu obo, kala Satana li mu osa ti baara ba nde badzwana bo-a-bo, bunu-a-bo emfumu e nde eelaama? Be lili mu okalyele ti me Beledzebule li mu okagwa me mpaana yi obyi mifulu mi mibi. ");
INSERT INTO tyx_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kala ti Beledzebule li mu okagwa me lileene lii obyi mifulu mi mibi, lo baana ba be nande aakagwa bo lileene lii okabyi mye? Mu obo, bo bomo sa balyele ti be ligyahaba ndagha. ");
INSERT INTO tyx_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lo, kala mu lileene li Nzaami me ndi mu okabyi mifulu mi mibi, oli mu osuo ti Emfumu e Nzaami ayi emaayato kundaa be.» ");
INSERT INTO tyx_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Ŋa ookakebe baghala nga a mpini wu li a bidzwana bi bikughu nzo a nde, bilogho bi nde byehene biikakala kunsa ekagha. ");
INSERT INTO tyx_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lo, kala mbwuru wu luru nde mpini yadzwana ekyini ya nde, mbwuru munde sa agwohono bidzwana bi nde byehene bi aakasa nde kana, ya sa akaba bilogho bi nde byehene.» ");
INSERT INTO tyx_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Nswe munde wuulu ka li emõ ya me o, li mutaara a me, ya nswe munde wu aagwene okabvughu ya me, nde aakatsala.» ");
INSERT INTO tyx_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Ŋa ookapala mufulu wu mubi mu nyuru a mbwuru, nde aakayisagha ebini kii ogwumu ku syehe. Kala ti ka bagha kye o, nde sa atsimi bu: “Nyaã me mbvughuru ku nzo ku aamfi me.” ");
INSERT INTO tyx_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mu obo nde sa abvughuru ya sa ayabagha nzo bakuomo ya yifaana. ");
INSERT INTO tyx_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ŋa mbihi oŋo, nde sa apala ayigwolo mifulu mi mibi mikimi nsaama mi miluru nde bubi. Mye sa miyasomo ya sa mikala omo. Mu obo, mbwuru sa amono mpara yiluru oyo yi áli a nde nsomo.» ");
INSERT INTO tyx_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yiisu bu amana obili obo, mukaha mutsyini wu áali kunsa mpwumu a baara átsughu ndagha ti: «Esee kundaa mukaha wu aaburu ya aaŋmihi we mabyene!» ");
INSERT INTO tyx_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lo Yiisu ágwi mvuru yi: «Lo esee kundaa baara ba bali mu okagyughu Ndagha a Nzaami ya ba bali mu okasalala yo.» ");
INSERT INTO tyx_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ŋa ósi mpwumu a baara Yiisu ŋa kara, nde ályele bo ndiri: «Baara baba eseene kii lolo ki bali babi! Bo bali mu oluomo elyimi. Lo ka bamono elyimi o, kala ti ka yini a kii Dzonase o. ");
INSERT INTO tyx_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mu kuulu, bwunu a bu óli Dzonase elyimi mu basi Ninibve, Mwana a mbwuru si sa akala elyimi mu baara baba eseene ki. ");
INSERT INTO tyx_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mu etsughu ki osa Nzaami mumfwunu a basi nsie, Ngasa a nsie yi a Sude sa atemene ŋa nkulu a baara baba eseene ki, ya sa agwa bo masyeme, mu kuulu nde aamara bula bu nde ba buli la mu oyagyughu maluo mama bunsughu ma ookaluo Salomõ. Lo ŋa oli ya mbwuru wu bvulu Salomõ. ");
INSERT INTO tyx_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mu etsughu kii mumfwunu a basi nsie, basi Ninibve sa batemene ŋa nkulu a baara baba eseene ki, ya sa bagwa bo masyeme mu kuulu bo baagyiŋi mayele ŋa baagyughu bo mukwughu wu ooti Dzonase. Lo, ŋa oli ya mbwuru wu bvulu Dzonase.» ");
INSERT INTO tyx_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Ka oli ya mbwuru wu aakanahaba mwindi mu osweghe nde bwunu we mu ofughu nde nkuru o, lo ŋa yulu ebini ki baakatwulu mwindi mu kuulu ba baasomo mu nzo bakala kunsa otsyeme. ");
INSERT INTO tyx_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lihi li we lili ti mwindi a nyuru a we. Kala nta-ntala a we li yi mbwe, nyuru a we yohono sa yikala kunsa otsyeme. Lo, kala nta-ntala a we li yi mbi, nyuru a we yohono sa yikala kunsa mpyibi. ");
INSERT INTO tyx_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mu obo, we faana osa mayele mu kuulu otsyeme ku oli mu we onyaã okala mpyibi. ");
INSERT INTO tyx_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kala nyuru a we yohono yili kunsa otsyeme, ku ogwene a esighi si etsyini kunsa mpyibi, yo yohono sa yikala kunsa otsyeme ti ŋa ookatsehebe we mwindi.» ");
INSERT INTO tyx_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yiisu bu amana obili, mu-Faridzyẽ mutsyini ályele nde ayidza ku nzo a nde. Mu obo Yiisu ásomo mu nzo ya ábwi nsini mu odza. ");
INSERT INTO tyx_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mu-Faridzyẽ munde ákiŋimi mu omono ti Yiisu ka áswagha myaã o, nsomo-a-nsomo abaana odza ti bu óli ekulu ki ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mu obo, Mfumu ályele nde ti: «Be ba-Faridzyẽ, be lili a epfu ki okatsehebe bibaha ya mandoŋõ ma be ku mbihi, lo mu kara be lili a nzala a pfyibi ya mandagha mama nkehe. ");
INSERT INTO tyx_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Be mayele we! Nzaami wu aagyighili bilogho bi biikamoŋono, me nde si aagyighili mukolo a mbwuru. ");
INSERT INTO tyx_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mu obo ligwa bawele bilogho bi bili mu bibaha ya mandoŋõ ma be, ya bilogho bi be byehene sa bikala bibi tse-tse.» ");
INSERT INTO tyx_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Lo nyiĩ mu be ba-Faridzyẽ! Be liikagwa Nzaami kaba lili kwumu lili bilogho bi liikakunu be, ti bu oli mampihi-a-mpihi ya miswoho mimi bifa-bifa. Lo be liikadzinimi bunsumu ya dzyi li Nzaami. Mamo mandagha ma lifaana okasa be, ya ogwene odzinimi bibike nsimi.» ");
INSERT INTO tyx_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Nyiĩ mu be ba-Faridzyẽ! Be liikadzyi okabwa nsini mu bipehe bibi ku nkulu mu manzo ma lisamana, ya be liikadzyi ti baara bakagwa be mamboro mama budziri mu bibini bi ookabvuŋunu baara. ");
INSERT INTO tyx_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nyiĩ mu be! Be lili efaana kii mampyeme ma magwene a elyimi, maala baara bali mu okadzyara mo ku ogwene a ogyahaba.» ");
INSERT INTO tyx_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mumõ ŋa kara li baluo-mikyene ályele nde ndiri: «Muluo, ŋa bili we obo, we aatughu bihi si!» ");
INSERT INTO tyx_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yiisu ábvuhulu nde ti: «Nyiĩ si mu be baluo-mikyene! Be liikagwa baara matsulu mama leme mu obiri, lo be ka liikabaha bo si eke o. ");
INSERT INTO tyx_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nyiĩ mu be! Mu kuulu be liikatwu mampyeme ma mibighili, lo bankagha ba be báadzwi mye. ");
INSERT INTO tyx_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mu obo, be lili mu okasuo bumpughulu ti be liikakihi bigyighili bi ósi bankagha ba be, mu kuulu bo bádzwi mibighili, ya be liikatwu bo mampyeme. ");
INSERT INTO tyx_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Lo Nzaami mu mayele ma nde mwohono ályele bu: “Me sa ngweghe mibighili ya bantumu. Bo sa badzwa bana ya sa bamwehẽ babake kimini.” ");
INSERT INTO tyx_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mpaala baara baba eseene ki babagha masyeme mu nkooro a makili ma mibighili myehene mi bádzwi obaana ebaana e nsie, ");
INSERT INTO tyx_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","obaana lipfu li Abele tee mu lili Dzakari wu bádzwi ŋa kara li ebini ki baakatsughu Nzaami bikaba ya nzo a Nzaami yi nene. Me ndi mu olyele be, baara baba eseene ki sa babagha masyeme mu nkooro a makili ma bo.» ");
INSERT INTO tyx_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Nyiĩ mu be baluo-mikyene, mu kuulu be liimaha bvungulu li nzo yi aakagwa baara ligyahaba, be beme ka liisomo omo o, ya lili mu okakahaba babo ba badzyi osomo omo.» ");
INSERT INTO tyx_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mu matala ma ómara Yiisu ŋa ebini ekye, baluo-mikyene ya ba-Faridzyẽ bábaana okolo nde nkehe yi mbi ya okagwa nde bifwulu mu mandagha malagha. ");
INSERT INTO tyx_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bo bákasagha osomo nde mu mweẽ nkini-a-nki nde ákughu opaha ndagha yi mbi. ");
INSERT INTO tyx_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mu matala mamo, mapfwunu ma baara mayabvuŋunu, mu obo babake bákadzyara myili mi banganda. Yiisu ábaana olyele kundaa binduono bi nde ti: «Lisa mayele mu pfini lili ba-Faridzyẽ, li lili mandagha mama fughuru-fughuru. ");
INSERT INTO tyx_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Etsughu eli kiili mandagha mwohono ma másweme sa magyighili omoŋono, ya mansweghe mwohono sa bagyahaba mo. ");
INSERT INTO tyx_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mu obo, mandagha mwohono ma liibili be kunsa mpyibi, sa bagyughu mo mu nkara a mwiĩ, ya mandagha ma liilyele be mu mamfwunu munsa mangwumu ma manzo, sa bata mo mukwughu ku yulu a see li nzo lili eyala.» ");
INSERT INTO tyx_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«A baana-abo, me bu ndyele be: Ka libara baara baala yina a nyuru bakughu odzwa o, lo ka bakughu osa elogho ekimi o. ");
INSERT INTO tyx_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Me be aansuo nande be lifaana obara. Mbwuru wu lifaana obara be, munde wuulu ŋa mbihi ŋa aamaha nde mbwuru muwumu, nde li a lileene lili otsili nde ku mungele-a-mbaa. Me ngyighili olyele be yo, me nde be lifaana obara. ");
INSERT INTO tyx_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ka baakatyeghe binswini-a-nswini bitaana mu mana a mipara myele o? Lo Nzaami ka aakadzimini si emõ mu bye nsimi o. ");
INSERT INTO tyx_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ngu okala mfu a be yi a ku mutswi, Nzaami gyahaba mutala a yo. Mu obo ka likala a nzalamweẽ o. Ŋa mihi mi Nzaami, be liluru mupfunu ya binswini-a-nswini bilagha!» ");
INSERT INTO tyx_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Me ndyele be bu, nswe mbwuru wu aakihi me ŋa mihi mi baara, Mwana a mbwuru si sa akihi nde ŋa mihi mi bangye-yulu ba Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lo munde wu aatunu ŋa mihi mi baara ti nde ka gyahaba me o, Mwana a mbwuru sa abihi nde si ŋa mihi mi bangye-yulu ba Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nswe mbwuru wu tughu Mwana a mbwuru kughu obagha kolokolo, lo munde wu aatsaala Mufulu a Ngili ka kughu obagha kolokolo o. ");
INSERT INTO tyx_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ŋa akala baabiri be mu manzo mama lisamana ma ba-Dzwife mu osa be muyala, bwunu we kundaa bamfumu ya ba baakatumu, ka likala a mikolo maã-maã mu mandagha ma liibvuhulu be bo o, bwunu we mu mandagha ma akala liibili be. ");
INSERT INTO tyx_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mu kuulu mu matala mamo Mufulu a Ngili sa asuo be mandagha ma lifaana obili be.» ");
INSERT INTO tyx_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mbwuru mutsyini ŋa kara li ba báli oŋo ályele Yiisu ti: «Muluo, lyele naana a me akaba ya me pfa li oosihi taara bihi.» ");
INSERT INTO tyx_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yiisu ágwi nde mvuru yi: «Ta baghala, nande aatwulu me nsughu a lamana a be bwunu we mbwuru wu aakaba pfa li be?» ");
INSERT INTO tyx_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ŋa mbihi oŋo nde ályele bo ndiri: «Lisa mayele linyaã okala a ntono a nzi, mu kuulu mbwuru ka kughu obagha laama lili ngaŋma mu nkooro a bilogho bi ali a bye o, si kala ti nde li a bye kyele.» ");
INSERT INTO tyx_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mu obo nde áti bo nkumu yi: «Esini etsyini éli a manseghe ma máburu ku olagha. ");
INSERT INTO tyx_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nde ákatsimi ti: “Bunu-abo me aansa? Me ka aafirinsyili a ebini kii olwunu bimburu byehene bi aantolo me mu nseghe o.” ");
INSERT INTO tyx_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mu obo, nde ályele ti: “Me bu aansa: Me sa mbwihi bitaghala bi me ya me sa ntwu bibaã bi biluru bunene, ya me sa ntwulu mburu a bele a me ya bilogho bi me omo. ");
INSERT INTO tyx_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ŋa mbihi oŋo sa ndyele muwumunu a ti: We aabunu bilogho bilagha bi bikughu osa bamvulu balagha. Gwumu o we, dza, ŋma ya kala mu esee!” ");
INSERT INTO tyx_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lo Nzaami ályele nde ti: “We ewulu! Mu mpyibi yiyi we kpa aakpa. Lo bilogho byehene bi aalwunu we, nande aabyala bye?”» ");
INSERT INTO tyx_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yiisu áfiribwehe bu: «Bumõ kundaa munde wu aakakwu busini mu nkooro a ndeme, lo nde ka li esini ŋa nkulu a Nzaami o.» ");
INSERT INTO tyx_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ŋa mbihi oŋo, Yiisu ályele binduono bi nde ndiri: «Me mu obo me ndyele be ti: Ka limono mukolo mpara mu nkooro a bi-odza bi bifaana mu laama li be o, bwunu we mu binkuru bi bifaana mu manyuru ma be o. ");
INSERT INTO tyx_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mu kuulu, laama liluru bi-odza, ya nyuru yiluru binkuru. ");
INSERT INTO tyx_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Litala bangankwaã: Bo ka baakakunu o, ka baakatolo o, ka bali a bibaã bwunu we mangwumu ma baakalwunu bimburu o, lo Nzaami aakabuŋunu bo. Ligyahaba ti be liluru baŋmini mupfunu. ");
INSERT INTO tyx_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nande ŋa kara li be kughu obwehe etsughu mu laama li nde mu nkooro a minyoõ mi nde? ");
INSERT INTO tyx_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kala be ka likughu osa enda-ndagha kii obo o, mu emakye be lili a minyoõ mu bilogho bibike? ");
INSERT INTO tyx_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Litala bu ookamene bifulu mu ebiri, bye ka biikasala o, bye ka biikatwu o, lo me ndyele be ti, si kala Salomõ, mbwuru wu áali a nsia yi alagha, ka álaha bubwe oluru efulu emõ mu bye o. ");
INSERT INTO tyx_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kala ti Nzaami aakalaha obo lolo nsele yili mu ebiri ya yiili mbala sa batsili yo ku mbaa, lo bunu-abo nde akala aangwene olaha be obo, be baara banga-a-kana li lisala? ");
INSERT INTO tyx_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Lo be, ka likasagha bilogho bi liidza bwunu we bi liiŋma, ya mikolo mi be minyaã okala mu yulu mu okatsimi mandagha mamo. ");
INSERT INTO tyx_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mu kuulu, yini a babo baala ka bali ba-Dzwife o baakasughu mukolo mu bilogho byene bibye. Lo Taara a be gyahaba ti be lili a nzala a bilogho bibye. ");
INSERT INTO tyx_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nsomo-a-nsomo be lifaana osagha Emfumu e Nzaami, ya sa bagwa be bilogho bibike bibye.» ");
INSERT INTO tyx_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Mukaã a bindoomo wu asala, ka kala a nzalamweẽ o, mu kuulu Taara a be aamono ti oli bubwe nde agwa be Emfumu e nde. ");
INSERT INTO tyx_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Lityeghe bilogho bi lili a be ya ligwa nzi kundaa bawele. Likala a bimpogholo bi nzi bi biigwene okakagha, lilwunu mu mayulu busini bu buugwene okafa, mu kuulu oko muturu ka kughu oturu bo o, ya bansiele ka bakughu odza bo o. ");
INSERT INTO tyx_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mu kuulu ebini ki okala busini bu be, me oŋo ŋa okala mikolo mi behe si.» ");
INSERT INTO tyx_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Likala yeelee, likuru nswele mu bala ya lisa kuulu ti miindi mi be mikala mi minama. ");
INSERT INTO tyx_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Behe si, likala ti anga baara ba bali mu okakebe mfumu a bo, wu aagyene ku kyiri kii mabala, mpaala badzubulu nde nzo maswa-maswa ŋa ayabvughuru nde ya ŋa aakoboro nde muŋma a nzo. ");
INSERT INTO tyx_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Esee kundaa bisala bi ooyabagha mfumu a bo ŋa aagya nde mu okakahala mihi! Mu engaŋma, me ndyele be, nde sa alaha binkuru bi nde bii esala, sa abwihi bo nsini ŋa tabele, ya nde ndeme sa agwa bo bi-odza. ");
INSERT INTO tyx_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ngu okala ti nde gyi kara-a-kara a mpyibi bwunu we ku ookya bwihi, ya nde ayabagha bo mu okakahala mihi, bo sa bakala kunsa esee ki elagha. ");
INSERT INTO tyx_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Limatsimi ati. Kala ti nga-a-nzo aakasoolo matala ma okagya muturu, nde nkini aakasa myehene mu kuulu banyaã obulu nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Behe si likala yeelee, mu kuulu Mwana a mbwuru kughu ogya mu matala maala be ka lili a si bitsimi bi mo o.» ");
INSERT INTO tyx_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mu obo Piere áfwulu nde ti: «Mfumu, we yini a mu bihi aati nkumu oyo, bwunu we mu baara bwohono?» ");
INSERT INTO tyx_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mfumu ábvuhulu nde ndiri: «Nande li musala wu aakakebe ya aakasalala bilogho bi mfumu a nde wu mayele ya wu bakughu osa kana mu nde, wu ootwulu mfumu mukwuru a basala ba nde, mu kuulu akagwa bo bi-odza mu matala ma mafaana? ");
INSERT INTO tyx_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Esee kundaa musala munde kala ti mfumu a nde yabvughuru ya yabagha nde mu okasala esala ekye! ");
INSERT INTO tyx_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mu engaŋma me ndyele be, mfumu munde sa agwa bilogho bi nde byehene ŋa myaã mi nde, mu kuulu nde akatala bye. ");
INSERT INTO tyx_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lo kala ti musala munde tsimi bu: “Mfumu a me li mu ogyili”. Ya kala nde baana odzwa basala babake baba babaghala ya baba bakaha nkubu, kala ti nde bwi mu odza, oŋma ya okolo mala, ");
INSERT INTO tyx_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mfumu a musala munde sa ayabvughuru ensihibi mu etsughu ya matala maala nde ka agyahaba o. Nde sa agwini a nde nkubu yi luru, sa abagha masyeme mamo ya baara ba bagwene a kana. ");
INSERT INTO tyx_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Musala wu gyahaba mi okadzyi mfumu a nde, lo kwono ogyighili dzyi li nde, sa bakaha nde nswa-nswa yi alagha. ");
INSERT INTO tyx_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lo munde wu gwene gyahaba mi okadzyi mfumu a nde ya gyighili mandagha ma makughu osa ti bakaha nde nswa-nswa, ka badzwa nde nkubu yi alagha o. Sa basagha bi bilagha kundaa munde wu baagwi bi bilagha. Sa baluomo bi biluru kundaa munde wu baagwi bi bibvulu.» ");
INSERT INTO tyx_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Me aayantsili mbaa ŋa yulu a nsie. Me áli ndzyi omono mbaa oyo yimaalughulu. ");
INSERT INTO tyx_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Oli a liboghoro li mfaana me obagha, ya mukolo a me li a mbaa mu obaabagha lo! ");
INSERT INTO tyx_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Be bu litsimi ti me edzuunu aayangwa ŋa nsie? Pele! Me bu ndyele be: Me aangyi mu okabala baara. ");
INSERT INTO tyx_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mu kuulu, obaana etsughu kii lolo dzumu lili baara bataana sa likaghaba, nkolo mõ baara batere, nkolo yinke baara buolo: ");
INSERT INTO tyx_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Munkaghaba sa akala ŋa kara li taara ya mwana a nde wu baghala, ŋa kara li mwana wu baghala ya taara a nde, ŋa kara li ngughu ya mwana a nde wu mukaha, ŋa kara li mwana wu mukaha ya ngughu a nde, ŋa kara li bako ba bakaha bo-a-bo.» ");
INSERT INTO tyx_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yiisu áfirilyele kunda mpwumu a baara bu: «Ŋa liikamono be edzi kii epyini ku ookadzyama tala, mu matala maana mamo be liikalyele ti: “Mvulu sa anoõ”. Ya ookakala obo. ");
INSERT INTO tyx_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ya ŋa liikamono be efulu ki eekafa ku Sude, be liikalyele: “Lolo mwiĩ sa agyighili obala”. Ya ookakala obo. ");
INSERT INTO tyx_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Be baara ba lili fughuru-fughuru! Be ligyahaba okabaghala mandagha ma liikamono ku yulu ya ŋa nsie ŋa. Mu emakye liikuono obaghala mandagha ma mali mu oluru mu matala ma?» ");
INSERT INTO tyx_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Mu emakye be beme liikakuono obaghala mandagha mama bunsumu? ");
INSERT INTO tyx_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mu matala ma li mu okagye we kundaa nsughu a lamana ya mutaara a we, sa myehene mu ogwihini ya nde ŋaala be nkini mu nzili. Kala pele, mbwuru munde sa abiri we kundaa nsughu a lamana, ya nsughu sa agwa we ku myaã mi bambumbulu mu kuulu balo we mu boloko. ");
INSERT INTO tyx_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Me ndyele be, we ka pala mu boloko o, kala ti we ka mana ofiri ebyimi kyehene o.» ");
INSERT INTO tyx_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mu matala maana mamo, ndaama a baara báyalyele Yiisu mi míbwi mu basi Ngalile ba ódzwi Pilate, mu matala ma bákatsughu bo bikaba. ");
INSERT INTO tyx_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yiisu ábvuhulu bo ti: «Be bu litsimi ti basi Ngalile babo bámono mpara oyo, mu kuulu bo bábvulu a masumu mu baara bwohono baba mu Ngalile? ");
INSERT INTO tyx_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pele! Lo me ndyele be, kala ti be ka ligyiŋi mayele o, be bwohono sa likpa ti bu bákpi bo. ");
INSERT INTO tyx_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Lo baara kwumu a mpuomo (18) ba bákpi ŋa óbwi nzo yi mutele yi a Silowe ŋa yulu a bo, be bu litsimi ti bo báluru baara bwohono babake baba Yerusaleme bubi? ");
INSERT INTO tyx_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pele! Lo me ndyele be, kala ti be ka ligyiŋi mayele o, be bwohono sa likpa ti bu bákpi bo.» ");
INSERT INTO tyx_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yiisu áfirita nkumu yi: «Baghala mutsyini áli ákunu mufinge mu nseghe a nde yi a bviini. Etsughu etsyini nde áyasagha bimburu, lo ka ábagha elogho o. ");
INSERT INTO tyx_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mu obo nde ályele kundaa musala a nseghe a bviini ti: “Mibvu ayi mitere mi ndi mu okayasagha me bimburu mu mufinge wu, lo ka ndi mu okabagha elogho o. Kpaa nde! Mu emakye nde ali mu okakala nsie kuu bwunu?” ");
INSERT INTO tyx_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Lo musala ábvuhulu kundaa nde ti: “Mfumu, mafirinyaã nde mubvu wu. Me sa nsimi nde mu bele-a-bele, ya me sa ndo nde mbwoho, ");
INSERT INTO tyx_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","nkini-a-nki buru bimburu mu bitsughu bi biigya. Kala pele, sa kpaa o we nde”.» ");
INSERT INTO tyx_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mu etsughu kii sabate, Yiisu ákaluo mu nzo a lisamana a ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Omo óli a mukaha mutsyini wu áali a mufulu wu mubi wu áagwi nde epfwumu, mu bamvulu kwumu a mpuomo (18). Ebughu e nde éli ekorono ya nde ka ákakughu otemene nsumu o. ");
INSERT INTO tyx_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yiisu bu amono nde, áti nde mbili ya ályele kundaa nde ti: «Mukaha, baakwulu we mu epfwumu e we». ");
INSERT INTO tyx_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ŋa mbihi oŋo nde ánaã nde myaã. Mu matala maana mamo, mukaha átemene nsumu ya ábwi okasyighi Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lo mukwuru a nzo a lisamana a ba-Dzwife ákolo nkehe mu kuulu Yiisu ádzuhu mbwuru mu etsughu kii sabate. Mu obo, nde ályele kundaa mpwumu a baara ti: «Bihi-a-be bitsughu bisemene lili a bye bibi esala. Liikayasagha libughu mu bitsughu bibye, lo ka mu etsughu kii sabate o.» ");
INSERT INTO tyx_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mfumu ábvuhulu kundaa nde ndiri: «Be lili baara baba bifa byele! Mu etsughu kii sabate, nande ŋa kara li be aagwene okanyana ngoomo bwunu we aane a nde swe ŋa ebini ki aakadza nde mu oyigwa nde madza aŋma? ");
INSERT INTO tyx_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ya mwana a Abarahame wu mukaha wu, bamvulu kwumu a mpuomo (18) bamaaluru, obaana bu ókuru nde Satana minkana. Mu obo, bubi mu bu aanyana me nde minkana mimye mu etsughu kii sabate?» ");
INSERT INTO tyx_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ŋaala nde mu okabili obo, mitaara mi nde mímono budzwa, lo mpwumu a baara yímono esee mu mandagha ma manene ma mabwe ma ókasa Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mu obo, Yiisu áfirilyele ti: «Mu nki efaana Emfumu e Nzaami eli, ya emakye me nkughu obvughu kye? ");
INSERT INTO tyx_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kye efaana ya liburu li mutaade li ókunu mbwuru mu ebwa e nde. Bu lilughubu, likulu ya likighiri muti, mu obo baŋmini baba yulu báyatwu manzo mu mampala ma nde.» ");
INSERT INTO tyx_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yiisu áfirilyele ti: «Ya emakye me nkughu obvughu ya Emfumu e Nzaami? ");
INSERT INTO tyx_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kye efaana ya pfini li ólo mukaha mutsyini ya ábvughu lo ya makaba matere mama farine. Mu obo nkpaŋa yohono yíkumu.» ");
INSERT INTO tyx_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ŋa ókagye Yiisu ku Yerusaleme, nde ákabulusomo mu mabvulu ya mu mala, ya ákabululuo. ");
INSERT INTO tyx_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mbwuru mutsyini áfwulu nde ndiri: «Mfumu, yini a mana ndaama a baara akala baabvwughu?» Yiisu ágwi bo mvuru yi: ");
INSERT INTO tyx_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Lisa makpa lisomo mu muŋma a nzo wu a sala. Mu kuulu, me ndyele be yo, balagha akala baasagha osomo lo bo ka baleene o.» ");
INSERT INTO tyx_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","«Etsughu eli mu ogya, kiili nga-a-nzo sa atemene ya sa akuru yo. Mu obo be sa likala ku mbala, sa libaana okoboro nzo ya olyele ndiri: “Mfumu, dzubulu bihi nzo!” Lo nde sa abvuhulu be bu: “Me ka ngyahaba ku liifi be o!” ");
INSERT INTO tyx_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mu obo be sa lilyele nde: “Bihi ali liikadza ya okaŋma emõ ya we, ya we aakaluo mu minsagha mi bihi!” ");
INSERT INTO tyx_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lo nde sa abvuhulu kundaa be bu: “Me ka ngyahaba ku liifi be o! Ligye la ya me, be bwohono ba lili mu okasa bubi!” ");
INSERT INTO tyx_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Oko sa okala a bilili ya nkerene a myini, mu matala ma liimono be Abarahame, Idzake ya Dzakobe ya mibighili myehene, babwi nsini mu Emfumu e Nzaami, lo be bapaha be ku mbala. ");
INSERT INTO tyx_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Baara balagha baafa ku esete ya ku wesete, ku nore ya ku sude, sa basomo kunsa malagha ma odza mu Emfumu e Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ya mono, baara babake ba bali binsiele-mbihi sa bakala baba nsomo, ya ba bali baba nsomo sa bakala binsiele-mbihi.» ");
INSERT INTO tyx_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mu matala maana mamo, ndaama a ba-Faridzyẽ yígyi kundaa Yiisu ya yílyele nde ti: «Mara ŋa, gye o we, mu kuulu Erode dzyi odzwa we.» ");
INSERT INTO tyx_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Lo Yiisu ágwi bo mvuru yi: «Ligye liyilyele mubagha munde bu: “Mono, me ndi mu obyi mifulu mi mibi ya odzuhu babyele lolo, ya mbala, ya etsughu kii bitere, esala e me sa efa”. ");
INSERT INTO tyx_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Lo me mfaana osa esala e me lolo, mbala ya mbaala ŋa epala, mu kuulu yini a ŋa Yerusaleme bafaana odzwa mubighili, ka oli nkolo nkimi o.» ");
INSERT INTO tyx_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Yerusaleme, Yerusaleme! We wu aakadzwa mibighili ya wu aakadzwa mu mameẽ babo ba ookagweghe Nzaami kundaa we. Lo mu nswe matala, me aakansagha obvughu baana ba we ti bu ookabvughu nsuhu baana ba nde kunsa mapaba. Lo be ka liikadzyi o. ");
INSERT INTO tyx_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mono, Nzaami sa atyeghe nzo a be ebughu. Me ndyele be yo, be ka lifirimono me o, tee matala ma liilyele be ti: Liseme likala mu munde wu li mu ogya mu nkwumu a Mfumu.» ");
INSERT INTO tyx_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mu etsughu emõ kii sabate, Yiisu áli áyadza ku nzo a mukwuru ba-Faridzyẽ mutsyini. Ba-Faridzyẽ bákagyighili otala nde. ");
INSERT INTO tyx_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mbwuru mutsyini wu áli a bubyele baba bituru ágyi ŋa nkulu a Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yiisu áfwulu baluo-mikyene ya ba-Faridzyẽ ti: «Bunu, oli a muswa wu odzuhu mbwuru mu etsughu kii sabate, bwunu we pele?» ");
INSERT INTO tyx_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lo bo ka bábvuhulu ndagha o. Mu obo, Yiisu ákwara mubyele, ádzuhu nde ya ályele nde abvughuru ku nzo. ");
INSERT INTO tyx_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ŋa mbihi oŋo, Yiisu ályele kundaa bo ti: «Nande mu be wuulu kala ti mwana a nde wu baghala, bwunu we ngoomo a nde bwi munsa dzunu li madza mu etsughu kii sabate, ka apaha nde maswa-maswa o?» ");
INSERT INTO tyx_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bo ka bákughu ogwa nde mvuru mu ndagha oyo o. ");
INSERT INTO tyx_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yiisu bu amono ti baara ba óti mu-Faridzyẽ mbili mu oyadza bákasuolo bibini bibi nsomo, nde ályele kundaa bo ti: ");
INSERT INTO tyx_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Kala ti mbwuru ti we mbili mu ogye ku mabala, ka ayibwa nsini ŋa ebini kii nsomo o. Nkini-a-nki baati mbwuru mukimi wu luru we bunene mbili. ");
INSERT INTO tyx_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ya mbwuru wu aati be bansa buolo mbili anyaã oyalyele we ndiri: “Gwa nde ebini ki”. Mu obo, we sa mono budzwa mu oyibwa nsini ŋa ebini kii masini. ");
INSERT INTO tyx_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lo, kala ti bati we mbili, gye yibwa nsini ŋa ebini kii masini, mu kuulu mu matala ma ogya munde wu aati we mbili, nde sa alyele kundaa we ti: “Ndughu a me, kumu ŋa yulu ŋa!” Mu obo, we sa kala a budziri ŋa mihi mi baara bwohono ba bali mu odza ya we. ");
INSERT INTO tyx_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mu kuulu, munde wu aasagha oseŋene mu endeme, sa babvurulu nde linsie, ya munde wu aabvughuru linsie, sa baseene nde.» ");
INSERT INTO tyx_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yiisu ályele si kundaa munde wu áati nde mbili ndiri: «Ŋa aakadza we mu mwiĩ, bwunu we mu nkonkolo, ka akata bandughu ba we mbili o, si okala banaana ya bambwee ba we, taara ya ngughu a we, bisini bi bili bitaa-taa ya we o, mu kuulu boho si sa babvurulu we mi aagyighili we bo. ");
INSERT INTO tyx_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Lo, kala we dzyi odza malagha, ta bawele, banga-a-bipfwumu, bikara ya binkpa-mihi mbili. ");
INSERT INTO tyx_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mu obo, we sa kala a esee mu kuulu bo ka bali a elogho ki baabvurulu we o. Yini a Nzaami akala aabvurulu we bye, mu matala ma oosighili baba bunsumu mu lipfu.» ");
INSERT INTO tyx_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bu amana ogyughu mandagha mamo, mbwuru mutsyini wu áabwi nsini ya Yiisu ályele kundaa nde ti: «Esee kundaa munde wu akala aadza mu malagha mama Emfumu e Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yiisu ályele kundaa nde ndiri: «Mbwuru mutsyini ási malagha ya áti baara balagha mbili. ");
INSERT INTO tyx_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Matala ma odza bu mato, nde ágweghe musala a nde mu oyilyele bo bu: “Ligya, mu kuulu bilogho byehene biikughu”. ");
INSERT INTO tyx_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Lo bo bwohono mu etsimi emõ, bábaana ogwa mabwu. Wu a nsomo ályele nde ti: “Me aanswumu nseghe ya me mfaana oyitala yo. Me mbuono we, sa me kolokolo”. ");
INSERT INTO tyx_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mukimi ályele nde ndiri: “Me mfi ku oswumu bangoomo kwumu, ya me ndi mu nzili mu oyigyeele bo. Me mbuono we, sa me kolokolo”. ");
INSERT INTO tyx_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ya mukimi si ályele ti: “Me bu bu nkie, mu obo, me ka nkughu ogya o.” ");
INSERT INTO tyx_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Musala munde ábvughuru kundaa mfumu a nde ya ályele nde myehene mimye. Mu obo mfumu ákolo nkehe ya ályele kundaa musala a nde ti: “Sa maswa, gye mu bibini bi ookabvuŋunu baara bwohono, ya mu minsagha mimi munsa bvulu, gya a me ŋa bawele, ba banga-a-bipfwumu, binkpa-mihi ya bikara.” ");
INSERT INTO tyx_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Musala ályele kundaa nde ti: “Mfumu! Me aansi bu aatumu we, lo nkini ya bibini mu nzo.” ");
INSERT INTO tyx_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mu obo, mfumu ályele kundaa nde bu: “Gye mu manzili ya kunsa bibolo, sa myehene, tsiini baara basomo mu nzo a me mu kuulu yo yilwulu.” ");
INSERT INTO tyx_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Me ndyele be bu, mu baara ba aanti me mbili nsomo, si mumõ mu bo ka adza bilogho mu kyiri e me o.» ");
INSERT INTO tyx_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mu kuulu mampwumu ma baara mákanama Yiisu, nde ákaghala ya ályele kundaa bo ti: ");
INSERT INTO tyx_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Mbwuru wu dzyi ogya kundaa me, ka kughu okala enduono e me o kala ti nde ka bele taara ya ngughu, mukala, baana, bambwee ya banaana ba nde ba bakaha ya ba babaghala, ya laama li ndeme o. ");
INSERT INTO tyx_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ya munde wu bihi obiri kuruwa li nde ya onama me, ka kughu okala enduono e me o. ");
INSERT INTO tyx_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mu kuulu, ŋa kara li be mbwuru wu dzyi otwu nzo yi mutele, emakye aatswama okasa? Nsomo-a-nsomo, nde sa abwa nsini, ya sa atsimi mu mutala a nzi wu a faana, ya mu otala kala ti nde kughu omana yo. ");
INSERT INTO tyx_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kala pele, kala ti nde baana bitsini bi bibagha bi yo, ya kwono omana yo, baara bwohono ba baamono yo sa basebe nde ya balyele ndiri: ");
INSERT INTO tyx_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Mbwuru munde aabaana otwu nzo, lo aakwono omana yo”. ");
INSERT INTO tyx_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Bumõ si kundaa mukogho wu li a bambumbulu mafwunu kwumu (10 000), kala ti dzyi odzwana mvulu ya mukogho mukimi wu li a bambumbulu mafwunu makwumu muolo (20 000), ema aatswama osa? Nsomo-a-nsomo, nde sa abwa nsini ya atsimi kala ti nde kughu oyibwana a munde wu aayabaana nde mvulu. ");
INSERT INTO tyx_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kala nde mono ti ka akughu o, nde sa agweghe nde ntumu buulu bagwihini mu osa eyeŋe, ŋaala wu muke nkini la. ");
INSERT INTO tyx_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mu obo, nswe mbwuru ŋa kara li be ka kughu okala enduono e me o, kala ti nde ka asihi bilogho bi nde byehene o.» ");
INSERT INTO tyx_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Mungba li elogho ki ebwe, lo kala ti ntyere a nde yifi, bunu-a-bo bakughu ofiribvurulu nde yo? ");
INSERT INTO tyx_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nde ka aafirisyili a esala o, ngu okala mu nsie, bwunu we mu mbwoho. Lo baakatsili nde ku mbala. Nyaã munde wu li a matswi mu ogyughu, agyughu!» ");
INSERT INTO tyx_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Etsughu etsyini, mintolo-mpagha ya banga-a-masumu bákayabehene bo bwohono kundaa Yiisu mu ogyughu nde. ");
INSERT INTO tyx_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ba-Faridzyẽ ya baluo-mikyene bákaŋuŋunu ya bákalyele ndiri: «Mbwuru wu li mu okagyagha banga-a-masumu ya li mu okadza ya bo.» ");
INSERT INTO tyx_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Lo Yiisu áti bo nkumu yi: ");
INSERT INTO tyx_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Nande ŋa kara li be kala ti nde li a bindoomo nkama (100), ya kala ti etsyini edzimini, nde ka abulusihi makwumu-wa ya wa (99) bibike ku syehe mu oyisagha emõ ekye ki eedzimini tee ŋa aayimono nde kye o? ");
INSERT INTO tyx_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kala ti nde mono kye, nde sa akala a esee, sa atwulu kye ŋa yulu a bisaŋama bi nde. ");
INSERT INTO tyx_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ya bu ayabvughuru ku nzo, nde sa ata bandughu ba nde mbili ya ba bali bitaa-taa bibye, ya sa alyele kundaa bo ti: “Ligya likala mu esee ya me, mu kuulu me aamono endoomo e me ki ali eedzimini.” ");
INSERT INTO tyx_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Me ndyele be ti mu mayulu si bumõ, kala mbwuru yini a mumõ gyiŋi mayele, sa bamono esee ki eluru ki baakamono mu baara makwumu-wa ya wa (99) ba bali bunsumu ba bagwene a nzala a ogyiŋi mayele.» ");
INSERT INTO tyx_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Bwunu we, kala ti mukaha li a mipara mimi bisyeẽ kwumu, ya mupara mutsyini dzimini, lo nde ka anahaba mwindi, ka akwomo nzo ya okabulusagha nde ya bunkere tee ŋa aamono nde mupara mu nde o? ");
INSERT INTO tyx_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ŋa aamono nde mupara, sa ata bandughu ba nde mbili ya ba bali bitaa-taa bibye, ya olyele bo ndiri: “Liyakala mu esee ya me, mu kuulu me aamono mupara a me wu ali aadzimini.” ");
INSERT INTO tyx_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Bumõ si, me ndi mu olyele be, bangye-yulu ba Nzaami baakamono esee mu yini a nga-a-masumu mutsyini wu gyiŋi mayele.» ");
INSERT INTO tyx_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yiisu áfirilyele bu: «Baghala mutsyini áli a baana buolo ba babaghala. ");
INSERT INTO tyx_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mbwee ályele kundaa taara a nde ti: “Taara, gwa me kaba lili busini lili ndaa me”. Mu obo taara ákaba bo busini bu nde. ");
INSERT INTO tyx_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mana bitsughu bu biluru, mwana wu baghala wu a sala átolo byehene bi áli a bye ya ágyene ku nsie yi a la. Oko nde ábyihi busini bu nde mu laama lili bisee. ");
INSERT INTO tyx_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bu agyehe nzi a nde yohono, nde ásyili myaã-a-myaã. Ewala ki enene égyi mu nsie oyo, ya nde ábaana okpa nzala. ");
INSERT INTO tyx_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mu obo, nde áyisagha esala kundaa musi nsie oyo mutsyini. Nde ágweghe nde ku ebiri mu okabulukebe bangubulu. ");
INSERT INTO tyx_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mu nkooro a nzala, nde ádzyi ogyughuru mu bi-odza bi bangubulu, lo ka óli a mbwuru wu aagwa nde bye o. ");
INSERT INTO tyx_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mu obo, nde ábaana otsimi ya obili bu: “Basala ba taara a me bwohono baakadza bu badzyi, lo me ŋa ndi mu okakpa nzala. ");
INSERT INTO tyx_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Me sa ntemene, sa ngye kundaa taara a me, ya sa ndyele nde bu: Taara, me aansi masumu kundaa Nzaami ya kundaa we. ");
INSERT INTO tyx_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ka bafaana ofirita me mwana a we o, gwolo me ti mumõ ŋa kara li basala ba we.” ");
INSERT INTO tyx_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nde átemene ya ágyene kundaa taara a nde.» «Ŋaala nde nkini la, taara a nde, átaala nde, nyiĩ yíbagha nde. Ábara ntyini, áyibwumu nde ya ányuburu nde. ");
INSERT INTO tyx_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwana ályele kundaa nde ti: “Taara a me, me aansi masumu kundaa Nzaami ya kundaa we, ka bafaana ofirita me mwana a we o”. ");
INSERT INTO tyx_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Lo taara ályele kundaa basala ba nde ti: “Lisa maswa, liyabiri me enkuru ki eluru bubwe ya lilaha nde kye. Lilaha nde mulwu mu mulyeme, ya bikoghoro mu myili. ");
INSERT INTO tyx_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ligya a pulu li ngoomo lili maala, lidzwa lo. Litswe lidza ya likala kunsa esee. ");
INSERT INTO tyx_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mu kuulu mwana a me wu áli ákpi, lo aasighili mu lipfu, áli ádzimini, lo aafirimoŋono”. Ya bábaana osa kyiri.» ");
INSERT INTO tyx_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Mu matala mamo, mwana wu mukwuru áli munsa nseghe. Nde bu ayabvughuru, áyabehene ya nzo, ya nde ágyughu nkele a bikwumu ya makini. ");
INSERT INTO tyx_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nde áti musala mutsyini mbili ya áfwulu ndiri: “Nki ndagha yili mu okaluru mu nzo?” ");
INSERT INTO tyx_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Musala munde ábvuhulu nde bu: “Mbwee a we aayabvughuru, ya taara a we aatumu badzwa pulu li ngoomo lili maala bu aamono nde ti nde aagyi bunsiili”. ");
INSERT INTO tyx_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nde ákolo nkehe ya ábihi osomo mu nzo. Taara a nde ápala mu obuono nde asomo mu nzo. ");
INSERT INTO tyx_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Lo nde ábvuhulu kundaa taara a nde bu: “Mono, bamvulu balagha me ndi mu okasalala we. Me nkini ámaambihi osa litumu li we o. Lo we nkini ámaagwa me si mwana a ntaba mu osa kyiri ya bandughu ba me o. ");
INSERT INTO tyx_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lo mu matala ma oyabvughuru mwana a we wu wu aamana busini bu we bwohono mu okabulutaama ya bakaha banga-a-enkwunu, we aatumu badzwa pulu li ngoomo lili maala mu nkooro a nde!” ");
INSERT INTO tyx_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Taara ályele kundaa nde ti: “Mwana a me, we li ya me matala mwohono. Bilogho bi me byehene bili bibi ndaa we. ");
INSERT INTO tyx_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ali lifaana okala kunsa kyiri ya esee, mu kuulu mbwee a we áli ákpi, ya aasighili mu lipfu, nde áli ádzimini, ya aafirimoŋono.”» ");
INSERT INTO tyx_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yiisu ályele si kundaa binduono bi nde ti: «Óli a esini etsyini ki éli a musala wu aakakebe ya aakasalala bilogho bi mfumu a nde. Báyalyele nde ti musala a nde ákabyihi busini bu nde. ");
INSERT INTO tyx_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mu obo, Mfumu áti nde mbili ya ályele kundaa nde ti: “Mamo nki mandagha me ndi mu okagyughu mu nyuru a we? Suo me bu aasi we esala e we, mu kuulu we ka kughu ofirikala musala wu aakakebe ya aakasalala bilogho bi me o.” ");
INSERT INTO tyx_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Musala munde átsimi mu mukolo a nde ndiri: “Bunu-abo me aansa, buulu mfumu a me me aamaha mu esala? Me ka ndi a makpa mu osala esala kii manseghe o. Ya okabululuomo nzi kundaa baara, me sa mono budzwa! ");
INSERT INTO tyx_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa! Me ngyahaba emakye me aansa, mu kuulu baara bagyagha me mu manzo ma bo mu matala ma baamaha me mu esala.” ");
INSERT INTO tyx_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mu obo, bu ati mbwuru-mbwuru mbili mu ba báli a ebyimi ya mfumu a nde, nde áfwulu wu a nsomo bu: “Ebyimi kii kpe we li a kye ya mfumu a me?” ");
INSERT INTO tyx_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mbwuru munde ábvuhulu nde ti: “Batono nkama (100) baba maala”. Musala ályele nde ndiri: “Ma mukaana a we wu a ebyimi, bwa nsini mu maswa ya sono: Batono makwumu mataana (50).” ");
INSERT INTO tyx_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ŋa mbihi oŋo, nde ályele kundaa wu muke ndiri: “Lo we, ebyimi kii kpe we li a kye”? Nde ábvuhulu nde bu: “Me ebyimi kii basaake nkama (100) baba bimburu bi bele”. Musala ályele kundaa nde ti: “Ma mukaana a we wu a ebyimi ya sono bu: basaake makwumu mpuomo (80)”. ");
INSERT INTO tyx_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mfumu ásyighi musala munde wu mubi mu nkooro a mayele ma nde. Mu engaŋma basi nsie baluru mayele mu mandagha ma bo ya ba bali kunsa otsyeme.» ");
INSERT INTO tyx_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ya me bu ndyele kundaa be: «Nzi yiikapfiri baara balagha, lo be lisalala yo mu kuulu likala a bandughu. Mpaala mu matala ma oofa nzi oyo, sa bagyagha be mu manzo mu bamvulu ya bamvulu. ");
INSERT INTO tyx_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mbwuru wu aakagyughu mfumu a nde mu mandagha ma masala, aakagyughu nde si mu mandagha ma manene, wu aagwene okagyughu nde mu mandagha ma masala, ka akala aagyughu nde si mu mandagha ma manene o. ");
INSERT INTO tyx_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mu obo kala ti be ka lili a yughu o mu busini baba gwene a bunsumu, nande aasa kana mu be mu busini baba engaŋma? ");
INSERT INTO tyx_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ya kala ti be ka lili a yughu mu bilogho bi mbwuru mukimi o, nande aagwa be bibi ndaa beme? ");
INSERT INTO tyx_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ka oli a musala wu kughu osalala bamfumu buolo o. Kala pele, nde sa abele mutsyini ya sa adzyi wu muke, bwunu we sa anabara mu mumõ ya sa abele wu muke. Be ka lifaana osalala Nzaami ya nzi o.» ");
INSERT INTO tyx_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ba-Faridzyẽ ba baakadzyi nzi, bu bagyughu myehene mimye, bo bákasa Yiisu munsensehẽ. ");
INSERT INTO tyx_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yiisu ályele kundaa bo ndiri: «Be lili mu okasa mandagha mpaala limoŋono ti be lili bunsumu ŋa mihi mi baara, lo Nzaami gyahaba mikolo mi be, mu kuulu mandagha ma ookamono baara ti mali ma manene, mali mandagha ma maluru bubi ŋa mihi mi Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Mikyene ya mibighili míkala tee mu matala mama Dzã. Obaana oŋo, bali mu otsala Nsia yi Mbwe yi a Emfumu e Nzaami, ya nswe mbwuru li mu osa makpa mu osomo mu Emfumu ekye. ");
INSERT INTO tyx_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yulu ya nsie bikughu oluru, lo ŋa kara li Mikyene, si mpiri nsyini ka yimara o.» ");
INSERT INTO tyx_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Nswe baghala wu dzwi bala ya mukala a nde ya kie mukaha mukimi, nde si bukala, ya nswe baghala wu kie mukaha wu aadzwi bala ya mulumu a nde, si bukala.» ");
INSERT INTO tyx_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Áli oli a baghala mutsyini wu esini. Nde ákalaha biko bi bibwe ya bibi ntala. Nswe etsughu nde ákasa malagha. ");
INSERT INTO tyx_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Óli si ya muwele mutsyini wuulu áli ágyoŋomo ŋa muŋma a ekagha e nzo a esini, nkwumu a nde áli Ladzare, ya nyuru a nde áli yílwulu mu biboõ. ");
INSERT INTO tyx_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ya nde ákadzyi otolo yini a mpfi-mpfihini a bi-odza yi áakabwa ku nsie a tabele li esini ekye. Ya bambwa si bákayalyere biboõ bi nde. ");
INSERT INTO tyx_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Muwele ákpi ya bangye-yulu bábiri nde kundaa Abarahame. Esini si ékpi ya bádzyighi kye. ");
INSERT INTO tyx_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ya ku nsie a ba bákpi, nde ákamono kimini li lilagha. Bu asiili mihi, átaala Abarahame ku la, ya Ladzare ŋa nkara a nde. ");
INSERT INTO tyx_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nde ákehe engubu ndiri: “Abarahame, taara me, mono me nyiĩ, ya gweghe Ladzare atsubu mbunu a mulyele a nde mu madza ya abwoho me nzalisogho, mu kuulu me ndi mu okamono kimini lilagha munsa mbaa yi.” ");
INSERT INTO tyx_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abarahame ábvuhulu nde ti: “Mwana a me, libili mweẽ ti we áali a busini bulagha mu bumweẽ bu we, ya Ladzare áli kunsa kimini. Mu matala ma, bali mu obuono nde kunu, lo we li mu omono kimini. ");
INSERT INTO tyx_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gyahaba ti, mu matala ma oli ya mbie yi nene ŋa kara li bihi-a-be. Mpaala baara ba badzyi omara kunu mu ogya kundaa be ka baleene o, ya ba bali kundaa be ka baleene si osaghaba yo mu ogya kunu o.” ");
INSERT INTO tyx_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Esini élyele ndiri: “Taara, me mbuono we, gweghe Ladzare agye ku nzo a taara a me, ");
INSERT INTO tyx_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mu kuulu me ndi a bambwee bataana. Nde agye ayilyele bo mpaala bo si banyaã ogya ku ebini kii kimini ki.” ");
INSERT INTO tyx_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abarahame ábvuhulu nde bu: “Bo bali a Moyidze ya mibighili. Bafaana ogyughu bo!” ");
INSERT INTO tyx_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ya esini ébvuhulu nde ndiri: “Pele, taara Abarahame. Kala ti mbwuru wu ákpi gyene kundaa bo, bo sa bagyiŋi mayele.” ");
INSERT INTO tyx_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Lo Abarahame ábvuhulu kundaa nde bu: “Kala ti bo ka bagyughu Moyidze ya mibighili o, si okala ti mbwuru wu ákpi sighili mu lipfu, bo akala ka bagyughu nde si o.”» ");
INSERT INTO tyx_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yiisu ályele kundaa binduono bi nde ti: «Mandagha ma maakasa ti baara babwa mu lisumu ka makughu ogwene o. Lo nyiĩ kundaa munde wu aakala mpeene yi maagya mo! ");
INSERT INTO tyx_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ali oluru bubwe kundaa nde bakwighi nde limeẽ li linene mu bolo ya batsili nde mu mubu, ya bu abwihi mu lisumu mumõ ŋa kara li bike-bike bi. ");
INSERT INTO tyx_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Be beme lisa mayele. Kala ndughu mu kana bwi mu lisumu, fyeẽ nde. Kala ti nde gyiŋi mayele, sa nde kolokolo. ");
INSERT INTO tyx_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ya kala ti nde si we bubi nsa nsaama mu etsughu, ya kala ti mu nsa nsaama oyo nde gyi mu olyele we ti: “Me aanyoõ bu aansi we bubi”, sa nde kolokolo.» ");
INSERT INTO tyx_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bantumu bályele kundaa Yiisu ti: «Mfumu gwa bihi kana lili ngo lo.» ");
INSERT INTO tyx_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mu obo Mfumu ályele kundaa bo ndiri: «Kala ti be lili a kana ti liburu li mutaade, be likughu olyele kundaa muti wu a sikomore ti: “Tuŋumu ya midza mi we ya gye yibwa mu mubu!” Ya nde sa agyughu be.» ");
INSERT INTO tyx_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Nande ŋa kara li be kughu olyele kundaa musala a nde wu aakasala mu manseghe ma nde, bwunu we wu aakakebe mikaã mi nde, ŋa aafa nde ku manseghe bu: “Gya maswa-maswa, bwa nsini, ya dza?” ");
INSERT INTO tyx_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pele! Lo nde bu aalyele kundaa nde: “Naŋa me bi-odza, laha biko bibi esala ya gwa me bi-odza. Me mana odza ya oŋma, ŋa mbihi oŋo we kughu odza ya oŋma.” ");
INSERT INTO tyx_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Lo liimaamono ti mfumu bvurulu matuono kundaa musala a nde mu kuulu aakagyighili mi aakatumu nde? ");
INSERT INTO tyx_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Behe si bumõ, ŋa liimana osa myehene mi baatumu be osa, lilyele bu: “Bihi lili basala ba bagwene a mupfunu, bihi liigyighili yini a mamo ma lifaana ogyighili.”» ");
INSERT INTO tyx_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ŋaala Yiisu mu okagye ku Yerusaleme, nde áluru mu milili mi etsulu e nsie kii Samari ya kii Ngalile. ");
INSERT INTO tyx_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ŋa ákasomo nde munsa bula butsyini, banga-a-buala kwumu báyabwana a nde. Bátemene la-la ");
INSERT INTO tyx_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ya bákehe engubu: «Yiisu, Muluo, mono bihi nyiĩ!» ");
INSERT INTO tyx_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bu amono bo, nde ályele kundaa bo ti: «Ligye liyisuo manyuru kundaa bangaa ba nzaami.» Ŋa báli bo nkini mu okagye, bo bámono ti bo baadzughu. ");
INSERT INTO tyx_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mumõ ŋa kara li bo bu amono ti nde aadzughu, áyabvughuru ya ákasyighi Nzaami mu yulu. ");
INSERT INTO tyx_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nde ápfumunu busu mu nsie ŋa myili mi Yiisu ya ábvurulu nde matuono. Baghala munde áli musi Samari. ");
INSERT INTO tyx_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yiisu áfwulu ti: «Bunu, bo bansa kwumu ka baadzughu o? Bu wa babake kunu bali? ");
INSERT INTO tyx_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Yini a munzyi wu aayabvughuru mu ogwa Nzaami masyighi?» ");
INSERT INTO tyx_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ŋa mbihi oŋo Yiisu ályele kundaa nde ti: «Temene, gye, kana li we liibvwuhu we!» ");
INSERT INTO tyx_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ba-Faridzyẽ báfwulu nde ti nsa matala Emfumu e Nzaami eegya, nde ábvuhulu kundaa bo ti: «Emfumu e Nzaami ka eegyi ti anga elogho ki bakughu omono mu mihi o. ");
INSERT INTO tyx_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Banyaã olyele be ti: “Limono, ŋa eli”, bwunu we: “Eli kunii!” Limono, Emfumu e Nzaami eli ŋa nsa kara li be.» ");
INSERT INTO tyx_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ŋa mbihi oŋo, Yiisu ályele kundaa binduono bi nde ti: «Bitsughu sa bigya, bi likala a be nzala a omono Mwana a mbwuru, ti mu etsughu etsyini, lo akala ka liimono nde o. ");
INSERT INTO tyx_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Sa akala balyele kundaa be ti: “Nde ŋa ali”, bwunu we: “Kunii ali”. Ka ligye o, ya ka libara ntyini o. ");
INSERT INTO tyx_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mu kuulu, ti bu ookasehene mvulu ya bu aakatsehebe nde yulu nkolo ya nkolo, me obo si bu ookala Mwana a mbwuru mu etsughu e nde. ");
INSERT INTO tyx_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lo nde faana otswama omono mpara yi alagha, ya baara ba eseene ki sa babihi nde. ");
INSERT INTO tyx_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mi míluru mu matala mama Nowe sa miluru mu etsughu ki oogya Mwana a mbwuru. ");
INSERT INTO tyx_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Baara bákadza, bákaŋma, bákakie ya bákakwehe tee mu etsughu ki ósomo Nowe munsa bwara ba bunene. Ndwuru yígyi mu nsie nsyini, ya baara bwohono báfi ekulu. ");
INSERT INTO tyx_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bumõ si mu matala mama Lote. Baara bákadza, bákaŋma, bákaswumu ya bákatyeghe, bákakunu ya bákatwuhu manzo. ");
INSERT INTO tyx_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lo etsughu ki ópala Lote munsa bvulu lili Sodome, Nzaami ánohõ mvulu wu a mbaa ya wu makele ma maakalughulu mbaa, wu áayadzwa baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Sa okala bumõ mu etsughu ki oyamoŋono Mwana a mbwuru.» ");
INSERT INTO tyx_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Mu etsughu ekye, mbwuru wu li ku yulu a see li nzo lili eyala, asughuru, anyaã osomo munsa nzo mu ogwolo bilogho. Wu aakala ku manseghe, anyaã si obvughuru ku bula. ");
INSERT INTO tyx_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Litsimi mi míbwi mu mukala a Lote. ");
INSERT INTO tyx_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Munde wu aasagha obvwuhu laama li nde sa apfihili lo. Munde wu aakihi okpa, sa akala mweẽ. ");
INSERT INTO tyx_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Me bu ndyele kundaa be: mu mpyibi oyo, mu baara buolo ba baakala ku yulu a mbughu mõ, sa babiri mutsyini ya sa basihi wu muke. ");
INSERT INTO tyx_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mu bakaha buolo ba bali mu okasighi bimburu, sa bagwolo mutsyini ya sa basihi wu muke. ");
INSERT INTO tyx_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mu babaghala buolo ba baakala munsa nseghe, sa bagwolo mutsyini ya sa basihi wu muke.» ");
INSERT INTO tyx_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Binduono bíbvuhulu nde ti: «Mfumu, mandagha mamo kunu-ako akala maaluru?» Yiisu ágwi bo mvuru yi: «Ku ookala ebyimi, me oko ku oyabvuŋunu bango-mbimi.» ");
INSERT INTO tyx_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yiisu áti bo nkumu nsyini mu osuo bo ti bafaana okasamana Nzaami matala mwohono ku ogwene okolo. ");
INSERT INTO tyx_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Mu obo, nde ályele kundaa bo ti: «Óli a nsughu-a-lamana mutsyini mu bvulu litsyini. Nde ka ákabara Nzaami o, ya ka ákagwa si mbwuru mutsyini budziri o. ");
INSERT INTO tyx_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Óli si a mupfiili mutsyini wu mukaha oko, wu áakalyele kundaa nde ti: “Tsyiri ndagha yi li ŋa kara li me ya mutaara a me.” ");
INSERT INTO tyx_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Matala malagha nsughu-a-lamana munde ábihi. Lo ŋa mbihi oŋo, nde ábili bu mu mukolo a nde: “Si okala ti me ka aakambara Nzaami o, bwunu we me ka aakangwa mbwuru si mumõ budziri o, ");
INSERT INTO tyx_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lo me ndagha a mupfiili wu aantsyiri, mu kuulu nde ka li mu okanyaã me pii o. Kala pele, nde sa akayaluhu me nkele bitsughu byehene.”» ");
INSERT INTO tyx_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mfumu áfirilyele bu: «Be liigyughu mbiili a nsughu-a-lamana munde wu mubi. ");
INSERT INTO tyx_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Lo Nzaami ka kughu otsyiri mandagha ma babo ba ásuolo nde o, ba bali mu okasyama kundaa nde mpyibi ya mwiĩ? Ya nde ka asa maswa mu obaha bo o? ");
INSERT INTO tyx_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Me bu ndyele be, Nzaami sa atsyiri mandagha ma bo maswa-maswa. Lo ŋa oogya Mwana a mbwuru, nde sa ayamono kana ŋa yulu a nsie?» ");
INSERT INTO tyx_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yiisu áfirita bo nkumu yi mu ogwa maluo kundaa baara ba baakatsimi ti bo bali kunsa bunsumu ya ba baakatsaala babake. ");
INSERT INTO tyx_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Babaghala buolo bákumu ku nzo a Nzaami yi nene mu osamana. Mumõ áli mu-Faridzyẽ, ya wu muke áli muntolo-mpagha. ");
INSERT INTO tyx_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mu-Faridzyẽ átemene ya ásamana kunsa mukolo bu: “Nzaami, me mbvurulu we matuono mu kuulu me ka ndi ti baara babake o. Bo bali banga-a-pfyibi, ba bagwene a bunsumu, ba baakabvughu mbughu ya mukala bwunu we mulumu a nganda-mbwuru, ti anga muntolo-mpagha wu. ");
INSERT INTO tyx_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Me aankankuru nswele nsa ywolo mu limiŋi, me aakangwa kaba lili kwumu mu byehene bi aakambagha me.” ");
INSERT INTO tyx_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Muntolo-mpagha áli átemene la, ya ka ábagha si bu aasiili mihi ku yulu o. Nde ákakoboro ntulu ya ákalyele ti: “Nzaami mono me nyiĩ, me ndi nga-a-masumu!” ");
INSERT INTO tyx_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Me ndyele be, muntolo-mpagha munde ábvughuru ku nzo a nde ya Nzaami ákirili nde mbwuru wu bunsumu, lo ka mu-Faridzyẽ wu o, mu kuulu munde wu aaseŋene mu endeme, sa basurulu nde linsie, ya munde wu li linsie, sa baseene nde.» ");
INSERT INTO tyx_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Baara bágyi a baana ba basala kundaa Yiisu mu kuulu nde abyeme bo. Lo binduono bi nde bu bimono obo, bífyeẽ baara babo. ");
INSERT INTO tyx_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mu obo, Yiisu áti baana mbili ya ályele ti: «Linyaã baana ba basala bagya kundaa me, ya ka likahaba bo o, mu kuulu Emfumu e Nzaami eli kii ba bafaana ya bo. ");
INSERT INTO tyx_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Me ndyele be mu engaŋma, nswe munde wu gwene okihi Emfumu e Nzaami ti mwana wu asala, ka asomo omo o.» ");
INSERT INTO tyx_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mfumu a ba-Dzwife mutsyini áfwulu Yiisu ti: «Muluo wu mubwe, emakye me mfaana osa mu obagha laama lili mibvu ya mibvu?» ");
INSERT INTO tyx_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yiisu ályele kundaa nde ti: «Mu emakye we li mu olyele ti me mbwuru wu mubwe? Ka oli a mbwuru wu mubwe o, kala ka yini a Nzaami o. ");
INSERT INTO tyx_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","We gyahaba mikyene: Ka bvughu mbughu ya mukala bwunu we ya mulumu a nganda-mbwuru o, ka dzwa o, ka turu o, ka kala mpughulu wu a mpya mu nganda-mbwuru o, gwa taara ya ngughu a we budziri.» ");
INSERT INTO tyx_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mbwuru munde ábvuhulu bu: «Obaana bumwana bu me, me aankebe myehene mimye.» ");
INSERT INTO tyx_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bu amana ogyughu nde, Yiisu ályele kundaa nde ti: «Elogho etsyini we gwene a kye: Tyeghe byehene bi li a bye, kaba nzi kundaa bawele, ya we sa kala a busini mu mayulu. Ŋa mbihi oŋo, gya, ya nama me.» ");
INSERT INTO tyx_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lo bu agyughu obo, mbwuru munde ányoõ ku olagha, mu kuulu nde áli a busini bulagha. ");
INSERT INTO tyx_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yiisu bu amono minyoõ mi nde, ályele ti: «Mpara kundaa bisini mu osomo mu Emfumu e Nzaami! ");
INSERT INTO tyx_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mu kuulu, ka oli mpara o kundaa nyama wu baakata ti syamo mu osomo mu lihi li ntuumu, lo mpara kundaa esini mu osomo mu Emfumu e Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Baara ba bákagyughu mandagha mamo bályele ti: «Mu obo, nande kughu obvwughu?» ");
INSERT INTO tyx_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yiisu ábvuhulu bu: «Miili baara ka bakughu osa o, Nzaami kughu osa mye.» ");
INSERT INTO tyx_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piere ályele ti: «Tala, bihi liisihi bilogho bi liili a bye ya liinama we.» ");
INSERT INTO tyx_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Mu obo Yiisu ágwi bo mvuru yi: «Me ndi mu olyele be ngaŋma, nswe munde wu sihi nzo, mukala, banaana ya bambwee, taara ya ngughu, bwunu we baana ba nde, mu nkooro a Empu e Nzaami, ");
INSERT INTO tyx_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nde sa abagha mi miluru mu matala ma, ya laama lili mibvu ya mibvu mu bitsughu bi biigya.» ");
INSERT INTO tyx_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yiisu bu akogho ŋa bele a nde bantumu ba nde kwumu a buolo (12), nde ályele kundaa bo ti: «Mono! Bihi-a-be ku yulu a Yerusaleme lili mu ogye. Oko myehene mi ósono mibighili mu Mwana a mbwuru sa mikeele. ");
INSERT INTO tyx_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Sa batyeghe nde ŋa myaã mi baara ba bagwene osoolo Nzaami, sa basa nde munsighi, sa batsaala nde, sa batswulu nde manteẽ, ");
INSERT INTO tyx_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ya bu bamana okaha nde nswa-nswa, sa badzwa nde. Ya etsughu kii bitere, nde sa asighili mu lipfu.» ");
INSERT INTO tyx_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lo bantumu ba nde ka bábaghala ndagha si mõ o. Bo báli kunsa nzi-nzimini. Ka bákagyahaba o bunu-a-bo mandagha mamo mákadzyi olyele. ");
INSERT INTO tyx_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mu matala ma óyabehene Yiisu ŋa bvulu lili Dzeriko, enkpa-mihi etsyini ébwi nsini mu mukogho a nzili mu okaluomo baara nzi. ");
INSERT INTO tyx_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bu agyughu mpwumu a baara yi áakaluru, nde áfwulu nki ndagha áakaluru. ");
INSERT INTO tyx_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bályele nde ti: «Yiisu musi Nadzarete li mu okaluru.» ");
INSERT INTO tyx_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mu obo, nde ákehe engubu mu yulu ti: «Yiisu, Mwana a Dabvide, mono me nyiĩ!» ");
INSERT INTO tyx_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ba báli ku nkulu báfyeẽ nde ya bályele nde akuru muŋma, lo nde ákehe bingubu bi biluru: «Mwana a Dabvide, mono me nyiĩ!» ");
INSERT INTO tyx_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yiisu bu atemene, átumu bagya a nde kundaa nde. Nde bu ayabehene, Yiisu áfwulu nde ti: ");
INSERT INTO tyx_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Emakye we dzyi me nsa mu we?» Nde ábvuhulu bu: «Mfumu, sa kuulu me firimono!» ");
INSERT INTO tyx_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mu obo, Yiisu ályele kundaa nde ti: «Firimono o we! Kana li we liibvwuhu we!» ");
INSERT INTO tyx_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mu ena kyini ekye, nde ábaana omono, ya ábwi onama Yiisu mu okabulusyighi Nzaami. Baara bwohono bu bamono obo, básyighi Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yiisu ásomo mu Dzeriko ya áluru kunsa bvulu lilo. ");
INSERT INTO tyx_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mbwuru mutsyini áli oko, nkwumu a nde Dzasye. Nde áli mfumu a mintolo-mpagha ya áli esini. ");
INSERT INTO tyx_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nde ákasagha omono Yiisu, lo nde ka ákughu o, mu kuulu nde áli mutele mupfi, ya mpwumu a baara yíkyi Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mu obo, nde ábara ku nkulu ya ákumu ku yulu a muti wu a sikomore mu omono Yiisu, mu kuulu oyo nzili yi ákaluru nde. ");
INSERT INTO tyx_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yiisu bu ayato ŋa ebini ekye, ásiili mihi ku yulu, ya ályele kundaa nde ti: «Dzasye, sughuru mu maswa, mu kuulu me mfaana ogyoŋomo mu nzo a we lolo li.» ");
INSERT INTO tyx_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dzasye ási maswa ásughuru, ya ágyagha nde ya esee. ");
INSERT INTO tyx_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mu obo, baara bwohono ba bámono mandagha mamo bákaŋuŋunu ya bákalyele ti: «Nde aayigyoŋomo kundaa nga-a-masumu.» ");
INSERT INTO tyx_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lo Dzasye bu atemene ŋa nkulu a Mfumu, ályele nde ndiri: «Mfumu, tala: me nkaba bilogho bi me ŋa kara-a-kara mu ogwa ndaama kundaa bawele. Ya kala ti me aampfiri mbwuru mu ogwolo nzi yiluru kundaa nde, me sa mbvurulu nde yo nsa na.» ");
INSERT INTO tyx_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ŋa mbihi oŋo, Yiisu ályele bu: «Lolo li baara ba baakakala mu nzo yi baabvwughu, mu kuulu wuhu si li musi dzumu lili Abarahame. ");
INSERT INTO tyx_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mu kuulu Mwana a mbwuru aagyi mu osagha ya obvwuhu baara ba bádzimini.» ");
INSERT INTO tyx_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yiisu áfirita baara ba bákagyughu nde nkumu nkimi, mu buulu nde áto ŋa bele a Yerusaleme, ya baara bákatsimi ti Emfumu e Nzaami mu matala mamo ékaamoŋono. ");
INSERT INTO tyx_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mu obo Yiisu ályele kundaa bo ti: «Mbwuru mutsyini wu budziri ágyene ku nsie yi a la mu oyibyala emfumu kii mukogho ya áyabvughuru. ");
INSERT INTO tyx_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nsomo agye, nde áti basala kwumu mbili ŋa kara a basala ba nde. Nde ágwi ŋa kara a nswe musala mupara mutsyini wu a mu oore, ya ályele bo ti: “Lita nkaala mu nzi yi tee ku aayambvughuru me.” ");
INSERT INTO tyx_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lo baara baba nsie a nde bákabele nde. Mu obo, bágweghe baara ŋa mbihi a nde mu oyilyele ku ákagye nde bu: “Bihi ka lidzyi ti nde akala mukogho a bihi o.” ");
INSERT INTO tyx_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Bu amana obyala emfumu, nde áyabvughuru. Nde áti basala ba ágwi nde nzi mbili mu ogyahaba ndaana yi bábagha bo mu nkaala. ");
INSERT INTO tyx_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wu a nsomo ágyi ya ályele ti: “Mfumu! Mupara a we aaburu mipara kwumu.” ");
INSERT INTO tyx_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mfumu ályele nde ti: “Bubwe, we li musala wu mubwe. Mu kuulu we aasi waa li me mu bilogho bi bisala, me ntwulu we mfumu a mabvulu kwumu.” ");
INSERT INTO tyx_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wu a buolo ágyi ya ályele ti: “Mfumu, mupara a we aaburu mipara mitaana.” ");
INSERT INTO tyx_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mfumu ályele nde ndiri: “Me ntwulu wehe si mfumu a mabvulu mataana.” ");
INSERT INTO tyx_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mukimi ágyi ya ályele ti: “Mfumu, mupara a we ndindi. Me ali aandwunu nde kunsa mupa a eko. ");
INSERT INTO tyx_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Me aakankala a nzalamweẽ a we, mu kuulu we li mbwuru wu a mukolo wu a kubu. We aakagwolo bilogho bi aagwene okamono we mpara, ya we aakatolo bimburu bi aagwene okakunu we.” ");
INSERT INTO tyx_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mukogho ályele nde ti: “We li musala wu mubi! Me muyala a we aansa mu mandagha ma paha weme. We gyahaba ti me ndi a mukolo wu a kubu, me aakangwolo bilogho bi aangwene okamono me mpara, ya aakantolo bimburu bi aangwene okakunu me. ");
INSERT INTO tyx_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mu emakye we aagwene oyitwulu mupara a me kundaa ba baakabunu nzi? Bu ayambvughuru me bu, me ali aankughu obagha ndaana mu nde.” ");
INSERT INTO tyx_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ŋa mbihi oŋo nde ályele kundaa ba báli oŋo ti: “Ligwohono nde mupara munde ya ligwa nde kundaa wu li a mipara kwumu.” ");
INSERT INTO tyx_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bo bályele nde ti: “Mfumu, ta nde li a mipara kwumu mimi oore!” ");
INSERT INTO tyx_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nde ábvuhulu bo ti: “Me ndyele be, sa babwehe kundaa munde wu li a bye, lo wu gwene a bye, sa bagwohono si okala mana a ndaama yi ali a nde. ");
INSERT INTO tyx_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ŋa yulu oŋo, liyabiri mitaara mi me ŋa, mi miibihi ti me nkala mukogho a mye, ya lidzwa mye ŋa mihi mi me.”» ");
INSERT INTO tyx_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bu amana obili obo, Yiisu átswama ŋa nkulu a mpwumu a baara mu okumu ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mu matala ma ábehene a nde ŋa bula baba Betefadze ya bvulu lili Betani, ŋa bele a Munguo wu a mi-Olibve, Yiisu ágweghe binduono bi nde byele ");
INSERT INTO tyx_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ya ályele bye ti: «Ligye ku bula ba buli ku nkulu. Ŋa liisomo be oko, sa limono mwana a aane bákuru ŋa muti, ya wuulu si mbwuru mutsyini nkini ámaabwa nsini ŋa yulu a nde o. Linyana nde ya ligya a nde. ");
INSERT INTO tyx_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kala mbwuru fwulu be ti: “Mu emakye be lili mu onyana nde?” Lilyele nde bu: “Mfumu li a nzala a nde.”» ");
INSERT INTO tyx_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Binduono bibye bígyene ya bímono mandagha mwohono ti bu ólyele Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ŋa bákanyana bo mwana a aane, banga-a-nde báfwulu bo mu emakye bo bákanyana mwana a aane munde. ");
INSERT INTO tyx_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bo bábvuhulu bo ti Mfumu li a nzala a nde. ");
INSERT INTO tyx_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ŋa mbihi oŋo bágyene a mwana a aane kundaa Yiisu. Bágyala biko bi bo ŋa yulu a nde ya bákuhubu Yiisu ŋa yulu a nde. ");
INSERT INTO tyx_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ŋa ókagye Yiisu, baara bákagyala biko bi bo mu nzili. ");
INSERT INTO tyx_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ŋa áli nde ŋa bele Yerusaleme mu okumunu Munguo wu a mi-Olibve, mpwumu a binduono bi nde yísomo kunsa esee ya yíbaana osyighi Nzaami mu yulu mu nkooro a bimaã bi bámono bo. ");
INSERT INTO tyx_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bo bu bákalyele: «Liseme kundaa Mukogho, munde wu li mu ogya mu nkwumu a Mfumu! Edzuunu ekala ku yulu, ya nsia yikala kundaa Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ndaama a ba-Faridzyẽ yi áli ŋa kara li mpwumu a baara yílyele Yiisu ndiri: «Muluo, tumu binduono bi we binyaã nkele.» ");
INSERT INTO tyx_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nde ágwi bo mvuru yi: «Me ndi mu olyele be, kala bye binyaã nkele, mameẽ sa makehe bingubu!» ");
INSERT INTO tyx_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ŋa óto Yiisu ŋa bele a Yerusaleme, nde álili mu nkooro a bvulu lilo, ŋa ámono nde lo. ");
INSERT INTO tyx_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nde ályele ti: «Yerusaleme, kala wehe si, we aabaghala mandagha ma makughu ogwa we edzuunu mu matala ma! Lo mu matala ma, mo mali ma másweme ŋa mihi mi we. ");
INSERT INTO tyx_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bitsughu bili mu ogya, mitaara mi we sa mitsimi miwaghala mu odzwana a we. Mye sa midziŋi we ya sa miswehẽ we nkolo ya nkolo. ");
INSERT INTO tyx_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sa mitsala we, ya sa midzwa baara ba we bwohono. Mye ka misihi si limeẽ litsyini ŋa yulu a limeẽ o, mu kuulu we ka aagyahaba matala ma oogya Nzaami kundaa we o.» ");
INSERT INTO tyx_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yiisu ásomo mu Nzo a nzaami yi nene ya ábaana obyi ba bákata nkaala omõ. ");
INSERT INTO tyx_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nde ákalyele bo bu: «Bisono bi Nzaami bili mu olyele bu: “Nzo a me sa yikala nzo yi a lisamana”, lo be liikirili yo ngala yi ookasweme mituru.» ");
INSERT INTO tyx_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nde ákaluo mu Nzo a nzaami yi nene bitsughu byehene. Bakwuru ba bangaa ba nzaami, baluo-mikyene ya bakwuru ba ba-Dzwife bákasagha mayele ma odzwa nde. ");
INSERT INTO tyx_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Lo ka bágyahaba bu baasa o, mu kuulu baara bwohono bakagyighili ogyughu nde. ");
INSERT INTO tyx_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Etsughu etsyini, Yiisu ákaluo baara mu nzo a Nzaami yi nene, ya ákatsala Nsia yi Mbwe. Bakwuru ba bangaa ba nzaami, baluo-mikyene, ya bakulu bágyi. ");
INSERT INTO tyx_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bo báfwulu nde ti: «Lyele ati bihi, we nki emfumu li a kye mu osa mandagha ma? Ya nande aagwi we muswa munde?» ");
INSERT INTO tyx_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yiisu ágwi bo mvuru yi: «Mehe si be aangwa efwulu. ");
INSERT INTO tyx_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Lilyele me, oboghoro o Dzã kuu yulu bwunu we kuu baara?» ");
INSERT INTO tyx_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lo bo bátsoho bo-a-bo bu: «Kala libvuhulu ti Nzaami aatumu nde, nde sa afwulu bihi-a-be mu emakye liibihi osa kana mu mandagha ma nde? ");
INSERT INTO tyx_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ya kala lilyele ti kundaa baara, baara bwohono sa bakaha bihi-a-be mameẽ, mu kuulu bo bwohono bákihi ti Dzã mubighili áali.» ");
INSERT INTO tyx_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mu obo, bágwi nde mvuru ti bo ka bagyahaba o. ");
INSERT INTO tyx_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ya Yiisu ályele ti: «Mehe si ka andyele be o, mu nsa litumu me ndi mu okagyighili mandagha ma.» ");
INSERT INTO tyx_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ŋa mbihi oŋo, Yiisu áti baara nkumu yi: «Mbwuru mutsyini ákunu nseghe a bviini, ágwihini ya ba bákasala mu yo, ya ágyene ya ásihi nsie a nde, ási matala malagha oko. ");
INSERT INTO tyx_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Matala ma otolo bimburu bu máto, nde ágweghe musala mumõ kundaa ba bákasala mu nseghe a bviini, mpaala bagwa kaba li bviini lili nde. Bo bágwini a nde mpaana, ya bábvurulu nde myaã a myaã. ");
INSERT INTO tyx_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nde áfirigweghe musala mukimi. Baara babo bágwini a nde mpaana, ya babvurulu nde myaã a myaã. ");
INSERT INTO tyx_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nde áfirigweghe wu batere, bádzwaha nde mabogho ya babyi nde. ");
INSERT INTO tyx_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mu obo, mfumu a nseghe a bviini ábili bu: “Me bunu-a-bo aansa? Me mwana a me wu mukolo aangweghe, nkini-a-nki bo bagwi nde budziri.” ");
INSERT INTO tyx_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lo baara babo bu bamono nde, bábili bu bo-a-bo: “Wu me mbwuru wu aayabyala pfa. Litswe lidzwa nde, mu kuulu pfa likala lili ndaa bihi bameme.” ");
INSERT INTO tyx_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mu obo, bátsili nde ku mbala a nseghe a bviini ya bádzwi nde. Ŋa mbihi oŋo, nga a nseghe a bviini ema aasa bo? ");
INSERT INTO tyx_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nde sa agya, adzwa baara babo, ya sa agwa nseghe a bviini kundaa baara bakimi.» Ŋa ógyughu baara mandagha mamo, bo bályele ti: «Mandagha mamo ka makughu okala o!» ");
INSERT INTO tyx_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lo bu atala bo, Yiisu ályele ti: «Limatsimi ati, Ndagha yi básono mu Mukaana a Nzaami yi bunu-a-bo yidzyi olyele?» «Limeẽ li ootsili ba baakatwu nzo, lo ayi lili lili ngughu ŋa mutswunu a nzo», ");
INSERT INTO tyx_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«Nswe mbwuru wu aabwa ŋa yulu a lo, sa abwogho, ya kala ti lo libwi ŋa yulu a mbwuru, sa lipwene nde.» ");
INSERT INTO tyx_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bakwuru ba bangaa ba nzaami ya baluo-mikyene básagha bu baasyimi Yiisu mu ena kyini ekye, mu kuulu bo bábaghala ti nkumu oyo mu bo nde áti yo. Lo bo bábara nzalamweẽ a baara. ");
INSERT INTO tyx_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mu obo, bábaana ogyighili okatala Yiisu. Bo bágweghe bankere ba bákamoŋono ti bo bali baba bunsumu, mu kuulu bagyeele obwihi Yiisu mu mandagha ma ndeme. Ya ŋa mbihi oŋo, batyeghe nde ŋa myaã mi mfumu a etsulu e nsie kii Yude. ");
INSERT INTO tyx_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Baara babo bágwi nde efwulu ki: «Muluo, bihi ligyahaba ti we aakabili ya aakaluo ya bunsumu. We ka aakatala bifa bi baara o, lo we aakaluo nzili a Nzaami mu engaŋma. ");
INSERT INTO tyx_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Lyele ati bihi: mikyene mi bihi-a-be miikagwa bihi-a-be muswa wu ofiri mpagha kundaa Sedzare, bwunu we pele?» ");
INSERT INTO tyx_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lo Yiisu ábaghala mayele ma bo ma mabi ya ágwi bo mvuru yi: «Lisuo me mupara mutsyini. ");
INSERT INTO tyx_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Edzili ya bisono bi, bibi nande?» Bo bábvuhulu nde ti: «Bibi ndaa Sedzare.» ");
INSERT INTO tyx_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mu obo Yiisu ályele bo ti: «Libvurulu bibi Sedzare kundaa Sedzare, ya bibi Nzaami kundaa Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bo ka bákughu omono Yiisu epfwumu mu mandagha mamo ŋa mihi mi baara o. Bo bákiŋimi mu mvuru a Yiisu ya bákuru miŋma. ");
INSERT INTO tyx_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ndaama a ba-Saduseyẽ, baara babo ba baakalyele ti osighili o baara mu lipfu ka oli o, báyabehene ya bágwi Yiisu efwulu ki: ");
INSERT INTO tyx_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Muluo, Moyidze ágwi bihi mukyene wu: “Kala ti naana a mbwuru kpi, sihi mupfiili gwene a mwana, mbwee a nde faana ogwolo mupfiili munde, mu kuulu aburu naana a nde baana.” ");
INSERT INTO tyx_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Óli a babaghala nsaama ŋa bula bumõ, bo bwohono maama mumõ, taara mumõ. Wu a nsomo kie mukaha, nde yakpa, mwana we. ");
INSERT INTO tyx_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wu a buolo kie mupfiili, ya kpi si mwana we. ");
INSERT INTO tyx_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wu batere si kie mupfiili ya kpi. Bo bansa nsaama bumõ si, bákpi ku ogwene oburu mwana. ");
INSERT INTO tyx_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ŋa mbihi a bo, mupfiili si kpi. ");
INSERT INTO tyx_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lo ŋa akala oosighili baara bwohono mu lipfu, nande aakala mulumu a nde, buulu bo bansa nsaama bákie nde?» ");
INSERT INTO tyx_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yiisu ágwi bo mvuru yi: «Basi nsie bali mu okie bakala ya balumu, ");
INSERT INTO tyx_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","lo baara ba oomono Nzaami ti bakughu osighili mu lipfu, ya bagyagha nde mu bula bu bunyaghara, ka bakie bakala bwunu we balumu o. ");
INSERT INTO tyx_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bo ka bafirikpa o, mu kuulu sa bakala ti bangye-yulu, ya sa bakala baana ba Nzaami mu ku baasighili bo ŋa kara li ba bákpi. ");
INSERT INTO tyx_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moyidze ágyighili osuo ti ba bákpi sa basighili mu lipfu. Mu emoŋo kii eti-ti ki ékalughulu mbaa lo odzighi we, bályele ti: “Mfumu li Nzaami a Abarahame, Nzaami a Idzake ya Nzaami a Dzakobe.” ");
INSERT INTO tyx_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nzaami ka li Nzaami a ba bákpi o, lo wu a baba mweẽ. Mu kuulu kundaa nde, baara bwohono bali baba mweẽ.» ");
INSERT INTO tyx_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ndaama a baluo-mikyene bábvuhulu bu: «Muluo, we aabili ku obwe.» ");
INSERT INTO tyx_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mu obo, bo ka báfiribagha bukyini mu ogwa nde bifwulu o. ");
INSERT INTO tyx_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yiisu ályele kundaa bo ti: «Bunu-abo bakughu olyele ti Kriste li mwana a Dabvide? ");
INSERT INTO tyx_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dabvide ndeme ásono mu Mukaana wu Bikwumu ti: “Mfumu aalyele kundaa Mfumu a me: Bwa nsini ku kwogho-a-kwogho e me, ");
INSERT INTO tyx_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tee ŋa aansa me kuulu mitaara mi we mikala nkara a myili mi we.”» ");
INSERT INTO tyx_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Kala ti Dabvide aakata nde Mfumu, lo bunu-a-bo nde akughu ofirikala mwana a Dabvide?» ");
INSERT INTO tyx_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ŋaala baara bwohono mu okagyughu nde, Yiisu ályele kundaa binduono bi nde ndiri: ");
INSERT INTO tyx_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Lisa mayele mu baluo-mikyene. Bo badzyi okabuludzie ya binkuru bi bila. Badzyi ti baara bakagwa bo mamboro mu bibini bi ookabvuŋunu baara bwohono. Bo baakasuolo bibini bibi ku nkulu mu manzo mama lisamana mama ba-Dzwife, ya bibini bibi ku nkulu mu malagha. ");
INSERT INTO tyx_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Baakagwohono bilogho mu manzo ma bapfiili, ya baakasa nsamana yi nda mu kuulu baara bakamono bo. Mu obo, sa babagha masyeme ma maluru.» ");
INSERT INTO tyx_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yiisu bu aseene mihi, ámono bisini bi bíkalo bikaba munsa elogho ki baakagwa bikaba. ");
INSERT INTO tyx_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nde ámono si mukaha mutsyini wu mupfiili wu áli muwele mu olo mana mipara myele. ");
INSERT INTO tyx_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mu obo Yiisu ályele ti: «Me ndi mu olyele be engaŋma, ekaba kii mupfiili wu muwele wu eluru kii baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mu kuulu, bo bwohono baalo nzi yi bagwene a yo esala, lo nde kunsa buwele bu nde, aalo nzi yohono yi aakakala a yo mu olaama.» ");
INSERT INTO tyx_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Baara babake bákabili mu mi mitala Nzo a Nzaami yi nene, ya mu bu bátwu yo mu mameẽ ma mabwe, ya mu bilogho bi okagwa baara Nzaami bikaba. Mu obo Yiisu ályele: ");
INSERT INTO tyx_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Etsughu eli kiili mu myehene mi lili mu okamono be, ka osyili si limeẽ litsyini ŋa yulu a limeẽ likimi o. Nzo yohono sa yibwa mu nsie.» ");
INSERT INTO tyx_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bo báfwulu nde: «Muluo, mu nki matala mandagha mamo maatswighi, ya nki elyimi eesuo ti myehene sa mikala?» ");
INSERT INTO tyx_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yiisu ábvuhulu bu: «Lisa mayele, mbwuru anyaã opfiri be. Mu kuulu, baara balagha akala baagya mu nkwumu a me ya olyele ti: “Wu me Kriste wu lili mu okakebe be!” Ya “Matala maato!” Ka linama bo o. ");
INSERT INTO tyx_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ŋa liigyughu be nsia yi a mamvulu ya mandagha mama mpaatsala, ka likala a nzalamweẽ o. Mandagha mamo mafaana otswama ogya, lo masini ma nsie ka magya maswa-maswa o.» ");
INSERT INTO tyx_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ŋa mbihi oŋo nde ályele bo ti: «Ekaana e baara etsyini sa edzwana ya ki eke, nsie a mukogho mutsyini sa yidzwana ya yi a mukogho mukimi. ");
INSERT INTO tyx_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nsie sa yinyiŋi mu mpini yohono, ya nkolo ya nkolo bifulu bibi mabyele sa bibiri baara mu lipfu, ya biwala sa bigya. Mandagha ma maagwa baara nzalamweẽ yi alagha sa makala, ya bilyimi bi binene sa bimoŋono mu mayulu. ");
INSERT INTO tyx_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lo, nsomo-a-nsomo, sa basyimi be, ya sa bamwehẽ be kimini. Sa basa be muyala mu manzo mama lisamana ma ba-Dzwife ya sa batsili be mu boloko. Sa babiri be kundaa mikogho ya bamfumu mu nkooro a nkwumu a me. ");
INSERT INTO tyx_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mu obo be sa libagha mpeene yi okala bampughulu ba me. ");
INSERT INTO tyx_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ka limono mukolo mpara o mu mi liibili be ŋa baasa be muyala, ");
INSERT INTO tyx_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","mu kuulu meme sa ngwa be mayele mama obili ya munzeele bi biisa ti bataara ba be bwohono ka bakughu okemene mandagha ma be bwunu we obwihi be o. ");
INSERT INTO tyx_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Si okala basyana ya bangughu ba be, baana ba ngughu ya baana ba taara, badzighi ya bandughu ba be sa batyeghe be, ya sa badzwa babake ŋa kara li be.» ");
INSERT INTO tyx_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","«Baara bwohono sa babele be mu nkooro a nkwumu a me. ");
INSERT INTO tyx_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lo si lifu li be litsyini ku mutswi ka lipfighili o. ");
INSERT INTO tyx_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mu nkooro a mukama a be sa libagha laama.» ");
INSERT INTO tyx_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Ŋa liimono be mampwumu ma bambumbulu mu odzyi Yerusaleme, ligyahaba ti matala masala maasyili mpaala bvulu litsaŋama. ");
INSERT INTO tyx_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mu obo baara ba baakala ku etsulu e nsie kii Yude bafaana obara ku yulu a minguo, ba baakala ŋa nsa Yerusaleme bapala, ya ba baakala ku bibiri banyaã oyasomo kunsa bvulu. ");
INSERT INTO tyx_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bitsughu bibye sa bikala bitsughu bibi masyeme ma Nzaami, mu kuulu myehene mi básono mu Mukaana a Nzaami mitswighi. ");
INSERT INTO tyx_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mu bitsughu bibye, nyiĩ mu bakaha ba baakala a mayimi ya basuomo! Mu kuulu nsie yohono sa yisomo kunsa mpara yi alagha, ya Nzaami sa asuo nkehe a nde mu baara baba nsie yi. ");
INSERT INTO tyx_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mitaara sa midzwa baara balagha mu mapee, sa babiri bo kunsa bunkana ku mansie mwohono, ya baara baala ka bali ba-Dzwife o sa badzyara Yerusaleme tee ku ookughu matala ma bo.» ");
INSERT INTO tyx_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Bilyimi sa bimoŋono kunsa tala, kunsa ngoono ya kunsa baŋomaŋomo. Ŋa yulu a nsie baara bwohono sa bateghere. Nkele yi aafa ku mubu ya mimpagha mi madza sa bigwa baara nzalamweẽ. ");
INSERT INTO tyx_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Baara sa bakpa mu nzalamweẽ ŋa baatsimi bo mi mili mu ogya mu nsie nsyini, mu kuulu tala, ngoono ya baŋomaŋomo sa binyiŋi. ");
INSERT INTO tyx_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ŋa mbihi oŋo baara sa bamono Mwana a mbwuru mu ogya ŋa yulu a edzi, mu lileene ya nsia yohono. ");
INSERT INTO tyx_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ŋa obaana omoŋono mandagha mamo, litemene ya litala ku yulu mu kuulu obvwughu o be oobehene.» ");
INSERT INTO tyx_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ŋa mbihi oŋo Yiisu áti bo nkumu nsyini: «Litala mufinge ya miti myehene. ");
INSERT INTO tyx_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ŋa liikamono be ti mye mibaana omyehe masagha ma manyaghara, be liikasoolo ti mvulu a nsomo aabehene. ");
INSERT INTO tyx_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Behe si bumõ, ŋa liimono be mandagha mamo, ligyahaba ti Emfumu e Nzaami eebehene. ");
INSERT INTO tyx_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mu engaŋma me ndyele be ti baara baba eseene ki bo bwohono ka basomo mu lipfu o obaana mandagha mamo mamoŋono. ");
INSERT INTO tyx_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yulu ya nsie sa biluru, lo mandagha ma me ka maluru o.» ");
INSERT INTO tyx_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Lisa mayele! Mikolo mi be minyaã obyi mu byiri, mu okolo mala, bwunu we mu mpara a nsie, kala pele etsughu ekye sa ebwa be ensihibi, ");
INSERT INTO tyx_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","mu kuulu sa ebwa ŋa yulu a baara bwohono ba bali ŋa yulu a nsie ti likoho. ");
INSERT INTO tyx_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mu obo likahala mihi ya lisamana matala mwohono, mu kuulu likala a makpa ma olughulu ŋa nkulu a myehene mi mili mu ogya, ya lileene otemene ŋa nkulu a Mwana a mbwuru.» ");
INSERT INTO tyx_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Bitsughu byehene mu nkara-a-mwiĩ, Yiisu ákaluo mu Nzo a nzaami yi nene, ya ákayiluhu mpyibi ku yulu a Munguo wu a mi-Olibve. ");
INSERT INTO tyx_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mu obo baara, bwohono bákagya kundaa nde epala-epala ku Nzo a nzaami yi nene mu ogyughu nde. ");
INSERT INTO tyx_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kyiri kii mampa ma magwene a pfini, ki baakata Paake, ébehene. ");
INSERT INTO tyx_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bakwuru ba bangaa ba Nzaami ya Baluo-mikyene bákasagha bu baadzwa Yiisu, lo bo báli a nzalamweẽ a baara. ");
INSERT INTO tyx_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ankoho Satana ásomo mu mukolo a Yuda wu bákata Isikaryote. Nde áli mumõ ŋa kara li bantumu kwumu a buolo (12). ");
INSERT INTO tyx_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nde ágyene ayigwihini ya bakwuru ba bangaa ba Nzaami ya bakwuru ba baakakebe Nzo a nzaami yi nene, mu mi mitala bunu nde akughu otyeghe Yiisu kundaa bo. ");
INSERT INTO tyx_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bo básomo kunsa esee ya bagwihini ti bagwa nde nzi. ");
INSERT INTO tyx_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda ákihi ya ábaana osagha mpeene yi faana mu otyeghe Yiisu ku ogwene a mpwumu a baara ogyahaba. ");
INSERT INTO tyx_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Etsughu kii mampa ma magwene a pfini éto. Kye áli etsughu ki baakadzwa mwana a endoomo mu ogwa mukaba, mu odza kyiri kii Paake. ");
INSERT INTO tyx_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mu obo, Yiisu ágweghe Piere ya Dzã, ya ályele kundaa bo ti: «Ligye ligyighili bilogho bi liidza bihi-a-be kyiri kii Paake.» ");
INSERT INTO tyx_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bo báfwulu nde ti: «Kunu-ako we dzyi ti bihi ligyighili bye?» ");
INSERT INTO tyx_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yiisu ágwi bo mvuru yi: «Mono, ŋa liisomo be munsa bvulu, be sa libwana a baghala mutsyini ya yughu li madza. Linama nde tee mu nzo yi aasomo nde, ");
INSERT INTO tyx_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ya lilyele nga a nzo bu: “Muluo bu afwulu we: Ngwumu a nzo yi aandza me kyiri kii Paake ya binduono bi me yini a yo?” ");
INSERT INTO tyx_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nde sa asuo be ngwumu yi nene yi a ku yulu ku oli bilogho byehene mukughu. Me omo be liigyighili bilogho bi-odza mu kyiri kii Paake.» ");
INSERT INTO tyx_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bo bágyene ya bámono mandagha mwohono ti bu ólyele bo Yiisu, ya bagyighili bi-odza bi kyiri kii Paake. ");
INSERT INTO tyx_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Matala mama odza bu mato, Yiisu ábwi nsini ya bantumu. ");
INSERT INTO tyx_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nde ályele kundaa bo ti: «Me aandzyi ku olagha odza kyiri kii Paake ki ya be, nsomo-a-nsomo me mono mpara! ");
INSERT INTO tyx_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mu kuulu me ndi mu olyele be yo, me ka aafirindza kye o, tee matala ma ootswighi kye mu Emfumu e Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ya bu agwolo ebaha, nde ábvurulu matuono ya ályele ti: «Ligwolo ebaha ki, ya likaba kye be a be, ");
INSERT INTO tyx_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","mu kuulu, me ndi mu olyele be, me ka afiriŋma mala ma bviini o, tee mu matala ma oogya Emfumu e Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ŋa mbihi oŋo, nde ágwolo limpa, bu abvurulu matuono, nde átsyiri lo, ágwi bo lo ya ályele ti: «Yi me nyuru a me yi bágwi mu be. Liikasa bu mu okalibili me mweẽ.» ");
INSERT INTO tyx_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Bumõ si mu ebaha, bu bamana odza, nde ágwi bo kye ya ályele ti: «Ebaha ki eli ogwihini ku onyaghara mu makili ma me ma matsaŋama mu be.» ");
INSERT INTO tyx_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Lo litala! Kwogho kii munde wu aatyeghe me eli emõ ya me ŋa yulu a tabele. ");
INSERT INTO tyx_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mu engaŋma, Mwana a mbwuru faana ogye ti bu ogwaa Nzaami. Lo nyiĩ kundaa munde wu aatyeghe nde!» ");
INSERT INTO tyx_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mu obo, bo bábaana ofwulu bo-a-bo, nande ŋa kara li bo aagyighili ndagha oyo. ");
INSERT INTO tyx_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Binduono si bíbaana otsoho bye-a-bye mu ogyahaba nande bvulu babake bukwuru. ");
INSERT INTO tyx_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yiisu ályele bo ti: «Mikogho mi mansie miikatumu mansie ma bo, ya babo ba bali a litumu ŋa yulu a mo, baakata bo ba baakasa mi mibwe. ");
INSERT INTO tyx_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lo ka oli bubo o mu be, ka lisa obo o. Ŋa kara li be, mbwuru wu bvulu bukwuru, akala ti wu bvulu bungagye, ya munde wu li mu okatumu, akala ti musala. ");
INSERT INTO tyx_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nande bvulu bukwuru ŋa kara li munde wu aalabala myili mu odza ya munde wu li mu okasalala? Ka oli munde wu aalabala myili mu odza o? Lo ŋa kara li be, me ndi munde wu li mu okasalala.» ");
INSERT INTO tyx_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Be lili babo ba baasi mukama ya me kunsa bigyeele. ");
INSERT INTO tyx_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Me mu obo, bu ógwi me Taara Emfumu, me obo si me aangwi be kye. ");
INSERT INTO tyx_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mpaala be lidza ya liŋma emõ ya me ŋa tabele mu Emfumu e me. Ya be sa libwa nsini ŋa makubu mu olamana madzumu kwumu ya muolo (12) ma Isarayele.» ");
INSERT INTO tyx_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","«Simõ, Simõ, Satana aaluomo we mu onyihi we ti bu baakakele bimburu bi bele, ");
INSERT INTO tyx_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lo me aambuono Nzaami mu nkooro a we, mpaala kana li we linyaã obwa, ya mu matala ma akala aafiriyabvughuru we kundaa me, we gwa bambaala ba we bukyini.» ");
INSERT INTO tyx_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piere ályele nde ti: «Mfumu, me aankughu mu osomo boloko ya mu okpa ya we.» ");
INSERT INTO tyx_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yiisu ábvuhulu nde ti: «Piere, me ndyele we: Mu mpyibi yi a lolo yi, nsomo nsuhu akwolo, we sa tunu nsa tere ti we ka gyahaba me o.» ");
INSERT INTO tyx_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yiisu áfirilyele kundaa bo ti: «Mu matala ma ángweghe me be ku ogwene obiri nzi, ku ogwene a empogholo, ku ogwene a bikoghoro, be áli liigweene a elogho?» Bo bábvuhulu nde ti: «Ti elogho we!» ");
INSERT INTO tyx_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ya, nde ályele kundaa bo ti: «Lo mu matala ma, wu li a nzi, agwolo yo, bumõ si mu munde wu li a empogholo, agwolo kye, ya wu gwene a lipee atyeghe enkuru ya aswumu lipee limõ. ");
INSERT INTO tyx_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Me ndi mu olyele be ti, mandagha ma básono mu Mukaana a Nzaami mafaana otswighi mu me: Baatwulu nde mu muluo a baara ba babi. Mandagha mamo sa mamoŋono edzi-dzighi mu me.» ");
INSERT INTO tyx_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bantumu bályele kundaa nde ti: «Mfumu, mapee mwolo mama.» Nde ábvuhulu bo ti: «Ookughu!» ");
INSERT INTO tyx_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yiisu ápala ya ágyene ku Munguo wu a mi-Olibve ti bu óli epfu e nde. Binduono bi nde bínama nde. ");
INSERT INTO tyx_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bu ato oko, nde ályele bo: «Lisamana mpaala be linyaã obwa mu bigyeele.» ");
INSERT INTO tyx_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ŋa mbihi oŋo, nde ábulusihi bo ya ágyene mu etiiri ki bakughu otubu limeẽ, ákunu mabuo mu nsie ya ásamana. ");
INSERT INTO tyx_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nde ályele bu: «Taara, kala we dzyi, maha me ebaha ki. Lo ka bu ndzyi me o, lo bu dzyi we.»  ");
INSERT INTO tyx_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mu obo ngye-yulu áfi ku yulu mu ogwa nde bukyini. ");
INSERT INTO tyx_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yiisu ámono mpara yi alagha kunsa mukolo, ya áfirisamana mu mpini yi luru. Tsughuru li nde líli ti mabere ma makili ma mali mu okatsolo mu nsie. ");
INSERT INTO tyx_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bu amana osamana, átemene ya ágyene ku oli binduono bi nde. Nde áyabaha bye bigyoŋomo tolo mu nkooro a nyiĩ. ");
INSERT INTO tyx_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yiisu ályele bye ti: «Mu emakye be liigyoŋomo? Litemene, ya lisamana, mpaala linyaã obwa mu bigyeele.» ");
INSERT INTO tyx_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ŋaala Yiisu nkini mu okabili, mpwumu a baara yígyi. Yuda, mumõ ŋa kara li bantumu kwumu a buolo (12), áayabiri mpwumu oyo. Nde áyasele ŋa bele a Yiisu mu onyuburu nde. ");
INSERT INTO tyx_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yiisu ályele nde ti: «Yuda, me mu onyuburu we tyeghe Mwana a mbwuru!» ");
INSERT INTO tyx_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ŋa omono binduono bi Yiisu mandagha ma mali mu ogya, bye bífwulu nde: «Mfumu, lidzwana mu mapee?» ");
INSERT INTO tyx_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ya mumõ ŋa kara li bo ákaha musala a Mukwuru a bangaa ba nzaami ya atsyiri nde tswi lili kwogho-a-kwogho. ");
INSERT INTO tyx_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Lo Yiisu átsughu ndagha ti: «Linyaã! Lisa bwunu!» Mu obo, ábyeme tswi li mbwuru munde ya ádzuhu nde. ");
INSERT INTO tyx_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ŋa mbihi oŋo, Yiisu ályele bakwuru ba bangaa ba Nzaami, bakwuru baba bankyele ba Nzo a nzaami yi nene ya bakwuru ba ba-Dzwife ba bágyi mu oyasyimi nde bu: «Be liigyi a mapee ya mimpagha, ti be liiyasyimi ntwumu, ");
INSERT INTO tyx_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","bitsughu byehene, me aakankala ya be mu Nzo a nzaami yi nene, ya be ka liisyimi me o. Lo li me tala lili ndaa be ya lili lileene lili mpyibi.» ");
INSERT INTO tyx_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mu obo, básyimi Yiisu, bábiri nde ya bágyene a nde ku nzo a mukwuru a bangaa ba nzaami. Piere ákanama bo la la. ");
INSERT INTO tyx_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bábvughu mbaa ŋa kara-a-kara a mbala ya bábwi nsini. Piere ágyene ayibwa nsini ya baara ba bákagyoro mbaa. ");
INSERT INTO tyx_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Musala mutsyini wu mukaha wu áamono nde abwi nsini ŋa nkwu-a-mbaa, átuunu nde mihi ya ályele ti: «Baghala wuhu si aali ya nde.» ");
INSERT INTO tyx_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lo Piere átunu ya ályele: «Ma mwana, me ka ngyahaba nde o.» ");
INSERT INTO tyx_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mana matala bu maluru, mbwuru mukimi ámono nde ya ályele ti: «Wehe si li mumõ ŋa kara li baara ba bo.» Lo Piere ábvuhulu nde: «Pele ta baghala, ka oli me o.» ");
INSERT INTO tyx_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tala litsyini bu liluru, mbwuru mukimi ágyighili onyeme: «Mu engaŋma baghala wu ya nde aali mu kuulu nde li musi Ngalile.» ");
INSERT INTO tyx_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lo Piere ágwi mvuru yi: «Me ka ngyahaba mi dzyi we olyele o.» Mu ena kyini ekye, ŋaala Piere nkini mu okabili, nsuhu ákwolo. ");
INSERT INTO tyx_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mfumu ákaghala ya átala Piere. Piere álibili mweẽ ndagha yi áli olyele nde Mfumu: «Mu mpyibi yi a lolo nsomo nsuhu akwolo, we sa tunu nsa tere ti we gyahaba me.» ");
INSERT INTO tyx_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mu obo, Piere ábulupala ya ágwubulu mukaba a elili. ");
INSERT INTO tyx_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Baara ba bákakebe Yiisu bákasebe nde ya bákakaha nde. ");
INSERT INTO tyx_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Báfughu nde mihi ya bályele nde ti: «Bighili, nande aakaha we.» ");
INSERT INTO tyx_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bo bákatsyala nde bitughu ku oluru. ");
INSERT INTO tyx_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bwihi bu buki, ekwuru ki ba-Dzwife, bakwuru ba bangaa ba Nzaami ya baluo-mikyene bábvuŋunu ebini emõ. Bo bátumu bayabiri Yiisu kundaa ekwuru ki ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bo bályele Yiisu ti: «Lyele bihi, kala we li Kriste.» Yiisu ábvuhulu bo ti: «Kala me ndyele be, be ka lisa kana o, ");
INSERT INTO tyx_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ya kala me mfwulu be, be ka ligwa me mvuru o. ");
INSERT INTO tyx_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lo, obaana matala ma, Mwana a mbwuru sa abwa nsini ku kwogho-a-kwogho e Nzaami Nga-a-Mpwũ.» ");
INSERT INTO tyx_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bo bwohono báfwulu nde ti: «We me Mwana a Nzaami?» Nde ábvuhulu bo ti: «Beme lilyele ti me ndi nde.» ");
INSERT INTO tyx_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mu obo, bo bályele ti: «Bihi-a-be ka liifirisyili a nzala a bampughulu o. Bihi bameme liigyughu mi míipala mu muŋma a nde.» ");
INSERT INTO tyx_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Baara bwohono bátemene ya bábiri Yiisu ŋa nkulu a Pilate. ");
INSERT INTO tyx_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bábaana oburulu nde mandagha bu: «Bihi liimono mbwuru wu mu okagwa baara ba bihi mutswi mpini, ya olighi bo banyaã ofiri mpagha kundaa Sedzare. Ya aalyele ti nde li Kriste ya Mukogho.» ");
INSERT INTO tyx_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilate ágwi nde efwulu ki: «We me mukogho a ba-Dzwife?» Yiisu ábvuhulu nde ti: «Weme lyele obo!» ");
INSERT INTO tyx_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilate ályele kundaa bakwuru ba bangaa ba Nzaami ya kundaa mpwumu a baara ti: «Me ka mono ndagha yi mbi yi oosi baghala wu o.» ");
INSERT INTO tyx_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lo bo bányeme ya bályele ti: «Nde li mu okagwa baara mutswi mpini mu maluo ma nde, mu kuulu bakolo nkehe. Aabana ku Ngalile, aabululuru ku Yude lwohono, mu matala ma aagyi kunu.» ");
INSERT INTO tyx_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ŋa ógyughu Pilate mandagha mamo, nde áfwulu bo kala ti Yiisu musi Ngalile ali. ");
INSERT INTO tyx_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ya bu agyughu ti Yiisu áli mbwuru wu a bula baba emfumu e Erode, Pilate ágweghe nde kundaa Erode wu áali si ŋa Yerusaleme mu bitsughu bibye. ");
INSERT INTO tyx_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ŋa ómono Erode Yiisu, nde ámono esee ki elagha. Mu kuulu edzighi nde ákasagha omono nde mu nkooro a mi ágyughu nde mu Yiisu, ya nde ákadzyi ti Yiisu asa emamaã ŋa busu bu nde. ");
INSERT INTO tyx_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nde ágwi nde bifwulu bilagha, lo Yiisu ka ágwi nde mvuru si nsyini o. ");
INSERT INTO tyx_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bakwuru ba bangaa ba Nzaami ya baluo-mikyene báli oŋo ya bákaburulu nde mandagha mu nzuŋu. ");
INSERT INTO tyx_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erode ya bambumbulu ba nde bási nde munkulu. Bu bamana otsaala nde, bálaha nde enkuru ki ebwe ya babvurulu nde kundaa Pilate. ");
INSERT INTO tyx_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ŋa nsomo, Pilate ya Erode báli mitaara, lo mu etsughu kyini ekye, bo bákala bandughu. ");
INSERT INTO tyx_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate bu abvughu bakwuru ba bangaa ba Nzaami, bamfumu ya baara bwohono, ");
INSERT INTO tyx_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","nde ályele bo ti: «Be liigyi a me baghala wu ya liilyele ti nde li mu okagwa baara mutswi mpini. Litala, me aangwi nde bifwulu ŋa mihi mi be, ya me ka aamono nde epfwumu mu mandagha ma lili mu okakwighi be nde o. ");
INSERT INTO tyx_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erode si ka aamono nde epfwumu o, mu kuulu nde aabvurulu nde kunu. Mu olyele ti baghala wu ka aasi ndagha yi bakughu otsyiri nde lipfu o. ");
INSERT INTO tyx_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mu obo, me otumu aantumu bakaha nde yini a nswa-nswa, ŋa mbihi oŋo, me nde aanyaã agye o nde.» ");
INSERT INTO tyx_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mu nswe kyiri, Pilate ákapaha mbwuru mutsyini mu boloko. ");
INSERT INTO tyx_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Lo bo bwohono mu emvuŋunu bákehe bingubu ya bályele ti: «Dzwa baghala wu, ya paha bihi Barabase mu boloko.» ");
INSERT INTO tyx_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabase munde áli ásomo boloko mu nkooro a baara ba bábihi litumu li bamfumu ba bvulu, ya mbwuru wu bádzwi. ");
INSERT INTO tyx_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mu kuulu nde ákadzyi onyaã Yiisu agye, Pilate áfiribili ya bo, ");
INSERT INTO tyx_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","lo bo bákehe bingubu ti: «Komo nde ŋa kuruwa! Komo nde ŋa kuruwa!» ");
INSERT INTO tyx_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilate áfirilyele bo mu sa li li tere ti: «Bu nde nsa ndagha yi mbi aasi? Me ka aamono epfwumu mu nde o ki ekughu osa ti badzwa nde. Mu obo, me otumu aantumu bakaha nde nswa-nswa, ŋa mbihi oŋo me nde aanyaã agye.» ");
INSERT INTO tyx_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lo bo báfirikehe bingubu bi biluru, ya báluomo bakomo nde ŋa kuruwa. Pilate ágyughu bingubu bibo. ");
INSERT INTO tyx_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mu obo, nde átsyiri ndagha bu bákadzyi bo. ");
INSERT INTO tyx_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nde ápaha mbwuru wu báluomo bo mu boloko, munde wu áasomo boloko mu nkooro a baara ba bábihi litumu li bamfumu ba bvulu, ya ku bádzwi mbwuru, ya ágwi Yiisu ŋa myaã mi bo mu kuulu basa nde mi bákadzyi bo. ");
INSERT INTO tyx_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ŋa ókabiri bambumbulu Yiisu, bábwana a musi Sirene mutsyini, nkwumu a nde áli Simõ. Nde ku manseghe áfi. Bákwighi nde mu obiri kuruwa ŋa mbihi a Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mpwumu a baara yi nene ya bakaha bákanama Yiisu. Bakaha bákabeere bitulu ya bákagwobolo bilili mu nkooro a nde. ");
INSERT INTO tyx_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yiisu ákaghala, ályele bo ti: «Batughu ba Yerusaleme, ka lilili mu me o, lo lilili mu beme ya mu baana ba be. ");
INSERT INTO tyx_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mu kuulu, mu bitsughu bi bili mu ogya sa akala balyele ti: “Esee kundaa bitini, kundaa ba bagwene oburu, ya ba bagwene osomo busuomo!” ");
INSERT INTO tyx_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mu matala mamo, baara sa babaana olyele kundaa minguo mi minene: “Libwa ŋa yulu a bihi!” Ya kundaa minguo mi misala ti: “Lifughu bihi!” ");
INSERT INTO tyx_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mu kuulu, kala basi mandagha ma kundaa muti wu mubihi, ema akala baasa kundaa muti wu akee?» ");
INSERT INTO tyx_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mu matala maana mamo bákabiri si bantwumu buolo mu oyidzwa bo emõ ya Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ŋa báto bo ŋa ebini ki bákata ti «Etyeghe kii mutswi», bákomo Yiisu ŋa kuruwa ya bantwumu buolo babo, mutsyini ku kwogho-a-kwogho, ya wu muke ku engbambogho. ");
INSERT INTO tyx_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yiisu ályele bu: «Taara, sa bo kolokolo, mu kuulu bo ka bali mu ogyahaba mi bali mu okagyighili o.» Báti empa kii nga a bwehe, ya bákaba biko bi nde. ");
INSERT INTO tyx_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Baara bátemene oŋo ya bákatala. Bamfumu bákasa Yiisu munkulu ya bályele ti: «Nde aabvwuhu baara babake, abvwuhu nyuru a ndeme, kala ti ngaŋma nde li Kriste wu ósuolo Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bambumbulu si bákasa nde munkulu. Báyasele ku bele a nde, bágwi nde bviini lili ŋeẽ ");
INSERT INTO tyx_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ya bályele ti: «Kala ti we li mukogho a ba-Dzwife, bvwuhu nyuru a we weme!» ");
INSERT INTO tyx_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ŋa yulu a kuruwa li nde básono bu: «Wu me Mukogho a ba-Dzwife.» ");
INSERT INTO tyx_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mumõ mu bantwumu ba bákomo ŋa kuruwa, átughu nde ya ályele bu: «We ka li Kriste o? Bvwuhu nyuru a weme, ya bvwuhu bihi!» ");
INSERT INTO tyx_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lo wu muke áfyeẽ nde ya ályele ti: «We ka aakabara Nzaami o, we wu baatsyiri lipfu limõ ti nde? ");
INSERT INTO tyx_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Lipfu li lifaana mu bihi a we bansa buolo mu nkooro a bigyighili bi bihi a we bi bibi, lo nde ka aasi ndagha yi mbi o.» ");
INSERT INTO tyx_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ŋa mbihi oŋo, nde ályele kundaa Yiisu ti: «Yiisu, tsimini me mu matala ma ayabvughuru we kunsa emfumu e we.» ");
INSERT INTO tyx_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yiisu ágwi nde mvuru yi: «Mu engaŋma me ndyele we, lolo li we sa kala ya me ku paradise.» ");
INSERT INTO tyx_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Matala máto ku bele a mbihi a ntaã a minsene, ya mpyibi yíbwi ŋa yulu a nsie yohono tee mu matala mama matere ŋa mbihi a ntaã a minsene. ");
INSERT INTO tyx_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tala lípyini, ya nkpaŋa a eko yi áli mu Nzo a nzaami yi nene yíkagha ŋa kara-a-kara. ");
INSERT INTO tyx_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yiisu ákehe engubu ki enene: «Taara, me mbvurulu mufulu a me ŋa myaã mi we!» Nde abili obo, átaghaba. ");
INSERT INTO tyx_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ŋa ómono mfumu a ekuru ki bambumbulu nkama (100) mi míluru, nde ásyighi Nzaami ya ályele ti: «Ngaŋma, mbwuru wu, mbwuru wu a bunsumu áakakala.» ");
INSERT INTO tyx_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Baara bwohono ba bágyi mu mampwumu mu oyamono nde, bu bamono mandagha ma máluru, bási myaã ŋa yulu a mitswi ya bábvughuru. ");
INSERT INTO tyx_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Baara ba básoolo Yiisu ya bakaha ba bákanama nde obaana Ngalile, bátemene la la, ya bákatala mi míkaluru. ");
INSERT INTO tyx_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Óli a mbwuru mutsyini wu a ekwuru ki ba-Dzwife, nkwumu a nde Dzodzefe. Nde áli mbwuru wu mubwe ya wu bunsumu. ");
INSERT INTO tyx_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nde ka áli kunsa mfwunu yi ósi babake mu odzwa Yiisu o. Nde áli musi Arimate, bvulu li ba-Dzwife, ya ákakebe Emfumu e Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nde ágyene kundaa Pilate ya áluomo nde ebyimi e Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bu amaha kye ŋa yulu a kuruwa, ádziŋi kye kunsa eko kii lino ya átwulu kye kunsa mpyeme yi bátsimi kunsa limeẽ, mpyeme yiili nkini ka bámaadzyighi mbwuru o. ");
INSERT INTO tyx_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kye áli etsughu ki bákagyighili mi mitala etsughu kii Sabate, mu kuulu etsughu kii Sabate áli ayi mu obaana. ");
INSERT INTO tyx_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bakaha ba bánama Yiisu obaana ku Ngalile, bágyene nzili mõ ya Dzodzefe, bámono mpyeme ya bu bádzyighi ebyimi e Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ŋa mbihi oŋo, bo bábvughuru, bágyighili mananaase ya maala, ya bágwumu mu etsughu kii Sabate, bwunu a bu óli mikyene. ");
INSERT INTO tyx_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ya mu etsughu kii nsomo mu limiŋi, bakaha bágyene epala-epala ku mpyeme. Babiri mananaase ma bágyighili. ");
INSERT INTO tyx_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bámono ti limeẽ li baakakyi mpyeme baakimini lo la ya mpyeme. ");
INSERT INTO tyx_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ya bu basomo, bo ka bámono nyuru a Mfumu Yiisu o. ");
INSERT INTO tyx_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ya mu kuulu bo ka básoolo bu baasa o mu mi mitala ndagha yi, mono, babaghala buolo báyamoŋono ŋa nkulu a bo ya binkuru bi biikasehene. ");
INSERT INTO tyx_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bo bábagha nzalamweẽ, bápfumunu masu mu nsie, ya babaghala babo bályele bo ti: «Mu emakye be lili mu okasagha munde wu li mweẽ ŋa kara li baara ba bákpi? ");
INSERT INTO tyx_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nde ka ali ŋa o, nde aasighili mu lipfu. Litsimi nsa mandagha nde ákalyele be, ŋaala nde nkini ali ku Ngalile. ");
INSERT INTO tyx_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nde bu ákalyele ti: “Bafaana otyeghe Mwana a mbwuru ŋa myaã mi banga-a-masumu. Sa bakomo nde ŋa kuruwa, lo ŋa mbihi a bitsughu bitere, nde sa asighili mu lipfu.”» ");
INSERT INTO tyx_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bo bálibili mweẽ mandagha ma ókalyele bo Yiisu. ");
INSERT INTO tyx_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bámara ŋa mpyeme ya báyilyele mandagha mwohono mamo kundaa bantumu kwumu ya mumõ (11) ya binduono bibike byehene. ");
INSERT INTO tyx_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mu bo óli Mari musi Mangadala, Dzaane, Mari maama a Dzake, ya bakaha babake ba báli ya bo. Bo bályele kundaa bantumu, ");
INSERT INTO tyx_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","lo bantumu bámono ti mandagha ma ólyele bo bakaha máli bigwobolo. Mu obo, bo ka bási mo kana o. ");
INSERT INTO tyx_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lo Piere átemene ya ágyene mu ntyini ku mpyeme. Bu apfuŋumu, nde ámono yini a bisili bi bili mu nsie. Ŋa mbihi oŋo, nde ábvughuru ku nzo a nde, ya ákiŋimi ku olagha mu mi miluru. ");
INSERT INTO tyx_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ya mono, mu etsughu kyini ekye, binduono byele bíkagye ku bula butsyini bubu nkwumu a Emawuse. Etiiri ŋa kara a Yerusaleme ya bula bubo ekughu okala ampe bakilometere kwumu ya mumõ (11). ");
INSERT INTO tyx_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bo bákabulubili mu mandagha mwohono ma máluru. ");
INSERT INTO tyx_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ŋaala bo mu okabulubili ya mu okabulutsoho, Yiisu áyasele ya ábvughu nzili ya bo. ");
INSERT INTO tyx_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bo bámono nde, lo bo ka bákagyahaba ti munde áli nde o. ");
INSERT INTO tyx_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yiisu áfwulu bo ti: «Be nsa ndagha lili mu okabulutsoho mu nzili?» Bo bátemene ya bámono nyiĩ yi alagha . ");
INSERT INTO tyx_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mumõ ŋa kara li bo, nkwumu a nde Keleopase ágwi nde mvuru yi: «Ŋa kara li baara bwohono ba bali ŋa Yerusaleme, yini a we dzimini mandagha ma maaluru bitsughu bi?» ");
INSERT INTO tyx_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yiisu áfwulu bo ti: «Emakye?» Bo bábvuhulu nde ti: «Mandagha ma maabwi mu Yiisu musi Nadzarete. Nde ali mubighili mumõ wu munene ŋa mihi mi Nzaami ya mimi baara, mu nkooro a bigyighili bi nde ya maluo ma nde. ");
INSERT INTO tyx_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bakwuru ba bangaa ba Nzaami ya bakwuru ba bihi baasi nde muyala, baatsyiri nde lipfu, ya baakomo nde ŋa kuruwa. ");
INSERT INTO tyx_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bihi ali liikakala a bitsimi ti me nde aakwulu Isarayele kunsa bunkana. Lo, lolo bitsughu bitere biiluru, obaana bu ooluru mandagha mamo. ");
INSERT INTO tyx_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mu engaŋma, ndaama a bakaha ŋa kara li bihi baalyele bihi mandagha mama okiŋimi. Bo baagyene ku mpyeme epala-epala, ");
INSERT INTO tyx_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","lo ka baamono nyuru a nde o. Baayabvughuru ya baalyele bihi ti bo baamono bangye-yulu ba baalyele bo ti Yiisu li mweẽ. ");
INSERT INTO tyx_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ndaama a baara ba baakakala ya bihi baagyene ku mpyeme, ya baamono mandagha mwohono ti bu oolyele bakaha, lo nde ka baamono nde o.» ");
INSERT INTO tyx_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mu obo Yiisu ályele bo ti: «Be lili baara ba bagwene a mayele. Ya be lili a mikolo mimi maleme mu osa kana mu mandagha ma ólyele mibighili. ");
INSERT INTO tyx_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Lo, áli ofaana ti Kriste amono mpara mu mandagha mwohono mamo ya asomo mu nsia a nde?» ");
INSERT INTO tyx_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ŋa mbihi oŋo, nde ábaala bo mandagha mwohono ma básono mu nde mu Mukaana a Nzaami, obaana mu mi ósono Moyidze, tee mu mi ósono mibighili. ");
INSERT INTO tyx_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ŋa báto bo ŋa bele a Emawuse, Yiisu ási ti nde aaluru bula bu bo. ");
INSERT INTO tyx_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Lo bo bályele kundaa nde ti: «Agye o, kala ŋa ya bihi. Bwihi buugyili, ya mpyibi edzi-dzighi yibwi.» Mu obo, nde ásomo mu nzo mu okala ya bo. ");
INSERT INTO tyx_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ŋa bábwi bo nsini mu odza, nde ágwolo limpa, abvurulu matuono, átsyiri lo ya ágwi bo lo. ");
INSERT INTO tyx_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mu matala maana mamo, mihi mi bo mídzubulu, ya bo bábaghala ti munde áli Yiisu, lo nde ádzimini ŋa mihi mi bo. ");
INSERT INTO tyx_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bo bábili bo-a-bo ti: «Ŋa aakabili nde ya bihi a we mu nzili ya osuo bihi a we bunu-a-bo Mukaana a Nzaami adzyi olyele, bihi ka ali liimono esee ki eluru mu mikolo o?» ");
INSERT INTO tyx_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yini a mu mutala maana mamo, bo bátemene ya bábvughuru ku Yerusaleme. Bo báyibaha bantumu kwumu ya mumõ (11) bábvuŋunu ya binduono bibike, ");
INSERT INTO tyx_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","bo bályele ti: «Ngaŋma! Mfumu aasighili mu lipfu, nde aayamoŋono kundaa Simõ.» ");
INSERT INTO tyx_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bo bályele bo mi baabwana a bo mu nzili, ya bunu-a-bo baagyahaba Yiisu mu matala ma aakatsyiri nde limpa. ");
INSERT INTO tyx_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ŋaala bo nkini mu okabili obo, Yiisu ndeme áyamoŋono ŋa kara li bo, ya ályele bo ti: «Edzuunu ekala ya be!» ");
INSERT INTO tyx_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bo bábagha nzalamweẽ yi alagha, mu kuulu bátsimi ti munde mupfu baamono. ");
INSERT INTO tyx_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lo Yiisu ályele bo ti: «Mu ema be lili a mikolo maã-maã, ya mu ema be lili a mikeme? ");
INSERT INTO tyx_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Litala myaã ya myili mi me, me me mu engaŋma. Libyeme me ya litala. Mufulu ka ali a nyuru ya miwehe o, ti bu lili mu omono be ti me ndi a bye.» ");
INSERT INTO tyx_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bu abili obo, ásuo bo myaã ya myili mi nde. ");
INSERT INTO tyx_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Buulu bo báli kunsa esee, bo áli nkini ka bási kana o, ya báli kunsa okiŋimi, nde ályele kundaa bo ti: «Be lili a elogho kii odza ŋa?» ");
INSERT INTO tyx_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bágwi nde ekele e nswi ki bágyoho. ");
INSERT INTO tyx_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yiisu ágwolo kye ya áli ŋa mihi mi bo. ");
INSERT INTO tyx_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ŋa mbihi oŋo nde ályele bo ti: «Ma me mandagha ma ákandyele me be, mu matala maala me nkini áli ya be: “Myehene mi básono mu mikyene mi Moyidze, mikaana mi mibighili, ya mu Bikwumu mifaana otswighi.”» ");
INSERT INTO tyx_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mu obo, Yiisu ágwi bo mayele mpaala babaghala Mukaana a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nde ályele bo bu: «Mu obo, básono ti Kriste faana omono mpara ya sa asighili mu lipfu etsughu kii bitere. ");
INSERT INTO tyx_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ya bafaana si otsala nsia a nde, obaana ŋa Yerusaleme tee ku mansie mwohono, mu kuulu baara bagyiŋi mayele ya babagha kolokolo lili masumu mu nkwumu a nde. ");
INSERT INTO tyx_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Be lili bampughulu ba mandagha mwohono. ");
INSERT INTO tyx_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Me be aangweghe Mufulu a Ngili wu ósi Taara a me misiini. Lo be, limakala ŋa Yerusaleme ŋa, tee matala ma liilaha be lileene lili ku yulu.» ");
INSERT INTO tyx_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ŋa mbihi oŋo, Yiisu ábiri bo tee ku bele a Betani. Bu aseene myaã ku yulu, nde áseme bo. ");
INSERT INTO tyx_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mu matala ma ákaseme nde bo, nde ákaghaba ya bo ya bágyene a nde ku yulu. ");
INSERT INTO tyx_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bo bu bamana obuono nde, bábvughuru ku Yerusaleme kunsa esee kii elagha. ");
INSERT INTO tyx_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bitsughu byehene, bo bákasyighi ya bákaseme Nzaami mu Nzo a nzaami yi nene.");
INSERT INTO tyx_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ku ebaana óli Ndagha, Ndagha yíli ya Nzaami, Ndagha yíli Nzaami. ");
INSERT INTO tyx_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nde áli ya Nzaami ku ebaana. ");
INSERT INTO tyx_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nzaami ásalala Ndagha mu ogyighili bilogho byehene, ya ka oli ya elogho si emõ o ki eli ki bágwene ogyighili mu ndagha oyo. ");
INSERT INTO tyx_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mu Nde óli a bumweẽ, ya bumweẽ búli otsyeme o baara, ");
INSERT INTO tyx_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","otsyeme ookasehene kunsa opyini, lo opyini ka ogyagha otsyeme o. ");
INSERT INTO tyx_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Áli oli a mbwuru wu ógweghe Nzaami, nkwumu a nde áli Dzã. ");
INSERT INTO tyx_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nde ágyi ti anga mpughulu, mu osuo bumpughulu bu otsyeme, mu kuulu mu nde baara bwohono basa kana. ");
INSERT INTO tyx_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ka óli nde áali otsyeme o, lo nde ágyi mu osuo bumpughulu bu otsyeme. ");
INSERT INTO tyx_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ndagha yíli otsyeme kuu ngaŋma, otsyeme ku ookatsehebe nswe mbwuru, yo yígyi ŋa nsie. ");
INSERT INTO tyx_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ndagha yíli mu nsie, ya nsie bágyighili yo mu Nde, lo nsie ka yísoolo Nde o. ");
INSERT INTO tyx_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nde ágyi kundaa baara ba ndeme, lo baara ba ndeme ka bágyagha Nde o. ");
INSERT INTO tyx_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lo kundaa babo ba báagyagha nde, babo ba baakasa kana mu nkwumu a nde, nde aagwi muswa mu okala baana ba Nzaami. ");
INSERT INTO tyx_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Baara babo ka báburu bo bu baakaburu baara o, bwunu we mu waa lili baghala ya mukaha, lo mu waa li Nzaami. ");
INSERT INTO tyx_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ya Ndagha yiikighiri mbwuru, nde aayakala ŋa kara li bihi, ya bihi liimono nsia a nde, nsia oyo yi ookagyagha Mwana wu a mbunu kundaa Taara. Nde álwulu mu bwehe ya mu engaŋma. ");
INSERT INTO tyx_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Dzã li mu osuo bumpughulu mu nde ya aati mukwughu ti: «Wu me mbwuru wu áli andyele me ti “Munde wu li mu ogya ku mbihi a me bvulu me mu mupfunu, mu kuulu nde áli nsomo me nkala.”» ");
INSERT INTO tyx_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ya mu olwulu o nde mu bwehe, bihi bwohono líibagha liseme ŋa yulu a liseme. ");
INSERT INTO tyx_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mu obo, Nzaami ágwi bihi Mukyene mu Moyidze, lo bwehe ya engaŋma biigyi mu Yiisu-Kriste. ");
INSERT INTO tyx_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mbwuru nkini ámaamono Nzaami o. Lo munde wu áasuo baara nde, me Nzaami Mwana wu a mbunu, wu li ŋa likara li Taara. ");
INSERT INTO tyx_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Bu me bumpughulu bu Dzã, mu matala ma ógweghe bamfumu ba ba-Dzwife bangaa ba Nzaami ya ba-Lebvite ba báli ku Yerusaleme mu oyifwulu Dzã ti: «We nande li?» ");
INSERT INTO tyx_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ya Dzã ka ábihi ogwa mvuru o, nde ákihi ya ályele epankala ti: «Me, me ka ndi Kriste o.» ");
INSERT INTO tyx_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bo báfirifwulu nde ti: «Lo we nande li? We me Eli?» Nde ábvuhulu ndiri: «Me ka ndi Eli o». Bo báfirifwulu nde ti: «Bunu, we me Mubighili?» Nde ábvuhulu ti: «Pele.» ");
INSERT INTO tyx_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mu obo, bo bályele kundaa nde ti: «Lo we nande li? We nki ndagha lyele mu weme? Mu kuulu bihi liyigwa mvuru kundaa babo ba baagweghe bihi.» ");
INSERT INTO tyx_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nde ályele ti: «bwunu a bu ólyele mubighili Edzayi Me ndi likyi li munde wu li mu okakehe engubu ku syehe, lisa nzili a Mfumu nsumu.» ");
INSERT INTO tyx_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ŋa kara li baara babo ba bágweghe kundaa Dzã, óli ya ba-Faridzyẽ. ");
INSERT INTO tyx_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bo báfwulu nde ti: «Kala ti we ka li Kriste o, we ka li Eli o, we ka li Mubighili o, lo mu emakye we li mu okaboghoro baara?» ");
INSERT INTO tyx_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Dzã ábvuhulu kundaa bo ti: «Me ndi mu okaboghoro baara mu madza. Lo ŋa kara li be oli a mbwuru wu ligwene osoolo be. ");
INSERT INTO tyx_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nde li mu ogya ku mbihi a me ya me ka nkughu onyana misyi mi bikoghoro bi nde o.» ");
INSERT INTO tyx_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mandagha ma máluru ku Betani, ku ngulu a mwele wu a Dzurudẽ, ku ókaboghoro Dzã baara. ");
INSERT INTO tyx_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ŋa mbihi a etsughu ekye, Dzã bu amono Yiisu wu áakagya kundaa nde, ályele ti: «Limono Mwana a endoomo e Nzaami wu aakamaha masumu ma nsie nsyini. ");
INSERT INTO tyx_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Me mu nde me áakandyele ti: “Oli a mbwuru wu li mu ogya ku mbihi a me, wu bvulu me mu mupfunu, mu kuulu nde áli nsomo me nkala.” ");
INSERT INTO tyx_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ya meme si ka áakansoolo nde o, lo kala ti me aangyi mu oboghoro baara mu madza, mu kuulu basoolo nde mu Isarayele.» ");
INSERT INTO tyx_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Dzã ásuo mpughulu bu: «Me aamono Mufulu mu efaana kii beeme, wu fi ku yulu, yakumunu ya yakala mu nde. ");
INSERT INTO tyx_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ya me ka áakansoolo nde o, lo munde wu áagweghe me mu oboghoro baara mu madza, me nde áalyele me ti: “Munde wu akala aamono we Mufulu yakumunu ya yakala mu nde, me nde akala aaboghoro baara mu Mufulu a Ngili.” ");
INSERT INTO tyx_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ya meme aamono ya ndi mu osuo bumpughulu ti mbwuru wu li Mwana a Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ŋa mbihi a etsughu kii byele, Dzã áfirigya ŋa ebini ekye ya byele mu binduono bi nde. ");
INSERT INTO tyx_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Bu ámono Yiisu wu áakaluru, nde ályele ti: «Limono Mwana a endoomo e Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Binduono binsa byele bu bigyughu nde mu obili obo, bínama Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yiisu bu akaghala, ámono ti bo bákayanama nde ya nde áfwulu bo ti: «Be emakye lili mu okabulusagha?» Bo bábvuhulu ti: «“Rabi”, mbaala ti, “Muluo”, we kunu-ako aakakala?» ");
INSERT INTO tyx_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nde ályele kundaa bo ti: «Ligya ya be sa limono.» Bo bágyene ya bámono ŋa ákakala nde ya bákala ya nde etsughu ekye. Áli oli ku bele a tala lili mana ŋa mbihi a embehe. ");
INSERT INTO tyx_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mumõ mu bo buolo ba bágyughu mandagha ma ókalyele Dzã ya ba bánama Yiisu áli Andere, mbwee a Simõ-Piere. ");
INSERT INTO tyx_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nde átswama omono mwana a taara a nde Simõ ya ályele nde ti: «Bihi liimono Mesi!» Mbaala ti, «Kriste». ");
INSERT INTO tyx_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nde ábiri Simõ kundaa Yiisu. Yiisu bu atala nde ályele ti: «We me Simõ, mwana a Dzã, sa bakata we mu nkwumu yi a “Sefase”, mbaala ti “Piere”». ");
INSERT INTO tyx_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ŋa mbihi a etsughu ekye, Yiisu ágwolo munkaana mu ogye ku etsulu e nsie kii Ngalile. Nde ábwana a Filipe ya ályele kundaa nde ti: «Nama me!» ");
INSERT INTO tyx_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ankoho Filipe áli musi Betesayida, bvulu li Andere ya Piere. ");
INSERT INTO tyx_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipe ábwana a Natanayele ya ályele nde ti: «Bihi liimono munde wu básono mu Mukyene a Moyidze ya mu mikaana mi mibighili: Me Yiisu musi Nadzarete, mwana a Dzodzefe.» ");
INSERT INTO tyx_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayele ályele kundaa nde ti: «Bunu, ku Nadzarete okughu opala elogho kii mubwughu?» Filipe ábvuhulu nde ti: «Gya ya mono.» ");
INSERT INTO tyx_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yiisu bu amono Natanayele wu aakagya kundaa nde ályele mu nde ti: «Limono nkara a musi Isarayele, mu nde ka oli a mpya o.» ");
INSERT INTO tyx_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayele áfwulu kundaa Yiisu ti: «We kunu-ako soolo me?» Ya Yiisu ábvuhulu nde ndiri: «Nsomo Filipe ata we mbili, ŋaala we nkini áli ŋa nsini a muti a finge, me áamono we.» ");
INSERT INTO tyx_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayele áfirilyele ti: «Muluo, me we li Mwana a Nzaami, me we li mukogho a Isarayele.» ");
INSERT INTO tyx_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yiisu ábvuhulu kundaa nde ti: «We busi kana mu nkooro a ku ndyele me we ti: “Me aamono we ŋa nsini a muti a finge?” We sa firimono mandagha ma mabvulu ma mu bunene!» ");
INSERT INTO tyx_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yiisu áfirilyele kundaa bo ti: «Mu engaŋma me ndyele kundaa be, be sa limono yulu bwaha ya bangye-yulu ba Nzaami mu okakumu ya okasughuru ŋa yulu a Mwana a mbwuru.» ");
INSERT INTO tyx_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ya mu etsughu kii bitere, óli a mabala ku bvulu lili Kaana mu etsulu e nsie kii Ngalile. Ngughu a Yiisu áli oŋo. ");
INSERT INTO tyx_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bágwi si Yiisu ya binduono bi nde mpighi a mabala mamo. ");
INSERT INTO tyx_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mu matala ma ófi bviini, ngughu a Yiisu ályele kundaa nde ti: «Bo ka baafirisyili a bviini o!» ");
INSERT INTO tyx_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Lo Yiisu ábvuhulu nde ti: «Maama, we ya me ndagha ma? Matala ma me nkini maakughu o.» ");
INSERT INTO tyx_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ngughu a nde ályele kundaa basala ti: «Ligyighili nswe ndagha yi aalyele nde be.» ");
INSERT INTO tyx_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ŋa ebini ekye óli a mayughu masemene mama mu mameẽ ma ókasalala ba-Dzwife mu okatsehebe manyuru. Mu oluhu nswe yughu, báfaana olo mbyeẽ mpuomo bwunu we kwumu ya ywolo (12). ");
INSERT INTO tyx_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yiisu ályele kundaa basala ti: «Liluhu mayughu ma mu madza». Ya bo báluhu mayughu tee mu mibiili. ");
INSERT INTO tyx_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yiisu ályele kundaa bo ti: «Mu matala ma, liloŋono ya libiri mo kundaa mfumu a kyiri.» Bo bábiri nde mo. ");
INSERT INTO tyx_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mfumu a kyiri ályini madza ma mákighiri bviini. Nde ka ásoolo ku máfi mo o, lo basala ba báloŋono madza áli basoolo. Mfumu a kyiri áti baghala wu áakakie mbili ");
INSERT INTO tyx_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ya ályele kundaa nde ti: «Nswe mbwuru aatswama okataba baara bviini li libwe, ya baara bamana okolo mala, ŋa nseele nde aakapaha bviini liili ka lili nkara a li libwe o. Lo we, we aabunu bviini li libwe tee sonali!» ");
INSERT INTO tyx_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Obo me bu óbaana Yiisu osa bilyimi bii okiŋimi, mu elyimi ki ási nde ku Kaana lili Ngalile. Nde ásuo nsia a nde, ya binduono bi nde bísi kana mu nde. ");
INSERT INTO tyx_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ŋa mbihi oŋo, Yiisu ákumunu ku bvulu lili Kaperenawume, emõ ya ngughu a nde, bambwee ya binduono bi nde. Lo bo ka bási bitsughu bilagha oko o. ");
INSERT INTO tyx_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kyiri kii Paake li ba-Dzwife bu ebehene, Yiisu ákumu ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mu mbala a nzo a Nzaami nde ámono baara ba bákatyeghe bangoomo, bindoomo ya mabeeme, ya babo ba baakasobo nzi ba bábwi nsini. ");
INSERT INTO tyx_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yiisu bu abvughu misyi mi básyere, agyighili nswa-nswa, ábwi obyi baara bwohono mu mbala a nzo a Nzaami, bindoomo ya bangoomo, ya átsala mipara mi ba baakasobo nzi ya ápfumunu batabele ba bo. ");
INSERT INTO tyx_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ya nde ályele kundaa ba bákatyeghe mabeeme ti: «Limaha bilogho byehene bi ŋa ya linyaã osa nzo a Taara a me nzo a nkaala.» ");
INSERT INTO tyx_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Binduono bi nde bílibili mweẽ ti básono bu: «Dzyi li lilagha li ndi a me mu nzo a we sa lidzihi me ti anga mbaa.» ");
INSERT INTO tyx_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Lo ba-Dzwife báfwulu nde ti: «Nsa elyimi kii okiŋimi we aasa mu osuo bihi ti we li a muswa mu ogyighili mandagha ma?» ");
INSERT INTO tyx_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yiisu ábvuhulu bo ti: «Litsala nzo a Nzaami yi, ya mu bitsughu bitere, me sa firintehebe yo.» ");
INSERT INTO tyx_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ba-Dzwife bályele ti: «Nzo a Nzaami yi bátwu yo mu bamvulu makwumu-mana ya basemene (46), lo we mu bitsughu bitere, we sa firitehebe yo?» ");
INSERT INTO tyx_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lo nzo a Nzaami yi ákalyele nde me nyuru a ndeme. ");
INSERT INTO tyx_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mu obo, mu matala ma ósighili Yiisu mu lipfu, binduono bi nde bílibili mweẽ ti obo me bu ákabili nde. Ya bo bási kana mu Bisono bi Nzaami ya mu mandagha ma ólyele bo Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mu matala ma óli Yiisu ku kyiri kii Paake ku Yerusaleme, baara balagha bási kana mu nkwumu a nde ŋa bámono bo bilyimi bibi okiŋimi bi ákasa nde. ");
INSERT INTO tyx_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lo Yiisu ka ákasa emiini mu bo o, mu kuulu nde ákasoolo bo bwohono. ");
INSERT INTO tyx_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ya nde ka áli a nzala a kuulu ti basuo nde bumpughulu mu mbwuru o. Yiisu ndeme ákagyighili osoolo mi mili mu mukolo a mbwuru. ");
INSERT INTO tyx_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ankoho ŋa kara li ba-Faridzyẽ, óli a mumõ mu bamfumu ba ba-Dzwife, nkwumu a nde Nikodeme. ");
INSERT INTO tyx_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mu mpyibi, nde áyamono Yiisu ya ályele nde ti: «Muluo, bihi lisoolo ti we li muluo mumõ wu aafi kundaa Nzaami, mu kuulu ka oli a mbwuru wu kughu osa bilyimi bibi okiŋimi bi li mu okasa we, kala ti Nzaami ka li ya nde o.» ");
INSERT INTO tyx_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yiisu ábvuhulu kundaa nde ti: «Mu engaŋma, me ndyele we yo: Mbwuru si mumõ ka kughu omono Emfumu e Nzaami o, kala ti ka bafiriburu nde o.» ");
INSERT INTO tyx_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodeme áfwulu nde ti: «Bunu-abo bakughu oburu mbwuru wuulu ayi eŋmini? Nde kughu ofirisomo munsa mweẽ a ngughu a nde ya bafiriburu nde?» ");
INSERT INTO tyx_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yiisu ábvuhulu nde ti: «Mu engaŋma, me ndyele we yo: Mbwuru si mumõ ka kughu osomo mu Emfumu e Nzaami o, kala ti ka baburu nde mu madza ya mu Mufulu o. ");
INSERT INTO tyx_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wu báburu mu musunu li musunu, ya wu báburu mu Mufulu li mufulu. ");
INSERT INTO tyx_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ka kiŋimi o kala me aandyele we ti: “Bafaana ofiriburu we”. ");
INSERT INTO tyx_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lipwubu liikafulu ku lidzyi lo, ya we aakagyughu likyi li lo, lo we ka akasoolo o nki nkolo lo liikafa ya kunu-ako lo liikagye. Oboho si oli kundaa nswe munde wu baaburu mu Mufulu.» ");
INSERT INTO tyx_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodeme áfwulu nde ti: «Ndagha oyo bunu-abo yi kughu okala?» ");
INSERT INTO tyx_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yiisu ábvuhulu nde ti: «We li muluo mumõ mu Isarayele ya we ka soolo mandagha mamo o! ");
INSERT INTO tyx_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mu engaŋma me ndyele kundaa we ti: Bihi-a-be liikabili mu mandagha ma lisoolo, ya lili bampughulu mu mandagha ma liikamono. Lo be ka lili mu okasa kana mu bumpughulu ba lili mu okasuo bihi o. ");
INSERT INTO tyx_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kala ti be ka lisi kana mu me o ŋa aandyele me be mandagha mama ŋa nsie, bunu-abo be liisa kana mu me kala ti me ndyele be mandagha mama ku yulu? ");
INSERT INTO tyx_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mu kuulu mbwuru si mumõ nkini ámaakumu ku yulu o, kala ti ka oli yini a munde wu áafi ku yulu o, Mwana a mbwuru. ");
INSERT INTO tyx_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ya bwunu a bu óseene Moyidze ntaala mu yulu ku syehe, oboho si bafaana oseene Mwana a mbwuru, ");
INSERT INTO tyx_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","mpaala nswe mbwuru wu aasa kana, abagha laama lili mibvu ya mibvu mu nde. ");
INSERT INTO tyx_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mu obo, Nzaami bu ábvulu dzyi nsie, ágwi Mwana a nde wu a mbunu, mpaala nswe mbwuru wu aasa kana mu nde anyaã okpa, lo abagha laama lili mibvu ya mibvu. ");
INSERT INTO tyx_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mu kuulu Nzaami ka ágweghe Mwana a nde ŋa nsie mu oyalamana nsie o, lo mu kuulu nsie yibvwughu mu nde. ");
INSERT INTO tyx_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mbwuru wu aasa kana mu nde, ka balamana nde o. Lo munde wu aagwene osa kana, ayi bamaalamana nde, mu kuulu nde ka aasi kana mu nkwumu a Mwana a Nzaami wu a mbunu o. ");
INSERT INTO tyx_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mumfwunu me ngu wu: Otsyeme oogyi mu nsie, lo baara baabvulu odzyi opyini ŋa ebini kii otsyeme, mu kuulu bigyighili bi bo bili bi bibi. ");
INSERT INTO tyx_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mu kuulu, mbwuru wu aakasa bubi aakabele otsyeme ya ka kughu ogya ku otsyeme o, nde li a nzalamweẽ ti mara bigyighili bi nde bi bibi bimoŋono. ");
INSERT INTO tyx_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lo mbwuru wu aakasalala engaŋma aakagya ku otsyeme, mpaala bigyighili bi nde bimoŋono ti bye bili nsumu ya waa li Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ŋa mbihi oŋo, Yiisu ágyene ya binduono bi nde ku etsulu e nsie kii Yude. Nde ákala mana bitsughu oko ya bo, ya nde ákaboghoro baara. ");
INSERT INTO tyx_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Dzã si ákaboghoro baara ŋa bula bubu Enone, la we ya bula bubu Salime, mu kuulu oŋo óli a madza malagha. Baara bákagya kundaa nde ya nde ákaboghoro bo. ");
INSERT INTO tyx_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mu matala mamo, nkini áli bálo Dzã mu boloko o. ");
INSERT INTO tyx_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Lo mumbaŋana ábwi ŋa kara li binduono bi Dzã ya mu-Dzwife mumõ mu nkooro a muswagha wu a otsehebe manyuru. ");
INSERT INTO tyx_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bo báyamono Dzã ya bályele nde ti: «Muluo, mbwuru munde wu aali ya we ku ngulu a mwele wu a Dzurudẽ, munde wuulu we aasuo bumpughulu mu nde, mono, nde li mu okaboghoro, ya baara bwohono bali mu okagye kundaa nde.» ");
INSERT INTO tyx_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Dzã ábvuhulu kundaa bo ti: «Mbwuru okagyagha yini a ki ookagwa nde yulu. ");
INSERT INTO tyx_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Be, beme lili bampughulu ba me ŋa ándyele me ti: “Me ka ndi Kriste o, lo me ndi munde wu bágweghe ku nkulu a nde.” ");
INSERT INTO tyx_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nga-a-mukala me mulumu, lo ndughu a mulumu li ŋa bele a nde. Ndughu a mulumu aakagyughu nde ya likyi li nde liikaluhu nde mu esee. Ekye ngu esee e me, kye eli kii mukughu. ");
INSERT INTO tyx_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nde faana okulu mu mupfunu, ya me mfaana okughulu.» ");
INSERT INTO tyx_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Wu fi ku yulu li ŋa yulu a byehene. Wu a ŋa nsie li wu a nsie ya likyi li nde lili lili nsie. Wu fi ku mayulu li ŋa yulu a byehene, ");
INSERT INTO tyx_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ya li mpughulu mu mi aamono ya mu mi aagyughu nde. Lo mbwuru ka li mu okihi bumpughulu bu nde o. ");
INSERT INTO tyx_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Munde wu aakihi bumpughulu bu nde li mu osuo ti mi oolyele Nzaami mili mimi ngaŋma. ");
INSERT INTO tyx_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mbwuru wu ógweghe Nzaami ályele mandagha ma Nzaami, mu kuulu Nzaami ágwi nde Mufulu a nde mukughu. ");
INSERT INTO tyx_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taara dzyi Mwana ya nde aagwi bilogho byehene ŋa myaã mi nde. ");
INSERT INTO tyx_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Munde wu aasa kana mu Mwana li a laama lili mibvu ya mibvu. Munde wu aagwene osa kana mu Mwana ka abagha laama o, lo nkehe a Nzaami sa yikakala ŋa yulu a nde.» ");
INSERT INTO tyx_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yiisu bu ásoolo ti ba-Faridzyẽ bágyughu ti nde ábvulukabagha ya okaboghoro binduono ku oluru Dzã, ");
INSERT INTO tyx_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ngu okala ti Yiisu ndeme ka ákaboghoro o, lo binduono bi nde bíikaboghoro), ");
INSERT INTO tyx_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","nde ámara ku etsulu e nsie kii Yude ya ábvughuru ku Ngalile. ");
INSERT INTO tyx_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mu obo, nde áli faana obululuru mu nsie yi a Samari. ");
INSERT INTO tyx_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Me obo nde áyato ŋa Sisyare, bvulu limõ li lili mu etsulu e nsie kii Samari, ŋa bele a nseghe yi ógwi Dzakobe kundaa mwana a nde Dzodzefe. ");
INSERT INTO tyx_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Oŋo óli a dzunu li madza li Dzakobe. Yiisu bu akolo mu dzwe, ákarabwa nsini ŋa mukogho a dzunu li madza. Áli oli ku bele a tala lili embehe. ");
INSERT INTO tyx_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mukaha mutsyini wu a musi Samari áyatyeghe madza. Yiisu ályele kundaa nde ti: «Gwa me madza mama oŋma.» ");
INSERT INTO tyx_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Binduono bi nde bígyene ku bvulu mu oyiswumu bi-odza. ");
INSERT INTO tyx_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Lo mukaha wu a musi Samari ályele nde ti: «Bunu-abo we wu li mu-Dzwife kughu oluomo madza mama oŋma kundaa me wu ndi musi Samari?» Mu kuulu, ba-Dzwife bákabihi okala emõ ya basi Samari. ");
INSERT INTO tyx_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yiisu ábvuhulu kundaa nde ti: «Kala ti we áli soolo ekaba e Nzaami, ya nande li mbwuru wu aalyele kundaa we ndiri: “Gwa me madza mama oŋma”, me we nkini kaaluomo nde mo, ya nde kaagwa we madza mama bumweẽ.» ");
INSERT INTO tyx_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mukaha ályele ti: «Mfumu, we ka li a elogho o ki ogwolo madza, ya dzunu li madza lili lila. Kunu we aabagha madza mamo mama bumweẽ? ");
INSERT INTO tyx_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Bunu! We bvulu taara a bihi, mukwuru a bihi Dzakobe? Me nde áasihi bihi dzunu li madza li, ya ndeme si áŋmi madza ma lo, bumõ si kundaa baana ya bibuolo bi nde.» ");
INSERT INTO tyx_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yiisu ábvuhulu kundaa nde ti: «Nswe munde wu aaŋma madza ma sa afiribagha nyoro. ");
INSERT INTO tyx_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Lo munde wu akala aaŋma madza ma akala aangwa me nde, nde ka afiribagha nyoro o. Ya madza ma akala aangwa me nde sa makala mu nde mukele wu aakapaha madza mama laama lili mibvu ya mibvu.» ");
INSERT INTO tyx_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mukaha ályele kundaa nde ti: «Mfumu, gwa me madza mamo mpaala me nyaã ofiribagha nyoro, ya me nyaã ofirikayatyeghe madza ŋa.» ");
INSERT INTO tyx_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yiisu ályele kundaa nde ti: «Gye, yita mulumu a we mbili ya yabvughuru ŋa.» ");
INSERT INTO tyx_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mukaha ábvuhulu nde ti: «Me ka ndi a mulumu o.» Yiisu ályele kundaa nde ndiri: «We li a bwuu bu lyele ti: “Me ka ndi a mulumu o”. ");
INSERT INTO tyx_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mu kuulu we aali a babaghala bataana ya munde wu li ya we mu matala ma ka li mulumu a we o. Mu obo we lyele ngaŋma.» ");
INSERT INTO tyx_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mukaha ályele kundaa nde ti: «Mfumu, me mono ti we, we li mubighili. ");
INSERT INTO tyx_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bataara ba bihi bákasamana ku yulu a munguo wu, ya be liikalyele ti ebini ki efaana mu okasamana eli ku Yerusaleme.» ");
INSERT INTO tyx_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yiisu ályele kundaa nde ti: «Mukaha, sa kana mu ma aandyele me, matala mali mu ogya maala be akala ka liisamana Taara ku yulu a munguo wu o, ngu okala ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Be, basi Samari liikasamana wu ligwene osoolo. Bihi, ba-Dzwife liikasamana wu lisoolo bihi, mu kuulu obvwughu ógyi mu ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lo matala mali mu ogya, ya mu bu mo mamaato, maala ba baakasamana baba ngaŋma sa basamana Taara mu mufulu ya mu engaŋma. Baara ba baakasamana obo, me ba ookasagha Taara. ");
INSERT INTO tyx_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nzaami li Mufulu, mu obo, ba baakasamana nde bafaana okasamana mu mufulu ya mu engaŋma.» ");
INSERT INTO tyx_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mukaha ályele kundaa nde ti: «Me nsoolo ti Mesi sa agya, munde wu baakata ti Kriste. Ŋa akala aagya nde, nde sa alyele bihi mandagha mwohono.» ");
INSERT INTO tyx_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yiisu ályele kundaa nde ti: «Me ndi Mesi, me wu li mu okabili ya we.» ");
INSERT INTO tyx_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mu matala mamo binduono bi nde bíyato ya bye bíkiŋimi mu omono Yiisu mu okabili ya mukaha. Lo mbwuru si mumõ ka áfwulu nde o ti: «Emakye we li mu okasagha?» Bwunu we «Nsa ndagha we li mu okabili ya nde?» ");
INSERT INTO tyx_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Oŋo mukaha ábulusihi yughu li nde, ágyene ku bvulu ya ályele kundaa baara ti: ");
INSERT INTO tyx_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ligya limono mbwuru wu aalyele me mandagha mwohono ma aansi me. Nde ka li Kriste o?» ");
INSERT INTO tyx_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bo bápala mu bvulu ya bágyi kundaa nde. ");
INSERT INTO tyx_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mu matala mamo, binduono bíkabuono nde ya bíkalyele ti: «Muluo, dza!» ");
INSERT INTO tyx_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lo nde ályele bo ti: «Me sa ndza bi-odza biili be ka ligyahaba bye o.» ");
INSERT INTO tyx_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mu obo, binduono bíbwi ofuhunu bye-a-bye ti: «Bunu, mbwuru aayabiri nde bi-odza?» ");
INSERT INTO tyx_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yiisu ályele kundaa bo ti: «Bi-odza bi me, ngu osa waa li munde wu aagweghe me ya omana esala e nde. ");
INSERT INTO tyx_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Bunu, be beme ka liikalyele o ti: “Bangoono bana basyili ya matala mama otolo bimburu sa magya”? Lo me bu ndyele be ti: Liseene mihi ya litala manseghe: bimburu biigyele ya biifaana mu otolo! ");
INSERT INTO tyx_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mbwuru wu aakatolo bimburu maabagha mufuru a nde, ya li mu okakwu bimburu mu laama lili mibvu ya mibvu, mpaala munde wu aakunu ya munde wu aatolo bakala emõ mu esee. ");
INSERT INTO tyx_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mu kuulu nkumu yi aakalyele ti: “Mumõ wu aakunu, wu muke wu aatolo” yili yi a ngaŋma. ");
INSERT INTO tyx_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Me aangweghe be mu oyitolo bimburu biili be ka liimono mpara mu osala bye o. Bakimi báasala bye, ya be liigyi mu otolo bimburu bi esala e bo.» ");
INSERT INTO tyx_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Basi Samari balagha baba bvulu lilo bási kana mu Yiisu mu nkooro a bumpughulu bu mukaha wu áalyele ti: «Nde aalyele me mandagha mwohono ma aansi me.» ");
INSERT INTO tyx_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ya basi Samari bu bayato ŋa áli nde, bo báluomo nde mu okala ya bo. Ya nde áluhu bitsughu byele ya bo. ");
INSERT INTO tyx_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Baara balagha báfirisa kana mu nkooro mandagha ma ákalyele ndeme. ");
INSERT INTO tyx_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ya bo bályele kundaa mukaha ti: «Ka oli yini a mu nkooro a mi aalyele we bihi, bihi liisi kana o, mu kuulu bihi liigyughu nde bihi bameme ya bihi lisoolo ti, ngaŋma wu me Mubvwuhu a nsie.» ");
INSERT INTO tyx_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ŋa mbihi a bitsughu byele bibye, Yiisu ámara ŋa bvulu lilo, ya ágyene ku Ngalile. ");
INSERT INTO tyx_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mu kuulu ndeme áli ályele ti ka baakagwa mubighili budziri mu nsie a ndeme o. ");
INSERT INTO tyx_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Lo nde bu ayato ku Ngalile, basi Ngalile bábwana a nde bubwe, mu kuulu boho si báli ku Yerusaleme ku kyiri kii Paake, ya bomo si áli bámono mandagha ma ágyighili nde. ");
INSERT INTO tyx_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mu obo, Yiisu áfiriyabvughuru ku Kaana mu etsulu e nsie kii Ngalile ku ákirili nde madza bviini. Óli ya mfumu a bambumbulu ba mukogho mumõ wu áali a mwana wu baghala wu mubyele ku Kaperenawume. ");
INSERT INTO tyx_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nde bu agyughu ti Yiisu aafi ku etsulu e nsie kii Yude mu ogye ku etsulu e nsie kii Ngalile, nde áyimono Yiisu ya ábuono nde akumunu mpaala adzuhu mwana a nde wu baghala wu áakadzwana ya lipfu. ");
INSERT INTO tyx_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Mu obo Yiisu ályele kundaa nde ti: «Kala ti be ka limono bilyimi bibi okiŋimi ya bimaã o, si okala a bunu be ka lisa kana o!» ");
INSERT INTO tyx_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mfumu a bambumbulu ályele kundaa nde ti: «Mfumu, kumunu nsomo mwana a me akpa!» ");
INSERT INTO tyx_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yiisu ályele kundaa nde ti: «Gye, mwana a we li mweẽ.» Baghala munde ási kana mu ndagha yi ólyele nde Yiisu ya ágyene. ");
INSERT INTO tyx_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nde áli nkini mu okakumunu ŋa óyabwana a nde basala ba nde ba bályele kundaa nde ti: «Mwana a we wu baghala li mweẽ!» ");
INSERT INTO tyx_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nde áfwulu bo ti: «Mu nsa matala mwana aamono bubwe?» Bo bábvuhulu ti: «Matsighi, tala limõ ŋa mbihi a embehe, mukaama aafi nde.» ");
INSERT INTO tyx_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Oŋo taara a mwana ábaghala ti me mu tala lyini lilo Yiisu ályele kundaa nde ti: «Mwana a we wu baghala li mweẽ!» Obaana oŋo, nde ya baara ba nzo a nde bwohono bási kana. ");
INSERT INTO tyx_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ekye éli elyimi kii okiŋimi kii byele ki ósi Yiisu ku Ngalile, mu matala ma áfi nde ku Yude. ");
INSERT INTO tyx_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ŋa mbihi oŋo, mu matala mama kyiri emõ kii ba-Dzwife, Yiisu ákumu ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ankoho, ku Yerusaleme ŋa bele a muŋma a nzo a Bindoomo, óli a edzyi ki madza ki baakata mu eebele ti Betesata. Kye éli a biluru bitaana. ");
INSERT INTO tyx_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ku nsie a biluru bibye, óli a mpwumu a babyele yi agyoŋomo: Binkpa-mihi, banga a mitele myele, ba oneŋene binama. ");
INSERT INTO tyx_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mu kuulu mu matala ma make, ngye-yulu a Mfumu ákakumunu munsa edzyi ya ákanyihi madza. Ŋa okanyiŋi madza, mbwuru wu a nsomo wu áakabwa munsa edzyi, ákadzughu mu ebyele nswe ebyele. ");
INSERT INTO tyx_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Oŋo, óli a mbwuru mumõ wu áasi bamvulu makwumu-matere ya mpuomo (38) kunsa obyele. ");
INSERT INTO tyx_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yiisu ámono nde ágyoŋomo ya bu asoolo ti nde ási matala malagha kunsa obyele, áfwulu nde ti: «We dzyi odzughu?» ");
INSERT INTO tyx_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mubyele ábvuhulu kundaa nde ti: «Mfumu, me ka ndi a mbwuru wu aalo me mu edzyi o mu matala ma ookanyiŋi madza. Ŋa aakansagha me osughuru omo, agwolo mbwuru mukimi aakatswama osughuru ŋa nkulu a me.» ");
INSERT INTO tyx_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yiisu ályele kundaa nde ti: «Temene, gwolo laba li we ya gye.» ");
INSERT INTO tyx_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ŋaana oŋo baghala munde ádzughu, ágwolo laba li nde ya ábwi odzyara. Ankoho etsughu ekye éli etsughu kii Sabate. ");
INSERT INTO tyx_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mu obo, bakwuru ba ba-Dzwife bályele kundaa mbwuru munde wu áadzughu ti: «Lolo etsughu kii Sabate, we ka li a muswa mu obiri laba li we o.» ");
INSERT INTO tyx_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nde ábvuhulu kundaa bo ti: «Mbwuru munde wu aadzuhu me, me nde aalyele me ti: “Gwolo laba li we ya dzyara.”» ");
INSERT INTO tyx_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bo báfwulu nde ti: «Baghala wu aalyele we ti: “Gwolo laba li we ya dzyara” nande ali?» ");
INSERT INTO tyx_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Lo munde wu áadzughu ka ákasoolo nande baghala munde áli o, mu kuulu Yiisu ásomo kunsa mpwumu a baara yi áali ŋa ebini ekye. ");
INSERT INTO tyx_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ŋa nseele, Yiisu ámono mbwuru munde munsa nzo a Nzaami, ályele kundaa nde ti: «Mono we ayi nsiili! Ka firisa masumu o, mara ndagha yibvulu bubi yibwi mu we!» ");
INSERT INTO tyx_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mbwuru munde áyilyele kundaa bakwuru ba ba-Dzwife ti áli Yiisu áadzuhu nde. ");
INSERT INTO tyx_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mu obo, ba-Dzwife bábaana oswehẽ Yiisu mu kuulu nde ágyighili ndagha oyo mu etsughu kii Sabate. ");
INSERT INTO tyx_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Lo Yiisu ábvuhulu kundaa bo ti: «Tee sonali Taara a me li mu okasala, ya mehe si ndi mu okasala.» ");
INSERT INTO tyx_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mu nkooro a ndagha oyo, bakwuru ba ba-Dzwife bákabvulu osagha nde odzwa, mu kuulu nde ka yini a bungili bu etsughu kii Sabate ákatsumunu o. Lo nde ákalyele si ti Nzaami li Taara a ndeme. Mbimbili oyo yíkasuo ti nde li nsihi ya Nzaami. ");
INSERT INTO tyx_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yiisu ábvuhulu kundaa bo ti: «Mu engaŋma me ndyele be ti, Mwana ka kughu ogyighili ndagha si mõ mu endeme o, lo nde akagyili yini a mandagha ma aakamono nde Taara mu ogyighili. Ma ookagyighili Taara, me maana mamo si Mwana aakagyighili. ");
INSERT INTO tyx_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Buulu Taara dzyi Mwana ngu aakasuo nde mandagha mwohono ma aakasa nde. Nde sa afirisuo nde bigyighili bi bibvulu bunene, mpaala be likiŋimi. ");
INSERT INTO tyx_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bwunu a bu ookasiili Taara baara ba bákpi ya aakagwa bo bumweẽ, bwunu obo si Mwana aakagwa bumweẽ kundaa munde wu adzyi nde. ");
INSERT INTO tyx_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ya Taara ka aakalamana mbwuru o, lo nde aagwi litumu lwohono lili okalamana kundaa Mwana, ");
INSERT INTO tyx_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","mpaala baara bwohono bagwa Mwana budziri ti bwunu a bu baakagwa Taara budziri. Mbwuru wu aagwene ogwa Mwana budziri, nde ka li mu ogwa si Taara wu aagweghe nde budziri o.» ");
INSERT INTO tyx_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Mu engaŋma, me ndyele be ti: Mbwuru wu gyughu ndagha a me ya si kana mu munde wu aagweghe me, nde li a laama lili mibvu ya mibvu. Nde ka agya ku mumfwunu o, lo nde aamara ku lipfu ya aaluru ku bumweẽ. ");
INSERT INTO tyx_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mu engaŋma, me ndyele be ti: Lo matala mali mu ogya, ya mu bu mo mamaato, maala ba bákpi sa bagyughu likyi li Mwana a Nzaami ya babo ba akala baagyughu lo sa bakala baba mweẽ. ");
INSERT INTO tyx_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mu kuulu, bwunu a bu oli a Taara bumweẽ mu ndeme, oboho si bu aagwi nde Mwana mu okala a bumweẽ mu ndeme. ");
INSERT INTO tyx_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ya nde aagwi nde litumu lili olamana mu kuulu nde li Mwana a mbwuru. ");
INSERT INTO tyx_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nyaã ka likiŋimi o mu mandagha mwohono ma! Matala mali mu ogya maala baara bwohono ba bali munsa mampyeme sa bagyughu likyi li nde, ");
INSERT INTO tyx_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ya bo sa bapala. Babo ba bási mandagha ma mabwe sa bapala ya basighili mu lipfu mu okala baba mweẽ. Babo ba bási mandagha ma mabi, sa basighili mu lipfu mu osomo mu mumfwunu. ");
INSERT INTO tyx_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Me, me ka nkughu ogyighili ndagha mu ememe o. Me aakandamana bwunu a bu oli mandagha ma aakangyughu me, ya olamana o me oli nsumu, mu kuulu me ka aakansagha waa li meme o, lo waa li munde wu aagweghe me.» ");
INSERT INTO tyx_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Kala ti me, me ndi mpughulu mu meme, bumpughulu bu me ka buli bubu ngaŋma o. ");
INSERT INTO tyx_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Lo mbwuru mukimi aakala mpughulu mu me, ya me nsoolo ti bumpughulu bu nde mu me buli bubu ngaŋma. ");
INSERT INTO tyx_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Me be liigweghe baara kundaa Dzã, ya nde li mu osuo bumpughulu bu engaŋma. ");
INSERT INTO tyx_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mu me, me ka ndi a nzala a bumpughulu bu mbwuru o, lo me mbili obo mpaala be libvwughu. ");
INSERT INTO tyx_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Dzã áli mwindi wu bánahaba ya wu li mu okasehene. Ya be liidzyi okala mu esee kunsa otsyeme o nde mu mana matala.» ");
INSERT INTO tyx_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Lo me ndi a bumpughulu bu bubvulu bunene ya bubu Dzã: Ngu mandagha ma aakangyighili me, ma ootumu me Taara ogyighili. Mandagha ma aakangyighili me, mali bumpughulu bu me ti Taara aagweghe me. ");
INSERT INTO tyx_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ya Taara wu aagweghe me ndeme si aasuo bumpughulu mu me. Lo be nkini límaagyughu likyi li nde o, nkini límaamono edzili e nde si o. ");
INSERT INTO tyx_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ya ndagha a nde ka yili mu be o, mu kuulu be ka liisi kana mu munde wu aagweghe nde o. ");
INSERT INTO tyx_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Be liikakeene Bisono mu kuulu be liikatsimi obagha laama lili mibvu ya mibvu mu bye. Ankoho, me bisono bibye byeme biikasuo bumpughulu mu me. ");
INSERT INTO tyx_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ya be ka lidzyi ogya kundaa me mu obagha laama o.» ");
INSERT INTO tyx_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Me ka aakansagha nsia yi aafa kundaa baara o. ");
INSERT INTO tyx_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lo me nsoolo be, be ka lili a dzyi li Nzaami mu be o. ");
INSERT INTO tyx_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Me aangyi mu nkwumu a Taara a me, ya be ka lili mu ogyagha me o. Lo kala ti mbwuru mukimi gyi mu nkwumu a ndeme, munde be sa ligyagha nde! ");
INSERT INTO tyx_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bunu-abo be likughu osa kana, be ba liikagwa be a be nsia, ya ba liikuono okasagha nsia yi aakafa yini a kundaa Nzaami? ");
INSERT INTO tyx_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ka litsimi o ti me akala aanfwunu be ŋa nkulu a Taara. Ngu Moyidze akala aafwunu be, mu kuulu mu nde be liisi emiini. ");
INSERT INTO tyx_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kala ti be liikasa kana mu Moyidze, likaasa kana mu mehe si, mu kuulu nde ásono mu mi mitala me. ");
INSERT INTO tyx_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lo kala ti be ka lisi kana mu bisono bi nde o, bunu-a-bo be liisa kana mu mi aandyele me?» ");
INSERT INTO tyx_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ŋa mbihi oŋo, Yiisu ágyene ku ngulu yinke yi a mubu wu a Ngalile, wu baakata si mubu wu a Tiberyade. ");
INSERT INTO tyx_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mpwumu a baara yi nene yíkanama nde mu kuulu baara bákamono bilyimi bibi okiŋimi bi ákasa nde mu babyele. ");
INSERT INTO tyx_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yiisu ákumu ku yulu a munguo ya ábwi nsini oŋo ya binduono bi nde. ");
INSERT INTO tyx_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Paake, kyiri ki ba-Dzwife áli ébehene. ");
INSERT INTO tyx_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yiisu bu asiili busu, ámono mpwumu a baara yi nene yi ákagya kundaa nde. Nde áfwulu kundaa Filipe ti: «Kunu-ako liiswumu mampa mpaala baara ba badza?» ");
INSERT INTO tyx_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nde ályele obo mu otsihi nde, mu kuulu nde ndeme áli asoolo ma ákaagyighili. ");
INSERT INTO tyx_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipe ábvuhulu kundaa nde ti: «Ngu okala ti liswumu mampa mama nkama ywolo (200) yi a badenye, mu kuulu nswe mbwuru abagha mana etsulu ki limpa, ka makughu o.» ");
INSERT INTO tyx_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andere, mwana a taara a Simõ-Piere, mumõ mu binduono bi nde, ályele nde ti: ");
INSERT INTO tyx_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Oli a mumpala ŋa wu li a mampa mataana mama mu mburu a oredze ya binswi-nswi byele, lo bibye sa bikughu mu mpwumu a baara yi?» ");
INSERT INTO tyx_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ŋa ebini ekye óli a nsele alagha yi a maŋeẽ. Yiisu ályele ti: «Libwihi bo mansini.» Bo bábwi mansini. Mutala a babaghala ba báli oŋo áli ku bele a mapfwunu mataana (5 000). ");
INSERT INTO tyx_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yiisu ágwolo mampa, bu abvurulu matuono kundaa Nzaami, ákaba mo kundaa baara ba báli oŋo. Nde ási bwunu obo si mu banswi, ya bágwi bo bye ti bwunu a bu óli nzala a nswe mbwuru. ");
INSERT INTO tyx_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bu bagyughuru, Yiisu ályele kundaa binduono bi nde ti: «Litolo bitsulu bi biisyili mpaala binyaã odzimini.» ");
INSERT INTO tyx_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bo bábvughu bye ya báluhu bitubu kwumu ya byele (12) mu bitsulu bi bísyili mu mampa mataana mama mu oredze ma óli baara. ");
INSERT INTO tyx_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Baara bu bamono elyimi kii okiŋimi ki ósi Yiisu, bo bályele ti: «Ngaŋma, mbwuru wu li mubighili wu faana ogya ŋa nsie.» ");
INSERT INTO tyx_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Lo Yiisu, bu asoolo ti baara bákaayagwolo nde mu mpini mu obyaha nde mukogho, nde ákaghaba ya bo ya áfirigye ku munguo ngasighi. ");
INSERT INTO tyx_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nkonkolo bu yito, binduono bi Yiisu bíkumunu tee ku mukogho a mubu. ");
INSERT INTO tyx_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bo básomo mu bwara bu bunene ya bábwi ogye ku Kaperenawume, ku ngulu a mubu yinke. Mpyibi áli yimaabwa, ya Yiisu nkini áli ka ayato ŋa báli bo o. ");
INSERT INTO tyx_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Efulu kii mpini ékafulu ya madza ma mubu makateeme ku olagha. ");
INSERT INTO tyx_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bo bu badzughu bwara mu etiiri ki bakilometere bataana bwunu we basemene, bo bámono Yiisu mu okayadzyara ŋa yulu a madza ma mubu ya ákayabehene ya bwara. Bo bábagha nzalamweẽ. ");
INSERT INTO tyx_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lo Yiisu ályele bo ti: «Wu me, ka likala a nzalamweẽ o!» ");
INSERT INTO tyx_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bo bákasagha osohobo nde mu bwara, lo ŋaana-oŋo bwara búkulu mu nsie ŋa ebini ki bákagye bo. ");
INSERT INTO tyx_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ŋa mbihi a etsughu ekye, mpwumu a baara yi áasyili ku ngulu a mubu yinke, yíbaghala ti oŋo óli a yini a bwara bumõ, ya Yiisu ka áli ágyene mu bwara ya binduono bi nde o. Bo áli bágyene bo ngasighi. ");
INSERT INTO tyx_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mabwara ma make ma máfi ku bvulu lili Tiberyade máyato ŋa bele a ebini ekye ŋa báli bo mampa ŋa mbihi a ŋa óbvurulu Mfumu matuono. ");
INSERT INTO tyx_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mpwumu a baara bu yimono ti, ngu okala Yiisu, ngu okala binduono bi nde, ka báli oŋo o, baara básomo mu mabwara ya bágyene ku Kaperenawume mu okabulusagha Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Baara bu bamono Yiisu ku ngulu yinke yi a mubu, bo báfwulu nde ti: «Muluo, we munsa matala aayato kunu?» ");
INSERT INTO tyx_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yiisu ábvuhulu ti: «Mu engaŋma me ndyele be, ka mu nkooro a bilyimi bibi okiŋimi bi liimono be lili mu okasagha me o, lo mu nkooro a bu liili be mampa ya liigyughuru. ");
INSERT INTO tyx_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ka likasala mu obagha bi-odza biili sa bipfighili o, lo liikasala mu bi-odza biili sa bilaama mu mibvu ya mibvu. Bi-odza bibye me bi akala oogwa be Mwana a mbwuru, buulu me nde, Taara wu li Nzaami, ágwi enyeme kii litumu.» ");
INSERT INTO tyx_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mu obo, bo báfwulu nde ti: «Emakye bihi lifaana osa mu okuhu bigyighili bi Nzaami?» ");
INSERT INTO tyx_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yiisu ábvuhulu bo ti: «Bigyighili bi Nzaami me mu osa kana mu munde wu aagweghe ndeme.» ");
INSERT INTO tyx_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mu obo bo báfwulu kundaa nde ti: «Bu we, nki elyimi kii okiŋimi we aasa mpaala bihi limono ya lisa kana mu we? Nsa bigyighili we aasa? ");
INSERT INTO tyx_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ku syehe, bataara ba bihi áli báli maane ti bu básono: Nde ágwi bo limpa li lífi ku yulu mu odza.» ");
INSERT INTO tyx_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Lo Yiisu ályele bo ti: «Mu engaŋma, me ndyele be, ka oli Moyidze áagwi be limpa lili ku yulu o, lo me Taara a me gwi be nkara limpa lili yulu. ");
INSERT INTO tyx_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mu kuulu limpa li Nzaami, lili lilo li liifi ku yulu liiyakumunu ŋa nsie ya liikagwa nsie bumweẽ.» ");
INSERT INTO tyx_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bo bályele nde ndiri: «Mfumu, aakagwa bihi limpa lilo matala mwohono!» ");
INSERT INTO tyx_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yiisu ályele bo ti: «Ngu me ndi limpa lili bumweẽ. Munde wu aagya kundaa me ka afirifuru nzala o, munde wu aasa kana mu me, ka afiribagha nyoro a madza o.» ");
INSERT INTO tyx_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","«Lo me aandyele be ti: Be liimono me, lo be ka liisi kana o. ");
INSERT INTO tyx_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bo bwohono ba oogwa me Taara, bo sa bagya kundaa me, ya wu aagya kundaa me, me akala ka ambyi nde agye ku mbala o. ");
INSERT INTO tyx_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mu kuulu me aamfi ku yulu aayankumunu ŋa nsie ka mu osa waa li meme o, lo mu osa waa li munde wu aagweghe me. ");
INSERT INTO tyx_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Waa li munde wu aagweghe me lili ti me nyaã odzihibi mbwuru mumõ mu babo ba ágwi nde me, lo me nsiili bo mu lipfu mu etsughu kii masini. ");
INSERT INTO tyx_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Waa li Taara a me ti nswe munde wu aamono Mwana ya si kana mu nde sa abagha laama lili mibvu ya mibvu. Ya me, me sa nsiili nde mu lipfu mu etsughu kii masini.» ");
INSERT INTO tyx_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ba-Dzwife bábaana oŋuŋunu mu nkooro a nde buulu nde ályele ti: «Me ndi limpa li liifi ku yulu liiyakumunu ŋa nsie.» ");
INSERT INTO tyx_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ya bo bákalyele ti: «Bunu, wu ka li Yiisu mwana Dzodzefe o, wuulu bihi lisoolo taara ya ngughu a nde? Bunu nde akughu olyele mu matala ma ti: “Me aamfi ku yulu aayankumunu ŋa nsie?”» ");
INSERT INTO tyx_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yiisu ábvuhulu kundaa bo ti: «Linyaã miŋuŋunu ŋa kara li be! ");
INSERT INTO tyx_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mbwuru ka kughu ogya kundaa me kala ti Taara wu aagweghe me ka ati nde mbili o, ya me, me sa nsiili nde mu lipfu mu etsughu kii masini. ");
INSERT INTO tyx_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Básono bu mu mikaana mi mibighili: Nzaami sa aluo bo bwohono. Nswe munde wu aagyughu mi miifa kundaa Taara ya kihi maluo ma nde, nde gyi kundaa me. ");
INSERT INTO tyx_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mu kuulu mbwuru nkini ka ámaamono Taara o, kala ti ka yini a munde wu aafi kundaa Nzaami o. Munde aamono Taara. ");
INSERT INTO tyx_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mu engaŋma me ndyele be, munde wu aasa kana li a laama lili mibvu ya mibvu. ");
INSERT INTO tyx_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Me ndi limpa lili bumweẽ. ");
INSERT INTO tyx_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ku syehe bataara ba be báli maane, ya bo bápki. ");
INSERT INTO tyx_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Li me limpa li liifi ku yulu liiyakumunu ŋa nsie, nswe mbwuru wu aadza lo ka akpa o. ");
INSERT INTO tyx_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Me me ndi limpa lili bumweẽ li liifi ku yulu liiyakumunu ŋa nsie. Wu aadza limpa li, sa akala mweẽ mu mibvu ya mibvu. Limpa li akala aangwa me, ngu nyuru a me yi akala aangwa me mpaala nsie yibagha laama.» ");
INSERT INTO tyx_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mu obo ba-Dzwife bábaana obaŋana bo-a-bo ya bákalyele ti: «Bunu-abo nde akughu ogwa bihi nyuru a nde odza?» ");
INSERT INTO tyx_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yiisu ályele bo ti: «Mu engaŋma, me ndyele be, kala be ka lili nyuru a Mwana a mbwuru o ya kala ti be ka liŋmi makili ma nde o, be ka likala a laama mu be o. ");
INSERT INTO tyx_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nswe munde wu aadza nyuru a me ya oŋma makili ma me li a laama lili mibvu ya mibvu, ya me sa nsiili nde mu lipfu mu etsughu kii masini. ");
INSERT INTO tyx_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Buulu nyuru a me yili bi-odza bibi ngaŋma, ya makili ma me mali mala mama ngaŋma. ");
INSERT INTO tyx_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nswe munde wu aadza nyuru a me ya oŋma makili ma me, nde sa akala mu me ya me mu nde. ");
INSERT INTO tyx_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Taara wu áagweghe me li mweẽ ya me ndi mweẽ mu Taara. Mu obo, nswe munde wu aadza me sa akala mweẽ mu me. ");
INSERT INTO tyx_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Li me limpa li liifi ku yulu li liiyakumunu ŋa nsie. Lo ka lili ti anga limpa li óli bataara ba be o. Bo bwohono bápki, lo nswe munde wu aadza limpa li sa akala mweẽ mu mibvu ya mibvu.» ");
INSERT INTO tyx_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Mamo mandagha ma óluo Yiisu ku Kaperenawume, mu nzo a lisamana a ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ŋa mbihi a ŋa bágyughu bo mandagha ma Yiisu mamo, balagha mu binduono bi Yiisu báalyele ti: «Mandagha ma maluru mpini! Nande kughu okihi mo?» ");
INSERT INTO tyx_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Lo, Yiisu bu asoolo ti binduono bi nde bíkaŋuŋunu mu nkooro a mandagha mamo, nde áfwulu bo ti: «Mandagha ma kya mali kundaa be? ");
INSERT INTO tyx_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ya kala ti be limono Mwana a mbwuru mu okumu ku áli nde nsomo? ");
INSERT INTO tyx_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Me mufulu aakagwa bumweẽ, nyuru ka yiikagyighili ndagha o. Mandagha ma áandyele me be mali mufulu ya bumweẽ. ");
INSERT INTO tyx_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Lo baara babake ŋa kara li be ka baakasa kana o.» Mu kuulu obaana ku ebaana, Yiisu áli asoolo baara babo ba baagwene okasa kana, ya nande áali munde wu akala aatyeghe nde. ");
INSERT INTO tyx_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ya nde ábwehe: «Me mu obo me áandyele be ti: “Mbwuru ka kughu ogya kundaa me kala Taara ka gwi nde muswa o.”» ");
INSERT INTO tyx_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Obaana matala mamo, balagha mu binduono bi nde báabvughuru mbihi ya báanyaã ofirikagye ya nde. ");
INSERT INTO tyx_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mu obo Yiisu ályele kundaa Kwumu ya Buolo (12) ti: «Lo be, behe si lidzyi ogye?» ");
INSERT INTO tyx_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simõ-Piere ábvuhulu kundaa nde ti: «Mfumu, kundaa na bihi liigye? We li a mandagha mama laama lili mibvu ya mibvu. ");
INSERT INTO tyx_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ya bihi, bihi liisi kana ya bihi lisoolo ti we li Wu-a-Ngili a Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yiisu ábvuhulu kundaa bo ti: «Ka oli me áansuolo be, be bansa Kwumu ya Buolo o (12)? Lo ŋa kara li be, mumõ li dyabulu!» ");
INSERT INTO tyx_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nde ákabili obo mu Yuda, mwana a Simõ musi Isikaryote, mu kuulu me nde, mumõ mu Kwumu ya Buolo (12), wu akala aatyeghe nde. ");
INSERT INTO tyx_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ŋa mbihi oŋo, Yiisu ákabuludzye mu etsulu e nsie kii Ngalile. Nde ka ákadzyi ogye ku Yude o, mu kuulu ba-Dzwife bákasagha nde odza. ");
INSERT INTO tyx_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lo kyiri ki ba-Dzwife kii Bidzwama ébehene. ");
INSERT INTO tyx_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bambwee ba Yiisu bályele nde ti: «Mara ŋa ya gye ku Yude mpaala binduono bi wehe si bimono bigyighili bi li mu okasa we. ");
INSERT INTO tyx_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mbwuru ka aakasala mu ensweghe o kala nde dzyi ti baara ba nsie basoolo nde. Buulu we aagyighili mandagha mama obo, sa kuulu ti baara bwohono basoolo we!» ");
INSERT INTO tyx_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bambwee ba nde bomo si ka bákasa kana mu nde o. ");
INSERT INTO tyx_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yiisu ályele bo ti: «Matala mama ndaa-me nkini maato o, lo mu be, matala mwohono mali ma mabwe. ");
INSERT INTO tyx_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nsie ka yikughu be obele o, lo me, yo yili mu okabele me mu kuulu me aankasuo bumpughulu ti bigyighili bi yo bili bi bibi. ");
INSERT INTO tyx_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Be, likumu o be ku kyiri. Me, me ka nkumu ku kyiri ekye o, mu kuulu matala mama ndaa-me nkini maakughu o.» ");
INSERT INTO tyx_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nde ámana obili obo, ásyili ku Ngalile. ");
INSERT INTO tyx_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Lo mu matala ma ógyene bambwee ba nde ku Kyiri, ndehe si ábwi nzili mu ogye, lo ti anga mu ensweghe, ku ogwene a nyuru osuo kundaa baara. ");
INSERT INTO tyx_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kunsa kyiri, ba-Dzwife bákasagha nde ya bákafwulu ti: «Bu nde kunu ali?» ");
INSERT INTO tyx_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kunsa mpwumu baara, balagha báakaŋuŋunu mu nde. Babamõ bákalyele ti: «Nde li mbwuru wu mubwe». Ba bake ti: «Pele, nde li mu okadzihibi mpwumu a baara.» ");
INSERT INTO tyx_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Lo mbwuru si mumõ ka ákabili epankala mu nkwumu a nde o, mu nkooro a nzalamweẽ a bamfumu ba ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kara-a-kara li bitsughu bi kyiri, Yiisu ákumu ku nzo a Nzaami ya ábwi oluo. ");
INSERT INTO tyx_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ba-Dzwife bu bágyughu mandagha ma ákaluo nde, bo bákiŋimi ya bákalyele ti: «Bunu-abo nde akughu osoolo Bisono bu, nde wuulu ka ágyighi o?» ");
INSERT INTO tyx_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yiisu ábvuhulu bo ti: «Maluo ma me ka mafi kundaa me o, lo mo mafi kundaa munde wu aagweghe me. ");
INSERT INTO tyx_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kala ti mbwuru dzyi ogyighili waa li Nzaami, nde sa asoolo kala ti maluo ma kundaa Nzaami mafi bwunu-we kala ti me mu nkwumu a meme ndi mu okabili. ");
INSERT INTO tyx_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Munde wu aakabili mu nkwumu a ndeme, aakasagha nsia yi a ndeme. Lo munde wu aakasagha nsia yi a wu aagweghe nde li wu a ngaŋma, ya mpya ka yili mu nde o. ");
INSERT INTO tyx_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Wu áagwi be Mukyene ka Moyidze o? Lo mbwuru si mumõ mu be ka aakasalala nde o. Mu ema be lili mu okasagha me odzwa?» ");
INSERT INTO tyx_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mpwumu a baara yíbvuhulu nde ti: «We li a mufulu wu mubi! Nande li mu okasagha odzwa we?» ");
INSERT INTO tyx_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yiisu ábvuhulu ti: «Me ndagha yini a mõ aangyighili ya be bwohono liikiŋimi. ");
INSERT INTO tyx_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moyidze ágwi be litumu lili okasohobo baana ba be ba babaghala nzo a mbaa. Litumu lilo ka lífi kundaa Moyidze o, lo kundaa bankagha-kwuru ba bihi. Ya be liikasohobo ba babaghala nzo a mbaa mu etsughu kii Sabate. ");
INSERT INTO tyx_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kala ti be liikasohobo baghala nzo a mbaa mu etsughu kii Sabate mu onyaã otsala Mukyene a Moyidze, mu emakye be liikolo me nkehe bu aandzuhu me mbwuru mu etsughu kii Sabate? ");
INSERT INTO tyx_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Linyaã okalamana baara mu yini a mi liikamono be, lo liikalamana bo mu bunsumu!» ");
INSERT INTO tyx_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ndaama a baara baba Yerusaleme bákagwa bifwulu ti: «Wu ka me mbwuru wu bali mu okasagha bo odzwa o? ");
INSERT INTO tyx_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Limono, nde li mu okabili epankala ŋa nkulu a baara bwohono, lo bo ka bali mu obvuhulu nde ndagha o! Bunu-abo, bamfumu ba bihi bamaakihi mu engaŋma ti ngu nde li Kriste? ");
INSERT INTO tyx_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bu gyughu, ŋa akala oogya Kriste, mbwuru si mumõ ka asoolo o kunu-ako nde aafa, lo wu, bihi lisoolo ku aafi nde.» ");
INSERT INTO tyx_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yiisu bu áakaluo munsa nzo a Nzaami ábili mu likyi lili mpini: «Be lisoolo me! Be lisoolo ku aamfi me! Lo me ka aangyi mu ememe o. Munde wu aagweghe me li wu a ngaŋma, munde wu ligwene osoolo be. ");
INSERT INTO tyx_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Me, me nsoolo nde mu kuulu me aamfi kundaa nde ya me nde aagweghe me.» ");
INSERT INTO tyx_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bo básagha osyimi Yiisu, lo mbwuru si mumõ ka ákwara nde o, mu kuulu matala ma nde nkini áli ka mákughu o. ");
INSERT INTO tyx_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Munsa mpwumu, baara balagha bási kana mu nde ya bákalyele ti: «Ŋa akala oogya Kriste, nde sa asa bilyimi bii okiŋimi bi biluru bi ali mu okasa nde?» ");
INSERT INTO tyx_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ba-Faridzyẽ bágyughu bu ókaŋuŋunu baara mu Yiisu. Bakwuru ba bangaa ba Nzaami ya ba-Faridzyẽ bátumu bankyele ba Nzo a nzaami mu oyisyimi nde. ");
INSERT INTO tyx_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yiisu ályele ti: «Me nkini ndi ya be mu mana matala, ya me sa ngye kundaa munde wu aagweghe me. ");
INSERT INTO tyx_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Be sa lisagha me, lo be ka limono me o, mu kuulu be ka likughu ogya ŋa ebini ekye ki akala aankala me o.» ");
INSERT INTO tyx_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Oŋo ba-Dzwife bákabili bo-a-bo ti: «Kunu-ako nde aagye kuulu bihi ka lifirimono nde o? Nde kundaa ba-Dzwife ba bátsaŋama ŋa kara li ba-Ngereke aagye? Nde ba-Ngereke aayiluo? ");
INSERT INTO tyx_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ndagha yi aalyele nde yi: “Be sa lisagha me, lo be ka limono me o”, ya “mu kuulu be ka likughu ogya ŋa ebini ekye ki akala aankala me o” mbaala a yo ma?» ");
INSERT INTO tyx_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mu etsughu kii masini kii kyiri, ki eli etsughu ki enene mu kyiri, Yiisu átemene ya áti mukwughu wu: «Kala ti mbwuru li a nyoro a madza, lo nde agya kundaa me ya nde aŋma. ");
INSERT INTO tyx_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","“Munde wu aasa kana mu me, manzala mama madza mama laama sa mapala munsa nde”, ti bwunu a bu oli Bisono». ");
INSERT INTO tyx_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yiisu ákabili mu Mufulu a Ngili wu akala oogyagha babo ba baasa kana mu nde, mu kuulu Nzaami nkini áli ka ágwi Mufulu kundaa ba baakasa kana o, ya Yiisu nkini áli ka ábagha nsia o. ");
INSERT INTO tyx_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ŋa kara li mpwumu a ba bágyughu mandagha mamo, bana bákalyele ti: «Ngaŋma, mbwuru wu me Mubighili!» ");
INSERT INTO tyx_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Babake bákalyele ti: «Me nde li Kriste!» Babamõ bákalyele ti: «Kriste kughu ofa ku Ngalile? ");
INSERT INTO tyx_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bisono ka biikalyele o ti Kriste sa akala mu dzumu li Dabvide, ya nde sa afa ku Beteleeme, bula bu busala ku ókakala Dabvide?» ");
INSERT INTO tyx_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mpwumu yíkaghaba mu nkooro a nde. ");
INSERT INTO tyx_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ŋa kara li bo, baara babake bákasagha osyimi nde, lo mbwuru si mumõ ka ákwara nde o. ");
INSERT INTO tyx_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bankyele ba nzo a Nzaami báyabvughuru kundaa bakwuru ba bangaa ba Nzaami ya ba-Faridzyẽ báfwulu bo ti: «Mu emakye be liigwene oyabiri nde?» ");
INSERT INTO tyx_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bo bábvuhulu ti: «Mbwuru si mumõ nkini ka ámaabili ti bu oli mu okabili baghala munde o.» ");
INSERT INTO tyx_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ba-Faridzyẽ bályele bo ti: «Behe si liikihi ti badzihibi be? ");
INSERT INTO tyx_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ŋa kara li bamfumu bwunu we ŋa kara li ba-Faridzyẽ, oli a si mbwuru mutsyini wu áasi kana mu nde? ");
INSERT INTO tyx_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lo mpwumu a baara yi ka yisoolo Mikyene o, baara ba bálogho!» ");
INSERT INTO tyx_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Lo Nikodeme, mumõ mu ba-Faridzyẽ, munde wu áayimono Yiisu, ályele ti: ");
INSERT INTO tyx_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Mikyene mi bihi-a-be miikagwa mbwuru ebili kala ti ka batswama ogyughu nde o ya ka basoolo mandagha ma aagyighili nde o?» ");
INSERT INTO tyx_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bo bábvuhulu nde ti: «Wehe si li mbwuru wu a Ngalile? Yighili otala mu Bisono ya we sa mono ti ku Ngalile ka ookapala mubighili o.»  ");
INSERT INTO tyx_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ŋa mbihi oŋo, mbwuru-mbwuru ágyene ku nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yiisu ágyene ku Munguo wu a mi-Olibve. ");
INSERT INTO tyx_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Etsughu ki enema mu minkya-nkya, nde áyabvughuru ku Nzo a nzaami. Buulu baara bwohono bákagya kundaa nde, nde ábwi nsini ya ábaana oluo. ");
INSERT INTO tyx_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Baluo-Mikyene ya ba-Faridzyẽ báyabiri nde mukaha wu básyimi bukala ya básuhu nde ŋa kara li baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bo bályele nde ti: «Muluo, mukaha wu baasyimi nde bukala. ");
INSERT INTO tyx_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moyidze, mu Mikyene, ágwi litumu ti bafaana odzwa bakaha baba bu mu mameẽ. Lo, we bunu lyele?» ");
INSERT INTO tyx_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bo bákabili obo mu oleghebe nde mwere mpaala babagha ndagha yi baafwunu nde. Lo Yiisu bu apfuŋumu, ábwi osono mu mulyeme ŋa nsie. ");
INSERT INTO tyx_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Buulu bo báfirikagwa nde bifwulu, Yiisu ásiili busu ya ályele bo ti: «Nyaã mbwuru wuulu ka ali a masumu o, akala wu a nsomo mu okaha nde limeẽ.» ");
INSERT INTO tyx_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nde áfiripfuŋumu ya áfiribaana osono ŋa nsie. ");
INSERT INTO tyx_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bo bu bagyughu ndagha oyo, bábaana ogye mumõ-mumõ, obaana mu ba babvulu bukwuru. Ya mukaha ásyili nde ngasighi oŋo ŋa nkulu a Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yiisu ásiili mutswi ya ályele kundaa nde ti: «Mukaha, bo kunu-ako bali? Ka oosyili a mbwuru si mumõ ŋa wu aalyele ti bafaana otsyiri we mukakana wu lipfu o?» ");
INSERT INTO tyx_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nde ábvuhulu ti: «Mbwuru we, Mfumu». Ya Yiisu ályele kundaa nde ti: «Mehe si ka ntsyiri we mukakana wu lipfu o. Gye, lo ka afirisa masumu o.» ");
INSERT INTO tyx_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yiisu áfirilyele kundaa bo ti: «Me ndi otsyeme o nsie. Munde wu aanama me ka adzyara kunsa opyini o, lo nde sa abagha otsyeme kuu laama.» ");
INSERT INTO tyx_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Oŋo ba-Faridzyẽ bályele kundaa nde ti: «We li mu osuo bumpughulu mu weme, bumpughulu bu we ka buli bubu ngaŋma o!» ");
INSERT INTO tyx_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yiisu ábvuhulu ti: «Ngu okala ti me ndi mu osuo bumpughulu mu meme, bumpughulu bu me buli bubu ngaŋma, mu kuulu me nsoolo ku aamfi me ya ku ndi mu okagye me. Lo be, be ka lisoolo ku aamfi me ya ku ndi mu okagye me o. ");
INSERT INTO tyx_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Be liikalamana mu embwuru. Me ka ndamana mbwuru o. ");
INSERT INTO tyx_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kala ti me ndamana, olamana o me sa okala kuu ngaŋma, mu kuulu me ka ndi ngasighi o, oli si ya munde wu aagweghe me. ");
INSERT INTO tyx_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Munsa Mikyene mi be básono ti bumpughulu bubu baara buolo buli bubu ngaŋma. ");
INSERT INTO tyx_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Me ndi mu osuo bumpughulu mu meme, ya Taara wu aagweghe me li mu osuo si bumpughulu mu me.» ");
INSERT INTO tyx_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ba-Faridzyẽ báfwulu nde ti: «Taara a we, kunu-ako ali?» Yiisu ábvuhulu ti: «Be ka lisoolo me o ya be ka lisoolo Taara a me o. Kala ti be áli lisoolo me, be likaasoolo si Taara a me.» ");
INSERT INTO tyx_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yiisu ályele mandagha mamo mu matala ma ákaluo nde mu Nzo a nzaami, ŋa bele a elogho ki baakagwa bikaba. Mbwuru si mumõ ka ásyimi nde o, mu kuulu matala ma nde nkini áli ka máto o. ");
INSERT INTO tyx_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yiisu áfirilyele kundaa bo ti: «Me ndi mu ogye, be sa lisagha me, lo be sa likpa mu nkooro a masumu ma be. Oko ku aangye me, be ka likughu ogye oko o.» ");
INSERT INTO tyx_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ba-Dzwife bu bagyughu ndagha oyo, bo-a-bo bákagwa bifwulu ti: «Nde nyuru aadzwa bu alyele ti: “Ku aangye me, be ka likughu ogye oko o?”» ");
INSERT INTO tyx_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yiisu ábvuhulu bo ti: «Be lili baba ku nsie, me, me ndi wu a ku yulu. Be lili baba mu nsie yi, me, me ka ndi wu a mu nsie yi o. ");
INSERT INTO tyx_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Me mu obo me áandyele be ti be sa likpa mu nkooro a masumu ma be. Kala ti be ka lisi kana o ti me “Me Ndi”, be sa likpa munsa masumu ma be.» ");
INSERT INTO tyx_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mu obo bo báfwulu nde ti: «We nande li?» Yiisu ábvuhulu kundaa bo ti: «Yi ndi mu okalyele me be obaana ku ebaana. ");
INSERT INTO tyx_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Me ndi a mandagha malagha ma aandyele me mu mi mitala be ya ma aandamana me be, lo munde wu aagweghe me li ngaŋma, ya mandagha ma aangyughu me kundaa nde, me mo me ndi mu okalyele kundaa baara ba nsie.» ");
INSERT INTO tyx_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Lo bo ka bábaghala o ti ngu mu Taara Yiisu ákabili a bo. ");
INSERT INTO tyx_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Oŋo Yiisu ályele kundaa bo ti: «Mu matala ma akala liibaŋana be Mwana a mbwuru ŋa yulu a kuruwa, be akala lisoolo ti me, “Me Ndi”, ya me ka aankansa ndagha si mõ mu ememe o: Me aankandyele mandagha ma ógyihi me Taara. ");
INSERT INTO tyx_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Munde wu aagweghe me li ya me: Nde ka aanyaã me ngasighi o, mu kuulu matala mwohono me aankansa mandagha ma maakagwa nde esee.» ");
INSERT INTO tyx_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yiisu bu abili obo, baara balagha bási kana mu nde. ");
INSERT INTO tyx_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ya Yiisu ályele kundaa ba-Dzwife ba bási kana mu nde ti: «Kala ti be linabara mu mandagha ma aandyele me be, be sa likala binduono bi me bibi ngaŋma, ");
INSERT INTO tyx_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","be sa lisoolo engaŋma, ya engaŋma sa egwa be bumpoholo.» ");
INSERT INTO tyx_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bo bábvuhulu kundaa nde ti: «Bihi lili mimburu mi mweẽ a Abarahame ya mbwuru nkini ka ámaasa bihi mu bunkana o, bunu-abo we kughu olyele ti bihi sa likala baara baba bumpoholo?» ");
INSERT INTO tyx_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yiisu ábvuhulu kundaa bo ti: «Mu ngaŋma me ndyele be ti, munde wu aasa masumu, li nkana a masumu. ");
INSERT INTO tyx_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nkana ka aakakala mankulu mu dzumu o, lo mwana wu baghala, nde li mankulu mu dzumu. ");
INSERT INTO tyx_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mu obo, kala ti Mwana wu baghala gwi be bumpoholo, be sa likala baara baba bumpoholo bubu ngaŋma. ");
INSERT INTO tyx_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Me nsoolo ti be lili mimburu mi mweẽ a Abarahame, lo be lili mu okasagha odzwa me mu kuulu be ka lili mu okakihi mandagha ma aandyele me be o. ");
INSERT INTO tyx_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Me aakandyele mandagha ma áamono me kundaa Taara a me. Lo be, be liikasa mandagha ma liikagyughu be kundaa taara a be!» ");
INSERT INTO tyx_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bo bábvuhulu kundaa nde ti: «Taara a bihi me Abarahame.» Yiisu ályele kundaa bo ti: «Kala ti be lili baana ba Abarahame, nkini be likaakasa bigyighi bi ókasa Abarahame. ");
INSERT INTO tyx_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Lo be lili mu okasagha odzwa me, me wu ndi mu okalyele be engaŋma ki aangyughu me kundaa Nzaami. Abarahame ka ási obo o. ");
INSERT INTO tyx_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Lo be, be liikasa bigyighili bi taara a be.» Bo bábvuhulu kundaa nde ti: «Bihi ka lili baana ba báburu mu enkwunu o, bihi lili a Taara yini a mumõ, Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yiisu ályele kundaa bo ti: «Kala ti Nzaami ali Taara a be, nkini be likaadzyi me, mu kuulu kundaa Nzaami me aamfi ya me aangyi. Me ka aangyi mu litumu li meme o, lo me nde aagweghe me. ");
INSERT INTO tyx_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mu emakye be lili mu ogwene okabaghala mbiili a me? Mu kuulu be ka lidzyi ogyughu ndagha a me o.» ");
INSERT INTO tyx_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","«Be lili ti anga taara a be dyabulu, ya be lidzyi okasa dzyi li taara a be. Obaana ku ebaana, nde li munde wu aakadzwa baara, ya nde ka áli munsa engaŋma o, mu kuulu mu nde ka oli a engaŋma o. Ŋa aakapfiri nde mpya, nde aakabili mu mi mili mu ndeme, mu kuulu nde li nga-a-mpya ya taara a mpya. ");
INSERT INTO tyx_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Lo me, buulu me aakandyele engaŋma, be liikakuono osa kana mu mi aakandyele me. ");
INSERT INTO tyx_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nande mu be kughu osuo ti me aansi masumu? Kala ti me ndi mu okalyele engaŋma, mu emakye be liigwene okasa kana mu mi aakandyele me? ");
INSERT INTO tyx_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Munde wu li wu a Nzaami aakagyughu mandagha ma Nzaami. Lo be, kala ti be ka lili mu okagyughu o, mu kuulu be ka lili baba Nzaami o.» ");
INSERT INTO tyx_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ba-Dzwife bábvuhulu kundaa nde ti: «Bihi ka liili a bwu o mu olyele ti we musi Samari ya we li a mufulu wu mubi?» ");
INSERT INTO tyx_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yiisu ábvuhulu bo ti: «Pele, me ka ndi a mufulu wu mubi o, lo me Taara a me ndi mu okagwa budziri. Ya be, be lili mu okagwa me bupfiri! ");
INSERT INTO tyx_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Me ka akansagha o ti baara bagwa me nsia. Lo oli a mumo wu aakasagha yo mu nkooro a me, ya wu akalamana mu bunsumu. ");
INSERT INTO tyx_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mu engaŋma me ndyele be yo, kala ti mbwuru kebe mandagha ma me, nde akala ka akpa o.» ");
INSERT INTO tyx_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ba-Dzwife bályele kundaa nde ti: «Mu bu bihi lisoolo ti we li a mufulu wu mubi! Abarahame ya mibighili bákpi, lo we, we lyele ti: “Kala mbwuru kebe mandagha ma me, nde akala ka akpa o”. ");
INSERT INTO tyx_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bunu, we bvulu taara a bihi Abarahame, wu áakpi? Ya mibighili si míkpi. Lo we bu tsimi ti we nande li?» ");
INSERT INTO tyx_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yiisu ábvuhulu bo ti: «Kala ti me ngwi nyuru a meme nsia, nsia a me yili yi a bwunu. Me Taara a me li mu okagwa me nsia, munde, wu liikalyele be ti, nde li Nzaami a be. ");
INSERT INTO tyx_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ya be ka lisoolo nde o, lo me, me nsoolo nde. Kala me ndyele be ti me ka nsoolo nde o, me sa nkala mbwuru nga-a-mpya ti anga be. Lo me nsoolo nde ya me aakankebe mandagha ma nde. ");
INSERT INTO tyx_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Taara a be Abarahame álwulu mu esee mu etsimi kii omono etsughu kii ogya o me. Nde ámono kye ya álwulu mu esee.» ");
INSERT INTO tyx_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ba-Dzwife bályele nde ti: «We nkini aakuhu bamvulu makwumu-mataana (50) o, lo we lyele ti we áamono Abarahame!» ");
INSERT INTO tyx_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yiisu ábvuhulu bo ti: «Mu engaŋma me ndyele be, nsomo-a-nsomo báburu Abarahame, “me ndi”.» ");
INSERT INTO tyx_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Oŋo ba-Dzwife bátolo mameẽ mu okaha nde mo, lo Yiisu ásweme ya ápala mu Nzo a nzaami. ");
INSERT INTO tyx_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yiisu bu akaluru mu nzili, ámono mbwuru wu áali enkpa-mihi kii emburu-ngughu. ");
INSERT INTO tyx_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Binduono bi nde bífwulu nde ndiri: «Muluo, nande áasi masumu mpaala baburu nde enkpa-mihi, ndeme, bwunu we biburu bi nde?» ");
INSERT INTO tyx_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yiisu ábvuhulu bo ti: «Ka oli mu nkooro a masumu ma nde bwunu we mama biburu bi nde o? Lo mu kuulu bigyighili bi Nzaami bimoŋono mu nde! ");
INSERT INTO tyx_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ŋaala bwihi nkini buki, bihi lifaana osala esala ki munde wu aagweghe me. Mpyibi yili mu ogya yiili mbwuru si mumõ ka kughu osala esala o. ");
INSERT INTO tyx_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ŋaala me nkini ndi ŋa nsie, me ndi otsyeme o nsie.» ");
INSERT INTO tyx_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yiisu ámana obili obo, átswulu manteẽ ŋa nsie, ápworo toro mu mõ ya ákili lo mu mihi mi enkpa-mihi. ");
INSERT INTO tyx_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ya Yiisu ályele kundaa nde ti: «Gye yiswagha busu mu edzyi kii Silowe», mbaala ti, «wu bágweghe». Enkpa-mihi égyene, éswagha busu, ya ékayamono ŋa ékayabvughuru kye. ");
INSERT INTO tyx_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Baara ba bákakala ya nde kara lilo, ya babo ba bátswama okamono wu aakaluomo nzi, bályele ti: «Wu ka li mbwuru wu aakabwa nsini mu okaluomo nzi o?» ");
INSERT INTO tyx_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Baara babamõ bákalyele ti: «Me nde!» Babake ti: «Pele, mbwuru wu bali efa emõ ya nde.» Lo ndeme ákalyele ti: «Ngu me.» ");
INSERT INTO tyx_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mu obo bo báfwulu nde ti: «Bunu-abo mihi mi we miisi mu odzughu?» ");
INSERT INTO tyx_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nde ábvuhulu ti: «Mbwuru wu a nkwumu a Yiisu aapworo toro, aakili me lo mu mihi ya aalyele me ti: “Gye yiswagha busu mu edzyi kii Silowe”. Me obo me aangyene, me aanswagha busu ya me aambwi omono.» ");
INSERT INTO tyx_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bo báfwulu nde ti: «Nde kunu-ako ali?» Nde ábvuhulu ti: «Me ka nsoolo o.» ");
INSERT INTO tyx_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Baara bábiri mbwuru wu áali enkpa-mihi kundaa ba-Faridzyẽ. ");
INSERT INTO tyx_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ankoho ekye eli etsughu kii sabate ki ópworo Yiisu toro ya ádzuhu mihi mi mbwuru munde. ");
INSERT INTO tyx_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ba-Faridzyẽ si báfwulu nde bunu-abo nde aabaana omono. Nde ábvuhulu bo ti: «Nde aakili me toro mu mihi, me aanswagha busu, ya me aambwi omono.» ");
INSERT INTO tyx_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ŋa kara li ba-Faridzyẽ, babamõ bákalyele ti: «Mbwuru wu ka aafi kundaa Nzaami o, mu kuulu nde ka li mu ogwa etsughu kii sabate budziri o.» Lo babake bákalyele ti: «Bunu-abo mbwuru nga-a-masumu akughu ogyighili bilyimi bii okiŋimi bibi bu?» Ya ba-Faridzyẽ bákaghaba. ");
INSERT INTO tyx_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bo báfirifwulu mbwuru wu áli enkpa-mihi ti: «Ya we, we bunu lyele mu mbwuru munde wu aadzuhu we mihi?» Nde ábvuhulu kundaa bo ti: «Nde li mubighili.» ");
INSERT INTO tyx_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Lo bamfumu ba-Dzwife bábihi osa kana ti, mbwuru wu li mu okamono wu áli enkpa-mihi aakakala. Mu obo, bo báti ba báburu nde mbili, ");
INSERT INTO tyx_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ya báfwulu bo ti: «Baghala wu li mwana a be? Ngaŋma nde áli enkpa-mihi ŋa líburu be nde? Ya mu bu, bunu-abo nde aasi mu omono?» ");
INSERT INTO tyx_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ba báburu nde bábvuhulu ti: «Bihi lisoolo ti wu mwana a bihi ya nde áli enkpa-mihi ŋa líburu bihi nde, ");
INSERT INTO tyx_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","lo bihi ka lisoolo o bunu-abo nde aasi mu omono ya nande aadzuhu nde mihi. Be lifwulu ndeme, buta nde li mbwuru wu akulu, nde ndeme kughu ogwa mvuru mu mi mitala nde!» ");
INSERT INTO tyx_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ba báburu nde bábili obo mu nkooro a nzalamweẽ a bamfumu ba-Dzwife ba áli bagwolo mukakana wu opaha mu nzo a lisamana a ba-Dzwife, nswe munde wu aalyele ti Yiisu me Kriste. ");
INSERT INTO tyx_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Me mu obo ba báburu nde bályele ti: «Nde li mbwuru wu akulu, lifwulu ndeme.» ");
INSERT INTO tyx_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ba-Faridzyẽ báfirita mbwuru munde wu áli enkpa-mihi mbili, ya bo bályele kundaa nde ti: «Gwa nsia kundaa Nzaami! Bihi lisoolo ti mbwuru munde li nga-a-masumu.» ");
INSERT INTO tyx_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nde ábvuhulu kundaa bo ti: «Me ka nsoolo o kala ti nde nga-a-masumu ali. Lo me yi nsoolo me ndagha yini a mõ: Me áandi enkpa-mihi, mu bu me ndi mu okamono!» ");
INSERT INTO tyx_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bo báfwulu nde ti: «Nde emakye aasi we? Bunu-abo nde aadzubulu we mihi?» ");
INSERT INTO tyx_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nde ábvuhulu ti: «Me maandyele be yo, lo be ka liigyughu me o! Mu emakye be lidzyi yo ofirigyughu mu sa likimi? Behe si nzala a kuulu ti likala binduono bi nde?» ");
INSERT INTO tyx_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ba-Faridzyẽ bábwi otughu nde ya bályele kundaa nde ti: «Me we li enduono e nde! Bihi, bihi lili binduono bi Moyidze. ");
INSERT INTO tyx_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Bihi lisoolo ti Nzaami ábili kundaa Moyidze. Lo mbwuru wu, bihi ka lisoolo ku aafi nde o!» ");
INSERT INTO tyx_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Baghala ábvuhulu bo ti: «Yi ndagha yi okiŋimi: Nde aadzubulu me mihi, lo be ka lisoolo ku aafi nde o! ");
INSERT INTO tyx_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Baara bwohono basoolo ti Nzaami ka aakagyughu banga-a-masumu o, lo nde aakagyughu mbwuru wu aakagwa nde budziri ya aakasa waa li nde. ");
INSERT INTO tyx_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kaala bihi nkini límaagyughu ti mbwuru ámaadzubulu mihi mi munde wu báburu enkpa-mihi o. ");
INSERT INTO tyx_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kala mbwuru wu ka áfi kundaa Nzaami o, nde ka aakaagyighili ndagha si mõ o.» ");
INSERT INTO tyx_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ba-Faridzyẽ bábvuhulu nde ti: «We wu li kunsa masumu obaana bu báburu we, me we kughu oluo bihi!» Ya bo bábyi nde ágye ku mbala. ");
INSERT INTO tyx_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yiisu agyughu ti bo baabyi mbwuru munde. Nde áyimono nde ya áfwulu nde ti: «We aasi kana mu Mwana a mbwuru?» ");
INSERT INTO tyx_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nde ábvuhulu ti: «Mfumu, nde nande ali mpaala me nsa kana mu nde?» ");
INSERT INTO tyx_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yiisu ábvuhulu nde ti: «We aamono nde! Me munde wu li mu okabili ya we.» ");
INSERT INTO tyx_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mbwuru munde ábvuhulu nde ti: «Mfumu, me nsi kana!» Ya nde ákunu mabuo mu nsie ŋa nkulu a nde. ");
INSERT INTO tyx_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yiisu áfirilyele ti: «Me aangyi mu nsie mu oyasa muyala, mpaala ba baagwene okamono bamono, ya ba baakamono bakala binkpa-mihi.» ");
INSERT INTO tyx_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ndaama a ba-Faridzyẽ ba báli oŋo bágyughu mandagha mamo ya báfwulu nde ti: «Bihi si lili binkpa-mihi?» ");
INSERT INTO tyx_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yiisu ábvuhulu bo ti: «Kala ti be áli binkpa-mihi, be ka likaakala a masumu o. Lo mu matala ma lili mu okalyele be ti: “Bihi lili mu omono”, masumu ma be mali nkini ya be». ");
INSERT INTO tyx_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yiisu áfirilyele kundaa ba-Faridzyẽ ti: «Mu engaŋma me ndyele be ti, mbwuru wuulu ka somo mu etyi ki bindoomo ŋa mu muŋma o, lo nde kumu kye ŋa ebini ekimi mu osomo, munde li muturu ya ntwumu. ");
INSERT INTO tyx_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Lo munde wu aasomo ŋa muŋma a etyi li munkaala-bibuolo. ");
INSERT INTO tyx_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nkyele a etyi aakadzubulu nde kye, ya bindoomo biikagyughu likyi li munkaala-bibuolo. Nde aakata bindoomo bi nde mbili, nswe endoomo mu nkwumu a kye, ya aakapaha bye ku mbala. ");
INSERT INTO tyx_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mu matala ma aakamana nde opaha bindoomo byehene, nde aakagye ŋa nkulu, ya bye biikanama nde ŋa mbihi, mu kuulu bye bisoolo likyi li nde. ");
INSERT INTO tyx_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Si okala ka bunu, bye ka biikanama mbwuru wu bagwene osoolo o, lo bye sa bibara nde mu kuulu bye ka bisoolo likyi li baara ba bagwene osoolo o.» ");
INSERT INTO tyx_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yiisu áti bo nkumu oyo, lo bo bákwono obaghala yo. ");
INSERT INTO tyx_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yiisu áfirilyele ti: «Mu engaŋma, me ndyele be, me ndi muŋma a etyi ki bindoomo. ");
INSERT INTO tyx_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bo bwohono ba bátswama nsomo me ngya bali banga-a-pfyibi ya bantwumu, lo bindoomo ka bígyughu bo o. ");
INSERT INTO tyx_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Me ndi muŋma a etyi, kala mbwuru somo mu me, nde sa abvwughu, nde sa asomo ya ayapala, ya sa abagha bi-odza. ");
INSERT INTO tyx_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nga-a-pfyibi aakagya yini a mu oyaturu, mu oyadzwa ya mu oyapfihili. Lo me, me aangyi mpaala baara babagha laama ya babagha lo lili bufulu.» ");
INSERT INTO tyx_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Me ndi munkaala-bibuolo wu mubwe. Munkaala-bibuolo wu mubwe aakagwa laama li nde mu bindoomo bi nde. ");
INSERT INTO tyx_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Lo mbwuru wu baakafiri nzi mu okakebe bibuolo, wuulu ka li munkaala-bibuolo o, ya bindoomo ka bili bibi ndaa nde o, mu matala ma aakamono nde ngo, nde aakabara ya aakasihi bindoomo. Ngo aakabwirili bindoomo ya aakatsala bye. ");
INSERT INTO tyx_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mu kuulu baghala munde yini a mu nkooro a nzi aakasala, nde ka li a nyiĩ mu bindoomo o.» ");
INSERT INTO tyx_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","«Me ndi munkaala-bibuolo wu mubwe, me nsoolo bindoomo bi me, ya bye bisoolo me, ");
INSERT INTO tyx_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ti bwunu a bu osoolo me Taara ya ti bu nsoolo me Taara. Me sa ngwa laama li me mu bindoomo bi me. ");
INSERT INTO tyx_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Me ndi a bindoomo bikimi biili ka bili bibi etyi ki o. Bibye, me mfaana obiri bye si, bye sa bigyughu likyi li me ya sa bikala mukaã a bibuolo mumõ ya sa bikala a munkaala-bibuolo mumõ. ");
INSERT INTO tyx_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Taara aakadzyi me mu kuulu me ndi mu ogwa laama li me ya me sa firimbagha lo. ");
INSERT INTO tyx_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mbwuru ka amaha me lo o, lo meme ngwi lo mu waa li me. Me ndi a lileene lili ogwa lo ya lili ofirigwolo lo. Lilo me litumu li ógwi me Taara a me.» ");
INSERT INTO tyx_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mu nkooro a mandagha mamo, ba-Dzwife báfirikaghaba. ");
INSERT INTO tyx_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Balagha ŋa kara li bo báakalyele ndiri: «Nde li a mufulu wu mubi, nde li nga-a-lala. Mu emakye be lili mu okagyughu nde?» ");
INSERT INTO tyx_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Lo babake bákalyele bu: «Mbwuru nga-a-mufulu wu mubi ka kughu obili bu o. Mufulu wu mubi kughu odzubulu mihi mi enkpa-mihi?» ");
INSERT INTO tyx_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ku Yerusaleme óli a kyiri kii ndibili a mweẽ a etsughu ki báseme nzo a Nzaami. Áli oli mu ndo yi a mpie yi a alagha. ");
INSERT INTO tyx_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mu mbala a nzo a Nzaami, Yiisu ákabulugye, ku nsie a eluru kii Solomõ. ");
INSERT INTO tyx_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ba-Dzwife bádzyi nde ya báfwulu nde ti: «Tee nki matala we aasa ti bihi likala kunsa bitsimi ogwimi? Kala ti we li Kriste, saalyele epankala!» ");
INSERT INTO tyx_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yiisu ábvuhulu bo ti: «Me aandyele be yo lo be ka lili mu osa kana o. Bigyighili bi ndi mu okasa me mu nkwumu a Taara me, bili mu osuo bumpughulu mu me. ");
INSERT INTO tyx_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lo be liibihi osa kana mu me, mu kuulu be ka lili bindoomo bi me o. ");
INSERT INTO tyx_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Bindoomo bi me biikagyughu likyi li me, me nsoolo bye ya bye biikanama me. ");
INSERT INTO tyx_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ya me aakangwa laama lili mibvu ya mibvu kundaa bindoomo bi me. Bye ka bikughu opfighili o ya mbwuru si mumõ ka kughu ogwohono me bye ŋa ekee o. ");
INSERT INTO tyx_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taara a me wu aagwi me bye, bvulu byehene mu bunene ya mbwuru si mumõ ka kughu ogwohono elogho ŋa ekee e Taara o. ");
INSERT INTO tyx_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Me ya Taara lili mbwuru mumõ.» ");
INSERT INTO tyx_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ba-Dzwife báfiritolo mameẽ mu odzwa nde mu mõ. ");
INSERT INTO tyx_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Lo Yiisu áfirilyele ti: «Me aansuo be bigyighili bi bibwe bi bifi kundaa Taara. Mu nki egyighili be lidzyi odzwa me mu mameẽ?» ");
INSERT INTO tyx_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ba-Dzwife bábvuhulu nde ti: «Bihi ka lidzyi odzwa we mu mameẽ mu nkooro a egyighili ki ebwe ki aasi we o, lo mu nkooro a ku aatsaala we Nzaami, mu kuulu we wu li mbwuru, we li mu olyele ti we li Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yiisu ábvuhulu bo ti: «Mu Mikyene mi be básono bu: “Me aandyele, be lili banzaami!” ");
INSERT INTO tyx_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ankoho mbwuru ka kughu osobo mibasono mu Bisono bibi Ngili o. Mu kuulu mu Mikyene agwolo baakata baara babo, ba bágyughu ndagha a Nzaami, banzaami. ");
INSERT INTO tyx_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Lo be lili mu okalyele, kundaa munde wu ótwulu Nzaami mu libee mu osalala nde ya wu ágweghe nde mu nsie ti: “We li mu okatsaala Nzaami”, mu kuulu me aandyele ti me ndi Mwana a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kala ti me ka ndi mu okasa bigyighili bi Taara a me o, ka lisa kana mu me o! ");
INSERT INTO tyx_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Lo kala ti me ndi mu okasa bye, ngu okala ti be libihi osa kana mu me, be lifaana osa kana mu bigyighili bibye, mpaala be lisoolo ya libaghala ti Taara li mu me ti anga bu ndi me mu Taara.» ");
INSERT INTO tyx_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Oŋo bo báfirisagha osyimi nde, lo nde ábulumara ŋa kara li bo. ");
INSERT INTO tyx_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yiisu ábvughuru ku ngulu a mwele wu a Dzurudẽ, ŋa ebini ki áli obaana Dzã baara oboghoro ya nde ákala oko. ");
INSERT INTO tyx_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Baara balagha bákagya kundaa nde ya bákalyele ti: «Dzã ka aasi elyimi kii okiŋimi si emõ o, lo mandagha mwohono ma áalyele nde mu mbwuru wu máli mama ngaŋma.» ");
INSERT INTO tyx_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ya ŋa ebini ekye, baara balagha bási kana mu Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mbwuru mumo wu a nkwumu Ladzare áli mubyele. Nde áli musi Betani, bula bu ókakala Mari ya naana a nde Marete. ");
INSERT INTO tyx_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari me mukaha munde wu áli aagyiri Yiisu maala mama mpihi yi mbwe ya wu áagyala myili mi Mfumu mu mfu a nde. Me nkele a nde Ladzare áali mubyele. ");
INSERT INTO tyx_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bankele bansa buolo bágweghe mukyene kundaa Yiisu ti: «Mfumu, ndughu a we wu mukolo li mubyele.» ");
INSERT INTO tyx_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mu matala ma ógyughu Yiisu nsia oyo nde ályele ti: «Bubyele ba ka bubiri ku lipfu o, lo bo buli mu ogwa nsia kundaa Nzaami. Mu nkooro a bubyele bubo, sa basyighi Mwana a Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ankoho, Yiisu ákadzyi Marete, mbwee a nde ya Ladzare. ");
INSERT INTO tyx_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mu matala ma ágyughu nde nsia ti Ladzare áli mu okabyele, nde áfiriluhu bitsughu byele ŋa ebini ekye ki áli nde. ");
INSERT INTO tyx_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ya ŋa mbihi oŋo nde áyalyele kundaa binduono bi nde ti: «Litswe libvughuru ku etsulu e nsie kii Yude.» ");
INSERT INTO tyx_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Binduono bi nde bílyele nde ti: «Muluo, ka oli edzighi o, ba-Dzwife baakasagha odzwa we mu mameẽ, ya we dzyi ofiribvughuru oko?» ");
INSERT INTO tyx_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yiisu ábvuhulu ti: «Ka oli a matala kwumu ya mwolo (12) mama otsyeme mu etsughu o? Kala ti mbwuru li mu okadzyara mu mwiĩ, nde ka kughu okubu kya o mu kuulu nde li mu okamono otsyeme ku nsie yi. ");
INSERT INTO tyx_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Lo kala ti mbwuru li mu okadzyara mu mpyibi, nde sa akubu kya mu kuulu otsyeme ka oli mu nde o.» ");
INSERT INTO tyx_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bu amana olyele mandagha mamo, nde ábwehe ti: «Ndughu a bihi-a-be Ladzare aagyoŋomo, lo me nde àayinsiili.» ");
INSERT INTO tyx_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Binduono bílyele ndiri: «Kala ti nde yini a ogyoŋomo aagyoŋomo, nde sa adzughu.» ");
INSERT INTO tyx_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ankoho, Yiisu mu lipfu li Ladzare ákadzyi obili, lo bo bákatsimi ti nde mu ensama kii tolo ákabili. ");
INSERT INTO tyx_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mu obo Yiisu ásaalyele bo epankala ti: «Ladzare aakpi. ");
INSERT INTO tyx_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ya me ndi a esee elagha mu be, buulu me ka aakankala oko o, mu kuulu be lisa kana mu me. Lo litswe ligye ku ali nde!» ");
INSERT INTO tyx_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mu obo Toma, munde wu baakata ti Mbu, ályele kundaa binduono bibike ti: «Litswe, mpaala bihi-a-be si, likpa emõ ya nde.» ");
INSERT INTO tyx_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mu matala ma óyito Yiisu oko, bályele nde ti Ladzare maasa bitsughu bina munsa mpyeme. ");
INSERT INTO tyx_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bula bubu Betani búli be-bele ya Yerusaleme mu etiiri kii bakilometere batere. ");
INSERT INTO tyx_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mu obo ba-Dzwife balagha bágyi kundaa Marete ya Mari mu ogwa bo bukyini mu nkooro a lipfu li nkele a bo Ladzare. ");
INSERT INTO tyx_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marete bu ágyughu ti Yiisu aayabehene ya bula, nde áyibwana nde. Lo Mari ásyili ku nzo. ");
INSERT INTO tyx_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marete ályele kundaa Yiisu ti: «Mfumu, kala ti we ali ŋa aakakala, nkini li nkele a me ka aakpi o. ");
INSERT INTO tyx_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Lo me nsoolo ti, ngu okala mu bu, nswe ndagha yi aaluomo we kundaa Nzaami, Nzaami sa agyighili we yo.» ");
INSERT INTO tyx_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yiisu ályele kundaa nde ti: «Nkele a we sa asighili mu lipfu.» ");
INSERT INTO tyx_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marete ábvuhulu nde ti: «Me nsoolo ti nde sa asighili mu lipfu mu etsughu kii masini, etsughu kii osighili mu lipfu.» ");
INSERT INTO tyx_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yiisu ályele kundaa nde ti: «Me ndi osighili mu lipfu ya laama. Munde wu aasa kana mu me, ngu okala ti nde kpi, sa akala mweẽ. ");
INSERT INTO tyx_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ya nswe munde wu li mweẽ ya si kana mu me, nde akala ka akpa o. We si kana mu ndagha oyo?» ");
INSERT INTO tyx_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marete ábvuhulu ti: «Eẽ! Mfumu, me nsi kana ti we li Kriste, Mwana a Nzaami wu básuolo mu ogya mu nsie.» ");
INSERT INTO tyx_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bu amana obili obo, Marete áyita mbwee a nde Mari mbili ya ályele nde mu mamfwunu ti: «Muluo li ŋa, ya nde we aakata mbili.» ");
INSERT INTO tyx_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mari bu agyughu obo, átemene mu maswa ya ágyene kundaa Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yiisu áli nkini ka ásomo munsa bula o. Nde áli nkini ŋa ebini ekye ki óbwana a nde Marete. ");
INSERT INTO tyx_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ba-Dzwife ba báli munsa nzo ya Mari mu okagwa nde bukyini, bu bamono nde apala munsa nzo mu maswa, bo bánama nde. Mu kuulu bo bákatsimi ti nde ku mpyeme ákagye mu oyilili. ");
INSERT INTO tyx_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mari bu ayato ŋa ebini ki óli Yiisu ya bu amono nde, nde ábwi ŋa myili mi nde ya ályele kundaa nde ti: «Mfumu, kala ti we ali ŋa aakakala, nkini li nkele a me ka aakpi o.» ");
INSERT INTO tyx_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yiisu bu amono Mari mu okalili, ya ba-Dzwife ba bákanama nde si mu okalili, nde ányoõ ku olagha mu mukolo ya endwu e nyuru épala nde. ");
INSERT INTO tyx_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nde áfwulu bo ti: «Kunu-ako be liisuhu nde?» Bo bábvuhulu nde ti: «Mfumu, gya yamono.» ");
INSERT INTO tyx_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yiisu álili. ");
INSERT INTO tyx_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ya ba-Dzwife bábwi olyele ti: «Limono, nde áakadzyi nde ku olagha!» ");
INSERT INTO tyx_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lo babake ŋa kara li bo bákalyele ti: «Nde wu aadzuhu mihi mi enkpa-mihi, mu emakye nde aakwono okahaba lipfu li Ladzare?» ");
INSERT INTO tyx_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yiisu áfirinyoõ ku olagha ya ágyene ku mpyeme. Mpyeme oyo áli ngala yi bákyi mu limeẽ li linene. ");
INSERT INTO tyx_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yiisu ályele ti: «Limaha limeẽ li.» Marete, nkele a wu ákpi ályele kundaa nde ti: «Mfumu, nde aabaana otsuru mpihi, mu kuulu lolo ayii kii etsughu kii bina obaana bu baadzyighi nde.» ");
INSERT INTO tyx_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Lo Yiisu ályele ndiri: «Me ka aandyele we o ti, kala we si kana, we sa mono nsia a Nzaami?» ");
INSERT INTO tyx_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bu bamaha limeẽ, Yiisu átala ku yulu ya ályele ti: «Taara, me mvurulu we matuono mu kuulu we aagyughu me. ");
INSERT INTO tyx_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Me nsoolo ti we aakagyughu me mu matala mwohono, lo me bu mbili obo mu nkooro a mpwumu a baara yi aadzyi me yi, mpaala bo basa kana ti we aagweghe me.» ");
INSERT INTO tyx_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bu amana obili obo, nde ábili mu likyi lili mpini ndiri: «Ladzare, pala!» ");
INSERT INTO tyx_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ladzare wu áapki, ápala, myili ya myaã bádzyi bisili, edzili báfughu mu mupa a eko. Yiisu ályele kundaa baara ti: «Linyana nde bisili ya linyaã nde agye!» ");
INSERT INTO tyx_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ba-Dzwife balagha ba bágyi kundaa Mari ya bámono mi ogyighili Yiisu, bási kana mu nde. ");
INSERT INTO tyx_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Lo babake ŋa kara li bo bágyene kundaa ba-Faridzyẽ ya bályele bo mi ógyighili Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mu obo, bakwuru ba bangaa ba Nzaami ya ba-Faridzyẽ bábvuŋunu mu mfwunu a ekwuru ki ba-Dzwife ya bályele ndiri: «Emakye bihi-a-be liisa? Mbwuru wu li mu okasa bilyimi bilagha bi okiŋimi. ");
INSERT INTO tyx_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kala ti bihi-a-be linyaã nde akasa bilyimi bi okiŋimi bu, baara bwohono sa basa kana mu nde, ya ba-Romẽ sa bayatsala ebini e bihi kii Ngili ya nsie a bihi yohono.» ");
INSERT INTO tyx_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mumõ ŋa kara li bo, wu a nkwumu a Kayife, wu áali mukwuru a bangaa ba Nzaami mu mubvu munde ályele ti: «Be ka lili mu obaghala o! ");
INSERT INTO tyx_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Be ka lili mu obaghala o ti bubwe kundaa be mbwuru mutsyini akpa mu nkooro a baara bwohono, ya nsie a bihi yi nyaã opfighili?» ");
INSERT INTO tyx_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nde ka ályele mandagha mamo mu endeme o, lo mu kuulu nde áli mukwuru a bangaa ba Nzaami mu mubvu munde. Me mu obo, nde ábighili ti áli bubwe Yiisu akpa mu nkooro a nsie a ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ya ka oli yini a mu obo o, lo mu obvughu si emõ baana ba Nzaami bwohono ba bátsaŋama mu nsie nsyini. ");
INSERT INTO tyx_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Me mu etsughu ekye bamfumu ba-Dzwife bágwolo munkaana wu odzwa Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mu obo, mu midzye mi nde, nde ka áfirikamoŋono kundaa ba-Dzwife o. Nde ágyene ku etsulu e nsie ki éli bele ya syehe, mu bvulu lili Efarayime. Nde ákala oko ya binduono bi nde. ");
INSERT INTO tyx_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kyiri kii Paake ki ba-Dzwife ébehene. Mu obo baara balagha bákamara mu mala ya bákagye ku bvulu lili Yerusaleme mu oyitsehebe manyuru ma bo nsomo basomo kyiri. ");
INSERT INTO tyx_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bo bákasagha Yiisu, ya munsa nzo a Nzaami mu báli bo, bo bákalyele bo-a-bo ti: «Be bunu litsimi? Nde ka agya ku kyiri o?» ");
INSERT INTO tyx_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bakwuru ba bangaa ba Nzaami ya ba-Faridzyẽ bátswi baara mukele ti nswe mbwuru wu aasoolo ku oli Yiisu, faana olyele mpaala basyimi nde. ");
INSERT INTO tyx_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bitsughu bisemene áli biisyili nsomo kyiri kii Paake eto. Yiisu ágyene ku Betani, bula bu Ladzare, wu ásiili nde mu lipfu. ");
INSERT INTO tyx_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Oko áli banaŋa Yiisu bi-odza. Marete ákakaba bo bi-odza, ya Ladzare áli emõ ya ba bákadza ŋa tabele. ");
INSERT INTO tyx_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari ágwolo etsulu e litere ki mananaase mama nare mama ntala yi alagha, ágyiri mo mu myili mi Yiisu ya ábwi ogyala mo mu mfu a nde ya nzo yohono yílwulu mu mpihi a mananaase. ");
INSERT INTO tyx_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mu obo Yuda Isikaryote, mumõ mu binduono bi nde, wu akala aatyeghe nde, ályele ndiri: ");
INSERT INTO tyx_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Mu emakye liigwene otyeghe mananaase ma mu nkama-tere (300) yi a denali mpaala ligwa nzi oyo kundaa bawele?» ");
INSERT INTO tyx_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yuda ka ályele obo mu nkooro a nyiĩ a bawele o, lo mu kuulu nde áli nga-a-pfyibi. Me nde áakakebe empogholo e nzi ya nde ákaturu nzi yi bákalo mu kye. ");
INSERT INTO tyx_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Lo Yiisu ályele kundaa nde ti: «Nyaã nde! Nde aasi obo mu nkooro a etsughu ki akala baadzyighi me. ");
INSERT INTO tyx_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bawele, be sa likala ya bo mu matala mwohono. Lo me ka ankala ya be mu matala mwohono o.» ");
INSERT INTO tyx_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mpwumu a ba-Dzwife yi nene yígyughu ti Yiisu áli mu Betani. Mu obo, bo ka bágyi yini a mu nkooro a Yiisu ndeme o, lo mu omono si Ladzare wu ásiili nde ŋa kara li ba bákpi. ");
INSERT INTO tyx_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Bakwuru ba bangaa ba Nzaami bágwolo si munkaana wu odzwa Ladzare, ");
INSERT INTO tyx_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mu kuulu me mu nkooro a nde mutala a ba-Dzwife wu alagha ákapala mu emvuŋunu e bo ya abwi okasa kana mu Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ŋa mbihi a etsughu ekye, mpwumu a baara yi nene yi áagyi ku kyiri, yígyughu ti Yiisu aakayabehene ya Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bo bágwolo matswene ma maba ya bápala mu oyibwana a nde. Bo bákakehe bingubu ti: «Odzaana! Liseme kundaa munde wu li mu ogya mu nkwumu a Mfumu, mukogho a Isarayele.» ");
INSERT INTO tyx_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yiisu ágwolo mwana nyama wu a nkwumu aane ya nde ábwi nsini ŋa yulu a nde, bwunu a bu básono ti: ");
INSERT INTO tyx_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Mutughu wu a Siyoni, akala a nzalamweẽ o! Mukogho a we li mu ogya, ya nde aakumu ŋa yulu a mwana a aane.» ");
INSERT INTO tyx_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ku ebaana, binduono bi nde ka bíkabaghala mandagha ma mákaluru o. Lo ŋa óbagha Yiisu nsia, bo bálibili mweẽ ti mandagha mamo mu nkooro a Yiisu áli básono mo, ya me bwunu obo si bási mu nde. ");
INSERT INTO tyx_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mpwumu a baara ba báli ya Yiisu ŋa ápaha nde Ladzare mu mpyeme ya ŋa ásiili nde nde ŋa kara li ba bákpi, yísuo bumpughulu mu nde. ");
INSERT INTO tyx_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mpwumu a baara yíyabwana nde mu nkooro a bu bágyughu bo ti me nde ási elyimi ekye. ");
INSERT INTO tyx_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ba-Faridzyẽ bákabili bo-a-bo ndiri: «Limono, be ka liileene ndagha si mõ o. Baara bwohono bali mu okanama nde!» ");
INSERT INTO tyx_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ŋa kara li baara ba bákumu ku Yerusaleme ku oyisamana Nzaami ku kyiri, óli a ndaama ba-Ngereke. ");
INSERT INTO tyx_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bo báyabehene kundaa Filipe, musi Betesayida, mu etsulu e nsie kii Ngalile, ya báluomo nde ti: «Mfumu, bihi lidzyi omono Yiisu.» ");
INSERT INTO tyx_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipe áyilyele kundaa Andere, ya bo bansa buolo báyilyele kundaa Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yiisu ábvuhulu kundaa bo ti: «Matala maato ma bafaana osa Mwana a mbwuru nsia. ");
INSERT INTO tyx_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mu engaŋma me ndyele be ti, kala ti liburu li bele li liibwi ŋa nsie ka likpi o, lo sa likala ngasighi. Lo kala ti lo likpi, lo sa likala ya bimburu bilagha. ");
INSERT INTO tyx_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Munde wu dzyi laama li nde, nde sa apfihili lo, ya munde wu àabele laama li nde mu nsie yi, nde sa akebe lo mu mibvu ya mibvu. ");
INSERT INTO tyx_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kala ti mbwuru dzyi osalala me, nyaã nde anama me, ya oŋo ŋa ndi me, oŋo si musala a me akala aakala. Kala ti mbwuru salala me, Taara sa asa kuulu bagwa nde budziri.» ");
INSERT INTO tyx_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Mu matala ma, muwumunu a me li maã-maã. Ya mayo me aandyele? Taara, bvwuhu me mu tala lili mpara li? Lo, me mu nkooro a tala lili mpara li me aangyi. ");
INSERT INTO tyx_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taara, sa kuulu ti nkwumu a we yikala a nsia!» Mu obo, likyi líbili ku yulu ya lílyele ndiri: «Me aansi yo nsia, ya me sa firinsa yo nsia.» ");
INSERT INTO tyx_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mpwumu a baara yi áli oŋo yígyughu ya yílyele ti: «Ekye edzumu e mvulu!» Ba bake ti: «Munde ngye-yulu bili kundaa nde!» ");
INSERT INTO tyx_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ya Yiisu ályele kundaa bo ti: «Likyi lilo ka mu nkooro a me libili o, lo mu nkooro a be. ");
INSERT INTO tyx_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ma me matala ma mumfwunu a nsie. Me mu matala ma bali mu obyi mfumu a nsie yi ku mbala. ");
INSERT INTO tyx_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Lo, ŋa akala báseene me ŋa yulu nsie, me sa nsa kuulu ti baara bwohono bagya kundaa me.» ");
INSERT INTO tyx_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mu mbiili oyo, nde ásuo mu nki lipfu nde akala aakpa. ");
INSERT INTO tyx_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mpwumu a baara yíbvuhulu kundaa nde ti: «Bihi líimono básono mu Mikyene ti Kriste faana okala mu mibvu ya mibvu. Lo bunu-abo we li mu okalyele ti bafaana oseene Mwana a mbwuru? Mwana a mbwuru munde nande?» ");
INSERT INTO tyx_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yiisu ábvuhulu bo ti: «Otsyeme oli nkini ŋa kara li be mu mana a matala. Lidzyara mu matala ma lili be kunsa otsyeme, mpaala mpyibi yinyaã obwa ŋa kara li be ensihibi. Mu kuulu mbwuru wu aakadzyara kunsa mpyibi ka akasoolo ku ali mu okagye o. ");
INSERT INTO tyx_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mu matala ma lili be kunsa otsyeme, lisa kana mu munde wu aakagwa otsyeme, obo be sa likala baana ba otsyeme.» Bu amana obili obo, Yiisu ámara ŋa kara li bo ya ágyene kuulu bo ka bákughu nde omono o. ");
INSERT INTO tyx_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Si buulu ti Yiisu ási bilyimi bilagha ŋa mihi mi bo, bo ka bási kana mu nde o, ");
INSERT INTO tyx_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","mpaala ndagha yi ólyele mubighili Edzayi yikeele: «Mfumu, na aasi kana mu mandagha ma liilyele bihi? Kundaa nande Mfumu aasuo lileene li nde?» ");
INSERT INTO tyx_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bo bákwono osa kana, ti bu olyele Edzayi: ");
INSERT INTO tyx_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Nde aadzwi bo mihi ya nde aagwi bo mikolo mimi ngyi, mpaala banyaã omono mu mihi mi bo, banyaã obaghala mu mikolo mi bo, ya banyaã ogyiŋi mayele, ya mpaala me ndzuhu bo!» ");
INSERT INTO tyx_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Edzayi ábili obo mu kuulu nde ámono nsia a Yiisu, ya ábili mu Nde. ");
INSERT INTO tyx_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Lo, ŋa kara li bomo bamfumu ba ba-Dzwife, balagha bási kana mu Yiisu. Lo mu nkooro a ba-Faridzyẽ, bo ka bákakihi nde ŋa mihi mi baara bwohono o, mpaala banyaã obyi bo mu nzo a lisamana a ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bo bákabvulu odzyi nsia yi ookagwa bo baara, lo ka li oyo yi aakafa kundaa Nzaami o. ");
INSERT INTO tyx_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mu obo Yiisu ábili mu likyi lili mpini ndiri: «Nswe munde wu aasa kana mu me, ka mu me nde asi kana o, lo mu munde wu aagweghe me. ");
INSERT INTO tyx_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ya mbwuru wu mono me, nde mono si munde wu aaweghe me. ");
INSERT INTO tyx_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Me aangyi ŋa nsie ti anga otsyeme, mpaala nswe munde wu àasa kana mu me, anyaã okala kunsa mpyibi. ");
INSERT INTO tyx_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kala ti mbwuru gyughu mandagha ma me ya bihi mo okebe, me ka ndamana nde o, buulu me ka aangyi mu oyalamana nsie o, lo me aangyi mu oyabvwuhu nsie. ");
INSERT INTO tyx_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nswe munde wu aabihi me ya bihi okihi mandagha ma me, nde li a nsughu alamana a nde: Me ndagha yi aandyele me akala aalamana nde mu etsughu kii masini. ");
INSERT INTO tyx_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mu kuulu, me ka aambili mu litumu li meme o, lo Taara wu áagweghe me áatumu me mandagha ma mfaana olyele me ya bu mfaana oluo me. ");
INSERT INTO tyx_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ya me nsoolo ti litumu li nde liikagwa laama lili mibvu ya mibvu. Mandagha ma ndyele me, me ndyele mo ti bwunu a bu ólyele me Taara mo.» ");
INSERT INTO tyx_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nsomo basomo kyiri kii Paake, Yiisu bu asoolo ti matala ma nde mama omara ŋa nsie mu ogye kundaa Taara maato, nde wu áakadzyi baba nde ba bali mu nsie, nde ádzyi bo tee ku masini. ");
INSERT INTO tyx_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Mu matala mama nkonkolo, Yiisu ákadza ya binduono bi nde, dyabulu ásohobo etsimi kii otyeghe Yiisu mu mukolo a Yuda, mwana a Simõ Isikaryote. ");
INSERT INTO tyx_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yiisu ásoolo ti Taara ágwi byehene ŋa myaã mi nde, ya nde kundaa Nzaami áfi, ya li mu obvughuru kundaa Nzaami. ");
INSERT INTO tyx_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yiisu átemene, ádzwulu enkuru e nde kii ŋa yulu, ya ásyere eko ki baakagyala madza mu bala. ");
INSERT INTO tyx_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nde álo madza mu ndoŋo, ábaana oswagha myili mi binduono bi nde, ya ábwi ogyala mye mu eko ki baakagyala madza ki ásyere nde mu bala. ");
INSERT INTO tyx_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bu ato ŋa nkulu a Simõ-Piere, Simõ-Piere áfwulu nde ti: «Mfumu, me we aaswagha me myili?» ");
INSERT INTO tyx_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yiisu ábvuhulu nde ti: «Mu matala ma, we ka kughu osoolo ndagha yi ndi mu okagyighili me o, lo mbala-tsughu, we sa baghala yo.» ");
INSERT INTO tyx_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piere ályele nde ndiri: «Si okala ka bunu, we ka kughu oswagha me myili o!» Yiisu ábvuhulu kundaa nde ti: «Kala ti me ka nswagha we myili o, lo we ka akala emo ya me o.» ");
INSERT INTO tyx_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simõ-Piere ályele kundaa nde ti: «Mfumu, mu obo ka swagha me yini a myili o, lo swagha me myaã ya mutswi si!» ");
INSERT INTO tyx_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yiisu ábvuhulu kundaa nde ti: «Mbwuru wu maagyogho madza, li a yina nzala oswagha myili, mu kuulu nyuru a nde yohono yili tse-tse. Be lili baba tse-tse, lo ka be bwohono o.» ");
INSERT INTO tyx_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yiisu ásoolo mbwuru wu akala aatyeghe nde, mu obo nde ályele ti: «Be bwohono ka lili baba tse-tse o.» ");
INSERT INTO tyx_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Mu matala ma ámana nde oswagha bo myili, nde áfirilaha enkuru e nde kii yulu, ábvughuru ábwi-nsini ŋa tabele ya áfwulu bo ti: «Be liibaghala ndagha yi aangyighili me be? ");
INSERT INTO tyx_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Be liikata me mu “Muluo” ya “Mfumu”, mu oyo be lili a bwu, mu kuulu me ndi Muluo ya Mfumu. ");
INSERT INTO tyx_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mu obo, kala ti me aanswagha be myili, me wu ndi Mfumu ya Muluo, behe si lifaana okaswagha myili be a be. ");
INSERT INTO tyx_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Me nsuo be bu lifaana osa. Bu aansi me kundaa be, behe si lisa obo kundaa babamõ. ");
INSERT INTO tyx_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mu engaŋma me ndyele be ti, Nkana ka bvulu mfumu a nde mu mupfunu o, bwunu we ntumu ka bvulu munde wu aagweghe nde mupfunu o. ");
INSERT INTO tyx_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Be bu lisoolo ndagha yi, be sa likala a esee kala ti, be lisalala yo. ");
INSERT INTO tyx_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Me ka ndyele ndagha yi mu nkooro a be bwohono o, me nsoolo babo ba aansuolo me. Lo ndagha oyo yi básono mu Mikaana mi Nzaami yifaana okeele: “Munde wu líikadza limpa emõ ya me, ayi mutaara a me”. ");
INSERT INTO tyx_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mu matala ma, me ndyele be ndagha yi aabwa nsomo yo yibwa, mpaala ŋa akala oobwa ndagha me, be lisa kana ti “Me Ndi”. ");
INSERT INTO tyx_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mu engaŋma me ndyele be ti, nswe munde wu aagyagha munde wu ngweghe me, me agyagha, munde wu gyagha me, gyagha wu áagweghe me.» ");
INSERT INTO tyx_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bu abili obo, endwi e nyuru épala Yiisu ya nde ályele ti: «Mu engaŋma me ndyele be, mumõ ŋa kara li be sa atyeghe me.» ");
INSERT INTO tyx_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Binduono bítala bambaala ya bíkafwulu ti nde mu nande ákabili. ");
INSERT INTO tyx_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mumõ ŋa kara li binduono, munde wu ókadzyi Yiisu, áli abwi-nsini ŋa bele a nde. ");
INSERT INTO tyx_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simõ-Piere ákoro enduono ekye mu kuulu kye efwulu Yiisu, mu nande nde ákabili obo. ");
INSERT INTO tyx_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Enduono ekye bu esiŋi ŋa etulu e Yiisu, éfwulu nde ti: «Mfumu, na munde?» ");
INSERT INTO tyx_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yiisu ábvuhulu ndiri: «Me munde wu aangwa me ekele ki limpa ki àantsubu me mu ndoŋo.» Yiisu ágwolo ekele ki limpa ki átsubu nde mu ndoŋo ya ágwi kye kundaa Yuda, mwana a Simõ Isikaryote. ");
INSERT INTO tyx_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda bu agyagha ekele ki limpa ekye, Satana ásomo mu nde. Yiisu ályele kundaa nde ti: «Ndagha yi dzyi we ogyighili, gyighili yo mu maswa-maswa.» ");
INSERT INTO tyx_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mbwuru si mumõ mu ba báli oŋo, ka ábaghala o mu emakye nde ábili obo. ");
INSERT INTO tyx_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Buulu Yuda aakakwara empogholo e nzi, babake bátsimi ti Yiisu nde átumu mu oyiswumu bilogho bi báli a nzala a bye mu kyiri, bwunu we mu oyigwa bilogho kundaa bawele. ");
INSERT INTO tyx_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Bu amana agyagha ekele ki limpa ekye, ŋaana oŋo, nde ápala. Mpyibi áli yi maabwa. ");
INSERT INTO tyx_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda bu apala, Yiisu ályele ndiri: «Mu matala ma, Mwana a mbwuru maabagha nsia, ya Nzaami aabagha nsia mu nde. ");
INSERT INTO tyx_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kala ti Nzaami bagha nsia mu nde, Nzaami ndeme si sa agwa Mwana a nde nsia, ya edzi-dzighi, nde sa agwa yo. ");
INSERT INTO tyx_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Baana ba me, me ndi ya be mu mana matala. Be sa lisagha me. Ya ti bwunu a bu aandyele me kundaa ba-Dzwife ti: “Ku aangye me, be ka likughu ogye oko o.” Mu matala ma, me ndyele obo kundaa behe si. ");
INSERT INTO tyx_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Me ngwi be mukyene wu munyaghara: Liikakala a dzyi be a be . Bwunu a bu aandzyi me be, behe si liikadzyi be a be. ");
INSERT INTO tyx_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kala ti be likala a dzyi be a be, baara bwohono sa basoolo ti be lili binduono bi me.» ");
INSERT INTO tyx_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simõ-Piere áfwulu nde ti: «Mfumu, we kunu aagye?» Yiisu ábvuhulu nde ti: «Oko ku aangye me, we ka kughu onama me mu matala ma o. Lo ku nkulu, we sa nama me.» ");
INSERT INTO tyx_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piere ábvuhulu nde ti: «Mfumu, mu emakye me ka nkughu onama we mu matala ma o? Me aankughu mu ogwa laama li me mu nkooro a we!» ");
INSERT INTO tyx_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yiisu ábvuhulu ndiri: «We aakughu mu ogwa laama li we mu nkooro a me! Mu engaŋma, me ndyele we ti mu mansa matere we sa tunu me, nsomo mulumu a nsuhu akuolo.» ");
INSERT INTO tyx_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yiisu ályele kundaa binduono bi nde ti: «Mikolo mi be ka mikala maã-maã o. Lisa kana mu Nzaami, lisa si kana mu me. ");
INSERT INTO tyx_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mu nzo a Taara a me oli a bibini bilagha. Kala pele, me ka aakandyele be ti me sa yingyighili be ebini o. ");
INSERT INTO tyx_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Me yingyighili be ebini, me sa yamvughuru mu ogwolo be, mpaala ŋa ebini ki akala aankala me, behe si likala oŋo. ");
INSERT INTO tyx_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Oko ku ndi mu ogye me, be lisoolo nzili yi baakagye oko.» ");
INSERT INTO tyx_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma ályele nde ti: «Mfumu, bihi ka lisoolo ku li mu ogye we o, lo bunu bihi liisoolo nzili yi baakagye oko?» ");
INSERT INTO tyx_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yiisu ályele nde ti: «Me ndi nzili, engaŋma ya laama. Ka oli a mbwuru wu kughu ogye kundaa Taara o kala ti nde ka luru mu me o. ");
INSERT INTO tyx_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kala ti be liisoolo me, be liikaasoolo si Taara a me. Ya mu matala ma, be liisoolo nde ya be liimono nde.» ");
INSERT INTO tyx_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipe ályele nde ti: «Mfumu, suo bihi Taara, ya obo okughu mu bihi.» ");
INSERT INTO tyx_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yiisu ábvuhulu ti: «Filipe, edzighi e lagha me ndi ya be, lo we ka soolo me! Munde wu mono me, Taara amono. Mu emakye we lyele ti: “Suo bihi Taara?” ");
INSERT INTO tyx_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","We ka li a kana o ti me ndi mu Taara ya Taara li mu me? Mandagha ma aakandyele me be, ka meme aakambagha mo o, lo Taara wu li mu me, aakakuhu bigyighili bi nde ndeme. ");
INSERT INTO tyx_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Lisa kana mu me, ti me ndi mu Taara ya Taara li mu me. Kala pele, lisa kana yini mu nkooro a bigyighili bi.» ");
INSERT INTO tyx_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«Mu engaŋma, me ndyele be: Munde wu aasa kana mu me, ndehe si sa asa bigyighili bi aakangyighili me. Nde sa asa bi bibvulu bunene ya bi aansi me, mu kuulu me ndi mu ogye kundaa Taara. ");
INSERT INTO tyx_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mandagha mwohono ma akala liiluomo be mu nkwumu a me, me sa ngyighili mo, mpaala Taara abagha nsia mu Mwana. ");
INSERT INTO tyx_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kala ti be liluomo elogho mu nkwumu a me, me sa ngyighili obo.» ");
INSERT INTO tyx_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Kala ti be lidzyi me, likebe Mikyene mi me. ");
INSERT INTO tyx_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Me sa nduomo kundaa Taara agweghe be Mubaha mukimi wu àayakala ya be mu matala mwohono. ");
INSERT INTO tyx_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nde me Mufulu wu engaŋma, munde wuulu baara ba nsie ka bakughu okihi o, mu kuulu bo ka bakughu omono ya ka bakughu osoolo nde o. Lo be, be lisoolo nde, mu kuulu nde li ŋa kara li be, ya nde sa akala mu be. ");
INSERT INTO tyx_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Me akala ka ansihi be bisyana o, me sa yambvughuru kundaa be. ");
INSERT INTO tyx_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Matala masala masyili, nsie ka yifirimono me o. Lo be sa limono me, mu kuulu me ndi mweẽ, ya behe si sa likala mweẽ. ");
INSERT INTO tyx_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mu etsughu me ekye, be sa libaghala ti, me ndi mu Taara a me, anga bu lili be mu me, ya me ndi mu be. ");
INSERT INTO tyx_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Munde wu dzyi me, me munde wu li a Mikyene mi me ya wu aakanama mye. Mu obo munde wu dzyi me, Taara a me sa adzyi nde, mehe si sa ndzyi nde ya sa me moŋono kundaa nde.» ");
INSERT INTO tyx_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mu obo, Yuda wuulu ka wu a musi Isikaryote o, áfwulu nde ndiri: «Mfumu, mu emakye we akala aamoŋono yina kundaa bihi, lo ka kundaa basi nsie o?» ");
INSERT INTO tyx_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yiisu ábvuhulu nde ti: «Kala ti mbwuru dzyi me, nde sa anama mandagha ma me, ya Taara a me sa adzyi nde. Mu obo, bihi sa ligya kundaa nde ya sa likala mu nde. ");
INSERT INTO tyx_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Munde wu gwene dzyi me, ka aakanama mandagha ma me o. Ndagha yi lili mu okagyughu be, yo ka yifi kundaa me o, lo kundaa Taara wu aagweghe me. ");
INSERT INTO tyx_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Me aandyele be mandagha ma mu matala ma ndi me nkini ŋa kara li be. ");
INSERT INTO tyx_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lo me Mukala, Mufulu a Ngili wu akala oogweghe Taara mu nkwumu a me, sa aluo be mandagha mwohono ya sa alibili be mweẽ mu mandagha mwohono ma ándyele me be.» ");
INSERT INTO tyx_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Me nsihi be edzuunu, me ngwi be edzuunu e me. Me ka ngwi be kye ti anga bu ookagwa baara ba nsie o. Mikolo mi be minyaã okala maã-maã ya minyaã okala a nzalamweẽ. ");
INSERT INTO tyx_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Be áli liigyughu ti me áandyele be ndiri: “Me ndi mu ogye, ya me sa yamvughuru kundaa be”. Kala ti be áli liikadzyi me, be likaakala mu esee mu ogye o me kundaa Taara, mu kuulu Taara bvulu me mupfunu. ");
INSERT INTO tyx_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Me ndyele be mandagha mamo mu matala ma, nsomo mo mabwa, mu kuulu ŋa akala maabwa mo, be lisa kana. ");
INSERT INTO tyx_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Me ka afirimbili ku olagha ya be o, mu kuulu mfumu a nsie yi li mu ogya. Nde ka li a litumu ŋa yulu a me o. ");
INSERT INTO tyx_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Lo baara ba nsie bafaana osoolo ti me ndzyi Taara ya me aakansa mandagha ma aakatumu nde me. Litemene, litswe limara ŋa ebini ki!» ");
INSERT INTO tyx_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Me ndi muti a bviini wu a ngaŋma ya Taara a me li munde wu aakasala mu nseghe a bviini oyo. ");
INSERT INTO tyx_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nswe mpala yi li mu me, yiili ka yiikaburu mburu o, nde aakamaha yo. Ya nde aakatebe mampala ma maakaburu mburu mu kuulu mo maburu mburu yi alagha. ");
INSERT INTO tyx_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Be, be lili tse-tse mu nkooro a mandagha ma aandyele me be. ");
INSERT INTO tyx_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Likala ba banabara mu me ti bu ánabara me mu be! Mpala si mõ ka yikughu oburu mburu yomo o, kala ti yo ka yili yinabara mu muti a bviini o. Bumõ si kundaa be, kala ti be ka likala ba banabara mu me o, be ka liburu mburu o. ");
INSERT INTO tyx_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Me ndi muti a bviini, be lili mampala. Munde wu akala wu aanabara mu me, ti bwunu a bu ndi me wu aanabara mu nde, nde sa aburu mburu yi alagha. Lo kala ti me we, be ka likughu ogyighili ndagha si mõ o. ");
INSERT INTO tyx_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kala ti mbwuru ka kala wu anabara mu me o, sa batsili nde ku mbala ti anga mpala, ya yo sa yikee. Ya mampala ma makee baakatolo mo, baakatubu mo ku mbaa, ya mo maakadzighi. ");
INSERT INTO tyx_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kala ti be likala ba banabara mu me, ya mandagha ma me makala manabara mu be, liluomo nswe elogho ki liidzyi be ya be sa libagha kye. ");
INSERT INTO tyx_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Bu ngu bu okamoŋono nsia a Taara a me: be liburu mburu yi alagha ya likala binduono bi me. ");
INSERT INTO tyx_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Me aakandzyi be ti bu ódzyi me Taara. Likala ba banabara mu dzyi li me. ");
INSERT INTO tyx_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kala ti be linama Mikyene mi me, be sa likala ba banabara mu dzyi li me, ti bwunu a bu aankebe me Mikyene mi Taara a me ya me ndi wu anabara mu dzyi li nde.» ");
INSERT INTO tyx_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Me ndyele be mandagha ma mu kuulu esee e me ekala mu be, ya esee e be ekala kii mukughu. ");
INSERT INTO tyx_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Wu me mukyene wu ngwi me be: Liikakala a dzyi be a be ti bu aakandzyi me be. ");
INSERT INTO tyx_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ka oli a dzyi li libvulu bunene ti lili munde wu aagwa laama li nde mu ba adzyi nde o. ");
INSERT INTO tyx_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Be lili bandughu ba me, kala ti be liikasa mandagha ma aakantumu me be. ");
INSERT INTO tyx_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Me ka firinta be basala o, mu kuulu musala ka soolo mandagha ma ookayighili mfumu a nde o. Lo be, me nti be bandughu ba me, mu kuulu me aansuo be mandagha mwohono ma aangyughu me kundaa Taara a me. ");
INSERT INTO tyx_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ka oli be liisuolo me o, lo me aansuolo be ya me aando be mu esala kii ogye, mu oyiburu mburu, mburu yi aagyili. Mu obo, Taara sa agwa be byehene bi akala liiluomo be kundaa nde mu nkwumu a me. ");
INSERT INTO tyx_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mukyene wu ngwi me be ngu wu: Liikakala a dzyi be a be.» ");
INSERT INTO tyx_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yiisu afirilyele ndiri: «Kala ti baara ba nsie babele be, lisoolo ti bo bátswama bele me nsomo ya be. ");
INSERT INTO tyx_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kala ti be áli baara ba nsie, nkini nsie yíkaadzyi be, mu kuulu be likakala baba nde. Lo me áansuolo be ya áampaha be ŋa kara li baara ba nsie. Be ka lili baara ba nsie o, me mu obo nsie yili mu okabele be. ");
INSERT INTO tyx_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Litsimi mu mandagha ma aandyele me be: “Nkana ka bvulu mfumu a nde mu mupfunu o”. Kala bo baamwehẽ me kimini, bo sa bamwehẽ behe si kimini. Kala bo baakebe mandagha ma me, lo bo sa bakebe mandagha ma behe si. ");
INSERT INTO tyx_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lo bo sa bamwehẽ be kimini mu nkooro a nkwumu a me, mu kuulu bo ka basoolo munde wu aagweghe me o. ");
INSERT INTO tyx_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kala ti me ka ángyi o, ya kala ti me ka ándyele bo o, bo ka baakakala a masumu o. Lo mu matala ma, bo ka bali a bwuu li baagwa o. ");
INSERT INTO tyx_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nswe munde wu bele me, nde bele si Taara a me. ");
INSERT INTO tyx_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kala ti me ka áansi mandagha mama okiŋimi ŋa kara li bo o, mandagha maala mbwuru mukimi nkini ka ámaasa mo o, bo ka bakaakala a masumu o. Lo mu matala ma maala bo baamono mo, bo baabele bihi, me ya Taara a me. ");
INSERT INTO tyx_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mu kuulu mandagha ma, ma básono mu Mikyene mi bo makeele: “Bo baabele me ku ogwene a bwu”». ");
INSERT INTO tyx_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Mu matala ma akala oogya Mubaha wu aangweghe me be ŋa aankala me kundaa Taara, Mufulu wu engaŋma wu aafa kundaa Taara, nde ndeme akala aasuo bumpughulu mu me. ");
INSERT INTO tyx_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ya behe si sa lisuo bumpughulu mu me, mu kuulu be lili ya me obaana ku ebaana.» ");
INSERT INTO tyx_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Me aandyele be mandagha mwohono ma mpaala kana li be linyaã obwa. ");
INSERT INTO tyx_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mu kuulu sa bapaha be mu manzo ma lisamana ma ba-Dzwife. Ya bitsughu bili mu ogya biili, babo ba akala baadzwa be sa batsimi ti obo Nzaami bo bali mu osalala. ");
INSERT INTO tyx_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bo sa basa obo, mu kuulu bo kaala ka básoolo Taara o, ya kaala ka básoolo me o. ");
INSERT INTO tyx_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Lo me aandyele be mandagha mwohono ma, mpaala ŋa ooto matala mamo, be lilibili mweẽ ti me áli áandyele be mo. Ku ebaana, me ka aandyele be mo o, mu kuulu me aandi ya be.» ");
INSERT INTO tyx_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Ya mu matala ma me ndi mu ogye kundaa munde wu aagweghe me, ya mbwuru si mumõ mu be ka aafwulu me o ti: “Kunu we gyene”? ");
INSERT INTO tyx_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mu kuulu me aandyele be mandagha mamo, mikolo mi be miilwulu mu minyoõ. ");
INSERT INTO tyx_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mu engaŋma me ndyele be ti: ali obvulu bubwe kundaa be ti me ngye. Mu kuulu, kala ti me ka ngyene o, Mubaha ka agya kundaa be o. Lo kala ti me ngyene, me sa ngweghe be nde.» ");
INSERT INTO tyx_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","«Mu matala ma aagya nde, nde sa asuo emwehẽ kundaa basi nsie mu mi mitala masumu, bunsumu ya muyala: ");
INSERT INTO tyx_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","mu ndagha yitala masumu, mu kuulu bo ka baasi kana mu me o. ");
INSERT INTO tyx_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mu ndagha yitala bunsumu, mu kuulu me ndi mu ogye kundaa Taara, ya be ka lifirimono me o. ");
INSERT INTO tyx_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mu ndagha yitala mumfwunu, mu kuulu mfumu a nsie yi bamaalamana nde.» ");
INSERT INTO tyx_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Me nkini ndi a mandagha malagha ma aandyele me be, lo mu matala ma, be nkini ka lili a mikolo mi okebe mo o. ");
INSERT INTO tyx_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ŋa akala oogya Mufulu wu engaŋma, nde sa abiri be kunsa engaŋma kyehene. Mu kuulu nde akala ka abili mu litumu li ndeme o, lo nde sa alyele be mandagha ma akala aagyughu nde, ya nde sa alyele be mandagha mwohono ma maagya ku nkulu. ");
INSERT INTO tyx_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nde sa agwa me nsia, mu kuulu nde sa agyagha mandagha ma aandyele me nde, ya nde sa atuoho mo kundaa be.» ");
INSERT INTO tyx_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","«Bilogho bi Taara byehene bili bibi ndaa me. Mu obo me aandyele ti nde sa atuoho kundaa be mandagha ma aagyagha nde kundaa me.» ");
INSERT INTO tyx_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Matala masala masyili, be ka lifirimono me o, ya mana matala masyili, be sa lifirimono me.» ");
INSERT INTO tyx_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Binduono bi nde bibike bíbwi obili bye-a-bye ndiri: «Nsa ndagha nde adzyi olyele bihi mu mbiili yi: “Matala masala masyili, be ka lifirimono me o, ya mana matala masyili, be sa lifirimono me”, bwunu we: “Me ndi mu ogye kundaa Taara”?» ");
INSERT INTO tyx_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bo báfiribwehe ti: «“Matala masala” bunu odzyi olyele? Bihi ka lili mu obaghala ndagha yi adzyi nde olyele o!» ");
INSERT INTO tyx_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yiisu bu asoolo ti bo bákadzyi ogwa nde bifwulu, nde alyele kundaa bo ti: «Be a be lili mu okasagha mbaala a ndagha a me yi: “Matala masala masyili, be ka lifirimono me o, ya mana matala masyili, be sa lifirimono me.” ");
INSERT INTO tyx_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mu engaŋma me ndyele be ti: Be sa lilili ya sa lisyama, lo basi nsie sa bakala kunsa esee. Be sa linyoõ, lo ŋa mbihi, minyoõ mi be sa mikighiri esee. ");
INSERT INTO tyx_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mu matala mama oburu, mukaha akasomo kunsa minyoõ mu kuulu tala li nde lili omono mpara liikughu. Lo nde bu amana oburu mwana, dzimini mpara a nde nsimi. Nde somo kunsa esee mu kuulu nde aaburu mwana. ");
INSERT INTO tyx_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mu matala ma, behe si lili kunsa minyoõ. Lo mu matala ma akala aamfirimono me be, mikolo mi be sa mikala kunsa esee. Ya esee ekye, mbwuru si mumõ ka aleene ogwohono be kye o.» ");
INSERT INTO tyx_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Mu etsughu ekye, be ka lifirigwa me efwulu mu ndagha si mõ o. Mu engaŋma, me ndyele kundaa be: Mandagha mwohono ma liiluomo be kundaa Taara mu nkwumu a me, nde sa agwa be mo. ");
INSERT INTO tyx_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tee mu matala ma, be nkini liiluomo elogho mu nkwumu a me o. Liluomo, sa bagwa be, mpaala esee e be ekala kii mukughu.» ");
INSERT INTO tyx_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Me aandyele be mandagha mwohono ma mu mankumu, lo matala mali mu ogya maala me ka firimbili kundaa be mu mankumu o. Lo me sa ndyele be mandagha ma matala Taara a me ŋa tse-tse. ");
INSERT INTO tyx_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mu etsughu ekye, be sa liluomo kundaa Taara mu nkwumu a me. Lo me ka ndyele be o ti me sa mbuono Taara mu nkooro a be. ");
INSERT INTO tyx_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mu kuulu Taara ndeme dzyi be mu nkooro a ku liidzyi be me ya ku liisi be kana ti me kundaa Nzaami aampfi. ");
INSERT INTO tyx_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Me aampfi kundaa Taara ya me aangyi ŋa nsie. Lo mu matala ma, me ndi mu osihi nsie, ya ndi mu obvughuru kundaa Taara.» ");
INSERT INTO tyx_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Binduono bi nde bílyele kundaa nde ti: «Mu matala ma, we li mu obili ŋa tse-tse, ya we aanyaã mbiili a we yi a mu mankumu. ");
INSERT INTO tyx_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mu matala ma, bihi lisoolo ti we soolo mandagha mwohono ya we ka li a nzala a ti bagwa we bifwulu mu mõ o. Mu obo, bihi lisi kana ti we kundaa Nzaami aafi.» ");
INSERT INTO tyx_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yiisu ábvuhulu bo ti: «Mu matala ma be lisi kana? ");
INSERT INTO tyx_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Limono, matala maabehene, ya mo mamaato, maala sa batsala be, nswe mbwuru sa abara ku áfi nde, ya be sa lisihi me ngasighi. Lo me ka ndi ngasighi o, mu kuulu Taara li emõ ya me. ");
INSERT INTO tyx_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Me aandyele be mandagha ma mu kuulu be likala a edzuunu mu me. Mu nsie yi be sa limono kimini, lo likala a bukyini! Me aandughulu lileene li nsie!» ");
INSERT INTO tyx_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yiisu bu amana obili obo, átala ku yulu ya ályele ti: «Taara, matala maato, sa Mwana a we nsia, mpaala mwana a we asa we nsia. ");
INSERT INTO tyx_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","We aagwi nde emfumu ŋa yulu a baara bwohono, buulu nde agwa laama lili mibvu ya mibvu kundaa bo bwohono ba aagwi we nde. ");
INSERT INTO tyx_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ya laama lili mibvu ya mibvu lili ti bo basoolo we, we Nzaami mumõ wu a ngaŋma, ya basoolo Yiisu-Kriste, munde wu aagweghe we. ");
INSERT INTO tyx_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Me aansi we nsia ŋa yulu a nsie, ya me aamana esala ki aagwi we me osa. ");
INSERT INTO tyx_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ya mu matala ma, Taara, sa me nsia ŋa li we, nsia oyo yi ándi a me ŋa ándi me kundaa we, nsomo we gyighili nsie.» ");
INSERT INTO tyx_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Me aansi kuulu ti baara ba ágwolo we mu nsie yi basoolo we, babo ba ágwi we me. Bo báli baba ndaa we, we aagwi me bo ya bo baakebe ndagha a we. ");
INSERT INTO tyx_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mu matala ma bo basoolo ti byehene bi ágwi we me kundaa we bífi, ");
INSERT INTO tyx_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ya me aantwoho kundaa bo mandagha mamo ma ágwi we me. Bo baakihi mo, ya bo baasoolo mu engaŋma ti me kundaa we aampfi, ya bo baasi kana ti we aagweghe me.» ");
INSERT INTO tyx_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Me nduomo kundaa we mu nkooro a bo. Me ka nduomo we mu nkooro a baara ba nsie o, lo mu babo ba aagwi we me, buulu bo bali baba ndaa we. ");
INSERT INTO tyx_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Byehene bibi me bili bibi we, ya byehene bibi we bili bibi me. Ya nsia a me yili mu okamoŋono mu bo. ");
INSERT INTO tyx_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Me ka afirinkala ŋa nsie o, lo bo bali mu osyili ŋa nsie, mu kuulu me ndi mu ogya kundaa we. Taara wu a ngili, kebe bo mu nkwumu a we, nkwumu yi aagwi we me, mpaala bo bakala emõ ti anga bu lili bihi a we emõ. ");
INSERT INTO tyx_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ŋa aandi me ya bo, me aakankebe bo mu nkwumu a we yi ágwi we me. Me aakankala bo ya si mumõ mu bo ka aadzimini o, ŋa yulu a yini a munde wu áafaana odzimini, mpaala mamo ma básono mu Bisono makeele.» ");
INSERT INTO tyx_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Mu matala ma, me ndi mu ogya kundaa we ya me ndyele mandagha ma ŋa ndi me nkini ŋa nsie, mpaala bo bakala a esee e me mu bo, esee kii mukughu. ");
INSERT INTO tyx_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Me aanduo bo ndagha a we, ya nsie yiibele bo, mu kuulu bo ka bali baara ba nsie o, ti anga me, me ka ndi mbwuru a nsie o. ");
INSERT INTO tyx_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Me ka nduomo we mu omaha bo ŋa nsie o, lo we kebe bo mu Wu Mubi. ");
INSERT INTO tyx_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bo ka bali baara ba nsie o, ti anga me, me ka ndi mbwuru a nsie o. ");
INSERT INTO tyx_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sa kuulu ti bo bakala baara ba we mu nzili a engaŋma: Ndagha a we yili engaŋma. ");
INSERT INTO tyx_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Bwunu a bu aagweghe we me mu nsie, me ngweghe boho si mu nsie. ");
INSERT INTO tyx_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ya me meme ngwi we bumweẽ bu me mu nkooro a bo, mpaala boho si bakala baara ba we mu engaŋma.» ");
INSERT INTO tyx_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Me ka nsamana yini a mu bo o, lo mu babo si ba akala baasa kana mu me mu nkooro a maluo ma bo. ");
INSERT INTO tyx_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Me nsamana si mu kuulu bo bwohono bakala mbwuru mumõ ti bu li we Taara mu me, ya me mu we. Boho si bakala mu bihi, mpaala baara ba nsie basa kana ti we aagweghe me. ");
INSERT INTO tyx_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ya me aansi bo nsia yi áasi we me, mpaala bakala mbwuru mumõ ti anga bu lili bihi a we mbwuru mumõ. ");
INSERT INTO tyx_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Me nkala mu bo ya we kala mu me. Obo bo bakala mbwuru mumõ mu ngaŋma, ya mpaala baara ba nsie basoolo ti we aagweghe me ya we aakadzyi bo ti bwunu a bu aakadzyi we me.» ");
INSERT INTO tyx_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Taara, me ndzyi ti babo ba aagwi we me, bakala si ya me oŋo ŋa akala aankala me, ya bo bamono nsia a me, nsia yi aasi we me, mu kuulu we áadzyi me nsomo we gyighili nsie. ");
INSERT INTO tyx_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Taara wu a nsumu, baara ba nsie nkini bámaasoolo we o, lo me aansoolo we, ya binduono bi me bi biisoolo ti we aagweghe me. ");
INSERT INTO tyx_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Me aansi kuulu ti bo basoolo nkwumu a we, ya me sa firinsa obo, mpaala dzyi li li a we mu me likala mu bo, ya me nkala mu bo.» ");
INSERT INTO tyx_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yiisu bu amana olyele mandagha mamo, ápala ya binduono bi nde ya ágyene ku ngulu a emwe-mwele kii Sederõ. Oko óli a ebwa ki miti, ya Yiisu ásomo omo ya binduono bi nde. ");
INSERT INTO tyx_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda wu áatyeghe Yiisu, ákasoolo ebini ekye, mu kuulu Yiisu ya binduono bi nde báli a epfu kii okayibvuŋunu oko. ");
INSERT INTO tyx_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yuda ábiri mpwumu a bambumbulu ya bankyele ba nzo a Nzaami ba ógwi bakwuru ba bangaa ba nzaami ya ba-Faridzyẽ. Bo básomo kunsa ebwa ki miti ya bitsyi bi mbaa, miindi ya bidzwana. ");
INSERT INTO tyx_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Buulu Yiisu ali ásoolo mandagha mwohono ma maagya mu nde, ásele kundaa bo ya ályele ti: «Be nande lili mu okasagha?» ");
INSERT INTO tyx_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bo bábvuhulu nde ti: «Yiisu, musi Nadzarete.» Nde ályele bo ti: «Me me.» Yuda wu áatyeghe nde áli ŋa kara li bo. ");
INSERT INTO tyx_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ŋa ólyele bo Yiisu ti: «Me me», bo bábvughuru limbi-mbihi ya bábwi mu nsie. ");
INSERT INTO tyx_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yiisu áfirifwulu bo ti: «Be nande lili mu okasagha?» Bo bábvuhulu nde ti: «Yiisu, musi Nadzarete.» ");
INSERT INTO tyx_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yiisu ábvuhulu bo ti: «Me aandyele be ti, me me. Kala ti ngu me be lili mu okasagha, linyaã baara ba bagye.» ");
INSERT INTO tyx_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Obo me bu okeele ndagha yi ályele nde ti: «Me ka aandzihibi si mumõ mu babo ba aagwi we me o.» ");
INSERT INTO tyx_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simõ-Piere wu áali a lipee, ádzuru lo mu likuru, ya bu akaha musala e mukwuru a bangaa ba Nzaami, átsyiri nde tswi lili ku kwogho kii babaghala. Nkwumu a musala munde áli Malekuse. ");
INSERT INTO tyx_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Lo Yiisu ályele kundaa Piere ti: «Bvurulu lipee li we munsa likuru li lo! We bu tsimi ti me ka nkughu oŋma ebaha kii kimini ki ti bu ootumu me Taara o?» ");
INSERT INTO tyx_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mu obo, mpwumu a bambumbulu, mfumu a bo ya bankyele ba bamfumu ba ba-Dzwife básyimi Yiisu ya bákuru nde bibolo. ");
INSERT INTO tyx_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bo bábiri nde nsomo kundaa Aane, buko bu Kayife munde wu áali mukwuru a Bangaa ba Nzaami mu mubvu munde. ");
INSERT INTO tyx_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ngu Kayife áagwi ba-Dzwife luo ti: «Bubwe mbwuru mutsyini akpa mu nkooro a baara bwohono». ");
INSERT INTO tyx_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simõ-Piere ya enduono ekimi bákanama Yiisu. Buulu Mukwuru a bangaa ba nzaami ákasoolo enduono e Yiisu ekye, kye ésomo ya Yiisu mu mbala a nzo a Mukwuru a bangaa ba nzaami. ");
INSERT INTO tyx_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piere átemene ku mbala ŋa bele a muŋma a nzo. Enduono ekye ki ósoolo Mukwuru a bangaa ba nzaami épala, ébili ya mukaha wu áali nkyele a muŋma a nzo ya nde ásohobo Piere. ");
INSERT INTO tyx_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mu obo, musala wu mukaha wu áali nkyele a muŋma a nzo ályele kundaa Piere ndiri: «Wehe si ka li mumõ ŋa kara li binduono bi mbwuru wu o?» Piere ábvuhulu ti: «Pele, me ka ndi enduono e nde o!» ");
INSERT INTO tyx_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Buulu óli a mpie, basala ya bankyele bábvughu mbaa ya bákagyoro. Piere si átemene ya bo ya ákagyoro mbaa. ");
INSERT INTO tyx_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mukwuru a bangaa ba nzaami ábwi ogwa Yiisu bifwulu mu binduono bi nde ya mu maluo ma nde. ");
INSERT INTO tyx_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yiisu ábvuhulu nde ti: «Me aakambili epankala ŋa nkulu a baara bwohono. Mu matala mwohono me aakanduo mu manzo mama lisamana ma ba-Dzwife ya mu nzo a Nzaami yi nene, mu ookabvuŋunu ba-Dzwife bwohono. Me ka aandyele ndagha si mõ mu ensweghe o. ");
INSERT INTO tyx_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mu emakye we li mu ogwa me bifwulu? Mandagha ma aandyele me, fwulu mo kundaa babo ba báakagyughu me. Bo bagyighili osoolo mandagha ma aandyele me.» ");
INSERT INTO tyx_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yiisu bu abili obo, nkyele mumo wu áali oŋo ákaha Yiisu limpala ya ályele nde ti: «Oyo mvuru yi kughu ogwa we kundaa Mukwuru a bangaa ba nzaami?» ");
INSERT INTO tyx_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yiisu ábvuhulu nde ti: «Kala ti me bubi mbili, suo me bubi bubo. Lo kala ti me bubwe mbili, mu emakye we kaha me?» ");
INSERT INTO tyx_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Oŋo Ane ágweghe Yiisu ya bibolo kundaa Kayife, Mukwuru a bangaa ba nzaami. ");
INSERT INTO tyx_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mu matala ma ókagyoro Simõ-Piere mbaa oŋo, báfwulu nde ti: «Wehe si ka li mumõ mu binduono bi baghala wu o?» Piere átunu ya ályele ti: «Pele, me ka ndi enduono e nde o!» ");
INSERT INTO tyx_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Musala a Mukwuru a bangaa ba nzaami mumõ, wu áali musi dzumu li munde wu ótsyiri Piere tswi ályele nde ti: «Ka oli we me aamono ku ebwa ki miti ya Yiisu o?» ");
INSERT INTO tyx_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piere áfiritunu nde, ya ŋaana oŋo, mulumu a nsuhu ákwolo. ");
INSERT INTO tyx_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mu obo, mu minkya-nkya, bámara a Yiisu kundaa Kayife, ya bábiri nde ku nzo a emfumu ki ba-Romẽ mu etsulu e nsie ekye. Babo ba bákabiri nde bábihi osomo munsa nzo oyo, mu kuulu banyaã osuŋumu ya mpaala badza kyiri kii Paake. ");
INSERT INTO tyx_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mu obo, Pilate wu áali mfumu a etsulu e nsie ekye ágyabagha bo ku mbala ya áfwulu bo ti: «Mu nki ndagha be liifwunu mbwuru wu?» ");
INSERT INTO tyx_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bo bábvuhulu nde ti: «Kala ti mbwuru wu ka aasi bubi o, bihi ka likaatyeghe nde kundaa we o!» ");
INSERT INTO tyx_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate ályele bo ti: «Ligwolo nde ya lilamana nde be beme ti bwunu a bu oli Mikyene mi be.» Ba-Dzwife bábvuhulu nde ti: «Bihi ka lili a muswa wu otsyiri mbwuru mukakana wu lipfu o!» ");
INSERT INTO tyx_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Obo me bu ófaana ookeele ndagha yi ólyele Yiisu, ŋa ásuo nde mu nsa lipfu nde afaana okpa. ");
INSERT INTO tyx_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate ábvughuru munsa nzo, áti Yiisu mbili ya áfwulu nde ti: «Ngu we li mukogho a ba-Dzwife?» ");
INSERT INTO tyx_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yiisu ábvuhulu nde ti: «Mi lyele we mimye weme bagha mye, bwunu we baara bakimi baalyele we obo mu me?» ");
INSERT INTO tyx_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate ábvuhulu nde ti: «Me, mu-Dzwife ndi? Baara ba weme ya Bakwuru ba bangaa ba nzaami baagyatyeghe we kundaa me! Nki ndagha we aasi?» ");
INSERT INTO tyx_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yiisu ábvuhulu nde ti: «Emfumu e me ka eli kii nsie yi o. Kala ti emfumu e me áli kii nsie yi, nkini basala ba me baakadzwana mpaala banyaã ogwa me ŋa myaã mi bamfumu ba ba-Dzwife. Lo, emfumu e me ka eli kii ŋa nsie ŋa o.» ");
INSERT INTO tyx_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilate áfwulu nde ti: «We ankoho mukogho li?» Yiisu ábvuhulu nde ti: «We lyele ti me ndi mukogho. Me báburu me ya kala ti me áangyi mu nsie me mu okala mpughulu a engaŋma. Nswe munde wu li wu a engaŋma nde aakagyughu mandagha ma me.» ");
INSERT INTO tyx_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate áfwulu nde ti: «Engaŋma emakye?» Pilate bu amana obili obo, áfiriyimono ba-Dzwife ku mbala ya ályele bo ti: «Me ka mono epfwumu ki oosi baghala wu o, mu kuulu me ntsyiri nde mukakana wu lipfu. ");
INSERT INTO tyx_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Lo, mu buulu epfu e be eli ti mu nswe kyiri kii Paake, me mfaana onyaã be mbwuru a boloko mutsyini, be lidzyi ti me nyaã be mukogho a ba-Dzwife?» ");
INSERT INTO tyx_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mu obo bo bwohono bábwi okehe bingubu ti: «Pele, ka munde o! Lo Barabase!» Lo Barabase munde áli ntwumu. ");
INSERT INTO tyx_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mu obo, Pilate ágwi litumu ti babiri Yiisu ya bakaha nde nswa-nswa. ");
INSERT INTO tyx_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bambumbulu bátwu kagha lili mu mansiene, bákwighi nde lo mu mutswi ya bálaha nde enkuru kii mungala. ");
INSERT INTO tyx_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bo báyabehene ya nde ya bákalyele nde ti: «Mboro a we, mukogho a ba-Dzwife!» Ya bákakaha nde mampala. ");
INSERT INTO tyx_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate áfiripala ku mbala ya ályele kundaa ba-Dzwife ti: «Ligyughu, me nde aayambiri be ku mbala, mu kuulu be lisoolo ti me ka aambagha ebili mu nde o, mu kuulu me ntsyiri nde mukakana wu lipfu.» ");
INSERT INTO tyx_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mu obo, bápala a Yiisu ku mbala. Nde áli álaha kagha lili mu mansiene ya enkuru kii mungala. Pilate ályele bo ti: «Limono mbwuru me!» ");
INSERT INTO tyx_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Lo bakwuru ba Bangaa ba Nzaami ya bankyele bu bamono Yiisu, bo bákafulu bingubu: «Komo nde ŋa kuruwa! Komo nde ŋa kuruwa!» Pilate ályele bo ti: «Ligwolo nde ya likomo nde beme ŋa kuruwa. Mu kuulu, me ka aambagha ebili mu nde o ki bakughu otsyiri nde mukakana wu lipfu.» ");
INSERT INTO tyx_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ba-Dzwife bábvuhulu nde ti: «Bihi lili a mukyene, ya mu bu ookasuo mukyene munde, nde faana okpa, mu kuulu nde aalyele ti nde li Mwana a Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ŋa ógyughu Pilate ndagha oyo, nde áfirimono nzalamweẽ kuu oluru. ");
INSERT INTO tyx_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nde áfirisomo munsa nzo ya áfwulu Yiisu ti: «We kunu-a-ko áfi?» Lo Yiisu ka ágwi nde mvuru o. ");
INSERT INTO tyx_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mu obo, Pilate ályele nde ti: «Mu emakye we li mu okatsurulu me? We ka soolo o ti me ndi a litumu lili onyaã we, bwunu we lili osa ti bakomo we ŋa kuruwa?» ");
INSERT INTO tyx_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Lo Yiisu ábvuhulu nde ti: «We ka ákaakala a litumu ŋa yulu a me o, kala ti Nzaami mu mayulu ka ágwi we lo o. Me mu obo, lisumu lili munde wu aatyeghe me kundaa we libvulu lili we mu bunene.» ");
INSERT INTO tyx_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Obaana oŋo, Pilate ákasagha bu aanyaã Yiisu, lo ba-Dzwife bákakehe bingubu ya bákalyele ti: «Kala ti we nyaã nde, lo we ka li ndughu a Sedzare o! Mu kuulu nswe munde wu aalyele ti nde li mukogho, nde li mutaara a Sedzare.» ");
INSERT INTO tyx_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Mu matala ma ógyughu Pilate ndagha oyo, nde ábiri Yiisu ku mbala ya ábwi nsini ŋa epehe kii muyala, ki baakata ti ebini ki bágyala mameẽ, mu Eebele baakalyele ti Ngabata. ");
INSERT INTO tyx_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ku bele a tala lili embehe mu etsughu ki ékatswama nsomo ya etsughu kii kyiri kii Paake, Pilate ályele kundaa ba-Dzwife ti: «Limono mukogho a be!» ");
INSERT INTO tyx_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Lo bo bákakehe bingubu ti: «Dzwa nde! Dzwa nde! Komo nde ŋa kuruwa!» Pilate áfirilyele ti: «Be lidzyi me nkomo mukogho a be ŋa kuruwa?» Bakwuru ba bangaa ba Nzaami bábvuhulu nde ti: «Bihi ka lili a mukogho mukimi o kala ka yini a Sedzare o.» ");
INSERT INTO tyx_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mu obo, Pilate ágwi bo Yiisu mpaala bakomo nde ŋa kuruwa. Me obo, bo bábiri Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yiisu ákabiri kuruwa li nde ndeme, ápala mu bvulu ya ágyene ku ebini kii nkwumu etyee ki mutswi a mbwuru, mu Eebele baakalyele ti Ngolongota. ");
INSERT INTO tyx_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Me oŋo bo bákomo nde ŋa kuruwa. Bo bákomo baara buolo bakimi ngulu ya ngulu, ya Yiisu ŋa kara. ");
INSERT INTO tyx_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilate átumu basono bisono mu mana baya ya batwulu lo ŋa yulu a kuruwa. Bu me bu básono: «Yiisu musi Nadzarete, mukogho a ba-Dzwife.» ");
INSERT INTO tyx_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ba-Dzwife balagha báakataã bisono bibye, mu kuulu ebini ki bákomo Yiisu ŋa kuruwa éli be-bele ya bvulu. Ya básono bisono bibye mu Eebele, mu Latẽ ya mu Engereke. ");
INSERT INTO tyx_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bakwuru ba bangaa ba Nzaami báyilyele kundaa Pilate ti: «Banyaã osono ti “mukogho a ba-Dzwife”, lo basono ti: “mbwuru wu aalyele ti: Me ndi mukogho a ba-Dzwife.”» ");
INSERT INTO tyx_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate ábvuhulu bo ti: «Mamo ma aansono me, mafaana okala bwunu.» ");
INSERT INTO tyx_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Bambumbulu bu bamana okomo Yiisu ŋa kuruwa, bágwolo binkuru bi nde ya báti bye makaba mana, nswe mbwuru ya kaba li nde. Bo bágwolo enkuru e nde ki ela ki baakalaha ŋa yulu, ki bágwene obaama. Kye éli mu nkpaã mõ obaana ku yulu tee ku nsie. ");
INSERT INTO tyx_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bambumbulu bábili bo-a-bo ti: «Linyaã okaghala kye! Litswe lita empa kii nga a bwehe me wu aagwolo mu osuolo wu aagwolo kye». Obo bu ókeele mandagha ma básono mu Mukaana a Nzaami: «Bo baakaba binkuru bi me, ya enkuru e me ki ela ki baakalaha ŋa yulu, bo baati kye empa kii nga a bwehe me wu aagwolo». Obo me bu ósi bambumbulu. ");
INSERT INTO tyx_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ngughu a nde, naana a ngughu a nde, Mari mukala a Kolopase ya Mari musi Mangadala bátemene ŋa bele a kuruwa li Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yiisu bu amono ngughu a nde ŋa bele a enduono ki ákadzyi nde ku olagha, ályele kundaa ngughu a nde ti: «Maama, mono mwana a we.» ");
INSERT INTO tyx_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ŋa nseele nde ályele kundaa enduono ndiri: «Mono ngughu a we.» Ya obaana tala lilo, enduono ekye égwolo nde mu okala mu nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ŋa nseele, mu kuulu Bisono bi Nzaami bikeele, Yiisu bu asoolo ti mandagha mwohono maakughu, ályele bu: «Me ndi a nyoro». ");
INSERT INTO tyx_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Oŋo óli a mfulu yi alwulu mu mala mama ŋeẽ. Bambumbulu bágwolo nsana, bábvwighi yo mu mala mama ŋeẽ, bákuru yo ku nto a muti wu a nkwumu a idzope ya bási yo ŋa muŋma a Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Bu aŋmi mala mama ŋeẽ, Yiisu ályele ti: «Myehene miikughu!» Ya, bu apfumunu busu ku nsie, nde átaghaba. ");
INSERT INTO tyx_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lo, buulu ekye éli etsughu ki ekatswama nsomo a etsughu kii sabate, bamfumu ba ba-Dzwife ka bákadzyi o ti bibyimi bikala ŋa makuruwa tee mu etsughu kii sabate. Etsughu e sabate ekye éli etsughu ki enene. Mu obo, bo báluomo kundaa Pilate babogholo bo myili ya bamaha bo ŋa makuruwa. ");
INSERT INTO tyx_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Bambumbulu bágyi, bábogholo myili mi babo ba bákomo ŋa makuruwa ebini emõ ya Yiisu, mimi mbwuru wu a nsomo ya mimi wu a buolo. ");
INSERT INTO tyx_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bo bu bato ŋa ndaa Yiisu, bámono ti nde ali ayi ákpi. Mu obo, bo ka bábogholo nde myili o. ");
INSERT INTO tyx_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lo mbumbulu mumõ átobolo Yiisu libee mu lisuo, makili ya madza mápala mu nde. ");
INSERT INTO tyx_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mbwuru wu áamono mandagha mamõ, me nde li mu okalyele mo, ya bumpughulu bu nde buli bubu ngaŋma. Nde soolo ti nde engaŋma asuo, mpaala behe si lisa kana. ");
INSERT INTO tyx_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mandagha mwohono ma mámoŋono mu kuulu Bisono bi Nzaami bibikeele: «Ka akala babogholo muwehe a nde si mumõ o.» ");
INSERT INTO tyx_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Óli si ya ndagha nkimi mu Bisono bi Nzaami yi aakalyele bu: «Bo sa batala kundaa munde wu bátobolo bo libee.» ");
INSERT INTO tyx_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ŋa mbihi oŋo, Dzodzefe musi Arimate, áluomo muswa kundaa Pilate mu omaha nyuru a Yiisu ŋa kuruwa. Mu nkooro a nzalamweẽ a bamfumu ba ba-Dzwife, nde áli enduono e Yiisu mu ensweghe. Pilate ágwi nde muswa, ya Dzodzefe áyimaha nyuru a Yiisu ŋa kuruwa. ");
INSERT INTO tyx_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodeme munde wuulu áli áyimono Yiisu mu mpyibi ágyi ya nde. Nde áyabiri mananaase mama miire ma bábvughu ya alowese. Mo máli ku bele bakilo makwumu-matere (30). ");
INSERT INTO tyx_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bo bágwolo nyuru a Yiisu, bádzyi yo mu bisili, bási mansagha mu mananaase, ti bwunu a bu ókadzyighi ba-Dzwife bamvwumu. ");
INSERT INTO tyx_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ŋa ebini ki bákomo Yiisu ŋa kuruwa óli ya ebwa. Munsa ebwa ekye óli a mpyeme yi nyaghara yiili nkini ka bálo mbwuru omo o. ");
INSERT INTO tyx_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Me munsa omo bo bátwulu ebyimi e Yiisu, mu kuulu mpyeme oyo áli yibehene ya ŋa báli bo. Ya mu kuulu ekye éli si etsughu ki ékatswama nsomo a etsughu kii sabate li ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mu etsughu kii limiŋi, mu minkya-nkya, ŋaala bwihi nkini ogyaghala we, Mari musi Mangadala ágyene ku mpyeme. Nde ámono ti limeẽ li líkakyi mpyeme baamaha. ");
INSERT INTO tyx_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nde ábara ntyini, áyibagha Simõ-Piere ya enduono ki eke, ki ókadzyi Yiisu, ya ályele kundaa bo ti: «Baamaha Mfumu munsa mpyeme, ya bihi ka lisoolo ku baayitwulu nde o.» ");
INSERT INTO tyx_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piere ya enduono ki eke bábulupala ya bágyene ku mpyeme. ");
INSERT INTO tyx_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bo bansa buolo bákabara ntyini ŋa emõ, lo enduono ki eke éluru Piere mu ntyini ya kye éyito nsomo ku mpyeme. ");
INSERT INTO tyx_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kye égyimini munsa mpyeme ya émono bisili bi áli bádzyi Yiisu ŋa nsie, lo kye ka ésomo omo o. ");
INSERT INTO tyx_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simõ-Piere wu áakayanama nde bu ayato, ásomo munsa mpyeme. Nde ámono bisili bi áli bádzyi Yiisu oŋo ");
INSERT INTO tyx_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ya mupa eko wu áli bádzyi nde mu mutswi. Mupa eko munde ka áli ebini emõ ya bisili o, lo bágyighili ofughuru nde mu libee, ŋa ebini ekimi. ");
INSERT INTO tyx_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Me oŋo enduono ki éyato nsomo ésomo munsa mpyeme si. Nde ámono ya ási kana. ");
INSERT INTO tyx_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mu kuulu, bo áli nkini ka bákabaghala Bisono bi Nzaami o, bi biikalyele ti Yiisu faana osighili ŋa kara li ba bákpi. ");
INSERT INTO tyx_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ŋa mbihi oŋo, binduono bibye bíbvughuru ku bíkakala bye. ");
INSERT INTO tyx_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mari ali ásyili ku mbala ŋa bele a mpyeme, mu okalili. Kunsa elili, nde ápfuŋumu ya ákagyimini munsa mpyeme. ");
INSERT INTO tyx_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nde ámono bangye-yulu buolo ba bálaha binkuru bibi buŋu, ba bábwi nsini ŋa ebini ki áli bátwulu nyuru a Yiisu, mumõ ku mutswi, wu muke ku myili. ");
INSERT INTO tyx_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bo báfwulu nde ti: «Mukaha, mu emakye we li mu okalili?» Nde ábvuhulu bo ti: «Baamaha Mfumu a me, ya me ka nsoolo ku baayitwulu nde o.» ");
INSERT INTO tyx_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bu amana obili obo, nde ákaghala ya ámono Yiisu átemene oŋo, lo nde ka ákasoolo o ti munde me Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yiisu áfwulu nde ti: «Mukaha, mu emakye we li mu okalili? Nande we li mu okasagha?» Mari bu ákatsimi ti munde áli mbwuru wu aakasala munsa ebwa, ályele nde ti: «Mfumu! Kala ti we aamaha nde lyele me ku aatwulu we nde, ya me sa yingwolo nde.» ");
INSERT INTO tyx_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yiisu áti nde mbili ti: «Mari!» Mari áfirikaghala ya ályele nde mu ndiŋi yi a Eebele ndiri: «Rabuni!» Mbaala ti, «Muluo». ");
INSERT INTO tyx_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yiisu ályele nde ti: «Ka kwara me o, mu kuulu me nkini ka aankumu kundaa Taara a me o. Lo we gye yilyele kundaa baana ba taara a me ti me ndi mu okumu kundaa Taara a me wu li Taara a behe si, kundaa Nzaami a me wu li Nzaami a behe si.» ");
INSERT INTO tyx_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mu obo, Mari musi Mangadala áyilyele binduono ti: «Me aamono Mfumu!» Ya nde átuoho kundaa bo mandagha mwohono ma ólyele nde Yiisu. ");
INSERT INTO tyx_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mu nkonkolo yi a etsughu kyini ekye, etsughu kii limiŋi, binduono bi Yiisu áli bibvuŋunu munsa nzo. Mu nkooro a nzalamweẽ a bamfumu ba ba-Dzwife, bo bágyighili okuru muŋma a nzo. Lo Yiisu ágyi, áteme ŋa kara li bo ya ályele bo ti: «Nyaã edzuunu ekala ya be.» ");
INSERT INTO tyx_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bu amana obili obo, nde ásuo bo myaã ya libee li nde. Binduono bu bimono Mfumu, bíli kunsa a esee. ");
INSERT INTO tyx_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Mu obo, Yiisu áfirilyele bo ti: «Nyaã edzuunu ekala ya be! Ti bwunu a bu ógweghe me Taara, mehe si ngweghe be.» ");
INSERT INTO tyx_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Bu abili obo, nde áfulu muwuele ŋa yulu a bo ya ályele bo ti: «Ligyagha Mufulu a Ngili. ");
INSERT INTO tyx_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Babo baliisa be masumu ma bo kolokolo, sa basa bo mo kolokolo. Babo baliibihi be masumu ma bo osa kolokolo, ka basa bo mo kolokolo o.» ");
INSERT INTO tyx_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma, wu bákata ti mbu, mumõ mu binduono kwumu ya byele (12), ka áli ya bo o mu matala ma ómoŋono Yiisu kundaa bo. ");
INSERT INTO tyx_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mu obo, binduono bibike bílyele nde ti: «Bihi liimono Mfumu!» Lo nde ábvuhulu bo ti: «Kala ti me ka mono bilyimi bibi mansere mu myaã mi nde o, kala ti me ka nsohobo mulyeme mu mambaala mamo o, ya kala ti me ka nsi ekee ŋa libee li nde o, me ka nsa kana ti nde li mweẽ o!» ");
INSERT INTO tyx_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ŋa mbihi a bitsughu mpuomo, binduono bífiribvuŋunu munsa nzo, ya Toma áli ya bo. Bo áli bágyighili okuru bidzughubu byehene, lo Yiisu ágyi, átemene ŋa kara li bo ya ályele bo ti: «Nyaã edzuunu ekala ya be!» ");
INSERT INTO tyx_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ŋa mbihi, nde ályele Toma ndiri: «Gya, lo mulyeme a we ŋa, ya mono bikee bi me. Gya a ekee e we ya sa kye ŋa libee li me. Nyaã mikeme ya sa kana!» ");
INSERT INTO tyx_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma ábvuhulu nde ti: «We li Mfumu a me ya Nzaami a me!» ");
INSERT INTO tyx_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yiisu ályele nde ti: «We busi kana bu mono me! Esee kundaa babo baala ka baamono o lo baasi kana!» ");
INSERT INTO tyx_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yiisu áfirisa bilyimi bibi okiŋimi bilagha ŋa mihi mi binduono bi nde biili ka básono bye mu mukaana wu o. ");
INSERT INTO tyx_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Lo mandagha ma, básono mo mu kuulu be lisa kana ti Yiisu li Kriste, Mwana a Nzaami, ya mu kuulu, bu lisi kana, be libagha laama mu nkwumu a nde. ");
INSERT INTO tyx_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ŋa mbihi oŋo, Yiisu áfirimoŋono kundaa binduono mu mukogho a mubu wu a Tiberyade. Bu me bu ámoŋono nde. ");
INSERT INTO tyx_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simõ-Piere, Toma wu baakata ti Mbu, Natanayele wu a bvulu lili Kaana mu Ngalile, baana ba Dzebede ba babaghala ya binduono byele bikimi, báli emõ. ");
INSERT INTO tyx_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simõ-Piere ályele bo ti: «Me ngyene ku osyama banswi.» Bo bályele nde ti: «Bihi si, ya we liigye.» Bo bápala ya básomo mu bwara. Lo mu mpyibi oyo, bo ka bábagha si nswi mumõ o. ");
INSERT INTO tyx_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mu minkya-nkya, Yiisu ágyi ya átemene ŋa mukogho a mubu, lo binduono ka bíkasoolo o ti nde áali. ");
INSERT INTO tyx_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yiisu áfwulu bo ti: «Baana ba me! Be ka lili a nswi wu odza o?» Bo bábvuhulu nde ti: «Pele!» ");
INSERT INTO tyx_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nde ályele bo ti: «Litubu likoho ku ngulu yi a kwogho kii babaghala yi a bwara ya be sa libagha banswi.» Mu obo, bo bátubu likoho, ya ka bákaleene opaha lo mu madza o, mu kuulu banswi ba bákogholo áli balagha. ");
INSERT INTO tyx_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Enduono ki ókadzyi Yiisu ku olagha élyele Piere ti: «Munde me Mfumu!» Simõ-Piere bu agyughu ti munde me Mfumu, ásyere mu bala enkuru e nde kii ŋa yulu ki áli amaha nde, mu kuulu nde áli mpene, ya ábwi mu madza. ");
INSERT INTO tyx_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Binduono bibike bíyabvughuru ya bwara ku mukogho a madza, ya bákayadzuru likoho li lílwulu mu banswi, mu kuulu bo ka báli la ya mukogho a madza o, yini a ku bele a mankpaã nkama (100). ");
INSERT INTO tyx_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bo bu bapala mu bwara, bámono ŋa ebini ekye mbaa yi makala, nswi ŋa yulu a mo ya limpa. ");
INSERT INTO tyx_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yiisu ályele bo ti: «Ligya a ndaama a banswi mu babo ba liibagha be.» ");
INSERT INTO tyx_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simõ-Piere áfirikumu munsa bwara ya ádzuru likoho ŋa nsie. Likoho áli lilwulu mu banswi, nkama ya makwumu-mataana ya batere (153) ma banswi ba banene. Lo, si buulu ti banswi áli balagha, likoho ka líkagha o. ");
INSERT INTO tyx_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yiisu ályele bo ti: «Liyadza». Enduono si emõ ka ébagha bukyini o mu ofwulu nde ti «We nande li?» Mu kuulu bo bákasoolo ti nde me Mfumu. ");
INSERT INTO tyx_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yiisu ásele ŋa báli bo, ágwolo limpa ya ágwi bo lo, nde ási bwunu obo si mu nswi. ");
INSERT INTO tyx_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Lilo líli sa lili tere li óyamoŋono Yiisu kundaa binduono bi nde, ŋa mbihi a ŋa ásighili nde ŋa kara li ba bákpi. ");
INSERT INTO tyx_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bo bamana odza, Yiisu áfwulu Simõ-Piere ti: «Simõ, mwana a Dzã, we dzyi me ku obvulu babake ba?» Nde ábvuhulu nde ti: «Eẽ, Mfumu, we soolo ti me ndzyi we.» Mu obo Yiisu ályele nde ti: «Kebe baana ba bindoomo ba me.» ");
INSERT INTO tyx_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mu sa lili ywolo, Yiisu áfirifwulu Piere ndiri: «Simõ, mwana a Dzã, we dzyi me?» Piere ábvuhulu nde ti: «Eẽ, Mfumu, we soolo ti me ndzyi we.» Yiisu ályele nde ti: «Kala munkaala bindoomo bi me.» ");
INSERT INTO tyx_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mu sa lili tere, Yiisu áfirifwulu Piere ti: «Simõ, mwana a Dzã, we dzyi me?» Piere ányoõ mu kuulu Yiisu áfwulu nde mu sa lili tere ti: «We dzyi me?» Ya nde ábvuhulu ti: «Mfumu, we wu soolo mandagha mwohono, we gyighili osoolo ti me ndzyi we.» Yiisu ályele nde ti: «Kebe bindoomo bi me. ");
INSERT INTO tyx_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mu engaŋma me ndyele we ti: ŋa áli we munkuru-mbala, we áakakuru musyi a bala a we weme ya áakagye ku ákadzyi we. Lo ŋa akala aaŋmini we, we sa gyala myaã ya mbwuru mukimi akala aakuru we musyi a bala, ya obiri we ku akala aagwene dzyi we.» ");
INSERT INTO tyx_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yiisu ábili obo mu osuo bu akala lipfu li Piere liigwa Nzaami nsia. Ŋa mbihi oŋo, Yiisu ályele nde ti: «Nama me.» ");
INSERT INTO tyx_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piere bu akaghala ku mbihi, ámono enduono ki ókadzyi Yiisu mu okayanama bo. Me nde áli aasiŋi ŋa etulu e Yiisu, ŋa bákadza bo, ya ályele ti: «Mfumu, na munde aatyeghe we?» ");
INSERT INTO tyx_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piere bu amono nde, áfwulu Yiisu ti: «Mfumu, nde bunu akala aabwana?» ");
INSERT INTO tyx_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yiisu ábvuhulu nde ti: «Kala me ndzyi ti nde akala mweẽ tee mu matala ma aayamvughuru me, ŋana yitala we? We, nama me!» ");
INSERT INTO tyx_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mu ndagha oyo, nsia yitsaŋama ŋa kara li binduono ti enduono ekye ka ekpa o. Mu engaŋma Yiisu ka ályele Piere o ti Dzã ka akpa o, lo nde ályele bu: «Kala me ndzyi ti nde akala mweẽ tee mu matala ma aayamvughuru me, ŋana yitala we?» ");
INSERT INTO tyx_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Me enduono ekye kyeme eli mu osuo bumpughulu mu mandagha mamo mwohono ya aasono mo, ya bihi lisoolo ti bumpughulu bu nde buli bubu ngaŋma. ");
INSERT INTO tyx_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yiisu áfirisa mandagha ma malagha makimi. Kala ti ali basono nsyini-nsyini mu mõ, me aantsimi ti, nkini nsie nsyini ka yikaabagha ebini o kii otwulu mikaana myehene mimye mi bakaasono.");
INSERT INTO tyx_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ndughu a me Tofile, mu mukaana a me wu a nsomo, me aandyele mandagha mwohono ma óbaana Yiisu osa ya oluo, ");
INSERT INTO tyx_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tee mu etsughu ki áseŋene nde mu okumu ku yulu, ŋa mbihi a ŋa ámana otswa nde mikele mu Mufulu a Ngili, kundaa bantumu ba ásuolo nde. ");
INSERT INTO tyx_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ŋa mbihi a mpara yi ámono nde, nde ákamoŋono kundaa bo ya mu bilyimi bilagha, nde ákasuo kundaa bo ti nde li mweẽ. Mu bitsughu makwumu-mana (40), nde ákabulumoŋono kundaa bo ya ákabulubili mu mi mitala Empu e Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Etsughu nga-emõ, nde bu ákadza emõ ya bo, nde átswi bo mukele wu: «Ka limara mu Yerusaleme o, lo likebe mi oosiini a be Taara, mimye mi liigyughu be kundaa me ");
INSERT INTO tyx_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ti: Dzã aaboghoro mu madza, lo be, mu mana bitsughu sa baboghoro be mu Mufulu a Ngili.» ");
INSERT INTO tyx_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Obo me buulu, babo ba bábvuŋunu, báfwulu kundaa nde ti: «Mfumu, ngu mu matala ma we aabvurulu Emfumu e Isarayele?» ");
INSERT INTO tyx_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nde ábvuhulu kundaa bo ti: «Ka yili ndagha a be o mu osoolo matala ya ena bi ókuru Taara mu litumu li ndeme, ");
INSERT INTO tyx_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","lo be sa ligyagha lileene ŋa akala oogya Mufulu a Ngili mu be, ya be sa likala bampughulu ba me mu Yerusaleme, mu Yude lwohono, mu Samari, tee ku osughu nsie.» ");
INSERT INTO tyx_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Bu amana obili obo, nde áseŋene mu okumu ku yulu ŋaala bo bwohono mu okamono nde, ya edzi éfughu nde ŋa mihi mi bo. ");
INSERT INTO tyx_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ŋaala bo áli nkini mu okatala ku yulu, ku ákagye nde, babaghala buolo ba bálaha binkuru bi bipeŋeme bágyi ŋa bele a bo, ");
INSERT INTO tyx_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ya bályele kundaa bo ti: «Basi Ngalile, mu emakye be liitemene oŋo mu okatala ku yulu? Yiisu wu, wu oogyene a Nzaami ku yulu ŋa mihi mi be, sa ayabvughuru si ti bwunu a bu liimono be nde mu ogye ku yulu.» ");
INSERT INTO tyx_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mu obo, bantumu bábvughuru ku Yerusaleme, obaana ku Munguo wu a mi-Olibve, wu li ŋa bele a Yerusaleme, mu etiiri ki bágwi muswa mu odzyara etsughu kii Sabate. ");
INSERT INTO tyx_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bo bu bayabvughuru, básomo mu ngwumu yi a ku yulu, omo mu báli a bo epfu ki okabvuŋunu. Mu bo óli a Piere, Dzã, Dzake ya Andere, Filipe, Toma, Baretelemi, Matye, Dzake mwana a Alafe, Simõ mu-Nzelote ya Yuda mwana a Dzake. ");
INSERT INTO tyx_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bo bwohono babo, bási mukama mu mukolo mumõ mu okasamana, emõ ya bakaha, ya Mari ngughu a Yiisu, ya bambwee ba Yiisu ba babaghala. ");
INSERT INTO tyx_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mu bitsughu bibye, mpwumu a banga-a-kana yi áali ŋa ebini ekye yíli ku bele a nkama ya makwumu-muolo (120) ma baara. Piere átemene ŋa kara li bo ya ályele ti: ");
INSERT INTO tyx_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Baana ba taara a me, áli bubwe ti, mandagha ma áli olyele Mufulu a Ngili mu Mukaana a Nzaami mu muŋma a Dabvide mu nkooro a Yuda makeele, nde wu ákighiri mumbiri a babo ba básyimi Yiisu. ");
INSERT INTO tyx_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nde aali mumõ ŋa kara li bihi, ya nde aabagha kaba lili esala ki. ");
INSERT INTO tyx_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nde bu abagha mufuru wuulu ka li wu a nsumu o, nde swumu nseghe. Nde aabwi kii mapfumunu, bala li nde liibughulu ya biini bi nde biitsaŋama. ");
INSERT INTO tyx_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ya baara bwohono baba Yerusaleme basoolo ndagha oyo. Mu obo, bo baakata nseghe oyo mu ndiŋi yi bula bu bo ti: “Akeledama”, mbaala ti, “nseghe yi makili”. ");
INSERT INTO tyx_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ankoho, básono mu mukaana wu Bikwumu ti: “Nyaã nzo a nde yikala mukaŋana, ya mbwuru anyaã okala munsa yo!”» «Ya báfiri sono ti: “Nyaã mbwuru mukimi asala esala e nde”.» ");
INSERT INTO tyx_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Mu obo, bafaana osuolo mbwuru mukimi ŋa kara li baara ba bákabulugye ya bihi, mu matala mwohono maala Mfumu Yiisu ákabulugye ŋa kara li bihi, ");
INSERT INTO tyx_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","obaana ŋa óboghoro nde Dzã, tee mu etsughu ekye ki bámaha nde ŋa kara li bihi. Mbwuru munde, emõ ya bihi, faana okala mpughulu mu osighili o Yiisu ŋa kara li ba bákpi.» ");
INSERT INTO tyx_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Básuo baara buolo: Dzodzefe wu bákata Barasabase, wu bálughu Yusutuse, ya Matiase. ");
INSERT INTO tyx_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ya bo bwohono básamana ya bályele ti: «Mfumu, we wu soolo mikolo mi baara bwohono, suo bihi mu bo bansa buolo ba, nande we áasuolo, ");
INSERT INTO tyx_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mpaala agwolo ebini mu esala ki buntumu ki, ki oosihi Yuda mu ogye ku ebini kii ndaa nde.» ");
INSERT INTO tyx_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ŋa nseele, bo báti empa kiili nga-a-bwehe me wu aagwolo, ya eti ébwi ŋa ndaa Matiase, ya básohobo nde mu kaba li bantumu kwumu ya mumõ (11). ");
INSERT INTO tyx_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Etsughu kii Pantekote bu eto, bo bwohono bábvuŋunu ŋa ebini emõ. ");
INSERT INTO tyx_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ya ensihibi, nkele yífi ku yulu ti anga nkele a efulu kii mpini, yíluhu nzo yohono mu bábwi bo nsini. ");
INSERT INTO tyx_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bo bámono manzalisogho mu efaana ki mile mi mbaa, mi míkakaghaba ya míkabwa ŋa yulu a nswe mbwuru mu bo. ");
INSERT INTO tyx_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bo bwohono bálwulu mu Mufulu a Ngili ya bábwi obili mu mandiŋi makimi, bwunu a bu ókatumu bo Mufulu obili. ");
INSERT INTO tyx_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ankoho ku Yerusaleme óli a ba-Dzwife ba bali a enzaama kii ngaŋma, baara ba báfi mu bitsulu bi mansie byehene. ");
INSERT INTO tyx_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bu bagyughu nkele oyo, bo bábvuŋunu mu mpwumu, ya bo bwohono bákiŋimi ku olagha, mu kuulu nswe mbwuru ákagyughu bo mu okabili mu ndiŋi a ndeme. ");
INSERT INTO tyx_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bo bákiŋimi ku olagha, bágwuu ya bákalyele ti: «Bunu, baara bwohono ba bali mu okabili ba, bo ka bali baara ba etsulu e nsie kii Ngalile o? ");
INSERT INTO tyx_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Lo bunu-a-bo mbwuru-mbwuru mu bihi ali mu okagyughu bo mu okabili mu ndiŋi yi bula bu nde? ");
INSERT INTO tyx_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ŋa kara li bihi oli a baara ba nsie yi a ba-Parete, nsie yi a Mede, nsie yi a Elame ya ba baakakala ku Medzopotami, ku Yude, ku Kapadose, ku Põ ya ku Adzi, ");
INSERT INTO tyx_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ku Firingi, ku Pamfili, ku Edzipite ya ba bali mu bitsulu bi nsie bibi ku Libi lili Sirene ya ba bali ku bvulu lili Rome, ");
INSERT INTO tyx_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ba-Dzwife ya baara ba básomo Nzaami a bo, basi Kerete ya basi Arabi, bihi lili mu okagyughu bo mu okabili mu mandiŋi ma bihi, bigyighili bi Nzaami bi binene!» ");
INSERT INTO tyx_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bo bwohono bágwuu ya mayele máfi bo, bákalyele bo-a-bo ti: «Bu yi ma?» ");
INSERT INTO tyx_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lo babake bákasa bo munsensehẽ ya bákalyele ti: «Buta mala baakolo!» ");
INSERT INTO tyx_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mu obo, Piere átemene ya bantumu kwumu ya mumõ (11), ábili mu likyi lili mpini kundaa mpwumu ya ályele kundaa bo ti: «Basi Yude, ya be bwohono ba lili ŋa Yerusaleme, ligyughu mandagha ma aandyele me, libaghala ti, ");
INSERT INTO tyx_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","baara ba ka mala baakolo o ti bu lili mu okatsimi be, mu kuulu, li nkini tala lili wa mu epala. ");
INSERT INTO tyx_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Lo bu me bu oli mu okeele ndagha yi ólyele mubighili Dzowele.» Nde ályele ti: ");
INSERT INTO tyx_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«Mu bitsughu bibi masini, bu ólyele Nzaami, me sa nsurulu Mufulu a me ŋa yulu a mbwuru-mbwuru, ya baana ba be ba babaghala ya baba batughu sa babighili, Nzaami sa asa kuulu ti bampala ba be bamono mandagha ma manyaghara ya biŋmini bi be sa biluoro manzolo. ");
INSERT INTO tyx_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Eẽ, mu bitsighu bibye, me sa nsurulu Mufulu a me ŋa yulu a basala ba me baba babaghala, ya baba bakaha. Ya bo sa bakala mibighili, ");
INSERT INTO tyx_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ku yulu me sa ngyighili mandagha mama okiŋimi mu yulu, ya ku nsie bilyimi bibi mpaana ŋa yulu nsie: Makili, mbaa ya bidzi bibi lwuu. ");
INSERT INTO tyx_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tala sa likighiri mpyibi, ya ngoono sa abie ti makili. Myehene mimye sa mimoŋono nsomo ya ogya ku etsughu e Mfumu, etsughu ki enene ya kii nsia. ");
INSERT INTO tyx_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Oŋo nswe munde wu akala aataŋana nkwumu a Mfumu sa abvwughu.» ");
INSERT INTO tyx_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Basi Isarayele, ligyughu mandagha ma: Yiisu wu a ku Nadzarete, mbwuru munde wu oosuo Nzaami kundaa be mu bimaã, mandagha mama okiŋimi ya mu bilyimi bi ási nde ŋa kara li be, ti bwunu a bu lisoolo be beme yo, ");
INSERT INTO tyx_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","mbwuru munde, wu bátyeghe ti bwunu a bu oli bitsimi bi otswama ogyahaba Nzaami, be liigwi nde ŋa myaã mi baara ba bagwene osoolo Nzaami, ba baadzwi nde bu baakomo nde ŋa kuruwa. ");
INSERT INTO tyx_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lo Nzaami aasiili nde, bu aakwulu nde mu mpara a lipfu, buulu ka okughu okala o ti lipfu lidzarala nde. ");
INSERT INTO tyx_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mu kuulu, mu nde Dabvide ályele ti: Mu nswe matala, me áakamono Mfumu ŋa nkulu a me, nde li ŋa kwogho e me kii babaghala, mpaala me nyaã otighiri mu nzalamweẽ.» ");
INSERT INTO tyx_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","«Me mu obo mukolo a me ali kunsa esee, muŋma a me aalwulu mu munyuŋu ya nyuru a me yili kunsa emiini, ");
INSERT INTO tyx_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","mu kuulu we ka nyaghala muwumunu a me ku nsie a ba bákpi o, we ka nyaã wu a we Wu a Ngili abolo o. ");
INSERT INTO tyx_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","We aasuo me mankwulu mama laama, we buli ŋa nkulu a me, we sa luhu me mu esee.» ");
INSERT INTO tyx_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Baana ba taara a me, linyaã me bu ndi a muswa, me ndyele be mu kana lwohono mi mitala nkagha-kwuru Dabvide ti: nde ákpi, bádzyighi nde, ya mpyeme a nde yili tee lolo ŋa kara li bihi-a-be . ");
INSERT INTO tyx_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Lo nde áli mubighili ya nde ásoolo ti mu mukihi, Nzaami ágwi misiini kundaa nde ti mumõ mu bateghele ba nde sa akiri ŋa likubu li nde. ");
INSERT INTO tyx_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Mu limono, Dabvide bu átswama otaala mi mitala osighili o Kriste ŋa kara li ba bákpi, nde ályele ti: “Ka baanyaghala nde ku nsie a ba bákpi o, ya ka baanyaã nyuru a nde yibolo o.” ");
INSERT INTO tyx_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Me Yiisu munde Nzaami aasiili ŋa kara li ba bákpi, ya bihi bwohono lili bampughulu mu ndagha oyo. ");
INSERT INTO tyx_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nzaami bu aakuhubu Yiisu ku kwogho e nde kii babaghala, Yiisu aagyagha kundaa Taara Mufulu a Ngili wu áli bagwi misiini, ya nde aasurulu nde ŋa yulu a bihi. Mimye me mi lili mu okamono ya lili mu okagyughu be lolo li. ");
INSERT INTO tyx_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mu kuulu, Dabvide ndeme ka ákumu ku mayulu o, lo nde ályele ti: “Mfumu aalyele kundaa Mfumu a me ti: Yabwa-nsini ku kwogho e me kii babaghala, ");
INSERT INTO tyx_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tee mu matala ma akala aansa me mitaara mi we mikala edzyara e myili mi we.” ");
INSERT INTO tyx_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Nyaã ti basi Isarayele bwohono bagyighili osoolo mu ngaŋma ti: Nzaami aasi ti Yiisu wu liikomo be ŋa kuruwa akala Mfumu ya akala Kriste!”» ");
INSERT INTO tyx_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","«Bu bamana ogyughu mandagha mamo, mikolo mi bo mídzwala, ya bályele kundaa Piere ya kundaa bantumu ti: “Baana ba taara, emakye bihi lifaana osa?”» ");
INSERT INTO tyx_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piere ábvuhulu kundaa bo ti: «Ligyiŋi mayele ya baboghoro nswe mbwuru mu be mu nkwumu a Yiisu-Kriste. Mpaala Nzaami asa masumu ma nde kolokolo ya be sa ligyagha kaba li Mufulu a Ngili. ");
INSERT INTO tyx_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mu kuulu misiini mi, Nzaami ási mye kundaa be, kundaa baana ba be ya kundaa babo ba bali ku la, bo bwohono ba akala oota Mfumu Nzaami a bihi mbili.» ");
INSERT INTO tyx_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mu mandagha makimi ma malagha, Piere ákapeene a bo ya ákagwa bo mpama, ŋa ákalyele nde kundaa bo ti: «Ligyagha obvwughu ya be sa lipala mu eseene ki ebi ki!» ");
INSERT INTO tyx_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ya babo ba bákihi mandagha ma nde, báboghoro bo, ya mu etsughu ekye, ba báyasomo mu kaba li ba bákasa kana, báli ku bele a mapfwunu-matere (3 000) ma baara. ");
INSERT INTO tyx_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bo bwohono bási mukama mu maluo ma ókaluo bantumu, mu okala ti baana baba taara mumõ, mu okakaba limpa ya mu okasamana Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nswe mbwuru áli a nzalamweẽ, mu nkooro a mandagha mama okiŋimi ya bilyimi bi bilagha bi ókasa bantumu. ");
INSERT INTO tyx_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Babo bwohono ba bási kana báli bumõ, ya byehene bi báli a bye, bíli bibi ebvughu. ");
INSERT INTO tyx_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bo bákatyeghe mansie ma bo ya byehene bi báli a bye, ya bákakaba nzi kundaa baara bwohono, bwunu a bu óli nzala a nswe mbwuru. ");
INSERT INTO tyx_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nswe etsughu mu mukama, bo bákagwihini mu okagye ku nzo a nzaami, mu okakaba limpa munsa manzo, ya bákadza bilogho bi bo mu esee ya mu mukolo wu okughulu. ");
INSERT INTO tyx_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bo bákasyighi Nzaami ya baara bwohono bákasuo bubwe kundaa bo. Ya nswe etsughu, Mfumu ákabwehe mu kaba li bo, ba bákabvwughu. ");
INSERT INTO tyx_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Etsughu nga-emõ, Piere ya Dzã bákakumu ku nzo a nzaami mu oyisamana, mu tala lili matere ŋa mbihi a embehe. ");
INSERT INTO tyx_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Oko, nswe etsughu, baara bákagya a baghala mumõ wu báburu ekara, ya bákatwulu nde ŋa muŋma a nzo a nzaami, wu bákata ti Muŋma a Nzo Wu Mubwe, mu kuulu nde akaluomo nzi kundaa babo ba bákasomo mu nzo a nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nde bu amono Piere ya Dzã ba bákagye mu osomo munsa nzo a nzaami, nde áluomo bo nzi. ");
INSERT INTO tyx_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piere ya Dzã batuunu nde mihi, ya Piere ályele kundaa nde ti: «Tala bihi!» ");
INSERT INTO tyx_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mbwuru munde ágyighili otala bo, ya ákakebe mu ogyagha elogho ki eefa kundaa bo. ");
INSERT INTO tyx_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piere ályele kundaa nde ti: «Me ka ndi a nzi ya oore o, lo ki ndi a me, me ngwi we kye: Mu nkwumu a Yiisu-Kriste musi Nadzarete, temene ya dzyara!» ");
INSERT INTO tyx_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bu akwara nde mu kwogho kii babaghala, átehebe nde. Ŋaana oŋo bitaama bi nde ya maseẽ ma myili ma nde bíbagha mpini. ");
INSERT INTO tyx_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Bu adzuŋumu mankagha, nde átemene ya ábwi odzyara. Nde ásomo ya bo munsa nzo a nzaami, ákadzyara, ákadzuŋumu ya ákasyighi Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Baara bwohono bámono nde mu okadzyara ya mu okasyighi Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ya baara básoolo ti me nde wu áakabwa-nsini ŋa Muŋma a nzo a nzaami wu baakata ti Muŋma wu Mubwe mu okaluomo nzi. Bo bámono nzalamweẽ yi alagha, ya bákiŋimi mu mi míbwi mu nde. ");
INSERT INTO tyx_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Buulu mbwuru munde ka ákanyaã Piere ya Dzã o, baara bwohono bákiŋimi ya bágyi mu ntyini kundaa bo, ŋa eluru kii nzo a nzaami ki baakata ti Eluru kii Salomõ. ");
INSERT INTO tyx_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piere bu ámono obo, nde áfwulu kundaa baara ti: «Basi Isarayele, mu emakye be lili mu okakiŋimi mu ndagha yi? Mu emakye be lili mu okatala bihi ti anga áli mu lileene li bihi bameme, bwunu-we mu enzaami e bihi, bihi liisi kuulu ti baghala wu adzyara? ");
INSERT INTO tyx_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nzaami a Abarahame, a Idzake, a Dzakobe, Nzaami a bankagha ba bihi, aagwi musala a nde Yiisu nsia, nde wu liityeghe be ya wu liibihi be ŋa nkulu a Pilate, wu áamono ti áli bubwe mu onyaã nde. ");
INSERT INTO tyx_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Be liibihi Wu a Ngili ya Wu bunsumu, ya be liiswolo banyaã be wu aakadzwa baara. ");
INSERT INTO tyx_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Be liidzwi Mfumu a bumweẽ. Lo Nzaami aasiili nde ŋa kara li ba bákpi. Bihi, bihi lili bampughulu mu ndagha oyo. ");
INSERT INTO tyx_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Me mu lileene li nkwumu a Yiisu, mu nkooro a kana mu nde, baghala wu lisoolo ya wu lili mu okamono be wu, aabagha mpini. Me kana mu Yiisu liisi ti nde asaadzughu, bwunu a bu likughu omono be bwohono nde.» ");
INSERT INTO tyx_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Mu obo, baana ba taara a me, me nsoolo ti kunsa odzimini be ya bamfumu ba be liigyighili mandagha mamo. ");
INSERT INTO tyx_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mandagha ma ótswama olyele Nzaami mu miŋma mi mibighili myehene maatswighi. Mandagha mamo me ma: “Kriste a nde sa akala amono mpara”. ");
INSERT INTO tyx_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mu obo, ligyiŋi mayele, libvughuru kundaa Nzaami, mu kuulu nde amaha masumu ma be, ");
INSERT INTO tyx_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ya mu kuulu matala ma ogwumu ma oogwi Mfumu magya, ŋa akala aagweghe nde Yiisu, Kriste munde wu átswama osuolo nde mu be. ");
INSERT INTO tyx_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Lo mu matala ma, nde faana okala ku yulu, tee mu matala ma akala oobvurulu Nzaami bilogho byehene, ti bu ályele nde mu miŋma mi mibighili mimi ngili mimi nsi-nkulu. ");
INSERT INTO tyx_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mu kuulu Moyidze ályele ti: “Mfumu Nzaami a be sa apaha mu nkooro a be, ya ŋa kara li ekaana e be mubighili ti anga me. Be lifaana ogyughu mandagha mwohono ma akala aalyele nde be. ");
INSERT INTO tyx_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nswe mbwuru wu akala aagwene ogyughu mubighili munde, sa akala bamaha nde mu ekaana, nde sa akpa.” ");
INSERT INTO tyx_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ya Mibighili myehene, obaana Samwele ya myehene mi mígyi ŋa mbihi a nde, míbili mu mi mitala bitsughu bi. ");
INSERT INTO tyx_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Be, be lili baana ba mibighili ya baana ba ogwihini ku ósi Nzaami ya bataara ba be ŋa ályele nde kundaa Abarahame ti: “Me sa nseme bikaana byehene bibi ŋa yulu a nsie mu nzili a musyi a dzumu li we”. ");
INSERT INTO tyx_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nsomo, mu be Nzaami átehebe musala a nde, wu átswama ogweghe nde mu oseme be, mu kuulu mbwuru-mbwuru mu be asihi bigyighili bi nde bi bibi.» ");
INSERT INTO tyx_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piere ya Dzã báli nkini mu okabili kundaa baara, ŋa ógyi bangaa ba nzaami, mfumu a bankyele ba nzo a nzaami ya ba-Saduseyẽ. ");
INSERT INTO tyx_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bo báli a nkehe mu kuulu Piere ya Dzã bákaluo baara ya bákalyele ti bwunu a bu ósighili Yiisu ŋa kara li ba bákpi, obo si baara ba bákpi akala baasighili mu lipfu. ");
INSERT INTO tyx_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bo básyimi Piere ya Dzã ya bálo bo mu boloko tee mbala, buulu áli ayi nkonkolo. ");
INSERT INTO tyx_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lo mu ba bákagyughu ndagha, balagha áli baasi kana. Ya mutala a bo áli ku bele a mapfwunu-mataana (5 000). ");
INSERT INTO tyx_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mbala, bamfumu ba ba-Dzwife, bakwuru ya baluo-mikyene bábvuŋunu ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mu bo óli a Ane mukwuru a bangaa ba nzaami, Kayife, Dzã, Alekandere ya baara bwohono baba musyi a dzumu li bamfumu ba bangaa ba nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bo bágyi a Piere ya Dzã ŋa nkulu a bo ya báfwulu bo ti: «Mu lileene li nande bwunu we mu nkwumu a nande be liigyighili ndagha yi?» ");
INSERT INTO tyx_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Me mu obo, Piere wu áalwulu mu Mufulu a Ngili, ályele kundaa bo ti: ");
INSERT INTO tyx_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","«Bamfumu ba ekaana ya bakwuru, lolo li bali mu ofwulu bihi mu nkooro a bubwe bu liisi bihi kundaa mbwuru nga a epfwumu, ya bunu-a-bo nde aabvwughu. ");
INSERT INTO tyx_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Be bwohono ya ekaana kyehene kii Isarayele, ligyighili osoolo yo ti, me mu nkwumu a Yiisu-Kriste wu a ku Nadzarete, wu liikomo be ŋa kuruwa ya wu oosiili Nzaami ŋa kara li ba bákpi, me mu nde wu aatemene ŋa nkulu a be wu ali nsiili.» ");
INSERT INTO tyx_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Me Yiisu li: «Limeẽ liili be bantwu manzo, liitsaala, Lo, lo ayi limeẽ lili ngughu ŋa mutswunu.» ");
INSERT INTO tyx_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","«Obvwughu ka oli mu mbwuru mukimi o, mu kuulu ka oli a nkwumu nkimi o ŋa yulu a nsie yi bágwi kundaa baara, yiili mu yo bihi libvwughu.» ");
INSERT INTO tyx_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bo bu bamono kana li Piere ya Dzã, bákiŋimi, mu kuulu bo bábaghala ti baara ba ka báli a mupfunu o, bo ka bágyighi o. Bo básoolo ti bo ba bákakala emõ ya Yiisu. ");
INSERT INTO tyx_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Lo bo bu bamono baghala wu adzughu átemene ŋa bele a bo, bákuono a yi baalyele kundaa Piere ya Dzã. ");
INSERT INTO tyx_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Oŋo bo bágwi litumu bapaha bo ŋa kara li ekwuru ki ba-Dzwife, ya bo-a-bo básyili mu okuru mfwunu, ");
INSERT INTO tyx_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","bákalyele ti: «Emakye liisa mu baara ba? Buulu baara bwohono baba mu Yerusaleme basoolo mu ngaŋma elyimi ki baagyighili bo, ya bihi ka likughu obihi kye o. ");
INSERT INTO tyx_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lo mu osa kuulu ndagha yi yinyaã otsaŋama ku olagha ŋa kara li baara, litswe litswa bo mukele mu ebaghala, banyaã ofiribili mu nkwumu oyo kundaa mbwuru si mumõ.» ");
INSERT INTO tyx_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bu bati bo mbili, bátswi bo mukele mu ebaghala mu onyaã ofiribili ya ofiriluo mu nkwumu a Yiisu. ");
INSERT INTO tyx_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piere ya Dzã bábvuhulu kundaa bo ti: «Lilamana beme: Nsa ndagha yili bunsumu ŋa mihi mi Nzaami, osa litumu li be, bwunu we osa litumu li Nzaami? ");
INSERT INTO tyx_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bihi, ka lileene okuru miŋma mu mandagha ma liimono ya ma liigyughu o.» ");
INSERT INTO tyx_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bo báfiriŋaana bo ya bányaã bo. Bo ka bábagha nzili yi baasyeme bo o, mu nkooro a baara. Mu kuulu baara bwohono bákasyighi Nzaami mu ndagha yi áabwi. ");
INSERT INTO tyx_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Baghala munde wu áadzughu mu elyimi kii okiŋimi ekye, áli aluru bamvulu makwumu-mana (40). ");
INSERT INTO tyx_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bu banyaã bo, Piere ya Dzã bágyene kundaa baba ndaa bo ya bátwoho bo mandagha mwohono ma ólyele bo bamfumu ba bangaa ba nzaami ya ekwuru ki ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Boho si, bu bamana ogyughu, bágwihini mu bitsimi bimõ, bábuono Nzaami mu likyi lili mpini ya bályele ti: «Mfumu, we wu áagyighili yulu, nsie ya mubu, ya bilogho byehene bi bili omo, ");
INSERT INTO tyx_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","me we áalyele mu Mufulu a Ngili mu muŋma a taara a bihi Dabvide, musala a we.» Nde ályele ti: «Mu emakye mansie mali kunsa yaŋã-yaŋã, ya bikaana bili mu osa mamfwunu ma magwene a mupfunu? ");
INSERT INTO tyx_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mikogho mi nsie mili yeelee mu odzwana mvulu, ya bamfumu baatemene mu emõ mu odzwana a Mfumu ya mu odzwana a Kriste a nde.» ");
INSERT INTO tyx_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Mu engaŋma, Erode ya Ponse Pilate baabvuŋunu mu bvulu li. Ya emõ ya baala ka bali ba-Dzwife o, ya ekaana kii Isarayele, bo baabvuŋunu mu odzwana a musala a we wu a ngili Yiisu, wu ámaana we. ");
INSERT INTO tyx_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bo baasi ti myehene mi ótswama otsyiri kwogho ya bitsimi bi we mikeele. ");
INSERT INTO tyx_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ya mu matala ma Mfumu, mono miŋaana mu bihi, ya gwa basala ba we kana lwohono mu otsala nsia a ndagha a we. ");
INSERT INTO tyx_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Labala kwogho e we mpaala baara badzughu ya bilyimi ya mandagha maa okiŋimi bimoŋono mu nkwumu a Yiisu, musala a we wu a ngili.» ");
INSERT INTO tyx_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bu bamana osamana Nzaami, ebini ki bábvuŋunu bo ényiŋĩ. Nzaami áluhu bo bwohono mu Mufulu a Ngili ya bo bábwi otsala nsia a ndagha a Nzaami ya kana. ");
INSERT INTO tyx_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mpwumu a ba bási kana yíli mukolo mumõ ya muwumunu mumõ. Ka óli a mbwuru wu áakalyele ti bilogho bi nde bibi ndaa ndeme o, byehene bi báli a bo bíli bibi ebvughu. ");
INSERT INTO tyx_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mu lileene li linene, bantumu bákasa esala kii bumpughulu mu osighili o Mfumu Yiisu mu lipfu, ya bwehe bu bunene búli ŋa yulu a bo bwohono. ");
INSERT INTO tyx_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ŋa kara li bo, ka óli a mbwuru wu áakagwene a elogho o. Mu kuulu, bo bwohono ba báli a manseghe bwunu-we manzo, bákatyeghe mo, bákagya a nzi yi a bi bákatyeghe, ");
INSERT INTO tyx_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ya bákatwulu yo ŋa nkulu a bantumu. Ya bákakaba kunda nswe mbwuru-mbwuru bwunu a bu oli nzala a nde. ");
INSERT INTO tyx_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Dzidzefe mu-Lebvite wu a bvulu lili Syipere, wu ókata bantumu «Baranabase», mbaala ti, «wu aakagwa bukyini», ");
INSERT INTO tyx_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","átyeghe nseghe yi áli a yo ya áyagwa nzi yi ábagha kundaa bantumu. ");
INSERT INTO tyx_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Lo baghala mumõ, wu a nkwumu Ananyase, emõ ya Safira mukala a nde, bátyeghe ndaama a nsie a bo. ");
INSERT INTO tyx_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nde ágwihini ya mukala a nde mu osweghe ndaama a nzi mu yi bábagha bo, ábiri ndaama yi ásyili ya ágwi yo kundaa bantumu. ");
INSERT INTO tyx_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Piere ályele kundaa nde ti: «Ananyase, mu emakye we aanyaã Satana asomo mu mukolo a we, mpaala we pfiri Mufulu a Ngili ya we sweghe ndaama a nzi yi a aatyeghe we ndaama a nsie? ");
INSERT INTO tyx_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nsomo we tyeghe ndaama a nsie yo yiili yi a ndaa we. Ŋa aatyeghe we yo, we aali a bumpoholo mu osalala nzi a we bu dzyi. Bu bunu-a-bo we aabagha bitsimi bi bibi bi? We ka aapfiri baara o, lo Nzaami we aapfiri.» ");
INSERT INTO tyx_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananyase bu agyughu ndagha oyo, ábwi ya ákpi. Bo bwohono ba bágyughu ndagha oyo bábagha nzalamweẽ yi alagha . ");
INSERT INTO tyx_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bampala bu batemene, bádzyi ebyimi, bábiri kye mu oyidzyighi. ");
INSERT INTO tyx_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ŋa mbihi-a-bele a matala matere, mukala a Ananyase áyasomo omo, gwene osoolo ndagha yi áabwi. ");
INSERT INTO tyx_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piere áfwulu nde ti: «Lyele me, yi me nzi yi liityeghe be ndaama a nsie?» Nde ábvuhulu ti: «Eẽ, me yo!» ");
INSERT INTO tyx_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piere ályele kundaa nde ti: «Bunu-abo be likughu ogwihini mu otsihi Mufulu a Mfumu? Gyughu, ba baafi ku odzyighi mulumu a we ayi ŋa muŋma a nzo, ya bo bali mu obiri wehe si!» ");
INSERT INTO tyx_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ŋaana oŋo, nde ábwi ŋa myili mi Piere ya ákpi. Bampala bu basomo, bámono nde ákpi, bábiri nde mu oyidzyighi nde ŋa bele a mulumu a nde. ");
INSERT INTO tyx_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Libwunu li Nzaami lwohono ya bo bwohono ba bágyughu mandagha mamo bábagha nzalamweẽ yi alagha. ");
INSERT INTO tyx_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bantumu bákasa bilyimi ya mandagha maa okiŋimi malagha ŋa kara li baara. Banga-a-kana bwohono bu bagwihini, bo bákabvuŋunu ŋa eluru e nzo a nzaami ki baakata ti kii Salomõ. ");
INSERT INTO tyx_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mu baara baala nkini ali ka bási kana o, ka óli a mbwuru si mumõ wu áabagha bukyini mu osomo mu kaba li banga-a-kana o, ngu okala ti baara bákabili bubwe mu bo. ");
INSERT INTO tyx_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Lo ŋa yulu oŋo, mampwumu ma babaghala ya mama bakaha ba bákasa kana mu Mfumu mákapfini. ");
INSERT INTO tyx_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Baara bákapaha babyele mu minsagha, ya bákalaha bo ŋa yulu a bikala ya ŋa yulu a malaba, mpaala ŋa ooluru Piere, edzyimi-a-dzyimi e nde ebuluberene a si mumõ mu bo. ");
INSERT INTO tyx_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mampwumu ma baara mákafa mu mabvulu ma mábehene ya Yerusaleme, mákayabiri babyele ya ba báli a mifulu mi mibi. Ya bo bwohono bákadzughu. ");
INSERT INTO tyx_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mfumu a bangaa ba nzaami ya ba báli emõ ya nde, kaba li ba-Saduseyẽ bátemene mu ogyighili ndagha. Bo áli balwulu mu musogho. ");
INSERT INTO tyx_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bo básyimi bantumu ya bálo bo mu boloko lili baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Lo mu mpyibi, ngye-yulu a Mfumu ádzubulu bidzughubu bi boloko, ápaha bo ku mbala ya ályele kundaa bo ti: ");
INSERT INTO tyx_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Ligye, ya bu litemene munsa nzo a nzaami, liluo baara mandagha mwohono mama bumweẽ bu bunyaghara ba.» ");
INSERT INTO tyx_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bo bu bagyughu obo, epala-epala básomo mu nzo a nzaami ya bábwi oluo. Mu obo, mfumu a bangaa ba nzaami ya babo ba báli ya nde, báti ekwuru ki ba-Dzwife mbili ya mfwunu a baana ba Isarayele, ya bágweghe baara ku boloko mu oyigwolo bantumu. ");
INSERT INTO tyx_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lo basala bu bayito ku boloko, bo ka bámono bo omo o, ya bu bayabvughuru, bátwoho nsia, ");
INSERT INTO tyx_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ya bályele ti: «Bihi liiyibagha boloko li bágyighili okuru, ya bankyele ba baatemene ŋa bidzughubu bi lo. Lo bu lidzubulu lo, bihi ka liimono si mbwuru mu kara o.» ");
INSERT INTO tyx_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mfumu a bankyele ba nzo a nzaami ya bamfumu ba bangaa ba nzaami, bu bagyughu ndagha oyo, bákiŋimi ku olagha ya bábwi obili ti yi nsa ndagha? ");
INSERT INTO tyx_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mbwuru mumõ áyalyele kundaa bo ti: «Ligyughu! Baara ba liilo be mu boloko bali munsa nzo a nzaami ya bali mu okaluo baara.» ");
INSERT INTO tyx_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mu obo, mfumu a bankyele ba nzo a nzaami ágyene, emõ ya bambumbulu ba nde, mu oyigwolo bantumu. Báyabiri bo, lo ka mu mpini o, buulu bo báli a nzalamweẽ a baara, mfangolo bakaha bo mameẽ. ");
INSERT INTO tyx_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bu bayabiri bo, bálamana bo ŋa nkulu a ekwuru ki ba-Dzwife. Mfumu a bangaa ba nzaami ábwi ogwa bo bifwulu, ");
INSERT INTO tyx_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","nde ályele kundaa bo ti: «Bihi ka liitswi be mikele mu onyaã ofiriluo mu nkwumu yi o? Ya limono, be liiluhu Yerusaleme mu maluo ma be ya be lidzyi otwulu lipfu li mbwuru munde ŋa yulu a mitswi mi bihi!» ");
INSERT INTO tyx_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piere ya bantumu babake bábvuhulu ti: «Bihi lifaana osa litumu li Nzaami, lo ka lili baara o. ");
INSERT INTO tyx_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nzaami a bataara ba bihi aasiili Yiisu wu liidzwi be, bu liikomo nde ŋa yulu a muti. ");
INSERT INTO tyx_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nzaami aaseene nde mu lileene li nde, mpaala akala Mfumu ya Mubvwuhu, mu kuulu baara ba Isarayele bagyiŋi mayele, ya babagha kolokolo a masumu ma bo. ");
INSERT INTO tyx_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ya bihi lili bampughulu mu mandagha mamo, bihi ya Mufulu a Ngili wu oogwi Nzaami kundaa babo ba baakasa litumu li nde.» ");
INSERT INTO tyx_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ekwuru ki ba-Dzwife bu egyughu mandagha mamo, kye élwulu mu nkehe ya ésagha odzwa bantumu. ");
INSERT INTO tyx_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lo mumõ mu ba-Faridzyẽ, nkwumu a nde Ngamalyele, muluo mikyene wu ookagwa baara bwohono budziri, bu atemene ŋa kara li ekwuru, áluomo ti bapaha bantumu ku mbala mu mana matala, ");
INSERT INTO tyx_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ya nde ályele kundaa bo ti: «Baara ba Isarayele, lisa mayele mu ma lidzyi be ogyighili kundaa baara ba! ");
INSERT INTO tyx_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Buulu, ka oli edzighi o, mbwuru wu a nkwumu Tewudase aayapala. Nde aakamoŋono ti nde mbwuru wu bvulu mupfunu, ya mutala a baara ba baakanama nde ali ku bele a nkama-na (400). Lo mu matala ma baadzwi nde, baara bwohono ba baakanama nde baatsaŋama ya emvuŋunu ekye eekpi. ");
INSERT INTO tyx_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ŋa mbihi a nde, Yuda musi Ngalile, aayamoŋono mu bitsughu bibi osono mankwumu mu osoolo mutala a baara. Baara balagha baakanama nde. Lo ndehe si aakpi, ya baara bwohono ba baakanama nde baatsaŋama. ");
INSERT INTO tyx_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mu matala ma, me ndyele kundaa be ti: Ka linama mandagha ma baara ba o, ya linyaã bo bagye. Mu kuulu, kala ti ndagha yi ya esala ki kundaa baara biifi, lo sa bidzimini. ");
INSERT INTO tyx_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lo kala ti bye kundaa Nzaami biifi, be ka likughu odzihibi bye o. Ka lisagha odzwana ya Nzaami o!» Emvuŋunu ki ekwuru ki ba-Dzwife égyughu Ngamalyele. ");
INSERT INTO tyx_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bu bati bantumu mbili, bákubu bo nswanswa ya bálighi bo mu ofiribili mu nkwumu a Yiisu, ya bányaã bo. ");
INSERT INTO tyx_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bantumu bámara ŋa nkulu a ekwuru ki ba-Dzwife, bágyene mu esee, buulu Nzaami ámono ti bo áli bakughu mu omono mpara mu nkooro nkwumu a Yiisu, ");
INSERT INTO tyx_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ya nswe etsughu mu nzo a nzaami ya munsa manzo, bo bákaluo Nsia yi Mbwe yi a Yiisu-Kriste, ku ogwene okolo. ");
INSERT INTO tyx_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mu bitsughu bibye, mutala a binduono ápfini ku olagha. Ba-Dzwife ba bákabili ndiŋi yi a ba-Ngereke bábwi oŋuŋunu mu ba-Dzwife baba mu Isarayele ba bákameŋene bapfiili ba bo ba bakaha mu matala ma bákakaba bi-odza bibi nswe etsughu. ");
INSERT INTO tyx_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Bantumu kwumu ya buolo (12) bábvughu mpwumu a binduono yohono, ya bályele kundaa bo ndiri: «Ka oli bubwe o ti bihi linyaã okaluo ndagha a Nzaami mu osala esala kii okakaba bi-odza. ");
INSERT INTO tyx_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mu obo baana ba taara, liswolo ŋa kara li be babaghala nsaama ba bali a bumpughulu bu bubwe, ba bálwulu mu Mufulu ya bunsughu, bihi sa ligwa bo esala ekye. ");
INSERT INTO tyx_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Lo bihi sa lisa mukama mu okabuono ya mu okasala esala kii oluo mandagha ma Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mpwumu a baara yohono yíkihi etsimi ekye. Básuolo Etiene, baghala wu áli a kana ya álwulu mu Mufulu a Ngili, Filipe, Porokore, Nikanore, Timõ, Paremenase ya Nikola munde wu a ku Antyose, wu áasomo Nzaami a ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bágyi a bo ŋa nkulu a bantumu. Bantumu básamana mu bo ya bánaŋa bo myaã. ");
INSERT INTO tyx_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ndagha a Nzaami yíkabvulu otsaŋama, ya mutala a binduono ákapfini ku olagha ku Yerusaleme, ya mpwumu a bangaa ba nzaami yi nene yíkasa kana mu Yiisu. ");
INSERT INTO tyx_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiene áli alwulu mu bwehe ya mu lileene. Nde ákasa mandagha maa okiŋimi ya bilyimi bii okiŋimi ŋa kara li baara. ");
INSERT INTO tyx_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ndaama a baara baba nzo a lisamana a ba-Dzwife yi baakata ti Nzo a bankana ba bali bunya-nyaã, baba ku Sirene, baba ku Aledzandiri ya baba ku Silisi lili Adzi, bábwi osa munsoho ya Etiene. ");
INSERT INTO tyx_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lo bo ka bákakughu otemene o ŋa nkulu a mandagha mama bunsughu ma ókagwa nde Mufulu mu obili. ");
INSERT INTO tyx_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mu obo, bo bágwi baara nzi mpaala balyele ti: «Bihi liigyughu nde mu okatswagha Moyidze ya Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bo bátyihi baara, bakwuru ba babaghala ya baluo-mikyene. Bo bu bayato, básyimi Etiene ya babiri nde ŋa nkulu a Mfwunu a ekwuru ki ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bo bátehebe bampughulu baba mpya ba bályele ti: «Baghala wu ka li mu okakolo o mu okalyele bubi mu ebini kii ngili ki ya mu mikyene mi Moyidze. ");
INSERT INTO tyx_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bihi liigyughu nde mu okalyele ti Yiisu wu, wu a ku Nadzarete sa atsala ebini ki ya sa osobo ekulu ki ósihi bihi Moyidze.» ");
INSERT INTO tyx_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bo bwohono ba bábwi-nsini mu Mfwunu a ekwuru, bu batuunu nde mihi, bámono edzili ki Etiene éli ti anga kii ngye-yulu. ");
INSERT INTO tyx_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mfumu a bangaa ba nzaami áfwulu Etiene ti: «Mandagha mamo mali mama ngaŋma?» ");
INSERT INTO tyx_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiene ábvuhulu ti: «Baana ba taara a me ya bataara ba me, ligyughu! Nzaami wu a nsia ámoŋono kundaa Abarahame taara a bihi, ŋa áli ku Medzopotami, nsomo nde ayikala ku Arane. ");
INSERT INTO tyx_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ya nde ályele kundaa Abarahame ti: “Pala mu nsie a we, sihi dzumu li we, ya gye ku nsie oyo yi akala aansuo me we”. ");
INSERT INTO tyx_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mu obo, nde ápala mu nsie yi a Bakaledeẽ, átwu ku Arane. Ŋa mbihi a lipfu li taara a nde, Nzaami ábiri nde ku nsie oyo, mu lili mu okakala be mu matala ma. ");
INSERT INTO tyx_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nzaami ka ágwi nde pfa si limõ mu nsie yi o, si ebini kii otwulu bitaama o, lo ásiini a nde mu ogwa nde nsie yi, ya musyi a dzumu li nde mpaala yikala pfa li bo. Mu matala mamo, Abarahame nkini ka áli a mwana o. ");
INSERT INTO tyx_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nzaami ályele kundaa nde ndiri: “Musyi a dzumu li we sa ayikala mu nsie yi bunzyi, oko sa bakirili bo bankana ya sa bamwehẽ bo kimini mu nkama-na (400) yi mibvu”. ");
INSERT INTO tyx_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nzaami áfirilyele ti: “Me, me sa ndamana ekaana ekye ki eekirili bo bankana. Ŋa mbihi oŋo, bo sa bapala, ya sa bakabuono me ŋa ebini ki”. ");
INSERT INTO tyx_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nzaami áti endughu ya nde mu elyimi ki ásohobo nde nzo a mbaa, ya mu matala ma áburu nde Idzake, nde ásohobo nde nzo a mbaa mu etsughu kii mpuomo, ya Idzake ási bumõ kundaa Dzakobe, ya Dzakobe kundaa bankagha-kwuru kwumu ya buolo (12).» ");
INSERT INTO tyx_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Bankagha-kwuru bámono Dzidzefe mukolo mubi, ya bátyeghe nde kundaa baara, ya baara babo bábiri nde ku Edzipite. Lo Nzaami áli ya nde. ");
INSERT INTO tyx_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nzaami ákwulu Dzidzefe mu mpara a nde yohono, ya ágwi nde bwehe ya bunsughu ŋa nkulu a Faraõ, mukogho a Edzipite, wu áatwulu nde mfumu wu munene mu Edzipite, ya mu nzo a nde yohono. ");
INSERT INTO tyx_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Munzyala ásomo mu Edzipite yohono ya mu Kaana. Mpara yíli yilagha, ya bataara ba bihi ka báfirikabagha bi-odza o. ");
INSERT INTO tyx_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Dzakobe bu agyughu ti ku Edzipite óli a bele, nde ágweghe bataara ba bihi mu mukubu wu a nsomo. ");
INSERT INTO tyx_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mu mukubu wu a myele, Dzidzefe ásuo nyuru kundaa banaana ba nde, ya Faraõ ásoolo dzumu li nde. ");
INSERT INTO tyx_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Dzidzefe ágweghe bayigwolo taara a nde Dzakobe ya dzumu li nde lwohono. Bo báli baara makwumu-nsaama ya bataana (75). ");
INSERT INTO tyx_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Dzakobe ákumunu ku Edzipite, ákpi oko, bumõ si ya bataara ba bihi. ");
INSERT INTO tyx_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bábiri miwehe mi bo ku bula bubu Sisyeme ya bádzyighi mye mu mpyeme yi óswumu Abarahame mu nzi kundaa baana ba Emore ku Sisyeme.» ");
INSERT INTO tyx_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Buulu matala ma ookeele misiini mi ósi Nzaami kundaa Abarahame máyabehene, ekaana e bihi épfini ya éburunu mu Edzipite, ");
INSERT INTO tyx_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","tee mu matala ma óbyala mukogho mukimi mu Edzipite wuulu ka ásoolo Dzidzefe o. ");
INSERT INTO tyx_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mukogho munde ápfiri ekaana e bihi, ámwehẽ bataara ba bihi kimini. Nde átumu bo mu mpini bakatsili baana babo ba babwihi, mu kuulu banyaã obaŋa. ");
INSERT INTO tyx_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Me mu ena ekye báburu Moyidze, nde áli mubwe ŋa mihi mi Nzaami. Bátsyaha nde mu bangoono batere mu nzo a taara a nde. ");
INSERT INTO tyx_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ya bu batsili nde, mwana a Faraõ wu mukaha átolo nde, ya ákwuhu nde ti anga mwana wu áburu ndeme. ");
INSERT INTO tyx_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moyidze ágyighi maluo mama bunsughu bwohono mama basi Edzipite. Ya áli a lileene mu mbiili ya mu bigyighili bi nde. ");
INSERT INTO tyx_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ŋa ákuhu nde bamvulu makwumu-mana (40), nde ábagha bitsimi mu oyimono baana ba taara a nde, baana ba Isarayele. ");
INSERT INTO tyx_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nde ámono musi Edzipite wu áakamwehẽ mumõ mu basi Isarayele mpara. Nde ábaha ya ákala musi Isarayele ya ádzwi musi Edzipite. ");
INSERT INTO tyx_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nde ákatsimi ti baana ba taara a nde sa babaghala ti mu nde Nzaami aabvwuhu bo. Lo bo ka bábaghala o. ");
INSERT INTO tyx_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ŋa mbihi a etsughu ekye, Moyidze áyimono baara buolo ba bákadzwana. Nde ásagha obvurulu egyeẽ ya edzuunu ŋa kara li bo ya ályele kundaa bo ti: “Mu emakye be lili mu okasa bubi be a be? Buta be lili baana ba taara mumõ!” ");
INSERT INTO tyx_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Munde wu ákamwehẽ nganda mpara ábihi ogyughu Moyidze ya ályele kundaa nde ti: “Nande aatwulu we mfumu ya nsughu-a-lamana mu bihi? ");
INSERT INTO tyx_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","We me dzyi odzwa ti bu aadzwi we musi Edzipite matsighi?” ");
INSERT INTO tyx_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moyidze bu agyughu ndagha oyo, ábara ya áyikala ku nsie yi a Madyane, oko nde áburu baana buolo ba babaghala.» ");
INSERT INTO tyx_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Mibvu makwumu-mana (40) bu mikughu, ngye-yulu ámoŋono kundaa nde munsa mule a mbaa wu eti-ti, ku syehe lili munguo wu a Sinayi. ");
INSERT INTO tyx_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moyidze ákiŋimi mu mandagha ma ámono nde, ya bu ayabehene mpaala agyighili otala, nde ágyughu likyi li Mfumu li lílyele kundaa nde ti: ");
INSERT INTO tyx_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Me ndi Nzaami a bataara ba we, Nzaami a Abarahame, Idzake ya Dzakobe”. Kunsa enkwughu, Moyidze ka áleene otala o. ");
INSERT INTO tyx_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ya Mfumu ályele kundaa nde ti: “Maha mapaapa mu myili mi we, mu kuulu ebini ki aatemene we, eli ebini kii ngili. ");
INSERT INTO tyx_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Me aamono kimini li ekaana e me ku Edzipite, me aangyughu misyama mi bo. Ya me aankumunu mu okwulu bo. Mu matala ma, gye, me ngweghe we ku Edzipite”». ");
INSERT INTO tyx_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Wu me Moyidze wu bábihi bo ŋa áli bályele ti: “Nande aatwulu we mfumu ya nsughu-a-lamana?” Lo me nde Nzaami ágweghe ti mfumu ya mukwulu. Nzaami átumu nde mu nzili a ngye-yulu wu ámoŋono kundaa nde mu eti-ti. ");
INSERT INTO tyx_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Me nde áapaha bo mu nsie yi a Edzipite mu mandagha mama okiŋimi ya bilyimi, ŋa Mubu wu a Bie ya ku syehe, mu mibvu makwumu-mana (40). ");
INSERT INTO tyx_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Me nde, Moyidze áalyele kundaa baana ba Isarayele ti: “Nzaami sa apaha mu nkooro a be, ŋa kara li baana ba taara a be, mubighili mumõ ti anga me”. ");
INSERT INTO tyx_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mu matala ma óli emvuŋunu ku syehe, me nde áli aatemene mu okagyughu ya bataara ba bihi mi ókalyele ngye-yulu ku yulu a munguo wu a Sinayi. Nde ágyagha mandagha mama bumweẽ mu ogwa mo kundaa bihi. ");
INSERT INTO tyx_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Lo bataara ba bihi ka bákihi osa litumu li nde o, bo bábihi nde ya mikolo mi bo míbvughuru ku Edzipite. ");
INSERT INTO tyx_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bo bályele kundaa Aarõ ti: “Gyighili bihi banzaami ba baadzyara ŋa nkulu a bihi mu kuulu bihi ka lisoolo o bu oobwana Moyidze wu, nde wu aapaha bihi mu nsie yi a Edzipite”. ");
INSERT INTO tyx_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mu bitsughu bibye bo bátsulu etyeghe mu efaana kii pulu li ngoomo. Ya bádzwi nyama mu ogwa mukaba kundaa kye ya bási kyiri mu nkooro a etyeghe ekye ki ótsulu myaã mi bo. ");
INSERT INTO tyx_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nzaami átyeghe bo mbihi ya ányaã bo bakasamana mikaã mimi mayulu, bwunu a bu básono mu mukaana a mibighili ti: “Nzo a Isarayele, mu mibvu makwumu-mana (40), kundaa me be líigwi banyama ya mikaba ku syehe? ");
INSERT INTO tyx_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Be líibiri ebvulu e Moloke, ya ŋomaŋomo a Rayifã, nzaami a be, bityeghe bibye bi lígyighili be mu okasamana bye. Mu obo, me sa mbiri be ku bunkana ku mbihi a Babilone”». ");
INSERT INTO tyx_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Ku syehe, bataara ba bihi báli a ebvulu kii bumpughulu baa ogwihini, bwunu a bu ótumu munde wu áabili kundaa Moyidze, ti agyighili ebvulu mu efaana ki ásuo kundaa nde. ");
INSERT INTO tyx_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Bataara ba bihi bu bakihi kye, básohobo kye mu litumu li Dzodzuwe mu nsie yi ógwi bo Nzaami, ŋa mbihi a ŋa ábyi nde bikaana bibye ŋa mihi mi bo, tee mu matala ma Dabvide. ");
INSERT INTO tyx_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nde ábagha bwehe ŋa busu bu Nzaami ya áluomo muswa wu obagha nzo yi a nzaami a Dzakobe. ");
INSERT INTO tyx_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lo me Salomõ áatwu nzo a nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Lo Wu Ensoõ-yulu ka aakakala mu manzo ma ótwu myaã mi baara o.» Obo me bu ólyele mubighili ti: ");
INSERT INTO tyx_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","«Yulu lili likubu li me, ya nsie yili nkara a myili mi me. Nki nzo be liitwu me, bu olyele Mfumu, ya ŋa nki ebini me akala aangwumu? ");
INSERT INTO tyx_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bunu, ka oli myaã mi me míigyighili bilogho byehene bibye o?» ");
INSERT INTO tyx_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Be lili baara banga a mutswi-mpini, banga a mikolo ngyi ya matswi-nkyihi. Mu matala mwohono, be liikabihi Mufulu a Ngili, be lili ti anga bataara ba be! ");
INSERT INTO tyx_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nki mubighili bataara ba be bágwene omwehẽ kimini? Bo bádzwi ba bátswama oyatwoho nsia a ogya o Wu-a-Nsumu, munde wu liityeghe ya liidzwi be mu matala ma. ");
INSERT INTO tyx_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Be ba lígyagha Mikyene mu nzili a bangye-yulu, lo be ka liikasalala mye o.» ");
INSERT INTO tyx_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Baara ba mfwunu a ekwuru ki ba-Dzwife bu bagyughu mandagha mamo, bo bábagha nkehe yi alagha ya bákadza myini mu nkooro a nde. ");
INSERT INTO tyx_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lo Etiene bu áli wu aalwulu mu Mufulu a Ngili, átala ku yulu ya ámono bunkiri bu Nzaami ya Yiisu mu mukiri ŋa ngo-kwogho e Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nde ályele ti: «Ligyughu! Me ndi mu okamono mayulu bwaha, ya Mwana a mbwuru átemene ŋa ngo-kwogho e Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bo bákehe bingubu bi binene, bákyi matswi ma bo, ya mu emvughu bo bwohono bágyighiri mu nyuru a Etiene. ");
INSERT INTO tyx_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bo bápaha nde mu bvulu ya bádzwi nde mu mameẽ. Ya bampughulu básuhu binkuru bi bo ŋa myili mi mumpala mumõ, nkwumu a nde Sawule. ");
INSERT INTO tyx_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mu matala ma bákakaha nde mameẽ, Etiene ákabuono bu: «Mfumu Yiisu, gyagha mufulu a me!» ");
INSERT INTO tyx_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ya bu akunu mabuo ŋa nsie, nde ákehe engubu ti: «Mfumu, Mfumu, sa bo kolokolo mu lisumu li!» Bu alyele obo, ewumu ésughu ya nde ákpi. ");
INSERT INTO tyx_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sawule áli mumõ mu babo ba bámono ti lipfu li Etiene ndagha yi mbwe. Mu etsughu kyini ekye, bámwehẽ Libwunu li Nzaami lili Yerusaleme kimini li lilagha. Ya bo bwohono ba báli mu Libwunu li Nzaami bátsaŋama, bágyene ku Yude ya ku Samari. Yini a bantumu baasyili mu Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Lo baara banga-a-enzaami kii engaŋma bádzyighi Etiene ya bálili nde ku olagha. ");
INSERT INTO tyx_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ya Sawule ákabulutsala Libwunu li nzaami, nde ákabulusomo mu manzo, ákabulusyimi babaghala ya bakaha, ya ákayilo bo mu boloko. ");
INSERT INTO tyx_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Babo ba bátsaŋama bákabulutsala Nsia yi Mbwe yi a ndagha a Nzaami omo mwohono mu bákabulubara bo. ");
INSERT INTO tyx_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Obo me buulu, Filipe ákumunu mu bvulu limõ lili mu Samari, nde ábwi otsala nsia a Kriste. ");
INSERT INTO tyx_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Emõ, mampwumu ma baara mákatyeghe matswi mu mandagha ma ókaluo Filipe, ŋa bákagyughu ya bákamono bo bilyimi bii okiŋimi bi ákasa nde. ");
INSERT INTO tyx_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mu engaŋma, mifulu mi mibi milagha mi míli mu baara, míkapala mu okabulukehe mingili. Balagha ba ókpi binama ya banga-a-bipfwumu mu myili bákadzughu. ");
INSERT INTO tyx_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mu obo, baara baba mu bvulu lilo, báli kunsa esee ki elagha. ");
INSERT INTO tyx_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ankoho, áli oli a baghala mumõ mu bvulu lili Samari, nkwumu a nde Simõ. Nde átswama okakala munsa bvulu lilo. Nde áli ngaa-a-mpaana, ya baara baba mu Samari bákakiŋimi mu mi ákagyighili nde. Ya ndeme ákatsimi ti nde mbwuru wu munene. ");
INSERT INTO tyx_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ya baara bwohono, obaana bakwuru tee bike-bike, bákasa kana mu nde, ya bákalyele ti: «Baghala wu me lileene li Nzaami, li baakalyele ti “Lileene li Linene”.» ");
INSERT INTO tyx_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ya bo bákasa kana mu nde, mu kuulu mana edzighi, nde ákabulugyighili mandagha maa okiŋimi mu mpaana a nde. ");
INSERT INTO tyx_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lo bu basi kana mu Filipe wu ákaluo Nsia yi Mbwe yi a empu e Nzaami ya nkwumu a Yiisu-Kriste, babaghala ya bakaha bákakihi oboghoro. ");
INSERT INTO tyx_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simõ ndeme si ási kana ya báboghoro nde. Nde ákanama Filipe ya ákiŋimi, bu ákabulumono bilyimi ya bimaã bii okiŋimi bi ókabulusa Filipe. ");
INSERT INTO tyx_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bantumu ba básyili ku Yerusaleme bu bagyughu ti basi Samari baakihi ndagha a Nzaami, bágweghe Piere ya Dzã kundaa bo. ");
INSERT INTO tyx_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bu bato oko, básamana mu basi Samari mpaala bagyagha Mufulu a Ngili. ");
INSERT INTO tyx_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Mu engaŋma, Mufulu a Ngili nkini ali ka ámaabwa mu mbwuru si mumõ mu bo o, yini a oboghoro báboghoro bo mu nkwumu a Mfumu Yiisu. ");
INSERT INTO tyx_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Oŋo, Piere ya Dzã bánaã bo myaã ŋa yulu a mitswi, ya bo bágyagha Mufulu a Ngili. ");
INSERT INTO tyx_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simõ bu amono ti bantumu bákagwa Mufulu mu onaã myaã ŋa yulu a mutswi, nde ágwi bo nzi, ");
INSERT INTO tyx_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ya ályele ti: «Ligwa mehe si lileene lilo, mpaala nswe munde wu aanãa me myaã ŋa yulu a mutswi, nde agyagha Mufulu a Ngili.» ");
INSERT INTO tyx_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Lo Piere ályele kundaa nde ti: «Nyaã we ya nzi a we lipfighili! Mu kuulu we aatsimi ti we kughu oswumu mu nzi ekaba ki ookagwa Nzaami ku o bwunu. ");
INSERT INTO tyx_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mu ogyighili otala, we ka li wu a kaba li bihi o, ya we ka li a pfa mu esala ki o. Mu kuulu mukolo a we ka li nsumu ŋa nkulu a Nzaami o. ");
INSERT INTO tyx_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mu obo, gyiŋi mayele mu bubi bu we, ya samana Mfumu, nkini-a-nki bakughu osa we kolokolo mu bitsimi bi biigyi we ŋa mukolo. ");
INSERT INTO tyx_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mu engaŋma, me ndi mu omono ti we li a bubi bubu nkala mu mukolo, ya we li nkana a masumu.» ");
INSERT INTO tyx_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simõ ábvuhulu ti: «Be beme lisamana Mfumu mu nkooro a me, mpaala mandagha ma liilyele be manyaã obwa mu me.» ");
INSERT INTO tyx_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Piere ya Dzã, bu bamana osuo bumpughulu bu Mfumu ya otsala nsia a ndagha a Nde, bábvughuru ku Yerusaleme. Mu nzili, bo bákabulutsala Nsia yi Mbwe mu mala malagha mu Samari. ");
INSERT INTO tyx_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ngye-yulu a Mfumu ályele kundaa Filipe ti: «Temene, ya gye ku nkolo yi a ku Sude, mu nzili yi aakamara ku Yerusaleme ya yiikakumunu ku Ngadza. Baara ka baafirikaluru mu nzili oyo o.» ");
INSERT INTO tyx_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bu atemene, nde ágyene. Ankoho, baghala mumõ wu bágwogholo, wu a ku Etyopi, musala wu munene wu a Kandase, mfumu a busini bwohono bu ngasa a basi Etyopi, áli agyi ku Yerusaleme mu oyabuono Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nde áli ayi mu okabvughuru. Nde ábwi-nsini munsa syare li nde, mu okabulutaã mukaana a mubighili Edzayi. ");
INSERT INTO tyx_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mufulu a Ngili ályele kundaa Filipe ti: «Gye yibagha syare lilo.» ");
INSERT INTO tyx_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Bu abara ntyini tee oŋo, Filipe ágyughu nde mu okataã mukaana a mubighili Edzayi, ya nde áfwulu nde ti: «Bunu, we li mu okabaghala mi li mu okataã we?» ");
INSERT INTO tyx_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nde ábvuhulu ti: «Bunu-abo me aambaghala kala ti mbwuru ka gwi me mbaala a mo o?» Ya nde ályele Filipe akumu ya abwa-nsini ŋa bele a nde. ");
INSERT INTO tyx_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Etsulu e ndagha a Nzaami ki ákabulutaã nde me ki: «Nde áli ti endoomo ki bali mu okabiri ku ebini ki baakadzwa bibuolo, ya ti anga mwana a endoomo wu gwene a likyi, ŋa nkulu a wu li mu okakye nde mfu, nde ka aadzubulu muŋma o! ");
INSERT INTO tyx_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kunsa okughulu o nde, baasi nde muyala, nde ka aabagha bwuu o, nande akala aabili mu eseene e nde? Mu kuulu baamaha laama li nde ŋa nsie.» ");
INSERT INTO tyx_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Musala wu munene wu a Etyopi munde, áfwulu Filipe ti: «Kolokolo a we, lyele me, mubighili mu na ali mu okabili obo? Mu ndeme bwunu we mu mbwuru mukimi?» ");
INSERT INTO tyx_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mu obo, Filipe ábaana mu mi básono mu Mukaana wu a Ngili, áluo nde Nsia yi Mbwe yi a Yiisu. ");
INSERT INTO tyx_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bu bákagye mu nzili, báto ŋa mbughu yi áali a madza, ya Musala wu munene wu a Etyopi ályele ti: «Mono madza moŋo! Emakye eekahaba me mu obagha liboghoro?»  ");
INSERT INTO tyx_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipe ályele kundaa nde ti: «Kala ti we si kana mu mukolo a we ndehene, we kughu obagha liboghoro». Musala wu munene ábvuhulu ti: «Me ndi a kana ti Yiisu-Kriste li mwana a Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nde átehebe syare, bo bansa buolo básughuru mu madza, ya Filipe áboghoro nde. ");
INSERT INTO tyx_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bu bapala mu madza, Mufulu a Mfumu ábulubiri Filipe ya musala wu munene wu a Etyopi ka áfirimono nde o. Lo nde ánama bula bu nzili a nde mu esee. ");
INSERT INTO tyx_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipe áyipala ku Adzote mu okabulutsala Nsia yi Mbwe mu mabvulu mwohono ma áluru nde, tee bu áyito nde ku Sedzare. ");
INSERT INTO tyx_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mu matala mamo, Sawule wu áakaŋaana odzwa binduono bi Mfumu, áyiluomo kundaa mfumu a bangaa ba nzaami, ");
INSERT INTO tyx_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","mikaana mimi manzo mama lisamana ma ba-Dzwife mama mu bvulu lili Damase. Oko, kala ti nde mono baara ba baakanama nzili a Mfumu, babaghala bwunu we bakaha, nde akuru bo minkana, ya ayabiri bo ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Bu ákagye mu nzili, nde ábehene ya bvulu lili Damase. Ensihibi, otsyeme ku ófi ku yulu óbwi mu nde ya odzyi nde. ");
INSERT INTO tyx_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nde ábwi ŋa nsie, ágyughu likyi li líkalyele nde ti: «Sawule, Sawule, mu emakye we li mu okamwehẽ me kimini?» ");
INSERT INTO tyx_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nde áfwulu ti: «Mfumu, we nande?» Likyi líbvuhulu ti: «Me ndi Yiisu, ngu me we li mu okamwehẽ kimini. ");
INSERT INTO tyx_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lo temene, somo munsa bvulu, ya sa balyele we mandagha mafaana we ogyighili.» ");
INSERT INTO tyx_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Baara ba bákadzye ya nde, bátemene ya bákwono otsughu ndagha mu nzalamweẽ. Bo bákagyughu likyi, lo ka bákamono wu áakabili o. ");
INSERT INTO tyx_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawule átemene ya ádzubulu mihi, lo nde ka áfirikamono elogho si emõ o. Baara ba bákagye ya nde, bákwara nde mu kwogho ya básohobo nde mu bvulu lili Damase. ");
INSERT INTO tyx_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Oko nde ási bitsughu bitere biili nde omono we, odza we ya oŋma we. ");
INSERT INTO tyx_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ku Damase óli a enduono etsyini, nkwumu a nde Ananyase. Mu limono Nzaami áti nde mbili: «Ananyase!» Nde ábvuhulu ti: «Mfumu, me ndindi!» ");
INSERT INTO tyx_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mfumu ályele kundaa nde ti: «Gye mu munsagha wu baakata ti Wu a Nsumu, ya fwulu munsa nzo a Yuda, baghala wu a nkwumu Sawule musi Tarese. Nde li omo mu okasamana, ");
INSERT INTO tyx_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ya mu bantaala, nde aamono baghala mutsyini, nkwumu a nde Ananyase wu áasomo mu nzo ya wu áanaã nde myaã ŋa yulu mutswi mpaala nde afirimono.» ");
INSERT INTO tyx_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananyase ábvuhulu ti: «Mfumu, me áakangyughu baara balagha mu okabili mu baghala munde ya mu bubi bwohono bu aakasa nde kundaa baba ngili ba we mu Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ya bamfumu ba bangaa ba nzaami bágwi nde litumu lili osyimi baara bwohono ba baakasamana we.» ");
INSERT INTO tyx_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lo Mfumu ályele ti: «Gye kundaa mbwuru munde, mu kuulu nde li elwee ki aansuolo mu oyitsala Nsia a Nkwumu a me kundaa bikaana bibi gwene osoolo me, kundaa mikogho ya kundaa basi Isarayele. ");
INSERT INTO tyx_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Me, meme sa nsuo nde mpara yi afaana omono nde mu nkooro a nkwumu a me.» ");
INSERT INTO tyx_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananyase ágyene, ásomo munsa nzo. Ya bu anaã nde myaã ŋa yulu a mutswi, ályele kundaa nde ti: «Sawule, mwana a taara a me, Mfumu gweghe me, Yiisu munde wu aamoŋono kundaa we mu nzili yi aakagya we, mu kuulu we firimono ya we lwulu mu Mufulu a Ngili.» ");
INSERT INTO tyx_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ŋaana oŋo, bilogho bi bifaana ti anga makala ma nswi bíkogholo mu mihi mi nde ya nde ábaana ofirimono. Nde átemene ya báboghoro nde. ");
INSERT INTO tyx_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ya bu amana odza, Sawule ábagha mpini mu nyuru. Sawule áluhu mana bitsughu ya binduono bi Mfumu ku Damase. ");
INSERT INTO tyx_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ŋaana oŋo, nde ábwi okabululuo mu manzo mama lisamana ma ba-Dzwife ti: Yiisu li Mwana a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Baara bwohono ba bákagyughu nde bákakiŋimi ya bákalyele ti: «Ka oli nde wu áakamwehẽ ba baakasamana mu nkwumu a Yiisu kimini ku Yerusaleme o? Ya nde ka aagyi kunu mu osyimi bo ya obiri bo mu binkana kundaa bamfumu ba bangaa ba nzaami o?» ");
INSERT INTO tyx_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Lo Sawule ákagwama ku oluru, ba-Dzwife baba ku Damase ka bákabagha yi baabili ŋa nkulu a nde o, ya nde ákasuo ti Yiisu me Kriste. ");
INSERT INTO tyx_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Bitsughu bilagha bu biluru, ba-Dzwife bákuru mfwunu yi odzwa nde. ");
INSERT INTO tyx_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mpyibi ya mwiĩ, bo bákakebe mu miŋma mi ekagha kii bvulu kuulu badzwa nde. Lo Sawule ágyahaba mfwunu a bo. ");
INSERT INTO tyx_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mu obo, mu mpyibi, binduono bi Sawule, bílo nde mu nkuru ya bísurulu nde ku ngulu a ekagha kii bvulu. ");
INSERT INTO tyx_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Bu ato ku Yerusaleme, Sawule ásagha osomo mu kaba lili binduono, lo bo bwohono báli a nzalamweẽ a nde, ya ka bákasa kana o ti nde áli ayi enduono. ");
INSERT INTO tyx_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Baranabase ábiri nde kundaa bantumu ya ályele bo bu óbwana a Sawule Mfumu mu nzili a Damase, ya bu ábili nde kundaa Sawule. Ya bunu-a-bo, obaana ku Damase, nde ákabili ya kana lwohono mu nkwumu a Yiisu. ");
INSERT INTO tyx_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Obaana matala mamo, Sawule ákabulugye mu bibini byehene ya bo mu Yerusaleme, ya ákabulubili mu nkwumu a Mfumu ya kana. ");
INSERT INTO tyx_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nde ákabili ya ákatsoho ya ba-Dzwife ba baakabili Engereke. Lo bo bákasagha odzwa nde. ");
INSERT INTO tyx_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bandughu mu kana bu basoolo ndagha oyo, bábiri nde ku Sedzare, ya oko bo bágweghe nde ku Tarese. ");
INSERT INTO tyx_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Libwunu líli kunsa edzuunu mu bitsulu bi nsie byehene bibi Yude, Ngalile ya Samari. Mu libaha li Mufulu a Ngili, lo líkakulu mu mufulu, líkadzyara kunsa budziri bu Mfumu ya líkakulu mu mutala a baara. ");
INSERT INTO tyx_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Obo me buulu Piere, wu áakabuludzie mu bitsulu byehene, ákumunu si kundaa baba ngili ba báli mu bula bubu Lida. ");
INSERT INTO tyx_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nde ámono baghala mutsyini wu óneŋene binama. Baghala munde ágyoŋomo ŋa yulu a ekala mu mibvu mpuomo. Nkwumu a nde Ene. ");
INSERT INTO tyx_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piere ályele kundaa nde ti: «Ene, Yiisu-Kriste aadzuhu we. Temene, ya fughuru ekala e we weme!» Mu likpa lyini lilo, nde ásaatemene. ");
INSERT INTO tyx_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Baara bwohono baba mu Lida ya baba ku elehe kii Syarone bu bamono obo, bo bási kana mu Mfumu. ");
INSERT INTO tyx_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mu bvulu lili Yope, óli a enduono kii mukaha. Nkwumu a nde Tabita, mu Engereke «Dorokase», mbaala ti, «nsa». Nde ákagyighili mi mibwe ya ákabaha bawele. ");
INSERT INTO tyx_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mu bitsughu bibye, nde ábyele ya ákpi. Bu baswagha ebyimi e nde, báyitwulu kye mu ngwumu a nzo yi a ku yulu. ");
INSERT INTO tyx_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Buulu Lida áli libehene ya Yope, binduono bigyughu ti Piere áli oŋo, bígweghe babaghala buolo mu oyibiŋini nde ya bíbuono nde ti: «Sa maswa, gya kundaa bihi!» ");
INSERT INTO tyx_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mu maswa Piere ágyene ya bo. Bu ato oko, bo bákuhubu nde ku ngwumu a nzo yi a ku yulu. Bapfiili bwohono ba bakaha bátemene ŋa nkulu a nde ya bábuulu elili, bákasuo nde binkuru bi bila ya binkuru bi baakalaha ŋa yulu bi ókatwu bo Dorokase ŋa aali nde mweẽ. ");
INSERT INTO tyx_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piere ápaha baara bwohono ku mbala, ya bu akunu mabuo mu nsie, nde ábwi osamana. Ŋa mbihi, nde ákaghala ku óli ebyimi ya ályele ti: «Tabita, temene!» Tabita ádzubulu mihi, ya bu amono Piere, nde ásighili ábwi-nsini. ");
INSERT INTO tyx_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piere ákwara nde mu kwogho ya átehebe nde. Ŋa nseele, nde áti baba ngili ya bapfiili mbili ya nde ásuo bo Dorokase wu a mweẽ. ");
INSERT INTO tyx_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yope lwohono lígyughu ndagha oyo ya baara balagha bási kana mu Mfumu. ");
INSERT INTO tyx_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piere áluhu bitsughu bilagha ku Yope, mu nzo a Simõ, wu áakasa esala ki okagyighili bibaana bi banyama. ");
INSERT INTO tyx_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ku bvulu lili Sedzare óli a baghala mutsyini, nkwumu a nde Koroneye, mfumu a mpwumu a bambumbulu nkama (100), yi baakata ti «mpwumu yi a Itali». ");
INSERT INTO tyx_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nde áli mbwuru wu bunsumu ŋa nkulu a Nzaami ya ákagwa nde budziri, emõ ya baara ba nzo a nde bwohono. Nde ákabaha bawele ba ba-Dzwife ku olagha ya ákasamana Nzaami matala mwohono. ");
INSERT INTO tyx_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Etsughu nga-emõ, mu tala lili matere ŋa mbihi a embehe, nde ágyighili omono mu limono ngye-yulu a Nzaami wu áyasomo mu nzo a nde ya wu áati nde mbili ti: «Koroneye!» ");
INSERT INTO tyx_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Koroneye bu atala nde ku edzili, ábagha nzalamweẽ ya ábvuhulu nde ndiri: «Mfumu! Nki ndagha?» Ngye-yulu ályele kundaa nde ti: «Nsamana a we ya bikaba bi aakagwa we kundaa bawele, biito kundaa Nzaami, ya nde aalibili mweẽ mu we. ");
INSERT INTO tyx_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mu matala ma, gweghe bambiŋini ku Yope, buulu bayabiri we Simõ wuulu nkwumu yi obili Piere. ");
INSERT INTO tyx_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nde li mu nzo a Simõ mukimi, munde wu áakasa esala ki okagyighili bibaana bi banyama ya aakakala ku mukogho a mubu.» ");
INSERT INTO tyx_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mu matala ma ógyene ngye-yulu wu ákabili ya nde, Koroneye áti basala ba nzo a nde buolo mbili ya mbumbulu mumõ wu áali a enzaami kii ngaŋma, wuulu edzighi ákasala kunsa litumu li nde. ");
INSERT INTO tyx_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ya bu alyele bo mandagha mwohono ma ábwana a nde, nde ágweghe bo ku Yope. ");
INSERT INTO tyx_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ŋa mbihi a etsughu ekye, ŋaala bo nkini ali mu okanama bula bu nzili a bo, bo bábehene ya bvulu, ya ku bele a matala mama embehe, Piere ákumu ku yulu a see li nzo lili eyala mu oyisamana. ");
INSERT INTO tyx_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Lo nzala bu yifuru nde, nde ásagha bi-odza. Mu matala ma bákanaã nde bi-odza, nde ábagha limono. ");
INSERT INTO tyx_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nde ámono yulu bwaha: Elogho etsyini ékayakumunu. Kye éli ti anga mupa a eko wu munene wu bákwara mu manto mansa mana wu áyabwa ŋa nsie. ");
INSERT INTO tyx_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ŋa yulu a nde óli a banyama baba mawa-mawa: Banyama baba myili mina, ba baakagye mu etulu ya baŋmini. ");
INSERT INTO tyx_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ya likyi lílyele kundaa nde ti: «Piere, temene, dzwa ya dza!» ");
INSERT INTO tyx_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piere ábvuhulu ti: «Mfumu! Si kala ka bunu! Mu bumweẽ bu me, me nkini ámaandza elogho kii nyara ya ki bási ngili o.» ");
INSERT INTO tyx_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Likyi líbili kundaa nde mu sa lili ywolo ti: «Bi ootsehebe Nzaami, we, we ka kughu olyele ti bye bili bibi nyara o!» ");
INSERT INTO tyx_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ndagha oyo yímoŋono kundaa nde mansa matere, ya ŋa nseele, elogho ekye ésaabvughuru ku yulu. ");
INSERT INTO tyx_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piere ndeme ákasagha obaghala ndagha oyo yi ámono nde, lo nde ka ákakughu o. Mu matala maana mamo, baara ba ógweghe Koroneye, ba bákabulufwulu ku oli nzo a Simõ, báyato ŋa muŋma a nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bo báti nde mbili ya báfwulu kala ti Simõ wu baakata ti Piere áli munsa nzo oyo. ");
INSERT INTO tyx_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piere áli nkini mu okatsimi ndagha yi aamono nde, ya Mufulu a Ngili ályele kundaa nde ti: «Oli a babaghala batere ku ba bali mu okasagha we. ");
INSERT INTO tyx_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mu obo, kumunu lili, bvughu nzili ya bo ku ogwene a okeŋe, mu kuulu, me aangweghe bo.» ");
INSERT INTO tyx_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piere ákumunu, ábvuŋunu ya baara babo. Nde ályele kundaa bo ti: «Me ndindi. Mbwuru wu lili mu okasagha be ngu me. Mu nki ndagha be liiyatala me?» ");
INSERT INTO tyx_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bo bábvuhulu ti: «Koroneye, mfumu a mpwumu a bambumbulu nkama (100), mbwuru wu a bunsumu, wu aakagwa Nzaami budziri ya wuulu ba-Dzwife bwohono bali a bumpughulu bu bubwe mu nde, aagweghe bihi. Ngye-yulu wu a ngili aasuo kundaa nde ti nde ali faana ota we mbili ku nzo a nde mpaala agyughu mandagha ma aalyele we.» ");
INSERT INTO tyx_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Oŋo Piere ágwi bo ebini kii ogyoŋomo. Ŋa mbihi a etsughu ekye, nde ágyene ya bo nzili mo. Ndaama a baara ba bákanama nde mu Yope bágyene ya nde. ");
INSERT INTO tyx_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Etsughu etsyini kii byele, bo báyito ku Sedzare. Koroneye wu áakakebe bo, áli ayi áti baara ba dzumu li nde ya bandughu ba nde mbili. ");
INSERT INTO tyx_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Mu matala ma óyito Piere, Koroneye áyibwana a nde ya ákunu mabuo ŋa nsie a myili mi nde mu ogwa nde mboro yi a budziri. ");
INSERT INTO tyx_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lo Piere átehebe nde ya ályele ti: «Temene! Buta mehe si yini a mbwuru ndi.» ");
INSERT INTO tyx_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nde ásomo munsa nzo mu okabulubili ya nde. Omo, nde ámono baara balagha ba bábvuŋunu, ");
INSERT INTO tyx_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ya nde ályele kundaa bo ti: «Be ligyighili osoolo ti mu mikyene mi ba-Dzwife, mu-Dzwife ka li a muswa wu osa endughu ya munzyi bwunu we ogyagha nde mu nzo a nde o. Lo kundaa me, Nzaami aayasuo me ti ka lifaana omono ti mbwuru wu li a nyara bwunu we nde aatsumunu ngili. ");
INSERT INTO tyx_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Me mu obo, we bu aatumu me ngya, me aangyi kwono ku makeŋe osa. Lo mu bu, me ndzyi osoolo mu nki ndagha be liitumu me ngya.» ");
INSERT INTO tyx_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koroneye ágwi nde mvuru yi: «Bitsughu yini a bitere bimaaluru, mu tala lili matere ŋa mbihi a embehe, me aakansamana Nzaami munsa nzo a me. Ensihibi, mbwuru mutsyini wu áalaha binkuru bi bíkasehene, áyamoŋono ŋa nkulu a me, ");
INSERT INTO tyx_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ya ályele kundaa me ti: “Koroneye! Nzaami aagyughu osamana o we ya nde ka aadzimini bikaba bi aakagwa we kundaa bawele nsimi o. ");
INSERT INTO tyx_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Me mu obo, gweghe bambiŋini ku Yope mpaala bayabiri we Simõ wuulu nkwumu yi obili Piere. Nde li mu okakala mu nzo a Simõ wu aakasala esala ki okagyighili bibaana bi banyama ya aakakala ku mukogho a mubu.” ");
INSERT INTO tyx_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mu maswa, me aangweghe bambiŋini bayagwolo we, ya we aasi bubwe mu ogya kundaa bihi. Mu matala ma, bihi bwohono lili ŋa nkulu a Nzaami mu ogyughu mandagha ma oolyele we Mfumu mu oyatwoho kundaa bihi.» ");
INSERT INTO tyx_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mu obo, Piere átsughu ndagha ya ályele ti: «Mu engaŋma, me aambaghala ti Nzaami ka li a munkabala o, ");
INSERT INTO tyx_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ya ti mu bikaana byehene, nde aakakihi nswe munde wu aakagwa nde budziri ya aakasalala bunsumu bu nde. ");
INSERT INTO tyx_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nde ágweghe Ndagha a nde kundaa basi Isarayele, Nsia yi Mbwe yi a edzuunu mu Yiisu-Kriste, wu li Mfumu a baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Be lisoolo ndagha yi aabwi, nsomo ku Ngalile, ŋa nseele mu Yude lwohono, ŋa mbihi a liboghoro li ókaluo Dzã. ");
INSERT INTO tyx_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Be lisoolo bunu-a-bo Nzaami ásughu lileene li Mufulu a Ngili mu Yiisu wu a ku Nadzarete. Nde aakabulusa bubwe omo mwohono mu ákaluru nde, nde ákadzuhu bwohono ba ósi dyabulu kunsa bunkana, mu kuulu Nzaami áli ya nde. ");
INSERT INTO tyx_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ya bihi ba lili bampughulu mu esala e nde kyehene mu etsulu e nsie ki ba-Dzwife ya ku Yerusaleme. Munde wu baadzwi bo mu obaŋana ŋa yulu a kuruwa. ");
INSERT INTO tyx_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Lo Nzaami aasiili nde ŋa kara li ba bákpi mu etsughu kii bitere, ya aagwi nde muswa mu omoŋono ");
INSERT INTO tyx_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","kundaa bampughulu ba ótswama osuolo Nzaami, kundaa bihi ba liikadza ya liikaŋma ya nde, ŋa mbihi a osighili o nde ŋa kara li ba bápki. Lo ka kundaa baara bwohono o. ");
INSERT INTO tyx_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nde aagwi bihi litumu mu otsala nsia kundaa baara ya mu okala bampughulu ba ndagha yi: Me nde Nzaami aasuolo mu okala nsughu-a-lamana a baara baba mweẽ ya ba bákpi. ");
INSERT INTO tyx_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Me mu nde mibighili myehene míkabili ti: Nswe munde wu aasa kana mu nde, mu nkwumu a nde, sa abagha kolokolo a masumu ma nde.» ");
INSERT INTO tyx_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piere áli nkini mu okabili, Mufulu a Ngili ábwi ŋa yulu a bo bwohono ba bákagyughu ndagha a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ba-Dzwife ba bákasa kana ba bánama Piere, bákiŋimi mu omono ti ekaba ki Mufulu a Ngili ki oogwi Nzaami, eetsaŋama tee kundaa bikaana bibi banzyi. ");
INSERT INTO tyx_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mu kuulu, bo bákagyughu baara ba mu okabili mu mandiŋi ma bagwene osoolo bo ya okasyighi bunene bu Nzaami. Piere áfirilyele ti: ");
INSERT INTO tyx_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Baara ba baagyagha Mufulu a Ngili ti anga bihi-a-be, mbwuru kughu okahaba ti ka baboghoro bo mu madza o?» ");
INSERT INTO tyx_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nde ágwi litumu ti baboghoro bo mu nkwumu a Yiisu-Kriste. Ya bo báluomo kundaa nde afiriluhu mana bitsughu ya bo. ");
INSERT INTO tyx_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bantumu ya bandughu mu kana ba báli ku Yude bágyughu ti baara baala ka bali ba-Dzwife o, baakihi si Ndagha a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Piere bu akumu ku Yerusaleme, ba-Dzwife ba bási kana mu Yiisu báyakumunu nde ");
INSERT INTO tyx_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ya bályele kundaa nde ti: «We aasomo mu nzo a ba bágwene osomo nzo a mbaa, ya we aali ya bo!» ");
INSERT INTO tyx_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Obo me buulu Piere ásuo bo mandagha mwohono, bwunu a bu máluru: ");
INSERT INTO tyx_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Ŋa aandi me mu bvulu lili Yope, mu matala ma aakansamana me, me ámbagha limono, me áamono elogho éfi ku yulu ya ékayakumunu tee kundaa me. Kye éli ti anga mupa a eko wu munene wu bákwara mu manto mansa mana. ");
INSERT INTO tyx_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Me bu aangyili okehene kye, me aamono banyama ba nsie baba myili mina, banyama baba musuru, ba baakagye mu etulu ya ba baakapuŋumu mu yulu. ");
INSERT INTO tyx_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ya me áangyughu likyi li lílyele kundaa me ti: “Piere temene, dzwa ya dza!” ");
INSERT INTO tyx_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Me áambvuhulu ti: “Pele Mfumu! Si kala ka bunu. Mu kuulu mu bumweẽ bu me, elogho kii nyara ya ki bási ngili nkini ka émaasomo mu muŋma a me o.” ");
INSERT INTO tyx_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Mu mukubu wu a buolo, likyi lífiribili ku yulu ti: “Elogho ki oosi Nzaami kii tse-tse, we ka lyele o ti kye eli kii nyara!” ");
INSERT INTO tyx_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ndagha oyo yímoŋono kundaa me mu mansa matere. Ŋa mbihi oŋo, elogho ekye ébvughuru ku yulu. ");
INSERT INTO tyx_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Mu matala maana mamo, babaghala batere ba báfi ku Sedzare mu oyagwolo me, báyato ŋa nzo yi líli bihi. ");
INSERT INTO tyx_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mufulu a Ngili ályele me bu: “Gye ya bo, ka keŋe o.” Bandughu mu kana basemene ba baagyi ya me ŋa áli bagyene ya me. Ya bihi bwohono líisomo mu nzo a Koroneye. ");
INSERT INTO tyx_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nde ályele me bu ámono nde ngye-yulu wu áyamoŋono munsa nzo a nde ya ályele nde ti: “Gweghe bambiŋini ku Yope mpaala bayabiri Simõ wu baakata ti Piere. ");
INSERT INTO tyx_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nde sa alyele we mandagha ma maabvwuhu we ya nzo a we yohono.” ");
INSERT INTO tyx_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Me bu mbaana obili, Mufulu a Ngili ásughuru ŋa yulu a bo ti bu ásughuru nde ŋa yulu a bihi mu ebaana. ");
INSERT INTO tyx_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Oŋo, me ándibili-mweẽ mu ndagha yi ali olyele Mfumu ti: “Dzã áboghoro mu madza, lo be, be sa baboghoro be mu Mufulu a Ngili.” ");
INSERT INTO tyx_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kala ti Nzaami aagwi baara ba ekaba emõ kyini-ekye ki ágwi kundaa bihi, ŋa lísi bihi kana mu Mfumu Yiisu-Kriste, lo me na, buulu me ali nkahaba dzyi li Nzaami?» ");
INSERT INTO tyx_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bu bagyughu mandagha mamo, mikolo mi bo myehene mídzuunu ya bo básyighi Nzaami ti: «Mu engaŋma Nzaami aagwi si kundaa bikaana biili ka bili ba-Dzwife o bwehe buu ogyiŋi mayele ya obagha bumweẽ.» ");
INSERT INTO tyx_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ŋa mbihi a lipfu li Etiene, bábwi omwehẽ banga-a-kana mu Kriste kimini. Mu obo, bo bátsaŋama manto ya manto. Bo bágyene tee ku Fenisi, ku Syipere ya ku Antyose. Lo bo bákabululuo Ndagha a Nzaami yini a kundaa ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ankoho, baara babake ŋa kara li bo, basi Syipere ya basi Sirene, bu bato ku Antyose, bábwi okatsala si Nsia yi Mbwe yi a Mfumu Yiisu kundaa baara ba baakabili ndiŋi yi a Engereke. ");
INSERT INTO tyx_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kwogho e Mfumu éli ya bo, ya mutala a baara ba bákasa kana mu Mfumu ya ba bákagyiŋi mayele ákapfini ku olagha. ");
INSERT INTO tyx_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nsia oyo yíto kundaa Libwunu li Nzaami lili ku Yerusaleme, ya bo bágweghe Baranabase ku Antyose. ");
INSERT INTO tyx_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nde bu ato ya bu amono bwehe bu Nzaami, ámono esee ki elagha, ya nde ágwi bo bwohono bukyini ya ályele bo banama Mfumu mu mukolo mumõ. ");
INSERT INTO tyx_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Baranabase áli mbwuru wu mubwe, wu áalwulu mu Mufulu a Ngili ya mu kana. Me mu obo baara balagha bási kana mu Mfumu. ");
INSERT INTO tyx_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ŋa mbihi, Baranabase ágyene ku Tarese mu oyisagha Sawule. ");
INSERT INTO tyx_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bu amono nde, áyabiri nde ku Antyose. Bo bansa buolo báluhu mubvu mumõ ya Libwunu li Nzaami mu okaluo mpwumu a baara yi alagha. Me ku Antyose mu sa lili nsomo báti binduono mu nkwumu yi a bakriste. ");
INSERT INTO tyx_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mu bitsughu bibye, mibighili mífi ku Yerusaleme ya míkumunu ku Antyose. ");
INSERT INTO tyx_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mu lileene li Mufulu a Ngili, mumõ mu bo wu a nkwumu Angabuse, átemene ya ályele ti munzyala sa agya mu nsie nsyini. Ya munzyala munde ágyi mu matala ma óli Kolode Mukogho. ");
INSERT INTO tyx_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mu obo, binduono bígwolo munkaana wu ogweghe libaha kundaa bandughu mu kana ba báli ku Yude, bwunu a bu óli bupfulu bu nswe mbwuru. ");
INSERT INTO tyx_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bo bási obo, bágweghe bikaba bibye kundaa bakwuru. Bo bágwi bye ŋa myaã mi Baranabase ya Sawule. ");
INSERT INTO tyx_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mu matala mamo, mukogho Erode ábaana omwehẽ ndaama mu baara ba Libwunu li Nzaami kimini. ");
INSERT INTO tyx_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Mu litumu li nde, bádzwi Dzake, naana a Dzã mu lipee. ");
INSERT INTO tyx_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nde bu amono ti ndagha oyo yíkagwa ba-Dzwife esee, nde áfirigwa litumu basyimi Piere mu bitsughu bibi kyiri kii mampa ma magwene a pfini. ");
INSERT INTO tyx_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bu basyimi ya balo nde mu boloko, Erode ási bikuru bina bibi bambumbulu bana-bana mu okakebe Piere. Dzyi li Erode áli ti nde asa Piere muyala ŋa mihi mi baara bwohono ŋa mbihi a kyiri kii Paake. ");
INSERT INTO tyx_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piere áli mu boloko, lo Libwunu li Nzaami líkasamana matala mwohono mu nkooro a nde. ");
INSERT INTO tyx_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Mu mpyibi yi oto mu etsughu ki ókaasa Erode Piere muyala, Piere ágyoŋomo ensama ŋa kara li bambumbulu buolo. Bákuru nde misyi mimi bisyeẽ, ya bankyele ba boloko bátemene ŋa muŋma a nzo. ");
INSERT INTO tyx_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Lo ngye-yulu a Mfumu áyapala ya otsyeme kuu mpini ómoŋono munsa boloko. Nde ákaha Piere mu mbambaha a mbee, ásiili nde ya ályele ti: «Saana, temene!» Misyi mimi bisyeŋe mi bákuru nde míbwi. ");
INSERT INTO tyx_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ngye-yulu ályele kundaa nde ti: «Kuru muswele a we mu bala ya kuru misyi mi mapaapa ma we!» Ngye-yulu áfiribwehe ti: «Laha enkuru e we ki ela kii kobo ya nama me.» ");
INSERT INTO tyx_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piere ápala ŋa mbihi a nde. Nde ka ákasoolo o ti mandagha ma ókasa ngye-yulu áli mama ngaŋma. Nde bu ákatsimi ti lilo áli limono. ");
INSERT INTO tyx_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bo báluru bankyele baba nsomo, ŋa mbihi baba buolo, ya báto ŋa muŋma a nzo wu a esyeŋe wu aakapaha kunsa bvulu. Muŋma a nzo ádzubulu ndeme ŋa nkulu a bo. Bu bato ku mbala, bo bágyene ku nto a nkwulu, ya ensihibi, ngye-yulu ásihi Piere. ");
INSERT INTO tyx_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Oŋo embwuru bu eyabvughuru Piere, nde ályele ti: «Mu matala ma me nsoolo mu engaŋma ti me Mfumu aagweghe ngye-yulu a nde mu kuulu akwulu me ŋa myaã mi Erode ya mu mandagha mwohono ma ookeene ekaana ki ba-Dzwife osa mu me.» ");
INSERT INTO tyx_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Bu abaghala ndagha oyo, nde ágyene ku nzo a Mari, ngughu a Dzã, wu baakata ti Mareke. Baara balagha áli babvuŋunu omo mu okasamana. ");
INSERT INTO tyx_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piere bu akoboro ŋa muŋma a nzo, musala mutsyini wu mutughu, nkwumu a nde Rode, ágyi mu oyagyuulu. ");
INSERT INTO tyx_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nde bu agyughu likyi li Piere, mu esee, nde ka ádzubulu edzughubu e nzo o, lo nde ábara ya áyilyele kundaa bana ndiri, Piere li ŋa muŋma nzo. ");
INSERT INTO tyx_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bo bályele kundaa nde ti: «We lala byele!» Lo nde ágyighili onyeme ti ngaŋma, nde áli ŋa muŋma a nzo. Ya bo bábvuhulu ti: «Lo munde ngye-yulu a nde.» ");
INSERT INTO tyx_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Piere ási enziini mu okakoboro. Bo bákarayadzubulu, ya bákiŋimi ku olagha mu omono nde. ");
INSERT INTO tyx_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nde ákahaba bo banyaã osa nkele, ályele kundaa bo bu oopaha nde Mfumu mu boloko ya áfiribwehe bu: «Liyitwoho nsia kundaa Dzake ya kundaa bandughu mu kana babake.» Ya nde ámara oŋo, ágyene nto nkimi. ");
INSERT INTO tyx_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Bwihi bu buki, mpaatsala yíbwi ŋa kara li bambumbulu, bo bákabili bo-a-bo ti: «Bu Piere bunu aabwana?» ");
INSERT INTO tyx_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erode ásagha ti bayabiri nde Piere, lo ka bámono nde o. Báfwulu bankyele ya bágwi litumu ti badzwa bo. Ŋa nseele, Erode ákumunu ku Yude, ágyene ku Sedzare ya áluhu mana bitsughu oko. ");
INSERT INTO tyx_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erode áli a nkehe yi alagha ya baara baba mabvulu mama Tire ya Sidõ. Baara babo bágwihini mu oyimoŋono ŋa nkulu a nde. Bo bápeene a Balasito, musala a mukogho mu mi miikatala ngwumu a nde, bo baluomo edzuunu kundaa Erode, mu kuulu mansie ma bo mákabagha bi-odza ku nsie a nde. ");
INSERT INTO tyx_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Etsughu ki bási lagha bu eto, Erode wu álaha enkuru e nde kii bukogho, ábwi-nsini ŋa ebini kii muyala ya ábwi obili mu likyi lili mpini kundaa bo ŋa nkulu a baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Baara bábwi ofulu miluolo ti: «Likyi li, likyi li nzaami, lo ka lili lili mbwuru o!» ");
INSERT INTO tyx_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ŋaana oŋo, ngye-yulu a Mfumu ákaha Erode, mu kuulu nde ka ágwi nsia kundaa Nzaami o. Ya misere míli Erode, nde ákpi. ");
INSERT INTO tyx_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nsia a Ndagha a Nzaami yíkatsaŋama ya ba bákasa kana bákapfini. ");
INSERT INTO tyx_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Lo Baranabase ya Sawule bu bamana esala e bo osa mu nkooro a baara baba Yerusaleme, bábvughuru. Bo bábiri Dzã wuulu nkwumu yi obili Mareke. ");
INSERT INTO tyx_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mu Libwunu li Nzaami li líli ku Antyose, óli a mibighili ya miluo: Baranabase, Simeõ wu baakata ti Ndoomo, Lusiyuse musi Sirene, Manahene wu bákwuhu emõ ya Erode, mfumu a etsulu e nsie, ya Sawule. ");
INSERT INTO tyx_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Etsughu nga-emõ, bo bu bákasamana Mfumu ya bákuru nswele mu bala, Mufulu a Ngili ályele kundaa bo ti: «Litwulu, mu nkooro a me, mu libee Baranabase ya Sawule mu esala ki ánti me bo mbili.» ");
INSERT INTO tyx_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Oŋo, bu bamana osamana ya okuru nswele mu bala, bo bánaã bo myaã ŋa yulu a mutswi ya bányaã bo bagye. ");
INSERT INTO tyx_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mufulu a Ngili bu agweghe bo, bo bákumunu ku bvulu lili Selesi ku bágwolo bo bwara bu bunene mu ogye ku elyi kii Syipere. ");
INSERT INTO tyx_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bu bato ŋa bvulu lili Salamine, bo bátsala nsia a ndagha a Nzaami munsa manzo mama lisamana ma ba-Dzwife. Dzã-Mareke áli ya bo mu okabulubaha bo. ");
INSERT INTO tyx_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bu bamana osaghaba elyi kyehene tee ku bvulu lili Pafose, bo bábwana a mu-Dzwife mumõ nga-a-mpaana, mubighili wu a mpya, nkwumu a nde Bare-Yiisu. ");
INSERT INTO tyx_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nde áli emõ ya ba bali mpiŋi ya Serengyo Poole, mfumu a elyi, mbwuru nga-a-mayele. Nde áti Baranabase ya Sawule mbili, mu kuulu nde áli a nzala a ogyughu ndagha a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lo Elimase, nga-a-mpaana, mu kuulu oyo me mbaala a nkwumu a nde, ákasagha okahaba bo mu kuulu nde ka ákadzyi o ti mfumu Serengyo Poole asa kana mu ndagha a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mu obo Sawule, wu bákata si ti Poole, wu áalwulu mu Mufulu a Ngili, átuunu Elimase mihi ");
INSERT INTO tyx_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ya ályele kundaa nde ti: «We aalwulu mu mpya ya mu mayele mama pfyibi, mwana a dyabulu, mutaara a bunsumu. We ka nyaã okagwini manzili ma Mfumu ma mali nsumu o? ");
INSERT INTO tyx_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mu matala ma, gyughu: Mfumu we àasyeme. We sa kala enkpa-mihi mu mana matala, we ka afirimono tala o.» Ŋaana oŋo libwi ya mpyibi yi a laŋa-laŋa bíbwi mu nde, ya nde ábwi okadzeŋene mu osagha mbwuru wu akwara nde mu kwogho ya osuo nde nzili. ");
INSERT INTO tyx_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mu matala ma ómono mfumu Serengyo mandagha ma mábwi, nde ási kana ya ákiŋimi ku olagha mu maluo ma Mfumu. ");
INSERT INTO tyx_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Poole ya bandughu ba nde básomo bwara ŋa Pafose, bo bágyene ku bvulu lili Perenge mu etsulu e nsie kii Pamfili. Oko, Dzã-Mareke ákaghaba ya bo ya ábvughuru ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lo Poole ya Baranabase, bu bamara Perenge, bánama nzili a bo ya báto ku bvulu lili Antyose lili mu etsulu e nsie kii Pisidi. Mu etsughu kii sabate, bo básomo mu nzo a lisamana a ba-Dzwife ya bábwi nsini. ");
INSERT INTO tyx_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bu bamana otaã mikaana mi Mikyene mi Moyidze ya mimi Mibighili, bamfumu ba nzo a lisamana a ba-Dzwife bályele kundaa bo ti: «Bandughu mu kana, kala ti be lili a ndagha yi ogwa baara bukyini, lo libili mu matala ma!» ");
INSERT INTO tyx_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Poole bu atemene, áseene kwogho, ya ályele ti: «Basi Isarayele, ya be babake ba liikagwa Nzaami budziri, ligyughu me! ");
INSERT INTO tyx_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nzaami a ekaana kii Isarayele ásuolo bataara ba bihi. Nde ási ti ekaana epfini mu matala ma éli kye ku nsie a Edzipite. Ya nde ápaha kye omo mu lileene li kwogho e nde. ");
INSERT INTO tyx_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Mu mibvu ku bele a makwumu-mana (40), nde ábuŋunu bo. ");
INSERT INTO tyx_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ŋa mbihi, nde bu amana odzwa baara baba mansie nsaama ba báli ku Kaana, nde ágwi bo mansie mamo ti pfa. ");
INSERT INTO tyx_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mandagha mwohono mamo mágyili ku bele a bamvulu nkama na ya makwumu-mataana (450).» «Ŋa mbihi, Nzaami ágwi bataara ba bihi bansughu-a-lamana ba ekaana tee mu matala ma mubighili Samwele. ");
INSERT INTO tyx_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ŋa nseele, bo báluomo mukogho, ya Nzaami ágwi bo Sawule, mwana a Kise, mu dzumu li Benzamẽ. Nde átumu mu bamvulu makwumu-mana (40). ");
INSERT INTO tyx_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ya Nzaami bu amaha nde, ábyaha Dabvide mu okala mukogho a bataara ba bihi. Me kundaa nde Nzaami ásuo bumpughulu ba: “Me aansuolo Dabvide, mwana a Yese, mbwuru wu li mu okadzyara bu ookadzyi mukolo a me. Nde sa agyighili mandagha mwohono ma aangwaa me”. ");
INSERT INTO tyx_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Me mu musyi a dzumu li nde, Nzaami ápaha Yiisu, Mubvwuhu a Isarayele, ti bwunu a bu óli misiini mi nde. ");
INSERT INTO tyx_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Nsomo Yiisu agya, Dzã ákata mukwughu kundaa basi Isarayele bwohono mu obagha liboghoro lili ogyiŋi mayele. ");
INSERT INTO tyx_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ya mu matala ma ákagye nde ku omana esala, nde ályele ti: “Mu bitsimi bi be, me nande ndi? Pele, me ka ndi munde wu lili mu okakebe be o! Lo ligyughu, nde li mu ogya ku mbihi a me, me ka nkughu onyana misyi mi bikoghoro bi nde o”». ");
INSERT INTO tyx_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Bandughu ba me mu kana, baana ba musyi a dzumu li Abarahame, ya be ba lili ŋa kara li bihi ba baakagwa Nzaami budziri, me kundaa bihi-a-be bágweghe ndagha yi obvwughu yi. ");
INSERT INTO tyx_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mu engaŋma, baara ba Yerusaleme ya bamfumu ba bo ka baabaghala ti Yiisu nande ali o, bu baasi nde muyala, obo me bu baakuhu mandagha ma mibighili ma baakataã mu etsughu kii sabate. ");
INSERT INTO tyx_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Si buulu bo ka bábagha ebili kii odzwa nde o, lo bo báluomo kundaa Pilate ti badzwa nde. ");
INSERT INTO tyx_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bo bámana okuhu mandagha mwohono ma básono mu nde, básurulu nde ŋa kuruwa ya bátwulu nde munsa mpyeme. ");
INSERT INTO tyx_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lo Nzaami ásiili nde ŋa kara li ba bápki». ");
INSERT INTO tyx_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","«Mu bitsughu bilagha, nde ákamoŋono kundaa babo ba bákumu ya nde obaana ku Ngalile tee ku Yerusaleme. Mu bu, bo bali bampughulu ba nde ŋa nkulu a baara. ");
INSERT INTO tyx_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ya bihi, bihi lili mu oluo Nsia yi Mbwe oyo: Misiini mi bágwi kundaa bataara ba bihi, ");
INSERT INTO tyx_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nzaami aagyighili okuhu mye kundaa bihi, baana ba bo, mu matala ma aasiili nde Yiisu ŋa kara li ba bákpi, ti bwunu a bu básono mu Ekwumu kii byele ti: “We li Mwana a me wu baghala, Me me aamburu we, etsughu kii lolo”». ");
INSERT INTO tyx_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Nzaami ásiili nde ŋa kara li ba bákpi, mu kuulu anyaã obolo, obo me bu ályele nde ti: “Me sa ngwa be bibi ngili bi bafaana osa kana mu bye, bi ánsiini a me Dabvide”». ");
INSERT INTO tyx_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«Me mu obo, nde áfirilyele ŋa ebini ekimi ti: “We ka nyaã Wu a ngili a we abolo o”». ");
INSERT INTO tyx_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«Ankoho, mu eseene e nde, Dabvide ákasalala mandagha ma ókadzyi Nzaami. Ŋa mbihi oŋo, nde ákpi, bádzyighi nde ŋa bele a bataara ba nde ya nde ábolo. ");
INSERT INTO tyx_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Lo munde wu oosiili Nzaami mu lipfu, ka aabolo o.» ");
INSERT INTO tyx_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«Bandughu mu kana, lisoolo ti, me mu nde baagwi be nsia a kolokolo a masumu ya mandagha mwohono maala Mikyene mi Moyidze ka mísi be baba bunsumu o. ");
INSERT INTO tyx_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Lo nswe munde wu aasa kana mu nde sa akala wu bunsumu. ");
INSERT INTO tyx_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mu obo, lisa mayele, mu kuulu mandagha ma ósono mibighili manyaã obwa mu be.» Mandagha mamo me ma: ");
INSERT INTO tyx_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","«Litala, be ba lili a ligwagha, likiŋimi ya lidzimini! Mu kuulu me sa ngyighili ndagha mu bitsughu bi bumweẽ bu be, ndagha yiili be ka likughu osa kana mu yo o, kala ti mbwuru lyele be yo!» ");
INSERT INTO tyx_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ŋa ópala ba Poole ya Baranabase mu nzo a lisamana a ba-Dzwife, bábuono bo mu ofiriyabili mu mandagha maana mamo mu etsughu kii sabate kii yulu. ");
INSERT INTO tyx_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ŋa mbihi a ŋa bábvuŋunu bo, ba-Dzwife balagha ya ba baakasamana Nzaami a bo bánama Poole ya Baranabase. Bo bákamoŋo ya bo, ya bákagwa bo bukyini mu onabara bwehe bu Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Etsughu kii sabate bu eto, baara ba bvulu lwohono bábvuŋunu mu ogyughu Ndagha a Mfumu. ");
INSERT INTO tyx_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ba-Dzwife bu bamono mpwumu a baara oyo, bálwulu mu musogho ya bábwi okaala mandagha ma ókaluo Poole embihi ya bákatughu nde. ");
INSERT INTO tyx_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Poole ya Baranabase mu kana, bályele kundaa bo ti: «Kundaa be bákaatswama otuoho Ndagha a Nzaami! Mu kuulu be lili mu okabihi yo, ya lili mu okalamana beme ti, be ka likughu obagha laama lili mibvu ya mibvu o. Mu matala ma bihi sa ligye kundaa baala ka bali ba-Dzwife o. ");
INSERT INTO tyx_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mu kuulu, Mfumu aagwi bihi litumu ti: “Me aansuolo we mu okala otsyeme o mansie mwohono, mpaala we biri obvwughu tee ku osughu nsie.”» ");
INSERT INTO tyx_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Baala ka bali ba-Dzwife o bu bagyughu mandagha mamo, bálwulu mu esee ya bábwi osyighi ndagha a Mfumu. Ya babo ba básuolo mu obagha laama lili mibvu ya mibvu bási kana. ");
INSERT INTO tyx_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ndagha a Mfumu yítsaŋama mu etsulu e nsie kyehene. ");
INSERT INTO tyx_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lo ba-Dzwife bákatsiini bakaha baba budziri ba baakabuono Nzaami, ya baara baba mupfunu mu bvulu lilo, basa ngirini. Bo bási obo mu kuulu bamwehẽ Poole ya Baranabase kimini, ya babyi bo mu nsie a bo. ");
INSERT INTO tyx_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bo bu bakubulu lifufunu li myili mi bo, bágyene ku bvulu lili Ikonyome. ");
INSERT INTO tyx_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Lo binduono bibi mu Antyose bílwulu mu esee ya mu Mufulu a Ngili. ");
INSERT INTO tyx_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ku Ikonyome, Poole ya Baranabase bágyene ku nzo a lisamana a ba-Dzwife. Oko, bo báluo Ndagha a Nzaami mu eteese kiili mpwumu a ba-Dzwife ya ba-Ngereke yi alagha yísi kana. ");
INSERT INTO tyx_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lo ba-Dzwife ba bábihi osa kana, bátsiini ba bagwene osoolo Nzaami mu osa bandughu mu kana bubi. ");
INSERT INTO tyx_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Lo, Poole ya Baranabase báluhu matala malagha oko. Bo bákabili ya kana mu mi mitala Mfumu. Mfumu ákagwa bo lileene lili ógyighili mandagha maa okiŋimi ya bilyimi. Obo me bu ákasuo nde ti, mandagha ma bákalyele bo mu mi mitala bwehe bu nde máli ngaŋma. ");
INSERT INTO tyx_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mpwumu a baara ba bvulu yíkaghaba mu mawa muolo: Ba bamo ku ngulu yi a ba-Dzwife, babake ku ngulu yi a bantumu. ");
INSERT INTO tyx_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Baara baala ka bali ba-Dzwife o ya ba-Dzwife, emõ ya bamfumu ba bo, bábagha bitsimi bii omwehẽ Poole ya Baranabase kimini ya odzwa bo mu mameẽ. ");
INSERT INTO tyx_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bo bu basoolo bitsimi bibye, bábara ku mabvulu mama Lisitere ya Derebe mu etsulu e nsie kii Likawoni, ya mu mala ma máli bitaataa bibye. ");
INSERT INTO tyx_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Oko si, bo bákatsala Nsia yi Mbwe. ");
INSERT INTO tyx_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ku Lisitere óli a baghala mumõ wu ókpi myili, wu áabwi nsini. Epfwumu e nde ekye éli emburu-ngughu ya nde áli nkini ka ámaadzyara o. ");
INSERT INTO tyx_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Etsughu nga-emõ, nde ákagyughu Poole mu okabili. Poole bu atuunu nde mihi, ya bu amono ti nde áli a kana mu obvwughu, ");
INSERT INTO tyx_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","nde ályele mu likyi lili mpini ti: «Temene nsumu mu myili mi we!» Nde ádzuŋumu, ya ábwi odzyara. ");
INSERT INTO tyx_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mampwumu ma baara bu mamono ndagha yi ógyighili Poole, mályele mu mpini mu ndiĩ yi a Likawoni ti: «Banzaami baakighiri baara ya baayasughuru kundaa bihi.» ");
INSERT INTO tyx_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bo bákata Baranabase mu nkwumu yi a Dzeese ya Poole mu nkwumu yi a Eremese, mu kuulu me Poole áakabili mu nkwumu a bo bansa buolo. ");
INSERT INTO tyx_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nzo a lisamana yi a ngaa a nzaami a Dzeese yíli ku baakayasomo bvulu. Nde ágwolo balumu ba bangoomo ya álaha bo bibara bibi bifulu. Emõ ya mpwumu a baara, bo bákadzyi odzwa bo mu ogwa mukaba kundaa Poole ya Baranabase. ");
INSERT INTO tyx_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Lo bantumu Poole ya Baranabase bu bagyughu ndagha oyo, bákaghala binkuru bi bo, básomo mu ntyini ŋa kara li mpwumu mu okaŋaã ");
INSERT INTO tyx_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ya bákalyele ti: «Bandughu, be yi nsa ndagha lili mu okagyighili? Bihi si lili baara ti anga be! Nsia yi Mbwe yi lili mu okatsala bihi kundaa be, yili mu oluomo be lisihi mandagha ma magwene a mupfunu ma, mu okaghala kundaa Nzaami wu a mweẽ wu aagyighili yulu, nsie, mubu, ya byehene bi bili omo. ");
INSERT INTO tyx_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Me nde wuulu mu biseene bi bíluru, ágwi muswa kundaa bikaana byehene bikagyighili bu bidzyi bye. ");
INSERT INTO tyx_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Lo, nde aakagyighili ma mabwe kundaa be, mu kuulu mu yulu, nde aakanohõ bamvulu ya aakagwa mando ma maakaburu be bimburu bi bilagha, mpaala be libagha bi-odza ya mikolo mi be milwulu mu esee.» ");
INSERT INTO tyx_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Lo, si mu mbiili a bo oyo, mu mpara Poole ya Baranabase báleene okahaba mpwumu a baara mu ogwa bo mukaba. ");
INSERT INTO tyx_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ba-Dzwife ba báfi ku Antyose ya ku Ikonyome bu bágyi, bápeene a mpwumu a baara mu bitsimi bi bo. Bo bákaha Poole mameẽ, bákwolo ya bápaha nde ku mbala a bvulu, mu kuulu, bo bátsimi ti nde ákpi. ");
INSERT INTO tyx_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Lo binduono bu bibvuŋunu, bídzyi Poole, nde átemene ya ábvughuru munsa bvulu. Ŋa mbihi a etsughu ekye, nde ya Baranabase bágyene ku bvulu lili Derebe. ");
INSERT INTO tyx_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bu bamana otsala Nsia yi Mbwe munsa bvulu lili Derebe, ya bu babagha binduono bilagha omo, bo bábvughuru ku Lisitere, Ikonyome ya Antyose. ");
INSERT INTO tyx_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Poole ya Baranabase bákagwa binduono mpama ya bákaluomo bo bakala a mukama mu osa kana, ya bákalyele ti: «Bihi lifaana omono mpara yi alagha mu osomo mu Emfumu e Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mu nswe Libwunu, Poole ya Baranabase básuolo bakwuru. Bu bakuru nswele mu bala, básamana Nzaami ya bágwi bo ŋa myaã mi Mfumu munde wu bási bo kana. ");
INSERT INTO tyx_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ŋa nseele, bo báluru mu etsulu e nsie kii Pisidi ya báto ku etsulu e nsie kii Pamfili, ");
INSERT INTO tyx_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","bátsala nsia a Ndagha a Nzaami ku Perenge, ya bákumunu ku bvulu lili Atali. ");
INSERT INTO tyx_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Bu bamara oko, bo básomo bwara mu ogye ku Antyose, oko ku báluomo mu bo bwehe bu Nzaami, mu esala ki bákuhu bo ki. ");
INSERT INTO tyx_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Bu bayato ku Antyose, bo bábvughu Libwunu ya bályele mandagha mwohono ma ógyighili Nzaami mu bo, ya bu ádzubulu nde nzili a kana kundaa babo baala ka bali ba-Dzwife o. ");
INSERT INTO tyx_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bo báluhu matala ma malagha ya binduono. ");
INSERT INTO tyx_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ndaama a baara baba ku Yude, bákumunu ku bvulu lili Antyose, bákaluo Libwunu, ya bákalyele ti: «Kala ti ka basohobo be nzo a mbaa o, ti bwunu a bu ookatumu Mikyene mi Moyidze, be ka likughu obvwughu o.» ");
INSERT INTO tyx_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Poole ya Baranabase bábihi ogyughu baara babo ba bágyi, ya mumbaŋana wu a mpini ábwi ŋa kara li bo. Bo bákuru etsimi ti Poole, Baranabase ya mana a babaghala babake ba bágyi, bákumu ku Yerusaleme kundaa bantumu ya bakwuru ba Libwunu, mu mi mitala ndagha a mumbaŋana munde. ");
INSERT INTO tyx_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Libwunu lígwi bo bilogho bi baabiri. Bu baluru mu nsie yi a Fenisi ya yi a Samari, bo bákabululyele bunu-a-bo baala ka bali ba-Dzwife o bákagyiŋi mayele. Ya bandughu mu kana bwohono báli kunsa esee ki elagha. ");
INSERT INTO tyx_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bo bu bato ku Yerusaleme, bandughu mukana bwohono, bantumu ya bakwuru bábwana a bo. Ya bo bágwi bo nsia a mandagha mwohono ma ókabulugyighili Nzaami mu bo. ");
INSERT INTO tyx_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lo ndaama a baara ba báli mu emvuŋunu ki ba-Faridzyẽ nsomo basa kana, bátemene ya bályele ti: «Bafaana osohobo baala ka bali ba-Dzwife o nzo a mbaa ya otumu bo bakakebe Mikyene mi Moyidze». ");
INSERT INTO tyx_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bantumu ya bakwuru bábvuŋunu mu otala ndagha oyo. ");
INSERT INTO tyx_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Buulu mumbaŋana áli ayi wu a mpini, Piere átemene ya ályele kundaa bo ti: «Bandughu ba me mu kana, be lisoolo ti edzighi Nzaami ásuolo me ŋa kara li be, mu kuulu me ntsala Nsia yi Mbwe kundaa baala ka bali ba-Dzwife o, mpaala bo basa kana. ");
INSERT INTO tyx_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ya Nzaami wu gyahaba mikolo mi baara, li mpughulu a bo, bu aagwi Mufulu a Ngili kundaa bo ti bwunu a bu ágwi nde bihi, ");
INSERT INTO tyx_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ku ogwene osa lisoghobo ŋa kara li bo ya bihi-a-be. Nde aatsehebe mikolo mi bo mu kuulu bo baasi kana. ");
INSERT INTO tyx_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mu matala ma, mu emakye be lidzyi otsihi Nzaami bu liikwighi binduono leme, liili ngu okala bataara ba bihi, ngu okala bihi bameme, ka liibagha mpini yi obiri lo o? ");
INSERT INTO tyx_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Lo bihi lili a kana ti bihi sa libvwughu mu bwehe bu Mfumu Yiisu, bumõ si kundaa bo!» ");
INSERT INTO tyx_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Baara bwohono bákala pii ya bákagyughu Baranabase ya Poole ba bákabili mu bilyimi ya mandagha mama okiŋimi bi ógyighili Nzaami mu esala e bo ŋa kara li babo baala ka bali ba-Dzwife o. ");
INSERT INTO tyx_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bo bu bamana obili, Dzake ályele ti: «Bandughu ba me mu kana, ligyughu me! ");
INSERT INTO tyx_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simeõ aalyele bihi-a-be bunu obaana mu ebaana, Nzaami ási ŋa kara li bikaana biili ka bíli ba-Dzwife o mu osuolo bye bikala baara ba bandaa nde. ");
INSERT INTO tyx_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ya mandagha ma, mali mu ogye mu mana ya mandagha ma mibighili.» Mu kuulu básono ti: ");
INSERT INTO tyx_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","«Ŋa mbihi a mamo, me sa yambvughuru, me sa firintwu ebvulu e Dabvide ki eebwi, me sa firingyili bibwa bi kye, ya sa me firimbvurulu kye mu mutele. ");
INSERT INTO tyx_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Mu obo, baara babake ba basyili basagha Mfumu, ya bumõ si kundaa bikaana byehene bi aanti me mbili mu okala bibi ndaa me. Obo me bu olyele Mfumu, wu aakagyighili mandagha mwohono. ");
INSERT INTO tyx_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ma basoolo, obaana edzighi.» ");
INSERT INTO tyx_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«Me mu obo me ntsimi ti bubwe mu onyaã omwehẽ mpara baala ka bali ba-Dzwife o ba baasi kana mu Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Lo lisono bo mukaana ti banyaã osuŋumu mu odza tuo li banyama ba baagwi mikaba kundaa banzaami baba bityeghe, banyaã okasa enkwunu, ya banyaã odza tuo lili banyama ba baakpi mbiili o. Bo ka bafaana odza si makili o. ");
INSERT INTO tyx_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mu kuulu, obaana mu biseene bi bikulu, mu nswe bvulu oli a ba baakaluo Mikyene mi Moyidze. Bo baakatala mye mu nswe etsughu kii sabate mu manzo ma lisamana ma ba-Dzwife.» ");
INSERT INTO tyx_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Oŋo, bantumu ya bakwuru, ya Libwunu lwohono, bágwihini mu osuolo baara ŋa kara li bo, ba baagweghe ku Antyose emõ ya Poole ya Baranabase. Bo básuolo Yuda, wu baakata ti Baranabase ya Silase, baara baba budziri ŋa kara li bandughu mu kana. ");
INSERT INTO tyx_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bágwi bo mukaana wu básono ti: «Bantumu, bakwuru ya bandughu mu kana bagwi mboro kundaa baala ka bali ba-Dzwife o, ba bali ku Antyose, ku Siri ya ku Silisi. ");
INSERT INTO tyx_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bihi liigyughu ti baara bana ŋa kara li bihi, baala bihi ka liigwi bo litumu o, baayasa be mikolo maŋa-maŋa ya baagwi be nzalamweẽ mu mbiili a bo. ");
INSERT INTO tyx_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Me mu obo bihi bwohono liikuru mfwunu ya liimono ti ali bubwe bihi lisuolo baara ba liigweghe bihi kundaa be, nzili mõ ya bandughu ba bihi baba mukolo Baranabase ya Poole, ");
INSERT INTO tyx_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","babo ba bágwi laama li bo mu osalala nkwumu a Mfumu a bihi Yiisu-Kriste. ");
INSERT INTO tyx_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Mu obo, bihi liigweghe be Yuda ya Silase mu kuulu bo bayalyele be mandagha ma liisono bihi mu mukaana. ");
INSERT INTO tyx_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Mufulu a Ngili ya bihi bameme si, liimono ti ali bubwe mu onyaã okwighi be maleme makimi, ŋa yulu a yini a mandagha maala ka makughu ogweene o. ");
INSERT INTO tyx_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mandagha mamo me ma: Ka likadza banyama ba baagwi mikaba kundaa banzaami baba bityeghe o. Ka likadza makili o, ka likadza banyama ba baakpi mbiili o, ya ka likasa enkwunu o. Kala ti be liikakebe manyuru ma be, lo be liikasa bubwe. Likala bubwe!» ");
INSERT INTO tyx_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bányaã babo ba básuolo mu okumunu ku Antyose bagye, ya bo bágyene. Oko, bo bábvughu libwunu ya bágwi bo mukaana. ");
INSERT INTO tyx_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bu bataã mukaana, bo bámono esee mu nkooro a mpama yi ákagwa nde bo. ");
INSERT INTO tyx_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda ya Silase, ba báli bomo mibighili, bábili ku olagha ya bágwi bo mpama ya mpini. ");
INSERT INTO tyx_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ya bu baluhu mana matala oko, bandughu mu kana bábvurulu bo mu edzuunu kundaa ba bágweghe bo. ");
INSERT INTO tyx_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Lo, Silase ámono ti ali bubwe nde asyili oko. ");
INSERT INTO tyx_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Poole ya Baranabase básyili ku Antyose. Emõ ya baara balagha babake, bo bákaluo ya bákatsala nsia yi mbwe yi a ndagha a Mfumu. ");
INSERT INTO tyx_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ŋa mbihi a mana bitsighu, Poole ályele kundaa Baranabase ti: «Tswe libvughuru liyitala bandughu mu kana mu mabvulu mwohono, mu líitsala bihi a we nsia a Ndagha a Mfumu, mu kuulu limono bu bali mu okadzyara bo.» ");
INSERT INTO tyx_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Baranabase ákadzyi obiri ya bo Dzã wu baakata Mareke. ");
INSERT INTO tyx_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Lo Poole ámono ti ali bubwe mu ogwene ogwolo nde emõ ya bo, mu kuulu nde áli akaghaba ya bo ku Pamfili ya ka ágyene nzili mo ya bo o mu oyisa esala. ");
INSERT INTO tyx_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mumbaŋana wu a mpini ábwi ŋa kara li bo ya bo bákaghaba. Baranabase ágwolo Mareke, básomo mu bwara bu bunene ya bágyene ku Syipere. ");
INSERT INTO tyx_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Poole ásuolo Silase ya bo bágyene. Lo nsomo bagye, bandughu mu kana báluomo ti bwehe bu Mfumu bukala ya bo. ");
INSERT INTO tyx_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ya nde áluru mu mansie mama Siri ya Silisi, mu okabulugwa mabwunu mpini. ");
INSERT INTO tyx_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Poole áyito ku Derebe, ŋa nseele nde ágyene ku Lisitere. Oŋo óli a enduono emõ kii nkwumu Timote, mwana a mukaha wu mu-Dzwife, wu áasi kana mu Mfumu. Lo taara a nde áli mu-Ngereke. ");
INSERT INTO tyx_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bandughu mu kana baba mu mabvulu mama Lisitere ya Ikonyome bákasuo bumpughulu bu bubwe mu nde. ");
INSERT INTO tyx_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Poole ákadzyi obiri nde. Ya bu agwolo nde, ásohobo nde nzo a mbaa, mu nkooro a ba-Dzwife ba báli mu bitsulu bi nsie bibye, mu kuulu bo bwohono áli basoolo ti taara a nde áli mu-Ngereke. ");
INSERT INTO tyx_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ya mu mabvulu ma bákaluru bo, Poole ya Silase bákatuoho kundaa bandughu mu kana mandagha ma ókuru bantumu ya bakwuru ba libwunu lili ku Yerusaleme. Ya bo bákaluomo kundaa banga-a-kana mu onama mo. ");
INSERT INTO tyx_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mabwunu mákagwama mu kana, ya nswe etsughu, mo mákapfini mu mutala a baara. ");
INSERT INTO tyx_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Buulu Mufulu a Ngili, ákahaba bo banyaã otsala nsia a Ndagha a Nzaami mu etsulu e nsie kii Adzi, Poole ya Silase bábululuru mu bitsulu bi nsie bibi Firingi, ya bibi Ngalate. ");
INSERT INTO tyx_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bo bu babehene ku etsulu e nsie kii Misi, bo básagha ogye ku etsulu e nsie kii Bitini, lo Mufulu a Yiisu ka ágwi bo muswa o. ");
INSERT INTO tyx_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mu obo, bo bábululuru mu etsulu e nsie kii Misi, ya bákumunu ku mbwuu yi a mu bvulu lili Torowase. ");
INSERT INTO tyx_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Etsughu nga-emõ mu mpyibi, Poole ámono mu limono, musi Masedwane átemene ya ákabuono nde ti: «Bululuru mu etsulu e nsie kii Masedwane, ya baha bihi!» ");
INSERT INTO tyx_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ŋa mbihi a limono li Poole lilo, bihi líisagha obaagye ku Masedwane, mu kuulu bihi líili a kana ti Nzaami áakata bihi mbili mu oyitsala Nsia yi Mbwe oko. ");
INSERT INTO tyx_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Bu lisomo mu bwara ŋa Torowase, bihi líigyene nsumu ku elyi kii Samotarase. Ya etsughu ki énama ŋa mbihi, bihi líigyene ku bvulu lili Neyapolise. ");
INSERT INTO tyx_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ya bu limara oŋo, bihi líigyene ku Filipe, bvulu li libvulu mupfunu mu etsulu e nsie kii Masedwane, ki éli kunsa litumu li ba-Romẽ. Bihi líiluhu mana bitsughu munsa bvulu lilo. ");
INSERT INTO tyx_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mu etsughu kii sabate, bihi líipala mu bvulu. Ya bu liluono mukogho a mwele, bihi líiyito ŋa ebini emõ ki líkatsimi bihi ti ebini kii lisamana. Bu libwi-nsini, bihi líibili ya bakaha ba bábvuŋunu oŋo. ");
INSERT INTO tyx_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ŋa kara li bo óli a mukaha mumõ wu a nkwumu a Lidi. Nde áli musi bvulu lili Tyatire. Nde ákatyeghe biko bibi mungala ya ákabuono Nzaami. Nde ákagyughu bihi ya Mfumu ádzubulu mukolo a nde mu kuulu agyighili okanama mandagha ma ókalyele Poole. ");
INSERT INTO tyx_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ya ŋa mbihi a ŋa báboghoro nde, emõ ya baara ba nzo a nde, nde ábuono bihi ti: «Kala be liimono ti me aakansa kana mu Mfumu, lo liyakala mu nzo a me.» Nde ási enkwili buulu bihi likihi. ");
INSERT INTO tyx_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Etsughu etsyini, mu matala ma líkagye bihi ku ebini kii lisamana, musala mutsyini wu mukaha áyabwana a bihi. Nde áli a mufulu wu mubi, wu áakasa ti nde akataala mandagha ma maagya ku nkulu, ya mu buntaala bu nde, bamfumu ba nde bákabagha nzi yi alagha. ");
INSERT INTO tyx_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nde ákayanama Poole ya bihi. Nde ákabiili bingubu ti: «Baara ba bali basala ba Nzaami wu Ensoõ-Yulu! Kundaa be, bo bali mu okatsala nsia a nzili yi obvwughu». ");
INSERT INTO tyx_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nde ákasa obo bitsughu bilagha. Etsughu etsyini Poole ákolo nkehe, ya bu akaghala, ályele kundaa mufulu munde ti: «Mu nkwumu a Yiisu-Kriste, me ntumu we, pala mu mukaha wu!» Ya ŋaana oŋo, mufulu ápala. ");
INSERT INTO tyx_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bamfumu ba nde, bu bamono ti bo ka bakughu ofirisalala nde mu obagha nzi o, básyimi Poole ya Silase, bákwolo a bo tee ŋa ebini ki ókabvuŋunu baara ba bvulu lwohono, ŋa nkulu a bamfumu. ");
INSERT INTO tyx_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bábiri bo ŋa nkulu a bansughu-a-lamana ba báli ba-Romẽ ya bályele bo ndiri: «Baara ba bali ba-Dzwife. Bo bali mu okasa ligyuu munsa bvulu li bihi. ");
INSERT INTO tyx_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ya bo bali mu okaluo baara bipfu bi binyaghara, biili bihi ba-Romẽ ka lili a muswa mu okihi o, bwunu we mu onama.» ");
INSERT INTO tyx_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mpwumu a baara yíkaghala bo mfulu, bansughu-a-lamana bágwi litumu badzwulu bo binkuru ya bakaha bo nswanswa. ");
INSERT INTO tyx_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ya bu bamana okaha bo nswanswa, bálo bo mu boloko ya bádzuru nkyele a boloko matswi mu ogyighili okebe bo. ");
INSERT INTO tyx_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nkyele a boloko bu agyughu litumu lilo, nde álo bo kunsa ngwumu yi a mu kara, ya álo bo myili mu bidzu. ");
INSERT INTO tyx_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mu kara-a-kara li mpyibi, Poole ya Silase bákasamana ya bákagyimi bikwumu mu osyighi Nzaami. Baara ba boloko babake bákagyughu bo. ");
INSERT INTO tyx_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ensihibi, nsie yínyiŋi mu mpini mu eteese kii onyihi bitsini bi bibagha bi boloko. Bidzughubu bi boloko byehene bísaanyaã ya misyi mimi bisyeẽ myehene mi bákuru baara ba boloko mísughuru. ");
INSERT INTO tyx_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nkyele a boloko ábulusighili kunsa ensama, ya bu amono bidzughubu bi boloko bwaha, nde ápaha lipee mu kuulu adzwa nyuru. Nde ákatsimi ti baara ba báli mu boloko báfi obara. ");
INSERT INTO tyx_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Lo Poole ágyamana nde ti: «Ka sa nyuru a we mfini o! Bihi bwohono lili ŋa». ");
INSERT INTO tyx_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Oŋo nkyele a boloko áluomo mwindi, ya mu embwa-mbwa nde ásomo mu báli bo, mu enkwughu kyehene áyibwa ŋa nkulu a Poole ya Silase. ");
INSERT INTO tyx_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nde ápaha bo ya áfwulu bo ti: «Bataara! Emakye me aansa kuulu me mbvwughu?» ");
INSERT INTO tyx_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bo bábvuhulu nde ti: «Sa kana mu Mfumu Yiisu, ya we sa bvwughu, we ya baara ba nzo a we.» ");
INSERT INTO tyx_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bo báluo nde ndagha a Mfumu, nde ya baara ba nzo a nde bwohono. ");
INSERT INTO tyx_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mu matala maana mamo, nkyele a boloko ábiri Poole ya Silase ku nzo a nde, áswagha bo mambaala, ya bo básaaboghoro nde ya baara ba nzo a nde bwohono. ");
INSERT INTO tyx_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nde ásohobo bo munsa nzo a nde ya ágwi bo bi-odza. Nde ya baara ba nzo a nde bwohono, bákughu mu esee, mu kuulu, bo bási kana mu Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bwihi bu buki, bansunghu-a-lamana bágweghe babaakasala ya bo bayilyele kundaa nkyele a boloko ti: «Nyaã baara babo bagye!» ");
INSERT INTO tyx_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nkyele a boloko átwoho nsia oyo kundaa Poole ti: «Bansunghu-a-lamana baagweghe mukyene ti me nyaã be. Mu obo, lipala ya ligye mu edzuunu!» ");
INSERT INTO tyx_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Lo Poole ábvuhulu bo ti: «Bo baatumu bakaha bihi nswanswa ŋa mihi mi baara bwohono, gwene a otswama osa bihi muyala, bihi ba lili ba-Romẽ! Ŋa nseele bo baalo bihi mu boloko. Ya mu matala ma bo badzyi opaha bihi mu ensweghe? Pele, ka okughu okala obo o! Nyaã bomo bayapaha bihi!» ");
INSERT INTO tyx_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Babaakasala ya bansughu-a-lamana báyitwoho mvuru oyo kundaa bansunghu-a-lamana. Bo bu bagyughu ti Poole ya Silase báli ba-Romẽ, bo bábagha nzalamweẽ, ");
INSERT INTO tyx_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ya báyaluomo bo kolokolo. Bo bápaha bo mu boloko ya báluomo bo bamara mu bvulu. ");
INSERT INTO tyx_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Poole ya Silase bu bapala mu boloko, bágyene kundaa Lidi. Bo bámoŋono ya bandughu mu kana, bágwi bo mpama, ya bo bágyene. ");
INSERT INTO tyx_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bu baluru mu mabvulu mama Amfipoli ya Apoloni, Poole ya Silase báyato ŋa Tesalonike. Oŋo, óli a nzo a lisamana a ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ti bwunu a bu óli epfu e nde, Poole ásomo mu nzo a lisamana a ba-Dzwife. Nde ákabili ya bo mu mi mitala Mandagha ma Nzaami, mu bitsughu bi sabate bitere. ");
INSERT INTO tyx_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nde ákabaala ya ákasuo bo ti Kriste áfaana omono mpara ya osighili ŋa kara li ba bákpi, ya ákalyele bu: «Kriste, me Yiisu wu ndi mu okagwa me be nsia.» ");
INSERT INTO tyx_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bo bápeene a ndaama a ba-Dzwife ba báyabvuŋunu ya bo. Ba-Ngereke balagha ba baakasyighi Nzaami ya bakaha balagha ba banene boho si, bási bumõ. ");
INSERT INTO tyx_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Lo ba-Dzwife bana bámono mukolo mubi ya báti baara ba babi ba baakabwa nsini mu manzili mbili. Bu babvughu bo, bátumu bo mu osa ngirini munsa bvulu. Bo báyibvuŋunu ŋa nzo a Yasone, bákasagha Poole ya Silase mu kuulu babiri bo ŋa nkulu a baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bu bakwono omono bo, bo bábiri Yasone ya ndaama a bandughu mu kana babake ŋa nkulu a bamfumu ba bvulu, ya bákabuluta mukwu ti: «Baara ba báanyihi nsie nsyini, bamaato kunu mu matala ma. ");
INSERT INTO tyx_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasone aagyagha bo ku nzo a nde. Bo ka bali mu okanama litumu li Mukogho Sedzare o, ya bali mu okabululyele si ti oli a mukogho mukimi, nkwumu a nde Yiisu.» ");
INSERT INTO tyx_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ndagha oyo yímwehẽ bakwuru ba bvulu ya mpwumu a baara mpara. ");
INSERT INTO tyx_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bo bákehe Yasone ya babake ekolo ki ofuru ŋa nseele bányaã bo bagye. ");
INSERT INTO tyx_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Mpyibi bu yibwi, bandughu mu kana bágweghe Poole ya Silase ku Bere. Bo bu bato oko, básomo mu nzo a lisamana a ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ba-Dzwife baba ku Bere báli a mikolo mi mibwe ku obvulu baba ku Tesalonike. Bo bágyagha Ndagha a Nzaami mu esee ki elagha mu okagyighili okeene yo nswe etsughu, mu kuulu basoolo kala ti mandagha ma ókaluo bo Poole máli mama ngaŋma. ");
INSERT INTO tyx_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Baara balagha mu bo bási kana, bumõ si ya bakaha baba ba-Ngereke ba banene mu bvulu ya babaghala balagha. ");
INSERT INTO tyx_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Lo ba-Dzwife baba ku Tesalonike bu basoolo ti Poole ákabulutsala si nsia a Ndagha a Nzaami ku Bere, bo bágyene oko si mu kuulu basa ngirini ya mu otihi mampwumu ma baara. ");
INSERT INTO tyx_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Mu maswa, bandughu mu kana bási ti Poole abara ku mukogho a mubu. Lo Silase ya Timote básyili ku Bere. ");
INSERT INTO tyx_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ba bákagye ya Poole, bábiri nde tee ku bvulu lili Atene. Mu matala ma bákabvughuru bo, Poole átumu bo bályele kundaa Silase ya Timote bagye mu maswa ku áli nde. ");
INSERT INTO tyx_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mu matala ma okakebe Poole Silase ya timote ku Atene, nde ákanyoõ ku olagha bu ákamono ti bvulu lilo áli lilwulu mu banzaami baba bityeghe ba ókasyighi baara. ");
INSERT INTO tyx_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mu obo, mu nzo a lisamana a ba-Dzwife, nde ákamoŋo ya ba-Dzwife ya babo baala ka báli ba-Dzwife o ba baakasamana Nzaami. Ya nswe etsughu, nde ákamoŋo ya baara bwohono ba ákabwana a nde ŋa ebini ki ookabvuŋunu baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Óli si ya banga-a-mayele ba baakata ba-Epikuryẽ ya ba-Sitoyisyẽ ba bákamoŋo ya nde. Bana bákalyele ti: «Nsa ndagha Nga-a-nkele wu adzyi olyele?» Babake bákalyele ti: «Ti anga nde li mu okabili mu banzaami baba bunzyi.» Bo bákalyele obo mu kuulu Poole ákaluo Nsia yi Mbwe yitala Yiisu ya osighili o ba bápki mu lipfu. ");
INSERT INTO tyx_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mu obo, bo bágwolo Poole ya bábiri nde ŋa nkulu a mfwunu a bamfumu ba bvulu yi baakata Ayeropadze. Bo báfwulu nde ti: «We kughu olyele bihi nsa maluo ma manyaghara we li mu okabulugwa baara? ");
INSERT INTO tyx_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mu kuulu we li mu okalo mu matswi ma bihi mandagha ma manyaghara ya bihi lidzyi ogyahaba mambaala ma mo.» ");
INSERT INTO tyx_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Mu engaŋma, baara ba bvulu lili Atene ya banzyi ba báli munsa bvulu lilo, bákaluhu matala ma bo yini a mu okabili bwunu we mu okagyughu bitsimi bi binyaghara. ");
INSERT INTO tyx_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Mu obo, Poole bu atemene ŋa nkulu a baara ba bábvuŋunu mu mfwunu a Ayeropadze, átsughu ndagha ti: «Baara ba bvulu lili Atene, me ndi mu omono ti mu mandagha mwohono, be lili baara banga a enzaami nkara kii elagha. ");
INSERT INTO tyx_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mu kuulu, mu matala ma áakabulundzye me munsa bvulu li be, me aamono bityeghe bi liikasamana be, ya me aamono ebini emõ ki baakagwa bikaba. Ŋa yulu a kye básono ti: “Kundaa nzaami wu bagwene ogyahaba”. Me aayangwa be nsia a Nzaami munde wu liikasamana be, gwene a osoolo nde. ");
INSERT INTO tyx_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Me Nzaami munde áagyighili nsie yohono ya bilogho byehene bi bili mu yo, nde li Mfumu a yulu ya nsie. Nde ka aakakala mu bibini bibi lisamana bi ógyili myaã mi baara o. ");
INSERT INTO tyx_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ŋa yulu oŋo, nde ka li a nzala a kuulu ti myaã mi baara misalala nde o ti anga nde li a nzala a elogho. Mu kuulu nde aakagwa bumweẽ, ewumu, ya bilogho byehene kundaa baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Mu mbwuru mutsyini, nde ágyighili bikaana bi baara byehene mu kuulu bye bikala ŋa yulu a nsie yohono. Nde ákuru mando ya ási milili mu mansie ma baakala bo. ");
INSERT INTO tyx_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nzaami ási obo mu kuulu baara bakasagha nde, si kala ti bo baakamono mpara mu okasagha nde, bo sa bamono nde. Mu engaŋma, nde ka li la ya nswe mbwuru mu bihi o. ");
INSERT INTO tyx_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Mu kuulu me mu nde bihi lili mweẽ, liikabuludzyara, ya bihi lili, ti bu ólyele banga-a-liteere li obili ba be babake ti: “Bihi si lili baana ba nde.” ");
INSERT INTO tyx_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Mu obo, buulu bihi lili baana ba Nzaami, bihi ka lifaana otsimi o ti Nzaami li mu efafaana ki etyeghe ki bátsulu mu oore, mu ngele, bwunu we ki bágwala mu limeẽ, ki bágwala ya bunkere mu mayele ya bitsimi bi mbwuru. ");
INSERT INTO tyx_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ankoho Nzaami ka aafirikatala matala maala baara báli kunsa nzi-nzimini o. Lo mu matala ma, nde li mu okalyele kundaa baara bwohono mu mansie mwohono ti bagyiŋi mayele. ");
INSERT INTO tyx_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Mu kuulu nde ákuru etsughu ki akala aalamana nde nsie nsyini mu bunsumu mu mbwuru wu ásuolo nde. Nde áasuo kundaa baara bwohono elyimi, ki bakughu osa kana, bu áasiili mbwuru munde ŋa kara li ba bákpi.» ");
INSERT INTO tyx_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Bo bu bagyughu ndagha yi osighili o baara ŋa kara li ba bákpi, baara bana bábwi osebe nde, babake bákalyele ti: «Mu ndagha oyo, bihi sa ligyughu we mu matala makimi!» ");
INSERT INTO tyx_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Mu obo, Poole ábulusihi bo. ");
INSERT INTO tyx_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lo ndaama a baara mu bo yínama nde ya yísi kana. Mu bo óli Denise, mumõ mu mfwunu a Ayeropadze, ya mukaha mutsyini wu a nkwumu Damarise ya baara bakimi. ");
INSERT INTO tyx_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ŋa mbihi oŋo, Poole ámara ku Atene ya ágyene ku Korẽte. ");
INSERT INTO tyx_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Oko, nde ábwana mu-Dzwife wu a nkwumu Akila, wu áfi ku etsulu e nsie kii Põ. Ka oli edzighi o, nde áfi ku Itali ya mukala a nde Pirisika, mu kuulu Mukogho Kolode ágwi litumu ti ba-Dzwife bwohono bafaana opala mu bvulu lili Rome. Poole ágyene kundaa Akila ya Pirisile. ");
INSERT INTO tyx_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ya buulu nde esala emõ ákasa ya bo, bo báli bantwu bibvulu, Poole ákala emõ ya bo, ya bákasala ya bo. ");
INSERT INTO tyx_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Mu nswe etsughu kii sabate, Poole ákabili mu nzo a lisamana a ba-Dzwife ya ákasagha opeene a ba-Dzwife ya ba-Ngereke basa kana. ");
INSERT INTO tyx_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Mu matala ma ófi Silase ya Timote ku Masedwane ya báyato ku Korẽte, Poole ábaana okaluhu matala ma nde mwohono mu okaluo Ndagha a Nzaami. Nde ákalyele kundaa ba-Dzwife ti ngaŋma Yiisu li Kriste. ");
INSERT INTO tyx_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Lo ba-Dzwife bátemene a Poole nsumu ya bákatughu nde. Mu obo, nde ákubulu lifufunu li binkuru bi nde ya ályele bo ti: «Nyaã makili ma be mabwa ŋa yulu a mitswi mi beme! Me ka ndi a ebili mu mo o. Obaana lolo, me kundaa baala ka bali ba-Dzwife o aangye.» ");
INSERT INTO tyx_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Poole bu amara ŋa ebini ekye, ágyene kundaa baghala mumõ wu áakasamana Nzaami. Nkwumu a nde Tituse Yusutuse, ya nzo a nde yíli ŋa bele a nzo a lisamana a ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirisipuse, mfumu a nzo a lisamana a ba-Dzwife, ási kana mu Mfumu, nde ya baara ba nzo a nde bwohono. Ya baara baba ku Korẽte, ba bákagyughu Poole, bási kana ya báboghoro bo. ");
INSERT INTO tyx_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Etsughu nga-emõ mu mpyibi, Mfumu áyamoŋono kundaa Poole mu limono ya ályele nde ti: «Ka kala a nzalamweẽ o, sa mukama mu okabili, ka kuru muŋma o! ");
INSERT INTO tyx_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Buulu me ndi ya we, ka oli a mbwuru wu kughu osyimi we mu omwehẽ we kimini o. Munsa bvulu li, me ndi a baara balagha.» ");
INSERT INTO tyx_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Poole ási mvulu mumõ ya bangoono basemene ku Korẽte mu okaluo Ndagha a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Mu matala ma óli Ngalyõ mfumu a Rome, mu etsulu e nsie kii Akayi, ba-Dzwife bágwihini mu okala a etaara mu Poole, ya bábiri nde ŋa mbala a muyala. ");
INSERT INTO tyx_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bo bályele ti: «Mbwuru wu li mu okatumu baara bakasamana Nzaami mu okakaala mikyene embihi.» ");
INSERT INTO tyx_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Mu matala ma ókaabili Poole, Ngalyõ ágwi mvuru yi kundaa ba-Dzwife: «Kala ti ali ndagha yi baadzwi mbwuru bwunu we bigyighili bi bibi, me kaankihi oluhu matala ma me mu ogyughu be ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Lo buulu mumbaŋana a be li mu nkooro a mbiili, mankwumu ya mikyene mi be, ndagha oyo yitala be beme! Me ka nkughu okala nsughu-a-lamana a be o.» ");
INSERT INTO tyx_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ya nde ápaha bo ku mbala a nzo a muyala. ");
INSERT INTO tyx_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Mu obo, bo bwohono básyimi Sosetene, mfumu a nzo a lisamana a ba-Dzwife, bádzwi nde nkubu ŋa mbala a nzo a muyala. Lo Ngalyõ ka átsughu si ndagha o. ");
INSERT INTO tyx_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Poole áfiriluhu bitsughu bilagha ŋa Korẽte. Ŋa mbihi, nde ábulusihi bandughu mu kana ya ásomo mu bwara mu ogye ku Siiri, nzili mõ ya Pirisile ya Akila. Lo nsomo, bási nde nkulu ŋa Senkere mu kuulu nde ágwi misiini kundaa Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bu bato ŋa Efedze, nde ásihi Pirisile ya Akila oŋo. Nde ágyene ku nzo a lisamana a ba-Dzwife ya ákamoŋo ya ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bo báluomo nde mu oluhu bitsughu bilagha oko, lo nde ábihi, ");
INSERT INTO tyx_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","nde ábulusihi bo ya ályele ti: «Kala Nzaami dzyi, me sa firiyambvughuru kundaa be mu sa likimi.» Ŋa nseele nde ásomo mu bwara ya ásihi bvulu lili Efedze. ");
INSERT INTO tyx_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Bu ato ŋa bvulu lili Sedzare, Poole átswama okumu ku Yerusaleme mu ogwa libwunu li Nzaami mboro. Ŋa mbihi, nde ákumunu ku Antyose. ");
INSERT INTO tyx_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nde áluhu mana bitsughu, ya ásihi bvulu lilo. Nde ábululuru mu mabvulu mama Ngalate ya Firingi, mu okabulugwa binduono byehene mpama mu kana. ");
INSERT INTO tyx_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mu-Dzwife mumõ, wu a nkwumu Apolose, wu áafi ku bvulu lili Aledzandiri, áyato ŋa Efedze. Nde áli a liteere li obili ya áli asoolo Bisono bi Nzaami bubwe. ");
INSERT INTO tyx_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nde ágyighi nsia a nzili a Mfumu, ya nde bu áli a mukolo mbaa, ákaluo ya ákagyihi mu bunsumu Nsia yi mbwe yitala Yiisu. Lo nde ákagyahaba yini a liboghoro li Dzã. ");
INSERT INTO tyx_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Mu obo, nde ákaluo ya bukyini bwohono munsa nzo a lisamana a ba-Dzwife. Lo bu bamana ogyughu nde, Pirisile ya Akila bágwolo nde mu okala emõ ya bo, mu ofirigyighili osuo nde nzili a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Buulu Apolose áli a etsimi kii ogye ku Akayi, bandughu mu kana bákihi etsimi ekye ya básono mukaana kundaa binduono mu kuulu babwana a nde bubwe. Nde bu áyato, mu bwehe bu Nzaami, nde áli a mupfunu kundaa babo ba bási kana. ");
INSERT INTO tyx_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Mu engaŋma, mu mbiili a nde, nde ákabwihi mu ebaghala kyehene bitsimi bi ba-Dzwife ŋa mihi mi baara bwohono, bu akasuo mu libaha li Bisono bi Nzaami ti Yiisu ngu Kriste. ");
INSERT INTO tyx_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mu matala ma óli Apolose ku Korẽte, Poole wu áabululuru mu etsulu e nsie kii minguo mimi Adzi áto ku Efedze. Oko, nde áyibagha ndaama a binduono. ");
INSERT INTO tyx_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ya nde áfwulu bo ti: «Mu matala ma lísi be kana mu Mfumu, be líigyagha Mufulu a Ngili?» Bo bábvuhulu nde ti: «Bihi nkini lígyughu ti oli a Mufulu a Ngili o!» ");
INSERT INTO tyx_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Mu obo, Poole áfwulu bo ti: «Bu nsa liboghoro be líbagha?» Bo bábvuhulu ti: «Liboghoro lili Dzã.» ");
INSERT INTO tyx_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Poole áfirilyele bo ti: «Dzã ákaboghoro baara ba bákagyiŋi mayele ya nde ákaluomo kundaa bo mu osa kana mu munde wu akala aagya ŋa mbihi a nde. Mbwuru munde, me Yiisu.» ");
INSERT INTO tyx_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bu bamana ogyughu nde, báboghoro bo mu nkwumu a Mfumu Yiisu. ");
INSERT INTO tyx_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Poole ánaã bo myaã ŋa yulu a mitswi ya Mufulu a Ngili ábwi mu bo. Bo bábwi obili mu mandiĩ mama bunzyi ya okabighili. ");
INSERT INTO tyx_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mutala a bo bwohono áli ku bele a baara kwumu ya buolo (12). ");
INSERT INTO tyx_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Nswe matala, Poole ákagye ku nzo a lisamana a ba-Dzwife, ya mu bangoono batere, nde ákabili ya kana lwohono, ya ákaluo mu mi mitala Empu e Nzaami. Nde ákasa mukama mu opeene a baara ba bákagyughu nde mu kuulu bo basobo bitsimi. ");
INSERT INTO tyx_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lo baara babake ŋa kara li bo, bákuru mikolo, bábihi osa kana ya bákatswagha maluo ma matala nzili a Mfumu ŋa nkulu a libwunu lwohono. Mu obo, Poole ábulusihi bo. Nde ágwolo binduono ya ágyene a bye, ya nswe etsughu, nde ákaluo bye munsa nzo a Tiranose yi a maluo. ");
INSERT INTO tyx_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nde ási mukama mu okaluo bo tee mu bamvulu buolo. Me obo baara bwohono baba mu etsulu e nsie kii Adzi, ba-Dzwife ya ba-Ngereke bágyughu Ndagha a Mfumu. ");
INSERT INTO tyx_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nzaami ákasa bimaã bii okiŋimi mu Poole. ");
INSERT INTO tyx_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Mu obo, bákayinahaba biko bwunu we mipa mi biko mi míberene a nyuru a nde kundaa babyele. Babyele bákadzughu, ya mifulu mi mibi míkapala mu bo. ");
INSERT INTO tyx_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ndaama a ba-Dzwife ba baakabulugye nto ya nto mu okabulubyi mifulu mi mibi, bákataŋana si nkwumu a Mfumu Yiisu ya bákalyele kundaa mifulu mi mibi ti: «Mu nkwumu a Yiisu wu oli mu okabululuo Poole, me ntumu be, lipala!» ");
INSERT INTO tyx_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Obo me bu ókasa baana nsaama ba mukwuru a bangaa ba nzaami a ba-Dzwife wu a nkwumu Seva. ");
INSERT INTO tyx_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Lo etsughu nga-emõ, mufulu wu mubi ábvuhulu kundaa bo ti: «Yiisu, me ngyahaba nde, ya me nsoolo nande Poole ali. Lo be, be bana lili?» ");
INSERT INTO tyx_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ya mbwuru wu áali a mufulu wu mubi ábwi ŋa yulu a bo, ábvulu bo mu mpini ya ámwehẽ bo bwohono mpara mu nzuŋu yi alagha. Bo bábulupala mu nzo oyo mu ntyini, mpene ya mambaala mu manyuru. ");
INSERT INTO tyx_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Baara bwohono mu bvulu lili Efedze, ba-Dzwife ya ba-Ngereke bágyughu ndagha oyo. Bo bwohono bámono nzalamweẽ ya bákasyighi bunene bu nkwumu a Mfumu Yiisu. ");
INSERT INTO tyx_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ŋa kara li baara ba bási kana, balagha báakakihi bigyighili bi bo bi bibi ŋa mihi mi baara bwohono. ");
INSERT INTO tyx_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Baara balagha báyabiri mikaana mi bo mimi mpaana, ya bátsughu mye mbaa ŋa mihi mi baara bwohono. Bu batala ntala a mikaana mimye, bábagha mafwunu kwumu (50 000) ma mipara mimi bisyeẽ. ");
INSERT INTO tyx_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Me mu obo, mu lileene li Mfumu, Ndagha a Nzaami yíkatsaŋama ya yíkakulu mu manto mwohono. ");
INSERT INTO tyx_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ŋa mbihi a mandagha mamo, mu Mufulu, Poole ábagha bitsimi bii ogye ku Yerusaleme, mu obululuru mu bitsulu bi mansie bibi Masedwane ya Akayi. Nde ákalyele ti: «Ŋa aamara me oko, me mfaana ogye si ku Rome.» ");
INSERT INTO tyx_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Mu obo, nde ágweghe baara buolo mu mimbaha mi nde ku Masedwane, Timote ya Erasite. Lo nde-ndeme áfiriluhu mana bitsughu mu etsulu e nsie kii Adzi. ");
INSERT INTO tyx_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Me mu matala mamo baara bási ngirini yi nene mu nkooro a nzili a Mfumu. ");
INSERT INTO tyx_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Demeteryuse, muntsulu bisyeẽ, ákagyighili binzo-nzo bibi lisamana mu ngele mu efaana e nzo a nzaami a Aretemise, nzaami wu mukaha. Nde ya ba bákasa esala emõ ya nde bákabagha ndaana yi alagha. ");
INSERT INTO tyx_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nde ábvughu bo ya baara ba baakasala bisala bikimi bibi myaã bi bifaana ya kii bo, ya ályele kundaa bo ndiri: «Bandughu ba me, be lisoolo ti me mu esala ki bihi-a-be liikabagha busini. ");
INSERT INTO tyx_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Lo be lili mu omono ya lili mu ogyughu ti Poole li mu okalyele ti banzaami ba lili mu okagyighili mu myaã mi bihi-a-be ka bali banzaami baba ngaŋma o. Nde aaleene opeene a mampwumu ma baara mu osobo bo bitsimi. Ka oli yini a mu Efedze bali mu okalyele obo o, lo mu etsulu e nsie kyehene kii Adzi. ");
INSERT INTO tyx_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ka oli yini a esala e bihi-a-be bali mu okatswagha o, lo bali mu okatsaala si nzo a nzaami a Aretemise, nzaami wu munene wu mukaha. Ya edzi-dzighi nde sa apfihili nsia a nde yi nene, nde wu li nzaami wu baakasamana mu etsulu e nsie kii Adzi ya mu nsie nsyini.» ");
INSERT INTO tyx_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bo bu bagyughu obo, bákolo nkehe ya bábwi ofulu bingubu ti: «Aretemise wu a Efedze li nzaami wu mukaha wu munene!» ");
INSERT INTO tyx_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ngirini yíbwi mu bvulu lwohono. Bo bwohono mu mpwumu bágyene ku nzo a bimpa, bábulusyimi ya bábiri Ngayuse ya Arisitarake, basi Masedwane ba bákabulugye ya Poole . ");
INSERT INTO tyx_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Poole ákadzyi oyimoŋono ŋa nkulu a mpwumu a baara, lo binduono bíkahaba nde. ");
INSERT INTO tyx_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bandughu ba nde babake ba báli bamfumu mu etsulu e nsie kii Adzi bágweghe nde si baara mu obuono nde mu kuulu anyaã ogye ku nzo a bimpa. ");
INSERT INTO tyx_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Bana bákakehe bingubu mu ndagha yi, babake bákakehe bingubu mu ndagha nkimi. Mpaatsala yíbwi ŋa nsa emvuŋunu. Ya baara balagha ŋa kara li bo ka bákasoolo o mu emakye bo bábvuŋunu. ");
INSERT INTO tyx_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Munsa mpwumu, ndaama a baara yígwi nsia kundaa Alekandere wu ótwulu ba-Dzwife ŋa nkulu. Nde áseene ekee mu obili mu kuulu akala nyuru a nde ŋa nkulu a mpwumu a baara. ");
INSERT INTO tyx_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Lo bu babaghala ti nde li mu-Dzwife, baara bwohono bákakehe bingubu mu likyi limõ, mu matala muolo ti: «Aretemise wu a Efedze li nzaami wu mukaha wu munene!» ");
INSERT INTO tyx_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Munsono mikaana wu a bvulu áleene ogwuhubu mpwumu a baara ya ályele ti: «Baara ba Efedze, nande dzimini ti bvulu li Efedze lili nkyele a nzo a nzaami a Aretemise wu munene ya wu a etyeghe e nde ki éfi ku yulu? ");
INSERT INTO tyx_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Buulu ka oli a mbwuru wu kughu osa mikeme mu ndagha oyo o, be lifaana odzuunu ya ka lisa buwulu o. ");
INSERT INTO tyx_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Be liiyabiri babaghala ba ŋa. Lo bo ka baaturu bilogho bi nzo a nzaami o ya bo ka baatswagha nzaami a bihi wu mukaha o. ");
INSERT INTO tyx_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kala ti Demeteryuse ya basala ba nde bali a ndagha ya mbwuru, bitsughu bibi miyala bili, bansunghu-a-lamana si bali. Lo nyaã bo bayifwunu! ");
INSERT INTO tyx_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ya kala ti be lili a mandagha makimi ma liifwunu, emvuŋunu ki eekanama mikyene sa egyighili mo. ");
INSERT INTO tyx_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Mu engaŋma, bakughu ofwunu bihi-a-be ti bihi liitemene nsumu ya emfumu e bvulu mu mi miiluru lolo. Mu kuulu ka oli a bwuu li likughu ogwa kundaa bamfumu ba bvulu mu emvuŋunu ki o.» Nde bu amana obili obo, ábvurulu baara. ");
INSERT INTO tyx_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ngirini oyo bu yifi, Poole áti binduono bi nde mbili ya ágwi bo bukyini. Bu agwi bo mboro yi munkaghaba, nde ágyene ku Masedwane. ");
INSERT INTO tyx_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nde abululuru mu etsulu e nsie ekye ya ákabulugwa ba bási kana bukyini bulagha. Ŋa nseele, nde áyito ku nsie a ba-Ngereke. ");
INSERT INTO tyx_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nde áluhu bangoono batere oko. Mu matala ma ákasomo nde bwara mu ogye ku Siiri, nde ágyughu ti ba-Dzwife bákuru ewaa mu odzwa nde. Mu obo, nde ágwolo mukakana wu obvughuru mu nzili yi a Masedwane. ");
INSERT INTO tyx_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopatere mwana a Piruse musi Bere, Arisitarake ya Sekunduse basi Tesalonike, Ngayuse musi Derebe, Timote, Tisike ya Torofime baara baba etsulu e nsie kii Adzi, bágyene ya nde. ");
INSERT INTO tyx_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bo bátswama ku nkulu ya báyikebe bihi ŋa bvulu lili Torowase. ");
INSERT INTO tyx_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ya ŋa mbihi a kyiri kii mampa ma magwene a pfunu, bihi líisomo bwara ŋa Filipe. Ŋa mbihi a bitsughu bitaana, bihi líiyibagha bo ŋa bvulu lili Torowase ya líiluhu bitsughu nsaama oŋo. ");
INSERT INTO tyx_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mu etsughu kii bisemene mu nkonkolo, bihi líibvuŋunu mu okaba limpa. Ya Poole ákamoõ ya bihi. Mu kuulu nde mbala ákagye, nde ádzuru emoõ tee kara-a-kara a mpyibi. ");
INSERT INTO tyx_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Bihi áli liibvuŋunu mu ngwumu yi a ku yulu. Omo óli a miindi milagha. ");
INSERT INTO tyx_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mu matala ma ókabiri Poole emoõ ela-ela, mumpala mumõ wu a nkwumu Etike áli abwi-nsini ŋa etse e nzo ya ákpi mukaba a ensama. Kunsa ensama, nde alighibi ku yulu a muya a nzo wu mitere ya ábwi ku nsie. Bu basagha otehebe nde, bámono ti nde ákpi. ");
INSERT INTO tyx_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Poole bu asughuru, ápfuŋumu, ágwolo nde ya ályele ti: «Ka likala maŋa-maŋa o, nde mweẽ ali!» ");
INSERT INTO tyx_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Bu abvughuru ku yulu a nzo, Poole átsyiri limpa áli. Nde áfiribiri emoõ ela-ela tee ku oki bwihi, ya ábwi nzili ágyene. ");
INSERT INTO tyx_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bábiri mumpala munde wu a mweẽ, ya bo bwohono bábagha bukyini bulagha. ");
INSERT INTO tyx_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Bihi líitswama nkulu ya líiyisomo bwara bu bunene mu ogye ku Asose. Oko bihi líkaabulugwolo Poole, wu áagyene oko mu myili ti bu oli waa li nde. ");
INSERT INTO tyx_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Mu matala ma áyabagha nde bihi ŋa mbwuu yi a Asose, nde ásomo mu bwara li líli bihi ya líigyene bihi bwohono ku bvulu lili Mitilene. ");
INSERT INTO tyx_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Bu limara oŋo, bihi líigwolo nzili yi a mubu. Ya mu etsughu ki nsomo, bihi líiyito ŋa elyi kii Kiyo. Mbala bihi líipala ku elyi kii Samose. Ya muyiri-mbala bihi líiyito ŋa mbwuu yi a bvulu lili Mile. ");
INSERT INTO tyx_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Poole ágwaa mu oluru mikiŋi bvulu lili Efedze, mu kuulu bihi linyaã ofiriluhu matala mu etsulu e nsie kii Adzi. Nde ákabiŋini oyito ku Yerusaleme mu etsughu kii Pantekote. ");
INSERT INTO tyx_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Poole bu ato ku Mile, ágweghe bambiŋini ku Efedze mu oyita bakwuru ba libwunu li Nzaami mbili. ");
INSERT INTO tyx_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bo bu bayato kundaa Poole, nde ályele bo ti: «Be ligyahaba, bu áakankala me ya be matala mwohono, obaana mu etsughu kii nsomo ki áyanto me ku Adzi. ");
INSERT INTO tyx_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Me aansalala Mfumu kunsa okughulu kwohono, mu mansaã ya mu makimini ma óokasa me ba-Dzwife mamfwunu. ");
INSERT INTO tyx_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Be lisoolo ti me ka ákansweghe be ndagha si mõ yi kughu okala mupfunu kundaa be o. Lo me áakanduo ya áakangyihi be mye ŋa mihi mi baara bwohono ya mu manzo. ");
INSERT INTO tyx_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Me áakanduomo kundaa ba-Dzwife ya baala ka bali ba-Dzwife o bagyiŋi mayele, bagya kundaa Nzaami ya basa kana mu Mfumu a bihi Yiisu.» ");
INSERT INTO tyx_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Mu matala ma, me ndi mu okagye ku Yerusaleme bwunu a bu oli mu okatumu me ya epini Mufulu a Ngili. Me ka nsoolo o, nsa ndagha me aambwana a yo oko. ");
INSERT INTO tyx_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Lo mu engaŋma, Mufulu a Ngili li mu okalyele kundaa me ti, mu nswe bvulu, mindala ya kimini bili mu okakebe me. ");
INSERT INTO tyx_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lo mu me, laama li me ka lili a mupfunu o. Ndagha yi li mupfunu kundaa me, oto ku masini ma esala ya osala esala ki ógwi me Mfumu Yiisu, mu okala mpughulu a Nsia yi Mbwe yi a bwehe bu Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Me áakankala ŋa kara li be mu okaluo be mu mi mitala Emfumu e Nzaami. Lo obaana lolo, me nsoolo ti be ka lifirimono edzili e me o. ");
INSERT INTO tyx_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mu obo, etsughu kii lolo me ndyele kundaa be ti: Kala ti be lidzimini, me ka ankala a ebili mu be bwohono o. ");
INSERT INTO tyx_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mu engaŋma, me aandyele be bitsimi bi Nzaami byehene, me ka aansweghe be ndagha si mõ o. ");
INSERT INTO tyx_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Likahala mihi mu beme ya mu mukaã a bindoomo wohono wu oogwi be Mufulu a Ngili mu okebe. Ligyighili okebe libwunu li Nzaami, li aabagha nde mu makili ma mwana a nde.» ");
INSERT INTO tyx_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","«Me nsoolo ti ŋa mbihi a ŋa aangye me, baara ba bali ti bango sa bapala. Ya bo ka babvwuhu mukaã a bindoomo o. ");
INSERT INTO tyx_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ŋa kara li be, sa okala a baara ba baalyele mandagha mama mpya, mu kuulu binduono bigwuŋumu ya binama bo. ");
INSERT INTO tyx_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Mu obo, likala yeelee, ya liikalibili mweẽ ti mu bamvulu batere, mpyibi ya mwiĩ, ngu okala ti kunsa mansaã, me ka aandzimini ogyehe nswe mbwuru ŋa kara li be o.» ");
INSERT INTO tyx_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Lo mu matala ma, me ngwaghala be ŋa myaã mi Nzaami ya kunsa ndagha a nde yi a bwehe. Nde wu li a lileene mu osa ti be likulu mu kana ya mu ogwa pfa kundaa baba ngili bwohono. ");
INSERT INTO tyx_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Me ka áansughu mukolo mu nzi, mu oore, bwunu we mu binkuru bi mbwuru o. ");
INSERT INTO tyx_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Myaã mi liilomono be mi, be beme lisoolo ti me aankasala mu obagha bibye bi liili a bihi nzala bye, me ya ba baakabulugye ya me. ");
INSERT INTO tyx_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mu mandagha mwohono, me áakansuo be ti, me mu okasala obo be lifaana obaha babo ba bagwene a mpini, ya mu okalibili mweẽ mandagha ma ólyele Mfumu Yiisu ndeme ti: “Esee kii wu aakagwa ebvulu kii munde wu aakagyagha.”» ");
INSERT INTO tyx_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Bu amana olyele mandagha mamo, nde ya bo bwohono bákunu mabuo ŋa nsie ya nde ábuono Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Baara bwohono bábuulu elili, ya bákabwumu Poole mu ogwa nde mboro yi a masini. ");
INSERT INTO tyx_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bo bányoõ ku olagha mu nkooro a bu ályele nde kundaa bo ti, bo akala ka bafirimono nde o. Ya bo báyitwulu nde tee ŋa bwara. ");
INSERT INTO tyx_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Bu likaghaba ya bo, bihi líisomo mu bwara ya líigyene nsumu ku elyi kii Kose. Mu etsughu ki énama, bihi líigyene ku elyi kii Rode, ya bu limara oko, líigyene ku bvulu lili Patara. ");
INSERT INTO tyx_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Oko, bihi líimono bwara bu búkagye ku nkolo yi a nsie yi a Fenisi, bihi líisomo omo ya líigyene. ");
INSERT INTO tyx_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Bu lito ŋa bele a elyi kii Syipere, bihi líisihi kye ku engbambogho, ya líinama nzili yi a madza ku nto yi a nsie yi a Siri. Bihi líipala mu bwara ŋa mbwuu yi a Tire, mu kuulu me oŋo bákasurulu bilogho bi bíli mu bwara. ");
INSERT INTO tyx_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Oŋo, bihi líimono binduono ya líiluhu bitsughu nsaama emõ ya bo. Mu litumu li Mufulu, bo bályele kundaa Poole anyaã okumu ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ŋa mbihi a bitsughu nsaama bibye, bihi líitemene mu ogye. Ya bo bwohono, bakaha ya baana ba bo, báyitwulu bihi tee ku nto a bvulu. Bu lito ŋa mukogho a mubu, bihi bwohono líikunu mabuo ŋa nsie, ya líisamana Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ŋa masini, bu ligwihini a mamboro mama okaghaba, bihi líisomo munsa bwara ya bo bábvughuru ku manzo ma bo. ");
INSERT INTO tyx_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Bihi líimana dzwe mu mubu, bu libaana ku Tire, líyisughu ŋa Petolemayise. Oŋo bihi líigwi bandughu mu libwunu mamboro, ya líiluhu etsughu etsyini ya bo oŋo. ");
INSERT INTO tyx_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Mu etsughu ki énama, bihi líigyene ya líiyito ku Sedzare. Oko bihi líigyene ku nzo a Filipe, Muluo a Nsia yi Mbwe. Nde áli mumõ mu babaghala nsaama ba básuolo ku Yerusaleme mu obaha bantumu. Ya bihi líiluhu mana a bitsughu kundaa nde. ");
INSERT INTO tyx_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nde áli a batughu bana baba minkyini ya báli mibighili. ");
INSERT INTO tyx_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bihi áli limaaluhu bitsughu bilagha oŋo, mu matala ma óyato mubighili mumõ wu áafi ku Yude, nkwumu a nde Angabuse. ");
INSERT INTO tyx_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nde bu agyi kundaa bihi, ágwolo muswele a Poole, ákuru myili ya myaã mi ndeme ya ályele ndiri: «Mufulu a Ngili li mu okalyele bu: Ba-Dzwife baba ku Yerusaleme me bu akala baakuru mbwuru nga-a-muswele wu misyi, ya akala baagwa nde ŋa myaã mi baala ka bali ba-Dzwife o.» ");
INSERT INTO tyx_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Bihi ya baara baba bvulu lili Sedzare bu ligyughu mandagha mamo, líibuono Poole anyaã okumu ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Lo nde ábvuhulu ti: «Mu emakye be lili mu okalili ya omwehẽ mukolo me mpara? Me aankughu mu ogwa nyuru a me, ka oli yini a mu kuulu bakuru me misyi o, lo ya mu okpa si ku Yerusaleme mu nkooro a nkwumu a Mfumu Yiisu.» ");
INSERT INTO tyx_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Buulu bihi ka líkakughu opeene a nde o, bihi líinyaã ya líilyele ti: «Nyaã okala bu oli dzyi li Mfumu!» ");
INSERT INTO tyx_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ŋa mbihi a bitsughu bibye, bihi líikuru matsulu ya líikumu ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Binduono bibike bibi ku Sedzare bi bíkagye nzili mõ ya bihi, bíbiri bihi ku nzo a Menasõ, wuulu obaana edzighi áli enduono. Nde áli musi Syipere. ");
INSERT INTO tyx_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Mu matala ma líto bihi ku Yerusaleme, bandughu mu libwunu bábwana bihi mu esee. ");
INSERT INTO tyx_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Mu etsughu ki énama, Poole ábiri bihi kundaa Dzake, ku ókabvuŋunu bakwuru ba libwunu bwohono. ");
INSERT INTO tyx_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Poole ágwi bo mboro, ya ábwi olyele kundaa bo myehene mi ógyighili Nzaami ŋa kara li baala ka bali ba-Dzwife o, mu musala a nde. ");
INSERT INTO tyx_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Bo bu bamana ogyughu mandagha mamo, bábwi osyighi Nzaami. Ya bo bályele kundaa Poole ti: «Ndughu a bihi mu kana, mono mafwunu ya mafwunu ma ba-Dzwife ma maasi kana, ya bo bwohono bali mu okanama mikyene ya dzyi li lilagha. ");
INSERT INTO tyx_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ankoho bo baagyughu ti we li mu okaluo ba-Dzwife bwohono baba mansie mama banzyi ti basihi Mikyene mi Moyidze, banyaã ofirikasohobo baana ba bo nzo a mbaa ya banyaã ofirikanama ekulu ki ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Lo emakye liisa? Bo sa bagyughu ti we aagyi. ");
INSERT INTO tyx_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mu obo, we faana ogyighili mandagha ma liilyele bihi we. Ŋa kara li bihi oli a babaghala bana ba bágwi Nzaami misiini mu bomo. ");
INSERT INTO tyx_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Gye ya bo, sa mansagha mama otsehebe nyuru a we emõ ya bo, ya we firi nzi mu kuulu basa bo mankulu. Obo, baara bwohono sa basoolo ti mandagha mwohono ma báakabili bo mu nyuru a we mali mama mpya, ya ti wehe si aakasalala Mikyene mi Moyidze. ");
INSERT INTO tyx_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Lo kundaa baara baala ka bali ba-Dzwife o, ba baasi kana, bihi liisono mukaana mu olyele bo mandagha ma liikuru bihi. Mandagha mamo me ma: Banyaã odza tuo li banyama ba baagwi mukaba kundaa banzaami baba bityeghe. Banyaã oŋma makili ya odza tuo li banyama ba baakpi mbibili ya banyaã osa enkwunu.» ");
INSERT INTO tyx_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Mu etsughu ki énama, Poole ágwolo babaghala babo, ási mansagha mama otsehebe manyuru emõ ya bo. Ŋa mbihi oŋo, bo básomo mu nzo a Nzaami mu ogwalagha li baamana bo mansagha mama otsehebe manyuru ya nswe mbwuru mu bo àagwa ekaba. ");
INSERT INTO tyx_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ku bele a masini ma bitsughu nsaama bibi mansagha mama otsehebe manyuru, ba-Dzwife ba báfi ku Adzi bámono Poole mu nzo a Nzaami yi nene. Bo bátsiini mpwumu a baara mu osa ngirini ya bo básyimi nde. ");
INSERT INTO tyx_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bo bákakehe bingubu ti: «Basi Isarayele, liyabaha bihi! Limono mbwuru me wu li mu okabululuo kundaa baara bwohono ya mu bibini byehene maluo ma mali mu okakabyihi embwuru ki ekaana e bihi-a-be, Mikyene ya ebini ki. Ya mu matala ma, nde aasohobo si baara baala ka bali ba-Dzwife o munsa nzo a Nzaami, ya aatsaala bungili bu ebini kii ngili ki.» ");
INSERT INTO tyx_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Buulu bo áli batswama omono nde ya Torofime musi Efedze munsa bvulu, bo bátsimi ti Poole nde aasohobo munsa nzo a Nzaami yi nene. ");
INSERT INTO tyx_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mpaatsala yíbwi mu bvulu lwohono ya baara bágyi mu mampwumu. Bo básyimi Poole ya bákwolo nde ku mbala. Ya básaakuru bidzughubu bi nzo a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Mu matala ma bákasagha bo odzwa Poole, nsia yi yíto kundaa mukwuru a pfwunu li bambumbulu (1 000) lili ba-Romẽ ti mpaatsala yiibwi mu bvulu lili Yerusaleme lwohono. ");
INSERT INTO tyx_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mu maswa-maswa, nde ábvughu bamfumu ba bikuru bi bambumbulu nkama ya bambumbulu ba bo, ya bágyene ku óli mpwumu a baara. Baara bu bamono mukwuru a bambumbulu ya bambumbulu ba nde, bo bányaã ofirikaha Poole. ");
INSERT INTO tyx_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mu obo, mukwuru a pfwunu (1 000) li bambumbulu bu ayabehene, ágwi litumu básyimi Poole ya bakuru nde misyi myele mimi bisyeẽ. Ŋa nseele, nde ásagha ogyahaba baghala munde nande ali, ya nsa ndagha nde aasi? ");
INSERT INTO tyx_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Lo kunsa mpwumu a baara, bana bákakehe bingubu mu ndagha yi, babake bákakehe bingubu mu ndagha nkimi. Buulu oli a nkele yi alagha, mukwuru a pfwunu li bambumbulu (1 000) ka áleene osoolo kumu li ndagha o. Mu obo, nde ágwi litumu babiri Poole kunsa ekagha ku ookakala bambumbulu. ");
INSERT INTO tyx_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Mu matala ma óli Poole ŋa yulu a ekaala kii osomo kunsa ekagha, bambumbulu báseene nde mu kuulu mpwumu a baara yíli a kabala li lilagha. ");
INSERT INTO tyx_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Baara bwohono bákanama nde ya bákabiili engubu bu: «Nde wu odzwa!» ");
INSERT INTO tyx_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Mu matala ma bákasohobo Poole kunsa ekagha ku ookakala bambumbulu, nde ályele kundaa mukwuru a pfwunu li bambumbulu (1 000) ti: «Me nkughu olyele we ndagha nga-mõ?» Mfumu a bambumbulu ábvuhulu ti: «We soolo obili engereke? ");
INSERT INTO tyx_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","We ka li musi Edzipite wu aayasohobo mpaatsala mu bitsughu bi biiluru bi, ya wu aabiri mapfwunu mana (4 000) ma bantwumu ba baakadzwa baara ku syehe o?» ");
INSERT INTO tyx_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Poole ábvuhulu ti: «Me, me ndi mu-Dzwife, musi Tarese, bvulu lili nsia, mu etsulu e nsie kii Silisi. Kolokolo a we, gwa me muswa me mbili kundaa baara ba.» ");
INSERT INTO tyx_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mukwuru a bambumbulu bu agwi nde muswa, Poole átemene ŋa yulu a ekaala, áseene ekee mu olyele kundaa mpwumu a baara yikala pii. Baara bwohono bákala pii ya nde ábili kundaa bo mu ndiĩ yi a Eebere ti: ");
INSERT INTO tyx_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Baana ba taara ya bataara ba me, mu matala ma ligyughu mandagha ma aandyele me be mu okala nyuru a me.» ");
INSERT INTO tyx_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Bo bu bagyughu Poole mu okabili kundaa bo mu Eebere, báfirikala pii ku olagha. ");
INSERT INTO tyx_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Nde ályele bo ti: «Me ndi mu-Dzwife, wu báburu ku Tarese, mu nsie yi a Silisi, lo me mu bvulu li nkulu, mu Yerusaleme ya me áangyighili ogyighi bwunu a bu ofaana Mikyene mi bataara ba bihi ŋa myili mi Ngamalyele. Me áli aakansalala Nzaami mu mukolo wu áalwulu mu dzyi mu Nzaami ti bu lili mu okasalala be lolo bu. ");
INSERT INTO tyx_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Me áankamwehẽ baara ba bákanama nzili a Mfumu kimini tee ku lipfu. Me áakankuru babaghala ya bakaha minkana, ya me áakando bo mu manzo ma boloko. ");
INSERT INTO tyx_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mukwuru a bangaa ba Nzaami ya mfwunu a bakwuru bali bampughulu mu mi ndi mu okabili me. Me bo báagwi me mikaana mi óyisyimi bandughu mu kana baba ku Damase mu matala ma ángyene me oko. Bo báagwi me litumu lii oyisyimi ya oyabiri baara ku Yerusaleme buulu basyeme bo.» ");
INSERT INTO tyx_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Me áli mu nzili mu okagye, ku bele a ntaã a minsene, me áambehene ya bvulu lili Damase. Ya ensihibi, otsyeme kuu mpini ófi ku yulu ya ótsehebe ebini ki ándi me. ");
INSERT INTO tyx_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Me áambwi ŋa nsie ya áangyughu likyi li líkalyele me ti: “Sawule, Sawule, mu emakye we li mu okamwehẽ me kimini?” ");
INSERT INTO tyx_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Me áamfwulu ti: “Mfumu, we na?” Likyi líbvuhulu ti: “Me ndi Yiisu, musi Nadzarete. Me me we li mu okamwehẽ kimini.” ");
INSERT INTO tyx_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Baara ba báli ya me bámono otsyeme, lo bo ka bágyughu likyi li líkabili kundaa me o. ");
INSERT INTO tyx_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mu obo, me áamfwulu bu: “Mfumu, emakye me mfaana osa?” Ya Mfumu ábvuhulu kundaa me ti: “Temene, gye ku Damase, ya oko sa balyele we mandagha mwohono ma faana we osa.” ");
INSERT INTO tyx_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Buulu musehene a otsyeme oko ádzwi me mihi, baara ba báli ya me bákwara me mu kwogho ya bábiri me ku Damase.» ");
INSERT INTO tyx_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Oko óli a baghala mutsyini wu a nkwumu Ananyase. Nde áli a enzaami ki ebwe ya ákakebe Mikyene. Ba-Dzwife bwohono ba báli mu Damase báli bampughulu mu bigyighili bi nde bi bibwe. ");
INSERT INTO tyx_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananyase áyamono me ya ályele ti: “Sawule, mwana a taara a me, nyaã we firimono!” Ya mu matala maana mamo, me áamfirimono ya áamono nde. ");
INSERT INTO tyx_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nde ályele kundaa me ti: “Nzaami a bataara ba bihi áli aatswama osuolo we mu kuulu we soolo dzyi li nde, we mono munde wu a Nsumu, ya we gyughu likyi li nde. ");
INSERT INTO tyx_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","We faana okala mpughulu a nde ŋa nkulu a baara bwohono, mu olyele bo mandagha ma aamono ya ma aagyughu we. ");
INSERT INTO tyx_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Lo mu matala ma, emakye we li mu ofirikyele? Temene, bagha liboghoro ya gyagha otsehebe ku masumu ma we mu okasamana mu nkwumu a Mfumu.”» ");
INSERT INTO tyx_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Bu ámbvughuru ku Yerusaleme ya bu ánkansamana munsa nzo a Nzaami, me áambagha limono. ");
INSERT INTO tyx_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Me áamono Mfumu ya nde ályele me ti: “Saana sa maswa, pala mu Yerusaleme! Mu kuulu baara ba bvulu lilo ka bakihi bumpughulu bu we mu me o.” ");
INSERT INTO tyx_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Me áambvuhulu ti: “Mfumu, bo basoolo ti me me áakabulungye mu manzo ma ba-Dzwife mama lisamana mu okabululo mu maboloko ya okabulukaha nswanswa babo ba baakasa kana mu we. ");
INSERT INTO tyx_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ya ŋa bátsala makili ma Etiene, wu áali mpughulu a we, me áandi oŋo. Me áankihi bitsimi bi ba bákadzwa nde ya me áakankebe binkuru bi bo.” ");
INSERT INTO tyx_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Lo Mfumu ályele kundaa me ti: “Gye, mu kuulu me sa ngweghe we ku la, kundaa baala ka bali ba-Dzwife o.”» ");
INSERT INTO tyx_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ba-Dzwife ba bákagyughu Poole tee ŋa ályele nde mandagha mamo, bábwi okabiili bingubu: «Limaha mbwuru wu a bu ŋa yulu a nsie, nde ka afaana ofirikala mweẽ o!» ");
INSERT INTO tyx_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bo bákagyighili ofiribiili bingubu, bákatsili binkuru bi bo ya bákaseene lifufunu mu yulu. ");
INSERT INTO tyx_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mukwuru a bambumbulu ágwi litumu basohobo Poole kunsa ekagha ku ookakala bambumbulu, ya bakakubu nde nswanswa ŋa bàagwa nde bifwulu, mpaala basoolo mu nsa ndagha baara bákakehe bingubu bibye mu nde. ");
INSERT INTO tyx_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Bu bakuru nde minkana mpaala bakaha nde nswanswa, Poole ályele kundaa Mukwuru a ekuru ki bambumbulu nkama wu áli oŋo ti: «Bunu, be lili a muswa wu okaha mu-Romẽ nswanswa, ŋaala be nde nkini muyala osa we?» ");
INSERT INTO tyx_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Mukwuru a ekuru ki bambumbulu nkama bu ágyughu obo, nde áyilyele kundaa mukwuru a ekuru ki bambumbulu pfwunu ti: «Bunu-abo we àasa? Mbwuru wu li musi Rome!» ");
INSERT INTO tyx_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Mukwuru a ekuru ki bambumbulu pfwunu ágyene ya áyifwulu Poole ti: «Lyele me, mu ngaŋma we li musi Rome?» Nde ákihi: «Heẽ». ");
INSERT INTO tyx_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mukwuru a ekuru ki bambumbulu pfwunu áfirilyele ti: «Me áangyehe nzi yi alagha mu okighiri musi Rome.» Poole ábvuhulu kundaa nde ti: «Me, me ndi musi Rome wu emburu ngughu.» ");
INSERT INTO tyx_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Mu matala maana mamo, babo ba bákasagha ogwa nde bifwulu bányaã nde. Lo mukwuru a ekuru ki bambumbulu pfwunu ábagha nzalamweẽ ŋa ábaghala nde ti mu-Romẽ nde átumu bakuru minkana. ");
INSERT INTO tyx_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mu etsughu ki ékanama, mukwuru a ekuru ki bambumbulu pfwunu bu áli a nzala ogyighili ogyahaba ndagha yi mubwughu yi ófwunu ba-Dzwife Poole, átumu banyana nde minkana. Ya nde ábvughu bakwuru ba bangaa ba Nzaami ya mfwunu a ekwuru ki ba-Dzwife yohono. Ŋa nseele, nde ápaha Poole, átwulu nde ŋa nkulu a bo, mpaala bo bagyughu nde. ");
INSERT INTO tyx_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Poole bu atala mfwunu a ekwuru ki ba-Dzwife pii, ályele ti: «Baana ba taara a me, munsa mukolo a me, me bu nsoolo ti, me áakandzyara mu bunsumu ŋa busu bu Nzaami, tee mu etsughu kii lolo.» ");
INSERT INTO tyx_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Lo Ananyase, mukwuru a bangaa ba Nzaami átumu ba báli ŋa bele a Poole bakaha nde mu muŋma. ");
INSERT INTO tyx_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Mu obo Poole ályele kundaa nde ti: «Mu mukubu wu a we, Nzaami sa akaha we, ebagha ki básyili mpeeme! We aabwi-nsini ŋa mu olamana me ti bwunu a bu ookatumu Mikyene. Lo we oŋo Mikyene li mu osalala bu li mu ogwa litumu ti bakaha me?» ");
INSERT INTO tyx_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ba báli oŋo bályele kundaa nde ti: «We aatughu Mukwuru a bangaa ba Nzaami!» ");
INSERT INTO tyx_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Poole ábvuhulu ti: «Baana ba taara a me, me ka aakansoolo o ti nde me Mukwuru a bangaa ba Nzaami. Mu engaŋma básono ti: “We ka tughu mfumu a nsie a we o.”» ");
INSERT INTO tyx_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nde bu asoolo ti kunsa mfwunu a ekwuru ki ba-Dzwife babake báli ba-Saduseyẽ ya ba bamo ba-Faridzyẽ, Poole ákehe engubu ŋa kara li bo ti: «Baana ba taara a me, me ndi mu-Faridzyẽ, mwana a mu-Faridzyẽ, mu nkooro a kana li bihi mu osighili o baara mu lipfu bali mu okalamana me.» ");
INSERT INTO tyx_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nde bu amana obili obo, mumbaŋana ábwi ŋa kara li ba-Faridzyẽ ya ba-Saduseyẽ, ya emvuŋunu ékaghaba mu makaba muolo. ");
INSERT INTO tyx_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Mu kuulu ba-Saduseyẽ baakalyele ti osighili o baara mu lipfu ka oli o, bangye-yulu ka bali o, Mifulu si ka mili o. Lo ba-Faridzyẽ baakasa kana mu mandagha mwohono mamo. ");
INSERT INTO tyx_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nkele yífiriluru. Ndaama a baluo-mikyene mimi kaba lili ba-Faridzyẽ bátemene ya bákabili mu mpini ti: «Bihi ka liimono ebili mu mbwuru wu o. Nkini a nki mufulu, bwunu we ngye-yulu aabili kundaa nde!» ");
INSERT INTO tyx_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Buulu mumbaŋana ákabvulu mpini, mukwuru a ekuru ki bambumbulu pfwunu, bu amono nzalamweẽ ti bo bakughu okaghala Poole mu bipa, nde átumu bambumbulu basughuru, bapaha nde ŋa kara li bo ya babiri nde kunsa ekagha ku ookakala bambumbulu. ");
INSERT INTO tyx_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Mu mpyibi yi áanama, Mfumu ámoŋono kundaa Poole ya ályele nde ti: «Kala a bukyini! Mu kuulu, bwunu a bu aakala we mpughulu a me mu Yerusaleme, bumõ si we faana okala mpughulu a me ku Rome.» ");
INSERT INTO tyx_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Bwihi bu buki, ba-Dzwife bákuru mfwunu, báli mukakana ya bályele ti bo ka badza o ya ka baŋma o tee mu matala ma baadzwa bo Poole. ");
INSERT INTO tyx_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ba-Dzwife ba bákuru mfwunu oyo áli baluru makwumu-mana (40) ma baara. ");
INSERT INTO tyx_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bo báyimono bakwuru ba bangaa ba nzaami ya bakwuru ba ekaana. Bályele kundaa bo ti: «Bihi liili mukakana ti bihi ka lidza o ya ka liŋma o tee mu matala ma liidzwa bihi Poole. ");
INSERT INTO tyx_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Mu obo, ligwihini ya mfwunu a bakwuru ba ba-Dzwife, mu oyilyele mukwuru a ekuru ki bambumbulu ti bagya a be Poole mu mpere yiili be ligyighili okeene ndagha a nde embe. Bihi me baala sa liyikehele nde ya lidzwa nde, nsomo nde ayato ŋa.» ");
INSERT INTO tyx_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Lo mwana a nkele a Poole wu baghala ásoolo mfwunu oyo, ágyene ku ekagha ku ookakala bambumbulu, ásomo omo ya ályele ndagha oyo kundaa Poole. ");
INSERT INTO tyx_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Poole áti mumõ mu bakwuru ba bikuru bi bambumbulu nkama mbili, ya ályele kundaa nde ti: «Biri mumpala wu kundaa mukwuru a ekuru ki bambumbulu pfwunu, nde li a ndagha yi aalyele nde.» ");
INSERT INTO tyx_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mukwuru a ekuru ki bambumbulu nkama ábiri nde kundaa mukwuru a ekuru ki bambumbulu pfwunu ya ályele ti: «Poole wu liilo mu boloko aati me mbili, ya aatumu me yambiri mumpala wu kundaa we. Nde li a ndagha yi aalyele we.» ");
INSERT INTO tyx_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mukwuru a ekuru ki bambumbulu pfwunu ákwara nde mu kwogho, ágyene a nde mu libee ya áfwulu nde ti: «We nsa ndagha li a yo yi aalyele me?» ");
INSERT INTO tyx_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Mumpala ábvuhulu nde ti: «Ba-Dzwife baagwihini mu oluomo kundaa we ti mbala we biri Poole ŋa nkulu a mfwunu a bo. Bo sa balyele we ti bo badzyi ogyighili okeene ndagha a nde embe. ");
INSERT INTO tyx_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Lo we me wuulu ka akihi bitsimi bi bo o. Mu kuulu oli a makwumu-mana (40) ma baara ŋa kara li bo ba baayikehele nde. Bo baali mukakana ti, bo ka badza o ya ka baŋma o, tee mu matala ma baadzwa bo Poole. Mu matala ma bo bali yeelee, yini a mvuru a we bali mu okakebe.» ");
INSERT INTO tyx_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mukwuru a ekuru ki bambumbulu pfwunu ábvuhulu mumpala ya átswi nde mukele ti: «Ka lyele mbwuru ti we aasuo me mfwunu oyo o.» ");
INSERT INTO tyx_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Mukwuru a ekuru ki bambumbulu pfwunu áti buolo mu bakwuru ba bikuru bi bambumbulu nkama mbili, ya ályele bo ti: «Likala yeelee mu ogye ku Sedzare, mu tala lili wa mu mpyibi. Ligwolo nkama ywolo yi a bambumbulu (200), makwumu-nsaama (70) mama ba baakabiri basyevale ya nkama ywolo (200) yi a bambumbulu ba bali a magyuo. ");
INSERT INTO tyx_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ligyighili si basyevale ba baabiri Poole wu mukughu ya mweẽ kundaa Felikise, mfumu a etsulu e nsie.» ");
INSERT INTO tyx_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Nde ásono bu mu mukaana: ");
INSERT INTO tyx_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Kundaa we Felikise, mfumu wu budziri, mboro a we! Me Kolode Lisyase, ndi mu osono. ");
INSERT INTO tyx_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mbwuru wu ngweghe me we, ba-Dzwife baasyimi nde ya baadzyi odzwa nde. Me bu aangyughu ti nde li musi Rome, me aangyene ya mpwumu a bambumbulu ba me mu okwulu nde. ");
INSERT INTO tyx_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Me bu aandzyi osoolo ebili ki baafwunu nde, me aambiri nde ŋa nkulu a mfwunu a bakwuru ba bo. ");
INSERT INTO tyx_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Me aamono ti mandagha ma bali mu okafwunu nde matala mumbaŋana mu mikyene mi bo. Ka oli a ndagha yi bakughu odzwa nde o, bwunu we olo nde mu boloko. ");
INSERT INTO tyx_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Me bu aangyughu ti bo baakuru mfwunu mu odzwa mbwuru wu, me ngweghe we nde mu maswa-maswa. Ya me aanduomo kundaa ba bali mu okafwunu nde, bayalyele ŋa mihi mi we ebili ki baabagha bo mu nde.» ");
INSERT INTO tyx_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Bambumbulu bágyene a Poole ya bábiri nde mu mpyibi ŋa bvulu lili Antipatirise ti bwunu a bu óli litumu li bágwi bo. ");
INSERT INTO tyx_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Etsughu ki énama, bambumbulu ba bákagye mu myili, bábvughuru ku ekagha ku ookakala bambumbulu, ba bákabiri basyevale bánama nzili ya Poole. ");
INSERT INTO tyx_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bu bato ku Sedzare, bambumbulu ba baakabiri basyevale bágwi mukaana kundaa mfumu a etsulu e nsie, ya básuo nde si Poole. ");
INSERT INTO tyx_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Mfumu a etsulu e nsie átaã mukaana ya áfwulu Poole munsa etsulu e nsie nde áfi. Poole ályele nde ti ku Silisi. ");
INSERT INTO tyx_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Nde ályele kundaa Poole ti: «Me sa ngyughu we mu matala ma ookala ba baafwunu we ŋa nkulu a me.» Nde ágwi litumu bakebe Poole mu nzo a emfumu yi ótwu Erode. ");
INSERT INTO tyx_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ŋa mbihi a bitsighu bitaana, Ananyase, Mukwuru a bangaa ba nzaami ákumunu ku bvulu lili Sedzare nzili mõ ya ndaama a bakwuru ba ba-Dzwife, ya Teretuluse, nsughu a bo. Bo báfwunu Poole kundaa mfumu a etsulu e nsie. ");
INSERT INTO tyx_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bu bati Poole mbili, Teretuluse ábaana okwighi nde mandagha bu: «Mfumu wu munene, bihi lili kunsa edzuunu ki enene mu nkooro a we, ya mu mandagha mwohono mama lisobo maasi we mu Ekaana ki. ");
INSERT INTO tyx_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Felikise wu a nkara budziri! Mu matala mwohono ya mu bibini byehene, bihi liikabvurulu matuono ma malagha mu mandagha ma mabwe mwohono ma aakagyighili we. ");
INSERT INTO tyx_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Lo mu ogwene oluhu we matala, me mbuono we, ya mu bubwe bu we, magyughu bihi. ");
INSERT INTO tyx_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Bihi liimono ti mbwuru wu nkara a mubi. Nde aakatsubu ngirini ŋa kara li ba-Dzwife bwohono baba nsie nsyini. Ya nde li mukwuru a emvuŋunu ki basi Nadzarete. ");
INSERT INTO tyx_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nde aagyeele otsaala bungili bu nzo a Nzaami, me mu obo bihi liisyimi nde. Bihi liidzyi olamana nde ti bwunu a bu oli mikyene mi bihi, ");
INSERT INTO tyx_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","lo Lisyase, mukwuru a bambumbulu, áyagwohono bihi nde mu mpini. ");
INSERT INTO tyx_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ya aagwi litumu kundaa ba baafwunu nde mu ogya ŋa nkulu a we. We kughu ofwulu baghala wu weme, ya we sa mono ti mandagha ma lili mu okasa bihi nde mumfwunu mali mama ngaŋma.» ");
INSERT INTO tyx_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ba-Dzwife básyighi mandagha ma ólyele Teretuluse, ti mo máli mama ngaŋma. ");
INSERT INTO tyx_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Mfumu a etsulu e nsie ágwi nde muswa mu obili, ya Poole ábvuhulu ti: «Me nsoolo ti obaana bamvulu balagha, we aakalamana baara ba ekaana ki mu bunsumu. Me mu obo me ndi a kana mu okala nyuru a me. ");
INSERT INTO tyx_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Bitsughu kwumu ya byele (12) nkini biiluru o, obaana bu áankumu me ku Yerusaleme mu oyibuono Nzaami. We kughu ofwulu ndagha oyo. ");
INSERT INTO tyx_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Mbwuru si mumõ ka aamono me mu okatsoho ya mbwuru o, bwunu we mu okatihi mpwumu a baara. Ngu okala mu Nzo a nzaami, ngu okala mu manzo ma lisamana ma ba-Dzwife, ngu okala munsa bvulu. ");
INSERT INTO tyx_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Baara ba, ka bakughu osuo we o ti ndagha yi bali mu okasa me mumfwunu mu matala ma yili yi a ngaŋma. ");
INSERT INTO tyx_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Mono ndagha yinsoolo me: Me aakambuono Nzaami a bataara ba bihi mu nzili a Mfumu yi bali mu okata bo ti Emvu-mvuŋunu. Me aakansa kana mu mi básono mu Mikyene ya mu mibighili. ");
INSERT INTO tyx_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Kana li aakansa me mu Nzaami ti sa okala a osighili o baara baba nsumu ya ba bagwene a bunsumu mu lipfu, me lyini lilo si bo bali a lo. ");
INSERT INTO tyx_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Me mu obo meme si aakansa mpini mu matala mwohono mu omoŋono mbwuru wu gwene a bitsimi bi okughu osyeme Nzaami ya baara. ");
INSERT INTO tyx_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Ŋa mbihi a bamvulu balagha baala me ka ándi ya be o, me aayamvughuru ku Yerusaleme mu oyabiri libaha kundaa ekaana e me, ya mu ogwa bikaba kundaa Nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Me mu matala mamo bo baamono me munsa Nzo a nzaami ŋa mbihi a mansagha mama otsehebe nyuru a me. Ka ókakala a mpwumu a baara o, ya ka ókakala a kyaã o. ");
INSERT INTO tyx_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Lo ba-Dzwife babake baba ku Adzi, ba bákakala oŋo, me bo bakaafwunu me kundaa we, kala ti boho si baamono ndagha yi mbi mu me. ");
INSERT INTO tyx_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bwunu we, nyaã baara ba balyele ndagha yi mbi yibaamono bo mu me, ŋa baalamana me ŋa nkulu a mfwunu a ekwuru ki ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Bunu, yini a mu nkooro a ndagha yi aankehe me engubu mu mutele ŋa kara li bo ti: “Mu osighili o ba bákpi mu lipfu bali mu okalamana me lolo li ŋa nkulu a be?”» ");
INSERT INTO tyx_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felikise wu áakagyighili osoolo mi mitala nzili a Mfumu, ábvurulu bo ya ályele ndiri: «Me sa ndamana ndagha a be ŋa ooyakumunu Lisyase Mfumu a ekuru ki bambumbulu pfwunu ŋa.» ");
INSERT INTO tyx_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nde ágwi litumu kundaa mfumu a ekuru ki bambumbulu nkama mu okebe Poole mu boloko ya mana bumpoholo, ya anyaã bandughu ba nde bumpoholo mu okabaha nde. ");
INSERT INTO tyx_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ŋa mbihi a mana bitsughu, Felikise ya Durusile, mukala a nde wu mu-Dzwife, bágyi. Nde átumu bayibiŋini Poole ya nde ágyughu nde mu okabili mu kana mu Yiisu-Kriste. ");
INSERT INTO tyx_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Lo mu matala ma óbwi obili Poole mu mi mitala bunsumu, okebe nyuru ya mumfwunu wu akala aagya, Felikise ábagha nzalamweẽ ya ályele kundaa nde ti: «Mu matala ma, magye! Me sa nta we mbili mu sa likimi.» ");
INSERT INTO tyx_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Felikise áli a kana ti Poole sa agwa nde nzi. Mu obo nde ákata nde mbili matala malagha mu okamoõ ya nde. ");
INSERT INTO tyx_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ŋa mbihi a bamvulu buolo, Porosiyuse Fesetuse ákiri Felikise ŋa emfumu. Buulu Felikise ákasagha ogwa ba-Dzwife esee, nde ányaghala Poole mu boloko. ");
INSERT INTO tyx_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fesetuse áto mu etsulu e nsie kii Yude. Ŋa mbihi a bitsughu bitere nde ámara ku Sedzare ya ákumu ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Bakwuru ba bangaa ba nzaami ya ba-Dzwife baba mupfunu báyimono Fesetuse ya báfwunu Poole kundaa nde. Bo bási enziini, ");
INSERT INTO tyx_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","mu obuono Fesetuse abvurulu Poole ku Yerusaleme. Mu engaŋma, bo áli bakuru mfwunu yi okehele nde mu nzili mu kuulu badzwa nde. ");
INSERT INTO tyx_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Lo Fesetuse ábvuhulu kundaa bo ti Poole áli mu boloko lili ku Sedzare, ya edzi-dzighi ndeme ákabvughuru oko. ");
INSERT INTO tyx_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nde áfirilyele ti: «Nyaã bamfumu ba be bakumunu nzili mõ ya me ku Sedzare, ya bo bafwunu nde oko, kala ti nde li a ebili.» ");
INSERT INTO tyx_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesetuse áluhu bitsighu mpuomo bwunu we kwumu ku Yerusaleme, ŋa mbihi nde ákumunu ku Sedzare. Mu etsughu ki énama, nde bu abwi-nsini ŋa ebini kii muyala, átumu bayabiri nde Poole. ");
INSERT INTO tyx_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Poole bu ayato, ba-Dzwife ba báfi ku Yerusaleme bádzyi nde ya bábwi okaburulu nde mandagha ma malagha ya mama mpara. Lo bo ka bákakughu osuo engaŋma ki mandagha mamo o. ");
INSERT INTO tyx_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Poole ákala nyuru a nde ya ályele ti: «Me ka aansi bubi o, ngu okala ŋa nkulu a Mikyene mi ba-Dzwife, ngu okala mu nzo a nzaami, ngu okala mu mi mitala mukogho Sedzare.» ");
INSERT INTO tyx_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fesetuse bu ákadzyi ogwa ba-Dzwife esee áfwulu Poole ti: «We dzyi okumu ku Yerusaleme mu kuulu balamana ndagha a we yi oko ŋa nkulu a me?» ");
INSERT INTO tyx_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Lo Poole ábvuhulu ti: «Me ndi ŋa mbala a muyala a mukogho Sedzare, me ŋa ebini ki bafaana olamana me. Ti bwunu a bu gyighili osoolo weme, me ka aansi ndagha yi mbi kundaa ba-Dzwife o. ");
INSERT INTO tyx_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kala ti me ka ndi a bwuu o ya kala ti me aansi bubi buulu bafaana odzwa me, lo me ka nkughu obihi lipfu o. Lo kala ti mandagha ma oli mu okaburulu me baara ba mali mama bwunu, lo mbwuru ka li a muswa mu otyeghe me ŋa myaã mi bo o. Me nduomo mukogho Sedzare alamana ndagha a me.» ");
INSERT INTO tyx_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fesetuse bu afi ku mfwunu ya bansughu-a-lamana, ágwi nde mvuru yi: «We aaluomo ti mukogho Sedzare alamana ndagha a we, we sa gye ŋa nkulu a Sedzare!» ");
INSERT INTO tyx_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mana bitsughu bu biluru, mukogho Angiripa ya Berenise báyato mu bvulu lili Sedzare ya báyigwa Fesetuse mboro. ");
INSERT INTO tyx_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Buulu bo bákaluhu bitsughu bilagha oko, Fesetuse ágwi nsia yi a ndagha a Poole kundaa mukogho ya ályele ti: «Ŋa oli a mbwuru mumõ wu oosihi Felikise mu boloko. ");
INSERT INTO tyx_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Mu matala ma aandi me ku Yerusaleme, bakwuru ba bangaa ba nzaami ya bakwuru ba ba-Dzwife baafwunu nde, ya baakaluomo ti me ngwa nde ebili. ");
INSERT INTO tyx_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Me aamvuhulu kundaa bo ti ba-Romẽ ka bali a epfu kii otyeghe mbwuru wu baafwunu ŋa myaã mi baara o, kala ti ka batswama ogyughu mabwuu ma bo o. Nsomo bafaana ogwa wu baafwunu matala mu okala nyuru a nde. ");
INSERT INTO tyx_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Me mu obo bo bwohono baagyi ŋa, gwene a ogwa me lagha. Bwihi bu buki, me aambwi-nsini mu nzo a muyala, ya aantumu bagya a mbwuru munde. ");
INSERT INTO tyx_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bu baagyi, ba baafwunu nde baabili, lo ka oli a ndagha si mõ yi a mpara o, ti bu aakansimi me. ");
INSERT INTO tyx_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bo yini a munsohobo baasi mu mi mitala osamana o bo, emvulu ngughu ndagha yitala mbwuru mumõ wu áakpi, nkwumu a nde Yiisu. Poole li mu okabululyele ti nde li mweẽ. ");
INSERT INTO tyx_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Buulu me ka aakansoolo bu aansa o, me aamfwulu Poole kala ti nde dzyi ogye ku Yerusaleme buulu balamana ndagha a nde oko. ");
INSERT INTO tyx_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lo Poole aaluomo ti mukogho wu a Rome alamana ndagha a nde. Me mu obo me aantumu ti bakebe nde mu boloko tee mu matala ma aangweghe me nde kundaa Sedzare.» ");
INSERT INTO tyx_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Angiripa ályele kundaa Fesetuse ti: «Mehe si, ndzyi ogyughu mbwuru munde!» Fesetuse ábvuhulu kundaa nde ti: «Mbala we sa gyughu nde.» ");
INSERT INTO tyx_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Bwihi bu buki, Angiripa ya Berenise bágyi kunsa nsia. Bo básomo munsa nzo a muyala, nzili mõ ya bakwuru ba bambumbulu, ya baara baba budziri baba mu bvulu. Fesetuse ágwi litumu bayabiri Poole. ");
INSERT INTO tyx_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fesetuse ályele ti: «Mukogho Angiripa ya be bwohono ba lili ŋa ya bihi, limono mbwuru wu. Mu nkooro a nde, mpwumu a ba-Dzwife yígyi kundaa me ku Yerusaleme ya ŋaha si, ya yili mu okaluomo kunsa bingubu ti nde ka faana ofirikala wu a mweẽ o. ");
INSERT INTO tyx_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Me ka aamono mu nde ebili ki bakughu otsyiri nde mukakana wu lipfu o. Lo buulu ndeme aaluomo ti ndagha a nde olamana yo mukogho a Rome, me aangwolo munkaana wu ogweghe nde kundaa Sedzare. ");
INSERT INTO tyx_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Me bu aankwono obagha ngughu a ndagha yi osono kundaa mukogho a Rome mu mi mitala mbwuru wu, me aayambiri nde ŋa nkulu a be, ŋa nkulu a we mukogho Angiripa, mu kuulu ŋa mbihi a bifwulu bi aagwa we nde, me mbagha mi aansono me mu nde. ");
INSERT INTO tyx_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mu engaŋma, me aamono ti oli buwulu mu ogweghe mbwuru a boloko kundaa mukogho a Rome, gwene a osuo bubi bu baafwunu nde.» ");
INSERT INTO tyx_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Angiripa ályele kundaa Poole ti: «We li a muswa wu obili mu okala nyuru a we!» Poole álabala kwogho ya ábili bu mu okala nyuru a nde: ");
INSERT INTO tyx_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Mukogho Angiripa! Me ndi a nkara esee mu etsughu kii lolo mu obili mu okala nyuru a me ŋa nkulu a we, mu mandagha mwohono ma oli mu okaburulu me ba-Dzwife. ");
INSERT INTO tyx_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Mu kuulu we gyighili osoolo ekulu ki ba-Dzwife kyehene ya mandagha ma baakabulubaŋana bo. Yoboo, me mbuono we, ka kolo o mu ogyughu me!» ");
INSERT INTO tyx_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Ba-Dzwife bwohono basoolo bumweẽ bu me, obaana matala ma ándi me munkuru-mbala, ŋa kara li ekaana e me ku Yerusaleme. ");
INSERT INTO tyx_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bo basoolo me edzighi, kala ti bo badzyi, bo bakughu olyele engaŋma mu me ti me áli mbwuru a emvuŋunu ki ebvulu a mpini mu enzaami e bihi, emvuŋunu kii ba-Faridzyẽ. ");
INSERT INTO tyx_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ya kala ti bali mu olamana me lolo, mu nkooro a kana li me mu misiini mi ósi Nzaami kundaa bataara ba bihi, ");
INSERT INTO tyx_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ya madzumu ma bihi kwumu ya muolo (12) si maakasa kana ti misiini mimye sa mikeele ya maakabuono Nzaami mpyibi ya mwiĩ mu mbaa yi alagha. A mukogho! Me mu nkooro a kana lilo ba-Dzwife baafwunu me. ");
INSERT INTO tyx_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Mu emakye be ba-Dzwife liikagwene osa kana ti Nzaami kughu osiili ba bákpi? ");
INSERT INTO tyx_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Meme si áakansimi odzwana a nkwumu a Yiisu musi Nadzarete mu manzili mwohono. ");
INSERT INTO tyx_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Mamo me mandagha ma ákangyighili me ku Yerusaleme. Mu litumu li ógwi me bakwuru ba bangaa ba nzaami. Meme áakando baba ngili balagha mu maboloko ya me áakankihi ti bakadzwa bo. ");
INSERT INTO tyx_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Me aakubulungye mu manzo mama lisamana ma ba-Dzwife mwohono mu okasyeme bo ya me áakansiini bo bakatswagha nkwumu a Nzaami. Mu nkehe a me yi a mpini, me áakamweẽ bo kimini tee mu mabvulu mama bunzyi.» ");
INSERT INTO tyx_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Etsughu nga-emõ me ákangye ku Damase ya litumu lwohono ya esala ki ógwi me bakwuru ba bangaa ba nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","A mukogho! Me ándi mu nzili, ku bele a matala mama embehe, me áamono otsyeme ku obvulu tala mu osehene, ku ófi ku yulu, ya óyabwa mu me ya ba bákagye nzili mõ ya me. ");
INSERT INTO tyx_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Bihi bwohono líibwi ŋa nsie, ya me áangyughu likyi li líkalyele kundaa me mu Eebere ti: “Sawule, Sawule, mu emakye we li mu okamwehẽ me kimini? Mpara yi a bwunu kundaa we bu gwene okihi, ti anga ngoomo wu li mu okasa ngyi ŋa bali mu okakulu nde munkumu!” ");
INSERT INTO tyx_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ya me áamfwulu ti: “Mfumu, we na?” Mfumu ábvuhulu me ti: “Me ngu Yiisu, ngu me we li mu okamwehẽ kimini. ");
INSERT INTO tyx_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Lo sighili ya temene mu myili mi we. Me aamoŋono kundaa we mu osa kuulu we kala musala a me ya mpughulu a me mu mi áamono we mu me, ya mu mi àansuo me we ŋa àamfirimoŋono me kundaa we. ");
INSERT INTO tyx_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Me sa akala nkwulu we ŋa myaã mi baara ba, ya mimi baala ka bali ba-Dzwife o. Me kundaa baala ka bali ba-Dzwife o me aangweghe we, ");
INSERT INTO tyx_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","buulu we dzubulu bo mihi, bapala ku mpyibi a nswi mu ogya ku otsyeme, bapala mu litumu li Satana mu osomo mu lili Nzaami. Bo babagha kolokolo a masumu ya babagha kaba lili pfa li baba ngili, mu nzili yi a kana mu me.”» ");
INSERT INTO tyx_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Mu obo, mukogho Angiripa, me ka ánsi nkyini mu limono lili mayulu lilo o. ");
INSERT INTO tyx_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Lo me áanduo nsomo kundaa baara baba Damase, tumu kundaa baba Yerusaleme, mu etsulu e nsie kii Yude, ya kundaa bikaana biili ka bili ba-Dzwife o. Me áanduomo bo bagyiŋi mayele, babvughuru kundaa Nzaami, ya basuo bigyighili bi bifaana ya ogyiŋi mayele. ");
INSERT INTO tyx_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Me mu obo ba-Dzwife baasyimi me mu nzo a nzaami ya baakasagha odzwa me. ");
INSERT INTO tyx_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Lo Nzaami li mu okakebe me, ya tee mu etsughu kii lolo, me ndi mpughulu kundaa bike-bike ya kundaa bakwuru, kwono ku ndagha obwehe ŋa yulu a mi ólyele mibighili ya Moyidze, ti mandagha mamo mafaana okeele. ");
INSERT INTO tyx_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Mandagha mamo me ma: Kriste faana omono mpara ya nde li wu a nsomo mu osighili ŋa kara li ba bákpi. Nde faana otsala nsia a otsyeme kundaa ba-Dzwife ya kundaa baala ka bali ba-Dzwife o.» ");
INSERT INTO tyx_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Poole ákabili mu okala nyuru a nde ya bu alyele ndagha oyo, Fesetuse ábili mu likyi lili mpini: «Poole we lala li a lo! Mayele mwohono ma li a we maagwi we lala!» ");
INSERT INTO tyx_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Lo Poole ábvuhulu ti: «Fesetuse, wu a nkara budziri! Me ka aambyele lala o! Lo mandagha ma ndyele me mama ngaŋma ya mama bunsumu. ");
INSERT INTO tyx_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mu kuulu mukogho soolo mandagha mamo mwohono, ya me nkughu obili ŋa nkulu a nde ya kana lwohono. Me ngyighili osoolo ti nde ka dzimini si ndagha mõ mu mo o, mu kuulu mandagha mamo ka máluru mu ensweghe o. ");
INSERT INTO tyx_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","A mukogho Angiripa! We aakasa kana mu mibighili? Me nsoolo ti we aakasa kana mu mye.» ");
INSERT INTO tyx_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Angiripa ábvuhulu kundaa Poole ti: «Osyili eki-kiri we peene a me mu kuulu me nkala mukriste!» ");
INSERT INTO tyx_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Poole ályele kundaa nde ti: «Ngu okala eki-kiri, bwunu we matala malagha, kala ti Nzaami dzyi, ka okala yini a we o, lo ya baara bwohono ba bali mu okagyughu me lolo li. Nyaã be likala ti anga me, lo gwene a minkana mimi mu bisyeẽ mi!» ");
INSERT INTO tyx_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mukogho, mfumu a etsulu e nsie, Berenise ya babo bwohono ba bábwi-nsini, bátemene. ");
INSERT INTO tyx_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Bo bágyene ku mfwunu, báfuunu bo-a-bo ti: «Mbwuru wu ka aagyighili ndagha si mõ o yi bakughu odzwa nde bwunu we olo nde mu boloko.» ");
INSERT INTO tyx_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Angiripa ályele kundaa Fesetuse ti: «Mbwuru wu ali wu onyaã, kala ti nde ka aaluomo Sedzare alamana ndagha a nde o.» ");
INSERT INTO tyx_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Mu matala ma bágwolo munkaana ti bihi lisomo mu bwara mu ogye ku Itali, bágwi Poole ya baara ba boloko babake ŋa myaã mi mfumu a ekuru ki bambumbulu nkama (100) wu a nkwumu Yulyuse. Nde áli mu mpwumu a bambumbulu yi baakata ti Mpwumu yi a Onguste. ");
INSERT INTO tyx_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Bihi líisomo mu bwara bubu bvulu lili Adaramite bu búkagye ku mambwuu mama Adzi ya bihi líigyene mu nzili a mubu. Bihi líili ya Arisitarake, musi Masedwane wu a ku Tesalonike. ");
INSERT INTO tyx_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Mu etsughu ki éluono, bihi líito ŋa bvulu lili Sidõ ya líigwumu oŋo. Yulyuse wu áakagwolo Poole mu embwuru, ágwi nde muswa mu oyimono bandughu ba nde buulu bo babaha nde. ");
INSERT INTO tyx_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Bu limara oŋo, bihi líinama mu mukogho-mukogho a elyi kii Syipere mu kuulu libara efulu ki ékaghala mfulu kundaa bihi. ");
INSERT INTO tyx_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Bihi líipala mubu mbembehe li bitsulu bi nsie bibi Silisi ya Pamfili, ya bihi líisughuru ŋa bvulu lili Mire mu etsulu e nsie kii Lisi. ");
INSERT INTO tyx_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Oŋo, mfumu a ekuru ki bambumbulu nkama (100) bu amono bwara bubu bvulu lili Aledzanderi bu búkagye ku Itali, ásohobo bihi omo. ");
INSERT INTO tyx_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Mu bitsughu bilagha bihi líikagye buke-buke mu bwara, ya mu mpara bihi líyito ŋa nkulu a bvulu lili Kinide. Buulu efulu ékakahaba bihi mu ogye linkulu, bihi líiluru minkiŋi ŋa nto a elyi ki baakata Salemone ya líigyene mukogho-mukogho mu ngulu yi a elyi kii Kerete. ");
INSERT INTO tyx_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Bwara búkagye mu mpara yi alagha mu mukogho a madza ya bihi líiyito ŋa ebini emõ ki baakata ti Mambwuu ma Mabwe, ŋa bele a bvulu lili Lasaya. ");
INSERT INTO tyx_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Matala malagha máluru bihi oŋo, ya osomo mu bwara ya ogye mu madza áli oli ndagha yi a mpara, mu kuulu matala mama okuru nswele mu bala áli ayi máluru. Poole ágyehe bo ya ályele ti: ");
INSERT INTO tyx_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Bandughu ba me, me ndi mu omono ti dzwe li sa likala li libi. Bilogho ya bwara bikughu opfighili, ya bihi-meme si likughu opfihili bumweẽ bu bihi.» ");
INSERT INTO tyx_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lo mfumu a ekuru ki bambumbulu nkama (100) ábvulu okasa kana mu mbwuru wu aakabiri bwara ya mu nga-a-bwara. Nde ka ádzyi ogyughu Poole o. ");
INSERT INTO tyx_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Lo buulu mbwuu ka yíli a bu oluhu ndo yi a mpie yi alagha o, ba balagha bákihi etsimi kii omara oŋo. Bitsimi bi bo áli ti, bo bákughu oto ku Fenikise, mbwuu mõ yi a Kerete. Yo yíli bwaha ku Sude-Este ya ku Nore-Weste. ");
INSERT INTO tyx_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mana efulu ki edzuunu ki eekafa ku Sude bu etemene, bo bámono ti bakughu onama etsimi e mfwunu a bo, ya bu basohobo enkulu ki eekatehebe bwara mu madza, bo bágyene mukogho-mukogho a elyi kii Kerete. ");
INSERT INTO tyx_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Lo ŋa mbihi a mana matala, efulu e nkiri ki baakata ti efulu ki Nore-Esete, ki eekafa ku minguo mimi elyi, ébwi ofulu mu mpini. ");
INSERT INTO tyx_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Efulu ébiri bwara, ya buulu bihi ka líli a bu ofirisa o, bwara búkabulugye a bihi magye-agye. ");
INSERT INTO tyx_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Bu líkaluru ŋa bele a elyi-lyi kii Koda, ki ékakyi bihi efulu, bihi líisi mpini mu osomo mu bwara bu busala baba libaha. ");
INSERT INTO tyx_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ba baakasala mu bwara, básohobo bwara bu busala bubu libaha munsa bwara bu bunene. Bo bádziŋi bwara bu bunene misyi, ya bu bamono nzalamweẽ ti mara bakwogho a bihi tee ku dzyele lili mukogho a mubu wu a Libi, bo bátubu mu madza enkulu kii endehẽ ki eekatehebe bwara. Ya bányaã efulu ékagye a bihi magye-agye. ");
INSERT INTO tyx_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Etsughu ki éluono, buulu efulu ékanyihĩ bihi mu mpini, bo bátsili pa li matsulu mu mubu, ");
INSERT INTO tyx_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ya mu etsughu kii bitere, bo bomo bátsili mu mubu nkpaã a eko yi aakasa ti bwara bukagye ya muti wu aakakwara yo. ");
INSERT INTO tyx_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Mu bitsughu bilagha, tala ya baŋomaŋomo ka bífirikamoŋono o, efulu ka édzuunu si eke o, ya bihi ka lífirisyili a emiini kii obvwughu o. ");
INSERT INTO tyx_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Bitsughu bilagha bíiluru biili bo ka báli o. Ya Poole bu atemene ŋa kara li bo ályele ti: «Bandughu ba me, kala ti be ali liigyughu me, ti linyaã omara ŋa Kerete, nkini ka likaabwana a efulu ki enene ki ya opfihili bilogho byehene bi o. ");
INSERT INTO tyx_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Lo mu matala ma, me nduomo be mu okala a bukyini. Mu kuulu ka oli a mbwuru si mumõ mu be wu aapfihili laama li nde o, yini a bwara buubyi. ");
INSERT INTO tyx_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Mu kuulu mu mpyibi yi, ngye-yulu a Nzaami, Nzaami wu aabagha me ya wu aakansalala me, aayamoŋono kundaa me ");
INSERT INTO tyx_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ya aalyele me ti: “Poole, ka kala a nzalamweẽ o, mu kuulu bafaana olamana we ŋa nkulu a Sedzare. Nzaami aagwi we bwehe ya mu nkooro a we, banganda ba we baba midzye sa bakala mweẽ.” ");
INSERT INTO tyx_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Me mu obo bandughu ba me likala a bukyini! Me ndi a kana mu Nzaami ti mandagha ma aalyele nde me sa makeele. ");
INSERT INTO tyx_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Bwara bu bihi-a-be sa buyitsaŋama ŋa yulu a elyi emõ.» ");
INSERT INTO tyx_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Mpyibi oyo áli yi a kwumu ya na (14) yi líkabulugye bihi magye-agye mu mubu wu a Adiryatike. Mu kara-a-kara a mpyibi, ba baakabulusala mu bwara bábaghala ti bihi líito be-bele a nsie. ");
INSERT INTO tyx_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bo bágyeele muyighi madza, ya bábagha mankpaã makwumu-matere ya nsaama (37). Bu bafirisele ŋa nkulu, báfirigyeele ya bábagha mankpaã makwumu-muolo ya mataana (25) mama muyighi. ");
INSERT INTO tyx_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bu bamono nzalamweẽ ti mara bayikaghara ku yulu a mameẽ, bo básurulu binkulu bina bi biikatehebe bwara mu madza ku mbihi a bwara, ya bo bákasughu mukolo ti bwihi bu baakya. ");
INSERT INTO tyx_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Lo buulu ba baakasala mu bwara bákasagha obara, bo básurulu bwara bu busala buu libaha mu mubu, ya bási mpere yi oyitere binkulu bi biikatehebe bwara mu madza, ku nkulu a bwara bu bunene. ");
INSERT INTO tyx_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Poole ályele kundaa mukwuru a ekuru ki bambumbulu nkama ya bambumbulu ti: «Kala ti baara ba ka bakala munsa bwara o, lo be ka libvwughu o!» ");
INSERT INTO tyx_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Bambumbulu bátsyiri misyi mi bwara bu busala buu libaha ya bányaã bo bugye mu madza. ");
INSERT INTO tyx_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Bu bákakebe ti bwihi bukya, Poole ábwono baara bwohono ti badza, ya ályele ti: «Etsughu kii lolo me kii kwumu ya bina (14) ki lili mu okakebe be, ya kiili be elogho odza we. ");
INSERT INTO tyx_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Mu obo, me mbuono be mu odza mu kuulu be lili a nzala a bi-odza mu obvwughu. Mu engaŋma, mbwuru si mumõ mu be ka apfihili si lifu li mutswi a nde limõ o.» ");
INSERT INTO tyx_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Bu amana obili, nde ágwolo limpa, bu abvurulu matuono kundaa Nzaami ŋa nkulu a bo bwohono, átsyiri lo ya ábwi odza. ");
INSERT INTO tyx_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Bo bwohono bábagha bukyini ya boho si bágwolo bilogho báli. ");
INSERT INTO tyx_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Munsa bwara bihi líili nkama-ywolo ya makwumu-nsaama ya baara basemene (276). ");
INSERT INTO tyx_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Bu bagyughuru, bo bátsili matsulu mama mburu a bele mu mubu mpaala bwara buleẽ. ");
INSERT INTO tyx_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Bwihi bu buki, ba baakasala mu bwara ka báfirikasoolo nsie yi bámono bo o. Lo bo bátaala furu li mubu li líli a dzyele lilagha. Bo bágwolo munkaana wu obiri bwara tee oŋo, kala ti bakughu oleene. ");
INSERT INTO tyx_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Mu obo, bo bányana binkulu bi biikatehebe bwara mu madza ya bányaã bye mu mubu. Bo bányana si misyi mi mankaba ma maakabiri bwara. Ŋa mbihi, bo bakuhubu nkpaã eko yi nene ku nkulu a bwara mpaala efulu etsiini bo ya ebiri bo ku mukogho a mubu. ");
INSERT INTO tyx_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lo bo bábvuulu ekumu e dzyele munsa mubu. Mutswi a bwara ákaghara mu dzyele ya bwara ka búfirikanyiĩ o. Etsulu kii mbihi étsaŋama mu nkooro a mampo ma mubu ma mákagya mu mpini. ");
INSERT INTO tyx_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Bambumbulu bágwolo munkaana wu odzwa baara ba boloko. Mu kuulu bo báli a nzalamweẽ ti mfangolo mumõ mu bo abwa mu madza, bara mu otsaba. ");
INSERT INTO tyx_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Lo mfumu a ekuru ki bambumbulu nkama ákahaba bo mu kuulu nde ákasagha obvwuhu Poole. Nde ágwi litumu kundaa ba basoolo otsaba mu obwa nsomo mu madza ya bapala ŋa nseghe. ");
INSERT INTO tyx_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ba bake báfaana onama bo mu okumu mu yulu a mabaya, bwunu we bipa bi bwara. Obo me bu óbvwughu baara bwohono ya báto ŋa yulu a nseghe mukughu, gwene a epfwumu. ");
INSERT INTO tyx_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Bu libvwughu baba mukughu ya mweẽ, bihi líigyughu ti nkwumu a elyi ekye Malate. ");
INSERT INTO tyx_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Baara ba baakakala ŋa elyi ekye bábwana a bihi mu embwuru ki elagha. Bo bábvughu mbaa yi nene, báti bihi mbili mu oyagyoro, mu kuulu mvulu ákanoõ ya óli a mpie. ");
INSERT INTO tyx_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Poole átolo byeghe li nkwi ya átubu lo ku mbaa. Mpili ásuru munsa byeghe lilo mu nkooro a kyaŋana, ánabara nde ŋa ekee. ");
INSERT INTO tyx_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Baara baba elyi bu bamono ntaala wu áakatsyi ŋa ekee e nde bábili bo-a-bo ti: «Ngaŋma, mbwuru wu baara aakadzwa! Nde aabvwughu mu mubu, lo bunsumu bu Nzaami ka buli mu ogwa nde muswa mu okala mweẽ o.» ");
INSERT INTO tyx_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Poole ákubulu ntaala kunsa mbaa, lo nde ka ámono mpara o. ");
INSERT INTO tyx_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Baara bákakebe omono bu oobyimi nyuru a nde, bwunu we ku aakpa nde nkaã. Bo bákebe edzighi elagha ya ka bámono ndagha yi a mpara yi áabwi mu nde o. Mu obo, bo básobo bitsimi, bábwi okabili ti nde li nzaami. ");
INSERT INTO tyx_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Bitaa-taa bibye, óli a mansie ma mfumu a elyi ekye. Nkwumu a nde áli Pubiliyuse. Nde ábwana a bihi kundaa nde ti anga bandughu ba nde, ya bihi líiluhu bitsughu bitere ku nzo a nde. ");
INSERT INTO tyx_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Taara a Pubiliyuse áli a mukaama ya mumweẽ wu makili ákaluru nde. Poole áyitala nde ŋa mbughu ŋa ágyoŋomo nde, bu asamana, ánaã nde myaã, ya ádzuhu nde. ");
INSERT INTO tyx_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ŋa mbihi a mandagha mamo, baara bwohono baba elyi ba báli a mabyele bágyi si kundaa nde, ya nde ádzuhu bo. ");
INSERT INTO tyx_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bo bágwi bihi budziri bu bulagha ya mu matala ma lísomo bihi bwara mu ogye, bo bágwi bihi bilogho bi líli a bihi nzala a bye. ");
INSERT INTO tyx_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ŋa mbihi a bangoono batere, bihi líigwolo bwara bu búluhu ndo yi a mpie yi alagha ŋa elyi. Bwara bubo búfi ku bvulu lili Aledzanderi, nkwumu a bo «Dyosokure», mbaala ti, «banzaami ba bali bambu». ");
INSERT INTO tyx_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Bihi líito ŋa bvulu lili Sirakuse, ya líiluhu bitsughu bitere oŋo. ");
INSERT INTO tyx_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Bu limara oŋo, bihi líinama mukogho a mubu, ya líiyito ku Rengyo. Ŋa mbihi a etsughu emõ, efulu kii ku Sude ébwi ofulu ya bihi líiyipala ku bvulu lili Punzolo mu bitsughu byele, ");
INSERT INTO tyx_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","oko bihi líimono bandughu mu kana ba bábuono bihi mu oluhu bitsughu nsaama ya bo. Obo me bu líyato bihi ku Rome. ");
INSERT INTO tyx_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Bandughu mu kana baba ku Rome bu bagyughu mandagha ma líbwana a bihi, bágyi tee ŋa yu lili Apiyuse ya ŋa ebini ki baakata ti Manzo matere mu oyabwana a bihi. Poole bu amono bo, ábvurulu matuono kundaa Nzaami ya ábagha bukyini. ");
INSERT INTO tyx_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Mu matala ma líto bihi ku Rome, bágwi Poole muswa mu okala mu nzo yi a nde ngasighi ya bágwi nde mbumbulu wu áakabulukebe nde. ");
INSERT INTO tyx_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ŋa mbihi a bitsughu bitere, Poole áti bakwuru ba ba-Dzwife baba ku Rome mbili ku nzo a nde. Bu babvuŋunu, nde ályele kundaa bo ti: «Baana ba taara a me, me ka aangyighili ndagha si mõ yi mbi kundaa baara ba bihi ya kundaa bipfu bi ekulu ki bataara ba bihi o, lo baasyimi me ku Yerusaleme ya baatyeghe me ŋa myaã mi ba-Romẽ. ");
INSERT INTO tyx_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Bo bu bamana ogwa me bifwulu, bo baakadzyi onyaã me, mu kuulu bo ka baabagha ebili ki baadzwa me o. ");
INSERT INTO tyx_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Lo ba-Dzwife ka baakadzyi o, ya me aakaranduomo ti mukogho Sedzare alamana ndagha a me, gwene a okala a etsimi kii ofwunu baara ba ekaana e me. ");
INSERT INTO tyx_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Me mu obo me aanduomo omoŋono ya omoõ ya be. Mu ngaŋma, mu nkooro a kana li Isarayele me ndi mu minkana mimi bisyeẽ mi.» ");
INSERT INTO tyx_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bo bályele kundaa nde ti: «Bihi ka liigyagha mukaana si mumõ wu aafi ku Yude mu nkooro a we o. Ka oli a mbwuru si mumõ o mu bandughu mu kana wu aagwi bihi nsia bwunu we wu aalyele bihi mandagha ma mabi mu we. ");
INSERT INTO tyx_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Lo bihi lidzyi ti weme lyele bihi bitsimi bi we. Mu kuulu bihi ligyighili osoolo ti mu mambughu mwohono, baara bali mu okatemene nsumu emvuŋunu ki li mu okanabara we.» ");
INSERT INTO tyx_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Bo bási lagha li baafiribvuŋunu ya Poole. Etsughu ekye bu eto, baara bágyi balagha ku nzo yi ákakala nde. Obaana epala tee nkonkolo, Poole ákaluo ya ákabaala mandagha mwohono ma matala Emfumu e Nzaami. Nde ákasagha bu aapeene a bo mu kuulu bakihi mandagha ma ákalyele nde bo mu mi mitala Yiisu, obaana mu Mikyene mi Moyidze, tee mu mibighili. ");
INSERT INTO tyx_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Baara bana bákihi mandagha ma ákalyele nde bo, babake bábihi osa kana. ");
INSERT INTO tyx_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Mu matala ma bákabvughuru bo, bo-a-bo nkini áli ka bákagwihini o, ya Poole ábwehe ndagha yi: «Mufulu a Ngili ábili bubwe kundaa bataara ba be mu mubighili Edzayi.» ");
INSERT INTO tyx_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Nde ályele ti: «Gye yilyele kundaa baara babo: Be sa ligyighili ogyughu, lo ka libaghala o. Be sa ligyighili otala, lo ka limono o. ");
INSERT INTO tyx_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Mu kuulu mikolo mi baara ba ayi miikubu. Bo baakyihi matswi ma bo. Bo baadzwi mihi mi bo, mpaala banyaã omono mu mihi mi bo, banyaã ogyughu mu matswi ma bo, banyaã obaghala mu mikolo, mu obo, banyaã ogyiŋi mayele, mpaala me ndzuhu bo.» ");
INSERT INTO tyx_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«Be lifaana osoolo ti Nzaami aagweghe si nsia yi a obvwughu kundaa baala ka bali ba-Dzwife o. Bo, sa bagyughu!»  ");
INSERT INTO tyx_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Poole bu amana obili obo, ba-Dzwife bábvughuru mu okabulubaŋana bo-a-bo. ");
INSERT INTO tyx_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Poole áluhu bamvulu buolo mu nzo yi ofuru. Nde ákabwana baara bwohono ba bákayamono nde. ");
INSERT INTO tyx_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Nde ákatsala nsia a Emfumu e Nzaami ya ákaluo mu kana lwohono ya mu bumpoholo bwohono mandagha ma matala Mfumu Yiisu-Kriste.");
INSERT INTO tyx_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Me Poole, musala a Yiisu-Kriste, wu báti mbili mu okala ntumu ya wu básuolo mu otsala Nsia yi Mbwe yi a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Nzaami ágwi misiini mimi Nsia yi Mbwe yi kundaa mibighili mi nde mu Bisono bibi Ngili. ");
INSERT INTO tyx_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Yo yitala Mwana a nde, wuulu mu musunu li mu musyi a dzumu li Dabvide. ");
INSERT INTO tyx_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Baatwulu Yiisu-Kriste Mfumu a bihi Mwana a Nzaami ya lileene, bwunu a bu oli Mufulu wu bungili, mu nkooro a osighili o nde ŋa kara li ba bákpi. ");
INSERT INTO tyx_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Me mu nde, me aabagha bwehe baa okala ntumu mu obiri bitswumu byehene mu okala a bintamana bibi kana, mu nsia a nkwumu a nde. ");
INSERT INTO tyx_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Behe si lili bamo mu baara ba bo, be ba ooti Yiisu-Kriste mbili. ");
INSERT INTO tyx_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Me nsono mukaana wu kundaa be bwohono ba lili mu bvulu lili Rome, be ba ookadzyi Nzaami mu mukolo ya ba áti nde mbili mu okala baba ngili: Nyaã bwehe ya edzuunu, bi bifi kundaa Nzaami Taara a bihi ya kundaa Mfumu Yiisu-Kriste bikala ya be. ");
INSERT INTO tyx_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nsomo, me mbvurulu matuono kundaa Nzaami a me mu Yiisu-Kriste mu nkooro a be bwohono, mu kuulu bali mu okabili mu kana li be mu nsie nsyini. ");
INSERT INTO tyx_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nzaami, wu aakansalala me mu mukolo mumõ mu Nsia yi Mbwe yi a Mwana a nde, li mpughulu a me ti me aakantsimi mu be matala mwohono ma aakantsamana me. ");
INSERT INTO tyx_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mu nsamana a me, me aakanduomo waa li Nzaami, mpaala me mbagha mpeene yi ogya kundaa be. ");
INSERT INTO tyx_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Mu kuulu me ndi a nzala a omono be ku olagha, mpaala me ngyaha be ekaba kii mufulu, ekaba kii bwehe mu kuulu be ligwama. ");
INSERT INTO tyx_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Bwunu we mpaala, kundaa be, bihi bwohono libagha bukyini, nswe mbwuru mu kana lili ndaa wu muke. ");
INSERT INTO tyx_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Bandughu ba me mu kana, me ndzyi be lisoolo ti matala malagha me aakantsimi ogya kundaa be, mu obagha mana bimburu kundaa be ya kundaa bitswumu bibike. Lo tee sonali, bali mu okakahaba me. ");
INSERT INTO tyx_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Me ndi a ebyimi kundaa ba-Ngereke ya kundaa banzyi, kundaa bansughu ya kundaa ba bagwene soolo mandagha. ");
INSERT INTO tyx_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Mu obo me ndi a maangu nzala a otsala Nsia yi Mbwe kundaa behe si ba lili ku Rome. ");
INSERT INTO tyx_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mu kuulu me ka ndi a budzwa bu Nsia yi Mbwe o, mu kuulu yo yili lileene li Nzaami mu obvwughu o nswe munde wu aasa kana, nsomo mu-Dzwife, ŋa nseele mu-Ngereke. ");
INSERT INTO tyx_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Mu kuulu, me yo yiikasuo bu ookasa Nzaami baara bunsumu mu nzili a kana ya mu nkooro a kana, ti bwunu a bu básono ti: «Munde wuli wu a nsumu mu nkooro a kana sa akala wu a mweẽ.» ");
INSERT INTO tyx_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Mu obo, obaana ku yulu, nkehe a Nzaami yili mu okamoŋono kundaa baara ba bagwene a enzaami ya ba bagwene a bunsumu, ba baakasweghe engaŋma kunsa ogwene a bunsumu. ");
INSERT INTO tyx_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Mu kuulu mandagha ma bakughu osoolo mu Nzaami mali mu okamoŋono ŋa kara li bo. Me Nzaami aasuo bo mo. ");
INSERT INTO tyx_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Mu obo, mandagha ma maagwene okamoŋono kundaa nde, mbaala ti, lileene li nde lili mibvu ya mibvu ya bunzaami bu nde, maagyighili okamoŋono obaana ku bágyighili nsie, mu matala ma ookasa mayele lisobo mu bigyighili bi nde. Me mu obo bo ka bakughu obagha obvwughu o, ");
INSERT INTO tyx_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","mu kuulu bu basoolo Nzaami, bo ka baasyighi nde ti anga Nzaami o, ya ka baabvurulu nde matuono o. Lo bo bágwuŋumu kunsa bitsimi bi bigwene a mupfunu ya mikolo mi bo mi migwene a mayele miisomo kunsa mpyibi yi a laŋa-laŋa. ");
INSERT INTO tyx_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bu batsimi ti bo bali bansughu, bo ayi banga-a-lala, ");
INSERT INTO tyx_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ya bo baasobo nsia a Nzaami wu aagwene okakpa mu bidzili a dzili bi bili efaana e mbwuru wu aakakpa, kii baŋmini, kii banyama ba bali a myili mina ya kii banyama ba baakagye mu etulu. ");
INSERT INTO tyx_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Me mu obo Nzaami anyaghala bo mu okala kunsa mandagha mama osuŋumu mu dzyi li mikolo mi bo, mpaala bo-a-bo banyaã ogwa manyuru ma bomo budziri. ");
INSERT INTO tyx_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bo baasobo engaŋma e Nzaami mu mpya, ya baakabuono bilogho bi ógyighili Nzaami, bu baakasamana bye ŋa ebini e ndeme. Masyighi kundaa nde mu mibvu ya mibvu! «Aamene!» ");
INSERT INTO tyx_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Me mu obo Nzaami aatyeghe bo mu dzyi li mandagha ma maakatwuhu budzwa. Mu obo, bakaha ba bo ka baafirikabvughu mbughu ya babaghala o, lo baakabvughu mbughu ya bambaala bakaha. ");
INSERT INTO tyx_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Bumõ si kundaa babaghala, bu banyaã ofirikabvughu mbughu ya bakaha, bo baalughulu mu mbaa a dzyi li okabvughu mbughu bo-a-bo, mu okagyighili mandagha mama bupfiri babaghala ya babaghala, ya bo baabagha mu manyuru ma bo masyeme ma mafaana ya ogwuŋumu o bo. ");
INSERT INTO tyx_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Mu kuulu bo baatsimi ti ka oli bubwe mu osoolo Nzaami o, Nzaami aatyeghe bo ku mayele ma bo ma magwene a bunsughu. Me mu obo bo baakagyighili mandagha ma magwene ofaana. ");
INSERT INTO tyx_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Bo balwulu mu mandagha mama mawa-mawa ma magwene a bunsumu, mu mokolo bubi, mu ntono a nzi, mu okagyighili mandagha ma mabi, bo balwulu mu musogho, mu odzwa baara, mu mumbaŋana, mu bintwaã, mu bipfu bi bibi, mu okaburulu banganda mandagha, ");
INSERT INTO tyx_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","mu okabili bubi mu banganda, mitaara mi Nzaami, banga a eŋma, banga a ligwagha, banga a mubili a nyuru, banga a bitsimi bubi, ba baakabihi litumu li ba báburu bo. ");
INSERT INTO tyx_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Bo ka bali a mayele o, ka baakanama mukihi wu bálaba o, ka bali a nyiĩ o, ka bali a ngebe o. ");
INSERT INTO tyx_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ya ngu okala ti bo basoolo ti Nzaami ákehe baara ba baakagyighili mandagha mama obo lipfu, bo ka yini a ogyighili baakagyighili mo o, lo bo baakakihi si ba baakagyighili mo. ");
INSERT INTO tyx_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","We, nswe ka nande we li, we wu aakalamana baara, ka bakughu osa we kolokolo o. Mu kuulu, we wu aakalamana babake, ya weme si aakagyighili mandagha maana mamo, we nyuru a weme aakasyeme. ");
INSERT INTO tyx_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ankoho bihi lisoolo ti olamana o Nzaami oli kuu ngaŋma kundaa baara ba baakagyighili mandagha mama obo. ");
INSERT INTO tyx_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","We wu aakalamana ba baakagyighili mandagha mama obo, ya weme si aakagyighili mo, we bunu tsimi, ti we sa bvwughu mu mumfwunu a Nzaami? ");
INSERT INTO tyx_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Bwunu we, we wu aakatsaala busini bubu bubwe bu Nzaami, mukolo a nde wu munene okuru mukolo a nde mu okebe, we ka soolo o ti bubwe bu Nzaami bufaana obiri we ku ogyiŋi mayele? ");
INSERT INTO tyx_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Mu nkooro a mutswi mpini a we, we li mu okabihi ogyiŋi mayele. Me mu obo we li mu okakwu ŋa yulu a weme nkehe yi nene mu etsughu ki akala oomoŋono nkehe ya mumfwunu a Nzaami wu bunsumu, ");
INSERT INTO tyx_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","wu «akala aabvurulu kundaa nswe mbwuru bwunu a bu oli bigyighili bi nde». ");
INSERT INTO tyx_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Nzaami sa agwa laama lili mibvu ya mibvu kundaa babo baala mu mukama a bo wu okasa bubwe, bo baakasagha nsia, budziri ya bumweẽ bu buugwene okafa. ");
INSERT INTO tyx_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Lo Nzaami sa asyeme mu nkehe yi alagha babo ba baakanama bitsimi bi bomo, baakabihi engaŋma ya bali kunsa litumu li mandagha ma magwene a bunsumu. ");
INSERT INTO tyx_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Mpara ya minyoõ kundaa nswe mbwuru wu aakasa mandagha ma mabi, nsomo kundaa mu-Dzwife, ya kundaa mu-Ngereke si. ");
INSERT INTO tyx_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Lo Nzaami aakagwa nsia, budziri ya edzuunu kundaa nswe munde wu aakasa bubwe, nsomo kundaa mu-Dzwife, ŋa nseele kundaa mu-Ngereke. ");
INSERT INTO tyx_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Mu kuulu Nzaami ka ali a munsuolo mu baara o. ");
INSERT INTO tyx_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Baara bwohono ba baasi masumu gwene a Mikyene osoolo, sa bapfighili si gwene a Mikyene. Ya baara bwohono ba baasi masumu kunsa Mikyene, sa balamana bo mu Mikyene. ");
INSERT INTO tyx_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Mu kuulu, ka oli baara ba baakagyughu Mikyene bali baba nsumu ŋa busu bu Nzaami o, lo babo ba baakasalala Mikyene baakala baba bunsumu. ");
INSERT INTO tyx_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Mu matala maala baara baala ka bali ba-Dzwife o, ba bagwene soolo Mikyene, baakasalala mi ookatumu Mikyene, mono ti anga bo bali a Mikyene mu mikolo mi bo, ankoho bo ka basoolo Mikyene o. ");
INSERT INTO tyx_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Bo baakasuo ti bigyighili bi ookatumu Mikyene básono bye munsa mikolo mi bo. Embwuru e bo eekasuo si bumpughulu mu bo, bumõ si ya bitsimi bi bo biili matala mana biikafwunu bo ya matala ma make biikakala bo. ");
INSERT INTO tyx_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Mandagha mamo sa mamoŋono mu etsughu ki oolamana Nzaami mansweghe ma baara mu Yiisu-Kriste, ti bwunu a bu oli Nsia yi Mbwe yi aakansala me. ");
INSERT INTO tyx_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Lo kala ti we wu li a nkwumu yi a mu-Dzwife, we aasiŋi mu Mikyene ya li a mutwunu mu Nzaami a we, ");
INSERT INTO tyx_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","we wu soolo waa li nde, Mikyene miiluo we bu osuolo bubwe bu ofaana osa mbwuru, ");
INSERT INTO tyx_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","we wu aakatsimi ti we li mumbiri a binkpa-mihi, otsyeme o ba bali kunsa mpyibi yi a laŋa-laŋa, ");
INSERT INTO tyx_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","muluo a ba bagwene a ligyahaba ya muluo a bike-bike, mu kuulu we akatsimi ti mu Mikyene we li a ligyahaba ya engaŋma. ");
INSERT INTO tyx_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Lo we, wu aakaluo babake, we ka li mu okaluo weme o! We wu aakaluo ti ka bafaana oturu o, we li mu okaturu! ");
INSERT INTO tyx_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","We wu aakalighi ti ka bafaana obvughu mbughu ya mukala bwunu we mulumu a nganda-mbwuru o, we li mu okabvughu mbughu ya mukala bwunu we mulumu a nganda-mbwuru! We wu aakabele bityeghe, we aakagwolo bilogho bi bili mu bibini bi baakasamana bye! ");
INSERT INTO tyx_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","We wu li a mutwunu mu Mikyene, we ka aakagwa Nzaami budziri o, bu aagwene okasalala Mikyene! ");
INSERT INTO tyx_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Mu kuulu básono ti: «Me mu nkooro a be bikaana bi banzyi biikatsaala nkwumu a Nzaami.» ");
INSERT INTO tyx_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Mu engaŋma, osomo nzo a mbaa oli mupfunu kala ti we aakasalala Mikyene. Lo kala ti we aakatsumunu Mikyene, we li ti anga mbwuru wu áagwene osomo nzo a mbaa. ");
INSERT INTO tyx_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Kala ti mbwuru wu áagwene somo nzo a mbaa aakasalala litumu li Mikyene, Nzaami ka kughu otala nde ti anga mbwuru wu áasomo nzo a mbaa o? ");
INSERT INTO tyx_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Mbwuru wu áagwene osomo nzo a mbaa mu nyuru a nde, wu aakasalala Mikyene, ka akala alamana we o, we wu aakatsala mye, ngu okala ti we li a mukaana a Mikyene ya aasomo nzo a mbaa? ");
INSERT INTO tyx_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Mu-Dzwife wu a ngaŋma ka oli munde wu aakamoŋono mu mihi o, ya osomo nzo a mbaa kuu ngaŋma ka oli elyimi ki baakamono mu nyuru o. ");
INSERT INTO tyx_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Lo mu-Dzwife wu a ngaŋma me munde wu li mu-Dzwife kunsa mansweghe. Osomo nzo a mbaa o nde oli kuu mukolo ku ookagwa Mufulu a Nzaami, lo ka oli kuu mukaana wu básono o. Mu-Dzwife wu a ngaŋma munde ka aakabagha masyighi ma maakafa kundaa baara o, lo ma maakafa kundaa Nzaami. ");
INSERT INTO tyx_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Mu obo, mu emakye okala mu-Dzwife obvulu bitswumu bibike? Mupfunu wu osomo nzo a mbaa ŋana-aŋo ali? ");
INSERT INTO tyx_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Mupfunu li wu munene mu mandagha malagha! Mu kuulu, nsomo, kundaa ba-Dzwife Nzaami ágwi Ndagha a nde okebe. ");
INSERT INTO tyx_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Lo emakye? Kala ti ba-Dzwife babake bagwene a kana, ogwene a kana o bo okughu osa kuulu ti Nzaami anyaã okebe mukihi wu álaba nde? ");
INSERT INTO tyx_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Si okala ka bunu! Nyaã Nzaami akala wu a ngaŋma ya nswe mbwuru akala nga-a-mpya, ti bwunu a bu básono ti: «Mpaala bamono we wu bunsumu mu mandagha ma we», «ya we lughulu ŋa baakasa we muyala». ");
INSERT INTO tyx_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Lo kala ti ogwene a bunsumu bu bihi-a-be buukasuo empakala bunsumu bu Nzaami, mayo bihi liilyele? Nzaami ka li a bunsumu o ŋa aakakolo nde nkehe? Me mu embwuru ndi mu okabili. ");
INSERT INTO tyx_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Si okala ka bunu! Kala pele, lo bunu a bo Nzaami akala aalamana nsie? ");
INSERT INTO tyx_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Lo kala ti mu mpya a me engaŋma e Nzaami eli mu okakulu mu nkooro a nsia a nde, lo mu emakye bali mu ofirilamana me ti anga nga-a-masumu? ");
INSERT INTO tyx_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ya mu emakye liigwene olyele ti anga bu ookatsimi ba baakapfiri mpya ndiri bihi liikaluo ti: «Bihi-a-be litswe likasa o bihi bubi mpaala bubwe bumoŋono mu bo!» Baara baba obo bafaana osyeme bo. ");
INSERT INTO tyx_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Lo bunu odzyi olyele? Bihi-a-be ba-Dzwife libvulu bikaana bibike? Komo pele! Mu kuulu bihi liitswama osuo ti: baara bwohono, ba-Dzwife ya ba-Ngereke, bali kunsa litumu li masumu. ");
INSERT INTO tyx_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Bwunu a bu básono ti: «Ka oli a mbwuru wu a nsumu o, ka oli a si mumõ o, ");
INSERT INTO tyx_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ka oli a mbwuru si mumõ wu li a mayele o, ka oli si mumõ wu aakasagha Nzaami o. ");
INSERT INTO tyx_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Bo bwohono baagwuŋumu, mu emvughu bo ayi baara ba baagwene okasa dzyi li Nzaami, ka oli a si mbwuru mumõ wu aakasa bubwe o, ka oli a si mumõ o. ");
INSERT INTO tyx_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Miguolo mi bo mili ti mpyeme yi a bwaha, bo baakasalala manzalisogho mabo mu okapfiri mpya, mu bibolo bi bo oli a misuo mi mpili, ");
INSERT INTO tyx_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","miŋma mi bo milwulu mu bipwolo ya mu mandagha mama nkala. ");
INSERT INTO tyx_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Myili mi bo mileŋe mu okabulutsala makili, ");
INSERT INTO tyx_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","mu manzili mwohono ma baakaluru bo, bo baakatsala bilogho byehene ya baakasihi nyiĩ, ");
INSERT INTO tyx_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","bo nkini ka bamaagyahaba nzili yi a edzuunu o. ");
INSERT INTO tyx_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Budziri bu Nzaami ka buli ŋa mihi mi bo.» ");
INSERT INTO tyx_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ankoho bihi lisoolo ti mandagha mwohono ma ookalyele Mikyene, mye miikalyele mo kundaa baara ba bali kunsa litumu li Mikyene, mpaala nswe muŋma akala wu a nkunkuru, ya nsie yohono yikala a ebili ŋa busu bu Nzaami. ");
INSERT INTO tyx_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Me mu obo ka oli a mbwuru wu aakala wu a nsumu ŋa nkulu a Nzaami mu bigyighili bi Mikyene o, buulu Mikyene yini a ligyahaba li masumu miikagwa. ");
INSERT INTO tyx_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Lo mu matala ma, gwene a mikyene, Nzaami aasuo bihi-a-be bu aakasa nde bihi-a-be baba nsumu ŋa nkulu a nde. Mikaana mi Mikyene ya mibighili miikasuo bumpughulu mu yo. ");
INSERT INTO tyx_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Baara bwohono ba baakasa kana Nzaami aasi bo bunsumu mu nkooro a kana li bo mu Yiisu-Kriste. Mu kuulu ka oli a lisobo ŋa kara li bo o: ");
INSERT INTO tyx_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Mu kuulu bo bwohono baasi masumu, ya baagwene obagha nsia a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Lo gwene a ofiri nzi, baasi bo baara baba bunsumu mu bwehe bu Nzaami, mu nzili a okwulu ku oli mu Yiisu-Kriste. ");
INSERT INTO tyx_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Nzaami aasuolo nde ti anga ekaba kii ofughu masumu mu makili ma nde, mu nzili a kana, mu osuo bunsumu bu nde. Mu kuulu nde ka ásyeme masumu ma ósi baara mu nsi-nkulu o ");
INSERT INTO tyx_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","mu kuulu nde li a mukolo wu munene. Nzaami aadzyi osuo bunsumu bu nde mu matala ma, nde li wu a nsumu, bu atwulu munde wu si kana mu Yiisu nsumu. ");
INSERT INTO tyx_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ndagha yi okasa mutwunu ŋana yili? Pele, yo ka yifaana okala o! Mu nki mikyene? Mu mikyene mi bigyighili? Pele, lo mu mikyene mi kana. ");
INSERT INTO tyx_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Mu kuulu bihi litsimi ti Nzaami aakasa mbwuru akala wu bunsumu mu kana, gwene a osalala mi mikyene. ");
INSERT INTO tyx_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Bwunu we, Nzaami li yini a wu a ba-Dzwife? Nde ka li si Nzaami a baala ka bali ba-Dzwife o? Eẽ, nde li si Nzaami a baala ka bali ba-Dzwife o, ");
INSERT INTO tyx_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","kala ti oli ngaŋma ti Nzaami li yini a nga-mumõ: Me nde aasa ba básomo nzo a mbaa ya ba bágwene osomo nzo a mbaa bakala baara baba bunsumu mu kana. ");
INSERT INTO tyx_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Mu obo, limaha oko Mikyene mu nkooro a kana? Si okala ka bunu! Lo bihi ligyighili onyeme ti Mikyene mikala. ");
INSERT INTO tyx_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Mu obo, bihi emakye liilyele mu Abarahame, nkagha-kwuru a bihi mu musunu? Nde emakye ábagha? ");
INSERT INTO tyx_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Mu kuulu, kala mu bigyighili Nzaami ási ti Abarahame akala wu bunsumu, nde kughu okala a mutwunu. Lo ŋa nkulu a Nzaami ka oli obo o! ");
INSERT INTO tyx_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Mu kuulu, Bisono emakye biikalyele? «Abarahame ási kana mu Nzaami, me mu lo Nzaami átala nde ti anga mbwuru wu bunsumu.» ");
INSERT INTO tyx_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ankoho kundaa munde wu si esala, ka bakughu otala mufuru a nde ti anga bwehe o, lo mufuru a nde li ti anga ebyimi ki bafaana ofiri nde. ");
INSERT INTO tyx_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Lo kundaa munde wuulu ka aasi esala o, lo si kana mu Nzaami wu aakasa ti nga-a-masumu akala wu bunsumu, Nzaami aakatala nde ti anga mbwuru wu bunsumu mu nkooro a kana li nde. ");
INSERT INTO tyx_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Me mu obo si, Dabvide ali mu okabili mu esee kii mbwuru, wuulu Nzaami aakakihi nde ti anga wu bunsumu gwene a otala bigyighili bi nde: ");
INSERT INTO tyx_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Esee kundaa babo ba oosi Nzaami bubi bu bo kolokolo ya ba aamaha nde masumu ma bo! ");
INSERT INTO tyx_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Esee kundaa mbwuru munde wuulu Mfumu ka aakatala masumu ma nde o!» ");
INSERT INTO tyx_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Esee ekye eli yini a kii ndaa baara ba básomo nzo a mbaa, bwunu we kii ba bagwene osomo si nzo a mbaa? Mu kuulu bihi lilyele ti: Kana li Abarahame lísi ti Nzaami atala nde ti anga mbwuru wu bunsumu. ");
INSERT INTO tyx_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Mu nki matala Nzaami átala nde ti anga nde mbwuru wu bunsumu? Nsomo a nsomo, bwunu we ŋa mbihi a ŋa ásomo nzo a mbaa o? Pele, ka ŋa mbihi o, lo nsomo nde ásomo nzo a mbaa! ");
INSERT INTO tyx_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abrahame ágyagha elyimi kii osomo nzo a mbaa ti anga enyeme kii bunsumu bu ábagha nde mu kana, mu matala maala nde nkini ka áli asomo nzo a mbaa o. Mu obo, nde li taara a baara bwohono babo ba bali a kana wene a osomo nzo a mbaa, mu kuulu batala boho si ti anga baara baba bunsumu. ");
INSERT INTO tyx_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Nde li si taara a ba básomo nzo a mbaa – ka oli yini a ba básomo nzo a mbaa o, lo ba baakadzyara mu bitaama bi kana li óli a Abarahame, taara a bihi, mu matala maala nde nkini áli ka ásomo nzo a mbaa o. ");
INSERT INTO tyx_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Mu obo, ka mu nzili a Mikyene Nzaami ásiini a Abarahame, bwunu we musyi a dzumu li nde, mu ogwolo pfa li nsie o, lo mu nzili a bunsumu bu kana. ");
INSERT INTO tyx_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Mu kuulu, kala ti ba baakagwolo pfa baakagwolo lo mu nzili a Mikyene, lo kana ka lifirisyili a mubwughu o ya misiini ka mifirisyili a mupfunu o. ");
INSERT INTO tyx_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Mu kuulu, Mikyene miikatubulu nkehe a Nzaami, ya ŋa ebini kiili Mikyene we, ka oli ya otsala ku Mikyene o. ");
INSERT INTO tyx_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Mu obo, me mu nkooro a kana baakagwolo pfa, mpaala bukala bwehe ya misiini mikala mimi bwohono ba bali mu musyi a dzumu li Abarahame. Ka yini a mu nkooro a babo ba baakasalala mikyene o, lo si mu nkooro a ba baakasa kana ti bu ósi Abarahame kana, taara a bihi bwohono, ");
INSERT INTO tyx_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","bwunu a bu básono ti: «Me aansi we taara a bikaana bilagha.» Nde li taara a bihi, ŋa nkulu a munde wu ási nde kana, Nzaami wu aakagwa bumweẽ kundaa baara ba bákpi ya wu aakasa ti bilogho biili ka bili o, bikala. ");
INSERT INTO tyx_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Nde ási emiini ŋaala ka bakughu osa emiini o, nde ási kana ya mu obo nde ayi taara a bikaana bilagha, ti bwunu a bu bályele ti: «Obo bu ookala musyi a dzumu li we.» ");
INSERT INTO tyx_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Nde ka ányaã osa kana o, nde ámono nyuru a nde ti anga yo ayi yiikpi – ngu okala ti nde áli ku bele a bamvulu nkama (100) – ya mweẽ a Sara ka ali afirisyili a mbaa o. ");
INSERT INTO tyx_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Lo ŋa nkulu a misiini mi Nzaami, nde ka ási makeŋe o, mu ogwene osa kana, lo nde bu ábagha lileene mu kana ágwi masyighi kundaa Nzaami. ");
INSERT INTO tyx_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Nde áli a kana lili mukughu ti, mi ookasiini a nde Nzaami, Nzaami li a lileene lii ogyighili mye. ");
INSERT INTO tyx_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Me mu obo bátala nde ti anga mbwuru wu bunsumu. ");
INSERT INTO tyx_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Lo ka yini a mu nkooro a nde ngasighi básono o ti: «Me mu obo bátala nde ti mbwuru wu bunsumu,» ");
INSERT INTO tyx_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","lo mu nkooro a bihi si, bihi baala kana li bihi sa batala lo, kundaa bihi ba liikasa kana mu munde wu ásiili Mfumu a bihi Yiisu ŋa kara li ba bákpi. ");
INSERT INTO tyx_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yiisu, wu bátyeghe mu nkooro a bubi bu bihi ya básiili nde ŋa kara li ba bákpi mpaala bihi likala baara baba bunsumu. ");
INSERT INTO tyx_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Me mu obo, bu lili baara baba bunsumu mu nkooro a kana, bihi-a-be lili mu edzuunu ya Nzaami mu Mfumu a bihi Yiisu-Kriste. ");
INSERT INTO tyx_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Me mu nde bihi liibagha nzili mu kana mu ogyagha bwehe bubo bu lili bihi munsa bo, ya bihi liisi mutwunu a bihi mu emiini kii nsia a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ŋa yulu oŋo, bihi liikasa mutwunu mu mpara a bihi, bu lisoolo ti mpara yiikaburu nkaã, ");
INSERT INTO tyx_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","nkaã yiikasa ti mbwuru akebe mukihi wu alaba, ngu okala ti nde li kunsa bigyeele, okebe mukihi wu alaba ookagwa emiini. ");
INSERT INTO tyx_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ankoho, emiini ka eekagwa bupfiri o, mu kuulu baagyirili dzyi li Nzaami mu mikolo mi bihi mu Mufulu a Ngili wu baagwi bihi. ");
INSERT INTO tyx_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Mu kuulu, ŋaala bihi áli nkini mpini we, Kriste ákpi mu nkooro a banga-a-masumu mu matala ma ókuru Nzaami. ");
INSERT INTO tyx_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Oli mpara ti mbwuru akihi lipfu mu nkooro a mbwuru wu a nsumu, ampe mbwuru kughu obagha bukyini mu okpa mu nkooro a mbwuru wu mubwe. ");
INSERT INTO tyx_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lo limono, bu oosuo Nzaami dzyi li nde mu bihi-a-be: Kriste ákpi mu nkooro a bihi-a-be ŋaala bihi-a-be áli nkini banga-a-masumu. ");
INSERT INTO tyx_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ya mu matala ma, maala bihi-a-be ayi lili baara baba bunsumu mu makili ma nde, oli ngaŋma ti Yiisu sa abvwuhu bihi-a-be mu nkehe a Nzaami. ");
INSERT INTO tyx_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Mu kuulu, kala ti ŋa líli bihi-a-be mitaara mi Nzaami, Nde ábvurulu ogwihini o nde ya bihi-a-be mu lipfu li Mwana a nde, lo bunu bihi-a-be ligwene obvwughu mu bumweẽ bu mwana a nde, bu liibvurulu ogwihini ya nde. ");
INSERT INTO tyx_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ŋa yulu oŋo, bihi liikasa mutwunu a bihi mu Nzaami, mu Mfumu a bihi Yiisu-Kriste. Mu nde bihi liigyagha obvurulu ogwihini mu matala ma. ");
INSERT INTO tyx_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Me mu obo, bwunu a bu oosomo lisumu mu nsie mu nzili a mbwuru mumõ, ya mu nzili a lisumu lipfu liisomo mu nsie, bwunu obo si lipfu liisomo mu baara bwohono, mu kuulu bwohono baasi masumu... ");
INSERT INTO tyx_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Mu kuulu, tee mu matala ma oli Mikyene, masumu máli mu nsie, lo ka baakatala masumu o ŋaala Mikyene mye we. ");
INSERT INTO tyx_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Lo komo, obaana Adã tee Moyidze, lipfu líli a litumu, ngu okala ŋa yulu a ba bágwene osa masumu mu nzili a otsumunu ngili ti anga bu ósi Adã, nde wu li efaana ki munde wu faana ogya. ");
INSERT INTO tyx_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Lo ekaba kii bwehe ebvulu bubi bu ósi Adã mu mupfunu. Mu kuulu, kala ti mu bubi bu mbwuru mutsyini lipfu lísomo mu mampwumu ma baara, lo bwehe bu Nzaami ya ekaba kii bwehe ki bágwi mu bu mbwuru mutsyini, Yiisu-Kriste, épfini ku obvulu olagha ŋa yulu a mampwumu ma baara. ");
INSERT INTO tyx_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","