﻿USE sofia;
DROP TABLE IF EXISTS sofia.txuNT_vpl;
CREATE TABLE txuNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES txuNT_vpl WRITE;
INSERT INTO txuNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ba, ibê Matêu ne ba pi'ôkkam ar amã ikabẽn jarẽ. Dja ba ar amã Jeju Kritu'ã ajarẽ. Metĩndjwỳnh ne 'ã Bẽnjadjwỳrbê kumkati mẽ. Kute 'ã Bẽnjadjwỳrbê kumkati mẽnhkôt ne me Jejumã Kritu jarẽ. Dja ba Jeju Kritu nhingêt kumrẽx'ã ar amã ajarẽ. Aben nhitepã ar amã ingêt djàri arẽnho tẽ. O tẽn arỳm 'ã ar amã pi'ôk no'ôk gar arẽn ama. Jeju nhingêtbê ne Dawi. Ne ingêt 'õdjwỳbê Abraão. ");
INSERT INTO txuNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ingêt Abraão ne Idjak dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Nhym kam Djuda arỳm Tamaremã Perêmẽ Djera ar adjuw. ");
INSERT INTO txuNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ar ba:n kam arỳm Amĩnadabi dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ar ba:n kam arỳm Rabemã Bôadji dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ar ba:n kam arỳm Dawi dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ar ba:n kam arỳm Robowão dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ar ba:n arỳm Djoxapa dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ar ba:n arỳm Djotão dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ar ba:n arỳm Manaxe dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ar ba:n arỳm Djekonijmẽ kamy ar adjuw. ");
INSERT INTO txuNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nhym me krĩraxbê Babirônijkam ar ba: nhym kam Djekonij arỳm Xarati dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ar ba:n arỳm Abidji dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ar ba:n arỳm Xadoki dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ar ba:n arỳm Erijdjô dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ar ba:n arỳm Jôdje dji. ");
INSERT INTO txuNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Be, Abraão krakam kra mã aben djô'ã apôx. Nhym me aben nhitepã ar'ã akre: nhym ar kute 14 pyràk ne aben djô'ã apôx nhym me kam Dawi'ỳr o bôx. Nhym kam Dawi krakam kra mã aben djô'ã apôx. Nhym me aben nhitepã ar'ã akre: nhym ajte ar kute 14 pyràk ne aben djô'ã apôx. Nhym me kam arỳm me kurê djwỳnh kute mebê idjaer pytàr'ỳr o bôx. Me me utàn krĩraxbê Babirônij'ỳr meo bôx. Nhym kam me krakam kra mã aben djô'ã apôx. Nhym me aben nhitepã ar'ã akre: nhym ajte ar kute 14 pyràk ne aben djô'ã apôx. Nhym me kam arỳm Kritu'ỳr o bôx. Metĩndjwỳnh kute 'ã Bẽnjadjwỳrbê kumkati mẽnhkôt ne me kum Kritu jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jakam dja ba Jeju Kritu kator'ã ajarẽ. Nã kurũm kator'ã ajarẽ. Nãbê ne Marij. Metĩndjwỳnh Karõ ne Marij'ỳr bôx nhym arỳm tujarô. Marij tujarô kêtri ne Jôdje arỳm amim kum kabẽn nhym me kunĩ kuma. Nãm amim kum kabẽn kajgobit. Kraxje kute o nõr kêt. Nhym kam arỳm tujarô. Tujarô nhym arỳm omũ. ");
INSERT INTO txuNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ne kam bit kute kangamã. Jôdje mexkam bit kute me kàxã kangamãn amim karõo nhỹn amim, —Ne ba ren me krãptĩ nhipôkri kanga nhym ren me arỳm kam ngryk ne. Ba me krãptĩ kàxã kanga. Nãm ã mexkam amim ane. ");
INSERT INTO txuNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nãm ã amim anhỹro nhỹn kam nõn arỳm ngõr. Ngõr nhym aêrbê Bẽnjadjwỳr djwỳnh kadjy mrãnh djwỳnh'õ arỳm 'ỳr bôx nhym õtkam arỳm omũ. Nhym kum, —Jôdje, Dawi tàmdjwỳ, arỳm aprõ tujarôkam kwãrĩk wãnh adjumar punu kêt. Mrãmri dja ga ĩ tu 'ỳr amõrkumrẽx. Djãm axwe? Kati. Metĩndjwỳnh Karõ ne 'ỳr bôx nhym arỳm tujarô. ");
INSERT INTO txuNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Dja kra ruw ga kam kum Jeju jarẽ. Mỳkam dja ga kum ja jarẽ? Bir, dja õ me wỳnh axwebê me utà. Kam dja ga kum Jeju jarẽ. Nãm ã Metĩndjwỳnh kadjy mrãnh djwỳnh'õ Jôdjemã ane. Mỳj'ã ne idjibê Jeju amijakre? Bir, me utàr djwỳnh'ã ne amijakre. ");
INSERT INTO txuNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Amrẽbê: ne Bẽnjadjwỳr djwỳnh Jeju nã tujarô'ã ajarẽ. Kabẽn jarẽnh djwỳnhmã 'ã ajarẽ. Nhym arỳm kukwakam me bakukãmãremã kum, “Me kurerer'õ, me'õ kraxje kute o nõr kêtja dja arỳm tujarô nhym ĩ kra ruw. Nhym me arỳm idji'ã abenmã kum, ‘Emane’, anhỹro ba.” Nãm ã kabẽn jarẽnh djwỳnh Bẽnjadjwỳr djwỳnh kukwakam me bakukãmãremã ane. Nhym kam me aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm me bakamingrãnyrekam Jeju nã katon arỳm abatành ne ar ba. Ar ba:n arỳm tujarôkumrẽx. Kraxje me'õ kute o nõr kêtkam arỳm tujarôkumrẽx. Me kute me bakukãmãremã 'ã ujarẽnh kôt arỳm ã tujarôo ane. Kabẽn jarẽnh djwỳnh ne me bakukãmãremã kum, —Nhym me arỳm idji'ã abenmã kum, “Emane”, anhỹro ba. Be, ne ren me me bakabẽnkôt idjibê Emane'ã abenmã kum, —Kubê ne me banhõ Metĩndjwỳnh. Me banhõ Metĩndjwỳnh arỳm me baro'ã ar ba. Nãm ã kabẽn jarẽnh djwỳnh me bakukãmãremã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Metĩndjwỳnh kadjy mrãnh djwỳnh prõ'ã Jôdjemã karõn arỳm kum karõ pa. Nhym arỳm krã kato. Ne kam arỳm kabẽn kôt prõ'ỳr mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nãm 'ỳr mõr kajgon ikô'ã ikwã kêt. Kra rwỳkkambit ne ikô'ã ikwã. Nãm 'ỳr mõr kajgo nhym kam arỳm kra kutewa ruw nhym kumỳ. Kumỳ nhym arỳm kum Jeju jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ar kute kanhêtire mar ne ar myt apôx djà kurũm tẽ. Tẽ: nhym arỳm akati krãptĩ apêx nhym ar arỳm Djeruxarẽkam bôx. Pykabê Djudêjakam krĩraxbê Berẽkam ne Jeju ruw. Bẽnjadjwỳr raxbê Erodji memã ỹrri ne ruw. ");
INSERT INTO txuNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ar kute kanhêtire mar Djeruxarẽkam bôx ne arỳm me kukjêro tẽ. Ar memã kum, —Nhỹnh ne me'õ prĩreja? Dja kubê mebê idjaer nhõ Bẽnjadjwỳr rax. Kanhêtire kute rwỳk'ã amijakre ne bar arỳm omũ. Myt apôx djà'ãnh ne bar omũn kam amrẽ 'ỳr tẽn arỳm bôx. Ije kum rax jarẽnhmã bôx, ane. Nãm ar ã memã anhỹro tẽmo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Memã anhỹro tẽ: nhym arỳm bẽnjadjwỳr raxbê Erodji kuma, me kute ar arẽnhja ma. Kuman arỳm axwe: umar ne. Djeruxarẽkam me kunĩdjwỳ axwe: umar ne. ");
INSERT INTO txuNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nhym kam Erodji arỳm amiwỳr me rũnh 'uw. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ amiwỳr me ku'uw ne amijã meo akuprõ. Ne kam arỳm abej me kukjêro nhỹn memã kum, —Nhỹnh ne Kritu rwỳkmã? Nhỹnh ne Kritu rwỳk djàja? ane. Metĩndjwỳnh kute 'ã Bẽnjadjwỳrbê kumkati mẽnhkôt ne me kum Kritu jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nãm Erodji memã ane nhym me kum, —Pykabê Djudêjakam krĩbê Berẽkam ne rwỳk djà. ");
INSERT INTO txuNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Amrẽbê: ne Metĩndjwỳnh kabẽn jarẽnh djwỳnhmã arẽ. Kritu rwỳk djà'ã kum ajarẽ. Nhym kukwakam me bakukãmãremã 'ã ajarẽ. Me krĩmã arẽn kum, “Pykabê Djudêjakam krĩbê Berẽ, amã ne ba ikabẽn ne. Djãm Djudêjakam akajgo got? Abê bẽnjadjwỳr rax pyràk. Djudêjakam me bẽnjadjwỳr kunĩ dja amã arax jarẽ. Mỳkam? Bir, akam dja me'õ prĩre ruw ne ĩ arỳm bẽnjadjwỳr rax. Ne arỳm inhõ mebê idjaer pumũn meo ba. Dja meo ba kute mrãmri ne mrykĩ'ãtomtio ba djwỳnh kute õ mryo ba pyràk”, ane. Nãm kabẽn jarẽnh djwỳnh ã me bakukãmãremã anen arỳm 'ã pi'ôk no'ôk ne. Ga, Berẽkam Kritu rwỳkja pumũ. Pi'ôk jakôt ne bar arỳm omũ. Nãm me rũnh ã Erodjimã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nhym kam bẽnjadjwỳr Erodji amipdjun amiwỳr ar kute kanhêtire mar 'uw nhym ar arỳm 'ỳr bôx. 'Ỳr bôx nhym me kàxã arkum, —Nhỹnhjakam ne kanhêtire amirĩt djà? Mỳj ne kanhêtire kute amirĩt'ã amex kute? ane. Nhym ar arỳm prĩne kum arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nhym kam arỳm Berẽmã ar anon arkum, —Aje. Dja gar tẽn prĩne me'õ prĩre jabej ne kum akato. Kum akaton on amrẽ iwỳr tẽn imã 'ã ajarẽ. Badjwỳ 'ỳr itẽm ne ije kum rax jarẽnh prãmkumrẽx. Aj mã, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nhym ar bẽnjadjwỳr rax kabẽn mar pan arỳm 'ỳr tẽ. 'Ỳr tẽ: nhym ar aêrbê kanhêtireja mõ. Tãm ne ar myt apôx djà'ãnh omũ. Arỳm ar kukãm mõ. Nãm ar kukãm mõ:n arỳm iby arek wajêt. Prĩre rwỳkja nhiby arek wajêt nhym ar arỳm omũ. ");
INSERT INTO txuNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Omũn arỳm kĩ:nhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ne kôt tẽ:n arỳm ũrkwã'ỳr bôx. Ne kam arỳm wadjàn prĩreja pumũ. Nã Marij ne kumỳn o nhỹ nhym ar omũ. Ne kam amikajgo man arỳm amijo ngriren parbê tu mỳrbê rôrôk ne. Parbê kum rax jarẽnho ikwã. Ne kam arỳm kàjmã krĩn arỳm nêkrêx 'ãpre bôn kum adjuw. Kẽn karỳrmẽ pĩ djur, me kute kuwykam rẽnh nhym kudjỳjamẽ me kudjỳ djàbê mirajamẽ ne ar kum adjuw. ");
INSERT INTO txuNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ne kam kàjmã djan pry 'õdjwỳ kôt akubyn ar õ pykamã tẽ. Me'õ ne ar biptirkam arkum, —Kwãrĩk wãnh akubyn Erodji'ỳr atẽm kêt, ane nhym kam ar akubyn Erodji jaà'ã tẽ. Tẽ:n arỳm ar õ pykakam bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nãm ar kute kanhêtire marja tẽ nhym kam Jôdje arỳm ngõr. Ngõr nhym ẽ, arỳm Metĩndjwỳnh kadjy mrãnh djwỳnh'õ bôx ne kum, —Kàjmã djan amibêx ne prĩremẽ nã aro akaton amũ pykabê Edjitumã aro tẽ. Erodji kute prĩre bĩnmã kute abej 'ỳr. Dja gar Edjitumã tẽn bôx ne arek kam ar aba. Ije amã arẽnhkambit dja gar akubyn tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nãm kum ane nhym arỳm kàjmã dja. Nhym akamàt kô rã'ã nhym arỳm prĩremẽ nã aro tẽ. Pykabê Edjitu'ỳr ne aro tẽn aro bôx. Ne kam ar arek kam ar ba. ");
INSERT INTO txuNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Amrẽbê: ne Bẽnjadjwỳr djwỳnh ar Edjitu'ỳr tẽm'ã ajarẽ. Kabẽn jarẽnh djwỳnhmã 'ã ajarẽ. Nhym arỳm kukwakam me bakukãmãremã kum, “Bẽnjadjwỳr djwỳnh ne me amã, ‘Ba ne ba ikra 'uw nhym arỳm Edjitu kurũm kato.’ Nãm ã me amã ane.” Nãm ã kabẽn jarẽnh djwỳnh me bakukãmãremã ane. Nhym kam me aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm me bakamingrãnyrekam Jôdje ar arỳm Edjitu'ỳr tẽ. Me bakukãmãremã 'ã ujarẽnh kôt ar arỳm Edjitu'ỳr tẽ. Arỳm Erodji tykkambit dja ar akubyn Edjitu kurũm tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jôdje ar Edjitu'ỳr tẽ nhym Erodji arỳm ar kute kanhêtire marja ma. Ne kam amim, —Je tô mỳkam ne ar imã 'êx ne iwỳr bôx kêt? ane. Nãm anen arỳm ngry:k ne. Ne amim, —Amũ akati ja'ã ne ar kute kanhêtire mar imã, “Bẽnjadjwỳr rwỳk ny'ã kanhêtire katorja'ã ne arỳm amex amãnhkrut apêx bar omũ”, ane. Be, kanhêtire kator'ã amex amãnhkrut apêx kôt godja bẽnjadjwỳr rwỳk ny'ã arỳm amex amãnhkrut ne apêx jabej. Nãm ã amim anen arỳm õ krãkamngônhmã kum, —Me on Berẽkam me prĩre nhimex. Bu'ã Berẽ nhõ pyka kunĩkôtdjwỳ dja ga me me prĩre nhimex. Mybit dja ga me kunĩ nhimex. Me prĩre rwỳk'ã amex amãnhkrut apêx nhijukribit dja ga me me imex kêt, ane. Erodji õ krãkamngônhmã ane nhym me arỳm me prĩre'ỳr mõn me imexo mõ. Me imexo mõn arỳm me imex pa. Nhym me arỳm amak djàje mỳro kumex. ");
INSERT INTO txuNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Amrẽbê: ne Metĩndjwỳnh me mỳr kumex'ã ajarẽ. Kabẽn jarẽnh djwỳnhbê Djermimã 'ã ajarẽ. Nhym arỳm kukwakam me bakukãmãremã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ota krĩbê Ramakam me mu:w ne kàj bê amra:. Rakeu krao amak djàje me mu:w. Kra arỳm kubê kêtkam ne me te kute memã kaprĩ kwỳ ngrimã.” Nãm ã kabẽn jarẽnh djwỳnh Metĩndjwỳnh kukwakam me bakukãmãremã ane. Nhym kam me aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm me bakamingrãnyrekam ne me arỳm mỳro kumex. Krãkamngônh arỳm me prĩre nhimex ne nhym me arỳm amak djàje mỳro kumex. Djermi kute me bakukãmãremã 'ã ujarẽnh kôt me arỳm ã mỳro ane. ");
INSERT INTO txuNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Jôdje ar Edjitukam ar ba: nhym kam Erodji arỳm ty. Ty nhym kam Jôdje arỳm biptiro nõ. Biptiro nõ nhym Metĩndjwỳnh kadjy mrãnh djwỳnh'õ arỳm kum amijo amirĩt ne kum, ");
INSERT INTO txuNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Kàjmã djan prĩremẽ nã aro tẽ. Me abê idjaer nhõ pyka'ỳr aro tẽ. Me kute bit prĩre bĩn prãmja ne me arỳm ty, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nhym kam Jôdje arỳm kàjmã djan prĩremẽ nã aro tẽ. Aro tẽn amũ mebê idjaer nhõ pyka'ỳr aro tẽ. 'Ỳr aro tẽ:n arỳm 'ỳr aro bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","'Ỳr aro bôx nhym me arỳm kum, —Erodji kra Akireu arỳm pykabê Djudêjakam bãm pãnh memã bẽnjadjwỳr, ane. Nãm me Jôdjemã ane nhym arỳm kum uman Djudêja'ỳr tẽm prãm kêt. Ne kam õtkam me'õ arỳm nêje kukrà. Nhym kuman arỳm pykabê Djudêja nhibej tẽn kam pykabê Garrêjakam bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ne ajte tẽ:n arỳm krĩraxbê Nadjarekam bôx ne kam ar ba. Kam ar ba: nhym kam Jeju arỳm kam abatành ne. Amrẽbê: ne Metĩndjwỳnh ja'ã ajarẽ. Jeju Nadjarekam abatành'ã ajarẽ. Kabẽn jarẽnh djwỳnhmã 'ã ajarẽ. Nhym arỳm kukwakam me bakukãmãremã kum, “Dja me abenmã 'ã, ‘Nadjarekam ne abatành djà’, anhỹro ba.” Nãm ã ujarẽnh djwỳnh Metĩndjwỳnh kukwakam me bakukãmãremã ane. Nhym kam me aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm me bakamingrãnyrekam arỳm 'ỳr o bôx nhym Jeju arỳm Nadjarekam abatành ne. Me bakukãmãremã 'ã ujarẽnh kôt ne arỳm Nadjarekam abatành ne. ");
INSERT INTO txuNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jeju Nadjarekam ar ba: nhym kam ngômã me angjênh djwỳnhbê Djuão arỳm bôx. Pykabê Djudêjakam kapôt kukritkam ne Djuão me akreo ba. Me ta ne me 'ỳr ban bôxo kumex nhym ar me akreo ba. ");
INSERT INTO txuNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nãm memã kum, —Me amikam akaprĩren wãnh ajaxwemã anhiren Metĩndjwỳnh'ỳr amijo akẽx. Arỳm kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo ba 'ỳr. Nãm ã Djuão memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Amrẽbê: ne Metĩndjwỳnh Djuão kukãm 'ã ajarẽ. 'Ã ujarẽnh djwỳnhbê Idjaijmã 'ã ajarẽ. Nhym arỳm kukwakam me bakukãmãremã kum, “Me'õ dja kapôt kukritkam memã kabẽn ne. Kàj bê dja me akren memã kum, ‘Me apa. Ẽ, on Bẽnjadjwỳr djwỳnh kutêp wãnh ajaxwemã anhiren katàt amijo aba. Kute mrãmri ne me kute bẽnjadjwỳr rax kutêp pryo mex ne kute kum katàt pry jadjwỳrja pyràk’, ane. Dja ã ujarẽnh djwỳnh Bẽnjadjwỳr djwỳnh'ã memã ane.” Nãm ã Idjaij Djuão'ã me bakukãmãremã ane. Nhym kam me aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũmràm 'ỳr o bôx nhym Djuão arỳm kato. Me bakamingrãnyrekam katon arỳm ã me akreo bao ane. Metĩndjwỳnh kute me bakukãmãremã 'ã ujarẽnh kôt Djuão arỳm katon ã me akreo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Be, Djuão ne mry jabatànhbê kameru kĩ nhipêxo kubẽkàn angij ne mry kào amikrax pren krytkanhê kun menh kangôo ikõ. ");
INSERT INTO txuNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nhym kam krĩraxbê Djeruxarẽkam me ja Djuão'ỳr bôxo dja. Bu'ã pykabê Djudêjakam me jadjwỳ Djuão'ỳr bôxo dja. Ngôbê Djodão bu'ã pykakam me jadjwỳ 'ỳr bôxo kume:x ne. Nãm me Djuão'ỳr ban bô:xo dja. ");
INSERT INTO txuNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ne kam amijaxwe kôt amijarẽn memã kum, —Be, mrãmri ne ba ijaxwe tũm krãptĩ. Arỳm imã kĩnh kêt ne wãnh kum inhire, ane. Nhym kam ngô raxbê Djodãokam mã Metĩndjwỳnhmã me angij. ");
INSERT INTO txuNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nhym kam mebê pardjêumẽ mebê xadjudjêumẽ krãptĩ arỳm Djuão'ỳr bôxo dja. Nhym me omũn memã kum, —Me akamingrãny ne ga me abê iry. Mỳj me'õ got ne me amã Metĩndjwỳnh ngryk nhõ akati jarẽ ga me umaje iwỳr aprõt kajgo? ");
INSERT INTO txuNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","On katàt amijo aba gê me mrãmri me amex jabej me amã kato. Mrãmri ga me amikam akaprĩren wãnh ajaxwemã anhirern aje Metĩndjwỳnh'ỳr amijo akẽx jabej gê me me amã kato. Ne kam me akam kĩnhkumrẽx kute mrãmri ne me kute pidjô djô mexmã apôx ne kam kĩnhja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kwãrĩk wãnh me anhõkre kadjwỳnhbê anhingêt kukãmãre Abraãoo adjàmra kêt ne amim, —Me ba ne ba me ibê Abraão tàmdjwỳ. Dja Metĩndjwỳnh me ikam ngryk kêt. Dja ba me te ijaxwe nhym kam me inhingêt kukãmãre Abraãokôt Metĩndjwỳnh kum me ijabê ne me ijaxwekam me ijo bikẽnh kêtkumrẽx, ane. Kwãrĩk wãnh ga me ã anhỹr ar aba kêt. Kati. Ẽ, ba me amã arẽ. Dja ga me te abê Abraão tàmdjwỳ nhym Metĩndjwỳnh tu me ajo ajkẽ, me ajaxwe pãnh tu me ajo ajkẽ. Ne ren kute ajte Abraão tàmdjwỳ prãm jabej ren tu kẽnjao itun o amim Abraão tàmdjwỳ nhipêx nhym me ren tu katon kumex. ");
INSERT INTO txuNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ẽ, mrãmri arỳm 'ỳr. Metĩndjwỳnh kute memã axwe pãnh jarẽnh nhõ akati arỳm 'ỳr. Kute mrãmri ne pidjô apỹnh abenkam ô kêt nhym me kute kàr ne o mrãnh ne kute kuwykam rẽnhja pyràk. Arỳm ne Metĩndjwỳnh me ajã pidjô djô kêt jakren arỳm me ajaxwe pãnh kute me ajo bikẽnh 'ỳr. Dja me ajo mõn kuwykam me amẽ. Arỳm 'ỳr. Kute mrãmri ne me'õ kute pidjômã 'yr kadjy kute parbê kàxkrãkô mỳnh ne o ãm pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mrãmri ba ne ba ngômãbit me ajangij. Ga me amikam akaprĩren wãnh ajaxwemã anhiren Metĩndjwỳnh'ỳr amijo akẽx ba ngômãbit me ajangij. Nhym be, itotokbê ne me'õ bôxmã. Me'õ tãm ne raxo kute amũ ijakrenh, kute ijakrenh mexi. Nã bãm te irax ne 'ỳr ibikamẽnh prãmje. Nã bãm te irax ne 'ã inhibôn ije kum parkà 'ã pre bônh ne o itẽm prãmje. Be, ãm irax ba ren arỳm kum apê. Nhym be, kati. Ãm ingrire. Nãm raxo ijakrenh mex ne. Tãm ne arỳm bôx 'ỳr. Djãm ngômã kute me ajangjênhmã? Kati. Tãm dja bôx ne kam me awỳr Metĩndjwỳnh Karõ jano. Katàt me aje amijo ababit'ỳr dja ano kute me ajo bamã. Ne kam me ajaxweja kute kuwymã me arẽnhmã. ");
INSERT INTO txuNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Gêdja bôx ne kam kute mrãmri ne me kute kôtyk byr ne o kute bàygogore ka'uk ne kute kam mũm 'ynhĩ, 'y mexjao atom ne kam kute 'ykàjao tẽm ne kute kuwykam mẽnh nhym xêtja pyràk. Dja me'õja bôx ne ã me axweo anen kuwykam me kurẽ. Nhym kuwyja dja pôk rã'ã: rã'ãn apêx kêtkumrẽx. Nhym be, me mex, me katàt kute amijo baja'ã gêdja 'y mex jakren mũm meo atom. Meo atom ne kàjkwakam õ pykamã meo mõ gê me kam kam kĩnhkumrẽx ne ar ba. Arỳm kute meo anhỹr 'ỳr. Nãm ã Djuão mebê pardjêumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kam Jeju arỳm pykabê Garrêja kurũm tẽ. Tẽ:n arỳm ngôbê Djodão'ỳr bôx. Nãm 'ỳr bôx ne arỳm Djuão'ỳr bôx. Kute Metĩndjwỳnhmã ngômã adjàrmã ne 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nhym kum, —Djãm ba ije ngômã ajadjàrmã? Kati. Ba ne ga ren Metĩndjwỳnhmã ngômã ijadjà, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nhym kum, —Kati, kwãrĩk rã'ã. Metĩndjwỳnh kute gu bamã katàt baje amijo baba'ã karõ kôt dja gu prĩne katàt amijo baba. Kam dja kĩnhkumrẽx. Kam dja ga on ngômã ijadjà, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nhym arỳm ngômã adjà. Nhym kam wabin dja nhym aêrbê kàjkwa arỳm aben bê ajkij. Aben bê ajkij nhym me kute omũnh kadjy Metĩndjwỳnh Karõ kute tut pyràk arỳm 'ỳr ruw ne 'ã tỹm. 'Ã tỹm nhym Djuão arỳm omũ. ");
INSERT INTO txuNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nhym ẽ, arỳm kàjkwa kurũm Metĩndjwỳnh memã kabẽn ne memã kum, —Ikra ne wã. Imã abê:kumrẽx. Ba kam kam ikĩnhkumrẽx. Nãm ã Metĩndjwỳnh Kra'ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nhym kam Metĩndjwỳnh Karõ kapôt kukritmã Jejuo katon o mõ. Dja Xatanaj te kute axwe'ã mẽnhmã kum apnê. Ja kadjy ne o mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nhym kam Jeju Metĩndjwỳnhmã amijajbu. Nãm amijajburo dja: nhym 'ã akatibê 40 apêx. Nhym kam arỳm kum prã:m ne. ");
INSERT INTO txuNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nhym kam me axwe'ã memã àpnênh djwỳnhbê Xatanaj arỳm 'ỳr tẽn 'ỳr bôx. Nãm bit kute amikôt o ba nhym kôt axwemã 'ỳr bôx. Ne kam kum, —Ẽ, goja abê Metĩndjwỳnh Krakumrẽx jabej ne goja kẽnjamã akabẽn gê goja kubê djwỳ ga krẽ, ane. Nãm Xatanaj ã Jejumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nhym kam kum, —Kati. Mỳkam? Bir, Metĩndjwỳnh ne amrẽbê: me ikukãmãremã kum, “Djãm djwỳobit dja me amitỳx ne tĩn ne ar ba? Kati. Metĩndjwỳnh kabẽnodjwỳ dja me amitỳx ne tĩn ne ar ba, kabẽn kunĩo.” Nãm ã Metĩndjwỳnh me ikukãmãremã ane nhym me arỳm 'ã pi'ôk no'ôk ne. Ije Metĩndjwỳnh kabẽn ja markam ije akabẽnkôt kẽno djwỳ prãm kêt. Nãm ã Jeju kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nhym kam Xatanaj Djeruxarẽ'ỳr o tẽn o bôx. Krĩrax jamã ne me kum, “Metĩndjwỳnh nhõ krĩrax”, ane. Nãm o bôx ne o tẽn Metĩndjwỳnh nhõ kikreti'ỳr o bôx. Ne kam o tẽn o wabin kikreti nhimõk'ỳr o bôx ne anhà'ã kudja. ");
INSERT INTO txuNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ne kam kum, —Ẽ, goja abê Metĩndjwỳnh Krakumrẽx jabej goja rũm tẽn ato. Amrẽbê: ne me akukãmãre amã arẽ. Metĩndjwỳnh kukwakam amã arẽn amã, “Dja ba ajã ikadjy mrãnh djwỳnhmã karõ. Dja me atẽmkôt amã ikra dja gê kẽn'õ apar ngãnh kêtkumrẽx.” Nãm ã Metĩndjwỳnh me akukãmãre amã ane nhym me arỳm 'ã pi'ôk no'ôk ne. Ajrã, rũm tẽn ato gê goja me atẽmkôt amã ikra dja, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nhym Jeju kum, —Kati. Mỳkam? Bir, ba ajte amã arẽ ga ama. Amrẽbê: ne me ikukãmãre memã arẽ. Metĩndjwỳnh kukwakam memã arẽn memã kum, “Kwãrĩk wãnh Bẽnjadjwỳr djwỳnh, Atĩndjwỳnh kabi kêt, kute ajãno ãm jabej kabi kêt”, ane. Nãm ã Metĩndjwỳnh me ikukãmãremã ane nhym me arỳm 'ã pi'ôk no'ôk ne. Ije Metĩndjwỳnh kabẽn ja markam ne ba ije akabẽnkôt rũm itẽm ne idjàtor prãm kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nhym Xatanaj ajte o tẽn krãnh prêkti nhimõk'ỳr o wabi nhym dja. Nhym kam apỹnh pyka djàri nhym Xatanaj arỳm kum kunĩ jakreo dja. Ne apỹnh bẽnjadjwỳr kute meo ba djàri kum me kunĩ jakreo dja. Nhym apỹnh me õ mỳjja rũnh ne uma djàri nhym kum me kunĩ jakreo dja nhym arỳm kunĩ pumũ. ");
INSERT INTO txuNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nhym kam kum, —Ba amã ja kunĩ kanga. Ba amã me õ mỳjja rũnh ne uma kunĩ kanga. Dja ga amijo angrin ikuka kônh akõnkrão nhỹn imã irax jarẽ ba arỳm amã kungã. Ba amã kunĩ ngã ga arỳm idjô'ã o aminhõn ar o aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nhym Jeju kum, —Kati, Xatanaj, on rũm imã akàx. Djãm ije akuka kônh ikõnkrão inhỹrmã ne ije amã arax jarẽnhmã? Arkati. Mỳkam? Bir, amrẽbê: me ikukãmãre memã arẽ. Metĩndjwỳnh kukwakam memã arẽn memã kum, “Bẽnjadjwỳr djwỳnh, Atĩndjwỳnhmãbit dja ga amijo angrin kum rax jarẽn ajbitmã apê. Kwãrĩk wãnh atemã 'õmã rax jarẽnh kêt.” Nãm ã Metĩndjwỳnh me ikukãmãremã ane nhym me 'ã pi'ôk no'ôk ne. Ije Metĩndjwỳnh kabẽn ja markam ne ba ije akuka kônh ikõnkrão inhỹr ne ije amã arax jarẽnh prãm kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nhym kam Xatanaj arỳm kum kàx ne mã tẽ. Nhym kam kadjy mrãnh djwỳnh ar arỳm 'ỳr bôx ne o djuw mex. ");
INSERT INTO txuNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nhym kam Jeju arỳm tẽ. Tẽ:n pykabê Garrêjakam bôx. Me arỳm kute Djuãoo tỹm ne kubê ijêkam ne Garrêjakam bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nãm Garrêjakam krĩraxbê Nadjarekam bôx. Ne kam kurũm katon kam amũ krĩraxbê Kapanakam tẽn bôx ne nhỹ. Imôti mỳrri ne Kapana dja. Me kute Kapana bu'ã pykamã Djeburõmẽ Naptar jarẽnh. Kam ne krĩraxbê Kapana dja. ");
INSERT INTO txuNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Amrẽbê: ne ujarẽnh djwỳnhbê Idjaij me bakukãmãremã arẽ. Jeju Kapanajakam bôx jarẽ. Metĩndjwỳnh kukwakam ne Idjaij memã arẽn memã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Pykabê Djeburõ, pykabê Naptar. Imôti'ỳr pyka. Ngôbê Djodão nhikjêbê pyka. Me bajtem nhõ pyka jamã ne me kum Garrêja jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Pyka jakam ne me axwe:. Me mrãnh punu:re kute mrãmri ne akamàt kô tykkam me mrãnh punu pyràk. Me ja ne me arỳm me'õ me:xkumrẽx pumũ kute mrãmri ne me kute memã irã djà rax pumũnh pyràk. Pyka jakam ne me kaprĩre ne ar ba. Kute mrãmri ne me on tyk karõ kaprĩn ar ba pyràk. Me ja ne me arỳm me'õ me:xkumrẽx pumũn kĩnhkumrẽx ne. Me kĩnhkumrẽx kute mrãmri ne ajte arngrokam me kĩnh pyràk”, ane. Nãm Idjaij ã me bakukãmãremã ane. Nhym kam me aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm me bakamingrãnyrekam Jeju arỳm Kapanakam bôx. Me:xkumrẽx ne arỳm kam bôx. Idjaij kute me bakukãmãremã 'ã ujarẽnh kôt ne bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ne kam arỳm kàj bê me akremo krax. Ne amijã memã kum, —Amikam akaprĩren wãnh ajaxwemã anhiren Metĩndjwỳnh'ỳr amijo akẽx. Arỳm kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo ba 'ỳr. Nãm ã Jeju me akreo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nhym kam Garrêjakam Jeju imôti mỳrbê tẽ. Nhym Ximãomẽ Ãngre ar axikôt katorja ngôkam ar kryre rẽnho ba nhym arỳm ar omũ. Ximãomã ne me Pedru jarẽ. Ar kubê tep pynênh djwỳnh tũm. ");
INSERT INTO txuNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nãm ar ar kryre rẽnho ba nhym Jeju arkum, —On ar mã ikôt ajkamẽ. Jakam dja gar ikôt me kamẽnho aba kute mrãmri ne ar aje tep pynênho aba pyràk, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nhym ar on amikôt kryre mẽn arỳm mã Jeju kôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nhym ãm ajbir tẽ nhym Xijagumẽ Djuão ar kàkam nhỹ nhym arỳm ar omũ. Ar axikôt kator. Djebedêu ne ar adjuw. Djebedêumẽ ne ar amim kryreo mexo nhỹ. Nãm ar omũn arỳm kàj bê amikôt ar ku'uw. ");
INSERT INTO txuNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nhym bãm Djebedêu kàkam nhỹ nhym ar arỳm wãnh kum iren mã Jeju kôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nhym kam Jeju Garrêjakam pyka kunĩkôt memã kukràdjà jarẽnho ba. Apỹnh mebê idjaer bikprõnh djàri memã arẽnho ba. Ne kàj bê ujarẽnh ny jarẽnho ba. Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo ba'ã memã ujarẽnh ar ba. Ne kam arỳm apỹnh me kanêmẽ me punuo mexo ba. ");
INSERT INTO txuNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nhym me arỳm arẽnh kumex. Pykabê Xirijkam ne me prĩne me kunĩmã arẽnho ipôk ne. Arẽnho ipôk nhym me kunĩ arỳm Jeju jarẽnh ma. Ne kam arỳm 'ỳr me punu kunĩo bôx. Apỹnh me kanê djàri meo bôx. Ajte apỹnh me tokry djàri meo bôx. Nhym me kwỳ me karõ punu kute meo baja nhym me meo bôx. Nhym me kwỳ me tyk kute meo baja nhym me meo bôx. Nhym me kwỳ akry nhym me meo bôx. Nhym kam arỳm me kunĩo mex. ");
INSERT INTO txuNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nhym kam me krãptĩ: arỳm 'ỳr bôx ne kôt ar ba. Pykabê Garrêja kurũm, pyka nhidjibê Krĩraxbê 10 kurũm, krĩraxbê Djeruxarẽ kurũm, pykabê Djudêja kurũm, ngôbê Djodão nhijukri pyka kurũm ne me bôx ne kôt ar ba. ");
INSERT INTO txuNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kam ne me krãptĩ: Jeju kôt ar ba nhym me omũ. Ne kam arỳm krãnh'ã tẽn wabi. Wabin arỳm nhỹ. Nhỹ nhym kôt ba djwỳnh ar arỳm 'ỳr bôx ne nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nhym arỳm arkum amikabẽn jarẽnhmo krax ne kum, ");
INSERT INTO txuNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Ẽ, djãm me kute amim, “Ikajgo”, anhỹro baja djãm me kaprĩ got? Kati. Mỳkam? Bir, me wã dja kàjkwakam Bẽnjadjwỳr djwỳnh amim me utàn meo ba. Kam dja me kĩ:nhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Djãm me mỳr baja kaprĩ got? Kati. Mỳkam? Bir, me wã dja Metĩndjwỳnh ĩ meo kĩnhkumrẽx. Kam dja me kĩ:nhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Djãm me kabôt katija kaprĩ got? Kati. Mỳkam? Bir, me wã dja me ĩ pykakam mỳjja kunĩo õ. Kam dja me kĩ:nhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Me kute memã kum, “Ba on Metĩndjwỳnhmã ijaxwe kêt”, anhỹro ba ne kute katàt amijo ba prã:mja djãm me kaprĩ got? Kati. Mỳkam? Bir, me wã dja me ĩ axwe kêt'ỳr bôxkumrẽx ne arỳm prĩne Metĩndjwỳnhmã mexkumrẽx. Kam dja me kĩ:nhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Djãm me ukaprĩja kaprĩ got? Kati. Mỳkam? Bir, me wã dja Metĩndjwỳnh kum me kaprĩkumrẽx. Kam dja me kĩ:nhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Djãm me kute amikam axwe'õ mar kêtja kaprĩ got? Kati. Mỳkam? Bir, me wã dja me Metĩndjwỳnh pumũ. Kam dja me kĩ:nhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Djãm me kute aben nêje me kukrào baja kaprĩ got? Kati. Mỳkam? Bir, me wã'ã dja me abenmã kum, “Metĩndjwỳnh kra ne wã”, ane. Kam dja me kĩ:nhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Me katàt kute amijo baja dja me te katàt nhym me arỳm meo ajkẽ. Me katàt kute amijo bakam meo ajkẽ. Djãm kam me kaprĩ got? Kati. Mỳkam? Bir, me wã dja kàjkwakam Bẽnjadjwỳr djwỳnh arỳm amim me utàn ar meo ba. Kam dja me kĩ:nhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ar ga dja gar ikabẽn markumrẽx ne kôt ar amijo aba nhym me te wãnh ar amã akij ne te ar ajo ajkẽn te ar ajaxweo ar apytà, apỹnh ar ajaxwe djàrio ar apytà. Djãm kam ar akaprĩ got? Kati, Mỳkam? Bir, kàjkwakam akĩnh djà raxkam. ");
INSERT INTO txuNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dja gar tu akĩnhkumrẽx ne kam akĩnh kati. Mỳkam? Bir, dja Metĩndjwỳnh ar amã o pãnh rax ne. Kàjkwakam gêdja amã o pãnh mex ne. Kàjkwakam kute ar amã o pãnh mex ja dja gar amikukãm aman kam akĩnh kati. Nãm me tũmre ã axwe anen me kamingrãny kajmã'ã ã Metĩndjwỳnh kabẽn jarẽnh djwỳnho bikẽnho bao ane. Ga, arỳm kam kàjkwakam me kĩnhkumrẽxja pumũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ne kam ajte arkum, —Ar aje kadjwanhĩ pyràk. Kadjwanhĩ kute õmrõo mex pyràk ar gadjwỳ dja gar ajmã akute kêt ne akabẽn mexkumrẽx ne ar aba nhym ar abu'ã me ja kwỳ ar akudjwa arỳm mex jabej. Dja kadjwanhĩkam akry apêx jabej mỳj dja ajte akry kadjy kam nẽ? Arkati. Arỳm mỳjja akry kadjy punukumrẽx. Godja punukam me kum kĩnh kêt ne arỳm rũm kapĩ. Kapĩ nhym me arỳm 'ã mrãn paro kajy. Ar gadjwỳ godja gar memã kum, “Ba ne ba ije Jeju mar”, ane. Ne ate kam ar ajaxwe gar arỳm apunu. Apunu nhym me arỳm kum ar akĩnh kêt ne ar apunukôt kum Metĩndjwỳnhdjwỳ kĩnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ar aje mrãmri ne pyka kunĩkôt me kurwỳ djà pyràk. Ga, krĩraxja pumũ. Djãm krãnhre'ã me kute krĩrax nhipêxkam me kute o bipdjurmã? Arkati. Ar gadjwỳ kwãrĩk wãnh ikam apijàm kêt ne ikôt adjukaprĩ. ");
INSERT INTO txuNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ngônhpôkdjwỳ. Djãm me kute kum angjênh ne kute mỳjja 'õkôt o bipdjur got? Kànoipôko 'ã pro got? Kati. Ngônhpôk ne me kum angij ne tu parkam, kênhkam umjuw nhym me kunĩmã kikre kre kurwỳo ku'ê. ");
INSERT INTO txuNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ar gadjwỳ kwãrĩk wãnh ikam apijàm kêt. Ar abê me kurwỳ djà pyràk ne ar adjukaprĩ. Dja me ar adjukaprĩ pumũn arỳm kàjkwakam ar Abãmmã rax jarẽ. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ne kam ajte arkum, —Kwãrĩk wãnh ijã amim, “Be, mỳj kadjy ne Jeju bôx? Bir, kute memã kum, ‘Kwãrĩk wãnh jakam Môjdjê kabẽnja mar kêt. Ne Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh 'õdjwỳ kabẽnja kwãrĩk wãnh mar kêt.’ Kute ã memã anhỹro ba kadjy ne bôx”, ane. Kwãrĩk wãnh ijã ã amim anhỹr kêt. Djãm ije ja jarẽnhmã? Kati. Mỳkam? Bir, me amrẽbê: me bakukãmãremã ijã ajarẽ. Nhym me aben djô'ã arẽnho mõ:. Arẽnho mõr tãmtã arỳm iwỳr o bôx. Ba kam arỳm me kute amrẽbê: ijã ujarẽnh kôt ar amijo iba. Me kute ikukãm ijã ujarẽnh kôt ije amijo anhỹr kadjy ne ba bôx. Kam ije ar kabẽn markumrẽx ne ije ar'ã anhỹr prãm kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Dja te Metĩndjwỳnh kabẽn kukràdjà kwỳ'ã pi'ôk no'ôk kryre ne te apỹnh mỳrbê kyx djàri'ã pi'ôk no'ôk kryre djãm 'õ kajgomã? Kati. Dja 'õ kajgo kêt. Kabẽn'ã pi'ôk no'ôk kôt dja mỳjja apôxkumrẽx. Kôt dja mỳjja kunĩ apôx tẽ:n prĩne apôx mexkumrẽx. Kabẽn 'õ dja kajgo kêtkumrẽx. Nhym kam kàjkwamẽ pyka arỳm apêx. Mrãmri ne ba ar amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Godja me'õ Metĩndjwỳnh kabẽn ngrire 'õmã kajgo jarẽn kam 'ã memã kum, “Kabẽn ja dja ga me mar rerekre”, anhỹro ba jabej, dja me adjwỳnhdjwỳmã kum, “Akajgo”, ane. Kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo bakam dja me kunĩ kum, “Akajgo”, anhỹro kumex. Nhym be, dja me'õ Metĩndjwỳnh kabẽn man kôt ar amijo ban kam memã kabẽn jarẽnho ba. Me'õ jamã dja me kum, “Araxkumrẽx”, ane. Kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo bakam dja me kum, “Araxkumrẽx”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kam, ba ar amã arẽ gar ama. Djãm mrãmri Môjdjê kukràdjà mar djwỳnhmẽ mebê pardjêu mexkumrẽx? Kati. Mrãmri ar aje katàt amijo abakam ne o aje me akrenhkambit dja kàjkwakam Bẽnjadjwỳr djwỳnh amim ar apytà gar kôt ar amijo aba. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ne kam ajte arkum, —Amrẽbê: me bakukãmãre memã kum, “Kwãrĩk wãnh me par kêt”, anen ajte, “Dja me me'õnh bĩ nhym me arỳm kum axwe pãnh jarẽ”, ane. Tãm ne me ar amã arẽ gar arỳm ama. ");
INSERT INTO txuNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nhym be, ba dja ba ar amã arẽ gar ama. Djã ne me me'õnh bĩ nhym me arỳm kambit kum axwe pãnh jarẽ? Kati. Me kute me'õkam ngrykkamdjwỳ. Dja me axwe jabej kukjêr kêt ne tu kam ngryk. Nhym kam me arỳm kum axwe pãnh jarẽ. Ba ajte ar amã arẽ gar ama. Me kute ikukwakam abeno kamyja godja me kum kamy kurêkam kum, “Apunure”, anhỹr jabej nhym kam me arỳm 'ã meo akuprõ. Memã axwe pãnh jarẽnh djwỳnh krãptĩbê 70 jao akuprõ nhym me arỳm memã amikôt amijarẽ. Nhym be, godja me kamymã kum, “No kêt”, anhỹr jabej ne kam arỳm me biknor tokry djàkam kuwykam mõr jabej. ");
INSERT INTO txuNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kam godja ga Metĩndjwỳnh nhõ ki'ỳr kĩnh djào abôx jabej. O abôxo tẽn kam akamy ma. Aje o akamyja kute ajã, “Nãm ijo ajkẽ”, anhỹrja ga ama. Akam kaprĩja ga ama. Djãm kam aje on Metĩndjwỳnhmã kĩnh djàja nhõrmã? Kati. Dja akamy akam kaprĩ ga Metĩndjwỳnhmã kĩnh djàjao bôx nhym Metĩndjwỳnh arỳm kum kĩnh djàja kĩnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Kam dja ga wãnh ki kabem kĩnh djàjamã anhiren akamy kumrẽx'ỳr tẽn kam kum akabẽn mex jarẽ gê akubyn akam kĩnh. Akubyn akam kĩnhkam dja ga akubyn tẽn kam kĩnh djàja mỳn Metĩndjwỳnhmã angã. ");
INSERT INTO txuNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Dja me'õ mỳjjakam kum akurên memã axwe pãnh jarẽnh djà'ỳr ajo tẽm jabej. 'Ỳr ajo tẽmri dja ga on o anhõbikwa. O anhõbikwa nhym arỳm memã axwe pãnh jarẽnh djà'ỳr ajo tẽm kêt. Nok ga ren o anhõbikwa kêt nhym ren memã axwe pãnh jarẽnh djwỳnhmã akanga nhym ren mebê ijê djwỳnhmã akanga. Nhym kam ren mebê ijê djàkam abê ijê. ");
INSERT INTO txuNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ga ren kam akator kêt. Prĩne aje amijo pãnh mex inomã mẽnhkambit ren akato. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ne kam ajte arkum, —Nãm me ar amã, “Kwãrĩk wãnh mebê prõ, nàr mjêno adjàkĩnh kêt”, ane. Ja ne me ar amã arẽ gar ama. ");
INSERT INTO txuNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nhym be, ba dja ba ar amã arẽ gar ama. Mrãmri ro'ã anõrkam ajaxwe. Djãm kambit ne ajaxwe? Kati. Dja gar me'õ nire pumũn arỳm amã o anõr prãm ne. Jabit. Kam arỳm akadjwỳnhbê amim o adjàkĩnh'ã karõ. Kamdjwỳ arỳm ajaxwe. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ne kam Ar kubê axwe pyma. Ga, me kute apỹnh kukràdjào àpênh jaxwe prãmja pumũ. Me kute àpênh jaxweo krã'yrmã ne Jeju Ar kubê axwe pyman arkum, —Ne ga ren ano djubôko ajaxwe prãm ga ren on kaban mũm amibê amẽ. Ren te ano nhikjê kêt ne ren Metĩndjwỳnh kôt atĩn ne ar aba rã'ã, kam ren akĩnhkumrẽx. Ne ren ano amãnhkrut rã'ã nhym Metĩndjwỳnh ren me biknor tokry djàkam amẽ. Ga ren kam akaprĩkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne ga ren anhikra djubôko ajaxwe prãm ga ren on krãtan mũm amibê amẽ. Ren te anhikra nhikjê kêt ne ren Metĩndjwỳnhkôt atĩn ne ar aba rã'ã kam, ren akĩnhkumrẽx. Ne ren anhikra amãnhkrut rã'ã nhym Metĩndjwỳnh ren me biknor tokry djàkam amẽ. Ga ren kam akaprĩkumrẽx, ane. Djãm mrãmri ne me kute amino kadjàrmã ne Jeju arkum karõ? Kati. Djãm mrãmri ar kute aminhikra krã'yrmã arkum karõ? Kati. Me kute àpênh jaxweo krã'yrmã ne Jeju Ar kubê axwe pyma. ");
INSERT INTO txuNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ne kam ajte arkum, —Me ar amã, “Me kute prõ kangamã gê me 'ã pi'ôk no'ôk ne kum kungãn kam kanga”, ane. Nãm me ã ar amã ane, gar ama. ");
INSERT INTO txuNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nhym be, ba dja ba ar amã arẽ gar ama. Gêdja me'õ prõ djwỳnh kangan kam arỳm axwemã ngrẽk. Gêdja prõ djwỳnhja pãnh me'õ mymã kabẽn nhym arỳm 'ỳr mõ. Nhym kam nija arỳm o akĩn kam axwe. Nhym kam my jadjwỳ arỳm o akĩn kam adjwỳnhdjwỳ axwekumrẽx. Nhym be, prõja krô'ã mjênkambit nhym myja kute kangakam axwe kêt. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ne kam ajte arkum, —Kam, amrẽbê: me bakukãmãre memã kum, “Dja gar memã akabẽn jarẽn amã me kute amar pydji prãm jabej kum, ‘Metĩndjwỳnh ne amybỳm kute imar. Ije amã ikabẽn pydjin arẽnhkôt kute imar’, anhỹrkam kwãrĩk wãnh 'ã adjukanga kêt. Dja gar aje memã akabẽn jarẽnh kôt ar amijo abakumrẽx. Nok ren ga kôt ar amijo aba kêt ne ren arỳm Metĩndjwỳnh jarẽnh kajgon ren o kum amikurêtuw”, ane. Nãm me bakukãmãre ã memã ane gar arỳm ama. ");
INSERT INTO txuNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nhym be, ba dja ba ar amã arẽ gar ama. Djãm ar aje memã akabẽn jarẽnhkam aje ajte kôt Metĩndjwỳnh nàr õ mỳjja'õ jarẽnhmã? Kati. Mrãmri dja gar memã akabẽn pỹnhbit jarẽ. Kwãrĩk wãnh aje memã akabẽn pydjin arẽnhkôt ajte memã kàjkwa jarẽnh kêt. Metĩndjwỳnh kam ỹrkam memã arẽnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kwãrĩk wãnh ar aje memã akabẽn pydjin arẽnhkôt ajte memã pyka jarẽnh kêt. Metĩndjwỳnh pykakam par djãm djàkam memã arẽnh kêt. Nàr, kwãrĩk wãnh ar aje memã akabẽn pydjin arẽnhkôt ajte memã Djeruxarẽ jarẽnh kêt. Kubê Bẽnjadjwỳr rax djwỳnh nhõ krĩraxkam memã arẽnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nàr, kwãrĩk wãnh ar aje memã akabẽn pydjin arẽnhkôt ajte akrã jarẽnh kêt. Mỳj ne gar aje omã? Djãm ar ga aje akrãkam akĩ 'õo akamã nàr akĩ 'õo kakrãtykmã? Arkati. Te aje akĩo anhỹrmã. ");
INSERT INTO txuNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kam, memã akabẽn pỹnhbit jarẽ. Aje mrãmri mỳjjao anhỹrmã. Kambit memã kum, “Nà. Dja ba ã o ane”, ane. Nàr, aje mỳjjao anhỹr kêtmã. Kam memã kum, “Kati. Dja ba o anhỹr kêt”, ane. Jabit memã arẽ. Memã akabẽn pỹnhbit jarẽ. Godja gar memã akabẽn jarẽ ne me kute ar amar pydji kadjy ajte kôt memã apỹnh mỳjja jarẽn arỳm akabẽn punu. Kute mrãmri ne me axwe nhõ bẽnjadjwỳr jajkwa kurũm akabẽn kator pyràk. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ne kam ajte arkum, —Me ar amã, “Amrẽbê: ne me bakukãmãre memã kum, ‘Dja me me'õ no katõk gê me o aben man kam pãnh no katõk. Nàr, dja me me'õ djwa kwỹr gê me pãnh wa kwỹr’, ane. Me bakukãmãre ã memã ane.” Nãm me ã ar amã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nhym be, ba dja ba ar amã arẽ gar ama. Djãm ar aje amipãnh meo abikẽnhmã? Kati. Kwãrĩk wãnh. Dja me ar ajo ajkẽ gar amipãnh meo abikẽnh kêt. Godja me ikra poo anhine djubôkbê ar akurwanh jabej tu me'ỳr anhine nhikjêo apa gê kurwa. ");
INSERT INTO txuNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nhym godja me arỳm pykakam me bẽnjadjwỳr'ỳr ajo tẽn 'ỳr ajo bôx ne kum, “Me'õja ne ijo ajkẽ. Kum arẽ gê imã o pãnh”, ane. Nhym bẽnjadjwỳr arỳm amã “Pãnh dja ga kum anhõ kubẽkà'õ pydjin angã”, ane. Djãm aje kubê nêmã? Kati. Dja ga tu kam anhõdjành ne kum anhõ kubẽkào amãnhkrut ne angã. ");
INSERT INTO txuNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Dja me kôt atẽmmã amã krà tỳ:x ne amã, “Ga dja ga ikôt tẽ nhym ajã kirometu pydji apêx”, ane. Ga kam kabẽnkôt tẽ. Kôt atẽmo kirometu pydji apêx. Ga kam ikabẽn kôt amã kĩnh ne ajte ijukri kôt tẽ nhym ajã kirometu 'õdjwỳ apêx. ");
INSERT INTO txuNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Godja me ar amã, “Imã angã”, anhỹr jabej tu kum angã. Godja me ar amã, “Imã angã. Ba kam ĩ amã kungã”, anhỹr jabej. Kwãrĩk wãnh kubê nê kêt. Ba ne ba ã ar amã ane. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ne kam ajte arkum, —Me ar amã, “Me bakukãmãre ne memã kum, ‘Ar amã amibu'ã me ja jabên kam amã akurê djwỳnh kurê’, ane. Me ã memã ane.” Nãm me ã ar amã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nhym be, ba dja ba ar amã arẽ gar ama. Djãm ar amã akurê djwỳnh kurêmã? Kati. Dja gar amã akurê djwỳnh jabê. Me kute ar ajo Metĩndjwỳnhmã à'wỳr ne kum, “Dja ga o ajkẽ”, anhỹro baja dja gar meo Metĩndjwỳnhmã a'wỳ ne kum, “Dja ga o djuw mex”, ane. Amã akurê djwỳnh kaprĩ. Me kute ar amã kabẽn punuo baja ne kute ar ajo bikẽnho baja dja gar meo Metĩndjwỳnhmã a'uw. ");
INSERT INTO txuNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ar amã akurê djwỳnh jabên arỳm Abãm kôt amijo tẽ. Aje amijo kàjkwakam Abãm krakumrẽx kadjy dja gar Abãm kôt amijo tẽ. Ga, Abãm kute me axwemẽ me mex'ã myto apôxja pumũ. Ne kute me katàt kute amijo bamẽ me ate kute amijo ba'ã nao bixadjwỳrja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Godja gar amã me kum ajabêjabit jabê djãm kam Metĩndjwỳnh kute ar amã mex jarẽnhmã? Kati. Mỳkam? Bir, ar amã me kum ar ajabêjabit jabêkam. Amã akurê djwỳnh jabê kêtkam. Djori kam amex? Kati. Nãm ã me bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnh djàkĩnhĩ meo ane. Me kum kurê djwỳnh jabê kêt. Djori kam me mex? Kati. Metĩndjwỳnh ne memã axwe jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Godja gar anhõbikwamãbit akabẽn mex jarẽ djãm kam ar amexkumrẽx? Kati. Mỳkam? Bir, ar aje anhõbikwamãbit akabẽn mex jarẽnhkam. Aje akurê djwỳnhmã akabẽn mex jarẽnh kêtkam. Nãm ã me bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnh meo ane. Me kute kurê djwỳnhmã kabẽn mex jarẽnh kêt. Djori kam me mex. Kati. Metĩndjwỳnh ne memã axwe jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kam ar ga dja gar amextire. Kàjkwakam ar Abãm prĩne mextirekumrẽx. Kudjwa ã ar amextireo anen amã akurê djwỳnh jabê. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ne kam ajte arkum, —Dja gar mekam adjukaprĩ. Djãm kam ar aje amim, “Ba memã amibẽn ne mekam idjukaprĩ gê ibu'ã me ja imã idjukaprĩ jarẽ”, anhỹrmã? Kati. Kwãrĩk wãnh amim anhỹr kêt. Dja gar memã amibẽn nhym me ar amã adjukaprĩ jarẽ. Djãm kam dja Metĩndjwỳnh ar amã akĩnh djà ngã? Ar aje memã amibẽnkam djãm ar amã akĩnh djà ngã? Kati. Kam ar aje memã amibẽnkam dja ar amã akĩnh djà nhõr kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kam ar aje me õ mỳjja kêtmã ar anhõ mỳjja nhõr kadjy. Djãm kam ar aje me kute amijo 'êx ne ta kute amijo Metĩndjwỳnh mar mexja kudjwamã? Nãm me kute memã amibẽn nhym me kute memã ukaprĩ jarẽnh kadjy amijo õ'i kakô. Me bikprõnh djàkam nàr pry kôt amijo õ'i kakôro ba. Djãm ar aje me kudjwamã? Kati. Kwãrĩk wãnh me kudjwa kêt. Mrãmri ar aje amibẽnkam dja pykakam me ja ar amã ukaprĩ jarẽ. Djãm Metĩndjwỳnh dja ar amã akĩnh djà ngã? Kati. Ar aje memã amibẽnkam dja ar akam kĩnh kêtkumrẽx ne ar amã akĩnh djà nhõr kêt. Mrãmri ije ar amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nhym be, ar ga ar aje me õ mỳjja kêtmã mỳjja nhõrmã tu udju gê me ar abu'ã ar amar kêt. Gê ar aje memã õrkôt me ar abu'ã ar amar kêt. Dja gar memã angãn kwãrĩk wãnh amim, “Arỳm ne ba kum kungã. Idjukaprĩkumrẽx”, kwãrĩk wãnh amim anhỹro aba kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dja gar mebê udju nhym ar Abãm djwỳnh arỳm ar aman ta arỳm ar amã akĩnh djà ngã. Nhym kam me kunĩ ar apumũ. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ne kam ajte arkum, —Metĩndjwỳnhmã ar akabẽnkam djãm aje me kute amijo 'êx ne ta kute amijo Metĩndjwỳnh mar mexja kudjwamã? Me kute memã amibẽn nhym me kute memã mex jarẽnh kadjy ne me me bikprõnh djàkam nàr pry bikjêrkam Metĩndjwỳnhmã kabẽno ku'ê. Djãm ar aje me kudjwamã? Kati. Kwãrĩk wãnh me kudjwa kêt. Mrãmri me kute amibẽnkam dja pykakam me ja memã mex jarẽ. Djãm Metĩndjwỳnh kute memã mex jarẽnhmã? Kati. Me kute memã amibẽnkam ne Metĩndjwỳnh mekam kĩnh kêtkumrẽx. Kam dja memã mex jarẽnh kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ar aje mrãmri kum akabẽnmã djãm ar aje memã amibẽn kadjy me ipôkri adjãmmã? Kati. Kwãrĩk wãnh. Dja gar me kàxã ar anhõ kumoka'ê djwỳnhmã wadjàn amijã ijê. Ar Abãm djwỳnh ne bipdjur. Nãm te bipdjurn kute mỳjja bipdjur kunĩ pumũnh. Dja gar amijã ijê. Ne kam arỳm kum akabẽn jarẽ nhym arỳm ar apumũn ar ama. Ar aman arỳm ar amã akĩnh djà ngã nhym kam me kunĩ ar apumũ. ");
INSERT INTO txuNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Dja gar Metĩndjwỳnhmã amikabẽn jarẽ. Kwãrĩk wãnh me kwỳ kudjwa kêt. Me kwỳ kute apỹnh mỳjjao metĩndjwỳnh karõ nhipêx ne marja ne me 'êx ne arĩk mỳjjamã amikabẽn krãptĩ jarẽnh kajgoo ba. Ne arĩk amim, “Dja ba kum amijarẽnh krãptĩ gê ikabẽn krãptĩ man arỳm imarkumrẽx”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kwãrĩk wãnh me kwỳ ja kudjwa kêt. Djãm we ar aje Metĩndjwỳnhkumrẽxmã akabẽn krãptĩ jarẽnh nhym kôt we kute amarmã? Kati. Ar Abãm djwỳnh, kubê Metĩndjwỳnhkumrẽx, djã ne mỳjjao metĩndjwỳnh karõ nhipêxja kudjwa amakkre kêt? Kati. Metĩndjwỳnhkumrẽx ne amak me:xkumrẽx ne tu kute ar amar. Ar anhõ mỳjja kêtja tu kute mar. Ar aje kum mỳjjao adjà'wỳr kêtri arỳm kute ar amar. ");
INSERT INTO txuNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ate gêdja gar ikabẽn kôt kum akabẽn jarẽ ne kum, “Djũnwã, ga ne ga kàjkwakam nhỹ ba arỳm ama. Gê me amexo apymaja man amim ajarẽn abenmã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","On me kadjy abẽnjadjwỳr ne ar meo aba. Ga, kàjkwakam me kute akabẽn marn kôt kute ar amijo baja pumũ. Gê me pykakamdjwỳ on me kudjwa ã akabẽn marn kôt ar amijo bao ane. ");
INSERT INTO txuNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Akati jakam ar ijajkwa mãnhkutã ar imã inhõ kwỳ krẽn djà ngã. ");
INSERT INTO txuNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ar ijaxwe maro akno. Godja me'õ ar ikam axwe bar o ibiknor jabej ga gadjwỳ ar ijaxwe maro akno. ");
INSERT INTO txuNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Me kute ar imã axwe'ã àpnênh kunĩkôt ga ga ar ijo tỳx bar mebê idjãm tỳx ne ijaxwe kêt. Dja ga ajte Xatanajbê mã ar ipytàro aba. Mỳkam ne bar ã amã ane? Bir, abê Bẽnjadjwỳr djwỳnh. Ga apydji ajitỳ:x ne ara:x rã'ã: rã'ã ne. Tãm ne ja”, ane. Dja gar ã Metĩndjwỳnhmã akabẽno ane. ");
INSERT INTO txuNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nã bãm ar amã, “Dja me'õ ar akam axwe gar tu wãnh axwe maro aknon kam angryk kêt”, ane. Mỳkam? Bir, godja gar me axwe maro aknon kam angryk kêt nhym kàjkwakam Abãmdjwỳ ar ajaxwe maro aknon akam ngryk kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nhym be, godja gar me axwe mar rã'ãn me kam angryk rã'ã jabej ar Abãmdjwỳ dja ar ajaxwe mar rã'ãn ar akam ngryk rã'ã. Kam ne ba ar amã, “Dja me'õ ar akam axwe gar axwe maro aknon kam angryk kêt.” Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ne kam ajte arkum, —Ne kam ar aje Metĩndjwỳnhmã amijajbur jabej djãm ar aje me kute amijo 'êx ne ta kute amijo Metĩndjwỳnh mar mexja kudjwamã? Me kute amijajburo amirĩt ne memã amibẽn kadjy ne me amijo nokre kaprĩn aminokreo àpnu. Djãm ar aje me kudjwamã? Kati. Kwãrĩk wãnh me kudjwa kêt. Mrãmri me kute amibẽnkam dja pykakam me memã mex jarẽ. Djãm kam Metĩndjwỳnh kute memã mex jarẽnhmã? Kati. Me kute memã amibẽnkam Metĩndjwỳnh mekam kĩnh kêtkumrẽx ne memã me kĩnh djà nhõr kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nhym be, ar ga ar aje kum amijajburkam on amikrã ngràn aminokre põ. ");
INSERT INTO txuNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ar aje amijajbur'ã memã amijo amirĩt kêt kadjy ã memã amijo ane. Ar Abãm djwỳnhbê Metĩndjwỳnh ne bipdjur. Nãm te apdjun kute mỳjja bipdjur kunĩ pumũnh. Dja gar ã anen arỳm kum amijajbu nhym ar apumũn ar ama. Ar aman arỳm ar amã akĩnh djà ngã nhym kam me kunĩ ar apumũ. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ne kam ajte arkum, —Kwãrĩk wãnh amim pykakam ar anhõ nêkrêx rax jadjwỳr kêt. Kam ne kanêremẽ 'ôk arỳm abê o àpnu nhym me àkĩnhĩ arỳm 'ã õpôk ne o akĩ. ");
INSERT INTO txuNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ate dja gar Metĩndjwỳnhmã apê nhym arỳm pãnh kàjkwa djwỳnhkam ar amã nêkrêx rax jadjuw. Kam ne 'ôk kute ar abê o àpnu kêt nhym kanêre kute o àpnu kêt nhym me àkĩnhĩ kute 'ã õpôk ne o àkĩnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mỳkam dja kàjkwakam anhõ nêkrêx? Bir, ar aje anhõ nêkrêxkôt ajamak bẽn prãmkam. Dja kàjkwakam ar anhõ nêkrêx rax gar arỳm kàjkwakam mỳjjakôt ar ajamak bẽno aba. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nhym me nodjwỳ. Me noo ne me kute mỳjja pumũnh. Dja gar ano mex ne ajmã ano kute kêt jabej arỳm mrãmri arĩt tỳxkumrẽx ne mỳjja pumũ. Aje mrãmri ne me a'uri mrãnh mex pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nhym be, dja ano rã, ano ajmã kute gar arỳm arĩt kêt ne aje mỳjja pumũnh kêt. Aje mrãmri ne me akamàt kô tykkam mrãnh punuja pyràk. Gêdja gar Metĩndjwỳnh kôt aje amijo aba kêt jabej kute ar amã amikukràdjà jarẽnhja kôt aje amijo aba kêt jabej arỳm ar aje me'õ akamàtkam ba pyràk, aje me'õ akamàt kô tyk tỳxkam mrãnh punuja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ẽ, nhỹnh ne me'õ amẽ õ bẽnjadjwỳr ajkrut ne kum apê? Kati, gêdja o anen kam te o ane. Gêdja kum ja kurên kam kum ja jabê. Nàr kon, gêdja kum ja kĩnh ne kumãbit apê ne kam kum ja kurên kum àpênh kêt ne. Dja gar amã Metĩndjwỳnh kĩnh ne ajte amã nêkrêxo atom raxja kĩnh ne kam kute bẽnjadjwỳr amãnhkrutmã adjàpênh pyràk. Dja gar te o ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ne kam Jeju ajte arkum, —Kwãrĩk wãnh amikam adjumar punun amim, “Mỳj dja ba kukrẽ, mỳj dja ba o ikõ, mỳj dja ba adjà?” Kwãrĩk wãnh ã adjumar punuo anhỹr kêt. Djãm Metĩndjwỳnh kute ar akudjwa djwỳmẽ kubẽkàbit maro ba? Kati. Kute ar gajbit ar amar tỳx. Kute ar amar tỳxkam dja ta arỳm ar amã ar anhõ kwỳ krẽn djàmẽ ar anhõ kubẽkàmẽ kungã. Kam, kwãrĩk wãnh amikam adjumar punu kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ga, kỳjrũm kwênhja pumũ. Djãm kwênh kute pur kre nàr bàygogo djê nàr o atom ne kute õ kikrekam adjwỳr? Kati. Kwênh kute ã o anhỹr kêt nhym kàjkwakam Abãm tu o djuw mex. Metĩndjwỳnh ne kum kwênh kĩnh ngrire. Ar gajbit kum ar akĩnhkumrẽx. Kam ar gajbit dja ar ajo djuw mexkumrẽx. Kam kwãrĩk wãnh amikam adjumar punun amim, “Mỳj dja ba kukrẽ”? anhỹr kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Djãm amikam ar adjumar punun arỳm ar adjumar punuo ar aje amũ atyk kêtmã aminhõ akati kamẽnhmã? Kati. Ar aje te o anhỹrmã. ");
INSERT INTO txuNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mỳkam ne gar anhõ kubẽkà prãmje amikam adjumar punu? Ga, kapôtkam pidjôrãja pumũ. Mỳj ne pidjôrã abatành on? Djãm pidjôrã àpênh nàr djãm kute õ kubẽkà kayr? Kati. ");
INSERT INTO txuNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bẽnjadjwỳr raxbê Xaromão nhõ kubẽkà me:xkumrẽx ne kume:x. Djãm mexo kute pidjôrã pyràk? Arkati. Pidjôrã ne mexo kute Xaromão nhõ kubẽkà jakrenh me:xi. ");
INSERT INTO txuNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Metĩndjwỳnh ne pidjôrã kre nhym abatành ne arỳm mexkumrẽx. Akatija tãmkam ne mex nhym akati nhym me arỳm kaban kuwykam kurẽ nhym arỳm xêr. Ga, Metĩndjwỳnh kute prĩne pidjôrão djuw mex nhym mexkumrẽxja pumũ. Mỳkam ne gar amim Metĩndjwỳnh mar rerekre? Kum pidjôrã kĩnh ngrire. Nhym be, ar gajbit Metĩndjwỳnh kum ar akĩnhkumrẽx. Tãm dja gar ama. Djãm kute ar ajo djuw mex kêtmã got? Dja ar ajo djuw mexkumrẽx gar arỳm anhõ kubẽkà. ");
INSERT INTO txuNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kam kwãrĩk wãnh ar anhõ mỳjja prãmje amikam ar adjumar punu kêt. Kwãrĩk wãnh amim, “Mỳj dja ba kukrẽ”? nàr, “Mỳj dja ba o ikõ”? nàr, “Mỳj dja ba angij”? kwãrĩk wãnh amim anhỹr kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Apỹnh pyka djàri me kute Metĩndjwỳnh mar kêtja kute mỳjja jakôtbit amak bẽn ne. Djãm ar aje me kudjwamã? Kati. Kwãrĩk wãnh. Kàjkwakam ar Abãm kute ar amar. Ar anhõ mỳjja kêtja kunĩkôt kute ar amar. ");
INSERT INTO txuNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nhym be, ar ga, djãm ar amã mỳjja ja kĩnhmã? Kati. Kwãrĩk wãnh. Bir, mỳj dja gar amã kĩnh? Bir, Metĩndjwỳnh kute ar apytàr ne kute ar ajo bajabit dja gar kumrẽx amikam mar tỳx. Ne kôt ar ajaxwe kêtdjwỳ dja gar mar 'ãno dja. Ja dja gar amã kĩnh nhym kam arỳm ar amã mỳjja kĩnhja kunĩ ar amã kungã. ");
INSERT INTO txuNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kwãrĩk wãnh ar amikukãm adjumar punu'õ mar kêt ne amim, “Godja akatibê idjumar punu djà'õ iwỳr bôx jabej mã gêdja ba nẽ”? anhỹr kêt. Djãm akati 'õkam Metĩndjwỳnh kute ar ajo djuw mex kêtmã? Kati. Akati kunĩkôt kute ar ajo djuw mex. Dja akati nhym Metĩndjwỳnh ta arỳm ar ajo djuw mex. Ar adjumar punu ar awỳr bôx jabej ajbit dja gar amikam ama. Kwãrĩk wãnh amũ amikukãm adjumar punu'õ maro atẽm kêt. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ne kam ajte arkum, —Ar aje me axwe jabej me kukjêr kêtkam mỳkam ne gar tu me'ã amim, “Axwe”, anhỹro aba? Kwãrĩk wãnh. Dja gar me'ã axwe rẽnho aba nhym me arỳm amipãnh ar ajã axwe rẽ nàr Metĩndjwỳnh arỳm ar amã ajaxwe jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Godja gar me'ã mỳjja'õ man kôt tu 'ã, “Axwe”, ane. Djãm kam me nàr Metĩndjwỳnh akam kĩnh? Kati. Dja gar me'ã ane nhym me nàr Metĩndjwỳnh arỳm ar gadjwỳ ar ajã mỳjja tãm man kôt ar ajã axwe mẽ. Dja gar Metĩndjwỳnh kudjwa memã õr rũnh nhym kam me akubyn ar aje memã õr 'ãnh ar amã kungã, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mỳkam ne gar akamy nokam pyka jaũmbit pumũn kam ar anokam pĩponhtija pumũnh kêt ne? ");
INSERT INTO txuNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Djãm ar aje akamymã kum, “Akmere, amrẽ ba amã anokam pyka jaũmwã kaba”, anhỹrmã? Ne kam ar anokam pĩponhtiwã pumũnh kêtkumrẽx ne. Ar aje aminokam pĩponh pumũnh kêtkam we ã kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kê. Mrãmri ne gar apunu rax ne kam ajajkwakambit amimexo amra. Akumrẽx gêdja gar aminokam pĩponhtiwã kaban kam arĩt mex ne arỳm kôt ar akamy nokam pyka jaũm ngrire wã kaba. Kam dja gar akumrẽx wãnh ajaxwemã anhire. Ne kam arỳm aje aminokam pĩ ponhti kadjàr pyràk. Ar ga dja gar akumrẽx wãnh ajaxwemã anhire ne kam arỳm amex ne ajaxwe kêt ne ar akamy jaxwe nêje kukrà kadjy arỳm amex. Amex kute arỳm ar akamy nokam pĩ jaũm kadjàr kadjy kute arĩt mex pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Me kwỳ ne me kum axwe kĩ:nh ne kam axwe'ã maje kum Metĩndjwỳnh kĩnh kêt. Djãm me jamã aje Metĩndjwỳnh kabẽn jarẽnhmã? Kati. Ga ren me jamã arẽ ne ren aje mrãmri me kute ropremã Metĩndjwỳnh nhõ mỳjja rẽnh pyràk nàr me kute angrô jamymã kryt karỳr rẽnh pyràk. Kwãrĩk wãnh o anhỹr kêt. Ga ren o ane nhym ren me kum Metĩndjwỳnh kabẽn kurên o ajkẽn akẽx ne gadjwỳ ajo ajkẽ. Kute mrãmri ne ropre kute mỳjja mex nhirênh nhym angrô jamy ituo kryt karỳr ngãnhja pyràk. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ne kam ajte arkum, —Dja gar tu mỳjja'ã 'uw, mã mỳjja'ã 'wỳro tẽ nhym Metĩndjwỳnh arỳm ar amã kungã. Ga, ar aje mã mỳjja jabej ne kam arỳm kum ajapôxja pumũ. Ne kam mã kikre jajkwa krekremã akabẽno aku'ê nhym arỳm me kute ar amã 'ã rênhja pumũ. Dja gar ã Metĩndjwỳnh 'wỳro ane. ");
INSERT INTO txuNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Be, me kute mỳjja'ã 'wỳr 'ãno ãm gêdja Metĩndjwỳnh arỳm memã kungã. Ga, me kute mỳjja jabej ne kum apôxja pumũ. Ne kam me kute kikre jajkwa krekremã kabẽno ku'ê nhym arỳm me kute memã kikre'ã rênhja pumũ. Dja gar gadjwỳ ã mỳjja'ã Metĩndjwỳnh 'wỳro ane nhym arỳm amã o amirĩt. ");
INSERT INTO txuNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nhỹnh ne ar akra'õ tẽn djwỳ'ã ar ajuw gar kum kẽn ngã? ");
INSERT INTO txuNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ne tep'ã ar ajuw gar kum kangã ngã. Arkati. ");
INSERT INTO txuNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Be, gar ajaxwekam aje akramã mỳjja mex nhõrja pumũ. Nhym be, kàjkwakam ar Abãm mextire ta gêdja ar amã amũ mỳjja mex nhõro ar ajakre. ");
INSERT INTO txuNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kam gar aje amibu'ã me'ã amim “Gê me imã mex”, “Gê me imã mex”, anhỹro aba. Kute aje me'ã amim anhỹro aba pyràk ar gadjwỳ dja gar amikabẽn kôt ã memã amexo ane. Dja ga ã memã amexo anen arỳm Metĩndjwỳnh kabẽn kukràdjà kôtdjwỳ aje amijo aba mexkumrẽx. Môjdjê kute kabẽn jarẽnh kôt aje amijo aba mexkumrẽx. Me kute Metĩndjwỳnh kukwakam memã kabẽn jarẽnhdjwỳ aje kôt amijo aba mexkumrẽx. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Nhym kam mrãmri me kute mỳjja mar ne kôt ar amijo ba ne kute pry pyràk. 'Ã ne Jeju arkum, —Ikôt dja gar amijo aban arỳm abê tỳx kute mrãmri ne pry kre ngrire mebê tỳx pyràk. Nhym be, dja gar me kum ikĩnh kêtja kôt ar amijo aban arỳm amã rerekre. Amã tỳx kêt kute mrãmri ne pry kre raxkôt me mrãnh memã tỳx kêt pyràk. Kwãrĩk wãnh me kum ikĩnh kêtja kôt ar amijo aba kêt. Aje pry jajkwa krekre ngrirekôt adjàr mãn pràbê dja ga on amim iman ikôt ar amijo aba. Me krãptĩ ne me me kum ikĩnh kêtja kôt ar amijo ba. Memã tỳx kêtê kute mrãmri ne me kute pry jajkwa krekre raxkôt ngjêx nhym memã tỳx kêt pyràk. Kute pry kre rax kôt me mõr memã tỳx kêt pyràk. Dja gar me kum ikĩnh kêt kôt ar amijo aban arỳm akuno. Me biknor tokry djàkam akuno. ");
INSERT INTO txuNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nhym be, me ngrêrebit ne me imã apôx ne amim imaro ba. Me kute mrãmri ne me ngrêre pry jajkwa kre kre ngriremẽ pry kre ngriremã apôx pyràk. Ar ga dja gar imã akaton amim imaro aban arỳm atĩn ne, Metĩndjwỳnhkôt atĩn ne ar aba rã'ã: rã'ã ne. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ne kam ajte arkum, —Me kute amijo 'êx ne memã, “Ba ne ba ibê Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh”, anhỹro bajabê amijã ano tỳx. Nãm me kute mrãmri ne rop krori kute amijo mrykĩ'ãtomti kà jangjênh ne bôx pyràk. Me ta ne me kute amijo imar mex ne ar awỳr bôx. Nhym be, kati. Nãm me ar anoo akno. Me kà kadjwỳnhbê ne me kute mrãmri ne rop jamrex pyràk. Me axwe. Ne kute ar amã Metĩndjwỳnh'ã 'êx ne kabẽn kêt jarẽnhmã ne ar awỳr bôx. Kute o ibê amiwỳr ar ajo akẽx ne ar ajo bamã ne ar awỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mỳj dja gar me omũnh ne memã akator on? Bir, mỳj dja gar pidjôjadjwỳ mar on? Bir, ô ne parbê rôrôk ne ikwãn o bàrio amirĩt nhym me kôt kum apôx. Ga, rojtikam tyrti apôx kêtja pumũ. Ar gadjwỳ dja me apỹnh kabẽn punu jarẽn àpênh jaxwe gar me omũn arỳm memã akaton amim, “Be, ga, axweja pumũ. Kabẽn kajgo. Nãm Metĩndjwỳnh'ã 'êx ne kabẽn kêt jarẽnho ba”, ane. Djãm mrỳnhĩkam me kute akrô djôbê uba rênh? Kati. Nàr, djãm prêxkam me kute pidjôbê pigu rênh? Kati. ");
INSERT INTO txuNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bàri mexkam ne ô mex arij. Nhym be, bàri punukam ne ô punu arij. ");
INSERT INTO txuNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bàri mexkam ne ô punu arij prãm kêtkumrẽx. Nàr, bàri punukam ô mex arij prãm kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bàrikam ô punu jarijja kunĩ ne me kute akàr ne kuwykam rẽnh. Dja me ã kute Metĩndjwỳnh'ã 'êx ne kabẽn kêt jarẽnho bajao ane. ");
INSERT INTO txuNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Be, me àpênh jaxwe dja gar omũn arỳm kôt kum akato. Me kute Metĩndjwỳnh kabẽn kêt jarẽnhja dja gar ama. 'Ã ne ba ar amã, “Ga, rojtikam tyrti apôx kêtja pumũ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Me kute arĩk imã, “Ga abê inhõ Bẽnjadjwỳr djwỳnh. Ga ne ga ijo aba”, anhỹrja. Djãm me ja kunĩ kàjkwakam Bẽnjadjwỳr djwỳnh kute amim me utàr ne ar meo bamã? Kati. Me kute amim kàjkwakam Ibãm kabẽn mar ne kôt kute amijo babit. Me jabit dja Bẽnjadjwỳr djwỳnh amim me utàn ar meo ba. ");
INSERT INTO txuNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ije memã axwe pãnh jarẽnh nhõ akati wãkam dja me krãptĩ aminêje imã, “Bẽnjadjwỳr djwỳnh. Djãm akukwakam ije memã akabẽn jarẽnh kêt got ga ikanga? Djãm akukwakam ije me karõ punu kujaêk kêt got ga ikanga? Djãm akukwakam ije mỳjja pumũnh kêt nhipêx kêt got ga ikanga? Mỳjja rũnh, mỳjja krãptĩ ne ba ipêx ga ikanga”, ane. Ije memã axwe pãnh jarẽnh djà nhõ akatikam dja me ã imã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kam dja ba irã ipôkri me kunĩmã kum, “Kati. Djãm ikukwakam ne ga mỳjja nhipêx? Kati. Wãnh amikukwakam ne ga mỳjja nhipêx. Ba ije amar kêt. Rũm imã akàx. Me adjàpênh jaxwe”, ane. Dja ba ã memã ane. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ne kam ajte arkum, —Me kunĩ kute ikabẽnja mar ne kôt kute amijo baja ne me kute mrãmri ne me'õ jamak mex pyràk. Me'õ jamak mexja kẽnkam amim kikre. ");
INSERT INTO txuNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nhym kam te 'ã na axidjuw ne te 'ã ngô tàm ne te kôk djàbêr tỳx kikre karngrõ nhym tỹm kêt. Kẽnkam kute ipêxkam ne tỹm kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nhym be, me kunĩ kute ikabẽnja mar kajgon kôt kute amijo ba kêt ne me kute mrãmri ne me'õ bẽn kati pyràk. Me'õ bẽn kati pykatikam amim kikre. ");
INSERT INTO txuNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nhym kam 'ã na axidjuw ne 'ã ngô tàm ne kôk djàbêr tỳx kikre karngrõ nhym arỳm tỹm. Djã nãm kàjbê ban tỹm got? Kati. Nãm tu ban gru: ane. ");
INSERT INTO txuNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Nãm ã Jeju memã anen arỳm memã amikukràdjà jarẽnh pa. Nhym me kabẽn man kam ari ar aben pumũn kam abenmã kum, —Tô mỳj kabẽn ny gotja? Nãm prĩne kute amimarkôt katà:t memã amikukràdjà jarẽnhkumrẽx. Nãm ã me bẽnjadjwỳr rũnh kwỳ kabẽn mex anen ar prĩne kabẽno meo atomo ba, ane. Djã nãm ã Môjdjê kukràdjà mar djwỳnh memã arẽnho ane? Kati, nãm me ari no prõt ne ari kukràdjà jarẽnh'ã umju:w ne kute arẽnh katàt kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nhym kam krãnh'ã arỳm rwỳk tẽ. Nãm rwỳk tẽ:n arỳm ruw. Nhym me krãptĩ: kôt mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nhym kam me'õ ĩ kajêkam têja 'ỳr bôx ne parbê kõnkrão nhỹn kum rax jarẽn kum, —Bẽnjadjwỳr djwỳnh, ga aje inhĩ kajêkam itêkôt aje ipumũnh ne aje mar. Aje ijo mex prãm jabej ba ren arỳm imex ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nhym arỳm 'ỳr ikran kupên kum, —Ije ajo mex prãm. On amex, ane. Nhym arỳm 'ã ĩ kajêkam têja apêx nhym arỳm mex ne. Kute o ãm tãmkam tẽmbê kà mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nhym kum, —Kwãrĩk wãnh ga amijarẽnh kêt. Dja ga tu katàt mã me kadjy Metĩndjwỳnh mar djwỳnh'ỳr tẽn kum amibẽ, kum amikà bẽ. Ne kam kum mry ngã gê akadjy Môjdjê kukràdjà kôt Metĩndjwỳnhmã mry gan kum kungã. Arỳm akà mexkam dja ga kum mrywã ngã gê me kunĩ apumũ, arỳm akà mexkôt apumũ. Nãm ã Jeju me'õmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ne kam arỳm tẽn krĩraxbê Kapanamã wadjà. Nhym krãkamngônh krãptĩ kubê 100 nhõ bẽnjadjwỳr arỳm 'ỳr bôx ne kum õ àpênho no katon kum arẽn kum, ");
INSERT INTO txuNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Bẽnjadjwỳr djwỳnh, inhõ àpênh arỳm akryn tokry rax ne kikrekam arek nõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nhym Jeju kum, “Ba 'ỳrn o mex”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nhym krãkamngônh nhõ bẽnjadjwỳr kum, —Djãm imex got ga inhũrkwãmã tẽ? Kwãrĩk wãnh. Dja ga akabẽnbit jarẽ nhym arỳm inhõ àpênh mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Inhõ bẽnjadjwỳr kute raxo ijakrenhja ne imã kabẽn ba kabẽn man kôt ar amijo iba. Ne kam ba ibê me krãkamngônhre nhõ bẽnjadjwỳrkam ba memã ikabẽn nhym me ikabẽn kôt ar amijo ba. Ba 'õmã kum, “'Ỳr tẽ”, ane nhym arỳm 'ỳr tẽ. Ba kam ajte 'õdjwỳmã kum, “Amrẽ tẽ”, ane nhym arỳm amrẽ tẽ. Ba inhõ àpênhmã kum, “On mỳjja kupê”, ane nhym arỳm kupê. Kam ne ba amã, “Abẽnjadjwỳr djwỳnhkam dja ga akabẽn nhym arỳm akabẽnkôt mex ne”, ane. Krãkamngônh nhõ bẽnjadjwỳrbê ne me bajtem. ");
INSERT INTO txuNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nãm Jejumã ane nhym kuman arỳm kam no tyn djan kôt ba djwỳnh arkum, —Be, me'õ bajtemja kute tu amim imar mexkumrẽx. Mebê idjaerkumrẽx ren kudjwa ã amim imaro ane. Nhym be, kati. Me kute kudjwa ã amim imaro anhỹr kêt. Pydji bajtemkam kute amim imar me:xkumrẽx. Mrãmri ne ba ar amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ẽ, ba ar amã arẽ gar ama. Kàjkwakam Bẽnjadjwỳr djwỳnh arỳm kute pykakam amim me utàr ne ar meo bakam dja gwaj me bakukãmãremẽ ro'ã banhõ kwỳ krẽ. Abraãomẽ Idjakmẽ Djakomẽ ro'ã banhõ kwỳ krẽn mexo nhỹ. Nhym kam dja me bajtem krãptĩ: ban bôx, myt apôx djàrũm bôx ne myt ngjêx djàrũm bôx. Bôx ne arỳm gwaj baro'ã õ kwỳ krẽno nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nhym be, mebê idjaerkumrẽxja dja Metĩndjwỳnh arỳm bõm me kumẽ. Bẽnjadjwỳr djwỳnh bit kute amim me utàr ne ar meo baja, me tãm dja arỳm bõm me kumẽ. Bõm mebê idjaer mẽ nhym me wãnh akamàt kô tykkam ar ba. Wãnh ne me amim ngryk ne tokry djàje amijanên ar àmra ba. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ne kam me krãkamngônh nhõ bẽnjadjwỳrmã kum, —Aj mã. Ga ne ga tu amim imarkumrẽx. Kôt dja ba arỳm amã ã o ane, ane. Nhym myt tãmkam arỳm õ àpênh mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nhym kam Jeju arỳm Pedru nhõ kikrekam bôx nhym Pedru djupãnhdjwỳ kanên nõ. ");
INSERT INTO txuNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nhym 'ỳr bôx ne arỳm ikra kupê. Kupê nhym kanê arỳm kum ire. Kum ire nhym arỳm kàjmã djan arỳm mex ne. Ne kam arỳm aro djuw mexo ba. ");
INSERT INTO txuNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nhym kam ar'ã para nhym me arỳm 'ỳr me krãptĩo bôx. Me karõ punu kute meo baja tãm ne me'ỳr meo bôx. Nhym mã me'ã kabẽnbit jarẽ nhym mã me karõ punu umaje mõ. Memã iren mã mõ. Jeju arỳm mã me kunĩkam me karõ punu kujate. Ne kam ajte me punudjwỳ kunĩo mex. ");
INSERT INTO txuNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Amrẽbê: ne ujarẽnh djwỳnhbê Idjaij Jeju'ã ajarẽ. Kute meo mex'ã ajarẽ. Nãm Metĩndjwỳnh kukwakam 'ã ajarẽ. Nãm me bakukãmãremã kum, “Apỹnh me bapunu djàri, apỹnh me bakanê djàri nhym kute amijã me bamar. Kute mrãmri ne me kute jênh pytĩo bakam kute amijã mar pyràk. Nãm ã amijã me bamaro ane.” Nãm ã Idjaij me bakukãmãremã ane. Jeju kute meo mex'ã ne memã arẽ. Nhym kam me aben djô'ã arẽnho mõ:. Arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm, me bakamingrãnyrekam Jeju arỳm kato. Katon kam arỳm abatành ne ar ba. Ne kam arỳm me punuo mexo ba. Metĩndjwỳnh kukwakam Idjaij kute me bakukãmãremã 'ã ujarẽnh kôt Jeju arỳm ã meo mexo bao ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jeju me punuo mex ne arỳm amibu'ã me krãptĩ: pumũ. Ne kam arỳm arkum, —Gwaj on akàx nhikjêmã rê, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nhym kam Môjdjê kukràdjà mar djwỳnh'õ 'ỳr bôx ne kum, —Ẽ, ujarẽnh djwỳnh, ba arek akôt tẽ. Dja ga nhĩ'ãm amrãnh kunĩkôt ba akôt mrã, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nhym kam kum, —Ẽ, ga, djoti pykakam kreja pumũ. Ne kwênh kỳjrũm aêja pumũ. Mrymẽ kwênhbit ne õt djà kute amim kre pumũnhkôt kam õt djà. Nhym be kati. Ba ne ba inhõ kikre kêt. Inhikwã djà kêt. Ije amijo inhĩ ne me awỳr irwỳk nhỹnh ne ba inhũrkwãja? Kon, gop ga amiman kam ikôt atẽm jabej nàr kon, arek dja, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nhym kam me'õ ja kute Jejukôt bamã ne kum, —Bẽnjadjwỳr djwỳnh, ba ibãm kumrẽx jadjà. Ne kam arỳm akôt ar iba, ane. Nhym kum, ");
INSERT INTO txuNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—Kati. Amrẽ on ikôt ar aba. Gê me kute Metĩndjwỳnh mar kêt wãnh me tyk jadjà. Me kute mar kêt ne me kute mrãmri ne me tyk jamakkre kêt pyràk. Gê me wãnh õbikwa tyk jadjà. Nãm ã Jeju kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ne kam ar kà'ỳr tẽn 'ỳr bôx. Nhym Jeju arỳm kàkam nhỹ nhym kôt ba djwỳnh ar arỳm kôt nhỹ. Nhym kam ar arỳm kà kujaten amũ tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tẽ: nhym ar aêrbê na 'itỳx ruw nhym kôk 'itỳx wabê. Nhym ngô arỳm aben pumjuw ne kà nhiby ato. Nhym be, Jeju wãnh arek õto nõ. ");
INSERT INTO txuNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nhym kam kôt ba djwỳnh ar 'ỳr tẽn arỳm tok ne kum, —Bẽnjadjwỳr djwỳnh, gop ar ipytà. Arỳm gwaj badjàr 'ỳr, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nhym arkum, —Nã gãm ar amim imar rere:kre. Mỳkam ne gar atĩn prãm? ane. Ne kam kàjmã djan kôkmã bẽn tỳx. Nhym arỳm tu ngô mên nõ. ");
INSERT INTO txuNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nhym ar te kute marmã kam no tyn djan abenmã kum, —Mỳj got on nhym kôkmẽ ngô raxmẽ tu kabẽn kôt ã amijo ane? ane. Nãm ar ã abenmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nhym kam Jeju arỳm ngô nhikjêmã bôx ne wabi. Kam ne pyka nhidjibê Djeradja. Nãm wabi nhym me'õ amãnhkrut ar arỳm kajpa. Me karõ punu ne ari aro ba. Me tykmã kikre kurũm ne ar mõ. Ar àkrê: nhym me te ar umaje ne te ar'ãnh tẽmmã. ");
INSERT INTO txuNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nãm ar Jeju kajpan arỳm kàj bê amran aminêje kum, —Mỳj nã Metĩndjwỳnh Kra? Djãm me inhõ akati kêtri dja ga me imã me itokry jadjà? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nhym nĩjar angrô jamy krãptĩ: àkur mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nhym kam me karõ punu kum amijo a'uw ne kum, —Aje me ikujaêk prãm jabej ba me angrô jamy krãptĩ:wãmã wadjà, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nhym kum, “Aj mã”, ane. Nhym me arỳm kato. Katon arỳm angrô jamy krãptĩ:mã wadjà. Wadjà nhym arỳm angrô jamy kunĩ prõt ne. Pyka krã'yr'ã aparmã prõt tỳ:x ne arỳm imôtikam nox ne aminhimex ne. ");
INSERT INTO txuNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nhym angrô jamy pumũnh djwỳnh ar omũn arỳm krĩraxmã prõt ne. Prõt ne arỳm bôx. Bôx ne arỳm prĩne memã mỳjja kunĩ'ã ajarẽ. Ne ajte me karõ punu kute ar o baja'ã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nhym krĩraxkam me krãptĩ kute Jeju pumũnhmã 'ỳr mõ. Ne kam arỳm omũn kam anon kum, —Gop me inhõ pyka kurũm akato, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nhym kam Jeju ar arỳm kàkam wadjàn nox ne arỳm akàx nhikjêmã rê. Ne kam wabin krĩraxkam ar ba tũmjamã tẽn bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nhym ar kwỳ kum me'õ jakryo bôx. Ikwã djàkam nõr rã'ã nhym ar kum o bôx. Nhym amim, —Be, ar ja ne ar tu amim ikamnhĩxkumrẽx, ane. Ne me'õ jakryjamã kum, —Akmere, on akĩnh. Jakam ne ba arỳm ajaxwe kunĩ maro aknon kam ingryk kêt ne, ane. Djã nãm tẽmbê me'õ jakryo mex got? Kati, nãm amidjêje nên kum jabit jarẽ nhym êje nõ. Jeju ta ne axweo akno. ");
INSERT INTO txuNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nhym wãnh Môjdjê kukràdjà mar djwỳnh kwỳ arỳm amim, —E kum be, me'õ ja ne ajmãn Metĩndjwỳnh japrỳo djan amijo Metĩndjwỳnho dja. Metĩndjwỳnh pydji ne kute me axweo biknorn mekam ngryk kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nãm me ã õkre kadjwỳnhbê anhỹro kumex nhym arỳm tu me kuman memã kum, —Mỳkam ne ga me anhõkre kadjwỳnhbê ijo kajgon ijaprỳo akumex? ");
INSERT INTO txuNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ẽ, ba me amã mỳjja amãnhkrut jarẽ. Mỳj ne amirĩt, nẽn? Ba ren kum, “Ba arỳm ajaxwe maro aknon akam ingryk kêt”, ane. Nàr kon, “On kàjmã djan tẽ”, ane. Mỳj ne ren amirĩt, nẽn? Nã bãm ren kum, “Ba arỳm ajaxwe maro aknon akam ingryk kêt”, ane nhym amirĩt kêtkumrẽx ne. Tãmbit ne amirĩt kêt. Nhym be, kàjmã me ku'ê, ije ren me'õmã kum, “Kàjmã djan tẽ”, ane nhym ren arỳm amirĩt. Tãmbit ne amirĩtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dja ba kum, “Kàjmã djan tẽ”, anen arỳm o mex ga me arỳm omũn arỳm amim, “Be ga, Jeju kute me'õ jakryo mexja pumũ. Be, djãm kute me axweo biknor kêt got? Mrãmri ne Metĩndjwỳnh arỳm amijo ĩ ne pyka jakam amikabẽnkôt ari me axweo biknoro ba”, ane. Me aje amim ja jarẽnh kadjy dja ba me'õ jakryjao mex. Nãm ã Môjdjê kukràdjà mar djwỳnhmã anen arỳm tu me'õ jakryja'ỳr akẽx ne kum, —On kàjmã djan anhikwã djà mỳn anhũrkwãmã o tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nhym kam arỳm me aêrbê kàjmã djan ikwã djà mỳn ũrkwãmã o tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nhym me krãptĩ omũn kam no tyn kumex ne amim, —Ẽ, arỳm ne djãm mrãmri o mex nhym mrãnh mexja pumũ. Mrãmri ne kabẽnkumrẽx. Djãm kute me axweo biknor kêt got? Mrãmri kute Metĩndjwỳnh kabẽnkôt me axweo biknorkumrẽx. Ga, kute kam me'õo mex nhym mrãnh mexkumrẽxja pumũ. Metĩndjwỳnh mexkumrẽx, ane. Nãm me krãptĩ: ã amim ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nhym kam Jeju arỳm tẽ. Tẽ: nhym me'õ bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djàkam nhỹ. Idjibê ne Matêu. Nhỹ nhym arỳm omũn kum, “Amrẽ mã ikôt ajkamẽ”, ane. Nãm kum ane nhym Matêu arỳm amim kabẽn man kàjmã dja. Kàjmã djan arỳm kôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nhym kam arỳm Matêu nhũrkwãkam tẽn bôx ne arỳm õ kwỳ krẽno nhỹ. Nhym bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnh krãptĩ bôx ne Jejumẽ ro'ã nhỹ. Nhym we me axwedjwỳ ikô'ã nhỹ. Me krãptĩ ne me nhỹ. Jeju kôt ba djwỳnh ne ar Matêumẽ ro'ã nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nhym mebê pardjêu arỳm me ja pumũn arỳm Jejukôt ba djwỳnh arkum, —Je tô, djãm me wã axwe ngri got? Mỳkam ne ar anhõ ujarẽnh djwỳnh me ro'ã õ kwỳ krẽno nhỹ? Bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnhmẽ me axwemẽ ro'ã õ kwỳ krẽno nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Nhym Jeju arỳm ar kabẽn ma. Ar kute, —Djãm me wã axwe ngri got? anhỹrja Jeju arỳm kuman arkum, —Djãm me mex'ỳr ne me kane djwỳnh mrã? Kati, me kanê'ỳrbit ne me kane djwỳnh mrã. Badjwỳ ne ba me axwe'ỳr tẽ. Djãm we me amex'ỳr ne ba tẽ? Kati, me axwe'ỳr ne ba tẽ. Me tãm ne ba amiwỳr me ku'uw. Me amikam kaprĩren wãnh axwemã irern iwỳr amijo akẽxmã ne ba amiwỳr me ku'uw. Nhym be, amrẽbê: ne Metĩndjwỳnh me bakukãmãremã kum, “Djãm me aje imã mry bôr djãm imã kĩnh? Kati. Me amã me kaprĩ. Ja ne imã kĩnh”, ane. Mỳj'ã ne Metĩndjwỳnh me bakukãmãremã ja jarẽ? Ja dja gar tẽn ama. Mỳkam? Bir, me axwe ne ba amikôt me ku'uw. Nãm ã Jeju mebê pardjêumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nhym kam Djuão. Kubê ngômã me angjênh djwỳnh. Djuãokôt ba djwỳnh ar arỳm Jeju'ỳr bôx ne kum, —Ar ba ne bar ije Metĩndjwỳnhmã amijajbur kumex. Mebê pardjêudjwỳ ne me kute kum amijajbur kumex. Nhym be, akôt ba djwỳnh ne ar kute kum amijajbur kêt. Mỳkam? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nhym Jeju tu amijã mjên jarẽn amikôt ba djwỳnh ar'ã mjênmẽ ro'ã ar ar ba jarẽn arkum, —Ga, me kute abenã mjênmẽ prõmẽ rẽnhja pumũ. Djãm ar mjênmẽ ro'ã ar baja kaprĩn mỳr got? Arkati. Ar kĩnhkumrẽx ne ar õ kwỳ krẽn rax. Adjỹm, dja apỹnh akati amrẽ mõrjakam me Ar kubê mjêno tỹm ne mã o mõ. Nhym kam gêdja ar kaprĩren arỳm Metĩndjwỳnhmã amijajburo ba. Nãm ã Jeju Djuãokôt ba djwỳnh arkum ane. Amijã ne mjên jarẽ. Ne amikôt ba djwỳnh'ã ne mjênmẽ ro'ã ar ar baja jarẽn arỳm ã arkum ane. Mỳj'ã ne me kute Ar kubê mjêno tỹmja jarẽ? Bir, ta amijã ne arẽ. Jeju dja meo tỹm ne mã o mõ. Kambit dja kôt ba djwỳnh amijajburo ba. ");
INSERT INTO txuNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Be, ga, me kute jãm amim Jeju kukràdjà ny mar ne ajte kute jãm amim me kukràdjà tũm marja pumũ. Me kute amẽ kukràdjà maro bakam umar mex kêt. Me kute mrãmri ne kubẽkà ny kubẽkà tũm'ã ir pyràk ne ajte kute pidjô kangô ny mrykào ngônh tũmkam runh pyràk. 'Ã ne Jeju ajte memã kum, —Ga, me'õ nhõ kubẽkà tũm ne arỳm 'yrja pumũ. Nhym kam arỳm kubẽkà nyn põnh kêt. Djã ne me tũmja'ã kudji? Kati. Mỳkam? Bir, dja me kupõ nhym arỳm nykam ê abenmã wangij. Abenmã wangij ne arỳm tũmja kadjô. Nhym kam arỳm 'yr nyja kute 'yr tũmja jakrenh mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ga, me'õ nhõ mrykào ngônhja pumũ. Me bakukãmãre ne me õ mrykào ngônh. Ga, mrykào ngônh arỳm tũm ne ngràja pumũ. Djã ne kam uba kangô ny ru? Kati. Mỳkam? Bir, dja nõr 'ãtũm nhym uba kangô arỳm kadjàn ajmrô nhym ngônh arỳm igot tẽn arỳm ajkatõr. Nhym arỳm kangô ajkapĩ nhym ngônh arỳm punu ne. Be, kam mex rã'ã kadjy ne me kute mry kào ngônh ny, kà rerekrekambit kangô ny runh prãm. Nãm ã Jeju arkum ane. Gêdja me amim Jeju kukràdjà nybit maro ban arỳm mar mexkumrẽx. Nhym be, gêdja me amim me kukràdjà tũmdjwỳ mar prãm ne arỳm umar mex kêtkumrẽx. 'Ã ne Jeju memã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kute memã ja jarẽnho ãmkam ne me'õ bẽnjadjwỳr 'ỳr bôx ne kute kum rax jarẽnh kadjy tu parbê tỹm. Ne arỳm kum rax jarẽn kum, —Arỳm godja ikra ni ty. Dja ga ikôt 'ỳr tẽn 'ã anhikra dji gê arỳm tĩn ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nhym arỳm kàjmã djan kôt tẽ. Kôt ba djwỳnhdjwỳ ne arkôt tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tẽ: nhym me'õ nire kôt bôx. Kamrô apôx'ã ne arỳm amexbê 12 apêx. Nãm kôt bôx ne tu Jeju nhibũm kôt 'ã kubẽkà jabu djàbit kupê. ");
INSERT INTO txuNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kute o anhỹr djwỳnhràm ne ta arỳm amim, —Ba gop 'ã kubẽkàbit mãn kupên arỳm imex ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nhym kam Jeju arỳm akẽx ne omũn kum, —Àpnhĩre, on akĩnh. Ga ne ga tu amim ikamnhĩxkumrẽx ne arỳm amex ne, ane. Nhym kam myt tãmkam mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nhym kam Jeju ar tẽ. Tẽ:n kam arỳm bẽnjadjwỳr nhũrkwã'ỳr bôx ne arỳm wadjà. Nhym wãnh me kwỳ pore kakôro dja nhym me kangao kumex. ");
INSERT INTO txuNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nhym memã kum, —Me on ajmà. Djã nãm kurerer wã ty got? Kati. Nãm õto nõ, ane. Nhym me arỳm 'ã keketo kumex. ");
INSERT INTO txuNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ne arỳm kato. Nhym kam arỳm 'ỳr tẽn 'ỳr bôx ne kurerer nhikra 'amỳ. Nhym arỳm tĩn ne kàjmã dja. ");
INSERT INTO txuNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nhym kam me arỳm pyka kunĩkôt arẽnho ipôk ne. ");
INSERT INTO txuNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nhym kam Jeju arỳm amũ tẽ. Tẽ: nhym me'õ no rã ar amãnhkrut arỳm kôt tẽ. Nãm ar kàj bê kum amijo àmra tẽn mã kum, —Dawi tàmdjwỳ gop amã ar ikaprĩ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nhym arỳm kikremã wadjà nhym ar no rã arỳm 'ỳr bôx. Nhym ar kukij ne arkum, —Djã ne gãm ar tu amim imarkumrẽx? Ije ar ajo mex marja djãm mrãmri ar aje tu amim ja markumrẽx? ane. Nhym ar kum, “Nà, Bẽnjadjwỳr djwỳnh”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nhym kam arỳm ar no kupê ne arkum, —Ar aje tu amim imarkumrẽx kôt dja ba ã ar ajo ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nhym kam ar arỳm rĩt mex ne. Nhym Jeju nêje arkum 'ã karõn kàj bê arkum, —Kwãrĩk wãnh me'õmã ijarẽnh kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nhym ate ar katon arỳm pyka kunĩkôt arẽnho ipôk ne. ");
INSERT INTO txuNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nhym kam me Jeju'ỳr me'õo bôx. Me karõ punu ne ar me'õo ba nhym ô'ã kabẽn kêt nhym me 'ỳr o bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nhym arỳm me karõ janon kujate nhym arỳm me aêrbê kabẽn mexkumrẽx. Nhym me krãptĩ: kam no tyn kumex ne abenmã kum, —Mỳj me'õ ne kute me babê idjaerkam mỳjja pumũnh kêt ja'õ pumũnh? Arkati, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nhym be, mebê pardjêu ne me memã kum, —Me karõ punu nhõ bẽnjadjwỳr kabẽnkôt ne kute me karõ kujaêko ba, ane. Nãm mebê pardjêu ã Jeju'ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jeju ne krĩrax kunĩkôt memã ujarẽnh ny jarẽnho tẽ. Krĩraxmẽ krĩ kryre kunĩkôt memã arẽnho tẽ. Me bikprõnh djàkam memã arẽnho tẽ. Bẽnjadjwỳr djwỳnh kute amim me utàr ne ar meo ba'ã ujarẽnh nyja ne kàj bê memã arẽnho tẽ. Ne ajte me punumẽ me kanê kunĩo mexo tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ne kam me krãptĩ: pumũ. Nãm me omũn arỳm kum me kaprĩ:. Mỳkam? Bir, me katyk ne ate ar bakam. Me kute mrãmri ne kute mrykĩ'ãtomtio djuw mex djwỳnh kêtkam katyk ne ate ar ba pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ne kam kôt ba djwỳnhmã kum, —Me kute Metĩndjwỳnh mar prãmja ne me kumex. Nãm me kute mrãmri ne bày arỳm abôr tyk ne kumexja pyràk. Nhym be, Metĩndjwỳnh'ã ujarẽnh djwỳnh ne me ngrêre kute bàykam me àpênh djwỳnh ngrêreja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kam dja gar me kadjy Metĩndjwỳnh 'uw gê me'ỳr 'ã ujarẽnh djwỳnh jano gê me memã arẽ nhym me kuman kam arỳm tu amim markumrẽx ne. Kute mrãmri ne me mrãnh ne kute me õ purkam bày pumũnh ne mrãnh ne bôx ne kute kadjy me õ pur djwỳnhmã arẽnh nhym me kute amũ kadjy memã arẽnh nhym me ban kute memã ê ja pyràk. Dja gar ã me kadjy Metĩndjwỳnh 'wỳro ane. ");
INSERT INTO txuNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nhym kam amiwỳr kôt ba djwỳnh Ar kubê 12 'uw nhym ar bôx. Nhym ar kute kabẽnkôt me karõ punu janor ne kujaêk kadjy arkum amipyma jadjà. Nhym apỹnh me punu djàri. Nhym apỹnh me kanê djàri. Nhym ar kute kabẽnkôt meo mex kadjy arkum tỳx jadjà. Ne kam arỳm ar ano. ");
INSERT INTO txuNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Apỹnh kute ar anorbê 12 nhidji jarẽnh kadjy ne ja. Ximão. Idji 'õdjwỳ ne Pedru. Ãngre. Kamybê ne Pedru. Xijagu. Djebedêu ne kudji. Djuão. Kamybê ne Xijagu. ");
INSERT INTO txuNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Piripi. Batormê. Tôme. Matêu. Kubê ne bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnh. Xijagu 'õdjwỳ. Aupêu ne kudji. Tadêu. ");
INSERT INTO txuNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ximão 'õdjwỳ. Mekôt ne me kukràdjà'ã no tỳx. Djuda. Idji nhikjêbê ne Ikadji. Tãmja ne Jeju kurê djwỳnhmã kanga. Apỹnh kute ar anorbê 12 nhidji ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ar ja ne Jeju ar ano. Nãm ar àpênh djà'ã arkum karõn ar ano. Nãm arkum, —Kwãrĩk wãnh me bajtemmã ar amõr kêt ne kwãrĩk wãnh pykabê Xamarijkam krĩ'õmã ar adjàr kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mebê idjaer ne me no akunon ate ar ba kute mrãmri ne mrykĩ'ãtomti no biknor pyràk. Me ja'ỳr dja gar mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ne me'ỳr bôx ne kàj bê memã kum, “Arỳm kàjkwakam Bẽnjadjwỳr djwỳnh kute pykabê amim õ me utàr ne ar meo ba 'ỳr”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Dja gar me kanêo mex ne ajte me ĩ kajêkam têo mex ne ajte akubyn me tyko tĩn. Ne ajte mekam me karõ punu janon kujate. Ba ne ba tu kajgo ar amã adjàpênh djà'ã karõ gar maro aba. Ikudjwa tu kajgo meo mexo aba. Kwãrĩk wãnh memã pãnh jarẽnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kwãrĩk wãnh kẽn karỳr nàr kryt jaka nàr kryt kamrêkbê kobri me kute o õ pi'ôk kaprĩja kwãrĩk wãnh byr ne ar anhõ katõk'y djàkam ir kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kwãrĩk wãnh ar anhõ xakuo amõr kêt. Ar akà krãkà pỹnh ne ar aparkà amãnhkrut ne ar anhõ kô pỹnh dja gar o mõ. Jabit dja gar o mõ. Ar anhõ mỳjja ja'õ'ã kàtàm kwãrĩk wãnh o amõr kêt. Ar adjàpênh pãnh dja me ta ar amã ar anhõ mỳjja ngã. Nãm ã arkum karõo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ne kam ajte arkum, —Dja gar krĩrax 'õmã wadjàn me'õ mexja jabej. Kum ar akĩnh dja gar abej. Dja ar amã aminhũrkwã jarẽ gar kambit anhikwã. Me kurũm ar akatorkambit ajte anhũrkwã 'õdjwỳ jabej. ");
INSERT INTO txuNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Dja gar me ũrkwã 'õmã wadjàn memã umar mex jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Dja me mex ne kum ar akĩnh gar memã umar mex jarẽ nhym me arỳm ar akabẽn kôt mrãmri umar mexkumrẽx. Nàr godja me kum ar akĩnh kêt jabej dja me umar mex kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Godja me'õ kum ar akĩnh kêt ne kute akabẽn mar prãm kêt jabej aparkà'ã me õ pyka ka'u. Me ũrkwã kurũm nàr me õ krĩrax kurũm ar akator kutã ar aparkà'ã me õ pyka ka'u. Aje me kute akabẽn mar prãm kêtjao amirĩt nhym Metĩndjwỳnh kute omũnh ne amũ 'õkam kute memã pãnh jarẽnh kadjy me õ pyka ka'u. ");
INSERT INTO txuNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ba ar amã arẽ gar ama. Amrẽbê: me bakukãmãrekam ne me krĩraxbê Xôtômamẽ Gomorakam axwekumrẽx. Dja ĩ Metĩndjwỳnh kute me axwemã pãnh jarẽnh kadjy akati bôx nhym me arỳm tokry. Dja ajbir krĩrax jakamdjwỳ me axwe pãnh tokry:. Ne tokryo Xôtômakam me jamẽ Gomorakam me ja jakrenh me:x ne. Mrãmri ne ba ar amã arẽnhkumrẽx, ane. Jeju ã arkum 'ã karõo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ne kam ajte arkum, —Dja ba ar ajano gar arỳm aje mrãmri ne mrykĩ'ãtomti kute rop djàkrê katikôt ar ba pyràk. Amijã ano tỳx kute mrãmri ne kangã amijã no tỳx pyràk. Ne ar ajaxwe kêt kute mrãmri ne tut axwe kêt pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aminêje rĩt. Mỳkam. Bir, godja me ar ajo rôrôk ne ar ajo mõ. Nhym kam me krãptĩ kute ar akukjêr kadjy arỳm ar ajã akuprõ. Ar ajã akuprõ nhym me arỳm ar akaprêprêk. Mebê idjaer bikprõnh djàkam ar akaprêprêk. Mry kà punuo ar akaprêprêk ne. ");
INSERT INTO txuNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Imã ar adjàpênhkam dja me ar ajo rôrôk ne ar apa 'amỳn arỳm me bẽnjadjwỳr kabem ar apumjuw. Ne me bẽnjadjwỳr rũnh kabem ar apumjuw gar arỳm ijã memã amijarẽ. Nhym me me bajtem kabem ar apumjuw gar arỳm ijã memã amijarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Godja me ar ajo rôrôk ne ar ajo mõn me kabem ar apumjuw kwãrĩk wãnh ar amikukãm amim, “Mỳj dja ba aminêje memã ikabẽn on”? anhỹr kêt. Mỳkam? Bir, myt tãmkam dja ar amã akabẽn jangij. ");
INSERT INTO txuNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Djãm ar ga dja gar amikabẽn jarẽ? Kati. Ar Abãm djwỳnh Karõ dja ar amã amikabẽn jarẽ gar arỳm amũ memã arẽ. Nãm Jeju ã arkum 'ã karõo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ne kam ajte arkum, —Me kamy dja kurê djwỳnhmã kamy kanga nhym me arỳm me kupa. Nhym me bãmdjwỳ dja kurê djwỳnhmã kra kanga. Nhym me kra dja me kum bãmmẽ nã kurê ne memã ar kanga nhym me ar kupa. ");
INSERT INTO txuNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Imã adjàpênhkôt dja me kunĩ kum ar akurê. Dja gar ikôt ar aba tỳx rã'ã:n ijã adjukanga kêt ne kam 'ã aminhinomã amimẽ ba arỳm ar apytà. ");
INSERT INTO txuNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Godja me krĩrax 'õkam kum ar akurên ar ajo ajkẽ gar krĩrax 'õdjwỳmã aprõt. Dja gar apỹnh mebê idjaer nhõ krĩraxkam me akreo tẽ:n o atẽm nhinomã mẽnh kêt ba arỳm bôx. Ba ije amijo inhĩ ba arỳm ar awỳr bôx. Nãm Jeju ã arkum 'ã karõo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ne kam ajte arkum, —Ẽ, djãm ar kute kabẽn mar ar o baja kute raxo ar õ ujarẽnh djwỳnh jakrenh? Kati. Nàr, djãm õ àpênh kute raxo õ bẽnjadjwỳr jakrenh? Kati. ");
INSERT INTO txuNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kute kabẽn mar ar o baja kute ar õ ujarẽnh djwỳnh kôt ar amijo bakambit ne mex. Õ àpênh kute õ bẽnjadjwỳr kôt ar amijo bakambit ne mex. Ga, me kum ikurê ne imã me karõ punubê Bedjêbu jarẽnho baja pumũ. Djãm me kum ar akurê kêtmã? Kati. Ar gadjwỳ dja me ar amã mỳjja punu jarẽnh kume:x. Ar aje araxo ijakrenh kêtkam ne ikôt ar amijo abakam dja me ar gadjwỳ ar amã mỳjja punu jarẽnh kume:x. ");
INSERT INTO txuNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Djã nãm me kadjwỳnhbê axweja bipdjur rã'ãmã? Kati, dja ĩ amirĩt ne. Nhỹnh ne mỳjja bipdjur'õ me kute omũnh kêtmã? Ne nhỹnh ne me kute mỳjja pudjur'õ mar kêtmã? Adjỹm, dja ĩ kunĩ amirĩt ne. Mỳjja pudjur, mỳjjao bipdjurja dja ĩ kunĩ amirĩt ne. ");
INSERT INTO txuNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ije akamàtkam ar amã mỳjja jarẽnh dja gar a'uri kàj bê memã arẽ. Ije ar ajamakri ijajkwa momokkam mỳjja jarẽnh dja gar kikre nhimõk po'ã djan kàj bê memã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ne kwãrĩk wãnh gar amã me kute ar aparja pyma kêt. Me ja gêdja me ar akrãkàbit par kajgon kam ijukri kute ar akadjwỳnhbê ajmã ar ajo kêt. Kati, ba ar amã arẽ. Me'õ pydji dja ga ar amã uma. Kute me bĩn ne ijukri me biknor tokry djàkam me rẽnh jabit dja ga ar amã uma. Be, ba ar amã arẽ. Metĩndjwỳnhbit dja gar amã uma. ");
INSERT INTO txuNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kwênhne amãnhkrut ne pãnh ngrire, pãnh ngônhponh pydji. Nhym kam kwênh pydji pykabê tỹm ne arỳm ty. Djãm Abãm djwỳnh kute mar kêt? Kati. Kute kwênh mar. ");
INSERT INTO txuNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ne ar akĩdjwỳ kute mar. Arỳm Abãm djwỳnh kute ar amã abenã ar akĩ'ã akre mar. ");
INSERT INTO txuNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kam, djãm ar atĩn prãmmã? Kati. Kwãrĩk wãnh. Te kwênh krãptĩ: nhym kum kwênh kĩnh ngrire. Nhym be, ar gajbit. Metĩndjwỳnh kum ar akĩnhkumrẽx. Tãm dja gar aman atĩn prãm kêt. Nãm Jeju ã arkum karõo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ne kam ajte arkum, —Kam me'õ kute amijo ipytàr ne me ipôkri memã kum, “Ba ne ba ije amim Jeju mar”, anhỹro baja. Badjwỳ dja ba tãmwã'ã kàjkwakam Ibãmmã kum, “Nà, ba inhõbikwa ne wã”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nàr, dja me'õ me ipôkri memã kum, “Kati. Ije Jeju mar kêt”, ane. Badjwỳ dja ba tãmwã'ã kàjkwakam Ibãmmã kum, “Kati. Ije tãmwã mar kêt”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Djãm ibôx nhym ikam me umar mexmã? Kati. Dja ba bôx nhym me arỳm imỳr jabej abeno kurê djwỳnh ne aben pa. ");
INSERT INTO txuNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Amrẽbê: ne me me bakukãmãremã kum, “Dja me'õ my kum bãm kurê. Nhym me'õ nire kum nã kurê. Nhym prõ kum umrengêx kurê. ");
INSERT INTO txuNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Me'õ nhũrkwãkam dja ta õbikwa kum aben kurê.” Nãm me ã me bakukãmãremã ane. Jakam dja me imỳr jabej ã abeno ane. Me kute me bakukãmãremã arẽnh kôt dja me ã abeno ane. ");
INSERT INTO txuNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Godja gar ajõ imã, “Ba akôt apê”, anen amã abãmbit nàr amã anãbit kĩnh ne amã ikĩnh ngrire ba arỳm imã ikôt adjàpênh kĩnh kêt. Godja amã akra mybit nàr amã akra nibit kĩnh ne amã ikĩnh ngrire ba arỳm imã ikôt adjàpênh kĩnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Dja gar ajõ amã ikôt atokry pyma ne ikôt aje anhõ pĩte'y mỳnh prãm kêt ne ikôt abikamẽnh prãm kêt jabej ba kam imã ikôt adjàpênhja kĩnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dja gar ajõ atĩnmã aminên arỳm akuno. Nàr gar ibê aminê kêt nhym me arỳm abĩ. Imã adjàpênhkam arỳm abĩ. Kwãrĩk wãnh rã'ã. Metĩndjwỳnh dja arỳm atĩnkumrẽx kadjy apytà ga arỳm kôt atĩn ne ar aba rã'ã: rã'ã ne. Nãm ã Jeju arkum 'ã karõo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ne kam ajte arkum, —Dja gar me'ỳr bôx nhym me kum ar akĩnh. Me kum ar akĩnh o arỳm kum badjwỳ ikĩnh. Ne kum ikĩnh o arỳm kum kute ijanor djwỳnhdjwỳ kĩnh. ");
INSERT INTO txuNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dja Metĩndjwỳnh kukwakam memã kabẽn jarẽnh djwỳnh me'ỳr bôx nhym me kum kĩnh. Kubê Metĩndjwỳnh kukwakam memã kabẽn jarẽnh djwỳnhkam kum kĩnh. Metĩndjwỳnh dja kam arỳm memã o pãnh ne. Metĩndjwỳnh kute kukwakam ujarẽnh djwỳnhmã àpênho pãnh kôt dja arỳm memã o pãnh. Dja me'õ katàt kute amijo bakumrẽx me'ỳr bôx nhym me kum kĩnh. Me'õ katàt kute amijo bakam me kum kĩnh. Metĩndjwỳnh dja arỳm memã o pãnh ne. Metĩndjwỳnh kute me'õ katàt kute amijo bajamã o pãnh kôt dja memã o pãnh. ");
INSERT INTO txuNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dja me'õ ikôt ba djwỳnh rax kêt'õ bôx nhym me kum ngô ngã. Me'õja kute ikôt bakam kum ngô ngã. Ba dja ba mrãmri o pãnh mex. Me kute o djuw mex ngrire jao pãnh mex. Nãm ã Jeju arkum 'ã karõo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ne arỳm kôt ba djwỳnh Ar kubê 12mã 'ã karõ pa. Arkum 'ã karõ pan kam arỳm amũ tẽ. Pykabê Garrêjakam apỹnh krĩ rũnh djàri kute memã kukràdjà jarẽnh ne kute kàj bê 'ã me akre kadjy ne amũ tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nhym kam me Djuãomã Jeju jarẽ. Djuãobê ne ngômã me angjênh djwỳnh. Me kute arỳm Djuãobê ijêkam ne me kum Jeju jarẽ. Nãm me Djuãomã kum, —Jeju ne arỳm apỹnh mỳjja pumũnh kêt nhipêx, ane nhym arỳm kuma. Kuman arỳm Jeju'ỳr amikôt ba djwỳnh ar amãnhkrut jano. ");
INSERT INTO txuNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ar kute Jeju kukjêrmã ne Djuão ar ano nhym ar arỳm 'ỳr tẽn 'ỳr bôx ne Jejumã kum, —Metĩndjwỳnh kute me imã me'õ janor nhym bôxmã, kute me imã arẽnhja djãm ga? Nàr kon godja gwaj me'õkam ama? Nãm ar ã Jejumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nhym Jeju arkum, —Dja gar akubyn Djuão'ỳr tẽn kum arẽ. Aje ajbir mỳjja mar ne omũnhja kum arẽn kum, ");
INSERT INTO txuNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Me no rã arỳm rĩt mex. Nhym me mrãnh kêt arỳm mrãnh mex. Nhym me ĩ kajêkam tê arỳm mex. Nhym me amakkre kêt arỳm amak mex. Nhym me tyk akubyn tĩn ne. Nhym me õ mỳjja kêtja nhym me kàj bê memã ujarẽnh ny jarẽnho ba”, ane. Tãm dja gar aman Djuãomã arẽ gê kuma. ");
INSERT INTO txuNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dja me memã ijarẽ nhym me ibê amijo akẽx kêt, me ja ne me kĩnhkumrẽx. Nãm ã Jeju Djuãokôt ba djwỳnh arkum ane. Nhym ar kuman arỳm katon tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nhym kam Jeju arỳm me krãptĩ:mã kum, —Mỳj ne ga me aje kapôt kukritkam omũnhmã mõ? Djãm Djuão kute bõti kôk djàbêrkam ari amijadjwỳr pyràk? Djãm ari memã kabẽn jadjuw? Kati. Nãm katàt memã kabẽn jadjwỳrkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bir, mỳj ne ga me aje omũnhmã mõ? Djãm Djuão ne kubẽkà pãnh rax ne akrita jangij? Kati. Nãm kubẽkà pãnh ngrire jangij. Bẽnjadjwỳr rũnh nhõ kikretikam ne me kubẽkà jakrita jangij. Nhym be, Djuão ã kà kute anhỹr kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nhym bir, mỳj ne ga me aje omũnhmã mõ? Djãm Metĩndjwỳnh kukwakam memã ujarẽnh djwỳnh? Nà. Tãm. Nhym be, Djuão ne raxo kute Metĩndjwỳnh kukwakam memã ujarẽnh djwỳnh kunĩ jakrenh. ");
INSERT INTO txuNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Amrẽbê: ne Metĩndjwỳnh imã 'ã ajarẽ. Djuão'ã imã ajarẽ. Nãm imã, “Ota ba akukãm ajã ujarẽnh djwỳnh'õ jano kute akukãm me akre nhym me kute mar ne akutêp kute axwemã irern katàt amijo bamã. Kute mrãmri ne me kute me bẽnjadjwỳr rũnh kutêp katàt 'ã pry jadjwỳrja pyràk.” Nãm ã Metĩndjwỳnh Djuão'ã imã ane. Amrẽbê: me bakukãmãre ar bari. Nhym me arỳm kabẽn man 'ã pi'ôk no'ôk ne. Ne kam me aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm me bakamingrãnyrekam Djuão arỳm kato. Katon arỳm abatành ne. Abatành ne arỳm ijã memã ujarẽnh ar ba. Me kute amrẽbê Metĩndjwỳnh kabẽn'ã pi'ôk no'ôk kôt ne Djuão ijã ujarẽnh ar ba. Ikukãm meo mexo ba. ");
INSERT INTO txuNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngômã me angjênh djwỳnhbê Djuão ne jakam raxo kute pykakam me kunĩ jakrenh. Djãm me'õ pykakam ar ba 'õ raxo kute Djuão jakrenh? Kati. Mrãmri ne ba me amã ja jarẽnhkumrẽx. Nhym be, dja ĩ kàjkwakam Bẽnjadjwỳr djwỳnh amim me utàn meo ba. Nhym kam dja me kunĩ raxo Djuão jakre. ");
INSERT INTO txuNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nhym be, on jakam Djuão ra:x. Nãm memã arẽnho ban memã kum, “Kàjkwakam Bẽnjadjwỳr djwỳnh kute amim me utàr ne ar meo ba 'ỳr”, anhỹro ba. Nhym kam me krãptĩ kuman amim Bẽnjadjwỳr djwỳnh mar prã:m. Me kute mrãmri ne me krãptĩ kute kikre ngriremã ngjêx prãm ne kute 'ã kute aben nhingãnhja pyràk. Me kute ari 'ã ikjêo aben rẽnh ne 'ã kute aben nhingãnho kumex ja pyràk. Ne jakam me kute o anhỹr rã'ã. ");
INSERT INTO txuNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Amrẽbê: me me bakukãmãremã Bẽnjadjwỳr djwỳnh bôxmã arẽ. Metĩndjwỳnh kukwakam ujarẽnh djwỳnh aben kukãm Bẽnjadjwỳr djwỳnh bôxmã arẽ:. Môjdjêdjwỳ arẽ: nhym kam me bakamingrãnyrekam Djuão arỳm katon ajte tãm jarẽ. Bẽnjadjwỳr djwỳnh bôx jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Amrẽbê: ne me me bakukãmãremã kum, “Dja me'õ kute Erij pyràk bôx”, ane. Ba on ar amã me'õ jarẽ gar ama. Djuão ne kute Erij pyràk ne arỳm bôx. Ar aje imar prãm jabej dja gar arỳm ima. Nàr ar aje imar prãm kêt jabej arỳm imar kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Gop ar ajamak mex jabej tu amim ikabẽn ja markumrẽx. Nãm ã Jeju me krãptĩmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ne kam ajte memã kum, —Je tô mỳj got ba me akamingrãny'ã akre? Mỳj ne ga me aje uràk? Nã gãm me aje me prĩre mỳjja kam kĩnh kêt pyràk. Ga me, me prĩre kikre kabem krĩn kute abeno bixaêr baja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ar ja ne ar ar jamã kabẽn ne arkum, “Gwaj bakĩnh katio dja, gwaj babixaêro dja ne ngôtàx à'àk”, ane. Nhym ar kum, “Waj, ar ibixaêr prãm kêtê. Ar itor prãm kêtê. Ar imã wã kĩnh kêtê”, ane. Nhym ajte arkum, “Gwaj bamỳr kati mãn o nhỹ”, ane. Nhym ar, “Kê, wajre. Ar imã kĩnh kêtê. Ar imỳr prãm kêtê”, ane. Be, nã gãm me aje me prĩre pyràk ne amã ja kĩnh kêt ne ajte amã jadjwỳ kĩnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Djuãobê ngômã me angjênh djwỳnh ne me awỳr bôx. Nãm amijajbu:n kute uba kangôo kõm kêt ne ar ba ga me amã kĩnh kêt ne kam we, “Nãm ajbã. Me karõ punu ne ar o ba nhym ajbã”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nhym be, ba ne ba mrãmri gêt amijo inhĩ ne me awỳr bôx ne me akam idjàkur iban kôt ikõm iba ga me amã ikĩnh kêt ne we ijã, “Kê, tãmwã ne kute àkur rũnhbit mar, kum uba kangô djànhti”, ane. Ne we ajte ijã, “Me kute bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnhmẽ me axweo bit ne õbikwa ne”, anhỹr ar o aba. Nhym be, djãm Metĩndjwỳnh amak punu got? Amak me:xkumrẽx ne prĩne kute amikukãm mỳjja kunĩ mar ne Djuão kute amijajbur ne ar bamã ano. Ne ajte amikukãm umarkam badjwỳ ijano. Ije amijajbur kêtmã ijano. Nhym kôt me amak mex ne amikukãm umar, ar ipumũn kam õkre kadjwỳnhbê amim, “Mrãmri ne Metĩndjwỳnh mexkumrẽx ne amẽ ar ano.” Nãm ã Jeju memã ane. Tãm ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nĩjar krĩraxkam ne Jeju mỳjja pumũnh kêt ngrêre nhipêx nhym me krãptĩ tu amim markumrẽx. Nhym kam arỳm me wãmã kabẽn'õ jarẽnh kêt. Nhym be, amiwỳr krĩraxkam me ja ne Jeju arỳm memã kabẽn ne. Krĩrax jakam ne arỳm mỳjja pumũnh kêt krãptĩ nhipêx ne me punu krãptĩo mex. Djã ne me amikam kaprĩren wãnh axwemã iren 'ỳr amijo akẽx? Kati. Me kute 'ỳr amijo akẽx kêt. Kam ne arỳm krĩrax jakam memã kabẽn ne memã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Ỹ, watĩ:re Koradjikam me wã. Watĩ:re Bexadakam me wã. Dja ga me atokry rax ne. Ba ren me bajtem nhõ pykabê Xirumẽ Xidõkam ren mỳjja rũnhja, mỳjja pumũnh kêtja kwỳ nhipêx nhym ren me omũn ren arỳm amrẽbê amim katon ren amikam kaprĩren wãnh axwemã ire. Ne ren kute kum irero amirĩt kadjy kubẽkà kukrebê exopa jangjên ren amijã mro prà kapĩ. Ne ren kam iwỳr ren amijo akẽx. Nhym be kati, inhõ me wỳnhkam me ga, Koradjikam me gamẽ Bexadakam me gamẽ me akam ne ba te mỳjja pumũnh kêt kwỳ rax ne ipêx ga me omũnh kajgo. Omũnh kajgon amikam akaprĩre kêt ne wãnh ajaxwemã anhirer kêtkumrẽx ne aje iwỳr amijo akẽx kêtkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ba me amã arẽ ga me ama. Dja ĩ kute me axwemã pãnh jarẽnh nhõ akati bôx nhym Metĩndjwỳnh me ajaxwemã pãnh jarẽ. Ga me kam arỳm pãnh atokryo me rĩnã jakrenh mex. Ga me atokryo krĩraxbê Xirumẽ Xidõ jakrenh mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ne kam krĩraxbê Kapanakam me gadjwỳ djãm mrãmri me abẽnjadjwỳr rũnho kàjkwa'ỳr abôxmã? Kati, aparmãbit dja ga me me biknor tokry djàmã wadjà. Krĩraxbê Xôtômakam me axwe: nhym Metĩndjwỳnh arỳm meo akno. Ba ren mekam mỳjja pumũnh kêt nhipêx kute me akam ije mỳjja pumũnh kêt nhipêx ja pyràk nhym ren me wãnh axwemã ire nhym ren krĩrax arek ãm rã'ã. Krĩraxbê Xôtôma ren arek ãm rã'ã. Nhym be, kati. ");
INSERT INTO txuNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ba me amã arẽ ga me ama. Dja ĩ kute me axwemã pãnh jarẽnh kadjy õ akati bôx. Dja Metĩndjwỳnh memã pãnh jarẽ ga me kam arỳm atokry raxo Xôtômakam me ja jakrenh mex ne. Nãm ã Jeju krĩraxkam me jamã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Nhym kam Jeju Bãmmã kum, —Djũnwã, ota ga anhõ kàjkwa, anhõ pyka djwỳnh. Amã ne ba amikĩnh jarẽ. Nã gãm me amikukãm umarmẽ me kute mỳjja mar rũnhjabê mỳjja ja pudju. Ne kam me kute amijo prĩre pràbê amijo rũnh kêtjamã mỳjjao amirĩt ne. Mrãmri Djũnwã, nã gãm ã aje anhỹrkam mrãmri mexkumrẽx. Ga adjukaprĩkam ne ga amim me'ã karõn arỳm ã meo ane. Ba kam badjwỳ ikĩnhkumrẽx ne wãm amã amikĩnh jarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ne kam ajte me krãptĩmã kum, —Arỳm ne Ibãm imã õ mỳjja kunĩ kanga. Ba ibê Metĩndjwỳnh Kra. Djãm me'õ ne kute prĩne imar? Kati. Ibãmbit ne kute imar. Djãm me'õ ne kute prĩne Ibãm mar? Kati. Bajbit ne ba ije prĩne mar. Ije me'õmã Ibãmo amirĩt prãmja adjwỳnhdjwỳ kute mar. ");
INSERT INTO txuNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Pykakam me akukràdjà punu ne ga me aman kôt ar amijo aba. Ne kam arỳm akaprĩre kute mrãmri ne me jênh pytĩ turn o ban kam kaprĩja pyràk. Kam ne ga me akatyn akaprĩ:re. Amrẽ me akunĩ iwỳr tẽn ikam atyk djà kêt ne ikam akôkam kôt. ");
INSERT INTO txuNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Nãm me mry bàri kute jênh bjêro mrãnh kadjy ne umar mex kadjy mutbê pĩo kapa. Ikukràdjà mex ne kute mry mutbê pĩo kapaja pyràk. Dja ga me amim ikukràdjà mex man kôt ar amijo aba kute mrãmri ne me kute mry bàri mutbê pĩo kapa ja pyràk. Djãm aje ikukràdjà kôt ar amijo abakam adjumar punumã? Kati. Kam adjumar mexkumrẽx. Adjumar mex kute mrãmri ne me kute mry mutbê pĩ kajkrito kapa ja pyràk. Djãm ije me amã ino katormã? Djãm ije amijo idjàmramã? Kati. Ba ne ba memã iprĩ mex ne meo iban ije amijo ingrire kadjy amimar. Kam dja ga me ikukràdjà kôt ar amijo aba nhym me abê tỳx kêtkumrẽx ne. Kute mrãmri ne jênh kajkrit mrybê utĩ kêt pyràk. Kam dja ga me ikukràdjà kôt ar amijo aban arỳm akadjwỳnhbê atyk djà kêt. Nãm ã Jeju me krãptĩmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ne kam pi'ôk ràràrkam Jeju pur katikôt tẽ. Nhym kôt ba djwỳnh ar kôt mõn arỳm kum prãm ne mõrmã bàygogo 'y nhikẽn mrãnhkôt ngãnh ne amijajkwamã rẽnho mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nhym kam mebê pardjêu ar omũn kum, —Je tô mã ne akôt ba djwỳnh ar arỳm nẽ? Pi'ôk ràràrkam ne me tyk djà kêt djà. Me kute pi'ôk ràràrjakam mỳjja jao anhỹr kêt. Me tũmre ne me ta kukràdjàkôt mã me babê uma. Me kute pi'ôk ràràrkam mỳjja kupênh kêt. Kambit ne me tyk djà kêt djà. Mỳkam ne akôt ba djwỳnh ar ã ar o anhỹro ba? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nhym kam Jeju memã kum, —Kê, djãm me aje Metĩndjwỳnh kabẽn'ã pi'ôk no'ôkjadjwỳ pumũnh kêt? Djãm me aje me bakukãmãrebê Dawi'ã ujarẽnhja pumũnh kêt? Ẽ, Dawi arkum prã:m. ");
INSERT INTO txuNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kum prã:m nhym Dawi arỳm Metĩndjwỳnh nhũrkwãmã wadjàn djwỳ byn kukrẽn kam kôt ar tẽm jamãdjwỳ kungã nhym ar arỳm kukrẽ. Djwỳ me kute Metĩndjwỳnhmã õrja tãm ne kubyn kukrẽn arkum kungã. Metĩndjwỳnh nhõ djwỳ ja ne me kàtàm kute kur kêtkumrẽx. Me kadjy Metĩndjwỳnh mar djwỳnhbit ne kute kur. Nhym be, Dawi ta ne tu kukrẽ. Nhym kam me kute kum axwe jarẽnh kêt. Djãm me aje ja mar kêt? Ga, me kute Dawimã axwe jarẽnh kêtja pumũ. Ne kam ikôt ba djwỳnhmẽbit ar imã ar ijaxwe jarẽ. Je tô mỳkam? ");
INSERT INTO txuNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ba ajte me amã arẽ ga me ama. Mỳj ne me kadjy Metĩndjwỳnh mar djwỳnh pi'ôk ràràrkam nẽ? Mỳj ne me me tyk djà kêt djà nhõ akatikam nẽ. Djãm me aje me'ã Môjdjê kukràdjà mar kêt got? Djãm me aje 'ã pi'ôk no'ôk pumũnh kêt got ga me imã akabẽn ne? Nãm me pi'ôk ràràrkam Metĩndjwỳnh nhõ kikretikam tu àpênh ba. Ne kadjy kum mry bôro bao tu àpênh ar ba. Djã ne Metĩndjwỳnh kam memã axwe jarẽ? Kati. Ga, me kute me kadjy Metĩndjwỳnh mar djwỳnhmã axwe jarẽnh kêtja pumũ. Ne kam ikôt ba djwỳnhmẽbit ar imã ar ijaxwe jarẽ. Je tô mỳkam? ");
INSERT INTO txuNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ba ajte me amã arẽ ga me ama. Ba ne ba Metĩndjwỳnh nhõ kikretikam ipydji irax ne ije kam me àpênh'ã memã karõ djwỳnh. ");
INSERT INTO txuNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ga me ren Metĩndjwỳnh kute me bakukãmãremã kabẽn jarẽnhja ma. Nãm memã kum, “Djãm me aje imã mry bôr djãm imã kĩnh? Kati. Me amã me kaprĩ. Ja ne imã kĩnh.” Nãm ã Metĩndjwỳnh me bakukãmãremã ane. Ga me ren Metĩndjwỳnh kabẽn ja man ren amã me kaprĩ. Ne ren amã me kaprĩkumrẽx ne ren ar axwe kêtjamã axwe jarẽnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ba me amã arẽ ga me ama. Ba ije amijo inhĩ ne me awỳr irwỳk ne ba inhõ pi'ôk ràràr djwỳnh. Kam gêdja ba memã, “Kwãrĩk wãnh ga me kam mỳjja kupênh kêt nàr kon, dja ga me jakam apên nàr kam mỳjja kupênh kêt ne arek akrĩ”, ane. Tãm ne ja. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ne kam arỳm amũ tẽn mebê pardjêu nhõ me bikprõnh djàmã wadjà. ");
INSERT INTO txuNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nhym me'õ nhikra nhikjê jarõxja me ikô'ã nhỹ. Nhym me ja kute 'ã axwe nhôr kadjy Jeju kukij ne kum, —Djãm Môjdjê kukràdjà kôt ne me me tyk djà kêt djà nhõ akatikam meo mexo ba? Pi'ôk ràràrkam meo mexo ba? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nhym memã kum, —Ba me amã arẽ ga me ama. Godja me ajõ anhõ mrykĩ'ãtomti nhym pi'ôk ràràrkam arỳm kre'õkam tỹm. Djãm ate akrãmã? Kati. Dja ga amã kaprĩn 'amỳn kaba. ");
INSERT INTO txuNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nhym be, Metĩndjwỳnh kum mrykĩ'ãtomti kĩnh ngrire. Nhym be, gu me ba ne kum me bakĩnhkumrẽx. Kam me kute pi'ôk ràràrkam meo mexkam Metĩndjwỳnh kute memã axwe jarẽnh prãm kêt. Mrãmri, me kute pi'ôk ràràrkam meo mexkam ne me kute kukràdjà kôt amijo ba mexkumrẽx. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ne kam arỳm me'õ nhikra jarõxjamã kum, “Amrẽ anhikra katàt”, ane. Nhym 'ỳr ikra katàto dja nhym arỳm kum mex ne. Kum ikra mex kute ikra nhikjê mexja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nhym mebê pardjêu ar mã apôx ne o aben man abenmã kum, —Mỳj godja gwaj baje Jeju bĩn kadjy on? ane. Nãm me ã Jeju'ã abenmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nhym Jeju arỳm ar kuman pyka wã kurũm kato. Kato nhym me krãptĩ: arỳm kôt mõ nhym arỳm me kunĩo mex. ");
INSERT INTO txuNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ne kam mã memã kum, “Dja ga me ipudju”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Amrẽbê: ne Metĩndjwỳnh Jeju 'ã ajarẽ. Jeju dja memã prĩ mex ne memã kukràdjà jarẽ. Nhym kam kabẽn jarẽnh djwỳnh Metĩndjwỳnh kukwakam amũ me bakukãmãremã 'ã ajarẽn memã kum, “Metĩndjwỳnh ne memã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Ota, ba arỳm amijo inhõ àpênh pytà. Imã abê. Imã kĩnhkumrẽx. Dja ba kum Ikarõ jano nhym arỳm o ba. Nhym arỳm apỹnh me bajtem ba djàri memã 'ã ajarẽ. Ije meo mex nhym me imã axwe kêtja 'ã memã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ne mekmẽ kabẽno aben japanho ku'ê kêt. Ne memã àkjêro ku'ê kêt. Djãm kàj bê kabẽn nhym me kute prykôt õkre marmã? Kati. ");
INSERT INTO txuNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Me kaprĩre kute mrãmri ne bõti kajyr kaprĩre pyràk djãm kute meo bikẽnhmã? Kati. Dja memã tỳx jadjà nhym me kam arỳm kĩnh ne. Me kute amim imar rerekre kute mrãmri ne ngônhpôk nhõ kadjàtnhĩ kũm tyk ne akrax rerekreja pyràk. Djãm kute memã àkjêr nhym me 'ã ukangamã? Kati. Dja memã kabẽn mex jarẽ nhym me arỳm amim mar tỳx. Ne memã axweo àpanho tẽ:n kam arỳm meo mexkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nhym kam apỹnh me ba djàkam me bajtem arỳm tu amim markumrẽx.’ Nãm ã Metĩndjwỳnh memã ane.” Nãm ã Idjaij me bakukãmãremã ane nhym me arỳm aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm me bakamingrãnyrekam Jeju arỳm katon kam arỳm abatành ne ar ba. Ne kam arỳm memã prĩ mex ne memã kukràdjà jarẽnho ba. Idjaij kute me bakukãmãremã 'ã ujarẽnh kôt ne memã prĩ mex ne memã kukràdjà jarẽnho ban kam memã kum, —Dja gar ipudju. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nhym kam me karõ punu kute me'õo baja me arỳm 'ỳr o bôx. Me karõ kute o bakam ne no rãn kabẽn kêtkumrẽx. Nhym kam arỳm o mex nhym me aêrbê arỳm kabẽn ne rĩt mex. ");
INSERT INTO txuNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nhym me kunĩ kam no tyn abenmã kum, —Bãrãm mrãmri got we kubê Dawi tàmdjwỳkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nhym be, mebê pardjêu arỳm me kabẽn man arỳm abenmã kum, —Djãm Metĩndjwỳnh kukwakam ne Jeju bõm ar me karõ punu rẽnho ba? Kati. Me karõ punu nhõ bẽnjadjwỳrbê Bedjêbu. Bedjêbu kukwakam ne bõm ar me karõ punu rẽnho ba, ane. Xatanaj'ã ne me Bedjêbu jarẽn ã abenmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nhym kam Jeju tu me kadjwỳnhbê me kabẽn man memã kum, —Me karõ punu ne Xatanajmã àpênh ar ba. Djãm mrãmri ne ba we Xatanaj kukwakam õ àpênh kujaêko iba? Kati. Dja me aben djwỳnh tãm kum aben kurê nhym kurê djwỳnh arỳm meo apêx. Nàr, me õ krĩrax tãmkam nàr õ kikre tãmkam me krĩja godja me ja tãm kum aben kurê jabej mỳj dja me kam nẽ? Bir, kam dja me arỳm aben ngràn abenbê ajmà. Djãm mrãmri ne ba we Xatanaj kukwakam õ àpênh kujaêko iba? Kati. Djãm Xatanaj kum õ àpênh kurê? Kati. ");
INSERT INTO txuNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Be, Xatanaj ren kum õ àpênh kurên kujate nhym ren õ àpênh arỳm aben ngràn abenbê ajmà. Ren me abenbê ajmà nhym ren arỳm kubê me õ bẽnjadjwỳr kêt. Nhym be, kati. Xatanaj kum õ àpênh kurê prãm kêt. Ba ren we Xatanaj kukwakam õ àpênh kujate nhym ren Xatanajdjwỳ kum õ àpênh kurê. Nhym be, kati. Xatanaj kum õ àpênh kurê prãm kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ba ren Bedjêbu kabẽnkôt ren bõm ar me karõ punu rẽnho iba nhym ren mỳj kabẽnkôt ne anhõ àpênh bõm ar me karõ rẽnho ba? Me jadjwỳ ne me bõm me karõ punu rẽnho ba. Djãm me adjwỳnhdjwỳ ne me we Xatanaj kabẽnkôt ar bõm me karõ rẽnho ba? Ga me ren memã ja jarẽ nhym ren me amã, “Je tô djãm Xatanaj ta kute õ àpênho bikẽnho ba got”? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nhym be kati, Metĩndjwỳnh pyma puroobit ne ba ar bõm me karõ rẽnho iba. Ga, kôt arỳm Metĩndjwỳnh me awỳr bôxja pumũ. Metĩndjwỳnh kute me apytàr ne me akadjy bẽnjadjwỳr ne kute me ajo bamã me awỳr bôxja pumũ. Ja dja ga me ama. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ne kam memã kum, —Nàr, mỳj dja me me'õ tỳx nhũrkwãmã àr on? Kute kubê nêkrêxo prõt kadjy me'õ tỳx nhũrkwãmã àr on. Bir, dja me me'õo tỹm ne uwpre. Ne kam arỳm ũrkwãmã wadjàn kubê nêkrêxo prõt ne, ane. Mỳj'ã ne me'õ tỳx jarẽ? Bir, Xatanaj'ã. Dja me Xatanaj kumrẽx djuwpren kam arỳm amim õ me ja pytà. Ja'ã ne Jeju ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ne kam ajte memã kum, —Me'õ kum ikĩnh kêt ne arỳm mrãmri ijo kurê djwỳnh ne. Ne ar ikôt ba kêt ne arỳm kam amijã, “Ba dja ba ate ikrãn ar mrã. Amidjwỳnhbit dja ba amiman amijo mrã”, anen ate ar ba. ");
INSERT INTO txuNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kam ba me amã arẽ ga me ama. Me kute mỳjjao bikẽnh kunĩkôt Metĩndjwỳnh kute me axweo biknor prãm. Ne me kute Metĩndjwỳnh japrỳ kunĩkôt kute me axweo biknor prãm. Metĩndjwỳnh kute me axweo biknor ne wãnh mekam ngrykmã irer prãm. Nhym be, me kute Metĩndjwỳnh Karõ japrỳkambit ne Metĩndjwỳnh mekam ngryk rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Godja me'õ ijã kabẽn punu jarẽnh jabej ije amijo inhĩ'ã kabẽn punu jarẽnh jabej Metĩndjwỳnh dja axweo akno ne kam ngryk kêt. Nhym be, godja Karõ'ã kabẽn punu jarẽnh jabej Metĩndjwỳnh dja axweo biknor kêt ne. Ne kam kam ngryk rã'ã ne. Jakam dja ngryk rã'ã. Amrẽ akubyn Kra bôx'ã akati mõrkamdjwỳ dja kam ngryk rã'ã. ");
INSERT INTO txuNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Djãm pidjô punukam pidjô djành apôx got? Nàr kon, djãm pidjô mex, pidjô djànhjakam pidjô punu apôx got? Kati, apỹnh pidjô bàri djàri ne kam ô apôx. Ô ne parbê rôrôk ne ikwãn kam bàrio amirĩt nhym me kôt kum apôx. ");
INSERT INTO txuNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Me akamingrãnyre ne ga me abê iry. Me ajaxwekam djãm me aje akabẽn mex 'õ jarẽnh prãm? Arkati. Ẽ, me õkre kadjwỳnhbê ne me mỳjja kumex ma nhym kam amrẽ bõm ajkwa krekremẽ õto'ỳr apôx nhym me kam arẽnho ba. Arẽnho ban kam arỳm memã amijo amirĩt. Mex nàr axwe jao memã amijo amirĩt. Kute mỳjja ô kute pidjô bàrio amirĩt ja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nãm me õkre kadjwỳnhbê kabẽn punu kumex man arỳm kabẽn punuo memã amijo amirĩt. Nhym me ajte õkre kadjwỳnhbê kabẽn mex kumex man arỳm kabẽn mexo memã amijo amirĩt. ");
INSERT INTO txuNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ba me amã arẽ ga me ama. Amrẽ memã axwe pãnh jarẽnh djà nhõ akati mõrkam dja ga me amikôt Metĩndjwỳnhmã amijarẽ. Me aje amrẽbê akabẽn kajgo, akabẽn punu jarẽnh kunĩkôt kum arẽ nhym arỳm me ama. ");
INSERT INTO txuNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kam amrẽbê me akabẽn mex jabej dja akabẽn mex kôt me amã amex jarẽ. Nàr, amrẽbê akabẽn punu jabej dja akabẽn punu kôt me amã ajaxwe jarẽ ga me arỳm me biknor tokry djàkam akuno. Nãm ã Jeju me krãptĩmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nhym kam Môjdjê kukràdjà mar djwỳnhmẽ mebê pardjêu kwỳ Jejumã kum, —Ujarẽnh djwỳnh, dja ga mỳjja pumũnh kêt'õ nhipêx ba me omũn kôt ama, ane. Nhym memã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","—Me akamingrãnyre ne ga me ajaxwen mỳjjakôt ari Metĩndjwỳnhbê amijo akẽxo aba. Ga, me kwỳ kum prõ djwỳnh kĩnh ngriren kute ar mebê prõo àkĩnho baja pumũ. Me gadjwỳ ne ga me amã Metĩndjwỳnh kĩnh ngriren mỳjjakôt ari kubê amijo akẽxo aba. Ne ate kam ije me amã mỳjja pumũnh kêt nhipêxja'ã ijwỳro aba. Kati. Ije me amã ipêx ga me aje omũnh prãm kêtkumrẽx. Dja ba amijo kute Metĩndjwỳnh kukwakam ujarẽnh djwỳnhbê Djônaj pyràk. Tãm dja ga me omũn imã akator jabej. ");
INSERT INTO txuNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Me bakukãmãre Djônaj ne tep rax tikkrekam nõ nhym 'ã akatin akatin akati nhym arỳm kato. Badjwỳ dja ba ã amijo anen kẽnkrekam nõ nhym ijã akatin akatin akati ba arỳm ikato. Ba ne ba amijo inhĩ ne bôx. Dja ba ã amijo ane. Jabit dja ga me omũ. ");
INSERT INTO txuNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Djônaj ne krĩraxbê Niniwekam me akreo tẽ nhym me arỳm amikam kaprĩren wãnh axwemã iren Metĩndjwỳnh'ỳr amijo akẽx. Nhym be, ba ije iraxo Djônaj jakrenh mex ne ba jakam me akuri djan te me amã idjujarẽnh ar iba. Djã ne ga me me kudjwa amikam akaprĩn wãnh ajaxwemã anhiren Metĩndjwỳnh'ỳr amijo akẽx? Kati. Me aje wãnh ajaxwemã anhirer kêtkam dja Niniwekam me wã arỳm pãnh me amã ajaxwe jarẽ. Me akamingrãnymã arẽ ga me me biknor tokry djàkam akuno. ");
INSERT INTO txuNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Be ga, aparmã onĩ:j pyka 'õdjwỳkam bẽnjadjwỳr rax nija pumũ. Bẽnjadjwỳr ni Xaromão'ỳr tẽ:, 'ỳr tẽm 'iry:n arỳm 'ỳr bôx. Kute krã mexkôt marmã 'ỳr bôx ne arỳm kuma. Nhym be, ba ije iraxo Xaromão jakrenh me:x ne ba jakam me akuri djan te me amã idjujarẽnh ar iba. Djã ne ga bẽnjadjwỳr ni kudjwa ajamak mex ne ima? Kati. Ga me aje imar kêtkumrẽx. Me aje imar kêtkam dja bẽnjadjwỳr ni ĩ arỳm pãnh me amã ajaxwe jarẽ. Me akamingrãnymã arẽ ga me me biknor tokry djàkam akuno, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ne kam ajte me karõ punu'ã ajarẽn memã kum, —Me karõ pydjin kute ar me'õo baja ne arỳm kurũm katon tẽ. Ne kam te ar mrã, ngô kêtkam ar mrã, te ajte me'õmã àr ne tyk djà kêtmã ar mrã. ");
INSERT INTO txuNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ne kam amim, —Ba inhũrkwã kurũm ikatorja'ỳr tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ne kam amim badjà tũmja'ỳr tẽn 'ỳr bôx ne omũ nhym arỳm mexkumrẽx. Me karõ'õ kute o ba kêt nhym prĩne kre mex nhym arỳm kam mỳjja katàt. Nhym kam kadjy mã me karõ punu'ỳr tẽ. Ne kam mekam me kwỳ japrôn 'ỳr meo mõn meo bôx. Nãm me karõbê 7 ne o bôx ne me'õjamã meo wangij nhym kam mekam ar ba. Kute me karõ punubê 7 ne o bôx tãm ne axweo kute õbê pydji kute ar o ba tũmja jakrenh mex ne kam arỳm o punu rax ne. Kàjbê punuri ne kàjbê punu nhym be, kute kubê 7 ne o bôxja ne arỳm o punu rax ne. Dja ã me akamingrãnyre ajaxwekam me karõ punu me ajo ane, ane. Nãm Jeju ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jeju me krãptĩ:mã kabẽno dja nhym nãmẽ kamyre ar axikôt apôx ar bôx ne bõm ku'ê. Ne kute kum kabẽn jarẽnhmã. ");
INSERT INTO txuNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nhym me'õ 'ỳr tẽn kum, —Ẽ, onĩj anãmẽ akamy ar amã kabẽn, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nhym Jeju me'õmã kum, —Be, ije me'õmã inãmẽ ikamy jarẽnh kadjy mỳj dja arkam kute? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ne kam kôt ba djwỳnhmã kum, —Ota, inãmẽ ikamy ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dja gar Metĩndjwỳnho kĩnh kadjy kabẽn man kôt ar amijo aba. Ba kam arỳm ar amã ikamyre nàr ikanikwỳnh nàr inã jarẽ. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ne kam akati tãmkam Jeju kikre kurũm katon tẽn arỳm imôti mỳrri nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nhym kam me krãptĩ: 'ã akuprõ. Nhym kam arỳm mebê tẽn kàkam nhỹ nhym me krãptĩ: arỳm ngô mỳrri kum dja. ");
INSERT INTO txuNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nhym kam arỳm apỹnh kukràdjà djàri'ã memã mỳjja jakren memã 'ã ajarẽ. Ne memã kum, —Ẽ, õ pur djwỳnh ne kute õ purkam bàygogo kremã 'ỳr o tẽ. 'Ỳr o tẽn o bôx ne kam ar 'yo ukabêr mrã, ane. Nãm me kute mỳjja kre kadjy tu mỳjja 'yo akabê, bàygogo 'yja ne me kute purkam kremã o mrãn kam purkam o ukabêr mrã. Kute mrãmri ne me kute katẽbàri 'yo ukabêr mrãnhja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jeju memã kum, —Be, me'õ ne ar bàygogo 'yo ukabêr mrã. Nhym 'y kwỳ prykam rôrôk. Nhym kwênh prĩne kuku. ");
INSERT INTO txuNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nhym kwỳ kẽn po'ã pyka purorrekam rôrôk. Nhym kam pyka purorrekam ingrõt kukrà kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nhym kam kỳjrũm myt nhỹn arỳm 'y nhingrõt ga nhym kajot ne arỳm ty. Arê jabjê kêtkam ne ty. ");
INSERT INTO txuNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nhym 'y kwỳ mrỳnhĩkam rôrôk ne kam mrỳnhĩmẽ ro'ã ingrõt. Nhym kam prĩne o akno. ");
INSERT INTO txuNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nhym 'y kwỳ pyka mexkam rôrôk ne ingrõt ne kam abatành ne. Ne arỳm apỹnh bàri ku'ê djàri nhym kwỳ ijy jabjê nhym kam 'y mexti:re. Nhym kam 'y'ã akre kubê 100. Nhym kwỳ ijy mexkumrẽx nhym 'y'ã akre kubê 60. Nhym kwỳ kàjbê ijy mex nhym 'y'ã akre kubê 30. Nãm ã Jeju Metĩndjwỳnh kukràdjà'ã apỹnh mỳjja jakren 'ã ujarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ne ajte memã kum, —Gop me ajõ ar ajamak mex jabej tu amim ikabẽn markumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nhym kam kôt ba djwỳnh ar 'ỳr bôx ne kum, —Mỳkam ne ga apỹnh kukràdjà djàri'ã memã mỳjja jakren memã mỳjjabit'ã ajarẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nhym arkum, —Bir, djãm me kunĩ kute ikukràdjà marmã? Kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo ba'ã ikabẽn kukràdjà ja djãm me kunĩ kute marmã? Kati. Ar gajbit ije ar amã arẽnho amirĩt gar aje marmã. Nhym be, me wãbê ne ba udju ne. ");
INSERT INTO txuNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Be, me kwỳ kute ikukràdjà markumrẽx ja dja ba mã memã mỳjja krãptĩ jarẽ nhym me arỳm mỳjja krãptĩ ma. Nhym me kwỳ mã kute ikukràdjà mar kajgojabê dja ba ikukràdjào apdju. Kute ikukràdjà mar kajgojao apdju. ");
INSERT INTO txuNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Me wã kute mar kajgokam ne ba memã mỳjjabit 'ã ajarẽ. Ba apỹnh kukràdjà djàri'ã memã mỳjja jakren memã mỳjjabit'ã ajarẽ. Me kute ikukràdjà mar kajgo wã ne me amrẽbê: me bakukãmãremã arẽn memã kum, “Me te memã mỳjja jakre nhym me omũnh kajgon mã amim omũnhkumrẽx kêt. Nhym me te memã mỳjja jarẽ nhym me me kabẽn maro krĩn mã mar kêt. Mã mỳjja'ã me kabẽn kute amijakreja mar kêt ne.” Nãm me ã me wã'ã me bakukãmãremã ane. Me kute ikukràdjà mar kajgo'ã ne memã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Me bakukãmãre Idjaij ne amrẽbê: me kute imar kajgowãmã kabẽn jarẽ. Nãm Metĩndjwỳnh kukwakam memã kum, “Dja ga me maro aku'ên mã mar kêt. Mã kukràdjà'ã mỳjja kute amijakreja mar kêt. Ne omũnh kajgon mã amim omũnhkumrẽx kêt. Mỳkam? ");
INSERT INTO txuNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bir, arỳm ga me adjumar djàkam ajamakkre kêt. Me aje ajamako mar kêtmã ne ga me arỳm ajamakkre jaduj. Ne aje anoo omũnh kêtmã tu ano ngõr. Nã gãm me aje mar kêtmã ã ibê amijo ane. Aje ikukràdjà'ã mỳjja kute amijakreja mar kêtmã ã ibê amijo ane. Ne aje adjumar djàkam mar kêtmã ã ibê amijo ane. Me aje iwỳr amijo akẽx ba ije me ajo mex kêtmã ã ibê amijo ane.” Nãm ã me bakukãmãre Idjaij me kute ikabẽn mar kajgomã ane. Nhym me bakukãmãre aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm me wã'ỳr o bôx. Tũ:mràm me bakamingrãnyrekam ne me wã ã ikukràdjà mar kajgoo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nhym be, djãm ar ga ne gar ã anomẽ ajamako ane? Kati. Ar ga ne gar ano atemã ne aje omũnhkumrẽx. Ajamakkre ne atemã ne aje markumrẽx. Kam ar akĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ba ar amã arẽ gar ama. Djãm ar aje mỳjja pumũnh ja ne me bakukãmãre kute omũnh? Djã ne Metĩndjwỳnh kukwakam ujarẽnh djwỳnhmẽ me katàt kute amijo bamẽ kute omũnh? Kati. Djãm ar aje mỳjja mar ja ne me kute mar? Kati. Me krãptĩ ne amrẽbê te kute omũnh ne mar prãmje. Kam, ar gajbit ne gar aje omũnh ne aje mar. Mrãmri ne ba ar amã arẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kam ba ar amã arẽ gar ama. Ije ikabẽn kukràdjà'ã me'õ kute bàygogo 'yo ukabêr jakreja dja gar ama. ");
INSERT INTO txuNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kàjkwakam Bẽnjadjwỳr djwỳnh kabẽn ne me arỳm me'õmã arẽ. Metĩndjwỳnh kute amim me utàr ne kute ar meo ba'ã kabẽnja kum arẽ nhym arỳm mar kêt ne. Mỳj'ã kute kabẽn jakreja mar kêt ne. Nhym ate Xatanaj jãm meo amijakren mebê Metĩndjwỳnh kabẽno akno. Me kute tu amim markumrẽx nhym Metĩndjwỳnh kute kubê me utàr karõ ne jãm meo amijakren mebê Metĩndjwỳnh kabẽno akno. Bàygogo 'y kwỳ prykam rôrôk ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kẽnkam 'y rôrôk ja ne me kute amim Metĩndjwỳnh kabẽn mar 'iry kêt ne kangaja'ã amijakre. Nãm me myt tãmkam Metĩndjwỳnh kabẽn man bit kum kĩnhkumrẽxo tẽm kajgo. ");
INSERT INTO txuNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kute tu amim markumrẽx kêtê. Ajkwaobit ne kute mar. Kute 'y nhingrõt ne arê jabjê kêtkam tẽmbê tykja pyràk. Kute amim mar 'iry kêt nhym ate apỹnh me kaprĩ djàri 'ỳr bôx nhym arỳm kanga. ");
INSERT INTO txuNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mrỳnhĩkam 'y rôrôkja ne me kute Metĩndjwỳnh kabẽn mar ne kam ate ajte kute jãm mỳjja marja'ã amijakre. Nãm me arỳm Metĩndjwỳnh kabẽn man kam 'ãno ãm kêt ne amim, “Mỳj dja ba nẽn inhõ kwỳ krẽn mex ne inhõ kubẽkà mex? Ikanêkam mỳj dja ba nẽ”? ane. Nãm pykakam mỳjjabitkam ar no katon axwe umar. Ne kam amim pi'ôk kaprĩo atom rax prã:m ne ajte nêkrêxo atom rax prã:m. Djãm kute amim mỳjjao atom raxkam mrãmri umar mex? Kati. Bir, me arỳm õ mỳjja rũnhkam mrãmri umar punukumrẽx. Ga, mrỳnhĩ kute bàygogoo bikẽnh nhym kam ijy kêtja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ga, me'õ bàygogo 'yo ukabêr tẽ nhym ajte kwỳ pyka mexkam rôrôkja pumũ. Nhym kam arỳm ingrõt ne abatành ne. Abatành ne arỳm ijykam 'y kume:x. Me kwỳdjwỳ ne me memã Bẽnjadjwỳr djwỳnh'ã kabẽn jarẽ nhym me arỳm tu amim markumrẽx. Ne kam maro amũ amikamẽn arỳm mar rax ne. Mar rax ne arỳm ukaprĩkumrẽx. Me kwỳ ne me ukaprĩti:re kute mrãmri ne bàri kwỳkam ijy mexti:re nhym kam 'y kubê 100 pyràk. Nhym me kwỳ kàjbê ukaprĩ kute mrãmri ne bàri kwỳkam ijy mexkumrẽx nhym kam 'y kubê 60 pyràk. Nhym me kwỳ kàjbê ukaprĩ kryre kute mrãmri ne bàri kwỳkam ijy mex nhym kam 'y kubê 30 pyràk. Me ukaprĩkumrẽx nhym Metĩndjwỳnh arỳm mekam kĩnhkumrẽx. Mekam kaprĩre kêtkumrẽx. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ne kam Jeju ajte kabẽn kukràdjà'ã pur 'õdjwỳ jakren memã 'ã ajarẽn memã kum, —Kàjkwakam Bẽnjadjwỳr djwỳnh dja pykakam amim me kwỳ pytàn ar meo ba. Kam dja meo ajkij. 'Ã ne pur amijakre. Purkam ne me'õ 'y mex rẽnho tẽ. Ne o tẽ:n arỳm kre pa. ");
INSERT INTO txuNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ne kadjy ate krã. Nhym me õt mỳrri kurê djwỳnh arỳm pur'ỳr bôx. 'Ỳr bôx ne kam 'ê 'ymẽ bõ nhijymẽ akrô 'ymẽ rẽnho tẽ. Bàygogo 'y mex nhiby 'ê 'y rẽnho tẽ:n arỳm kre pa. Kre pan arỳm mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nhym kam bàygogo ingrõt ne abatành ne ijy ajkapĩ. Nhym 'êdjwỳ arỳm kam kume:x ne. ");
INSERT INTO txuNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nhym kam õ àpênh ar arỳm õ pur djwỳnh'ỳr bôx ne kum, “Bẽnjadjwỳr, 'y mexbit ne ga purkam arẽn kre. Mỳj ne arỳm ajmã pur kam nẽ nhym kam 'ê kume:x”? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nhym arkum, “Gwaj bakurê djwỳnh'õ ne kam 'ê 'y rẽ”, ane. Nhym õ àpênh ar kum, “Dja bar 'ê kaba”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nhym arkum, “Kati. Gar ren 'êmẽ ro'ã bàygogo kaba. ");
INSERT INTO txuNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kwãrĩk wãnh ro'ã abatành gê prỳ ngrà ba 'ỳr ê djwỳnh jano. Kam dja ba ê djwỳnh arkum, ‘Dja gar 'ê kumrẽx karwàn 'ãpren kum adjà gê xêr. Nhym be, bàygogo dja gar o atom ne inhõ bàygogo nhõ kikremã o wadjàn adjwỳ’, ane. Dja ba ã kum ane.” Nãm ã õ pur djwỳnh arkum ane. Nãm ã Jeju memã ujarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ne kam ajte kabẽn kukràdjà'ã motadu 'y jakren memã kum, —Kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo ba ne kute mrãmri ne me'õ arỳm õ purkam motadu 'y kre nhym abatành pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Motadu 'y ne kryreo kute apỹnh 'y jakrenh. Nhym be, arỳm abatànhkam abatànho kute purkam djwỳ kunĩ jakrenh. Arỳm abatành kute pĩ pyràk. Nhym arỳm àkmẽ kwênh apỹnh pa'ã ku'ê. Nãm ã Jeju arkum ane. Me kute amim Jeju marmã nhym arỳm ja pydjin kadjy amima nhym arỳm ja kadjy amiman 'ã tỹm nhym ja kôt 'ã tỹm nhym ja 'ã tỹm nhym arỳm 'ã krãptĩ ne. 'Ã ne 'y kryre ja jakre. ");
INSERT INTO txuNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ne kam ajte kabẽn kukràdjà'ã djwỳ nhigot djà jakren memã kum, —Kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo ba ne kute mrãmri ne djwỳ nhigot djà djwỳkam bimành tẽm pyràk. Me'õ nire ne djwỳ nhigot djà byn arỳm djwỳ djôm raxkam kapĩ. Djwỳ'ã akreo amãnhkrut ne ikjêkêt. Nãm djwỳkam kapĩn o akà nhym arỳm prĩne djwỳkam ajmà, ane. Jejudjwỳ dja amim me utàro tẽn kam arỳm pyka kunĩkôt amim me kwỳ pytàn ar meo ba. ");
INSERT INTO txuNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jeju kute memã mỳjja'ã ujarẽnhja kunĩ ne kukràdjà'ã akre. Ne kam me krãptĩ:jamã mỳjjabit'ã ajarẽ. Djãm kute kukràdjà 'õ'ã mỳjja jakre kêt ne tu kukràdjàbit memã arẽ? Kati. Nãm kukràdjà'ã memã mỳjjabit jakren memã 'ã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Me bakukãmãre ne Metĩndjwỳnh kukwakam memã ja'ã ajarẽ. Jeju memã ujarẽnh ja'ã ajarẽ. Amrẽbê: ne memã kum, “Kukràdjà'ã dja ba memã mỳjjabit jakren memã 'ã ajarẽ. Adjàkam mỳjja bipdjur ne bipdjur rã'ã dja ba arỳm 'ã ajarẽ”, ane. Nãm ã me bakukãmãre Metĩndjwỳnh kukwakam memã ane. Ne kam me aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm me bakamingrãnyrekam ne Jeju katon arỳm ã memã ujarẽnho ane. Me bakukãmãre kute memã ujarẽnh kôt ne Jeju arỳm amikabẽn kukràdjà'ã mỳjjabit jakren memã mỳjjabit 'ã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ne kam arỳm me krãptĩ jano nhym me mã mõ nhym arỳm kikremã wadjà. Nhym kôt ba djwỳnh ar arỳm 'ỳr bôx ne kukijn kum, —Ajbir me kute purkam bàygogo 'y mex nhiby 'ê 'y rẽnho tẽm'ã adjujarẽnhja mỳj'ã ne amijakre? Ar imã arẽ bar kuma, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nhym arkum, —Bir, ba ne ba amijo inhĩ ne ruw. Ba ijã ne me'õ kute purkam 'y mex rẽnh ja. Ijã ne me'õja amijakre. ");
INSERT INTO txuNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pyka kunĩkôt me kunĩ'ã ne pur amijakre. Me kute Bẽnjadjwỳr djwỳnh mar'ã ne 'y mex amijakre. Me kute Xatanaj kôt ar amijo baja'ã ne 'ê amijakre. ");
INSERT INTO txuNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Xatanaj'ã ne kurê djwỳnh kute purkam 'ê 'y rẽnhja amijakre. Mỳjja kunĩ kute aminhinomã amimẽnh djà nhõ akati'ã ne bàygogoo atom djà nhõ akati amijakre. Metĩndjwỳnh kadjy mrãnh djwỳnh'ã ne me kute bàygogo djê djwỳnhja amijakre. ");
INSERT INTO txuNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kute ê djwỳnh kute 'ê jarênh ne o atom ne kum adjàr nhym xêt pyràk, dja Metĩndjwỳnh kadjy mrãnh djwỳnh ã me axweo ane. Me kute aminhinomã amimẽnh djà nhõ akatikam me axweo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ba ije amijo inhĩ dja ba amũ ikadjy mrãnh djwỳnh jano nhym me arỳm me axwe kunĩo atom. Bẽnjadjwỳr djwỳnh kute pykakam meo bajakam me axwe kunĩo atom. Me kute me axwe'ã memã àpnênhmẽ me axwe kunĩo atom. ");
INSERT INTO txuNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ne kam me arỳm me biknor tokry djàkam me kumẽ. Wãnh ne me amim ngryk ne tokry djàje amijanên ar àmra ba. ");
INSERT INTO txuNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kam dja me Bãm djwỳnh amim me katàt kute amijo baja pytàn ar meo ba. Nhym kam me axweja kuràm dja me arỳm me:xkumrẽx nhym me kum me kĩ:nhkumrẽx kute mrãmri ne arỳm myt katorkam me kum kĩnh pyràk. Gop me ajõ ar ajamak mex jabej tu amim ikabẽnja markumrẽx. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ne kam ajte arkum, —Kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo ba ne me kum kĩnh. Kute mrãmri ne kute me kum nêkrêx pãnh rax kĩnh pyràk. 'Ã ne nêkrêx pãnh rax amijakre. Pykakam ne me'õ nêkrêx pãnh rax jadjàn o apdju nhym atemã me'õja arỳm 'ỳr bôx ne kum katon kaban kam kĩnhkumrẽx. Me'õja nêkrêx pãnh raxkam kĩnhkumrẽx ne ajte pyka tãmkam nêkrêx pãnh rax jadjàn o apdju. Me'õ kute kubê o àkĩnh karõ o apdju. Ne amim, “Ba on pykao inhõn kam ije nêkrêx pãnh rax jadjàr djào inhõ pyka”, ane. Ne kam arỳm õ mỳjja kunĩo atom ne memã kungãn pãnh pi'ôk kaprĩ by. Ne kam arỳm pi'ôk kaprĩo amim pyka byn o õ. Ne urokam kute kam nêkrêx pãnh rax jadjàrjao õ. ");
INSERT INTO txuNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kam, ajte kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo ba ne me kum kĩnh. Kute mrãmri ne kute me kum nêkrêx pãnh rax kĩnh pyràk. 'Ã ne angà pãnh raxdjwỳ amijakre. Kam ne me'õ kute angà byrmã abej ar mrã. ");
INSERT INTO txuNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ne kam arỳm angàja pãnh ra:xmã kato. Ne amim, “Ba on angà pãnh raxjao aminhõ”, ane. Ne kam amũ tẽn õ mỳjja kunĩo atom ne memã kungãn pãnh pi'ôk kaprĩ by. Ne kam angàja pãnh rax pãnh memã pi'ôk kaprĩ ngãn arỳm o õ. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ne kam ajte arkum, —Kàjkwakam Bẽnjadjwỳr djwỳnh dja pykakam amim me utàn ar meo ba. Kam, dja me axwemã pãnh jarẽ. 'Ã ne kryreti amijakre. Imôtikam ne me kryreti mẽ nhym arỳm apỹnh tep krãptĩ kum wangij nhym me arỳm unê. ");
INSERT INTO txuNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ne arỳm ipukam bjêro mõn akàx'ã kumẽ. Ne kam arỳm tep kabio nhỹ. Nãm tep mex ne karwàn kaxnokaikam o atom. Nhym be, tep punu ne me rũm kurẽn kanga. ");
INSERT INTO txuNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mỳjja kunĩ kute aminhinomã amimẽnh djà nhõ akatikam dja me ã meo ane. Dja Metĩndjwỳnh kadjy mrãnh djwỳnh apôx ne me'ỳr bôx ne meo ajkij. Me axweja me katàt kute amijo bajabê meo ajkij. ");
INSERT INTO txuNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ne kam arỳm kuwy djàkam me axwe mẽ. Kam dja me amim ngryk ne tokry djàje amijanên ar àmra ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ne kam arkum, —Djã ne gar arỳm mỳjja markumrẽx? Mỳjja'ã ije apỹnh mỳjja jakreja djã ne gar arỳm markumrẽx? ane. Nhym ar kum, —Nà. Mỳjja'ã apỹnh mỳjja kute amijakreja bar ije markumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nhym kam arkum, —Aj, tãm ne ja. Arỳm ne ba mỳjja krãptĩ'ã ajarẽ gar ama. Kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàrn ar meo ba'ã ne ba mỳjja krãptĩ jakren ar amã 'ã ajarẽ gar arỳm ama. Arỳm ar aje markam ar aje õ kikre djwỳnh pyràk. Õ kikre djwỳnh ne õ nêkrêx jadjwỳr djàkam mỳjja nymẽ mỳjja tũmo pôx. Ar aje uràk. Ar abê memã kukràdjà jarẽnh djwỳnh ne gar arỳm memã kukràdjà ny jarẽn ajte memã kukràdjà tũm jarẽ. Tãm ne ja. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jeju apỹnh kukràdjà'ã memã mỳjja ja jakren memã 'ã ajarẽn kam arỳm o ino re. Ne kam arỳm mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ne kam arỳm õ pyka djwỳnhkam tẽn bôx. Bôx ne arỳm me bikprõnh djàkam tẽn wadjà. Ne kam arỳm memã kukràdjà jarẽ. Memã arẽ nhym me arỳm kam no tyn kumex ne abenmã kum, —Tô, mỳj me'õ ne kum me kukràdjà ja jarẽ nhym arỳm ã amak mexo ane. Mỳj me'õ ne kum arẽ nhym arỳm ã mỳjja nhipêxo ane. Mỳjja pumũnh kêtkumrẽx ne arỳm ipêx nhym kumex. ");
INSERT INTO txuNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Be, kubê ne pĩ kênh djwỳnh kajgo kra. Marij kurũm ne kato. Kôt ar apôxjabê Xijagumẽ Jôdjemẽ Ximãomẽ Djudamẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kanikwỳnhdjwỳ ar me baro'ã ar ba. Tô mỳj me'õ ne kum kukràdjà ja jarẽ nhym maro ba? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Me ã abenmã anhỹro ban kam kubê kĩnh no kati. Nhym Jeju amijã memã kum, —Metĩndjwỳnh kukwakam memã ujarẽnh djwỳnh dja pyka kunĩkôt ba nhym me kum mex jarẽnho ba prãm ne. Nhym be, õ pyka djwỳnhkam me jabit ne me ari aprỳo ba. Õbikwa djwỳnhkam ar ajbit dja me ari aprỳo ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ne kam arỳm te kute õ pyka djwỳnhkam me krãptĩo mex prãmje. Me kute amim tu kamnhĩxkumrẽx kêtkam te kute meo mex prãmje. ");
INSERT INTO txuNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nhym kam me amũ Jeju jarẽnho ipôk ne. Nhym kam mebê idjaer nhõ bẽnjadjwỳr raxbê Erodji arỳm me kute Jeju jarẽnhja ma. ");
INSERT INTO txuNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ne kam arĩk Jejuo Djuão ne õ àpênhmã kum, —Ngômã me angjênh djwỳnhbê Djuão arỳm akubyn tĩn ne ar ba. Be, tyk ne akubyn tĩnkam ne arỳm mỳjja pumũnh kêt nhipêxo ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Be, Erodji kute bĩn kêtri ne Djuão Erodjij'ã kum kabẽn ne. Erodji ne Erodjijo prõ. Nãm 'ã kum kabẽn ne kum, —Metĩndjwỳnh kukràdjà kupa'ã ne ga akamyrebê prõ'ỳr mõ, ane. Nhym kuman arỳm ngryk ne. Ne arỳm 'ỳr me krãkamngônh jano nhym me arỳm o tỹm ne kubê ijê. ");
INSERT INTO txuNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nhym kam bit kute me anor nhym me kute bĩnmã. Nhym be, kati. Me krãptĩ: ne me 'ã abenmã kum, —Djuãobê ne Metĩndjwỳnh kukwakam memã ujarẽnh djwỳnh, ane. Me krãptĩ kute ã anhỹrkam ne Erodji arỳm kum me krãptĩ pyman Djuão bĩn kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nhym kam Erodji rwỳk djà nhõ akati arỳm bôx. Bôx nhym me arỳm ro'ã àkuro nhỹ. Nhym Erodjij kra arỳm memã to. Memã to nhym Erodji kum kĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kum kĩnhkam ne kum, —Mỳj ne ga amã kĩnh? On imã mỳjja'õ jarẽ ba arỳm amã kungã. Amã ikabẽn kajgo kêtkumrẽx. Metĩndjwỳnh ne arỳm ima, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kraja kum tor djwỳnhràm ne nã arỳm Djuão krã'ã kum karõn kum, —Dja kum akĩnh ga Djuão krã'ã kum apnê, ane. Nhym kam arỳm kum to nhym kum kĩnh. Kum kĩnh ne kum mỳjja jarẽnh mãmdji nhym arỳm kuma. Ne nã kabẽn man arỳm Erodjimã kum, —Dja ga ngômã me angjênh djwỳnhbê Djuãoja ngônh purortikam krã djàn o bôx ne imã angã, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nhym kam bẽnjadjwỳr rax arỳm kuman kaprĩren amim, —Je, arỳm ne ba mrãmri kum ikabẽn jarẽnh mãmdji nhym Metĩndjwỳnh arỳm ima. Ba arỳm kam te ije kum, “Kati”, anhỹr prãmje. Ibu'ã me jadjwỳ ne me arỳm mrãmri ikabẽnkumrẽx ma, ane. Ne kam arỳm õ àpênhmã kum, “Me kum angã”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ne 'ỳr me ano nhym me mebê ijê djà'ỳr mõn arỳm 'ỳr bôx. Ne kam arỳm mut krãta. ");
INSERT INTO txuNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mut krãtan ngônh purortikam krã djàn o tẽn arỳm kurerermã kungã. Nhym kumỳn o tẽn arỳm nãmã kungã. ");
INSERT INTO txuNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nhym kam Djuãokôt ba djwỳnh ar 'ỳr tẽn 'ỳr bôx. Ne kam Djuão nhĩ mỳn o tẽn arỳm adjà. Ne kam Jeju'ỳr tẽn 'ỳr bôx ne kum arẽ nhym arỳm kuma. ");
INSERT INTO txuNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nhym kam ate arwãkam ỹr kadjy kàkam nhỹn arỳm nox ne. Nhym kam me arỳm arẽnh ma. Arẽnh man arỳm krĩrax kurũm kôt mõ. Pykakôt ar ibej mõ. Ar ibej mõ:n arỳm akàx nhikjêkam Jeju kutêp akuprõ. ");
INSERT INTO txuNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nhym Jeju ar ngôkôt mõn arỳm akàx'ỳr bôx. 'Ỳr bôx ne arỳm kà dji. Nhym kam Jeju arỳm wabin me krãptĩ: pumũ. Me omũn arỳm kum me kaprĩ:. Kum me kaprĩn arỳm me kanêo mexo dja. ");
INSERT INTO txuNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Meo djan kam arỳm amykry mex ne. Nhym Jeju kôt ba djwỳnh arỳm 'ỳr bôx ne kum, —Arwãkam ne gwaj ar baba nhym arỳm amykry mex ne. On me krãptĩmã arẽn kum, “Me amũ krĩ kryremã mõn djwỳ jamỳn anhõ kwỳ krẽ”, ane. Dja ga ã memã ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nhym arkum, —Kati. Kwãrĩk wãnh amũ me mõr kêt. Ar ga dja gar memã mỳjja ngã nhym me arỳm kukrẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nhym ar kum, —Jakam ne djwỳ kubê 5bit ne tep amãnhkrutbit, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nhym arkum, “Amrẽ imã o tẽ”, ane. Nhym kam ar arỳm 'ỳr o bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nhym kam me bõkam ỹrmã memã arẽ. Ne kam arỳm djwỳ kubê 5mẽ tep amãnhkrutja jamỳ. Amỳn kàjmã kàjkwa pumũn djwỳmẽ tepo Metĩndjwỳnhmã amikĩnh jarẽ. Kum amikĩnh jarẽn arỳm djwỳ kokij. Djwỳ kokjêro dja:n mã kôt ba djwỳnh arkum õro dja. Arkum õro dja: nhym ar mã memã õro mrã. ");
INSERT INTO txuNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Memã õro mrã: nhym kam me kunĩ kukrẽn arỳm ajne. Nhym kam ar arỳm aũm karwànho mrã. O mrãn arỳm kaxnokaikam kungij ne o ipu. O ipun arỳm 'ã akre. Kam kaxnokai ipu kubê 12 ne 'ã kàtàm ne dja. ");
INSERT INTO txuNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Be, me my kute krẽn 'ã akre kubê 5.000. Ne ijukri me niremẽ me prĩre'ã akre kêt. Be, me kunĩ ne me arỳm õ kwỳ krẽn mex ne arỳm ajne. ");
INSERT INTO txuNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nhym kam Jeju kôt ba djwỳnh arkum, —Aj mã, kàkam nhỹ. Dja gar ikukãm akàx nhikjêmã rê. Ba 'ỳr me ano gê me mã mõ, ane. Nhym ar arỳm kàkam nox ne mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nhym arỳm me krãptĩ'ỳr tẽn memã kum, —Aje, me on ajmà. Ba on, ane. Ne kam Metĩndjwỳnhmã kabẽn kadjy krãnh'ã tẽn wabi. Nhym kam arỳm akamàt nhym ate krãnhkam nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nhym ar kàkam mõrja arỳm imôti nhipôkri mõ. Mõ: nhym kôk ar kutã àbêr tỳx. Àbêr tỳx nhym ngô arỳm ar'ã kà japĩno mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Apĩno mõ: nhym arỳm õkrẽn'ãnh kà. Õkrẽn'ãnh kàr pydji nhym Jeju arỳm tu ngô rax'ã arkôt tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ngô'ã arkôt tẽ nhym kôt ba djwỳnh ar arỳm omũ. Ngô'ã tẽmkôt omũn arỳm madjà kretin abenmã kum, —Ota amrẽ me karõ'õ gwaj bakôt mõ, anen arỳm umaje amra. ");
INSERT INTO txuNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nhym kam arkum, —E kum, ba ne ba wãm ar akôt tẽ. On ar akĩnh ne ar atĩn prãm kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nhym Pedru kum, —Djãm mrãmri gakumrẽx? Ga atẽmkumrẽx jabej amiwỳr ijwỳ ba wãm akudjwa ngô'ã awỳr tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nhym kum, “Amrẽ iwỳr tẽ”, ane. Nhym Pedru arỳm Jeju'ỳr tẽmmã ngôkam ruw ne arỳm ngô'ã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngô'ã tẽn arỳm ngô pumũ. Kôk djàbêr tỳx kute ngô djàkà tỳxkôt omũn arỳm tĩn prãm. Tĩn prãm ne arỳm àr tẽ. Ngômã àr tẽn arỳm amran kum, “Bẽnjadjwỳr djwỳnh, gop ipytà”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nhym Jeju on pa 'amỳn kum, —Aje amim imar rere:kre. Mỳkam ne ga amim, “Djãm mrãmri ne Jeju kute ngô ja mar”, anen amim imar rerekre? ");
INSERT INTO txuNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nãm ã kum ane nhym ar arỳm kà'ỳr bôx. Ne kam arỳm wabi. Wabi nhym kôk djàbêr on amikrãtan anhikrê ne. ");
INSERT INTO txuNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Amikrãta nhym kàkam ar ỹrja arỳm parbê kõnkrão nhỹn rax ma:ro nhỹ. Ne arỳm kum, —Mrãmri abê Metĩndjwỳnh Krakumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ne kam ar arỳm akàx nhikjêmã rên kam arỳm kà dji. Ar pykabê Djene'ã kà dji. ");
INSERT INTO txuNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nhym kam me arỳm Jeju nokre pumũn amũ memã arẽ. Nhym kam me arỳm bu'ã pyka kunĩkôt me'ỳr me ano nhym me me'ỳr mõ. Me'ỳr mõn memã arẽ nhym me arỳm kuman Jeju'ỳr me punu kunĩo bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nhym me arỳm kum, —Ba me akà japkrebit kupên arỳm imex ne, ane. Ne me kunĩ kute kupênhja arỳm prĩne mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nhym kam mebê pardjêumẽ Môjdjê kukràdjà mar djwỳnh krĩraxbê Djeruxarẽ kurũm mõn Jeju'ỳr bôx. Me õ kwỳ krẽn kadjy ne me aminhikra põnho ba. Me kukãmãkjê kukràdjà kôt me we Metĩndjwỳnhmã mex kadjy ne me kum aminhikra põnho ba. 'Ã ne me Jejumã kabẽn ne kum, ");
INSERT INTO txuNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Mỳkam ne akôt ba djwỳnh ar me kukãmãkjê kukràdjà mar kêt ne kam amikrà ar o ba? Nãm ar kute aminhikra põnh kêt ne tu aku, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nhym Jeju memã kum, —Djãm mrãmri Metĩndjwỳnh kukràdjà kôt ne ga me me akukãmãkjê kukràdjàja jarẽ? Kati. Atemã. Ga me atemã akukãmãkjê kukràdjà ja'ã ano tỳx ne Metĩndjwỳnh kukràdjà mar kêt. Ne kam arỳm kam amikrà ar o aba. ");
INSERT INTO txuNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ba me amã arẽ gar ama. Metĩndjwỳnh ne me bakukãmãremã 'ã karõn memã kum, “Me amã abãmmẽ anã jabên ar kabẽn ma”, ane. Ne ajte memã kum, “Me'õ arỳm bãm'ã nàr nã'ã, ‘Gê Metĩndjwỳnh o ajkẽ’, anhỹr jabej gê me tu kubĩ”, ane. Me kum bãmmẽ nã ar abêmã ne Metĩndjwỳnh ã me bakukãmãremã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nhym be, djãm me ga ne ga me amã abãmmẽ anã jabê? Kati. Ga me akukràdjà kôt arĩk memã kum, “Me ajõ godja anã nàr abãm mỳjja'ã ajwỳr jabej. Ne aje kubê anhõ mỳjja nê prãm jabej kum, ‘Be, ba te ije amã õrmã. Aje mỳjja 'ã ijwỳr ba arỳm o Metĩndjwỳnh nhõ mỳjja. Kam ba te ije amã õrmã’, ane. Dja ga me ã kum anen arỳm kubê nê nhym kam arỳm pijàm ne”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ga me aje ã memã 'ã karõo anhỹrkam arỳm me nãmẽ bãmbê õdjỳ'ã memã adjàpnênho aba. Me kum ar abê kêt'ã memã adjàpnênho aba. Metĩndjwỳnh te memã 'ã karõn memã kum, “Me amã abãmmẽ anã jabên ar kabẽn ma”, ane. Nãm te memã ane ga me arỳm Metĩndjwỳnh kabẽn jao me kukràdjà kajgon kupa'ã memã akukràdjà punu ja jarẽn arỳm nãmẽ bãmbê õdjỳ'ã memã adjàpnênho aba. ");
INSERT INTO txuNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Me ga ne ga me amijo ajêx ne ar amijo Metĩndjwỳnh mar mexo aba. Mrãmri ne me bakukãmãre Idjaij me ajã kabẽn ne. Nãm Metĩndjwỳnh kukwakam me ajã me bakukãmãremã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Be, me ja ne me arĩk 'êx ne ajkwa kajgokam imã imex jarẽnho ban õkre kadjwỳnhbê jãm ate ibê krãn ba. ");
INSERT INTO txuNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ne arĩk imã irax jarẽnh kajgoo ban 'êx ne me ta kukràdjà'ã memã kum, ‘Metĩndjwỳnh kukràdjà’, anhỹro ba.” Nãm ã Idjaij me ajã ane ga me akamingrãnyre ajêx ne akukràdjà kajgoo Metĩndjwỳnh kukràdjàn memã arẽnho aba. Mrãmri ne me ajã arẽnhkumrẽx. Nãm Jeju ã mebê pardjêu arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ne kam amiwỳr me krãptĩ 'uw ne memã kum, —Ẽ, dja ga me akunĩ iman ikabẽn markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Me kute apỹnh mỳjja'ã memã kum, “Ja dja ga ãm omũ. Dja ga krẽn arỳm ajaxwe”, anhỹro ba. Nhym be, djãm me'õ mỳjja 'õ krẽ nhym Metĩndjwỳnh arỳm kum, “Ja ne ga krẽ. Arỳm ajaxwe”, ane? Kati. Me kabẽn punukam ne memã axwe jarẽ. Me àkĩnhĩkam ne memã arẽ. Me ari prõ, mjên kupa'ã kurẽ bakam ne memã arẽ. Me 'êxnhĩkam ne memã arẽ. Apỹnh axwe 'õkam ne Metĩndjwỳnh memã axwe jarẽ. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kam kôt ba djwỳnh ar 'ỳr bôx ne Jejumã kum, —Ẽ, mebê pardjêu kute akabẽn markam arỳm ngryk ne, ane. Nhym me'ã arkum, ");
INSERT INTO txuNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","—Ga, me no rã ne me amikukãm rĩt kêtja pumũ. Kam me kute amipry mar kêt. Kam godja me no rã me no rã japrô kute meo ba jabej nhym arỳm amẽ kre'õkam tỹm. Mebê pardjêu ne me kute me uràk. Nãm me 'êx ne memã, “Ba ne ba ije Metĩndjwỳnh mar”, anhỹro ba. Nhym be, kati. Me kute mar kêt. Ne kam te memã Metĩndjwỳnh'ã ujarẽnh ar ba nhym me adjwỳnhdjwỳ kute Metĩndjwỳnh mar kêt. Mebê pardjêu 'êx ne kute memã anhỹro bakam dja Ibãm arỳm memã o pãnh ne me biknor tokry djàkam me kumẽ kute mrãmri ne me kute 'ê kadjàr ne rũm mẽnh pyràk. Kwãrĩk wãnh me rã'ã. Nãm ã Jeju mebê pardjêu'ã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nhym Pedru kum, —Nã gãm ar imã, “Djãm me mỳjja 'õ krẽ nhym Metĩndjwỳnh kum, ‘Ja ne ga krẽn arỳm ajaxwe’, ane? Kati”, ane. Tãm ne ga arẽ nhym ar ibê bipdjur rã'ã ne. Mỳj'ã ne ga akabẽn jarẽ? Ar imã arẽ bar kuma. Nãm ã Pedru Jejumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nhym Jeju arkum, —Djãm ar gadjwỳ ar aje mỳjja mar kêt rã'ã? ");
INSERT INTO txuNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mỳjja me kute krẽn ne me tikkambit wangij. Ne kam atykmã arỳm apôx. ");
INSERT INTO txuNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nhym be, me ajkwa kurũm me kabẽn punu apôxja ne me kute amim mỳjja'ã karõ djà kurũm apôx. Kam Metĩndjwỳnh arỳm memã axwe jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Me kute amim mỳjja'ã karõ djàkam amim mỳjja punu'ã karõn arỳm me kurũm apôx. Nãm me kute me par'ã amim karõ. Ne kute me prõ puro nàr me mjên puroo àkĩnh ne ro'ã ikwãja'ã amim karõ. Ne prõ djwỳnh nàr mjên djwỳnh kupa'ã kurẽ'ã amim karõ. Ne kute mỳjjao àkĩnh'ã amim karõ. Ne memã 'êx'ã amim karõ. Ne kute Metĩndjwỳnh japrỳ'ã amim karõ. ");
INSERT INTO txuNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Me axweja kunĩ ne me kurũm apôx nhym Metĩndjwỳnh arỳm memã axwe jarẽ. Nhym be, me kute aminhikra põnh kêt ne kute õ kwỳ krẽn ja ne Metĩndjwỳnh kute memã axwe jarẽnh kêt. Djãm ar aje ja mar kêt? Nãm ã Jeju kôt ba djwỳnh arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ne kam Jeju arỳm mebê tẽ. Tẽ:n kam krĩraxbê Xirumẽ Xidõ bu'ã pyka'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nhym pykabê Kanaãkam me'õ nire pyka wãkam ar ba. Mebê idjaer ne me wão me bajtem. Me'õ nire kam ar ban arỳm Jeju'ỳr bôx. Ne kam kàj bê kum, —Bẽnjadjwỳr djwỳnh, Dawi tàmdjwỳ, gop amã ikaprĩ. Me karõ punu ne ari ikrao bikẽnho ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nhym tu kubê anhikrên itõ ne. Nhym kôt ba djwỳnh ar 'ỳr bôx ne kum, —Dja ga amũ ano gê tẽ. Nãm ari gwaj bakôt àmra tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nhym arkum, —Djãm me bajtem'ỳr ne Metĩndjwỳnh ijano ba tẽ? Kati. Mebê idjaer'ỳr ne ijano ba tẽ. Mebê idjaer ne me kute mrãmri ne mrykĩ'ãtomti no biknor pyràk ne ate ar ba. Me ate ar ba ja'ỳr ne ijano ba tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nhym kam arỳm ni bajtemja 'ỳr bôx. 'Ỳr bôx ne arỳm parbê kõnkrão nhỹn ra:x man kum, —Bẽnjadjwỳr djwỳnh gop ikôt o kangõn ikrao mex, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nhym õ mebê idjaer'ã me prĩre jakren kum, —Nok ba ren rop kraremã me prĩre nhõ djwỳ rẽ nhym ren kam punure, ane. Djãm mrãmri ne djwỳ'ã ajarẽ? Kati. Kute meo mex djà'ã ne djwỳ jakren kum 'ã ajarẽ. Bir, Jeju ne jakam kute me bajtemo mex prãm kêt. Õ mebê idjaer'ỳr ne Metĩndjwỳnh Jeju jano. Kute õ mebê idjaerbit kumrẽxo mexo bamã. Kam ne nimã kum, —Nok ba ren rop kraremã me prĩre nhõ djwỳ rẽ nhym ren kam punure, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nhym nija arỳm amim, —Ijã ne rop krare jarẽ, anen arỳm kum, —Tukwa, mrãmri Bẽnjadjwỳr djwỳnh. Kôt ne ga arẽ. Nhym be, godja wãnh õ wỳnh nhõ pĩponh krakri djwỳ jaũm rôrôk. Aũmbit dja rop krare kukrẽ. Kam gop badjwỳ ibê rop krare pyràk tu imã ikrao mex, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nhym Jeju kum, —Me'õ nire, ga ne ga tu amim ikamnhĩx me:xkumrẽx. Akabẽn kôt ne ba arỳm akrao mex, ane. Nhym myt tãmkam kra arỳm mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nhym kam Jeju arỳm pyka ja kurũm tẽn imôtibê Garrêja'ỳr tẽn 'ỳr bôx. Ne kam arỳm krãnh'ã tẽn wabin nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nhym me krãptĩ: arỳm 'ỳr bôx. Nãm me 'ỳr me punuo mõn 'ỳr meo bôx. Me mrãnh kêtmẽ me no rãmẽ me kabẽn kêtmẽ apỹnh me kukràdjà punumẽ apỹnh me punu djà 'õdjwỳ krãptĩ:ja ne me 'ỳr meo mõn meo bôx ne Jeju parbê me adju:w nhym arỳm meo mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jeju meo mex nhym me krãptĩ: arỳm me omũ. Me kabẽn kêt arỳm kabẽn mex. Me apỹnh kukràdjà punu arỳm kukràdjà mex ne. Me mrãnh kêt arỳm mrãnh mex ne. Me no rã arỳm rĩt mex ne. Nhym me arỳm me omũn te kute marmã mekam no tyn kumex. Ne kam arỳm mebê idjaero ba djwỳnhmã rax jarẽ. Metĩndjwỳnhmã rax jarẽnho kume:x. ");
INSERT INTO txuNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nhym kam arỳm amiwỳr kôt ba djwỳnh ar ku'uw nhym ar bôx nhym arkum, —Imã me krãptĩ:ja kaprĩ. Me iro'ã krĩ'ã arỳm akati amãnhkrut ne ikjêkêt apêx. Ne kam arỳm me õ mỳjja kêt. Nok ba ren me kum prãmkam ren amũ me ũrkwãmã me ano nhym ren pry konenh ren me arỳm rerekre nhym ren tyk djà me kupa, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nhym kôt ba djwỳnh ar kum, —Kapôt kukrit jakam ne gwaj te me krãptĩ:ja kadjy djwỳ kume:x prãmje. Mỳj got gwaj me kadjy nẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nhym Jeju arkum, —Mỳj ne ar anhõ djwỳ kute? ane. Nhym ar kum, —Djwỳ kubê 7. Tepprãredjwỳ ngrêre, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nhym kam arỳm me krãptĩmã 'ã karõn kum, —Pykabê dja ga me nhỹ, ane. Nhym me kam arỳm nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nhym kam arỳm djwỳ kubê 7 jamỳn tepprãre jamỳn o Metĩndjwỳnhmã amikĩnh jarẽ. Ne kam kokij ne mã kôt ba djwỳnh arkum kungã nhym ar mã me krãptĩmã adjuw. ");
INSERT INTO txuNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nhym kam me kunĩ kwỳ krẽn arỳm ajne. Nhym kam me arỳm aũm karwàn kaxnokaikam kungij. Kungij nhym arỳm kaxnokai ipubê 7 ne 'ã kàtàm. ");
INSERT INTO txuNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Be, me my kubê 4.000 ne õ kwỳ krẽ nhym me niremẽ me prĩre'ã akre kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nhym kam arỳm amũ me anon kam kà'õkam nhỹ. Ne kam nox ne pykabê Madara'ỳr mõn 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nhym mebê pardjêumẽ mebê xadjudjêumẽ Jeju'ỳr bôx ne mrãmri kubê Metĩndjwỳnh Krakumrẽx jabej kum, —Goja kàjkwa kurũm mỳjja pumũnh kêt'õ nhipêx bar omũn kôt ama, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nhym memã kum, —Arỳm myt djàrmã nhym myt ngjêx djàkam kàjkwa kamrêk. Ga me kam 'ã abenmã kum, “Dja kryràm kàjkwa mex”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nàr, arỳm myt katormã nhym myt apôx djàkam kàjkwa kamrêk ne kakrã kumex ga me kam 'ã abenmã kum, “Akati jakam dja na kumex”, ane. Me ga ne ga me amijo ajêx ne amijo Metĩndjwỳnh mar mex. Aje kàjkwa mex mar nàr aje kàjkwa punu mar. Mỳkam ne ba me akam ar ibari mỳjja pumũnh kêt kwỳ nhipêx ne me amã mỳjjao amirĩto iba ga me ja mar kêt ne? Ga me omũnh kajgon amim, “Je tô mỳj'ã”? anhỹr kajgon mar kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Me ga akamingrãnyre ne ga me ajaxwen mỳjjakôt ari Metĩndjwỳnhbê amijo akẽxo aba. Ga, me kwỳ kute kum prõ djwỳnh kĩnh ngriren kute mebê prõo àkĩnho baja pumũ. Me gadjwỳ ne ga me amã Metĩndjwỳnh kĩnh ngriren ari kubê amijo akẽxo aba. Ne kam me aje omũnh kadjy ije me amã mỳjja pumũnh kêt nhipêx jabej. Djãm kam ije me amã ipêxmã? Kati. Ije me amã ipêx me aje omũnh prãm kêtkumrẽx. Dja ba ĩ amijo Metĩndjwỳnh kukwakam ujarẽnh djwỳnhbê Djônaj pyràk. Dja ga me jabit pumũ, ane. Tyk ne akubyn tĩn'ã ne ã Jeju memã ane. Ne kam arỳm mebê akẽx ne mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ne kam ar imôti'ã rên akàx nhikjêmã bôx. Nhym kôt ba djwỳnh ar djwỳo amak kêt katin arỳm Jejumã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nhym arỳm me kukràdjà kajgo kôt ar amijo ba kêt kadjy arkum kabẽn ne arkum, —Ga, me kute djwỳ nhigot djà djwỳ djômkam kapĩnja pumũ. Nhym arỳm djwỳ tỳx me:x ne. Ar gadjwỳ dja gar me kukràdjà man kôt ar amijo aban arỳm ajaxwe mex ne. Mebê pardjêu kukràdjà nàr mebê xadjudjêu kukràdjà dja gar aman kôt ar amijo aban arỳm ajaxwe me:x ne. Ar amijã ano tỳx ne me kukràdjà mar kêt ne kôt ar amijo aba kêt. Nãm ã Jeju nêje ar kukrào ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nhym kam ar ari 'ã aben kukij ne arĩk abenmã kum, —Gwaj baje djwỳ byr kêtkam ne ã gwaj bamã ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nhym Jeju arỳm ar kabẽn man arkum, —Ar aje amim imar ngri:re. Mỳkam ne gar aben kukij ne abenmã kum, “Gwaj baje djwỳ byr kêtkam ne ã gwaj bamã ane”, ane? ");
INSERT INTO txuNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Djãm ar aje mỳjja mar kêt rã'ã? Mỳj'ã ikabẽn kute amijakreja djãm aje mar kêt rã'ã? Ar akubyn amijo tẽn ije djwỳ kubê 5o mebê 5.000o djuw mex'ỳr amijo bôx. Mỳj ne ar aje djwỳ janhy karwànhkam kaxnokai ipu kuten 'ã kàtàm ne? ");
INSERT INTO txuNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ar akubyn amijo tẽn ije djwỳ kubê 7o mebê 4.000o djuw mex'ỳr amijo bôx. Mỳj ne gar aje djwỳ janhy karwànhkam kaxnokai ipu kute? Ga, djwỳ kume:xo ije meo djuw mexja pumũ. Djãm arỳm ne gar o ajamak kêt kati? ");
INSERT INTO txuNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Djãm djwỳ'ã ne ba ar amã arẽ? Djãm 'ã ne ba ar amã, “Ari amijã ano tỳx. Kwãrĩk wãnh mebê pardjêu kukràdjà, nàr mebê xadjudjêu kukràdjà, kute djwỳ nhigot djà pyràk kwãrĩk wãnh kôt ar amijo aba kêt”, ane? Kati. Djwỳ'ã ije ar amã ja jarẽnh kêt. Mỳkam ne gar aje ja mar kêt? Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nhym kam ar arỳm kuma. Kute Ar kubê me kukràdjà pyma. Kute Ar kubê mebê pardjêumẽ mebê xadjudjêu kukràdjà pyma. 'Ã ne djwỳ nhigot djà amijakre. Tãm ne ar arỳm jakam kuma. ");
INSERT INTO txuNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Be, Piripi nhõ krĩraxbê Xedjare bu'ã ne apỹnh me õ krĩ djàri. 'Ỳr ne Jejumẽ kôt ba djwỳnh ar mõ. Ar 'ỳr mõrkôt nhym Jeju arkum, —Ẽ, ar imã ijã me ujarẽnh jarẽ ba kuma, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nhym ar arỳm kum, —Nãm me kwỳ ajã, “Ngômã me angjênh djwỳnhbê Djuão. Ta ne akubyn tĩn ne ar ba”, ane. Nhym me kwỳ ajã, “Me bakukãmãre Erij. Metĩndjwỳnh kukwakam ujarẽnh djwỳnh raxbê Erij”, ane. Nhym me kwỳ ajã, “Me bakukãmãre Djermi. Metĩndjwỳnh kukwakam ujarẽnh djwỳnhbê Djermi”, ane. Nhym me kwỳ ajã, “Me bakukãmãrekam Metĩndjwỳnh kukwakam ujarẽnh djwỳnh ar 'õ.” Nãm me ã abenmã ajã ane. Nãm ã ar Jejumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nhym ajte arkum, —Ne ar gadjwỳ mã ne gar imar on? Mỳj'ã ne gar ijakre? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nhym Pedru kum, —Abê me inhõ Bẽnjadjwỳrbê kumkatibê Kritu. Abê Metĩndjwỳnh tĩn ne ar baja Kra, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nhym Jeju Pedrumã kum, —Ximão, Djônaj kra. Djãm pykakam me'õ ar ba ne amã ijarẽ ga ima? Kati. Kàjkwakam Ibãm ne amã ijo amirĩt ga ima. Kam ne ga akĩ:nhkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ga ne ga imã, “Abê me inhõ Bẽnjadjwỳrbê kumkatibê Kritu. Kadjy ne Metĩndjwỳnh ajano ga bôx. Ga abê Metĩndjwỳnh tĩn ne ar baja kra”, ane. Ba amã arẽ ga ama. Ga abê Pedru. Mrãmri, kẽn'ã ne anhidji amijakre. Akabẽn mex jakôt ne ga arỳm atỳx ne aje kẽn pyràk. Dja me akudjwa ã amim imaro ane ba arỳm amim me utà nhym me arỳm akudjwa tỳx kute kẽn tỳx pyràk. Me kute amim imar kunĩja dja me tỳ:x nhym arỳm Xatanaj nhõ me àpênh te kute meo àpanhmã ne te kute me biknor tokry djàkam meo biknormã. ");
INSERT INTO txuNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dja ga aje mrãmri ne me'õ kute bẽnjadjwỳr nhõ kikrekam o kajkep djào ba pyràk. Me'õ kikre'ã kuta nhym me arỳm wadjà nàr kikre'ã ijê tỳx ne arỳm mebê aptà nhym me àr kêtkumrẽx. Aje me'õja pyràk. Dja me amim imar kêt ga arỳm mebê aptà. Nhym kam kàjkwakam Ibãmdjwỳ arỳm akôt amikabẽn djin arỳm mebê aptàn amim me utàr kêt ne ar meo ba kêt. Nàr, dja me amim ima ga memã kum, “Ajrã. Kôt ar aba”, ane nhym kàjkwakam Ibãmdjwỳ arỳm akôt amikabẽn djin memã kum, “Ajrã. Ikôt ar aba”, anen arỳm amim me utàn ar meo ba. Nãm ã Jeju Pedrumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ne kam amijã kôt ba djwỳnh arkum karõ. Metĩndjwỳnh ne arỳm mebê idjaer kadjy Jeju'ã Bẽnjadjwỳrbê kumkati mẽ. 'Ã ne me kum Kritu jarẽ. Nãm amijã arkum karõn arkum, —Kwãrĩk wãnh me'õmã kum, “Jejubê ne Kritu. Kubê ne me banhõ Bẽnjadjwỳrbê kumkati”, anhỹr kêt. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ne kam ja nhijukri arỳm kôt ba djwỳnh arkum, —Krĩraxbê Djeruxarẽkam itokry kumexmã ne Metĩndjwỳnh ijano ba arỳm 'ỳr itẽmmã. Dja ba kam bôx nhym mebêngêtmẽ me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ ijo bikẽnh kumex nhym me arỳm ibĩ. Nhym ijã akatin akatin akati ba akubyn itĩn ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nhym kam Pedru arỳm Ar kubê Jejuo tẽn ar kàxã nêje kum bẽn tỳxmo krax ne kum, —Bẽnjadjwỳr djwỳnh, gop gê Metĩndjwỳnh kum akaprĩ. Djãm ga dja me abĩ? Arkati, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nhym Jeju akẽx ne Pedrumã kum, —Arỳm akabẽn kute Xatanaj kabẽn pyràk. Amũ imã akre rax ne dja. Aje Metĩndjwỳnh bê ijo akẽx prãm pyràk. Metĩndjwỳnhkôt adjumar kêt. Me kum ikĩnh kêtja kôt ne ga adjumar djà dji, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nhym kam Jeju kôt ba djwỳnh arkum, —Gêdja gar ajõ mã ikôt abikamẽnh prãm jabej kwãrĩk wãnh amidjwỳnhbit mar kêt. Dja ga amim, “Djãm ba ije amijo ikĩnhmã? Kati”, ane. Dja ba ityk kadjy inhõ pĩte'y mỳn itokry:. Dja ga ijã amijakren aje anhõ pĩte'y mỳnh mãn pràbê amã atokry pyma kêt ne amã ijabê rã'ã ne mã ikôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Me kute amidjwỳnhbit mar ne me kum tokry pyma, me tãm gêdja me tyn kam ijukri me biknor tokry djàkam tẽ. Nhym be, me kum ijabêkumrẽx ne kute amidjwỳnhbit mar kêt nhym me kute me bĩn jabej me tãm gêdja me amiptàn ar tĩn ne ba rã'ã: rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ne ren me'õ pykabê mỳjja mexja kunĩ, nêkrêx kunĩja ren ari o atom ne o ban kam ren ty. Je, mã dja kam nẽ? Kati, nãm ren ty nhym ren õ nêkrêxja ren wãnh kumex. Nhym mỳj pãnh ne ne ren Metĩndjwỳnhmã arẽ nhym ren akubyn o tĩn nhym ren kum amijo pãnh? Arkati. Dja te kum pãnh jarẽ nhym akubyn o tĩn prãm kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ba ije amijo inhĩ ne me'ỳr irwỳk dja ba Ibãm jadjênhmẽ umao ipyma:n me'ỳr bôx. Kadjy mrãnh djwỳnh pyma:mẽ ro'ã me'ỳr bôx. Ne kam me ĩ pỹnhkôt me kunĩmã o pãnh ne. Me axwe kôt nàr me kute katàt amijo ba kôt memã o pãnh ne. ");
INSERT INTO txuNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ba ar amã arẽ. Ije amijo inhĩ ne ar awỳr ibôx. Ibãm dja ijã bẽnjadjwỳr rax mẽ. Dja ba bôx ne ipymao ar apytàn ar ar ajo iba. Dja gar adjãmja akwỳ atĩnri iraxkôt ipumũ, ar akadjy ibẽnjadjwỳr rax ne ipymakôt ipumũ. Mrãmri ne ba ikabẽnja. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jeju memã ane nhym kam ar'ã akati amãnhkrut ne amãnhkrut ne amãnhkrut apêx. Nhym kam Jeju arỳm Pedrumẽ Xijagumẽ Djuão ar aprôn aro tẽn krãnh prêkti'ã aro wabin ate ar ro'ã me kàxã dja. ");
INSERT INTO txuNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ne kam arỳm ar kabem amijo atemã. Ne nokre jadjênh kute myt jadjênh pyràk. Nhym õ kubẽkà arỳm aka:n kam adjê:nh. ");
INSERT INTO txuNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nhym kam me bakukãmãrebê Môjdjêmẽ Erijmẽ arỳm arkum amijo amirĩt ne. Ar Jejumẽ abenmã ujarẽnho dja nhym ar arỳm ar omũ. ");
INSERT INTO txuNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nhym kam Pedru Jejumã kum, —Bẽnjadjwỳr djwỳnh, jakam arỳm gwaj bakĩnhkumrẽx. Amã kĩnh jabej dja bar ar amã kikre kryre nhipêx. Dja bar amã 'õ nhipêx ne Môjdjêmã 'õ nhipêx ne Erijmã 'õ nhipêx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nãm kum kabẽno dja nhym kakrã jadjênh arỳm ar nokrekam kato. Ar nokrekam katon arỳm ar kuno. Nhym ar aêrbê Metĩndjwỳnh kakrã kurũm kabẽn nhym ar kabẽn ma. Nhym arkum, —Ikra ne wã. Imã abê:kumrẽx. Ba kam kam ikĩnhkumrẽx. Tãmwã dja gar kabẽn man kôt ar amijo aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ar kabẽn ja man arỳm madjà kreti. Madjà kretin tu mỳrbê tỹm ne nõ. ");
INSERT INTO txuNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nhym Jeju ar'ỳr bôx ne ar kupên arkum, —Kàjmã ar dja. Kwãrĩk wãnh ar atĩn prãm kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nhym ar kàjmã rĩt nhym arỳm Jeju pydjibit dja nhym ar omũ. Arỳm ne Môjdjê ar ar aêrbê mã tẽn arỳm amirĩt kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nhym kam ar arỳm krãnh prêkti'ã rwỳk tẽ. Rwỳk tẽ nhym Jeju arỳm arkum 'ã karõn arkum, —Ar aje ipumũnhja kwãrĩk wãnh on me'õmã 'ã adjujarẽnh kêt. Ba ije amijo inhĩja ityk ne akubyn itĩnkambit dja gar 'ã ajarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nhym kôt ba djwỳnh ar Erij jabej Jeju kukij ne kum, —Mỳkam ne Môjdjê kukràdjà mar djwỳnh memã kum, “Erij kumrẽx dja bôx nhym kam Metĩndjwỳnh ar meo ba”, ane? Mỳkam ne me memã ja jarẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nhym Jeju arkum, —Be, mrãmri, gêdja me'õ kute Erij pyràk kumrẽx bôx ne akubyn Metĩndjwỳnh'ỳr me kunĩo akẽx ne. Meo akẽx nhym me arỳm amim maro ba. ");
INSERT INTO txuNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ba ar amã arẽ gar ama. Me'õ kute mrãmri ne Erij pyràk arỳm bôx nhym me kute mar kêt ne arỳm amikĩnhje o bikẽnho ba. Badjwỳ ije amijo inhĩ dja me ijo bikẽnho ba ba itokry ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nhym kam kôt ba djwỳnh ar amim, —Be, ngômã me angjênh djwỳnhbê Djuão'ã ne ar imã ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kam Jeju ar arỳm krãnh'ã rwỳk tẽ. 'Ã rwỳk tẽ:n arỳm me krãptĩja'ỳr bôx. Nhym kam me'õ 'ỳr bôx ne parbê kõnkrão nhỹn ");
INSERT INTO txuNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kum, —Bẽnjadjwỳr djwỳnh, amã ikra kaprĩ. Ikra ibê tyk ar ban amijo bikẽnh krãptĩ. Nãm mã tyn kuwykam rôrôk ne ngôkam nox. ");
INSERT INTO txuNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nã bãm akôt ba djwỳnh ar'ỳr o bôx nhym ar te kute o mexmã o ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nhym kam Jeju me'ỳr akẽx ne memã kum, —Je, me akamingrãny aje amim ikamnhĩx kêtkumrẽx ne ajaxwe. Mỳj dja ijã akati, akamàt kô kute ba me akam arek ar iba? Nã bãm me awỳr bôx ga me ajamakkre kêtkumrẽx ne prĩne akabẽno ikaty. Nã bãm te amiwỳr me akam ama ga me arĩk ar aba, ane. Ne kam bãmjamã kabẽn ne kum, —Amrẽ akrao tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nhym arỳm 'ỳr o tẽn o bôx nhym Jeju arỳm kum akij. Me karõ punu kute kra bôktio bajamã akij nhym arỳm kum iren kurũm katon mã tẽ. Nhym arỳm myt tãmkam mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nhym kam Jeju tẽn ate dja nhym kôt ba djwỳnh ar arỳm 'ỳr bôx ne kum, —Mỳkam ne bar te: ije me karõ punu kujaêkmã o ane? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nhym Jeju arkum, —Djãm ar aje kujaêk kadjy tu amim Metĩndjwỳnh kamnhĩxkumrẽx? Kati. Ar aje kadjy tu amim kamnhĩxkumrẽx kêt. Dja gar tu amim kamnhĩxkumrẽx. Be, me kute tu amim Metĩndjwỳnh kamnhĩxkumrẽxkam me kute rerekre pyràk. Ga, pidjôbê motadu 'ydjwỳ ngri:ren rere:kreja pumũ. Nhym be, kati. Motadu 'y arỳm krekam ingrõt ne abatành ne kam arỳm abatà:nh ne. Ar gadjwỳ dja gar tu amim Metĩndjwỳnh kamnhĩxkumrẽx ne kam kute arerekre pyràk nhym arỳm ar amã mỳjja jabatành nhipêx. Kute mỳjja rũnh kunĩ nhipêx mar. Gar ren kadjy tu amim Metĩndjwỳnh kamnhĩxkumrẽx ne ren krãnhjamã kum, “Krãnh, amũ ajkamẽ”, ane nhym ren arỳm amũ ajkamẽ. Djã ne gar ren te aje mỳjja 'õo anhỹrmã? Kati. Ne gar ren apỹnh mỳjja kadjy tu amim Metĩndjwỳnh kamnhĩxkumrẽx nhym ren arỳm ar amã ipêx ne. Nhym be, kati. Ar aje tu amim kamnhĩxkumrẽx kêt. Mrãmri ne ba ar amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nhym be, me karõ punu kute bôktio baja mebê tỳ:x. Me kute Metĩndjwỳnhmã o à'wỳr ne kum amijajburkambit arỳm apôx. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nhym kam ar arỳm pykabê Garrêjakam ar ba. Nhym kam Jeju arkum, —Ba ije amijo inhĩ dja me'õ ibê amijo akẽx ne memã ikanga. ");
INSERT INTO txuNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nhym me kam arỳm ibĩ. Nhym ijã akatin akatin akati ba akubyn itĩn, ane. Nhym kam kôt ba djwỳnh ar arỳm kaprĩre ne. ");
INSERT INTO txuNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nhym kam ar krĩraxbê Kapana'ỳr tẽn 'ỳr bôx. Nhym kam pi'ôk kaprĩo atom djwỳnh ar ba. Ar kute Metĩndjwỳnh nhõ kikretio mex kadjy pi'ôk kaprĩo atomo ba. Ne kam ar Pedru'ỳr bôx ne Jeju jabej kukij ne kum, —Djãm ar anhõ ujarẽnh djwỳnh kute Metĩndjwỳnh nhõ kikreti kadjy memã pi'ôk kaprĩ nhõrmã? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nhym arkum, —Nà. Dja ar amã kungã, ane. Ne kam kikremã wadjàn Jeju'ỳr bôx ne amikabẽn mar tôràm nhym Jeju kumrẽx kum, —Ximão, mỳj ne ga kam mar on? Mỳj xêbê gêdja pykakam me bẽnjadjwỳr pi'ôk kaprĩo atomo ba? Pi'ôk kaprĩbê ĩpôxuo atom nàr pi'ôk kaprĩbê kributuo atom. Mỳj xêjabê dja o atom? Djãm ta kra Ar kubê dja o atom nàr djãm õ àpênh kajgobê o atom? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nhym Pedru kum, —Õ àpênh kajgobê dja pi'ôk kaprĩo atom, ane. Nhym Jeju kum, —Mrãmri, õ àpênh kajgobê dja o atom. Kute kra Ar kubê pi'ôk kaprĩo atom kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bir be, gu babê Metĩndjwỳnh kra. Kam Metĩndjwỳnh gu babê pi'ôk kaprĩo atom kêt. Gê te gu babê pi'ôk kaprĩ byr kêt gu ba dja gu tu o atom djwỳnh arkum kungã. Metĩndjwỳnh nhõ kikreti kadjy o atom djwỳnhmã kungã. Gwaj ren arkum õr kêt nhym ren me abenmã gwaj bajã kabẽ:n ne. Aje, imôti'ỳr dja ga tẽn 'ỳr bôx. Ne kam kum anhõ kadjàt mẽ. Dja tep'õ kumrẽx 'ã wajêt ga o wabin abyn ajkwa pôt. Ajkwakam dja ga ngônhponho pi'ôk kaprĩ pumũ. Tãm dja ga aby gu amikadjy arkum kungã, ane. Nhym kam arỳm ã anen arỳm arkum kungã. ");
INSERT INTO txuNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nhym kamã kôt ba djwỳnh 'õdjwỳ ar 'ỳr bôx ne kukij ne kum, —Kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo bakam nhỹnh ar ijõ dja bar iraxo aben jakre? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nhym amiwỳr me'õ prĩre 'uw nhym 'ỳr bôx nhym ar ipôkri kudja. ");
INSERT INTO txuNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ne arkum, —Dja gar on amirax jabejja kangan amijo angriren amijo akàtàm. Amijo angrire kute me prĩre pyràk. Godja gar amirax jabej rã'ã djãm kàjkwakam Bẽnjadjwỳr djwỳnh kôt ar abamã? Kati. Kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo bakam kôt ar aba prãm kêtkumrẽx. Mrãmri ne ba ar amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kam me kute amijo ngrire kute me prĩre ja pyràk tãm ne raxo kute me kunĩ jakrenh. Kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo bakam ne raxo kute me kunĩ jakrenh. ");
INSERT INTO txuNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nhym kam me kute ikukwakam kum me prĩre kute ja pyràk kĩnh, kum me'õ kàtàmja kĩnh ne kam arỳm badjwỳ kum ikĩnh. ");
INSERT INTO txuNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nhym be, me'õ kute me prĩre pyràk ne ajbir kute amim imar ny nhym kam ren ate me'õja axwe'ã kum apnê nhym ren arỳm kôt axwe nhym kam ren pãnh me mut'ã kẽnpoti nhô, kute kum axwe'ã àpnênh djwỳnhja mut'ã ren kẽn jabatành nhô ne ren ngônhmã kumẽ, ngô jabatành nhipôkri kumẽ nhym ren ngô kubĩ. Ja ne kàjbê tokry. Tokry ngrire. Nhym be kati, dja prĩne Metĩndjwỳnh o ajkẽ nhym tokry ra:x ne. ");
INSERT INTO txuNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ỹ, watĩ:re. Pykakam me kute me axwe'ã memã àpnênhja dja me tokry ra:x ne. Mrãmri dja me axwe'ã memã àpnênh ba. Nhym be, kute 'ã memã àpnênh djwỳnhja watĩ:re. Dja tokry ra:x ne. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ga, me kute apỹnh amikukràdjào àpênh jaxwe prãmja pumũ. Ar kute àpênh jaxwe krã'yrn kangamã ne Jeju Ar kubê axwe pyman arkum, —Ne ga ren ar ajaxwe kadjy anhikra nhikjêo aje mỳjja punu kupênh prãm nàr ar apar nhikjêo mỳjja punu'ỳr amrãnh prãm mỳj ne gar ren on? Bir, ga ren ar on krãtan rũm amibê amẽ. Ne ren kam te anhikra nhikjê kêt nàr apar nhikjê kêt ne ren atĩnkam ren akĩnhkumrẽx. Metĩndjwỳnhkôt atĩn ne ar abakam ren akĩ:nhkumrẽx. Ne ren aktã anhikra rã'ã nàr aktã apar rã'ã nhym Metĩndjwỳnh ren kuwykam ar amẽ. Kuwy pôk rã'ã: rã'ãkam ren ar amẽ gar ren kam atokry ra:x ne. ");
INSERT INTO txuNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ne gar ren ajaxwe kadjy ano nhikjêo aje mỳjja punu pumũnh prãm mỳj ne gar ren on? Bir, ga ren ar on kaban rũm amibê amẽ. Ne ren kam te ano nhikjê kêt ne ren atĩnkam ren akĩnhkumrẽx. Metĩndjwỳnhkôt atĩn ne ar abakam ren akĩ:nhkumrẽx. Ne ren aktã ano rã'ãn ren atokry ra:x ne. Ne ga ren ar me biknor tokry djàkam kuwykam tẽn ren kam akaprĩkumrẽx, ane. Djãm mrãmri ne ar kute aminoo pôx ne aminhikra krãkàr ne amipar krãkàrmã Jeju arkum 'ã karõ? Kati, ar kute àpênh jaxwe krã'yrn kangamã ne Jeju 'ã arkum ar kute amibê amikukràdjà krãkàrmã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ne kam ajte arkum, —Me'õ kute me prĩre pyràk djãm ar amã kurên aje kum kajgo jarẽnhmã? Kati. Kwãrĩk wãnh. Mỳkam? Bir, djãm kajgo? Kati. Mỳkam? Bir, kadjy mrãnh djwỳnh kute me prĩreo djuw mex djwỳnhja ne kute kàjkwakam Ibãm pumũnh rã'ãkam. Ba ne ba ar amã ja jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Be, ije me axwe pytàrmã ne ba tẽ. Kadjy ne ba amijo inhĩ ne me awỳr ruw, ije me axwekam me biknorja pytàrmã. ");
INSERT INTO txuNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ar gadjwỳ dja gar adjukaprĩ. Godja me'õ nhõ mrykĩ'ãtomti krãptĩ kubê 100 nhym kam pydji kubê màt ne biknorja. Mỳj dja me'õja on? Bir, dja mry krãptĩbê 99jamã ire gê wãnh kutêp kumex, nhym kam krãnh'ỳr kôt tẽ, pydji biknorjakôt tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Godja kum kator jabej ne kam arỳm kĩ:nhkumrẽx. Kute pydji biknorjamã katorkam dja kĩ:nhkumrẽx. Ne mry'ã kàtàmbê 99 biknor kêtjakam dja kĩnh ngrire. Ba ne ba mrãmri ar amã ja jarẽnhkumrẽx. Be, ije ar amã idjujarẽnhjakam mỳj dja gar kam ama? ");
INSERT INTO txuNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bir, kàjkwakam Abãm djwỳnhdjwỳ, djãm me'õ prĩre kute ãmja pyràk pydji biknor nhym kam kĩnh got? Arkati. Kam kĩnh kêtkumrẽx. Ukaprĩkam kam kĩnh kêtkumrẽx. Tãm dja ga amim aman kudjwa adjukaprĩ. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ne kam ajte arkum, —Kam, aje me'õo akamy'õ godja ajo bikẽnh jabej ne arỳm axwe jabej. Ga dja ga adjukaprĩn akumrẽx 'ỳr tẽn me kàxã kukjan kum akabẽn. Godja kute amar ne axwemã irer jabej ga ne ga arỳm Metĩndjwỳnh'ỳr o akẽx nhym ajte kôt ba. ");
INSERT INTO txuNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nhym godja kute amar prãm kêt ne mã axwe jabej. Kam dja ga me'õ pydji nàr amãnhkrut 'ỳr aro tẽ. 'Ỳr aro tẽn 'ỳr aro bôx. Ne kam kukjan kum akabẽn gê ar amã amijarẽ gar ama. Gar ajamãnhkrut nàr ar ajamãnhkrut ne ikjêkêt dja gar arỳm ama. Amrẽbê: Metĩndjwỳnh kabẽn kôt dja gar ã maro ane. Nãm me bakukãmãremã kum, “Dja me'õ amijarẽnh jabej. Gê ar amãnhkrut nàr ar amãnhkrut ne ikjêkêt kabẽn kôt memã arẽ. Ar kute kabẽn mar kôt arẽ nhym me arỳm kuma. Ar axikôt kabẽnkam dja me ar kabẽn man arỳm abenmã kum, ‘Mrãmri me'õja kute amijarẽnh nhym ar kute kabẽn kôt arẽnhkumrẽx’, ane. Dja me ã abenmã ane.” Nãm ã Metĩndjwỳnh me bakukãmãremã ane. Metĩndjwỳnh kabẽn jakôt dja gar ajamãnhkrut ne ikjêkêt ne me'õja'ỳr tẽn 'ỳr bôx ne ama. ");
INSERT INTO txuNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Godja gar gadjwỳ te kukjan kum akabẽn nhym kute ar amar prãm kêt ne mã axwe prãm jabej gar me kute amim imarjamã arẽ. Me kute aben pydjikam memã arẽ. Nhym godja me kute amim imar aben pydjikam te kukjan kum kabẽn nhym kute me mar prãm kêt ne mã axwe prãm jabej gar abenmã kum, “Kute Metĩndjwỳnh mar kêt. Ga, axwe prãm rã'ãja pumũ”, ane. Dja gar ã abenmã anen arỳm o kute me bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnh jaxwe pyràk. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ne kam ajte arkum, —Ba ar amã arẽ gar ama. Dja me amim imar kêt gar mebê aptà nhym kàjkwakam Ibãmdjwỳ dja ar akôt amikabẽn dji. Nàr, dja me amim ima gar memã kum, “Ajrã”, ane, kàjkwakam Ibãmdjwỳ dja ar akôt amikabẽn dji. Mrãmri ne ba ar amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ba ajte ar amã arẽ gar ama. Godja gar ajamãnhkrut pykakam kum mỳjjao a'uw nàr kum me'õo a'uw ne axikôt 'ã ar akabẽn dji, kàjkwakam Ibãm dja arỳm ar aman ar akabẽn kôt ã anen ar amã mỳjja ngã nàr me'õ kaprĩmã kĩnh jadjàn nàr me'õo mex. Ar akabẽn kôt dja ã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mỳkam? Bir, godja me'õ ar amãnhkrut nàr ar amãnhkrut ne ikjêkêt ikabẽnkôt bikprõnh jabej badjwỳ dja ba ar ro'ã akuprõ. Kam dja Ibãm ar akabẽn kôt ã ar amã o ane. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kam, Pedru Jeju'ỳr bôx ne kum, —Ije me'õo ikamy godja ari ikam axweo ba jabej. Mỳj dja ba kam ingryk kêt on? Djãm kam ingryk kêt 'ikrãn ne kubê 7? Nàr kon? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nhym Jeju kum, —Kati. Dja ga kam angryk kêt ry typdji. Dja ga kam angryk kêtbê 70 ne ajte kubê 70 ne ajte kubê 70 ne ajte kubê 70 ne ajte kubê 70 ne ajte kubê 70 ne ajte kubê 70. Dja ga ã kam angryk kêt ry typdjio ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kàjkwakam Bẽnjadjwỳr djwỳnh dja pykakam amim me utàn ar meo ba. Kam dja kum me kaprĩ. Gwaj badjwỳ ne gwaj ren bamã me kaprĩ. 'Ã dja ba idjujarẽnh jakre gar ama. Pykakam bẽnjadjwỳr rax'õ. Nhym õ àpênh kwỳ. Amrẽbê ne bẽnjadjwỳr õ àpênh kwỳmã pi'ôk kaprĩ ngã nhym ar kum o ba. Nhym jakam arỳm kute akubyn Ar kubê õ pi'ôk kaprĩo atommã. ");
INSERT INTO txuNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ne kam kute amikraxmã ne arỳm 'ỳr me àpênh'ã me omũnh djwỳnh jano. Õ àpênh ja'ỳr me àpênh'ã me omũnh djwỳnh jano. Nhym 'ỳr tẽn arỳm 'ỳr bôx. Ne kam bẽnjadjwỳr'ỳr õ àpênhjao tẽn o bôx. Be, amrẽbê ne bẽnjadjwỳr õ àpênh jamã pi'ôk kaprĩ kumex ngã nhym kum o ba. Pi'ôk kaprĩ kume:x kubê 10.000 ne kum kungã nhym o ba. Kum ar o ba:n arỳm nhỹnh o akno nhym arỳm pi'ôk kaprĩ kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Õ me àpênh'ã me omũnh djwỳnh bẽnjadjwỳr'ỳr õ àpênhjao bôx nhym te kute akubyn õ bẽnjadjwỳrmã pi'ôk kaprĩ nhõrmã. Te o ane nhym arỳm kam ngryk ne. Ngryk ne arỳm õ me àpênh'ã me omũnh djwỳnhmã kum, “Inhõ àpênh ja ne ibê inhõ pi'ôk kaprĩ kume:x ar o ban nhỹnh o akno. Gu akubyn kubê inhõ pi'ôk kaprĩ byrkumrẽx. Dja ga kubê õ mỳjja kunĩ byn me kàtàmmã angã gê me kubyn pãnh amã pi'ôk kaprĩ ngã. Nhym õ mỳjja kêt ga ajte me kàtàmmã ta ĩ djwỳnh ngã gê memã àpênh ar ba nhym me pãnh arỳm amã pi'ôk kaprĩ ngã. Ga kam ajte memã prõmẽ kra ar kungã gê ar memã apê nhym me pãnh arỳm amã pi'ôk kaprĩ ngã. Kam dja ga me kute amã pi'ôk kaprĩ nhõr kunĩo atom ne iwỳr o bôx ne imã angã. Ba kam arỳm akubyn inhõ pi'ôk kaprĩ byrkumrẽx. Inhõ àpênhja kute ibê pi'ôk kaprĩo biknor pãnh dja ba arỳm akubyn amim byrkumrẽx”, ane nhym me àpênh 'ã me omũnh djwỳnh kum, “Gê tô, ba 'ỳr”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nhym õ àpênhja arỳm õ bẽnjadjwỳr kabẽn man umaje parbê tỹm ne kõnkrão nhỹn aminêje kum, “Bẽnjadjwỳr, gop adjy amimar tô. Dja ba ĩ akubyn anhõ pi'ôk kaprĩ pãnh amã pi'ôk kaprĩ kunĩ ngã”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nhym bẽnjadjwỳrja arỳm kum õ àpênhja kaprĩ: ne kum, “Aje, jakam dja ga imã o pãnh kêt. Arỳm ba maro aknon akam ingryk kêt”, anen arỳm kum ire nhym kato. ");
INSERT INTO txuNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kute õ bẽnjadjwỳrbê pi'ôk kaprĩ ra:xo biknor ja katon arỳm ro'ã àpênh'õ jabej. Amrẽbê ro'ã ar baja jabej. Bẽnjadjwỳr nhõ àpênh ja ne amrẽbê ro'ã àpênh jamã pi'ôk kaprĩ ngrire kubê 100bit ngã nhym kum kubyn ar o ba. Nãm ro'ã àpênhja jabe:j ne arỳm kum kato. Kum katon arỳm mut 'amỳn õkreny janên kum, “Aje imã pi'ôk kaprĩo abaja on akubyn imã angã”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nhym ro'ã àpênhja arỳm umaje parbê tỹm ne kõnkrão nhỹ. Nhỹn arỳm aminêje amijo a'uw ne kum, “Adjy amimar tô. Dja ba ĩ amã kunĩo pãnh”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nhym kute bẽnjadjwỳrbê pi'ôk kaprĩ kumexo biknorja arỳm ro'ã àpênhkam ngry:k ne. Ne kum kaprĩ kêt ne kum, “Kati. On dja ga imã kunĩo pãnh ne”, ane. Ne kam on krãkamngônhmã arẽ nhym me arỳm kabẽnkôt kubê ijê. Kute mebê ijê djàkam ãm ne o pãnhkambit katormã ne me kubê ijê. Nãm ã ro'ã àpênho ane. On kute kum õ pi'ôk kaprĩ ngrirebito pãnh kêtkam ã ro'ã àpênhjao ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nhym kam amũ bẽnjadjwỳr nhõ àpênh kwỳ 'õdjwỳ arỳm 'ã omũn kam ar arỳm kam kaprĩ:re ne. Ukaprĩ kêtkam arỳm kam kaprĩ:re ne. Ne kam bẽnjadjwỳr'ỳr tẽn arỳm prĩne kum 'ã ajarẽ. Õ àpênhja kute kubê pi'ôk kaprĩ kumexo biknorja'ã kum ajarẽ. Ukaprĩ kêt'ã kum ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nhym kam bẽnjadjwỳr amiwỳr õ àpênhja 'uw nhym bôx nhym kum, “Inhõ àpênh, ga ne ga ajaxwe:. Ga inhõ pi'ôk kaprĩ kumexo aban ibê o akno ba amã, ‘Imã o pãnh’, ane. Ga te aje imã o pãnhmãn arỳm aminêje imã akabẽn. Ba imã akaprĩn arỳm amã, ‘Aj. Jakam dja ga imã o pãnh kêt. Arỳm ba maro aknon akam ingryk kêt’, ane. Imã akaprĩkam ne ba ã akam ingryk kêto ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ga ren ikudjwa ã amã aro'ã àpênhja kaprĩo anen kam ren ã angryk kêto ane. Nhym be, kati. Aro'ã àpênh ja amã anhõ pi'ôk kaprĩ ngrirebito ba. O ba ga kam anhõ pi'ôk kaprĩ jabej kum akabẽn. Nhym kam te kute akubyn amã õrmãn aminêje amã kabẽn. Djã ne ga ikudjwa amã kaprĩ? Kati. Ga tu kam angryk ne memã kanga nhym me arỳm kubê ijê.” Nãm ã bẽnjadjwỳr õ àpênhjamã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ne kam arỳm kam ngrykkumrẽx ne. Bẽnjadjwỳr nhõ àpênh kute ro'ã àpênhkam ngryk ne kum kaprĩ kêtja pãnh õ bẽnjadjwỳr arỳm kam ngrykkumrẽx ne. Ne kam arỳm me kamjêr djwỳnhmã kanga. Kute tokry kumexmã kamjêr nhym on kute o pãnh mex kadjy kum kanga. Nãm ã o ane. ");
INSERT INTO txuNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ne kam ar gadjwỳ, apỹnh ar anhĩ djàri, godja ar aje me'õo akamyja ar akam axwe jabej ar ga dja gar amã kaprĩ. Mrãmri tu amã kaprĩkumrẽx ne axwe maro aknon tu kam angryk kêt. Godja gar amã kaprĩ kêt ne kam angryk rã'ã jabej kàjkwakam Ibãmdjwỳ dja kum ar akaprĩ kêt ar akam ngry:k ne. Ije ar amã pykakam bẽnjadjwỳr'ã idjujarẽnhja kôt dja ar akam ngry:k ne. ");
INSERT INTO txuNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jeju arkum ja jarẽnh pan arỳm pykabê Garrêja kurũm katon tẽ. Nãm tẽ:n arỳm ngôbê Djodão nhikjêmã rên pykabê Djudêja'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nhym me krãptĩ: ne me kôt mõ. Nhym tẽn bôx ne kam arỳm kam meo mexo dja. ");
INSERT INTO txuNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nhym kam mebê pardjêu 'ỳr bôx ne kute we kabẽn kajgo jabej kukjêrmã ne kum, —Djãm Metĩndjwỳnh kukràdjà kôt me kute mỳjja ngrirekôt tu prõ kangamã? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Nhym memã kum, —Adjàkamã ne mỳjja kunĩ nhipêx djwỳnh mymẽ ni ar ipêx ne memã kum, “Kam dja me my prõ kadjy arỳm bãmmẽ nã arkum iren kam arỳm prõbit'ã ngrà ne. Nhym kam ar ĩ abenã tỹm ne kam kute ĩ typdji pyràk”, ane. Djãm ar aje anhõ pi'ôkkam ja pumũnh kêt? ");
INSERT INTO txuNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Djãm ar ĩ amãnhkrut rã'ã? Kati, ar kute ĩ typdji pyràk. Be ga, Metĩndjwỳnh kute abenã ar mẽnhja pumũ. Kwãrĩk wãnh me'õ abenbê aro bikjêr kêt. Nãm ã Jeju mebê pardjêumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nhym me kum, —Mỳkam ne me bakukãmãre Môjdjê memã 'ã karõn memã kum, “Gê me prõ'ã pi'ôk no'ôk ne kam kanga”? ane. Mỳkam ne Môjdjê ã memã ane? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nhym memã kum, —Bir, me amakkre kêtkam ne memã prõ kanga jarẽ. Nhym djãm adjàkamã ne me ã prõo ane? Kati. ");
INSERT INTO txuNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ba dja ba ar amã arẽ gar ama. Gêdja me'õ prõ djwỳnh kangan kam atemã akàxbê me'õmã kabẽn ne kam 'ỳr mõn kam arỳm mrãmri krô'ã o prõn arỳm axwekumrẽx. Nhym be, prõja krô'ã mjênkambit nhym myja kute kangakam axwe kêt. Nhym kam godja atemã me'õ my jadjwỳ arỳm prõ kangaja'ỳr mõr jabej. 'Ỳr mõrkam arỳm o akĩn ajte adjwỳnhdjwỳ axwekumrẽx. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nhym kôt ba djwỳnh ar kum, —Djã nãm ã me prõkam ane? Nãm ren me kum amijã man ren kam kuprỳn ar ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nhym arkum, —Be, me kwỳ kukràdjà kôt ne aje arẽnhja. Me kwỳ tỳxkam ne me kum amijã ma. Me jabit ne me prõ kêt. Nhym be, me kwỳ ne me tỳx kêt ne kam kum amijã ma kêt ne arỳm prõ'ỳr mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nhym be, me nã tikkrekam ne me kwỳ amijo ajkẽ. Me nire kadjy kukràdjà amijo ajkẽn kam kurẽ kêt ne. Nhym irãri me me kwỳo ajkẽ nhym kam me kurẽ kêt ne. Nhym me kwỳ kute kàjkwakam Bẽnjadjwỳr djwỳnh'ã nopdji kadjy ta kum amijã ma. Kum amijã man arỳm kum me nire kĩnh kêt ne. Dja gar amã amijã ma kadjy atỳx jabej amã amijã man amã me nire kĩnh kêt. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nhym kam me arỳm 'ỳr me prĩreo bôx. Kute me'ã ikra jadjwỳr ne Metĩndjwỳnhmã meo à'wỳr kadjy ne me Jeju'ỳr meo bôx nhym kôt ba djwỳnh ar arỳm nêje memã bẽn tỳx. ");
INSERT INTO txuNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nhym Jeju arkum, —Kwãrĩk wãnh arek amrẽ me prĩre iwỳr mõ, ane. Kwãrĩk wãnh mebê adjàptàr kêt gê me arek amrẽ mõ. Me kute amijo me prĩre pyràk ne amijo kàtàmjabit gêdja kàjkwakam ibãm me utàn me kadjy bẽnjadjwỳr ne ar meo ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ne kam arỳm me prĩre'ã ikra jadjuw. Ne kam arỳm mã me kurũm tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tẽ: nhym me'õ 'ỳr bôx ne kum, —Ujarẽnh djwỳnh, ga ne ga amexkumrẽx. Mỳj dja ba Metĩndjwỳnhmã amijo ne gêt kôt itĩn ne ar iba rã'ã: rã'ã ne? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nhym kam kum arẽ. Kute Jejubê Metĩndjwỳnh Kramã kator kadjy ne Jeju arỳm kum, —Mỳkam ne ga mỳjja mex jabej ikukij? Me'õ pykakam mex kêtkumrẽx. Metĩndjwỳnh pydjibit mex. Metĩndjwỳnh me katàt kute amijo ba'ã memã karõkôt kukràdjàja dja ga aman kôt ar amijo aban kam arỳm kôt atĩn ne ar aba rã'ã: rã'ã ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nhym kum, —Nhỹnh kukràdjàjakôt dja ba amijo iba? ane. Nhym kum, “Kwãrĩk wãnh me par kêt. Kwãrĩk wãnh mebê prõo adjàkĩnh kêt. Kwãrĩk wãnh adjàkĩnhĩ kêt. Kwãrĩk wãnh ajêx ne me kàmex jarẽnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Amã abãmmẽ anã jabên ar kabẽn ma. Amã amibu'ã me ja jabê. Kute mrãmri ne ga amã amijabêja pyràk dja ga ã amibu'ã amã me ja jabêo ane”, ane. Metĩndjwỳnh kute me bakukãmãremã 'ã karõkam kabẽnja dja ga aman kôt katàt amijo aba ne kam atĩn ne ar aba rã'ã: rã'ã ne. Nãm ã Jeju kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nãm me'õja ajbir abatành ne. Nhym Jeju kum ane nhym kam kum, —Nà, arỳm ne ba ja kunĩ man kôt katàt ar amijo iba. Ibôktikam ne ba kôt katàt amijo iban kam kôt ije katàt ar amijo iba rã'ã. Mỳj dja ba ajte nẽn kam itĩn ne ar iba rã'ã: rã'ã ne? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nhym Jeju kum, —Be, prĩne amex kadjy on tẽn memã anhõ mỳjja wã ngãn pãnh pi'ôk kaprĩ byn me 'uwtĩ, me õ mỳjja kêtjamã angãn o meo kĩnh ne kam amrẽ iwỳr tẽn mã ikôt ajkamẽ. Dja ga ã anen kam arỳm kàjkwakam anhõ mỳjja mex kumex, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nhym arỳm kuman kam akẽx ne mã tẽ. Kaprĩ:re ne tẽ. Be, õ nêkrêx ne kume:x. 'Ã maje ne mã kaprĩ:ren tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nhym Jeju arỳm kôt ba djwỳnh arkum, —Nêkrêx ne kute me kukrà prãmã. Me õ nêkrêx kumex gêdja me te kàjkwakam Bẽnjadjwỳr kute amim me utàr ne ar meo baja'ỳr bôxmã. Mrãmri ne ba ar amã arẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ba ajte ar amã arẽ gar ama. Be, ga mry jabatànhbê kameru te: kute aguja tekrax kremã ngjêxmãja pumũ. Me õ nêkrêx rũnhdjwỳ kute uràk. Nãm me te Metĩndjwỳnh kute amim me utàr ne ar meo baja'ỳr bôxmã nhym nêkrêx utà: ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kôt ba djwỳnh ar kute ja markam te kute marmã kam no tyn ku'ên arỳm abenmã kum, —Je nhym mỳj me'õ gêdja Metĩndjwỳnh amim me utà? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nhym Jeju arỳm ar omũnho djan arkum, —Be, me ne me te: kute amipytàr prãmje. Nhym be, Metĩndjwỳnh kute mỳjja kunĩ mar. Kumãbit ne amirĩt ne. Ta ne kute me utàrkôt kute mar, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nhym kam Pedru kum, —Ẽ, arỳm ne bar inhõ mỳjja kunĩmã inhiren kam mã akôt ajkamẽ. Mỳj dja bar pãnh kubyn o aminhõ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nhym Jeju arkum, —Ba ar amã arẽ gar ama. Ar ga ne gar arỳm mã ikôt ajkamẽ. Amrẽ mỳjja kunĩ ny mõrkam dja ba ipyma. Ije amijo inhĩ dja ba imexo ipyma:n ikrĩ djà raxkam memã nhỹ. Ar gadjwỳ, ikôt ar abaja dja gar apỹnh anhĩ djàri ar abẽnjadjwỳr rũnh ne akrĩ djà rũnhbê 12kam memã akrĩ. Apỹnh mebê idjaer ba djàri kubê 12 dja gar memã akrĩ, memã axwe pãnh jarẽnho akrĩ. Mrãmri ne ba ar amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kam godja me'õ imã àpênh kadjy arỳm õ mỳjjamã irer jabej nàr õbikwamã irer jabej. Õ kikre nàr kamy nàr kanikwỳnh nàr bãm nàr nã nàr prõ nàr kra nàr õ pykamã irer jabej. Godja arỳm õ mỳjja ja'õmã irer jabej ba dja ba kum o pãnh ra:x ne pãnh kum õ mỳjjao akrenh mex ne kum kungã ne pãnh kum õbikwao akrenh mex ne kum kungã. Kum õ mỳjjamẽ õbikwamẽ krãptĩ: kubê 100 ngã. Nhym kam arỳm Metĩndjwỳnh kôt tĩn ne ar ba rã'ã: rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nhym be, jakam me rũnho kutewaja djãm me kute memã wa rã'ãmã? Kati. Me ja krãptĩ gêdja me kajgo mex ne me katẽ tẽ. Nhym be, jakam me kajgo mex ne me katẽn tẽmja krãptĩ gêdja me pãnh rũnho kutewa. Nãm ã Jeju kôt ba djwỳnh arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ne kam ajte arkum, —Kàjkwakam Bẽnjadjwỳr djwỳnh kute pykakam amim me utàr ne ar meo bakam dja memã o pãnh. 'Ã dja ba õ pidjôkô djwỳnh jakren 'ã ajarẽ gar ama. Õ pidjôkô djwỳnh ne kry:ràm aminhũrkwã kurũm kato. Ne tẽ:n me abej. Kute õ pidjôkôkam kum àpênh kadjy me abej. ");
INSERT INTO txuNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ne kam ar ja'ỳr bôx ne arkum, “Dja ba ar adjàpênh pãnh apỹnh ar anhĩ djàri ar amã pi'ôk kaprĩ pỹnh ne kungã”, ane. Nhym ar kum, “Mrãmri”, ane. Nhym arỳm amũ õ pidjôkômã ar ano nhym ar arỳm 'ỳr tẽ. 'Ỳr tẽn 'ỳr bôx ne kam arỳm àpênh 'amỳ. ");
INSERT INTO txuNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nhym kam arỳm kàjmã myt nhỹrbê 9 ora nhym õ pidjôkô djwỳnh ajte kato. Katon arỳm amũ me kute mỳjja nhõr djàbê mekadukam tẽn bôx. Nhym ar ja àpênh kêt ne dja nhym arỳm ar omũ. ");
INSERT INTO txuNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ne ar'ỳr bôx ne arkum, “Ẽ, ar gadjwỳ inhõ pidjôkôkam tẽn apê. Dja gar apê ba arỳm ar amã o pãnh katàt”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nhym ar arỳm kabẽn kôt amũ 'ỳr tẽn 'ỳr bôx. Ne kam àpênh 'amỳ. Nhym kam mêdjijkam ajte katon tẽn ajte tãm ne àpênh'ỳr me kwỳ 'õdjwỳ jano. Ne kam myt nhibôbê 3 orakam ajte katon tẽn ajte tãm ne àpênh'ỳr me kwỳ 'õdjwỳ jano. ");
INSERT INTO txuNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nhym kam arỳm amykry mexbê 5 ora nhym ajte katon tẽ. Nhym ar ja àpênh kêt ne dja nhym arkum, “Mỳkam ne gar adjàpênh kêt nhym arỳm ar ajã amykry”? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nhym ar kum, “Bir, me'õ kute ar imã idjàpênh jarẽnh kêtkam”, ane. Nhym arkum, “Ar gadjwỳ dja gar tẽn inhõ pidjôkôkam apê. Dja ba katàt ar amã adjàpênho pãnh”, ane. Nhym ar arỳm 'ỳr tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nhym kam arỳm para nhym õ pidjôkô djwỳnh amiwỳr me àpênh'ã me omũnh djwỳnh 'uw nhym arỳm bôx. Nhym kum, “Inhõ àpênh kunĩmã akabẽn gê ar bôx ga arkum àpênho pãnh. Dja ga ar kute àpênh'ỳr ar katẽ mõrjamã o pãnh kumrẽx. Ne ar kunĩmã o pãnho tẽ: nhym ar kumrẽx àpênh'ỳr bôxja dja ga arkum o pãnh ne o pãnho ino re”, ane. Nhym me àpênh'ã me omũnh djwỳnh kum, “Gê tô. Ba akabẽnkôt memã o pãnh.” Nãm ã õ bẽnjadjwỳrmã ane. Õ pidjôkô djwỳnhmã anen arỳm amiwỳr õ àpênh 'uw. Ar ku'uw nhym ar arỳm 'ỳr bôxo dja. ");
INSERT INTO txuNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kam ar ja kumrẽx 'ỳr bôx. Ar amykry mexkam 5 orakam àpênh'ỳr mõrja kumrẽx 'ỳr bôx. 'Ỳr bôx nhym arỳm apỹnh ar ĩ djàri pi'ôk kaprĩ pỹnh ne arkum kungã. ");
INSERT INTO txuNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nhym amũ ar jadjwỳ aben totokmã 'ỳr bôx. 'Ỳr bôxo dja: nhym arỳm arkum o pãnho tẽ. Arkum o pãnho tẽ: nhym kam ar kumrẽx àpênh djà'ỳr bôxja arỳm 'ỳr bôx. Ar ja ne ar amim, “Jakam dja ar imã kàjmã pãnh kamẽ”, ane. Ar 'ỳr bôx nhym kam arỳm pi'ôk kaprĩ tãm ne arkum kungã. Pi'ôk kaprĩ pỹnhbit ne arkum kungã. Nhym apỹnh ar ĩ djàri pi'ôk kaprĩ pỹnhbit jamỳ. ");
INSERT INTO txuNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Amỳn arỳm õ pidjôkô djwỳnh'ã kabẽn kume:x ne arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ne kam kum, “Ẽ, amykrykam ar kute ar ikatẽ àpênh'ỳr bôxwã àpênh ngrire ne 'ã ora pydjibit apêx. Ar bajbit ne bar arngro tỳxkam idjàpênh 'iry ne. Djã ne ga katàt ar imã o pãnh ne? Kati. Ga ren ar imã kàjmã pãnh kamẽn ren ar imã pi'ôk kaprĩ rax ne ar imã angã. Ne ren ar wãmã ngrire ne angã. Ga arỳm aro ar ipyràk ne arỳm arkum pi'ôk kaprĩ pỹnh ne arkum angã”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nhym arỳm ar 'õmã kum, “Akmere, djã ne ba amã ijêx ne anoo akno ga akabẽn ne? Kati. Kryràm ne ba amã, ‘Pi'ôk kaprĩ pỹnh dja ba adjàpênh pãnh amã kungã’, ane. Ga kam imã, ‘Mrãmri, dja ga ã imã õro ane’, anen arỳm adjàpênh'ỳr mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kam dja ga on akrànmã anhõ pi'ôk kaprĩ jamỳn o tẽ. Mrãmri ne pidjôkô'ỳr ar kute akatẽn bôxja ije arkum o pãnho kute apyràk. Mrãmri ije amã õr kôt ije arkum pỹnh ne õrkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Inhõ ne pi'ôk kaprĩ djwỳnh. Ba dja ba amim me'ã karõ kôt memã kungã. Djãm kam ijaxwe? Kati. Imã ar ja kaprĩkam ga ren akĩnh ne. Nhym be, kati. Angryk. Me'õ nhõ mỳjja pro prãmje angryk ne. Kwãrĩk wãnh.” Nãm ã õ pidjôkô djwỳnh ane. Tãm ne ja. Be, dja ã Bẽnjadjwỳr djwỳnh kute pykakam amim me utàrn ar meo bakam memã o pãnho ane, ane. Jeju ã kôt ba djwỳnh arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ne kam ajte arkum, —Jakam me kajgo mex ne me katẽ tẽmja djãm me katẽ tẽm rã'ãmã? Kati. Me ja dja me ĩ rũnho kutewa. Nhym be, me rũnho kutewaja gêdja me pãnh kajgo mex ne me katẽ tẽ. Mỳkam? Bir, Metĩndjwỳnh ne amiwỳr me krãptĩ 'uw. Nhym be, kute mekam me ngrêrebit amijo me utàr. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ne kam ajte prykôt mõ. Kôt ba djwỳnhbê 12 ne aro mõ. Krĩraxbê Djeruxarẽ'ỳr ar àbir tẽ nhym arỳm me kàxã aro tẽn arkum, ");
INSERT INTO txuNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Ẽ, ota gwaj arỳm Djeruxarẽ'ỳr badjàbirn babôxmã. Nhym kam ba ije amijo inhĩ dja me apỹnh me rũnhmã ikanga. Dja me me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr arkum ikangan Môjdjê kukràdjà mar djwỳnhmãdjwỳ ikanga. Kam dja me ikà mex jarẽn ijã abenmã kum, “Axwekumrẽx. Gê me pãnh tu bĩnkumrẽx”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ne kam me bajtemmã ikanga nhym me arỳm ijã bẽno ajkẽn mry kà punuo ikaprêprê:k ne. Ne kam arỳm pĩte'y'ã inhô ba arỳm ty. Nhym kam ijã akatin akatin akati ba kam akubyn itĩn ne. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nhym kam Djebedêu prõ Jeju'ỳr kra aro tẽ. Ne kam 'ỳr aro bôx ne parbê kõnkrão nhỹn kum rax jarẽ. Kute mỳjja'ã 'wỳrmã ne 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nhym kum, “Mỳj nã”? ane. Nhym kum, —Me kadjy abẽnjadjwỳr ne aje amim me utàr ne aje meo abakam gê ikra amãnhkrutja ar rax ne anhikô'ã memã nhỹ. Gê ja adjubôk'ãnh nhỹ nhym ja adjuge'ãnh nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nhym Jeju kum, —Gêt kon. Ẽ, nã gãm arĩk amim 'ã karõn imã arẽ. Ba ar amã arẽ gar ama. Dja ba ngônhkrã kam kangô jao ikõ. Djãm ar aje ipyràk ne kangô jao akõmmã? Dja me ngômã ijadjà. Djãm ar aje ipyràk nhym ngômã me kute ar ajadjàrmã? Nãm ã arkum ane. Bir, mỳj'ã ne kangô jao kõm ne ngômã adjàrja jakre? Bir, amitokry kume:x'ã ne akre. Nhym ar kute uràk jabej ne ar kukij. Ar tokryo kute Jeju tokry pyràk jabej ne ar kukij. Nhym ar Jejumã kum, —Nà. Kadjy ar ije apyràk, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nhym Jeju arkum, —Mrãmri dja gar aje ipyràk ne atokry kumex ma. Mrãmri dja gar kangô jao ikõ nhym me ngômã ar ajadjà. Be, djãm ba ne ba ar amã inhikô'ã ar anhỹrmã arẽ got? Be, Ibãm kute amrẽbê: amijo me'õ ar utàr, ar ta dja ar inhikô'ã memã nhỹ. Nãm ã Xijagumẽ Djuão arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nhym kôt ba djwỳnh Ar kubê 10 arỳm ar kabẽn man arỳm arkum àkrê. Ar arỳm kamy amãnhkrutja, Xijagumẽ Djuão arkum àkrê ne. ");
INSERT INTO txuNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nhym Jeju amiwỳr ar ku'uw ne arkum, —Me bajtemkam me bẽnjadjwỳr ne me àpênh'ã memã àpnênh ne memã bẽn tỳx ar o ba. Nãm ã me bajtemkam me rũnh ar meo bao ane. Gar arỳm ama. ");
INSERT INTO txuNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Djãm ar ga gar aje me kudjwamã? Kati. Ar ga dja gar ã anhỹr kêtkumrẽx ne. Ar ajõ abenkam arax prãm jabej gêdja amijo kajgon tu ar amã àpênh ar ba. ");
INSERT INTO txuNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ga kam ar ajõ aben kadjy abẽnjadjwỳr rax prãm jabej gêdja tu amijo kàtàm ne tu ar amã àpênh kajgo ba. ");
INSERT INTO txuNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ba ije amijo inhĩ djãm me imã àpênh kadjy ne ba amrẽ tẽ? Kati, ba dja ba memã apê. Me ren ta amijaxwe pãnh tokryn arỳm ty. Nhym be kati. Me krãptĩ jaxwe pãnh ba dja ba itokryn arỳm ty. Memã idjàpênh ja kadjy ne ba amrẽ tẽ. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nhym kam ar krĩraxbê Djeriko kurũm kator tẽ nhym me krãptĩ: arỳm arkôt mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nhym ar no rã amãnhkrutja pry japkre'ã nhỹ. Nhym me abenmã kum, “Jeju ne tẽ”, anhỹro kumex nhym ar arỳm kuman kam kum amijo akij, —Ẽ, amã ar ikaprĩ, Bẽnjadjwỳr djwỳnh, Dawi tàmdjwỳ 'õ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nhym me krãptĩ mõrja arkum bẽn tỳx ne arkum, —E kum ar anhikrê, ane. Nhym kam ar tu kum àkjêro bên kum, —Ẽ, gop amã ar ikaprĩ, Bẽnjadjwỳr djwỳnh. Dawi tàmdjwỳ 'õ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nhym Jeju ar kabẽn man arỳm arek arkum dja. Arkum djan amiwỳr ar ku'uw nhym ar 'ỳr bôx. Nhym arỳm arkum, —Mỳj ne ba ije ar ajomã? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nhym ar kum, —Bẽnjadjwỳr djwỳnh, bar on irĩt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nhym Jeju arỳm kum ar kaprĩn ar no kupê. Nhym ar no kupênhmẽ ro'ã ar rĩt ne arỳm kôt tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Nhym Jejumẽ ar prykôt mõ:n kam krĩraxbê Djeruxarẽ kuri krĩ ngrire ja'ỳr bôx. Krãnhrebê Oriwêre'ã rwỳkbê ne krĩ ngrire jabê Bepadjê. Ar krĩ ngrire ja'ỳr bôx nhym arỳm kôt ba djwỳnh amãnhkrutmã kum, —Pry ja'ã dja gar arek katàt krĩwãmã tẽ. Nhym ar akutã pry kator kraxkam dja gar mry'ã krĩwã pumũ, djumẽtuwã pumũ. Kraremẽ dja gar omũ. Nhym me kute mrywã pĩ maktã krã djê nhym amẽ ãmwã dja gar 'ãpre bôn amrẽ amẽo tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Godja me'õ 'ã ar amã kabẽn jabej gar kum, “Bẽnjadjwỳr 'ã tẽm prãm. Dja 'ã tẽn kam akuby:n amã ano”, ane. Nhym kam dja on ar amã, “Ajrã, 'ỳr o tẽ.” Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mỳkam ne ã arkum ane? Bir, amrẽbê: ne ujarẽnh djwỳnh me bakukãmãremã 'ã ajarẽ. Jeju djumẽtu'ã tẽm'ã ajarẽ. Metĩndjwỳnh kukwakam memã 'ã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ne memã kum, “Dja ga Xijãokam me jamã kum”, Krĩraxbê Djeruxarẽ'ã ne memã Xijão jarẽ. Nãm memã kum, “Dja ga Xijãokam me jamã kum, ‘Ota me anhõ Bẽnjadjwỳr rax me awỳr bôxmã. Nãm kabôt katin mry jabatành nyre'ã nhỹ. Mry'ã krĩ kra'ã ne nhỹn me awỳr bôx’, ane. Dja ga ã Xijãokam me jamã ane.” Nãm ã ujarẽnh djwỳnh me bakukãmãremã ane nhym me arỳm aben djô'ã abenmã arẽnho mõ:. Arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm Jeju arỳm me bakamingrãnyrekam kato. Ne ar ban kam kute arỳm mry'ã krĩja'ỳr kôt ba djwỳnh janorja'ỳr o bôx. Ujarẽnh djwỳnh kute me bakukãmãremã ujarẽnh kôt ne mry'ã krĩja'ỳr arỳm ar ano. ");
INSERT INTO txuNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nhym kam ar arỳm 'ỳr tẽn 'ỳr bôx. Jeju kute arkum 'ã karõ kôt ar 'ỳr tẽn 'ỳr bôx. Ne kam mrymẽ krare 'ãpre bô. ");
INSERT INTO txuNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ne kam akubyn 'ỳr o bôx. Ne kam arỳm aminhõ kubẽkà krãkào pôx ne o amẽ mry nhibũm'ã kum aty. Nhym arỳm krare'ã nhỹn arỳm tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nhym kam me krãptĩ: aminhõ kubẽkà krãkào pôx ne arỳm kukãm kum pry'ã o atyo mõ. 'Ã tẽm kadjy kum pry'ã kum atyo mõ. Nhym me kwỳ pi'ô nhikẽn arỳm kukãm pry'ã kum atyo mõ. Me ta kukràdjà kôt ne me ã Bẽnjadjwỳr rax kukãm pryo ane. Me kukãm pry'ã kum atyo mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nhym me krãptĩ: kukãm mõ, o àkjêr mõ nhym ajte me krãptĩ: kôt o àkjêr mõ. Nãm me o àkjêr mõn kàj bê abenmã kum, Metĩndjwỳnhmã kum, —Jejubê me inhõ Bẽnjadjwỳr rax. Bẽnjadjwỳr raxbê Dawi tàmdjwỳ. Ãm mexkumrẽx. Kam me ikĩ:nhkumrẽx. Gê on me ipytà. Gê Metĩndjwỳnh o kĩnh rax. Metĩndjwỳnh kukwakam ne arỳm me bakadjy bôx. Gê me kàjkwakamdjwỳ Metĩndjwỳnhmã mextire jarẽnho kumex. Gê on me ipytà. Nãm me ã Jejuo àkjêro mõro ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nhym kam arỳm Djeruxarẽmã wadjà. Nhym kam krĩraxkam me kunĩ te no katon 'ã aben kukjêro kumex ne abenmã kum, —Mỳj me'õ ne bôx? Mỳj me'õ ne bôx? anhỹro kumex. ");
INSERT INTO txuNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nhym me krãptĩ: memã kum, —Jeju ne bôx. Metĩndjwỳnh kukwakam ne ar me bamã 'ã ujarẽnh ba. Pykabê Garrêjakam krĩraxbê Nadjarekam ne Jeju abatành djà. Nãm ã me krãptĩ memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nhym kam Jeju Metĩndjwỳnh nhõ kikretimã tẽn wadjà. Nhym me kute memã mỳjja nhõr djwỳnh kam kumex. Nhym me kute memã mỳjjao pãnh ne amim byr kadjy ne me me'ã kumex. Nhym arỳm bõm me rẽnho tẽ. Nhym me kute me õ pi'ôk kaprĩ pãnh memã kikreti nhõ pi'ôk kaprĩ nhõr kadjy ne me kumex nhym mebê pĩponho àpanho tẽ. Nhym me kute tut nhõr djwỳnhdjwỳ kumex nhym mebê krĩ djà nhikô rênho tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ne kam memã kum, —Amrẽbê: ne me bakukãmãre Metĩndjwỳnh kabẽn'ã pi'ôk no'ôk ne. Kamã ne Metĩndjwỳnh ta memã kum, “Inhõ kikreti ja'ã dja me abenmã kum, ‘Me kute Metĩndjwỳnhmã kabẽn kadjy ne õ kikreti wã’, ane. Dja me ã inhõ kikreti'ã abenmã ane.” Nãm ã Metĩndjwỳnh pi'ôkkam ane. Nhym be, me ga ne ga me kam aje me àkĩnhĩo aben pydji djà. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nhym kam Metĩndjwỳnh nhõ kikretikam me no rãmẽ me mrãnh punu 'ỳr bôxo kumex nhym arỳm meo mex. ");
INSERT INTO txuNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nhym kam me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ ne me Jeju djàpênh me:xkumrẽxja pumũn ajte me prĩre pumũ. Me prĩre ne me kikretikam kàj bê o akij ne kum, —Jejubê me inhõ bẽnjadjwỳr rax. Bẽnjadjwỳr raxbê Dawi tàmdjwỳ. Ãm mexkumrẽx. Kam me ikĩnhkumrẽx. Gê on me ipytà, ane. Nhym me me omũn me kuman arỳm ngryk ne. ");
INSERT INTO txuNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ngryk ne arỳm Jejumã kum, —Djãm aje me prĩre kabẽnja mar kêt? ane. Nhym memã kum, —Nà, arỳm ba kuma. Ba ar amã arẽ gar ama. Me bakukãmãre ne amrẽbê: Metĩndjwỳnhmã me prĩre ja'ã ajarẽ. Me kum, “Me prĩremẽ me karàremẽ ne ga memã me kabẽn mexmã 'ã karõ nhym me arỳm amã mextire jarẽnh mexkumrẽx.” Nãm ã me bakukãmãre Metĩndjwỳnhmã ane. Nhym me arỳm kuman amũ aben djô'ã abenmã arẽnho mõ:. Arẽnho mõr tãmtã arỳm iwỳr o bôx. Tũmràm me bakamingrãnyrekam me prĩre arỳm imã amikĩnh jarẽnho kumex. Me bakukãmãre kute Metĩndjwỳnhmã me prĩre ja'ã ujarẽnh kôt ne me prĩre arỳm imã amikĩnh jarẽ. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nãm memã anen kam arỳm memã kàx ne krĩrax kurũm katon tẽ. Ne tẽ:n arỳm krĩ ngrirebê Betanha'ỳr bôx. Ne kam arỳm kam ngõr. ");
INSERT INTO txuNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nhym 'ã akati nhym ajte akubyn krĩraxbê Djeruxarẽmã tẽ. Nãm 'ỳr tẽ:n kam arỳm kum prãm. ");
INSERT INTO txuNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ne arỳm prykôt pidjôbê pigêre pumũn 'ỳr tẽn 'ỳr bôx. Ne te ô jabej. 'Ôbit ne kumex. Ne kam kum, —Gê ajte adjô'õ jêt kêtkumrẽx, ane. Nhym arỳm tẽmbê ngrà. ");
INSERT INTO txuNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nhym kam kôt ba djwỳnh ar arỳm omũn kam no tyn abenmã kum, —Je, mã ne bàrio nhym myt tãmkam ngrà? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nhym Jeju arkum, —Ba ar amã arẽ gar ama. Dja gar kadjy tu amim Metĩndjwỳnh kamnhĩxkumrẽx. Kwãrĩk wãnh anhõkre kadjwỳnhbê amim, —Kon, birãm dja ipêx, kon, anhỹr kêt. Gar ren tu amim kamnhĩxkumrẽx ne ren arỳm ã pidjôbê pigêremã ane nhym ren arỳm ã ngrào ane. Djãm jabit? Kati, gar ren krãnhwãmã kum, “On amikaban ngô jabatành mũjakam mõn tỹm”, ane. Nhym ren arỳm akabẽn kôt mrãmri ã amijo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Dja gar mỳjjao Metĩndjwỳnhmã a'uw ne tu kadjy amim kamnhĩxkumrẽx nhym arỳm ar akabẽn kôt ã ar amã mỳjjao ane. Mrãmri ne ba ar amã ja jarẽnhkumrẽx. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ne kam arỳm Metĩndjwỳnh nhõ kikreti'ỳr bôx ne kum wadjà. Ne kam arỳm kam memã Metĩndjwỳnh kukràdjà'ã ujarẽnho dja. Nhym me rũnh arỳm 'ỳr bôx. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebêngêtmẽ 'ỳr bôx. 'Ỳr bôx ne amũja'ã kute kikreti kurũm me anorja jabej kukij ne kum, —Mỳj me'õ kabẽnkôt ne ga ar ã meo anhỹro aba? Mỳj me'õ ne amã me'ã karõ ga kam amũ ô'ã bõm ar me rẽnho aba? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nhym Jeju memã kum, —Badjwỳ dja ba mỳjja jabej me akukja. Me akumrẽx dja ga me imã arẽ. Ba kam arỳm badjwỳ ije mỳj me'õ kabẽnkôt ar me anoro ibaja me amã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Djuão kute ngômã me angjênhja djãm me kabẽn kôt ne arĩk ar ngômã me angjênho ba? Nàr djãm Metĩndjwỳnh kabẽnkôt? Imã arẽ, ane. Nhym kam me abenkam kangan abenmã kum, —Je mỳj dja gwaj kum nẽ? Dja gwaj kum “Metĩndjwỳnh kabẽnkôt”, ane nhym kam gwaj bamã kabẽn 'õ jarẽn gwaj bamã, “Bir be, mỳkam ne ga me amim Djuão kabẽnja mar kêt ne”? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nàr dja gwaj kum, “Me kabẽnkôt ne tu arĩk ar ngômã me angjênho ba”, ane nhym kam me krãptĩ ren o ngryk ne kum gwaj bakurê gwaj ren kam bamã me uma ne. Me kàtàm ja ne me arỳm Djuão kabẽn man kum kĩnh ne ne o Metĩndjwỳnh kabẽn jarẽnh djwỳnh ne. Dja gwaj kam ane nhym me arỳm o ngryk ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nãm me ã abenmã anen kam Jejumã kum, —Kon ne. Me ije mar kêt. Mỳj me'õ kabẽnkôt Djuão kute ngômã me angjênhja me ije mar kêtê, ane. Nhym kam memã kum, —Bir be, dja ba badjwỳ me amã arẽnh kêt ne. Mỳj me'õ kabẽnkôt ije ar meo iba ja dja ba me amã arẽnh kêt ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ne kam ajte memã kum, —Be, mỳj ne ga me me'õ krakam ama? Me'õ kra amãnhkrut. Ne kam arỳm kutewa'ỳr tẽn kum, “Akmere, akati jakam dja ga gu banhõ pidjôkôkam apê”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nhym kum, “Kê, kati”, ane. Ne kam tẽ. Arỳm amimaro tẽ:n arỳm amim ngryk ne, ne amim, “Kati. Dja ba pidjôkô'ỳr tẽ”, ane. Ne arỳm 'ỳr tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nhym kam bãm kutapu'ỳr tẽn àpênh'ỳr ano. Nhym kum, “Djũnwã, dja ba arỳm akabẽn kôt 'ỳr tẽ”, ane. Ne kam atekam arek nhỹn 'ỳr tẽm kêt. Be, tãm ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ba me amã arẽ. Nhỹnh ja ne bãm kabẽn man kôt amijo tẽ? Nãm ã Jeju me rũnhmã ane. Kutewa kute bãmmã, “Kati”, anhỹr ne kam kute amimarja ne Jeju kute me axwe'ã akre. Kute mrãmri ne me axwe pyràk. Nãm arỳm amima. Amiman kam arỳm Metĩndjwỳnh'ỳr amijo akẽx ne tu amim markumrẽx. Nhym be, kutapu kute bãmmã 'êx ne Jeju kute me rũnh'ã akre. Kute mrãmri ne me rũnh pyràk. Me kute Metĩndjwỳnh kôt kabẽn djir kajgon kam kute kabẽn mar kêt ne. Nãm Jeju me rũnh kukij ne memã kum, —Nhỹnhja ne bãm kabẽn man kôt amijo tẽ? Nhym me kum, “Kutewaja”, ane. Nhym memã kum, —Ba me amã arẽ ga me ama. Djãm me arũnhja dja ga me akumrẽx kàjkwakam Bẽnjadjwỳr djwỳnh kôt dja nhym me ajo ba? Kati. Pykakam me bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnhmẽ me nire kuprỳmẽ, me aje memã axwe jarẽnhja dja me kàjkwakam Bẽnjadjwỳr djwỳnh kôt dja nhym arỳm ar meo ba. Ga me kam arỳm wãnh dja. ");
INSERT INTO txuNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mỳkam? Bir, Djuão ne me awỳr bôx. Kute katàt me amã pry jakre kadjy me awỳr bôx. Kôt ga me Metĩndjwỳnhmã amex kadjy me awỳr bôx. Ga me kam amim Djuão mar kêt. Nhym be, pykakam me bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnhmẽ me nire kuprỳmẽ ne me tu amim Djuão markumrẽx. Ga me kam arỳm me omũ. Ne te me omũ. Me ga ne ga me wãnh ajaxwemã anhirer ne amim mar kêt. Mrãmri ne ba me amã ja jarẽnhkumrẽx. Nãm ã Jeju me rũnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ne kam ajte memã atemã mỳjja'ã ujarẽnh jakreo tẽn memã kum, —Ẽ, jadjwỳ dja ga me ama. Me'õ ne pur rax ne kudjin kam kam amim pidjô kumex ne kadjy bu'ã kẽno kôkayr kum o ipôk ne. Ne kam pidjô janênh djàmã kren ipêx. Ne pidjô pumũnh djwỳnh ku'ê djà'ã par prêkti nhipêx. Ne kam me kwỳmã kum, —Gora me imã o djuw mex. Gora gê abatành ne ô ga amim kwỳo atom ne imã mũm kwỳo atom. Nãm ã me rũnhmã ane. Mebê idjaer'ã ne Jeju pidjô jakren me rũnh'ã pidjôo djuw mex djwỳnh jakren Metĩndjwỳnh'ã õ pidjôkô djwỳnh jakren kam arek memã 'ã ujarẽnho djan memã kum, —Õ pidjôkô djwỳnh ã memã anen kam atemã pyka 'õmã tẽ. Ne kam kam wãnh ar ba. ");
INSERT INTO txuNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nhym arỳm pidjôja tuk ne kumex. Nhym kam õ pidjôkô djwỳnhja arỳm 'ã mytyrwỳ jakren kam 'ỳr õ àpênh kwỳ jano. Ar kute memã arẽnh nhym me kute kum pidjô kwỳo atom ne kute arkôt anor kadjy ne 'ỳr ar ano. ");
INSERT INTO txuNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nhym kam ar 'ỳr tẽn bôx nhym kam me kute pidjôo djuw mexja ate ar 'õja kaprêprê:k ne ar'õnh bĩn ar 'õ kẽno titik. ");
INSERT INTO txuNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nhym kam ajte memã õ àpênh krãptĩ jano nhym me ajte ã aro ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nhym kam tekrekam me'ỳr kra jano. Nãm amim, “Godja ikra me'ỳr bôx nhym me arỳm mar jabej”, ane. Ne arỳm me'ỳr kra jano nhym me'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nhym o djuw mex djwỳnh arỳm kra pumũn abenmã kum, “Be, kra ne wã. Gwaj on kubĩ. Tãmja dja bãm kum mỳjja kunĩ ngã, õ nêkrêx kunĩ kanga. Gwaj on tãmja bĩn kam amim õ nêkrêx, õ mỳjja, õ pidjôja kunĩo aminhõ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ne kam arỳm o tỹm. O tỹm ne pidjôkô kurũm bõm kumẽn arỳm kubĩ. Tãm ne ja, ane. Me rũnh'ã ne Jeju pidjô pumũnh djwỳnh jakre. Me kute mrãmri ne me rũnh pyràk. Ne kam ajte memã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","—Mỳj gêdja õ pidjôkô djwỳnhja bôx ne ajmã pidjô pumũnh djwỳnh on? Nãm Jeju ã me rũnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nhym me kum, —Bir, dja prĩne me axwejao ajkẽn me imex ne kam õ pidjôkôja atemã me ja'õmã kungã nhym me arỳm pidjô tukkam arỳm kum pidjô nhõrkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nhym kam Jeju ajte memã me kukãmãre kabẽn jarẽn memã kum, —Amrẽbê: ne me bakukãmãre Metĩndjwỳnh kabẽn jarẽn memã kum, “E kum kẽn ja ne me kute kikreo ãm djwỳnhja kute kikremã armã te omũn kam bõm kumẽ. Kẽn ja ne arỳm kute kikremã o kajpar, kum o kajpar tỳxi. Bẽnjadjwỳr djwỳnh ta ne ã kẽno ane gu me omũ nhym kam gu bamã mexkumrẽx.” Nãm ã me bakukãmãre memã anen arỳm 'ã pi'ôk no'ôk ne. Djãm me aje omũnh ne mar kêt? Nãm Jeju ã me rũnhmã ane. Nãm amijã kẽn jakre. Ne me rũnh'ã kikreo ãm djwỳnh jakre. Me rũnh kute mrãmri ne kikreo ãm djwỳnh pyràk ne arỳm Jeju kanga. Me rũnh kute kanga'ã ne Jeju me rũnhmã ja jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ne kam ajte memã kum, —Ba me amã arẽ ga me ama. Metĩndjwỳnh bit kute amim me apytàr ne ar me ajo bamã. Nhym be, kati. Dja me akangan me apãnh amim me bajtem pytàn meo ba. Nhym me kam arỳm kute pidjô djô mex pyràk ne imã mexkumrẽx ne axwe kêt. Nãm Jeju ã me rũnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ne kam ajte memã kum, —Ẽ, kẽn ja gêdja ga me ajõ 'ã tỹm ne prĩne 'ã amikrakrak ne. Nhym be, ta gêdja me ajõ nhiby tỹm ne prĩne angãn prĩne pyka mẽ ajo amrà, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jeju memã ja jarẽ. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebê pardjêumã ja jarẽ nhym me arỳm kuman amim, —Be, me bajã ne pidjôo djuw mex djwỳnhmẽ kikreo ãm djwỳnh jakren me bamã 'ã ajarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ne kam me bit kute o tỹmmã te 'ã amijakre. Me krãptĩ ne me Jeju'ã amim, —Be, Metĩndjwỳnh kukwakam memã 'ã ujarẽnh ba, ane. Nhym kam me me umaje te 'ã amijakre. ");
INSERT INTO txuNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nhym kam Jeju ajte apỹnh kukràdjà djàri'ã memã mỳjja jakren memã 'ã ajarẽn memã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Kàjkwakam Bẽnjadjwỳr djwỳnh kute amim me utàr ne ar meo ba'ã dja ba bẽnjadjwỳr rax'õ jakren 'ã ajarẽ gar ama. Be, bẽnjadjwỳr rax arỳm kute kra'ã prõ mẽnhmã. Amrẽbê ne kadjy memã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ne kam arỳm kute amrẽbê memã arẽnhja'ỳr õ àpênh ar ano. Kute abenã ar mẽnh djà'ỳr me 'wỳr kadjy ar ano. Nhym ar me'ỳr bôx ne memã arẽ. Nhym me arỳm arkum, —Kati, 'ỳr ar imõr prãm kêt, ane. Nhym kam ar akubyn bẽnjadjwỳr'ỳr bôx ne arỳm kum arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nhym kam õ àpênh 'õdjwỳ arkum, —Dja gar amrẽbê ije memã arẽnhjamã ikabẽn jarẽn memã kum, “Ẽ, arỳm ne ba me akadjy inhõ jadjuw nhym kumex. Inhõ mrytimẽ abatành nyre twỳmtijamẽ ne me arỳm kupa. Arỳm ne ba mỳjja kunĩo mex. Dja ga me amrẽ abenã ar mẽnh djà'ỳr mõ”, ane. Dja gar ã memã ane. Nãm ã bẽnjadjwỳr arkum ane. Nhym ar arỳm me'ỳr tẽn kôt memã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nhym me ate krã. Me kwỳ ja ne me õ purmã mõ nhym me kwỳ ja õ nêkrêx'ỳr mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nhym me kwỳ ja ne me arỳm aro rôrôk ne aro ajkẽn arỳm ar kupa. ");
INSERT INTO txuNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nhym kam bẽnjadjwỳr rax arỳm arẽnh man arỳm ngryk ne. Ne kam arỳm õ krãkamngônh krãptĩmã 'ã karõn me'ỳr me ano. Nhym me arỳm kabẽnkôt me'ỳr mõn arỳm me'ỳr bôx. Me'ỳr bôx ne arỳm me kupan mebê krĩraxmã adjà nhym arỳm xêr. ");
INSERT INTO txuNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nhym kam ajte bẽnjadjwỳrja õ àpênh arkum, —Ije abenã ar mẽnh kadjy ne ba arỳm prĩne mỳjjao mex nhym nõ. Nhym be, ije memã arẽnhja ne me kadjy mex kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jakam dja gar apỹnh pry bikjêr djàri kôt tẽn ar aje me omũnh kunĩ memã akrà gê me amrẽ mõ gwaj baro'ã banhõ kwỳ krẽ gwaj bakĩnh kati, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kam, õ àpênh ar arỳm apỹnh pry djàri kôt tẽn arỳm kute me omũnh kunĩo atomo tẽ. Me mex nàr me punu kunĩo atomo tẽ:n meo bôx. Nhym me kam prĩne abenã ar mẽnh djàkam kikre kre jaê. ");
INSERT INTO txuNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nhym kam arỳm bẽnjadjwỳr rax wadjàn me omũnho tẽ. Nhym wãnh me'õ dja. Kute abenã me rẽnh'ỳr me ngjêx kadjy me õ kubẽkà jadjàr kêt ne dja. ");
INSERT INTO txuNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nhym arỳm omũn kum, —Akmere, nã gãm abenã me rẽnh'ỳr me ngjêx kadjy me õ kubẽkà jadjàr kêt ne wadjà. Mỳj ne ga nẽn wadjà? ane. Nhym arỳm te kute aminêje kum kabẽn'õ jarẽnhmã. ");
INSERT INTO txuNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nhym kam bẽnjadjwỳr rax õ àpênhmã kum, —Dja gar inỳx 'ãpren te 'ãpren amũ o tẽn bõm amẽ. Wãnh ne me akamàt kô tykkam amim ngryk ne mỳro kumex ne tokry djàje amijanênho kumex. Me ikô'ã dja gar amẽ, ane. Nhym me ã me'õo ane. Tãm ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Be, Metĩndjwỳnh ne amiwỳr me krãptĩ 'uw. Nhym be, kute mekam me ngrêrebit amijo me utàr. Nãm Jeju ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nhym kam mebê pardjêu arỳm mã tẽn Jejuo aben ma. Nãm me abenmã kum, —Mỳj gêdja gwaj Jejumã arẽ nhym arỳm gwaj bamã bẽnjadjwỳr'ã kabẽn punu'õ jarẽ? Dja bẽnjadjwỳr'ã kabẽn punu jabej nhym me arỳm kum axwe jarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nãm me aben man kam arỳm 'ỳr õ me ja kwỳ jano. Erodji nhõ me ja kwỳ ne me adjwỳnhdjwỳ 'ỳr me ano. Nhym me 'ỳr bôx ne kum, —Ujarẽnh djwỳnh, bar arỳm ama. Ga ne ga akabẽn katàtkumrẽx ne Metĩndjwỳnh kabẽn kôt me kute amijo ba'ã memã adjujarẽnh katàtkumrẽx. Amã me rũnh pyma kêt. Me rũnhmẽ me kajgomẽ ne ga memã akabẽno aben pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ba me akukja ga me imã arẽ. Me rũnh kunĩ nhõ bẽnjadjwỳr raxbê Xedja. Mebê idjaer kute o me bajtemja. Djãm Metĩndjwỳnh kukràdjà kôt ne gu me baje bẽnjadjwỳr Xedjamã pi'ôk kaprĩ nhõrmã? Nàr kon? Goja on me imã arẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nhym Jeju arỳm me axwe kôt tu me kuman memã kum, —Me ga ne ga me amijo ajêx ne amijo Metĩndjwỳnh mar mexo aba. Nok ba ren me amã, “Metĩndjwỳnh kabẽn kupa'ã ne me kum õro ba”, ane ga me ren memã kum, “Be, Jeju axwekumrẽx. Ga, kute bẽnjadjwỳr raxbê Xedjabê pi'ôk kaprĩ nê prãmja pumũ”, ane. Ga me ren memã anen ren arỳm memã ikurêtuw. Nã gãm me ajêx ne aje Metĩndjwỳnh mar. ");
INSERT INTO txuNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Amrẽ imã pi'ôk kaprĩo tẽ, me aje kum õrja o tẽ ba me amã omũ, ane. Nhym me arỳm 'ỳr ngônhponho pi'ôk kaprĩ pydjio tẽn kum kungã. ");
INSERT INTO txuNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nhym memã kum, —Mỳj me'õ ne 'ã karõja? Ne mỳj me'õ ne 'ã idji jêtja? ");
INSERT INTO txuNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nhym me kum, —E kum be Xedja karõ, ane. Nhym memã kum, —Bir be, õ pi'ôk kaprĩ. Dja ga me kum angã. Nhym be, Metĩndjwỳnh nhõ mỳjjabit dja ga me Metĩndjwỳnhmã angã. Nãm Jeju ã memã ane nhym me arỳm kabẽn ma. ");
INSERT INTO txuNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ne arỳm te kute mỳjja'õ jarẽnhmã kam no tyn dja. Ne kam arỳm kum kàx ne mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nhym kam myt tãmkam mebê xadjudjêu kwỳ 'ỳr bôx. Mebê xadjudjêu ne me arĩk memã kum, —Be, me tyk akubyn tĩn prãm kêtkumrẽx, anhỹr ar o ba. Nãm me 'ỳr bôx ne kukij ne kum, ");
INSERT INTO txuNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Ujarẽnh djwỳnh, me bakukãmãre Môjdjê ne amrẽbê: me bamã, “Godja me'õ prõ'ỳr mõn kra kêt rã'ã tyk jabej mỳj dja me nẽ? Bir, dja kamymẽ ar aben djàkam ikwãja'õ 'ỳr mõ. Ne kum kra djin kukrij nhym abatành ne. Me kute 'ã abenmã kum, ‘Be, kamy tyk kra ne wã’, anhỹr ne kute kamy tyk mar tỳx rã'ã kadjy.” Nãm ã me bakukãmãre Môjdjê me bamã ane, ane. Mebê xadjudjêu ne me ã Jejumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ne kôt arĩk kum, —Be, ar my aben djàkam ikwãbê 7. Ne kam kutewa prõ'ỳr mõ. Ne kam kra kêt rã'ã ty. Nhym prõja arỳm 'uwtĩ. Nhym kam atãri kamyreja 'ỳr mõ. Ne kam ã ane, kra kêt rã'ã ty. ");
INSERT INTO txuNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nhym aben totokmã Ar kubê 7 kunĩ kudjwa ã anen 'ỳr ban kra kêt rã'ã ty. ");
INSERT INTO txuNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nhym kam ar prõjadjwỳ arỳm ar o ino ren ty. Ja ne ba me kuman amã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ar kubê 7 ne ar aben totokmã kamy prõ'ỳr ba. Godja we ar kunĩ akubyn tĩn ne àbir jabej we àbirkam nhỹnh kamyja dja ajte 'ỳr mõ? ane. Me ta kute we me tyk akubyn tĩn kêt jarẽnh mỳr jabej ne me ã Jejumã ane. Me kute o àpanh nhym binhikrênh kadjy nàràm ne mebê xadjudjêu ã kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nhym Jeju arỳm memã kum, —Me aje Metĩndjwỳnh kabẽn'ã pi'ôk no'ôk mar kêt ne me aje Metĩndjwỳnh tỳ:xkumrẽx mar kêt. Nã gãm me arĩk Metĩndjwỳnh kupa'ã memã 'ã adjujarẽnh aba. ");
INSERT INTO txuNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Be, me tyk ne akubyn tĩnkam djãm me ajte abenwỳr ba? Kati, akubyn me tĩnkam dja me abenwỳr ba prãm kêtkumrẽx. Kam dja me kute Metĩndjwỳnh kadjy mrãnh djwỳnh pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Be, mrãmri me tyk akubyn tĩnkumrẽx. Amrẽbê: Metĩndjwỳnh kute me bakukãmãremã kabẽn jarẽnh. Me tyk akubyn tĩn'ã kute kabẽn jarẽnh nhym me kute 'ã pi'ôk no'ôk djãm me aje amim arẽnh kêt? ");
INSERT INTO txuNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nãm me bakukãmãremã kum, “Ibê Abraãomẽ Idjakmẽ Djako ar õ Metĩndjwỳnh”, ane. Bir be, ar tyk tũmja Metĩndjwỳnhmã tĩn ne ar ba nĩj pumũ. Djãm Metĩndjwỳnhbê me tyk nhõ Metĩndjwỳnh? Kati. Metĩndjwỳnh ne me tĩn nhõ Metĩndjwỳnh. Me tyk kunĩ ne me kum tĩn. Kam ne ba me amã, —Metĩndjwỳnh ne kubê me tĩn nhõ Metĩndjwỳnh. Nãm Jeju ã mebê xadjudjêumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nhym me krãptĩ: kuman te kute mỳjja'õ jarẽnhmã kam no tyn kumex. ");
INSERT INTO txuNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jeju mebê xadjudjêumã ane nhym me amijã maje arỳm anhikrê. Amijã maje anhikrê nhym mebê pardjêu arỳm arẽnh man arỳm akuprõ. ");
INSERT INTO txuNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Me'õbê ne Môjdjê kukràdjà mar djwỳnh. Tãm ne Jeju'ỳr bôx ne kute amak mex jabej kabimã. Kute Môjdjê kukràdjà jabej kukjêrmã. Jeju kute kukràdjà kupa'ã arẽnh kadjy nàràm ne kum kabẽn ne kum, ");
INSERT INTO txuNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ujarẽnh djwỳnh, Môjdjê kute Metĩndjwỳnh kukwakam kabẽn kukràdjà jarẽnh, kute kam me kute katàt amijo ba'ã memã karõja nhỹnh kabẽnja ne mexo kute kunĩ jakrenh? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nhym Jeju kum, —Be, nãm memã kum, “Me anhõ Bẽnjadjwỳr djwỳnh, me Atĩndjwỳnh dja ga me amã kĩnh, amã abêo katàt me kunĩ, mỳjja kunĩ jakre. Djãm ajajkwaobit amã Metĩndjwỳnh jabêmã? Kati. Ajamak, akadjwỳnhbê, akukràdjà kunĩo dja ga me amã abê:”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Be, tãm ne ja. Metĩndjwỳnh kabẽn mexo kute kabẽn kunĩ jakrenh ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ne kam atãri Môjdjê ajte 'õ kute uràk memã arẽn memã kum, “Me amã amibu'ã me ja jabê. Kute mrãmri ne ga me amã amijabêja pyràk dja ga me ã amã amibu'ã me ja jabêo ane”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Be, ba arỳm amã Môjdjê kabẽn kukràdjà ja jarẽn ajte amã ja jarẽ. Dja ga amẽ kabẽn ja man kôt ar amijo aba jabej ne mrãmri tu arỳm Metĩndjwỳnh kabẽn kukràdjà kunĩkôt ar amijo aba mexkumrẽx. Môjdjê kute Metĩndjwỳnh kukwakam kabẽn jarẽnhjamẽ kukwakam memã 'ã ujarẽnh djwỳnh 'õdjwỳ kute kabẽn jarẽnhjamẽ ne ga arỳm kunĩkôt ar amijo aba mexkumrẽx. Nãm ã Jeju kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mebê pardjêu kute abeno bikprõnhri Jeju amijabej me kukij ne memã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Mỳj ne ga me Kritukam ama? ane. Metĩndjwỳnh ne arỳm mebê idjaer kadjy Jeju'ã Bẽnjadjwỳrbê kumkati mẽ. Kumã ne me Kritu jarẽ. Nãm Jeju amijã memã kum, —Mỳj ne ga me Kritukam ama? Mỳj me'õ tàmdjwỳbê ne Kritu? ane. Nhym me kum, —Me bakukãmãre Dawi tàmdjwỳ. Bẽnjadjwỳr raxbê Dawi tàmdjwỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Nhym kam Jeju ta kubê Bẽnjadjwỳr Kritu'ã memã kum, —Ne kam ajte kubê Dawi nhõ Bẽnjadjwỳr. Mỳj ne arỳm kubê Dawi tàmdjwỳn ajte õ Bẽnjadjwỳr kadjy nẽ? ane. Ne kam Jeju memã me bakukãmãre Dawi kabẽn jarẽn memã kum, —Be ga, me bakukãmãre Dawi ta kute memã 'ã ujarẽnhja pumũ. Metĩndjwỳnh Karõ kukwakam kute memã Kritu'ã ujarẽnhja pumũ. Nãm memã kum, “Inhõ Bẽnjadjwỳrmã ne Bẽnjadjwỳr djwỳnh kabẽn ne kum, ‘Amrẽ idjubôk'ãnh nhỹ, Abẽnjadjwỳr raxkam idjubôk'ãnh nhỹ. Ikam ama ba amrẽ awỳr akurê djwỳnho mõ ga me kwỳo apardjan me kwỳ nhimex.’ Nãm ã Metĩndjwỳnh inhõ Bẽnjadjwỳrmã ane”, ane. Bir be ga, Dawi kute kum “Abẽnjadjwỳr rax”, anhỹrja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mỳkam ne me Dawi tàmdjwỳ kajgo jarẽ? Djã nãm o tàmdjwỳ kajgo? Kati, Dawi ta ne kute o õ Bẽnjadjwỳr rax. Nãm ã Jeju mebê pardjêumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nhym me'õ te kute kutã kabẽn'õ jarẽnhmã te amijo ane. Kabẽn mex pymaje me kute ajte mỳjja 'õ jabej kukjêr kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nhym kam Jeju me krãptĩ:mẽ kôt ba djwỳnhmã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Be, Môjdjê kukràdjà mar djwỳnhmẽ mebê pardjêumẽ ne me Môjdjê pãnh ar amã Metĩndjwỳnh kukràdjà jarẽnho krĩ. ");
INSERT INTO txuNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kam dja me Metĩndjwỳnh kabẽn kôt ar amã kabẽn jarẽ gar prĩne me kabẽn kunĩ man kôt ar amijo aba. Nhym be, me ta ne me arĩk ar ba. Nãm me ajkwakambit ar amã Metĩndjwỳnh kabẽn jarẽn kam ta kute amikabẽn mar ne kôt kute ar amijo ba kêt ne arĩk ar ba. Kwãrĩk wãnh mekôt ar amijo aba kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nãm me ajte kabẽn kajgoobit ar memã we Metĩndjwỳnh kabẽn jarẽnho ba. Djãm Metĩndjwỳnh kabẽn? Kati, me ta kabẽno ne me ar me anoro ba. Ne kam kôt kute amijo ba kêt ne. Nhym me te amijo anen kam, “Je mỳj dja ba me nẽ”? ane. Me kute ã meo anhỹrkam ne kute mrãmri ne me kute me kadjybit jênh rũnho atom ne me mut'ã anhôr ne kam kute memã tur kêtkumrẽx ja pyràk. Nãm ã Jeju memã ane. Ne kam ajte arkum, ");
INSERT INTO txuNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","—Me kute memã amibẽn nhym me kute memã mex jarẽnh kadjy ne me amijo ba. Môjdjê kukràdjà'ã pi'ôk no'ôk kwỳ ne me 'ã ikôn amikrãmẽ amipamã aktã 'ãpre. Ne 'ã ikô poti:reo ane. Mỳj kadjy? Bir, me kute memã amibẽn kadjy. Dja we me me omũn memã mex jarẽ. Ja kadjy ne me 'ã ikô poti:reo anen amikrãmẽ amipamã aktã 'ãpre. Ne kam ajte 'ã kubẽkà jabu djà ã abjêo ane. Mỳj kadjy? Bir, me kute memã amibẽn kadjy. Dja we me me omũn memã mex jarẽ. Ja kadjy ne me 'ã kubẽkà jabu djà jabjên 'ã ar ba. ");
INSERT INTO txuNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Me krãptĩ nhikô'ã me õ kwỳ krẽnkam ne me me rũnh krĩ djàkam krĩ prãmkumrẽx. Kute memã amibẽn kadjy me rũnh krĩ djàkam krĩ prãmkumrẽx. Ne mebê idjaer bikprõnh djàkam ne me memã wan krĩ prãmkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ne ajte me krãptĩ bikarêr nhipôkri, mekadu nhipôkri kute memã amibẽn nhym me kute memã rũnh jarẽnh ne kute memã kum, “Ujarẽnh djwỳnh, djãm ga? djãm ga”? anhỹrja. Ja ne me kum kĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nhym be, ar ga me kute ar amã, “Ujarẽnh djwỳnh”, anhỹrmã djãm ar amã ja kĩnhmã? Kati. Mỳkam? Bir, atemã ar anhõ ujarẽnh djwỳnh pydjii. Kam dja gar abeno akamybit. ");
INSERT INTO txuNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ne kam djãm ar aje pykakam me'õ raxmã, “Djũnwã”, anhỹrmã? Kati. Mỳkam? Bir, ar Abãm pydji. Kàjkwakam ar Abãm djwỳnh pydjii. ");
INSERT INTO txuNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Djãm me kute ar amã, “Bẽnjadjwỳr”, anhỹrmã? Djãm ar amã ja kĩnhmã? Kati. Mỳkam? Bir, ar anhõ Bẽnjadjwỳr pydjii. Metĩndjwỳnh ne arỳm 'ã me õ Bẽnjadjwỳrbê kumkati mẽ. Kubê ne Kritu. ");
INSERT INTO txuNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ar ajõ abenkam araxo kutewa prãm jabej gêdja amijo kajgon tu ar amã àpênh ar ba. ");
INSERT INTO txuNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mỳkam? Bir, me kute amijo rũnh prãmja gêdja ĩ kajgo mex ne. Nhym be, me kute amijo kajgo mex ne akrànmã kute amijo baja gêdja Metĩndjwỳnh arỳm pãnh meo rũnh ne. Nãm ã Jeju arkum ane. Ne kam Môjdjê kukràdjà mar djwỳnhmẽ mebê pardjêumã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","—Be, me abê Môjdjê kukràdjà mar djwỳnhmẽ me abê pardjêumẽ ne ga me amijo ajêx ne ar amijo Metĩndjwỳnh mar mexo aba. Ỹ, watĩre. Dja ga me ĩ me biknor tokry djàkam tu amõrkumrẽx. Mỳkam? Bir, me aje mebê adjàptàrkam. Me bit kute kàjkwakam Bẽnjadjwỳr djwỳnh kôt ãm ne kôt ar amijo ba prãm ga me kupa'ã memã arẽ. Ne Bẽnjadjwỳr djwỳnh nêje aje memã atemã kukràdjà jarẽnho aban arỳm o mebê utà. Ga me kam ga Metĩndjwỳnh mar kêt ne ajte me jadjwỳbê aptà. ");
INSERT INTO txuNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Be, me abê Môjdjê kukràdjà mar djwỳnhmẽ me abê pardjêumẽ ne ga me amijo ajêx ne ar amijo Metĩndjwỳnh mar mexo aba. Ỹ, watĩ:re, dja ga me ĩ me biknor tokry djàkam tu amõrkumrẽx. Mỳkam? Nã gãm me me 'uwtĩ krão apan mebê mỳjja kunĩo akĩ ne kam ajajkwaobit Metĩndjwỳnhmã akabẽn rũnh ne, ne kum akabẽn 'ijabjêo aku'ê. Bir, nã gãm me ajêx ne amijo amex ne kum akabẽno aku'ê. Be kati, me ajaxwekumrẽx. Kam gêdja Metĩndjwỳnh me kuràm me amã pãnh rax jarẽn prĩne me kuràm me ajo ajkẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Be, me abê Môjdjê kukràdjà mar djwỳnhmẽ me abê pardjêumẽ ne ga me amijo ajêx ne ar amijo Metĩndjwỳnh mar mexo aba. Ỹ, watĩ:re. Dja ga me ĩ me biknor tokry djàkam tu amõrkumrẽx. Mỳkam? Bir ga, me aje arĩk memã kum, “Ba me Metĩndjwỳnh'ỳr meo akẽx gê me amim maro ba”, anhỹrja pumũ. Djãm mrãmri ne ga me akabẽn? Kati, me aje amiwỳr me'õ pydjio akẽx kadjy ngômẽ pykakôt aba 'ijabjê:. Nhym arỳm me awỳr amijo akẽx ga me kam arỳm amikôt axwe 'ã mẽnh mex ne. Amikôt axwe 'ã mẽnh mex nhym arỳm axweo me ajakrenh mex ne. Nhym arỳm me akôt biknor prãmkumrẽx. Djãm Metĩndjwỳnh'ỳr ne ga me meo akẽx nhym me amim kuma got? Kati. Nãm ã Jeju Môjdjê kukràdjà mar djwỳnhmẽ mebê pardjêumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ne kam ajte memã kum, —Ỹ, watĩ:re. Dja ga me ĩ me biknor tokry djàkam tu amõrkumrẽx. Me aje mrãmri ne me no rã kute arĩk meo ba pyràk. Mỳkam? Bir, me aje arĩk memã Môjdjê kukràdjà jarẽnh punukam. Nãm ã Jeju memã ane. Bir, Môjdjê kukràdjà kôt ne mebê idjaer memã amikabẽn jarẽn ajte memã kum, —Nã bãm amã ikabẽn pydjin arẽ, anen ajte kôt memã Metĩndjwỳnh nhõ mỳjja jarẽ. Mỳj kadjy ne kôt memã Metĩndjwỳnh nhõ mỳjja jarẽ? Bir, kute kabẽn maro ãmja kute mar pydji kadjy ne me Metĩndjwỳnh nhõ mỳjja jarẽ. Gêdja amikabẽn jarẽnhja 'êx ne kam Metĩndjwỳnh nhõ mỳjja jarẽn kam arỳm o Metĩndjwỳnhmã amikurêtuw. Amikurêtuw nhym Metĩndjwỳnh arỳm kute maro ãmjao ngrykmã. Nãm me ã Môjdjê kukràdjà kôt memã amikabẽn jarẽnho ane. Nãm Jeju Môjdjê kukràdjà jarẽnh djwỳnh arkum, —Me aje mrãmri ne me no rã kute arĩk meo ba pyràk. Mỳkam? Bir, me aje arĩk memã Môjdjê kukràdjà jarẽnh punukam. Nã gãm me memã kum, “Dja ga me memã amikabẽn jarẽn memã kum, ‘Nã bãm amã ikabẽn pydjin arẽ. Ẽ, Metĩndjwỳnh nhõ kikretija ma’, ane. Gêdja ga me memã ajêx prãm jabej ne Metĩndjwỳnh nhõ kikretibit jarẽ ne kam o amikurê'uk kêt. Dja Metĩndjwỳnh me'õ kute akabẽn maro ãmjao ngryk kêt ne me ajo bikẽnh kêt. Nhym be, dja ga me memã amikabẽn jarẽn memã kum, ‘Nã bãm amã ikabẽn pydjin arẽ. Ẽ, Metĩndjwỳnh nhõ kikretikam kẽn karỳrja ma’, ane. Aje kẽn karỳr jarẽnhkam dja ga akabẽnkumrẽx. Aje memã amikabẽn jarẽnh kôt dja ga amijo anhỹrkumrẽx. Dja ga memã ajêx ne kam kẽn karỳr jarẽn arỳm o Metĩndjwỳnhmã amikurêtuw” ane. Me abê Môjdjê kukràdjà mar djwỳnh ne ga me arĩk ã memã kukràdjà jarẽnh punuo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Me no rã ne me kute amikukãm rĩt kêt. Kam me kute amipry mar kêt. Me aje me uràk ne amijo ajêx ne memã, “Ba ne ba ije Metĩndjwỳnh mar mex”, anhỹr ar o aba. Nhym be, kati. Me aje mar kêt ne te memã Metĩndjwỳnh'ã adjujarẽnh ar aba nhym me adjwỳnhdjwỳ kute mar kêt. Be, me amãbit ne kẽn karỳr kute mexo kikreti jakrenh. Djãm mrãmri? Kati. Kikreti ne kute mexo kẽn karỳr jakrenh. Kikreti kukwakambit ne kẽn karỳr mex. Metĩndjwỳnhmã mex. Nãm Jeju ã Môjdjê kukràdjà mar djwỳnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ne ajte memã kum, —Ga me arĩk memã kum, “Dja ga me memã amikabẽn jarẽn memã kum, ‘Nã bãm amã ikabẽn pydjin arẽ. Ẽ, Metĩndjwỳnh nhõ ngônho kija ma’, ane. Gêdja ga me amã memã ajêx prãm jabej ne Metĩndjwỳnh nhõ ngônho kibit jarẽ ne kam o amikurê'uk kêt. Dja Metĩndjwỳnh me'õ kute akabẽn maro ãmjao ngryk kêt ne me ajo bikẽnh kêt. Nhym be, dja ga me memã amikabẽn jarẽn memã kum, ‘Nã bãm amã ikabẽn pydjin arẽ. Ẽ, Metĩndjwỳnh nhõ ngônho kikam mry nõrja ma’, ane. Aje mry nõr jarẽnhkam dja ga akabẽnkumrẽx. Aje memã amikabẽn jarẽnh kôt dja ga amijo anhỹrkumrẽx. Dja ga memã ajêx ne kam mry nõr jarẽn arỳm o Metĩndjwỳnhmã amikurêtuw”, ane. Me abê Môjdjê kukràdjà mar djwỳnh ne ga me arĩk ã memã kukràdjà jarẽnh punuo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Me aje me no rã pyràk. Djãm mrãmri mry kute mexo Metĩndjwỳnh nhõ ki jakrenh? Kati. Õ ki ne kute mexo mry jakrenh. Õ kikam me kute mry jadjwỳrkambit ne kum mex, Metĩndjwỳnhmã mex. Nãm Jeju ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ne kam ajte memã kum, —Kam, me kute memã amikabẽn jarẽnh ne kôt ajte kute Metĩndjwỳnh nhõ ki jarẽnhkam djãm kute õ kibit jarẽnh? Kati. Nãm me kute õ ki jarẽnh ne ajte kute kam mỳjja kunĩ ikwãdjwỳ jarẽnh. ");
INSERT INTO txuNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ne ajtekam me kute memã amikabẽn jarẽnh ne kôt ajte kute Metĩndjwỳnh nhõ kikreti jarẽnhkam djãm kute kikretibit jarẽnh? Kati. Nãm me kute kikreti jarẽnh ne ajte kute Metĩndjwỳnh kam ỹr jarẽnh. ");
INSERT INTO txuNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ne ajtekam, me kute memã amikabẽn jarẽnh ne kôt ajte kute kàjkwa jarẽnh. Djãm kute kàjkwabit jarẽnh? Kati. Nãm kute kàjkwa jarẽnh ne ajte kute Metĩndjwỳnh nhõ krĩ djà rax jarẽnh ne ajte kute 'ã krĩ djwỳnhbê Metĩndjwỳnh jarẽnh. Kam, dja me memã kabẽn pỹnh ne arẽn kôt amijo anhỹrkumrẽx. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ne kam ajte memã kum, —Be, me abê Môjdjê kukràdjà mar djwỳnhmẽ me abê pardjêumẽ ne ga me amijo ajêx ne ar amijo Metĩndjwỳnh mar mexo aba. Ỹ, watĩ:re. Dja ga me ĩ me biknor tokry djàkam tu amõrkumrẽx. Mỳkam? Bir, me aje Metĩndjwỳnhmã mỳjja kakritbit nhõr ne kam mỳjjabê kumkatija aje kum õr kêtkumrẽxkam. Nã gãm me mỳjja kakrit, õmrõ djành djà, pi'ômẽ õmrõ djành djà 'õdjwỳmẽ Metĩndjwỳnhmã ikjê rên kum kryre ne angã. Ne kam kukràdjà kôt ar amijo aba kêt ne katàt meo aba kêtkumrẽx ne amã me kaprĩ kêtkumrẽx ne amim Metĩndjwỳnh mar kêt ne. Aje kum kryre ne õrja ne mrãmri tu mexkumrẽx. Mỳkam ne ga me kum mỳjjabê kumkatijadjwỳ kum õr kêt ne? Mỳkam ne ga me amã Metĩndjwỳnh jabên katàt meo abaja kêt ne? Ja ne ga me aje marmãn ate mỳjja kakritbit ma. ");
INSERT INTO txuNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ba me amã arẽ ga me ama. Dja me anhõ õmrõkam pure'õ tỹm ga me pure ngrire'ã ano tỳ:x ne kaban mũm amẽ. Nhym be, mry jabatànhbê kameru ja ne anhõ õmrõkam dja, ga me ate akrãn tu ro'ã krẽ. Be, mỳj'ã ne ba amã ikabẽn ja jarẽ? Bir, mỳjja kryre ne ga me'ã ano tỳ:x ne ma:ro aba. Nhym be, mỳjja bê kumkati, mỳjja kabẽnkumrẽx ne ga me aje mar kêt. Metĩndjwỳnh kabẽn kute me ajaxwe nêje me akukràja ne ga me aje mar kêt ne ate akrãn ajaxwe rax rã'ã. 'Ã ne ba me amã, “Ga me pure ngrire'ãbit ano tỳx ne kaban mũm amẽn tu kameru raxja õmrõmẽ ro'ã krẽ”, ane. Kam ne ga me aje meo ba djwỳnh no rã pyràk. Nãm Jeju ã memã ane. Ne kam ajte memã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Be, me abê Môjdjê kukràdjà mar djwỳnhmẽ me abê pardjêumẽ ne ga me amijo ajêx ne ar amijo Metĩndjwỳnh mar mexo aba. Ỹ, watĩ:re. Dja ga me ĩ me biknor tokry djàkam tu amõrkumrẽx. Mỳkam? Bir, nã gãm me aje mrãmri ne me kute ngônhkrãmẽ ngônh puror nhibũmbit põnh ne kre põnh kêt nhym krekam mỳjja kakrãtyk pyràk. Be, nã gãm me ã we katàt amijo abao ane. Nhym kam me me akrãkàbit pumũ nhym kam kute me amex pyràk. Nhym be kati, me akadjwỳnhbê ne ga me apunu rã'ã. Me akadjwỳnhbê ne me amã me õ nêkrêx prãm ne 'ã angryk ne aje mebê mỳjjao adjàkĩnh'ã aje amim karõ rã'ã. Kam ne ga me akadjwỳnhbê apunu rã'ãja. ");
INSERT INTO txuNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Me abê pardjêu ne ga me aje me no rã pyràk. Dja ga me akadjwỳnhbê kumrẽx wãnh ajaxwemã anhire. Ne kam arỳm mrãmri abu'ã memã amexkumrẽx. Ne kam aje mrãmri ne me kute ngônh puror, kremẽ ibũm põnh nhym prĩne mex pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Be, me abê Môjdjê kukràdjà mar djwỳnhmẽ me abê pardjêumẽ ne ga me amijo ajêx ne ar amijo Metĩndjwỳnh mar mexo aba. Ỹ, watĩ:re. Dja ga me ĩ me biknor tokry djàkam amõrkumrẽx. Mỳkam? Bir, ga me aje mrãmri ne me kute me tykmã kikre krãkà jaka pyràk. Krãkàkambit ne kute memã mexti:re pyràk. Nhym be, kadjwỳnhbê ne mỳjja punu:re. Kadjwỳnhbê me tyk 'imẽ mỳjja punu kunĩ. ");
INSERT INTO txuNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ga me aje uràk. Abu'ã memã ajaxwe kêt pyràk. Nhym be, kati. Metĩndjwỳnh ne me akadjwỳnhbê me aje mỳjja marja kunĩ kute mar. Me ga ne ga me amijo ajêx ne ar amijo Metĩndjwỳnh mar mexo aban aje ajaxwebit mar. Nãm ã Jeju memã ane. Ne kam ajte memã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—Be, me abê Môjdjê kukràdjà mar djwỳnhmẽ me abê pardjêumẽ ne ga me amijo ajêx ne ar amijo Metĩndjwỳnh mar mexo aba. Ỹ, watĩ:re. Dja ga me ĩ me biknor tokry djàkam amõrkumrẽx. Mỳkam? Bir, amrẽbê: me bakukãmãrekam ne Metĩndjwỳnh kabẽn jarẽnh djwỳnh arỳm ty nhym me amrẽbê: me angij. Ga me akamingrãnyre ne ga me me tyk tũmjamã kikren me katàt kute amijo ba tũm nhõ pyka krã kunhêro aba. ");
INSERT INTO txuNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ne kam arĩk memã kum, “Ne ba me ren amrẽbê: me bakukãmãre, me banhingêt kator nyri ren me ro'ã ikator ne ar iba ne ren me banhingêt kudjwa ã anhỹr kêtkumrẽx ne. Ne ren Metĩndjwỳnh kabẽn jarẽnh djwỳnh par kêtkumrẽx ne.” Nã gãm me ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Me aje ã memã anhỹrkam arỳm amikôt amijarẽ. Me abê me par djwỳnh tàmdjwỳ, Metĩndjwỳnh kabẽn jarẽnh djwỳnh kanê tàmdjwỳ. Arỳm ne ga me amikôt amijarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Metĩndjwỳnh ne me anhingêtkam ngryk. Aje, me rã'ã ne me anhingêt kôt ã ajaxweo anen ar badjwỳ ar ipa. Ar badjwỳ ar ipa gê Metĩndjwỳnh on me akam ngryk me:x ne. Nãm ã Jeju memã ane. Ne kam ajte memã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","—Me akamingrãnyre ne ga me abê kangã, me abê iry. Djãm me ga ne ga me aje abiknorbê amipytàrmã? Kati. Me biknor tokry djàbê me aje amipytàr prãm kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kam arỳm ije me awỳr me anormã. Ije me awỳr ikabẽn jarẽnh djwỳnh janormã. Ije ajte me awỳr me no mex janormã. Ije ajte me awỳr me kukràdjà mar djwỳnhkumrẽx janormã. Dja ga me kam arỳm me kwỳ pa, pĩte'y'ã me kwỳmo iten me kupa. Ne me abikprõnh djàkam mry kà punuo me kwỳ kaprêprêk. Ne aje meo abikẽnh kadjy me abej mõ, apỹnh krĩrax djàri kôt me abej mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Me akukãmãremẽ nã gãm me me katàt kute amijo ba kunĩ paro tẽ. Paro tẽn paro tẽn arek me kamrô kapĩn o tẽ. Nhym Metĩndjwỳnh arỳm meo ngryk ne kam gormã me ajabatànhmã pãnh jarẽ. Me akukãmãre ne me Abeu jaxwe kêtja bĩno kurêtuw ne kam ijukri me ja paro tẽm tãmtã: arek o tẽ ne kam Djakarij, Berakij kute irja'ỳr bôx ne kam Metĩndjwỳnh nhõ kikretimẽ õ ngônho ki kaêxkam kubĩ. ");
INSERT INTO txuNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ẽ, ba me amã arẽ. Metĩndjwỳnh ne arỳm meo ngryk ne. Ne kam me akamingrãnymã arỳm pãnh jarẽ. Me ga dja Metĩndjwỳnh me akukãmãre kute me imex tũmja pãnh me ajo ajkẽ. Mrãmri ne ba me amã arẽnhkumrẽx. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ne kam krĩraxmã kum, —Djeruxarẽ, Djeruxarẽ, mỳkam ne akra kute Metĩndjwỳnh kabẽn jarẽnh djwỳnh par prãm ne? Mỳkam ne me kẽno me titik ne me kupa, Metĩndjwỳnh kute me awỳr me anorja pa? Je nã bãm te ije me ajo ibikprõnh ne ije me ajo atommã. Kute mrãmri ne õkrẽn'ãnh kute arao noreo bikprõnhja pyràk. Ba ren ã me ajo ane. Nã bãm te ije me ajo anhỹrmã ga me amã ikĩnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ẽ, jakam me amõr djà ja gêdja kukrit mex ne kaprỳn nõ. ");
INSERT INTO txuNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ẽ, ba me amã arẽ ga me ama. Jakam dja ga me ipumũnh kêtkumrẽx ne. Ipumũnh kêt rã'ã: nhym inhõ akati ijo rãm ne jao tẽ ga me abenmã kum, “Ẽ, ota arỳm Metĩndjwỳnh kabẽnkôt tãmja bôxmã. Me:xkumrẽx”, ane. Dja ga me ã abenmã ane ba kam arỳm me awỳr bôx. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ne kam Metĩndjwỳnh nhõ kikreti kurũm kato. Nhym kôt ba djwỳnh 'ỳr bôx. Ar kute kikretikam apỹnh kum kikre jakre kadjy 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ne kam ar arỳm kum akre nhym Jeju arkum, —Ar mỳjja kunĩ pumũnho dja. Ẽ, ba ar amã katàt arẽ. Be, dja ĩ me kurê djwỳnh prĩne kikreti ngrà. Dja me kẽn aben nhiby ikwã kunĩ nhikô rê. Nhym kam kẽn'õ aben nhiby nõr kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ne kam ar tẽn kam krãnhbê Oriwêre'ã wabi nhym arỳm ate nhỹ. Nhym kam kôt ba djwỳnh 'ỳr bôx ne me kàxã kum, —Dja ga ar imã kikreti ngrành'ã ajarẽ. Nhỹnh amex 'õkam dja me bakurê djwỳnh me bawỳr bôx ne kikreti ngrà? Dja ga akubyn bôx nhym mỳjja kunĩ arỳm pyka kôt amingrà nhym me kunĩ arỳm pykakam ar ba'ã aminhinomã amimẽ. Mỳj gêdja kukãm apôx? Dja bar omũn kam kôt õ akatimã ikaton õ akati ma. ");
INSERT INTO txuNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nhym kam Jeju arkum apỹnh mỳjja kukãm apôxmã arkum 'ã ajarẽn arkum, —Ar amijã ano tỳx gê me'õ ar amã 'êx ne ar anoo biknor ne Metĩndjwỳnhbê ar ajo akẽx kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Be, me krãptĩ dja ĩ aben totokmã me'ỳr bôx ne arỳm amijo 'êx ne amijã imẽ. Amijã imẽn arỳm memã kum, “Me anhõ Bẽnjadjwỳrbê kumkati kadjy ne Metĩndjwỳnh ijano ba tẽn bôx. Ba ibê Kritu”, ane. Ne kam arỳm me krãptĩ noo aknon Metĩndjwỳnhbê meo akẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Be, kam dja gar me kute abenwỳr prõt man amybỳm me kute abenwỳr prõt jarẽnh ma. Kwãrĩk wãnh kam ar atĩn prãm kêt. Ba ne ba kukãm ar amã 'ã ajarẽ gar arỳm ama. Ja kumrẽx gêdja me ã o anhỹro tẽ. Kraxje kute inomã mẽnh kêt, kute 'ỳr o tẽm rã'ã, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nà, apỹnh me ba djàri gêdja me abenwỳr prõt ne aben nhimexo ba. Nhym apỹnh bẽnjadjwỳr rũnh nhõ àpênhja abeno kurê djwỳnh ne aben nhimexo ba. Nhym prãmdjwỳ me kwỳ nhimex. Apỹnh pyka djàri gêdja kam pyka terte:t ne. ");
INSERT INTO txuNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Be, me tokry krax ne ja. Ga me nire kra àja pumũ. Adjỹm. Dja kra à:n kam arỳm à ra:x ne. Me adjwỳnhdjwỳ dja me tokry mõ:n kam arỳm tokry ra:x ne. Be, me tokry krax ne ja. Nãm ã Jeju arkum ane. Ne kam ajte arkum, ");
INSERT INTO txuNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Dja me tokry: nhym kam me arỳm memã ar akanga. Me kute ar ajo bikẽnho ba kadjy ar akanga. Nhym me arỳm ar apa. Apỹnh me bajtem ba djà kunĩkôt dja me kum ar akurê. Ikôt ar abikamẽnhkam dja me kum ar akurê. ");
INSERT INTO txuNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kam dja me krãptĩ ibê amijo akẽx. Ne kam me kurê djwỳnhmã aben kangan kum aben kurê. ");
INSERT INTO txuNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Me krãptĩ dja me ta amijo 'êx ne amijã Metĩndjwỳnh kabẽn jarẽnh djwỳnh rẽ. Amijã kurẽn memã kum, “Metĩndjwỳnh kukwakam ne ba ar amã arẽ”, anhỹro ba. Dja me ã amijo 'êxo anen arỳm me krãptĩ noo aknon Metĩndjwỳnhbê meo akẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Me krãptĩ kum Metĩndjwỳnh kĩnhja dja me arỳm kum kĩnh apêx. Pyka kunĩkôt me krãptĩ axweo kume:x. Me axweo kumexkam dja me arỳm kum kĩnh apêx. ");
INSERT INTO txuNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nhym be, dja mỳjja kunĩ kute amingrành nhõ akati bôx. Me kunĩ kute aminhinomã amimẽnh nhõ akati bôx. Nhym kam me 'ã ukanga kêt ne kum kĩnh tỳx rã'ãja dja Metĩndjwỳnh arỳm me utà. ");
INSERT INTO txuNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mỳjja kute amingrành kêtri dja me apỹnh pyka kunĩkôt memã arẽ. Bẽnjadjwỳr djwỳnh'ã ujarẽnh nyja memã arẽ. Apỹnh me ba djà kunĩkôt me kute ujarẽnh mar kadjy memã arẽ. Nhym kam akati arỳm bôx. Me kunĩ kute aminhinomã amimẽnh nhõ akati arỳm bôx. Ba ne ba kukãm ar amã 'ã ajarẽ gar arỳm ama. Nãm ã Jeju arkum ane. Ne kam ajte arkum, ");
INSERT INTO txuNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","—Be, ar aje ajbir imã, “Dja ga ar imã kikreti ngrành'ã ajarẽ”, anhỹrja ba ar amã arẽ gar ama. Dja mỳjja kute amingrành 'ỳr nhym kam arỳm mỳjja punutija dja. Metĩndjwỳnh nhõ kikretikam dja. Gar arỳm omũ. Mỳjja punuti djô'ã dja me mỳjja kunĩo ajkẽ ne kungrà. Me bakukãmãre Danijeu ne amrẽbê: 'ã ajarẽ. Metĩndjwỳnh kukwakam memã 'ã ajarẽ. Danijeu ne arỳm memã mỳjja punuti ja'ã ajarẽn 'ã pi'ôk no'ôk. Dja gar pi'ôk no'ôkwã pumũn kam mỳjja punuti pumũn kam kôt ama. ");
INSERT INTO txuNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kam gêdja Djeruxarẽ bu'ã pyka ja nhidjibê Djudêjakam me ja amijã maje krãnh'ỳr prõt ne. ");
INSERT INTO txuNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Gêdja me kikre nhimõk po'ã ãm jabej kwãrĩk wãnh akubyn ũrkwãkam nêkrêx'ỳr àr ne byr ne o tẽm kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gê purkam me ar ba jabej tu umaje prõt. Kwãrĩk wãnh me kute kubẽkà jamỳnhmã 'ỳr akẽx kêt. Dja tu me ãm kamã amũ prõt. ");
INSERT INTO txuNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ỹ, watĩ:re, akati wãkam me tujarômẽ me kra karà dja me tokry:. Mỳj gêdja me ja mỳjja punutija pymaje prõtja on? ");
INSERT INTO txuNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dja gar Metĩndjwỳnhmã amijo a'uw gê na raxkam umaje ar aprõt kêtmã. Nàr, gê pi'ôk ràràrbê me tyk djà kêt nhõ akatikam ar aprõt kêtmã. ");
INSERT INTO txuNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Be, dja me kam tokry kumex. Dja gar akubyn amijo tẽn mỳjja kunĩmo krax djà'ỳr amijo bôx ne ama. Me akukãmãre aben kukãm tokrykôt dja gar maro tẽ. Me tokry tũm maro tẽ:n amiwỳr me tokry maro bôx. Ga, me tokry kume:xja pumũ. Be, amrẽ mỳjja punuti nhõ akati bôxkam dja me tokryo katàt me tokry tũmwã kunĩ jakre. Ne amrẽ me'ã akati mõrkam me tokry nydjwỳ dja me tokryo mỳjja punuti'ã me tokryja têp kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Metĩndjwỳnh ren tokry'ã akati kwỳ ngri kêt nhym me'õ ren tĩn kêtkumrẽx. Be, Metĩndjwỳnh kute amijo me utàrja kadjy dja arỳm 'ã akati wã kwỳ ngri. ");
INSERT INTO txuNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Godja me'õ 'êx ne ar amã, “Ota, jakam arỳm Kritu bôx ne nhỹ. Arỳm ne Metĩndjwỳnh 'ã me õ Bẽnjadjwỳrbê kumkati mẽ nhym jakam arỳm memã nhỹ”, anhỹr jabej nàr me'õ ajte 'êx ne ar amã, “Ota, jakam arỳm Kritu bôx ne nhỹ. Arỳm ne Metĩndjwỳnh 'ã me õ Bẽnjadjwỳrbê kumkati mẽ nhym jakam arỳm memã nhỹ”, anhỹr jabej. Djãm ar aje me ja marmã? Kati. Kwãrĩk wãnh amim me ja mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Be, apỹnh me 'êx ne ta kute amijo Kritu, ta kute amijo Bẽnjadjwỳrbê kumkati dja me apôx. Nhym amũ me jadjwỳ dja me apôx ne 'êx ne memã kum, “Ba ne ba Metĩndjwỳnh kukwakam me amã idjujarẽnh iba”, anhỹro ba. Dja me me aêrbê mỳjja pumũnh kêt kwỳ nhipêx, kute me noo biknor nhym me kute me'ã abenmã kum, “Mrãmri ne djãm Metĩndjwỳnh kukwakam me kabẽnkumrẽx”, anhỹr kadjy. Godja me me noo biknor ne Metĩndjwỳnhbê meo akẽx jabej, Metĩndjwỳnh kute amrẽbê amijo me utàrja kubê meo akẽx ne kute meo ba jabej. Me 'êxnhĩ no tỳxo kute me akrenh jabej godja kubê me kwỳo akẽx ne meo ba jabej. ");
INSERT INTO txuNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ba ne ba mỳjja apôx kêtri kukãm ar amã 'ã ajarẽ gar arỳm ama. Nãm ã Jeju arkum ane. Ne kam ajte arkum, ");
INSERT INTO txuNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—Kam godja me'õ ar amã, “Ẽ, onĩj kapôt kukritkam arỳm bôx ne ar ba”, anhỹr jabej. Djãm 'ỳr ar amõrmã? Kati, dja gar tu ate akrãn 'ỳr amõr kêt. Nàr, godja me'õ ar amã, “Ẽ, kikre jakam ne apdjun nhỹ”, ane. Djãm ar aje amim me marmã? Kati. Kwãrĩk wãnh amim me mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Djãm ibôx ne mebê ibipdjur? Kati. Ga, kàjkwakam na krak ne adjênhja pumũ. Na jadjênh prõt ne arỳm myt ngjêx djàmã ngjêxja pumũ. Adjênh kute kàjkwa kunĩ kurwỳja pumũ. Dja ba ã ibôxo ane. Ije amijo inhĩ dja ba ã ibôxo ane nhym me kunĩ arỳm ipumũ. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nhym kôt ba djwỳnh bôx djà jabej kukij ne kum, —Bẽnjadjwỳr, nhỹnh jakam dja ga bôx, ane? Nhym arkum, —Ga me, nhônh ne mry tyk'ã bikprõnh ne kumex ne kute o amirĩtja pumũ, ane. Dja ã Jeju akubyn bôx kutã mỳjja apôx ne bôx djào amirĩto ane. Nãm ã Jeju arkum ane. Ne kam ajte arkum, ");
INSERT INTO txuNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—Nhym me tokryo ku'êwã'ã akati kwỳ apêxkam dja on mỳjja rũnh apôx. “Dja myt amijo akamàt kô tyk nhym mytyrwỳ irã kêt. Nhym kanhêti kàjkwa kurũm rôrôk nhym kàjkwakam apỹnh mỳjja tỳ:x amingrẽk ne.” ");
INSERT INTO txuNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ba kam ije amijo inhĩ dja ba kàjkwakam amirĩt nhym me arỳm ipumũ. Nhym kam pyka kunĩkôt me ba djàkam me kunĩ arỳm mu:w. Ba kam ije amijo inhĩ dja ba arỳm itỳ:x ne prĩne imextire ne ipyma:. Ne kam kàjkwakam kakrãkôt bôx nhym me kunĩ: arỳm ibôxkôt ipumũ. ");
INSERT INTO txuNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dja ba ikadjy mrãnh djwỳnh jano nhym me arỳm õ'i kakôr tỳ:x ne. Kakôr tỳx ne arỳm ije amijo me utàrja kunĩo atom. Dja me kàjkwa krax'ãm mõn meo atomo mõ. Ne kàjkwa 'ênhôt'ãm mõn meo atomo mõ. Ne aktã kàjkwa nhirê'ãm mõn meo atomo mõ. Ne apỹnh pyka kunĩkôt inhõ me ja kunĩ: abenwỳr meo atomo mõn meo aben pydji. Ba ne ba kukãm ar amã 'ã ajarẽ. Gora abej ajkam ama. ");
INSERT INTO txuNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Be, akubyn ibôx djà nhõ akatija'ã ne ba ije pidjôbê pigêre jakremã. Gora ije 'ã mỳjja jakreja ma. Ba ar amã arẽ gar ama. Be, dja pidjô pakà nokà tukam 'ô nhingrã kadjy arỳm ingrã apôx gar kam arỳm amexmã kamnhĩx nhym kam arỳm amex. ");
INSERT INTO txuNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bir be, gêdja ba ije ar amã mỳjja jarẽnhja ã apôx mõr ane gar me kam arỳm ijabej rĩt ne ijabej ajkam ama. Akubyn ibôx djà arỳm 'ỳr. 'Ỳr dja mỳjja apôxja. Amex kutã gêdja pi'ô ingrã. Nhym be, ibôx kutã gêdja mỳjja pymatija apôx mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nà, mrãmri ne ba ar amã kôt arẽ. Ar anhõ pykakam me kamingrãny ja gêdja me tyk par kêtri mỳjja ja kunĩ apôx. Mrãmri ne ba ar amã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ikabẽn kajgo kêtkumrẽx. Gêdja pykamẽ kàjkwa ĩ apêx nhym be, ba ikabẽn gêdja 'õ biknor kêtkumrẽx. Mrãmri gêdja ba ije mỳjja jarẽnh ja kunĩ apôx nhym me omũ. ");
INSERT INTO txuNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ne kam ajte arkum, —Be, ba akubyn ibôx djà nhõ akati nàr myt djãm me'õ kute mar? Kati, me'õ kute mar kêtkumrẽx. Metĩndjwỳnh kadjy mrãnh djwỳnhdjwỳ kute mar kêt. Ibãmbit ne kute mar. ");
INSERT INTO txuNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Be ga, amrẽbê me bakukãmãre Nôwe pykakam ar bari me ate krãn ar baja pumũ. Dja ba ibôx 'ỳr nhym me ã ane. Ije amijo inhĩ dja ba akubyn ibôx 'ỳr nhym me ate krãn ar ba. ");
INSERT INTO txuNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Amrẽbê: ngô kute pykao bikamỳr kêtri ne me bakukãmãre ate krãn ar õ kwỳ krẽnbit ba ne ar kõmbit ba. Ne abenwỳr babit ar ba. Nãm me me mymã kra jarẽ ne memã kum, —Nà, jakam dja ga arỳm tu ikra'ỳr mõ, anhỹro ba nhym me arỳm me'ỳr ba. Nãm me mỳjja jabit kôt amak bẽno ba: nhym kam Nôwe arỳm kà raxmã wadjà. ");
INSERT INTO txuNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nãm me amikukãm mỳjja mar kêtkumrẽx ne ar ba: nhym me aêrbê ngô tàm mõn me kunĩo mõn prĩne meo akno. Ije amijo inhĩ dja ba akubyn ibôx 'ỳr nhym me ã anen ate krã nhym mỳjja arỳm ã meo ane. ");
INSERT INTO txuNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nhym me'õ my ar amẽ kapôtkam tẽ. Ba ikjê pa 'amỳ nhym ikjê arek wakrekam dja. ");
INSERT INTO txuNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nhym me'õ nire ar amẽ à'uko nhỹ. Ba ikjêbit pa 'amỳn o tẽ nhym ikjêja arek wakrekam nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kam dja gar arek ijabej ajkam ama. Mỳkam? Bir, ar aje akubyn ibôx'ã myt mar kêtkam. Ba ibê ar anhõ Bẽnjadjwỳr djwỳnh ar aje akubyn ibôx'ã myt mar kêtkam. ");
INSERT INTO txuNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Dja gar ikabẽn ma. Ba ajte ar amã 'õdjwỳ jarẽ gar ama. Ne ren õ kikre djwỳnhja ren me àkĩnhĩ bôx djà man ren kam ren arek kam amako nhỹ. Nhym ren bôx ne kikre'ã 'yr ne kum àr kêtkumrẽx. Badjwỳ dja ba ije me àkĩnhĩ pyràk ne me ajaêrbê bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kam gêdja gar gadjwỳ mã ikam amako nhỹ. Ba ije amijo inhĩ ne me awỳr ibôx ba gêdja ba ajte akubyn bôx. Ar aje nhỹnh myt nhỹr 'õkam aje ibôx djà mar kêt. Kam gêdja ba tu ar ajaêrbê bôx. Nãm ã Jeju arkum amibôx djà jarẽnho ane. Ne kam ajte arkum, ");
INSERT INTO txuNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—Me õ bẽnjadjwỳr ne õ àpênhmã kabẽn ne kum, “Ga dja ga me àpênh'ã me omũ ne prĩne 'ã meo djuw mex. Ne myt kunĩkôt memã õ kwỳ krẽn djà ngãn akrànmã memã õro aba.” Nãm ã õ àpênhmã me'ã karõo ane. Kute akrànmã me àpênh'ã me omũnh ne kute 'ã meo djuw mex katàtmã ã kum me'ã karõo ane. Nhym õ àpênh kum, “Nà, gêdja ba mrãmri ã anen kam me 'ãno dja”, ane. Nhym kam õ bẽnjadjwỳr mã nhĩ'ãm tẽ. Nhym kam õ àpênhja kabẽnkumrẽx. Nãm katàt ar memã mỳjja nhõro ba, me kanga kêtkumrẽx ne ar meo ba. ");
INSERT INTO txuNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nhym kam bẽnjadjwỳr akubyn bôx ne kam õ àpênhjamã kato. Kute amrẽbê kum kabẽn jarẽnhja kôt ne mrãmri meo djuw mexkumrẽx nhym kam arỳm kum kato. Kam dja õ àpênhjadjwỳ tu amikam kĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ẽ, ba ar amã kôt arẽ. Bẽnjadjwỳrja dja õ àpênh ja'ã bẽnjadjwỳr mẽ. Kute nêkrêxmẽ mỳjja kunĩ pumũnhmã dja 'ã bẽnjadjwỳr mẽ. Nhym kam õ àpênhja kĩnhkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nãm ren õ àpênhja axwen ren õkre kadjwỳnhbê õ bẽnjadjwỳrja'ã ren, “Be, nãm nhĩ'ãm bẽnjadjwỳr tẽn arỳm amikrà. Jakam dja ba on tu arĩk ar iba”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ne kam ren ar õ àpênhja titiko ba, me ro'ã àpênhja ren ar me titiko ba. Ren õ kwỳ krẽnbit ban me bibãnhkôt ren kadjwati kangôo kõmo ba. ");
INSERT INTO txuNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nhym kam õ bẽnjadjwỳrja aêrbê bôx. Õ àpênhja kute amim õ bẽnjadjwỳrja bôx djàkôt mar kêt. Nhỹnh akati 'õkam bôx djàmã kute mar kêt ne nhỹnh myt nhỹr 'õkam bôx djàmã kute mar kêtkam ne aêrbê bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nãm bôx ne kam õ àpênh arĩk ar bajakam ngryk ne. Ngryk ne kam o ajkapôn bõm kumẽ. Me kute amijo 'êx ne ta kute amijo Metĩndjwỳnh mar mexjamẽ ro'ã ãm kadjy bõm kumẽ. Wãnh ne me amim ngryk ne tokry djàje amijanên ar àmra ba, ane. Nãm Jeju ã kôt ba djwỳnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ne kam ajte arkum, —Kàjkwakam Bẽnjadjwỳr djwỳnh dja akubyn bôx ne amim me utàn ar meo ba. 'Ã dja ba me prĩtirebê 10 jakren 'ã ar amã ajarẽ. Be, mjên kumrẽx ne arỳm prõ nhũrkwã'ỳr tẽn 'ỳr bôx ne arỳm aminhũrkwã'ỳr kute prõo bôxmã. Me kute abenã ar mẽnhmã ne aminhũrkwã'ỳr kute prõo bôxmã. Nhym nĩjar me prĩtirebê 10 arkam ama. Ar ro'ã kĩnh kadjy arkam ama. Arkam ama:n kam arỳm kute ar kajpar kadjy arỳm katon ar'ỳr ngônhpôko mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ar prĩtirebê 5 ne ar no rerekre nhym Ar kubê 5 ne ar no mexkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ar no rerekreja ngônhpôkkambit kangôo mõn ngônhpôk kangô 'õdjwỳo mõr kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nhym be, ar amak mexja ne ar ngônhpôko mõn ajte ngônh 'õdjwỳkam ajte kangô 'õdjwỳo mõ. Ar amũ mjênmẽ prõ ar'ỳr ngônhpôko mõ:. ");
INSERT INTO txuNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nhym mjên ar amikrà nhym prĩtireja ar arỳm õtdjwan dja:n arỳm nõn kam arỳm ngõr. ");
INSERT INTO txuNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nhym akamàt kô ipôkri nhym me'õ arỳm ar aêrbê mjên aro aki:j ne arkum, “Ẽ, arỳm ne prõo bôx. Amrẽ ar aprõt ne ar kajpa”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nhym kam ar prĩtire kunĩ krã katon arỳm ngônhpôko mex. ");
INSERT INTO txuNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nhym no rerekre arja arỳm amak mex ar jamã kum, “Ar imã ar anhõ kuwy kangô kwỳ ru. Arỳm ar inhõ ngônhpôk àtyk mõ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nhym ar arkum, “Kati. Ngrire. Ba ren ar ar amã kangô kwỳ ru nhym ren kangô gwaj banhõ ngônhpôk'ỳr ren bôx kêt. Ar ngônhpôk kangô nhõr djwỳnh'ỳr mõn amim kwỳ kõpra”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nhym kam ar no rerekre arỳm kõpra djà'ỳr mõ. 'Ỳr mõrràm nhym arỳm mjênmẽ prõ ar bôx. Nhym kam ar prĩtire, ar õ ngônhpôk kangôja arỳm mjênmẽ arkôt wadjà. Me kute prõ'ã mẽnh djàkam kikremã wadjà. Mjênmẽ prõmẽ ro'ã ar õ kwỳ krẽn kĩnh kadjy ne ar prĩtire ar kôt kikremã wadjà. Nhym kam me arỳm ar pãnh kikre'ã ijê. ");
INSERT INTO txuNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nhym kam ajmã nhym ar prĩtire no rerekreja bôx. Ar arỳm kuwy kangô kõpra djàkam tẽn kangô kõpran arỳm akubyn bôx. Ne kam mjênmẽ prõ nhõ kikre'ỳr bôx ne kum, “Bẽnjadjwỳr, bẽnjadjwỳr, gop ar imã kikre'ã ta”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nhym arkum, “Kati. Ije ar amar kêt. Mrãmri ne ba ar amã arẽnhkumrẽx.” Nãm ã bẽnjadjwỳr arkum ane. Tãm ne ja. Nãm ã Jeju kôt ba djwỳnh arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ne kam 'ã ajte arkum, —Dja ba ije mjênwã bôx pyràk. Kam dja gar ijabej ajkam ama. Ba ije amijo inhĩja ar aje ibôx'ã akati nàr myt mar kêt. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ne kam ajte arkum, —Kàjkwakam Bẽnjadjwỳr djwỳnh dja akubyn bôx ne arỳm amim me utàn ar meo ba. 'Ã dja ba me'õ jakren 'ã ar amã ajarẽ. Me'õja ne anhỹr bê pyka 'õmã tẽmmã, ne amiwỳr õ àpênh ar ku'uw. Nhym kam ar bôx nhym arỳm arkum õ mỳjja ngã. ");
INSERT INTO txuNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Apỹnh ar kum àpênh mexkôt ne arkum õ mỳjja ngã. Ar kute kutêp kum kàjmã 'ã kamẽnhmã ne arkum kungã. Õ àpênh no mexjamã ne pi'ôk kaprĩ rax ngã. Pi'ôk kaprĩbê tarẽtubê 5 ne kum kungã. Ne kam ajte kàjbê no mexjamã pi'ôk kaprĩo amãnhkrut ne kungã. Ne kam ajte no rerekre jamã pydjin kungã. Ne kam arỳm mã pyka 'õmã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nhym kam kute pi'ôk kaprĩbê 5 byrja arỳm o nêkrêx kumex by. Ne kam pi'ôk kaprĩ pãnh arỳm memã õro dja. Memã õro dja: nhym me pãnh kum pi'ôk kaprĩ rax nhõro dja. Nhym amỳn arỳm 'ã akre. 'Ã akre:n arỳm 'ã akrebê 5 ne kuby ne kam ijukri 'ã akre: ne o 5 ne kuby. ");
INSERT INTO txuNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nhym kam kute pi'ôk kaprĩo amãnhkrut byrja ã o anen o nêkrêx kumex by. Ne kam pi'ôk kaprĩ pãnh arỳm memã õro dja. Memã õro dja: nhym me pãnh ajte kum pi'ôk kaprĩ rax nhõro dja. Nhym amỳn arỳm 'ã akre. 'Ã akre:n arỳm 'ã akreo pi'ôk kaprĩo amãnhkrut ne kuby ne kam ijukri 'ã akre: ne kam o amãnhkrut ne kuby. ");
INSERT INTO txuNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nhym be, kute pi'ôk kaprĩ pydji byrja ne mã o tẽn kam kum kren tu kam adjà. Nãm kàjmã kum 'ã akre bikamẽnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nhym kam ajmã:kam ar àpênh nhõ bẽnjadjwỳrja bôx ne amiwỳr ar ku'uw nhym ar 'ỳr bôx. Kute akubyn õ pi'ôk kaprĩ jamỳnh ne 'ã akre kadjy amiwỳr aro bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nhym kute pi'ôk kaprĩbê 5 byrja ne kum o bôx ne kum ajte ijukri 5 ne o bôx ne kum kungãn kum, “Bẽnjadjwỳr, ije amã omũnh kadjy ne ga imã 5 ne angã. Ota, ba arỳm kàjmã amã 'ã akre kamẽ nhym arỳm kubê 10. Mĩ, anhõ pi'ôk kaprĩbê 10”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nhym õ bẽnjadjwỳr kum, “Mexkumrẽx. Ga ne ga adjàpênh mexkumrẽx. Akabẽnkumrẽx. Nã bãm amã mỳjja ngrire ngã ga prĩne ikutêp imã o djuw mex ne 'ã adjukanga kêt. Pãnh gêdja ba amã inhõ mỳjja rax jarẽ. Ga kam amũ idjô'ã ar o aba. On dja ga ikôt akĩnhkumrẽx”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nhym kam kute pi'ôk kaprĩ amãnhkrut byrja ne ajte 'ỳr bôx ne kum, “Bẽnjadjwỳr, ije amã omũnh kadjy aje imã o amãnhkrut ne õrja ne ba arỳm kàjmã amã 'ã akre kamẽ nhym arỳm kubê 4. Mĩ, anhõ pi'ôk kaprĩbê 4”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nhym õ bẽnjadjwỳr kum, “Mexkumrẽx. Ga ne ga adjàpênh mexkumrẽx. Akabẽnkumrẽx. Nã bãm amã mỳjja ngrire ngã ga prĩne ikutêp imã o djuw mex ne 'ã adjukanga kêt. Pãnh gêdja ba amã inhõ mỳjja rax jarẽ. Ga kam amũ idjô'ã ar o aba. On dja ga ikôt akĩnhkumrẽx”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nhym kam kute pi'ôk kaprĩ pydji byrja ne 'ỳr bôx ne kum, “Bẽnjadjwỳr, nã gãm ajamakkre kêt. Nã gãm adjàkre kêtkam ar mebê djwỳo atomo aba. Ne aje amim mỳjja kunĩ jadjwỳr kêtkam ar mebê jãm o amijakren o atomo aba. ");
INSERT INTO txuNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ba kam ije amã kupênh prãm kêtkam prĩne kum kren kam adjà nhym nõ. Imã apymakam. Mĩ, anhõ pi'ôk kaprĩ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nhym kam õ bẽnjadjwỳr kum, “Ga ne ga ajaxwekumrẽx. Amã djukangakumrẽx. Djã nã bãm idjàkre kêtkam ar mebê djwỳo atomo iba ne ije amim mỳjja kunĩ jadjwỳr kêtkam ar mebê jãm o amijakren o atomo iba? ");
INSERT INTO txuNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bir be, ga kam we ga aje amim ipumũnhkôt ren inhõ pi'ôk kaprĩ jao tẽn ren me kute pi'ôk kaprĩ marmã angã nhym ren abenã rôrôk tẽn rax ba ren arỳm 'ỳr bôx ne arỳm ren kuby.” Nãm õ bẽnjadjwỳr ã kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ne kam memã kum, “Aj, amũ me ajõ kubê pi'ôk kaprĩwã byn o tẽn kute imã pi'ôk kaprĩo àptàr nhym kubê 10wãmã angã”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mỳkam? Bir, arỳm me õ mỳjja gêdja Metĩndjwỳnh iby memã kungã nhym kam arỳm me õ mỳjja kumex. Nhym be, me õ mỳjja kêt, kute memã õr nhym me kute kum o djuw mex kêtjabê gêdja Metĩndjwỳnh mỳjja ngrireja kunĩ by. Ẽ, ba ar amã arẽ gar ama. Me kute tu amim imarkumrẽx jamã dja Ibãm ijo amirĩto tẽ gê me amim imar rax. Nhym be, me ajkwaobit kute amim imarjabê dja Ibãm ijo apdju. Dja prĩne inêje me no nhityn mebê ijo apdju. ");
INSERT INTO txuNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Be, nhym kam bẽnjadjwỳr memã kum, “Aje, me bõm inhõ àpênh punuwã mẽ gê wãnh akamàt kô tykkam ar me ikô'ã ba. Wãnh ne me tokry djàje amijanên ar àmra ba. Nãm ã bẽnjadjwỳr memã ane nhym me arỳm bõm kumẽ. Tãm ne ja.” Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ne kam ajte arkum, —Ba ije amijo inhĩ dja ba prĩne imex ne ipyma:n arỳm akubyn bôx. Ne amikôt Metĩndjwỳnh kadjy mrãnh djwỳnh kunĩo bôx. Ne kam kàjkwakam imexo ime:xkumrẽx ne ipyma:kumrẽx ne arỳm ikrĩ djà raxkam nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nhym kam apỹnh me ba djà kunĩkôt dja me ikabem akuprõ ba arỳm meo ajkij. Kute mryo ba djwỳnh kute õ mryo bikjêr pyràk. Kute aben bê mrykĩ'ãtomtimẽ mokaàko bikjêr pyràk. Dja ba arỳm ã aben bê meo ibikjêro ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ne inhõ me mex kute mrykĩ'ãtomti pyràk ja dja ba amidjubôk'ãnh me umjuw. Ne me axwe kute mokaàk pyràk ja dja ba amidjuge'ãnh me umjuw. ");
INSERT INTO txuNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ne kam ba Ibẽnjadjwỳr rax idjubôk'ãnh me mex ku'êjamã kum, “Amrẽ me iwỳr mõn ikôt aku'ê. Ba ibê me anhõ Bẽnjadjwỳr djwỳnh dja ba arỳm me ajo ibakumrẽx. Amrẽbê: mỳjja kunĩ kator djà kraxkam ne Ibãm arỳm amijo me apytàn me ajo djuw mex. Ije amim me apytàr ne ije me ajo iba kadjy amijo me apytà. ");
INSERT INTO txuNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mỳj ne ga me nẽ ba kam arỳm amikôt me apumjuw? Bir, arỳm imã prãm ga me imã mỳjja'õ ngã ba kukrẽ. Arỳm imã kôr ga me imã mỳjja 'õ ngã ba o ikõ. Nãm me ijo me bajtem ga me arỳm imã anhũrkwã jarẽ ba kam inhikwã. ");
INSERT INTO txuNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Arỳm ikà kêt ga me arỳm imã kubẽkà ngã ba adjà. Arỳm ikanê ga me arỳm ikane. Arỳm me ibê ijê ga me arỳm iwỳr bôx ba ikĩnh. Kam ne ba arỳm amikôt me apumjuw”, ane. Akubyn ibôxkam dja ba ã idjubôk'ãnh me katàt kute amijo bajamã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nhym kam dja me imã, “Bẽnjadjwỳr djwỳnh, nhỹnh ne ga amã prãm ba me apumũn amã mỳjja ngã ga krẽ? Nhỹnh ne ga amã kôr ba me amã mỳjja'õ ngã ga o ikõ? ");
INSERT INTO txuNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nhỹnh ne me kute ajo me bajtem ba me apumũn amã inhũrkwã jarẽ ga kam anhikwã? Nhỹnh ne ga akà kêt ba me amã kubẽkà ngã ga adjà? ");
INSERT INTO txuNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nhỹnh ne akanê ba me apumũ? Nhym nhỹnh ne me abê ijê ba me awỳr bôx ga akĩnh”? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kam, ba Ibẽnjadjwỳr rax dja ba memã kum, “Ije meo ikamy'õ nhym me kum kurê. Nhym arỳm õ mỳjja kêt. Ga me kam arỳm o djuw mex. Aje o djuw mex o aje ba ijo djuw mex pyràk. Mrãmri aje o djuw mexkam aje ba ijo djuw mex mexkumrẽx”, ane. Dja ba ã akubyn ibôxkam me mexmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kam dja ba idjuge'ãnh me axwe ku'êjamã kum, “Me apunu:re. Me rũm imã akàx. Kuwy pôk rã'ã: rã'ãjamã me mõ. Ije Xatanajmẽ kadjy mrãnh djwỳnh kadjy kuwy nhipêxjamã me mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mỳj ne ga me nẽ ba me amã, ‘Me rũm imã akàx’? ane. Bir, imã prãm ga me aje imã mỳjja nhõr kêt. Imã kôr ga me aje imã ngô'õ nhõr kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Me kute ijo me bajtem ga me aje imã anhũrkwã jarẽnh kêt. Ikà kêt ga me aje imã kubẽkà nhõr kêt. Ikanê ga me iwỳr abôx kêt nhym me ibê ijê ga me iwỳr abôx kêt. Ga me ã ane ba kam me amã, ‘Me rũm imã akàx’, ane.” Dja ba ã idjuge'ãnh me axwe ku'êjamã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Me axwewãdjwỳ dja me imã, “Bẽnjadjwỳr djwỳnh, nhỹnh ne ga amã prãm nàr amã kôr nàr me ajo me bajtem nàr akà kêt nàr akanê nàr me abê ijê ba me ajo djuw mex kêt”? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kam dja ba memã kum, “Bir, ikamy 'õ me kum kurê nhym õ mỳjja kêt ga me aje o djuw mex kêt. Aje o djuw mex kêt o ne aje ba ijo djuw mex kêt pyràk”, ane. Mrãmri, ba me amã ja jarẽnhkumrẽx. Dja ba ã akubyn ibôxkam me axwemã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kam dja me arỳm mã mõn tokry rã'ã: rã'ã ne. Nhym be, me katàt kute amijo baja dja me Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jeju arkum kabẽn jarẽnh pan kam arỳm kôt ba djwỳnh arkum, ");
INSERT INTO txuNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Arỳm ne Metĩndjwỳnh me bakukãmãre nhirôbê mrãnh djà nhõ akati 'ỳr. Mebê idjaer krãptĩ kute aben kajmã'ã me irôbê mrãnh djà mar kadjy ne me kute aben pydji 'ỳr. Arỳm nêje akati pydji. Tãm ne gar arỳm ama. Kam ba ije amijo inhĩja dja me memã ikanga nhym me arỳm pĩte'y'ã inhôn ibĩ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nãm arkum ane nhym wãnh me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax nhỹ. Idjibê ne Kajbaj. Õ kikretikam ne nhỹ nhym me rũnh arỳm kam akuprõ. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ mebêngêtmẽ akuprõ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nãm me akuprõn abenmã kum, —Mỳj godja gwaj me krãptĩ kàxã Jejuo tỹm ne bĩn kadjy on? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ne kam abenmã kum, —Kwãrĩk wãnh gwaj me kute aben pydji djà nhõ akatijakam o batỹm kêt. Ne gwaj ren o ane nhym me krãptĩ ren o ngryk ne ren kangao kumex, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Be, krĩ ngrirebê Betanhakam ne Jeju nhỹ. Kamã ne me'õ ĩ kajêkam tê arỳm mex. Idjibê ne Ximão. ");
INSERT INTO txuNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ximão nhũrkwãkam ne Jeju õ kwỳ krẽno nhỹ. Õ kwỳ krẽno nhỹ: nhym me'õ nire arỳm 'ỳr tẽn 'ỳr bôx. Nãm 'ỳr kẽn jakareo ngônh byn o tẽ. Be, ngônhkam ne me kudjỳ djà kangôo ipu. Nãm me prĩne ipêx mex nhym pãnh raxkumrẽx. Nãm ngônho tẽn kam Jeju nhimõk'ã kangô kapĩ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nhym kôt ba djwỳnh ar arỳm omũ. Ne kam nokà nhàn abenmã kum, —Je tô mỳkam ne arỳm me kudjỳ djào ajkẽ? ");
INSERT INTO txuNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Gwaj ren pi'ôk kaprĩ kadjy ren memã kungã ne ren pãnh pi'ôk kaprĩ rax ne ren kubyn ren me õ mỳjja kêtmã kungrà. Mỳkam ne arỳm o ajkẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nhym Jeju arỳm tu ar kabẽn man arkum, —Mỳkam ne gar kum kaprĩ jadjà? Djãm kute ijã kapĩnkam punu got? Kati, mexkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Be, akati kunĩkôt ne ar abu'ã me õ mỳjja kêt ar ba rã'ã. Nhym djãm arek gwaj baro'ã ar baba rã'ãmã? Kati. ");
INSERT INTO txuNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Dja ba ty nhym me arỳm ijadjà. Me kute ijadjàr kadjy ne ijã me kudjỳ djà kapĩ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ba ar amã arẽ gar ama. Dja me kàj bê pyka kunĩkôt mã ijã memã ujarẽnh ny jarẽn mã nijadjwỳ 'ã ajarẽ. Kute ijã me kudjỳ djà kapĩn'ã ajarẽ. Ne kam aben djô'ã nija mar rã'ã ne. Mrãmri ne ba ar amã arẽnhkumrẽx. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nhym kam Jejukôt ba djwỳnhbê 12 ja 'õ, idjibê Djuda Ikadji ne me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr'ỳr tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nãm ar'ỳr tẽn ar'ỳr bôx ne arkum, —Arỳm ne ba ije ar amã Jeju kangamã. Mỳj dja gar pãnh imã angã? Ba kam arỳm ar amã kanga, ane. Nhym kam ar arỳm kum kryt jakao ngônhponho pi'ôk kaprĩ jarẽ. Nãm ar kute 'ã akrebê 30 ne kum kungã nhym kubyn o tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ne kam amim, —Mỳj dja ba ije arkum Jeju kanga kadjy on? Nãm ã amim anhỹro ba. ");
INSERT INTO txuNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nhym kam mebê idjaer kukràdjàkôt me kute djwỳponhbit kur nhõ akati arỳm kutewa nhym kôt ba djwỳnh ar Jeju'ỳr bôx ne kum, —Metĩndjwỳnh me irôbê mrãnh nhõ akatikam gwaj banhõ kwỳ krẽn kadjy jãm dja bar tẽn akutêp gwaj banhõ kwỳ krẽn djà jadjwỳr mex? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nhym arkum, —Dja gar krĩraxkam tẽn me'õ 'ỳr bôx ne kum, “Ujarẽnh djwỳnh ne amã, ‘Arỳm ne inhõ akati iwỳr bôx. Dja bar Metĩndjwỳnh me irôbê mrãnh nhõ akatikam me kukràdjà kôt inhõ kwỳ krẽ. Bamẽ ikôt ba djwỳnhmẽ dja bar anhũrkwãkam inhõ kwỳ krẽ’, ane. Dja gar ã kum ane.” Nãm Jeju ã kôt ba djwỳnh arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nhym kam ar arỳm Jeju kute arkum 'ã karõ kôt 'ỳr tẽ. Ne me'õ ja'ỳr bôx ne kum Jeju kabẽn jarẽ nhym arkum, “Ã”, ane. Nhym kam ar arỳm ũrkwãkam kutêp ar õ kwỳ krẽn djà jadjwỳr mex. Metĩndjwỳnh me irôbê mrãnh nhõ akati kadjy ne ar õ kwỳ krẽn djà jadjwỳr mex. Ne kam akubyn Jeju kutã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nhym kam ar'ã para nhym ar me'õ kute arkum ũrkwã jarẽnhja nhũrkwã'ỳr tẽ. Kam ar õ kwỳ krẽnmã 'ỳr tẽn 'ỳr bôx. Ne kam nhỹ. Ar kubê 12ja ne ar Jejumẽ ro'ã nhỹ ne arỳm õ kwỳ krẽno nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","O nhỹ: nhym Jeju arkum, —Be, ar ajõ dja ga ikurê djwỳnhmã ikanga. Mrãmri ne ba ar amã arẽnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nhym kam ar arỳm kaprĩ:ren apỹnh ar ĩ djàri aben totokmã kum, —Bẽnjadjwỳr djwỳnh, djãm ba? Bẽnjadjwỳr djwỳnh, djãm ba? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nhym arkum, —Be, kute ikôt ngônhkrãtikam djwỳ jadjàrja tãm dja memã ikanga. ");
INSERT INTO txuNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Be, me bakukãmãre kute ba ije amijo inhĩ ijã pi'ôk no'ôk, kute Metĩndjwỳnh kukwakam ijã pi'ôk no'ôkkôt ne me arỳm jakam ar ã ijo anhỹro ba. Nhym be, kute ikurê djwỳnhmã ikanga djwỳnhja dja ĩ kute memã ikanga pãnh tokry ra:xi. Ỹ, watĩ:re. Tãmja ne ren rwỳk kêt ne. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nhym Djuda, kute kurê djwỳnhmã kanga djwỳnhja kum, —Ujarẽnh djwỳnh, djãm ba dja ba ajo ane? Arkati, ane. Nhym kum, —Arỳm ga, “Ba”, ane. Amikôt ne ga arỳm amijarẽnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nhym ar àkuro nhỹ: nhym Jeju arỳm djwỳ'õ byn kam o Metĩndjwỳnhmã mextire jarẽ. Kum mextire jarẽn arỳm kôt ba djwỳnh arkum kokij ne apỹnh arkum kungã. Ne kam aminhĩ'ã djwỳ jakren arkum, —Inhĩ ne ja. Ar abyn krẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ne kam ngônhkrãkam pidjô kangôjadjwỳ byn kam o Metĩndjwỳnhmã mextire jarẽ. Amikamrô'ã ne pidjô kangô jakren arkum, —Ar akunĩ dja gar o ikõ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ikamrô ne ja. Me krãptĩ jaxwe pãnh dja ikamrô prõt nhym kam Metĩndjwỳnh memã kabẽn ny jarẽnh mãmdjin me axwe maro aknon me kam ngryk kêt. ");
INSERT INTO txuNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ba ar amã arẽ gar ama. Ije pidjô kangôo ikõmo krã'yr ne ja. Ibãm kute amim õ me ja kunĩ pytàr ne kute meo bakambit dja ba ajte pidjô kangô nyo ikõ. Gwaj baro'ã o ikõ. Nãm Jeju ã arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nhym kam ar ngre. Ngren arỳm o ino re. O ino ren arỳm amũ krãnhbê Oriwêre'ỳr mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ar 'ỳr mõ: nhym Jeju arkum, —Be, akamàtja tãmkam dja me ijo ajkẽ gar me umaje aprõt ne ajmà. Amrẽbê: ne me bakukãmãre ar aprõt ne abimành'ã ajarẽ. Metĩndjwỳnh kukwakam ne me arẽn memã kum, “Be, dja ba mrykĩ'ãtomtio ba djwỳnh titik nhym mry umaje prõt ne ajmà”, anen arỳm 'ã pi'ôk no'ôk ne. Be, akamàtja tãmkam dja gar me umaje aprõt ne ajmà. Me bakukãmãre kute ar ajã ujarẽnh kôt dja gar aprõt ne ibê ajmà. ");
INSERT INTO txuNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ibê ajmà nhym me arỳm ibĩ. Ba ityk ne akubyn itĩnkam dja ba ar akukãm pykabê Garrêjamã tẽ. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nhym Pedru kum, —Godja ar kunĩ prõt ne bimành jabej ba dja ba arkôt iprõt kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nhym Jeju kum, —Kati, mrãmri dja ga arkôt aprõt. Ba amã arẽ ga ama. Akamàtja tãmkam õkrẽn'ãnh kàr kêtri dja ga amijã maje ajêxo amãnhkrut ne ikjêkêt ne memã kum, “Kati, ije me'õwã pumũnh kêtkumrẽx”, ane. Mrãmri ne ba amã ja jarẽnhkumrẽx. Nãm ã Jeju kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nhym Pedru kum, —Kati, gê me gu baro'ã gu babĩn jabej ba ije aminêje ajã ijêx prãm kêtkumrẽx, ane. Nhym kam kôt ba djwỳnh ar kunĩ kabẽn kôt kum arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ne kam mõ:n kam Jeju kôt pidjôkôbê Djexema'ỳr bôx. Nhym kam kôt ba djwỳnhmã kum, —Jakam dja gar ikutêp nhỹ. Ba mũm tẽn Metĩndjwỳnhmã amijo a'wỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ne kam Pedrumẽ Djebedêu kra ar amãnhkrut japrôn aro tẽ. Ne kam tokry rax pymaje madjà kreti:n arỳm kaprĩ rax ne. ");
INSERT INTO txuNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ne kam arkum, —Arỳm ne ba ikaprĩ:re. Arỳm ikaprĩ kute ibĩn 'ỳr. Jãnh mãn ar idjêje nhỹ gwaj baro'ã aminêje barĩt o nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ne kam amũ tẽ. Tẽmo rãm ne jan tu mỳrbê tỹm. Tỹm ne arỳm Metĩndjwỳnhmã amijo a'uw ne kum, —Djũnwã, aje itokry, ikaprĩjabê ipytàr prãm jabej ipytà. Nàr kon, kwãrĩk wãnh rã'ã ba tu itokry. Djãm ba ne ba amimarkôt ar amijo iba? Kati, akabẽnkôt ne ba ar amijo iba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ne kam kàjmã djan kôt ba djwỳnh ar'ỳr akẽx ne tẽn ar'ỳr bôx. Nhym arek ar õto ikwã. Nhym Pedrumã kum, —Je, kraxje kô 'iry kêt ne gar anhõto anhikwã. Mỳkam ne gar iro'ã aminêje arĩto anhỹr kêt ne? ");
INSERT INTO txuNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ar aminêje rĩt ne Metĩndjwỳnhmã amijo a'wỳ. Gêdja me te ar ajaxwe'ã ar amã apnê gar mekôt ajaxwe kêt. Ja kadjy dja gar kum amijo a'wỳ. Be, ar anhõkre kadjwỳnhbê ne gar amã ikabẽnja kĩnh. Nhym be, ar aminêje arĩtbê ne gar arerekren anhõtdjwa ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ne kam ajte amũ tẽn Metĩndjwỳnhmã amijo a'uw ne kum, —Djũnwã, aje itokry, ikaprĩjabê ipytàr prãm kêt jabej kwãrĩk wãnh rã'ã ba tu itokry ne akabẽn man kôt ar amijo iba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ne kam ajte akubyn ar'ỳr akẽx ne tẽn ar'ỳr bôx. Nhym ar nokà bã mex ne ajte arek õto ikwã. Rerek mex ne arek õto ikwã nhym ar omũ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ne kam ajte akẽx ne amũ tẽn Metĩndjwỳnhmã amijo a'uw. Õbê kute kum kabẽn jarẽnh jakôt ajte kum tãm jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ne kam ajte kôt ba djwỳnh ar 'ỳr akẽx ne ar'ỳr tẽn ar'ỳr bôx ne arkum, —Je, djãm arek ar anhõto anhikwã rã'ãã, akôkam kôto anhikwã? Aj, arỳm itokry djà iwỳr bôx 'ỳr. Ota, arỳm kute me axwemã ikangamã, ije amijo inhĩja ne kute memã ikangamã. ");
INSERT INTO txuNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kàjmã ar dja. Gwaj on me'ỳr. Ota, arỳm kute memã ikanga djwỳnh bôx. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ne kute arkum anhỹro ãm rã'ã nhym Djuda arỳm 'ỳr tẽn 'ỳr bôx. Jeju kôt ba djwỳnhbê 12 'õ ne kubê Djuda. Nãm 'ỳr bôx nhym me krãptĩ me:x ne kôt mõn 'ỳr bôx. Nãm me kàxdjwa kajgomẽ kô jamỳn kôt 'ỳr o mõn o bôx. Me rũnh ne me me ano. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebêngêtmẽ ne me me ano nhym me 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Me 'ỳr mõr kêtri ne kute memã kanga djwỳnhbê Djuda memã kum, —Be, ije me'õ nhine kaôrkôt dja ga me omũn o tỹm ne pa 'amỳ. Nãm ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nãm Jeju'ỳr bôx ne kum, —Ujarẽnh djwỳnh, djãm amexkumrẽx? anen arỳm ine kaô. ");
INSERT INTO txuNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nhym Jeju kum, —Akmere, mỳj kadjy ne ga iwỳr bôx? ane. Nhym kam me arỳm 'ỳr mõn o tỹm ne pa 'amỳ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nhym kam bẽnjadjwỳr nhõ àpênh'õ ne mekôt tẽ. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax nhõ àpênh mekôt tẽ. Nhym Jejumẽ ro'ã ar ku'êja 'õ ne arỳm õ kàxdjwa kajgo kaban o me'õjamã akabên amak ta, bẽnjadjwỳr nhõ àpênhja jamak ta. ");
INSERT INTO txuNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nhym Jeju nêje kukràn kum, —Kwãrĩk wãnh. Akubyn àkam adjà. Ga, me kute kàxdjwa kajgoo pôx ne kute o aben parja pumũ. Ja dja ga amikam ama, ane. Mỳj'ã ne kum kabẽn ja jarẽ? Bir, djãm me kute me par prãm umar mexmã? Kati. Dja kurê djwỳnh ĩ arỳm kubĩ. 'Ã ne Jeju kum, —Ga, me kute kàxdjwa kajgoo pôx ne kute o aben parja pumũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ne kam ajte kum, —Djã nã gãm ijã amim, “Dja te Bãm 'uw nhym kum õr kêt”, ane? Kati, ba ren me'ã Ibãm 'uw nhym ren imã kadjy mrãnh djwỳnh krãptĩ: jano. Ren imã redjiãobê 12 jano nhym me ren ipytà. Me redjiãobê 12kam me krãkamngônh'ã akre nhym me kubê 72.000. Me krãptĩ:. ");
INSERT INTO txuNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ne me ren ipytà ba ren kam me bakukãmãre kute Metĩndjwỳnh kabẽn'ã pi'ôk no'ôk kôt amijo itẽm kêt. Nhym be, kati. Mrãmri ne ba kabẽn kôt amijo itẽmkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nãm ã Jeju kum anen kam me krãptĩjamã kum, —Je djãm idjàkĩnhĩ ne ga me aje ijo atỹm kadjy iwỳr anhõ kômẽ anhõ kàxdjwa kajgomẽ o mõ? Myt kunĩkôt ne ba Metĩndjwỳnh nhõ kikretikam ikrĩ, memã idjujarẽnho ikrĩ ga me kam kam ijo atỹm kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mỳkam ne ga me ijo tỹm? Bir, amrẽbê: ne Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh me bakukãmãremã me ajã ajarẽ. Me aje ijo atỹm'ã ajarẽn arỳm 'ã pi'ôk no'ôk ne. Nhym me arỳm aben djô'ã arẽnho mõ:. Arẽnho mõr tãmtã arỳm iwỳr o bôx. Tũ:mràm me bakamingrãnyrekam arỳm iwỳr o bôx. Ba ar iba: ga me arỳm jakam ã ijo ane. Me kute me bakukãmãremã me ajã ujarẽnh kôt ne ga me arỳm jakam ã ijo atỹmo ane. Nãm ã Jeju me krãptĩmã ane. Nhym kam kôt ba djwỳnh kunĩ mã amijã maje prõt ne. ");
INSERT INTO txuNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nhym me kute pa 'amỳnh djwỳnhja o mõ:n arỳm Kajbaj'ỳr o bôx. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr raxbê ne Kajbaj. Nhym Môjdjê kukràdjà mar djwỳnhmẽ mebêngêtmẽ ne me arỳm akuprõ nhym me me'ỳr o bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nhym be, Pedru ne Jeju kôt tẽ, nĩjar kum kre rax ne tẽ. Nhym me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax nhõ kikre nhipôkri kênh ngrire nhym Pedru arỳm Jejukôt wadjà. Me kute ajmã Jeju o jabej kute omũnhmã arỳm nhỹ, bẽnjadjwỳr nhõ krãkamngônhmẽ ro'ã nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nãm me me'ỳr Jejuo bôx nhym kam me rũnh arỳm me 'êxnhĩ jabej. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebêngêttemẽ me rũnh kunĩ ne me me 'êxnhĩ jabej. Dja me amãnhkrut Jeju'ã 'êx ne memã kum, —Ba ne ba axwe kôt omũ. Nãm ã ane ba omũ, ane. Dja me ane nhym me arỳm me kabẽn man arỳm we axwe 'õ pãnh kubĩ. Kadjy ne me me 'êxnhĩ jabej. ");
INSERT INTO txuNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ne te abejo dja. Me'õ ar amãnhkrut kute axikôt 'ã kabẽnja ne me te abejo dja:. Nhym me 'êxnhĩ krãptĩ kàjmã ku'ên arĩk aben kupa'ãbit axwe jarẽnho kumex. Nhym me te ar amãnhkrut axikôt 'ã kabẽnja jabejo dja: nhym kam ar 'êxnhĩ amãnhkrutja arỳm kàjmã djan axikôt 'ã kabẽn jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nãm ar'ã 'êx ne memã kum, —Tãmwã ne memã kum, “Ba ne ba ije Metĩndjwỳnh nhõ kikreti ngrành ne ije akubyn ipêx kadjy ijitỳxo 'ỳr ibôx mexkumrẽx. Akubyn ije ipêx'ã dja akati amãnhkrut ne ikjêkêtbit apêx ba arỳm ipêx pa.” Nãm Jeju ã memã ane bar arỳm kuma. Nãm ar 'êxnhĩja ã Jeju'ã memã ane. Ar axikôt ã memã arẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nhym me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr raxja arỳm kàjmã djan kum, —Ga ar kabẽnjama. Djãm aje aminêje akabẽn'õ jarẽnh prãm kêtkumrẽx. On imã amikôt amijarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nhym Jeju tu anhikrê. Nhym me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax ajte kum, —Metĩndjwỳnh tĩn ne ar baja ne arỳm gu bapumũnho nhỹ. Kwãrĩk wãnh nokrekam ajêxnhĩ kêt. On me imã amijarẽ. Djãm abê me babê idjaer nhõ Bẽnjadjwỳrbê kumkati, nẽn? Djãm mrãmri abê Kritu? Djãm abê Metĩndjwỳnh Kra? On me imã amijarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nhym Jeju kum, —Kôt ne ga imã arẽ. Ba ar amã arẽ gar ama. Gêdja ba ĩ Metĩndjwỳnh pymati djubôk'ãnh nhỹ. Ije amijo inhĩ ne ibẽnjadjwỳr raxkam ubôk'ãnh nhỹ gar arỳm ipumũ. Ne kam ajte kakrãkôt amrẽ kàjkwa kurũm itẽmkôt ipumũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nhym kam me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax kute memã amingryko amirĩt kadjy arỳm amibê kà kadjô. Amibê kà kadjôn arỳm memã kum, —Ẽ, arỳm ne Metĩndjwỳnh japrỳ. E kum kwãrĩk wãnh gwaj ijukri axwe kôt omũnh djwỳnh'õ jabej kêt. Gwaj bakunĩ ne gwaj arỳm kute Metĩndjwỳnh japrỳja ma. Ta ne amijo Metĩndjwỳnh rax pytàn arỳm o aprỳ gwaj kôt kuma. Kute gwaj bamã, “Metĩndjwỳnh djubôk'ãnh inhỹrkôt dja gar ipumũ”, anhỹrkôt ne gwaj arỳm kuma. ");
INSERT INTO txuNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Arỳm ne gar ama. Mỳj dja gwaj nẽ? ane. Nhym me kupãnhtã 'ã kum, —Gê me on kubĩ. Gê me on kubĩ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Nhym kam me kwỳ nokre kutôn ikra krão tak nhym me kwỳ ikra poo tak ne kum, —We me inhõ Bẽnjadjwỳrbê kumkati kadjy ne Metĩndjwỳnh ajano, abê Kritu kadjy ajano ga bôx. Aj, goja abê Kritu jabej goja me'õ kute akurwanhjakôt omũ. Goja tu aman me imã arẽ. Nãm me ã Jeju'ã bẽno bikẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nhym Pedru arỳm me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax nhõ kikre nhipôkri kênh ngrirekam nhỹ. Nhỹ: nhym bẽnjadjwỳr nhõ àpênh ni arỳm 'ỳr bôx ne omũn kum, —Tukwa, gadjwỳ ne ga Jeju kôt ar aba. Pykabê Garrêjakam Jejukôt ar aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nhym me kunĩ nhipôkri arĩk aminêje 'êx ne kum, —Kati, ije akabẽnwã mar kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ne kam kikreti'ỳr àrmã katon kre tã dja. Nhym bẽnjadjwỳr nhõ àpênh ni 'õdjwỳ omũn memã kum, —Tãmwãdjwỳ ne Jejukôt ar ba, Nadjarekam Jejukôt ar ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nhym ajte aminêje 'êx ne memã kum, —Aje mỳj me'õ jarẽnhwã ije omũnh kêt. Djãm ijêxnhĩ? Kati. Metĩndjwỳnh ne arỳm ijêxnhĩ kêtkôt ima, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nhym kàjbê 'ãtũm nhym kam me'õ 'ỳr tẽn kum, —Be, mrãmri ne gadjwỳ kôt ar aba. Abê pykabê Garrêja kra'õ. Garrêjakam me kabẽn kôt ne ga akabẽn bar kôt aman arỳm amã ikato, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nhym memã kum, —Kati, mrãmri ije me'õwã pumũnh kêtkumrẽx, ane. Ne me'õ kute kum anhỹr kêtmã arỳm amikangrôn memã kum, —Dja ba ijêxnhĩ jabej gê Metĩndjwỳnh pãnh ijo akno. Ta ne arỳm ijêxnhĩ kêt kôt ima, ane. Nãm anhỹr 'iry kêt nhym arỳm õkrẽn'ãnh kà. ");
INSERT INTO txuNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nhym kam Pedru õkrẽn'ãnh kàr man akubyn amimaro tẽ. Amimaro tẽn arỳm amũja'ã Jeju kute kum kabẽn jarẽnhja'ỳr amimaro bôx ne amijã kabẽn ma. Kute kum, —Õkrẽn'ãnh kàr kêtri dja ga aminêje ajêxo amãnhkrut ne ikjê kêt ne memã kum, “Kati, ije tãmwã pumũnh kêt”, anhỹr ja ne arỳm kuma. Nãm maro dja nhym arỳm rerek 'ỳr bôx. Rerek 'ỳr bôx nhym arỳm katon mu:w. ");
INSERT INTO txuNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nhym kam kryràm me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr kunĩmẽ mebê idjaer bêngêt arỳm Jejuo aben ma. O aben man arỳm abenmã 'ã karõn abenmã kum, —Mrãmri dja me on tu bĩnkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ne kam arỳm uwpren Piratu'ỳr o mõn o bôx. O bôx ne kum kanga. Piratubê bẽnjadjwỳr bajtem. ");
INSERT INTO txuNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Me kute bĩnmã 'ỳr o mõrkam ne Djuda arỳm omũ. Djuda kute kurê djwỳnhmã kanga djwỳnhja arỳm omũ. Ne kam arỳm amim ngry:k ne. Amim ngryk ne arỳm amim, —Je tô mỳkam ne ba memã Jeju kanga? ane. Amim ngryko tẽ:n akubyn me rũnh'ỳr kryt jakao ngônhponho pi'ôk kaprĩbê 30o tẽn arỳm me'ỳr o bôx. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebêngêt'ỳr ne o bôx ne arỳm memã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Axwe kêtkumrẽxkam ne ba me amã kanga ga me arỳm aje bĩnmã. Ba kam arỳm ijaxwe:, ane. Ne memã kum, “Mĩ”, ane. Nhym me kum, —Djãm me ba ne ba me o amaro iba? Kati, ga ne ga o me ima, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nhym kam arỳm Metĩndjwỳnh nhõ kikreti'ỳr tẽn 'ỳr bôx ne kikreti kadjwỳnhbê ngônhponh mẽn arỳm mã tẽ. Mã tẽn kam ta pĩ'ã amimut djên amibĩn arỳm ty. ");
INSERT INTO txuNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nhym kam me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr ar 'ỳr tẽn ngônhponho atom ne abenmã kum, —Djãm Metĩndjwỳnh nhõ kikreti nhõ pi'ôk kaprĩo atom djàkam gwaj baje ngônhponh djirmã? Kati. Djuda kute gwaj bamã Jeju kanga nhym me kute bĩn nhym kamrô prõt pãnh ne ngônhponho pi'ôk kaprĩja. Gwaj ren Metĩndjwỳnh nhõ kikretikam pi'ôk kaprĩ djin ren kam Môjdjê kukràdjà kupa'ã amijo tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ne kam aben man abenmã kum, —Gwaj ngônhponho ngybôr nhõ pyka by. Me kute kam me bajtem tyk jangjênh kadjy pyka by, ane. Ne kam arỳm ngônhponho pyka by. ");
INSERT INTO txuNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kam ne me arỳm pykamã pyka kamrôre jarẽ. Akatija tãmkam ne me kute kum arẽnh rã'ã. ");
INSERT INTO txuNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Amrẽbê: ne me bakukãmãre Djermi memã 'ã ajarẽ. Me kute ngônhponho ngybôr nhõ pyka byr'ã ajarẽ. Djermi Metĩndjwỳnh kukwakam me bakukãmãremã 'ã ajarẽn memã kum, “Nãm me kam arỳm kryt jakao ngônhponho pi'ôk kaprĩbê 30 by. Mebê idjaer kute me'õ'ã kum, ‘Dja ba me me'õ pãnh amã ã pi'ôk kaprĩo ane’, anhỹr kôt ne me arỳm kubê 30 by. Ne kam arỳm o ngybôr nhõ pyka by. Bẽnjadjwỳr djwỳnh kute imã arẽnh kôt ne me kuby.” Nãm ã Djermi me bakukãmãremã ane. Nhym me kam arỳm aben djô'ã arẽ:. Arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm me bakamingrãnyrekam me rũnh arỳm ngônhponho ngybôr nhõ pyka byrkumrẽx. Djermi kute amrẽbê: me bakukãmãremã 'ã ujarẽnh kôt ne me arỳm pyka byrkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Me kute pyka byr djwỳnhràm ne me rũnh arỳm bẽnjadjwỳr Piratu'ỳr Jejuo mõn o bôx. O bôx nhym arỳm kabem dja nhym kum, —Djãm abê mebê idjaer nhõ bẽnjadjwỳr rax? ane. Nhym Jeju kum, —Kôt ne ga aje arẽnhwã, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nhym kam me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebêngêtmẽ arĩk Jeju'ã axwe janhô. Nhym tu anhikrê. ");
INSERT INTO txuNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nhym Piratu kum, —Djãm ajaxwe krãre ne me amã arẽ? Djãm aje mar kêt? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nhym kum kabẽn'õ jarẽnh kêtkumrẽx. Nhym bẽnjadjwỳr Piratu te kute marmã kam no tyn omũnho nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Be, akatija tãmkam ne mebê idjaer krãptĩ: arỳm aben pydji. Me kute aben kajmã'ã Metĩndjwỳnh me kukãmãre nhirôbê mrãnh djà mar kadjy aben pydji. Amex kunĩkôt ne bẽnjadjwỳr raxbê Piratu akati jakam mebê ijê djà kurũm me pỹnh ne meo pôx nhym me mã mrã, mebê ijêjao pôx nhym me mã mrã. Me kute me'õ'ã à'wỳrja ne me kĩnh kadjy bõm kumẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mebê ijê djàkam ne me arỳm me'õ axwe:jabê ijê. Idjibê ne Baraba. ");
INSERT INTO txuNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Me krãptĩ ne me akati jakam akuprõ nhym Piratu memã kum, —Mỳj me'õ dja ba me amã kaban ano? Dja ba Baraba kaban ano. Nàr, dja ba Jejumã inhiren ano, me kute kum Kritu jarẽnhjamã inhiren ano, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nãm anhỹr djwỳnhràm amim, —Jeju'ã me krãptĩkam ne me rũnh 'ã ngryk ne imã kanga, ane. Ne kam arỳm kute Jejumã irer ne kute anor prãm. ");
INSERT INTO txuNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Piratu arek memã axwe pãnh jarẽnh djàkam nhỹ nhym prõ amũ kum kabẽn janon kum, —Kwãrĩk wãnh ajmã me'õwão kêt. Axwe kêtkumrẽxkam ajmã o kêt. Akatija tãmkam ne ba ibiptirkam omũn arỳm kam axwe idjumar, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kam ne Piratu kute kum irer ne kute anor prãm ne me krãptĩmã kum, —Mỳj me'õ dja ba kum inhiren ano? ane. Nhym me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebêngêtmẽ me krãptĩmã kum, —Baraba dja ga me amã kĩnh. Jeju'ã dja ga me kum, “Abĩ, abĩ.” Nãm me ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nhym kam bẽnjadjwỳr Piratu ajte me krãptĩmã kum, —Ar amãnhkrutja. Nhỹnhja dja ba kum inhiren ano? ane. Nhym me kum, “Baraba”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nhym memã kum, —Mỳj dja ba Jejudjwỳ on? Me kute kum Kritu jarẽnhja mỳj dja ba on? ane. Nhym me kunĩ kum, “Pĩte'y'ã anhô”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nhym Piratu memã kum, —Tô mỳkam? Mã ne kute? Djãm axwe? ane. Nhym me kàj bê kum, “Pĩte'y'ã anhô”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nhym Piratu amim, —Je, jakam ne ba arỳm te meo ane. Nhym me ngry:k ne kangao kumex, ane. Ne kam ta kute we memã amijaxwe kêto amirĩt kadjy arỳm ngô byn me kunĩ nokrekam aminhikra põn memã kum, —Djãm ije me'õ axwe kêtja kamrô kapĩnkam ba ijaxwe? Kati, me ga ne ga me 'ã imã apnê ba arỳm ije bĩnmã. Me ga ne ga me ajaxwe, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nhym me kunĩ kum, —Nà. Tãm. Me ba dja ba me ijaxwe. Me ikramẽ ikrakam itàmdjwỳmẽ dja ba me ijaxwe. Me ba ne ba me imã bĩn prãm ne kam aje bĩnmã amã 'ã apnê, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nhym kam arỳm Baraba kaban ano nhym ta arỳm arek ar mekôt ba. Nãm kum iren anon kam memã Jeju jarẽ. Nhym me arỳm mrykà punuo kaprêprê:k ne. Nhym kam me kute pĩte'y'ã nhôr kadjy memã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nhym kam bẽnjadjwỳr Piratu nhõ krãkamngônh kikretimã Jejuo mõn o wadjà. Kumoka'ê nhidjibê Pretorimã o mõn o wadjà. O wadjàn arỳm kadjy me krãkamngônh kàtàm kunĩo akprõ. O akprõ nhym me kunĩ arỳm bôx ne Jeju'ã aben pydji. Me kute aprỳn 'ã bẽno bikẽnh kadjy 'ã aben pydji. ");
INSERT INTO txuNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ne kam kubê kubẽkà kaban inôkà ryti kamrêk kute me bẽnjadjwỳr rũnh nhinôkà pyràkja kum adjà. ");
INSERT INTO txuNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ne kam mrỳnhĩo kajkep ne ikãnh ne, ne kum kutu. Nãm me me bẽnjadjwỳr rũnh nhõ krãdjê'ã mrỳnhĩ jakren arỳm kum kutu. Ne kam ikra djubôkmã po'ê jadjà nhym kuby. Me bẽnjadjwỳr djàbêr djà'ã ne me po'ê jakren ikramã adjà nhym kubyn o nhỹ. Nhym me parbê ari rôrôk ne kõnkrão krĩn 'ã bẽno ajkẽn apỹnh kum, —Ga we abê mebê idjaer nhõ bẽnjadjwỳr rax. Gora kribêm atĩn 'iry, anhỹro kumex. ");
INSERT INTO txuNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ne kam apỹnh kutôn apỹnh po'ê byn arĩk o krã môre. ");
INSERT INTO txuNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ne kam arỳm 'ã bẽno bikẽnhja inomã kumẽn kam arỳm kubê inôkà ryti kamrêk kaban akubyn kum õ kubẽkà djwỳnhja jadjà. Ne kam kute pĩte'y'ã nhôrmã o katon o mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","O mõn arỳm me'õbê Ximão kajpa. Pykabê Xirenikam me kra 'õ. Nhym me krãkamngônh arỳm Jeju nhõ pĩte'y'ã kum àpnênh tỳx nhym arỳm kum ikreio kumỳn o mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Krãnhrebê Gogota'ỳr ne me Jejuo mõ. Me bakabẽnkam ne gu me ren krãnhremã me krã'i jarẽ. Nãm me 'ỳr o mõn arỳm 'ỳr o bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ne kam pidjô kangô kadjàmẽ pĩdjỳo akàn arỳm Jejumã kungã. Nhym te kakin kanga. ");
INSERT INTO txuNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nhym kam me arỳm pĩte'y'ã kunhô nhym wajêt. Nhym kam me apỹnh kute õ kubẽkà jamỳnh kadjy kẽn kryre rẽ. Me kute kẽn rẽnhkôt ne me amijo kubẽkà pytà. Amrẽbê: ne ujarẽnh djwỳnh 'ã ajarẽ. Me kute abenmã õ kubẽkà ngrành'ã ajarẽ. Metĩndjwỳnh kukwakam ne 'ã ajarẽn me bakukãmãremã kum, “Metĩndjwỳnh Kra ne memã kum, ‘Arỳm ne me abenmã ikà ngrà. Nãm me ikà ja'ã kẽn kryre rẽn arỳm amijo utà.’ Nãm ã memã ane.” Nãm ã me bakukãmãremã ane nhym me arỳm aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm me bakamingrãnyrekam 'ỳr o bôx nhym me arỳm abenmã Jeju kà ngrànhkumrẽx. Metĩndjwỳnh kukwakam ujarẽnh djwỳnh kute me bakukãmãremã 'ã ujarẽnh kôt ne me arỳm abenmã Jeju kà ngrànhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ne kam arỳm nhỹ, nêje rĩto nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ne kam 'ã pi'ôk no'ôk ne. Pi'ôkkam ne memã kum, —Jeju ne ja. Mebê idjaer nhõ bẽnjadjwỳr rax ne ja, ane. Me kunĩ kute omũnh kadjy ne me Jeju nhimõkri kunhô. Me kute we Jeju jaxwe 'õ pãnh pĩte'y'ã jêtja pumũnh ne kute mar kadjy ne me pi'ôk no'ôk ne imõkri kunhô. ");
INSERT INTO txuNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ne kam ar àkĩnhĩ amãnhkrutja Jeju nhikjê'ã pĩte'y'ã ar kunhô. Nhym arỳm ar arij. Jeju õkredjàkôt wajêt nhym aktã ar axweja ijên wajêt. ");
INSERT INTO txuNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nhym me 'ãnh mõrja nokà nhàn kum kabẽn punu:re ne kum, ");
INSERT INTO txuNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Be, ga: ne ga we aje Metĩndjwỳnh nhõ kikreti ngrành ne aje akubyn ipêxmã. Nhym aje ipêxo adjãm'ã akati amãnhkrut ne ikjêkêt ga we aje ipêx parmã. Goja jakam amiptà. Goja abê Metĩndjwỳnh Kra jabej pĩte'y kurũm rwỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nhym kam me rũnh arĩk 'ã bẽno ajkẽ. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ mebêngêtmẽ ne me arĩk 'ã bẽno ajkẽn abenmã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Amũbit ne me utà. Ne kam te kute amipytàr prãmje. Goja gê mrãmri mebê idjaer nhõ bẽnjadjwỳr raxkumrẽx jabej on pĩte'y kurũm rwỳ. Gê goja rwỳ gwaj goja rwỳkkôt omũn arỳm tu amim markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tãmwã ne we Metĩndjwỳnh kanàrràm ar ba. Gê Metĩndjwỳnh mrãmri kum kĩnh jabej on utà. Tãmwã ne 'êx ne memã kum, “Ibê Metĩndjwỳnh Kra”, anhỹr ar o ba. Nãm me ã abenmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nhym ar àkĩnhĩ aktã pĩte'y'ã jêtjadjwỳ kum àkjêro wajêt. ");
INSERT INTO txuNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nhym arỳm kàjkwa nhipôkri myt nhỹ. Nhym kam tu akamàt kô tyk ne. Pyka kunĩkôt ne me'ã akamàt kô tyk ne. Nãm me'ã akamàt kô tykkam myt kyn kyn kyn ky: nhym 3 orakam, amykrykambit arỳm ajte myt no pôt ne. Arỳm ajte myt kato. ");
INSERT INTO txuNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Myt kato nhym Jeju mebê idjaer kabẽnkam kàj bê kabẽn ne Bãmmã kum, —Eroi: Eroi: rama xabatani, ane. Nãm ren me bakabẽn kam kum, —Inhõ Metĩndjwỳ:nh, Inhõ Metĩndjwỳ:nh, mỳkam ne ga arỳm ikanga? ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nhym parbê me ku'êja kabẽn man arĩk abenmã kum, “Ẽ, me'õwã ne Erijmã kabẽn”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nhym kam me'õ prõt ne ngônh puror põnh djà jakrita byn pidjô kangô kadjàmã adjà. Nhym kam kangô ipu nhym pĩ nhidjamã adjàn kàjmã kum kungã, kute kaôr kadjy. ");
INSERT INTO txuNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nhym me'õ ar kum, —Adjỹm, gê goja me bakukãmãrebê Erij 'ỳr bôx ne goja utà, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nhym kam Jeju kàj bê ajte kabẽn ne arỳm ty. ");
INSERT INTO txuNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Be, nhym arỳm Metĩndjwỳnh nhõ kikreti kadjwỳnhbê kubẽkàtija ta amikadjô. Nãm nhôr djà'ãnh amikrax ne e y: ne kraxmã amimẽ. Nhym pyka arỳm amingrẽk ne. Nhym apỹnh kẽn amikokij. ");
INSERT INTO txuNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nhym apỹnh pyka krã amijã kurê. Nhym me tyk krãptĩ, Metĩndjwỳnh nhõ me ja krãptĩ, arỳm ĩ tã akubyn tĩn ne kato ");
INSERT INTO txuNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ne arỳm Jeju akubyn tĩn nhijukri Djeruxarẽmã mõ, krĩrax tãmmã ne me kute Metĩndjwỳnh nhõ krĩrax mextire jarẽnh ja, kumã ne me mõn me krãptĩmã amijo amirĩt. ");
INSERT INTO txuNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pyka amingrẽk nhym mỳjja kwỳ ã amijo ane. Nhym krãkamngônh krãptĩ: kubê 100 nhõ bẽnjadjwỳrmẽ ro'ã Jeju nêje rĩto ku'êja arỳm omũ. Mỳjja pumũn arỳm tĩn prã:m ne abenmã kum, —Be, mrãmri ne me'õ jabê Metĩndjwỳnh Krakumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nhym me niredjwỳ krãptĩ amybỳm omũnho dja. Amrẽbê Jeju pykabê Garrêjakam ar bari ne me nire ja mã kôt ban o djuw mexo ba. Ne Jeju ajbir krĩraxbê Djeruxarẽ'ỳr tẽmkam kôt ajte mõn bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Me nire ja nhikô'ã ne Marij Madarena dja. Nhym Marij 'õdjwỳ dja. Kurũm ne Xijagumẽ Jôdje ar apôx. Nhym Djebedêu kute kum ar adjwỳrja nãdjwỳ dja. ");
INSERT INTO txuNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nãm Jeju ty nhym kam amykry mex ne. Nhym Jôdje arỳm bôx. Krĩraxbê Armatêkam ne Jôdje abatành djà. Õ nêkrêx rax. Adjwỳnhdjwỳ ne arỳm Jeju kôt ba. ");
INSERT INTO txuNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nãm Piratu'ỳr tẽn bôx ne Jeju nhĩ'ã kuma. Nhym Piratu memã kum, “Aje, me kum angã”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nhym kam Jôdje kadjy kubẽkà mexbê rinhu byn 'ỳr o tẽ. 'Ỳr o tẽn arỳm pĩte'y kurũm o ruw. Ne kam arỳm kubẽkào kupu. ");
INSERT INTO txuNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","61","Nhym wãnh ta õ me tyk nhõ kẽnkreja. Ta kabẽn kôt ne me ajbir kẽnkre kakruw. Nhym arỳm Jeju o mõn kam adjàro dja. Ne adjàr pan kam kẽnpoti jabatànhja ajkwa krekre'ã kudjan kam arỳm mã tẽ. Nhym Marij Madarenamẽ Marij 'õdjwỳmẽ ar kẽnkre kônh omũnho nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pi'ôk ràràr nêje akatikam ne me adjà. Akati jakam ne me me tyk djà kêt djà nhõ akati bôx kêtri aminhõ mỳjja kupênho kumex. Nhym kam arỳm pi'ôk ràràr bôx. Me tyk djà kêt djà nhõ akati bôx. Nãm te pi'ôk ràràr nhym me rũnh akati mar kêt ne tu Piratu'ỳr tẽ. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebê pardjêu Piratu'ỳr tẽn 'ỳr bôx ne Jeju'ã kum, ");
INSERT INTO txuNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Bẽnjadjwỳr, me'õ 'êxnhĩja tĩn ne ar bari ne memã kum, “Dja ba ty nhym ijã akatin akatin akati ba kam akubyn itĩn”, ane. Tãm ne bar ma:ro iba. ");
INSERT INTO txuNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kam bar amã arẽ. Godja kôt ba djwỳnh ar akamàtkam kẽnkre 'ỳr bôx ne arỳm ĩo akĩn mã o mõ. Ne kam arĩk memã 'êx ne memã kum, “Arỳm ne akubyn tĩn ne”, anhỹro ba. Jeju ta ne amrẽbê me noo biknoro ba. Dja ar ijukri akubyn tĩn jarẽ nhym me abenmã arẽn arỳm abennoo biknor me:x ne. Me 'êx kêt kadjy dja ga anhõ krãkamngônh janon memã kum, “Me 'ỳr mõn kẽnkre kuri dja”, ane nhym ar te kute ĩo àkĩnhmã. Gê 'ã akati amãnhkrut ne ikjêkêt apêxkambit me ajte ate krã ba. Nãm me rũnh ã Piratumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nhym memã kum, —Gêtô. 'Ỳr krãkamngônh kwỳo mõ gê me kẽnkre nêje djan rĩt tỳ:xo dja, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nhym kam me arỳm kẽnkre'ỳr meo mõn meo bôx. Ne kam arỳm kẽnkre'ã kẽnpotio yn kam kre nêje krãkamngônh pumjuw nhym me arỳm nêje djan rĩt tỳ:xo dja. ");
INSERT INTO txuNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nhym me tyk djà kêt djà nhõ akati arỳm apêx nhym arỳm pi'ôk kamrêkkam akati tẽ. Nhym kam Marij Madarenamẽ Marij 'õdjwỳ ar arỳm kute kẽnkre pumũnhmã 'ỳr tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","'Ỳr tẽ: nhym arỳm pyka amingrẽk tỳ:x ne. Bẽnjadjwỳr djwỳnh kadjy mrãnh djwỳnh 'õ ne kàjkwa kurũm ruw nhym kam pyka amingrẽk tỳ:x ne. Nhym kadjy mrãnh djwỳnh arỳm kẽnkre'ỳr tẽn 'ỳr bôx. Bôx ne arỳm ajkwa krekre'ã jãm kẽnpoti dja. Jãm kudjan arỳm 'ã nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nãm nokre jadjê:nh kute mrãmri ne na jadjênhkam pôk tỳxja pyràk. Nhym õ kubẽkàja jaka: kute mrãmri ne kakũm arngrokam akaja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nhym kre nêje ku'ê djwỳnhja arỳm omũ. Omũn arỳm umaje terte:t ne arỳm rôrôk ne. Ne kam arỳm wãnh kute me tyk pyràk ne ikwã. ");
INSERT INTO txuNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nhym ar nire kẽnkre'ỳr tẽn bôx nhym kadjy mrãnh djwỳnhja arkum, —Kwãrĩk wãnh ar atĩn prãm kêt. Jeju ne gar abej. Arỳm ne ba ar ama. Me kute pĩte'y'ã nhôr ne bĩnja ne gar abej tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Jakam ne arỳm nõr kêt. Nãm akubyn tĩn ne kato, kute ar amã arẽnh kôt. Amrẽ ar tẽn nõr djà kaprỳja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Dja gar omũn kam amikrà kêt ne tẽn kôt ba djwỳnhmã arẽ. Dja gar arkum, “Arỳm ne akubyn tĩn ne ar akukãm pykabê Garrêja'ỳr tẽmmã. Dja gar kam tẽn arỳm omũ” ane. Dja gar ã arkum ane. Ba ne ba arỳm ar amã arẽ gar arỳm ama. Nãm ã kadjy mrãnh djwỳnh arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nhym ar nire kabẽn man arỳm amikrà kêt ne mã kẽnkre kurũm prõt ne. Tĩn prãmmẽ kĩnhmẽ akàn prõt ne. ");
INSERT INTO txuNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ar kute kôt ba djwỳnh arkum arẽnhmã prõt ne. Prõ:t nhym ar aêrbê Jeju ar kajpan arkum, “Àpnhĩre ar”, ane. Nhym ar arỳm 'ỳr bôx ne paro tỹm ne kum rax jarẽnho nõ. ");
INSERT INTO txuNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nhym Jeju arkum, —Kwãrĩk wãnh ar atĩn prãm kêt. Tẽn ikamy arkum ikabẽn jarẽn arkum, “Ar Garrêja'ỳr mõ. Dja gar kam bôx ne arỳm omũ”, ane. Dja gar ã arkum ane. Nãm ã Jeju arkum ane. Nhym ar nire arỳm ar'ỳr mõ. ");
INSERT INTO txuNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ar'ỳr mõ nhym wãnh kre nêje ku'ê djwỳnh kwỳja arỳm kàjmã djan amũ krĩraxmã mõn bôx. Bôx ne arỳm me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmã prĩne amijarẽn arkum, —E kum, pyka ne amingrẽk nhym kadjy mrãnh djwỳnh arỳm ruw ne kẽnkre'ỳr tẽ. 'Ỳr tẽn arỳm ajkwa krekre'ã jãm kẽnpoti djan 'ã nhỹ. Nokre adjê:nh ne nhỹ. Bar omũn itĩn prã:m, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nhym ar arỳm kuman mebêngêt'ỳr tẽn 'ỳr bôx ne mekmẽ akuprõ. Ne kam arỳm o aben ma. O aben mar pan kam arỳm krãkamngônh'ỳr bôx ne arkum, ");
INSERT INTO txuNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Kwãrĩk wãnh memã wã jarẽnh kêt. Dja gar memã ajêx ne memã kum, “Akamàtkam ar inhõt tykkam arỳm kôt ba djwỳnh ar bôx. Bôx ne arỳm Jejuo akĩn mã nhĩ'ãm o mõ”, ane. Dja gar ã memã ajêxo ane bar pãnh arỳm ar amã pi'ôk kaprĩ kumex ngã. ");
INSERT INTO txuNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nhym godja me kàtàm arỳm ar anhõ bẽnjadjwỳr Piratumã ar ajarẽnh jabej ne kum, “Nãm anhõ krãkamngônh kre nêje rĩt'ã ngõr nhym kôt ba djwỳnh ar arỳm Jejuo akĩ”, anhỹr jabej. Nhym ar akam ngryk jabej. Ar ba dja bar arỳm ar anêje kum ikabẽn ne ar apytà. Mĩ, pi'ôk kaprĩ. Dja gar ã memã ajêxo ane. Nãm ã me rũnh krãkamngônh arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nhym kam ar arỳm amim pi'ôk kaprĩ jamỳn ã memã 'êxo bao ane. Ar kute arkum 'ã karõ kôt ã memã 'êxo bao ane. Nhym kam mebê idjaer arỳm arẽnho kumex ne arẽnho ipôk ne. Ne akati jakam kute we ar kute Jejuo àkĩnhja jarẽnh rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nhym kam kôt ba djwỳnh Ar kubê 11ja amũ pykabê Garrêja'ỳr mõn bôx. Jeju kute arkum krãnh jarẽnhja'ỳr ne ar bôx. ");
INSERT INTO txuNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ne kam arỳm Jeju pumũn parbê kõnkrão nhỹn kum rax jarẽn kum, —Mrãmri ne ga arỳm akubyn atĩn ne, ane. Nhym be, ar kwỳ ne ar abenmã kum, —Djãm mrãmri Jejukumrẽx ne dja? Djãm mrãmri akubyn tĩn ne? Kon ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nhym Jeju arỳm ar'ỳr bôx ne arkum, —Kàjkwamẽ pykamẽ kam mỳjja kunĩ ne ba ije o iba kadjy arỳm ibẽnjadjwỳr rax. ");
INSERT INTO txuNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kam dja gar mõn me kunĩmã arẽ. Apỹnh me ba djà kunĩkôt memã arẽ gê me ikabẽn man kôt ar amijo ba. Dja me ikabẽn man kôt ar amijo ba gar Metĩndjwỳnhmã ngômã me angij. Dja gar memã kum, “Arỳm ne ga tu amim Bãm markumrẽx ne ajte tu amim Kra markumrẽx ne ajte tu amim Metĩndjwỳnh Karõ markumrẽx. Ba kam arỳm ar kukwakam ngômã ajadjà”, ane. Dja gar ã memã anen arỳm ngômã me angij. ");
INSERT INTO txuNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ije ar amã katàt ar amijo aba'ã karõkam ikabẽn kunĩja memã arẽ gê me ikabẽn kunĩ man kôt ar amijo ba. Dja ba kam akati kunĩkôt ar amẽ amijo ikajkep rã'ã: rã'ã ne nhym pykakam me kute aminhinomã amimẽnh djà nhõ akati arỳm bôx. Nãm ã Jeju arkum ane. Tãm ne ja.");
INSERT INTO txuNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ba ibê Makô ne ba pi'ôkkam me amã ikabẽn jarẽ. Me ujarẽnh ny kraxkôt ne ba me amã arẽ. Jeju. Kubê ne Metĩndjwỳnh Kra. Metĩndjwỳnh arỳm 'ã Bẽnjadjwỳrbê kumkati mẽ. Jejubê Bẽnjadjwỳrbê kumkatikôt ne me kum Kritu jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Idjaij ne amrẽbê Metĩndjwỳnh kukwakam kabẽn. Kabẽnkam ne Metĩndjwỳnh Kramã kum, “Ota ba akukãm ajã ujarẽnh djwỳnh'õ jano kute akutêp me akre nhym me kute mar ne adjwỳnhràm axwemã irern katàt kute amijo bamã. Kute mrãmri ne me kute me bẽnjadjwỳr rũnh kutêp katàt pry jadjwỳrja pyràk”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ne ajte me bakukãmãremã kum, “Me'õ dja kapôt kukritkam memã kabẽn ne. Kàj bê dja me akren memã kum, ‘Me apa. Ẽ, on Bẽnjadjwỳr djwỳnh kutêp wãnh ajaxwemã anhiren katàt amijo aba. Kute mrãmri ne me kute bẽnjadjwỳr rũnh kutêp pryo mex ne kute kum katàt pry jadjwỳrja pyràk’, ane. Dja ã me'õ Bẽnjadjwỳr djwỳnh'ã memã ane.” Nãm ã Idjaij me bakukãmãremã ane nhym me arỳm 'ã pi'ôk no'ôk ne. Nhym kam me aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm 'ỳr o bôx. Tũ:mràm 'ỳr o bôx nhym Djuão arỳm kato. Me bakamingrãnyrekam katon arỳm abatành ne. Abatành ne arỳm ã Kritu kukãm memã ujarẽnh ar bao ane. Metĩndjwỳnh kute me bakukãmãremã 'ã ujarẽnh kôt arỳm katon ã wỳnhràm ar me akreo bao ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nãm kapôt kukritmã kato. Katon arỳm ngômã me angjênh ar o ban ar me akreo ba. Nãm memã kum, —Me ga ne ga me ajaxweo aba tũm. On me amikam akaprĩren wãnh ajaxwemã anhiren Metĩndjwỳnh'ỳr amijo akẽx. Dja ga me ane nhym Metĩndjwỳnh arỳm me ajaxwe maro aknon arỳm ngryk kêt. Ba kam arỳm Metĩndjwỳnhmã ngômã me ajangij. Nãm ã memã anhỹr ar o ba. ");
INSERT INTO txuNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nhym kam pykabê Djudêjakam me jamẽ krĩraxbê Djeruxarẽkam me jamẽ aben totokmã Djuão'ỳr ban bôxo dja. Bôx ne tu me ipôkri amijaxwe kôt amijarẽn kum, —Be mrãmri, ba ijaxwe: ar iba. Arỳm imã kĩnh kêt ne wãnh kum inhire, ane. Nhym Djuão arỳm ngô raxbê Djodãokam Metĩndjwỳnhmã ngômã me kunĩ jangij. ");
INSERT INTO txuNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Be, Djuão ne mry jabatànhbê kameru kĩ nhipêxo kubẽkà jangij ne mry kào amikrax pren mỳjja kute krytkanhê pyràk kun menh kangôo ikõ. ");
INSERT INTO txuNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nãm kàj bê memã Jeju'ã ajarẽn memã kum, —Itotokbê ne me'õ bôxmã. Me'õ tãm ne raxo kute ijakrenh, kute ijakrenh mexi. Nã bãm te irax ne 'ỳr ibikamẽnh prãmje. Nã bãm te irax ne 'ã inhibôn ije kum parkà 'ãpre bônh ne o itẽm prãmje. Be, ãm irax ba ren arỳm kum apê. Nhym be kati. Ãm ingrire. Nãm raxo ijakrenh mex ne. Tãmja ne arỳm bôx 'ỳr. ");
INSERT INTO txuNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ba ne ba ngômãbit me ajangij. Djãm tãmwã kute ngômã me ajangjênhmã? Kati. Tãm dja bôx ne kam me awỳr Metĩndjwỳnh Karõ jano. Nãm ã Djuão memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nhym kam pykabê Garrêjakam krĩraxbê Nadjare. Kurũm arỳm Jeju tẽ. Tẽ:n kam arỳm Djuão'ỳr bôx. Nhym kam arỳm ngô raxbê Djodãokam ngômã Jeju jadjà, Metĩndjwỳnhmã adjà. ");
INSERT INTO txuNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nhym arỳm ngô kurũm kator tẽ nhym aêrbê kàjkwa abenbê ajkij nhym arỳm omũ. Nhym Metĩndjwỳnh Karõ kute tut pyràk 'ã ruw. Me kute omũnh kadjy ne amijo tut pyràk ne 'ã ruw. ");
INSERT INTO txuNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nhym arỳm kàjkwa kurũm Metĩndjwỳnh Jejumã kabẽn ne kum, —Mrãmri abê ikrakumrẽx. Imã ajabê:kumrẽx. Ba akam ikĩnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ne kam adjynkêt ne Metĩndjwỳnh Karõ kabẽno amũ Jeju kujaten kapôt kukritmã o mõn o bôx ne ipôkri o ba. ");
INSERT INTO txuNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nhym kapôt kukritkam rop mõr djàkam ar ba. Nhym kam me axwe nhõ bẽnjadjwỳrbê Xatanaj te kute axwe'ã Jeju mẽnhmã kum àpnênho dja nhym 'ã akatibê 40 apêx. Nhym kam kadjy mrãnh djwỳnh arỳm Jeju'ỳr bôx ne o djuw mex. ");
INSERT INTO txuNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nhym kam Jeju arỳm tẽ. Tẽ:n pykabê Garrêjakam bôx. Me arỳm kute Djuãoo tỹm ne kubê ijêkam ne Jeju kam bôx. Bôx ne kàj bê memã ujarẽnh ny jarẽnho ba. ");
INSERT INTO txuNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nãm memã kum, —Be, Metĩndjwỳnh kute amrẽbê me bakukãmãremã arẽnh kôt arỳm õ akati bôx 'ỳr. Kute amim me utàr ne ar meo ba 'ỳr. Me on amikam akaprĩren wãnh ajaxwemã anhiren Metĩndjwỳnh'ỳr amijo akẽx ne tu amim ujarẽnh ny markumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ne kam Garrêjakam imôti mỳrbê tẽ. Nhym Ximãomẽ Ãngre ar axikôt katorja ngônhkam ar kryre rẽnho ba. Ar kubê tep pynênh djwỳnh tũm. ");
INSERT INTO txuNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ar kryre rẽnh ar o ba nhym Jeju arkum kabẽn ne arkum, —Amrẽ ar mã ikôt ajkamẽ ba ar amã ar adjàpênh djà ny jarẽ gar ar o aba. Dja gar mã ikôt me kamẽnh ar o aba. Kute mrãmri ne gar aje tep pynênho abaja pyràk dja gar mã ikôt me kamẽnh ar o aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nhym ar arỳm amikôt kryre mẽn mã Jeju kôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nhym ajbir tẽ nhym Xijagumẽ Djuão ar axikôt apôxja kàkam amim kryreo mexo nhỹ nhym arỳm ar omũ. Djebedêu ne ar adjuw. ");
INSERT INTO txuNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nãm ar omũ nhym adjynkêt nhym amikôt ar ku'uw. Nhym Bãm Djebedêumẽ õ àpênhmẽ ar kàkam nhỹ. Nhym Xijagu ar arỳm wãnh ar wãmã iren mã Jejukôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jejumẽ ar mõ:n arỳm krĩraxbê Kapanakam bôx. Nhym kam ar'ã pi'ôk ràràr. Ar'ã me tyk djà kêt djà nhõ akati nhym kam ar mebê idjaer bikprõnh djàmã wadjà. Nhym kam arỳm memã 'ã ujarẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nhym me Jejukam no tyn kumex ne kam abenmã kum, —Tô mỳj kabẽn ny got ja? Nãm prĩne kute amimarkôt katà:t memã amikukràdjà jarẽnhkumrẽx. Nãm ã me bẽnjadjwỳr rũnh kwỳ kabẽn mex anen ar prĩne kabẽno meo atomo ba, ane. Djã nãm ã Môjdjê kukràdjà mar djwỳnh memã arẽnho ane? Kati. Nãm me ari no prõt ne ari kukràdjà jarẽnh'ã umju:w ne kute arẽnh katàt kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jeju memã 'ã ujarẽnho dja nhym me'õja me bikprõnh djàkam nhỹ. Me karõ punu ne me'õjao ba tũm. Nãm nhỹ nhym me karõ punu kute o baja kàj bê Jejumã kabẽn ne kum, ");
INSERT INTO txuNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Krĩraxbê Nadjarekam Jeju, mỳj ne ga aje me ijomã? Tô djãm aje me ijo abiknormã? Ba me ije apumũnh tũm. Metĩndjwỳnh mexo ne ga amex. Õ kàjkwa kurũm ne ga ruwn ar aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nhym kam Jeju kum bẽn tỳx ne kum, —Anhikrên me'õja kurũm akato, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nhym arỳm me karõ punu me'õja bĩ nhym tyko nõ. Nãm kubĩn amran arỳm kum iren katon mã tẽ. Nhym arỳm mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nhym arỳm me kunĩ te kute marmã kam no tyn kumex ne te ari aben kukij ne abenmã kum, —Mỳj ne kute? Djãm me kukràdjà ny 'õ ne wã? Nãm kute amimar kôt tu me karõ punumã kabẽn nhym arỳm kum uman kabẽn kôt mã tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nhym kam me pykabê Garrêja kunĩkôt abenmã Jeju jarẽnho ipôk ne. ");
INSERT INTO txuNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nhym kam Jejumẽ Xijagumẽ Djuão ar mebê idjaer bikprõnh djà kurũm kato. Ne kam ar Ximãomẽ Ãngre ar ũrkwãmã mõn bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nhym Ximão djupãnhdjwỳ kanên nõ. Ar wadjà nhym ar Jejumã kum, —Ximão djupãnhdjwỳ kanê kubĩ nhym nõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nhym arỳm 'ỳr tẽn 'ỳr bôx ne ikra 'amỳn kàjmã ỹr. Nhym ar aêrbê kanê kum ire nhym arỳm kàjmã dja. Kàjmã djan kam arỳm aro djuw mexo ba. ");
INSERT INTO txuNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nhym arỳm ar'ã myt wadjà. Nhym me kanêmẽ me punumẽ me karõ punu kute meo ba tũmja nhym me aben totokmã Jeju'ỳr me ja kunĩo bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nãm krĩraxja tãmkam me kunĩ 'ã akuprõ, ũrkwã jajkwa krekre'ã akuprõ. ");
INSERT INTO txuNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nhym kam apỹnh me kanê djàri kute me parja Jeju arỳm me ja krãptĩo mex. Ne me karõ punu krãptĩ kute ar meo baja arỳm ano nhym arỳm memã ire. Nhym kute anoro ãmri mã me karõ punumã kum, “Anhikrê”, ane. Mỳkam? Bir, me karõ kute Jeju pumũnh tũmkam ã kum anhỹro ba. Nhym kam ar'ã akamàt nhym ar arỳm ngõr. ");
INSERT INTO txuNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Õto nõ: nhym kam, Jeju õkrẽn'ãnh kàr pydjikam krã katon amũ arwãmã kato. Ne tẽn arỳm Metĩndjwỳnhmã kabẽno nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nhym kam Ximão ar abej mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Abej mõn kam arỳm kum katon kam kum, —E kum, me kunĩ ne me ajabej ar ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nhym arkum, —Gwaj on amũ bu'ã krĩ kwỳkamdjwỳ tẽ ba me kamdjwỳ kàj bê memã arẽ. Me wãdjwỳ kadjy ne ba ikato, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ne kam Garrêjakam pyka kunĩkôt kàj bê memã arẽnho ba. Apỹnh mebê idjaer bikprõnh djàkam memã arẽnho ba. Ne me karõ punu kute ar meo baja janoro ba nhym arỳm memã iren mã mrã. ");
INSERT INTO txuNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nhym kam me'õ ĩ kajêkam têja 'ỳr bôx ne parbê kõnkrão nhỹn kum rax jarẽn kum, —Bẽnjadjwỳr djwỳnh, ga aje inhĩ kajêkam itêkôt ipumũnh ne aje mar. Aje ijo mex prãm jabej ba ren arỳm imex ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nhym arỳm kum kaprĩn 'ỳr ikran kupên kum, —Ije ajo mex prãm. On amex, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nhym arỳm 'ã ĩ kajêkam têja apêx ne arỳm mex ne. Kute o ãm tãmkam tẽmbê kà mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Nhym kum, —Kwãrĩk wãnh ga memã amijarẽnh kêt. Dja ga tu katàt mã me kadjy Metĩndjwỳnh mar djwỳnh'ỳr tẽn kum amibẽ, kum amikà bẽ. Ne kam kum mry ngã gê akadjy Môjdjê kukràdjà kôt Metĩndjwỳnhmã mry gan kum kungã. Arỳm akà mexkam dja ga kum mrywã ngã gê me kunĩ apumũ, arỳm akà mexkôt apumũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nãm te kum ane nhym arỳm tu memã amijã ujarẽnh ar bamo krax ne kam memã amijã ujarẽnho ipôk ne. Nhym kam Jeju te irã ipôkri krĩrax'õmã àrn ar ba prãmje ne arỳm arwãkambit ar ba. Nãm arwãkam ar ba nhym me arỳm bu'ã pyka kunĩkôt 'ỳr ban bôxo dja. ");
INSERT INTO txuNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nhym kam 'ã akati kwỳ apêx nhym Jeju krĩraxbê Kapanakam tẽn bôx. Nhym kam me abenmã kum, —Arỳm ne ajte õ kikrekam bôx. Arỳm ne ajte õ kikrekam bôx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nhym kam me itepato 'ã akuprõ. Me krãptĩ: 'ã akuprõ nhym arỳm kikre kre'ã me kàtàm abenbê krãptĩ:. Ne prĩne kikre jajkwa krekre pytàr mex ne. Nhym arỳm kàj bê memã Metĩndjwỳnh kabẽn jarẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nhym ar 'õ amãnhkrut ne amãnhkrut me'õ jakryja mỳn o tẽn o bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ne kam me krãptĩkam te: Jeju'ỳr àrmã. Ne kam kikre nhimõk'ỳr o wabi. Kikre nhimõk po'ỳr ne o wabin arỳm Jeju nhiby kikre nhimõk'ã kuprã ne kôt 'ã jãm ngybôr jadjuw ne kôt 'ỳr o ruw. Akryja ikwã djàkam nõr rã'ã nhym ar o ruw ne arỳm kabem kudji. ");
INSERT INTO txuNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nhym kam Jeju amim, —Ar ja ne ar tu amim ikamnhĩxkumrẽx, ane. Ne kam me'õ jakrymã kum, —Akmere, jakam ne ba arỳm ajaxwe kunĩ maro aknon akam ingryk kêt ne, ane. Djã nãm tẽmbê me'õ jakryo mex got? Kati, nãm amidjêje nên kum jabit jarẽ nhym êje nõ. Jeju ta ne axweo akno. ");
INSERT INTO txuNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nhym wãnh Môjdjê kukràdjà mar djwỳnh kwỳ nhỹn arỳm amim, ");
INSERT INTO txuNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—E kum be me'õ ja ne ajmãn Metĩndjwỳnh japrỳo djan amijo Metĩndjwỳnho dja. Metĩndjwỳnh pydji ne kute me axweo biknorn mekam ngryk kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nãm me ã õkre kadjwỳnhbê anhỹro kumex nhym arỳm tu kuman memã kum, —Mỳkam ne ga me anhõkre kadjwỳnhbê ijo kajgon ijaprỳo akumex? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ẽ, ba me amã mỳjja amãnhkrut jarẽ. Mỳj ne amirĩt? Ba ren me'õ jakryjamã kum, “Ba arỳm ajaxwe maro aknon akam ingryk kêt”, ane. Nàr kon, “On kàjmã djan anhikwã djà mỳn o tẽ”, ane. Mỳj ne ren amirĩt, nẽn? Nã bãm ren kum, “Ba arỳm ajaxwe maro aknon akam ingryk kêt”, ane nhym amirĩt kêtkumrẽx ne. Tãmbit ne amirĩt kêt. Nhym be, kàjmã me ku'ê, ije ren me'õmã kum, “Kàjmã djan tẽ”, ane nhym ren amirĩt. Tãmbit ne amirĩtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Dja ba kum, “Kàjmã djan anhikwã djà mỳn o tẽ”, anen arỳm o mex gar arỳm omũn arỳm amim, “Be ga, Jeju kute me'õ jakryo mexja pumũ. Be, djãm kute me axweo biknor kêt got? Mrãmri ne Metĩndjwỳnh arỳm amijo ĩ ne pyka jakam amikabẽn kôt ari me axweo biknoro ba”, ane. Me aje amim ja jarẽnh kadjy dja ba me'õ jakryjao mex. Nãm ã Môjdjê kukràdjà mar djwỳnhmã anen arỳm tu me'õ jakryja'ỳr akẽx ne kum, ");
INSERT INTO txuNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Amã ne ba ikabẽn ne. On kàjmã djan anhikwã djà mỳn anhũrkwãmã o tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nhym kam me aêrbê me ipôkri kàjmã dja nhym me kunĩ arỳm omũ. Nãm kàjmã djan ikwã djà mỳn mã o katon o tẽ. Nhym me krãptĩ kam no tyn kumex ne abenmã kum, —Mỳj me'õ got mỳjja mex ja'õ pumũ. Arkati, anen amim, —Ẽ, arỳm ne djãm mrãmri o mex nhym mrãnh mexja pumũ. Mrãmri ne kabẽnkumrẽx. Djãm kute me axweo biknor kêt got? Mrãmri kute me axweo biknorkumrẽx. Ga, kute kam me'õo mex nhym mrãnh mexkumrẽxja pumũ. Metĩndjwỳnh mexkumrẽx, ane. Mrãmri ne Jeju kute me axweo biknorkumrẽx. Me kute ja mar kadjy ne Jeju arỳm me'õ jakryo mex. Tãm ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nhym kam Jeju arỳm katon ajte imôti mỳrbê tẽ. Nhym kam me itepato 'ã akuprõ nhym arỳm memã 'ã ujarẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ne kam amũ tẽ. Tẽ: nhym kam Rewi, Aupêu kute irja nhỹ. Kubê ne Matêu. Bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djàkam ne nhỹ nhym arỳm omũ. Ne kam 'ỳr tẽn kum, —Amrẽ on mã ikôt ajkamẽ, ane. Nãm kum ane nhym amim kuman arỳm kàjmã dja. Kàjmã djan arỳm mã kôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nhym kam Jeju Rewi nhõ kikrekam õ kwỳ krẽno nhỹ. Nhym bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnh krãptĩ Jejumẽ ro'ã nhỹ. Nhym we me axwedjwỳ ikô'ã nhỹ. Me krãptĩ ne me nhỹ. Be, me ja krãptĩ ne me arỳm amim Jeju man kôt ba. Nhym kôt ba djwỳnh tũmdjwỳ Jejumẽ ro'ã nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nhym mebê pardjêukôt Môjdjê kukràdjà mar djwỳnh arỳm me omũ. Pi'ôk kaprĩo atom djwỳnhmẽ me we axwe ar Jejumẽ ro'ã õ kwỳ krẽno nhỹ nhym me arỳm me omũ. Ne kam arỳm kôt ba djwỳnhmã kum, —Be, gar bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnhmẽ me axwe ar omũ. Je tô, djãm me wã axwe ngri got ne Jeju me ro'ã õ kwỳ krẽno nhỹ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nhym Jeju arỳm me kabẽn ma. Me kute, —Djãm me wã axwe ngri got? anhỹrja Jeju kuman memã kum, —Djãm me mex'ỳr ne me kane djwỳnh mrã? Kati, me kanê'ỳrbit ne me kane djwỳnh mrã. Badjwỳ ne ba me axwe'ỳr tẽ. Djãm we me amex'ỳr ne ba tẽ? Kati, me axwe'ỳr ne ba tẽ. Me tãm ne ba amiwỳr me ku'uw. Me amikam kaprĩren wãnh axwemã irern kute iwỳr amijo akẽxmã ne ba amiwỳr me ku'uw. Nãm ã Jeju mebê pardjêumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nhym kam Djuãokôt ba djwỳnhja ne ar Metĩndjwỳnhmã amijajburo ba. Djuãobê ngômã me angjênh djwỳnhja. Nãm ar amijajburo ba. Mebê pardjêu nhõ me jadjwỳ ne me amijajburo ba. Nhym kam me Jeju'ỳr mõn 'ỳr bôx ne kukij ne kum, —Be, Djuãokôt me ba djwỳnhmẽ mebê pardjêu nhõ me jamẽ ne me amijajburo ba. Je tô, mỳkam ne akôt ba djwỳnh ar kute amijajbur kêt mex ne ar ba, ane? ");
INSERT INTO txuNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nhym Jeju tu amijã me'õ mjên jarẽn amikôt ba djwỳnh ar'ã mjênmẽ ro'ã ar ar ba jarẽn memã kum, —Ga, me kute abenã prõmẽ mjên rẽnhja pumũ. Djãm mjênmẽ ro'ã ar ar baja kute amijajbur got? ");
INSERT INTO txuNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Arkati. Mjênmẽ ro'ã ar ar baja ar kĩnhkumrẽx ne kute amijajbur kêt. Ar õ kwỳ krẽn rax. Adjỹm, akati amrẽ mõrjakam dja me Ar kubê mjêno tỹm ne mã o mõ. Kam gêdja ar kaprĩren arỳm Metĩndjwỳnhmã amijajburo ba, ane. Mỳj'ã ne me kute Ar kubê mjêno tỹm jarẽ? Bir, ta amijã ne arẽ. Jeju dja me o tỹm ne mã o mõ. Kambit dja kôt ba djwỳnh amijajburo ba. ");
INSERT INTO txuNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Be ga, me kute jãm amim Jeju kukràdjà ny mar ne ajte jãm amim kukràdjà tũm marja pumũ. Me kute amim amẽ kukràdjà maro bakam ne me umar mex kêt. Me kute mrãmri ne kubẽkà ny tũm'ã ir pyràk. Ne me ajte ãm mrãmri ne kute pidjô kangô ny ngônh tũmkam runh pyràk. 'Ã ne Jeju ajte memã kum, —Ga, me'õ nhõ kubẽkà tũm ne 'yrja pumũ. Nhym kam arỳm kubẽkà ny, põnh kêt. Djã ne tũm'ã kudji? Kati. Mỳkam? Bir, dja me kupõ. Nhym kam arỳm põnhkam nykam ê abenmã wangij. Abenmã wangij nhym arỳm tũmja kadjô. Nhym kam arỳm 'yr nyja kute 'yr tũmja jakrenh mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ga, me'õ nhõ mrykào ngônh. Me bakukãmãre ne me mrykào ngônh. Mrykào ngônh arỳm tũm ne ngràja pumũ. Djã ne kam uba kangô ny ru? Kati. Mỳkam? Bir, ãm 'ãtũmkam arỳm uba kangô kadjàn ajmrô nhym ngônh arỳm igot tẽn arỳm ajkatõr. Nhym arỳm kangô ajkapĩ nhym ngônh arỳm punu ne. Be, kam mex rã'ã kadjy mrykào ngônh ny, kà rerekrekambit me kute kangô ny runh prãm. Nhym kam amẽ mex rã'ã. Nãm ã Jeju memã ane. Gêdja me amim kukràdjà nybit maro ban arỳm umar mexkumrẽx. Nhym be, gêdja me amim me kukràdjà tũmdjwỳ mar prãm ne arỳm umar mex kêtkumrẽx. 'Ã ne Jeju memã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ne kam pi'ôk ràràrkam pur katikôt tẽ. Nhym kôt ba djwỳnh arkôt mõ. Kôt mõn arỳm kum prãm ne mõrkôt bàygogo 'y nhikẽn mrãnhkôt ngãnh ne amijajkwamã rẽnho mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nhym kam mebê pardjêu ar omũn kum, —Je tô mỳj ne akôt ba djwỳnh ar arỳm nẽ? Pi'ôk ràràrkam ne me tyk djà kêt djà. Me kute pi'ôk ràràr jakam mỳjja jao anhỹr kêt. Me tũmre ne me ta kukràdjàkôt mã me babê uma. Me kute pi'ôk ràràrkam mỳjja kupênh kêt. Kam ne me tyk djà kêt djàbit. Mỳkam ne akôt ba djwỳnh ar ã anhỹro ba? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nhym kam Jeju memã kum, —Kê, djãm me aje Metĩndjwỳnh kabẽn'ã pi'ôk no'ôkjadjwỳ pumũnh kêt? Djãm me aje me bakukãmãrebê Dawi'ã ujarẽnhja pumũnh kêt? Ẽ, Dawi arkum prã:m. ");
INSERT INTO txuNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kum prãm ne arỳm Metĩndjwỳnh nhũrkwãmã wadjà. Amrẽbê: me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax ne kubê Abijta. Metĩndjwỳnh nhũrkwãkam ne me bakukãmãremã nhỹ. Nhym Dawi ar Metĩndjwỳnh nhũrkwãmã wadjàn djwỳ byn kukrẽn kam kôt ar tẽm jamãdjwỳ kungã nhym ar arỳm kukrẽ. Djwỳ me kute Metĩndjwỳnhmã õrja tãm ne kubyn kukrẽn arkum kungã. Metĩndjwỳnh nhõ djwỳ ne me kàtàm kute kur kêtkumrẽx. Me kadjy Metĩndjwỳnh mar djwỳnhbit ne kute kur. Nhym be, Dawi ta ne tu kubê kukrẽ. Nhym kam me kute kum axwe jarẽnh kêt. Djãm me aje ja mar kêt? Ga, me kute Dawimã axwe jarẽnh kêtja pumũ. Ne kam ikôt ba djwỳnhmẽbit ar imã ar axwe jarẽ. Je tô mỳkam? Nãm ã Jeju mebê pardjêumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ne kam ajte memã kum, —Djãm me kute pi'ôk ràràr ajbit maro ba kadjy ne Metĩndjwỳnh me ipêx? Kati. Me tỳx djà kadjy ne Metĩndjwỳnh akati ja jarẽ nhym wajêt. ");
INSERT INTO txuNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ba me amã arẽ ga me ama. Ba ije amijo inhĩ ne me awỳr irwỳk ne ba inhõ pi'ôk ràràr djwỳnh. Kam gêdja ba memã, “Kwãrĩk wãnh ga me kam mỳjja kupênh kêt nàr kon, dja ga me jakam apên nàr kam mỳjja kupênh kêt ne arek akrĩ”, ane. Tãm ne ja. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nhym kam ajte ar'ã pi'ôk ràràr nhym kam ar me bikprõnh djà'ỳr bôx ne wadjà. Nhym me'õ nhikra nhikjê jarõxja me ikô'ã nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nhym kam me kam krĩja amim, —Adjỹm, dja te me tyk djà kêt djà nhõ akati nhym arỳm me'õjao mex, ane. Ne kam Jeju kam no tyn kumex. Kute me'õjao mex jabej rĩto kumex. Adjỹm. Dja me'õo mex nhym me arỳm 'ã axwe nhôn memã kum, —Tãmwã ne kum me bakukràdjà kurêkumrẽx ne pi'ôk ràràrkam meo mexo ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nãm me kam no tyn kumex nhym Jeju arỳm me'õ nhikra jarõxjamã kabẽn ne kum, —Amrẽ tẽn me ipôkri dja, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ne kam me kukij ne memã kum, —Amrẽbê: ne me bakukãmãre Môjdjê pi'ôk ràràr'ã memã karõ. Mỳj godja me kam nẽ? Godja me kam àpênh mex jabej nàr godja me kam àpênh punu jabej. Nàr godja me kam me utàr jabej nàr godja me kam me par jabej. Mỳj godja me pi'ôk ràràrkam nẽ? Be, ba dja ba me'õjao mex. Djãm kôt me aje imã ijaxwe jarẽnhmã? ane. Nãm ane nhym me arỳm bẽn kêt mex ne nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nhym me kute kabẽn mar prãm kêtkam arỳm mekam kaprĩ:re ne. Ne kam arỳm nokà nhàn me omũ. Ne kam tu me'õ nhikra jarõxmã kum, “Amrẽ anhikra katàt”, ane. Nhym 'ỳr ikra katàt tẽm puron arỳm ikra mex ne. Arỳm prĩne kum mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nhym mebê pardjêu arỳm ngryk ne mã apôx. Ne kam on Erodjikôt me ba djwỳnh'ỳr mõn me'ỳr bôx. Ne kam arỳm Jejuo aben man abenmã kum, —Mỳj godja gwaj baje Jeju bĩn kadjy on? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Nhym kam Jejumẽ kôt ba djwỳnh ar me kurũm kato. Katon arỳm imôti'ỳr mõ. 'Ỳr mõn arỳm 'ỳr bôx. Nhym me krãptĩ: apỹnh pyka djàri kurũm arkôt mõn bôx. Garrêja kurũm ne me kwỳ bôx. Nhym Djudêja kurũm me kwỳ bôx. Nhym me kwỳ krĩraxbê Djeruxarẽ kurũm bôx. Nhym me kwỳ Idumêja kurũm bôx. Nhym me kwỳ ngôbê Djodão nhikjêbê apỹnh kikre djàri kurũm bôx. Nhym me kwỳ krĩraxbê Xirumẽ Xidõ kurũm mõn bôx. Jeju kute apỹnh mỳjja pumũnh kêt nhipêx djàri ne me arỳm omũn amũ memã 'ã ajarẽ nhym me arỳm kuma. Ne kam arỳm itepato arkôt mõn bôx. Me krãptĩ: bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nhym kam Jeju arỳm kôt ba djwỳnh arkum, —Gar ikuri kà'õ dji. Godja me ijo bikamỳr jabej ba on mebê kàkam nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Bir, kute me krãptĩo mexkam ne apỹnh me punu djàri kute kupênh prãm. Me krãptĩ: te kupênh prãmje ari Jeju kôt bikamẽnho ku'ên ingãnho kumex. Kam ne ar kute kuri kà'õ djirmã arkum kà jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nhym mekôt apỹnh me karõ punu kute ar meo ba. Nhym me Jeju parbê rôrôk. Me karõ kute Jeju pumũnhkam ne me mã: parbê rôrôk ne mã: kàj bê kum kabẽn ne kum, —Ga abê Metĩndjwỳnh Kra, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nhym kam mã me karõ punumã bẽn tỳx ne kum, —Dja ga me ipudju, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ne kam arỳm krãnh'ã wabi. 'Ã wabin arỳm amikôt ar ku'uw. Kum ar kĩnh djàri ar ku'uw nhym ar arỳm 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Nhym kam arỳm amikôt ar umjuw. Ar kubê 12 pumjuw. Dja mã amimẽ aro ba nhym ar arỳm ỹtãri omũn kabẽn maro ba. Nhym kam kute ar anorn kute arkum, —Dja gar kàj bê memã ijã adjujarẽnh ar aban kam ikukwakam me punuo mexo aban kam me karõ punu janor ne kujaêko aba, anhỹrmã. Dja ã Jeju Ar kubê 12mã ane. Ja kadjy ne amikôt ar umjuw. Nhym kam me aben djô'ã ar'ã abenmã kum, —Kute ar anorja, anhỹro ba. ");
INSERT INTO txuNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","17","Be, kute amikôt Ar kubê 12 pymjỳr nhidji jarẽnh kadjy ne ja. Ximão. Ajbir ne Jeju kum Pedru jarẽ. Xijagu. Djebedêu ne Xijagu dji. Djuão. Xijagumẽ ne Djuão ar axikôt kator. Ajbir ne ar amẽmã Bôanedu jarẽ. Na krikrit'ã ne ar idji amijakre. ");
INSERT INTO txuNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ãngre. Piripi. Batormê. Matêu. Tôme. Xijagu 'õdjwỳ. Aupêu ne Xijagu ja dji. Tadêu Ximão 'õdjwỳ. Idji nhikjêbê ne Xerodji. ");
INSERT INTO txuNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Djuda. Idji nhikjêbê ne Ikadji. Ta dja kurê djwỳnhmã Jeju kanga. Be, Ar kubê 12 nhidji ne ja. Jeju kute amikôt Ar kubê 12 pymjỳr ne kute ar anor ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nhym kam Jeju ar mõn arỳm kikre 'õmã wadjà. Nhym kam me krãptĩ: ajte ar'ã akuprõ. Nhym kam ar te kute õ kwỳ krẽn mexmã. ");
INSERT INTO txuNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nhym Jeju kute meo õbikwaja arỳm me krãptĩ: jarẽnh man abenmã kum, “Bãrãm arỳm ajbã”, ane. Ne kam kute o tỹm ne pa 'amỳnhmã kôt tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nhym Môjdjê kukràdjà mar djwỳnh kwỳ ne me arỳm krĩraxbê Djeruxarẽ kurũm tẽn mekôt bôx. Ne kam arĩk Jeju'ã memã kum, —Be, djãm Metĩndjwỳnh kukwakam ne me karõ punu kujaêko ba? Kati. Me karõ punubê Bedjêbu ne o ba. Me karõ punu nhõ bẽnjadjwỳr kukwakam kute me karõ punu janor ne kujaêko ba. Nãm me ã Jeju'ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nhym kam amiwỳr me ku'uw ne apỹnh kukràdjà djàri'ã memã mỳjja jakren 'ã memã ajarẽn memã kum, —Djãm mrãmri ne ba we Xatanaj kukwakam õ àpênh kujaêko iba? Kati. ");
INSERT INTO txuNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Me aben djwỳnh tãm kum aben kurêkam ne kurê djwỳnh arỳm meo apêx. ");
INSERT INTO txuNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nàr, õ kikre tãmkam me krĩ godja me ta kum aben kurê jabej nhym me arỳm aben bê me kungrà. Djãm mrãmri ne ba we Xatanaj kukwakam õ àpênh kujaêko iba? Kati. Djãm Xatanaj kum õ àpênh kurê? Kati. ");
INSERT INTO txuNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Be, Xatanaj ren kum õ àpênh kurên kujate nhym ren õ me arỳm aben bê ajmà nhym ren arỳm bẽnjadjwỳr'ã aminhinomã amimẽ. Nhym be, kati. Xatanaj kum õ àpênh kurê prãm kêt. Ne ba ren Xatanaj kukwakam õ àpênh kujate nhym ren Xatanajdjwỳ kum õ àpênh kurê. Nhym be, kati. Xatanaj kum õ àpênh kurê prãm kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ga, me'õ tỳx nhũrkwãja pumũ. Mỳj dja me kute õ nêkrêxo prõt kadjy me'õ tỳx nhũrkwãmã àr on? Bir, dja me me'õ tỳx kumrẽxo tỹm ne uwpre. Ne kam arỳm ũrkwãmã wadjàn kubê nêkrêxo prõt ne, ane. Mỳj'ã ne Jeju me'õ tỳx jarẽ? Bir, Xatanaj'ã. Dja me Xatanaj kumrẽxo tỹm ne uwpren kam arỳm amim õ me ja pytà. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ne kam ajte memã kum, —Kam ba me amã arẽ ga me ama. Me kute mỳjjao bikẽnh kunĩkôt ne Metĩndjwỳnh me axweo aknon mekam ngryk kêt. Me kute Metĩndjwỳnh japrỳkam dja o aknon me kam ngryk kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nhym be, dja me Metĩndjwỳnh Karõ japrỳ nhym arỳm mekam ngryk rã'ã ne memã axwe jarẽnh rã'ã: rã'ã ne. Nãm ã Jeju memã ane. Mỳkam ne ã memã ane? ");
INSERT INTO txuNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bir, Metĩndjwỳnh Karõ ne mã Jejuo ba nhym me arĩk 'ã memã kum, —Me karõ punu ne ar o ba, ane. Nhym kam arỳm Metĩndjwỳnh Karõ'ã me kabẽn punu nêje me kukrà. ");
INSERT INTO txuNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nhym kam Jeju nhõbikwa ar kute o tỹm ne pa 'amỳnhmã kôt mõ. Jeju nãmẽ kamyre ar axikôt apôx ar Jejukôt tẽn kam arỳm mekôt bôx. Ne kam ar arek bõm ku'ê. Arek ku'ên arỳm 'ỳr me'õ jano. Kute amiwỳr 'wỳr kadjy 'ỳr ano. ");
INSERT INTO txuNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nhym me krãptĩ: bu'ã ku'ê nhym me'õja 'ỳr bôx ne kum, —E kum, bõm anãmẽ atõnhre ar amã kabẽn, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nhym kum, —Be, mỳj dja mekam kute ba kum, “Nhirwa”, ane nàr kum, “Akmere”, ane? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ne kam ari me bu'ã ku'êkôt krãn memã kum, —Ota, inãmẽ ikamy ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Dja gar Metĩndjwỳnho kĩnh kadjy kabẽn man kôt ar amijo aba. Ba kam arỳm ar amã, “Akmere” nàr amã, “Àpnhĩre”, ane nàr amã, “Nhirwa.” Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ne kam akati tãmkam tẽn arỳm imôti mỳrri nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nhym kam me krãptĩ: 'ã akuprõ. Nhym kam arỳm mebê tẽn kàkam nhỹ nhym me krãptĩ: arỳm ngô mỳrri kum dja. ");
INSERT INTO txuNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Nhym kam arỳm apỹnh kukràdjà djàri'ã memã mỳjja jakren memã 'ã ajarẽ. Ne memã kum, —Ẽ, õ pur djwỳnh ne kute õ purkam bàygogo kremã 'ỳr o tẽ. 'Ỳr o tẽn o bôx ne kam ar 'yo ukabêr mrã, ane. Nãm me kute mỳjja kre kadjy tu mỳjja 'yo ukabê, bàygogo 'yja ne me kute purkam kremã o mrãn kam purkam o ukabêr mrã. Kute mrãmri ne me kute katẽbàri 'yo ukabêr mrãnhja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nãm Jeju memã kum, —Be, me'õ ne ar bàygogo 'yo ukabêr mrã. Nhym 'y kwỳ prykam rôrôk. Nhym kwênh prĩne kuku. ");
INSERT INTO txuNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nhym kwỳ kẽnpo'ã pyka purorrekam rôrôk. Nhym kam pyka purorrekam ingrõt kukrà kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nhym kam kỳjrũm myt nhỹn arỳm 'y nhingrõt ga nhym kajot ne arỳm ty. Arê jabjê kêtkam ne ty. ");
INSERT INTO txuNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nhym 'y kwỳ mrỳnhĩkam rôrôk ne kam mrỳnhĩmẽ ro'ã ingrõt ne. Nhym kam prĩne o akno nhym arỳm bàygogo 'y kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nhym 'y kwỳ pyka mexkam rôrôk ne ingrõt ne kam abatành ne. Ne arỳm apỹnh bàri ku'ê djàri nhym kwỳ'ã kàjbê ijy mex nhym 'y'ã akre kubê 30. Nhym kwỳ ijy mexkumrẽx nhym 'y'ã akre kubê 60. Nhym kwỳ ijy jabjê nhym 'y mexti:re ne kam 'y'ã akre kubê 100. Nãm ã Jeju Metĩndjwỳnh kukràdjà'ã apỹnh mỳjja jakreo ane. ");
INSERT INTO txuNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ne ajte memã kum, —Gop me ajõ ajamak mex jabej tu amim ikabẽn markumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nhym kam me krãptĩ mã mõ. Mã mõ nhym Jeju ar arỳm ate nhỹ. Nhym bu'ã ar jamẽ kôt ba djwỳnhbê 12 ar arỳm kukij ne kum, —Mỳkam ne ga apỹnh kukràdjà djàri'ã mỳjja jakren memã ajbit jarẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nhym arkum, —Bir, djãm me kunĩ kute ikukràdjà marmã? Kàjkwakam Bẽnjadjwỳr djwỳnh kute amim me utàr ne ar meo ba'ã ikabẽn kukràdjà djãm me kunĩ kute marmã? Kati. Ar gajbit ije ar amã arẽnho amirĩt gar aje marmã. Nhym be, me wãbê ne ba udju ne. ");
INSERT INTO txuNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Me wã kute mar kajgokam ne ba apỹnh kukràdjà djàri'ã memã mỳjja jakren memã mỳjjabit'ã ajarẽ. Me kute ikukràdjà mar kajgo wã ne amrẽbê: me bakukãmãre memã arẽn memã kum, “Me te memã mỳjja jakre nhym me omũnh kajgon mã amim omũnhkumrẽx kêt. Nhym me te memã mỳjja jarẽ nhym me me kabẽn maro krĩn mã mar kêt. Mã kukràdjà'ã mỳjja kute amijakreja mar kêt. Kute Metĩndjwỳnh'ỳr amijo akẽx kêt nhym me axwekam ngryk rã'ãmã.” Nãm me bakukãmãre ã me wã'ã memã ane. Kam ne ba apỹnh kukràdjà'ã apỹnh mỳjja jakren memã mỳjjabit'ã ajarẽ. Me wã kute mar kajgokam. ");
INSERT INTO txuNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ne kam ajte arkum, —Be, ikukràdjà ije ajbir 'ã me'õ kute bàygogo 'yo ukabêr jakreja djãm ar aje mar kêt? Be, dja ba apỹnh ikukràdjà'ã mỳjja jakre rã'ã. Mỳj godja gar amũ ikukràdjà ja mar on. ");
INSERT INTO txuNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Be, Metĩndjwỳnh kabẽn'ã ujarẽnh djwỳnh ne arỳm memã arẽ nhym me kuma. ");
INSERT INTO txuNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kuma kute mrãmri ne 'y kwỳ prykam rôrôk pyràk. Nhym ate Xatanaj totokbê jãm mebê o amijakren mebê Metĩndjwỳnh kabẽno akno. ");
INSERT INTO txuNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kẽnkam 'y rôrôkja ne me kute amim Metĩndjwỳnh kabẽn mar 'iry kêt ne kangaja'ã amijakre. Nãm me myt tãmkam Metĩndjwỳnh kabẽn man bit kum kĩnhkumrẽxo tẽm kajgo. ");
INSERT INTO txuNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kute tu amim markumrẽx kêtê. Ajkwaobit ne kute mar. Kute 'y nhingrõt ne arê kêtkam tẽmbê tykja pyràk. Kute amim mar 'iry kêt nhym ate apỹnh me kaprĩ djàri me'ỳr bôx nhym me arỳm kanga. ");
INSERT INTO txuNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mrỳnhĩkam 'y rôrôkja ne me kute Metĩndjwỳnh kabẽn mar ne kam ate ajte kute jãm mỳjja marja'ã amijakre. Nãm me arỳm Metĩndjwỳnh kabẽn man ");
INSERT INTO txuNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kam 'ãno ãm kêt ne amim, “Mỳj dja ba nẽn inhõ kwỳ krẽn mex ne inhõ kubẽkà mex? Ikanêkam mỳj dja ba nẽ”? ane. Nãm pykakam mỳjjabitkam ar no katon axwe umar. Ne kam amim pi'ôk kaprĩo atom rax prã:m ne ajte apỹnh mỳjjao atom rax prã:m. Djãm kute amim mỳjjao atom raxkam mrãmri umar mex? Kati. Bir, me arỳm õ mỳjja rũnhkam mrãmri umar punukumrẽx. Ga, mrỳnhĩ kute bàygogoo bikẽnh nhym kam ijy kêtja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ga, me'õ bàygogo 'yo ukabêr tẽ nhym ajte kwỳ pyka mexkam rôrôkja pumũ. Nhym arỳm ingrõt ne abatành ne. Abatành ne arỳm ijykam 'y kume:x. Me kwỳdjwỳ ne me memã Metĩndjwỳnh kabẽn jarẽ nhym me arỳm tu amim markumrẽx. Ne kam maro amũ amikamẽn arỳm mar rax ne. Mar rax ne arỳm ukaprĩkumrẽx. Me kwỳ ne me kàjbê ukaprĩ kryre kute mrãmri ne bàri kwỳkam ijy mex nhym kam 'y kubê 30 pyràk. Nhym me kwỳ ukaprĩkumrẽx kute mrãmri ne bàri kwỳkam ijy mexkumrẽx nhym kam 'y kubê 60 pyràk. Nhym me kwỳ ukaprĩti:re kute mrãmri ne bàri kwỳkam ijy mexti:re nhym kam 'y kubê 100 pyràk. Me ukaprĩkumrẽx nhym Metĩndjwỳnh arỳm mekam kĩnhkumrẽx. Mekam kaprĩre kêtkumrẽx. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ne kam arkum, —Be, godja me me'ỳr ngônhpôko bôx jabej djãm me kute mỳjja 'õkôt o bipdjur got, kute kànoipôko 'ã pro got? Nàr djãm me ikwã djà krakri me kute umjỳr got? Kati. Ngônhpôk ne me kum angij ne tu parkam kênhkam umjuw. ");
INSERT INTO txuNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ba ar amã arẽ gar ama. Ikabẽn kukràdjà ije 'ã apỹnh mỳjja jakren mebê udjurja dja ĩ me kunĩmã amirĩtkumrẽx nhym me kunĩ kuma. ");
INSERT INTO txuNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Gop ar ajamakkre mex jabej tu amim ikabẽn markumrẽx. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne kam ajte arkum, —Ar ikabẽn mar 'ãno dja. Ar ajamakkre mex kôt dja ba ar amã ikabẽn jarẽ. Dja gar tu amim ikabẽn markumrẽx ba arỳm ar amã ikabẽn kumex jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mỳkam? Bir, me kute tu amim ikabẽn markumrẽx jamã dja ba mã kwỳ rax ne arẽnho tẽ nhym me arỳm kwỳ rax ne kuma. Nhym be, me kute ikabẽn mar kajgoja dja Metĩndjwỳnh arỳm mebê o akno, mebê ikabẽn mar kajgo jao akno. Nãm ã Jeju kôt ba djwỳnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Me kute memã Metĩndjwỳnh kabẽn jarẽnh nhym ta kute arỳm memã amak bônh nhym me kute amũ mar kamẽnh ne kute arỳm mar rax ne. 'Ã ne Jeju memã kum, —Be, Metĩndjwỳnh kute amim me utàr ne ar meo baja'ã ne bàygogo amijakre. Be, me'õ ne bàygogo 'yo ukabêro tẽ:n arỳm 'y kre pa. ");
INSERT INTO txuNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ne kam akati kunĩkôt ate kadjy krã. Nhym kam 'y ingrõt ne abatành tẽn arỳm prĩti. Nhym kam kre djwỳnh amim, “Je, mỳj ne abatành kadjy amijon”? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Be, bàygogo ta ne pykakam abatành ne arỳm ô. 'Y kumrẽx ne pykakam ikwã. Ne kam arỳm ingrõt. Ne abatành tẽ:n arỳm prĩti. Prĩtin arỳm tujarô. Tujarôn arỳm ijy ajkapĩ. ");
INSERT INTO txuNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ajkapĩn kam arỳm prỳ ngrà. Nhym me'õja arỳm 'ãno djan êo mõ. Be, Metĩndjwỳnh kute ar meo ba ja ne me bàygogo kôt ã amijo ane. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ne kam ajte memã kum, —Metĩndjwỳnh kute amim me utàr ne ar meo baja. Mỳj ne kute me uràk? Ba ar amã arẽ gar ama. ");
INSERT INTO txuNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Me amikraxkam kajgo kute motadu 'y kajgo pyràk. Pykakam 'y bimànhkam 'y kryre. Apỹnh pidjô 'y djàri kam 'y ne kute rũnho motadu 'y jakrenh mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pykakam motadu 'y rôrôk ne kam arỳm ingrõt. Ingrõt ne arỳm rũnh mõ. Rũnh mõn arỳm amipãnh pidjô bàri kunĩ rẽ. Ne arỳm pa koror mex ne. Nhym kwênh arỳm amykrãkôt apỹnh pakam ku'ê. Nãm ã Jeju memã ane. Me kute amim Jeju marmã nhym arỳm ja pydjin kadjy amima nhym arỳm ja kadjy amiman 'ã tỹm nhym ja kôt 'ã tỹm nhym ja 'ã tỹm nhym arỳm 'ã krãptĩ ne. 'Ã ne 'y kryre ja jakre. ");
INSERT INTO txuNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mỳjja kute ajbir ja pyràk krãptĩ ne Jeju memã kukràdjà'ã akren memã 'ã ajarẽ. Me amakkre mex kôt ne memã 'ã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ne apỹnh mỳjjabit'ã ajarẽ. Nãm kute Metĩndjwỳnh kukràdjà'ã mỳjja jakrebit ne memã 'ã ujarẽnh ar ba. Ne kam arỳm kôt ba djwỳnh ar ate ỹrkam prĩne arkum kukràdjà jarẽnh mex. Kukràdjà'ã mỳjja kute amijakreja prĩne arkum arẽnh mex. ");
INSERT INTO txuNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nhym akati tãmkam arỳm ar'ã myt wadjà nhym Jeju arkum, —Gwaj on ne ikjêmã rê, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nhym kam ar me krãptĩmã kum, —Me on ajmà, ane. Nhym Jeju kôknhõkàkam ỹr rã'ã nhym ar tu amimẽ o mõ. Nhym me kwỳ kà kwỳkam arkôt mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nhym kam na 'itỳx ar'ã ruw nhym kôk 'itỳx wabê nhym kam ngô arỳm aben pumjuw ne kà nhiby aton arỳm kà krekam bikapĩno mõ. Kà krekam bikapĩno mõ nhym arỳm ipu 'ỳr. ");
INSERT INTO txuNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nhym wãnh Jeju kà katẽkam krã japar djà'ã krã djin õto nõ. Õto nõr mex katikôt nhym kôt ba djwỳnh ar arỳm tok ne kum, —E kum, ujarẽnh djwỳnh, ngô kute gwaj banhimex 'ỳr ga ate akrãn anhõto nõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nhym arỳm kàjmã djan kôkmã bẽn tỳx. Kum bẽn tỳx ne ngômã kum, —Anhikrê, on akubyn aminê, ane. Nhym arỳm kôk djàbêr amikrãta nhym ngô arỳm tu mê ne nõ. ");
INSERT INTO txuNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nhym kam arkum, —Je tô mỳkam ne gar ã atĩn prãmo ane? Mỳkam ne gar tu amim imarkumrẽx kêt? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nhym ar madjà kretin abenmã kum, —Je tô mỳj me'õ got ja? Nãm tu gêt kôkmã kabẽn nhym tu kabẽn kôt anhikrê, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ne kam imôti nhikjêmã bôx. Kam ne mebê Djeradja nhõ pyka. ");
INSERT INTO txuNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nhym kam Jeju ar akàxkam bôx ne arỳm wabin dja. Nhym adjynkêt ne me'õja pyka krã kurũm katon 'ỳr tẽ. Me karõ punu ne ar o ba. ");
INSERT INTO txuNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Pyka krãkam ne ar ba tũm. Nhym me te kàxiràxo ari uwpreo ba. ");
INSERT INTO txuNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nãm me te kadjy kàxiràxo te djê djàmẽ kàxiràxo kàkrã djê djà mỳn te o uwpre nhym mã ari kàkrã djê djà rênho ba. Ne mã ari kàxiràxo te djê djà kukẽnho ba. Nhym me kute unênh mex kadjy te: me tỳxo kute uràk'õ prãmje. ");
INSERT INTO txuNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nhym akati kunĩkôt ne akamàt kunĩkôt me'õja krãnhre'ã ar ba. Ne me tykmã kikre mẽ amijo kajkepo ba. Nãm ari àmra ban ari kẽno amijayro ba. ");
INSERT INTO txuNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Me'õja katon arỳm amybỳm Jeju pumũ. Omũn arỳm tu 'ỳr prõt ne. Prõt ne 'ỳr bôx ne arỳm ibôn nhỹ. Kute kum amijo à'wỳr kadjy ne parbê ibôn nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Nhym kam kum kabẽn ne kum, —Me karõ, apunure. On kum anhire, ane. Nhym me'õ me karõ punu kukwakam arỳm kum kabẽn ne. Kàj bê kum àmrakam kum kabẽn ne kum, —E kum, mỳj nã Jeju? Abê kàjkwakam Metĩndjwỳnh Kra. Mỳj ne ga aje ijo mã? Dja ga Metĩndjwỳnhmã akabẽn pydjin jarẽn ijã kum, “Dja ba kamjêr kêt”, ane. Dja ga ã Metĩndjwỳnhmã anen arỳm ikamjêr kêt ba arỳm itokry kêt. Nãm ã me'õ kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nhym kum, “Mỳj ne anhidji kute”? ane. Nhym kum, —Me ikrãptĩ:kam, inhidjibê ne krãptĩtire, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ne kam amijo a'uw ne kum, —Kwãrĩk wãnh me ja mõr djà kurũm me ijanor kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nhym wãnh angrô jamy krãptĩ: krãnhrekam àkur mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nhym me karõ punu krãptĩ amijo a'uw ne kum, —Gop angrô jamymã me ijano ba me kum wadjà, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nhym memã kum, “Aj mã”, ane. Nhym me karõ punu krãptĩ arỳm me'õmã iren kurũm kato. Katon arỳm angrô jamymã wadjà. Nhym angrô jamy arỳm amibêx ne tu pyka krã'yr'ã aparmã prõt. Prõt ne arỳm imôtikam nox. Nox ne arỳm ngôo aminhimex ne arỳm kunĩ ty. Angrô jamy kubê 2.000 ne ty. ");
INSERT INTO txuNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nhym wãnh angrô jamyo djuw mex djwỳnh ar arek omũnho dja. Ne kam mã krĩraxmã tẽn arỳm memã arẽ. Arwãkam me jamẽ ne memã arẽ. Nhym me kute mỳjja pumũnhmã amũ 'ỳr mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jeju'ỳr mõn 'ỳr bôx. Nhym me'õ me karõ kute kum irerja arỳm arek nhỹ. Nãm arỳm kà jadjàn no mextiren nhỹ. Nhym me kum uma ne. ");
INSERT INTO txuNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nhym ar kumrẽx kute omũnhja arỳm me'õja'ã ajarẽ. Ne ar ajte angrô jamy'ã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nhym kam me Jejumã à'wỳrmo krax ne kum, —Gop on me inhõ pyka kurũm akato, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nhym Jeju ajte kàkam ỹrmã tẽ nhym me'õ me karõ kute kum irerja kum amijo a'uw ne kum, —Ba mã akôt ajkamẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nhym kum, —Kati, mã. Akubyn anhũrkwã 'ỳr tẽ. Aje meo anhõbikwa wã'ỳr tẽ. Memã Bẽnjadjwỳr djwỳnh'ã ajarẽ. Kum akaprĩn kute ajo mex'ã ajarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nhym kam arỳm mã tẽn amũ pyka nhidjibê Krĩraxbê 10'ỳr bôx. Ne kam Jeju kute o mex'ã me kunĩmã ujarẽnh ar ba. Nhym me kunĩ te kute mỳjja marmã kam no tyn ku'ê. ");
INSERT INTO txuNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nhym kam Jeju ajte kàkam nox ne akàx nhikjêmã mõ:n kam bôx. Ne kam wabin dja. Nhym kam ajte me krãptĩ: 'ã akuprõ. ");
INSERT INTO txuNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nhym me'õbê Djajru 'ỳr tẽ. Mebê idjaer bikprõnh djàkam kubê bẽnjadjwỳr'õ. Nãm 'ỳr tẽn arỳm omũ. Omũn kute kum rax jarẽnh kadjy tu parbê tỹm ne nõ. ");
INSERT INTO txuNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ne krao a'u:w ne kum, —Wãnh ne ikra prĩtire nõn arỳm tyk 'ỳr. Gu 'ỳr ga 'ã anhikra dji gê à kêt ne imã tĩn, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nhym arỳm kôt tẽ. Tẽ: nhym me krãptĩ: prĩne aêr mex ne kôt mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nhym wãnh me'õ nire kôt tẽ. Kamrô mã: apôx'ã ne arỳm amex kubê 12 apêx. ");
INSERT INTO txuNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nhym kamã me ta kute amijo mỳjja marja krãptĩ aben totokmã te kaneo ba. Djãm kam arỳm mex got? Kati. Me ô'ã ãm mã tokryo tokry. Ne mã memã o pãnh'ã arỳm õ pi'ôk kaprĩ kunĩ krẽ. Ne kam mex kêt ne ãm punu mex mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ne kam me kute Jeju'ã ujarẽnh man arỳm 'ỳr tẽ. Me krãptĩ: Jejukôt mõ: nhym nija mekôt amibêx mex ne arỳm kôt bôx. Kôt bôx ne tu Jeju nhibũmkôt 'ã kubẽkà kupê. ");
INSERT INTO txuNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Be, kute o anhỹr kêtri ne amim, —Ba 'ã kubẽkàbit kupên arỳm imex ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nãm 'ã kubẽkà kupên kupênhmẽ ro'ã nhym arỳm kamrô ngrà nhym arỳm amikam amimex ma. ");
INSERT INTO txuNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nhym Jeju on kute o mexkôt amikam kuman arỳm me ipôkri akubyn akẽx ne memã kum, —Nhym ne ijã kubẽkà kupê? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nhym kôt ba djwỳnh kum, —Djãm me krãre ne me akuno ga, “Nhym ne ikupê”? ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nhym kute me'õmã katormã ari mekôt krã. ");
INSERT INTO txuNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nhym nija arỳm kute amimex markam 'ỳr bôx. Nãm umaje tertet ne tu parbê tỹm. Parbê tỹm ne arỳm prĩne kum amijarẽn kum, —Mrãmri, ba ne ba akà kupê ga arỳm ijo mex ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nhym kam kum, —Àpnhĩre, ga ne ga tu amim ikamnhĩxkumrẽx ne arỳm amex ne. Adjumar mex ne tẽ. Arỳm amexkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nãm ã kum anhỹro dja nhym me kwỳ bẽnjadjwỳr Djajru nhũrkwã kurũm tẽn ar kajpan arỳm Djajrumã kum, —Arỳm ne akadjwỳx akuno. Kwãrĩk wãnh ijukri ujarẽnh djwỳnh kunor kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nhym Jeju Ar kubê ate krãn arỳm Djajrumã kum, —Kwãrĩk wãnh amã akra tyk pyma kêt. Djã gãm tu amim ikamnhĩxkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ne kam Pedrumẽ Xijagumẽ Djuão arkum, —Ar gajbit dja gar ikôt tẽ, ane. Ne bu'ã me ku'êmã kum, —Me arek jakam dja, ane. Djuãomẽ ne Xijagu ar axikôt kato. ");
INSERT INTO txuNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nãm memã anen kam ar Djajru nhũrkwãmã tẽn bôx. Nhym wãnh me kangao kumex. Me muw ne abej àmrao kumex nhym Jeju arỳm me omũ. ");
INSERT INTO txuNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ne kam arỳm me'ỳr wadjàn memã kum, —Mỳkam ne ga me akangao akumex ne muw? Djã nãm prĩtija ty? Kati. Nãm õto nõ, ane. Kute akubyn o tĩnmã. Kam ne ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nãm memã ane nhym me arỳm 'ã bẽno ajkẽn keketo kumex. Nhym kam arỳm bõm me ano nhym me kunĩ kato. Ne kam bãmmẽ nãmẽ kôt ba djwỳnh ar ajbito mõn prĩti nhikwã djà'ỳr aro wadjà. ");
INSERT INTO txuNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ne kam prĩti nhikra 'amỳn kum, “Tarita kumĩ”, ane. Nãm ren me bakabẽnkam kum, —Prĩtire, amã ne ba ikabẽn. Kàjmã dja, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nãm kum ane nhym arỳm ar aêrbê kàjmã djan ar mrã. Nhym ar arỳm kôt madjà kreti. Prĩti'ã ne amex kubê 12. ");
INSERT INTO txuNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nhym kam arkum kabẽn ne amijã arkum karõn arkum, “Djã gãm ar ipudju”, ane. Ne ajte arkum, —Ar kum mỳjja'õ ngã gê kukrẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ne kam arỳm memã kàx ne amũ õ pyka djwỳnhmã tẽ. Nhym kôt ba djwỳnh ar kôt mõ. Nhym kam arỳm 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nhym ar'ã arỳm pi'ôk ràràr. Nhym arỳm mebê idjaer bikprõnh djà'ỳr tẽn kam 'ỳr bôx ne arỳm wadjà. Ne kam kute memã amikukràdjà jarẽnh kadjy arỳm amikrax ne. Nhym me krãptĩ kabẽn man kam no tyn kumex ne ari abenmã kum, —Je tô nhym nã kum me kukràdjà ja jarẽ nhym ã kabẽn mexo ane. Nhym ne kum àpênh'ã karõ nhym ã mỳjja nhipêxo ane. Mỳjja pumũnh kêtkumrẽx ne ipêx nhym kumex. ");
INSERT INTO txuNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Be, Jejubê ne pĩ kênh djwỳnh kajgo. Marij kurũm ne kato. Kôt ar apôxjabê ne Xijagumẽ Jôdjemẽ Djudamẽ Ximãomẽ. Be, ar axikôt apôx ne ja. Kanikwỳnhdjwỳ ar me baro'ã ar ba. Djãm atemã me'õ? Kati. Tãm. Me bajõ tãm. Ne kam ã àpênho ane. Nãm me ã ari abenmã anen kam arỳm kubê Jeju kĩnh no kati. ");
INSERT INTO txuNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nhym kam amijã memã kum, —Pyka kunĩkôt me Metĩndjwỳnh kukwakam ujarẽnh djwỳnhmã kàjmã rax kamẽnho ba. Nhym be, õ pyka djwỳnhkam me jabit ne me ar prãro ba. Õbikwa djwỳnhkam ar ja, õ kikre djwỳnhkam ar ja ne me ar prãro ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ne kam te kute õ pyka djwỳnhkam mỳjja pumũnh kêt krãptĩ nhipêx prãmje. Te me krãptĩo mex prãmje. Me kute aparmã rax kamẽnh prãmkam. Nãm me punu ngrêrebit'ã ikra jadjuw ne meo mex. ");
INSERT INTO txuNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ne mekam no tyn djan amim, —Je tô mỳkam ne me kute inhõ pyka djwỳnhkambit amim imar kêtkumrẽx, ane. Ne kam arỳm tẽ. Apỹnh krĩkôt tẽ. Memã amikukràdjà jarẽnho tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ne kam amiwỳr Ar kubê 12 'uw nhym ar arỳm 'ỳr bôx. 'Ỳr bôx nhym kute amũ ar anor kadjy arỳm aro aben nhikjê. Ne ar kute kukwakam me karõ punu janor ne kujaêk kadjy arkum amipyma jadjà. ");
INSERT INTO txuNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ne kamã arkum 'ã karõn arkum, —Ar amõr kadjy kwãrĩk wãnh mỳjja krãptĩ byr kêt. Dja gar akajpar djàbit by. Kwãrĩk wãnh mokà byr kêt. Kwãrĩk wãnh djwỳ byr kêt. Kwãrĩk wãnh anhõ katõk'y djàkam pi'ôk kaprĩ byr kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ne ar aparkà ponh jangjên ar anhinôkà pỹnhbit jangjê, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ne kam ajte arkum, —Dja gar apỹnh krĩ'ỳr mõ. Nhym me'õ arỳm ar amã aminhũrkwã jarẽ. Kumã dja gar wadjàn kambit anhikwã. Ne kam me õ krĩrax kurũm ar amõrkambit dja gar anhũrkwã 'õdjwỳ jabej. ");
INSERT INTO txuNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nhym godja me ar abê aminhũrkwã nê jabej ne kute ar amar prãm kêt jabej gar mebê aparkà'ã me õ pyka ka'u. Me kurũm akatorkam pyka ka'u. Aje me kangao amirĩt kadjy. Ba ar amã arẽ gar ama. Amrẽbê: krĩraxbê Xôtômamẽ Gomorakam me axwekumrẽx. Dja ĩ Metĩndjwỳnh kute memã axwe pãnh jarẽnh kadjy akati bôx. Nhym be, ajbir me krĩ jakam dja me axwe pãnho amrẽbê me tũm wã jakre. Me kute ar abê aminêkam dja me axwe pãnho me tũmwã jakre. Nãm ã arkum karõo ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nhym kam ar amũ mõn kàj bê me akreo ban memã kum, —On me amikam akaprĩren wãnh ajaxwemã anhiren Metĩndjwỳnh'ỳr amijo akẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ne arỳm me karõ punu krãptĩ kute ar meo ba jano nhym arỳm memã iren mã mõ. Nhym ar me kanê krãptĩ kungrà. Mỳjja kangô kute rõny kangô pyràko me kungràn meo mexo ba. ");
INSERT INTO txuNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nhym kam me amũ Jeju jarẽnho ipôk. Nhym kam mebê idjaer nhõ bẽnjadjwỳr rax nhidjibê ne Erodji. Arỳm ne me kute Jeju jarẽnhja ma. Ne kam arĩk Jejuo Djuão ne memã kum, —Ngômã me angjênh djwỳnhbê Djuão arỳm akubyn tĩn ne ar ba. Be, tyk ne akubyn tĩnkam ne mã mỳjja pumũnh kêt nhipêxo ba, mã me punuo mexo ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nhym me ja arĩk Jeju'ã memã kum, —Be, kubê Metĩndjwỳnh kukwakam ujarẽnh djwỳnhbê Erij, ane. Nhym amũ me ja 'ã memã kum, —Be, kubê ne Metĩndjwỳnh kukwakam ujarẽnh djwỳnh'õ. Nàr, kute amrẽbê: Metĩndjwỳnh kukwakam ujarẽnh djwỳnh'õ pyràk, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nhym bẽnjadjwỳr rax Erodji kute Jeju jarẽnh markam 'ã memã kum, —Be, Djuão ne wã. Ba ije kadjy me anor nhym me kute mut krã'yr, arỳm akubyn tĩn ne ar ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Be, me kute Djuão bĩn kêtri ne Erodji kamyre. Idjibê ne Piripi. Piripi prõ nhidjibê ne Erodjij. Nhym kam Erodji arỳm kamyrebê prõ pytàn ar o ba. Nhym kam Djuão nêje kum kabẽn ne kum, —Metĩndjwỳnh kukràdjà kupa'ã ne ga akamyrebê prõ pytà, ane. Nhym Erodjij kuman arỳm Erodjimã apnê. Djuão'ã kum apnê nhym arỳm 'ỳr me krãkamngônh jano. Nhym me arỳm o tỹm ne kubê ijê. ");
INSERT INTO txuNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nhym kam Erodjij ari kum Djuão kurêo ban te kute bĩnmã 'ã amijakreo ba. ");
INSERT INTO txuNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Erodji kum Djuão pymakam Erodjij te 'ã amijakreo ba. Erodji mã 'ã amim, —Djuão ne katàt ar amijo ban Metĩndjwỳnh mexo mex, ane. Nãm mã amim anen ar Erodjijbê utàr mexo ba. Djuão kute Erodjimã Metĩndjwỳnh jarẽnho ỹr kunĩkôt Erodji ari amim, —Je tô mỳj dja ba amijon? anen te kute kabẽn mar ne kôt kute amijo anhỹr prãmje. Nhym be, kum Djuão kabẽn mar prãmã. ");
INSERT INTO txuNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erodjij kum Djuão kurêo ba nhym kam arỳm mrãmri kute bĩn kadjy õ akati bôx. Erodji rwỳk djàkam õ akati arỳm bôx. Nhym õ akatikam arỳm bu'ã bẽnjadjwỳrreja ro'ã àkuro nhỹ. Apỹnh õ me rũnh djàri, õ krãkamngônh nhõ bẽnjadjwỳr djàri, õ pykabê Garrêjakam me õ nêkrêx rũnh djàri, me kunĩ õ akati kadjy Erodji'ã akuprõ. ");
INSERT INTO txuNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ne õ kwỳ krẽno nhỹ nhym Erodjij kra kurerer arỳm me'ỳr wadjà. Ne kam memã to nhym me arỳm kum kĩnh. Erodjimẽ me ro'ã ỹrja kum kĩnhĩ. Nhym kam Erodji kurerermã kum, —Mỳj ne ga amã kĩnh? Dja ga amã mỳjja'õ kĩnh ne imã arẽ ba arỳm amã kungã, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nãm kum kabẽn jarẽnh mãmdjin kum, —Be, amã ikabẽn kajgo kêtkumrẽx nhym Metĩndjwỳnh arỳm ima. Dja ga amã mỳjja'õ kĩnh ne imã arẽ ba arỳm amã õrkumrẽx. Nàr godja amã inhõ pyka kuto katẽ kĩnh jabej ba arỳm amã kungã. Mrãmri ne ba tu amã ikabẽn jarẽnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nhym kam arỳm katon nã kukij ne kum, “Ô mỳj dja ba kum arẽ”? ane. Nhym kum, —Xô, ngômã me angjênh djwỳnhbê Djuão krã'ã dja ga 'wỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nhym amibêx ne ajte bẽnjadjwỳr rax'ỳr wadjàn kum, —Ô kum amikrà kêt ne ngômã me angjênh djwỳnhbê Djuão krã dja ga imã angã. Ngônh purortikam adjàn o bôx ne imã angã, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nhym kam bẽnjadjwỳr rax arỳm kaprĩren õkre kadjwỳnhbê amim, —Je, arỳm ne ba mrãmri kum ikabẽn jarẽnh mãmdji nhym Metĩndjwỳnh arỳm ima. Jakam ba te ije kum, “Kati”, anhỹr prãmje. Inhõ me rũnh mrãmri ikabẽnkumrẽx jabej ikam no tyn kumex, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ne kam on me par djwỳnhmã kabẽn ne kum, —Amrẽ Djuão krão aprõt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nhym arỳm mebê ijê djà'ỳr tẽn wadjàn arỳm Djuão mut krãtan kam arỳm ngônh purortikam krã djà. Ne kam kurerermã o tẽn o bôx ne arỳm kum kungã. Nhym arỳm nãmã kungã. ");
INSERT INTO txuNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nhym kam Djuãokôt ba djwỳnh ar arẽnh man arỳm 'ỳr tẽ. 'Ỳr tẽn 'ỳr bôx ne kam arỳm Djuão nhĩ mỳn o tẽn arỳm kẽnkrekam adjà. Be, me kute Djuão bĩn'ã ujarẽnh ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ne kam Jeju kute ar anorja ne arỳm apỹnh krĩkôt tẽ:n kam arỳm akubyn Jeju'ỳr tẽn 'ỳr bôx ne 'ã akuprõ. Ne kam kum amijã ajarẽ. Kute mỳjja nhipêx kunĩ'ã kum ajarẽ. Kute memã kukràdjà jarẽnh kunĩja kum 'ã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nhym me krãptĩ: Jeju ar'ã aben japanho dja. Ar 'ã aben japanho dja nhym ar te õ kwỳ krẽn kadjy amijo ane. Nhym kam Jeju arkum, —Gwaj on arwãmã mebê tẽn kam bôx ne bakôkam kôto nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nhym kam ar ate arwãkam ỹr kadjy kàkam nhỹn arỳm nox ne. ");
INSERT INTO txuNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nhym me krãptĩ ar mõrkôt amim nokre pumũn arỳm ar ibej prõt ne. Krĩ kunĩ kurũm ne me pykakôt ar ibej prõt ne. Ibej prõt ne arỳm akàx nhikjêbê ar kukãm akuprõ. ");
INSERT INTO txuNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nhym kam ar kà dji nhym Jeju wabi. Wabin arỳm me krãptĩ me:xja pumũ. Ne kam amim, —E kum, nãm me kute mryo ba djwỳnh kêtkam mrykĩ'ãtomti krãptĩ ta kajgo ba pyràk, ane. Kam ne arỳm kum me kaprĩn arỳm memã kukràdjà krãptĩ jarẽnhmo krax ne. ");
INSERT INTO txuNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nãm memã arẽnho dja: nhym kam arỳm 'ã myt ibô. Nhym kam kôt ba djwỳnh ar arỳm 'ỳr bôx ne kum, —Arwã jakam mỳjja kêt nhym arỳm amykry mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Me ano gê me amũ apỹnh kikremã mõn amũ apỹnh krĩmã mõ. Dja me amim õ kwỳ krẽn djà jamỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nhym arkum, —Ar ga dja gar memã mỳjja ngã gê me kukrẽ, ane. Nhym ar kum, —Djãm gwaj baje pi'ôk kaprĩ kumexjao djwỳ jamỳnhmã? Denarju kubê 200jao djwỳ jamỳnhmã? Djãm gwaj baje memã õr nhym me kute krẽnmã? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nhym arkum, —Mỳj ne ar anhõ djwỳ kute? Tẽn omũ, ane. Nhym ar arỳm bu'ã me ku'ê kôt tẽn omũ. Ne akubyn 'ỳr bôx ne kum, —Ẽ, djwỳ amãnhkrut ne amãnhkrut ne ikjêkêt. Ne tepdjwỳ amãnhkrut, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nhym kam arkum, —Ar memã arẽ gê me apỹnh bõre ngrãngrãkam krĩ mõ, ane. Nhym ar arỳm apỹnh me krĩ kadjy memã karõ. ");
INSERT INTO txuNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nhym me apỹnh me krĩ kadjy me'ã akre. Nhym me kwỳ kubê 100'ã kabẽn ne krĩ mõ. Nhym me kwỳ kubê 50'ã kabẽn ne krĩ mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nhym djwỳ amãnhkrut ne amãnhkrut ne ikjêkêt jamỳ. Ne tep amãnhkrutja by. Ne kàjmã o kàjkwa jabẽn Metĩndjwỳnhmã o amikĩnh jarẽ. Ne kam djwỳ kokij ne kôt ba djwỳnhmã kungã nhym ar memã õro mõ. Ne kôt tepdjwỳ ã o anen arỳm me kunĩmã kungã. ");
INSERT INTO txuNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nhym kam me kunĩ õ kwỳ krẽn arỳm ajne. ");
INSERT INTO txuNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nhym kam me arỳm tepmẽ djwỳ janhy ngij ne 'ã akre. Nhym arỳm 'ã akrekam kaxnokai ipubê 12 ne 'ã kàtàm. ");
INSERT INTO txuNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Be, me my kute djwỳ krẽn'ã akrekam kubê 5.000. Ne ijukri me niremẽ me prĩre'ã akre kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nhym kam Jeju urokam kôt ba djwỳnhmã kum, —Aje, on ar mõn kàkam nhỹn ikukãm akàx nhikjêmã rên krĩbê Bexadamã tẽ. Ba me ano gê me on mã mõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ne kam me krãptĩ'ỳr tẽn memã kum, —Aje, on me ajmà. Ba on, ane. Ne kam arỳm Metĩndjwỳnhmã kabẽn kadjy krãnh'ã tẽn wabi. ");
INSERT INTO txuNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nhym kam ar'ã akamàt nhym ar arỳm kàkam ngô nhipôkri mõ nhym Jeju ate atỳxã dja. ");
INSERT INTO txuNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nhym kam ar kutã arỳm kôk djàbêr tỳx. Àbêr tỳx nhym ar kute kutã ngô rẽnh kurêje àpênh raxo nhỹ. Àpênh ra:x nhym arỳm ar omũ. Ne õkrẽn'ãnh kàr pydjikam arỳm arkôt tẽ. Ngô'ã arkôt tẽ. Tẽn kam bit ar'ãnh tẽmmã. ");
INSERT INTO txuNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nhym ar arỳm ngô'ã tẽmkôt omũn abenmã kum, —Ota, amrẽ me karõ'õ mõ. Ar anen amra. ");
INSERT INTO txuNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ar kunĩ omũn arỳm madjà kreti. Nhym adjynkêt nhym arỳm arkum, —E kum, ba ne ba wãm tẽ. On ar akĩnh ne atĩn prãm kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ne arỳm arkôt kàkam nhỹ. Kàkam nhỹ nhym arỳm kôk djàbêr anhikrê. Nhym ar õkre kadjwỳnhbê amikabẽn kudjan te kute mỳjja marmã kam no tyn nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Be, amũja'ã ne Jeju te me krãptĩ:mã djwỳ ngã nhym ar kute kum kator kêt. Kubê Metĩndjwỳnh Krajamã kator kêt. Nhym kam ar te kute marmã kam no tyn nhỹ. Ar amakkre kêtkam. ");
INSERT INTO txuNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ne kàkam ngô'ã mõn kam ar arỳm pykabê Djenekam akàx nhikjêmã bôx ne kà dji. ");
INSERT INTO txuNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nhym kam ar wabi nhym me arỳm amim Jeju nokre pumũ. ");
INSERT INTO txuNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ne kam me bu'ã pykawã kunĩkôt prõt ne arẽ. Nhym me arỳm kute memã Jeju bôx djà jarẽnhja'ỳr meo bôxmo krax ne. Me punu nhikwã djàkam ikwã rã'ãja ne me Jeju'ỳr meo prõt ne meo bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ne kam mã kikre kabem me punu jadjuw. Krĩ kryrekam nàr krĩraxkam nàr arwãkam Jeju ku'ê djà kunĩkôt mã kikre kabem me punu jadjuw. Nhym me mã Jeju tẽmkôt kum amijo a'uw ne kum, —Ba gop akà japkrebit kupê. Ba gop akà japkrebit kupênh, ane. Ne me kute kupênh kunĩkôt arỳm mex ne. ");
INSERT INTO txuNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ne kam mebê pardjêumẽ Môjdjê kukràdjà mar djwỳnh kwỳ krĩraxbê Djeruxarẽ kurũm mõn Jeju'ã akuprõ. ");
INSERT INTO txuNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nhym Jejukôt ba djwỳnh kwỳ tu ikra põnh kêtkam õ kwỳ krẽ nhym me arỳm ar omũ. Ne ar'ã kabẽn ne Jejumã kum, —Mỳkam ne akôt ba djwỳnh me bakukãmãkjê kukràdjà kupa'ã ikra punu rã'ã tu àkur ba? Dja me o ane nhym Metĩndjwỳnh arỳm memã axwe jarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Bir, mebê pardjêumẽ mebê idjaer kunĩ ne me mã me kukãmãkjê kukràdjà'ã no tỳx ne kam arĩk abenmã kum, —Me kute prĩne aminhikra põnhkambit dja me aku. Kambit dja Metĩndjwỳnh memã axwe kêt jarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ne me me õ djwỳ jamỳnh djà kurũm ban bôx. Ne kam kute ngôo amiku'õnhkambit aku. Be, apỹnh me kukãmãkjê kukràdjà kajgo kute ja pyràk ne krãptĩ. Nhym me 'ã no tỳx ne mã apỹnh mỳjja ku'õ. Ngônhkrãmẽ ngyo ngônhmẽ ngônh tykmẽ ne me mã ku'õn arĩk amim, —Dja ba o ane nhym Metĩndjwỳnh imã imex jarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kamã ne mebê pardjêumẽ Môjdjê kukràdjà mar djwỳnhmẽ Jejumã kum, —Mỳkam ne akôt ba djwỳnh me bakukãmãkjê kukràdjà kupa'ã ikra punu rã'ã àkur ba? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nhym memã kum, —Me ga ne ga me amijo ajêx ne ar amijo Metĩndjwỳnh mar mexo aba. Mrãmri ne Idjaij Metĩndjwỳnh kukwakam me ajã pi'ôk no'ôkkumrẽx. Nãm me bakukãmãremã kum, “Metĩndjwỳnh ne me amã, ‘Be, me ja ne me arĩk 'êx ne ajkwa kajgokam imã imex jarẽnho ban jãm ate ibê krãn ban ");
INSERT INTO txuNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","imã irax jarẽnh kajgoo ban kam ta kukràdjào ikukràdjàn memã arẽnho ba. Ne kam ta kukràdjà'ã memã kum, Metĩndjwỳnh kukràdjà, anhỹro ba.’ Nãm ã Metĩndjwỳnh me amã ane.” Nãm ã Idjaij me ajã ane. Ga me akamingrãnyre arỳm akabẽn kajgoo Metĩndjwỳnh kukràdjàn memã arẽnho aba. Mrãmri ne me ajã arẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Be, Metĩndjwỳnh ne me kute katàt amijo ba'ã memã karõ ga me kam kubê amijo akẽxo aba. Ne kam mã me akukãmãkjê kukràdjà'ã ano tỳx ne ar o aba. Ne kam ngyo ngônhmẽ ngônhkrã ku'õ. Apỹnh me akukràdjà kajgo kute ja pyràk krãptĩ ga me 'ã ano tỳx ne ar o aba. Ne kam arĩk 'ã abenmã kum, “Dja Metĩndjwỳnh kôt imã ijaxwe kêt jarẽ.” ");
INSERT INTO txuNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nãm ã Jeju memã ane. Ne kam ajte memã kum, —Be, Metĩndjwỳnh kute katàt amijo aba'ã me amã karõ ga me arỳm kabẽn ma. Djãm mrãmri Metĩndjwỳnh kukràdjà kôt ne ga me akukãmãkjê kukràdjà jarẽ? Kati. Atemã. Atemã ne ga me akukãmãkjê kukràdjà ja'ã ano tỳx ne Metĩndjwỳnh kukràdjà mar kêt ne arỳm o abikẽnho aba. Djãm kam me ano mex got? ");
INSERT INTO txuNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ba me amã arẽ ga me ama. Môjdjê ne Metĩndjwỳnh kukwakam me bakukãmãremã karõn memã kukràdjà jarẽn memã kum, “Me amã abãmmẽ anã jabên ar kabẽn ma”, ane. Ne ajte memã kum, “Me'õ arỳm bãm'ã nàr nã'ã, ‘Gê Metĩndjwỳnh o ajkẽ’, anhỹr jabej gê me tu kubĩ”, ane. Me kum bãmmẽ nã ar abêmã ne Metĩndjwỳnh ã me bakukãmãremã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nhym be, djãm me ga ne ga me amã abãmmẽ anã jabê? Kati. Ga me akukràdjà kôt arĩk memã kum, “Me ajõ godja anã nàr abãm mỳjja'ã ajwỳr ga aje kubê anhõ mỳjja nê prãm jabej. Ne kum, ‘Be, ba te ije amã õrmã. Aje mỳjja 'ã ijwỳr ba arỳm o Metĩndjwỳnh nhõ mỳjja. Kam ba te ije amã õrmã’, ane. Dja ga me ã kum anen arỳm kubê nê nhym kam arỳm pijàm ne akubyn 'ã ajwỳr kêt”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ga me aje ã memã 'ã karõo anhỹrkam arỳm me nãmẽ bãmbê õdjỳ'ã memã adjàpnênh aba. ");
INSERT INTO txuNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Me kum ar abê kêt'ã memã adjàpnênho aba. Metĩndjwỳnh te memã kum, “Me amã abãmmẽ anã jabên ar kabẽn ma”, ane ga me arỳm Metĩndjwỳnh kabẽno me kukràdjà kajgon akukràdjào arỳm nãmẽ bãmbê õdjỳ'ã memã adjàpnênho aba. Aje Metĩndjwỳnh kukràdjào me kukràdjà kajgo ne ajte kupa'ã memã akukràdjà punu ja jarẽ. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ne kam ajte amiwỳr me kunĩ 'uw ne memã kum, —Ẽ, dja ga me akunĩ imaro nhỹn ikabẽn markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Me kute apỹnh mỳjja'ã memã kum, “Ja dja ga ãm omũ. Dja ga krẽn arỳm ajaxwe”, anhỹro ba. Nhym be, Metĩndjwỳnh, djã ne me mỳjja 'õ krẽ nhym arỳm kum, “Ja ne ga krẽn arỳm ajaxwe”, ane? Kati. Me kabẽn punukam ne memã axwe jarẽ. Me àkĩnhĩkam ne memã arẽ. Me ari prõ, mjên kupa'ã kurẽ bakam ne memã arẽ. Me 'êxnhĩkam ne memã arẽ. Axwe'õkambit ne Metĩndjwỳnh memã axwe jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Gop me ajamak mex jabej tu amim ikabẽn markumrẽx. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ne kam arỳm mebê kikremã wadjà. Nhym kôt ba djwỳnh arỳm kukij ne kum, —Nã gãm ar imã, “Djã ne me mỳjja 'õ krẽ nhym Metĩndjwỳnh kum, ‘Ja ne ga krẽn arỳm ajaxwe’, ane? Kati”, ane. Tãm ne ga arẽ nhym ar ibê bipdjur rã'ã ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nhym kam arkum, —Je tô djãm ar gadjwỳ ajamakkre kêt? Be, mrãmri ne me kute mỳjja'õ krẽnkôt Metĩndjwỳnh memã axwe jarẽnh kêt. Djãm ar aje ja mar kêt? ");
INSERT INTO txuNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Be, aparmã ne mỳjja mrãn me tikkremãbit wangij. Mỳjja'õ kurja ne me kute amim mỳjja'ã karõ djàkam ngjêx kêtkumrẽx. Me tikkremãbit ne wangij ne kam atykmã arỳm apôx. Me kute amim mỳjja'ã karõ djàmã ngjêx kêtkam Metĩndjwỳnh kute kôt memã axwe jarẽnh prãm kêt, ane. Jeju kute ã arkum anhỹro arỳm me õ mỳjja krẽnja kunĩ mex jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ne kam ajte arkum, —Me kurũm me kabẽn punu apôx ne me àpênh punukam ne Metĩndjwỳnh memã axwe jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Me kadjwỳnhbê, me amim mỳjja'ã karõ djàkam ne me amim axwe'ã karõ nhym arỳm me kurũm apôx. Me kute amim axwe'ã karõkam ne me kute me prõ puro nàr me mjên puroo àkĩnh ne ro'ã ikwãja'ã amim karõ. Ne prõ djwỳnh nàr mjên djwỳnh kupa'ã kurẽ'ã amim karõ. Ne kute me par'ã amim karõ. ");
INSERT INTO txuNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ne kute mebê mỳjjao àkĩnh'ã amim karõ. Ne kute mỳjjao atom rũnh'ã amim karõ. Ne kute meo bikẽnh'ã amim karõ. Ne memã 'êx ne kute me noo biknor'ã amim karõ. Ne kurẽ ba'ã amim karõ. Ne te ta kute me uràk prãmje ngryk. Ne me'ã kabẽn punu'ã amim karõ. Ne amijo àmrati. Ne bẽn kati. Me kute amim axwe'ã karõ ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Me axweja kunĩ ne me kurũm apôx. Nhym kam kôt Metĩndjwỳnh memã axwe jarẽ. Nãm ã Jeju kôt ba djwỳnh arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ne kam arỳm mebê tẽ. Tẽ:n kam krĩraxbê Xirumẽ krĩraxbê Xidõ kuri pykaja'ỳr bôx. Ne kam arỳm kikre'õmã wadjàn nhỹ. Ne bit kute me'õmã amijo amirĩt kêtmã. Ne kam te kute mebê amijo bipdjurmã. ");
INSERT INTO txuNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nhym me'õ nire arỳm arẽnh ma. Kubê ne me bajtembê kregu'õ. Pykabê Xirij Penixijkam ne rwỳk djà. Me karõ punu ne kra prĩtio ba. Nãm arẽnh man arỳm 'ỳr tẽn parbê ibôn nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ne arỳm Jejumã krao a'uw ne kum, —Amrẽ tẽn me karõ punu kute ikra prĩtio baja jano gê kum ire, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Bir, Jeju ne jakam me bajtemo mex prãm kêt. Nãm kute õ mebê idjaerbit kumrẽx o mexo bamã. 'Ã kute kum ujarẽnh nhym kôt kute marmã ne õ mebê idjaer'ã me prĩre jakren kum, —Gê me prĩre kumrẽx djwỳo amitỳxmã. Nok ba ren me prĩre nhõ djwỳ rop kraremã kurẽ nhym ren kam punure, ane. Djãm mrãmri ne djwỳ'ã ajarẽ? Kati. Kute meo mex'ã ne djwỳ jakren kum 'ã ajarẽ. Nãm, —Nok ba ren me prĩre nhõ djwỳ rop kraremã kurẽ nhym ren kam arỳm punure, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nhym nija arỳm amim, —Ijã ne rop krare jarẽ, anen arỳm kum, —Tukwa, mrãmri Bẽnjadjwỳr djwỳnh. Kôt ne ga arẽ. Nhym be, godja wãnh pĩponh krakri djwỳ jaũm rôrôk. Aũmbit dja rop krare arỳm kukrẽ. Kam gop badjwỳ ibê rop krare pyràk tu imã ikrao mex, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nhym kôt kum, —Be, aje imã akabẽn wã jarẽnhkam adjumar mex ne tẽ. Arỳm ne me karõ punu akramã ire, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nhym kam arỳm ũrkwãmã akẽx ne 'ỳr bôx. Nhym wỳnhràm me arỳm me ikwã djàkam kra prĩti dji nhym nõ. Me karõ punu arỳm kum ire nhym arek nõ nhym arỳm omũ. ");
INSERT INTO txuNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nhym kam krĩraxbê Xirumẽ Xidõkuri pykaja kurũm tẽ. Tẽ:n kam amũ pyka nhidjibê Krĩraxbê 10jakôt tẽ. Ne tẽ:n kam arỳm imôtibê Garrêja'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nhym wãnh me'õ jamakkre kêt ne kabẽn tôja. Nhym me arỳm 'ỳr o bôx ne kum, “Gop 'ã anhikra dji”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nhym ate kute o ãm kadjy amũ me krãptĩ bê o tẽ. Ne kam aktã amakkremã aminhikra'i jadjàn aptôn õtodjwỳ kupê. ");
INSERT INTO txuNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ne kàjkwa jabẽn kum kaprĩkam arỳm amityk djà mẽ. Ne kum, “Epata”, ane. Nãm ren me bakabẽnkam kum, “On ajamakkre kajrer”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nãm kum ane nhym arỳm amakkre kajrer ne kabẽn mex ne. Nhym kam akubyn me'ỳr o bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ne memã 'ã karõn memã kum, “Gora ipudju”, ane. Be, nãm te mã: memã anhỹro ba nhym me ate mã: pyka kunĩkôt abenmã arẽnho ba. ");
INSERT INTO txuNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nãm me'õo mex nhym me te kute marmã kam no tyn ku'ê ne abenmã kum, —Nãm apỹnh me kanê djàri me kunĩo mexkumrẽx. Nãm me umar kêto mex nhym arỳm akubyn amak mex ne. Nãm me kabẽn kêtdjwỳo mex nhym arỳm akubyn kabẽn mex ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nhym kam me krãptĩ: ajte Jeju'ã akuprõn 'ã akuprõn me'ã õ kwỳ krẽn djà kêt. Nhym kam arỳm amiwỳr kôt ba djwỳnh ar ku'uw nhym ar bôx nhym arkum, ");
INSERT INTO txuNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Imã me krãptĩ:ja kaprĩ. Me iro'ã krĩ'ã arỳm akati amãnhkrut ne ikjêkêt apêx. Ne kam arỳm me õ mỳjja kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nok ba ren me kum prãmkam ren amũ me ũrkwãmã me ano nhym me ren pry konenh ren rerekre ne. Ren me rerekre nhym ren me tyk djà me kupa. Djãm jãnh got. Onĩj me ũrkwã. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nhym kôt ba djwỳnh ar kum, —Kapôt kukrit jakam ne gwaj te me krãptĩ:ja kadjy djwỳ kumex prãmje. Mỳj got gwaj me kadjy nẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nhym Jeju arkum, —Mỳj ne ar anhõ djwỳ kute? ane. Nhym ar kum, “Djwỳbê 7”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nhym kam me krãptĩmã kum, —Pykabê dja ga me nhỹ, ane. Nhym kam me arỳm nhỹ. Nhym kam arỳm djwỳbê 7 jamỳn o Metĩndjwỳnhmã amikĩnh jarẽ. Ne kam kokij ne mã kôt ba djwỳnh arkum kungã nhym ar mã me krãptĩmã adjuw. Nãm ar memã adjwỳro mõn kam arỳm adjwỳr pa. ");
INSERT INTO txuNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ne kam ar õ tepprãre ngrêre nhym o Metĩndjwỳnhmã amikĩnh jarẽ. Ne kam arkum, —Dja gar memã jadjwỳ jadjwỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nhym kam ar memã adjwỳro mõn adjwỳr pa. Nhym kam me arỳm kukrẽn arỳm ajne. Nhym kam me arỳm aũm ngij ne 'ã akre nhym kaxnokai ipubê 7 'ã kàtàm. ");
INSERT INTO txuNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Be, me my kubê 4.000 ne õ kwỳ krẽ. Nhym kam memã kum, “Aje, on me ajmà”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ne on kôt ba djwỳnhmẽ ro'ã kàmã wadjàn nhỹ. Nhym ar arỳm nox ne rê:n kam arỳm pykabê Tamanu'ãnh kà djin wabi. ");
INSERT INTO txuNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nhym mebê pardjêumẽ mebê xadjudjêumẽ Jeju'ỳr bôx ne kukij ne mrãmri kubê Metĩndjwỳnh Kra ne kute mỳjja pumũnh kêt'õ nhipêx jabej 'ã kum apnên kum, —Goja kàjkwa kurũm mỳjja pumũnh kêt'õ nhipêx bar omũn kôt ama, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nhym amikadjwỳnhbê tyk djà mẽn memã kum, —Je tô mỳkam ne ga me akamingrãnyre mỳjja'ã ijuw? Ije me amã mỳjja pumũnh kêt'õ nhipêx ga me aje omũnh prãm kêtkumrẽx. Mrãmri ne ba me amã ikabẽnkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ne kam arỳm mebê akẽx ne tẽn ajte kàmã wadjà. Wadjàn akàx nhikjêmã rêr kadjy arỳm nox ne. ");
INSERT INTO txuNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nhym kam djwỳ ar kumãnhkutã nhym kôt ba djwỳnh kute byrmãn arỳm o amak kêt kati. Nhym wãnh kàkam djwỳ pydjibit nõ. ");
INSERT INTO txuNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nhym kam Jeju me kute me kukràdjà kajgo mar kêt kadjy ne kôt kute ar amijo ba kêt kadjy arkum kabẽn ne arkum, —Ga, me kute djwỳ nhigot djà djwỳ djômkam kapĩnja pumũ. Nhym arỳm djwỳ tỳx me:x ne. Ar gadjwỳ dja gar me kukràdjà man kôt ar amijo aban arỳm ajaxwe me:x ne. Mebê pardjêu kukràdjà nàr Erodji kukràdjà dja gar aman kôt ar amijo aban arỳm ajaxwe me:x ne. Ar amijã ano tỳx ne me kukràdjà mar kêt ne kôt ar amijo aba kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nhym kam ar ari 'ã aben kukij. Ne kam arĩk abenmã kum, —Gwaj baje djwỳ byr kêtkam ne ã ar imã ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Be, Jeju kute me kukràdjà kajgo'ã djwỳ nhigot djà jakre nhym ar kute mar kêt. Nhym kam arỳm ar kabẽn man arkum, —Mỳkam ne gar abenmã, “Gwaj baje djwỳ byr kêtkam ne ã ar imã ane”, ane? Djãm kraxje ar aje omũnh kêt rã'ã? Djãm kraxje ar aje mỳjja mar kêt rã'ã? Mỳj'ã ikabẽn kute amijakre ar aje mar kêt rã'ã? Djãm ar ajamakkreja kêt? ");
INSERT INTO txuNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jãm ne gar anon omũnh kêt ne. Jãm ne gar ajamak ne mar kêt ne. Be, ije djwỳ ngrireo me krãptĩo djuw mexja djã ne gar arỳm o ajamak kêt kati? ");
INSERT INTO txuNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Akubyn amijo tẽn ije mebê 5.000mã djwỳ kubê 5 kokjêr'ỳr amijo bôx. Ar aje djwỳ janhyo atomkam mỳj ne kam kaxnokai ipu kute? ane. Nhym ar Jejumã kum, “Kaxnokai ipubê 12”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nhym ajte arkum, —Ajte akubyn amijo tẽn ije mebê 4.000 kadjy djwỳbê 7djwỳ kokjêr'ỳr amijo bôx. Ar aje kam djwỳ jaũmo atomkam mỳj ne kam kaxnokai ipu kute? ane. Nhym ar kum, “Kaxnokai ipu kubê 7”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nhym kam arkum, —Djãm djwỳ'ã ne ba ar amã arẽ? Djãm 'ã ne ba ar amã, “Ari amijã ano tỳx”, ane? Kati. Djwỳ'ã ne ba ije ar amã ja jarẽnh kêt. Mỳkam ne gar aje ja mar kêt rã'ã? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ne kam ar arỳm krĩraxbê Bexadamã tẽn bôx. Nhym kam me Jeju'ỳr me'õ no rão mõn o bôx ne kum, “Gop kupê gê mex”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nhym arỳm me'õ no rã nhikra 'amỳn krĩ kurũm o katon atykmã o tẽ. Ne kam no kutôn 'ã ikra djin kukij ne kum, —Djãm arỳm ga mỳjja'õ pumũ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nhym kàjmã krãn kum, —Arỳm ne me kute pĩ pyràk ne mrã ba omũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nhym ajte no'ã ikra djin kàjmã kum krã nhym arỳm no mex. No mex ne arỳm kute me kunĩ pumũnh mexkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nhym kum, —Aj mã. Dja ga katàt anhũrkwãmã tẽ. Kwãrĩk wãnh krĩmã atẽm kêt. Ne kwãrĩk wãnh krĩkam me'õmã ijarẽnh kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Be, bẽnjadjwỳr raxbê Piripi nhõ krĩraxbê Xedjare bu'ã ne apỹnh me õ krĩ djàri. 'Ỳr ne Jejumẽ kôt ba djwỳnhmẽ ar mõ. 'Ỳr mõ nhym Jeju arỳm arkum, —Ẽ, ar imã ijã me ujarẽnh jarẽ ba kuma, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nhym ar arỳm kum, —Nãm me kwỳ ajã, “Ngômã me angjênh djwỳnhbê Djuão”, ane. Nhym me kwỳ ajã, “Me bakukãmãre Erij. Metĩndjwỳnh kukwakam ujarẽnh djwỳnh raxbê Erij”, ane. Nhym me kwỳ ajã, “Me bakukãmãrekam Metĩndjwỳnh kukwakam ujarẽnh djwỳnh ar 'õ.” Nãm me ã abenmã ajã ane. Nãm ã ar Jejumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nhym ajte arkum, —Ne ar gadjwỳ mã ne gar imar on? Mỳj'ã ne gar ijakre? ane. Nhym Pedru kum, —Abê ne Kritu. Abê me inhõ Bẽnjadjwỳrbê kumkati, Metĩndjwỳnh tĩn ne ar bakumrẽxja Kra. Amrẽbê ne me bakukãmãremã ajarẽ. Aje me ipytàr ne aje ar me ijo abamã ajarẽ. Amrẽbê me imã ajarẽ ba me akam amako iba nhym arỳm Metĩndjwỳnh ajano ga arỳm bôx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nhym arkum, —Kwãrĩk wãnh me'õmã ja jarẽnh kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ne kam amijã arkum ajarẽn arkum, —Ba ije amijo inhĩ ne ar awỳr irwỳkja ije mrãmri itokry kumex mar kadjy ne Metĩndjwỳnh ijano ba tẽ. Dja me rũnh ikanga. Mebêngêtmẽ me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ dja me memã ikanga nhym me arỳm ibĩ. Nhym ijã akatin akatin akati ba akubyn itĩn ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nãm Jeju arkum ja jarẽnho amirĩtkumrẽx. Nhym Pedru arỳm Ar kubê o tẽn ar kàxã nêje kum bẽn tỳxmo krax. ");
INSERT INTO txuNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nhym kam arỳm kôt ba djwỳnh'ỳr akẽx ne ar omũn Pedrumã bẽn tỳx ne kum, —Arỳm akabẽn kute Xatanaj kabẽn pyràk. Amũ imã akre rax ne dja. Ga Metĩndjwỳnh kôt adjumar kêt. Me kàtàm kôt ari adjumar, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ne kam me krãptĩ:mẽ kôt ba djwỳnhmẽ amiwỳr me ku'uw. Nhym me arỳm 'ỳr bôx nhym memã kum, —Gêdja ga me ajõ mã ikôt abikamẽnh prãm jabej kwãrĩk wãnh amidjwỳnhbit mar kêt ne mã amim, “Djãm ba ije amijo kĩnhmã? Kati”, ane. Dja ba ityk kadjy inhõ pĩte'y mỳn itokry:. Dja ga ijã amijakren aje anhõ pĩte'y mỳnh mãn pràbê amã atokry pyma kêt ne amã ijabê rã'ã ne mã ikôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Me kute amidjwỳnhbit mar ne me kum tokry pyma. Me tãm gêdja me tyn kam ijukri me biknor tokry djàkam tẽ. Nhym be, me kum ijabêkumrẽx ne kute amidjwỳnhbit mar kêt nhym me kute me bĩn jabej me tãm gêdja me amiptàn ar tĩn ne ba rã'ã: rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nhym ren me'õ pykabê mỳjja mexja kunĩ, nêkrêx kunĩja ari o atom ne o ban kam ren ty, je mã dja kam nẽ? Kati, nãm ren ty nhym ren õ nêkrêxja ren wãnh kumex. ");
INSERT INTO txuNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nhym mỳj pãnh ne ne ren Metĩndjwỳnhmã arẽ nhym ren akubyn o tĩn nhym ren kum amijo pãnh ne? Arkati. Dja ga te kum pãnh jarẽ nhym akubyn ajo tĩn prãm kêtkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Be, me kamingrãny ja ne me axwe:kumrẽx ne ari mỳjjakôt ibê amijo akẽxo ba. Ga, me kwỳ kum prõ djwỳnh kĩnh kêt ne mebê prõo àkĩnho baja pumũ. Me jadjwỳ ne me kum ikĩnh kêt ne ate ibê jãm krã. Kam godja me'õ ikam pijàm ne ikukràdjàkam pijàm jabej ba badjwỳ gêdja ba amipãnh kam ipijàm. Ba ije amijo inhĩ ne me awỳr irwỳk dja ba Ibãm jadjênhmẽ umao ipyma:n ar awỳr bôx. Kadjy mrãnh djwỳnh pyma:mẽ ro'ã ar awỳr bôx. Ibê kumkatio bôx nhym tãmja ikam pijàmja ba badjwỳ arỳm amipãnh kam ipijàm ne. Nãm ã Jeju me krãptĩmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ne kam arkum, —Ba ar amã arẽ. Ibãm dja ijã bẽnjadjwỳr rax mẽ. Dja ba bôx ne ipymao me apytàn ar me ajo iba. Dja gar adjãmja akwỳ atĩnri iraxkôt ipumũ, me akadjy ibẽnjadjwỳr rax ne ipymakôt ipumũ. Mrãmri ne ba ikabẽnja, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nhym kam akati amãnhkrut ne amãnhkrut ne amãnhkrut ar'ã apêx nhym Jeju arỳm krãnh prêkti'ã wabi. Nãm Pedrumẽ Xijagumẽ Djuão ar aprôn aro wabin ate ar ro'ã me kàxã dja. Ne kam arỳm ar kuka kônh atemã aminhipêx. ");
INSERT INTO txuNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ne õ kubẽkà arỳm adjênh ne aka: kute kakũm arngrokam aka pyràk. Ren kubẽkà põnh djwỳnh'õ kubẽkà'õ põn ren kubẽkà jakao kute Jeju kà jaka têp kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nhym kam me kukãmãrebê Erijmẽ Môjdjê arỳm arkum amijo amirĩt ne. Nãm ar Jejumẽ abenmã kabẽno dja nhym ar ar omũ. ");
INSERT INTO txuNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nhym Pedru kum, —Be, ujarẽnh djwỳnh, jakam ne gwaj arỳm bakĩnhkumrẽx. Dja bar ar amã kikre'ã irõx nhipêx. Dja bar amã 'õ nhipêx, Môjdjêmã 'õ nhipêx, Erijmã 'õ nhipêx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ar madjà kretikam ne Pedru umaje Jejumã kabẽn kajgo jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nhym kam kakrã'õ arỳm amirĩt ne ar kuno. Ar kuno nhym Metĩndjwỳnh arỳm kakrã kurũm kabẽn nhym ar arỳm kuma. Nhym arkum, —Ikra ne wã. Imã abê:. Tãmwã dja gar kabẽn man kôt ar amijo aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nhym ar te ar abej amibu'ã rĩt. Nhym Jeju pydjibit dja nhym ar omũ. Arỳm ne Môjdjê ar ar aêrbê mã tẽn arỳm amirĩt kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nhym kam ar arỳm krãnh prêkti'ã rwỳk tẽ. Rwỳk tẽ nhym Jeju arỳm ar kute omũnh'ã arkum karõn arkum, —Ar aje omũnhja kwãrĩk wãnh jakam me'õmã 'ã adjujarẽnh kêt. Ba ije amijo inhĩ ne ibôxja ityk ne akubyn itĩnkambit dja ga memã 'ã ajarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nhym kam ar arỳm 'ã ujarẽnh kêt. Ne rwỳk tẽn kam aben kukij ne abenmã kum, —Jeju kute gwaj bamã, “Ityk ne akubyn itĩn”, anhỹrja. Mỳj'ã ne amijakre? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ne kam Jejumã kum, —Mỳkam ne Môjdjê kukràdjà mar djwỳnh memã kum, “Erij kumrẽx dja bôx. Nhym kam totokbê Metĩndjwỳnh bôx ne ar meo ba”? ane. Mỳkam ne me mã memã ja jarẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nhym Jeju arkum, —Be, gêdja me'õ kute Erij pyràk kumrẽx bôx ne akubyn Metĩndjwỳnh'ỳr me kunĩo akẽx ne. Meo akẽx nhym me arỳm amim maro ba. Mỳkam ne ba ije amijo inhĩ ne ibôxja badjwỳ amrẽbê: me ijã me bakukãmãremã kum, “Dja arỳm tokry kumex ma nhym me memã kanga”, ane? Nãm me ã ijã anen arỳm 'ã pi'ôk no'ôk ne. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ne kam ngômã me angjênh djwỳnhbê Djuão'ã arkum, —Ba ar amã arẽ gar ama. Mrãmri, me'õ kute Erij pyràk ne arỳm bôx. Nhym kam me arỳm mar kêt ne amikĩnhje o bikẽnho ba. Amrẽbê: me bakukãmãre kute Metĩndjwỳnh kabẽn'ã pi'ôk no'ôkkam me kute o anhỹrmã kôt ne me arỳm ã o ane, ane. Nãm krãnh'ã rwỳk tẽmkôt ne Jeju ã arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ar rwỳk tẽn kam arỳm kôt ba djwỳnh kwỳ aro rãm ne ja. Ar arkôt krãnh'ã àbir kêtjao rãm ne ja. Nhym me krãptĩ ar'ã akuprõ. Nhym Môjdjê kukràdjà mar djwỳnhmẽ ar aktã kabẽno aben japanho dja nhym Jeju arỳm me omũ. ");
INSERT INTO txuNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ne me aêrbê bôx nhym me kunĩ kam no tyn kumex ne 'ỳr prõt ne kum, —Djãm arỳm ne ga bôx? Djãm arỳm ne ga bôx? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nhym kam abej Môjdjê kukràdjà mar djwỳnh kukij ne memã kum, —Mỳkam ne ga me akabẽno aben japanho dja? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nhym kam me krãptĩkôt me'õ ãmja kum, —Ujarẽnh djwỳnh, awỳr ne ba bit ikrao itẽmmã. Me karõ punu ne o ba nhym ibê kabẽn kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nhym apỹnh kute par djàri pyka'ã kurẽ nhym ajmrô prõt ne àpjãnh ne àpnhirẽnho nõ. Awỳr ne ba bit o itẽmmã ga adjãm kêt. Ba kam tu akôt ba djwỳnh'ỳr o bôx ne arkum, —Dja gar ano gê kum ire, ane. Nhym ar te kute kujaêkmã o dja. Nãm ã me'õ Jejumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nhym kam Jeju me'ỳr akẽx ne memã kum, —Je, me akamingrãny aje amim ikamnhĩx kêtkumrẽx ne ajaxwe. Mỳj dja ijã akati, akamàt kô kute ba me akam arek ar iba? Nã bãm me awỳr bôx ga me ajamakkre kêtkumrẽx ne prĩne akabẽno ikaty. Nã bãm te amiwỳr me akam ama ga me arĩk ar aba, ane. Ne kam bãmjamã kabẽn ne kum, —Amrẽ akrao tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nhym me arỳm 'ỳr o bôx. 'Ỳr o bôx nhym me karõ arỳm Jeju pumũn ajte me'õ kraja bĩ. Kubĩ nhym arỳm pykabê tỹm ne àpnhirẽnho nõn ajmrô prõto nõ. ");
INSERT INTO txuNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nhym Jeju arỳm bãm kukij ne kum, —Mỳj ne kute bĩn kraxkam 'ã amex kute? ane. Nhym kum, —Prĩrekam ne kum o krax. ");
INSERT INTO txuNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nãm te: kute bĩn mexmã ar o ba. Nãm kute kuwymẽ ngôkam rẽnh krãptĩ. Aje me karõbê utàr mar jabej utà. Amã ar ikaprĩn utà, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nhym Jeju kum, —Be, Metĩndjwỳnh umaro kute mỳjja kunĩ jakrenh mexi. Me tu amim kamnhĩxkumrẽx nhym arỳm meo mex. Dja ga tu amim kamnhĩxkumrẽx nhym arỳm amã akrao mex, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nhym kam bãm no kangô prõtmẽ ro'ã on kàj bê kum, —Bẽnjadjwỳr djwỳnh, arỳm ba amim kamnhĩx. Gop ga imã 'itỳx jadjà ba gop tu amim kamnhĩxkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nhym me arỳm itepato prõt ne 'ã bikprõnho dja nhym Jeju arỳm me omũ. Ne arỳm me karõ punumã bẽn tỳx ne kum, —Me karõ, aje me'õ bôktimã kabẽn kêtmẽ amakkre kêt jadjàr. Ba ne ba amã ikabẽn ne. On kum anhiren kwãrĩk wãnh ajte o aba kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nhym arỳm amran bĩno bê mex ne arỳm kurũm kato. Nhym arỳm kute tyk pyràk ne nõ. Nhym me krãptĩ 'ã abenmã kum, —Arỳm ne akuno. Arỳm ne akuno, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nhym Jeju arỳm ikra 'amỳn kàjmã aro tẽ nhym arỳm kàjmã dja. ");
INSERT INTO txuNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nhym Jeju arỳm tẽn kikremã wadjà. Nhym me kàxã kôt ba djwỳnh ar arỳm me karõ jabej kukij ne kum, —Mỳkam ne bar te ije me karõ punu kujaêkmã o ane? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nhym arkum, —Bir, me karõ punu kute wã pyràk ne 'itỳ:xi. Dja me Metĩndjwỳnhmã amijo a'uw ne kum amijajbu. Kambit dja me me karõ wã jano nhym arỳm memã ire, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ne kam ar arỳm me kurũm tẽn amũ pykabê Garrêjakôt tẽ. Nãm mebê amijo bipdjuro tẽ. Jeju kute me kàxã kôt ba djwỳnh arkum amijã ujarẽnh prãm. Ne kam mebê amijo bipdjuro tẽ. Tẽ:n kam arỳm arkum, —Ba ije amijo inhĩ ne ibôxja dja me memã ikanga nhym me arỳm ibĩ. Nhym kam dja ityk'ã akati amãnhkrut ne ikjêkêt apêx. Ba kam akubyn itĩn, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nhym ar amim, —Je tô, mỳj'ã ne kabẽn ja jarẽ? ane. Ne kam ar kute kukjêr kêt. Jeju kute arkum kabẽn pymaje ar kute kukjêr kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ne kam mõ:n kam arỳm krĩraxbê Kapana'ỳr bôx ne kikremã wadjà. Nhym kam Jeju arkum, —Pry'ã ar amõrkôt ne gar aktã akabẽno aben japanho mõ. Mỳj'ã ne gar abenmã akabẽn ne? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nhym ar arỳm anhikrê ne. Be, prykôt ne ar amirax mỳr jabej abenmã kabẽn mõ. Kam ne Jeju 'ã ar kukij nhym ar arỳm pijàm ne anhikrê ne. ");
INSERT INTO txuNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nhym kam nhỹn amiwỳr ar ku'uw. Kôt ba djwỳnhbê 12ja 'uw ne arkum, —Gar ajõ araxo kutewa prãm jabej gêdja amijo kajgon me katẽ tẽn kam tu me kunĩmã àpênh ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ne kam arỳm me prĩre'õ nhikra 'amỳn o tẽn ar ipôkri kudja. Ne kam kute o kĩnh kadjy kumỳn arkum, ");
INSERT INTO txuNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ẽ, ga, me'õ prĩreja pumũ, kàtàm mexja pumũ. Dja me'õ ikukwakam kum me'õ kute prĩre ja pyràk kĩnh, kum me'õ kàtàmja kĩnh ne kam arỳm badjwỳ kum ikĩnh. Djãm bajbit kum ikĩnhmã? Kati, dja me'õ kum ikĩnh ne kam kum ibãmdjwỳ kĩnh, ibãm kute ijanorjadjwỳ kum kĩnh. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nhym Djuão arỳm kum, —Ujarẽnh djwỳnh, ba amã arẽ. Me'õ gwaj bakôt ba kêt'õ tu me karõ punu kute meo ba'ã anhidji jarẽ. 'Ã anhidji jarẽn me karõmã kum, “Ba Jeju kukwakam amã ikabẽn ne. On kum anhire.” Nãm ã anhỹro dja bar arỳm omũ. Ne kam gwaj bakôt ba kêtkam kum, “Kwãrĩk wãnh”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nhym Jeju arkum, —Kwãrĩk wãnh kubê adjàptàr kêt. Be, godja me ikukwakam mỳjja pumũnh kêt nhipêx, godja me'õ punuo mex, me ja ne me te kute ijã kabẽn punu jarẽnhmã. ");
INSERT INTO txuNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Be, me kum gwaj bakurê kêtja ne gwaj bajo õbikwa. Kam kwãrĩk wãnh kubê adjàptàr kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ba ne ba ibê Kritu. Gar ikôt abakam godja me'õ ar amã ngônhkrãkam ngô nhõr jabej. Ba dja ba mrãmri kum àpênh mexjao pãnhkumrẽx. Mrãmri ne ba ar amã arẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nhym be, me'õ kute me prĩre pyràk ne ajbir kute amim imar ny nhym kam ren ate me'õja axwe'ã kum apnê nhym ren arỳm kôt axwe nhym kam ren me õkre'ã kẽnpoti nhô. Kute memã axwe'ã àpnênh djwỳnhja nhõkre'ã kẽn jabatành nhô ne ren ngô jabatànhmã kumẽ nhym ren ngô kubĩ, ja ne kàjbê tokry. Tokry ngri. Nhym be kati, Metĩndjwỳnh dja prĩne o ajkẽ nhym tokry ra:x ne. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ga, me kute apỹnh amikukràdjào àpênh jaxwe prãmja pumũ. Me kute àpênh jaxwe kangamã ne Jeju mebê uman memã kum, —Ne gar ren ajaxwe kadjy anhikra nhikjêo mỳjja punu kupênh prãm mỳj ne gar ren on? Bir, gar ren on krãta. Ne kam ren te anhikra nhikjê kêt ne ren atĩnkam ren akĩnhkumrẽx. Metĩndjwỳnhkôt atĩn ne ar abakam ren akĩ:nhkumrẽx. Ne ren aktã anhikra rã'ãn ren me biknor tokry djàkam tẽn ren atokry ra:x ne. Kam ne kuwy pôk rã'ã: rã'ãn àtyk kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kam kôp kute me kakwỳrja tyk kêt nhym me kute kuwy pôkjadjwỳ par kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ne gar ren ajaxwe kadjy apar nhikjêo mỳjja punu'ỳr amrãnh prãm mỳj ne gar ren on? Bir, gar ren on krãta. Ne kam ren te apar nhikjê kêt ne ren atĩnkam ren akĩnhkumrẽx. Metĩndjwỳnhkôt atĩn ne ar abakam ren akĩ:nhkumrẽx. Ne ren aktã apar rã'ãn ren me biknor tokry djàkam tẽn ren atokry ra:x ne. Kam kuwy pôk rã'ã: rã'ãn àtyk kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kam kôp kute me kakwỳrja tyk kêt nhym me kute kuwy pôkjadjwỳ par kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ne gar ren ajaxwe kadjy ano nhikjêo aje mỳjja punu pumũnh tỳx prãm mỳj ne gar ren on? Bir, gar ren on kaba. Ne ren kam te ano nhikjê kêt ne ren akĩnhkumrẽx. Metĩndjwỳnh kute me utàr ne ar me kadjy bẽnjadjwỳr ne kute ar meo baja'ỳr abôxkam ren akĩ:nhkumrẽx. Ne ren aktã ano rã'ãn ren me biknor tokry djàkam kuwykam tẽn ren atokry ra:x ne. ");
INSERT INTO txuNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Me bakukãmãre ne amrẽbê: 'ã memã kum, “Kôp kute me kakwỳrja tyk kêt nhym me kute kuwy pôkjadjwỳ par kêt.” Nãm ã Jeju arkum ane. Djãm mrãmri ne ar kute aminhikra, amipar jakàrmã? Djãm mrãmri ne ar kute aminoo pôxmã? Kati, ar kute àpênh jaxwe krã'yr ne kangamã ne Jeju 'ã arkum ar kute amibê amikukràdjà jakàrmã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ne kam arkum, —Be, kuwykam gêdja me kunĩ tokry. Kute mrãmri ne me kute Metĩndjwỳnhmã mry parkam kadjwanhĩo mry kunĩ kangàr pyràk, ane. Dja me ã tokryo tuknĩo ane. ");
INSERT INTO txuNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ne kam ar'ã kadjwanhĩ jakre ne arkum, —Be, kadjwanhĩ mexkumrẽx. Godja kadjwanhĩ ta amikam akry apêx jabej arỳm o mỳjja jakry kadjy punukumrẽx ne. On ar aje kadjwanhĩ mex pyràk ne abenmã akabẽn mex, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ne kam arỳm krĩraxbê Kapanakam me jamã kàx. Ne tẽ:n arỳm ngôbê Djodão nhikjêmã rên arỳm pykabê Djudêja'ỳr bôx. Bôx nhym kam me krãptĩ: ajte 'ã bikprõnho dja. Nhym kam ajte memã ujarẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nhym mebê pardjêu arỳm 'ỳr bôx ne kute we kabẽn kajgo jabej kukjêrmã ne kum, —Djãm Metĩndjwỳnh kukràdjà kôt me kute tu prõ kangamã? Nãm me Jeju kute kabẽn kajgo jarẽnh kadjy nàràm ã kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nhym memã kum, —Be, Môjdjê ne amrẽbê: me bakukãmãremã 'ã karõ. Mỳj ne memã arẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nhym me kum, —Môjdjê ne memã kum, “Gê me prõ'ã pi'ôk no'ôk ne kam kanga”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nhym memã kum, —Bir, me amakkre kêtkam ne memã prõ kanga jarẽ. Nhym djãm adjàkamã ne me ã prõo ane? Kati. ");
INSERT INTO txuNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","7","Adjàkamã, kute mỳjja kunĩ nhipêxkam ne Metĩndjwỳnh mymẽ ni ar ipêx ne memã kum, “Kamã dja me my prõ kadjy arỳm bãmmẽ nã arkum iren kam arỳm prõbit'ã ngrà ne. ");
INSERT INTO txuNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nhym kam ar ĩ abenã tỹm ne kam kute ĩ typdji pyràk.” Nãm ã Metĩndjwỳnh memã ane. Kam, djãm ar ĩ amãnhkrut rã'ã? Kati, ar kute ĩ pydji pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Be ga, Metĩndjwỳnh kute abenã ar mẽnhja pumũ. Kwãrĩk wãnh me'õ abenbê aro bikjêr kêt. Nãm ã Jeju mebê pardjêumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nhym kam ar akubyn kikrekam tẽn nhỹ. Nhym kôt ba djwỳnh arỳm Jeju kute memã kabẽn jarẽnhja jabej kukij. ");
INSERT INTO txuNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nhym arỳm arkum, —Gêdja me'õ prõ djwỳnh kangan kam atemã akàxbê me'õmã kabẽn ne 'ỳr mõn kam arỳm mrãmri krô'ã o prõn arỳm axwekumrẽx, prõkam axwekumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nhym me niredjwỳ gêdja me mjên kanga nhym kam atemã me'õ akàxbê 'ỳr mõ nhym kam arỳm mrãmri krô'ã o mjên ne arỳm axwekumrẽx. Nãm ã arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nhym kam ar ja arỳm Jeju'ỳr me prĩreo mõn o bôx. Kute me kupênhmã ne ar 'ỳr meo mõ. Nhym kôt ba djwỳnh ar arỳm nêje memã bẽn tỳx. ");
INSERT INTO txuNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nhym Jeju arỳm ar omũn arỳm no kà nhàn arkum, —Kwãrĩk wãnh arek amrẽ me prĩre iwỳr mõ, ane. Kwãrĩk wãnh gar mebê adjàptàr kêt gê me arek amrẽ mõ. Ã me kute amijo anhỹrbit gêdja Metĩndjwỳnh me utàn me kadjy bẽnjadjwỳr ne ar meo ba. ");
INSERT INTO txuNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ẽ, me kute me prĩre pyràk ne amijo kàtàmjabit gêdja Metĩndjwỳnh me utàn me kadjy bẽnjadjwỳr ne ar meo ba. Be, me prĩre kute ta amim imarja pumũ. Ã me kute amijo anhỹr gêdja Metĩndjwỳnh me utàn me kadjy bẽnjadjwỳr ne ar meo ba. Mrãmri ne ba me amã katàt arẽ. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ne kam aben totokmã me prĩre jamỳn me'ã ikra jadjuw ne memã kum, —Gê Metĩndjwỳnh ajo djuw mex. Gê Metĩndjwỳnh ajo djuw mex, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ne kam arỳm memã kàx ne ajte prykôt tẽ. Tẽ: nhym me'õ arỳm 'ỳr prõt ne arỳm parbê kõnkrão nhỹn kum, —Ujarẽnh djwỳnh, ga ne ga amexkumrẽx. Itĩn rã'ã rã'ãmã mỳj gêdja ba Metĩndjwỳnh kadjy nẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nhym Jejubê Metĩndjwỳnh Kra nhym ta kute kôt kum kator kadjy Jeju kum, —Mỳkam ne ga imã imex jarẽ? Me'õ pykakam mex kêtkumrẽx. Metĩndjwỳnh pydjibit mex. ");
INSERT INTO txuNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Metĩndjwỳnh kukràdjà ne ga arỳm ama. Me kute katàt amijo ba'ã kute memã karõkôt kukràdjà ne ga arỳm ama. Nãm memã kum, “Kwãrĩk wãnh me par kêt. Kwãrĩk wãnh mebê prõo adjàkĩnh kêt. Kwãrĩk wãnh adjàkĩnhĩ kêt. Kwãrĩk wãnh ajêx ne me kàmex jarẽnh kêt. Kwãrĩk wãnh aje me'õ nhõ mỳjja o aminhõ kadjy kwãrĩk wãnh ajêxnhĩ kêt. Me amã abãmmẽ anã jabên ar kabẽn ma”, ane. Ja kunĩ ne ga arỳm ama. Nãm ã Jeju kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nhym kum, —Nà, ujarẽnh djwỳnh, arỳm ne ba ibôktikam ja kunĩ ma. Ne kam kôt ije ar amijo iba rã'ã:n arỳm ijabatành ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nhym Jeju arek omũnho djan kam kum kĩnhkumrẽx ne kum, —Be, mỳjja pydji ne kute akukrà rã'ã. On tẽn memã anhõ mỳjja wã ngràn pãnh pi'ôk kaprĩ byn me 'uwtĩ, me õ mỳjja kêtjamã angãn o me kĩnh. Ne kam amrẽ iwỳr tẽn mã ikôt ajkamẽ. Dja ga ã anen kam arỳm kàjkwakam anhõ mỳjja mex kumex. Ne kam ijã amijakren aje pĩte'y mỳnh mãn pràbê amã atokry pyma kêt ne amã ijabê rã'ã ne mã ikôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jeju ã kum ane nhym arỳm kam kaprĩ:re ne. Ne kam akẽx ne mã tẽ. Kaprĩ:re ne tẽ. Be, õ nêkrêx ne kume:x. 'Ã maje ne mã kaprĩren tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nhym kam Jeju kôt ba djwỳnh ar'ỳr akẽx ne arkum, —Nêkrêx ne kute me kukrà prãmã. Me õ nêkrêx kumex gêdja me te Metĩndjwỳnh kute amim me utàr ne ar meo baja'ỳr bôxmã, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nhym kôt ba djwỳnh te kute marmã kam no tyn ku'ê nhym Jeju arỳm arkum, —Akmere ar, me õ nêkrêx kanàrràm ar baja ne me te Metĩndjwỳnh kute amim me utàr ne ar meo baja'ỳr bôxmã. ");
INSERT INTO txuNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ba ar amã arẽ gar ama. Be ga, mry jabatànhbê kameru te: kute aguja tekrax kremã ngjêxmãja pumũ. Me õ nêkrêx rũnhdjwỳ kute uràk. Me te Metĩndjwỳnh kute amim me utàr ne ar meo baja'ỳr bôxmã nhym nêkrêx utà: ne. Nãm Jeju ã arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nhym kôt ba djwỳnh ja man kam no tyn djan kam kum, —Je, nhym mỳj me'õ gêdja Metĩndjwỳnh amim utà? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nhym Jeju arỳm ar omũnho djan arkum, —Be, me ne me te: kute amipytàr prãmje nhym be, Metĩndjwỳnh kute mỳjja kunĩ mar. Kumãbit ne amirĩt ne. Ta ne kute me utàrkôt kute mar, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nhym kam Pedru kum, —Ẽ, arỳm ne bar inhõ mỳjja kunĩmã inhiren mã akôt ajkamẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Nhym Jeju arkum, —Ẽ, godja me'õ imã àpênh ne memã ijã ujarẽnh tẽm kadjy arỳm õ mỳjjamã irer jabej, õbikwamã irer jabej. Õ kikre nàr kamy nàr kanikwỳnh nàr nã nàr bãm nàr prõ nàr kra nàr õ pykamã irer jabej ba dja ba kum o pãnh ra:x ne. Ne pãnh pyka jakam kum õ mỳjjao akrenh mex ne kum kungã. Ne pãnh õbikwao akrenh mex ne kum kungã. Dja ba kum krãptĩ: kubê 100 ngã nhym pãnh õ kikre, kamy, kanikwỳnh, nã, kra, õ pyka krãptĩ mex ne. Kamdjwỳ dja me kàtàm me'õ jao bikẽnho ba. Dja ã pykakam ane. Nhym ije pykao nykam gêdja Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. Mrãmri ne ba ar amã arẽnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nhym be, jakam me rũnho kutewaja djãm me kute memã wa rã'ãmã? Kati. Me ja krãptĩ gêdja me kajgo mex ne me katẽn tẽ. Nhym be, me kajgo mex ne me katẽn tẽmja gêdja me pãnh rũnho kutewa. Nãm ã Jeju kôt ba djwỳnh arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ne kam ar ajte Jejumẽ ro'ã prykôt mõ. Krĩraxbê Djeruxarẽ'ỳr àbir mõ nhym Jeju tu kum me uma kêt ne ar kukãm tẽ. Nhym ar te kute marmã kam no tyn mõn arỳm tĩn prãm. Nhym kam arỳm me kàxã aro tẽn arkum amijã ujarẽnh tẽ. Kôt ba djwỳnhbê 12jamã ne amijã ujarẽnh tẽn kum, ");
INSERT INTO txuNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Ẽ, ota gwaj arỳm Djeruxarẽ'ỳr badjàbirn babôxmã. Nhym kam ba ije amijo inhĩ dja me apỹnh me rũnhmã ikanga, me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr arkum ikangan Môjdjê kukràdjà mar djwỳnhmãdjwỳ ikanga. Nhym kam me ikà mex jarẽn ijã abenmã kum, “Axwekumrẽx. Gê me pãnh tu bĩnkumrẽx”, ane. Ne kam me bajtemmã ikanga. ");
INSERT INTO txuNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nhym me arỳm ijã bẽno ajkẽn ikutôn mry kà punuo ikaprêprê:k ne. Ne kam arỳm ibĩ nhym ijã akatin akatin akati ba akubyn itĩn ne. Nãm ã arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nhym kam Xijagumẽ Djuão ar arỳm 'ỳr bôx. Djebedêu kute ar irja 'ỳr bôx ne kum, —Ujarẽnh djwỳnh, bar amã arẽ ga prĩne kôt ã ar ijo ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nhym arkum, —Mỳj ne ba ije ar ajomã? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nhym ar kum, —Be, dja ga ĩ anhõ me ja kunĩo amiptàn prĩne amexkumrẽx ne apyma. Memã anhỹrkam bar irax ne anhikô'ã memã nhỹ, bar ijõ adjubôk'ãnh nhỹ nhym ar ijõ adjuge'ãnh nhỹ. Dja ga ã ar ijo ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nhym Jeju arkum, —Gêt kon. Nã gãm ar arĩk amim 'ã karõn imã arẽ. Ba ar amã arẽ gar ama. Dja ba ngônhkrã kam kangô jao ikõ. Djãm ar aje ipyràk ne kangô jao akõm mã? Dja me ngômã ijadjà. Djãm ar aje ipyràk nhym ngômã me kute ar ajadjàrmã? Nãm ã arkum ane. Bir, mỳj'ã ne kangô jao kõm ne ngômã adjàrmã akre? Bir, amitokry kume:x'ã ne akre. Ar kute uràk jabej ne ar kukij. Ar tokryo kute Jeju tokry pyràk jabej ne ar kukij. ");
INSERT INTO txuNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nhym ar kum, —Nà. Kadjy ar ije apyràk, ane. Nhym Jeju arkum, —Mrãmri dja gar aje ipyràk ne atokry kumex ma. Mrãmri dja gar kangô jao ikõ nhym me ngômã ar ajadjà. ");
INSERT INTO txuNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Be, djãm ba ne ba ar amã inhikô'ã ar anhỹrmã arẽ got? Be, Ibãm kute amrẽbê: amijo me'õ ar utàr ar ta dja ar inhikô'ã memã nhỹ. Nãm ã Xijagumẽ Djuão arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nhym kôt ba djwỳnhbê 10 arỳm ar kabẽn ma. Ne kam arỳm Xijagumẽ Djuão arkum àkrê ne. ");
INSERT INTO txuNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nhym Jeju amiwỳr ar ku'uw ne arkum, —Me bajtemkam me bẽnjadjwỳr ne me ari àpênh'ã memã àpnênh ne memã bẽn tỳx ba. Nãm ã me bajtemkam me rũnh kute meo bao ane gar arỳm ama. ");
INSERT INTO txuNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Djãm ar ga aje me kudjwamã? Kati. Ar ga dja gar ã anhỹr kêtkumrẽx ne. Ar ajõ abenkam arax prãm jabej amijo akajgon arkum adjàpênh ar aba. ");
INSERT INTO txuNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ne kam ar ajõ aben kadjy abẽnjadjwỳr rax prãm jabej tu amijo akàtàm ne me kunĩmã adjàpênh kajgo aba. ");
INSERT INTO txuNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ba ije amijo inhĩ djãm imã me àpênh kadjy ne ba amrẽ tẽ? Kati, ba dja ba memã apê. Me ren ta amijaxwe pãnh tokryn arỳm ty. Nhym be kati. Me krãptĩ jaxwe pãnh ba dja ba itokryn arỳm ty. Memã idjàpênh ja kadjy ne ba amrẽ tẽ. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nhym kam ar ajte tẽ:n kam krĩraxbê Djerikokam bôx. Bôx ne kam kato. Nhym kam Jejumẽ kôt ba djwỳnhmẽ me krãptĩmẽ ne me Djeriko kurũm kator mõ. Kator mõ nhym wãnh Baximêu no rãja pry japkre'ã nhỹ, amijo à'wỳro nhỹ. Ximêu ne kudji. ");
INSERT INTO txuNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nhym me abenmã kum, —Nadjarekam Jeju ne tẽmja, anhỹro kumex. Nhym arỳm kuman arỳm kum amijo akij ne kum, —Ẽ, Jeju, Dawi tàmdjwỳ 'õ. Gop amã ikaprĩ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nhym me krãptĩ arỳm kum bẽn tỳx ne kum, “E kum anhikrê”, ane. Nhym kam tu kum àkjêro bên kum, —Dawi tàmdjwỳ 'õ, gop amã ikaprĩ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nhym Jeju arek kum djan memã kum, —Me ajõ tẽn kum arẽ gê amrẽ iwỳr tẽ, ane. Nhym me 'ỳr tẽn kum arẽn kum, —On akĩnh ne on kàjmã dja. Onĩj amiwỳr ajuw, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nhym arỳm wãnh inôkàti mẽn ekrux ne kàjmã dja. Kàjmã djan arỳm Jeju'ỳr tẽ. 'Ỳr tẽn arỳm 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nhym Jeju kum, —Mỳj ne ba ije ajomã? ane. Nhym no rãja kum, —Bẽnjadjwỳr, aje inoo mex ba irĩtmã, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nhym Jeju kum, —Ga ne ga arĩt kadjy tu amim ikamnhĩxkumrẽx ne iwỳr bôx. Kam dja ba arỳm ajo mex. Aj mã, ane. Nhym kum kabẽnmẽ ro'ã arỳm rĩt mex ne arỳm Jejukôt pry'ã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nhym Jejumẽ ar prykôt mõ:n kam krĩraxbê Djeruxarẽ kuri krĩ ngrire ja'ỳr bôx. Krãnhrebê Oriwêre'ã rwỳkbê ne krĩ ngrire jabê Bepadjêmẽ Betanhamẽ. 'Ỳr bôx nhym kôt ba djwỳnh amãnhkrutmã kum, ");
INSERT INTO txuNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Pry ja'ã dja gar arek katàt krĩwãmã tẽ. Nhym ar akutã pry kator kraxkam dja gar mry'ã krĩ jabatành nyrewã pumũ. Nhym me kute pĩ maktã õkre djê nhym ãmwã. Kraxje me'õ mry wã'ã krĩ kêt. Dja gar 'ãpre bôn amrẽ o tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Godja me'õ 'ã ar amã kabẽn jabej ne ar amã, “Mỳj kadjy”? ane gar kum, “Bẽnjadjwỳr 'ã tẽm prãm. Dja 'ã tẽn kam akuby:n amã ano.” Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nhym kam ar 'ỳr tẽ. Tẽ:n kam arỳm mrymã kato. Kikre'õ jajkwa krekre tãri ne me mry 'ãpre nhym dja. Pry kênhkam ne mry dja nhym ar arỳm 'ãpre bô. ");
INSERT INTO txuNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nhym ar bu'ã me ku'êja ar kukij ne arkum, —Mỳj kadjy ne gar mry 'ãpre bô? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nhym Jeju kute arkum 'ã karõ kôt ne ar ã memã ane. Nhym me arỳm arkum, “Ajrã”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nhym ar arỳm Jeju'ỳr mryo tẽn o bôx. Ne kam ar aminhõ kubẽkào kum mry'ã aty. Nhym kam 'ã nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nhym kam me krãptĩdjwỳ kukãm kum pry'ã atyo mõ. Aminhõ kubẽkào kum atyo mõ. Nhym me kwỳ bu'ã kapôt'ỳr mõn pi'ô nhikẽn o bôx ne kukãm kum pry'ã o atyo mõ. Nhym arỳm 'ã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nhym me kwỳ kukãm mõ, o àkjêr mõ nhym me kwỳ kôt o àkjêr mõ. Nãm me o àkjêr mõn kàj bê abenmã kum, Metĩndjwỳnhmã kum, —Jejubê me inhõ Bẽnjadjwỳr rax. Ãm mexkumrẽx. Kam me ikĩ:nhkumrẽx. Gê on me ipytà. Gê Metĩndjwỳnh o kĩnh rax. Metĩndjwỳnh kukwakam ne arỳm me bakadjy bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Arỳm me bakukãmãre Dawi kudjwa kute me ijo ba kadjy ne bôx. Gê me kàjkwakamdjwỳ Metĩndjwỳnhmã mextire jarẽnho kumex. Gê on me ipytà, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nhym arỳm krĩraxbê Djeruxarẽkam bôx. Bôx ne kam Metĩndjwỳnh nhõ kikretimã wadjà. Ne kam amibu'ã mỳjja kunĩ pumũnho tẽ. Nhym kam arỳm 'ã amykry mex ne. Nhym kam kôt ba djwỳnhbê 12mẽ amũ krĩ ngrirebê Betanha'ỳr tẽ. 'Ỳr tẽ:n kam bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nhym ar'ã akati nhym arỳm Betanha kurũm tẽ. Ne kam kum prãm ne. ");
INSERT INTO txuNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nhym wãnh pidjôbê pigêre'õ dja nhym amybỳm 'ô pumũ. Ne kute ô jabej kadjy 'ỳr tẽn 'ỳr bôx. Ne te ô jabej nhym ô kêt ne 'ôbit nhym arỳm omũ. Kraxje ô'ã mytyrwỳ kator kêt rã'ãkam ne ô kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nãm omũn tu pidjômã kum, —Jakam dja ga adjô kêtkumrẽx nhym me adjô krẽn kêt ne, ane. Nhym kôt ba djwỳnh arỳm kuma. ");
INSERT INTO txuNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nhym kam ar tẽ:n kam krĩraxbê Djeruxarẽkam bôx. Kam bôx nhym kam Jeju Metĩndjwỳnh nhõ kikretimã tẽn wadjà. Nhym me kute memã mỳjja nhõr djwỳnh kumex. Nhym me kute memã mỳjjao pãnh ne amim byr kadjy 'ã kumex. Nhym arỳm bõm me rẽnho dja. Nhym me kute me õ pi'ôk kaprĩ pãnh memã kikreti nhõ pi'ôk kaprĩ nhõr kadjy me kumex nhym mebê pĩponho àpanho tẽ. Nhym me kute tut nhõr djwỳnhdjwỳ kumex nhym mebê krĩ djà nhikô rênho tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne mã mebê àptàro djan memã kum, —Kwãrĩk wãnh on Metĩndjwỳnh nhõ kikreti katikôt me ajênho aba kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ne kam memã kum, —Amrẽbê: ne me bakukãmãre Metĩndjwỳnh kabẽn'ã pi'ôk no'ôk ne. Kamã Metĩndjwỳnh ta memã kum, “Inhõ kikreti ja'ã dja me abenmã kum, ‘Apỹnh me õ pyka kunĩkôt me kute Metĩndjwỳnhmã kabẽn kadjy ne õ kikreti wã’, ane. Dja me ã inhõ kikreti'ã abenmã ane.” Nãm ã Metĩndjwỳnh pi'ôkkam ane. Nhym be, me ga ne ga me aje kam me àkĩnhĩo aben pydji djà. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nhym Môjdjê kukràdjà mar djwỳnhmẽ me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ arỳm Jeju kabẽn ma. Ne kam 'ã aben maro nhỹn abenmã kum, —Je tô mỳj dja gwaj baje Jeju bĩnmã on? ane. Me kum umakam ã abenmã ane. Me kàtàm kunĩ Jejukam no tyn kum kabẽn kĩnh ne kumex. Nhym kam me rũnhja kum uma. ");
INSERT INTO txuNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nhym kam Jeju ar'ã para nhym ar arỳm krĩrax kurũm katon tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nhym ar'ã akati nhym ar ajte pidjôbê pigêre 'ãnh tẽn omũ. Nhym arỳm arêmẽ kunĩ ngrà ne. ");
INSERT INTO txuNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nhym Pedru akubyn amijo tẽn Jeju kabẽn man kum, —Ujarẽnh djwỳnh ota, aje pidjôbê pigêre kangrônhja arỳm ngràn dja, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nhym kam arkum, —Gora ar tu amim Metĩndjwỳnh kamnhĩxkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ba ar amã arẽ gar ama. Gorẽn me'õ krãnhwãmã kum, “On amikaban ngô jabatành mũjakam mõn tỹm”, ane. Ne ren õkre kadjwỳnhbê amim, “Kon, birãm dja ipêx, kon”, anhỹr kêt ne tu kadjy amim kamnhĩxkumrẽx ne ren amim, “Be, mrãmri dja ikabẽn kôt ã imã o ane”, ane. Kute ren ã amim anhỹrkam ren krãnh mrãmri ã amijo ane. Mrãmri ne ba ar amã arẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kam aje mỳjja kunĩo Metĩndjwỳnhmã adjà'wỳrja dja gar tu kadjy amim kamnhĩxkumrẽx nhym arỳm ar akabẽn kôt ã ar amã o ane. ");
INSERT INTO txuNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ga kam ar aje Metĩndjwỳnhmã adjà'wỳro adjãmkam amimaro dja. Me'õkam angryk jabej amimaro dja. Godja gar me'õkam angryk jabej on kam angryk wãnh kum anhiren kam angryk kêt. Dja gar kam angryk kêt nhym kàjkwakam ar Abãmdjwỳ arỳm ar gadjwỳ ar ajaxwe maro aknon ar akam ngryk kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Be, godja gar me'õ, axwe'õ mar rã'ã jabej ne kam angryk rã'ã jabej nhym ar Abãmdjwỳ ar ajaxwe mar rã'ãn ar akam ngryk rã'ã ne. Nãm ã Jeju kôt ba djwỳnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nhym ar tẽ:n kam Djeruxarẽkam bôx. Nhym kam Jeju ajte Metĩndjwỳnh nhõ kikretikam bôx ne kam ar mrã. Nhym me rũnh arỳm 'ỳr bôx. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ mebêngêtmẽ ne me 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","'Ỳr bôx ne amũja'ã kute kikreti kurũm me anorja jabej kukij ne kum, —Mỳj me'õ kabẽnkôt ne ga ar ã meo anhỹro aba? Mỳj me'õ ne amã me'ã karõ ga kam amũ ô'ã bõm ar me rẽnho aba? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nhym Jeju memã kum, —Badjwỳ dja ba mỳjja jabej me akukja. Me akumrẽx dja ga me imã arẽ. Ba kam arỳm badjwỳ ije mỳj me'õ kabẽnkôt ar me anoro ibaja me amã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Djuão kute ngômã me angjênhja djãm me kabẽn kôt ne arĩk ar ngômã me angjênho ba? Nàr djãm Metĩndjwỳnh kabẽnkôt? Goja imã arẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nhym kam me abenkam kangan abenmã kum, —Je mỳj dja gwaj kum nẽ? Dja gwaj kum “Metĩndjwỳnh kabẽnkôt”, ane nhym kam gwaj bamã kabẽn 'õ jarẽn gwaj bamã, “Bir be, mỳkam ne ga me amim Djuão kabẽnja mar kêt ne”? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nàr dja gwaj kum, “Me kabẽn kôt ne tu arĩk ar ngômã me angjênho ba”, ane nhym kam me krãptĩ ren o ngryk ne kum gwaj bakurê gwaj ren kam bamã me uma ne. Me kàtàm ja ne me arỳm Djuão kabẽn man kum kĩnh ne, ne o Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh ne. Dja gwaj kum ane nhym me arỳm o ngryk ne. ");
INSERT INTO txuNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nãm me ã abenmã anen kam Jejumã kum, —Kon ne. Ar ije mar kêt. Mỳj me'õ kabẽnkôt Djuão kute ngômã me angjênhja ar ije kôt mar kêtê, ane. Nhym kam memã kum, —Bir be, dja ba badjwỳ me amã arẽnh kêt ne. Mỳj me'õ kabẽnkôt ije ar meo iba ja dja ba me amã arẽnh kêt ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ne kam memã apỹnh kukràdjà djàri'ã memã mỳjja jakren memã 'ã ajarẽn memã kum, —Be, me'õ arỳm amim pidjô kwỳ kren kadjy bu'ã kẽno kôkayro kum o ipôk ne. Ne kam pidjô janênh djàmã kren ipêx. Ne pidjô pumũnh djwỳnh ku'ê djà'ã par prêkti nhipêx. Ne kam me kwỳmã kum, “Gora me imã o djuw mex. Gora gê abatành ne ô ga amim kwỳo atom ne imã mũm kwỳo atom.” Nãm ã me kwỳmã ane. Mebê idjaer'ã ne Jeju pidjô jakren me rũnh'ã pidjôo djuw mex djwỳnh jakren Metĩndjwỳnh'ã õ pidjôkô djwỳnh jakren kam arek memã 'ã ujarẽnho djan memã kum, —Õ pidjôkô djwỳnh ã me kwỳmã anen kam atemã pyka 'õmã tẽ. Ne kam kam wãnh ar ba. ");
INSERT INTO txuNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nhym arỳm pidjôja tuk ne kumex. Nhym kam õ pidjôkô djwỳnhja arỳm 'ã mytyrwỳ jakren kam 'ỳr õ àpênh jano. Kute memã arẽnh nhym me kute kum pidjô kwỳo atom ne kute kôt anor kadjy ne 'ỳr ano. ");
INSERT INTO txuNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nhym kam 'ỳr tẽn bôx nhym kam me kute pidjôo djuw mexja ate me'õjao tỹm ne kaprêprê:k ne. Nhym mã akubyn 'ỳr ỹkam tẽn 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nhym ajte õ pidjôkô djwỳnhja pãnh 'ỳr me'õjadjwỳ jano nhym 'ỳr tẽn 'ỳr bôx nhym me bĩn punun kum pijàm jadjàn ano. ");
INSERT INTO txuNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nhym kam õ pidjôkô djwỳnh 'ỳr ajte õ àpênh 'õ jano nhym 'ỳr tẽn 'ỳr bôx. Tãmwãdjwỳ ne me tu kubĩ. Nhym kam aben totokmã me'ỳr õ àpênh krãptĩ jano nhym me kwỳ titik ne kwỳ pa. ");
INSERT INTO txuNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nhym kra djwỳnh pydji, kum kra jabêja 'ã ne arỳm amim, “Godja ikra me'ỳr bôx nhym me arỳm mar jabej”, ane. Ne arỳm me'ỳr ano nhym me'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nhym kam me abenmã kum, —Be, kra ne wã. Gwaj on kubĩ. Tãmwã dja bãm kum mỳjja kunĩ ngã, õ nêkrêx kunĩ kanga, ane. Gwaj on tãmwã bĩn kam amim õ nêkrêx, õ mỳjja, õ pidjôja kunĩo aminhõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ne kam o tỹm ne kubĩn arỳm pidjôkô kurũm bõm kumẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Be, mỳj gêdja õ pidjôkô djwỳnhja me ja on? Bir, dja me'ỳr tẽn me'ỳr bôx ne me imex ne kam õ pidjôkôja atemã me ja'õmã kungã. Nãm ã Jeju me rũnhmã ane. Amijã ne õ pidjôkô djwỳnh kra jakren Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh'ã ne õ àpênh jakre. ");
INSERT INTO txuNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nhym kam Jeju ajte memã me kukãmãre kabẽn jarẽn memã kum, —Amrẽbê: ne me bakukãmãre memã Metĩndjwỳnh kabẽn jarẽn memã kum, “E kum kẽn ja ne me kute kikreo ãm djwỳnhja kute kikremã armã te omũn kam bõm kumẽ. Kẽn ja ne arỳm kute kikremã o kajpar, kum o kajpar tỳxi. ");
INSERT INTO txuNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bẽnjadjwỳr djwỳnh ta ne ã kẽno ane gu me omũn kam bamã mexkumrẽx”. Nãm ã me bakukãmãre memã anen arỳm 'ã pi'ôk no'ôk ne. Djãm me aje omũnh ne mar kêt? Nãm Jeju ã me rũnhmã ane. Nãm amijã kẽn jakre. Ne me rũnh'ã kikreo ãm djwỳnh jakre. Mrãmri ne me rũnh kute kikreo ãm djwỳnh pyràk ne arỳm Jeju kanga. Me rũnh kute kanga'ã ne Jeju me rũnhmã ja jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nhym me amim, —Be, gwaj bajã ne pidjôo djuw mex djwỳnhmẽ kikreo ãm djwỳnh jakre, ane. Ne bit kute o tỹmmã te 'ã amijakre. Me krãptĩ pymaje ne me te 'ã amijakren arỳm mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ne kam Jeju'ỳr mebê pardjêu kwỳmẽ Erodji nhõ me ja kwỳ jano. Jeju bẽnjadjwỳr'ã kabẽn punu jabej ne me me ja jano. Godja bẽnjadjwỳr'ã kabẽn punu'õ jarẽ nhym me arỳm bẽnjadjwỳrmã arẽ. Kadjy ne me Jeju'ỳr bôx ne kum, ");
INSERT INTO txuNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","—Ujarẽnh djwỳnh, ba me arỳm ama. Ga ne ga akabẽn katàtkumrẽx. Amã me rũnh pyma kêt. Me rũnhmẽ me kajgomẽ ne ga memã akabẽno aben pyràk ne me imã Metĩndjwỳnh kukràdjà'ã adjujarẽnh mexkumrẽx. Me bẽnjadjwỳr rũnh kunĩ nhõ bẽnjadjwỳr raxbê Xedja. Mebê idjaer kute o me bajtemja. Djãm Metĩndjwỳnh kukràdjà kôt ne gu me baje bẽnjadjwỳr Xedjamã pi'ôk kaprĩ nhõrmã? Nàr kon. Goja on ar imã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dja gu me kum kungã nàr dja gu me kubê nê? Nãm me ã Jejumã ane. Nhym arỳm me 'êxnhĩkôt tu me kuman memã kum, —Nok ba ren me amã, “Metĩndjwỳnh kabẽn kupa'ã ne me kum õro ba”, ane ga me ren memã kum, “Be, Jeju axwekumrẽx. Ga, kute bẽnjadjwỳr raxbê Xedjabê pi'ôk kaprĩ nê prãmja pumũ”, ane. Amrẽ imã ngônhponho pi'ôk kaprĩo tẽ ba me amã omũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nhym me kum o tẽn kungã nhym arỳm memã kum, —Mỳj me'õ ne 'ã karõja? Ne mỳj me'õ ne 'ã idji jêtja? ane. Nhym me kum, —E kum be, Xedja nhõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nhym Jeju memã kum, —Bir be, õ pi'ôk kaprĩ. Dja ga me kum angã nhym be, Metĩndjwỳnh nhõ mỳjjabit dja ga me Metĩndjwỳnhmã angã, ane. Nãm memã ane nhym me te kute kutã mỳjja'õ jarẽnhmã kam no tyn dja. Ne kam arỳm kum kàx ne mã mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nhym kam mebê xadjudjêu kwỳ 'ỳr bôx. Mebê xadjudjêu ne me arĩk memã kum, —Be, me tyk akubyn tĩn prãm kêtkumrẽx, anhỹr ar o ba. Me ja ne me 'ỳr bôx ne kukij ne kum, ");
INSERT INTO txuNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Ujarẽnh djwỳnh, me bakukãmãre Môjdjê ne amrẽbê: me bamã, “Godja me'õ prõ'ỳr mõn kra kêt rã'ãn tyk jabej mỳj dja me nẽ? Bir, dja kamymẽ ar aben djàkam ikwãja'õ 'ỳr mõ. Ne kam kum kra djin kukrij nhym abatành ne. Me kute 'ã abenmã kum, ‘Be, kamy tyk kra ne wã’, anhỹr ne kute kamy tyk mar tỳx rã'ã kadjy.” Nãm ã me bakukãmãre Môjdjê me bamã ane. Nãm mebê xadjudjêu ã Jejumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ne ajte kum, —Be, kamybê 7 ne axikôt apôx. Nhym kutewaja prõ'ỳr mõ. Prõ'ỳr mõn kra kêt ne ty. ");
INSERT INTO txuNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nhym atãrija pãnh 'ỳr mõn kam ajte ty. Nhym pãnh atãrija 'ỳr mõn kam kra kêt rã'ãn ajte ty. ");
INSERT INTO txuNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Be, nãm ar ã o anhỹro tẽm tãmtã: nhym arỳm kutapureja aro ino ren 'ỳr mõn adjwỳnhdjwỳ ty, kra kêt ne ty. Nhym arỳm ar prõja arkôt ty, kra kêt rã'ãn ty. ");
INSERT INTO txuNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ar kubê 7 ne ar aben totokmã kamy prõ'ỳr ba. Godja we ar kunĩ akubyn tĩn ne àbir jabej we àbirkam nhỹnh kamyja dja 'ỳr mõ? ane. Me ta kute we me tyk akubyn tĩn kêt jarẽnh mỳr jabej ne me ã Jejumã ane. Me kute o àpanh nhym binhikrênh kadjy nàràm ne mebê xadjudjêu ã kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nhym Jeju arỳm memã kum, —Me aje Metĩndjwỳnh kabẽn'ã pi'ôk no'ôk mar kêt ne me aje Metĩndjwỳnh tỳ:xkumrẽx mar kêt. Nã gãm me arĩk Metĩndjwỳnh kupa'ã memã 'ã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Be, me tyk ne akubyn tĩnkam djã ne me ajte abenwỳr ba? Kati, akubyn me tĩnkam ne me abenwỳr ba prãm kêtkumrẽx. Kam dja me kute kàjkwakam kadjy mrãnh djwỳnh pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Be, mrãmri me tyk akubyn tĩnkumrẽx. Amrẽbê: ne Metĩndjwỳnh me bakukãmãre Môjdjêmã kabẽn jarẽ. Me tyk akubyn tĩn'ã kabẽn jarẽ nhym 'ã pi'ôk no'ôk. Djãm me aje pi'ôkkam omũnh kêt, akaôk pôk ne tu mex ne ãm'ã ujarẽnhkam Metĩndjwỳnh kute kum, “Ibê Abraãomẽ Idjakmẽ Djako ar õ Metĩndjwỳnh”, anhỹrja, djãm me aje pi'ôkkam amim arẽnh kêt? Arỳm Abraão ar tyk 'ãtũmkam ne Metĩndjwỳnh ã me bakukãmãremã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bir be, ar tyk tũmja Metĩndjwỳnhmã tĩn ne ar ba nĩj pumũ. Djãm Metĩndjwỳnhbê me tyk nhõ Metĩndjwỳnh? Kati. Metĩndjwỳnh ne me tĩn nhõ Metĩndjwỳnh. Me tyk kunĩ ne me kum tĩn. Kam ne ba me amã, “Metĩndjwỳnh ne kubê me tĩn nhõ Metĩndjwỳnh”, ane. Nã gãm me kupa'ã memã 'ã ajarẽ. Nãm Jeju ã mebê xadjudjêumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jejumẽ mebê xadjudjêumẽ aktã kabẽno aben japanho dja nhym Môjdjê kukràdjà mar djwỳnh'õ arỳm me'ỳr bôx. Ne Jeju katàt kute memã Metĩndjwỳnh kabẽn jarẽnhkôt arỳm kuman kam kukij ne kum, —Metĩndjwỳnh kute katàt me kute amijo ba'ã memã karõkam kabẽn jarẽnhja kute aben nhitepã memã kabẽn jarẽnhja dja ga amim maro tẽ. Nhỹnh kabẽnja'õ ne mexo kute kunĩ jakrenh? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nhym kum, —Be, Metĩndjwỳnh kabẽn'õ kumrẽx mexo kute kunĩ jakrenhja ba amã arẽ ga ama. Metĩndjwỳnh memã kum, “Ẽ, mebê idjaer, gora ikabẽn ma. Bẽnjadjwỳr djwỳnh, kubê ne Metĩndjwỳnh. Bẽnjadjwỳr djwỳnh pydji. ");
INSERT INTO txuNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Me anhõ Bẽnjadjwỳr djwỳnh, me Atĩndjwỳnh dja ga me amã kĩnh, amã abêo katàt me kunĩ, mỳjja kunĩ jakre. Djãm ajajkwaobit amã Metĩndjwỳnh jabêmã? Kati. Ajamak, akadjwỳnhbê, akukràdjà kunĩo dja ga me amã abê:.” Nãm ã Metĩndjwỳnh memã ane. Be, tãm ne ja. Metĩndjwỳnh kabẽn'õ kumrẽx mexo kute kabẽn kunĩ jakrenh ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ne kam atãri Metĩndjwỳnh ajte memã kum, “Me amã amibu'ã me ja jabê. Kute mrãmri ne ga me amã amijabêja pyràk dja ga me ã amã amibu'ã me ja jabêo ane.” Nãm ã Metĩndjwỳnh memã ane. Atemã kabẽn'õ mexo kute ja jakrenh kêt. Nãm ã Jeju kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nhym Môjdjê kukràdjà mar djwỳnh kum, —Ujarẽnh djwỳnh, kôt ne ga arẽ. Mrãmri Metĩndjwỳnh pydjibit. Atemã'õ kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dja me kum kĩnh, kum abêo katàt me kunĩ, mỳjja kunĩ jakre. Djãm ajkwaobit kum Metĩndjwỳnh jabêmã? Kati. Amak, kadjwỳnhbê, kukràdjà kunĩo dja me kum abê:. Ne kum amibu'ã me ja jabê. Kute mrãmri ne me kum amijabêja pyràk dja me ã kum amibu'ã me ja jabêo ane. Akabẽn ja ne mexo Môjdjê kabẽn kunĩ jakre. Dja me Metĩndjwỳnh kabẽnja man kôt ar amijo ban arỳm mexkumrẽx nhym me kute Metĩndjwỳnhmã mry bôrja mexo me têp kêtkumrẽx. Me kute kum apỹnh mỳjja nhõr kunĩja mexo me têp kêtkumrẽx. Nãm ã Môjdjê kukràdjà mar djwỳnhja Jejumã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nhym kam õkre kadjwỳnhbê amim, —Be, tãmwã ne ikabẽn kôt kabẽn mexkumrẽx, ane. Ne kum, —Be, Metĩndjwỳnh kute amim apytàr ne ar ajo ba 'ỳr, ane. Nhym me ajte ijukri Jeju kukjêr kêt. Kabẽn mex pymaje ne ajte kukjêr kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nhym kam Jeju ajte Metĩndjwỳnh nhõ kikretikam tẽn bôx ne memã Metĩndjwỳnh kukràdjà'ã ujarẽnho djan kam memã kum, —Be, Môjdjê kukràdjà mar djwỳnh ne me memã kum, “Kritubê ne Dawi tàmdjwỳ”, anhỹr ar o ba. Be, djãm Kritubê Dawi tàmdjwỳbit? Kati, kubê ne Dawi nhõ Bẽnjadjwỳrdjwỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ne kam memã me kukãmãre Dawi kabẽn jarẽn memã kum, —Be ga, me bakukãmãre Dawi ta kute memã 'ã ujarẽnhja pumũ. Metĩndjwỳnh Karõ kukwakam kute memã Kritu'ã ujarẽnhja pumũ. Nãm memã kum, “Inhõ Bẽnjadjwỳrmã ne Bẽnjadjwỳr djwỳnh kabẽn ne kum, ‘Amrẽ idjubôk'ãnh nhỹ, Abẽnjadjwỳr raxkam idjubôk'ãnh nhỹ. Ikam ama ba amrẽ awỳr akurê djwỳnho mõ ga me kwỳo apardjan me kwỳ nhimex.’ Nãm ã Metĩndjwỳnh inhõ Bẽnjadjwỳrmã ane”, ane. Bir be ga, Dawi kute kum “Abẽnjadjwỳr rax”, anhỹrja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mỳkam ne me 'ã Dawi tàmdjwỳ kajgo jarẽ? Djã nãm o tàmdjwỳ kajgo? Kati, Dawi ta ne kute o õ Bẽnjadjwỳr rax. Nãm Jeju ã memã ane nhym me krãptĩtija kum kabẽn kĩ:nhkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nhym arek memã ujarẽnho dja:n memã kum, —Gora me aminêje me omũ. Aminêje Môjdjê kukràdjà mar djwỳnhwã pumũ. Be, me ja ne me kute amibẽn kadjy kute kubẽkà jabjêtibit jangjênh prãmkumrẽx. Ne ajte me krãptĩ nhipôkri kute memã amibẽn nhym me kute memã rũnh jarẽnh ne kute memã kum, “Bẽnjadjwỳr, djãm ga, djãm ga”? anhỹrja. Ja ne me kum kĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ne mebê idjaer bikprõnh djàkam nàr me krãptĩ àkuro krĩkam ne memã wan krĩ prãmkumrẽx. Me kute amibẽn kadjy ne me me rũnh krĩ djàkam krĩ prãmkumrẽx. Kwãrĩk wãnh gar me kudjwa kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nãm me me 'uwtĩ krão apan mebê mỳjja kunĩo akĩ ne kam ajkwaobit Metĩndjwỳnhmã kabẽn rũnh ne, ne kum kabẽn 'ijabjêo ku'ê. Nãm me 'êx ne amijo mex ne kum kabẽn. Be kati, me axwekumrẽx. Kam gêdja Metĩndjwỳnh me kuràm memã pãnh rax jarẽn prĩne me kuràm meo ajkẽ. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nhym kam me kwỳ itepato mõn bôx. Me kute amikutã Metĩndjwỳnhmã pi'ôk kaprĩ kwỳ nhõr kadjy ne me mõ. Nhym Jeju arỳm tẽn pi'ôk kaprĩ nhõr djà kônh nhỹn me omũnho nhỹ. Me õ nêkrêx rũnh krãptĩ ne me aben totokmã kam pi'ôk kaprĩ rũnh ne kurẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nhym kam me'õ nija 'uwtĩ kubê mjên tyk nhym õ mỳjja kêtja ngônhponhreo pi'ôk kaprĩo amãnhkrut ne kubyn o tẽn kam kumẽ. Ngônhponhreja ne abenã rẽnhkam kubê pi'ôk kaprĩ 'ô pydji, ngri:re. ");
INSERT INTO txuNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nhym kam Jeju amiwỳr kôt ba djwỳnh ar ku'uw nhym ar 'ỳr bôx. Nhym arkum, —Ba ar amã arẽ, me'õ 'uwtĩ ja ne õ mỳjja kêt ne tu me kuràm õ pi'ôk kaprĩ raxo tẽn Metĩndjwỳnhmã kungã. Me kunĩ kuràm pi'ôk kaprĩ raxo tẽn kum kungã. ");
INSERT INTO txuNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Me ja ne me õ pi'ôk kaprĩ kumex ne kam 'ã kàtàm ne kumex. Ne kam 'ã kàtàmja Metĩndjwỳnhmã kungã. Nhym be, me'õ nija ne õ pi'ôk kaprĩ kêtê, pi'ôk kaprĩ ngrire ne tu kum kunĩ ngã. O kute amikadjy mỳjja byr ne krẽn ne tĩn kadjy Metĩndjwỳnhmã kunĩ ngã. Kum 'õ nõr kêtê. Kam ne ba me amã, —Nãm me kuràm pi'ôk kaprĩ rax ne kum kungã. Mrãmri ne ba ar amã arẽ. Nãm ã Jeju kôt ba djwỳnh arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ne kam Metĩndjwỳnh nhõ kikreti kurũm kato. Nhym kôt ba djwỳnh'õ kum, —Ẽ, Ujarẽnh djwỳnh ga, kẽntio me kute kikreti kwỳ nhipêxja pumũ. Kẽnmẽ kikre ã ti:re ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nhym Jeju arỳm arkum, —Be, ar kikretija pumũ. Dja ĩ me kurê djwỳnh prĩne kikreti ngràn kẽn aben nhiby ikwã kunĩ nhikô rê. Nhym kam kẽn'õ aben nhiby nõr kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nhym kam ar tẽ:n kam krãnhbê Oriwêre'ã wabi. Nhym Jeju arỳm amybỳm Metĩndjwỳnh nhõ kikreti kônh nhỹ. Nhym Pedrumẽ Xijagumẽ Djuãomẽ Ãngre ar me kàxã kukij ne kum, ");
INSERT INTO txuNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Ẽ, ar imã kikreti ngrành'ã ajarẽ. Nhỹnh amex 'õkam dja me bakurê djwỳnh me bawỳr bôx ne kikreti ngràn ãm djà kapõ? Mỳj gêdja kukãm apôx? Dja bar omũn kam kôt õ akatimã ikaton õ akati ma. ");
INSERT INTO txuNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nhym kam Jeju arkum apỹnh mỳjja kukãm apôxmã arkum 'ã ajarẽn arkum, —Gora ar amijã ano tỳx gê me'õ ar amã 'êx ne ar anoo biknor ne Metĩndjwỳnhbê ar ajo akẽx kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Be, me krãptĩ dja ĩ aben totokmã me'ỳr bôx ne arỳm amijo 'êx. Amijo 'êx ne arỳm amijã imẽ. Amijã imẽn arỳm memã kum, “Me anhõ Bẽnjadjwỳrbê kumkati kadjy ne Metĩndjwỳnh ijano ba tẽn bôx. Ba ibê Kritu”, ane. Ne kam arỳm me krãptĩ noo aknon Metĩndjwỳnhbê meo akẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Be, kam dja gar me kute abenwỳr prõt man amybỳm me kute abenwỳr prõt jarẽnh ma. Kwãrĩk wãnh kam ar atĩn prãm kêt. Ba ne ba kukãm ar amã 'ã ajarẽ gar arỳm ama. Ja kumrẽx gêdja me ã o anhỹro tẽ. Kraxje kute inomã mẽnh kêt, kute 'ỳr o tẽm rã'ã. ");
INSERT INTO txuNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nà, apỹnh me ba djàri gêdja me abenwỳr prõt ne aben nhimexo ba. Nhym apỹnh bẽnjadjwỳr rũnh nhõ me dja me abeno kurê djwỳnh ne aben nhimexo ba. Apỹnh pyka djàri gêdja kam pyka terte:t ne. Nhym prãmdjwỳ me kwỳ nhimex. Be, me tokry krax ne ja. Ga, me nire kra àja pumũ. Adjỹm. Dja kra à:n kam arỳm à ra:x ne. Me adjwỳnhdjwỳ dja me tokry mõ:n kam arỳm tokry ra:x ne. Be, me tokry krax ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Be, ar ga dja gar ajaxwe kêt kadjy amijãno dja. Dja me apỹnh me rũnhmã ar akangan me bikprõnh djàkam ar atitik ne. Ar aje ijã adjujarẽnh ar abakam dja me apỹnh me bẽnjadjwỳr rũnhmẽ me bẽnjadjwỳr kry'ỳr ar ajo mõ. Ar ajo mõ gar me kabem aku'ê. Memã ijã adjujarẽnh nhym me kute mar kadjy me kabem aku'ê. ");
INSERT INTO txuNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nhym be, me kute amim imar dja me apỹnh me ba djà kunĩkôt ijã ujarẽnh ny jarẽnh kumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Dja me ar ajo rôrôk ne kute memã ar akukjêr kadjy me rũnhmã ar akanga. Kwãrĩk wãnh gar kam amikukãm akabẽn 'õ'ã karõ kêt ne kwãrĩk wãnh amikukãm anhõkre kadjwỳnhbê amim, “Je tô mỳj gêdja ba aminêje memã ikabẽn ja on”? anhỹr kêt. Be, me kute memã ar akukjêr majmã dja Metĩndjwỳnh Karõ ta ar amã ar akabẽn mex jarẽ gar aman arỳm memã arẽ. Kute ar amã ar akabẽn jarẽnh ja dja gar memã arẽ. Djãm ar ga dja gar memã akabẽn jarẽ got? Kati. Karõ ta dja memã kabẽn jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nhym mỳjja kunĩ pyka kôt amingrành kadjy dja me kute abeno õbikwa djwỳnh abenmã àkrê. Me rũnh kute me par kadjy dja me memã kamy kanga. Dja bãm memã kra kanga. Dja kra kum nã nàr bãm kurên me rũnhmã ar kanga. Me rũnh kute ar par kadjy ar kanga. ");
INSERT INTO txuNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ikôt ar abikamẽnhkam dja me kunĩ kum ar akurê. Ne te kum ar akurê gar ijã adjukanga kêt ne amã ikĩnh tỳx rã'ã ba arỳm ar apytà. Dja me kunĩ kute aminhinomã amimẽnh nhõ akati bôx gar amã ikĩnh tỳx rã'ã ba arỳm ar apytà. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ne kam ajte arkum, —Be, ar aje ajbir imã, “Ar imã kikreti ngrành'ã ajarẽ”, anhỹrja ba ar amã arẽ gar ama. Dja mỳjja amingrành 'ỳr nhym kam arỳm mỳjja punutija dja. Metĩndjwỳnh nhõ kikretikam dja. Djãm mỳjja punuti Metĩndjwỳnh nhõ kikretikam ãmkam mex got? Dja kam dja gar arỳm omũ. Mỳjja punuti djô'ã dja me mỳjja kunĩo ajkẽn kungrà. Me bakukãmãre Danijeu ne amrẽbê: 'ã ajarẽ. Metĩndjwỳnh kukwakam memã 'ã ajarẽ. Danijeu ne arỳm memã mỳjja punuti ja'ã ajarẽn 'ã pi'ôk no'ôk. Dja gar pi'ôk no'ôkwã pumũn kam mỳjja punuti pumũn kam kôt ama. Kam gêdja Djeruxarẽ bu'ã pyka ja nhidjibê Djudêjakam me ja amijã maje krãnh'ỳr prõt ne. ");
INSERT INTO txuNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Gêdja me'õ kikre nhimõk po'ã ãm jabej kwãrĩk wãnh akubyn ũrkwãmã nêkrêx'ỳr àr ne byr ne o tẽm kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Gê purkam ar ba jabej tu umaje prõt. Kwãrĩk wãnh kute kubẽkà jamỳnhmã 'ỳr akẽx kêt. Dja tu me ãm kamã amũ prõt. ");
INSERT INTO txuNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Watĩ:re, akati wãkam me tujarômẽ me kra karà dja me tokry:. Me mỳjja punuti pymaje prõt ne kam arỳm tokry:. ");
INSERT INTO txuNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dja gar Metĩndjwỳnhmã amijo a'uw gê na raxkam umaje ar aprõt kêtmã. ");
INSERT INTO txuNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Be, dja me kam tokry kume:xi. Akubyn amijo tẽn mỳjja kunĩmo krax djà'ỳr amijo bôx ne ama. Me akukãmãre aben kukãm tokrykôt dja gar me maro tẽ. Dja gar me tokry tũm maro tẽ:n amiwỳr me tokry maro bôx. Ga, me tokry kume:xja pumũ. Be, amrẽ mỳjja punuti nhõ akati bôxkam dja me tokryo katàt me tokry tũm wã kunĩ jakre. Ne amrẽ me'ã akati mõrkam me tokry nydjwỳ dja me tokryo mỳjja punuti'ã me tokryja têp kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Metĩndjwỳnh ren tokry'ã akati kwỳ ngri kêt nhym me'õ ren tĩn kêtkumrẽx. Be, Metĩndjwỳnh kute amim õ me ja'ã karõ ne kute amijo me utàrja kadjy dja arỳm 'ã akati wã kwỳ ngri. ");
INSERT INTO txuNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Godja me'õ 'êx ne ar amã, “Ota, jakam arỳm Kritu bôx ne nhỹ. Arỳm ne Metĩndjwỳnh 'ã me õ Bẽnjadjwỳrbê kumkati mẽ nhym jakam arỳm memã nhỹ”, anhỹr jabej. Nàr me'õ ajte 'êx ne ar amã, “Ota, jakam arỳm Kritu bôx ne nhỹ. Arỳm ne Metĩndjwỳnh 'ã me õ Bẽnjadjwỳrbê kumkati mẽ nhym jakam arỳm memã nhỹ”, anhỹr jabej. Djãm ar aje me ja marmã? Kati, kwãrĩk wãnh amim me ja mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Be, apỹnh me ta kute amijo Kritu pyràk dja me amijo amirĩt ne. Nhym amũ me jadjwỳ amijo amirĩt ne 'êx ne memã kum, “Ba ne ba Metĩndjwỳnh kukwakam me amã idjujarẽnh iba”, anhỹro ba. Dja me me aêrbê mỳjja pumũnh kêt kwỳ nhipêx, kute me noo biknor nhym me kute me'ã abenmã kum, “Mrãmri ne djãm Metĩndjwỳnh kukwakam me kabẽnkumrẽx”, anhỹr kadjy. Godja me o me noo biknor ne Metĩndjwỳnhbê meo akẽx jabej. Metĩndjwỳnh kute amrẽbê amijo me utàrja kubê meo akẽx ne kute meo ba jabej. Me 'êxnhĩ no tỳxo kute me akrenh jabej, godja kubê me kwỳo akẽx ne meo ba jabej. ");
INSERT INTO txuNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Be, ar ga dja gar amijã ano tỳx ne. Ba ne ba mỳjja apôx kêtri kukãm ar amã arẽ gar arỳm ama. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ne kam ajte arkum, —Nhym me tokryo ku'êwã'ã akati apêxkam dja mỳjja rũnh apôx. “Nhym myt amijo akamàt kô tyk nhym mytyrwỳ irã kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nhym kanhêti kàjkwa kurũm rôrôk nhym kàjkwakam apỹnh mỳjja tỳ:x amingrẽk ne.” ");
INSERT INTO txuNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ba kam ije amijo inhĩ dja ba arỳm prĩne itỳ:x ne prĩne imextire ne ipyma:. Ne kam kakrãkôt bôx nhym me kunĩ: arỳm ibôxkôt ipumũ. ");
INSERT INTO txuNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ba kam ikadjy mrãnh djwỳnh jano nhym me arỳm inhõ me ja o atom. Ije amijo me utàrja kunĩo atom. Dja me kwỳ kàjkwa krax'ãm mõn meo atomo mõ. Nhym me kwỳ kàjkwa 'ênhôt'ãm mõn meo atomo mõ. Nhym me kwỳ aktã kàjkwa nhirê'ãm mõn meo atomo mõ. Dja me apỹnh pyka kunĩkôt inhõ me ja kunĩ:o atom. Ba ne ba kukãm ar amã 'ã ajarẽ. Gora abej ajkam ama. ");
INSERT INTO txuNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Be, akubyn ibôx djà nhõ akatija'ã ne ba ije pidjôbê pigêre jakremã. Gora ije 'ã mỳjja jakreja ma. Ba ar amã arẽ gar ama. Dja pidjô pakà nokà tukam 'ô nhingrã kadjy arỳm ingrã apôx gar kam arỳm amexmã kamnhĩx nhym kam arỳm amex. ");
INSERT INTO txuNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bir be, gêdja ba ije ar amã mỳjja jarẽnhja ã apôx mõr ane gar kam arỳm ijabej rĩt ne ijabej ajkam ama. Akubyn ibôx djà arỳm 'ỳr. 'Ỳr dja mỳjja apôxja. Amex kutã gêdja pi'ô ingrã. Nhym be, ibôx kutã gêdja mỳjja pymatija apôx mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nà, mrãmri ne ba ar amã kôt arẽ. Me akamingrãnyre ja gêdja gar atyk par kêtri mỳjja ja kunĩ apôx. Mrãmri ne ba ar amã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ikabẽn kajgo kêtkumrẽx. Gêdja pykamẽ kàjkwa ĩ apêx. Nhym be, ba ikabẽn gêdja 'õ biknor kêtkumrẽx. Mrãmri gêdja ba ije mỳjja jarẽnh ja kunĩ apôx nhym me omũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ne kam ajte arkum, —Be, ba akubyn ibôx djà nhõ akati nàr myt djãm me'õ kute mar? Kati, me'õ kute mar kêtkumrẽx. Kàjkwakam kadjy mrãnh djwỳnhdjwỳ kute mar kêt. Ibãmbit ne kute mar. ");
INSERT INTO txuNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Dja gar ajaxwebê amijãno djan arek ijabej ajkam ama ne Metĩndjwỳnhmã amijo a'wỳ. Mỳkam? Bir, ar aje akubyn ibôx djà'ã myt mar kêtkam. ");
INSERT INTO txuNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ar aje akubyn ibôx djàkam myt mar kêt kute õ kikre djwỳnh nhõ àpênh pyràk. Ba ar amã arẽ gar ama. Be, õ kikre djwỳnh ne arỳm kurũm anhỹr bê tẽmmã. Ne kam õ àpênhmã kikre'ã karõn arkum apỹnh àpênh djà'ã karõ. Ne kre nêje ku'ê djwỳnhmã kum, “Gora arek ijabej ajkam ama”, ane. Ne kam arỳm mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kam dja gar gadjwỳ arek ijabej ajkam ama. Ba ne ba ije õ kikre djwỳnh pyràk. Ar aje ibôx'ã myt mar kêt. Godja ba parakam ibôx jabej nàr akamàt kô ipôkri ibôx jabej nàr õkrẽn'ãnh kàrkam ibôx jabej nàr kryràm ibôx jabej. ");
INSERT INTO txuNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ar arek ijabej ajkam ama. Dja gar ate akrã ba ar ajaêrbê bôx gar ajmã nẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ar amã ne ba arỳm ibôx djà'ã karõ. Jakam ne ba me kunĩmã 'ã karõ. Me arek ijabej ajkam ama. Nãm ã Jeju me kukãm mỳjja apôx'ã arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Be, Metĩndjwỳnh me irôbê mrãnh nhõ akati nêje arỳm akati pydji. Kam ne mebê idjaer kunĩ amex kunĩkôt aben pydji. Amrẽbê: Metĩndjwỳnh me kukãmãre nhirôbê mrãnh nhym me kute aben kajmã'ã mar kadjy ne me aben pydji. Kamãdjwỳ ne me kute djwỳponhrebit kur. Metĩndjwỳnh me irôbê mrãnh nhõ akati nêje akati pydji nhym me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ arỳm abenmã kum, —Mỳj godja gwaj baje me krãptĩ kàxã Jejuo batỹm ne bĩnmã on? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ne ajte abenmã kum, —Kwãrĩk wãnh gwaj me kute aben pydji djà nhõ akatikam o batỹm kêt. Gwaj ren o ane nhym me krãptĩ ren o ngryk ne ren kangao kumex, ane. Metĩndjwỳnh me irôbê mrãnh nhõ akatikam me krãptĩ bôxja ne me kuman ã Jeju'ã abenmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Be, krĩ ngrirebê Betanhakam ne Jeju nhỹ. Kamã ne me'õ ĩ kajêkam tê arỳm mex. Idjibê ne Ximão. Ũrkwãkam ne Jeju õ kwỳ krẽno nhỹ. Õ kwỳ krẽno nhỹ: nhym me'õ ni arỳm 'ỳr tẽn 'ỳr bôx. Nãm 'ỳr kẽn jakareo ngônh byno tẽ. Ngônhkam ne me kudjỳ djà kangôo ipu. Idjibê ne nadu. Nãm me prĩne ipêx mex nhym pãnh raxkumrẽx. Nãm o tẽn o bôx ne 'ã kutan arỳm Jeju nhimõkkam kapĩ. ");
INSERT INTO txuNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nhym bu'ã me ku'ê kwỳ kôt nokà nhàn abenmã kum, —Je tô mỳkam ne arỳm me kudjỳ djào ajkẽ? ");
INSERT INTO txuNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gwaj ren pi'ôk kaprĩ kadjy ren memã kungã ne ren pãnh pi'ôk kaprĩ rax ne ren kuby. Ren 'ã akrekam pãnho denarju kubê 300 jakre. Gwaj ren pi'ôk kaprĩ rax byn ren me õ mỳjja kêtmã kungrà. Mỳkam ne arỳm o ajkẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nãm ar anen nijamã akij. Nhym Jeju arỳm tu ar kabẽn man arkum, —Kwãrĩk wãnh rã'ã. Mỳkam ne gar kum kaprĩ jadjà? Djãm kute ijã kapĩnkam punu got? Kati, mexkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Be, akati kunĩkôt ne ar abu'ã me õ mỳjja kêt ar ba rã'ã. Ar aje memã mỳjja nhõr prãm tu memã angã. Nhym djãm arek gwaj baro'ã ar baba rã'ãmã? Ba ar amã arẽ gar ama. ");
INSERT INTO txuNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dja ba ty nhym me arỳm ijadjà. Me kute ijadjàrmã ne nija kuma. Kuman arỳm kum ikaprĩn ijã me kudjỳ djà kapĩ. Nãm te kute mỳjja mexo kute imex pyràk ne kute imã õrmãn arỳm tu ijã me kudjỳ djà kapĩ. ");
INSERT INTO txuNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ba ar amã arẽ gar ama. Dja me kàj bê pyka kunĩkôt mã memã ijã ujarẽnh ny jarẽn mã nijadjwỳ 'ã ajarẽ. Kute ijã me kudjỳ djà kapĩn'ã ajarẽ. Gêdja me kam aben djô'ã nija mar rã'ã ne. Mrãmri ne ba ar amã arẽnhkumrẽx. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nhym kam Djuda Ikadji, Jejukôt ba djwỳnhbê 12 'õ ne me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr ar'ỳr tẽ. Kute arkum Jeju kanga kadjy ne tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ar'ỳr tẽn ar'ỳr bôx ne arkum, —Arỳm ba ije ar amã Jeju kangamã. Nãm ã arkum ane nhym ar kuman arỳm kĩnhkumrẽx ne. Ne arỳm kum kabẽn jarẽnh mãmdjin kum, —Dja ga ã Jejuo ane bar kam arỳm amã pãnh pi'ôk kaprĩ ngã, ane. Nhym kam amim, —Mỳj dja ba ije arkum Jeju kanga kadjy on? Nãm ã Djuda amim anhỹro ba. ");
INSERT INTO txuNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nhym kam mebê idjaer kukràdjàkôt me kute djwỳponhbit kur nhõ akati arỳm kutewa. Kam ne me apỹnh ũrkwãkam Metĩndjwỳnhmã mrykĩ'ãtomti pan kuku. Amrẽbê: Metĩndjwỳnh me irôbê mrãnhja ne me kute kôt mar kadjy ã o ane. Nhym kôt ba djwỳnh ar Jejumã kum, —Metĩndjwỳnh me irôbê mrãnh nhõ akatikam gwaj banhõ kwỳ krẽn kadjy jãm dja bar tẽn ar akutêp gwaj banhõ kwỳ krẽn djà jadjwỳr mex? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nhym arỳm kôt ba djwỳnh amãnhkrutmã 'ã karõn arkum, —Dja gar krĩraxkam tẽ. Nhym arỳm me'õ ngyo ngônhkam ngô mỳn o tẽ gar omũ. ");
INSERT INTO txuNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nhym arỳm kikremã wadjà gar kôt tẽn wadjà. Wadjàn õ kikre djwỳnhmã kum, “Ujarẽnh djwỳnh ne amã kabẽn ne amã, ‘Bamẽ ikôt ba djwỳnhmẽ ne bar inhõ kwỳ krẽnmã. Nãr kadjy inhõ kumoka'ê? Aje me bôx nymã kumoka'ê jarẽnhja, nãr? Dja bar Metĩndjwỳnh me irôbê mrãnh nhõ akati mar kadjy mrykĩ'ãtomti krẽ.’ Nãm ã Bẽnjadjwỳr amã ane”, ane. Be, dja gar ã õ kikre djwỳnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nhym kam kôjrũm kumoka'ê jabatành'ỳr ar ajo tẽn ar amã akre. Kam ne gwaj bakutêp mỳjja kunĩ nõr pro. Dja gar kam ikutêp gwaj banhõ kwỳ krẽn djà jadjwỳr mex. Nãm ã Jeju arkum 'ã karõo ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nhym kam kôt ba djwỳnh 'ỳr tẽ. Ne Jeju kute arkum kabẽn kôt arỳm mỳjja kunĩmã katon arỳm kam mrykĩ'ãtomti gan õ kwỳ krẽn djà jadjwỳr mex. ");
INSERT INTO txuNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nhym arỳm ar'ã para nhym Jejumẽ Ar kubê 12 ro'ã kikre'ỳr tẽn 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ne kam arỳm nhỹ. Àkuro nhỹ nhym kam Jeju arkum, —Ar ajõ ikôt adjàkuro anhỹrja dja ga ikurê djwỳnhmã ikanga. Mrãmri ne ba ar amã arẽnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nhym kam ar arỳm kaprĩren apỹnh ar ĩ djàri aben totokmã kum, —Djãm ba? Djãm ba? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nhym arỳm arkum, —Be, ar abê 12ja 'õ, aje ikôt ngônhkrãtikam mry kangômã djwỳ jadjàro anhỹrja'õ dja ga memã ikanga. ");
INSERT INTO txuNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Be, ba ije amijo inhĩ ne amrẽbê me bakukãmãre ijã Metĩndjwỳnh kabẽn no'ôk nhym pi'ôkkam me kute ijo anhỹrmã arẽnh kôt ne me arỳm jakam ar ã ijo anhỹro ba. Nhym be, kute ikurê djwỳnhmã ikanga djwỳnhja dja ĩ kute memã ikanga pãnh tokry rax ne. Ỹ, watĩ:re. Tãmja ne ren rwỳk kêt ne. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nhym ar àkuro nhỹ: nhym Jeju arỳm djwỳ'õ byn kam o Metĩndjwỳnhmã mextire jarẽ. Kum mextire jarẽn arỳm kokij ne apỹnh arkum kungã. Ne kam aminhĩ'ã djwỳ jakren arkum, —Inhĩ ne ja. Ar abyn krẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ne kam ngônhkrãkam pidjô kangôjadjwỳ byn kam o Metĩndjwỳnhmã mextire jarẽn arkum kungã. Nhym ar kunĩ o ikõ. ");
INSERT INTO txuNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nhym kam amikamrô'ã pidjô kangô jakren arkum, —Ikamrô ne ja. Me krãptĩ kadjy dja ikamrô prõt. Metĩndjwỳnh ne arỳm ikamrô prõt'ã memã kabẽn ny jarẽnh mãmdji, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ba ar amã arẽ gar ama. Ije pidjô kangôo ikõmo krã'yr ne ja. Metĩndjwỳnh kute amim õ me ja kunĩ pytàr ne kute meo bakambit dja ba pidjô kangô nyo ikõ. Mrãmri ne ba ar amã arẽnhkumrẽx. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nhym kam ar ngre. Ngren arỳm o ino re. Ngrero ino ren arỳm amũ krãnhbê Oriwêre'ỳr mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","'Ỳr mõ: nhym Jeju arkum, —Be, akamàtja tãmkam dja me ijo ajkẽ gar me umaje aprõt ne ajmà. Amrẽbê: ne me bakukãmãre ar aprõt ne ar abimành'ã ajarẽ. Metĩndjwỳnh kukwakam ne me ar ajã ajarẽn memã kum, “Be, dja ba mrykĩ'ãtomtio ba djwỳnh titik nhym mry umaje prõt ne ajmà.” Nãm me ã ar ajã ujarẽnho anen arỳm 'ã pi'ôk no'ôk ne. Be, akamàtja tãmkam dja gar me umaje aprõt ne ajmà. Me bakukãmãre kute ar ajã ujarẽnh kôt dja gar aprõt ne ajmà. ");
INSERT INTO txuNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nhym kam me arỳm ibĩ. Ba ityk ne akubyn itĩnkam dja ba ar akukãm pykabê Garrêjamã tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nhym Pedru kum, —Godja ar kunĩ prõt ne bimành jabej ba dja ba arkôt iprõt ne imàt kêt ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nhym Jeju kum, —Kati, mrãmri dja ga arkôt aprõt. Ba amã arẽ ga ama. Akamàtja tãmkam õkrẽn'ãnh kàr kêtri dja ga amijã maje ajêx pydji, nhym arỳm kà. Ga kam ajte amijã maje ajêxo amãnhkrut ne ijã memã kum, “Kati, ije me'õwã pumũnh kêtkumrẽx”, ane. Nhym ajte kà. Dja ga ã ijã memã ane. Mrãmri ne ba amã arẽnhkumrẽx. Nãm ã Jeju kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nhym Pedru kàj bê ajte kum, —Gê me gu baro'ã gu babĩn jabej ba ije amijã maje ijêx prãm kêtkumrẽx, ane. Nhym kam ar kunĩ ã kum ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ne kam mõ:n kam Jeju kôt pidjôkôbê Djexema'ỳr bôx. Nhym kam kôt ba djwỳnhmã kum, —Jakam dja gar ikutêp nhỹ. Ba 'ỳr Metĩndjwỳnhmã amijo a'wỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ne kam Pedrumẽ Xijagumẽ Djuão ar aprôn aro mõ. Ne kam madjà kreti:n arỳm kaprĩ rax ne. ");
INSERT INTO txuNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ne kam arkum, —Ikaprĩ:re. Arỳm ikaprĩ kute ibĩn 'ỳr. Jãnh mãn ar idjêje nhỹ gwaj baro'ã aminêje barĩto nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ne kam amũ tẽ. Tẽmo rãm ne ja ne tu mỳrbê tỹm. Tỹm ne arỳm Metĩndjwỳnhmã amijo a'uw. Kute tokry, kaprĩbê utàr prãm jabej kum amijo a'uw. Tokry 'ỳr bôx kêt jabej kum amijo a'uw. ");
INSERT INTO txuNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ne kum, —Djũnwã, djãm abê mỳjja'õ bipdjur? Kati. Aje mỳjja kunĩ nhipêx mar. Itokry, ikaprĩjabê ipytà. Nàr kon, kwãrĩk wãnh rã'ã ba tu itokry. Djãm ba ne ba amimarkôt ar amijo iba? Kati, akabẽnkôt ne ba ar amijo iba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ne kam kàjmã djan ar amãnhkrut ne ikjêkêtja'ỳr akẽx ne tẽn ar'ỳr bôx. Nhym arek ar õto ikwã. Nhym Pedrumã kum, —Je, Ximão, djã nã gãm arek anhõto nõ? Kraxje kô 'iry kêt ne ga anhõto nõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ne ar kunĩmã kum, —Ar aminêje rĩt ne Metĩndjwỳnhmã amijo a'wỳ. Gêdja me te axwe'ã ar amã apnê gar mekôt ajaxwe kêt. Ja kadjy dja gar kum amijo a'wỳ. Be, ar anhõkre kadjwỳnhbê ne gar amã ikabẽnja kĩnh. Nhym be, ar aminêje arĩtbê ne gar arerekren anhõtdjwa ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ne kam ajte amũ tẽn Metĩndjwỳnhmã amijo a'uw ne kute õbê kum kabẽn jarẽnhja kôt ajte kum tãm jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ne kam ajte akubyn ar'ỳr akẽx ne tẽn ar'ỳr bôx. Nhym ar nokà bã mex ne. Ajte arek õto ikwã. Rerek mex ne arek õto ikwã nhym ar tok nhym ar te kute kum kabẽnmã umaro nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nhym kam ajte amũ tẽn Metĩndjwỳnhmã amijo a'uw. Kum amijo a'uw ne ajte ar'ỳr akẽx ne ar'ỳr tẽn ar'ỳr bôx. Ne arkum, —Je, djãm arek ar anhõto anhikwã rã'ãã, akôkam kôto anhĩkwã? Aj, arỳm itokry djà iwỳr bôx 'ỳr. Ota, arỳm kute me axwemã ikangamã, ije amijo inhĩja ne kute memã ikangamã. ");
INSERT INTO txuNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kàjmã ar dja. Gwaj on me'ỳr. Ota, arỳm kute memã ikanga djwỳnh bôx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ne kute arkum anhỹro ãm rã'ã nhym Djuda arỳm 'ỳr bôx. Jeju kôt ba djwỳnhbê 12 'õ ne kubê Djuda. Nãm 'ỳr bôx nhym me krãptĩ me:x ne kôt mõn 'ỳr bôx. Nãm me kàxdjwa kajgomẽ kô jamỳn kadjy o mõn o bôx. Me rũnh ne me me ano. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebêngêtmẽ ne me me ano nhym me 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Me 'ỳr mõr kêtri ne kute memã kanga djwỳnhbê Djudaja memã kum, —Be, ije me'õ nhine kaôrkôt dja ga me omũn arỳm o tỹm ne pa 'amỳ. Nãm Djuda arỳm ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ne kam 'ỳr tẽn 'ỳr bôx ne kum, “Ujarẽnh djwỳnh”, anen arỳm ine kaô. ");
INSERT INTO txuNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nhym kam me arỳm 'ỳr mõn 'ỳr bôx ne o tỹm ne arỳm pa 'amỳ. ");
INSERT INTO txuNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nhym me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr raxja nhõ àpênh mekôt tẽ. Nhym bu'ã me ku'êja 'õ ne arỳm õ kàxdjwa kajgo kaban o me'õjamã akabên amak ta, bẽnjadjwỳr nhõ àpênhja jamak ta. ");
INSERT INTO txuNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nhym kam Jeju me krãptĩjamã kum, —Je djãm idjàkĩnhĩ ne ga me aje ijo atỹm kadjy iwỳr anhõ kômẽ anhõ kàxdjwa kajgomẽo mõ? Myt kunĩkôt ne ba ar Metĩndjwỳnh nhõ kikretikam ikrĩ, ar memã idjujarẽnho ikrĩ ga me kam kam ijo atỹm kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mỳkam ne ga me ijo tỹm? Bir, amrẽbê: ne Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh me bakukãmãremã me ajã ajarẽ. Me aje ijo atỹm'ã ajarẽn arỳm 'ã pi'ôk no'ôk ne. Nhym me arỳm aben djô'ã arẽnho mõ:. Arẽnho mõr tãmtã arỳm iwỳr o bôx. Tũ:mràm me bakamingrãnyrekam arỳm iwỳr o bôx. Ba ar iba: ga me arỳm jakam ã ijo ane. Me kute me bakukãmãremã me ajã ujarẽnh kôt ne ga me arỳm jakam ã ijo atỹmo ane. Nãm ã Jeju me krãptĩmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nhym kam kôt ba djwỳnh kunĩ mã amijã maje prõt ne. ");
INSERT INTO txuNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Me'õ abatành ny ne kute kubẽkà pydjio amikupuja Jeju kôt tẽ. Rinhuo ne kubẽkà. Nhym me kwỳ adjwỳnhdjwỳo tỹm ne kubê kubẽkà 'amỳnh tỳx. ");
INSERT INTO txuNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nhym arỳm amikaban amikôt kubẽkàmã iren tu kajgo mã prõt ne. ");
INSERT INTO txuNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nhym me arỳm Jejuo mõ. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax'ỳr ne me o mõ. Nhym arỳm me rũnh kunĩ abeno akuprõ. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebêngêtmẽ Môjdjê kukràdjà mar djwỳnhmẽ ne me arỳm akuprõ. Nhym me Jejuo mõn o bôx ne arỳm me rũnh kabem kudja. ");
INSERT INTO txuNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nhym be, Pedru ne Jeju kôt tẽ, nĩjar kum kre rax ne tẽ. Nhym me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax nhõ kikre nhipôkri kênh ngrire nhym Pedru arỳm Jejukôt wadjà. Ne arỳm bẽnjadjwỳr nhõ krãkamngônhmẽ ro'ã ànhũnho nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nãm me me'ỳr Jejuo bôx nhym kam me rũnh arỳm me 'êxnhĩ jabej. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebêngêtmẽ me rũnh kunĩ ne me me 'êxnhĩ jabej. Dja me amãnhkrut Jeju'ã 'êx ne memã kum, —Ba ne ba axwe kôt omũ. Nãm ã ane ba omũ, ane. Dja me ane nhym me arỳm me kabẽn man arỳm we axwe'õ pãnh kubĩ. Kadjy ne me me 'êxnhĩ jabej. Ne te abejo dja. Me'õ ar amãnhkrut kute axikôt 'ã kabẽnja ne me te abejo dja:. ");
INSERT INTO txuNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nhym me 'êxnhĩ krãptĩ ne me kàjmã ku'ên arĩk aben kupa'ãbit axwe jarẽnho kumex. ");
INSERT INTO txuNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nhym kam me'õ ar ja arỳm kàjmã djan 'êx ne 'ã kabẽn jarẽn memã kum, ");
INSERT INTO txuNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Tãmwã ne memã kum, “Be, me kute ikrao Metĩndjwỳnh nhõ kikreti nhipêxja dja ba kungrà. Ne kam Metĩndjwỳnh nhõ kikreti 'õdjwỳ nhipêx. Me kute ikrao ipêx kêtja'õ dja ba ipêx. Nhym ije ipêxo idjãm'ã akati amãnhkrut ne ikjêkêtbit apêx ba ipêx pa.” Nãm ã Jeju memã ane bar arỳm kuma, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ne kam ar jadjwỳ kute memã arẽnhkam axikôt Jeju'ã kabẽn jarẽnh kêt ne arĩk aben kupa'ãbit arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nhym kam me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr raxja arỳm kàjmã djan me ipôkri djan Jeju kukijn kum, —Ga, ar kabẽnja ma. Djãm aje aminêje akabẽn'õ jarẽnh prãm kêtkumrẽx? On imã amikôt amijarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nhym tu anhikrê. Nhym me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax ajte kukijn kum, —Djãm abê me babê idjaer nhõ Bẽnjadjwỳrbê kumkati, nẽn? Djãm mrãmri abê Kritu? Djãm abê Metĩndjwỳnh Kra? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nhym Jeju kum, —Kôt ne ga imã arẽ. Ba ar amã arẽ gar ama. Gêdja ba ĩ Metĩndjwỳnh pymati djubôk'ãnh nhỹ. Ba ije amijo inhĩ gêdja ba ubôk'ãnh nhỹ. Ibẽnjadjwỳr raxkam ubôk'ãnh nhỹ gar ipumũ. Ne kam ajte kakrãkôt amrẽ kàjkwa kurũm itẽmkôt ipumũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nhym kam me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax kute memã amingryko amirĩt kadjy arỳm amibê kà kadjô. Amibê kà kadjôn arỳm memã kum, —Ẽ, arỳm ne Metĩndjwỳnh japrỳ. E kum kwãrĩk wãnh gwaj ijukri me'õ kute axwe kôt omũnhja jabej kêt. ");
INSERT INTO txuNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gwaj bakunĩ ne gwaj arỳm kute Metĩndjwỳnh japrỳja ma. Ta ne amijo Metĩndjwỳnh rax pytàn arỳm o aprỳ gwaj kuma. Kute gwaj bamã, “Metĩndjwỳnh djubôk'ãnh inhỹrkôt dja gar ipumũ”, anhỹrkôt ne gwaj arỳm kuma. Arỳm ne gar ama. Mỳj dja gwaj nẽ? ane. Nhym me kupãnhtã 'ã kum, —Gê me on kubĩ. Gê me on kubĩ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nhym kam me kwỳ nokre kutôn rĩtbê nokre'ã pron ajte nokrebê tak ne. Ne kute takmẽ ro'ã kum, —Nhym ne akurwa? Goja me'õ pumũn imã arẽ, ane. Nhym krãkamngônh arỳm 'ã akuprõn tako kumex. ");
INSERT INTO txuNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nhym wãnh Pedru kikreti parbê ànhũnho nhỹ. Ànhũnho nhỹ: nhym me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax nhõ àpênh nija arỳm 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ne omũn prĩne omũnh mex ne kum, —Tukwa, gadjwỳ ne ga Jeju kôt ar aba. Krĩraxbê Nadjarekam Jejukôt ar aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nhym aminêje 'êx ne kum, —Kati, ije akabẽnwã mar kêtkumrẽx, ane. Ne kam tẽn kre tã dja nhym kôt arỳm õkrẽn'ãnh kà. ");
INSERT INTO txuNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nhym bẽnjadjwỳr nhõ àpênh nija ajte omũn bu'ã me ku'êmã kum, —Tãmwãdjwỳ ne kôt ar ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nhym ajte aminêje 'êx ne kum, “Kati”, ane. Nhym kàjbê 'ãtũm nhym bu'ã me ku'êja kum, —Be, mrãmri ne ga kôt ar aba, ane. Abê pykabê Garrêja kra'õ. Garrêjakam me kabẽn kôt akabẽnja ma. Bar kôt aman arỳm amã ikato, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nhym memã kum, —Kati. Mrãmri ije me'õwã pumũnh kêtkumrẽx. Aje me'õ jarẽnhwã ije omũnh kêt, ane. Ne kam me'õ kute kum anhỹr kêtmã amikangrôn memã kum, —Dja ba ijêxnhĩ jabej gê Metĩndjwỳnh pãnh ijo akno. Ta ne arỳm ijêxnhĩ kêtkôt ima, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nãm ane nhym totokbê ajte õkrẽn'ãnh kà. Nhym kam Pedru akubyn amijo tẽn amrẽbê Jeju kute kum kabẽn jarẽnhja ma. Kute kum, —Õkrẽn'ãnh kàr kêtri dja ga amijã maje ajêx pydji nhym arỳm kà. Ga kam amijã maje ajêxo amãnhkrut ne ijã memã kum, “Kati, ije tãmwã pumũnh kêt”, ane nhym ajte kà, anhỹrja ne arỳm kuma. Nãm maro dja nhym arỳm rerekre 'ỳr bôx. Rerekre 'ỳr bôx nhym arỳm mu:w. ");
INSERT INTO txuNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nhym kam me'ã akati, kryràm nhym apỹnh me rũnh djàri akuprõn arỳm aben kabẽn ma. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebêngêtmẽ Môjdjê kukràdjà mar djwỳnhmẽ me rũnh kunĩmẽ ne me Jejuo aben ma. Ne kam arỳm uwpren Piratu'ỳr o mõn 'ỳr o bôx. 'Ỳr o bôx ne kum kanga. ");
INSERT INTO txuNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nhym kam Piratu arỳm kukij ne kum, —Djãm abê mebê idjaer nhõ bẽnjadjwỳr rax? ane. Nhym kum, —Kôt ne ga aje arẽnhwã, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nhym kam me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr ar arĩk Jeju'ã axwe krãptĩ janhô. ");
INSERT INTO txuNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nhym tu anhikrê. Nhym Piratu kum, —Ẽ ama. Djãm ajaxwe krãre ne me amã arẽ? Djãm aje aminêje akabẽn'õ jarẽnh kêtkumrẽx? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nhym kum kabẽn 'õ jarẽnh kêtkumrẽx. Nhym Piratu te kute marmã kam no tyn nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Be, me irôbê mrãnh nhõ akatija tãmkam ne mebê idjaer krãptĩ: arỳm aben pydji. Me kute aben kajmã'ã Metĩndjwỳnh me kukãmãre nhirôbê mrãnh mar kadjy ne me aben pydji. Amex kunĩkôt ne bẽnjadjwỳr raxbê Piratu akati jakam mebê ijê djà kurũm mebê ijê pỹnh ne meo pôx nhym me mã mrã. Me kute me'õ'ã à'wỳrja ne me kĩnh kadjy bõm kumẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ajbir me'õbê ijê ne idjibê Baraba. Me kute kubê ijê kêtri ne me jakôt me bẽnjadjwỳr'ỳr prõt ne me kwỳ pa. Nhym kam me arỳm kubê ijê. ");
INSERT INTO txuNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nãm Piratu Jeju kukjêro dja: nhym kam me krãptĩ: arỳm kàj bê Piratumã me'õbê ijê jarẽ ne kum, —Aje mekbê ijêwã'õ kaba gê arek ar me ikôt ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nhym arỳm Jeju'ã memã kum, —Me abê idjaer, we me anhõ bẽnjadjwỳr rax ne ja djãm ije me amã kum inhirermã? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Be, Piratu kute memã ja jarẽnh kêtri ne arỳm me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr ma. Nãm ar'ã amim, —Jeju'ã me krãptĩkam ne me rũnh 'ã ngryk ne imã kanga, ane. Ne kam bit kute kum irermã ã me krãptĩmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nãm 'ã memã kum, —Djãm ije me anhõ bẽnjadjwỳrmã inhirermã? ane. Nhym me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr ar memã kum, —Kwãrĩk wãnh me amã Jeju kĩnh kêt. Dja ga me kum Baraba jarẽ gê kaba, ane. Nhym me kàtàm krãptĩ Piratumã kum, —Kwãrĩk wãnh Jejumã anhirer kêt. Baraba dja ga kaba, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nhym kam Piratu memã kum, —Be, ga me abê idjaer, aje tãmwãmã anhõ bẽnjadjwỳr rax jarẽnhja mỳj dja ba kam on? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nhym me kàj bê kum, “Pĩte'y'ã anhô”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nhym Piratu memã kum, —Mỳkam? Mỳj ne ajmã o ne ba ije pĩte'y'ã nhôrmã? ane. Nhym me kàj bê kum, —Pĩte'y'ã anhô. Pĩte'y'ã anhô, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nhym kam me kĩnhmã Piratu Baraba kaba nhym arỳm arek ar mekôt ba. Nhym kam Piratu krãkamngônhmã Jeju jarẽ. Me kute kaprêprêk kadjy memã arẽ. Nhym me arỳm mrykà punuo kaprêprê:k ne. Kaprêprêk nhym Piratu arỳm memã kangan memã arẽ. Me kute pĩte'y'ã nhôr kadjy memã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nhym kam me krãkamngônh amũ bẽnjadjwỳr nhõ kikretimã Jejuo mõn o wadjà. Kumoka'ê nhidjibê Pretorimã o mõn o wadjà. Ne kam me krãkamngônh kàtàm kunĩ jadjwỳ o akprõ nhym me kunĩ arỳm 'ã aben pydji. ");
INSERT INTO txuNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Me kute 'ã bẽno bikẽnh kadjy ne me 'ã akuprõ. Ne kam inôkà ryti kamrêkja byn arỳm Jejumã adjà. Ne mrỳnhĩo kajkep ne ikãx ne kum kutu. Nãm me arĩk bẽnjadjwỳr rax krãdjê'ã mrỳnhĩ jakren ikãx ne arỳm kum kutu. ");
INSERT INTO txuNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ne kum kabẽno kute me rũnhmã me kabẽn pyràk ne kum, —Ga we abê mebê idjaer nhõ bẽnjadjwỳr rax, gora kribêm atĩn 'iry, anhỹrkôt ");
INSERT INTO txuNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","po'êo krã môn kutôn parbê kõnkrão krĩ. Nãm me parbê kõnkrão krĩo kute me bẽnjadjwỳr rũnh parbê kõnkrão krĩja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ne kam arỳm 'ã bẽno ajkẽn inomã kumẽn arỳm kubê inôkà ryti kamrêkja kaban akubyn kum õ kubẽkà djwỳnhja jadjà. Ne kam kute pĩte'y'ã nhôrmã o katon o mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nhym me'õbê Ximão tẽ. Pykabê Xireni kra 'õ. Kute Arexãrimẽ Rupu ar ir. Arwã kurũm ne tẽn bit me'ãnh tẽmmã. Nhym me krãkamngônh arỳm Jeju nhõ pĩte'y'ã kum àpnênh tỳx. Kum 'ã àpnênh tỳx nhym arỳm kadjy kumỳn o mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nãm me krãnhrebê Gogota'ỳr Jejuo mõn 'ỳr o bôx. Me bakabẽnkam ne gu me ren krãnhremã me krã'i jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nhym kam me pidjô kangôkam pĩdjỳbê mirao akàn Jejumã kungã nhym arỳm kanga. ");
INSERT INTO txuNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nhym kam me pĩte'y'ã kunhô nhym wajêt. Nhym kam me apỹnh kute õ kubẽkà jamỳnh kadjy kẽn kryre rẽ. Me kute ari kẽn rẽnhkôt ne me amijo kubẽkà pytà. ");
INSERT INTO txuNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Arỳm kàjmã myt nhỹrkam. 9 orakam ne me pĩte'y'ã kunhô. ");
INSERT INTO txuNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ne kam 'ã pi'ôk no'ôk ne. Pi'ôkkam ne me memã kum, —Mebê idjaer nhõ bẽnjadjwỳr rax ne ja, ane. Me kunĩ kute omũnh kadjy ne me Jeju nhimõkri kunhô. Me kute we Jeju jaxwe 'õ pãnh pĩte'y'ã jêtja pumũnh ne kute mar kadjy ne me pi'ôk no'ôk ne imõkri kunhô. ");
INSERT INTO txuNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ne kam ar àkĩnhĩ amãnhkrutja Jeju nhikrebê pĩte'y'ã ar kunhô. Nhym arỳm ar wajêt. Jeju õkredjàkôt wajêt nhym aktã ar axweja ijên wajêt. ");
INSERT INTO txuNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Amrẽbê: ne me bakukãmãre'õ memã ja jarẽn 'ã pi'ôk no'ôk ne. Nãm memã kum, “Dja me 'ã abenmã kum, ‘Nãm me o axwen me axwemẽ ro'ã kubĩ’, anhỹro dja.” Nãm ã pi'ôkkam memã ane. Nhym kam me aben djô'ã arẽ. Arẽnho mõr tãmtã tũ:mràm arỳm 'ỳr o bôx. Me bakukãmãre kute memã arẽnh kôt ne me arỳm ar axwejamẽ ro'ã ar anhôrkumrẽx nhym me arỳm 'ã arẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nhym me 'ãnh mõrja nokà nhàn kum kabẽn punu:re ne kum, —Be, ga: ne ga we aje Metĩndjwỳnh nhõ kikreti ngrành ne akubyn ipêxmã. Nhym aje ipêxo adjãm'ã akati amãnhkrut ne ikjêkêt we aje ipêx parmã. ");
INSERT INTO txuNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Goja amiptàn pĩte'y kurũm rwỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nhym kam me rũnh arĩk 'ã bẽno ajkẽ. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ ne me arĩk 'ã bẽno ajkẽn abenmã kum, —Amũbit ne me utà. Ne kam te kute amiptàr prãmje. ");
INSERT INTO txuNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Goja gê mrãmri kubê Kritukumrẽx jabej goja mrãmri kubê mebê idjaer nhõ Bẽnjadjwỳrbê kumkatikumrẽx jabej on pĩte'y kurũm rwỳ. Gwaj goja kôt omũn arỳm tu amim markumrẽx. Nãm me rũnh ã abenmã ane. Nhym ar aktã pĩte'y'ã jêtjadjwỳ Jejumã àkjêro wajêt. ");
INSERT INTO txuNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nhym arỳm kàjkwa nhipôkri myt nhỹ. Nhym kam tu akamàt kô tyk ne. Pyka kunĩkôt me'ã akamàt kô tyk ne. Nãm me'ã akamàt kô tykkam myt kyn kyn kyn ky: nhym 3 orakam, amykrykambit arỳm ajte myt no pôt ne. Arỳm ajte myt kato. ");
INSERT INTO txuNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kato nhym mebê idjaer kabẽnkam Jeju kàj bê kabẽn ne Bãmmã kum, —Eroi: Eroi: rama xabatani, ane. Nãm ren me bakabẽn kam kum, —Inhõ Metĩndjwỳ:nh, inhõ Metĩndjwỳ:nh, mỳkam ne ga arỳm ikanga? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nhym parbê me ku'êja kabẽn man arĩk abenmã kum, “Ẽ, Erijmã ne kabẽn”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nhym kam me'õ prõt ne ngônh puror põnh djà jakritaja byn pidjô kangô kadjàmã adjà. Nhym kam kangô ipu nhym pĩ nhidjamã adjàn kàjmã kum kungã, kute kaôr kadjy. Nhym me'õ ar kum, —Adjỹm, gê goja me bakukãmãrebê Erij 'ỳr bôx ne goja o rwỳk jabej, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nhym kam Jeju kàj bê kabẽn ne ate ty. ");
INSERT INTO txuNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Be, nhym kam arỳm Metĩndjwỳnh nhõ kikreti kadjwỳnhbê kubẽkàtija ta amikadjô. Nãm nhôr djà'ãnh amikrax ne e y: ne kraxmã amimẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nhym krãkamngônh krãptĩ: kubê 100 nhõ bẽnjadjwỳr pĩte'y parbê dja. Nhym Jeju kàj bê kabẽn ne ty nhym arỳm omũ. Omũn arỳm memã kum, —Be, mrãmri ne me'õ jabê Metĩndjwỳnh Krakumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nhym me niredjwỳ amybỳm omũnho dja. Nhym Marij Madarenamẽ Marij, kurũm Jôdjemẽ Xijagu ar apôxjamẽ Xirôwemẽ ne ar me ikô'ã dja. ");
INSERT INTO txuNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Amrẽbê, Jeju pykabê Garrêjakam ar bari ne ar nireja mã kôt ajkamẽn o djuw mexo ba. Nhym ar ja bu'ã me nire krãptĩdjwỳ amybỳm omũnho dja. Jeju ajbir krĩraxbê Djeruxarẽ'ỳr tẽmkam ne me nireja kôt mõn bôx. ");
INSERT INTO txuNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jeju ty. Ty nhym kam amykry mex ne. Amykry mex nhym me arỳm no katon õ mỳjja kupênho kumex. Pi'ôk ràràr djwỳnhràm õ mỳjja kupênho kumex. ");
INSERT INTO txuNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nhym Jôdje arỳm bôx. Krĩraxbê Armatêkam ne Jôdje abatành djà. Nãm me rũnh bikprõnh djàkam mekôt rax nhym me kum kĩnh. Nãm amiwỳr Metĩndjwỳnh kamnhĩx ne. Metĩndjwỳnh bôx ne me kadjy bẽnjadjwỳr ne kute ar meo bamã ja ne amiwỳr kamnhĩx ne. Jôdje kum Piratu pyma kêt ne 'ỳr tẽn 'ỳr bôx ne Jeju 'ã kuma. ");
INSERT INTO txuNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nhym arỳm kam no tyn nhỹn kum, “Je, djãm arỳm ne ty”? ane. Ne kam amiwỳr krãkamngônh nhõ bẽnjadjwỳr 'uw nhym bôx. Bôx nhym arỳm kukij ne kum, “Djãm arỳm ne ty”? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nhym kum, “Nà”, ane. Nhym kam arỳm Jôdjemã Jeju jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nhym kam rinhuo kubẽkà 'õ byn 'ỳr o tẽ. 'Ỳr o tẽn 'ỳr o bôx. Ne kam arỳm pĩte'y kurũm Jejuo ruw. O ruw ne arỳm kubẽkào kupun kam kẽnkre'ỳr o tẽ. Me kute kẽnkre kakrwỳnhja'ỳr o tẽn kam arỳm kam adjà. Ne kam kẽnpoti ajkwa krekre'ã kudja. ");
INSERT INTO txuNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nhym Marij Madarenamẽ Marij kurũm Jôdje katorja arỳm omũ. ");
INSERT INTO txuNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nhym kam pi'ôk ràràr, me tyk djà kêt djà nhõ akati apêx nhym ar arỳm pi'ôk kaprĩ pãnh me tyk nhõ pĩdjỳ kwỳ by. Marij Madarenamẽ Marij kurũm Xijagu katorjamẽ Xirôwemẽ ne ar kadjy pĩdjỳ kwỳ by. Kẽnkre'ỳr tẽm ne kute o Jeju djymã ne ar kadjy kwỳ by. ");
INSERT INTO txuNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nhym kry:ràm, pi'ôk kamrêkkam, kraxje akati mex kêtkam ar kẽnkre'ỳr tẽ. Tẽ: nhym arỳm myt kato nhym ar arỳm o rãm ne ja. ");
INSERT INTO txuNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","O rãm ne jan arỳm abenmã kum, —Mỳj me'õ dja gwaj bamã jãm ajkwa krekre'ã kẽnpoti dja? ane. Kẽn jabatànhkam ne ar ã abenmã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Abenmã anen kam rĩt ne omũ nhym arỳm amijã kuta. ");
INSERT INTO txuNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nhym kam ar 'ỳr tẽn arỳm kẽnkremã wadjà. Nhym kadjy mrãnh djwỳnh'õ kute me'õ jabatành ny pyràk ne nhỹ. Nãm inôkà jaka ryti jadjàn nõr djà djubôk'ãnh nhỹ. Nhym ar wadjàn arỳm omũ. Ne te umaje. ");
INSERT INTO txuNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nhym arkum, —Kwãrĩk wãnh ikam ar atĩn prãm kêt. Jeju Nadjarekam abatành ja me kute pĩte'y'ã nhôr ne bĩnja ne gar abej tẽ. Jakam arỳm nõr kêt. Nãm akubyn tĩn ne kato. Gar nõr djà kaprỳja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Be, amũ ar tẽn kôt ba djwỳnhmã arẽ. Ne arkôt Pedrumã arẽ. Ne arkum, “Arỳm ne ar akukãm pykabê Garrêja'ỳr tẽmmã. Dja gar kam tẽn arỳm omũ”, ane. Dja gar ã arkum ane. Amrẽbê kute ar amã arẽnh kôt ba arỳm ar amã arẽ. Nãm ã kadjy mrãnh djwỳnh ar niremã ane. ");
INSERT INTO txuNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nhym ar katon mã kẽnkre kurũm prõt ne. Te umaje tertetkam prõt ne. Tĩn prãmkam ne me'õmã kabẽn kêt ne tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Be, akubyn tĩnkam kryràm, pi'ôk kamrêkkam ne Jeju Marij Madarena kumrẽxmã amijo amirĩt ne. Be, me karõ punubê 7 ne Marijo ba nhym Jeju amrẽbê ano nhym kum ire. ");
INSERT INTO txuNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nãm Marijmã amijo amirĩt nhym arỳm kôt ba djwỳnh'ỳr tẽn ar'ỳr bôx. Nhym ar kaprĩ:ren mỳro nhỹ. Nhym arỳm ar'ỳr bôx ne arkum 'ã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nãm arkum Jeju tĩn jarẽn kute omũnh'ã ajarẽ. Nhym ar kuman arỳm abenmã kum, “Nãm 'êx”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nhym kam ajte ar jamã kute amijo amirĩtmã tẽ. Nãm kôt ba djwỳnh amãnhkrut arwãmã tẽ. Tẽ nhym arỳm atemã aminhipêx. Ne kam kute atemã me'õ pyràk ne arkum amijo amirĩt ne arkôt tẽ. ");
INSERT INTO txuNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nhym kam ar akubyn Djeruxarẽ'ỳr tẽ. Kôt ba djwỳnh'ã kàtàmja'ỳr tẽn ar'ỳr bôx ne arkum 'ã ajarẽ. Nhym ar abenmã kum, “Kati, nãm ar 'êx”, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nhym kam ajte Ar kubê 11mã amijo amirĩt. Ar õ kwỳ krẽno nhỹ nhym arkum amijo amirĩt ne arkum bẽn tỳx ne arkum, —Nãm ar akubyn itĩnkôt ipumũn ar amã ijã ajarẽ gar ar'ã abenmã kum, “Nãm ar 'êx”, ane. Tô mỳkam ne gar tu amim imarkumrẽx kêt? Djãm ar ajamakkreja kêt? ane. ");
INSERT INTO txuNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ne kam ajte arkum, —Apỹnh me ba djà kunĩkôt dja gar mõn kàj bê me kunĩmã ijã adjujarẽnh ny jarẽnho mõ. ");
INSERT INTO txuNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dja me tu amim imarkumrẽx nhym me Metĩndjwỳnhmã ngômã me angij. Nhym arỳm me utà. Nhym be, me kute amim imar kêt dja Metĩndjwỳnh arỳm pãnh me kanga. ");
INSERT INTO txuNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nhym me kute tu amim ikamnhĩxkumrẽx dja me mỳjja pumũnh kêt nhipêx. Me kute Metĩndjwỳnh raxmã kator kadjy ipêx. Ne me karõ punu kute meo baja jano nhym me karõ memã ire. Dja me apỹnh me bajtem kabẽnkam kabẽn. ");
INSERT INTO txuNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Godja me kangã djàkrê by. Me kute mar kêtkam kangã djàkrê by nhym arỳm ajmã meo kêt. Nàr, te mỳjja kanêo ikõ nhym ajmã meo kêt. Dja me me kanê krã'ã ikra jadjuw nhym me arỳm à kêt ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bẽnjadjwỳr djwỳnh Jeju memã ane nhym Metĩndjwỳnh arỳm kàjkwamã amiwỳr o wabi. Nhym arỳm ra:x ne Metĩndjwỳnh djubôk'ãnh nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nhym kam kôt ba djwỳnh arỳm amũ mõn pyka kunĩkôt kàj bê memã 'ã ujarẽnh mõ. Nhym Bẽnjadjwỳr djwỳnh mã arkum tỳx jangij nhym ar arỳm mỳjja pumũnh kêt nhipêxo mõ. Me kute ar'ã abenmã kum, —Mrãmri ne djãm ar Metĩndjwỳnh kôt kabẽnkumrẽx? anhỹr kadjy ne ar mỳjja pumũnh kêt nhipêxo mõ.");
INSERT INTO txuNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Aj, Teopire, ba ne ba wãm amã pi'ôk no'ôk ne. Ba ibê Ruka ne ba wãm amã pi'ôk no'ôk ne. Me kunĩ ne me kum akĩnh ne amex jarẽ ba badjwỳ imã akĩnh ne wãm amã pi'ôk no'ôk ne. Me krãptĩ ne me arỳm 'ã pi'ôk no'ôk ne, Jeju me ikam ar ba'ã ne me pi'ôk no'ôk ne. Me kute kraxrũm noo Jeju pumũnh ne memã kabẽn'ã ujarẽnh, me tãm ne me me imã arẽ nhym me amũ me ijuk'ã 'ã pi'ôk no'ôk ne. Ba kam badjwỳ inhõkre kadjwỳnhbê, —Be, mexkumrẽx. Badjwỳ dja ba 'ã pi'ôk no'ôk nhym kam mexkumrẽx, ane. Mrãmri ne ba me'ỳr tẽ, me kute noo Jeju pumũnhja'ỳr tẽ. Me'ỳr tẽn prĩne abej me kukij ne kam Jeju kraxrũm prĩne mỳjja kunĩ maro tẽn inomã kumẽn mar tỳx ne. Mar tỳx ne kam amã 'ã pi'ôk no'ôk ne. Dja ba prĩne mỳjja kraxrũm amã kôt 'ã idjujarẽnh tẽ, aje prĩne marmã. Me kute õbê amã arẽnh ga aje katàt maro atẽmmã ne ba badjwỳ mekôt amã 'ã pi'ôk no'ôko tẽ, aje omũnh ne aje amim, —Mrãmri ne me katàt imã Jeju jarẽ, anhỹr kadjy. Kadjy ne ba amã 'ã pi'ôk no'ôk ne. ");
INSERT INTO txuNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Be, ẽ, ije amã katàt Jeju'ã idjujarẽnh kadjy dja ba amã Djakarij kumrẽx jarẽn kam ijukri amã Jeju jarẽ. Mekbê idjaer nhõ pykabê Djudêjakam me kadjy Metĩndjwỳnh mar djwỳnh 'õ nhidjibê ne Djakarij. Nhym Djakarij nhingêt kukãmã nhidjibê ne Abij. Ne kam prõdjwỳ idjibê Ixabeu, kubê ne Arão tàmdjwỳ 'õ. Nhym bep me õ bẽnjadjwỳr nhidjibê ne Erodji ne memã nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nhym Djakarijmẽ prõ ar amẽ mrãnh katàt nhym Metĩndjwỳnh arkam kĩnhkumrẽx ne. Nãm ar prĩne Metĩndjwỳnh kabẽnkôt amijo ba, Metĩndjwỳnh kute memã me katàt amijo ba'ã karõjakôt amijo ban kute 'õ kudjar kêtkumrẽx. Ãm ar mexkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nhym bep Ixabeu kra kêt ne te kra prãme ar ba, mjênmẽ ro'ã te ar ari kra prãme ba ne arỳm kubêngê:tte. ");
INSERT INTO txuNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Be, me kute me kadjy Metĩndjwỳnh mar ne me Metĩndjwỳnh nhõ kikretikam àpênh tẽ, apỹnh me ingêt me kajmã'ã àpênh'ỳr ngjênh djàri ne me me kudjwa Metĩndjwỳnhmã àpênh tẽ. Nãm me ja kumrẽx mytyrwỳ 'õkam 'ỳr wadjàn kam apê:n kato. Nhym pãnh me ja ajte mytyrwỳ 'õkam 'ỳr wadjàn kam kum apê:n kam kato. Nãm ã meo anhỹro tẽ. Nhym kam mekbê Abij me ja pãnh 'ỳr wadjàn Metĩndjwỳnhmã àpênh ba. Nhym Djakarij, kubê me kadjy Metĩndjwỳnh mar djwỳnhkam mekôt Metĩndjwỳnhmã àpênho ku'ê. Nhym me kute Metĩndjwỳnhmã kikre kudjỳ djà bôr kadjy kẽn mêre à'àk ne kurẽn kôt 'ỳr wangij nhym Djakarij kukràdjà jakôt ate Metĩndjwỳnh nhõ kikretimã wadjà, kute kikre kudjỳ djà bôrmã. Ate ne me kudjwa 'ỳr wadjà ne kum kubô. ");
INSERT INTO txuNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nhym kute kum bôrkôt me kunĩ kikreti kabem Metĩndjwỳnhmã kabẽno ku'ê. ");
INSERT INTO txuNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nhym Djakarij bôro dja nhym aêrbê Metĩndjwỳnh kadjy mrãnh djwỳnh 'õ nokam kato. Nãm tu kikre kudjỳ djà bôr djà jakỳxkôt 'ỳr kato. ");
INSERT INTO txuNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nhym omũn kam umar punuren kum uma ne, kute ajmã o karõ ne kum uma. ");
INSERT INTO txuNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nhym kam kum, —Djakarij, kwãrĩk wãnh atĩn prãm kêt. Arỳm ne Metĩndjwỳnh aje amijo adjà'wỳr ma. Dja on aprõbê Ixabeu tujarô gar amim akra my mỳ. Akra my mỳn kam kum idji Djuão jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Dja gar tu akĩ:nhkumrẽx ne. Nhym me krãptĩ ar akôt kĩnhkumrẽx, ar akra rwỳkkam kĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nhym Metĩndjwỳnh kadjy godja akra rax ne kam kabẽn mexkumrẽx ne. Godja uba kangô djàkrêo kõm kêt, nàr atemã kadjwati kangô 'õo kõm kêt. Nhym Metĩndjwỳnh Karõ raxo akra kadjwỳnhbê nhỹn ar o ba, nã tikkrekam jêt rã'ã dja Metĩndjwỳnh Karõ mrãmri o ba. ");
INSERT INTO txuNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nhym mekbê idjaer krãptĩ dja me õ Bẽnjadjwỳr Metĩndjwỳnh 'ỳr amijo akẽx, akra kabẽnkôt 'ỳr amijo akẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nhym akra dja Bẽnjadjwỳr kukãm tẽ, kute memã bôx djà'ã ujarẽnh nhym me kute kadjy amijo mexmã dja kukãm tẽ. Nhym Metĩndjwỳnh Karõ dja mrãmri o ba nhym uma ne, kute mrãmri ne Metĩndjwỳnh Karõ kute Erijo ba nhym umaja pyràk. Dja akra memã arẽ nhym me nãmẽ me bãm akubyn kum kra jabê. Nhym ate ajte memã arẽ nhym me amakkre kêtja dja me akubyn katàt mrãn arỳm ajte kabẽn mexkumrẽx. Dja akra ã memã ane nhym me arỳm Metĩndjwỳnh kadjy amijo mex. Nãm ã kadjy mrãnh djwỳnh Djakarijmã kabẽn jarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nhym kam kum, —Gêt kon ne. Mỳjkôt dja ba akabẽn ma? Arỳm iprõmẽ ar ibêngêtte. Djãm ar ijabatành ny godja bar ikra mỳ? ");
INSERT INTO txuNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nhym kam kum, —Ba ibê Gabrijeu ne ba Metĩndjwỳnh kabem dja. Ije amã kabẽn jarẽnhmã ne ijano ba awỳr tẽ. Mỳjja mextire ije amã arẽnhmã ne ijano ga ate “Kon ne” ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aje amim ikabẽn mar kêtkumrẽx pãnh gêdja ga akabẽn kêt nhym akra ruw. Dja akra nhõ akati 'ỳr bôx nhym ruw ga kam ijukri akabẽn, ane. Nãm ã Gabrijeu kum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nhym me kam kapôtã te Djakarij kam ama:, te bôx nhym me kute kukràdjà 'õ marmãn kam abenmã kum, —Ije tô mỳj got ar o ba? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nhym kam arỳm katon te kute memã kabẽnmã. Nhym me, —Arỳm ne Metĩndjwỳnh nhõ kikretikam mỳjja 'õ pumũ, ane. Nhym tu ikrao memã ujakreo djan kabẽn kêt mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ne kam ar àpênh ba:n arỳm inomã kumẽn kam katon akubyn ũrkwãmã tẽn bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Bôx nhym kàjbê 'ãtũm nhym kam prõbê Ixabeu tujarôn kam pijàm ne kam kikre bu'ãbit mrã. Kute amirĩt kêt'ã mytyrwỳ amãnhkrut ne amãnhkrut ne ikjêkêt, pijàm djàje, tujarôkam. Nãm, —Ota Bẽnjadjwỳr ipumũn kum ikaprĩn arỳm ijo mex. Jakam dja me ijã kabẽn kêt ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Nhym kam arỳm tujarô'ã mytyrwỳ amãnhkrut ne amãnhkrut ne amãnhkrut nhym Metĩndjwỳnh ajte kadjy mrãnh djwỳnhbê Gabrijeu jano, Marij'ỳr ano. Marij kurererkam ne kra kêtkumrẽx, me'õ 'ỳr mõr kêtkam. Nhym bep me'õbê Jôdje ne kum kabẽn kajgo, kraxje 'ỳr mõr kêt. Nhym bep Jôdje nhingêt ne Dawi. Apỹnh ne me õ pyka nhym bep tu pyka abenã tỹm nhidjibê ne Garrêja. Nhym bep kam krĩ 'õ nhidjibê ne Nadjare. Krĩ jakam ne Metĩndjwỳnh Marij'ỳr Gabrijeu jano. ");
INSERT INTO txuNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nhym arỳm 'ỳr tẽn bôx ne kum, —Marij, djãm ga? Metĩndjwỳnh ne arỳm akam ukaprĩn ajo ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nhym Marij Gabrijeu kabẽn man axwe amikam umar ne õkre kadjwỳnhbê amim, —Mỳj kabẽn got ja? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nhym kam kum, —Kwãrĩk wãnh, Marij, atĩn prãm kêt. Mrãmri ne Metĩndjwỳnh akam kĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ota, dja ga on atujarôn kam akra my mỳn kam kum Jeju jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Godja akra bẽnjadjwỳr rax ne ar meo ba nhym kam me 'ã abenmã kum, “Metĩndjwỳnh pymati kra”, ar o ba. Gêdja Bẽnjadjwỳr Metĩndjwỳnh Jeju'ã bẽnjadjwỳr rax mẽ nhym kam ar meo ba. Ingêtbê Dawi bẽnjadjwỳr rax djô'ã dja rax ne ar meo ba. ");
INSERT INTO txuNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tãm godja tũmràm mekbê idjaer kadjy bẽnjadjwỳr ne ar meo ba. Dja bẽnjadjwỳr rã'ã rã'ãn ar meo ban o ino rer kêtkumrẽx, ane. Nãm ã kadjy mrãnh djwỳnh kum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nhym kam kum, —Godjãm me'õ iwỳr mõr kêtjakam ba ije ikra mỳnhmã. Mỳj godja imã ikra dji? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nhym kam kum, —Metĩndjwỳnh Karõ dja awỳr ruw. Metĩndjwỳnh pymati Karõ dja awỳr ruw. Djãm tãwãbê mỳjja tỳx? Ta gêdja tu amã akra jadjà nhym akurũm kato. Ne kam prĩrerũm mrãmri mexo tuknĩn mexkumrẽx. Kam axwe 'õ kêtkumrẽx. Nhym me kam kum Metĩndjwỳnh Kra jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ota anhõbikwa Ixabeu te kubêngêtte ne arỳm tujarô. Me kute Ixabeumã kra kêt jarẽnh ar o baja ne arỳm tujarô. Adjwỳnhdjwỳ ne kra my wajêt nhym arỳm jêt'ã mytyrwỳ amãnhkrut ne amãnhkrut ne amãnhkrut. ");
INSERT INTO txuNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Djãm Metĩndjwỳnhbê mỳjja 'õ bipdjur got? ane. Nãm ã kadjy mrãnh djwỳnh kum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nhym kam kum, —Ã, mrãmri. Ibê Metĩndjwỳnh nhõ àpênh tũm. Gora gê akabẽnkôt ã ijo ane, ane. Marij ã kum ane nhym arỳm mã kurũm tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Nhym kam Marij no kator mex ne mã Ixabeu'ỳr tẽ, kute omũnhmã 'ỳr tẽ. Pykabê Djudêjakam krĩ 'õ'ỳr tẽ. Kam ne krãnh kumex. Nhym tẽn bôx ne Djakarijmẽ Ixabeu ar ũrkwãmã wadjàn kam Ixabeumã kabẽn. ");
INSERT INTO txuNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kum kabẽn nhym Ixabeu kute kabẽn marmẽ ro'ã kraja Marij kabẽn man kam kĩnh ne kàjmã amijã te. Nã tikkrekam kàjmã amijã te. Nhym kam Metĩndjwỳnh Karõ raxo Ixabeu kadjwỳnhbê nhỹn ar o ba ");
INSERT INTO txuNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","nhym kàj bê kabẽn ne kum, —Metĩndjwỳnh ne arỳm ajo kĩnh, me nire kunĩ kuràm ajo kĩnh ne. Ne atikkrekam akra jêtjadjwỳ o kĩnhkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Xô kum djãm ibẽnjadjwỳr rax ne Metĩndjwỳnh kute ijo kĩnhmã iwỳr inhõ Bẽnjadjwỳr nã jano? ane. Arỳm ne inhõ Bẽnjadjwỳr nã iwỳr bôx ba arỳm ikĩnhkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ẽ, ga imã akabẽn, ba akabẽn ma nhym kam ikra kĩnhkumrẽx. Itikkrekam jêtja kĩnhkumrẽx ne kam kàjmã amijã te, ba kam amã ikabẽn jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ô kwep akĩnhkumrẽx. Bẽnjadjwỳr ne arỳm amã kabẽn ga tu amijã akra kamnhĩxkumrẽx ne amim, “Mrãmri, Metĩndjwỳnh kabẽnkôt dja ikra rwỳkkumrẽx”, ane. Kam ne ga akĩnhkumrẽx ne. Nãm ã Ixabeu Marijmã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Nhym kam Marij kutã kum kabẽn ne kàjmã Metĩndjwỳnhmã rax jarẽnho dja, ne, —Dja ba mã Bẽnjadjwỳrbê Metĩndjwỳnhmã rax jarẽn kôt kum amikĩnh jarẽ. Metĩndjwỳnhbê ipytàr djwỳnhkam ne ba ikĩnh raxkumrẽx, ikadjwỳnhbê ikĩnh ne kam kum amijarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Metĩndjwỳnh ta ne kum ikaprĩn ijo amiptàn kam imã kĩnh jadjà. Djãm adjàkam irax tũm? Xô kum kati, ingrire. Ãm ibê õ àpênh kajgokumrẽx. Ingrire nhym kam tu Bẽnjadjwỳr ijo amiptàn kam imã ikĩnh rax jadjà. Jakam dja kamingrãny amũ aben nhijuk'ã abenmã ikĩnh jarẽnho tẽ, ikĩnh rax jarẽnho tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ga prĩne kute ijo kĩnhja pumũ. Djãm Metĩndjwỳnh rerek got? Axwe tỳx. Ga kute mỳjja pumũnh kêt imã o amirĩtja pumũ. O ne imã ikĩnh jadjà. Mrãmri ne tãwã mexkumrẽx. Nãm mexo uma. ");
INSERT INTO txuNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ne mekam ukaprĩkumrẽx. Me kute Metĩndjwỳnh kabẽn mar ne kôt kute ar amijo baja mekam ne ukaprĩ. Nhym kamingrãny amũ me banhijuk'ã amũ maro tẽ nhym Metĩndjwỳnh me kamdjwỳ ukaprĩ, me banhijuk'ã me kamdjwỳ ukaprĩ tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bep me kute amijo àmraja, me kute õkre kadjwỳnhbê, “Ba ne ba ibẽnjadjwỳr rax, ba ne ba irax”, anhỹrja, memã ne arỳm amimao pôx ne kàjbê me kumẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ne me bẽnjadjwỳr rũnh memã ỹrja me tãm ne tu arỳm meo kàtàm ne, ne kam pãnh me kute amijo kàtàmja, me kute amijo àmra kêtjao bẽnjadjwỳr rũnh ne. ");
INSERT INTO txuNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ne kam ajte me õ mỳjja kêt, me kum prãmja ne mỳjja mextireo memã ajne ne o me kĩnho ba. Ne kam pãnh me õ pi'ôk kaprĩ rũnh, me õ djwỳ krãptĩja arỳm meo ajkẽn aminêje me ano nhym me ỹkam ar ba. ");
INSERT INTO txuNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Metĩndjwỳnh kute amrẽbê me bakukãmãremã katàt arẽnhkôt ne arỳm me baman kum me bakaprĩ. Ne me babê idjaer, me babê õ àpênhja ne kum me bakaprĩn me bawỳr ruw ne amikôt me bajo mõn me bajo djuw mex ne ar me bajo ba. ");
INSERT INTO txuNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Amrẽbê ne me banhingêt Abraãomã kabẽn ne kum kaprĩ, me bakajmã'ã kum kaprĩ ne kam kôpdji'ã me baman kum me bakaprĩ. Dja kum me bakaprĩ rã'ã rã'ã ne. Nãm ã Marij kum kabẽno ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ne kam Ixabeu kuri dja: nhym kam 'ã mytyrwỳ amãnhkrut ne ikjêkêt nhym arỳm mã tẽ, mã õ pykamã tẽn bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nhym kam Ixabeu kra rwỳk djà nhõ akati arỳm 'ỳr bôx nhym kam kra my ruw. ");
INSERT INTO txuNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nhym kam õbikwa kuman arỳm kĩnhkumrẽx. Nhym atãri ar ũrkwãkam me jadjwỳ kuman kam kôt kĩnhkumrẽx. Metĩndjwỳnh kam ukaprĩ raxkôt kuman kam kudjwa kĩnhkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Nhym kam arỳm kra rwỳk'ã pi'ôk kamrêk pydji nhym me kute my nhinhu kà krã'yrmã bit kute kum Djakarij jarẽnhmã, bit kute kum bãm nhidji jarẽnhmã nhym nã memã kum, —Xô kum kati, idjibê ne Djuão, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","62","Nhym me kam kum, —Je tô mỳkam? Nhỹnh ne anhõbikwa 'õ ã idji ane? anen kam bãm'ỳr akẽx ne kum ikrao ajakre. Idji jabej kukjêr kadjy ne me bãmmã ikrao ajakre. —Mã ne aje kum idji jarẽnhja kute? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nhym kam bãmja kute memã idji no'ôk kadjy mỳjja'ã me ku'uw nhym kam me kum o tẽ nhym kam memã idji no'ôk ne, —Idjibê ne Djuão. Nhym me omũn kam ari aben pumũn abenmã kum, —Je tô mỳkam? Mỳj got ja? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nhym Djakarij kute idji no'ôkmẽ ro'ã arỳm ajte kabẽn ne kam Metĩndjwỳnhmã mextire jarẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nhym kam ar õ krôkam me ja tĩn prãm ne kam abenmã arẽnho ipôk ne. Pykabê Djudêjakam apỹnh krãnhrekam me õ krĩkam ne me abenmã arẽnho ipôk ne. ");
INSERT INTO txuNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nhym me kam kuma:n ar o ba, Metĩndjwỳnh kute ar krao bakam ne me mar ar o ban kam abenmã kum, —Mã gêdja abatành ne kute? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nhym kam Metĩndjwỳnh Karõ raxo bãmbê Djakarij kadjwỳnhbê nhỹn ar o ba nhym amũ Metĩndjwỳnh djô'ã kabẽn jarẽnho dja ne Jeju kumrẽx'ã ajarẽ. Jejubê bẽnjadjwỳr rax ne kubê mekbê idjaer pytàr djwỳnh'ã ajarẽ. Ne kam ijukri Djuão jarẽ. Nhym bep Jeju kumrẽx ne 'ã ajarẽ ne memã kum, ");
INSERT INTO txuNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—E kum me babê idjaer nhõ Bẽnjadjwỳr mexkumrẽx. Ba gop me amã me banhõ Bẽnjadjwỳr, me banhõ Metĩndjwỳnh mextire jarẽ. Mỳkam? Bir, nãm ta õ me ba djwỳnh'ỳr ruw, kute me bapytàrmã ne me bawỳr ruw. ");
INSERT INTO txuNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kute umao ar me bapytàr ne me bajo ba kadjy ne arỳm me bamã me bapytàr djwỳnh jano. Ingêt kukãmãre ne Dawi, õ àpênh tũmja. Ingêt kukãmãrebê Dawi jabatành djàkam ne me bakadjy nõ. Abatành ne kute umao me bapytàr ne ar me bajo ba kadjy arỳm ingêt jabatành djàkam nõ. ");
INSERT INTO txuNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Me kute Metĩndjwỳnh kabẽn jarẽnh djwỳnh kabẽn kôtô. Amrẽbê ne Metĩndjwỳnh kute kabẽn jarẽnh djwỳnh mexkumrẽx jamã kabẽn jarẽnh kôt ne arỳm me bamã ano. ");
INSERT INTO txuNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kute me bakurê djwỳnhbê me bapytàrmã, me kum me bakurê ne kute me bajo bajabê me bapytàrmã ne Metĩndjwỳnh me bawỳr ano. ");
INSERT INTO txuNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nãm me bakukãmãremã kabẽn pydjin arẽn memã kum, “Dja ba imã me akaprĩ”, ane. Dja ba amikabẽn mexja mã kuman o ibiknor kêt, ane ne kam kôt me bawỳr ano. ");
INSERT INTO txuNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nãm ã me bakukãmãrebê Abraãomã kabẽn pydjin arẽnho anen kam katàt kôt kuma. ");
INSERT INTO txuNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kute me bakurê djwỳnhbê me bapytàr, gu me badjumar mex ne arek ar baban kum badjàpênhmã. ");
INSERT INTO txuNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Me bamextire ne katàt bamrãnh ne kum badjàpênhmã. Me batĩnri Metĩndjwỳnh kabem kribêm ar me babao rãm ne mũ jamã ne kum arẽ. Nãm ã Abraãomã kabẽn jarẽnho anen kam katàt kôt kuman me bawỳr me bapytàr djwỳnh jano, Bẽnjadjwỳr jano, ane. Nãm ã Djakarij memã Jeju jarẽnho anen kam ajte kramã kabẽn jarẽ, krabê Djuãomã 'ã karõ, Djuão Jeju kukãm tẽmmã 'ã kum karõ ne kum, ");
INSERT INTO txuNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","—Bep ga, akmere, ga dja ga Bẽnjadjwỳr kukãm tẽn kutêp me akre gê me kuman Bẽnjadjwỳr kam amakbê katàt amijo ba. Kute mrãmri ne me kute me bẽnjadjwỳrmã katàt pry djirja pyràk. Gêdja me ajã, “Metĩndjwỳnh Pymati kabẽn jarẽnh djwỳnh ne ja”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nà, ga dja ga kukãm tẽn memã arẽ. Ta kute õ me ja pytàr ne ar meo bamã memã arẽ. Mã ne me bapytàr o? Apỹnh me bajaxwe djàri kute tu o bingrành ne me bakam ngryk kêtmã. Kute ã ukaprĩkôt me bapytàro anhỹrmã. ");
INSERT INTO txuNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mrãmri ne me Batĩn djwỳnh kum me bakaprĩ rax ne. Ne kam kàjkwa kurũm me bapytàr djwỳnh me bawỳr ano. Kute me bamã irã djà pyràk. Kute mrãmri ne myt kute me bamã irãn kute me bakurwỳja pyràk ne me bawỳr ano. ");
INSERT INTO txuNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Me kum tyk pyma, me tĩn prãmja ne me kute mrãmri ne me akamàt kô tykkam me krĩja pyràk. Nhym bep me bapytàr djwỳnh dja me jamã tĩn prãmo ajngrà. Ga akati kute akamàt kô nhipônhja pumũ. Dja ã me bamã me batĩn prãm, me bamã batyk pyma ã o bingrànho ane gu me kam badjumar mexkumrẽx ne ar baba. Tãm ne ja. Nãm ã Djakarij kramã 'ã karõo ane, Jeju kukãm tẽm ne kute kutêp me akremã. ");
INSERT INTO txuNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nhym kam kra arỳm kàjmã krã tẽn kam Metĩndjwỳnh kabẽnkôt amijo ba. Kute kôt amijo ba rã'ãn abatành. Ne kam kapôt kukritkam ar ba. Õ akati kutêp ne kapôt kukritkam ar ba. Kute mekbê idjaermã amijo amirĩt nhõ akati amiwỳr kam amakbê kapôt kukritkam ar ba. ");
INSERT INTO txuNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nhym kam bẽnjadjwỳr raxbê Xedja Agujtu memã kabẽn jarẽ. Xedja Agujtu ne me kunĩmã nhỹ. Nãm memã kabẽn jarẽn memã kum, —Me akunĩ, pyka kunĩkôt dja ga me anhingêt nhõ pyka'ỳr aba gê me me anhidji'ã pi'ôk no'ôk, ba ije me ajã akre kadjy, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Me kute me idji'ã pi'ôk no'ôko kutewa kadjy ne ja. Nhym Xirênhu, bẽnjadjwỳr bajtem, pykabê Xirijkam memã nhỹ. Kam ne me kute bẽnjadjwỳr raxbê Xedja Agujtu kabẽnkôt me idji'ã no'ôkmã. ");
INSERT INTO txuNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nhym kam me kunĩ apỹnh krĩ djàri'ỳr ajmà. Apỹnh me ingêt nhõ pykakam abatành djàri'ỳr ajmàn kam bôx. Bôx nhym me kam me idji'ã pi'ôk no'ôko tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Nhym kam Jôdjemẽ Marij ar adjwỳnhdjwỳ me kudjwa ingêt nhõ pyka'ỳr tẽ, ingêtbê Dawi rwỳk djà'ỳr ne ar tẽ. Arỳm ne kum kabẽn ne. Kraxje 'ỳr mõr kêt rã'ã. Nãm kum kabẽn kajgo. Tu pyka abenã mẽnh nhidjibê ne Garrêja ne kam apỹnh ne krĩ djàri idji. Garrêjakam krĩ nhidjibê ne Nadjare. Kurũm ne ar tẽ. Marij arỳm tujarô tỳx nhym ar tẽ. Atemã ajte pyka 'õ tu abenã tỹm nhidjibê ne Djudêja. 'Ỳr ne ar wabi ne kam tẽ:n kam krĩbê Berẽ'ỳr bôx. Ingêtbê Dawi rwỳk djàmã tẽn bôx, õ pyka nhidjibê Berẽmã tẽn bôx, me kute ar idji'ã pi'ôk no'ôkmã. ");
INSERT INTO txuNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Nhym kam me kumex ne prĩne Ar kubê kikre kre jaê. Nhym kam kra rwỳk djà nhõ akati arỳm 'ỳr bôx nhym kra my ruw. Kra kutewa ne ruw. Nhym Marij kubẽkào kupun o tẽn mryti djàkur djàkam kudji, me kute prĩne Ar kubê kikre kre jaêrkam. ");
INSERT INTO txuNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nhym krĩ nokà'ã ne mry nhõ kapôt. Nhym arỳm akamàt. Nhym kam mry nhõ kapôtkam ar kute mry pumũnh djwỳnhja õ krit pumũnho dja. ");
INSERT INTO txuNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nhym kam Metĩndjwỳnh kadjy mrãnh djwỳnh ar nokrekam kato nhym Metĩndjwỳnh jadjênh prĩne ar kurwỳ ne arkum ipôk ne. Nhym arkum uma ne kam madjà tertet ne. ");
INSERT INTO txuNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nhym kam kadjy mrãnh djwỳnh arkum, —Kwãrĩk wãnh, ar amã uma kêt. Ota ba ije ar amã mỳjja mex jarẽnhmã tẽ. Ẽ, me akĩnh djà ne arỳm me akadjy kato. Me akunĩ akĩnh kadjy, akĩnh raxmã. ");
INSERT INTO txuNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ẽ, akamàt ja tãmkam ne me apytàr djwỳnh arỳm me akadjy ruw. Dawi nhõ pykakam ne ruw. Kubê ne Kritu, kubê ne Bẽnjadjwỳr djwỳnh. ");
INSERT INTO txuNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tãm ne ajbir rwỳk nhym nã kute kubẽkào kupun mryti djàkur djàkam irwã. Kute kubẽkào kupun mryti djàkur djàkam irkôt dja gar kum akaton kam omũ, ane. Nãm ã Metĩndjwỳnh kadjy mrãnh djwỳnh arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nhym kam ar aêrbê kàjkwa kurũm Metĩndjwỳnh me ano, amikadjy mrãnh djwỳnh jano nhym katon kumex, kumrẽx kator jakôt ne me katon kumex ne kam Metĩndjwỳnhmã mextire jarẽnho kumex ne mry pumũnh djwỳnhmã o amra, ");
INSERT INTO txuNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Kàjkwakam ne Metĩndjwỳnh me:xkumrẽx, tỳ:xkumrẽx, uma:kumrẽx. Gora gê me kunĩ kàjmã kum mex jarẽnho tẽ. Arỳm ne pykakam me wãmã umar mex jarẽ. Gora gê õ me wãkam kĩnhwã umar mex ne ar ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nãm ã Metĩndjwỳnh kadjy mrãnh djwỳnh anen kam mã ar kurũm kàjkwamã wabi. Nhym kam ate mry pumũnh djwỳnh abenmã kum, —Gêtô gwaj gop Berẽmã mõn goja karàkôt omũ. Bẽnjadjwỳr djwỳnh kute gwaj bamã arẽnhja pumũ, anen kam 'ỳr prõt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Prõt ne Marijmẽ Jôdje ar'ỳr kato nhym mryti djàkur djàkam nõ, ngrire ne nõ nhym ar omũ. ");
INSERT INTO txuNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nõrkôt omũn kam memã arẽnho ajkate. Kadjy mrãnh djwỳnh kute mry pumũnh djwỳnhmã arẽnhja, kute Marij kra jarẽnhja ne me memã arẽnho ajkate. ");
INSERT INTO txuNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nhym me kuman kam abenkam no tyn kumex ne abenmã kum, —Mỳj gotja? Mỳkam got Metĩndjwỳnh kadjy mrãnh djwỳnhja katon kumex? anen ari aben pumũnho akẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nhym bep ãm Marij ta kute kraxkôt mar ne amikam mỳjja kunĩ ma:ro tẽn 'õo biknor kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Be, nhym kam mry pumũnh djwỳnh kapôtmã akẽx. Kadjy mrãnh djwỳnh kute arkum arẽnhkôt ne ar karà nõrkôt omũ. Kônh ne arkum kudji nhym ar mỳjja kunĩ pumũn kuman kam Metĩndjwỳnhmã mex jarẽnho mõ. Ne kàjmã kum rax jarẽnho mõn kum, —Metĩndjwỳnh, gajbit ne ga apydjin adjukaprĩ, amex, arax, atỳx, anhỹro mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nhym kam arỳm 'ã akati amãnhkrut ne amãnhkrut ne amãnhkrut ne amãnhkrut nhym ar my nhinhu kà krãtan kam ajte kum idji Jeju jarẽ. Tikkrekam jêt kêtri Metĩndjwỳnh kadjy mrãnh djwỳnh kute kum idji jarẽnhja ne kum arẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Nhym kam akati krãptĩ nhym ar krĩraxbê Djeruxarẽ'ỳr o tẽ. Ar kute Bẽnjadjwỳr djwỳnhbê Metĩndjwỳnhmã armã ne ar o tẽ. Metĩndjwỳnh kabẽn'ã pi'ôk no'ôkkam ne memã, “Me akra my kutewa gêdja axidjuw ga me Bẽnjadjwỳr djwỳnhmã me umjuw, kute o aminhõmã”, ane. Kôt ne ar kute Djeruxarẽmã Jejuo tẽm ne kum armã. Ar adjwỳnhdjwỳ kute Metĩndjwỳnhmã mry bôrmã. Arỳm ne Marij kamrô ngràn kam kute Môjdjê kukràdjàkôt Metĩndjwỳnhmã mry djàr ne kum õrmã. Amrẽbê ne Môjdjê Metĩndjwỳnh kabẽn'ã pi'ôk no'ôk ne memã kum, “Ẽ, dja ga me akamrô ngràn kam Bẽnjadjwỳr djwỳnhmã tutte amẽ agan kum angã, nàr tutti no tỳr nyre amẽ abĩn kum aga”, ane. Jakôt ne ar kute kum àr ne õr nhym nãja akubyn Metĩndjwỳnhmã mex ne õ kikretimã àrmã Djeruxarẽmã o tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nhym bep Djeruxarẽkam me'õ mybê Ximião. Mrãnh katàt ne Metĩndjwỳnh kabẽnkôt ar amijo ba. Nãm arek mekbê idjaer pytàr djwỳnh, memã kaprĩ rênh djwỳnh, Kritukam ama. Nhym Metĩndjwỳnh Karõ ar o ba. ");
INSERT INTO txuNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ar o ban kam arỳm kum, —Ẽ, atĩn rã'ã dja ga Metĩndjwỳnh kute anorja'ỳr bôx ne omũ. Kute me apytàrmã ne ano, kubê ne Kritu, tãm dja ga omũ, anhỹtã 'ỳr bôx ne anoo omũ, ane. Nãm ã Metĩndjwỳnh Karõ Ximiãomã ane nhym kuman ar o ba. ");
INSERT INTO txuNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ne kam Metĩndjwỳnh nhõ kikreti'ỳr tẽ. Metĩndjwỳnh Karõ ne ano nhym tẽ. Kumrẽx ne ar kukãm tẽn bôx. Nhym Jeju nãmẽ bãm arkôt 'ỳr o bôx. Ar kute me amikukràdjà tũmkôt Metĩndjwỳnhmã armã ne ar 'ỳr o tẽn o wadjà. ");
INSERT INTO txuNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nhym Ximião omũn kumỳn kam Metĩndjwỳnhmã mextire jarẽn kum amikĩnh jarẽn kum, ");
INSERT INTO txuNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Bẽnjadjwỳr djwỳnh, jakam dja ga on imã ityk nhõ akati jarẽ, ba ibê anhõ àpênh dja ba wãm awỳr tẽ, aje imã arẽnhkôt. Arỳm ne ba omũn arỳm ikĩnhkumrẽx ne arỳm idjumar mexkumrẽx ne. Jakam dja ba idjumar mexbê ty, aje imã arẽnhkôt. ");
INSERT INTO txuNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ga ga arỳm me utàr djwỳnh jano ba inoo omũ. ");
INSERT INTO txuNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Anhỹr djwỳnhràm aje arẽnhja ne ga arỳm memã o akato nhym me kunĩ pyka kunĩkôt omũ. ");
INSERT INTO txuNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Me utàr djwỳnhja ne kute a'u pyràk. Dja apỹnh me bajtemja no bô nhym me katàt mrã. Nhym kam ajte me ibê idjaermãdjwỳ kĩnh jadjà. Kôt dja me me imã me ikĩnh jarẽ, me irax jarẽ, ane. Nãm ã Ximião Jeju'ã ujarẽnh ane. ");
INSERT INTO txuNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nhym kam bãmmẽ nã ar kuman kam abenkam no tyn aben pumũnho dja. ");
INSERT INTO txuNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nhym kam Ximião jãm aro akẽx ne Metĩndjwỳnhmã aro a'uw ne kum, —Dja ga aro kĩnh ne adjukaprĩkôt aro djuw mex ne arkum umar mex jarẽ gê ar umar mex ne ar ba, ane. Ne kam ajte jãm nãjao akẽx ne kum, —Ota arỳm akra kute meo bikjêrmã bôx. Me babê idjaer kwỳ dja me kum kurên kam kôt amijo ajkẽ. Dja te kute memã Metĩndjwỳnho amirĩtmã nhym me mã aprỳ. Nhym bep me bakwỳ dja gu me mã bamã abên kam amiptàn kôt ar amijo baba. ");
INSERT INTO txuNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nhym akra ta dja ar mekmã apôx ba. Godja me õkre kadjwỳnhbê amim mỳjja'ã karõ nhym akra ta tu ar memã apôx ba. Ga gadjwỳ akra djô'ã akaprĩ rax ne akra ma: ne. Kute mrãmri ne nànhre kute gadjwỳ anhõpôkkam akaprĩ pyràk, ane. Nãm ã Ximião anhỹr djwỳnhràm kum arẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Nhym kam me'õ nibê Ana adjwỳnhdjwỳ ar'ỳr bôx. Kubê Metĩndjwỳnh kabẽn jarẽnh djwỳnh 'õ, Panuwe kra, mekbê Axer 'õ. Nãm 'uwtĩ. Amrẽbê ne mjên 'ỳr mõ nhym 'ã amex amãnhkrut ne amãnhkrut ne amãnhkrut ne ikjêkêt nhym arỳm kubê ty. Nhym kam 'uwtĩn arỳm kubêngê:xte. Arỳm 'ã amexbê 84. Nãm Metĩndjwỳnh nhõ kikretikam ku'ên kator kêtkumrẽx ne tu Metĩndjwỳnhmã àpênho dja. Akamàtmẽ akati kunĩkôt ne kum kabẽno ku'ên kadjy amijajbu. ");
INSERT INTO txuNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ne kam kum ajmã ar'ỳr bôx ne Jeju pumũn kam Metĩndjwỳnhmã amikĩnh jarẽn kum ukaprĩ jarẽ ne kam ajte me kute kam amakjamã Jeju jarẽ. Me utàr djwỳnh bôx ne kute me kurê djwỳnhbê akubyn me õ krĩraxbê Djeruxarẽ pytàrmã ne me kam ama. Memã ne Ana, —Arỳm ne bôx. Arỳm ne me bapytàr djwỳnh bôx, ane. Nãm ã Ana me kute kam amakjamã arẽnho anen kam ajte mã wadjà. ");
INSERT INTO txuNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nhym kam Marijmẽ Jôdje ar Bẽnjadjwỳr djwỳnh kukràdjà kunĩkôt arỳm mỳjjao tẽn inomã kumẽn kam akubyn pykabê Garrêja'ỳr tẽn kam ar õ krĩbê Nadjarekam bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nhym kam kra kàjmã krã tẽn kam ĩ tỳx tẽ. Tẽn tẽn ĩ arỳm abatành ne kam no mexkumrẽx nhym kam Metĩndjwỳnh kam kĩnhkumrẽx ne mã o djuw mex. ");
INSERT INTO txuNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nhym na mê gaga mrãnh kunĩkôt Jeju nãmẽ bãm ar Djeruxarẽmã mrã. Me kute aben pydjin kute Metĩndjwỳnh me irôbê mrãnh nhõ akati mar ne õ kwỳ krẽn rax kadjy ne ar 'ỳr mrã. ");
INSERT INTO txuNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","43","Nhym ajbir Jeju nõrny. Arỳm 'ã amexbê 12. Nhym ar kunĩ mekôt ajte me kute aben pydji'ỳr wabin me'ỳr bôx ne mekôt ar õ kwỳ krẽn ba, Jejumẽ. Nhym me kam o ino re nhym nãmẽ bãm ar akubyn õ krĩmã tẽ. Tẽn kam pry konenh te abej aprã. Nhym be nãm nõrnyja, arek Djeruxarẽkam ar ba nhym nãmẽ bãm ar kute mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nãm kute atemã me'õ arkôt mã tẽm pyràk. Nhym 'ã akati pydji nhym ar te õbikwakam abej aprã. ");
INSERT INTO txuNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ne kam kute Djeruxarẽkam ajte abejmã akubyn tẽ. Tẽn bôx ne kam te: ajte abej nhym 'ã akamàt. ");
INSERT INTO txuNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nhym akati kêt nhym ar te ajte abej. Nhym kam akati nhym kam ar Metĩndjwỳnh nhõ kikretikam kum kato. Nhym me ipôkri nhỹ, Môjdjê kukràdjà jarẽnh djwỳnh nhipôkri nhỹ, me kabẽn maro nhỹn kam me kukjêro nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nhym me Jejukam no tyn nhỹ. Nãm tu me aêrbê prĩne mỳjja ma. Nhym me jadjwỳ mỳjja jabej kukjêro nhỹ nhym no mexkôt katàt memã mỳjja jarẽnho nhỹ. Kam ne me kam no tyn nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nhym nãmẽ bãm ar mekôt omũn kam mekôt kam no tyn dja. Nhym nã kum, —Akmere, mỳkam ne ga ar ibê ã anhỹr aba? Nã bãm abãmmẽ ar te ajabej aprãn axwe akam idjumar ne kam ajabej ar mrã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nhym kam kum, —Mỳkam ne gar ijabej ar mrã? Djãm ar aje imarja kêt? Arỳm ne ba Ibãm nhũrkwão inhũrkwãn kam idjàpênhmã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nhym ar kute kabẽnja mar kêtkumrẽx. Ne te kute marmãn kam õkre kadjwỳnhbê, —Mỳj kabẽn got ja? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nhym kam arkôt tẽ, arkôt Nadjarekam tẽn bôx ne kam ar kabẽnkôt ar amijo ba. Nhym bep nãja ne mỳjja kunĩ man kum kĩnh ne. ");
INSERT INTO txuNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nhym bep Jeju ta adjàkamã no mex tũm ne amũ no mexo amikamẽnho tẽn kam ĩ abatành mex ne. Nhym Metĩndjwỳnh kam kĩnhkumrẽx. Nhym mebêngôkredjwỳ kam kĩnhkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Nhym bep Djuão kapôt kukritkam ar ba. Djuão, Djakarij kraja ne kapôt kukritkam ar ba. Nhym kam Metĩndjwỳnh kum kabẽn ne. Be, nhym bep bẽnjadjwỳr raxbê Xiberu Xedja. Me bẽnjadjwỳr kunĩ kuràm rax ne me kunĩmã nhỹ. Ne kam amidjô'ã me kwỳ'ã bẽnjadjwỳr rẽ. Nãm pykabê Djudêjakam me ja kadjy Põxu Piratu'ã bẽnjadjwỳr mẽ, kubajtem. Ne kam ajte pykabê Garrêjakam me ja kadjy Erodji'ã bẽnjadjwỳr mẽ. Ne kam ajte pykabê Iturejmẽ Tarakônikam me ja kadjy Piripi'ã bẽnjadjwỳr mẽ. Erodji kamybê Piripi'ã bẽnjadjwỳr mẽ. Ne kam ajte pykabê Abirẽnkam me ja kadjy Rixanij'ã bẽnjadjwỳr mẽ. Nhym ar kute me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr raxbê Ananhmẽ Kajbajmẽ ar ar meo ba. Nhym arỳm Xiberu Xedja memã ỹr'ã amexbê 15 nhym ô'ã ar bẽnjadjwỳr nyreja arỳm memã krĩ. Nhym kam Metĩndjwỳnh Djuãomã kabẽn ne. Djuão kapôt kukritkam ar bajamã kabẽn ne. ");
INSERT INTO txuNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nhym kam kabẽnkôt ngôbê Djodãokam ar mrã. Ne kam ar me akreo ba. Me akreo ban memã kum, —On me amim akaton wãnh ajaxwemã anhiren Metĩndjwỳnh'ỳr amijo akẽx gê me ajaxweo aknon me akam ngryk kêt. Ba kam on ngônhmã me ajangjê, me aje ajaxwemã anhirerkôt me kute me amar kadjy, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Amrẽbê ne anhỹr djwỳnhràm Metĩndjwỳnh kabẽn jarẽnh djwỳnhbê Idjaij ne 'ã pi'ôk no'ôk ne memã kum, “Me'õ dja kapôt kukritkam memã kabẽn ne. Kàj bê dja me akren memã kum, ‘Me apa. Ẽ, me on Bẽnjadjwỳr djwỳnh kutêp wãnh ajaxwemã anhiren katàt amijo aba. Kute mrãmri ne me kute me bẽnjadjwỳr rũnh kutêp pryo mex ne kute memã katàt pry jadjwỳrja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nãm me inuw kunĩo amrà ne kam krãnhre rũnhmẽ kryremẽ, kunĩ abenãnh imõk rê nhym pyka aben pyràk ne ikwã. Nhym pry nhirô nhym me katàt adjuw. Ne pyka karôtdjwỳ prĩne katen o aben pyràk nhym mêkumrẽx ne ikwãja pyràk. Dja me ã Bẽnjadjwỳr djwỳnhràm axwemã irer ne katàt amijo bao ane. ");
INSERT INTO txuNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nhym me kunĩ dja me Metĩndjwỳnh kute me utàrkôt me omũ’, ane.” Nãm ã anhỹr djwỳnhràm Idjaij memã arẽnho ane. Kôt ne Djuão Bẽnjadjwỳr kukãm katon me akre ar o ba, nhym me kwỳ rax ne me mrãmri axwemã iren katàt amijo ba. ");
INSERT INTO txuNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nãm Djuão me akre ar o ba nhym me itepato 'ỳr bao ku'ê. Kute ngônhmã me angjênhmã ne me 'ỳr bao ku'ê. Nhym kam memã kum, —Me akamingrãny ne ga me abê iry. Me ajaxwekam abê kangã. Mỳj me'õ ne me amã Metĩndjwỳnh ngryk nhõ akati jarẽ ga me umaje iwỳr aprõt kajgo? ");
INSERT INTO txuNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gop on me katàt Metĩndjwỳnhkôt amijo aba gê me mrãmri me amex jabej me amã kato. Mrãmri me amim akator ne aje wãnh ajaxwemã anhirer ne aje Metĩndjwỳnh'ỳr amijo akẽx jabej gê me on me amã kato. Gê me me amexmã katon me akam kĩnho kute mrãmri ne me kute pidjô djô mexmã apôx ne kam kĩnhja pyràk. Kwãrĩk wãnh me anhõkre kadjwỳnhbê anhingêt kukãmãre Abraãoo adjàmra kêt ne amim, “Me ba ne ba me ibê Abraão tàmdjwỳ. Dja Metĩndjwỳnh me ikam ngryk kêt. Dja ba me te ijaxwe nhym kam me inhingêt kukãmãre Abraãokôt Metĩndjwỳnh kum me ijabê ne me ijaxwekam me ijo bikẽnh kêtkumrẽx”, anhỹr kêt. Kwãrĩk wãnh ga me ã anhỹr ar aba kêt. Kati. Ẽ, ba me amã arẽ. Dja ga me te abê Abraão tàmdjwỳ nhym Metĩndjwỳnh tu me ajo ajkẽ, me ajaxwe pãnh tu me ajo ajkẽ. Ne ren kum ajte Abraão tàmdjwỳ prãm jabej ren tu kẽnjao itun o amim Abraão tàmdjwỳ nhipêx nhym me ren tu katon kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ẽ, mrãmri arỳm 'ỳr. Metĩndjwỳnh kute me axwe pãnh memã akati jarẽnh arỳm 'ỳr. Kute mrãmri ne pidjô apỹnh abenkam ô kêt nhym me kute kàr ne o mrãnh ne kute kuwykam rẽnhja pyràk. Arỳm ne Metĩndjwỳnh me ajã pidjô djô kêt jakren arỳm me ajaxwe pãnh kute me ajo bikẽnh 'ỳr. Dja me ajo mõn kuwykam me amẽ. Arỳm 'ỳr. Kute mrãmri ne me'õ kute pidjômã 'yr kadjy kute parbê kàxkrãkô mỳnh ne o ãm pyràk, ane. Nãm ã Djuão me krãptĩmã arẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nhym me kam kum, —Ije tô mã dja ba me nẽ? ane. Metĩndjwỳnh kute me ijo bikẽnh kêt kadjy, mã dja ba me nẽ? ");
INSERT INTO txuNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nhym memã kum, —Dja ga me ajõ nhõ kubẽkà amãnhkrut ne kam me'õ nhõ kubẽkà kêtmã ikjê ngã. Nhym me'õdjwỳ õ kwỳ krẽn djà krãptĩn kam me'õ nhõ djwỳ kêtmã amikutã kwỳ ngã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nhym me kute bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnh me kudjwa Djuão'ỳr bôx, kute ngônhmã me angjênhmã. 'Ỳr bôx ne kum, —Bẽnjadjwỳr, mã gêdja ba me nẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nhym kam memã kum, —Ẽ, me anhõ bẽnjadjwỳr kute me amã pi'ôk kaprĩ jarẽnhja 'ãnhbit dja ga me kum o atom. Kwãrĩk wãnh ga me ga amũ amim pi'ôk kaprĩ kamẽnh ne amỳnh kêt. Dja ga me tu 'ãnh jamỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nhym me krãkamngônhredjwỳ kum, —Ne me badjwỳ, mã dja ba me nẽ? ane. Nhym kam memã kum, —Ẽ, kwãrĩk wãnh ga me me pa 'amỳnh ne mekbê mỳjjao aprõt kêt. Ne kwãrĩk wãnh ga me me kàtàm'ã axwe rẽnh ne me axweo me utàr ne mekbê ijên me õ mỳjjao aprõt kêt. Nhym bep ga adjàpênh pãnh dja ga pi'ôk kaprĩ byn tu akĩnh ne. Kwãrĩk wãnh ga me adjàkrê kêt, ane. Nãm ã Djuão memã kabẽn jarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nhym me kunĩ Bẽnjadjwỳrbê kumkati jabej ajkam aman kam õkre kadjwỳnhbê amim, —Bep birãm tãm ne ja. Birãm Djuão got Metĩndjwỳnh me bawỳr ano, me bakadjy Bẽnjadjwỳrbê kumkatimã me bawỳr ano, ane. Birãm Kritu ne ja, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nhym kam Djuão me kunĩmã kum, —Mrãmri ba ne ba ngônhmãbit me ajangij. Nhym bep itotokbê me'õ bôxja. Me'õ tãm ne raxo kute ijakrenh, kute ijakrenh mexi. Bãm te irax ne 'ã inhibôn ije kum parkà 'ãpre bônh ne o itẽm prãme. Bep ãm ren irax ne ba ren arỳm kum apê. Nhym bep kati, ãm ingrire. Nãm raxo ijakrenh mex ne. Tãm ne arỳm bôx 'ỳr. Djãm ngônhmã kute me ajangjênhmã? Kati. Tãm dja bôx ne kam me awỳr Metĩndjwỳnh Karõ jano, me katàt amrãnhbit'ỳr dja ano, kute ar me ajo bamã. Ne kam me ajaxweja kute kuwymã me arẽnhmã. ");
INSERT INTO txuNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Gêdja bôx ne kam kute mrãmri ne me kute kôtyk byr ne o kute bàygogore ka'uk ne kute kam mũm 'y mexjao atom ne kam kute 'ykàjao tẽm ne kute kuwykam ỹr nhym xêtja pyràk. Dja me'õja bôx ne ã me axweo anen kuwykam me kurẽ. Nhym kuwyja dja pôk rã'ã: rã'ãn apêx kêtkumrẽx. Nhym bep bàygogo 'y mex'ã ne me mexja jakren mũm meo atom ne. Ne kàjkwakam õ pykamã meo mõ gê me kam kam kĩnhkumrẽx ne ar ba. Arỳm kute ã meo anhỹr 'ỳr. ");
INSERT INTO txuNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nãm ã Djuão memã ane. Ne kam arek memã kabẽn jarẽnho tẽ. Nãm atemã kukràdjà krãptĩo me akre. Ne mã kabẽn nyo, kabẽn mexo ar me akreo ba. ");
INSERT INTO txuNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Nhym bep bẽnjadjwỳrbê Erodji ne axwekumrẽx. Nãm axwe aben nhiby kumexo mõ, aben nhiby adjwỳro mõn kam ajte Djuão mekbê ijê djàkam iby kumẽ. Nãm kamybê upãnh'ỳr mõ, upãnhbê Erodjij'ỳr mõ. Nhym kam Djuão arỳm kum kabẽn jarẽn kum, —Kati, kwãrĩk wãnh, ane. Nhym kam Erodji tu amakkre kêt ne Djuãobê ijê. ");
INSERT INTO txuNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Anhỹr djwỳnhràm me kute kubê ijê kêtri ne Djuão ngônhmã me kunĩ jangij ne kam ajte Jeju ngônhmã adjà. Ngônhmã adjà nhym kam Bãmmã kabẽno dja. Kum kabẽno ãm rã'ã nhym kàjkwa abenbê ajkij. Abenbê ajkij nhym Metĩndjwỳnh Karõ 'ỳr ruw ne 'ã tỹm. Amijo tut ne 'ỳr ruw ne 'ã tỹm. Nhym kàjkwa kurũm kabẽn ne kum, —Mrãmri abê ikrakumrẽx. Imã ajabê. Ba akam ikĩnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Nhym kam Jeju arỳm ta àpênhmã o krax ne. Arỳm 'ã amexbê 30 ne kum o krax ne. Nhym me we Jôdjeo Jeju bãm. ");
INSERT INTO txuNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Arỳm Djuão kute ngônhmã Jeju jadjàr nhym Metĩndjwỳnh Karõ kute amijo tut ne rwỳk ne 'ã tỹm nhym Bãm kute kum kabẽnja kurũm Jeju tẽ. Ngôbê Djodão kurũm ne arỳm Jeju tẽ. Nhym Metĩndjwỳnh Karõ raxo kadjwỳnhbê nhỹn ar o ban kam kapôt kukrit'ỳr o bôx nhym kam kam ar ba. Nhym kam Xatanaj 'ỳr bôx ne te kum mỳjja'ã apnê. Kute kabẽnkôt amijo ba jabej kum mỳjja'ã àpnênh tẽ. Te kum mỳjja'ã àpnênh'ã akatibê 40. Akati krãptĩ. Kute ã kum anhỹrkam kute mỳjja krẽn kêtkumrẽx. Nhym kam akati apêx nhym prãm prĩne kubĩ. ");
INSERT INTO txuNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nhym kam Xatanaj kum, —Ẽ, goja abê Metĩndjwỳnh krakumrẽx jabej goja kẽnjamã akabẽn gê goja kubê djwỳ ga krẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nhym kam kum, —Kati, Metĩndjwỳnh kabẽn'ã pi'ôk no'ôkkam ne, “Djãm djwỳobit ne me kute amitỳx ne ar tĩn ne ba? Kati, Metĩndjwỳnh kabẽno djwỳ dja me amitỳx ne tĩn ne ba”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nhym kam Xatanaj krãnh nhimõk'ỳr Jejuo tẽn o bôx ne kum pyka kunĩkôt me akreo dja. Apỹnh bẽnjadjwỳr kute meo ba djàri kum me kunĩ jakreo dja. Nãm tebê kum krĩ jakre, kukrà kêt mex ne tebê kum akre. Ne ajte kum bàmẽ kapôtmẽ krĩ rũnhmẽ mỳjja kunĩ jakre nhym omũ nhym kum, ");
INSERT INTO txuNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","—Ẽ, ba inhõ. Amã dja ba ja kunĩ kanga. Pyka kunĩkôt apỹnh me ba djàri dja ba amã me kunĩ ngã ga me ja kunĩ kadjy abẽnjadjwỳr rax. Djãm mỳjja kakrit, djãm mỳjja punu got. Mỳjja mexjakam. Mỳjja krãptĩ, mỳjja pyma. Ba inhõ. Djãm me'õ nhõ? Ba inhõ dja ba imã me'õ kĩnhkôt amidjô'ã kum kungã nàr amã kungã. ");
INSERT INTO txuNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Dja ga amijo angrin ikuka kônh akõnkrão nhỹn imã irax jarẽ ba arỳm amã kunĩ kanga ga arỳm amũ idjô'ã o aminhõn ar o aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nhym kam Jeju kum, —Kati, Metĩndjwỳnh kute pi'ôk no'ôkkam ne, “Bẽnjadjwỳr djwỳnh, Atĩndjwỳnhmãbit dja ga amijo angrin kum rax jarẽn ajbitmã apê. Kwãrĩk wãnh atemã me'õmã rax jarẽnh kêt”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nhym kam Djeruxarẽmã Jejuo tẽn Metĩndjwỳnh nhõ kikreti nhimõk'ỳr o wabin anhà'ã kudjan kum, —Ẽ, goja abê Metĩndjwỳnh krakumrẽx jabej goja rũm tẽn ato. ");
INSERT INTO txuNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nãm we Metĩndjwỳnh kute pi'ôk no'ôkkam amã, “Dja ba ikadjy mrãnh djwỳnhmã ajarẽ gê anêje mỳjja punu kajpa”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ne ajte we Metĩndjwỳnh kute pi'ôk no'ôkkam we, “Dja ba ajã ikadjy mrãnh djwỳnhmã karõ. Dja me atẽmkôt amã ikra dja gê kẽn 'õ apar ngãnh kêtkumrẽx”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nhym kam Jeju amipãnh kum, —Kati, Metĩndjwỳnh kabẽn'ã pi'ôk no'ôkkam ne, “Kwãrĩk wãnh, Bẽnjadjwỳr Atĩndjwỳnh kabi kêt, kute ajãno ãm jabej kabi kêt”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nhym kam Xatanaj arỳm mỳjja'ã kum àpnênh pa. Nãm te kute Metĩndjwỳnh kabẽn kangan Xatanaj kabẽnkôt kute ar amijo bamã 'ã kum àpnênho dja. Apỹnh mỳjja djàri kunĩ'ã te kum àpnênho djan 'ã kum àpnênh pan kam mã kurũm tẽ. Ajte akati 'õ kadjy mã kurũm tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nhym kam Jeju akubyn pykabê Garrêja'ỳr tẽ. Metĩndjwỳnh Karõ arỳm kum tỳx jadjà, Metĩndjwỳnhmã àpênh mex kadjy kum tỳx jadjà nhym tỳxkumrẽx ne kam akubyn tẽn bôx. Nhym kam me abenmã Jeju jarẽnho ajkate, pyka kunĩkôt ne me abenmã arẽnho ajkate. ");
INSERT INTO txuNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nhym Jeju apỹnh mekbê idjaer bikprõnh djàkam ar memã Metĩndjwỳnh kukràdjà'ã ujarẽnh ba. Memã 'ã ujarẽnh ba nhym me kunĩ abenmã Jeju mex jarẽnho ipôk ne. ");
INSERT INTO txuNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nhym bep krĩraxbê Nadjarekam ne me atemã kabẽn. Nhym kam Jeju Nadjarekam bôx, abatành djà'ỳr tẽn bôx nhym arỳm pi'ôk ràràr. Pi'ôk ràràr kunĩkôt ne Jeju mekôt mekbê idjaer bikprõnh djà'ỳr mrãn wangijn krĩ. Ne kam arỳm kàjmã dja. Kute Metĩndjwỳnh kabẽn'ã pi'ôk no'ôk jarẽnhmã kàjmã dja. ");
INSERT INTO txuNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nhym me kum kungã nhym kubyn o ajkij. Metĩndjwỳnh kabẽn jarẽnh djwỳnhbê Idjaij kute pi'ôk no'ôkjao ajkijn kam kadjy amijã no'ôkjamã kato. Kum katon kam memã arẽnho djan memã kum, ");
INSERT INTO txuNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Metĩndjwỳnh Karõ ne mã ijo ba. Arỳm ne amijo ipytà, ije me õ mỳjja kêtmã kabẽn mex, kabẽn ny kàj bê arẽnh nhym me kĩnhmã. Kadjy ne ar ijo ba. Ne kam ajte mekbê ijê kadjy ijano. Ije kàj bê memã kum, ‘On me akato. Me kute me abê ijêja on me akato’, anhỹrmã ne ijano ba tẽ. Ne ajte ije kàj bê me no rãmã kum, ‘On me arĩt mex’, anhỹrmã. Kadjy ne ijano ba tẽ. Ne ajte ije kàj bê me 'uwtĩmẽ me kute meo bikẽnh nhym me kaprĩn mrãnhmã kum, ‘On me akĩnh ne adjumar mex ne ar aba. Jakam dja me me ajo bikẽnh kêt’, anhỹrmã ne ijano ba tẽ. Ne ajte ije kàj bê memã kum, ‘Ẽ, amex jakam dja on Bẽnjadjwỳr mekam ukaprĩ kato’, anhỹrmã ne ijano ba tẽ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nãm ã Jeju memã pi'ôk no'ôkkôt amijarẽnho ãmo anen pi'ôk abenã kudjin akubyn kute pi'ôko atom djwỳnhmã kungãn kam nhỹ. Nhym kam me kunĩ Jejukam no tyn kumex, me bikprõnh djàkam ne me Jejukam no tyn kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nhym kam ajte ujarẽnhmo krax ne memã kum, —Amrẽbê Metĩndjwỳnh kute kabẽn'ã pi'ôk no'ôk ja ne arỳm kato. Mrãmri ne kônh kum kudji nhym ajbir jakam kato. Me aje maro anhỹrjakam ne arỳm kato, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nhym me kam abenmã Jeju mex jarẽnho kumex kajgo ne abenmã, —Je kum bep mexkumrẽx. Ga kabẽn mexja pumũ, Jôdje kra ne ajmãn me bajaêrbê kabẽn mexkumrẽx jarẽ. Jôdje kra, me baje Jôdje pumũnh tũmja tãm ne kra dji nhym kabẽn mexkumrẽx jarẽnho tẽ, ane. Nãm me ã kabẽn jarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nhym kam Jeju memã kum, —Birãm me aje imã me banhingêxê kabẽn tũm jarẽnhmã ne ga me anhõkre kadjwỳnhbê imã arẽnho nhỹ, ba arỳm kuma. Birãm me aje imã, “Goja abê me kane djwỳnh jabej on amikanen amex”, anhỹrmã. Goja aje mỳjja 'õ pumũnh jabej nàr aje mỳjja 'õ mar jabej goja on ipêx, ba me ikunĩ omũ, me inokam ipêx ba me ikunĩ omũ. Rĩnakambit, krĩbê Kapanakambit ne ga ar mỳjja nhipêxo aba. Nhym 'ã ujarẽnh me iwỳr bôx ba me kuma. Goja on jakam, anhõ pyka djwỳnhkam mỳjja pumũnh kêt 'õ nhipêx ba me omũ. Birãm me aje ã imã anhỹrmã ne ga me anhõkre kadjwỳnhbê amim ijã karõ. ");
INSERT INTO txuNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ẽ, ba me amã mỳjja jarẽ. Mrãmri ikabẽn. Ẽ, got ren Metĩndjwỳnh kabẽn jarẽnh djwỳnh atemã pyka 'õkam tẽ nhym me ren arỳm kabẽn ma. Nhym bep kati, õ pyka djwỳnhkam me kute kukràdjàkôt omũnh ne kute kabẽn mar kêt. Ãm me kute kukràdjàkôt mar kêt ne me tu ate krã. Me ga, me banhõ krôkam me ga ne ga me ã ijo anen tu ãm imar kêtkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Ẽ, gora me ikabẽn ma. Mrãmri ikabẽn. Me Metĩndjwỳnh kabẽn jarẽnh djwỳnhbê Erij ja ma. Amrẽbê ne me'ã na kêtkumrẽx. Arỳm na kêt'ã amex amãnhkrut ne ikjêkêt apêx nhym na rwỳk kêtkumrẽx ne. Nhym ajte na tỹmkam ajte na kêt ne. Nhym me prãmkam ar ba. Pyka kunĩkôt djwỳ kêtkumrẽx. Nhym prãm me imex ne. Nhym mekbê idjaer nhõ pykakam axwe me nire 'uwtĩ krãptĩ. Djãm me'ỳr ne Metĩndjwỳnh Erij jano, me kute o djuw mexmã? Arkati, me bajtem, mekbê idjaer kêt'ỳr ne ano. Mekbê idjaer kêt nire 'uwtĩ'õ'ỳr ne ano. Pyka typydji nhidjibê ne Xidõ. Nhym bep krĩ nhidjibê ne Xarepta. 'Ỳr ne ano. Nhym me'õ ni bajtemja o djuw mex ar o ba. ");
INSERT INTO txuNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ajte Metĩndjwỳnh kabẽn jarẽnh djwỳnh 'õbê Eridjêu ja ma. Mekbê idjaer nhõ pykakam axwe me krãptĩ ĩ kajêkam tê. Nhym bep Eridjêu kute me jao mex kêtkumrẽx. Kubajtem, kubê idjaer kêt pydji ne o mex. Pykabê Xirij kurũm me'õbê Namãbit ne o mex ne, ane. Nãm ã Jeju memã arẽnho ane. Djãm ta õ pykakambit ne mekbê idjaerkam kute me ajbitmã mỳjja pumũnh kêt 'õ nhipêxmã? Kati, ta dja ukabikôt amũ pyka mũjakam mỳjja kwỳ 'yro mõ. Nàr kon ta kute amimarkôt õ pyka djwỳnhkam mỳjja pumũnh kêt 'õ nhipêx. Ne ta ukaprĩkôt amũ me mũ jakamdjwỳ mỳjja kwỳ nhipêx. ");
INSERT INTO txuNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nhym me kuman kam kam ngryk ne. Me bikprõnh djàkam me ja kunĩ ne me Jejukam ngry:k ne. ");
INSERT INTO txuNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","30","Ne kam pa 'amỳn bõm kumẽ. Nãm meo mõn krãnhre nhimõk'ỳr o wabi. Krãnhre konenh ne krĩbê Nadjare. Kam ne me Jeju pa 'amỳn krãnh nhimõk'ỳr o mõn o bôx. Ne bit kute amũ aparmã mẽnh nhym tỹm ne tykmã o mõ nhym kam mekbê amikaban kam me õêxo tẽn katon mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mã tẽn kam krĩraxbê Kapanakam bôx. Pykabê Garrêjakam krĩraxbê Kapanakam bôx. Bôx ne memã Metĩndjwỳnh kukràdjà'ã ujarẽnho dja. Pi'ôk ràràrkam ne memã 'ã ujarẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nhym me kabẽn man kam ari ar aben pumũn kam abenmã kum, —Tô mỳj kabẽn ny got ja? Kabẽn mexkumrẽx. Nãm ã me bẽnjadjwỳr rũnh kwỳ kabẽn mex anen ar prĩne kabẽno meo atomo ba, ane. Nãm Jeju prĩne kute amimar kôt katà:t memã amikukràdjà jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ne me bikprõnh djàkam memã 'ã ujarẽnho ãm rã'ã nhym kam me'õ my kum akij. Me karõ punu'õ ne ar o ba nhym kum akij. ");
INSERT INTO txuNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Me karõ punu'õ kute me'õ my ar o baja tãm ne akij. Djãm me'õ bêngôkre ne kum akij? Kati, e kum me'õ kadjwỳnhbê, me'õ bêngôkre kadjwỳnhbê, me karõ punu'õ ne Jejumã akij. Kubêngôkre ja ta àkjêr kêt. Ãm me karõ'õ ne kum akij ne kam kute kubêngôkre mãn kute kum àkjêr pyràk. Ne kum, —Ã, tô mã ne ga aje me ijomã? Ẽ, Jeju, Nadjare kra'õ, djãm aje me iparmã ne ga bôx. Arỳm ne ba me prĩne apumũ, ga ne Metĩndjwỳnh arỳm amim adja, ga kam amexo apyma, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nhym kam kum bẽn tỳx ne kum, —On anhikrên akato, ane. Nhym me karõ punu ikôta. Me ipôkri ikôtan kurũm kato. Kute kubêngôkre ajmã o kêtkumrẽx. Me karõ punu kute me'õo baja kator kutã ajmã o kêtkumrẽx. Nãm ikô'yr kajgon kam mã kurũm katon tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nhym me kunĩ ari aben pumũn abenmã kum, —Mỳj kabẽn gotja? Mã got on? Nãm tu kabẽno, umao bõm me karõ punu mẽ nhym mã tẽ. Djãm rerek got. Me bakàtàm'õ baje ã mỳjja ja'õo anhỹr kêtkumrẽx. Pydji ne tu kabẽno bõm me karõ punu mẽ nhym mã tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ne kam abenmã Jeju jarẽnho kumex. Bu'ã pykakam me ja ne me abenmã arẽnho kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nhym kam Jeju me bikprõnh djà kurũm tẽn kam Ximão nhũrkwãmã wadjà. Nhym Ximão djupãnhdjwỳja kanên nõ. Kanê kubĩ nhym nõ. Nhym me kum arẽ, kute o mexmã. ");
INSERT INTO txuNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nhym 'ỳr tẽn irãn kanêmã bẽn tỳx nhym arỳm kum ire. Nhym arỳm à kêt ne kàjmã dja. Kàjmã djan kam aro djuw mex ar o ba. ");
INSERT INTO txuNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nhym arỳm para. Nhym me Jeju'ỳr bao dja. Me kunĩ ne me 'ỳr õbikwa kanêo bao dja. Apỹnh me õbikwa kanê djàri ne me Jeju'ỳr meo ban meo bôx. Nhym me pỹnhkôt me'ã ikra jadjuw nhym me kunĩ arỳm mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nhym me karõ punudjwỳ me krãptĩ kurũm apôx ne Jejumã kum, —Abê Metĩndjwỳnh kra, anhỹro ba. Nhym kam tu memã bẽn tỳx ne memã kum, —On me anhikrên mã amũ mõ, ane. Nhym me karõ punu tu anhikrên mã mõ. Me karõ punu kute Jeju pumũnh. Kute Metĩndjwỳnh kute amim Jeju Bẽnjadjwỳrbê kumkati kadjy ar ne anorkôt omũnh. Kute Jejubê Kritu kôt omũnh. Kam ne me karõ punu bit kute irãri memã Jeju jarẽnhmã nhym kubê aptàn ano. ");
INSERT INTO txuNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nhym akati kêt nhym krĩ kurũm arwãmã tẽn kam ar ba. Nhym me abej mõ. Abej mõn 'ỳr kato. 'Ỳr katon bit kute kubê àptàrmã, arek mekam ãmmã ne me bit kute kubê àptàrmã ");
INSERT INTO txuNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","nhym memã kum, —Ẽ, djãm me amãbit ne ba Metĩndjwỳnh'ã idjujarẽnh tẽ? Kati, ije krĩ kunĩkôt kàj bê memã arẽnhmã ne ba me'ỳr tẽ. Kadjy ne Metĩndjwỳnh ijano ba tẽ. Ije memã amijã idjujarẽnh ny jarẽnhmã. Metĩndjwỳnh me kadjy Bẽnjadjwỳr ne kute ar meo bamã ja ne ba ije krĩ kunĩkôt memã arẽnhmã. Kadjy ne ijano ba me'ỳr tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Anen kam mã memã Metĩndjwỳnh'ã ujarẽnh mõ. Apỹnh krĩ djàri ne kàj bê memã 'ã ujarẽnh mõ. Ne kam ajte amũ tẽn krĩ 'õkam bôx ne me bikprõnh djàkam ajte memã Metĩndjwỳnh kukràdjà'ã ujarẽnho dja. Nãm ã pykabê Djudêjakam memã 'ã ujarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ne akati 'õkam memã arẽnho dja, memã Metĩndjwỳnh kabẽn jarẽnho dja. Imôti nhidjibê Gênexare mỳrri ne memã arẽnho dja. Nhym kam me 'ã akuprõn maro kumex. Nhym me kwỳ nĩnh mrãn te kute marmãn kam jãm 'ã me kamẽ. Me kamẽn te kute marmãn kam 'ã aben nhingãnho kumex ne Jejudjwỳ nhingãnho mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nhym kam me umaje kàmã wadjà. Nãm ar kute tep pynênh djwỳnhja kà dji. Kà djin kam katon kam kryre põnho dja. Nhym amẽ kà nõ. ");
INSERT INTO txuNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nhym kam ikjêjamã wadjàn kam õ kà djwỳnhjamã kum, Ximãomã kum, —Amũ kamẽ, amũ kamẽnh ngrire, ane. Nhym kam amũ kamẽ. Kamẽnh ngrire nhym kam kam nhỹn memã Metĩndjwỳnh'ã ujarẽnho nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ne memã 'ã ujarẽnh pan kam Ximãomã kum, —Ẽ, gop amũ ubỳmwã'ỳr kà kamẽn kam mãn kryre mẽn kam tep kwỳ pynê, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nhym Ximão kum, —Je kum bẽnjadjwỳr, nã bãm ar te ari ar kryre rẽnho iba ri nhym akati. Ãm tep kêt. Ba gop tu akabẽnkôt kumẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nhym kam ar kumẽn kam tu kam tep kwỳ pynê:nhkumrẽx. Nhym arỳm tep kute kryre rênh 'ỳr. ");
INSERT INTO txuNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nhym kam ar te o no katon kà nhikjêjamã ikra bẽno dja, ar kute 'ỳr kào tẽmmã. Nhym ar 'ỳr kào tẽ nhym kam ar aprakamã kàkam tepo ipu. Nhym kam arỳm amẽ àr 'ỳr. ");
INSERT INTO txuNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Nhym kam Ximão Pedrumẽ ar ja ari aben pumũ. Ar kute amijaêrbê tep kwỳ pynê:nhkam ne ar abenkam no tyn ku'ê. Nhym Ximãomẽ ar ro'ã kute tep pynênh ar o baja kubê Xijagumẽ Djuão, Djebedêu kute ar irja, ar jadjwỳ ne ar abenkam no tyn ku'ê. Nhym Ximão Pedru mỳjja kunĩ pumũn kam umaje Jeju kabem kõnkrão nhỹn kum, —Bẽnjadjwỳr, on mã ikurũm tẽ. Ga ne ga mrãmri amexkumrẽx. Nhym bep ãm ba, ba ne ba ijaxwe, ane. Nhym kam kum, —Kwãrĩk wãnh amã ipyma kêt ne atĩn prãm kêt. Jakam gêdja ga on mebêngôkrebito atom ne memã ijarẽ gê me amim iman amim ikamnhĩx. Jakam dja ga tep pynênh kêt ne kam mebêngôkrebito akprõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nhym ar kam kà djin wabin kam mỳjja kunĩmã iren kam mrãmri Jeju'ãbit ngrà: ne. 'Ã ngrà tỳx ne mã kôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nhym kam akati 'õkam Jeju tẽn krĩ 'õkam bôx. Nhym me'õ ĩ kajêkam têja prĩne kào ajkẽ, prĩne o tuknĩ. Nhym Jeju'ỳr bôx ne omũn kam pijàm djàje tẽn tu mỳrbê tỹm. Ne kam nõrkam kum amijarẽnho nõn kum, —Bẽnjadjwỳr, aje inhĩ kajêkam itê markôt, aje ijo mex prãm jabej, ijo mex, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nhym kam 'ỳr ikra mõn kupên kam kum, —Ije, ije ajo mex prãmã. On akà mex, ane. Nhym gêt ajmã kà nẽn kà mex ne. Kute o ãm tãmkam tebê kà mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nhym kum, —Kwãrĩk wãnh ga memã amijarẽnh kêt. Dja ga tu katàt mã me kadjy Metĩndjwỳnh mar djwỳnh'ỳr tẽn kum amibẽ, kum amikà bẽ. Ne kam kum mry ngã gê akadjy Môjdjê kukràdjàkôt Metĩndjwỳnhmã mry gan kungã. Arỳm akà mexkam dja ga kum mrywã ngã gê me kunĩ apumũ, arỳm akà mexkôt apumũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aje, jakam ne me arỳm abenmã Jeju jarẽnho ajkate:n apỹnh abenmã arẽnho ba. Nhym kam me itepato 'ỳr mõn 'ã akuprõ. Me kute kabẽn mar nhym kute me kanêo mexmã ne me 'ã akuprõ. ");
INSERT INTO txuNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nhym bep ta ne mã arwãmã tẽn kam Metĩndjwỳnhmã kabẽno dja, kum amijarẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nhym kam ajte akati 'õkam Jeju memã Metĩndjwỳnh'ã ujarẽnho dja. Nhym me arek maro nhỹ. Mekbê pardjêumẽ me kute Môjdjê kukràdjà jarẽnh djwỳnhmẽ ne me arek maro nhỹ. Mỳj pyka kurũm? Pykabê Garrêjamẽ pykabê Djudêja kunĩkam apỹnh krĩ djàri ne me kurũm kwỳ bôx. Nhym Djeruxarẽ kurũmdjwỳ me kwỳ bôx. Nhym Metĩndjwỳnh prĩne Jejuo tỳx, kute tỳxo meo mexmã. ");
INSERT INTO txuNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Me'õ jakryja arek nõr djàkam nõr rã'ã nhym õbikwa 'ỳr o mõn o bôx ne te kute kikremã o àrmã. Te kute Jeju'ỳr o bikamẽnh ne kute parbê ir nhym kute o mexmã. Nhym me kikre jajkwa krekre pytàr mex ne. Nhym kam ar tu ibej o wabi. O wabin kikre nhimõkkôt 'ã ngy tỳx katen jãm ngybôr jadjuwn kam me'õ jakry nõr djàkam nõr rã'ã o ruw nhym me ipôkri Jeju parbê nõ. ");
INSERT INTO txuNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nhym Jeju amim ar omũ. Ar kute tu amim kamnhĩxkumrẽxja pumũ ne kam õbikwa jakryjamã kum, —Akmere jakam ne ba ajaxwe kunĩo aknon arỳm akam ingryk kêt ne, ane. Jeju ta ne axweo akno. ");
INSERT INTO txuNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nhym wãnh Môjdjê kukràdjà mar djwỳnhmẽ mekbê pardjêu õkre kadjwỳnhbê arỳm amim, —E kum bep me'õja ne ajmãn Metĩndjwỳnh japrỳo djan amijo Metĩndjwỳnho dja. Metĩndjwỳnh pydji ne kute me axweo biknorn mekam ngryk kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nãm me ã õkre kadjwỳnhbê anhỹro kumex nhym arỳm tu kuman memã kum, —Mỳkam ne ga me anhõkre kadjwỳnhbê ijo ikajgon ijaprỳo akumex? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ẽ, ba me amã mỳjja amãnhkrut jarẽ. Mỳj ne amirĩt ne? Ba ren me'õ jakryjamã kum, “Ba arỳm ajaxweo aknon akam ingryk kêt”, ane, nàr kon, “On kàjmã djan tẽ”. Mỳj ne ren amirĩt, nẽn? Nã bãm ren kum, “Arỳm ne ba ajaxweo aknon akam ingryk kêt”, ane nhym amirĩt kêtkumrẽx ne. Tãmbit ne amirĩt kêt. Nhym bep kàjmã me ku'ê, ije ren me'õmã kum, “Kàjmã djan tẽ” nhym ren amirĩt ne. Tãmbit ne amirĩtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Dja ba kum, “Kàjmã djan anhikwã djà mỳn o tẽ”, anen arỳm o mex ga me arỳm omũn arỳm abenmã, “Be, ga Jeju kute me'õ jakryo mexja pumũ. Be, djãm kute me axweo biknor kêt got. Mrãmri ne Metĩndjwỳnh arỳm amijo ĩ ne pyka jakam amikabẽnkôt ar me axweo biknoro ba”, ane. Me aje abenmã ja jarẽnh kadjy dja ba me'õ jakryjao mex, ane. Nãm ã Môjdjê kukràdjà mar djwỳnhmã anen arỳm tu me'õ jakryja'ỳr akẽx ne kum, —Amã ne ba ikabẽn ne. On kàjmã djan anhikwã djà mỳn anhũrkwãmã o tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nhym me ipôkri ekrux ne kàjmã djan nõr djà mỳn mã ũrkwãmã o tẽ, Metĩndjwỳnhmã mexmẽ õdjànhmẽ rax jarẽnho tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nhym me kunĩ omũn kam ari aben pumũnho kumex ne kôt Metĩndjwỳnhmã mexmẽ rax jarẽnho kumex ne kam arỳm kum Metĩndjwỳnh pyman abenmã kum, —Atemã mỳjja mexkumrẽx ne gu me arỳm jakam omũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nhym kam Jeju me kurũm tẽ. Tẽn kute pi'ôk kaprĩo atom djwỳnh'ỳr bôx ne omũ. Idjibê Rewi. Pi'ôk kaprĩ nhũrkwãkam ne bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atomo nhỹ. Nhym Jeju 'ỳr bôx ne omũn kum, —Gop amrẽ ikôt ajkamẽn gop ikôt ar aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nhym tu ekrux ne kàjmã djan mỳjja kunĩ kangan mã kôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ne kam me krãptĩmẽ ro'ã õ kwỳ krẽn rax kadjy memã djwỳmẽ mry gan kadjy memã arẽ. Nhym me kute bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnh krãptĩn bôx nhym ajte atemã me jadjwỳ kwỳ bôx, Rewi nhũrkwãkam bôx ne õ kwỳ krẽno kumex, ar kutã õ kwỳ krẽno kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nhym kam mekbê pardjêumẽ me kute Môjdjê kukràdjà mar djwỳnh omũn bẽn prĩkam kabẽno krĩ, Jejukôt ba djwỳnh'ã kabẽn ne kum, —Mỳkam ne gar me kute pi'ôk kaprĩo atom djwỳnhmẽ me axwemẽ akàn aro'ã anhõ kwỳ krẽno akumex ne kôt akõmo akumex? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nhym kam Jeju memã kum, —Djãm me mex'ỳr ne me kane djwỳnh mrã? Kati, me kanê'ỳrbit ne me kane djwỳnh mrã. ");
INSERT INTO txuNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Badjwỳ ne ba me axwe'ỳr tẽ. Djãm we me katàt mrãnh'ỳr ne ba tẽ? Kati, me axwe'ỳr ne ba tẽ, ije amiwỳr me 'wỳrmã. Me kute ikabẽn mar ne amim kator ne wãnh axwemã irer ne kute iwỳr amijo akẽxmã ne ba me'ỳr tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nhym me ajte kum, —Ota Djuãokôt ba djwỳnh kute Metĩndjwỳnhmã amijarẽnh kadjy amijajbun ba. Nhym mekbê pardjêu nhõ me ja me kudjwa ã ane nhym bep akôt ba djwỳnhbit ne mã akun kôt kõm ar ba, ane. Ar kute Metĩndjwỳnhmã amijajbur kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nhym kam Jeju memã kum, —Nà, ikôt ba djwỳnh dja mã aku. Ga me kute abenã me rẽnhkam me àkur rũnhja pumũ. Djãm me kute abenã me rẽnhkam me àkur ngy got? Me kute abenã me rẽnhkam ne me mrãmri àkur rũnhkumrẽx. Abenkam kĩnh ne õ kwỳ krẽno kumex. Djãm me kute mỳjja jakam amijajbur got? Djãm me mjênmẽ abentã ku'êri àkur punu got? ");
INSERT INTO txuNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nhym bep amũ akati 'õkam, dja me me aêrbê mekbê mjêno tỹm ne pa 'amỳn mã o tẽ. Nhym me arỳm kam kaprĩre ne kam amijajbun ajbit ma, kôtbit amak bẽ:no nhỹn õ kwỳ krẽnja kêtkumrẽx ne. Nãm ã Jeju amijã me mjên jakreo ane. ");
INSERT INTO txuNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ne kam ajte memã amikukràdjà ny'ã memã mỳjja jakren arẽ. —Nhỹnh got me'õ inôkà ny 'õ byn kadjô, mex katikôt kadjôn kute tũmja'ã ir ne kute o mexmã? Kati, nãm ren o anen ren amibê nyo ajkẽ nhym nymẽ tũmja ren aben pyràk kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ne ajte nhỹnh got me'õ mrykà tũm, mekbê idjaer kukãmãre ne me mrykào ngônh nhinhujabjêti, nhỹnh got me'õ mrykà tũm, mrykà kadjàkam pidjô kangô ny ru, pidjôbê uba kangô ru. Nãm ren ane nhym ren ajkatõr ne ajkapĩ. Kangô nymẽ tũm kute abenkam o bikàr ne runhkam ne ren ajkatõr ne ajkapĩ, nhym mrykàdjwỳ arỳm punu. ");
INSERT INTO txuNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kati, mrykà nykam dja pidjô kangô nyja ru. ");
INSERT INTO txuNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nhym ajte nhỹnh got me'õ kute pidjô kangô tũmbito kõmo ban ny kakin kum ny djành? Kati, arỳm tũmbito amipràk ne kam, “Ije bep kangô tũmbit ne ành”, ane. Nãm ã Jeju kute memã kukràdjà tũm'ã pidjô kangô tũm jakren kute kukràdjà ny'ã pidjô kangô ny jakreo anen kam memã arẽnh pa. ");
INSERT INTO txuNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ne kam pi'ôk ràràrkam Jeju pur katikôt tẽ. Nhym kôt ba djwỳnh kôt mõ. Kôt mõn arỳm kum prãm ne mõrmã bàygogo 'y nhikẽn mõrkôt ngãnh ne amijajkwamã rẽnho mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nhym kam mekbê pardjêu ar omũn arkum, —Ije tô mã ne gar arỳm nẽ? Pi'ôk ràràrkam ne me tyk djà kêt djà. Me kute pi'ôk ràràrkam mỳjjao anhỹr kêt. Me tũmre ne me ta kukràdjàkôt mã me babê uma. Me kute pi'ôk ràràrkam mỳjja kupênh kêt. Kambit ne me tyk djà kêt djà. Mỳkam ne gar ã ar o anhỹro aba? ");
INSERT INTO txuNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nhym kam Jeju memã kum, —Kê, djãm me aje Metĩndjwỳnh kabẽn'ã pi'ôk no'ôkjadjwỳ pumũnh kêt? Djãm me aje me bakukãmãrebê Dawi'ã ujarẽnhja pumũnh kêt, Metĩndjwỳnh kabẽnkam me aje Dawi'ã ujarẽnhja pumũnh kêt? Ẽ, Dawi arkum prã:mã. ");
INSERT INTO txuNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nhym Dawi Metĩndjwỳnh nhũrkwãmã wadjàn djwỳ byn kukrẽn kam kôt ar tẽm jamãdjwỳ kungã, nhym ar kukrẽ. Djwỳ me kute Metĩndjwỳnhmã õrja tãm ne kubyn kukrẽn arkum kungã. Metĩndjwỳnh nhõ djwỳ ne me kàtàm kute kur kêtkumrẽx. Me kadjy Metĩndjwỳnh mar djwỳnhbit ne kute kur. Nhym bep Dawi ta ne tu kubê kukrẽ. Nhym kam me kute kum axwe jarẽnh kêt. Djãm me aje ja mar kêt? Ga me aje Dawimã axwe jarẽnh kêtja pumũ ne kam ikôt ba djwỳnhmẽbit ar imã ar ijaxwe jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Bep kati, ba ije amijo inhĩ ne me awỳr irwỳk ne ba inhõ pi'ôk ràràr djwỳnh. Kam gêdja ba memã, “Kwãrĩk wãnh ga me kam mỳjja kupênh kêt, nàr kon, dja ga me jakam apên, nàr kam mỳjja kupênh kêt ne arek akrĩ”, ane. Tãm ne ja, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nhym kam ajte pi'ôk ràràr 'õkamdjwỳ me bikprõnh djàmã wadjàn kam kam memã Metĩndjwỳnh'ã ujarẽnho dja. Nhym me'õ nhikra jarõxja nhỹ. Ubôk ne arõx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nhym mekbê pardjêumẽ me kute Môjdjê kukràdjà mar djwỳnh arek Jejukam no tyn krĩ. Nhym pi'ôk ràràrkam kute ikrao mex nhym me kute kôt kum kator ne kute kum, —Arỳm ne ga Môjdjê kukràdjàkôt amijo aba kêt, anhỹrmã ne me arek kam no tyn omũnho krĩ. Mekbê pardjêumẽ me kute Môjdjê kukràdjà mar djwỳnh ne me ã Jejukam no tyn ar krĩ ba ane. ");
INSERT INTO txuNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nhym bep ta, Jeju ta ne arỳm me kute õkre kadjwỳnhbê amim 'ã karõja arỳm kuma ne kam me'õ nhikra jarõxjamã, —Amrẽ tẽn me ipôkri dja, ane. Nhym kàjmã djan 'ỳr tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nhym kam memã kum, —Ẽ, ba me bakukràdjà jabej me akukja. Nhỹnhja ne me bakukãmãre me bamã arẽ? Djãm pi'ôk ràràrkam me baje mỳjja mex nhipêxmã nàr kon kam me baje mỳjja punu nhipêxmã? Djãm kam me baje me utàr nàr kon kam me baje me parmã, nẽn? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ne kam ari ar me omũn kam ate ikra jarõxjamã, —On anhikra katàt, ane. Nhym kam ikra katàt ne. Arỳm ne ikra mexkumrẽx. Arỳm ajte ikra katàt ne ikrakumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nhym kam ajte mekbê pardjêu ngry:k ne. Ngryk tỳ:x ne. Ne kam Jeju'ã abenmã karõo kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nhym kam akati 'õkam krãnhre'ỳr tẽn 'ã wabin nhỹ, kute Bãmmã kabẽnmã, Metĩndjwỳnhmã kabẽnmã. Kum kabẽno ỹr ri nhym akati. ");
INSERT INTO txuNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","16","Akati nhym kam amiwỳr kôt ba djwỳnh 'uwn amijo ar kwỳ pytàn amim ar umjuwn arkum, —Ba dja ba ar ajano, gar memã ijã adjujarẽnho ajmà. Ar abê inhõ àpênh, ane. Nãm kute ar anor kadjy ar o 12 ne amijo ar utàn kam tũmràm ar ano. Ximão. Jeju kute kum Pedru jarẽnhja. Ãngre. Ximãomẽ Ãngre ar aben djàkam ikwã. Xijagu. Djuão. Piripi. Batormê. Matêu. Tôme. Xijagu 'õdjwỳ. Kubê ne Aupêu kra. Ximão 'õdjwỳ. Ximão tãm ne kum me bajtemja kurêkumrẽx, me bajtem kute meo baja kum me kurêkumrẽx. Djuda. Xijagu kraja. Djuda Ikadji. Kute Jeju kurê djwỳnhmã kanga djwỳnhja. Be, Jeju kute tũmràm ar anor ne ja. ");
INSERT INTO txuNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ne kam kôt ba djwỳnhbê 12jamẽ ro'ã ruw ne pyka kênh'ỳr bôx ne kam kam meo dja. Nhym me kôt ba kajgo ne me 'ã kumex. Nhym me kàtàmjadjwỳ Jeju'ỳr mõn bôx ne 'ã kumex. Pykabê Djudêja kurũm me krãptĩmẽ krĩraxbê Djeruxarẽ kurũm me krãptĩmẽ ngô rax nokà'ã pykabê Xirumẽ Xidõmẽ kurũm me krãptĩmẽ. Me tãm ne me akàn Jeju'ã kumex. Me ja ne me 'ỳr akuprõ. 'Ỳr bikprõnh ne kute kabẽn mar nhym kute apỹnh me kanê djàri meo mexmã ne me 'ã akuprõ. ");
INSERT INTO txuNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nhym me karõ punu kute meo bajadjwỳ mekôt 'ỳr mõn bôx nhym kam mekam me karõ punuja jano nhym me arỳm mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nhym me itepato kute Jeju kupênh prãm. Nãm Jeju tu tỳxkumrẽx nhym kurũm uma apôx ne me kunĩo mex. Kam ne me kunĩ kute Jeju kupênh prãmã. ");
INSERT INTO txuNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nhym kam meo mex pan kam kôt ba djwỳnh pumũn arkum, —Ẽ ar anhõ nêkrêx kêtwã, ar ga ne gar akĩnhkumrẽx. Mỳkam? Bir, ar ga ne Metĩndjwỳnh ar akadjy bẽnjadjwỳr ne ar ar ajo ba. ");
INSERT INTO txuNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ẽ, ar jakam amã prãmwã, ar ga ne gar akĩnhkumrẽx. Mỳkam? Bir, ar ga dja gar ajajnekumrẽx ne. Ẽ, ar jakam amỳrwã, ar ga ne gar akĩnhkumrẽx. Mỳkam? Bir, ar ga dja gar akeket ne. ");
INSERT INTO txuNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ẽ, jakam me kum ar akurêja, ar ga dja gar akĩnhkumrẽx ne. Ba ne ba amijo inhĩ ne me awỳr ruw ne kam ar me ajo iba. Ga me akwỳ amã ikĩnh ne iwỳr akuprõ ba kam ar ar ajo iba. Nhym me kam kum ikurên kam ikôt kum ar akurê ne. Gar mã ikôt abikamẽnhkamdjwỳ me kum ar akurê. Gêdja me te wãnh kum ar akurên bõm ar arẽn ar ajaprỳn ar ajaxweo ar apytà, ");
INSERT INTO txuNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","gar tu akĩnhkumrẽx ne ate akĩnh katin amijara tatak ne. Mỳkam? Bir, dja Metĩndjwỳnh ar amã o pãnh rax ne. Kàjkwakam gêdja ar amã o pãnh mex ne. Kàjkwakam kute ar amã o pãnh mex ja dja gar amikukãm aman ate akĩnh kati. Nãm me tũmre ã axwe anen me kamingrãny kajmã'ã ã Metĩndjwỳnh kabẽn jarẽnh djwỳnho bikẽnho bao ane. Gar arỳm kam kàjkwakam me kĩnhkumrẽx ne ar baja pumũ, ane. Nãm ã Jeju arkum ane. Ne kam ajte me õ nêkrêx kumexjamã kabẽn ne memã kum, ");
INSERT INTO txuNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","—Nhym bep me anhõ nêkrêx krãptĩwã me ga dja ga me akaprĩ rax ne. Bir, mỳkam? Jakambit akĩnh djà kajgokam. Gêdja ĩ apêx ne ajte amũ kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ne me jakam ajajnewã, me ga dja ga me akaprĩ rax ne. Mỳkam? Bir, me ga dja ga me amã prãm ne. Ne me jakam akeketwã, me ga dja ga me akaprĩ rax ne. Mỳkam? Bir, me ga dja ga me abixangrin kam amỳro akumex. ");
INSERT INTO txuNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ne me kunĩ kute abenmã me amex jarẽnho kumexja me ga dja ga me akaprĩ rax ne. Mỳkam? Ga me axwe pumũ. Ga me kum me axwebit kĩnh ne kute abenmã me mex jarẽnho kumexja pumũ. Nãm me tũmre ã axwe o anen me kamingrãny kajmã'ã kum me 'êxnhĩbit kĩnh. Me 'êx ne kute amijo Metĩndjwỳnh kabẽn jarẽnho bajabit ne me kum me kĩnh ne abenmã ã me mex jarẽnho kumexo ane. Kam ne me kamingrãny me tũmre kôpdji'ã kum me axwe, me 'êxnhĩbit kĩnh ne kute abenmã me mex jarẽnho kumexja. Nãm ã Jeju memã anen kam kôt ba djwỳnhmã kum, ");
INSERT INTO txuNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Ẽ, ba ajte ar amã ikabẽn 'õ jarẽ, gora ar ikabẽn ma. Gora gar tu amã akurê djwỳnh jabê. Gora me kum ar akurêja dja me te ar ajo ajkẽ gar akrànmã amã me abên ar meo aba. ");
INSERT INTO txuNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gora ar me kute ar adjũnwãmã tu akabẽn mex jarẽ. Gora ar me kute ar ajo bikẽnhja tu Metĩndjwỳnhmã me arẽ gê meo djuw mex. ");
INSERT INTO txuNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Gêdja me'õ ar ajõ nhinebê kurwa ga 'ỳr akẽx gê aktã anhinebê kurwa. Gêdja me'õ ar ajõbê inôkà by ga tu kum kanga. Nhym ajte akà 'õ'ã ajwỳ ga ajte akà 'õdjwỳ byn kôt kum angã. ");
INSERT INTO txuNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Gêdja me'õ mỳjja 'ã ajwỳ ga tu kum kanga. Gêdja me'õ abê anhõ mỳjja 'õ by ga tu kum kangakumrẽx. Kwãrĩk wãnh ga akubyn 'ã 'wỳr kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Djã nãm me ar ajõo ajkẽ ga akĩnh ne? Kati, nã gãm akaprĩre. Bir be, kam dja gar ã me jao anhỹr kêtkumrẽx gê me adjwỳnhdjwỳ kaprĩ kêt. Nàr kon, djã nãm me ar ajõkam mex ga akaprĩ? Kati, nãm me ar akam mex gar akĩnhkumrẽx ne. Bir be, kam dja gar ã me jakam amexo ane gê me adjwỳnhdjwỳ kĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ẽ, ba ar amã arẽ. Me kum ar ajabê gar amipãnh amã me abêkumrẽxja bãrãm kam dja ba ar amex jarẽnh jabej? Kati, ẽ, me axwe ne me kum õbikwabit jabê, kum aktã aben jabê ne kam kum me kàtàmja kĩnh kêtkumrẽx. Be, dja gar gadjwỳ amã anhõbikwabit jabê, djori kam mex? Kati, ar ikôt aba djwỳnhkam gêdja gar tu amã me abêo tuknĩ. Ar amã anhõbikwa jabên kam kôt amã akurê djwỳnhdjwỳ jabê. ");
INSERT INTO txuNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nhym ajte me ar akam ukaprĩ gar amipãnh mekam adjukaprĩ, bãrãm kam dja ba ar amex jarẽnh jabej? Kati, ẽ, me axwe ne me õbikwakambit ukaprĩ, aktã abenkam ukaprĩ ne kam me kàtàmjakam ukaprĩ kêtkumrẽx. Be, dja gar gadjwỳ anhõbikwakambit adjukaprĩ, djori kam mex? Kati, ar ikôt aba djwỳnhkam gêdja gar tu me kunĩkam adjukaprĩo tuknĩ, anhõbikwakam adjukaprĩn kam kôt akurê djwỳnhdjwỳ kam adjukaprĩ. ");
INSERT INTO txuNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nhym ajte me ar amã mỳjja ngã gar kam amipãnh memã mỳjja ngã, bãrãm kam dja ba ar amex jarẽnh jabej? Kati, ẽ, me axwe ne me aktã aben pãnh abenmã mỳjja nhõro ba. Nãm me akubyn abenmã 'ãnh õro ba. Be, dja gar gadjwỳ me kute akubyn ar amã mỳjja nhõrmãbit mỳjja ngã, djori kam mex? Kati, ar ga, ar ikôt aba djwỳnhja dja gar tu memã mỳjja nhõrkumrẽx ne kam pãnhkam amak kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bir be, ar ga dja gar amã akurê djwỳnh jabêkumrẽx ne kam adjukaprĩ ne tu kum mỳjja kajgo ngã. Kute akubyn amã pãnh mỳjja 'õ nhõrmã pãnh kam amak kêt. Metĩndjwỳnh pymati tãm gêdja ar amã o pãnh ra:x ne. Gar kam arỳm abê Metĩndjwỳnh krakumrẽx. Mỳkam dja gar ã meo ane? Bir, Metĩndjwỳnh ne tu me õdjỳ, me axwekam ukaprĩ. ");
INSERT INTO txuNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kam dja gar kàjkwakam Abãm'ã amijakren mekam adjukaprĩ. ");
INSERT INTO txuNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kwãrĩk wãnh gar me'ã axwe rẽnh kêt. Dja gar me'ã axwe rẽ nhym me amipãnh ar ajã axwe rẽ, nàr Metĩndjwỳnh ar amã axwe jarẽ. Kwãrĩk wãnh gar me axwemã akator kêt ne memã pãnh jarẽnh kêt. Dja gar me axwemã akato ne memã pãnh jarẽ nhym me amipãnh ar ajaxwemã katon ar amã pãnh jarẽ, nàr Metĩndjwỳnh ar amã pãnh jarẽ. Nhym bep kati, gêdja me kute ar akam amikràja gar tu o abiknorkumrẽx gê me amipãnh ar gadjwỳ tu ar ajaxweo biknorkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gora ar memã anhõdjành ne tu memã angã. Gê me kam amipãnh ar amã õdjànhkumrẽx ne ar amã mỳjja ngã. Dja Metĩndjwỳnh ar amã o pãnh rax ne. Kute mrãmri ne me kute akubyn abenmã djwỳ ngrà nhõr kadjy kute ngônhkam ngjênh ne ajte kute à'àk ne kum o'uk ne iby ngjênh nhym akà'ã bikapĩnja pyràk. Dja ã Metĩndjwỳnh ar amã õr raxo ane. Bir be, kam dja gar Metĩndjwỳnh kudjwa memã õr rũnh nhym kam me akubyn ar aje memã õr 'ãnh ar amã kungã, ane. Nãm Jeju ã kôt ba djwỳnhmã arẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ne kam ajte apỹnh mỳjja djàri arkum 'ã ujarẽnh jakreo tẽ. Ne kam arkum, —Djãm me'õ no rãja kute me'õ no rãjamã kum, “Amrẽ, ba amã kô 'amỳn katàt ajo tẽ”, anhỹrmã? Kati, gorẽn kum kô 'amỳn o mõn ren ar ro'ã krekam tỹm, ane. Be, me axwe rã'ãkam dja me amũ me jamã axwe jarẽnh kêt. Me axwekam ne me kute me no rã pyràk. ");
INSERT INTO txuNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Djãm me'õ kute mỳjja mar kêtja kute me'õ kute mỳjja mar raxja jakrenh got? Kati, nhym bep djãm me'õ kute marja prĩne kum arẽn kum akre nhym kam arỳm ar aben pyràk ne. Bir be, ar aje Metĩndjwỳnh kukràdjà mar tũmja amijãno dja. Dja me nyre ar ajã amijakren kam kute ar apyràk. ");
INSERT INTO txuNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mỳkam ne ga akamy nokam pyka jaũmjabit pumũn kam ga anokam pĩponhtija pumũnh kêt ne? ");
INSERT INTO txuNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Djãm aje akamymã kum, “Akmere, amrẽ ba amã anokam pyka jaũmwã kaba”, anhỹrmã? Ne kam ga anokam pĩponhtiwã pumũnh kêtkumrẽx ne. Aje aminokam pĩponh pumũnh kêtkam we ã kum ane. Kê. Mrãmri ne ga apunu rax ne kam ajajkwakambit ajte amimexo amra. Akumrẽx gêdja ga aminokam pĩponhtiwã kaban kam arĩt mex ne arỳm amikôt akamy nokam pyka jaũm ngrire wã kaba. ");
INSERT INTO txuNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ne ajte jadjwỳ, ẽ, djãm pidjô mex, pidjô djànhjakam pidjô punu apôx got? Nàr kon, djãm pidjô punukam pidjô djành apôx got? Kati, apỹnh pidjô bàri djàri ne kam ô apôx. ");
INSERT INTO txuNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ô ne parbê rôrôk ne ikwãn kam o bàrio amirĩt nhym me kôt kum apôx. Pidjô punukam ô punu apôx, nhym ate pidjô mexkam ô mex apôx. Ga rojkàkrekam tyrti apôx kêtja pumũ. Ga ajte prêxkamdjwỳ katẽbàri apôx kêtja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bir be, nãm ã mebêngôkredjwỳ ane. Nãm me õkre kadjwỳnhbê kabẽn mex man arỳm kabẽn mexo memã amijo amirĩt. Nhym me ajte õkre kadjwỳnhbê kabẽn punu man arỳm kabẽn punuo memã amijo amirĩt. Nãm me õkre kadjwỳnhbê mỳjja kumex ma nhym kam amrẽ bõm ajkwa krekremẽ õto'ỳr apôx nhym me kam arẽnho ba. Arẽnho ban kam arỳm memã amijo amirĩt. Mex nàr axwe ja o memã amijo amirĩt. Kute mỳjja ô kute bàrio amirĩt ja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ẽ, ba ajte ar amã ja jarẽ. Mỳkam ne gar imã “Bẽnjadjwỳr, Bẽnjadjwỳr” anhỹro aban ajte ikabẽnkôt ar amijo aba kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Ẽ, ba ar amã arẽn kikre'ã me ajakre. Me'õ iwỳr akẽx ne kute ikabẽn markumrẽx ne ikabẽnkôt kute ar amijo baja ne kute mrãmri ne me kute kikremã kre jabjê:n kam kam par pymjỳr ne kam iby kẽnmẽ pyka rẽnh ne kute kum o'uk ne 'ã kute kikre nhym te ngô tàm ne kute kangõnh nhym mrãmri ku'ê tỳxja pyràk. Kum kre jabjêkam ne mrãmri ãm tỳx ne. Nãm ã me kute amim ikabẽn mar tỳx ã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nhym bep me'õ kute ikabẽn mar kajgo, kute ikabẽnkôt amijo ba kêtja ne kute mrãmri ne me kute tu pyka krãkà'ã par pymjỳr. Kre krãnne kam kute par pymjỳr ne kute 'ã kikre pyràk. Nhym 'ã ngô tàm ne kute kàjbê me'ã rẽnh nhym rôrôkja pyràk. Djã nãm kàjbê kukẽ nhym ban rôrôk got? Kati, nãm tu ator nhym ban gru: ane. Dja me'õ kute ikabẽn mar kêt'õ ã ane, ane. Nãm ã Jeju arkum ujarẽnho ãmo anen memã ujarẽnh pa. ");
INSERT INTO txuNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ne kam ate krĩbê Kapana'ỳr tẽ. Mã 'ỳr tẽn bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Bôx nhym krãkamngônh nhõ bẽnjadjwỳr arỳm kuma, kubê ne krãkamngônhre krãptĩbê 100 nhõ bẽnjadjwỳr arỳm kuma, bôxkôt kuma. Kubajtem. Arỳm kuman kam 'ỳr mebêngêtte kwỳ jano. 'Ỳr mebêngêttebê idjaer kwỳ jano. Õ àpênh ne kanê tỳx ne nõ. Arỳm tyk'ỳr. Arỳm arkatin nõ. Kum õ àpênh jabêkumrẽx ja ne kubê kanên nõ nhym kam kadjy Jeju'ỳr ar ano. Ar kute kum arẽnh nhym 'ỳr tẽm ne kute kum õ àpênho mexmã ne 'ỳr ar ano. ");
INSERT INTO txuNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Nhym ar mõn Jeju'ỳr bôx ne kam kum o no katon kum, —E kum bep tãmja ne mexkumrẽx. Mrãmri dja ga 'ỳr tẽn kum õ àpênh pytà. Nãm kum me bakĩnhkumrẽx ne arỳm me bamã me babikprõnh djà nhipêx ne. Dja ga on 'ỳr tẽ, anhỹro ku'ê. ");
INSERT INTO txuNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Nhym kam 'ỳr tẽ. Bit 'ỳr tẽn 'ỳr kikre têpo tẽ nhym krãkamngônh nhõ bẽnjadjwỳrja ajte kutã õbikwa kwỳ jano. Nhym ar kutã tẽn kajpan kum, —Bẽnjadjwỳr, on dja ga akẽx ne. Krãkamngônh nhõ bẽnjadjwỳr ne ar imã, “Ar tẽn kum arẽ gê on amũ akẽx”, ane. Bar kam akutã tẽ. Nãm amã, “Ibẽnjadjwỳr kaàk, ibẽnjadjwỳr ngrirekam ne ga inhũrkwãmã adjàr ba ipijàm karõ amã ane. Ingrire, ikàtàmkam ne ba ba akutã itẽm kêt ne, amikam ipijàmkam. Dja ga tu akabẽnobit inhõ àpênho mex nhym arỳm mexkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Inhõ bẽnjadjwỳr ne imã kabẽn, kute raxo ijakrenhja ne imã kabẽn ba kabẽn man kôt amijo iba. Ne kam ajte ba ibê me krãkamngônhre nhõ bẽnjadjwỳrkam ba memã ikabẽn nhym me ikabẽnkôt amijo ba. Ba me'õmã kum, ‘'Ỳr tẽ’, ane nhym arỳm 'ỳr tẽ. Ba kam ajte me'õmãdjwỳ, ‘Amrẽ tẽ’, ane nhym arỳm amrẽ tẽ. Ba inhõ àpênhmã, ‘On mỳjja kupê’, ane nhym arỳm mỳjja kupê. Kam ne ba amã, ‘Abẽnjadjwỳr djwỳnhkam dja ga akabẽnobit o mex ne’, ane.” Nãm ã krãkamngônh nhõ bẽnjadjwỳr amã ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nhym Jeju ar kabẽn man kam arkam no tyn djan õkre kadjwỳnhbê amim, —E kum be nãm tu amim ikamnhĩxkumrẽx ne, ane. Ne kam me itepato kôt mõrja'ỳr akẽx ne memã kum, —Ẽ, ba me amã arẽ. Nhỹnh ne me babê idjaer 'õ ã kute tu amim imaro anhỹr? Kati, kêtkumrẽx. Nhym be nãm tãwã, tãwã kubajtem ne gêt tu amim ikamnhĩxkumrẽx ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nhym kam krãkamngônh nhõ bẽnjadjwỳr nhõbikwaja akubyn kikremã tẽ. Kikremã tẽn bôx ne kanên nõrja pumũ. Nhym mexkumrẽx ne, arỳm à kêt ne nhỹ. Tãm ne ja. ");
INSERT INTO txuNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nhym kam akati ngrêre nhym Jeju krĩ 'õmã tẽ. Krĩ nhidjibê Naĩmã tẽ. Nhym kôt ba djwỳnhmẽ me kàtàm krãptĩ kôt mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nhym kam Jeju meo mõ. Meo mõn ĩ krĩ têpo mõ. Nãm bit krĩo rãm ne jao mõ nhym Ar kubê kra tykjao mõn o kajpa. Kikre bu'ã kẽno kô kayr jajkwa krekremã o aben kajpa. Amrẽbê me'õbê mjên tyk nhym kam kraja adjwỳnhdjwỳ kôt kubê ty. Kute amikamã kra pydjin irja ne kubê ty. Nhym me kam kẽnkre'ỳr o mõn o kajpa. Me krãptĩ ne me kẽnkre'ỳr bit o mõ, bit kute mekbê idjaer kukràdjàkôt kẽnkrekam adjàrmã. ");
INSERT INTO txuNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nhym Jeju me'õ nija pumũn kam kum kaprĩ: ne kum, —Kwãrĩk wãnh ga amỳr kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ne kam 'ỳr tẽ. 'Ỳr tẽn kam 'ã nõr djàbit kupê. Nhym ar kute o mõrja, tyko mõrja, o mõr tỳx katikôt kum o dja. Nhym kum kabẽn ne kum, —Akmere, ba amã arẽ. Ẽ, on kàjmã nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nhym ekrux ne kàjmã nhỹn kam kabẽno nhỹ. Nhym Jeju nãmã kungã. ");
INSERT INTO txuNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nhym me kunĩ madjà kreti ne kum uman kam Metĩndjwỳnhmã raxmẽ mex jarẽnho kumex ne abenmã kum, —Ota Metĩndjwỳnh kabẽn jarẽnh djwỳnh rax 'õ me bakam kato, ane. Ne ajte, —Metĩndjwỳnh ne arỳm õ me baja 'ỳr bôx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nhym me kam abenmã Jeju jarẽnho kumex ne amũ abenmã arẽnho prõt ne. Nhym pykabê Djudêjakam me ja kuma. Nhym amũ bu'ã pyka ja kunĩkôt me abenmã arẽn kuma. ");
INSERT INTO txuNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Nhym Djuão kôt ba djwỳnhdjwỳ arỳm kuman Djuãomã arẽ. Nhym adjwỳnhdjwỳ kuma. Mekbê ijê djàkam nõr rã'ãkam ne ar kum mỳjja ja kunĩ jarẽ nhym kuma. Kuman kam amiwỳr ar ku'uw, amiwỳr kôt ba djwỳnh 'uw, ar amãnhkrut ne ar ku'uw ne arkum, —Ẽ, ar Jeju'ỳr tẽn kum, “Djãm ga ne Metĩndjwỳnh amrẽbê me imã ajarẽ ga arỳm bôx. Nàr kon, dja ba me atemã 'õdjwỳ jabej ajkam ama”? ane. Djuão ne ã arkum anen kam ar ano. Bẽnjadjwỳr djwỳnh'ỳr ar ano. Ar kute omũnh ne tẽm ne kute Djuãomã arẽnhmã ne 'ỳr ar ano. Nhym ar 'ỳr tẽn bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bôx ne kum, —Djuão kute ngônhmã me angjênh djwỳnh ne awỳr ar ijano ne ar imã, “Ar tẽn kum, ‘Djãm ga ne Metĩndjwỳnh amrẽbê me imã ajarẽ ga arỳm bôx? Nàr kon, dja ba me atemã 'õdjwỳ jabej ajkam ama’? ane.” Nãm ã arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nhym kam Jeju arek me utàro dja. Me apỹnh kanê djàrimẽ, apỹnh me tokry djàrimẽ, me karõ punu kute meo bamẽ, me no rãmẽ, me ja ne meo mexo dja. Me krãptĩ ne meo mexo dja. Djuão kôt ba djwỳnh kute omũnh ne akubyn 'ỳr tẽm ne kute kôt kum arẽnh nhym kute marmã ne arek me utàro dja. ");
INSERT INTO txuNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ne kam arkum, —Ar'ỳr tẽn Djuãomã arẽ. Ba ne ba arỳm me'ỳr bôx ne me utàro dja nhym me no rã arỳm rĩt, me te jakry arỳm mrã, me ĩ kajêkam tê arỳm kà mex, me amakkre kêt arỳm amakkre mex ne ajkam ama, nhym me tykjadjwỳ arỳm akubyn tĩn ne, nhym me me õ mỳjja kêt jamãdjwỳ kabẽn mex, kabẽn ny kàj bê arẽ. Bir be, ar aje ije meo mexkôt ipumũnhja dja gar tẽn kôt Djuãomã arẽ, ane. Ne ajte kum, ");
INSERT INTO txuNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","—Me'õ kute tu amim imar ne kute õkre kadjwỳnhbê ijã amim, “Djãm tãm, nàr kon atemã”, anhỹr kêt, tãm dja kĩnhkumrẽx, ane. Nãm ã Jeju Djuão kôt ba djwỳnhjamã ane. Nhym ar kuman kam mã 'ỳr akubyn tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ar tẽm tekrekam memã Djuão jarẽnho dja. Me krãptĩjamã arẽnho djan memã kum, —Nã gãm me aje Djuão pumũnhmã mõ, kapôt kukritkam mõ. Mã ne kute? Me bõreja pumũ. Bõre ne kôk o wabên ari ar adjuw. Mũm wabên adjuw. Nhym pãnh wabên mũm adjuw. Ne ari ar adjuw. Djãm ã Djuão kute anhỹr? Djã nãm ã memã kabẽn jarẽnho ane? Djã nãm me jamã kabẽn 'õ jarẽ ne kam ajte me umaje amũ me jamã atemã kabẽn 'õ jarẽ? Kati, nãm tu katàt memã kabẽn jarẽnhkumrẽx ne, tu kum me uma kêt ne kabẽn pydji memã arẽnho tẽ, kabẽn tãm jarẽnho tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Djã nã gãm me aje Djuão pumũnhmã 'ỳr aba nhym kubẽkà mex jangij ne o ba? Kê, me kute kubẽkà mexbit jangjênh ne kute 'ã amibẽno baja ne me bẽnjadjwỳr rax nhõ kikretikambit ar ba, ikra kêt, àpênh kêt mex ne ar ba. ");
INSERT INTO txuNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bir be, nhym mỳj ne ga me aje omũnhmã mõ? Djãm Metĩndjwỳnh kabẽn jarẽnh djwỳnh 'õ ne ga me aje omũnhmã mõ? Nà, tãm. Tãm. Ba me amã arẽ. Djuão ne Metĩndjwỳnh kabẽn jarẽnh djwỳnh kunĩ kuràm raxi. ");
INSERT INTO txuNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","'Ã ne amrẽbê Metĩndjwỳnh pi'ôk no'ôkkam me amã, “Ota ba akukãm ajã ujarẽnh djwỳnh 'õ jano, kute akukãm me akre nhym me kute mar ne akutêp kute axwemã irern katàt amijo bamã. Kute mrãmri ne me kute me bẽnjadjwỳr rũnh kutêp katàt pry jadjwỳrja pyràk”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ba me amã arẽ. Djuão ne me kunĩ kuràm raxi. Nhỹnh ne me'õ nã tikkre kurũm kator'õ raxo kute Djuão jakrenh? Kati, bep Metĩndjwỳnh me kadjy bẽnjadjwỳr ne kute ar me utàr ne meo baja, me ja'õ ne te kàtàm mex ne kute raxo Djuão jakrenh mexi. ");
INSERT INTO txuNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nà, Djuão ne rax nhym me kunĩ Djuão kabẽn ma. Nhym me axweja, me kute bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnhdjwỳ me kudjwa kabẽn ma. Nãm me Djuão kabẽn man õkre kadjwỳnhbê amim, “Mrãmri ne Metĩndjwỳnh katàt meo ba”, ane. Nhym Djuão arỳm ngônhmã me angij. ");
INSERT INTO txuNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nhym bep mekbê pardjêumẽ me kute Môjdjê kukràdjà mar djwỳnhmẽ, me ja ne me Metĩndjwỳnhbê amikati. Metĩndjwỳnh kute amim me'ã karõ ne me mar kêt ne ar kubê amikatio ba. Nhym Djuão kute ngônhmã me angjênhmã nhym me ate ar kubê amikatio ba. ");
INSERT INTO txuNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ije tô mỳj'ã got ba me akamingrãny jakre? Mỳj ne ga me aje uràk? ");
INSERT INTO txuNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nã gãm me aje me prĩre mỳjja kam kĩnh kêt pyràk. Ga me me prĩre kikre kabem krĩn kute abeno bixaêr baja pumũ. Ar ja ne ar ar jamã kabẽn ne arkum, “Gwaj bakĩnh katio dja, gwaj babixaêro dja ne ngôtàx à'àk”, ane. Nhym ar kum, “Waj, ar ibixaêr prãm kêtê. Ar itor prãm kêtê. Ar imã wã kĩnh kêtê.” Nhym ajte arkum, “Gwaj bamỳr kati mãn o nhỹ.” Nhym ar, “Kê, wajre. Ar imã kĩnh kêtê. Ar imỳr prãm kêtê.” ");
INSERT INTO txuNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Djuão kute ngônhmã me angjênh djwỳnh ne me awỳr bôx. Nãm amijajbu:n kute uba kangôo kõm kêt ne ar ba, ga me amã kĩnh kêt ne kam we, “Nãm ajbã. Me karõ punun ar o ba nhym ajbã”, ane. Be, nã gãm me aje me prĩre pyràk ne amã ja kĩnh kêt ne ajte amã jadjwỳ kĩnh kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nhym bep ba ne ba mrãmri gêt amijo inhĩ ne me awỳr bôx ne me akam idjàkur iban kôt ikõm iba ga me kam amã ikĩnh kêt ne we ijã, “Kê, tãwã ne kum prãmti, kum uba kangô djànhti.” Ne we ajte ijã, “Me kute bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnhmẽ me axweobit ne õbikwa”, anhỹr ar o aba. ");
INSERT INTO txuNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Djãm Metĩndjwỳnh jamak punu got? Axwe amak mex ne prĩne kute amikukãm mỳjja kunĩ mar ne Djuão kute amijajbur ne ar bamã ano. Ne ajte amikukãm umarkam badjwỳ ijano. Ije amijajbur kêtmã ijano. Nhym kôt me amak mex, me amikukãm umar, ar ipumũn kam õkre kadjwỳnhbê amim, “Mrãmri ne Metĩndjwỳnh mexkumrẽx ne amẽ ar ano”, ane. Nãm ã Jeju memã ane. Tãm ne ja. ");
INSERT INTO txuNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nhym kam mekbê pardjêu'õ nhidjibê Ximão ne Jejumã kum, —Amrẽ tẽn ikutã anhõ kwỳ krẽ, ane. Nhym kam kutã õ kwỳ krẽnmã tẽn bôx ne nhỹ. Nhym me abenmã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nhym me'õ nire arỳm kuma. Me'õ nija ne axwe ne krĩ tãmkam arĩk ar ban kam Jeju tẽm ne mekbê pardjêu'õ nhũrkwãkam õ kwỳ krẽno ỹrkôt arỳm kuma. Arỳm kuman kam 'ỳr tẽ. Nãm ngônh mexte, kẽn jakareo ngônhkam me kudjỳ djào ipun kubyn 'ỳr o tẽn o bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","O bôx ne burũm ibôn mỳro nhỹ. Parbê mỳro nhỹ nhym no kangô prĩne Jeju par kumrã. Par kumrã nhym kam ta amikĩo par ngrà. Kum Jeju kĩnhkam 'ỳr tẽn bôx ne omũn kam amikam pijàm ne kam muw ne prĩne no kangôo par kumrãn kam amikĩo par ngrà. Ne kam par kaô. Kum abêkam par kaôn kam me kudjỳ djào par kudjỳ. ");
INSERT INTO txuNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nhym mekbê pardjêu'õ kutã Jeju õ kwỳ krẽno ỹrja arỳm omũ. Arỳm omũn kam õkre kadjwỳnhbê amim, —Be, Jeju kute mar kêt. Bep Metĩndjwỳnh kabẽn jarẽnh djwỳnhkumrẽx ne ren arỳm kuma. Mỳj me'õ niwã ma, arĩk ar baja ren arỳm kôt kuma, me'õ axwe kute kupênhkôt ren arỳm kuma. Ren kuman ren aminêje ano. Bep kati kute mar kêt. Kute Metĩndjwỳnh kabẽn jarẽnh mar kêt, kàtàm. Nãm ã õkre kadjwỳnhbê amim ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nãm ã ane nhym Jeju arỳm kuman kam kum, —Ximão ba amã ikabẽn jarẽ, ane. Nhym, —Ã, bẽnjadjwỳr, aj rã'ã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nhym kum, —Ẽ, me'õ ne ar amãnhkrutjamã pi'ôk kaprĩre ngã. Nãm jamã pi'ôk kaprĩ ngrireo 50 ne kungã. Ne ajte jamãdjwỳ pi'ôk kaprĩ raxo 500 ne kungã. ");
INSERT INTO txuNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nhym ar ja amẽ te akubyn kute kum o pãnhmã. Te o ane nhym kam kute arkum pi'ôk kaprĩ nhõr djwỳnhja arkum, “Kwãrĩk wãnh imã o pãnh kêt. Dja ba tu o akno”, ane. Bir be, nhym gêdja kum abê rax ne? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nhym kam Ximão Jejumã kum, —Kon, birãm tãwã, kute kum rax ne õr ne kute pãnh tu o biknorwã gêdja kum kĩnh rax ne, ane. Nhym kum, —Nà, kôt ne ga aje arẽnhwã, ane. Nija ne axwe rax. Ba arỳm axwe kunĩo aknon kum pãnh jarẽnh kêt ne. Kam ne kum ikĩnh rax ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ne kam nija'ỳr akẽx ne Ximãomã kum, —Ẽ, djã nã gãm nija pumũ? Be, nã bãm anhũrkwãmã wadjà ga aje imã ngô nhõr kêt, ije amipar ku'õnh kadjy aje imã õr kêt. Nhym bep tãmja ne no kangôo ipar kumrãn kam amikĩo ipar ngrà. ");
INSERT INTO txuNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ga ne ga amã ikĩnh kêtkam aje inhine kaôr kêt nhym bep tãmja ne ibôx totokbê arek ipar kaôro nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ga ne ga aje ikrã ngrành kêt nhym bep tãmja ne me kudjỳ djào ipar kungrà. Tãmja ne kum ijabêkumrẽx ne prĩne ijo djuw mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kam ne ba amã, “Tãmja ne axwe krãptĩ ba arỳm tu kunĩo ibiknorkumrẽx ne. Ga kum ijabê raxja pumũ. Nhym bep ije me'õ jaxwe ngrireo ibiknor ne amipãnh kum ikĩnh ngrire”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ne kam nijamã kum, —Arỳm ne ba ajaxwe djàri arỳm kunĩo akno, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nhym kam me Jejumẽ ro'ã õ kwỳ krẽno kumexja abenmã kum, —Djijàk tô mỳj me'õ ne gêt me axweo biknoro ba? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nhym bep Jeju ne nijamã kum, —Ga ne ga mrãmri aje tu amim ikamnhĩxkumrẽx nhym kam Metĩndjwỳnh arỳm apytà, on adjumar mex ne tẽ, ane. Tãm ne ja. ");
INSERT INTO txuNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nhym kam tũmbê Jeju ajte pyka kunĩkôt ipôko mõ. Krĩ rũnhmẽ krĩ kryre kunĩkôt memã Metĩndjwỳnh kukràdjà'ã ujarẽnho ipôko mõ. Ne kàj bê memã kabẽn ny, kabẽn mex'ã ujarẽnh mõ. Mỳj kabẽn mex'ã? Bir, Metĩndjwỳnh kute me utàr ne me kadjy bẽnjadjwỳr ne kute ar meo bamã tãm. Tãm ne memã arẽnho ipôko mõ. Nhym kôt ba djwỳnhbê 12 kôt mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nhym me niredjwỳ kôt mõ. Mỳj me nire nã? Bir, me karõ punumẽ apỹnh me kanê djàri kute kubê me utàrjadjwỳ ne me kôt mõ. Marij me kute kum Madarena anhỹrja, kurũm ne Jeju kute me karõ punuo 7 ne apôx ne anorja. ");
INSERT INTO txuNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","'Õbê ne Djôwanã, Kudja prõ. Kudja ne kubê bẽnjadjwỳr raxbê Erodji nhõ nêkrêx pumũnh djwỳnh. 'Õbê ne Xudjana. Nhym ajte me kwỳ rax ne me kôt mõ. Be, me nire tãm ne me kôt mõn õ pi'ôk kaprĩreo aro djuw mexo mõ, o arkum mỳjja jamỳnho mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nhym me apỹnh pyka kunĩkôt Jeju'ỳr mõn bôx ne 'ã kumex. Me krãptĩ ne me 'ã akuprõ nhym kam Jeju Metĩndjwỳnh kukràdjà'ã memã mỳjja jakre. ");
INSERT INTO txuNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Nãm mekmã kum, —Ẽ, õ pur djwỳnh ne kute õ purkam bàygogore kremã 'ỳr o tẽ. 'Ỳr o tẽn o bôx ne kam ar 'yo ukabêr mrã, ane. Nãm mekbê idjaer kute mỳjja kre kadjy tu mỳjja 'yo akabê, bàymẽ bàygogore 'ymẽ, ja ne me kute purkam kremã o mrãn kam purkam o ukabêr mrã. Kute mrãmri ne me kute katẽbàri 'yo ukabêr mrãnhja pyràk. —Be, me'õ ne ar bàygogore 'yo ukabêr mrã. Nhym 'y kwỳ prykam rôrôk ne. Nhym me paro pykamã angij nhym te ingrõtmã nhym me prĩne paro pykamã angij. Nhym kwênhdjwỳ mã prĩne kuku. ");
INSERT INTO txuNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nhym 'y kwỳ kẽnpo'ã rôrôk ne ingrõt totokbê tu ingrõt mjô. Mrãmri ne kẽn'ã pyka prorrekam 'y rôrôk ne 'êx ne ingrã mex ne te kẽnmã arêo ingãn arỳm ty. ");
INSERT INTO txuNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nhym 'y kwỳ mrỳnhĩkam rôrôk ne kam mrỳnhĩmẽ ro'ã ingrõt ne. Nhym kam prĩne o akno. ");
INSERT INTO txuNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nhym bep 'y kwỳ ne pyka mexkam rôrôk ne kam ingrõt ne abatành ne ijy rũnh ne 'y krãptĩkumrẽx. Ijykam 'yja amũ o amijakren kam 'y pỹnhkôt kubê 100 ne. Tãm ne ja, ane. Nãm ã Jeju memã anen kam ajte kàj bê memã kum, —Godja ga me ajõ ajamakkre mex jabej, on ama, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nhym kam kôt ba djwỳnh abej kukij ne kum, —Mỳj'ã ne ga bàygogore kre jakre? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nhym arkum, —Bep ar amãbit dja ba mỳjja bipdjuro amirĩt ne. Metĩndjwỳnh kute ar apytàr ne ar akadjy bẽnjadjwỳr ne kute ar ar ajo baja, ar amãbit dja ba kukràdjào amirĩt ne. Nhym bep me jamã dja ba kukràdjà'ã mỳjja jakren memã arẽ, “gê me te kute mỳjja pumũnhmã ari ar abej rĩt ne te kute mỳjja marmã te ari ar amako akẽx ne mar kêtkumrẽx ne.” ");
INSERT INTO txuNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Nà, ar amã dja ba kukràdjà jarẽ. Ije kukràdjà'ã mỳjja jakreja jarẽ. 'Yja, me'õ kute 'yo ukabêrjabê ne Metĩndjwỳnh kabẽn. ");
INSERT INTO txuNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","'Y prykam rôrôkja ne me kute Metĩndjwỳnh kabẽn mar kajgoja'ã akre. Bit me kute amim Metĩndjwỳnh kabẽn markumrẽx ne 'ã ngrà tỳxmã nhym ate Xatanaj jãm meo amijakren mekbê Metĩndjwỳnh kabẽno akno. Me kute tu amim markumrẽx nhym Metĩndjwỳnh kute kubê me utàr karõ ne jãm meo amijakren mekbê Metĩndjwỳnh kabẽno akno. ");
INSERT INTO txuNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kẽnkam 'y rôrôkja ne me kute amim Metĩndjwỳnh kabẽn mar 'iry kêt ne kangaja'ã akre. Nãm me Metĩndjwỳnh kabẽn man bit kum kĩnhkumrẽx o tẽm kajgo. Kute mrãmri tu amim markumrẽx kêtê. Ajkwaobit ne kute mar. Kute 'y nhingrõt ne arê kêtkam tebê tykja pyràk. Kute amim mar 'iry kêt nhym ate apỹnh me kaprĩ djàri kute ikô'yrmã 'ỳr bôx nhym arỳm kanga. ");
INSERT INTO txuNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mrỳnhĩkam 'y rôrôkja ne me kute Metĩndjwỳnh kabẽn mar ne kam ate ajte kute jãm mỳjja marja'ã akre. Nãm me arỳm amim Metĩndjwỳnh kabẽn man kam 'ãno ãm kêt ne. Djã nãm me Metĩndjwỳnhbit man ar o ba? Kati, nãm me jãm umar punu djà 'õmẽ nêkrêxmẽ mỳjja me kute o amikĩnhjamẽ mỳjja jakôtbit amak bẽn ne ne kam amũ amim Metĩndjwỳnh kabẽn maro àrwỳ kêtkumrẽx ne. Kute mrỳnhĩ kute prĩne bàygogo nhingrõto bikẽnh nhym kam ijy kêt mexja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nhym bep pyka mexkam 'y rôrôk ja ne me kute tu amim markumrẽx ja'ã akre. Nãm me tu amim Metĩndjwỳnh kabẽn markumrẽx ne tu 'ã ngrà tỳx ne kam mũm ate ibej mỳjja 'õ mar kêt ne tu mrãmri 'ãno djan mã kôt ajkamẽ. Kute 'y nhingrõt ne abatành ne ijy mexkumrẽx ne kumex ja pyràk. Tãm ne ja. ");
INSERT INTO txuNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ba ajte ar amã 'õdjwỳ jarẽ. Djãm me kute ngônhpôkmã angjênh ne kute ngônho 'ã pro got? Ne kute ikwã djà krakri umjỳr got? Kati, ngônhpôk ne me kum angij ne tu kênhkam umjuw nhym memã kikre kre kurwỳo ku'ê. Nhym me mrãn wangij nhym prĩne memã irã. Dja gar ã abê ngônhpôk mãn pràbê ã memã Metĩndjwỳnh jarẽnho ane gê me kuma. ");
INSERT INTO txuNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ẽ, amũ akati 'õkam dja mỳjja bipdjur kunĩ amirĩt ne. Nhym mỳjja pudjurdjwỳ amirĩt nhym me kunĩ kuma. ");
INSERT INTO txuNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kam gêdja gar mỳjja kunĩ kute amirĩt kêtri prĩne ikabẽn ma. Gora ar amim aprĩn ikabẽn ma. Me kute tu amim imarkumrẽxmã dja Ibãm ijo amirĩto tẽ gê me amim imar rax. Nhym bep me ajkwaobit kute amim imarjabê dja Ibãm ijo apdju. Dja prĩne inêje me no'ã pron mekbê ijo apdju. Tãm ne ja, ane. Nãm ã Jeju arkum amijarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nhym kam Jeju nãmẽ kamy ar 'ỳr tẽ. Ar kute omũnhmã ne ar 'ỳr tẽ. Nhym me 'ã kumex. Nhym ar te 'ỳr bikamẽnhmã te 'ã meo ane. Nhym me 'ã ĩptĩ: ane. Prĩne Ar kubê utà. ");
INSERT INTO txuNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nhym kam me'õ Jejumã kum, —Ota anãmẽ akamy ar amrẽbê awỳr bôx ne akuri ku'ê, te kute apumũnhmã kikre kabem ku'ê, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nhym kam kum, —Me kute Metĩndjwỳnh kabẽn mar ne kute kabẽnkôt amijo baja, o ne ba inã, o ne ba ikamy, o ne ba inhõbikwakumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ne kam amũ akati jakam kôt ba djwỳnhmẽ ro'ã kàkam wadjàn nhỹ. Nhym kam arkum, —Gwaj gop imôti nhikjêmã rê, ane. Nhym kam ar kum, —Gêtô, ane. Nhym kam ar mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kôknhõkàkam ne ar mõ. Mõ: nhym kam Jeju õto nõ. Nhym kam arỳm kôk wabê. Àbêr tỳx nhym arỳm kam ngô aben mok ne. Nhym kam ngô kute aben mokkam arỳm kàkam ngô ipu ne. Ne arỳm àr 'ỳr. ");
INSERT INTO txuNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nhym Jeju arek õto nõ. Arek õto nõ nhym kam kôt ba djwỳnh 'ỳr prõt ne tok ne kum, —Meo ba djwỳnh, meo ba djwỳnh, gop ano tỳx, ota gwaj arỳm badjàr 'ỳr, ane. Nhym kam ekrux ne kàjmã dja. Ne kam kôkmã bẽn tỳx ne ngô kute aben moktijamã bẽn tỳx nhym arỳm ngô anhikrê nhym arỳm kôk djàbêr anhikrê. Nhym arỳm ngô anhikrên nõ. ");
INSERT INTO txuNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nhym kam Jeju arkum, —Mỳkam ne gar imar kêt ne tu amim ikamnhĩxkumrẽx kêt ne? ane. Nhym kam ar madjàkam e tuk anen kam ari aben pumũnho kumex ne kam abenmã kum, —Ije tô mỳj me'õ got ja? Nãm tu gêt kôkmã kabẽn ne ngômã kabẽn nhym tu kabẽnkôt anhikrê, ane. Arỳm ne Jeju kôkmẽ ngômã kabẽn nhym anhikrên nõ. ");
INSERT INTO txuNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nhym kam ar mõ. Mõ:n arỳm ikjêmã rê. Mekbê Djeradja nhõ pyka'ỳr rê. Aben kônh ne pykabê Garrêjamẽ mekbê Djeradja nhõ pyka. Aben kônh ne aktã akàx nhikjê'ã krĩ. Nhym kam arỳm ar ikjê'ã mekbê Djeradja nhõ pyka'ỳr rê. ");
INSERT INTO txuNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nhym kam Jeju wabi. Krĩbê Djeradjakam me kra 'õ ne me karõ punu ar o ba nhym kam Jeju bôx nhym omũn kam 'ỳr prõt ne. Amrẽbê me karõ punu kute ar o ba tũmkam ne ar kubẽkà jangjênh kêt ne ba. Kẽnkrekambit ba. Kikremã bôx kêt. Kẽnkrekambit ne ar ba, me kute kẽnkrekam me angjênh jakambit ne ar ba. ");
INSERT INTO txuNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Me karõ punu kute ar o baja ne me te kute uwpren kubê ijêmã te o ane. Nhym me karõ punu kute ar o bakam mrãmri 'itỳxkumrẽx ne. Nãm me te pa djuwpren te te djuwpre nhym tu amijã kàxiràx kukẽ. Nhym me karõ punu mã arwã'ỳr kujaêko ba, mã 'ỳr kangõ. Nãm ã me karõ punu ar o anhỹro ba. Be, tãm ne Jeju pumũn kam 'ỳr prõt ne. 'Ỳr prõt ne parbê tu mỳrbê tỹm ne amra. Nhym Jeju arỳm me karõjamã kum, —Me karõ punu on akato, ane. Nhym kam arỳm amra ne. Ne kam kàj bê kum kabẽn ne kum, —Jeju, Metĩndjwỳnh pymao kubê kumkati kra, mỳj ne ga aje ijomã? Kwãrĩk wãnh ijo abikẽnh kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nhym kam Jeju kukij ne kum, —Mã ne anhidji kute? ane. Nhym kum, —Ibê ne Krãptĩtire, ane. Me karõ krãptĩ: kute ar o ba'ã ne, —Ibê ne Krãptĩtire, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kwãrĩk wãnh ga mũm me ijanor kêt, ane. Ne kàj bê kum kabẽn ne, aminêje kum kabẽn ne, ne kum, —Kwãrĩk wãnh ga kre ry typydjija'ỳr me ijanor kêt. Kwãrĩk wãnh kam me ijo abikẽnh kêt ba me itokry kêt, anhỹro nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","33","Nhym kum ajmã angrô jamyre krãnhrekam kumex. Kute pi'ô pyràk ne àkuro kumex. Nhym kam me karõ punu Jejumã kum, —Dja ga angrô jamyre'ỳr me ijano. Dja ga angrô jamyre'ỳr me ijano ba me kum wangjê, ane. Nhym kam memã, —Rã'ã, ane. Nhym kam me karõ punu arỳm kum iren mã kurũm katon angrô jamy'ỳr mõn kum wangij. Nhym angrô jamyre umaje bõm tỹm ne pyka krã'yrkam mõn ngô to do: ane, akàx prêk'ã ne mõn nox nhym kam ngô kunĩ nhimex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nhym kam me kute õ krito djuw mex djwỳnhja omũnho dja. Omũnho djan prõt ne kam bôx ne memã arẽ. Me õ krĩkam me jamã arẽn bu'ã krĩkam me jamãdjwỳ arẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nhym kam me Jeju'ỳr prõt ne. Kute omũnhmã 'ỳr prõt ne. Nhym kam me karõ punu kute ar me'õo baja arỳm mexkumrẽx ne Jeju parbê nhỹ. Kubẽkà jangij ne nhỹ. Arỳm umar mexkumrẽx ne nhỹ. Nhym me omũn kam tĩn prãm ne. ");
INSERT INTO txuNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nhym kam me kute Jeju pumũnh djwỳnhja mekôt prõt ne ajte katon kam memã arẽnho dja, Jeju kute me'õkam me karõ punu janorja memã arẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kam pykabê Djeradjakam me jamẽ bu'ã krĩ krykam me ja ne me Jejumã kabẽn ne kum, —On me ikurũm tẽ, on mã me ikurũm tẽ, ane. Me kum uma tỳxkam ne me ã aminêje anoro ane. Nhym kam Jeju kàmã wadjà. ");
INSERT INTO txuNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nhym kam Jeju kute me karõ punubê me'õ pytàrja te kôt krà ne kum, —Ba akôt tẽ. Ba akôt tẽ, ane. Nãm te ane nhym aminêje nên kum, ");
INSERT INTO txuNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Kati, arek dja. Mã akubyn tẽn anhũrkwãkam memã amijarẽ, Metĩndjwỳnh kum akaprĩn kute apytàrkôt memã amijarẽ, ane. Nhym kam ã anen kam mã akubyn tẽn kam arỳm kikre kunĩkôt kikrepdjitã memã ar amijarẽnho ba, Jeju kum kaprĩn kute utàrkôt ar memã amijarẽnho ba. ");
INSERT INTO txuNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nhym kam Jeju kàmã wadjàn ajte akubyn ikjêmã mõn rê. Nhym me kam amako krĩ nhym arỳm bôx nhym me kam kĩnhkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Nhym kam me'õbê Djajru Jeju'ỳr tẽn bôx. Djajrubê bẽnjadjwỳr'õ, me bikprõnh djàkam bẽnjadjwỳr'õ. Ne kam Jeju'ỳr tẽn bôx ne kabem tu mỳrbê tỹm ne kam kum, —Dja ga inhũrkwãmã tẽ, ane. Ne kam kum krao no katoro dja. Kra pydji, kra prĩti ne kanên nõ. Arỳm tyk 'ỳ:r ne nõ nhym kam kum o no kato. Nhym kam Jeju kôt tẽ. Me krãptĩ Jeju'ã aô ne kunoro mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Nhym kam tẽmkôt me'õ nija kôt bôx ne 'ã kubẽkà nhidja kupê. Nãm ar kamrô apôx ba. Amrẽbê ne ar kamrô apôx ba. Arỳm 'ã amexbê 12. Nãm prĩne amijã amibê pi'ôk kaprĩ kunĩ krẽn kajgon mex kêt rã'ã ne. Nãm te me kane djwỳnh o ane. Nhym bep Jeju tẽmkôt ne 'ã kubẽkà nhidjabit kupên, tãmkam arỳm kamrô ngrà, arỳm mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nhym kam Jeju memã kum, —Mỳj me'õ ne ikupê? ane. Nhym me kunĩ aminêje kum, —Kati, kon, me'õ, me'õ, anhỹro kumex. Nhym kam Pedru kum, —Bẽnjadjwỳr, djãm me krãre: got ga “Mỳj me'õ ne ijã kubẽkà kupê”, ane. Me kute gwaj bamã ipôk mex ne kute gwaj bakunoro mõrjakam ga, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nhym kum, —Nà, arỳm ne me'õwã ikupê. Ipymao ne ba arỳm me'õwão mex ne arỳm kuma, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nhym nija te kute kubê amipdjurmãn kam ta amim, —Kati, arỳm ne kuma, anen kam 'ỳr tẽ. 'Ỳr tertet tẽ. Umaje tertet tẽn tu mỳrbê tỹm ne kum amijarẽ. Me ipôkri tu kum amijarẽnho nõ. Kute 'ã kubẽkà kupênh ne tãm kam mexkôt kum amijarẽnho nõ. ");
INSERT INTO txuNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nhym kum, —Àpnhĩre nã gãm tu amim ikamnhĩxkumrẽx ne. Aje amim ikamnhĩxkumrẽx kôt ne ba arỳm apytà. On adjumar mex ne mã akubyn tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kum kabẽno ãm rã'ã nhym bẽnjadjwỳr nhũrkwã kurũm me'õja tẽn kajpan kum, —Onĩj arỳm akra ty. Kwãrĩk wãnh ga memã ujarẽnh djwỳnhmã akrao ano kator kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nhym Jeju arỳm kuman kum, —Kwãrĩk wãnh ga akaprĩ kêt ne akrakam adjumar punu kêt. Dja ga tu akra'ã ikamnhĩxkumrẽx nhym arỳm akubyn mex ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Nãm ã anen kam mã 'ỳr tẽ. Tẽn kam ũrkwãmã bôx. Nhym me arek abej àmrao kumex. Nhym kam mekmã kum, —Kwãrĩk wãnh ga me amỳr kêt. Kati, tyk kêtê, nãm õto nõ, ane. Nhym me arỳm tyk mexkôt omũn kam Jeju'ã keketo kumex ne aprỳo kumex, ne we, —Be nãm we, “Nãm õto nõ”, ane. Nhym kam aminêje me ja nê, mekôt mõrjamẽ me kute tyk jabej àmrao kumexjamẽ aminêje me nê. Nhym bep Pedrumẽ Djuãomẽ Xijagumẽ tyk ne nõrja nãmẽ bãmmẽ ar ajbit ne ar kôt wadjà. ");
INSERT INTO txuNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nhym kam Jeju ikra 'amỳn kum, —Àpnhĩre, kàjmã nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nhym kam karõ akubyn kum wadjà nhym akubyn tĩn ne ekrux ne kàjmã nhỹ. Nhym kam Jeju nãmẽ bãm arkum, —Ar kum mỳjja 'õ ngã gê kukrẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nhym nãmẽ bãm ar abenkam no tyn dja. Nhym kam arkum, —Kwãrĩk wãnh gar memã arẽnh kêt. Dja gar tu mekbê udju, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nhym kam akati 'õkam Jeju amikôt ba djwỳnho akprõ. Kôt ba djwỳnhbê 12ja ne aro akprõ. Apỹnh me õ pyka djàri kute 'ỳr ar anormã ne aro akprõn arkum, —Ẽ, ikabẽnkôt dja gar me nêje me karõ punu jano. Ne apỹnh me kanê djàri me utàro mõ. Ba dja ba ar amã ipyma jadjà gar kam ipymao apỹnh me kanê djàri meo mexo mõn me karõ punu kute meo ba djàri kubê me utàro mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","5","Ar apa, ẽ, ba ar amã arẽ. Kwãrĩk wãnh gar anhõ mỳjja'õ byr ne o amõr kêt, akajpar djà'õ byr ne o amõr kêt, ajênh tur ne o amõr kêt, anhõ kwỳ krẽn djà, anhõ pi'ôk kaprĩ, anhõ kubẽkà'õ kwãrĩk wãnh gar o atẽm kêt. Dja gar tu anhỹkam mõ. Mõn kam apỹnh me õ pyka djàri me 'ỳr ajmà. Dja gar me'õ nhũrkwãkam bôx ne nhỹ, kwãrĩk wãnh ajte amũ amã me'õ nhũrkwã 'õ kĩnh ne 'ỳr amõr kêt. Dja gar tu bôx ne kikrekam abôxwã tãmkam tu arek kam anhikwão dja. Dja gar memã arẽnh pan kam arỳm ajte amũ pyka 'õ'ỳr tẽn ajte kikre 'õkam tãm ne. Ne ajte amũ tẽn 'õkam tãm ne. Ne ajte 'õkam tãm ne. Dja gar krĩ 'õkam bôx nhym me kum ar akĩnh kêt ne kute ar akabẽn mar prãm kêt jabej, gar kam arỳm tu amõrkumrẽx ne. Tu amõrkumrẽx kadjy amiparkà'ã pykawã tatak ne. Aje me kute akabẽn mar prãm kêtjao amirĩt nhym Metĩndjwỳnh kute omũnh ne amũ 'õkam kute memã pãnh jarẽnh kadjy dja gar amiparkà'ã pykawã tatak ne. Dja gar kàj bê memã kum, “Onĩj Metĩndjwỳnh kute ar me bapytàr ne me bakadjy bẽnjadjwỳr ne kute ar me bajo bamã”, anhỹro mõ. Ne kam kôt meo mexo mõ, ane. Nãm ã Jeju kôt ba djwỳnhmã me'ã karõo anen kam mã me'ỳr ar ano. ");
INSERT INTO txuNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ar ano nhym kam ar arỳm krĩ kunĩkôt ajmà ne kàj bê memã Jeju'ã ujarẽnh ny jarẽnho mõn kôt meo mexo mõ, apỹnh krĩ kunĩkôt ne ar ajmàn ba. ");
INSERT INTO txuNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Nhym kam bẽnjadjwỳr raxbê Erodji arỳm Jeju'ã ujarẽnh man kôt ba djwỳnh kute meo mexo mõrja arỳm adjwỳnhdjwỳ ma, ne kam te kute marmã. Nãm me apỹnh kabẽno noo biknor mex ne. Nhym te kute mỳjja marmã. Jeju'ã ne me ari kabẽn kwỳ jarẽ: ne abenmã kum, —Bep Djuão kute ngônhmã me angjênhja ne we ajte tĩn ne kato, ane. Nhym ajte me kwỳ we, —Me bakukãmãrebê Erij ne ajte kato, ane. Nhym ajte we me kwỳ, —Bep Metĩndjwỳnh kabẽn jarẽnh djwỳnh amrẽbê tyk ne ajte we tĩn ne kato, ane. Nhym kam Erodji te kute apỹnh me kabẽn ja marmã. ");
INSERT INTO txuNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ne kam ta amim, —Ije bep Djuão ne ba arỳm mut krãta. Nhym mỳj me'õ got ja ba arỳm 'ã ujarẽnh ma, ane. Ne kam te kute Jeju pumũnh prãme. ");
INSERT INTO txuNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nhym kam arỳm Jeju kute ar anor nhym ar mõrja ajte akubyn 'ỳr mõn bôx ne kum amijarẽ. Nhym kam krĩmã me umaje ar ajbit aro tẽ. Krĩ nhidjibê Bexadamã ne aro tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ar ajbit kute o mõrmã nhym ate ajte me kàtàmja kôt krãptĩ:n bôx. Nãm me abenmã Jeju mõrkôt arẽn kam ajte kôt mõ. Djã nãm Jeju me krãptĩ pumũn memã àkrê? Kati, nãm me krãptĩ pumũn kam tu memã kabẽn mex jarẽ. Nãm Metĩndjwỳnh me kadjy bẽnjadjwỳr ne kute me utàr ne ar meo bamã memã arẽ ne kam ajte kôt me kanê pytàro dja. ");
INSERT INTO txuNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nhym kam arỳm me'ã amykry tẽ. Nhym kam kôt ba djwỳnhbê 12ja 'ỳr tẽ. Jeju'ỳr tẽn kum, —Ije gop on me ano. Gop on me krãptĩja me ano gê me apỹnh krĩmã ajmàn bu'ã krĩ kryremãdjwỳ mõn wãnh kam õ kwỳ krẽn wãnh kam nõn ta amikadjy mỳjja by. Nhym nhỹnh ne mỳjja 'õ ne me kute krẽnmã ne me jakam ar ba. Arwãkam ne gwaj ar baba, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nhym kam Jeju kôt ba djwỳnhmã kum, —Ar ga dja gar mekmã mỳjja ngã gê me kukrẽ, ane. Nhym ar kam kum, —Ije kati, ar inhõ djwỳbê 5 ne tepdjwỳ amãnhkrut. Jabit. Be, djãm mỳjja rax? Nàr djãm ar imõr ne ije gwaj banhõ pi'ôk kaprĩo me krãptĩja kadjy ije djwỳ byrmã? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","E kum bep me krãptĩkumrẽx. Me my'ã akrebê 5.000. Nhym kam arkum, —Ẽ, dja gar meo 50'ã kabẽn ne me krĩo tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nhym kam kôt ba djwỳnh meo 50'ã kabẽn ne me krĩo tẽn me krĩ pa. ");
INSERT INTO txuNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nhym kam Jeju djwỳbê 5ja byn tep amẽ kubyn kàjmã krãn kàjkwa pumũn Metĩndjwỳnhmã õdjành jarẽ. Ne kam djwỳmẽ tep kokij ne kam kôt ba djwỳnhmã kungã. Nhym kam amũ memã kungã, me krãptĩjamã kungã. ");
INSERT INTO txuNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nhym me kam kukrẽ. Nhym kam me kunĩ õ kwỳ krẽn kam ajnekumrẽx. Nhym kam djwỳmẽ tepja'ã kàtàm. Nhym kam kôt ba djwỳnh anhyjao atom ne. Djwỳmẽ tep janhyjao atom nhym kam 'ã kàbê 12. Djãm djwỳmẽ tep ngri got. ");
INSERT INTO txuNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nhym kam 'õkam Jeju ate mekbê tẽn kam Metĩndjwỳnhmã amijarẽnho nhỹ. Nhym kôt ba djwỳnhbit kuri krĩ. Nhym kam Jeju kute amijã ujarẽnh marmã abej ar kukij. —Ẽ, ar imã ijã me ujarẽnh jarẽ ba kuma, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nhym ar kam kum, —Ije kum be nãm we me ajo Djuão kute ngônhmã me angjênh djwỳnhja, nhym me kwỳ ajo me bakukãmãrebê Erij, nhym me kwỳ ajo Metĩndjwỳnh kabẽn jarẽnh djwỳnh tũm ajte akubyn tĩn ja'õ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nhym kam arkum, —Ne ar gadjwỳ mã ne gar imar on? Mỳj'ã ne gar ijakre? ane. Nhym kam Pedru kum, —Kati, abê ne Kritu. Abê me inhõ Bẽnjadjwỳrbê kumkati. Metĩndjwỳnh amrẽbê kute me bakukãmãremã ajarẽnh ga aje me ipytàr ne aje ar me ijo abamã amrẽbê kute me imã ajarẽnh ba me ije ar akam amako iba, ne arỳm Metĩndjwỳnh ajano ga arỳm bôx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nhym kam arkum, —Nà, kôtô. Kwãrĩk wãnh gar memã ja jarẽnh kêt. Dja gar tu mekbê ipudjurkumrẽx ne, ane. Ar kute udjurmã ã arkum arẽnh tỳxo ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ne ajte arkum, —Ẽ, dja me prĩne ijo ajkẽ, ba itokry rax ne. Ba ije amijo inhĩ ne me awỳr irwỳk ba dja ba itokry rax ne. Dja mebêngêttemẽ me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ kum ikĩnh kêt ne ikanga ne kam tu ibĩ nhym ijã akati amãnhkrut ne ikjêkêt ba kam akubyn itĩn ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ne kam ajte me kunĩmã kum, —Gêdja ga me ajõ mã ikôt abikamẽnh prãm jabej kwãrĩk wãnh amidjwỳnhbit mar ne amijo kĩnh kêt. Dja ba ityk kadjy inhõ pĩte'y mỳn itokry: ne. Dja ga me ajõ ijã amijakren aje pĩte'y mỳnh mãn pràbê amã atokry pyma kêt ne amã ijabê rã'ãn kam myt kunĩkôt ikadjy amiman mã ikôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Me kute amidjwỳnhbit mar ne me kum tokry pyma, me tãm gêdja me tyn kam me biknor tokry djàkam tẽ. Nhym bep me kum ijabêkumrẽx ne kute amidjwỳnhbit mar kêt nhym me kute me par jabej me tãm gêdja me amiptàn ar tĩn ne ba rã'ã: rã'ã. ");
INSERT INTO txuNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ne ren me'õ pykabê mỳjja mexja kunĩ, nêkrêx kunĩ ren ari o atom ne o ban kam ren ty, je mã dja kam nẽ? Kati, nãm ren ty nhym ren õ nêkrêxja ren wãnh kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Godja me'õ ikam pijàm ne ikabẽnkam pijàm jabej ba badjwỳ amipãnh kam ipijàm ne. Ba ije amijo inhĩ ne me awỳr irwỳk gêdja ba amipãnh tãwãkam ipijàm ne. Dja ba ajte iraxo me awỳr bôx. Ibãmmẽ kadjy mrãnh djwỳnh jadjênhmẽ umao ipyma:n me awỳr bôx. Ibê kumkatio bôx nhym tãmja ikam pijàmja ba badjwỳ arỳm amipãnh kam ipijàm ne. ");
INSERT INTO txuNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ba me amã arẽ. Ibãm dja ijã bẽnjadjwỳr rax mẽ ba ipymao me apytàn ar me ajo iba. Dja gar adjãmja akwỳ atĩnri iraxkôt ipumũ, me akadjy ibẽnjadjwỳr rax ne ipymakôt ipumũ. Mrãmri ne ba ikabẽnja, ane. Nãm ã Jeju memã kabẽn jarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nhym 'ã pi'ôk kamrêk pydji nhym aro tẽ, Pedrumẽ, Xijagumẽ, Djuão aro tẽ, krãnh'ỳr aro tẽn imõkmã aro bôx. Kute Bãmmã amijarẽnhmã ne 'ỳr aro bôx. Ne kam Bãmmã amijarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bãmmã amijarẽnho dja nhym ajmã nokre o nhym atemã nokre nhym 'ã kubẽkàdjwỳ aka: ne. Akakam adjênh ne. ");
INSERT INTO txuNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Nhym ar my amãnhkrut ne kum kabẽno dja. Môjdjêmẽ Erij ar amrẽbê tyk, ar tãm ne ar katon kum kabẽno dja. Nãm ar adjênh ne uma:kumrẽx ne kum kabẽno dja. Jejumẽ ne ar abenmã kabẽno dja. Jeju tyk'ã ne ar abenmã ujarẽnho dja. Krĩraxbê Djeruxarẽkam me kute bĩnmã ne ar abenmã arẽnho dja. Metĩndjwỳnh kute tykmã kum 'ã karõkôt ne ajte ar 'ỳr bôx ne kôt abenmã arẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nhym Pedru ar õtdjwakumrẽx ne arek õto ikwã. Ne kam no tỳx ne kam Jeju pyma, adjênhkôt omũ nhym amẽ ar kuri ãmjadjwỳ tãm ne. Kam kubẽkà jadjênh ne kam mexkumrẽx ne ku'ê. ");
INSERT INTO txuNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nhym arỳm ar amẽ tẽm 'ỳr dja nhym Pedru Jejumã kum, —Bẽnjadjwỳr, mrãmri ne bar jakam bôx ne akuri nhỹ nhym mexkumrẽx ne. Bar apỹnh ar amã kikre'ã irõx nhipêx, ga anhõmẽ, Môjdjê nhõmẽ, Erij nhõmẽ. Amãnhkrut ne ikjêkêt dja bar ar amã ipêx, ane. Kute amikabẽn'õ mar kêt. Pedru ta ne amikabẽn'õ mar kêtkam ãm tu arĩk kabẽn ja jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kum kabẽno ãm rã'ã nhym kam kakrã arỳm prĩne aro akno. Nãm kakrã kute prĩne aro biknorkam arỳm ar tĩn prãm ne. ");
INSERT INTO txuNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nhym kam kakrã kurũm Metĩndjwỳnh arkum kabẽn ne arkum, —Be, ikra ne wã. Ar omũ. Ikra ja ne ba àpênh kadjy amijo utàn amim kudja. Tãwã dja gar kabẽn man kabẽnkôt mrã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","37","Nãm ã arkum kabẽn anen anhikrê nhym kam Jejumẽ kôt ba djwỳnh ar ate ku'ê. Amẽ ar myja arỳm mã nhĩ'ãm tẽ. Nhym akati nhym kam Jeju akubyn krãnhre kurũm aro ruw. Aro ruw ne kam mã aro mõ. Aro mõ nhym me krãptĩ ar kutã mõn ar kajpa. Djãm kam got ar kute Jeju jadjênhkôt omũnhja memã arẽ? Kati, Jeju ar pykabê bari ne ar mekbê udju ne. ");
INSERT INTO txuNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nhym me ar kajpa nhym me ipôkri me'õ myja kàj bê kum akij, —Bẽnjadjwỳr, gop ikraja pumũ. Ikra myja ne pydjii. ");
INSERT INTO txuNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ota me karõ punu'õ ar ibê ikra paro ba. Nãm 'ỳr ban bôx nhym ar ijaêrbê tu amra: ne. Nãm amran rôrôk ne àmnhirẽnho ikwã, ajmrô prõto ikwã. Ne kam kute amijo pyka titik kurêje prĩne amingã. Kute kum irer prãm kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nã bãm te akôt ba djwỳnhjamã ikrao a'uw nhym kute imã ikra pytàr kêtkumrẽx, te kute imã utàrmã te o ane, ane. Nãm ã Jejumã kra jarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nhym kam Jeju me'ỳr akẽx ne memã kum, —Ije me akamingrãny aje amim ikamnhĩx kêtkumrẽx. Me ajaxwe. Mã dja ijã akati, akamàt kô kute ba me akam arek ar iba. Nã bãm me awỳr bôx ga me ajamakkre kêtkumrẽx ne prĩne akabẽno ikaty. Nã bãm te amiwỳr me akam ama ga me arĩk ar aba, ane. Ne ajte bãmjamã kabẽn ne kum, —Amrẽ akrao tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nhym kam 'ỳr tẽn pa 'amỳn Jeju'ỳr o tẽ. 'Ỳr o tẽmràm nhym ajte me karõ punuja o pyka kôpênàt ne. Krajao pyka kôpênàt nhym àmnhirẽnho nõ. Nhym Jeju me karõ punujamã bẽn tỳx nhym umaje bõm tỹm. Nhym kam Jeju kum krao mex ne akubyn bãmmã kungã. ");
INSERT INTO txuNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nhym me kôt omũ, Jeju kute Metĩndjwỳnh pymao o mexja me kôt omũ ne ari aben pumũnho kumex. Djãm Metĩndjwỳnh pyma ngri got. Nhym me Jejukam no tyn kumex rã'ã nhym Jeju kôt ba djwỳnhmã kum, ");
INSERT INTO txuNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Gora ar amijamakkrekam ikabẽn janhô. Ẽ, ba ije amijo inhĩ ne me awỳr irwỳk gêdja me memã ikanga, ikurê djwỳnhmã ikanga, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nhym ar kute kabẽnja mar kêtkumrẽx. Nãm ar ajmã amakkre nẽ, te kute marmã. Ne kam te kute kukjêrmãn kam pijàm ne. ");
INSERT INTO txuNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ne kam kabẽno aben japanho mõ, kôt ba djwỳnhja kabẽno aben japanho mõ. Mỳj mỳr jabej? Bir, nhỹnh kôt ba djwỳnhja 'õ gêdja bẽnjadjwỳr raxo aben jakre. Ja mỳr jabej ne me kabẽno aben japanho mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nhym Jeju kôt ba djwỳnh kute kabẽno aben japanho mõrja kute ar tãri amako mar kêt. Nãm tu mũm kuma ne kam me'õ prĩre pa 'amỳn amijakỳxkôt kudja. ");
INSERT INTO txuNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kudjan arkum, —Ẽ, gar me'õ prĩreja pumũ, kàtàm mexja pumũ. Dja me'õ ikôpdji'ã kum me'õ prĩreja, me'õ kàtàmja kĩnh ne kam arỳm badjwỳ kum ikĩnh ne. Dja me'õ kum ikĩnh ne kam kum Ibãmdjwỳ kĩnh ne, Ibãm kute ijanorjadjwỳ kum kĩnh ne. Ẽ, me'õ kàtàm mex gêdja ja pãnh bẽnjadjwỳr rax ne, ane. Nãm ã Jeju kôt ba djwỳnh kute amijo rax prãmjamã kabẽn jarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nhym kam Djuão kum, —Bẽnjadjwỳr, ba amã arẽ. Me'õ gwaj bakôt ba kêt'õ ne tu me karõ punu kute me'õo bamã anhidji jarẽ. Kum anhidji jarẽn me karõmã kum, “Ba Jeju kukwakam amã ikabẽn. On kum anhire”, ane. Nãm ã kum anhỹro dja, bar arỳm omũ. Ne kam gwaj bakôt ba kêtkam bar kum, “Kwãrĩk wãnh”, ane. Nãm ã Djuão kum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nhym kam kum, —Kati, kwãrĩk wãnh 'ã kum akabẽn kêt. Ba ar amã arẽ. Me'õ kute ar ajo kurê djwỳnh kêt ne arỳm tu mrãmri ar ajo õbikwa, ane. Nãm ã Jeju kum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nhym arỳm Bãm kute kàjkwamã o àbirmã arỳm õ akati 'ỳr bôx 'ỳr. Nhym kam krĩraxbê Djeruxarẽmã krà. Nãm te kam mỳjja pyma, mỳjja tokry nhym tu 'ỳr tẽmmã kràn kam 'ỳr tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ne kam 'ỳr tẽmkôt amikukãm kôt ba djwỳnh kwỳ jano. Ar mrãnh ne me bajtem, Xamarijkam me jakam bôx ne kam kute Jeju kutêp ikwã djà jabej ne kum õ kwỳ krẽn djà jabej nhym bôx ne kam kam õ kwỳ krẽn ne kam nõr kadjy nàràm amikukãm 'ỳr ar ano. 'Ỳr ar ano nhym ar mrãn bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bôx nhym kam Xamarijkam me ja aminêje ar ano. Jejumẽ kôt ba djwỳnh Ar kubê idjaerkam. Ne mekbê idjaer nhõ pykabê Djeruxarẽ'ỳr mõrkam. Kam ne Xamarijkam me ja kum ar kurêkumrẽx, me kute abeno kurê djwỳnh tũmkam. Kam ne me kum ar kurên kum ar kĩnh kêt ne tu aminêje ar ano. ");
INSERT INTO txuNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nhym kam kôt ba djwỳnhbê Xijagumẽ Djuão ar me omũn kam Jejumã kum, —Bẽnjadjwỳr, dja bar kuwy'ã Abãm 'wỳ gê kàjkwa kurũm kuwy tỹm ne prĩne me kuga gê me xêr, nẽn, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nhym ar'ỳr akẽx ne ar omũn arkum bẽn tỳx ne, —Kati, kwãrĩk wãnh, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nhym ar kunĩ ajte tu atemã krĩ 'õ'ỳr mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","'Ỳr mõ nhym me'õ kum, —Ẽ, ba arek akôt tẽ. Dja ga nhĩ'ãm amrãnh katã ba akôt mrã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nhym kam kum, —Ẽ, ga djoti pykakam kreja pumũ. Ne kwênh kỳjrũm aêja pumũ. Mrymẽ kwênhbit ne õt djà, kute amim pyka kre pumũnhkôt kam õt djà, nhym bep kati, ba ne ba inhõ kikre kêt, inhikwã djà kêt. Ije amijo inhĩ ne me awỳr irwỳk nhỹnh ne inhõ kikre ja? Nhỹnh ne inhikwã djà ja? Kati. Kon, gop ga amiman kam ikôt atẽm jabej nàr kon arek dja, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ne kam ajte ta me'õmã, —Ikôt tẽ. Ikôt tẽn mã ikôt ajkamẽ, ane. Nhym kam kum, —Adjỹm, Bẽnjadjwỳr, ibãm kumrẽx gêdja ba akubyn tẽn adjà. Ibãm ne ajbir ibê ty, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nhym Jeju kum, —Gê me kute Metĩndjwỳnh mar kêt wãnh me tyk jadjà. Me kute mar kêt ne me kute mrãmri ne me tyk jamakkre kêt pyràk. Gê me wãnh õbikwa tyk jadjà, ane. Nhym bep ga dja ga ikôt Metĩndjwỳnh'ã adjujarẽnh tẽ, Metĩndjwỳnh me akadjy bẽnjadjwỳr ne kute ar me ajo bamã gêdja ga 'ã adjujarẽnh tẽ, ane. Nãm ã Jeju kum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nhym me'õjadjwỳ Jejumã kum, —Bẽnjadjwỳr, ba dja ba akôt tẽ. Inhũrkwã kumrẽxkam dja ba inhõbikwamã amijarẽn kam akôt tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nhym kum, —Djãm me purkam àpênh katẽri kute kum irer got? Kati, mỳjja wãkam ne me apên àpênh mrãn tu àpênh inomã rẽnhkumrẽx ne. Djãm me kute Metĩndjwỳnhdjwỳ maro ban konenh krãkàr got? Kati, dja ga tu amim maro tẽn tu maro atẽmkumrẽx ne. Dja ga maro mõn mar konenh krãtan kam Metĩndjwỳnh nhõ pyka'ỳr abôx kêtkumrẽx ne. Metĩndjwỳnh kute me utàr ne me kadjy bẽnjadjwỳr ne kute ar meo baja dja ga 'ỳr abôx kêt ne, ane. Nãm ã Bẽnjadjwỳr Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nhym kam Jeju kute arkum arẽnh nhijukri ajte amim ar kwỳ rax ne ar umjuw. Me kwỳo 70 ne amim ar umjuw. Nãm amim aro aben nhikjê'ã kabẽn ne amim ar umjuw, kute ar anor kadjy. Kute ar anor nhym ar kukãm mõr ne kumrẽx pyka kunĩkôt, krĩ kunĩkôt mõrmã. Dja ĩ Jeju ar kudjwa ã ane, ar kudjwa krĩ kunĩkôt bôx mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ne kam kute ar anor nhym ar mõr kutã prĩne me'ã arkum karõ ne arkum, —Me kute Metĩndjwỳnh mar prãmja ne me kumex. Nãm me kute mrãmri ne bày arỳm abôr tyk ne kumexja pyràk. Nhym bep Metĩndjwỳnh'ã ujarẽnh djwỳnh ne ngrêre kute bàykam me àpênh djwỳnh ngrêre ja pyràk. Kam dja gar me kadjy Metĩndjwỳnh 'uw gê me'ỳr 'ã ujarẽnh djwỳnh jano gê me kuman kam tu amim kamnhĩxkumrẽx. Kute mrãmri ne me mrãnh ne kute me õ purkam bày pumũnh ne mrãnh ne bôx ne kute kadjy me õ pur djwỳnhmã arẽnh nhym me kute amũ kadjy me kwỳmã arẽnh nhym me ban kute memã ê ja pyràk. Dja gar ã me kadjy Metĩndjwỳnh 'wỳro ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ẽ, on dja gar mõ. Arỳm ne ba ije me'ỳr ar ajanormã. Ar aje memã ijarẽnhmã ne ba ar ajano. Dja gar me kam bôx nhym me ikôpdji'ã ar ajo kurê djwỳnh ne kum ar apar prãmkumrẽx ne. Kute mrãmri ne rop kute mrykĩ'ãtomti kra par prãmkumrẽx ja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ẽ, dja gar tu anhỹkam mõ. Kwãrĩk wãnh gar anhõ katõk'y djà jamành kêt ne ajênh tur ne o amõr kêt. Ne aparkà 'õ byr kêt. Dja gar ajamãnhkrut'ã kabẽn ne pyka kunĩkôt aben ngrà. Kwãrĩk wãnh gar apỹnh krĩ djàri kôt ajmà gê me'õ ar ajõ kajpan amã kabẽno akukrào ãm kêt. Dja gar tu amrãnhkôt me'õmã akabẽn jarẽnho tẽn tu mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Dja gar mrãn bôx ne me'õ nhũrkwãmã wadjàn kam kum, “Gora adjumar mex ne ar aba”, ã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Dja umar mex prãm jabej arỳm mrãmri akabẽnkôt umar mexkumrẽx ne. Nhym bep djãm kum umar mex prãm kêt ne kam ũrkwãkam me jamẽ ro'ã umar punu mex ne ar ba. Me jabit dja me umar punu. Gar kam gajbit adjumar mex ne ar aba. ");
INSERT INTO txuNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dja gar kikrekam abôxwã tãmkam tu arek kam anhikwão dja. Kwãrĩk wãnh gar bôx ne kikrekôt ar aba kêt. Dja gar kikrekam abôxwã tãmkam gê me ar ajo djuw mex ne ar amã mỳjja ngã gar krẽ, tu kam apijàm kêtkumrẽx ne krẽn kôt ikõn adjumar mexkumrẽx. Ar aje memã Metĩndjwỳnh'ã adjujarẽnh pãnh, ar aje memã 'ã adjujarẽnho aku'ên atyk djà pãnh dja gar tu anhõ kwỳ krẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Dja gar krĩ 'õkam bôx gê me kum ar akĩnh ne ar akam ukaprĩ jabej ar amã mỳjja ngã gar tu krẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Krĩwãkam ar abôxwã, kam me kute ar amã kabẽn mex jarẽnh tãmkam gêdja gar me kanê pytàn memã kum, “Arỳm ne Metĩndjwỳnh me akadjy bẽnjadjwỳr ne kute me apytàr ne kute ar me ajo ba 'ỳr. Arỳm ne me ajo rãm ne ja”, ane. Dja gar ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nhym bep djã gãm ar krĩ 'õkam bôx nhym me kum ar akĩnh kêt ne aminêje ar ajano gar kam tu me ipôkri memã akabẽn jarẽnho tẽ. Ne memã kum, ");
INSERT INTO txuNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ẽ, dja bar me abê me anhõ pyka ja amiparkà'ã tatak ne. Ar ije me ajaxweo amirĩt ga me aje omũnh kadjy. Gora me ar ikabẽnja ma. Ẽ, arỳm ne Metĩndjwỳnh me akadjy bẽnjadjwỳr ne kute me apytàr ne kute ar me ajo bamã ga me ate amã kĩnh kêt ne ar imã, ‘Kati, me ije akabẽnwã mar prãm kêtkumrẽx’, ane. Me aje ã ar imã anhỹrkam ne bar me abê me anhõ pykaja amiparkà'ã tatak ne.” ");
INSERT INTO txuNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Dja gar ã memã akabẽn jarẽnho ane. Ẽ, ba ar amã arẽ. Krĩ wãkam me wã ar aje mebê amiparkà'ã me õ pyka tatakja me tãm gêdja me tokry rax ne. Metĩndjwỳnh kute memã axwe pãnh jarẽnh nhõ akatikam godja krĩwãkam me wã meo bikẽnh raxo Xôtômakam me ja jakrenh mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Watĩ:re Koradjikam me wã. Watĩ:re Bexadakam me wã. Dja ga me atokry rax ne. Ba ren me bajtem nhõ pykabê Xirumẽ Xidõkam ren mỳjja rũnhja, mỳjja pumũnh kêt ja kwỳ 'y nhym ren me omũn ren arỳm amrẽbê amim katon ren wãnh amijaxwemã ire. Ne ren kute kum irero amirĩt kadjy kubẽkàbê exopa jangijn ren amijã mro prà tatak ne. Ne ren kam iwỳr amijo akẽx. Nhym bep kati, inhõ me wỳnhkam me ga, Koradjikam me gamẽ Bexadakam me gamẽ me akam ne ba te mỳjja pumũnh kêt kwỳ rax ne ipêx ga me omũnh kajgon kam ajaxwemã anhirer kêt ne iwỳr amijo akẽx kêtkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Metĩndjwỳnh kute memã axwe pãnh jarẽnh nhõ akatikam godja me ajo bikẽnh raxo me bajtem nhõ pykabê Xirumẽ Xidõkam me ja jakrenh mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Krĩraxbê Kapanakam me gadjwỳ djãm me aje amijo adjàmran aje amijo raxmã? Djãm me aje amijo rax ne aje araxo aje kàjkwa têpmã? Kati, dja Metĩndjwỳnh aparmã me biknor tokry djàmã me amẽ ga kam me atokrybit ma. ");
INSERT INTO txuNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nà, dja gar aben nhikjê'ã kabẽn ne pyka kunĩkôt ajmàn memã ijarẽ. Godja me'õ ar akabẽn man badjwỳ ikabẽn ma. Nhym ate me'õ kum ar akurên ar akabẽn mar kêt ne badjwỳ kum ikurên ikabẽn mar kêt ne. Dja me'õ badjwỳ kum ikurên ikabẽn mar kêt ne ne Ibãm kute ijanor djwỳnhjadjwỳ kum kurên kabẽn mar prãm kêt ne, ane. Nãm ã Jeju aro 70 ne kute ar anor kutã arkum kabẽn jarẽnho anen kam aro aben nhikjê'ã kabẽn ne ar ano, pyka kunĩkôt ar bimànhmã ar ano. ");
INSERT INTO txuNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nhym ar mõn memã Metĩndjwỳnh'ã ujarẽnh mõn me kanêbê me utàro mõ:n kam akubyn mõ, kĩnhkumrẽx ne akubyn mõ. Mõn bôx ne kam Jejumã kum, —Bẽnjadjwỳr, nã bãm ar akabẽnkôt me karõ punu jano nhym me karõ punu anhidji jarẽnh kajgokambit apymaje prõt ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nhym kam arkum, —Ã, me karõ punu ne gar ano. Nhym bep arỳm ne me karõ nhõ bẽnjadjwỳrbê Xatanaj kàjkwa kurũm tẽn tỹm ba arỳm omũ. Nãm amikrà kêt mex ne tỹm kute na jadjênh tamikrà kêt mex ne rôrôk ja pyràk. Gar aje Xatanaj nhõ àpênh kujaêko amõro aje arỳm pa nhikjê 'yr rax mexja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Be, arỳm ne ba ar amã ipyma jadjà gar te kangãmẽ makmẽ mry kakrit djàkrêja kunĩ 'ã aku'ê nhym mỳjja ipymaje ajmã ar ajo kêtkumrẽx ne. Nhym te me bakurê djwỳnh pyma gar ipymao tu kujate nhym ajmã ar ajo kêtkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Be, ja ne kajgo. Me karõ punu ar akabẽn pymaje prõt ja ne kajgo. Tãm ne ngrire. Nhym bep kàjkwakam Metĩndjwỳnh kute ar anhidji'ã pi'ôk no'ôk ja ne mrãmri rax. Tãm ne kubê kumkatikumrẽx. Kam dja gar tu akĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nãm ã Jeju kôt ba djwỳnhmã anen kam arỳm kĩnhkumrẽx ne. Metĩndjwỳnh Karõ ne kum kĩnh jadjà nhym kam kĩnh rax kato. Ne kam Bãmmã amikĩnh jarẽn kum, —Djũnwã, ota ga anhõ kàjkwan anhõ pyka djwỳnh. Amã ne ba amikĩnh jarẽ. Nã gãm me amikukãm umarmẽ me kute mỳjja mar rũnhjabê mỳjja ja pudju ne kam me kute amijo prĩre pràbê amijo rũnh kêtjamã mỳjjao amirĩt ne. Mrãmri Djũnwã, nã gãm ã aje anhỹrkam mrãmri mexkumrẽx. Adjukaprĩkam ne ga amim me'ã karõ ne arỳm ã meo ane. Ba kam badjwỳ ikĩnhkumrẽx ne wãm amã amikĩnh jarẽ. Nãm ã Bãmmã amijarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ne kam ajte kôt ba djwỳnhmã kum, —Ibãm ne imã kukràdjà kunĩ jarẽ ba kam ar o iba. Nhỹnh ne jakam me'õ prĩne idjàtàri? Kati, Ibãmbit ne prĩne kute imar ne kute arỳm prĩne idjàtàri. Nhym Ibãmdjwỳ. Nhỹnh ne me'õ kute ikudjwa noo Ibãm pumũnh ne kute kukràdjàkôt mar? Kati, bajbit. Bajbit ne ba prĩne inoo Ibãm pumũn kam idjukabikôt me kwỳmã kukràdjà'ã idjujarẽnh tẽ. O me kwỳmã o amirĩt nhym me arỳm prĩne ikôt kuma, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ne kam kôt ba djwỳnh'ỳrbit akẽx ne me kàxã ar amakri arkum arẽn arkum, —Ar ga ne gar akĩnhkumrẽx. Ar ga ne gar anoo mỳjja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ba gop ar amã arẽ. Me kute Metĩndjwỳnh kabẽn jarẽnh djwỳnh tũmmẽ me bẽnjadjwỳr tũmdjwỳ krãptĩ te kute omũnh prãme, ar anoo aje mỳjja pumũnhja te kute omũnh prãme, ne ar ajamako aje mỳjja marja te kute marmã. Nhym bep kati, ar gajbit ne gar anoo mỳjja pumũnh kêt kwỳ pumũn mỳjja ma. Ar ga ne gar akĩnhkumrẽx ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nhym kam akati 'õkam Môjdjê kukràdjà mar djwỳnh'õ Jeju kabẽn maro nhỹ. Kabẽn maro nhỹn kàjmã dja. Môjdjê kukràdjà mar djwỳnhja kàjmã dja. Kute Jeju no mex jabej kabimã kàjmã dja. Kute Môjdjê kukràdjà jabej Jeju kukjêrmã, Jeju kute kukràdjà kupa'ã arẽnh kadjy nàràm ne amikadjy kàjmã 'ỳr djan kum kabẽn ne kum, —Bẽnjadjwỳr, mã gêdja ba amijo nhym kam Metĩndjwỳnh pãnh imã itĩn rã'ã rã'ão itĩnmã imã arẽ? ane. Nhym kam kum, ");
INSERT INTO txuNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","—Mã ne Môjdjê kukràdjà'ã pi'ôk no'ôk kute? Mỳj ne ga kam omũn arỳm ama? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nhym kam Môjdjê kukràdjà mar djwỳnh Jejumã kum, —Nãm, “Me anhõ Bẽnjadjwỳr djwỳnh, me Atĩndjwỳnh dja ga amã kĩnh, amã abêo katàt me kunĩ, mỳjja kunĩ jakre. Djãm ajajkwaobit amã Metĩndjwỳnh jabêmã? Kati, ajamak, akadjwỳnhbê, akukràdjà kunĩo dja ga me amã abê. Ne ajte amã amibu'ã me ja jabê. Kute ga amã amijabêja pyràk dja ga ã amã amibu'ã me ja jabêo ane”, ane. Nãm ã Môjdjê kukràdjà'ã me bamã pi'ôk no'ôko ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nhym Jeju kum, —Nà, kôt ne ga arẽ. Dja ga ã ar o anhỹro aban kam arỳm tu atĩnkumrẽx ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nhym kam Môjdjê kukràdjà mar djwỳnh õkre kadjwỳnhbê amim, —E kum kati, imã Metĩndjwỳnh jabê rax kêtê, ne imã ibu'ã me ja jabê rax kêtê, ane. Ne kam pijàm ne amijã maje, —Nhym ne ibu'ã dja ba imã abê? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nãm Jeju kukij nhym kam kum, —Ẽ, me'õ ne Djeruxarẽ kurũm krĩraxbê Djeriko'ỳr ruw. Ne kam tẽ. Tẽ nhym kam arỳm me àkĩnhĩ wỳnhràm kum nõn tẽmràm o arĩn kubê kubẽkàmẽ kubê mỳjja kunĩo prõt ne kam titik ne mã prõt ne. Nhym kam wãnh wakrekam tyko nõ. ");
INSERT INTO txuNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tyko nõ nhym kam me kadjy Metĩndjwỳnh mar djwỳnh'õ pry'ã tẽ. Tẽn omũn kam irôbê apan mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nhym mekbê Rewi'õ, adjwỳnhdjwỳ Metĩndjwỳnhmã àpênh'õ kôt tẽn adjwỳnhdjwỳ tãm ne. Nãm 'ỳr tẽn irãn omũn tẽn irôbê apan mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nhym bep me'õ, Xamarijkam me ja 'õ ne arkôt tẽ. Xamarijkam me ja kute me bajo kurê djwỳnh ja 'õ ne arkôt tẽ. Arkôt tẽ:n 'ỳr bôx ne omũn kam kum kaprĩ ne. Omũn kam rerek ne kum kaprĩ. ");
INSERT INTO txuNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ne kam me kute o tỹm ne kute titik kurêje kute apỹnh kà rênhja kum oy. Kadjwati kangôo kum oyn kam ajte mỳjja kute rõny kangô pyràko kum oy. Ne kam kubẽkào kupu. Prĩne kupun kam ta õ mryja'ã kudjin o tẽ. O tẽn atemã me'õ nhũrkwã'ỳr o bôx ne kam prĩne o djuw mexo dja. ");
INSERT INTO txuNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nhym akati nhym kam pi'ôk kaprĩ raxja amẽ kaba. Õ kikre djwỳnhjamã kaban kum kungãn kum, “Ẽ, dja ga prĩne imã tãmjao djuw mexo dja, prĩne ikutêp imã o djuw mexo dja. Dja ga 'ã aje pi'ôk kaprĩ krẽn jabej ba kam bôx ne arỳm ajte amã o pãnh, ajte akubyn ibôxkam”, ane. Be, tãm ne ja. Nãm ã Xamarijkam me ja'õ kum kurê djwỳnh kaprĩn o djuw mexo ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Gop imã arẽ. Nhỹnh ar 'õja ne kute o kamy? Djãm tẽm ne kute omũnh ne irôbê àpanhja? Nàr kon, djãm kôt tẽmja? Nàr kon djãm Xamarijkam me ja'õ? ");
INSERT INTO txuNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nhym kam kum, —Nà, me'õ kum kaprĩja. Me'õ kum kaprĩja ne o kamy, ane. Nhym kam kum, —Nà, kôtô. Nà, ga kam gadjwỳ tẽn ã kudjwa akurê djwỳnho anhỹro aba, ane. Nãm ã Jeju Xamarijkam me ja'õ ukaprĩkôt kute kurê djwỳnho kamyja'ã ujarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nhym kam Jeju ar mã mõn kam atemã krĩ 'õkam bôx. Kam ne me'õ nire nhidjibê Mata. Mata ne ukaprĩkumrẽx ne kam Jejumã kum, —Amrẽ inhũrkwãmã tẽn kam anhõ kwỳ krẽn kam nõn akôkam kôt, ane. Nhym kam kum, —Ã, aj mã, ba kam wãm akôt tẽ, anen kam ũrkwãmã tẽ. Ũrkwãmã tẽn kam 'ỳr wadjàn nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nhym Mata kanikwỳnhbê Marijja nhỹ. Arek Bẽnjadjwỳr'ỳr tẽn parbê nhỹn kam kàjmã kôt õkren kabẽn maro nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nhym Mata àpênh ra:x ne. Jeju õ kwỳ krẽn mex kadjy ne àpênh raxo djan kam Marijmã kabẽn ne. Marij kute kôt kum mỳjja 'õ kupênhmã. Ne kam Jeju'ỳr tẽn kum, —Bẽnjadjwỳr, djãm aje imar kêt? Ikanikwỳnh ne ikôt àpênhmãn ate ari akuri ba. Ba kam bajbit ar mỳjja kupênho iba. On amrẽ ano gê tẽn gop ikôt apê, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nhym kam Bẽnjadjwỳr kum, —Àpnhĩre, àpnhĩre Mata. Nã gãm ari mỳjja man kam akabẽn wã jarẽ. Nã gãm mỳjja krãptĩ kupê ne kôt mar ar o aban kam adjumar punu. ");
INSERT INTO txuNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nhym bep mrãmri mỳjja pydji ne mexkumrẽx. Tãm ne arỳm Marij o nhỹ. Nãm ikabẽn maro nhỹ. Ja ne mexkumrẽx. Kwãrĩk wãnh arek ikabẽn maro nhỹ. Wãm ije awỳr anor prãm kêtê. Gêdja arek ikabẽn maro nhỹn prĩne ikabẽn man kam o biknor kêtkumrẽx, ane. Nãm ã Jeju ane. Tãm ne ja. ");
INSERT INTO txuNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nhym kam Jeju akati 'õkam Metĩndjwỳnhmã amijarẽnho dja. Kum amijarẽnho djan kum amijarẽnh pa nhym kam kôt ba djwỳnh'õ kum, —Bẽnjadjwỳr, gop ar imã arẽ. Ar ije Abãmmã amijarẽnh kadjy gop ar imã arẽ. Mã dja bar kum ikabẽn ja o? Djuãobit ne kôt ba djwỳnhmã kabẽn'ã karõ. Gadjwỳ dja ga ar imã 'ã karõ bar akudjwa Abãmmã amijarẽnho iba, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nhym kam arkum, —Ẽ, dja ga goja ar aje Metĩndjwỳnhmã amijarẽnh kadjy kum, “Djũnwã, gê me ame:xo amex man amim ajarẽn abenmã ajarẽ. On me kadjy abẽnjadjwỳr ne ar meo aba. ");
INSERT INTO txuNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Myt kunĩkôt ar ijajkwa mãnhkutã mã ar imã inhõ kwỳ krẽn djà ngã. ");
INSERT INTO txuNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Dja bar akam ijaxwe ga tu ar ijaxweo akno. Ar badjwỳ dja me'õ ar ikam amikrà bar akôt tu o akno. Kam dja ga ar ijaxweo akno. Godja me kute ar imã axwe'ã àpnênh katã ga ga ar ijo tỳx bar mebê idjãm tỳx ne ijaxwe kêt. Tãm ne ja.” Dja gar ã kum anhỹr ar aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ne kam ajte ar kute Metĩndjwỳnhmã amijarẽnh 'ãno ãm kadjy arkum kabẽn jarẽn arkum, —Ga ren ar ajõ anhõbikwa'õ ajbir bôx, akamàt kô ipôkri bôx ga ren aje kadjy mỳjja'õ byrmã tẽn ren anhõbikwa 'õmã kum, “Nãr, imã angã, anhõ djwỳ 'ãmro amãnhkrut ne ikjêkêt imã 'õ ngã gê inhõbikwa kukrẽ. Nãm iwỳr y:n kam ajbir bôx. Ba kam kadjy mỳjja jabej tẽ. Kadjy inhõ mỳjja kêtkumrẽx ba kam kadjy ije akutã djwỳ kwỳ byrmã tẽ. Gop on imã angã.” ");
INSERT INTO txuNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nhym ren anhõbikwaja arek õto nõr prãme ren amã, —Kati, inhõtdjwaa. Ije amã õr prãm kêt. Arỳm ne ba kikre'ã ijê ne arek ikrao inhikwã. Kàjmã idjãm prãm kêtê. Amũ dja ga tẽ gê me'õ amã 'õ ngã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bir be, ba ar amã arẽ. Ga kam ren arek 'ã adjà'wỳro dja, mã 'ã 'uw nhym kam ren arỳm kàjmã djan ren, “Ba on kum kungã gê wãm o tẽ ba gop ikujrẽnh kêt ne gêt arek inhõto nõ”, ane. Djãm ar aje abeno anhõbikwakam ne amã kungã? E kum kati, ẽ, aje mã 'ã 'wỳrkam ne amã kungã. Apijàm kêt ne aje 'ã 'wỳr 'ãno adjãmkam ne amã kungã, ar atu mãnhkutã amã kungã. ");
INSERT INTO txuNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Bir be, kam ne ba ar amã, “Dja gar tu mỳjja 'ã 'uw, mã mỳjja'ã 'wỳro tẽ nhym Metĩndjwỳnh arỳm ar amã kungã. Gar aje mã mỳjja jabej ne kam arỳm kum akatorja pumũ. Ne kam ajte mã kikre kabem õ kikre djwỳnhmã akabẽno aku'ê nhym arỳm kute ar amã kikre 'ã 'yrja pumũ.” Dja gar ã Metĩndjwỳnh 'wỳro ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Be, me kute mỳjja'ã 'wỳr 'ãno ãmja dja arỳm Metĩndjwỳnh memã kungã. Gar me kute mỳjja jabej ne kum apôxja pumũ. Ne kam ajte me kute kikre jajkwa krekremã kabẽno ku'ê nhym arỳm me kute memã kikre'ã rênhja pumũ. Dja gar gadjwỳ ã mỳjja'ã Metĩndjwỳnh 'wỳro ane nhym arỳm ar amã kungã. ");
INSERT INTO txuNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nhỹnh ne ar akra'õ tẽn tep'ã ar ajuw gar kum kangã ngã? ");
INSERT INTO txuNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ne õkrẽnẽ'ãnh ngre'ã ajuw gar kum makre ngã? Arkati. ");
INSERT INTO txuNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Be, gar ajaxwekam aje akramã mỳjja mex nhõrja pumũ. Nhym bep kàjkwakam ar Abãm mextire ta gêdja ar amã amũ mỳjja mex nhõro ar ajakren ar amã Amikarõ ngã. Gêdja gar Metĩndjwỳnh Karõ'ã 'uw nhym tu ar amã kungã, ta mextire ne ar baja gêdja ar amã Amikarõ ngã, ar amã Amikarõ jano, ane. Nãm ã Jeju me kute mỳjja'ã Bãm 'wỳr nhym õdjànhkôt kute memã Amikarõ nhõrmã ã memã 'ã ujarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nhym kam me karõ punu ar me'õo ba nhym kabẽn kêtkumrẽx ne. Me karõ ajmã ajkwa o nhym kabẽn kêtkumrẽx ne. Nhym kam Jeju bõm kumẽ. Bõm kumẽ nhym arỳm mã tẽ nhym arỳm kabẽn ne. Nhym me kam ari aben pumũn Jejukam no tyn kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nhym bep me kwỳ ne me abenmã kum, —Kê, djãm Metĩndjwỳnh kabẽnkôt? Kati, Bedjêbu. Me karõ punu nhõ bẽnjadjwỳrbê Bedjêbu kabẽnkôt uma proo ne ar bõm me karõ rẽnho ba, ane. Xatanaj nhidji 'õbê ne Bedjêbu. ");
INSERT INTO txuNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nhym ate me kwỳ kum, —Goja on mỳjja'õ nhipêx ba me omũ, Metĩndjwỳnh pyma proo mỳjja pumũnh kêt goja 'õ nhipêx ba me omũ, ane. Jeju kute Metĩndjwỳnh pyma proo kute mỳjja pumũnh kêt'õ nhipêx mar jabej ne me kute kabimã kum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nhym Jeju ta prĩne me õkre kadjwỳnhbê me kabẽn ma, me kute Bedjêbu pyma proo ne ar bõm me karõ rẽnho ba anhỹrja me kadjwỳnhbê prĩne kuman kam memã kum, —Godja me õ pyka tãmkam abeno kurê djwỳnh mã ne ren me kam nẽ? Nãm ren ã me anen kam ren arỳm amijo ajkẽ. Nhym ren me ta ũrkwã tãmkam abeno kurê djwỳnh mã ne ren me kam nẽ? Nãm ren ã me anen kam ren arỳm abeno apêx. ");
INSERT INTO txuNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Bir be, Xatanajdjwỳ ta õ àpênhmẽ ne ren abeno ajkij ne ren abeno kurê djwỳnh, mã ne ren me kam nẽ? Mã ne ren Xatanaj nẽ? Nãm ren anen kam ren arỳm abeno apêx. Nã gãm me we ijã, “Bep Bedjêbu pyma proo ne ar bõm me karõ punu rẽnho ba”, ane. Ije gêdjãm Xatanaj ta ajte jãm õ àpênho akẽx ne ar bõm rẽnho ba. ");
INSERT INTO txuNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ba ren Bedjêbu kabẽnkôt ren bõm ar me karõ punu rẽnho iba nhym ren mỳj me'õ kabẽnkôt ne me anhõ àpênh bõm ar me karõ rẽnho ba? Ar jadjwỳ ne ar bõm me karõ rẽnh ar o ba. Djãm ar adjwỳnhdjwỳ ne ar we Xatanaj kabẽnkôt ar bõm me karõ rẽnho ba. Ga ren me arkum ja jarẽ nhym ren ar me amã, “Ije tô djãm Xatanaj ta kute õ àpênho bikẽnho ba got.” ");
INSERT INTO txuNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nhym bep kati, Metĩndjwỳnh pyma proobit ne ba ar bõm me karõ punu rẽnho iba. Ga kôt arỳm Metĩndjwỳnh me awỳr bôxja pumũ. Metĩndjwỳnh kute me apytàr ne me akadjy bẽnjadjwỳr ne kute me ajo bamã me awỳr bôxja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ba ajte atemã me'õ'ã amijakre ga me ama. Me'õ ne õ kikrekam kruwmẽ rop'io nhỹ ne o õ nêkrêx pytàn o nhỹ. Umao amim õ nêkrêx pytàn o nhỹ. Nhym me'õ ajmã kute õ nêkrêx o kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nhym bep atemã me'õ kute umao akrenh mex ne tu bôx ne kruw tã o tỹm ne kubê kunĩo pôx ne kam kubê nêkrêxo prõt ne, kubê mỳjja kunĩo prõt ne. Kute umao õ nêkrêx pytàr ne o ỹrja tu kubê o prõt ne memã kungrà. Ba ne ba ipymao Xatanaj jakrenh mex ne kam amijo aptàn kubê õ krito iprõt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Me'õ kum ikĩnh kêt ne arỳm mrãmri ijo kurê djwỳnh ne. Ne ikôt àpênh prãm kêt ne arỳm Xatanajkôt apê. Dja me'õ kum ikĩnh kêt ne kam ajte kum Xatanaj kĩnh kêt ne kam amijã, “Ba dja ba ate ikrãn ar mrã, amidjwỳnhbit man ar o mrã”, anen arỳm Xatanajkôt apê, ane. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ne kam ajte me karõ punu'ã ajarẽn memã kum, —Me karõ punu pydjin kute ar me'õo baja ne arỳm kurũm katon tẽ. Ne kam te ar mrã, ngô kêtkam ar mrã, te ajte kute me'õmã àr ne tyk djà kêtmã ar mrãn kam akubyn kute ar me'õo ba tũmja'ỳr tẽ. Ne kam amim, “Ba gop inhũrkwã kurũm ikatorja ajte 'ỳr tẽ”, ane. Kute ar me'õo ba tũm'ã ne ũrkwã jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ne kam amim ba djà tũmja'ỳr tẽn bôx ne omũ nhym arỳm mexkumrẽx. Me karõ 'õ kute o ba kêt nhym prĩne kadjwỳnhbê mex ne arỳm kam mỳjja katàt. ");
INSERT INTO txuNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nhym kam kadjy mã me karõ punu'ỳr tẽ. Ne kam mekam me kwỳ japrôn 'ỳr meo mõn meo bôx. Nãm me karõo 7 ne o bôx ne me'õ jamã meo wangij nhym kam me kam ar ba. Kute me karõ punuo 7 ne o bôx tãm ne axweo kute õbê pydji kute ar o ba tũmja jakrenh mex ne kam arỳm o punu rax ne. Kàjbê punuri ne kàjbê punu nhym bep kute o 7 ne o bôxja ne arỳm o punu rax ne. Nãm ã Jeju me karõ punu'ã ujarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nãm memã kabẽno ãm rã'ã nhym me ipôkri me'õ nire kàj bê kum kabẽn ne kum, —Ô kum anãbit ne kĩnhkumrẽx. Abê bẽnjadjwỳr raxkam ne ga anã tikkremã wadjàn ruw ne anã kà kaô nhym anã kĩnhkumrẽx ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nhym kum, —Bep me kute Metĩndjwỳnh kabẽn mar ne 'ãno ãm ne kute kôt amijo baja, me tãm gêdja me mrãmri kĩnhkumrẽx ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Nhym kam me Jeju'ỳr ban bôxo dja. 'Ỳr ban bôxo djan 'ã aben pydjio mõn o mõn o mõn ĩ 'ã utĩ: ane. Me kute õbê kum, —Goja on mỳjja pumũnh kêt'õ nhipêx ba me omũ, anhỹr jamã ne Jeju, —Me akamingrãny ne ga me ajaxwekumrẽx. Nã gãm me abentã ijuw ne imã, “Mỳjja pumũnh kêt'õ nhipêx. Ba me goja omũn kam tu amim amarkumrẽx”, ane. Bep kati, djã bãm me amã ipêx kêtkumrẽx ne. Ẽ, mỳjja pydji dja ga me omũ. Gêdja ba ty. Nhym ijã akati amãnhkrut ne ikjêkêt ba akubyn itĩn ne ikato ne kam me amã Metĩndjwỳnh raxo amirĩt ne. Ga me me bakukãmãrebê Djônaj tep tikkrekam nõrja pumũ. Tep tikkrekam nõr nhym 'ã akati amãnhkrut ne ikjêkêt nhym ajte tep tikkre kurũm kator ne kam pykabê Niniwekam me ja'ỳr tẽm ne kute memã Metĩndjwỳnh raxo amirĩtja pumũ. Badjwỳ ije amijo inhĩ ne me awỳr ibôx gêdja ba ty ne akubyn itĩn ne ikato ga kam me akamingrãny amim Metĩndjwỳnh raxkôt ama. ");
INSERT INTO txuNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Godja Metĩndjwỳnh kute memã axwe pãnh jarẽnh nhõ akati kato nhym kàjkwa nhirê kurũm bẽnjadjwỳr ni ajte katon kam me akamingrãny, me amymã axwe jarẽ. Mỳkam? Bir, amrẽbê ne me bakukãmãrebê Xaromão no mexkumrẽx ne kute prĩne mỳjja mar. Bẽnjadjwỳr rax. Nhym arỳm bẽnjadjwỳr nija arỳm 'ã ujarẽnh ma. Arỳm Xaromão'ã ujarẽnh man kam kute omũnh prãm ne. Ne kam nĩnh kàjkwa nhirê kurũm 'ỳr tẽn bôx. 'Ỳr bôx ne kam prĩne kabẽn ma. Ẽ, ba ne ba Xaromão kuràm irax. Nã bãm iraxo bôx, jakam, me akam bôx ga me imar kêt ne, ikanga mex ne. Kam dja bẽnjadjwỳr nija me amã axwe jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nhym Niniwekam me jadjwỳ me amã axwe jarẽ. Godja Metĩndjwỳnh kute memã axwe pãnh jarẽnh nhõ akati kato nhym Niniwekam me ja ajte apôx ne kam me akamingrãnymã axwe jarẽ. Mỳkam? Bir, Djônaj ne kàj bê memã Metĩndjwỳnh'ã ajarẽ nhym Niniwekam me ja kuman amim katon wãnh axwemã iren Metĩndjwỳnh'ỳr amijo akẽx ne. Ẽ, ba ne ba iraxo Djônaj jakrenh mex ne. Ga me tu ate akrãn ikanga mex ne. Kam ne ba me amã, “Me ja dja me akubyn apôx ne arỳm me amã axwe jarẽ”, ane. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ne kam ajte memã irã jarẽ ne memã, —Djãm me kute ngônhpôkmã angjênh ne kute mỳjja 'õkôt o bipdjur got? Ne kute kào 'ã pro got? Kati, ngônhpôk ne me kum angij ne tu kênhkam umjuw nhym memã kikre kre kurwỳo ku'ê. Nhym me mrãn wangij nhym memã irãkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nhym me nodjwỳ. Me noo ne me kute mỳjja pumũnh. Dja ga me ajõ ano mex, ajmã ano kute kêt jabej arỳm mrãmri arĩt tỳxkumrẽx ne aje mỳjja pumũnh. Aje mrãmri ne me a'uri mrãnh mex pyràk. Nhym bep dja ga ano rã, ano punukumrẽx jabej arỳm arĩt kêt ne aje mỳjja pumũnh kêt. Aje mrãmri ne me akamàt kô tykkam mrãnh punu, mrãnho bikàr mrãnh ja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gora me amijãno djan Metĩndjwỳnh kute me amã amikukràdjà jarẽnhkôt amijo aba. Gêdja ga me kôt amijo aba kêt jabej, kute me amã amikukràdjà jarẽnhja kôt amijo aba kêt jabej arỳm aje me'õ akamàtkam ba pyràk, me aje me'õ akamàt kô tyk tỳxkam mrãnho bikàr mrãnh ja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nhym bep dja ga me mrãmri Metĩndjwỳnh kabẽn kunĩkôt amijo abakumrẽx ne kam me aje me'õ mrãmri ngônhpôkti nhirãkambit mrãnh ne kam akamàt kô tykkam mrãnh kêtkumrẽx ja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nãm memã arẽnh pa nhym kam mekbê pardjêu'õ kum, —Amrẽ ikôt tẽn ikutã anhõ kwỳ krẽ, ane. Nhym Jeju kum “Ã” anen kam kôt tẽn ũrkwãmã wadjàn nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kute aminhikra ku'õnh kêt ne nhỹ nhym omũn kam õkre kadjwỳnhbê amim, —Ije tô mỳj nã? Ije kum bep kute me bakukràdjàkôt aminhikra ku'õnh kêt. Õ kwỳ krẽn kadjy kute aminhikra ku'õnh kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nhym kam Bẽnjadjwỳr kum, —Kê, me abê pardjêu ne ga me ijã akabẽn ne anhõkre kadjwỳnhbê amim, “Kute me bakukràdjàkôt aminhikra ku'õnh kêt”, ane. Bep me ga ne ga me ajêx ne we amijo akabẽn mex. Nã gãm me aje mrãmri ne me kute ngônh krãmẽ ngônh puror nhibũmbit põnh ne kute kre põnh kêt nhym krekam mỳjja kakrãtyk pyràk. Be, nã gãm me ã we katàt amijo abao ane. Nhym kam me me akrãkàbit pumũ nhym kam kute me amex pyràk. Nhym bep kati, me akadjwỳnhbê ne ga me apunu rã'ã. Me akadjwỳnhbê ne me amã me õ nêkrêx prãm ne 'ã angryk ne ajaxwe'ãbit aje amim karõ rã'ã. Kam ne ga me akadjwỳnhbê apunu rã'ãja. ");
INSERT INTO txuNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Me ano kêtkumrẽx. Djã nãm me anhipêx djwỳnh me akrãkàbit 'y? E kum kati, nãm me akadjwỳnhdjwỳ 'y. Kam ne kute prĩne me akadjwỳnhbê me apumũnh ne kum me akadjwỳnhbê me amex prãmkumrẽxja. ");
INSERT INTO txuNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nã gãm me we amijo akabẽn mex ne, ne amijo katàt amrãnh, bep kati, me akadjwỳnhbê apunu. Dja ga me me 'uwtĩmãdjwỳ anhõdjành ne me 'uwtĩkam adjukaprĩn memã mỳjja ngãn kam arỳm akadjwỳnhbêdjwỳ amexkumrẽx ne, akrãkàmẽ akadjwỳnh kunĩ mexkumrẽx ne, me 'uwtĩkam me adjukaprĩkam. ");
INSERT INTO txuNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Me abê pardjêu dja ga me ĩ me biknor tokry djàkam mõ. Watĩ:re. Mỳkam? Me aje Metĩndjwỳnhmã mỳjja kakritbit nhõr ne kam aje mỳjjabê kumkatija aje kum õr kêtkam. Nã gãm me mỳjja kakrit, õmrõ djành djà, pi'ômẽ djwỳ kakrit kunĩ ne ga me Metĩndjwỳnhmã ikjê rên kum kryre ne angã. Ne kam ga abêngôkreja amã abê kêt ne katàt meo aba kêtkumrẽx ne. Me aje kum kryre ne õrja ne mrãmri tu mexkumrẽx. Mỳkam ne ga me mỳjja raxjadjwỳ kum õr kêt ne? Mỳkam ne ga me amã Metĩndjwỳnh jabên katàt meo abaja kêt ne. Ja ne ga me aje marmãn ate mỳjja kakritbit ma. ");
INSERT INTO txuNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Me abê pardjêu dja ga me ĩ me biknor tokry djàkam mõ. Watĩ:re. Mỳkam? Me aje amijo rũnhbit mar prãmkam. Me kute aben pydji djàkam me amã me bẽnjadjwỳr rũnh krĩ djàbit kĩnhkam. Nhym me me ipôkri me kute me amã kabẽn ne me amã rũnh jarẽnho kumex jabit ne ga me amã kĩnh. ");
INSERT INTO txuNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Me ga dja ga me ĩ me biknor tokry djàkam mõ. Watĩ:re. Mỳkam? Me aje pyka krã pyràkkam. Nã gãm me aje pyka krã arỳm biknor ne pyka mẽ bimràk ne kute pykakumrẽx pyràk. Nhym me kute mar kêt ne tu iby mrãnhja pyràk. Ne kam kadjwỳnhbê ne punu, kadjwỳnhbê ne mỳjja kro. Nã gãm me ã akadjwỳnhbê apunu ane nhym me kute me amar kêt. Nãm mỳjja 'êx ne krãkàbit mex ne kam kadjwỳnhbê ã punu ane. Nãm ã Jeju mekbê pardjêu jaxweo amirĩto ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nhym kam me kute Môjdjê kukràdjà mar djwỳnh'õ Jejumã kum, —Ẽ, bẽnjadjwỳr, nã gãm me badjwỳ me ijaprỳ. Nã gãm akabẽn jao me badjwỳ ã me ijo ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nhym kam Jeju kum, —Ije nà, me aje Môjdjê kukràdjà mar djwỳnhdjwỳ dja ga me ĩ me biknor tokry djàkam mõ. Watĩ:re. Nã gãm me akabẽn kajgoobit ar memã Metĩndjwỳnh kabẽn jarẽnho aba. Djãm Metĩndjwỳnh kabẽn? Kati, me ga akabẽno ne ga me ar me anoro aba. Ga kam me ga kôt ar aba kêt ne. Nhym me te amijo anen kam, “Ije mã dja ba me nẽ”? ane. Me aje ã meo anhỹrkam ne kute mrãmri ne me kute me kadjybit jênh rũnho atom ne kam kute kàjmã memã arĩ kêtkumrẽx ne kute memã tur kêtkumrẽx ne kute me ibũm nêje kum katy kêtkumrẽx ja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Me ga dja ga me ĩ me biknor tokry djàkam mõ. Watĩ:re. Mỳkam? Me amã Metĩndjwỳnh kabẽn jarẽnh djwỳnh par prãmkam. Me akukãmãre ne Metĩndjwỳnh kabẽn jarẽnh djwỳnh kwỳ pa:, ga me kam anhingêt nhimry krã prĩne kum o djuw mex ne. Me anhingêtbê Metĩndjwỳnh kabẽn jarẽnh djwỳnh par djwỳnhmẽ me aje aben pyràk. Me akukãmãre kute me parja ne ga me omũn kam kôt amijo mõn kam we imry krã prĩne kum o djuw mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kwãrĩk rã'ã. Metĩndjwỳnh ta ne no mexkôt, ta kute amim 'ã karõkôt arỳm me amã, “Ẽ, dja ba me amã ikabẽn jarẽnh djwỳnh janon inhõ àpênh jano ga me kwỳ pan kwỳo ajkẽ”, ane. Djã nãm kupa'ã arẽ? Kati, kônh ne kum kudji. Ga me aje me paro amõrja pumũ. Kam ne Metĩndjwỳnh arỳm pãnh jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Me akukãmãremẽ ne ga me me kraxrũm Metĩndjwỳnh kabẽn jarẽnh djwỳnh paro tẽ. Paro tẽn paro tẽn arek me kamrô kapĩn o tẽ. Nhym Metĩndjwỳnh arỳm meo ngryk ne kam gormã me ajabatànhmã pãnh jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nã gãm me akukãmãre Abeu bĩno kurêtuw ne kam ijukri me ja paro tẽm tãmtã: jakam arek o tẽ ne kam Djakarij'ỳr bôx ne kam Metĩndjwỳnh nhõ kikretimẽ õ ngônho ki kaêxkam kubĩ. Nà, ẽ, ba me amã arẽ. Metĩndjwỳnh ne arỳm meo ngryk ne. Ne kam me akamingrãnymã arỳm pãnh jarẽ. Me ga dja Metĩndjwỳnh me akukãmãre kute me imex tũmja pãnh me ajo ajkẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Me aje Môjdjê kukràdjà mar djwỳnh dja ga me ĩ me biknor tokry djàkam mõ. Watĩ:re. Ga me aje memã Metĩndjwỳnh kabẽno amirĩto atẽmmãn ate ajte mekbê udju. Nhym me te kute amim Metĩndjwỳnh marmã. Nã gãm me aje mrãmri ne me kute mekbê kikre'ã ijên nhĩ'ãm kam o kajkep djà rẽnh nhym me te kute kikre'ã rênh ne ngjênh prãme kapôtã ku'êja pyràk. Ga me kam ga Metĩndjwỳnh mar kêt ne ajte me jadjwỳbê aptà, ane. Nãm ã Jeju memã bẽn tỳxo anen kam katon mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Nhym kam mekbê pardjêumẽ me kute Môjdjê kukràdjà mar djwỳnhmẽ Jeju jabej rĩt mõ. Jeju kute Môjdjê kukràdjà'õ kupa'ã arẽnh jabej ne me umaro dja. Ne kam mã kukijn mã kukijn mã kabẽn'ã kum apnên ajte kum, —Goja rã'ã ajte arẽ, ba me kuma, ane. Jeju kute kupa'ã arẽnh nhym me kute o tỹm ne bĩnmã ne me ã ane. Nãm me te kute Jeju'ã kabẽn punu nhôrmã. Kute kabẽn punu 'õ jarẽnh nhym me kute 'ã kabẽn punu nhôrmã te abej umaro dja. ");
INSERT INTO txuNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nhym me Jeju'ã bikprõnho dja. 'Ã bikprõnho djan o djan o djan ĩ 'ã utĩ: ane. Kute pi'ô pyràk. Ne ĩ ãm ta aben par'ã ku'ên ĩ ta ikjêo aben rẽ, me krãptĩkam. Nhym kam Jeju amikôt ba djwỳnh kumrẽxmã kum, —Gora ar aminêje me wã pumũ, aminêje mekbê pardjêu jaxwe 'ãno dja. Nãm me 'êx ne kute mex pyràk. Nhym bep kati, me kadjwỳnhbê ne me punukumrẽx. Me õkre kadjwỳnhbê ne me axwebit kute mar ne 'ã amim karõ. Me axwe kute djwỳ nhigot djà pyràk. Gêdja amũ me'õ'ỳr bôx ne amũ me'õ'ỳr bôx ne amũ me'õ'ỳr bôx ne ĩ mekmẽ amrà ne ĩ me kunĩo tuknĩ. Kam ne ba ar amã, “Gora ar aminêje me wã pumũ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Djã nãm me kadjwỳnhbê axweja bipdjur rã'ãmã? Kati, dja ĩ amirĩt ne. Nhỹnh ne mỳjja bipdjur'õ me kute omũnh kêtmã? Ne me kute mỳjja pudjur'õ mar kêtmã? Adjỹm, dja ĩ kunĩ amirĩt ne. Dja mỳjja pudjur, mỳjja o bipdjurja ĩ kunĩ amirĩt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Dja gar te akamàt kô tykkam abẽn prĩkam abenmã mỳjja jarẽ nhym me ĩ tu irãri arẽnho kumex. Dja gar te amijã ijê, kikre kadjwỳnhbê amijã ijên ajte aben jamakri ajajkwa momokkam abenmã mỳjja jarẽ nhym me tu kàj bê abenmã arẽ. Dja amirĩt ne. Dja me kuman kam kàj bê abenmã arẽ, kikrekôt arẽnho ipôk ne, ne ngàbê abenmã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ẽ, ar apa, inhõbikwa ar, ba ar amã arẽ. Kwãrĩk wãnh ga ar amã me kute ar aparja pyma kêt. Me ja gêdja me ar akrãkàbit par kajgon kam ijukri kute ar akadjwỳnhbê ajmã ar ajo kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kati, ba ar amã arẽ. Me'õ pydji dja ga ar amã uma. Kute me bĩn ne kute ijukri me biknor tokry djàkam me rẽnh, jabit dja ga ar amã uma. Be, ba ar amã arẽ, Metĩndjwỳnhbit dja ga ar amã uma. ");
INSERT INTO txuNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ẽ, mã ne kwênhne pãnh kute? Kwênhne ne pãnh ngri:re. Kwênhne ne amãnhkrut ne amãnhkrut ne ikjêkêt kam pãnh birãm ngônho pi'ôk kaprĩ amãnhkrut. Nà, tãm. Nhỹnh ne Metĩndjwỳnh kwênhne jao akno? Djã nãm o akno? Kati, nãm te mỳjja kakrit, te kubê kwênhne nhym prĩne o djuw mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Be, ar ja man atĩn prãm kêt. Ar ga ne gar kwênhne kuràm abê kumkati. Ar ga ne gar abêngôkre ne anhĩ pỹnhkôt kwênhne krãptĩ kuràm arax. Be, kute kwênhneo djuw mexja pumũ. Nhym bep ar ga. Ar ga dja prĩne ar ajo djuw mex ne. Ga prĩne kute me bamar ne kute me bajãno ãmja pumũ. Mỳjja'õ kubê biknor kêt. Nhỹnh ne mỳjja'õ kubê akuno? Ga kute me bakĩ'ã akreja pumũ. Kam ne ba ar amã, “Kwãrĩk wãnh ga ar adjumar punu kêt ne amã mỳjja pyma kêt”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ba ar amã mỳjja 'õdjwỳ jarẽ. Me kute amijo ipytàr ne kute me krãptĩ nhipôkri kute, “Nà, ba ne ba arỳm amijo Jeju pytà”, anhỹrja gêdja ba badjwỳ ije amijo inhĩ ne me awỳr irwỳk badjwỳ Metĩndjwỳnh kadjy mrãnh djwỳnh nhipôkri, “Nà, ba inhõbikwa ne wã”, ane. Dja ba ã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nhym bep me kute imar kêt ne kum ikĩnh kêt, me kute, “Ije bep ije tãwã mar kêt”, anhỹr, me tãm gêdja ba badjwỳ amipãnh Metĩndjwỳnh kadjy mrãnh djwỳnh nhipôkri, “Ije tãwã mar kêt”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ẽ, gêdja me'õ ijã kabẽn ba ije amijo inhĩ ne me awỳr irwỳk, dja me'õ ijã kabẽn nhym Metĩndjwỳnh tu o aknon mar kêt ne. Nhym bep me'õ kute Metĩndjwỳnh Karõ japrỳ, tãm gêdja Metĩndjwỳnh mar rã'ã rã'ã ne, mã kam ngryk ne. ");
INSERT INTO txuNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Dja me ĩ ar ajo ajkẽ. Gêdja me ar apa 'amỳn mekbê idjaer bikprõnh djà'ỳr ar ajo bôx. Ne kam ajte me bẽnjadjwỳr krĩ djà'ỳr ar ajo mõ. Dja me ar apa 'amỳn ar ajo mõn amikabem ar apumjuw ne ar ajaxwe jabej ar akukjêro nhỹ. Kwãrĩk wãnh gar ajõ, “Ije, mỳj dja ba ikabẽn nẽ? Mỳj dja ba arẽ? Mã gêdja ba gêt ikabẽn on arẽ”, anhỹr kêt. Dja gar tu ate akrãn amikam atĩn prãm kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Metĩndjwỳnh Karõ ta dja ar amã kabẽn jarẽ. Me kabem adjãmkam dja amã kabẽn jarẽ gar kam kabẽno akabẽn ne memã akabẽn jarẽ. Nãm ã Jeju kôt ba djwỳnhmã kabẽn jarẽnho ane. Me kute kôt ba djwỳnho bikẽnh nhym ar kute memã kabẽn jarẽnhmã ã arkum anhỹr djwỳnhràm kabẽn jarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nhym kam me krãptĩ nhipôkri ne me'õ kàj bê kum, —Bẽnjadjwỳr, gop ikamymã arẽ gê imã nêkrêx kwỳ ngã. Ibãm tyk kutã ne ar imã nêkrêx'ã karõ bar ije ar o ibamã nhym ikamy bôx ne tu jãm o amijakren utàn mã o mõ. Kute imã kwỳ nhõr kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nhym kam Jeju kum, —Ije mỳj me'õ kabẽnkôt gêdja ba aben nêje ar akukrà. Ne mỳj me'õ kabẽnkôt gêdja ba akamy kutã nêkrêx kwỳ byn amã kungã? Djãm kadjy ne ba me awỳr tẽ? Kati, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ne kam me kunĩmã kum, —Gora me amijãno djan amã nêkrêx prãm kêt. Kwãrĩk wãnh ga me anhõ nêkrêx rũnh ne anhõ nêkrêxo adjàptàr ne ar o aba kêt. Djãm me kute amim nêkrêxo àptàr ne o bakam umar mex got, kôt me kĩnh got? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ne kam memã me'õ'ã ujarẽnh jakreo tẽn memã, —Me'õ ne õ nêkrêx krãptĩ ne õ purkamdjwỳ djwỳ krãptĩ. Bàygogoremẽ bàymẽ djwỳ kunĩ ingrõ:t ne kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nhym kam, “Ije, mã dja ba on? Nhỹnh gêdja ba inhõ bàygogomẽ bày kumexjao atom ne 'ã man ar o iba”? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ne kam amim, “Goja, nà, gêdja ba bàygogo nhõ kikre kryreja ngràn kam ajte akàjbê rũnh nhipêx ne kam kam o atom ne kumex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ije nà, dja ba o ane nhym arỳm mrãmri inhõ nêkrêx kumex. Mrãmri ne ba arỳm amimex ne. Gêdja 'ã amex krãptĩn kumex rã'ã ne. Jakam gêdja ba idjàpênh krãtan ikôkam kôt ne inhõ kwỳ krẽn kôt ikõn kam ikĩnh katibit ma”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nhym Metĩndjwỳnh kum, “Nã gãm ajbã. Akamàt ja tãmkam gêdja ga ty. Nã bãm te amexmã akabi ga atemã. Nhym nãr anhõ nêkrêxwã? Mỳj kadjy ne ga anhõ nêkrêx ar o aba? Nhym gêdja amỳrbê ar o ba”? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Bir be, nãm ã me kute amim Metĩndjwỳnh mar kêt ne kam kute õ nêkrêxbit mar ne kute amim o atommã o atom kajgoo ane. Nãm amimex ne kam Metĩndjwỳnhmã mex kêtkumrẽx ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ne kam ajte kôt ba djwỳnhmã kum, —Bir, kam ne ba ar amã, “Kwãrĩk wãnh gar amikam adjumar punu kêt ne anhõ kre kadjwỳnhbê amim, ‘Mỳj dja ba kukrẽ’? Nàr kubẽkà'ã, ‘Mỳj kubẽkà dja ba angij’? anhỹr kêt.” ");
INSERT INTO txuNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Metĩndjwỳnh ta ne gwaj bajo tĩn ne, ga gwaj batĩn ne ar babaja pumũ. Ja ne gwaj bamã mex, ja ne mrãmri wỳnhĩ. Nhym bep me õ ne kajgo, djwỳ ne kàjbê. Nhym bep Metĩndjwỳnh ne gwaj banhipêx. Ja ne gwaj bamã mex, ja ne mrãmri wỳnhĩ. Nhym bep kubẽkà ne kajgo. Kubẽkà ne kàjbê. Kwãrĩk wãnh ar amikam adjumar punu kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ẽ, gop ar bàrire ja pumũ. Kute amim pur jadjwỳr kêt. Kute amim djwỳ kre kêt. Kute amim mỳjjao atom kêt. Nhỹnh got õ bày nhõ kikre, nàr o atom djà? Kati, kwênhne ne ta ar ba, nhym kam Metĩndjwỳnh prĩne o djuw mex ne. Kwênh kute amim djwỳo atom kêtja pumũ. Ar ga ne gar kwênhne kuràm amexkumrẽx. Ne ar araxo kwênhne jakrenh mex ne. Dja Metĩndjwỳnh kwênhne kuràm prĩne ar ajo djuw mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nhỹnh ne me'õ ta ajkwao, mỳjja kam umar punuo, amũ tyk kêtmã aminhõ akati kamẽ? Kati. ");
INSERT INTO txuNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Gar aje mỳjja ngrire te o anhỹrja pumũ. Gar aje mỳjja ngrire ja mar kêtja pumũ. Metĩndjwỳnhbit ne kute mar. Ajbit kute me tĩn nhijukri kute amidjar mar, kumãbit ne amirĩtkumrẽx. Ne kute me bajo djuw mexjadjwỳ mar, prĩne kute mar, kumã ne mrãmri amirĩ:tkumrẽx. Kam gêdja me bajo djuw mexkumrẽx. Bir be, mỳkam ne gar amikam atĩn prãm ne amikam adjumar punu? Kwãrĩk wãnh gar amikam adjumar punu kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ẽ, ar kapôtkam pidjôrãja pumũ. Pidjôrã ne ta ingrõt ne kumex. Àpênh kêtkumrẽx. Ne kute amim kubẽkà kayr kêt. Ẽ, ba ar amã arẽ, bẽnjadjwỳr raxbê Xaromão ne kute kubẽkà mextire jangjênhkam kĩ:nhkumrẽx. Nhym bep pidjôrãja ne mex, kĩnho Xaromão jakrenh mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Metĩndjwỳnh ta ne pidjôrã nhipêx nhym kam mexkumrẽx ne. Rã abenon kumex ne kam kĩnhkumrẽx. Nhym akati nhym me arỳm kadjy bõremã adjà nhym xêr. Te mỳjja kakrit tebê apêx ba nhym Metĩndjwỳnh prĩne o djuw mex ne. Ar ga ne gar pidjôrã kuràm abêngôkre ne amexkumrẽx. Dja Metĩndjwỳnh pidjôrã kuràm prĩne ar ajo djuw mex ne ar amã ar akàdjwỳ ngã. Be, kam gêdja gar tu amim Metĩndjwỳnh kamnhĩxkumrẽx. Nhym mỳkam ne gar amim kamnhĩx kêt ne kàjbê amim kamnhĩx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kwãrĩk wãnh gar amikam adjumar punu kêt ne anhõ kwỳ krẽn ne kôt akõmkôtbit ajamak bẽn kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Apỹnh pyka djàri me kute amim Metĩndjwỳnh mar kêt ne me ar mỳjja ja jabej ba. Nhym bep kati, ar Abãm kute prĩne ar amar ne ar anhõ mỳjja kêtkôt kute ar amar. Kam gêdja prĩne ar ajo djuw mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Metĩndjwỳnh kumrẽx dja gar mar ar o aba, Metĩndjwỳnh kukràdjàmẽ dja gar kumrẽx ma. Nhym kam ijukri dja arỳm ar amã mỳjja ja ngã. ");
INSERT INTO txuNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ẽ, inhõ kritte, inhõ àpênh ngrêreja, kwãrĩk wãnh gar atĩn prãm kêt. Ar Abãm ne arỳm amim ar ajã karõ. Kute meo atom ne me kadjy bẽnjadjwỳr ne kute ar meo bakam kute ar ajã bẽnjadjwỳr mẽnh gar aje ro'ã meo abamã arỳm ar ajã amim karõ. ");
INSERT INTO txuNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ẽ, kwãrĩk wãnh pykabê anhõ nêkrêxja'ã ano tỳx ne 'ã angràn ar o aba kêt. Dja gar anhõ nêkrêx me'õmã angã gê pãnh ar amã pi'ôk kaprĩre ngã gar abyn kam me õ mỳjja kêtjamã angã. Bep kati, kàjkwakam dja Metĩndjwỳnh ar amã anhõ mỳjjao atom, nhym tũmràm ar amã mexkumrẽx gar o aba. Tũmràm rerek ne punu kêtkumrẽx. Ar aje amim kàjkwakam mỳjja mextireo atomja gêdja kàpo, mỳjja'õ ar abê o bikẽnh kêtkumrẽx nhym me àkĩnhĩ'õ 'ỳr bôx kêtkumrẽx, gar ar o aba. Kwãrĩk wãnh gar pykabê mỳjja ja mar ne o atom ne ar o aba kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Be, nok ga ren ar pykabê amim mỳjjao atom ne kam ren kôt pykabê ar anhõ mỳjjabit man ar o aba. Nhym bep dja kàjkwakam Metĩndjwỳnh ar amã mỳjjao atom gar kam kôt arỳm kàjkwakam anhõ mỳjja man ar o aba. ");
INSERT INTO txuNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Dja ba tyn akubyn itĩn ne kàjkwa kumrẽxmã wabi. Ne kam arỳm ajte akubyn bôx. Ar ga dja gar ikam ama. Ne ikutêp amijãno dja. Ikutêp amijãno djan ar amijo aba. Kute mrãmri ne me õ bẽnjadjwỳr me kute abenã me rẽnh'ỳr mrãnh nhym õ àpênh kutêp kikrekam krĩn kute kubẽkà jangjênh rã'ãn õt kêt ne kute ngônhpôkmã angjênh rã'ãn kutêp no tỳx ne kam amako krĩ. Nhym kam me õ bẽnjadjwỳr akubyn mrãn bôx ne kam õ àpênhmã kabẽn ne. Ne arkum, “Kikre'ã ta”, ane. Nhym ar tebê kum kikre'ã kuta nhym arỳm wadjà. Ar õ bẽnjadjwỳrja arỳm bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ar no tỳx ne kute kam amak rã'ã nhym bôx nhym kam ar kĩnhkumrẽx ja pyràk. Nhym kam ar õ bẽnjadjwỳrdjwỳ arkam kĩnhkumrẽx ne. Õ àpênhkam kĩnhkumrẽxkam gêdja kute arkum õmrõmã kadjy amidjê. Mrãmri ne ba ar amã katàt arẽ. Dja amidjên kam ar'ỳr tẽn kam arkum, “Ar nhỹ. Ar nhỹ ba ar amã ar anhõ kwỳ krẽn djà nhipêx gar krẽ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dja te akamàt kô ipôkri nàr te akati maktã bôx nhym õ àpênhja no tỳx ne kam amako krĩ rã'ã ne. Kam gêdja ar õ bẽnjadjwỳr arkam kĩnhkumrẽx ne, nhym ar jadjwỳ kĩnhkumrẽx ne. Dja gar ã bẽnjadjwỳr nhõ àpênh'ã amijakren arek ikam amako akrĩo ane. Gêdja gar ikam amak rã'ã jabej ba ar akam ikĩnhkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Gop ar ikabẽn ma. Ba ajte ar amã 'õdjwỳ jarẽ gar ama. Ne ren õ kikre djwỳnhja ren me àkĩnhĩ bôx djà man kam ren arek kam amako nhỹ. Nhym ren bôx ne kikre'ã 'yr ne kum àr kêtkumrẽx ne. Badjwỳ dja ba ije me àkĩnhĩ pyràk ne me ajaêrbê bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kam gêdja gar gadjwỳ mã ikam amako akrĩ. Ba ije amijo inhĩ ne me awỳr ibôx ba gêdja ba ajte akubyn bôx. Ar aje nhỹnh myt nhỹr 'õkam aje ibôx djà mar kêt. Kam gêdja ba tu ar ajaêrbê bôx, ane. Nãm ã Jeju arkum amibôx djà jarẽnho anen kam arkum kabẽn jarẽnh pa. ");
INSERT INTO txuNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nhym Pedru kum, —Djãm ar imãbit ne ga arẽ, ar ije akam amakmã, djãm ar imãbit ne ga arẽ, nàr kon, djãm me kunĩmã ne ga arẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nhym kam kum, —Be, me kute amikajmã'ã imar kunĩ dja me arĩk ikam ama ne kam kute mrãmri ne me àpênh djwỳnh kute õ bẽnjadjwỳr kam amakja pyràk. Me õ bẽnjadjwỳr ne õ àpênhmã kabẽn ne ne kum, “Ga dja ga me àpênh'ã me omũ, ane, ne prĩne 'ã meo djuw mex. Dja ga myt kunĩkôt memã õ kwỳ krẽn djà ngãn akrànmã memã õro aba. Ne me'ã akren memã angã.” Nãm ã õ àpênhmã me'ã karõo ane. Kute akrànmã me àpênh'ã me omũnh ne kute 'ã meo djuw mex katàtmã ã kum me'ã karõo ane. Nhym õ àpênh kum, “Nà, gêdja ba mrãmri ã anen kam me 'ãno dja”, ane. Nhym kam õ bẽnjadjwỳr mã nhĩ'ãm tẽ. Nhym kam õ àpênhja kabẽnkumrẽx. Nãm no mexkumrẽx ne katàt ar memã mỳjja nhõro ba, me kanga kêtkumrẽx ne ar meo ba. ");
INSERT INTO txuNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nhym kam bẽnjadjwỳr akubyn bôx ne kam õ àpênhjamã kato. Kute amrẽbê kum kabẽn jarẽnhja kôt mrãmri meo djuw mex nhym kam arỳm kum kato. Kam dja õ àpênhjadjwỳ tu amikam kĩnhkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ẽ, ba ar amã kôt arẽ. Bẽnjadjwỳrja dja õ àpênh ja'ã bẽnjadjwỳr mẽ. Kute nêkrêxmẽ mỳjja kunĩ pumũnhmã dja 'ã bẽnjadjwỳr mẽ. Nhym kam õ àpênhja kĩnhkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nãm ren õ àpênhja õkre kadjwỳnhbê, õ bẽnjadjwỳrja'ã ren, “Be, nãm nhĩ'ãm bẽnjadjwỳr tẽn arỳm amikrà. Jakam dja ba on tu arĩk ar iba, inomã arwãri”, ane. Ne kam ren ar õ àpênhja titiko ba, õ àpênh mymẽ õ àpênh nimẽ ren ar titiko ba. Ren õ kwỳ krẽnbit ban kôt kadjwati kangôo ikõn kam ren kam ajbãn ar ba. ");
INSERT INTO txuNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nhym kam õ bẽnjadjwỳrja aêrbê bôx. Õ àpênhja kute amim õ bẽnjadjwỳrja bôx djàkôt mar kêt. Nhỹnh akati 'õkam bôx djàmã kute mar kêt ne nhỹnh myt nhỹr 'õkam bôx djàmã kute mar kêtkam ne aêrbê bôx. Nãm bôx ne kam õ àpênh arĩk ar bajakam ngryk ne. Ngryk ne kam o ajkapôn bõm kumẽ. Me amakkre kêtjamẽ ro'ã bõm kumẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Bir be, dja ã me bẽnjadjwỳr ane. Me kute õ àpênhmã prĩne mỳjja'ã karõ nhym me ren ãm mar kajgo ne kam ren ate krãn ar ba ne ren kabẽnkôt amijo ba kêtkumrẽx ne. Nhym ren me õ bẽnjadjwỳrja bôx ne prĩne ren meo ajkẽ, me kaprêprê:k ne. Kute arỳm memã 'ã karõ kajgo nhym me kute kabẽn mar kêtkam. ");
INSERT INTO txuNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nhym bep õ àpênhja kute õ bẽnjadjwỳrja kabẽn mar kêt, me'õ kute memã kabẽn jarẽnh kêtkam, ne ren arĩk ar ba, kam ne ren õ bẽnjadjwỳrja bôx ne kam ren me kaprêprêk ngrire, meo bikẽnh ngri mex ne. Nãm me ren te mar mex ne tu ate krãn ar ba nhym ren prĩne meo ajkẽ. Nhym bep kati, me kute mar kêt, kam ne bôx ne ãm meo bikẽnh ngri mex ne. Metĩndjwỳnh ne apỹnh ar amã mỳjja ngã, ne ar amã ar adjê mex, ar ano mex, ar ajamak mex ar amã kungã, o ar kum adjàpênh kadjy. Dja abej ar akukij ne ar amã, “Nãr, ije ar amã ar ano mex, ar adjê mex nhõrja, mã ne gar kam nẽ? Djã ne gar o adjàpênh mex ne?” Kute me'õmã mỳjja kàjbê rax nhõrja gêdja o kum kàjbê àpênh rax jabej kukij. Nhym bep kute me'õmã mỳjja ra:x nhõrja gêdja o kum àpênh ra:x jabej kukij. ");
INSERT INTO txuNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ẽ, mỳj kadjy ne ba jakam tẽn bôx. Ije me axweo apêxmã ne ba pyka jakam bôx. Ga kuwy kute mỳjja kakrit kunĩo apêxja pumũ. Dja ba ĩ ibê kuwy mãn pràbê ã o anen me axwemã ikaton memã pãnh jarẽn kam me imex ne. Gora gê on õ akati 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nhym bep dja ba itokry rax kumrẽxi. Dja ba itokry rax ne kute mrãmri ne me wỳrkam ngoo tuknĩ ja pyràk. Dja ĩ itokry ã prĩne ijo tuknĩo ane. Dja ba itokry ra:x nhym me ibĩ. Kadjy ne ba tẽ. Gora gê on inhõ akati iwỳr bôx ba gop itokry rax gê gop on apêx. Ba kam arỳm ije amimarja arỳm apêx. ");
INSERT INTO txuNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Djãm ije pykabê me jamã umar mexmẽ me typydjin ar ba jarẽnhmã ne ba me'ỳr tẽ. Arkati, ẽ, ba ar amã arẽ. Me kute imỳr jabej abeno bikjêrmã ne ba me'ỳr tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Jakam dja me kikre tãmkam imỳr jabej abeno kurê djwỳnh ne. Me ta õbikwamẽ dja me ĩ abeno kurê djwỳnh ne abeno ajkij. Dja ar amãnhkrut ne ikjêkêtja amẽ ar jao kurê djwỳnh nhym amẽ ar ja amipãnh ar amãnhkrut ne ikjêkêt jao kurê djwỳnh ne. Arỳm ne ar abeno ajkij. ");
INSERT INTO txuNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bãmja dja imỳr jabej kra myo kurê djwỳnh ne. Nhym kra my amipãnh bãmo kurê djwỳnh ne. Nhym ate nãja dja kra nio kurê djwỳnh nhym kra nijadjwỳ amipãnh não kurê djwỳnh ne. Nhym ate umrengêxja dja wỳnh nio kurê djwỳnh nhym wỳnh nija amipãnh umrengêxo kurê djwỳnh ne. Dja me ã imỳr jabej abeno kurê djwỳnh ne abeno bikjêro ane. Tãm ne ja. Nãm ã Jeju kôt ba djwỳnhmã kabẽn jarẽnho anen arkum kabẽn jarẽnh pa. ");
INSERT INTO txuNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ne kam ajte me krãptĩtijamã kum, —Nã gãm me kàjkwa nhôt kurũm kakrã amrẽ bikamẽnh baja pumũn kam abenmã kum, “Gêdja na ruw”, ane. Ga me mrãmri tu kônh kum irkumrẽx, nhym arỳm ruw. ");
INSERT INTO txuNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nã gãm me kôk djàbêr tỳxja pumũ, kàjkwa nhirê kurũm kôk djàbêr pumũn kam abenmã kum, “Gêdja on amex nhym kam arỳm arngro tỳ:x ne”, ane. Ga me tu mrãmri kônh kum irkumrẽx nhym ã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kê, nã gãm me ajêx ne mỳjja mar kajgo ar o aba. Kàjkwamẽ kôk djàbêrbit ne ga me aje mar ne omũnh. Mỳkam ne ba me akam ar ibari mỳjja pumũnh kêt kwỳ 'yn me amã mỳjjao amirĩto iba ga me ja mar kêt ne omũnh kajgon amim, “Ije tô mỳj'ã”? anhỹr kajgon mar kêtkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Nhym mỳkam ne ga me amimar ne amijaxwemã akator ne Metĩndjwỳnhmã amijarẽnh kêt ne? Ja ne katàt. Mỳkam ne ga me ã anhỹr kêt ne? ");
INSERT INTO txuNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gêdja ga me Metĩndjwỳnh nhõ akati bôx kêtri kum amijo a'wỳ gê me ajo mex. Ba me amã arẽn me'õ'ã me ajakre. Birãm me'õ amã, “Ga ne ga ibê mỳjjao ajkẽn ar ikam amikrào aba. Aje imã o pãnh kêtkam gêdja ba bẽnjadjwỳr kute me axwemã apôx'ỳr ajo tẽ gê amã pãnh jarẽ”, ane. Gêdja ga amibêx ne kute 'ỳr ajo bôx kêtri kum amijarẽn kum o pãnh. Kute memã axwe pãnh jarẽnh djwỳnhmã apa 'amỳnh ne abjêro tẽm nhym kute krãkamngônhmã akanga nhym me kute abê ijê kêtri. Kute ã ajo anhỹr kêtri gêdja ga atẽmbê kum o pãnh. Dja ga ã o anen kum o pãnh kêt nhym arỳm mekbê ijê djàkam amẽ ga kam kum o pãnh ra:xo dja. ");
INSERT INTO txuNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Gêdja ga kum pãnho dja:n kum pãnho ino rer jabej arỳm akato. Nhym be djã gãm kum pãnho ino rer kêt ne mrãmri arek aku'ê. Gêdja ga me ã anen Metĩndjwỳnh kute memã axwe pãnh jarẽnh nhõ akati kator kêtri Metĩndjwỳnh'ỳr amijo akẽx ne kum amijo a'wỳ gê me ajo mex, ane. Nãm ã Jeju memã arẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ne kam memã kabẽn ja jarẽnh pa nhym me kam kum pykabê Garrêjakam me ja jarẽ. Nãm me Metĩndjwỳnhmã mry pan kubô. Kum bôro ku'ê rã'ã nhym Piratu õ àpênh krãkamngônhre me'ỳr ano nhym me prĩne me imex ne, me kute mry bôro ku'ê ja ne me me imex ne, ne mry kamrômẽ me kamrôo akà. Nhym me omũn kam Jejumã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nhym kam memã kum, —Birãm gãm me we, “Be nãm me õ pykakam me ja axweo me tĩnja jakrenh mex ne kam ty.” ");
INSERT INTO txuNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Arkati. Ba me amã arẽ. Me gadjwỳ dja ga me amim akator ne wãnh ajaxwemã anhirer ne Metĩndjwỳnh'ỳr amijo akẽx kêtkam me kudjwa tu abiknorkumrẽx ne, me akunĩĩ, ane. Nãm ã Jeju ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nhym krĩraxbê Djeruxarẽkamdjwỳ kikre prêktibê Xirôwe me imex ne. Nãm me'ã tỹm ne meo 18 ne me imex ne. Nhym me adjwỳnhdjwỳ pumũn kam Jejumã arẽ. Nhym kam ajte memã kum, —Birãm gãm me we, “Be nãm Djeruxarẽkam me ja kute Metĩndjwỳnhkam amikrào me tĩnja jakrenh mex ne kam ty.” ");
INSERT INTO txuNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Arkati. Ba me amã arẽ. Me gadjwỳ dja ga me amim akator ne wãnh ajaxwemã anhirer ne Metĩndjwỳnh'ỳr amijo akẽx kêtkam me kudjwa tu abiknorkumrẽx ne, me akunĩĩ, ane. Tãm ne ja, ane. Nãm ã Jeju memã ane. Nãm me abenmã axwe kukrà kêt mex ne arẽ nhym kam ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","7","Ne kam ajte memã atemã mỳjja 'ã ujarẽnh jakreo tẽ. Me kute abenmã axwe kukrà kêt mex ne arẽnhbê ne memã kum, —Atemã pidjôbê pigêre ne õ àpênh kute õ bẽnjadjwỳrjamã kremã o tẽ. O tẽn kum kre. Pidjôkô nhipôkri kum kre. Nhym arỳm ingrõt ne abatành ne. Nhym õ pidjô djwỳnhja kute ô jabejmã 'ỳr tẽ. Ne te ô jabej nhym amex nhym te ô jabej nhym ajte amũ amex nhym te ô jabej, ô jabej te aprãn kam õ àpênhmã kum, “Ota aje pidjô kreja ô kêt ne. Arỳm 'ã amex amãnhkrut ne ikjêkêt ba te ô jabej. On tẽn kum ta. Mỳj kadjy ne mõn inhõ purkam ãm kajgoo dja”? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nhym õ àpênhja kum, “Adjỹm bẽnjadjwỳr. Gê arek djan 'ã amex pydji ba kam bu'ã kakuwn kum mry nhĩno ipôk ne o kane. Mry nhĩno dja ba kanen kam gop ô jabej. ");
INSERT INTO txuNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Dja ô mex ne kam arek dja. Gêdja ô kêt ba tu kum kuta”, ane. Tãm ne ja. Metĩndjwỳnh on kute memã pãnh jarẽnh kêt. Tũmràm dja ĩ memã pãnh jarẽ. Me kute axwemã irer ne kute tũmràm 'ỳr amijo akẽx kadjy ne tũmràm memã pãnh jarẽn meo ajkẽ. 'Ã ne kute memã ujarẽnh jakreja. ");
INSERT INTO txuNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ne kam pi'ôk ràràr 'õkam me kute abeno bikprõnh djàkam memã Metĩndjwỳnh'ã ujarẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nhym kam me'õ nija wadjà. Me karõ punu'õ ne mã o ba nhym kam ibôn mrã. Ibôn mrãnh'ã amex krãptĩ. Arỳm 'ã 18. Nãm te katàt kàjmã ãmmãn katàt kêt mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nhym kam Jeju omũn kam amiwỳr ku'uw ne kam kum, —Àpnhĩre, me karõ'õ kute ajo baja ne arỳm amã ire, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ne kam 'ã ikra dji. 'Ã ikra dji nhym tebê kàjmã dja, arỳm katàt ne dja. Ne kam Metĩndjwỳnhmã mextire jarẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nhym bep me bikprõnh djàkam bẽnjadjwỳrja ne 'ã ngryk ne. Pi'ôk ràràrkam Jeju kute meo mexo ãmkam ne 'ã ngryk ne. Ne kam memã, —Pi'ôk ràràr ne ja. Pi'ôk tykkambit ne me àpênh djà. Pi'ôk tyk amãnhkrut ne amãnhkrut ne amãnhkrutkambit ne me àpênh djà. Kam dja ga me amrẽ mõ gê me ajo mex. Kwãrĩk wãnh ga me pi'ôk ràràrkam amrẽ 'ỳr abao adjãm kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nhym kam Bẽnjadjwỳr djwỳnh kum, —Kê, nã gãm me ajêx ne ajajkwakambit amimex jarẽ, ar amimex jarẽnho aba kajgo. Nhỹnh ne ga me ajõ pi'ôk ràràrkam anhõ krit'õ kõm kêt ne, anhõ mryti nàr mry'ã krĩja krãdjê djà 'ãpre bôn ũrkwã kurũm o akaton o tẽ nhym kõm kêt ne? Kati, nã gãm me pi'ôk ràràrkam anhõ krito aba nhym kõm ba. ");
INSERT INTO txuNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ije nhym mỳkam gêdja ba me'õ ni, Abraão tàmdjwỳja 'ãpre bônh kêt ne? Me ga ne ga me pi'ôk ràràrkam anhõ krit 'ãpre bô. Nhym mỳkam gêdja ba kubêngôkreja 'ãpre bônh kêt ne, Xatanaj kute uwpre'ã amex krãptĩ, arỳm 'ã amexbê 18ja 'ãpre bônh kêt ne? Kati, dja ba 'ãpre bô gê kàjmã dja, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ã kum ane nhym kam kurê djwỳnhja amikam pijàm ne. Nhym bep me ja, me kunĩ ne me tu kam kĩnhkumrẽx ne. Nãm Jeju memã mỳjja krãptĩo pôx nhym mexkumrẽx nhym me kam kam kĩnhkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nhym kam ajte Jeju memã kum, —Ẽ, Metĩndjwỳnh kute me utàr ne me kadjy bẽnjadjwỳr ne kute ar meo baja, mỳj ne kute uràk? Mỳj'ã ne ba ije akremã? ");
INSERT INTO txuNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","E kum nãm kute pidjô 'y kryre ja pyràk. Pidjô 'y kryrebê motadu. Me'õ ne amim 'y kryreja by ne kam o tẽn õ purkam kre nhym tebê abatành ne. Abatành mexkumrẽx nhym kam kwênhne apỹnh pa'ã aê, ane. Me kute amim Jeju marmã nhym arỳm ja pydji kadjy amima, nhym arỳm ja kadjy amiman 'ã tỹm, nhym ja kôt 'ã tỹm, nhym ja 'ã tỹm, nhym ja 'ã tỹm nhym arỳm 'ã krãptĩ ne. 'Ã ne 'y kryre ja jakre. ");
INSERT INTO txuNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ne kam ajte memã kum, —Metĩndjwỳnh kute me utàr ne me kadjy bẽnjadjwỳr ne kute ar meo baja mỳj ne ba ije 'ã akremã? ");
INSERT INTO txuNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","E kum nãm kute djwỳ nhigot djà pyràk. Me'õ nire ne djwỳ djôm byn ngônhkam kumẽn kam ajte iby o amãnhkrut ne kumẽ ne kam kadjy djwỳ nhigot djà ngri:re ja by. Ne kam o akàn kudji nhym nõn kam arỳm igot mõ. Igot mõ:n arỳm rax ne kam prĩne djwỳo tuknĩ, ane. Nãm ã me kute Metĩndjwỳnh mar amũ abendjô'ã abenmã Metĩndjwỳnh jarẽnho ane nhym arỳm me pyka kunĩkôt arẽnho ajmà nhym arỳm pyka kunĩkôt me kute Metĩndjwỳnh mar krãptĩ ne. 'Ã ne memã djwỳ nhigot djà jakren arẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ne kam tu Djeruxarẽ'ỳr kràkumrẽx ne. Ne kam apỹnh krĩ rũnhmẽ krĩ kryre kôt mõ. Kam memã Metĩndjwỳnh'ã ujarẽnh mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Djeruxarẽ'ỳr me mõrkôt ne memã 'ã ujarẽnh mõ nhym kam me'õ kum, —Bẽnjadjwỳr, djãm Metĩndjwỳnh kute me utàrja djãm me ngrêrebit? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Nhym kam memã, —Ẽ, kwãrĩk wãnh ga amũ me ja mar kêt. Nhym bep Metĩndjwỳnh dja ga amikajmã'ã ama. Ga me kikre jajkwa krekre ngrire kônh mrãnh, kônh ngjênhmã mrãnh tỳx ne kute ikjêo aben rẽnh ne mrãnh ne ngjêxja pumũ. Gadjwỳ dja ga ã amikam atỳxo anen Metĩndjwỳnh nhõ pyka'ỳr bôx. Ba me amã arẽ. Nãm me krãptĩ te 'ỳr àrmã. Dja me te o anen te o anen 'ỳr àr kêt ne. Kute mrãmri ne me te kikremã àr prãme ja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Dja õ kikre djwỳnh 'ỳr tẽn kikre'ã ijê, me abê kikre'ã ijê. Ga me kam wãnh kapôtã akumex. Ne kam 'ã ijê djà môro akumex. Te 'ã ijê djà môro akumex ne kam kum, “Bẽnjadjwỳr, amrẽ me imã kikre'ã ta ba me wãm wadjà”, anhỹro akumex. Te kum ane. Nhym kam me amã, “Kê waj, ije me amar kêt. Ije mỳjwã kurũm me ajapôx djàkôt me amar kêt”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dja ga me te kum, “Tô gêt anhikô'ã ne ba me inhõ kwỳ krẽn kôt ikõ ga me inhũrkwã kabe'ã me akreo mõ”, anhỹro akumex. ");
INSERT INTO txuNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nhym kam me amã, “Ba me amã arẽ ga me ikabẽn ma. Ije mỳjwã kurũm me ajapôx djàkôt me amar kêt. Rũm mãn me mõ, me aje ajaxwebit markam dja ga me rũm mõ”, ane. Dja ã õ kikre djwỳnh me kapôtã akumexjamã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ã me amã ane ga me kam amran amim angryk ne wãnh amijanên amijo pyka titik ar o aba. Abraãomẽ Idjakmẽ Djakomẽ Metĩndjwỳnh kabẽn jarẽnh djwỳnh kunĩmẽ dja me Metĩndjwỳnh nhõ pykakam ar ba, ga me te me omũ. Metĩndjwỳnh arỳm kute me utàr ne me kadjy bẽnjadjwỳr ne kute ar meo ba, õ pykakam kute ar meo baja dja ga me te me omũ, amybỳm me omũ ne kam ajte jãm amipumũn kam amikam angryk ne. Metĩndjwỳnh kute bõm me arẽnhkam gêdja ga me ã amim angryk o anen amran amijanên ar amijo pyka titik o aba. ");
INSERT INTO txuNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bir be, dja me apỹnh pyka kunĩkôt Metĩndjwỳnh'ỳr akuprõn kam kutã õ kwỳ krẽno kumex. Kàjkwa kraxrũm me jamẽ, kàjkwa nhôt kurũm me jamẽ, aktã kàjkwa nhirê'ãnh me jamẽ, me tãm dja me 'ỳr bôx ne kutã õ kwỳ krẽno kumex. Nhym bep Metĩndjwỳnh dja me ja kadjy bẽnjadjwỳr ne meo ba. ");
INSERT INTO txuNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nhym kam pykabê me 'uwtĩ, me kàtàm ar baja gêdja me kumrẽx Metĩndjwỳnh nhõ pyka'ỳr bôx. Nhym bep jakam me kute amirũnhbit mar ne kute amirũnh mar kanàrràm baja gêdja me pãnh me katẽn mrã, ane. Nãm ã Jeju memã Bãm nhõ pyka jarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nãm memã kabẽn jarẽnh pa nhym kam mebê pardjêu kwỳ 'ỳr bôx ne kam kum, —On ja kurũm tẽ, ane. On ja kurũm tẽ. Arỳm ne Erodji kute abĩnmã akangrô, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nhym kam memã kum, —Ãm me mõn kukônhwãmã arẽ, axwere wãmã arẽ, “Ota ba akati jakam arek me karõ punubê me utàro djan me kanêo mexo dja. Gêdja akati ba ajte tãm ne. Nhym ijã akati amãnhkrut ne ikjêkêt ba arỳm inom kumẽ.” Dja ga me ã kum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nà, mrãmri ne ba arỳm Djeruxarẽ'ỳr itẽmkumrẽxmã. Dja ba akati jakam meo mexo tẽn nõ nhym akati kêt ba ajte amũ tẽn 'ỳr nõ nhym akati ba arỳm 'ỳr bôx, Djeruxarẽkam bôx. Nhỹnh ne me kute atemã krĩrax 'õkam Metĩndjwỳnh kabẽn jarẽnh djwỳnh par djà 'õ got ba 'ỳr tẽ? Kati, Djeruxarẽ pydjii. Pydji ne ba arỳm 'ỳr itẽmmã. Kam gêdja me ibĩ, ane. Nãm ã Jeju mekbê pardjêumã ane. Ne kam ajte Djeruxarẽkam me ja'ã, ");
INSERT INTO txuNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","—Ỹ, Djeruxarẽ, Djeruxarẽ, mỳkam ne akra Metĩndjwỳnh kabẽn jarẽnh djwỳnh par prãm ne? Mỳkam ne kẽno me titik ne me kupa, Metĩndjwỳnh kute me awỳr me anorja pa? Ije nã bãm te ije me ajo ibikprõnh ne ije me ajo atommã. Kute mrãmri ne õkrẽnẽ'ãnh kute arao krao bikprõnhja pyràk. Ba ren ã me ajo ane. Nã bãm te ije ã me ajo anhỹrmã ga me. ");
INSERT INTO txuNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ẽ, jakam me amõr djà ja gêdja kukrit mex ne kaprỳn nõ. Ẽ, ba me amã arẽ, jakam dja ga me ipumũnh kêtkumrẽx ne. Ipumũnh kêt rã'ã: nhym inhõ akati ijo rãm ne jao tẽ ga me abenmã kum, “Ẽ, ota arỳm Metĩndjwỳnh kabẽnkôt tãmja bôxmã. Gê Metĩndjwỳnh o kĩnh.” Ga me ã abenmã ane ba kam arỳm me awỳr bôx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nãm memã kabẽn jarẽnh pan kam ajte tẽ. Nhym ajte pi'ôk ràràr nhym mekbê pardjêu nhõ bẽnjadjwỳr ngri'õ kum, —Amrẽ ikôt tẽn inhũrkwãkam ikutã anhõ kwỳ krẽ, ane. Nhym kum “Ã” anen kôt tẽn kutã õ kwỳ krẽ nhym me arek kam no tyn omũnho nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nhym Jeju kutã me'õ my nhỹ. Nãm prĩne igoto tuknĩ. ");
INSERT INTO txuNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nhym mekbê pardjêumẽ me kute Môjdjê kukràdjà mar djwỳnh arek Jeju pumũnho nhỹ. Kute o mex jabej ne me ikô'ã nhỹn omũnho nhỹ. Nhym kam memã, —Djãm ori me kute pi'ôk ràràrkam meo mexkam punu? Djori kam punu? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nhym me pijàm djàje anhikrê:n nhỹ. Nhym kam pa'ã byn kàjmã kudjan o mex ne kam ano. ");
INSERT INTO txuNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ne kam memã kum, —Gêdja me ajõ kra'õ, me ajõ nhõ krit'õ pi'ôk ràràrkam tẽn kreti, ngômkwatikam tỹm, mã gêdja ga on? Djãm aje arek pi'ôk ràràrkam omũnh kajgoo adjãmmã? Omũnh kajgoo adjãm nhym tykmã? Kati, gêdja ga pi'ôk ràràrkam o wabi, ngô kute bĩn kêtri, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nhym me ajte anhikrê:n nhỹ, ne te kute amipãnh kum kabẽn'õ jarẽnhmãn mrãmri nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nhym me õ kwỳ krẽno ỹrja, bẽnjadjwỳr kute memã arẽnh nhym me õ kwỳ krẽnmã ỹrja ne me kwỳ amijo rũnh prãm ne mekbê amijo me rũnh krĩ djà pytà. Nhym Jeju me omũn kam nêje memã kabẽn kadjy memã mỳjja'ã ajarẽ ne memã kum, ");
INSERT INTO txuNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","—Me kute abenã me rẽnhkam ne me àkur rũnhĩ. Nhym kute abenã me rẽnh djwỳnhja amã kabẽn jabej ne amã, “Amrẽ tẽn me kutã anhõ kwỳ krẽ”, ane. Ga kam tẽn ũrkwãmã wadjàn kam kwãrĩk wãnh ga amijo me rũnh krĩ djà pytàr ne kam anhỹr kêt. Dja me bẽnjadjwỳr'õ akôt bôx, kute raxo ajakrenh'õ akôt bôx nhym kam abenã me rẽnhdjwỳnh amã, “On kàjmã dja. On kàjmã dja gê tãwã nhỹ. Tãwã ne kute raxo ajakrenh. Ga dja ga tẽn me burũm nhỹ, me wã nhikô'ã nhỹ”, ane ga kam apijàm ne. Kute me ipôkri amã anhỹrkam dja ga apijàm rax ne. ");
INSERT INTO txuNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bep kati, dja ga anhõ kwỳ krẽn kadjy wadjàn tu me burũm nhỹ, me kàtàm ja nhikô'ã nhỹ nhym kam ta, abenã me rẽnhdjwỳnh ta gêdja amã, “Kati, Bẽpbãmre, amrẽ tẽn me rũnh krĩ djàkam nhỹn anhõ kwỳ krẽn mex”, ane. Ga kam arỳm 'ỳr tẽ. Ta gêdja arỳm me ipôkri ajo rax. Nhym me kunĩ arỳm araxkôt apumũ. Me aro'ã anhõ kwỳ krẽno anhỹrja dja me araxkôt apumũ. ");
INSERT INTO txuNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","E kum ẽ, me kute amijo rũnh prãmja gêdja me ĩ pijàm ne. Nhym bep me amikam pijàm ne akrànmã ar kute amijo baja gêdja arỳm Metĩndjwỳnh pãnh meo rũnh ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nãm ã Jeju me ro'ã õ kwỳ krẽno ỹrjamã anen kam ajte bẽnjadjwỳrjamã kabẽn ne. Ne kum, —Gêdja anhõ djwỳ kumex, anhõ mry kumex jabej ga arỳm anhõ kwỳ krẽn rax ne. Kàjkwa nhipôkri myt nhỹrkam nàr kon amykrykam anhõ kwỳ krẽn rax ne. Kwãrĩk wãnh anhõbikwamẽ akamymẽ anhõbikwa 'õmẽ me kute amimexjamẽ me jamã arẽnh kêt, anhõ kwỳ krẽn djàja jarẽnh kêt. Me kute akubyn amã o pãnh karõ me jamã arẽnh kêt. Mỳkam? Bir, ga ren anhõbikwamã mỳjja ngã nhym ren arỳm amipãnh amã mỳjja ngã. ");
INSERT INTO txuNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nhym bep kati, dja ga anhõ kwỳ krẽn rax kutã, kadjy me õ mỳjja kêt, me kute amijo bikẽnh, me akry, me no rã, me jamã akabẽn gê me akutã õ kwỳ krẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Metĩndjwỳnh dja pãnh ajo kĩnh ne. Me 'uwtĩja dja me te kute amã o pãnhmã. Nhym bep Metĩndjwỳnh dja amã o pãnh ne, me katàt mrãnh ne tyk ne akubyn tĩn nhõ akatikam gêdja arỳm amã o pãnh ne, ane. Nãm ã Jeju kum kabẽn jarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nhym kam Jejumẽ ro'ã me õ kwỳ krẽno ỹr ja'õ kuman kum, —Be, godja me'õ Metĩndjwỳnh nhõ kàjkwa'ỳr bôx ne kutã õ kwỳ krẽn jabej, dja mrãmri kĩnhkumrẽx ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nhym kam kum, —Me'õ ne arỳm kute memã djwỳ nhije djàrmã djwỳmẽ mry nhijeo nhỹ. Ne arỳm kadjy me krãptĩmã arẽ ne arỳm memã djwỳmẽ mry ga nhym arỳm xêr. ");
INSERT INTO txuNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Arỳm xêr nhym kam kadjy õ àpênhmã arẽn kum, “Mã tẽn ar wãmã arẽ. Ar wãmã arẽ gê amrẽ ar mõ. Dja ga arkum, ‘Arỳm ne xêr gwaj on 'ỳr banhõ kwỳ krẽ’, ane.” Amrẽbê ne kadjy memã arẽ ne kam ajte kadjy me'ỳr õ àpênh jano. Nhym kam õ àpênhja tẽn bôx ne te kadjy memã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nhym kam ar kunĩ apỹnh kukràdjàkôt kubê amikati ne. Ja kumrẽx ne kum, “Kati, ajbir ne ba amim pur byn kam ije omũnhmã 'ỳr tẽ. 'Ỳr tẽn kum ijarẽ. Dja ba wãm itẽm kêt ne. Kwãrĩk wãnh gê ikam ngryk kêt”, ane. “Nẽn”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nhym atãri ja kum, “Ota ba ajbir mryti krãptĩbê 10o bôx ne kam ije gop àpênh mex jabej, tỳx jabej ije kabimã 'ỳr tẽ. 'Ỳr tẽn kum ijarẽ. Dja ba wãm itẽm kêt ne. Kwãrĩk wãnh gê ikam ngryk kêt”, ane. “Nẽn”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nhym kam kute o ino rerja kum, “Ajbir ne ba iprõ ne kam te ije kum inhirer ne wãm itẽmmã”, ane. Nãm ar ã kubê amikatio ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nhym kam õ àpênhja tẽn bôx ne kum arẽ, õ bẽnjadjwỳrjamã arẽ. Nhym kam ngryk ne, õ bẽnjadjwỳrja ngry:k ne. Ne kam kum, “Amibêx ne amũ aprõt ne ajte me abej. Ngôo pry kamũn kikre bu kamũ. Ne amrẽ me õ mỳjja kêt, me kute amijo bikẽnh, me no rã, me akrywã kunĩo mõ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nhym kam õ àpênh meo bôx ne kam, “Be, ota ga aje imã me arẽnhja ba arỳm meo bôx nhym me kute kikre jaêr kêt rã'ãã”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nhym kam õ bẽnjadjwỳrja kum, “Ajte akubyn me'ỳr tẽn prykôt me abej ne purkamdjwỳ ajte me abej, ane. Memã arẽn me pa 'amỳn amrẽ meo mõ. Amrẽ meo mõn meo bôx gê me prĩne inhũrkwã kre jaê”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ba me amã arẽ, ije kumrẽx 'wỳrja gêdja mrãmri ikutã õ kwỳ krẽn kêtkumrẽx ne. Tãm ne ja, ane. Nãm ã Jeju mekbê pardjêumã anen kàjkwamã 'ỳr me bôx kêtmã ã arẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ne kam ajte Djeruxarẽ'ỳr krà. Nhym kam me itepato kôt mõ. Kôt mõ: nhym kam me'ỳr akẽx ne memã kum, ");
INSERT INTO txuNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Dja ga me ajõ mã ikôt abikamẽnh prãm jabej gora amã ijabê tỳxo, amã ikĩnh tỳxo amã anhõbikwa kĩnhja jakrenh mex ne. Dja ga amã abãmmẽ anãmẽ aprõmẽ akramẽ akamymẽ akanikwỳnhmẽ kĩnh kêt ne kam ga amã aminhĩdjwỳ kĩnh kêt ne kam bajbit amã ijabê tỳx ne kam arỳm abê inhõ àpênhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ne kam ajte dja ga me ajõ amã atokry pyma jabej kam arỳm ikôt aba djwỳnh kêtkumrẽx. Nhym bep kati, dja ga ijã amijakren ikudjwa aje anhõ pĩte'y mỳnh mãn pràbê atokry rax ne amã ijabê rã'ã nhym me kute abĩn jabej ga ikanga kêt ne tu mã ikôt ajkamẽn kam arỳm mrãmri ikôt aba djwỳnhkumrẽx, ane. Nãm ã Jeju memã anen kam ajte memã kum, ");
INSERT INTO txuNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","—Nà, dja ga me ajõ aje kikreti nhipêx jabej gêdja ga kadjy amikadjwỳnhbê amim 'ã karõ ne amim 'ã pi'ôk kaprĩ jakre kumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Got ga ren 'ã pi'ôk kaprĩ jakre kêt ne ren ipêxo mõ nhym ren kam abê 'ỳr pi'ôk kaprĩ atãk ne. Ga ren kam kum parbit pumjuw. Kum parbit pumjuw ne kam te aje inomã mẽnhmãn kam ren tu katẽri krãta. Nhym kam ren me kàtàmja ajã keket ne ren kam ajaprỳ, ");
INSERT INTO txuNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Tãwã ne kute kikre nhipêxo tẽm ne inomã mẽnhmã ar o ban kam katẽri krãta”, ane. Ga ren kam apijàm ne. Bir be, ã me kute ajã anhỹr kêtbê gêdja ga pi'ôk kaprĩ kumrẽx 'ã akre. Bir be, gêdja me'õ mã ikôt bikamẽnh prãm jabej, amim ijã karõ kumrẽx ne kam amim, “Ije ba on mã Jejukôt ajkamẽ ne kôt ar iba, o ino rer kêt, katẽri krã'yr kêt. Dja ba tu kôt ar ibakumrẽx ne”, ane. Dja ga ã me ajõ ijã amim karõo anen kam mã ikôt ajkamẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","32","Ba me amã ajte 'õdjwỳ jarẽ. Bẽnjadjwỳr ja ne arỳm kurê djwỳnh'ỳr õ àpênh jao mõ. Nhym õ àpênhja krãptĩ ne. Õ àpênh ne kubê 20.000. Nhym kum ỹrja nhõ àpênh ngrêre. Kubê 10.000. Nhym bẽnjadjwỳr ja kute nĩnh 'ỳr õ àpênho mõr ja ne kum ỹr nhõ àpênhja jakrenh mex ne. Nhym kam kum ỹrja bit kurê djwỳnh kutã õ àpênho mõn kam ajte amikam ajkam aman te kurê djwỳnh'ã õ àpênh jakren kam amim, “Ije, mỳj dja ba nẽ? Ije ba me'ỳr inhõ àpênh jano, nĩjar me mõr rã'ãri gê ikàxã mekmã ijã aprã. Bar arek apỹnh nhỹn idjumar mex”, ane. Nãm me ja bit kute me ja'ỳr prõtmãn kam te amikabin amikam ajkam aman tu akubyn akẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Be, dja ga ã amim ijã karõ kumrẽxo ane. Aje arek o atẽm ne aje inomã mẽnh kadjy, katẽri krã'yr kêt kadjy. Dja ga amikabi kumrẽx ne kam anhõ nêkrêx, anhõ mỳjja kunĩ'ã ano tỳx kêt ne tu amibê kanga ne kam mrãmri ikôt aba djwỳnhkumrẽx. Nhym bep kati, dja ga anhõ nêkrêx 'amỳnh tỳx ne kam arỳm ikôt aba djwỳnh kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ẽ, kadjwanhĩ. Kadjwanhĩ ne mexri ànhkumrẽx, akrykumrẽx. Nhym bep arỳm tũmkam ành kêt, akry kêt nhym me kute ajte o mex kêtkumrẽx. Me te o ane. Mrãmri tu akry kêt. Mỳj kadjy ne ga ar o aba kajgo? Kajgo mexi. ");
INSERT INTO txuNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","O me kute djwỳ kane kêt ne kute mry nhĩnmẽ o bikàr ne kute o pidjôjadjwỳ kane kêt. Nãm me tu o ban mũm kurẽ. Arỳm mrãmri akry kêt. Kajgo mexi. Gop me ajamakkre jabej, gop on ama, ane. Nãm ã me'õ kute amijo Jeju pytàr ne kôt tẽm ne katẽri kubê akẽxkam ã kajgo ane, kum õ nêkrêx kĩnhkam kute kubê akẽxkam ã kajgo ane. Djã nãm mrãmri mã Jejukôt ajkamẽ got? Kati, nãm 'êx ne kôt ar ba kajgo. ");
INSERT INTO txuNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nhym kam me kute bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnhmẽ me axwe ajte Jeju'ã akuprõn kuri kumex, me kute kabẽn marmã ne me 'ã akuprõn kuri kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nhym kam mekbê pardjêumẽ me kute Môjdjê kukràdjà mar djwỳnhmẽ ne me kàxã kabẽn ne, bẽn prĩkam kabẽn ne abenmã, —Djidjàk, tãwã ne kum me axwebit kĩnh ne ajte ro'ã mõn õ kwỳ krẽno nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nhym kam atemã memã mỳjja'ã ujarẽnh jakreo tẽn memã, ");
INSERT INTO txuNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Birãm me ajõ nhõ krit, mrykĩ'ãtomti krãptĩbê 100. Dja abê pydji akuno ga kam mã dja ga on? Dja ga tu anhõ mrykĩ'ãtomti krãptĩbê 99jamã anhire gê wãnh akutêp kumex, kapôt kukritkam kumex ga kam pydji biknorja jabej tẽ. Abej tẽ:n arỳm kum akaton aprôn o tẽn o bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aprôn o tẽn o bôx ne kam akĩnh ra:x ne. ");
INSERT INTO txuNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Akĩnh rax ne kam anhõbikwamẽ anhũrkwã nhitepã me jao akuprõn kam memã kum, “Ota ba arỳm inhõ krit ibê biknorja japrôn o tẽn o bôx. Dja ga me idjô'ã akĩnh ne akĩnh rax”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Bir be, gêdja ã kàjkwakam me kĩnho ane. Me'õ pydji gêdja amim katon wãnh axwemã iren Metĩndjwỳnh'ỳr amijo akẽx nhym kam me kĩnhkumrẽx. Me'õ pydjikam dja kàjkwakam me kĩnh rax ne. Kam kĩnh raxo me mex, me krãptĩkam kĩnhja jakrenh mex ne. Me kute, “Bep ba ne ba katàt mrãn imexkumrẽx”, anhỹr ne ajkwaobit kute amimex jarẽnhja ne Metĩndjwỳnh kute meo mex kêtê. Nhym kam kàjkwakam me jadjwỳ mekam kĩnh kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ba ajte me amã 'õdjwỳ jarẽ. Me'õ nire nhõ kryt jakao ngônhponho pi'ôk kaprĩbê 10 ne pydjin kubê akuno, pãnh ra:xkam. Mã dja on? Dja ngônhpôktimã adjàn kam prĩ:ne ar abej kapõnho ban kam kum kato. ");
INSERT INTO txuNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kum katon kam õbikwamẽ itepã kikrejakam me jao akprõn memã kum, “Me ikôt akĩnh. Ota ba arỳm ije pi'ôk kaprĩo ibiknorjamã ikato”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Bir be, ba me amã arẽ. Dja Metĩndjwỳnh kadjy mrãnh djwỳnh ã kĩnh ane. Me'õ pydjin amim kator ne kute wãnh axwemã irern kam kute Metĩndjwỳnh'ỳr amijo akẽx nhym kam ã kadjy mrãnh djwỳnh kam kĩnh ane. Nãm ã Jeju memã ujarẽnh ane. ");
INSERT INTO txuNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","12","Ne kam ajte memã 'õdjwỳ jarẽn memã, —Me'õ my kra amãnhkrut nhym kam kutapureja bãmmã kum, “Djũnwã, gop on ar imã anhõ nêkrêx kwỳo ajkjê. Aje ar imã atyk kutã nêkrêxo abikjêrmã arẽnhja on atĩnri ar imã o ajkjê, ar ije kam amak kêt kadjy”, ane. Nhym kam kum “Ã” anen kam arkum o ajkijn kutapure jamã kungãn kutewajamã kungã. ");
INSERT INTO txuNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nhym kam bãm kute kum õrja arỳm amim kuby, kutapureja amim kuby. Nhym kam 'ã akati ngrêre nhym kam arỳm mã o mõ, õ mỳjja kunĩo atom ne o mõn ajbubê o tỹm, pyka 'õkam o mõn o bôx ne kam arĩ:k ar o ba. Tu arĩk ar ba'ã pi'ôk kaprĩ krẽno tẽ:n kam krẽn pa. ");
INSERT INTO txuNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Prĩne 'ã pi'ôk kaprĩ krẽn mex ne, ne kam arỳm arĩk ar ba. Nhym kam pykawãkam arỳm djwỳ kêtkumrẽx, nhym me prãmkam ar ba. Nhym kam pi'ôk kaprĩ krẽn pan kam tu arĩk ar ba, prãmkam ba. ");
INSERT INTO txuNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ne kam bẽnjadjwỳr 'õ'ỳr tẽn kam kum, “Ba amã apê”, ane. Kum àpênh nhym kute kum pi'ôk kaprĩ nhõr nhym kute o mỳjja byr ne krẽnmã. Nhym kam bẽnjadjwỳrja “Ã” anen kam õ mry nhõ kapôtmã ano, kute angrô jamyre pumũnh ne kute kum o djuw mexmã. Nhym kam kum omũnho dja. ");
INSERT INTO txuNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nhym kam angrô jamyre bày kakô kuro ba nhym kubêngôkreja arỳm prãm bĩn mex nhym te kute angrô jamyre kutã bày kakô kwỳ krẽnmã. Nhỹnh ne me'õ got kute kum mỳjja 'õ nhõr nhym kute krẽnmã? Arkati. ");
INSERT INTO txuNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nãm ar ban kam amim katon kam amim, “Ije, djã nãm ã ibãm nhõ àpênhja anen ar prãmkam ba? Djũnwã ne prĩne õ àpênho djuw mex nhym kam djwỳ kumex. Djwỳ kumex ne kam 'ã kàtàm ne kumex. Mỳkam ne ba bajbit ar prãmkam iba. ");
INSERT INTO txuNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ba gêt on akubyn ibãm'ỳr tẽn kum, ‘Djũnwã, ota ba Metĩndjwỳnhkam ar amikrào iba, ne gadjwỳ akam ar amikrào iba. ");
INSERT INTO txuNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Djãm imex ne ga aje ijo akra rã'ãmã. Dja ga tu ijo anhõ àpênh, ijo ajtem ne. Ba kam amã apê.’ Gêdja ba ã Djũnwã'ỳr tẽn kum ane.” ");
INSERT INTO txuNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ne kam ekrux ne kàjmã djan kam bãm'ỳr tẽ. Bãm'ỳr tẽ: nhym kam bãmja amybỳm omũ, kraja pumũ. Ne kam rerek ne, tik ngyo nhỹn kum kaprĩ ne. Ne kam prõt ne kajpan o tỹm ne kam abej muw. ");
INSERT INTO txuNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","22","Nhym kam bãmmã kum, “Djũnwã, ota ba Metĩndjwỳnhmẽ ar akam ar amikrào iba. Djãm imex got ga aje ijo akra rã'ãmã”, anhỹr konenh nhym bãmja õ àpênhmã kum, “Amũ ar ajõ aprõt ne kubẽkà mexwãmẽ ikrakam ràxwãmẽ parkàwãmẽ amrẽ amỳn o aprõt ne kum angjê, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ne ãm ar ajõ aprõt ne ije kutêp mryti jabatành nyre nhĩptĩ'ã ma nhym ãmwã japrôn amrẽ o tẽn abĩ. Gwaj banhõ kwỳ krẽn rax ne bakĩnh kadjy. ");
INSERT INTO txuNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ota ikra. Be, ikra djwỳnh ja ne ibê tyn ajte akubyn tĩn ne. Nãm akunon arỳm akubyn imã kato”, ane. Nhym kam me kĩnh rax kato. Kĩnhkumrẽx ne õ kwỳ krẽno kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","26","Nhym kam kutewaja purkam àpênho dja. Àpênho dja:n àpênho ino ren kam kurũm tẽ. Tẽn kam kikre têpo tẽn me kanga ma. Me toro dja nhym me ngrer man kam amikutã bãm nhõ àpênh 'uw. Nhym kutã tẽn kajpa nhym kum, “Mỳj nã”? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nhym kam kum, “Ije atõnhre ne arỳm bôx. Nhym kam abãm kadjy mryti jabatành nyreja bĩ, twỳmtija bĩ. Nhym abãm kĩnhkumrẽx ne. Amrẽbê: atõnhre tẽm ne arỳm bôxkam ne abãm kĩnhkumrẽx ne. Mỳjja kute ajmã o kêt, umar mex ne ar ban arỳm bôx, kam ne abãm kĩnhkumrẽx ne”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nhym kam tu ngry:k ne kikremã àr kêtkumrẽx ne. Ne kam kapôtã arek ngryk ne dja. Dja nhym bãm 'ỳr katon te kum kabẽn ne, te kum me tor'ã apnên kum, “Amrẽ tẽn anhõ kwỳ krẽn me kudjwa akĩnh”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nãm te kum ane nhym kam kum, “Kê wajre. Nã bãm amã idjàpê:nh ar iba. Arỳm idjàpênh'ã amex krãptĩĩ. Djã nã bãm abê amikati? Ga mỳjja 'ỳr ijano ba ‘Kê wajre’ ane? Kati, nã gãm mỳjja 'ỳr ijano ba akrànmã amã 'ỳr mrã. Djã ne ga kam mãn imã anhõ mokaàk'õnh bĩ bar inhõbikwamẽ ro'ã kwỳ krẽno nhỹn ikĩnhkumrẽx ne? ");
INSERT INTO txuNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nhym bep akamrerre ne anhõ nêkrêxo mõn me kuprỳ'ã kukrẽn mõn ajbir bôx ga kum gu banhõ mryti twỳmtija bĩ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nhym kam bãmja kum, “Akmere ga ne ga arek ikuri dja. Ne inhõ mỳjja kunĩo anhõ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mrãmri ne bar ikĩnhkumrẽx ne. Mrãmri ne bar ikĩnh ne itor inhỹrja. E kum mrãmri ne atõnhre gu babê tyn ajte akubyn tĩn ne. Nãm akunon arỳm akubyn kato, ane. Nãm ã bãm kutewajamã ane. Tãm ne ja. Be, nãm ã Jeju mekbê pardjêumã ujarẽnh ane. Metĩndjwỳnh kum me axwedjwỳ jabên kute me abej ne kute me utàr nhym me ô'ã kĩnh'ã ujarẽnh ne ja. ");
INSERT INTO txuNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nhym kam Jeju ajte kute kôt ba djwỳnhmã mỳjja 'õ'ã kabẽn jakremã arkum, —Me'õ bẽnjadjwỳr ne õ pi'ôk kaprĩ kumex. Nhym kam õ àpênh ne kum kam àpênho dja. Pi'ôk kaprĩmẽ nêkrêxja kunĩkam kum àpênh ar ba. Nhym kam me kàtàm ne me kum õ àpênhja jarẽn kum, “Ẽ, ota anhõ àpênh arỳm abê amijã anhõ pi'ôk kaprĩ krẽno mõ, ane. Arỳm abê o apêx mexo mõ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nhym kam arỳm õ bẽnjadjwỳrja amiwỳr ku'uw ne kum, “Mỳj nã? Mỳj ne ga ajmã o nhym me imã ajarẽ? On amrẽ inhõ nêkrêx'ã pi'ôk no'ôkwão akato ba omũ. Jakam dja ga imã adjàpênh kêtkumrẽx ne”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nhym kam kabẽn ja man kam õkre kadjwỳnhbê amim, “Ije tô mã dja ba nẽ? Arỳm ne inhõ bẽnjadjwỳr bõm imẽ. Mã dja ba nẽ? Ãm arngro tỳxkam purkam idjàpênhbê irerekre ne kikre kabe'ã idjà'wỳr imrãnhbê ipijàmà”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nãm ja jarẽn nhỹn kam ajkam aman kam, —E kum ã ane. Arỳm ne ba kuma. Jakam dja ba ar jamã ikabẽn jarẽ nhym arỳm inhõ bẽnjadjwỳr kute bõm imẽnhkam ar ja arỳm ijo õbikwan amiwỳr ijo wadjà, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ne kam ar kute bẽnjadjwỳrmã pãnh kêtja amiwỳr ar ku'uw. Amiwỳr ar ku'uwn arkum, “Mã ne ga aje mỳjjao pãnh kêtja kute?” ");
INSERT INTO txuNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nhym kam kum, “Ngônh krõkrõktibê 100. Rõny kangô'ã ngônh krõkrõktibê 100 ne ba kum o pãnh kêt ne”, ane. Nhym kam kum, “Mĩ. Aje pi'ôk no'ôk tũmja byn on o nhỹn 100ja ngràn pãnh 50 nhô”, ane. Ajêx ne kum ngrêre jarẽn kum 50 nhô, ane. Nhym kam ã anen kam kĩnhkumrẽx ne kunhôn mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nhym kam ajte abej ja kukij ne kum, “Mã ne ga aje mỳjjao pãnh kêtja kute”? ane. Nhym kam kum, “Bàygogore'ã xakubê 100”, ane. Nhym kam kum, “Mĩ. Anhõ pi'ôk no'ôk tũmja by gê arĩk wãnh 100 nõ, ga pãnh kum 80 nhô, ane. Ajêx ne 'ã kum kàjbê krãptĩbê 80 nhô”, ane. Nhym kam ã anen kunhôn kam kĩnhkumrẽx ne mã tẽ. Nãm ã arkum o anhỹro tẽ. Õ àpênhja arkum õ bẽnjadjwỳrja noo biknoro anhỹro tẽ. We arkum kĩnh ne kute amipãnh o õbikwamã ne ã arkum o anhỹro tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nhym õ nêkrêx djwỳnh ne õ àpênhja no mex jarẽ. Àkĩnhĩkam ne kum no mex jarẽ. Nà, mrãmri ne amikadjy no mexkumrẽx. Nà, mrãmri ne pykabê me ar baja ne me mrãmri amikadjy no mexkumrẽx ne o Metĩndjwỳnh nhõ me ja jakrenh mex ne. Nhym bep Metĩndjwỳnh nhõ me ja ne Metĩndjwỳnh kadjy amak mex ne kam kute a'uri me mrãnhja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Djãm ã ar aje õ àpênh kudjwa me noo abiknoro anhỹrmã ne ba ije ar amã arẽnhja? Djãm ar adjàkĩnhĩ, ar ajêxnhĩkôt aje meo anhõbikwamã got. Djãm ar aje pi'ôk kaprĩkôt meo anhõbikwa nhym atykkam kute amikôt kàjkwamã ajo àbirmã got. Djãm me ja kute kàjkwamã ajo àbir gar atĩn rã'ã rã'ãmã got. ");
INSERT INTO txuNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Arkati. Gêdja me'õ mỳjja kakritte kumrẽx, mỳjja ngrire kam àpênho djan prĩne o djuw mex ne o àkĩnh kêt, me'õ tãm gêdja arỳm ajte amũ ijukri mỳjja rũnhdjwỳo djuw mex. Nhym bep kati, gêdja me'õ mỳjja kakrittekam àpênho djan arỳm o akĩ ne kam ajte mỳjja raxkamdjwỳ àpênho djan adjwỳnhdjwỳo akĩ. ");
INSERT INTO txuNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bir be, tãm. Dja gar pykabê mỳjja kakrit, pi'ôk kaprĩjao akĩ djãm Metĩndjwỳnh kute kàjkwakam õ mỳjja rũnh, õ mỳjja mextire kute ar amã õrmã got? Kati, arỳm ne ar akabi. ");
INSERT INTO txuNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Dja gar ari me õ nêkrêx prokam amikràn o adjàkĩnho aban ar mekbê o abikẽnho aba, djãm Metĩndjwỳnh kute ar amã anhõ mỳjja nhõrmã, anhõ nêkrêx djwỳnh kute ar amã õrmã? Arkati. ");
INSERT INTO txuNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ẽ, nhỹnh ne me'õ õ bẽnjadjwỳr amãnhkrut'õ amẽ arkum àpênh ar ba? Kati, gêdja o anen kam te o ane. Gêdja kum ja kurên kam kum ja jabê. Nàr kon, gêdja kum ja kĩnh ne kumãbit apê ne kam kum ja kurên kum àpênh kêt ne. Dja ga amã Metĩndjwỳnh kĩnh ne ajte amã nêkrêx kĩnh ne kam kute bẽnjadjwỳr amãnhkrutmã adjàpênh pyràk. Gêdja ga te o ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nhym bep mekbê pardjêu ne me Jeju kabẽn maro nhỹn aprỳo kumex. Me kum pi'ôk kaprĩ kĩnhkam, kam ne arẽ nhym kam me aprỳo kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nhym kam Jeju memã kum, —Me ga ne ga we me amijo katàt amrãnh ne. Me kunĩ kute we me amex pumũnh ne kute me amã me amex jarẽnhmã ne ga we me amijo katàt amrãnh ne. Nhym bep kati, Metĩndjwỳnh ne kute prĩne me akadjwỳnhbê me apumũnh. Me aje amim mỳjja'ã karõjakôt ne me akadjwỳnhbê prĩne me apumũ. Be, mebêngôkre ne me me akrãkàbit pumũ, ga me kam kute amex pyràk nhym me me amex jarẽ. Bep kati, Metĩndjwỳnh kute prĩne me akadjwỳnhbê me apumũnh nhym mỳjja punubit me akadjwỳnhbê ikwãkam kum me amex kêt. Mrãmri me apunukumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Amrẽbê ne me Môjdjê kukràdjàkôt ar amijo ba. Metĩndjwỳnh kabẽn jarẽnh djwỳnh kabẽnkôtmẽ ar amijo ba. Ar kôt me kute amijo ba rã'ã nhym arỳm Djuão ajte adjwỳnhdjwỳ bôx. Djuão kute ngônhmã me angjênhja adjwỳnhdjwỳ bôx. Ajbir ne Djuão tũmràm bôx ne ar memã 'ã ujarẽnh ny jarẽnho ba. Me kute axwemã irern kute Metĩndjwỳnh'ỳr amijo akẽx nhym Metĩndjwỳnh kute me utàr ne me kadjy bẽnjadjwỳr ne ar kute meo ba'ã ne memã ujarẽnh tẽ. Nhym me krãptĩ arỳm kute 'ỳr amijo akẽx prãmkumrẽx, kute mrãmri ne me krãptĩ kikre ngriremã ngjênh prãm ne kam 'ã kute aben nhingãnhja pyràk. Me kute ari 'ã ikjêo aben rẽnh ne 'ã kute aben nhingãnho kumexja pyràk. Nãm me ã kute Metĩndjwỳnh'ỳr amijo akẽx prãmkam ã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nhym Metĩndjwỳnh kukràdjà tũmja, kute me mrãnh mex'ã memã karõja, djãm arỳm tũm ne apêxmã? Kati, gêdja rã'ã ne. Pykamẽ kàjkwabit dja apêx nhym bep Metĩndjwỳnh kabẽn dja tũmràm rã'ã rã'ã ne. Nhỹnh ne mỳjja ngrire, mỳrbê itàja 'õ biknormã? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ne kam ajte Metĩndjwỳnh kukràdjà 'õ jarẽ. Me kute tu prõ'ỳr bakumrẽx ne kute kanga kêtmã memã arẽ ne memã kum, —Gêdja me'õ prõ'ỳr mõn ar o ban kanga ne kam pãnh atemã me'õ'ỳr mõn kam kute krô'ã prõ pyràk. Mjênja ne axwe. Nhym kam ajte me'õ ne prõ kanga nhym kam me'õja ne me'õ kute prõ kangaja'ỳr mõn kam arỳm kute me'õbê prõo àkĩnh pyràk, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nãm ã Jeju memã anen kam ajte memã mỳjja 'õ'ã karõ ne memã, —Me'õ ne õ nêkrêx kumex ne kute amidjwỳnhbit mar. Nãm kubẽkà mex, kubẽkà pãnh raxbit jangij ne õ kwỳ krẽn djà mexbit kute mar. Myt kunĩkôt ne ã o anen õ kwỳ krẽn rax ne. ");
INSERT INTO txuNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Nhym kikre jajkwa krekremã me'õ bikẽnhja ikwã. Myt kunĩkôt kikre jajkwa krekremã ikwã. Ne te kute õ anhy krẽn prãme. Me'õ kute myt kunĩkôt kubẽkà mex, kubẽkà pãnh rax jangjênh ne 'ã mrãnhja tãm ne te kute õ anhy krẽnmã kuri ikwã ne te 'ã 'wỳro ikwã. Idjibê ne Radjaru. Tãm ne prĩne karỳr tỳx ne, têmẽ prĩne tỳx ne. Karỳrmẽ tê tỳx nhym ta ikwã. Nhym bep roprebit ne 'ỳr màt ne karỳr kunuw, tê kunuw. ");
INSERT INTO txuNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nhym õ mỳjja kêtja, Radjaru, arỳm ty nhym kam kadjy mrãnh djwỳnh kumỳn kàjkwamã Abraão'ỳr o tẽn o bôx. Nhym kam ar ingêt kukãmãre Abraãomẽ ro'ã ar ba. Nhym me'õ nhõ nêkrêx kumexjadjwỳ ty nhym me kam o mõn adjà. ");
INSERT INTO txuNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","O mõn adjà nhym kam me tyk nhõ pykakam bôx ne kam tokry rax ne. Tokry: ne, ne kam tokry pymaje kàjmã rĩt ne amybỳm Abraão pumũ. Nhym ar Radjarumẽ ro'ã ar ba. Ar umar mexkumrẽx ne kĩnhkumrẽx ne ar ba. ");
INSERT INTO txuNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nhym kam Abraão pumũn kam kum amijo akijn kum, “Ngêtwa, ngêtwa Abraão, gop amrẽ amã ikaprĩn iwỳr Radjaru jano gê amrẽ iwỳr tẽn ngômã ikra nhôttebit jadjàn o inhõto ngo, ane. Ota ba kuwyjakam itokryo bit itokry”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nhym Abraão kum, “Bir be, krãny, omũ. Atĩnri ne ga mỳjja mexbito amikĩnh ne. Nhym bep Radjaru ne kaprĩ, tĩnri kaprĩn ar ba. Ne kam arỳm jakam kĩnhkumrẽx ne. Ga ne ga arỳm pãnh atokryn akaprĩre. ");
INSERT INTO txuNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ẽ, mỳjja 'õdjwỳ. Djãm jãnh ne wãm awỳr tẽm ne kute ajmã ajomã? Nãm me banêje inuwti: nõ, ne kam abenmã kre raxi. Ne kam jakam me ijõ'õ me awỳr itẽm prãm kêtê. Ga me ajõ nĩnh pãnh me ikam abôx prãm kêtê. Aprakamã ne gwaj banêje inuwti: nõ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Nhym kam kum, “E kum ã ne. Ẽ, ngêtwa, gora ibãm nhũrkwã'ỳr Radjaru jano. Kam ne ikamy amãnhkrut ne amãnhkrut ne ikjêkêt. Ar'ỳr dja Radjaru tẽn arkum arẽn arkum tĩn jadjà gê ar jakam, me tokry rax djàjamã ikôt bôx kêt”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nhym Abraão kum, “Kati. Arkati, amrẽbê ne Môjdjêmẽ Metĩndjwỳnh kabẽn jarẽnh djwỳnh ar 'ã pi'ôk no'ôk ne te memã arẽ. Gê ar Môjdjê ar kabẽn ma”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nhym kam kum, “Kati, ngêtwa Abraão, got ren me'õ me tyk kurũm me'ỳr katon bôx ne memã arẽ nhym ren me arỳm kôt amim katon kam ren wãnh axwemã iren Metĩndjwỳnh'ỳr amijo akẽx ne jakam bôx kêt ne”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nhym Abraão kum, “Kati, dja me Môjdjêmẽ Metĩndjwỳnh kabẽn jarẽnh djwỳnh kabẽn mar prãm kêt, nhym ajte me'õ me tyk kurũm katon te memã amijo amirĩt ne te memã arẽ nhym ren ajte tãm ne. Te ren omũn tu ate krã”, ane. Nãm ã Abraão me'õ nhõ nêkrêx kumexjamã ane. Tãm ne ja, ane. Be, nãm ã Jeju memã ujarẽnh ane. ");
INSERT INTO txuNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Ne kam ajte kôt ba djwỳnhmã, —Wãnh ne me axwe pro ar akukãm rax ne nõ. Nhym bep me kute memã axwe'ã àpnênhja gêdja me tokry ra:x ne. Watĩ:re. Dja prĩne Metĩndjwỳnh meo ajkẽ nhym me tokry ra:x ne. Me'õ kute me prĩre pyràk ne ajbir kute amim imar nyja nhym ren me'õ axwe'ã kum apnê nhym ren arỳm kôt axwe nhym kam ren me kute kum axwe'ã àpnênh djwỳnhja nhõkre'ã kẽnpoti nhô ne ren ngônhmã kumẽ, ngô raxbê pyka kêtmã kumẽ nhym ren kubĩ, ja ne kàjbê tokry. Tokry ngri. Nhym bep kati, dja prĩne Metĩndjwỳnh o ajkẽ nhym tokry ra:x ne. ");
INSERT INTO txuNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gora ar amijã ano tỳx ne amijãno dja. Dja ar akamy'õ axwe jabej gar ajõ kum akabẽn'õ jarẽ. Kum akabẽn'õ jarẽ gê axwekam amim ngryk ne amim kato ga kam tu o akno. ");
INSERT INTO txuNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Gêdja mã akam axwe jabej ga kam tu o abiknorkumrẽx. Dja myt pydjikam akam axwe amãnhkrut ne amãnhkrut ne amãnhkrut ne ikjêkêt ne kam awỳr tẽm ne kute amã, “Arỳm ne ba ijaxwekam amim ingryk ne”, anhỹr amãnhkrut ne amãnhkrut ne amãnhkrut ne ikjêkêt jabej ga kam tu o akno, ane. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nhym kute ar anor nhym ar mõrja Bẽnjadjwỳrmã kum, —Ar ba ne bar ije amim amar ngrire. Gop on ar ikadjwỳnhbê ar ijo tỳx ne ar ikadjwỳnhbê akabẽn wadjà bar amim amar rax. ");
INSERT INTO txuNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nhym kam Bẽnjadjwỳr arkum, —Ga ren ar amim ikamnhĩx ngrireo kute motadu 'y kryre ja pyràk ne ren arỳm pyjamã akabẽn ne ren kum, “On amikaban ngô raxbê pyka kêt mũ jakam mãn ajte dja”, ane. Nhym ren tẽn ngô rax nĩjkam dja. Ar aje tu amim ikamnhĩxkumrẽxkam ren tẽn nĩjar ngô raxkam dja. Nhym bep kati, ãm ar aje amim ikamnhĩxkumrẽx kêtê, ane. 'Ybê motadu ne kryre kute karnhô nhijy pyràk. Nhym Jeju ajte arkum, ");
INSERT INTO txuNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ga we ar ajõ abẽnjadjwỳr rax ne nhỹ. Nhym kam anhõ àpênh purkam àpênhmã tẽ, nàr kon kute mrykĩ'ãtomtio djuw mexmã 'ỳr tẽ. Ne kam wãnh purkam àpênho dja. Àpênho dja:n arỳm àpênho ino ren bôx. Djãm aje kum, “Amibêx ne nhỹn atyk djà kêt ne kam anhõ kwỳ krẽ”, anhỹrmã got. ");
INSERT INTO txuNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bep kati, dja ga ajte tu ano ne kum, “On imã õmrõn kam kadjy tẽn kubẽkà mex jadjàn amrẽ imã õmrõo tẽ ba kukrẽ. Ne ngôdjwỳ imã kwỳ jadjà. Dja ba inhõ kwỳ krẽn kôt ikõ, ane. Ba ikumrẽx inhõ kwỳ krẽn pa ga kam ikudjwa anhõ kwỳ krẽn kôt ikõ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Djã nãm bẽnjadjwỳrja õ àpênh djàpênho amra got. Djã nãm õ àpênh djàpênh pumũn kum mex jarẽnho ba got. Kute kabẽn mar ne kute kôt amijo bakam, djã nãm kum mex jarẽn kam kum amikĩnh jarẽnh ar o ba? Kati, mrãmri ne õ àpênh. Õ àpênh kute õ bẽnjadjwỳr kabẽn mar ne kute kôt kum mỳjja kupênh. ");
INSERT INTO txuNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bir be, ar gadjwỳ dja gar Metĩndjwỳnh kute ar amã mỳjja jarẽnhja kunĩ kupên amidjàpênh pumũn kam, “Ije, djã nã bãm ar Bẽnjadjwỳrmã idjàpênh mex ar iba got ar ijo amra? Kati, dji Bẽnjadjwỳr kute me anor nhym õ àpênh kute kum àpênhmãkêt. Kôt ne Bẽnjadjwỳr ar ijano bar kum idjàpênh iban ikĩnhkumrẽx ne, ane. Djãm kute ar idjàpênho àmra kadjy ne bar kum apê? Kati, nã bãm ar tu akrànmã kum idjàpênh iban kam ikĩnhkumrẽx ne”, ane. Dja gar ã ane. Be, nãm ã Jeju kôt ba djwỳnhmã arẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ne kam ajte Djeruxarẽ'ỳr kràn tẽn pry pnã, aben nêje a'yr. Nãm mũm pykabê Xamarij ne amrẽ pykabê Garrêja nhym pyka 'yr nhõkre djàkôt pry ja'ã tẽ, 'ã Djeruxarẽ'ỳr tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Nãm pry'ã tẽn kam ĩ krĩ 'õmã àr tẽ. Krĩ 'õmã àr tẽ nhym me ĩ kajêkam tê kutã mõ. Me ĩ kajêkam têbê 10 ne kutã mõn kajpan kam nĩjar ku'ê, tãri ku'ê kêtê, nĩjar ku'ên kam kàj bê kum kabẽn ne kum, —Jeju, Bẽnjadjwỳr, gop amã me ikaprĩ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nhym Jeju me omũn kam memã, —On me mõn me kadjy Metĩndjwỳnh mar djwỳnhmã amibẽ, ane. Nhym me mõr pro akẽx ne mã Metĩndjwỳnh mar djwỳnh'ỳr mõn mõrràm arỳm kà mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nhym kam pydjin amimex pumũn kam akubyn Jeju'ỳr tẽ. Metĩndjwỳnhmã ukaprĩ, mex jarẽnho tẽ. Kàj bê kum arẽnho tẽn kam Jeju'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jeju'ỳr bôx ne kam tu mỳrbê tỹm ne kum amikĩnh jarẽnho nõn kum mex jarẽnho nõ. Me bajtem'õ, Xamarijkam me ja'õ. Tãm ne akubyn tẽn Jejumã mex jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Nhym kam Jeju memã, —Ije, nhãr me? Nã bãm mebê 10o mex nhym me 'õ akubyn iwỳr tẽm kêt ne. Mỳkam ne kubajtemjabit akubyn iwỳr tẽ? Mỳkam ne me wã akubyn kudjwa mõr ne Metĩndjwỳnhmã mex jarẽnh kêt ne? ");
INSERT INTO txuNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ne kam kum, —Aj, on kàjmã djan tẽ. Nã gãm tu amim ikamnhĩxkumrẽx ne. Nhym kam arỳm Metĩndjwỳnh apytà, ane. Nãm ã Jeju kum ane nhym kam mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nhym kam mebê pardjêu Jejumã, —Mỳj akatikam dja Metĩndjwỳnh me bawỳr Bẽnjadjwỳrbê kumkati jano nhym kute me bakurê djwỳnhbê me bapytàr ne kute ar me bajo bamã? Nhym kam memã, —Kute me apytàr ne ar me ajo ba kadjy, djãm Bẽnjadjwỳrbê kumkati mỳjja 'õmẽ ro'ã bôx ga me aje kôt omũnh ne aje abenmã bôx jarẽnho akumexmã? Kati, me kute mỳjja 'õkôt omũnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Me kute jakam mỳjja pumũnh ne kute abenmã, “Ota, Bẽnjadjwỳr arỳm bôx”, anhỹr kêt. Nàr kon, me kute nĩjar omũnh ne kute abenmã, “Orĩnã, arỳm Bẽnjadjwỳr amrẽ tẽ”, anhỹr kêt. Mỳkam? Bir, anhõ Bẽnjadjwỳrbê kumkati kute ar me apytàr ne me akadjy bẽnjadjwỳr ne kute ar me ajo bamã ne arỳm me awỳr bôx, arỳm me anhipôkri bôx, me anhipôkri ar ba, ga me omũnh kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ne kam ate kôt ba djwỳnhmã, —Adjỹm, dja ĩ ar akaprĩ djà ar awỳr bôx. Ar akaprĩ djà nhijukri dja gar te ikuka kre jabej rĩt. Ne kam abenmã, “Gora gê on ajte akubyn bôx gwaj omũ. Amrẽbê kute gwaj bakadjy amijo ĩ ne gwaj bawỳr rwỳkja gora gê akati pydjikam ajte rwỳk jabej gwaj gop ajte omũ”, ane. Dja gar te aje ipumũnh prãme. ");
INSERT INTO txuNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nhym me ar amã, —Ota arỳm bôx, ota arỳm jakam bôx, anhỹr jabej, nàr me ar amã, “Ẽ, onĩj arỳm bôx”, anhỹr jabej ga kam ar tu ate akrãn 'ỳr amõr kêt ne mekôt 'ỳr aprõt kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nhym bep kati, ibôx djà gêdja amirĩ:tkumrẽx ne. Amirĩtkumrẽx nhym me kunĩ omũ. Ba ije amijo inhĩ dja ba akubyn bôx nhym me kunĩ ipumũ. Ga na jadjênh ne kute prĩne kàjkwa kurwỳo tuknĩja pumũ. Dja ã akubyn ibôx djà nhõ akatikam ije amijo amirĩto kàjkwa kunĩ kurwỳo ane. ");
INSERT INTO txuNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nhym bep itokry rax kumrẽxi. Me kamingrãny ja dja me prĩne ijo ajkẽ ba kam itokry rax ne. ");
INSERT INTO txuNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nhym bep akubyn ibôx 'ỳr dja me ate krãn ar ba. Ba ije amijo inhĩ dja ba akubyn ibôx 'ỳr nhym me ate ar krãn ba. Me kute amrẽbê me bakukãmã Nôwekam me ja pyràk ne ate ar krãn ba. ");
INSERT INTO txuNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nãm me õ kwỳ krẽn kôt ikõn abenwỳr babit ar o ba rã'ã nhym arỳm Nôwe kà raxmã wadjà nhym me aêrbê ngô me iby ajkapĩn me imex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ne kam ajte kute amrẽbê me bakukãmãre Rokam me ja pyràk ne ate krãn ar ba ne õ kwỳ krẽn kôt ikõn abenmã mỳjja ngãn abenmã mỳjja o pãnh ne purkam mỳjja kren amim kikren jabit ar kuman o ba. ");
INSERT INTO txuNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ar ã anhỹr ba rã'ã nhym arỳm Ro krĩbê Xôtôma kurũm tẽ. Aje. Nhym arỳm wakrekam kuwy me aêrbê mekam ajka'u ne me imex ne. Kẽn ngrãngrã pôkmẽ me'ã akàn kam me imex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Dja ba ã akubyn ibôx djào ane. Gêdja me ate ar krãn ba. Ba kam ba ije amijo inhĩja dja akubyn ibôx djà me aêrbê ã amirĩto ane. ");
INSERT INTO txuNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kam, ibôx djàjakam, gêdja me'õ kre tã nhỹ ne akubyn õ nêkrêx'ỳr àr kêt. Kwãrĩk wãnh akubyn ũrkwãkam nêkrêx'ỳr àr ne byr ne o tẽm kêt. Nhym me'õdjwỳ ar purkam ba. Ba bôx gê arĩk wãnh õ kikremã õ nêkrêx'ỳr kwỳr kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gar Ro prõja ma. Ro prõ ne õ nêkrêxo amak djàje amipãnh krã tẽn ty. ");
INSERT INTO txuNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Me kute amidjwỳnhbit mar ne pykakam mỳjja jakôtbit amak bẽnja gêdja me tyn kam ijukri tĩn kêtkumrẽx. Nhym bep me kute amidjwỳnh mar kêt ne amibê õ mỳjja kanga, me tãm gêdja me amiptàn ar tĩn ne ba, jakam ar tĩn ne ban kam tyk nhijukri tĩn rã'ã rã'ã. Tãm ne ja. ");
INSERT INTO txuNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nhym bep kati. Ẽ, ba ar amã arẽ, dja ba akamàtkam ibôx jabej nhym me'õ my ar amãnhkrut aben nhikô'ã nõ. Ba ikjêbito tẽ nhym ikjê arek wakrekam nõ. ");
INSERT INTO txuNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nhym me'õ nire ar amẽ à'uko nhỹ. Ba ikjêbit pa 'amỳn o tẽ nhym ikjêja arek wakrekam nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nhym me'õ my ar amẽ kapôtkam tẽ ba ikjê pa 'amỳ nhym ikjê arek wakrekam dja, ane. Nãm ã Jeju ane. ");
INSERT INTO txuNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nhym kôt ba djwỳnh bôx djà jabej kukij ne kum, —Bẽnjadjwỳr, nhỹnh jakam dja ga bôx? Nhym arkum, —Gar nhônhne mry tyk'ã bikprõnh ne kumex ne kute o amirĩtja pumũ, ane. Dja ã Jeju akubyn bôx kutã mỳjja apôx ne bôx djào amirĩto ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nhym kam ajte kôt ba djwỳnhmã atemã mỳjja'ã ujarẽnh jakreo tẽ. Mete Metĩndjwỳnhmã kabẽn 'ãno ãm ne kute kanga kêt'ã ne arkum arẽn arkum, ");
INSERT INTO txuNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Atemã pyka 'õkam ne memã axwe pãnh jarẽnh djwỳnh kum Metĩndjwỳnh pyma kêtkumrẽx ne mebêngôkredjwỳ mar kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nhym pyka tãmkam me'õ ni 'uwtĩre kubê mjên tyk nhym me'õ ar o bikẽnho ba, 'uwtĩkam ar o bikẽnho ba. Nhym kam akati kunĩkôt mã 'ỳr mrãn kum arẽn kum, “On ijo angryk”, ane. “On ikurê djwỳnhmã arẽ gê on imã o pãnh”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Ne mã kum 'ã apnê. Te kum 'ã apnê nhym ate krãn ar ba. Nhym mã kum arẽ nhym kam, “Ije. Ije ba gop on 'uwtĩwão ingryk ne kute kum o pãnh kadjy kurê djwỳnhmã ikabẽn 'õ jarẽ gê gop on arek wãnh nhỹ ba ityk djà kêt. Djã nã bãm imã Metĩndjwỳnh pyman imã mebêngôkre pyma got ba o ingryk? Kati, nãm mã ikujrẽ ba gop on o ingryk gê gop on anhikrên kabẽno ikatyk ngri”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jeju ne arek arkum ujarẽnho dja ne arkum, —Memã axwe pãnh jarẽnh djwỳnh ja ne axwekam me'õ 'uwtĩo ngryk ne. Amijã maje ne o ngryk ne. ");
INSERT INTO txuNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Djãm ã Metĩndjwỳnh kute anhỹr got? Kati, Metĩndjwỳnh ta ne amijo me bapytàn kam õ me jabê ate krãn ar ba kêtkumrẽx. Nãm õ me ja mar 'ãno dja. Nhym me kum amijarẽnh ry typydji. Akamàtkammẽ a'urimẽ ne me kum amijarẽnh ry typydji. Nhym arỳm me kuma. Djã nãm amikrà:n gormã õ me jao ngryk got. ");
INSERT INTO txuNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kati, ẽ, ba ar amã arẽ. Dja õ me jao ngryk kukrà kêt ne. Ba ije amijo inhĩ gêdja ba akubyn pyka jamã bôx, ije meo ingryk kadjy akubyn bôx, djã nãm me ja akubyn ibôxmã ikamnhĩx got? Kati, dja me ate krãn ar pyka jabê ba rã'ã ba akubyn bôx, ane. Nãm ã Jeju kôt ba djwỳnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ne kam ajte memã atemã mỳjja'ã ujarẽnh jakreo tẽ. Me ãm ta axwekam we katàt mrãnh ne ajkwaobit kute ar amimex jarẽnho ban kam mũm me ja'ãbit ar axwe rẽnho baja, me ja'ã ne memã mỳjja jarẽn memã, ");
INSERT INTO txuNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Me'õ ar amãnhkrut ne ar kute Metĩndjwỳnh nhõ kikretikam kum amijarẽnhmã tẽ. Nhym jabê pardjêu'õ nhym jabê bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnh, àkĩnhĩre. ");
INSERT INTO txuNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nhym kam pardjêuja tẽn wadjàn djan kam Metĩndjwỳnhmã amijarẽnhkam amijo àmrao djan kum, “Metĩndjwỳnh, ba amã amikĩnh jarẽ, ane. Ije me uràk kêtkam ne ba ikĩnhkumrẽx. Me ne me àkĩnhĩ, axwe, abenbê prõo akĩ. Nhym bep kati, ba ne ba ajmã ikute kêtê. Ije tãwã pyràk kêtê. Ije àkĩnhĩwã, kute pi'ôk kaprĩo atom djwỳnhwã pyràk kêtê, kam ne ba ikĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nhym bep ba ne ba amã ikabẽn kadjy amijajburo amãnhkrut ne, pi'ôk tyk nhõkre djàkôtmẽ pi'ôk ràràrmẽkam. Ne ajte amã apỹnh inhõ mỳjja djàri kwỳ rax ne kungã. Nã bãm apỹnh inhõ mỳjja djàri kunĩ aben kadjy kryre ne amỳn o aptàn rax ne amã kungã. Tãm ne ja”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nhym bep ate ne pi'ôk kaprĩo atom djwỳnh. Nĩjar ne dja, pijàm djàje ibôn djan kàjmã kàjkwa'ỳr krã kêt ne amititiko dja. Amijaxwekam kaprĩn pijà:m ne. Ne kam Metĩndjwỳnhmã kum, “Dja ga adjukaprĩkôt ikam adjukaprĩ, ane. Nà, mrãmri ne ba ijaxwe ga kam tu amã ikaprĩ”, ane. Nãm ã pi'ôk kaprĩo atom djwỳnh Metĩndjwỳnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Be, ba me amã arẽ. Mrãmri ne arỳm Metĩndjwỳnh tãmja jaxwekam ngryk kêt ne arỳm kum axwe kêt jarẽ. Nãm tu axweo aknon kum kabẽn mex jarẽ nhym arỳm umar mexkumrẽx ne mã ũrkwãmã tẽ. Nhym bep me'õbê pardjêuja ne kute kum axwe kêt jarẽnh kêt. Mỳkam? Bir, me kute amijo rax kadjy kute ar amimex jarẽnho baja gêdja me ĩ kàtàm ne. Nhym bep me kàtàm, me akrànmã kute amijo ban pijàm ne ar baja gêdja ĩ Metĩndjwỳnh meo rax ne. Nãm ã Jeju memã arẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nhym me Jeju'ỳr me prĩredjwỳo mõ, me prĩredjwỳ jamỳn 'ỳr meo mõ, kute me'ã ikra jadjwỳr ne kute meo kĩnhmã. Nhym kôt ba djwỳnh me omũn kam nêje me kajpan memã bẽn tỳx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nhym bep Jeju ne amiwỳr me prĩre 'uw ne kam kôt ba djwỳnhmã kum, —Kwãrĩk wãnh arek amrẽ me prĩre iwỳr mõ, ane. Kwãrĩk wãnh gar mebê adjàptàr kêt gê me arek amrẽ mõ. Ã me kute amijo anhỹrbit gêdja Metĩndjwỳnh me utàn me kadjy bẽnjadjwỳr ne ar meo ba. ");
INSERT INTO txuNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ẽ, mrãmri ne ba ar amã katàt arẽ. Me kute me prĩre pyràk ne amijo kàtàmjabit gêdja Metĩndjwỳnh me utàn me kadjy bẽnjadjwỳr ne ar meo ba. Be, me prĩre kute ta amim imarja pumũ. Ã me kute amijo anhỹr gêdja Metĩndjwỳnh me utàn me kadjy bẽnjadjwỳr ne ar meo ba, ane. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nhym kam me'õ, bẽnjadjwỳr ngri'õ Jejumã, —Bẽnjadjwỳr, ga ne ga amexkumrẽx. Mã gêdja ba amijo? Itĩn rã'ã rã'ãmã, mã gêdja ba kadjy amijon? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nhym kam kum, —Mỳkam ne ga imã imex jarẽ? Djãm mrãmri aje amim imex marmã got ga imã imex jarẽ. Me ne me mex kêt, nhym bep Metĩndjwỳnh pydji ne mex. ");
INSERT INTO txuNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Arỳm aje Metĩndjwỳnh kukràdjà marjakam ajte ikukij. Kute me mrãnh katàt'ã memã karõkôt kukràdjà ne ga arỳm ama. Aje mebê prõo adjàkĩnh kêt ne aje me par kêt ne adjàkĩnhĩ kêt ne ajêx ne aje me kàmex jarẽnh kêt. Ne ajte aje abãmmẽ anã ar kabẽn mar ne ar kabẽnkôt amijo abaja ne ga arỳm ama. Ja kunĩ ne ga arỳm ama, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nhym bẽnjadjwỳr ngrija kum, —Nà, arỳm ne ba ibôktikam ja kunĩ ma. Ne kam kôt ar amijo iba rã'ã:n arỳm ijabatành ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nhym Jeju kabẽn ja man kum, —Mỳjja pydji ne kute akukrà rã'ãã. On tẽn memã anhõ mỳjja wã ngràn pãnh pi'ôk kaprĩ byn me 'uwtĩ, me õ mỳjja kêtjamã angãn o me kĩnh ne kam amrẽ iwỳr tẽn mã ikôt ajkamẽ. Dja ga ã anen kam arỳm kàjkwakam anhõ mỳjja mex kumex, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nhym kam kuman kam kaprĩ:re. Õ nêkrêx kume:xkôt amak bẽn ne kam kaprĩre ne dja. ");
INSERT INTO txuNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nhym kam Jeju kaprĩ pumũn kam memã, —Nêkrêx ne kute me kukrà prãmã. Me õ nêkrêx kumex gêdja me te Metĩndjwỳnh nhõ pyka'ỳr bôxmã, te Metĩndjwỳnh kute meo baja'ỳr bôxmã. ");
INSERT INTO txuNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Be, ga mry jabatànhbê kameru te: kute aguja tekrax kremã ngjênhmãja pumũ. Me õ nêkrêx rũnhdjwỳ kute uràk. Nãm te Metĩndjwỳnh nhõ pyka'ỳr bôxmã, te Metĩndjwỳnh kute meo baja'ỳr bôxmã nhym nêkrêx utà: ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nhym me kabẽnja man kam kum, —Ije nhym mỳj me'õ gêdja Metĩndjwỳnh amim utà? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nhym memã, —Mebêngôkre te kute mỳjjao anhỹrja ne Metĩndjwỳnhmãbit amirĩt ne. Metĩndjwỳnh kute me õ nêkrêx kumexja kute me utàrkôt mar, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nhym kam Pedru kum, —Ẽ, arỳm ne bar inhõbikwa kunĩmã inhiren kam mã akôt ajkamẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Nhym kam arkum, —Nà. Mrãmri ne ba katàt ar amã arẽ. Godja me'õ arỳm õ mỳjjamã irer jabej, nàr õbikwamã irer jabej, õ kikre, nàr prõ, nàr kamy nàr nãmẽ bãm, nàr kramã irer jabej. Godja arỳm õ mỳjja ja 'õmã irer, ne kute memã Metĩndjwỳnh'ã ujarẽnh nhym kute me utàr ne kute meo ba kadjy kum irer jabej, ba dja ba kum o pãnh ra:x ne. Dja ba pãnh on pyka jakam kum mỳjjao akrenh mex ne kum kungã. Nhym ije pykao nykam gêdja tĩn rã'ã rã'ã ne, ane. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ne kam kôt ba djwỳnhbê 12o aben pydjin kam aro mõn arkum, —Ẽ, ota gwaj arỳm Djeruxarẽ'ỳr badjàbir ne kam babôxmã. Kam gêdja me ajmã ijo. Ba ije amijo inhĩ ne me awỳr ibôxja dja me ajmã ijo. Metĩndjwỳnh kabẽn jarẽnh djwỳnh kute ijã pi'ôk no'ôk tũmja kôt dja me ã ijo anhỹro tẽ:n kam inomã kumẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Dja gwaj bôx nhym kam me me bajtemmã ikanga nhym kam me ijã bẽno ajkẽn ijo axên ijaprỳn ikutôn ikaprêprê:k ne kam ibĩ. Nhym kam ijã akati amãnhkrut ne ikjêkêt ba kam ajte akubyn itĩn ne ikato, pi'ôk no'ôk tũmja kôt, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nãm ã Jeju kôt ba djwỳnhmã amijã karõn arkum amijarẽnho ane. Nhym ar kute kabẽn ja mar kêtkumrẽx. Kabẽn ja ne Ar kubê bipdjur nhym ar kam te kute marmã. ");
INSERT INTO txuNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nhym kam Jeju kôt ba djwỳnho mõ ne kam krĩraxbê Djeriko têpo mõ. Nhym me'õ no rãja pry jakàkam nhỹ ne à'wỳro nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nhym me itepato 'ãnh mõ nhym kam me kanga man memã, —Mỳkam ne ga me akanga mõ? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nhym kam me kum, —Jeju, ane. Nadjarekam Jeju ne me ijo mõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nhym kam kum amijo akij ne kum, —Ẽ, Jeju, Dawi tàmdjwỳ 'õ, gop amã ikaprĩ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nhym me wamã mõrja kum bẽn tỳx ne kum, —E kum anhikrê, ane. Nhym kam tu kum àkjêro bên kum, —Dawi tàmdjwỳ'õ, gop amã ikaprĩ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nhym kam Jeju tẽm tỳx katikôt djan kam amiwỳr ku'uw. Nhym kam me'õ 'ỳr tẽn kum, —Aje, onĩj arỳm amiwỳr ajuw, anen kam pa 'amỳn o tẽn 'ỳr o bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Nhym kam kum, —Nãr, mỳj nã? Mã ne ba ije ajomã? Nhym kam kum, —Bẽnjadjwỳr, aje inoo mex ba irĩtmã. ");
INSERT INTO txuNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nhym kam kum, —Nà, on rĩt. Tu aje amim ikamnhĩxkumrẽx kam ne ga arỳm amex, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nhym kam tebê rĩt. Ne kam Jejukôt tẽ, mekôt tẽ, ne Metĩndjwỳnhmã ukaprĩmẽ amikĩnh jarẽnho tẽ. Nhym kam me kunĩ omũn kôt Metĩndjwỳnhmã mex jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Nhym kam Jeju krĩbê Djeriko'ỳr meo mõn meo bôx ne kam bit kajônhkôt katormã. Nhym me Jeju'ã kumex ne prĩne angrĩn o mõ. Nhym kam me'õbê Djakij. Djakij ne bẽnjadjwỳr bajtemmã pi'ôk kaprĩo atom djwỳnh nhõ bẽnjadjwỳr. Kam ne õ nêkrêx ra:x ne. ");
INSERT INTO txuNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nhym me prĩne Jeju jangrĩn o mõ, kunoro mõ. Nhym kam te Djakij kute omũnhmã 'ã aminhinô ryo tẽ. Mỳj me'õbê Jejuja kute omũnhmã te 'ã aminhinô ryo tẽ. Djakij krô krĩkam ne te kute omũnhmã nhym me prĩne kubê utà. ");
INSERT INTO txuNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nhym kam kukãm prõt ne. Kukãm prõt ne kutêp wabi. Pidjô'ã wabi. Amrẽ tẽm nhym kute omũnhmã kutêp pidjô'ã wabi. ");
INSERT INTO txuNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nhym kam Jeju 'ỳr tẽn bôx ne parbê djan kàjmã krãn kam kum, —Djakij, amrẽ aparmã aprõt. Jakam dja ba akôt tẽn anhũrkwãkam nõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nhym kam tebê aparmã prõt ne ruw ne kam kĩ:nhkumrẽx ne ũrkwãmã Jejuo tẽn o wadjà. ");
INSERT INTO txuNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ũrkwãmã o tẽn o wadjà nhym me omũn kam kangãngãn abenmã ajkwa momoko kumex, ne, —Djijàk, me axwe'ỳr ne mõn wadjà, ane. Djãm tãwã mex, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nhym Djakij Bẽnjadjwỳr kuka kônh djan kam kum, —Bẽnjadjwỳr, ba inhõ mỳjja kônho ajkjên me bikẽnhmã kungã, ane. Ne ije me'õbê pi'ôk kaprĩo idjàkĩnh jabej akubyn me'õmã inhõ jao amãnhkrut ne o amãnhkrut ne kungã. ");
INSERT INTO txuNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nhym kam Jeju kum, —Akati jakam ne arỳm Metĩndjwỳnh apytà, anhũrkwãkam ar wãmẽ ro'ã. Mrãmri gadjwỳ ne ga abê Abraão tàmdjwỳ'õ nhym Metĩndjwỳnh arỳm apytà, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Be, ja kadjy ne ba tẽ. Ije me axwe jabej ne ije me utàrmã ne ba tẽ. Kadjy ne ba amijo inhĩ ne me awỳr ruw, ije me axwekam biknorja jabej ne ije me utàrmã, ane. Nãm ã Jeju kum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nhym me kute maro ãm rã'ã nhym ajte memã mỳjja 'õ'ã ujarẽnh jakreo tẽ. Nãm Jeju arỳm Djeruxarẽkam bôx 'ỳr nhym kam me amim, —Jakam dja Jeju Djeruxarẽkam bôx ne on me bakadjy Bẽnjadjwỳrbê kumkatin me bakurê djwỳnhbê me bapytàn ar me bajo ba, ane. Me ta ne me kute amim àtàri kêtkam tỳx amim kamnhĩx. Nhym bep Jeju ne kute katàt memã arẽnhmã. ");
INSERT INTO txuNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kadjy ne memã mỳjja 'õ'ã ujarẽnh jakreo tẽn memã, —Ẽ, bẽnjadjwỳr kra'õ ne me kute nĩjar atemã pyka 'õkam 'ã bẽnjadjwỳr mẽnhmã tẽ. 'Ã bẽnjadjwỳr mẽnh nhym ajte akubyn õ pykamã me'ỳr tẽmmã. ");
INSERT INTO txuNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ne kam tẽm kutã amiwỳr õ àpênh 'uw. Õ àpênhbê 10 ne amiwỳr ar ku'uw ne kam arkum ngônho pi'ôk kaprĩre ngã. Pãnh raxkam. Õ àpênh kunĩmã pi'ôk kaprĩ pỹnh'ã kabẽn ne arkum kungãn kam arkum, “Dja gar ikutêp imã jao aptà. Dja ba amrẽ akubyn 'ỳr tẽ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nhym bep õ pyka djwỳnhkam me ja ne me kum kĩnh kêt ne, kum kurê ne kam kôt me kwỳ jano nhym me nĩjar kôt bôx ne kam memã, “Kwãrĩk wãnh tãmja'ã bẽnjadjwỳr mẽnh kêt. Me ba ne ba me imã tãwã kĩnh kêtê. Kwãrĩk wãnh gê tãmja me ijo ba kêt”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nhym me tu ate krãn 'ã bẽnjadjwỳr mẽ. 'Ã bẽnjadjwỳr mẽ nhym akubyn õ pykamã bôx ne kam amiwỳr õ àpênh 'uw ne arkum, “Nãr, djãm arỳm ne ba ije ar amã pi'ôk kaprĩ nhõrwã gar ikutêp imã o aptà”? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nhym kam ja kumrẽx 'ỳr o bôx ne kam kum, “Bẽnjadjwỳr, ota ba anhõ pi'ôk kaprĩ pydjija ar o iban arỳm amã o aptà. Amã o aptàn abenã kumẽ nhym arỳm kubê 10”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nhym kam kum, “Mexkumrẽx. Ga ne ga adjàpênh mexkumrẽx. Nã bãm amã mỳjja ngrire ngã ga prĩne imã o djuw mex ne, ikutêp imã o djuw mex ne aje kanga kêt. Pãnh gêdja ba amã krĩ krãptĩ jarẽ, krĩbê 10 jarẽ. Ga kam abẽnjadjwỳr rax ne amũ idjô'ã ar kam meo aba”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nhym atãri ja 'ỳr o bôx ne kum, “Bẽnjadjwỳr, ota ga aje imã pi'ôk kaprĩ nhõrja ba ar o iban arỳm amã o aptà nhym kubê 5”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nhym kam kum, “Gadjwỳ ne ga amexkumrẽx. Jakam dja ba amãdjwỳ krĩ krãptĩ jarẽ, krĩbê 5 jarẽ, ga kam abẽnjadjwỳr rax ne amũ idjô'ã ar kam meo aba”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Nhym kam atãri ja 'ỳr o bôx ne kam kum, “Bẽnjadjwỳr, mĩ, anhõ pi'ôk kaprĩ. Nã bãm ije amã kupênh prãm kêtkam prĩne amã kubẽkào kupun kudji. Imã apymakam. Nã gãm apyma ne. Nã gãm aje amim mỳjja kunĩ jadjwỳr kêtkam ar mebê jãm o amijakren o atomo aba. Ne ga adjàkre kêtkam ar mebê djwỳo atomo aba”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Nhym kam kum, “Ga ne ga ajaxwekumrẽx ne imã adjàpênh prãm kêt ne. Akabẽn jakôt gêdja ba ã ajo ane. Djã nã bãm ipyma? Ne ije amim mỳjja kunĩ jadjwỳr kêtkam ar jãm mebê o amijakren o atomo iba ne idjàkre kêtkam ar mebê djwỳo atomo iba? Bir be, ga kam we ga aje amim ipumũnhkôt ren inhõ pi'ôk kaprĩ jao tẽn me kute pi'ôk kaprĩ marmã angã nhym ren abenã rôrôk tẽn rax ba ren arỳm 'ỳr bôx ne kuby”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ne kam me kute arek omũnho ku'êjamã, “Aj, amũ me ajõ kubê pi'ôk kaprĩwã byn o tẽn kute imã pi'ôk kaprĩo àptàr nhym kubê 10wãmã angã”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nhym me kam kum, “Kati, bẽnjadjwỳr, arỳm tãwã nhõ pi'ôk kaprĩre raxi. Arỳm õ 10”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nhym kam memã, “Bir be, ba me amã arẽ. Arỳm me õ mỳjja gêdja ajte Metĩndjwỳnh iby memã kungã. Nhym bep me õ mỳjja kêt, kute memã õr nhym me kute kum o djuw mex kêtjabê gêdja Metĩndjwỳnh mỳjja ngrireja kunĩ by”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","—Ẽ, ikurê djwỳnh kute ijã “Kwãrĩk wãnh gê tãmja me ijo ba kêt”, anhỹrja gêdja ga me amrẽ meo mõn ikuka kônh me imex, ane. Be, tãm ne ja. Nãm ã Jeju kàjkwamã tẽm ne akubyn pykamã bôx ne kute ar meo bamã ã amijarẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Memã arẽnh pan kam ate meo mõ, Djeruxarẽ'ỳr kàjmã meo mõn ");
INSERT INTO txuNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","kam arỳm amẽ krĩ ngrireja têpo mõ. Krãnh nhidjibê Oriwêre parbê amẽ krĩja têpo mõ. Krĩ nhidjibê Bepadjêmẽ Betanha têpo mõn kam amikukãm kôt ba djwỳnh amãnhkrut janon arkum, ");
INSERT INTO txuNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Pry ja'ã dja gar arek katàt krĩwãmã tẽ. Nhym ar akutã pry kator kraxkam me kute mry jabatành nyre pĩ maktã kum õkre djê nhym ãmwã. Me 'ã krĩ kêtwã. Tãm gêdja gar amrẽ 'ãpre bôn o tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Gêdja gar 'ãpre bônho dja nhym me'õ ar amã, “Mỳkam ne gar 'ãpre bônho dja”? ane. Gar kam kum, “Bẽnjadjwỳr 'ã tẽm kadjy”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nhym kam Jeju kute ar anorja mã ar tẽn 'ỳr bôx ne kam kum kato. Kute arkum arẽnh kôt kum kato. ");
INSERT INTO txuNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kum katon 'ãpre bônho dja nhym kam õ mry djwỳnhja arkum, —Mỳkam ne gar mry 'ãpre bônho dja? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nhym kam ar kum, —Bẽnjadjwỳr 'ã tẽm kadjy, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","36","Ne kam Jeju kutã o tẽn o bôx ne kam kum 'ã kubẽkà rẽ, 'ã ỹr kadjy. Ne kam kum ikra dja nhym ar ikrakam par djan kàjmã 'ã arĩn arỳm ate 'ã tẽ. Nhym kam me arỳm prykôt kum kubẽkà rẽnho mõ. Nãm mebê idjaer ã me bẽnjadjwỳr raxmã mỳjja rẽnh nhym 'ã tẽmmã ã kum prykôt kubẽkà rẽnho mõro ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nhym kam arỳm Jeju Djeruxarẽ têpo mõ. Krãnhrebê Oriwêre ja'ã rwỳkbê arỳm Djeruxarẽ têpo mõ. Nhym arỳm kôt ba djwỳnhjamẽ, mekôt mõr, me itepato kôt mõrja arỳm kĩnhkumrẽx, kĩnh ra:x ne arỳm àkjêr mõ. Jeju ne mỳjja pumũnh kêt kwỳ rax ne ipêx ne, nhym me kute ipêxkôt omũn kam kĩnhkumrẽx ne Metĩndjwỳnhmã mex jarẽnho mõ, àkjêr mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ne kam abenmã, —Gê Metĩndjwỳnh bẽnjadjwỳr jao kĩnh rax. Bẽnjadjwỳr djwỳnh kukwakam ne arỳm me bakadjy bôx. Gora gê me kàjkwakamdjwỳ umar mex ne kĩnh rax. Gora gê me kàjkwakamdjwỳ Metĩndjwỳnhmã mextire jarẽnho kumex, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nãm me ã anhỹro kumex nhym kam mebê pardjêumẽ me krãptĩ akàn Jejukôt mõ. Nhym kam mebê pardjêu Jejumã, —Bẽnjadjwỳr gop akôt ba djwỳnhmã akabẽn gê anhikrê, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nhym kam memã, —Ba me amã arẽ. Nãm ren me anhikrê nhym ren kẽnja ijo àkjêro nhỹ, ikam kĩnh ne ren ijo àkjêro nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Anen kam arỳm Djeruxarẽ'ỳr mõ. 'Ỳr mõn arỳm irã. Irãn omũn kam ate me abej muw. Me kute amibê Jeju kangan amibê kurên kute bĩn nhym Metĩndjwỳnh kute pãnh prĩne meo bikẽnhmã ne kôt amak bẽn ne me abej muw, ne, ");
INSERT INTO txuNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—Ga ren me ga aje amidjumar mex djà mar ren akati ja tãmkam ren adjumar mex ne ar aba. Nhym bep kati, mỳjwã ne adjumar djà'ã, mỳjwã ne me ajãn kam me abê o akno. ");
INSERT INTO txuNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Adjỹm, dja ĩ me ajo bikẽnh djà nhõ akati me awỳr bôx. Dja ĩ me akurê djwỳnh me awỳr bôx ne me amã ipôk ne prĩne pykao me abê ka'ên prĩne me abê ijên me amã ipôk me:x ne me ajo dja. ");
INSERT INTO txuNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Dja me aminhikra kraxkam me akrã jadjuw ne prĩne me anhimex ne kam me anhõ kikre prĩne kungràn ikô rênho mõ, ne me abêngôkredjwỳo pyka tako mõ, akramẽ. Dja me prĩne me ajo mõr djà kaprã. Nhỹnh gêdja par'õ dja? Nhỹnh dja mỳjja'õ nõ? Mỳkam? Bir, me aje amim Metĩndjwỳnh mar prãm kêtkam. Nãm arỳm Metĩndjwỳnh me awỳr bôx kute me amã me adjumar mex jarẽnh ga me adjumar mex ne ar abamãn amã Metĩndjwỳnh mar prãm kêt ne, ane. Nãm ã Jeju ane, anhỹr djwỳnhràm Djeruxarẽ kurê djwỳnh kute o bikẽnhmã ã memã arẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ne kam Djeruxarẽkam bôx. Kam bôx ne kam Metĩndjwỳnh nhõ kikretimã tẽn wadjà, Bãm nhũrkwãmã tẽn wadjà. Nhym arỳm me kam pi'ôk kaprĩ pãnh memã mry nhõro ku'ê. Nhym kam arỳm bõm nêje me rẽnho tẽ, Bãm nhõ kikre nêje bõm me rẽnho tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ne memã, —Metĩndjwỳnh ne õ pi'ôk no'ôkkam memã, “Me kute imã kabẽn kadjybit ne inhõ kikretiwã. Nhym bep me ga ne ga me kam aje me àkĩnhĩo aben pydji djà”, ane. Nãm ã Jeju memã anen bõm me kurẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ne kam kam akati kunĩkôt memã Metĩndjwỳnh kukràdjà'ã ujarẽnho ku'ê. Nhym kam me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ ar kute meo ba djwỳnhmẽ te kute bĩn prãme. ");
INSERT INTO txuNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Te kute ajmã on kute bĩnmã nhym me kunĩ kum kabẽn kĩ:nhkumrẽx ne maro kumex. Kabẽn 'ãno djan kam no tyn maro nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nhym kam akati 'õkam Jeju Metĩndjwỳnh nhõ kikretikam memã 'ã ujarẽnho dja. Ne kam Metĩndjwỳnh'ã ujarẽnh ny memã arẽnho dja. Nhym kam me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ mebêngêttemẽ ne me ro'ã Jeju'ỳr bôx ne kam kum, ");
INSERT INTO txuNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—Goja on me imã arẽ. Mỳj me'õ kabẽnkôt ne ga ar ã meo anhỹro aba? Mỳj me'õ ne amã me'ã karõ ga kam amũ ô'ã bõm ar me rẽnho aba? Goja on me imã arẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nhym kam amipãnh memã, —Badjwỳ dja ba mỳjja jabej me akukij. Me akumrẽx dja ga me imã arẽ ba kam arỳm badjwỳ me amã arẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Djuão kute ngônhmã me angjênhja, djãm mebêngôkre kabẽnkôt ne arĩk ar ngônhmã me angjênho ba? Nàr djãm Metĩndjwỳnh kabẽnkôt? Gop me imã arẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nhym kam me abenkam kangan abenmã, —Ije mã dja gwaj kum nẽ? Dja gwaj kum, “Metĩndjwỳnh kabẽnkôt”, ane nhym kam gwaj bamã kabẽn'õ jarẽ, gwaj bamã, —Bir be, mỳkam ne ga me Djuão kabẽnja mar kêt ne? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nàr dja gwaj kum, —Me kabẽnkôt ne tu arĩk ar ngônhmã me angjênho ba, ane nhym me kunĩ arỳm kẽno gwaj batitik ne gwaj bapa. Me kàtàm ja ne me arỳm Djuão kabẽn man kum kĩnh ne, ne o Metĩndjwỳnh kabẽn jarẽnh djwỳnh ne. Dja gwaj ane nhym me o ngryk ne gwaj bapa, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nãm me ã abenmã anen kam Jejumã kum, —Kon ne. Ar ije mar kêt. Mỳj me'õ kabẽnkôt Djuão kute ngônhmã me angjênhja ar ije kôt mar kêtê, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nhym kam memã, —Bir be, dja ba badjwỳ me amã arẽnh kêt ne. Mỳj me'õ kabẽnkôt ije ar meo ibaja dja ba me amã arẽnh kêt ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Anen kam memã atemã mỳjja'ã ujarẽnh jakreo tẽn memã, —Me'õ ne pur rax djin kam kam amim pidjô kumex ne. Ne kam me kwỳmã kum, “Gora me imã o djuw mex. Gora gê djan abatành ne ô ga amim kwỳo atom ne imã mũm kwỳo atom”, ane. Nãm ã memã anen kam atemã pyka 'õmã tẽ. Ne kam kam wãnh ar ba. Ar ban kam kà'ã ngrà: ne. ");
INSERT INTO txuNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nhym arỳm pidjôja tuk ne kumex. Nhym kam õ pidjô djwỳnhja arỳm 'ã mytyrwỳ jakren kam 'ỳr õ àpênh jano. Kute memã arẽnh nhym me kute kum pidjô kwỳo atom ne kute kôt anor kadjy ne 'ỳr ano. Nhym kam 'ỳr tẽn bôx nhym kam me kute pidjôo djuw mexja ate kaprêprê:k ne. Nhym mã akubyn 'ỳr ỹkam tẽn bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nhym ajte õ pidjô djwỳnhja pãnh 'ỳr me'õjadjwỳ jano nhym 'ỳr tẽn bôx nhym me ajte tãm ne, kaprêprêk ne prĩne o ajkẽn kum pijàm jadjàr mex ne ano nhym akubyn 'ỳr ỹkam tẽn bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nhym ajte õ pidjô djwỳnh 'ỳr ajte õ àpênh 'õ jano nhym 'ỳr tẽn bôx. Adjwỳnhdjwỳ ne me prĩne o ajkẽn bĩn punun bõm kumẽ nhym 'ỳr tẽn bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nhym kam õ pidjô djwỳnhja amim, “Ije, mã gêdja ba nẽ? Mỳj gêdja ba on? Jakam dja ba 'ỳr ikra jano, ikra djwỳnh imã abêja dja ba 'ỳr ano gê gop me mar jabej.” Nãm ã amim anen kam me'ỳr kra djwỳnhja jano nhym me'ỳr tẽn bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nhym kam me kute puro djuw mex djwỳnhja kra pumũn kam abenmã 'ã karõ ne abenmã, “Be, kra ne wã. Ajrã, gu me on kubĩ. Tãwã dja bãm kum mỳjja kunĩ ngã, õ nêkrêx kunĩ kanga ane. Gu me on tãwã bĩn kam amim õ nêkrêx, õ mỳjja, õ pidjôja kunĩo aminhõ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ne kam pidjôkô kurũm bõm kumẽn kubĩ. Bir be, mã gêdja õ pidjô djwỳnhja kute me ja omã? ");
INSERT INTO txuNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Bir be, dja õ pidjô djwỳnhja me'ỳr tẽn bôx ne me imex ne kam õ pidjôkôja atemã me ja'õmã kungã, ane. Nhym me kute maro ku'êja kuman kam kum, —Kati, gora gê ã o anhỹr kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nhym kam Jeju arek mekam no tyn djan kam memã, —Mrãmri, ane. Mỳj'ã ne Metĩndjwỳnh pi'ôk no'ôkkam memã ja jakre? “E kum kẽn ja ne me kute kikreo ãm djwỳnhja kute kikremã armã te omũn kam bõm kumẽ. Kẽn ja ne kute kikremã o kajpar, kum o kajpar tỳxi”, ane. Mỳj'ã ne Metĩndjwỳnh kabẽn ja, nẽn? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ẽ, kẽn ja gêdja ga me ajõ 'ã tỹm ne prĩne 'ã amikrakrak ne. Nhym bep ta gêdja me ajõ nhiby tỹm ne prĩne angãn prĩne pyka mẽ ajo amrà, ane. Nãm ã Jeju kute prĩne kurê djwỳnh nhimexmã ã amijã kẽn jakreo ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nhym kam Môjdjê kukràdjà mar djwỳnhmẽ me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr te kute memã 'ã ujarẽnho ãmri kute o tỹm nhym me kute bĩnmã te 'ã amijakre. Jeju kute puro djuw mex djwỳnh'ã me akrekam. Nhym me kuman kam kam ngryk ne. Ne te kute o tỹm nhym me kute bĩnmã, ne kum me uma ne, kum me krãptĩtija pyma ne. ");
INSERT INTO txuNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nãm te me kute Jeju bĩnmã o anen kam amim amã, kute kabẽn 'õ kupa'ã arẽnh nhym me kute on o tỹm ne bĩnmã ne me amim amã. Kam ne me Jeju'ỳr ar kwỳ jano. Ar kute amijo kabẽn mex ne kute amijo Jeju kabẽn mar prãm ne kute mỳjja jabej kukjêr kadjy ne me Jeju'ỳr ar ano. Ar kute pa 'amỳnh ne kute o tẽm ne me bajtem nhõ bẽnjadjwỳrjamã arẽnh nhym kute bĩnmã ne ar ã o ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ar ja, ar 'êx ne kute amijo Jeju kabẽn mar prãmja ne ar kum, —Bẽnjadjwỳr, nã gãm katàt me imã mỳjja jarẽnh mexkumrẽx ne, ne katàt adjujarẽnho dja. Djã nã gãm te me mũja pymaje ne me mũjamã akabẽn mex jarẽ? Kati, nã gãm katàt me imã arẽnho aben pyràk ne, me imã Metĩndjwỳnh kukràdjà'ã adjujarẽnh mexkumrẽxo dja. Bar arỳm kuma. ");
INSERT INTO txuNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ẽ, djãm Metĩndjwỳnh kukràdjàkôt ne gu me baje bẽnjadjwỳr Xedjamã pi'ôk kaprĩ nhõrmã? Nàr kon. Goja on ar imã arẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bẽnjadjwỳrbê Xedja ne me kunĩmã nhỹ ne mebê idjaero aminhõ ne pi'ôk kaprĩ'ã ar me 'wỳro ba. Me kute kum õr nhym kute we me utàrmã. Ja jabej ne we ar amijo kabẽn mex ne Jeju kukij. Kute “Kati, kwãrĩk wãnh kubajtemmã pi'ôk kaprĩ nhõr kêt,” anhỹr nhym Xedja nhõ krãkamngônhre kute o tỹmmã, nàr kon kute, “Nà, kum angã,” anhỹr nhym me ja kute o tỹmmã, ne ar kukij ne kum, —Djãm mrãmri ne gu me baje bẽnjadjwỳr Xedjamã pi'ôk kaprĩ nhõrmã, nàr kon? ane. Nhym bep kati, Jeju ne tu ar omũ, ar kadjwỳnhbê tu ar omũn kam arkum, ");
INSERT INTO txuNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Goja amrẽ ngônhponho pi'ôk kaprĩwão tẽ ba omũ, ane. Nhym kam ar kum o tẽn kungã. Nhym kam arkum kubẽ ne arkum, —Mỳj me'õ ne 'ã karõja? Ne mỳj me'õ ne 'ã idji jêtja? Nhym ar kum, —E kum bep Xedja karõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nhym kam arkum, —Bir be, õ pi'ôk kaprĩ. Dja gar kum angã nhym bep Metĩndjwỳnh nhõ mỳjjabit dja gar Metĩndjwỳnhmã angã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nãm prĩne arkum arẽnh mexkumrẽx nhym kam ar abenmã, —Ije tô mã ne gwaj baje omã? Djãm nopnu: got kute mỳjja'õ kupa'ã arẽnh gwaj baje ajmã omã, ane. Nãm ar te me ipôkri Jejumã nõ, kute kabẽn'õ jarẽnh nhym ar kute o tỹmmã te me ipôkri kum nõ nhym mrãmri kabẽn kôt arẽ. Nhym kam ar tu anhikrê, pijàm djàje anhikrê. ");
INSERT INTO txuNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nhym pãnh me ja 'ỳr bôx. Mekbê xadjudjêu ne me kwỳ 'ỳr bôx. Nãm we me, —Kati, me tyk ne akubyn tĩn kêt, ane. Nãm tu me tykkumrẽx ne, ane. Me ja kwỳ ne me 'ỳr bôx ne kute mỳjja jabej kukjêrmã 'êx ne kum, ");
INSERT INTO txuNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Bẽnjadjwỳr, we Môjdjê ne me bamã me badjupãnh'ã karõ ne 'ã pi'ôk no'ôk ne. Me'õ prõ'ỳr mõr ne kra kêt ne tyk nhym atãri kamy'õ pãnh 'ỳr mõr ne kute kum kra djirmã arẽ, ane. Kamy kumrẽx 'ỳr mõrja tyk nhym kam kamy pãnh 'ỳr mõrja kute kum kra djir nhym kam kra kutewaja we kute bãm kamy kumrẽx tykja nhõ mỳjjao aminhõmã. Nhym bep atãri ja ne kute we bãm tĩn nhõ mỳjja jao aminhõmã. Nãm ã we Môjdjê 'ã me bamã karõo ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Be, kamybê 7 ne axikôt apôx. Nhym kutewaja prõ'ỳr mõ. Prõ'ỳr mõn kra kêt ne ty. ");
INSERT INTO txuNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nhym atãrija pãnh 'ỳr mõn kam ajte ty. ");
INSERT INTO txuNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nhym pãnh atãrija 'ỳr mõn kam kra kêt rã'ã ajte ty. Be, nãm ar ã o anhỹro tẽm tãmtã: nhym arỳm kutapureja aro ino ren 'ỳr mõn adjwỳnhdjwỳ ty, kra kêt ne ty. ");
INSERT INTO txuNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nhym arỳm ar prõja arkôt ty, kra kêt rã'ã ty. ");
INSERT INTO txuNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Be, nija, mã gêdja me akubyn tĩnkam ar on? Nhym ne kute o kubajtem ne kute o prõ kêt dja 'ỳr mõ? Ar kunĩ ne ar axikôt 'ỳr ban ty, ane. Nãm ã mebê xadjudjêu Jejumã anhỹro dja. ");
INSERT INTO txuNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nhym kam memã, —Ẽ, pyka jabê me ar bari ne me prõ'ỳr ba nhym me nire mjên. ");
INSERT INTO txuNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nhym bep me akubyn tĩnkam gêdja me abenwỳr ba kêtkumrẽx ne. Metĩndjwỳnh kute me'ã mex nhôr nhym me tyk nhijukri akubyn tĩn me tãm gêdja me abenwỳr ba kêtkumrẽx ne. Me my prõ'ỳr ba kêt nhym me nire mjên kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nãm me akubyn tyk prãm kêtkumrẽx ne abenwỳr ba kêt ne. Kam ne me kute kadjy mrãnh djwỳnh pyràk. Ne arỳm akubyn tĩnkam dja me kubê Metĩndjwỳnh krakumrẽx ne tu tĩn ne ajte tyk kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Môjdjêdjwỳ ne me tyk ne akubyn tĩnja memã o amirĩt ne. Ga me akaôk pôk ne tu mex ne ãm'ã ujarẽnhkam kute, “Ibê Abraãomẽ Idjakmẽ Djako ar õ Metĩndjwỳnh”, anhỹrja pumũ. Bẽnjadjwỳr'ã, Metĩndjwỳnh'ã ne ã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bir be, ar tyk tũmja Metĩndjwỳnhmã tĩn ne ar ba nĩj pumũ. Djãm Metĩndjwỳnhbê me tyk nhõ Metĩndjwỳnh? Kati, Metĩndjwỳnh ne me tĩn nhõ Metĩndjwỳnh. Me tyk kunĩ ne me kum tĩn. Me tykkumrẽx kêt. Metĩndjwỳnh ne akubyn meo tĩn. Kam ne ba me amã, “Metĩndjwỳnh ne kubê me tĩn nhõ Metĩndjwỳnh”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nhym kam Môjdjê kukràdjà mar djwỳnh kwỳ ne kum, —Be, bẽnjadjwỳr, nã gãm me wãmã arẽnh mexkumrẽx ne, ane. Môjdjê kukràdjà mar djwỳnh ne me kum mebê xadjudjêu kĩnh kêt nhym Jeju kabẽno me jao apa nhym me arỳm anhikrê. Nhym kam Môjdjê kukràdjà mar djwỳnh arỳm kôt omũn kĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nhym kam me kunĩ arỳm kum Jeju pyman mỳjja'õ jabej kukjêr kêt ne arỳm tu anhikrê. ");
INSERT INTO txuNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","42","Nhym kam Jeju amipãnh me kukij. Kute memã amijã ujarẽnh nhym me kute mar ne kute kôt kum kator kadjy. Amrẽbê ne Metĩndjwỳnh memã Bẽnjadjwỳrbê kumkati jarẽ, kute memã anormã. Ne kam memã Bẽnjadjwỳrbê kumkati jarẽn arẽn arẽn arỳm memã ano. Metĩndjwỳnh ta ne memã Jeju jano, nhym kute memã amijarẽnho ãm nhym me kute kum katormã, me kute kubê Bẽnjadjwỳrbê kumkati kôt kum kator kadjy ne memã, —Nãm we me Bẽnjadjwỳrbê kumkati dja kubê Dawi tàmdjwỳ'õ, ane. Metĩndjwỳnh kute me bamã anorja dja kubê Dawi tàmdjwỳ. Mỳkam ne me kum Dawi tàmdjwỳ ane? Be, djãm Kritubê ne Dawi tàmdjwỳbit? Kati, kubê ne Dawi nhõ Bẽnjadjwỳrdjwỳ, ane. Dawi ta ne o õ Bẽnjadjwỳr ne me ngrer'ã pi'ôk no'ôkkam ajte ta, Dawi ta ne, “Inhõ Bẽnjadjwỳrmã ne Bẽnjadjwỳr djwỳnh kabẽn ne kum, ‘Amrẽ idjubôk'ãnh nhỹ, Abẽnjadjwỳr raxkam idjubôk'ãnh nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ikutêp nhỹ ba 'ỳr amrẽ awỳr akurê djwỳnho mõ ga kwỳo apardjan kwỳ nhimex’, ane. Nãm ã Metĩndjwỳnh inhõ Bẽnjadjwỳrmã arẽnho ane”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Bir be, ga Dawi kute kum “Abẽnjadjwỳr rax” anhỹrja pumũ. Mỳkam ne me Dawi tàmdjwỳ kajgo jarẽ? Djã nãm o tàmdjwỳ kajgo? Kati, Dawi ta ne kute o õ Bẽnjadjwỳr rax, ane. Nãm ã Jeju memã amijarẽnho anen o me unê nhym me kute ajte kukjêr kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nhym me itepato Jeju kabẽn maro kumex. Nhym kam Jeju me ipôkri kôt ba djwỳnhmã, ");
INSERT INTO txuNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Gora ar aminêje me omũ, ane. Aminêje Môjdjê kukràdjà mar djwỳnhwã pumũ, ane. Me wã ne me kute amibẽn kadjy kute kubẽkà jabjêti jangjênh ne 'ã ba prãmkumrẽx. Nhym me ajte me krãptĩ nhipôkri kute me mexo àmran kute memã rũnh jarẽnh ne kute memã, “Bẽnjadjwỳr, djãm ga, djãm ga”, anhỹr jabit ne me kum kĩnh. Ne mebê idjaer bikprõnh djàkam kute abeno krĩ djàkam kute amijo rũnh ne kute mebê me rũnh krĩ djà pytàr prãmkumrẽx. Ne kam ajte me krãptĩ kute abeno bikprõnh ne àkuro krĩ katã kute mebê me rũnh krĩ djà pytàr prãmkumrẽx, ne kute mỳjja rũnh, mỳjja mexbit kur prãmkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nãm ã me amijo rũnho bao anen kam ate ajte me 'uwtĩ krão apan mebê mỳjja kunĩo akĩ ne kam ajte ajkwaobit Metĩndjwỳnhmã kabẽn rũnh ne, ne kum kabẽn jabjêo ku'ê. Nãm me 'êx ne amijo mex ne kum kabẽn ne. Bep kati, me axwekumrẽx. Kam gêdja Metĩndjwỳnh me kuràm memã pãnh rax jarẽn prĩne me kuràm meo ajkẽ. Kam ne ba ar amã, “Gora ar aminêje me wã pumũ”, ane. Nãm ã Jeju kôt ba djwỳnhmã me kute amijo mex, amijo rũnh ne kute amijaxweo bipdjurja'ã ã arkum karõo ane. ");
INSERT INTO txuNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Metĩndjwỳnh nhõ kikretikam ỹr rã'ãkam ne ã arkum anhỹro nhỹ, arkum 'ã ujarẽnho nhỹn 'ã ujarẽnh pan kam ibôn nhỹn kàjmã krãn arỳm ari ar me omũ. Nhym me õ nêkrêx krãptĩ, õ pi'ôk kaprĩ krãptĩja Metĩndjwỳnhmã me kute pi'ôk kaprĩ nhõr djàkam kum pi'ôk kaprĩ rẽnho kumex, aben nhitepã kum kam rẽnho kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nhym kam me'õ nija, me'õ ni 'uwtĩ kubê mjên tyk nhym õ mỳjja kêtja ngônhponhreo pi'ôk kaprĩ byn o tẽn kam kum kumẽ. Amãnhkrutkam pãnh ngrire ne amẽ kubyn o tẽn kam kumẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nhym Jeju arek omũnho nhỹn kam arkum, —Ba ar amã arẽ, me'õ 'uwtĩ ja ne õ mỳjja kêt, ne tu me kuràm õ pi'ôk kaprĩ raxo tẽn Metĩndjwỳnhmã kungã. Me kunĩ kuràm pi'ôk kaprĩ raxo tẽn kum kungã. ");
INSERT INTO txuNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Me ja ne me õ pi'ôk kaprĩ kumex ne kam 'ã kàtàm ne kumex. Ne kam 'ã kàtàmja Metĩndjwỳnhmã kungã. Nhym bep me'õ nija ne õ pi'ôk kaprĩ kêtê, pi'ôk kaprĩ ngrire ne tu kum kunĩ ngã. O kute amikadjy mỳjja byr ne krẽn ne tĩn kadjy Metĩndjwỳnhmã kunĩ ngã. Kum 'õ nõr kêtê. Kam ne ba ar amã, “Nãm me kuràm pi'ôk kaprĩ rax ne kum kungã. Mrãmri ne ba ar amã arẽ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nhym ar kwỳ abenmã Metĩndjwỳnh nhõ kikretija jarẽnho mõ. Ne abenmã, —Kẽn ja ne mexkumrẽx. Nhym me o kikre nhym kĩnhkumrẽx. Ja ne kikre jao kĩnh ne. Ẽ, nhym me kwỳ kute Metĩndjwỳnh nhõ kikretio kĩnh kadjy kute apỹnh mỳjja aben kadjy õrkam kute o kikre ja kĩnhkumrẽxja pumũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Nhym kam arkum, —Bir be, ar omũ. Ar aje omũnhwã gêdja õ akati, o bikẽnh djà nhõ akati 'ỳr bôx nhym me kurê djwỳnh prĩne kikreti ngrà. Dja me kẽn aben nhiby ikwã kunĩ nhikô rê. Nhym kam kẽn'õ aben nhiby nõr kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nhym ar kum, —Bẽnjadjwỳr, nhỹnh amex 'õkam dja me kurê djwỳnh o ane? Mỳj gêdja kukãm apôx bar omũn kam kôt õ akatimã ikaton õ akati ma? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nhym kam arkum, —Ar amijã ano tỳx, gê me'õ ar amã 'êx ne ar anoo biknor ne Metĩndjwỳnhbê ar ajo akẽx kêt. Be, me krãptĩ dja ĩ aben totokmã me'ỳr bôx ne arỳm amijo 'êx. Amijo 'êx ne arỳm amijã imẽ. Amijã imẽn arỳm memã, “Me anhõ Bẽnjadjwỳrbê kumkati kadjy ne Metĩndjwỳnh ijano ba tẽn bôx. Ba ibê Kritu”, ane. Ne kam ajte, —Ota arỳm akubyn bôx djà nhõ akati kato, ane. Kwãrĩk wãnh gar me wã kabẽn mar ne mã mekôt abikamẽnh ne ar mekôt aba kêt. Dja gar tu ate akrã. ");
INSERT INTO txuNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Gêdja me abeno kurê djwỳnh ne abenwỳr prõt ne aben nhimexo ba gar omũn kôt ama. Nhym ajte me kwỳ ta õ pykakam õ bẽnjadjwỳro kurê djwỳnh ne ta ajte jãm abeno kukan aben paro ba. Dja gar mỳjja ja man atĩn prãm kêt ne amã uma kêt. Ja kumrẽx gêdja me ã o anhỹro tẽ. Kraxje kute inomã mẽnh kêt, kute 'ỳr o tẽm rã'ã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nãm ã Jeju arkum 'ã karõo anen kam ajte arkum, —Nà, apỹnh me ba djàri gêdja me abenwỳr prõt ne aben nhimexo ba. Nhym apỹnh pyka abenã rôrôk djàri dja me abeno kurê djwỳnh ne aben nhimexo ba. ");
INSERT INTO txuNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Apỹnh pyka djàri gêdja kam pyka terte:t ne, tertet rax ne. Nhym prãmdjwỳ me kwỳ nhimex. Nhym apỹnh me kanê djàri me kwỳ nhimex ne. Nhym mỳjja rũnh, mỳjja pymadjwỳ kàjkwa kurũm apô:x ne kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nhym bep mỳjja ja apôx kêtri gêdja me ar ajo rôrôk ne prĩne ar ajo ajkẽ. Ne me bikprõnh djà'ỳr ar apa 'amỳn ar ajo mõn me bẽnjadjwỳrmã ar ajo 'êx ne ar ajaxweo ar apytàn mebê ijê djàkam ar arẽ. Ar amã ijabê ne amã ikĩnhkôt gêdja me me bẽnjadjwỳr'ỳr ar apa 'amỳn ar ajo mrã. Me bẽnjadjwỳr krymẽ me bẽnjadjwỳr rũnh'ỳr ar ajo mrã. ");
INSERT INTO txuNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kam, kamã gêdja gar memã ikukràdjà ny'ã ajarẽ gê me kuma. ");
INSERT INTO txuNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kam gêdja gar adjumar punu kêt ne amim, “Mỳj ikabẽn gêdja me amiwỳr ijo tẽ ba arẽ”? anhỹr kêt. Ne, “Mã dja ba gêt memã amijã idjàprãrmã ikabẽn ja on”? anhỹr kêt. Kwãrĩk wãnh gar ã amim anhỹr kêt, anhỹr djwỳnhràm ã amim anhỹr kêt. ");
INSERT INTO txuNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bep kati, ba gêdja ba ar ajamakmã ikabẽn wadjà. Ba gêdja ba ar amã ikabẽn jarẽ gar kam ikabẽn ja tãm memã arẽ nhym kam ar akurê djwỳnh te ar amã ãm tỳx ne kute kabẽn'õ mar ne kute bẽno ar ajapanhmãn tu anhikrê. ");
INSERT INTO txuNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","E kum ã, ar abãmmẽ, ar anã, ar akamy, ar anhõbikwaja tãm gêdja me ar akurê djwỳnh'ỳr ar apa 'amỳn ar ajo mrã nhym me ar akwỳ pa. ");
INSERT INTO txuNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ikôt ar abikamẽnhkam dja me kunĩ kum ar akurê ne. ");
INSERT INTO txuNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nhym bep Metĩndjwỳnh ta gêdja prĩne ar ajo djuw mex ne ar apumũnh 'ãno dja. Djãm kum ar apumũnh kangamã got? Kati, gêdjãm prĩne ar apumũnh 'ãno dja. ");
INSERT INTO txuNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Gora ar memã adjãm tỳx. Dja gar adjãm tỳx ne 'ãno djan arỳm tu atĩnkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Gêdja krãkamngônh Djeruxarẽmã ipôk mõ ne 'ã aben krãkà proo mõ gar kam omũn arỳm kôt ama. Mrãmri ne arỳm õ akati têpo tẽ, Djeruxarẽo bikẽnh djà nhõ akati têpo tẽ, me kute me amõr djà ngrành ne kute prĩne kapõnhmã ne arỳm têpo mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kam gêdja Djeruxarẽ bu'ã pyka ja nhidjibê Djudêjakam me ja amijã maje krãnh'ỳr prõt ne. Nhym bep krĩbê me ja gêdja me amikrà kêt mex ne amijã maje kurũm kato. Nhym purkam me jamẽ, bàkam me jamẽ gêdja me ajte akubyn ũrkwãmã mõr kêt. Dja me tu ãm kamã ajmà, apỹnh krãnh'ỳr ba. Akubyn krĩmã mõr ne bôx ne ajte akubyn prõt kêt. Tu ãm kamã amũ prõt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Be, akati kaprĩ ne ja. Akati kĩnh kê:tkumrẽx ne ja. Mrãmri gêdja Metĩndjwỳnh me axwekam ngryk ne me axwe pãnh prĩ:ne meo ajkẽ. Anhỹr djwỳnhràm ne Metĩndjwỳnh pi'ôk no'ôkkam ja kunĩ'ã ajarẽ. Dja õ akati 'ỳr bôx, anhỹr djwỳnhràm Metĩndjwỳnh kute pi'ôk no'ôkkam arẽnh jakôt dja 'ỳr bôx ne kam kôt ã o anhỹro tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","24","Be, akati ja dja kaprĩ ra:x ne. Watĩre me nire tujarô, watĩre me nire kute kra karàre jamỳnhja. Mã gêdja me ja krãkamngônh pymaje prõtja on? Metĩndjwỳnh gêdja pyka jakam me jakam ngry:k ne. Ne prĩne kam meo ajkẽ, me axwekam. Metĩndjwỳnh ta gêdja pyka ja'ỳr me kurê djwỳnh jano nhym me me'ỳr bôx ne Djeruxarẽmã ipôk ne kam prĩne me imexo mõ. Kàxdjwa kajgoo me kwỳ nhimex ne kam amipardja'ã me kwỳ pa 'amỳn kam apỹnh me bajtem nhõ pykakôt me kungrà. Krãkamngônhre bajtem ja gêdja prĩne Djeruxarẽo ajkẽ, prĩne o ajkẽn kungràn jãm o mrãn kurẽn kam arỳm mỳrbê kam ajkarê. Kam bikarêr rã'ã: nhym arỳm me kute meo bikẽnh djà nhõ akati apêx. Arỳm me bajtem nhõ akatija apêx nhym arỳm me mã mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nhym kàjkwakam mỳjja pumũnh kêt kwỳ rax dja apôx. Mytmẽ mytyrwỳmẽ kanhêtirekam gêdja mỳjja apôx ne kumex. Nhym pykabêdjwỳ ngô rax dja tàm ne aben pumjuw ne mũja bê abenã ajkapĩ ne kam rãrã:ko nõ. Dja me apỹnh õ pyka djàri omũn kam abenmã, —Mỳj got ja? Mỳkam? anen kam umar punure. Te kute mỳjja'õ marmãn mỳjja'õ mar kêtkumrẽx ne kam axwe umarre. ");
INSERT INTO txuNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ne kam terteto kumex. Mỳjja pyma kator ne kute prĩne pykao bikamỳr ne kute prĩne meo bikẽnh pymaje ne me terteto kumex. Nãm me amijã ja kamnhĩx ne kam tĩn prã:m ne. Te tĩn prãme ne kam terte:to kumex. Djãm mỳjja pyma ngri: ne apôxmã got me umaje tertet kêt ne. Kàjkwakam apỹnh mỳjja tỳ:x dja amingrẽk ne. ");
INSERT INTO txuNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kam gêdja ba me'ỳr bôx nhym kam me kunĩ ipumũ. Ije amijo inhĩ dja ba imextire ne itỳxkumrẽx ne ipyma:kumrẽx ne. Kam dja ba kàjkwakam kakrã kôt bôx nhym me kunĩ: arỳm ibôxkôt ipumũ. ");
INSERT INTO txuNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kukãm ne mỳjja apôxja. Bir be, gêdja mỳjja ja arỳm apôxmo krax ga kam ar amikam atỳx. Amikam atỳx ne akĩnh ne. Arỳm ije ar apytàrmã me awỳr ibôx 'ỳr, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ne kam ajte arkum atemã mỳjja 'õ'ã ujarẽnh jakreo tẽn arkum, —Gop ar pidjôbê pigêremẽ ràmtàxtemẽ pĩ kunĩ ma. ");
INSERT INTO txuNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Amex kutã gêdja 'ô ingrã gar kam arỳm amexmã kamnhĩx nhym kam arỳm amex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bir be, gêdja ba ije ar amã mỳjja jarẽnhja ã apôx mõr ane gar kam arỳm ijabej rĩt ne ijabej ajkam ama. Akubyn ibôx ne me kadjy ibẽnjadjwỳr rax ne ipymao ije me utàr ne ar meo ibamã arỳm 'ỳr. 'Ỳr dja mỳjja apôx tẽ. Amex kutã gêdja pi'ô ingrã, nhym bep ibôx kutã gêdja mỳjja pymatija apôx mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nà, mrãmri ne ba ar amã kôt arẽ. Ar anhõ krôkam me kamingrãny ja gêdja me tyk par kêtri mỳjja ja kunĩ apôx. Mrãmri ne ba ar amã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ikabẽn kajgo kêtkumrẽx. Gêdja pykamẽ kàjkwa ĩ apêx nhym bep ba ikabẽn gêdja 'õ biknor kêtkumrẽx. Mrãmri gêdja ba ije mỳjja jarẽnh ja kunĩ apôx nhym me omũ. ");
INSERT INTO txuNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Gora ar ikam amakbê amijã ano tỳx ne amijãno dja. Gar mrãmri akukràdjà mexbito atẽm rã'ã. Kwãrĩk wãnh gar kadjwati kangôkôtbit ar aban o akõm nhym kute bõm ar ano rẽnh ne prĩne kute ar ano kamrêkwã wãm nõ. Ne kôt arĩk ar abawã gêdja wãm nõ. Kwãrĩk wãnh gar pyka jabêbit adjumar punukôtbit ajamak bẽn ne o aba kêt. Dja gar ã ar anhỹr aba ba kam ar ajaêrbê bôx gar kam ajmã imã amijarẽnh on? ");
INSERT INTO txuNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kute mrãmri ne me mrymã krĩn kute aêrbê parja pyràk. Be, dja ba ã anen ar ajaêrbê bôx, pyka kunĩkôt dja ba ã ar ajaêrbê ibôxo ane, ar akunĩ jaêrbê ibôxo ane. ");
INSERT INTO txuNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kukãm dja ĩ mỳjja kunĩ apôx tẽ. Kadjy ne ba ar amã, “Gop ar arek ijabej ajkam aman amijãno dja. Mã amijãno djan arek Metĩndjwỳnhmã amijo adjà'wỳr rã'ã gê ar ajo tỳx. Gar atỳx ne mỳjja punu apôxkam ijãno djan ikanga kêt. Ne akubyn ibôxkam amikam apijàm kêt ne ikabem aku'ê. Ba ije amijo inhĩ ne me awỳr ibôxja ikabem amikam apijàm kêt ne aku'ê.” Nãm ã Jeju arkum bôx djà nhõ akatimẽ kukãm mỳjja apôx djà nhõ akatimẽ arkum arẽnho ane. ");
INSERT INTO txuNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Ne kam akati kunĩkôt memã Metĩndjwỳnh kukràdjà'ã ujarẽnh tẽ. Metĩndjwỳnh nhõ kikretikam memã 'ã ujarẽnh tẽ. Nhym amykry nhym kam krãnhbê Oriwêre'ỳr tẽn kam ikwã. Nhym akati nhym ajte akubyn Metĩndjwỳnh nhõ kikreti'ỳr tẽn kam ajte memã 'ã ujarẽnho dja. Nhym me kryràm 'ỳr ban bôx ne ujarẽnh ma nhym amykry nhym me mã ba. Nãm ã akati kunĩkôt ã o anhỹro tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Arỳm ne Metĩndjwỳnh nhõ akati, amrẽbê Metĩndjwỳnh me irôbê mrãnh nhym me mã kôt kute mar nhõ akati arỳm o rãm ne ja o mõ. Kam ne me djwỳponhrebit ku. ");
INSERT INTO txuNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nhym kam me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ ne me abenmã Jeju'ã karõo mõ. Mete bĩnmã ne me abenmã 'ã karõo mõ. Ne kam me kum me kàtàmja pyma ne. Me kàtàm ja ne me kunĩ kum Jeju kĩnhĩ. Nhym bep me ja, me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ ne me kum kurê ne kam kute bĩnmã abenmã 'ã karõo mõn kam kum me kàtàmja pyma ne. ");
INSERT INTO txuNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nhym kam Xatanaj Djudamã wadjà. Jeju kôt ba djwỳnhbê 12'õ ne Djuda. Idji 'õ ne Ikadji. Kumã ne Xatanaj wadjà. ");
INSERT INTO txuNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Arỳm Djudamã wadjà nhym kam arỳm mã me'ỳr tẽ. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Metĩndjwỳnh nhõ kikretikam krãkamngônh nhõ bẽnjadjwỳrmẽ me'ỳr tẽ. Me'ỳr tẽn bôx nhym me abenmã 'ã àpnênho nhỹ. Nhym kam me kum, —Ije ba gop on me amã Jeju kanga ga me abĩn amã kurê kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nhym kam arỳm me kĩnhkumrẽx. Kĩnhkumrẽx ne kam kum, —Mexkumrẽx. Gêdja bar kam pãnh amã pi'ôk kaprĩre ngã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nhym kam “Ã” ane. Nhym kam me arỳm kum pi'ôk kaprĩre ngã nhym kam amim kubyn kam ate kato. Katon kam arỳm Jeju'ã amim karõo tẽ. Me 'ã bikprõnh kêtri, me no prãri ne kute me kum kangamã amã. ");
INSERT INTO txuNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nhym kam mebê idjaer kukràdjàkôt mete djwỳponhbit kur nhõ akati arỳm kato. Kam ne me apỹnh ũrkwãkam Metĩndjwỳnhmã mrykĩ'ãtomti pan kubôn kuku. Amrẽbê Metĩndjwỳnh me irôbê mrãnh nhõ akati me kute kôt mar kadjy ne me ã o ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kam ne Jeju kôt ba djwỳnh jano. Nãm Pedrumẽ Djuão ar anon arkum, —Ar tẽn ar ikutêp mrykĩ'ãtomti jabatành nyrewã bĩn aga. Bar wãm bôx gwaj kukrẽ. Gwaj baje Metĩndjwỳnh me irôbê mrãnh nhõ akati mar kadjy mrykĩ'ãtomti krẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nhym ar kum, —Nhỹnh gêdja bar ar akutêp mry ga? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Nhym kam arkum, —Ẽ, ba ar amã arẽ. Gêdja gar tẽn krĩ'ỳr bôx nhym me'õ my ngôo tẽn ar akajpa. Ga kam ar kôt tẽ nhym ũrkwãmã wadjà. Gar kôt wadjàn kam õ kikre djwỳnhjamã kum, “Bẽnjadjwỳr ne amã, ‘Nhỹnh kumoka'ê ja ne me bôx ny kadjy, dja ba ikôt ba djwỳnhmẽ ro'ã bôx ne kam inhõ kwỳ krẽ? Ar ije Metĩndjwỳnh me irôbê mrãnh nhõ akati mar kadjy mrykĩ'ãtomti krẽ’? ane.” ");
INSERT INTO txuNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Dja gar ã kum ane nhym kam ar amã kumoka'ê rax jakre, kỳjrũm imõkkam kumoka'ê raxwã jakre, kapõnh pro, arỳm o mex pro, kam gêdja gar ar ikutêp agan adji, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nhym kam ar tẽn kam kajpa. Kute arkum arẽnh kôtô. Kute arkum arẽnh kôt ne ar tẽn me'õja pumũn kam kôt tẽn ũrkwãmã wadjàn kam ar kutêp mry ga. ");
INSERT INTO txuNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nhym Jeju kute kôt ba djwỳnho mõrja'ã arỳm apajrũm myt tẽ. Nhym ar bôx ne kam ro'ã õ kwỳ krẽnmã arỳm nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nhỹ nhym Jeju arkum, kôt ba djwỳnhbê 12mã, —Ba ne ba imã gwaj baro'ã banhõ kwỳ krẽn prãmkumrẽx. Itokry kêtri gwaj baro'ã baje Metĩndjwỳnh me irôbê mrãnh nhõ akati mar kadjy mrykĩ'ãtomti krẽn prãmã. ");
INSERT INTO txuNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ẽ, ba ar amã arẽ. Ja dja ba krẽn o ino re. Ne kam ajte krẽn kêt 'iry:n kam Metĩndjwỳnh me kadjy bẽnjadjwỳr ne kute me utàr ne kute ar meo bakambit gêdja ba ajte inhõ kwỳ krẽn djà djwỳnhja krẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ne ngônhkrãkam uba kangôjadjwỳ byn 'ã Metĩndjwỳnhmã õdjành jarẽn kam arkum, —Mĩ, ar jao ikõ, aben nhitepã o akõmo mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ba ar amã arẽ, gar ama. Ije pidjô kangôo ikõmo krã'yr ne ja. Metĩndjwỳnh kute amim õ me ja kunĩ pytàr ne kute meo bakambit dja ba ajte pidjô kangô nyo ikõ. ");
INSERT INTO txuNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ne kam ajte djwỳ ja byn 'ã Metĩndjwỳnhmã õdjành jarẽn kam kokijn apỹnh arkum kungãn arkum, —Ẽ, inhĩ ne ja. Inhĩ'ã ne ba djwỳ jakren ar amã kokij. Ar akadjy dja ba ty. Dja me pĩte'y'ã inhôn ibĩ. Dja gar akuprõn inhĩ ja'ã djwỳ jakren krẽ. Dja gar krẽn ã imaro anen imar rã'ã ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nhym ar õ kwỳ krẽn pa nhym kam ajte uba kangô byn kam arkum, —Ikamrô'ã ne ba pidjôbê uba kangô jakre. Dja me ibĩ nhym kam ityk jakôt dja ikamrô ã me akadjy prõt ne bixabjêr ane. Ikamrô jakôt gêdja Metĩndjwỳnh me amã kukràdjà ny, kabẽn ny jarẽnh mãmdji. ");
INSERT INTO txuNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","22","Ẽ, ikuri ỹr ne õ kwỳ krẽno ỹr ja gêdja ikurê djwỳnhmã ikanga. Mrãmri dja me ibĩ. Amrẽbê ne Metĩndjwỳnh me kute ibĩn kadjy amim ijã karõ. Kute amim ijã karõjakôt gêdja me ibĩ. Ba ije amijo inhĩ ne me awỳr ibôxja gêdja me ibĩ. Watĩre kute ikurê djwỳnhmã ikanga djwỳnhwã. Ta gêdja tokry ra:x ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nãm ã Jeju arkum ane nhym kam kôt ba djwỳnhja abenmã, —Ije, mỳj gwaj bajõ dja gwaj kurê djwỳnhmã kanga? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ne abenkam kangao kumex ne kam adjwỳnhdjwỳ abenbê bẽnjadjwỳr pytàro kumex. Ne abenmã, —Ba gêdja ba gop ibẽnjadjwỳr raxo ar ajakre, anhỹro kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nhym kam Jeju arkum, —Me bajtemkam ne me bẽnjadjwỳr rũnh kabẽno meo atom ne ar meo ba. Nãm we memã, “Idjukaprĩkôt ne ba amim me ajo atom ne amim ar me ajo iba. Me akadjy ne ba ibẽnjadjwỳr rax”, ane. Nãm we ã me bajtemkam me bẽnjadjwỳr we ã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bep kati, ar ga dja gar ã anhỹr kêtkumrẽx ne. Dja gar ajõ abenkam arax jabej, djã gãm aje me kutapure pyràk ne me katẽn tẽ. Ne ar ajõ amikam aben kadjy abẽnjadjwỳr jabej gêdja ga tu ar memã adjàpênh aba. ");
INSERT INTO txuNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nhym ne bẽnjadjwỳr raxo kute aben jakrenh? Djãm kum ỹr nhym kute 'ỳr õmrõo tẽmja? Nàr kon djãm kum àpênh ne kute kum õmrõ ne o tẽmja? Kum ỹrja. Bep kati, ba ne ba te ibẽnjadjwỳr raxo me bẽnjadjwỳr kunĩ jakren tu amijo ikàtàm ne ar ar amã idjàpênh iba. Dja gar ã ikudjwa ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ẽ, ar ga ne gar amexkumrẽx. Nãm me te kum ikurên ijo ajkẽ gar mã ijã angrà tỳx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Kam gêdja ba akati 'õkam arỳm ar ajã bẽnjadjwỳr rẽ. Ibãm ne ijã bẽnjadjwỳr mẽ ba kam badjwỳ amidjô'ã ar ajã bẽnjadjwỳr rẽ. Kam dja gar inhõ pyka djwỳnhkam ar akadjy ibẽnjadjwỳr ne ije ar ajo ibakam ikôt anhõ kwỳ krẽn kôt ikõ. Kam dja gar me bẽnjadjwỳr rũnh krĩ djàkam memã akrĩn ar meo aba, apỹnh me kute mekbê idjaermã idji jarẽnh djàri kubê 12jamã akrĩn ar meo aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ỹ, Ximão, Ximão, ota arỳm Xatanaj ar ajã Ibãm ma, kute ar akabimã, mrãmri ar amã ikĩnh ne ijã angrà tỳx ne ar ikôt aba jabej. Kute mrãmri ne me kute bày 'ykà katêk ne kute djwỳ kapĩn djàkam krĩn kute kapĩn ja pyràk. Dja ã Xatanaj kute ar akabimã ã ar ajo ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ẽ, Ximão, ba ne ba arỳm Ibãmmã ajo a'uw. Ijã angrà tỳx ne mã ikôt abikamẽnh ne ar ikôt aba kadjy. Dja ga mekôt ikangan kam akubyn aje iwỳr amijo akẽxkam gora akamydjwỳo tỳx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nhym kam Pedru kum, —Kati, Bẽnjadjwỳr, ba dja ba apymaje iprõt kêtkumrẽx ne. Gêdja me kute abê ijê jabej akôt ibê ijê. Ne kute abĩn o mõr jabej akôt ibĩ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nhym kam Jeju kum, —Kati, ba amã arẽ, Pedru. Akamàt ja tãmkam õkrẽnẽ'ãnh kàr kêtri dja ga amijã maje memã ajêxo dja. Memã aminêje ajêxo adjãmo amãnhkrut ne ikjêkêt ne memã, “Kati, ije tãwã pumũnh kêt”, ane. Be, dja ga ã memã ijã ane. Ba arỳm amã arẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nãm Jeju ã Pedrumã anen kam ajte arkum, —Ije õbê ar ajanor gar anhỹkam amõr ne aje anhõ katõk'y djà, aparkà 'õ byr ne o amõr kêt ne ajênh 'õ aje tur ne o amõr kêtja, djori kam ar anhõ mỳjja kêt? Ne kam ar anhõ kwỳ krẽn djà kêt? ane. Nhym ar kum, —Kati, kam ar inhõ mỳjja, kam ar inhõ kwỳ krẽn djà. Me ne me ar imã kungã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nhym kam arkum, —Nhym bep jakam ne atemã. Jakam dja gar anhõ katõk'y djàwã jamà ne ajênhdjwỳ'õ tun o mõ. Ne anhõ kàxdjwa kajgo kêt jabej on kadjy aminhinôkàtiwã ngãn pãnh pi'ôk kaprĩ byn amim o 'õ byn ar o mrã. ");
INSERT INTO txuNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ba ar amã arẽ. Arỳm ne me kute ibĩnmã arỳm ijo rã:m ne jao tẽ. Amrẽbê me kute Metĩndjwỳnh kabẽnkam ijã pi'ôk no'ôkkam kute, “Nãm me o axwen me axwemẽ ro'ã kubĩ”, anhỹr ja arỳm kator 'ỳ:r. Amrẽbê me kute ijã pi'ôk no'ôk ja gêdja mrãmri on kato nhym me omũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nhym ar kam kum, —Bẽnjadjwỳr, omũ, ota ar inhõ kàxdjwa kajgo amãnhkrut, ane. Nhym kam arkum, —Ã, aj, anũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nãm arkum “Anũ” anen ate kikre kurũm katon krãnhbê Oriwêre'ỳr kôt ba djwỳnho mõ. Kute 'ỳr aro mõr tũmja 'ỳr ne ajte aro mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","'Ỳr aro mõn aro bôx ne kam arkum, —Ar Metĩndjwỳnhmã amijo a'wỳ. Gêdja me te ar ajaxwe'ã ar amã apnê, gar mekôt ajaxwe kêt. Ja kadjy dja gar kum amijo a'wỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Arkum anen ate tẽn ỹro rãm ne nĩj. Nãm kôt ba djwỳnhmã iren tẽn ỹro rãm ne nĩj ne kõnkrão nhỹ. Ne kam arek Bãmmã kabẽno nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ne kum, —Djũnwã, aje ibê ikaprĩja kadjàr jabej on ibê kaba. Aje ibê ikaprĩ kadjàr nhym me kute ibĩn kêtmã ne ba amã amijarẽ. Nàr kon, dja ga mrãmri ibê kadjàr kêt jabej ba tu mrãmri itokryo itẽm rã'ã. Djãm ba ne ba amimar kôt ar amijo iba? Kati, akabẽnkôt ne ba amijo iba, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nhym kam kàjkwa kurũm kadjy mrãnh djwỳnh 'ỳr ruw ne kam o tỳx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nhym kam akubyn Bãmmã amijarẽnho nhỹ. Kaprĩ ra:xkam ajte akubyn prĩne kum amikôt amijarẽnho nhỹ. Kaprĩ raxkam ne õ djàkam tokry. Tokry raxkam ne arỳm 'ã ngô pepeko dja. Djãm 'ã ngô? Kati, kamrô ne prõto dja, pykakam totoko dja. ");
INSERT INTO txuNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ne Bãmmã amijarẽnho nhỹn kam kum amijarẽnh pan kàjmã djan kam akubyn kôt ba djwỳnh'ỳr tẽ. Nhym kôt ba djwỳnh arek õto kumex. Kaprĩ raxkam arek õto kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nhym kam arkum, —Mỳkam ne gar arek anhõto akumex? On ar kàjmã djan Metĩndjwỳnhmã amijo a'wỳ. Gêdja me te ar ajaxwe'ã ar amã apnê, gar mekôt ajaxwe kêt. Ja kadjy dja gar kum amijo a'wỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Arkum kabẽno ãm rã'ã nhym arỳm me kute pa 'amỳnh ne o mõrmã arỳm 'ỳr bôx. Me krãptĩ ne me arỳm 'ỳr bôx. Djuda, Jeju kôt ba djwỳnhbê 12ja'õ ne 'ỳr meo mõ. Ne kam kute o tỹm ne kute ine kaôrmã 'ỳr tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nhym kam kum, —Djuda, djãm aje inhine kaôro atẽm pro aje memã ijo atỹmmã ne ga iwỳr tẽ? Nã gãm ajêx ne ije amijo inhĩ ne me awỳr ibôxja ijo anhõbikwan inhine kaô, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nhym kam Jeju nhõ àpênh bu'ã ku'êja arỳm kuma, tu amikam kuman kum, —Bẽnjadjwỳr, djãm ar ije kàxdjwa kajgoo me ja parmã? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nhym ate ar'õ me'õjamã akabê, me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax nhõ àpênh ja'õmã akabên toxy anen arỳm amak nhikjê ta, amak djubôk ne kuta. Nãm tu amak toprik ane nhym wãnh amak tỹm. ");
INSERT INTO txuNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nhym kam Jeju, —Aje, anũ, arek ar dja, ane. Ne kam amak djãm djà kupê nhym arỳm ajte amak mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nhym kam me kute pa 'amỳnhmã 'ỳr mõrjamã, me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Metĩndjwỳnh nhõ kikretikam krãkamngônhmẽ mebêngêttemã, —Ije djãm idjàkĩnhĩ ne ga me aje ibĩnmã iwỳr anhõ kômẽ anhõ kàxdjwa kajgomẽ o mõ? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Myt kunĩkôt ne ba me akam ar Metĩndjwỳnh nhõ kikretikam iba ga me kam kam ijo atỹm kêt ne. Nà, mrãmri me anhõ akati ne ja. Me ajaxwe rax ne kute akamàt kô tyk pyràk. Nãm prĩne me bajo ajkamuw. Kam ne ga me aje ipa 'amỳnhmã iwỳr mõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nãm ã memã ane nhym kam me pa 'amỳn kam me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax nhõ kikre'ỳr o mõ. 'Ỳr o mõ nhym kam Pedru mekôt tẽ, nĩjar memã kre rax ne tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nhym me arỳm Jejuo mõn o bôx, me kute pa 'amỳnhja ne me arỳm o mõn o bôx ne kam kikre nhipôkri kênh ngrire jakam amim kuton kam 'ã ànhũnho kumex. Nhym kam Pedru mekôt tẽn 'ỳr wadjàn kam me ikô'ã nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nhym bẽnjadjwỳr nhõ àpênh kurererja kuwy pôkmã omũ ne kam 'ỳr tẽn kam no tyn djan kam memã, —Tãwãdjwỳ ne arkôt ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nhym kam Pedru aminêje 'êx ne kum, —Kati, arkati. Ije tãwã pumũnh kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nhym adjynkêt ne me'õ mydjwỳ 'ỳr bôx ne omũn kam kum, —Gadjwỳ ne ga abê õ àpênh'õ, ane. Nhym kam kum, —Kati, arkati. Ibê õ àpênh kêtê, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nhym 'ãtũm nhym ajte me'õ myjadjwỳ 'ỳr bôx ne 'ã no tỳx mex ne 'ãno djan memã arẽn memã, —Mrãmri ne tãwãdjwỳ arkôt ba. Kubê pykabê Garrêja kra'õ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nhym kam kum, —Kati, ije akabẽnwã mar kêt. Ije akabẽnwã mar prãm kêtkumrẽx, ane. Ne kam kabẽno ỹr rã'ã nhym 'ã õkrẽnẽ'ãnh kà. ");
INSERT INTO txuNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nhym kam Bẽnjadjwỳr 'ỳr akẽx ne omũ. Nãm ar aktã aben pumũ. Nhym kam arỳm Pedru Bẽnjadjwỳr kabẽn ma. Kute anhỹr djwỳnhràm kum kabẽn jarẽnh ja ne arỳm kuma. Kute kum, —Akamàt ja tãmkam õkrẽnẽ'ãnh kàr kêtri dja ga aminêje ajêxo amãnhkrut ne ikjê kêt ne memã, “Kati, ije tãwã pumũnh kêt”, anhỹr ja ne arỳm kuma. ");
INSERT INTO txuNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ne kam katon mu:w. Kaprĩ raxkam ne mỳr rax ne. ");
INSERT INTO txuNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nhym me kute Jeju pumũnho ku'êja kam bẽno ajkẽn tak ne. ");
INSERT INTO txuNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nãm me no'ã pron kam apỹnh tak ne kam kum, —Aj, goja me'õ kute akurwanhjakôt omũ. Goja tu aman me imã arẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nãm me prĩ:ne o ajkẽ. Nãm me aprỳ:o kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nhym arỳm akati nhym kam mebê idjaer bêngêtmẽ me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ me kute Môjdjê kukràdjà mar djwỳnhmẽ, me ta ne me aben pydjin amiwỳr Jeju 'uw. Nhym kam me me'ỳr Jejuo mõn o bôx ne me kabem kudja. ");
INSERT INTO txuNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Me kabem kudja nhym me kum, —Goja on me imã amijarẽ. Djãm abê me babê idjaer nhõ Bẽnjadjwỳrbê kumkati, nẽn? Goja on me imã amijarẽ, ane. Nhym kam memã, —Got ba ren me amã amijarẽ ga ren me amim imar kêtkumrẽx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ba ren badjwỳ me akukij ga ren me imã arẽnh kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nhym bep jakam gêdja ba on Metĩndjwỳnh pymati djubôk'ãnh nhỹ. Ba ije amijo inhĩ ne ibẽnjadjwỳr raxkam gêdja ba ubôk'ãnh nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nhym kam me kunĩ kukij ne kum, —Djãm abê Metĩndjwỳnh kra? ane. Nhym kam memã, —Ãã, kôt ne ga me aje arẽnhwã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nhym kam me abenmã, —Bir be, arỳm ta kute amijo Metĩndjwỳnhja ma. Mỳj kadjy dja gu me ajte me'õdjwỳ kukij? Kati, ta ne arỳm amijarẽ gu me arỳm kuma, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nhym kam me rũnhja eku:n kàjmã djan mũjar Piratu'ỳr o mõn o bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","O bôx ne kam Piratumã Jeju kàmex jarẽn kum, —Ẽ, tãmja ne axwere. Tãwã ne ar me ibê idjaer noo biknoro ba. Ba meo tỹm ne awỳr o mõ. Nãm we me imã, “Kwãrĩk wãnh ga me bẽnjadjwỳr raxbê Xedja me kunĩmã ỹr djwỳnhmã pi'ôk kaprĩ nhõr kêt”, ane. Ibê me anhõ Bẽnjadjwỳrbê kumkatikam gêdja ba ipymao ar me apytàn me ajo iba, ane. Nãm we ã me inoo biknoro ane, ane. Nãm ã me Jejuo 'êxo ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nhym kam Piratu Jejumã, —Djãm abê mebê idjaer nhõ bẽnjadjwỳr rax? ane. Nhym kam kum, —Ãã, kôt ne ga aje arẽnhwã, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nhym kam Piratu me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ me krãptĩmã, —Nã bãm te kukij. Ajmã kute kêt. Axwe kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nhym kam me mã kum 'ã apnê. Kum 'ã apnê:n kum, —Kati, nãm prĩne aben kadjy memã 'êx mõ. Nãm Garrêja kurũm tẽn Djudêjakam bôx ne aben kadjy memã 'êx. Nãm krĩ 'õkam bôx ne aben kadjy memã 'êx. Ne ajte amũ krĩ 'õkam bôx ne aben kadjy memã 'êx. Ne ajte amũ 'õkam bôx ne aben kadjy memã 'êx ne ajte amũ 'õkam bôx ne aben kadjy memã 'êx. Ne jakam arỳm bôx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nhym Piratu me kabẽn ja man kam abej me kukij ne memã, —Djãm Garrêjakam me kra'õ? ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nhym me kum “Ãã” ane. Garrêjakam me ja nhõ bẽnjadjwỳr nhidjibê ne Erodji. Ajbir Djeruxarẽkam bôx. Kam ne Piratu Erodji'ỳr Jeju jano, Erodji kute Piratu kudjwa Jeju kukjêrmã. Jejubê Garrêja krakam ne kum ano. Nhym me arỳm 'ỳr o bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nhym Erodji Jeju pumũn kam kĩnhkumrẽx ne. Amrẽbê ne Jeju'ã ujarẽnh man kam te kute tãri omũnh prãme. Nhym kam me arỳm 'ỳr Jejuo mõn o bôx nhym kam kĩnhkumrẽx ne. Kute kum mỳjja pumũnh kêt'õ nhipêx nhym kute omũnhmã ne bit 'ã kamnhĩx ne. ");
INSERT INTO txuNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ne kam te Jeju kukjêr krãptĩ ne. Nhym mrãmri bẽn kêt mex ne dja. ");
INSERT INTO txuNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nhym bep me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ Môjdjê kukràdjà mar djwỳnhmẽ ne me Jeju kuri ku'ên kam mã kum arẽ. Kum kàtàm jarẽnho ku'ê. Djã nãm me akrànmã kum arẽ? Kati, nãm me tu Erodjimã Jeju jarẽnho bê: ne. ");
INSERT INTO txuNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nhym kam Erodji õ krãkamngônhremẽ ro'ã Jeju japrỳ ne 'ã keket ne kam kum me bẽnjadjwỳr kà jadjàn kam akubyn ajte Piratu'ỳr ano nhym me ajte akubyn 'ỳr o mõn o bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nhym Erodjimẽ Piratu ar myt tãmkam abeno õbikwa. Jejukôt ne ar abeno õbikwa. Amrẽbê ne arkum aben kurê ne kam ajbir arỳm Jejukôt abeno õbikwa. Piratu kute Erodji'ỳr Jeju janorkam ne ar arỳm abeno õbikwa. ");
INSERT INTO txuNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nhym me akubyn Piratu'ỳr Jejuo mõn o bôx. O bôx nhym kam Piratu me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ me kute meo ba djwỳnhmẽ me kàtàmmẽ meo akprõn kam memã, ");
INSERT INTO txuNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","—Ẽ, tãm ne ga me iwỳr o mõn o bôx ne kam imã, “Tãmja ne ar me inoo biknoro ba”, ane. Ba kam te kukij, te me anhipôkri kukij, nhym ajmã kute kêtkumrẽx. Mexkumrẽx. Nã gãm me ajêx ne arĩk kàmex jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nhym Erodjidjwỳ te ikudjwa kukij nhym mexkumrẽx. Ga kute ajte akubyn me bawỳr anorja pumũ. Be, mỳj kadjy dja ba kubĩ? Ije bĩn prãm kêtê. ");
INSERT INTO txuNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kam dja ba tu kaprêprêk kajgon ano, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","19","Nhym kam me kunĩ axikôt kum 'ã àpnênho kumex. Ne kum, —Kati, on o tẽn abĩn me imã Baraba bõm amẽ, ane. Nãm Piratu me kute Metĩndjwỳnh me irôbê mrãnh nhõ akati mar kunĩkôt me pỹnh ne bõm me rẽnho tẽ. Me axwe nhym kute mebê ijêja ne bõm me rẽnho tẽ. Baraba ne axwekumrẽx. Nãm me bẽnjadjwỳr kadjy memã 'êx nhym me me bẽnjadjwỳr'ỳr prõt ne, nhym ta adjwỳnhdjwỳ me kwỳ pa. Tãm ne Piratu kubê ijê. 'Ã ne me ku'uw ne kum, —On rũm tãwã o tẽn abĩn pãnh me imã Baraba kaba, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nhym Piratu te kute Jejumã irer prãme. Ne kadjy ajte memã kabẽn ne memã, —Ba kum inhiren ano, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nhym me kàj bê: 'ã kum apnên kum, —On pĩte'y'ã anhô. On pĩte'y'ã anhô, anhỹro kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nhym kam ajte memã, —Tô mỳkam? Mã ne kute dja ba kubĩ? Djãm axwe? Nã bãm te kukij nhym axwe kêtkumrẽx. Kam ne ba ije bĩn prãm kêtê. Dja ba tu kaprêprêk kajgon kam akubyn ano, ane. Nãm te memã anen te memã anen kam arỳm ajte te memã ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nhym me mã 'ã kum apnê. Nãm me kàj bê kum 'ã àpnênho kumex ne kum, —On pĩte'y'ã anhô, on pĩte'y'ã anhô, ane. Nãm me tỳxo Piratu jakrenh mex ne prĩne kabẽno katy. ");
INSERT INTO txuNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nhym kam me umaje “Ã” anen tu memã kanga. ");
INSERT INTO txuNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nhym me'õ kute bẽnjadjwỳr kadjy memã 'êx ne ta kute me kwỳ parja Piratu kaba. Me kute Piratumã “Me imã Baraba bõm amẽ”, anhỹr ja ne kaban anon kam pãnh memã Jeju kanga, krãkamngônhre kute Jeju bĩnmã memã kanga. Me kum kurêkam ne me 'ã Piratumã apnê, kute bĩnmã. Nãm me kum 'ã àpnênho katyk mex ne. Nhym kam arỳm me kute bĩnmã memã kanga. ");
INSERT INTO txuNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nhym kam krãkamngônhre arỳm o mõ. O mõ nhym kam me'õja tẽn me kajpa. Me'õ nhidjibê Ximão, pykabê Xireni kra'õ. Arwã kurũm ne tẽn me kajpa nhym me pa 'amỳn ikreikam pĩte'y djin kam kum, —Kum amỳ, ane. Nhym kam kum kumỳn o Jeju katẽn o mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nhym me itepato kôt mõ. Nhym me niredjwỳ kôt mõ. Mõrkôt abej mỳr mõ, kàj bê abej àmra mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nhym Jeju me'ỳr akẽx ne memã, —Ẽ, àpnhĩre ar, Djeruxarẽkam me kra, kwãrĩk wãnh ga me ijabej amỳr kêt. Bep me akra jabejbit dja ga me muw, ne ga amijabej muw. ");
INSERT INTO txuNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Dja ĩ meo bikẽnh djà nhõ akati me awỳr bôx. Dja me awỳr bôx nhym me abenmã, “Ỹ, me nire kra kêtja ne me mrãmri kĩnhkumrẽx. Ne me kute kra jamỳnh kêtdjwỳ kĩnhkumrẽx. Ne me kute krao kaôr kêtdjwỳ kĩnhkumrẽx”, ane. Me jabit dja me mã prõt ne kato. ");
INSERT INTO txuNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Ne ajte kamã tokry pymaje krãnhmã, ‘On amrẽ me inhiby arôrôk ne me inhimex’, ane. Ne kam ajte krãnh kryre jamã, ‘On amrẽ me inhiby arôrôk ne me ijo apdju’, ane.” ");
INSERT INTO txuNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ga me kute ã pĩ ngoo anhỹrja pumũ. Godja arỳm pĩ ngrà nhym mã dja me ajte on? Ba ne ba ajmã ikute kêtkumrẽx ne itokry rax ne. Nhym bep mrãmri me axweja, mã dja Metĩndjwỳnh me on, Djeruxarẽkam me ajaxweja on? ane. Nãm ã Jeju mỳjja kute meo bikẽnh djà nhõ akati djwỳnhràm ã memã arẽnho anen ta amijaxwe kêt'ã pĩ ngo jakren me axwe'ã pĩ ngrà jakre. ");
INSERT INTO txuNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nhym me amẽ ar kàtàmja Jejukôt aro tẽ, me kute pĩ'ã Jejukôt ar nhôr kadjy. Ar kute mekam ar amikrào baja ne me kute Jejumẽ ro'ã ar parmã aro mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aro mõn aro bôx. Krãnhbê me krã'i'ỳr ne me Jeju aro bôx. Aro bôx ne kam apỹnh pĩte'y'ã ar adjuw. Ne kam ar ikramã kàxiràxo iten ar parjamo iten kam kàjmã krekam ar umjuw. Nhym arỳm ar arij. Jeju õkredjàkôt wajêt nhym aktã ar axweja ijên o wajêt. ");
INSERT INTO txuNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nhym kam Jeju me nêje Bãmmã kabẽn ne, —Djũnwã, dja ga tu imar krãtan mekam angryk kêt. Me kute ibĩnja dja ga tu mar krãta. Me kute ibĩnja ne me kute gu bakukràdjà mar kêtkumrẽx, ane. Nhym kam me abenmã kàja ngrà. Nãm me apỹnh kute kà jamỳnh kadjy kẽn kryre rẽ. Me kute ari kẽn kryre rẽnhkôt ne me amijo kubẽkà pytàn amỳ. ");
INSERT INTO txuNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nhym me kunĩ no ma mõn Jeju pumũnho dja. Nhym me bẽnjadjwỳrdjwỳ aprỳo dja. Nãm me abenmã, —Amũbit ne me utà. Goja gê ta amiptà. Goja gê Metĩndjwỳnh kute anor nhym kubê me banhõ Bẽnjadjwỳrbê kumkatikumrẽx jabej goja on amiptà, Metĩndjwỳnh kute amijo utàr jabej goja on amiptà, anhỹro kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Nhym me krãkamngônhredjwỳ 'ã keket ne aprỳo kumex. Nãm me 'ỳr bôx ne kum pidjô kangô kadjà bẽn kum, —Ajrã, goja on amiptà. Goja abê mebê idjaer nhõ bẽnjadjwỳr rax jabej goja on amiptà, anhỹro dja. ");
INSERT INTO txuNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ne kam ajte Jeju nhimõkri pi'ôk no'ôk nhipêx ne kunhô. Me kute omũnh ne kam kute, —Mebê idjaer nhõ bẽnjadjwỳr rax ne ja, anhỹr kadjy ne me imõkri kunhô. ");
INSERT INTO txuNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nhym kam me kute Jeju nhikô'ã amẽ ar axwe nhôrja ikjêja Jeju japrỳo wajêt. Ne kum, —Goja abê mebê idjaer nhõ Bẽnjadjwỳrbê kumkatikumrẽx ne goja on amiptàn ar badjwỳ ar ipytà, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nhym kam ikjêja kum bẽn tỳx ne kum, —Kwãrĩk wãnh. Birãm amã Metĩndjwỳnh pyma kêtkumrẽx. Me kute gwaj bajanhôr ga arỳm gadjwỳ atyk 'ỳrja pumũ ne kam ajmãn amã Metĩndjwỳnh pyma kêt mex ne. ");
INSERT INTO txuNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mrãmri ne me kute arỳm gu babĩnmã arỳm ã gu bajo ane. Gu ba ne gu ar mekam amikrào baba nhym arỳm me kute pãnh gu babĩnmã. Nhym bep tãmja ne kute ajmã mỳjja 'õo kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ne kam ajte Jejumã, —Jeju, gora anhõ me ja kunĩ kadjy abẽnjadjwỳr ne aje ar meo abakam gora badjwỳ ima, ibiknor kêt kadjy ima, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nhym kam Jeju kum, —Myt ja tãmkam dja gu baro'ã kàjkwakam Ibãm nhõ pyka'ỳr bôx. Mrãmri ne ba arỳm amã ikabẽn pydjin arẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Nhym arỳm kàjkwa nhipôkri myt nhỹ. Nhym kam tu akamàt kô tyk ne. Pyka kunĩkôt me'ã akamàt kô tyk ne, arngro kêtkumrẽx ne. Nãm me'ã akamàt kô tykkam myt kyn kyn kyn ky: nhym 3 orakam, amykrykambit arỳm ajte kàjkwa no pôt ne. Arỳm ajte myt kato. Nhym arỳm Metĩndjwỳnh nhõ kikreti kadjwỳnhbê kubẽkàtija ta amikadjô. Nãm kônh e ty:k ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nhym kam Jeju Bãmmã amijarẽ. Kàj bê kum amijo akij ne kum, —Djũnwã, ba wãm awỳr ikarõ jano, ane. Nãm ã kum anen kum amikarõ janon ate ty. ");
INSERT INTO txuNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nhym krãkamngônhre krãptĩbê 100 nhõ bẽnjadjwỳr Jeju tykkôt omũn kam Metĩndjwỳnhmã rax jarẽ, ne, —Mrãmri ne djãm tãmja axwe kêtê. Mexkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nhym me itepato kute Jeju tykkôt omũnhmã mõrja arỳm mỳjja kunĩ pumũn kam akubyn mõn kaprĩkam aminhõkôt titiko mõ, ũrkwã'ỳr binhirênh mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nhym bep õbikwa kunĩmẽ, Garrêja kurũm me nire kôt mõrjamẽ, me tãm ne me arek omũnho dja, kum kre rax ne omũnho dja. ");
INSERT INTO txuNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","52","Nhym kam me'õ nhidjibê Jôdje ne Piratu'ỳr tẽ. Mebê idjaer nhõ krĩ'õ nhidjibê Armatêkam kra'õ. Nãm me rũnh bikprõnh djàkam mekôt mrã. Kabẽn mexkumrẽx, katàt ne mrã. Nhym me kute Jeju bĩnmã amim 'ã karõo nhỹ nhym kam te nêje me kukrà. Atemã ne kabẽn. Me ja kabẽnkôt kabẽn kêtê. Nãm amim Metĩndjwỳnh kamnhĩx ne. Metĩndjwỳnh bôx ne me kadjy bẽnjadjwỳr ne kute ar meo bamã ja ne amim kamnhĩx ne. Tãm ne Piratu'ỳr tẽn bôx ne Jeju'ã kuma. Kute Jejuo rwỳk ne adjàrmã ne 'ỳr tẽn bôx ne 'ã kuma. ");
INSERT INTO txuNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nhym kam kum “Ã” anen kam kum kanga. Nhym kam pĩte'y'ỳr tẽn kam Jejuo ruw, kute adjàrmã. Ne kam kadjy kubẽkà mexja byn kam prĩne o kupun kam kẽnkrekam adjà. Me kute kẽnkre kakrwỳnh nyjakam adjà. Kraxje me kute kam me'õ jadjàr kêtkumrẽx. Kam ne adjà. ");
INSERT INTO txuNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pi'ôk ràràr nêje akati jakam ne adjà. Akati jakam ne me no katon õ mỳjja kupênho kumex. Pi'ôk ràràr kêtri õ mỳjja kupênho kumex. Akati jakam ne adjà. ");
INSERT INTO txuNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","56","Nhym me nire Garrêja kurũm Jeju kôt mõrja mekôt mõn omũ. Nãm me kute kẽnkrekam adjàrkôt omũn kam akubyn ũrkwãmã mõn bôx. Bôx ne kam me kudjỳ djàmẽ pidjỳ nhĩnmẽ kubyn abenkam o akàn kam kadjy kudji. Nhym pi'ôk ràràr nhym arỳm me nire tyk djà kêto kumex, Môjdjê kukràdjàkôt ne me pi'ôk ràràrkam tyk djà kêto kumex. ");
INSERT INTO txuNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nhym arỳm pi'ôk kamrêk. Nhym ar nire kry:ràm kô rã'ã kute me kudjỳ djà abenkam o birênh ne irja byn 'ỳr o mõ, kẽnkre'ỳr o mõ. Ar kute kẽnkrekam adjàrja'ỳr o mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nãm ar bit Jeju'ỳr o mõ, ar kute o kudjỳmã ne ar bit 'ỳr o mõr kajgo. Nhym arỳm me kute kẽnpotio 'ã ijêja arỳm amijã kutan kre jakà'ã amidjan dja. Me'õ ne o mõn kudja nhym dja. ");
INSERT INTO txuNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nhym ar nireja 'ỳr mõn kẽnkremã wangij ne kam te Jeju nõr djà kamũ nhym nõr kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nhym ar te kute mỳjja'õ marmã o dja nhym adjynkêt ne ar my amãnhkrutja ar aêrbê kato. Tu ar nokam kato. Õ kubẽkà jadjê:nh ne ar kuri dja. ");
INSERT INTO txuNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nhym ar te tĩn prãme ne rôrôk ne ponh ne ikwã. Nhym kam arkum, —Mỳkam ne gar me tykkam me'õ akubyn tĩnja jabej mõ? ");
INSERT INTO txuNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Ẽ, ar nõr kêtja pumũ. Arỳm ne akubyn tĩn ne kato. Djã ne gar kabẽnja ma. Amrẽbê ne ar amã, Garrêjakam ar ba rã'ãkam ar amã, “Gêdja me me axwemã ikanga. Ba ije amijo inhĩ dja me me axwemã ikanga nhym me pĩte'y'ã inhô ba ty ne ijã akati amãnhkrut ne ikjêkêt ne akubyn itĩn ne”, ane, ã ar amã ane. Ã ar amã ane gar ajte abej mõ, ane. Nãm ã kadjy mrãnh djwỳnh arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","10","Nhym kam ar nire arỳm Jeju kabẽn ja ma. Kabẽn ja man kam akubyn kẽnkre kurũm mõ. Mõn bôx ne kam Jeju kôt ba djwỳnhmã mỳjja kunĩ jarẽ. Kôt ba djwỳnhbê 11mẽ õbikwaja kunĩmã mỳjja jarẽ. Marij Madarenamẽ Djôwanãmẽ Xijagu nãbê Marijmẽ ar ro'ã mõrjamẽ. Ar ja ne Jeju'ỳr mõn te nõr djà kaprãn bôx ne memã arẽ, Jeju kute tũmràm ar anorjamã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nhym bep nãm me ate krã. Nãm me o kabẽn kajgon kam tu ate krãn amim kamnhĩx kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nhym bep Pedrubit ne ekrux ne kàjmã djan kam kẽnkre'ỳr prõt ne 'ỳr bôx ne kam te 'ã ibôn ỹmkjêro nõ. Te abej rĩto nõ. Nhym kupu djàbit ate nõ. Nhym omũn kam akubyn tẽ, te kute amikam mỳjja'õ marmã umar tẽ. Tẽn ũrkwãkam bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nhym myt tãmkam kôt ba djwỳnh amãnhkrut ne krĩ ngrire 'õ'ỳr tẽ. Krĩ ngrirebê Imau'ỳr ne ar tẽ. Djãm mũjar got. Tãm ne ja. Djeruxarẽ kurũm pry'ã akrebê 11 kirometu 'ỳr ne ar tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ne kam abenmã kabẽn tẽ, abenmã Jeju bĩnmẽ mỳjja ja kunĩ jarẽnho tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Abenmã arẽnho tẽm rã'ã nhym Jeju arkôt bôx. Arkôt bôx ne arỳm ro'ã mõ. ");
INSERT INTO txuNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nãm ar omũnh kajgo. Bãrãm mỳjja ne ar no'ã nhym ar te kute omũnhmã. Jeju ta ne aminêje ar no nhity ne kam arkum, ");
INSERT INTO txuNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","—Ije tô mỳj ne gar abenmã arẽnho tẽ? ane. Nãm arkum kabẽn nhym ar tẽm tỳx katikôt djan kam kaprĩre, nokre kaprĩre ne dja. ");
INSERT INTO txuNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nhym kam ikjêja idjibê Kreôpa kum, —Ije birãm apydji ne ga aje mỳjja mar kêt, mỳjja ajbir katorja mar kêt ne. Djeruxarẽkam me kunĩ ne me kuma, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nhym kam kum, —Ije nhym mỳj nã? Nhym mỳj ne gar abenmã arẽnho tẽ? Nhym amẽ ar ja kum, —Ije tô gêt Nadjarekam me kra'õ nhidjibê Jeju. Metĩndjwỳnh kabẽn jarẽnh djwỳnh'õ. Kabẽn mexkumrẽx. Nãm katàt memã Metĩndjwỳnh kukràdjà'ã ujarẽnh mexkumrẽx ne. Ne ar memã mỳjja pumũnh kêt kwỳ 'yro ba. Mỳjja kwỳ nhipêx mexkumrẽxo ba. Kam ne Metĩndjwỳnh kam kĩnhkumrẽx nhym me kàtàmdjwỳ kam kĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nhym bep me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ me banhõ bẽnjadjwỳrmẽ, me ja ne me me kute bĩnmã memã kanga nhym me pĩte'ykam kubĩ. ");
INSERT INTO txuNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ỹ, kute me bakurê djwỳnhbê me bapytàrmã, me babê idjaer pytàrmã ne bar bajbit amim kamnhĩx ne, nhym arỳm ty. Nãm me arỳm kubĩ nhym kam arỳm 'ã akati amãnhkrut ne ikjêkêt. ");
INSERT INTO txuNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Nhym ar nire ar ikôt Jejumã àpênh ja ar ijaê. Kry:ràm ne ar kẽnkre'ỳr mõn te abej ne kam akubyn bôx ne kam we ar imã, “Arỳm ne bar mỳj me'õja pumũ. Birãm kadjy mrãnh djwỳnh got bar omũ. Nhym ar imã, ‘Jeju ne arỳm akubyn tĩn ne’, ane.” Nà, nãm ã ar nire ar ijaêro ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nhym kam ar ijõ kẽnkre'ỳr tẽn te kam abej. Nhym kẽnkre kaprỳ ne. Mrãmri ne ar nire kôt arẽ. Nhym bep Jeju ta ne amirĩt kêtkumrẽx, ane. Ã kum ane. Nãm ã Jeju kôt ba djwỳnh Jejuo atemã me'õn ã kum kabẽn ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nhym kam Jeju ta arkum, —E kum ar ano kêt. Mỳkam ne amrẽbê Metĩndjwỳnh kabẽn jarẽnh djwỳnh me amã mỳjja ja jarẽ ga me tu amim mar ne amijamakkrekam kunĩ nhôr ne ar o aba kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mrãmri ne arỳm Bẽnjadjwỳrbê kumkati tokryn arỳm kàjkwamã tẽmmã. Amrẽbê Metĩndjwỳnh kabẽn jarẽnh djwỳnh kute arẽnh kôtô. Dja tokry kumrẽx ne kam arỳm bẽnjadjwỳr rax kadjy kàjkwamã tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ne kam prĩne arkum Metĩndjwỳnh kabẽn'ã ujarẽnh tẽ, Metĩndjwỳnh kabẽnkam ta amijã ujarẽnhja ne kunĩ arkum 'ã ujarẽnh tẽ. Nãm Môjdjê kumrẽx memã 'ã pi'ôk no'ôkmo krax nhym kam atãri Metĩndjwỳnh kabẽn jarẽnh djwỳnh memã 'ã pi'ôk no'ôk ne. Nhym kam ta amijã ujarẽnh tẽm tãmtã ĩ amũ 'ã ujarẽnh tẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","Nhym kam ar ro'ã mõ. Ar krĩ'ỳr tẽmja'ỳr ne ar ro'ã mõn kam arỳm têpo mõ. Nhym kam bit Jeju mã tẽmmã. Nhym ar kabẽno nê ne kum, —Jãnh ar inhũrkwãkam ar inhikô'ã nõ. Arỳm ne apajrũm myt nhỹ. Arỳm akamàt 'ỳr, ane. Nhym kam tu arkôt wadjà. ");
INSERT INTO txuNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ne kam bit õ kwỳ krẽnmã nhỹ. Õ kwỳ krẽnmã nhỹn kam djwỳ byn Metĩndjwỳnhmã amikĩnh jarẽn kam ipôn arkum kungã. ");
INSERT INTO txuNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nhym kam ar amak e tyk anen arỳm Jeju ma nhym kam tu ar nokam akuno. ");
INSERT INTO txuNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tu ar nokam akuno nhym kam ar abenmã, —E kum tãm. Ga pry'ã kute gu bamã Metĩndjwỳnh kabẽn'ã pi'ôk no'ôk jarẽnho tẽm gu bakĩnh ne bakrãkà 'ô nhỳnhja pumũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Ne ekrux ne kàjmã djan kam ajte akubyn Djeruxarẽmã tẽ, Jeju kôt ba djwỳnh'ỳr tẽ. Jeju kôt ba djwỳnhbê 11mẽ õbikwamẽ ne ar ro'ã aben pydjin nhỹ. Nhym kam ar ar ja'ỳr bôx. Bôx nhym ar aben pydjin ỹr ja ar kutã arkum arẽ, —Mrãmri ne arỳm Bẽnjadjwỳr akubyn tĩn ne katon Ximãomã amijo amirĩt ne, ane. Ar kutã ne ar arkum arẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nhym kam ar nĩnh tẽmjadjwỳ amipãnh arkum arẽ. Pry'ã ar tẽm nhym Bẽnjadjwỳr Jeju arkôt bôx ne ro'ã mõr ne kikrekam ỹr nhym kute djwỳ nhipônh ne 'ã Metĩndjwỳnh 'wỳr ne arkum õr nhym ar kute kôt kum kator ja ar amipãnh arkum arẽ. ");
INSERT INTO txuNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nãm ar arkum arẽnho ãm rã'ã nhym Bẽnjadjwỳr ta ajte tu ar nokam katon ar ipôkri dja. Ar ipôkri djan arkum, —On ar adjumar mex ne ar aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nhym kam ar tĩn prãm ne kum uma: ne. Nãm ar Jejuo me karõn kam kum uma: ne. ");
INSERT INTO txuNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nhym kam arkum, —Mỳkam ne gar amikam atĩn prãm ne anhõkre kadjwỳnhbê amim, “Mỳj ne ja? Birãm me karõ ne ja”, anhỹro akumex? ");
INSERT INTO txuNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ẽ, ar inhikramẽ iparkam kàxiràx djwakreja pumũ. Ba. Atemã me'õ kêt. Gop ar ikupên ipumũ. Djãm ã me karõ kute anhỹr? Me karõ ã kute anhỹr kêt. Gop ar inhĩmẽ ijija pumũ. Djãm me karõ ã 'imẽ ĩ kute anhỹr got, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ã arkum anen kam arkum aminhikramẽ amipar bẽn kam ari arkum o apa. ");
INSERT INTO txuNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nhym ar omũn kam kĩnhkumrẽx ne. Ne kam kĩnhkam amim, —Ije, djãm tãm? Kati, atemã me'õ. Nàr kon tãmỹ, anhỹro kumex. Nãm ar kĩnh rax ne kam te kute marmã o dja. Nhym kam Jeju arkum, —Djori mỳjja ba kukrẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Nhym kam ar kum tep djàr kwỳ tan kungã nhym kubyn kukrẽ. Nhym ar arek 'ã omũnho nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nhym kam arkum, —Ẽ, ar ikabẽn ja ma. Ar akam ar ibari ikabẽn ja gop ar ama. Nã bãm anhỹr djwỳnhràm ar amã, “Me kute ijã pi'ôk no'ôkja kunĩ dja apôx gar omũ. Môjdjêmẽ me Metĩndjwỳnh kabẽn jarẽnh djwỳnh kute ijã pi'ôk no'ôk nhym me ijã ngrerdjwỳ 'ã pi'ôk no'ôkja kunĩ dja apôx gar omũ”, ane. Nã bãm ã ar amã ane nhym arỳm apôx gar arỳm omũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nãm ã arkum anen kam arkum Metĩndjwỳnh kabẽn'ã pi'ôk no'ôkja kunĩ jarẽnho tẽn kadjy ar amak bô nhym ar kam kuma. ");
INSERT INTO txuNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nãm arkum, —Metĩndjwỳnh kabẽn'ã pi'ôk no'ôkkam ne, “Bẽnjadjwỳrbê kumkati dja tokryn tyn 'ã akati amãnhkrut ne ikjê kêt ne akubyn tĩn ne kato”, ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kam dja me pyka kunĩkôt kàj bê 'ã ujarẽnh mõ gê me amim katon wãnh axwemã iren Metĩndjwỳnh'ỳr amijo akẽx gê Metĩndjwỳnh me axweo aknon mekam ngryk kêt. Djeruxarẽkam dja me memã arẽnhmo krax ne. Ne kam apỹnh pyka kunĩkôt memã arẽnho ajmà. Nãm ã me anhỹr djwỳnhràm Metĩndjwỳnh kabẽnkam 'ã pi'ôk no'ôko ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nhym arỳm apôx gar ga anoo prĩne omũ. ");
INSERT INTO txuNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jakam dja ba ar amã Ibãm Karõ jano. Ibãm kute ar amã kabẽn pydjin arẽnhja tãm, kute ar amã Amikarõ jarẽnh tãm dja ba amrẽ ar amã ano. Gora ar arek krĩraxbê Djeruxarẽwãkam arek djan kam ama. Adjãm rã'ã gê arỳm ar awỳr bôx. Dja kàjkwa kurũm ar awỳr ruw ne kam ar ajo ban kam ar ajo tỳx gar kam atỳxkumrẽx ne kam pyka kunĩkôt 'ã adjujarẽnh mõ, ane. Nãm ã arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ne kam krĩbê Betanhamã aro mõn aro bôx. Djeruxarẽ kurũm aro mõn aro bôx ne kam aro kĩnh ne. Kute aro kĩnh kadjy ne arkum ikra bẽn arkum kabẽn ne. ");
INSERT INTO txuNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Arkum kabẽno ãm rã'ã, tu kabẽn konenh mebê kàjkwamã wabin kam arỳm kàjkwakam õ pykamã bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nhym kam kôt ba djwỳnhja kum mex, rax jarẽnho kumex. Ne kam akubyn Djeruxarẽmã arỳm mõn bôx. Kĩnhkumrẽx ne mõn bôx. ");
INSERT INTO txuNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ne kam Metĩndjwỳnh nhõ kikretikam ar mã Metĩndjwỳnhmã mex, rax jarẽnho ba. Mrãmri. Tãm ne ja.");
INSERT INTO txuNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mỳjja kunĩ kêtri ne arỳm me'õ nhidjibê Kabẽn. Me'õ nhidjibê Kabẽn kàjkwakam Metĩndjwỳnhmẽ ro'ã nhỹn adjwỳnhdjwỳ kubê Metĩndjwỳnh. ");
INSERT INTO txuNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ta ne mỳjja kunĩ kêtri Metĩndjwỳnhmẽ ro'ã nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kubê ne mỳjja kunĩ nhipêx djwỳnh. Ne ren kêt nhym ren mỳjja katorjadjwỳ kunĩ ren kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Me'õ nhidjibê Kabẽnjabê ne mỳjja kunĩ tĩn djwỳnhkumrẽx. Ne kam kôt kute mrãmri ne me kurwỳ djà pyràk. Ga, ngônhpôk kute akamàt kô tyk kurwỳ nhym me kute akamàtkam mỳjja kunĩ pumũnh ne katàt mrãnhja pumũ. Me jadjwỳ ne me axwen kam mrãnh punu. Nhym kam me memã me'õ nhidjibê Kabẽnja'ã ajarẽ nhym me kwỳ arỳm amim tu markumrẽx. Kubê mỳjja kunĩ tĩn djwỳnhkam ne me kwỳ amim tu markumrẽx ne kam arỳm axwe kêt ne katàt amijo ba. ");
INSERT INTO txuNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ga, akamàt kô tykkam me kute mỳjja pumũnh kêt ne ba punuja pumũ. Me kwỳ jadjwỳ ne me axwen ba punu. Nhym kam me memã me'õ nhidjibê Kabẽnja'ã ajarẽ. Memã 'ã ajarẽ nhym me axweja kute akamàt kô tykkam baja pyràk ne me amim mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Be, atemã me'õbê ne Djuão. Ngômã me angjênh djwỳnhja. Metĩndjwỳnh ne Djuão jano nhym arỳm kukwakam ujarẽnh tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Me'õ nhidjibê Kabẽnja kute mrãmri ne me kurwỳ djà pyràk nhym Djuão arỳm 'ã ujarẽnh tẽ. Kôt me kunĩ kute tu amim me'õbê Kabẽnja markumrẽx kadjy ne 'ã ujarẽnh tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Be, djãm Djuão ta kute me kurwỳ djàja pyràk? Kati. Kukãm kute 'ã ujarẽnh kadjy ne tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Me'õ nhidjibê Kabẽnja ne mrãmri kute amijo ba mexkumrẽx ne katàt kute memã kabẽn jarẽnhkumrẽx. Nãm me kunĩmã arẽnhkumrẽx. Kute mrãmri ne me kurwỳ djà kute memã pry kurwỳ pyràk. ");
INSERT INTO txuNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Me'õ nhidjibê Kabẽnja ne amikadjy me kunĩ nhipêx ne tũmràm me'ỳr bôx ne me ro'ã ar ba. Ta ne amikadjy me kunĩ nhipêx. Nãm te me ipêx ne te me ro'ã ar ba nhym me kute amim mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Õ me wỳnh'ỳr ne bôx nhym õ me wỳnh kute o aminhõ bẽnjadjwỳr kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nhym be, me kwỳ ne me apỹnh ĩ djàri arỳm o aminhõ bẽnjadjwỳrkumrẽx. Me ja ne me me'õ nhidjibê Kabẽnja'ã amim, —Mrãmri ne kubê Metĩndjwỳnh Krakumrẽx, ane. Nãm me amim anen arỳm o aminhõkumrẽx. Nhym kam arỳm apỹnh me ĩ djàri memã kum, —Mrãmri ne arỳm abê Metĩndjwỳnh krakumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mebê Metĩndjwỳnh krakam arỳm umar djà ny. Umar djà nyo kute mrãmri ne me prĩre bixadjwỳr nykam umar djà ny pyràk. Djãm me my kute me niremã kra jadjwỳrkôt me umar djà ny? Kati. Nàr, djãm me my kute me nireo ikwã prãmkôt ne me umar djà ny? Kati. Nàr, djãm me kute kra'ã amim karõkôt me umar djà ny? Kati. Metĩndjwỳnh kute memã amak bônhkôt me umar djà ny. ");
INSERT INTO txuNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Be, me'õ nhidjibê Kabẽnja ne arỳm amijo ĩ ne me baro'ã ar ba. Nãm mexo uman ar ba. Ar ba ne bar prĩne mexo umakôt omũnho iba. Bãm pyma o ne uma. Kubê Metĩndjwỳnh Kra djwỳnh. Pydji. Kam ne prĩne mexo uma. Ta ne tu kum me kaprĩ:kumrẽx ne kabẽn pỹnh ne arẽn me baro'ã ar ba. ");
INSERT INTO txuNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Be, ngômã me angjênh djwỳnhbê Djuão ne kàj bê 'ã ajarẽn memã kum, —Arỳm ne ba ar amã me'õ ja'ã ajarẽn 'ã ar amã, “Me'õ dja ikôt bôx. Nãm raxo katàt ijakre. Be, mỳkam? Bir, amrẽbê: ikêtri ne ar ba tũm. Kam ne raxo katàt ijakre”, ane. Arỳm ne ba ã ar amã ane. Nãm ã Djuão memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Be, mỳjja kunĩ ne õ. Ta ne ukaprĩo ukaprĩn õ mỳjja kunĩmẽ me bakunĩo djuw mexo nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Môjdjê ne Metĩndjwỳnh kukwakam me kute katàt amijo ba'ã memã karõ. Me axwe kêt kadjy memã karõ. Nhym be, Jeju Kritu ta ne tu kum me kaprĩn kabẽn pỹnh ne arẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Be, djãm me'õ ne kute Metĩndjwỳnh pumũnh got? Arkati. Kra djwỳnh pydjibit ne kute omũnh. Bãmmẽ ro'ã ne nhỹ. Krabit kute omũnh ne arỳm memã 'ã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Be, Djeruxarẽkam mebê idjaer rũnhja ne me Djuãomã me kwỳ jano. Ne me kadjy Metĩndjwỳnh mar djwỳnh kwỳ jano. Ne mebê Rewidjwỳ kwỳ jano. Me kute abej Djuão kukjêr kadjy ne me me kwỳja jano nhym me arỳm 'ỳr mõ. 'Ỳr mõ:n kam arỳm 'ỳr bôx ne kum, —Mỳj me ajõ ga nã? Djãm abê me inhõ Bẽnjadjwỳrbê kumkatibê Kritu? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nhym Djuão memã 'êx kêt ne mrãmri tu memã arẽnhkumrẽx ne memã kum, —Ba ibê Kritu kêt. Metĩndjwỳnh kute ijã me õ Bẽnjadjwỳrbê kumkati mẽnh kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nhym me kum, —Be, abê Kritu kêtkam mỳj me ajõ ga nã? Djãm abê Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh? Djãm abê Erij? ane. Nhym memã kum, “Kati”, ane. Nhym me kum, —Metĩndjwỳnh kute me imã kukwakam kabẽn jarẽnh djwỳnh'õ janormã. Djãm ga? ane. Nhym memã kum, “Kati”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nhym me kum, —Bir, dja ga me imã amijarẽ. Me ije memã akabẽn jarẽnh kadjy. Me kute awỳr me ijanor ba me ije memã akabẽn jarẽnh nhym me kute amar kadjy on me imã amijarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nhym memã kum, —Be, amrẽbê: ne Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnhbê Idjaij ijã kabẽn jarẽn me bakukãmãremã kum, “Kapôt kukritkam dja me'õ kàj bê me akren memã kum, ‘Bẽnjadjwỳr djwỳnh kutêp wãnh ajaxwemã anhiren kum amex. Kute mrãmri ne me kute me bẽnjadjwỳr rũnhmã katàt pry jadjwỳr nhym mexja pyràk. Dja gar ã kutêp amexo ane’, ane.” Ba ijã ne Idjaij memã ane, ane. Djuão ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Be, mebê idjaer rũnh kute Djuão'ỳr me kwỳ janorja, kute kukjêrjabê ne mebê pardjêu. ");
INSERT INTO txuNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Djuão amijã memã ane nhym me kum, —Be, abê Bẽnjadjwỳrbê kumkatibê Kritu kêt ne abê Erij kêt ne abê Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh'õ kêt ne kam Metĩndjwỳnhmã ngômã me angjênho aba. Mỳkam? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nhym memã kum, —Bir, ba ikajgo me:xi. Ije Metĩndjwỳnhmã me arẽnh kadjy ba ngômãbit me angjênho iba. Ikajgo nhym be, me'õ ra:x arỳm bôx. Ne kam ar me banhipôkri ba ga me aje mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tãmwã 'ã ne ba me amã, “Me'õ gêdja ikôt bôx. Nãm raxo katàt ijakre”, ane. Bãm te irax ne 'ã inhibôn ije kum parkà 'ãpre bônh ne o itẽm prãmje. Be, ãm irax ba ren arỳm kum apê. Nhym be, kati. Ãm ingrire. Nãm raxo ijakrenh mex ne. Nãm ã Djuão memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ngô raxbê Djodão nhikjê'ã krĩbê Betanhakam ne ã memã ane. Ngômã kute me angjênh djàkam ne ã memã ane. Djeruxarẽ kurũm me bôxjamã ã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nhym kam arỳm akamàt ne akati. Nhym Djuão ar jãnh dja nhym nĩnh Jeju Djuão kutã tẽ. Nhym omũn 'ã memã kum, —Ota, Metĩndjwỳnh nhõ Mrykĩ'ãtomti jabatành ny tẽ. Tãm ne Metĩndjwỳnh me bawỳr ano nhym me kute bĩn nhym kute me kunĩ jaxweo pãnhmã. ");
INSERT INTO txuNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tãmwã 'ã ne ba ar amã, “Me'õ dja ikôt bôx. Nãm raxo katàt ijakre. Be, mỳkam? Bir, amrẽbê: ikêtri ar ba tũm. Kam ne raxo katàt ijakre”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Be, djãm ba ne ba amrẽbê nokre pumũ? Kati. Ije amrẽbê omũnh kêt. Metĩndjwỳnh kabẽnkôt ije me abê idjaermã Kritu'ã idjujarẽnh ga me aje marmã. Jabit ne ba kuma. Me aje Kritu marmã ne ba ngômã me ajangjênho iba, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Ne kam Djuão ajte memã kum, —Djãm amrẽbê ije nokre pumũnh got? Kati. Metĩndjwỳnh amrẽbê ngômã me angjênh'ã imã karõ. Ne kam ije Kritu nokre pumũnh kadjy ta ajte imã, “Be, me'õ'ã dja Ikarõ ruw ne arek kam nhỹ ga omũ. Tãmja ta gêdja memã Ikarõ jano nhym arỳm meo ba”, ane. Kute imã anhỹr kôt ne ba kam arỳm nokre pumũ. Metĩndjwỳnh Karõ kute tut pyràk arỳm Jeju'ã ruw ne arek kam nhỹ ba arỳm omũn kam nokre pumũ. ");
INSERT INTO txuNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ije nokre pumũnhkam ba arỳm memã arẽnhkumrẽx ne memã kum, “Be, mrãmri tãmwãbê Metĩndjwỳnh Krakumrẽx”, ane. Jeju kutã tẽmkam Djuão ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Nhym kam ajte akati nhym Djuãomẽ kôt ba djwỳnh amãnhkrut ar Jeju tẽmkôt omũnho dja nhym arỳm arkum, —Ota, Metĩndjwỳnh nhõ Mrykĩ'ãtomti jabatành ny tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nhym Djuãokôt ba djwỳnh ar kuman mã Jeju kôt ajkamẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nhym Jeju ar'ỳr akẽx nhym ar kôt tẽ nhym ar omũn arkum, —Mỳj nã? Mỳj ne gar amã kĩnh ne ikôt tẽ? ane. Nhym ar kum, —Rabi, nhỹnh ne ga anhũrkwãja? ane. Ujarẽnh djwỳnh'ã ne ar kum, “Rabi”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nãm ar ũrkwã jabej kukij nhym arkum, —Amrẽ ar ikôt tẽn omũ, ane. Nhym ar arỳm kôt tẽ. Kôt tẽ:n arỳm ũrkwã'ỳr bôx ne arỳm omũ. Ne kam arek kam nhỹ. Arỳm ar'ã amykrykam ar arek kam nhỹ. Nhỹ: nhym ar'ã akati. ");
INSERT INTO txuNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Be, ar amãnhkrut kute Djuão kabẽn mar ne mã Jeju kôt bikamẽnhja nhikjê nhidjibê ne Ãngre. Ãngremẽ Ximão Pedru ar axikôt apôx. ");
INSERT INTO txuNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nãm ar ỹr'ã akati nhym Ãngre kamy Ximão kumrẽx jabej tẽn arỳm kum katon kum, —Arỳm ne bar Mexijmã ikato, ane. Me õ Bẽnjadjwỳrbê kumkatibê Kritu'ã ne me kum Mexij jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nãm Ximãomã anen arỳm Jeju'ỳr o tẽn 'ỳr o bôx ne kum akre. Nhym kam Jeju arek omũnho djan kum, —Ga abê Ximão. Djônaj ne adji. Dja ba jakam amã Xepa jarẽ, ane. Be, kẽn'ã ne kum Xepa jarẽ. Me bakabẽnkam ne kum Pedru jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nhym ajte ar'ã akati nhym Jeju pykabê Garrêja'ỳr tẽmmã. Ne 'ỳr tẽm kêtri Piripi kumrẽxmã katon kum, —Amrẽ mã ikôt ajkamẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Krĩraxbê Bexadakam ne Piripi nhũrkwã. Kamdjwỳ ne Ãngremẽ Pedru ar ũrkwã. ");
INSERT INTO txuNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nãm Jeju Piripimã kabẽn nhym kam arỳm tẽn Natanajeumã kum, —Arỳm ne bar kum ikato. Me bakukãmãre Môjdjê kute me bakukràdjà'ã pi'ôk no'ôkkam kute tãmwã'ã pi'ôk no'ôk. Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh 'õdjwỳ ar kute tãmwã'ã pi'ôk no'ôk. Bar pi'ôk kôt kum ikato. Kubê ne Nadjarekam Jeju, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nhym Natanajeu kum, —Tô nhỹnh, djãm Nadjare kurũm mỳjja mex'õ kator prãm got? ane. Nhym kum, “Amrẽ ikôt tẽn omũ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ne kam arỳm 'ỳr o tẽ. 'Ỳr o tẽ:n 'ỳr o bôx. Nhym Jeju arỳm Natanajeu tẽmkôt omũn kum, —Be, ga abê idjaerkumrẽx. Ajêxnhĩ kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nhym Natanajeu kum, —Je, nhỹnh ne ga arỳm ima? ane. Nhym kum, —Be, Piripi kute iwỳr ajwỳr kêtri ne ba arỳm apumũ. Pĩbê pigêre parbê anhỹrri ne ba arỳm apumũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nhym kum, —Ujarẽnh djwỳnh, mrãmri ne abê Metĩndjwỳnh Krakumrẽx. Abê mebê idjaer nhõ bẽnjadjwỳr rax, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nhym Jeju kum, —Ba ije amã, “Pigêre parbê anhỹrri ba arỳm apumũ”, anhỹrbit. Ga kam arỳm tu amim imarkumrẽx. Adjỹm, dja ba ajte mỳjja pumũnh kêt kwỳ nhipê:x ga omũ. Mỳjja raxo kute ajbir ije amã arẽnhja jakrenh mex dja ga omũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ne kam ajte kum, —Ba ije amijo inhĩ dja ĩ ijã kàjkwa abenbê ajkij nhym Metĩndjwỳnh kadjy mrãnh djwỳnh arỳm ikurũm wabin ijã axidjuw gar arỳm omũ. Mrãmri ne ba ar amã ja jarẽnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nhym akatin akatin akati nhym onĩj Garrêjakam krĩraxbê Kanakam me'õ myja me'õ nire'ỳr mõrmã. Nhym me me kukràdjà kôt arỳm ar'ã akuprõn kute abenã ar mẽnhmã o dja. Nhym Jeju nã me kôt kam ar ba. ");
INSERT INTO txuNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nhym me Jejumẽ kôt ba djwỳnh arkum krà nhym ar arỳm me'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Me'ỳr bôx nhym uba kangô arỳm mebê apêx. Nhym nãja Jejumã kum, —Uba kangô ne arỳm mebê apêx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nhym kum, —Adjỹm me'õ nire. Djãm arỳm idjàpênh'ã myt bôx got ga imã arẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nhym kam nã kikrekam me õ àpênhmã kum, —Gêdja ar amã arẽ gar kabẽn kôt apê. Nãm ã nã arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nhym kam kẽno ngônhbê 6 ne ku'ê. Me kute amiku'õnh djà kadjy ne ngônhja. Mebê idjaer kute Metĩndjwỳnhmã amiku'õnh djà kadjy. Ngônh kre rũnh kute ngônhti pyràk. Kẽno ngônh pydji kre'ã akrekam ne kute ngônhkrõkrõkti ipuo amãnhkrut ne amãnhkrut pyràk. ");
INSERT INTO txuNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nã me àpênh djwỳnhmã kabẽn nhym kam Jeju arkum, “Ar ngôo ipu”, ane. Nhym kam ar ngô runho tẽn o ipu mex ne. ");
INSERT INTO txuNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nhym arkum, —Ar kwỳ run memã ỹr djwỳnhmã o tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nhym arỳm ar kwỳ run memã ỹr djwỳnhmã o tẽ nhym arỳm kakin amim, —Je tô, nhỹnh ne uba kangôja? ane. Ne kam amiwỳr me'õ my kute ni'ỳr mõrja 'uw nhym 'ỳr bôx nhym kum, ");
INSERT INTO txuNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—E kum, uba kangô mexkumrẽx ne ga o apdjun ajbir o akato. Djãm me kute ã o anhỹr got? Kati. Me kute abenã me rẽnhkam ne me kute memã kangô djànhkumrẽxja kumrẽxo apôx. Ne me kute o kõm kumexkambit kute memã kàjbê kangô djànho apôx. Be, ga ne ga atemã ne ajbir kangô djànhkumrẽx jao akato, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Be, me kute raxmã kator kadjy mỳjja pumũnh kêt nhipêx krax ne ja. Garrêjakam krĩraxbê Kanakam ne ngô kajgoo uba kangô nhipêx ne o memã amiraxo amirĩt. Nhym kam kôt ba djwỳnh ar kute omũnhkam tu amim markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nhym kam Jeju krĩraxbê Kapana'ỳr rwỳk tẽ. Nãmẽ kamymẽ kôt ba djwỳnhmẽ ne ar kôt mõ. Ar 'ỳr rwỳk mõ:n arỳm 'ỳr bôx. Ne Kapanakam ar ba: nhym ar'ã akati ngrêrebit apêx. Nhym kam ar ajte mõ. ");
INSERT INTO txuNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Djeruxarẽkam mebê idjaer kute aben pydji 'ỳr. Me kute aben kajmã'ã Metĩndjwỳnh me bê idjaer kukãmãre nhirôbê mrãnhja mar kadjy ne me aben pydji 'ỳr. Nhym Jeju arỳm mekôt 'ỳr tẽ. 'Ỳr tẽ:n kam arỳm 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ne kam Metĩndjwỳnh nhõ kikretimã wadjà. Nhym me kumex. Me kute pi'ôk kaprĩ pãnh memã mry nhõr djwỳnh kumex. Mry bàri, mrykĩ'ãtomti, tut nhõr djwỳnh kumex. Nhym me kute me õ pi'ôk kaprĩ pãnh memã kikreti nhõ pi'ôk kaprĩja nhõr kadjy me kumex. Nhym arỳm me omũ. ");
INSERT INTO txuNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ne kam me kadjy arỳm djudjêdjêo me kaprêprêk djà nhipêx ne arỳm me aêro tẽn bõm me kurẽ. Nãm me kunĩmẽ me õ mrykĩ'ãtomtimẽ me õ mry bàri jano. Nãm me kute me õ pi'ôk kaprĩ pãnh memã kikreti nhõ pi'ôk kaprĩ nhõr djwỳnhjabê pi'ôk kaprĩ ngràn mebê pĩponh ikjêo rẽnho tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne tut nhõr djwỳnhmã kum, —Mũm me mỳjjao akato. Djãm Ibãm nhõ kikreo bikẽnh got ga me kikre kreo àpnu? Kwãrĩk wãnh Ibãm nhõ kikrekam mỳjja pãnh abenmã pi'ôk kaprĩ nhõr kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nhym kôt ba djwỳnh omũn arỳm pi'ôkkam Metĩndjwỳnh kabẽn ma. Amrẽbê: Kra kute Bãmmã kum, “Dja ba anhõ kikre'ã ino tỳx nhym me arỳm ibĩ”, anhỹr ja ne ar arỳm kuma. ");
INSERT INTO txuNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nhym kam mebê idjaer rũnh Jejumã kum, —Goja on mỳjja pumũnh kêt'õ nhipêx bar omũ. Ne kam arỳm abẽnjadjwỳr rax ma. Aje mỳj me'õ kabẽnkôt kikretikam me anoro abaja ma, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nhym memã kum, —Ã. Dja ba ĩ me amã mỳjja pumũnh kêt'õ nhipêx. Dja me Metĩndjwỳnh nhõ kikretija ngrà ba kam akubyn ipêx. Ije ipêxo idjãm'ã gêdja akati amãnhkrut ne ikjêkêt apêx ba arỳm ipêx pa, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nhym me kum, —Tô nhỹnh? Djãm kikre ja nhipêx'ã akati amãnhkrut ne ikjêkêt apêx got? Kati. Be, me kute kikreti ja nhipêxo ku'ê'ã amex krãptĩ:bê 46 apêx nhym me arỳm ipêx pa, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Be, djãm Metĩndjwỳnh nhõ kikreti wã'ã ne memã kabẽn jarẽ? Kati. Aminhĩ'ã ne Metĩndjwỳnh nhõ kikreti jakren memã arẽ. Be, Jeju nhĩ kute mrãmri ne Metĩndjwỳnh nhõ kikre pyràk. Dja ty nhym me adjà. ");
INSERT INTO txuNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nhym kam arỳm akubyn tĩn. Nhym kôt ba djwỳnh akubyn tĩnkôt omũn akubyn amijo tẽn arỳm Jeju kabẽn ja ma. Kute aminhĩ'ã kikreti jakreja man amim, —Be, mrãmri ne Metĩndjwỳnh amrẽbê: pi'ôkkam Jeju kônh kabẽn dji. Mrãmri ne Jeju kabẽnkumrẽx, ane. Dja kôt ba djwỳnh ar kikreti'ã kabẽn man ã amim ane. ");
INSERT INTO txuNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Me krãptĩ kute aben pydji djà nhõ akatikam ne Jeju Djeruxarẽkam ar ba. Me kute aben kajmã'ã Metĩndjwỳnh me bê idjaer kukãmãre nhirôbê mrãnhja mar kadjy ne me aben pydji. Nhym Jeju mekam ar ban arỳm mỳjja pumũnh kêt kwỳ nhipê:x. Nãm me punu krãptĩ:o mex nhym me arỳm omũ. Me krãptĩ ne me omũn arỳm amim, —Be, mrãmri ne Jejubê Metĩndjwỳnh Krakumrẽx. Mrãmri kubê me banhõ Bẽnjadjwỳrbê kumkatibê Kritukumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nhym Jeju arỳm me kabẽn man amim, —Be, djãm mrãmri me krãptĩja kute tu amim imarkumrẽx got, ba on meo iba? Kati. Me krãptĩ kabẽn kajgo, ane. Be, djãm Jeju kute me mar kêt got? Nãm kute me kunĩ mar. ");
INSERT INTO txuNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Djãm kute me'õmã, “Mỳj ne me kuma”? anhỹr prãm got? Kati. Kute prĩne me õkre kadjwỳnhbê me kabẽn mar. Kute me kwỳ kabẽn kajgo mar. ");
INSERT INTO txuNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Be, me'õ, idjibê Nikodemu. Kubê pardjêu'õ. Me rũnhmẽ ro'ã ne mebê idjaer kunĩmã nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Akamàtkam ne Jeju'ỳr tẽn 'ỳr bôx ne kum, —Ujarẽnh djwỳnh, mrãmri ne Metĩndjwỳnh ajano. Aje memã kukràdjà'ã adjujarẽnh kadjy ajano ga bôx. Arỳm ba me ije amar. Ga ne ga aje mỳjja pumũnh kêt kwỳ nhipê:x, me punu krãptĩ:o mex. Kam ne ba me arỳm kôt ije amar. Djãm me'õ kajgo kute ã meo anhỹrmã got? Kati. Be, Metĩndjwỳnh amẽ amijo kajkep. Kam ne ga ã meo ane. Nãm ã Nikodemu Jejumã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nhym kum, —Ẽ, djãm aje Metĩndjwỳnh rax ne kute meo bajamã akator ne aje marmã ne ga tẽ? Be, ga ne ga te aje kum akatormã. Adjumar djà nykambit. Adjumar djà ny kute me prĩre bixadjwỳr nykam umar djà ny pyràk. Kambit dja ga kum akaton ama. Mrãmri ne ba amã ja jarẽnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nhym kum, —Je, mỳj dja ba idjumar djà ny kadjy on? Djãm arỳm ijabatànhkam ije inã tikkremã idjàr ne ajte ikator got ba idjumar djà nymã? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nhym kum, —Djãm ja ne ba amã arẽ? Kati. Dja me amim Metĩndjwỳnh kabẽn ma. Metĩndjwỳnh kabẽn ne kute ngô pyràk. Dja me amim kabẽn ma nhym Karõ arỳm memã amak bô nhym me arỳm umar djà ny kute me prĩre bixadjwỳr nykam umar djà ny pyràk. Nhym kam Metĩndjwỳnh arỳm amim me utàn ar meo ba. Mrãmri ne ba amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Djãm me my kute memã kra jadjwỳr nhym me bixadjwỳrkam Metĩndjwỳnh kôt umar? Kati. Me kôt umar kêtkumrẽx. Nhym be, Metĩndjwỳnh Karõ kute meo ny kôt ne me mrãmri umar djà nykumrẽx ne arỳm kôt umar. ");
INSERT INTO txuNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ba amã, “Dja ga adjumar djà ny kute mrãmri ne me prĩre bixadjwỳr nykam umar djà ny pyràk”, ane. Ije amã anhỹrkam kwãrĩk wãnh te aje marmã ikam ano tyk ne anhỹr kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Be, ga, kôkreja pumũ. Djãm ga aje àbêrja kraxkôt omũnh ne nhĩ'ãm prõtkôt aje omũnh? Kati. Metĩndjwỳnh Karõdjwỳ djãm aje omũnh? Kati. Kute memã umar djà ny jangjênhdjwỳ djãm aje kôt omũnh? Kati. Aje kôt omũnh ne mar kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nhym Nikodemu kum, —Kon. Bir, mỳj dja kute memã umar djà ny jangjênh on? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nhym kum, —Be, ga ne ga mebê idjaerkam me kukràdjà'ã adjujarẽnh djwỳnh ne ren aje ikabẽn mar. Nhym be, kati. Aje imar kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mrãmri amrẽbê ar ije mỳjja mar ne omũnhkumrẽx. Ne kam arỳm me amã arẽ ga me kam aje amim ar imar kêt rã'ã. ");
INSERT INTO txuNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Pykakam me kukràdjà kôt ba arỳm amã ikabẽn jarẽ ga aje amim imar kêt. Ne ba ren kàjkwakam ikukràdjà kôt amã ikabẽn jarẽ. Djãm kam ga ren tu amim imarkumrẽx? Kati. Ga ren kamdjwỳ aje amim imar kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Be, nhỹnh ne me'õ kute kàjkwakam kukràdjà marmã 'ỳr wabin 'ỳr bôx? Ne kuman akubyn ruwn arỳm memã arẽ. Kati. Pykakam me'õ kute kadjy àbir kêtkumrẽx. Ba ije amijo inhĩbit ne ba arỳm kàjkwa kurũm ruw. Ba ne ba kam inhỹr tũm. Ne kam arỳm me amã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Be, me bakukãmãre Môjdjê kapôt kukritkam kryto kangã karõ nhipêx. Ipêx ne pĩ'ã kunhôn arỳm kàjmã kudja. Kudja nhym kangã karõ kỳjrũm pĩ'ã wajêt. Badjwỳ, ije amijo inhĩdjwỳ, dja me pĩ'ã inhô ba arỳm kỳjrũm ã ijêto ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mỳj kadjy dja ba kỳjrũm wajêt? Bir, dja me kwỳ ĩ pỹnhkôt tu amim imarkumrẽx ne arỳm Metĩndjwỳnh kôt tĩn ne ar ba rã'ã: rã'ã ne. Ja kadjy dja ba kỳjrũm wajêt. Nãm ã Jeju Nikodemumã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Metĩndjwỳnh ne kum pykakam me kunĩ jabê:. Mỳj ne kum me abê on? Bir, nãm me kadjy Kra djwỳnh jano. Kra pydji jano nhym arỳm pykamã bôx ne me kadjy ty. Mỳj kadjy ne ty? Bir, dja me kwỳ ĩ pỹnhkôt tu amim Kra markumrẽx nhym arỳm me utà. Dja me biknor tokry djàkam me biknorbê me utà nhym kam me Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. Ja kadjy ne ty. Nãm ã Metĩndjwỳnh kum me kunĩ jabêo ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mỳj kadjy ne Metĩndjwỳnh pykamã Kra jano? Djãm kute memã axwe pãnh jarẽnh nhym me me biknor tokry djàkam biknor kadjy? Kati. Kute kubê me kunĩ pytàrmã ne ano. ");
INSERT INTO txuNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Be, me kute arỳm tu amim Kra markumrẽxja Metĩndjwỳnh kute memã axwe pãnh jarẽnh kêtkumrẽx nhym me biknor kadjy kêtkumrẽx. Nhym be, me kute amim mar prãm kêtjamã ne arỳm kute memã axwe pãnh jarẽnhkumrẽx. Arỳm kute me'ã amim, —Tãmwã dja axwe pãnh me biknor tokry djàkam akuno, anhỹrkumrẽx. Mỳkam? Bir, Metĩndjwỳnh Kra djwỳnh me kute amim mar prãm kêtkam dja me arỳm akuno. ");
INSERT INTO txuNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mỳj ne Metĩndjwỳnh amim arẽn kam arỳm memã me biknor tokry djàkam biknor jarẽ? Bir, nãm amim, —Ba arỳm pykakam memã Jeju jano nhym bôx. Jeju ne kute memã pry kurwỳ djà pyràk. Jejukôt me katàt amijo ban tĩnkumrẽx. Nã bãm memã ano nhym me kum kĩnh kêt. Ga, akamàt kô tykkam me kute mỳjja pumũnh kêt ne ba punuja pumũ. Me jadjwỳ ne me kum arĩk ar baja kĩnh. Mỳkam? Bir, me axwe'ã maje kum katàt amijo ba kĩnh kêt. Nãm ã me'ã amim ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ga, me kunĩ arĩk ar baja kum Jeju kurê ja pumũ. Jeju kute memã pry kurwỳ djà pyràk me kum kurê. Djãm me kute amim Jeju mar ne kôt kute amijo ba prãm? Kati. Ren me amim Jeju ma nhym ren arỳm memã apỹnh axwe jarẽ. Axwe pãnh kute memã bẽn tỳx pymaje ne me kute amim mar prãm kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nhym be, me katàt kute amijo baja ne me kute Jeju kôt amijo ba prãm. Jeju kute memã pry kurwỳ djà pyràk ja ne me kute kôt amijo ba prãm. Mỳj kadjy? Bir, dja me kôt ar amijo ba nhym me arỳm omũ. Kôt me ukaprĩja pumũ. Metĩndjwỳnh djukaprĩ kôt me ukaprĩ dja memã amirĩtkumrẽx nhym me arỳm omũ. Ja kadjy ne me kute Jeju kôt amijo ba prãm. ");
INSERT INTO txuNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jeju Nikodemumã kabẽn pan kam kôt ba djwỳnhmẽ arỳm ar tẽ. Tẽ:n kam arỳm pykabê Djudêjakam bôx. Bôx ne arek ar kam ba. Metĩndjwỳnhmã ngômã me angjênho ba. ");
INSERT INTO txuNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nhym Djuãodjwỳ amũ ngômã me angjênho ba. Amũ krĩraxbê Xarĩ kuri pykabê Inõkam ne ngômã me angjênho ba. Kam ngô kumexkam ne meo ba. Nhym me 'ỳr bôxo ku'ê nhym ngômã me angjênho ku'ê. ");
INSERT INTO txuNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Me kute Djuãobê ijê kêtri ne meo ku'ê. ");
INSERT INTO txuNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nhym kam Djuãokôt ba djwỳnhmẽ mebê idjaermẽ ar arỳm aktã kabẽno aben japanho dja. Nãm ar abenmã kum, —Mỳj godja me ngôo me on nhym Metĩndjwỳnh memã mex jarẽ? anen ");
INSERT INTO txuNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","arỳm Djuão'ỳr tẽn 'ỳr bôx ne Jeju'ã kum, —Ẽ, ujarẽnh djwỳnh, aje ngôbê Djodão nhijukri me'õmẽ ro'ã aban aje 'ã adjujarẽnh ar aba. Be, adjwỳnhdjwỳ arỳm ngômã me angjênho ba nhym me kunĩ arỳm mũm abê tẽn 'ã kume:x, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nhym Djuão memã kum, —Kwãrĩk wãnh rã'ã. Metĩndjwỳnh kute me'ã kum karõja ne me arỳm mũm 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ba arỳm me amã amijarẽ ga me ikabẽn ma. Ba me amã, “Djãm ibê me banhõ Bẽnjadjwỳrbê kumkati got? Djãm ibê Kritu got? Kati. Kukãm ne Metĩndjwỳnh ijano ba tẽ”, ane. Ba arỳm me amã ja jarẽ ga me arỳm ama. ");
INSERT INTO txuNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Djãm me wã ne inhõ me? Kati. Me wã ne Jeju nhõ me. Ga, me mjênbit kute prõo baja pumũ. Jeju kute prõo ba mãn pràbê me wão ba. Jejubit ne me wão aminhõn meo ba. Ba ne inhõ me kêt. Be, ba ne ba amybỳm kam ikĩnhkumrẽx. Ga, me mjên prõ'ỳr baja pumũ. Nhym amybỳm mjên nhõbikwa kajgo arỳm mjên kabẽn ma. Kabẽn man kam arỳm kĩnhkumrẽx ne. Jeju'ã me krãptĩkam ne ba arỳm ã ikĩnho ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mrãmri dja raxo amũ ijakrenho tẽ. Nãm ã Djuão memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kàjkwa kurũm rwỳkja ne raxo kute me kunĩ jakrenh. Nhym be, pykabê me bixadjwỳrja ne me pykabê ar ba. Pykabê ar ban pykabê mỳjjabit jarẽ. Nhym be, kàjkwa kurũm rwỳkja raxo kute me kunĩ jakrenh. ");
INSERT INTO txuNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kute kàjkwakam mỳjja pumũnh ne mar ne memã 'ã amijarẽnho ba. Nhym me krãptĩ: kute amim kabẽn mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nhym be, me kwỳ kute amim, —Mrãmri ne Jeju kabẽn katàtkumrẽx, anhỹrkam djãm Jejubit ne me amim kuma? Kati. Kàjkwakam Metĩndjwỳnhdjwỳ ne me amim kuma. Nãm me amim, —Mrãmri ne Metĩndjwỳnh kabẽn katàtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Metĩndjwỳnh kute anorkam ne Kra arỳm Metĩndjwỳnh kukwakam kabẽn jarẽnho ba. Kute kubê Karõ nê kêtkumrẽx nhym kute 'amỳnh tỳx ne o ba. ");
INSERT INTO txuNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kàjkwakam Bãm kum Kra jabê. Ne kam arỳm Kramã õ mỳjja'ã kum karõn kam kum kunĩ kanga nhym ar o ba. ");
INSERT INTO txuNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kra Bãm nhõ mỳjja kunĩo ba nhym kam me kute tu amim Kra markumrẽxja arỳm Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. Nhym be, me kute amim Kra mar kêtja dja me tĩnkumrẽx'ỳr bôx kêtkumrẽx. Metĩndjwỳnh dja mekam ngryk rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Nhym kam Bẽnjadjwỳr djwỳnh Jeju arỳm pykabê Djudêja kurũm tẽ. Mỳkam ne tẽ? Bir, arỳm kute õ me jao Djuão jakrenhkam. Jeju amikôt me kamẽn ngômã me angij nhym me arỳm kume:x. Nhym mebê pardjêu arỳm me kumex jarẽnh ma. Nhym kam arỳm amim, —Be, me arỳm kute ijã me kumex jarẽnh mar. Ba on, ane. Ne kam arỳm mebê tẽ. Djãm Jeju ta ne ngômã me angjênho ba? Kati. Kôt ba djwỳnh ne ar ngômã me angjênho ba. Nãm Jeju Djudêja kurũm tẽn kam ajte pykabê Garrêja'ỳr tẽmmã. ");
INSERT INTO txuNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ne kam arỳm tu Garrêja'ỳr pykabê Xamarijkôt tẽm prãm. ");
INSERT INTO txuNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nãm Xamarijkôt tẽ:n kam arỳm krĩrax'õ'ỳr bôx. Idjibê ne Xika. Kuri ne Jôdje nhõ pyka. Amrẽbê: me bakukãmãre Djako kra Jôdjemã pyka kwỳ tan kum kungã. ");
INSERT INTO txuNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Õ pykakam ne Djako nhõ ngômkwati. Nãm Jeju krĩrax'ỳr bôx ne arỳm pykakôt tẽm kurêje katy. Ne kam tẽn arỳm ngômkwati jakà'ã nhỹ. Arỳm kàjkwa nhipôkri myt nhỹrkam ne 'ã nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nhỹ: nhym nĩnh Xamarijkam me'õ nire arỳm 'ỳr tẽ. Kute kam ngô kwỳ jadjàrmã ne 'ỳr tẽn 'ỳr bôx. Nhym kam kum, “Ba ikõ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Be, arỳm kôt ba djwỳnh mã krĩraxmã mõrkam. Kute ar õ kwỳ krẽn djà byrmã ne ar tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nãm kum, “Ba ikõ”, ane. Nhym kum, —E 'õ. Mỳkam ne ga me ajõbê idjaerkam ngô'ã ijuw? Ba ibê pykabê Xamarijkam me'õ nire ne ga ngô'ã ijuw, ane. Be, mebê idjaer ne me kum mebê Xamarij kĩnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nãm nireja ã kum ane nhym Jeju kum, —Ga aje Metĩndjwỳnh kute meo kĩnh djà mar kêt ne ba ije ngô'ã ajwỳr djwỳnh aje imar kêt. Ne ga ren iman ren ba ngô'ã ijuw ba ren amã me tĩnkumrẽx kadjy ngô ren amã kungã, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nhym kum, —Ô kum bẽnjadjwỳr, anhõ ngôo àbir djà kêt nhym ngômkwati kre ry:. Nhỹnh ne me tĩnkumrẽx kadjy anhõ ngôja? ");
INSERT INTO txuNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Me banhingêt kukãmãre Djako kukwakam ne ngômkwatija. Ta ne kute kam o kõmo ku'ê nhym kramẽ õ mrymẽ kute kam o kõmo ku'ê. Djãm araxo aje me banhingêt Djako jakrenh? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nhym kum, —Gêdja me ngô kajgo jao ikõn akubyn kum kôr. ");
INSERT INTO txuNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nhym be, ba ije amã ngô jarẽnhja gêdja me kwỳ ĩ pỹnhkôt o ikõn akubyn kum kôr kêtkumrẽx. Ije amã ngô jarẽnh ja gêdja me o ikõ nhym mã mekam apôx kute mrãmri ne ngômkwatikam ngô mã apôx pyràk. Nhym kam me arỳm Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nhym kam kum, —Bẽnjadjwỳr goja amrẽ imã aje ngô jarẽnhwã ngã ba o ikõn goja imã kôr kêt ne amrẽ ngôo imrãnh kêt, ane. Djãm ngôkumrẽx'ã ne kute kum me tĩnkumrẽx kadjy ngô 'ã ajarẽ? Kati. Metĩndjwỳnh Karõ'ã ne ngô jakren kum 'ã ajarẽ. Nãm ã nire ngô'ã Jeju 'wỳro ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nhym kum, —Tẽn amjênmã arẽ gê amrẽ tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nhym kum, “Imjên kêt”, ane. Nhym kum, —Nà. Mrãmri amjênkumrẽx kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Amrẽbê ne aben totokmã amjên amãnhkrut ne amãnhkrut ne ikjêkêt ga kanga. Ne kam ajbir awỳr bao ku'êja ne kubê amjên kêt. 'Ã ne aje mrãmri imã, “Imjên kêt”, anhỹrja. ");
INSERT INTO txuNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nhym kum, —Bẽnjadjwỳr, ga abê Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh'õ ba arỳm ama. ");
INSERT INTO txuNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Krãnh wã'ã ne me ikukãmãre kute Metĩndjwỳnhmã rax jarẽnh djà. Nhym me abê idjaer ne ga me atemã ne aje memã kum, —Krĩraxbê Djeruxarẽkambit ne me kute Metĩndjwỳnhmã amijarẽnh djà, anhỹro aba, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nhym Jeju kum, —Djãm me aje krãnh wã'ã me Bãm djwỳnhmã rax jarẽnh rã'ãmã? Nàr djãm me aje Djeruxarẽkam kum amijarẽnh rã'ãmã? Kati. Gêdja ga me ĩ kam kum amijarẽnh kêt. Kam kum amijarẽnh kêt'ã ne amrẽ akati mõr rã'ã. Mrãmri ne ba ije amã arẽnhkumrẽx. Dja ga tu amim ikabẽnja markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Me abê pykabê Xamarijkam me kra ne ga me aje we apytàr djwỳnhja, aje kum rax jarẽnhja aje mar kêt. Nhym be, me ibê idjaerkam ne ba me ije Metĩndjwỳnhmã amijarẽnhja arỳm ije mar. Ije me utàr djwỳnhkumrẽx mar. Me ibê idjaerkam ne me utàr djwỳnh kato. Kam ne ba me ije mar. ");
INSERT INTO txuNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Me kute markumrẽx dja me ĩ me Bãm djwỳnhmã rax jarẽnhkumrẽx ne 'êx kêtkumrẽx. Me kadjwỳnhbê Metĩndjwỳnh Karõ kôt dja me mrãmri amijo ngriren raxmã katorkumrẽx ne kum rax jarẽnhkumrẽx. 'Ã akati amrẽ mõr rã'ãn arỳm bôx 'ỳr. Me Bãm djwỳnh kum me ja kĩnh. ");
INSERT INTO txuNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Djãm kàjkwakam Metĩndjwỳnh kute me bapyràk? Djãm ĩmẽ 'imẽ kute me bapyràk? Kati. Karõbit. Nhym me kute omũnh kêtkumrẽx. Me kute omũnh kêtkam dja me tu amikadjwỳnhbê karõ kôt mrãmri amijo ngriren raxmã katorkumrẽx. Kum katorkumrẽx ne kum rax jarẽnhkumrẽx. Nãm Jeju ã me'õ niremã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jejubê ne Bẽnjadjwỳrbê kumkatibê Kritu nhym kute mar kêt. Kritu nhidji 'õdjwỳbê ne Mexij. Me'õ nire kute mar kêt ne kum, —Tukwa, gêdja Mexij bôx ne me imã mỳjja kunĩ jarẽ ba me kuma. Ja ne ba arỳm ije mar, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nhym kum, —E kum, ba ne ba arỳm amã ikabẽno nhỹ. Ibê ne Mexij, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nãm nirejamã ja jarẽnho nhỹ nhym kôt ba djwỳnh arỳm 'ỳr bôx ne ar omũ. Jeju kute kum kabẽno ỹrkôt arỳm ar omũ. Ne te kute ar marmã arkam no tyn dja. Ne bit kute nija'ã kukjêr ne kute kum, —Mỳj ne ga kum arẽnho nhỹ? Mỳkam ne ga kum akabẽno nhỹ? anhỹrmã ne arkum uman arek ku'ê. ");
INSERT INTO txuNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nãm kôt ba djwỳnh Jeju'ỳr bôx nhym nire arỳm õ ngyo ngônhmã iren mã: krĩraxbê Xikamã tẽn wadjà. Ne kam memã kum, ");
INSERT INTO txuNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Ô kum onĩj me'õ. Ije amijo ibaja kunĩkôt ipumũn imã arẽ. Bãrãm mrãmri kubê me banhõ Bẽnjadjwỳrbê kumkatibê Kritukumrẽx. Gwaj 'ỳr gar omũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nhym me arỳm krĩrax kurũm katon 'ỳr tẽn arỳm 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Me 'ỳr bôx kêtri ne kôt ba djwỳnh arỳm kum, —Ujarẽnh djwỳnh, gop anhõ kwỳ krẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nhym arkum, —Be, atemã inhõ kwỳ krẽn djàja ar aje mar kêt, ane. Be, djãm mrãmri õ kwỳ krẽn'ã ne arkum ane? Kati. Nãm Metĩndjwỳnhmã àpênho õ kwỳ krẽn djà. Metĩndjwỳnhmã àpênh ar ba'ã ne arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nãm arkum ane nhym ar arỳm abenmã kum, —Djã ne me'õ arỳm kum mỳjja'õ ngã nhym kukrẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nhym arkum, —Be, kàjkwakam Metĩndjwỳnh kute amrẽ pykamã ijanor arỳm ijã amim karõ. Kute idjàpênh djà'ã amim karõ kôt dja ba amijo iban arỳm inomã kumẽ. Be, idjàpênh jakam ikĩnho inhõ kwỳ krẽnkam ikĩnh jakrenh mex ne. 'Ã ne ba ije ar amã, “Atemã inhõ kwỳ krẽn djà”, anhỹrja. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ne kam ajte arkum, —Kwãrĩk wãnh gar amim, “Dja bàygogo'ã mytyrwỳ amãnhkrut ne amãnhkrut apêx bar kam êo mõ”, anhỹr kêt. Be, ba ne ba ar amã, “Ar kàjmã akrãn me kute ikabẽn mar prãmja pumũ. Me krãptĩ kute bàygogo pyràk wã pumũ. Dja gar memã ijã ajarẽ nhym me arỳm tu amim imarkumrẽx. Ja kadjy ne me mexkumrẽx. Me mexkumrẽx kute mrãmri ne bàygogo prỳ ngràn akakam ê kadjy mexja pyràk. ");
INSERT INTO txuNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Dja gar on jakam memã arẽ nhym me amim ima ba arỳm ar amã o pãnh. Nhym kam me ikôt tĩn ne ar ba rã'ã: rã'ã ne. Ba ar amã o pãnh gar arỳm akĩnh rã'ã: rã'ã ne. Djãm ar gajbit dja gar akĩnh? Kati. Me kute amrẽbê memã arẽnhdjwỳ dja me ar aro'ã kĩnh. Ga, me kumrẽx kute bàygogo kre nhym ate me ja kute tũmràm bàygogo djêja pumũ. Me kute ê parkam me ro'ã kĩnhkumrẽx. Inhõ àpênh tũmmẽ dja gar aro'ã akĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Be, me memã kum, ‘Gêdja me'õ 'y kre nhym me'õ arỳm ê’, anhỹro ba. Be, ikabẽnja kônh ne me kabẽn ja dji. ");
INSERT INTO txuNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ar aje o atom ne êmã ne ba 'ỳr ar ajano. Amrẽbê ne gar bàygogokam adjàpênh kêt. Me'õ kumrẽx ne arỳm kam apên kam 'y krebito ba. Gar inhõ me àpênh tũm kôt ajbir adjàpênh 'amỳ”, ane. Ar kute memã 'ã ujarẽnhmã nhym me kute tu amim markumrẽxmã ne Jeju ã kôt ba djwỳnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nãm me'õ nire krĩraxbê Xikakam Xamarij kramã kum, —Nãm prĩne ije amijo iba kunĩkôt imã arẽnh mex, anhỹro tẽ. Nhym me krãptĩ kuman arỳm tu amim Jeju markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ne kam Jeju'ỳr tẽn 'ỳr bôx ne kum, —Gop arek me iro'ã ar aba, ane. Nhym arỳm arek mekam ar ba. Ar ba nhym arỳm 'ã akati amãnhkrut apêx. ");
INSERT INTO txuNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nhym kam me kute Jeju ta kabẽn markam ne krãptĩ tu amim markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ne kam nijamã kum, —Jakam bar tu amim Jeju markumrẽx. Djã ne bar akabẽnbit man amim tu markumrẽx? Kati. Arỳm ne bar Jeju ta kabẽn kôt amim kuman amim, “Be, mrãmri ne Jejubê Bẽnjadjwỳrbê kumkatibê Kritukumrẽx. Mrãmri kubê pykakam me axwe kunĩ pytàr djwỳnhkumrẽx.” Nã bãm ar ã amim ane. Nãm me ã nire jamã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Be, Jeju'ã akati amãnhkrut apêx nhym arỳm amũ ajte tẽ. Tẽn arỳm abatành djà, õ pykabê Garrêjakam bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jeju ta ne amrẽbê memã kum, —Djãm Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh'õ ne abatành djàkam bôx nhym me kum rax jarẽnh got? Kati. Nãm me aprỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jeju abatành djàbê Garrêja jakam bôx. Nhym kam me kum kabẽn mex jarẽ. Me kute amrẽbê amũ Djeruxarẽkam Jeju pumũnhkam ne me kum kabẽn mex jarẽ. Me krãptĩ kute amikukràdjà tũm mar kadjy aben pydji djà nhõ akatikam ne me Djeruxarẽ'ỳr tẽn 'ỳr bôx. 'Ỳr bôx ne arỳm kam mekôt Jeju pumũ. Nhym mỳjja pumũnh kêt krãptĩ nhipêx nhym me arỳm omũ. Omũn kam akubyn Garrêjakam bôx. Nhym Jejudjwỳ kam bôx ne me'ỳr bôx. Nhym me kam kum kabẽn mex jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jeju Garrêjakam bôx ne ajte krĩraxbê Kanakam bôx. Kam ne amrẽbê kute ngô kajgoo uba kangô nhipêx. Jeju bôx nhym onĩj Kapanakam me'õ bẽnjadjwỳr kra arỳm kanê. ");
INSERT INTO txuNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nhym me arỳm bẽnjadjwỳrmã arẽn kum, —Onĩj, Jeju arỳm Djudêja kurũm katon Garrêjakam bôx, ane. Nhym kuman arỳm Kana'ỳr tẽn kam Jeju'ỳr bôx. 'Ỳr bôx ne kum, —Ẽ, gu 'ỳr ga imã ikrao mex gê kanê kum ire, ane. Nãm mã 'ỳr kum krà. Arỳm kra tyk 'ỳrkam ne mã 'ỳr kum krà. ");
INSERT INTO txuNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nhym Jeju kum, —Ga me aje amim imar kêtkumrẽx. Ije mỳjja pumũnh kêt nhipêx ga me aje omũnhkambit ne amim ima. Mỳkam? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nhym bẽnjadjwỳr Jejumã kum, —Bẽnjadjwỳr, amibêx, tyk kêtri gu 'ỳr tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nhym kum, —Aj mã. Arỳm ne akra tĩn ne, ane. Nhym arỳm tu amim kabẽn markumrẽx ne arỳm 'ỳr tẽ. Amim kamnhĩxo tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tẽ: nhym kam arỳm 'ã akamàt. Nhym akati nhym ajte tẽ: nhym õ àpênh ar arỳm kutã tẽn kajpa. Ne kum, “Arỳm ne akra tĩn ne”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nhym arkum, —Nhỹnh ne myt nhỹ nhym mexmo krax ne? ane. Nhym kum, —Amũja'ã myt akẽxkam ne arỳm kanê kum ire, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nhym amim, —Be, Jeju kute imã, “Arỳm ne akra tĩn”, anhỹr majmã ne arỳm kanê kum ire, ane. Ne arỳm tu amim Jeju markumrẽx. Õ kikrekam ar kunĩdjwỳ tu amim markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jeju Djudêja kurũm tẽn Garrêjakam bôxkam ne ajte mỳjja pumũnh kêt ja nhipêx. Me kute raxmã kator kadjy ne arỳm bẽnjadjwỳr krao mex. ");
INSERT INTO txuNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jeju bẽnjadjwỳr krao mex. Nhym kam onĩj krĩraxbê Djeruxarẽkam arỳm mebê idjaer kute aben pydji djà nhõ akati 'ỳr. Nhym Jeju arỳm 'ỳr tẽ. 'Ỳr tẽn kam arỳm 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Be, Djeruxarẽkam ne ngô'õ nõ. Me kute krĩraxmã mrykĩ'ãtomtio ngjêx djà kuri ne ngô'õ nõ. Mebê idjaer kabẽnkam ne me ngômã Bexeda jarẽ. Ngô bu'ã ne kikre kre kênh amãnhkrut ne amãnhkrut ne ikjêkêt. ");
INSERT INTO txuNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kikrekam ne me punu krãptĩ ikwã. Me no rãmẽ me mrãnh punumẽ me akrymẽ ikwã. Ngô kute amingrẽk ne me kam amako ikwã. ");
INSERT INTO txuNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mỳjkôt ne ngô amingrẽk? Bir, Metĩndjwỳnh kadjy mrãnh djwỳnh ne ngô'ỳr ban me aêrbê ngômã wangij, ngômã ngjêx pỹnh. Nhym arỳm kôt ngô amingrẽk ne. Amingrẽk nhym me'õ punu kumrẽx kute memã wan noxja ne arỳm mex ne. Pydjibit mex. ");
INSERT INTO txuNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Be, Jeju Djeruxarẽ'ỳr bôx ne ngô ja'ỳr bôx. Nhym me'õja me punu kôt nõ. Punu'ã ne amex krãptĩ:bê 38 apêx. ");
INSERT INTO txuNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nhym arỳm omũn amim, —Be, amrẽbê ne me'õwã punu, ane. Ne kam kum, “Djãm amã amex prãm”? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nhym punuja kum, —Be, ngô kute amingrẽkkam djãm inhõbikwa'õ got ijo tẽn ngômã imẽ ba on imex ne? Kati. Nã bãm te ngô'ỳr amibêx ne nhym arỳm me'õ imã wan nox ne. Ba kam imex prãm kêt ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nhym kum, —Be, kàjmã djan anhikwã djà krãn amỳn o tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nhym arỳm kabẽnmẽ ro'ã mex ne ikwã djà krãn kumỳn o tẽ. Pi'ôk ràràrkam, me tyk djà kêt djà nhõ akatikam ne mex ne. ");
INSERT INTO txuNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nhym mebê idjaer rũnh omũn kum kabẽn ne kum, —E kum pi'ôk ràràr ne ja. Djãm aje kam kukràdjà mar kêt ne ate anhikwã djà mỳn o tẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nhym aminêje memã kum, —Me'õ kute ijo mex ne imã, “Anhikwã djà krãn amỳn o tẽ”, anhỹr kôt ne ba arỳm inhikwã djà mỳn o tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nhym me kum, —Mỳj me'õ ne amã, “Anhikwã djà krãn amỳn o tẽ”, ane ga kam o tẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nhym, “Kon, ije mar kêt”, ane. Be, ar bu'ã ne me krãptĩ: ajkarê. Nhym Jeju arỳm me katikôt mã tẽ nhym arỳm omũnh kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nhym kam Jeju Metĩndjwỳnh nhõ kikretikam kum katon kum, —Ẽ, arỳm amexkam on ajaxwe krãta. Dja ga ajte ajaxwe nhym mỳjja'õ ajte ajo ajkẽ. Mỳjja punu kute apunu tũm jakrenh mex dja ajte ajo ajkẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nhym arỳm mebê idjaer rũnh'ỳr tẽn memã arẽn memã kum, —Be, Jeju ne ijo mex, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jeju kute pi'ôk ràràrkam meo mexo bakam ne mebê idjaer rũnh kum kurêo ba. Ne kam arỳm abenmã kum, “Gwaj on kubĩ”, anhỹro ba. ");
INSERT INTO txuNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nhym Jeju arỳm memã kum, —Be, Ibãm ne pi'ôk ràràrkam àpênh ar ba. Ba kudjwa kam idjàpênh ar iba, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nhym me arỳm abenmã kum, —Be, Jeju gwaj bapãnh pi'ôk ràràrkam àpênh ba. Djãm jabit? Kati. Tãmwã ta ne amijo 'êx ne Metĩndjwỳnho bãm ne raxo amiptàro ba, ane. Me abenmã anen arỳm we Metĩndjwỳnho ngryk ne kute Jeju bĩnmã kangrônh tỳx ne. ");
INSERT INTO txuNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nhym kam Jeju amipãnh memã kum, —E kum, mrãmri ne ba ibê Metĩndjwỳnh Krakumrẽx. Djãm ba ipydji ne ba idjàpênh got? Kati. Ibãmmẽ ne bar idjàpênh'ã ajkrut. Ne ba ren ipydjin ren ije meo mex kêt. Ibãm djàpênh ne ba omũn arỳm àpênh o idjàpênh. Ibãm djàpênh kunĩkôt ne ba kudjwa ã idjàpênho ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Be, mỳkam? Bir, Ibãm kum ijabêkam. Ne kam arỳm imã amidjàpênh kunĩ jakre ba kôt ipêx. Dja ĩ imã mỳjja pumũnh kêt ra:x kwỳ jakre ba arỳm ipêx ne. Dja mỳjja raxo ajbir ije ipêxja jakrenh mex ne. Dja ba ipêx ga me te aje marmã kam ano tyn aku'ê. ");
INSERT INTO txuNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ba Ibãm kôt akubyn me tyko tĩn. Kute Ibãm ta kute akubyn me tyko tĩn pyràk ne ba ã meo ane. Dja ba imã me tyk akubyn o tĩn kĩnh ne arỳm ã meo ane nhym me arỳm akubyn tĩn. ");
INSERT INTO txuNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dja ba me axwe kukjan memã ikaton kam memã axwe pãnh jarẽnhdjwỳ. Ibãm kute me'õmã axwe pãnh jarẽnh kêt. Ta ne imã, “Ga dja ga me kunĩmã axwe pãnh jarẽ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Be, mỳj kadjy ne ijã memã axwe pãnh jarẽnh djwỳnh mẽ? Bir, dja ba memã axwe pãnh jarẽ nhym me arỳm ijo bẽnjadjwỳr ra:x ne. Dja me ijo bẽnjadjwỳr ra:x mrãmri me kute Ibãmo bẽnjadjwỳr rax pyràk. Ja kadjy ne ijã memã axwe pãnh jarẽnh djwỳnh mẽ. Be, djãm me kute imã ikajgo jarẽnhkam kute Ibãmmã rax jarẽnh got? Kati. Dja me imã irax jarẽnh kêt ne arỳm Ibãmdjwỳmã rax jarẽnh kêt. Ta ne ijano ba tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Dja me tu amim ikabẽn markumrẽx ne tu amim kute ijanor djwỳnh markumrẽx ne arỳm kunĩ Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. Dja ba me jamã axwe jarẽnh kêtkumrẽx. Amrẽbê ne me ja Metĩndjwỳnhbê amakkre kêt kute mrãmri ne me tyk amakkre kêt pyràk. Ne kam arỳm jakam Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. Mrãmri ne ba me amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Dja me tyk ĩ ikabẽn ma. Ibê Metĩndjwỳnh Kraja ikabẽn ma. Ne kam me kute ikabẽn mar kunĩ dja me akubyn tĩn. 'Ã akati arỳm me bajo rãm ne ja. Arỳm ije kum o kraxmã. Mrãmri ne ba me amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Be, mỳj ne ikam kute ba memã ikabẽn nhym me akubyn tĩn? Bir Ibãmmẽ ije aben pyràk. Kam ne ba memã ikabẽn nhym me akubyn tĩn. Ibãm ta ne tĩn ne ta kute mỳjja kunĩmã tĩn jangjênho ba. Ibãm kabẽn kôt ne ba kudjwa itĩn ne ije mỳjja kunĩmã tĩn jangjênho iba. ");
INSERT INTO txuNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ne Ibãm kabẽnkôt dja ba memã axwe pãnh jarẽnhdjwỳ. Arỳm ije amijo inhĩkam dja ba ã meo ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Be, ije me amã, “Dja me tyk ikabẽn man akubyn tĩn”, anhỹrkam kwãrĩk wãnh te aje marmã ikam ano tyk kêt. Mrãmri dja pyka krãkam me tyk kunĩ ikabẽn man akubyn kato. ");
INSERT INTO txuNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Me mex ne ukaprĩ dja me akubyn tĩn. Dja me Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. Nhym me axwedjwỳ dja me akubyn tĩn. Ije memã axwe pãnh jarẽnh kadjy dja me akubyn tĩn. ");
INSERT INTO txuNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Be, djãm ipydji ne ba ar iba? Kati. Ba ipydji, idjàpênh ne ikabẽn kêt. Ibãm kabẽn o ne ba ikabẽn. Ibãm ne imã me axwe jakre ba kôt me axwemã ikaton kam memã pãnh jarẽ. Djãm ije amidjwỳnhbito kĩnhmã? Kati. Ibãm kute ijanor ne ba ije o kĩnhmã. Kabẽnkôt ije katàt me axwemã ikatorn kam pãnh jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Be, djãm ipydji ne ba me amã amijarẽ? Kati. Ba ren ipydjin me amã amijarẽ ga me ren mrãmri ijã, “Kati. Kabẽn kajgo”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nhym be, kati. Me'õdjwỳ ne ikukãm ijã me amã ujarẽnhkumrẽx. Katàt me amã ijã ujarẽnhkumrẽx. Ja ne ba arỳm ije mar. ");
INSERT INTO txuNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Be, me ga ne ga me amrẽbê Djuão'ỳr me akwỳ jano. Nhym me Djuão'ỳr bôx ne kukij. Nhym arỳm katàt me amã ijã ujarẽnhkumrẽx ga me arỳm ama. ");
INSERT INTO txuNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Be, djãm kute kabẽno Ibãm jakrenh got ba me amã Djuão jarẽ? Kati. Pykakam me'õ kute kabẽno Ibãm jakrenh kêt. Be, mỳj kadjy ne ba me amã Djuão jarẽ? Bir, me aje amijã Djuão kabẽn markumrẽx nhym Metĩndjwỳnh kute me ajaxwebê me apytàrmã ne ba me amã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Djuão ne kute mrãmri ne ngônhpôk nhirã pyràk ne ar ba. Nãm me amã kabẽn mex jarẽnho ba. Ga me ren tu amim kabẽn markumrẽx ne ren amijo aba mex rã'ã. Nhym be, kati. Djuão kute me amã arẽnho bakam ga me aje mar 'ikrãn ne akĩnh 'ikrãn ne. ");
INSERT INTO txuNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Be, Ibãmdjwỳ ne kute imã, “Ije amã adjàpênh djà jarẽnhja dja ga inomã amẽ”, anhỹr ne kute prĩne imã 'ã karõ ba arỳm kôt idjàpênh iba. Ba mỳjja pumũnh kêt nhipêxo iba ga me arỳm omũ. Idjàpênh ja kute iraxo amirĩto Djuão jakrenh mex. Ga me ren aje idjàpênh pumũnhkam ren arỳm mrãmri iraxmã akatorkumrẽx. Ibãm kute ijanorkôt ne ga me ren imã akatorkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ibãm ta kute ijanor ne arỳm ijã ajarẽ. Djãm me aje õkre mar ne ĩ pumũnh got? Arkati. ");
INSERT INTO txuNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ga me ren aje amim Ibãm kabẽn mar prãm ne ren tu amim imarkumrẽx. Nhym be, kati. Ibãm kute ijanor djwỳnh ta ne arỳm mã amã ijã ajarẽ ga me aje amim kabẽn 'amỳnh kêt ne mar prãm kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Goja prĩne Metĩndjwỳnh kabẽn'ã pi'ôk no'ôk pumũ. Me ga ne ga me 'ã amim, “Dja ba arẽnho iban Metĩndjwỳnhkôt itĩn ne ar iba rã'ã: rã'ã ne”, anhỹro aba. Me aje amim anhỹrkam goja prĩne amim omũn ama. Pi'ôk tãmkam ne Metĩndjwỳnh ba ijã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nãm te pi'ôkkam ijã ajarẽ ga me ikôt abikamẽnh kêt. Ga me ren Metĩndjwỳnhkôt atĩn kadjy ren ikôt ajkamẽ. Nhym be, kati. Me aje ikôt abikamẽnh prãm kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Djãm me aje imã, “Araxkumrẽx”, anhỹrmã? Djãm irax ja ne ba abej? Kati. ");
INSERT INTO txuNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Be, mỳkam? Bir, me amã kàjkwakam Metĩndjwỳnh jabê kêtkam ije irax ja jabej kêt. Arỳm ije me amar. ");
INSERT INTO txuNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ibãm kukwakam ba tẽn me awỳr bôx ga me aje amim imar kêt. Me'õ kàtàm ta dja tẽn me awỳr bôx ne ta amiraxo àmra ar ba ga me arỳm tu amim markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Be, me ga ne ga me amirax jabej mã amim, “Ba gêt ba amibẽn gê me imã irax jarẽ”, anhỹro aba. Ne kam aje amim, “Ba Metĩndjwỳnhmãbit amijarẽ gê ta ijo rax”, anhỹr kêtkumrẽx. Aje amim, “Ba gêt irax. Ba gêt irax”, anhỹro abakam aje amim Metĩndjwỳnh mar prãm kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Djãm ba dja ba Ibãmmã me ajaxwe jarẽ? Kati. Ga me akukãmãre Môjdjê kanàrràm ar amijo aba. Ta ne arỳm Metĩndjwỳnhmã me ajaxwe jarẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Djãm mrãmri ne ga me aje tu amim akukãmãre Môjdjê kabẽn markumrẽx? Kati. Ga me ren tu amim Môjdjê kabẽn markumrẽx ne ren badjwỳ tu amim imarkumrẽx. Ta ne ikukãm ijã ajarẽn ijã pi'ôk no'ôk. Kam ga me ren amim kabẽn jarẽn ren tu amim imarkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nhym be, kati. Me aje amim Môjdjê kabẽn mar kêt ne aje kôt amim badjwỳ ikabẽn mar kêt. Nãm ã Jeju pi'ôk ràràrkam kute me'õ punuo mexkam mebê idjaer rũnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nãm memã anen kam arỳm amũ tẽ. Tẽ:n kam arỳm imôtibê Garrêja nhikjêmã rê. Imôti nhidji 'õdjwỳbê Xiberij. ");
INSERT INTO txuNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nhym kam me krãptĩ kôt mõ. Õbê Jeju kute mỳjja pumũnh kêt kwỳ nhipêx nhym me kute omũnhkam ne me kôt mõ. Nãm me punu krãptĩo mex nhym me omũn arỳm kôt mõ. ");
INSERT INTO txuNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kôt mõ nhym Jejumẽ kôt ba djwỳnh ar me kukãm mõ. Mõ:n krãnh'ã wabi. Àbir tẽ:n arỳm kam nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Be, arỳm ne Djeruxarẽkam mebê idjaer kute aben pydji djà nhõ akatija bôx 'ỳr. Me kute Metĩndjwỳnh me kukãmãre nhirôbê mrãnhja mar kadjy ne arỳm õ akati 'ỳr. ");
INSERT INTO txuNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ar krãnh'ã nhỹ nhym kam Jeju amipãnh rĩt. Nhym nĩnh me krãptĩ: kôt mõ nhym me omũ. Ne kam Piripimã kum, —Jãm dja gwaj tẽn me kadjy djwỳ kwỳ by? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Be, djãm kute amikukãm amimar kêt ne Piripi kukij? Kati. Kute prĩne amikukãm amimar. Be, mỳkam ne kukij? Bir, Piripi kute mrãmri amim tu markumrẽx jabej ne kukij. ");
INSERT INTO txuNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nãm kukij nhym Piripi kum, —Tô gêt kon. Gwaj banhõ pi'ôk kaprĩ'ã akrekam kubê denarjuo 200bit. Ne gwaj ren pi'ôk kaprĩ jao ren me kadjy djwỳ by nhym ren me krãptĩ abenmã kokjêr kryre nhym ren me krãptĩ:'ã djwỳ kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nhym Jejukôt ba djwỳnh 'õdjwỳja nhidjibê Ãngre. Ximão Pedrumẽ ar axikôt apôx. Ãngreja kum, ");
INSERT INTO txuNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ota jakam me'õ bôktire nhõ djwỳmẽ tepprãremẽ. Xewadao djwỳ nhipêx amãnhkrut ne amãnhkrut ne ikjêkêt. Ne tepprãre amãnhkrut. Nhym be, me krãptĩ:. Mỳj dja gwaj djwỳ ngrirejao me on? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nhym Jeju arkum, —Ar memã arẽ gê me nhỹ, ane. Be, bõre ne pyka wãkam kumex ne. Jeju arkum ane nhym ar arỳm memã arẽ. Nhym me arỳm bõrekam nhỹ. Me krãptĩ: kubê 5.000 ne me nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nhym kam Jeju arỳm djwỳ jamỳ. Ne kam arỳm o Metĩndjwỳnhmã amikĩnh jarẽ. O kum amikĩnh jarẽn arỳm kôt ba djwỳnhmã kungã. Nhym ar me krãptĩmã kungã. Nãm ã tepprãredjwỳo ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nhym me õ kwỳ krẽ:n arỳm ajne. Nhym Jeju kôt ba djwỳnhmã kum, —Dja gar djwỳ janhy karwà. O bikẽnh kêt kadjy, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nhym kam ar karwàn kaxnokai pỹnh djàri kam kungij. Nhym kam kaxnokaibê 12 ipu. Be, xewadao djwỳ amãnhkrut ne amãnhkrut ne ikjêkêt janhy 'ã kàtàm ne ja. ");
INSERT INTO txuNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nhym me arỳm kute mỳjja pumũnh kêtja pumũnhkam abenmã kum, —Be, Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh ja ne me amrẽbê arẽ. Me memã kum, “Dja pykamã bôx”, anhỹro ba. Be, kôt ne Jeju arỳm jakam bôxkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nhym Jeju arỳm me kuman amim, —Got ba ren arek dja nhym ren me tu ijo tỹm ne ijã bẽnjadjwỳr rax mẽ. Djãm on pykakam memã inhỹr prãm got? ane. Ne kam arỳm mebê tẽn amũ krãnh'ã wabin ate ar ba. ");
INSERT INTO txuNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nhym kam arỳm para. Nhym kôt ba djwỳnh tẽn arỳm imôti'ỳr ruw. ");
INSERT INTO txuNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ne kam arỳm kà'õkam wadjàn nox ne. Amũ akàx nhikjêmã krĩraxbê Kapana'ỳr mõrmã ar arỳm nox ne. 'Ỳr mõ: nhym ar'ã arỳm akamàt ne. Nhym kraxje Jeju ar'ỳr bôx kêt rã'ã. ");
INSERT INTO txuNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ar mõ: nhym arỳm kôk 'itỳx wabê nhym kam ngô amijapĩn tỳx ne. ");
INSERT INTO txuNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nhym ar ngô rẽnho mõn arỳm ajbubê tỹm ne. Ar mõr'ã arỳm kirometubê 5 apêx. Nhym Jeju nĩnh arkôt tu ngô'ã tẽ nhym ar omũ. Nhym arỳm aro rãm ne ja nhym ar arỳm tĩn prãm ne. ");
INSERT INTO txuNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nhym arkum, —Ar atĩn prãm kêt. Ba ne ba ar akôt tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nhym ar kabẽn man arỳm kĩnh ne. Ne kum, —Amrẽ ar ikôt kàmã wadjà, ane. Nhym arỳm wadjàn nhỹ. Nhym ỹrmẽ ro'ã ar arỳm akàx nhikjê'ỳr bôx. Kapanakam ar bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Jeju ar akàx nhikjêkam bôx nhym arỳm ar'ã akati. Nhym kam amũ akàx nhikjêbê me te ar õ kà jabej. Me krãptĩ kute amũja'ã djwỳ krẽnja ne te ar õ kà jabej ne abenmã kum, —Be, amũja'ã kà pydjibit nõ nhym ar o mõ. Kôt ba djwỳnhbit mã o mõ nhym Jeju arkôt kàkam ỹr kêt. Nãm me krãptĩ te ar õ kà jabejn kam ã abenmã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","24","Ne kam me kute Jeju ar omũnh kêtkam arỳm ar'ỳr mõ. Me kà kwỳkam wadjàn akàx nhikjêmã Kapana'ỳr nox ne mõ. Be, nhỹnh kà ja'õkam ne me mõ? Bir, krĩraxbê Xiberijkam kà 'õkam ne me mõ. Xiberijkam kà kwỳ arỳm me ku'ê djà'ãnh mõ. Bẽnjadjwỳr djwỳnh kute Metĩndjwỳnhmã amikĩnh jarẽnh nhym me kute djwỳ krẽn djà'ãnh ne arỳm kà mõ. Kà kwỳ jamã ne me wadjàn amũ kôt mõ. Me kute Jeju jabej kadjy ne me Kapana'ỳr mõ. ");
INSERT INTO txuNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","'Ỳr mõ:n kam imôti nhikjêmã bôx. Bôx ne abej ne arỳm kum kato. Jejumã katon arỳm kum, —Ujarẽnh djwỳnh, tô nhỹnh ne myt nhỹ ga jakam bôx? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nhym memã kum, —Be, mỳkam ne ga me ijabej mõ? Djãm amũja'ã ije mỳjja pumũnh kêt kwỳ nhipêx ga me aje omũnhkam? Djãm arỳm me aje kôt iraxmã akatorkam? Djãm me aje ajte irax marmã ne ga me ijabej mõ? Arkati. Be, me ajajnekam. Me aje djwỳ krẽn ne me ajajnekam ne ga me ijabej mõ. Mrãmri ne ba me amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kwãrĩk wãnh djwỳkôtbit ajamak bẽn kêt. Tãm dja akuno. Nhym be, atemã mỳjja kute djwỳ pyràk. Jakôt dja ga me ajamak bẽn. Tãm ne mex rã'ã nhym ô'ã me Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. Ba ije amijo inhĩ dja ba me amã kungã ga me atĩn ne ar aba rã'ã: rã'ã ne. Bir, Ibãm kute imã 'ã karõ. Kabẽnkôt dja ba me amã kungã. Kàjkwakam Ibãm, Metĩndjwỳnh ta ne mrãmri kute 'ã imã karõ mãmdji, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nhym me kum, —Be, mỳj dja ba me Metĩndjwỳnhmã idjàpênh o nhym arỳm kum me ikĩnh? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nhym, —Metĩndjwỳnh ne ijano ba tẽ. Kôt dja ga tu amim imarkumrẽx. Kum adjàpênh ne ja. Dja ga me ã ane nhym arỳm kum me akĩnh, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nhym me kum, —Goja mỳjja pumũnh kêt'õ nhipêx ba me omũ. Ba me ije araxmã ikator kadjy omũn kam goja tu amim amarkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Be, me bakukãmãre ne me kapôt kukritkam djwỳbê mỳj ne ja krẽ. Me bakukãmãre ne me 'ã pi'ôk no'ôk ne kamã memã kum, “Me kute krẽn kadjy ne memã kàjkwa kurũm djwỳ ngã”, ane. Goja kudjwa ã me imã o ane ba me omũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","33","Nhym amijã djwỳkumrẽx jakren memã kum, —Be, Môjdjê kute me akukãmãremã kàjkwa kurũm djwỳ nhõr kêt. Nhym be, Ibãm kute me amã kàjkwa kurũm atemã djwỳkumrẽx nhõr. Me'õ ne arỳm kàjkwa kurũm ruw ne kute me kunĩmã tĩn jangjênh. Kute memã tĩn jangjênh nhym me tĩn ne ar ba rã'ã: rã'ã ne. 'Ã ne ije me amã, —Metĩndjwỳnh kute me amã atemã djwỳkumrẽx nhõr, anhỹr. Mrãmri ne ba me amã ja jarẽnhkumrẽx. Nãm Jeju ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nhym me kum, —Bẽnjadjwỳr djwỳnh, goja mã me imã djwỳ ja nhõro nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nhym Jeju memã kum, —E kum, ba. Ba ne ba ije atemã djwỳ pyràk. Ba ne ba ije memã tĩn jangjênh nhym me tĩn ne ar ba rã'ã: rã'ã ne. Dja me mã ikôt ajkamẽn arỳm kĩnhkumrẽx rã'ã kute mrãmri ne me arỳm kum prãm kêtkam kĩnh pyràk. Dja me tu amim imarkumrẽx ne arỳm kĩnhkumrẽx rã'ã kute mrãmri ne me arỳm kum kôr kêtkam kĩnh pyràk. ");
INSERT INTO txuNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Be, djãm me aje tu amim imarkumrẽx got? Kati. Ba ne ba arỳm me amã, “Nã gãm me te ipumũn amim imar kêt”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Be, Ibãm kute ikadjy memã amak bônhja kunĩ dja me tu amim imarkumrẽx ne arỳm mã ikôt ajkamẽ. Ba kam me'õ kanga kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mỳkam dja ba me'õ kanga kêtkumrẽx? Bir, Ibãm kute me'ã imã karõ kôt dja ba me'õ kanga kêt. Be, djãm ba ije amijã amim karõ kôt ne ba kàjkwa kurũm ruw ne ar iba? Kati. Ibãm kute ijanor djwỳnh kabẽn kôt ne ba ruw ne ar iba. ");
INSERT INTO txuNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ibãm kute ijanor djwỳnh ta ne ijã amim karõn amim, “Be, ije kadjy memã amak bônhja dja ikra mã meo ban 'õo biknor kêt nhym me akubyn tĩn ne. Pykakam me kunĩ kute aminhinomã amimẽnh djà nhõ akatikam dja ikra akubyn õ me jao tĩn”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ibãm kute ijanor djwỳnh ajte ijã amim karõn amim, “Me kute ikra pumũnh ne tu amim markumrẽxja dja me kunĩ ikôt tĩn ne ar ba rã'ã: rã'ã ne”, ane. Ibãm kute ijã amim karõ ne ja. Pykakam me kunĩ kute aminhinomã amimẽnh djà nhõ akatikam dja ba akubyn inhõ me jao tĩn, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nhym kam mebê idjaer rũnh arỳm kàxã kabẽn kumex ne arẽ. Kute memã, “Ba ibê kàjkwa kurũm djwỳ”, anhỹrkam ne me kabẽn kumex jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ne abenmã kum, —Be, djãm kubê Metĩndjwỳnh Kra got? Kati. Jôdje ne kudji. Idjibê ne Jeju. Ba me ije nãmẽ bãm pumũnh tũm. Nhym amijo 'êx ne gwaj bamã, —Kàjkwa kurũm ne ba ruw, anhỹro ba. Kati:. Nãm 'êx. Nãm me ã abenmã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nhym Jeju me kabẽn man memã kum, —Kwãrĩk wãnh ikàxã akabẽn kumex ne arẽnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Be, djãm me ga dja ga me ikôt ajkamẽ? Kati. Ibãm kute ijanor djwỳnh kute memã amak bônhkambit ne me mã ikôt ajkamẽ. Mã ikôt ajkamẽ ba arỳm akubyn meo tĩn. Pykakam me kunĩ kute aminhinomã amimẽnh djà nhõ akatikam dja ba akubyn meo tĩn. ");
INSERT INTO txuNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Amrẽbê: ne me bakukãmãre Metĩndjwỳnh kukwakam kabẽn jarẽn memã kum, “Metĩndjwỳnh ta dja memã amikabẽn jarẽ nhym me arỳm kabẽn markumrẽx”, ane. Be, me bakukãmãre kute memã anhỹr ne 'ã pi'ôk no'ôk kôt mỳj xê dja mã ikôt ajkamẽ? Bir, Ibãm kute memã kabẽn jarẽnh nhym me arỳm kute kabẽn markumrẽx. Me kute mỳjja'ã kute kabẽn jarẽnhja markumrẽx. Me ja dja me mã ikôt amijo bikamẽnhkumrẽx. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ne kam ajte memã kum, —Be, djãm me'õ ne arỳm Ibãm pumũ got? Kati. Bajbit ne ba arỳm kàjkwakam Metĩndjwỳnh pumũn arỳm kurũm tẽn bôx. Bajbit ne ba arỳm Ibãm pumũ. ");
INSERT INTO txuNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Me kute tu amim imarkumrẽx arỳm Metĩndjwỳnhkôt tĩn ne ar ba rã'ã rã'ã ne. Mrãmri ne ba me amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ba ne ba ije atemã djwỳ pyràk. Ba ne ba memã tĩn jangij nhym me Metĩndjwỳnhkôt tĩn ne ar ba rã'ã rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Be, me bakukãmãre ne me kapôt kukritkam djwỳbê mỳj ne ja ku nhym mebêngêt tũmràm me kupa. ");
INSERT INTO txuNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ije me amã atemã djwỳ jarẽnhja ne kubê kàjkwa kurũm djwỳ. Dja me kukun tyk kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ba ne ba ije atemã djwỳ pyràk. Ba ne ba memã tĩn jangij. Dja me djwỳ ja krẽn Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. Djwỳ ije memã õrja ne kubê inhĩ. Me kunĩ tĩn kadjy dja ba memã kungã, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nhym kam mebê idjaer rũnh arỳm kabẽno aben japan abenmã kum, —Je tô, mỳj dja memã aminhĩ nhõr on nhym me ajmã krẽnja on? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Be, djãm mrãmri ne me kute ĩkumrẽx krẽnmã? Kati. Atemã. Be, mrãmri me kute tu amim Jeju markumrẽxo bamã. 'Ã ne Jeju me kute ĩ krẽn jakren 'ã me kute kamrôo kõm jakre. 'Ã ne memã kum, —Be, ba ije amijo inhĩ dja ga me inhĩ krẽn kêt ne ikamrôo akõm kêt ne kam atĩnkumrẽx prãm kêt. Mrãmri ne ba me amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Me kute inhĩ krẽn ne ikamrôo kõm ne me mrãmri Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. Pykakam me kunĩ kute aminhinomã amimẽnh djà nhõ akatikam dja ba akubyn meo tĩn. ");
INSERT INTO txuNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mrãmri ne inhĩbê djwỳ ne ikamrôbê me kõm djà. ");
INSERT INTO txuNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Me kute inhĩ kur ne ikamrôo kõmja, me jamẽ ne ba me ije aben mar tỳx ne ije aben jamỳnh tỳx ne abenã idjukanga kêt ne ar abeno iba. ");
INSERT INTO txuNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mrãmri Ibãm tĩnkumrẽx ne ijano ba tẽ. Kam ne ba Ibãm tĩn o itĩnkumrẽx. Nhym me kute inhĩ kurdjwỳ dja me ba itĩn jao tĩnkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ije amã atemã djwỳ jarẽnh ja ne kàjkwa kurũm ruw. Djãm kute djwỳbê mỳj ne ja pyràk? Kati. Nãm me te mỳj ne ja ku nhym mebêngêt arỳm me kupa. Nhym be, ate dja me atemã djwỳ ja kun arỳm Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Mebê idjaer bikprõnh djàkam ne Jeju memã ja jarẽ. Kapanakam me bikprõnh djàkam. ");
INSERT INTO txuNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kute memã aminhĩ'ã djwỳ jarẽnh ne memã 'ã ujarẽnhkam ne me kôt baja krãptĩ arỳm amim, —Je, djãm me ije kabẽn wã mar got? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nhym Jeju ta arỳm me kuman memã kum, —Ba arỳm me amã atemã djwỳ jarẽ ga me aje amim imar kêt ne arỳm apijàm ne. ");
INSERT INTO txuNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Dja ba ĩ ikrĩ djà tũmmã wabi ga me idjàbirkôt ipumũ. Mỳj dja ga me arỳm kam nẽ? ");
INSERT INTO txuNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Be, atemã kàjkwakam ikabẽn kukràdjà ne ba me amã arẽ. Metĩndjwỳnh Karõ kute meo bakambit ne me kute ikabẽn mar. Me ga ne ga me aje amidjwỳnho kĩnh prãm. Kam me aje imar kêtkumrẽx. Nã bãm me amã ikabẽn jarẽ, me amã Metĩndjwỳnh Karõ jarẽ. Tãm ne kute meo ban memã tĩn jangij nhym me Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Be, djãm me akunĩ ne ga me aje tu amim imarkumrẽx? Kati. Me akwỳ ne ga me aje amim imar kêt, ane. Nãm Jeju ã memã ane. Be, mỳj ne me mar on kam ã memã ane? Bir, amrẽbê mỳjja kunĩ kêtri ne Jeju kute amikukãm me mar. Apỹnh me ĩ djàri kute amim mar kêtja arỳm kute me mar. Djudadjwỳ dja ĩ kurê djwỳnhmã Jeju kanga. Nhym arỳm kute adjwỳnhdjwỳ mar. Kukãm kute mar. ");
INSERT INTO txuNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ne kam memã kum, —Me akwỳ ne ga me aje amim imar kêt. Ba kam arỳm me amã, “Djãm me ga dja ga me ikôt ajkamẽ? Kati. Ibãm kute memã amak bônhkambit dja me mã ikôt ajkamẽ.” Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nhym kam me kôt baja krãptĩ arỳm kubê amijo akẽx ne ajte kôt ba kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nhym kam Jeju kute ar anorjabê 12mã kum, —Djãm ar gadjwỳ dja gar ikanga? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nhym ar 'õbê Ximão Pedru kum, —Kati. Bẽnjadjwỳr djwỳnh, mỳj me'õkôt dja bar ar iba? Arkati. Gajbit ne ga akabẽno meo tĩn ne 'ã ar imã adjujarẽnh ar aba. Metĩndjwỳnhkôt me tĩn ne ar ba rã'ã: rã'ãja'ã ar imã adjujarẽnh ar aba. ");
INSERT INTO txuNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ar ba ne bar tu amim amarkumrẽx. Mrãmri abê me inhõ Bẽnjadjwỳrbê kumkatibê Kritu. Mrãmri abê Metĩndjwỳnh Kra. Metĩndjwỳnh tĩnkumrẽx Kra. Ar ba ne bar tu amim amarkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nhym Jeju arkum, —Be, mrãmri ne ba amijo ar apytàrkumrẽx. Ije ar ajanorbê 12 ne ba amijo ar apytàrkumrẽx. Be, djãm ar akunĩ ne gar amex? Kati. Ar ajõ apydji ne abê Xatanaj nhõ àpênh, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Djuda'ã ne kabẽn. Djuda Ikadji. Ximão 'õdjwỳ kute irja. Dja ĩ kurê djwỳnhmã Jeju kanga. Kute ar anorjabê 12'õ ja dja kanga. ");
INSERT INTO txuNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jeju memã anen kam arek Garrêjakambit ar ba. Be, mỳkam ne Djudêjakam arek ar ba kêt? Bir, mebê idjaer kute kam bĩnmã ar abej bakam. ");
INSERT INTO txuNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nhym kam arỳm Djeruxarẽkam mebê idjaer krãptĩ kute aben pydji djà nhõ akati 'ỳr. Me kute aben kajmã'ã me bakukãmãre kukràdjà mar kadjy bô mjỳrkam krĩ djà nhõ akati 'ỳr. ");
INSERT INTO txuNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nhym kam Jeju kamy ar axikôt apôxja kum, —E kum, goja amũ pykabê Djudêja'ỳr tẽ. Dja wãkam akôt me ba djwỳnh adjàpênh kôt apumũ. ");
INSERT INTO txuNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Djãm me'õ kute me kunĩmã amiraxo amirĩt prãmkam kute mebê amijo bipdjur prãm got? Aje mrãmri mỳjja pumũnh kêt nhipêx jabej goja pyka kunĩkôt me kunĩmã amijo amirĩt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Be, nãm ar te Jejumẽ axikôt apôx ne amim mar kêt. Kam ne ar ã kum ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nhym Jeju arỳm arkum, —Je djãm kraxje me kute ijo tỹm djà nhõ akati iwỳr bôx kêtjakam gar kam imã arẽ? Kati. Ar gajbit akati kunĩkôt ar adjumar mex rã'ã. ");
INSERT INTO txuNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nhỹnh ne pykakam me axwe 'õ kum akurêmã? Arkati. Nhym be, ba, me kum ikurêkumrẽx. Ije me axwe'ã memã idjujarẽnh ar ibakam me kum ikurêkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ar gajbit dja gar Djeruxarẽkam me krãptĩ kute aben pydji djà'ỳr mõ. Inhõ akati iwỳr bôx kêt rã'ãkam 'ỳr itẽm prãm kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nãm arkum anen arek Garrêjakam ar ba. ");
INSERT INTO txuNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nhym kam kamy ar arỳm tẽ. Nhym ar ba:n kam amipdjun arỳm me kute aben pydji djà'ỳr tẽ. 'Ỳr tẽ:n arỳm 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nhym arỳm 'ã me kute aben pydji djà nhõ akati bôx nhym mebê idjaer rũnh arỳm abej ne memã kum, “Nhỹnh ne Jeju dja”? ane. Nhym me “Kon”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nhym me me kàxã abenmã Jeju jarẽnho kumex. Me kwỳ ne me abenmã kum, “Kati. Jeju mexkumrẽx”, ane. Nhym me kwỳ arĩk abenmã kum, —Kati. Nãm Jeju amijo 'êx ne me noo biknoro ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nhym be, nãm me me ipôkri memã Jeju'ã ujarẽnho amirĩt kêt ne. Mebê idjaer rũnh pymaje ne me me ipôkri 'ã ujarẽnho amirĩt kêt ne. ");
INSERT INTO txuNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nhym kam arỳm me kute aben pydji djà nhõ akati nhõkre djà kôt Jeju arỳm Metĩndjwỳnh nhõ kikreti'ỳr tẽn wadjàn kam arỳm memã kukràdjà jarẽnho dja. ");
INSERT INTO txuNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nhym kam mebê idjaer rũnh te kute Jeju marmã kam no tyn kumex ne abenmã kum, —Je tô djãm tãmwã kute mekôt pi'ôk jarẽnh tũm got ã me kukràdjà jarẽnh mexo ane? ");
INSERT INTO txuNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nhym Jeju memã kum, —Djãm ba ikukràdjà ne ba me amã arẽnho iba? Kati. Kute ijanor djwỳnh kukràdjà ne ba me amã arẽnho iba. ");
INSERT INTO txuNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Gêdja ga me ajõ ga aje kukràdjà kôt amijo aba prãm jabej arỳm ama. Me'õ kute ikukràdjà jarẽnhmo krax djwỳnhja dja ga me ama. Djãm ba ne ba ije me amã ikukràdjà jarẽnhmo krax djwỳnh? Kati. Kàjkwakam Metĩndjwỳnh ne kute arẽnhmo krax ba kam kôt me amã arẽ. Ja dja ga me ama. Me aje kukràdjà kôt amijo aba prãm jabej ama. ");
INSERT INTO txuNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ne ga ren me ajõ ga amirax jabej ne ren 'ã memã amijarẽn memã amijo adjàmra ar aba. Nhym be, kati. Kute ijanor djwỳnh ne ba ije rax jarẽnh. Ije ajbit rax jarẽnh ne kam katàt ije ikabẽn jarẽnhkumrẽx ne ijêxnhĩ kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Me bakukãmãre Môjdjê kute me amã Metĩndjwỳnh kukràdjà jarẽnhja djã ne ga me kôt ar amijo aba? Kati. Ga me ajõ aje kukràdjà kôt ar amijo aba kêt. Ne kam aje ibĩnmã ijabej ar aba. Mỳkam? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nhym me kum, —Je tô nhỹnh me'õja ne kute abĩnmã ajabej ar ba? Be, me karõ punu'õ ne ajo ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nhym Jeju arỳm memã kum, —Be, ba amrẽbê me'õ punu pydjio mex ga me te aje mỳjja marmã ikam ano tyn akumex. ");
INSERT INTO txuNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Nã bãm pi'ôk ràràrkam me'õo mex ga me arĩk ijã abenmã kum, —Pi'ôk ràràrkam ne apê. Axwekumrẽx, anhỹro aban arỳm ikam angryk ne. Djãm bajbit ne ba kam idjàpênh iba ga me bajbit imã ijaxwe jarẽ? Kati. Me gadjwỳ ne ga me pi'ôk ràràrkam adjàpênh aba. Môjdjê ne me amã me my nhinhu kà rênh jarẽ. Djãm ta ne kumrẽx arẽ? Kati. Me bakukãmãre Abraão ar kumrẽx ne ar arẽ. Ga me kam aje katàt Môjdjê kukràdjà kôt amijo aba kadjy pi'ôk ràràrkam adjàpênh ne me my kà rênho aba. Mỳkam ne ga me bajbit imã ijaxwe jarẽ? Ije kam prĩne me'õ punuo mexkam imã ijaxwe jarẽ. Ga me ren imã ijaxwe jarẽnh kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kwãrĩk wãnh ga me arĩk me axwe kêt'ã axwe janhôr kêt. Dja ga me mrãmri me axwekumrẽxkôt memã ajapôxkumrẽx ne kam arỳm katàt memã axwe jarẽnhkumrẽx. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nhym kam Djeruxarẽkam me ar ba tũm kwỳ Jeju jabej aben kukij ne abenmã kum, —Je, djãm mrãmri me kute tãmwã bĩnmã ar abej ba? ");
INSERT INTO txuNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nhym kam kum me uma kêt ne memã kabẽn ne. Nhym me arỳm kutã kute kum mỳjja'õ jarẽnh prãm kêtkumrẽx. Bãrãm me rũnh arỳm kute tãmwã'ã amim, “Jejubê ne me banhõ Bẽnjadjwỳrbê kumkatibê Kritu”, anhỹrkam ne me anhikrên kabẽn maro dja. ");
INSERT INTO txuNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tô nhỹnh? Be, kati. Djãm me kute kraxkôt Bẽnjadjwỳrbê kumkatibê Kritu mar got? Kati. Me kute kraxkôt mar kêtkumrẽx. Nhym be, bãm kute Jeju djir ne gu me baje arỳm omũnh. Kôt ne gu me arỳm Jeju 'êxnhĩmã bakato. Nãm me kwỳ ã Jeju'ã abenmã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nhym kam Jeju kute Metĩndjwỳnh nhõ kikretikam memã kukràdjà jarẽnho ãmkam kàj bê memã kum, —Be, mrãmri ne ga me aje imar. Nhỹnhja kurũm ne ba itẽm ne ibôx ja ne ga me arỳm aje mar. Djãm ba ne ba amikabẽn kôt amrẽ tẽ? Kati. Me'õ kute ijanor djwỳnh ne mrãmri. Tãmwã ne ga me aje mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nhym be, ba ne ba ije omũnh tũm. Tãm ne ijano ba amrẽ kurũm tẽn bôx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nhym kam me bit kute o tỹm ne pa 'amỳnhmã. Ne te: o ane. Me kute o tỹm'ã myt bôx kêt rã'ãkam ne me te: o ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nhym me kwỳ krãptĩ arỳm tu amim markumrẽx ne abenmã kum, —Me baje raxmã bakator kadjy ne Jeju arỳm mỳjja pumũnh kêt krãptĩ nhipêx ne. Me punu krãptĩo mex. Djãm me'õdjwỳ bôx ne kute àpênh mexo kute akrenh got? Kati. Be, mrãmri tãmwãbê ne me banhõ Bẽnjadjwỳrbê kumkatibê Kritukumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Me rũnh kàxã ne me ã abenmã anhỹro ku'ê nhym mebê pardjêumẽ me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr arỳm me kuma. Me kuman arỳm Jeju'ỳr me krãkamngônh kwỳ jano. Me kute pa 'amỳnhmã ne me me ano. ");
INSERT INTO txuNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nhym kam Jeju arỳm memã kum, —Be, me aro'ã ar iba ne arỳm 'ã akati ngrêre. Dja ba kam arỳm kute ijanor djwỳnh'ỳr tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ga me kam arỳm te ijabej. Te ijabej ne imã akator kêt. Ne kam ikrĩ djà'ỳr te abôx prãmje, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nhym mebê idjaer rũnh abenmã kum, —Je tô, jãm dja tẽ gu me kum bakator kêt. Djãm apỹnh me bajtem ba djàkam me bimành tũm'ỳr ne tẽmmã? Djãm kam kute me bajtemmã kukràdjà jarẽnhmã? ");
INSERT INTO txuNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kute me bamã, “Dja ba tẽ ga me arỳm te ijabej. Te ijabej ne imã akator kêt. Ne kam ikrĩ djà'ỳr te abôx prãmje”, anhỹr. Mỳj gêdja kam nẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nhym kam me kute amikukràdjà kôt amijo mõr ne kute 'ã aminhinomã amimẽnh nhõ akati arỳm bôx. Akati raxja bôx. Me kukãmãre kukràdjà kôt me kute bô mjỳrkam krĩ'ã aminhinomã amimẽnh kadjy akati ne arỳm bôx. Nhym Jeju arỳm kàjmã djan memã kum, —Me ajõ ar amã kôr jabej amrẽ iwỳr tẽn ikõ. ");
INSERT INTO txuNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Me kute tu amim imarkumrẽxja gêdja ĩ me kadjwỳnhbê ngô kute meo tĩnja mã mekam apôx. Me bakukãmãre kute pi'ôkkam memã arẽnh kôt ne ba ar amã arẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nãm Jeju Metĩndjwỳnh Karõ'ã ã memã ane. Dja me tu amim Jeju markumrẽx nhym Metĩndjwỳnh Karõ arỳm me'ỳr bôx ne meo ba. Djãm arỳm ne meo ba? Kati. Metĩndjwỳnh kute memã Karõ janor djwỳnhràm ne Jeju memã ane. Dja Metĩndjwỳnh amiwỳr Jejuo wabin akubyn o rax. Ne kambit arỳm memã Karõ jano nhym bôx ne meo ba. ");
INSERT INTO txuNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jeju memã ane nhym me krãptĩ kute kabẽnja markam 'ã abenmã kum, —Be, mrãmri ne tãmwãbê Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh. Me bakukãmãre ne me amrẽbê: arẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nhym me kwỳ Jeju'ã abenmã kum, —Be, tãmwã ne mrãmri kubê Kritukumrẽx. Mrãmri kubê me banhõ Bẽnjadjwỳrbê kumkatibê Kritukumrẽx, ane. Nhym me kwỳ arĩk 'ã abenmã kum, —Be kati. Jejubê ne Bẽnjadjwỳrbê kumkatibê Kritu kêt. Abatành djà ne pykabê Garrêja. ");
INSERT INTO txuNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nhym be, me banhõ Bẽnjadjwỳrbê kumkatibê Kritukumrẽx krĩbê Berẽkam abatành. Kubê ne me bakukãmãre Dawi tàmdjwỳ. Bẽnjadjwỳr rax Dawi jabatành djàkam ne Kritu abatành djà. Amrẽbê: ne me bakukãmãre pi'ôkkam arẽ. Nhym be, kati. Djãm Jejubê Bẽnjadjwỳrbê kumkatibê Kritu got? Jeju ate Garrêjakam abatành, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Me kute ã abenmã anhỹrkam me kute Jeju'ã axikôt kabẽn jadjwỳr kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nhym me ja kwỳ bit kute o tỹm ne pa 'amỳnhmã. Ne kam te: kute o anhỹrmã. ");
INSERT INTO txuNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nhym kam me krãkamngônh kikreti nêje ku'êja me rũnh'ỳr akẽx ne me'ỳr bôx. Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebê pardjêu'ỳr bôx. Nhym kam me rũnh me krãkamngônhmã kum, —Je tô mỳkam ne ga me Jejuo abôx kêt? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nhym me krãkamngônh memã kum, —Djãm me'õ pykakam kabẽn mexo kute tãmwã pyràk? Kati. Nãm prĩne kabẽn mexo kute katàt me kunĩ jakrenh. Ba me kam te ije o itỹm ne pa 'amỳnhmã, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nhym mebê pardjêu memã kum, —Je tô djãm arỳm ne me gadjwỳ me anoo akno? ");
INSERT INTO txuNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ẽ, ba me amã arẽ. Djãm me irax'õ, nàr me ibê pardjêu'õ ije amim tãmwã mar got? Kati. ");
INSERT INTO txuNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Be, djãm me kàtàmwã kute Môjdjê kukràdjà mar got? Me kute me bakukãmãre kukràdjà mar kêtkam dja Metĩndjwỳnh arỳm me kanga, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nhym Nikodemu. Tãm ne akamàtkam Jeju'ỳr tẽ. Kubê ne mebê pardjêu'õ. Nãm arỳm memã kum, ");
INSERT INTO txuNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Je gêdja gwãm kraxje me baje axwe jabej me kukjêr kêtkam memã axwe jarẽ? Kati. Be, Jeju kute kraxje me bamã amijarẽnh kêtkam gu me arỳm 'ã axwe nhôro nhỹ, me bakukràdjà kupa'ã ne gu me 'ã nhôro nhỹ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nhym me arĩk kum, —Djãm gadjwỳ pykabê Garrêjakam ajabatành djà ne ga nêje akabẽno dja? Be, pi'ôkkam ne Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh'õ Garrêjakam abatành kêtkumrẽx. Dja ga amim pi'ôk jarẽn arỳm kôt ikabẽnkumrẽxmã akato. Jejubê Bẽnjadjwỳrbê kumkati kêt. Tãm dja ga pi'ôk jarẽn ama, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nhym kam me kunĩ ajmàn aminhũrkwãmã apêx. ");
INSERT INTO txuNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jeju arỳm krãnhbê Oriwêre 'ỳr tẽ. Tẽ:n arỳm 'ỳr bôx nhym 'ã akamàt nhym nõ. Nõ: nhym arỳm õkrẽn'ãnh kà. ");
INSERT INTO txuNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nhym kam Metĩndjwỳnh nhõ kikreti'ỳr tẽn kam bôx. Nhym kam me kunĩ ajte 'ỳr bôx nhym arỳm nhỹ. Nhỹn arỳm memã kukràdjà jarẽnho nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nhym kam me arỳm Jeju'ỳr me 'õ nireo bôx ne me ipôkri kudja. Arỳm ne mjên ne kam ajte me'õbê mjêno akĩn ar ro'ã nõ. Nhym me arỳm omũn o tỹm ne pa 'amỳn Jeju'ỳr o bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ne kum, —Ẽ, ujarẽnh djwỳnh. Be, me'õ nire ja arỳm mjên ne arỳm me'õ myo akĩn ar ro'ã nõ. Ba me ar nõrkôt ar omũn aro tỹm ne arỳm awỳr o bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Be, me ja jaxwe pãnh ne Môjdjê arỳm memã arẽ. Kute me bakukràdjà jarẽnhkam Môjdjê arỳm 'ã memã kum, —Ga me axwe pãnh kẽno titik ne abĩ gê ty, ane. Be, gadjwỳ ar imã axwe pãnh'õ jarẽ bar kuma. Mỳj gêdja bar on? Nãm me ã Jejumã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mỳj kadjy ne me kum ane? Bir, godja kukràdjà kupa'ã mỳjja jarẽnh jabej nhym me arỳm kôt kum axwe jarẽ. Ja kadjy ne me kum ane. Nhym Jeju ate idjao nhỹn arek ikrao pyka no'ôko nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nhym me mã kum tãmja jarẽ nhym arek pyka no'ôko nhỹ. Nhym kam kàjmã djan memã kum, —Goja me ajõ apydji ajaxwe kêtkumrẽx jabej ga akumrẽx kẽn'õ byn o titik ne abĩ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nãm anen ajte nhỹ, pyka no'ôko nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nhym me arỳm amima:ro djan amijaxwedjwỳ ma. Ne kam arỳm pijàm ne mã apôxo dja. Me abatànhja kumrẽx ne me kato. Nhym mekôt me abatành nydjwỳ apôxo dja. Nhym ajbir abatành nyre meo ino ren kato. Arỳm ne me kunĩ apêx. Nhym kam Jeju arỳm ate nhỹ nhym niredjwỳ arỳm ate dja. ");
INSERT INTO txuNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nhym kàjmã djan nire ate ãmkôt omũn kum, —Me'õ nire, nhỹnh ne me kute amã ajaxwe jarẽnhja ku'ê? Djãm me'õ kute ajaxwe pãnh kẽno atitik prãm kêtkumrẽx? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nhym kum, —Ã bẽnjadjwỳr. Me'õ kute pãnh ititik prãm kêt, ane. Nhym kum, —Badjwỳ. Ajaxwe pãnh ije kẽno atitik prãm kêt. Aj mã. Kwãrĩk wãnh ga ajte ajaxwe kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nhym kam Jeju ajte memã kum, —Be, apỹnh me ba djà kunĩkôt me axwe kunĩ katàt kute amijo ba kadjy ne ije mrãmri ne memã pry kurwỳ djà pyràk. Ga, me kurwỳ djà kute akamàtkam memã pry kurwỳ nhym me kute akamàtkam mỳjja kunĩ pumũnh ne katàt baja pumũ. Badjwỳ dja me tu amim imarkumrẽx ne arỳm katàt amijo ba. Ga, akamàt kô tykkam me kute mỳjja pumũnh kêt ne ba punuja pumũ. Me axwedjwỳ ne me kute mỳjja mar kêt ne amijo ba punu. Djãm me kute tu amim imarkam axwe ne amijo ba punu? Kati. Ba ije mrãmri ne memã pry kurwỳ djà pyràk. Dja me tu amim imarkumrẽx ne arỳm katàt amijo ban kam arỳm ikôt tĩn ne ar ba rã'ã: rã'ã ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nhym mebê pardjêu kum, —Je, djã nãm me'õ akôt kabẽn dji? Kati. Ga apydji aje memã amijarẽnho aba nhym me'õ kute akôt kabẽn djir kêt. Ba me kam arỳm amã akabẽn kajgo jarẽ. Akabẽn kajgo nhym me kute amar kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nhym memã kum, —Kati. Ipydji ije memã amijarẽnhkam ije memã amijarẽnh kajgo kêt. Kàjkwakam Metĩndjwỳnh ne ijano ba amrẽ kabẽn kôt tẽ. Be, 'ỳr dja ba akubyn tẽ. Ja ne ije markumrẽx. Kam ikabẽn kajgo kêt. Nhym be, me ga ne ga me aje imar kêt. Nhỹnhja kurũm ne ba itẽmja ne ga me aje mar kêt. Nhĩ'ãm itẽmdjwỳ ga me aje mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Me ga ne ga me aje amidjwỳnho kĩnh prãm ne aje memã axwe jarẽnho aba. Djãm ba ne ba ije amidjwỳnho kĩnh prãm ne memã axwe jarẽnh got? Kati. ");
INSERT INTO txuNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Godja ba memã axwe jarẽnh jabej arỳm katàt memã arẽnhkumrẽx. Djãm ipydji dja ba arẽ? Kati. Ibãm kute ijanor djwỳnhmẽ dja bar axikôt ikabẽn ne memã axwe jarẽ. Kam ne ije katàt memã axwe jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nhym be, amrẽbê: me bakukãmãre kute me akukràdjà'ã pi'ôk no'ôkdjwỳ. Me akukràdjàja kôt ba ije Ibãmmẽ axikôt memã amijarẽnho iba. Me akukràdjà jakam me'õ ar amãnhkrut ne kute me omũnhkôt kute axikôt me arẽnh nhym me kunĩ kute mar ne kute memã kum, “Mrãmri katàt ar kute me arẽnhkumrẽx”, anhỹrmã. Ja ne ga me arỳm aje mar. ");
INSERT INTO txuNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Be, ja kôt ne ba Ibãmmẽ ã me amã amijarẽnho ane. Ba ije me amã amijarẽnh. Nhym Ibãm kute ijanor djwỳnh ikôt kute me amã ijarẽnh. Ba Ibãmmẽ ar ije axikôt me amã amijarẽnhkam ne ga me ren me akukràdjà kôt ijã, “Mrãmri ne katàt kute memã amijarẽnhkumrẽx”, ane. Ba Ibãmmẽ ar ije axikôt me amã amijarẽnhkam dja ga me ar ikabẽn katàtjamã akaton ama. Me akukràdjà'ã pi'ôk no'ôk kôt dja ga me ima, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nãm ã Jeju memã ane nhym me arỳm kum, —Tô nhỹnh ne abãmja? ane. Nhym memã kum, —Me aje imar kêt ne aje Ibãmdjwỳ mar kêt. Ne ga me ren iman ren Ibãmdjwỳ ma. Nhym be, kati. Aje mar kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Be, Metĩndjwỳnh nhõ kikretikam me kute Metĩndjwỳnhmã pi'ôk kaprĩo atom djàkam ne Jeju ã memã ane. Nhym me'õ kute o tỹm ne pa 'amỳnh kêtkumrẽx. Pa 'amỳnh'ã myt bôx kêt rã'ãkam. ");
INSERT INTO txuNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nhym kam ajte memã kum, —Dja ba ĩ mã tẽ ga me arỳm te ijabej. Te ijabej ne kam arỳm ty. Nhym kam Metĩndjwỳnh me amã ajaxwe jarẽnh rã'ã. Mũm itẽmmã 'ỳr ikràja dja ga me te ikôt 'ỳr atẽm ne 'ỳr abôx prãmje, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nhym mebê idjaer rũnh abenmã kum, —Je tô mỳj dja nẽ? Birãm, dja amibĩ. Nãm me ã abenmã ane. Kute memã kum, —Dja ba ĩ mã tẽ ga me arỳm te ijabej, anhỹrkam ne me ã abenmã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nhym memã kum, —Be, me ga ne ga me pykakam ajapôx ne ar aba. Nhym be, ba ne ba kỳjrũm kàjkwakam ar iba tũm. Me ga ne ga me aje pykakam mỳjjabit mar. Ba ne ba ije kàjkwakam mỳjja mar. ");
INSERT INTO txuNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Me aje pykakam mỳjjabit markam ne ba me amã, “Dja ga me ty nhym Metĩndjwỳnh amã ajaxwe jarẽnh rã'ã”, ane. Ne me amã, “E kum ba. Ba ne ba arỳm bôx”, ane. Dja ga me kam amim imar kêt rã'ã jabej arỳm ty nhym Metĩndjwỳnh me amã ajaxwe jarẽnh rã'ã, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nhym me kum, —Bir, mỳj me ajõ ga nã? Gop me imã amijarẽnhkumrẽx, ba me ama, ane. Nhym Jeju memã kum, —Be, amrẽbê ne ba me amã amijarẽnho iba. Nã bãm me amã, ");
INSERT INTO txuNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","“Be, ije me ajaxwe kumex markam ba ren memã me ajaxwe jarẽn ajte me amã pãnh jarẽ. Be, ijanor djwỳnh kute katàt kabẽn jarẽnhkôt ne ba me kunĩmã arẽnho iba.” Nãm bãm ã me amã ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kute memã kum, “Kute ijanor djwỳnh”, anhỹrkam me kute mar kêt. Kute memã Bãm jarẽnhja me kute mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nhym kam Jeju memã kum, —Ba ije amijo inhĩ ne ibôxja dja ga me kỳjrũm inhô. Kam dja ga me arỳm ima. Ba ije amikabẽnkôt amijo iba kêtkumrẽx. Ibãm kute imã kabẽn jarẽnh kôt ne ba memã arẽnho iba. Ja dja ga me aje kỳjrũm inhôrkam ama. ");
INSERT INTO txuNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kute ijanor djwỳnh ne imẽ amijo kajkep. Djã nãm imã kàx ba ate ar iba? Kati. Be, mỳkam ne imã kàx kêt? Bir, ije o kĩnh kadjy ne ba kum idjàpênh mex rã'ã. Kam imã kàx kêt. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kute memã ja jarẽnhkam ne me kumex arỳm tu amim markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nhym kam mebê idjaer kute tu amim markumrẽxja Jeju memã kum, —Dja ga me mã ikabẽn kôt ar amijo aban 'ã adjukanga kêt ne arỳm me abê ikôt aba djwỳnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ne kam arỳm mrãmri ikabẽnkumrẽxmã akaton ijã amim, “Be, mrãmri ne kabẽn katàtkumrẽx”, anhỹro aba. Ne kam ikabẽn katàtkumrẽxmã akato ba kam arỳm me apytà. Me'õja kute me apa 'amỳnh ga me kum adjàpênh kajgoo abaja ba kubê me apytà. Ga me kam ikôt adjumar mexkumrẽx ne ar aba. Nãm ã Jeju me axwe nhõ bẽnjadjwỳr'ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nhym ajte me kwỳ kum, —Tô nhỹnh ne kam me'õ kute me ipa 'amỳnh ba me kum idjàpênh kajgoo ibaja? Kati. Me ba ne ba me ibê me bakukãmãre Abraão tàmdjwỳ. Nhym kam me'õ kute me ipa 'amỳnh kêtkumrẽx. Mỳkam ne ga, —Ba me'õbê me apytà? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nhym Jeju memã kum, —Mrãmri me ajaxwe prãmkam ne me ajo ba djwỳnhja arỳm kute me apa 'amỳnh ga me arỳm kum adjàpênh kajgokumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ba me amã arẽ ga me ama. Djãm me'õ nhõ kikrekam õ àpênh djwỳnh djãm kubê õ àpênhkam kum àpênh rã'ãmã? Kati. Gêdja ĩ atemã me'õmã apê. Nhym be, kam me'õ krakumrẽxja dja kam kra rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ba ibê Metĩndjwỳnh Kra rã'ãkam ibê me apytàr djwỳnh. Me apa 'amỳnh djwỳnhbê me apytàr djwỳnh. Dja ba me apa 'amỳnh djwỳnhbê me apytà ga me kam mrãmri adjumar mexkumrẽx ne ar aba. ");
INSERT INTO txuNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","We me abê Abraão tàmdjwỳ, ba ije kôt me amar. Ga we me te abê Abraão tàmdjwỳ ne me aje ibĩnmã. Me amã ikabẽn kĩnh kêtkumrẽxkam ne ga me aje ibĩnmã. ");
INSERT INTO txuNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Be, Ibãmmẽ ro'ã ar ibari ije mỳjja pumũnh ne mar. Tãm ne ba me amã arẽ. Me ga ne ga me anhingêt kute amã arẽnh kôt ar amijo aba. ");
INSERT INTO txuNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nhym me kum, —Be, mrãmri me inhingêtbê Abraãokumrẽx, ane. Nhym memã kum, —Ga ren me abê Abraão tàmdjwỳkumrẽx ne ren Abraão djàpênh kôt adjàpênh ar aba. ");
INSERT INTO txuNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nhym be, kati. Ga me jakam aje ibĩnmã. Kàjkwakam Metĩndjwỳnh kute imã kabẽn katàt jarẽnh kôt ije katàt me amã arẽnhkumrẽxkam ne ga me aje ibĩnmã. Djãm ã Abraão meo ane? Kati. ");
INSERT INTO txuNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ne ren Abraãobê me anhingêtkumrẽx ga ren me adjàpênh mex. Nhym be, kati. Atemã me anhingêt djàpênh kôt ne ga me atemã adjàpênh ar aba. Nhym me kum, —Djãm krô'ã me'õ kute akudjwa me ijadjwỳr? Kati. Be, me Ibãm djwỳnh pydji. Kàjkwakam Metĩndjwỳnh, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nhym Jeju memã kum, —Ne ga me ren mrãmri kàjkwakam Metĩndjwỳnho Abãm ne ren amã ijabê. Be, mỳkam? Bir, kàjkwakam Metĩndjwỳnh kurũm ne ba tẽn bôx. Be, djãm ba ne ba tẽ? Kati. Tãm ne ijano ba amrẽ tẽ. Kam ga me ren amã ijabê. ");
INSERT INTO txuNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Be, mỳkam ne ga me aje ikabẽn mar kêt? Bir, me ajamakkre kêt prãmkam. ");
INSERT INTO txuNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Be, me anhingêtbê Xatanaj ne ar me ajo ba. Me anhingêt kum axwe prãm kôt ne ga me amã ajaxwe prãm. Kute amikrax totokbê kubê me par djwỳnh. Ta kabẽn katàt kêtkam kute Metĩndjwỳnh kabẽn katàt 'amỳnh tỳx kêt ne kôt kute amijo ba kêt. Ta 'êxnhĩ kôt memã 'êx ba. Mrãmri 'êxnhĩkumrẽxkam kubê me 'êxnhĩ nhingêt. ");
INSERT INTO txuNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kubê me 'êxnhĩ nhingêtkam ba te me amã katàt ikabẽn jarẽnhkumrẽx ga me aje amim imar kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Be, mỳj me ajõ ga ne ga me aje mrãmri ijaxwe'õmã akatorkumrẽx? Kati. Ga me te: aje ijaxwe'õmã akator prãmje. Ijaxwe'õ kêtkam mỳkam ne ga me aje imar kêt? Ba te ije me amã katàt Metĩndjwỳnh kabẽn jarẽnhkumrẽx ga me aje imar kêt. Be, mỳkam? ");
INSERT INTO txuNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Bir, ne ga ren me abê Metĩndjwỳnh kra ne ren amim kabẽn markumrẽx. Nhym be, kati. Me abê Metĩndjwỳnh kra kêtkam ne ga me aje amim kabẽn mar kêt. Nãm ã mebê idjaer rũnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nhym mebê idjaer rũnh arĩk kum, —Be, abê pykabê Xamarijkam me kra'õ ba me arỳm ama. Me karõ punu ne ari ajo ba, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nhym Jeju memã kum, —Kati. Me karõ punu kute ijo ba kêt. Ba ne ba Ibãm rax jarẽnho iba. Ga me kam imã ikajgo jarẽnho aba. ");
INSERT INTO txuNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Be, djãm ba ne ba amirax jabej? Kati. Atemã 'õ kute irax jabej ne kute me ajaxwe mar. ");
INSERT INTO txuNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mrãmri dja me ikabẽn man kôt ar amijo ban arỳm tykkumrẽx'ỳr bôx prãm kêt. Mrãmri ne ba me amã ja jarẽnhkumrẽx. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nhym mebê idjaer rũnh kum, —Tô nhỹnh? Be, me bakukãmãre Abraão arỳm ty. Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnhdjwỳ ne me arỳm aben kukãm ty. Tô nhỹnh dja me akabẽn man kôt ar amijo ban tyk kêt? Akabẽn jakôt ba me arỳm amã ikaton amarkumrẽx. Mrãmri ne me karõ punu ajo ba. ");
INSERT INTO txuNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Djãm aje araxo me bakukãmãre Abraão jakrenh ne ga aje, “Dja me ikabẽn man kôt ar amijo ban tyk kêt”, anhỹr? Abraão arỳm ty. Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh ar arỳm ty. Mỳj me'õ rax ne ga arĩk o amiptàrn 'ã amimẽnho dja? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nhym Jeju memã kum, —Ne ba ren arĩk amijã me'õ rax mẽn ren mrãmri ikajgo. Nhym be, kati. Ibãm ne kute ijã irax mẽnhkumrẽx. 'Ã ne ga me aje abenmã, “Me Batĩndjwỳnh”, anhỹr kajgoo aban ");
INSERT INTO txuNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","aje mar kêtkumrẽx. Nhym be, bajbit ije markumrẽx. Ne ren ijêxnhĩ ne ren me amã, “Ije mar kêt”, ane. Ne kam ren me akudjwa memã ijêx iba. Nhym be, kati. Mrãmri ije markumrẽx ne kabẽn kôt ar amijo iban ijêxnhĩ kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Be, me anhingêt Abraão arỳm amikukãm iman arỳm ikam kĩnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nhym mebê idjaer rũnh kum, —Je tô, djãm kraxje ajã amex krãptĩbê 50 apêx kêtjakam djãm ga ne ga arỳm me bakukãmãre Abraão pumũ got? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nhym Jeju memã kum, —Be, me akukãmãre Abraão amirĩt kêtri ne ba ar iba tũm, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nhym me arỳm kẽn kwỳ jamỳ, kute o titik ne bĩn kadjy. Nhym Jeju arỳm amijo apdjun mã tẽ. Metĩndjwỳnh nhõ kikreti kurũm katon mã tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tẽ: nhym arỳm me'õ no rã nhỹ. Adjàkamã ne me'õ no rã. Nãm nhỹ nhym arỳm omũ. ");
INSERT INTO txuNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nhym kôt ba djwỳnhdjwỳ omũn Jeju kukij ne kum, —Ujarẽnh djwỳnh, mỳkam ne me'õja adjàkamã no rã? Djãm ta axwe pãnh ne adjàkamã no rã? Nàr nãmẽ bãm ar axwe djô'ã ne no rã? Mỳj ne kam kute? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nhym arkum, —Kati. Ta axwe pãnh no rã kêt. Ne nãmẽ bãm ar axwe djô'ã no rã kêt. Be, Metĩndjwỳnh kute no rãkam àpênh nhym me kute kôt raxmã kator kadjy ne no rã. ");
INSERT INTO txuNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Be, jakam imexri idjàpênh prãmkumrẽx kute mrãmri ne a'uri me àpênh prãm pyràk. Kute ijanor djwỳnh kute idjàpênh'ã imã karõ kôt idjàpênh prãmkumrẽx. Adjỹm, dja me ĩ ijo bikẽnho tẽn ibĩ ba te idjàpênh prãmje. Kute mrãmri ne me akamàt kô tykkam te àpênh prãm pyràk. ");
INSERT INTO txuNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pykakam me axwemẽ ro'ã ar ibari ba ije mrãmri memã pry kurwỳ djà pyràk. Ga, me kute akamàtkam memã pry kurwỳ nhym me katàt baja pumũ. Badjwỳ ne ba memã Metĩndjwỳnh kabẽn jarẽ nhym me arỳm kôt katàt ar amijo ba. Ne tu amim kabẽn markumrẽx ne arỳm katàt ar amijo ba. ");
INSERT INTO txuNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nãm anen arỳm pykakam aptôn kam o ajrên arỳm o me'õ no rãja no djy. Ne kam kum, ");
INSERT INTO txuNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—'Ỳr tẽn ngô nhidjibê Xirôwekam amino ku'õ, ane. Me bakabẽnkam ne me ren ngômã, kute anor jarẽ. Nãm kum ane nhym arỳm 'ỳr tẽn kam amino ku'õ. Ku'õn arỳm no mex ne. No mex ne kam ũrkwã'ỳr tẽn arỳm 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nhym ũrkwã bu'ã me krĩ kute me'õ no rã pumũnh tũm abenmã kum, —Djãm tãmwã ne amijo à'wỳro krĩ? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nhym me kwỳ memã kum, “Nà, tãm”, ane. Nhym me kwỳ memã kum, —Kon, kute tãmwã pyràk, ane. Nhym ta memã kum, “Nà, ba”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nhym me kum, —Tô mỳj me'õ ne amã ano mex jadjà? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nhym memã kum, —Be, me'õbê Jeju ne pykakam aptôn kam o ajrên arỳm o ino djy. Ino djyn arỳm imã, “'Ỳr tẽn ngôbê Xirôwekam amino ku'õ”, ane. Ba kam 'ỳr tẽn amino ku'õn arỳm ino mex ne irĩt mexkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nhym me kum, “Nhỹnh ne dja”? ane. Nhym memã kum, “Kon”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nhym kam me arỳm mebê pardjêu'ỳr o bôx. Me'ỳr me'õ no rãn arỳm no mexjao bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Be, me tyk djà kêt djà nhõ akatikam, pi'ôk ràràrkam ne Jeju pykakam aptôn o ajrên o me'õ no djyn o noo mex. ");
INSERT INTO txuNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nãm me mebê pardjêu'ỳr o bôx nhym me ajte kukij ne kum, —Mỳj ne ga arĩt mex kadjy nẽ? ane. Nhym memã kum, —Nãm pykakam aptôn o ajrên o ino djy ba ku'õn arỳm ino mex ne irĩt mexkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nhym mebê pardjêu kwỳ abenmã kum, —Djãm Metĩndjwỳnh ne tãmwã jano got? Be, me bakukràdjà pãnh ne pi'ôk ràràrkam ari àpênh ba. Axwekumrẽx, ane. Nhym me kwỳ 'ã abenmã kum, —Nhym bê ne me'õ jaxwe kute ã mỳjja pumũnh kêt nhipêxo anhỹr. Kute ã me'õ no rão mexo anhỹr. Nãm me ã Jeju'ã kabẽno aben japanho ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ne kam me'õ no rãn arỳm no mexjamã kum, —Kute amã anoo mexkam 'ã akabẽn'õ jarẽ ba me ama, ane. Nhym memã kum, —Be, kubê Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnh'õ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nhym mebê idjaer rũnh amim mar kêt ne. Nãm me amim, —Je tô djãm mrãmri ne me'õja adjàkamã no rã? Be, kati, ane. Ne kam arỳm bãmmẽ nã ar'ỳr me ano. Nhym me ar'ỳr tẽn arỳm aro bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nhym me arkum, —Be, gar memã kum, “Ikra adjàkamã no rã”, anhỹro aba. Djãm tãm ne ja? Mỳj ne rĩt mex kadjy nẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nhym ar memã kum, —Be, mrãmri ar ikrakumrẽx ne ja. Mrãmri ne adjàkamã no rãkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ne kam mỳj ne arỳm no mex on, ar ije mar kêt. Mỳj me'õ ne kum noo mex nhym rĩt mex, ar ije mar kêt. Be, ta ne arỳm abatành ne. Dja ga me kukja nhym arỳm me amã amijarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Be, mỳkam ne ar kute memã kum, —Jeju ne ar ikra noo mex, anhỹr kêt? Bir, arkum mebê idjaer rũnh pymakam. Nãm me arỳm abenmã Jeju'ã kabẽn djin abenmã kum, —Dja me'õ memã kum, “Be, mrãmri ne Jejubê me banhõ Bẽnjadjwỳrbê kumkatibê Kritukumrẽx”, ane gwaj kôt me nêje kanga gê ajte me bikprõnh djàkam me baro'ã krĩ kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kam ne me kute ar kanga pymaje ar memã, —Be, ta ne arỳm abatành. Dja ga me tãmwã kukja, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nhym kam me ajte amiwỳr me'õ no rãn arỳm no mexja 'uw nhym arỳm 'ỳr bôx. 'Ỳr bôx nhym kum, —Be, me ba ne ba me ije Jeju jaxwekôt mar. Kwãrĩk wãnh ga mex jarẽnh kêt. Kàjkwakam Metĩndjwỳnh ta ne anoo mex. Tãm dja ga kum mex jarẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nhym memã kum, —Be, mỳj Jeju axwe nã? Ije mar kêt. Mrãmri ne arỳm ino rãkumrẽx. Ne arỳm jakam ba mrãmri irĩt mexkumrẽx. Jabit ne ba mrãmri ije markumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nhym kam me ajte kum, —Mỳj ne ajo, ga arỳm ano mex ne arĩt mex ne? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nhym memã kum, —Je, arỳm ne ba me amã arẽ. Djãm me aje imar kêt got ga me ajte: ikukij? Be, mỳj kadjy dja ba ajte me amã arẽ ga me ajte ama. Djãm me aje me kudjwa mã kôt abikamẽnhmã got ga me ikukjêro dja? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nhym me arỳm kum kurên kum, —Be, kati. Ga ne ga arỳm kôt aba djwỳnh. Me ba ne ba me atemã. Me bakukãmãre Môjdjêkôt ne ba me amijo iba. ");
INSERT INTO txuNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Be, Metĩndjwỳnh mrãmri me bakukãmãre Môjdjêmã kabẽnkumrẽx. Ja ne ba me ije markumrẽx. Nhym be, tãmwã. Djãm me kute kator djà mar got? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nhym amipãnh memã kum, —Be:, Jeju ne imã irĩt mex jadjà ga me aje kator djà mar kêtja pumũ. Djãm me ano mex got? ");
INSERT INTO txuNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ba me amã arẽ ga me ama. Djãm me axwe ne Metĩndjwỳnh kute me mar ne kôt àpênh? Kati. Ja ne gu me arỳm baje mar. Nhym be, me kute mrãmri Metĩndjwỳnhmã rax jarẽnh ne kute kabẽn mar ne kôt kute amijo bakumrẽxja Metĩndjwỳnh arỳm kute me mar ne me kôt àpênhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Be, djãm Metĩndjwỳnh Jeju kôt àpênh ngri got ga me 'ã akabẽn ne? Mỳj me'õ ne adjàkamã no rã nhym me arỳm kute kum rĩt mex jadjàr ga me amrẽbê aje mar? Kati. Me bakukãmãre kute arẽnh kêt. Me kunĩ kute arẽnh kêtkumrẽx. Jejubit ne ajbir bajbit ijo mex ga me arỳm aje ipumũnh. ");
INSERT INTO txuNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Metĩndjwỳnh ren kute anor kêt nhym ren kabẽnkôt àpênh kêt ba ren ino mex kêt ne. Nhym be, kati. Mrãmri Metĩndjwỳnh kute anorkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nhym me kum, —Be, djãm akudjwa adjàkamã me ijaxwe? Djãm ajaxwekam aje me ijakre got? ane. Nãm me kum anen kangan arỳm me nêje bõm kumẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nhym kam Jeju me kute bõm mẽnhkôt arỳm kuman 'ỳr tẽn kum katon kum, —Djãm arỳm ga tu amim Metĩndjwỳnh Kra markumrẽx? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nhym kum, —Bẽnjadjwỳr, dja ga imã Metĩndjwỳnh Kra jakre ba tu amim markumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nhym kum, —Arỳm ga ipumũ. Ba. Ba ne ba amã ikabẽno dja, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nhym kum, —Nà, Bẽnjadjwỳr djwỳnh, arỳm ne ba tu amim amarkumrẽx, ane. Ne arỳm kute Metĩndjwỳnh Kramã katorkam amikajgo man parbê ibôn nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nhym Jeju memã kum, —Be, mỳj kadjy ne ba pykakam bôx ne ar iba? Bir, dja ba me kukijn me axwemã ikaton arỳm memã pãnh jarẽ. Be, me kwỳ kute amijo àmran arĩk amim, “Djãm ije Metĩndjwỳnh kabẽn mar ngri got”? anhỹrja dja ba te memã kukràdjà jarẽ nhym me arỳm mar kêt ne arỳm amakkre kêt mex ne ar ba. Me kute mrãmri ne me rĩt mex arỳm no rãn ba pyràk. Nhym be, me kwỳ kute kukràdjà mar kêt ne mar prãm dja ba memã arẽ nhym me arỳm tu amim markumrẽx. Tu amim markumrẽx ne arỳm kôt kute amijo ba mexkumrẽx. Me kute mrãmri ne me no rã arỳm rĩt mex ne katàt ba pyràk. Ja kadjy ne ba pykakam bôx ne ar iba, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nhym mebê pardjêu bu'ã ku'êja arỳm kabẽn man kum, —Je, djãm me badjwỳ ne ba me ije me no rã pyràk? Kati. Djãm me ije Metĩndjwỳnh kukràdjà mar ngri got? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nhym memã kum, —Ne ga ren me aje Metĩndjwỳnh kukràdjà mar prãm ne ren aje mrãmri ne me no rã rĩt mex prãm pyràk. Ne kam ren ajaxwe kêt ne. Nhym be, kati. Me aje, “Me badjwỳ djãm me ije Metĩndjwỳnh kukràdjà mar ngri got”? anhỹrkam me ajaxwe rã'ã. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ne kam mrykĩ'ãtomti'ã memã ajarẽn õ me ja'ã mrykĩ'ãtomti jakren memã kum, —Be, õ kôkayrkam mrykĩ'ãtomti ar bakam nhym me ngjêx prãmkam me kwỳ ajkwa krekrekôt ngjêx kêt ne ate kôkayr nhibũm kôt wangij. Be, me ja ne me mryo àkĩnh prãm nhym me me'ã memã kum, “Me àkĩnhĩ”, ane nàr, “Mebê mỳjjao prõt djwỳnh”, ane. Mrãmri ne ba me amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nhym be, me kute katàt ajkwa krekrekôt ngjêxjabê ne õ mryo ba djwỳnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nhym 'ã ijê djà nêje ku'ê djwỳnh arỳm o ba djwỳnhmã 'ã ijê djà'ã kurê nhym arỳm wangij. Ne kam mrymã kabẽn nhym arỳm amim kabẽn ma. Kute apỹnh mrymã idji jarẽnh djàri aben totokmã mrymã arẽ nhym arỳm kute apỹnh aminhidji jarẽnh mar kôt bõm rôrôk. Bõm rôrôk nhym o ba djwỳnh arỳm kapôtmã mryo apôx. ");
INSERT INTO txuNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mryo apôx ne arỳm mry kukãm mrã nhym mry arỳm kôt ba. Kute amim o ba djwỳnh kabẽn markam kôt ba. Nãm mry ã o ba djwỳnh kôt ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nhym be, atemã me bajtem mry'ỳr bôx ne te mrymã kabẽn nhym kôt ba kêt ne tu mã kubê prõt ne. Kute amim me bajtem kabẽn mar kêtkam amijã no tỳx ne tu mã kubê prõt ne. Mrãmri ne ba me amã ja jarẽnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Be, mrykĩ'ãtomti'ã ujarẽnhja ne Jeju kute amikabẽn kukràdjà'ã akre nhym me mrybit man kukràdjà mar kêt. Nãm me te: kute mỳj'ã ujarẽnh kute amijakre marmãn te: kute kukràdjà marmã. ");
INSERT INTO txuNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","9","Nhym ajte memã kum, —Mrãmri ije mrykĩ'ãtomti nhõ kôkayrkôt ajkwa krekre pydji pyràk. Ga, mryo ba djwỳnh kute ajkwa krekrekôt mryo ngjêxja pumũ. Nhym kôkayr tỳx arỳm kute mỳjja djàkrêbê mry pytàr nhym umar mexja pumũ. Badjwỳ ije ajkwa krekre pydjimãn pràbê dja me tu amim imarkumrẽx ba arỳm axwebê me utà. Nhym kam me arỳm ikôt tĩn ne ar ba rã'ã: rã'ã ne. Atemã me'õkôt ne me tĩn kêtkumrẽx. Dja me tu amim bajbit imarkumrẽx ba arỳm me utà. Ga, mryo ba djwỳnh kute kôkayr kurũm mryo apôxja pumũ. Nhym mry àkur ban ajte akubyn ngjêxja pumũ. Badjwỳ dja ba me utàro iba nhym me ikôt umar mex ne ar ba. Nhym be, amrẽbê ibôx kêtri ne me kwỳ Metĩndjwỳnh'ã 'êx ne memã kum, “Metĩndjwỳnh ne imã arẽ ba kukwakam amã kabẽn jarẽnho iba”, ane. Me Metĩndjwỳnh'ã 'êxja kunĩ ne me àkĩnhĩ. Me kute amiwỳr inhõ me jao akẽxmãn te meo ane nhym me kute me kabẽn mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Be, me àkĩnhĩ ne me kute mryo àkĩnh ne par kadjy bôx. Nhym be, kati. Ba ne ba atemã. Me tĩnkumrẽx ne umar mexkumrẽx kadjy ne ba bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ije me kute mrykĩ'ãtomtio ba djwỳnh mex pyràk. Dja ba me kadjy ty. Ije me utàr kadjy ty. ");
INSERT INTO txuNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nhym be, me mrykam àpênh djwỳnh ne me atemã. Gêdja rop'õ mry'ỳr bôx nhym arỳm tĩn prãmje tu mry kangan prõt ne. Kubê õ mry djwỳnh kêtkam ne tu mry kangan mã prõt ne. Nhym rop arỳm mryo rôrôk nhym mry abenbê ajmà. ");
INSERT INTO txuNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Me mrykam àpênh djwỳnh kute pi'ôk kaprĩbit markam ne me kum mry jabê kêt. Nhym kam rop bôx nhym kum mry jabê kêtkam arỳm mry kangan prõt ne. ");
INSERT INTO txuNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ba ije me kute mryo ba djwỳnh mex pyràk. Ibãm kute imarkumrẽx. Badjwỳ ije Ibãm markumrẽx. Inhõ me jadjwỳ ije ã me maro ane. Nhym inhõ me jadjwỳ kute imar. Ba dja ba me kadjy ty. Ije me utàr kadjy ty. ");
INSERT INTO txuNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Djãm kôkayr jakambit inhõ krit? Kati. Onĩj inhõ krit rã'ã. Me wãdjwỳ dja me amim ikabẽn ma. Dja ba inhõ me jamẽ me wãdjwỳo aben pydji. Kam arỳm inhõ me kunĩo iba. ");
INSERT INTO txuNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Be, mỳkam ne Ibãm kum ijabê? Bir, ije kabẽn kôt amijo ibakam. Kam ne kum ijabê. Ba dja ba ty. Akubyn itĩn kadjy dja ba ty. ");
INSERT INTO txuNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Djãm me ta dja me ibĩ? Kati. Ba dja ba amikabẽnkôt tyn kam amikabẽnkôt akubyn itĩn ne. Ibãm ta ne ityk ne akubyn itĩn'ã imã karõ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nãm Jeju memã ane nhym kam mebê idjaer rũnh ajte kabẽno aben japanho dja. ");
INSERT INTO txuNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Me krãptĩ ja ne me arĩk memã kum, —Be, me karõ punu ne o ba. Ga, kute kukwakam kabẽn kajgo krãptĩ jarẽnhja pumũ. Mỳkam ne ga me kabẽn maro dja? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nhym me kwỳ ja ne memã kum, —Nhym bê ne me karõ punu kute o ba nhym ã kabẽn kute anhỹr. Be, kati. Kabẽn mexkumrẽx. Djãm me karõ punu kute me no rã noo mex mar got? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Be, krĩraxbê Djeruxarẽkam, me krãptĩ kute aben pydji djà nhõ akatikam, arỳm na nhõ mytyrwỳkam, Jeju me'ỳr tẽn bôx ne arỳm Metĩndjwỳnh nhõ kikretikam ar mrã. Me kute aben kajmã'ã me bakukãmãre kute amrẽbê: Metĩndjwỳnhmã kikreti ny nhipêx mar kadjy ne me krãptĩ akati jakam aben pydji. ");
INSERT INTO txuNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jeju kikreti bu'ã kikre kre kênhkam ar mrã. Kikre kre kênhjamã ne me kum, “Xaromão nhõ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nãm kam ar mrã nhym mebê idjaer rũnh arỳm omũn kam kum ipôk ne kum, —Aje. Ga mrãmri abê me inhõ Bẽnjadjwỳrbê kumkatibê Kritukumrẽx jabej tu me imã amijarẽnho amirĩtkumrẽx. Mỳkam ne ga me ibê amipdju? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nhym Jeju memã kum, —E kum arỳm ne ba me amã amijo amirĩt ga me aje amim imar kêt. Ibãm kukwakam ije apỹnh mỳjja pumũnh kêt nhipêx djàri. Tãm ne kute me amã ijo amirĩt mexkumrẽx ga me aje amim imar kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Be, me abê inhõ krit kêtkam ne ga me aje amim imar kêt. Arỳm ba me amã ja jarẽ ga me arỳm ama. ");
INSERT INTO txuNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Inhõ krit ar kute amim ikabẽn mar. Badjwỳ ije inhõ krit ar mar nhym ar mã ikôt ar amijo ba. ");
INSERT INTO txuNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Dja ba memã tĩn jadjà nhym me Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. Ne me biknor tokry djàkam biknor kêtkumrẽx. Ba mã meo iba nhym me'õ kute ibê me pa 'amỳnh ne ibê me ikô rênh prãm kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ibãm kute ikôt me kamẽnhja ne tỳxo kute me kunĩ jakrenh. Tãm ne mã meo ba nhym me'õ kute kubê me pa 'amỳnh ne kubê me ikô rênh prãm kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ibãmmẽ ro'ã ne bar itipdjin ar iba. Nãm ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nhym mebê idjaer rũnh ajte kadjy kẽn jamỳ. Kute o titik ne bĩnmã kẽn jamỳ. ");
INSERT INTO txuNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nhym memã kum, —Ibãm kukwakam ne ba mỳjja mex krãptĩ nhipêx ne me amã o amirĩt ga me omũ. Nhỹnh idjàpênh mexja pãnh dja ga me kẽno ititik ne ibĩ? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nhym me kum, —Djãm adjàpênh mex pãnh ne ba me ije kẽno atitik ne abĩnmã? Kati. Metĩndjwỳnh ne ga arỳm aprỳ. Abê pykakam me'õkam ne ga ga amijo ajêx ne amijo Metĩndjwỳnh Kra ne amijo Metĩndjwỳnh pyràk. Aje Metĩndjwỳnh raxo amiptàrkam ne ba me arỳm Metĩndjwỳnho ingryk ne ije abĩnmã, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nhym amipãnh memã kum, —Tô nhỹnh ne ba aprỳ? Be, kukwakam kabẽn jarẽnh djwỳnh ne me bakukãmãremã Metĩndjwỳnh kabẽn jarẽn memã kum, “Nã bãm memã kum, ‘Me abê metĩndjwỳnh’, ane.” Nãm ã me bakukãmãremã anen arỳm 'ã pi'ôk no'ôk ne. ");
INSERT INTO txuNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Metĩndjwỳnh kabẽn ne ga me te akabẽno aje o adjàpanhmã. Ga, Metĩndjwỳnh ta kute memã kum, “Me abê metĩndjwỳnh”, anhỹrja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Metĩndjwỳnh ta ne imã idjàpênh djà jarẽn pykamã ijano ba kabẽn kôt amrẽ tẽn bôx. Djori kam ibê Metĩndjwỳnh Kra kêt? Kati, ibê Metĩndjwỳnh Krakumrẽx. Djori kam ba aprỳ. Arkati. ");
INSERT INTO txuNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ne ba ren Ibãm djàpênh o idjàpênh kêt ga ren me aje katàt imã ikajgo jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nhym be, kati. Mrãmri Ibãm djàpênh o idjàpênhkumrẽx. Kam ga me ren amim idjàpênhbit ma. Aje amim ba imar kêtkam ga ren idjàpênhbit man ren Ibãm djàpênh o idjàpênhja man ren arỳm kam ima. Ibãmmẽ ne bar itipdjin ar iba ga me ren kam arỳm ama, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nãm memã ane nhym me arỳm kute pa 'amỳnhmã te o ane nhym mã mebê katon tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ne kam arỳm mã ngô raxbê Djodão nhijukri tẽ. Tẽ:n arỳm Djuão kute ngômã me angjênhmo krax djàkam bôx ne arek kam ar ba. ");
INSERT INTO txuNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ar ba nhym me krãptĩ 'ỳr bôx ne abenmã kum, —Be, Djuão ne me kute raxmã kator kadjy kute mỳjja pumũnh kêt'õ nhipêx kêt. Kute me punuo mex kêt. Ne kam mrãmri katàt me'õja kukãm 'ã ujarẽnhkumrẽx. Nhym kam arỳm kute kukãm 'ã ujarẽnh kôt prĩne kôt amijo bakumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nhym kam me krãptĩ pyka jakam tu amim Jeju markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Be, me'õ nhidjibê Radjaru ne arỳm kanê bĩno mõ. Kanikwỳnh ne ar amãnhkrut. Ar idjibê ne Marijmẽ Mata ar. Ne ar kunĩ krĩbê Betanhakam ũrkwã. ");
INSERT INTO txuNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Marij ja kute Bẽnjadjwỳr djwỳnh par'ã me kudjỳ djà kangô kapĩ. 'Ã me tyk kadjy kudjỳ djà kangô kapĩn kam kute amikĩo 'ã kangô ngrà tãm. ");
INSERT INTO txuNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nãm kamy Radjaru arỳm kanê bĩno mõ: nhym kanikwỳnh ar arỳm Bẽnjadjwỳr djwỳnh'ỳr me'õ jano. Onĩ:j. Nhym arỳm 'ỳr tẽ:n 'ỳr bôx ne arỳm kum arẽn kum, —Bẽnjadjwỳr djwỳnh, onĩj amã anhõbikwa jabêja arỳm kanê: nhym kanikwỳnh ar amã arẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nhym Jeju arỳm kuman kum, —Djãm tu tyk rã'ã kadjy ne kanêja? Kati. Dja me kàjkwakam Metĩndjwỳnh raxmã katon ba ibê Metĩndjwỳnh Kra iraxmã kato. Ja kadjy ne kanê raxja, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Be, Matamẽ kanikwỳnhmẽ Radjarumẽ ne Jeju kum ar abê. ");
INSERT INTO txuNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nãm Jeju kabẽn man kam tu arek ỹr djàkam nhỹ nhym 'ã akati amãnhkrut apêx. ");
INSERT INTO txuNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nhym kam kôt ba djwỳnhmã kum, —Gwaj on pykabê Djudêjamã tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nhym ar kum, —E kum, ujarẽnh djwỳnh, wãkam ajbir mebê idjaer rũnh kute kẽno atitik ne abĩnmã ga ajte 'ỳr atẽmmã, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nhym Jeju arkum, —Djãm arngro pydjikam kàxdjàkênh pa ipôkbê 12bit. Nà tãm. Djãm ori me arngrokam mrã nhym mỳjja'õ me par tok? Kati. Arngrokam ne mỳjja amirĩt nhym me omũn aà'ã mrã. ");
INSERT INTO txuNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nhym be, akamàtkambit ne me ba punu, arĩk rôrôk ba, me nokrekam irã kêtkam, ane. Me kute o tỹm ne bĩn kêtri tẽmbê kute àpênh inomã mẽnhmã ne amijã arngro jakreo tẽn me kute o tỹm ne bĩn'ã akamàt jakre. ");
INSERT INTO txuNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nãm arkum anen kam arkum, —Be, gwaj banhõbikwa Radjaru arỳm õto nõ. Arỳm ba ije tokmã ne ba 'ỳr tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nhym ar kum, —Dja õto nõrkam akubyn mex, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Be, djãm mrãmri õtkumrẽx'ã ne arkum ane? Be, kati. Arỳm tyk'ã ne arkum ane. Nhym ar arĩk amim, —Be, õtkam tyk djà kêt'ã ne ã ar imã ane, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nhym kam arkum arẽnho amirĩtkumrẽx ne arkum, —Be, Radjaru ne arỳm ty. ");
INSERT INTO txuNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Wãkam idjãm kêt nhym arỳm ty. Kam idjãm kêtkam ar akadjy ikĩnh. Jakam dja gwaj wãkam tẽn bôx gar arỳm mỳjja pumũn arỳm tu amim imarkumrẽx. Ar akadjy ne ikĩnh. Aj gwaj on 'ỳr, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nhym kam Jejukôt ba djwỳnh 'õ nhidjibê Tôme Djidjimuja kôt ba djwỳnh 'õdjwỳmã kum, —Gwaj on badjwỳ kôt ty, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nhym kam Jeju ar arỳm 'ỳr tẽ. 'Ỳr tẽ:n arỳm 'ỳr bôx. Nhym me arỳm kum arẽn kum, —Be, arỳm ne ty ba me adjà. Nhym arỳm 'ã akati amãnhkrut ne amãnhkrut apêx ga bôx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Be, krĩbê Betanhamẽ krĩraxbê Djeruxarẽmẽ ne aben jatãri. Abenwỳr pry'ã akrebê kirometu amãnhkrut ne ikjêkêtbit. ");
INSERT INTO txuNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kam ne mebê idjaer krãptĩ Matamẽ Marij ar'ỳr bôx. Ar kamy arỳm tykkam me kute ar kaprĩ, ar mỳr, ar amakbê arkum kabẽnmã ar'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nhym Jeju ar bôx 'ỳr nhym me'õ arỳm Matamã arẽ. Nhym kàjmã djan ate kutã tẽ. Nhym be, Marij arek nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata Jeju kutã tẽn arỳm kajpan kum, —Bẽnjadjwỳr djwỳnh, ga ren pyka jakam arek ar aba nhym ren ikamy tyk kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Gêdja ga mỳjja'õo Metĩndjwỳnhmã a'uw nhym arỳm akabẽn man prĩne akabẽn kôt ipêx ne. Tãm ne arỳm ije mar, ane. Nhym kum, ");
INSERT INTO txuNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Dja atõ akubyn tĩn, ane. Nhym kum, ");
INSERT INTO txuNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Nà, me kunĩ kute aminhinomã amimẽnh djà nhõ akatikam dja me tyk akubyn tĩn. Nhym mekôt dja ikamy akubyn tĩn. Tãm ne arỳm ije mar, ane. Nhym kum, ");
INSERT INTO txuNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","—E kum, ba ne ba ibê akubyn me tyko tĩn djwỳnh ne ije memã tĩn jangjênh djwỳnh. Me kute tu amim ikamnhĩxkumrẽx dja me tĩn ne. Dja te tyn Metĩndjwỳnhkôt tĩn ne ar ba rã'ã: rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nhym me tĩn ne ar ba kute tu amim ikamnhĩxkumrẽx dja me Metĩndjwỳnhkôt tĩn ne tyk kêtkumrẽx. Djã ne ga tu amim ikabẽnja markumrẽx? ane. Nhym kum, ");
INSERT INTO txuNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Nà, Bẽnjadjwỳr djwỳnh, abê Kritukumrẽx. Mrãmri ne Metĩndjwỳnh ajã me inhõ Bẽnjadjwỳrbê kumkati mẽnhkumrẽx. Me bakukãmãre kute amrẽbê: memã kum, “Gêdja ĩ Metĩndjwỳnh Kra pykamã bôx”, anhỹr kôt ga arỳm bôx ne kam abê Metĩndjwỳnh Krakumrẽx. Tãm ne ba tu amim markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nãm ã kum anen kam akubyn kanikwỳnh'ỳr tẽ. 'Ỳr tẽ:n arỳm 'ỳr bôx ne me kàxã kum, —Arỳm ne memã ujarẽnh djwỳnh bôx ne amã kabẽn. ");
INSERT INTO txuNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nãm kum ane nhym kàjmã djan amibêx ne 'ỳr tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Be, kraxje Jeju krĩmã àr kêt. Nãm arek Mata kute kajpar djàkam arek dja. ");
INSERT INTO txuNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nhym Marij kàjmã djan amibêx ne tẽ nhym kikrekam mebê idjaer kute ar kaprĩbê arkum kabẽno ãmja arỳm abenmã kum, —Be, ar mỳrmã ne ar kẽnkre'ỳr tẽ, ane. Nãm me anen arỳm kôt tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nhym be, Marij Jeju'ỳr tẽ nhym arek kam dja nhym arỳm 'ỳr bôx. Ne omũn arỳm kõnkrão nhỹn kum, —Bẽnjadjwỳr djwỳnh, ga ren pyka jakam ar aba nhym ren ikamy tyk kêtkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nãm mỳro nhỹ nhym kôt mebê idjaer mõrja kôt mỳro dja. Nhym Jeju me omũn arỳm rerekren tik ngyo dja. ");
INSERT INTO txuNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ne kam memã kum, —Nhỹnh ne ga me adjà? ane. Nhym me kum, —Bẽnjadjwỳr djwỳnh, amrẽ ar ikôt tẽn omũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nhym Jeju arỳm muw. ");
INSERT INTO txuNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nhym mebê idjaer abenmã kum, —Be, kum abêkumrẽx. Ga, arỳm mỳrja pumũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nhym me kwỳ abenmã kum, —E kum, me no rãmã ne rĩt mex jangij. Nok ren Radjarudjwỳo mex nhym ren tyk kêt ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nhym kam Jeju 'ỳr tik ngy tẽn arỳm kẽnkre'ỳr bôx. Kẽnpotio ne me arỳm kẽnkre'ã ijê. ");
INSERT INTO txuNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nãm kẽnkre'ỳr bôx ne memã kum, “Me 'ã kẽnpoti kaba”, ane. Nhym tyk kanikwỳnh Mataja kum, —Ô kum arỳm kro:. Tyk'ã arỳm akati amãnhkrut ne amãnhkrut apêx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nhym Jeju kum, —Ẽ, arỳm ne ba amã, “Dja ga tu amim ikamnhĩxkumrẽx ne arỳm Metĩndjwỳnh raxmã akato”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nhym me arỳm kẽnkre'ã jãm kẽnpoti dja. Nhym Jeju kàjmã krãn kàjkwa jabẽn Bãmmã kum, —Djũnwã. Ga ne ga arỳm aje ikabẽn mar. Kam ikĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Amã ikabẽn kunĩkôt ne ga arỳm aje ikabẽn mar. Be, me ibu'ã ku'ê ja amã ikabẽnkôt kute imar kadjy ne ba amã ikabẽn. Dja me tu amim imarkumrẽx ne ijã amim, “Be, mrãmri ne Metĩndjwỳnh kute anorkumrẽx”, anhỹro ba. Ja kadjy ne ba amã ikabẽn, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nãm anen arỳm kàj bê kabẽn ne kum, “Radjaru, amrẽ akato”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nhym arỳm me aêrbê akubyn tĩn ne kato. Arỳm tu tykkumrẽx ne jakam arỳm akubyn tĩn ne kato. Prĩne kubẽkào ikramẽ par'ã kupu rã'ãn kato. Kubẽkào nokre kupu rã'ãn kato. Nhym Jeju memã kum, —Me 'ã kubẽkà bô gê tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jeju akubyn Radjaruo tĩn nhym mebê idjaer omũ nhym arỳm kwỳ krãptĩ tu amim Jeju markumrẽx. Marijkôt me mõrja tu amim markumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nhym me kwỳ ja arỳm amũ mebê pardjêu'ỳr mõn memã Jeju jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nhym kam me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebê pardjêu arỳm me rũnho akuprõ. Nhym kam me abenmã kum, —Be, mỳjja pumũnh kêt kwỳ rax ne ipêx. Me kute raxmã kator kadjy ne ipêx. Nãm me punu krãptĩo mex ne akubyn me tyko tĩn. Mỳj dja gu me nẽ? ");
INSERT INTO txuNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Dja gu me amitô nhym me kunĩ arỳm tu amim markumrẽx ne kôt ar amijo ba. Dja me ane nhym krĩraxbê Rômakam me õ me ja arỳm me bawỳr prõt ne pyka mẽ Metĩndjwỳnh nhõ kikretio amràn aben bê me babê idjaer kunĩ ngrà, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nhym me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr raxbê Kajbajja ne amexja tãmkam memã nhỹ. Kajbaj memã kum, —E kum, me aje mỳjja mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Me'õ pydji dja me babê idjaer kunĩ pãnh ty. Kam dja me abenbê me bangrành kêt gu me arỳm badjumar mex. Me aje ja mar kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Be, djãm Kajbaj ta ne amikabẽn jarẽ? Kati. Metĩndjwỳnh kukwakam ne kabẽn jarẽ. Amexja tãmkam ne kubê me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr rax. Bẽnjadjwỳr rax ne Metĩndjwỳnh mar djwỳnh kunĩmã nhỹ. Kunĩmã ỹrkam ne arỳm memã Metĩndjwỳnh kabẽn jarẽ. Kute memã Jeju mebê idjaer kunĩ pãnh tyk jarẽnhkam ne memã Metĩndjwỳnh kabẽn jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Be, djãm mebê idjaerbit pãnh dja ty? Kati. Metĩndjwỳnh kraja amrẽbê abenbê me bimành. Apỹnh me bajtem ba djàkam me bimành. Jeju kute amikôt me jao aben pydjimã. Me jadjwỳ pãnh dja ty. 'Ã ne Kajbaj kute Metĩndjwỳnh kukwakam kabẽn jarẽnhja. ");
INSERT INTO txuNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Be, krax ne ja. Me kute Jeju bĩn kadjy kute aben kabẽn marmo krax djà ne ja. Jeju kute akubyn Radjaruo tĩn nhõ akati jakam. ");
INSERT INTO txuNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nhym kam Jeju kute ja nhijukri mebê idjaer rũnhmã amijo amirĩto ba kêt. Kapôt kukrit nokà'ã ar bamã ne arỳm tẽ. Kam ne arỳm krĩbê Epraĩmã tẽn bôx ne kôt ba djwỳnhmẽ ro'ã kam ar ba. ");
INSERT INTO txuNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nhym kam mebê idjaer kute aben pydji djà 'ỳr. Me kute me kukãmãre nhirôbê mrãnhja mar kadjy arỳm õ akati 'ỳr. Kam ne me krãptĩ: kadjy krĩraxbê Djeruxarẽ'ỳr àbir mõ. Me kute Môjdjê kukràdjà kôt Metĩndjwỳnhmã amijaxwe jarẽnhmã ne me mõ. ");
INSERT INTO txuNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ne kam arỳm bôxo dja nhym me rũnh arỳm Jeju jabej. Ne Metĩndjwỳnh nhõ kikretikam abenmã kum, —Djãm me krãptĩ kute aben pydji djà nhõ akati kadjy mekôt bôxmã? Djã ne ga me ajõ ama? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Be, arỳm me kute Jeju'ã memã karõ. Me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳrmẽ mebê pardjêumẽ ne me arỳm 'ã memã karõn memã kum, —Dja ga me ajõ Jeju pumũn me imã arẽ ba me pa 'amỳ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Me Djeruxarẽkam Jeju jabej nhym arỳm ajte krĩbê Betanhakam bôx. Betanhakam ne Radjaru ar ba. Amrẽbê ne ty nhym Jeju 'ỳr bôx ne akubyn o tĩn. Ne jakam Jeju ajte Betanhakam bôx. Nhym amũ Djeruxarẽkam Metĩndjwỳnh me irôbê mrãnh nhõ akati bôx 'ỳr. Dja akati amãnhkrut ne amãnhkrut ne amãnhkrut apêx nhym arỳm akati bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nãm Jeju Betanhakam bôx nhym arỳm amykry. Nhym Mata ar arỳm kum õ kwỳ krẽn djà nhipêx. Ipêx nhym Jeju ar krẽno nhỹ. Mata ne arkum õ kwỳ krẽn djà nhõro dja. Radjarumẽ ro'ã ne ar àkuro nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Àkuro nhỹ nhym Marij arỳm me kudjỳ djà kangô ipuja by. Me tyk kadjy ne kudjỳ djà. Kangô nhidjibê ne nadu. Utĩ'ã akrekam ne kubê kiru kute o katẽ 'ỳr ne kam pãnh raxkumrẽx. Nãm ar àkuro nhỹ nhym Marij arỳm kangôja byn Jeju par'ã kapĩ. 'Ã kapĩ ne amikĩo arỳm par'ã kangô kwỳ ngrà. Nhym kam arỳm amũ kikre krekôt kudjỳ prõt ne. ");
INSERT INTO txuNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nhym Djuda Ikadji. Ximão kute ir ja. Jejukôt ba djwỳnhja. Tãmja dja kurê djwỳnhmã Jeju kanga. ");
INSERT INTO txuNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Marij Jeju par'ã kangô kapĩ nhym Djuda arkum, —Je tô, mỳkam ne arỳm kangô mexjao akno? Ne ga ren ar memã kangô ngãn ren pãnh pi'ôk kaprĩ kumex ne aby. Ne ren pãnh'ã akrekam denarju kubê 300 ne ren abyn kam ren me õ mỳjja kêtmã angrà, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Be, djãm Djuda kum me bikẽnh kaprĩkam ne ã arkum ane? Kati. Àkĩnhĩkam. Kubê ar õ pi'ôk kaprĩo ba djwỳnhkam. Ne kam ta amim kwỳo àkĩnho ba. Kam ne ã arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nhym Jeju arkum, —Kwãrĩk wãnh rã'ã. Mỳj kadjy ne amim kangô dji? Bir, dja ba ty nhym me arỳm ijadjà. Kute ijã kangô kapĩnkam dja ba ikudjỳ nhym me ijadjà. Ja kadjy ne amim kangô dji. ");
INSERT INTO txuNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ar aje memã mỳjja nhõrmã wãnh ne me õ mỳjja kêt ar abu'ã ar ba rã'ã. Dja gar anen arỳm memã mỳjja ngã. Badjwỳ. Djãm arek gwaj baro'ã ar baba rã'ãmã? Kati. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jeju Betanhakam ar ba: nhym kam mebê idjaer krãptĩ arỳm kuman 'ỳr bôx. Djãm me kute Jejubit pumũnhmã ne me 'ỳr bôx? Kati. Radjarudjwỳ. Jeju kute Radjaru tyk akubyn o tĩnkam ne me kute adjwỳnhdjwỳ pumũnhmã 'ỳr bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nhym be, me kadjy Metĩndjwỳnh mar djwỳnh nhõ bẽnjadjwỳr ne ar atemã. Nãm ar bit kute Radjaru bĩnmã 'ã aben maro nhỹ. ");
INSERT INTO txuNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Be, mỳkam? Bir, Jeju kute akubyn Radjaruo tĩnkôt mebê idjaer krãptĩ arỳm omũn tu amim Jeju markumrẽx. Nhym kam me kute omũnh kêt kadjy ar kute Radjarudjwỳ bĩnmã. Nhym Jeju Betanhakam ar ba nhym kam 'ã akati. 'Ã akati nhym Jeju amũ Djeruxarẽ'ỳr tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nhym kam me Djeruxarẽkam kukãm abenmã kum, —Arỳm Jeju bôx 'ỳr. Arỳm Jeju bôx 'ỳr, ane. Me krãptĩ kute aben pydji djà nhõ akati kadjy bôxja ne me ã abenmã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ne kam mõn bô kwỳ nhikẽ. Me kute o Jeju kajpar kadjy ne me arỳm kutã mõ. Ne kàj bê abenmã Jeju mexo àkjêr mõn mã memã kum, —Jejubê ne me banhõ bẽnjadjwỳr rax. Ãm mexkumrẽx. Kam me bakĩ:nhkumrẽx. Gê on me bapytà. Gê Bẽnjadjwỳr djwỳnh o kĩnh rax. Kukwakam ne arỳm me bakadjy bôx. Ãm mexkumrẽx. Me babê idjaer nhõ bẽnjadjwỳr rax ne arỳm bôx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Me kute o anhỹr kêtri ne Jeju mry'ã nhỹ. Nãm mry'ã krĩ jabatành nyremã katon 'ã nhỹ. Amrẽbê: ne me Metĩndjwỳnh kukwakam me bakukãmãremã ja jarẽn memã kum, ");
INSERT INTO txuNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ẽ krĩraxbê Xijãokam me ja, kwãrĩk wãnh me atĩn prãm kêt. Ota, me anhõ bẽnjadjwỳr rax bôxmã. Dja mry'ã krĩ jabatành nyre'ã nhỹn me awỳr bôx.” Nãm me ã me bakukãmãremã anen arỳm 'ã pi'ôk no'ôk ne. Nhym me aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã tũ:mràm me bakamingrãnyrekam arỳm 'ỳr o bôx. Jeju mry'ã nhỹn arỳm Djeruxarẽ'ỳr bôxmã tẽmkumrẽx. Djeruxarẽ nhidji nhikjêbê ne Xijão. ");
INSERT INTO txuNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nãm 'ỳr tẽ nhym me o àkjêr mõ. Nhym kôt ba djwỳnh ar kute omũnh totokbê amim, —Je tô, mỳj'ã ne me kute Jejuo àkjêrja? anen mar kêt ne. Arỳm Jeju àbir ne ra:xkambit dja ar akubyn pi'ôk kôt amijo tẽn arỳm kuma. Be, pi'ôkkam me kute Jejuo anhỹrmã kôt ne me arỳm jakam ã Jejuo ane. Ja dja ar kuma. ");
INSERT INTO txuNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Be, Jeju kutã me mõrja ne me amrẽbê Jeju kute akubyn Radjaruo tĩnkôt omũ. Kute kum kabẽn nhym kẽnkre kurũm katorkôt ne me omũ. Ne kam amũ memã 'ã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nhym me krãptĩ arỳm kute akubyn o tĩnja man kam arỳm adjwỳnhdjwỳ mekôt Jeju kutã mõn kajpa. ");
INSERT INTO txuNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Me krãptĩ: Jeju kutã mõn kajpa. Nhym kam mebê pardjêu arỳm abenmã kum, —Be ga, pyka kunĩkôt me kunĩ arỳm kute 'ỳr amijo akẽxja pumũ. Me baje te: mebê Jeju pyma nhym me mã kum kĩnhja pumũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nhym kam me bajtembê kreguja kwỳ ne me me krãptĩ kôt ar ba. Me kute mekôt me kute aben pydji djà nhõ akatikam Metĩndjwỳnhmã rax jarẽnh kadjy ne me bôx ne mekôt ar ba. ");
INSERT INTO txuNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ne kam arỳm Piripi'ỳr bôx ne kum, “Ba me Jeju pumũ”, ane. Piripi ne pykabê Garrêjakam krĩraxbê Bexadakam abatành djà. ");
INSERT INTO txuNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Me kum ane nhym amũ Ãngre'ỳr bôx ne kum arẽ. Nhym kam ar ro'ã Jeju'ỳr tẽn kum arẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nhym Jeju arkum, —Be, arỳm ityk'ã akati bôx 'ỳr. Dja ba me kadjy tyn akubyn itĩn. Ne kam arỳm ira:xkumrẽx ne ipyma:. ");
INSERT INTO txuNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ga, me kute bàygogo 'y krekam arỳm tyk pyràk. Djãm mrãmri ne arỳm ty? Kati. Ga, 'y ingrõt ne abatành nhym arỳm 'ã ô kumexja pumũ. Ne ren me 'y kre kêt nhym ren 'y kajgo rã'ãn àptàr kêtkumrẽx. Ba ije bàygogo 'y pyràk. Badjwỳ dja ba ty nhym me arỳm ijadjà. Nhym kam ityk djô'ã arỳm me krãptĩ tĩn. Mrãmri ne ba ar amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Be, me arek pykabêbit ar ba kadjy kute amimarja dja me arỳm tyn akuno. Nàr me kadjy kute amimar kêtja, arek pykabêbit ar ba kadjy kute amimar kêtja dja Metĩndjwỳnh me utà nhym me arỳm kôt tĩn ne ar ba rã'ã: rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Be, me imã àpênhja gê me mã ikôt amijo bakumrẽx. Kam dja ba nhĩ'ãm ar iba nhym inhõ àpênh arek ikôt ar ba. Dja imã apê nhym Ibãm arỳm kàjmã kum rax kamẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ne ajte arkum, —Be, arỳm idjumar punu iwỳr bôx. Be, mỳj dja ba nẽ? Djãm ije kum, “Djũnwã, arỳm itokry'ã myt bôx 'ỳr. Itokrybê ipytà”, anhỹrmã? Kati. Ije itokry ja markumrẽx kadjy ne ba arỳm tẽn bôx. Nãm ã arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ne ajte Bãmmã kum, —Djũnwã, jakam dja ga memã amiraxo amirĩt gê me araxmã kato, ane. Nhym ar arỳm kàjkwa kurũm Bãm kabẽn ma nhym kum, —Arỳm ne ba memã iraxo amirĩt. Dja ba ajte memã iraxo amirĩt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nhym ar bu'ã me ku'ê kwỳ arĩk abenmã kum, —E kum, na ne krikrit, ane. Nhym me kwỳ arĩk abenmã kum, —Metĩndjwỳnh kadjy mrãnh djwỳnh'õ ne kum kabẽn, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nhym Jeju memã kum, —Djãm ba ije kabẽn mar kadjy ne kabẽn kato? Kati. Me ga aje kabẽn mar kadjy. ");
INSERT INTO txuNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Be, jakam dja Metĩndjwỳnh me kunĩ axwemã kato. Me ĩ pỹnhkôt me axwe djàri kum kato. Jakam dja ba pykakam me axwe nhõ bẽnjadjwỳro apan kujaten kumẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Dja me kỳjrũm inhô ba arỳm amiwỳr me kunĩo akẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Pĩte'y'ã jêt'ã ne ã memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nhym me kum, —Nhym bê ne me kute me inhõ Bẽnjadjwỳrbê kumkatibê Kritukumrẽx bĩnmã. Kritu ne tyk kêtkumrẽxmã nhym me me imã arẽ, Môjdjê kukràdjà'ã pi'ôk no'ôk kôt ne me imã arẽ ba me kuma. Be, ga ne ga atemã. Aje me imã, “Ba ije amijo inhĩja dja me kỳjrũm inhô”, anhỹr kôt ba me arỳm akajgo ma. Be, we aje amijo anhĩjakam mỳj me ajõ ga nã? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nhym Jeju memã kum, —Ga, akamàt kô tykkam me ba punuja pumũ. Me kute amikukãm mỳjja pumũnh kêtkam ne me ba punure. Ba ije memã pry kurwỳ djà pyràk ne memã Metĩndjwỳnh kabẽn jarẽnh nhym me arỳm tu amim markumrẽx ne ba mexkumrẽx. Arek me aro'ã ar ibari dja ga me tu amim imarkumrẽx ne ikabẽn kôt ar amijo aba. Nok ga ren kôt amijo aba kêt ne ren me axwe kôt ajaxwen arỳm aje ajte me akamàt kô tykkam ba punu pyràk. ");
INSERT INTO txuNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Arek me aro'ã ar ibari dja ga me tu amim imarkumrẽx. Ne kam arỳm aje mrãmri ne pry kurwỳ djàkôt me ba mex pyràk, ane. Nãm Jeju memã anen arỳm mã tẽn mebê amijo apdju. ");
INSERT INTO txuNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kute amijo bipdjur kêtri ne me nokrekam mỳjja krãptĩ nhipêx. Nãm te me punu krãptĩo mex nhym me kute amim mar kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Be, amrẽbê: Metĩndjwỳnh kukwakam kabẽn jarẽnh djwỳnhbê Idjaij kute me bakukãmãremã arẽnh kôt ne me kute amim mar kêt. Nãm memã kum, “Bẽnjadjwỳr djwỳnh, mỳj me'õ ne kute amim ar ikabẽn mar got? Mỳj me'õ ne kute Bẽnjadjwỳr djwỳnh djàpênh pumũnhkam amim mar got?” Nãm ã me bakukãmãremã ane. Nhym me arỳm aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm tũ:mràm me bakamingrãnyrekam arỳm 'ỳr o bôx. Jeju te me punu krãptĩo mex nhym me me omũn amim Jeju mar kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Idjaij kute me bakukãmãremã arẽnh kôt ne me me omũn amim Jeju mar kêt. Be, djãm me ta ne me kute tu amim markumrẽxmã? Kati. Me ta ne me te: kute amim marmã. Be, mỳkam? Bir, Metĩndjwỳnh ta kute me nomẽ me amako bimràkkam. Kôt ne Idjaij ajte me bakukãmãremã kum, ");
INSERT INTO txuNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Metĩndjwỳnh ne mebê nomẽ amako amrà. Nhym kam me te memã mỳjja jakre nhym me kukràdjà pumũnh kajgon mã omũnhkumrẽx kêt. Nhym me te memã mỳjja jarẽ nhym me mar kumrẽx kêt ne. Mã kukràdjà'ã mỳjja kute amijakreja mar kêt. Ne kam iwỳr amijo akẽx kêt ba kam memã axwe jarẽnh rã'ã ne kam ije meo mex kêt. Me amakkre kêt prãmkam ne ã meo ane”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Idjaij ne Jeju mexo umakôt omũ ne 'ã me bakukãmãremã ujarẽnh ba. Ne kam ã memã ane. Kam me ta te kute amim Jeju marmã. ");
INSERT INTO txuNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","43","Be, djãm me rũnh kunĩ ne me amakkre kêt prãm? Kati. Me kwỳ kute tu amim markumrẽx. Djãm me kwỳ ja kute memã amijo amirĩt? Djãm me kute memã kum, —Arỳm ne ba tu amim Jeju markumrẽx, anhỹro amijo amirĩt? Kati. Mebê pardjêu kabẽn pymaje ne me kute memã amijarẽnh kêt. Be, mỳkam? Bir, me amim, —Dja ba amijarẽnh kêt nhym me imã imex jarẽnh rã'ã. Ba ren Jeju'ã memã amijarẽ nhym ren me arỳm imã ijaxwe jarẽn me nêje bõm imẽ. Ne ren kam ajte me bikprõnh djàkam me ro'ã ikrĩ kêt, anhỹro ba. Me kute amim anhỹrkam ne me kute memã amijarẽnh kêt ne. Djã ne Metĩndjwỳnhbit kute memã mex jarẽnhja me kum kĩnh? Kati. Pykakam me axwe kute memã mex jarẽnhja ne me kum kĩnh. Jabit ne me kum kĩnh. ");
INSERT INTO txuNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nhym kam Jeju kàj bê memã kum, —Djãm me aje tu amim imarkumrẽxkam ne ga me aje bajbit imar? Kati. Me aje amim imar o ne ga me aje amim ijanor djwỳnh mar. ");
INSERT INTO txuNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Me aje ipumũnh o ne ga me aje ijanor djwỳnhdjwỳ pumũnh. ");
INSERT INTO txuNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ga, me kute akamàt kô tykkam pry kurwỳ nhym pry arỳm amirĩtkumrẽxja pumũ. Nhym me arỳm ba mexkumrẽx. Badjwỳ ne ba memã Metĩndjwỳnh kabẽn jarẽ. Nhym me kwỳ ĩ pỹnhkôt kute tu amim kabẽn markumrẽx ne kôt kute amijo baja ne me arỳm axwe kêt ne kute amijo ba mexkumrẽx. Ne ajte kute akamàt kô tykkam me ba punuja pyràk prãm kêtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Me ajõ aje ikabẽn mar kajgon amim imar kêtkam djãm on ije amã ajaxwe pãnh jarẽnhmã? Me anhĩ pỹnhkôt ajaxwe djàri pãnh jarẽnhmã? Djãm on pãnh atokrymã? Kati. Djãm ije memã axwe pãnh jarẽnh nhym me pãnh tokrymã ne ba bôx? Kati. Ije pykakam me kunĩ axwebê me utàrmã ne ba bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Be, me ajõ aje ikangan amim ikabẽn mar kêtkam me'õ dja amã ajaxwe pãnh jarẽ. Me kunĩ kute aminhinomã amimẽnh djà nhõ akatikam dja kàjkwakam Metĩndjwỳnh amã, “Aje amim Ikra mar kêtkam ajaxwekumrẽx”, ane. Dja amã ane ga arỳm ajaxwe pãnh atokry. ");
INSERT INTO txuNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mỳkam dja ã amã ane? Bir, djãm ba ikabẽn ne ba me amã arẽ? Kati. Ibãm ne ikabẽn'ã imã karõ ba arỳm me amã arẽ. Kam dja Ibãm ta amikabẽno ngryk ne me ajõmã ajaxwe pãnh jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ibãm ne imã, “Dja me tu amim amarkumrẽx ne arỳm ikôt tĩn ne ar ba rã'ã: rã'ã ne”, ane. Tãm ne ba ije markumrẽx. Kam Ibãm kute imã kabẽn jarẽnh kôt ne ba memã arẽ. Nãm ã Jeju memã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Be, arỳm Metĩndjwỳnh me bakukãmãre nhirôbê mrãnh nhõ akati 'ỳr. Mebê idjaer kunĩ kute aben kajmã'ã me irôbê mrãnh djà mar kadjy aben pydji djà nhõ akati 'ỳr. Jeju arỳm kute pykakam mebê àbir 'ỳr. Bãm'ỳr àbir 'ỳr. Ja ne arỳm kute mar. Arỳm ne kum pykakam õ me ja jabê:. Nhym te me amakkre kêt arỳm kute bĩn 'ỳr nhym kum õ me abê rã'ã. ");
INSERT INTO txuNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Arỳm ar kute õ kwỳ krẽn parkam nhym Djuda kute Jeju kanga 'ỳr. Ximão ne Djuda dji. Djuda ja nhidji nhikjêbê ne Ikadji. Nãm kute kurê djwỳnhmã kanga 'ỳr. Xatanaj ne 'ã kum apnê nhym kute memã kanga 'ỳr. ");
INSERT INTO txuNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Bãm arỳm kute Jejumã õ mỳjja kunĩ kanga nhym arỳm Bãmbê Metĩndjwỳnh kurũm rwỳk ne kam akubyn 'ỳr àbir 'ỳr. Ja ne Jeju arỳm kute mar. ");
INSERT INTO txuNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nãm kuman kam kàjmã dja. Ar õ kwỳ krẽn parkam kàjmã djan õ kubẽkà krãkào pôx ne adjuw. Ne me'ã ngô ngrà djà byn arỳm o amikrax kupu. ");
INSERT INTO txuNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ne kam arỳm ngônh purortikam ngô run kam arỳm kôt ba djwỳnh par ku'õnhmo krax. Ar par ku'õnho tẽ:n mã me'ã ngô ngrà djào ar par'ã ngô ngrà. O amikrax kupu rã'ãn o ar par'ã ngô ngrà. ");
INSERT INTO txuNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nãm ar par ku'õnho tẽ:n kam arỳm Ximão Pedru'ỳr bôx. Nhym kum, —Je, djãm ba dja ga ipar ku'õ? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nhym Jeju kum, —Jakam aje idjàpênh mar kêt. Dja ba ĩ amã arẽ ga ama, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nhym kum, —Be kati. Aje ipar ku'õnh prãm kêtkumrẽx, ane. Nhym kum, —Dja ba apar ku'õnh kêt ga arỳm ikôt aba kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nhym kum, —Bẽnjadjwỳr djwỳnh. Djãm iparbit? Inhikramẽ ikrãdjwỳ dja ga ku'õ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nhym kum, —Be, gar arỳm adjwỳrkam arỳm ar anhĩ mex ba kam ije ar aparbit ku'õnhmã, ane. Ne kam ar axwe kêt'ã arkum, —Be, arỳm ar amex. Djãm ar akunĩ ne gar amex? Kati. Ar ajõ apydji ne ga amex kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Arỳm kute amikukãm kurê djwỳnhmã kanga djwỳnh markam ne arkum, —Djãm ar akunĩ ne gar amex? Kati, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ne kam arỳm ar par ku'õnh pan kam kà jangijn kam nhỹn arkum, —Be, mỳkam ne ba ar apar ku'õ? Djã ne gar ama? ");
INSERT INTO txuNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Bir, gar imã, “Ujarẽnh djwỳnh, Bẽnjadjwỳr djwỳnh”, anhỹro aba. Be, mrãmri ne gar imã arẽ. Ibê tãm. ");
INSERT INTO txuNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ibê ar anhõ Bẽnjadjwỳr djwỳnh ne ibê ar anhõ ujarẽnh djwỳnhkam ne ba arỳm amijo ingrin amijo ikàtàm ne arỳm ar amã apê. Ar akajgo mex, ar akàtàmmã ne ba apên arỳm ar apar ku'õ. Djãm ar ajõ aje, “Be, ba ne ba irax. Ije me kajgomã idjàpênh prãm kêt”, anhỹrmã? Kati. Ar gadjwỳ aben par ku'õ. ");
INSERT INTO txuNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Be, mỳj kadjy ne ba ar apar ku'õ? Bir, dja gar ipumũn ikudjwa arỳm amijo angriren akàtàm ne abenmã apê. Ja kadjy ne ba ar apar ku'õ. ");
INSERT INTO txuNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Imã adjàpênhkam djãm aje araxo ijakrenh got? Ije ajanorkam djãm aje araxo ijakrenh got? ");
INSERT INTO txuNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ar aje araxo ijakrenh kêtkam dja gar amijã ije ar apar ku'õnhja man ikudjwa amijo angriren amijo akàtàm ne abenmã apê. Dja gar amijo anen arỳm akĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Be, djã ne ba ar akunĩmã ikabẽn jarẽ? Kati. Djãm ar akunĩ amex? Kati. Ije ar anhĩ pỹnhkôt amijo ar apytàr ba arỳm ije ar amar. Nhym be, ar ajõ dja ga amã ikurê. Amrẽbê: ije amikukãm arẽnh kôt dja ga amã ikurê. Nã bãm me bakukãmãremã kum, “Gwaj baro'ã badjàkur'õ dja kum ikurê”, ane. Nã bãm ã memã ane nhym me arỳm 'ã pi'ôk no'ôk ne. Nhym me aben djô'ã arẽnho mõ:. Arẽnho mõr tãmtã tũ:mràm arỳm iwỳr o bôx. Gwaj baro'ã badjàkur'õ dja kum ikurê. ");
INSERT INTO txuNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ar ajõ amã ikurê kêtri ba arỳm pi'ôkkam ar amã ikabẽn jarẽ. Be, mỳj kadjy? Bir, dja gar ajõ amã ikurê kôt arỳm omũn kam arỳm akubyn amijo tẽn pi'ôkkam ikabẽnja ma. Anhỹr djwỳnhràm ikabẽn ja ma. Ne kam arỳm amim, “Mrãmri kôt ne amikukãm arẽnhkumrẽx. Jejubê ne Bẽnjadjwỳrbê kumkatibê Kritukumrẽx”, ane. Dja gar ã anen tu amim imarkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Be, godja ba amũ me ano nhym me me'ỳr bôx nhym me arỳm amim me kabẽn man kam arỳm kôt badjwỳ amim ima. Ne kam arỳm kôt amim kute ijanor djwỳnhdjwỳ ma. Mrãmri ne ba ar amã ja jarẽnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jeju arkum anen arỳm umar punure ne. Ne kam arkum arẽnho amirĩtkumrẽx ne arkum, —Be, mrãmri dja gar ajõ ikurê djwỳnhmã ikanga. Mrãmri ne ba ar amã ja jarẽnhkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nhym kôt ba djwỳnh te kute marmã abenkam no tyn nhỹn amim, —Je tô, mỳj me'õ'ã ne ane? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Be, kôt ba djwỳnh'õ ne Jeju tãri nhỹ. Jeju kum abêja. ");
INSERT INTO txuNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nhym Ximão Pedru jãnh nhỹn amũ Jeju tãri ỹrja'ỳr akẽx ne ar aktã aben pumũ. Ne kam kute ar 'õ jabej Jeju kukjêrmã Pedru kum inhuo Jeju jakre. ");
INSERT INTO txuNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nhym arỳm Jeju'ỳr ajkamẽn kum, —Bẽnjadjwỳr djwỳnh, nhym nã? Ar imã arẽ bar kuma, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nhym kum, —Dja ba õmrõmã djwỳ jadjàn amũ kum kungã ga arỳm ar 'õ pumũ, ane. Ne kam arỳm kum adjàn amũ Djudamã kungã. Djuda nhidji 'õdjwỳbê ne Ikadji. Ximão 'õdjwỳ ne Djuda dji. ");
INSERT INTO txuNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nãm kum kungã nhym Xatanaj arỳm Djudamã wadjàn 'amỳnh tỳx ne. Nhym kam Jeju arỳm kum, “Ajrã, amibêx”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nhym kôt ba djwỳnh kute kabẽn mar kajgon mỳjja'ã Jeju kute kum kabẽn jarẽnhja ar kute mar kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Djudabê ne ar õ pi'ôk kaprĩo ba djwỳnh. Ne kam ar kwỳ arĩk amim, —Bãrãm kute gwaj banhõ kwỳ krẽn djà'õ byrmã ne ano. Me krãptĩ kute aben pydji djà nhõ akati kadjy kute mỳjja byrmã ne ano. Nàr, kute me õ mỳjja kêtmã mỳjja kwỳ nhõrmã ne ano, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nãm Jeju kum djwỳ ngã nhym arỳm kubyn mã kadjy katon tẽ. Arỳm akamàtkam ne tẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Djuda kato nhym Jeju arỳm kôt ba djwỳnhmã kum, —Ije amijo inhĩ ne ar ibaja dja me jakam arỳm iraxmã kato ba memã irax. Nhym kam me arỳm ikôt kàjkwakam Metĩndjwỳnh raxmã kato. ");
INSERT INTO txuNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nhym kam arỳm memã ra:x ne uma:n kam arỳm amiraxo badjwỳ ijo rax. On dja ijo ra:x ba ipyma:. ");
INSERT INTO txuNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Akmere ar, gwaj baro'ã ar babaja arỳm kêt 'ỳr. Dja gar ijabej ar aban te idjãm djà'ỳr abôx prãmje. Nã bãm ã mebê idjaer rũnhmãdjwỳ ane. Ar gadjwỳ ba arỳm ã ar amã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Be, ba ar amã 'ã karõ. Ikabẽn ny ne ba ije ar amã arẽnhmã. Dja gar aman mã kôt amijo aba mex ne amã aben jabê. Kute imã ar ajabê pyràk ã ar amã aben jabêo ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nhym kam me kàtàm kunĩ arỳm ar ajã abenmã kum, “Be, Jejukôt ba djwỳnhkumrẽx ne wã. Ga, arkum aben jabêwã pumũ.” Dja me ã ar ajã abenmã ane. Nãm ã Jeju arkum ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nhym Ximão Pedru kum, —Bẽnjadjwỳr djwỳnh, jãm ne ga atẽmmã? ane. Nhym kum, —Bir, dja ba tẽ ga arỳm te on idjãm djà'ỳr ikôt atẽm prãmje. Kam dja ga tũmràm arỳm ikôt tẽ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nhym Pedru arĩk kum, —Bẽnjadjwỳr djwỳnh, mỳkam dja ba te on adjãm djà'ỳr akôt itẽm prãmje? Dja me kum abĩn prãm ne ikumrẽx ibĩn kam abĩ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nhym kum, —Djãm me kute akumrẽx abĩn ne kam ibĩnmã got? Be, dja me ijo mõ, ga õkrẽn'ãnh kàr kêtri amijã maje ajêxo amãnhkrut ne ikjêkêt ne ijã memã kum, “Kati. Ije me'õwã pumũnh kêtkumrẽx”, ane. Nhym arỳm ajã õkrẽn'ãnh kà. Mrãmri ne ba amã ja jarẽnhkumrẽx. Nãm ã kum ane. ");
INSERT INTO txuNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ne kam ajte arkum, —Kwãrĩk wãnh ba ar akadjy tẽ gar axwe amikam adjumar kêt. Dja gar tu amim Metĩndjwỳnh markumrẽx. Badjwỳ dja gar tu amim imarkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Onĩj Ibãm nhõ kikretikam me ũrkwã krãptĩ. Djã ne ren kêt ba ren arỳm ar amã, “Kati, kêt”, ane. Nhym be, kati. Mrãmri ne Ibãm nhõ kikretikam me ũrkwã krãptĩkumrẽx. Ba arỳm 'ỳr itẽmmã. Dja ba 'ỳr tẽn 'ỳr bôx ne arỳm ar akutêp ar amã anhũrkwão mex. ");
INSERT INTO txuNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Dja ba ar anhũrkwão mex kadjy tẽ:n kam akubyn ajte ar awỳr bôx. Ne kam arỳm mã amikôt ar adjan ar ajo tẽ. Be, mỳj kadjy? Bir gwaj arek baro'ã ar baba kadjy. ");
INSERT INTO txuNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Be, idjãm djà gar arỳm ama. 'Ỳr ipry gar arỳm ama. Kwãrĩk wãnh axwe amikam adjumar kêt, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nhym Tôme arỳm kum, —Jãm atẽmmã ja ar ije mar kêt ne ar ije apry kraxdjwỳ omũnh kêt. Mỳj dja bar nẽn kum ikato? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nhym Jeju kum, —Bir, ba mrãmri ije 'ỳr me pry pyràk. Dja me tu amim imarkumrẽx ba arỳm Ibãm'ỳr meo bôx. Bajbit ije memã katàt ikabẽn jarẽnhkumrẽx ne ije memã tĩn jangjênh nhym me Ibãmkôt tĩn ne ar ba rã'ã: rã'ã ne. Djãm Ibãm'ỳr me o bôx kadjy me'õdjwỳ? Kati. Bajbit ne ba 'ỳr meo bôx. ");
INSERT INTO txuNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ne ga ren ar aje imarkumrẽx ne ren arỳm Ibãmdjwỳ ma. Be, arỳm ba ar amã arẽ gar arỳm aman omũ, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nhym Piripi kum, —Bẽnjadjwỳr djwỳnh, ar imã Abãm jakre bar omũ. Ne kam arỳm ikĩnh ne, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nhym Jeju kum, —E kum Piripi, djãm gormã ne ga ikôt ar aban aje imarn ipumũnhja kêt? Be, me kute ipumũnh o ne me arỳm Ibãmdjwỳ pumũ. Mỳkam ne ga imã, “Ar imã Abãm jakre bar omũ”? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Be, Ibãmmẽ ne bar itipdjin ar iba. Djãm aje amim imar kêt? Ije ar amã ikabẽn jarẽnhja ba ba ije arẽnh kêt. Djãm ba ne ba idjàpênh ar iba? Kati. Ibãm ne ar ijo ban àpênh ar ba. ");
INSERT INTO txuNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Be, Ibãmmẽ ne bar abenã itypdjin ar iba. Ja dja gar aman tu amim imarkumrẽx. Nàr idjàpênhkôt imã akaton tu amim imarkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Me kute tu amim ikamnhĩxkumrẽx gêdja me idjàpênh o apê. Gêdja me àpênho ijakre. Be, mỳkam? Bir, arỳm Ibãm'ỳr itẽmkam dja me àpênho ijakrenh mex ne. Mrãmri ne ba ar amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Dja gar amijo Metĩndjwỳnhmã a'wỳ. Tu amim imarkumrẽx ne kum amijo a'wỳ ba kam ar aje kum arẽnh kôt ã ar amã o ane. Be, mỳj kadjy? Bir, dja ba kôt memã Ibãm ra:xo amirĩt. Ja kadjy dja ba ar aje kum arẽnh kôt ã ar amã o ane. ");
INSERT INTO txuNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ikukwakam dja gar kum mỳjja kunĩo a'wỳ ba kam ar aje kum arẽnh kôt ã ar amã o ane. ");
INSERT INTO txuNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Gar mrãmri amã ijabê jabej mã ikabẽn man kôt ar amijo aba. Ije amrãnh mex'ã ar amã karõ kôt dja gar amijo aba. ");
INSERT INTO txuNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Dja ba kam arỳm ar ajo Ibãmmã a'uw nhym arỳm ar amã ajo kĩnh djwỳnh 'õdjwỳ jano. Nhym kam arỳm arek ar aro'ã ar ba rã'ã: rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Karõ dja ar amã ano. Karõ kute katàt memã ikabẽn jarẽnhkumrẽx. Me kum Metĩndjwỳnh kĩnh kêtjamã dja Karõ janor kêt. Be, mỳkam? Bir, mebê Karõ bipdjur nhym me kute mar kêtkam dja memã anor kêt. Ar ga ne gar atemã. Arỳm aje mar. Karõ arek ar aro'ã ar bakam aje mar. Dja arek ar aro'ã ar ba rã'ã. ");
INSERT INTO txuNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Djãm ije ar amã inhirer gar aje me 'uwtĩ pyràk ne akaprĩn ar abamã? Kati. Ba dja ba mrãmri ar awỳr ibôxkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dja ijã akati ngrêre ba arỳm me kum ikĩnh kêtjabê amijo apdju. Ar gajbit dja ba ar abê amijo ibipdjur kêt. Itĩnkôt dja gar gadjwỳ atĩnkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kam dja gar amim, “Be, mrãmri ne Jeju Bãmmẽ tipdjin ar ba. Badjwỳ ne ba Jejumẽ itipdjin ar iba. Jejudjwỳ ne imẽ tipdjin ar ba.” Djã gãm ar ã amim ane. ");
INSERT INTO txuNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mỳj me'õ ne mrãmri kum ijabêkumrẽx? Bir, ba ne ba me kute katàt amijo ba'ã memã karõ. Dja me kam amim ikabẽn man kôt ar amijo ba. Me ja ne me mrãmri kum ijabêkumrẽx. Dja me mrãmri kum ijabêkumrẽx nhym Ibãmdjwỳ arỳm kum me abê. Badjwỳ dja ba imã me abên arỳm ikabẽno memã amijo amirĩt nhym me arỳm mrãmri imarkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nhym Djuda 'õdjwỳ. Djãm Djuda Ikadji? Kati. Djuda 'õdjwỳ Jejumã kum, —Be, mỳkam dja ga ar bajbit ar imã amijo amirĩt? Mỳkam dja ga me kunĩmã amijo amirĩt kêt? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nhym Jeju kum, —Bir, me kum ijabê dja me ikabẽn man kôt ar amijo ba. Nhym kam Ibãm arỳm kum me abê bar kam arỳm me'ỳr bôx ne ar meo iba. ");
INSERT INTO txuNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nhym be, me kum ijabê kêtja dja me ikabẽn mar kêt ne kôt amijo ba kêt ne tu ate krãn amidjwỳnhbit ma. Be, ije ar amã ikabẽn jarẽnh gar aje marja djãm ba ikabẽn? Kati. Ibãm kute ijanor djwỳnh kabẽn ne ja. ");
INSERT INTO txuNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Gwaj baro'ã ar babari ne ba ar amã ikabẽn ja jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dja ba mã tẽ nhym ar ajo kĩnh djwỳnh arỳm ar amã ikabẽn jarẽ. Metĩndjwỳnh Karõja tãm dja arỳm ar amã arẽ. Ije amrẽbê ar amã ikabẽn jarẽnh ja kunĩkôt dja ar amã arẽ. Kàjkwakam Ibãm dja ar amã Karõ jano nhym arỳm bôx ne ar amã ikabẽn jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Itẽm tekrekam dja gar ikabẽnkôt adjumar mex. Idjumar mex kôt adjumar mex. Djãm me kum ikĩnh kêtja kabẽnkôt adjumar mexmã? Kati. Tãm ne kajgo. Ba ikabẽn kôt dja gar adjumar mex ne mrãmri adjumar mexkumrẽx. Kwãrĩk wãnh amikukãm axwe adjumar ne atĩn prãm kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Õbê ne ba arỳm ar amã, “Dja ba mã tẽn kam akubyn ajte ar awỳr tẽn bôx”, ane. Ga ren ar mrãmri amã ijabêkumrẽx ne ren akĩnhkumrẽx. Ije ar amã Ibãm'ỳr idjàbir jarẽnh ar aje markam ne gar ren akĩnhkumrẽx. Be, mỳkam? Bir, kàjkwakam Ibãm kute raxo ijakrenhkam. ");
INSERT INTO txuNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Be, jakam ba arỳm ar amã arẽ. Idjàbir kêtri ba ar amã arẽ. Dja ba wabi gar kam ikabẽnja man arỳm tu amim imarkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Jakam dja ba arỳm ar amã ikabẽn jarẽnh kwỳ ngri. Be, mỳkam? Bir, arỳm Xatanaj bôx 'ỳr. Me kum ikĩnh kêtja nhõ bẽnjadjwỳr iwỳr bôx 'ỳr. Djãm iwỳr bôxkam kute ijo bamã? Arkati. ");
INSERT INTO txuNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Dja ba Ibãm kabẽn kôt ar amijo iba. Ibãm kute imã 'ã karõ kôt ar amijo iba nhym kam me kum ikĩnh kêtja arỳm ima. Dja me amim, “Mrãmri kum Bãm jabêkumrẽx”, ane. Tãm dja me kuma. Kàjmã ar dja. Gwaj on 'ỳr. Nãm Jeju ã kôt ba djwỳnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ne kam apỹnh akrô kukràdjà'ã ajarẽn arkum, —Be ga, atemã akrô djôja pumũ. Ba ne ba ije akrô bàri pyràk. Ibãm ne kute akrôo djuw mex djwỳnh pyràk. Ar ga ne gar aje akrô bàrikam apỹnh pa pyràk. ");
INSERT INTO txuNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ga, akrôo djuw mex djwỳnh kute akrô pa kajgo rênhja pumũ. Pakam ô kêtkam ne kurê. Ibãmdjwỳ kum me kute imar kajgo kĩnh kêt ne wãnh me kanga. Mỳkam? Bir, me kute imar kajgo ne ukaprĩ kêt ne axwe ar ba. Kute mrãmri ne akrô pakam ô kêt pyràk. Kam ne wãnh me kanga. Ga, akrô pa kwỳkam ôja pumũ. Nhym o djuw mex djwỳnh kute 'ã ingrã kajgodjwỳ rênh. Akrô pakam ôbit krãptĩ kadjy ne kurê. Ibãmdjwỳ kum me kute tu amim imarkumrẽxja kĩnh. Ne kam arỳm mebê mỳjja kajgo kunĩ kurê. Mỳj kadjy? Bir, dja me amim imar 'ãno djan mỳjja kajgo mar kêt. Ne kam arỳm ukaprĩ:n katàt ar amijo ba. Ne kam mexkumrẽx kute akrô pakam ô kumexkam mexkumrẽx pyràk. Ja kadjy ne mebê mỳjja kajgo kunĩ kurê. ");
INSERT INTO txuNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Be, ar aje akrô bàrikam apỹnh pa pyràk. Arỳm ar amex. Ije ar amã ikabẽn jarẽnhkôt arỳm ar amex. ");
INSERT INTO txuNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Dja gar arek ijamỳnh tỳxkumrẽx ne tu amim imar tỳxkumrẽx ne ijã adjukanga kêtkumrẽx. Badjwỳ dja ba arek ar ajamỳnh tỳxkumrẽx. Djãm akrô pa arek akrô bàri 'amỳnh kêtkam ô got? Arkati. Ar gadjwỳ dja gar ijamỳnh kêt ne ijã adjukanga djãm kam amex? Kati. Te amex prãmje kute akrô pakam ô kêtkam mex kêt pyràk. ");
INSERT INTO txuNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ba ije akrô bàri pyràk. Ar ga ne gar aje bàrikam apỹnh pa pyràk. Dja gar arek ijamỳnh tỳx ne tu amim imar tỳxkumrẽx ne ijã adjukanga kêtkumrẽx. Ba badjwỳ dja ba arek ar ajamỳnh tỳx. Kam dja gar katàt ar amijo aban adjukaprĩn amexkumrẽx kute akrô pakam ô mexkumrẽx ne kumexja pyràk. Djãm aje amim imar kêtkam amex prãm got? Dja ga ijã adjukangan arỳm te amex prãmje. ");
INSERT INTO txuNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Dja me amim imar rerekren ijã ukanga nhym Metĩndjwỳnh arỳm wãnh me kanga. Ga, akrô pa ate bàri'ã arij nhym o djuw mex djwỳnh kute rênh ne wãnh rẽnh nhym arỳm ngràja pumũ. Nhym kam me kute o atom ne kuwykam rẽnh nhym xêtja pumũ. ");
INSERT INTO txuNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Gêdja gar arek ijamỳnh tỳx ne tu amim imarkumrẽx ne ijã adjukanga kêt ne tu amim ikabẽn mar tỳxkumrẽx nhym kam Ibãm arỳm akabẽnkôt ã amã o ane. Dja gar amã mỳjja kĩnh ne kum o a'uw nhym arỳm akabẽnkôt ã amã o ane. ");
INSERT INTO txuNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Dja gar amexkumrẽx ne katàt ar amijo aban adjukaprĩ kute akrô pakam ô mexkumrẽx ne kumexja pyràk. Nhym me amex ja pumũn arỳm Ibãm raxmã kato. Dja gar ã amijo anen arỳm abê ikôt aba djwỳnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Imã ar ajabê kute mrãmri ne Ibãm kum ijabê pyràk. Dja gar tu imã ar ajabêja markumrẽx ne ar amã ijabê'ã adjukanga kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Gêdja gar mã ikabẽnja man kôt ar amijo aba. Ije ar amã katàt aje amijo aba'ã karõkam ikabẽnja man kôt ar amijo aba. Ne kam arỳm ar amã ijabê'ã adjukanga kêt. Ga, ije Ibãm kabẽn kôt amijo ibaja pumũ. Ba kam imã Ibãm jabê'ã idjukanga kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Be, mỳj kadjy ne ba ar amã ikabẽn ja jarẽ? Bir, dja gar ikabẽn man arỳm ikĩnho akĩnh. Akĩnh ne akĩnh rã'ãn akĩnhtire. ");
INSERT INTO txuNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Be, ar amã aben jabêmã ne ba abenã ar amã karõ. Amã aben jabê kute mrãmri ne imã ar ajabê pyràk. ");
INSERT INTO txuNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Djãm ije inhõbikwa kadjy itykkam imã inhõbikwa jabê ngri got? Imã abêo katàt me kunĩ jakre. ");
INSERT INTO txuNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Dja ba ar amã katàt aje amijo aba'ã karõ gar ikabẽn man kunĩkôt ar amijo aba ba arỳm ar ajo inhõbikwakumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Djãm jakam ije ar amã, “Inhõ àpênh”, anhỹrmã? Kati. Ne ga ren ar abê inhõ àpênhbit ba ren ar amã adjàpênh djàbit jarẽ gar ren jabit man ren kam aje ikabẽn kunĩ mar kêt. Nhym be, kati. Ibãm kute imã kabẽn jarẽnh ja ba arỳm ar amã kunĩ jarẽ. Ije ar amã Ibãm kabẽn kunĩ jarẽnhkam arỳm ije jakam ar amã, “Inhõbikwa”, anhỹrmã. ");
INSERT INTO txuNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Djãm ar ga ne gar amijo ipytà? Kati. Ba ne ba amijo ar apytàn arỳm ar adjàpênh djà'ã ar amã karõ. Be, mỳj kadjy? Bir, dja gar katàt ar amijo aban adjukaprĩkumrẽx ne memã ijã adjujarẽnh mõ. Ne kam arỳm Metĩndjwỳnhmã amexkumrẽx rã'ã. Kum amexkumrẽx rã'ã ne arỳm aje mrãmri ne akrô pakam ô mexkumrẽx ne kumexja pyràk. Ja kadjy ne ba adjàpênh djà'ã ar amã karõ. Mỳj kadjy dja gar ã amexo ane? Bir, dja gar ikukwakam mỳjja'ã Ibãmmã a'uw nhym arỳm ã ar amã o ane. Ar aje kum arẽnh kôt ã ar amã o ane. Ja kadjy dja gar ã kum amexo ane. ");
INSERT INTO txuNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ar amã aben jabêmã ne ba abenã ar amã karõ. ");
INSERT INTO txuNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Be, dja me kum Metĩndjwỳnh kĩnh kêtja kum ar akurê jabej. Ikumrẽx ne me ã kum ikurêo ane. Ja dja gar ama. ");
INSERT INTO txuNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ne ga ren ar me kum ikĩnh kêtja jaxwe kôt ajaxwe nhym ren me kum ar ajabê ne. Nhym be, kati. Me axwe kôt ajaxwe kêt. Ba ne ba amijo ar apytàn mebê amikôt ar apumjuw. Kam ne me kum ikĩnh kêtja kum ar akurê. ");
INSERT INTO txuNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ba arỳm ar amã, “Ar abê inhõ àpênhkam djãm aje araxo ijakrenh got”? ane. Djãm ar aje araxo ijakrenh got gar amim, “Kati. Dja me ijo bikẽnh kêt”, anhỹro aba? Kati. Ikôt dja me ar ajo bikẽnhkumrẽx. Nhym be, me kwỳ kute amim ikabẽn mar kôt dja me amim ar akabẽndjwỳ ma. ");
INSERT INTO txuNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Be, mỳkam dja me ar ajo ajkẽ? Bir, ikôt ar abakam. Me kute ijanor djwỳnh mar kêtkam dja me ar ajo ajkẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ne ba ren me'ỳr ibôx kêt ne ren memã ikabẽn jarẽnh kêt nhym Metĩndjwỳnh ren memã axwe jarẽnh kêt. Nhym be, kati. Arỳm ne ba me'ỳr bôx ne memã ikabẽn jarẽ nhym me kute amim imar kêt. Kam dja mrãmri memã axwe jarẽnhkumrẽx. Jakam dja me te Metĩndjwỳnhmã kum, “Kati. Ijaxwe kêt”, anhỹrmã. ");
INSERT INTO txuNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Be, me kum ikurêja kum Ibãmdjwỳ kurê. ");
INSERT INTO txuNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ne ba ren ije me nokrekam mỳjja pumũnh kêt kwỳ nhipêx kêt nhym ren me omũnh kêt nhym Metĩndjwỳnh ren memã axwe jarẽnh kêt. Nhym be, kati. Arỳm me kute omũnhkam ne me kum ikurên kum Ibãmdjwỳ kurê. ");
INSERT INTO txuNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Me kum ikurêja'ã ne me bakukãmãre amrẽbê: pi'ôk no'ôk ne. Ba ne ba kam amikukãm memã kum, “Ajmã ije meo kêtkam ne me kum ikurê.” Nã bãm ã memã ane nhym me arỳm kukràdjàkam 'ã pi'ôk no'ôk ne. Nhym kam me aben djô'ã arẽnho mõ:n arẽnho mõr tãmtã arỳm iwỳr o bôx. Tũ:mràm iwỳr o bôx. Nhym me kamingrãnyre arỳm kum ikurê. Ajmã ije meo kêtkam me kum ikurê. ");
INSERT INTO txuNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Be, dja ba Ibãm 'ỳr wabin 'ỳr bôx ne arỳm ar amã ar ajo kĩnh djwỳnh jano, ar amã Metĩndjwỳnh Karõ jano. Ta dja katàt memã kabẽn jarẽnhkumrẽx. Ibãm kurũm dja tẽ. Dja ba ar amã ano nhym bôx. Ne kam kute ipumũnh kôt arỳm ar amã ijã ajarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ar gadjwỳ gêdja gar ijã memã adjujarẽnh aba. Idjàpênh kraxkôt iro'ã ar abakam aje ipumũnh kôt memã ijã adjujarẽnh aba. ");
INSERT INTO txuNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ar aje ibê amijo akẽx kêt kadjy ne ba ar amã ikabẽn jarẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Me bikprõnh djàkam dja me ar akangan me nêje bõm ar amẽ. Ne arĩk ar ajã amim, “Dja ba ar kupa nhym kôt Metĩndjwỳnh arỳm kum ikĩnhkumrẽx”, anen arỳm ar abĩ. ");
INSERT INTO txuNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Me kute Ibãmmẽ ar imar kêtkam dja me ã ar ajo ane. ");
INSERT INTO txuNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Djãm amrẽbê ne ba ar amã ikabẽn ja jarẽnho tẽ? Kati. Gwaj baro'ã ar babari ne ije ar amã arẽnh kêt. Ajbir ne ba ar abê idjàbir kutã ar amã arẽ. Dja ba wabi nhym me arỳm ar ajo bikẽnho ba. Kam dja gar akubyn ije ar amã ikabẽn jarẽnh ja'ỳr amijo bôx ne arỳm aman amim, “Be, mrãmri kute imã arẽnh kôt ne me arỳm jakam ã ijo bikẽnho bao ane”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jakam ba arỳm kute ijanor djwỳnh'ỳr idjàbirmã. Kam ne gar aje imã, “Jãm dja ga tẽ”? anhỹr kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Be, mỳkam? Bir, ba ije ar amã idjàbir jarẽnh gar akaprĩ raxkam ne gar aje ikukjêr kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kwãrĩk wãnh ar akaprĩ kêt. Dja ba wabin arỳm ar amã ajo kĩnh djwỳnh 'õdjwỳ jano. Metĩndjwỳnh Karõ jano nhym ar awỳr bôx gar adjumar mexkumrẽx. Ba ren idjàbir kêt nhym ren Karõ ar awỳr bôx kêt. Nhym be, kati. Dja ba idjàbirkumrẽx ne ar awỳr anorkumrẽx. Mrãmri ne ba ar amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Mrãmri dja Metĩndjwỳnh Karõ pykakam bôxkumrẽx. Ne kam ta arỳm mã pykakam me axwemã kum, “Mrãmri ajaxwekumrẽx”, anhỹro ba. Nhym kam me arỳm kôt amijaxwe maro ba. Be, mỳkam? Bir, me kute amim imar kêtkam ne me axwe. Dja Metĩndjwỳnh Karõ ta arỳm mã memã kum, “Jeju katàt kute amijo bakumrẽx”, anhỹro ba. Nhym kam me arỳm kôt ikatàtkumrẽx maro ba. Be, mỳkam? Bir, Ibãm'ỳr idjàbir gar aje ipumũnh kêtkam dja me mrãmri ikatàtkumrẽx maro ba. Dja Metĩndjwỳnh Karõ ta arỳm mã memã kum, “Dja ga ajaxwe pãnh atokry”, ane. Nhym kam me arỳm kôt amimaro ba. Be, mỳkam? Bir, dja me kum ikĩnh kêtja nhõ bẽnjadjwỳrbê Xatanaj tokry. Axwe pãnh tokry. Dja me ja man arỳm amimaro ba, amijaxwekam pãnh tokrymã maro ba. ");
INSERT INTO txuNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Be, ba te ije ar amã ikukràdjà kumex jarẽnh prãmje. Ar aje ikukràdjà kumex mar kadjy ne gar ajamak mex kêt rã'ã. ");
INSERT INTO txuNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kwãrĩk wãnh rã'ã. Dja ĩ Metĩndjwỳnh Karõ bôx. Kute memã katàt kabẽn jarẽnhkumrẽxja bôx. Ne kam arỳm ar ajo ba gar ikabẽn katàt kunĩ ma. Djãm ta ne kute amikabẽn jarẽnhmã? Kati. Ba dja ba kum arẽ nhym arỳm ar amã kute ikabẽn marja jarẽ gar arỳm ama. Dja ar akukãm apỹnh mỳjja apôx djwỳnhràm ar amã arẽ gar arỳm ama. ");
INSERT INTO txuNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ba dja ba kum ikabẽn jarẽ nhym kuman arỳm ar amã arẽ. Kute ar amã ikabẽn jarẽnhkam dja ijo rax gar arỳm ira:xmã akaton ama. ");
INSERT INTO txuNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Be, ba Ibãm kabẽn o ikabẽnkam ne ba ar amã, “Ba dja ba Karõmã ikabẽn jarẽ nhym kuman arỳm ar amã arẽ”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Arỳm itẽm 'ỳr. Dja ba tẽ gar arỳm ipumũnh kêt. Nhym kam ijã akati ngrêre gar ajte ipumũ. Ibãm'ỳr idjàbir 'ỳr. Kam dja gar ajte ipumũ. Nãm ã Jeju kôt ba djwỳnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nhym kôt ba djwỳnh kwỳ ar abenmã kum, —Nãm gwaj bamã, “Arỳm itẽm 'ỳr. Dja ba tẽ gar arỳm ipumũnh kêt. Nhym kam ijã akati ngrêre gar arỳm ajte ipumũ”, ane. Ne, “Ibãm'ỳr idjàbir 'ỳr. Kam dja gar ajte ipumũ”, ane. Be, mỳj'ã ne gwaj bamã ja jarẽ? ane. ");
INSERT INTO txuNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ne kam, —Kute gwaj bamã, “Akati ngrêre”, anhỹrkam mỳj'ã ne kute gwaj bamã ja jarẽ? Gwaj te baje mar prãmje, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Be, ar kute kukjêr prãmkôt ne Jeju arỳm ar kuma. Ne kam arkum, —Djã ne gar bit aje ikukjêrmã? Ije ar amã, “Arỳm itẽm 'ỳr. Dja ba tẽ gar arỳm ipumũnh kêt. Kam dja ijã akati ngrêre gar arỳm ajte ipumũ”, anhỹr. Ije ar amã anhỹrkam djã ne gar aje bit abej ikukjêrmã? ");
INSERT INTO txuNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ba ar amã arẽ gar ama. Dja gar muw ne akaprĩ rax. Nhym be, me kum ikĩnh kêtja dja me kĩnh. Dja gar akaprĩ tẽn kam ĩ arỳm akĩnhkumrẽx. Mrãmri ne ba ar amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Be, me nire kra àkam kaprĩre. Me kra bixadjwỳr 'ỳr nhym me kaprĩre. Ne kam me kra bixadjwỳrkam arỳm kaprĩo aknon mar kêt ne. Me kĩnhkam ne me arỳm kaprĩo akno. ");
INSERT INTO txuNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Dja gar ã akaprĩn ajte akĩnho ane. Jakam gar akaprĩ. Kwãrĩk wãnh rã'ã. Dja gwaj ajte aben pumũ gar akĩnhkumrẽx. Nhym kam me arỳm te kute ar amã akaprĩ jadjàr prãmje. ");
INSERT INTO txuNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Gwaj baje ajte aben pumũnhkam dja gar imã adjà'wỳr prãm kêt. Ne kam ikukwakam Ibãm tamã mỳjjao a'uw nhym arỳm ã ar amã o ane. Mỳjja kunĩo ikukwakam kum adjà'wỳrja dja ã ar amã o ane. Mrãmri ne ba ar amã ja jarẽnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kraxje ar aje ikukwakam Ibãmmã adjà'wỳr kêt rã'ã. Ikukwakam kum a'wỳ nhym arỳm ã ar amã o ane. Ar akĩnhtire kadjy dja ã ar amã o ane. ");
INSERT INTO txuNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Be, Ibãm kukràdjà'ã ne ba pykakam apỹnh mỳjja jakren ar amã arẽ nhym kukràdjà kwỳ ar abê bipdjur. Adjỹm, dja ba ĩ ar amã ã arẽnho anhỹr kêt. Dja ba ar amã Ibãm kukràdjà jarẽ nhym ar amã amirĩtkumrẽx ne ar abê bipdjur kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Amrẽ akati mõrjakam ije ar ajo Ibãmmã idjà'wỳr prãm kêt. Ar ga dja gar ikukwakam kum a'uw nhym arỳm ar ama. ");
INSERT INTO txuNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Be, mỳkam? Bir, ta kum ar ajabêkam. Ar amã ijabêkam ne ta kum ar ajabê. Ije ar amã, “Ta ne ijano ba tẽ”, anhỹr gar aje tu amim ikabẽn markumrẽxkam ne ta kum ar ajabê. Dja gar kum a'uw nhym ta arỳm ar ama. ");
INSERT INTO txuNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ibãm kurũm ne ba amrẽ tẽn pykamã bôx. Dja ba jakam pyka kurũm Ibãm'ỳr tẽn arỳm 'ỳr bôx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nhym kôt ba djwỳnh kum, —Be, jakam ne ga arỳm imã akabẽn jarẽnho amirĩtkumrẽx. Aje akukràdjà'ã pykakam mỳjja'ã adjujarẽnhja jakre kêt. Ga tu akukràdjà jarẽnho amirĩtkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jakam bar arỳm amim ama. Mrãmri ne aje mỳjja kunĩ markumrẽx. Jakam ar ije ajte akabẽn jabej akukjêr prãm kêtkumrẽx. Be, mrãmri ne ga kàjkwakam Metĩndjwỳnh kurũm tẽn abôxkumrẽx, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nhym Jeju arkum, —Djãm jakam ne gar mrãmri tu amim imar tỳxkumrẽx? Kati. ");
INSERT INTO txuNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Adjỹm, dja gar amidjwỳnhbit man ĩ ibê ajmà. Me umaje ibê ajmà ba arỳm ate dja. Be, djãm mrãmri ba ate idjãmmã? Kati. Ibãm kute imẽ amijo kajkepkam dja ba ate idjãm kêt. ");
INSERT INTO txuNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Be, mỳj kadjy ne ba ã ar amã ane? Bir, dja gar ĩ ije ar amã ikabẽn jarẽnhja man arỳm tu amim markumrẽx. Ne kam arỳm ikanàrràm adjumar mex ne ar aba. Be, me kum ikĩnh kêtja kôt dja gar arek ar aba nhym me ar ajo bikẽnho ba. Kwãrĩk wãnh kam ar akaprĩ kêt. Ba ne ba itỳxo ije me kum ikĩnh kêtja jakrenh mex ne. Nãm ã Jeju kôt ba djwỳnhmã ane. ");
INSERT INTO txuNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nãm arkum anen kam kàjmã õkren kàjkwa jabẽn Bãmmã kum, —Djũnwã, arỳm itokry'ã myt bôx. Dja ga memã iraxo amirĩt gê me iraxmã kato. Dja me iraxmã kato ba arỳm memã araxo amirĩt nhym me gadjwỳ araxmã kato. ");
INSERT INTO txuNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Be, mỳjkôt dja me gu baraxmã kato. Bir, aje me kadjy ijã Bẽnjadjwỳr djwỳnh mẽnhkôt. Apỹnh pyka djàri kunĩkôt dja ba me kunĩmã nhỹ. Ne kam arỳm me kwỳmã tĩn jadjà. Aje mã ikôt me kamẽnhja kunĩmã tĩn jadjà nhym me arỳm gu bakôt tĩn ne ar ba rã'ã: rã'ã ne. Ja kadjy ne ga ijã Bẽnjadjwỳr djwỳnh mẽ. Kôt dja me kum gu bakĩnhkumrẽx. ");
INSERT INTO txuNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Be, mỳj ne me kute marmãn arỳm gu bakôt tĩn ne ar ba rã'ã: rã'ã ne? Bir, dja me amim, “Kàjkwakam Metĩndjwỳnh pydji. Mrãmri ne kubê Metĩndjwỳnhkumrẽx. Mrãmri ne kute pykamã Jeju janorkumrẽx”, anhỹro ba. Ja ne me kute marmã. Me kute mar ne tu amim gu bamarkumrẽxmã. Dja me tu amim gu bamarkumrẽx ne arỳm gu bakôt tĩn ne ar ba rã'ã: rã'ã ne. ");
INSERT INTO txuNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Pykakam ar ibari ba arỳm memã araxo amirĩt nhym me kwỳ arỳm kum akĩnhkumrẽx. Aje adjàpênh djà'ã imã karõ kôt ba apên arỳm 'ã aminhinomã amimẽ. ");
INSERT INTO txuNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jakam badjwỳ dja ga memã iraxo amirĩt gê me ira:xmã kato. Adjàkam mỳjja kunĩ kator kêtri gu ar baba. Kam gu bara:x. Amrẽbê: gu baraxja kôt dja ga jakam ijo rax. ");
INSERT INTO txuNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ga ne ga arỳm mebê anhõ me kwỳo akẽx. Me kum akĩnh kêtja bê anhõ me kwỳo akẽx ne mã ikôt me kamẽ. Ba kam arỳm memã ajo amirĩtkumrẽx ne. Nhym kam me arỳm akabẽn man kôt ar amijo ba. ");
INSERT INTO txuNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Arỳm me kute imarn arỳm ijã amim, “Jeju ne Metĩndjwỳnh kukwakambit àpênh ne kabẽn jarẽnho ba”, anhỹro ba. Ja ne me kute mar. ");
INSERT INTO txuNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Aje akabẽn'ã imã karõ kôt ba memã arẽ nhym me arỳm tu amim markumrẽx ne mã kôt ar amijo ba. Ne mã ijã amim, “Mrãmri kàjkwakam Metĩndjwỳnh kurũm ne tẽn bôx. Mrãmri ta ne kute anorkumrẽx nhym arỳm tẽn bôx”, ane. ");
INSERT INTO txuNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Djãm pykakam me kum akĩnh kêtjao ne ba amã a'uw? Kati. Aje ikôt me kamẽnhjao ne ba amã a'uw. ");
INSERT INTO txuNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ga ne ga arỳm inhõ me kunĩo an