﻿USE sofia;
DROP TABLE IF EXISTS sofia.txq_vpl;
CREATE TABLE txq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES txq_vpl WRITE;
INSERT INTO txq_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Makasososan Manetualain nakadadadik lalai no dae-inak. ");
INSERT INTO txq_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Lelek naa, dae-inak bei ta dadi, ma basa-basan bei runggu-rangga. Bei hambu kada oe, ma makiu-makahatuk tatana nalan. Manetualain Dula-dalen laa-laa neu-mai nai oe naa bafon lain. ");
INSERT INTO txq_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Basa boe ma Manetualain kokolak nae, “Muste hambu manggaledok.” Kokolak basa nae talo naa, boe ma manggaledok dadi. ");
INSERT INTO txq_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ana mete-nita manggaledok naa, boe ma dalen namahoko, nahuu hata fo Ana nakadadadi nalak naa, memak neulauk. De Ana tada feꞌe manggaledok numa makiuk mai fo esa-esak no fai heli-helin. ");
INSERT INTO txq_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ana foi manggaledok naa nade, ‘leledok’, ma makiuk naa, ‘leꞌodaek’. Naa, fai kaesan. ");
INSERT INTO txq_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Basa boe ma Manetualain kokolak seluk bali nae, “Dadi mamana rouk, fo tada feꞌe oe. Huu naa de hambu oe nai tadak lain, ma hambu oe nai tadak dae.” Kokolak basa nae talo naa, boe ma oe naa tada baꞌen neu dua. ");
INSERT INTO txq_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","De Ana foi mamana rouk manai tadak lain naa nade, ‘lalai’. Naa, fai kaduan. ");
INSERT INTO txq_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Basa boe ma Manetualain kokolak seluk bali nae, “Oe manai tadak dae naa muste nakabubua neu mamanak esa, mita fo hambu dae madak.” Kokolak basa talo naa, boe ma dae madak dadi. ");
INSERT INTO txq_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","De dae madak naa Ana foin nade, ‘mada lai’; ma oe mana makabubuak naa, Ana foin nade ‘tasi’. Ana mete-nita basa naar, boe ma dalen namahoko, nahuu hata fo Ana nakadadadi nalak naa, memak neulauk. ");
INSERT INTO txq_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Boe ma Manetualain kokolak seluk bali nae, “Mada lai muste mori sele-tandek. Muste hambu sele-tandek mana maboak, kadeꞌek, ma mana madoo momodok. Mita fo sele-tandek esa-esak nabuna-boa tungga mata-aon.” Kokolak basa talo naa, boe ma basa sele-tandek dadi. ");
INSERT INTO txq_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nai mada lai, basa sele-tandek kara rabuna-boa tungga esa-esak mata-aon. Ana mete-nita basa naar, boe ma dalen namahoko, nahuu hata fo Ana nakadadadi nalak naa, memak neulauk. ");
INSERT INTO txq_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Naa, fai katelun. ");
INSERT INTO txq_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Basa boe ma Manetualain kokolak seluk bali nae, “Nai tadak lain naa, muste hambu buas manggaledok mata-matak fo tao manggaledo dae-inak ia. Muste hambu mana tao manggaledo fai leledok, ma muste hambu laen mana tao manggaledo fai leꞌodaek. Basa sara dadi reu tanda, mita fo bisa reke fai, teuk, ledo-fair bula lalalin.” Kokolak basa talo naa, boe ma basa buas manggaledok kara dadi. ");
INSERT INTO txq_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ana nakadadadik buas manggaledok moꞌok matak dua. Mana moꞌon lenak, nasaꞌa nai fai leledok; kadiꞌik nasaꞌa nai fai leꞌodaek. Ana oo nakadadadik nduuk kara boe. ");
INSERT INTO txq_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ma Ana koladu buas sara raa reu lalai, fo ara rasaꞌa tao manggaledo dae-inak. ");
INSERT INTO txq_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Boe ma ara tao manggaledo fai leledok, ma manggaledo fai leꞌodaek. No dalak naa, ara tada baꞌe manggaledok numa makiuk mai. Ana mete-nita basa naar, boe ma dalen namahoko, nahuu hata fo Ana nakadadadi nalak naa, memak neulauk. ");
INSERT INTO txq_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Naa, fai kahaan. ");
INSERT INTO txq_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Basa boe ma Manetualain kokolak seluk bali nae, “Muste hambu banda mata-matak kara, leo rai oe dale. Ma muste hambu mbuik mata-matak kara, lambu rai dae-inak lain.” ");
INSERT INTO txq_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Boe ma Ana nakadadadik basa iꞌak mata-matak kara ro banda moꞌok mana leo nai oe dale. Ana oo nakadadadik basa mbuik mata-matak kara, lambu rai lalai boe. Ana mete-nita basa naar, boe ma dalen namahoko, nahuu hata fo Ana nakadadadi nalak naa, memak neulauk. ");
INSERT INTO txq_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Basa boe ma Ana kokolak fee babaꞌe-babatik neu basa bandar raa lalaꞌen nae, “Iꞌak kara muste tamba ramanoꞌu, fo rasofe basa oer rai bee a mesan. Ma mbuik kara oo muste tamba ramanoꞌu boe.” ");
INSERT INTO txq_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Naa, fai kaliman. ");
INSERT INTO txq_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Basa boe ma Manetualain kokolak seluk bali nae, “Muste hambu banda mata-matak kara, leo rai mada lai. Ndia banda neni nekeboik, banda fuir, ma banda mana manodo-manamak nai daer, esa-esak no mata-aon.” Kokolak basa talo naa, boe ma basa bandar dadi. Ana mete-nita basa naar, boe ma dalen namahoko, nahuu hata fo Ana nakadadadi nalak naa, memak neulauk. ");
INSERT INTO txq_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Basa boe ma Manetualain kokolak seluk bali nae, “Mai fo Ita adu hatahori dae-bafok tungga Ita mata-aon. Mita fo ara lopo-linu ma kiu-lolo basa iꞌak kara marai tasi dale, basa mbuik kara marai lalai, basa banda neni nekeboik kara, ma basa banda laen nara mana leo rai dae-inak.” ");
INSERT INTO txq_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","De Ana adu hatahori dae-bafok tungga Ndia mata-aon. Ana adu sara, touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Boe ma Ana kokolak fee babaꞌe-babatik neu sara nae, “Ei muste bonggi tamba mamanoꞌu, fo tao masofe ma faduli dae-bafok ia. Au oo fee haak neu ei fo faduli iꞌak kara, mbuik kara, ma basa bandar marai mada lai boe. ");
INSERT INTO txq_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nenene matalolole! Au fee ei nanaꞌak mata-matak kara rai dae-bafok ia. Ndia: sele-tande kaboak ma kadeꞌek, ma mana madoo momodok. ");
INSERT INTO txq_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Au oo fee basa sele-tandek mata-matak kara, fo dadi neu basa banda mata-matak kara nanaꞌan boe. Hambu nanaꞌak soa-neu banda nekeboik, banda fuir, banda mana manodo-manamak, ma mbuik kara.” Kokolak basa talo naa, boe ma basa nanaꞌak mata-matak kara dadi. ");
INSERT INTO txq_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ana mete-nita basa naar, boe ma dalen namahoko, nahuu hata fo Ana nakadadadi nalak naa, memak neulaun seli. Naa, fai kaneen. ");
INSERT INTO txq_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","No dalak naa, Manetualain nakadadadik nala lalai no dae-inak no basa oe-isin nara lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ana adu nala basa sara, boe ma neu beꞌe-main, ndaa no fai kahitun, Ana hahae. ");
INSERT INTO txq_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","No dalak naa, Ana tao fai kahitun neu fai ina-huuk lena basa fai laen nara. Ana koladu talo naa, nahuu nateꞌe Ndia ue-osan ena, boe ma neu fai kahitun Ana hahae. ");
INSERT INTO txq_vpl VALUES ("GN2_4a","002_2_4a","GEN","2","4a","4a","Manetualain nakadadadik lalai no dae-inak tutuin, ndia talo naa. ");
INSERT INTO txq_vpl VALUES ("GN2_4b","002_2_4b","GEN","2","4b","4b","Neu MANETUALAIN bei fo mulai nakadadadik lalai no dae-inak naa, ");
INSERT INTO txq_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","bei ta hambu sele-tandek hata-hata, nahuu Ana bei ta nakonda udan. Lelek naa, bei hambu kada koꞌa-masuk mana hene numa dae mai fo tao nakoe dae-inak. Ma bei ta hambu hatahori dae-bafok fo naue-osa osi-lutu. ");
INSERT INTO txq_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Basa boe ma MANETUALAIN haꞌi nala dae faa, de Ana adun dadi neu hatahori dae-bafok. Boe ma Ana fuu ani hahaek neni idu bolon neu, de hatahori dae-bafok naa dadi horis neuk ka. ");
INSERT INTO txq_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Basa boe ma MANETUALAIN tao nala osi esa numa dae Eden, nai dulu. De Ana fee hatahori dae-bafok naa leo neu osi naa dale. ");
INSERT INTO txq_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Nai osi naa dale, Ana nakamomorik ai huuk malole mata-matak kara ena, ma ai huuk fo hatahori bisa naꞌa no malada. Ana oo nakamomorik ai huuk matak dua numa osi naa talada heon boe. Ai huuk esa, mete ma hatahori naꞌa boan, na, ana bisa nasoda nakandoo. Tehuu ai huuk esa bali, mete ma hatahori naꞌa boan, na, ana bisa bubuluk bee ndia neulauk ma bee ndia manggarauk. ");
INSERT INTO txq_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Hambu lee esa numa dae Eden, ndia faa dea neu numa osi naa mai. Lee naa nabaꞌe dadi neu panggek haa. ");
INSERT INTO txq_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Panggek kaesan, nade Pison. Panggek naa eko-feo ndule dae Hawila, fo hambu lilo mbilas noꞌuk ka. ");
INSERT INTO txq_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Numa naa hambu lilo mbila isik, hambu ai huuk fo daan naboo meni, ma hambu batu manggadilak. ");
INSERT INTO txq_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Lee naa pangge kaduan, nade Gihon. Panggek naa eko-feo ndule dae Kus. ");
INSERT INTO txq_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Panggek katelun, nade Tigris. Panggek ia dadi too-lane neu dae Asyur boboan dulu. Lee panggek kahaan, nade Efrat. ");
INSERT INTO txq_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","MANETUALAIN fee hatahori dae-bafok naa leo numa Eden, fo ana faduli natalolole osi naa. ");
INSERT INTO txq_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","De Ana fee parenda neu hatahori dae-bafok naa nae, “O bole muꞌa ai boak hata a mesan numa basa ai huuk marai osi ia dale mai. ");
INSERT INTO txq_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Tehuu hambu esa, o ta bole muꞌa sana. Ndia, ai huuk fo mana fee o bubuluk bee ndia neulauk ma bee ndia manggarauk. Mete ma o muꞌan, na, neu ko o mate.” ");
INSERT INTO txq_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Basa boe ma MANETUALAIN kokolak bali nae, “Ta malole mete ma hatahori dae-bafok ia leo-laꞌo mesa kana. De Au nau adu feen, nonook esa nandaa noon.” ");
INSERT INTO txq_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Lelek naa, MANETUALAIN haꞌi nala dae, de adu nala banda mata-matak kara ma mbuik kara. Basa boe ma Ana neni bandar ro mbuik kara reni hatahori naa reu, mita fo ana foi naden nara. Boe ma hatahori naa foi bandar ma mbuik kara raa, esa-esak no naden. Tehuu ndia mesa kana bei ta hambu nonook esa fo nandaa noon. ");
INSERT INTO txq_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Basa boe ma MANETUALAIN fee hatahori naa sunggu seli. Neu ana sunggu, MANETUALAIN haꞌi nala kaihusu duin esa, basa de Ana mbambalu falik hinak naa. ");
INSERT INTO txq_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Numa duik naa mai, Ana adu dadi inak. Basa de Ana loo lima inak neu hatahori naa. ");
INSERT INTO txq_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Hatahori naa mete-nita inak naa, boe ma ana nae, “Naaa! Ia dei! Ia dei fo nandaa no au! Ndia duin sama leo au duing. Ma ndia mbaan oo sama leo au mbaang boe. Huu ana dadi numa touk mai, de au foin nade ‘inak’.” ");
INSERT INTO txq_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Huu naa de touk muste laꞌo ela inan ma aman, fo neu leo dalek esa no ndia saon, huu dua sara dadi reu esa ena. ");
INSERT INTO txq_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Lelek naa, dua sara makaholak kara, tehuu ara ta rameda mae faa boe na. ");
INSERT INTO txq_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Numa basa bandar fo MANETUALAIN nakadadadi nalak kara nai dae-bafok ia ena, mengge ndia mana malela pepeko-lelekok sudi selik kana. Laꞌe esa, hambu mengge natane neu inak naa nae, “Tebe, do? Manetualain kaꞌi nae, ‘Ei ta bole miꞌa ai boak numa ai huuk kara marai osi ia dale mai, hetu?’ ” ");
INSERT INTO txq_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Inak naa bala nae, “Taa! Ai bole miꞌa! Tehuu hambu kada ai huuk esa nai osi taladan, ndia Manetualain kaꞌi fo ai ta bole miꞌan. Ana nae ai ta bole miꞌa, ma ta bole mafaroe boan, huu neu ko ai mate.” ");
INSERT INTO txq_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tehuu mengge naa naselu nae, “Wee, naa ta ndaa! Ei ta mate! ");
INSERT INTO txq_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Manetualain memak kaꞌi talo naa, nahuu Ana bubuluk ena mete ma ei miꞌa ai boak naa, ei dadi malelak sama leo Ndia. Ndia, bubuluk bee ndia neulauk, ma bee ndia manggarauk.” ");
INSERT INTO txq_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Basa boe ma inak naa mete neu te ai huuk naa lolen seli, ma boan nok bali ladan seli. De ana duduꞌa nae, “Mete ma au uꞌa ai boak ia, neu ko au dadi malelak.” Boe ma ana ketu nala ai boak naa, de naꞌa. Basa de ana ketu neni fee saon, de saon naꞌa. ");
INSERT INTO txq_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ara raꞌa basa, dei de ara bubuluk rae sira dua sara makaholak kara. Huu naa de ara nato ai dook kara fo ara mbambalu neu sira makaholan. ");
INSERT INTO txq_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ledo bobon naa, ara ramanene MANETUALAIN laꞌo-laꞌo numa osi naa dale. Boe ma ara keke reu ai huuk boboan seri, mita fo MANETUALAIN ta mete-nita sara. ");
INSERT INTO txq_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tehuu MANETUALAIN nanggou touk naa nae, “Adam, aa! O nai bee?” ");
INSERT INTO txq_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Touk naa naselu nae, “Au amanene Manetualain haran nai ia. Tehuu au mae, huu au makaholak. Huu naa de au alai mai keke.” ");
INSERT INTO txq_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Boe ma MANETUALAIN nae, “See ndia nafada nae o makaholak? Talo bee? O muꞌa ai boak fo Au kaꞌi ei boso miꞌak naa, hetu?” ");
INSERT INTO txq_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ana naselu nae, “Inak ia fo Manetualain feen mai fo nanonoo no au naa, ana ndia fee au ai boak naa, de au uꞌa!” ");
INSERT INTO txq_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Basa boe ma MANETUALAIN kokolak no inak naa nae, “Tao hata de o tao talo naa?” Boe ma inak naa naselu nae, “Te mengge kedi-ira nala au na! Huu naa de au uꞌa ai boak naa, leo maa.” ");
INSERT INTO txq_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Basa boe ma MANETUALAIN nakatoo mengge naa nae, “Huu o tataon ia, de Au huku-doki o. Numa basa banda laen mai, kada o mesa ngga hambu neketook talo ia. Mulai numa hatematak ia neu losa o mate, o roso munik kada o poꞌon, ma o muꞌa nai kada daer. ");
INSERT INTO txq_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Au tao o mua inak ia, esa musu no esa seku neu. Ma ei dua ngga tititi-nonosim mara oo talo naa boe. O tititi-nonosim neu ko kiki nala hatahori ei tinggan. Tehuu ndia tititi-nonosin esa, neu ko tutu nakalulutu o langgam.” ");
INSERT INTO txq_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Basa de Manetualain nafada inak naa nae, “Neu ko Au tamba o susa-sonam neu faik fo o mairu, ma tamba nembetak neu faik fo o bonggi. Leo mae talo naa, tehuu o dalem oo bei hii nalan seli neu o saom boe. Ma ana ndia koladu o.” ");
INSERT INTO txq_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Boe ma Manetualain nafada touk naa nae, “O ta tungga au parendang, tehuu tungga o saom hihiin, losa o muꞌa ai boak fo Au kaꞌik naa ena. Huu naa de o hambu huku-dokik boe. Ma dae oo hambu huku-dokik boe. Mulai numa hatematak ia neu losa o mate, o muste maue-osa fafandek lima-eim doꞌi dae, fo o bisa hambu nanaꞌak. No o maue-osa talo naa, dei fo o bisa masoda. ");
INSERT INTO txq_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Leo mae o sele-tande mata-matak kara, tehuu dae nakamomorik kada dilak ma nggauk. ");
INSERT INTO txq_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","De o muste maue-osa fafandek lima-eim, dei fo dae fee o nanaꞌak. O muste maue-osa mbusem titi talo naa losa mate. Au adu ala o numa dae mai. De mete ma o mate, na, o fali muu dadi dae bali.” ");
INSERT INTO txq_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Basa boe ma Adam foi saon, nade ‘Hawa’ (fo sosoa-ndandaan nae ‘mana masodak’), huu ndia naa, basa hatahori mana masodak inan. ");
INSERT INTO txq_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Boe ma MANETUALAIN tao bua-loꞌa numa banda roun mai, fo fee dua sara pake. ");
INSERT INTO txq_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Basa boe ma MANETUALAIN kokolak nae, “Hatematak ia, hatahori iar bubuluk ena bee ndia neulauk, ma bee ndia manggarauk, sama leo Ita. Boso losak ara oo raꞌa ai boak numa ai huuk mana fee sara rasoda seku neu boe.” ");
INSERT INTO txq_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","De Ana husi kalua heni sara numa osi manai Eden naa mai, fo ara reni mamanak laen reu, de ara leo-laꞌo no ue daek, fo rasoda numa dae buna-boan mai. ");
INSERT INTO txq_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Manetualain husi basa sara, boe ma Ana nadenu Ndia ata kalidan nara ruma nusa tetuk do inggu temak mai, fo reu ranea numa osi naa boboan dulu. Ara toꞌu tafar lombe sara reu-mai, rasaꞌa sama leo aꞌi. Manetualain nadenu sara kena dalak mana maso dale neu, huu Ana ta nau hatahorir ketu rala ai boak mana fee sara rasoda seku neu naa. ");
INSERT INTO txq_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Faik esa, Adam neu sunggu-soro no saon Hawa. Boe ma inak naa nairu. De ana bonggi nala ana touk esa. De ana nae, “Au bonggi ala ana touk esa ena, nahuu MANETUALAIN tulun au ena.” Ana foi kanak naa nade, Kaen (fo sosoa-ndandaan ‘feen dea mai’). ");
INSERT INTO txq_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Basa boe ma Hawa bongggi seluk ana touk esa bali. Ana foin nade Habel. Neu dua sara ramoꞌo mamais, Habel lolo banda-manur, ma Kaen naue-osa osi-lutu. ");
INSERT INTO txq_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Laꞌe esa, Kaen haꞌi neni ndia osin buna-boan ketuk, fo fee MANETUALAIN. ");
INSERT INTO txq_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel oo haꞌi neni ndia bibi lombo inan nara ana ulun. Ana hala bibi lombor raa, de haꞌi nala mbaa neulaun lenak fee Manetualain. MANETUALAIN mete-nita talo naa, boe ma Ndia dalen namahoko huu Habel ma tunu-hotun naa. ");
INSERT INTO txq_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Tehuu Ana ta hii Kaen ma tunu-hotun naa. De Kaen namanasa nalan seli, losa matan manggarau ndoos. ");
INSERT INTO txq_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Boe ma MANETUALAIN kokolak no Kaen nae, “Weeh, Kaen! Tao hata de o mamanasa talo naa? Talo bee de o matam manggarau ndoos? ");
INSERT INTO txq_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mete ma o tao neulauk, neu ko Au oo simbok o no neulauk boe. Tehuu besa-besa! Mete ma o tao manggarauk, na, neu ko manggarauk naꞌa nasafali o, sama leo meo nae kobo lafo. Dadi mete ma o hihiik ka tao manggarauk, malole lenak o timba henin memak kana leo!” ");
INSERT INTO txq_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Laꞌe esa, Kaen fufudi Habel nae, “Fadi, ee! Mai fo ita laꞌo-laꞌo teni osi teu.” Neu ara losa naa, medak neu ma Kaen poko-femba nakamate fadin. ");
INSERT INTO txq_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Boe ma MANETUALAIN natane Kaen nae, “Wee, Kaen! O fadim nai bee?” Kaen naselu nae, “Au ta bubuluk ana nai bee! Mae hetu ko au ia, soa toꞌu ndia ein, do?” ");
INSERT INTO txq_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Boe ma MANETUALAIN kokolak nae, “Tao hata de o tao manggarauk talo naa? Boso duꞌa mae, o bisa mafuni mala o fadim daan nai daer, huu Au mete-ita basa sara ena! ");
INSERT INTO txq_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Hatematak ia neketook daka nala o ena. Huu neu o hala misa o fadim, dae musi nala daan. De hatematak ia dae naa ta bisa baꞌe fee o soda-ladak ena. ");
INSERT INTO txq_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Mete ma o tao osi-lutu, dae ta nau baꞌe fee o buna-boak hata esa boe na ena. Mulai numa hatematak ia neu, o soa laꞌo madaba oek muu-mai sama leo hatahori kasian fo mana sangga soda-ladak nai dae-bafok ia.” ");
INSERT INTO txq_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Tehuu Kaen nasabara neu MANETUALAIN nae, “Awii! Manetualain, ee! Talo bee de Manetualain fee au neketook beran seli, losa au ta bisa lemba abeꞌin bali ia? ");
INSERT INTO txq_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Huu Manetualain husi heni au numa mamanak ia mai ena, neu ko au dook ka numa Manetualain mai. Au soa adabak uni bee a mesan uu. De see a mesan ndia natonggo no au, na, neu ko ara tao risa au.” ");
INSERT INTO txq_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tehuu MANETUALAIN naselu nasafali nae, “Ta talo naa! See ndia tao nisa o, neu ko Au fee huku-dokik neun beran lena laꞌe hitu!” Basa de MANETUALAIN tao tanda neu Kaen, mita fo hatahorir bubuluk fo ara ta tao risan. ");
INSERT INTO txq_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Basa boe ma Kaen laꞌo ela mamanak naa, fo nakadodook numa MANETUALAIN mai. Ana laꞌok losa mamanak esa, nai osi Eden boboan dulu. Mamanak naa nade Nod, sosoa-ndandaan nae, ‘Nedabak’. De ana leo neu naa. ");
INSERT INTO txq_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Basa boe ma Kaen sao, de saon nairu. Ana bonggi nala ana touk esa, ara foin nade Henok. Ma Kaen nambaririik nggorok esa, de ana foi nggorok naa nade Henok, tungga ndia anan naden. ");
INSERT INTO txq_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Boe ma Henok anan, ndia Irad. Irad anan, Mehuyael. Mehuyael anan, Metusael. Ma Metusael anan, Lamek. ");
INSERT INTO txq_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek saon dua. Esa nade Ada, ma esa bali nade Sila. ");
INSERT INTO txq_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada anan, nade Yabal. Ndia tititi-nonosin nara dadi mana lolo banda. Ara leo lali-lali mamanak, ma leo nai kada laak dale. ");
INSERT INTO txq_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabal fadin nade Yubal. Yubal tititi-nonosin nara dadi hatahori mana makaminak bua kaliik, pake sulik ma bua kaliik kukutik pake loa. ");
INSERT INTO txq_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamek saon Sila bonggi nala Tubal Kaen. Tititi-nonosin nara dadi mana tutu besi, fo tao bua-baꞌu mata-matak numa besi ma riti mai. Tubal Kaen fadi inan, nade Naꞌama. ");
INSERT INTO txq_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Laꞌe esa, Lamek koa aon neu saon dua sara matan nae, “Ei nenene, ee! Bebeik kara ia tou taꞌe anak esa nggafu au, tehuu au poko isan. ");
INSERT INTO txq_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Hatahori mana hala nisa Kaen, hambu huku-dokik beran lena laꞌe hitu. Tehuu mete ma see nae bala nembeda dalen neu au, na, ara hambu huku-dokik beran lena laꞌe 77.” ");
INSERT INTO txq_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam saon Hawa, bonggi seluk ana touk esa bali. Boe ma ara foi kanak naa nade, Set (fo sosoa-ndandaan ‘loo feen mai’), nahuu Hawa nae, “Manetualain loo fee au kanak ia ena, nggati Habel fo Kaen hala nisak naa ena.” ");
INSERT INTO txq_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Doo-doo boe ma Set hambu ana touk esa, nade Enos. Lelek naa, hatahorir mulai rakaluku-rakatele neu MANETUALAIN. ");
INSERT INTO txq_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Neu Manetualain adu hatahori dae-bafok, Ana adu mata-aon nara sama leo Ndia mata-ao heli-helin. Ana adu sara, touk ma inak. Basa boe ma Ana noke naden nara nae, “hatahori dae-bafok”, boe ma Ana fee babaꞌe-babatik neu sara. Hatahori dae-bafok makasososak naden, Adam. Adam tititi-nonosin nara naden: ");
INSERT INTO txq_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Neu Adam teun nara 130, boe ma ana hambu ana touk esa, mata-aon sama leo aman. Boe ma ana foi kanak naa, nade Set. ");
INSERT INTO txq_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Basa boe ma Adam bei nasoda teuk 800 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Teun nara 930, boe ma maten. ");
INSERT INTO txq_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Neu Set teun nara 105, boe ma ana hambu ana tou anak esa, nade Enos. ");
INSERT INTO txq_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Basa boe ma Set bei nasoda teuk 807 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Teun nara 912, boe ma maten. ");
INSERT INTO txq_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Neu Enos teun nara 90, boe ma ana hambu ana touk esa, nade Kenan. ");
INSERT INTO txq_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Basa boe ma Enos bei nasoda teuk 815 bali, ma hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Teun nara 905, boe ma maten. ");
INSERT INTO txq_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Neu Kenan teun nara 70, boe ma ana hambu ana touk esa, nade Mahalalel. ");
INSERT INTO txq_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Basa boe ma Kenan bei nasoda teuk 840 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Teun nara 910, boe ma maten. ");
INSERT INTO txq_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Neu Mahalalel teun nara 65, boe ma ana hambu ana touk esa, nade Yared. ");
INSERT INTO txq_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Basa boe ma Mahalalel bei nasoda teuk 830 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Teun nara 895, boe ma maten. ");
INSERT INTO txq_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Neu Yared teun nara 162, boe ma ana hambu ana touk esa, nade Henok. ");
INSERT INTO txq_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Basa boe ma Yared bei nasoda teuk 800 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Teun nara 962, boe ma maten. ");
INSERT INTO txq_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Neu Henok teun nara 65, boe ma ana hambu ana touk esa, nade Metusalak. ");
INSERT INTO txq_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Basa boe ma Henok leo-laꞌo dalek esa no Manetualain, losa teuk 300 bali. Boe ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Ana leo-laꞌo dalek esa no Manetualain seku neu. Neu teun nara 365, boe ma mopok kana, nahuu Manetualain soꞌuk kana neni lalai neu. ");
INSERT INTO txq_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Neu Metusalak teun nara 187, boe ma ana hambu ana touk esa, nade Lamek. ");
INSERT INTO txq_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Basa boe ma Metusalak bei nasoda teuk 782 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Teun nara 969, boe ma maten. ");
INSERT INTO txq_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Neu Lamek teun nara 182, boe ma ana hambu ana touk esa. ");
INSERT INTO txq_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek foi anan naa nade, Noh (sangga sama no dedeꞌa deꞌek esa fo sosoa-ndandaan ‘fee kokoe-nanasi’), nahuu ana nae, “Kanak ia neu ko ana kokoe-nanasi tao namahoko ita dalen nara numa ita ue-osa beran mai nai dae ia fo Manetualain nakatoo nalan ena.” ");
INSERT INTO txq_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Basa boe ma Lamek bei nasoda teuk 595 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Teun nara 777, boe ma maten. ");
INSERT INTO txq_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Neu Noh teun nara 500 ena, boe ma ana hambu ana touk telu, ndia: Sem, Yafet, ma Ham. ");
INSERT INTO txq_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Lelek naa, hatahori dae-bafok tamba namanoꞌu ena. Boe ma ara leo ratanggenggela sudi rai bee, ndule basa dae-bafok ia ena. Ara oo bonggi rala ana inak kara boe. ");
INSERT INTO txq_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Manetualain ana toun nara mete-rita hatahori dae-bafok ana feꞌon nara, neulau ndoos sara. Boe ma ara reu sao rala ana feꞌok see fo ara hii sara. ");
INSERT INTO txq_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Boe ma MANETUALAIN nae, “Au mangguk ka ena ua hatahori dae-bafok leleo-lalaꞌo takandaan nara ia. Au Dula-daleng mana baꞌe masodak neu sara raa, ta nau fee sara rasoda seku neu ena bali. Ara muste mate. Dadi neu ko ara rasoda losa kada teuk 120.” ");
INSERT INTO txq_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tembo-lelek naa, ma tembo-lele bakadeak kara mana tungga naa, hambu hatahori parangguk kara nai dae-bafok ena. Neu lelek fo Manetualain ana toun nara sao rala hatahori dae-bafok ana inan nara, boe ma ara bonggi rala hatahori ta hohoꞌak kara, ndia, malangga musur, fo neni nelelak kara nai tutui lele uluk. ");
INSERT INTO txq_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Lelek naa, MANETUALAIN mete-nita hatahori dae-bafok nai dae-bafok manggaraun nara sudi selik kana ena. Dalen nara duꞌa kada manggarauk taa-taa. ");
INSERT INTO txq_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","De MANETUALAIN fale dalen adu nala sara ena fo leo nai dae-bafok ia. Naa, tao nala Ndia dalen hedis sudi selik kana. ");
INSERT INTO txq_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Huu naa de Ana kokolak nae, “No dalak naa, neu ko Au akalulutu hatahori dae-bafok, fo Au adu ala sara rai dae-bafok ia. Au oo akalulutu basa mbuik kara ma banda laen nara lalaꞌen boe. Huu Au fale daleng adu ala sara ena.” ");
INSERT INTO txq_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tehuu kada Noh mesa kana, ndia tao namahoko MANETUALAIN dalen. ");
INSERT INTO txq_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noh tutuin talo ia: ana toun nara telu, ndia Sem, Yafet ma Ham. Noh naa, leo-laꞌo tungga ndoon, ta tao mangggarauk, ma ana leo-laꞌo deka-deka no Manetualain. Lelek naa, kada mesa kana ndia neulauk. ");
INSERT INTO txq_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Tehuu Manetualain mete-nita basa hatahori laen manggarau ndoos sara. Nai bee a mesan, hatahorir leleo-lalaꞌon nara ta neulauk sudi selik kana ena. Manetualain mete-nita hatahori dae-bafok nai dae-bafok naa, kada manggarauk kara. ");
INSERT INTO txq_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Boe ma Ana nafada Noh nae, “Nai bee a mesan, Au mete-ita kada hatahori dae-bafok manggaraun. Dadi Au aketu basa ena ae, Au ae akalulutu basa dae-bafok ia no oe-isin lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","De talo ia, Noh! Hatematak ia o tao mala ofa moꞌok esa numa ai teas mai. Nai ofak naa dalen, o tao kamar. Basa naa, balu ofak naa pake ter. ");
INSERT INTO txq_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","O tao ofak naa narun meter 133; loan meter 22; ma deman meter 13. ");
INSERT INTO txq_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ofak naa, taon kareredok. Tehuu reredok naa, naomba nai rarain meter seserik esa numa rindi lain mai. O baꞌe ofak naa dadi tadak telu. Boe ma tao lelesu esa nai ofak naa boboan. ");
INSERT INTO txq_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Masaneda matalolole! Neu ko Au akonda faa moꞌok fo ana nakamate basa hata fo horis marai dae-bafok ia, losa ta ela hata esa boe na. ");
INSERT INTO txq_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tehuu Au nau ndara fangga hehelu-bartaak ua o. Neu ko o maso muni ofak naa dale muu, sama-sama mua o saom, o anam mara, ma o feto-feum mara. ");
INSERT INTO txq_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Numa basa bandar lalaꞌen mai, o muste haꞌi pasan esa-esak, fo muni sara reni ofak naa dale reu, mita fo ara rasoda sama-sama ro o. Sira: banda nekeboik, mbuik kara, ma banda mana manodo-manamak kara, mita fo basa sara rasoda. ");
INSERT INTO txq_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","O muste muni basa nanaꞌak mata-matak kara reni ofak dale reu soa-neu ei, ma basa bandar raa.” ");
INSERT INTO txq_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Basa boe ma Noh tao tungga basa Manetualain parendan lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Basa boe ma MANETUALAIN kokolak no Noh nae, “Au mete uni sudi bee uu, tehuu hambu kada o mesa ngga ndia, dale ndoos. Huu naa de, o mua o sao-anam mara maso meni ofak dale miu leo. ");
INSERT INTO txq_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Numa basa bandar mata-matak kara mai fo ei bole miꞌan, ma bee fo ei bole menin fee Au, na, o here mala pasan hitu-hituk, fo muni sara reni ofak naa dale reu. Numa basa mbuik mata-matak kara mai oo, muni pasan hitu-hituk boe. Tehuu numa bandar laen nara mai, muni kada pasan esa-esak. No dalak naa, bandar ma mbuik kara raa dadi bini, fo ta ramaketu. ");
INSERT INTO txq_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Masaneda matalolole! Huu faik hitu bali, Au akonda udan ta namaketu hatu-leledon losa faik haa hulu. No dalak naa, Au akamate basa horis lalaꞌen marai mada lai fo Au akadadadi alak kara ena.” ");
INSERT INTO txq_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Basa boe ma Noh tao tungga basa MANETUALAIN parendan lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Neu lelek fo faa moꞌok mai naa, Noh teun nara 600. ");
INSERT INTO txq_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Boe ma Noh no saon, anan nara, ma feto-feun nara, maso reni ofak naa dale reu, fo ara rasoda numa faa moꞌok naa mai. ");
INSERT INTO txq_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Tungga MANETUALAIN parendan naa, boe ma Noh neni basa mbuik mata-matak kara, ma bandar laen nara, esa-esak no ndia pasan numa bee fo hatahori bole naꞌan, ma bee fo hatahori ta bole naꞌa sana, de ana neni sara ofak dale reu. ");
INSERT INTO txq_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Basa faik hitu, boe ma faa moꞌok lala mai, de mulai tatana nala dae-bafok ia. ");
INSERT INTO txq_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ndaa neu Noh teun nara 600, tamba bulak dua ma faik 17, boe ma faa moꞌok lala mai! Lelek naa, leo bali lelesu lalais neni soik, de oen mboꞌa dae mai. Ma basa oe bubuk kara marai dae dale kadi sara, de oe rasapupura dea mai. ");
INSERT INTO txq_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Boe ma udan konda ta namaketu hatu-leledon, losa faik haa hulu dalen. ");
INSERT INTO txq_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tehuu faik naa oo, Noh, saon, ana katelun nara, ndia Sem, Yafet, ma Ham, ma Noh feto-feun nara, maso reni ofak naa dale reu. ");
INSERT INTO txq_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ara maso sama-sama ro bandar, ndia banda nekeboik, banda fuir, banda mana manodo-manamak, mbuik kara, ma banda laen fo kalidak kara. ");
INSERT INTO txq_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Pasan esa-esak numa basa horis lalaꞌen mai, maso reni ofak dale reu, sama-sama ro Noh, tungga hata fo Manetualain fee parenda neun. Neu basa sara maso rala ofak dale, boe ma MANETUALAIN nggoe ofak naa lelesun. ");
INSERT INTO txq_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","19","Uda moꞌok konda nakandoo losa faik haa hulu, de faa moꞌok hene tamba namadema, losa ofak laa boꞌu-boꞌu. Oe hene nakandoo losa ana tatana nala lete demak kara. ");
INSERT INTO txq_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Oe naa hene ta namaketu, losa deman nakalena letek kara meter hitu. ");
INSERT INTO txq_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","No dalak naa, basa horis marai mada lai, mate basa sara. Ndia: hatahori dae-bafok, banda nekeboik, banda fuir, banda mana manodo-manamak, ma mbuik kara. Kada Noh ma basa marai ofak naa dale, rasoda. ");
INSERT INTO txq_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Oe naa ta reꞌe-reꞌe, losa faik 150. ");
INSERT INTO txq_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tehuu Manetualain ta lilii Noh sara no basa bandar marai ofak naa dale. De Ana fee anin mai fo fuu nareꞌe oe faa moꞌok naa. ");
INSERT INTO txq_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ana oo tatana basa oe bubuk kara marai dae-inak, ma Ana fee udan numa lalai mai hahae boe. ");
INSERT INTO txq_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Boe ma oe reꞌe nakandoo. Basa faik 150, boe ma oe sangga ta demak ka ena. ");
INSERT INTO txq_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ndaa no bulak kahitun seli faik 17, boe ma ofak naa hara neu lete demak esa, nade Ararat. ");
INSERT INTO txq_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Oe reꞌe nakandoo losa bulak kasalahunun faik kaesan, boe ma letek kara poin nara mulai mete-rita sara. ");
INSERT INTO txq_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Seli faik haa hulu, boe ma Noh soi ofak dinelan esa. ");
INSERT INTO txq_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Basa boe ma ana mboꞌi mbuik kaa esa. Mbuik naa lambu nakandoo neu-mai losa oe faa moꞌok reꞌe tebe-tebe ena. Ana ta fali neni ofak neu ena. ");
INSERT INTO txq_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Boe ma Noh mboꞌi seluk mbui lunda sina esa bali, fo sangga bubuluk oe naa, reꞌe tebe-tebe ena do beik. ");
INSERT INTO txq_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tehuu oe bei tatana nala basa dae-bafok, de mbuik naa ta hambu mamana sasaꞌek. Boe ma ana lambu fali neni ofak neu. Noh soro liman neu, de ana simbo nala falik mbuik naa maso neni ofak dale neu. ");
INSERT INTO txq_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noh nahani faik hitu bali, boe ma ana mboꞌi seluk mbuik naa. ");
INSERT INTO txq_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ledo bobon naa, mbuik naa fali neni Noh mai, ma ana neni ai setun dook esa, ana dei fo ketu nalan. Boe ma Noh bubuluk oe reꞌe tebe-tebe ena. ");
INSERT INTO txq_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ana nahani faik hitu bali, de ana mboꞌi seluk mbui lunda sina naa. Tehuu oek ia, mbuik naa ta fali ena. ");
INSERT INTO txq_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Neu Noh teun nara 601, ndaa no bulak kaesan, faik kaesan, oe reꞌe tebe-tebe ena. Boe ma Noh soi ofak naa dinelan, de ana mete sudi bee neu, te daer madak kara ena. ");
INSERT INTO txq_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Losa bulak kaduan, faik ka-27, dae mada tebe-tebe ena. ");
INSERT INTO txq_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Basa boe ma Manetualain kokolak no Noh nae, ");
INSERT INTO txq_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Noh! Hatematak ia ei basa ngga konda numa ofak ia mai leo. ");
INSERT INTO txq_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kalua heni basa bandar raa lalaꞌen leo! Ndia: banda nekeboik, banda fuir, banda mana manodo-manamak, ma mbuik kara. Ela sara fo basa sara tamba ramanoꞌu, ma rasofe dae-bafok ia.” ");
INSERT INTO txq_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Basa boe ma Noh no saon, anan nara, ma feto-feun nara, basa sara kalua numa ofak naa mai. Basa bandar raa oo kalua boe, esa-esak no ndia matan. ");
INSERT INTO txq_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Basa boe ma Noh totodo batur fo tao mei tunu-hotuk soa-neu MANETUALAIN. Numa bandar fo bole pake dadi neu banda tunu-hotuk kara mai, Noh haꞌi nala esa-esak. De ana hala fo hotu sara reu mei tunu-hotuk naa lain, dadi neu tanda makasi soa-neu MANETUALAIN. ");
INSERT INTO txq_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Neu MANETUALAIN hae nala tunu-hotuk naa boo menin, boe ma dalen namahoko. De Ana duduꞌa nae, “Mulai numa hatematak ia neu, Au ta akatoo dae-bafok ia bali, nahuu hatahori dae-bafok manggaraun. Leo mae ara duduꞌa kada manggarauk numa kadiꞌi anan nara mai, tehuu Au ta akalulutu basa horis lalaꞌen bali, sama leo Au taok naa ena. ");
INSERT INTO txq_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Losa neu dae-bafok ia bei hambun, ledo-fair ia laꞌok rakandoo, tungga sira dalan. Ndia: fai sele-tandek ma fai ketu-koruk, fai makasufuk ma fai hanas, fai fanduk ma fai udan, leledok ma leꞌodaek.” ");
INSERT INTO txq_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Manetualain fee babaꞌe-babatik neu Noh no anan nara, ma kokolak nae, “Ei bonggi mala noꞌun seli, fo tao masofe falik dae-bafok ia. ");
INSERT INTO txq_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Neu ko basa banda fuir, mbuik ma iꞌak kara ramataꞌu ei. Ei ndia muste lopo-linu sara. ");
INSERT INTO txq_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ei bole miꞌa basa bandar raa mbaan, sama leo ei oo bole miꞌa sele-tandek kara buna-boan boe. Basa iar, Au fee sara reu ei. ");
INSERT INTO txq_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Kada ei ta bole miꞌa mbaa bei kadaak, nahuu banda samanen nai daan dale. ");
INSERT INTO txq_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Au adu hatahori dae-bafok tungga Au mata-aong. Huu naa de ta bole hala misa hatahori dae-bafok. Mete ma hambu hatahori do banda, fo tao nisa hatahori dae-bafok, na, muste makanisa sara boe. Hohoro-lalanek ia numa Au mai. ");
INSERT INTO txq_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ei muste bonggi noꞌun seli, fo tao masofe dae-bafok ia bali.” ");
INSERT INTO txq_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Manetualain tuti seluk kokolan nae, ");
INSERT INTO txq_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Hatematak ia Au nau ndara fangga Au hehelu-bartaang ua ei, losa ei tititi-nonosim mara boe. ");
INSERT INTO txq_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Hehelu-bartaak ia oo soa-neu basa hata fo horis boe, ndia banda nekeboik, banda fuir, ma mbuik kara. Kekeꞌun, soa-neu basa hata fo ei sama-sama mia sara, kalua numa ofak naa dale mai. ");
INSERT INTO txq_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Au hehelu-bartaang naa, talo ia: Au ta haitua faa moꞌok bali, fo tao nisa basa hata fo horis lalaꞌen, ma akalulutu basa dae-bafok ia. ");
INSERT INTO txq_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Au tao Au elus neu lalai, fo dadi tanda nesenedak neu Au hehelu-bartaang ta mana ketuk ua ei, no basa hata fo horis lalaꞌen, ma dae-bafok ia. ");
INSERT INTO txq_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Mete ma hambu sosoꞌak nai lalai, boe ma elus dadi, na, neu ko ana fee nesenedak mai Au soa-neu hehelu-bartaak naa, nae: neu ko faa moꞌok ta nakalulutu basa hata fo horis lalaꞌen bali. No dalak naa, Au hehelu-bartaang ta mana basak naa, neni ndara fanggak ena no ei, ma no basa hata fo horis lalaꞌen.” ");
INSERT INTO txq_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noh anan nara mana kalua numa ofak naa mai, ndia Sem, Yafet ma Ham (Ham naa, Kanaꞌan aman). ");
INSERT INTO txq_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Basa hatahorir marai dae-bafok ia, tititi-nonosin nara konda numa Noh ana katelun nara mai. ");
INSERT INTO txq_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noh naa, hatahori mana ue daek. Ana ndia makasososan tao osi anggor. ");
INSERT INTO txq_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Laꞌe esa, ana ninu anggor losa mafu nalan seli. Boe ma ana lufa heni bualoꞌa-papaken, de ana sunggu lololi tao folik numa laan dale. ");
INSERT INTO txq_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Neu Ham mete-nita aman makaholan naa, boe ma ana nalai dea neu, fo neu nafada kaꞌan Sem no Yafet. ");
INSERT INTO txq_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Boe ma dua sara haꞌi rala lafa esa, de rakambembelan neu sira dua sara arun nara. Basa boe ma ara laꞌok rakadedeak reni laak naa dale reu, fo rakambambalu rala sira aman. No dalak naa, ara ta mete-rita sira aman nekeholan naa. Basa boe ma ara kalua dea reu. ");
INSERT INTO txq_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Neu Noh mamafun mulai lende, boe ma ana bubuluk ndia ana muri anan tatao-nonoꞌin. ");
INSERT INTO txq_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Boe ma ana kokolak nae, “Weeh! Kanaꞌan amanee! Au akatoo o! Neu ko o dadi muu o kaꞌam mara ata-daton! ");
INSERT INTO txq_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Kokoa-kikiok neu MANETUALAIN! Naa fo Ana fee babaꞌe-babatik neu Sem! Tehuu naa fo Kanaꞌan dadi neu Sem ata-daton. ");
INSERT INTO txq_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Elan fo Manetualain tao nambaloa Yafet dae oen; Ma tititi-nonosin leo-laꞌo mole-dame ro Sem tititi-nonosin. Tehuu elan fo Kanaꞌan dadi neu Yafet kulin.” ");
INSERT INTO txq_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Mulai numa faa moꞌok naa basa neu, Noh bei nasoda teuk 350 bali. ");
INSERT INTO txq_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Teun nara 950, boe ma ana mate. ");
INSERT INTO txq_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Basa faa moꞌok, boe ma Noh anan nara hambu tititi-nonosik. Ndia tititi-nonosik numa Sem, Yafet, ma Ham mai. ");
INSERT INTO txq_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","5","Yafet tititi-nonosin nara, ndia Gomer, Magog, Madai, Yawan, Tubal, Mesek, ma Tiras. Esa-esak no sira dedeꞌan, sira leon, ma sira dae oe heli-helin. Gomer tititi-nonosin nara, ndia Askenas, Rifat ma Togarma. Yawan tititi-nonosin nara, ndia Elisa, Tarsis, Kitim hatahorin nara, ma Dodanim, fo mana leo numa tasi tatain nara. ");
INSERT INTO txq_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham tititi-nonosin nara, sira Kus, Misraim, Put, ma Kanaꞌan. ");
INSERT INTO txq_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus tititi-nonosin nara, sira Seba, Hawila, Sabta, Raema ma Sabteka. Raema tititi-nonosin nara, sira Syeba ma Dedan. ");
INSERT INTO txq_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus ana toun, ndia Nimrod. Ndia naa, malangga musu ta hohoꞌak makasososan. ");
INSERT INTO txq_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ndia ta hohoꞌan hambun numa MANETUALAIN mai, losa ana oo dadi neu mana sombu ta hohoꞌak mateꞌen boe. Huu naa de hatahorir rasiꞌe kokolak rae, “Naa fo o dadi muu mana sombu ta hohoꞌak sama leo Nimrod, fo ana hambu ndia ta hohoꞌan numa MANETUALAIN mai.” ");
INSERT INTO txq_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Makasososan Nimrod toꞌu koasa mulai numa Babel, Erek Akad, ma Kalne mai. Basa naar rai Sinear. ");
INSERT INTO txq_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Numa naa mai, ana koasa tamba no Asyur. Basa boe ma ana nambaririik kota Niniwe, Rehobot-Ir, Kala, ");
INSERT INTO txq_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ma Resen manai Niniwe no Kala taladan. Basa naar, kota moꞌok kara. ");
INSERT INTO txq_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim tititi-nonosin nara, sira hatahori Ludim, Anamim, Lehabim, Naftuhim, ");
INSERT INTO txq_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Kasluhim ma Kaftorim. Hatahori Kasluhim naa, ndia hatahori Filistin nara bei-baꞌin. ");
INSERT INTO txq_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaꞌan ana ulun, ndia Sidon. Kanaꞌan oo dadi neu hatahori Het, ");
INSERT INTO txq_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusi, Amori, Girgasi, ");
INSERT INTO txq_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwi, Arki, Sini, ");
INSERT INTO txq_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwadi, Semari ma Hamati, bei-baꞌin nara. Kanaꞌan tititi-nonosin nara ratanggela losa dook ka ");
INSERT INTO txq_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","losa sira daen too-lanen nara mulai numa Sidon seku neni Gerar neu losa Gasa. Numa naa mai, neni Sodom, Gomora, Adma, Seboim losa Lasa neu. ");
INSERT INTO txq_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Sira basa naar, Ham tititi-nonosin. Esa-esak no sira dedeꞌan, sira leon, ma sira dae oe heli-helin. ");
INSERT INTO txq_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafet kaꞌan Sem, dadi hatahori Eber bei-baꞌin nara. ");
INSERT INTO txq_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem tititi-nonosin nara, sira Elam, Asyur, Arpakhsad, Lud ma Aram. ");
INSERT INTO txq_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram tititi-nonosin nara, sira hatahori Us, Hul, Geter ma hatahori Mas. ");
INSERT INTO txq_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakhsad anan, Sela. Sela anan, Eber. ");
INSERT INTO txq_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber hambu ana touk dua. Uluk, hambu nadek Pelek, (fo sosoa-ndandaan ‘bingga-baꞌek’), nahuu lelek naa, hatahorir rabingga-baꞌek nai dae-bafok. Fadin nade Yoktan. ");
INSERT INTO txq_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan tititi-nonosin nara, sira Almodad, Selef, Hasar-Mawet, Yerah, ");
INSERT INTO txq_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO txq_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO txq_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila ma Yobab. Sira basa sara iar, Yoktan tititi-nonosin nara. ");
INSERT INTO txq_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Sira mamana leleon nara raa, mulai numa Mesa mai, seku neu losa Sefar, ndia mamana mbuku letek nai boboak dulu. ");
INSERT INTO txq_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sira basa sara raa, Sem tititi-nonosin nara. Esa-esak no sira dedean, sira leon, ma sira dae oe heli-helin. ");
INSERT INTO txq_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Basa naar, Noh tititi-nonosin nara, esa-esak no sira leo heli-helin. Neu faa moꞌok hahae, sira iar ndia sasarak tao rasofe dae-bafok. ");
INSERT INTO txq_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Lele uluk, basa hatahorir rai dae-bafok kokolak pake kada dedeꞌak esak ka. ");
INSERT INTO txq_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Neu sira ketuk mulai lali reni boboan dulu reu, ara losa dae matetuk esa nai Sinear, boe ma ara leo reu naa. ");
INSERT INTO txq_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Basa sara rala harak rae, “Wee! Toranoo nggara ein! Mai fo ita tambaririik kota moꞌok esa. Ita muste tao batu mbilas, boe ma ita hotun losa natea. Ma ita totodo batu mbilas raa pake ter. Basa boe ma ita tambaririik manara mandema esa, suꞌun losa lalai, mita fo ita hambu nade kokoak. Mita fo ita dadi teu hatahori nusa moꞌok esa, hae tabingga-baꞌek.” ");
INSERT INTO txq_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Boe ma MANETUALAIN konda mai titino soba kota naa no manaran, fo ara rambaririik kana. ");
INSERT INTO txq_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Basa boe ma Ana kokolak nae, “Basa hatahori dae-bafok kara iar hatahori nusak esa, ma pake dedeꞌak esa. Hata fo ara taok hatematak ia, ia bei fo kada ue makasososak. Mbila-beinesak, mete ma basa sara rakaesa dadi reu esa, sama leo hatematak ia, neu ko ara bisa tao hata a mesan. ");
INSERT INTO txq_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Malole lenak Ita konda fo tao dedeꞌan nara esak matan, mita fo sira esa ta nala esa dedeꞌan bali.” ");
INSERT INTO txq_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Basa boe ma MANETUALAIN konda fo tao babalik sira dedeꞌan. No dalak naa, Ana tao hatahori dae-bafok kara raa sasarak reni basa mamanak kara rai dae-bafok ia reu. De ara ta rambaririik rakandoo kota naa ena bali. ");
INSERT INTO txq_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Huu naa de ara foi kota naa, nade Babel, (fo sangga sama leo dedeꞌa deꞌek esa sosoa-ndandaan ‘panggananaa’), nahuu MANETUALAIN tao babalik sira dedeꞌan ma tao sasarak kasa reni sudi bee reu, ndule dae-bafok ia. ");
INSERT INTO txq_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ia Sem tititi-nonosin nara. Neu faa moꞌok basa teuk dua ena, nandaa no Sem teun nara 100, boe ma ana hambu ana touk esa, nade Arpaksad. ");
INSERT INTO txq_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Basa boe ma Sem bei nasoda teuk 500 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Neu Arpaksad teun nara 35, boe ma ana hambu ana touk esa, nade Sela. ");
INSERT INTO txq_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Basa boe ma Arpaksad bei nasoda teuk 403 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Neu Sela teun nara 30, boe ma ana hambu ana touk esa, nade Eber. ");
INSERT INTO txq_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Basa boe ma Sela bei nasoda teuk 403 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Neu Eber teun nara 34, boe ma ana hambu ana touk esa, nade Pelek. ");
INSERT INTO txq_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Basa boe ma Eber bei nasoda teuk 430 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Neu Pelek teun nara 30, boe ma ana hambu ana touk esa, nade Rehu. ");
INSERT INTO txq_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Basa boe ma Pelek bei nasoda teuk 209 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Neu Rehu teun nara 32, boe ma ana hambu ana touk esa, nade Seruk. ");
INSERT INTO txq_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Basa boe ma Rehu bei nasoda teuk 207 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Neu Seruk teun nara 30, boe ma ana hambu ana touk esa, nade Nahor. ");
INSERT INTO txq_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Basa boe ma Seruk bei nasoda teuk 200 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Neu Nahor teun nara 29, boe ma ana hambu ana touk esa, nade Tera. ");
INSERT INTO txq_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Basa boe ma Nahor bei nasoda teuk 119 bali, ma ana hambu tamba seluk ana touk ma inak. ");
INSERT INTO txq_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Neu Tera teun nara 70 lenak, boe ma ana hambu ana touk telu, ndia Abram, Nahor ma Haran. ");
INSERT INTO txq_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera tititi-nonosin nara, talo ia: Tera anan nara, ndia Abram, Nahor ma Haran. Haran hambu ana touk esa, nade Lot. ");
INSERT INTO txq_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran mate numa ndia nggoro-tadu huun, nade Ur, nai hatahori Kasdim daen. Neu ana mate naa, aman Tera bei masodak. ");
INSERT INTO txq_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram sao nala Sarai. Nahor sao nala Haran ana inan, nade Milka. Haran oo hambu ana touk esa, nade Yiska. ");
INSERT INTO txq_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Tehuu Sarai kala tedis, ana ta bisa bonggi. ");
INSERT INTO txq_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Laꞌe esa, Tera nuni nala anan Abram, feto-feun Sarai, ma umbun Lot, de ara kalua laꞌo ela nggorok Ur. Lelek naa, ara sangga reni dae Kanaꞌan reu. Tehuu losa nggorok Haran, boe ma ara leo reu kada naa leo. ");
INSERT INTO txq_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Numa naa, Tera maten, neu teun nara 205. ");
INSERT INTO txq_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Lelek naa, MANETUALAIN kokolak no Abram ena nae, “Abram! O kalua laꞌo ela o nufanelum, o amam uman ma o nggoro-tadum. O muni mamanak esa muu, dei fo Au atudun neu o. ");
INSERT INTO txq_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Neu ko Au fee babaꞌe-babatik neu o. Ma o tititi-nonosim mara, neu ko ramanoꞌu, ma ara dadi reu hatahori nusa moꞌo ta hohoꞌak esa, losa hatahorir ralela o nadem. De neu ko o dadi muu mana fee babaꞌe-babatik neu hatahori laen. ");
INSERT INTO txq_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Neu ko Au fee babaꞌe-babatik neu hatahori fo mana fee babaꞌe-babatik neu o. Tehuu Au akatoo neu hatahori fo mana nakatoo o. Nenene matalolole! Neu ko basa hatahori nusa-nusak kara marai dae-bafok ia, hambu babaꞌe-babatik nahuu o.” ");
INSERT INTO txq_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Lelek naa, Abram teun nara 75. Ana nuni nala saon Sarai, ndia fadin anan Lot, haꞌi neni basa ndia hata-heton lalaꞌen, ma basa hatahori mana maue-osar fo ana hambu sara ruma kota Haran. Boe ma Abram asa laꞌo ela Haran, fo reni mamanak fo MANETUALAIN nafada neun ena. De ara laꞌok rakandoo, losa mamanak esa, nade Kanaꞌan. ");
INSERT INTO txq_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Losa naa, de Abram laꞌok eo ndule dae naa, losa deka no nggorok esa, nade Sikem. Boe ma ara leo taak deka ai huu moꞌok esa nai More. Lelek naa, hatahori Kanaꞌan nara bei leo numa naa. ");
INSERT INTO txq_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Numa naa, MANETUALAIN natudu aon neu Abram. Ana nae, “Neu ko Au fee nusak ia neu o tititi-nonosim.” Basa boe ma Abram totodo batur dadi neu mei batu esa fo paken dadi neu mei tunu-hotuk soa-neu MANETUALAIN fo mana natudu Ndia aon numa naa ena. ");
INSERT INTO txq_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Basa boe ma Abram asa lali reni letek nai kona reu, de ara leo taak numa nggorok Betel ma nggorok Ai taladan. Numa naa, ana nambaririik mei tunu-hotuk esa, de ana nakaluku-nakatele neu MANETUALAIN. ");
INSERT INTO txq_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Basa boe ma ana lali-lali mamanak, losa dae Negeb nai Kanaꞌan boboan kona. ");
INSERT INTO txq_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Laꞌe esa, hambu fai ndoe-laꞌas nalan seli numa nusa Kanaꞌan. Huu naa de Abram asa laꞌok ramadoo aon nara bali reni boboan kona reu losa nusa Masir. Ara leo taak reu naa. ");
INSERT INTO txq_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Neu ara rae maso reni nusa Masir reu, ana nafada saon Sarai nae, “Sarai, ee! O ia, manaꞌa hiek seli. ");
INSERT INTO txq_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","De mete ma hatahori Masir mete-rita o manaꞌa hiek talo ia, na, neu ko ara nau hala risa au, nahuu au ia o saom. No dalak naa, ara bisa leꞌa rala o. ");
INSERT INTO txq_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Dadi malole lenak, o mafada sara mae, au ia o kaꞌam. No dalak naa, ara ta hala risa au, tehuu neu ko ara malole ro au, nahuu o.” ");
INSERT INTO txq_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Neu Abram asa losa Masir ena, hatahorir mete-rita inak naa manaꞌa hiek seli. ");
INSERT INTO txq_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Neu mane Masir penggawen nara mete-ritan, boe ma ara koa inak naa manaꞌa hien numa manek matan. De ara leꞌa ro inak naa neni manek uman neu. ");
INSERT INTO txq_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Dadi manek malole neu Abram, nahuu Sarai. Boe ma manek fee mudak bandar reu Abram, sira: bibi hiek, bibi lombo, sapi, keledei ma onta. Ana oo fee mudak ata touk ma inak boe. ");
INSERT INTO txq_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tehuu no manek leꞌa nala hatahori sao inan neni ndia uman dale neu ena, huu naa de MANETUALAIN fee huku-dokik mata-matak neun no uma isi-oen nara. ");
INSERT INTO txq_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Basa boe ma manek noke nala Abram, de natanen nae, “Abram! O tao au talo bee ia ena? Tao hata de o ta mafada mae inak naa, o saom? ");
INSERT INTO txq_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Tehuu o mae ndia ia, o fadim! Ela faak ka au haꞌi alan dadi neu au saong! Ia, o saom ndia. Hatematak ia haꞌi malan fo malai laꞌo heok au matang ia leo!” ");
INSERT INTO txq_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Basa boe ma manek fee parenda neu ndia penggawen nara, fo ara husi kalua heni Abram, saon, ma basa sira bua-baꞌun nara lalaꞌen fo kalua numa nusak naa mai. ");
INSERT INTO txq_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Basa boe ma Abram laꞌo ela Masir, fo ana fali neni dae Negeb neu. Ana nuni no saon ma basa ndia hata-heton lalaꞌen. Fadin anan Lot oo tungga sara boe. ");
INSERT INTO txq_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram naa, namasuꞌi nalan seli. Banda nekeboin nara, lilo mbilas ma lilo fulak, noꞌun seli. ");
INSERT INTO txq_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Numa Negeb mai, ana leo lali-lali, losa ana fali neni nggoro Betel ma nggoro Ai taladan neu. Fai bakahulun ana leo nita numa naa ena. ");
INSERT INTO txq_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ma ana oo nambaririik mei tunu-hotuk ena boe. De ana nakaluku-nakatele neu MANETUALAIN numa naa. ");
INSERT INTO txq_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, fo mana tungga sama-sama no Abram naa oo, naena banda nekeboik noꞌuk ka boe, ma ndia hatahori mana maue-osan nara oo noꞌuk ka boe. ");
INSERT INTO txq_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Tehuu mamanak naa sangga ta loak ka soa-neu Abram ma Lot, ro basa sira hata-heton lalaꞌen, fo ara leo-laꞌo sama-sama reu naa. Basa boe ma Abram no Lot mana lolon nara mulai rareresi, nahuu naꞌu manai mamanak naa, ta dai sira bandan nara raꞌa. (Lelek naa, hatahori Kanaꞌan ma hatahori Feris oo bei leo ruma naa boe.) ");
INSERT INTO txq_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Basa boe ma Abram nafada anan nae, “Lot, ee! Ita iar nufaneluk esa. Boso losak ita dua ngga, esa ta malole no esa, boe ma ita hatahori mana maue-osan nara soa rahuur taa-taa. ");
INSERT INTO txq_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Dadi malole lenak ita dua ngga tabingga-baꞌek leo. Mamanak ia loak ka, de mete ma o here mala dae manai boboa kiin, na, au haꞌi ala dae manai boboa konan. Tehuu mete ma o here mala dae manai boboa konan, na, au haꞌi ala dae manai boboa kiin.” ");
INSERT INTO txq_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Boe ma Lot mete ndule basan. De ana mete-nita lee Yarden doken sofek no oe, losa nggoro Soar. Mamanak naa daen maisi-minak sama leo MANETUALAIN osin, ma sama leo dae Masir. (Lelek naa, MANETUALAIN bei ta nakalulutu kota Sodom no Gomora. De dae naa bei malole). ");
INSERT INTO txq_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Huu naa de Lot here nala basa lee Yarden doken lalaꞌen. De dua sara rabingga-baꞌek. Boe ma Lot neni boboak dulu neu. ");
INSERT INTO txq_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Tehuu Abram leo nakandoo numa dae Kanaꞌan. Ma Lot neu leo numa nggoro-nggorok mana deka kota Sodom nai Yarden doken. ");
INSERT INTO txq_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tehuu hatahori Sodom mara manggarauk sudi selik kana. Ma ara ta nau nenene neu MANETUALAIN. ");
INSERT INTO txq_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Neu Lot no Abram rabingga-baꞌek ena, boe ma MANETUALAIN nafada Abram nae, “Abram! Soba o leleuk sudi bee neu fo mete ndule basa mamanak kara numa mamanak fo o mambariik naa mai. Mete matalolole dea-matan ma kii-konan. ");
INSERT INTO txq_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Basa daer fo o mete-mitak kara raa, neu ko Au fee sara reu o, ma o tititi-nonosim mara, fo dadi neu ei pusakam nakandoo, losa doon naa neu. ");
INSERT INTO txq_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Neu ko Au fee o tititi-nonosim mara dadi ramanoꞌu sama leo sarakaek nai tasi tatain. Losa hatahorir ta bisa reke rala o tititi-nonosim mara dedesin. ");
INSERT INTO txq_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Hatematak ia o laꞌok eo ndule dae ia loa-narun. Huu basa naar, neu ko Au fee sara reu o!” ");
INSERT INTO txq_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Basa boe ma Abram asa lali mamanak, de reu leo seluk bali numa mamanak fo mana deka no ai huu moꞌok kara marai Mamre, deka no nggoro Hebron. Basa boe ma ana tia-totodo mei tunu-hotuk fo rakaluku-rakatele reu MANETUALAIN numa naa. ");
INSERT INTO txq_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Lelek naa, hambu manek haa rakabua, sira: Amrafel, manek nusak Sinear. Ariok, manek nusak Elasar. Kedarlaomer, manek nusak Elam. Ma Tideal, manek nusak Goyim. ");
INSERT INTO txq_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Lelek naa oo, hambu manek laen lima rakabua boe, sira: Bera, manek nusak Sodom. Birsa, manek nusak Gomora. Sinab, manek nusak Adema. Semeber, manek nusak Seboim. Ma manek nusa Bela (ndia nusak Soar). De manek kahaak kara raa reu ratati laban manek kalima laen nara raa. ");
INSERT INTO txq_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Manek kalimak kara raa rakabubua ro soldadun nara ruma Sidim doken, (fo hatematak ia roken rae, Tasi Mates). ");
INSERT INTO txq_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Netatik naa momori-dadadin talo ia: fai bakahulun manek Kedarlaomer parenda manek kalimak kara raa losa teuk 12. Tehuu neu teuk ka-13, boe ma ara foꞌa de laban ana. ");
INSERT INTO txq_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Neu maso teuk ka-14, boe ma manek Kedarlaomer, ma ndia nonoon manek kateluk kara raa, mai ro sira soldadun nara. Boe ma ara ratati rasenggi nusak hida. Sira: hatahori Refaim marai nusak Asterot-Karnaim, hatahori Susim marai nusak Ham, hatahori Emim marai nusak Sawe-Kiryataim, ");
INSERT INTO txq_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ma hatahori Hori marai letek Seir, losa mamana nees El Paran tatain. ");
INSERT INTO txq_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Basa boe ma ara lenggu fali reni En Mispat reu (fo hatematak ia nade Kades). Basa naa, ara rakalulutu hatahori Amalek kara nusan, ma hatahori Amori fo mana leo numa nusa Haseson-Tamar. ");
INSERT INTO txq_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Basa boe ma manek kalimak kara raa ator sira soldadun nara ruma Sidim doken, de ara ratati laban manek kahaak kara raa. ");
INSERT INTO txq_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nai dokek naa, hambu lifu ter noꞌuk ka. Neu ara ratati naa, manek Sodom ma manek Gomora ro soldadun nara ralai. Sira ketuk mbesi reni lifu ter dale reu, ma ketuk ralai reni letek reu. ");
INSERT INTO txq_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","De manek kahaak mana masenggik kara raa, reu fonda rala basa bua-baꞌu ma nanaꞌak kara ruma Sodom no Gomora mai. Boe ma ara fali reu sara. ");
INSERT INTO txq_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lelek naa, Abram anan Lot leo nai Sodom. De manek kahaak kara raa oo humu rala Lot asa, ma fonda rala basa bua-baꞌun nara boe. ");
INSERT INTO txq_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tehuu hatahori esa mboꞌi henin. De ana nalaik neu tui Abram, hatahori Ibrani. Lelek naa, hambu hatahori Amori esa, nade Mamre. Abram leo deka-deka no Mamre ai huu moꞌon nara. Mamre toranoon, ndia Eskol ma Aner. Sira raa, dadi Abram partein. ");
INSERT INTO txq_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Neu Abram namanene nala nae, hatahorir humu reni ndia fadin anan ena, boe ma ana nakabubua nala ndia hatahori mana maue-osan fo mana malela netatik. Sira basa sara hatahori 318. Basa boe ma reu husi manek kahaak kara raa losa nggorok Dan, dook ka nai boboan kii. ");
INSERT INTO txq_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Nai naa, Abram baꞌe ndia hatahorin nara dadi reu bubuak hida. Neu leꞌodae, boe ma ara reu nggafu fee hatahorir raa. Tehuu ketuk ralai. Boe ma Abram asa husi rahere sara losa nggoro Hoba, manai kota Damsik boboan kii. ");
INSERT INTO txq_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","No dalak naa, Abram sambu nala falik Lot no hatahorin nara, basa bua-baꞌun nara lalaꞌen, ma hatahori laen nara boe. ");
INSERT INTO txq_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Neu faik fo Abram fali numa tao nasenggi mane kahaak kara raa mai, boe ma manek Sodom mai soru Abram numa Sawe doken (hatahorir rasiꞌe roken rae, Manek Doken). ");
INSERT INTO txq_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Lelek naa, Melkisedek dadi manek kota Salem. Ma ndia oo malangga anggama numa Manetualain mana Demak Mateꞌen mai boe. Ana mai neni fee Abram roti no oe anggor. ");
INSERT INTO txq_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Boe ma ana kokolak fee babaꞌe-babatik neu Abram nae, “Elan fo Manetualain mana Demak Mateꞌen, mana nakadadadik lalai no dae-inak naa, fee babaꞌe-babatik neu o. Koa-kio neu Manetualain, mana tao o masenggi o musum mara.” Basa boe ma Abram baꞌe fee Melkisedek, babaꞌek esa numa salahunu mai, numa basa bua-baꞌur fo ana leꞌa nala falik kara raa. ");
INSERT INTO txq_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Boe ma manek Sodom doꞌor mbali Abram, de nae, “Papa Abram. Bua-baꞌur fo papa leꞌa nalak kara numa au musung nggara mai, elan fo papa soa basa sara. Tehuu au oke fee falik kada au hatahoring nggara.” ");
INSERT INTO txq_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Tehuu Abram naselu nae, “Au sumba-soo numa MANETUALAIN mana Demak Mateꞌen matan, fo mana makadadadik lalai no dae-inak ");
INSERT INTO txq_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ae, au ta nau haꞌi ala hata esa boe na numa o bua-baꞌum mara mai. Leo mae kada aba dook esa oo, au ta nau haꞌi ala sana boe. No dalak naa, o ta bisa kokolak mae, ‘Abram namasuꞌi, nahuu au.’ ");
INSERT INTO txq_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Au ta parluu hata-hata. Kada hata fo au hatahoring nggara pake sara ena, na, taon neu basa ena. Ma elan fo au nonong katelung nggara iar, Aner, Eskol ma Mamre, haꞌi reni sira babaꞌen.” ");
INSERT INTO txq_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Basa boe ma MANETUALAIN natudu aon neu Abram. De Ana nae, “Abram! O hae mamataꞌu. Huu Au ndia siꞌu heni ma mana babata o numa musu mai. Ma Au fee o nanala moꞌok.” ");
INSERT INTO txq_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Tehuu Abram nae, “MANETUALAIN. Leo mae MANETUALAIN baꞌe fee au hata-hata noꞌun talo naa oo, sosoan taa boe. Huu au ana taak fo fee au tititi-nonosik. Dadi nau hambu pusaka noꞌun seli tao neu hata? Bole-bole kada au atang, Eliasar numa Damsik mai, ndia hambu basa sara.” ");
INSERT INTO txq_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tehuu MANETUALAIN naselu nae, “Ta talo naa! O ana heli-helim ndia neu ko hambu pusaka naa, tehuu ta ata naa.” ");
INSERT INTO txq_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Boe ma Ana nuni no Abram dea neu, de nae, “Hatematak ia o mete muni lalai muu. Soba o mete neu nduuk kara raa. O bisa reke mala sara, do? O tititi-nonosim mara neu ko noꞌun nara desi leo nduuk kara raa!” ");
INSERT INTO txq_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Boe ma Abram simbok MANETUALAIN kokolan naa. De MANETUALAIN henggenee nalan dadi neu hatahori dalen ndoos, nahuu Abram namahere neun. ");
INSERT INTO txq_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Basa boe ma MANETUALAIN tuti seluk kokolan bali nae, “Au ia Manetualain. Au ndia nuni ua o kalua numa nggorok Ur mai ena, nai hatahori Kasdim asa daen. Ma Au ndia fee dae ia dadi neu o pusakam.” ");
INSERT INTO txq_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Tehuu Abram natane bali nae, “Tehuu talo bee MANETUALAIN? Talo bee fo au bisa bubuluk ae, neu ko dae ia dadi neu au pusakang?” ");
INSERT INTO txq_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Boe ma Ana naselu nae, “Talo ia! Mai fo ita ndara fangga hata fo Au kokolak bebeik kara ia. Hatematak ia muu haꞌi mala bandar fee Au: sapi ina esa, bibi hiek ina esa, ma bibi lombo mane esa. Basa sara muste teun nara beke teluk. Basa naa o haꞌi muni mbuik teu esa ma mbuik lunda sina esa bali.” ");
INSERT INTO txq_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Boe ma Abram neu haꞌi nala basa bandar raa. Basa de ana sefa seseri baꞌe duak sapi, bibi hiek, ma bibi lombo naa. Boe ma ana teri mbaar raa dadi babaꞌek dua reu daer, esa nasare esa, dadi neu baris dua. Tehuu ana ta seseri baꞌe mbuik kara raa. ");
INSERT INTO txq_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Basa boe ma mbuik mana naꞌa nenetuk kara mai fo nau raꞌa mbaar raa. Tehuu Abram husi heni sara. ");
INSERT INTO txq_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Neu ledo tesa, boe ma Abram sunggu seli. Ana nala meꞌi nae, makiu-makahatuk tatana nalan losa ana namataꞌu nalan seli. ");
INSERT INTO txq_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Boe ma MANETUALAIN nafadan nae, “Abram! Neu ko o masoda losa o mambalasi malan seli, ma mate no mole-damek, dei fo ara ratoi o no neulauk. Tehuu o tititi-nonosim mara neu ko reu dadi mana leo taak nai hatahori laen nusan. Neu ko hatahori numa nusak naa mai tao sara dadi reu kuli, boe ma ara tuni-ndeni tao doidoso sara sudi selik kana, losa teuk natun haa. Tehuu neu ko Au huku-doki hatahori nusak naa. Boe ma Au nuni ua o tititi-nonosim mara kalua numa naa mai, ma ara reni pusaka noꞌun seli. ");
INSERT INTO txq_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Neu ko Au koladu fo o tititi-nonosim mara dombe kaliman fali reni ia mai bali. Hatematak ia, hatahori Amorir leo nai dae ia lain. Hatahorir ia manggarauk kara, tehuu bei ta sudi selik kana. Neu ko mete ma o umbu-anam mara fali reni ia mai ena, Au nau pake sara fo huku-doki rakalulutu hatahari Amorir. Huu lelek naa, sira manggaraun nara sudi selik kana ena.” ");
INSERT INTO txq_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Neu leꞌodae ena, medak neu ma hambu raꞌo neni tamba dae kamasuk esa ma mbele mana mbilak esa unda-unda lele nesik mbaa baris kaduak kara raa taladan. ");
INSERT INTO txq_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Faik naa oo, MANETUALAIN ndara fangga hehelu-bartaan no Abram boe. Ana nafada nae, “Au helu-bartaa, neu ko Au fee nusak ia neu o tititi-nonosim, mulai numa lee Masir mai losa lee Efrat, ");
INSERT INTO txq_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","no basa hatahori Keni, Kenas, Kadmon, ");
INSERT INTO txq_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het, Feris, Refaim, ");
INSERT INTO txq_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori, Kanaꞌan, Girgasi, ma Yebus daen nara.” ");
INSERT INTO txq_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Lelek naa, Abram fali numa Masir mai ena, de ana leo teuk salahunu numa Kanaꞌan ena. Saon Sarai bei ta hambu anak. Sarai naena ata inak hatahori Masir, nade Hagar. Laꞌe esa, Sarai kokolak no Abram nae, “Papa! MANETUALAIN tatana au ana manan ena. De malole lenak papa muu sunggu mua au atang Hagar, mita fo ana bonggi fee au.” Boe ma Abram tungga ndia saon kokolan. De Sarai fee Hagar dadi neu Abram sao murin. ");
INSERT INTO txq_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Basa boe ma Abram neu sunggu-soro no Hagar, boe ma inak naa nairu. Tehuu neu Hagar bubuluk ana nairu ena, ana koa ao, de ana mete nakadadaek Sarai. ");
INSERT INTO txq_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Boe ma Sarai kokolak no Abram nae, “Au ndia fee ata naa, dadi neu o sao murim. Tehuu neu inak naa bubuluk ana nairu, de ana mete nakadadaek au. Basa naar, o salam! Elan fo MANETUALAIN naketu-naladi ita dua ngga dedeꞌan. Dei fo o bubuluk!” ");
INSERT INTO txq_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Basa boe ma Abram naselu nae, “Talo ia! O ia, sao uluk. Tehuu ndia naa kada sao murik a mesan. Dadi o ndia maena koasa neun. O nau tao hata mbalin, numa kada o mai!” Basa boe ma Sarai tao kada barakai boto-botok mbali Hagar, losa ana nalai. ");
INSERT INTO txq_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ana nalai losa moo sarakaek. Boe ma MANETUALAIN atan esa numa nusa tetuk do inggu temak mai, hambun deka no oe matak manai dalak mana neni Sur neu. ");
INSERT INTO txq_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Boe ma ana nae, “Wee! Hagar, Sarai atan! Tao hata de o nai ia? O numa bee mai, ma nau muni bee muu?” De Hagar naselu nae, “Au alai laꞌo ela au ina umang.” ");
INSERT INTO txq_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Boe ma MANETUALAIN atan kokoen nae, “Talo ia! Malole lenak o fali muni o ina uman muu. Ana tao o talo bee, na, simbo a mesan. ");
INSERT INTO txq_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","O boso mamataꞌu. Neu ko Au tao o tititi-nonosim namanoꞌu, losa hatahori ta bisa reke rala sara. ");
INSERT INTO txq_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Hatematak ia o kairuk. Ta dook ka te, o bonggi ana touk esa. O muste foin nade Ismael (fo sangga sama no dedeꞌa deꞌek laen esa sosoa-ndandaan nae ‘Manetualain namanene’), nahuu MANETUALAIN namanene o bubuꞌi nemetanim ena. ");
INSERT INTO txq_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tehuu kanak naa namoꞌo mamais a, ana leo-laꞌo dook ka numa toranoon nara mai. Huu ana sama leo ndara langga tema fo ana ta tungga rapa. See a mesan, ana laban asa. Ma basa hatahorir laban rasafalik kana.” ");
INSERT INTO txq_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar namanene basa talo naa, boe ma ana kokolak nai dalen dale nae, “Au mete-ita MANETUALAIN ena, fo mana loti-mete ma mana lopo-linu au.” Basa boe ma ana mulai noke Manetualain pake nadek, “Manetualain mana Faduli au.” ");
INSERT INTO txq_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Huu naa de hatahorir foi oe matak naa nade, Beer Lahai Roi, sosoa-ndandaan nae, “Oe matak numa Ndia mana masodak mai, fo mana faduli au.” Oe matak naa mamanan nai nggoro Kades no nggoro Beret talada heon. Oe matak naa bei hambun losa hatematak ia. ");
INSERT INTO txq_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Basa boe ma Hagar fali neu ngga. Boe ma ana bonggi ana touk esa. Abram foin nade Ismael. ");
INSERT INTO txq_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Neu Hagar bonggi Ismael, Abram teun nara 86 ena. ");
INSERT INTO txq_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Neu Abram teun nara 99, MANETUALAIN mai natudu aon neu Abram. Boe ma Ana kokolak nae, “Au ia, Manetualain mana Koasa Mateꞌen. O muste tungga makandoo Au hihii-nanaung, ma leo-laꞌo tungga ndoon. ");
INSERT INTO txq_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Au nau ndara fangga hehelu-bartaak ua o, ma tao o tititi-nonosim mara ramahefu ralan seli.” ");
INSERT INTO txq_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Boe ma Abram sendek luu-langgan fo nateꞌe langgan losa daer. De Manetualain kokolak nakandoo nae, ");
INSERT INTO txq_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Au tao hehelu-bartaak ua o, talo ia: neu ko o dadi muu hatahori nusak noꞌuk ka bei-baꞌin. Huu naa de o nadem ta Abram bali (fo sosoa-ndandaan ‘amak fo naden neni nelelak’), tehuu nade Abraham (fo sosoa-ndandaan ‘hatahori nusak noꞌuk ka bei-baꞌin’). ");
INSERT INTO txq_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Neu ko Au tao o tititi-nonosim mara ramahefu ralan seli. Ma neu ko Au oo ambaririik hatahori nusak noꞌuk ka numa sira mai, ma soꞌu manek noꞌuk ka numa tititi-nonosik kara raa mai boe. ");
INSERT INTO txq_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Au toꞌu akandoo Au hehelu-bartaang ua o, ma o tititi-nonosim mara. Hehelu-bartaak ia ta mana ketuk, huu Au ia, o mua o tititi-nonosim mara Manetualain. ");
INSERT INTO txq_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Basa dae Kanaꞌan ia, neu ko Au feen neu o mua o tititi-nonosim mara. Hatematak ia o kada leo taak nai ia. Tehuu neu ko o tititi-nonosim mara soa dae Kanaꞌan ia losa doon naa neu. Ma neu ko Au oo dadi neu sira Manetualain boe. ");
INSERT INTO txq_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Tehuu o ma o tititi-nonosim mara oo muste toꞌu mahere Au hehelu-bartaang ia no dale mahanik boe. Basa touk kara lalaꞌen muste sunat. ");
INSERT INTO txq_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Mulai numa hatematak ia neu, basa touk kara muste sunat mulai numa bei fo bonggi heni sara faik falu. O nufanelum, basa o hatahori mana maue-osam mara, ma ata-dato fo o hasa malak ena numa nusak laen mai, basa sara muste sunat. Sunat naa, dadi tanda neu ita dua ngga hehelu-bartaan, fo nakadite nai ei ao-inam. ");
INSERT INTO txq_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Touk bee fo ana ta sunat, ana ta hambu babaꞌek nai Au hehelu-bartaang dale, ma ana ta maso dadi neu Au hatahoring.” ");
INSERT INTO txq_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Basa boe ma Manetualain kokolak nakandoo bali nae, “Mulai numa hatematak ia neu, o boso moke o saom no nadek Sarai bali, tehuu moke mae kada Sara leo. ");
INSERT INTO txq_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Neu ko Au fee babaꞌe-babatik noꞌuk ka neu Sara, fo ana bonggi fee o ana touk esa. Tebe! Neu ko Sara dadi neu hatahori nusak noꞌuk ka bei-baꞌin. Ma neu ko Au soꞌu manek noꞌuk ka numa ndia tititi-nonosin mai.” ");
INSERT INTO txq_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Boe ma Abraham sendek luu-langgan fo nateꞌe langgan losa daer. Tehuu nai dalen dale ana hika. Ana duꞌa nae, “Tou lasi kalu merek, teuk 100 leo au ia, bei hambu anak bali? Ma Sara fo lasi nggoꞌo bauk ena, teuk 90, ana bei bonggi talo bee bali?” ");
INSERT INTO txq_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","De ana nafada Manetualain nae, “Manetualain! Elan fo kada Ismael hambu au pusakan oo ta hata-hata boe.” ");
INSERT INTO txq_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tehuu Manetualain naselu nae, “Taa! Huu neu ko o saom Sara, bonggi nala ana touk esa. O foin nade Isak. Au hehelu-bartaang neu ko konda neun no ndia titiiti-nonosin, losa doon naa neu. ");
INSERT INTO txq_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Au oo amanene hata fo o moke soa-neu Ismael ena boe. Huu naa de Au oo fee babaꞌe-babatik neun, ma Au tao tamba amanoꞌu ndia tititi-nonosin. Neu ko hambu mane leo 12 numa ndia tititi-nonosin mai. Ma neu ko ndia tititi-nonosin dadi hatahori nusak ta hohoꞌak esa. ");
INSERT INTO txq_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Leo mae talo naa, tehuu Au hehelu-bartaang ia neni ndara fanggak no kada o anam Isak. Neu ko teu mana maik ia, mete te ledo-fain talo ia, Sara bonggi kanak naa.” ");
INSERT INTO txq_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Manetualain kokolak basa talo naa, boe ma Ana laꞌo ela Abraham mesa kana neu naa. ");
INSERT INTO txq_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Faik naa oo, Abraham tungga memak Manetualain parendan boe. De ana sunat. Basa boe ma ana sunat Ismael ma basa touk kara marai ndia uman dale. Ana oo sunat basa ata-dato touk kara lalaꞌen boe. Lelek naa, Abraham teuk 99 ena, ma Ismael teuk 13. ");
INSERT INTO txq_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Faik esa, neu Abraham leo deka ai huu moꞌok kara marai Mamre. MANETUALAIN mai natudu aon neun numa naa. Tutuin talo ia: Faik naa katobi ndoos, de Abraham nanggatuuk nonori anin numa laak lelesu bolon. ");
INSERT INTO txq_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Neu Abraham botik matan, boe ma mete-nita hatahori telu rambariik nai naa. De ana nalaik neu soru sara lai-laik. Ana sendek luu-langgan, ");
INSERT INTO txq_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","de nae, “Papa nggara ein! Mete ma bisa, na, papa sara tuli taak nai au laang dei. Leo mae minu kada oe hiek oo malole boe. ");
INSERT INTO txq_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Papa sara hahae taak miu saꞌok. Dei fo kakanak kara haꞌi oe fo safe papa sara ein. ");
INSERT INTO txq_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ma au uu sadia nanaꞌak fee papa sara, fo hambu barakaik faa, dei fo papa sara laꞌo rakandoo. Huu au amahoko bisa aono-lalau papa sara.” Basa boe ma ara raselu rae, “Neu. Makasi noꞌun seli. Ai tuli.” ");
INSERT INTO txq_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Boe ma Abraham nalaik neni laak neu, de nafada Sara nae, “Lai-laik! Haꞌi mala tarigu neulauk lenak saku esa, fo tao roti.” ");
INSERT INTO txq_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Basa boe ma ana nalaik neni ndia sapin nara neu, de here nala sapi ana maao esa. De nadenu ndia atan hala sapi naa, ma nasu mbaan. ");
INSERT INTO txq_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Boe ma Abraham neu haꞌi susu, keju, ma mbaa sapi fo bei fo nasu ralak naa, de neni fee fuik kara raa. Neu ara raꞌa, ana nambariik neu ai huuk taen fo naono-lalau sara. ");
INSERT INTO txq_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Basa boe ma ara ratanen rae, “Abraham! O saon Sara nai bee?” De ana naselu nae, “Nai laak dale.” ");
INSERT INTO txq_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Boe ma esa numa sira hatahori kateluk kara raa mai kokolak nae, “Nai rarain teu mana maik ia, Au fali mai. Faik naa, o saom Sara bonggi nala ana touk esa ena.” Neu ara kokolak talo naa, Sara nenene numa lelesu dean mai. ");
INSERT INTO txq_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Lelek naa, Abraham no Sara memak rambalasi ralan seli ena, ma Sara oo ta hambu bulak ena boe. ");
INSERT INTO txq_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara namanene ara kokolak talo naa, boe ma ana hika nai dalen. De ana duꞌa nae, “Awii! Au ambalasi nggoꞌo-nggoꞌo talo ia, ma au saong mana malek ena. Talo bee de ai bei hii leo mana sao beuk, fo sangga anak bali?” ");
INSERT INTO txq_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Basa boe ma MANETUALAIN natane Abraham nae, “Tao hata de Sara hika? Ana duꞌa nae hata fo Au kokolak ia, ta dadi, nahuu ndia lasik ena, do? ");
INSERT INTO txq_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Au ia MANETUALAIN! Ta hambu hata esa boe na fo Au ta bisa taon. Masaneda matalolole, ee! Neu ko mete ma Au fali uni ia mai nai teu mana maik ia, na, Sara bonggi nala ana touk esa ena.” ");
INSERT INTO txq_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara namanene nala naa, boe ma namataꞌu. De ana laka nae, “Au ta hika, maa!” Tehuu MANETUALAIN naselu nae, “Memak o hika bebeik kara ia, maa.” ");
INSERT INTO txq_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Basa boe ma fuik kateluk kara raa laꞌo reni kota Sodom reu. De Abraham nafuli sara losa baꞌe dua dalak. Numa mamanak naa mai, ara bisa mete-rita Sodom. ");
INSERT INTO txq_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Boe ma MANETUALAIN kokolak nai dalen dale nae, “Malole lenak Au tui fee Abraham ae, Au ae akalulutu kota Sodom. ");
INSERT INTO txq_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Huu ndia tititi-nonosin nara tamba ramanoꞌu, ma ara dadi reu hatahori nusak ta hohoꞌak kara. Ma neu ko ndia oo dadi mana fee babaꞌe-babatik soa-neu basa hatahori nusa-nusak marai dae-bafok ia boe. ");
INSERT INTO txq_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Au here alan ena fo nanori anan nara ma hatahori laen nara, fo tungga rakandoo MANETUALAIN eno-dalan, fo ara leo-laꞌo no ndoos ma ta pepeko-leleko. Mete ma ara tao talo naa, na, Au tao atetu Au hehelu-bartaang ua Abraham.” ");
INSERT INTO txq_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Boe ma MANETUALAIN nafada Abraham nae, “Talo ia! Au amanene hatahori noꞌuk ka unggu-remu laꞌe-neu hatahori numa kota Sodom ma Gomora mai ena. Tatao-nonoꞌi manggaraun nara sudi selik kana ena. ");
INSERT INTO txq_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Huu naa de Au konda mai, fo Au nau parisa aong, basa hata fo Au amanenek kara raa, tebe do taa. Mete ma taa, na, neu ko Au bubuluk.” ");
INSERT INTO txq_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Neu MANETUALAIN bei kola-kola no Abraham, fuik kaduak kara raa laꞌo rakandoo reni kota Sodom reu. ");
INSERT INTO txq_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham neu deka-deka no Manetualain, boe ma ana kokoe nae, “Talo bee? Papa nau makalulutu hatahori ndoos no hatahori manggarauk sama-sama, do? ");
INSERT INTO txq_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Mete ma hambu hatahori ndoos 50 rai kota naa dale, na, Papa bei nau tao makalutu basa sara boe, do? Do Papa ta makalulutu kota naa, nahuu sira. ");
INSERT INTO txq_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Papa boso makalulutu sara talo naa! Boso losak hatahori ndoos sara raa oo mate tungga boe, nahuu Papa nau makalulutu hatahori manggarauk kara. Papa ndia dadi Mana Maketu-maladi Dedeꞌa nai lalai ma dae-inak ia. Ma Papa mesa kana bubuluk ena, naa mbeu seserik.” ");
INSERT INTO txq_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","MANETUALAIN naselu nae, “Mete ma Au hambu hatahori ndoos 50 rai kota Sodom, na, Au ta huku-doki kota naa, nahuu sira.” ");
INSERT INTO txq_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Boe ma Abraham kokolak bali nae, “Papa, au oke ambon, fo au kokolak faa bali. Au ia, hatahori dae-bafok nggoa bebek fo ta bubuluk hata esa boe na. ");
INSERT INTO txq_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Leo ta hambu hatahori ndoos 50, tehuu hambu kada 45, na, talo bee? Mete ma kuran kada hatahori lima, na, Papa bei nau nakalulutu kota naa, do?” Manetualain naselu nae, “Mete ma Au hambu hatahori ndoos 45 nai naa, na, Au ta akalulutu kota naa.” ");
INSERT INTO txq_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Basa boe ma Abraham kokoe seluk bali nae, “Mete ma hambu kada hatahori 40, na, talo bee Papa?” De Ana naselu nae, “Mete ma Au hambu 40, na, Au ta huku-doki sara.” ");
INSERT INTO txq_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham kokoe nakandoo bali nae, “Papa boso mamanasa, tehuu mete ma hambu kada hatahori ndoos 30, na, talo bee?” Ana naselu nae, “Mete ma Au hambu 30, na, Au ta huku-doki sara.” ");
INSERT INTO txq_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Boe ma Abraham noke naloe seluk bali nae, “Papa boso mamanasa, mete ma au atane faa bali. Mete ma hambu kada hatahori 20, na, talo bee?” De Ana naselu bali nae, “Mete ma hambu 20, na, Au ta akalulutu kota naa.” ");
INSERT INTO txq_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Boe ma Abraham nateꞌe ndia kokolan nae, “Papa! Au kokolak laꞌe esa bali, tehuu Papa boso mamanasa au, ee! Mete ma hambu kada hatahori ndoos 10, na, talo bee?” De Ana naselu nae, “Mete ma Au hambu hatahori ndoos 10 nai naa, na, Au ta akalulutu kota naa.” ");
INSERT INTO txq_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ara kola-kola basa talo naa, MANETUALAIN laꞌo nakandoo, boe ma Abraham fali. ");
INSERT INTO txq_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Neu Manetualain bei kola-kola no Abraham, Manetualain ata kaduan nara laꞌo rakandoo reni kota Sodom reu. Ara losa naa, boe ma ledo sangga nae tesa ena. Faik naa, Lot bei nanggatuuk numa kota naa lelesu mason. Ana mete-nita hatahori kaduak kara raa, boe ma neu soru sara. De ana sendek luu-langgan, ma nateꞌe langgan neu matan nara. ");
INSERT INTO txq_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Boe ma ana kokolak nae, “Papa nggara ein! Mai fo tuli taak nai au umang dei, mita fo Papa sara sasafe eim mara, ma sunggu nai naa. Naa fo beꞌe-mai huhua anan, dei fo Papa sara laꞌo makando.” Tehuu ara raselu rae, “Makasi. Tehuu hae masambute! Naa fo ai miu sunggu nai kada kota dae moon.” ");
INSERT INTO txq_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tehuu Lot kokoe nakandoo sara, losa ara nau leo taak nai ndia uman. Boe ma Lot asa tunu roti ma sadia mei, de raꞌa sama-sama. ");
INSERT INTO txq_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Fuik kara raa bei ta reu sunggu, te Sodom toun nara, basa sara moꞌo-kadiꞌik, mai eko-feo rala Lot uman. ");
INSERT INTO txq_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ara kii-bolu no hara barakaik neu Lot rae, “Weeh, Lot! Tou kaduak bebeik kara raa rai bee? Fee sara kalua ia mai, te ai nau bode sara!” ");
INSERT INTO txq_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Boe ma Lot kalua dea neu, basa boe ma kena lelesu neu. ");
INSERT INTO txq_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ana kokolak nae, “Toranoo nggara ein! Ei boso tao manggarauk talo naa neu au fuing nggara. ");
INSERT INTO txq_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Hena ei nenene dei, ee? Au ana feꞌong dua, sira bei ao tema. Naa fo au fee dua sara reu ei. Ei nau tao dua sara talo bee oo, naa numa kada ei mai boe. Tehuu ei boso tao hata esa boe na neu au fuing nggara. Huu tungga ita dala-hadan, na, au muste anea atalolole sara.” ");
INSERT INTO txq_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tehuu hatahori Sodom mara raa kii-bolu rae, “O boso sambor! O ia, kada hatahori mana leo taak nai ia! O hatahori deak, de o ta maena haak koladu ai. Malole lenak o malai laꞌo heok ia. Mete ma taa, na, ai tao mala o beran lenak numa hatahori kaduak kara raa mai!” Boe ma ara timba heni Lot, de basa sara rame-rame reu tara lelesu naa, fo rae rakalulutun. ");
INSERT INTO txq_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tehuu fuik kaduak kara raa soro liman nara reu, de ara leꞌa Lot neni uma dale neu, boe ma ara nggoe lelesu neu. ");
INSERT INTO txq_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Basa boe ma dua sara tao rapoke hatahori Sodom mara raa matan, losa ara rafaroroe sangga lelesu, tehuu ta hambu sana. ");
INSERT INTO txq_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Basa boe ma fui kaduak kara raa, kokolak mbali Lot rae, “Lot! MANETUALAIN bubuluk kota ia manggaraun ena. Ana nadenu ai mai fo nau makalulutu heni kota ia. De o bei maena nufaneluk laen nai kota ia, do taa? Mete ma hambu ana touk do, inak do, mane-feuk do, feto-feuk do, sudi see a mesan, na, muu mala sara fo kalua numa kota ia mai leo!” ");
INSERT INTO txq_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","De Lot neu natonggo no touk dua, fo nae tao sara dadi reu ndia mane-feun nara, boe ma ana nafada sara nae, “Nenene matalolole! Hatematak ia ei kalua lai-laik numa kota ia mai leo, te MANETUALAIN nae nakalulutun ena!” Tehuu ara duꞌa rae, Lot kada kokolak nakoa-kandiaok naa. ");
INSERT INTO txq_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Neu beꞌe-mai huhua anan, boe ma Manetualain ata kaduan nara raa, rakasetik Lot fo ara kalua lai-laik leo. Ara rae, “Lot! Mambadeik leo! Leꞌa muni o saom, ma ana ina kaduam mara raa, fo ei malai leo. Laꞌo ela kota ia. Boso losak ei mate hie-hie a, ma noe sama-sama mia kota ia.” ");
INSERT INTO txq_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tehuu Lot bei naeok, naa te MANETUALAIN nau tao nasoi-nasodan. Huu naa de fuik kaduak kara raa toꞌu rala liman nara fo ara leꞌa Lot, saon, ma ana ina kaduan nara, fo roo sara kalua numa kota naa mai. ");
INSERT INTO txq_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Boe ma esa numa fuik kaduak kara raa mai parenda nae, “Malaik tetebe, fo sangga masodak leo! Boso leuk dea! Boso hahae nai dokek! Malaik makandoo ndaꞌe meni letek naa miu, mita fo ei boso mate!” ");
INSERT INTO txq_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Tehuu Lot bala nae, “Awii, Papa! Boso talo naa! ");
INSERT INTO txq_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Papa memak tulun tao nasoi-nasoda ai ena. Tehuu letek naa doon seli! Boso losak ai bei ta losa naa, te sosoek hambu nala ai nai dala laladak ena. ");
INSERT INTO txq_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Papa mete dei. Hambu nggorok kadiꞌik esa ta dook ka numa ia mai. Nggorok naa sosoan-ndandaan taa. De mete ma Papa nau, na, naa fo ai miu sangga masodak nai kada naa leo.” ");
INSERT INTO txq_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ana naselu nae, “Neu! Miu leo! Neu ko au ta akalulutu nggorok naa. ");
INSERT INTO txq_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","De hatematak ia ei malai tetebe naa miu leo! Huu au ta bisa tao hata-hata, mete ma ei bei ta losa naa.” Mulai numa lelek naa neu, hatahori foi nggorok naa, nade Soar, sosoa-ndandaan nae, ‘kadiꞌik’. ");
INSERT INTO txq_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Neu ledo mulai hene, boe ma Lot asa losa Soar. ");
INSERT INTO txq_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Medak neu te, MANETUALAIN mboꞌa aꞌi no balerang mana mbilak numa lalai mai konda neni Sodom no Gomora neu. ");
INSERT INTO txq_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","MANETUALAIN nakalulutu basa kota ma nggorok marai nusak naa, no basa horis lalaꞌen marai naa, sira hatahori dae-bafok, banda-manur, ma sele-tandek kara. ");
INSERT INTO txq_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Neu ara ralaik, boe ma Lot saon leuk dea. Medak neu ma, ana dadi neu dii masik neuk ka. ");
INSERT INTO txq_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Neu beꞌe-mai huhua anan, boe ma Abraham fali neni mamanak fo afik ka ana nambariik kokoe MANETUALAIN naa neu. ");
INSERT INTO txq_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Boe ma ana mete memeli matan neni Sodom no Gomora, ma basa dokek kara raa neu. Ana mete neu te sudi nai bee, aꞌi masu bubuak mboka-mboka hene neni lalai neu. Ma aꞌi naꞌa heni basa sudi hata lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Manetualain tulun Lot kalua henin numa mamana mana hambu huku-dokik naa mai, neu faik fo Ana nakalulutu basa kotar raa, nahuu Ana nasaneda Ndia hehelu-bartaan neu Abraham. ");
INSERT INTO txq_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lelek naa, Lot namataꞌu leo nakandoo numa nggorok Soar. Huu naa de ana no ana inan dua sara lali reni letek reu. De ara leo numa luak esa dale. ");
INSERT INTO txq_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Laꞌe esa, ina ana kaꞌak kokolak no fadin nae, “Ndule basa mamanak ia, ta hambu touk esa boe na fo bisa mai sao no ita. Ma ta dook ka bali te papa boe nambalasi, de ana ta bisa hambu anak ena bali. ");
INSERT INTO txq_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","De malole lenak, ita pou takamafu papa. Basa boe ma ita sunggu-soro toon, mita fo ita tuti papa tititi-nonosin.” ");
INSERT INTO txq_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Boe ma leꞌodaen naa, ara pou rakamafu sira aman renik oe anggor. Basa boe ma ana ina kaꞌak neu sunggu-soro no aman. Tehuu tou lasik mafu nalan seli, losa ana ta bubuluk ana tao hata mbali ndia ana inan ena. ");
INSERT INTO txq_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Neu beꞌe-mai, boe ma kaꞌak nafada fadin nae, “Fadi! Leꞌodaek ka au sunggu-soro ua papa ena. Leꞌodaen ia, o babaꞌem. Dei fo ita pou takamafu papa bali, boe ma fadi maso muu sunggu-soro muan. No dalak naa, ita dua ngga sama-sama bisa hambu anak, fo tuti papa tititi-nonosin.” ");
INSERT INTO txq_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Leꞌodaen naa oo, ara pou rakamafu sira aman bali. Boe ma ina ana murik maso neu sunggu-soro no aman. Tehuu tou lasik mafu nalan seli ena, losa ana ta bubuluk ana tao hata mbali ndia ana inan. ");
INSERT INTO txq_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","No dalak naa, dua sara rairu numa sira ama bonggi heli-helin mai. ");
INSERT INTO txq_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Basa boe ma ina ana kaꞌak bonggi nala ana touk esa. Boe ma ana foin, nade Moab (fo liin sangga sama leo dedeꞌa deꞌek laen esa, sosoa-ndandaan ‘numa papa mai’). Ana ndia dadi neu hatahori Moab bei-baꞌin hatematak ia. ");
INSERT INTO txq_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Boe ma ina ana fadik oo, bonggi nala ana touk esa boe. Ana foin nade, Ben Ami (fo sosoa-ndandaan ‘anak numa au hatahoring mai’). Ndia naa, dadi neu hatahori Amon bei-baꞌin hatematak ia. ");
INSERT INTO txq_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Basa boe ma Abraham lali numa Mamre mai, neni dae Negeb manai boboan kona neu, de ana leo numa nggoro Kades ma Syur taladan. Tehuu ta dook ka, boe ma ana lali seluk bali neni nggoro Gerar neu. ");
INSERT INTO txq_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","De ana nafada hatahorir marai naa nae, Sara naa, ndia fadin. Huu naa de Abimelek, manek Gerar nadenu ndia hatahorin nara reu roke Sara fo roon neni uma manek neu. ");
INSERT INTO txq_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Leꞌodaek esa, Manetualain natudu aon neu manek nai meꞌis dale. Ana kokolak nae, “O sangga mae mate ia ena! Te o leꞌa mala hatahori saon na.” ");
INSERT INTO txq_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Tehuu Abimelek naselu nae, “Manetualain! Au bei ta koi laꞌe inak naa. Ma au oo ta sala boe. Abraham mesa kana ndia nae, inak naa, ndia fadin! Ma inak naa oo manaku talo naa boe. Huu naa de au adenu reu ralan no dale lolo-laok. Dadi Manetualain boso fee salak neu au!” ");
INSERT INTO txq_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Boe ma Manetualain naselu nae, “Memak Au bubuluk o dalem lolo-laok. Huu naa de Au ndia taon fo o ta koi laꞌe inak naa. No dalak naa, o ta tao salak mua Au boe. ");
INSERT INTO txq_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Hatematak ia o fee falik inak naa neni saon neu. Touk naa, Au mana toꞌu dedeꞌang. De moken fo ana hule-haradoi fee o, mita fo o boso mate. Tehuu mete ma o ta fee falik inak naa, na, o masaneda matalolole! Huu o mua basa o hatahorim mara lalaꞌen, neu ko mate.” ");
INSERT INTO txq_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Neu beꞌe-mai huhua anan, boe ma manek noke basa ndia penggawe nara, de ana tui ndia meꞌin. Boe ma basa sara ramataꞌu. ");
INSERT INTO txq_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Basa boe ma manek noke Abraham, de natanen nae, “Au tao sala hata neu o, losa tao sosoek neu au, ua au rau-inggung nggara talo ia? O ta bole tao hata fo ta neulauk talo ia. ");
INSERT INTO txq_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","O duduꞌa hata, losa o tao talo ia?” ");
INSERT INTO txq_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Boe ma Abraham naselu nae, “Papa manek! Au duꞌa ae, ei basa ngga ta mana malela Manetualain. De neu ko ei ketuk mae makanisa au, mita fo bisa haꞌi mala au saong. ");
INSERT INTO txq_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Au memak kokolak tebe ae, au fading ndia. Ai dua ngga ama esa, tehuu laen mama. Huu na de ai dua ngga esa tao esa neu sao holu ndaek. ");
INSERT INTO txq_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Dadi neu Manetualain nadenu ai miu sembo nusak, boe ma au afada au saong ae, ‘Mete ma ita teni bee teu, ma hatahorir ratane ita dua ngga tututin, ma mete ma o sue-lai au, na maselu mae ita dua ngga kaꞌa-fadik kara.’ ” ");
INSERT INTO txq_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","16","Basa boe ma manek Abimelek fee falik Sara. De ana nafada Sara nae, “Hatematak ia au bae o kaꞌam doi fulak rifun esa, fo dadi neu bukti nae, au bei ta tao sala hata-hata ua o. Mita fo basa hatahorir bubuluk talo naa!” Boe ma manek kokolak no Abraham nae, “Abraham! Au nusang ia neni soik soa-neu o. O nau muu leo nai bee a mesan, bole.” Basa boe ma ana oo fee Abraham, sapi, bibi hiek, ma bibi lombo boe. Ana oo fee ata touk ma inak boe. ");
INSERT INTO txq_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Fai bakahulun MANETUALAIN tatana basa inak kara ana manan fo mana leo nai Abimelek nusan, nahuu ana leꞌa nala Abraham saon. Tehuu neu manek fee falik Sara neni saon neu, boe ma Abraham hule-haradoi fo Manetualain buka seluk inak kara raa ana manan. De ara bisa bonggi fali. ");
INSERT INTO txq_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","7","Basa boe ma MANETUALAIN fee babaꞌe-babatik neu Sara, tungga Ndia hehelu-bartaan. Sara nairu nai Abraham fai lasin. Neu ana nae bonggi naa, Abraham teun nara 100 ena. Fain nara dai, boe ma ana bonggi ana touk esa. De Abraham foi kanak naa nade Isak (fo sosoa-ndandaan ‘ana hika’). Sara oo kokolak boe nae, “Manetualain tao nala au hika, nahuu hatematak ia au amahoko. Hatahorir duꞌa rae, nai au fai lasing ia, au ta bisa hambu anak ena. Naa te leo mae au sao toung lasik nggonggok ena, tehuu au bei bonggi feen. De hatematak ia, see a mesan namanene dedeꞌak ia, ara oo hika sama-sama ro au boe.” Neu bonggi heni Isak faik falu, boe ma Abraham sunat ana, tungga Manetualain parendan. ");
INSERT INTO txq_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Basa boe ma Isak tamba namoꞌo. Neu rae filan, boe ma Abraham tao feta moꞌok. ");
INSERT INTO txq_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Laꞌe esa, Sara mete-nita Ismael, fo Abraham sao murin Hagar anan, nakaminak nakoa-kandiaok no Isak. Sara mete-nita naa, boe ma kokolak no saon nae, “Husi heni ata-dato manuma Masir mai naa no anan leo! Au ta nau ana ata-dato naa simbo pusaka hata-hata. Kada au anang Isak mesa kana, ndia muste hambu basa sara.” ");
INSERT INTO txq_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham namanene Sara kokolak talo naa, boe ma ana nameda ta malole, nahuu Ismael naa ndia anan boe. ");
INSERT INTO txq_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tehuu Manetualain kokolak no Abraham nae, “Abraham! O boso duduꞌa o sao murim naa no anan. Tungga kada Sara hihiin, nahuu neu ko o hambu tititi-nonosik fo au helu-bartaak naa ena, nesik Isak. ");
INSERT INTO txq_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Tehuu Au oo fee babaꞌe-babatik neu o sao murin anan boe, nahuu ndia oo, o ana heli-helin boe. Neu ko ndia tititi-nonosin oo dadi neu hatahori nusak esa boe.” ");
INSERT INTO txq_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Neu beꞌe-mai huhua-anan, boe ma Abraham tao lepa-nggees fo fee Hagar, ma feen oe boto esa, ana nasalilin neu arun. Basa boe ma ana neu nafuli inak naa no anan Ismael, de ara laꞌo leo. Boe ma ara laꞌok ndule basa dae nees, mana deka nai Beer Syeba. ");
INSERT INTO txq_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Neu oe nininun nara basan ena, boe ma Hagar laꞌo ela anan neu ai huu anak esa saꞌon. ");
INSERT INTO txq_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Boe ma ana duduꞌa nai dalen dale nae, “Au daleng ta nalak kana, mete-ita kanak ia mamaten.” Boe ma ana nakadedeak, de nanggatuuk doon nai rarain meter 50 numa kanak naa mai. De buꞌi nakarereu. ");
INSERT INTO txq_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Manetualain oo namanene Ismael hara bubuꞌin boe, boe ma atan numa nusa tetuk do inggu temak mai, nanggou Hagar nae, “Hagar! Tao hata de o susa-sona talo ia? Boso mamataꞌu, huu Manetualain namanene kanak naa bubuꞌin ena. ");
INSERT INTO txq_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Hatematak ia o mambadeik leo fo muu mete kanak naa. Tao matetea dalen, huu neu ko Au ae tao ndia tititi-nonosin dadi neu hatahori nusak ta hohoꞌak esa.” ");
INSERT INTO txq_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Basa boe ma Manetualain tao nambaloa matan, de mete-nita oe matak esa numa naa. Boe ma neu nadai oe neni boto naa neu, de neu fee kanak naa ninu. ");
INSERT INTO txq_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Basa boe ma Ismael no inan leo numa moo sarakaek Paran. Ana namoꞌo mamais a, boe ma ana dadi neu mana kou malelak. Basa boe ma inan feen sao nala ana feꞌo Masir esa. Basa iar dadi, nahuu Manetualain sama-sama no Ismael. ");
INSERT INTO txq_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Lelek naa, manek Abimelek no ndia malangga musun, nade Fikol, mai ratonggo ro Abraham. Manek kokolak nae, “Abraham! Ai bubuluk ena mae, Manetualain sama-sama no o. Huu naa de o tao hata a mesan, basa-basan dadi. ");
INSERT INTO txq_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","De hatematak ia au oke o soꞌuk sumba-sook nai Manetualain matan mae, o ta pepeko-leleko au ua umbu-anang nggara. Sama leo au atudu au dale susueng neu o ena, de o muste matudu o dale susuem neu au ma nusak ia boe.” ");
INSERT INTO txq_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Boe ma Abraham naselu nae, “Hou! Au sumba-soo.” ");
INSERT INTO txq_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Tehuu basa boe ma Abraham kalaak manek nae, “Papa manek hatahorin nara leꞌa rala au oe matang esa.” ");
INSERT INTO txq_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Manek namanene nala naa, boe ma naselu nae, “Awii! Au bei fo amanene dedeꞌak ia. Tao hata de papa ta kalaak numa fai bakahulun mai? Au ta bubuluk see ndia tao.” ");
INSERT INTO txq_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","28","Basa boe ma Abraham no Abimelek ndara fangga hehelu-bartaak. Boe ma Abraham leꞌa sapi ma bibi lombo fo fee manek. Basa de ana tada feꞌe bibi lombo tenak hitu bali. ");
INSERT INTO txq_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Boe ma manek natanen nae, “Tao hata de o tao talo naa?” ");
INSERT INTO txq_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham nafada nae, “Papa manek simbo mala bibi lombo tena kahituk kara iar fo dadi neu tanda rae, papa manek manaku, au ndia kali oe matak ia.” ");
INSERT INTO txq_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Huu dua sara soꞌuk sumba-sook numa naa ena, de ara foi mamanak naa nade Beer Syeba. Sosoa-ndandaan nae, ‘Oe mata Sumba-sook’. ");
INSERT INTO txq_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ara sumba-soo basa, boe ma manek Abimelek no ndia malangga musun fali reni sira nusan Filistin reu. ");
INSERT INTO txq_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Basa boe ma Abraham sele ai huu tamariska esa numa Beer Syeba. Mulai numa lelek naa neu, ai huuk naa fee nesenenedak neu Abraham, fo numa naa ana nakaluku-nakatele neu MANETUALAIN mana Masodak Losa Doon Naa Neu. ");
INSERT INTO txq_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Basa boe ma Abraham leo taak nala dook ka numa hatahori Filistin nara nusan. ");
INSERT INTO txq_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ta dook ka boe ma Manetualain fora sudik Abraham dalen, fo nau nita ana namanene neu Manetualain, do taa. Boe ma Manetualain nanggoun nae, “Abraham!” De naselu nae, “Ia, Manetualain.” ");
INSERT INTO txq_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Basa boe ma Manetualain nadenun nae, “Nenene matalolole! Haꞌi mala o ana kise muꞌen fo o sue malan seli naa. Munin neni dae Moria neu, fo o taon dadi neu tunu-hotuk soa-neu Au. Losa naa, dei fo Au atudu o mamanan nai letek esa.” ");
INSERT INTO txq_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Neu beꞌe-mai huhua anan, boe ma Abraham tati ai nenaꞌak. Ana fufutu sara, de ana fua sara reu keledei lain. Boe ma ana no Isak, ma atan dua, laꞌo reni mamanak fo Manetualain nafada elak naa reu. ");
INSERT INTO txq_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ara laꞌo-laꞌo, de neu bei-nesan, Abraham mete-nita mamanak naa numa dook ka mai. ");
INSERT INTO txq_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Boe ma nafada ata kaduak kara raa nae, “Ei dua ngga mahani taak mai ia, mia keledei ia, ee! Au ua au anang mae meni lai naa miu, fo nau makaluku-makatele neu Manetualain. Basa dei fo ai fali meni ia mai bali.” ");
INSERT INTO txq_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Basa boe ma Abraham haꞌi nala ai nenaꞌak kara soa-neu tunu-hotuk naa, de ana ndae sara neu Isak arun. Ma ndia mesa kana neni dombe ma ai suꞌu kaꞌaꞌik. Neu dua sara laꞌok sama-sama, ");
INSERT INTO txq_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","boe ma Isak nanggou aman nae, “Papa!” De Abraham naselu nae, “Tao hata Isak?” Isak natane nae, “Papa. Ita tae tao tunu-hotuk. Ai nenaꞌak no aꞌin nai ia ena. Tehuu bibi lombo ana fo ita taon dadi neu tunu-hotuk nai bee?” ");
INSERT INTO txq_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Boe ma Abraham naselu nae, “Ana nggee! Neu ko Manetualain mesa kana ndia fee Ndia bibi lombo anan fo paken dadi neu tunu-hotuk.” Basa boe ma dua sara ndaꞌe rakandoo. ");
INSERT INTO txq_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Neu ara losa mamanak, fo Manetualain nafada elak naa, boe ma Abraham totodo batur fo tao mei mamana tunu-hotuk. De ana naduru ai nenaꞌak kara reu mei batu naa lain. Boe ma ana bonggobudi anan, de feen sunggu nalelengga neu ai nenaꞌak kara lain. ");
INSERT INTO txq_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Basa boe ma Ana haꞌi nala dombe, de nau hala anan. ");
INSERT INTO txq_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tehuu medak neu ma, MANETUALAIN atan nanggou numa lalai mai nae, “Wee! Abraham! Mahani dei!” Boe ma ana naselu nae, “Tao hata, Manetualain?” ");
INSERT INTO txq_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Harak naa nae, “O boso hala kanak naa! Boso tao hata esa neun boe na! Hatematak ia Au bubuluk ena ae, o tebe-tebe tungga Manetualain hihii-nanaun, nahuu o sadia memak ena fee o ana kise muꞌen naa neu Manetualain, fo dadi neu tunu-hotuk.” ");
INSERT INTO txq_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Basa boe ma Abraham mete-nita bibi lombo mane esa, susuran kado nai ai huu anak ndanan nara. Boe ma Abraham neu haꞌi nala bibi lombo naa, de ana tunun dadi neu banda tunu-hotuk soa-neu Manetualain, ngganti neu ndia anan. ");
INSERT INTO txq_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Dadi Abraham foi mamanak naa nade, ‘Neu ko MANETUALAIN sadia hata fo parluu.’ Huu naa de losa hatematak ia oo hatahorir kokolak boe rae, “Nai MANETUALAIN leten naa lain, neu ko Ana sadia hata fo parluu.” ");
INSERT INTO txq_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Basa boe ma Manetualain atan eki numa lalai mai bali nae, ");
INSERT INTO txq_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“MANETUALAIN mesa kana nae, ‘Au sumba-soo pake Au nade heli-heling, talo ia: o sadia memak fee Au o ana mane kise muꞌem fo dadi neu tunu-hotuk. Huu naa de ");
INSERT INTO txq_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","neu ko Au fee babaꞌe-babatik noꞌun seli neu o, ma o tititi-nonosim. Neu ko ara ramanoꞌu losa hatahorir ta bisa reke rala sara, sama leo nduuk kara rai lalai, ma sarakaek nai tasi tatain. O umbu-anam mara neu ko ara tao rasenggi basa sira musun nara. ");
INSERT INTO txq_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Numa o tititi-nonosim mai, neu ko basa hatahori nusa-nusak kara marai dae-bafok hambu babaꞌe-babatik, nahuu o tungga Au parendang ena.’ ” ");
INSERT INTO txq_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Basa boe ma Abraham no Isak konda fali reni ata kaduan nara reu, fo ara fali sama-sama reni Beer Syeba reu. Abraham asa leo nai naa. ");
INSERT INTO txq_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Laꞌe esa, Abraham namanene nala nae, ndia fadin Nahor saon Milka, bonggi nala anak kara ena. ");
INSERT INTO txq_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ana uluk, nade Us. Fadin nade Bus. Basa naa, Kemuel (fo dadi Aram aman). ");
INSERT INTO txq_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Boe ma Kesed, Haso, Pildas, Yidlaf, ma Betuel. ");
INSERT INTO txq_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel naa, Ribka aman. ");
INSERT INTO txq_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Tehuu Nahor oo hambu tamba seluk anak kara ruma sao tian mai, nade Reuma. Ana bonggi nala Teba, Gaham, Tahas, ma Maaka. ");
INSERT INTO txq_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Neu Sara mate, teun nara 127 ena. Neu ana mate naa, Abraham asa leo numa Kiryat-Arba (ndia Hebron) nai dae Kanaꞌan. Abraham buꞌi nakarereu, ma ana beꞌe-falufii saon fo mana matek naa ena. ");
INSERT INTO txq_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Basa boe ma Abraham neu natonggo no hatahori Het asa. Ana nafada nae, ");
INSERT INTO txq_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Au ia, kada leo taak nai ei taladam. Au dae oeng taa fo atoi au saong. De mete ma ei nau, na, au hasa ala ei daem bibiak faa, mita fo au atoin neu naa.” ");
INSERT INTO txq_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Boe ma ara raselu rae, ");
INSERT INTO txq_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Talo ia, Papa! Doo basa ia, ai tao papa sama leo lasik esa ena, fo ai fee hada-horomatak tebe-tebe neun. De papa here leo, dae bee ndia neulaun lenak fo nandaa papa hihiin. Ai simbo a mesan.” ");
INSERT INTO txq_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Boe ma Abraham nambariik, de kaur langgan fo fee hada-horomatak neu tenu daek, hatahori Het asa. ");
INSERT INTO txq_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","De ana nae, “Mete ma ei simbok au kokolang bebeik kara ia, na, au oke tulun ei fo kokolak mia tou lasi Sohar ana toun, Efron. ");
INSERT INTO txq_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Moken, mete ma bisa, na, ana seꞌo ndia luan, nade Makpela, mana nai osin boboan naa, neu au. Ana noke belin baꞌu hata a mesan, au bae. Au nau bae ketu belin nai ei basa ngga matam, mita fo dae naa dadi neu au enang. Au nau taon dadi neu ai mamana ratem mara.” ");
INSERT INTO txq_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Faik naa, Efron oo nanggatuuk sama-sama no hatahori Het asa boe. De ana oo namanene Abraham kokolan naa boe. Boe ma ana nambariik, de naselu Abraham numa basa hatahori lasin nara matan nae, ");
INSERT INTO txq_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Boso talo naa, papa! Talo ia dei. Au fee osi naa no luan Makpela neu papa. Papa matoi papa saon neu naa leo. Au loo lima dae naa neu papa nai au hatahoring nggara matan, mita fo basa sara dadi reu mana sakasiir!” ");
INSERT INTO txq_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Boe ma Abraham kaur seluk langgan neu hatahori Het asa. ");
INSERT INTO txq_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","De ana kokolak no Efron nae, “Naa oo malole boe, tehuu ei basa ngga nenene au dei. Au nau hasa ketu dae naa, mita fo au atoi au hatahoring nggara reu naa.” ");
INSERT INTO txq_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Efron naselu nae, “Dae naa belin kada doi fulak 400! Tao hata de ita dua ngga kada tahule aok neu-mai laꞌe-neu doik baꞌu anak naa? Papa muu fo matoi papa saom neu naa leo.” ");
INSERT INTO txq_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham nakaheik dae naa belin, tungga Efron kokolan. De numa basa hatahori Het asa matan fo mana dadi sakasiir maruma naa, Abraham reke doi fulak 400, de ana bae neu Efron. ");
INSERT INTO txq_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","De no dalak naa, Abraham laꞌe Efron daen, dadi neu ndia enan. Ndia dae fo manai Makpela naa, deka no Mamre (ndia Hebron). Ana hasa ketu dae naa no osin, luan, ma basa ai huuk manai dae lain. Basa hatahori Het lasin nara dadi reu sakasiir rae, dae naa no basa isin lalaꞌen dadi reu Abraham enan. Basa boe ma Abraham neu natoi Sara neni luak naa dale neu, nai dae Kanaꞌan. ");
INSERT INTO txq_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","No dalak naa, osi naa no luan fo makasososan hatahori Het asa daen, hatematak ia dadi neu Abraham enan ena, de ana taon dadi neu mamana rates sara. ");
INSERT INTO txq_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham teun naruk ka losa ana nambalasi nalan seli. Ma MANETUALAIN nanea natalololen, boe ma Ana feen leo-laꞌo no mole-damek. ");
INSERT INTO txq_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Abraham naena hatahori nemeherek esa, mana koladu basa ndia hata-heton lalaꞌen. Laꞌe esa, Abraham nanggou nalan, de nae, “Nenene matalolole! Au oke o sumba-soo mates, pake MANETUALAIN naden. Fo ndia Manetualain mana makadadadik lalai no dae-inak. Mae, o ta bole haꞌi mala inak numa hatahori Kanaꞌan nara ia mai, fo feen sao nala au anang Isak. ");
INSERT INTO txq_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Tehuu o muste muni au nusa huung muu, nai au nufanelung nggara. O sangga mala ana feꞌok esa nai naa fo feen sao nala au anang.” ");
INSERT INTO txq_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Basa boe ma ata naa natane Abraham nae, “Malole, Papa! Tehuu mete ma ana feꞌok naa ta nau ia mai, na, talo bee? Mete ma talo naa, na, au muste ua papa anan fo neu sao nai naa, do talo bee?” ");
INSERT INTO txq_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham naselu nae, “O masaneda matalolole! Leo mae talo bee oo, o ta bole mua au anang naa neu boe. ");
INSERT INTO txq_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Masaneda te MANETUALAIN mana toꞌu koasa nai lalai, neni au kalua numa au nusa huung mai ena, boe ma nafuli au losa dae ia. Ana oo ndara fangga hehelu-bartaak no au ena nae, ‘Neu ko Au fee basa dae ia neu o titisi-nonosim.’ De o boso babati! Kada muu leo. Neu ko Manetualain nadenu Ndia atan numa nusa tetuk do inggu temak mai nasosoi dalak fee o, fo o bisa matonggo mua ana feꞌok naa, fo neu ko dadi neu au anang saon. ");
INSERT INTO txq_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Tehuu mete ma ana feꞌok naa ta nau tungga o muni ia mai, na, o makamboꞌik numa sumba-sook ia neu. Leo mae talo bee oo, o boso mua au anang neni naa neu boe.” ");
INSERT INTO txq_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Boe ma ata naa soꞌuk sumba-sook no Abraham nae, neu ko ndia tao tungga basa Abraham hihii-nanaun. ");
INSERT INTO txq_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Basa boe ma ata naa here nala banda onta salahunu. De ana fua bua-baꞌu neulauk mata-matak kara reu ontar raa lain. Boe ma ana laꞌo neni Nahor kotan neu, nai Mesopotamia. ");
INSERT INTO txq_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Mateꞌen, ata naa losa kota naa. Boe ma ana no ontan nara hahae aok numa kota tatain, deka oe matak esa. Faik naa bobok ena, ndaa no ana feꞌok kara reu ndui oe numa oe matak naa. ");
INSERT INTO txq_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Boe ma ata naa hule-haradoi nae, “MANETUALAIN, au malanggang, Abraham Manetualain. Tulun buka dalak, mita fo au mamaing ia neni ua-nale neulauk. Matudu Manetualain dale susuen neu au malanggang ma masaneda ndia hehelu-bartaan neu au. De naa fo au atonggo ua inak fo ae taon dadi neu Isak saon. ");
INSERT INTO txq_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Manetualain, au ambariik nai oe matak ia tatain. Ma ana feꞌok kara ruma kota mai ndui oe nai ia. ");
INSERT INTO txq_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","De au hule talo ia: Mete ma au kokolak ua ana feꞌok esa ae, ‘Ana feꞌok, ee! Tulun makonda o ure oem fo fee au inu oe faa dei.’ Mete ma ana naselu nae, ‘Papa minu leo! Ma dei fo au fee papa ontan nara oo rinu oe boe.’ Naa dadi tanda nae, ana feꞌok naa ndia Manetualain here nalan dadi neu Isak saon ena! No tanda talo naa, au bisa bubuluk ae, Manetualain natudu Ndia dale susuen neu au malanggang Abraham ena.” ");
INSERT INTO txq_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Ana bei ta hule-haradoi nateꞌe, te ana feꞌok esa mai. Naden Ribka. Ndia naa, Abraham fadin Nahor no saon Milka umbun. Ribka aman, nade Betuel. Ribka naa, manaꞌa hiek sudi selik kana ma bei ao tema. Ana konda neni oe matak naa dale neu, boe ma ana nadai oe neni ure oen neu, basa boe ma ana hene fali. ");
INSERT INTO txq_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Neu Ribka losa lain, boe ma Abraham atan nalaik neu natonggo noon. De ana noke nae, “Ana feꞌok. Tulun fee au inu oe faa dei.” ");
INSERT INTO txq_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ana feꞌok naa naselu nae, “Minu leo, toꞌo!” Boe ma nakonda ure oen lai-laik, de ana fee ata naa ninu. ");
INSERT INTO txq_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ana ninu basa, boe ma ana feꞌok naa nae, “Naa fo au ndui oe fee toꞌo ontan nara, fo rinu losa rakabete.” ");
INSERT INTO txq_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Boe ma ana neu sali oe lenan neni bandar haꞌon nara reu. De ana nalaik konda-hene neu ndui oe numa oe matak naa mai, fo fee basa ontar raa rinu losa rakabete. ");
INSERT INTO txq_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Abraham atan nambariik matu-matu, fo ana mete naherek ana feꞌok naa ue-tataon. Ana duduꞌa nae, “Ana feꞌok ia ndia MANETUALAIN here nalan, do?” ");
INSERT INTO txq_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ontar raa rinu losa rakabete. Boe ma ata naa haꞌi nala ndeli iduk lilo mbilas ma kale lilo mbilas pasan esa, de ana olu sara reu ana feꞌok naa liman dua sara. ");
INSERT INTO txq_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Basa boe ma ata naa natane nae, “Ana feꞌok papan, nade see? Mete ma bisa, na, au sunggu taak nai ana feꞌok papan uman.” ");
INSERT INTO txq_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Boe ma ana feꞌok naa naselu nae, “Au papang, nade Betuel. Au baꞌing, ndia Nahor. Ma au being, ndia Milka. ");
INSERT INTO txq_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nai ai uman hambu mamana susungguk dai toꞌo sara. Ma hambu naꞌu noꞌuk ka soa-neu toꞌo bandan nara.” ");
INSERT INTO txq_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Basa boe ma ata naa nateꞌe langgan, de ana nakaluku-nakatele neu MANETUALAIN. ");
INSERT INTO txq_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","De ana kokolak nae, “Koa-kio MANETUALAIN! MANETUALAIN soi dalak fee au ena, losa au atonggo matang ua papa Abraham nufanelun nai ia. No dalak naa, MANETUALAIN natudu dale susuen neu au malanggang Abraham, no tao natetu ndia hehelu-bartaan neu au.” ");
INSERT INTO txq_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Basa boe ma ana feꞌok naa nalai fali lai-laik, de ana tui basa uma isin nara, hata fo dadi ena. ");
INSERT INTO txq_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ribka naan, nade Laban. Ana mete-nita bua lilo mbilas sara raa, ma namanene Ribka tutuin, boe ma Laban nalai dea neu lai-laik, de neu natonggo no ata naa fo bei nambariik no ontan nara deka oe matak naa. ");
INSERT INTO txq_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Boe ma Laban kokolak nae, “Toꞌo! MANETUALAIN nakalalaꞌok toꞌo losa ia no sodak. De boso mambariik muu dea ia! Mai teni ai uman teu. Ai sadia memak kama ena. Nanaꞌak soa-neu toꞌo ontan nara oo mana hetak boe.” ");
INSERT INTO txq_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Basa boe ma Abraham atan tungga no Laban, de maso reni Betuel uman reu. Boe ma Laban asa sou rakonda fufuak ruma ontar lain mai. Ara fee ontar raꞌa naꞌu. Ma ara oo reni oe fee ata naa no hatahorin nara, de ara safe ein nara boe. ");
INSERT INTO txq_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Neu ara mbeda nanaꞌa-nininuk kara reu mei lain, boe ma ata naa nae, “Ai mae miꞌa-minu, tehuu au oke parmisi fo afada dale hihiik esa dei.” Boe ma Laban naselu nae, “Toꞌo kokolak leo.” ");
INSERT INTO txq_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ata naa nae, “Au ia, ei baꞌim Abraham atan. ");
INSERT INTO txq_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","MANETUALAIN fee babaꞌe-babatik noꞌuk ka neu au malanggang ena, losa ana namasuꞌi nalan seli. MANETUALAIN feen lilo mbilas, lilo fulak, ata tou ma inak, ma banda noꞌun seli, sira: sapi, onta, keledei, bibi hiek ma bibi lombo ena. ");
INSERT INTO txq_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Neu au malanggang touk no inak lasik kara ena, boe ma mama Sara bonggi fee au malanggang Abraham, ana touk esa. Neu ko kanak naa ndia simbo basa au malanggang Abraham pusakan lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Laꞌe esa, au malanggang Abraham fee au sumba-soo ae, ‘O ta bole haꞌi ana feꞌok Kanaꞌan, fo feen sao nala au anang Isak. ");
INSERT INTO txq_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Tehuu o muste haꞌi ana feꞌok numa au nufanelu heli-heling nggara mai, dadi neu ndia saon.’ ");
INSERT INTO txq_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Boe ma au atane au malanggang ae, ‘Mete ma ana feꞌok naa ta nau tungga au, na, talo bee?’ ");
INSERT INTO txq_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ana naselu nae, ‘MANETUALAIN fo au soa tungga kada Ndia hihii-nanaun, neu ko Ana nadenu atan numa nusa tetuk do inggu temak mai soi dalak fee o, mita fo o bisa hambu ana feꞌok esa numa au nufanelu heli-heling nggara mai, fo dadi neu au anang saon. ");
INSERT INTO txq_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tehuu mete ma au nufanelung nggara ta simbok fo ta nau fee ana feꞌok naa neni ia mai, na, o makamboꞌik numa sumba-sook naa mai.’ ");
INSERT INTO txq_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","De neu bebeik kara ia losa oe matak, boe ma au hule-haradoi nai au daleng ae, ‘MANETUALAIN, au malanggang Abraham Manetualain. Tulun soi dalak, mita fo au mamaing ia neni ua-nale neulauk. Naa fo au atonggo ua inak fo ae taon dadi neu Isak saon. ");
INSERT INTO txq_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Manetualain, au ambariik nai oe matak ia tatain. Ma ana feꞌok kara ruma kota mai ndui oe nai ia. De au hule talo ia: mete ma au kokolak ua ana feꞌok esa ae, “Ana feꞌok, ee! Tulun makonda o ure oem fo fee au inu oe faa dei.” ");
INSERT INTO txq_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Mete ma ana naselu nae, “Papa minu leo! Ma dei fo au fee papa ontan nara oo rinu boe.” Naa dadi neu tanda nae, ana feꞌok naa ndia Manetualain here nalan dadi neu au malangga anang saon ena!’ ");
INSERT INTO txq_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Au bei ta hule-haradoi basa, te ana feꞌok Ribka mai ena neni ndia ure oen, fo ndui oe nai oe matak. Neu ana hene nalak ka lain, boe ma au oke ae, ‘Ana feꞌok, ee! Fee au inu oe faa dei.’ ");
INSERT INTO txq_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Boe ma ana nakonda ure oen lai-laik, de nae, ‘Toꞌo minu leo! Ma dei fo au fee toꞌo ontan nara oo rinu boe.’ Boe ma au inu, ma au ontang nggara oo rinu boe. ");
INSERT INTO txq_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Boe ma au atane ae, ‘Ana feꞌok papan, nade see?’ Ana naselu nae, ‘Au papang, nade Betuel. Au baꞌing, ndia Nahor ma au being ndia Milka.’ De au kado ndeli neu idun, ma olu kaler lilo mbilas pasan esa neu liman nara. ");
INSERT INTO txq_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Boe ma au ateꞌe au langgang fo akaluku-akatele neu Manetulaian ae, ‘Koa-kio Manetualain! Manetualain soi dalak fee au ena, losa au atonggo aong ua au malanggang Abraham nufanelun nai ia. Ma au atonggo aong ua inak fo ae taon dadi neu malangga anak Isak saon.’ ");
INSERT INTO txq_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Dadi hatematak ia, mete ma papa sara nau matudu susuem neu au malanggang Abraham, na, mafada au no ledo-ledo. Mete ma taa oo, mafada no ledo-ledo boe, mita fo au bubuluk au muste tao hata.” ");
INSERT INTO txq_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ata naa kokolak basa, boe ma Laban no Betuel raselu rae, “Mete ma MANETUALAIN ndia nanaen talo naa ena, na, ai nau talo bee bali. ");
INSERT INTO txq_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ana feꞌok Ribka nai ia. Moke malan fo mian naa neu leo. Mita fo ana dadi neu baꞌi Abraham feto-feun, tungga hata fo MANETUALAIN naen ena.” ");
INSERT INTO txq_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abraham atan namanene nala naa, boe ma ana nateꞌe langgan losa daer, de noke makasi neu MANETUALAIN. ");
INSERT INTO txq_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Boe ma ana kalua heni bua lilo mbilas, lilo fulak, ma bua-loꞌa neulauk kara, de feen neu Ribka. Ana oo fee Ribka naan ma inan, hadia bua mabelir boe. ");
INSERT INTO txq_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Basa boe ma Abraham atan no ndia hatahorin nara ranggatuuk raꞌa-rinu. Boe ma ara sunggu ruma naa. Neu beꞌe-mai huhua anan ara beꞌe, boe ma ata naa nafada tenu umak nae, “Au oke luas fo mete ma bisa, na, hatematak ia ai nau fali meni au malanggang miu.” ");
INSERT INTO txq_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tehuu Ribka kaꞌan no inan rae, “Ei nau hailai laꞌo tao hata? Elan fo Ribka leo no ai faik salahunu talo naa dei. Basa, na, mian laꞌo leo.” ");
INSERT INTO txq_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Tehuu ata naa naselu nae, “Awii! Boso kaꞌi au! Huu MANETUALAIN tulu-fali nala au ena, losa au atonggo ua malangga anak saon ena. De mama sara makamboꞌik ai, fo ai fali miu tui au malanggang dei.” ");
INSERT INTO txq_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Boe ma ara raselu rae, “Talo ia! Mai fo ita tatane aon neu kada Ribka. Ndia hihiin talo bee?” ");
INSERT INTO txq_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Basa boe ma ara roken, de ratanen rae, “Ribka! Hatematak ia numa kada o mai. O nau tungga memak mua hatahori ia leo, do talo bee?” Boe ma ana naselu nae, “Au nau tungga.” ");
INSERT INTO txq_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","De ara mboꞌik Ribka, no ata inan fo mana malalaun numa kadiꞌin mai, fo reu ro Abraham atan nara. Boe ma ara kokolak fee babaꞌe-babatik neu Ribka rae, “Ribka! Ai mamahena Manetualain fee o bonggi noꞌuk ka, fo o tititi-nonosim neu ko dadi neu rifu-rifuk kara. Ma ai oo mamahena o tititi-nonosim tao rasenggi musun nara boe!” ");
INSERT INTO txq_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Basa boe ma Ribka no ata inan nara rafafaꞌu bua-loꞌan nara, boe ma ara saꞌe onta, de ara laꞌo leo, tungga Abraham atan nara. ");
INSERT INTO txq_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isak leo numa dae Negeb. Faik naa, Ana bei fo fali numa oe matak manai Beer Lahai Roi mai. ");
INSERT INTO txq_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ledo bobok esa, ana kalua numa laak mai, fo neu laꞌo-laꞌo haꞌi anin. Ana botik matan, boe ma mete-nita ontar mai. ");
INSERT INTO txq_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Neu Ribka mete-nita Isak, boe ma ana konda lai-laik numa ontan mai. ");
INSERT INTO txq_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ana natane Abraham atan nae, “Toꞌo! Tou mana laꞌok mai naa, see?” Ata naa naselu nae, “Ndia naa, au malangga anang.” Boe ma Ribka haꞌi nala tema popoi langgan, de ana lalaa nafuni matan. ");
INSERT INTO txq_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Boe ma ata naa tui basa-basan neu Isak. ");
INSERT INTO txq_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","De Isak noke no Ribka neni inan laan dale neu, boe ma dua sara rauma-loo leo. Isak sue nala Ribka sudi selik kana, huu naa de ana ta susa-sona bali no inan mamaten. ");
INSERT INTO txq_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham sao seluk inak esa, nade Ketura. ");
INSERT INTO txq_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura bonggi feen anak kara, sira: Simran, Yoksan, Medan, Midian, Isbak ma Sua. ");
INSERT INTO txq_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan anan nara, sira: Seba no Dedan. Dedan tititi-nonosin nara, sira: hatahori Asyur, hatahori Etus, ma hatahori Leum. ");
INSERT INTO txq_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian anan nara, sira: Efa, Efer, Henok, Abida ma Eldaa. Sira basa sara raa, Ketura tititi-nonosin. ");
INSERT INTO txq_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Neu Abraham bei masodak, ana baꞌe fee Hagar ma Ketura anan nara ena, esa-esak no ndia hata-heton. Basa boe ma ana nadenu sara, fo reu leo nai dae Kanaꞌan boboan dulu, mita fo rakadodook ro ndia anan Isak. Tehuu basa ndia pusakan lalaꞌen, ana loo lima basa sara reu Isak. ");
INSERT INTO txq_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Neu Abraham teun nara 175, boe ma maten. ");
INSERT INTO txq_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Basa boe ma anan Isak no Ismael ratoin numa lua Makpela mana deka no Mamre. Fai bakahulun Abraham hasa dae naa numa hatahori Het esa nade Efron, ndia Sohar anan. Fai bakahulun ara oo ratoi Sara numa luak naa ena boe. ");
INSERT INTO txq_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Mate heni Abraham, boe ma Manetualain fee Isak babaꞌe-babatik, losa ana leo-laꞌo no mole-damek. Lelek naa, Isak leo deka oe matak, manade Beer Lahai Roi. ");
INSERT INTO txq_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismael tutuin talo ia: Ndia naa, Abraham no sao murin Hagar anan. Hagar naa, Sara atan numa Masir mai. ");
INSERT INTO txq_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","16","Ismael ana toun salahunu dua. Naden nara tungga-tungga numa uluk losa muri anak, sira: Nebayot, Kedar, Adbeel, Mibsam, Misma, Duma, Masa, Hadad, Tema, Yetur, Nafis, ma Kedma. Kakanak kara raa, dadi reu bei-baꞌik ruma hatahori nusa-nusak salahunu dua mai, esa-esak no ndia nusa heli-helin. Ara foi nusak kara raa naden nara, esa-esak tungga sira baꞌin nara naden. ");
INSERT INTO txq_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Neu Ismael teun nara 137, boe ma maten. ");
INSERT INTO txq_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Tehuu tititi-nonosin nara esa musu no esa. De ara leo sasarak, mulai numa Hawila mai losa Syur, fo mana natoo no nusa Masir, nakandoo losa Asyur. ");
INSERT INTO txq_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham anan Isak tutuin, talo ia. ");
INSERT INTO txq_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Neu Isak sao nala Ribka, Isak teun nara 40. Ribka aman, Betuel. Ma naan, Laban. Sira raa, hatahori Aram numa Padan Aram mai. ");
INSERT INTO txq_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ribka ta bonggi nala anak. Huu naa de Isak hule-haradoi neu MANETUALAIN fo noke-hule Ana buka Ribka ana manan. MANETUALAIN namanene ndia huhule-haradoin, boe ma Ribka nairu. ");
INSERT INTO txq_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Naa te ana nairu anak dua. Tehuu kakanak kara raa kada rakosi-rasakak nai Ribka poꞌon dale. De Ribka natane nai dalen dale nae, “Tao hata de kakana kaduak kara iar, talo ia?” Basa boe ma ana natane MANETUALAIN. ");
INSERT INTO txq_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Boe ma MANETUALAIN naselu nae, “Nai o poꞌom dale hambu hatahori nusak dua, neu ko ara ramusuk taa-taa. Neu ko muri anak barakain lena uluk. Ma kaꞌak naue-osa fee fadin.” ");
INSERT INTO txq_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Neu bula fain nara losa ena, boe ma Ribka bonggi ana duak, tou anak mesan. ");
INSERT INTO txq_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ana kaꞌak mbilas, ma basa ao-inan kabuluk. Huu naa de ara foin nade, Esau (fo dedeꞌa deꞌek naa liin sangga sama no dedeꞌa deꞌek laen, fo sosoa-ndandaan ‘kabuluk’). ");
INSERT INTO txq_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Basa dei de fadin kalua. Tehuu ana toꞌu kaꞌan ei tinggan. Huu naa de ara foin nade, Yakob (fo dedeꞌa deꞌek naa liin sangga sama no dedeꞌa deꞌek laen, fo sosoa-ndandaan ‘ei tinggak’). Neu bonggi dua sara, Isak teun nara 60 ena. ");
INSERT INTO txq_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Neu kakana kaduak kara raa ramoꞌo mamais, Esau dadi neu mana sombu ta hohoꞌak. Ana hii leo nai lasi dale. Tehuu Yakob naa mana neneek, ma ana hii nahani nai kada uma. ");
INSERT INTO txq_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak hii naꞌa mbaa banda fui. Huu naa de ana sue nakalena Esau. Tehuu Ribka sue nakalena Yakob. ");
INSERT INTO txq_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Laꞌe esa, neu Yakob nasu kua fufue, Esau bei fo sombu fali. Ana bengge-manggu ma ndoe nalan seli. ");
INSERT INTO txq_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Boe ma ana nafada Yakob nae, “Fadi, ee! Au ndoe alan seli! De fee au, o kua mbilas manai urek naa faa dei, fo au isi neu au poꞌong.” (Huu naa de ara roken rae, Edom, fo dedeꞌa deꞌek naa liin sangga sama no dedeꞌa deꞌek laen, fo sosoa-ndandaan ‘mbilas’.) ");
INSERT INTO txq_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Boe ma Yakob naselu nae, “Malole kaꞌa. Tehuu fee kaꞌa haak ana uluk neu au dei!” ");
INSERT INTO txq_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","De Esau naselu nae, “Sokolaa heni haak ana uluk naa! O soan leo! Au ndoe alan seli ia ena. O sode lai-laik kua naa, fo munin mai leo, te au nau uꞌa ia ena.” ");
INSERT INTO txq_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Tehuu Yakob kokolak seluk bali nae, “Kaꞌa mahani dei! Kaꞌa sumba-soo dei mae, kaꞌa fee haak naa neu au ena.” Boe ma Esau soꞌuk sumba-sook tungga naa. ");
INSERT INTO txq_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Basa boe ma Yakob sode feen kua fufue naa no roti. Esau naꞌa-ninu basa, boe ma ana laꞌo. No dalak naa, Esau fee mudak ndia haak ana ulun. ");
INSERT INTO txq_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Laꞌe esa, hambu ndoe-laꞌas ta hohoꞌak numa nusak naa, sama leo ndoe-laꞌas neu lelek Abraham bei masodak. De Isak neu noke luas Abimelek, hatahori Filistin nara manen, fo ana bisa leo nai Gerar. ");
INSERT INTO txq_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ana tao talo naa, nahuu MANETUALAIN natudu aon neun ena nae, “O boso muni Masir muu. Neu ko au dudu mamanak laen fee o. ");
INSERT INTO txq_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","4","Mete ma o leo taak muu mamanak naa, na, neu ko Au sama-sama ua o, ma Au fee o babaꞌe-babatik mata-matak. Neu ko Au tao o tititi-nonosim mara ramanoꞌu, sama leo nduuk kara marai lalai. Ma Au fee o ma o tititi-nonosim mara nusak ia no basa nggoro-tadun nara. Numa o tititi-nonosim mai, neu ko basa hatahori nusa-nusak kara marai dae-bafok hambu babaꞌe-babatik. No dalak naa, Au tao atetu Au hehelu-bartaang neu o amam Abraham. ");
INSERT INTO txq_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Au tao basa iar, nahuu o amam tungga Au hihii-nanaung, Au parendang, ma Au hohoro-lalaneng ena.” ");
INSERT INTO txq_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Dadi Isak leo taak numa Gerar. ");
INSERT INTO txq_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ribka naa, manaꞌa hiek sudi selik kana, de hatahorir marai naar mete-ritan, boe ma ratatane aok laꞌe-neun. Tehuu Isak naselu nae, “Ribka naa au fading.” Ana namataꞌu, mete ma ana manaku nae ndia saon, na, neu ko hatahorir raa hala risa ndia fo leꞌa reni Ribka. ");
INSERT INTO txq_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak leo doo-doo numa naa ena, de laꞌe esa manek titino tungga dinela, ma mete-nita Isak no Ribka raholuk ma raiduk. ");
INSERT INTO txq_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Boe ma ana nadenu hatahorir reu roke ro Isak mai, de ana ndindian nae, “Isak! Au bubuluk tebe-tebe ena, inak naa memak o saom! Tehuu tao hata de o mae, ndia naa, o fadim?” Boe ma Isak naselu nae, “Talo ia, papa! Au amataꞌu, mete ma ae au saong, na, boso losak hatahorir hala risa au.” ");
INSERT INTO txq_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Manek naselu nae, “Tao hata de o tao talo naa neu ai? Mete ma hambu hatahorir rai ia sunggu-soro ro o saom, neu ko o fee salak neu ai, hetu?” ");
INSERT INTO txq_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Basa boe ma Abimelek ndindia nahere neu rau-inggun nara nae, “Ei basa ngga masaneda matalolole! Ei see nambarani tao manggarauk neu hatahori ia, do saon, na, neu ko au fee hukun mates neun.” ");
INSERT INTO txq_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Lelek naa oo, Isak sele-tande numa nusak naa boe. De ana hambu falik buna-boak lipa laꞌe 100, nahuu MANETUALAIN fee babaꞌe-babatik neun. ");
INSERT INTO txq_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Hata-heton tamba nakandoo, losa ana namasuꞌi nalan seli. ");
INSERT INTO txq_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ndia sapin, bibi hien ma bibi lombon nara tamba ramanoꞌu. Ndia atan nara oo noꞌuk ka boe. Losa hatahori Filistin dalen nara mbiri neun. ");
INSERT INTO txq_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Fai bakahulun Isak aman Abraham asa kali oe matak noꞌuk ka ena. Tehuu hatematak ia hatahori Filistin nara reu rakadodofu basa oe matak kara raa renik dae. ");
INSERT INTO txq_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Basa boe ma manek Abimelek kokolak no Isak nae, “Isak! Malole lenak, o huꞌa laꞌo ela nusak ia leo. Huu o koasam lena heni ai ena.” ");
INSERT INTO txq_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Basa boe ma Isak nakadedeak numa naa neu, de fali neu leo numa Gerar doken. ");
INSERT INTO txq_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Boe ma ana neu suu falik oe matak kara raa, fo ara rakadodofu henik kara ena. Ma ana foi oe matak kara raa, tungga nadek kara fo aman foi nala sara ena. ");
INSERT INTO txq_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Neu Isak atan nara kali oe matak numa Gerar doken, boe ma ara kali laꞌe oe matan, de nasapura kalua. ");
INSERT INTO txq_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tehuu mana lolor marai Gerar rareresi ro Isak mana lolon nara, nahuu oe naa. Mana lolor marai Gerar rae, “Oe ia, ai oem!” Huu naa de Isak foi oe matak naa, nade Esek, sosoa-ndandaan nae, ‘rareresi’. ");
INSERT INTO txq_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Basa boe ma Isak hatahorin nara kali oe matak esa bali. Tehuu ara oo rareresi bali, nahuu oe matak naa boe. Huu naa de Isak foi oe matak naa, nade Sitna, fo sosoa-ndandaan ‘rahuur-ratofa’. ");
INSERT INTO txq_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Basa boe ma ana laꞌo ela mamanak naa, de ana kali oe matak esa bali. Oek ia, ara ta rareresi. Huu naa de Isak foi oe matak naa, nade Rehobot, fo sosoa-ndandaan ‘mamana loak’. Ma ana kokolak nae, “Hatematak ia, Manetualain fee ita leo nai dae loak ena. De nai ia, dei fo ita bisa tamanoꞌu.” ");
INSERT INTO txq_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Numa naa neu, Isak asa laꞌo bali fo rae reu leo nai Beer Syeba. ");
INSERT INTO txq_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Leꞌodaen naa, boe ma MANETUALAIN natudu matan neun, ma kokolak nae, “Isak! Au ia, o amam Abraham Manetualain. De o boso mamataꞌu, huu Au anea o. Neu ko Au fee babaꞌe-babatik neu o. Ma o tititi-nonosim mara neu ko ara tamba ramanoꞌu. Au tao talo ia, nahuu Au hehelu-bartaang neu o amam.” ");
INSERT INTO txq_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Basa boe ma Isak totodo batur fo nambaririik mei tunu-hotuk numa naa. De ana noke makasi neu MANETUALAIN numa mamanak naa. Ana leo numa naa, ma hatahorin nara mulai kali oe matak bali. ");
INSERT INTO txq_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Faik naa, manek Abimelek numa Gerar mai. Ana sama-sama no nonoon Ahusat, ma ndia malangga musun, Fikol, mai ratonggo ro Isak. ");
INSERT INTO txq_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Boe ma Isak natane nae, “Papa manek! Fai bakahulun ei husi heni ai ena. De hatematak ia ei nau mai tao hata bali?” ");
INSERT INTO txq_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Boe ma ara raselu rae, “Talo ia! Hatematak ia ai bubuluk mae, Manetualain nanea o. Huu naa de ai duduꞌa mae, malole lenak ita dua ngga tao hehelu-bartaak talo ia: O sumba-soo mae, ");
INSERT INTO txq_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","neu ko ei ta tao manggarauk neu ai, sama leo ai oo ta tao manggarauk neu ei boe. Memak ai dalen nara neulauk neu ei. Huu naa de fai maneuk kara, ei kalua no mole-damek numa ai daen mai. Ai bubuluk tebe ena, MANETUALAIN ndia fee babaꞌe-babatik neu ei.” ");
INSERT INTO txq_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Boe ma Isak tao feta fee sara, de basa sara raꞌa-rinu rame-rame. ");
INSERT INTO txq_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Neu beꞌe-mai huhua anan, boe ma ara soꞌuk sumba-sook. De Isak nakamboꞌik kasa, fo ara laꞌo no mole-damek. ");
INSERT INTO txq_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Faik naa, Isak hatahori mana tao ue-osan nara mai tui laꞌe-neu oe matak fo ara kalik rae, “Papa! Ai hambu oe ena.” ");
INSERT INTO txq_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Boe ma Isak foi oe matak naa, nade Syeba, fo sosoa-ndandaan ‘sumba-sook’. De ara foi kota naa nade Beer Syeba, losa hatematak ia. ");
INSERT INTO txq_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Neu Esau teun nara 40, boe ma ana sao nala ana feꞌok dua ruma leo Het mai. Esa, Beeri anan, nade Yudit. Ma esa bali, Elon anan, nade Basmat. ");
INSERT INTO txq_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ina kaduak kara raa, tao rala Isak no Ribka dalen nara susa-sona. ");
INSERT INTO txq_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Neu Isak nambalasi ena, matan nita sambu-sambuk ka ena, boe ma noke ana ulun fo ana sue nalan seli naa nae, “Sau! O mai ia dei!” Esau naselu nae, “Tao hata papa?” ");
INSERT INTO txq_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak nafada nae, “Talo ia! Au lasik ena. Au ta bubuluk faik hida au mate. ");
INSERT INTO txq_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","De muu haꞌi o tee-kokoum mara, fo muu sombu fee au banda fui esa dei. ");
INSERT INTO txq_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Basa naa, tunu-nasu malan malada tungga au hihiing, fo munin mai au. Au uꞌa basa, dei fo au fee memak babaꞌe-babatik neu o. Mete ma au fee babaꞌe-babatik basa neu o ena, na, leo mae au mate oo malole boe.” ");
INSERT INTO txq_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Basa boe ma Esau laꞌo neu sombu. Tehuu Ribka oo namanene Isak kokolan naa boe. ");
INSERT INTO txq_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Boe ma Ribka neu nafada Yakob nae, “Ako, ee! Nenene matalolole! Bebeik kara ia au bei fo amanene amam kokolak no Esau nae talo ia: ");
INSERT INTO txq_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘O muu sombu mala banda fui esa, fo tunu-nasu malan malada fee au. Mete ma au uꞌa basa ena, na, dei fo au fee babaꞌe-babatik neu o nai MANETUALAIN matan.’ ");
INSERT INTO txq_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Dadi nenene matalolole! Tao matetu au parendang ia. ");
INSERT INTO txq_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Hatematak ia o muni ita bibi hiek ma bibi lombon mamanan muu, fo here mala bibi hiek maao tenak dua. Basa boe ma tunu-hala sara fo haꞌi mbaan nara, ma muni sara fee au. Dei fo au tunu-nasu tungga o amam hihiin. ");
INSERT INTO txq_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Mete ma au tunu-nasu basa ena, na, munin neni o amam neu fo naꞌa. Boe ma neu ko ana fee babaꞌe-babatik neu o dei, dei fo ana mate. No dalak naa, o ndia hambu babaꞌe-babatik naa. Ta o kaꞌam.” ");
INSERT INTO txq_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tehuu Yakob kokolak no inan nae, “Mama! Masalan talo ia. Kaꞌa Sau ao-inan kabuluk, tehuu au ao-inang bulu taak. ");
INSERT INTO txq_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Boso losak papa nafaroe laꞌe au ao-inang, na, ana bubuluk memak au kedi-ira ndia. De ana nakatoo au.” ");
INSERT INTO txq_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Inan naselu nae, “Ako, ee! O boso babati. Dei fo mama ndia koladu! Mete ma o amam nakatoo o, na, elan fo mama ndia lemba-nasaan! Hatematak ia o muu humu mala bibi hiek naa leo.” ");
INSERT INTO txq_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Boe ma Yakob neu humu bibi hiek kara raa, de ana tunu-hala sara fo neni feen neu inan. Basa boe ma Ribka tunu-nasu tungga Isak hihiin. ");
INSERT INTO txq_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Basa de Ribka neu haꞌi nala Esau bua-loꞌa neulaun nara, de ana fee Yakob pake. ");
INSERT INTO txq_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ana oo mbambalu Yakob liman, ma boliin pake bibi hiek naa bulun. ");
INSERT INTO txq_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","De ana fee Yakob nanaꞌa malada naa, no roti fo ana tao nalak ena. ");
INSERT INTO txq_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Basa boe ma Yakob neni nanaꞌak naa fee aman. Ana kokolak nae, “Papa! Au mai ndia ia ena.” Boe ma Isak naselu nae, “Weeh? Te o ia see?” ");
INSERT INTO txq_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","De Yakob naselu nae, “Au ia, papa ana ulun, Esau! Au tao tungga hata fo papa nadenuk bebeik kara ia ena. Mambadeik fo muꞌa leo. Au tunu-nasu ala mbaa fo au sombu alak numa lasi dale naa ena. Muꞌa, fo basa, na, papa fee babaꞌe-babatik neu au leo!” ");
INSERT INTO txq_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Basa boe ma Isak kokolak nae, “O ia ta hohoꞌak, ee! Te o bisa hambu banda lai-laik talo naa!” De Yakob naselu nae, “Au hambu ia, nahuu MANETUALAIN fo papa nakaluku-nakatele neuk naa, Ana tulu-fali au.” ");
INSERT INTO txq_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Boe ma Isak noke Yakob nae, “O deka-deka ia mai, fo au afaroe sudik o! O ia Esau tebe, do?” ");
INSERT INTO txq_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Basa boe ma Yakob deka neni aman matan neu, de tou lasik mulai nafaroen. Boe ma ana kokolak nae, “Harak ia, leo Yakob haran! Tehuu limak ia, Esau liman.” ");
INSERT INTO txq_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Tehuu Isak ta nalela Yakob, nahuu liman kabuluk sama leo Esau. Neu ana nae fee babaꞌe-babatik neu Yakob, ");
INSERT INTO txq_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ana natane seluk bali nae, “O ia tebe-tebe Esau, do?” Yakob naselu nae, “Tebe, papa!” ");
INSERT INTO txq_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Basa boe ma Isak kokolak nae, “O soro mbaa naa mai fo au uꞌa. Basa, dei fo au fee babaꞌe-babatik neu o.” Boe ma Yakob soro mbaa naa neu aman, ma ana feen anggor fo ninu. ");
INSERT INTO txq_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Basa boe ma aman kokolak nae, “Ana, nggee! Deka-deka ia mai, fo idu au dei.” ");
INSERT INTO txq_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Neu Yakob deka-deka mata neu fo idun, boe ma Isak hae hambu Esau bua-loꞌan nara boon. De ana kokolak fee babaꞌe-babatik neu Yakob nae, “Au anang boon, sama leo naꞌu mook boon fo MANETUALAIN fee babaꞌe-babatik neun ena. ");
INSERT INTO txq_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Elan fo Manetualain nakonda dinis numa lalai mai, fo tao nala o osi-lutum mara raisi-mina! Elan fo Ana fee o hade heta-pepede, ma anggor boan nara sofe ta ela luꞌa-lembaneu. ");
INSERT INTO txq_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Hatahori nusa-nusak kara dadi neu o atam, ma leo-leor holu ei ma fee hada-horomatak neu o. Elan fo o parenda basa o toranoom mara, ma ara sendek luu-langgan nara reu o matam. See ndia fee neketook neu o, na, ara oo hambu neketook boe. Ma see ndia fee babaꞌe-babatik neu o, na, ara oo hambu babaꞌe-babatik boe.” ");
INSERT INTO txq_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Neu Isak fee babaꞌe-babatik basa, ma Yakob bei fo kalua laꞌo ela aman, kaꞌan Esau fali neni banda fui fo ana sombu nalak. ");
INSERT INTO txq_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","De neu tunu-nasu, basa boe ma neni fee aman. Ana kokolak nae, “Papa! Mambadeik fo muꞌa leo. Au tunu-nasu ala mbaa fo au sombu alak naa ena. Muꞌa basa, na, papa fee babaꞌe-babatik neu au leo.” ");
INSERT INTO txq_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Boe ma Isak pangganaa, de natane nae, “Weeh! Te o ia, see bali?” Boe ma Esau naselu nae, “Au ia Sau! Papa ana ulun.” ");
INSERT INTO txq_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Boe ma Isak aon mulai nakabebe. De tou lasik natane nae, “Mete ma talo naa, na, bebeik kara ia see ndia neni fee au mbaa naa, de au uꞌa ena? Basa boe ma au feen babaꞌe-babatik ena. De ta bisa leꞌa falik babaꞌe-babatik naa bali.” ");
INSERT INTO txq_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau namanene aman kokolak talo naa, boe ma dalen hedis, de buꞌi nakarereu ma ana kokolak nahere nae, “Awii! Papa, ee! Fee babaꞌe-babatik neu au boe, papa!” ");
INSERT INTO txq_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tehuu Isak nae, “O fadim mai kedi-ira nala au ena, de namanaꞌo neni o babaꞌe-babatim.” ");
INSERT INTO txq_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Boe ma Esau kokolak nae, “Ana kedi nala au laꞌe dua ena. Makasososan, ana kedi nala au haak ana uluk. Hatematak ia ana kedi nala au babaꞌe-babating bali. Nandaa ndia naden, ‘Yakob’. Tehuu papa bei naena babaꞌe-babatik laen fee au bali, do?” (Nade Yakob sosoa-ndandaan ‘toꞌu neu ei tinggak’. Tehuu sosoa-ndandaan laen ‘mana kedi-irak.’) ");
INSERT INTO txq_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Basa boe ma Isak naselu nae, “Au soꞌuk alan dadi neu o malanggam ena. Ma basa toranoon nara dadi reu ndia atan ena. Au baꞌe feen hade heta-pepede, ma anggor sofe ta ela luꞌa-lembaneu ena. De ana, nggee! Hatematak ia bei ela babaꞌe-babatik hata bali fo au bisa feen neu o?” ");
INSERT INTO txq_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau namanene nala naa, boe ma ana honi nakandoo neu aman nae, “Papa babaꞌe-babatim kada esak ka, do? Neu ko papa bei bisa sangga babaꞌe-babatik laen fee au. Leo mae babaꞌe-babatik baꞌu anak oo malole boe!” Boe ma ana mulai buꞌi bali. ");
INSERT INTO txq_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Basa boe ma Isak naselu mbalin nae, “O masodam neu ko dook ka numa osi-lutu maisi-minak mai, huu ta hambu dinis konda numa lalai mai fo tao makoe o daem. ");
INSERT INTO txq_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","O tafam ndia neu ko fee o masoda. Tehuu leo mae talo bee oo, o dadi ata neu o fadim boe. Kada mete ma o bisa laban neun, na, dei fo o bisa makamboꞌik numa liman mai.” ");
INSERT INTO txq_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau mburuk nalan seli neu Yakob, nahuu fadin leꞌa nala ndia babaꞌe-babatin ena. Tehuu ana duduꞌa nae, “Ta dook ka bali papa mate. De nahani a leo. Mete ma beꞌe-falufii basa, au hala isan!” ");
INSERT INTO txq_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Neu Ribka namanene nala Esau nanaen, boe ma ana noke nala Yakob, de nae, “O nenene matalolole! O kaꞌam sangga nae bala ndia dale hedin, fo nae nakanisa o. De o malai lai-laik muni o toꞌom Laban muu nai Haran. ");
INSERT INTO txq_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Muu fo leo doo-doo faa nai naa, losa o kaꞌam ta namanasa o ena bali. ");
INSERT INTO txq_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Mete ma ana lilii heni hata fo o tao neun, dei fo au adenu hatahorir reu rala falik o. Huu au ta nau au anang dua sara, mopo sara rai faik esa dalen.” ");
INSERT INTO txq_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Basa boe ma Ribka kokolak no Isak nae, “Au doak ua Esau saon, hatahori Het asa! Mete ma Yakob sao nala ana feꞌok Het boe, na, malole lenak au mate leo.” ");
INSERT INTO txq_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Boe ma Isak noke Yakob, de ana feen babaꞌe-babatik ma ana nanori-nafadan nae, “Nenene matalolole! O boso sao ana feꞌok Kanaꞌan. ");
INSERT INTO txq_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tehuu o muni Padan Aram muu, nai baꞌi Betuel uman. O muu sao mala toꞌom Laban, ana inan esa. ");
INSERT INTO txq_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Elan fo Manetualain mana Koasa Mateꞌen fee babaꞌe-babatik neu o, fo o umbu-anam mara ramanoꞌu, ma o tititi-nonosim mara dadi neu hatahori nusa ta hohoꞌak noꞌuk ka. ");
INSERT INTO txq_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Elan fo Manetualain hehelu-bartaan neu Abraham, ana konda neu o, ma o tititi-nonosim mara. Elan fo o soa dae ia, fo Manetualain helu-bartaa nae feen neu Abraham ena.” ");
INSERT INTO txq_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isak kokolak basa talo naa, boe ma ana mboꞌi Yakob neni Padan Aram neu, fo neni toꞌon Laban ma baꞌin Betuel uman neu. ");
INSERT INTO txq_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau namanene nala nae, Isak fee babaꞌe-babatik neu Yakob ena, ma kaꞌin fo boso sao no ana feꞌok Kanaꞌan. Ana oo namanene nala boe nae, ndia aman nadenu ndia fadin ena, fo neu sao nala toꞌon ana feꞌon esa nai Padan Aram. ");
INSERT INTO txq_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Boe ma Yakob namanene nala inan no aman parendan, de ana laꞌo neni Padan Aram neu. ");
INSERT INTO txq_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ana oo bubuluk boe nae, ndia aman ta hii ndia saon, hatahori Kanaꞌan nara. ");
INSERT INTO txq_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","De ana neni ama ina-huun Ismael neu, boe ma ana sao nala Ismael anan bali, nade Mahalat. Mahalat naa, Nebayot fadi inan. ");
INSERT INTO txq_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Basa boe ma Yakob laꞌo ela Beer Syeba, de nae neni Haran neu. ");
INSERT INTO txq_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Neu ledo tesa, ana losa mamanak esa, boe ma ana sunggu neu naa. Neu ana nau sunggu, ana haꞌi nala batu esa fo taon dadi neu kailunu. ");
INSERT INTO txq_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Leꞌodaen naa ana nala meꞌi, Ana mete-nita hedahuuk esa nambariik neu daer ma suꞌun losa lalai. Boe ma Manetualain atan nara ruma nusa tetuk do inggu temak mai, ara konda-hene hedahuuk naa. ");
INSERT INTO txq_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nai meꞌis na dale, Yakob mete-nita MANETUALAIN nambariik nai ndia boboan, de kokolak nae, “Au ia, MANETUALAIN, o baꞌim Abraham ma amam Isak Manetualain. Neu ko Au fee dae ia neu o ma o tititi-nonosim. ");
INSERT INTO txq_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Neu ko o tititi-nonosim noꞌun nara, sama leo afu. Ma neu ko ara ratanggela sudi bee reu, nai basa mamanak kara. Numa o tititi-nonosim mai, neu ko basa hatahori nusa-nusak kara marai dae-bafok hambu babaꞌe-babatik. ");
INSERT INTO txq_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Masaneda matalolole! O muni bee muu a mesan, Au sama-sama ma anea o. Neu ko Au ua falik o muni nusak ia mai. Au ta mboꞌi o mesa ngga. Ma neu ko Au tao atetu basa hehelu-bartaak kara fo Au feen neu o.” ");
INSERT INTO txq_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Neu Yakob beꞌe, boe ma ana nae, “Au bei fo bubuluk ae, MANETUALAIN oo nai ia boe!” ");
INSERT INTO txq_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ana namataꞌu, boe ma ana duduꞌa nae, “Awii! Mamanak ia tao nala au aong mumuru. Manetualain uman nai ia! Fama te ia lelesu mana neni nusa tetuk do inggu temak neu.” ");
INSERT INTO txq_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Neu huhua anan, Yakob nambadeik, boe ma ana haꞌi nala batu fo ana taon neu kailunu naa, de nambaririik kana dadi tanda. Boe ma ana mboꞌa mina neu batu naa lain, fo ana nakaluku-nakatele neu Manetualain. ");
INSERT INTO txq_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ana foi mamanak naa, nade, Betel, fo sosoa-ndandaan ‘Manetualain uman’. (Fai bakahulun mamanak naa, nade Luus.) ");
INSERT INTO txq_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Basa boe ma Yakob soꞌuk sumba-sook nae, “Mete ma Manetualain sama-sama no au, Ana nanea au nai au dala-lalaꞌong ia, ma fee au nanaꞌa-nininuk ma bua-loꞌa, ");
INSERT INTO txq_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","losa au fali no sodak, na, neu ko MANETUALAIN dadi neu au Manetualain. ");
INSERT INTO txq_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Batu fo au ambaririi alak ia, dadi neu mamana nekeluku-neketelek neu Manetualain. Ma basa hata fo Manetualain fee neu au, neu ko au fee falik babaꞌek esa numa babaꞌek salahunu mai.” ");
INSERT INTO txq_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Basa boe ma Yakob laꞌok nakandooo neni dulu neu. ");
INSERT INTO txq_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Faik esa, ana mete-nita oe matak esa deka no nggorok esa. Bibi lombo bubuak telu, deka-deka numa naa, rahani fo rae rinu oe numa naa. Tehuu hambu batu moꞌok esa tatana nala oe matak naa. ");
INSERT INTO txq_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sira siꞌen, mete ma basa bibi hiek ma bibi lombor rakabubua ena, na, dei fo mana lolo keko heni batu naa, fo ndui oe fee bandar raa rinu. Rinu basa, ara tatana falik oe matak naa bali. ");
INSERT INTO txq_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Boe ma Yakob neu natane mana lolor raa nae, “Wee! Ei numa bee mai?” Ara raselu rae, “Air ia, numa nggorok Haran ia mai.” ");
INSERT INTO txq_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Boe ma Yakob natane seluk bali nae, “Ei malela au toꞌong Laban, do? Laban naa, Nahor anan.” Ara raselu rae, “Ai malelan.” ");
INSERT INTO txq_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Boe ma Yakob natane nakandoo bali nae, “Ana bei sodak, do?” Ara raselu rae, “Tou lasik bei sodak. Hena mete. Naa, ana inan, nade Rahel, ana foo neni bibi hien ma bibi lombon nara mai rinu oe nai ia. O mahani leo.” ");
INSERT INTO txq_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Basa boe ma Yakob kokolak seluk bali nae, “Hatematak ia ledo bei nai lain. De malole lenak bandar bee fo rakubua nai ia ena, na, ei fee sara rinu leo. Basa dei fo ei foo meni sara reni mook reu, fo raꞌa naꞌu bali.” ");
INSERT INTO txq_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tehuu ara rasabara rae, “Awii, ta bisa talo naa! Ita muste tahani basa mana lolor reni basa bandan nara fo rakabua nai ia dei, dei fo ita keko heok batu naa, fo fee bandar rinu.” ");
INSERT INTO txq_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakob bei kola-kola no hatahorir raa, te Rahel losa no aman bibi hien ma bibi lombon nara. Ana ndia nasiꞌe foo bandar raa. ");
INSERT INTO txq_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Neu Yakob mete-nita Rahel no bibi hien ma bibi lombon nara, boe ma neu keko heok oe matak naa tatanan. De ana hani toꞌon bandan nara. ");
INSERT INTO txq_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Basa boe ma neu holu nala Rahel, de ana idun ma ana buꞌi. ");
INSERT INTO txq_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ana tui Rahel nae, “Fadi! Au ia, o papam fadin Ribka anan.” Boe ma Rahel nalaik fali neu ngga, fo neu nafada aman. ");
INSERT INTO txq_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Neu Laban namanene Rahel tutuin laꞌe-neu Yakob, ndia fadin Ribka anan, boe ma ana nalaik neu sorun. Neu natonggon, Laban holu nalan de idun, basa boe ma noo Yakob neni ndia uman neu. Boe ma Yakob tui basa-basan neu Laban. ");
INSERT INTO txq_vpl VALUES ("GN29_14a","002_29_14a","GEN","29","14a","14a","De Laban kokolak nae, “Memak tebe! Ita dua ngga nufaneluk kara!” ");
INSERT INTO txq_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Neu Yakob leo no sara bulak esa ena, ");
INSERT INTO txq_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban kokolak noon nae, “Talo ia, Ako! Au ta nau o maue-osa mudak fee au, nahuu ita dua ngga nufaneluk. O moke seseba-babaek baꞌu hata?” ");
INSERT INTO txq_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban naa, naena ana inak dua. Kaꞌak nade Lea. Fadik nade Rahel. ");
INSERT INTO txq_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea matan mana mamalek. Tehuu Rahel matan manaꞌa hiek sudi selik kana, ma ao-inan neulauk. ");
INSERT INTO txq_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakob sue Rahel. De ana naselu Laban nae, “Au aue-osa fee toꞌo teuk hitu, sadi toꞌo fee au sao ala Rahel.” ");
INSERT INTO txq_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Boe ma Laban naselu nae, “Au akaheik! Malole lenak au fee Rahel sao no o, fo au nufanelu heli-heling! Ana hae sao no hatahori laen. De talo kada ia fo maue-osa fee au leo.” ");
INSERT INTO txq_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Boe ma Yakob naue-osa teuk hitu, mita fo ana hambu Rahel. Tehuu ana sue nalan seli neu Rahel. Dadi teuk hitu naa, ana namedan sama leo kada faik hida a. ");
INSERT INTO txq_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Seli teuk kahituk kara raa, boe ma Yakob fee nesenedak neu Laban nae, “Toꞌo! Au aue-osa fee toꞌo teuk hitu ia ena, de hatematak ia fee au sao ua Rahel leo.” ");
INSERT INTO txq_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Boe ma Laban tao feta kabin, de noke basa hatahorir marai nusak naa. ");
INSERT INTO txq_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","27","Leꞌodaen naa, Laban ta fee Rahel, tehuu ana nadenu Lea maso neni Yakob laan neu. De Yakob sunggu-soro noon. Neu beꞌe-main, dei de Yakob bubuluk nae, ndia sunggu-soro no Lea. Boe ma Yakob neu nasabara no Laban nae, “Tao hata de toꞌo tao kekedik neu au? Au aue-osa fafandek lima-eing teuk hitu dalen fo hambu Rahel. Tehuu tao hata de toꞌo nggati no Lea?” Boe ma Laban naselu nae, “O boso mamanasa talo naa! Tungga ai dala-hadan nai ia, fadik ta bole sao nakahuluk kaꞌak. De malole lenak talo kada ia! O mahani losa feta kabin fai hitu ia basa dei. Dei fo o hambu Rahel, sadi o maue-osa fee au teuk hitu bali.” Boe ma Laban fee ndia ata inan, nade Silpa fo dadi neu Lea atan. ");
INSERT INTO txq_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakob nakaheik. Huu naa de neu feta faik hitu naa basa, boe ma Laban fee Rahel sao nala Yakob. ");
INSERT INTO txq_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Basa de Laban fee ndia ata inan esa bali, nade Bilha, fo dadi neu Rahel atan. ");
INSERT INTO txq_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Basa boe ma Yakob sunggu-soro no Rahel. Ana sue Rahel lena heni Lea. De ana naue-osa tamba teuk hitu bali fee ari-aman. ");
INSERT INTO txq_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Tehuu MANETUALAIN bubuluk Yakob sue Rahel lena heni Lea. Boe ma Ana fee luas fo Lea hambu anak, tehuu Rahel beik. ");
INSERT INTO txq_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","De Lea nairu, boe ma ana bonggi ana touk esa. Ana foi kanak naa, nade Ruben (fo sosoa-ndandaan ‘mete neu, hambu anak’), nahuu ana nae, “MANETUALAIN memak mete-nita au sususang ena. Huu naa de hatematak ia, au saong oo nau mete au boe.” ");
INSERT INTO txq_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Basa boe ma Lea nairu bali, de ana hambu ana touk esa. Ana foi kanak naa nade Simeon (fo sosoa-ndandaan fama te ‘hatahori namanene ena’), nahuu ana nae, “MANETUALAIN namanene ena nae, au saong ta tao matak neu au. Huu naa de Ana fee tamba anak esa bali neu au.” ");
INSERT INTO txq_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Basa de, Lea nairu bali, boe ma ana bonggi ana touk esa bali. Ana foi kanak naa nade Lewi, nahuu ana nae, “No anak ia au dedeꞌang basan ena. Neu ko au saong ta bila no au, nahuu au bonggi feen ana touk telu ena.” ");
INSERT INTO txq_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Basa boe ma Lea nairu bali, de ana hambu ana touk esa. Ana foi kanak naa, nade Yahuda (fo sosoa-ndandaan fama te ‘kokoa-kikiok’), nahuu ana nae, “Oek ia, au nau koa-kio MANETUALAIN!” Basa de Lea ta bonggi leo. ");
INSERT INTO txq_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Tehuu Rahel bei ta hambu anak. De ana mbiri neu kaꞌan. Boe ma ana kokolak no saon nae, “Kaꞌa! Fee au anak dei. Mete ma taa, na, malole lenak au mate leo.” ");
INSERT INTO txq_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Boe ma Yakob nasaparak kana nae, “O duꞌa mae au ia Manetualain, de bisa fee o anak!?” ");
INSERT INTO txq_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Basa boe ma Rahel kokolak nae, “Talo ia! Malole lenak papa haꞌi nala au atang Bilha. Muu sunggu-soro muan fo ana bonggi fee au anak.” ");
INSERT INTO txq_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Boe ma ana fee Bilha neu ndia saon. De Yakob sunggu-soro noon. ");
INSERT INTO txq_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Boe ma Bilha nairu, de bonggi ana touk esa. ");
INSERT INTO txq_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Basa boe ma Rahel kokolak nae, “Manetualain namanene au huhule-haradoing ena. Huu naa de Ana fee au ana touk esa ena. Manetualain naketu-naladi au dedeꞌang ena no ta mbeu seserik.” Boe ma ana foi kanak naa nade, Dan (fo sosoa-ndandaan ‘neketu-neladi dedeꞌak’). ");
INSERT INTO txq_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Basa boe ma Bilha nairu bali, de bonggi ana touk esa. ");
INSERT INTO txq_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Boe ma Rahel kokolak nae, “Au akaseseꞌuk ua au kaꞌang ena, de au senggi.” Huu naa de ana foi kanak naa nade Naftali (fo sosoa-ndandaan ‘nekeseseꞌuk’, do ‘nekeheheek’). ");
INSERT INTO txq_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Neu Lea nameda ndia ta hambu anak seluk ena, boe ma ana fee atan Silpa neu saon, fo ana sao nalan. ");
INSERT INTO txq_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Basa boe ma Silpa bonggi nala ana touk esa. ");
INSERT INTO txq_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Boe ma Lea kokolak nae, “Au ua-naleng neulauk ena.” De ana foi kanak naa, nade Gad (fo sosoa-ndandaan ‘ua-nale neulauk’). ");
INSERT INTO txq_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Basa boe ma Silpa bonggi seluk ana touk esa bali. ");
INSERT INTO txq_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Boe ma Lea kokolak nae, “Wee! Hatematak ia, bei fo au amahoko! Mete te neu ko basa inak kara kokolak rae, au aua alan seli ena.” Huu naa de ana foi kanak naa, nade Aser (fo sosoa-ndandaan ‘nemehokok’). ");
INSERT INTO txq_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Laꞌe esa, ndaa no fai koru hader, Ruben neni lasi dale neu, boe ma ana natonggo no sele-tandek modo-aidoo esa fo bisa tao nairu hatahori. Boe ma nenin fee neu inan Lea. Rahel mete-nita naa, boe ma noke Lea nae, “Kaꞌa, ee! Fee au modo-aidoo fo Ruben nenik naa faa dei.” ");
INSERT INTO txq_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Tehuu Lea naselu nae, “Wee! O ia sudi selik kana! O leꞌa mala au saong ena. Hatematak ia o nau leꞌa mala modo-aidoo naa numa au anang mai bali? O ia ta mae malela!” Tehuu Rahel kokolak nae, “Talo ia kaꞌa. Mete ma au hambu modo-aidoo naa, na, leꞌodaen ia o bole sunggu-soro mua Yakob.” Boe ma Lea nakaheik. ");
INSERT INTO txq_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Neu ledo bobon, Yakob fali numa osi mai. Boe ma Lea neu natonggo noon, de kokolak nae, “Ako, ee! O muste sunggu-soro mua au leꞌodaek ia! Huu au bae memak o ena, unik au anang modo-aidoon.” Boe ma leꞌodaen naa oo, Yakob sunggu-soro no Lea boe. ");
INSERT INTO txq_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Manetualain namanene Lea huhule-haradoin. Huu naa de ana nairu, de ana bonggi nala ana touk kaliman. ");
INSERT INTO txq_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Boe ma Lea foi kanak naa nade Isaskar, (fo sosoa-ndandaan ‘bae sosota-mamangguk’), nahuu ana nae, “Manetualain bae au sosota-mamanggung ena, huu au fee Silpa sao no au saong ena.” ");
INSERT INTO txq_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Basa boe ma Lea nairu bali, de ana bonggi nala ana touk kaneen. ");
INSERT INTO txq_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ana kokolak nae, “Manetualain fee au hadia neulauk ena. De hatematak ia au saong muste fee hada-horomatak neu au, nahuu au bonggi feen ana touk nee ena.” Huu naa de ana foi kanak naa, nade Sebulon (fo sosoa-ndandaan ‘fee hada-horomatak’). ");
INSERT INTO txq_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Basa boe ma Lea bonggi nala ana inak esa, de ana foin nade Dina. ");
INSERT INTO txq_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Boe ma Manetualain nasaneda Rahel, de Ana namanene huhule-haradoin. Huu naa de Ana buka ana manan. ");
INSERT INTO txq_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Basa boe ma Rahel nairu, de ana bonggi nala ana touk esa. Ana nae, “Manetualain siꞌu-sapu heni au dale mamaeng ena.” ");
INSERT INTO txq_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Boe ma ana foi kanak naa, nade Yusuf (fo sosoa-ndandaan fama te ‘naa fo ana fee tamba’), nahuu ana nae, “Au hule fo Manetualain fee tamba au, ana touk esa bali.” ");
INSERT INTO txq_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Neu Rahel bonggi basa Yusuf ena, Yakob kokolak no Laban nae, “Papa! Mete ma bisa, na, au ae fali uni au nusang uu dei. ");
INSERT INTO txq_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Elan fo au fali uu ngga ua au saong ma anang nggara. Papa bubuluk ena, au tao ue-osa fafandek lima-eing fee Papa ena, de au bae ketu sara ena. Huu naa de hatematak ia sira raa, au ndia haak.” ");
INSERT INTO txq_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Boe ma ari-aman naselu nae, “Ana, nggee! O nenene dei. Au losi-lale basa ena, de bubuluk ae, Manetualain fee babaꞌe-babatik neu au, nahuu o. ");
INSERT INTO txq_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","De hatematak ia, o nau moke baꞌu hata a mesan, na, au bae! Sadi o leo nai ia, ma maue-osa makandoo fee au.” ");
INSERT INTO txq_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Boe ma Yakob naselu nae, “Papa mesa kana mete-nita, au aue-osa ahere ena. Huu naa de papa banda-manun nara tamba ramanoꞌu rakandooo. ");
INSERT INTO txq_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Neu au bei ta mai naa, papa hata-heton bei ta noꞌuk ka. Tehuu hatematak ia, papa namasuꞌi ena. Manetualain fee babaꞌe-babatik neu papa ena, nahuu au ue-osang. Hatematak ia fain losa ena, fo au aue-osa soa-neu au sao-anang nggara bali.” ");
INSERT INTO txq_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Basa boe ma Laban natane nae, “Dadi au muste bae talo bee neu o?” Boe ma Yakob naselu nae, “Papa hae fee au hata-hata. Neu ko au lopo-linu akandoo papa banda-manun nara, sadi au bisa tao matak esa. ");
INSERT INTO txq_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Fee luas neu au, fo faik ia oo, au uni papa banda-manun nara uu boe, fo tada ala bibi hiek ma bibi lombok. Bee fo ta kokotok ma ta keketak kara, na, naa dadi neu papa enan. Tehuu bee fo kokotok ma keketak kara, na, naa fo au laꞌe sara. Ma au oo haꞌi ala basa bibi lombo nggeok kara boe. Basa naar, dadi neu seseba-babaek soa-neu au sosota-mamanggung. ");
INSERT INTO txq_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Neu fai bakadean, dei fo papa bisa bubuluk, au ia ndoos do taa. Sudi neu faik bee a mesan, papa bisa mai parisa au bandang nggara. Mete ma papa mete-nita bibi hiek bee fo ta kokotok do keketak, do bibi lombo mutik, na, papa bubuluk memak mae, au ndia amanaꞌo ala papa bandan nara.” ");
INSERT INTO txq_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Boe ma Laban nakaheik nae, “Malole! Talo kada naa leo!” ");
INSERT INTO txq_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tehuu faik naa oo, Laban tada feꞌe basa banda kokotok ma keketak kara, ro bibi lombo nggeok kara boe. Basa boe ma ana nadenu ndia anan nara fo lopo-linu banda-manur raa. ");
INSERT INTO txq_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Boe ma ara ro bandar raa reni mamanak esa reu, doon fai telu laꞌo eik numa Yakob mai. Yakob bei nakaboi ari-aman bibi hien ma bibi lombo lenan nara. ");
INSERT INTO txq_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Basa boe ma Yakob tati nala ai huuk matak telu ndanan nara, de ana fina tatada roun nara tao sara leo kokoto-keketak kara. ");
INSERT INTO txq_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ana mbeda ai ndana neni fina tatada rouk kokoto-keketak kara raa reni bandar haꞌon dale reu. Bandar hii rahoa rai mamana nininuk naa. ");
INSERT INTO txq_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","De neu bandar rahoa rai ai ndana neni fina tatada rouk kokoto-keketak kara raa matan, neu ko ara bonggi te anan nara bulun oo, kokotok ma hambu keketak boe. ");
INSERT INTO txq_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Neu Laban bandan nara rae rahoa, Yakob fee sara rasare reni banda bulu kokotok ma keketak reu. De anan nara oo kokotok ma keketak kara boe. No dalak naa, ndia banda heli-helin nara tamba ramanoꞌu. Basa boe ma ana tada feꞌe sara ruma Laban bandan nara mai. ");
INSERT INTO txq_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Neu banda barakaik kara rahoa, na, Yakob tao ai kokoto-keketak kara raa deka matan nara, neu haꞌon nara dale. ");
INSERT INTO txq_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tehuu mete ma ana mete-nita banda kamanauk kara ndia rahoa, na, ana ta tao air raa reu. De Laban hambu basa banda kamanauk kara. Tehuu Yakob hambu basa banda barakaik kara. ");
INSERT INTO txq_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","No dalak naa, Yakob namasuꞌi nalan seli. Ndia bibi hien, bibi lombon, ontan, keledein, ma ata-daton nara noꞌun seli. ");
INSERT INTO txq_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Laꞌe esa, Yakob namanene Laban anan nara kola-kola rae, “Yakob namasuꞌi nalan seli ena, nahuu ana kakao nala basa ita aman hata-heton ena.” ");
INSERT INTO txq_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakob oo mete-nita ndia ari-aman Laban matan ta nalengga ena, ma ana ta malole no ndia boe, sama leo fai bakahulun bali. ");
INSERT INTO txq_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Basa boe ma MANETUALAIN kokolak no Yakob nae, “Hatematak ia fain losa ena. De o muste fali muni o ina-amam mara muu. Dei fo Au sama-sama ua o.” ");
INSERT INTO txq_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Basa de Yakob fee reu roke Rahel no Lea, fo mai ratonggo ro ndia nai bandar mamanan nai mook. ");
INSERT INTO txq_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Boe ma ana nafada sara nae, “Nai fai bakadean ia, au mete-ita ei amam matan ta nalengga no au ena. Ana oo ta malole no au boe, sama leo fai bakahulun ena bali. Tehuu Manetualain fo au amang nakaluku-nakatele neuk naa, Ana sama-sama no au. ");
INSERT INTO txq_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ei dua ngga bubuluk, doo basa ia, au aue-osa fafandek lima-eing sudi selik kana soa-neu ei amam! ");
INSERT INTO txq_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Leo mae talo naa oo, tehuu ana kedi-ira nakamiminak au laꞌi-laꞌik ka boe. Ana nggati au seseba-babaeng, laꞌe salahunu. Leo mae talo naa, tehuu Manetualain nanea naherek au. ");
INSERT INTO txq_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Neu ei amam kokolak nae, ‘Banda-manu kokotok kara raa dadi reu o seseba-babaem’, boe ma banda-manur raa bonggi basa ana kokotok lalaꞌen. Faik laen, ana kokolak bali nae, ‘Hatematak ia banda-manu fo keketak kara, dadi reu o seseba-babaem,’ boe ma banda-manur raa bonggi basa ana keketak lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Manetualain tao talo naa, mita fo Ana haꞌi nala ei amam banda-manun nara, fo fee sara reu au. ");
INSERT INTO txq_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Laꞌe esa, neu banda-manur fai nehoan nara, au mete-ita nai meꞌis dale nae, basa banda-manu mane kahoak kara raa, hambu ketuk bulun tatadak, kokotok ma hambu ketuk keketak. ");
INSERT INTO txq_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Boe ma Manetualain atan numa nusa tetuk do inggu temak mai nanggou au nai meꞌis dale nae, ‘Wee! Yakob!’ Boe ma au aselu ae, ‘Tao hata, Manetualain?’ ");
INSERT INTO txq_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Boe ma ana nafada nae, ‘Mete dei! Basa banda-manu mane kahoak kara hambu kada bulu tatadak, kokotok ma keketak. Au ndia koladu basa naar, nahuu Au mete-ita ena hata fo Laban tao neu o ena. ");
INSERT INTO txq_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Au ia, Manetualain, fo atudu aong neu o numa Betel. O mambaririik batu esa numa naa, basa boe ma mboꞌa mina neu lain, de makaluku-makatele neu Au. Basa boe ma o ndara fangga hehelu-bartaak mua Au numa naa. Hatematak ia o muste laꞌo ela nusak ia, fo fali muni o ina-amam mara nusan naa muu.’ ” ");
INSERT INTO txq_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Boe ma Rahel no Lea raselu rae, “Neu! Ai tungga a mesan! Ai ta maena pusaka hata-hata bali numa ai aman Laban mai. ");
INSERT INTO txq_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Doo basa ia, tou lasik tao ai leo kada hatahori deak kara ena. Ana seꞌo heni ai ena. Boe ma ana naꞌa heni ai beli-mbaan nara ena. ");
INSERT INTO txq_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Basa hata-heto fo Manetualain haꞌin numa papa Laban mai naa, hatematak ia dadi neu ai ma ai anan nara pusakan. Dadi mete ma Manetualain nae talo bee, na, tungga a leo!” ");
INSERT INTO txq_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Basa boe ma Yakob mulai nafafaꞌu bua-loꞌan nara. Boe ma ana fua basa sao-anan nara reu onta lain, ma foo neni basa banda-manun nara, ma basa bua-baꞌu fo ana hambu sara ruma Padan Aram, de ara fali reni dae Kanaꞌan reu. ");
INSERT INTO txq_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Faik naa, Laban neu nggute bibi lombon nara bulun. Boe ma Rahel loi neni aman patong sosonggon nara. ");
INSERT INTO txq_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakob asa laꞌo no kada neneek, ma ta rafada ndia ari-aman. ");
INSERT INTO txq_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ana baꞌu neni basa ndia hata-heton nara, de ara laꞌo lai-laik ladi lee Efrat, boe ma rasare reni letek Gilead reu. ");
INSERT INTO txq_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Seli fai telu, boe ma Laban hambu harak rae, Yakob asa ralai ena. ");
INSERT INTO txq_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Boe ma Laban nakabubua ndia hatahorin nara, fo reu husi tungga ndia mane-feun. Ara husi losa faik hitu, dei de hambu sara ruma Gilead leten nara. ");
INSERT INTO txq_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Neu leꞌodaen, boe ma Manetualain natudu aon neu Laban numa meꞌis dale. Ana nae, “Laban! Mete ma o kokolak mua Yakob, na, manea matalolole o bafa-maam.” ");
INSERT INTO txq_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Leꞌodaen naa, Yakob nambaririik laak numa letek Gilead ena. Boe ma Laban asa oo rambaririik sira laan boe, ta dook ka numa naa neu. ");
INSERT INTO txq_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Basa boe ma Laban mai natonggo no Yakob. Boe ma ana kokolak nae, “Weeh, Yakob! Tao hata de o malai muni au ana inang nggara no neneek talo ia? Sama leo hatahori fo o humu malak nai netatik dale. ");
INSERT INTO txq_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Talo bee de o malai no neneek, ta pake mateꞌa au bali! Mete ma o mafada au no malole dei, na, neu ko au tao feta rame-rame, fo afuli ei pake bua kaliik dei fo mboꞌi ei laꞌo. ");
INSERT INTO txq_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","O salam esa bali, ndia o ta fee au idu au umbu-anang nggara, dei fo mboꞌi sara laꞌo. O tataom ia nggoa bebek sudi selik kana! ");
INSERT INTO txq_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Au bisa tao akasususak o no muda hiek. Tehuu leꞌodaek ka, Manetualain fo o amam nakaluku-nakatele neuk naa kaꞌi-ore au nae, mete ma au kokolak ua o, na, au muste anea atalolole au bafa-maang. ");
INSERT INTO txq_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Memak au bubuluk ae, o laꞌo nahuu o dalem hii nalan seli mae fali ena. Tehuu tao hata de o bei mamanaꞌo muni au patong sosonggong nggara bali?” ");
INSERT INTO txq_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Basa boe ma Yakob naselu nae, “Toꞌo boso mamanasa au! Au laꞌo no neneek naa, nahuu au amataꞌu, boso losak toꞌo namanggenggee kakanak kara iar, na, talo bee?” ");
INSERT INTO txq_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tehuu Yakob ta bubuluk nae, ndia saon Rahel ndia loi neni patong sosonggok kara raa. De ana nae, “Toꞌo! Laꞌe-neu patong raa, sangga leo! Mete ma hambu sara rai see, na, hukun makanisan. Parisa basa sara! Mete ma hambu toꞌo bua pusaka laen, na, haꞌi mala falik kasa. Elan fo basa hatahori iar, dadi reu sakasii.” ");
INSERT INTO txq_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Boe ma Laban neu parisa esa-esak laan. Nakahuluk Yakob laan. Basa boe ma neni Lea laan neu. De neni ata ina kaduak kara laan neu. Tehuu ana ta hambu patong raa. Mateꞌen, ana maso neni Rahel laan neu. ");
INSERT INTO txq_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Tehuu Rahel nafuni patong raa rai onta bebelan ndandaan dae. De nanggatuuk neu bebelak naa lain. Laban parisa no lutuk Rahel laan, tehuu ta hambu sara. ");
INSERT INTO txq_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Boe ma Rahel kokolak no aman nae, “Papa boso mamanasa. Au ta bisa ambariik, huu au hambu bulak.” De Laban sangga seluk bali, tehuu ana ta hambu patong raa. ");
INSERT INTO txq_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Boe ma Yakob namanasa, de ana mboka nasaparak Laban nae, “Au tao manggarauk hata neu toꞌo? Losa toꞌo husi tungga au, nok bali au hatahori manggarauk! ");
INSERT INTO txq_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Toꞌo parisa basa au bua-baꞌung nggara ena. De toꞌo hambu hata? Soba taon neu mata ia fo ita basa ngga mete-tita! Naa fo hatahorir ia raketu rae, bua-baꞌur raa see enan. ");
INSERT INTO txq_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Teuk 20 ena, au dadi kuli neu toꞌo. Neu au kiu-lolo toꞌo banda-manun nara, esa boe na ta kalaheni. Au ta uꞌa heni esa boe na! ");
INSERT INTO txq_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mete ma banda kakiki-kakaak tao nisa toꞌo bandan esa, na, au ta afada toꞌo, tehuu au nggatin. Mete ma hatahorir ramanaꞌo reni toꞌo bandan esa, toꞌo nadenu au nggati, leo mae au ta ndia sala. ");
INSERT INTO txq_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Leledok, au seꞌi ledo. Leꞌodaek au marini dere faku-faku. Au beꞌe losa ta sunggu, nahuu kiu-lolo toꞌo bandan nara. ");
INSERT INTO txq_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Memak teuk 20 naa, tebe! Au aue-osa teuk 14, fo hambu toꞌo ana inan nara. Basa de au aue-osa tamba seluk teuk 6 bali, fo bisa hambu au bandang nggara. Au dadi kuli doo basa naa, tehuu toꞌo soa nggati au seseba-babaeng laꞌe salahunu. ");
INSERT INTO txq_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Endik de hambu Manetualain fo baꞌi Abraham ma papa Isak rakaluku-rakatele neuk. Mete ma Ana ta nanea au, na, neu ko toꞌo nadenu ara husi falik au ua lima rouk ena. Tehuu Manetualain ta napopoke matan neu au susa-sonang, ma ana susuri-memete basa au ue-osang lalaꞌen. Huu naa de leꞌodaek ka, Ana mai ndindia toꞌo.” ");
INSERT INTO txq_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban namanene Yakob kokolan talo naa, boe ma ana naselu nae, “Talo ia! Ina kaduak kara raa, au anang nggara. Kakanak kara fo ara bonggi ralak kara raa, basa sara au umbung nggara. Basa bandar ia, au enang nggara. Basa hata fo o mete-mitak kara iar, memak au enang nggara. Tehuu au ae tao hata? Au ta bisa kena-kaꞌi sara. ");
INSERT INTO txq_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","De malole lenak, ita dua ngga ndara fangga hehelu-bartaak. Ma ita muste leo-laꞌo tungga hehelu-bartaak naa.” ");
INSERT INTO txq_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Basa boe ma Yakob haꞌi nala batu moꞌok esa, de nambaririik kana numa naa, dadi neu tanda nesenedak. ");
INSERT INTO txq_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Boe ma Yakob nadenu hatahorin nara reu raduduru batur fo fua totodo neun. Boe ma basa sara ranggatuuk raꞌa-rinu deka batur raa. ");
INSERT INTO txq_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Basa boe ma Laban foi batu netotodok naa nade, Yegar Sahaduta. Tehuu Yakob foin nade, Galeed. ");
INSERT INTO txq_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Basa boe ma Laban nae, “Batu netotodok ia, dadi sakasii soa-neu ita dua ngga.” Huu naa de mamanak naa nade Galeed. ");
INSERT INTO txq_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban oo foi mamanak naa nade Mispa boe (fo dedeꞌa deꞌek naa liin sangga sama leo dedeꞌa deꞌek laen, fo sosoa-ndandaan ‘mamana neneak demak’), nahuu ana kokolak nae, “Neu ko MANETUALAIN mesa kana ndia nanea ita dua ngga, fo leo mae ita takadodook oo, ita ta lena-langga hehelu-bartaak ia boe. ");
INSERT INTO txq_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Mete ma o tao manggarauk neu au anang nggara iar, do sao ina laen nara, neu ko au ta bubuluk. Tehuu masanedak! Manetualain ndia dadi sakasii neu o, ma au. ");
INSERT INTO txq_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Soba mete neu batu mana mambariik ia, ma batu netotodok. Masaneda huu batur ia oo dadi neu too-lane boe. O ta bole seli batur ia fo tao manggarauk neu au. Ma au oo ta bole seli batur ia fo tao manggarauk neu o boe. ");
INSERT INTO txq_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ita dua ngga ndara fangga hehelu-bartaak ia pake ita bei-baꞌin nara Manetualain naden. Fo ndia o baꞌim Abraham, ma au baꞌing Nahor Manetualain. Dei fo Ndia mesa kana ndia dadi mana maketu-maladi dedeꞌak fo naketu-naladi ita dedeꞌan.” Yakob namanene nala naa, boe ma ana soꞌuk sumba-sook mates pake Manetualain naden fo ndia aman Isak nakaluku-nakatele neuk. ");
INSERT INTO txq_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Basa boe ma Yakob tunu-hala banda-manu, de ana nenin dadi tunu-hotuk fee Manetualain numa letek naa lain. Boe ma ana noke basa hatahorir, de raꞌa-rinu rame-rame ma ara beꞌe losa beꞌe-mai huhua anan numa naa. ");
INSERT INTO txq_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Neu beꞌe-mai huhua anan, Laban neu idu-holu basa umbu-anan nara. Basa de ana kokolak fee babaꞌe-babatik neu sara, boe ma ana fali neni nusan neu. ");
INSERT INTO txq_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Basa de Yakob asa laꞌok rakandooo. Boe ma Manetualain atan nara ruma nusa tetuk do inggu temak mai ratonggo roon. ");
INSERT INTO txq_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Neu ana mete-nita sara, boe ma ana kokolak nae, “Fama te Manetualain soldadun nara mamana hahaen nai ia!” Huu naa de ana foi mamanak naa nade Mahanaim (fo sosoa-ndandaan ‘mamana hahaek dua’). ");
INSERT INTO txq_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Basa boe ma Yakob nadenu ana nunin hida laꞌok rakahuluk reni nusa Edom reu (ndia Seir), fo rafada ndia kaꞌan Esau rae, ndia nae mai. ");
INSERT INTO txq_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakob nafada ana nunin nara nae, “Ei miu mafada au kaꞌang Esau talo ia: ‘Papa Esau! Papa atam, fadim Yakob, haitua hara masodak noꞌuk ka neu papa. Numa au laꞌo ndia fai bakahulun losa hatematak ia mai, papa atan leo nai toꞌo Laban uman. ");
INSERT INTO txq_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Hatematak ia papa atan ia naena sapi, keledei, bibi hiek, bibi lombo, ata touk ma ata inak ena. Au adenu hatahorir ia rakahuluk, fo reni harak fee papa laꞌe-neu au mamaing. Au amahena papa nau simbok ai no lima makambelak.’ ” Boe ma hatahorir raa reu. ");
INSERT INTO txq_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Neu ara lenggu fali Yakob mai, boe ma ara tui rae, “Ai miu matonggo mia papa kaꞌan Esau ena. Hatematak ia ana mai no touk 400, fo nae natonggo no papa.” ");
INSERT INTO txq_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakob namanene nala naa, boe ma tenden nduka-nduka ma namataꞌu nalan seli. Boe ma ana baꞌe basa bandan nara ma hatahorin nara neu bubuak dua. ");
INSERT INTO txq_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ana duꞌa nae, “Mete ma Esau mai, fo ana nggafu fee bubuak kaesan, na, bubuak kaduan bisa ralai sangga sodak.” ");
INSERT INTO txq_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Basa boe ma Yakob hule-haradoi nae, “Manetualain, ee! Manetualain fo au baꞌing Abraham ma au amang Isak rakaluku-rakatele neuk. Nenene neu au dei. Fai maneuk kara, Manetualain ndia nadenu au fo fali uni au nufanelung nggara mai, nai nusak ia. Manetualain ndia helu-bartaa nae, neu ko Manetualain koladu tao natetu basa-basan. ");
INSERT INTO txq_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Au ta andaa simbok Manetualain susue-lalain, ma Manetualain dale mahanin. Fai bakahulun neu au ladi lee Yarden, au uni kada teteꞌe ai. Tehuu hatematak ia au fali ia mai ngga, uni hatahorir ma banda-manur bubuak dua. ");
INSERT INTO txq_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Au amataꞌu, boso losak kaꞌa Esau mai nggafu tao nisa ai basa ngga. De au hule fo Manetualain tao nasoi-nasoda au ua basa sao-anang nggara numa kaꞌa Esau mai. ");
INSERT INTO txq_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Manetualain ndia helu-bartaa nae, Manetualain fee babaꞌe-babatik noꞌuk ka neu au, ma tao au tititi-nonosing nggara tamba ramanoꞌu, sama leo sarakaek nai tasi tatain fo hatahorir ta bisa reke rala sara.” ");
INSERT INTO txq_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Basa boe ma Yakob sunggu numa mamanak naa. Neu beꞌe-main, boe ma ana here nala banda fo nae fee hadia neu kaꞌan. ");
INSERT INTO txq_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ana here nala bibi hie ina 200, bibi hie mane 20, bibi lombo ina 200, bibi lombo mane 20, ");
INSERT INTO txq_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","0nta ina 30 ro ana kalasusun nara, sapi ina 40, sapi mane 10, keledei ina 20, ma keledei mane 10. ");
INSERT INTO txq_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Basa boe ma ana baꞌe banda-manur raa, matak esa-esak no ndia fofoon. Boe ma ana fee fofook esa-esak nonook mana lolon. Ana nafada sara nae, “Ei laꞌok makahuluk. Dei fo au tungga dea. Tehuu ei muste mete fo fofook esa naomba dook ka faa numa fofook laen mai.” ");
INSERT INTO txq_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Boe ma Yakob parenda mana lolo numa fofook kaesan mai nae, “Mete ma au kaꞌang Esau natonggo no o, ma ana natane nae, ‘O mae bee muu? O ia, see atan? Banda-manur ia, see enan?’ ");
INSERT INTO txq_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ei muste maselu mae, ‘Banda-manur ia, papa atan Yakob enan. Ana haitua fee kaꞌan, papa Esau. Tehuu ndia mesa kana bei tungga dea.’ ” ");
INSERT INTO txq_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Ana oo fee parenda talo naa neu basa mana lolo numa fofook laen nara mai boe nae, “Mete ma matonggo mia kaꞌa Esau ena, ei hadia banda-manur raa neun. Ma ei mafadan mae, au bei tungga dea.” Yakob duduꞌa nae, mete ma ana fee basa banda-manur raa reu Esau, na, neu ko Esau dalen bangganaꞌu neu ndia. ");
INSERT INTO txq_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","De ana haitua banda-manur raa rakahuluk. Tehuu leꞌodaen naa, ana bei nahani numa naa. ");
INSERT INTO txq_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Leꞌodaen naa, Yakob nambadeik, de fee sao kaduan nara, sao tia kaduan nara, ma ana kasalahunu esan nara, fo ladi reni lee Yabok boboan seri reu. ");
INSERT INTO txq_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Neu basa sara losak a seri, boe ma ana haitua basa hata-heton nara reni naa reu. ");
INSERT INTO txq_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Tehuu Yakob mesa kana bei nahani numa naa. Basa boe ma touk esa mai, de naule noon losa lole manggaledo. ");
INSERT INTO txq_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Neu touk naa nameda Yakob sangga nae senggi ndia ena, boe ma ana femba Yakob sakabukun, de dui buꞌun kosir laꞌo ela mamanan. ");
INSERT INTO txq_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Boe ma touk naa nae, “Makamboꞌik au, huu doo-doo faa te ledo nae toda ena.” Tehuu Yakob naselu nae, “O fee babaꞌe-babatik neu au dei, dei fo au akamboꞌik o!” ");
INSERT INTO txq_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Boe ma touk naa natane nae, “O nade see?” Ana naselu nae, “Yakob.” ");
INSERT INTO txq_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Basa boe ma touk naa kokolak nae, “O ta nade Yakob ena. Tehuu mulai hatematak ia neu, hatahorir roke o rae, Israꞌel, nahuu o maule laban hatahori dae-bafok ma Manetualain ena, losa o masenggin.” (Nade Israꞌel sosoa-ndandaan ‘mana maulek no Manetualain’.) ");
INSERT INTO txq_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Boe ma Yakob natane nae, “O nade see?” Tehuu touk naa nae, “O nau matane au nadeng tao hata?” Basa boe ma ana fee babaꞌe-babatik neu Yakob numa naa. ");
INSERT INTO txq_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Basa de Yakob kokolak nae, “Au mete-ita Manetualain matak no matak ena, tehuu au bei masodak.” Huu naa de ana foi mamanak naa nade Peniel, fo sosoa-ndandaan nae, ‘Manetualain matan’. ");
INSERT INTO txq_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakob laꞌo ela mamanak naa, neu ledo nai lain ena. Tehuu ana laꞌok doka-doka, nahuu sakabuku duin nalai sala. ");
INSERT INTO txq_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Huu naa de losa hatematak ia, hatahori Israꞌel asa ta raꞌa mbaa banda sakabukun, nahuu Manetualain femba sira baꞌin Yakob sakabukun, de duin nalai sala. ");
INSERT INTO txq_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Faik naa oo, Yakob mete-nita Esau mai no ndia nononggon hatahori 400 boe. Boe ma ana babaꞌe anan nara reni inan nara esa-esak reu. ");
INSERT INTO txq_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ana fee sao tia kaduak kara raa ro ana nara laꞌok resi mata. Basa de Lea no anan nara, dei de Rahel no anan Yusuf resi seku dea. ");
INSERT INTO txq_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Tehuu Yakob laꞌok seku nesi mata numa basa sara mai. Neu ana sangga deka-deka no kaꞌan ena, ana sendek luu-langgan ma nateꞌe langgan losa daer, laꞌe hitu. ");
INSERT INTO txq_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tehuu neu Esau mete-nita fadin, boe ma nalaik neu soru Yakob, de ana holu nalan ma idun. Boe ma dua sara buꞌi. ");
INSERT INTO txq_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Neu Esau mete-nita inak kara ro anan nara raa, boe ma ana natane nae, “Basa hatahorir ia, seer?” Boe ma Yakob naselu nae, “Hatahorir raa Manetualain fee sara reu au ena, fo kaꞌa atan.” ");
INSERT INTO txq_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Basa boe ma sao tian nara, ma ana nara mai kaur langgan nara mbali Esau. ");
INSERT INTO txq_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Basa de Lea no anan nara mai kaur langgan nara mbali Esau. Mana tungga dea mateꞌen, Yusuf no inan Rahel mai kaur langgan nara mbali Esau. ");
INSERT INTO txq_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Basa boe ma Esau natane nae, “Banda-manu fofook kara fo o haituak bebeik kara raa, sosoan hata?” Boe ma Yakob naselu nae, “Talo ia kaꞌa! Au hadia basa banda-manur raa fee kaꞌa, mita fo kaꞌa simbok au no dale loak.” ");
INSERT INTO txq_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tehuu Esau bala nae, “Fadi Yakob! Au hata-hetong oo noꞌuk ka boe. De o hae fee au hata-hata.” ");
INSERT INTO txq_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Boe ma Yakob naselu nae, “Kaꞌa boso talo naa! Kaꞌa muste simbok fo dadi neu tanda nae, kaꞌa simbok au no lima makambelak. Neu au mete-ita kaꞌa huhumen bebeik kara ia, nok bali au ita Manetualain huhumen. ");
INSERT INTO txq_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","De au hule no hada-horomatak, mita fo kaꞌa simbo mala au hadiang ta kandaak ia. No Manetualain neulaun sudi selik kana no au ena, huu naa de Ana fee basa hata fo au toꞌak ena.” Yakob kokoe nakandooon, losa nau ta nau, Esau simbo hadiar raa. ");
INSERT INTO txq_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Basa boe ma Esau kokolak nae, “Mete ma talo naa, na, ei mahehere fo ita laꞌo leo! Dei fo au afuli ei.” ");
INSERT INTO txq_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Tehuu Yakob naselu nae, “Bosok kaꞌa! Kaꞌa mete aom. Kanak kara bei kadiꞌi anak kara, de ara ta bisa laꞌo lai-laik. Banda-manu mana bonggi beuk kara oo noꞌuk ka boe. Mete ma ita takasetik kasa laꞌok lai-lai, na, neu ko nai kada faik esa dalen, banda-manur ia bisa mate basa sara. ");
INSERT INTO txq_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","De malole lenak kaꞌa sara laꞌok makahuluk leo. Dei fo ai basa ngga laꞌok koe-koe tungga dea. Dei fo ai neti tiro kaꞌa nai Seir.” ");
INSERT INTO txq_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Basa boe ma Esau kokolak bali nae, “Mete ma talo naa, na, au ela au ana nunin ruma ro o, fo ara ratudu dalak neu ei.” Tehuu Yakob nae, “Kaꞌa hae tao mbutes neu kaꞌa aon. Sadi au bubuluk ae, kaꞌa simbok nala au no malole ena.” ");
INSERT INTO txq_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Esau namanene nala naa, boe ma ana laꞌo ela sara de fali neni Seir neu. ");
INSERT INTO txq_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Tehuu numa mamanak naa neu, Yakob neni Sukot neu. Numa naa, ana nambaririik uma ma tao lalae fee basa banda-manun nara. Huu naa de mamanak naa, ara foin nade Sukot (fo sosoa-ndandaan ‘uma leo taak’). ");
INSERT INTO txq_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Mateꞌen, Yakob asa losa no sodak ruma Padan Aram mai reni nggoro Sikem reu, nai nusa Kanaꞌan. Boe ma ara rambaririik laak, de leo deka-deka nggorok naa. ");
INSERT INTO txq_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Dae fo Yakob nambaririik laak neuk naa, ana hasa ketun numa Hemor, fo Sikem aman mai. Ana bae nenik doi fulak 100. ");
INSERT INTO txq_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Numa naa, ana totodo batur fo tao mei tunu-hotuk. Basa boe ma ana foi mamanak naa nade El-Elohe-Israꞌel fo sosoa-ndandaan ‘Manetualain naa, Israel Manetualain.’ ");
INSERT INTO txq_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Laꞌe esa, Yakob no Lea ana inan, Dina, neu tiro-dangga ana feꞌok kara marai nusak naa. ");
INSERT INTO txq_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Nusak naa manen, nade Hemor, numa leo Hewi mai. Ana toun nade Sikem. Laꞌe esa, Sikem mete-nita Dina, boe ma leꞌa nenin, de ana boden. ");
INSERT INTO txq_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sikem dalen tuda neu Dina, ma ana sue nalan seli. De ana kokolak nalolole no Dina, mita fo Dina oo bala ndia susuen boe. ");
INSERT INTO txq_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Boe ma Sikem nafada aman nae, “Papa! Tulun muu matane Dina fo au bisa sao alan.” ");
INSERT INTO txq_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakob namanene hambu hatahori bode ndia ana inan ena, tehuu ana kada nenee, ma ta nakaundak hata-hata. Huu faik naa, ana toun nara ranea bandar rai mook. De ana nahani losa basa sara fali. ");
INSERT INTO txq_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Faik naa, Sikem aman Hemor, neni Yakob neu, fo nae natane Dina. ");
INSERT INTO txq_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ndaa no dua sara bei kola-kola, Yakob anan nara fali numa mook mai. Neu ara ramanene rae, Sikem bode sira fadi inan, boe ma dalen nara hedis, ma ramanasa ralan seli. Basa boe ma ara rae, “Dedeꞌak matak talo ia, ta nandaa mori-dadi nai Israꞌel. De ita ta bole simbok hatahori tao manggarauk talo naa.” ");
INSERT INTO txq_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Boe ma Hemor kokoe Yakob asa nae, “Toranoo Yakob! Au anang Sikem dalen tuda tebe-tebe neu toranoo ana inan ena. De au hule fo fee luas au anang sao nalan. ");
INSERT INTO txq_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mete ma bisa, na, ita anan nara esa laꞌe esa. Ei ana toum mara sao ro ai ana inan nara. Ma ai ana toun nara sao ro ei ana inam mara. ");
INSERT INTO txq_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Elan fo ei leo mabali mia ai nai ia. Ei bisa leo sudi nai bee. Basa naa masembo-danggak, fo hambu hata-heto nai ia.” ");
INSERT INTO txq_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Basa naa, Sikem kokolak no Dina aman, ma kaꞌan nara nae, “Ei nau moke hata a mesan au tungga. Ei nau moke doi tatana mamaek, ma beli-mban baꞌu hata a mesan, au bae. Sadi ei nau fee luas fo au soa ei fadi inam.” ");
INSERT INTO txq_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tehuu Yakob anan nara bubuluk ena rae, Sikem bode sira fadin Dina ena. De ara raselu kekedik Sikem no aman Hemor. ");
INSERT INTO txq_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Boe ma ara raselu rae, “Ai ta bisa fee ai fadin sao no hatahori fo ta bei neni sunat! Naa, neni mamaek soa-neu ai! ");
INSERT INTO txq_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tehuu dala sasain, talo ia: basa ei touk kara lalaꞌen, moꞌo-kadiꞌik, muste sunat sama leo ai. ");
INSERT INTO txq_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Mete ma ei tao talo naa, dei fo ita bisa esa sao esa. Ma ai oo bisa leo sama-sama mia ei nai ia boe, fo ita bisa dadi teu hatahori nusak esa. ");
INSERT INTO txq_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tehuu mete ma ei ta nau tungga ai hihiin, ma ta nau sunat, na, neu ko ai haꞌi falik ai fadin, fo ai huꞌa laꞌo ela ia.” ");
INSERT INTO txq_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hemor no Sikem simbok kokolan nara no neulauk. ");
INSERT INTO txq_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tehuu Sikem ta nakataka nala dalen ena, nahuu ana sue nalan seli neu Dina. Ma basa hatahorir marai nusak naa ara fee hada-horomatak neu Sikem. ");
INSERT INTO txq_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","De Hemor no Sikem reni mamana neole dedeꞌak nai nggorok lelesu mason reu, boe ma rakokola aok ro basa hatahorir marai nusak naa. Ara kokolak rae, ");
INSERT INTO txq_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Basa toranoo nggara ein! Hatahori Israꞌel asa iar hii leo-laꞌo mole-dame ro ita. De ela sara leo sama-sama ro ita nai nusak ia. Nusak ia loan dai soa-neu ita basa ngga. Ita bisa sao tala sira ana feꞌon nara. Sira oo bisa sao rala ita ana feꞌon nara. ");
INSERT INTO txq_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ara roke kada dedeꞌa kadiꞌi anak esa numa ita mai. Ndia, basa ita touk kara muste sunat sama leo sira. ");
INSERT INTO txq_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Mete ma ita leo-laꞌo teu esa ena, na, dei fo sira banda-manun nara ma hata-heton nara oo dadi neu ita pusakan boe, hetu? De malole lenak ita simbok sira hihii-nanaun. Mai fo ita basa ngga sunat sama-sama. Makaheik, do?” ");
INSERT INTO txq_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Boe ma basa hatahorir fo mana rakabua ruma naa, rakaheik ro Hemor no Sikem kokolan. De basa tour marai nusak naa sunat rame-rame. ");
INSERT INTO txq_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Neu fai katelun, neu basa mana sunat ara, bisun nara bei rambeta, boe ma Dina kaꞌan Simeon no Lewi, lesu rala dombe-tafan nara de ara maso no neneek reni nggorok dale reu. Boe ma ara hala risa basa touk kara raa. ");
INSERT INTO txq_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ara oo hala risa Hemor no Sikem boe. Boe ma ara leꞌa ro Dina kalua numa Sikem uman mai, de ara fali. ");
INSERT INTO txq_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Basa boe ma Yakob anan laen nara maso reni nusak naa dale reu, de ara foꞌai reni nusak naa isi-oen. Ara ramanasa, nahuu hatahori bode sira fadi inan numa naa ena. ");
INSERT INTO txq_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ara foꞌai reni basa hatahorir uman nara isi-oen, ma foo reni basa hatahorir banda-manun nara numa mook mai. ");
INSERT INTO txq_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ara leꞌa reni basa inak kara ro anan nara, ma foꞌai reni basa nusak naa bua-baꞌu mabelin nara. ");
INSERT INTO txq_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Neu Yakob bubuluk anan nara tatao-nonoꞌin naa, boe ma ana kokolak no Simeon ma Lewi nae, “Ei tao ue-tatao nggoa bebek hata ia ena? Kada tao makasususak au! Neu ko hatahori Kanaꞌan, hatahori Peris, ma basa hatahori marai nusak ia, ara mburuk ralan seli ro ita. Sira hatahorin nara noꞌuk ka. Tehuu ita hatahorin nara kada hidak ka. Mete ma ara mai nggafu fee ita, na, neu ko etoboꞌa memak nala ita leo maa.” ");
INSERT INTO txq_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tehuu ara raselu ro nasak rae, “Papa! Fama te papa duꞌa nae ai mboꞌi sara tao ai fadim dadi neu ina petak, do?” ");
INSERT INTO txq_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Basa boe ma Manetualain kokolak no Yakob nae, “Au ia, Manetualain, fo mana natudu aong neu o ena, neu faik fo o malai numa o kaꞌam Esau mai. Hatematak ia o lali muni Betel muu leo. Losa naa, o totodo batur tao mei tunu-hotuk fo makaluku-makatele neu Au. Basa naa o leo muu naa leo.” ");
INSERT INTO txq_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Boe ma Yakob kokolak no basa ndia uma isin nara nae, “Hatematak ia, ita basa ngga tae laꞌok teni Betel teu. Bakahulun neu au bei numa susa-sonak dale, Manetualain tulun nala au numa naa. Au nau ambaririik mei tunu-hotuk neu naa. Dadi hatematak ia, ei nggari heni basa ei bua sosonggom mara lalaꞌen. Tao malalao ei ao-inam mara, ma nggati ei bua-loꞌam mara, huu ita nau takaluku-takatele neu Manetualain.” ");
INSERT INTO txq_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Boe ma ara loo lima sira bua sosonggon nara ro basa sira falon nara. Basa boe ma Yakob nakadodofu basa buas sara raa reu ai huu moꞌok esa taen, deka nggorok Sikem. ");
INSERT INTO txq_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Neu Yakob no ndia nononggon nara laꞌok ruma Sikem mai, Manetualain fee nemeda nemetaꞌuk neu hatahorir rai nusak matia-aok kara, losa ara ta rambarani tao manggarauk neu Yakob asa. ");
INSERT INTO txq_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Boe ma Yakob no basa ndia nononggon nara, losa Betel (fo fai bakahulun nade Luus) no sodak, nai dae Kanaꞌan. ");
INSERT INTO txq_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Numa naa, Yakob nambaririik mei tunu-hotuk numa batu mai. Basa boe ma ana foi mamanak naa nade El Betel, (fo sosoa-ndandaan ‘Betel Manetualain’), nahuu fai bakahulun Manetualain natudu aon neu Yakob numa naa, neu faik fo ana nalai numa ndia kaꞌan mai. ");
INSERT INTO txq_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deka no nggorok Betel, hambu ai huu moꞌok esa, hatahorir foin nade, Alon Bakut. Sosoa-ndandaan ‘ai huu makarereuk’. Ana hambu nadek naa, nahuu neu Debora fo Ribka ina mana koꞌon maten, ara ratoin neu ai huuk naa taen. ");
INSERT INTO txq_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Neu Yakob fali numa Padan Aram mai, Manetualain natudu aon bali, ma Ana feen babaꞌe-babatik. ");
INSERT INTO txq_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Manetualain kokolak nae, “Mulai hatematak ia neu, o nadem ta Yakob bali. Tehuu Au fee o nade beuk, ndia Israꞌel. ");
INSERT INTO txq_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Au ia, Manetualain mana Koasa Mateꞌen. De o bonggi maumbu-ana noꞌun seli leo! Neu ko hatahori nusak kara mori-dadi numa o tititi-nonosim mara mai. Ma neu ko o bonggi mala mane-manek kara. ");
INSERT INTO txq_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nusak fo Au feen neu o baꞌim Abraham ma amam Isak naa ena, hatematak ia Au feen neu o mua basa o tititi-nonosim mara.” ");
INSERT INTO txq_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Manetualain kokolak basa talo naa, boe ma Yakob nambaririik dii batu esa neu naa, mita fo dadi tanda nesenedak neu Manetualain hehelu-bartaan. Boe ma ana mboꞌa oe anggor no mina neu batu naa lain, de nakaluku-nakatele neu Manetualain. ");
INSERT INTO txq_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Mamanak naa, ana foin nadeBetel. ");
INSERT INTO txq_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Basa boe ma Yakob asa laꞌo ela Betel. Neu ara bei dook ka faa numa Efrata mai (ndia Betlehem), Rahel fain fo nae bonggi losa ena. Tehuu ana bonggi nakareo. ");
INSERT INTO txq_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Neu ana bei nakananasa sota-mate, boe ma hatahori mana makabobonggik nafada neun nae, “Mama Rahel! Tao matetea dalem, huu hambu ana touk bali!” ");
INSERT INTO txq_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Neu Rahel sangga nae ketu ani hahaen, boe ma ana foi kanak naa, nade, Ben-Oni, (fo sosoa-ndandaan ‘kanak numa au doidosong mai’). Basa boe ma maten. Tehuu Yakob foi kanak naa nade Benyamin, (fo sosoa-ndandaan ‘kanak lima konak.’) ");
INSERT INTO txq_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Basa boe ma ratoi Rahel neu dalak mana neni Efrata neu tatain (fo hatematak ia, nade Betlehem). ");
INSERT INTO txq_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Boe ma Yakob nambaririik batu rates esa neu naa. Losa faik ia oo, Rahel batu raten naa bei nai naa boe. ");
INSERT INTO txq_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Basa boe ma Yakob lali-lali nakandoo. Laꞌe esa, ana tao laak numa manara Eder boboan. ");
INSERT INTO txq_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Neu ara bei ruma naa, Ruben sunggu-soro no ndia aman sao tian, Bilha. Yakob bubuluk anan tatao-nonoin naa. Yakob ana toun salahunu dua. ");
INSERT INTO txq_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea anan nara, sira: Ruben (fo Yakob ana ulun), Simeon, Lewi, Yahuda, Isaskar, ma Sebulon. ");
INSERT INTO txq_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel anan nara, sira: Yusuf no Benyamin. ");
INSERT INTO txq_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel atan Bilha anan nara, sira: Dan no Naftali. ");
INSERT INTO txq_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Boe ma Lea atan Silpa anan nara, sira: Gad no Aser. Bonggi kakanak kara raa ruma Padan Aram. ");
INSERT INTO txq_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Basa boe ma Yakob neu tiro aman Isak numa Mamre, deka no nggorok Kiriat-Arba (fo hatematak ia ndia Hebron). Fai bakahulun, baꞌin Abraham oo leo numa naa boe. ");
INSERT INTO txq_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak nasoda losa teun nara 180, dei de maten. Boe ma anan nara Esau no Yakob ratoin. ");
INSERT INTO txq_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ia Esau tititi-nonosin nara. Naden laen ndia Edom. ");
INSERT INTO txq_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau sao ana feꞌok Kanaꞌan dua, esa hatahori Het, ndia Elon ana inan, nade Ada. Sao kaduan, hatahori Hewi, nade Oholibama. Aman nade Anah, ma baꞌin nade Sibeon. ");
INSERT INTO txq_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esau oo sao nala Ismael ana inan, nade Basmat. Basmat kaꞌa toun, nade Nebayot. ");
INSERT INTO txq_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esau sao ulun, Ada, bonggi Elifas. Basmat bonggi Rehuel. ");
INSERT INTO txq_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Boe ma Oholibama bonggi Yeus, Yalam, ma Kora. Bonggi basa Esau anan nara ruma nusa Kanaꞌan. ");
INSERT INTO txq_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Laꞌe esa, Esau lali neni nusak laen esa neu dook ka numa Yakob mai. Ana nuni noo sao-anan nara, hatahori mana maue-osan, banda-manun ma ndia hata-heton nara lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau nabingga-baꞌek no Yakob, nahuu sira banda-manun ma hata-heton nara noꞌun seli. Dadi ara leo-laꞌo rakaseseꞌe nai nusak naa. ");
INSERT INTO txq_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Boe ma Esau (ndia Edom), neu leo nusa mbuku-letek nai Seir. ");
INSERT INTO txq_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ia, Esau tititi-nonosin fo ara rae, ‘hatahori Edom’. Ara leo numa nusa mbuku-letek nai Seir. ");
INSERT INTO txq_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esau saon Ada, bonggi nala anak touk esa, nade Elifas. Elifas ana toun nara lima. Sira: Teman, Omar, Sefo, Gatam, ma Kenas. Elifas sao tian, nade Timna. Ana bonggi nala ana touk esa, nade Amalek. Esau saon mana nade Basmat, bonggi nala ana touk esa, nade Rehuel. Rehuel bonggi nala ana touk haa, sira: Nahat, Sera, Syama, ma Misa. ");
INSERT INTO txq_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau saon Oholibama, fo ndia Anah anan, fo Sibeon umbun naa, bonggi nala ana touk telu, sira: Yeus, Yalam, ma Kora. ");
INSERT INTO txq_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esau umbu-anan nara ratanggela dadi reu leo noꞌuk ka. Esa-esak no sira mane leon. Esau ana ulun Elifas anan nara, dadi reu mane leo Teman, mane leo Omar, mane leo Sefo, mane leo Kenas, mane leo Kora, mane leo Gatam, ma mane leo Amalek. Sira basa sara raa, Esau no saon Ada tititi-nonosin. ");
INSERT INTO txq_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau anan Rehuel anan nara, dadi mane leo Nahat, mane leo Sero, mane leo Syama, ma mane leo Misa. Sira basa sara raa, Esau no saon Basmat tititi-nonosin. ");
INSERT INTO txq_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau no saon Oholibama anan nara, dadi mane leo Yeus, mane leo Yalam, ma mane leo Kora. ");
INSERT INTO txq_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Basa leor raa lalaꞌen, Esau tititi-nonosin. ");
INSERT INTO txq_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Numa mamanak naa oo hambu hatahori Hori esa boe, nade Seir. Anan nara ratanggela dadi leo noꞌuk ka. Esa-esak no sira mane leon. De ndia anan nara dadi mane leo Lotan, mane leo Sobal, mane leo Sibeon, mane leo Anah, mane leo Dison, mane leo Eser, ma mane leo Disan. ");
INSERT INTO txq_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan anan, sira: Hori ma Heman (Lotan feton, Timna). ");
INSERT INTO txq_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal anan nara, sira: Alwan, Manahat, Ebal, Sefo ma Onam. ");
INSERT INTO txq_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon anan nara, sira: Aya no Anah. Anah naa, ndia natonggo oe mata katobik numa mamana nees, neu ana lolo aman keledein nara. ");
INSERT INTO txq_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anah ana inan ndia Oholibama, ma ana toun ndia, Dison. Dison anan nara, sira: Hemdan, Esban, Yitran, ma Keran. ");
INSERT INTO txq_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser anan nara, sira: Bilhan, Saꞌawan, ma Akan. ");
INSERT INTO txq_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan anan nara, sira: Us ma Aran. ");
INSERT INTO txq_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Dadi mane leor hatahori Horir raa, sira: Lotan, Sobal, Sibeon, Anah, Dison, Eser, ma Disan. Sira basa sara leo numa nusa Seir. ");
INSERT INTO txq_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Neu nusa Israꞌel bei ta hambu manek, nai dae Edom hambu manek kara ena. Sira naden nara tungga-tungga, sira: ");
INSERT INTO txq_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ara soꞌu Beor anan, nade Bela, dadi manek numa kota Dinhaba. ");
INSERT INTO txq_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Neu Bela maten, boe ma Yobab hene dadi manek nggatin. Ndia aman, nade Sera numa nggorok Bosra mai. ");
INSERT INTO txq_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Neu Yobab maten, boe ma Husam hene dadi manek nggatin. Husam naa, numa hatahori Teman nara nusan mai. ");
INSERT INTO txq_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Neu Husam maten, boe ma Hadad hene dadi manek nggatin. Ndia aman, nade Bedad numa nggorok Awit mai. (Ana ndia nasenggi hatahori Midian neu lelek fo ara ratati numa Moab.) ");
INSERT INTO txq_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Neu Hadad maten, boe ma Samla hene dadi manek nggatin. Samla naa, numa nggorok Masreka mai. ");
INSERT INTO txq_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Neu Samla maten, boe ma Saul hene dadi manek nggatin. Saul naa, numa nggorok Rehobot nai lee tatain mai. ");
INSERT INTO txq_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Neu Saul maten, boe ma Baꞌal-Hanan hene dadi manek nggatin. Ndia aman, nade Akbor. ");
INSERT INTO txq_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Neu Baꞌal-Hanan maten, boe ma Hadar hene dadi manek nggatin. Hadar naa, numa nggorok Pau mai. Saon nade Mehetabel. Mehetabel aman, nade Matret. Ma ndia baꞌin, nade Mesahab. ");
INSERT INTO txq_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Dadi mane leor mana konda numa Esau sara mai, sira: Timna, Alwa, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibsar, Magdiel, ma Iram. Sira esa-esak foi sira nusan nara tungga sira nade heli-helin. Dadi basa naar, tutuik laꞌe-neu Esau tititi-nonosin, ndia hatahori Edom mara. ");
INSERT INTO txq_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2a","Ia Yakob asa tutuin. Fai maneuk kara, Yakob neu leo seluk bali numa dae Kanaꞌan. Naa, ndia aman Isak mamana leleon numa fai bakahulun mai. ");
INSERT INTO txq_vpl VALUES ("GN37_2b","002_37_2b","GEN","37","2b","2b","Lelek naa, Yakob anan esa numa saon Rahel mai, nade Yusuf. Neu teun nara 17, ana no kaꞌan nara rasiꞌe reu ranea sira bibi hien ma bibi lombon nara sama-sama. Kaꞌan nara sira Yakob no saon Bilha ma Silpa anan nara. Tehuu Yusuf ia, mana bafa lafok fee aman laꞌe-neu ndia kaꞌan nara tatao-nonoꞌin. ");
INSERT INTO txq_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Neu bonggi Yusuf, Yakob lasik ena. Huu naa de ana sue nala Yusuf lena heni anan laen nara. Laꞌe esa, Yakob tao badu naruk esa lolen seli fee Yusuf. ");
INSERT INTO txq_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Neu kaꞌan nara mete-rita sira aman sue nakalena neu Yusuf, boe ma ara mburuk ralan seli roon, losa ara ta nau kokolak malole roon bali. ");
INSERT INTO txq_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Leꞌodaek esa, boe ma Yusuf nala meꞌi. Basa boe ma ana nafada meꞌis naa neu kaꞌan nara nae, “Wee! Ei nenene dei! Au ala meꞌi ae, ita basa ngga futu-paꞌa ita hade-nggandum nara ruma osi dale. Boe ma au hadeng nambariik ndoo fido-fidok. Tehuu ei hadem mara rambariik eko-feo rala au enang, de ara kaur langgan nara mbali au enang.” Kaꞌan nara ramanene rala naa, boe ma ara tamba rasakele neun bali. ");
INSERT INTO txq_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Basa boe ma ara ndindia Yusuf rae, “Woi! O duꞌa mae, o nau dadi neu malanggan fo parenda ai, do?” Ara rasakele ralan seli neun ena, nahuu ana nafada ndia meꞌin naa. ");
INSERT INTO txq_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Basa boe ma Yusuf nala meꞌi seluk bali. Boe ma ana nafada kaꞌan nara nae, “Wee! Au ala meꞌi bali. Au mete-ita ledo, bulan, ma nduuk salahunu esa. Basa sara kaur langgan nara no malole mbali au.” ");
INSERT INTO txq_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yusuf tui basa meꞌis naa neu ndia aman ma kaꞌan nara ena, boe ma aman nahara nahere neun nae, “Meꞌis matak bee naa! O duꞌa mae, au ma o inam, ma o kaꞌa-fadim mara mai fo ai idu o eim? O neulauk naa ena maa!” ");
INSERT INTO txq_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","De Yusuf kaꞌan nara mbiri ralan seli roon. Tehuu ndia aman duꞌa ta basa-basa no meꞌis naa. ");
INSERT INTO txq_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Faik esa, Yusuf kaꞌan nara foo reni sira aman bibi hien ma bibi lombon nara losa deka nggorok Sikem. ");
INSERT INTO txq_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ta dook ka boe ma aman nae, “Usu, ee! O kaꞌam mara lolo bibi hiek ma bibi lombo deka-deka nai Sikem. De mahehere fo muu tiro sara dei.” Boe ma Yusuf naselu nae, “Malole, papa.” ");
INSERT INTO txq_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","De aman nae, “O muu dei, fo tiro sudi o kaꞌam mara ma au bibi hieng ma bibi lombong nggara. Ara talo bee, na, o fali mai fo tui au.” Boe ma Yusuf laꞌo ela dae Hebron moon, de nakandooo neu losa Sikem. ");
INSERT INTO txq_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Losak ka boe ma ana sangga sara ndule mook. Basa boe ma ana natonggo no hatahori esa, de hatahori naa natanen nae, “O sangga hata?” ");
INSERT INTO txq_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusuf naselu nae, “Toꞌo, au sangga au kaꞌang nggara. Ara foo bibi hiek ma bibi lombo sangga naꞌu deka-deka nai ia. Toꞌo mete-nita sara boe, do?” ");
INSERT INTO txq_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Boe ma hatahori naa nafada nae, “Ara ta rai ia ena. Tehuu ara rae sira sangga reni deka-deka nggorok Dotan reu.” Basa boe ma Yusuf neu tungga neni kaꞌan nara reu, losa ana mete-nita sara numa Dotan. ");
INSERT INTO txq_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Tehuu neu Yusuf bei numa dook ka, te ara mete-ritan ena. Boe ma ara rala harak fo rae tao risan. ");
INSERT INTO txq_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","De esa nafada esa nae, “Ei mete dei. Malangga meꞌis mai ena! ");
INSERT INTO txq_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mai fo ita tao tisan leo. Basa naa ita nggari henin neni oe mata mates esa dale neu. Dei fo ita tafada papa tae, banda fuir raꞌa henin ena. Dei fo ita mete sudik ndia meꞌin nara raa dadi talo bee!” ");
INSERT INTO txq_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kaꞌan Ruben namanene nala naa, boe ma ana sangga dalak fo nae fee Yusuf nasoda. De ana kaꞌi-ore fadin nara nae, “Wee! Ita boso tao tisan! ");
INSERT INTO txq_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Malole lenak ita nggarin neni kada oe mata mates ia dale neu. Nai ia mamana nees, de ta hambu hatahori esa boe na bubuluk. Sadi boso feen nadaa.” Ana kokolak talo naa, nahuu ana nau nakamboꞌik Yusuf, fo nadenun fali neu ngga. ");
INSERT INTO txq_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Neu Yusuf losa kaꞌan nara, boe ma ara toꞌu ralan de ara ruꞌi heni badu malolen naa. ");
INSERT INTO txq_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Boe ma ara leꞌa rorosok kana, de ara timban maso neni oe matak dale neu. ");
INSERT INTO txq_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Basa boe ma ara fali reu raꞌa-rinu. Ara bei raꞌa-rinu, medak neu ma ara mete-rita hatahori nononggok esa mai. Hatahori nononggok naa, ontan nara fua reni bua-baꞌu neseseꞌok kara, ndia leo ai daa kaboo menik, bumbu-fanir, ma modo-aidoo mata-matak kara. Naa te hatahori nononggok Ismael hatahorin nara raa, ara ruma nggorok Gilead mai, rae reni doon seli reu, nai nusa Masir. ");
INSERT INTO txq_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Basa boe ma Yahuda nafada kaꞌa-fadin nara nae, “Wee! Malole lenak talo kada ia. Ita boso tao tisan. Nanalan hata? Leo mae talo bee oo, ita ta bisa tafuni tala ndia daan boe. ");
INSERT INTO txq_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Malole lenak ita teu seꞌon neu hatahori Ismael asa raa. Leo mae ita taon talo bee oo, ndia bei ita fadi bonggin boe. Huu naa de ita boso takahehedik kana!” Boe ma basa sara rala harak tungga ndia kokolan. ");
INSERT INTO txq_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ndaa no hatahori mana danggan nara raa laꞌok tungga naa, boe ma Yusuf kaꞌan nara leꞌan numa oe matak naa dale mai. De ara seꞌo henin neu hatahori Ismael asa raa, no belin doi fulak dua hulu. Basa boe ma ara roo Yusuf neni Masir neu. ");
INSERT INTO txq_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Neu ara seꞌo heni Yusuf naa, Ruben ta bubuluk. Huu naa de neu ana fali neni oe matak naa neu, ana nggengger nalan seli, nahuu Yusuf ta sana ena. De ana sisii nasida bualoꞌa-papaken manai ao-inan, nahuu dalen susa nalan seli. ");
INSERT INTO txq_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Boe ma ana fali neni fadin nara neu, de nae, “Awii! Kanak naa ta sana ena. Hatematak ia au muste tao hata bali?” ");
INSERT INTO txq_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Basa boe ma ara hala bibi hiek esa, de haꞌi rala Yusuf badu malolen naa, ara boron neni daak naa neu. ");
INSERT INTO txq_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Boe ma ara haꞌi rala badu mana lelemu daak naa, de renin fee neu sira aman, ma rafada rae, “Papa! Ai here mala badu ia! Papa mete sudik kana. Fama ko ia fadi Usu badun.” ");
INSERT INTO txq_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakob namumula basak ka badu naa, boe ma nalelan tutik ka. De ana naselu nae, “Awii! Ia memak au anang badun. Mitak mae banda fuir sii rakalulutun numa bee. Awii! Au anang maten ena!” ");
INSERT INTO txq_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Basa boe ma Yakob sii nakalulutu badun, de ana pake bua-loꞌa soka akinaak, nahuu ana susa nalan seli. Boe ma ana buꞌi nakarereu anan ta pake hahae. ");
INSERT INTO txq_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Basa ndia ana toun ma ana inan lalaꞌen mai kokoen, tehuu ta rala sana. Ana nae, “Taa! Au bisa susa losa mate, huu au ta bisa lilii kakanak esa ia.” Boe ma Yakob dalen susa nakandoo, nahuu ana nasaneda neu anan Yusuf mana matek naa ena. ");
INSERT INTO txq_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Neu Yakob bei susa-sona talo naa, tehuu hatahori danggan nara raa, losa Masir ena. Boe ma reu seꞌo Yusuf neu hatahori ina-huuk esa, nade Potifar. Ndia ia, komedan numa basa soldadu mana manea manek Masir uma manen mai. ");
INSERT INTO txq_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Basa boe ma Yahuda laꞌo ela kaꞌa-fadin nara, fo neu leo no nonoon Hira numa nggorok Adulam. ");
INSERT INTO txq_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Numa naa, hambu amak esa, hatahori Kanaꞌan, nade Sua. Yahuda nahiik no Sua ana feꞌon esa, boe ma dua sara rauma-loo. Basa naa, ana bonggi nala ana touk hida ratutungga. ");
INSERT INTO txq_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ana nomer kaesan, ara foin nade Er. ");
INSERT INTO txq_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Boe ma nomer kaduan, ara foin nade Onan. ");
INSERT INTO txq_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ma nomer katelun, nade Sela. Neu ara bonggi Sela, boe ma ara lali reni nggorok laen reu, nade Kesib. ");
INSERT INTO txq_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Neu ana nomer kaesan, Er, namoꞌo mamais ena, boe ma Yahuda neu natane feen ana feꞌok esa, nade Tamar. De dua sara rauma-loo. ");
INSERT INTO txq_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tehuu Er naa manggarau ndoos. Huu naa de Manetualain hukun nakamaten. De Er mate ta laꞌo ela anak. ");
INSERT INTO txq_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Basa boe ma Yahuda nadenu ana nomer kaduan nae, “Onan! O kaꞌam maten ena, tehuu anan taa. De hatematak ia, tungga hatahori lasik kara siꞌen, na, o muste lenggu-bara sinik neu o kaꞌam saon, mita fo o bonggi fee o kaꞌam tititi-nonosik.” ");
INSERT INTO txq_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan bubuluk hadak naa ena. Tehuu ana ta nau fee tititi-nonosik neu kaꞌan Er. De tungga-tungga ana sunggu-soro no Tamar, na, ana nggari heni ndia bibi-nggeen, mita fo Tamar hae bonggi nala. ");
INSERT INTO txq_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onan tatao-nonoꞌin naa, tao nala Manetualain namanasa nalan seli. Huu naa de Manetualain hukun nakamaten boe. ");
INSERT INTO txq_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Neu Yahuda mete-nita ana kaduan nara, mana sao Tamar mate sara ena, boe ma ana namataꞌu. Ana duꞌa nae, boso losak ana muri anan Sela sao nala Tamar bali, na, neu ko maten boe. Huu naa de ana neu nafada feto-feun Tamar nae, “Ana nggee! Malole lenak o fali muni o ina-amam muu leo. Naa fo au anang Sela namoꞌo ena dei, dei fo o fali mai ngga fo sao malan.” Boe ma Tamar fali neu ngga. ");
INSERT INTO txq_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Seli doo-doo boe ma mate Yahuda saon. De ana susa losa fai susa-sonak basa. Boe ma ana noke nonoon Hira, fo dua sara reni nggorok Timna reu. Numa naa, hatahorir rame-rame nggute bibi lombo bulun fo seꞌo. ");
INSERT INTO txq_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Boe ma hatahorir rafada Tamar rae, “O ari-amam neni Timna neu, fo koladu hatahorir fo nggute ndia bibi lombon nara bulun.” ");
INSERT INTO txq_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Lelek naa, Yahuda ana muri anan Sela moꞌok ena. Tehuu Tamar bubuluk ena nae, ndia ari-aman ta nau ndia sao nala Sela. Boe ma Tamar sangga dalak fo noke ndia haak. Boe ma ana olu heni ndia bua-loꞌa ina falun, de nggati pake bua-loꞌa malole. Ana pake tema popoi langgak fo lalaa nafuni langgan ma matan. Basa boe ma ana neu nanggatuuk neu nggorok Enaim lelesu mason, ndaa tetar no dalak mana neni Timna neu. ");
INSERT INTO txq_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Neu Yahuda laꞌok nesik lelesu maso nggorok naa, ana mete-nita inak esa. Ana nae hetuk ko inak naa ina petak, nahuu Tamar namasosoak no bua-loꞌan nara, ma ana lalaa nafuni matan bali. ");
INSERT INTO txq_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yahuda ta duꞌa nae inak naa, ndia feto-feun. De ana deka-deka neni inak naa neu, boe ma natane nae, “Wee! Mete ma au ua o, na, o moke baꞌu hata?” Tehuu Tamar naselu nae, “Neu! Numa kada papa hihiin mai.” ");
INSERT INTO txq_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yahuda noke naloe belin nae, “Mete ma au fee o bibi hiek esa, na, talo bee?” Boe ma Tamar bala nae, “Malole papa. Sadi papa fee au toꞌu tanda nemeheherek esa dei. Sudi losa faik hida, dei fo papa haitua bibi hiek naa mai.” ");
INSERT INTO txq_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Boe ma Yahuda natane bali nae, “Au fee o hata dadi neu tanda nemeheherek?” Tamar naselu nae, “Papa laꞌo ela cap fo papa bokoliik naa no talin. Ma laꞌo ela teteꞌe ai boe.” Yahuda namanene nala naa, boe ma ana laꞌo ela basa buas sara raa neun. De dua sara reu sunggu-soro rakabua leo. Basa boe ma Tamar fali neu ngga. Ana buka heni ndia bualoꞌa-papake malolen ma tema popoi langgak naa, de ana pake falik ndia bua-loꞌa ina falun. Ta bubuluk te Tamar nairu ena. ");
INSERT INTO txq_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ta dook ka boe ma Yahuda noke tulun ndia nonoon Hira nae, “O muni bibi hiek ia feen neni ina petak manai Enaim naa neu, fo haꞌi muni falik au bua-baꞌung fo ana toꞌuk.” Hira losa naa, de natane neu-mai, tehuu ta natonggo no inak naa. ");
INSERT INTO txq_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Boe ma ana natane hatahorir marai naa nae, “Wee! Ei mete-mita ina petak fo mana nasiꞌe nanggatuuk nai lelesu mason ia, do? Ana nai bee, ee?” Tehuu ara raselu rae, “Papa, nai ia ta hambu ina petak.” ");
INSERT INTO txq_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Dadi Hira fali neni Yahuda neu. Ana nafada nae, “Au ta atonggo ua inak naa. Au sangga-sangga, tehuu hatahorir marai naa rafada rae, nai mamanak naa ta hambu ina petak.” ");
INSERT INTO txq_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahuda naselu nae, “Ela bua-baꞌur raa ruma naa, fo ana soa sara leo. Sadi hatahorir ta rakamamaek ita. Huu au nau bae ena, tehuu ita ta tatonggo sana.” ");
INSERT INTO txq_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Seli bulak telu, boe ma hatahorir reu rafada Yahuda rae, “O feto-feun Tamar naa, ana tao aon, leo ina petak ia. Hatematak ia kairuk ena.” Yahuda namanene nala naa, boe ma namanasa nalan seli. De ana fee parenda neu hatahorir raa nae, “Miu leꞌa muni inak naa ia mai, fo hotu malaok kana!” ");
INSERT INTO txq_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Boe ma ara reu leꞌa Tamar, tehuu ana kalua heni cap ma teteꞌe ai naa. Boe ma ana nadenu sara reu rafada ndia ari-aman nae, “Papa, parisa sudik bua-baꞌur ia dei. Cap ma teteꞌe ai ia lamatuan ndia tao nairu au.” ");
INSERT INTO txq_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahuda mete-nita bua-baꞌur raa, boe ma ana nalela memak kasa, huu naa ndia enan. De ana nafada nae, “Memak! Inak naa ta sala. Au ndia sala. Ndia ndaa. Tungga hadak, na, au muste feen sao nala au anang Sela. Tehuu au ndia ta nau. Makamboꞌik kana leo!” Basa boe ma Yahuda ta sunggu-soro nakabua no Tamar bali. ");
INSERT INTO txq_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar fain fo nae bonggi losa ena, boe ma ana bonggi ana duak. ");
INSERT INTO txq_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Neu ana bonggi, kanak esa soro kalua liman. Boe ma ina mana makabobonggik paꞌa aba mbilas neu limak naa. Ana nae, “Ia ndia nomer kaesan.” ");
INSERT INTO txq_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tehuu kanak naa leꞌa falik liman dale neu. Boe ma toranoon ndia kalua nakahuluk. Ina mana makabobonggik kokolak mbali kanak naa nae, “Wee! O ia memak barakaik! Huu naa de o maseti makahuluk!” Boe ma ana foi kanak naa nade Peres (sosoa-ndandaan nae, ‘naseti kalua’). ");
INSERT INTO txq_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Basa dei de fadin neni paꞌa aba mbilas naa kalua. Ara foin nade Sera (sosoa-ndandaan nae, ‘mbila kara-karak’). ");
INSERT INTO txq_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","2","Fai maneuk kara, hatahori Ismael asa raa roo Yusuf neni Masir neu. Numa naa, hambu hatahori ina-huuk esa, nade Potifar. Ndia naa, komedan numa basa soldadu mana manea manek Masir uma manen mai. Basa boe ma Potifar hasa nala Yusuf numa hatahori mana danggan nara mai, fo dadi neu ndia ata-daton nai ndia uman. Numa naa, MANETUALAIN tulun Yusuf, de ana tao natetu basa ue-osan no neulauk. ");
INSERT INTO txq_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Yusuf malanggan mete-nita Yusuf ue-osan neulauk talo naa, boe ma ana bubuluk tebe nae, MANETUALAIN tulun neu Yusuf. ");
INSERT INTO txq_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Huu naa de malanggan naa hii Yusuf, ma namahere neun. Boe ma ana soꞌuk kana dadi mandor nai ndia uman. Ana oo fee Yusuf koladu ndia uman ma ndia pusakan nara lalaꞌen boe. ");
INSERT INTO txq_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Mulai numa Yusuf dadi mandor numa naa, Manetualain oo fee babaꞌe-babatik neu ndia malanggan, hatahori Masir naa boe. Ndia uma isin, ndia pusakan, ndia osi-lutun, ma ndia ue-osan basa-basan dadi no malole. ");
INSERT INTO txq_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Neu Potifar mete-nita Yusuf koladu basa ue-osar no malole, huu naa de ana ta duduꞌa hata-hata bali, nalela kada naꞌa-ninu a mesan. Lelek naa, Yusuf mata-aon lolen seli. ");
INSERT INTO txq_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ana leo numa naa bei ta dook ka, tehuu Potifar saon dalen tuda neun ena. Boe ma ana kokoe Yusuf fo sunggu-soro sama-sama noon. ");
INSERT INTO txq_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tehuu Yusuf ta nau. Boe ma ana naselu nae, “Boso talo naa, mama! Huu au malanggang Potifar fee au koasa ena fo koladu basa ndia ue-osan lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nai uma ia, ta hambu hatahori laen ena fo toꞌu koasa lena heni au. Huu malanggan fee au koladu basa-basa sara ena. Kada Mama mesa kana ndia au ta aena haak fo koladu. Talo bee de au bisa tao manggarauk talo naa. Naa oo laban Manetualain hihii-nanaun ena boe!” ");
INSERT INTO txq_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Leo mae talo naa, tehuu tungga faik malanggan naa saon, kada kokoen nakandooo. Tehuu Yusuf ta tao matak neun. ");
INSERT INTO txq_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Laꞌe esa, Yusuf maso neni uma dale neu, fo nae mete ndia ue-osan. Faik naa, ta hambu hatahori laen nai uma dale. ");
INSERT INTO txq_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Boe ma ndia malanggan saon mai, de toꞌu neu Yusuf badun, boe ma ana leꞌa nala Yusuf, de nae, “Mai leo! Hatematak ia ela kada ita dua ngga ena. Mai leo fo dua ngga teu sunggu-soro.” Tehuu Yusuf ta nau. Boe ma ana naleleꞌak, losa mboꞌi heni badun numa aon mai. De nalai dea neu. Tehuu inak naa bei toꞌu naherek badu naa. ");
INSERT INTO txq_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Neu Potifar saon mete-nita Yusuf nalai dea neu laꞌo ela badun ena, ");
INSERT INTO txq_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","boe ma ana nanggou hatahori mana maue-osar, de nafada nae, “Wee! Ei mai mete-mita ia dei! Bebeik kara ia, tou Ibrani naa, maso neni au kamang dale mai. Ana nau tao manggarauk neu au, tehuu au bolu ahere. Ia, ana laꞌo ela badun, de nalai dea neu. Au saong ia, ana neni hatahori sesesu taak ia, fo tao kada nekemamaek neu ita!” ");
INSERT INTO txq_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Boe ma Potifar saon toꞌu naherek badu naa losa Potifar fali. ");
INSERT INTO txq_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ndaa no saon fali, boe ma ana tui nae, “Kaꞌa, ee! Hatahori Ibrani fo kaꞌa nenin ia mai naa, bebeik kara ana maso neni au kamang dale neu ena, fo nau bode au! ");
INSERT INTO txq_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tehuu au bolu ahere fo anggou hatahorir. Boe ma ana kou nalai, laꞌo ela badun ia.” ");
INSERT INTO txq_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potifar namanene saon tui talo naa, boe ma ana namanasa nalan seli. ");
INSERT INTO txq_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","De ana nadenu hatahorir reu humu Yusuf. Boe ma ara teen neni manek buin dale neu. ");
INSERT INTO txq_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tehuu MANETUALAIN ta lilii neu Yusuf. Huu naa de MANETUALAIN tulun nakandoo neun, losa malangga bui naa oo hii nalan seli neu Yusuf boe. ");
INSERT INTO txq_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Boe ma ana namahere Yusuf. Huu naa de ana feen koasa fo koladu basa hatahori buir lalaꞌen, ma koladu basa ue-osar marai naa. ");
INSERT INTO txq_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","De malanggan langgan ta nareo koladu hata-hata nai bui naa dale bali ena. MANETUALAIN tulun nakandoo Yusuf, huu naa de basa ue-osar marai bui naa dadi malole. ");
INSERT INTO txq_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Nai bui naa dale, hambu hatahori dua dadi rita neu malangga mana maono-lalau nai manek Masir uma manen. Esa soa naono-lalau manek nininun. Esa bali soa naono-lalau manek rotin. Dua sara tao rasala manek. Huu naa de manek namanasa, losa ana tee sara reni bui dale reu. Dua sara rakabua rai mamanak esa ro Yusuf. ");
INSERT INTO txq_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Boe ma malangga bui naa fee parenda neu Yusuf, fo naono-lalau penggawe kaduak kara raa. Ara leo ruma naa losa teuk esa do dua. ");
INSERT INTO txq_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Leꞌodaek esa, penggawe kaduak kara raa rala meꞌi. Esa-esak no meꞌin. Ma meꞌis sara raa oo esa-esak no sosoa-ndandaan boe. ");
INSERT INTO txq_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Neu beꞌe-main, Yusuf mai, ma mete-nita dua sara matan nara, mana masaloek kara. ");
INSERT INTO txq_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Boe ma ana natane sara nae, “Tao hata de faik ia, ei dua ngga matam mara mana nggari henik kara talo naa?” ");
INSERT INTO txq_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Boe ma ara raselu rae, “Leꞌodaek ka ai mala meꞌi, tehuu ai ta bubuluk sosoa-ndandaan.” Basa boe ma Yusuf kokolak nae, “Ta hambu hatahori dae-bafok esa boe na fo bubuluk meꞌis sosoa-ndandaan, kada Manetualain mesa kana. Soba ei tui dei. Dei fo au sangga sudi sosoa-ndandaan nara numa Manetualain mai.” ");
INSERT INTO txq_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Basa boe ma hatahori mana maono-lalau manek nininun tui nae, “Talo ia. Nai au meꞌing dale, au mete-ita ai anggur huuk esa, ");
INSERT INTO txq_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ndanan telu. Ai huuk naa nadoo, nabuna, ma naboa nggingginuk kara, losa rambalatu neuk ka. ");
INSERT INTO txq_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Basa boe ma au mete-ita, au toꞌu manek nggalaa nininun. Boe ma au haꞌi ala anggor naa boan, de keꞌe oen neni manek nggalaan dale neu. Basa naa, au loon neu manek fo ninu.” ");
INSERT INTO txq_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusuf namanene nala naa, boe ma nafada nae, “Papa. Meꞌis naa sosoa-ndandaan talo ia: Ndanak kateluk kara raa sosoa-ndandaan ndia faik telu. ");
INSERT INTO txq_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nai faik telu ia dalen, neu ko manek kalua heni papa numa bui dale mai. Boe ma ana soꞌu falik papa, fo naono-lalau seluk ndia nininun sama leo fai bakahulun. ");
INSERT INTO txq_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mete ma papa ua-nalen talo naa ena, na, boso lilii au, ee! Mete ma papa sue au, na, tulun mafada manek, fo ana oo kalua heni au numa ia mai boe. ");
INSERT INTO txq_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Te mete ma tungga ndoon, na, ara haꞌi reni au no nekesetik numa hatahori Ibrani nggoron mai. Nai ia, au ta tao manggarauk hata-hata. Tehuu ta bubuluk te, ara tee au uni bui ia dale mai, sama leo au ia, hatahori manggarauk a mesan.” ");
INSERT INTO txq_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Hatahori mana maono-lalau roti naa namanene nala meꞌis naa sosoa-ndandaan neulauk talo naa, boe ma ana tui Yusuf nae, “Fadi, ee. Au oo ala meꞌi talo ia boe: Au suu lembaneu neketotodok telu nai au langgan. ");
INSERT INTO txq_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nai lembaneu manai seku lain, ara mbeda manek koki-baroon mata-matak kara. Tehuu mbuik kara mai, de bido heni basa koki-barook kara raa ruma au langgang lain mai.” ");
INSERT INTO txq_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusuf namanene nala naa, boe ma naselu nae, “Papa meꞌin sosoa-ndandaan talo ia: Lembaneu kateluk kara raa sosoa-ndandaan oo faik telu boe. ");
INSERT INTO txq_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nai faik telu ia dalen, mete te manek nadenu hatahorir mai tete heni papa langgan. Basa naa ara londa papa nenetun neu dii. Boe ma mbuik kara mai bido heni basa papa ao-mbaan.” ");
INSERT INTO txq_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Seli faik telu, ndaa no manek fai bobonggin, boe ma ana tao feta moꞌok fee basa ndia penggawen nara. Ana fee parenda fo reu kalua heni penggawe kaduak kara raa ruma bui dale mai. ");
INSERT INTO txq_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Basa boe ma ana soꞌu falik penggawe mana maono-lalau manek nininun naa, neu falik panggan bakahulun, fo ana naono-lalau seluk manek nininun. ");
INSERT INTO txq_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tehuu penggawe mana maono-lalau manek rotin naa, ara londa risan, ndaa tetar no Yusuf kokolan ena. ");
INSERT INTO txq_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tehuu penggawe mana maono-lalau nininuk naa, ta nasaneda Yusuf bali. Ana lilii heni Yusuf ena. ");
INSERT INTO txq_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Seli heni teuk dua, boe ma manek Masir nala meꞌi. Ana nala meꞌi nambariik numa lee Nil tatain. ");
INSERT INTO txq_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Medak neu ma, ana mete-nita sapi maao hitu. Roun nara manggadila moi-moik kara. Ara kalua numa lee naa mai, de raꞌa naꞌu numa naa. ");
INSERT INTO txq_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Basa boe ma hambu sapi laen hitu bali kalua numa lee naa mai. Aon nara nggofa-siik kara. Ara rambariik deka-deka ro sapi maaor raa. ");
INSERT INTO txq_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","De sapi nggofa-siik kahituk kara raa, kodo heni sapi maao kahituk kara raa. Boe ma manek afe kaiboik. ");
INSERT INTO txq_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ta dook ka boe ma ana sunggu seli bali. De ana nala meꞌi seluk. Ana mete-nita hade mbule neuk hitu, kalua numa hade huu neulauk esa mai. ");
INSERT INTO txq_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Basa de ana mete-nita bali, hade mbule langgak hitu mana malek kara laꞌe ani katobik ena. ");
INSERT INTO txq_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Boe ma basa hade mbule langgak kara raa, kodo heni hade mbule neuk kahituk kara raa. Basa boe ma manek afe. Dei de ana bubuluk, ndia nala meꞌi seluk ena bali. ");
INSERT INTO txq_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Neu huhua anan, boe ma manek duduꞌan ta namaneu. De ana fee parenda neu hatahorir fo reu tungga basa hatahori mana losi-laler ma hatahori malelak kara marai Masir. Basa de ana tui ndia meꞌin neu sara, tehuu ta hambu esa boe na bisa selu nala meꞌis naa sosoa-ndandaan. ");
INSERT INTO txq_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Basa boe ma penggawe mana maono-lalau manek nininun naa, bei fo nasaneda nala Yusuf. De ana neu nafada manek nae, “Papa manek, au muste manaku au salang. ");
INSERT INTO txq_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Fai bakahulun neu papa namanasa au ua au nonoong, de tee ai meni bui dale miu, ");
INSERT INTO txq_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","leꞌodaek esa, ai dua ngga mala meꞌi. Esa-esak no meꞌin, ma esa-esak no ndia sosoa-ndandaan. ");
INSERT INTO txq_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Numa bui naa dale oo, hambu hatahori Ibrani bei muri-soruk esa boe. Malangga bui soꞌu nalan dadi neu malangga mana maono-lalau numa bui dale. Ai tui ai meꞌin neun. Boe ma ana nafada meꞌis sara raa sosoa-ndandaan. ");
INSERT INTO txq_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Huu naa de papa manek soꞌu falik au. Tehuu au nonoong naa hambu hukun mates. Dadi basa naar, ndaa tetar sama leo hatahori Ibrani naa kokolan.” ");
INSERT INTO txq_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Manek namanene nala naa, boe ma ana nadenu hatahori lai-laik neu nala Yusuf numa bui. Basa boe ma Yusuf nafafaꞌu nalolole aon, ma nggati bualoꞌa-papaken fo neu nasare manek. ");
INSERT INTO txq_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ana losa, boe ma manek kokolak nae, “Taꞌek, ee! Au ala meꞌi, tehuu ta hambu hatahori esa boe na fo bisa selu meꞌis naa sosoa-ndandaan. Tehuu hambu hatahori nafada au nae, o bisa.” ");
INSERT INTO txq_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Boe ma Yusuf naselu nae, “Papa manek. Au oo ta ala hata-hata boe. Kada Manetualain mesa kana ndia bisa selu no tetuk meꞌis naa sosoa-ndandaan. Neu ko Ana nae nafada hata fo malole neu papa manek.” ");
INSERT INTO txq_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Basa boe ma manek tui nae, “Nai au meꞌing naa dale, au ambariik numa lee Nil tatain. ");
INSERT INTO txq_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Boe ma hambu sapi maao hitu, roun nara manggadila moi-moik kara. Ara kalua numa lee mai, de reu raꞌa naꞌu numa lee tatain. ");
INSERT INTO txq_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Basa boe ma sapi laen hitu mai bali. Tehuu sapir raa nggofa-siik kara. Nai dae Masir ia, au bei ta ita sapi nggofa-siik matak leo naak! ");
INSERT INTO txq_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tehuu au heran laꞌe esak kana! Huu medak neu ma, sapi nggofa-siik kahituk kara raa, kodo heni sapi maao kahituk kara raa. ");
INSERT INTO txq_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ara kodo heni sara, tehuu sapir raa nggofa-siik rakandoo. Basa boe ma au afe kaiboik. ");
INSERT INTO txq_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Basa de au sunggu seli bali, boe ma au ala meꞌi seluk. Au mete-ita hade mbule neuk hitu, kalua numa hade huu neulauk esa mai. ");
INSERT INTO txq_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Basa naa, au mete-ita seluk bali, hade mbule langgak hitu, mana malek kara laꞌe ani katobik ena. ");
INSERT INTO txq_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Boe ma basa hade mbule langgak kara raa, kodo heni hade mbule neuk kahituk kara raa. Basa naa au afe. Boe ma au tui meꞌis naa neu hatahori malelak kara. Tehuu ta hambu hatahori esa boe na fo bisa selu nala sosoa-ndandaan.” ");
INSERT INTO txq_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Boe ma Yusuf selu nae, “Papa manek. Meꞌis kaduak kara raa sosoa-ndandaan kada esak ka. Manetualain nafada memak papa manek hata fo Ana nae taon. ");
INSERT INTO txq_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Meꞌis naa sosoa-ndandaan talo ia: sapi maao kahituk kara raa, ma hade mbule neuk kahituk kara raa, ndia fai betes teuk hitu. Meꞌis sara raa sosoa-ndandaan esak ka. ");
INSERT INTO txq_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Boe ma sapi nggofa-siik kahituk kara raa, ma hade langgak mbule kahituk kara raa, ndia fai ndoe-laꞌas teuk hitu. ");
INSERT INTO txq_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","De Manetualain nafada memak ena hata fo Ana nae taon. Naa, sama leo hata fo bebeik kara ia au afadak ena. ");
INSERT INTO txq_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Neu ko ita hambu fai betes losa teuk hitu nai basa mamanak kara marai nusa Masir ia. ");
INSERT INTO txq_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Basa naa, dei fo ita hambu fai ndoe-laꞌas losa teuk hitu. Neu ko fai ndoe-laꞌas naa, ta hohoꞌak sudi selik kana! Losa ta hambu nanaꞌak nai nusak ia bali. Basa hatahorir ndoe-laꞌa ralan seli, losa ara ta bisa rasaneda fai betes naa ena. ");
INSERT INTO txq_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Papa manek nala meꞌi laꞌe dua naa sosoa-ndandaan nae, Manetualain henggenee memak ena. Ta dook ka bali, hata fo Ana henggeneek naa, mulai dadi ena. ");
INSERT INTO txq_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Huu naa de au fee au hahambung talo ia: Malole lenak papa manek sangga hatahori malelak esa, fo bisa nakaneni no malole. Basa naa soꞌu malan fo ana koladu natalolole nusak ia. ");
INSERT INTO txq_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Neu fai betes teuk hitu naa, malole lenak papa manek oo soꞌu hatahori laen bali boe, fo ara raduduru nanaꞌa lenan nara. Nanaꞌa lenan nara raa, ara baꞌe sara reu lima fo mbeda babaꞌek esa. ");
INSERT INTO txq_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ara muste tungga papa manek parendan, fo ara haꞌi hader numa basa nggorok kara marai Masir mai. Basa naa ara muste mbeda hader raa reu soka-poler fo ranea ratalolole sara. ");
INSERT INTO txq_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Fo neu ko fai ndoe-laꞌas teuk kahituk kara raa losa, na, ita bei taena nanaꞌak. No dalak naa, ta hambu hatahori mate nahuu ndoes.” ");
INSERT INTO txq_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Manek namanene Yusuf kokolak talo naa, boe ma manek no ndia penggawe moꞌon nara rakaheik tungga Yusuf hahambun naa. ");
INSERT INTO txq_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Boe ma manek kokolak nae, “Manetualain Dula-dalen koasan hambu memak nai Yusuf ena. Huu naa de ta bisa dadi, ai hambu hatahori laen bali fo lena heni ndia.” ");
INSERT INTO txq_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Boe ma manek kokolak no Yusuf nae, “Manetualain nafada basa dedeꞌak kara iar reu o ena. Hatematak ia, dei de ai bubuluk mae o ia malelak. Ma o malelan lena heni basa hatahorir. ");
INSERT INTO txq_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Huu naa de hatematak ia au soꞌuk o dadi neu au lima konang, fo o dadi malanggan nai au uma manen. Ma neu ko basa au rau-inggung nggara tungga o parendan. Kada au mesa ngga ndia lena heni o.” ");
INSERT INTO txq_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Basa boe ma manek olu heni ndia ndeli cap, de ana olun neni Yusuf lima kukun neu. De ana kokolak nae, “No dalak ia, au soꞌuk o dadi neu au lima konang nai basa nusa Masir ia.” Basa de ana olu badu naru tema bangganaꞌuk esa neu Yusuf, ma ana bokolii rante lilo mbilas neu boliin. ");
INSERT INTO txq_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Basa boe ma ana fee ndia kareta ndara nomer kaduan neu Yusuf fo ana saꞌe. Hambu hatahori nalaik nakahuluk nesik mata fo nanggou taa-taa nae, “Wee! Soi dalak! Fee hada-horomatak! Hambu hatahori ina-huuk nae nesik ia!” No dalak naa, manek soꞌuk Yusuf dadi neu ndia lima konan nai dae Masir ena. ");
INSERT INTO txq_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Basa boe ma manek kokolak no Yusuf nae, “Talo ia. O bubuluk memak ena, au ia manek. Au afada basa hatahorir marai Masir ena ae, mete ma o ta fee luas, na, ara ta bisa tao hata-hata.” ");
INSERT INTO txq_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Basa boe ma manek foi Yusuf nade Safnat Panea, tungga hatahori Masir naden. Ana oo fee Yusuf sao nala inak esa boe, nade Asnat. Yusuf ari-aman nade Potifera. Ana ndia koladu anggama nai kota On. No dalak naa, Yusuf dadi neu hatahori ina-huuk nai dae Masir. ");
INSERT INTO txq_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Neu ara soꞌuk Yusuf naa, teun nara 30. Basa boe ma ana laꞌo neu memete ndule basa mamanak kara marai dae Masir. ");
INSERT INTO txq_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nai fai betes teuk hitu naa dalen, basa osi-lutur nanaꞌan nara dadi ralan seli. ");
INSERT INTO txq_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Boe ma Yusuf naduduru nanaꞌa lenak kara raa, fo ana mbeda sara. Hambu hader ruma mamanak kara deka no kota bee, na, ana mbeda sara neu kota naa soka-polen. ");
INSERT INTO txq_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Losa hader buna-boan fo ana naduduru nalak kara raa noꞌun seli, sama leo sarakaek manai tasi tataik, losa ta hambu hatahori bisa uku-sudi nala sara ena. ");
INSERT INTO txq_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Neu fai ndoe-laꞌas bei ta losa, Yusuf saon Asnat bonggi nala ana touk dua ena. ");
INSERT INTO txq_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Boe ma Yusuf kokolak nae, “Manetualain tao nala au lilii heni au doidosong, neu au kalua numa au amang uman mai.” Huu naa de ana foi ana ulun nade Manase (fo dedeꞌa deꞌek naa liin sangga sama no dedeꞌa deꞌek laen, fo sosoa-ndandaan nae, ‘lilii’). ");
INSERT INTO txq_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Neu ana hambu ana kaduan, boe ma ana kokolak bali nae, “Au hambu doidosok noꞌuk ka numa mamanak ia ena. Tehuu Manetualain fee babaꞌe-babatik, ma au hambu anak numa ia ena.” Boe ma ana foi kanak naa nade, Efraim. ");
INSERT INTO txq_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Basa boe ma fai betes teu kahituk kara raa basa. ");
INSERT INTO txq_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Boe ma fai ndoe-laꞌas teuk hitu mulai mai, ndaa no hata fo fai bakahulun Yusuf nafada memak ena. Nai mamanak laen hatahorir ndoe-laꞌa ena. Tehuu nai basa mamanak kara marai Masir, hambu nanaꞌak. ");
INSERT INTO txq_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Doo-doo boe ma hatahori Masir asa mulai ndoe-laꞌa. De ara reu roke nanaꞌak numa manek. Boe ma manek nadenu sara reni Yusuf reu, fo tungga Yusuf parendan. ");
INSERT INTO txq_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Tehuu fai ndoe-laꞌas naa tamba ta hohoꞌak bali, losa basa mamanak kara marai Masir oo ndoe-laꞌa boe. Boe ma Yusuf mulai sai heni basa soka-poler fo seꞌo hader reu hatahori Masir asa. ");
INSERT INTO txq_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Basa boe ma hatahorir sudi ruma bee mai reu hasa nanaꞌak numa Masir, nahuu fai ndoe-laꞌas naa nemetaꞌuk ndoos. ");
INSERT INTO txq_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Lelek naa, papa Yakob namanene hatahorir rae hambu hade nai Masir, boe ma ana kokolak no anan nara nae, “Ana nggara ein, ee! Tao hata de ei nggua-nggua mamananauk kana talo kada naa! ");
INSERT INTO txq_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Au amanene ena rae, nai Masir hambu nanaꞌak. Malole lenak ei miu hasa nai naa dei, mita fo ita boso mate nahuu ndoes.” ");
INSERT INTO txq_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Basa boe ma Yusuf kaꞌa kasalahunun nara rahehere fo rae reu hasa nanaꞌak nai Masir. ");
INSERT INTO txq_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tehuu Yakob ta nau mboꞌi Yusuf fadi muri anan Benyamin fo neu sama-sama no sara. Ana duꞌa nae, “Boso losak kanak naa hambu sosoek bali!” ");
INSERT INTO txq_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Huu hatahorir sudi rai bee ramanene ena hambu nanaꞌak nai Masir, de hatahori noꞌuk ka reu hasa nai naa. Fai ndoe-laꞌas naa oo losa dae Kanaꞌan boe. De Yakob anan nara oo tungga reu hasa nai naa boe. ");
INSERT INTO txq_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Lelek naa, Yusuf dadi neu manek lima konan nai Masir ena. Mete ma hatahorir ruma sudi bee mai fo rae hasa hade, na, Yusuf ndia seꞌo neu sara. Huu naa de neu kaꞌan nara losa, ara reu sendek luu-langgan nara fee hada-horomatak neun, losa idu-matan nara laꞌe daer. ");
INSERT INTO txq_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Neu ana mete-nita sara, boe ma ana nalela memak kasa. Tehuu Yusuf tao aon sama leo hatahori Masir, huu naa de ara ta ralela sana. Boe ma ana natane sara no hara berak nae, “Eir ia, numa bee mai?” Boe ma raselu rae, “Air ia numa Kanaꞌan mai. Ai mai fo mae hasa nanaꞌak nai papa.” ");
INSERT INTO txq_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Boe ma Yusuf nasaneda ndia meꞌin fai bakahulun naa. De ana nakatataꞌuk kasa nae, “Au ta amahere! Ei basa ngga ia mana mamaꞌur. Ei mai fo sangga bubuluk dae Masir nemeninon, fo basa naa fali mai nggafu fee ai, hetu!” ");
INSERT INTO txq_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Tehuu ara raselu rae, “Taa, papa! Air ia kada papa hatahori neondan. Tebe-tebe ai mai kada mae hasa nanaꞌak. ");
INSERT INTO txq_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ai basa ngga ia amak esa. Ai ta mana mamaꞌur, papa! Ai hatahori neulauk kara.” ");
INSERT INTO txq_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Tehuu Yusuf kokolak tamba nahere haran bali nae, “Weeh! Kokola bafa rouk! Boso pepeko-leleko au! Memak tebe eir ia mana mamaꞌur. Ei mai fo mae sangga bubuluk nusak ia nemeninon nara!” ");
INSERT INTO txq_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Boe ma ara rasabara rae, “Taa, papa! Air ia kada papa hatahori neondan! Ai numa dae Kanaꞌan mai. Ai kaꞌa-fadik hatahori salahunu dua. Ai basa ngga amak esa. Ai fadi muri anan nahani no papa. Ma ai fadim esa ta sana ena.” ");
INSERT INTO txq_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Boe ma Yusuf naselu nasafali nae, “Taa! Hata fo au afadak bebeik kara ia tebe naa ena! Eir ia memak mana mamaꞌur. ");
INSERT INTO txq_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","De ei muste fee bukti dei, fo au bubuluk ei kokolam bebeik kara ia, memak tebe do taa. Au sumba-soo! Mete ma ei fadi muri anam naa ta neni ia mai, na, ei ta bisa laꞌo ela nusak ia! ");
INSERT INTO txq_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","De ei here mala hatahori esa fo neu nala fadi muri anak naa ia mai. Laen nara, au oka sara. Au nau mete-ita ei kokolak tebe do taa. Mete ma taa, na, memak tebe ei mana mamaꞌur.” ");
INSERT INTO txq_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Basa boe ma Yusuf nadenu oka sara ruma bui dale faik telu. ");
INSERT INTO txq_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Neu fai katelun, boe ma Yusuf neu kokolak no sara ruma bui nae, “Au ia, hatahori esa fo mana namataꞌu Manetualain. Ma au soa tungga Ndia hihii-nanaun. Au nau akamboꞌik ei, mita fo ei bisa masoda. Tehuu ei muste tao matetu dedeꞌak esa. ");
INSERT INTO txq_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Mete ma ei kokolak tungga ndoon, na, ei muste matudu bukti neu au. Dalan talo ia: au oka hatahori esa neu bui dale. Ei laen nara fali fo meni nanaꞌak fee ei nufanelum. Huu ara rahani ei fali meni nanaꞌak. ");
INSERT INTO txq_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Basa naa ei mia ei fadim naa mai, fo dadi neu bukti nae ei hatahori ndoos sara. Mita fo au boso hukun mates neu ei.” Ara ramanene rala naa, boe ma rakaheik. ");
INSERT INTO txq_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Basa boe ma esa kokolak no esa nae, “Hatematak ia ita hambu babalak numa ita sala-singgon ndia fai maneuk kara, fo ita taon neu ita fadin ena. Ita mete-tita ana doidoso nalan seli ena, losa ana noke tutulu-fafalik, tehuu ita ta tao matak neun. Huu naa de hatematak ia ita doidoso talo ia.” ");
INSERT INTO txq_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Boe ma Ruben fee nesenedak neu sara nae, “Fadi nggara ein! Fai bakahulun au kaꞌi ei ena, fo boso tao hata esa boe na neu kanak naa, hetu! Tehuu ei ta nau nenene au kokolang. Huu naa de hatematak ia ita lemba-tasaa tala Yusuf daan ena maa.” ");
INSERT INTO txq_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sira esa kola-kola mbali esa talo naa, tehuu ara ta bubuluk rae Yusuf oo nalela sira dedeꞌan boe. Huu neu Yusuf kokolak no sara, ana pote pake dedeꞌa Masir, dei fo mana kokolak salin neni dedeꞌa Ibrani neu. ");
INSERT INTO txq_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusuf namanene sira esa kola-kola no esa talo naa, boe ma ana nambadeik laꞌo ela sara, de neu buꞌi mesa kana numa mamana laen. Neu ana buꞌi basa ena, boe ma ana fali neni toranoon nara neu. De ana nadenu hatahori paꞌa Simeon numa toranoon nara matan. ");
INSERT INTO txq_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Basa boe ma Yusuf fee parenda neu ndia hatahorin nara, fo radai hader reni kaꞌan nara karon dale reu. Ma mbeda falik esa-esak doin neu sira karon bafon. Ana oo nadenu hatahorir raa fee sara lepa-nggees boe. De hatahorir raa tao tungga Yusuf parendan. ");
INSERT INTO txq_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Basa boe ma Yusuf kaꞌan nara fua basa karon hader raa reni sira keledein reu. De ara laꞌo fali reu sara. ");
INSERT INTO txq_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Neu ara hahae taak numa dalak, boe ma esa numa sira mai sefi ndia karon talin, fo nae fee keledein naꞌa. Tehuu ana mete-nita ndia doin numa hader bafon. ");
INSERT INTO txq_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ana nggengger nalan seli! Boe ma ana nanggou kaꞌan nara nae, “Awii! Ei mai mete sudik ia dei! Ara fee falik au doing nai au karong dale. De ita soe ia ena maa!” Ara mete-rita talo naa, boe ma tendak heni samanen nara, de ramataꞌu ralan seli. Boe ma ara kokolak rae, “Manetualain tao ita talo bee ia ena bali?” ");
INSERT INTO txq_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Basa boe ma ara laꞌo rakandoo losa Kanaꞌan, de ara tui sira aman basa hata fo dadi ena. ");
INSERT INTO txq_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Ara rafada rae, “Papa, ee! Manek Masir lima konan naa, ana sudi selik kana. Ndia kokolan barakai ndoos. Ana nakasasaꞌek salak neu ai nae, ai miu mamaꞌu ndia nusan. ");
INSERT INTO txq_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tehuu ai maselu mae, ‘Taa! Ai kokolak tungga kada ndoon. Air ia ta mana mamaꞌuk kara. ");
INSERT INTO txq_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ai hatahori neulauk kara. Ai basa ngga toranook salahunu dua. Ai ama bonggik esa. Tehuu esa ta sana ena, ma muri anak nahani no papa nai Kanaꞌan.’ ");
INSERT INTO txq_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Boe ma papa naa nae, ‘Au ae soba, eir ia ndoos sara do taa! Ei esa muste nahani nai ia. Ei laen fali, meni hader fee ei nufanelum mara, mita fo ara boso mate nahuu ndoes. ");
INSERT INTO txq_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ei muste mia ei fadim mai dei. No dalak naa, dei fo au bubuluk ei ta mana mamaꞌur, tehuu memak ei hatahori ndoos sara. Dei fo au bisa akamboꞌik ei toranoom fo au oka elak naa ena. Boe ma au fee luas fo ei bole sudi bee miu, nai nusak ia.’ ” ");
INSERT INTO txq_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ara tui rateꞌe, boe ma ara mulai sai sira karon nara isin. Medak neu ma, ara mete-rita esa-esak doin bei nai sira karon dale. Yakob mete-nita talo naa, boe ma ana no basa anan nara ramataꞌu ralan seli. ");
INSERT INTO txq_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Basa boe ma Yakob kokolak no sara nae, “Eir ia tao mamopo au anang nggara ena. Yusuf ta sana ena. Simeon oo leo naak boe. Hatematak ia oo ei mae mia Benyamin bali boe? Eir ia tebe-tebe kada mae tao doidoso au!” ");
INSERT INTO txq_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Boe ma Ruben kokolak mbali aman nae, “Papa, ee! Loo lima Benyamin neu au leo. Au ndia ataa. Au helu-bartaa, neu ko au ua falik kana neu papa. Tehuu mete ma taa, na, elan fo papa hala heni au ana tou kaduang nggara.” ");
INSERT INTO txq_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tehuu Yakob naselu falik kana nae, “Ta bisa! Ei ta bole mia Benyamin. Huu kaꞌan Yusuf maten ena. Hatematak ia ela kada mesa kana. Mete ma ana oo hambu sosoek nai dalak boe, na, ei tao susa-sonak tamba nai au langgang losa au konda uni rates uu.” ");
INSERT INTO txq_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Lelek naa, fai ndoe-laꞌas numa Kanaꞌan tamba sudi selik kana bali. ");
INSERT INTO txq_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yakob nufanelun nara raꞌa rabasa nanaꞌak kara fo fai maneuk kara ndia anan nara reni numa Masir mai. Boe ma ana nafada sara nae, “Ana nggara ein! Malole lenak ei fali meni Masir miu, fo hasa seluk fee ita hade bali dei.” ");
INSERT INTO txq_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tehuu Yahuda naselu nae, “Papa! Fai maneuk kara, manek Masir lima konan naa fee nesenedak nahere neu ai ena nae, ai ta bole matudu matan nara reu ndia, mete ma ai ta mia papa ana muri anan Benyamin! ");
INSERT INTO txq_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","De papa muste fee luas neu fadi Benyamin, fo tungga no ai dei. Dei fo ai nau miu hasa nanaꞌak fee papa. ");
INSERT INTO txq_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tehuu mete ma papa ta nau fee Benyamin neu, na, ai oo ta miu boe. Te hatahori Masir naa kokolak talo naa ena na!” ");
INSERT INTO txq_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Boe ma Yakob ndindia sara nae, “Tao hata de ei mafada hatahori naa ena mae, ei fadim bei ela esa bali! Ei sangga-sangga salak fo kada makasususak au!” ");
INSERT INTO txq_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Boe ma ara kokoe rae, “Papa, ee! Hatahori naa kada natane nakandook kana, fo nae sangga bubuluk ita ma basa ita nufanelun nara lalaꞌen. Ana natane nae, ‘Talo bee? Ei amam bei masodak, do? Ei bei ela fadi touk laen bali, do?’ De ai mae talo bee bali? Nau ta nau, ai kokolak tungga kada ndoon leo. Te see bubuluk nae, ana nau nadenu ai mia ai fadin naa neu?” ");
INSERT INTO txq_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","9","Boe ma Yahuda kokolak tamba bali nae, “Papa! Fee luas kakanak ia neu no ai leo. Au helu-bartaa, mete ma dadi hata esa neun, na, dei fo au ataa nggatin. Mete ma au ta ua falik kana no sodak neu papa, na, dei fo papa ndae salak naa neu au losa mate. De Papa fee luas kakanak ia leo, huu ai nau laꞌo ia ena. Malole lenak ai miu lai-laik fo ketuk boso mate nahuu ndoes. ");
INSERT INTO txq_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Soba mete ma ai ta mahani doo basa ia, na, ai miu-maik laꞌe dua ena.” ");
INSERT INTO txq_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Basa boe ma sira aman nae, “Mete ma talo naa, na, ei tao talo ia leo. Miu haꞌi mala ita daen isi-minan neulaun lenak. Ndia: fani oe, bumbu-fanir, ai daa kaboo menik, modo salaf, kanari ma fufue laen bali. Basa naa meni fee manek Masir lima konan naa, fo mae ia ita fefeen. ");
INSERT INTO txq_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ei oo meni doik baꞌu lena laꞌe dua boe, nahuu ei muste fee falik doik fo ei hambun numa ei karom dale, ndia fai maneuk kara raa. Fama te hatahorir raa ndia tao sala. ");
INSERT INTO txq_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ei oo mia ei fadim boe, basa naa fali lai-lai naa miu, ee! ");
INSERT INTO txq_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Au hule-haradoi fo Manetualain mana Koasa Mateꞌen, oꞌofe-fafae manek Masir lima konan naa, fo nameda kasian neu ei. Losa ana nau fee falik Benyamin no Simeon neu ei, fo ei basa ngga fali sama-sama. Tehuu mete ma au anang nggara muste mopo, elan fo au lemba-asaa susa-sonak naa nakandoo leo.” ");
INSERT INTO txq_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Basa boe ma ara reu rakabubua rala sira fefeen ma doik kara raa, fo reni sara Masir reu. Ara oo roo Benyamin boe. Ara losa naa, boe ma reu rasare Yusuf. ");
INSERT INTO txq_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Neu Yusuf mete-nita Benyamin no kaꞌan nara, boe ma ana nadenu ndia malangga mana maono-lalaun nae, “Mia hatahorir ia reni au umang reu! Basa naa miu tati sapi esa fo dode-nasu malada-malada. Huu neu ko ara raꞌa nai ledo tetuk ia ro au.” ");
INSERT INTO txq_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Boe ma malangga mana maono-lalaun naa, tao tungga Yusuf parendan. De ana noo sara reni Yusuf uman reu. ");
INSERT INTO txq_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Neu ara laꞌo reni Yusuf uman reu, kaꞌan nara ramataꞌu ralan seli. Neu ara bei laꞌok numa dalak, esa kokolak no esa nae, “Tao hata de ana nadenu ro ita ia mai? Fama te ana nae nakasususak ita, nahuu doik fo ara fee falik kasa numa ita karon nara dale ndia fai maneuk naa. Ara kedi rae ro ita ia mai, fo medak neu ma ara humu rala ita, fo tao ita dadi neu ndia ata-daton. Basa boe ma ara leꞌa rala basa ita keledein nara.” ");
INSERT INTO txq_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Huu naa de neu ara sangga deka-deka Yusuf uman ena, boe ma ara kokolak ro malangga mana maono-lalaun naa rae, ");
INSERT INTO txq_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Papa! Ai moke ambon, huu fai maneuk kara ai mai hasa mita nanaꞌak numa ia ena. ");
INSERT INTO txq_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","De neu ai fali meni ai nggoron miu, ai hahae numa dalak fo mae sunggu. Boe ma ai buka ai karon nara fo mae fee bandar raꞌa. Ta bubuluk te ai hambu falik ai esa-esak doi hasa haden nara ruma karon dale. Ai ta bubuluk see ndia tao sara reu naa! Tehuu hatematak ia ai meni falik basa doik kara raa ena. De papa boso mamanasa, ee! Mita fo papa bubuluk, hatematak ia ai oo meni doik laen bali, fo mae hasa nanaꞌa beuk.” ");
INSERT INTO txq_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Boe ma malangga mana maono-lalau naa naselu nae, “Ei matu-matu a leo! Hae mamataꞌu! Fama te ei Lamatuam ndia fee babaꞌe-babatik neu ei nai ei karom mara naa dale. Fai maneuk naa, au simbo ala basa ei doim mara ena. Ei ta mahuta ena.” Basa boe ma ana mboꞌi falik Simeon neni sira neu. ");
INSERT INTO txq_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Boe ma basa sara maso reni Yusuf uman dale reu. De malangga mana maono-lalau naa fee sara oe fo ara safe ralao ein nara. Ana oo fee sira keledein nara raꞌa boe. ");
INSERT INTO txq_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Basa boe ma ana nafada nae, “Dei fo ei miꞌa ledo tetuk sama-sama mia malanggan.” Neu ara bei rahani Yusuf mamain, ara raole memak sira fefeen. ");
INSERT INTO txq_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Neu Yusuf losa, boe ma basa sara sendek luu-langgan nara reu matan. De loo sira fefeen nara neun. ");
INSERT INTO txq_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Boe ma Yusuf natane sara nae, “Talo bee? Ei basa ngga sodak kara, do? Ei amam fo lasik naa ena talo bee? Ana oo sodak boe, do?” ");
INSERT INTO txq_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ara raselu rae, “Papa ata lasin, fo ai ama bonggin naa bei sodak.” Boe ma ara kaur langgan nara fo fee hada-horomatak neun bali. ");
INSERT INTO txq_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Basa boe ma Yusuf leleuk ndule sara, losa ana mete-nita ndia fadin Benyamin. Sira dua sara ina esa ma ama esa. Boe ma ana nae, “Ooo! Ndia ena, ei fadi muri anam fo ei tuik fai maneuk kara raa ena, do?” Boe ma ana kokolak no Benyamin nae, “Ana, nggee! Au hule-haradoi fo Manetualain fee babaꞌe-babatik noꞌuk ka neu o.” ");
INSERT INTO txq_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusuf mete-nita Benyamin naa, boe ma dalen hii nalan seli fo nahindan doo basa ia naa nae mboꞌa dea mai ena. Te ana sue nalan seli neu fadin na. Ana ta bisa nakataka nala dalen ena. Boe ma ana lai-laik laꞌo ela sara, fo maso neni kaman dale neu. De ana buꞌi nasakekedun numa naa. ");
INSERT INTO txq_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ana buꞌi nateꞌe, boe ma neu narou oe. Ana tao natetea dalen, de dea neu natonggo no sara. Boe ma ana nadenu mana mafafaꞌu uman nara reu rambembeda mei nanaꞌak. ");
INSERT INTO txq_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ara fee Yusuf mesa kana naꞌa feꞌe neu mei esa. Ndia kaꞌa-fadin nara raꞌa reu mei laen. Ndia penggawe hatahori Masir asa oo raꞌa feꞌe reu mei laen boe, nahuu ara nunute mete ma raꞌa rakabua ro hatahori Ibranir. ");
INSERT INTO txq_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Malangga mana maono-lalau naa tao talo naa ena, fo fee kaꞌa-fadin nara ranggatuuk rasasare aok ro Yusuf. Ana fee sara esa-esak ranggatuuk tungga sira teun nara, mulai numa kaꞌa uluk losa fadik mateꞌen. Neu ara mete-rita sira nenggetuun nara talo naa, boe ma ara heran. ");
INSERT INTO txq_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Basa de Yusuf koladu fo ndia mana mafafaꞌu uman nara haꞌi fee kaꞌa-fadin nara nanaꞌak numa ndia mein mai. Basa sara simbo koko babaꞌuk. Tehuu ara tao Benyamin enan, baꞌu lena laꞌe lima numa ndia kaꞌan nara mai. Boe ma basa sara raꞌa-rinu losa poꞌon nara rakabete ralan seli. ");
INSERT INTO txq_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ara raꞌa-rinu basa, boe ma Yusuf kutu-kutu no ndia malangga mana maono-lalaun nae, “O muu madai hader reni hatahorir ia esa-esak karon dale reu, losa sofe sara. Basa naa o tao seluk doin nara reni sira esa-esak karon dale reu. ");
INSERT INTO txq_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Boe ma o haꞌi mala au moo lilo fulang, fo taon neni kana muri anak karon dale neu.” De neu tao tungga Yusuf parendan. ");
INSERT INTO txq_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Neu beꞌe-mai huhua anan, boe ma Yusuf mboꞌi sara fo fali reni nanaꞌak kara ro sira keledein. ");
INSERT INTO txq_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ara laꞌo bei ta dook ka numa kota mai, boe ma Yusuf nafada ndia malangga mana maono-lalaun nae, “O malaik muu husi tungga hatahorir raa lai-laik. Mete ma husi hambu sara ena, na, o mafada talo ia, ‘Tao hata de ei pepeko tou lasik? De ei bala ndia neulaun no tatao-nonoꞌi manggarauk talo ia! ");
INSERT INTO txq_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Tao hata de ei dalem mara malak mamanaꞌo meni tou lasik moo lilo fulan? Ei ta bubuluk, do? Naa, ta kada tou lasik moo nininun! Ana oo pake mook naa fo tiro hatahori ua-nalen boe. Te mook naa neni malelak na! Ei tatao-nonoꞌim mara ia memak manggarauk sudi selik kana!’ ” ");
INSERT INTO txq_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Basa boe ma malangga mana maono-lalau naa husi neu losa hambu sara. Boe ma nafada sara tungga Yusuf kokolan bebeik kara. ");
INSERT INTO txq_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Boe ma ara rasabara rae, “Papa duduꞌan talo bee ia? Ai sumba-soo. Ta bisa dadi ai tao manggarauk talo naa! ");
INSERT INTO txq_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Papa mesa kana bubuluk ena, hetu? Doik kara raa maruma ai karon nara dale ndia fai maneuk naa, ai fee falik kasa reu papa ena, hetu? Dadi talo bee de ai bei malak mamanaꞌo malanggan lilo fulan do lilo mbilan numa uman mai! Ta bisa dadi! ");
INSERT INTO txq_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Papa parisa leo! Hambu buas naa nai see karon dale, na, hukun mates neun leo! Ma elan fo ai laen nara iar, dadi neu papa ata-daton leo.” ");
INSERT INTO txq_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Basa de malangga mana maono-lalau naa nae, “Taa! Talo kada ia leo. Mete ma hambu mook naa nai see, na, ana dadi neu au kuling. Laen nara bole fali.” ");
INSERT INTO txq_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Boe ma ara rakonda lai-laik karon nara raa. De ara buka memak kasa. ");
INSERT INTO txq_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Malangga mana maono-lalau naa parisa no lutuk karon nara raa esa-esak, mulai numa kaꞌa uluk karon mai, losa fadi murik enan. Boe ma ana mete-nita moo lilo fulak naa numa Benyamin karon dale. ");
INSERT INTO txq_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Benyamin kaꞌan nara mete-rita talo naa, boe ma dalen nara rakalulutu ralan seli. Ara fua falik karon nara raa reni keledei lain reu, de ara lenggu fali reni kota reu. ");
INSERT INTO txq_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Neu ara fali losa Yusuf uman, ana bei numa naa. Boe ma ara sendek luu-langgan nara reu matan. ");
INSERT INTO txq_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","De Yusuf mboka nasaparak kasa nae, “Weeh! Tao hata de ei tao au talo ia! Ei ta bubuluk mae hatahori ina-huuk leo au ia, bisa pake malelak fo sangga bubuluk hatahori nemeninon?” ");
INSERT INTO txq_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Boe ma Yahuda naselu nae, “Awii! Manetualain lufa nakaholak ai sala-singgon nara ena, de ai mae kokolak hata bali, papa? Ai mae masalaꞌe ai aon nara talo bee bali. Mete ma papa nae kaꞌi ela ai fadi muri anan ia, na, malole lenak papa kaꞌi ela ai basa ngga. Haꞌi mala ai basa ngga, dadi neu papa ata-daton leo.” ");
INSERT INTO txq_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Tehuu Yusuf naselu nae, “Taa! Hambu mook naa nai see, na, ana ndia dadi neu au kuling! Ei laen nara akamboꞌik kasa. Fali meni ei amam miu leo!” ");
INSERT INTO txq_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Basa boe ma Yahuda neu deka-deka no Yusuf, de ana kokolak nae, “Papa! Au bubuluk papa koasan sama leo manek ia. Huu naa de boso mamanasa au dei. Au oke luas fo kokolak faa ua papa. ");
INSERT INTO txq_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Afik ka papa natane ai ena mae, ‘Ei amam ma fadim esa bei elan, do?’ ");
INSERT INTO txq_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","De ai maselu mae, ‘Ai aman lasik ena. Ma hambu ai fadi muri anan boe. Neu bonggin, ai aman lasik ena. Fadi muri anak naa, hambu kaꞌa tora ndunun esa, tehuu maten ena. Sira dua sara inan oo maten ena boe. De hatematak ia, ela kada fadi muri anak mesa kana. Huu naa de ai aman sue nalan seli neun.’ ");
INSERT INTO txq_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Boe ma papa nadenu ai meni ai fadin naa neni ia mai, fo papa bisa mete-nitan. ");
INSERT INTO txq_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","De ai maselu mae, kanak naa ta bisa laꞌo ela aman. Mete ma ana laꞌo elan, na, ai aman maten naa ena. ");
INSERT INTO txq_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Boe ma papa naselu nae, ‘Mete ma ei ta meni ei fadi muri anam naa, na, ei ta bisa mete-mita au matang ena.’ ");
INSERT INTO txq_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Basa boe ma ai fali. Losa ai aman, boe ma ai mafada basa papa kokolan nara naa lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Doo-doo boe ma ai nanaꞌan nara basa ena. De ai aman nadenu ai fali meni Masir mai, fo hasa nanaꞌak bali. ");
INSERT INTO txq_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tehuu ai maselu mae, ‘Papa, ee! Ai ta bisa naa miu ena. Huu manek lima konan naa nafada ena nae, mete ma ai ta mia ai fadi muri anan, na, ai ta bisa mete-mita ndia matan. De ai fadi muri anan muste tungga neu dei, dei fo ai miu.’ ");
INSERT INTO txq_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Basa naa ai aman kokolak bali nae, ‘Ei bubuluk ena, hetu? Au saong Rahel naa, anan kada duak ka. ");
INSERT INTO txq_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ana uluk ta sana ena. Mete te banda fuir raꞌa henin ena. Huu naa de losa hatematak ia, au ta mete-ita sana ena. ");
INSERT INTO txq_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Mete ma ei haꞌi meni kana muri anak ia numa au mai bali, boe ma ana hambu sosoek, na, ei tao tamba makasususak au, fo lasik ia ena, de au mate leo.’ ");
INSERT INTO txq_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Talo ia, papa. Mete ma au fali uni au amang uu, ma ta ua falik fadi muri anak ia, neu ko ai aman maten naa ena. Te ndia samanen nakaesa no kanak ia na. Ana nambalasi nalan seli ena, de mete ma ai tao tamba makasususak kana, neu ko maten. ");
INSERT INTO txq_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Lenak bali au helu-bartaa ua au amang ena ae, au ndia ataa kanak ia. Au helu-bartaa ua au amang mete ma au ta ua fali kanak ia neu ndia, na, dei fo au ataa salak naa losa mate. ");
INSERT INTO txq_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","De au oke talo ia, papa: Elan fo au mesa ngga ndia ahani ia nggatin, dadi neu papa ata-daton. Elan fo ana fali no kaꞌan nara. ");
INSERT INTO txq_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mete ma kanak ia ta tungga, na, au oo ta bisa fali boe. Au ta akatataka ala mete-ita ai aman doidoso losa mate.” ");
INSERT INTO txq_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusuf namanene nala naa, boe ma dalen noe losa ta bisa nakataka nala nai ndia penggawe nara matan bali. Huu naa de ana nadenu sara dea reu, fo ela kada ndia mesa kana no ndia kaꞌa-fadin nara. No dalak naa, ana bisa manaku aon nae, ndia naa, see. ");
INSERT INTO txq_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","De basa penggawer raa dea reu, boe ma ana buꞌi nakarereu nahere, losa basa hatahori Masir asa marai kama naa dea ramanene. Ma hatahorir marai manek uman oo ramanene boe. ");
INSERT INTO txq_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Basa boe ma Yusuf nafada no ledo-ledo neu ndia toranoon nara nae, “Kaꞌa-fadi nggara ein, ee! Au ia Yusuf, ei toranoom! Memak papa bei sodak, hetu?” Kaꞌa-fadin nara ramanene rala naa, boe ma ramataꞌu ralan seli, losa ara unggu ta kukudu ena. ");
INSERT INTO txq_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Boe ma Yusuf nggaper asa nae, “Basa ngga deka-deka mai mata ia dei.” De ara reu deka ro Yusuf. Boe ma ana kokolak seluk nae, “Au ia Yusuf, fo fai bakahulun ei seꞌo henin neni Masir neu. ");
INSERT INTO txq_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Memak ei seꞌo heni au ena. Tehuu boso mamataꞌu, ma boso mareresi fo esa ndae salak neu esa bali. Naa te Manetualain mesa kana ndia no au ia mai, akahuluk numa ei mai. No dalak naa, Ana pake au fo tao asoi-asoda hatahori noꞌuk ka, mita fo ara boso mate nahuu ndoes. ");
INSERT INTO txq_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Hatematak ia, fai ndoe-laꞌas bei fo dadi teuk dua. Bei ela teuk lima bali. Lelek naa, hatahori ta mbomboꞌa-kakali dae, ta sele-tande, ma ta hambu dae isi-minan hata-hata. ");
INSERT INTO txq_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","No dalak fo ita ta bubuluk sosoa-ndandaan ia, Manetualain neni au akahuluk numa ei mai. Mita fo ketuk numa ei mai, ma ei umbu-anam mara ndia rasoda. ");
INSERT INTO txq_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Dadi ndondoon ndia, ta huu no ei tataom mara de au losa ia, tehuu ia Manetualain nanaen. Ana ndia naen de au dadi uu manek lima konan nai Masir. Boe ma au dadi malangga mana maono-lalau nai manek uma manen. Ta hambu hatahori laen moꞌon lena heni au. ");
INSERT INTO txq_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","De hatematak ia, ei fali lai-laik leo, fo meni au harang neu papa mae leo ia, ‘Papa anan Yusuf naa, bei masodak! Ana dadi neu hatahori ina-huuk nai Masir ena. Ana oo noke papa neni Masir neu lai-laik boe. ");
INSERT INTO txq_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Dei fo papa bole leo nai nusa Gosen deka no ndia. Mamanak naa neulauk ma loak, de papa bisa nakaboi basa papa bibi hien, bibi lombon, ma sapin nara lalaꞌen. Boe ma ana oo noke fo papa neu no umbu-anan, uma isin, ma basa pusakan nara lalaꞌen fo leo rakandoo nai naa boe. ");
INSERT INTO txq_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mete ma papa nai Gosen, na, ana bisa nanea papa nai naa. Huu fai ndoe-laꞌas bei ela teuk lima bali. De dei fo ana koladu fo papa, nufaneluk kara, ma basa papa banda-manun nara lalaꞌen ta toꞌa kuran hata esa boe na.’ ” ");
INSERT INTO txq_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusuf nafada basa, boe ma ana kokolak bali nae, “Hatematak ia, ei mete-mita no ei matam ena, hetu? Ma o Benyamin. Au ia, memak Yusuf. ");
INSERT INTO txq_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","De mafada ita aman mae, au koasang nai Masir ia moꞌon seli. Ma tui papa basa hata fo ei mete-mitan ena boe. Basa naa ei mia papa lai-laik neni ia mai leo!” ");
INSERT INTO txq_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Boe ma ana holu nala fadin Benyamin, de dua sara buꞌi. ");
INSERT INTO txq_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ana oo holu nala kaꞌan nara boe, de ana idu esa-esak. Basa naa, dei de ara mulai kokolak roon. ");
INSERT INTO txq_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Basa naa, neu manek no ndia penggawen nara ramanene Yusuf kaꞌa-fadin nara mai, boe ma basa sara ramahoko. ");
INSERT INTO txq_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Basa boe ma manek kokolak noon nae, “Yusuf, ee! Mafada o kaꞌa-fadim mara, fo ara fua rala hader reu sira keledein nara lain, fo reni sara Kanaꞌan reu. ");
INSERT INTO txq_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Basa naa madenu sara ro o amam no basa nufanelum mara lalaꞌen, fo ara lali reni ia mai leo. Dei fo au fee sara dae fo neulaun lenak nai Masir, fo ara bisa leo-laꞌo neu naa, ma ara raꞌa numa dae naa isi-minan mai. ");
INSERT INTO txq_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Boe ma mafada sara, fo ara reni memak kareta hida numa ia neu, fo ara fua kakana anar ma o amam. ");
INSERT INTO txq_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Boso duduꞌa pusaka fo ara ta bisa koꞌo-baꞌu reni sara raa, huu basa hata fo neulauk lenak nai Masir ia, dei fo ara soa sara.” ");
INSERT INTO txq_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yusuf namanene nala naa, boe ma ana fee sara kareta hida, ma lepa-nggees nai dalak, tungga manek parendan. Ma ndia kaꞌa-fadin nara oo raole fo fali reu sara tungga manek parendan boe. ");
INSERT INTO txq_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yusuf oo fee sara esa-esak bua-loꞌa beuk pasan esa boe. Tehuu ana fee Benyamin doi fulak 300, no bua-loꞌa beuk pasan lima. ");
INSERT INTO txq_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ana oo haitua fee aman bua-baꞌu malole mateꞌen numa Masir mai boe, de ara fua sara reu keledei mane salahunu. Ana fee tamba seluk hade, roti, ma nanaꞌak mata-matak kara, reu keledei ina salahunu lain, fo dadi reu sira lepa-nggeen, neu ara fali reni Masir mai. ");
INSERT INTO txq_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Basa boe ma ana fee sara fali, ma ana fee nesenedak nae, “Ei boso mareresi nai dalak, ee!” ");
INSERT INTO txq_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Basa boe ma ara fali reni sira aman nai Kanaꞌan reu. ");
INSERT INTO txq_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ara losa naa, boe ma rafada sira aman rae, “Papa, ee! Papa anan Yusuf bei masodak. Ana dadi hatahori ina-huuk ena, de ana parenda nai Masir!” Neu Yakob namanene nala naa, boe ma ana namananauk kana, ma ana ta namahere sira tutuin. ");
INSERT INTO txq_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tehuu neu ara rafada basa Yusuf kokolan, ma ana mete-nita karetar fo Yusuf haituak kara fo sangga fua reni ndia neni Masir neu, dei de ana mulai namahere. ");
INSERT INTO txq_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Boe ma ana kokolak nae, “Awii! Au anang bei masodak, ee! Talo naa dei fo au amahoko! Au muste uu tiron dei, dei fo au bisa mate no lino-lendek.” ");
INSERT INTO txq_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Basa boe ma Yakob asa rafafaꞌu bua-baꞌun nara, de ara laꞌo ela Kanaꞌan. Losa nggorok Barseba, boe ma ana tunu-hala banda fo tao tunu-hotuk fee Manetualain, fo ndia aman Isak nakaluku-nakatele neun numa fai bakahulun mai. ");
INSERT INTO txq_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Leꞌodaek esa boe ma ana nala meꞌi. Nai meꞌis dale, ana namanene Manetualain nanggoun nae, “Yakob! O mambadeik dei, fo nenene!” Boe ma ana naselu nae, “Tao hata, Manetualain!” ");
INSERT INTO txq_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Boe ma Manetualain nae, “Au ia Manetualain fo o amam nakaluku-nakatele neun numa fai bakahulun mai ena. O boso mamataꞌu muni Masir muu, huu neu ko Au tao o tititi-nonosim dadi neu hatahori nusa moꞌok nai naa. ");
INSERT INTO txq_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Neu ko Au uni Masir uu sama-sama ua o. Ma neu ko Au oo ua falik o tititi-nonosim mara reni dae Kanaꞌan mai boe. Neu ko neu faik fo o mate, o anam Yusuf hambu o ani hahaem.” ");
INSERT INTO txq_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Basa boe ma Yakob no anan nara laꞌo ela nggoro Barseba. Ara fua Yakob no sao-anan nara reu karetar fo manek Masir haituak ena. ");
INSERT INTO txq_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Boe ma ara haꞌi reni basa sira pusakan nara, ma basa banda-manun nara fo sira ue rala numa dae Kanaꞌan ena. Yakob no ndia ana toun, ana inan, ma basa umbu-usin nara lalaꞌen laꞌo reni Masir reu. ");
INSERT INTO txq_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakob nufanelun nara fo mana tungga lali reni Masir reu, sira: Ruben, ana uluk. ");
INSERT INTO txq_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Anan nara sira: Henok, Palu, Hesron, ma Karmi. ");
INSERT INTO txq_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon, no anan nara, sira: Yemuel, Yamin, Ohad, Yakin, ma Sohar. Ma Saul, ndia anan numa saon, ina Kanaꞌan mai. ");
INSERT INTO txq_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi no anan nara, sira: Gerson, Kehat, ma Merari. ");
INSERT INTO txq_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahuda no anan nara, sira: Sela, Peres, ma Sera. Yahuda anan laen Er, ma Onan, mate sara ruma Kanaꞌan ena. Ana oo neni Peres anan nara boe, sira: Hesron ma Hamul. ");
INSERT INTO txq_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaskar no anan nara, sira: Tola, Pua, Ayub, ma Simron. ");
INSERT INTO txq_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon no anan nara, sira: Sered, Elon, ma Yahleel. ");
INSERT INTO txq_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Sira basa sara raa, Yakob no saon Lea ana bonggin nara, neu ara leo numa Mesopotamia. Hambu sira ana inan esa bali, nade Dina. De Yakob no Lea tititi-nonosin nara basa sara, sira hatahori 33. ");
INSERT INTO txq_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Boe ma hambu anan nara ruma saon laen mai, sira: Gad, no anan nara: Siflon, Hagi, Suni, Esbon, Eri, Arodi ma Areli. ");
INSERT INTO txq_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser no anan nara, sira: Yimna, Yiswa, Yiswi, Beria, ma sira feton, nade Sera. Hambu Beria anan nara boe: Heber no Malkiel. ");
INSERT INTO txq_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Sira basa sara, hatahori 16, fo Yakob no ndia saon Silpa umbu-anan nara. Silpa naa, ina mana malalau uma-loo fo Laban feen neu ana inan Lea, Yakob sao ulun. ");
INSERT INTO txq_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Boe ma hambu Yakob saon laen bali, nade Rahel. Ana bonggi nala anak dua, sira: Yusuf no Benyamin. ");
INSERT INTO txq_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Lelek naa, Yusuf sao nala Asnat numa Masir ena. Ndia ari-aman naa, malangga anggama numa Kota On. Ndia naden Potifera. Yusuf no Asnat anan nara, sira: Efraim ma Manase. ");
INSERT INTO txq_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin oo tungga Masir neu no anan nara boe, sira: Bela, Beker, Asibel, Gera, Naaman, Ehi, Ros, Mupim, Hupim, ma Ared. ");
INSERT INTO txq_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","De Yakob no saon Rahel tititi-nonosin naa, hambu hatahori 14. ");
INSERT INTO txq_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Basa naa, bei hambu Yakob saon esa bali, nade Bilha. Dua sara anan nara, sira: Dan no Naftali. Dan anan, nade Husim. ");
INSERT INTO txq_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali no anan nara, sira: Yasel, Guni, Yeser, ma Silem. ");
INSERT INTO txq_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yakob no saon Bilha tititi-nonosin naa, hambu hatahori 7. Bilha naa, Rahel ina mana malalau uma-loon fo ana hambun numa ndia papan Laban mai. ");
INSERT INTO txq_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","De basa Yakob tititi-nonosin nara mana reni Masir reu, hambu hatahori 66. Bei ta reke no ndia mane-feun ma feto-feun nara. ");
INSERT INTO txq_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Tamba no Yusuf anan nara fo bonggi sara ruma Masir, sira dua. De Yakob no nufanelun nara fo mana leo numa Masir, basa sara hatahori 70. ");
INSERT INTO txq_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Neu ara sangga deka Masir ena, Yakob nadenu anan Yahuda laꞌok nakahuluk, fo neu noke Yusuf mai natonggo noon nai Gosen. Neu ara losa Gosen ena, ");
INSERT INTO txq_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","boe ma Yusuf saꞌe karetan, fo neu natonggo no aman numa naa. Neu ara ratonggo, boe ma Yusuf holu nala aman, de ana buꞌi nala doon seli. ");
INSERT INTO txq_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","De Yakob kokolak nae, “Anang Yusuf, ee! Hatematak ia au mesa ngga mete-ita o ena. Ma au bubuluk ena o bei masodak. Huu naa de leo mae au mate hatematak ia oo malole boe.” ");
INSERT INTO txq_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Basa boe ma Yusuf nafada basa ndia kaꞌa-fadin nara nae, “Au muste uu afada manek ae, au nufanelung nggara ruma Kanaꞌan mai ena. ");
INSERT INTO txq_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Dei fo au afada ae, eir ia hatahori mana makaboi bibi lombo ma sapi. Huu naa de ei oo meni ei banda-manum ma pusakam mara ruma Kanaꞌan mai boe. ");
INSERT INTO txq_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mete ma manek noke ei, ma ana natane nae ei masiꞌe tao ue-osa hata, ");
INSERT INTO txq_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","na, ei maselu neun mae, ei basa ngga ia, mana makaboi banda-manu numa kadiꞌi anam mai, sama leo ei bei-baꞌim mara. No dalak naa, neu ko ana nadenu ei leo miu dae Gosen.” Yusuf nafada talo naa, nahuu hatahori Masir asa nunute, mete ma ara leo rakabua ro mana lolo bandar. ");
INSERT INTO txq_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Basa boe ma Yusuf no ndia toranoon lima reu rasare manek. Yusuf nakalelelak kasa reu manek nae, “Papa manek! Au amang ma au kaꞌa-fading nggara ruma Kanaꞌan mai ena. Ara mai ro basa sira bibi hien, bibi lombon, sapin, ma sira bua-baꞌun nara lalaꞌen. Hatematak ia basa sara rai dae Gosen ena.” ");
INSERT INTO txq_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Boe ma manek natane nae, “Ei ue-osam hata?” De ara raselu neu manek rae, “Air ia mana lolor sama leo ai bei-baꞌin nara. ");
INSERT INTO txq_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Hatematak ia, nai dae Kanaꞌan hambu teu ina ta hohoꞌak losa ta hambu nanaꞌak ma naꞌu ai-ana ena. Huu naa de ai meni nusak ia mai fo leo taak. Ai oo meni ai banda-manun nara boe. De hatematak ia, ai moke luas neu papa manek fo ai leo miu dae Gosen, fo makaboi ai banda-manun nara reu naa.” ");
INSERT INTO txq_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Basa boe ma manek nafada ndia hihiin neu Yusuf nae, “Hatematak ia o amam no o kaꞌa-fadim mara rai ia ena. ");
INSERT INTO txq_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","De ara bole tao nusak ia, sama leo sira nusa heli-helin. Au bubuluk, dae Gosen naa, dae neulauk mateꞌen nai nusak ia. Dadi malole lenak ara leo reu kada naa leo. Mete ma ketuk ruma sira mai toꞌu lima banda-manur ro malole, na, naa fo ara oo toꞌu lima au enang nggara reu naa boe.” ");
INSERT INTO txq_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Basa boe ma Yusuf nakalelelak aman neu manek. Boe ma Yakob hule-haradoi neu Manetualain fo Ana fee babaꞌe-babatik neu manek naa. ");
INSERT INTO txq_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Boe ma manek natane Yakob nae, “Papa teun nara hida ena?” ");
INSERT INTO txq_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob naselu nae, “Au asoda teuk 130 ena, tehuu au ta leo ahuu uu mamanak esa boe na. Au bei-baꞌing nggara oo talo naa boe. Mete ma akasasamak ua sara, na, memak au teung nggara kekeꞌun lena, tehuu sofek no manggataꞌak.” ");
INSERT INTO txq_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","De Yakob noke Manetualain fee seluk babaꞌe-babatik neu manek, basa boe ma ana nateꞌa. ");
INSERT INTO txq_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Boe ma Yusuf tao tungga manek kokolan, de ana dudu fee sara mamanak nai dae Gosen. Mamanak naa, lolen seli. (Neu ko ara foi mamanak naa nade ‘Rameses’). Basa boe ma Yusuf aman no kaꞌa-fadin nara leo rakandooo reu naa. ");
INSERT INTO txq_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusuf oo sadia nanaꞌak boe fo fee ndia aman, kaꞌa-fadin nara, ma basa sao-anan nara lalaꞌen, mulai numa moꞌok mateꞌen mai, losa kadiꞌi anak mateꞌen. ");
INSERT INTO txq_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Lelek naa, fai ndoe-laꞌas sudi selik kana, losa sudi nai bee ta hambu nanaꞌak ena. Numa Masir mai losa Kanaꞌan, basa hatahori mana ndole-naꞌuk kara ena. Ara ta bisa tao hata-hata ena, nahuu mana farakuk kara ena. ");
INSERT INTO txq_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Boe ma hatahorir ruma basa mamanak kara marai Masir ma basa mamanak kara marai Kanaꞌan mai, mai fo hasa nanaꞌak nai Yusuf. De ana naduduru basa doik kara raa, fo neu mbeda sara reu manek uman. ");
INSERT INTO txq_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Lelek naa, hatahori Masir ma hatahori Kanaꞌan nara ketu doin nara ena. Huu naa de ara ta bisa hasa nanaꞌak bali. Boe ma ara mai rasare Yusuf, de roke rae, “Papa, ee! Fee ai nanaꞌak dei, mita fo ai boso mate nahuu ndoes. Te ketu ai doin nara ena na.” ");
INSERT INTO txq_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Boe ma Yusuf naselu nae, “Mete ma memak ei doi taak kara ena, na, taon talo ia: fee kada ei banda-manum mara mai, fo au sai-selun no nanaꞌak.” ");
INSERT INTO txq_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Boe ma ara fee sira banda-manun nara reu Yusuf, fo sai-selun no nanaꞌak. Ndia sira ndaran, bibi lombon, bibi hien, sapin, ma keledein nara, nahuu teuk naa Yusuf helu-bartaa talo naa ena. ");
INSERT INTO txq_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Manafali boe ma ara reni Yusuf mai bali, de rae, “Papa, ee! Ai kokolak tungga ndoon leo. Ai doin ma ai banda-manun papa sai-selu nala basa sara ena. Hatematak ia ai ta ela hata-hata ena. Ela kada ai aon ma ai dae oen. ");
INSERT INTO txq_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Boso ela ai mate. Mete ma ai mate, na, see ndia nakaneni dae oer raa? Malole lenak papa haꞌi mala ai dadi neu papa ata-daton. Ma papa oo haꞌi mala ai dae oen nara boe, fo dadi neu papa enan. Basa naa papa fee bini-nggees fo ai sele-tande fee papa. Ai sosota-mamanggum ma ai dae oen naa, papa nggatin no kada nanaꞌak. Sadi ai boso mate.” ");
INSERT INTO txq_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","No fai ndoe-laꞌas boe namatua, huu naa de basa hatahori Masir seꞌo heni sira dae oen. De Yusuf hasa nala basa dae oer marai Masir fo dadi neu manek pusakan. ");
INSERT INTO txq_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","No dalak naa, de basa rau-inggu Masir dadi neu manek ata-daton. ");
INSERT INTO txq_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Tehuu Yusuf ta hasa malangga anggamar dae oen, nahuu manek fee sara nanaꞌak taa-taa. Huu naa de ara ta parluu seꞌo sira dae oen. ");
INSERT INTO txq_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Lelek naa oo Yusuf kokolak no rau-inggur boe nae, “Hatematak ia ei dadi miu manek ata-daton ena. Basa ei dae oem lalaꞌen oo, au hasa ala sara ena soa-neu manek boe. Dadi ei haꞌi mala bini-nggees ia, fo miu sele-tande neu dae oer raa leo. ");
INSERT INTO txq_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Basa naa neu fai ketu-koruk, na, ei baꞌen neu babaꞌek lima. Babaꞌek esa menin fee manek. Ela babaꞌek haa, ei paken dadi bini-ngges, ma ketuk ei miꞌa mia ei nufanelum mara.” ");
INSERT INTO txq_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Boe ma ara raselu rae, “Papa fali mala ai sodam ena, huu naa de ai moke makasi. Ai nau dadi miu papa manek ata-daton leo.” ");
INSERT INTO txq_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Basa boe ma Yusuf tao hohoro-lalanek naa dadi neu dala-hadak nai nusa Masir. Huu naa de numa basa hader fo rau-inggur ketu-koru ralak kara, ara baꞌen neu lima. Babaꞌek esa, ara feen neu manek. Babaꞌek haa, sira mesa kasa pake. Kada malangga anggamar dae oen, manek ta hasa sara. Dala-hadak naa, ara bei pake rakandoon. ");
INSERT INTO txq_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Mulai numa lelek naa mai, boe ma hatahori Israꞌel asa leo rahuu reu Masir rai dae Gosen. Ara dadi reu hatahori kamasuꞌik, ma tititi-nonosin nara oo tamba ramanoꞌu boe. ");
INSERT INTO txq_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Numa Masir, Yakob bei nasoda teuk 17 bali, losa basa teun nara dadi teuk 147. ");
INSERT INTO txq_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Neu fai mamaten sangga deka ena, boe ma ana noke nala Yusuf, de nafadan nae, “Anang Usu, ee! Au ameda ta dook ka bali, te Manetualain noke falik au ena. Dadi au oke, mete ma o sue au, na, o sumba-soo fo boso matoi au nai dae Masir ia. ");
INSERT INTO txq_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","O muste muni falik au ao-mbaa mamateng, neni ita bei-baꞌin nara mamana raten neu, fo matoi au neu naa. Naa, papa hihiin.” Boe ma Yusuf naselu nae, “Malole, papa! Mete ma papa nau talo naa ena, na, au tungga a leo.” ");
INSERT INTO txq_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","De Yakob kokolak nae, “Mete ma talo naa, na, hatematak ia o sumba-soo dei, fo mae o tungga papa hihiin.” Basa boe ma Yusuf sumba-soo tungga Yakob kokolan. Boe ma Yakob sendek luu-langgan neu koi lain, fo hule-haradoi noke makasi neu Manetualain. ");
INSERT INTO txq_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ta dook ka boe ma hatahorir mai rafada Yusuf rae ndia aman namahedi noꞌuk ka ena. De ana no anan dua sara, sira Manase ma Efraim, fo reu tiro sira baꞌin Yakob. ");
INSERT INTO txq_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Neu Yakob namanene Yusuf asa mai ena, boe ma ana nakatatakak aon fo nanggatuuk neu koi. ");
INSERT INTO txq_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Boe ma ana nafada Yusuf nae, “Anang Usu, ee! Fai maneuk kara Manetualain mana Koasa Mateꞌen natudu aon neu au ena numa nggorok Luus nai dae Kanaꞌan. Numa naa, Ana helu-bartaa neu au. ");
INSERT INTO txq_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ana kokolak nae, ‘Neu ko Au fee o umbu-anam mara ramahefu, fo o tititi-nonosim dadi neu hatahori nusa moꞌok. Neu ko Au oo fee nusak ia neu o tititi-nonosim mara boe, fo dadi neu sira pusakan losa dae-bafok fai mateꞌen.’ ");
INSERT INTO txq_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Hatematak ia o anam Efraim no Manase naa, sira haak talo ia: au uni Masir mai, tehuu dua sara rai ia ena. Leo mae talo naa oo, hatematak ia au tao dua sara leo au ana heli-heling ena, sama leo Ruben ma Simeon boe. ");
INSERT INTO txq_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tehuu mete ma o hambu anak bali, na, naar o anam mara. Au ta tao sara reu au anang nggara. Dadi dei fo ara simbo sira pusakan numa kada sira kaꞌan Efraim ma Manase mai. ");
INSERT INTO txq_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Au tao talo naa, fo asaneda neu o inam Rahel. Neu ita fali numa Mesopotamia mai fo teni Kanaꞌan teu, boe ma o inam bonggi lenggu numa dalak deka no nggorok Efrata nai dae Kanaꞌan. Faik naa, au dalen susa nalan seli! Boe ma au atoin numa dalak mana neni nggorok Efrata neu tatain.” (Nggorok naa hatematak ia, ara foin nade Betlehem.) ");
INSERT INTO txq_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yakob kokolak basa, boe ma ana botik matan, de mete-nita Yusuf anan nara ruma naa. Boe ma ana natane Yusuf nae, “See anan nara iar?” ");
INSERT INTO txq_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusuf naselu nae, “Sira iar, kanak kara fo Manetualain baꞌe fee au numa Masir.” Basa boe ma Yakob kokolak nae, “Mete ma talo naa, na, o mua sara deka-deka au, fo au hule-haradoi oke Manetualain fee babaꞌe-babatik neu sara.” ");
INSERT INTO txq_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yakob lasik ena, de matan sambu-sambuk ka ena. Huu naa de ana ta bisa mete-nita no malole ena. Boe ma Yusuf noo anan dua sara reu deka-deka Yakob, de ana holu ma idu sara. ");
INSERT INTO txq_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Basa boe ma ana kokolak no Yusuf nae, “Doo basa ia au duꞌa ae, ta bisa dadi au atonggo ua o bali. Tehuu hatematak ia Manetualain tao lenak bali, losa au oo bei bisa mete-ita o anam mara boe.” ");
INSERT INTO txq_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Basa boe ma Yusuf fee anan nara rakaheok numa Yakob mai, de ana sendek luu-langgan no matan losa daer neu aman matan. ");
INSERT INTO txq_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Boe ma Yusuf nambadeik. De leꞌa nala anan nara, fo fee sara rambariik deka-deka ro ndia aman. Ana tao ana kaesan, Manase, neu Yakob boboa konan, ma ana kaduan Efraim, neu boboa kiin. ");
INSERT INTO txq_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tehuu neu Yakob nae ndae liman neu sara, fo noke babaꞌe-babatik fee dua sara, ana lali lima konan neni Efraim langgan neu, ma ana ndae lima kiin neu Manase langgan. ");
INSERT INTO txq_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Boe ma ana hule-haradoi neu Manetualain fo fee babaꞌe-babatik neu Yusuf nae, “O baꞌim Isak aman Abraham, no o baꞌim Isak naa, dua sara tungga Manetualain hihii-nanaun taa-taa. Manetualain oo nakaboi au numa muri-sorung mai losa hatematak ia boe. ");
INSERT INTO txq_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ana nakamboꞌik au ena numa basa sosoek mata-matak kara mai. De au oo oke-hule fo Ana fee babaꞌe-babatik neu kakanak kara iar ro tititi-nonosin nara boe. Mete ma ara hule-haradoi neu Manetualain, na, ara boso lilii raseseik baꞌi Abraham, baꞌi Isak, ma au nadeng. Mita fo sira tititi-nonosin nara tamba ramahefu, fo dadi hatahori nusa moꞌok nai dae-bafok ia.” ");
INSERT INTO txq_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Tehuu neu Yusuf mete-nita ndia aman ndae lima konan neu fadik Efraim langgan, boe ma ana toꞌu nala aman liman naa, de ana lalin neni kaꞌak Manase langgan neu. ");
INSERT INTO txq_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ana nafada aman nae, “Papa, ee! Boso tao talo naa. Huu ndia naa, fadik. Ana uluk ta ndia sana. Papa muste ndae papa lima konan neu kaꞌak langgan. Te naa kaꞌak haak na!” ");
INSERT INTO txq_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tehuu aman Yakob ta nau. Boe ma ana nae, “Ana, nggee! Memak au bubuluk. Neu ko Manase dadi hatahori ta hohoꞌak ma tititi-nonosin tamba ramahefu, losa dadi neu hatahori nusa moꞌok. Tehuu ndia fadin Efraim naa, neu ko ana ta hohoꞌak lena henin bali. Ma ndia tititi-nonosin nara, neu ko noꞌun seli losa ara dadi reu hatahori nusak ta hohoꞌak noꞌuk ka.” ");
INSERT INTO txq_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Basa boe ma ana nafada kakana kaduak kara raa nae, “Mete ma hatahori Israꞌel roke-hule Manetualain fee babaꞌe-babatik neu hatahorir, na, neu ko ara oo raseseik ei dua ngga nadem boe. Neu ko ara roke-hule rae, ‘Ela leo bee na Manetualain fee babaꞌe-babatik neu o, sama leo Ana fee babaꞌe-babatik neu Efraim ma Manase.’ ” No dalak naa, Yakob oo naseseik Efraim naden nakahuluk numa ndia kaꞌan Manase naden mai boe. ");
INSERT INTO txq_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Basa boe ma Yakob nafada Yusuf nae, “Ana, nggee! Ta dook ka bali te au mate ena. Tehuu neu ko Manetualain tulu-fali ei, boe ma Ana no falik ei meni ei bei-baꞌim mara nusan miu. ");
INSERT INTO txq_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","De hatematak ia, au fee o lena heni au fee o kaꞌa-fadim mara. Ma au fee tamba o letek manai dae Kanaꞌan, fo fai bakahulun au haꞌi alan numa hatahori Amorir mai, neu au atati ua sara.” ");
INSERT INTO txq_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Basa boe ma Yakob nadenu roke basa anan nara. Ara mai, boe ma nafada sara nae, “Ana nggara ein, ee! Mai fo ei makabubua deka-deka mia au nai ia dei. Au nau afada ei esa-esak leleo-lalaꞌom nai fai bakadean.” ");
INSERT INTO txq_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Boe ma Yakob mulai nafada memak anan nara nae, “Talo ia! Yakob anan nara ein, ee! Mai ei mambariik eko-feo au. Nenene ei amam Israꞌel ia nae kokolak: ");
INSERT INTO txq_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben! O ia, au anang kaꞌak mateꞌen! O ia, au teteꞌe aing, ma au lima konang. Hatahorir fee hada-horomatak meteꞌen neu o. ");
INSERT INTO txq_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tehuu o dalem ta nakise, ta bubuluk o hihiim ndia bee, sama leo rii nai tasi no kaiboik ana ia mai, ma neni naa neu. Medak neu ma, o muu sunggu-soro mua au saong Bilha ena, de tao manggenggeo o amam koin. Huu naa de o panggak kaꞌam tuda henin memak! ");
INSERT INTO txq_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon ma Lewi! Ei dua ngga leo esak kara! Ei dua ngga soa lesu tafar no muda hiek, fo tao mala hatahorir doidoso. ");
INSERT INTO txq_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ei hihiim ndia kada tati ketu sapir ei mbimbiin nara, losa ara sesendok reu kada mamanan nara. Ma ei manggaraum mara bali, ndia ei henggu nisim mara, dei fo tao misa hatahorir. Huu naa de au ta nau tao matak neu ei kokolam mara. Au oo ta nau sorodododo ua ei dedeꞌam mara boe. ");
INSERT INTO txq_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","De hatematak ia, au akatoo ei mana bobotom mara raa, te sudi selik kana na! Ma ei nasa-odadedeim fo ta mana maena dale kasian faa boe na. Neu ko ei mesa ngga lemba-masaa ei manggaraum. Neu ko Manetualain husi kii-konak ei tititi-nonosim mara. Boe ma ara leo sasarak sudi nai bee, nai dae Israꞌel. ");
INSERT INTO txq_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuda! O nadem sosoa-ndandaan nae, ‘koa-kio’. O kaꞌa-fadim mara neu ko ara koa-kio o, ma ara rateꞌe langgan nara fee hada-horomatak neu o. O musum mara oo, o ndeꞌi sara, losa ara ta bisa botik langgan nara boe. ");
INSERT INTO txq_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","O ia sama leo singa tena ta hohoꞌak, fo mesa kana bisa sangga nanaꞌan. O sama leo singa mane narereꞌa ao-inan fo nae neu sunggu-luꞌu boe; ta hambu esa boe na nambarani neti nggunggue o. O sama leo singa ina fo mana nanea anan boe; ta hambu hatahori esa boe na nambarani neu rambaraꞌu o. Leo naak oo no o boe, huu hatahorir ramahia o, ma ara ta rambarani tao mata-matak. ");
INSERT INTO txq_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Neu ko o ndia toꞌu parenda. O tititi-nonosim mara oo, toꞌu parenda tungga-tungga boe, losa neu ko hambu esa naena haak lena heni basa sara fo nanggatuuk toꞌu parenda naa. Ma basa hatahori nusak kara kaur langgan ma ramanene neu Ndia. ");
INSERT INTO txq_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Neu ko o leo-laꞌo no nemehokok. O hii hata a mesan, hambun! O mae tao hata a mesan, dadi! Boe ma o banda-manum mara, ma osi-lutur buna-boan nara tamba ramanoꞌu, losa neni pipiru-ngganggari henik kara. ");
INSERT INTO txq_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","O nanaꞌa-nininum mara malada-malada mesan, losa ta basa-basa. ");
INSERT INTO txq_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon! O dae pusakam loan seli, ma deka no tasi, losa natoo no kota Sidon. Ofak kara sudi ruma bee mai fo nggari naka no linok neu o tasim tatain. ");
INSERT INTO txq_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Isaskar! O ia, sama leo keledei barakaik, tehuu o langga batun mata bali. Mete ma o sunggu nai dalak ena, na, see ndia bisa nakasetik o mambadeik fo laꞌok makandoo. Tehuu mete ma o mete-mita nggoro neulauk naa nai serik naa ena, na, ta nedenu oo, o lemba mala o fufuam mara ena fo muu boe. De o naa, talo naa leo! ");
INSERT INTO txq_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan! O nadem sosoa-ndandaan nae, ‘mana maketu-maladi dedeꞌak’. Boe ma o ia, ma o tititi-nonosim mara, neu ko raketu-raladi o leom dedeꞌan nara no ta mbeu seserik. Huu o leom naa, esa numa hatahori nusa Israel asa mai. ");
INSERT INTO txq_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","O ia oo kadudin seli sama leo mengge karasok mana luꞌu nai dalak tatain boe. Mete ma hatahori saꞌe ndara nesik naa, na, nggengger neu te o kiki ndara ei dean, losa hatahorin tuda nalenggu pikok. ");
INSERT INTO txq_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Oo, MANETUALAIN! Au hule-haradoi fo O fee masoi-masodak neu ai basa ngga. ");
INSERT INTO txq_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad! O nadem liin sangga leo ‘nggafu feen’. Neu ko naꞌo manu-meo bubuak kara nggafu fee o, tehuu o nggafu masafali masenggi sara. ");
INSERT INTO txq_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser! Neu ko o osi-lutum buna-boan neulauk mateꞌen, losa o bisa tao koki-baroo maladar, fo mane-manek kara mai banda-hasa nai o. ");
INSERT INTO txq_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali! O ia, sama leo rusa ina fui, de ta hambu hatahori esa boe na bisa koladu nala o. O bonggi mala o anam mara kada neulauk kara boe. ");
INSERT INTO txq_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf! O sama leo ai kalonggek mana mori deka nai oe matak. O ndanam mara ralongge reni tembo demak kara reu. ");
INSERT INTO txq_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Hambu hatahorir oo tao sundak o, huu dalen nara hedis sara, sama leo musu mana kou o. ");
INSERT INTO txq_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tehuu Manetualain fo au akaluku-akatele neuk naa, tulu-fali o. Huu naa de neu ko Ana fee lima boa mapaherek neu o, losa o bisa kou masafali sara, leo mae numa dook ka mai. O bisa masenggi sara, nahuu Manetualain mana tulu-fali o naa, memak koasan ta neni babanggak tetebes. Huu naa de au asarai neun. Huu Ana ndia nanea au. ");
INSERT INTO txq_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Neu ko Ana oo nanea o boe. Ma Ana fee babaꞌe-babatik neu o, babaꞌe-babatik numa lalai mai, babaꞌe-babatik numa dae-inak mai, ma babaꞌe-babatik bonggi mala anak manahetak fo sodak. ");
INSERT INTO txq_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Letek kara ta mopo heni sara. Ma au babaꞌe-babating soa-neu o ia, noꞌun lena heni basa letek kara lalaꞌen! Ela leo bee na basa babaꞌe-babatik kara iar mboꞌa reni o reu, nahuu o ndia lena mateꞌen numa basa o kaꞌa-fadim mara lalaꞌen mai. ");
INSERT INTO txq_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin! O paranim sama leo busa fui mana lakamarak. Bei huhua anak, te ana neu sombu ena fo humu nala ndia nanaꞌan. Mete ma leꞌodae, na, ana neu babaꞌe nanaꞌa lenan nara fee anan nara. O tititi-nonosim oo ta hohoꞌak talo naa boe!” ");
INSERT INTO txq_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Baꞌu kada naa leo, Yakob nafada memak ndia anan nara leleo-lalaꞌon nai fai bakadean, esa-esak no tititi-nonosin. Sira basa sara raa, ndia rakonda leo Israꞌel kasalahunu duak kara. ");
INSERT INTO txq_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Basa boe ma Yakob noke anan nara helu-bartaa, de ana nae, “Ta dook ka bali, te au mate ia ena. Mete ma au mate, na, ei muste miu matoi au uu baꞌi Abraham raten. Rates naa nai luak, deka no nggorok Makpela ma Mamre nai dae Kanaꞌan. Fai bakahulun baꞌi Abraham tifa nala luak naa osin, fo taon neu ndia mamana raten. Ana tifa ketun numa leo Het hatahorin esa mai, nade Efron. ");
INSERT INTO txq_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Nai naa ara ratoi ita baꞌin Abraham no ita bein Sara, ma au amang Isak no au inang Ribka. De ei oo muste matoi au uu naa boe, neu au saong Lea boboan. ");
INSERT INTO txq_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ei boso lilii matoi au neu luak, fo baꞌi Abraham tifa nalak naa ena.” ");
INSERT INTO txq_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakob kokolak basa talo naa, boe ma ana sunggu fali neu koi lain, de maten leo. ");
INSERT INTO txq_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Basa boe ma Yusuf holu nala aman, de ana buꞌi nakarereu. Ma ana idu nasakukukun. ");
INSERT INTO txq_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Basa de Yusuf fee parenda neu mana makaneni ao-mbaa mamates sara, fo ara tao modo-aidoo neu Yakob ao-mbaa mamaten, fo ta nakalulutu. ");
INSERT INTO txq_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Boe ma mana makanenir rakaneni ao-mbaa mamates naa, losa faik 40 dalen, tungga sira siꞌen. Basa hatahori Masir asa oo buꞌi ramatani Yakob mamaten boe. Ara tao talo naa losa faik 70 dalen, taon sama leo sira hatahori ina-huun mate. ");
INSERT INTO txq_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Basa faik kahitu hulun nara, boe ma Yusuf nafada ndia penggawen nara nae, “Nenene! Au oke fo ei meni au hara liing ia, miu mafada manek mae talo ia: ");
INSERT INTO txq_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Neu au amang nae mate, ana noke au helu-bartaa fo au uu atoi ndia ao-mbaa mamaten nai dae Kanaꞌan. De au hule manek fee luas fo au uu atoi au amang. Basa naa, dei fo au fali ia mai.’ ” ");
INSERT INTO txq_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Manek namanene nala naa, boe ma ana naselu nae, “Mete ma o helu-bartaa neu o amam talo naa ena, na, muu fo matoin neu naa leo.” ");
INSERT INTO txq_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Boe ma Yusuf neu natoi aman. Hatahori noꞌuk ka oo tungga roon boe. Ndia basa manek penggawen nara, ma basa hatahori ina-huuk maruma Masir mai. ");
INSERT INTO txq_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusuf kaꞌa-fadin, ma basa sira hatahori mana maue-osan nara oo tungga reu ratoi Yakob boe. Elak kara maruma Gosen kada sira sao inan no ana diꞌi-doen, ma banda-manun nara. ");
INSERT INTO txq_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Soldadu noꞌuk ka oo tungga boe. Ketuk saꞌe kareta, ma ketuk saꞌe ndara. No mana tunggak kara raa noꞌun seli, huu naa de nononggok mana laꞌok tungga mamates naa narun seli. ");
INSERT INTO txq_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Boe ma basa sara laꞌok losa ara ladi lee Yarden numa mamanak esa nade Atad. Hatahorir rasiꞌe mai fo fefemba hade nai naa. Numa mamanak naa, Yusuf asa buꞌi ramatani ndia aman mamaten. Boe ma ara beꞌe-falufii leꞌodaek hitu bali. ");
INSERT INTO txq_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Neu hatahori Kanaꞌan marai naa mete-rita sususak talo naa, boe ma ara kokolak rae, “Awii! Ei mete dei! Hatahori Masir asa hada bebeꞌe-falufiin sususan sudi selik kana talo naa! Ara buꞌi ramatani losa dadi talo naa.” Huu naa de ara foi mamanak naa nade, Abel-Misraim. Sosoa-ndandaan nae, ‘hatahori Masir sususan.’ ");
INSERT INTO txq_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Basa boe ma Yakob anan nara tao tungga sira hehelu-bartaan. ");
INSERT INTO txq_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Boe ma ara koꞌo reni Yakob ao-mbaa mamaten, de reu ratoin neu luak deka nggoro Makpela ma Mamre. Abraham tifa nala mamanak naa ena numa leo Het hatahorin esa mai, nade Efron, fo taon dadi neu sira mamana raten. ");
INSERT INTO txq_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusuf natoi basa aman, boe ma ana no kaꞌa-fadin nara lenggu fali reni Masir reu. Leo naak oo, basa hatahori laen mana tungga ro sara reu ratoi mamates boe. ");
INSERT INTO txq_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Neu ara losa nai Masir, boe ma Yusuf kaꞌan nara mulai ramataꞌu, nahuu sira aman ta sana ena. De ara rakokola aok rae, “Awii! Ei duduꞌa dei! Leo Yusuf bei nambeda dalek neu ita, fo ana bala ita tatao-nonoꞌi manggaraun neun, na, talo bee?” ");
INSERT INTO txq_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Boe ma ara rala harak esa fo haitua hara liik neu Yusuf rae talo ia: “Papa! Ai bei masaneda neu ita aman bei numa lain naa, ana nadenu ai ");
INSERT INTO txq_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","fo mafada papa mae, ‘Usu muste lilii heni kaꞌan nara salan, nahuu fai bakahulun ara tao manggarauk neun ena.’ Ai oo masaneda ita aman nakaluku-nakatele neu Manetualain numa lele uluk mai boe. Ai oo dadi neu Manetualain atan nara boe. Huu naa de hatematak ia ai mai moke ambon, nahuu ai basa ngga tao masala papa ena.” Yusuf namanene nala naa, boe ma ana buꞌi. ");
INSERT INTO txq_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Basa boe ma ndia kaꞌan nara mai aon, de ara sendek luu-langgan nara reu ndia matan, ma ara kokolak rae, “Elan fo papa tao ai dadi miu papa ata-daton leo.” ");
INSERT INTO txq_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tehuu Yusuf nafada sara nae, “Kaꞌa nggara ein, ee! Ei hae mamataꞌu bali! Kada Manetualain mesa kana ndia naena haak fee hukun neu hatahori. Tehuu au ia, taa. ");
INSERT INTO txq_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Fai bakahulun naa, ei memak mala harak esa ena, fo mae tao manggarauk neu au. Tehuu Manetualain tao nasafali ei nanae manggaraum, fo Ana taon dadi neu malole. Huu naa de Ana soꞌu au dadi neu hatahori ina-huuk, fo hatahori noꞌuk ka bisa hambu sodak. ");
INSERT INTO txq_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Dadi hatematak ia, au afada ei fo boso mamataꞌu bali. Huu au helu-bartaa neu ko au loti-mete ei, ma basa ei anam mara lalaꞌen.” No kokolak neulauk talo naa, Yusuf tao nalende kaꞌan nara dalen. ");
INSERT INTO txq_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Basa boe ma Yusuf no kaꞌa-fadin nara leo rahuu reu Masir. Ana nasoda losa teuk 110. ");
INSERT INTO txq_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ana bei hambu Efraim umbu-anan nara. Ma ndia mesa kana oo nakaboi Manase umbun boe, ndia Makir anan nara. ");
INSERT INTO txq_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusuf nafada kaꞌan nara nae, “Kaꞌa nggara ein, ee! Nai au nememedang, na, au fai mamaten deka-deka ena. Tehuu au amahere neu ko Manetualain nakaboi ei. Ana ndia neu ko nakalalaꞌok ei kalua numa nusak ia mai. Ana oo ndia nangganuni ei fali meni nusak fo Ana sumba-soo ena fo nae feen neu baꞌi Abraham, baꞌi Isak, ma papa Yakob.” ");
INSERT INTO txq_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Boe ma Yusuf noke toranoon nara soꞌuk sumba-sook nae, “Ei muste helu-bartaa neu au. Mete ma losa fain Manetualain no falik ei meni nusak naa miu, na, ei oo muste haꞌi meni au dui-roung nggara boe.” ");
INSERT INTO txq_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Basa boe ma Yusuf maten numa Masir, neu teun nara 110. Boe ma ara tao modo-aidoo neu ao-mbaa mamaten. De ara taon neni kopan dale neu. ");
INSERT INTO txq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","2","Ia, buku tutuik laꞌe-neu Yesus Karistus, Hatahori naa ndia Manetualain helu-bartaa memak kana numa lele uluk mai ena, fo nae nadenun mai. Ndia ia, mane Dauk ma baꞌi Abraham tititi-nonosin. Mulai numa baꞌi Abraham losa mane Dauk hambu dombe salahunu haa. Ndia bei-baꞌin nara tungga susura tititi-nonosin, leo iak: Abraham bonggi nala Isak, Isak bonggi nala Yakob, Yakob bonggi nala Yahuda no kaꞌa-fadin nara, ");
INSERT INTO txq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda bonggi nala Peres no Sera (sira inan, nade Tamar), Peres bonggi nala Herson, Herson bonggi nala Ram, ");
INSERT INTO txq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram bonggi nala Aminadab, Aminadab bonggi nala Nahason, Nahason bonggi nala Salmoon, ");
INSERT INTO txq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmoon bonggi nala Boꞌas (ndia inan, nade Rahab), Boꞌas bonggi nala Obet (ndia inan, nade Rut), Obet bonggi nala Isai, ");
INSERT INTO txq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","11","Isai bonggi nala Dauk. Numa Dauk mai losa lelek naa, fo hatahori Israꞌel asa neni nggari henik kara reni Babel reu, hambu dombe salahunu haa bali, sira: Dauk bonggi nala Soleman (Soleman inan ndia, bakahulun Uria saon). Soleman bonggi nala Rehabeam, Rehabeam bonggi nala Abia, Abia bonggi nala Asaf, Asaf bonggi nala Yosafat, Yosafat bonggi nala Yoram, Yoram bonggi nala Usia, Usia bonggi nala Yotam, Yotam bonggi nala Ahas, Ahas bonggi nala Heskia, Heskia bonggi nala Manase, Manase bonggi nala Amos, Amos bonggi nala Yosias, Yosias bonggi nala Yekonya no fadin nara, neu lelek fo neni nggari henik kara reni Babel reu. ");
INSERT INTO txq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Neu ara neni nggari henik kara reni Babel reu losa Yesus, hambu dombe salahunu haa bali, sira: Yekonya bonggi nala Saltiel, Saltiel bonggi nala Serubabel, Serubabel bonggi nala Abihut, Abihut bonggi nala Elyakim, Elyakim bonggi nala Asor, Asor bonggi nala Sadok, Sadok bonggi nala Akim, Akim bonggi nala Eliut, Eliut bonggi nala Eliasar, Eliasar bonggi nala Matan, Matan bonggi nala Yakob, boe ma Yakob bonggi nala Yusuf. Yusuf naa, sao nala Maria. Maria naa, ndia bonggi nala Yesus Karistus. ");
INSERT INTO txq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dadi mulai numa Abraham mai losa Dauk, hambu dombe salahunu haa; numa Dauk mai losa ara neni nggari henik kara reni Babel reu, hambu dombe salahunu haa; ma numa Babel mai losa bonggi Karistus, hambu dombe salahunu haa. ");
INSERT INTO txq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maria bonggi nala Yesus naa, tutuin talo ia: Maria ia, Yusuf fufudin ena. Dua sara bei ta sunggu-soro rakabua sama leo sao holu-ndaek, naa te medak neu ma, Maria taꞌin naisi numa Manetualain Dula-dale Malalaon mai ena. ");
INSERT INTO txq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Neu Yusuf bubuluk talo naa, boe ma ana nae tao naketu sira dua sara nefufudi aon naa. Tehuu ana ta nau nakamamaek Maria nai hatahori noꞌuk kara matan, nahuu ndia dalen neulauk. Huu naa de ana nae tao naketun no kada neneek. ");
INSERT INTO txq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","De neu ana bei duꞌa-duꞌa neu-mai, boe ma leꞌodaek esa ana nala meꞌi. Numa meꞌis naa, ana mete-nita Manetualain atan numa nusa tetuk do inggu temak mai nafadan nae, “Yusuf! O ia, mane Dauk tititi-nonosin. O boso babati sao mala Maria. Te kakanak manai taꞌin dale naa, Manetualain Dula-dalen ndia tao naa. ");
INSERT INTO txq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Neu ko Maria bonggi nala ana tou anak esa. Boe ma o muste foin nade Yesus, nahuu neu ko Ana ndia tao nasoi-nasoda Manetualain hatahorin nara ruma sira sala-singgon nara mai.” ");
INSERT INTO txq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dedeꞌak ia dadi talo naa, nahuu Manetualain nafada memak kana numa lele uluk mai ena. Ana pake nita Ndia mana toꞌu dedeꞌan Yesaya fo surak nae, ");
INSERT INTO txq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ei nenene, ee! Neu ko hambu ana feꞌok esa bei ao tema, ta bubuluk te taꞌin naꞌisi ena. Boe ma ana bonggi nala Ana tou anak esa. Ara oo foin nade Imanuel boe.” (Nai dedeꞌa Ibrani, ‘Imanuel’ sosoa-ndandaan: Manetualain sama-sama no ita.) ");
INSERT INTO txq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusuf nala meꞌi basa, boe ma nambadeik. De ana tungga memak Manetualain hara hehelun naa. Ana simbo nala Maria dadi neu ndia saon, ");
INSERT INTO txq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","tehuu Yusuf ta sunggu-soro nakabua noon sama leo sao holu-ndaek, losa Maria bonggi basa Kakanak naa ena. Bonggi basan, boe ma Yusuf foi Kakanak naa, nade Yesus. ");
INSERT INTO txq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Neu bonggi Yesus numa nggorok Betlehem nai profensi Yudea, manek Herodes toꞌu parenda. Faik naa, hambu hatahori hida ruma mamana dook nai mamanak ledo toda, reni kota Yerusalem mai. Sira iar, hatahori mana malela mete nduuk. ");
INSERT INTO txq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Neu ara losa Yerusalem, ara ratane reu-mai rae, “Hatahori Yahudir manen fo bei fo neni bonggik naa, nai mamanak bee? Ai mete-mita nduuk esa nai mamanak ledo toda natudu tanda nae, Ana neni bonggik ena. Huu naa de ai mai fo mae makaluku-makatele neun.” ");
INSERT INTO txq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Neu manek Herodes namanene nala kokolan nara talo naa, boe ma dalen nameda ta neulauk. Huu naa de, basa hatahorir marai Yerusalem oo rameda leo naak boe. ");
INSERT INTO txq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Basa boe ma manek Herodes nakabua nala malangga anggama Yahudi malanggan nara ma meser anggamar lalaꞌen, de natane sara nae, “Soba ei mafada au dei! Karistus naa, fo Manetualain helu-bartaa memak kana ena naa, bonggin nai bee?” ");
INSERT INTO txq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Boe ma ara raselu rae, “Nai nggorok Betlehem, profensi Yudea, papa manek. Sama leo Manetualain mana toꞌu dedeꞌan Mika surak memak kana ena numa lele uluk mai, leo iak: ");
INSERT INTO txq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Woi, ei hatahori Betlehem marai profensi Yudea naa. Ei boso duꞌa mae, ei nggorom naa, kada nggoro kadiꞌik esa fo sosoan taa. Huu neu ko hambu hatahori moꞌo-inahuuk esa numa naa mai. Neu ko Ana dadi mana lolo soa-neu Au hatahoring Israꞌel asa.’ ” ");
INSERT INTO txq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Manek Herodes namanene nala naa, boe ma ana nanggou nala hatahori mana malela mete nduuk kara no neneek. De ana natane sara nae, “Faik bee ei mete-mita nduuk naa toda nai lalai?” Boe ma ara rafadan. ");
INSERT INTO txq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","De ana nadenu sara reni Betlehem reu ma nafada nae, “Ei miu sangga Kakanak naa ndule basa mamanak manai naa. Mete ma ei matonggo mian ena, na, fali mai ngga fo mafada au. Au oo ae uu akaluku-akatele neun boe.” ");
INSERT INTO txq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ara ramanene rala manek kokolan, boe ma ara reu. Ta bubuluk te, ara mete-rita seluk nduuk naa, fo fai bakahulun mete ritan numa mamanak ledo toda naa ena. Nduuk naa toda neu matan nara, boe ma ana laꞌok nakandoo de nambariik tetar Kakanak naa mamana leleon lain. ");
INSERT INTO txq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ara mete-rita talo naa, boe ma ramahoko ralan seli. ");
INSERT INTO txq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","De ara maso uma dale reu, boe ma mete-rita Kakanak naa no inan, Maria. De ara sendek luu-langgan nara fo rakaluku-rakatele neun. Boe ma ara buka sira hadia buas mabelir mbombotin, fo fee neu Kakanak naa. Ara fee lilo mbilas, rani, ma ai kaboo menik daan. ");
INSERT INTO txq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ta dook ka boe ma ara hambu meꞌis numa Manetualain mai nae, “Ei boso bei fali meni manek Herodes miu bali.” Huu naa de ara fali reni sira nusan reu, tungga dalak laen. ");
INSERT INTO txq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Neu hatahori mana malela mete nduuk kara raa fali reu ngga, boe ma Manetualain atan esa numa nusa tetuk do inggu temak mai nafada Yusuf nai meꞌis dale nae, “Yusuf! Mambadeik lai-lai leo! Malai mua Kakanak naa no inan meni nusa Masir miu. Leo makandoo miu naa, losa Au afada faik bee fo ei bisa fali, te manek Herodes sangga Kakanak naa, fo nae tao nisan!” ");
INSERT INTO txq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Boe ma Yusuf nambadeik. Ana nuni nala saon no Kakanak naa, de leꞌodaek naa oo ara ralai reni nusa Masir reu boe. ");
INSERT INTO txq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ara leo numa naa losa Herodes mate. No dalak naa, Manetualain kokolan dadi, sama leo Ndia mana toꞌu dedeꞌan Hosea nafada memak numa lele uluk mai ena nae, “Au anggou falik Au Anang, fo kalua numa Masir mai.” ");
INSERT INTO txq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Neu manek Herodes bubuluk ena nae, hatahori mana malela mete nduuk kara raa lelekok kana ena, boe ma ana namanasa nalan seli. Ana parenda soldadun nara nae, “Meni nggorok Betlehem ma nggorok kara mana deka rai naa. Makanisa basa kakana ana touk kara lalaꞌen, fo teun nara dua dae reu.” Herodes parenda talo naa, nahuu ana nasaneda hatahori malelak kara raa tutuin. Ana reke mulai numa makasososan mai mete-rita nduuk naa toda numa lalai. ");
INSERT INTO txq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Basa hata mandadik kara iar dadi tungga hata fo Manetualain mana toꞌu dedeꞌan Yeremia surak memak kana numa lele uluk mai ena nae, ");
INSERT INTO txq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Hambu hatahori haran buꞌi namatani nai kota Rama. Rahel buꞌi nakarereu, nahuu ndia anan nara mate basa sara ena. Ana ta nau hatahorir mai kokoe-nanasi neun, nahuu ndia anan nara taa sara ena.” ");
INSERT INTO txq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Doo-doo boe ma manek Herodes mate. Faik naa Yusuf asa bei rai Masir. Boe ma Manetualain atan esa numa nusa tetuk do inggu temak mai natudu mata-aon neu Yusuf nai meꞌis dale. ");
INSERT INTO txq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ata naa nae, “Yusuf! Mambadeik leo! Nuni mua Kakanak naa no inan, fo fali muni Israꞌel miu leo. Hatahori fo mana nae nakanisa Kakanak naa, maten ena.” ");
INSERT INTO txq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusuf namanene nala naa, boe ma ana nambadeik. De ana nuni nala sara fali reni nusa Israꞌel reu. ");
INSERT INTO txq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tehuu neu ana namanene nae, manek Herodes anan Arkalaus ndia toꞌu parenda hatematak ia nai profensi Yudea, boe ma ana namataꞌu fali neni naa neu. De Manetualain parendan nai meꞌis esa dale bali nae, “Yusuf, o boso leo nai Yudea.” Huu naa de ana neu leo nai profensi Galilea, ");
INSERT INTO txq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","numa nggorok esa nade Nasaret. No dalak naa, Manetualain kokolan naa, dadi tetar ena tungga hata fo Ndia mana toꞌu dedeꞌan surak memak kana ena nae, “Neu ko hatahorir roken rae, Hatahori Nasaret.” ");
INSERT INTO txq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Neu Yesus namoꞌo mamais, boe ma Yohanis Mana Saranik mulai nanori hatahorir numa mamana nees, nai profensi Yudea. ");
INSERT INTO txq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ana nafada nae, “Toranoo susue nggara ein! Ei muste manaku ma laꞌo ela ei sala-singgom mara, fo fali meni Manetualain miu leo. Hatematak ia basa hatahorir bisa maso dadi reu Manetualain hatahorin ena.” ");
INSERT INTO txq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Lele uluk Manetualain mana toꞌu dedeꞌan esa, nade Yesaya surak laꞌe-neu Yohanis nae, “Neu ko hambu hatahori eki nai mamana nees nae, ‘Basa hatahorir sadia memak tao matalolole dalak, fo soru Lamatuak mamain! Tao matetu dalak kara soa-neun!’ ” ");
INSERT INTO txq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanis ia leleo-lalaꞌon sama leo Manetualain mana touꞌ dedeꞌan lele uluk kara. Bua-loꞌan, taon numa banda onta bulun mai. Kalikeen, taon numa banda roun mai. Nanaꞌa-nininun, ndia lamak ma fani oe lasi. ");
INSERT INTO txq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Faik naa, hatahori noꞌun seli mai fo rae ratonggo ro Yohanis. Ara ruma Yerusalem, ma ruma profensi Yudea isin lalaꞌen mai. Ara oo ruma nggorok kara mana dekak ro lee Yarden mai boe. ");
INSERT INTO txq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ara buka dalen nara ma manaku sira sala-singgon lalaꞌen, basa boe ma Yohanis sarani sara ruma lee Yarden. ");
INSERT INTO txq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Faik naa, hatahorir maruma anggama Farisi partein ma anggama Saduki partein oo mai fo roke Yohanis sarani sara boe. Tehuu neu ana mete-nita sara, boe ma ana mboka nae, “Weeh! Eir ia, sama leo mengge mana pepeko-lelekok! Neu ko Manetualain hukun ei, nahuu ei tatao-nonoi manggaraum mara. Heeh! Boso duꞌa mae, ei bisa makamboꞌik numa Ndia huku-dokin mai. ");
INSERT INTO txq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Dadi malole lenak ei fali meni Manetualain miu, ma laꞌo ela ei sala-singgom mara lalaꞌen. Basa naa, tao hata fo neulauk kara, sama leo ai huuk mana maboa neulauk. ");
INSERT INTO txq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Boso duꞌa mae, eir ia, baꞌi Abraham tititi-nonosin, de ei masodam mara nai lino-lendek dale ena. Mamahere au! Manetualain bisa adu batur ia fo dadi reu baꞌi Abraham tititi-nonosin. ");
INSERT INTO txq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Besa-besa, ee! Te hambu Hatahori toꞌu memak taka, nahani a fo nae hungga heni basa ai huuk ta mana maboa neulauk lalaꞌen. Hungga basa, na, Ana nggari sara reni aꞌi dale reu. ");
INSERT INTO txq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Hatematak ia au sarani ei unik oe fo dadi tanda nae, ei masadea laꞌo ela ei sala-singgom mara ena. Tehuu neu ko hambu Hatahori esa ta neni babanggak lena heni au nae mai. Leo mae dadi uu kada Ndia hatahori neondan oo, au ta andaa boe. Neu ko Ana nasofe ei dalem mara nenik Manetualain Dula-dale Malalaon. Ana oo tao nala ei dadi malalaok boe, sama leo hatahori pake aꞌi fo hotu heni dafuk. ");
INSERT INTO txq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ana toꞌu kokoko nonook hade ena fo sangga daꞌi heni hade langgak. Boe ma Ana nadai hade neun nara reni soka dale reu. Tehuu hade langgak kara, Ana mboꞌa sara reni aꞌi mana mbila ta kala matek neu.” ");
INSERT INTO txq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Faik naa, Yesus konda numa Galilea mai neni lee Yarden neu. Ana mai noke Yohanis saranin, ");
INSERT INTO txq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","tehuu Yohanis ta nau. Ana nasabara nae, “Talo bee de au muste sarani Lamatuak? Ta sala ia, do? Lamatuak ndia muste sarani au. Te naa ndia au toꞌak, na!” ");
INSERT INTO txq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Boe ma Yesus naselu nae, “Ta hata-hata. Tehuu hatematak ia malole lenak kaꞌa ndia sarani Au. No dalak naa, ita tungga Manetualain hihii-nanaun.” Yohanis namanene nala naa, boe ma ana naselu nae, “Bee a mesan, Lamatuak.” De ana sarani Yesus. ");
INSERT INTO txq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sarani basa, boe ma Yesus kalua numa lee mai. Tehuu medak neu ma, lalai natahuka. Boe ma Ana mete-nita Manetualain Dula-dalen konda mai neni Ndia neu, dadi sama leo mbui lunda sina mai tai neun. ");
INSERT INTO txq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Boe ma Manetualain nahara numa lalai mai nae, “Ndia ia, Au Ana susueng. Ana soa tao namahoko Au.” ");
INSERT INTO txq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Basa boe ma Manetualain Dula-dalen nuni noo Yesus neni mamana nees neu, mita fo nitur malangga ina-huun soba-doun. ");
INSERT INTO txq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Numa naa Ana puasa hatu-leledon faik haa hulu dalen, de Ana ndoe nalan seli. ");
INSERT INTO txq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Neu Ana ndoe nalan seli talo naa, boe ma nitur malangga ina-huun mai soba-doun nae, “O ia, tebe-tebe Manetualain Anan, do? Mete ma tebe, na, parenda batur ia dadi reu nanaꞌak leo.” ");
INSERT INTO txq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tehuu Yesus naselu nae, “Sama leo neni surak nai Manetualain Susura Malalaon dale nae: ‘Hatahori dae-bafok ta rasoda numa kada nanaꞌak mai. Tehuu ara oo muste nenene Manetualain Dedeꞌa-kokolan boe, ma tao tungga Ndia hihii-nanaun.’ ” ");
INSERT INTO txq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Boe ma nitu naa nuni noo Yesus neni kota Yerusalem neu, ndia Lamatuak kota malalaon. De ana noo Yesus hene reni mamanak fo demak mateꞌen manai Uma Huhule-haradoi Ina-huuk reu. ");
INSERT INTO txq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Boe ma nitu naa nae, “Mete ma tebe-tebe Manetualain Anan O, na, soba O boke dae muu leo. Sama leo neni surak nai Manetualain Susura Malalaon nae, ‘Neu ko Manetualain parenda Ndia atan nara ruma nusa tetuk do inggu temak mai, fo ranea O.’ Nai Manetualain Susura Malalaon oo neni surak boe nae, ‘Neu ko ara ratanee rala O renik liman nara, mita fo O ta koi laꞌe batu ma O ao-inam oo ta nambeta boe.’ ” ");
INSERT INTO txq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tehuu Yesus naselu nae, “Hambu neni surak boe nai Manetualain Susura Malalaon dale nae, ‘Manetualain naa, ndia naena haak fo parenda o. Huu naa de o boso soba-doun.’ ” ");
INSERT INTO txq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Boe ma nitu naa nuni noo Yesus neni letek fo demak mateꞌen esa poin neu. De ana natudu basa nusak kara marai dae-bafok roo basa ta hohoꞌan nara. ");
INSERT INTO txq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Natudu basa naar lalaꞌen, boe ma nitu naa nafada nae, “Sadi O sendek luu-langgam fo makaluku-makatele neu au, neu ko basa iar lalaꞌen au fee sara reu O.” ");
INSERT INTO txq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tehuu Yesus ranggan nae, “Weeh, nitu! O malai heok ia leo! Huu Manetualain Susura Malalaon nae, ‘O muste makaluku-makatele neu Manetualain, ma o muste maue-osa soa-neu kada Ndia mesa kana.’ ” ");
INSERT INTO txq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nitu namanene nala naa, boe ma ana laꞌo ela Yesus. Boe ma Manetualain atan nara ruma nusa tetuk do inggu temak mai fo raono-lalau neun. ");
INSERT INTO txq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Lelek naa, manek Herodes sese Yohanis Mana Saranik neni bui dale neu. Neu Yesus namanene talo naa, boe ma Ana fali neni Galilea neu. ");
INSERT INTO txq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ana neni Ndia nggoro-tadun Nasaret neu, basa de Ana laꞌo nakandoo neu leo numa nggorok Kapernaum. Nggorok naa, nai dano Galilea tatain, nai Sebulon no Naftali daen. ");
INSERT INTO txq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","No dalak naa, Ana tao tungga hata fo Manetualain mana toꞌu dedeꞌan Yesaya surak memak kana ena nae, ");
INSERT INTO txq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nai Sebulon daen ma Naftali daen, mana deka no dano Galilea, nai lee Yarden boboan seri, hatahori ta Yahudir oo leo rai naa boe. ");
INSERT INTO txq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ara leo-laꞌo nai makiu-makahatuk dale, tehuu hatematak ia ara mete-rita Manggaledok ena. Ma Manggaledok naa nasaꞌa ena soa-neu basa hatahorir fo bei ta ralela Manetualain.” ");
INSERT INTO txq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Numa lelek naa mai oo, Yesus mulai nanori hatahorir boe nae, “Ei muste masadea laꞌo ela ei sala-singgom mara, fo leo-laꞌo no lolo-laok leo! Hatematak ia basa hatahorir bisa maso dadi reu Manetualain hatahorin ena.” ");
INSERT INTO txq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Faik esa, Yesus laꞌok nesik dano Galilea tatain. Ana natonggo no hatahori dua kaꞌa-fadik kara. Esa nade Simon, tehuu hatahorir rasiꞌe roken rae, Petrus. Ma fadin nade Anderias. Ara dala iꞌak numa dano, nahuu dua sara mana puꞌa-dala. ");
INSERT INTO txq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Boe ma Yesus nanggou sara nae, “Woi, mai fo tungga Au leo! Ei masiꞌe sangga iꞌak, tehuu hatematak ia Au anori ei fo dadi miu mana sangga samanek.” ");
INSERT INTO txq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dua sara ramanene rala naa, boe ma ara laꞌo ela sira dalan, de reu tungga tutik ka ro Yesus. ");
INSERT INTO txq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Basa naa, Yesus laꞌok nala faa bali, boe ma mete-nita Sabadeus anan nara. Kaꞌak nade Yakobis, ma fadik nade Yohanis. Dua sara rafafaꞌu ralole puꞌak nai ofak dale sama-sama ro sira aman. Boe ma Yesus nanggou dua sara fo tunggan. ");
INSERT INTO txq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dua sara ramanene rala naa, boe ma ara laꞌo ela sira ofan ma aman, fo tungga tutik ka roon. ");
INSERT INTO txq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Basa naa, Yesus asa laꞌok ndule profensi Galilea, fo fee nenorik nai hatahori Yahudi uma huhule-haradoin nara dale. Ana fee nenorik laꞌe-neu Manetualain Hara Lii Malolen, ma nafada dalan talo bee fo hatahorir bisa tungga Manetualain parendan. Ana oo, tao nahai basa hatahorir ruma sira hedi mata-matan nara mai boe. ");
INSERT INTO txq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ta dook ka boe ma tutuik laꞌe-neu Yesus tataon naa, natanggela ndule basan losa profensi Siria. De hatahorir roo sira hatahori kamahedin nara fo hedis mata-matak kara reni Yesus reu. Ara oo reni hatahori fo nitu saꞌek, mulu bibik ma keko-luꞌuk boe. Boe ma Ana tao nahai basa sara. ");
INSERT INTO txq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Faik naa, hatahori noꞌun seli mai, de tunggan. Ara ruma profensi Galilea mai, ma ruma nusa kota salahunuk fo rasiꞌe roken rae, Dekapolis. Hambu laen bali, na, ruma kota Yerusalem mai, ruma profensi Yudea mai, ma ruma lee Yarden boboan seri mai. ");
INSERT INTO txq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Neu Yesus mete-nita hatahori noꞌun seli mai tungga Ndia, boe ma Ana hene neni lete-mbuku anak esa neu, de nanggatuuk neu naa. Ndia ana nunin nara fo neni here nalak kara raa, mai deka-deka fo nenene neun. ");
INSERT INTO txq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Boe ma Ana mulai nanori sara nae, ");
INSERT INTO txq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Hatahori kasian nara fo mana parluu Manetualain raua, nahuu Manetualain mesa kana, ndia sira Mane neulaun. ");
INSERT INTO txq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hatahorir mana rameda susa-sonak raua, nahuu Manetualain mesa kana, ndia kokoe-nanasi sara. ");
INSERT INTO txq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hatahori kadiꞌik kara raua, nahuu neu ko ara simbo basa babaꞌe-babatik fo Manetualain helu-bartaak ena. ");
INSERT INTO txq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Hatahorir fo dalen nara hii ralan seli neu Manetualain eno-dala ndoon raua, nahuu neu ko Ana tao nala sara rameda dai. ");
INSERT INTO txq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hatahorir mana ratudu dale kasian raua, nahuu neu ko Manetualain oo tuda kasian neu sara boe. ");
INSERT INTO txq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Hatahorir fo dalen nara lolo-laok raua, nahuu neu ko sira mesa kasa, ndia mete-rita Manetualain. ");
INSERT INTO txq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Hatahorir mana tao mole-damek raua, nahuu neu ko Manetualain nae, ‘Sira iar, Au anang nggara.’ ");
INSERT INTO txq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Hatahorir mana hambu tuni-ndenik nahuu tungga Manetualain raua, nahuu Manetualain mesa kana, ndia sira Mane neulaun. ");
INSERT INTO txq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Neu faik fo hatahori laen tao doidoso ei, nahuu tungga Au, ei oo maua boe. Neu faik fo ara kokolak manggarauk neu ei, ma ratuik puputa-papata tao raboboo ei nadem mara, ei oo maua boe. ");
INSERT INTO txq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Leo mae talo naa oo, ei muste tao aom mara mamahoko ma dalem mara kada mbena sau-sau boe, nahuu Manetualain sadia bala fee ei babaꞌem noꞌun seli nai nusa tetuk do inggu temak ena. Tehuu masaneda, ee! Ta kada ei ndia doidoso talo naa, te bakahulun hatahorir oo tao manggarauk talo naa soa-neu Manetualain mana toꞌu dedeꞌan nara boe.” ");
INSERT INTO txq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mete ma ita tae tao nanaꞌak malada, na, ita tao masik neun dei. Leo naak oo, hatahorir mana leo nai dae-bafok ia, ara toꞌa neu ei boe. Tehuu mete ma masik mami ena, na, nanalan hata bali? Kada nggari henin neu dalak fo heheta-tatabun leo. ");
INSERT INTO txq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ei oo muste leo-laꞌo sama leo lambu boe, mita fo hatahori noꞌuk ka mete-rita no neulauk. Ei mbilam mara muste rasaꞌa, nok bali kota manai letek lain, de basa hatahorir mete-ritan. ");
INSERT INTO txq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hatahori mana nambila lambu tiꞌoek, ara ta ranggunggua lambu naa neu ure dae dale. Tehuu ara ratetende lambu naa neu mamana demak, mita fo ana tao manggaledo uma isin lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ei oo muste leo-laꞌo talo naa boe. Ei muste masaꞌa, mita fo hatahori laen nara mete-rita ei leleo-lalaꞌo neulaum mara. Neu ara mete-rita talo naa, neu ko ara koa-kio Manetualain rae, ‘Wee! Ei Amam manai nusa tetuk do inggu temak naa, ta neni babanggak!’ ” ");
INSERT INTO txq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ei boso duꞌa mae, Au uni dae-bafok ia mai, fo koka heni Manetualain hohoro-lalanen fo Ana feek neu baꞌi Musa. Ma boso duꞌa mae, Au ta tao matak neu hata fo Manetualain mana toꞌu dedeꞌan nara kokolak memak kana numa lele uluk mai ena. Huu Au mamaing ia, ae tao basan dadi tetar sama leo basa hata fo ara kokolak memak kana ena. ");
INSERT INTO txq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Huu naa de nenene matalolole, ee! Lalai no dae-inak bei ta rakalulutu, mete ma basa-basan bei ta dadi tungga Manetualain hohoro-lalanen nara. Leo mae titik do koma esa oo, ta bisa neni koka henik boe. ");
INSERT INTO txq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Numa Manetualain hatahorin lalaꞌen mai, mete ma hambu ketuk lena langga Manetualain hohoro-lalanen, nahuu ana duꞌa nae, ‘Hee! Hohoro-lalanek ia kadiꞌik ka, ta naena sosoak hata esa boe na!’ De ana nanori neu hatahori laen talo naa, neu ko Manetualain henggenee nalan dadi kada hatahori kadiꞌik nai nusa tetuk do inggu temak. Tehuu hatahori mana tao tungga Manetualain hohoro-lalanen lalaꞌen, boe ma ana nanori hatahori laen talo naa, neu ko Manetualain henggenee nalan dadi hatahori mana maena sosoak nai nusa tetuk do inggu temak. ");
INSERT INTO txq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mamahere neu Au! Ei muste leo-laꞌo no ndoos lena heni meser anggama ma hatahori partei Farisir raa. Mete ma taa, na, ei ta bisa maso dadi miu Manetualain hatahorin.” ");
INSERT INTO txq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ei bubuluk baꞌi Musa hohoro-lalanen fo nafada memak kana neu ita bei-baꞌin nara ena nae, ‘Boso makanisa hatahori, te see nakanisa hatahori, neu ko ana hambu hukun.’ ");
INSERT INTO txq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tehuu Au ae afada talo ia: esa boso namanasa esa, te see namanasa ndia toranoon, neu ko ana hambu hukun. Hatahori mana nahuur mbali toranoon nae, ‘O uten leo kea!’ neu ko hatahori naa, muste neu nasare nai lasi anggamar matan. Ma hatahori mana mboka babalik ndia toranoon nae, ‘Nggoa bebek, ee!’, neu ko ana hambu hukun nai aꞌi mbila ta kala matek dale. ");
INSERT INTO txq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Dadi mete ma o muni fefeek soa-neu Manetualain, tehuu o masaneda mae, hambu o toranoom bei namanasa o, ");
INSERT INTO txq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na, boso mbeda o fefeem naa neu dei. Muu fo mole-dame mua o toranoom dei, basa naa dei fo o muu mbeda o fefeem soa-neu Manetualain. ");
INSERT INTO txq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mete ma hambu hatahori rae radedeꞌa ro o, na, malole lenak o muu maote lai-laik fo mole-dame muan dei. Mete ma taa, na, neu ko hatahori naa leꞌa no o, fo muu masare mbali mana maketu-maladi dedeꞌak. Boe ma mana maketu-maladi dedeꞌak loo lima o muni pulisi muu, de ara sese o muni bui dale muu. ");
INSERT INTO txq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Au kokolak tetebes ia! Neu ko o leo makandoo muu bui dale, losa bae maketu basa o hutam lalaꞌen.” ");
INSERT INTO txq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ei bubuluk baꞌi Musa hohoro-lalanen mana nae, ‘Boso hohongge.’ ");
INSERT INTO txq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tehuu Au ae afada talo ia: hatahori mana botik matan fo mete-nita inak esa, boe ma dalen hii nalan seli nae sunggu-soro nakabua noon, na, touk naa hohongge no inak naa nai dalen dale ena. ");
INSERT INTO txq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mete ma o tao salak munik o mata konam, na, doꞌi henin leo. Malole lenak o maso muni nusa tetuk do inggu temak muu, muni kada o matam esak ka lena heni ara nggari o muni aꞌi mbila ta kala matek muu, mua o mata deꞌem dua sara. ");
INSERT INTO txq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma mete ma o tao salak munik o lima konam, na, tete heni limak naa leo. Malole lenak o maso muni nusa tetuk do inggu temak muu, muni kada o limam esak ka lena heni ara nggari o muni aꞌi mbila ta kala matek muu, mua o limam dua sara.” ");
INSERT INTO txq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ei bubuluk baꞌi Musa hohoro-lalanen ena nae, ‘Hatahori mana namaketu no sao inan, na, ana muste fee inak naa susura nemeketuk.’ ");
INSERT INTO txq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tehuu Au afada talo ia: mete ma hambu hatahori namaketu no sao inan, naa te sao inan bei ta laꞌok sala nita no touk laen, boe ma inak naa sao seluk, na, naa sama leo sao touk makasososan, ndia tao inak naa hohongge-lelena. Mete ma hambu touk sao nala inak esa fo saon elan ena, na, dua sara oo hohongge-lelena naa ena boe.” ");
INSERT INTO txq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ei bubuluk baꞌi Musa hohoro-lalanen ena fo ana nafada neu ita bei-baꞌin nara nae, ‘Mete ma o soꞌuk hehelu-bartaak pake sumba-sook no Manetualain naden, na, o makaesa mua hehelu-bartaak naa ena.’ ");
INSERT INTO txq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tehuu Au afada talo ia: mete ma o soꞌuk hehelu-bartaak, na, boso pake sumba-sook. Boso sumba-soo pake nusa tetuk do inggu temak naden, nahuu nusa tetuk do inggu temak naa, Manetualain mamana leleon. ");
INSERT INTO txq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Boso sumba-soo pake dae-inak naden, nahuu dae-inak naa Manetualain ei tatabun. Ma boso sumba-soo pake Yerusalem naden, nahuu Yerusalem naa, Mane Ina-huuk kotan. ");
INSERT INTO txq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Boso sumba-soo pake ei langgam. Te ei ta maena koasa fo parenda ei langga bulu doom esa fo bisa dadi nggeok do mutik. ");
INSERT INTO txq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Dadi mete ma ei mae soꞌuk hehelu-bartaak mae, ‘hou’, na, mafada mae, ‘hou’ a leo. Tehuu mete ma ‘taa’, na, mae, ‘taa’ a leo. Mete ma ei kokolak lenak numa naa mai, na, naa naoka nai nitu dale ena.” ");
INSERT INTO txq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ei bubuluk baꞌi Musa hohoro-lalanen ena nae, ‘Mete ma hatahori tao nakalutu o matam, na, balan tao makalutu matan boe. Mete ma hambu hatahori tao namoꞌu heni o nisim, na, balan tao mamoꞌu heni nisin boe.’ ");
INSERT INTO txq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tehuu Au afada talo ia: boso bala manggarauk no manggarauk. Mete ma hatahori famba o nasum seri, na, elan numa naa fo ana famba o nasum seri bali. ");
INSERT INTO txq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mete ma hambu hatahori nae nadedeꞌa no o, fo nae haꞌi nala o badum, na, fee o jeket neun bali. ");
INSERT INTO txq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mete ma soldadu esa nakasetik o fo luꞌa-lemba ndia bua-baꞌun laꞌok kilo esa, na, lemba malan makandoo losa kilo dua. ");
INSERT INTO txq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mete ma hambu hatahori noke o buam hata a mesan, na, feen neu leo. Ma mete ma hatahori nae pindan o buam hata a mesan, na, feen neu leo.” ");
INSERT INTO txq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ei mamanene hatahorir rae, ‘Sue-lai neu o toranoom, ma mburuk neu hatahori mana mburuk neu o.’ ");
INSERT INTO txq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tehuu Au afada talo ia: o muste sue-lai neu hatahori mana mburuk neu o. Ma moke-hule fo Manetualain fee babaꞌe-babatik soa-neu hatahori mana tao doidosok neu o. ");
INSERT INTO txq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mete ma o tao talo naa, na, o matudu mae, o ia, Amak manai nusa tetuk do inggu temak anan. Huu Ana tao ledo nasaꞌa soa-neu hatahori neulauk, ma Ana oo tao ledo nasaꞌa soa-neu hatahori manggarauk boe. Ana oo nakonda udan soa-neu hatahori mana tao tungga Ndia parendan, sama-sama ro hatahori mana laban Ndia parendan boe. ");
INSERT INTO txq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Dadi mete ma o sue neu kada hatahori mana sue o, na, o duꞌa mae, Manetualain muste balan no fee o babaꞌe-babatik, do? Taa! Te hatahori manggarauk oo sue sira nonoon mana sue neu sara boe. ");
INSERT INTO txq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mete ma o kada kokolak soda-molek neu o nonoom, na, lenan hata? Te hatahori ta kamaherek neu Manetualain oo tao talo naa boe. ");
INSERT INTO txq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dadi masaneda, ee! O Amam manai nusa tetuk do inggu temak sue-lai neu basa hatahorir. Huu naa de o muste tao tungga talo naa boe!” ");
INSERT INTO txq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesus fee nenorik nakandoo nae, “Masaneda, ee! Boso tungga doꞌo-doꞌo mia anggama hohoro-lalanen, fo kada nau sangga hatahorir koa ei. Te mete ma ei tao talo naa, na, ei Amam manai nusa tetuk do inggu temak, ta fee ei seseba-babaek hata esa boe na. ");
INSERT INTO txq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mete ma ei nau tulu-fali hatahori kasian nara, na, boso miu tui leli-belak kana nai bee a mesan. Te mete ma ei tao talo naa, na, ei sama leo hatahori mana kokolak laen, tao laen ena. Ara soa reu laꞌo-laꞌo nai uma huhule-haradoik, mita fo hatahorir koa sara rae, ‘Awii, hatahori ia, ta hohoꞌak!’ Au kokolang ia ndia tetebes! Huu no hambu kokoak talo naa, ara simbo rala sira seseba-babaen ena. ");
INSERT INTO txq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dadi mete ma ei mae tulu-fali hatahori kasian nara, na, boso mafada see a mesan, ee! ");
INSERT INTO txq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","No dalak naa, hatahori manai dae-bafok ia ta bubuluk. Tehuu ei Amam manai nusa tetuk do inggu temak ndia bubuluk hata fo ei taon no neneek naa. Neu ko Ana bala ei menik babaꞌe-babatik noꞌun seli.” ");
INSERT INTO txq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Neu ei hule-haradoi, na, boso tao aom mara sama leo hatahori mana kokolak laen, tao laen. Ara soa reu laꞌo-laꞌo nai dala rame, ma rambariik rai uma huhule-haradoik, mita fo hatahori noꞌuk kara mete-rita ma koa sara rae, ‘Awii! Sira iar, hatahori malalaok!’ Tehuu nenene, ee! Huu no hambu kokoak talo naa, de ara simbo rala sira seseba-babaen ena. ");
INSERT INTO txq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tehuu ei ta bole talo naa. Mete ma ei hule-haradoi, na, maso meni kama dale miu dei. Basa naa, nggoe lelesu, dei fo ei hule-haradoi mbali ei Amam no neneek. Leo mae hatahori laen ta mete-rita, tehuu ei Amam mete-nita. Neu ko Ana bala ei no babaꞌe-babatik noꞌun seli. ");
INSERT INTO txq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mete ma ei hule-haradoi, na, boso kokolak maputak miu-mai. Hatahori ta mana malela Manetualain oo bisa hule-haradoi talo naa boe. Ara duꞌa rae, Manetualain hii nenene huhule-haradoin nara fo mana lolola naruk naa. ");
INSERT INTO txq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Boso tao tungga sama leo sira, ee! Te mae ei bei ta moke hata-hata neu Amak manai nusa tetuk do inggu temak, tehuu Ana bubuluk memak hata fo ei toꞌak ena. ");
INSERT INTO txq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dadi mete ma hule-haradoi, na, pake netuduk talo ia: ‘Amak manai nusa tetuk do inggu temak! Amak naden malalaok mateꞌen. Naa fo basa hatahorir rakadedemak Amak naden ta neni babanggak. ");
INSERT INTO txq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Naa fo Amak dadi Manek soa-neu basa hatahorir! Naa fo basa hatahorir tao tungga Amak parendan nai dae-bafok ia, sama leo Amak atan nara tao tungga Amak parendan nai nusa tetuk do inggu temak. ");
INSERT INTO txq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Amak tulun fee ai nanaꞌak mana daik tungga faik. ");
INSERT INTO txq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ai moke-hule Amak koka heni ai sala-singgon nara, sama leo ai oo lilii heni basa hatahorir salan fo ara tao neu ai boe. ");
INSERT INTO txq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Amak, manea fo ai ta tao manggarauk. Ma tao masoi-masoda ai numa nitu koasan mai. Huu Amak ndia, Manek mana maena koasa mateꞌen ma ta neni babanggak. Amak mana toꞌu parenda seku neu. Ai huhule-haradoin talo kada naa, Amak. Amin.’ ");
INSERT INTO txq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tehuu masaneda, ee! Mete ma ei lilii heni hatahori salan neu ei, neu ko ei Amam manai nusa tetuk do inggu temak oo koka heni ei sala-singgom mara boe. ");
INSERT INTO txq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tehuu mete ma ei ta nau lilii heni hatahorir salan neu ei, neu ko ei Amam oo ta koka heni ei sala-singgom mara boe.” ");
INSERT INTO txq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mete ma ei hule-haradoi ma puasa, na, boso tao idu-matam mara mana sunda-lukak sama leo hatahori mana kokolak laen, tao laen. Ara tao talo naa, mita fo hatahorir koa sara rae, ‘Awii! Sira iar, hatahori malalaok!’ Tehuu nenene, ee! Huu no hambu kokoak talo naa, de ara simbo rala sira seseba-babaen ena. ");
INSERT INTO txq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mete ma ei puasa, na, marou idu-matam mara lao-laok, ma sau malole langga bulum mara! ");
INSERT INTO txq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Dadi, neu ko hatahorir mete-rita ei, ara ta bubuluk rae, ei puasa. Tehuu ei Amam ndia bubuluk. Neu ko Ana bala fee ei babaꞌe-babatik noꞌun seli.” ");
INSERT INTO txq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Boso maue-osa fafandek lima-eim mara fo maduduru hata-heto noꞌun seli nai dae-bafok ia. Te fufuk no rutu raꞌa heni sara. Ma naꞌo manu-meo oo mai ofe uma fo baꞌu neni sara boe. ");
INSERT INTO txq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tehuu malole lenak maue-osa fafandek lima-eim mara fo maduduru hata-heto noꞌun seli nai nusa tetuk do inggu temak. Te nai naa fufuk no rutu ta bisa rakalulutu sara. Ma naꞌo manu-meo oo ta bisa mai ofe uma fo baꞌu neni sara boe. ");
INSERT INTO txq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ei mbeda hata-hetom nai bee, neu ko ei dalem mara oo rakadite nai naa boe.” ");
INSERT INTO txq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Hatahori matan, sama leo lambu tao nanggaledo ndia dalen. Mete ma matan manggaledok, na, ana tungga eno-dala masoda malole, sama leo hatahori laꞌok nai manggaledok dale. ");
INSERT INTO txq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tehuu mete ma ndia matan kiu-habu, na, ana ta tungga eno-dala malole, sama leo hatahori laꞌok nafaroroe a nai makiuk dale. Dadi mete ma manggaledok manai ei dalem naa dadi makiuk ena, na, ei oo leo-laꞌo nai makiuk dale boe.” ");
INSERT INTO txq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Hatahori ta bisa naue-osa tebe-tebe soa-neu malanggan dua, nahuu neu ko ana hii malanggan esa, lena heni malanggan laen. Boe ma ana bisa tungga malanggan esa, tehuu ana ta tao matak neu malanggan laen. Huu naa de o ta bisa kokolak mae, ‘Lamatuak naa, ndia naena haak fo parenda au,’ mete ma o tao doik dadi neu o malanggam ena. ");
INSERT INTO txq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Huu naa de Au afada talo ia: boso masambute mia duduꞌak, au ae asoda talo bee, au ae uꞌa hata, inu hata, pake hata? Ei duꞌa mae, masodak naa, kada ndia naꞌa-ninuk mesa kana, do? Ma ao-inak naa, kada soa-neu pake bua-loꞌas mesa kana, do? Ta talo naa. ");
INSERT INTO txq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mete sudik mbuik mana lambuk kara rai lalai naa. Ara ta rasambute sele-tande do ketu-koru fo rahinda nanaꞌak nai soka-pole. Tehuu ei Amam manai nusa tetuk do inggu temak nakaboi-nasamao sara rakandoo. Neu ko Ana bisa nakaboi-nasamao ei lena heni basa mbuik kara raa. Dadi duꞌa matalolole dei. Ana timba-tai ei lena heni mbuik kara raa. ");
INSERT INTO txq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mete ma hatahori nambariik nai titiro matan, boe ma ana nasambute no ao heli-helin, ana bisa tao nadema ao-inan, do? Ta bisa! ");
INSERT INTO txq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mete ma taa, na, tao hata de ei masambute fo duduꞌa laꞌe-neu bua-loꞌas bali? Miu mete sudik bungga bakung manai mook. Ara ta lolo abas, ma ta tenu temak. ");
INSERT INTO txq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tehuu nenene matalolole, ee! Manek Soleman bua-loꞌan mana mandela-masaꞌa lenak oo, ta bisa laban bungga raa lolen nara boe. ");
INSERT INTO txq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Manetualain dalen susuri-memete neu bungga fo nasoda kada faik ia, boe ma beꞌe-mai maten de hatahori nggarin neni aꞌi dale neu. Mete ma Ana tao talo naa, neu ko Ana oo heti ei lena heni bungga raa boe. Dadi ei muste mamahere tebe-tebe neun. ");
INSERT INTO txq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Huu naa de hae masambute duduꞌa mae, ‘Ai mae miꞌa hata?’ do, ‘Minu hata?’ do, ‘Pake hata?’ ");
INSERT INTO txq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hatahorir ta mana ramahere neu Manetualain, ara raue-osa fafandek lima-ein nara fo rae soba hambu basa naar lalaꞌen. Tehuu ei boso talo naa, huu ei Amam manai nusa tetuk do inggu temak bubuluk basa hata fo ei toꞌak kara ena. ");
INSERT INTO txq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tehuu ei muste makalalaꞌok makahuluk Ndia uen dei, ma muste tungga Ndia parendan dei, basa naa neu ko Ana fee tamba basa hata fo ei toꞌak. ");
INSERT INTO txq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Dadi boso masambute duduꞌa mia hata fo ei toꞌak beꞌe-mai. Huu beꞌe-mai hambu ndia totoꞌan laen bali. Faik ia susa-sonan mesa kana dai ena.” ");
INSERT INTO txq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ei boso makasasaꞌek salak neu hatahori, mita fo Manetualain ta nakasasaꞌek salak neu ei. ");
INSERT INTO txq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ei timba-tai hatahori talo bee, na, neu ko Manetualain oo timba-tai ei talo naa boe. Ei uku-sudi hatahori laen salan talo bee, neu ko Manetualain oo uku-sudi ei talo naa boe. ");
INSERT INTO txq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","O hii tanda hatahori sala kadiꞌi anan, tehuu o sala moꞌom, o taon leo bali ta maena salak. Naa, sama leo o mete-mita uꞌuk esa nai o nonoom matan, naa te hambu balo moꞌok natabaa nala o matam, tehuu o ta mameda sana. ");
INSERT INTO txq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Talo bee de o mambarani kokolak mae, ‘Tia-laik! Mai fo au nggai heni uꞌuk numa o mata deꞌem mai dei.’ Naa te o mesa ngga ta bisa mete-mita hata-hata, huu hambu balok natabaa nala o matam, na. ");
INSERT INTO txq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Woi! O ia, memak hatahori mana dea-matak tebe-tebe! Tulun dei! Piru heni balok naa numa o mata heli-helim mai, dei fo o bisa mete-mita, de tulu-fali mala o nonoom fo nggai heni uꞌuk numa o nonoom naa matan mai. ");
INSERT INTO txq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Boso fee nenorik dedeꞌa malalaok laꞌe-neu Manetualain, fee hatahori mana makatitiik. Te sira raa, sama leo busa kakikik fo neu ko ara fali mai fo kiki ei. Sira oo nggoa bebek kara, sama leo bafi boe. Mete ma hatahori feen poemata mabeli, na, ana ta mbali sana. Ana kada roroo-tatabun.” ");
INSERT INTO txq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mete ma ei hule-haradoi, moke makandoo neu Manetualain; neu ko Ana fee. Mete ma ei sangga makandoo, neu ko Ana natudu dalak. Mete ma ei manggou makandoo; neu ko Ana soi lelesu. ");
INSERT INTO txq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Huu basa hatahorir fo mana roke rakandoo neu Manetualain, neu ko ara simbo. Mana sangga rakandoo, neu ko ara hambu. Mana ranggou rakandoo, neu ko Ana soi lelesu. ");
INSERT INTO txq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ei duꞌa sudik kana! Mete ma hambu kakanak fo noke roti, neu ko aman ta feen batu, hetu? ");
INSERT INTO txq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Do, noke iꞌak, aman ta feen mengge! ");
INSERT INTO txq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ei Amam manai nusa tetuk do inggu temak naa, memak neulaun seli. Dadi mete ma hatahori dae-bafok manggarauk matak leo ei ia, hii fee hata fo neulauk soa-neu ei anam mara, hata-bali ei Amam! Neu ko Ana fee hata fo ei mokek. ");
INSERT INTO txq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Dadi hata fo o nau hatahori laen taon fee o, na, o muste tao talo naa soa-neun boe. Huu dedeꞌak ia dadi neu oka-huuk numa basa hata fo baꞌi Musa no Manetualain mana toꞌu dedeꞌa laen nara fee nenorik memak kasa numa lele uluk mai ena.” ");
INSERT INTO txq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mete ma hatahori nae maso neni nusa tetuk do inggu temak neu, na, ana muste maso tungga lelesu makabiꞌak. Hambu dala mudak no lelesun loak boe, fo hatahori noꞌuk kara hii tunggan. Tehuu besa-besa, ee! Dalak leo naak ndia neni hatahori reni mamana aꞌi mbila ta kala matek reu, fo ara rabinggak ruma Manetualain mai. ");
INSERT INTO txq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Hatahori mana nae maso neni nusa tetuk do inggu temak neu, muste tungga dala manggataꞌak naa, ma maso lelesu makabiꞌak naa. Leo mae kada hatahori hidak ka laꞌok resik naa, tehuu dala makabiꞌak leo naak, neni hatahori reni Manetualain reu.” ");
INSERT INTO txq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Besa-besa mia mana pepeko-lelekok fo soꞌuk aon nara rae, sira iar Manetualain mana toꞌu dedeꞌan. Ara tao aon nara malole nok bali bibi lombo. Naa te sira raa manggarauk, nok bali busa fuir mana mai raꞌa bibi lombo. ");
INSERT INTO txq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Talo bee fo ei bisa malela hatahori mana dea-matak kara raa? Mete neu kada hata fo ara taok. Sama leo hatahori mete-rita ai boak, de ralela ai boak naa huun. Ai boa neulauk, ta dadi numa ai huuk ta neulauk mai. ");
INSERT INTO txq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ai huu neulauk naboa neulauk. Tehuu ai huu ta neulauk naboa ta neulauk. ");
INSERT INTO txq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ta hambu ai huu neulauk, naboa ta neulauk. Ma ta hambu ai huu ta neulauk naboa neulauk. ");
INSERT INTO txq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ai huu mana naboa ta neulauk, neu ko ara mai hungga henin fo nggarin neni aꞌi dale neu. ");
INSERT INTO txq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Leo naak oo, no mana toꞌu dedeꞌak mana dea-matak kara raa boe. Ei bisa malela sara numa sira tatao-nonoꞌin nara mai.” ");
INSERT INTO txq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Neu ko hambu hatahorir ranggou Au rae, ‘Lamatuak!’, fo mana maena haak parenda neu sara. Tehuu sira iar, raseseik nai kada bifi doon nara. Neu ko Manetualain manai nusa tetuk do inggu temak piru-nggari heni sara. Kada hatahori mana tungga no tebe-tebe Manetualain hihii-nanaun, ndia Ana simbok kana dadi neu Ndia hatahorin. ");
INSERT INTO txq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Neu dae-bafok fai mateꞌen, hatahori noꞌuk ka manaku rae, Au ia ndia aena haak parenda neu sara. Ara kokoe Au rae, ‘Lamatuak, ee! Ai miu tui-bengga tao matanggela Lamatuak nenorin ena. Ai oo husi nitur pake Lamatuak naden boe. Ma ai tao tanda heran mata-matak kara pake Lamatuak koasan.’ ");
INSERT INTO txq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Leo mae ara kada kokoe Au talo naa, tehuu neu ko Au aselu sara ae, ‘Eir ia, see? Au ta alela ei, ei ta leo-laꞌo tungga Manetualain hihii-nanaun. Dadi malai heok laꞌo ela ia leo!’ ” ");
INSERT INTO txq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Hatahori mana mai nenene Au, boe ma tao tungga Au kokolang, ndia naa sama leo hatahori malelak, fo nambaririik uman nai batu fanderen lain. ");
INSERT INTO txq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Doo-doo boe ma uda moꞌok konda losa faa lala mai. Ani makarumbuk oo, mai fumbu babalik uma naa boe. Tehuu uma naa ta ndefa heni sana, nahuu nambariik nai batu fanderen matea lain. ");
INSERT INTO txq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Hatahori mana mai nenene Au, tehuu ana ta tao tungga Au kokolang, ndia naa sama leo hatahori nggoa bebek fo nambaririik uman nai sarakaek lain. ");
INSERT INTO txq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Doo-doo boe ma uda moꞌok konda losa faa lala mai. Ani makarumbuk oo, mai fumbu babalik uma naa boe. De uma naa ndefa henin losa nakalulutu.” ");
INSERT INTO txq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus kokolak basa talo naa, boe ma basa hatahorir heran bali-bali ramanene Ndia nenorin, ");
INSERT INTO txq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","huu Ana bubuluk tebe-tebe nenorik naa isin. Ndia fefee nenorin naa, ta sama no sira meser anggaman nara. ");
INSERT INTO txq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus konda numa letek mai, boe ma hatahori noꞌuk ka rame-rame reu fo tunggan. ");
INSERT INTO txq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Medak neu ma, hambu hatahori hedi kusta esa mai nasare mbalin. Ana sendek luu-langgan fo noke tulu-falik neu Yesus nae, “Lamatuak, ee! Tulu-fali au dei! Mete ma Lamatuak nau, na, Lamatuak bisa mamopo au heding ia, mita fo hatahori boso nunute au bali, boe ma au bisa hule-haradoi seluk nai uma huhule-haradoik dale.” ");
INSERT INTO txq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesus namanene nala naa, boe ma Ana loo liman de nafaroe neu hatahori kusta naa, ma kokolak nae, “Au nau a mesan! O hai leo!” Medak neu ma, hatahori naa hedin mopon tutik ka. ");
INSERT INTO txq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Boe ma Yesus nafadan nae, “Masaneda, ee! O hai ena, tehuu ta bole mafada esa boe na. O muste tungga baꞌi Musa hohoro-lalanen dei. Dadi muni malangga anggama muu fo ana parisa o ao-inam, mita fo ana bubuluk o hedim mopon tebe-tebe ena, do beik. Boe ma o muste muni o fefeem tanda makasi fo basa hatahorir bubuluk rae, o hai tebe-tebe ena.” ");
INSERT INTO txq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Basa boe ma Yesus maso neni nggorok Kapernaum neu. Nai naa, hambu komedan soldadu Roma esa mai noke tulu-falik nae, ");
INSERT INTO txq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Papa, ee! Au ana mana maue-osang esa namahedi berak nai uma. Ana ta bisa nambadeik laꞌo ela mamana susunggun, de ana doidoso nalan seli.” ");
INSERT INTO txq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus naselu nae, “Malole! Dei fo Au uu tao ahain.” ");
INSERT INTO txq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tehuu komedan naa nae, “Papa! Papa hae makamamangguk aom fo mai bali, huu au ta andaa simbok Papa nai au umang. Sadi Papa kada kokolak numa ia mai leo, neu ko au ana mana maue-osang naa, hai tutik kana. ");
INSERT INTO txq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Au bubuluk dalak ia, nahuu au malanggang naena koasa fo parenda au. Ma au oo aena koasa fo parenda au soldadung nggara boe. Mete ma au parenda au ana nuning ae, ‘Muni naa muu!’ Neu ko ana neu. Mete ma au ae, ‘Ia mai!’ Neu ko ana mai boe. Mete ma adenu au hatahori mana maue-osang ae, ‘Tao ia!’ Neu ko ana tao talo naa. De sadi Papa kada kokolak, neu ko au ana mana maue-osang naa, hai tutik kana.” ");
INSERT INTO txq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus namanene nala naa, boe ma Ana heran. Ana kokolak neu hatahori noꞌuk kara mana tunggan nae, “Heran, ee! Doo basa ia, Au bei ta atonggo ita hatahori Yahudi esa boe na, fo nemeheheren matea sama leo hatahori Roma ia! ");
INSERT INTO txq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nenene, ee! Neu ko hambu hatahori feꞌek noꞌuk ka sama leo hatahori Roma ia ruma dulu mai, ma ruma muri mai. Ara mai fo ranggatuuk raꞌa feta sama-sama ro baꞌi Abraham, baꞌi Isak ma baꞌi Yakob nai Manetualain uman nai nusa tetuk do inggu temak. ");
INSERT INTO txq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Leo mae Manetualain here nala hatahori Yahudir fo dadi reu Ndia hatahorin, tehuu hambu noꞌuk ka ta tao matak neu sana. Neu ko Ana timba heni sara reni mamana makiu-makahatuk dale reu. Nai naa, ara buꞌi rakarereu ma doidoso ralan seli.” ");
INSERT INTO txq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesus kokolak basa talo naa, boe ma nafada komedan naa nae, “Ama fali leo. Huu ama ana mana maue-osan naa hai ena, sama leo ama nemeheheren.” Ndaa no hatematak naa, kanak naa hai tutik kana. ");
INSERT INTO txq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Laꞌe esa, Yesus neni Petrus uman neu. Ana mete-nita Petrus ari-inan sunggu nai mamana susungguk lain, huu ana sumai. ");
INSERT INTO txq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus toꞌu nala liman, boe ma ina lasik sumain mopon tutik ka. De ana nambadeik neu nalalau Yesus asa. ");
INSERT INTO txq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Neu ledo sangga tesa, boe ma hatahorir mai reni sira hatahorin fo nitu saꞌek kara. De Yesus parenda nitur raa nae, “Weeh, nitu! Malai heok laꞌo ela hatahorir ia leo!” Boe ma nitur raa ralai tutik ka. Ana oo tao nahai basa hatahori hedis sara boe. ");
INSERT INTO txq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ana tao basa iar, tungga hata fo Manetualain mana toꞌu dedeꞌan Yesaya surak memak kana nae, “Ana tao nahai ita hedin nara. Ma Ana nasaa nala ita doidoson.” ");
INSERT INTO txq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Basa naa, Yesus mete-nita hatahori noꞌuk ka mai eko ralan. Boe ma Ana nadenu ana nunin nara nae, “Mai fo ita saꞌe ofak teni dano boboan seri teu.” ");
INSERT INTO txq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Boe ma hambu meser anggama esa mai kokolak nae, “Papa Meser! Papa neni bee neu a mesan, na, au ae tungga akandoo ua Papa!” ");
INSERT INTO txq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tehuu Yesus naselu nae, “Malole, boe! Tehuu masaneda talo ia. Basa hatahorir ma banda-manur kamamana leleo-luluꞌuk mesan. Busa fui fali neni ndia bolo luluꞌun neu. Mbuik fali neni ndia ndunun neu. Tehuu Au, Hatahori Dae-bafo Isi-isik ia, ta aena uma heli-heling fo fali uni naa uu. Mamana ndae langgak neu oo, ta hambu boe.” ");
INSERT INTO txq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Boe ma hatahori laen esa bali, fo mana tungga-tungga no Yesus mai noke nae, “Lamatuak! Au nau tungga Lamatuak, tehuu elan fo au fali fo faduli ina-amang nggara dei. Mete ma au amang maten ena, na, dei fo au tungga.” ");
INSERT INTO txq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Boe ma Yesus kokolak nae, “Talo ia! Elan numa naa fo hatahorir ta mana ramahere neu Manetualain, ara rafafaꞌu sira hatahori mana maten. Tehuu mete ma o mae tungga Au, na, o muste tungga no tebe-tebe!” ");
INSERT INTO txq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Basa boe ma Yesus hene neni ofak lain neu sama-sama no Ndia ana nunin nara. ");
INSERT INTO txq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Neu ara saꞌe ofak reni dano boboan seri reu, boe ma Yesus sunggu. Ta dook ka boe ma ani makarumbuk mai. Rii tufa reu-mai, de oe lala neni ofak dale neu. ");
INSERT INTO txq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yesus ana nunin nara mete-rita naa, boe ma ara fafaen rae, “Lamatuak! Lamatuak, ee! Mambadeik fo fali mala ai dei! Te ita sangga molo mate ia ena!” ");
INSERT INTO txq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Boe ma Yesus naselu nae, “Heeh, tao hata de ei mamataꞌu!? Ei ta mamahere Au, do?” Boe ma Ana nambadeik. De Ana kaꞌi anin ma rii naa nae, “Hahae leo!” Boe ma rii no anin lende tutik kana leo. ");
INSERT INTO txq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yesus ana nunin nara heran. Ara kokolak rae, “Awii! Ndia ia see, ee? Talo bee de Ana bisa parenda anin no rii fo tungga Ndia hihii-nanaun?” ");
INSERT INTO txq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ta dook ka boe ma, ara losa dano tatain seri nai hatahori Gadara nusan. Numa naa, hambu hatahori fo nitu saꞌek dua, ara leo rai lua batu mamana hatahori mates. Sira raa, manggaraun nara seli, de ta hambu hatahori esa boe na nambarani laꞌok nesik naa. Ara mete-rita Yesus mai, ");
INSERT INTO txq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","boe ma ara eki rae, “Wooi, Manetualain Anan! Tao hata de O mai pode-ura babalik ai? Leo mae fain fo sangga huku-doki ai bei ta losa, tehuu O mae tuni-ndeni ai ena.” ");
INSERT INTO txq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Deka-deka no mamanak naa, hambu bafi noꞌuk ka sosoka dae sangga nanaꞌak. ");
INSERT INTO txq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Boe ma nitur raa roke-hule neu Yesus rae, “Mete ma O nau husi ai, na, madenu ai maso meni kada bafir raa dale miu!” ");
INSERT INTO txq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","De Yesus parenda sara nae, “Miu leo!” Basa naa, nitur raa kalua laꞌo ela hatahori kaduak kara raa, de maso reni bafir raa dale reu. Bafir raa ralaik ralenggu-pikok, boe ma ara tuda tungga mbiak tatain reni dano dale reu. De basa sara mate rasamele. ");
INSERT INTO txq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mana manea bafir mete-rita mandadik naa, boe ma ara ralaik fali reni nggorok reu, de ara tui basa-basan. ");
INSERT INTO txq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hatahori noꞌuk kara ramanene rala tutuik naa, boe ma ara kalua reni mamanak naa reu. Ara ratonggo ro Yesus, de ara kokoen nakandoo fo Ana laꞌo ela sira mamanan. ");
INSERT INTO txq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Basa naa, Yesus asa saꞌe falik ofak fo reni dano boboan seri reu, de ara losa kota Kapernaum, Ndia mamana leleon. ");
INSERT INTO txq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Numa naa, hambu hatahorir ndoro reni sira nonoon keko-luꞌuk neni Yesus neu. Yesus mete-nita naa, boe ma Ana bubuluk ara ramahere reu Ndia rae, Ndia bisa tao nahai sira nonoon naa. Huu naa de Ana kokolak neu hatahori keko-luꞌuk naa nae, “Ana nggee! Matetea o dalem dei! Au koka heni o sala-singgom mara ena.” ");
INSERT INTO txq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tehuu hambu meser anggama Yahudir hida ruma naa, ara ramanene Yesus kokolan naa. Boe ma dalen nara rakasuka tutik kana. De ara rakokola aok rae, “Hatahori ia nambarani nalan seli kokolak talo naa! Kada Manetualain mesa kana bisa fee ambon hatahori sala-singgon. Tehuu hatahori ia kokolan naa, tao aon sama leo ndia ia, Manetualain. Ana nakadadaek naa ena!” ");
INSERT INTO txq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tehuu Yesus bubuluk dale kuru-eron nara. De Ana kokolak nae, “Tao hata de ei duꞌa mae, Au ia kokolak akadadaek? ");
INSERT INTO txq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bee ndia mudan lenak? Mete ma Au afada hatahori keko-luꞌuk ia ae, ‘O sala-singgom hambu ambon ena,’ do, Au ae, ‘Mambadeik leo, fo fali muu ngga.’ ");
INSERT INTO txq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mete ma ana nambadeik tutik kana, dei fo ei mete-mita bukti mae, Au ia, Hatahori Dae-bafo Isi-isik. Au aena haak fo fee ambon neu hatahori sala-singgon.” Boe ma Yesus parenda hatahori keko-luꞌuk naa nae, “Mambadeik leo! Luꞌa mala o lalanggam fo laꞌok fali muu ngga leo!” ");
INSERT INTO txq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Boe ma hatahori keko-luꞌuk naa nambadeik, de ana laꞌok fali neu ngga. ");
INSERT INTO txq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Neu basa hatahorir mete-rita naa, boe ma ara heran. De ara rakadedemak Manetualain naden rae, “Manetualain naa, ta neni babanggak! Ana fee koasa moꞌok talo ia neu hatahori dae-bafok ena.” ");
INSERT INTO txq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Basa naa, Yesus laꞌo numa naa mai, boe ma Ana mete-nita hatahori mana susu bea esa, tao ues nai uma sususu bea. Naden Mateos. De Yesus noke nalan nae, “Mai fo tungga Au!” Mateos namanene nala naa, boe ma ana nambadeik fo tunggan tutik kana. ");
INSERT INTO txq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Basa de Mateos noke Yesus fo mai naꞌa nai ndia uman. Ana oo noke ndia nonoo mana susu bean nara, ma fuik laen nara boe, fo mai raꞌa sama-sama roo sara. ");
INSERT INTO txq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tehuu hambu hatahori hida ruma partei Farisi mai unggu-remu reu Yesus ana nunin nara rae, “Tao hata de ei mesem nanggatuuk naꞌa sama-sama no hatahori papake taak kara, sama leo mana susu bear raa, ma sira nonoo manggaraun nara?” ");
INSERT INTO txq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Boe ma Yesus nafada sara nae, “Hatahori kamahedik memak parluu doter. Tehuu hatahori bee fo sodak ena, ta parluu. ");
INSERT INTO txq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Malole lenak ei fali miu ngga fo parisa matalolole Manetualain Dedea-kokolan, fo lele uluk Ana nadenu Ndia mana toꞌu dedeꞌan Hosea surak nae, ‘Au hihii-nanaung ndia, Au hatahoring nggara rasue-laik ma ratudu dale kasian esa no esa. Mete ma ara ta tao talo naa, na, sira tunu-hotun banda fo ara renin fee Au naa, nanalan ta faa boe na.’ Naa, ndia Manetualain nafada ena. Huu naa de Au ta mai fo faduli hatahori mana tao aon neulauk ena, tehuu Au mai fo faduli hatahori ta kambareek kara.” ");
INSERT INTO txq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Basa naa, Yohanis Mana Saranik ana nunin nara reni Yesus reu. Ara ratane rae, “Ai mana tungga Yohanis naa, masiꞌe puasa. Hatahori Farisir oo puasa boe. Tehuu tao hata de Papa ana nunin nara raꞌa-rinu rakandoo? Sira raa, ta ralela puasa, do?” ");
INSERT INTO txq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tehuu Yesus naselu sara pake lololek nae, “Talo ia: mete ma hambu feta kabin, fuik kara ta puasa, tehuu ara raꞌa losa rakabete. Mete ma baroit touk bei nai naa, neu ko basa sara raꞌa rame-rame. Tehuu neu laꞌe esa, mete ma hatahori laen humu reni baroit touk, boe ma ndia nonoon nara rameda susa, dei fo lelek naa ara puasa. ");
INSERT INTO txq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hatahori ta haꞌi rala tema beuk bibiak faa fo tandan neu badu raak mana sidak ena. Te mete ma safe badu naa, tema neni tanda beuk naa, neu ko ana kukundu. No dalak naa, badu raak naa sidan boe tamba. ");
INSERT INTO txq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Leo naak oo hatahori ta radai oe anggor beuk neni boboꞌik banda rou raak dale neu boe, te neu ko kadin ma ana sii sasarak, de oe anggor beuk naa mboꞌa henin. Dadi oe anggor beuk muste nadain neni boboꞌik banda rou beuk neu, fo dua sara rakatataka no neulauk.” No lololek naa, Yesus nanori sara nae Ndia nenorin naa, beuk. Dadi boso feen nabali no nenori raak. ");
INSERT INTO txq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Neu Yesus bei kokolak no Yohanis ana nunin nara, boe ma hambu malangga uma huhule-haradoik esa mai natonggo no Yesus. Hatahori naa sendek luu-langgan neu Yesus matan, de noke-hule nae, “Papa, ee! Tulun dei! Te au ana fetong dei fo maten. Papa tulun mai ndae limam neun dei, fo ana bisa nasoda fali numa mamaten mai.” ");
INSERT INTO txq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesus namanene nala naa, boe ma Ana no ana nunin nara tungga memak ro hatahori naa. ");
INSERT INTO txq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Neu ara bei laꞌok numa dalak, hambu inak esa laꞌo tungga sara. Ana hambu bulak ta tungga ndoon losa teuk salahunu dua ena. Ana duduꞌa nai dalen dale nae, “Sadi au bisa afaroe kada Yesus badun, neu ko au hai.” Huu naa de ana neu nafaroe Yesus badun suꞌun. ");
INSERT INTO txq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus nameda, boe ma Ana hekor aon de mete neu inak naa. Boe ma Ana kokolak nae, “Ana nggee! Matetea o dalem. Huu o mamahere tebe-tebe neu Au, de o hai ena.” Hatematak naa oo inak naa hai tutik kana boe. ");
INSERT INTO txq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Basa de Yesus asa laꞌok rakandoo reni malangga uma huhule-haradoik naa uman reu. Losa naa, boe ma Ana maso de mete-nita manahelo bini susa-sonak, ma hatahori noꞌuk ka buꞌi rakarereu. ");
INSERT INTO txq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Boe ma Yesus nafada sara nae, “Hahae bubuꞌik, fali miu ngga leo! Huu kakanak ia ta mate. Ana kada sunggu a.” Tehuu ara hika korombiꞌe bafan nara mbali Yesus. ");
INSERT INTO txq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Boe ma hatahorir raa, basa sara kalua. De Yesus maso neni kakanak naa kaman dale neu, ma toꞌu nala liman. Boe ma kakanak naa nasoda fali numa mamaten mai tutik kana. ");
INSERT INTO txq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hatahori mete-rita naa, boe ma ara mulai ratuik ndule sira nusan, laꞌe-neu hata fo Yesus taok naa ena. ");
INSERT INTO txq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Basa boe ma Yesus laꞌok nakandoo. Neu bei laꞌok numa dalak, hambu hatahori pokek dua tungga-tungga roon. Ara eki rae, “Mane Dauk tititi-nonosin, ee! Kasian neu ai dei!” ");
INSERT INTO txq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesus maso neni uma dale neu, boe ma hatahori pokek kaduak kara raa reni Yesus reu. De Ana natane sara nae, “Ei mamahere tebe-tebe mae, Au aena koasa fo tao ei bisa mete-mita?” Boe ma ara raselu rae, “Awii! Papa boso matane bali, te ai mamahere Papa tebe-tebe ena.” ");
INSERT INTO txq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesus namanene nala naa, boe ma Ana nafaroe matan nara, de kokolak nae, “Mete ma talo naa, na, ana dadi leo tungga ei nemeheherem naa!” ");
INSERT INTO txq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yesus kokolak basa talo naa, boe ma ara mete-rita tutik ka. Tehuu Yesus fee nesenedak maherek neu sara nae, “Masaneda, ee! Boso mafada hatahori esa boe na, hata fo mandadik ia ena!” ");
INSERT INTO txq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tehuu ara ta bisa rakataka rala aon nara. De ara laꞌok ndule nusak naa, fo tui ratanggela hata fo Yesus taok naa. ");
INSERT INTO txq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hatahori pokek kaduak kara raa kalua, boe ma hatahorir nuni roo hatahori laen esa neni Yesus neu. Hatahori naa, ta bisa kokolak, nahuu nitu saꞌen. ");
INSERT INTO txq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesus mete-nita naa, boe ma Ana parenda nitu naa kalua laꞌo ela hatahori naa. Nitu naa kalua, boe ma hatahori naa kokolak tutik kana. De hatahori noꞌuk kara marai naa, heran bali-bali. Ara rae, “Awii! Ita hatahori Yahudir bei ta mete tita mandadik leo iak ia!” ");
INSERT INTO txq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tehuu hatahori Farisir ta ramahoko. Ara kokolak rae, “Weeh! Nitur malanggan ndia feen koasa fo Ana bisa husi kalua nitur.” ");
INSERT INTO txq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Basa de Yesus laꞌok ndule kota ma nggorok noꞌuk ka, fo fee nenorik nai uma huhule-haradoik kara. Ana nanori hatahorir laꞌe-neu Manetualain Hara Lii Malolen, ma tao talo bee fo bisa maso dadi Ndia hatahorin. Ana oo, tao nahai hedis mata-matak kara, ma basa hatahorir fo ao-mbaan nara mana male-maꞌak kara boe. ");
INSERT INTO txq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesus mete-nita hatahori noꞌuk kara raa, boe ma Ana tuda kasian neu sara, nahuu ara ta bubuluk tao talo bee. Basa sara, sama leo bibi lombo fo mana lolo taak. ");
INSERT INTO txq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","De Yesus kokolak no Ndia ana nunin nara nae, “Hatahori noꞌuk kara ia, sama leo osi-lutu buna-boan. Leo mae buna-boan noꞌuk, tehuu hatahori mana maue-osa ta dai fo ketu-koru rala buna-boan nara raa, fo rambeda sara rai soka-poler dale. ");
INSERT INTO txq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Huu naa de ei muste moke Tenu osik fo Ana nadenu hatahori mana maue-osar, mita fo ara reu rakabubua rala Ndia osin buna-boan nara.” ");
INSERT INTO txq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Basa naa, Yesus nanggou nala Ndia ana nunin nara fo mai rakabua. Boe ma Ana fee sara koasa fo husi nitu ma tao rahai hatahori ruma sira hedi-raun mata-matak kara mai. ");
INSERT INTO txq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ana nuni kasalahunu duak kara fo Ana nadenu sara raa naden nara, sira: Kaesan, nade Simon (ara rasiꞌe roken rae, ‘Petrus’), ma fadin, nade Anderias, boe ma Yakobis, ma fadin, nade Yohanis (dua sara, Sabadeus anan). ");
INSERT INTO txq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Hambu Felipus boe, ma Bartolomeos. Tomas, ma Mateos (mana susu bea). Boe ma Yakobis (Alpius anan), ma Tadius. ");
INSERT INTO txq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Boe ma Simon (mana tungga Selot partei politin), ma Yudas Iskariot (fo neu ko ana ndia seꞌo heni Yesus). ");
INSERT INTO txq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Basa naa, Yesus nadenu Ndia ana nuni kasalahunu duan nara, ma Ana fee parenda nae, “Au adenu ei meni ita hatahori Yahudin nara miu, nahuu hambu noꞌuk ka ruma ita hatahorin nara mai, fo ta mana tungga tebe-tebe neu Manetualain eno-dalan. Sira raa, sama leo bibi lombo mana matarak. Huu naa de ei hae meni hatahori ta Yahudir miu, ndia leo hatahori Samariar. ");
INSERT INTO txq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Miu mafada ita hatahori Israꞌel asa mae, ‘Fain losa ena fo basa hatahorir bisa maso dadi reu Manetualain hatahorin.’ ");
INSERT INTO txq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Miu mahai hatahori kamahedik, tao masoda falik hatahori mates, mahai hatahori hedi kusta ma husi kalua heni nitu. Manetualain fee ei mana hetak ena, tehuu Ana ta noke falik hata esa boe na. Dadi hatematak ia, ei oo muste miu fo fee soa-neu hatahori laen boe no ei dale kateman ma hae moke falik hata esa boe na numa sira mai. ");
INSERT INTO txq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Miu meni kada lima roum mara, ee. Hae meni doik, ");
INSERT INTO txq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","lepa-nggees, bua-loꞌa ngganggatik, tabu eis, do teteꞌe ai. Hatahori muste fee hatahori mana maue-osa, hata ndia mandaak fo ara bisa rasoda. ");
INSERT INTO txq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mete ma ei maso meni kota esa dale miu, do nggorok esa, na, sangga hatahori mana nau simbok ei. Basa, na, leo miu naa, losa ei laꞌo ela mamanak naa. ");
INSERT INTO txq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mete ma ei maso meni hatahori uman miu, na, kokolak mae, ‘Soda-molek! Manetualain fee babaꞌe-babatik neu ei.’ ");
INSERT INTO txq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mete ma hatahori manai uma naa simbok nala ei no malole, na, moke-hule fo Manetualain fee babaꞌe-babatik neu sara. Tehuu mete ma ara ta simbok ei, Manetualain oo ta fee babaꞌe-babatik neu sara boe. ");
INSERT INTO txq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mete ma hatahori ta nau ramanene ei, na, kalua laꞌo ela uma naa, do kota naa, ma ngganggafu heni afu numa ei eim mara mai, fo dadi neu tanda nae, ara ta nau ramanene, na, sira mesa kasa lemba-rasaa sira neselu-netaan. ");
INSERT INTO txq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tehuu masaneda, ee! Mateꞌen, neu faik Manetualain naketu hukun soa-neu hatahori marai dae-bafok ia, neu ko Ana naketu hukun soa-neu hatahorir fo ta nau simbok ei nai kota naa beran lena heni hatahori Sodom ma Gomora, fo bakahulun manggaraun sudi selik kana!” ");
INSERT INTO txq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Masanenedak, ee! Huu Au adenu eir ia, sama leo Au haitua bibi lombo neni busa fui manggarauk taladan nara neu. Huu naa de, ei muste pake ute-dodolem sama leo mengge malelak fo tao neulauk. Ma ei dalem mara oo, muste ndoos sama leo mbui lunda sina fo ta mana sangga mbutes boe. ");
INSERT INTO txq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tehuu besa-besa, ee! Huu neu ko hatahori tuni-ndeni ei sama leo busa manggarauk kiki nakanisa bibi lombo. Neu ko ara leꞌa reni ei maso meni mamana parisa dedeꞌa anggama miu. Ma neu ko ara poko-femba ei nai sira uma huhule-haradoin nara. ");
INSERT INTO txq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Neu ko ara leꞌa roo ei miu masare nggubenor ma manek, nahuu ei tungga Au. Tehuu ei muste pake fai lelak naa, fo tui-bengga Au Hara Lii Maloleng neu sara. No dalak naa, hatahori ta mana nalela Lamatuak oo namanene laꞌe-neu Au boe. ");
INSERT INTO txq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tehuu mete ma ara leꞌa roo ei talo naa, na, ei hae mamataꞌu mae, ‘neu ko au kokolak ae, hata?’ Do, ‘neu ko au aselu ae, leo bee?’ Haen no duduꞌa talo naa, huu losa fain, neu ko ei Amam manai nusa tetuk do inggu temak nafada laꞌe-neu hata fo ei muste kokolak. ");
INSERT INTO txq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Faik naa, hata fo ei kokolak, ta naoka numa ei mesa ngga dalem mai, huu Manetualain Dula-dale Malalaon, ndia fee nenorik fo ei kokolak hata. ");
INSERT INTO txq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ei mete leo, huu neu ko nai uma esa dale, mete ma hambu hatahori namahere neu Au, mete te ndia toranoo heli-helin sangga dalak fo nakanisan. Mete ma kanak ndia namahere, neu ko aman ndia nakanisan. Mete ma aman no inan ndia ramahere, neu ko ana heli-helin nara ndia nakanisa sara. ");
INSERT INTO txq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Neu ko mateꞌen basa hatahorir mburuk ralan seli roo ei, nahuu ei tungga ma mamahere Au. Tehuu hatahori mana nakatataka losa babasan, Manetualain neu ko tao masoi-masodak soa-neun. ");
INSERT INTO txq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mete ma hatahorir tuni-ndeni ei nai kota esa, na, malai meni kota laen miu. Tebe, naa! Au ia, Hatahori Dae-bafo Isi-isik. Neu ko ei bei ta laꞌok ndule basa kotar marai Israꞌel, tehuu Au fali mai ena. ");
INSERT INTO txq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Hatahorir rasiꞌe fee hada-horomatak neu meser esa, lena heni ndia ana nunin nara. Ma hatahori fee hada-horomatak neu malanggan esa, lena heni ndia ana maue-osan nara. ");
INSERT INTO txq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mete ma ana nunik nanori fo malelan sama no ndia mesen ena, ana nameda dai ena. Ma mete ma ana maue-osa nanori fo malelan sama no ndia malanggan ena, na, ana oo nameda dai boe. Dadi masaneda, ee! Mete ma hatahori roke tenu uma rae, ‘O ia, Balsebul, ndia nitur malanggan!’ na, neu ko ndia uma isin oo, hambu nade pake taak lenak bali boe.” ");
INSERT INTO txq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Dadi ei hae mamataꞌu mia hatahori mana laban ei. Huu hata fo hatahori taon no nefufunik, neu ko basa hatahorir mete-ritan. ");
INSERT INTO txq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hata fo Au anori neu ei mesa ngga ena, neu ko ei muste miu mafada basa hatahorir. Ma hata fo Au afada ei no neneek, neu ko ei muste miu mafada ndule basa mamanak kara. ");
INSERT INTO txq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hae mamataꞌu hatahori dae-bafok, huu ara rala kada tao risa hatahori ao-inan, tehuu ta bisa rakalulutu hatahori samanen. Huu naa de, ei muste mamataꞌu neu Manetualain, huu Ana ndia naena koasa fo piru-nggari heni hatahori ao-inan ma samanen, neni tasi aꞌi mana mbila seku neu. ");
INSERT INTO txq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Dadi tao matea ei dalem mara. Hatahori seꞌo mbui litik nai pasar, belin kada baꞌu anan seli. Tehuu ta hambu esa boe na tuda neni daer neu fo maten, mete ma ei Amam manai nusa tetuk do inggu temak ta nakaheik kana. ");
INSERT INTO txq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ei Amam manai nusa tetuk do inggu temak oo, tao matak neu ei losa hata fo kadiꞌi anan seli boe. Ei langga bulu doom noꞌun hida nai ei langgam oo, Ana bubuluk ena boe. ");
INSERT INTO txq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dadi ei boso mamataꞌu! Manetualain timba-tai ei belin lena heni basa mbui litik kara raa lalaꞌen.” ");
INSERT INTO txq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Basa de Yesus kokolak bali nae, “Hatahori mana nambarani manaku nalela Au nai hatahori noꞌuk matan nai dae-bafok ia, neu ko Au oo manaku alelan nai Au Amang matan nai nusa tetuk do inggu temak boe ae, ‘Ndia ia, Au hatahoring.’ ");
INSERT INTO txq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tehuu hatahori fo mana laka nai hatahori noꞌuk matan nae, ndia ta nalela Au, neu ko Au oo afada Au Amang manai nusa tetuk do inggu temak ae, ‘Au ta alela hatahori ia boe.’ ” ");
INSERT INTO txq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ei boso duꞌa mae, Au mai uni mole-damek nai dae-bafok ia. Au mai fo tao hatahori dae-bafok esa laban esa. ");
INSERT INTO txq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Au uni dae-bafok ia mai, tungga hata fo Manetualain mana toꞌu dedeꞌan surak memak kana ena nae, ‘Neu ko ana touk laban ndia aman, ana inak laban ndia inan, ma feto-feuk laban ari-inan, ");
INSERT INTO txq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","te uma isin nara mesa kasa, esa namusuk no esa.’ ");
INSERT INTO txq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Dadi hatahori mana nau tungga Au tebe-tebe, ana muste sue-lai neu Au lena heni basa-basan; lena heni ina-aman, ma lena heni anan nara. Mete ma taa, na, hatahori naa ta nandaa dadi neu Au hatahoring. ");
INSERT INTO txq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Hatahori mana nau tungga Au, tehuu ta nau lemba-nasaa doidosok, ana ta nandaa dadi neu Au hatahoring. ");
INSERT INTO txq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Hatahori mana sadia mate nahuu tungga Au, neu ko ana hambu masodak nakandoo no Manetualain. Tehuu hatahori mana nau nasoda soa-neu kada ndia ao heli-helin, neu ko masodan naa, mopon neuk kana leo!” ");
INSERT INTO txq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Hatahori mana simbok ei no neulauk, ana oo simbok Au boe. Ma hatahori mana simbok Au, ana oo simbok Manetualain mana madenu Au boe. ");
INSERT INTO txq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hatahori mana simbok Manetualain mana toꞌu dedeꞌan, nahuu mana toꞌu dedeꞌak naa kokolak laꞌe-neu Lamatuak, neu ko Lamatuak balan sama leo Lamatuak bala mana toꞌu dedeꞌak esa. Ma hatahori mana simbok hatahori dale ndoos esa, nahuu hatahori naa tungga tebe-tebe Lamatuak hihii-nanaun, neu ko Lamatuak balan sama leo Lamatuak bala hatahori dale ndoos esa. ");
INSERT INTO txq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Hatahori mana simbok hatahori esa kadiꞌin seli, nahuu ana tungga Au, neu ko Lamatuak balan. Leo mae hatahori fee kada oe mutik nggalas esa oo, neu ko Manetualain ta lilii heni sana boe.” ");
INSERT INTO txq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Neu Yesus helu basa Ndia ana nuni kasalahunu duan nara raa, boe ma Ana laꞌok ndule nggorok kara marai nusak naa, fo nanori hatahori ma tui-bengga Manetualain Hara Lii Malolen. ");
INSERT INTO txq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lelek naa, Yohanis nai bui dale ena. Neu ana namanene basa hata fo Yesus taok ena, boe ma ana nadenu ana nunin nara reu ratane Yesus rae, ");
INSERT INTO txq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Manetualain helu-bartaa memak numa lele uluk mai ena nae, Ana nau nadenu Karistus mai fo tao masoi-masodak neu ita hatahori Yahudir. Papa ia, ndia Karistus, do? Do, ai muste mahani neu hatahori laen bali?” De ara reu ratane Yesus. ");
INSERT INTO txq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesus namanene nala naa, boe ma Ana naselu nae, “Ei mesa ngga mamanene ena ma mete-mita ena. De fali miu ngga fo tui kaꞌa Yohanis mae, basa-basan dadi ena tungga hata fo Manetualain mana toꞌu dedeꞌan Yesaya surak memak kana ena nae: ");
INSERT INTO txq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Hatahori pokek, mete-nita. Hatahori ei kekok, nambadeik laꞌo-laꞌo. Hatahori hedi kusta, dadi nambalao. Hatahori mbakek, namanene. Hatahori mates, nasoda fali numa mamates mai. Hatahori kasian, namanene Hara Lii Malole. ");
INSERT INTO txq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dadi talo ia: miu mafada kaꞌa Yohanis, neu ko ana naua mete ma namahere nakandoo neu Au. Neu ko Manetualain fee babaꞌe-babatik neu hatahori fo nemeheheren neu Au ta nanggenggo!” ");
INSERT INTO txq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Neu Yohanis ana nunin nara fali reu ngga, boe ma Yesus kokolak no hatahori noꞌuk kara laꞌe-neu Yohanis nae, “Neu faik ei miu sangga Yohanis numa mamana nees naa, ei duꞌa mae ei matonggo mia hatahori dae-bafok rupak leo beek? Ta bisa dadi ei miu matonggo hatahori mana noe-naꞌuk, nok bali milak mana mbeu neu-mai tungga kada anin! ");
INSERT INTO txq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma ta bisa dadi ei miu fo mete-mita hatahori mana pake bua-loꞌa mabeli, huu hatahori rupa leo naak, leo nai kada uma manek! ");
INSERT INTO txq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dadi ei miu mete-mita hatahori rupa leo beek nai naa? Ei duꞌa mae, ei miu sangga Manetualain mana toꞌu dedeꞌan? Tebe! Tehuu ndia ia, mana toꞌu dedeꞌak ta hohoꞌan lenak. ");
INSERT INTO txq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sama leo Manetualain Susura Malalaon surak memak laꞌe-neu Yohanis nae, ‘Nenene! Au adenu Au hatahoring, fo neu nasosoi dalak fee O.’ ");
INSERT INTO txq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nenene matalolole, ee! Nai dae-bafok ia, ta hambu hatahori esa boe na, ta hohoꞌan lena heni Yohanis. Tehuu numa basa hatahori dae-bafok mana manaku nita Manetualain dadi neu sira Manen, hatahori bakahitok mateꞌen oo, ta hohoꞌan lena heni Yohanis ena boe. ");
INSERT INTO txq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mulai numa Yohanis nakalalaꞌok ue-tataon losa hatematak ia, hatahori noꞌuk ka maso dadi reu Manetualain enan ena. Tehuu hambu ketuk duꞌa sala rae, ara muste ratati fo rakasetik hatahorir maso dadi reu Manetualain hatahorin. Ma hambu ketuk oo mana ratati laban Manetualain hatahorin boe. ");
INSERT INTO txq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Losa faik Yohanis Mana Saranik mamain, ita hatahori Yahudir tasiꞌe leo-laꞌo tungga baꞌi Musa ma Manetualain mana toꞌu dedeꞌan nara hohoro-lalanen. ");
INSERT INTO txq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Dadi mamahere neu kada Au leo! Yohanis naa, ndia Elia fo Manetualain mana toꞌu dedeꞌan nara rafada memak ndia mamain ena. ");
INSERT INTO txq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Dadi mana hii bubuluk muste mamanene matalolole, ee! ");
INSERT INTO txq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Au ae fee lololek fo ei bisa bubuluk, hatahori hatematak ia, hatahori dae-bafok rupak bee. Sira raa, sama leo kana anar mana nggua-nggua rai pasar. Ara kada eki ro nonoon nara rae, ");
INSERT INTO txq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Woi! Ai fuu sulik rame-rame, tehuu ei ta foti-lendo setelele. Boe ma ai soda sosoda susa-sonak, tehuu ei ta buꞌi mamatani.’ ");
INSERT INTO txq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Eir ia, sama leo kana kadiꞌi anak kara fo ta mana rameda dai ndoos. Neu Yohanis mai, ana hii puasa, ma ta ninu anggor. De hatahorir henggenee ralan rae, ‘Ndia nitu saꞌek!’ ");
INSERT INTO txq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tehuu hatematak ia Au, Hatahori Dae-bafo Isi-isik mai ena. Au ta puasa, ma Au inu anggor. Boe ma hatahorir henggenee rala Au rae, ‘Ndia ia, hatahori bare-naꞌo huun! Mana mafu kamberak bali! Ana neu natia-laik no mana susu bear! Partei esa no hatahori ta papake taak kara! Ta nalela aon bali!’ Tehuu ei tanda Au kokolang leo, ee! Manetualain malelan neni nitak nai Ndia hatahorin leleo-lalaꞌon.” ");
INSERT INTO txq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Basa naa, Lamatuak Yesus mulai nahara berak neu hatahorir mana leo rai nggorok hida. Ana tao tanda heran noꞌun lenak numa naa ena, tehuu ara ta nau laꞌo ela sira sala-singgon nara, fo tungga Manetualain eno-dala ndoon. ");
INSERT INTO txq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yesus nahara berak nae, “Ei hatahori Korasin ma hatahori Betsaida rein, ee! Besa-besa, ee! Neu ko ei hambu sosoek! Au tao tanda heran mata-matak kara numa ei matam mara, tehuu ei ta nau mamahere neu Manetualain. Naa te, eir ia hatahori Yahudir fo mana manaku malela Manetualain. Tehuu mete ma tanda heran nara raa fo Au taok kara numa ei nggorom, ara dadi rakahuluk nai kota Tirus ma kota Sidon ena, na, doo basa ia hatahorir marai naar sale dalen do tuke tein nara memak, ma laꞌo ela sira sala-singgon nara ena, fo tungga Manetualain. Ma sira oo pake bua-loꞌa sususak boe, ma tao afu neu langgan nara fo dadi tanda rae, ara fale dalen nara neu sira sala-singgon nara. Naa te, hatahori Tirus ma hatahori Sidon iar, ta hatahori Yahudir fo mana manaku ralela Manetualain. ");
INSERT INTO txq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tebe! Neu ko ei mete a leo! Mete ma Manetualain naketu basa hatahorir dedeꞌan nara, ei huku-dokim mara beran lena heni hatahori Tirus ma hatahori Sidon huku-dokin nara. ");
INSERT INTO txq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ei hatahori Kapernaum! Besa-besa, ee! Ei boso duꞌa mae, neu ko Manetualain soꞌu botik ei maso meni nusa tetuk do inggu temak miu. Taa! Neu ko Manetualain nggari ei meni aꞌi mbila ta kala matek miu! Mete ma tanda heran nara raa fo Au taok numa ei nggorom, dadi nakahuluk numa kota Sodom, na, Manetualain ta parluu nakalulutu kota manggarauk naa. Mete ma hatahori Sodom mara mete-rita tanda heran nara raa, na, ara laꞌo ela sira manggaraun nara ena. ");
INSERT INTO txq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tebe! Neu ko ei mete a leo! Neu faik fo Manetualain naketu-naladi basa hatahorir dedeꞌan nara, ei huku-dokim mara beran lena heni hatahori Sodom huku-dokin nara!” ");
INSERT INTO txq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yesus kokolak basa talo naa, boe ma Ana hule-haradoi nae, “Papa! Papa ndia toꞌu haak parenda basa-basan nai lalai no dae-inak. Au oke makasi noꞌun seli, nahuu Papa tatana mala huku-dokik naa numa hatahori mana tao aon malelak kara, ma mana makadedema aok kara mai. Tehuu Papa buka basa dedeꞌak kara raa neu hatahori kadiꞌik kara, ma hatahori mana makaloloe aok kara. ");
INSERT INTO txq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tebe, Papa! Naa ndia tao nala Papa dalen namahoko!” ");
INSERT INTO txq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesus hule-haradoi basa talo naa, boe ma Ana nafada hatahorir marai naar nae, “Nenene matalolole, ee! Au Amang manai nusa tetuk do inggu temak fee basa koasa neu Au ena. Mana nalela Au no neulauk naa, kada Amak mesa kana. Ma mana nalela Amak no neulauk, ndia kada Amak Anan mesa kana, ndia Au ia. Ma Au here ala hatahori laen nara fo afada sara, mita fo sira oo ralela Ndia no neulauk boe. ");
INSERT INTO txq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Basa ei mana bengge-manggu tao ue-osa berak, mai tungga Au! Basa ei mana lemba-masaa dedeꞌa manggataꞌak, meni Au mai! ");
INSERT INTO txq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mete ma ei simbok Au nenoring, fo laꞌok sama-sama mia Au, na, ita iar nok bali sapi luku dua fo leꞌa sama-sama luku esa. Au ia, dale malole, ma Au ia, dale mana makaloloe aok. Mete ma ei tungga Au, na, ei dadi barakai fali. ");
INSERT INTO txq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Huu Au nenoring naa, ta susa. Ma Au parendang naa, ta berak.” ");
INSERT INTO txq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Laꞌe esa, ndaa no hatahori Yahudir fai hahae tao ue-osan, Yesus ma ana nunin nara laꞌok resik hatahori osin. Ndia ana nunin nara ndoe, huu naa de ara koru rala hade-nggandum mbulen, boe ma raꞌa laꞌo-laꞌo. ");
INSERT INTO txq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Numa naa, hambu hatahori hida ruma partei anggama Farisir mai, fo mana toꞌu rahere hatahori Yahudi dala-hadan. Neu ara mete-rita Yesus ana nunin nara tao talo naa, boe ma ara rahara berak neun rae, “O ana nunim mara koru hade-nggandum laꞌe-ndaa fai hahae tao ue-osa! Ta bole talo naa! Naa, lena-langga ita hohoro-lalanen ena.” ");
INSERT INTO txq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Tehuu Yesus naselu nae, “Talo bee, ou? Ei ta masaneda baꞌi Dauk tutuin, do? Baꞌi Dauk no hatahorin nara taꞌin nara kada kikiok, nahuu ndoe ralan seli ena. Boe ma ara maso reni Manetualain Laa Huhule-haradoin dale reu, de haꞌi rala roti fo malangga anggama fee neu Manetualain ena, de ara raꞌa. Naa te kada malangga anggamar mesa kasa ndia bole raꞌa roti naa. Hatahori laen ta bole. Boe ma baꞌi Dauk asa raꞌa, tehuu ta hambu hatahori fee salak neu sara. Ei nok bali ta lees mita Manetualain Susura Malalaon ia! ");
INSERT INTO txq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nai naa, neni surak laꞌe-neu malangga anggama mana maono-lalau nai uma huhule-haradoik, ndaa no fai hahae tao ue-osa. Tehuu ara ta hambu salak hata esa boe na. ");
INSERT INTO txq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nenene, ee! Lele uluk uma huhule-haradoik ndia nenenin lenak, tehuu hatematak ia hambu esa nenenin lenak seli bali. Ndia Au, Hatahori Dae-bafo Isi-isik ia. ");
INSERT INTO txq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nai Manetualain Susura Malalaon dale, Manetualain nae, ‘Au hihii-nanaung talo ia: Au hatahoring nggara muste ratudu dale kasian esa mbali esa. Mete ma ara ta tao talo naa, na, sira tunu-hotun banda fo ara renin fee Au naa, nanalan ta faa boe na.’ Dadi mete ma ei bubuluk no neulauk Manetualain kokolan naa, neu ko ei ta makasasaꞌek salak neu Au ana nuning nggara. Te ara ta tao salak hata-hata na! ");
INSERT INTO txq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Au ia, Hatahori Dae-bafo Isi-isik. Au ndia aena haak fo aketu ae, hatahori bole tao hata ndaa no fai hahae tao ue-osa.” ");
INSERT INTO txq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Basa boe ma Yesus laꞌo ela mamanak naa, fo neni sira uma huhule-haradoin neu. ");
INSERT INTO txq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Numa naa, hambu touk esa fo liman seri mates. Hatahori Farisir raa sangga-sangga dalak fo fee salak neu Yesus, mete ma Ana tao nahai hatahori fo lima mate seserik naa laꞌe-ndaa fai hahae tao ue-osa. De ara ratanen rae, “Tungga ita anggaman hohoro-lalanen, hatahori bole tao nahai hatahori laꞌe-ndaa fai hahae tao ue-osa, do taa?” ");
INSERT INTO txq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Boe ma Yesus naselu nae, “Mete ma hatahori bibi lombon esa tuda neni bolok dale neu laꞌe-ndaa fai hahae tao ue-osa, neu ko tenu bibik naa neu leꞌa falik bibi lombo naa, hetu? ");
INSERT INTO txq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Leo naak oo, Manetualain sue-lai hatahori dae-bafok lena heni tenu bibik naa sue ndia bibi lombon boe. Huu naa de hatahori bole tao hata neulauk laꞌe-ndaa fai hahae tao ue-osa.” ");
INSERT INTO txq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Boe ma Ana kokolak no hatahori fo lima mate seserik naa nae, “Kaꞌa, ee! Loo o limam mai!” Boe ma ana loo liman seri fo matek naa neu, de liman naa hai tutik ka, sama leo ndia liman seri boe. ");
INSERT INTO txq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hatahori Farisir raa mete-rita naa, boe ma ara luri. De ara rambadeik laꞌo ela uma huhule-haradoik naa, boe ma reu rala harak rae, “Ita muste sangga dalak fo tao tisan!” ");
INSERT INTO txq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tehuu Yesus bubuluk sira nanae manggaraun nara raa, huu naa de Ana laꞌo neni mamana laen neu. Hatahori noꞌuk ka tunggan, boe ma Ana tao nahai basa hatahori kamahedik kara. ");
INSERT INTO txq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tehuu Ana kaꞌi sara nae, “Ei boso mafada hatahori laen laꞌe-neu Au.” ");
INSERT INTO txq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ana tao talo naa, tungga hata fo Manetualain nafada neu Ndia mana toꞌu dedeꞌan Yesaya ena nae, ");
INSERT INTO txq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Mete sudik kana! Ndia ia, Au Hatahori neondang fo Au here alan ena. Au sue-lai neun, ma Au daleng namahoko nakandoo ua Ndia. Neu ko Au fee Au Dula-daleng neun, fo Ana neu fee nenorik nai basa hatahori nusak kara laꞌe-neu Au eno-dala ndoon. ");
INSERT INTO txq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ana ta nalela fefemba tenden. Ana ta nalela nakadedemak aon. ");
INSERT INTO txq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ndia dalen malole. Ana ta nakasususak hatahori. Ai mana nae tiꞌuk, Ana ta fae natiꞌu sana. Lambu tiꞌoek mana nae matek, Ana ta fuu nakamate sana. Ana nanori hatahorir nakandoo, losa doo-doo te basa hatahori nusak kara ralela tungga Manetualain eno-dala ndoon. ");
INSERT INTO txq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Neu ko basa hatahori nusak kara ramahere neun, nahuu ara bubuluk rae Ndia naa, see.” ");
INSERT INTO txq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Laꞌe esa, hatahorir reni Yesus reu roo hatahori nitu saꞌek esa. Hatahori ia nitu saꞌen losa ana poke ma ta bisa kokolak. Boe ma Yesus husi kalua heni nitu naa fo tao nahain. De hatahori naa bisa mete-nita ma kokolak tutik ka. ");
INSERT INTO txq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Basa hatahorir mete-rita naa, boe ma ara heran bali-bali. Ara rakokola aok rae, “Fama te Ndia ia, Dauk tititi-nonosin fo Manetualain mana toꞌu dedeꞌan nara surak memak kana numa lele uluk mai ena. Ndia ia, ndia Hatahori fo ita tahani a neun naa ena!” ");
INSERT INTO txq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tehuu neu hatahori Farisir ramanene rala talo naa, boe ma ara ta simbok. De ara rakokola aok rae, “Weeh! Hatahori ia bisa husi kalua heni nitu, nahuu nitur malanggan Balsebul, ndia feen koasa.” ");
INSERT INTO txq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tehuu Yesus bubuluk hatahori Farisir kokolan naa. Boe ma Ana nafada sara nae, “Ei kokolam naa, ta maso nai duduꞌa-aꞌafi neulauk! Mete ma nai nusak esa dale, rau-inggun nara rahuu-ratofak, talo bee de nusak naa bei bisa nakatataka! Leo naak oo, mete ma hatahorir marai kota esa, do uma esa, raruꞌi-raꞌuk esa no esa boe, na, sira iar rabingga-baꞌek losa rakalulutu! ");
INSERT INTO txq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Dadi mete ma nitur kada ramusuk ma kada rahusi-mbuuk esa mbali esa, na, sira malanggan ta bisa toꞌu parenda nala dook ka bali! ");
INSERT INTO txq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Masaneda, ee! Ei hatahorim mara oo ralela husi nitu boe. Ara pake koasa numa nitu mai, do? Taa! Dadi ei boso kokolak sadi ndaa mae, Au pake nitu koasan fo husi nitu. Neu ko ei hatahori heli-helim mara ndia raketu rae, hata fo ei makasasaꞌek salak naa, sala. ");
INSERT INTO txq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tehuu mete ma Au tebe-tebe husi nitu pake koasa numa Manetualain Dula-dalen mai, naa natudu nae, Manetualain naa, memak Manek mana toꞌu parenda fo nai ei idu-matam mara ena. ");
INSERT INTO txq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mete ma naꞌo manu-meo nae mai foꞌai bua-baꞌu nai hatahori barakaik esa uman, na, ana muste humu nala hatahori naa, boe ma futu-paꞌan dei. Basa dei fo ana bisa foꞌai uma naa bua-baꞌun nara. ");
INSERT INTO txq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Masaneda matalolole! Hatahori ta mana mabua-aok esa no Au, ndia naa mana musuk no Au. Ma hatahori ta mana tulun Au ue-osang, hatahori naa kada nakalulutu Au ue-osang. ");
INSERT INTO txq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Dadi nenene matalolole Au kokolang ia! Manetualain sadia koka heni hatahori sala-singgon nara. Mete ma hatahori kokolak ta neulauk neu hatahori laen, Manetualain bei sadia fee ambon neun. Tehuu mete ma hambu hatahori nambarani kokolak ta neulauk neu Manetualain Dula-dale Malalaon, Manetualain ta koka heni ndia salan naa. ");
INSERT INTO txq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mete ma hatahori kokolak manggarauk neu Au, Hatahori Dae-bafo Isi-isik ia, Manetualain sadia fee ambon neun. Tehuu mete ma hatahori kokolak rakadadaek laban Manetualain Dula-dale Malalaon, na, Manetualain ta koka heni ndia salan naa, numa hatematak ia losa doon naa neu!” ");
INSERT INTO txq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Basa de Yesus kokolak nakandoo mbali hatahori Farisir raa nae, “Duꞌa matalolole! Ai huu neulauk naboa neulauk. Tehuu ai huu ta neulauk naboa ta neulauk. Numa ai huuk boan naa mai, hatahori bisa bubuluk nae, ai huuk naa, neulauk do taa. ");
INSERT INTO txq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Eir ia, nok bali mengge mana puta-paik! Ei ta bisa kokolak hata fo neulauk kara. Huu hata fo neni nehindak nai hatahori dalen dale, naa ndia kalua numa bafan mai. ");
INSERT INTO txq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hatahori neulauk, neu ko kokolak neulauk, nahuu hambu hata fo neulauk kara neni nehindak nai dalen dale. Tehuu hatahori manggarauk, neu ko kokolak manggarauk, nahuu hambu hata fo manggarauk kara neni nehindak nai ndia dalen dale. ");
INSERT INTO txq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mamahere neu Au! Neu ko dae-bafok fai mateꞌen losa, Manetualain parisa basa hatahorir dedeꞌan nara. Faik naa, hatahori esa-esak muste naselu-nataa ndia dedeꞌa-kokolan fo sosoan taak. ");
INSERT INTO txq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","De besa-besa, ee! Neu ko Manetualain timba-tai ei dedeꞌa-kokolam, de naketu nae, ei hambu huku-dokik, do taa.” ");
INSERT INTO txq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Meser anggama ketuk ma hatahori Farisir ramanene Yesus kokolan talo naa, boe ma roken rae, “Papa Meser! Ai hii mete-mita Papa tao tanda heran fo dadi bukti nae, Papa koasan naa tebe-tebe numa Manetualain mai.” ");
INSERT INTO txq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tehuu Yesus mbokak kasa nae, “Wiih! Ei hatahori hatematak ia, ta nau nenene neu Manetualain! Ei kada malela tao manggarauk mesa kana! Leo mae ei moke tanda heran, tehuu Au ta fee. Lele uluk, Manetualain fee tanda heran pake Ndia mana toꞌu dedeꞌan Yunus ena. Naa, dai ena! ");
INSERT INTO txq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunus leo hatu-leledok fai telu numa iꞌa moꞌok poꞌon dale. Leo naak oo, Au Hatahori Dae-bafo Isi-isik ia boe. Neu ko Au leo hatu-leledok fai telu nai batu bolok mamana hatahori mates dale. ");
INSERT INTO txq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Neu ko neu dae-bafok fai mateꞌen, mete ma Manetualain dadi mana maketu-maladi dedeꞌak, hatahori Niniwer rambariik dadi sakasii fo rakasasaꞌek salak neu ei rae, ‘Ei basa ngga iar, nggoa bebek kara!’ Lele uluk, hatahori Niniwe raa ramanene neu Manetualain mana toꞌu dedeꞌan Yunus, de ara sale dalen do tuke tein nara ma laꞌo ela sala-singgon nara. Tehuu ei taa. Naa te, hatematak ia hambu Hatahori nai ei taladam mara ta neni babanggak lena heni Yunus, ndia Au ia. Tehuu ei ta nau tao matak faa boe na neu Au. ");
INSERT INTO txq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Neu ko neu dae-bafok fai mateꞌen, mete ma Manetualain dadi mana maketu-maladi dedeꞌak, mane inak Seba numa kona mai, ana oo nambariik dadi sakasii boe. Ana dedeu liman fo nakasasaꞌek salak neu ei basa ngga mana masodak hatematak ia nae, ‘Ei basa ngga iar, nggoa bebek kara, ee!’ Lele uluk, mane inak naa numa dook ka mai fo mete-nita no mata heli-helin manek Soleman malelan. Naa te, hatematak ia hambu Hatahori nai ei taladam mara ta neni babanggak lena heni Manek Soleman, ndia Au ia. Tehuu ei ta nau tao matak faa boe na neu Au.” ");
INSERT INTO txq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mete ma nitu neni husi henik numa hatahori esa mai, nitu naa neni mamana nees neu sangga mamana hahae aok. Tehuu ana ta hambu mamana mandaak. ");
INSERT INTO txq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Boe ma ana duꞌa nae, ‘Aweꞌ! Ta hambu mamanak talo ia, de malole lenak au fali uu leo nai hatahori bakahuluk naa.’ Basa de ana fali, boe ma mete-nita mamanak naa, laok ma neni nefafaꞌu neulauk ena. ");
INSERT INTO txq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Boe ma nitu naa neu noke ndia nonoon hitu, fo manggaraun nara lenak bali numa ndia mai. Basa sara reu leo rai hatahori naa, de ara nggafu feen rame-rame. Dadi hatematak ia, hatahori naa masodan hambu sosoek lenak bali. Leo naak oo, hatahori tembo-tanak hatematak ia boe.” ");
INSERT INTO txq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Faik naa, Yesus bei kokolak no hatahori noꞌuk kara. Boe ma Ndia inan ma fadin nara mai fo rae ratonggo roon. Ara rambariik reu kada uma dea, de radenu hatahori neu noken. ");
INSERT INTO txq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Boe ma hatahori mai nafadan nae, “Papa, ee! Papa mamam ma fadim mara rai dea naa. Ara rae ratonggo ro Papa.” ");
INSERT INTO txq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Boe ma Yesus naselu nae, “Au mama tebe-tebeng naa, ndia see? Ma Au toranoo tebe-tebeng nggara raa, sira seer?” ");
INSERT INTO txq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","De Ana dudu neu hatahorir mana tungga Ndia, ma kokolak nae, “Mete, te sira iar, Au mamang ma Au toranoong nggara. ");
INSERT INTO txq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Hatahori mana tao tungga Au Amang manai nusa tetuk do inggu temak hihii-nanaun, sira raa Au nufanelu tebe-tebeng.” ");
INSERT INTO txq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Faik naa oo Yesus kalua numa uma naa mai boe, de neu nanggatuuk numa dano Galilea tatain. ");
INSERT INTO txq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Boe ma hatahori noꞌun seli mai rakarumbu ralan. De Ana hene neu nanggatuuk numa ofa mana seek esa lain numa naa, boe ma Ana fee nenorik. Basa hatahorir marai mada lai nenene nenorin. ");
INSERT INTO txq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","De Ana fee nenorik noꞌuk ka neu sara pake lololek. Ana soꞌuk tutuik nae, “Hambu hatahori mana ue daek esa neu nggari bini-nggees nai ndia osin. ");
INSERT INTO txq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Neu ana nggari bini-nggees raa, hambu ketuk tuda nai dalak. Boe ma mbuik kara mai, de bido rabasa bini-nggees raa lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma hambu bini-nggees ketuk tuda ndaa dae batuk. Bini-nggees raa ranumbu lai-lai, tehuu dae isik naa niꞌis, ");
INSERT INTO txq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","de neu ledo hene mai lain de nahaa, boe ma numbun nara male de mate ramatuu. Te okan nara ta tora losa dae dale, na. ");
INSERT INTO txq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bini-nggees ketuk bali tuda nai dila-nggauk taladan. Boe ma dila-nggauk seti rakamate numbun nara. ");
INSERT INTO txq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma bini-nggees ketuk bali tuda ndaa dae isik. Bini-nggees raa ranumbu, basa de ramoꞌo losa raboa. Ketuk fee falik buna-boak lipa laꞌe telu hulu, ketuk lipa laꞌe nee hulu, ma hambu ketuk bali losa lipa laꞌe natun esa. ");
INSERT INTO txq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","See ndia kandiꞌi dook, na, nenene matalolole, ee!” ");
INSERT INTO txq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Basa boe ma Yesus ana nunin nara mai, de ratanen rae, “Tao hata de Papa nanori hatahori noꞌuk kara raa pake lololek?” ");
INSERT INTO txq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Boe ma Yesus naselu nae, “Huu ei nau bubuluk tebe-tebe Manetualain parendan, de Au afada memak lololek naa sosoa-ndandaan. Tehuu mete ma hatahori laen, na, Au fee nenorik no kada lololek. ");
INSERT INTO txq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Te hatahori mana nau sangga tebe-tebe Manetualain hihii-nanaun, neu ko Manetualain feen tamba nalela bali. Tehuu hatahori ta mana tao matak neu Manetualain hihii-nanaun, neu ko Manetualain taon namanggonggoak. ");
INSERT INTO txq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Au anori sara pake kada lololek, nahuu: ‘Ara mete-rita ena, tehuu ta nau ralela. Ara ramanene ena, tehuu ta nau bubuluk.’ ");
INSERT INTO txq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sira iar sama leo hatahorir fo Manetualain mana toꞌu dedeꞌan Yesaya surak kana ena nae, ‘Neu ko ei mamanene, tehuu ei ta nau bubuluk. Neu ko ei mete-mita, tehuu ei ta nau malela hata fo mandadik ena. ");
INSERT INTO txq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Hatahori iar tao rambake ndiꞌi doon nara, ma ara tao rapoke matan nara, nahuu dalen nara matea. De elan numa naa fo ndiꞌi doon nara mbake talo naa leo, ma elan numa naa fo matan nara poke talo naa leo. Naa fo Au hae tao neulau sara, nahuu ara ta nau tao matak neu Au.’ ");
INSERT INTO txq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tehuu eir ia maua! Huu ei mete-mita no mata heli-helim mara ena, ma ei mamanene no ndiꞌi doo heli-helim mara ena. ");
INSERT INTO txq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mamahere neu Au! Lele uluk Manetualain mana toꞌu dedeꞌan ma hatahori dale ndoos sara hihiik ka mete-rita hata fo ei mete-mitak ena, tehuu ara ta bisa. Ara oo hihiik ka ramanene hata fo ei mamanenek ena, tehuu ara ta bisa boe.” ");
INSERT INTO txq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesus kokolak basa talo naa, boe ma Ana nafada sara nae, “Dadi hatematak ia, ei nenene lololek naa sosoa-ndandaan. ");
INSERT INTO txq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bini-nggees fo mana tuda nai dalak naa, ndia hatahori fo mana namanene Dedeꞌa-kokolak laꞌe-neu Manetualain parenda-koasan, tehuu ana ta nalela tebe-tebe. Basa boe ma nitur malanggan mai, de haꞌi neni Dedeꞌa-kokolak naa numa hatahori naa dalen mai. ");
INSERT INTO txq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bini-nggees fo mana tuda nai dae batuk naa, ndia hatahori fo mana namanene nala Manetualain Dedeꞌa-kokolan, boe ma ana simbon no nemehokok. ");
INSERT INTO txq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tehuu Dedeꞌa-kokolak naa ta nahuu-naoka. Huu naa de ta nakai nala dook ka nai hatahori naa dalen. Neu hatahori laen nakasususak kana nahuu ana simbo Dedeꞌa-kokolak naa, boe ma ana nggari henin tutik kana. ");
INSERT INTO txq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma bini-nggees fo mana tuda nai dila-nggauk taladan, sama leo hatahori fo mana namanene nala Dedeꞌa-kokolak naa ena. Tehuu ana nasambute nalan seli no ue-osa mata-matak kara fo leo-laꞌo tungga dae-bafok lole-ladan. De basa nesembuten nara raa seti heni Dedeꞌa-kokolak naa numa dalen mai losa ta hambu buna-boak. ");
INSERT INTO txq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tehuu bini-nggees fo mana tuda ndaa dae isik, sama leo hatahori fo mana pasa ndiꞌi doon fo simbo nala Dedeꞌa-kokolak naa, ma tungga Manetualain hihii-nanaun. Basa de ana tao kada hata fo neulauk kara, sama leo bini-nggees mana maboak naa. Hambu ketuk raboa lipa laꞌe telu hulu, ketuk oo nee hulu, ma ketuk losa lipa laꞌe natun esa boe.” ");
INSERT INTO txq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus nafada seluk lololek esa bali nae, “Manetualain parenda-koasan naa, sama leo hatahori esa neu nggari bini-nggees neulauk nai ndia osin. ");
INSERT INTO txq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Neu fai leꞌodaen, basa hatahori mana sunggu selik kara, boe ma hatahori manggarauk mai, de neu nggari bini-nggees naꞌu fuir neu osi naa. ");
INSERT INTO txq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Neu osi naa mulai fee buna-boan, boe ma ndia hatahori mana maue-osan nara mete-rita naꞌu fuir mori sama-sama ro hade-nggandum numa naa. ");
INSERT INTO txq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Basa boe ma ara reu rafada tenu osik naa rae, ‘Papa, ee! Fai maneuk kara ita sele bini-nggees neulauk numa papa osin, hetu? Tao hata de hatematak ia hambu naꞌu noꞌun seli?’ ");
INSERT INTO txq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tenu osik naa naselu nae, ‘Naa, hatahori manggarauk ue-tataon naa.’ Boe ma ndia hatahori mana maue-osan nara fee hahambuk rae, ‘Papa, ai miu feꞌa heni naꞌu naa, do?’ ");
INSERT INTO txq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tehuu ana naselu nae, ‘Bosok! Neu ei feꞌa naꞌu naa, neu ko ita sesele-tande neulaun nara oo, neni feꞌa henik kara boe. ");
INSERT INTO txq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ela sara ruma naa fo ara mori sama-sama losa fai ketu-koruk. Neu ko neu faik naa, dei fo au afada hatahori mana maue-osar ae, “Ei maduduru makahuluk naꞌu fuir raa dei. Boe ma futu bubuak esa-esak, fo hotu heni sara. Basa dei fo maduduru buna-boak neulaun nara, fo mbeda sara reni soka-poler reu.” ’” ");
INSERT INTO txq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Basa naa Yesus kokolak bali nae, “Au fee tamba lololek esa bali, fo ei bisa malela talo bee de Manetualain dadi Manek soa-neu hatahori noꞌuk ka. Ndia hatahorin nara, mulai sama leo ai deꞌe kadiꞌi anak fo hatahori sele-tanden nai ndia osin dale. ");
INSERT INTO txq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Leo mae ai deꞌek naa kadiꞌi anan seli, tehuu mete ma ana mori mai ena, na, ana dadi neu ai huuk moꞌon lenak nai osi dale. Losa mbuik kara mai randunu rai ndanan nara.” ");
INSERT INTO txq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus tamba seluk lololek esa bali nae, “Manetualain hatahorin naa oo, sama leo laru taꞌik boe fo inak esa haꞌi nalan de rumun no tarigu saak esa. Boe ma roti naa kaifuu losa namoꞌo, nahuu laru taꞌik fo baꞌu anak naa.” ");
INSERT INTO txq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus nanori hatahori noꞌuk no pake tutuik noꞌuk ka leo naak. Ndia kokolan basa sara pake kada lololek. ");
INSERT INTO txq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ana fee nenorik talo naa, tungga hata fo Manetualain mana toꞌu dedeꞌan surak memak kana ena nae, “Neu ko Au fee nenorik pake lololek. Neu ko Au afada hata fo hatahorir bei ta ramanene ritan, mulai numa Manetualain nakadadadik dae-bafok losa hatematak ia.” ");
INSERT INTO txq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","De Yesus laꞌo ela hatahori noꞌuk kara raa, fo fali uma neu. Boe ma ana nunin nara mai, fo roke tulun neun rae, “Papa! Tulun mafada ai, lololek naꞌu fuir naa sosoa-ndandaan dei!” ");
INSERT INTO txq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Boe ma Yesus naselu nae, “Hatahori mana nggari bini-nggees neulauk naa, ndia Au, Hatahori Dae-bafo Isi-isik ia. ");
INSERT INTO txq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma osi naa, ndia dae-bafok ia. Bini-nggees neulauk naa, ndia hatahorir mana maso dadi reu Manetualain nufanelun nara. Ma naꞌu fuir raa, ndia nitur malanggan hatahorin nara. ");
INSERT INTO txq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Boe ma hatahori manggarauk naa, fo mana mai nggari bini-nggees naꞌu deꞌek naa, ndia nitur malangga ina-huun mesa kana. Ma fai ketu-koruk naa, ndia dae-bafok fai mateꞌen. Hatahori mana maue-osar fo mana haꞌi buna-boak naa, ndia Manetualain atan nara ruma nusa tetuk do inggu temak mai. ");
INSERT INTO txq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Neu dae-bafok fai mateꞌen, ara raduduru rala naꞌur raa fo hotu heni sara. ");
INSERT INTO txq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Au, Hatahori Dae-bafo Isi-isik ia, neu ko adenu atar ruma nusa tetuk do inggu temak mai. Neu ko ara reu rakabubua basa hatahorir ta mana tungga Manetualain parendan. Ma ara oo, rakabubua basa hatahorir mana dudunggu-mbambau hatahori laen boe, fo ara boso tungga Manetualain parendan. ");
INSERT INTO txq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Neu ko ara nggari heni basa hatahori manggarauk kara raa, reni aꞌi mbila ta kala matek reu, sama leo naꞌu fo neni hotuk naa. Nai naa, dei fo ara rameda doidosok ralan seli, ma buꞌi rakarereu ta hahae. ");
INSERT INTO txq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tehuu hatahori mana leo-laꞌo no ndoos tungga Manetualain hihii-nanaun, neu ko ara leo rakandoo ro sira Ama Manen nai nusa tetuk do inggu temak. Nai naa, ara rasaꞌa sama leo ledo. Hatahori mana nau nalela Au, pasa ndiꞌi doom matalolole, ee!” ");
INSERT INTO txq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesus tamba lololek esa bali nae, “Hatahori mana nau nalela Manetualain parenda-koasan, sama leo hatahori mana hii hambu buas fo mabelin seli, fo hatahori nafuni nitan numa dae dale. Hatahori mana hii hambu buas naa mai kalin, boe ma natonggo buas naa numa naa, de namahoko nalan seli. Boe ma ana natoi falik buas naa. Basa de ana fali lai-laik, fo neu seꞌo heni basa ndia hata-heton lalaꞌen. De neu hasa nala dae naa, mita fo ana bisa hambu memak buas mabeli naa.” ");
INSERT INTO txq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesus tamba bali nae, “Hatahori mana nau nalela Manetualain parenda-koasan naa oo, sama leo hatahori mana danggan esa boe, mana hii hambu poemata fo mabelin seli. Boe ma ana sangga poemata fo nae hasa. ");
INSERT INTO txq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Neu ana natonggo no poemata esa lolen seli, boe ma ana fali lai-laik, fo neu seꞌo heni basa ndia hata-heton lalaꞌen. Basa de ana neu hasa nala poemata naa, mita fo ana bisa hambu memak kana.” ");
INSERT INTO txq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesus tamba bali nae, “Manetualain parenda-koasan naa, sama leo puꞌak esa fo mana puꞌa-dalak kara reu mboꞌin nai dano. De puꞌak naa nala iꞌak mata-matak kara. ");
INSERT INTO txq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Neu puꞌak naa sofek no iꞌak ena, boe ma mana puꞌa-dalak kara mai leꞌan fo renin dano tatain neu. Boe ma ara ranggatuuk fo raꞌisi iꞌak kara ruma puꞌak mai. Iꞌa neulauk kara, ara mbeda sara reni luꞌa tasik neu. Tehuu iꞌak ta neulauk, ara nggari heni sara. ");
INSERT INTO txq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Leo naak oo, no dae-bafok fai mateꞌen boe. Neu ko Manetualain atan nara ruma nusa tetuk do inggu temak mai, fo reu tada baꞌe hatahori manggarauk kara ruma hatahori dale ndoos mai. ");
INSERT INTO txq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Neu ko ara nggari heni basa hatahori manggarauk kara reni aꞌi mbila ta kala matek reu. Nai naa, dei fo ara rameda doidosok ralan seli, ma buꞌi rakarereu ta hahae.” ");
INSERT INTO txq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesus kokolak basa talo naa, boe ma Ana natane sara nae, “Ei malela basa hata fo Au kokolak bebeik kara ia, do?” Ara raselu rae, “Malela, Papa!” ");
INSERT INTO txq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Basa boe ma Yesus naselu falik nae, “Malole! Te meser anggama esa-esak ndia nanori tebe-tebe Manetualain Dedeꞌa-kokolan ena, fo neni surak memak numa fai uluk mai, ma ana oo toꞌu nahere Au nenoring hatematak ia boe, na, ana sama leo tenu uma esa, hii soi ndia nggudang fo natudu ndia hata-heto raan, sama-sama no ndia hata-heto beun.” ");
INSERT INTO txq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Neu Yesus nanori basa hatahori noꞌuk kara pake lololek ena, boe ma Ana laꞌo ela mamanak naa, ");
INSERT INTO txq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","fo fali neni Ndia nggoro-tadun neu. Numa naa Ana maso neni uma huhule-haradoik neu fo nanori hatahorir. Basa hatahori mana ramanene neun, heran ralan seli. Ara rakokola aok rae, “Awii! Hatahori ia malelan mata ia, ma! Ana hambu nenorik numa bee mai? Talo bee de Ana bisa tao tanda heran raa? ");
INSERT INTO txq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Naa te Ndia ia, kada tukan ai Anan. Ita talela inan no malole, ndia Maria; ma fadin nara, sira Yakobis, Yusuf, Yudas ma Simon. ");
INSERT INTO txq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ita oo talela Ndia fadi inan nara boe, huu ita basa ngga leo nggorok esa, na! Dadi Ana hambu Ndia malelan naa, numa bee mai bali? Ma Ana hambu Ndia koasan ta neni babanggak naa, numa see mai bali?” ");
INSERT INTO txq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Huu naa de ara mbiri ma rasakele, de ara ta nau ramanene neu sana bali. Tehuu Yesus nafada nae, “Memak tetebes! Nai mamanak laen, hatahorir hii fee hada-horomatak neu Manetualain mana toꞌu dedeꞌan. Tehuu nai ndia nggoro-tadu heli-helin ma uma isin nara, hatahori ta nau fee hada-horomatak neun.” ");
INSERT INTO txq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Huu dalen nara ratea, losa ara ta nau ramahere neu Yesus, de Ana ta tao tanda heran noꞌuk ka numa naa. ");
INSERT INTO txq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Faik naa, manek Herodes toꞌu parenda numa profensi Galilea. Ana oo namanene tutuik mata-matak kara laꞌe-neu Yesus boe. ");
INSERT INTO txq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ana nafada ndia penggawen nara nae, “Yesus ia, fama te Yohanis Mana Saranik fo fai maneuk kara au adenu tete heni langgan. Hatematak ia ana nasoda fali numa mamaten mai ena! Huu naa de ana naena koasa fo tao tanda heran nara raa.” ");
INSERT INTO txq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Manek Herodes kokolak talo naa, huu fai bakahulun ana nadedeꞌa no Yohanis losa ana humu nalan, de teen neni bui dale neu. Dedeꞌak naa tutuin talo ia: manek Herodes sao nala fadin Felipus saon, nade Herodias. Naa te Felipus no Herodias bei ta ramaketu. ");
INSERT INTO txq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Huu naa de Yohanis kaꞌi-oren laꞌi-laꞌik kana nae, “Papa manek ta bole sao mala papa fadim saon. Naa nalena-langga ita hatahori Yahudi dala-hadan ena!” ");
INSERT INTO txq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tehuu Herodes ta nau tao matak neun, de ana sao nala Herodias leo. Tungga ndoon naa, Herodes hihiin nau tao nisa Yohanis Mana Saranik. Tehuu ana namahia hatahori noꞌuk kara, nahuu ara ramahere rae, Yohanis naa, Manetualain mana toꞌu dedeꞌan. Huu naa de ana nadenu ndia hatahorin fo sese Yohanis neni bui dale neu. ");
INSERT INTO txq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Doo-doo boe ma Herodes tao feta fai bobonggik. Faik naa, Herodias ana feton neu lendo mbali fuik kara. Lelendon naa lolen seli, losa tao nala Herodes dalen namahoko nalan seli. ");
INSERT INTO txq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ana fetok naa lendo basa, boe ma Herodes nanggou nalan, de nae, “O mae moke hata numa au mai, na, mafada leo! Neu ko au fee. Au toꞌu tebe-tebe au hehelu-bartaang ia. Ma au sumba-soo pake Manetualain naden.” ");
INSERT INTO txq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ana namanene nala manek kokolan talo naa, boe ma ana fetok naa inan tusu-hain. Huu naa de ana neu noke nae, “Papa! Au oke Yohanis Mana Saranik langgan. Taon neu dulang dale, fo menin fee au.” ");
INSERT INTO txq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Manek Herodes namanene nala ana fetok naa nonoken talo naa, boe ma tendak heni taꞌi dalen tutik kana. Tehuu ana ta bisa leꞌa falik ndia sumba-soon, huu basa fuik kara ramanene ena, na. Huu naa de ana tungga kada ana fetok naa hihiin leo. ");
INSERT INTO txq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Boe ma ana parenda hatahori fo reu tete Yohanis langgan nai bui dale. ");
INSERT INTO txq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ara tete rala Yohanis langgan, boe ma ara taon neu dulang dale, fo renin fee ana fetok naa. Ana simbo nala dulang naa, boe ma koꞌo nenin fee inan. ");
INSERT INTO txq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Neu Yohanis ana nunin nara ramanene rae, ara tete heni Yohanis langgan ena, boe ma ara mai haꞌi rala nenetun, de reu ratoin. Basa de ara reu rafada dedeꞌak naa neu Yesus. ");
INSERT INTO txq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Neu Yesus namanene tutuik laꞌe-neu Yohanis naa, boe ma Ana no ana nunin nara rae rakaheok numa mamanak naa mai. De ara saꞌe ofak fo rae reni mamana nees reu fo bisa hahae aon nara. Tehuu hatahori noꞌuk kara mete-rita Yesus asa ofan loro-loro dano tatain. Boe ma ara kalua numa nggorok kara mai, de laꞌok lai-laik tungga dala mada laik. Huu naa de ara losa mamana seseek rakahuluk numa Yesus asa mai. ");
INSERT INTO txq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Neu Ana konda numa ofak lain mai, boe ma Ana mete-nita hatahori noꞌuk kara raa rahanin. De Yesus tuda kasian neu sara. Boe ma Ana tao nahai sira hatahori kamahedin nara. ");
INSERT INTO txq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Neu ledo bobok ena, boe ma Ndia ana nunin nara mai rafadan rae, “Papa, ee! Malole lenak Papa madenu hatahorir ia, basa sara reu hasa nanaꞌak nai nggoro matia-taik marai iar. Huu ledo bobok ena! Nai ia, ta hambu nanaꞌak hata esa boe na.” ");
INSERT INTO txq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tehuu Yesus naselu nae, “Bosok! Ei ndia mahao sara leo.” ");
INSERT INTO txq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Boe ma ara raselu rae, “Awii, Papa, ee! Ai ta hambu hata esa boe na fo mahao hatahori noꞌun seli ia. Ai mae tao talo bee? Huu hambu kada roti lima, ma iꞌak duak ka, ma!” ");
INSERT INTO txq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tehuu Yesus kokolak nae, “Hou! Malole naa ena. Meni sara mai leo!” ");
INSERT INTO txq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Boe ma Ana nadenu hatahori raa ranggatuuk rakabubua reu naꞌu lain. De Yesus haꞌi nala roti kalimak kara ma iꞌa kaduak kara raa. Boe ma Ana nasare mbali lalai neu fo noke makasi neu Manetualain. Basa naa, Ana fifiꞌi baꞌe roti naa, de Ana loon neu Ndia ana nunin nara fo reu babaꞌe neu hatahori raa lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Boe ma basa sara raꞌa losa rakabete. Raꞌa basa, boe ma ara reu raduduru rala nanaꞌa lenan nara, losa sofe lembaneu salahunu dua. ");
INSERT INTO txq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Basa hatahori mana raꞌak kara raa, nai rarain hambu touk rifun lima. Bei ta reke tamba inak kara ma kakanak kara bali. ");
INSERT INTO txq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hatahorir raa raꞌa basa, boe ma Yesus nadenu ana nunin nara reu saꞌe ofak, fo rakahuluk reni dano boboan seri reu. Tehuu Ana bei nahani numa naa, fo nadenu hatahori noꞌuk kara raa fali reu sara. ");
INSERT INTO txq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Neu basa sara fali, boe ma Yesus hene neni letek esa lain neu, fo hule-haradoi. Ndia mesa kana bei numa naa, losa leꞌodae. ");
INSERT INTO txq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Faik naa, ana nunin nara ofan losa dook ka ena nai dano taladan. Ara sefe rangginggio, nahuu ani soru, ma rii moꞌok tufa sara. ");
INSERT INTO txq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lole manggaledo, boe ma Yesus neu laꞌo tungga sara. Tehuu Ana laꞌok nesik oe lain. ");
INSERT INTO txq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ana nunin nara mete-rita naa, boe ma ara nggengger ralan seli. Ara kokolak no nemetaꞌuk rae, “Heꞌe! Hambu maro ndia naa!” ");
INSERT INTO txq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tehuu Yesus kokolak tutik kana noo sara nae, “Weeh! Ei boso mamataꞌu, ee! Te Au ia, Yesus! Tao malende ei dalem mara leo!” ");
INSERT INTO txq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petrus namanene nala naa, boe ma naselu nae, “Mete ma memak Lamatuak ndia O, na, madenu au laꞌok usik oe lain fo au uni naa neti.” ");
INSERT INTO txq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","De Yesus naselu nae, “Neu! Ia mai leo!” Boe ma Petrus kalua numa ofak mai, fo neni Yesus neu laꞌok nesik oe lain. ");
INSERT INTO txq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tehuu neu Petrus nameda ani berak fumbuun, boe ma ana namataꞌu nalan seli. Ana mulai nasamele, de ana bolu nae, “Awii, Lamatuak, ee! Fali mala au dei!” ");
INSERT INTO txq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesus loo liman tutik ka no lai-laik, de toꞌu nala Petrus liman. Ana kokolak nae, “Ayii, Peꞌu, ee! Tao hata de o dalem nabaꞌek? O ta mamahere tebe-tebe neu Au, do?” ");
INSERT INTO txq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Basa naa, dua sara maso reni ofak dale reu. Boe ma anin lende tutik kana. ");
INSERT INTO txq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yesus ana nunin nara mete-rita naa, boe ma ara soꞌuk koa-kiok soa-neun rae, “Awii! Papa ia, memak tebe-tebe Manetualain Anan!” ");
INSERT INTO txq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Neu ara losa dano tatain seri, boe ma ara konda numa nggorok Genesaret namo seseen. ");
INSERT INTO txq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Neu ara konda, hatahori noꞌuk kara ralela tutik kasa. Boe ma ara mulai bolu rae, “Wee! Yesus mai ena!” Ara ralaik reu rafada ndule basan, boe ma hatahorir mai roo basa hatahori kamahedik kara. ");
INSERT INTO txq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ara roke fo ara bisa rafaroe laꞌe Yesus badun. Huu ara duꞌa rae, “Sadi hatahori kamahedik nafaroe laꞌe kada Yesus badun suꞌun, neu ko ana hai tutik kana.” De basa hatahori kamahedik kara fo mana nafaroe laꞌe Yesus badun naa, hai tutik ka. ");
INSERT INTO txq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Faik esa, hambu hatahori Farisir ma meser anggamar bubuak esa ruma Yerusalem mai fo ratonggo ro Yesus. ");
INSERT INTO txq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Hatahori Farisir toꞌu rahere sira Yahudir dala-hadan. Neu ara ramanene rae, Yesus ana nunin nara raꞌa ta safe liman nara tungga dala-hadak hihii-nanaun, de ara rasakele. Boe ma ara mai fo fee salak neu Yesus rae, “Tao hata de O ana nunim mara raꞌa, tehuu ta safe liman nara dei? Naa, laban ita bei-baꞌin nara dala-hadan naa ena!” ");
INSERT INTO txq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tehuu Yesus naselu nae, “Eir ia, memak hatahori mana kokolak laen, tao laen! Ei malela laban Manetualain parendan fo tungga kada ei bei-baꞌim mara dala-hadan mesa kana. ");
INSERT INTO txq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Manetualain parenda ena nae, ‘Fee hada-horomatak neu ei ina-amam.’ Ma tamba bali nae, ‘Mete ma hatahori esa oꞌole-aꞌali ndia inan do aman, muste hukun mates neun.’ ");
INSERT INTO txq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Manetualain fee nenorik talo naa, tehuu ei fee nenorik laen bali. Ei mae, ‘Mete ma hatahori esa helu-bartaa basa nae fee ndia bua-baꞌun neu Manetualain ena, na, ana ta parluu pake buas naa fo tulu-fali ndia ina-aman, leo mae ara doidoso ralan seli.’ Tehuu no ei fee nenorik talo naa, ei nggari heni Manetualain parendan ena, fo nggatin no ei hohoro-lalane heli-helim. ");
INSERT INTO txq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Huu naa de bebeik kara ia Au kokolak ena ae, eir ia, hatahori mana kokolak laen, tao laen! Naa, ndaa no hata fo Manetualain mana toꞌu dedeꞌan Yesaya surak memak laꞌe-neu ei numa lele uluk mai ena! Ana surak nae, ");
INSERT INTO txq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Hambu hatahori koa-kio Au, no kada bafan, tehuu ta no dalen. ");
INSERT INTO txq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Leo mae ara tao talo naa oo, naa kada hie-hie a mesan boe. Ara ta tao matak neu Au, ara tao matak neu kada hatahori dae-bafok hohoro-lalanen mesa kana.’ ” ");
INSERT INTO txq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Basa boe ma Yesus nanggou nala hatahori laen nara maruma naa, fo nanori sara nae, “Pasa ndiꞌi doom mara matalolole, fo ei bisa malela! ");
INSERT INTO txq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hata fo maso neni hatahori bafan neu, naa ta tao nanggenggeo hatahori. Tehuu hata fo kalua numa hatahori bafan mai, naa ndia tao nanggenggeon.” ");
INSERT INTO txq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Basa naa Yesus ana nunin nara mai, de rafadan rae, “Papa bubuluk, do? Hatahori Farisir raa dalen nara hedis neu ramanene Papa kokolan.” ");
INSERT INTO txq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tehuu Yesus naselu nae, “Au Amang nai nusa tetuk do inggu temak, neu ko feꞌa heni hatahori ta mana nau nanori hatahori tungga Amak hihii-nanaun. Naa, sama leo hatahori feꞌa heni basa sele-tandek fo ana ta sele sana. ");
INSERT INTO txq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dadi boso tao matak mia hatahori Farisir raa! Sira raa, sama leo hatahori pokek fo natudu dalak soa-neu hatahori pokek. Neu ko ara tuda maso randaa reni bolok dale reu.” ");
INSERT INTO txq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Basa boe ma Petrus kokolak nae, “Papa, tulun mafada ai lololek bebeik kara naa sosoa-ndandaan dei!” ");
INSERT INTO txq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus naselu nae, “Dadi ei oo bei ta malela boe, do? ");
INSERT INTO txq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Talo ia: hata fo ita taꞌan, maso nai bafak, boe ma nakandoo neni poꞌok dale neu, basa naa kalua henin neni kakus neu. ");
INSERT INTO txq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tehuu hata fo kalua numa bafak mai, naa ndia tao nanggenggeo hatahori losa Manetualain oo nunuten, ma ta nau simbok kana boe. ");
INSERT INTO txq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Huu dedeꞌa manggarauk noꞌuk ka kalua numa hatahori dalen mai! Haꞌi netuduk leo: duduꞌa-aꞌafi manggarauk, nekenisa hatahori, hohongge-lelena, laꞌok sala no hatahori sao holu-ndaen, nemenaꞌo, sakasii pepeko-leleko ma kokolak tao naboboo hatahori naden. ");
INSERT INTO txq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Basa manggarauk leo naak kara raa, ndia tao rala hatahori nanggenggeo. Tehuu mete ma kada hatahori naꞌa ma ta safe liman tungga dala-hadak hihii-nanaun, na, naa dedeꞌan taa.” ");
INSERT INTO txq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Basa boe ma Yesus laꞌo ela mamanak naa, fo neni nusak esa natia-taik no kota Tirus ma kota Sidon. ");
INSERT INTO txq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Numa naa, hambu inak esa numa nusak naa mai. Ndia ta hatahori Yahudi. Neu ana namanene Yesus nai naa ena, boe ma ana mai noke-hule tebe-tebe nae, “Mane Dauk tititi-nonosin, ee! Kasian neu au dei! Au ana fetong nitu saꞌen. Awii, kasian, ee! Ana doidoso ena.” ");
INSERT INTO txq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tehuu Yesus tutundindiik, ma ta naselu hata esa boe na. Boe ma ana nunin nara mai rafadan rae, “Papa, inak ia kada kii-bolu tao namuek. Malole lenak Papa madenun nalai heok numa ia mai leo!” ");
INSERT INTO txq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Boe ma Yesus naselu nae, “Manetualain nadenu Au mai fo tulu-fali ita hatahori Yahudin, nahuu ara laꞌok sala ena, sama leo bibi lombo mana matarak. Ana ta nadenu Au uu tulu-fali hatahori laen.” ");
INSERT INTO txq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tehuu inak naa mai deka-deka no Yesus bali. Ana sendek luu-langgan ma noke tutulu-fafalik nae, “Lamatuak, ee! Tulun au dei.” ");
INSERT INTO txq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tehuu Yesus tee mbolek nae, “Ta nandaa haꞌi tala kakanak kara nanaꞌan, fo nggari sara fee busa.” Ma sosoan bei nefunik nae, Yesus muste tulu-fali nakahuluk Ndia hatahori Yahudin, dei fo bisa tulu-fali hatahori laen. ");
INSERT INTO txq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tehuu inak naa naselu nae, “Tebe, Papa, ee! Tehuu busar rahani a nai mei fengga dalen. Ara oo raꞌa hata fo tuda numa kakanak kara pinggan dale mai boe.” Ma sosoan nae, neu kakanak kara raꞌa, busa oo hambu naꞌa boe. Leo mae Yesus tulu-fali Ndia hatahorin, tehuu Ana oo muste susuri-memete hatahori laen boe. ");
INSERT INTO txq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesus namanene nala naa, boe ma nafada nae, “Awii! Mama mamahere tebe-tebe neu Au! Dadi mama fali muu ngga leo, huu hata fo mama nokek naa, dadi memak ena!” Basa boe ma ana fali neu ngga, de ana mete-nita anan hai memak ena. ");
INSERT INTO txq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Basa naa, Yesus no ana nunin nara laꞌo ela mamanak naa, boe ma ara laꞌok loro-loro tungga dano Galilea tatain. Ara hene letek esa, de Yesus nanggatuuk nanori sara. ");
INSERT INTO txq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Boe ma hatahori noꞌun seli reni Yesus mai. Ara roo hatahori dokak, hatahori pokek, hatahori keko-luꞌuk, hatahori ta bisa kokolak, ma hatahori hedis laen boe. Ara ranggatutuuk hatahori kamahedik kara raa deka-deka ro Yesus ein. Boe ma Ana tao nahai sara. ");
INSERT INTO txq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hatahori noꞌuk kara raa, mete-rita naa, boe ma ara heran. Ara rakokola aok rae, “Awii! Ta neni babanggak sudi selik kana! Hatahori dokak, bisa laꞌok natetu. Hatahori pokek, bisa mete-nita. Hatahori keko-luꞌuk, bisa laꞌok. Ma hatahori ta bisa kokolak, bisa kokolak ena! Ia, Manetualain ndia taon. Ndia naa, ndia Manetualain fo ita bei-baꞌin nara rakaluku-rakatelen numa lele uluk mai.” ");
INSERT INTO txq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Basa faik hida boe ma Yesus nanggou nala Ndia ana nunin nara, de nae, “Au ameda kasian neu hatahori noꞌuk kara iar ena. Hambu ketuk numa dook ka mai, ma ara rakabubua faik telu ena, losa ta ela nanaꞌak ena. Malole lenak ara boso fali reu sara ro poꞌo rouk dei. Boso losak, ara ndiꞌa nai dalak.” ");
INSERT INTO txq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tehuu Yesus ana nunin nara raselu rae, “Papa! Mamanak ia nees, ma dook ka numa nggorok mai. Ta bisa dadi ita tahao hatahori noꞌuk ka talo ia.” ");
INSERT INTO txq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tehuu Yesus natane sara nae, “Ei rotim mara hida de?” Ara raselu rae, “Kada hituk ka! Ma iꞌak faa!” ");
INSERT INTO txq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Boe ma Yesus nadenu basa hatahori raa fo ranggatuuk reu daer. ");
INSERT INTO txq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ana haꞌi nala roti kahituk kara ro iꞌak, de noke makasi neu Manetualain. Basa boe ma Ana fifiꞌi baꞌe sara, de Ana fee sara reu ana nunin nara fo reu babaꞌe neu basa hatahorir raa. ");
INSERT INTO txq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","De basa sara raꞌa losa rameda dai ena. Basa naa ara raduduru rala basa nanaꞌa lenan nara, losa sofe lembaneu hitu. ");
INSERT INTO txq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Basa hatahori mana raꞌak kara raa, nai rarain hambu touk rifun haa. Bei ta reke tamba inak kara ma kakanak kara. ");
INSERT INTO txq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Basa naa Yesus nadenu hatahori noꞌuk kara fali reu ngga. Boe ma Ana saꞌe ofak fo ara reni nusa Magadan reu. ");
INSERT INTO txq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Laꞌe esa, hambu hatahori Farisir ma hatahori Sadukir hida reni Yesus mai. Ara rae rakaseseluk dedeꞌak ro Yesus fo rae ike rakatutudak kana. Huu naa de ara roken rae, “Papa! Tulun matudu tanda heran dei, fo dadi bukti ae, Papa hambu koasa numa Manetualain mai ena.” ");
INSERT INTO txq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tehuu Yesus naselu nae, “Neu ledo tesa ma lalai nasaraa mbila, ei tanda mae, ‘Beꞌe-mai udan taa.’ ");
INSERT INTO txq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma neu ledo toda ma lalai nasosoꞌa nggeo, ei tanda mae, ‘Bekin ia, udan nae mai.’ Dadi mete ma ei bisa tadu-tanda mala fai hanas ma fai oe faak lalalin talo naa, tao hata de ei ta bisa tadu-tanda mala tembo-lelek lalalin? ");
INSERT INTO txq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wuuh! Ei hatahori tanak ia, bisa tao kada manggarauk mesa kana! Ei ta tao matak neu Manetualain! Leo mae ei moke tanda heran, tehuu Au ta fee. Huu fai uluk Manetualain fee tanda heran ena, pake Ndia mana toꞌu dedeꞌan Yunus. Dadi, naa dai ena!” Yesus kokolak basa talo naa, boe ma Ana laꞌo ela sara. ");
INSERT INTO txq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Neu Yesus asa saꞌe ofak fo reni dano boboan seri reu, dei de ana nunin nara rasaneda rae, ara lilii reni roti soa-neu sira lepa-nggeen. ");
INSERT INTO txq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesus namanene nala ara kokolak talo naa, boe ma Ana nafada nae, “Masanenedak, ee! Ei muste besa-besa mia hatahori Farisir ma hatahori Sadukir laru taꞌin.” ");
INSERT INTO txq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yesus ana nunin nara ramanene rala naa, boe ma ara panggananaa. Ara rakokola aok rae, “Tou lasik kokolak hata naa? Fama te Ana kokolak talo naa, nahuu ita ta teni roti, do?” ");
INSERT INTO txq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tehuu Yesus bubuluk sira duduꞌan. De Ana kokolak nae, “Woi! Eir ia, sudi selik kana ena! Tao hata de ei kokolak laꞌe-neu roti? Ei ta mamahere tebe-tebe neu Au, do? ");
INSERT INTO txq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ei bei ta malela Au koasang, do? Neu faik naa, fo Au fifiꞌi baꞌe roti kalimak kara raa fo ahao hatahori rifun lima naa, nanaꞌa lenan nara ei maduduru mala lembaneu hida!? ");
INSERT INTO txq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Basa de, talo bee bali no roti kahituk kara fo Au babaꞌe fee hatahori rifun haa naa? Nanaꞌa lenan nara ei maduduru mala lembaneu hida!? ");
INSERT INTO txq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tao hata de ei ta malela Au kokolang bebeik kara naa? Au ta kokolak laꞌe-neu roti. Tehuu Au ae fee nesenenedak neu ei, mita fo ei besa-besa mia hatahori Farisir ma hatahori Sadukir nenorin. Huu sira nenorin nara raa bisa leꞌa-nore nala hatahori noꞌuk a, sama leo laru taꞌik tao kaifuu roti dadi namoꞌo.” ");
INSERT INTO txq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesus kokolak talo naa, dei de ara ralela rae, Ana ta kokolak laꞌe-neu roti. Tehuu Ana kokolak laꞌe-neu hatahori Farisir ma hatahori Sadukir nenorin fo mana laban Lamatuak hihii-nanaun. ");
INSERT INTO txq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Basa boe ma Yesus no ana nunin nara laꞌok reni nusak mana matia-taik ro kota Kaisarea Felipi reu. Neu ara bei laꞌok numa dalak, Ana natane ana nunin nara nae, “Tungga hatahori kokolan, ara rae, Au, Hatahori Dae-bafo Isi-isik ia see?” ");
INSERT INTO txq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ara raselu rae, “Hambu ketuk rae, Papa ia, Yohanis Mana Saranik fo nasoda fali numa mamaten mai ena. Laen rae, fama te Papa ia, baꞌi Elia. Laen bali rae, baꞌi Yeremia. Mete ma taa, na, Manetualain mana toꞌu dedeꞌan laen numa lele uluk mai.” ");
INSERT INTO txq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Boe ma Yesus natane sara bali nae, “Mete ma tungga ei mesa ngga, na, Au ia see?” ");
INSERT INTO txq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Basa boe ma Simon Petrus naselu nae, “Papa ia, Karistus, ndia Hatahori naa, fo lele uluk Manetualain helu-bartaa ena nae nadenun mai! Ma Papa ia, Manetualain mana masodak seku neu Anan!” ");
INSERT INTO txq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","De Yesus nae, “Simon, Yunus anan, ee! O ia, maua! Huu hatahori dae-bafok ta ndia nafada dedeꞌak ia neu o. Tehuu Au Amang manai nusa tetuk do inggu temak ndia nafada neu o. ");
INSERT INTO txq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nenene, ee! Hatematak ia Au ae foi nadek ‘Petrus’ neu o. Nadek naa sosoa-ndandaan, ndia batu. Neu ko o dadi muu fanderen soa-neu Au hatahori kamahereng nggara, nahuu o nemeheherem tean leo batu ena. Leo mae ara hambu malendu-mataꞌak losa mate oo, ara rakatataka rakandoo boe. ");
INSERT INTO txq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Neu ko Au fee haak neu o, fo koladu Au hatahoring nggara, sama leo o toꞌu nusa tetuk do inggu temak nggoen. No dalak naa, hata fo o kaꞌi-oren nai dae-bafok ia, naa oo Manetualain kaꞌi-oren nai nusa tetuk do inggu temak boe. Ma hata fo o fee luas nai dae-bafok ia, naa oo Manetualain fee luas nai nusa tetuk do inggu temak boe.” ");
INSERT INTO txq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesus kokolak basa talo naa, boe ma Ana ndindia sara fo boso rafada hatahori esa boe na rae, Ndia naa, Karistus. ");
INSERT INTO txq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mulai numa faik naa mai, Yesus nafada Ndia ana nunin nara nae, “Au muste uni kota Yerusalem uu. Tehuu neu ko nai naa, Au hambu doidosok noꞌun seli numa lasi-lasi hadak kara, malangga anggama Yahudi malanggan nara, ma basa meser anggamar mai. Neu ko ara rakanisa Au, tehuu neu bei-nesan, Au asoda fali numa mamates mai.” ");
INSERT INTO txq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yesus nafada talo naa, boe ma Petrus leꞌa nalan neni tataik neu fo ela kada dua sara mesa kasa, de Petrus kaꞌin nae, “Papa boso kokolak talo naa! Ta bisa dadi Manetualain elan dadi talo naa!” ");
INSERT INTO txq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tehuu Petrus kokolan naa, ta tungga Manetualain hihii-nanaun. Huu naa de Yesus hekor, de nahara berak mbalin nae, “Hei! Malai heok ia! Naa, nitu malanggan ndia kokolak! O boso dadi mana kai-baak soa-neu Au! O duduꞌa tungga kada hatahori dae-bafok hihii-nanaun mesa kana, te ta tungga Manetualain hihii-nanaun!” ");
INSERT INTO txq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Basa boe ma Yesus nanori ana nunin nara nae, “Hatahori mana nau tungga Au, ana muste nakatataka nakandoo tungga-tungga faik! Ana muste lilii heni ndia hihii-nanau heli-helin fo tungga kada Manetualain hihii-nanaun mesa kana. Leo mae hatahori rae tao risan, ana muste tungga nakandoo a mesan, sama leo ana lemba-nasaa ndia ai ngganggen fo neu mate. ");
INSERT INTO txq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Hatahori mana sadia mate nahuu ana tungga Au, neu ko ana hambu masodak nakandoo no Manetualain. Tehuu hatahori mana nau nasoda soa-neu kada ndia ao heli-helin, neu ko masodan naa, sambu do lalo talo kada naa leo! ");
INSERT INTO txq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nenene, ee! Mete ma o hambu basa dae-bafok oe-isin, tehuu Manetualain timba heni o, na, nanalan hata? Leo mae o lemba muni basa dae-bafok oe-isin oo, o ta bisa saiseluk kana neu o samanem boe! ");
INSERT INTO txq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Au afada neu ei dedeꞌak kara ia lalaꞌen, nahuu Au ia, Hatahori Dae-bafo Isi-isik. Neu ko Au konda fali mai ua Au Amang koasan ta neni babanggak, sama-sama ua Ndia atan nara ruma nusa tetuk do inggu temak mai. Faik naa, neu ko Au bala hatahori esa-esak tungga hata fo ana taok. ");
INSERT INTO txq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Masaneda matalolole, ee! Numa eir ia mai, neu ko hambu hatahori ketuk bei ta mate, losa faik bee fo mete-rita Au, ndia Hatahori Dae-bafo Isi-isik dadi neu Manek mana toꞌu parenda.” ");
INSERT INTO txq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seli faik nee numa Yesus nafada laꞌe-neu mamaten ma nesoda falin numa mamaten mai, boe ma Yesus nanggou nala Petrus, Yakobis ma fadin Yohanis, fo ara sama-sama hene reni lete demak esa reu, fo mesa kasa reu naa. ");
INSERT INTO txq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Losa lain, boe ma ara mete-rita Yesus mata-aon nasafali ena. Matan nasaꞌa leo ledo, ma bualoꞌa-papaken dadi muti manggahadok. ");
INSERT INTO txq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Medak neu ma, ara mete-rita Ana kola-kola no baꞌi Musa ma baꞌi Elia. ");
INSERT INTO txq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Boe ma Petrus panggananaa, losa ana kokolak sadi ndaa nae, “Papa! Ai mameda malole nai ia ena! Dadi malole lenak ai mambaririik laak telu. Esa soa-neu Papa, esa soa-neu baꞌi Musa, ma esa bali soa-neu baꞌi Elia.” ");
INSERT INTO txq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Neu Petrus bei kokolak talo naa, medak neu ma sosoꞌak konda mai de tatana nala sara. Boe ma ara heran bali-bali ramanene harak esa kalua numa sosoꞌak naa mai nae, “Nenene, ee! Yesus ia, Au Ana susueng. Ana soa tao namahoko Au daleng. Nenene matalolole neun, ee!” ");
INSERT INTO txq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ana nunin nara ramanene rala naa, boe ma ramataꞌu ralan seli, losa ara tuda ratono reu daer. ");
INSERT INTO txq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tehuu Yesus mai de kai neu sara, boe ma nae, “Wee! Mambadeik leo. Boso mamataꞌu!” ");
INSERT INTO txq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","De ara botik matan nara, tehuu ara ta mete-rita hatahori laen esa boe na numa naa, kada Yesus mesa kana. ");
INSERT INTO txq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Neu ara mulai konda numa letek naa mai, boe ma Yesus ndindia sara nae, “Hata ndia ei bei fo mete-mitan bebeik kara ia, boso mafada hatahori esa boe na, ee! Au, Hatahori Dae-bafo Isi-isik ia muste mate dei. Neu ko mete ma Au asoda fali numa mamates mai ena, na, dei fo ei bole mafada hatahori.” ");
INSERT INTO txq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Boe ma ara ratanen rae, “Papa ia, memak Karistus, tehuu baꞌi Elia nai bee? Huu meser anggamar raa fee nenorik rae, baꞌi Elia muste mai nakahuluk, dei fo Karistus mai. Tehuu tungga Papa, na, talo bee?” ");
INSERT INTO txq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus naselu nae, “Memak tebe. Baꞌi Elia muste mai nakahuluk, fo nasosoi dalak soa-neu Karistus. ");
INSERT INTO txq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nenene matalolole, ee! Baꞌi Elia mai ena, tehuu hatahorir ta ralela sana. Ara rakasususak kana, tungga sira hihiin. Neu ko ara oo tao leo naak boe soa-neu Au, Hatahori Dae-bafo Isi-isik ia.” ");
INSERT INTO txq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ara ramanene basa talo naa, dei de ara bubuluk rae, baꞌi Elia fo Yesus kokolak naa, ndia Yohanis Mana Saranik. ");
INSERT INTO txq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Neu Yesus asa fali ena, boe ma ara ratonggo ro hatahori noꞌuk ka fo rahani sara. Boe ma hambu papa esa mai sendek luu-langgan fo hule tutulu-fafalik neu Yesus ");
INSERT INTO txq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","nae, “Lamatuak! Kasian neu au anang dei! Huu ana namahedi mulu bibik, de ana doidoso nalan seli. Mete ma hedis naa sou mai, na, laꞌi-laꞌik ka ana tuda neni oe neu, do neni aꞌi neu. Tulun dei, Lamatuak, ee! ");
INSERT INTO txq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Au unin neni Lamatuak ana nunin nara uu ena, tehuu ara ta bisa rahai sana.” ");
INSERT INTO txq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus namanene nala naa, boe ma Ana mboka ana nunin nara nae, “Weeh! Eir ia sudi selik kana ena! Au anori ei laꞌi-laꞌik kana ena, tehuu ei ta malela no malole. Ma ei ta mamahere tebe-tebe neu Au! Au muste ahani ua ei losa faik hida bali? Mai fo mia kakanak naa ia mai!” ");
INSERT INTO txq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ara reni kakanak naa neu, boe ma Ana husi kalua heni nitu numa kakanak naa mai. De nitu kalua laꞌo ela kakanak naa, boe ma ana hai tutik kana. ");
INSERT INTO txq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Basa naa, neu Yesus mesa kana sama-sama no ana nunin nara, ara ratanen rae, “Papa! Tao hata de bebeik kara ia, ai ta bisa husi kalua heni nitu naa?” ");
INSERT INTO txq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus naselu nasafali nae, “Ei ta bisa husi nitu naa, nahuu ei ta mamahere tebe-tebe, na. Masaneda, ee! Mete ma ei mamahere tebe-tebe neu Au, leo mae kada baꞌu anan seli oo, sama leo ai deꞌe kadiꞌi anak esa boe, na, ei bisa parenda letek esa mae, ‘Heeh, letek! Lali naa muu!’ Neu ko ana lali leo. Dadi ei bisa tao hata a mesan, sadi ei mamahere tebe-tebe neu Lamatuak. ");
INSERT INTO txq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ma nenene, ee! Nitu mata leo iak kara memak manggaraun seli. Mete ma ei ta hule-haradoi ma puasa fo hule tutulu-fafalik neu Lamatuak, na, ei ta bisa husi nitu matak leo naak.” ");
INSERT INTO txq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Laꞌe esa, Yesus no ana nunin nara rakabua numa profensi Galilea. Ana nafada sara nae, “Ta dook ka te ara rae seꞌo heni Au uni hatahori laen uu. ");
INSERT INTO txq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","De ara tao risa Au, Hatahori Dae-bafo Isi-isik ia. Memak Au mate, tehuu neu ko bei-nesan Au asoda fali numa mamates mai.” Ana nunin nara ramanene Ana kokolak talo naa, boe ma dalen nara susa ralan seli. ");
INSERT INTO txq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Neu Yesus no ana nunin nara mai nai nggorok Kapernaum, boe ma mana susu bear mai ratane Petrus rae, “Ei Mesem bae Uma Huhule-haradoi Ina-huuk bean, do taa?” ");
INSERT INTO txq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petrus naselu nae, “Bae, ee!” Neu Petrus maso uma dale neu, boe ma Yesus nafada tutik kana nakahuluk nae, “Simon! Soba o duꞌa sudik kana. Manek kara marai dae-bafok ia, haꞌi bea numa see mai? Numa sira ana heli-helin nara, do, hatahori laen mai?” ");
INSERT INTO txq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus naselu nae, “Numa hatahori laen mai!” Yesus tuti bali nae, “Mete ma leo naak, manek anan hae bae, hetu? ");
INSERT INTO txq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Leo naak oo, no Uma Huhule-haradoi Ina-huuk bean boe. Tehuu ita hae tao mana susu bear ramanasa. Dadi malole lenak, o muu dolu iꞌak nai dano a leo. O mala iꞌak makasososak, na, buka bafan. Neu ko o hambu doi lilo fulak esa nai naa. De pake doik naa, fo muu bae ita dua ngga bean. Naa, dai ena fo bae ita dua ngga bean.” ");
INSERT INTO txq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Faik naa, Yesus ana nunin nara reni Yesus reu fo ratanen rae, “Papa! See ndia moꞌon lenak numa basa Manetualain hatahorin mai?” ");
INSERT INTO txq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Boe ma Yesus nanggou nala kakana ana esa, de nambaririik kana neu sira taladan. ");
INSERT INTO txq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","De Ana nae, “Nenene matalolole! Hatahori mana nae maso dadi neu Manetualain hatahorin, ana muste nggati dala duduꞌan fo dadi sama leo kakana ana fo ta nalela nekededema aok. ");
INSERT INTO txq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Huu hatahori fo dale nekeloloen sama leo kakana ana ia, ana ndia dadi neu hatahori moꞌo-inahuuk lenak nai Manetualain matan. ");
INSERT INTO txq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma hatahori mana simbok nala hatahori kadiꞌik sama leo kakanak ia, nahuu ana namahere neu Au, na, hatahori naa simbok nala Au ena.” ");
INSERT INTO txq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Basa boe ma Yesus nafada neu sara bali nae, “Mete ma hambu hatahori tao nala kakana ana esa tungga eno-dala kasalak, losa ana ta namahere Au bali, na, besa-besa, ee! Malole lenak fuli batu moꞌok esa, neu hatahori naa boliin fo feen tena neni tasi demak dale neu. ");
INSERT INTO txq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Dae-bafok ia, memak mamana sosoek, nahuu hambu matak noꞌuk ka bisa tao nala hatahori tuda neni kilu-salak dale neu. Tehuu hatahori mana hambu sosoek lenak naa, ndia hatahori mana edo-podek fo hatahori laen tao salak. ");
INSERT INTO txq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mete ma o tao salak munik o limam, do, o eim, na, tete henin leo! Malole lenak o maso nusa tetuk do inggu temak muu, muni kada lima seserik, do ei seserik lena heni ara nggari o muni aꞌi mbila ta kala matek muu, muni o limam ma eim dua sara. ");
INSERT INTO txq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mete ma o tao salak munik o matam, na, edo henin leo! Malole lenak o maso nusa tetuk do inggu temak muu, muni kada mata seserik lena heni ara nggari o muni aꞌi mbila ta kala matek muu, muni o matam dua sara.” ");
INSERT INTO txq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesus kokolak bali nae, “Besa-besa, ee! Boso losak ei makadadaek kakana ana talo ia. Huu Manetualain atan nara ruma nusa tetuk do inggu temak mai, ndia ranea sara. Ma atar raa bisa maso faik bee a mesan, fo reu rafada Manetualain laꞌe-neu hatahorir ia dedeꞌan nara. ");
INSERT INTO txq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","13","Ei duꞌa matalolole, te Au ae fee lololek talo ia: hambu hatahori esa naena bibi lombo natun esa. Faik esa boe ma hambu bibi lombo esa laꞌok sala dalan. Tungga ei duduꞌam, mana lolo naa muste tao hata? Neu ko ana laꞌo ela ndia bibi lombo kasio hulu sion nara reu letek lain, fo neu sangga bibi lombo kisek kala mopok naa. Mete ma ana hambu falik kana, neu ko ana namahoko nalan seli mete-nita bibi lombo kisek naa, lena heni ana mete-nita ndia bibi lombon kasio hulu sio ta kala mopok. Leo naak oo Au, Hatahori Dae-bafo Isi-isik ia, mai fo tao asoi-asoda hatahori mana laꞌok sala numa eno-dala ndoos mai boe. ");
INSERT INTO txq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Leo mae kada kakana ana esa ndia mopon oo, Au Amang manai nusa tetuk do inggu temak ta namahoko boe.” ");
INSERT INTO txq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus kokolak bali nae, “Mete ma o toranoo kamaherem nasala no o, na, muste muu matonggo muan. Mete ma kada ei dua ngga, dei fo mafada ndia salan. Mete ma ana nenene o kokolam, na, ei dua ngga malole masafali naa ena. ");
INSERT INTO txq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tehuu mete ma ana ta nau nenene o, na, muu moke mala o nonoom hatahori esa do dua fo reu sama-sama ro o. Basa de ei miu matonggo mia hatahori naa, fo kokolak seluk mian bali. Huu nai Manetualain Susura Malalaon neni surak nae, ‘Nai dedeꞌak esa dale, muste hambu sakasii dua do telu kokolan nara sama, dei fo bisa simbok sira kokolan nara raa.’ ");
INSERT INTO txq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tehuu mete ma ana bei ta nau nenene ei, na, miu mafada saranik kara. Ma mete ma ana ta nau simbok no malole saranik kara kokolan, na, taon ndia sama leo hatahori ta mana nalela Manetualain. Mete ma taa, na, taon leo hatahori manggarauk sama leo mana susu bear. ");
INSERT INTO txq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Masaneda matalolole Au kokolang, ee! Hata fo ei kaꞌi-oren nai dae-bafok ia, naa Manetualain kaꞌi-oren nai nusa tetuk do inggu temak ena. Ma hata fo ei makaheik kana nai dae-bafok ia, naa Manetualain nakaheik kana nai nusa tetuk do inggu temak ena. ");
INSERT INTO txq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ma Au afada seluk ae, mete ma hambu hatahori dua ruma ei mai, hule-haradoi no dalek esa, neu ko Au Amang manai nusa tetuk do inggu temak, baꞌe fee hata fo ara rokek. ");
INSERT INTO txq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mete ma hambu hatahori dua do telu rakabua fo hule-haradoi sama-sama, nahuu sira iar, Au hatahoring, na, Au oo nai sira taladan boe.” ");
INSERT INTO txq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Basa boe ma Petrus mai natane Yesus nae, “Papa, au ae atane faa dei. Mete ma au toranoo kamahereng nasala laꞌi-laꞌik kana mbali au, na, au muste fee ambon mbalin laꞌe hida? Losa laꞌe hitu, do?” ");
INSERT INTO txq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Boe ma Yesus naselu nae, “Taa! O muste fee ambon neun losa laꞌe 7 laꞌe 70, losa o ta bisa reke mala sara bali. ");
INSERT INTO txq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ei muste tao tungga talo naa, nahuu Manetualain naa sama leo manek esa fo reke no lutuk ndia penggawen nara hutan. ");
INSERT INTO txq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Neu ana mulai reke, boe ma ana nadenu ndia hatahorin fo neu noke nala penggawe esa mana nahuta doik neun, losa rifu-natuk kara. ");
INSERT INTO txq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tehuu penggawe naa, ta bisa bae ndia hutan nara raa. Dadi manek parenda nae, ‘Miu seꞌo heni hatahori ia no basa sao-anan nara, fo ara dadi reu ata-dator. Ma seꞌo heni hata-heton lalaꞌen fo bae neu ndia hutan nara.’ ");
INSERT INTO txq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Penggawe naa namanene nala naa, boe ma ana sendek luu-langgan neu manek matan fo kokoen nae, ‘Awii! Papa, ee! Papa manek tulun fee au fai lelak faa dei! Neu ko au bae falik au hutang nggara lalaꞌen.’ ");
INSERT INTO txq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Manek namanene nala naa, boe ma dalen tuda kasian neun. De ana koka heni memak penggawe naa hutan lalaꞌen. Boe ma ana nakamboꞌik penggawe naa. ");
INSERT INTO txq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tehuu neu penggawe naa laꞌo dea neu, ana natonggo no nonoon esa, mana nahuta doik baꞌu anak ka mbalin. Boe ma ana humu nala nonoon, de hese neu boliin ma mbokan nae, ‘Heeh! Bae o hutam hatematak ia boe!’ ");
INSERT INTO txq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nonoon namanene nala naa, boe ma ana sendek luu-langgan fo kokoen nae, ‘Awii! Tia-lai, ee! Tulun fee au fai lelak faa dei! Neu ko au bae falik au hutang nggara neu o.’ ");
INSERT INTO txq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tehuu penggawe naa nae, ‘Ta bisa! Nau ta nau, o muste bae hatematak ia!’ Boe ma ana sese nonoon neni bui neu, losa ana bae nabasa hutan nara raa. ");
INSERT INTO txq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Neu manek penggawen laen nara mete-rita hata mandadik naa ena, boe ma dalen nara sona. De reu tui manek. ");
INSERT INTO txq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Manek namanene nala naa, boe ma noke penggawe ta kalela hadak naa. Ana dedeun nae, ‘Weeh, hatahori manggarauk! Au koka heni o hutam mara lalaꞌen, nahuu o moke au kasian neu o. ");
INSERT INTO txq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tehuu tao hata de o ta maena dale kasian soa-neu o nonoom, sama leo au kasian neu o naa?’ ");
INSERT INTO txq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Manek naa namanasa nalan seli losa nadenu sese hatahori naa neni bui neu, mita fo ara tuni-ndenin, losa ana bae nabasa hutan nara lalaꞌen.” ");
INSERT INTO txq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesus nateꞌe Ndia tutuin, boe ma kokolak nae, “Au Amang manai nusa tetuk do inggu temak oo reke no lutuk talo naa boe. Neu ko Ana hukun ei, mete ma ei ta lilii heni tebe-tebe neu ei toranoo hatahori kamaherem mara sala-singgon nara.” ");
INSERT INTO txq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus fee basa nenorik kara raa, boe ma Ana laꞌo ela Galilea fo neni profensi Yudea manai lee Yarden boboan seri naa neu. ");
INSERT INTO txq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Hatahori noꞌuk ka tunggan, boe ma Ana tao nahai hatahori hedis numa naa. ");
INSERT INTO txq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Hambu hatahori Farisir ketuk oo mai boe, fo rae ike rakatudak Yesus. Ara ratane rae, “Papa! Tungga ita anggaman hohoro-lalanen, mete ma touk sao ena, na, ana bole namaketu no saon pake dalak bee a mesan, do talo bee?” ");
INSERT INTO txq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tehuu Ana naselu nae, “Eir ia, hatahori mana malela anggama. Tehuu tao hata de ei ta bubuluk Manetualain Susura Malalaon isin? Masaneda, nai tutui makasososak neni surak nae, ‘Manetualain adu hatahori dae-bafok, touk ma inak.’ ");
INSERT INTO txq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma neni surak bali nae, ‘Huu naa de touk muste laꞌo ela ndia inan ma aman, fo neu leo-laꞌo dalek esa no saon, huu dua sara dadi reu esa ena.’ ");
INSERT INTO txq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Dadi mete ma Manetualain mesa kana ndia adu nala dua sara dadi reu esa ena, na, hatahori dae-bafok boso mabingga-baꞌe sara bali!” ");
INSERT INTO txq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Hatahori Farisir ramanene rala Yesus kokolak talo naa, boe ma ratane bali rae, “Mete ma talo naa, na, tao hata de baꞌi Musa nae, hatahori bole namaketu, sadi ana fee susura nemeketuk soa-neu sao inan dei?” ");
INSERT INTO txq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Boe ma Yesus naselu bali nae, “Baꞌi Musa fee lelak ei bei-baꞌim mara ramaketu ro sira sao inan nara, nahuu sira raa, langga batuk kara sama leo ei! Tehuu neu Manetualain nakadadadik dae-bafok ia, Ndia nanaen ta talo naa. ");
INSERT INTO txq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Huu naa de Au afada, ee! Mete ma sao inak laꞌok sala nakahuluk, na, touk bole namaketu noon. Mete ma sao inak ta laꞌok sala, tehuu touk ndia namaketu noon, de ana sao seluk no inak laen, na, ana hohongge-lelena naa ena!” ");
INSERT INTO txq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesus ana nunin nara ramanene rala Ana kokolak talo naa, boe ma ara kokolak rae, “Mete ma talo naa, na, malole lenak boso sao leo.” ");
INSERT INTO txq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Boe ma Yesus naselu nae, “Ta basa hatahori bisa simbok rala Au kokolang laꞌe-neu hatahori ta mana saok. Kada hatahori fo Manetualain henggenee memak kana leo. ");
INSERT INTO txq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Hambu hatahori ta sao, nahuu numa inan bonggin mai leo naak ena. Hambu ketuk oo ta sao boe, nahuu hatahori tao sara talo naa. Ma hambu boe, ana here aon fo ta sao, nahuu ana nau nakalalaꞌok kada Manetualain ue-osan. Hatahori fo mana bisa nalela nenorik ia, elan numa naa fo ana simbo a mesan leo.” ");
INSERT INTO txq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Faik naa, hatahorir koꞌo roo sira anan nara reni Yesus reu, mita fo Ana ndae liman ma kokolak fee babaꞌe-babatik neu sara. Tehuu ana nunin nara rahara berak reu hatahorir raa. ");
INSERT INTO txq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Boe ma Ana namanasa ana nunin nara nae, “Ela kakana anar raa reni Au mai! Boso mamanggenggee sara! Huu hatahori mana sama leo sira iar, ndia Manetualain hatahorin.” ");
INSERT INTO txq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Boe ma Ana ndae liman neu kakana anar raa ma noke-hule fo Manetualain fee babaꞌe-babatik neu sara. Basa boe ma Ana laꞌo ela mamanak naa. ");
INSERT INTO txq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Laꞌe esa, hambu hatahori mai natane Yesus nae, “Papa Meser! Au muste tao hata malole talo bee, mita fo au bubuluk no tetuk ae, au bisa maso nusa tetuk do inggu temak? Huu au ae asoda akandoo ua Manetualain.” ");
INSERT INTO txq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Boe ma Yesus naselu nae, “Tao hata de o matane Au laꞌe-neu hata fo malole? Kada Manetualain ndia malole. Mete ma o mae masoda muan, na, leo-laꞌo tungga Ndia parendan.” ");
INSERT INTO txq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Hatahori naa natane bali nae, “Parenda bee naa?” Boe ma Yesus naselu nae, “Boso makanisa hatahori; boso laꞌok sala mua ta o saom; boso mamanaꞌo; boso dadi sakasii pepeko-lelekok; ");
INSERT INTO txq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","fee hada-horomatak neu o inam ma o amam; ma sue neu o toranoom sama leo o sue o ao heli-helim.” ");
INSERT INTO txq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hatahori naa naselu nae, “Basa parenda raa, au tao tungga sara ena. Bei kuran hata bali?” ");
INSERT INTO txq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus namanene nala naa, boe ma Ana nae, “Mete ma o mae tungga Manetualain hihii-nanaun lalaꞌen, na, fali muu ngga fo seꞌo heni basa o hata-hetom lalaꞌen. Basa naa, muu babaꞌe doin nara fee hatahori mana toꞌa taak kara. Basa dei fo o mai tungga Au. Huu neu ko Manetualain bala fee o hata-heto manahetak nai nusa tetuk do inggu temak.” ");
INSERT INTO txq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hatahori naa namanene nala naa, boe ma ana fali neu ngga no dalen sona, huu suꞌin noꞌun seli. ");
INSERT INTO txq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Basa boe ma Yesus kokolak no ana nunin nara nae, “Mamahere Au, hatahori kamasuꞌik susa laꞌe esak kana maso nusa tetuk do inggu temak. ");
INSERT INTO txq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ndia sususan naa, nok bali banda onta moꞌok esa maso neni lalaen neu nesik ndandauk bolon.” ");
INSERT INTO txq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesus ana nunin nara ramanene rala naa, boe ma ara heran bali-bali. De ara raselu rae, “Mete ma talo naa, na, see ndia bisa maso nusa tetuk do inggu temak?” ");
INSERT INTO txq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus mete natalolole sara, boe ma Ana kokolak nae, “Mete ma hatahori dae-bafok ndia tao, memak ta bisa dadi. Tehuu mete ma Manetualain ndia tao, basan bisa dadi!” ");
INSERT INTO txq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Boe ma Petrus fee nesenedak nae, “Papa! Ai laꞌo ela basa ai hata-heton lalaꞌen ena, fo tungga Papa. Tehuu ai hambu hata?” ");
INSERT INTO txq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus naselu nae, “Mamahere neu Au! Mete ma Manetualain nakadadadik basan dadi beuk ena, neu ko Au Hatahori Dae-bafo Isi-isik ia, anggatuuk nai kadera man-parenda moꞌo-inahuuk. Faik naa, ei mana tungga Au oo manggatuuk tungga boe nai kadera man-parenda salahunu dua dadi miu mana maketu-maladi dedeꞌak soa-neu ita leon Israꞌel kasalahunu duak kara! ");
INSERT INTO txq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hatahori mana laꞌo ela ndia uman, kaꞌa-fadin, ina-aman, anan nara ma ndia osi-lutun fo tungga Au, neu ko ana simbo falik losa lipa laꞌe natun esa. Ma neu dae-bafok fai mateꞌen, ana oo nasoda nakandoo no Manetualain boe. ");
INSERT INTO txq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Dadi masaneda, ee! Tungga Manetualain duduꞌan, hatahori noꞌuk mana soꞌuk aon leo hatahori moꞌo-inahuuk, sira raa, ndia hatahori kadiꞌin lenak. Tehuu hatahori mana tao aon leo hatahori kadiꞌik, sira raa, ndia hatahori moꞌo-inahuuk, tungga Manetualain duduꞌan.” ");
INSERT INTO txq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Basa naa Yesus fee nenorik nae, “Manetualain totoꞌu parendan naa, sama leo lololek ia: hambu tenu osik esa kalua bei liꞌu nee huhua anan, neu sangga hatahorir fo raue nai ndia osi anggor. ");
INSERT INTO txq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ana hambu hatahori mana maue-osar, boe ma rala harak fo raue-osa faik esa, babaen doi lilo fulak esa, tungga belin fo rateme ralak. Raketu basa, boe ma ana nadenu sara reu raue nai ndia osin. ");
INSERT INTO txq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Liꞌu sio huhuan, boe ma ana kalua bali neni pasar neu. Numa naa, ana mete-nita hatahori ketuk ranggatuuk nado nggoa-nggoak ka. ");
INSERT INTO txq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Boe ma ana nafada sara nae, ‘Wee, kaꞌa nggara ein, ee! Ei nau tao ues nai au osing, do? Neu ko au bae ei no mandaak.’ Ara ramanene talo naa, boe ma rakahuꞌu a, de reu raue-osa. ");
INSERT INTO txq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Liꞌu salahunu dua ledo tetun, ma liꞌu telu ledo bobon, tenu osik kalua numa uman mai, fo neu sangga hatahori mana maue-osa bali. ");
INSERT INTO txq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ledo bobok ena, fama te liꞌu lima, boe ma tenu osik naa kalua bali. Ana mete neu-mai te bei hambu hatahori kada rambarii hiek. Boe ma natane sara nae, ‘Tao hata de ei kada mambariik ta tao hata esa boe na numa huhuak ka losa ledo bobok ia?’ ");
INSERT INTO txq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Hatahorir raa raselu rae, ‘Papa, ee! Ta hambu hatahori fee ai ues.’ Boe ma tenu osik naa nae, ‘Mete ma talo naa, na, ei miu tao ues nai au osing leo!’ ");
INSERT INTO txq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Losa liꞌu fo hahae tao ues, boe ma tenu osik naa nanggou nala ndia mandor, de nae, ‘Manggou hatahori mana maue-osar raa fo bae sira esa-esak doi ue-osan. Mulai numa hatahori mana maso bakahitok losa hatahori mana maso makasososak naa.’ ");
INSERT INTO txq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Boe ma mandor naa nanggou hatahorir raa mulai numa mana tao ues liꞌu lima ledo bobon. Ana fee sara esa-esak simbo doi lilo fulak esa. ");
INSERT INTO txq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Basa de mandor naa nanggou hatahori mana maue-osa laen nara, losa mana maue-osa ndia liꞌu nee huhua anan. Mana tao ues numa huhuan mai duꞌa rae, neu ko sira simbo noꞌun lena heni hatahori fo mana tao ues numa liꞌu lima ledo bobon mai. Naa te sira oo, simbo doi lilo fulak esa boe. ");
INSERT INTO txq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ara simbo rala talo naa, boe ma unggu-remu neu tenu osik naa rae, ");
INSERT INTO txq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Aweꞌ! Ta bisa talo ia, papa! Sira mana maik bakadean seli, tao ues kada liꞌu esak ka. Tehuu ai mana maik numa huhua anan mai, maue-osa fafandek lima-ein losa ai mbusen nara faa! Tehuu talo bee de papa bae ai sama leo sira raa?’ ");
INSERT INTO txq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Boe ma tenu osik naselu neu sira esa nae, ‘Kaꞌa, ee! Au ta panake kaꞌa, nahuu kaꞌa mesa kana ndia nakaheik tao ues faik esa, na, babaen doi lilo fulak esa. Tebe, hetu? Dadi au bae tungga ita nekeketun, hetu? ");
INSERT INTO txq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Malole lenak kaꞌa simbo nala kaꞌa doin fo fali muu ngga leo. Mete ma au ae fee hatahori fo mana tao ues bakahitok numa kaꞌa mai, noꞌun sama no au feek neu kaꞌa, na, au haak naa. ");
INSERT INTO txq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Au ae pake au doing talo bee a mesan tungga kada au hihiing. Talo bee de kaꞌa nasakele nahuu au dale maloleng?’ ");
INSERT INTO txq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Leo naak oo, neu Manetualain dadi neu manek soa-neu hatahorir boe, Ana bala hatahorin nara tungga Ndia hihiin. Dadi hatahori mana mai bakahitok, neu ko ana simbo babaꞌen sama leo hatahori mana mai makasososak. Ma hatahori mana mai makasososak, neu ko ana simbo ndia babaꞌen sama leo hatahori mana mai bakahitok.” ");
INSERT INTO txq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Basa boe ma Yesus asa laꞌo reni Yerusalem reu. Neu ara bei laꞌok numa dalak, Ana nanggou nala ana nunin nara fo rakabua mesa kasa roon. Boe ma Ana nafada seluk bali nae, ");
INSERT INTO txq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ei nenene, ee! Hatematak ia ita tae teni Yerusalem teu. Tehuu nai naa ara seꞌo heni Au, Hatahori Dae-bafo Isi-isik ia uni malangga anggama Yahudi malanggan nara, ma meser anggamar uu. Boe ma ara raketu hukun mates neu Au. ");
INSERT INTO txq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","De ara loo lima Au uni hatahori feꞌek ta mana nalela Manetualain uu. Boe ma ara kokolak rakamamaek Au. Ma ara poko-femba rakalulutu Au ao-mbaang. Basa dei fo ara tao risa Au nai ai ngganggek lain. Memak Au mate tetebes. Tehuu neu bei-nesan, Au asoda fali numa mamates mai.” ");
INSERT INTO txq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Basa boe ma Sabadeus saon neni Yesus neu, sama-sama no anan Yakobis ma Yohanis. Boe ma ana sendek luu-langgan ma fee hada-horomatak fo kokoe nakandoo Yesus. ");
INSERT INTO txq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","De Yesus natanen nae, “Mama parluu hata?” Boe ma inak naa nafada nae, “Talo ia, Papa! Au hule mete ma Papa nanggatuuk toꞌu parenda ena, na, Papa soꞌuk nala au anang dua ia, fo ara oo tungga toꞌu parenda sama-sama ro Papa boe. Au hule fo Papa nanggatutuuk esa neu Papa boboa konan, ma esa neu Papa boboa kiin.” ");
INSERT INTO txq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesus namanene nala inak naa nonoken, boe ma Ana kokolak no Yakobis ma Yohanis nae, “Ei ta bubuluk hata fo ei mokek. Neu ko Au hambu doidosok noꞌuk ka. Dadi talo bee? Ei duꞌa mae, ei oo mabeꞌi lemba-masaa doidosok naa sama-sama mia Au boe, do?” Dua sara raselu leli-belak kana rae, “Bisa malan seli Papa, ee!” ");
INSERT INTO txq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Boe ma Yesus naselu bali nae, “Memak, neu ko ei oo lemba-masaa doidosok naa, sama leo Au boe. Tehuu neu ko see ndia nanggatuuk nai Au boboa konan do boboa kiin, naa Au ta ndia aketu. Manetualain ndia naena haak fo naketun. Ana naketu memak kana ena, see ndia nanggatuuk nai mamanak naa.” ");
INSERT INTO txq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Neu ana nuni laen kasalahunuk kara ramanene rala dua sara nonoken talo naa, boe ma ara rasakele. ");
INSERT INTO txq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tehuu Yesus nanggou nala basa sara, boe ma Ana nae, “Talo ia! Ei bubuluk ena, hetu? Hatahori moꞌo-inahuuk kara mana toꞌu parenda rasiꞌe tuni-ndeni sira rau-inggun, losa ara ta bisa rakaundak. Ma malangga nusak kara fo ta mana malela Manetualain, ara fee parenda lena-lenak, losa sira rau-inggun nara ta bisa botik rala langgan nara. ");
INSERT INTO txq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tehuu ei ta bole tao talo naa! See numa ei mai nau dadi neu hatahori moꞌo-inahuuk, ana muste dadi neu ata-dato fo naono-lalau hatahori laen. ");
INSERT INTO txq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma see ndia nau dadi neu malanggan, ana muste tao aon sama leo ata-dato. ");
INSERT INTO txq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nenene, ee! Au oo leo naak boe. Au, Hatahori Dae-bafo Isi-isik ia, mai fo aono-lalau hatahori. Au ta mai fo hatahori naono-lalau Au. Tehuu Au mai fo fee Au sodang katematuan, fo tefa-soi hatahori noꞌuk ka numa sira sala-singgon nara mai.” ");
INSERT INTO txq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Basa naa, Yesus asa laꞌok rakandoo. Neu ara kalua numa kota Yeriko mai, hambu hatahori noꞌuk ka laꞌok tungga sara. ");
INSERT INTO txq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Numa naa, hambu hatahori pokek dua ranggatuuk numa dalak tatain. Neu dua sara ramanene rae, mana laꞌok nesik naa, ndia Yesus numa Nasaret mai, boe ma ara bolu rahere rae, “Lamatuak! Dauk tititi-nonosin, ee! Ai mahani a doon seli ia neu Lamatuak ena! Kasian neu ai dei!” ");
INSERT INTO txq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Hatahorir ramanene rala dua sara bolu talo naa, boe ma ara kaꞌi sara rae, “Weeh! Ei dua ngga boso mamue!” Tehuu dua sara kii-bolu rahere bali rae, “Lamatuak, ee! Dauk tititi-nonosin, ee! Kasian neu ai dei!” ");
INSERT INTO txq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Neu Ana namanene talo naa, boe ma Ana nambarii taak, de natane sara nae, “Ei nau Au tao hata fee ei?” ");
INSERT INTO txq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ara raselu rae, “Lamatuak, ee! Tulun fo ai bisa mete-mita dei!” ");
INSERT INTO txq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus namanene nala kokolan nara talo naa, boe ma dalen tuda kasian neu sara. De Ana nafaroe matan nara, boe ma ara mete-rita tutik kana. Basa boe ma ara laꞌok tungga Yesus. ");
INSERT INTO txq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Basa naa, Yesus asa laꞌok rakandoo losa nggorok esa nade Betfage, nai letek Setun tatain. Nggorok naa deka-deka no kota Yerusalem ena. Ara hahae taak numa naa. Boe ma Ana nadenu ana nunin dua rakahuluk. ");
INSERT INTO txq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ana parenda sara nae, “Ei dua ngga meni nggorok naa miu. Mete ma ei maso, neu ko ei mete-mita banda keledei ina no ana tenan esa, neni paꞌak kara rai naa. Ei miu sefi heni talin nara, fo leꞌa meni sara ia mai fee Au. ");
INSERT INTO txq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tehuu mete ma hambu hatahori natane ei nae, ‘Tao hata de ei leꞌa meni hatahori keledein?’ Na, ei maselun mae, ‘Lamatuak nae paken. Mete ma pake basa ena, neu ko Ana haitua fali memak kana.’ ");
INSERT INTO txq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Basa iar muste dadi, tungga hata fo Manetualain mana toꞌu dedeꞌan surak memak kana ena nae, ");
INSERT INTO txq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Hee, ei hatahori Yerusalem mara ein! Mai fo mete ia dei! Te ei Manem mai ena. Ana mai no dale nekeloloen. Ana mai no saꞌe banda keledei tenak.’ ” ");
INSERT INTO txq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Basa boe ma ana nunin nara reu, ma tao tungga basa-basan, ndaa no Yesus helu neu sara ena. ");
INSERT INTO txq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ara leꞌa roo keledei ina no ana tenan reni Yesus reu. Boe ma ara bela lafan nara neu reredon, de Ana saꞌe neu lain fo nae maso neni kota neu. ");
INSERT INTO txq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Neu ara rae maso reni kota dale reu, boe ma hatahori noꞌuk kara haꞌi rala lafan nara ma ndae arun nara, fo bela sara reu dalak. Hambu ketuk reu tati rala mbua sina doon nara, fo ara nggenggela sara reu dalak. No dalak naa, ara tao tanda rae, ara soru Yesus sama leo hatahori moꞌo-inahuuk. ");
INSERT INTO txq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Boe ma hatahori ketuk laꞌok rakahuluk resik Yesus matan, ma ketuk tungga dean. Ara eki rame-rame rae, “Hosana! Ai koa-kio Manetualain! Huu Dauk tititi-nonosin mai ena! Hosana! Ai koa-kio Manetualain! Huu Lamatuak nadenu Hatahori ia mai ena. Hosana! Ai koa-kio Manetualain! Huu Lamatuak nanggatuuk toꞌu parenda memak nai lalai fo demak mateꞌen!” ");
INSERT INTO txq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Neu Yesus maso Yerusalem no rame-rame talo naa, boe ma kota isin lalaꞌen kalua, de ratane rae, “Awii! See ndia mai ia?” ");
INSERT INTO txq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hatahori noꞌuk kara raselu rae, “Ndia ia, Manetualain mana toꞌu dedeꞌan. Naden Yesus, hatahori Nasaret, numa profensi Galilea mai.” ");
INSERT INTO txq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Basa boe ma Yesus asa laꞌok rakandoo, de maso reni Manetualain Uma Huhule-haradoi Ina-huun reu. Numa Uma Huhule-haradoik naa bebelan, hatahori taon dadi neu pasar ena, fo ara raseseꞌo mbui lunda sinar, ndia hatahori paken dadi tunu-hotuk soa-neu huhule-haradoik. Yesus mete-nita talo naa, boe ma Ana neu husi-mbuu kalua heni sara. Ana fae nggari heni basa meir fo ara pake tuka doik, ma fae nalengga heni basa banggur fo ara pake raseseꞌo mbuik kara. ");
INSERT INTO txq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Boe ma Ana nafada sara nae, “Manetualain mana toꞌu dedeꞌan surak ena nae, ‘Au ambadedeik Uma ia, mita fo hatahorir bisa mai hule-haradoi nai ia.’ Manetualain nanaun talo naa, tehuu ei tao Uma ia dadi neu naꞌo manu-meor mamana nekebuan!” ");
INSERT INTO txq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Basa boe ma hatahori pokek ma hatahori keko-luꞌuk kara reni Yesus mai numa Manetualain Uma Huhule-haradoin naa. De Ana tao nahai basa sara. ");
INSERT INTO txq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Numa naa oo hambu malangga anggama Yahudi malanggan nara ma meser anggamar boe. Neu ara mete-rita Yesus tao tanda heran talo naa, boe ma ara rasakele. Lena-lenak bali, neu ara ramanene kakanak kara bolu rame-rame numa Uma Huhule-haradoik rae, “Hosana! Ai koa-kio Manetualain! Huu mane Dauk tititi-nonosin mai ia ena!” ");
INSERT INTO txq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Basa de malanggan nara raa kokolak reu Yesus rae, “Heeh! O mamanene kakanak kara raa kokolan? Naa, ta ndaa naa!” Tehuu Yesus naselu sara nae, “Hou, Au amanene. Te hata de? Ei bei ta lees mita nai Manetualain Susura Malalaon laꞌe-neu kakanak kara fo mana koa-kio Manetualain, do? Nai naa neni surak nae, ‘Manetualain sadia memak kakana mbimbila anak ma kakana kadiꞌi anak, fo ara koa-kio neu Ndia.’ ” ");
INSERT INTO txq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Basa boe ma Yesus asa kalua laꞌo ela kota naa, fo reu sunggu nai nggorok Betania. ");
INSERT INTO txq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Neu beꞌe-mai huhua anan, Yesus asa laꞌok bali fo maso fali reni kota Yerusalem reu. Tehuu neu ara bei laꞌok numa dalak, Ana nameda ndoe ena. ");
INSERT INTO txq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ana mete-nita ai huuk esa numa dalak tatain fo hatahorir rasiꞌe raꞌa boan. De Ana neu deka-deka no ai huuk naa, fo nae mete sudik kaboak do taa. Neu Ana losa ai huuk naa, Ana ta mete-nita boak esa boe na, tehuu mete-nita kada ai huuk naa doon. Boe ma Ana kokolak mbali ai huuk naa nae, “Huu o ta fee o boam soa-neu Au, de o ta bisa maboa ena!” Ana kokolak basa, boe ma ai huuk naa namatuu tutik kana. ");
INSERT INTO txq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ana nunin nara mete-rita talo naa, boe ma ara nggengger. Ara ratane rae, “Tao hata de medak neu ma ai huuk ia namatuu tutik kana?” ");
INSERT INTO txq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Boe ma Ana naselu nae, “Nenene matalolole, ee! Mete ma ei mamahere tebe-tebe neu Manetualain, ma ta madale duak faa boe na, ei bisa tao sama leo Au taok naa ena. Ei oo bisa tao lena heni naa boe. Haꞌi netuduk leo: ei bisa parenda letek esa fo lali neni tasi neu. Neu ko Manetualain lali heni memak letek naa, sadi ei mamahere tebe-tebe neu Ndia! ");
INSERT INTO txq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Basa hata fo ei moke neu Manetualain, neu ko ei simbon, sadi ei mamahere tebe-tebe neu Ndia.” ");
INSERT INTO txq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Basa boe ma Yesus asa laꞌok rakandoo. Losa Yerusalem, ara maso fali reni Uma Huhule-haradoi Ina-huuk bebelan reu bali. Neu Ana nanori hatahorir laꞌe-neu Manetualain eno-dala ndoon, boe ma malangga anggama Yahudi malanggan nara ma lasi-lasi hadak kara mai rakaseseluk dedeꞌak roon rae, “See ndia nadenu o mai tao nemuek numa ia ndia afik ka? See ndia fee o haak naa?” ");
INSERT INTO txq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tehuu Ana bubuluk ara sangga dalak fo rae rakatutudak Ndia. Boe ma Ana bala nae, “Au oo ae atane ei boe. Ei maselu Au dei, dei fo Au aselu ei. ");
INSERT INTO txq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Au ae atane talo ia: ei basa ngga malela Yohanis Mana Saranik naa, hetu? See ndia feen haak fo ana sarani hatahorir? Manetualain, do hatahori dae-bafok?” Boe ma ara duduꞌa reu-mai, ma rakokola aok rae, “Awii! Ikek nala ita ia ena, ma! Huu mete ma ita taselu tae, ‘Manetualain ndia feen haak’, neu ko Ana bala nae, ‘Mete ma talo naa, tao hata de ei ta mamahere Yohanis?’ ");
INSERT INTO txq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tehuu ita oo ta bisa tae, ‘Hatahori dae-bafok ndia feen haak’ boe, neu ko basa hatahorir ramue mbali ita, nahuu ara ramahere rae, Yohanis naa, Manetualain mana toꞌu dedeꞌan.” ");
INSERT INTO txq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Huu naa de ara raselu mbali Yesus rae, “Ai ta bubuluk.” Boe ma Yesus bala nae, “Dadi mete ma talo naa, Au oo ta parluu afada see ndia fee haak neu Au boe.” ");
INSERT INTO txq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus kokolak nakandoo no malanggan nara raa nae, “Ei duꞌa talo bee laꞌe-neu lololek ia? Hambu amak esa no ana toun dua. Ana parenda ana ulun nae, ‘Anang gee! O muu maue-osa nai osi dale faik ia dei.’ ");
INSERT INTO txq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tehuu kanak naa naselu nae, ‘Eeh! Au ta uu.’ Tehuu ta dook ka boe ma ana fale dalen de ana neu. ");
INSERT INTO txq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Basa boe ma amak naa nadenu ana kaduan nae, ‘Anang gee! O muu maue-osa nai osi dale faik ia dei.’ Boe ma kanak naa naselu nae, ‘Malole papa. Dei fo au uu.’ Naa te ana ta neu.” ");
INSERT INTO txq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yesus tui basa talo naa, boe ma natane sara nae, “Au ae atane talo ia: numa kakana kaduak kara raa mai, see ndia tao tungga aman parendan naa?” Boe ma ara raselu rae, “Ndia makasososak naa!” Basa de Ana kokolak nae, “Hou. Nenene matalolole, huu Au kokolang ndia ndaa. Hatahori fo ei henggenee malan ta kambareek kara, sama leo mana susu bea ia ma ina petak, neu ko ara maso dadi reu Manetualain hatahorin rakahuluk ruma ei mai. Huu ei kada mataa hie-hie mbali Manetualain, tehuu ei ta tao tungga Ndia hihii-nanaun. ");
INSERT INTO txq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Fai bakahulun, Yohanis Mana Saranik nanori ei ena, dalak talo bee fo ei bisa leo-laꞌo no ndoos. Tehuu ei ta nau mamahere neu sana. Naa te neu faik hatahori ta kambareek kara ramanene Yohanis, ara laꞌo ela basa sira sala-singgon nara fo tungga ndia nenorin naa. Ei oo bubuluk mala basa naar ena boe. Tehuu ei ta nau hahae numa ei sala-singgom mara mai, fo tungga Manetualain hihii-nanaun.” ");
INSERT INTO txq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Basa naa, Yesus tui lololek esa bali nae, “Hambu tenu daek esa neu nasosoi nambalao osi beuk fo nae sele ai anggor neu ndia daen lunggun. Basa de ana mbaꞌa eko-feon. Ma ana tao baak fo nae rumu-keꞌe anggor oen. Boe ma ana nambaririik mamana nenea demak. Basa de ana fee osi naa neu mana maue osir fo ara raue ma rabaꞌe buna-boan nara roon. Boe ma ana laꞌo neni nusa feꞌek neu. ");
INSERT INTO txq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Losa fai ketu anggor boan, boe ma tenu osik naa nadenu ndia hatahori mana maue-osan neni mana maue osir neu, fo noke ndia babaꞌen. ");
INSERT INTO txq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tehuu mana maue osir ta hosek ndia hatahori mana maue-osan naa. Ketuk hambu fefembak, ketuk rakanisa sara, ma ketuk neni tokok renik batu. ");
INSERT INTO txq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tehuu tenu osik naa nadenu seluk ndia hatahori mana maue-osan nara bubuak esa moꞌon lena makasososak naa. Tehuu mana maue osir raa oo, tao manggarauk talo naa neu basa sara boe. ");
INSERT INTO txq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Doo-doo boe ma, tenu osik naa nadenu ndia ana heli-helin. Huu ana duꞌa nae, ‘Mete ma au adenu au ana heli-heling, neu ko ara simbok no malole, ma ramanene neun.’ ");
INSERT INTO txq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tehuu neu mana maue osir raa mete-rita kanak naa, boe ma ara rakokola aok rae, ‘Heeh, ei mete dei! Tou lasik nadenu ndia ana heli-helin mai ena. Neu ko ana ndia simbo nala tou lasik pusakan lalaꞌen. Dadi mai fo ita tao tisan leo, mita fo ita ndia laꞌe tala osi ia.’ ");
INSERT INTO txq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Boe ma ara humu rala kanak naa, de ara nggarin neni osi deak neu fo tao risan.” ");
INSERT INTO txq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesus tui basa, boe ma natane sara nae, “Au ae atane talo ia: mete ma tenu osik naa fali mai ngga, nai rarain ana tao mana maue osir raa talo bee?” ");
INSERT INTO txq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Boe ma hatahori Yahudi malanggan nara raselu rae, “Neu ko ana nakanisa basa hatahori manggarauk kara raa. Basa naa, ana fee hatahori laen seba osi naa, fo neu ko baꞌe buna-boan ndaa no fain.” ");
INSERT INTO txq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Boe ma Yesus kokolak no sara nae, “Fama te ei bei ta lees mita hata fo neni surak nai Manetualain Susura Malalaon nae, ‘Hambu batu esa, tukan batur nggari henin, tehuu hatematak ia batu naa dadi neu uma batu netehuun ena! Manetualain mesa kana ndia here nalan, boe ma nanggatutuuk batu naa. Huu naa de ita mete-titan lolen seli!’ ” ");
INSERT INTO txq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Boe ma Yesus tuti kokolan nae, “Dadi ei duduꞌa matalolole, ee. Fai bakahulun Manetualain here nala ita hatahori Yahudir ia, fo dadi teu Ndia hatahorin. Tehuu ei ta nau tao matak mbali Au, de neu ko Manetualain here hatahori laen. Kada hatahori mana leo-laꞌo tungga Manetualain hihii-nanaun, ndia bisa maso dadi neu Manetualain hatahorin. ");
INSERT INTO txq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Au afada no kada ndoo-tetun. Au ia, ndia batu netehuuk naa. Hatahori mana tuda laꞌe-ndaa batu ia, neu ko nakalulutu. Ma mete ma batu naa tuda laꞌe hatahori, neu ko hatahori naa dadi makararafuk memak.” ");
INSERT INTO txq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Neu malangga anggama Yahudi malanggan nara, ma hatahori Farisir ramanene rala Yesus tutuin, boe ma ara bubuluk rae, lololek naa ndee laꞌe sira. Sira tetuk sama leo mana maue osir raa, ma tukan batu mana nggari heni batu netehuuk naa. ");
INSERT INTO txq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","De ara ramanasa ralan seli. Boe ma ara duduꞌa de rala harak fo rae humu Yesus. Tehuu ara ramahia hatahori noꞌuk kara fo mana tao leo Yesus naa, Manetualain mana toꞌu dedeꞌan. Huu naa de ara oo ta bisa tao hata-hata mbalin boe. ");
INSERT INTO txq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Basa de Yesus kokolak seluk no sara pake lololek nae, ");
INSERT INTO txq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Manetualain parenda-koasan naa, sama leo manek esa tao feta kabin soa-neu ana toun. ");
INSERT INTO txq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Neu raole rala feta ena, boe ma ana nadenu atan fo neu nafada basa hatahorir neni nokek kara nae, ‘Mai leo, te feta nae mulai ia ena.’ Tehuu hatahorir raa ta nau mai. ");
INSERT INTO txq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Boe ma atar raa lenggu fali de rafada manek. Manek namanene nala naa, boe ma nadenu ata laen nara nae, ‘Ei miu mafada basa hatahorir fo mai leo, huu sadia ala feta ena. Au tati sapi ena, ma dode-nasu malada-malada ena. Madenu sara mai raꞌa feta leo, huu basan neni sadiak ia ena.’ ");
INSERT INTO txq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Atar raa reu rafada talo naa. Tehuu hatahori neni nokek kara raa ta nau tao matak. Ketuk reni osi reu, ketuk reni mamana ue-osan reu, ");
INSERT INTO txq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ma ketuk humu rala manek atan nara fo tuni-ndeni sara losa mate. ");
INSERT INTO txq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Manek namanene nala naa, boe ma namanasa nalan seli. De Ana nadenu soldadun nara reu rakanisa basa hatahorir mana rakanisa ndia atan nara. Basa de soldadur raa hotu heni kota naa losa natetu no daer. ");
INSERT INTO txq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Boe ma manek naa nanggou ndia ata laen nara ma nafada nae, ‘Feta kabin neni sadiak ena, tehuu hatahorir fo au okek kara ena, ta randaa tungga au fetang. ");
INSERT INTO txq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hatematak ia ei kalua meni dala ramer miu moke see a mesan, fo ei matonggo mia sara rai naa.’ ");
INSERT INTO txq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Boe ma atar raa reni dala ramer reu. Ara roo hatahori noꞌuk ka fo ratonggo sara ruma naa, de reni feta kabin reu. Hambu hatahori neulauk kara, ma hambu hatahori manggarauk mana mai tao rasofe mamana feta naa. ");
INSERT INTO txq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Basa de manek naa maso neni mamana feta neu, de mete ndule ndia fuin nara. Boe ma ana mete-nita fuik esa ta pake bua-loꞌa feta. ");
INSERT INTO txq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","De manek natanen nae, ‘Tia-lai, ee! Tao hata de o maso ia mai ta pake bua-loꞌa feta?’ Tehuu hatahori naa panggananaa namanggonggoak kana. ");
INSERT INTO txq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Boe ma manek parenda atan nara nae, ‘Futu hatahori ia lima-ein nara fo pirun neni dea naa neu, mita fo ana buꞌi ma doidoso nai mamana makiuk naa.’ ");
INSERT INTO txq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Leo naak oo, Manetualain noke hatahori noꞌuk ka boe, tehuu Ana here nala kada hidak ka fo dadi neu Ndia hatahorin.” ");
INSERT INTO txq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hatahori Farisir ramanene rala Yesus kokolak talo naa, boe ma ara rala harak fo rae ike ma rakasasaꞌek salak neu Yesus. ");
INSERT INTO txq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","De ara radenu sira ana nunin nara sama-sama ro hatahori numa Herodes partei politik mai, fo reu rakaseseluk dedeꞌak ro Yesus. Ara rakadedemak kana rae, “Papa Meser! Ai bubuluk Papa dalen ndoos. Papa ta mana pepeko-lelekok ma ta mete matak. Papa soa fee nenorik laꞌe-neu Manetualain Dedeꞌa-kokolan no tetuk. ");
INSERT INTO txq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hatematak ia ai nau matane dedeꞌak esa. Tungga ita anggama Yahudi hohoro-lalanen, ndondoon naa ita muste bae bea fee man-parenda Roma mane ina-huun, do taa?” ");
INSERT INTO txq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tehuu Yesus bubuluk nae, ara rae ike Ndia naa ena fo Ndia kokolak laban man-parenda Roma. Boe ma Ana naselu nae, “Memak, ei hatahori mana dea-matak! Tao hata de ei mae ike Au menik dedeꞌak naa? ");
INSERT INTO txq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Matudu sudik doi lilo fulak esa fo hatahorir paken bae bea mai Au dei!” De ara ratudu doi lilo fulak esa neun. ");
INSERT INTO txq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Boe ma Ana natane sara nae, “Ia, see nggambar ia? Ma ia, see naden ia?” ");
INSERT INTO txq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ara raselu rae, “Naa keser, man-parenda Roma mane ina-huun naa.” Boe ma Yesus nafada sara nae, “Dadi mete ma talo naa, ei miu fee man-parenda hata fo man-parenda haak. Ma fee Manetualain hata fo Manetualain haak.” ");
INSERT INTO txq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ara ramanene rala Ana naselu talo naa, boe ma basa sara heran bali-bali, huu Ana kokolak ndaa, na. Huu naa de ara ta bisa ike sana. Boe ma ara laꞌo elan leo. ");
INSERT INTO txq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Numa naa oo, hambu hatahorir ruma partei Saduki mai boe. Hatahorir maruma partei Saduki mai ia fee nenorik rae, hatahori mates ta nasoda fali numa mamaten mai. Faik naa ara oo, sangga dalak fo rae ike Yesus boe. Huu naa de ara mai rakaseseluk dedeꞌak roon rae, ");
INSERT INTO txq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Papa Meser! Baꞌi Musa surak ela fee ita dala-hadak ia ena nae, mete ma touk esa mate laꞌo ela saon, tehuu anak taa, na, touk naa fadin muste sao nala ina falu naa, mita fo ana fee tititi-nonosik soa-neu kaꞌan mana matek naa ena. ");
INSERT INTO txq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Memak lele uluk baꞌi Musa fee nenorik talo naa, tehuu hatematak ia, ai nau matane talo ia: hambu touk hitu kaꞌa-fadik kara. Uluk sao, tehuu maten ma ta laꞌo ela anak. Boe ma fadin mana tunggan, sao nasafali ina falu naa. ");
INSERT INTO txq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ta dook ka, ana oo mate boe, ma anak taa. Leo naak oo no fadik katelun boe; ana sao nala ina falu naa, tehuu ana oo mate boe, ma ta laꞌo ela anak. Talo naa nakandoo losa fadi muri anak oo, maten boe. ");
INSERT INTO txq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Basa boe ma ina falu naa maten. ");
INSERT INTO txq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dadi hatematak ia, ai nau matane talo ia: inak naa sao nita no touk hitu ena. Neu ko neu dae-bafok fai mateꞌen, Manetualain nasoda falik hatahori mates sara, inak naa dadi neu see saon, ou?” ");
INSERT INTO txq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Boe ma Yesus naselu nae, “Mete ma ei matane talo naa, na, ei sala moꞌok ia ena! Ei ta malela Manetualain Susuran isin. Ma ei oo ta bubuluk Ndia koasan ta neni babanggak boe! ");
INSERT INTO txq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ndoon talo ia. Neu Manetualain nasoda falik hatahori mates sara, ta hambu dedeꞌa sasaok soa-neu sara ena, sama leo Ndia atan nara marai nusa tetuk do inggu temak. ");
INSERT INTO txq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ma Au oo nau kokolak laꞌe-neu hatahori mates bisa nasoda fali numa mamaten mai, do taa boe. Nai baꞌi Musa susuran hambu tutuik naꞌu ai ana neni hotuk, tehuu ta kade sana. Numa tutuik naa mai, ita bubuluk tae, hatahori mates bisa nasoda fali numa mamaten mai. Numa naa Manetualain nafada baꞌi Musa nae, ");
INSERT INTO txq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Au ia, Manetualain numa o baꞌim mara mai, sira baꞌi Abraham, baꞌi Isak, ma baꞌi Yakob. Basa sara rakaluku-rakatele rakandoo neu Au, losa hatematak ia.’ Ita bubuluk tae, neu Manetualain kokolak talo naa, baꞌir raa mate dook ka ena. Tehuu Manetualain nafada nakandoo nae, Ndia bei dadi neu sira Lamatuan. Huu naa de ita bubuluk tae, sira samanen nara bei rasoda rakandoo, leo mae ara mate dook ka ena. Dadi leo mae hatahori mate, tehuu ana nasoda fali numa mamaten mai. Kada hatahori masodak ndia mana nakaluku-nakatele neu Manetualain, ta hatahori mates, hetu?!” ");
INSERT INTO txq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hatahori Sadukir raa ramanene rala Yesus fee nenorik talo naa, boe ma ara ta bisa bala hata-hata bali. Tehuu hatahori noꞌuk kara raa heran bali-bali, de kokolak rae, “Awii! Hatahori ia nenorin ta neni babanggak, ee!” ");
INSERT INTO txq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Neu hatahori Farisir ramanene rala rae, Yesus bala nala hatahori Saduki raa ena, boe ma ara rakabua rame-rame fo rae rakaseseluk dedeꞌak roon. ");
INSERT INTO txq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sira mana malela anggaman esa nae ike sudik Yesus nae, ");
INSERT INTO txq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Papa Meser! Au nau atane talo ia: ita hohoro-lalanen, ma anggama parendan, noꞌun seli. Numa basa parendar fo maruma baꞌi Musa mai naa, bee ndia nenenin lenak?” ");
INSERT INTO txq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Boe ma Yesus naselu nae, “Parenda fo nenenin lenak nai Manetualain Susura Malalaon naa nae talo ia: ‘Manetualain naa, ei Lamatuam. Dadi ei muste sue-lai neu Ndia lena heni basa-basan. Huu naa de ei muste hii malan seli neun, malela Ndia, ma maue-osa fafandek lima-eim mara fo tungga Ndia hihii-nanaun.’ ");
INSERT INTO txq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Parenda naa, nenenin lena basan, ma ta neni babanggak! ");
INSERT INTO txq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma hambu parenda kaduan nae leo ia: ‘O muste sue hatahori laen nara, sama leo o sue o ao heli-helim.’ ");
INSERT INTO txq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Parenda kaduak kara ia, ndia huuk numa baꞌi Musa hohoro-lalanen ma Manetualain mana toꞌu dedeꞌan nara nenorin lalaꞌen. Ta bisa dadi, hatahori tungga parenda laen nara, mete ma ana ta tungga nakahuluk parenda moꞌo kaduak kara iar.” ");
INSERT INTO txq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Faik naa, hatahori Farisir bei rakabua numa naa, boe ma Yesus natane nasafali sara nae, ");
INSERT INTO txq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Manetualain helu-bartaa numa lele uluk mai ena nae nadenu Karistus mai fo tao nasoi-nasoda Ndia hatahorin nara. Tungga ei duduꞌam, Karistus naa, see tititi-nonosin?” Boe ma ara raselu rae, “Ndia naa, mane Dauk tititi-nonosin.” ");
INSERT INTO txq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus kokolak seluk nae, “Mete ma talo naa, na, hata de Manetualain Dula-dale Malalaon nafada mane Dauk fo noke Karistus naa, ‘Lamatuak’? Sama leo Dauk surak ena nae, ");
INSERT INTO txq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Manetualain nafada au lamatuang ena nae, “Mai fo manggatuuk muu Au boboa konang nai mamana hada-horomatak mateꞌen ia. Neu ko Au tao ala o musum mara, losa ara doꞌor mbali O.’ ” ");
INSERT INTO txq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Numa susurak naa mai, ita bisa bubuluk tae, mane Dauk mesa kana noke Karistus naa, ‘Lamatuak’. Dadi mete ma hatahori rae Karistus naa, kada mane Dauk tititi-nonosin, naa bei ta dai! Ndia oo dadi neu mane Dauk Lamatuan boe!” ");
INSERT INTO txq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ara ramanene rala Yesus kokolan talo naa, boe ma hatahori Farisir raa kada ramanggonggoak kana, ma ta hambu hatahori esa bisa naselu Yesus boe na. Huu naa de mulai numa faik naa mai oo, ara ramataꞌu ratatane boe, ma ta rambarani rae ike sudik Yesus bali. ");
INSERT INTO txq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Basa boe ma Yesus nanori ana nunin nara sama-sama roo hatahori noꞌuk kara fo mana tungga sara. ");
INSERT INTO txq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ana nafada nae, “Meser anggamar ma hatahori Farisir raa toꞌu haak fo fee nenorik laꞌe-neu baꞌi Musa hohoro-lalanen nara. ");
INSERT INTO txq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Huu naa de ei muste nenene sara ma tungga nenorin nara. Tehuu boso tungga hata fo ara taok, nahuu ara ta tao tungga sira nenori heli-helin. ");
INSERT INTO txq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ara rakasetik hatahorir fo lemba-rasaa sira anggaman hohoro-lalane kamaberan nara. Tehuu sira mesa kasa ta nau tulu-fali hatahorir fo tao tungga hohoro-lalanek naa. ");
INSERT INTO txq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Basa hata fo ara taok, ara taon mita fo hatahori koa sara. Haꞌi netuduk leo: hambu buas esa isin Manetualain Dedeꞌa-kokolan fo ara paꞌan neu langgan nara ma liman nara. Tehuu ara tao ramoꞌo sira enan, mita fo hatahori soꞌuk kasa rae, ‘Wee! Sira iar, hatahori malalaok!’ ");
INSERT INTO txq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mete ma ara maso reni uma huhule-haradoik reu, do tungga feta, ara soa sangga mamana nenggetuuk neulaun lenak, fo hatahori noꞌuk mete-rita sara. ");
INSERT INTO txq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mete ma reni pasar reu, ara oo hihii kada hatahori fee sara hada-horomatak boe. Ara sangga fo hatahori doꞌor neu sara rae, ‘Soda-molek, papa meser mana hambu hada-horomatak.’ ");
INSERT INTO txq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tehuu ei boso tungga sira hihiru-heheon naa! Hatahori ta bole roke ei rae, ‘papa meser’, nahuu ei Mesem kada esak ka. Ma ei basa ngga ia, toranook kara. ");
INSERT INTO txq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Boso makadedemak hatahori nai dae-bafok ia mae, ‘papa’, nahuu ei Amam nai nusa tetuk do inggu temak kada esak ka. ");
INSERT INTO txq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Hatahorir oo ta bole roke ei rae, ‘lamatuak’ boe, nahuu ei Lamatuam kada esak ka, ndia Au ia fo Manetualain helu-bartaa nadenun numa lele uluk mai ena. ");
INSERT INTO txq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Huu naa de Au afada fo ei ta bole soꞌuk aom mara, sama leo hatahori mana hii kada hambu hada-horomatak kara raa. See numa ei mai nau dadi miu hatahori moꞌo-inahuuk, ana muste dadi sama leo ata-dato fo naono-lalau hatahori laen. ");
INSERT INTO txq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Hatahori mana nakadedemak aon nara, neu ko Manetualain nakaloloek kana. Tehuu hatahori mana tao aon sama leo hatahori kadiꞌik, neu ko Manetualain nakadedemak kana.” ");
INSERT INTO txq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Basa naa, Yesus tuti kokolan nae, “Weeh, ei meser anggamar ma hatahori Farisir ein! Numa ei hihiru-heheom huun mai, eir ia, hatahori mana dea-matak kara! Neu ko ei hambu sosoek, nahuu ei ta nau mamahere neu Au, ndia Hatahori fo Manetualain helu-bartaa ena nae nadenun mai ia. Ma manggaraun lenak bali, ei mamanggee mala hatahorir mana nau mai maso nai Manetualain parenda-koasan dale fo ara boso ramahere neu Au. ");
INSERT INTO txq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Weeh, ei meser anggamar ma hatahori Farisir ein! Numa ei hihiru-heheom huun mai, eir ia, hatahori mana dea-matak kara! Neu ko ei hambu sosoek, nahuu ei kada pepeko-leleko ina falur, basa de ei fonda mala uman nara. Tehuu nai hatahori noꞌuk kara matan, ei mafuni ei manggaraum mara naa, ma mambariik hule-haradoi mala dook ka fo hatahorir rae, ei dalem mara lolo-laok. Tehuu neu ko Manetualain fee huku-dokik beran seli neu ei. ");
INSERT INTO txq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Weeh, ei meser anggamar ma hatahori Farisir ein! Numa ei hihiru-heheom huun mai, eir ia, hatahori mana dea-matak kara! Neu ko ei hambu sosoek, nahuu ei saꞌe ofak meni bee miu a mesan, ma konda-hene letek, nau sangga kada hatahori esak ka, fo maso neni ei anggamam neu. Tehuu mete ma ana maso ena, na, ei tao mala masodan manggaraun lenak bali, losa ana hambu huku-dokik nai aꞌi mbila ta kala matek, beran lena ei laꞌe dua. ");
INSERT INTO txq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Weeh! Ei dadi hatahori pokek nai dalem mara ena, tehuu hata de ei bei nau matudu dalak fee hatahori laen bali? Neu ko ei hambu sosoek, nahuu ei fee nenorik leli-belak kana mae, ‘Mete ma hatahori soꞌuk hehelu-bartaak pake sumba-sook ma seseik Uma Huhule-haradoi Ina-huuk, na, hatahori naa ta nakaesa no ndia hehelu-bartaan naa. Tehuu mete ma ana soꞌuk hehelu-bartaak pake sumba-sook ma seseik bua lilo mbilas manai Uma Huhule-haradoik naa, na, dei fo ana nakaesa no ndia hehelu-bartaan naa.’ ");
INSERT INTO txq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Eir ia, hatahori nggoak kamangganggak ta bubuluk hata esa boe na! Ei rarain mae, Manetualain duꞌa nae bua lilo mbilas nenenin lena heni Ndia Uma Huhule-haradoin, do? Taa! Uma naa ndia tao buas naa dadi malalaok! ");
INSERT INTO txq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ei oo fee nenorik leli-belak kana mae, ‘Mete ma hatahori soꞌuk hehelu-bartaak pake sumba-sook ma seseik mei tunu-hotuk manai Uma Huhule-haradoi Ina-huuk, na, hatahori naa ta nakaesa no ndia hehelu-bartaan naa. Tehuu mete ma ana soꞌuk hehelu-bartaak pake sumba-sook ma seseik tunu-hotuk manai mei lain, na, dei fo ana nakaesa no hehelu-bartaan naa.’ ");
INSERT INTO txq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Eir ia, memak poke tetebes sara ena. Neu ko mei tunu-hotuk naa nenenin lena heni tunu-hotuk manai mei naa lain. Mei naa ndia taon, de sira tunu-hotun nara dadi malalaok fee Manetualain. ");
INSERT INTO txq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Huu naa de mete ma hatahori sumba-soo ma seseik mei tunu-hotuk, na, malole lenak seseik mei naa, no basa hata manai mei naa lain boe. ");
INSERT INTO txq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mete ma hatahorir sumba-soo ma seseik Uma Huhule-haradoi Ina-huuk, na, malole lenak seseik Uma Huhule-haradoik sama-sama no Manetualain naden. Huu Ana ndia leo nai naa. ");
INSERT INTO txq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mete ma hatahori sumba-soo ma seseik nusa tetuk do inggu temak, na, naa sama leo ana seseik Manetualain kadera man-parendan sama-sama no naden, huu Ana ndia nanggatuuk toꞌu parenda nai naa. ");
INSERT INTO txq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Weeh, ei meser anggamar ma hatahori Farisir ein! Numa ei hihiru-heheom huun mai, eir ia, hatahori mana dea-matak kara! Neu ko ei hambu sosoek, nahuu ei malelam mara seli fo reke fee Manetualain babaꞌek esa numa salahunu mai. Ei soa reke makandoo basa-basan, losa ei bumbu-fanim mara ruma osi mai oo, ei reke no lutuk boe. Haꞌi netuduk leo, ei reke lutuk ei daradaim, adas makeek, ma jintan. Naa te ei lilii heni Manetualain hohoro-lalanen nara fo nenenin lenak mateꞌen! Ei ta leo-laꞌo no ndoos. Ei ta sue hatahori kasian nara. Ma ei ta leo-laꞌo makandoo tungga Manetualain hihii-nanaun. Malole lenak, ei tao tungga basa naar, dei fo miu reke ei bumbu-fanim mara fo ei nau fee Manetualain. ");
INSERT INTO txq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ei dalem mara makatemak kara ena, tehuu hata de ei bei nau matudu dalak fee hatahori laen bali? Ei tao hohoro-lalanek no lutu-lelon losa ei madenu hatahori laen nara tungga, tehuu Manetualain hohoro-lalanen fo nenenin lenak mateꞌen naa, ei mesa ngga ta tungga. Sama leo, ei parisa no lutuk ma seꞌe heni mumuu numa ei oe nininum mai. Tehuu banda moꞌok sama leo kamba, ei kodo katemak kana! ");
INSERT INTO txq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Weeh, ei meser anggamar ma hatahori Farisir ein! Numa ei hihiru-heheom huun mai, eir ia, hatahori mana dea-matak kara! Neu ko ei hambu sosoek, nahuu ei safe mala ei pingga-manggom mara losa ranggadilak, tehuu naa nai kada dean. Naa te dalen nara nggeon ndoos sofek no ei tatao-nonoꞌi manggaraum ndia leo naꞌo manu-meo ma bare-naꞌo. ");
INSERT INTO txq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Weeh! Hatahori Farisir pokek kara ein! Safe makahuluk ei pingga-manggom dalen nara dei! No dalak naa, dean nara oo, dadi laok boe! ");
INSERT INTO txq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Weeh, ei meser anggamar ma hatahori Farisir ein! Numa ei hihiru-heheom huun mai, eir ia, hatahori mana dea-matak kara! Neu ko ei hambu sosoek, nahuu eir ia nok bali rates neni dama mutik. Hatahorir mete-rita kada dean naa, lolen seli. Tehuu dalen naa, sofek no hatahori mates duin nara, ma basa mana kaboo mburuk. ");
INSERT INTO txq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ei oo sama boe! Ei soa tao aom mara nok bali hatahori lolo-laok. Hatahori mete-rita ei numa dea mai, sama leo hatahori dale ndoos. Naa te ei dalem mara sofek no dedeꞌa manggarauk ena. Ei kokolak laen, tao laen, ma lilii heni Manetualain parendan nara. ");
INSERT INTO txq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Weeh, ei meser anggamar ma hatahori Farisir ein! Numa ei hihiru-heheom huun mai, eir ia, hatahori mana dea-matak kara! Neu ko ei hambu sosoek! Ei tao rates moꞌok kara soa-neu Manetualain mana toꞌu dedeꞌan nara, ma heti mala hatahori dale maloler raten nara neulau ndoos. ");
INSERT INTO txq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tehuu ei mae, ‘Mete ma ita leo tanak esa to ita bei-baꞌin nara, neu ko ita ta tungga a mesan takanisa Manetualain mana toꞌu dedeꞌan nara.’ ");
INSERT INTO txq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","No dalak naa, ei mesa ngga ndia matudu mae, ei oo manggarauk sama leo ei bei-baꞌim mara boe. ");
INSERT INTO txq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dadi malole lenak, ei tao manggarauk talo naa losa basan, tungga ei bei-baꞌim sala-singgon nara! ");
INSERT INTO txq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Eir ia, tebe-tebe manggarauk nok bali mengge karasok. Ei duꞌa mae, Manetualain ta fee huku-dokik neu ei! Boso mamahena! Neu ko Ana piru ei meni aꞌi mbila ta kala matek miu! ");
INSERT INTO txq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nenene, ee! Neu ko Au nadenu fee ei Au nedenung nggara, fo ara fee nenorik ma ratudu ei Manetualain eno-dala ndoon. Tehuu neu ko ei hala misa ketuk, ma paku makanisa ketuk nai ai ngganggek. Hambu ketuk oo, ei poko-femba sara rai uma huhule-haradoik kara dale boe, ma ketuk ei tuni-ndeni sara losa ralai ruma kota esa reni kota laen reu. ");
INSERT INTO txq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lele uluk ei bei-baꞌim hala nisa Habel. Naa te ndia ia, hatahori dale ndoos. Ei bei-baꞌim mara soa rakanisa hatahori ndoos sara, numa dombe esa neni dombe laen neu. Neu losa Sakaria, fo Barakia anan. Ara rakanisan numa Uma Huhule-haradoi Ina-huuk bebelan, deka no mei tunu-hotuk. Ei muste lemba-masaa mala hatahori dale ndoos sara raa, daan lalaꞌen, nahuu ei tungga bei-baꞌim mara manggaraun. ");
INSERT INTO txq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Memak tebe! Ei marai hatematak ia, neu ko hambu huku-dokik, nahuu basa dedeꞌa manggarauk kara iar fo ei bei-baꞌim mara taok ena, ndia fai uluk naa.” ");
INSERT INTO txq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Heeh, hatahori Yerusalem mara ein! Ei ndia soa makanisa Manetualain mana toꞌu dedeꞌan nara, ma toko makamate nedenuk fo nae mai tulu-fali ei. Au kokoe ei laꞌi-laꞌik kana fo meni Au mai, nok bali manu ina nau nakarombo nala anan nara nai ndia lidan. Tehuu ei ta nau. ");
INSERT INTO txq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Huu naa de Manetualain ta nau tao matak no ei umam bali. Neu ko mbila-beinesak, te rouk ena. ");
INSERT INTO txq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nenene matalolole, ee! Neu ko ei ta mete-mita Au bali losa fain ei manaku mae, ‘Ita toke fo Manetualain fee babaꞌe-babatik neu Hatahori ia, nahuu Manetualain ndia nadenun mai.’ Ei manaku talo naa, dei fo ei mete-mita Au bali.” ");
INSERT INTO txq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Basa naa, Yesus kalua laꞌo ela Uma Huhule-haradoi Ina-huuk naa. Neu Ana kalua, ana nunin nara mai ratudu Uma huhule-haradoik naa lolen. ");
INSERT INTO txq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tehuu Ana naselu nae, “Uma ia, memak malole! Tehuu nenene, ee! Ta dook ka bali te ara randefa heni basa batur ia lalaꞌen.” ");
INSERT INTO txq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesus laꞌo neu nanggatuuk numa letek Setun. Boe ma ana nunin nara mai fo ara kokolak rasare matak roon rae, “Papa! Hena Papa mafada seluk Papa kokolan bebeik kara ia dei. Ndondoon naa Papa fai mamain dadi nai faik bee, ee? Ma tandan nara ndondoon naa leo beek? Talo bee bali no dae-bafok fai mateꞌen?” ");
INSERT INTO txq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Boe ma Yesus naselu nae, “Manea aom mara matalolole, ee! Fo ei boso hambu kedi-irak. ");
INSERT INTO txq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Neu ko hambu hatahori mata-matak kara mai fo femba tenden nara rae, ‘Au ia, Karistus, Hatahori fo Manetualain helu-bartaa ena numa lele uluk mai.’ No dalak naa, ara kedi-ira rala hatahori noꞌuk ka. ");
INSERT INTO txq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mete ma ei mete-mita hatahorir ratati, do ei mamanene harak nae, hambu netatik nai bee a mesan, na, ei hae mamataꞌu. Dedeꞌak leo naak naa muste dadi. Tehuu dae-bafok fai mateꞌen bei ta losa. ");
INSERT INTO txq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Neu ko leo esa natati laban leo laen. Nusak esa natati laban nusak laen. Hambu dae nanggenggo nai bee a mesan. Ma fai ndoe-laꞌas oo, ta hohoꞌak sudi selik kana boe! ");
INSERT INTO txq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tehuu basa naar, bei fo tanda kaesan fo nafada nae, dae-bafok fai mateꞌen deka-deka mai ena. Naa, sama leo inak bei fo mulai nameda hedis, nahuu faik nae bonggi deka-deka mai ena. ");
INSERT INTO txq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Dadi ei muste manea aom mara matalolole, ee! Neu ko ara tuni-ndeni ma tao risa ei. Ma neu ko basa hatahori nusak kara mburuk ralan seli ro ei, nahuu ei tungga Au. ");
INSERT INTO txq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Faik naa, hatahori noꞌuk ka rasadea ma ta nau ramahere neu Au bali. Sira, esa mburuk mbali esa, ma esa seꞌo esa. ");
INSERT INTO txq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Neu ko hambu mana kedi-irak kara rae, sira raa, Manetualain mana toꞌu dedeꞌan. Ma hatahori noꞌuk ka ramahere neu sara. ");
INSERT INTO txq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Neu ko hatahori manggaraun nara doo-doo boe ma ramanoꞌu, losa hatahorir ta rasue-laik esa no esa bali ena. ");
INSERT INTO txq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tehuu hatahori mana makatataka nakandoo losa mate, neu ko Manetualain tao masoi-masodak neun. ");
INSERT INTO txq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hatahorir muste tao ratanggela Manetualain Hara Lii Malolen, losa dae-bafok buꞌun nara, mita fo basa hatahorir bisa bubuluk Manetualain eno-dala ndoon. Basa naa, dei fo dae-bafok fai mateꞌen mai.” ");
INSERT INTO txq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesus kokolak nakandoo nae, “Manetualain mana toꞌu dedeꞌan Daniel surak laꞌe-neu hatahori esa fo manggaraun sudi selik kana ena. Neu ko ana maso nambariik neu mamana nelulik nai Manetualain Uma Huhule-haradoi Ina-huun. No dalak naa, ana tao nunute mamanak naa. Huu naa de Manetualain nasadea laꞌo ela mamanak naa. Mete ma ei mete-mita talo naa ena, na, besa-besa, ee! (See ndia lees susurak ia, muste nalela no malole!) ");
INSERT INTO txq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Naa dadi tanda nae, fai susa-sonak kara nai lelesu bafan ena. Hatahorir marai profensi Yudea malai meni letek miu leo, mete ma mete-mita talo naa ena. ");
INSERT INTO txq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mete ma hambu ketuk kalua numa uma mai ena, na, boso fali miu haꞌi bua-baꞌum bali. Malaik lai-lai leo, mita fo boso hambu sosoek. ");
INSERT INTO txq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Hatahori manai osi dale, boso fali miu haꞌi lafa nelusek bali. Malai makandoo leo! ");
INSERT INTO txq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mana kasian lenak ndia ina kairuk, ma inak kara mana rasususu ana mbimbila anan. Ara ta bisa ralai nggafak, na. ");
INSERT INTO txq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dadi malole lenak ei hule-haradoi fo moke sosoek naa, boso tuda laꞌe-ndaa fai udan, do laꞌe-ndaa fai hahae tao ue-osa. ");
INSERT INTO txq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Faik naa, susa laꞌe esak kana! Mulai numa Manetualain nakadadadik dae-bafok losa hatematak ia, hatahorir bei ta mete-rita susa-sonak moꞌok matak leo naak. Ma neu ko hatahorir ta mete-rita seluk susa-sonak matak leo naak bali. ");
INSERT INTO txq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tehuu ei maua malan seli, nahuu Manetualain tao kekeꞌu faik naa. Mete ma taa, na, ta hambu hatahori esa boe na bisa nakatataka nasoda. Manetualain tao kekeꞌu fai susa-sonak kara raa, nahuu Ana sue-lai Ndia hatahorin fo Ana here nalak ena. ");
INSERT INTO txq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mete ma faik naa losa ena, neu ko ei mamanene hatahorir rae, ‘Mete dei! Karistus nai ia!’ Ma hatahori laen nae, ‘Karistus nai naa!’ Tehuu ei boso mamahere, ee! ");
INSERT INTO txq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Neu ko hambu hatahori kalua mai fo fefemba tenden nae, ‘Au ia, Karistus!’ Ma laen bali nae, ‘Au ia, Manetualain mana toꞌu dedeꞌan.’ Mete te ara tao tanda heran mata-matak kara renik koasa makiuk fo pepeko-leleko hatahori. Ara oo soba-soba fo Manetualain hatahorin nara hambu kedi-irak boe! ");
INSERT INTO txq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","De ei muste manea aom mara matalolole, ee! Fai susa-sonak kara raa bei ta losa, tehuu Au fee nesenedak memak neu ei, ee! ");
INSERT INTO txq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mete ma hatahorir rafada ei rae, ‘Karistus nai dae mook naa ena!’ na, ei boso naa miu. Ma mete ma hambu ketuk rae, ‘Karistus nai uma ia ena!’, na, ei boso mamahere sira pepeko-lelekon naa. ");
INSERT INTO txq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Au ia, Hatahori Dae-bafo Isi-isik. Mete ma Au fali uni dae-bafok ia mai, neu ko basa hatahorir mete-rita Au, sama leo hatahorir mete-rita ndelas nanggahadok numa mamana ledo toda neni mamana ledo tesa neu. ");
INSERT INTO txq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mete ma Au fali mai, neu ko ei bubuluk Au nai bee. Sama leo hatahorir bubuluk rae, mete ma hambu mbui mana naꞌa nenetuk kara rakabua nai mamanak esa, na, neu ko nai naa hambu nenetuk.” ");
INSERT INTO txq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Boe ma Yesus tuti seluk bali, fo nafada ana nunin nara nae, “Mete ma fai susa-sonak kara raa basan ena, ‘Neu ko ledo dadi makiuk, bulan oo ta nasaꞌa bali ena boe. Nduuk kara bese tuda ruma lalai mai, ma basa koasa marai lalai rapiru-padok.’ ");
INSERT INTO txq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Boe ma basa hatahorir mete-rita tanda nai lalai rae, Hatahori Dae-bafo Isi-isik nae fali mai. Mete-rita talo naa boe ma, basa hatahori nusak kara rai dae-bafok ia ramataꞌu losa ara buꞌi rakarereu. Neu ko Au konda mai pake sosoꞌak, dei fo ara mete-rita Au koasang ma Au manula-manapung lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Boe ma Au pake toꞌik lii moꞌok fo parenda Manetualain atan nara marai nusa tetuk do inggu temak reu rakabubua basa hatahorir fo Au here alak kara ruma dae-bafok buꞌun haa sara mai, numa ledo toda mai losa ledo tesa; numa kii mai losa kona.” ");
INSERT INTO txq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Au haꞌi netuduk leo ai huuk. Mete ma doon mulai uni, naa tanda nae, fai hanas deka-deka mai ena. ");
INSERT INTO txq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Leo naak oo, mete ma ei mete-mita fai susa-sonak kara raa ena, sama leo Au afada bebeik kara ia ena, naa tanda nae, Au deka-deka mai ena boe. ");
INSERT INTO txq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Hatematak ia, nenene matalolole! Numa basa hatahorir fo masodak hatematak ia, neu ko hambu ketuk bei ta mate, tehuu fai susa-sonak kara raa mai ena. ");
INSERT INTO txq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Leo mae lalai no dae-inak sambu do lalo ena, tehuu Au Dedeꞌa-kokolang ia mahanik seku neu.” ");
INSERT INTO txq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ta hambu hatahori fo bubuluk faik bee Au fali mai. Manetualain atan nara marai nusa tetuk do inggu temak oo, ta bubuluk boe. Au mesa ngga oo ta bubuluk boe. Kada Au Amang mesa kana ndia bubuluk. ");
INSERT INTO txq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Au ia, Hatahori Dae-bafo Isi-isik, neu faik fo Au fali mai, neu ko naa sama leo lele uluk fo Noh bei masodak. ");
INSERT INTO txq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Faa moꞌok naa bei ta mai, te hatahorir raꞌa-rinu malada-malada, esa sao esa rame-rame sama leo biasa. Ara tao talo naa rakandoo, losa Noh maso neni ofa moꞌok dale neu. ");
INSERT INTO txq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tehuu neu faa mai, de lala neni basa sara, dei de matan nara mete-rita fo ara bubuluk hata mandadik ena naa. Leo naak oo no Au fai mamaing boe. ");
INSERT INTO txq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Faik naa, mete ma hatahori dua raue-osa nai osi dale, medak neu te Manetualain soꞌuk neni esa, ma Ana laꞌo ela esa. ");
INSERT INTO txq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mete ma inak dua mbau hade, medak neu te Manetualain soꞌuk neni esa, ma Ana laꞌo ela esa. ");
INSERT INTO txq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Huu naa de, ei oo muste manea hatu-leledon boe, te ei ta bubuluk faik bee ei Lamatuam fali mai. ");
INSERT INTO txq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Duduꞌa matalolole, ee! Mete ma tenu uma bubuluk leꞌodae naꞌo manu-meo nae mai, neu ko ana nanea nakandoo ena, mita fo naꞌo manu-meo boso maso neni uman dale neu. ");
INSERT INTO txq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Huu naa de, ei oo muste mahani a boe. Te Au fai mamaing naa no kada nggengger neuk ka!” ");
INSERT INTO txq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Boe ma Yesus kokolak tamba nae, “Ei muste sama leo hatahori neondak mana tungga nakandoo ndia malanggan hihii-nanaun. Mete ma malanggan nae laꞌok neni mamana dook neu, ana soꞌuk hatahori neondak leo naak, fo nakaneni ndia uma isin nanaꞌa-nininun nara. ");
INSERT INTO txq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mete ma malanggan fali ma mete-nita ndia hatahori neondan naue-osa neulauk, neu ko dalen namahoko no hatahori naa. ");
INSERT INTO txq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Dadi mamahere neu Au leo, te neu ko malanggan naa fee hatahori neondak naa koasa fo toꞌu lima ndia hata-heton lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tehuu mete ma hatahori neondak naa manggarauk, neu ko ana kokolak nai dalen nae, ");
INSERT INTO txq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Malole ena! Malanggan laꞌo talo ia, see bubuluk faik bee fo ana fali mai ngga!’ Duꞌa talo naa, boe ma ana mulai poko-femba ndia nonoon hatahori mana maue-osa laen nara. Ma ana nanggatuuk naꞌa-ninu malada-malada sama-sama no mana mafuk kara. ");
INSERT INTO txq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tehuu neu ana ta meda nala sana, nggengger neuk ka, ndia malanggan fali. ");
INSERT INTO txq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Boe ma malanggan naa tuni-ndeni nalan beran seli, basa de pirun dea neu, fo ana leo sama-sama no hatahori mana dea-matak kara. Nai mamanak naa, basa sara buꞌi rakarereu, nahuu ara doidoso ralan seli.” ");
INSERT INTO txq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Boe ma Yesus tuti kokolan laꞌe-neu Manetualain parenda-koasan nae, “Ei muste mahani a fo soru Au fafaling, sama leo lololek ia. Talo ia: laꞌe esa, hambu ana feꞌok salahunu kalua leꞌodaek ma reni sira lambu tiꞌoen nara fo reu soru baroit touk nai sira nonoon uman. ");
INSERT INTO txq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tehuu numa ana feꞌok kasalahunuk kara raa mai, hambu lima nggoa bebek kara, ma lima malelak kara. ");
INSERT INTO txq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nggoa bebe kalimak kara raa lilii reni mina lenak. ");
INSERT INTO txq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tehuu malela kalimak kara reni lenak memak ena. ");
INSERT INTO txq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Losa uma naa, te baroit touk naa oo bei ta mai boe. Doo-doo boe ma ana feꞌok kara raa tekaur, de ara sunggu seli. ");
INSERT INTO txq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Naa te neu fatilada, boe ma ara ramanene hatahorir eki rae, ‘Wee! Baroit mai ena! Mai fo ita teu sorun leo!’ ");
INSERT INTO txq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ara ramanene rala naa, boe ma ana feꞌok kara raa rambadeik rame-rame. De reu raole sira lambu tiꞌoen nara. ");
INSERT INTO txq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tehuu ana feꞌo nggoa bebek kara raa kokolak ro sira nonoon nara rae, ‘Wee, tia-lair, ee! Tulun baꞌe fee ai mina faa dei, huu ai lambun nara sangga mate ia ena!’ ");
INSERT INTO txq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tehuu ana feꞌo malelak kara raa raselu rae, ‘Awee! Boso mamanasa, te ta bisa, ou. Ai minan ia, ta dai soa-neu ita basa ngga! Malole lenak ei miu hasa nai kios leo.’ ");
INSERT INTO txq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Boe ma ara laꞌo reu hasa mina. Tehuu neu ara kalua, baroit naa losa ena. De ana feꞌo malelak kara raa maso tungga reni mamana feta reu sama-sama ro baroit ma basa fuik kara. Basa sara maso rala uma dale, boe ma hatahorir kena lelesu. ");
INSERT INTO txq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Basa de ana feꞌo nggoa bebek kara raa oo mai boe. Ara eki roke talu-talu rae, ‘Lamatuak! Lamatuak, ee! Tulun soi lelesu dei!’ ");
INSERT INTO txq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tehuu ana naselu nae, ‘Heeh, ta bisa! Au ta alela ei!’ ");
INSERT INTO txq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Huu naa de ei oo muste mahani a ma manea makandoo boe, te ei oo ta bubuluk Au mamaing laꞌe-ndaa faik bee, do liꞌu bee boe.” ");
INSERT INTO txq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Basa de Yesus tuti seluk lololek esa bali nae, “Mete ma Au laꞌo ela ei ena, na, ei muste maue-osa matalolole soa-neu Au, sama leo lololek ia. Talo ia: hambu malanggak esa nae neni mamana dook neu. Neu faik ana naole nae laꞌo ena, nanggou ndia hatahori neondan nara, boe ma ana parenda sara nae, ‘Ei pake doik ia dadi neu poko. Mete ma au fali mai ngga, neu ko ei muste tui au, ei hambu bunak baꞌu hata.’ ");
INSERT INTO txq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Boe ma ana fee hatahori neondak kaesan, doi lilo mbilas saku lima, fo ana nakabubunak kasa. Basa de ana fee hatahori neondak kaduan doik saku dua, ma hatahori neondak katelun doik saku esa, tungga esa-esak bebeꞌin. Basa boe ma ana laꞌo neni dook neu. ");
INSERT INTO txq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hatahori neondak kaesan simbo nala doik kara raa, boe ma ana kalua memak fo neu danggan. Ta dook ka te ana hambu nala bunak doik saku lima ena bali. ");
INSERT INTO txq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Leo naak oo, no hatahori neondak kaduan, ana hambu nala bunak doik saku dua bali boe. ");
INSERT INTO txq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tehuu hatahori neondak katelun fo mana simbo doik saku esa naa, neu kali bolok nai dae, de nafuni ndia malanggan doin naa. ");
INSERT INTO txq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Dook ka boe ma, dei de malanggan naa mai. De ana nakabubua nala ndia hatahori neondan nara fo mulai parisa ndia doin fo ara koladuk naa ena. ");
INSERT INTO txq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hatahori neondak kaesan naa maso, de loo lima doik saku salahunu, ma nae, ‘Papa! Papa doin ndia ia. Fai maneuk kara papa fee au doik saku lima ena. Tehuu hatematak ia, au hambu bunak saku lima bali.’ ");
INSERT INTO txq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Malanggan namanene nala naa, boe ma ana namahoko. Ana kokolak nae, ‘Malole! O ia, hatahori neonda neulauk. O maue-osa no manggatek ena, ma tungga makandoo au parendang ena, mae au ta ngga nai ia. Neu ko au soꞌuk o fo koladu dedeꞌak moꞌon lenak bali, nahuu o bisa koladu mala dedeꞌa kadiꞌik leo iak. Neu ko au tao feta fo ita basa ngga tamahoko rame-rame.’ ");
INSERT INTO txq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Basa de hatahori neondak kaduan naa, mai loo lima neu ndia malanggan doin saku haa, ma nae, ‘Papa! Fai bakahulun, papa loo lima au doik saku dua. Mete dei, au hambu bunak doik saku dua bali.’ ");
INSERT INTO txq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Boe ma malanggan naa namahoko. Ana kokolak nae, ‘Malole! O ia oo, hatahori neonda neulauk boe. O maue-osa no manggatek ena, ma o tungga makandoo au parendang ena, mae au ta ngga nai ia. Neu ko au soꞌuk o fo koladu dedeꞌak moꞌon lenak bali, nahuu o bisa koladu mala dedeꞌa kadiꞌik leo iak. Neu ko au tao feta fo ita basa ngga tamahoko rame-rame.’ ");
INSERT INTO txq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Basa de hatahori neondak katelun mai. Boe ma ana nafada nae, ‘Papa! Au bubuluk papa ia hatahori dale batuk. Papa haꞌi nala hata fo hatahori laen taok, ma ketu-koru nala hata fo hatahori laen sele-tandek. ");
INSERT INTO txq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Au amataꞌu, boso losak doi kara iar mopo sara, boe ma papa hukun au. Huu naa de au afuni atalololen. Ndia ia, papa! Simbo mala falik kana leo, huu papa doin saku esa ia, bei tema-tema!’ ");
INSERT INTO txq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Malanggan naa namanene nala naa, boe ma ana mbokan nae, ‘O ia, hatahori neonda manggarauk ma mbera-barek mateꞌen! Mete ma o bubuluk ena mae, au haꞌi hata fo hatahori laen taok, ma ketu-koru ala hata fo hatahori laen sele-tanden, ");
INSERT INTO txq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","tao hata de o ta muu mbeda au doing nai kada bank? Mita fo au fali, na, au bisa hambu bunan, mae baꞌu anak ka oo malole boe!’ ");
INSERT INTO txq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","De malanggan naa nadenu ndia hatahori neondan laen nae, ‘Haꞌi mala doik naa numa ndia mai, fo loo liman neu hatahori neondak mana hambu bunak doik saku lima naa. ");
INSERT INTO txq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Hatahori fo mana koladu nalole hata fo ana toꞌun ena, neu ko ana hambu tamba noꞌuk ka bali. Tehuu hatahori fo ta mana koladu hata fo ana toꞌuk naa ena, neu ko ara haꞌi rala basa-basan numa ndia mai. ");
INSERT INTO txq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Humu mala hatahori neondak fo nanalan taak ia. Leꞌa roroson fo nggari henin neni dea naa neu. Elan numa naa fo ana buꞌi nakarereu ma doidoso neu mamana makiuk naa!’ ” ");
INSERT INTO txq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Basa boe ma Yesus kokolak nakandoo nae, “Au, Hatahori Dae-bafo Isi-isik ia, neu ko konda fali pake Au Amang koasan ta neni babanggak, sama-sama ua Ndia atan nara ruma nusa tetuk do inggu temak mai. Boe ma Au anggatuuk uu Au kadera man-parenda ta neni babanggang, fo parisa basa hatahorir leleo-lalaꞌon. ");
INSERT INTO txq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Neu ko basa hatahorir fo mana leo nita nai dae-bafok ia, mai rasare Au. Boe ma Au bingga sara, sama leo mana lolo bingga heni bibi lombo numa bibi hiek mai, fo dadi reu bubuak dua. ");
INSERT INTO txq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hatahorir mana leo-laꞌo tungga Manetualain hihii-nanaun, Au tao sara reu Au boboa konang. Tehuu laen nara tao sara reu Au boboa kiing. ");
INSERT INTO txq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Lelek naa, Au toꞌu parenda sama leo Manek. Neu ko Au afada hatahorir marai Au boboa konang ae, ‘Eir ia, ndia simbo babaꞌe-babatik numa Au Amang mai. Mai fo maso meni Ndia uman fo Ana sadia memak kana ena, numa makasososan mai soa-neu ei. ");
INSERT INTO txq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Au oke ei, nahuu fai bakahulun neu Au ndoe, ei fee Au uꞌa. Neu Au dale mada, ei fee Au inu. Au mai, sama leo hatahori deak, tehuu ei simbok mala Au nai ei umam. ");
INSERT INTO txq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Au bua-loꞌa taak, tehuu ei fee Au bua-loꞌa. Au amahedi, tehuu ei mai malalau Au. Au nai bui dale, tehuu ei mai tiro-dangga Au.’ ");
INSERT INTO txq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Hatahori dale ndoos marai Au boboa konang naa ramanene talo naa, neu ko ara raselu rasafali rae, ‘Lamatuak, talo bee ia? Lamatuak nae, Lamatuak ndoe, boe ma ai fee O muꞌa. Lamatuak dale mada, boe ma ai fee O minu. ");
INSERT INTO txq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lamatuak sama leo hatahori deak, boe ma ai simbok maso nai ai uman. Lamatuak bua-loꞌa taak, boe ma ai fee. ");
INSERT INTO txq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lamatuak namahedi, boe ma ai miu malalau. Lamatuak nai bui, boe ma ai miu tulu-fali. Tehuu neu faik bee ai tao basa matak kara leo naak?’ ");
INSERT INTO txq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Neu ko Au aselu sara ae, ‘Mamahere neu Au! Huu neu ei tao basa matak kara raa soa-neu Au hatahoring nggara, mae tao soa-neu hatahori ta kambareek kara oo, na, ei tao naa soa-neu Au ena boe!’ ");
INSERT INTO txq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Boe ma Au afada hatahorir marai Au boboa kiing raa ae, ‘Weeh, hatahori manggarauk kara ein! Manetualain nakatoo ei ena. Malai heok numa ia mai! Neu ko Au adenu hatahorir piru ei meni aꞌi mbila ta kala matek miu. Huu Manetualain sadia memak mamana doidosok naa ena, fee nitur ma sira malangga moꞌon. ");
INSERT INTO txq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Au husi heni ei, nahuu neu Au ndoe, ei ta fee Au uꞌa. Neu Au dale mada, ei ta fee Au inu. ");
INSERT INTO txq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Au mai sama leo hatahori deak, tehuu ei ta simbo Au nai ei umam. Au bua-loꞌa taak, tehuu ei ta fee Au bua-loꞌa. Au amahedi, tehuu ei ta mai malalau Au. Au nai bui, tehuu ei ta mai tulu-fali Au.’ ");
INSERT INTO txq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hatahori manggarauk kara raa ramanene rala naa, neu ko ara raselu rae, ‘Lamatuak, talo bee ia ena? Lamatuak nae, Lamatuak ndoe, tehuu ai ta fee O muꞌa. Lamatuak dale mada, tehuu ai ta fee O minu. Lamatuak sama leo hatahori deak, tehuu ai ta simbok maso nai ai uman dale. Lamatuak bua-loꞌan taa, tehuu ai ta fee. Lamatuak namahedi, tehuu ai ta miu malalau. Lamatuak nai bui, tehuu ai ta miu tulu-fali. Tehuu neu faik bee ai tao Lamatuak talo naa?’ ");
INSERT INTO txq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Neu ko Au aselu sara ae, ‘Mamahere neu Au! Huu neu ei ta tulu-fali hatahori ta kambareek kara, na, naa sama leo ei ta tulu-fali Au.’ ");
INSERT INTO txq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Boe ma hatahori manggarauk kara raa, hambu doidosok rakandoo losa doon naa neu. Tehuu hatahori dale ndoos sara, hambu masoi-masodak rakandoo ro Manetualain losa doon naa neu.” ");
INSERT INTO txq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Neu Yesus fee nenorik basa dedeꞌak kara raa neu sara ena, boe ma Ana nafada Ndia ana nunin nara nae, ");
INSERT INTO txq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ei bubuluk ena, neu ko faik dua bali te ita fai malolen, ndia Feta Paska. Neu ko neu faik naa, hambu hatahori seꞌo heni Au, Hatahori Dae-bafo Isi-isik ia. Boe ma ara paku risa Au nai ai ngganggek lain.” ");
INSERT INTO txq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Faik naa, malangga anggama Yahudi malanggan nara ma lasi-lasi hadak kara rakabua numa Kayafas uman. Kayafas naa, ndia malangga anggama Yahudi malangga ina-huun. ");
INSERT INTO txq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ara sangga dalak fo rae humu Yesus no neneek, fo tao risan. ");
INSERT INTO txq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tehuu ara duduꞌa fo rala harak rae, “Makatataak dei! Ita boso humu Yesus lai-laik, nahuu fai maloler deka-deka ena. Boso losak hatahori noꞌuk kara mana hii Yesus, ara ramue.” ");
INSERT INTO txq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nai nggorok Betania, hambu hatahori esa, nade Simon. Fai bakahulun hatahorir nunuten, nahuu ana hambu hedi kusta. Tehuu hatematak ia ana hai ena. Faik naa, fai maloler bei ta losa, boe ma Yesus asa reu raꞌa numa Simon uman. ");
INSERT INTO txq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Neu ara raꞌa, boe ma inak esa mai natonggo no Yesus. Ana toꞌu boto esa, neni taok numa batu mabeli mai. Boto naa isin, mina kaboo menik fo belin seli. De inak naa femba tepa boto naa leusain. Boe ma ana mboꞌa nakafafaak koe-koe mina naa neu Yesus langgan, fo dadi tanda ana fee hada-horomatak neu Yesus. ");
INSERT INTO txq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tehuu neu Yesus ana nunin nara mete-rita inak naa tao talo naa, boe ma ramanasa, de ara rakokola aok rae, “Weeh! Tao hata de ana nggari heni hiek mina kaboo menik fo mabelin seli naa! ");
INSERT INTO txq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Malole lenak ana seꞌo mina naa! Mita fo doin, babaꞌen neu hatahori mana tofa-tarak kara!” ");
INSERT INTO txq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tehuu Yesus bubuluk sira duduꞌan naa, boe ma Ana kokolak nae, “Ei hae makasususak inak ia! Elan numa naa leo! Au amahoko, nahuu ana mboꞌa mina kaboo menik neu Au ao-mbaang ena. ");
INSERT INTO txq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hatahori mana tofa-tarak kara soa rai ei taladam mara. Tehuu ta dook ka bali, te Au ia, ta sama-sama ua ei ena. ");
INSERT INTO txq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma inak ia mboꞌa mina ia, ana sadia Au ao-mbaang ena, sama leo ana fee rambe memak Au ao-mbaang mamaten. Huu Au sodang ta dook ka ena bali. ");
INSERT INTO txq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Masaneda matalolole, ee! Nai bee a mesan, Manetualain Tutui Malolen natanggela nai dae-bafok ia, neu ko ara oo tui inak ia malolen boe, mita fo basa hatahorir rasanedan.” ");
INSERT INTO txq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hambu hatahori esa numa Yesus ana nuni kasalahunu duan nara mai, nade Yudas Iskariot. Faik naa oo, ana kalua neu sangga malangga anggama Yahudi malanggan nara boe fo nae loo lima Yesus neu sara. ");
INSERT INTO txq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Losa matan nara, boe ma ana natane nae, “Papa sara ein, ee! Mete ma au tulun humu Yesus naa, na, ei fee au hata?” Boe ma ara raselu rae, “Mete ma o nau seꞌon neu ai, na, ai bae.” Basa boe ma, ara reke rala doi lilo fulak telu hulu, de loo lima sara reu Yudas. ");
INSERT INTO txq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Basa naa, Yudas laꞌo dea neu, de ana mulai sangga dalak fo nae loo lima Yesus neu sara. ");
INSERT INTO txq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tungga teuk, hatahori Yahudir raena fai maloler doon faik hitu. Ara seseik fai maloler raa rae, ‘Feta Roti Ta Pake Laru Taꞌik’. Faik naa, feta sangga mulai ena, boe ma Yesus ana nunin nara mai ratanen rae, “Papa! Leꞌodaen ia, ita muste buka ita fai malolen nara. Dadi Papa nau fo ai miu hala bibi lombo, ma sadia mamana feta Paska nai bee?” ");
INSERT INTO txq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Boe ma Ana naselu nae, “Ei maso meni kota miu, neu ko ei matonggo mia touk esa. Mafadan mae talo ia, ‘Kaꞌa, ee! Papa Meser nameda nae ta dook ka te Ana mate ena. De Ana noke mamanak nai kaꞌa uman, fo Ana paken tao feta Paska sama-sama no ana nunin nara.’ ” ");
INSERT INTO txq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesus ana nunin nara ramanene rala naa, boe ma ara reu tao tungga Ndia kokolan naa. De ara sadia feta Paska neu naa. ");
INSERT INTO txq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Neu fai leꞌodae ena, boe ma Yesus no ana nuni kasalahunu duan nara ranggatuuk raꞌa feta. ");
INSERT INTO txq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Neu ara raꞌa, boe ma Ana kokolak nae, “Ei nenene, ee! Hambu esa numa ei mai, ndia neu ko seꞌo heni Au uni hatahori laen nara uu.” ");
INSERT INTO txq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ara ramanene rala naa, boe ma dalen nara rameda ta malole. De ara esa-esak ratane neu Yesus rae, “Hatahori fo Papa kokolak naa, ta ndia au, hetu?” ");
INSERT INTO txq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Boe ma Ana naselu nae, “Hatahori mana boro rotin nai manggo ia sama-sama no Au, ana ndia neu ko seꞌo heni Au. ");
INSERT INTO txq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Masaneda, ee! Au, Hatahori Dae-bafo Isi-isik ia, muste mate sama leo ara surak memak kana nai Manetualain Susura Malalaon. Tehuu besa-besa! Hatahori mana nae seꞌo heni Au naa, neu ko ana lemba-nasaa nala ndia sosoen! Malole lenak mete ma inan ta bonggi sana!” ");
INSERT INTO txq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Basa naa, Yudas oo tungga natane boe nae, “Neu ko hatahori fo Papa kokolak naa, ta ndia au, hetu?” Tehuu Yesus naselu nae, “Memak o mesa ngga ndia mae leo naa ena. Te see bali?” ");
INSERT INTO txq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Neu ara bei raꞌa, boe ma Yesus soꞌu botik roti balok esa, de noke makasi neu Manetualain. Boe ma Ana fifiꞌi baꞌe roti naa, de Ana loon neu ana nunin nara, ma nafada nae, “Roti ia, Au ao-mbaang. Ei haꞌi malan fo miꞌa leo!” ");
INSERT INTO txq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Basa naa, Ana haꞌi nala nggalas esa sofek no oe anggor, de noke makasi neu Manetualain. Basa boe ma, Ana oo loon neu ana nunin nara boe, ma nafada nae, “Ei basa ngga haꞌi malan fo minu. ");
INSERT INTO txq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Oe anggor ia, Au daang. Neu ko Au mate, Au daang titi henin fo tao nasoi-nasoda neu hatahori noꞌuk kara ruma sala-singgon nara mai. Daak ia, dadi bukti fo fee nesenedak nae, hata fo Manetualain helu-bartaan naa ena, memak hatematak ia ana dadi ena. De, haꞌi malan fo minu leo! ");
INSERT INTO txq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tehuu nenene matalolole! Numa leꞌodaen ia neu, Au ta inu oe anggor ena bali. Neu ko mete ma Au ua Au Amang manggatuuk toꞌu parenda nai nusa tetuk do inggu temak ena, dei fo Au inu bali ua ei.” ");
INSERT INTO txq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Basa boe ma ara soda sosodak esa fo koa-kio Manetualain. Leꞌodaen naa oo, ara kalua reni letek Setun reu boe. ");
INSERT INTO txq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Neu ara bei laꞌok naa, Yesus nafada memak ana nunin nara nae, “Neu ko leꞌodaen ia, ei basa ngga malai laꞌo ela Au. Sama leo ara surak memak kana nai Manetualain Susura Malalaon nae, ‘Neu ko Manetualain tao nisa mana lolo, de bibi lombon nara ralai sasarak.’ ");
INSERT INTO txq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Memak Au mate. Tehuu mete ma Au asoda fali numa mamates mai ena, neu ko Au ahani ei nai profensi Galilea naa.” ");
INSERT INTO txq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tehuu Petrus nasabara nae, “Papa! Leo mae basa hatahori laen nara ralai laꞌo ela Papa, tehuu Au ta alai!” ");
INSERT INTO txq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Boe ma Yesus naselu nae, “Talo naa Peꞌu, do? Mamahere Au! Leꞌodaen ia, manu bei ta kokoa, tehuu o laka laꞌe telu ena mae, o ta malela Au!” ");
INSERT INTO txq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tehuu Petrus natetea nae, “Taa, Papa! Mete ma Papa mate, au oo mate tungga sama-sama boe. Au ta alai laꞌo ela Papa!” Petrus nonoon laen nara oo, esa-esak nae leo naa boe. ");
INSERT INTO txq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Basa de, Yesus asa laꞌok rakandoo reni letek Setun reu, losa osi esa, nade Getsemani. Numa naa, Ana nafada ana nunin nara nae, “Ei manggatuu taak mai ia dei, huu Au ae uu hule-haradoi nai naa.” ");
INSERT INTO txq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tehuu Ana noke no Petrus, Yakobis, ma Yohanis, fo telu sara reu sama-sama roon. Mulai numa naa neu, Ndia dalen sona ma ta natetu faa boe na. ");
INSERT INTO txq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ara bei fo laꞌok doo-doo faa, te Ana nafada sara nae, “Au daleng susa nalan seli! Au ameda nok bali ae mate a ena. Ei manggatuuk beꞌe manea mia Au nai ia dei.” ");
INSERT INTO txq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Boe ma Ana hodok mata neu faa, de sendek luu-langgan fo hule-haradoi nae, “Papa! Mete ma Papa nau, na, Au hae lemba-asaa doidosok ia. Tehuu boso tungga Au hihii-nanaung; naa fo tungga kada Papa hihii-nanaun.” ");
INSERT INTO txq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ana hule-haradoi basa, boe ma fali neni Ndia ana nuni katelun nara neu. Tehuu ara sunggu seli. Ana fafae sara, boe ma Ana kokolak no Petrus nae, “Heeh, Peꞌu! Tao hata de ei sunggu? Au uu losak ka numa naa, tehuu ei ta bisa beꞌe manea faa boe na! ");
INSERT INTO txq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kukuku maneu ei matam mara dei, fo mambadeik manea mia Au! Ei dalem mara memak nau tao neulauk, tehuu ei ao-inam mara barakai taak. Dadi malole lenak ei hule-haradoi, fo mete ma hambu soba-douk, na, ei bisa makatataka mala.” ");
INSERT INTO txq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Basa de, Ana laꞌo neu hule-haradoi bali nae, “Papa! Mete ma Au muste lemba-asaa doidosok ia, na, naa fo tungga kada Papa hihii-nanaun leo.” ");
INSERT INTO txq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ana hule-haradoi basa, boe ma fali neni ana nuni katelun nara neu. Tehuu ara sunggu seluk ena bali, nahuu matan nara ramabera ralan seli. ");
INSERT INTO txq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Boe ma Ana laꞌo ela sara, fo neu hule-haradoi laꞌe esa bali. Ana noke seluk neu Amak fo boso laꞌo ela Ndia lemba-nasaa doidosok naa, tehuu naa fo tungga kada Amak hihii-nanaun leo. ");
INSERT INTO txq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ana hule-haradoi basa, boe ma fali neu fafae nambadedeik ana nunin nara nae, “Ei bei sunggu makandoo ia, do? Mambadeik leo! Hatahori fo mana nae seꞌo heni Au, Hatahori Dae-bafo Isi-isik ia, deka ena. Hatematak ia ara rae humu Au, fo loo liman neni hatahori manggarauk liman nara reu. ");
INSERT INTO txq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Heeh! Mambadeik leo! Buka ei matam mara fo mete sudi neni naa neu dei! Hatahori fo mana nae seꞌo heni Au naa, mai ena.” ");
INSERT INTO txq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Neu Yesus bei kola-kola talo naa, Yudas mai ena no hatahori noꞌun seli. Ara mai reni tafa mukuk ma tongga fo rae humu Yesus. Ara tao talo naa, tungga parenda numa malangga anggama Yahudi malanggan nara ma lasi-lasi hadak kara mai. ");
INSERT INTO txq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas fee tanda memak kasa nae, “Ei mete matalolole, ee! Hatahori bee fo au iduk naa, humu malan leo! Ndia naa, ndia hatahori naa fo ei sanggak!” ");
INSERT INTO txq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Neu ara losa Yesus, boe ma Yudas neni Yesus matan neu tutik kana, de nae, “Soda-molek, Papa Meser!” Boe ma Yudas holu nalan ma idun. ");
INSERT INTO txq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Boe ma Yesus natanen nae, “Heeh, Yudas! O mamaim ia, o mae tao hata, na, taon leo!” Boe ma hatahori noꞌuk kara raa mata reu, fo rae humu Yesus. ");
INSERT INTO txq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Medak neu te Yesus hatahorin esa lesu nala felan, de sambi naketu hatahori esa ndiꞌi doon. (Hatahori mana makahinak naa, ndia malangga anggama Yahudi malangga ina-huun hatahori neondan.) ");
INSERT INTO txq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesus mete-nita naa, boe ma nafadan nae, “Mbeda falik fela neni manan neu. Hatahori mana leo-laꞌo no tafa, neu ko ana mate oo, no tafa boe. ");
INSERT INTO txq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","O ta bubuluk, do? Au bisa oke Au Amang fo nadenu Ndia atan nara rifu-rifuk kara ruma nusa tetuk do inggu temak mai, fo tulu-fali Au. ");
INSERT INTO txq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tehuu haen leo. Ela sara ruma naa fo hatahori iar humu rala Au. Te basan neni surak memak kana nai Manetualain Susura Malalaon dale laꞌe-neu Au naa, muste dadi.” ");
INSERT INTO txq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Boe ma Yesus kokolak no hatahori noꞌuk kara mana mai humun naa nae, “Heeh! Ei duꞌa mae, Au ia, hatahori manggarauk, do? Tao hata de ei mai humu Au menik tafa mukuk ma tongga? Naa te tungga faik Au anori ei nai Manetualain Uma Huhule-haradoi Ina-huun dale, tehuu ta hambu hatahori esa boe na tao hata-hata mbali Au. ");
INSERT INTO txq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tehuu elan numa naa leo! Mai, humu mala Au leo! Basa iar neni surak memak kana numa lele uluk mai nai Manetualain Susura Malalaon dale ena.” Yesus ana nunin nara mete-rita talo naa, boe ma ara ramataꞌu ralan seli. De ara ralai laꞌo elan. ");
INSERT INTO txq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Basa boe ma hatahorir mana humu Yesus raa, roo Yesus neni malangga anggama Yahudi malangga ina-huun Kayafas uman neu, nahuu hatahori moꞌo-inahuuk kara rakabua rai naa ena. Sira ndia malangga anggama Yahudi malanggan nara, meser anggamar, ma lasi-lasi hadak kara. ");
INSERT INTO txq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Neu ara toꞌu roon neu naa, Petrus oo laꞌo bambi-bambi tungga dea, losa malangga ina-huuk naa uman boe. Petrus oo maso neni uma bebelan neu boe, fo nanggatuuk sama-sama no hatahorir marai naar. Huu ana nau bubuluk hata ndia neu ko ana dadi. ");
INSERT INTO txq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Numa uma naa dale, malangga anggama Yahudi malanggan nara rakokola aok roo basa hatahorir mana maketu-maladi dedeꞌa anggama. Basa sara sangga bukti fo nau sangga dala neketuk hukun mates neu Yesus. ");
INSERT INTO txq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tehuu leo mae ara fee sakasii pepekok noꞌun seli oo, ara ta hambu bukti hata esa boe na, fo ara bisa pake boe. Neu mateꞌen, ara hambu hatahori sakasii dua. ");
INSERT INTO txq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Sakasii kaduak kara raa rae, “Ai mamanene mita Hatahori ia kokolak nae, ‘Neu ko Au andefa heni Uma Huhule-haradoi Ina-huuk. Tehuu nai faik telu dalen oo, Au ambaririik falik kana boe.’ ” ");
INSERT INTO txq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Boe ma malangga anggama Yahudi malangga ina-huun naa nambariik neu basa hatahorir mana manggatuuk rai naa matan. De ana natane Yesus nae, “O mamanene hatahori noꞌuk ka rakasasaꞌek salak neu O ena. Tao hata de O kada tutundindiik?” ");
INSERT INTO txq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tehuu Yesus ta naselu hata esa boe na. Boe ma malangga ina-huuk naa natanen bali nae, “Au ae atane ia! Tehuu O muste maselu tebe-tebe sama leo O maselu mbali Manetualain mana masodak nai nusa tetuk do inggu temak. Hambu hatahori nae, O ia, Karistus, Manetualain Anan fo Ana helu-bartaan ena numa lele uluk mai naa. Tebe naa, do?” ");
INSERT INTO txq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Boe ma Yesus naselu nae, “Memak tebe, sama leo papa kokolan naa. Tehuu masaneda, ee! Neu ko ei basa ngga mete-mita Au, Hatahori Dae-bafo Isi-isik ia. Neu ko Au anggatuuk nai nusa tetuk do inggu temak nai Manetualain boboa konan fo toꞌu parenda sama-sama ua Ndia, mana maena koasa mateꞌen. Basa naa, neu ko Au kond fali mai pake sosoꞌak.” ");
INSERT INTO txq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Malangga ina-huuk naa namanene nala naa, boe ma ana namanasa nalan seli, losa ana sii nasida badu narun. Boe ma ana bolu nafada basa hatahorir mana manggatuuk ruma naa nae, “Wuuh! Ita ta parluu sakasii bali! Ei mamanene no ei ndiꞌi doo heli-helim ena, Ndia kokolan naa, hetu! Ana soꞌuk aon dadi neu Manetualain Anan. Ia, nakadadaek Manetualain ia ena! Ei basa ngga bubuluk ena mae, tungga ita anggama hohoro-lalanen, mete ma hambu hatahori tao aon sama leo Manetualain, na, hatahori naa muste maten! ");
INSERT INTO txq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Dadi hatematak ia, ei mae maketu hata?” Boe ma basa sara bolu rae, “Hatahori ia memak sala tetebes! Dadi muste hambu hukun mates!” ");
INSERT INTO txq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ma hambu hatahori hida mata reu pura ambe neu Yesus. Boe ma ara popoko rakamiminak kana ma famban. ");
INSERT INTO txq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Basa boe ma ara rakatitiik kana rae, “Heeh! O ia, Karistus, hetu? Hena O selu sudik kana! See ndia tutu O?” ");
INSERT INTO txq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Faik naa, Petrus bei nanggatuuk numa uma bebelan. Boe ma ata inak esa mai kokolak noon nae, “Bebeik kara ia, o tungga sama-sama mua Yesus, hatahori Nasaret naa boe, hetu?” ");
INSERT INTO txq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tehuu ana laka neu hatahori noꞌuk kara raa matan nae, “Taa! Tao hata de o matane talo naa! Au ta alela sana, ma.” ");
INSERT INTO txq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Basa boe ma Petrus laꞌo dea neu nambariik neu mbaꞌa lelesu matan. Boe ma hambu inak laen mete-nitan numa naa. De ana nafada hatahorir marai naa nae, “Wee, bebeik kara au mete-ita hatahori ia, sama-sama no Yesus, hatahori Nasaret naa.” ");
INSERT INTO txq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Boe ma Petrus nasabara nae, “Fama te, o kamuluk! Au ta alela Hatahori naa, ma! Au sumba-soo!” ");
INSERT INTO txq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ta dook ka bali, hatahori laen nara maruma naa, kokolak roon bali rae, “Weeh! O boso pepeko-leleko bali mae, o ta sama-sama mua hatahori naa! Ai mamanene o kokola-dadasin naa, sama tetar no hatahori Galilea!” ");
INSERT INTO txq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tehuu ana mulai oꞌole-aꞌali, boe ma ana laban nae, “Heeh! Au sumba-soo pake Manetualain naden! Au ta alela Hatahori naa!” Ndaa no ana kokolak talo naa, boe ma manu kokoa. ");
INSERT INTO txq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petrus namanene nala manu kokoan naa, boe ma nasaneda Yesus kokolan bebeik kara nae, “Manu bei ta kokoa, tehuu o laka laꞌe telu ena mae, o ta malela Au.” Petrus nasaneda nala naa, boe ma ana nalai dea neu de buꞌi nasakekedu. ");
INSERT INTO txq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bei huhua anan seli, basa hatahorir mana parisa dedeꞌa anggama raa, rala harak fo rae tao risa Yesus. ");
INSERT INTO txq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Huu naa de ara futu-paꞌa roo Yesus neu nasare nggubenor Pilatus. Ara nau fo nggubenor fee hukun mates neun. ");
INSERT INTO txq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Neu Yudas bubuluk nae, Yesus hambu hukun mates, boe ma ana fale dalen, nahuu ana seꞌo heni Yesus. De ana fali neni malangga anggama Yahudi malanggan nara, ma lasi-lasi hadak kara neu fo fee falik doi lilo fulak telu hulu naa. ");
INSERT INTO txq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ana nafada nae, “Au akilu-asala ena, nahuu au loo lima Hatahori ta naena salak hata esa boe na.” Tehuu ara raselu rae, “Weeh! Ai ta nau tao matak mia o bali! O mesa ngga ndia lemba-masaa kilu-salak naa.” ");
INSERT INTO txq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Boe ma Yudas toko falik doik kara raa reni Uma Huhule-haradoi Ina-huuk reu. De ana kalua neu londa aon losa maten. ");
INSERT INTO txq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Boe ma malangga anggama Yahudi malanggan nara raduduru rala doik kara fo Yudas nggari henik kara ena naa. Ara rakokola aok rae, “Ita ta bole tao falik doik kara iar reni peti doik neu, nahuu doik kara iar manggenggeok. ");
INSERT INTO txq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dadi malole lenak ita teu hasa tala dae faa numa mana tao ure dae mai. Mete ma hambu hatahori feꞌek mate, ma ta hambu hatahorir ralelan, na, ita bisa tatoin neu naa.” ");
INSERT INTO txq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Basa boe ma ara pake doik naa fo reu hasa dae naa. Huu naa de losa hatematak ia, hatahorir seseik dae naa rae, ‘Dae Daak’. ");
INSERT INTO txq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","No dalak naa, ara tungga hata fo Manetualain mana toꞌu dedeꞌan Yeremia kokolak memak kana ena nae, “Ara pake doi lilo fulak telu hulu fo hasa dae. Ara pake doik naa, nahuu doik desi naa, ara rasiꞌe paken fo bae neu hatahori esa belin, tungga hata fo hatahori Israꞌel asa raketu memak. ");
INSERT INTO txq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Dae naa, ara hasan numa mana tao ure dae mai, tungga Manetualain parendan neu au.” ");
INSERT INTO txq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Neu hatahorir leꞌa roo Yesus losa nggubenor, boe ma ana natane Yesus nae, “Talo bee? O ia, tebe-tebe hatahori Yahudir Manen, do?” Yesus naselu nae, “Tebe. Papa kokolak ndaa naa ena.” ");
INSERT INTO txq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Neu malangga anggama Yahudi malanggan nara ma lasi-lasi hadak kara rakasasaꞌek salak matak noꞌuk ka neu Yesus, tehuu Ana ta naselu hata esa boe na. ");
INSERT INTO txq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","De nggubenor natanen nae, “O ta mamanene sira kokolan naa? Ara fee salak neu O noꞌun seli ena. Tehuu tao hata de O ta bala sara boe?!” ");
INSERT INTO txq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tehuu Ana ta naselu faa boe na, losa nggubenor naa heran bali-bali. ");
INSERT INTO txq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tungga teuk, mete ma hatahori Yahudir tao feta Paska, hatahori noꞌuk kara rasiꞌe here rala hatahori bui esa fo nggubenor nakamboꞌik kana. ");
INSERT INTO txq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Faik naa, hambu hatahori bui esa, nade Barabas. Basa hatahorir bubuluk ndia naa see, nahuu manggaraun sudi selik kana. ");
INSERT INTO txq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Faik naa oo hatahori noꞌuk kara reni nggubenor Pilatus reu boe, fo roke ana nakamboꞌik hatahori bui esa, tungga sira siꞌen. Boe ma Pilatus natane sara nae, “Malole! Tehuu au akamboꞌik see? Nai ia oo, hambu Barabas ma hambu Yesus fo hatahorir raseseik kana rae, Karistus boe. Au akamboꞌik see? Ei here leo.” ");
INSERT INTO txq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Nggubenor kokolak talo naa, huu ana bubuluk malangga anggama Yahudi malanggan nara leꞌa roo Yesus neni ndia neu, nahuu ara mbiri rala Yesus seli.) ");
INSERT INTO txq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Neu nggubenor bei parisa dedeꞌak naa, boe te saon haitua harak feen nae, “Papa, ee! Besa-besa, ou, huu Yesus ia Hatahori ta naena salak hata-hata. Huu Ndia ia, de leꞌodaek ka au ala meꞌi ta malole. Losa hatematak ia oo, au bei ameda ta neulauk boe.” ");
INSERT INTO txq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tehuu malangga anggamar ma lasi-lasi hadak kara raa dudunggu hatahori noꞌuk kara raa, fo ara roke nggubenor nakamboꞌik Barabas, ma hukun mates Yesus. ");
INSERT INTO txq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","De ana natane seluk bali neu sara nae, “Numa hatahori kaduak kara iar, au akamboꞌik see?” Boe ma basa sara raselu rame-rame rae, “Barabas! Makamboꞌik kada Barabas leo!” ");
INSERT INTO txq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Boe ma ana natane sara nae, “Mete ma talo naa, na, au tao hata neu Yesus ia, fo hatahorir raseseik kana rae, Karistus?” Boe ma basa sara eki rame-rame rae, “Paku tao misan nai ai ngganggek leo!” ");
INSERT INTO txq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","De nggubenor natane seluk nae, “Ndia salan hata? Au parisan ena, tehuu au ta hambu salak hata esa boe na!” Tehuu basa sara boe eki rahere bali rae, “Tao misan! Pakun neu ai ngganggek leo!” ");
INSERT INTO txq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Doo-doo boe ma Pilatus bubuluk nae, ndia ta bisa tao hata-hata bali, huu hatahori noꞌuk kara raa rae ramue-anggik ena. Huu naa de ana haꞌi nala oe fo safe liman neu hatahorir raa matan nara, ma nafada nae, “Au ta lemba-asaa Hatahori ia mamaten! Naa fo ei ndia lemba-masaa malan!” ");
INSERT INTO txq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","De hatahori noꞌuk kara raa eki raselu rae, “Hou, neu leo! Naa fo ai mia ai umbu-anan nara ndia lemba-masaa mala Ndia daan naa!” ");
INSERT INTO txq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilatus namanene nala naa, boe ma ana nae, “Neu leo.” De ana nakamboꞌik Barabas tungga sira hihiin. Basa boe ma ana parenda mana manear, fo poko-femba Yesus pake fifiuk. Poko-femba basan, boe ma soldadur leꞌa roo Yesus fo rae reu paku tao risan nai ai ngganggek lain. ");
INSERT INTO txq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Basa naa, soldadur leꞌa roo Yesus neni sira kota batun bebela loan neu. Numa naa, ara roke rala sira nonoon nara batalion esa. ");
INSERT INTO txq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Boe ma ara rabua Yesus badu naru mbila kara-karak esa. ");
INSERT INTO txq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ma ara haꞌi rala ai kanggouk ndanan fo nanen dadi solangga. Boe ma ara ndeꞌi solangga kanggouk naa neu Yesus langgan, fo rakamiminak kana, sama leo ara rae soꞌuk mane beuk pake solangga manek. De ara rakatotoꞌuk ai esa neu lima konan, nok bali teteꞌe ai man-parenda. Boe ma ara sendek luu-langgan nara mbalin, ma rakatitiik kana rae, “Hada-horomatak neu hatahori Yahudir Manen.” ");
INSERT INTO txq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Boe ma ara pura ambe neu Yesus, ma haꞌi rala teteꞌe ai naa numa liman mai, de delu rakamiminak langgan. ");
INSERT INTO txq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ara rakatitiik rakamiminak basa Yesus, boe ma ara buka heni badu naruk naa. De ara feen pake falik bua-loꞌan nara. Basa boe ma ara leꞌa roon neni kota Yerusalem dean neu, fo rae reu pakun nai ai ngganggek lain losa maten. ");
INSERT INTO txq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Neu ara bei laꞌok fo leꞌa roo Yesus, ara ratonggo ro hatahori kota Kirene esa, bei fo nae maso neni kota Yerusalem neu. Ndia naden, Simon. Ara rakasetik kana fo lemba-nasaa nala ai ngganggek naa nggati Yesus. ");
INSERT INTO txq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Boe ma ara losa mamanak esa, nade Golgotaa. (Nai dedeꞌa Aram, sosoa-ndandaan nae, “Mamana langga duik.”) ");
INSERT INTO txq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Numa naa, ara rae fee Yesus ninu anggor neni babalik no modo malik, mita fo Ana nakatataka nala hedis. Yesus ninu nala kada faa, boe ma ana timba henin. ");
INSERT INTO txq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Basa boe ma ara paku Yesus neu ai ngganggek lain. Ma soldadur leꞌa lot fo sangga bubuluk see ndia hambu Yesus bua-loꞌan. ");
INSERT INTO txq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Boe ma ara ranggatuuk ranea Yesus numa naa. ");
INSERT INTO txq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ara oo surak neu papak esa boe nae, “IA YESUS, HATAHORI YAHUDIR MANEN” De ara paku papak naa neu Yesus langgan ndandaan lain fo rafada huun hata de sira fee hukun mates neun. ");
INSERT INTO txq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Numa naa oo ara paku rakanisa hatahori naꞌo manu-meo dua boe. Esa neu Yesus boboa konan; esa neu boboa kiin. ");
INSERT INTO txq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Basa hatahorir mana laꞌok resik naa, mete-rita Yesus. Boe ma ara korombiꞌe bafan nara, de rakatitiik kana. ");
INSERT INTO txq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ara eki mbalin rae, “Hoi! O mae O bisa mandefa heni Manetualain Uma Huhule-haradoi Ina-huun, basa de mambadedeik falik kana nai faik telu dalen, hetu? Mete ma O tebe-tebe Manetualain Anan, na, soba O makamboꞌik aom, fo konda numa ai ngganggek naa mai leo.” ");
INSERT INTO txq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Leo naak oo malangga anggama Yahudi malanggan nara, meser anggamar ma lasi-lasi hadak kara tungga rakatitiik Yesus boe rae, ");
INSERT INTO txq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ana tao nasoi-nasoda hatahori laen ena, tehuu Ana ta bisa tao nasoi-nasoda Ndia ao heli-helin! Ana nae, Ndia ia hatahori Israꞌel Manen! Mete ma talo naa, na, malole lenak Ana konda memak numa ai ngganggek naa mai. Mete ma ita mete-tita talo naa, dei fo ita tamahere neun. ");
INSERT INTO txq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mete ma tebe-tebe Ndia Manetualain Anan, naa fo ‘Ana namahena neu Manetualain. De mete ma Manetualain nau Ndia, na, mita fo Manetualain tao nasoi-nasodan.’ ” ");
INSERT INTO txq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Naꞌo manu-meo kaduak kara raa oo, tungga rakatitiik kana talo naa boe. ");
INSERT INTO txq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Basa naa, makiu-makahatuk tatana nala mamanak naa, numa ledo namatetu losa liꞌu telu ledo bobon. ");
INSERT INTO txq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ndaa no liꞌu telu ledo bobon, boe ma Yesus eki pake dedeꞌa Aram nae, “Eli! Eli! Lema sabaktani?” (Sosoa-ndandaan nae, “Au Lamatuang! Au Manetualaing, ee! Tao hata de Amak nasadea laꞌo ela Au talo ia?”) ");
INSERT INTO txq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hambu hatahori hida deka-deka ruma naa ramanene Yesus haran naa. Boe ma rae, “Hoi! Ei mamanene dei. Ana nanggou Elia, Manetualain mana toꞌu dedeꞌan lele uluk naa!” ");
INSERT INTO txq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Boe ma hatahori esa nalai neu haꞌi lombu fo boron neni anggor makeis neu. De ana nato lombu naa neu teteꞌe ai suꞌun, boe ma soron neni Yesus bifi doon neu, fo Ana musi. ");
INSERT INTO txq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tehuu hambu hatahori laen bali kokolak nae, “Tahani dei, fo ita mete sudik kana, Elia nae mai tao nasoi-nasodan, do taa?” ");
INSERT INTO txq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Boe ma Yesus eki seluk bali no hara berak, de maten. ");
INSERT INTO txq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nai Uma Huhule-haradoi Ina-huuk dale, hambu tema ririndi loak esa neni londak fo babata Manetualain Kama Malalao Mateꞌen. Ndaa no Yesus ketu ani hahaen, boe ma tema ririndik naa sii baꞌen neu dua, numa lain mai losa dae. Boe ma dae nanggenggo, losa batu moꞌok kara fanggi baꞌes sara. ");
INSERT INTO txq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Rates sara oo ratahuka boe. Ma Manetualain hatahorin mana matek kara ena, Ana tao nasoda falik ketuk ruma mamates mai. ");
INSERT INTO txq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Neu Yesus nasoda fali numa mamaten mai ena, boe ma ara kalua ruma rates mai, de maso reni Yerusalem reu. Hatahori noꞌuk ka mete-rita sara ruma naa. ");
INSERT INTO txq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Numa Golgotaa, hambu komedan no soldadun nara mana ranea Yesus ai ngganggen. Neu ara mete-rita dae-inak nanggenggo, ma basa hata fo mandadik naa ena, boe ma ara ramataꞌu ralan seli. Ara rakokola aok rae, “Awii! Hatahori ia, memak tebe-tebe Manetualain Anan!” ");
INSERT INTO txq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Numa naa oo, hambu inak hida fo ara tungga mete Yesus mamaten numa dook ka mai boe. Ara tunggan numa Galilea mai ena, huu ara ndia raono-lalaun numa bakahulun mai. ");
INSERT INTO txq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Numa inak kara raa mai, hambu Maria numa nggoro Magdala mai, Maria esa bali (ndia Yakobis ma Yusuf inan), ma Sabadeus saon (ndia Yakobis no Yohanis inan). ");
INSERT INTO txq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Numa naa, hambu hatahori kamasuꞌik esa numa nggorok Arimatea mai, nade Yusuf. Ana tungga Yesus nenorin dook ka ena. Yesus mamaten naa, tuda laꞌe-ndaa fai kaliman. Beꞌe-mai tuda laꞌe-ndaa hatahori Yahudir fai huhule-haradoin. Huu naa de, neu ledo sangga tesa, boe ma Yusuf sangga dalak fo nae nakonda memak Yesus ao-mbaa mamaten numa ai ngganggek lain mai. ");
INSERT INTO txq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","De ana neni nggubenor Pilatus neu, fo noke Yesus ao-mbaa mamaten. Boe ma nggubenor parenda fo ara loo lima mamates naa neu Yusuf. ");
INSERT INTO txq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Boe ma Yusuf neni Golgotaa neu. De ana nakonda Yesus ao-mbaa mamaten numa ai ngganggek naa mai. Boe ma ana mbomboti natalolole ao-mbaa mamates naa, no tema beuk mabeli. ");
INSERT INTO txq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Faik naa, hatahorir bei fo toꞌi basa bolok esa numa lete batu fo sadia memak rates fee Yusuf no nufanelun nara, mete ma ara mate. De Yusuf asa koꞌo roo Yesus ao-mbaa mamaten fo reu taon neni bolok naa neu. Boe ma ara loli rala batu moꞌok esa, de tatana ratalololen neu bolok naa lelesun. Basa naa, Yusuf asa fali reu sara leo. ");
INSERT INTO txq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Faik naa, Maria numa Magdala mai ma Maria laen naa oo tungga losa mamanak naa boe. Ara nggua-nggua mbali bolok naa. ");
INSERT INTO txq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Neu beꞌe-mai, ndaa no hatahori Yahudir fai hahae tao ue-osan. Boe ma malangga anggama Yahudi malanggan nara ma hatahori Farisir reu rasare nggubenor. ");
INSERT INTO txq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ara rafada rae, “Papa nggubenor, ai masaneda neu mana kedi-irak bei masodak, ana kokolak nita nae talo ia: ‘Memak Au mate, tehuu seli faik telu boe ma Au asoda fali numa mamates mai.’ ");
INSERT INTO txq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Huu naa de papa tulun madenu soldadur fo ranea ratalolole rates naa, losa fai katelun. No dalak naa, Ndia ana nunin nara ta bisa loi rala ao-mbaa mamaten, fo kedi-ira hatahorir rae, Ana nasoda fali numa mamaten mai ena. Mete ma ara kedi-ira talo naa, naa manggaraun lena ara kedi-ira fai bakahulun naa, neu ara rae Ndia ia, ndia Karistus.” ");
INSERT INTO txq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nggubenor namanene nala naa, boe ma naselu nae, “Malole boe! Tehuu ei kahatahori mana manear. Malole lenak pake kada sira leo, fo reu ranea ratalolole mamanak naa.” ");
INSERT INTO txq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Boe ma ara reni mamanak naa reu, ma roo sira hatahori mana manean nara. Losa naa, ara segel rakamate batu manai rates lelesu bafan. De ara radenu hatahorir raa ranea rakandoo mamanak naa, mita fo hatahori laen boso mai haꞌi reni mamates naa. ");
INSERT INTO txq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Neu fai Menggu huhua anan, boe ma Maria numa Magdala mai ma Maria laen naa, reu dangga rates naa. ");
INSERT INTO txq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Medak neu ma, dae-inak nanggenggo ta hohoꞌak. Manetualain atan esa numa nusa tetuk do inggu temak konda mai, de neu loli heni batu moꞌok naa, fo mana tatana bolok naa. Boe ma ana nanggatuuk neu batu naa lain. ");
INSERT INTO txq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ata naa matan nasaꞌa sama leo ndelas, ma bua-loꞌan muti lao ndoos. ");
INSERT INTO txq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hatahori mana manear raa ramataꞌu ralan seli, losa dere faku-faku, ma ara ta bisa rakaundak nok bali hatahori mates. ");
INSERT INTO txq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Boe ma ata numa nusa tetuk do inggu temak mai naa, nafada inak kara raa nae, “Ei boso mamataꞌu! Au bubuluk ei mai sangga Yesus, Hatahori fo ara paku risak numa ai ngganggek naa. ");
INSERT INTO txq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tehuu Ana ta nai ia ena. Ana nasoda fali numa mamaten mai ena, sama leo Ana kokolak memak kana ena. Mai maso dale miu fo mete no ei mata heli-helim, mamanak naa fo ara ralololi Ndia ao-mbaa mamaten. Mamanak naa rouk ena! ");
INSERT INTO txq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hatematak ia, ei fali lai-laik leo! Miu mafada ana nunin nara mae, Yesus nasoda fali numa mamaten mai ena. Ana laꞌok nakahuluk neni Galilea neu ena. Ara muste reu ratonggo roon nai naa, sama leo fai bakahulun Ana helu-bartaa memak neu sara ena. Mamahere leo. Fali leo fo mafada hata fo au kokolak ia ena!” ");
INSERT INTO txq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Boe ma inak kara raa ralai kalua laꞌo ela mamanak naa. Ara ramataꞌu, tehuu ara oo rameda nemehokok boe. Ara fali lai-laik fo tui basa dedeꞌak kara raa reu Ndia ana nunin nara. ");
INSERT INTO txq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tehuu neu ara bei laꞌok numa dalak, medak neu ma Yesus mai natonggo no sara. Ana kokolak nae, “Soda-molek!” Ara mete-rita naa, boe ma reu deka-deka de holu rala ein, ma rakaluku-rakatele neun. ");
INSERT INTO txq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Boe ma Ana kokolak nae, “Boso mamataꞌu, ee! Miu mafada Au ana nuning nggara, fo reu rahani Au nai Galilea.” ");
INSERT INTO txq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Neu inak kara raa bei laꞌok numa dalak, boe ma hatahori mana manear raa fali reni kota reu. Ara reu tui malangga anggama Yahudi malanggan nara basa mandadik kara raa ena. ");
INSERT INTO txq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Boe ma malanggak kara raa sangga dalak ro lasi-lasi hadak kara, fo fee hatahori mana manear raa doik noꞌun seli fo tatana bafan nara. ");
INSERT INTO txq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Malanggak kara raa rafada rae, “Talo ia. Mete ma hatahori ratane, na, ei muste maselu mae, neu fai leꞌodaek ei sunggu seli. Ta bubuluk te Ndia ana nunin nara mai, de ramanaꞌo reni ao-mbaa mamaten. ");
INSERT INTO txq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mete ma papa nggubenor namanene dedeꞌak naa, na, ei boso mamataꞌu, te neu ko ai ndia mataa mbali tou lasik.” ");
INSERT INTO txq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Boe ma hatahori mana manear raa haꞌi rala doik naa. Ara tao tungga malanggak kara raa hihiin. Huu naa de losa hatematak ia, hatahori Yahudir bei ramahere tutui pepeko-lelekok naa. ");
INSERT INTO txq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesus ana nuni kasalahunu esan nara raa ramanene basa inak kara raa tutuin, boe ma ara laꞌo reni profensi Galilea reu fo reu ratonggo roon nai letek esa, tungga Ndia hehelu-bartaan. ");
INSERT INTO txq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Neu ara mete-ritan numa naa, boe ma rakaluku-rakatele neun. Leo mae talo naa, tehuu bei hambu ketuk dalen nara bei rabaꞌe. ");
INSERT INTO txq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Boe ma Ana mai deka-deka no sara, de kokolak nae, “Manetualain fee Au koasa ena, fo Au parenda basa hata manai nusa tetuk do inggu temak, ma basa hata manai dae-bafok. ");
INSERT INTO txq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dadi ei meni bee miu a mesan, na, muste tui-bengga neu basa hatahori nusa-nusak kara, Au Tutui Maloleng. Ei muste fee nenorik matalolole neu sara, mita fo ara dadi reu Au ana nuning. Ma ei muste sarani sara, fo dadi tanda nae, sira rakaesa ro Amak, Ndia Anan, ma Ndia Dula-dale Malalaon ena. ");
INSERT INTO txq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma manori sara tao tungga basa parendar fo Au afada neu ei ena. Masaneda, ee! Au ua ei taa-taa nai ei taladam mara, losa dae-bafok fai mateꞌen.” ");
INSERT INTO txq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ia tutui malole, fo Manetualain Anan tutuin. Ndia naden Yesus Karistus. Manetualain dudu elan numa lele uluk mai ena. Ndia tutuin mulai talo ia: ");
INSERT INTO txq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yesus bei ta mulai Ndia ue-osan, te Manetualain nadenu hatahori esa, nade Yohanis, fo nakahuluk buka dalak soa-neu Yesus mamain. Lele uluk Manetualain pake Ndia mana toꞌu dedeꞌan esa ena, nade baꞌi Yesaya. Ana surak memak kana ena nae: “Nenene, ee! Au adenu Au hatahoring esa fo neu buka dalak fee O. ");
INSERT INTO txq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hatahori naa neu ko neni mamana nees neu, de ana bolu nae, ‘Basa hatahorir lalaꞌen tao malole dalak kara, fo simbok Lamatuak mamain! Ma fua matetu dokek kara fo simbok kana.’ ” ");
INSERT INTO txq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Hatahorir roke rateme Yohanis rae Mana Saranik. Ana leo nai mamana nees. Bualoꞌa-papaken, ara taon numa banda onta bulun mai. Kalekeen numa banda roun mai. Nanaꞌa-nininun ndia lamak ma fani oe. Yohanis leleo-lalaꞌon ia, sama leo baꞌi Elia lele uluk. Lelek naa, hatahorir ruma kota Yerusalem ma profensi Yudea isin nara mai ratonggo ro Yohanis numa ndia mamanan naa. Ara mai fo rae rita Yohanis ma sangga ramanene Yohanis nenorin. Yohanis nafada sara nae, “Ei muste manaku ma laꞌo ela basa ei sala-singgom mara lalaꞌen, fo ela Manetualain koka heni ei sala-singgom mara. Boe ma ei muste sarani dei, fo dadi neu tanda nae ei malole fali mia Manetualain ena.” Ramanene talo naa, boe ma ara manaku sala-singgon nara, de ana sarani sara numa lee Yarden. ");
INSERT INTO txq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ana nafada nae, “Neu ko Hatahori moꞌo-inahuuk esa lena heni au bali nae mai. Leo mae dadi uu kada ndia ana neondan oo, au ta andaa boe. ");
INSERT INTO txq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Au sarani ei pake kada oe, tehuu neu ko Ana tao lena heni au, ma Ana tao nasofe ei dalem mara no Manetualain Dula-dale Malalaon.” ");
INSERT INTO txq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Neu faik naa, Yesus numa nggoro Nasaret manai profensi Galilea mai, mai natonggo no Yohanis. Boe ma Yohanis sarani Yesus numa lee Yarden. ");
INSERT INTO txq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesus bei fo kalua numa oe dale mai, medak neu ma nita lalai natahuka, boe ma Manetualain Dula-dalen sama leo mbui lunda sina konda neni Yesus neu. ");
INSERT INTO txq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Boe ma Manetualain nahara numa lalai mai nae, “O ia, Au Ana susueng. O soa tao mamahoko Au.” ");
INSERT INTO txq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Basa boe ma Manetualain Dula-dalen nuni Yesus neni mamana nees esa neu. ");
INSERT INTO txq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nai mamanak naa, hambu kada banda fuir. Yesus leo numa naa doon faik haa hulu. Numa mamanak naa, nitur malanggan neu soba-dou Yesus fo tunggan, tehuu ta nala sana. Basa boe ma Manetualain atan nara ruma nusa tetuk do inggu temak mai fo reu ralalaun. ");
INSERT INTO txq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Faik naa fo ara tao Yohanis neni bui dale neu, boe ma Yesus neni profensi Galilea neu tui-bengga Manetualain Hara Lii Malolen nai naa. ");
INSERT INTO txq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ana nafada nae, “Nenene, ee! Hatematak ia Manetualain fain losa ena! Hatematak ia basa hatahori bei fo bubuluk rae, Manetualain toꞌu parenda. Huu naa de ei muste hahae numa ei pepeko-lelekom mai leo, fo tungga falik Manetualain, ma mamahere neu Ndia Hara Lii Malolen ia leo.” ");
INSERT INTO txq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Faik esa, Yesus laꞌok tungga dano Galilea tatain. Ana nita hatahori esa, nade Simon no fadin nade Anderias. Dua sara dala iꞌak. Naa sira ue-osan tungga-tungga faik. ");
INSERT INTO txq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus nanggou sara nae, “Woi! Mai fo tungga au leo! Ei masiꞌe sangga iꞌak, tehuu hatematak ia Au tao ei dadi miu mana sangga samanek.” ");
INSERT INTO txq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dua sara ramanene rala naa, boe ma ara laꞌo ela dala naa, fo reu tungga Yesus tutik ka. ");
INSERT INTO txq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Basa de Yesus laꞌok nala faa bali, boe ma nita Sabadius anan nara. Kaꞌak nade Yakobis no fadin nade Yohanis. Dua sara rafafaꞌu ralole puꞌak nai ofak lain. ");
INSERT INTO txq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus nanggou dua sara nae, “Wee! Mai fo tungga Au!” Boe ma dua sara laꞌo ela sira aman ma hatahori manaꞌa nggadin nara rai ofak lain. De ara reu tungga Yesus. ");
INSERT INTO txq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Basa boe ma Yesus no hatahori kahaak kara fo mana tungga Ndia naa, losa kota Kapernaum. Faik naa ndaa no hatahori Yahudir fai huhule-haradoin, boe ma Yesus maso neni uma huhule-haradoik dale neu, de fee nenorik numa naa. ");
INSERT INTO txq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Basa hatahori heran bali-bali neu ramanene Ndia kokolan, huu Ana bubuluk no tetuk nenorik naa isin. Naa, ta sama no hatahori Yahudi meser anggaman nara. ");
INSERT INTO txq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Faik naa, hambu hatahori fo nitu saꞌek esa. Ana oo neni uma huhule-haradoik dale neu, boe ma nitu manai hatahori naa dale bolu ");
INSERT INTO txq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","nae, “Weeh! Yesus hatahori Nasaret! O mai tao hata mua ai nai ia! O mai sangga makalulutu ai, hetu? Ai malela O. O ia, Hatahori Malalaok fo lele uluk Manetualain helu-bartaa nae nadenun mai.” ");
INSERT INTO txq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesus mbokan nae, “Makatema o bafam! Kalua laꞌo ela hatahori naa!” ");
INSERT INTO txq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Boe ma nitu naa tao nala hatahori naa ao-inan leꞌa kede-kede. De ana kalua numa hatahori naa neu, ma nakau nahere. ");
INSERT INTO txq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Boe ma basa hatahori manai uma huhule-haradoik naa dale bafan nara bese mboo, de rakokola aok rae, “Awii! Ia hata ia? Ana parenda nitur, de ara kalua tungga Ndia hihiin. Ia nenori beuk, do? Tou lasik kokolan ta neni babanggak!” ");
INSERT INTO txq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Boe ma hatahorir mulai tui-bengga mandadik naa ndule nggorok kara marai profensi Galilea. ");
INSERT INTO txq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ara kalua numa uma huhule-haradoik naa dale mai, boe ma Yesus neni Simon no Anderias uman neu. Yakobis no Yohanis tungga sara boe. ");
INSERT INTO txq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon ari-inan sumai, de ana sunggu nai mamana susungguk lain. Neu Yesus no ana nunin nara bei fo maso reni uma naa reu, te hatahori mai rafadan rae, “Ina lasik hambu sumaik.” ");
INSERT INTO txq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Basa boe ma Yesus neu tiro ina lasik, de Ana toꞌu nala liman fo nadedein. Ina lasik hedin mopon tutik kana. Boe ma ana nambadeik, de neu nalalau sara. ");
INSERT INTO txq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Neu ledo dei fo nae tesa, hatahorir reni sira hatahori kamahedin nara ma sira hatahorin fo nitu saꞌek kara mai, fo hule Yesus tulu-fali sara. ");
INSERT INTO txq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Losa basa hatahori kota esa isin nara rakarumbu reu de sofe uma naa bebelan. ");
INSERT INTO txq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Hatahorir raa hedin nara mata-matak kara, tehuu Yesus tao nahai basa-basa sara. Ma Ana oo husi kalua heni nitu noꞌuk ka boe. Ana ta fee lelak nitur raa kokolak, te ara oo ralelan boe, na. ");
INSERT INTO txq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Neu beꞌe-mai dulu silu fo bei makiuk, Yesus beꞌe ena de laꞌo numa uma naa neu. Ana neni mamana nees esa neu fo Ana hule-haradoi, kola-kola no Manetualain. ");
INSERT INTO txq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Neu Simon asa beꞌe, ta mete-rita Yesus de reu sanggan. ");
INSERT INTO txq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ara ratonggo ro Yesus, de rafadan rae, “Papa, hatahori noꞌuk ka mai sangga Papa.” ");
INSERT INTO txq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Boe ma Ana naselu nae, “Naa oo malole boe. Tehuu malole lenak ita teni nggorok laen mana deka nai ia teu dei. Au oo nau tui-bengga Hara Lii Malole neu sara boe. Te naa Au ue-osan, na.” ");
INSERT INTO txq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Basa boe ma Ana laꞌo ndule basa profensi Galilea fo tui-bengga Manetualain Hara Lii Malolen nai sira uma huhule-haradoin nara dale. Ma Ana oo husi heni basa nitur numa hatahorir mai boe. ");
INSERT INTO txq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Faik naa, hambu hatahori hedi kusta esa neni Yesus neu. Boe ma ana sendek luu-langgan de noke tulu-falik neu Yesus nae, “Papa, ee! Tulu-fali au dei! Au bubuluk Papa bisa tao mamopo au heding ia, mita fo hatahori boso nunute au bali. Sadi Papa nau.” ");
INSERT INTO txq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Basa boe ma Yesus dalen tuda kasian neu hatahori naa, de Ana loo liman fo nafaroe neun, ma nae, “Memak Au nau! O hai leo!” ");
INSERT INTO txq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Medak neu ma, hatahori naa hedin mopon tutik ka. De ana hai leo. ");
INSERT INTO txq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Boe ma Yesus nadenu hatahori naa fali neu ngga, ma Ana fee nesenedak neun ");
INSERT INTO txq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","nae, “Masaneda matalolole, o hai ena, tehuu ta bole tui esa boe na! Ma o muste tungga baꞌi Musa parendan dei. De muni malangga anggama muu dei, fo ana parisa o ao-inam, fo mete-nita o hedin mopon tebe ena, do beik. Boe ma muste muni o fefeem tanda makasi, mita fo basa hatahori bubuluk rae, o hai tebe-tebe ena.” ");
INSERT INTO txq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tehuu hatahori naa kalua, boe ma ana tui ndule sudi nai bee. De hatahori noꞌuk ka sangga fo rae ratonggo ro Yesus, losa-losak Ana ta bisa natudu matan nai nggorok dale. Ana leo nai mamana nees nai kada nggorok dea. Tehuu hatahorir sudi lua ruma bee mai fo sangga ratonggo roon. ");
INSERT INTO txq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tada faik hida boe ma Yesus neni Kapernaum neu seluk bali. Boe ma hatahorir ramanene rae Yesus nai uma ena. ");
INSERT INTO txq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","De hatahorir sudi ruma bee mai. Ara rakarumbu reu de rakaseseꞌe uma dale, ara sasi losa lelesu dea. Boe ma Yesus nafada sara Manetualain hihii-nanaun. ");
INSERT INTO txq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yesus bei kola-kola, te hatahori haa ndoro reni hatahori keko-luꞌuk esa neni Yesus neu. ");
INSERT INTO txq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tehuu hatahori sofen seꞌe-seꞌe, huu naa de ta bisa reni hatahori naa losa Yesus matan. Boe ma ara hene reni uma lain reu, de ara ofe heni uma sinin nai Yesus ndandaan lain. Ara ofe heni uma sinin, boe ma rakonda hatahori keko-luꞌuk naa no neneꞌin dae neu. ");
INSERT INTO txq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Neu Yesus mete-nita sara, Ana bubuluk ara ramahere tebe-tebe neu Ndia. Boe ma nafada hatahori keko-luꞌuk naa nae, “Ana nggee! Au fee ambon neu o sala-singgom mara ena!” ");
INSERT INTO txq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hambu meser anggama Yahudi hida ranggatuuk ruma naa. Neu ara ramanene Yesus kokolan naa, boe ma rameda ta malole nai dalen nara. ");
INSERT INTO txq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","De rakokola aok rae, “Hatahori ia nambarani sudi selik kana kokolak nae leo naa, ee! Kada Manetualain mesa kana bisa fee ambon neu hatahori sala-singgon. Hatahori ia kokolan naa, nakasasamak aon sama leo Manetualain. Ana nakadadaek Manetualain naa ena, ma!” ");
INSERT INTO txq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tehuu Yesus bubuluk memak dalen nara ena. De Ana nafada sara nae, “Ei boso duꞌa talo naa! ");
INSERT INTO txq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Tungga ei hahambum, na, bee ndia dakuk? Mete ma Au afada hatahori keko-luꞌuk ia ae, ‘O sala-singgom hambu ambon ena,’ na, neu ko ei ta bubuluk ana dadi tebe talo naa, do taa. Tehuu mete ma Au ae, ‘Mambadeik leo! Lulu mala o neneꞌim fo fali muu ngga leo’. Mete ma ana nambadeik tutik kana, naa ei bei fo mete-mita no ei matam mara mae, Au ia Hatahori Dae-bafo Isi-isik. Au aena koasa ma haak fo fee ambon neu hatahori sala-singgon.” Basa boe ma Yesus nafada hatahori keko-luꞌuk naa nae, ");
INSERT INTO txq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“O nenene, ee! Hatematak ia o hai ena! De mambadeik, lulu mala o neneꞌim fo fali muu ngga leo, ee.” ");
INSERT INTO txq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ana namanene nala talo naa, boe ma nambadeik tutik kana. De ana lulu nala neneꞌin, boe ma ana kalua laꞌo. Basa hatahorir ruma naa mete-rita ro mata deꞌen. Boe ma basa sara bafa bese mboo, de rae, “Awii! Ita bei fo mete tita dedeꞌa leo iak! Manetualain memak ta neni babanggak!” ");
INSERT INTO txq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Basa boe ma Yesus fali neni dano Galilea tatain neu bali. Hatahori noꞌuk ka mai ratonggo roon, boe ma Ana nafada sara Manetualain hihii-nanaun. ");
INSERT INTO txq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Numa naa, hambu hatahori esa nade Lewi, Alpius anan. Ana dadi neu man-parenda Roma mana susu bean. Yesus laꞌok nesik naa boe ma Ana mete-nita Lewi, de nae, “Wee! Mai fo tungga Au!” Lewi namanene nala Yesus nae leo naa, boe ma ana nambadeik fo tunggan tutik kana leo. ");
INSERT INTO txq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Basa boe ma Yesus asa raꞌa numa Lewi uman, sama-sama ro Lewi nonoo mana susu bean nara. Hambu hatahorir laen oo fo hatahori Yahudir henggenee sara rae, hatahori ta neulauk kara, tungga raꞌa ro sara numa naa boe. Numa hatahori mana ranggatuuk raꞌa naa mai, noꞌuk ka hii ramanene Yesus. ");
INSERT INTO txq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Faik naa, hambu meser anggama hida ruma partei Farisi mai, mete-rita Yesus nanggatuuk naꞌa no mana susu bear ma hatahori ta neulauk kara. Boe ma ratane ana nunin nara rae, “Tao hata de ei mesem nanggatuuk naꞌa no hatahori mana susu bear ma hatahori ta neulauk kara raa?” ");
INSERT INTO txq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tehuu Yesus namanene ara ratatane aok talo naa, boe ma Ana naselu nae, “Hatahori kamahedik memak parluu doter, tehuu hatahori bee fo sodak ena ta parluu. Au mai fo alalau hatahori ta neulauk kara. Tehuu Au ta mai fo alalau hatahori fo mana nameda aon hatahori ndoos ena.” ");
INSERT INTO txq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Laꞌe esa, partei anggama Farisi hatahorin nara puasa tungga anggama hohoro-lalanen. Ara mete-rita Yohanis Mana Saranik ana nunin nara oo puasa boe. Tehuu ta mete-rita Yesus ana nunin nara puasa leo sira. Boe ma sira hatahorin nara mai ratonggo ro Yesus, de ratanen rae, “Papa. Ai puasa. Yohanis hatahorin nara oo puasa boe. Tehuu tao hata de Papa ana nunin nara ta puasa?” ");
INSERT INTO txq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Boe ma Yesus naselu nae, “Memak ei bubuluk ena, mete ma tao feta kabin, na, fuik kara ta puasa, tehuu raꞌa-rinu losa rakabete. Mete ma baroit touk bei nai naa, na, neu ko basa sara raꞌa-rinu rame-rame. ");
INSERT INTO txq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tehuu neu faik esa mete ma hatahorir humu reni baroit touk, na, nonoon nara rameda susa, dei fo ara puasa.” ");
INSERT INTO txq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Boe ma Yesus tamba lololek esa nae, “Hatahori ta tanda tema beuk neu badu raak. Te mete ma safen, na, tema beuk naa kukundu de ana tao nasida tamba seluk badu raak naa. ");
INSERT INTO txq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Leo naak oo hatahori ta radai oe anggor beuk neni boboꞌik banda rou raak dale neu boe, te neu ko kadin ma ana sii sasarak, de oe anggor beuk naa mboꞌa henin. Dadi oe anggor beuk muste nadain neni boboꞌik banda rou beuk neu.” No lololek naa, Yesus nanori sara nae Ndia nenori beun boso babalik kana no hatahori Farisir nenori raan. ");
INSERT INTO txq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Laꞌe esa, ndaa no hatahori Yahudir fai huhule-haradoin, Yesus asa laꞌok resik osi esa dale. Boe ma Ndia ana nunin nara ketu rala hade-nggandum, de raꞌa. ");
INSERT INTO txq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tehuu hatahori Farisir mete-rita, de ratane Yesus rae, “Tao hata de O ana nunim mara lena-langga ita anggaman hohoro-lalanen? Ara ketu hade-nggandum ndaa no fai hahae tao ue-osa. Ei boso tao talo naa!” ");
INSERT INTO txq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ana naselu nae, “Talo bee, ou? Ei ta masaneda baꞌi Dauk tutuin, do? Lelek naa Abiatar dadi neu malangga anggama Yahudir malangga ina-huun. Baꞌi Dauk no ana nunin nara taꞌin nara kada kikiok, nahuu ndoe ralan seli ena. De ara maso reni Manetualain Laa Huhule-haradoin dale reu, boe ma haꞌi rala roti fo malangga anggamar fee basan neu Manetualain ena, de ara raꞌa. Naa te kada malangga anggamar ndia raꞌa roti naa, tehuu hatahori laen ta bole. De baꞌi Dauk asa raꞌa, tehuu ta hambu hatahori esa boe na fee salak neu sara.” ");
INSERT INTO txq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Boe ma Yesus nafada seluk bali nae, “Ei boso lilii-ndondou, huu Manetualain tao fai hahae tao ue-osa dadi neu babaꞌe-babatik fo tulu-fali ita hatahori dae-bafok. Ana ta tao ita hatahori dae-bafok fo kada tungga fai hahae tao ue-osa hohoro-lalanen. ");
INSERT INTO txq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Au ia, Hatahori Dae-bafo Isi-isik. De Au ndia aena haak fo afada hatahori dae-bafok ae bole, do ta bole tao sudi hata ndaa no fai hahae tao ue-osa.” ");
INSERT INTO txq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Basa boe ma Yesus fali seluk neni uma huhule-haradoik neu. Numa naa, Ana mete-nita hatahori esa fo liman seri mates. ");
INSERT INTO txq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Numa naa oo, hambu hatahori ruma ara sangga-sangga dalak fo fee salak neu Yesus boe. De ara mete mamakun fo sangga bubuluk Ana tao nahai hatahori naa ndaa no fai hahae tao ue-osa, do taa. ");
INSERT INTO txq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Boe ma Yesus nanggou hatahori fo lima mate seserik naa nae, “Mai fo mambariik muu mata ia.” ");
INSERT INTO txq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Boe ma Ana natane basa hatahorir raa nae, “Mete ma tungga ita anggaman hohoro-lalanen, ita bole tao kada hata ndaa no fai hahae tao ue-osa? Ita tao malole, do taa? Ita tao tahai hatahori, do tao tisan?” Tehuu basa sara bengge nee. ");
INSERT INTO txq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","De Yesus dalen susa nalan seli, nahuu ara hii kada tao matak neu anggama hohoro-lalanen, tehuu ta mbali neu hatahori fo lima mate seserik naa. Boe ma Ana namanasa de nakabubulak matan mbali sara. Basa de Ana nafada hatahori naa nae, “Loo o limam mai leo!” Hatahori naa loo liman neu, boe ma medak neu te liman hai tutik ka. ");
INSERT INTO txq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Basa boe ma hatahori Farisir raa laꞌo ela uma huhule-haradoik naa. De ara reu rala harak esa ro Herodes partei politin hatahorin nara fo ara sangga dalak rae tao risa Yesus. ");
INSERT INTO txq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Laꞌe esa, Yesus no ana nunin nara rakadedeak reni dano Galilea tatain reu. Tehuu hatahori noꞌuk ka ramanene basa hata fo Ana taon ena, huu naa de ara ruma basa nggorok kara mai fo tunggan. Ara ruma profensi Galilea, profensi Yudea ma profensi Idumea mai. Hambu ketuk ruma kota Yerusalem, kota Sidon ma kota Tirus mai. Ketuk bali ruma lee Yarden boboan dulu mai. Basa sara sangga Yesus fo rae ratonggo roon. ");
INSERT INTO txq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Huu hatahori noꞌun seli de Yesus nadenu ana nunin nara sadia feen ofak esa. Yesus hii kokolak numa ofak lain mai, mita fo basa sara ramanene ma mete-ritan no malole. ");
INSERT INTO txq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Fai bakahulun Ana tao nahai nita hatahori hedis noꞌuk ka. Huu naa de hatematak ia basa hatahori kamahedik kara rakaseseti fo nau rafaroe Yesus. ");
INSERT INTO txq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Neu hatahori fo nitu saꞌek kara mete-rita Yesus, boe ma lenggu heni sara ma rakaluku neu Yesus losa matan nara laꞌe daer. De ara bolu rahere rae, “O ia, memak Manetualain Anan!” ");
INSERT INTO txq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tehuu Ana kaꞌi nahere sara nae, “Boso mafada hatahori esa boe na mae, Au ia see!” ");
INSERT INTO txq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Basa boe ma Yesus hene neni letek esa lain neu. Ana nanggou nala hatahori ruma fo ndaa no Ndia dalen. De ara reu ratonggo roon. ");
INSERT INTO txq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Boe ma Ana here nala hatahori salahunu dua. De Ana nafada sara nae, “Au here ei fo tungga Au seku neu, fo dadi miu Au nedenung. Au fee ei miu tui-bengga Manetualain hara hehelun neu basa hatahori lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma Au ae baꞌe fee ei koasa, fo ei bisa husi heni nitur ruma hatahorir mai.” ");
INSERT INTO txq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Hatahori kasalahunu duak kara raa naden, sira: Simon (Yesus foin nade Petrus boe), Yakobis, Yohanis (Yakobis no fadin Yohanis ia, dua sara, Sabadius anan. Yesus foi dua sara nade ‘Boanerges’, sosoa-ndandaan nae ‘sama leo lalai nakaruu’.) Anderias, Felipus, Bartolomeos, Mateos, Tomas, Yakobis (Alpius anan), Tadius, Simon (mana tungga partei politik Selot), ma Yudas Iskariot (ana ia ndia neu ko seꞌo heni Yesus). ");
INSERT INTO txq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Basa boe ma Yesus no ana nunin nara konda fali numa letek lain mai. De ara maso reni uma dale reu. Tehuu hatahori noꞌuk ka mai rakarumbu rala Yesus bali, losa ara ta hambu lelak fo raꞌa-rinu. ");
INSERT INTO txq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hatahori mete-rita talo naa, boe ma rae, “Hena mete neu Yesus dei. Ana lilii faduli ao-inan ena.” Nufanelun nara ramanene hatahori kokolak talo naa, boe ma ara mai rae nuni roon laꞌo. ");
INSERT INTO txq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Faik naa, meser anggamar ruma Yerusalem mai fo rafada hatahori marai naa rae, “Weeh! Ei boso tungga doꞌo-doꞌo mia Yesus naa. Te Ana bisa husi nitu talo naa, nahuu Ana hambu koasa numa nitur malanggan mai, fo hatahori rasiꞌe roken rae, Balsebul.” ");
INSERT INTO txq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus namanene nala naa, boe ma ana noke nala basa sara, de nafada nae, “Ta dadi leo naak! Nitur malanggan ta bisa husi nasafali aon. ");
INSERT INTO txq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mete ma nai nusak esa dale rau-inggun nara rahuur-ratofa, na, neu ko nusak naa ta bisa nakataka nala dook. ");
INSERT INTO txq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mete ma uma-loo esa isin nara kada raraꞌu ao, na, neu ko uma-loo naa tetu-teman taa. ");
INSERT INTO txq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Leo naak oo mete ma nitur esa musu no esa boe, na, ndara baꞌe sara. No dalak naa, ara sida rakalulutu. ");
INSERT INTO txq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mete ma naꞌo manu-meo nae mai foꞌai bua-baꞌu nai hatahori barakaik esa uman, na, ana muste humu nala hatahori naa, boe ma futu-paꞌan dei. Basa dei fo ana bisa foꞌai uma naa bua-baꞌun. ");
INSERT INTO txq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Dadi Au afada memak ei: Manetualain sadia koka heni hatahori sala-singgon. Mete ma hatahori kokolak nakadadaek hatahori laen, na, Manetualain bei sadia fee ambon neun. ");
INSERT INTO txq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tehuu mete ma hatahori nambarani kokolak nakadadaek Manetualain Dula-dale Malalaon, na, Manetualain ta fee ambon neun, losa dae-bafok fai mateꞌen boe!” ");
INSERT INTO txq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus kokolak talo naa, nahuu ara henggeneen rae, “Hatahori naa, nitu saꞌen ena!” ");
INSERT INTO txq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Basa boe ma Yesus inan ma fadin nara reni uma naa reu, fo sangga ratonggo roon. Ara losa boe ma rambariik kada dea, de ara fee hatahori neu noken. ");
INSERT INTO txq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Faik naa, Yesus nanggatuuk kola-kola no hatahori noꞌuk ka. Boe ma hatahori mai nafadan nae, “Papa, ee! Papa mamam ma fadim mara rai dea. Ara sangga ratonggo ro Papa.” ");
INSERT INTO txq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tehuu Yesus naselu nae, “Au mamang ma toranoong tebe-teben, sira seer?” ");
INSERT INTO txq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Boe ma Ana mete basa hatahori mana manggatuu eko-feon. De Ana nae, “Basa ei lalaꞌen ia ndia Au mamang ma toranoong tebe-teben. ");
INSERT INTO txq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","See ndia tungga Manetualain hihii-nanaun, na, ana ndia Au nufanelu tebe-tebeng.” ");
INSERT INTO txq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Laꞌe esa, Yesus neni dano Galilea neu bali. Boe ma hatahori noꞌuk ka mai rakarumbu ralan. De Ana hene neu nanggatuuk numa ofa mana seek esa numa naa lain, boe ma Ana fee nenorik. Basa hatahori marai mada lai nenene nenorin. ");
INSERT INTO txq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","De Ana fee nenorik noꞌuk ka neu sara pake lololek nae, ");
INSERT INTO txq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ei nenene matalolole, ee! Hambu hatahori esa neu nggari bini-nggees nai ndia osin dale. ");
INSERT INTO txq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Neu ana nggari bini-nggees sara raa, hambu ketuk tuda nai dalak. Boe ma mbuik kara mai, de bido rabasa sara. ");
INSERT INTO txq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma bini-nggees ketuk tuda ndaa dae batuk. Bini-nggees sara raa ranumbu lai-lai, tehuu dae niꞌis, ");
INSERT INTO txq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","de neu ledo hene mai lain de nahaa, boe ma numbun nara male de mate ramatuu. Te okan nara ta tora losa dae dale na. ");
INSERT INTO txq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bini-nggees ketuk bali tuda nai dila-nggauk taladan. Boe ma dila-nggauk seti rakamate numbun nara, de ta bisa raboa. ");
INSERT INTO txq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma bini-nggees ketuk bali tuda ndaa dae isik. Bini-nggees sara raa ranumbu, basa de ramoꞌo losa raboa. Ketuk fee falik buna-boak lipa laꞌe telu hulu, ketuk lipa laꞌe nee hulu, ma hambu ketuk bali losa lipa laꞌe natun esa. ");
INSERT INTO txq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dadi ei see ndia kandiꞌi dook, na, nenene matalolole, ee!” ");
INSERT INTO txq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Boe ma neu Yesus mesa kana, Ndia ana nuni kasalahunu duan nara ma hatahori laen ruma fo mana ramanene rita Ndia nenorin naa, ara mai ratonggo roon. Ara roken nafada lololek naa sosoa-ndandaan. ");
INSERT INTO txq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Boe ma Yesus naselu nae, “Huu ei nau bubuluk tebe-tebe Manetualain parendan, de Au afada memak lololek naa sosoa-ndandaan. Tehuu mete ma hatahori laen, na, Au anori no kada lololek. ");
INSERT INTO txq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hatahori laen nara sama leo hata fo Manetualain mana toꞌu dedeꞌan surak memak kana ena nae, ‘Ara mete-rita ena, tehuu ta nau ralela. Ara ramanene ena, tehuu ta nau bubuluk. Naa fo ara hae ramahere neu Manetualain, fo Manetualain ta parluu fee ambon neu sara bali.’ ” ");
INSERT INTO txq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Basa boe ma Yesus nafada sara lololek naa sosoa-ndandaan nae, “Mete ma ei bei ta paꞌa-nato mala lololek ia sosoa-ndandaan, na, talo bee fo ei bisa paꞌa-nato mala lololek laen sosoa-ndandaan bali? ");
INSERT INTO txq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Dadi sosoa-ndandaan talo ia: hatahori mana nggari bini-nggees naa, sama leo hatahori mana tui-bengga Manetualain Dedeꞌa-kokolan. ");
INSERT INTO txq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma bini-nggees fo mana tuda nai dalak de mbuik kara bido raꞌa heni sara, naa sama leo hatahori mana namanene nala Manetualain Dedeꞌa-kokolan. Tehuu ta dook ka boe ma nitur malanggan mai, de haꞌi neni Dedeꞌa-kokolak naa numa hatahori naa dalen mai. ");
INSERT INTO txq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bini-nggees fo mana tuda ndaa dae batuk naa, sama leo hatahori fo namanene ma simbok nala Manetualain Dedeꞌa-kokolan no nemehokok. ");
INSERT INTO txq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tehuu Dedeꞌa-kokolak naa ta nahuu-naoka. Huu naa de ana ta nakai nala dook ka nai hatahori naa dalen. Neu hatahori laen nakasususak kana nahuu ana simbo Dedeꞌa-kokolak naa, boe ma ana nggari henin tutik kana. ");
INSERT INTO txq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma bini-nggees fo mana tuda nai dila-nggauk taladan naa, sama leo hatahori fo namanene nala Dedeꞌa-kokolak naa ena. ");
INSERT INTO txq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tehuu ana nasambute nalan seli no ue-osa mata-matak kara fo leo-laꞌo tungga dae-bafok lole-ladan. De basa nesembutek kara raa seti heni Dedeꞌa-kokolak naa numa dalen mai losa ta hambu buna-boak hata esa boe na. ");
INSERT INTO txq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma bini-nggees fo mana tuda ndaa dae isik, sama leo hatahori fo mana pasa ndiꞌi doon fo ana simbok nala Dedeꞌa-kokolak naa, ma ana tungga Manetualain hihii-nanaun. Basa de ana tao kada hata fo neulauk kara, sama leo bini-nggees mana mabuna-boak naa. Hambu ketuk rabuna-boa lipa laꞌe telu hulu, ketuk lipa laꞌe nee hulu, ma ketuk bali losa lipa laꞌe natun esa.” ");
INSERT INTO txq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus kokolak nakandoo numa ofak naa lain mai. Ana fee tamba lololek esa bali nae, “Talo bee! Ei mete mita ena do beik. Hatahori dede lambu tiꞌoek, de ana tatanan nenik lembaneu, do ana natetenden neni mamana susungguk fengga dalen neu. Taa hetu? Mete ma taon talo naa, na, ana ta manggaledo ena. Hatahori muste natetende lambu naa neu mamana demak mita fo hambu manggaledon. ");
INSERT INTO txq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","De hata fo neni nefunik hatematak ia, neu ko mete-titan. Ma hata fo hatahori ta bubuluk kana hatematak ia, neu ko bubuluk kana. ");
INSERT INTO txq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dadi see ndia kandiꞌi dook, na, nenene matalolole. ");
INSERT INTO txq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","De, duduꞌa matalolole! Mete ma ei uku-sudi hatahori laen tatao-nonoꞌin, na, hatahori oo uku-sudi ei leo naak boe. Manetualain oo uku-sudi nasafali ei leo naak boe. Tehuu Ndia uku-sudin beran lena bali. ");
INSERT INTO txq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Dadi mete ma hatahori nau sangga bubuluk tebe-tebe Manetualain hihii-nanaun, na, ana boe nalela. Tehuu mete ma hatahori ta tao matak neu Manetualain hihii-nanaun, na, ana boe namanggoa.” ");
INSERT INTO txq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Basa boe ma Yesus kokolak tamba nae, “Manetualain mamana parenda-koasan boe namoꞌo, sama leo bini-nggees fo hatahori nggarin nai osin dale. ");
INSERT INTO txq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Hatahori naa fali, leo mae ana sunggu do beꞌe, ta nasaneda bini-nggees naa bali, tehuu bini-nggees naa nanumbu ma ana boe namoꞌo nakandoo. ");
INSERT INTO txq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bini-nggees naa mori aon nai dae, boe ma nasarangga kahada, nabuna, naboa, losa naisi. ");
INSERT INTO txq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mete ma hade namatasa ena, na, tenu osik nalela kada neu ketu-koru leo. Manetualain mamana parenda-koasan oo leo naak boe. Basa naar, Manetualain ndia naue-osan.” ");
INSERT INTO txq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Basa naa Yesus tuti kokolan bali nae, “Au fee tamba lololek esa bali, talo ia: ei bisa makasasamak sudik Manetualain hatahorin nara. Mulai makasososan kada hidak ka, tehuu bakadean boe ma ara tamba ramanoꞌu. ");
INSERT INTO txq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Naa, nok bali ai deꞌe kadiꞌi anan seli. ");
INSERT INTO txq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tehuu mete ma ita sele-tande tala ai deꞌek naa ena, na, ana mori dadi neu ai huu mana moꞌon lenak. Boe ma mbuik kara mai hae saꞌok ma randunu rai naa.” ");
INSERT INTO txq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus nasiꞌe nanori sara tungga sira malelan. ");
INSERT INTO txq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ana nasiꞌe pake lololek, neu nanori hatahorir. Tehuu mete ma no Ndia ana nunin nara, na, Ana nafada lololek naa sosoa-ndandaan lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ledo bobon naa, Yesus bei nai ofak lain. Boe ma Ana nadenu ana nunin nara nae, “Mai ita saꞌe ofak teni serik teu.” ");
INSERT INTO txq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Boe ma ara saꞌe ofak sama-sama ro Yesus. De ara laꞌo ela hatahori noꞌuk kara raa ruma naa. Tehuu hambu ketuk saꞌe tungga ofak laen. ");
INSERT INTO txq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Faik naa Yesus ndae langgan neu kailunu, de Ana sunggu seli numa ofak ikon. Ta dook ka boe ma, ani makarumbuk mai. Rii tufa oe maso neni Yesus asa ofan dale neu, losa sangga sofen. De ana nunin nara ramataꞌu rae mate. Boe ma ara mai fafae Yesus rae, “Papa! Mambadeik dei! Ita sangga tae molo ia ena! Tehuu Papa ta tao matak neu ai!” ");
INSERT INTO txq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus namanene nala naa, boe ma nambadeik de Ana kaꞌi anin nae, “Nenee!” Ma Ana parenda neu dano nae, “Lende leo!” No hatematak naa anin hahae ma dano dadi neu lino-lendek leo. ");
INSERT INTO txq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Boe ma Yesus nahara berak ana nunin nara nae, “Tao hata de ei basa ngga mamataꞌu talo ia? Ei ta mamahere Au, do?” ");
INSERT INTO txq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Basa sara ramataꞌu ma heran, de rakokola aok rae, “Ndia ia see, ee? Losa rii ma anin oo ramanene neun boe, ee!” ");
INSERT INTO txq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Basa boe ma Yesus no ana nunin nara losa dano Galilea boboan seri numa mamanak esa nade Gerasa. ");
INSERT INTO txq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Numa mamanak naa, hambu touk esa nitu saꞌen de namulu. Ana leo nai rates sara. Hatu-leledon ana nadaba oek ndule basa mbumbukuk kara marai naa no hola-hola, ma ana kii-bolu nakandoo. Ana tutu nakahina ao-inan pake batu. Barakain sudi selik kana. Ta hambu hatahori esa boe na bisa futu-paꞌan, leo mae pake rante besi boe. Laꞌi-laꞌik ka hatahorir paꞌa lima-ein renik rante besi ena, tehuu ana tao ketu rante besi naa ma tao natepa heni besi numa ein mai. Ndia barakain sudi selik kana, de ta hambu hatahori esa boe na bisa nakatataka nalan. Neu Yesus asa konda numa ofak mai, de heta ein reu mada lai boe ma hatahori kamuluk naa mete-nita sara numa dook ka mai. De ana kalua numa rates ara mai, boe ma nalaik neu sendek luu-langgan neu Yesus matan. ");
INSERT INTO txq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesus mete-nita hatahori naa talo naa, boe ma Ana kokolak nae, “Heeh, nitu! O kalua numa hatahori ia neu leo!” Boe ma hatahori naa kii-bolu nahere nae, “Weeh! O mae tao hata neu au! Au bubuluk O ia, memak Yesus, Manetualain mana koasa mateꞌen Anan. Au hule fo O boso tuni-ndeni au!” ");
INSERT INTO txq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Boe ma Yesus natanen nae, “O nadem see?” Hatahori naa naselu nae, “Au nadeng Legion, huu ai noꞌun seli, nok bali soldadur batalion noꞌuk ka.” ");
INSERT INTO txq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Basa de nitur pake hatahori naa fo noke Yesus boso nadenu sara kalua numa mamanak naa mai. ");
INSERT INTO txq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hatahorir ranea bafi lalae esa deka-deka no mamanak naa. Bafir raa, basa sara fama te rifun dua. Ara sangga nanaꞌak rai letek tatain. ");
INSERT INTO txq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Boe ma nitur raa roke-hule Yesus rae, “Madenu ai maso mini bafir raa miu.” ");
INSERT INTO txq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus namanene nala nonoken nara raa, boe ma nakaheik. De nitur raa kalua numa hatahori naa neu, boe ma ara maso reni bafir raa reu. Bafi rifun kaduak kara raa ralaik ralenggu-pikok, boe ma ara tuda tungga mbiak tatain reni dano dale reu, de basa sara mate rasamele reu naa. ");
INSERT INTO txq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hatahori mana manea bafir raa mete-rita mandadik naa, boe ma basa sara ramataꞌu ralan seli. De ara ralaik reu rafada hatahori ndule nggorok kara marai naa. Boe ma hatahori noꞌuk ka kalua mai fo rae mete hata mandadik ena. ");
INSERT INTO txq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ara mai ratonggo ro Yesus, boe ma ara mete-rita hatahori fo nitu saꞌek naa nanggatuuk numa naa. Duduꞌan namaneu ena, de ana pake bua-loꞌa ena. Hatahorir raa mete-rita naa, boe ma ramataꞌu, nahuu ara bubuluk rae, see ndia bisa husi kalua heni nitu noꞌuk kara numa hatahori naa neu, na, ndia memak hatahori ta hohoꞌak tebe-tebe. ");
INSERT INTO txq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Boe ma basa sara bengga ndule nggorok rae, sira mete-rita no sira mata deꞌe heli-helin hatahori kamuluk naa hai ena, ma bafir raa fo mate rasamele ena. ");
INSERT INTO txq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Boe ma hatahori nggorok marai naa, ara mai roke-hule Yesus fo laꞌo ela sira mamanan. ");
INSERT INTO txq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Neu Yesus nae hene ofak dale neu, boe ma hatahori fo bebeik kara nitu saꞌek naa mai noke-hule Yesus fo ndia oo nau tungga boe. ");
INSERT INTO txq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tehuu Yesus ta nau. De nafadan nae, “Malole lenak o fali muu ngga fo mafada o nufanelum lalaꞌen, hata fo Manetualain taon fee o ena. Ma mafada mae, Manetualain sue nalan seli neu o.” ");
INSERT INTO txq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Basa boe ma hatahori naa fali neu ngga, de ana laꞌo ndule nusa kota salahunuk fo rasiꞌe roken rae, ‘Dekapolis’. Ana tui hata fo Yesus tao neu ndia ena. Basa hatahori mana ramanene tutuin naa, ara heran ralan seli, de rae, “Memak tetebes!” ");
INSERT INTO txq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Basa boe ma Yesus asa saꞌe ofak fali reni dano tatain seri reu. Neu ara konda numa ofak lain mai, te hatahori noꞌun seli mai rakarumbu ralan. ");
INSERT INTO txq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Numa naa oo hambu hatahori esa boe nade Yairus. Ndia naa, malanggan uma huhule-haradoik nai kota naa. Neu ana mete-nita Yesus, boe ma ana sendek luu-langgan neu Yesus matan, ");
INSERT INTO txq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","de ana kokoen nae, “Papa, ee! Au ana feꞌong bei fo teuk salahunu dua, ana namahedi ela kada faa maten. Papa tulun mai fo tao mahain dei.” ");
INSERT INTO txq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Boe ma Yesus tungga Yairus neni uman neu. Neu ara mulai laꞌok, boe ma hatahori noꞌuk ka tunggan de raseseti numa boboa kii-konan mai. ");
INSERT INTO txq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nai hatahori noꞌuk kara raa taladan, hambu inak esa hambu bulak ta tungga doon teuk salahunu dua ena. ");
INSERT INTO txq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ana nabasa tali-doin ma hata-heton nara fo bae neu doter asa. Tehuu ta hambu esa bisa tao nahain boe na. Hedin naa, kada mai-maik nakandoo. ");
INSERT INTO txq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Inak naa namanene noꞌuk ka laꞌe-neu Yesus ena. De ana naseseti nai hatahori noꞌuk kara raa taladan fo nau deka-deka neu Yesus numa dean mai. Ana duduꞌa nai dalen dale nae, “Sadi au bisa afaroe laꞌe kada Yesus badun, neu ko au hai!” Neu ana nafaroe laꞌe Yesus badun, medak neu te ndia daa mana mboꞌak naa hahae tutik kana. Ana nameda ana hai tebe-tebe ena. ");
INSERT INTO txq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hatematak naa oo Yesus nameda hambu barakaik kalua numa ao-inan mai. Boe ma Ana mbali dea, de mete neu hatahori noꞌuk kara raa. De Ana natane nae, “Ei see ndia nafaroe laꞌe Au badung, ee?” ");
INSERT INTO txq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ana nunin nara raselu rae, “Papa mesa kana mete leo. Hatahori noꞌuk kara iar esa naseseti no esa na. Naa te Papa natane nae, ‘See ndia nafaroe laꞌe Au badung?’ ” ");
INSERT INTO txq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tehuu Yesus leleuk ndule basan, fo sangga bubuluk bebeik kara ia see ndia nafaroe Ndia. ");
INSERT INTO txq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Inak naa namanene nala Yesus natane talo naa, boe ma namataꞌu nalan seli. De ana sendek luu-langgan neu Yesus matan fo ana mboꞌa nae, “Papa! Au ndia afaroe laꞌe Papa badun.” ");
INSERT INTO txq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Boe ma Yesus naselu neun nae, “Huu mama namahere tebe-tebe neu Au, de mama hai ena. Hatematak ia mama fali uma muu no dale lino-lendek leo, huu mama susa-sonan basan ena.” ");
INSERT INTO txq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus bei kola-kola talo naa, boe ma hatahori esa numa Yairus uman mai, de nafada nae, “Kasian ee, ana feꞌok maten ena. Dadi boso makasosotak Papa Meser bali. Ana hae neu bali.” ");
INSERT INTO txq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tehuu Yesus ta tao matak hatahori naa kokolan. De Ana nafada Yairus nae, “O hae mamataꞌu, ee! Mamahere neu kada Manetualain.” ");
INSERT INTO txq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Boe ma Yesus laꞌo ela ana nunin laen nara. Tehuu Ana nuni no Petrus, Yakobis ma fadin Yohanis, de ara laꞌo rakandoo. ");
INSERT INTO txq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Neu ara losa Yairus uman, ara mete-rita hatahori noꞌuk ka ramue-anggik, ma ramanene ara buꞌi rakarereu. ");
INSERT INTO txq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus maso uma dale neu, de natane sara nae, “Tao hata de ei mamue-anggik ma buꞌi makarereu talo ia? Kakanak ia ta mate. Ana kada sunggu a.” ");
INSERT INTO txq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ara ramanene Yesus kokolak talo naa, boe ma basa sara hika rakatitiik kana. Boe ma Ana nadenu basa sara dea reu. Ana noke nala kakanak naa aman no inan ma Ndia ana nunin telu sara, de basa sara maso reni kakanak naa kaman dale reu. ");
INSERT INTO txq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Boe ma Yesus toꞌu nala kakanak naa liman, de Ana kokolak neu kakanak naa pake sira dedeꞌa Aram nae, “Talita kum!” (Sosoa-ndandaan nae, “Ana feꞌok! Mambadeik leo!”) ");
INSERT INTO txq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Medak neu ma, ana fetok naa nambadeik, de ana mulai laꞌok. Boe ma Yesus nadenu inan nae, “Fee kakanak ia naꞌa leo!” Basa hatahorir fo mana mete-rita hata fo mandadik naa, heran bali-bali. Tehuu Yesus kaꞌi nahere sara nae, “Ei boso mafada esa boe na mae, Au asoda falik kana numa mamaten mai ena!” ");
INSERT INTO txq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Basa boe ma Yesus no ana nunin nara fali reni Ndia nggoron Nasaret reu. ");
INSERT INTO txq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ndaa no hatahori Yahudi fai huhule-haradoin, Yesus maso neni uma huhule-haradoik dale neu de Ana fee nenorik. Faik naa, hambu hatahori noꞌuk ka reu hule-haradoi. Neu ara ramanene Yesus nenorin, ara heran bali-bali, de rae, “Hatahori ia malelan mata ia, ma! Ana oo naena koasa boe! Talo bee de Ana bisa leo naak? ");
INSERT INTO txq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Naa te Ndia kada tukan ai. Ita talela inan, ndia Maria; no fadin nara, sira Yakobis, Yoses, Yudas ma Simon. Ndia oo naena fadi inak hida boe. Ita basa ngga leo nai nggorok esa, ma!” Huu naa de ara mbiri ma rasakele, de ara ta nau ramanene neu sana bali. ");
INSERT INTO txq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Boe ma Yesus nafada nae, “Memak tetebes! Hatahori hihiin lenak fee hada-horomatak neu Manetualain mana toꞌu dedeꞌan numa mamanak laen mai. Tehuu nai ndia nggoro-tadun, hatahori ta fee hada-horomatak neun.” ");
INSERT INTO txq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Tehuu hatahorir raa dalen nara matea ndoos, de ara ta nau ramahere neu Yesus. Huu naa de Ana heran, de Ana ta nau pake koasan nai naa bali. Ana tao nahai kada hatahori kamahedik esa do dua. ");
INSERT INTO txq_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Basa boe ma Yesus laꞌo ndule basa nggoro matia-taik kara, de nanori hatahorir Manetualain hihii-nanaun. ");
INSERT INTO txq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ana noke nala ana nuni kasalahunu duan nara, de Ana nadenu sara laꞌok dua-duak reu tui-bengga Manetualain Hara Lii Malolen. Ana oo fee koasa neu sara boe fo ara bisa husi nitu. ");
INSERT INTO txq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ana parenda neu sara nae, “Ei hae meni hata noꞌuk ka nai dalak. Neu ko Manetualain ndia koladun. Hae meni lepa-nggees, tali-doik ma tas. Tehuu meni kada teteꞌe ai, tabu eis ma badu esak ka. ");
INSERT INTO txq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mete ma hambu hatahori simbok ei nai uman nara, na, ei muste leo nai naa losa ei laꞌo seluk bali. ");
INSERT INTO txq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tehuu mete ma losa mamanak esa, ma hatahori marai naa ta nau simbok ma ta nau ramanene neu ei, na, nggani laꞌo ela naa. Ma mafada sara mae, ‘Ei ta nau mamanene, na. De ela numa naa fo ei mesa ngga lemba-masaa neselu-netaam!’ ” ");
INSERT INTO txq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Basa boe ma ara laꞌo reu tui-bengga Hara Lii Malole naa. Ara rafada basa hatahori fo muste hahae leo numa sira sala-singgon nara mai, de fali fo leo-laꞌo tungga Manetualain hihii-nanaun. ");
INSERT INTO txq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ara oo husi kalua heni nitur boe. Basa naa ara tao mina neu hatahori hedis langgan nara, fo hule-haradoi tao rahai sara. De ara hai tutik kana. ");
INSERT INTO txq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Faik naa, hatahori nai mamanak bee a mesan ralela Yesus ena. Tutuik laꞌe-neu Ndia koasan naa, losa Manek Herodes ndiꞌi doon ena boe. Hambu hatahori rae, “Yohanis Mana Saranik naa nasoda fali nai Yesus aon dale. Huu naa de Ana bisa tao nala tanda heran nara raa lalaꞌen.” ");
INSERT INTO txq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tehuu hambu hatahori laen rae, “Taa! Ia Elia ndia mana nasoda falik nai Ndia aon.” Hambu laen bali rae, “Ndia naa, Manetualain mana toꞌu dedeꞌan laen numa lele uluk mai.” ");
INSERT INTO txq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Neu manek Herodes namanene ara kokolak laꞌe-neu Yesus talo naa, boe ma ana naselu nae, “Ia mete te ndia Yohanis Mana Saranik fo fai maneuk kara au adenu tete rala langgan. Hatematak ia ana nasoda fali numa mamaten mai ena!” ");
INSERT INTO txq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Manek Herodes nadenu fo tete heni Yohanis Mana Saranik langgan talo naa, nahuu ana naena dedeꞌa moꞌok no Yohanis. Tutuin talo ia: manek Herodes sao nala fadin Felipus saon, nade Herodias. Naa te Felipus no Herodias ta bei raelak. Huu naa de Yohanis kaꞌi-ore laꞌi-laꞌik ka nae, “Papa manek ta bole sao mala papa fadim saon. Naa nalena-langga ita hatahori Yahudir dala-hadan ena!” Leo mae talo naa, tehuu Herodes sao nala inak naa boe. Basa boe ma ana nadenu hatahorir reu humu Yohanis fo mason neni bui dale neu. ");
INSERT INTO txq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Huu no Yohanis kaꞌi-ore laꞌi-laꞌik ka ena talo naa, de inak naa nambeda dalek fo nae tao nisan. Tehuu ta bei dadi, te Herodes kena nala Yohanis nai bui dale ena. ");
INSERT INTO txq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Boe ma ana nadenu soldadur fo ranea ratalololen. Herodes memak namahia Yohanis. Ana bubuluk nae, Yohanis naa, Manetualain ndia nadenun. Ma Yohanis naa oo hatahori neulauk boe. Herodes memak namahoko namanene Yohanis kokolan. Tehuu laꞌe-laꞌe esa dalen nameda ta neulauk, neu ana namanene Yohanis kokolan boe. ");
INSERT INTO txq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Basa boe ma faik esa, Herodias hambu dalak fo bala ndia dalen fo mana nameda hedis. Faik naa, ara tao manek Herodes fai bobonggin. Ara roke hatahori moꞌo-inahuuk kara fo mai raꞌa feta fai bobonggik. Mana maik kara raa, hatahori mana parendar, malangga soldadur ma lasi-lasi hada Galilear. ");
INSERT INTO txq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Neu feta bei laꞌok, boe ma Herodias ana feton maso neu lendo. Lelendon lolen seli, de tao namahoko Herodes no fuin nara. Boe ma Herodes noke nalan, de natanen nae, “O mae moke hata numa au mai, na, mafada leo! Neu ko au fee. ");
INSERT INTO txq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Leo mae o moke au nusang baꞌe duan oo au fee boe. Au sumba-soo pake Manetualain naden!” ");
INSERT INTO txq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Boe ma ana fetok naa neu natane inan nae, “Mama! Tungga mama, na, au oke hata ndia neulaun seli numa papa mai?” Boe ma inan naselu nae, “Naaa! Muu fo moke mala Yohanis naa langgan.” ");
INSERT INTO txq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Basa boe ma ana fetok naa lai-laik neni Herodes neu, de nae, “Papa! Au oke fo meni fee au Yohanis langgan, taon neu dulang dale. Hatematak ia leo!” ");
INSERT INTO txq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes namanene nala naa, boe ma tendak heni taꞌi dalen tutik kana. Tehuu ana ta bisa leꞌa falik sumba-soon ena, nahuu basa hatahori ramanene ena, na. ");
INSERT INTO txq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Basa boe ma ana parenda malangga soldadu esa fo neu tete Yohanis langgan nai bui dale. ");
INSERT INTO txq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Boe ma ara tete rala Yohanis langgan, de taon neu dulang dale, fo renin fee ana fetok naa. Ana simbo nala dulang naa, boe ma koꞌo nenin fee inan. ");
INSERT INTO txq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Neu Yohanis ana nunin nara ramanene rae, ara haꞌi reni Yohanis langgan ena, boe ma ara mai haꞌi rala Yohanis nenetun, de reu ratoin. Yohanis mamaten tutuin baꞌu kada naa. ");
INSERT INTO txq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Faik esa, Yesus ana nunin nara fo Ana nadenu sara ena reu tui-bengga Manetualain Hara Lii Malolen naa, ara fali de rakabua seluk ro Yesus. Ara rafada basa hata fo ara taok, ma hata fo ranori neu hatahorir ena. ");
INSERT INTO txq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tehuu faik naa, hatahori noꞌuk ka laꞌok reu-mai fo sangga Yesus. Losa-losak ka Ndia no ana nunin nara ta bisa raꞌa-rinu rala ena. Boe ma Yesus nafada ana nunin nara nae, “Mai fo ita teu sangga mamana nees fo ita bisa hahae tala faa dei ma.” ");
INSERT INTO txq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","De basa sara hene reni ofak dale reu fo reu sangga mamana nees fo dook ka numa nggorok mai. ");
INSERT INTO txq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tehuu hatahori noꞌuk kara raa mete-rita Yesus asa ofan laꞌok loro-loro dano tatain. Boe ma ara kalua numa nggorok reu tungga dala mada laik, de ara losa rakahuluk numa Yesus asa mai. ");
INSERT INTO txq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Neu Yesus konda numa ofak lain mai, boe ma Ana mete-nita hatahori noꞌuk ka rahanin ena. Basa boe ma dalen tuda kasian neu sara, nahuu basa sara ta bubuluk nau tao hata, sama leo bibi lombo mana lolo taak. Boe ma Yesus nanori sara Manetualain hihii-nanaun ");
INSERT INTO txq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","losa ledo bobok. Boe ma ana nunin nara rafadan rae, “Papa! Malole lenak Papa madenu hatahori iar basa sara reu hasa nanaꞌak nai nggorok matia-taik kara marai iar. Huu ledo bobok ia ena, ma ta hambu nanaꞌak nai ia.” ");
INSERT INTO txq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tehuu Yesus naselu nae, “Bosok! Ei ndia mahao sara leo.” Tehuu ara ratane rasafali rae, “Awii! Mete ma ai mahao hatahori noꞌuk kara iar, na, ai muste kalua doik noꞌun seli. Desi leo tukan esa nggadin teuk esa! Ta bisa dadi ai hambu doik desi naa!” ");
INSERT INTO txq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Boe ma Yesus naselu nae, “Ei miu matane sudi sara dei, hambu see ndia neni lepa-nggees.” Ara reu ratane basa boe ma ara fali mai, de rafada rae, “Hambu kada roti lima ma iꞌak dua.” ");
INSERT INTO txq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Boe ma Yesus nadenu basa hatahori raa fo ranggatuuk rakabubua reu naꞌu lain. ");
INSERT INTO txq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","De ara reu ranggatuuk rakabubua. Hambu bubuak ruma beke natun esak, ma ruma beke lima huluk. ");
INSERT INTO txq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Basa boe ma Yesus haꞌi nala roti kalimak kara ma iꞌa kaduak kara raa. De Ana nasare mbali lalai neu fo noke makasi neu Manetualain. Boe ma Ana fifiꞌi baꞌe roti naa, de Ana loon neu ana nunin nara fo reu babaꞌe fee basa hatahori raa. Ana oo babaꞌe iꞌa kaduak kara raa fee sara boe. ");
INSERT INTO txq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Basa sara raꞌa losa rakabete. ");
INSERT INTO txq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ara raꞌa basa boe ma ana nunik kara raa reu raduduru rala nanaꞌa lenan nara, sofe lembaneu salahunu dua. ");
INSERT INTO txq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hatahori mana raꞌak kara raa nai rarain desi rifun lima. Naa bei kada touk kara. Ta bei reke tamba inak kara ma kakanak kara. ");
INSERT INTO txq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Basa boe ma Yesus nadenu ana nunin nara reu saꞌe ofak fo rakahuluk reni nggoro Betsaida nai dano boboan seri naa reu. Tehuu Ana bei nahani nai naa fo nadenu hatahori noꞌuk kara raa fali reu sara. ");
INSERT INTO txq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Neu basa sara fali boe ma Ana hene neni letek esa lain neu fo hule-haradoi. ");
INSERT INTO txq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Neu fai leꞌodae ena, boe ma Yesus konda fali. Ana mete-nita ana nunin nara ofan ena losa nai dano taladan. Tehuu ara sefe rangginggiok, nahuu ani soru. Neu lole manggaledo, boe ma Yesus neu laꞌo tungga sara. Tehuu Ana laꞌok nesik oe lain. Neu Ana nae laꞌo seli ofak naa ena, boe ma ara mete-ritan. Ara nggengger ralan seli. Boe ma esa natane esa nae, “Weeh! Hata ia? Maro, do hata?” Tehuu Yesus nahara tutik ka nae, “Wei! Ei boso mamataꞌu, ee! Te Au ndia ena.” ");
INSERT INTO txq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Neu Yesus hene neni ofak dale neu, boe ma anin lende tutik kana. Ndia ana nunin nara lalaꞌen heran ta basa-basa. ");
INSERT INTO txq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ara bei fo mete-rita Yesus pake koasan fo nahao hatahori rifun lima lenak. Tehuu ara bei ta ralela tebe-tebe Yesus koasan, nahuu sira dalen nara bei matea ndoos. ");
INSERT INTO txq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Neu ara losa dano tatain seri, boe ma ara see numa kota Genesaret namo seseen. ");
INSERT INTO txq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Neu ara konda numa ofak lain mai, hatahori noꞌuk ka mete-rita sara ena. De ara bolu rae, “Wei! Yesus mai ena!” ");
INSERT INTO txq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Basa sara ralaik reu rafada ndule hatahorir, de ara koꞌo-luꞌa reni hatahori hedis sara mai. Sadi ara ramanene rae, Yesus nai mamanak esa, na, ara rame-rame koꞌo-luꞌa reni hatahori hedis sara fo ralololi sara reu dae moo-loak. Ara duduꞌa rae, “Sadi hatahori hedis sara raa rafaroe laꞌe kada Yesus badun suꞌun oo, ara hai tutik kana boe.” Ara rafaroe laꞌen talo naa, boe ma ara hai tutik kana. ");
INSERT INTO txq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Hambu hatahori Farisi bubuak esa ro meser anggama hida ruma Yerusalem mai fo ratonggo ro Yesus. ");
INSERT INTO txq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Hatahori Farisir raa toꞌu rahere sira Yahudir dala-hadan. Ndia leo, mete ma hatahori rae raꞌa-rinu, na, muste safe liman tungga sira dala-hadan hihiin. Leo naak oo mete ma fali numa pasar mai boe, ara muste radiu oe dei. Losa-losak sira bua-baꞌun manai dapur, ndia leo urek, pinggak, nggalaas ma cerek, muste safe basa sara tungga sira dala-hadan hihiin, dei fo bole raꞌa-rinu pake sara. Mete ma hambu hatahori Yahudi laen fo ta tao tungga dala-hadak naa, na, hatahori Farisir ramanasa. Neu ara mete-rita Yesus ana nunin nara raꞌa ta safe liman tungga dala-hadak hihiin, de ara ramanasa. Boe ma ara mai fo fee salak neu Yesus rae, “Tao hata de O ana nunim mara raꞌa, tehuu ta safe limak dei? Naa, ara laban ita dala-hadan numa bei-baꞌir mai!” ");
INSERT INTO txq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Tehuu Yesus naselu nae, “Eir ia, memak hatahori mana kokolak laen, tao laen. Numa lele uluk mai baꞌi Yesaya surak Manetualain hara hehelun ena nae, ‘Hatahorir ia koa-kio Au, no kada bafan nara, tehuu ta no dalen nara. Ara tao talo naa oo, naa kada hie-hie a mesan boe. Ara ta tao matak Au hihii-nanaun, tehuu ara tungga kada hatahori dae-bafok hihii-nanaun.’ Ei oo sama leo naak boe. ");
INSERT INTO txq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Ei laꞌo ela Manetualain hihii-nanaun ena, fo tungga kada hatahori dae-bafok dala-hadan. Memak tungga naa, na, ei malelan seli! ");
INSERT INTO txq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Lele uluk baꞌi Musa nafada Manetualain parendan ena nae, ‘Fee hada-horomatak neu ei ina-amam.’ Ma tamba bali nae, ‘Mete ma hatahori esa oꞌole-aꞌali inan do aman, na, muste hukun mates neun.’ ");
INSERT INTO txq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Manetualain fee nenorik talo naa, tehuu ei fee nenorik laen bali. Ei mae, ‘Mete ma hatahori helu-bartaa nae fee ndia bua-baꞌun esa neu Manetualain, na, ta bole pake buas naa fo tulu-fali ina-aman, leo mae ara doidoso ralan seli, huu ana helu-bartaa ena, nae neu ko ana feen neu Manetualain.’ ");
INSERT INTO txq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Huu naa de bebeik kara ia Au kokolak ena ae, ei nggari heni Manetualain hihii-nanaun ena, de ei nggatin no hohoro-lalane beuk. Hambu hohoro-lalanek noꞌuk ka, ei nggati sara ena talo naa.” ");
INSERT INTO txq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Basa boe ma Yesus nanggou nala hatahori laen numa naa, de nae, “Pasa ndiꞌi doom mara dei, fo ei malela. ");
INSERT INTO txq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hata fo maso neni poꞌok dale neu, naa ta tao nanggenggeo hatahori. Tehuu hata fo kalua, naa ndia tao nanggenggeon. ");
INSERT INTO txq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","See ndia kandiꞌi dook, na, nenene matalolole, ee!” ");
INSERT INTO txq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Basa boe ma Yesus no ana nunin nara laꞌo ela hatahorir raa, de maso reni uma esa dale reu. Boe ma ana nunin nara ratane lololek naa sosoa-ndandaan. ");
INSERT INTO txq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesus naselu nae, “Ei oo ta malela boe, do? Talo ia: hata fo hatahori naꞌan, na, naa malole. Tehuu hata fo ana kalua, naa ndia ta malole. Hata fo ita taꞌan, maso neni poꞌok dale neu, basa naa kalua henin bali. (Lamatuak Yesus lololen naa sosoan nae, hatahori sudi raꞌa hata a mesan, ta kena-kaꞌi.) ");
INSERT INTO txq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tehuu hata fo kalua numa hatahori dalen mai, naa ndia tao nanggenggeon losa Manetualain nunuten, de ta nau nakabua noon. ");
INSERT INTO txq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Huu dedeꞌa manggarauk noꞌuk ka kalua numa hatahori dalen mai! Sama leo: duduꞌa manggarauk, laꞌok sala no hatahori fo ta ndia sao toun do ndia sao inan, nemenaꞌo, nekenisa hatahori, ");
INSERT INTO txq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","bare-naꞌo, hohongge-lelena, tatao manggarauk, pepeko-leleko, tungga kada ao-mbaak hihiin, dale mana mbirik, kokolak tao naboboo hatahori naden, koa ao, ta malela hadak, ma langga batuk. ");
INSERT INTO txq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Dadi basa manggarau leo naak kara raa kalua numa hatahori dalen mai. Naa ndia tao nanggenggeon. Losa Manetualain oo nunuten boe.” ");
INSERT INTO txq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Basa boe ma Yesus asa laꞌo ela mamanak naa, de reni kota esa reu nade Tirus. Losa naa boe ma ara maso reni uma esa dale reu, nahuu Yesus ta nau hatahorir bubuluk Ndia nai naa. Tehuu Ana ta bisa nafuni nala aon. ");
INSERT INTO txq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Numa naa hambu inak esa fo ta hatahori Yahudi. Ndia neni bonggin numa nusa Fenisia nai profensi Siria. Neu ana namanene Yesus mai, de ana neu noke-hule Yesus fo husi heni nitu numa ana feton neu. ");
INSERT INTO txq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tehuu Yesus tee mbolek nae, “Kakanak kara muste raꞌa rakahuluk, dei fo nggari nanaꞌa lenan fee busa.” Ma sosoan bei nefunik nae, Yesus muste tulu-fali Ndia hatahori Yahudin nakahuluk, dei fo bisa tulu-fali hatahori laen. ");
INSERT INTO txq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tehuu inak naa naselu nae, “Tebe, Papa! Tehuu busa naa nai mei fengga dalen. Ana oo naꞌa hata fo tuda numa kakanak naa pinggan dale mai boe.” Ma sosoan nae, kakanak kara raꞌa, na, busa oo hambu naꞌa boe. Leo mae Yesus tulu-fali Ndia hatahorin oo, tehuu Ana muste susuri-memete hatahori laen boe. ");
INSERT INTO txq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesus namanene nala naa, boe ma nafada nae, “Awii! Mama kokolak ndaa tebe! Dadi mama fali muu ngga leo, te nitu naa kalua numa mama anan mai ena.” ");
INSERT INTO txq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Basa boe ma inak naa fali neu ngga. Ana losa uma, te anan mana sunggu selik. Memak nitu naa kalua tebe ena. ");
INSERT INTO txq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Basa boe ma Yesus asa kalua laꞌo ela kota Tirus, laꞌok tungga tasi tatain resik kota Sidon. Numa naa mai ara laꞌo rakandoo losa dano Galilea. Boe ma ara laꞌo reni nusa kota salahunuk fo rasiꞌe roken rae, ‘Dekapolis’. ");
INSERT INTO txq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nai mamanak naa hambu hatahori esa nggoak ma mbakek. Ndia nonoon nara roon neni Yesus neu. Ara roke-hule Yesus ndae liman neu hatahori naa, fo tao nahain. ");
INSERT INTO txq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Boe ma Yesus laꞌo ela hatahori noꞌuk kara raa, de Ana fiti feꞌe no kada hatahori naa. Yesus tao lima kukun neni hatahori naa ndiꞌi doon dua sara dale neu. Basa boe ma Ana tao ambe neu lima kukun de nafaroe hatahori naa maan. ");
INSERT INTO txq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesus nasare mbali lalai neu, de leꞌa hahaen, boe ma ana parenda pake sira dedeꞌan nae, “Efata!” (Sosoa-ndandaan nae, “Buka leo!”) ");
INSERT INTO txq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ana kokolak talo kada naa, boe ma hatahori naa ndiꞌi doon namanene tutik kana. Hatahori naa maan fo mana barakaik naa, bangganaꞌu tutik ka, de ana mulai kokolak no malole. ");
INSERT INTO txq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Basa boe ma dua sara fali reni hatahori noꞌuk kara reu. Yesus ndindia sara nae, “Nenene, ee! Ei boso mafada hatahori mae, Au tao ahai hatahori ia ena.” Leo mae Yesus ndindia nahere sara, tehuu ara tui-bengga sudi nai bee. ");
INSERT INTO txq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hatahori fo mana ramanene tutuik naa, ara heran ralan seli. Ara bese kola rae, “Ta neni babanggak! Hatahori ia tao basan dadi neu malole. Hatahori mbakek bisa namanene. Hatahori nggoak bisa kokolak.” ");
INSERT INTO txq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Laꞌe esa boe ma hatahori noꞌuk ka mai rakabubua fo ramanene neu Yesus kokolan. Ara tungga Yesus fai telu ena, huu naa de ta ela nanaꞌak ena bali. Boe ma Yesus nanggou nala ana nunin nara, de nae, “Au ameda kasian neu hatahori noꞌuk kara iar. Hambu ketuk numa dae dook mai, ma ara rakabubua faik telu ena, losa ta ela nanaꞌak ena. Malole lenak kara boso fali reu sara ro poꞌo rouk dei. Boso losak, ara ndiꞌa nai dalak.” ");
INSERT INTO txq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesus ana nunin nara raselu rae, “Papa! Mamanak ia nees, ma dook ka numa nggorok mai. Ta bisa dadi ita tahao hatahori noꞌuk ka talo ia!” ");
INSERT INTO txq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tehuu Yesus natane sara nae, “Ei rotim mara hida de?” Ara raselu rae, “Papa. Ai mambeda kada roti hitu a.” ");
INSERT INTO txq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","De Yesus nadenu basa hatahori raa fo ranggatuuk reu daer. Boe ma Ana haꞌi nala roti kahituk kara raa, de noke makasi neu Manetulain. Basa boe ma Ana fifiꞌi baꞌe roti naa nenik liman, de fee sara neu ana nunin nara. Boe ma ara reu babaꞌe fee basa hatahorir raa. ");
INSERT INTO txq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ara oo raena iꞌak hida boe. De Yesus noke seluk makasi neu Manetualain soa-neu iꞌak kara raa. Boe ma Ana nadenu ana nunin nara reu babaꞌe fee hatahorir raa bali. ");
INSERT INTO txq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Basa sara nai rarain hambu hatahori rifun haa. Ara raꞌa losa rakabete. Raꞌa basa boe ma Yesus ana nunin nara reu raduduru nanaꞌa lenan nara, sofe lembaneu hitu. Basa boe ma Yesus nadenu basa sara fali reu sara. ");
INSERT INTO txq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Neu ara fali reu sara, boe ma Yesus no ana nunin nara hene reni ofak dale reu, fo reni mamanak esa reu, nade Dalmanuta. ");
INSERT INTO txq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Neu Yesus asa losa Dalmanuta, boe ma hambu hatahori hida numa partei anggama Farisi mai ratonggo ro Yesus. Ara rakaseseluk dedeꞌak ro Yesus fo rae ike rakatutudak kana. Ara roke Yesus rae, “Papa! Matudu tanda heran esa fo dadi neu bukti ae, Papa memak hambu koasa numa Manetualain mai.” ");
INSERT INTO txq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus leꞌa hahaen, de nae, “Mete ma Au amanene ei kokolak talo naa, na, Au fale daleng! Tao hata de ei moke tanda heran? Boso talo naa! Memak hambu tanda heran, tehuu Au ta tao fee ei.” ");
INSERT INTO txq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Basa boe ma Yesus laꞌo ela sara, de neu fo no ana nunin nara hene fali ofak dale reu. Boe ma ara laꞌo reni dano boboan seri reu. ");
INSERT INTO txq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Neu Yesus asa losa dano taladan, dei de ana nunin nara rasaneda sira lilii reni lepa-nggees. Ara reni kada roti esa. ");
INSERT INTO txq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus namanene nala ara kokolak laꞌe-neu roti, boe ma Ana nae, “Ei muste besa-besa! Boso tungga manek Herodes no hatahori Farisir leleꞌa-nonore manggaraun. Sira leleꞌa-nonore manggaraun naa, sama leo laru taꞌik fo hatahori paken tao kaifuu roti dadi namoꞌo.” ");
INSERT INTO txq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ana nunin nara ramanene rala Yesus kokolak talo naa, boe ma ara panggananaa. Boe ma ara rakokola aok rae, “Tou lasik kokolak hata naa? Fama te Ana kokolak talo naa, nahuu ita ta teni roti, do?” ");
INSERT INTO txq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tehuu Yesus bubuluk duduꞌan nara. De Ana nafada nae, “Tao hata de ei kokolak laꞌe-neu kada roti! Ei ta malela Au kokolan sosoa-ndandaan, do? Memak ei utem mara ta rakaminak, na! ");
INSERT INTO txq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ei mete-mita no ei mata deꞌe heli-helim mara ena, tehuu ei ta bubuluk sosoa-ndandaan! Nok bali ei pokek kara. Ei mamanene mala no ei ndiꞌi doo heli-helim mara, tehuu ta malela hata esa boe na. Nok bali ei mbakek kara. Ei lilii heni ");
INSERT INTO txq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","roti kalimak kara fo Au fifiꞌi baꞌe sara, de ahao hatahori rifun kalimak kara raa ena, do? Faik naa ei maduduru mala roti lenan nara lembaneu hida?” Ara raselu rae, “Lembaneu salahunu dua, Papa.” ");
INSERT INTO txq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus natane seluk bali nae, “Ei bei masaneda faik naa, Au fifiꞌi baꞌe roti kahituk fo ahao hatahori rifun kahaak kara raa, do? Ei maduduru mala lenan nara lembaneu hida?” Ara raselu rae, “Hitu, Papa!” ");
INSERT INTO txq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Boe ma Yesus nae, “Memak tebe! Ei mete-mita no ei mata ao heli-helim ena, tehuu hata de ei bei ta malela Au koasang numa bee mai?” ");
INSERT INTO txq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Basa boe ma Yesus asa laok losa nggorok Betsaida. Numa naa hatahorir ralalaꞌo ro hatahori pokek esa neni Yesus neu. Ara roke-hule neu Yesus fo nafaroe tao nahai hatahori pokek naa. ");
INSERT INTO txq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Boe ma Yesus toꞌu nala hatahori naa liman, de noon laꞌo neni nggorok dea neu. De Ana pura ambe neu hatahori naa matan, basa boe ma Ana nafaroe matan. Ana natane nae, “Talo bee? O bisa mete-mita ena, do?” ");
INSERT INTO txq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hatahori naa botik matan fo mete kii-konan, boe ma naselu nae, “Hou! Au mete-ita hatahori laꞌo-laꞌo. Tehuu nok bali au mete-ita ai huuk laꞌo-laꞌo ia!” ");
INSERT INTO txq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","De Yesus tao seluk liman neu hatahori naa matan bali. Boe ma hatahori naa soba mete seluk, medak neu te matan hai tebe-tebe ena. Hatematak ia ana mete-nita no manggaledok ena. ");
INSERT INTO txq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Boe ma Yesus nadenu hatahori naa fali neu ngga, ma Ana fee nesenedak neun nae, “O fali muu ngga leo, tehuu tungga dalak laen. Boso fali muni Betsaida muu bali.” ");
INSERT INTO txq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Basa boe ma Yesus no ana nunin nara laꞌok ndule nggorok kara marai Kaisarea Felipi. Yesus natane sara numa dalak nae, “Mete ma tungga hatahori tutuin, na, ara rae, Au ia see?” ");
INSERT INTO txq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ara raselu rae, “Hambu ketuk rae, ‘Yohanis Mana Saranik’. Hambu ketuk bali rae, ‘baꞌi Elia’, fo Manetualain mana toꞌu dedeꞌan lele uluk naa. Laen bali rae, Papa ia, Hatahori esa numa Manetualain mana toꞌu dedeꞌa laen nara numa lele uluk mai.” ");
INSERT INTO txq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Boe ma Yesus natane bali nae, “Tehuu ei mesa ngga mae, Au ia see?” Petrus naselu nae, “Papa ia, Karistus! Ndia Manetualain henggenee memak kana numa lele uluk mai ena.” ");
INSERT INTO txq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tehuu Yesus ndindia sara nae, “Ei boso mafada esa boe na, ee!” ");
INSERT INTO txq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Basa boe ma Yesus mulai nafada ana nunin nara nae, “Au ia, Hatahori Dae-bafo Isi-isik. Neu ko Au hambu doidosok noꞌuk ka, nahuu lasi-lasi hadak kara, malangga anggama malanggan nara, ma meser anggamar timba heni Au. Neu ko ara tao risa Au, tehuu ndaa no bei-nesan, Au asoda fali numa mamates mai.” ");
INSERT INTO txq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus nafada no manggaledon talo naa, boe ma Petrus leꞌa nala Yesus neni tataik neu, de ana kaꞌi Yesus nae, “Papa boso kokolak talo naa! Au ta mboꞌi sira liman dai Papa.” ");
INSERT INTO txq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tehuu Petrus kokolak talo naa, ta tungga Manetualain hihii-nanaun. Boe ma Yesus hekor fo mete neni ana nunin laen nara neu. De Ana nahara berak neu Petrus nae, “Hei! Naa, nitur malanggan kokolan naa! Malai heok ia! O duduꞌa tungga kada hatahori dae-bafok hihii-nanaun, te ta tungga Manetualain hihii-nanaun!” ");
INSERT INTO txq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Basa boe ma Yesus nanggou nala hatahori laen nara fo mai rakabua ro ana nunin nara. De ana nanori sara nae, “See ndia nau tungga Au, ana muste nakatataka nakandoo tungga-tungga faik. Ana muste lilii heni ndia hihii-nanaun heli-helin fo tungga kada Manetualain hihii-nanaun mesa kana. Leo mae hatahori rae tao risan, ana muste tungga nakandoo a mesan, sama leo hatahori lemba-nasaa ai ngganggen fo neu mate. ");
INSERT INTO txq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Hatahori mana nau nasoda soa-neu kada ndia ao heli-helin, neu ko masodan naa, sambu do lalo talo kada naa leo! Tehuu hatahori mana sadia mate nahuu ana tungga Au ma tui-bengga Manetualain Hara Lii Malolen, neu ko ana hambu masodak nakandoo no Manetualain. ");
INSERT INTO txq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nenene ee! Mete ma o hambu basa dae-bafok oe-isin, tehuu Manetualain timba heni o, na, nanalan hata? ");
INSERT INTO txq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Leo mae o lemba muni basa dae-bafok oe-isin oo, o ta bisa saiseluk kana neu o samanem boe! ");
INSERT INTO txq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Masanenedak, ee! Hatahori manai dae-bafok tanak ia tatao-nonoꞌi manggaraun nara mata-matak kara. Ara ta tao matak neu Manetualain. De see ndia mae tungga Au, do mae toꞌu Au nenoring, neu ko Au oo mae manakun nai Manetualain matan boe. Au, Hatahori Dae-bafo Isi-isik ia, neu ko Au fali mai numa nusa tetuk do inggu temak mai. Ma Manetualain atan nara ruma nusa tetuk do inggu temak mai oo, konda sama-sama ro Au boe. Ai konda numa nusa tetuk do inggu temak mai no Amak koasan ta neni babanggak, dei fo hatahori bubuluk Au ia see. ");
INSERT INTO txq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ei boso lilii-ndondou Au kokolan ia. Hambu ketuk numa ei marai iar, bei ta mate, losa neu ko mete-rita Manetualain toꞌu parenda no koasa ina-huuk.” ");
INSERT INTO txq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seli faik nee numa Yesus nafada laꞌe-neu mamaten ma nesoda falin numa mamates mai, boe ma Yesus noke no Petrus, Yakobis ma Yohanis, fo ara sama-sama reu hene lete demak esa fo ta hambu hatahori nai naa. Neu ara losa lain, de ara mete-rita Yesus mata-aon nasafali. ");
INSERT INTO txq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ma Ndia bualoꞌa-papaken dadi neu muti manggahadok. Nai dae-bafok ia, ta hambu hata esa muti manggahadon lena heni Yesus bualoꞌa-papaken naa. ");
INSERT INTO txq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Medak neu ma, ara mete-rita Yesus kola-kola no baꞌi Elia ma baꞌi Musa. ");
INSERT INTO txq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Petrus asa ramataꞌu ralan seli. Boe ma Petrus pangganaa, losa ana kokolak sadi ndaa. De ana nafada Yesus nae, “Papa! Ai mameda malole nai ia! Dadi malole lenak ai mambaririik laak telu. Esa soa-neu Papa, esa soa-neu baꞌi Musa, ma esa bali soa-neu baꞌi Elia.” ");
INSERT INTO txq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Basa boe ma sosoꞌak konda mai de tatana nala sara. Boe ma ara ramanene harak esa numa sosoꞌak naa mai nae, “Nenene, ee! Yesus ia, Au Ana susueng. Ei nenene matalolole neun leo!” ");
INSERT INTO txq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Neu Petrus asa ramanene rala harak naa, boe ma ara leleuk ndule basan, tehuu medak neu ma ara ta mete-rita hatahori laen bali. Kada Yesus mesa kana. ");
INSERT INTO txq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Basa boe ma Yesus no ana nunin nara konda numa letek naa mai. Yesus helu sara nae, “Hata fo ei mete-mitan bebeik kara ia, ei boso mafadan neu hatahori esa boe na. Au ia, Hatahori Dae-bafo Isi-isik. Au muste mate dei. Neu ko mete ma Au asoda fali numa mamates mai ena, na, dei fo ei bole mafada hatahori.” ");
INSERT INTO txq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ara toꞌu ratalolole Yesus hara hehelun naa, de ara ta rafada hatahori esa boe na. Tehuu telu sara mulai ratatane aok rae, “Ana kokolak nae, ‘Ana nasoda fali numa mamaten mai’, sosoan hata, ee? Talo bee, ee?” ");
INSERT INTO txq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Boe ma ara ratane Yesus rae, “Meser anggamar raa rae, ‘Baꞌi Elia muste mai nakahuluk, dei fo Karistus mai.’ Tehuu tungga Papa, na, talo bee?” ");
INSERT INTO txq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus naselu nae, “Memak tebe! Baꞌi Elia muste mai nakahuluk, fo nasosoi dalak soa-neu Karistus, Hatahori naa ndia Manetualain henggenee memak kana numa lele uluk mai ena. De talo bee? Ei bei ta malela hata fo ara surak kana ena nai Manetualain Susura Malalaon soa-neu Hatahori Dae-bafo Isi-isik naa, do? Ara surak memak kana ena rae, neu ko mete ma Ana mai ena, na, hatahori rakasususak kana, losa ara nau tao risan. ");
INSERT INTO txq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","De ei muste pasa ei ndiꞌi doom mara matalolole, ee! Baꞌi Elia naa memak mai ena. Tehuu hatahori rakasususak kana tungga sira hihiin. Naa oo, ndaa no hata fo baꞌir surak memak kana numa lele uluk mai ena boe.” ");
INSERT INTO txq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Neu Yesus no ana nunin kateluk kara raa ratonggo fali ro ana nunin laen, ara mete-rita hatahori noꞌuk ka rakabua. Hatahori noꞌuk kara raa mai, de ara mete-rita Yesus ana nunin laen rareresi ro meser anggamar. ");
INSERT INTO txq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Neu hatahori noꞌuk kara raa mete-rita Yesus, ara nggengger nahuu ara duꞌa rae, Ana bei nai letek lain. Boe ma ara ralaik reu ratonggo ro Yesus. ");
INSERT INTO txq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Boe ma Yesus natane sara nae, “Ei mareresi hata nai ia?” ");
INSERT INTO txq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Hambu hatahori esa mai, de nae, “Papa, nenene dei! Au uni au ana toung mai, fo Papa tao mahain dei. Nggoak, ta bisa kokolak nala, huu nitu saꞌen. ");
INSERT INTO txq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mete ma nitu naa masok ena, na, ana fae nggari kakana ia ao-inan neu daer. Boe ma bafan lua fufudek kara, ma ana henggu nisin. Ao-inan barakai ndoos leo ai tuuk ia. Au oke Papa ana nunin nara fo ara husi heni nitu naa. Tehuu ara ta bisa tao hata esa boe na.” ");
INSERT INTO txq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesus namanene nala naa, boe ma Ana mboka sara nae, “Weeh! Eir ia, sudi selik kana ena! Au anori ei laꞌi-laꞌik ka ena, tehuu ei ta malela Au nenoring no malole. Ma ei ta mamahere tebe-tebe neu Au! Au ahani ua ei losa faik hida bali? Mai fo mia kakanak naa ia mai!” ");
INSERT INTO txq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Boe ma ara koꞌo roo kakanak naa neni Yesus neu. Tehuu neu nitu mete-nita Yesus, boe ma ana fae nggari kakanak naa losa tuda loli-loli neu daer, ma bafan lua fufudek kara. ");
INSERT INTO txq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Basa boe ma Yesus natane kakanak naa aman nae, “O anan dadi talo ia, ndia bee ena?” Kakanak aman naselu nae, “Numa kadiꞌi anan mai. ");
INSERT INTO txq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nitu naa nau tao nisa kakanak ia dook ka ena. Ana tumbu piru au anang laꞌi-laꞌik ka neni aꞌi dale neu, ma ana nggarin neni oe dale neu losa nasamele. Dadi Papa tulun dei! Mete ma bisa, na, Papa kasian neu ai fo tao mahai kakanak ia dei.” ");
INSERT INTO txq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus naselu nae, “Tao hata de o mae, ‘mete ma bisa’? Memak Au bisa tao hata a mesan, sadi hatahori ramahere dei!” ");
INSERT INTO txq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Basa boe ma tou lasik naselu leo bali nae buꞌi ia, ma nae, “Papa! Memak au amahere ena. Tehuu tulun fo au nemehehereng boe natea bali!” ");
INSERT INTO txq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Faik naa, Yesus mete-nita hatahori noꞌuk ka mulai rakarumbu mai ruma naa. De Ana parenda nitu naa nae, “Weeh, nitu! O kalua numa kakanak ia mai leo, fo ana bisa namanene ma kokolak nala. O boso maso fali muni ndia neu bali!” ");
INSERT INTO txq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nitu namanene Yesus kokolak talo naa, boe ma ana kii-bolu nahere. Ana fae nggari kakanak naa neu daer, de leꞌa kede-kede, basa dei de ana kalua laꞌo elan. Boe ma kakanak naa ndiꞌa nok bali sangga mate ia ena. De hatahorir marai naa rae, “Naa! Maten ena!” ");
INSERT INTO txq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tehuu Yesus toꞌu nala kakanak naa liman de nambadedeik kana. Boe ma ana nambadeik tutik kana. ");
INSERT INTO txq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Basa boe ma Yesus no ana nunin nara laꞌo ela mamanak naa, fo ara maso reni uma esa dale reu. Numa naa, ana nunin nara ratane Yesus rae, “Papa! Tao hata de bebeik kara ia, ai ta bisa husi nitu naa?” ");
INSERT INTO txq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Boe ma Yesus nafada nae, “Nenene matalolole! Nitur memak manggarauk. Dadi mete ma ei ta hule-haradoi moke tutulu-fafalik numa Manetualain mai, na, ei ta bisa mabeꞌi husi nitur matak leo naak.” ");
INSERT INTO txq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Basa boe ma Yesus no ana nunin nara laꞌo ela mamanak naa, fo ara maso reni nusa Galilea reu. Faik naa, Yesus ta nau hatahorir bubuluk Ndia nai naa, ");
INSERT INTO txq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","huu Ana nau nanori kada Ndia ana nunin nara. Ana nafada sara nae, “Ta dook ka te ara rae seꞌo heni Au uni hatahori laen nara uu. Boe ma ara tao risa Au, Hatahori Dae-bafo Isi-isik ia. Memak Au mate, tehuu neu ko bei-nesan, Au asoda fali numa mamates mai.” ");
INSERT INTO txq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesus nafada talo naa, tehuu ana nunin nara panggananaa. Te ara ta rambarani ratane seluk Yesus kokolan naa sosoa-ndandaan hata. ");
INSERT INTO txq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Basa boe ma Yesus asa laꞌok losa Kapernaum. Neu ara maso reni uma dale reu, boe ma Yesus natane ana nunin nara nae, “Bebeik kara ia ei mareresi hata numa dalak naa?” ");
INSERT INTO txq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tehuu ta hambu esa nambarani naselu, nahuu neu ara bei laꞌok numa dalak, ara rareresi rae, see ndia moꞌon lenak numa sira basa sara mai. ");
INSERT INTO txq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Boe ma Yesus nanggatuuk fo nanori sara nae, “See ndia nau dadi hatahori moꞌo-inahuuk, na, leleo-lalaꞌon muste dadi tebe-tebe sama leo hatahori kadiꞌik fo naono-lalau basa hatahorir.” ");
INSERT INTO txq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Boe ma Yesus koꞌo nala kakana ana esa numa naa, de ana fali neni ana nunin nara taladan neu. De Ana kokolak nae, ");
INSERT INTO txq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“See nau tungga Au fo ana naono-lalau hatahori kadiꞌik sama leo kakanak ia, na, sosoa-ndandaan nae, hatahori naa naono-lalau Au boe. Ma ana oo naono-lalau Au Amang fo mana madenu Au uni dae-bafok ia mai.” ");
INSERT INTO txq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Basa boe ma Yesus ana nunin Yohanis kalaak nae, “Papa! Laꞌe esa ai mete-mita hatahori esa pake Papa naden fo ana husi nitu. De ai kaꞌin, nahuu ndia naa, ta ita hatahorin.” ");
INSERT INTO txq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tehuu Yesus naselu nae, “Weeh! Ei boso kaꞌin. Huu see ndia pake Au nadeng fo tao tanda heran, na, ana ta kokolak tao naboboo Au nadeng. ");
INSERT INTO txq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mete ma ana ta lena-laba ita, sosoa-ndandaan nae, ndia naa oo ita hatahorin boe. ");
INSERT INTO txq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Masaneda matalolole! Mete ma hambu hatahori bubuluk nae, ei tungga Karistus, boe ma ana tulu-fali ei, na, neu ko Manetualain ta lilii heni hatahori naa sosota-mamanggun. Leo mae ana fee ei minu kada oe hiek nggalaas esa oo, Manetualain ta lilii hatahori naa boe.” ");
INSERT INTO txq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Basa boe ma Yesus nafada sara bali nae, “Mete ma hambu hatahori tao kakana ana esa leo-laꞌo tao salak, losa kakanak naa ta namehere neu Au bali, na, besa-besa, ee! Malole lenak haꞌi batu moꞌok esa, fuli neu hatahori naa boliin, fo feen tena neni tasi demak dale neu. ");
INSERT INTO txq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mete ma o tao salak munik o limam, na, tete henin leo! Malole lenak o maso nusa tetuk do inggu temak muu, muni kada lima seserik lena heni ara nggari o muni aꞌi mbila ta kala matek muu, muni o limam dua sara. ");
INSERT INTO txq_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Aꞌi mbila ta kala matek naa, memak mamana doidosok. Ulek kara marai naa ta hahae tao kaboo mburuk. ");
INSERT INTO txq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mete ma o tao salak munik o eim, na, tete henin leo! Malole lenak o maso nusa tetuk do inggu temak muu, muni kada ei seserik lena heni ara nggari o muni aꞌi mbila ta kala matek muu, muni o eim dua sara. ");
INSERT INTO txq_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Aꞌi mbila ta kala matek naa, memak mamana doidosok. Ulek kara marai naa ta hahae tao kaboo mburuk. ");
INSERT INTO txq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mete ma o tao salak munik o matam, na, edo henin leo! Malole lenak o maso nusa tetuk do inggu temak muu, muni kada mata seserik lena heni ara nggari o muni aꞌi mbila ta kala matek muu, muni o matam dua sara. ");
INSERT INTO txq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Aꞌi mbila ta kala matek naa, memak mamana doidosok. Ulek kara marai naa ta hahae tao kaboo mburuk.’ ");
INSERT INTO txq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Au nenoring ia, memak berak ka. De see ndia nau tungga Au, na, ana muste nakatataka tungga nakandoo, sama leo mbaa fo hatahori mamasin, ma ara seꞌin neu aꞌi, mita fo mbaa naa nakai nala dook ka. ");
INSERT INTO txq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Masik naa, malole. Ita paken fo tao nalada nanaꞌak kara. Tehuu mete ma masik naa mami ena, na, nenenin hata bali? Ita nggari henin leo. Ei oo muste dadi sama leo masik boe, fo leo-laꞌo no masue-laik mia basa hatahori lalaꞌen. De ei hahae mareresi bali mae, see ndia hatahori moꞌo-inahuuk, do see ndia kadiꞌik!” ");
INSERT INTO txq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Basa boe ma Yesus asa reni profensi Yudea reu, ma mamanak laen manai lee Yarden boboan dulu. Yesus nai mamanak bee a mesan, hatahori noꞌuk kara mai rakarumbu ralan. De Yesus nanori sara sama leo nasiꞌen. ");
INSERT INTO txq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hambu hatahori Farisi hida mai fo rae tao rakatudak kana. Ara ratanen rae, “Tungga ita anggaman hohoro-lalanen, mete ma touk esa sao ena, na, ana bole namaketu no saon, do taa?” ");
INSERT INTO txq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus naselu nae, “Masaneda dei! Hohoro-lalanek laꞌe-neu sao holu-ndaek fo baꞌi Musa tao elan fee ita nae leo bee?” ");
INSERT INTO txq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ara raselu rae, “Baꞌi Musa hohoro-lalanen nae, hatahorir bole ramaketu, sadi fee susura nemeketuk neu sao inan dei.” ");
INSERT INTO txq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus bala nae, “Weeh! Nenene, ee! Huu ei langga batum mara dei, de baꞌi Musa surak talo naa! ");
INSERT INTO txq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Boso lilii-ndondou tutui makasososak, neu lelek Manetulain adu lalai no dae-inak! Neni surak nae, ‘Manetualain adu hatahori dae-bafok, touk no inak. ");
INSERT INTO txq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Huu naa de touk muste laꞌo ela ndia inan ma aman, fo neu leo-laꞌo dalek esa no saon ");
INSERT INTO txq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","huu dua sara dadi reu esa ena.’ ");
INSERT INTO txq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mete ma Manetualain mesa kana ndia adu nala dua sara dadi reu esa ena, na, hatahori dae-bafok boso mabingga-baꞌe sara bali!” ");
INSERT INTO txq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Basa boe ma Yesus no kada ana nunin nara maso reni uma esa dale reu. Numa naa, ara ratane Yesus nenorin bebeik kara ia. ");
INSERT INTO txq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus naselu nae, “See ndia namaketu no sao inan, de ana sao seluk, na, ana hohongge-lelena naa ena! ");
INSERT INTO txq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Sao inak oo leo naak boe! Mete ma ana namaketu no saon, de ana sao seluk, na, ana oo hohongge-lelena naa boe!” ");
INSERT INTO txq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Faik esa, hambu hatahorir roo sira anan nara reni Yesus reu, fo roke-hule Ana ndae liman ma kokolak fee babaꞌe-babatik neu sara. Tehuu Yesus ana nunin nara rahara berak reu hatahorir raa. ");
INSERT INTO txq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus mete-nita talo naa, boe ma Ana namanasa ana nunin nara nae, “Ela kakana anar raa reni Au mai! Boso mamanggengge sara! Huu hatahori mana sama leo kakana anar iar, ndia Manetualain hatahorin. ");
INSERT INTO txq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ei masaneda matalolole! See ndia nau mai nasare Manetualain, na, muste dalen hii nalan seli neun, sama leo kakana anar dalen nara hii ralan seli neu sira inan ma aman. Mete ma ta leo naak, na, ara ta randaa dadi reu Manetualain hatahorin.” ");
INSERT INTO txq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Basa boe ma Yesus holu nala kakana anar raa, ma Ana ndae liman neu esa-esak langgan, de Ana fee babaꞌe-babatik neu sara. ");
INSERT INTO txq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Neu Yesus asa sangga laꞌo, boe ma hatahori kamasuꞌik esa nalaik mai fo nae natonggo no Yesus. Ana sendek luu-langgan nai Yesus matan, de natane nae, “Papa Meser mana hambu hada-horomatak. Au ae atane baꞌu anak. Talo ia Papa. Au muste tao talo bee fo au bubuluk no tetuk ae, au bisa maso nusa tetuk do inggu temak fo au asoda akandoo ua Manetualain?” ");
INSERT INTO txq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus naselu nae, “Tao hata de o moke Au mae ‘mana hambu hada-horomatak’? Ta hambu hatahori esa boe na mana hambu hada-horomatak, kada Manetualain mesa kana. ");
INSERT INTO txq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","O bubuluk Manetualain parendan numa lele uluk mai ena nae, ‘Boso makanisa hatahori; Boso hohongge-lelena; Boso mamanaꞌo; Boso dadi sakasii pepeko-lelekok; Boso pakanaꞌe mala hatahori hatan; Ma fee hada-horomatak neu o inam ma o amam.’ ” ");
INSERT INTO txq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hatahori naa naselu nae, “Tebe, Papa Meser! Mulai numa muri-sorung mai, au tungga basa parenda raa ena.” ");
INSERT INTO txq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus dalen kasian neu hatahori naa. Boe ma Ana nae, “Tebe! Tehuu bei ela matak esa bali. Hatematak ia o fali muu ngga leo fo seꞌo heni basa o hata-hetom lalaꞌen. Doin nara, o muu babaꞌe fee neu hatahori mana susak kara. Basa naa, o fali mai fo tungga Au leo. Dei fo Manetualain bala fee o hata-heto manahetak nai nusa tetuk do inggu temak.” ");
INSERT INTO txq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hatahori naa namanene nala Yesus kokolan talo naa, boe ma dalen nakalulutu. De ana fali neu ngga no dalen susa nalan seli, nahuu suꞌin noꞌun seli. ");
INSERT INTO txq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Boe ma Yesus mete neu-mai, de kokolak neu ana nunin nara nae, “Nenene, ee! Hatahori kamasuꞌik memak susa laꞌe esak kana maso nusa tetuk do inggu temak!” ");
INSERT INTO txq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ana nunin nara ramanene rala Yesus kokolak talo naa, boe ma ara panggananaa. Boe ma Yesus kokolak seluk bali nae, “Nenene matalolole! Memak manggataꞌan seli, mete ma nau dadi neu Manetualain hatahorin. Boso duduꞌa mae, muda hiek. ");
INSERT INTO txq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Hatahori kamasuꞌik maso nusa tetuk do inggu temak fo dadi neu Manetualain hatahorin, naa manggataꞌan sama leo banda onta moꞌok esa maso neni lalaen neu nesik ndandauk bolon.” ");
INSERT INTO txq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesus kokolan naa, tao nala basa sara boe panggananaa. Boe ma ara ratatane aok rae, “Mete ma tebe leo naak, na, see ndia bisa hambu nala masoi-masodak, ee?” ");
INSERT INTO txq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus mete sara esa-esak, boe ma Ana nae, “Soa-neu hatahori dae-bafok memak ta bisa dadi. Tehuu boso lilii-ndondou: soa-neu Manetualain basan bisa dadi!” ");
INSERT INTO txq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Basa boe ma Petrus soꞌuk kokolak nae, “Papa. Ai laꞌo ela basa ai hata-heton lalaꞌen, fo tungga Papa. Tehuu ai hambu hata?” ");
INSERT INTO txq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesus nae, “Au nau afada ei ae leo ia: hatahori mana tungga Au, fo laꞌo ela ndia ina-aman, kaꞌa-fadin, anan nara, osi-lutun, ue-osan, ma basa uma oe-isin lalaꞌen, fo neu tui-bengga Manetualain Hara Lii Malolen sudi nai bee, neu ko ana simbo falik losa lipa laꞌe natun esa. Basa hata fo ana laꞌo elak kara raa, neu ko ana simbo falik manahetak. Ma neu ko ana oo hambu tuni-ndenik, nahuu ana tungga Au. Tehuu neu dae-bafok fai mateꞌen, neu ko ana nasoda nakandoo no Manetualain. Naa, babalan ndian ena. ");
INSERT INTO txq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Masaneda, ee! Hatahori fo mana tao aon leo hatahori moꞌo-inahuuk, tungga Manetualain duduꞌan, neu ko ana dadi neu hatahori kadiꞌin lenak. Tehuu hatahori fo mana tao aon leo hatahori kadiꞌik, tungga Manetualain duduꞌan, neu ko ana dadi neu hatahori moꞌo-inahuuk.” ");
INSERT INTO txq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Faik naa, Yesus asa laꞌo reni Yerusalem reu, Ana nesik mata. Ndia ana nuni kasalahunu duan nara ro hatahori laen nara laꞌok tunggan. Ara bei rasaneda Ndia kokolan fai maneuk kara nae, hatahori nae tao nisan nai Yerusalem. De ara pangganaa ma ramataꞌu. Yesus namanene nala naa, boe ma Ana nanggou nala ana nunin nara mesa kasa, de nafada seluk bali hata fo hatahori nae tao neun nai Yerusalem. ");
INSERT INTO txq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ana nafada nae, “Ei nenene, ee! Hatematak ia ita teni Yerusalem teu. Au ia, Hatahori Dae-bafo Isi-isik. Tehuu nai naa ara seꞌo heni Au, neu malangga anggama malanggan nara ma meser anggamar. Basa de ara raketu hukun mates neu Au. Boe ma ara fee heni Au uni hatahori laen fo ta mana malela Manetualain uu. ");
INSERT INTO txq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Boe ma ara rakamamaek Au. Ara pura ambe neu Au. Ara poko-femba rakalulutu Au ao-mbaang. Basa dei fo ara tao risa Au. Memak Au mate tetebes. Tehuu neu bei-nesan, Au asoda fali numa mamates mai.” ");
INSERT INTO txq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Basa boe ma, Yakobis ma Yohanis, ndia Sabadeus anan nara reni Yesus reu. Ara rafada rae, “Papa Meser! Ai parluu Papa.” ");
INSERT INTO txq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus natane sara nae, “Ei parluu hata?” ");
INSERT INTO txq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ara raselu rae, “Talo ia, Papa! Neu ko mete ma Papa nangggatuuk toꞌu parenda ena, na, ai moke-hule Papa fo fee ai kadera nenggetuuk, esa neu Papa boboa konan, ma esa neu Papa boboa kiin, fo ai oo toꞌu parenda boe.” ");
INSERT INTO txq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus naselu nae, “Ei dua ngga ia ta bubuluk hata fo ei mokek. Au ia, neu ko hambu doidosok noꞌuk ka. De talo bee? Ei duꞌa mae, ei oo bisa mabeꞌi lemba-masaa doidosok naa sama-sama mia Au losa mate boe, do?” ");
INSERT INTO txq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ara raselu rae, “Ai bisa, Papa!” Yesus bala sara bali nae, “Memak, neu ko ei oo lemba-masaa doidosok naa sama leo Au boe. ");
INSERT INTO txq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tehuu see ndia nanggatuuk nai Au boboa kiin do Au boboa konan, Au ta ndia aketu naa. Manetualain ndia naena haak fo naketu. Ana naketu memak ena, see ndia nanggatuuk nai mamanak naa.” ");
INSERT INTO txq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Neu ana nuni laen nara ramanene rala Yakobis no Yohanis roke talo naa, boe ma ara ramanasa. ");
INSERT INTO txq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Basa boe ma Yesus nanggou nala basa sara, de Ana nae, “Talo ia! Ei bubuluk ena, hetu? Hatahori moꞌo-inahuuk fo mana toꞌu parenda nasiꞌe tuni-ndeni rau-inggun nara, losa ara ta bisa rakaundak rala. Ma malangga nusak kara fo ta mana malela Manetualain, ara fee parenda lena-lenak, losa rau-inggun nara ta bisa botik rala langgan nara. ");
INSERT INTO txq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tehuu ei ta bole tao talo naa! See numa ei mai nau dadi neu hatahori moꞌo-inahuuk, na, ana muste dadi sama leo hatahori neondak fo naono-lalau hatahori laen. ");
INSERT INTO txq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma see ndia nau dadi neu malanggan, na, ana muste tao aon leo ata-dato. ");
INSERT INTO txq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Au, Hatahori Dae-bafo Isi-isik ia ta mai fo hatahorir raono-lalau Au. Tehuu Au mai fo aono-lalau hatahori noꞌuk ka. Au mai fo fee Au sodang katematuan, fo tefa-soi ala hatahori noꞌuk ruma sala-singgon nara mai.” ");
INSERT INTO txq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus no ana nunin nara ma hatahori noꞌun seli losa kota Yeriko. Neu ara rae laꞌo rakandoo, te hatahori pokek esa nanggatuuk fo hule-hule numa dalak tatain. Naden Bartimeos, ndia papa Timeos anan. ");
INSERT INTO txq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Neu ana namanene nae, mana laꞌok nesik naa, ndia Yesus numa Nasaret mai, boe ma ana bolu nahere nae, “Yesus, Dauk tititi-nonosin, ee! Ai mahani a neu Papa dook ka ena. Kasian neu au dei!” ");
INSERT INTO txq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hatahorir ramanene ana bolu talo naa, boe ma ara kaꞌin rae, “Weeh! Nenee!” Tehuu ana boe kii-bolu nahere nae, “Yesus! Dauk tititi-nonosin, ee! Kasian neu au dei!” ");
INSERT INTO txq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Boe ma Yesus nambarii taak, de nae, “Mian mai dei!” Boe ma ara reu, de rafadan rae, “O nenee leo! Papa Meser noke o. Mai leo!” ");
INSERT INTO txq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeos namanene talo naa, boe ma ana piru heni lafan, de nambadeik lai-laik neu natonggo no Yesus. ");
INSERT INTO txq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus natane nae, “O hii hata?” Hatahori pokek naa naselu nae, “Papa, ee! Au oke-hule fo au bisa mete-ita.” ");
INSERT INTO txq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus nafada seluk kana bali nae, “Huu o mamahere mae, Au bisa tao ahai o, de hatematak ia o hai ena. Muu leo!” Boe ma Bartimeos matan mete-nita tutik kana leo. Basa boe ma ana laꞌo tungga neu nafuli Yesus. ");
INSERT INTO txq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Neu ara sangga deka kota Yerusalem, boe ma ara losa nggorok dua, ndia Betfage ma Betania, rai letek Setun tatain. Numa naa, Yesus asa hahae taak. Boe ma Ana nadenu ana nunin dua laꞌo rakahuluk. ");
INSERT INTO txq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ana helu sara nae, “Ei dua ngga makahuluk, meni nggorok naa miu. Mete ma ei maso, neu ko ei mete-mita banda keledei esa anan neni paꞌak nai naa. Hatahorir bei ta saꞌe ritan. Miu sefi heni talin fo leꞌa menin ia mai. ");
INSERT INTO txq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tehuu mete ma hambu hatahori natane ei nae, ‘Tao hata de ei sefi meni keledei naa?’ Na, ei maselun mae, ‘Ai Lamatuan nae paken. Mete ma Ana pake basa, neu ko Ana haitua fali memak kana.’ ” ");
INSERT INTO txq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Boe ma hatahori kaduak kara raa reu, de mete-rita keledei naa anan neni paꞌak nai uma esa bebelan, nai dalak tatain. Boe ma ara sefi heni talin, de leꞌa renin. ");
INSERT INTO txq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tehuu hatahorir fo mana rambariik ruma naa ratane rae, “Weeh! Tao hata de ei sefi meni hatahori keledein?” ");
INSERT INTO txq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Boe ma ara raselu rae, “Ai Lamatuan nae paken. Mete ma Ana pake basa, neu ko ai meni fali memak kana!” Boe ma hatahorir raa ela sara leꞌa reni keledei naa. ");
INSERT INTO txq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ara leꞌa renin neni Yesus neu. Boe ma ara bela lafan nara neu keledei naa lain, de Yesus saꞌen. ");
INSERT INTO txq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Neu ara sangga maso kota dale reu, boe ma hambu hatahori noꞌuk ka haꞌi rala lafan nara ma ndae arun nara, de ara tao sara reu dalak lain. Hambu ketuk reu tati rala mbua sina doon nara numa dalak tatain fo ara nggenggela sara reu dalak taladan. No dalak naa, ara tao tanda rae, sira soru Lamatuak Yesus no hada-horomatak. Sama leo ara rasiꞌe soru hatahori moꞌo-inahuuk kara. ");
INSERT INTO txq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Boe ma hambu hatahori ketuk laꞌok rakahuluk resik Yesus matan, ma ketuk laꞌok tungga dean. Ara mulai eki rae, “Hosana! Ita koa-kio Manetualain! Manetualain fee babaꞌe-babatik neu hatahori fo ana mai pake Manetualain naden, huu Manetualain nadenun mai ena! ");
INSERT INTO txq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hosana! Ita koa-kio Manetualain! Huu Manetualain nae nambadedeik falik mane Dauk parendan! Hosana! Ita koa-kio Manetualain! Huu Manetualain nanggatuuk toꞌu parenda ena nai lalai fo demak mateꞌen!” ");
INSERT INTO txq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesus asa losa kota dale, boe ma ara maso reni Manetualain Uma Huhule-haradoi Ina-huun bebelan reu. Boe ma Yesus mete natalolole ndule basa uma naa nanalan. Tehuu sangga makiuk ena, de ara fali reni nggoro Betania reu. ");
INSERT INTO txq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Neu beꞌe-mai huhua anan, boe ma ara kalua numa Betania mai, de ara maso fali reni kota Yerusalem reu. Tehuu neu ara bei laꞌok numa dalak, boe ma Yesus nameda ndoe. ");
INSERT INTO txq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ana mete-nita ai huuk esa numa dalak tatain. Hatahorir rasiꞌe raꞌa boan. De Yesus laꞌok deka-deka neni ai huuk naa neu fo nae mete sudik kaboak, do taa. Neu Ana losa ai huuk naa, Ana ta mete-nita boak esa boe na, Ana mete-nita kada ai huuk naa doon. Huu memak fai neboan bei ta losa. ");
INSERT INTO txq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Boe ma Yesus parenda ai huuk naa nae, “Huu o ta bisa fee o boan mai Au, de mulai numa hatematak ia neu o ta bisa fee o boan neu hatahori laen ena!” Ana nunin nara ramanene, Ana nahara berak talo naa. ");
INSERT INTO txq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Basa boe ma ara laꞌok rakandoo losa Yerusalem, de Yesus maso seluk neni Manetualain Uma Huhule-haradoi Ina-huun neu. Numa Uma Huhule-haradoi Ina-huuk naa bebelan, hatahori taon dadi neu pasar, fo ara raseseꞌo mbui lunda sinar, ndia hatahori paken dadi neu tunu-hotuk soa-neu hule-haradoik. Yesus mete-nita talo naa, boe ma Ana neu husi-mbuu kalua heni sara. Ana fae nggari heni basa meir fo ara pake tuka doik, ma fae nalengga heni basa banggur fo ara pake raseseꞌo mbuik kara. ");
INSERT INTO txq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Boe ma Ana kaꞌi-ore basa hatohori fo ta bole reni bua-baꞌun nara fo laꞌok tepa tungga Uma naa bebelan bali. ");
INSERT INTO txq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Boe ma Ana nanori sara nae, “Ei bubuluk memak ena hata fo Manetualain mana toꞌu dedeꞌan nara surak ena rae, ‘Au ambadedeik Au Umang ia fo basa hatahori nusa-nusak kara mai hule-haradoi nai ia.’ Tehuu ei tao Uma ia dadi neu naꞌo manu-meor mamana nekebuan!” ");
INSERT INTO txq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Neu malangga anggama Yahudir malanggan nara ma meser anggamar ramanene Yesus tao talo naa ena, boe ma ara rasakele neun. De ara mulai sangga dalak fo rae tao risan. Tehuu ara oo ramahia boe, nahuu hatahori noꞌuk ka hii ralan seli neu Ndia nenorin. ");
INSERT INTO txq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Neu ledo mulai tesa ena, boe ma Yesus asa kalua numa kota Yerusalem mai, fo fali reu sunggu nai nggorok Betania. ");
INSERT INTO txq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Neu beꞌe-mai huhua anan, boe ma ara fali reni Yerusalem reu bali. Neu ara bei laꞌok numa dalak, ara resik ai huuk naa, fo afik ka Yesus kokolak neun. Ana nunin nara heran bali-bali, nahuu ai huuk naa mate namatuu losa okan nara ena. Boe ma Petrus nasaneda Yesus kokolan afik ka naa. Basa boe ma ana nafada nae, “Papa! Mete sudik! Ai huuk naa fo afik ka Papa nakatoon naa, maten ena!” ");
INSERT INTO txq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Boe ma Yesus naselu nae, “Memak tetebes! Sadi ei oo mamahere tebe-tebe neu Manetualain leo naak boe. ");
INSERT INTO txq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mete ma ei mamahere tebe-tebe, na, ei bisa madenu letek esa fo lali neni tasi neu. Dei fo Manetualain lali heni letek naa, sadi ei nemeheherem boso bibiak! Ei muste mamahere tebe-tebe neu Manetualain. ");
INSERT INTO txq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Boso lilii-ndondou, ee! Sadi ei mamahere tebe-tebe mae, Manetualain bisa nabeꞌi fee hata fo ei mokek, neu ko Ana taon fee ei! ");
INSERT INTO txq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tehuu mete ma hambu hatahori esa hule-haradoi, naa te dalen ta neulauk no hatahori laen, na, ana muste malole fali no hatahori naa dei. Talo naa dei fo ei Amam manai nusa tetuk do inggu temak, koka heni ei sala-singgom. ");
INSERT INTO txq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mete ma hambu numa ei mai bei nambeda dalek, ma ta nau fee ambon neu hatahori, neu ko ei Amam manai nusa tetuk do inggu temak oo ta nau lilii heni ei sala-singgom mara boe.” ");
INSERT INTO txq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Basa boe ma ara laꞌo rakandoo. Losa Yerusalem, boe ma ara maso reni Manetualain Uma Huhule-haradoi Ina-huun reu bali. Neu ara maso losa Uma bebelan, boe ma malangga anggama Yahudi malanggan nara, meser anggamar, ma lasi-lasi hadak Yahudir mai, ");
INSERT INTO txq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","fo ratane Yesus rae, “See ndia nadenu O mai tao nemuek numa ia ndia afik ka? See ndia fee O haak?” ");
INSERT INTO txq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tehuu Yesus bubuluk ara sangga dalak fo rae rakatutudak Ndia. Boe ma Ana bala nae, “Au oo ae atane ei boe. Ei maselu Au dei, dei fo Au aselu ei. ");
INSERT INTO txq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Au ae atane talo ia: ei basa ngga malela Yohanis, Mana Saranik naa, hetu? See ndia feen haak fo ana sarani hatahorir? Manetualain, do hatahori dae-bafok?” ");
INSERT INTO txq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Boe ma ara duduꞌa reu-mai, ma rakokola aok rae, “Awii! Ikek nala ita ia ena, ma! Huu mete ma ita taselu tae, ‘Manetualain ndia feen haak’, neu ko Ana bala nae, ‘Mete ma talo naa, tao hata de ei ta mamahere Yohanis?’ ");
INSERT INTO txq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma ita oo ta bisa tae, ‘Hatahori dae-bafok ndia nadenun.’ Neu ko basa hatahori ramue, nahuu ara ramahere rae, Yohanis naa, Manetualain mana toꞌu dedeꞌan.” ");
INSERT INTO txq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","De ara raselu rae, “Ai ta bubuluk!” Boe ma Yesus naselu seluk bali nae, “Mete ma talo naa, na, Au oo ta nau afada boe ae, see ndia nadenu Au.” ");
INSERT INTO txq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Basa boe ma Yesus nafada seluk bali neu malangga anggama Yahudi malanggan nara, meser anggamar, ma lasi-lasi hadak Yahudir. Ana pake lololek nae, “Hatahori esa neu tao osi neu daen faa, fo sangga sele ai anggor. Basa de ana mbaꞌa eko-feon. Ma ana tao baak fo nae natanee anggor oen. Ana oo nambaririik mamana nenea demak esa boe. Basa de ana fee osi naa neu hatahori laen fo ara raue ma rabaꞌe buna-boan nara roon. Boe ma ana laꞌo neni nusa feꞌek neu. ");
INSERT INTO txq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Losa fai ketu anggor boan, boe ma tenu daek naa nadenu ndia hatahori mana maue-osan esa neni hatahori mana maue osir raa neu, fo noke ndia babaꞌen. ");
INSERT INTO txq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tehuu neu ana losa, mana maue osir raa humu ralan, de ara popokon. Boe ma ara radenun fali no lima rouk. ");
INSERT INTO txq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Basa boe ma tenu daek nadenu ndia hatahori mana maue-osan esa bali. Tehuu mana maue osir raa popoko hatahori naa langgan losa hinak kara. Boe ma ara rakamamaek kana ma ara husi henin. ");
INSERT INTO txq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Boe ma tenu daek naa nadenu seluk ndia hatahori mana maue-osan laen bali. Tehuu ara hala risan. Leo mae ara tao talo bee oo, tenu daek naa kada nadenu ndia hatahori mana maue-osan neu nakandoo boe. Tehuu mana maue osir raa popoko ketuk, ma hala risa ketuk. ");
INSERT INTO txq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hatematak ia ela kada hatahori esa, ndia tenu daek ana tou kisen, fo ana susuen mateꞌen. Huu ana ta hambu dalak seluk ena, de nadenu kada kanak naa neu. Ana duꞌa nae, ‘Mete ma au adenu au ana heli-heling ndia neu, neu ko ara simbon no malole, ma ara ramanene neun.’ ");
INSERT INTO txq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","De ana nadenu anan neu. Tehuu mana maue osir raa mete-rita kanak naa mai, boe ma ara rakokola aok rae, ‘Woi! Ei mete dei! Tou lasik nadenu ana heli-helin mai ena! Mete ma tou lasik maten, na, kanak ia ndia simbo nala basa pusakar raa lalaꞌen. Mai fo ita hala tisan, mita fo ita laꞌe tala ndia pusakan ia.’ ");
INSERT INTO txq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Boe ma ara rame-rame humu ralan, de ara hala risan. Basa naa ara koꞌo rala ao-mbaa mamaten, de ara nggarin neni osi dea neu. Lololek ia losa kada naa.” ");
INSERT INTO txq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Basa boe ma Yesus natane hatahori moꞌo-inahuuk kara nae, “Tungga ei hahambum mara, na, tenu daek tao mana maue osir raa talo bee? Tungga Au, na, neu ko tenu daek mai fo hala nisa basa mana maue osir raa. Basa naa, ana fee osi naa neu hatahori laen fo naue ma rabaꞌe buna-boan. ");
INSERT INTO txq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ita basa ngga lees tita Manetualain Susura Malalaon ena nae, ‘Hambu batu esa tukan nara nggari henin ena. Tehuu hatematak ia, batu naa dadi neu batu netehuuk ena. ");
INSERT INTO txq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Manetualain mesa kana ndia here nalan, de nanggatutuuk batu naa. Huu naa de ita mete-titan lolen seli!’ ” ");
INSERT INTO txq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hatahori moꞌo-inahuuk kara raa ralela ralak kana rae, Yesus pake lololek naa ndee laꞌe sira. Ara tetuk sama leo mana maue osir bebeik kara raa. Basa boe ma ara mulai sangga dalak fo rae humu Yesus. Tehuu ara ramahia hatahori noꞌuk kara fo mana hii Yesus nenorin. De ara laꞌo ela Yesus leo. ");
INSERT INTO txq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Basa boe ma hatahori Yahudir moꞌo-inahuun nara radenu hatahori Farisi hida ro Herodes partein hatahorin hida bali reu rakaseseluk dedeꞌak ro Yesus fo ara rae iken. ");
INSERT INTO txq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ara mai de rakaseseluk dedeꞌak ro Yesus rae, “Papa Meser! Ai basa ngga bubuluk Papa dalen ndoos, ma ta mana nalela pepeke-lelekok. Papa kada mete hatahori dalen. Papa oo nafada Manetualain hihii-nanaun no manggaledok boe, nahuu Papa ta mana mete matak. De hatematak ia, ai nau matane dedeꞌak esa. Tungga ita anggama Yahudi hohoro-lalanen, ndondoon naa ita bae bea neu man-parenda Roma mane ina-huun, do taa?” ");
INSERT INTO txq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tehuu Yesus bubuluk nae, ara rae ike Ndia naa ena fo Ndia kokolak laban man-parenda Roma. Boe ma Yesus naselu no nahere haran nae, “Tao hata de ei nau ike Au no dedeꞌak naa! Matudu sudik Au doi fulak esa dei!” ");
INSERT INTO txq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Boe ma ara loo fee Yesus doi fulak esa. Yesus haꞌi nalan, de ana namumulan. Basa boe ma Ana natane sara nae, “Nggambar ia, see matan? Ma ia see naden?” Boe ma ara raselu rae, “Naa, man-parenda Roma mane ina-huun!” ");
INSERT INTO txq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Boe ma Yesus nae, “Mete ma leo naa, na, ei miu fee man-parenda hata fo man-parenda haak. Ma fee Manetualain hata fo Manetualain haak.” Ara ramanene rala Yesus naselu talo naa, boe ma basa sara heran bali-bali, huu Ana nafada ndaa, na. Huu naa de ara ta bisa ike rala sana. ");
INSERT INTO txq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hambu partei anggama laen esa, fo hatahorir roken rae, partei Saduki. Ara fee nenorik rae, hatahori mates ta bisa nasoda fali numa mamaten mai. Laꞌe esa, hambu hatahori Saduki hida oo, mai fo rae ike Yesus boe. Ara kokolak ro Yesus rae, ");
INSERT INTO txq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Papa Meser! Baꞌi Musa surak ela fee ita dala-hadak ia nae: Mete ma touk esa mate laꞌo ela saon, ma anak taa, na, touk naa fadin muste sao nala ina falu naa, mita fo ana fee tititi-nonosik soa-neu kaꞌan mana matek naa ena. ");
INSERT INTO txq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Memak Musa fee nenorik talo naa. Tehuu ai nau matane talo ia: hambu touk hitu kaꞌa-fadik kara. Uluk sao nakahuluk, boe ma maten, tehuu anak taa. ");
INSERT INTO txq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Boe ma fadik mana tunggan, sao nasafali ina falu naa. Ta dook ka, ana oo mate boe, ma anak taa. Leo naak oo no fadik katelun boe. Ana sao nala ina falu naa, tehuu ana mate, ma anak taa. ");
INSERT INTO txq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Talo naa nakandoo losa fadi muri anak oo, maten boe. Basa boe ma ina falu naa maten. ");
INSERT INTO txq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dadi hatematak ia, ai nau matane talo ia: inak naa sao nita no touk hitu ena. Neu ko neu dae-bafok fai mateꞌen, Manetualain nasoda falik hatahori mates sara, inak naa dadi neu see saon numa touk kahituk kara mai, ou?” ");
INSERT INTO txq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Boe ma Yesus naselu nae, “Mete ma ei matane talo naa, sosoan-ndandaan nae, ei ta malela tebe-tebe Manetualain Susura Malalaon isin. Ma ei oo ta malela Manetualain koasan boe. Dadi eir ia sala tebe-tebe ena! ");
INSERT INTO txq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nenene, ee! Talo ia: ta hambu dedeꞌa sasaok nai nusa tetuk do inggu temak. Basa hatahori mates lalaꞌen fo Manetualain tao nasoda falik kasa, ta hambu esa sao bali. Leo naak oo, Manetualain atan nara marai nusa tetuk do inggu temak ta sao boe. ");
INSERT INTO txq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma Au oo nau kokolak laꞌe-neu hatahori mates bisa nasoda fali numa mamaten mai, do taa boe. Baꞌi Musa surak laꞌe-neu ai huu anak fo aꞌi naꞌan, tehuu ta kade sana. Ei masaneda tutuik naa, do taa? Neu aꞌi mbila numa ai huuk naa, Manetualain nafada baꞌi Musa nae, ‘Au ia, Manetualain numa o baꞌim mara mai, sira baꞌi Abraham, baꞌi Isak, ma baꞌi Yakob. Basa sara rakaluku-rakatele rakandoo reu Au losa hatematak ia.’ ");
INSERT INTO txq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","De ita bubuluk tae, ita baꞌin nara raa mates sara dook ka ena. Tehuu Manetualain nafada ena nae, Ndia bei dadi neu sira Lamatuan, huu naa de ita bubuluk tae, ara rasoda fali ena. Dadi leo mae hatahorir mate ena oo, ara rasoda fali numa mamates mai boe. Memak hatahori masodak ndia rakaluku-rakatele neu Manetualain, ta hatahori mates, hetu? Dadi mete ma ei toꞌu makandoo nenorik naa mae, hatahori mates ta nasoda fali numa mamaten mai, memak ei sala malan seli naa ena!” ");
INSERT INTO txq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Faik naa, neu Yesus nanggatuuk kola-kola no partei Saduki hatahorin nara, hambu meser anggama esa tungga namanenen. Meser anggama naa duꞌa nae, Yesus naselu hatahori Sadukir netanen nara no malole ena. Boe ma ana natane Yesus nae, “Papa! Au nau atane talo ia: ita dala-hadan hohoro-lalanen, ma anggama parendan, noꞌun seli. Numa basa parendar fo maruma baꞌi Musa mai naa, bee ndia nenenin lenak mateꞌen?” ");
INSERT INTO txq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus naselu nae, “Parenda fo nenenin lenak mateꞌen nai Manetualain Susura Malalaon dale naa nae talo ia: ‘Basa hatahorir marai Israel! Ei nenene matalolole! Manetualain naa, memak ita Lamatuan, ma ita Mana Parenda Mana Koasan. Ta hambu seluk laen, kada Ndia mesa kana ena. ");
INSERT INTO txq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","De ei muste sue-lai neun lena heni basa-basan. Huu naa de ei muste hii malan seli neun, malela Ndia, ma maue-osa fafandek lima-eim mara fo tungga Ndia hihii-nanaun.’ ");
INSERT INTO txq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma parenda kaduan nae talo ia: ‘O muste sue hatahori laen nara, sama leo o sue o ao heli-helim.’ Parenda kaduak kara ia nenenin lenak mateꞌen. Ta hambu parenda laen bali fo nenenin lena heni parenda kaduak kara ia.” ");
INSERT INTO txq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Basa boe ma meser anggama naa kokolak seluk no Yesus nae, “Memak Papa kokolan naa, tetebes. Manetualain dadi neu ita Malangga Ina-huun, ma ta hambu Lamatuak laen ena. ");
INSERT INTO txq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ita muste sue-lai Manetualain lena heni basa-basan, losa ita hii talan seli neun, ma ita talela Ndia, ma taue-osa fafandek ita lima-ein nara fo tungga Ndia hihii-nanaun. Ma ita muste sue basa hatahorir sama leo ita sue ita ao-ina heli-helin. Ita tao talo naa, na, Manetualain namahoko nalan seli lena heni ita tungga kada anggama hohoro-lalanen. Naa, lolen lena numa kada ita tao banda tunu-hotuk, do fee bua-baꞌuk laen neu Ndia.” ");
INSERT INTO txq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus namanene nala ana naselu talo naa, boe ma Ana duꞌa nae, meser anggama naa nalela no malole ena. Boe ma Yesus nae, “O sangga mae dadi muu Manetualain hatahorin ena.” Basa boe ma ta hambu seluk hatahori laen bali nambarani nakaseseluk dedeꞌak no Yesus, te ta hambu hatahori esa senggi Yesus boe na. ");
INSERT INTO txq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus bei nanori hatahorir raa nai Manetualain Uma Huhule-haradoi Ina-huun. Boe ma Yesus natane sara nae, “Tungga ei hahambum, na, talo bee? Meser anggamar fee nenorik rae, Karistus naa, ndia Manetualain here memak kana numa lele uluk mai ena. Tungga sira, na, Ndia kada mane Dauk tititi-nonosin. Tehuu naa, ta ndaa. ");
INSERT INTO txq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lele uluk Manetulain Dula-dale Malalaon pake mane Dauk fo ana surak ena nae, ‘Manetualain nafada au lamatuang ena nae, “Mai fo manggatuuk muu mamana hada-horomatak mateꞌen ia nai Au boboa konang. Neu ko Au tao ala o musum mara losa ara doꞌor mbali O.’ ” ");
INSERT INTO txq_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Numa naa mai, ita bubuluk tae, mane Dauk mesa kana noke Karistus naa nae, ‘Lamatuak’. Sosoa-ndandaan nae, mete ma hatahorir kokolak rae, Karistus naa, kada mane Dauk tititi-nonosin, na, naa ta bei dai. Ana oo dadi neu mane Dauk Lamatuan boe!” ");
INSERT INTO txq_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Neu Yesus kokolak talo naa, boe ma hatahori noꞌuk ka hii ralan seli nenene neun. ");
INSERT INTO txq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Basa boe ma Yesus nafada neu sara bali nae, “Ei muste besa-besa mia meser anggamar. Ara rasiꞌe laꞌo-laꞌo pake badu naruk roroso losa daer, reu ratonggo ro hatahori noꞌuk kara, mita fo hatahorir mete-rita sara, na, rae, ‘Wee! Sira iar, hatahori moꞌo-inahuuk!’ ");
INSERT INTO txq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mete ma ara maso reni uma huhule-haradoik dale reu, do reu raꞌa feta, na, ara soa sangga mamana nenggetuuk neulaun lenak, mita fo hatahori noꞌuk kara mete-rita sara. ");
INSERT INTO txq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tehuu besa-besa! Ara soa pepeko-leleko ina falur fo fonda rala uman nara lalaꞌen. Tehuu nai hatahori noꞌuk kara matan, ara rafuni sira manggaraun ma rambariik hule-haradoi dook ka. Ara nau fo hatahori rae, sira iar, hatahori lolo-laok. Tehuu neu ko Manetualain fee hukun beran lenak neu sara.” ");
INSERT INTO txq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Basa boe ma Yesus neu nanggatuuk nasare neni mamana kolete manai Manetualain Uma Huhule-haradoi Ina-huun naa neu. Ana mete-nita hatahorir mai mbeda sira doi koleten nara reni mamanan dale neu. Yesus mete-nita hatahori kamasuꞌik kara oo mai mbeda sira doin noꞌun seli numa naa boe. ");
INSERT INTO txq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Boe ma ina falu hata taak esa oo mai tungga hule-haradoi boe. Ana mbeda doik seen dua neni mamanak naa neu. Doik naa belin kadiꞌi anan seli. ");
INSERT INTO txq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Boe ma Yesus nggape ana nunin nara, de nae, “Ei mete matalolole ina falu hata taak naa dei. Ana mbeda kada doik seen dua, tehuu ana fee baꞌu lena heni basa hatahorir lalaꞌen ena. ");
INSERT INTO txq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Basa hatahori laen nara raa fee kolete numa doi sisan nara mai. Tehuu ina falu ia fee basa ndia doin neu Manetualain.” ");
INSERT INTO txq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Basa naa, Yesus no ana nunin nara rae laꞌo ela Uma Huhule-haradoi Ina-huuk. Neu ara kalua, boe ma ana nunin esa dudu Uma Huhule-haradoik naa, ma nae, “Papa, ee! Hena Papa mete sudik ia dei. Uma ia lolen seli! Ara tia-totodo rala batu moꞌon nara neulaun seli!” ");
INSERT INTO txq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Boe ma Yesus naselu nae, “Uma ia memak malole! Tehuu ta dook ka bali te ara randefa heni basa batun nara lalaꞌen.” ");
INSERT INTO txq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Basa boe ma Yesus asa reni letek Setun reu fo ranggatuuk ruma mamana mana mbali neni Uma Huhule-haradoi Ina-huuk naa neu. Boe ma ana nunin haa mai, de mesa kasa kokolak ro Yesus. Ana nuni kahaak kara raa sira Petrus, Yakobis, Yohanis ma Anderias. ");
INSERT INTO txq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ara ratane rae, “Papa! Hena Papa mafada seluk Papa kokolan bebeik kara ia dei! Neu faik bee fo fain losa? Boe ma tandan nara leo beek?” ");
INSERT INTO txq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Boe ma Yesus naselu nae, “Sadi ei manea matalolole! Fo ei boso hambu kedi-irak. ");
INSERT INTO txq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Neu ko hambu hatahori mata-matak kara mai fo femba tenden nara rae, ‘Au ia ndia Karistus, fo Manetualain helu-bartaa memak kana numa lele uluk mai.’ Boe ma ara oo kedi-ira rala hatahori noꞌuk ka boe. ");
INSERT INTO txq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mete ma ei mete-mita hatahori ratati, do ei mamanene dedeꞌa anik rae, hambu netatik sudi nai bee, na, hae mamataꞌu. Matak leo naak kara muste dadi rakahuluk, tehuu dae-bafok fai mateꞌen bei ta losa. ");
INSERT INTO txq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Neu ko leo esa natati laban leo laen. Nusak esa natati laban nusak laen. Hambu dae nanggenggo nai bee a mesan. Ma fai ndoe-laꞌas oo, ta hohoꞌak sudi selik kana boe! Basa iar dadi reu tanda, sama leo ina kairuk fo nameda hedis sangga nae bonggi. ");
INSERT INTO txq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","De ei muste manea matalolole! Neu ko ara mai humu rala ei fo leꞌa roo ei meni malangga anggamar uma neketu-neladi dedeꞌan miu. Ma ara popoko ei nai uma huhule-haradoik kara dale. Ma ara paꞌa reni ei, meni hatahori mana toꞌu koasa miu, nahuu ei tungga Au. Tehuu naa oo, ei hambu lelak fo dadi sakasii soa-neu Au. ");
INSERT INTO txq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Manetualain hatahorin muste neu nafada nakahuluk Au Tutui Maloleng neu basa leo nai dae-bafok ia, dei fo dae-bafok fai mateꞌen losa. ");
INSERT INTO txq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Masaneda, ee! Mete ma ara paꞌa reni ei meni mamana neketu-neladi dedeꞌak miu, na, ei hae mamataꞌu mae, ‘Neu ko au kokolak ae leo bee? Do, Au aselu ae leo bee?’ Mete ma faik naa losa ena, na, ei kokolak leo tungga kada hata fo Manetualain Dula-dale Malalaon nafada neu ei. ");
INSERT INTO txq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nai uma-loo esa dale, mete ma hambu uma isi ruma ramahere neu Au, neu ko ndia toranoo bonggin sangga dalak fo ana tao nisan. Boe ma mete ma anan ndia namahere, na, ama bonggin tao nisan. Mete ma aman no inan sira ramahere neu Au, neu ko sira ana bonggin ndia tao nisa sara. ");
INSERT INTO txq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","De neu ko hatahorir dalen nara mburuk roo ei, nahuu ei mamahere Au. Tehuu see ndia nakatataka losa babasan, neu ko Manetualain tao nasoi-nasodan.” ");
INSERT INTO txq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesus kokolak nakandoo nae, “Hatahori esa fo manggaraun nalan seli nae mai. Ana maso neu nambariik nai mamana nelulik manai Manetualain Uma Huhule-haradoi Ina-huun, naa te ana ta nandaa neu naa, losa ana tao nunute mamanak naa. Huu naa de Manetualain nasadea ela mamanak naa. Mete ma ei mete-mita talo naa ena, na, besa-besa, ee! (See ndia lees ia, na, ana oo muste besa-besa boe). Naa dadi neu tanda nae, fai susa-sonak losa nai lelesu bafan ena. Mete ma mete-mita leo naak ena, na, hatahori manai nusa Yudea malai meni letek miu leo. ");
INSERT INTO txq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma muste malai lai-lai, mita fo boso hambu susa-sonak. Mete ma ketuk kalua laꞌo ela uma ena, na, boso fali miu haꞌi bua-baꞌum bali. ");
INSERT INTO txq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Boe ma see ndia nai osi dale, boso fali neu haꞌi lafa nelusek bali, tehuu malai makandoo leo! ");
INSERT INTO txq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mana kasian lenak ndia ina kairuk, ma inak kara mana rasususu ana mbimbila anan. Ara ta bisa ralai nggafak, na. ");
INSERT INTO txq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dadi malole lenak ei hule-haradoi fo moke dedeꞌa manggarauk naa, boso tuda laꞌe-ndaa fai udan. ");
INSERT INTO txq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Faik naa, susa nalan seli! Mulai numa Manetualain nakadadadik dae-bafok losa hatematak ia, hatahorir bei ta mete-rita susa-sonak moꞌok matak leo naak. Ma neu ko hatahorir ta mete-rita seluk susa-sonak matak leo naak bali. ");
INSERT INTO txq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mete ma Manetualain ta tao kekeꞌu faik naa, neu ko ta hambu hatahori esa boe na bisa nakatataka nasoda. Manetualain tao kekeꞌu fai susa-sonak kara raa, nahuu Ana sue-lai Ndia hatahorin fo Ana here nalak ena. ");
INSERT INTO txq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mete ma faik naa losa ena, ei mamanene hatahorir rae, ‘Mete dei! Karistus nai ia!’ Ma hatahori laen bali nae, ‘Karistus nai naa!’ Tehuu ei boso mamanene sara, ee! ");
INSERT INTO txq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Neu ko hambu hatahori kalua fo femba tenden nae, ‘Au ia, Karistus!’ Laen bali nae, ‘Au ia, Manetualain mana toꞌu dedeꞌan.’ Neu ko ara tao tanda heran mata-matak kara pake nitu koasan fo pepeko-leleko hatahori. Ara oo soba-soba fo Manetualain hatahorin nara hambu kedi-irak boe. ");
INSERT INTO txq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tehuu Ei muste manea matalolole, ee! Fai susa-sonak kara raa ta bei losa, tehuu Au fee nesenedak memak neu ei, ee!” ");
INSERT INTO txq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Boe ma Yesus tuti seluk bali, fo nafada ana nunin nara nae, “Mete ma fai susa-sonak kara raa basan ena, ‘Neu ko ledo dadi makiuk, bulan oo ta nasaꞌa bali ena boe. ");
INSERT INTO txq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nduuk kara bese tuda ruma lalai mai, ma basa koasa marai lalai rapiru-padok.’ ");
INSERT INTO txq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Basa naa dei fo basa hatahorir mete-rita Au, Hatahori Dae-bafo Isi-isik ia. Neu ko Au mai nai sosoꞌak numa lalai mai. Ma basa hatahorir mete-rita Au koasang, Au manula-manapung lalaꞌen! ");
INSERT INTO txq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Boe ma Au parenda Manetualain atan nara manai nusa tetuk do inggu temak fo reu rakabubua basa hatahorir fo Au here alak kara ruma dae-bafok buꞌun haa sara mai, numa ledo toda mai losa ledo tesa; numa kii mai losa kona.” ");
INSERT INTO txq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesus tuti Ndia kokolan nae, “Au haꞌi lololek numa ai huuk mai. Mete ma doon mulai uni, naa tanda nae, fai hanas deka-deka mai ena. ");
INSERT INTO txq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Leo naak oo, mete ma ei mete-mita fai susa-sonak kara mai ena, sama leo Au afada bebeik kara ia ena, naa tanda nae, Au deka-deka mai ena boe. ");
INSERT INTO txq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Hatematak ia, nenene matalolole! Numa basa hatahorir mana masodak hatematak ia mai, neu ko hambu ketuk bei ta mate, tehuu fai susa-sonak kara raa mai ena. ");
INSERT INTO txq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Leo mae lalai no dae-inak sambu do lalo ena, tehuu Au Dedeꞌa-kokolang ia mahanik seku neu.” ");
INSERT INTO txq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesus kokolak seluk nae, “Ta hambu hatahori esa boe na bubuluk faik bee do liꞌu hida Au fali mai. Manetualain atan nara marai nusa tetuk do inggu temak oo, ta bubuluk boe. Au mesa ngga oo ta bubuluk boe. Kada Au Amang mesa kana ndia bubuluk. ");
INSERT INTO txq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Huu naa de ei muste manea matalolole, nahuu ei ta bubuluk neu faik bee ndia fain losa. ");
INSERT INTO txq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ta dook ka ena te Au laꞌo ela ei, tehuu Au fali mai. Sama leo tenu uma laꞌo ela ndia uman fo neni mamana dook neu. Ana nadenu ndia ana mana maue-osan nara fo rafafaꞌu ralolole uma naa. Ma ana baꞌe esa-esak no uen. Ana parenda neu mana manea lelesu fo nanea no malole, losa ndia fali mai ngga. ");
INSERT INTO txq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ei oo muste manea hatu-leledon boe, nahuu ei ta bubuluk faik bee fo tenu uma fali mai ngga. Fali mai ngga nai ledo bobok do fai baꞌe duak, do leledok, do huhuak, do ledo kamatetuk. Ei ta bubuluk faik bee. ");
INSERT INTO txq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Boso losak Ana mai no kaiboik boe ma ana hambu nala ei mana sunggu masanggorok kara. ");
INSERT INTO txq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","De hata fo Au afada ei ia, Au oo afada basa hatahori laen nara ena boe ae, ‘Ei muste manea matalolole fo soru Au mamaing.’ ” Lamatuak Yesus kola-kola no ana nunin nara numa letek Setun losa kada naa. ");
INSERT INTO txq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Basa boe ma malangga anggama Yahudir malanggan nara bei sangga dalak fo rae humu Yesus no neneek, fo rae tao risan. Ma ara duduꞌa fo rala harak rae, “Makatataak dei! Ita boso humu Ndia lai-laik, nahuu fai maloler deka-deka ena. Boso losak hatahori noꞌuk kara ramue.” Ara kokolak talo naa, nahuu bei ela faik dua bali, hatahori Yahudir fai malolen nara fo ara raseseik rae, ‘Fai Paska’, ma ‘Fai Feta Roti Ta Pake Laru Taꞌik’. No fai maloler raa, ara rasaneda lele uluk, neu bei-baꞌin nara kalua numa nusa Masir mai. ");
INSERT INTO txq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nai nggoro Betania, hambu hatahori esa nade Simon. Bakahulun hatahorir nunuten, nahuu ana hambu hedi kusta. Tehuu hatematak ia ana hai ena. Faik naa, fai maloler bei ta losa, Yesus asa reu raꞌa-rinu numa Simon uman. Neu ara bei raꞌa-rinu, boe ma inak esa mai natonggo no Yesus. Ana toꞌu boto esa, ara taon numa batu mai. Boto naa isin mina kaboo menik fo belin seli. Inak naa femba tepa boto naa leusain. Boe ma ana mboꞌa nakafafaak koe-koe mina naa neu Yesus langgan, fo dadi tanda ana fee hada-horomatak neu Yesus. ");
INSERT INTO txq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tehuu hambu hatahori laen hida fo tungga raꞌa numa naa boe. Neu ara mete-rita inak naa tao talo naa, boe ma ara ramanasa, de ara rakokola koa aok rae, “Huuh! Ina hata ia, fo ana neu nggari heni hiek mina kaboo menik mabelin seli naa! ");
INSERT INTO txq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Malole lenak ana seꞌo mina naa! Fo neu babaꞌe doi noꞌun nara fee hatahori mana tofa-tarak kara! Mina kaboo menik naa belin, sama leo hatahori esa nggadin teuk esa.” De ara rahara berak neun. ");
INSERT INTO txq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tehuu Yesus bala nae, “Ei hae tao makasususak inak ia. Elan numa naa leo! Au amahoko, nahuu ana mboꞌa mina kaboo menik ia neu Au ao-mbaang. ");
INSERT INTO txq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hatahori mana tofa-tarak kara soa roo ei. De ei bisa tulu-fali sara sudi neu faik bee. Tehuu Au, na, ta dook ka te Au ta akabua ua ei ena. ");
INSERT INTO txq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Au masodang ta dook ka ena. Ma ina mana mboꞌa mina bebeik kara ia sadia nakahuluk Au ao-mbaang, sama leo ana fee rambe memak neu Au ao-mbaang mamaten. ");
INSERT INTO txq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Masaneda matalolole, ee! Nai bee a mesan, Manetualain Tutui Malolen natanggela nai dae-bafok ia, neu ko ara oo tui inak ia malolen boe, mita fo basa hatahorir rasanedan.” ");
INSERT INTO txq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Basa boe ma Yesus ana nuni kasalahunu duan nara, esa nade Yudas Iskariot. Ana kalua neu sangga malangga anggama Yahudir malanggan nara fo nae seꞌo heni Yesus neu sara. Ana losa neu sara, boe ma nafada ndia dale ikon. ");
INSERT INTO txq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Malangga anggamar ramanene Yudas nae talo naa, boe ma ara ramahoko ralan seli. De ara helun rae, “Mete ma o nau seꞌo Yesus neu ai, na, ai bae.” Boe ma Yudas kalua dea neu, de ana sangga dalak fo nae fee Yesus neu sara. ");
INSERT INTO txq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Basa boe ma Yesus ana nunin nara mai ratanen rae, “Papa! Faik ia ita Fai Paska ena. De Papa nau ai miu sadia mamana feta Paska nai bee?” Te faik naa hatahori Yahudir fai malole makasososan. Nai faik naa ara rasiꞌe tunu roti ta pake laru taꞌik, ma ara oo hala bibi lombo boe. ");
INSERT INTO txq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Boe ma Yesus nadenu ana nunin dua nae, “Ei dua ngga makahuluk meni kota miu. Nai naa ei matonggo mia touk esa nasaa oe nai nggusi anak esa dale. Ei miu laꞌo tunggan leo. ");
INSERT INTO txq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mete ma ana maso neni uma bee neu, na, ei tungga naa miu. Basa naa, ei mafada tenu uma naa mae, ‘Papa! Ai Papa Mesen noke mamanak esa, fo nae paken neu mamana feta Paska no ana nunin nara.’ ");
INSERT INTO txq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Neu ko tenu uma naa dudu fee ei kama loak esa nai uma tadak lain. Ana sadia nala kama naa no matetuk ena. Ela kada ei dua ngga miu sadia nanaꞌak nai naa leo.” ");
INSERT INTO txq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","De dua sara laꞌo reni kota reu. Numa naa ara ratonggo ro basa hata fo Yesus nafada memak neu sara naa ena. Boe ma ara sadia basa-basan fo Yesus asa raꞌa feta Paska nai naa. Basa boe ma dua sara reu roke Yesus asa. ");
INSERT INTO txq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Neu ledo mulai tesa ena, boe ma Yesus no ana nuni kasalahunu duan nara reni naa reu. ");
INSERT INTO txq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Boe ma basa sara ranggatuuk, de raꞌa-rinu sama-sama. Neu ara raꞌa-rinu, boe ma Yesus kokolak nae, “Ei nenene ee! Hambu hatahori esa numa ei taladam mara mai, neu ko ana seꞌo heni Au neni hatahori laen nara neu.” ");
INSERT INTO txq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ara ramanene rala naa, boe ma dalen nara rameda ta malole. De ara esa-esak ratane Yesus rae, “Hatahori fo Papa nafadak naa, ta ndia au, hetu?” ");
INSERT INTO txq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus naselu nae, “Hatahori fo mana sama-sama no Au boro roti neni manggo ia dale neu naa ndia neu ko nae seꞌo heni Au. ");
INSERT INTO txq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Masaneda, ee! Au, Hatahori Dae-bafo Isi-isik ia muste mate sama leo neni surak memak nai Manetualain Susura Malalaon dale. Tehuu besa-besa! Hatahori fo mana nae seꞌo heni Au naa, ana ndia lemba-nasaa nala ndia sosoen. Malolen lenak mete ma inan ta bonggi sana!” ");
INSERT INTO txq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Neu ara bei raꞌa, boe ma Yesus soꞌu botik roti balok esa, fo noke makasi neu Manetualain. Boe ma Ana fifiꞌi baꞌe roti naa, de Ana loon neu ana nunin nara, ma nafada nae, “Roti ia, Au ao-mbaang. Haꞌi malan fo miꞌa leo!” ");
INSERT INTO txq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Basa naa, Ana haꞌi nala nggalaas neni isi oe anggor. Ana oo noke makasi neu Manetualain boe. Basa boe ma Ana loo nggalaas naa neu ana nunin nara fo basa sara rinu. ");
INSERT INTO txq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Boe ma Ana nae, “Anggor ia, Au daang. Neu ko titi henin fo tao nasoi-nasoda hatahori noꞌuk ka. Daak ia, dadi bukti fo tasaneda tae, hata fo Manetualain helu-bartaak ena, memak hatematak ia ana dadi ena. Haꞌi malan fo minu leo. ");
INSERT INTO txq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nenene matalolole dei! Mulai numa leꞌodaen ia neu, Au ta inu oe anggor ena. Losa Au anggatuuk parenda sama-sama ua Au Amang manai nusa tetuk do inggu temak, dei fo Au inu bali.” ");
INSERT INTO txq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Basa boe ma ara soda sosodak esa fo koa-kio neu Manetualain. Boe ma ara kalua leꞌodaek naa fo reni letek Setun reu. ");
INSERT INTO txq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Neu ara bei laꞌok naa, Yesus nafada memak nae, “Neu ko leꞌodaen ia, ei basa ngga malai laꞌo ela Au. Naa sama leo ara surak memak nai Manetualain Susura Malalaon dale nae, ‘Neu ko Manetualain tao nisa mana lolo, de bibi lombon nara ralai sasarak.’ ");
INSERT INTO txq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Memak Au mate. Ma neu ko mete ma Au asoda fali numa mamates mai ena, na, Au laꞌo akahuluk ei uni profensi Galilea uu.” ");
INSERT INTO txq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Boe ma Petrus nasabara nae, “Papa! Leo mae basa hatahori laen nara ralai laꞌo ela Papa oo, au ta alai boe!” ");
INSERT INTO txq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus naselu nae, “Peꞌu! Masaneda, ee! Leꞌodaen ia, manu bei ta kokoa laꞌe dua, tehuu o kokolak laꞌe telu ena mae, o ta malela Au!” ");
INSERT INTO txq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tehuu Petrus naselu nahere nae, “Taa, Papa! Mete ma Papa mate, na, au oo mate sama-sama ua Papa boe. Au ta alai laꞌo ela Papa, ma au ta laka ae, ta alela Papa!” Petrus nonoon laen nara oo, esa-esak nae leo naa boe. ");
INSERT INTO txq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Basa naa, Yesus asa laꞌok rakandoo losa osi esa nai letek Setun nade ‘Getsemani’. Boe ma Yesus nafada sara nae, “Ei manggatuuk mahani ia, ee. Au nau uu hule-haradoi nai naa.” ");
INSERT INTO txq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tehuu Yesus noke no Petrus, Yakobis ma Yohanis fo ara laꞌok ro Ndia. Mulai numa naa neu, Yesus dalen sona ma ta natetu faa boe na. ");
INSERT INTO txq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yesus nafada sara nae, “Au daleng susa nalan seli! Au ameda nok bali ae mate a ena. Ei manggatuuk manea mai ia dei.” ");
INSERT INTO txq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Boe ma Yesus laꞌo nakadodook aon faa, de Ana sendek luu-langgan neu daer fo Ana hule-haradoi nae, “Papa. Mete ma Papa nau, na, Au hae lemba-asaa doidosok naa losa mate leo iak. Au bubuluk memak ena ae, ta hambu hata esa boe na fo Papa ta bisa tao nalan. De mete ma Papa nau, na, nggari makadodook doidosok ia numa Au mai. Tehuu boso tungga Au hihii-nanaung, naa fo tungga kada Papa hihii-nanaun.” ");
INSERT INTO txq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Basa boe ma Ana fali neni ana nuni katelun nara neu, tehuu ara sunggu seli. Boe ma Yesus fafae sara, de kokolak no Petrus nae, “Heeh, Peꞌu! O sunggu, do? Au numa naa ta doo anak ka, tehuu ei ta bisa beꞌe manea faa boe na. ");
INSERT INTO txq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kukuku maneu o matam dei. Boe ma mambadeik fo manea mua Au. Ei dalem mara memak nau tao neulauk, tehuu ei ao-inam barakai taak. De malole lenak ei hule-haradoi fo mete ma hambu soba-douk, na, ta senggi ei.” ");
INSERT INTO txq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Basa boe ma Yesus neu hule-haradoi seluk laꞌe esa bali. Ana hule seluk neu Manetualain fo boso fee Ndia lemba-nasaa doidosok naa. ");
INSERT INTO txq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Boe ma Ana fali neni ana nuni katelun nara neu. Tehuu ara sunggu seluk bali, nahuu matan nara ramabera ralan seli. Boe ma Ana fafae seluk kasa bali, tehuu ara ta bubuluk fo raselu rae leo bee neu Yesus. ");
INSERT INTO txq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Basa boe ma Yesus laꞌo ela sara bali fo neu hule-haradoi seluk laꞌe katelun. Boe ma Yesus fali, de Ana fafae sara. Ana nae, “Ei bei sunggu bali, do? Dai ena! Mambadeik! Hatahori fo nae seꞌo heni Au, Hatahori Dae-bafo Isi-isik ia, deka ena. Hatematak ia ara rae humu Au, fo ara fee Au uni hatahori manggarauk kara liman uu. ");
INSERT INTO txq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mambadeik leo! Buka ei matam mara fo mete sudi neni naa neu dei! Hatahori fo nae seꞌo heni Au naa, ana mai ena. Mai fo ita teu tatonggo too sara!” ");
INSERT INTO txq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Neu Yesus bei kola-kola talo naa, te nggengger neuk ka, Yudas mai ena no hatahori noꞌun seli. Ara mai reni tafa mukuk ma tongga fo rae humu Yesus. Ara tao talo naa, tungga parenda numa malangga Yahudir malanggan nara mai. Sira raa, ndia malangga anggama malanggan nara, meser anggamar, ma lasi-lasi hadak kara. ");
INSERT INTO txq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas fee tanda memak kasa ena nae, “Ei mete matalolole, ee! Au idu see, na, ei humu malan leo! Ndia naa, ndia hatahori fo ei sanggak!” ");
INSERT INTO txq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dadi, neu Yudas asa losa naa, boe ma Yudas nasare matan no Yesus. De ana nahara nae, “Papa Meser!” Boe ma ana holu ma idu Yesus. ");
INSERT INTO txq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Basa boe ma hatahori noꞌuk kara mata reu fo humu Yesus. ");
INSERT INTO txq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tehuu Yesus hatahorin esa lesu nala fela mukun, de ana sambi naketu hatahori esa ndiꞌi doon. Hatahori mana makahinak naa, ndia malangga anggama Yahudi malangga ina-huun hatahori neondan. ");
INSERT INTO txq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Boe ma Yesus kokolak no hatahorir fo mana mai humu Ndia naa nae, “Talo bee? Ei duꞌa mae, Au ia hatahori manggarauk, do? De ei mai humu Au meni tafa ma tongga? ");
INSERT INTO txq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tungga faik Au anori ei nai Manetualain Uma Huhule-haradoik Ina-huun dale, ma ta hambu esa boe na mai humu Au. Mai, humu mala Au leo! Te ia neni surak memak kana numa lele uluk mai nai Manetualain Susura Malalaon dale ena.” ");
INSERT INTO txq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesus ana nunin nara ramataꞌu ralan seli. Boe ma ara ralai laꞌo ela kada Yesus mesa kana. ");
INSERT INTO txq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Numa naa oo, hambu tou muri anak esa tungga Yesus dean boe. Ana naluse ao-inan nenik kada sidi anak esa. Hatahorir raa rae humun boe. ");
INSERT INTO txq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tehuu ara ndaso rala kada sidin, de mboꞌi henin. Boe ma ana nalai fali neu ngga no kada makaholak, nahuu namataꞌu nalan seli ena. ");
INSERT INTO txq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Basa boe ma ara toꞌu roo Yesus neni anggama Yahudi malangga ina-huun uman neu. Numa naa, hatahori moꞌo-inahuuk kara rakabua ena. Sira ndia malangga anggamar malanggan nara, meser anggamar, ma lasi-lasi hadak kara. ");
INSERT INTO txq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Neu ara humu reni Yesus, Petrus laꞌo bambi-bambi tungga dea losa nai anggama Yahudi malangga ina-huun uman. Ana oo maso neni uma bebelan neu, de nanggatuuk dara aꞌi sama-sama no hatahori manear marai naa. ");
INSERT INTO txq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Numa uma naa dale, malangga anggamar malanggan nara kola-kola ro hatahorir mana maketu-maladi dedeꞌa nai mamana neketu-neladi dedeꞌa anggama. Basa sara sangga bukti fo nau fee salak neu Yesus nahuu ara rae hukun mates neun. Tehuu ara ta hambu bukti hata esa boe na. ");
INSERT INTO txq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Boe ma ara roke sakasii noꞌuk ka fo sangga rakatutudak Yesus. Tehuu kokolan nara esa ta nandaa no esa. ");
INSERT INTO txq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Boe ma hambu sakasii hida bali rambariik fo kokolak pepeko-lelekok rae, ");
INSERT INTO txq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ai mamanene hatahori ia kokolak nae, ‘Neu ko Au ndefa heni Uma Huhule-haradoi Ina-huuk fo hatahori dae-bafok rambadedeik kana no liman nara. Basa faik telu bali, na, neu ko Au ambaririik falik Uma naa, tehuu ta pake hatahori dae-bafok liman.’ ” ");
INSERT INTO txq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tehuu sira kokolan naa, esa ta nandaa no esa. ");
INSERT INTO txq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Basa boe ma malangga ina-huuk naa, nambariik neu basa hatahori mana maketu-maladi dedeꞌa matan nai mamana neketu-neladi dedeꞌa anggama naa. Boe ma ana natane Yesus nae, “Hatahori noꞌuk ka kalaak O. Tao hata de O ta mahara?” ");
INSERT INTO txq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tehuu Yesus ta nahara faa boe na. Basa boe ma malangga ina-huuk naa natane seluk kana bali nae, “Hena O mafada dei! Memak O ia tebe-tebe ndia Karistus, Manetualain Anan fo Ana helu-bartaan numa lele uluk mai naa ena, do?” ");
INSERT INTO txq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus naselu nae, “Memak tebe! Karistus naa, ndia Au ia. Neu ko ei basa ngga mete-mita Au, Hatahori Dae-bafo Isi-isik ia anggatuuk nai nusa tetuk do inggu temak nai Manetualain boboa konan. Ndia koasan ta neni babanggak! Neu ko Au ua Ndia toꞌu parenda sama-sama! Basa naa, neu ko Au konda numa nusa tetuk do inggu temak mai ua sosoꞌak.” ");
INSERT INTO txq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Malangga ina-huuk naa namanene Yesus kokolak talo naa, boe ma ana namanasa nalan seli, losa ana sii nasida badu narun. Boe ma ana bolu nafada neu basa hatahori mana nggero-furak kara nai mamana neketu-neladi dedeꞌa anggama naa nae, “Ita ta parluu sakasii ena! ");
INSERT INTO txq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ei mamanene no ei ndiꞌi doo heli-helim mara ena, Ndia mesa kana kokolak talo naa, hetu? Ana soꞌuk aon dadi neu Manetualain Anan. Ia nakadadaek nalan seli Manetualain ia! Tungga anggama hohoro-lalanen, mete ma hambu hatahori esa soꞌuk aon sama leo Manetualain, na, hatahori naa muste tao maten! De hatematak ia, ei nau maketu-maladi taon talo bee?” Boe ma basa sara raketu rae, “Hatahori ia memak tebe-tebe sala! Dadi Ana muste hambu hukun mates!” ");
INSERT INTO txq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Boe ma hatahori hida mata reu, de ara pura ambe neu Yesus. Ara mboti ketu matan, boe ma ara popokon. Basa boe ma ara radenun rae, “Mete ma O Manetualain mana toꞌu dedeꞌan, na, selu sudik see ndia tutu O?” Basa boe ma ara fee parenda neu hatahorir mana manea Uma Huhule-haradoi Ina-huuk fo mai reni Yesus. Ara roon neu, boe ma ara famba rakamiminak kana. ");
INSERT INTO txq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Faik naa, Petrus bei nanggatuuk sama-sama numa uma bebelan. Boe ma anggama Yahudi malangga ina-huun ata inan esa mai meten dara aꞌi. Ana namumula Petrus matan, boe ma ana kokolak nae, “Bebeik kara ia o tungga sama-sama mua Yesus, hatahori Nasaret naa boe, hetu? Tebe, hetu?” ");
INSERT INTO txq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tehuu Petrus naselu nae, “Taa! Tao hata de o matane talo naa! Au ta alela sana.” Boe ma Petrus kalua fo neu nambariik neu mbaꞌa lelesu matan. Hatematak naa oo manu kokoa boe. ");
INSERT INTO txq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Boe ma ata inak naa mete-nita seluk Petrus bali. De nafada basa hatahorir marai naar nae, “Ndia ia, esa numa hatahorir raa mai!” ");
INSERT INTO txq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Boe ma Petrus nasabara nae, “Fama te, o kamuluk! Au ta alela Hatahori naa, ma!” Doo-doo faa boe ma hatahori laen esa numa naa kokolak seluk bali neu Petrus nae, “Wee! O bei nau masapepeko bali mae, o ta sama-sama mua hatahorir raa! Heeh! Ei basa ngga, hatahori Galilea, hetu?” ");
INSERT INTO txq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tehuu Petrus nareresi bali nae, “Heeh! Au sumba-soo! Au ta alela Hatahori naa!” ");
INSERT INTO txq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ndaa no ana kokolak talo naa, boe ma manu kokoa laꞌe kaduan. Boe ma Petrus nasaneda Yesus kokolan bebeik kara nae, “Manu bei ta kokoa laꞌe dua, tehuu o laka laꞌe telu ena mae, o ta malela Au.” Petrus nasaneda Yesus kokolan naa, boe ma ana buꞌi nakarereu. ");
INSERT INTO txq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bei huhua anan seli, basa hatahorir marai mamana neketu-neladi dedeꞌak naa, rala harak fo rae tao risa Yesus. De ara futu-paꞌa roon neu nasare nggubenor Pilatus. ");
INSERT INTO txq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Neu ara losa nggubenor Pilatus, boe ma ana natane Yesus nae, “Talo bee? Tebe-tebe O ia, hatahori Yahudir Manen, do?” Yesus naselu nae, “Tebe. Papa nggubenor kokolak ndaa naa ena.” ");
INSERT INTO txq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Boe ma malangga anggamar malanggan nara kokolak ro nggubenor rae, “Hatahori ia tao salak noꞌun seli ena!” De ara hingga salan esa-esak. ");
INSERT INTO txq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Boe ma nggubenor natane seluk Yesus bali nae, “O ta mamanene sira kokolan nara de? Ara fee salak noꞌun seli neu O ena. Soba O bala dei!” ");
INSERT INTO txq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tehuu Yesus ta naselu hata esa boe na, losa nggubenor heran bali-bali. ");
INSERT INTO txq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tungga teuk, mete ma hatahori Yahudir tao feta Paska, hatahori noꞌuk kara rasiꞌe here rala hatahori bui esa fo nggubenor nakamboꞌik kana. ");
INSERT INTO txq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Faik naa hatahori bui esa, nade Barabas. Fai maneuk kara ara humu ralan no nonoon nara, nahuu ana laban man-parenda Roma, ma ana oo nakanisa hatahori boe. ");
INSERT INTO txq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Huu feta Paska sangga deka ena, de hatahori noꞌuk ka reni nggubenor Pilatus reu, de ara eki rae, “Papa nggubenor! Fai Paska mai ena. Mete ma bisa, na, Papa nggubenor tulun fo makamboꞌik hatahori bui esa tungga ai siꞌen!” ");
INSERT INTO txq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Boe ma nggubenor naselu nae, “Au ae akamboꞌik see? Talo bee, leo au akamboꞌik ei hatahori Yahudi Manen ia? Ei makaheik, do?” ");
INSERT INTO txq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nggubenor kokolak talo naa, naa te ana bubuluk ena malangga anggamar malanggan nara leꞌa roo Yesus neni ndia neu, nahuu ara mburuk ralan seli neu Yesus. ");
INSERT INTO txq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tehuu malangga anggamar malanggan nara dudunggu hatahori noꞌuk kara raa, de basa sara roke nggubenor rae, “Ai ta nau sana! Makamboꞌik kada Barabas dei!” ");
INSERT INTO txq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Boe ma nggubenor natane seluk nae, “Mete ma talo naa, na, Au tao Yesus talo bee, fo roken rae, ‘Mane hatahori Yahudi’ ia?” ");
INSERT INTO txq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Boe ma basa sara eki rame-rame rae, “Tao misa kada Yesus! Pakun neu ai ngganggek!” ");
INSERT INTO txq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Boe ma nggubenor natane nae, “Ana sala hata? Au parisan ena, te au ta hambu Ana sala hata esa boe na!” Tehuu basa sara boe eki rahere bali rae, “Tao misan! Pakun neu ai ngganggek leo!” ");
INSERT INTO txq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Huu nggubenor sangga tao namahoko hatahori noꞌuk kara dalen nara, de ana mboꞌi Barabas, tungga sira hihiin. Boe ma ana parenda mana manear fo reu poko-femba Yesus pake fifiuk. Ara poko-femba basan, boe ma soldadur leꞌa renin leo fo rae reu paku tao risan neu ai ngganggek. ");
INSERT INTO txq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Basa boe ma soldadur leꞌa roo Yesus neni sira uma bebela loan neu. Numa mamanak naa, roke rala sira nonoon nara batalion esa. ");
INSERT INTO txq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","De ara fee Yesus pake badu naru mbila maranggeok esa, sama leo manek kara bualoꞌa-papaken nara. Boe ma ara haꞌi ai dila-nggauk longgen, de ara nanen dadi neu solangga. Boe ma ara ndeꞌi solangga kanggouk naa neu Yesus langgan, fo rakamiminak kana sama leo rae soꞌu mane beuk fo feen pake solangga manek. ");
INSERT INTO txq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Boe ma basa sara fee hada-horomatak rakamiminak kana, ma rae, “Sodak Papa Manek Yahudi!” ");
INSERT INTO txq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Boe ma ara kaur rakekeik langgan nara mbali Yesus. Basa boe ma ara pupura ambe neu matan, ma ara dedelu laꞌi-laꞌik ka neun pake ai. ");
INSERT INTO txq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ara rakamiminak basan, boe ma ara buka heni badu naruk naa. De ara feen pake falik bua-loꞌan nara. Basa boe ma ara roon laꞌo ela kota Yerusalem fo reu paku londan neu ai ngganggek lain losa maten. ");
INSERT INTO txq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Neu ara bei laꞌok kalua numa Yerusalem mai, boe ma ara ratonggo ro hatahori esa numa kota Kirene mai. Hatahori naa, nade Simon. Ndia ia, Aleksander ma Rufus aman. Ana dei fo nae maso neni Yerusalem neu, tehuu soldadur toꞌu ralan, de rakasetik kana lemba-nasaa nala Yesus ai ngganggen. ");
INSERT INTO txq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ara leꞌa roo Yesus neni mamanak esa neu nade Golgotaa. (Ndia sosoa-ndandaan nae, ‘mamana langga duik’.) ");
INSERT INTO txq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Numa naa, ara fee Yesus ninu anggor makeis neni seseok no modo-aidoo, mita fo Ana bisa nakataka hedis. Tehuu Yesus ta nau ninu. ");
INSERT INTO txq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Basa boe ma ara paku ralelengga Yesus neu ai ngganggek lain. De ara rambaririik ai ngganggek naa, fama te neu liꞌu sio huhuan. Boe ma soldadu leꞌa lot fo sangga bubuluk see ndia hambu Yesus bua-loꞌan nara. ");
INSERT INTO txq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Basa boe ma ara surak neu papak esa, de ara pakun neu Yesus langgan dandaan lain nae, “Ia, hatahori Yahudir Manen.” Ara pake naa dadi neu huun fo hukun Yesus. ");
INSERT INTO txq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Numa naa oo, ara paku tao risa hatahori naꞌo manu-meo dua boe. Esa nai Yesus boboa konan, ma esa nai boboa kiin. ");
INSERT INTO txq_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","No dalak naa, ara tungga hata fo neni surak memak nai Manetualain Susuran nae, “Ara taon sama leo hatahori manggarauk.” ");
INSERT INTO txq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Basa hatahorir fo mana laꞌo tungga naa, mete-rita Yesus neni londak nai ai ngganggek lain. Boe ma ara kakale langgan nara ma rakatitiik-rakamamaek Yesus rae, “Weeh! O mae O bisa tao mandefa heni Manetualain Uma Huhule-haradoi Ina-huun fo mambadedeik falik kana doon kada faik telu, hetu? ");
INSERT INTO txq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Soba O konda numa ai ngganggek naa lain mai, fo makamboꞌik O aom leo! Mete ma dadi talo naa, na, dei fo ai mamahere memak mae, O ia Manetualain Anan.” ");
INSERT INTO txq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Malangga anggama Yahudir malanggan nara ma meser anggamar oo rakatitiik Yesus boe, ma ara kokolak rae, “Ana tao nasoi-nasoda hatahori laen, tehuu ana ta bisa tao nasoi-nasoda Ndia ao heli-helin! ");
INSERT INTO txq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ana nae, Ndia naa, ‘Karistus’, fo Manetualain helu-bartaa memak kana numa lele uluk mai. Hatahori laen rae, Ndia ia hatahori Israel Manen. Mete ma tebe leo naak, na, elan numa naa fo Ana konda numa ai ngganggek lain mai, fo ita mete-tita dei. Mete ma tebe leo naak, dei fo ita bisa tamahere neun.” Hatahori kaduak kara raa fo neni londak sama-sama ro Yesus numa ai ngganggek naa oo tungga rakatitiik Yesus boe. ");
INSERT INTO txq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Basa naa, makiu makahatuk tatana nala mamanak naa numa ledo namatetu losa liꞌu telu ledo bobon. ");
INSERT INTO txq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ndaa no liꞌu telu ledo bobon, boe ma Yesus eki pake dedeꞌa Aram nae, “Eloi! Eloi! Lema sabaktani?” (Sosoa-ndandaan nae, “Au Lamatuang! Au Manetualaing, ee! Tao hata de Amak masadea laꞌo ela Au talo ia?”) ");
INSERT INTO txq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hambu hatahori hida deka-deka ruma naa, ramanene Yesus haran naa. Boe ma rae, “Hoi! Ei mamanene dei. Ana nanggou Elia, Manetualain mana toꞌu dedeꞌan lele uluk naa!” ");
INSERT INTO txq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Boe ma hatahori esa nalaik neu haꞌi lombu, de ana boron neni anggor makeis dale neu. Boe ma ana nato lombu naa neu teteꞌe ai suꞌun, de soron neni Yesus bifi doon neu, fo Ana musi. Boe ma hatahori naa kokolak nae, “Tahani fo ita mete sudik kana. Fama te Elia mai fo nakondan numa ai ngganggek lain mai.” ");
INSERT INTO txq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","De Yesus eki seluk bali, boe ma maten. ");
INSERT INTO txq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nai Uma Huhule-haradoi Ina-huuk dale, hambu tema loak esa neni londak fo babata neu Manetualain Kama Malalaon Mateꞌen. Ndaa no Yesus ketu ani hahaen, boe ma temak naa sii baꞌen neu dua, numa lain mai losa dae. ");
INSERT INTO txq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Numa Golgotaa, hambu komedan mana manea esa, nambariik deka no Yesus ai ngganggen. Neu ana mete-nita Yesus mamaten, ana nggengger. Boe ma ana nae, “Awii! Hatahori ia, memak tebe-tebe Manetualain Anan, ee!” ");
INSERT INTO txq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ma hambu inak hida fo ara tungga mete Yesus mamaten numa dook ka mai. Inak kara raa, ndia bakahulun raono-lalau Yesus asa numa Galilea. Sira raa, ndia Salomi, Maria numa nusak Magdala mai ma Maria esa bali (fo Yakobis anak no Yoses inan), ma inak laen noꞌuk ka bali mana sama-sama ro Yesus reni Yerusalem mai. ");
INSERT INTO txq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Basa boe ma hatahori esa sangga dalak fo nakonda Yesus ao-mbaa mamaten numa ai ngganggek naa lain mai. Hatahori naa, nade Yusuf numa kota Arimatea mai, ma hatahori ia oo hatahori esa numa mana maketu-maladi dedeꞌak anggama Yahudi mai boe. Ndia dalen malole. Ma ana nahani taa-taa Manetualain parenda-koasan mai. Yesus fai mamaten naa, ndaa no fai limak. Beꞌe-mai laꞌe-ndaa no hatahori Yahudir fai huhule-haradoin. Huu naa de fai limak naa, Yusuf nau nakonda nakahuluk Yesus ao-mbaa mamaten. De ana tao nambarani dalen fo neu noke Yesus ao-mbaa mamaten nai nggubenor Pilatus. ");
INSERT INTO txq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Neu nggubenor namanene Yusuf noke talo naa, boe ma ana heran. De ana nae, “Awii! Hatahori naa mate lai-laik neuk ka. Au duꞌa ae, ta bisa dadi talo naa, oo!” Boe ma nggubenor nadenu hatahorir fo reu roke komedan soldadu naa mai, de natane nae, “Talo bee? Yesus naa, maten ena, do beik?” ");
INSERT INTO txq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Komedan soldadu naa naselu nae, “Memak Ana mate numa bebeik kara ia mai ena, Papa.” Nggubenor namanene nala naa, boe ma ana nakaheik Yusuf neu haꞌi nala Yesus ao-mbaa mamaten. ");
INSERT INTO txq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","De Yusuf neu hasa tema naruk mabeli. Boe ma ana neni Golgotaa neu. Ana nakonda Yesus ao-mbaa mamaten numa ai ngganggek lain mai. Ana oo mboti nalololen nenik tema beuk naa. Faik naa, ara bei fo toꞌi basa rates esa nai lete batu dale. Boe ma ara koꞌo rala Yesus ao-mbaa mamaten, de ralololin neni bolok naa dale neu. Basa de ara loli rala batu bebela moꞌok esa fo ara tatana ralololen neu rates naa lelesun. Boe ma Yusuf asa fali reu sara leo. ");
INSERT INTO txq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Faik naa, Maria numa Magdala mai, ma Maria laen (ndia Yoses inan) oo, tungga losa naa boe. Dua sara mete fo rasaneda ratalolole mamanak naa, fo ara tao Yesus ao-mbaa mamaten naa neu. ");
INSERT INTO txq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Beꞌe-mai fo fai neek, ndia hatahori Yahudir fai huhule-haradoin. Neu ledo tesa ena, Maria numa nusak Magdala mai, Maria esa bali (Yakobis inan) ma Salomi, reu hasa mina kaboo menik fo rae reu bibiru neu Yesus ao-mbaa mamaten, tungga hatahori Yahudir dala-hadan. ");
INSERT INTO txq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Neu fai Menggu huhua anan, telu sara reni rates naa reu. ");
INSERT INTO txq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Neu ara bei laꞌok numa dalak, boe ma rakokola aok rae, “Naa! See ndia bisa tulun ita fo keko heni batu moꞌok naa numa rates lelesun mai? Neu ko ita telu ngga ta tabeꞌi sana, te batu naa moꞌon seli na!” Tehuu neu ara losak ka naa, ara mete-rita batu naa neni loli henik ena. ");
INSERT INTO txq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Boe ma ara maso reni rates naa dale reu. Ara nggengger ralan seli, nahuu mete-rita hatahori muri anak esa nanggatuuk nai sira boboa konan, ana pake bua-loꞌa muti manggadilak. ");
INSERT INTO txq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Boe ma hatahori muri anak naa nafada sara nae, “Ei hae mamataꞌu! Au bubuluk ei mai sangga Yesus numa Nasaret mai, fo ara rakanisan numa ai ngganggek naa lain. Ana ta nai ia ena, Ana nasoda fali numa mamaten mai ena. Mai fo mete-mita no ei mata heli-helim mara mamanak fo ara tao Yesus ao-mbaa mamaten neuk naa rouk ena. ");
INSERT INTO txq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ei fali lai-lai leo! Miu mafada Petrus asa mae, Yesus nasoda fali numa mamaten mai ena. Ana laꞌo nakahuluk neni Galilea neu ena. Dei fo ara ratonggo ro Yesus nai naa, sama leo nafada ela sara ndia fai bakahulun. De fali miu ngga leo!” ");
INSERT INTO txq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Neu inak kara raa mete-rita mamanak naa rouk, boe ma ara nggengger. De ara ralai dea reu. Basa boe ma ara fali lai-laik. Ara ta rafada esa boe na, neu ara bei numa dalak, nahuu ara ramataꞌu ralan seli. ");
INSERT INTO txq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Fai Menggu huhua anan naa, Yesus neu natudu matan nakahuluk neu Maria numa Magdala mai, fo fai bakahulun Yesus husi nita nitu hitu numa aon mai. ");
INSERT INTO txq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ana mete-nita basa Yesus, boe ma ana fali de nafada basa hatahorir fo fai maneuk kara ara tungga Yesus. Ara bei bua-bua no dale sonak, ma luu-oen nara bei ta mada, rasaneda Yesus mamaten naa. ");
INSERT INTO txq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Boe ma Maria nafada sara nae, “Tao hata de ei bei susa? Hae susa bali, te Yesus nasoda fali numa mamaten mai ena! Bebeik kara ia au dei fo atonggo uan!” Tehuu basa sara raselu rae, “Weeh! O kada kokolak lelik!” ");
INSERT INTO txq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Basa boe ma Yesus ana nunin dua laꞌok reni nggorok esa reu. Neu ara bei laꞌok numa dalak, boe ma Yesus neu natudu matan neu sara. Yesus mata-aon nasafali ena, tehuu ta dook ka, boe ma ara ralelan. ");
INSERT INTO txq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Basa boe ma dua sara fali reu rafada nonoon nara rae, “Ei nenene dei! Bebeik kara ia, ai bei fo matonggo mia Yesus numa dalak!” Tehuu nonoon nara basa sara raselu rae, “Heeh! Ei boso kada kokolak lelik talo naa!” ");
INSERT INTO txq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Basa boe ma Yesus natonggo no ana nuni kasalahunu esan nara, neu ara ranggatuuk raꞌa-rinu. Ana nahara neu sara nae, “Weeh! Ei langga batum mara seli! Hatahori rafada ei ena rae, ara mete-rita Au no mata deꞌe heli-helin nara ena, tehuu ei ta nau mamahere! Ei mae, basa sara kada kokolak lelik! Naa! Hatematak ia Au mesa ngga mai ena. Memak Au mate ena, tehuu hatematak ia Au asoda fali numa mamates mai ena! Ei mesa ngga mete no ei matam mara leo. ");
INSERT INTO txq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","De hatematak ia ei muste laꞌo ndule basa dae-bafok ia, fo miu mafada basa hatahorir laꞌe-neu Au Tutui Maloleng ia. ");
INSERT INTO txq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hatahori fo mana namahere neu Au, ma ana hambu saranik, neu ko Manetualain tao nasoi-nasodan, fo ana leo seku neu no Manetualain nai nusa tetuk do inggu temak. Tehuu hatahori fo mana ta namahere, neu ko ana hambu hukun, ma Manetualain ta simbok kana nai nusa tetuk do inggu temak, de ana leo kada dea seku neu. ");
INSERT INTO txq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma hatahorir fo mana ramahere neu Au, ara bisa tao tanda heran mata-matak kara, fo basa hatahorir bubuluk rae, sira koasan naa memak numa Manetualain mai. Haꞌi netuduk, neu ko ara bisa husi nitur pake Au nadeng. Neu ko Manetualain fee sara bisa kokolak pake dedeꞌak laen, leo mae ara ta bei ralela dedeꞌak naa. ");
INSERT INTO txq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ma leo mae ara toꞌu mengge karasok, do, ara rinu hambu raso, ara ta hambu sosoek. Boe ma mete ma ara ndae liman nara reu hatahori hedis sara langgan, neu ko ara hai.” ");
INSERT INTO txq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesus kokolak basa no ana nunin nara, boe ma Manetualain soꞌu botik kana hene neni nusa tetuk do inggu temak neu. Nai naa, Yesus dadi neu Manetualain lima konan, fo Dua Sara ranggatuuk toꞌu parenda sama-sama. ");
INSERT INTO txq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Basa boe ma ana nunin nara tungga Ndia parendan. De ara sudi bee reu fo tui-bengga neu basa hatahorir laꞌe-neu Yesus Tutui Malolen. Boe ma Manetualain fee sara koasa fo ara tao basa tanda heran nara fo Yesus nafada elak kara raa. De hatahori noꞌuk ka ramahere neu Yesus, te ara bubuluk ena rae, Tutui Malole naa, memak tebe. Neu ina kateluk kara raa losa Petrus asa ena, boe ma ara rafada basa-basan laꞌe-neu hatahori muri anak naa, fo mana kokolak numa rates ndia bebeik kara raa. Basa boe ma Yesus parenda ana nunin nara fo reu tui-bengga laꞌe-neu Ndia Tutui Malolen ia nai basa mamanak kara losa dae-bafok buꞌun nara. Tutui Malole ia natudu dalak fo Manetualain tao nasoi-nasoda hatahorir numa sala-singgon nara mai fo rasoda seku neu ro Ndia. Tutui Malole ia, memak tetebe ndoos. Huu naa de ana nakatataka nakandoo losa ta namaketu. ");
INSERT INTO txq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Ama Teofilus fo mana hambu hada-horomatak. Soda-molek. Hatahori noꞌuk ka soba surak tutuik laꞌe-neu hata fo ara mori-dadi nai ai taladan nara ena. Ara surak tutuik kara raa, pake tutuik mana koko mafeo-falik numa ai fali neni ai mai seluk, numa fai uluk mai, fo ai bubuluk numa Lamatuak Yesus hatahori uma dalen nara ma numa hatahori laen mai boe fo ara mete-rita ro mata heli-helin nara. Basa tutuik kara raa, tungga tetu-tetu no Manetualain hehelu-bartaan numa lele uluk mai. Dadi au parisa no lutuk basa matak kara raa lalaꞌen mulai numa tutuik oka-huun mai ena. Boe ma au aketu fo surak basa sara ro malole tungga tututin. No dalak naa, papa bisa bubuluk no tetuk hata fo mori-dadi ena. ");
INSERT INTO txq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma papa oo bisa namahere mae, hata fo hatahorir tuik kara raa ena, ta tutui pepeko-lelekok boe. Basa naar, hambu sara tetebes! ");
INSERT INTO txq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tutuik ia oka-huun talo ia: neu manek Herodes toꞌu parenda numa profensi Yudea, hambu hatahori esa, nade Sakaria. Hatahori ia, malangga anggama Yahudi esa. Ma ndia oo bua-aok esa no baꞌi Abia malangga anggaman nara boe. Sakaria saon, nade Elisabet. Ndia oo tititi-nonosik numa malangga anggamar mai boe, huu ndia ia, baꞌi Musa kaꞌan Harun tititi-nonosin. ");
INSERT INTO txq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dua sara leo-laꞌo no ndoos tungga Manetualain parendan ma hohoro-lalanen lalaꞌen. Hatahorir oo fee hada-horomatak neu sara boe. ");
INSERT INTO txq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dua sara oo lasik kara ena boe, tehuu ana taak kara, huu Elisabet ana manan makatemak. ");
INSERT INTO txq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Laꞌe esa, Sakaria no ndia bua-aon Abia sara hambu babaꞌek tao ues numa Uma Huhule-haradoi Ina-huuk nai Yerusalem. ");
INSERT INTO txq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tungga sira siꞌen, malangga anggama raa leꞌa lot fo sangga bubuluk see ndia hambu babaꞌek maso neni Uma Huhule-haradoi Ina-huuk Kama Malalaon Mateꞌen dale neu. Nai naa, hatahori naa muste hotu ai kaboo menik, nai Manetualain matan. Faik naa, lot tuda laꞌe-ndaa Sakaria. ");
INSERT INTO txq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Boe ma ana maso dale neu. Neu ana hotu ai kaboo menik numa Kama naa, hatahori noꞌun seli hule-haradoi numa uma bebelan naa. ");
INSERT INTO txq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Medak neu ma, Manetualain atan esa numa nusa tetuk do inggu temak mai, nambariik numa mamana hotu ai kaboo menik boboan kona. ");
INSERT INTO txq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaria mete-nita naa, boe ma namataꞌu nalan seli, losa ana ta bubuluk nae tao hata ena. ");
INSERT INTO txq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tehuu ata naa kokolak nae, “Sakaria! Boso mamataꞌu, ee! Manetualain namanene nala o huhule-haradoim ena. Dadi neu ko o saom bonggi nala ana touk esa fee o. O muste foin, nade Yohanis. ");
INSERT INTO txq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Neu ko hatahori noꞌuk ka oo ramahoko sama-sama ro ei boe, nahuu ei hambu anak ena. Kakanak ia, neu ko tao nala o dalem mbena sau-sau. ");
INSERT INTO txq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Manetualain Dula-dalen koasan sama-sama noon, mulai numa inan bei fo nairun mai. Ana muste naluli basa laru-ara. Neu ana namoꞌo mamais a, Manetualain paken dadi neu hatahori mana nesi mata. ");
INSERT INTO txq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Neu ko ana kokoe-nanasi hatahori Israꞌel noꞌuk ka fo tungga falik sira Manetualain, fo mana naena haak parenda sara. ");
INSERT INTO txq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ndia hihiru-heheon ma koasan, neu ko sama tetar leo baꞌi Elia fo Manetualain mana toꞌu dedeꞌan numa lele uluk mai. Ana mai nakahuluk numa ita Lamatuan mai. Ana tao nala ina-amar dalen sue-lai rasafali anan nara. Ma hatahori mana masadea Manetualain oo, ana tao nasafali sara fo ara bisa tungga Manetualain hihii-nanaun boe. No dalak naa, ana tao nala hatahorir sadia dalen nara fo simbok Lamatuak mamain.” ");
INSERT INTO txq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tehuu Sakaria naselu nasafali mbali ata naa nae, “Ta bisa dadi?! Au ua au saong lasik talo ia ena! Talo bee de au bisa bubuluk ae, basa iar bisa mori-dadi?” ");
INSERT INTO txq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Boe ma ata naa naselu nae, “Talo ia! Au ia, Nggabarial, Manetualain neondan. Ana ndia nadenu au mai fo afada hara lii malole ia neu o. ");
INSERT INTO txq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tehuu o ta nau mamahere au kokolang. Dadi tandan fo o mokek talo ia! O maam nakadite ma o ta bisa kokolak mala numa hatematak ia neu, losa ei hambu mala kakanak naa. Dei fo o tadu aom leo. Te hata fo au afadak ia, neu ko ana mori-dadi ndaa no fain.” ");
INSERT INTO txq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Hatahori noꞌuk kara fo mana hule-haradoi ruma dea, ara tutundindiik, nahuu Sakaria ta kalua-kalua. ");
INSERT INTO txq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Neu ana dea mai, ana ta bisa kokolak nala hata ena. Boe ma ana dududu a mbali sara nenik liman, de ara bubuluk rae, Manetualain natudu feen tanda heran esa ena, numa Kama Malalaok Mateꞌen naa dale. ");
INSERT INTO txq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Basa sira ue babaꞌen, boe ma Sakaria fali neni uman neu. ");
INSERT INTO txq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Ta dook ka boe ma Elisabet taꞌin naisi. Boe ma ana kama aon losa bulak lima. Ana kokolak nae, “Koa-kio Manetualain! Mateꞌen boe ma Manetualain natudu Ndia dale susuen neu au. Mete ma au hambu tititi-nonosik ena, na, hatahorir ta rakamamaek au ena bali.” ");
INSERT INTO txq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Neu Elisabet taꞌin laꞌok bula nee ena, boe ma Manetualain nadenu atan numa nusa tetuk do inggu temak mai, fo neni nggorok esa nai profensi Galilea neu, nade Nasaret. Ata naa, nade Nggabarial. ");
INSERT INTO txq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nai Nasaret hambu ana feꞌok esa, nade Maria. Maria ia, ta mesa kana, huu touk esa, nade Yusuf fufudin ena. Yusuf naa, mane Dauk tititi-nonosin. Nggabarial neu natonggo no ana feꞌok Maria. ");
INSERT INTO txq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ana natudu aon neu ana feꞌok naa, boe ma nae, “Soda-molek ina! Manetualain here nala o ena, fo nae tao hata neulauk esa neu o. Manetualain sama-sama no o, Maria.” ");
INSERT INTO txq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria namanene nala naa, boe ma ana pangganaa doak ata naa kokolan. Ana ta nalela ata naa kokolan. ");
INSERT INTO txq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Boe ma ata naa tutin bali nae, “Maria! O hae mamataꞌu. Huu Manetualain nae natudu Ndia dale susuen neu o. ");
INSERT INTO txq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ta dook ka bali te o taꞌim naisi ena, de neu ko o bonggi mala ana touk esa. O muste foin, nade Yesus. ");
INSERT INTO txq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Neu ko Ana dadi neu Hatahori moꞌo-inahuuk. Neu ko Manetualain seseik kana nae, ‘Ndia ia, Au Ana heli-heling.’ Fo ndia ia, Manetualain mana Demak Mateꞌen Anan. Neu ko Manetualain soꞌu nalan fo toꞌu parenda, sama leo Ndia baꞌin mane Dauk. ");
INSERT INTO txq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Neu ko Ana ndia toꞌu parenda seku neu soa-neu hatahori Israꞌel asa. Huu Ndia parendan ta mana basak.” ");
INSERT INTO txq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tehuu Maria natane Nggabarial nae, “Au ia, bei ta sunggu-soro ita ua touk esa boe na! De talo bee fo au taꞌing bisa naisi?” ");
INSERT INTO txq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Boe ma Nggabarial naselu nae, “Talo ia! Neu ko Manetualain Dula-dale Malalaon neni o neti. Ma Manetualain mana Demak Mateꞌen koasan, neu ko ana nasaꞌo nala o. No dalak naa, neu ko Kakanak fo o bonggi malak naa, malalao ndoos. Huu Kakanak naa, Manetualain Anan. ");
INSERT INTO txq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Boso heran! O bobonggim esa, nade Elisabet, taꞌin naisi ena boe. Hatahorir rae, ana ta bisa bonggi nala ena, nahuu lasik ena. Hatematak ia taꞌin kaisik ma laꞌok bulak nee ena. ");
INSERT INTO txq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Huu soa-neu Manetualain, basa hata a mesan bisa dadi!” ");
INSERT INTO txq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Boe ma Maria naselu nae, “Malole. Au ia Manetualain atan. Naa fo basa sara dadi tungga papa kokolam naa. Au sadia tungga kada Manetualain hihii-nanaun.” Basa boe ma, ata numa nusa tetuk do inggu temak mai naa laꞌo ela Maria. ");
INSERT INTO txq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Seli fai hida, boe ma Maria lai-lai hiek numa Nasaret mai, neni Sakaria nggoron manai profensi Yudea mbuku leten neu. Losa naa, boe ma ana dudi tutik kana neni Sakaria uman dale neu. De ana lole haran neu Elisabet. ");
INSERT INTO txq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Neu Elisabet namanene Maria haran naa, boe ma kakanak manai Elisabet taꞌin dale naa, natingga-nasaka. Ma Manetualain Dula-dale Malalaon maso neni Elisabet neu. ");
INSERT INTO txq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Boe ma ana nanggou, de nafada nae, “Maria! Neu ko hatahorir soꞌu botik o nadem lena heni basa inak kara marai dae-bafok ia! Neu ko hatahorir oo soꞌu botik Kakanak manai o taꞌim dale naa boe! ");
INSERT INTO txq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Au oo neni soꞌu botik boe, nahuu au Lamatuang inan mai tiro-dangga au. ");
INSERT INTO txq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Neu o mai, de lole haram neu au, boe ma kakanak manai au taꞌing oo natingga-nasaka, huu namahoko boe. ");
INSERT INTO txq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Manetualain natudu dale susuen neu o ena, nahuu o mamahere mae, Ana nau tao tungga Ndia hehelu-bartaan.” ");
INSERT INTO txq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria soꞌuk haran nae, “Numa au dale kuru-erong mai, au akadedemak Lamatuak! ");
INSERT INTO txq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Au daleng mbena sau-sau, nahuu Manetualain tao nasoi-nasoda au! ");
INSERT INTO txq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ana loti-mete natalolole au ena, Ndia hatahori neondan fo sosoan taak ia. Numa hatematak ia neu, basa hatahorir tao au ia leo, ina mana mauak nalan seli, ");
INSERT INTO txq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","nahuu Manetualain tao dedeꞌa heran nara neu au. Ndia naa, mana Koasa Mateꞌen ma Malalao Ndoos. ");
INSERT INTO txq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Manetualain soa natudu dale kasian neu basa hatahorir mana fee hada-horomatak ma rakaluku-rakatele neun, numa tanak esa neni tanak esa neu. ");
INSERT INTO txq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ana pake koasan, fo tao nala hatahori mana koa aok kara ramue-anggik. ");
INSERT INTO txq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ana hai heni hatahori mana toꞌu koasar, nahuu sira nekededema aon nara. Tehuu Ana soꞌu botik hatahori mana makaloloe aok kara. ");
INSERT INTO txq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ana hao-hani hatahori mana ndoe-laꞌak kara losa rakabete, tehuu Ana husi heni hatahori kamasuꞌik kara fo ara laꞌo ro lima roun nara. ");
INSERT INTO txq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ana tulu-fali Ndia hatahori Israꞌel asa, ma soa natudu Ndia dale kasian neu sara. ");
INSERT INTO txq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Lele uluk, Ana ndara fangga hehelu-bartaak no ita bei-baꞌin nara, fo ndia, baꞌi Abraham no basa ndia tititi-nonosin lalaꞌen. Hatematak ia hehelu-bartaak bei neni ndara fanggak seku neu.” ");
INSERT INTO txq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Boe ma Maria leo no Elisabet losa bulak telu. Basa de ana fali neni ndia uman nai Nasaret neu. ");
INSERT INTO txq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Fain losak ka, boe ma Elisabet bonggi nala ana touk esa. ");
INSERT INTO txq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hara liik naa natanggela neni ndia nufanelun ma nggoro isin nara rae, Manetualain natudu dale susuen, de fee anak esa neu Elisabet ena. Boe ma basa sara ramahoko. ");
INSERT INTO txq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Neu kakanak naa bei fo faik falu, boe ma ara sunat ana, tungga hatahori Yahudi hohoro-lalanen. Ara rae foi kakanak naa, nade Sakaria, tungga aman naden. ");
INSERT INTO txq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tehuu inan nareresi nae, “Ta bisa talo naa! Muste nade Yohanis!” ");
INSERT INTO txq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tehuu ara bala rae, “Tao hata de here nadek Yohanis? Ta hambu hatahori esa boe na nai ei nufanelum ndia pake nadek naa!” ");
INSERT INTO txq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Boe ma ara dududuk Sakaria fo sangga bubuluk ana nau foi kakanak naa nade see. ");
INSERT INTO txq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaria dududu fo noke batu lei. Ara feen, boe ma ana surak nae, “Ndia naden Yohanis!” Boe ma basa hatahorir heran bali-bali. ");
INSERT INTO txq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Medak neu ma, Sakaria maan mana barakaik naa, bangganaꞌu tutik kana. Boe ma ana soꞌuk koa-kiok neu Manetualain. ");
INSERT INTO txq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Basa hatahorir fo mana leo deka-deka rai naa, ramataꞌu ma heran. Boe ma tutuik naa natanggela numa bafak mai neni bafak neu, losa hatahorir marai profensi Yudea leten nara oo bubuluk boe. ");
INSERT INTO txq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hatahorir fo mana ramanene tutuik naa duduꞌa rae, “Manggaledok ena, Manetualain koasan sama-sama no kakanak naa. Neu ko namoꞌo mamais a, ana dadi neu hatahori dae-bafok rupak leo beek, ou?” ");
INSERT INTO txq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Basa boe ma Manetualain Dula-dale Malalaon maso neni Sakaria neu. Huu naa de ana kokolak nae, ");
INSERT INTO txq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Koa-kio Lamatuak, hatahori Israꞌel Manetualain! Ana mai ena fo tefa-soi nala Ndia hatahorin nara, mita fo ara boso sama leo ata-dator bali. ");
INSERT INTO txq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Manetualain soꞌu nala Hatahori esa ena fo Ndia koasan ta neni babanggak, fo neu ko Ana tao nasoi-nasoda ita. Ndia ia, numa baꞌi Dauk tititi-nonosin mai. ");
INSERT INTO txq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Manetualain helu-bartaa memak basa iar ruma lele uluk mai ena, pake Ndia mana toꞌu dedeꞌan fo dalen mahanik kara. ");
INSERT INTO txq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Hatematak ia Ana nau nakamboꞌik ita numa ita musun nara mai, ma numa hatahorir fo dalen nara mburuk neu ita mai. ");
INSERT INTO txq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Ana natudu Ndia dale susuen neu ita bei-baꞌin nara, nahuu Ana nasaneda taa-taa neu Ndia hehelu-bartaan neu sara, fo Ana ndara fangga no baꞌi Abraham. ");
INSERT INTO txq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ana nakamboꞌik ita numa ita musun nara mai ena, fo ita bisa takaluku-takatele neun, ma ta parluu tamataꞌu bali. ");
INSERT INTO txq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ana nakamboꞌik ita ena, mita fo ita bisa leo-laꞌo nai matan no lolo-laok ma ndoos seku neu. ");
INSERT INTO txq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Anis! O ia, Au anang. Neu ko hatahorir ralela o rae, o ia, Manetualain mana Demak Mateꞌen mana toꞌu dedeꞌan. Neu ko o muu mafada hatahorir, fo ara simbok Lamatuak mamain no dale malenggak. ");
INSERT INTO txq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Neu ko o muu matudu dalak neu Manetualain hatahorin nara, fo ara bubuluk rae, ara hambu masoi-masodak, nahuu Manetualain koka heni sala-singgon nara. ");
INSERT INTO txq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Huu Manetualain dalen bangganaꞌu ma tuda kasian neu ita, de Ana fee lelak beuk neu ita, sama leo fai beuk neni manggaledo beuk. Ita mana leo-laꞌo nai makiuk dale, ma ita mana tamataꞌu mamates, nahuu bei ta malole to Manetualain, neu ko hambu manggaledok fo nakalalaꞌok ita teni dala mole-dame teu.” ");
INSERT INTO txq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Basa boe ma Yohanis tamba faik boe namoꞌo. Ma Manetualain Dula-dalen tao natetean. Ana namoꞌo mamais a, boe ma neu leo numa mamana nees, losa ana mulai tao uen soa-neu hatahori Israꞌel asa. ");
INSERT INTO txq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Laꞌe esa, neu Kirenius dadi neu nggubenor numa Siria, boe ma mane ina-huuk, nade Agustus fee kalua parenda esa nae, “Basa hatahorir marai man-parenda Roma koasan, muste fali nggoro-tadun nara reu, fo tungga sensus!” Naa, ndia makasososan fo man-parenda Roma reke rau-inggun nara. ");
INSERT INTO txq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","De basa hatahorir fali nggoro-tadun nara reu fo tungga sensus. ");
INSERT INTO txq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Faik naa, Yusuf leo numa nggoro Nasaret nai profensi Galilea. Ana fufudi ana feꞌok esa ena, nade Maria, fo taꞌin kaisik. Yusuf naa, mane Dauk tititi-nonosin, de ana muste fali neni Dauk kotan Betlehem neu nai profensi Yudea, fo tungga sensus. Huu naa de dua sara laꞌo reni kota Betlehem reu. ");
INSERT INTO txq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Neu ara ruma naa, Maria fain fo sangga nae bonggi losa ena. ");
INSERT INTO txq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tehuu numa naa ara ta hambu kama sesebak nai uma leo taak ena. Huu naa de ara dudi reni lalae esa dale reu. De ana bonggi Ana makasososan, Ana tou anak. Boe ma ara ralusen renik tema nelusek, fo rasusunggun neu haꞌo dale. ");
INSERT INTO txq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Leꞌodaen naa, hambu mana lolo hida beꞌe ranea sira bibihie-bibilombon numa mook nai kota deak. ");
INSERT INTO txq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Medak neu ma, ara mete-rita Manetualain atan numa nusa tetuk do inggu temak mai. Boe ma Lamatuak saꞌan nasaꞌa ndule basa sara, de ramataꞌu ralan seli. ");
INSERT INTO txq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tehuu ata naa nafada nae, “Ei boso mamataꞌu dei! Nenene matalolole, ee! Au mai fo nau afada ei hara lii malole esa. Basa mana namanene hara liik ia, neu ko ramahoko. ");
INSERT INTO txq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hara lii malole ia liin talo ia: Faik ia inak esa bonggi nala Karistus ena nai Betlehem, nai mane Dauk kotan. Karistus naa, Hatahori fo Manetualain helu-bartaa memak kana numa lele uluk mai. Manetualain nadenun mai fo Ana tao nasoi-nasoda hatahori numa sala-singgon nara mai! Ndia ia, neu ko hatahorir roken rae, ‘Lamatuak’, te Ana ndia naena haak parenda basa-basan! ");
INSERT INTO txq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dei fo ei malelan no dalak talo ia: ei matonggo mia Kana mbimbila anak esa neni nelusek no tema nelusek. Ana sunggu nai haꞌo bandar dale.” ");
INSERT INTO txq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ata naa kokolak basa boe ma, medak neu ma Manetualain atan noꞌun seli numa nusa tetuk do inggu temak mai fo rakabubua roon. Boe ma ara koa-kio Manetualain ma soda rae, ");
INSERT INTO txq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ai makadedemak Manetualain naden! Ndia mana toꞌu parenda nai lalai fo demak mateꞌen. Manetualain nau fee mole-dame soa-neu hatahorir marai dae-inak, fo mana tao ramahoko Ndia dalen!” ");
INSERT INTO txq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Basa boe ma Manetualain atan nara fali reni nusa tetuk do inggu temak reu. Boe ma mana lolor raa kokolak rae, “Wee! Mai ita teni Betlehem teu, fo teu mete-tita Kakanak naa dei! Te Lamatuak haitua harak naa neu ita ena.” ");
INSERT INTO txq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Boe ma ara laꞌo lai-lai hiek reni Betlehem reu. De ratonggo ro Maria ma Yusuf. Ma ara oo mete-rita Kana mbimbila anak naa, sunggu nai haꞌo dale boe. ");
INSERT INTO txq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Neu ara mete-rita Kakanak naa, boe ma ara tui rae, “Bebeik kara ia, Manetualain atan nara ruma nusa tetuk do inggu temak mai rafada laꞌe-neu Kakanak ia neu ai ena!” Boe ma ara tui no lutuk losa basan. ");
INSERT INTO txq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Basa hatahorir heran bali-bali, ramanene mana lolor raa tutuin. ");
INSERT INTO txq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tehuu Maria mbedan neu dalen, basa mandadik kara raa. Ana duduꞌa no neneek fo nae sangga bubuluk sosoa-ndandaan hata. ");
INSERT INTO txq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Basa de mana lolor fali reni sira bibihie-bibilombon nara reu. Boe ma ara rakadedemak Manetualain naden. Ara roke makasi neun, huu hata fo ramanenek ma mete-ritak naa, sama tetar no hata fo Manetualain atan nafadak naa ena. ");
INSERT INTO txq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bonggi basa fai falu, boe ma ara sunat Kana mbimbila anak naa tungga baꞌi Musa hohoro-lalanen. Ina-aman foin, nade ‘Yesus’. Nadek naa, ndia nadek fo ata numa nusa tetuk do inggu temak mai nafada sara ena, neu inan bei ta nairun. ");
INSERT INTO txq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hambu hohoro-lalanek esa numa baꞌi Musa mai nae, ina mana bonggi basak fai haa hulu ena muste neu tao tungga dala-hadak nelao aok nai Uma Huhule-haradoi Ina-huuk. No dalak naa, ara bisa maso uma huhule-haradoik leo biasa. Huu naa de Yusuf no Maria reni Yerusalem reu fo tao tungga dala-hadak naa. De ara roo sira Ana mbimbila anan naa neni Uma Huhule-haradoi Ina-huuk dale neu, fo loo liman dadi neu Lamatuak enan. ");
INSERT INTO txq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ara tungga Lamatuak hohoro-lalanen fo rae, “Inak esa-esak fo mana bonggi ana makasososak, mete ma tou anak, na, ana muste loo lima kakanak naa dadi neu Lamatuak enan.” ");
INSERT INTO txq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tungga Lamatuak hohoro-lalanen, mete ma loo lima kakanak neu Lamatuak, na, ina-aman muste fee mbui teu pasan esa do mbui lunda sina tenak dua. Huu naa de Yusuf no Maria oo tao tungga hohoro-lalanek naa boe. ");
INSERT INTO txq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Faik naa, hambu baꞌi esa, nade Simeon, leo numa kota Yerusalem. Hatahori ia, dalen ndoos ma dalen hii nalan seli neu Manetualain. Manetualain Dula-dale Malalaon nafadan ena nae, ana mete-nita Karistus dei fo ana mate. Karistus naa, ndia neu ko tao masoi-masodak neu hatahori Israꞌel asa. ");
INSERT INTO txq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Faik naa, Manetualain Dula-dalen nuni no Simeon neni Uma Huhule-haradoi Ina-huuk neu. Naa, nandaa no Yesus ina-aman roon neni naa neu, fo loo liman dadi neu Lamatuak enan. ");
INSERT INTO txq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Baꞌi Simeon mete-nita Kakanak naa, de ana koꞌo nalan, boe ma ana koa-kio Manetualain nae, ");
INSERT INTO txq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Koa-kio Manetualain! Manetualain tao tungga Ndia hehelu-bartaan neu au ena. Dadi hatematak ia Manetualain bisa nakamboꞌik au, mita fo au bisa mate no mole-damek, ");
INSERT INTO txq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","huu au mete-ita Hatahori fo Manetualain nadenun mai ena, fo tao nasoi-nasoda ai numa ai sala-singgon nara mai! ");
INSERT INTO txq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Manetualain nae pake Kakanak ia fo tao nasoi-nasoda basa hatahori nusa-nusak kara. ");
INSERT INTO txq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Neu ko Ana sama leo saꞌak, fo neni hada-horomatak soa-neu Manetualain hatahorin Israꞌel asa. Ana oo sama leo manggaledok boe, fo natudu Manetualain eno-dalan soa-neu basa hatahori nusa-nusak laen nara.” ");
INSERT INTO txq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yusuf no Maria ramanene rala naa, boe ma ara heran bali-bali neu hata fo baꞌi Simeon kokolak laꞌe-neu sira Anan. ");
INSERT INTO txq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Basa naa Simeon fee babaꞌe-babatik neu sara. Boe ma nafada Maria nae, “Yesus inan, ee! Neu ko hatahori noꞌuk ka rai Israꞌel timba-ndundu heni ina Anan ia. Tehuu sira tatao-nonoꞌin neun naa, neu ko natuda falik kasa. Ina Anan ia oo tao nala hatahori noꞌuk ka dalen mbena sau-sau boe. ");
INSERT INTO txq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","No dalak naa, neu ko Manetualain buka nakambela hatahorir dalen. Tehuu Maria, neu ko o hambu susa-sona moꞌok, nok bali mbau dombe tafak neu o tende boam.” ");
INSERT INTO txq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Numa Uma Huhule-haradoi Ina-huuk oo hambu ina lasik esa boe, nade Hanaa. Teun nara falu hulu haa. Aman, nade Fanuel, numa leo Aser mai. Ana nauma-loo teuk hitu, boe ma saon mate laꞌo elan. Beꞌa Hanaa ia, Manetualain mana toꞌu dedeꞌan. Ue-tataon soa hule-haradoi ma puasa nai Uma Huhule-haradoi Ina-huuk, fo nakaluku-nakatele neu Manetualain hatu-leledon. ");
INSERT INTO txq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Neu Simeon kola-kola no Yusuf ma Maria, ina lasik naa mai deka-deka. De ana namanene sara, boe ma ana koa-kio Manetualain. De ana kokolak laꞌe-neu Yesus soa-neu basa hatahori mana rahani Manek fo Manetualain helu-bartaa ena nae, nau nadenun mai fo nakamboꞌik hatahori Israꞌel asa. ");
INSERT INTO txq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Neu Yusuf no Maria tao tungga basa baꞌi Musa hohoro-lalanen lalaꞌen numa kota Yerusalem ena, boe ma ara fali reni profensi Galilea reu, nai sira nggoron Nasaret. ");
INSERT INTO txq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yesus oo namoꞌo mamais a boe, Ana tamba nakadere, tamba nalela ma Ana bubuluk dalak noꞌuk ka. Manetualain oo natudu dale susuen neun boe. ");
INSERT INTO txq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tungga teuk, Yusuf no Maria reni kota Yerusalem reu, fo raꞌa feta Paska numa naa. ");
INSERT INTO txq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Laꞌe esa, neu Yesus teun nara salahunu dua, ara oo laꞌok sama-sama reni Yerusalem reu fo tungga feta naa leo biasa boe. ");
INSERT INTO txq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Fai Paska nateꞌe, boe ma Yusuf no Maria laꞌok fali reni Nasaret reu rambalololok ro hatahori noꞌuk ka, fo fali reni Galilea reu. Tehuu ara ta bubuluk laꞌo ela Yesus numa Yerusalem. Ara duꞌa rae, fama te Yesus nambalololok no nonoon nara. Tehuu losa bobok, ara ta mete-rita sana. Boe ma ara mulai sangga reu-mai, ndule basa bobonggin nara ma nonoon nara. ");
INSERT INTO txq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Huu ara ta ratonggo roon, de ara lenggu fali reni Yerusalem reu, fo rae sanggan nai naa. ");
INSERT INTO txq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Losa naa, ara sanggan losa faik telu dalen, dei de ratonggo roon numa Uma Huhule-haradoi Ina-huuk dale. Ana nanggatuuk nakaseseluk dedeꞌak no meser anggama Yahudir. ");
INSERT INTO txq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Basa hatahori mana mamanenek kara heran bali-bali, nahuu Ana bubuluk tebe-tebe Manetualain Susuran isin ma Ana bisa naselu nala sira netatanen nara no neulauk. ");
INSERT INTO txq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ina-aman mete-rita talo naa, boe ma ara heran. De inan nae, “Yesus! Tao hata de O tao mala ai sota talo ia? O amam ma au pangganaa doak ma maputa-piok miu-mai sangga O!” ");
INSERT INTO txq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tehuu Yesus naselu nae, “Tao hata de mama no papa sota ma susa sangga Au? Bubuluk ena, hetu? Au aena ues nai Au Amang Uman.” ");
INSERT INTO txq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tehuu ara ta bubuluk no tetuk hata fo Ana kokolak naa. ");
INSERT INTO txq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Boe ma basa sara fali reni Nasaret reu. Yesus tao tungga Ndia inan no aman parendan. Boe ma inan mbeda basa mandadik kara raa neu dalen. ");
INSERT INTO txq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Leo naak ena Yesus oo namoꞌo mamais losa Ana dadi taꞌe ana, tamba nalela leo-laꞌo neulauk boe. Manetualain ma hatahorir oo sue-lai neun boe. ");
INSERT INTO txq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Faik naa, Tiberius dadi neu mane ina-huuk mana toꞌu parenda numa Roma teuk salahunu lima ena. Pontius Pilatus dadi neu nggubenor numa profensi Yudea. Herodes dadi neu nggubenor numa profensi Galilea. Herodes kaꞌan Felipus dadi neu nggubenor numa profensi Iturea ma profensi Trakonitis. Ma Lisanias dadi neu nggubenor numa profensi Abilene. Faik naa oo Hanas ma Kayafas dadi reu malangga anggama Yahudi malangga ina-huun nai kota Yerusalem boe. Faik naa, Yohanis fo Sakaria anan naa, leo numa mamana nees dook ka numa nggorok mai. Numa naa Manetualain feen hara heheluk. ");
INSERT INTO txq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohanis namanene basa, boe ma ana laꞌok neni basa nggoro mana deka-deka lee Yarden fo nafada hatahorir nae, “Ei muste manaku ma laꞌo ela basa sala-singgom mara fo Manetualain koka heni basa sala-singgok kara raa. Basa naa ei muste sarani dei, fo dadi tanda nae, ei malole mia Manetualain ena.” ");
INSERT INTO txq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Lele uluk Manetualain mana toꞌu dedeꞌan baꞌi Yesaya surak laꞌe-neu Yohanis ia nae, “Hambu hatahori nai mamana nees eki nae, ‘Basa hatahorir mahehere tao malole dalak fo simbok Lamatuak mamain! Tao matetetu dalak fo simbok kana. ");
INSERT INTO txq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Fua matetu dokek kara. Fera matetu letek kara. Tao mandoo dala peko-pakik kara, tao manggatusi dala mana duku-leꞌuk kara. ");
INSERT INTO txq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mita fo basa hatahori nusa-nusak kara bisa bubuluk rae, Manetualain nau tao nasoi-nasoda hatahori numa sira sala-singgon mai.’ ” ");
INSERT INTO txq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hatahori noꞌuk ka sudi ruma bee mai, fo roke Yohanis sarani sara. Tehuu ana mboka sara nae, “Heeh! Ei mana pepeko-lelekok! Ei sama leo mengge karasok! Boso duꞌa mae ei bisa makamboꞌik numa Manetualain huku-dokin mai, no ei kekedik mae ei sale dalem do tuke teim mara! Taa! Ta dook ka ena, te Manetualain huku-doki basa hatahorir ta mana sale dalen do tuke tein nara no tebe-tebe. ");
INSERT INTO txq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ei boso duꞌa mae, ‘Au ta hambu huku-dokik, nahuu au ia, baꞌi Abraham tititi-nonosin.’ Hambu nai bee dadi talo naa? Naa, ta bisa tulu-fali ei, nahuu ta tao nala ei dadi miu hatahori lolo-laok. Manetualain bisa tao nala batur ia dadi reu baꞌi Abraham tititi-nonosin. Au afada, ee! Matudun tungga ei leleo-lalaꞌom mara mae, ei masadea laꞌo ela ei sala-singgom mara ena, ma tungga falik Manetualain ena. ");
INSERT INTO txq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ei muste tao hata fo neulauk. Mete ma taa, na, Manetualain huku-doki beran tuda laꞌe ei, sama leo hatahori pake taka fo hungga heni ai huuk numa okan mai. Leo naak ena! Ai huuk sosoan ta ena, mete ma buna-boan ta neulauk. Dadi malole lenak hungga henin, fo pirun neni aꞌi dale neu.” ");
INSERT INTO txq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Basa de hatahori noꞌuk kara raa ratane Yohanis rae, “De ai muste tao hata?” ");
INSERT INTO txq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Boe ma ana naselu nae, “Mete ma o badum dua, na, fee esa neu hatahori badu taak. Mete ma o kananaꞌak, na, baꞌe fee hatahori nanaꞌa taak kara.” ");
INSERT INTO txq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Boe ma mana susu bear mai fo roke Yohanis sarani sara. Ara ratane rae, “Papa Meser! Ai muste tao talo bee?” ");
INSERT INTO txq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ana naselu nae, “Ei soa puputa-papata. Tehuu hatematak ia, ei muste maue-osa no ndoos. Boso puku bea lenak numa man-parenda hohoro-lalanen mai. Mita fo rau-inggu bae bea ndaa no hohoro-lalanen.” ");
INSERT INTO txq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Hambu soldadu hida ruma naa boe. Ara ratane Yohanis rae, “Mete ma ai, na, talo bee? Ai muste tao hata?” Boe ma ana naselu nae, “Boso pakanaꞌe mala hatahorir doin tungga ei hihiim. Ma boso makasasaꞌek salak neu hatahori no bolo-dalan taa. Ei muste moke makasi ma mameda dai no simbo katemak ei nggadim.” ");
INSERT INTO txq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Basa hatahorir ramanene rala kokolan naa, boe ma esa kei esa ma kutu-nuꞌu rae, “Awii! Fama te Yohanis ia, Karistus fo Manetualain helu-bartaa nae nadenun mai numa lele uluk mai ena!” ");
INSERT INTO txq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tehuu Yohanis nafada sara nae, “Nenene matalolole! Neu ko hambu Hatahori esa ta neni babanggak lena heni au nae mai. Leo mae dadi uu kada Ndia nedenun oo, au ta andaa boe. Au bisa sarani ei pake kada oe, tehuu neu ko Ana tao lena heni au bali, ndia Ana tao nasofe ei dalem mara no Manetualain Dula-dale Malalaon. Neu ko Ana tao nalalao ei, sama leo hatahorir hotu dafu dae pake aꞌi. ");
INSERT INTO txq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ana hukun hatahori mana tao salak kara, sama leo mana ue dae kukuru anin fo bingga feꞌe hade neuk numa hade langgak kara mai. Boe ma ana mbeda hade neuk neni soka dale neu ma hotu heni hade langgak kara. Leo naak oo Karistus hukun hatahori kasalak kara, ma piru sara reni aꞌi mbila ta kala matek dale reu boe.” ");
INSERT INTO txq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","No dalak naa, Yohanis fee nesenedak neu hatahori laꞌe-neu dedeꞌak mata-matak kara, ma nafada sara Manetualain Hara Lii Malolen. ");
INSERT INTO txq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Faik naa, Yohanis oo mulai kokolak no manggaledon laꞌe-neu Herodes tatao-nonoꞌin boe. Dedeꞌak naa talo ia: Herodes ia, nggubenor nai profensi Galilea. Salan malunu ndoos. Haꞌi netuduk leo, ana leꞌa neni fadin saon, nade Herodias. Naa te fadin bei masodak, ma bei ta namaketu no Herodias. Herodes leleo-lalaꞌo ta neulaun naa, tao nala Yohanis kaꞌin no ledo-ledo, losa Herodes doak neun. Boe ma Herodes humu nala Yohanis, de ana teen neni bui dale neu. ");
INSERT INTO txq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Fai bakahulun, neu ara bei ta humu rala Yohanis, ana sarani hatahori noꞌuk ka. Ma ana oo sarani Yesus boe. Basa naa Yesus hule-haradoi, boe ma lalai natahuka. ");
INSERT INTO txq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","De Manetualain Dula-dale Malalaon konda neni Yesus neu. Dula-dalek naa mata aon dadi sama leo mbui lunda sina. Basa de hambu harak numa lalai mai nae, “O ia, Au Ana susueng. O soa tao mamahoko Au.” ");
INSERT INTO txq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Neu Yesus mulai tui-bengga hatahorir laꞌe-neu Manetualain eno-dala sodan, Ndia teun nara, fama te teuk telu hulu. Hatahorir bubuluk rae, Yesus ia, Yusuf anan. Yusuf bei-baꞌin nara, sira: Yusuf aman, Eli. ");
INSERT INTO txq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli aman, Matat. Matat aman, Lewi. Lewi aman, Melki. Melki aman, Yanai. Yanai aman, Yusuf. ");
INSERT INTO txq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf aman, Matatias. Matatias aman, Amos. Amos aman, Nahum. Nahum aman, Hesli. Hesli aman, Nagai. ");
INSERT INTO txq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai aman, Maat. Maat aman, Matatias. Matatias aman, Semein. Semein aman, Yosek. Yosek aman, Yoda. ");
INSERT INTO txq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda aman, Yohanan. Yohanan aman, Resa. Resa aman, Serubabel. Serubabel aman, Sealtiel. Sealtiel aman, Neri. ");
INSERT INTO txq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri aman, Melki. Melki aman, Adi. Adi aman, Kosam. Kosam aman, Elmadam. Elmadam aman, Er. ");
INSERT INTO txq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er aman, Yosua. Yosua aman, Elieser. Elieser aman, Yorim. Yorim aman, Matat. Matat aman, Lewi. ");
INSERT INTO txq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi aman, Simeon. Simeon aman, Yahuda. Yahuda aman, Yusuf. Yusuf aman, Yonam. Yonam aman, Elyakim. ");
INSERT INTO txq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim aman, Melea. Melea aman, Mena. Mena aman, Matata. Matata aman, Natan. Natan aman, Dauk. ");
INSERT INTO txq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dauk aman, Isai. Isai aman, Obet. Obet aman, Boas. Boas aman, Salmon. Salmon aman, Nahason. ");
INSERT INTO txq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason aman, Aminadab. Aminadab aman, Admin. Admin aman, Arni. Arni aman, Hesron. Hesron aman, Peres. Peres aman, Yahuda. ");
INSERT INTO txq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda aman, Yakob. Yakob aman, Isak. Isak aman, Abraham. Abraham aman, Tera. Tera aman, Nahor. ");
INSERT INTO txq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor aman, Seruk. Seruk aman, Rehu. Rehu aman, Pelek. Pelek aman, Eber. Eber aman, Sela. ");
INSERT INTO txq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela aman, Kenan. Kenan aman, Arpaksad. Arpaksad aman, Sem. Sem aman, Noh. Noh aman, Lamek. ");
INSERT INTO txq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek aman, Metusalak. Metusalak aman, Henok. Henok aman, Yared. Yared aman, Mahalalel. Mahalalel aman, Kenan. ");
INSERT INTO txq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan aman, Enos. Enos aman, Set. Set aman, Adam. Adam ia, Manetualain ana nekedadadin. ");
INSERT INTO txq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yohanis sarani basa Yesus, boe ma Yesus laꞌo ela lee Yarden. Manetualain Dula-dale Malalaon sama-sama noon. Boe ma Dula-dalek naa nuni no Yesus neni mamana nees neu. ");
INSERT INTO txq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesus leo numa naa losa faik haa hulu. Faik naa Yesus ta naꞌa hata esa boe na, de Ana ndoe nalan seli. Boe ma nitur malanggan mai soba-doun fo sangga nae iken. ");
INSERT INTO txq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ana kokolak mbali Yesus nae, “Mete ma tebe-tebe Manetualain Anan O, na, O maena koasa. De madenu batur ia dadi roti fo O muꞌa sara leo.” ");
INSERT INTO txq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tehuu Yesus naselu nae, “O nanaum talo bee, ia! Ta bubuluk, do? Sama leo neni surak nai Manetualain Susura Malalaon dale nae, ‘Hatahori dae-bafok ta nasoda numa kada nanaꞌak mai, hetu!’ ” ");
INSERT INTO txq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","Basa boe ma nitur malanggan nuni no Yesus neni mamana demak esa neu, de natudun basa man-parenda manai dae-inak no basa nula-napun lalaꞌen. Boe ma ana kokoe Yesus nae, “Basa man-parendar ro sira koasan lalaꞌen naa, au enang basa naar. Leo naak oo, no basa ndia nula-napun boe! De au aena haak fee neu see, fo au nau. ");
INSERT INTO txq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Au nau fee basa sara reu O. Tehuu O tao matak esa dei, dei fo au fee. Muda hiek! O makaluku-makatele neu kada au. Kada naa!” ");
INSERT INTO txq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tehuu Yesus naselu mbalin nae, “Hambu nai bee talo naa? Sama leo neni surak nai Manetualain Susura Malalaon nae, ‘O muste makaluku-makatele neu kada Manetualain. Ma o muste maono-lalau neu kada Ndia.’ ” ");
INSERT INTO txq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Basa boe ma nitur malanggan nuni no Yesus neni kota Yerusalem neu. Numa naa, ana nuni no Yesus hene reni mamana demak mateꞌen manai Uma Huhule-haradoi Ina-huuk reu. Boe ma ana nae, “Mete ma tebe-tebe Manetualain Anan O, na, boke dae muu leo! ");
INSERT INTO txq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sama leo neni surak nai Manetualain Susura Malalaon nae, ‘Dei fo Manetualain nadenu Ndia atan nara ruma nusa tetuk do inggu temak mai, fo ranea O. ");
INSERT INTO txq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Neu ko ara mai ratanee rala O, mita fo O eim ta koi laꞌe batu faa boe na.’ ” ");
INSERT INTO txq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tehuu Yesus naselu nae, “Boso papata Au. Sama leo neni surak nai Manetualain Susura Malalaon dale nae, ‘Boso soba-dou Manetualain!’ ” ");
INSERT INTO txq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nitur malanggan soba-dou Yesus no dalak mata-matak kara, tehuu ana ta nala sana. Boe ma ana laꞌo ela Yesus, fo nahani fai neulauk dei. ");
INSERT INTO txq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Basa boe ma Yesus fali neni profensi Galilea neu, ma Manetualain Dula-dale Malalaon fee koasa neun. Ta dook ka boe ma hatahorir marai nusak naa, mulai ralela Ndia naden. ");
INSERT INTO txq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ana fee nenorik numa hatahori Yahudi uma huhule-haradoin nai bee a mesan. Boe ma hatahorir koa-kion rae, “Yesus naa, Hatahori ta neni babanggak, ee!” ");
INSERT INTO txq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Laꞌe esa, Yesus neni ndia nggoron Nasaret neu. Ndaa no hatahori Yahudir fai huhule-haradoin, ndia ‘fai Sabat’, Ana maso neni uma huhule-haradoik neu, tungga Ndia siꞌen. De Ana nambadeik fo nae lees numa Manetualain Susura Malalaon mai. ");
INSERT INTO txq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Boe ma ara loo feen baꞌi Yesaya susuran. Ana buka susurak naa de sangga lalanek, ma lees nae, ");
INSERT INTO txq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Manetualain Dula-dalen koasan nai Au. Huu naa de Ana henggenee memak Au, fo tui-bengga Lamatuak Hara Lii Malolen neu hatahori kasian nara. Ana nadenu Au ena, fo afada ae, mana nai buir, neu ko hambu nekemboꞌik; pokek kara, neu ko bisa mete-rita rasafali; mana hambu tuni-ndenik kara, neu ko leo-laꞌo no nekemboꞌik. ");
INSERT INTO txq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Hatematak ia Lamatuak fain losa ena, fo tao nasoi-nasoda Ndia hatahorin nara.” ");
INSERT INTO txq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lees basa susurak naa, boe ma Yesus lulu falik kana de loon neu mana koladu uma huhule-haradoik, basa de Ana nanggatuuk. Basa hatahorir maruma uma huhule-haradoik naa, mete raherek kana. ");
INSERT INTO txq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Boe ma Ana nafada sara nae, “Hata fo ei mamanenen numa Manetualain Susura Malalaon mai naa, hatematak ia dadi ena!” ");
INSERT INTO txq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Boe ma basa hatahorir maruma naa mulai koa Yesus rae, “Awii! Hata fo Ana kokolak bebeik kara ia, neulau ndoos. Tehuu Ndia ia, Usu Anan, hetu? Talo bee de ana bisa talo ia?” ");
INSERT INTO txq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Boe ma Yesus nafada sara nae, “Ei basa ngga bubuluk ena hambu dedeꞌak nae, ‘Heeh, doter! Puli mala o ao heli-helim dei!’ Ei mae pake dedeꞌak naa, fo ndee masafali neu Au mae, ‘Tao hata de O ta tao tanda heran esa boe na soa-neu ai marai ia, fo sama leo O taok numa kota Kapernaum naa?’ ");
INSERT INTO txq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ndoon talo ia: hatahori ta nau simbok Manetualain mana toꞌu dedeꞌan nai ndia nggoro-tadu heli-helin. ");
INSERT INTO txq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Haꞌi netuduk numa Manetualain mana toꞌu dedeꞌan baꞌi Elia mai. Laꞌe esa, udan ta konda teuk telu seserik ena. Lelek naa, hambu ina falu noꞌuk ka ruma Israꞌel. Tehuu Manetualain ta nadenu Elia fo tulu-fali sara. Manetualain nadenun neni kada ina falu esa numa nggorok Sarfat neu deka no kota Sidon. Naa te ina lasik naa, ta hatahori Yahudi. Tehuu ana namahere Manetualain koasan. ");
INSERT INTO txq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Haꞌi netuduk laen numa Manetualain mana toꞌu dedeꞌan Elisa mai. Lelek naa, hatahori Yahudi noꞌuk ka hambu hedi kusta ruma Israꞌel. Tehuu Manetualain ta fee hahaik neu sara. Manetualain nadenu Elisa fo tao nahai kada hatahori kusta esa, nade Naaman. Naa te ndia naa, hatahori Siria, ta hatahori Yahudi. Tehuu ana namahere Manetualain koasan.” ");
INSERT INTO txq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Neu ara ramanene rala Yesus kokolan naa, boe ma basa sara lurin. ");
INSERT INTO txq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Boe ma basa sara rambadeik randaa, de ara husi heni Yesus numa uma huhule-haradoik naa mai. Boe ma ara leꞌa roon neni nggorok tatain neu, fo rae timba nggarin neni mbiak manai naa dale neu. ");
INSERT INTO txq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tehuu Ana laꞌo dea neu nesi kada hatahori noꞌuk kara talada heon, de laꞌo ela sara ruma naa. ");
INSERT INTO txq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Basa boe ma Yesus konda neni Kapernaum neu nai dano Galilea tatain. Tungga-tungga fai huhule-haradoik, Ana nanori hatahorir rai uma huhule-haradoik dale. ");
INSERT INTO txq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Hatahorir heran bali-bali nenene Ndia kokolan, huu Ana bubuluk no tetuk nenorik kara raa isin. ");
INSERT INTO txq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Laꞌe esa, neu Yesus fee nenorik numa uma huhule-haradoik naa, hambu hatahori fo nitu saꞌek esa mulai bolu tingga-tingga nae, ");
INSERT INTO txq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hoi! Yesus Hatahori Nasaret, ee! O mai tao hata mua ai nai ia! O mai fo mae makalulutu ai, do? Ai malela O. O ia, Hatahori Malalaok fo lele uluk Manetualain helu-bartaa nae nadenun mai.” ");
INSERT INTO txq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tehuu Yesus mbokan nae, “Makatema o bafam! Kalua numa hatahori naa mai!” Medak neu ma, nitu naa fae nggari hatahori naa neu daer numa hatahorir taladan mai. Basa boe ma nitu naa kalua laꞌo ela hatahori naa, ma ana ta tao nahedi sana. ");
INSERT INTO txq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Basa hatahori bafan nara bese mboo, de rae, “Heran, ee! Hatahori ia kokolan naena koasa ta neni babanggak! Losa neu nitu oo tungga parendan boe, de kalua numa hatahori mai!” ");
INSERT INTO txq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Boe ma tutuik laꞌe-neu Yesus mulai natanggela nai basa mamanak kara marai nusak naa. ");
INSERT INTO txq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ara kalua numa uma huhule-haradoik naa mai, boe ma Yesus neni hatahori esa uman neu. Hatahori naa nade Simon. Simon ari-inan hambu hedi sumaik, de ao-inan natobi roo-roo. Boe ma ara roke-hule Yesus rae, “Papa! tulun tao mahai ina lasik dei!” ");
INSERT INTO txq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesus neu nambariik deka neu mamana susungguk tatain, boe ma Ana husi kalua heni hedi sumaik numa ina lasik mai. Hatematak naa oo hedi sumain mopon tutik ka boe. Boe ma nambadeik tutik ka, de neu sadia nanaꞌak fee sara. ");
INSERT INTO txq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bobon naa, neu ledo sangga nae tesa ena, hatahorir roo basa hatahori hedis sara reni Yesus reu. Hedin nara mata-matak kara. Boe ma Ana nafaroe hatahori hedis sara raa, de tao nahai basa sara. ");
INSERT INTO txq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Numa hatahori hedis sara raa mai oo, hambu hida nitu saꞌek kara boe. De Yesus parenda nitur raa, fo kalua numa hatahorir raa mai. Ara kalua ma bolu rae, “O ia, Manetualain Anan!” Nitur raa bubuluk rae, Ndia ia, Karistus fo Manetualain helu-bartaa memak kana numa lele uluk mai ena fo nae nadenun mai. De Yesus kaꞌi sara fo boso kokolak dedeꞌa deꞌek esa boe na laꞌe-neu Ndia aon. ");
INSERT INTO txq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Neu beꞌe-mai lole manggaledo, boe ma Yesus beꞌe fo neni mamana nees esa neu, nai kota dea. Hatahorir sanggan sudi nai bee. Neu ratonggon, boe ma ara kokoen rae, “Papa leo mua ai leo! Hae muni mamanak laen muu!” ");
INSERT INTO txq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tehuu Ana naselu nae, “Au oo muste uni nggorok laen uu boe, fo uu tui-bengga Hara Lii Malole laꞌe-neu Manetualain parenda-koasan. Manetualain nadenu Au ena fo akalalaꞌok ues naa.” ");
INSERT INTO txq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Boe ma Ana laꞌok numa nggorok esa mai neni nggorok esa neu, fo fee nenorik nai uma huhule-haradoik kara marai profensi Yudea. ");
INSERT INTO txq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Laꞌe esa, Yesus nanori hatahorir ruma dano Galilea tatain. Hatahori noꞌuk ka mai fo rae nenene Manetualain Dedeꞌa-kokolan. Losa neu ara raseseti rakarumbu rala Yesus. ");
INSERT INTO txq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Deka naa, hambu mana puꞌa-dalak kara raole ralao puꞌan nara ruma mada lai. Boe ma Yesus mete-nita ofa lambu rouk dua nafu ruma naa. ");
INSERT INTO txq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ofa kaduak kara raa, Simon enan esa. Yesus hene neni Simon ofan lain neu, boe ma noken fo ana tonda ofak neni oe demak faa neu dei. De Ana nanggatuuk nanori hatahori noꞌuk kara raa. ");
INSERT INTO txq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ana fee nenorik basa, boe ma kokolak no Simon nae, “Simon! Tonda ofak muni tasi demak faa muu fo nggari puꞌak neu naa. Neu ko ei mala iꞌak noꞌuk ka.” ");
INSERT INTO txq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tehuu Simon naselu nae, “Awii, Lamatuak boe oo! Ai puꞌa fafandek ai lima-ein nara hatu katemak esa ena, tehuu ta mala iꞌak esa boe na! Tehuu Papa nae leo naa ena, na, neu ta hata-hata! Au nggari sobak kana.” ");
INSERT INTO txq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Boe ma ara nggari puꞌak neu. Neu rae leꞌa falik puꞌak, naa te puꞌak sofek no iꞌak noꞌun seli, losa puꞌak mulai sida ena. ");
INSERT INTO txq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Boe ma Simon bolu nonoon nara marai ofak laen fo mai tulun. De ara raꞌu iꞌak kara reni ofak reu, losa ofa kaduak kara raa sofen tetu-tetu no iꞌak, de ela baꞌuk ka ara molo. ");
INSERT INTO txq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Simon nonoo mana puꞌa-dalan, Yakobis no Yohanis fo Sabadeus anan nara oo ruma naa boe. Ara oo heran ralan seli boe, nahuu ara rala iꞌak noꞌun seli talo naa. Neu Simon mete-nita mandadik kara raa, boe ma ana sendek luu-langgan neu Yesus matan, de nae, “Au ia, hatahori esa mana tao salak noꞌun seli ena. Dadi malole lenak Lamatuak boso deka-deka au bali.” Tehuu Yesus naselu nae, “Mon! Boso duduꞌa noꞌuk ka neu dedeꞌak naa, huu Au sangga ae pake ei. Eir ia, masiꞌe sangga iꞌak. Tehuu hatematak ia Au anori ei sangga hatahorir fo tungga Au.” ");
INSERT INTO txq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Basa boe ma ara tonda sira ofan tutik ka fo nafun neni mada lai neu. Boe ma ara laꞌo ela sira bebeain, fo tungga Yesus. ");
INSERT INTO txq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Numa nggorok esa, Yesus natonggo no hatahori esa hedi kusta ndule basa ao-inan ena. Neu ana mete-nita Yesus, boe ma neu sendek luu-langgan ma nateꞌe matan losa daer. Boe ma ana nae, “Papa, ee! Tulu-fali au dei! Au bubuluk, Papa bisa tao mamopo au heding ia, mita fo hatahori boso nunute au bali. Sadi Papa nau.” ");
INSERT INTO txq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Boe ma Yesus loo liman fo nafaroen. Ana kokolak nae, “Au nau a mesan! O hai leo!” Kokolak basak ka boe, ma hatahori naa hedi kustan mopon tutik ka. ");
INSERT INTO txq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Boe ma Yesus fee nesenedak neun nae, “Masaneda matalolole! O hai ena, tehuu boso mafada esa boe na, ee! Ma o muste tungga baꞌi Musa parendan lele uluk. Dadi muni malangga anggama muu, fo ana parisa o ao-inam, mita fo ana bubuluk o hedim mopon tebe ena, do beik. Boe ma o muste muni o fefeem tanda makasi fo basa hatahori bubuluk rae, o hai tebe-tebe ena.” ");
INSERT INTO txq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Leo mae Yesus kaꞌi-ore, tehuu tutuik laꞌe-neu Ndia koasan naa natanggela numa bafak mai neni bafak neu sudi nai bee. De hatahorir lua mai, fo rae ramanene Ndia nenorin. Basa boe ma Ana tao nahai hatahori hedin nara mata-matak kara. ");
INSERT INTO txq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tehuu Yesus oo hii nakaheok numa hatahori noꞌuk kara mai boe, fo neu hule-haradoi nai mamana nees. ");
INSERT INTO txq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Laꞌe esa, Yesus nanori hatahorir numa uma esa dale. Faik naa, hatahorir ruma partei anggama Farisir ma meser anggama hida mai fo tungga nenene Yesus nenorin. Ara ruma nggorok kara marai profensi Galilea, profensi Yudea, ma kota Yerusalem mai. Manetualain fee koasa neu Yesus fo tao nahai hatahori hedis sara. ");
INSERT INTO txq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Faik naa, hatahori hida ndoro reni hatahori keko-luꞌuk esa nai lalanggak lain. Ara raote tebe-tebe reni hatahori keko-luꞌuk naa fo Yesus tao nahain. Tehuu uma naa, sofek seꞌe-seꞌe no hatahorir, losa rae rakaseseti dale reu oo, ta bisa boe. Huu naa de ara ndoro roo hatahori keko-luꞌuk naa neni uma lain neu. Boe ma ara ofe uma naa, soi bolok fo rakonda hatahori keko-luꞌuk naa nonook lalanggan. Ara rakondan neu hatahori noꞌuk kara taladan, ndaa tetar neu Yesus matan. ");
INSERT INTO txq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesus mete-nita naa, boe ma Ana bubuluk nae, ara ramahere Ndia bisa tao nahai sira nonoon naa. Boe ma Ana kokolak no hatahori keko-luꞌuk naa nae, “Ana nggee! Au koka heni o sala-singgom mara ena.” ");
INSERT INTO txq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hatahori Farisir ma meser anggamar ramanene Yesus kokolak talo naa, boe ma ara mulai ratatane aok rae, “Na dei! Kada Manetualain mesa kana ndia naena haak fo koka heni hatahori sala-singgon nara. Te ndia ia see, de tao aon leo Manetualain! Ia, nekedadaek ta hohoꞌa ndoos ia!” ");
INSERT INTO txq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tehuu Yesus bubuluk dale kuru-eron nara. Boe ma Ana kokolak nae, “Tao hata de ei duꞌa mae, Au ia kokolak dedeꞌa nekedadaek? ");
INSERT INTO txq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Au ia, Hatahori Dae-bafo Isi-isik. Ma Au aena haak fo fee ambon neu hatahori sala-singgon nara. Mete ma Au kada afada neu hatahori keko-luꞌuk ia ae, ‘Au fee ambon neu o salam mara ena,’ ei ta mete-mita Au koasan nai dae-bafok ia. Tehuu mete ma Au ae, ‘Mambadeik leo! Luꞌa mala o lalanggam fo fali muu ngga leo.’ Mete ma ana nambadeik tutik ka, na, dei fo ei mete-mita Au koasang. Huu naa de Au nau tao ahai hatahori keko-luꞌuk ia, mita fo ei oo bubuluk Au aena haak boe, fo fee ambon neu hatahori sala-singgon nara.” Boe ma Ana mbali hatahori keko-luꞌuk naa, de kokolak nae, “Mambadeik leo! Luꞌa mala o lalanggam, fo fali muu ngga leo!” ");
INSERT INTO txq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Medak neu ma, hatahori naa nambadeik de nambariik neu hatahori noꞌuk kara matan, boe ma luꞌa nala lalanggan. De ana fali neu ngga, ma koa-kio Manetualain. ");
INSERT INTO txq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Neu basa hatahori mete-rita naa, boe ma ara heran. De ara rakadedemak Manetualain naden rae, “Manetualain ta neni babanggak, ee! Faik ia, ita mete-tita mandadi ta hohoꞌak to ita mata heli-helin nara!” ");
INSERT INTO txq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ta dook ka boe ma Yesus kalua numa uma naa mai, de mete-nita hatahori mana susu bea esa, nanggatuuk numa ndia mamana sususu bean. Hatahori naa, nade Lewi. Boe ma Yesus noken nae, “Mai tungga Au!” ");
INSERT INTO txq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi namanene nala naa, boe ma ana nambadeik tutik ka, de ana laꞌo ela basa bebeain marai naa, fo tungga Yesus. ");
INSERT INTO txq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Basa boe ma Lewi tao feta moꞌok fo noke Yesus neni ndia uman neu. Ana oo noke ndia nonoo mana susu bean nara ma fuik laen nara bali, fo mai raꞌa feta boe. ");
INSERT INTO txq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tehuu hambu hatahori partei Farisi hida ma meser anggamar, ara unggu-remu numa Yesus ana nunin nara matan rae, “Tao hata de ei manggatuuk miꞌa-minu sama-sama mia hatahori papake taak kara, ndia leo mana susu bear ma hatahori ta neulauk kara? Hatahori neulauk kara boso rakabua ro hatahori matak leo naak kara!” ");
INSERT INTO txq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Boe ma Yesus nafada sara nae, “Hatahori hedis memak parluu doter. Tehuu hatahori sodak ena, ta parluu. ");
INSERT INTO txq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Au mai fo tao matak neu hatahori ta neulauk kara. Tehuu ta mai fo tao matak neu hatahori fo mana nameda aon ndoos.” ");
INSERT INTO txq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Basa de, hatahori maruma partei anggama Farisi ma meser anggamar raa oo unggu-remu reu Yesus boe rae, “Talo ia, Papa! Yohanis Mana Saranik ana nunin nara puasa ma hule-haradoi laꞌi-laꞌik ka. Hatahori Farisir ana nunin nara oo tao talo naa boe. Tehuu tao hata de Papa ana nunin nara kada raꞌa-rinu rakandook kana? Ara ta puasa ralela, do?” ");
INSERT INTO txq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tehuu Yesus bala sara pake lololek nae, “Memak ei bubuluk ena, mete ma tao feta kabin, na, fuik kara ta puasa, tehuu ara raꞌa-rinu losa rakabete. Mete ma baroit touk bei nai naa, neu ko ara raꞌa-rinu sama-sama. ");
INSERT INTO txq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tehuu mete ma neu laꞌe esa, hatahori laen humu reni baroit touk naa, na, neu ko nonoon nara rameda susa, dei fo ara puasa.” ");
INSERT INTO txq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Basa boe ma Yesus fee lololek esa bali nae, “Ta hambu hatahori haꞌi nala tema beuk faa fo tandan neu badu raak mana sidak. Te mete ma safe badu naa, neu ko tema bibia beuk naa kukundu, de badu raak naa boe sidan. ");
INSERT INTO txq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Leo naak oo hatahori ta radai oe anggor beuk neni boboꞌik banda rou raak dale neu boe, te neu ko kadin ma ana sii sasarak, de oe anggor beuk naa mboꞌa henin. Dadi oe anggor beuk muste nadain neni boboꞌik banda rou beuk neu. No lololek naa, Yesus nanori sara nae Ndia nenori beun boso babalik kana no hatahori Farisir nenori raan. ");
INSERT INTO txq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hatahori fo mana ninu nita oe anggor raak, ta hii ninu oe anggor beuk. Huu ana bubuluk nae, ‘Anggor neni nehinda dook naa, ndia ladan seli, na!’ ” ");
INSERT INTO txq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Laꞌe esa, Yesus no ana nunin nara laꞌok resik hatahori osin dale, ndaa no hatahori Yahudir fai hahae tao ue-osan. Boe ma ana nunin nara koru rala hade-nggandum mbulen maruma sira matan. Ara raisin, de raꞌa. ");
INSERT INTO txq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Numa naa, hambu partei anggama Farisi hatahorin hida fo mana toꞌu rahere sira Yahudi dala-hadan. Ara mete-rita Yesus ana nunin nara tao talo naa, boe ma ara rahara berak neu Yesus rae, “Tao hata de O ana nunim mara lena-langga ita anggaman hohoro-lalanen? Ara tao ues laꞌe-ndaa fai hahae tao ue-osa! Mete ndia naa! Ara koru hade-nggandum. Boso talo naa!” ");
INSERT INTO txq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Tehuu Yesus bala nae, “Talo bee, ou? Ei ta masaneda baꞌi Dauk tutuin, do? Baꞌi Dauk no ndia ana nunin nara taꞌin nara kada kikiok, nahuu ndoe ralan seli ena. Boe ma ara maso reni Manetualain Laa Huhule-haradoin reu, de haꞌi roti fo malangga anggamar fee basan neu Manetualain, fo ara raꞌa. Naa te kada malangga anggamar ndia bole raꞌa roti naa. Hatahori laen ta bole. Boe ma baꞌi Dauk asa raꞌa, tehuu ta hambu hatahori fee salak neu sara. Ei nok bali ta bei lees mita Manetualain Susura Malalaon! ");
INSERT INTO txq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pasa ndiꞌi doom mara fo nenene matalolole! Au ia, Hatahori Dae-bafo Isi-isik. Au ndia aena haak fo aketu ae, hatahori bole tao hata-hata ndaa no fai hahae tao ue-osa.” ");
INSERT INTO txq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Laꞌe esa, ndaa no fai hahae tao ue-osa esa bali, Yesus neu fee nenorik numa uma huhule-haradoik. Numa naa, hambu touk esa fo liman seri mates. ");
INSERT INTO txq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Numa naa oo, hambu meser anggama hida ma hatahorir ruma partei anggama Farisi mai, ara sangga lelak fo rae rakatutudak Yesus. De ara rahani a fo mete sudik, fama te Ana nae tao nahai hatahori fo lima mate seserik naa, ndaa no fai hahae tao ue-osa. No dalak naa, ara bisa rakasasaꞌek salak neun nai hatahori noꞌuk matan. ");
INSERT INTO txq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tehuu Yesus bubuluk no tetuk sira duduꞌan. Huu naa de Ana nanggou hatahori fo lima mate seserik naa nae, “Kaꞌa, ee! Mai mambariik muu talada ia dei!” Boe ma neu nambariik tutik kana. ");
INSERT INTO txq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","De Yesus natane hatahorir raa nae, “Hena Au atane ei dei. Tungga ita anggaman hohoro-lalanen, na, kada hata ndia ita taon fo ndaa no fai hahae tao ue-osa? Ita tao malole do, manggarauk? Ita tao tasoi-tasoda hatahori do, takalulutu ndia masodan?” ");
INSERT INTO txq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Boe ma Yesus mete ndule basa sara, de Ana kokolak no hatahori fo lima mate seserik naa nae, “Loo o limam mai!” Boe ma ana loo liman neu, de liman hai tutik ka. ");
INSERT INTO txq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yesus musun nara mete-rita talo naa, boe ma ara luri. De ara mulai duduꞌa fo rala harak rae, “Ai muste sangga dalak laen bali fo mae makatutudak kana!” ");
INSERT INTO txq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ta dook ka bali, boe ma Yesus neni letek esa neu fo hule-haradoi. De Ana hule-haradoi numa naa, leꞌodae katemak esa. ");
INSERT INTO txq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Neu beꞌe-mai huhua anan, boe ma Ana nanggou nala Ndia ana nunin nara. Numa sira lalaꞌen mai, Ana here nala salahunu dua fo dadi neu Ndia nedenun nara. Hatahori fo Ana here nalak kara raa, sira: ");
INSERT INTO txq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (Yesus nasiꞌe noken nae, ‘Petrus’), Anderias (Simon fadin), Yakobis, Yohanis (Yakobis fadin), Felipus, Bartolomeos, ");
INSERT INTO txq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateos, Tomas, Yakobis (Alpius anan), Simon (mana tungga partei politik Selot), ");
INSERT INTO txq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas (Yakobis anan), ma Yudas Iskariot (fo neu ko ana ndia seꞌo heni Yesus). ");
INSERT INTO txq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Neu Yesus no ana nunin nara konda numa letek naa mai, boe ma ara rambariik ruma dae matetuk. Numa naa oo, hatahori noꞌuk kara rakabua boe. Hatahorir raa, ruma profensi Yudea, kota Yerusalem, Tirus ma Sidon mai, fo kota dua rai tasi tatain. ");
INSERT INTO txq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ara mai fo rae nenene Yesus, ma ketuk rae hule Yesus tao nahai hatahori hedis sara. Boe ma Ana tao nahai sara. Ana oo tao nahai hatahori fo nitu saꞌek, ma husi heni nitur kalua numa hatahorir raa mai boe. ");
INSERT INTO txq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Basa hatahorir nau koi laꞌe Yesus, te mete ma ara koi laꞌen, na, hambu koasa kalua numa Yesus mai fo tao nahai sara. ");
INSERT INTO txq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Boe ma Yesus nasare mbali ana nunin nara, de fee nenorik nae, “Hatahori kasian nara ein! Ei maua, nahuu Manetualain mesa kana, ei Mane neulaun. ");
INSERT INTO txq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Hatahori mana ndoe-laꞌak kara ein! Ei maua, nahuu Manetualain neu ko fee ei makabete. Hatahori mana buꞌi mamatanik kara ma mana susa-sonak kara ein! Ei maua, nahuu neu ko ei dalem mara ramahoko ma hika setelele. ");
INSERT INTO txq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Hatahori mana hambu susa-sonak, nahuu ana tungga Au, Hatahori Dae-bafo Isi-isik ia! Ei maua, nahuu neu ko Manetualain bala ei nai nusa tetuk do inggu temak. Leo mae hatahori mburuk ro ei, do, rakalulutu ei nade malolem, do, momolo-tatabu ei, do, husi-mbuu lulukur ei nok bali hatahori manggarauk, ei maua, nahuu Manetualain neu ko nasaneda ei nai nusa tetuk do inggu temak. Dadi mete ma hatahorir rakasususak ei talo naa, na, tao ei dalem mara kada mbena sau-sau leo! Ma makaboboku mamahoko! Hae heran, nahuu hatahori mana makasususak ei hatematak ia, sira bei-baꞌin nara ndia tao rakasususak Manetualain mana toꞌu dedean nara ndia lele uluk. De, mete ma ei hambu susa-sonak matak leo naak, tao ei dalem mara kada mbena sau-sau leo, nahuu Manetualain neu ko bala ei manahetak nai nusa tetuk do inggu temak! ");
INSERT INTO txq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tehuu hatahori kamasuꞌik kara ein! Ei hambu sosoek, nahuu ei masoda setelelem mara, losa kada ia leo. ");
INSERT INTO txq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Hatahori mana makabetek kara ein! Ei hambu sosoek, nahuu fai ndoe-laꞌas ta hohoꞌak daka nala ei. Hatahori mana hika sadi ndaak kara ein! Ei hambu sosoek, nahuu manggataꞌak mai tao nala ei buꞌi makarereu. ");
INSERT INTO txq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Hatahori taꞌe koak kara ein! Ei hambu sosoek, nahuu bakahulun ei bei-baꞌim mara oo koa-kio mana toꞌu dedeꞌa pepeko-lelekok kara boe!” ");
INSERT INTO txq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Boe ma Yesus tuti nae, “Pasa ndiꞌi doom fo nenene matalolole! O muste sue o musum mara, ma tao hata fo malole neu hatahori mana mburuk no o. ");
INSERT INTO txq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Hule-haradoi neu Manetualain fo Ana tao hata fo malole neu hatahori mana nakatoo o. Ma moke fo Ana tao hata fo malole neu hatahori mana soa tao manggarauk neu o. ");
INSERT INTO txq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mete ma hatahori famba o nasum seri, na, mboꞌin fo ana famba tamba o nasum seri bali. Mete ma ketuk leꞌa nala o jeket, na, fee tamba seluk o badum neun bali. ");
INSERT INTO txq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mete ma hatahori roke o hatan esa, na, feen neu leo. Mete ma ketuk baꞌu reni o hatam esa, na, elan numa naa fo ana soan leo. Boso muu moke falik kana bali! ");
INSERT INTO txq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","O muste tao hatahori laen nara oo, sama tetar no hata fo o hii hatahorir taon soa-neu o boe. ");
INSERT INTO txq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","O hii matudu susuem neu kada o hatahori heli-helim mara. Naa malole. Tehuu lenan, hata? Hatahori manggarauk kara oo sue sira hatahori heli-helin nara boe! ");
INSERT INTO txq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mete ma o tao neulauk neu kada hatahori mana tao neulauk neu o, na, lenan nai bee? Te hatahori manggarauk kara oo tao neulauk esa mbali esa talo naa boe. ");
INSERT INTO txq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mete ma o fee pindan doik neu kada hatahori see fo ana bisa fee falik kana, na, lenan hata? Te hatahori manggarauk kara oo bisa fee pindan doik neu hatahori laen boe, sadi mbila-beinesak ara simbo falik kasa tema-tema. ");
INSERT INTO txq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tehuu mana lenak naa, ndia talo ia: sue o musum mara! Ma tao hata fo malole neu sara. Ara toꞌa hata, na, fee pindan neu sara. Hae duꞌa mae, ara bisa fee falik kasa, do taa. No dalak naa, neu ko Manetualain bala o. Ma o dadi muu Manetualain mana Demak Mateꞌen anan. Huu o leo-laꞌo sama leo o Amam fo hii tao hata fo malole soa-neu hatahori manggarauk. Ana oo tao hata fo malole soa-neu hatahori ta mana malela noke makasi boe. ");
INSERT INTO txq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dadi o muste matudu dale kasian neu hatahori, sama leo o Amam manai nusa tetuk do inggu temak natudu dale kasian neu o.” ");
INSERT INTO txq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesus fee nenorik nakandoo nae, “Boso timba-tai hatahori, mita fo hatahori boso timba-tai rasafali o. Boso maselu kisubalik hatahori, te neu ko hatahorir oo raselu kisubalik o boe. Lilii heni hatahori sala-singgon, mita fo hatahori oo lilii heni o sala-singgom boe. ");
INSERT INTO txq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mete ma o fee hata fo hatahori toꞌa, na, neu ko o simbo masafalik kana. Neu ko Manetualain koladu fo o simbo falik sasi kao-kao. Naa, sama leo hatahorir radai fufue noꞌun seli neu balee uꞌukuk, boe ma ara ndondokon, ndeꞌin, basa de radai seluk bali losa ana sasi kao-kao. O simbo malak kara raa, sama leo naak. Mete ma o fee baꞌuk, na, o simbo falik oo baꞌuk boe. Tehuu mete ma o fee noꞌuk, na, o simbo falik oo manahetak boe.” ");
INSERT INTO txq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus oo fee nenorik pake lololek boe. Ana tui nae, “Ta hambu hatahori pokek natudu dalak fee hatahori pokek laen. Neu ko dua sara tuda reni bolok dale reu! ");
INSERT INTO txq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kakana sakola ta bisa lena heni ndia mesen! Tehuu mete ma ana tungga natalolole ndia mesen nenorin, na, ana bisa dadi sama leo ndia mesen. ");
INSERT INTO txq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","O hii kada tanda matalolole hatahori sala kadiꞌi anan. Tehuu o sala moꞌom, o taon leo bali ta ia. Naa, sama leo o mete-mita uꞌuk nai hatahori matan, naa te hambu balo moꞌok natabaa nala o matam, tehuu o ta mameda sana! ");
INSERT INTO txq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Talo bee de o mambarani kokolak mae, ‘Tia-laik! Mai fo au nggai heni uꞌuk numa o matam mai dei.’ Naa te o ao heli-helim ta bisa mete-nita hata-hata, nahuu balok natabaa nala o matam, na! Woi! O ia, memak hatahori mana dea-matak tebe-tebe! Tulun dei! Piru heni balok naa, numa o mata heli-helim mai dei. Dei fo o bisa mete-mita fo nggai heni uꞌuk numa o nonoom naa matan mai.” ");
INSERT INTO txq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesus tamba seluk lololek esa bali nae, “Ta bisa dadi ai huu neulauk naboa ai boa ta neulauk. Ma ta bisa dadi ai huu ta neulauk naboa ai boa neulauk. ");
INSERT INTO txq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Hatahori bisa tanda rala, ai huuk esa neulauk do taa, numa ai huuk naa boan mai. Basa hatahorir bubuluk rae, ta bisa dadi hatahori seu ufa boan, do anggor boan numa ai kanggouk mai. ");
INSERT INTO txq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Leo naak oo, hatahori dale lolo-laok bisa tao hata fo neulauk kara boe. Tehuu hatahori dale manggenggeok tao hata manggarauk kara. Te numa hatahori kokolan mai, natudu ndia isi-isin.” ");
INSERT INTO txq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesus tuti seluk kana bali nae, “Ei soa kada moke Au taa-taa mae, ‘Lamatuak’. Tehuu tao hata de ei ta nau tungga Au kokolang? ");
INSERT INTO txq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Hatahori mana mai nenene Au, boe ma ana tao tungga Au kokolang, ana sama leo ");
INSERT INTO txq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","hatahori mana nae nambaririik uma matea. Ana kali natalolole fanderen bolon nai dae isik dei, losa hambu batu isik. Basa naa, ana tao fanderen tetar neu batu naa lain, dei fo nambaririik uma. Mete ma faa lua mai, na, uma naa ta natanggenggo, nahuu fanderen matea ena. ");
INSERT INTO txq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tehuu hatahori mana nenene no kada dale bibiak ma ta tungga Au kokolang, ana sama leo hatahori mana nae nambaririik uma, te sadi ana dadi. Ana ta tao fanderen, tehuu ana kada netetende uma naa neu dae isik nai lee tatain. De neu faa lua mai, boe ma ana sapu nakalulutu heni uma naa!” ");
INSERT INTO txq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus fee nenorik basa talo naa, boe ma Ana fali neni kota Kapernaum neu. ");
INSERT INTO txq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nai naa, hambu komedan soldadu Roma esa. Ana naena ana mana maue-osa esa, dadi neu ndia ana nemeheren. Hatahori mana maue-osa naa tuda hedis, de ela baꞌuk ka maten. ");
INSERT INTO txq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Neu komedan naa namanene laꞌe-neu Yesus, boe ma ana nadenu lasi Yahudir hida fo reu roke Yesus mai tao nahai ana mana maue-osa naa. ");
INSERT INTO txq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ara kokoe Yesus, fo mete ma bisa, na, Ana mai no sara fo tao nahai hatahori naa. Ara kokoen rae, “Papa! Hatahori Roma ia, hatahori neulauk! Ana nandaa, Papa tulu-falin. ");
INSERT INTO txq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ana nambaririik nala uma huhule-haradoik esa fee ita, te ana sue ita hatahori Yahudi na.” ");
INSERT INTO txq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Boe ma Yesus tungga no sara. Ara bei ta losa uma, tehuu komedan naa, fee nonoon neu fo nafada Yesus ena nae, “Lamatuak hae makamangguk aom fo mai bali, huu au ta andaa simbok Lamatuak nai au umang. ");
INSERT INTO txq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Ma au oo, ta andaa neti asare matak ua Lamatuak boe. Memak manggaledok ena, Lamatuak naena koasa. De, sadi Lamatuak kada kokolak numa naa mai, neu ko au ana mana maue-osang hai neuk ka. Au bubuluk matak ia, nahuu au malanggang nggara raena koasa fo parenda au. Ma au oo, aena koasa fo parenda au soldadung nggara boe. Mete ma au fee parenda neu au ana nuning ae, ‘Muni naa muu!’ neu ko ana neu. Mete ma au ae, ‘Ia mai!’ neu ko ana mai. Mete ma au adenu au hatahori mana maue-osang ae, ‘Tao ia!’ neu ko ana tao talo naa. De, sadi Lamatuak kada kokolak, neu ko au ana mana maue-osang ia, hai neuk ka.” ");
INSERT INTO txq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesus namanene nala naa, boe ma Ana heran. Ana hekor aon fo nasare hatahori noꞌuk kara mana tungga Ndia. Boe ma Ana nae, “Heran, ee! Doo basa ia, Au bei ta atonggo ita hatahori Yahudi esa boe na, nemeheheren matea leo hatahori Roma ia!” ");
INSERT INTO txq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","De, Yesus laꞌok losa kada naa. Basa boe ma komedan nonoon nara lenggu fali. Losa komedan uman, boe ma mete-rita ana mana maue-osa naa, mana haik ena. ");
INSERT INTO txq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Neu beꞌe-mai, boe ma Yesus no Ndia ana nunin nara laꞌo reni nggorok esa reu, nade Nain. Hatahori noꞌuk ka rambalolok ro sara. ");
INSERT INTO txq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ara sangga deka nggorok naa lelesun, boe ma hatahori bubuak esa rae kalua reu ratoi mamates. Mana matek naa, ina falu esa ana tou kise-muꞌen. ");
INSERT INTO txq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Neu Yesus mete-nita ina falu naa, boe ma dalen tuda kasian. De Ana kokolak no inak naa nae, “Mama! Na leo, hae buꞌi!” ");
INSERT INTO txq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesus deka mata neu, de Ana koi lalangga mamates naa. Boe ma hatahori mana ndoro lalanggak naa, hahae taak. Basa boe ma Yesus kokolak neu hatahori mates naa nae, “Taꞌek! Mambadeik leo!” ");
INSERT INTO txq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Boe ma kanak naa nasoda fali numa mamaten mai, de nanggatuuk tutik ka. Ana mulai kokolak no hatahori mana rambariik eko-feon. Boe ma Yesus nafada inak naa nae, “Mama! Ia mama anan.” ");
INSERT INTO txq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Basa hatahorir maruma naa, ramataꞌu ralan seli! Boe ma ara koa-kio Manetualain rae, “Manetualain nadenu Ndia mana toꞌu dedeꞌan ta neni babanggak esa soa-neu ita!” Hambu laen bali rae, “Manetualain mai nai ita talada heon ena, fo natudu Ndia dale susuen!” ");
INSERT INTO txq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Boe ma tutuik naa oo, natanggela sudi bee neu numa profensi Yudea, losa nai basa mamanak laen nai nusak naa boe. ");
INSERT INTO txq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","20","Yohanis Mana Saranik ana nunin nara ramanene rala basa hata fo Yesus taon ena. De ara reu tui Yohanis numa bui dale. Boe ma ana nadenu hatahori dua reni Yesus reu fo ratanen rae, “Papa ia, tebe-tebe Karistus fo ai mahanik naa, do? Do, ai muste mahani hatahori laen bali?” Ara ratonggo roo Yesus, boe ma ratanen talo naa. ");
INSERT INTO txq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Neu nedenuk kara raa bei ruma naa, Yesus tao nahai hatahori noꞌuk ka hedin nara mata-matak kara. Ana husi heni nitur ruma hatahori fo nitu saꞌek kara mai. Ma tao nahai hatahori pokek kara, de ara bisa mete-rita. ");
INSERT INTO txq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Basa boe ma, Yesus nafada Yohanis ana nunin nara nae, “Ei fali miu mafada kaꞌa Yohanis, basa hata fo ei mamanene malan ma mete-mitan no mata heli-helim ena, sama leo Manetualain mana toꞌu dedeꞌan Yesaya surak nae, ‘Hatahori pokek, mete-nita. Hatahori ei kekok, nambadeik laꞌo-laꞌo. Hatahori hedi kusta, dadi nambalao. Hatahori mbakek, namanene. Hatahori mates, nasoda fali numa mamates mai. Hatahori kasian namanene Hara Lii Malole.’ ");
INSERT INTO txq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Fali miu mafada kaꞌa Yohanis mae, ‘hatahori fo ta mana mae simbok Au, neu ko raua ralan seli.’ ” ");
INSERT INTO txq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohanis ana nunin nara fali ena, boe ma Yesus kokolak no hatahori noꞌuk kara raa laꞌe-neu Yohanis nae, “Neu ei miu sangga Yohanis numa mamana nees naa, ei duꞌa mae matonggo mia hatahori rupa leo beek? Ta bisa dadi ei naa miu fo matonggo mia hatahori mana noe-naꞌuk, sama leo milak mbeu neu mai, tungga kada anin! ");
INSERT INTO txq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ta bisa dadi ei miu fo mete-mita hatahori mana pake bua-loꞌa mabeli, te hatahori matak leo naak, ana leo nai kada uma manek! ");
INSERT INTO txq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Dadi ei miu mete-mita see numa naa? Ei duꞌa mae, ei miu sangga Manetualain mana toꞌu dedeꞌan? Tebe! Tehuu ndia naa, mana toꞌu dedeꞌak ta hohoꞌan lenak. ");
INSERT INTO txq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sama leo Susura Malalaok surak ela laꞌe-neu Yohanis nae, ‘Nenene! Au adenu Au hatahoring, fo neu nasosoi dalak fee O.’ ");
INSERT INTO txq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nai dae-bafok ia, ta hambu hatahori esa boe na, fo ta hohoꞌak lena heni Yohanis. Tehuu nai Manetualain mamana parenda-koasan, hatahori mana nesik dea mateꞌen oo, ta hohoꞌan lena heni Yohanis boe.” ");
INSERT INTO txq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hatahori mana mamanene Yesus dedeꞌa-kokolan naa, ara bubuluk ena rae, Manetualain eno-dalan naa, eno-dala masodak tetebes. Mana susu bear oo bubuluk boe, nahuu bakahulun Yohanis sarani ma nanori sara ena. ");
INSERT INTO txq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tehuu hatahorir ruma partei anggama Farisi ma mana malela hukun Yahudir, ara ta nau tungga Manetualain hihii-nanaun ena. Huu naa de, ara ta roke Yohanis sarani sara. ");
INSERT INTO txq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Boe ma Yesus natane nae, “Au ae akasasamak hatahorir hatematak ia ro hata? Sira iar, hatahori rupak bee? ");
INSERT INTO txq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sira iar, sama leo kana anar mana nggua-nggua rai pasar. Ara kii-ouk ma unggu-remu rae, ‘Ai fuu sulik rame-rame, tehuu ei ta foti-lendo setelele. Boe ma ai soda-helo sosoda beꞌe mamates, tehuu ei ta buꞌi mamatani.’ ");
INSERT INTO txq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Huu Yohanis Mana Saranik ta ninu anggor ma ta hii puasa, de ei henggenee malan mae, ‘Ndia nitu saꞌek!’ ");
INSERT INTO txq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tehuu hatematak ia Au, Hatahori Dae-bafo Isi-isik ia, inu anggor ma uꞌa roti sama leo biasa. Boe ma ei henggenee mala Au mae, ‘Ndia ia, hatahori bare-naꞌo huun! Mana mafu kamaberak bali! Neu natia-laik no mana susu bear! Partei esa no hatahori papake taak kara! Ana ta nalela aon bali!’ ");
INSERT INTO txq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tehuu ei tanda leo, neu Au kokolang, ee! Hatahori mana bubuluk no tetuk, ara tungga Manetualain hihii-nanaun.” ");
INSERT INTO txq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Numa kota naa, hambu hatahori Farisi esa, nade Simon. Laꞌe esa, ana noke Yesus asa mai raꞌa numa ndia uman. Yesus asa simbo rala nonokek naa, boe ma reu fo rae ranggatuuk raꞌa-rinu. ");
INSERT INTO txq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Faik naa, ina petak esa namanene nae, Yesus nae naꞌa nai naa. Boe ma ana dudi mai, ma toꞌu neni boto mina kaboo meni mabeli esa. ");
INSERT INTO txq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ana deka neni Yesus neu, nesi Yesus dean. Boe ma sendek luu-langgan neu Yesus ein. Ana buꞌi nakarereu losa luun tuda laꞌe Yesus ein. De ana seka Yesus ein nenik ndia langga bulun, ma idu nasakukuku Yesus ein. Basa boe ma ana mboꞌa mina kaboo menik naa neu Yesus ein. ");
INSERT INTO txq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simon naa, bubuluk inak naa leleo-lalaꞌon. Huu naa de ana duꞌa nai dalen nae, “Ia dadi neu bukti ena, Yesus ia, ta Manetualain mana toꞌu dedeꞌan! Mete ma tebe-tebe Manetualain ndia nadenun mai, na, neu ko Yesus bubuluk ena nae, inak mana koi laꞌe Ndia naa, ina petak. Manetualain mana toꞌu dedeꞌan ta sama leo Ndia ia, huu hatahori malalaok ta bole deka-deka no hatahori manggenggeok kara!” ");
INSERT INTO txq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tehuu Yesus bubuluk no tetuk hata fo nai Simon duduꞌan. Boe ma Ana nae, “Kaꞌa Simon! Talo ia, kaꞌa. Au sangga afada kaꞌa matak esa.” Boe ma Simon naselu nae, “Neu! Papa Meser kokolak neu leo.” ");
INSERT INTO txq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Boe ma Yesus tui lololek non nae, “Hatahori esa nasiꞌe fee pindan doin nara neu hatahori laen. Ana fee pindan nita doin neu hatahori dua. Esa, ana feen doi lilo fulak natun lima, esa bali, ana feen kada lima hulu. ");
INSERT INTO txq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tehuu neu fain fo fee falik doik kara raa, dua sara ta rabeꞌi. Boe ma mana fee pindan doik naa, dalen tuda neu dua sara. Huu naa de ana nakamboꞌik kasa ruma dua sara hutan mai. Dadi mete ma tungga kaꞌa Simon duduꞌan, numa hatahori kaduak kara mana pindan doik naa, see ndia susuen lenak neu mana fee pindan doik naa?” ");
INSERT INTO txq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon nggado laik kana nae, “Neu ko ndia mana nahutak noꞌun lenak, ee!” Yesus naselu nae, “Tebe, kaꞌa!” ");
INSERT INTO txq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ana nasare mbali inak naa, boe ma kokolak no Simon nae, “Hena kaꞌa Simon mete neu inak ia. Neu Au dudi uni kaꞌa uman dale mai, kaꞌa ta sadia oe fo safe Au eing, tungga ita hadan. Tehuu inak ia nakoe Au eing nenik ndia luu-oen, boe ma ana seka nalaon nenik ndia langga bulun. ");
INSERT INTO txq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma bebeik kara ia, neu kaꞌa mai soru Au uni uma dale mai, kaꞌa Simon ta idu Au, tungga ita hadan. Tehuu mulai numa Au dudi uni uma ia dale mai, inak ia ta hahae idu Au eing. ");
INSERT INTO txq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kaꞌa Simon oo, lilii heni hadak mboꞌa mina neu fuik kara langgan boe, neu Au dudi mai bebeik kara ia. Tehuu inak ia, mboꞌa mina kaboo menik mabelin seli neu Au eing. ");
INSERT INTO txq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kaꞌa Simon nenene matalolole dei! Inak ia memak salan noꞌuk ka. Tehuu Manetualain koka heni sara ena, nahuu ana natudu susuen ma dale makasin noꞌuk ka neu Au. Tehuu hatahori fo mana nameda ndia aon ta tao salak noꞌuk ka, ana oo nameda ta parluu hambu ambon noꞌuk ka boe. Huu naa de ana ta sue nalela ma ta noke makasi mbali Manetualain.” ");
INSERT INTO txq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Basa boe ma Yesus nafada inak naa nae, “Au koka heni o salam mara ena!” ");
INSERT INTO txq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hatahorir mana ranggatuuk raꞌa sama-sama mulai bese kutu rae, “Wou! Ana duꞌa nae Ndia ia, see?! Ana nambarani fee ambon neu hatahori salan, ee! Naa te kada Manetualain mesa kana ndia naena haak fo koka heni hatahori salan! Cih!” ");
INSERT INTO txq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tehuu Yesus nafada inak naa nae, “O mamahere neu Au ena, huu naa de Manetualain tao nasoi-nasoda o ena. Fali muu ngga leo no mole-damek!” ");
INSERT INTO txq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ta dook ka boe ma Yesus no ana nuni kasalahunu duan nara, laꞌo ndule kota ma nggorok kara marai naar. Ana laꞌo neu nafada hatahorir laꞌe-neu Manetualain parenda-koasan. Naa dadi neu hara lii malole soa-neu sara. ");
INSERT INTO txq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Numa hatahori bubuak naa dale, hambu inak hida tungga boe. Inak kara iar, ketuk hambu rita hedis mata-matak kara ma ketuk nitu saꞌe nita sara. Tehuu Yesus tao nahai basa sara. Ndia leo, Maria numa nggoro Magdala mai. Fai bakahulun, Yesus husi nita nitu hitu numa Maria mai. ");
INSERT INTO txq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Susana no mama Yohana oo, ruma hatahori bubuak naa dale boe. Mama Yohana ia, papa Kusa saon. Kusa naa, malangga mana maono-lalau nai manek Herodes uma manen. Ma bei hambu inak laen noꞌuk ka rambalololok ro Yesus asa. Inak kara iar pake sira doi heli-helin fo tanggon rala Yesus asa doi dalan. ");
INSERT INTO txq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Laꞌe esa, hatahori numa nggorok noꞌuk ka mai fo sangga Yesus. Hatahori noꞌuk kara raa rakabua, boe ma Ana tui sara pake lololek esa nae, ");
INSERT INTO txq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Hatahori mana tao ue daek esa neu nggari bini-nggees numa osin. Bini-nggees ketuk tuda ndaa dalak. Neu hatahorir laꞌok resik naa, boe ma ara heta laꞌe bini-nggees raa. Basa boe ma mbuik kara mai, de bido ralao sara. ");
INSERT INTO txq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bini-nggees ketuk bali tuda ndaa dae batuk. Bini-nggees raa mulai ranumbu, tehuu male heni sara, nahuu oe baꞌuk ka. ");
INSERT INTO txq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bini-nggees laen tuda ndaa mamana dila-nggauk. Neu bini-nggees raa mulai ranumbu, dila-nggauk kara seti rakamate sara. ");
INSERT INTO txq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma bini-nggees laen tuda ndaa dae isi neulauk. Ara ranumbu, boe ma mori losa raboa. Bini-nggees raa fee falik buna-boak lipa laꞌe natun esa.” Yesus tui basa talo naa, boe ma Ana nateꞌe lololek naa, ma kokolak nahere haran nae, “Ei kandiꞌi dook kara, na, duꞌa malan matalolole!” ");
INSERT INTO txq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Basa boe ma Yesus ana nunin ara ratane lololek naa sosoa-ndandaan. ");
INSERT INTO txq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ana naselu nae, “Talo ia! Huu ei tungga tebe-tebe ena Manetualain hihii-nanaun, de Au buka no manggaledon fo ei bubuluk talo bee Manetualain nae parenda Ndia hatahorin nara. Tehuu hatahori laen nara ta nau tao matak Manetualain hihii-nanaun. Huu naa de Au anori sara pake kada lololek. Sama leo Manetualain mana toꞌu dedeꞌan surak memak laꞌe-neu hatahorir ia ena nae, ‘Ara mete-rita ena, tehuu ta nau ralela. Ara ramanene ena, tehuu ta nau bubuluk.’ ” ");
INSERT INTO txq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Boe ma Lamatuak Yesus nafada lololek naa sosoa-ndandaan nae, “Bini-nggees naa, ndia Manetualain Dedeꞌa-kokolan. ");
INSERT INTO txq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bini-nggees fo mana tuda ndaa dalak naa, ndia hatahorir fo mana ramanene rala Manetualain Dedeꞌa-kokolan, tehuu basa boe ma nitur malanggan mai de leꞌa neni Dedeꞌa-kokolak naa, numa dalen nara mai. No dalak naa, ara ta ramahere neu Manetualain, de ta hambu masoi-masodak. ");
INSERT INTO txq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bini-nggees fo mana tuda ndaa dae batuk naa, ndia hatahorir fo mana ramanene rala Manetualain Dedeꞌa-kokolan no nemehokok. Tehuu okan nara ta tora rala demak ka. Ara mulai ramahere, tehuu mete ma susa-sonak daka nala sara, na, ara tuda no muda hiek. ");
INSERT INTO txq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bini-nggees fo mana tuda ndaa mamana dila-nggauk naa, ndia hatahorir fo mana ramanene ma simbok rala Manetualain Dedeꞌa-kokolan. Tehuu ta dook ka boe ma ara lilii heni Dedeꞌa-kokolak naa, huu ara rasambute ralan seli no ue-osa heli-helin nara, sira hata-heton mata-matak kara, ma ara hii leo-laꞌo no kada setelelek. Huu naa de sira nemeheheren naa, nenenin taa. ");
INSERT INTO txq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tehuu bini-nggees fo mana tuda ndaa dae isi neulauk, ndia hatahorir dale malole ma dale ndoos. Neu ara ramanene rala Manetualain Dedeꞌa-kokolan, boe ma rahinda ratalololen neu dalen nara. No dalak naa, ara ramahere taa-taa, ma tao hata fo neulauk noꞌuk ka.” ");
INSERT INTO txq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Boe ma Yesus kokolak bali nae, “Ta bisa dadi hatahori dede lambu tiꞌoek, basa naa tatanan pake ure dae. Ma ta hambu hatahori natetende lambu neni koi fengga dalen neu. Mete ma taon talo naa, na, hatahori ta bisa mete-nita manggaledon bali. Lambu fo kanenenik, ndia neni netetendek nai mamana demak, mita fo saꞌan tao manggaledo hatahori mana dudi mai. ");
INSERT INTO txq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Basa hata fo neni nefunik hatematak ia, neu ko neni mete-nitak. Ma basa hata fo hatahori ta bubuluk kana hatematak ia, neu ko hatahori bubuluk kana. ");
INSERT INTO txq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Dadi ei muste duduꞌa matalolole dedeꞌak kara iar. Hatahori mana nau sangga bubuluk tebe-tebe Manetualain hihii-nanaun, ana boe nalela. Tehuu hatahori ta mana tao matak neu Manetualain hihii-nanaun, ana boe namanggoa.” ");
INSERT INTO txq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Laꞌe esa, Yesus mbute-mue no hatahori noꞌuk kara. Boe ma Ndia inan ma fadin nara mai fo rae ratonggo roon. Tehuu ara ta bisa deka-deka roon, nahuu hatahori noꞌun seli. ");
INSERT INTO txq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Boe ma hatahori neu nafada Yesus nae, “Papa! Papa mamam ma fadim mara rai dea naa. Ara rae ratonggo ro Papa.” ");
INSERT INTO txq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Boe ma Ana naselu nae, “Hou! Tehuu talo ia, Au inang ma toranoong tebe-teben nara ndia, hatahori fo mana namanene Manetualain Dedeꞌa-kokolan, de tao tunggan.” ");
INSERT INTO txq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Laꞌe esa Yesus noke nala ana nunin nara, de nae, “Mai ita saꞌe ofak fo teni dano boboan seri teu.” Boe ma ara saꞌe ofak esa, de ara mulai laꞌo. ");
INSERT INTO txq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Neu ofak laꞌok, boe ma Yesus sunggu. Ta dook ka boe ma ani makarumbuk mai. Rii tufa, de oe lala neni ofak dale neu. De ara sangga hambu sosoek ena. ");
INSERT INTO txq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ana nunin nara mete-rita naa, boe ma ara fafae Yesus rae, “Lamatuak! Lamatuak, ee! Mambadeik fo tulun dei! Ita sangga molo mate ia ena!” Boe ma Yesus nambadeik. De Ana kaꞌi anin ma rii naa nae, “Hahae leo!” Boe ma rii ma anin lende tutik kana. ");
INSERT INTO txq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Boe ma Ana nahara berak neu ana nunin nara nae, “Tao hata de ei bei ta mamahere neu Au boe?” Ara ramataꞌu ma heran. Boe ma esa natane esa nae, “Awii! Yesus ia see? Talo bee de Ana bisa parenda anin ma rii, de ara tungga Ndia hihii-nanaun?” ");
INSERT INTO txq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ta dook ka boe ma, ara losa nusa Gerasa nai dano Galilea boboan seri. ");
INSERT INTO txq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Numa naa, hambu hatahori esa fo nitu saꞌen dook ka ena. Hatahori ia uma taak, de ana leo nai kada rates sara. Tungga faik ana laꞌo neu-mai no hola-hola, nahuu nitur parendan taa-taa. Hatahori futu-paꞌan laꞌe-laꞌek kana pake rante ma langge besi ena, tehuu ana kada tao ketu sara. Boe ma nitur kada rakasetik kana fo nalai neni mamana nees neu. Neu Yesus asa konda numa ofak lain mai, hatahori kamuluk naa neni Yesus mai. Hatahori naa kii-bolu ma ana lenggu-bara aon neu Yesus ein. Boe ma Yesus parenda nae, “Heeh, nitu! Kalua numa hatahori ia mai!” Boe ma hatahori kamuluk naa kii-bolu nae, “Wooi! Boso pode-ura babalik au! Au bubuluk O ia Yesus, Manetualain mana Demak Mateꞌen Anan! O boso tuni-ndeni au!” ");
INSERT INTO txq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus natanen nae, “O nadem see?” Boe ma nitu naa naselu nae, “Legion, huu ai noꞌuk ka, nok bali soldadu rifu-rifuk kara.” Ana kokolak talo naa, nahuu hambu nitu noꞌuk ka maso leo nai aon dale. ");
INSERT INTO txq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nitur raa kada roke-hule taa-taa neu Yesus fo boso nadenu sira reni Bolo Doidosok reu, fo ndia mamana kekenak soa-neu koasa manggarauk kara. ");
INSERT INTO txq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tehuu deka-deka naa, hambu bafi bubua moꞌok esa, ara sosoka dae fo sangga nanaꞌak ruma letek tatain. Boe ma nitur raa roke-hule neu Yesus rae, “Madenu ai maso meni kada bafir raa dale miu leo!” Boe ma Yesus nakaheik. ");
INSERT INTO txq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","De nitur raa kalua laꞌo ela touk naa, boe ma ara maso reni bafir raa dale reu. Basa bafir raa ramulu, boe ma ralaik ramananauk kana tuda ruma letek naa mai, de mbesi reni dano dale reu. Boe ma basa sara mate rasamele. ");
INSERT INTO txq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mana manea bafir mete-rita naa, boe ma ralai ndule nggorok matia-taik marai naar, de ara tui basa-basan. ");
INSERT INTO txq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hatahori noꞌuk kara raa ramanene rala tutuik talo naa, boe ma ara kalua reni mamanak naa reu. Ara nau mete-rita ro mata heli-helin nara hata fo mandadik ena. Losa naa, boe ma ara mete-rita hatahori fo nitu saꞌek naa, nanggatuuk matu-matu deka Yesus ein. Ana pake bua-loꞌa ena, ma ta namulu ena. Basa sara mete-rita naa, boe ma ramataꞌu. ");
INSERT INTO txq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","De hatahorir fo bebeik kara mete-rita mandadik naa, ara tui hatahori mana bei fo maik kara, talo bee de hatahori kamuluk naa hai ena. ");
INSERT INTO txq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Boe ma basa hatahori Garasa fo mana leo numa nusak kara raa roke-hule neu Yesus fo laꞌo ela sara, nahuu basa sara ramataꞌu ralan seli. Boe ma Yesus asa hene reni ofak dale reu, fo rae fali reni dano Galilea boboan seri reu. ");
INSERT INTO txq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tehuu hatahori fo bebeik kara nitu saꞌek naa, kokoe nakandoo Yesus nae, “Papa! Naa fo au oo tungga ua Papa boe!” Tehuu Yesus naselun nae, ");
INSERT INTO txq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Talo kada ia! Malole lenak o fali muni o nufanelum mara muu, fo tui sara laꞌe-neu Manetualain susuen fo Ana taon fee o ena.” Boe ma hatahori naa laꞌok ndule kota naa, de ana tui neu basa hatahorir laꞌe-neu Yesus tao nahai ndia. ");
INSERT INTO txq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Basa boe ma Yesus asa saꞌe ofak fali reni dano Galilea tatain seri reu. Neu ara konda numa ofak lain mai, hatahori noꞌuk ka rahani a ena. Ara rakarumbu mai fo rae reu sorun. ");
INSERT INTO txq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Numa naa oo hambu hatahori esa nade Yairus boe. Hatahori ia, malangga uma huhule-haradoik nai kota naa. Anan, kada kisek; ina anak, teun salahunu dua. Hatematak ia ana fetok naa namahedi nalan seli ela kada faa maten. Neu Yairus mete-nita Yesus mai, boe ma ana neu sendek luu-langgan neu Yesus matan. Ana noke-hule Yesus neni ndia uman neu, fo tulu-fali ndia ana feton. Neu Yesus nakahuꞌun, boe ma ara laꞌo reni Yairus uman reu. Tehuu hatahori noꞌuk kara oo ta rala neun fo rae tungga boe. Huu naa de ara laꞌok raseseti. ");
INSERT INTO txq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hambu inak esa oo laꞌok tungga no sara boe. Ana hambu bulak ta tungga ndoon teuk salahunu dua ena. Ana nabasa tali-doin ma hata-heton ena fo bae neu doter asa. Tehuu ta hambu esa bisa tao nahain boe na. Hedin naa, kada mai-maik nakandoo. ");
INSERT INTO txq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Boe ma ana mai deka-deka neu Yesus numa dean mai. De ana nafaroe Yesus badun suꞌun. Neu ana nafaroe basa, boe ma ndia daan mana mboꞌa-mboꞌak hahae tutik kana. ");
INSERT INTO txq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","No kaiboik Yesus nambariik, boe ma Ana natane nae, “See ndia nafaroe Au ia?” Tehuu ta hambu hatahori esa manaku boe na. Boe ma Petrus nae, “Lamatuak boe oo! Hatahori noꞌuk ka raseseti talo ia! Sira ena, ndia ratumbu ruma dea mai.” ");
INSERT INTO txq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tehuu Yesus nafadan nae, “Taa! Bebeik kara ia Au ameda hambu koasa kalua numa Au mai. Dadi Au bubuluk hambu hatahori esa nafaroe Au.” ");
INSERT INTO txq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Neu inak naa nameda neu ko ndia ta bisa nafuni nala aon, boe ma namataꞌu nalan seli. Ana dere bebe-bebe, de sendek luu-langgan neu Yesus matan. De ana tui ndia dedeꞌan huu-suꞌun neu basa hatahorir matan. Basa de ana nafada nae, ndaa neu ndia nafaroe Yesus, boe ma ndia hai tutik kana. ");
INSERT INTO txq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Boe ma Yesus kokolak neun nae, “Kaꞌa inak! O hai ena, nahuu o mamahehere neu Au. Fali uma muu ngga leo no mole-damek!” ");
INSERT INTO txq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Neu Yesus bei kola-kola no inak naa, te Yairus hatahorin esa mai nafadan nae, “Awii, Papa, ee! Papa anan ta sana ena! Ana mate ena, de hae bei makasosotak Papa Meser bali.” ");
INSERT INTO txq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tehuu neu Yesus namanene hatahori naa nefadan, boe ma Ana nafada Yairus nae, “Kaꞌa! Malende o dalem! Boso babati! Mamahere neu kada Manetualain. Ana ndia tao nasoi-nasoda kaꞌa anan.” ");
INSERT INTO txq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Neu ara losa Yairus uman, hatahorir sofe naa ena. Ara buꞌi rakarereu. Boe ma Yesus kaꞌi sara nae, “Ei hahae buꞌi leo! Kakanak ia ta mate. Ana kada sunggu a!” Tehuu hatahorir kada hika korombiꞌe bafan nara mbali Yesus, huu mesa kasa ndia mete-rita kakanak naa ketu hahaen ena. Boe ma Yesus noke nala ana fetok naa ina-aman, Petrus, Yohanis ma Yakobis, maso dale reu sama-sama ro Ndia. Sira laen nara, Ana nadenu sara rahani kada dea. ");
INSERT INTO txq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ara maso, boe ma Yesus toꞌu nala kakanak naa liman, de nanggou nae, “Ana feꞌok! Mambadeik leo!” ");
INSERT INTO txq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Medak neu ma, kakanak naa nasoda fali numa mamaten mai, de nambadeik tutik kana. Boe ma Yesus nadenu ana fetok naa inan nae, “Fee kakanak ia naꞌa dei!” ");
INSERT INTO txq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ana fetok naa inan no aman heran ralan seli. Tehuu Yesus fee nesenedak neu sara, fo boso fee dedeꞌak naa natanggela neni hatahorir reu. ");
INSERT INTO txq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Laꞌe esa, Yesus nakabubua nala Ndia ana nuni kasalahunu duan nara. Boe ma Ana fee sara koasa fo bisa husi nitu, ma bisa tao rahai hatahori ruma sira hedin mata-matak kara mai. ");
INSERT INTO txq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ana nadenu sara fo laꞌok reu rafada hatahorir laꞌe-neu Manetualain parenda-koasan. Ana oo nadenu sara fo tao rahai hatahori hedis sara sudi rai bee boe. ");
INSERT INTO txq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma Ana nafada sara nae, “Masaneda matalolole! Ei hae meni hata-hata nai dalak. Meni kada badu manai ei ao-inam. Hae meni teteꞌe ai, do tas, do lepa-nggees, do tali-doik. Badu ngganggatik oo hae meni boe! ");
INSERT INTO txq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mete ma ei maso meni nggorok esa miu, ma hambu hatahorir rae simbok ei, na, miu fo leo nai kada sira uman nara. Boso dodoki uma. Leo miu naa makandoo, losa ei laꞌo ela nggorok naa. ");
INSERT INTO txq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mete ma ei maso meni nggorok esa miu, basa de hatahorir marai naa ta nau simbok ma ta nau ramanene neu ei, na, nggani laꞌo ela sara leo. Mete ma ei kalua numa mamanak naa mai, tao tungga dala-hadak fo ngganggafu heni afu numa ei eim mara mai. Ma mafada sara mae, ‘Ei ta nau mamanene na. De ela numa naa fo ei mesa ngga lemba-masaa neselu-netaam!’ ” ");
INSERT INTO txq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Basa boe ma ana nunik kara raa laꞌok numa nggorok esa mai reni nggorok esa reu. Ara tui-bengga hatahorir laꞌe-neu Manetualain Hara Lii Malolen. Boe ma ara oo tao rahai hatahori kamahedik kara boe. ");
INSERT INTO txq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Faik naa, tutuik mata-matak kara laꞌe-neu Yesus losa manek Herodes Antipas ndiꞌi doon ena. Ana namanene tutuik kara raa, boe ma ana panggananaa, nahuu hambu hatahori ketuk rae, “Yesus naa, ndia Yohanis Mana Saranik fo mana nasoda fali numa mamaten mai ena.” ");
INSERT INTO txq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Hambu ketuk bali rae, “Ndia naa, baꞌi Elia fo mana nasoda fali numa mamaten mai ena.” Hambu laen bali rae, “Ndia naa, esa numa Manetualain mana toꞌu dedeꞌan lele uluk laen nara mai.” ");
INSERT INTO txq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tehuu Herodes nasaneda nae, “Fai maneuk kara au adenu tete heni Yohanis langgan ena. Ana nasoda fali numa mamaten mai ena, do hata? De esa ia, see bali?” Boe ma ana sangga dalak fo nae natonggo no Yesus. ");
INSERT INTO txq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Faik esa, ana nunik kara fo Yesus nadenu sara reu tui-bengga Manetualain Hara Lii Malolen naa ena, ara fali de rakabua seluk ro Yesus. Ara rafadan basa hata fo ara taok ena. Boe ma Yesus asa laꞌo neneek reni mamanak esa reu deka no nggoro Betsaida fo reu hahae aon numa naa. ");
INSERT INTO txq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tehuu hatahori noꞌuk kara hae hambu Yesus asa rae bee reu, boe ma ara tungga doꞌo-doꞌo roon. De Yesus simbok kasa no malole, boe ma Ana tao nahai basa hatahori hedis sara, ma Ana tui sara laꞌe-neu Manetualain parenda-koasan. ");
INSERT INTO txq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Neu ledo bobok ena, boe ma ana nuni kasalahunu duan nara fee hahambuk neu Yesus rae, “Malole lenak Papa madenu hatahorir ia reni nggorok matia-taik marai ia reu, fo ara bisa sangga aon nanaꞌan nara. Ma naa fo ara reu sangga mamanak fo ara sunggu taak. Mamana nees talo ia, na, talo bee fo ara bisa hambu nanaꞌak?” ");
INSERT INTO txq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Tehuu Yesus naselu nae, “Talo ia! Naa fo ei ndia mahao sara leo!” Tehuu ara rareresi rae, “Awii, Papa dei! Hata de bisa talo naa? Hatahorir ia, rifun lima lenak! Naa, bei kada touk kara, bei ta reke inak kara ma kakana anak kara bali! Naa te ita rotin kada lima, ma iꞌak duak ka. Mete ma Papa nau ai mahao basa hatahori noꞌuk kara iar, na, talo bee fo ai bisa hasa nanaꞌak noꞌun seli fee sara?!” Boe ma Yesus nadenu sara nae, “Koladu hatahori iar fo ranggatuuk rakabubua beke lima huluk.” ");
INSERT INTO txq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","De ara reu tao tungga talo naa. ");
INSERT INTO txq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Neu ara ranggatuuk rala, boe ma Yesus haꞌi nala roti kalimak kara ma iꞌa kaduak kara. De Ana nasare mbali lalai neu fo hule-haradoi noke makasi. Basa boe ma Ana fifiꞌi baꞌe roti ma iꞌak kara raa, de Ana loo sara reu ana nunin nara fo reu babaꞌe fee hatahorir raa. ");
INSERT INTO txq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Basa sara raꞌa losa rakabete. Basa boe ma rakabubua rala nanaꞌa lenan nara raa, losa sofe lembaneu salahunu dua. ");
INSERT INTO txq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Laꞌe esa, Yesus mesa kana hule-haradoi numa mamanak esa. Ana nunin nara oo rakabua deka-deka roon numa naa boe. Ana hule-haradoi basa, boe ma natane sara nae, “Ei mamanene hatahorir kola-kola rae, Au ia see?” ");
INSERT INTO txq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ara raselu rae, “Hambu ketuk rae, Papa ia, Yohanis Mana Saranik. Laen bali rae, fama te Papa ia, baꞌi Elia. Mete ma taa, na, Hatahori esa numa Manetualain mana toꞌu dedeꞌan lele uluk fo mana nasoda fali numa mamates mai ena.” ");
INSERT INTO txq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Boe ma Yesus natane seluk kasa nae, “Mete ma tungga ei mesa ngga, na, ei duꞌa mae, Au ia see?” Boe ma Petrus naselu nae, “Papa ia, Karistus, ndia Hatahori fo Manetualain henggenee memak kana numa lele uluk mai ena!” ");
INSERT INTO txq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Basa de Yesus ndindia sara fo boso rafada esa boe na rae, Ndia naa, Karistus. ");
INSERT INTO txq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Basa boe ma Yesus kokolak seluk nae, “Au ia, Hatahori Dae-bafo Isi-isik. Au muste lemba-asaa doidoso berak mata-matak kara. Neu ko hatahori Yahudi lasi-lasi hadan nara, malangga anggama malanggan nara, ma meser anggamar ta nau simbok rae, Au ia, Karistus. Basa te neu ko ara tao risa Au. Memak Au mate, tehuu neu bei-nesan, Au asoda fali numa mamates mai!” ");
INSERT INTO txq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Basa boe ma Ana nafada hatahori noꞌuk kara nae, “Hatahori fo mana nau tungga Au, ana muste nakatataka nakandoo tungga-tungga faik. Ana muste solaa heni basa ndia hihii-nanau heli-helin. Ana muste tungga nakandoo, mae hatahori rae tao risan, sama leo hatahori lemba-nasaa ai ngganggen fo neni ndia mamana mamaten neu. ");
INSERT INTO txq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Hatahori fo mana sadia mate, nahuu ana tungga Au, neu ko nasoda nakandoo no Manetualain. Tehuu hatahori fo mana nau nasoda soa-neu kada ndia ao heli-helin, neu ko ana natalenggo feꞌe numa Manetualain mai. ");
INSERT INTO txq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mete ma hatahori hambu basa dae-bafok oe-isin, tehuu Manetualain timba henin, na, ana hambu nanalak hata? ");
INSERT INTO txq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Au ia, Hatahori Dae-bafo Isi-isik. Dadi hatahori see fo ana mae tungga Au, ma mae toꞌu Au nenoring, neu ko Au oo mae manakun nai Manetualain matan boe, neu Au fali numa nusa tetuk do inggu temak mai. Neu ko Au konda mai ua Amak koasan ta neni babanggak, sama-sama ua Ndia atan numa nusa tetuk do inggu temak mai. ");
INSERT INTO txq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Au afada tebe-tebe neu ei. Hambu ketuk numa ei marai iar, neu ko mete-rita ro mata heli-helin nara Manetualain parenda-koasan, dei fo ara bisa mate.” ");
INSERT INTO txq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Seli fai kafalun numa Yesus nafada laꞌe-neu mamaten ma nesoda falin numa mamates mai, boe ma Ana no Petrus, Yohanis ma Yakobis hene reni letek esa reu fo rae hule-haradoi. ");
INSERT INTO txq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Neu Yesus hule-haradoi, boe ma mata-aon nasafali ma bualoꞌa-papaken dadi neu muti manggahadok. ");
INSERT INTO txq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Medak neu ma, hatahori dua toda mai. Hatahori kaduak kara raa, baꞌi Musa ma baꞌi Elia siran ena. Boe ma ara kola-kola ro Yesus. ");
INSERT INTO txq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mete sara oo ta hohoꞌa ndoos sudi selik kana boe. Telu sara kola-kola laꞌe-neu Yesus neu ko maten nai Yerusalem. ");
INSERT INTO txq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Faik naa, Petrus no nonoon kaduan nara tekaur ralan seli, losa ara sunggu seli. Ara rambadeik, boe ma mete-rita Yesus nambariik no hatahori dua. Ara oo mete-rita Yesus nandela-nasaꞌa boe. ");
INSERT INTO txq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Neu baꞌi Musa no baꞌi Elia rae laꞌo ela Yesus ena, boe ma Petrus namananauk kana, ta bubuluk ana nae tao hata. Boe ma ana baro lelik nae, “Lamatuak! Ai mameda malole nai ia, ee! De malole lenak ai mambaririik laak telu. Esa soa-neu Lamatuak, esa soa-neu baꞌi Musa, ma esa bali soa-neu baꞌi Elia.” ");
INSERT INTO txq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tehuu neu ana bei kola-kola talo naa, sosoꞌa bubuak esa konda mai de tatana nala sara. De Petrus asa ramataꞌu. ");
INSERT INTO txq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Boe ma ara ramanene harak numa sosoꞌak naa dale mai nae, “Ia, Au Anang fo Au here memak kana ena! Ana kokolak, na, nenene matalolole neun!” ");
INSERT INTO txq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Harak naa hahae, boe ma Petrus asa mete-rita kada Yesus mesa kana. Telu sara rakatema bafan nara fo ta tui neu esa boe na, hata fo ara mete-ritak naa. Doo-doo dei de ara buka bafan nara fo tui neu hatahori laen. ");
INSERT INTO txq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Neu beꞌe-mai fo Yesus no Petrus asa konda numa letek naa mai, hatahori noꞌuk ka mai ratonggo ro Yesus. ");
INSERT INTO txq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Boe ma hambu hatahori esa bolu neun nae, “Papa Meser, ee! Tulun mete neu au ana tou kise-muꞌeng dei! ");
INSERT INTO txq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Huu nitu kada toꞌu naherek kana, de tao nalan kii-bolu kaiboik, ma ndondokon losa fufudek kara kalua numa bafan mai. Nitu naa oo popoko-paparun boe, ma ana tao babalik kana taa-taa. ");
INSERT INTO txq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Au hule tutulu-fafalik neu Papa ana nunin nara ena fo husi kalua heni nitu naa, tehuu ara ta rasenggi sana!” ");
INSERT INTO txq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesus namanene nala naa, boe ma Ana mboka basa sara nae, “Weeh! Ei ta mamahere mae, Manetualain bisa tao nahai hatahori, do? Eir ia, memak hatahori ta mana leo-laꞌo tungga eno-dala ndoos! Au muste sama-sama ua ei doon losa bee bali, ma ahani ua ei losa faik hida bali, dei fo ei mamahere neu Au?” Boe ma Ana kokolak nasafali no papa naa nae, “Muni o anam neni ia mai leo!” ");
INSERT INTO txq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Neu ara roo kakanak naa neni Yesus neu, boe ma nitu naa fae nggari kakanak naa neu daer, ma ndondoko nakamiminak kana. Tehuu Yesus parenda nitu naa, fo kalua laꞌo ela kakanak naa, boe ma ana hai tutik ka. De Yesus loo lima kakanak naa neu aman. ");
INSERT INTO txq_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Hatahori mana mete-rita Manetualain koasan ta neni babanggak naa, basa sara heran bali-bali. ");
INSERT INTO txq_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Neu basa hatahori bei bese kola laꞌe-neu tanda heran nara fo Yesus taok, Ana nafada Ndia ana nunin nara nae, ");
INSERT INTO txq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ei tadu matalolole Au kokolang ia! Ta dook ka bali te ara rae seꞌo heni Au, Hatahori Dae-bafo Isi-isik ia. Boe ma ara loo lima Au uni hatahori deak kara uu.” ");
INSERT INTO txq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tehuu ana nunin nara panggananaa. Ara ta ralela Ndia kokolan naa. Ara oo ramataꞌu ratane sosoa-ndandaan hata boe. ");
INSERT INTO txq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Laꞌe esa, Yesus ana nunin nara mulai rareresi laꞌe-neu see ndia dadi neu hatahori nomer kaesan numa sira mai. ");
INSERT INTO txq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tehuu Yesus bubuluk ara rareresi huu hata. Boe ma Ana nanggou nala kakana ana esa, de Ana nambaririik kana neu Ndia boboan. ");
INSERT INTO txq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Boe ma Ana nafada sara nae, “Nenene matalolole! Hatahori mana tungga Au fo naono-lalau hatahori kadiꞌik sama leo kakanak ia, sosoa-ndandaan nae, hatahori naa oo naono-lalau Au boe. Ma ana oo naono-lalau Au Amang manai nusa tetuk do inggu temak boe, fo mana madenu Au uni dae-bafok ia mai. Hambu hatahori noꞌuk ka hii rakadadaek hatahori kasian, hatahori mana susa-sonak, hatahori ta neulauk, hatahori ua kadorok, ma hatahori kadiꞌik. Tehuu hatahori fo mana naono-lalau hatahori matak leo naak kara, na, Manetualain taon leo hatahori ta hohoꞌa ndoos.” ");
INSERT INTO txq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Basa de Yohanis nafada Yesus nae, “Lamatuak! Laꞌe esa, ai mete-mita hatahori esa husi kalua heni nitu pake Papa naden. De ai kaꞌin fo boso naseseik Papa naden, nahuu hatahori naa, ta ita hatahorin.” ");
INSERT INTO txq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tehuu Yesus naselu nae, “Elan numa naa! Huu hatahori ta mana lena-laba ita, sosoa-ndandaan nae, ndia naa, ita nonoo heli-helin.” ");
INSERT INTO txq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus bubuluk nae, Ndia fai hehenen neni nusa tetuk do inggu temak neu ta dook ka ena. Boe ma Ana nakise basa ena fo neni kota Yerusalem neu. ");
INSERT INTO txq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ana nadenu hatahorir fo laꞌok rakahuluk ruma sira mai, mita fo ara bisa sadia nanaꞌa-nininuk. Boe ma ara maso reni nggorok esa nai profensi Samaria reu, fo rae sangga mamana luꞌu-leok. ");
INSERT INTO txq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tehuu hatahori Samariar ta nau simbok Yesus asa, nahuu Ana nae laꞌo neu nakaluku-nakatele neu Manetualain nai kota Yerusalem. ");
INSERT INTO txq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Neu Yakobis no Yohanis ramanene hatahori Samariar tatao-nonoꞌin, boe ma ara kokoe Yesus rae, “Lamatuak! Talo bee leo ita toke Manetualain nakonda aꞌi numa lalai mai fo naꞌa heni basa sara?” ");
INSERT INTO txq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tehuu Yesus nasare mbali dua sara, boe ma nahara berak mbali sara nae, “Hae duꞌa talo naa.” ");
INSERT INTO txq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Boe ma ara laꞌok rakandoo reni nggorok laen reu. ");
INSERT INTO txq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Neu ara bei laꞌo-laꞌo numa dalak, hatahori esa kokolak no Yesus nae, “Papa! Papa neni bee neu a mesan, na, au nau tungga akandoo ua Papa!” ");
INSERT INTO txq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesus naselu nae, “Malole, boe! Tehuu masaneda talo ia. Basa hatahorir ma banda-manur kamamana leleo-luluꞌuk mesan. Busa fui fali neni ndia bolo luluꞌun neu. Mbuik fali neni ndia ndunun neu. Tehuu Au, Hatahori Dae-bafo Isi-isik ia, ta aena uma heli-heling fo fali uni naa uu. Mamana ndae langgak neu oo, ta hambu boe.” ");
INSERT INTO txq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Laꞌe esa, Yesus nanggou hatahori laen esa nae, “Mai tungga Au, fo dadi muu Au hatahoring.” Hatahori naa naselu nae, “Neu! Tehuu talo ia, Lamatuak. Elan fo au fali fo afafaꞌu ina-amang nggara dei. Mete ma au amang maten ena, na, dei fo au tungga.” ");
INSERT INTO txq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tehuu Yesus nafadan nae, “Talo ia! Elan numa naa fo hatahorir ta mana ramahere neu Manetualain, rafafaꞌu sira hatahori mana maten. Tehuu ei mana mamahere neu Manetualain, ei uem miu tui-bengga laꞌe-neu Manetualain parenda-koasan.” ");
INSERT INTO txq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Hatahori esa bali nae, “Malole boe, Lamatuak! Au nau tungga Lamatuak akandoo. Tehuu mboꞌi au uu idu ateꞌa au nufanelung nggara, dei fo au fali mai tungga Lamatuak.” ");
INSERT INTO txq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tehuu Yesus nafadan nae, “Talo ia! Mete ma hatahori mulai dodoꞌi-kakali dae, tehuu ana nasambute no ues laen losa ana lilii sele-tande, na, osin ta dadi. Leo naak oo, soa-neu hatahori mana naketu nala nae tungga Au boe, tehuu nasaneda taa-taa neu ndia leleo-lalaꞌon fai uluk. Hatahori rupa leo naak sosoan taa, dadi neu hatahori mana maue-osa nai Manetualain parenda-koasan.” ");
INSERT INTO txq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Basa boe ma Yesus here nala ana nunik laen, hatahori hitu hulu dua. Boe ma Ana baꞌe sara dua-duak, fo rakahuluk reni mamanak kara fo Yesus nae naa neu. ");
INSERT INTO txq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ana nadenu sara nae, “Hambu hatahori noꞌuk ka sama leo hade nae namatasa. Nahani kada tenu osik nadenu ndia hatahori mana maue-osan nara fo reu ketu-koru. Dadi ei muste hule-haradoi moke Manetualain nadenu tamba Ndia hatahori mana maue-osan nara fo rakabubua rala hatahori mana nau tungga Au. Memak hatahori mana nau tungga Au naa noꞌuk ka. Tehuu hatahori mana maue-osa kada hidak ka. ");
INSERT INTO txq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hatematak ia ei miu leo! Au adenu ei fo meni hatahori noꞌuk ka miu. Tehuu masaneda talo ia. Ei sama leo bibi lombo ana dale malole, fo mana neni busa fui kakikik kara talada heon miu. ");
INSERT INTO txq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ei hae meni tali-doik, do tas bua-loꞌa, do tatabu ei lenak nai dalak. Boso nggari heni ledo-fai no muda hiek neu kada ei lole haram mara mia hatahorir rai dalak. ");
INSERT INTO txq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","8","Mete ma ei maso meni nggorok esa miu, ei boso lali-lali numa uma esa mai meni uma laen miu. Mete ma hatahori simbok ei no neulauk nai uma esa, na, leo miu kada naa leo, losa ei laꞌo ela nggorok naa. Mete ma ei maso meni uma esa miu, na, ei muste moke-hule fo Manetualain fee babaꞌe-babatik neu uma naa isin nara. Mete ma tenu uma simbok ei no neulauk, neu ko Manetualain natudu Ndia dale susuen neu uma naa isin nara. Tehuu mete ma ara ta nau simbok ei, na, naa fo Manetualain natudu dale susuen neu kada ei mesa ngga. Mete ma ei maso meni uma esa do nggorok esa miu, ara fee hata a mesan, na, miꞌa-minu leo. Simbok no nemehokok, huu neu sesesun mete ma ara fee ei talo naa fo nggati ei mbuse titim. ");
INSERT INTO txq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tao mahai sira hatahori hedin nara. Ma mafada sara mae, ‘Manetualain parenda-koasan deka-deka nai mata-iduk kara ena!’ ");
INSERT INTO txq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tehuu nggorok ketuk hatahori nara oo, ta nau simbok ei boe. Mete ma ara tao talo naa neu ei, na, miu mambariik miu nggorok naa dalan fo kokolak mae, ");
INSERT INTO txq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nenene matalolole! Ai mai meni Manetualain Dedeꞌa-kokolan soa-neu ei ena, tehuu ei ta hosek faa boe na. Dadi hatematak ia ai nggafu heni nggorok ia afun numa ai ein nara mai, fo dadi neu tanda mae, neu ko ei laꞌe aom mala nenenin! Tehuu masaneda matalolole! Manetualain parenda-koasan deka-deka nai mata-iduk kara ena!’ ");
INSERT INTO txq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ei bubuluk kota Sodom manggaraun, hetu? Au afada, ee! Neu ko ndaa no dae-bafok fai mateꞌen, te Manetualain fee hukun neu hatahori fo mana timba heni ei naa, beran lena heni hatahori Sodom mara!” ");
INSERT INTO txq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesus kokolak tamba bali nae, “Besa-besa neu ei marai nggorok Korasin ma nggorok Betsaida! Sosoek daka nala ei! Au tao tanda heran mata-matak kara numa ei matam mara ena, tehuu ei ta nau mamahere neu Manetualain. Naa te eir ia, hatahori Yahudi fo manaku mae ei malela Ndia. Tehuu mete ma tanda heran nara raa fo Au taok kara numa ei nggorom mara, leo dadi numa kota Tirus ma kota Sidon dei, na, neu ko doo basa ia, hatahori marai naa, ara sale dalen do tuke tein nara memak kana, ma ara laꞌo ela sira sala-singgon nara fo fali mai tungga Manetualain ena. Ma neu ko ara pake bua-loꞌa sususak, ma tao afu neu langgan nara fo dadi neu tanda nae, ara fale dalen nara huu sira sala-singgon nara. Naa te hatahori Tirus ma Sidon nara iar, ta hatahori Yahudi fo mana manaku rae sira ralela Manetualain. ");
INSERT INTO txq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tebe! Ei mete leo! Neu ko mete ma Manetualain naketu basa hatahorir dedeꞌan nara, na, hatahori Tirus ma hatahori Sidon hambu huku-dokik bei dakun lena heni ei huku-dokim. ");
INSERT INTO txq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Besa-besa, ei hatahori nggorok Kapernaum! Ei boso duꞌa mae, neu ko Manetualain soꞌu botik ei maso meni nusa tetuk do inggu temak miu. Taa! Neu ko Manetualain nggari ei meni aꞌi mbila ta kala matek miu! ");
INSERT INTO txq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Masaneda matalolole! Hatahori fo mana nenene ei, sama leo ana nenene Au. Ma hatahori fo ta mana nau nenene ei, sama leo ana ta nau nenene Au. Lenak bali, hatahori fo ta mana nau nenene Au naa, sama leo ana ta nau nenene Manetualain, mana nadenu Au uni dae-bafok ia mai.” ");
INSERT INTO txq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Neu hatahori nedenu kahitu hulu duak kara lenggu fali, dalen nara mbena sau-sau. Boe ma ara tui Yesus rae, “Awii! Ta hohoꞌa ndoos! Neu ai husi nitur pake Lamatuak naden, nitur raa nenene ai, basa boe ma ara kalua tutik ka! Sudi selik kana!” ");
INSERT INTO txq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Boe ma Yesus naselu nae, “Tebe! Neu ei tao talo naa, Au ita Manetualain nggari heni nitur ro sira malanggan numa lalai mai, nok bali ndelas te kii-konak kana numa lalai mai! ");
INSERT INTO txq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Masaneda, ee! Nitur malanggan naa, ita musun. Ma ana oo naena koasa boe! Tehuu Au fee ei koasa ena fo tao masenggi ndia koasan. Mete ma ei heta laꞌe mengge karasok, do kurak, na, ei ta hata-hata. Ta hambu esa tao sosoek neu ei boe na. ");
INSERT INTO txq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ei dalem mara mbena sau-sau, nahuu nitur nenene neu ei. Malole boe, tehuu naa kada dedeꞌa kadiꞌi anak! Malole lenak ei dalem mara mbena sau-sau, nahuu Manetualain surak nala ei nadem mara fo dadi miu Ndia rau-inggun fo mana maso nusa tetuk do inggu temak.” ");
INSERT INTO txq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Faik naa, Manetualain Dula-dale Malalaon tao nala Yesus dalen mbena sau-sau. Boe ma Ana koa-kio Manetualain nae, “Papa! Papa ndia toꞌu haak parenda basa-basan nai lalai ma dae-inak. Au oke makasi noꞌun seli, nahuu Papa tatana mala dedeꞌak kara iar neu hatahori fo mana tao aon malelak kara ma mana makadedema aok kara. Tehuu Papa buka basa dedeꞌak kara iar neu kakana kadiꞌi anak kara, ma hatahori fo mana makaloloe aok kara. Tebe, Papa! Naa ndia tao nala Papa dalen namahoko!” ");
INSERT INTO txq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Boe ma Yesus nafada hatahori noꞌuk kara nae, “Nenene, ee! Au Amang manai nusa tetuk do inggu temak fee basa koasa lalaꞌen neu Au ena. Mana bubuluk no tetuk nae, Au ia see, kada Amak. Ma mana bubuluk no tetuk nae, Amak naa see, kada Amak Anan fo ndia Au ia. Ma Au here ala hatahori laen fo afada sara, mita fo ara oo ralela Amak boe.” ");
INSERT INTO txq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Boe ma Yesus nasare mbali ana nunin nara, de nafada kada mesa kasa nae, “Mauak tetebes neu ei, nahuu ei mete-mita Manetualain koasan ena. ");
INSERT INTO txq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Manek kara ma mana toꞌu dedeꞌa lele uluk kara hihiik ka mete-rita hata fo ei mete-mitan ena, tehuu ara ta bisa. Ara oo hihiik ka ramanene hata fo ei mamanenek ena, tehuu ara ta bisa boe.” ");
INSERT INTO txq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Laꞌe esa, hambu hatahori mana malela hukun Yahudi esa nambariik fo nae ike Yesus. Ana natane nae, “Papa Meser! Tulun mafada dei! Au muste tao hata, mita fo au bubuluk au bisa asoda akandoo sama-sama ua Manetualain nai nusa tetuk do inggu temak?” ");
INSERT INTO txq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus naselu nae, “Baꞌi Musa surak hata laꞌe-neu dedeꞌak ia? Nai o hahambum talo bee neun?” ");
INSERT INTO txq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hatahori naa nafada nae, “Ana surak nae: ‘O muste sue-lai Manetualainlena heni basa-basan, te Ana ndia naena haak parenda o. Huu naa de o muste hii malan seli neun, maue-osa fafandek lima-eim mara fo tungga Ndia hihii-nanaun, ma malela Ndia.’ Ma neni surak boe nae, ‘O muste sue o toranoom sama leo o sue o ao heli-helim.’ ” ");
INSERT INTO txq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus bala nae, “Tebe! Mete ma o tao tungga talo naa, o masoda mua Manetualain seku neu.” ");
INSERT INTO txq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tehuu hatahori naa, tao aon leo hatahori mana matu-matuk ia. Boe ma ana natane Yesus nae, “Tehuu au ‘toranoong’ naa, ndia see?” ");
INSERT INTO txq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Boe ma Yesus naselu nae, “Talo ia! Au nau fee lololek esa. Dei fo o ndia mafada mae, see ndia o ‘toranoom’ tebe-tebe. Tutuin talo ia: Hatahori Yahudi esa laꞌok numa Yerusalem mai, konda neni Yeriko neu. Tehuu medak neu ma, hambu naꞌo manu-meor mai de ara foꞌain. Ara popokon, basa boe ma ara leꞌa rala basa tali-doin nara ma bua-loꞌan nara. Boe ma ara nggarin neni dalak tatain neu, de ara laꞌo elan. Hatahori naa, ela baꞌuk ka maten ena. ");
INSERT INTO txq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Medak neu ma hambu malangga anggama Yahudi esa oo laꞌok nesik dalak naa boe. Ana mete-nita hatahori makahinak mana malenggak numa dalak tatain, tehuu ana ta hahae fo tulu-fali sana. Ana sio nesik dalak tatain seri, de laꞌo nakandoo. ");
INSERT INTO txq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ta dook ka boe ma, hambu hatahori laen esa bali nesik naa. Hatahori naa, numa leo Lewi mai, fo ara rasiꞌe doi-sou neono-lalauk nai Manetualain Uma Huhule-haradoi Ina-huun. Neu ana mete-nita hatahori naa mana lenggu-barak numa dalak tatain, ana deka-deka mata neu meten, tehuu ana ta tulu-fali sana. Boe ma ana sio nesik dalak tatain seri de laꞌo nakandoo. ");
INSERT INTO txq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Ta dook ka bali boe ma, hambu hatahori esa numa nusa Samaria mai, nesik naa no ndia keledein. Ita basa ngga bubuluk tae, hatahori Yahudir rasiꞌe mete hatahori Samariar, na, ara pui a. Neu hatahori Samaria ia mete-nita hatahori neni foꞌaik naa, boe ma dalen tuda kasian neun. Ana deka-deka mata neu fo nau tulu-fali hatahori naa. Ana tao nalao hinan nara nenik anggor, boe ma ana rose mina neu sara. De ana mbambalu nalololen, ma ana fuan neni ndia keledein lain neu. Boe ma ana noon neni kota neu. De ana feen leo taak numa uma sesebak, ma nafafaꞌu nalololen. ");
INSERT INTO txq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Neu beꞌe-mai, hatahori Samaria naa, neu bae nakahuluk doi lilo fulak dua neu tenu uma sesebak, ma nafada nae, ‘Pake doik ia, fo mafafaꞌu malolole hatahori hedis naa losa ana hai. Mete ma ta dai, na, pake taak papa doin dei. Neu au lenggu fali, dei fo au nggati falik basa papa doin nara.’ ” ");
INSERT INTO txq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus lololen hondak kada naa. Boe ma Ana natane hatahori mana malela hukun naa nae, “Tungga o, na, see ndia ‘toranook’ tebe-tebe soa-neu hatahori neni foꞌaik bebeik kara naa?” ");
INSERT INTO txq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Hatahori naa naselu nae, “Neu ko ndia hatahori fo dalen tuda kasian neun naa.” Yesus nae, “Tebe, kaꞌa! Muu leo fo tao tungga.” ");
INSERT INTO txq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","40","Basa naa, Yesus no ana nunin nara laꞌo rakandoo reni Yerusalem reu. Boe ma ara tuli numa nggorok esa. Numa naa, hambu kaꞌa-fadik dua, nade Martaa ma Maria. Martaa noke Yesus asa fo sunggu taak nai ndia uman. De ara leo taak numa naa. Neu Yesus nanggatuuk, fo nanori hatahorir, boe ma Martaa mbute-mue no nafafaꞌu nanaꞌa-nininuk nai mamana dode-nasuk. Tehuu fadin Maria, nanggatuuk deka Yesus ein, fo nenene kokolan. Doo-doo faa, boe ma Martaa maso neu de unggu-remu mbali Yesus nae, “Papa, ee! Talo bee! Au mbute-mue alan seli afafaꞌu nanaꞌa-nininuk, naa te au fading kada nanggatuuk pasi-pasi nai ia. Tulun dei! Madenun fo ana sou au faa dei nai mamana dode-nasuk!” ");
INSERT INTO txq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tehuu Lamatuak Yesus naselun nae, “Maꞌa, Maꞌa, ee! O ia, mbute-mue duduꞌa kada mata-matak kara. ");
INSERT INTO txq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Malole, tehuu hatematak ia hambu matak esa belin lenak bali. No Maria nanggatuuk nenene Au Dedeꞌa-kokolang, ana tengga nala hata fo neulauk mateꞌen ena. Hatahori ta bisa leꞌa rala Dedeꞌa-kokolak naa numa ndia mai.” ");
INSERT INTO txq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Laꞌe esa, Yesus neu hule-haradoi. Hule-haradoi basa, boe ma Yesus ana nunin esa mai, de noke nae, “Papa! Yohanis Mana Saranik nanori ana nunin nara ena, de ara hule-haradoi ralela. Ai moke fo Papa oo manori ai hule-haradoi boe dei!” ");
INSERT INTO txq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Boe ma Yesus nae, “Malole boe! Hule-haradoi pake netuduk leo iak: Amak! Amak nadem malalao ndoos. Naa fo basa hatahorir rakadedemak Amak nadem fo ta neni babanggak naa. Naa fo Amak dadi Manek soa-neu basa hatahorir. ");
INSERT INTO txq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Amak tulun fee ai nanaꞌak mana daik tungga faik. ");
INSERT INTO txq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ai moke-hule fo Amak lilii heni ai sala-singgon nara, sama leo ai oo lilii heni hatahori salan fo ara taok neu ai boe. Amak manea fo ai ta tao manggarauk.” ");
INSERT INTO txq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Boe ma Yesus fee nenorik tamba neu sara laꞌe-neu huhule-haradoik. Ana pake lololek nae, “Taon neu leo fati ladak, hambu tia-laik numa dae dook mai, fo ana sunggu taak nai o umam. Tehuu o ta hambu hata esa boe na, fo feen naꞌa-ninu. Boe ma o muni o nonoom laen esa uman muu, fo hule nasi-nasi numa dea mai mae, ‘Kaꞌa, ee! Fee taak au roti balok telu dei. Huu au hambu fuik nai uma, tehuu ai ta raꞌu ndaa hata esa boe na ia! Kaꞌa, tulun dei! Kada balok telu a boe! Dei fo au nggati!’ ");
INSERT INTO txq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Mete te o nonoom naa naselu nae, ‘Kaꞌa boe oo! Hatahori sunggu seli ena, tehuu kaꞌa mai fafae bali! Lelesur neni nggoe nisak kara ena, ma! Kakanak kara sunggu seli ena. Boso mamanasa, ee! Laꞌe esa bali dei kaꞌa!’ ");
INSERT INTO txq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Leo mae talo naa oo, tehuu masaneda matalolole boe. Leo mae hatahori naa ta nambadeik fo fee o, nahuu o, ndia nonoon, de mete ma o kada moke makandoo, neu ko ana nambadeik fo fee o. ");
INSERT INTO txq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Leo naak oo soa-neu hule-haradoik boe. Moke-hule makandoo neu Manetualain; neu ko Ana fee. Sangga makandoo; neu ko Ana natudu dalak. Manggou makandoo; neu ko Ana soi lelesu. ");
INSERT INTO txq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Basa hatahori mana noke nakandoo neu Manetualain, neu ko simbo. Mana sangga nakandoo, neu ko hambu. Mana nanggou nakandoo, neu ko Ana soi lelesu. ");
INSERT INTO txq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hena ei duꞌa sudik kana! Hambu nai bee amak esa, mete ma anan noke iꞌak, na, ana feen mengge? ");
INSERT INTO txq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Do, anan noke manu tolo, na, ana feen kurak? Ta bisa leo naak, hetu? ");
INSERT INTO txq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hatahori dae-bafok, memak numa netehuun mai manggarauk. Tehuu ei Amam manai nusa tetuk do inggu temak naa, netehuun neulau ndoos. Dadi mete ma hatahori dae-bafok manggarauk matak leo kada ei ia, hii fee hata fo neulauk neu ei anam mara, hata-bali Amak! Ana ta fee kada hata fo ei toꞌa, tehuu lenak bali, Ana fee Ndia Dula-dale Malalaon neu hatahorir fo mana noke-hule neun.” ");
INSERT INTO txq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Laꞌe esa, Yesus husi kalua heni nitu numa hatahori nggoak esa mai. Boe ma hatahori naa mulai kokolak nala nasafali. Hatahorir maruma naa, heran bali-bali. ");
INSERT INTO txq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tehuu hambu ketuk rae, “Memak, Ana bisa husi heni nitu! Te Ana hambu koasa numa nitur malanggan mai fo ndia Balsebul na.” ");
INSERT INTO txq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hatahori laen nara rae sangga soba Yesus. Boe ma ara roken fo Ana tao tanda heran esa bali natudu neu sira nae, memak Ndia koasan numa Manetualain mai. ");
INSERT INTO txq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tehuu Yesus bubuluk memak sira ute manggaraun nara. De Ana kokolak nae, “Mete ma nai nusak esa, rau-inggun nara rahuur-ratofak, neu ko nusak naa nakalulutu. Leo naak oo, mete ma nai uma esa dale, uma isin nara leo-laꞌo ro kada rareresi esa no esa, na, neu ko uma-loo naa, tetu-teman ta ena boe! ");
INSERT INTO txq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","De mete ma nitur hii kada rahuur, ma esa husi esa, na, sira malanggan ta bisa toꞌu parenda nala dook ka ena bali! Dadi ta maso nai duduꞌak, mete ma ei mae, Au pake nitur koasan fo husi nitu bali! ");
INSERT INTO txq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Masaneda, ee! Ei hatahorim mara oo, ralela husi nitu boe. Ara pake nitu koasan, do? Taa, hetu! Dadi ei boso kokolak sadi ndaa mae, Au pake nitu koasan fo husi-mbuu nitu. Dei fo ei hatahori heli-helim mara ndia raketu rae, hata fo ei makasasaꞌek salak naa, sala. ");
INSERT INTO txq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tehuu mete ma tebe-tebe Au husi-mbuu nitu pake Manetualain koasan, na, natudu nae, Manetualain parenda-koasan nai ei idu-matam ena. Nai ia ena, tehuu nok bali ei ta bubuluk. ");
INSERT INTO txq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mete ma hatahori kalakak esa pake tee-tande kii-konak fo nanea natalolole ndia uman, neu ko basa ndia hata-heton, lino-lendek. ");
INSERT INTO txq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tehuu neu ko hambu esa barakain lena heni ndia mai nasenggin, ma ndondo neni hatahori naa tee-tanden nara. Basa boe ma ana huru neni hatahori naa hata-heton nara fo ana babaꞌe neu ndia ana nunin nara. Doo basa ia ena, hatahori kalakak naa namahena neu ndia tee-tanden. Tehuu hatematak ia ana ta namahena neu tee-tandek kara ena bali. ");
INSERT INTO txq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Masaneda matalolole! Hatahori fo ta mana mabua-aok esa no Au, ndia naa, Au musung. Ma hatahori fo ta mana tulun Au ue-osang, na, ndia naa, kada nakalulutu bua-aok.” ");
INSERT INTO txq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus kokolak tamba bali nae, “Neu ita husi nitu kalua numa hatahori esa mai, na, ana neni mamana nees neu fo sangga mamana hahae aok. Huu ana ta hambu mamana mandaak, boe ma ana duꞌa nae, ‘Aweꞌ! Ta hambu mamanak talo ia, de malole lenak au fali uu leo nai hatahori bakahuluk naa.’ ");
INSERT INTO txq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Boe ma ana fali, de natonggo no mamanak naa, neni sapu-saa laok ma nefafaꞌu neulauk ena. ");
INSERT INTO txq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","De nitu naa neu noke ndia nonoon hitu, manggaraun lena ndia bali. Boe ma basa sara reu leo rai hatahori naa, de ara nggafu feen. Dadi hatematak ia, hatahori naa masodan hambu sosoek lenak bali.” ");
INSERT INTO txq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Neu Yesus bei kola-kola no hatahori noꞌuk kara raa, inak esa numa naa eki nae, “O inam mauan seli, nahuu ana ndia bonggi nala O, ma ana nasusu O!” ");
INSERT INTO txq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesus naselu nae, “Tebe, mama! Tehuu mana mauan lenak bali, ndia hatahori mana pasa ndiꞌi doon fo nenene Manetualain Dedeꞌa-kokolan ma tao tunggan!” ");
INSERT INTO txq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Neu Yesus bei kola-kola, rea rakarumbu reu eko-feo rala Yesus. Boe ma Ana mulai kokolak nae, “Hatahori tembo-tanak ia, soa tao kada manggarauk. Ara kada roke taa-taa fo Au tao tanda heran fee sara, fo ara bubuluk Au ia, tebe-tebe Lamatuak hatahorin. Naa te, lele uluk Lamatuak fee tanda heran neu sara tungga Ndia mana toꞌu dedeꞌan Yunus. Naa, dai ena. ");
INSERT INTO txq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Lele uluk Yunus nafada hatahorir marai kota Niniwe nae, ara muste sale dalen do tuke tein nara dei. Hata fo dadi neu Yunus ndia lele uluk, dadi tanda soa-neu sara nae, Manetualain ndia nadenun. Leo naak oo, soa-neu Au, Hatahori Dae-bafo Isi-isik boe. Au mai afada ei, fo ei muste sale dalem do tuke teim mara dei. Ma hata fo dadi nai Au, neu ko dadi neu tanda soa-neu hatahori tembo-tanak ia nae, memak Manetualain ndia nadenu Au. ");
INSERT INTO txq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Neu ko neu dae-bafok fai mateꞌen, Lamatuak nambariik dadi neu Mana Maketu-maladi Dedeꞌak, mete te mane inak numa kona mai, nasoda fali fo dadi neu sakasii. Ana dedeu liman fo nakasasaꞌek salak neu ei basa ngga mana masodak hatematak ia nae, ‘Ei basa ngga iar, nggoa bebek kara!’ Huu lele uluk mane inak naa numa dook ka mai, fo mete-nita no mata heli-helin manek Soleman malelan. Naa te hatematak ia, hambu Hatahori nai ei talada heom, ta neni babanggak lena heni manek Soleman. Tehuu ei ta nau tao matak neun faa boe na! ");
INSERT INTO txq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ma ta kada ndia mesa kana! Mete te hatahori ruma Niniwe mai, ara oo rambariik fo dedeu ei mana masodak hatematak ia boe rae, ‘Ei basa ngga, nggoa bebek kara!’ Ara kokolak talo naa, huu fai bakahulun neu Yunus neu nafada Manetualain hihii-nanaun neu sara, boe ma ara sale dalen do tuke tein nara memak kana. Naa te hatematak ia, Hatahori ta neni babanggak lena heni Yunus nai ei talada heom, tehuu ei ta nau sale dalem do tuke teim mara faa boe na!” ");
INSERT INTO txq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus tuti kokolan bali nae, “Hatahori dede lambu tiꞌoek, boe ma ana mbedan neu mamana demak, mita fo ana tao manggaledo kama naa, soa-neu basa hatahori mana maso reni naa reu. Ta hambu hatahori dede lambu, boe ma tatanan pake ure dae fo nafuni nisan. Naa, sosoan taa! ");
INSERT INTO txq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ei matam oo sama leo lambu boe. Ana tao manggaledo ei dalem. Mete ma matak kiu-habu, na, hatahori mete hata a mesan no dale manggarauk. Tehuu mete ma matak manggaledo, na, hatahori mete hata a mesan no dale malole. ");
INSERT INTO txq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tao tetebe fo manggaledok manai ei dalem naa, saꞌan lenak bali, sama leo ledo saꞌan. Manggaledok manai ei dalem naa, boso sama leo bulan saꞌan fo fee mete-tita kada saꞌon. ");
INSERT INTO txq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mete ma ei dalem manggaledok, losa ta hambu makiuk nai buꞌuk faa boe na, neu ko ei masodam oo basa-basan manggaledok boe, nok bali hambu lambu moꞌok tao manggaledo ei masodam boe.” ");
INSERT INTO txq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus kokolak basa, boe ma hatahori esa numa partei anggama Farisi mai, noken fo neu naꞌa nai ndia uman. Losa naa, boe ma Yesus maso uma dale neu, de nanggatuuk neu mei nanaꞌak. ");
INSERT INTO txq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tehuu tenu uma heran mete-nita Yesus naꞌa, ma ta nafui oe nakahuluk, tungga hatahori Farisi hohoro-lalanen. ");
INSERT INTO txq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Boe ma Yesus nafadan nae, “Ei hatahori Farisir, ta hohoꞌak kara! Ei toꞌu mahere ei anggaman hohoro-lalanen! Ei masaneda tao malalao pinggak ma nggalas dean losa nanggadilak, tehuu ei ta masaneda tao malalao ei dale manggenggeom naa, fo manggarauk ma bare-naꞌom seli! ");
INSERT INTO txq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nggoa bebek kara ein, ee! Boso lilii-ndondou. Manetualain ndia adu manai dea. Ana oo, ndia adu manai dale boe. ");
INSERT INTO txq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tehuu malole lenak ei fee hatahori kasian nara numa hata fo ei maenam, mita fo ei bisa dadi miu lolo-laok nai Manetualain matan. ");
INSERT INTO txq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Hatahori Farisir ein, ee! Neu ko ei hambu sosoek! Laꞌe-neu fee Manetualain babaꞌek esa numa salahunu mai, ei soa kada reke basa-basan, moꞌo-kadiꞌik. Losa ei bumbu-fani kadiꞌi anan numa osi mai oo, ei reke no lutuk boe! Tehuu ei ta hosek matak bee fo nenenin lenak. Laꞌe-neu dedeꞌa susuek neu Manetualain, ma dedeꞌa ta mbeu seserik, ei lilii heni sara! Memak ita muste fee takandoo Manetualain babaꞌen, tehuu boso lilii-ndondou hata fo manenenin lenak kara. ");
INSERT INTO txq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Neu ko ei hambu sosoek! Ei soa sangga mamanak bee fo neulaun lenak nai uma huhule-haradoik dale, ma soa sangga hada-horomatak nai rea mamanan nara. ");
INSERT INTO txq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Neu ko ei hambu sosoek! Ei nok bali rates fo daen natetu ena. Hatahorir laꞌok resik naa, tehuu ara ta bubuluk rae, nai naa hambu rates, nahuu rates bafon laok, naa te nai dale kabook. Tehuu tungga ita dala-hadan, na, hatahori mana tabu laꞌe rates tao nanggenggeo ndia ao heli-helin, de ta nandaa neni uma huhule-haradoik neu. Ei hatahori Farisir sama leo rates naa! Mete numa dea mai, na, nok bali ei lao ndoos sara ia. Tehuu nai ei dalem dale sofek no kaboo mburuk kara.” ");
INSERT INTO txq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hambu hatahori malela dedeꞌa hukun Yahudi esa numa naa, nggado laik Yesus kokolan nae, “Papa Meser! Papa kokolan bebeik kara ia, ndee laꞌe ai boe!” ");
INSERT INTO txq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Boe ma Yesus balan nae, “Tebe! Ei mana malela dedeꞌa hukun Yahudir, naa fo ei oo, hambu sosoek boe! Ei ta tulu-fali hatahori ma ta tao mambadaku sira leleo-lalaꞌon nara, tehuu boe kada tao makasususak kasa no ei anggamam hohoro-lalanen kamaberan. Ma ei fee hatahori lemba-rasaa ei hohoro-lalanem mata-matak kara. Tehuu ei oo ta soba lemba sou mala berak naa no kada lima kukuk esa boe! ");
INSERT INTO txq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Neu ko ei hambu sosoek! Ei mbute-mue mia lutu tutuus fee Manetualain mana toꞌu deꞌan nara lele uluk fo fee hada-haromatak neu sara. Naa te ei bei-baꞌim mara mesa kasa ndia rakanisa mana toꞌu dedeꞌak kara raa! ");
INSERT INTO txq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ei oo, eik esa mia ei bei-baꞌim mara raa boe. Ara timba heni Manetualain mana toꞌu dedeꞌan nara ma rakanisa sara. Basa de, ei lutu tutuus fee mana toꞌu dedeꞌak kara raa, fo dadi tanda mae, ei oo mbeu tungga ei bei-baꞌim mara boe. ");
INSERT INTO txq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Huu naa de Manetualain fo mana bubuluk basa-basan, kokolak nita nae, ‘Neu ko adenu Au mana toꞌu dedeꞌang ma nedenuk laen nara, fo reni hatahori Israꞌel asa reu. Basa boe ma hatahorir raa tuni-ndeni rakamiminak ketuk ma rakanisa ketuk.’ ");
INSERT INTO txq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Hatahori mana masodak hatematak ia, muste lemba-nasaa nala neselu-netaan, numa hatahori fo mana makanisa Manetualain mana toꞌu dedeꞌan nara mai ena. Naa, reken numa Manetualain adu dae-bafok ia mai, mulai numa Habel mamaten mai losa bakadeak mateꞌen, Sakaria. Ndia naa, ndia hambu nekenisak numa mei tunu-hotuk, ma Kama Malalaok taladan nai Manetualain Uma Huhule-haradoi Ina-huun. Ei oo, lemba-masaa mala sira huku-dokin naa boe! ");
INSERT INTO txq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ei mana malela dedeꞌa hukun Yahudir ein, ee! Neu ko ei hambu sosoek! Ei toꞌu nggoek fo bisa soi lelesu fo hatahorir ralela no malole Manetualain hihii-nanaun. Tehuu ei ta maso naa miu. Manggaraun lenak bali, ei mamanggenggee hatahorir fo boso maso naa reu!” ");
INSERT INTO txq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Neu Yesus kokolak nateꞌe, boe ma meser anggama ro hatahori Farisir lurin. Mulai numa faik naa neu, ara soa ratane mata-matak kara fo rae ike ratutudak kana. Ara duduꞌa taa-taa sangga dalak de rala harak fo tao dedeꞌak roon. ");
INSERT INTO txq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Faik naa, hambu hatahori rifun hida naa, ara mai rae nenene Yesus. Ara laꞌok raseseti ma rakarumbu rala Yesus. Boe ma Ana kokolak nakahuluk no ana nunin nara nae, “Manea aom mara fo boso tungga hatahori Farisir dea-matan. Te ara soa kokolak laen, tao laen. ");
INSERT INTO txq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ara tao nok bali sira neulauk, tehuu sira dea-matan naa, neu ko neni nitak. Basa hata fo nefunik hatematak ia, neu ko neni nitak. ");
INSERT INTO txq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hata fo ei kokolak no nefufunik hatematak ia, neu ko hatahorir ramanene sara ledo-ledo. Hata fo ei kutu-nuꞌu nai kama dale, neu ko hatahorir kokolak kasa rahere nai hatahori noꞌuk ka matan.” ");
INSERT INTO txq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesus kokolak tamba nae, “Ana nggara ein! Boso bii-mamataꞌu mete ma hatahorir rae tao risa ei. Ara bisa tao risa kada ei ao-mbaam, tehuu ta bisa tao hata-hata neu ei samanem. ");
INSERT INTO txq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Au sangga afada ae, ei muste mamataꞌu neu see. Ei muste mamataꞌu neu Manetualain. Ana ndia bisa tao nisa, ma piru heni ei meni aꞌi mbila ta kala matek dale miu. De Ndia ia, ndia ei muste mamataꞌun tebe-tebe. ");
INSERT INTO txq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ei duꞌa sudik kana, mbui litik belin baꞌu hata? Belin baꞌu anak ka, hetu?! Mbuik lima belin seen dua, hetu ma! Leo mae talo naa, tehuu Manetualain ta lilii heni esa boe na. ");
INSERT INTO txq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Leo naak oo, Manetualain tao matak neu ei boe. Ana bubuluk no tetuk, ei langga bulun dook hida nai ei langgam mara. Dadi ei hae mamataꞌu, nahuu Manetualain timba-tai nala ei belim lena heni basa mbui litik noꞌuk kara raa.” ");
INSERT INTO txq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Basa de Yesus kokolak bali no Ndia ana nunin nara nae, “Pasa ndiꞌi doom mara matalolole! Mete ma hambu hatahori ta mae manaku Au nai hatahori noꞌuk ka matan nai dae-bafok ia, neu ko Au oo, ta mae manaku sana nai Manetualain atan nara matan nai nusa tetuk do inggu temak boe ae, ndia ia Au hatahoring. ");
INSERT INTO txq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tehuu mete ma hambu hatahori kokolak nai hatahori dae-bafok matan nae, ndia ta nalela Au, neu ko Au oo, kokolak nai Manetualain atan nara matan nai nusa tetuk do inggu temak boe ae, Au ta alela sana. ");
INSERT INTO txq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Au ia, Hatahori Dae-bafo Isi-isik. Mete ma hambu hatahori kokolak nakabobook Au nade maloleng, na, Manetualain bei sadia lilii heni ndia salan naa. Tehuu mete ma ana kokolak nakabobook Manetualain Dula-dale Malalaon nade malolen, Manetualain ta lilii ndia salan naa. ");
INSERT INTO txq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Neu hatahorir leꞌa reni ei meni mamana parisa dedeꞌa anggamar miu, do meni hatahorir mana parendar miu, nahuu ei mamahere neu Au, ei hae mamataꞌu masalaꞌe aom mara talo bee. ");
INSERT INTO txq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Neu ko faik naa oo, Manetualain Dula-dale Malalaon nanori ei dedeꞌa deꞌek fo nandaa no maselu mbali sara boe.” ");
INSERT INTO txq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Basa boe ma hatahori esa numa hatahori noꞌuk kara raa mai natane Yesus nae, “Papa Meser! Tulun madenu au kaꞌang fo baꞌe ai aman pusakan no au dei.” ");
INSERT INTO txq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tehuu Yesus naselun nae, “Heeh! See ndia soꞌuk Au dadi Mana Maketu-maladi Dedeꞌak fo aketu ei dua ngga dedeꞌam matak leo naak naa?” ");
INSERT INTO txq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Boe ma Yesus kokolak no basa hatahori noꞌuk kara raa nae, “Ei muste besa-besa fo boso miꞌa mata lenak. Huu hata-heto noꞌuk ka oo, ta neni fee masoda lino-lendek boe.” ");
INSERT INTO txq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Basa boe ma Ana tui lololek esa nae, “Hambu hatahori kamasuꞌik esa, osin buna-boan noꞌun seli. ");
INSERT INTO txq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Losa basa nggudang mamana mbembedak sofen seꞌe-seꞌe ena, de ana ta bubuluk tao talo bee bali. ");
INSERT INTO txq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Boe ma ana naketu nae, ‘Au nau tao talo kada ia! Au ofe heni nggudang raak kara iar, fo ambaririik seluk moꞌon lenak bali, dei fo au ahinda osi isin ma basa suꞌi-betes laen nara reu naa. ");
INSERT INTO txq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mete ma talo naa ena, na, dei fo au kokolak ua au aong ae, “Wee! Nggudang sofek ena! Nanaꞌak dai ena fo muꞌa losa teu-teuk kara. De muꞌa-minu malada-malada, ma ndae betok eim fo setelele leo!’ ” ");
INSERT INTO txq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tehuu Manetualain nafada neun nae, ‘Woi! Nggoa bebek, ee! Leꞌodaen ia oo, o mate boe. De see ndia soa basa o nggudang naa isin lalaꞌen, ee?’ ");
INSERT INTO txq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Dadi talo ia! Hatahori bisa naduduru hata-heto noꞌun seli nai dae-bafok ia soa-neu ndia ao heli-helin, tehuu nai Manetualain duduꞌan, ndia ia hata taak, nahuu ana ta malole no Manetualain.” ");
INSERT INTO txq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Basa de Yesus nanori tamba neu Ndia ana nunin nara nae, “Ei hae masambute mia masodam mara tungga faik laꞌe-neu mae miꞌa hata, do, pake hata. ");
INSERT INTO txq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Huu ita masodan ia, neulaun lena heni hata fo ita taꞌa, ma hata fo ita pake. ");
INSERT INTO txq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mete sudik mbui kaa nggeok kara! Ara ta sele-tande, ta ketu-koru, ta raena soka-pole fo rahinda nanaꞌak, tehuu Manetualain nakaboi sara. Mete ma talo naa, neu ko Ana oo bisa nakaboi ei boe, nahuu Ana timba-tai nala ei belim mara lena heni mbuik kara raa. ");
INSERT INTO txq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mete ma hatahori nambariik nasare titiro, boe ma ana kada nasambute no ao heli-helin, nai rarain ana bisa tao nambanaru ndia teu-fain, do taa? Ta bisa! ");
INSERT INTO txq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dadi mete ma ei masambute mia kada dedeꞌa kadiꞌi anak leo naak, ta neni nanalak hata esa boe na, talo bee de ei bei mae masambute mia dedeꞌa moꞌok kara bali? Nanalan hata? ");
INSERT INTO txq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mete sudik bungga fuir. Ara ta raue osi-lutur, ma ta tenu-lolo. Tehuu manek Soleman bua-loꞌan neulaun lenak oo ta bisa lena heni bungga fuir naa lolen boe. ");
INSERT INTO txq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Huu Manetualain nakaboi naꞌu kadiꞌi anak fo sosoan taa, fo mana nasoda kada faik ia, boe ma beꞌe-mai maten, fo hatahori nggarin neni aꞌi dale neu. Mete ma leo naak, Ana oo bisa nakaboi-nasamao ei fo belim mara lena heni naꞌu naa boe. Dadi tao hata de ei ta tai-mamahena neu Manetualain tebe-tebe? ");
INSERT INTO txq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Leo naak oo ei hae masambute laꞌe-neu nanaꞌa-nininuk boe. Huu neu ko Manetualain ndia koladu. ");
INSERT INTO txq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hatahorir fo ta mana tai-ramahena neu Manetualain, ara raue-osa fafandek lima-ein nara fo koladu basa matak kara raa. Tehuu eir ia, boso talo naa, nahuu Amam manai nusa tetuk do inggu temak bubuluk basa hata fo ei toꞌa. ");
INSERT INTO txq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mete ma ei makalalaꞌok makahuluk Manetualain ue-osan, neu ko Ana koladu basa matak kara iar fee ei.” ");
INSERT INTO txq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Basa de Yesus tuti seluk kokolan nae, “Ei sama leo bibi lombo bubua anak esa, fo ta raena barakaik faa boe na. Tehuu hae mamataꞌu! Ei Amam manai nusa tetuk do inggu temak naa, Mane Ina-huuk. Hata fo Ndia enan, Ana feen neu Ndia ana susuen nara no nemehokok. ");
INSERT INTO txq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dadi miu seꞌo heni basa ei bua-baꞌum mara, basa, na, doin nara miu babaꞌe fee hatahori hata taak kara. No dalak naa, ei mahinda hata-heto nai nusa tetuk do inggu temak, mamana lino-lendek ma matea ndoos. Naꞌo manu-meo ta bisa maso neu namanaꞌo nala sara. Lafo-iꞌinggir oo ta bisa raꞌa rakalulutu sara boe. ");
INSERT INTO txq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Masaneda matalolole! Ei hata-hetom nai bee, na, ei dalem oo nai naa boe.” ");
INSERT INTO txq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yesus kokolak bali nae, “Hatu-leledon ei muste mahani a fo maono-lalau neu Manetualain. Sama leo hatahori neondak beꞌe nahani tenu uma fali numa feta kabin mai. Mete ma tenu uma dedelu lelesu, na, ana bisa soin no lai-laik. ");
INSERT INTO txq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Neu tenu uma fali ma mete-nita hatahori mana maue-osar rahani a talo naa, neu ko ara raua. Neu ko tenu uma natudu dale susuen neu sara. Ana pake hatahori mana maue-osar bua-loꞌan nara, boe ma neu naono-lalau hatahori mana maue-osar raa no nanaꞌa malada-malada. ");
INSERT INTO txq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hatahori mana maue-osar raa memak raua, nahuu ara raono-lalau tenu uma no malole. Leo mae tenu uma mai liꞌu hida a mesan, fati ladak do, lole mbilak, ara rahani a taa-taa. ");
INSERT INTO txq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Duꞌa matalolole! Mete ma tenu uma bubuluk no tetuk liꞌu hida naꞌo manu-meo nae mai, neu ko ana ta fee lelak fo naꞌo manu-meo foꞌai ndia uman. ");
INSERT INTO txq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Dadi ei muste mahani a taa-taa, te ta hambu hatahori esa boe na bubuluk no tetuk faik bee, Hatahori Dae-bafo Isi-isik nae fali mai.” ");
INSERT INTO txq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Boe ma Petrus natane Yesus nae, “Papa Meser! Papa lololen bebeik kara ia, laꞌe kada ai mesa ngga do laꞌe basa hatahorir?” ");
INSERT INTO txq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Yesus naselu nae, “Lololek naa laꞌe-neu basa hatahorir fo mana tao sama leo malanggan mana koladu, fo mana malela koladu no dalen mahanik soa-neu ndia malanggan. Neu ko ndia malanggan soꞌuk kana fo dadi mana baꞌe nanaꞌak fee hatahori mana maue-osa laen nara. Mete ma ana manggate tao tungga ndia uen talo naa, mae malanggan mai neu faik bee a mesan, tehuu ana soa tao hata no tetuk. Boe ma ana hambu nanalak, nahuu ndia malanggan neu ko soꞌuk kana fo koladu basa hata-heton lalaꞌen. ");
INSERT INTO txq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tehuu sosoek mete ma malanggan mana koladuk naa, mulai duꞌa nae, ‘Mete te tou lasik dook ka dei fo ana fali.’ De ana mulai poko-femba hatahori mana maue-osa laen nara, touk ma inak. Boe ma ana nanggatuuk naꞌa-ninu no nemehokok losa mafu. ");
INSERT INTO txq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tehuu faik esa, neu malangga mana koladuk naa ta meda nala sana, nggengger neuk ka, ndia malanggan fali. Neu malanggan bubuluk dedeꞌa matak naa, boe ma ana poko-femban tutik kana. De ana husi henin, fo ana simbo nala babaꞌen nai deak sama-sama no hatahori fo dalen ta mahanik tungga ndia malanggan hihiin. ");
INSERT INTO txq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Hatahori mana maue-osa fo bubuluk ndia malanggan hihiin, tehuu ta sadia tao tungga, do ta nau tao tungga, neu ko hambu hukun berak. ");
INSERT INTO txq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tehuu hatahori mana maue-osa fo naue sala, nahuu ana ta bubuluk ndia malanggan hihiin, neu ko ana hambu hukun ta berak. Hatahori fo mana simbo noꞌuk, ndia babalan oo noꞌuk boe. Hatahori fo mana simbo ue-osa moꞌok, ndia neselu-netaan oo moꞌok boe.” ");
INSERT INTO txq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesus tuti seluk kokolan nae, “Au mai fo tada feꞌe Au hatahoring numa hatahori laen mai nai dae-bafok ia. Naa, sama leo hatahori pake aꞌi fo hotu heni dafuk. Au hihiing naa, mete fo aꞌi naa mulai mbila nai basa mamanak ena. ");
INSERT INTO txq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tehuu Au muste lemba-asaa ala doidoso berak akahuluk. Neu ko Au doidoso tebe-tebe losa Au uen basan ena dei. ");
INSERT INTO txq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ei duꞌa mae, Au mai uni mole-damek nai dae-bafok ia, do? Taa! Au mai fo tao ala hatahorir rahuur rasimbo bafak, ma tao hatahorir rabingga-baꞌek, nahuu Au nenoring. ");
INSERT INTO txq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Numa hatematak ia neu, hatahori ratoranook kara rabingga-baꞌek. Nai nufaneluk esa dale, telu laban dua, dua laban telu. ");
INSERT INTO txq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ama bonggik laban ana bonggin; ana bonggik laban ama bonggin. Ina bonggik laban ana bonggin; ana bonggik laban ina bonggin. Ari-inak laban feto-feun; feto-feuk laban ari-inan.” ");
INSERT INTO txq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Boe ma Yesus kokolak no hatahori noꞌuk kara raa nae, “Mete ma ei mete-mita sosoꞌak katek ka nai buꞌun muri, ei mae, ‘Ia tanda nae, udan sangga mai ena.’ Memak tebe leo naak. ");
INSERT INTO txq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mete ma ani konak fuu mai, na, ei mae, ‘Ia tanda nae, faik ia katobi ndoos!’ Memak tebe leo naak. ");
INSERT INTO txq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Woi! Ei hatahori dae-bafok mana dea-matak fo kokolak laen, tao laen! Ei tadu-tanda malela dae-inak ia tungga fai hanas ma fai oe faak lalalin hihiin. Tehuu tao hata de ei ta nau malela Manetualain hihii-nanaun nai hatematak ia?” ");
INSERT INTO txq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","58","Yesus kokolak tamba nae, “Mete ma ei madedeꞌa, na, tao hata de ta bisa maketu aom bee ndia ndaa! Malole lenak koladu fo mole-dame dei! Boso losak ei miu nai mana maketu-maladi dedeꞌak matan ena, boe ma ana naketu fo fee ei maso bui. ");
INSERT INTO txq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mete ma talo naa, neu ko ei ta bisa kalua, losa bae maketu basa ei hutam mara fo mana maketu-maladi dedeꞌak naketu basak naa.” ");
INSERT INTO txq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Faik naa, hambu hatahori nafada Yesus nae, nggubenor Pilatus nakanisa hatahori Yahudi hida maruma Galilea mai, neu ara reni tunu-hotuk numa Uma Huhule-haradoi Ina-huuk nai Yerusalem. ");
INSERT INTO txq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus namanene nala naa, boe ma Ana natane nae, “Ndondoon naa tungga ei duduꞌam, na, hatahori neni nekenisak kara raa salan nara moꞌon lena heni basa hatahori Galilear laen? Huu naa de ara hambu hukun mates, do? ");
INSERT INTO txq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Taa! Tehuu mete ma ei ta laꞌo ela ei leleo-lalaꞌo manggaraum mara, fo tungga falik Manetualain hihii-nanaun, neu ko ei oo hambu nekelulutuk sama leo sira boe. ");
INSERT INTO txq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Boe ma talo bee bali no hatahori kasalahunu faluk fo mana matek kara, huu manara manai Siloam ndefa henin de tuni nala sara, ndia fai maneuk kara naa? Salan nara moꞌon lena heni basa hatahorir marai Yerusalem, do? ");
INSERT INTO txq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Taa! Tehuu mete ma ei ta laꞌo ela ei leleo-lalaꞌo mana puta-paik fo tungga falik Manetualain eno-dalan ndoon, neu ko ei oo hambu nekelulutuk leo sira boe.” ");
INSERT INTO txq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Basa boe ma Yesus fee lololek esa nae, “Hambu hatahori esa naena ai huuk esa nai osin dale. Ana mai taa-taa fo sangga mete sudik ai huuk naa naboa do, beik. Tehuu ai huuk naa, bei ta naboa. ");
INSERT INTO txq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Basa boe ma ana nadenu ndia mana maue osin nae, ‘Basa teuk telu ia ena, au mai afalik fo sangga ai huuk ia boan, te ta hambu hata esa boe na. Dadi hungga henin leo, te ai huuk ia kada nanala mamana a.’ ");
INSERT INTO txq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tehuu mana maue osi naselu nae, ‘Papa boso mamanasa. Fee tembo neu ai huuk ia teuk esa bali. Mita fo au dodoꞌi ndule huun, ma fua dae maminak neun, fo doo ain neulau. ");
INSERT INTO txq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mete ma teu mana maik ia, ai huuk ia naboa, na, malole. Tehuu mete ma taa, na, neu hungga henin leo.’ ” ");
INSERT INTO txq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Laꞌe esa, ndaa no hatahori Yahudi fai huhule-haradoin, Yesus neu fee nenorik numa uma huhule-haradoik. ");
INSERT INTO txq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Numa naa, hambu inak esa nggotin mbukuk teuk salahunu falu ena, huu nitu tatao-nonoꞌin. Ana ta bisa nambariik no matetuk. ");
INSERT INTO txq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus mete-nita inak naa, boe ma Ana nanggou nalan, de nafada nae, “Ina, ee! Hatematak ia ina hai ena.” ");
INSERT INTO txq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Boe ma Yesus ndae liman neu inak naa nggotin. Medak neu ma, nggoti mbukun naa natetu tutik kana. Boe ma ana noke makasi noꞌuk ka ma koa-kio Manetualain. ");
INSERT INTO txq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tehuu malangga uma huhule-haradoik naa namanasa, nahuu Yesus tao nahai hatahori laꞌe-ndaa fai huhule-haradoik. Boe ma nafada hatahori noꞌuk kara raa nae, “Nai menggu esa dalen hambu fai ue-osa nee. De malole lenak hatahori kamahedik kara mai nai kada fai ue-osar raa, fo sangga hatahori tao nahai sara. Boso mai nai fai huhule-haradoik!” ");
INSERT INTO txq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tehuu Yesus naselu neun nae, “Weeh! Hatahori mana dea-matak. Nai fai huhule-haradoik oo ei maue-osa boe, hetu? Ei miu mboꞌi sapir ma keledeir, fo fee sara rinu oe, hetu? ");
INSERT INTO txq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Inak ia oo Abraham tititi-nonosin sama leo ita boe. Nitur malanggan futu-paꞌa nalan, doon teuk salahunu falu ena. Mete ma Au akamboꞌik kana laꞌe-ndaa fai huhule-haradoik, na, sala, do?” ");
INSERT INTO txq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus musun nara ramanene rala naa, boe ma ara mae. Tehuu hatahori noꞌuk kara raa ramahoko ro Ndia ue-tatao neulaun nara. ");
INSERT INTO txq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Boe ma Yesus tuti kokolan bali nae, “Ndondoon naa Au akasasamak Manetualain hatahorin nara sama leo hata, ee? ");
INSERT INTO txq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Makasososan bei kada hidak ka, tehuu doo-doo boe ma tamba ramanoꞌu. Sira iar, mulai sama leo kada ai deꞌe kadiꞌi anak. Hatahori sele-tanden nai osi dale. Basa boe ma ana mori, de dadi neu ai huu moꞌok. De mbuik kara mai randunu nai ndanan nara.” ");
INSERT INTO txq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Boe ma Yesus kokolak seluk nae, “Ndondoon naa Au akasasamak Lamatuak hatahorin nara, sama leo hata bali, ee? ");
INSERT INTO txq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ana sama leo laru taꞌik, fo inak kara haꞌi ralan de rumun no tarigu saak dua, fo tao roti noꞌuk ka. Boe ma tarigu naa basa sara kaifuu losa dadi moꞌok, nahuu laru taꞌik baꞌu anak naa. Lamatuak hatahorin nara leleꞌa-nonoren nara oo tamba rambaloa leo naak boe.” ");
INSERT INTO txq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Basa naa, Yesus asa mulai laꞌo reni kota Yerusalem reu. Tungga-tungga dalak, Ana tuli ndule kota ma nggorok fo nanori hatahorir. ");
INSERT INTO txq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Numa mamanak esa, hambu hatahori esa natanen nae, “Papa Meser! Fama te kada hatahori rumak ka ndia bisa hambu masoi-masodak, do?” ");
INSERT INTO txq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ana naselu nae, “Nusa tetuk do inggu temak lelesun dale neu, makabiꞌak. De maote tebe-tebe fo ei bisa maso tungga naa miu. Hambu hatahori noꞌuk ka rae soba maso, tehuu ta bisa. ");
INSERT INTO txq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mete ma tenu uma nggoe lelesu ena, neu ko ei mambariik miu dea fo dedelu lelesu, ma eki moke tulu-falik mae, ‘Lamatuak! Soi lelesu dei!’ Tehuu neu ko ana naselu nae, ‘Eir ia, see? Au ta alela ei!’ ");
INSERT INTO txq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Boe ma ei mae, ‘Talo bee de lamatuak ta nalela ai? Ai masiꞌe manggatuuk miꞌa-minu mia lamatuak. Lamatuak oo nasiꞌe fee nenorik nai ai okofoon nara boe.’ ");
INSERT INTO txq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ma neu ko Ana naselu nae, ‘Au afada bebeik kara ena, au ta alela ei! Eir ia, hatahori fo mana tao kada manggarauk. Malai heok numa ia miu!’ ");
INSERT INTO txq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mete ma Manetualain naketu-naladi basa hatahorir dedeꞌan nara, neu ko ei kada buꞌi makarereu ma henggu nisim mara. Ei mete-mita baꞌi Abraham, baꞌi Isak, baꞌi Yakob ma Manetualain mana toꞌu dedeꞌan nara, basa sara maso ranggatuuk rai nusa tetuk do inggu temak dale ena. Tehuu ei neni husi henik kara rai kada dea. ");
INSERT INTO txq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Neu ko hatahori dae-bafok manuma dae-bafok ia buꞌun nara mai, numa ledo toda mai losa ledo tesa; numa kii mai losa kona, ranggatuuk raꞌa-rinu sama-sama rai Manetualain uma mane ina-huun. ");
INSERT INTO txq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tanda matalolole matak kara iar: neu Manetualain naketu-naladi basa hatahorir dedeꞌan, neu ko hatahori see fo bakahulun tungga hatahori memeten rae, hatahori kadiꞌi anak, tehuu ana hambu hada-horomata moꞌok. Ma see fo bakahulun rae, ndia hatahori moꞌo-inahuuk, naa te Manetualain taon ndia leo kada hatahori kadiꞌi anak.” ");
INSERT INTO txq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Faik naa, hambu hatahori Farisi hida mai rasare Yesus de rafada rae, “Malole lenak Papa Meser makaheok muni mamanak laen muu, huu manek Herodes sangga nae tao nisa Papa.” ");
INSERT INTO txq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Boe ma Yesus naselu nae, “Weeh! Tou lasik naa, sama leo kue mana puta-paik. Miu mafadan mae, ‘Au husi nitur ma tao ahai hatahori kamahedik kara faik ia ma beꞌe-mai. Neu bei-nesak, dei fo Au ue-osang basan ena.’ Leo mae talo bee oo, Au bei nau tao ues baꞌu anak bali nai Au lalaꞌong uni Yerusalem uu boe. Huu hatahori Yerusalem mara fo mana soa rakanisa Manetualain mana toꞌu dedeꞌan nara. ");
INSERT INTO txq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Awii, hatahori Yerusalem mara, ee! Eir ia, kada makanisa taa-taa Manetualain mana toꞌu dedeꞌan nara, ma toko makamate nedenuk bee fo nae mai natudu Manetualain eno-dalan soa-neu ei. Laꞌi-laꞌik ka ena Au nau aduduru anea fo lopo-linu ei numa manggarauk mai, nok bali manu ina nau nakarorombo nala anan nara nai lidan dale. Tehuu ei ta nau. ");
INSERT INTO txq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hatematak ia Manetualain ta nau tao matak neu ei uma huhule-haradoin bali. Mbila-beinesak te rouk ena. Neu ko ei ta mete-mita Au, losa ei manaku mae, ‘Manetualain fee babaꞌe-babatik neu hatahori mana mai neni Manetualain naden, nahuu Manetualain nadenu Ndia ena!’ ” ");
INSERT INTO txq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Faik esa, ndaa no fai huhule-haradoik, hatahori partei anggama Farisir malanggan esa noke Yesus fo mai naꞌa nai ndia uman. Ana nanggatuuk naꞌa, tehuu hambu hatahorir makun fo sangga mete Ana tao hata laꞌe-ndaa fai huhule-haradoik. ");
INSERT INTO txq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Faik naa, hatahori esa hambu hedi mbae aok, nanggatuuk numa naa. ");
INSERT INTO txq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Boe ma Yesus natane neu mana malela hukun Yahudi ma hatahori Farisir mana ranggatuuk raꞌa sama-sama numa naa nae, “Tungga baꞌi Musa hohoro-lalanen, na, bole tao ahai hatahori kamahedik laꞌe-ndaa fai huhule-haradoik, do taa?” ");
INSERT INTO txq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tehuu ta hambu hatahori esa boe na fo buka bafan. Boe ma Yesus nafaroe hatahori kamahedik naa, de ana hai tutik kana. Basa de Yesus nadenu falik kana. ");
INSERT INTO txq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Boe ma Yesus natane seluk kasa bali nae, “Mete ma hambu kakanak esa, tuda neni oe matak dale neu laꞌe-ndaa fai huhule-haradoik, ei miu leꞌan dea mai, do taa? Mete ma sapi ndia tuda, ei elan numa naa, do ei leꞌan dea mai? Neu ko ei leꞌan dea mai. Naa sosoa-ndandaan nae, ei tao ue-osa naa ena, hetu!” ");
INSERT INTO txq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ara ramanene Yesus kokolak talo naa, tehuu ta hambu esa boe na fo bisa naselu mbalin. ");
INSERT INTO txq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Faik naa, Yesus memete hatahorir fo mana mai raꞌa feta numa uma naa. Hambu hatahori noꞌuk ka here mamanak nai mata fo reu ranggatuuk reu naa. Yesus mete-nita naa, boe ma Ana kokolak nae, ");
INSERT INTO txq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Besa-besa, ee! Neu hatahorir roke ei fo miu miꞌa feta kabin, na, boso miu sangga mamana nenggetuuk nai hatahori moꞌo-inahuuk kara mamanan. Boso losak tenu fetak noke fuir fo neulaun lenak. ");
INSERT INTO txq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mete ma talo naa, neu ko tenu fetak mai kokolak no o nae, ‘Boso mamanasa, ee! Ama lali muni dea muu dei, te au sadia kadera ia fee hatahori moꞌo-inahuuk ia.’ Boe ma o mambadeik laꞌo ela kadera naa no mamaek fo lali muu manggatuuk nai kadera fo manai dea mateꞌen. ");
INSERT INTO txq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Dadi neu o hambu nonokek, na, manggatuuk muu kadera fo manai dea mateꞌen. Dei fo tenu fetak mete-nita o, boe ma ana mai nae, ‘Papa, ee! Mai fo manggatuuk muu mata ia dei.’ No dalak naa, o hambu hada-horomatak nai basa hatahori fuir matan nara. ");
INSERT INTO txq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hatahori fo mana nakadedemak aon, neu ko Manetualain nakaloloek kana. Tehuu hatahori fo mana tao aon sama leo hatahori kadiꞌi anak, neu ko Manetualain nakadedemak kana.” ");
INSERT INTO txq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Basa naa Yesus kokolak no tenu uma nae, “Laꞌe esa bali, mete ma ama tao feta, na, boso moke kada ama nufanelum ma nonoo kamasuꞌim mara! Huu ara bisa bala ama nonokem. ");
INSERT INTO txq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Neu ama tao feta, na, moke hatahori hata taak, hatahori dokak, hatahori kekok fo ta bisa laꞌok, ma hatahori pokek kara. ");
INSERT INTO txq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Neu ko ara ta bisa bala ama nonokem. Tehuu neu ama noke sara, Manetualain ndia bala. Mete ma Ana nasoda falik hatahori kamaherek mana matek kara ena, neu ko Ana ta lilii ama dale susuen.” ");
INSERT INTO txq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hatahori fo mana nanggatuuk no Yesus mei esa, namanene talo naa, boe ma ana kokolak nae, “Mauan seli soa-neu hatahori fo mana naꞌa sama-sama nai Manetualain uma mane ina-huun!” ");
INSERT INTO txq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesus naselu mbalin nae, “Au tui talo ia: hambu hatahori esa tao feta moꞌok. Boe ma ana noke hatahori noꞌun seli. ");
INSERT INTO txq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Neu ara sadia rala feta ena, ana nadenu ndia hatahori neondan fo neu nanggou basa hatahori neni nokek kara nae, ‘Mai, te feta sangga mulai ena.’ ");
INSERT INTO txq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tehuu basa sara tui sira kai-baan mata-matak kara, mita fo ara hae mai. Esa nafada ndia kai-baan nae, ‘Awii! Au bei fo hasa ala osi esa, de muste uu mete sudik kana dei. Boso mamanasa, ee! Au ta bisa neti.’ ");
INSERT INTO txq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hambu esa bali fee ndia kai-baan nae, ‘Au bei fo hasa ala sapi luku pasan lima. Au ae uu soba sudik kasa, de oke ambon, ee!’ ");
INSERT INTO txq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Laen bali nae, ‘Au bei fo kabin, de ta bisa.’ ");
INSERT INTO txq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Boe ma hatahori neondak naa fali, de nafada ndia malanggan. Malanggan namanene nala naa, boe ma ana namanasa nalan seli. De ana parenda ndia hatahori neondan naa nae, ‘Mete ma talo naa, o kalua lai-laik leo! Muni basa okofook ma dala kabik lalaꞌen nai kota ia fo moke mua hatahori kasian, hatahori dokak, hatahori pokek, ma hatahori kekok kara.’ ");
INSERT INTO txq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Hatahori neondak naa namanene talo naa, boe ma neu noke basa hatahorir raa. Ana fali de nafada nae, ‘Papa! Basa sara mai ena, tehuu mamana rouk bei noꞌuk ka.’ ");
INSERT INTO txq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Boe ma malanggan naa nae, ‘Mete ma talo naa, na, muu seluk bali muni basa nggorok marai kota deak, losa basa osir lalaꞌen. Kokoe neu see a mesan fo mia sara mai, sadi tao masofe mamana feta ia. ");
INSERT INTO txq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nenene, ee! Hatahorir fo mana timba heni au nonokeng ia, ara ta rameda rita feta ia lole-ladan faa boe na!’ ” ");
INSERT INTO txq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Basa naa, Yesus asa laꞌo rakandoo reni Yerusalem reu. Hatahori noꞌuk ka tunggan. Boe ma Ana nasare sara, de kokolak nae, ");
INSERT INTO txq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Hatahori mana nau tungga Au tebe-tebe, ana muste sue-lai Au lena heni basa-basan: lena heni ina-aman, lena heni sao-anan, lena heni kaꞌa-fadin, lenak bali lena heni ao heli-helin. Mete ma taa, na, hatahori naa ta nandaa dadi neu Au ana nuning. ");
INSERT INTO txq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Hatahori fo ta mana nau lemba-nasaa doidosok nahuu ana tungga Au, ana ta nandaa dadi neu Au hatahoring. Hatahori fo mana nau dadi neu Au hatahoring, leo mae hatahorir tao risan oo, tehuu ana lemba-nasaa nakandoo ndia doidoson boe. ");
INSERT INTO txq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Dadi mete ma nau tungga Au, na, timba-tai matalolole dei. Haꞌi netuduk leo hatahori fo mana nae nambaririik uma katatadak. Ana muste reke natalolole doik dedesin no lutuk. Boso losak doik ta dai. ");
INSERT INTO txq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mete ma ta reke no lutuk, fama te ana dei fo tao uma fanderen, te basa doik ena. Boe ma hatahorir hika rakamamaek kana ");
INSERT INTO txq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","rae, ‘Ei mete sudik hatahori naa dei! Ana bei fo tao fanderen, tehuu bei ta hata-hata, te basa doik ena.’ ");
INSERT INTO txq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Haꞌi netuduk laen ndia dedeꞌa netatik. Manek fo mana nae natati muste nanggatuuk fo timba-tai nakahuluk no ndia nonoon nara dei. Mete ma soldadun nara kada hatahori rifun salahunu, na, ana bisa laban musu hatahori rifun dua hulu, do taa? ");
INSERT INTO txq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mete ma timba-tai basa ena, tehuu mateꞌen ma ana ta senggi netatik, na, malole lenak neu musu bei nai dook, ana nadenu memak nedenuk, fo raote kada mole-dame leo. ");
INSERT INTO txq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Leo naak oo, neu hatahori mana nae tungga Au boe. Ana muste timba-tai neu-mai nae, ana nahani a memak ena fo laꞌo ela basa-basan, do taa? Mete ma taa, na, hatahori naa ta nandaa dadi neu Au ana nuning.” ");
INSERT INTO txq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Yesus tuti kokolan no netuduk laen bali nae, “Masik naa, neulauk. Ita paken fo tao nalada nanaꞌak. Tehuu mete ma masin ta ena, na, sosoan hata bali? Ta bisa paken fo tao malada nanaꞌak kara bali. Paken fo fufuꞌa neu sele-tandek kara oo, ta bisa boe. Ita nggari henin leo. Dadi ei oo muste sama leo masik boe, fo leo-laꞌo no susue-lalaik mia basa hatahorir. See ka ndiꞌi dook, na, nenene matalolole, ee!” ");
INSERT INTO txq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Faik naa, hatahori mana susu bea ma hatahori papake taak laen nara reni Yesus reu taa-taa fo rae nenenen. Tehuu hatahori Yahudi tao sara leo, hatahori ta neulauk kara. ");
INSERT INTO txq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Hatahori Farisir ma meser anggama Yahudir mete-rita naa, boe ma ara unggu-remu rae, “Ciih! Hatahori ia, nakabua no hatahori papake taak kara. Lenak bali Ana nanggatuuk naꞌa-ninu no sara!” ");
INSERT INTO txq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesus namanene nala naa, boe ma Ana tui sara lololek ia nae, ");
INSERT INTO txq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Leo numa ei mai hambu hatahori esa naena bibi lombo natun esa. Boe ma mopo esa. Hatematak ia ana muste tao hata? Neu ko ana laꞌo ela bibi lombo kasio hulu siok kara neu mamana linok, boe ma neu sangga bibi lombo kala mopok naa losa hambu falik kana. ");
INSERT INTO txq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mete ma ana hambu falik bibi lombo naa ena, na, ana luꞌa neni falik kana no nemehokok. ");
INSERT INTO txq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Losa uma, ana noke nonoon nara, de nafada nae, ‘Ei mai fo mamahoko mia au dei! Huu au hambu falik au bibi lombong kala mopok naa ena.’ ");
INSERT INTO txq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nai nusa tetuk do inggu temak oo leo naak boe. Mete ma hambu hatahori masala-singgok esa sale dalen do tuke tein, boe ma fali neni Manetualain neu, basa nusa tetuk do inggu temak isin ramahoko. Ara ramahoko lenak bali, nahuu hatahori kisek ia fali neni Manetualain neu, lena heni nemehokok huu hatahori sio hulu sio leo-laꞌon nara ndoos ma ta laꞌo sala dalan nara.” ");
INSERT INTO txq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Boe ma Yesus tui lololek laen bali nae, “Hambu inak esa naena doi lilo fulak salahunu. Naa te, mopo esa. Hatematak ia ana nae tao hata? Neu ko ana dede lambu, de neu loti nai basa mamanak, ma sasapu uma naa losa buꞌun nara fo sangga natalolole doik naa. ");
INSERT INTO txq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Neu ana mete-nita falik doik naa, boe ma nanggou hatahori marai uma kotia-tain nara, de nafada nae, ‘Wee! Mai fo mamahoko sama-sama mia au dei! Huu au hambu falik doik kala mopok naa ena!’ ");
INSERT INTO txq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nai nusa tetuk do inggu temak oo leo naak boe. Mete ma hambu hatahori kasala-singgok esa sale dalen do tuke tein, boe ma fali neni Manetualain neu, neu ko basa ata marai nusa tetuk do inggu temak ramahoko ralan seli.” ");
INSERT INTO txq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Basa de Yesus tuti seluk ndia tutuin no lololek laen bali nae, “Hambu amak esa no ana toun dua. ");
INSERT INTO txq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Laꞌe esa, kana muri anak nafada aman nae, ‘Papa! Fee au babaꞌe pusakang hatematak ia leo!’ Boe ma aman baꞌe hata-hetor raa neu anan dua sara. ");
INSERT INTO txq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ta dook ka boe ma, kana muri anak seꞌo heni ndia babaꞌen. Boe ma ana mbomboti nala bua-loꞌan nara, de laꞌo neni nusa dook ka neu. Numa naa, ana ngganggari heni tali-doin nara no setelelek. ");
INSERT INTO txq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Neu faik fo basa doin nara, boe ma ndoe-laꞌas ta hohoꞌak daka nala nusak naa, losa ana oo toꞌa taa nalan seli boe. ");
INSERT INTO txq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Boe ma ana neu sangga ue-osa. Hambu hatahori esa numa nusak naa simbok kana, de nadenun hani bafir. ");
INSERT INTO txq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Huu ana ta nakatataka nala poꞌo ndoen ena, de ana hihiik ka naꞌa bafir nanaꞌan. Tehuu ta hambu hatahori esa boe na fo nau feen naꞌa-ninu. ");
INSERT INTO txq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Doo-doo boe ma ana mulai duꞌa neu-mai nae, ‘Nai au amang uman, basa hatahori mana maue-osar hambu nanaꞌa-nininuk losa rakabete. Naa te au nai ia ae mate, huu ndoes ena. ");
INSERT INTO txq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Malole lenak au fali uni au amang uu. Boe ma au afadan ae, “Papa! Au tao sala moꞌok mbali Manetualain ma papa ena. ");
INSERT INTO txq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Au ta andaa dadi uu papa anan bali ena. Leo mae papa simbok au dadi kada ata-dato nai papa uman oo malole boe!’ ” ");
INSERT INTO txq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ana duꞌa basa talo naa, boe ma nambadeik de fali neni aman uman neu. Bei nai dook ka te tou lasik mete-nitan ena, boe ma dalen tuda kasian neun. Ana konda numa uman mai, de nalaik neu soru anan mana falik naa ena. Boe ma tou lasik holu nalan, de idun. ");
INSERT INTO txq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kanak naa kokolak no aman nae, ‘Papa! Au tao sala moꞌok mbali Manetualain ma papa ena. Au ta andaa dadi uu papa anan bali ena.’ ");
INSERT INTO txq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tehuu aman parenda tutik ka hatahori mana maue-osan nara nae, ‘Woi! Lai-lai, ee! Miu haꞌi mala badu fo lolen lenak fo feen pake. Olu ndeli neu lima kukun ma sopatu neu ein. ");
INSERT INTO txq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Miu leꞌa mala sapi maꞌao naa fo halan, te ita tae tao feta nemehokok. ");
INSERT INTO txq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Huu au anang ia, nok bali maten ena, tehuu hatematak ia ana nasoda fali ena. Mopon, tehuu hatematak ia au hambu falik kana ena.’ Kokolak basa talo naa, boe ma ara mulai feta ramahoko. ");
INSERT INTO txq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Faik naa, ana uluk ta nai uma, te naue-osa nai osi dale. Neu ana fali, bei nai dook ka te namanene hatahorir rakaminak bua kaliik ma mete-nita ara foti-lendo. ");
INSERT INTO txq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Boe ma nanggou nala hatahori mana maue-osa esa, de natanen nae, ‘Woi! Tao setelelek hata ia?’ ");
INSERT INTO txq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hatahori mana maue-osa naa naselu nae, ‘Malanggan fadin fali mai ngga ena. De papa nadenu hala sapi fo tao feta moꞌok, huu anan fali no sodak ena.’ ");
INSERT INTO txq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ana uluk namanene talo naa, boe ma ana namanasa. Ana ta nau maso uma dale neu ena. Boe ma aman mai kokoen fo maso dale neu. ");
INSERT INTO txq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tehuu ana luri nae, ‘Papa! Duꞌa sudik kana dei! Doo-doo basa ia, au aue-osa fafandek lima-eing nggara nok bali ata-dato ia fee papa. Au ta lena-langga papa hihii-nanaun. Leo mae talo naa oo bei ta laꞌe esa boe na, papa fee nita bibi hie ana esa fo au tao feta nemehokok sama-sama ua au nonoong nggara boe. ");
INSERT INTO txq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Naa te papa anan fo mana ngganggari doik ia, neu nakaminak inak kara tao nabasa papa doin. Hatematak ia ana fali mai ngga, boe ma papa tati sapi neulaun lenak fo tao feta-dote moꞌok soa-neun.’ ");
INSERT INTO txq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tehuu aman naselu nae, ‘Au ana susueng, nggee! Nenene besa-besa dei! Doo basa ia, o leo mua papa. Basa hata fo papa enan basa naar lalaꞌen, o enam boe. ");
INSERT INTO txq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tehuu hatematak ia ita muste feta no nemehokok, nahuu o fadim kisek ia. Fai bakahulun sama leo maten ena, tehuu hatematak ia ana nasoda fali ena. Mopon, tehuu hatematak ia hambu falik kana ena.’ ” ");
INSERT INTO txq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Boe ma Yesus tui seluk lololek esa bali soa-neu ana nunin nara nae, “Hambu hatahori kamasuꞌik esa, soꞌuk nala hatahori esa dadi neu malangga mana koladu. Tehuu doo-doo ma hatahori kamasuꞌik naa namanene dedeꞌa anik nae, malanggan mana koladuk naa, mulai panake tao narunggin. ");
INSERT INTO txq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","De ana noke nala malangga mana koladuk naa fo nafadan nae, ‘O talo bee ia? Au amanene o panake au hata-hetong nggara. Hatematak ia o surak ue-osam mbembeda-ngganggaon fo au parisan dei. Huu basa naa, au ae fee o hahae leo.’ ");
INSERT INTO txq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Malangga mana koladuk naa namanene nala naa, boe ma ana duꞌa neu-mai nae, ‘Au soe ia ena, ma! Hatematak ia au ae tao hata? Doꞌi-dadaꞌu dae oo au ta abeꞌi boe. Dadi mana hule-kaik oo au mae boe. ");
INSERT INTO txq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mete ma au ta bisa aue-osa nai ia ena, na, au muste sangga dalak, mita fo hatahori laen nara bei nau tulun simbok au.’ ");
INSERT INTO txq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Huu naa de ana noke nala basa hatahorir fo mana rahuta mbali ndia malanggan fo hatahori kamasuꞌik naa. Ana natane hatahori kaesan nae, ‘Wee! O mahuta baꞌu hata neu au malanggang?’ ");
INSERT INTO txq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Hatahori naa naselu nae, ‘Au ahuta mina setun liter 4.000.’ Boe ma malangga mana koladuk naa nae, ‘Tebe. O susura hutam, ndia ia. Hatematak ia sii henin leo, basa naa manggatuuk fo surak susura beuk mae, o hutam kada liter 2.000.’ ");
INSERT INTO txq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Boe ma ana neu natane hatahori kaduan nae, ‘O bali, na, mahuta baꞌu hata?’ Ana naselu nae, ‘Au ahuta hade karon 1.000.’ Malangga mana koladuk naa nafada nae, ‘Sii heni o susura huta raam naa, basa, na, surak beuk mae, kada karon 800.’ ");
INSERT INTO txq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ana tao talo naa, losa hatahori kamasuꞌik naa bubuluk nala duduꞌa-aꞌafi mana kokoliꞌun. De hatahori kamasuꞌik naa muste manaku nae, malangga mana koladu manggarauk naa, memak kokoliꞌun seli. Au afada lololek ia fo ei bubuluk mae, mete ma nekesasamak kana no hatahori kamaherek, na, hatahori ta kamaherek kara memak leo-laꞌo ro kokoliꞌun lenak rai rau-inggur taladan hatematak ia. ");
INSERT INTO txq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Dadi ei duꞌa sudik kana dei. Leo mae hatahori dae-bafok soa tao manggenggeok pake sira hata-heton, tehuu malole lenak ei pake hata-heto dae-bafok fo tulu-fali hatahorir. No dalak naa, ei oo hambu nonook noꞌuk ka boe. Leo mae hata-hetor raa basa sara, tehuu neu ko Manetualain sadia mamanak fee ei nai nusa tetuk do inggu temak. ");
INSERT INTO txq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mete ma hatahori nadale ndoos no dedeꞌa kadiꞌi anak kara, neu ko nadale ndoos no dedeꞌa moꞌok kara boe. Tehuu mete ma hatahori panake no dedeꞌa kadiꞌi anak kara, neu ko ana oo panake no dedeꞌa moꞌok kara boe. ");
INSERT INTO txq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mete ma hatahori ta bisa namahere ei fo koladu hata-heto biasa no dedeꞌa kadiꞌi anak kara nai dae-bafok ia, talo bee fo Manetualain namahere ei soa-neu dedeꞌa moꞌok kara? ");
INSERT INTO txq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mete ma ei ta bisa koladu hatahori laen hata-heton, na, see nambarani fee hata-heton neu ei? ");
INSERT INTO txq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Hatahori neondak esa ta bisa nenene malanggan dua. Neu ko dalen mburuk mbali esa ma ana sue esa. Do, dalen mahanik neu esa, ma ana ta tao matak neu esa. Leo naak oo soa-neu ei boe, nahuu hatahori ta bisa sue-lai Manetualain sama-sama no tali-doik.” ");
INSERT INTO txq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Faik naa, hambu hatahori Farisir ketuk tungga ramanene Yesus kokolan bebeik kara ia. Boe ma ara rakamamaek kana, nahuu ara dale hedi doik. ");
INSERT INTO txq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tehuu Yesus naselu sara nae, “Heeh! Leo mae ei tao malao aom mara rai hatahori matan, tehuu Manetualain bubuluk ei dalem mara raa, manggarauk. Hambu matak noꞌuk ka fo hatahori dae-bafok rakadedemak kasa, naa te Manetualain taon neu dedeꞌa manggarauk, ma Ana nunute sara. ");
INSERT INTO txq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Losa Yohanis Mana Saranik mamain, ita hatahori Yahudir leo-laꞌo tungga baꞌi Musa ma Manetualain mana toꞌu dedeꞌan nara hohoro-lalanen. Tehuu hatematak ia, Manetualain Hara Lii Malolen natanggela losa bee a mesan ena. Hatahori noꞌuk ka raote tebe-tebe, mita fo ara bisa leo-laꞌo tungga Manetualain hihii-nanaun. ");
INSERT INTO txq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Leo mae lalai no dae-inak sambu do lalo, tehuu Manetualain hohoro-lalanen baꞌu anak oo ta mopo sana boe! Titik esa oo ta mopo sana boe! ");
INSERT INTO txq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Hatahori fo mana namaketu no sao inan, de ana sao seluk no inak laen, na, ana hohongge-lelena naa. Ma hatahori fo mana sao nala inak bee fo saon elan ena, na, ana oo hohongge-lelena boe.” ");
INSERT INTO txq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus tui tamba nae, “Hambu hatahori kamasuꞌik esa. Ana soa pake bua-loꞌa neulauk kara, fo tao sara numa tema bangganaꞌuk mabelir mai. Hatu-leledon nanggatuuk naꞌa-ninu malada-malada ma soa setelelek. ");
INSERT INTO txq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Numa naa oo, hambu hatahori hata taak mana ndoe-laꞌak esa boe. Naden Lasarus. Ao-inan sofek no bisu mburuk. Tungga faik, nonoon nara roon fo taon neu hatahori kamasuꞌik naa uma lelesu bafan. ");
INSERT INTO txq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ana hihiik ka hambu nanaꞌak numa hatahori kamasuꞌik naa nanaꞌa sisan nara mai, tehuu ana ta hambu hata-hata. Kada busar mai lalambe ndia bisu nanan. ");
INSERT INTO txq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Basa boe ma Lasarus maten. Boe ma Manetualain atan nara ruma nusa tetuk do inggu temak mai koꞌo roon, de reu ranggatutuuk kana neu baꞌi Abraham boboan. Ta dook ka boe ma hatahori kamasuꞌik naa oo maten boe, de hatahorir ratoin. ");
INSERT INTO txq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tehuu ana ta maso nusa tetuk do inggu temak. Ana maso neni aꞌi mbila ta kala matek neu, sama-sama no hatahori mates noꞌuk ka. Nai naa, ana hambu malendu-mataꞌak ma doidosok nakandoo. Laꞌe esa, ana botik matan boe ma mete-nita Lasarus nanggatuuk no nemehokok nai baꞌi Abraham boboan. ");
INSERT INTO txq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Boe ma ana eki nae, ‘Baꞌi Abraham, ee! Kasian neu au dei! Madenu Lasarus, boro lima kukun neu oe, fo mai deta makoe kada au maang suꞌun oo malole boe. Huu au doidoso ae mate nai aꞌi mbila ta kala matek ia!’ ");
INSERT INTO txq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Boe ma Abraham naselu nae, ‘Ana nggee! Masaneda matalolole, dei! Fai maneuk kara fo bei nai dae-bafok, o hambu mala basa neulauk lalaꞌen. Tehuu Lasarus hambu kada susa-sonak. Dadi hatematak ia Manetualain kokoe-nanasin nai ia, ma o doidoso. ");
INSERT INTO txq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Lenak bali, numa o mua ai mai, Manetualain tao nala mbia demak. De hatahori manai ia ta bisa naa neti, ma hatahori manai naa, ta bisa ia mai.’ ");
INSERT INTO txq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tehuu hatahori kamasuꞌik naa noke nae, ‘Mete ma talo naa, na, baꞌi tulun madenu Lasarus neni au amang uman neu dei. ");
INSERT INTO txq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Huu au bei aena fadi touk lima rai naa. Madenu Lasarus fee nesenedak neu sara, fo fali reni Manetualain reu leo. Mita fo ara mate, na, ta maso reni mamana doidosok ia mai.’ ");
INSERT INTO txq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tehuu Abraham naselu nae, ‘Manetualain fee sara baꞌi Musa no mana toꞌu dedeꞌak kara susuran ena. O fadim mara bisa lees laꞌi-laꞌik kana, fo ara bubuluk Manetualain hihii-nanaun.’ ");
INSERT INTO txq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tehuu hatahori kamasuꞌik naa nareresi nae, ‘Baꞌi Abraham, ee! Naa, bei ta dai. Ara ta nau tao matak mbali Manetualain Dedeꞌa-kokolan! Muste hambu hatahori mates kalua numa rates mai fo neu nafada sara, dei fo ara sale dalen do tuke tein, boe ma nau ramanene.’ ");
INSERT INTO txq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tehuu Abraham naselu nae, ‘Mete ma ara ta nau nenene baꞌi Musa no Manetualain mana toꞌu dedeꞌan nara dedeꞌa-kokolan, na, leo mae hatahori mates kalua numa rates mai fo neu kokolak no sara oo, neu ko ara ta nau nenene boe.’ ” ");
INSERT INTO txq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus nafada ana nunin nara nae, “Laꞌe noꞌuk ka hambu hatahori tuda neni salak dale neu, nahuu hatahori laen edo-poden. Tehuu hatahori mana edo-podek naa, ndia mana hambu sosoek lenak. ");
INSERT INTO txq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mete ma hatahori edo-pode losa hambu kakana ana esa ta namahere neu Au, neu ko Manetualain fee hukun berak neun. Malole lenak fuli batu moꞌok esa neu hatahori naa boliin, fo nggarin neni tasi demak dale neu. ");
INSERT INTO txq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Dadi manea aom mara matalolole fo ei oo boso makatutudak hatahori neni salak dale neu boe! Mete ma o toranoom tao salak, na, kaꞌi-ore neun. Mete ma ana sale dalen do tuke tein, de ana mai noke ambon, na, lilii heni ndia salan naa leo. ");
INSERT INTO txq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mete ma o toranoom tao salak laꞌe hitu nai faik esa dale, boe ma ana sale dalen do tuke tein, de ana mai laꞌe hitu noke ambon, na, o muste lilii heni salan laꞌe hitu boe.” ");
INSERT INTO txq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Faik esa, Yesus ana nunin nara mai rasaren, de roke rae, “Papa Meser! Ai nemeheheren ta matea. Tulun tao tamba matea ai nemeheheren dei.” ");
INSERT INTO txq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Boe ma Yesus naselu nae, “Mete ma ei mamahere neu Manetualain koasan, leo mae kada kadiꞌi anak ka oo, ei bisa parenda ai huu moꞌok boe mae, ‘Neni feꞌak leo, fo lali neni tasi dale neu!’ Neu ko ai huuk naa tungga memak ei parendam.” ");
INSERT INTO txq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Basa de Yesus kokolak bali nae, “Haꞌi netuduk. Hambu ata-dato dadaꞌu dae nai osi, do nanea bibi lombo nai mook. Ata-dato naa tao basa ue-osan boe ma fali uma neu. Neu ko ta bisa dadi malanggan kokolak noon nae, ‘Mai fo ita dua ngga tanggatuuk taꞌa sama-sama leo!’ ");
INSERT INTO txq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Taa! Tungga netemek naa ndia malanggan parendan nae, ‘Muu sadia mei fee au dei. Basa dei fo o muu muꞌa-minu nai seku dea naa.’ ");
INSERT INTO txq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mete ma ata-dato naa tao tungga ndia malanggan hihiin ena, ei duꞌa mae, ana noke makasi neun, do? Taa! ");
INSERT INTO txq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ei oo leo naak boe. Mete ma ei maue-osa basa hata fo Manetualain parendak ena, na, ei kokolak mae, ‘Ai kada hatahori neondak, fo ta nandaa simbo hata-hata. Ai ta sangga kokoak. Ai kada makalalaꞌok ues a mesan.’ ” ");
INSERT INTO txq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Neu Yesus asa laꞌok reni Yerusalem reu, ara losa profensi Galilea ma profensi Samaria dae toon. ");
INSERT INTO txq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Neu ara rae maso reni nggorok esa numa naa reu, hambu hatahori hedi kusta salahunu mai, fo rae ratonggo ro Yesus. Ara rambariik rai dook ka. ");
INSERT INTO txq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Boe ma ara eki randaa rae, “Yesus! Lamatuak! Kasian neu ai dei!” ");
INSERT INTO txq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Neu Yesus mete-nita sara, boe ma Ana nadenu nae, “Ei miu matudu ao-inam mara neu malangga anggamar dei, mita fo ara parisa rae, ei hedi kustam mopon ena, do beik.” Ara ramanene rala naa, boe ma reu. Tehuu neu ara bei laꞌok numa dalak, medak neu ma basa sara hai memak. ");
INSERT INTO txq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ara laꞌok rakandoo no nemehokok. Tehuu hambu esa fali neni Yesus neu. Ana eki nae, “Koa-kio Manetualain! Au hai ena!” ");
INSERT INTO txq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Boe ma ana sendek luu-langgan, de noke makasi noꞌun seli neu Yesus. (Naa te ndia ia, ta hatahori Yahudi. Ndia hatahori Samaria fo mana radedeꞌa rakandoo ro hatahori Yahudir.) ");
INSERT INTO txq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Boe ma Yesus natane hatahorir fo mana tunggan nae, “Talo bee ia? Bebeik kara Au tao ahai hatahori salahunu, hetu? Kasiok kara rai bee? ");
INSERT INTO txq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tao hata de kada hatahori feꞌek ia fali mai noke makasi neu Manetualain, ma soꞌuk koa-kiok neun?” ");
INSERT INTO txq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Boe ma Ana nafada hatahori naa nae, “O hai ena, nahuu o mamahere tebe-tebe neu Au. Dadi mambadeik fo fali muu ngga no sodak leo!” ");
INSERT INTO txq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Faik esa, hambu hatahori Farisir ketuk mai ratane Yesus rae, “Papa Meser! Mafada sudik dei! Faik bee Manetualain mulai nakalalaꞌok Ndia parenda-koasan?” Boe ma Yesus naselu nae, “Talo ia! Boso duꞌa mae Manetualain nakalalaꞌok parenda-koasan nai dae-bafok ia, no tanda mata-matak kara fo hatahorir bisa parisa ro mata deꞌen nara. Hatahorir ta hambu bukti rae, ‘Mete sudik nai ia! Te Manetualain nakalalaꞌok parenda-koasan nai ia!’, do ‘Nai naa!’ Taa! Huu Ana nakalalaꞌok parenda-koasan nai ei taladam ma nai hatahorir dalen.” ");
INSERT INTO txq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Basa de Yesus nafada ana nunin nara nae, “Ta dook ka te Au Hatahori Dae-bafo Isi-isik ia, ta sama-sama ua ei ena. Neu ko nai fai susa-sonak kara, ei dalem mara hii mete-mita Au fafaling. Tehuu Au bei ta fali. ");
INSERT INTO txq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mete ma hatahorir mai rafada rae, ‘Karistus nai ia!’ do, ‘Karistus nai naa!’ na, ei boso mamue-osak sangga miu-mai, huu sira kokolan nara raa, pepeko-lelekok. ");
INSERT INTO txq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Huu mete ma tebe-tebe Hatahori Dae-bafo Isi-isik fali mai, neu ko tandan nara manggaledo ndoos, sama leo ndelas nanggahadok tao nala lalai dadi manggaledok numa suꞌun seri mai losa suꞌun seri. ");
INSERT INTO txq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tehuu Ana oo muste lemba-nasaa doidoso mata-matak kara dei boe. Ma hatahori dae-bafok tanak ia, ta nau nenenen ma rae timba henin. ");
INSERT INTO txq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Neu Ana nae fali mai, neu ko hatahori leo-laꞌo no kada manggarauk leo biasa, sama leo numa Noh tembo-lelen. ");
INSERT INTO txq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Faik naa, ara raꞌa-rinu, tao feta kabin, losa faik fo Noh maso neni ofak dale neu. Tehuu hatahorir raa oo ta nau nenene boe. Medak neu ma faa moꞌok mai, de nakalulutu basa sara. ");
INSERT INTO txq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Naa oo, sama leo hatahorir fo mana leo-laꞌo no manggarauk numa Lot tembo-lelen boe. Faik naa, ara raꞌa-rinu, raseꞌo banda hasa, tao osi-lutur, rambaririik uma, ma leo-laꞌo biasa no kada manggarauk. ");
INSERT INTO txq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tehuu hatahorir raa oo ta nau nenene boe. Basa de huhuan naa, neu Lot nalai laꞌo ela kota Sodom, medak neu ma uda aꞌik no balerang tuda numa lalai mai, de naꞌa heni basa sara. ");
INSERT INTO txq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Dadi ei besa-besa, ee! Boso losak, mete ma Hatahori Dae-bafo Isi-isik nae fali mai, hatahorir leo-laꞌo no kada biasa-biasa a mesan. Tehuu medak neu ma Ana toda mai. ");
INSERT INTO txq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Faik naa, hatahori see fo nai uma pandopon, na, boso bei maso uma dale neu nafafaꞌu bali. Hatahori mana maue-osa nai osi dale, boso fali uma neu haꞌi bua-loꞌa bali. ");
INSERT INTO txq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Masaneda mandadik hata neu Lot saon lele uluk. Ana mate, nahuu nasaneda hata-heto marai uma. ");
INSERT INTO txq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Hatahori fo ta mana nau tungga Au, nahuu ana sue ao-ina heli-helin, neu ko masodan sosoan taa. Tehuu hatahori fo mana nau tungga Au, losa ana loo lima masodan, nahuu sue-lai Au, neu ko hambu masoi-masodak, ma leo-laꞌo nakandoo no Manetualain. ");
INSERT INTO txq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Au afada memak! Neu Hatahori Dae-bafo Isi-isik fali mai, mete ma hambu hatahori dua sunggu nai mamana susungguk esa, medak neu ma Lamatuak soꞌuk nala esa, ma ela esa. ");
INSERT INTO txq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mete ma hambu inak dua mbau hade sama-sama, neu ko Lamatuak soꞌuk nala esa, ma laꞌo ela laen. ");
INSERT INTO txq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mete ma hambu hatahori dua raue-osa sama-sama numa osi dale, neu ko Lamatuak soꞌuk nala esa, ma laꞌo ela laen.” ");
INSERT INTO txq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesus ana nunin nara ramanene rala naa, boe ma ratanen rae, “Papa Meser! Mete te basa naar dadi nai bee?” Boe ma Yesus tee dedeꞌak nae, “Talo ia. Mete ma ei mete-mita mbui manaꞌa nenetuk lambu rakabua rai bee, na, ei bubuluk ena, naa dadi tanda rae, neu ko ara raꞌa nenetuk nai mamanak naa.” No sosoa-ndandaan nefunik nae, mete ma Karistus fali mai, neu ko tandan manggaledo ndoos, soa-neu hatahori mana bisa lees. ");
INSERT INTO txq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Laꞌe esa, Yesus nanori ana nunin nara pake lololek fo ara hule-haradoi ta ramaketu, ma ta monda-maꞌa. Ara muste ramahere rakandoo neu Manetualain. ");
INSERT INTO txq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tutuin talo ia: “Numa kota esa, hambu mana maketu-maladi dedeꞌak esa fo ta mana tao matak neu Manetualain. Ana ta hosek hatahori esa boe na. ");
INSERT INTO txq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Numa naa oo, hambu ina falu esa boe, ana mai taa-taa neni mana maketu-maladi dedeꞌak naa neu fo noke nae, ‘Papa mana maketu-maladi dedeꞌak! Maketu au dedeꞌang no ndoos dei, ee!’ ");
INSERT INTO txq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sososan, mana maketu-maladi dedeꞌak naa ta hosek neu ina falu naa. Tehuu doo-doo boe ma ana mbera nenene neun. De ana duduꞌa nae, ‘Memak au ia ta tao matak neu Manetualain, hata-bali neu hatahori dae-bafok. ");
INSERT INTO txq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Tehuu ina falu ia tao nala au langgan nabako. Huu naa de malole lenak au aketu dedeꞌan tungga dalan dei. Mete ma taa, na, neu ko ana kada mai taa-taa tao nakamamangguk au.’ ");
INSERT INTO txq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ei duꞌa sudik mana maketu-maladi dedeꞌak manggarauk naa kokolan. ");
INSERT INTO txq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tehuu doo-doo boe ma ana tulu-fali ina falu naa ena, na, neu ko Manetualain oo nau tulu-fali Ndia hatahorin mana hule-haradoi hatu-leledon boe, fo roke tutulu-fafalik neun. Tehuu Manetualain ta mana keko-lali fai. ");
INSERT INTO txq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ana koladu sira dedeꞌan no lai-laik. Au ae atane talo ia: neu Au Hatahori Dae-bafo Isi-isik ia, fali mai ena, na, Au bei atonggo ua hatahori kamaherek kara rai dae-inak ia, do taa?” ");
INSERT INTO txq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus tui tamba lololek esa laꞌe-neu hatahori mana makadedema aok, ma mana hii nakadadaek hatahori laen. Ana tui nae, ");
INSERT INTO txq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Hambu touk dua reu hule-haradoi numa Uma Huhule-haradoi Ina-huuk. Hatahori esa numa partei anggama Farisi mai, ma esa bali, mana susu bea. Hatahori Yahudir tao hatahori Farisir raa, nok bali hatahori malalaok. Tehuu ara tao hatahori mana susu bear raa, nok bali hatahori ta neulauk. ");
INSERT INTO txq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Losa uma huhule-haradoik, boe ma hatahori Farisi naa nambariik mesa kana de hule-haradoi nae, ‘Makasi Manetualain, huu au ia hatahori neulauk. Au ta manggarauk leo hatahori laen nara. Au ta mana amanaꞌo. Au ta mana bare-naꞌo. Au ta mana laok sala ua hatahori saon. Makasi Manetualain, huu au ta manggarauk sama leo mana susu bea ia. ");
INSERT INTO txq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Au manggate puasa, nai menggu esa laꞌe dua. Ma au soa fee babaꞌek esa numa salahunu mai numa basa hata fo au hambuk.’ Hatahori Farisi naa, hule-haradoi talo naa. ");
INSERT INTO txq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tehuu mana susu bea naa, nambariik neu dook ka nai seku dea, Ana ta nambarani botik matan mbali lalai neu. Ana hule-haradoi no kada nateꞌe langgan ma dalen makalulutuk nae, ‘Manetualain, ee! Sue-lai neu au, hatahori makilu-masalak ia! Fee ambon neu au!’ ");
INSERT INTO txq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Neu hatahori kaduak kara raa fali reni uman nara reu, nai rarain see ndia malole no Manetualain? Hatahori Farisi mana koa aok naa, do, mana susu bea naa? Neu ko Ana simbok no malole hatahori mana susu bea dale nekeloloe aok naa. Tehuu Ana ta hosek hatahori Farisi naa. Huu Manetualain nakatutudak hatahori mana koa aok, tehuu Ana soꞌu botik hatahori mana nakaloloe aok.” ");
INSERT INTO txq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Laꞌe esa, hatahori koꞌo roo sira anan nara reni Yesus reu, mita fo Ana ndae liman ma kokolak fee babaꞌe-babatik neu sara. Yesus ana nunin nara mete-rita naa, boe ma ara rahara berak reu hatahorir raa. ");
INSERT INTO txq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Tehuu Yesus simbok nala kakana ana mana maik kara raa. Boe ma Ana nahara berak ana nunin nara nae, “Ela kakana anar raa reni Au mai. Boso mamanggenggee sara. Masaneda matalolole! Huu hatahori fo mana nau dadi neu Manetualain hatahorin, ana muste tai-namahena neu Manetualain, sama leo kakana anar tai-ramahena reu sira inan ma aman.” ");
INSERT INTO txq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Laꞌe esa, hambu hatahori Yahudi hatahori moꞌo-inahuun esa mai natane Yesus nae, “Papa Meser mana hambu hada-horomatak! Au muste tao talo bee, mita fo au bubuluk no tetuk ae, au bisa maso nusa tetuk do inggu temak fo asoda akandoo ua Manetualain?” ");
INSERT INTO txq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Boe ma Yesus naselu nae, “Tao hata de o moke Au mae, ‘mana hambu hada-horomatak?’ Kada esak ka fo mana hambu hada-horomatak, ndia Manetualain mesa kana. ");
INSERT INTO txq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","O bubuluk ena, hetu, Manetualain hohoro-lalanen numa lele uluk mai nae: Boso hohongge-lelena; Boso makanisa hatahori; Boso mamanaꞌo; Boso sakasii pepeko-leleko; ma fee hada-horomatak neu o inam ma o amam.” ");
INSERT INTO txq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hatahori naa naselu nae, “Tebe, Papa! Au tungga hohoro-lalanek kara raa mulai numa au bei kadiꞌik ka mai.” ");
INSERT INTO txq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesus namanene nala naa, boe ma Ana nae, “Malole! Tehuu o bei kuran matak esa. Huu naa de hatematak ia fali muu ngga fo seꞌo heni basa o hata-hetom lalaꞌen. Basa naa, muu babaꞌe doin nara fee hatahori mana toꞌa taak kara. Basa dei fo fali mai fo tungga Au. Huu neu ko Manetualain bala fee o hata-heto nai nusa tetuk do inggu temak.” ");
INSERT INTO txq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hatahori naa namanene nala naa, boe ma dalen sona, nahuu suꞌin noꞌun seli. ");
INSERT INTO txq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus mete-nita ana laꞌok no dale makalulutun, boe ma Ana nafada ana nunin nara nae, “Hatahori kamasuꞌik memak susa laꞌe esak kana maso neni nusa tetuk do inggu temak neu. ");
INSERT INTO txq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ita takasasamak kana no matak laen. Memak banda onta moꞌok ta bisa maso lalaen neu nesik ndandauk bolon. Leo naak oo soa-neu hatahori fo mana namahena neu kada ndia hata-heton, tehuu ta namahena neu Manetualain, ta bisa dadi ana maso nusa tetuk do inggu temak boe.” ");
INSERT INTO txq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hatahorir mana ramanene Yesus kokolan talo naa, ratanen rae, “Mete ma memak susa leo naak soa-neu hatahori kamasuꞌik, na, hatahori matak bee ndia bisa hambu masoi-masodak?” ");
INSERT INTO txq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus naselu nae, “Memak soa-neu hatahori dae-bafok, matak noꞌuk ka ta bisa dadi. Tehuu soa-neu Manetualain, basa-basan bisa dadi.” ");
INSERT INTO txq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Boe ma Petrus tuti kokolan nae, “Papa! Ai laꞌo ela basa ai hata-heton lalaꞌen ena, fo tungga Papa. Tehuu neu ko ai hambu hata?” ");
INSERT INTO txq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus naselu nae, “Peꞌu! Nenene matalolole, ee! Hatahori fo mana laꞌo ela uman, sao inan, kaꞌa-fadin, ina-aman, do anan nara, nahuu ana nakalalaꞌok ues numa Manetualain mai, ");
INSERT INTO txq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","neu ko ana simbo falik lenak noꞌuk ka nai dae-bafok ia. Ma neu dae-bafok fai mateꞌen, ana oo nasoda nakandoo no Manetualain boe.” ");
INSERT INTO txq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus nuni noo ana nuni kasalahunu duan nara fo neu kokolak no mesa kasa nae, “Ei basa ngga bubuluk ena mae, hatematak ia ita laꞌo teni kota Yerusalem teu. Losa naa, basa hata fo Manetualain mana toꞌu dedeꞌan nara surak kana ndia lele uluk laꞌe-neu Hatahori Dae-bafo Isi-isik naa ena, neu ko dadi no tetuk sama leo hata fo ara surak kasa. ");
INSERT INTO txq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Neu ko ara loo lima Au uni hatahori feꞌek kara fo ta mana ramahere reu Manetualain uu. Boe ma ara rakamamaek Au, rakadadaek mata-matak kara neu Au, pura ambe neu Au, ");
INSERT INTO txq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","poko-femba Au, basa te tao risa Au. Tehuu neu bei-nesan, Au asoda fali numa mamates mai.” ");
INSERT INTO txq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ara ramanene rala Yesus kokolak talo naa, boe ma ana nunin nara panggananaa, nahuu ara bei ta ralela dedeꞌa-kokolak kara raa sosoa-ndandaan. ");
INSERT INTO txq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Neu Yesus asa rae maso kota Yeriko, hambu hatahori pokek esa nanggatuuk hule-hule numa dalak tatain. ");
INSERT INTO txq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Neu ana namanene hatahori noꞌuk ka laꞌok resik naa, boe ma natane nae, “Woi! Hata ia?” ");
INSERT INTO txq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Boe ma hatahorir rafadan rae, “Yesus, Hatahori Nasaret naa, laꞌok nesik ia.” ");
INSERT INTO txq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hatahori pokek naa namanene nala naa, boe ma ana bolu nahere nae, “Yesus! Mane Dauk tititi-nonosin, ee! Kasian neu au dei!” ");
INSERT INTO txq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hatahori mana laꞌok nesi Yesus matan, kaꞌi-oren fo nenee. Tehuu ana boe kii-bolu nahere bali nae, “Mane Dauk tititi-nonosin, ee! Kasian neu au dei!” ");
INSERT INTO txq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Neu Yesus namanene talo naa, boe ma Ana nambarii taak. De Ana nadenu hatahorir reu leꞌa roo hatahori pokek naa mai. Losa Yesus matan, boe ma Ana natanen nae, ");
INSERT INTO txq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“O nau Au tao hata fee o?” Ana naselu nae, “Papa! Au oke-hule fo au bisa mete-ita.” ");
INSERT INTO txq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus naselu mbalin nae, “Malole. Huu o mamahere mae, Au bisa tao ahai o, de hatematak ia o bisa mete-mita.” ");
INSERT INTO txq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Medak neu ma, hatahori naa mata poken hai tutik kana leo. Boe ma ana tungga Yesus ma koa-kio Manetualain. Basa hatahori mana mete-rita talo naa oo soꞌuk koa-kiok neu Manetualain boe. ");
INSERT INTO txq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Boe ma Yesus asa maso resi kota Yeriko, fo rae laꞌok rakandoo. ");
INSERT INTO txq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Numa naa, hambu malangga mana susu bea esa fee man-parenda Roma. Naden Sakeos, ma ndia hatahori kamasuꞌik. ");
INSERT INTO txq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Neu ana namanene Yesus nae nesik naa, boe ma ana hihiik ka mete-nita Yesus. Tehuu ana ta bisa mete-nita no malole, nahuu hatahori noꞌun seli rakarumbu rala Yesus, ma ndia ao-inan boboku anak ka. ");
INSERT INTO txq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Huu naa de ana nalaik nakahuluk, fo hene neni ai huuk esa numa dalak tatain fo Yesus nae nesik naa. ");
INSERT INTO txq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Losa ai huuk naa taen, boe ma Yesus mete lain neu. De nanggou Sakeos nae, “Sakeos! Mai, konda leo! Lai-lai, bekin ia Au nau leo taak nai o umam.” ");
INSERT INTO txq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakeos heran bali-bali. Boe ma ana konda lai-laik, de no Yesus neni uman neu. Dalen namahoko nalan seli. ");
INSERT INTO txq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tehuu hatahori noꞌuk kara unggu-remu rae, “Ciih! Sakeos ia, hatahori ta neulauk! Tao hata de Yesus maso neu leo taak nai uman?! Basa hatahorir bubuluk ena!” ");
INSERT INTO txq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Losa uma, boe ma Sakeos nambariik neu Yesus matan, de kokolak nae, “Papa Meser! Numa faik ia neu au baꞌe dua au hata-hetong lalaꞌen, fo fee babaꞌek esa neu hatahori mana toꞌa taak kara. Mete ma au susu ita bea lena-lenak, au bae falik kasa lipa laꞌe haa.” ");
INSERT INTO txq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus naselu nae, “Malole. Faik ia Manetualain tao nasoi-nasoda o mua basa o nufanelum mara, nahuu o mamahere neu Manetualain sama leo baꞌi Abraham. ");
INSERT INTO txq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Manetualain nadenu Au dadi uu Hatahori Dae-bafo Isi-isik nai dae-bafok ia. Au mai fo sangga hatahori mana laꞌok sala numa Manetualain eno-dalan mai, fo tao asoi-asoda sara.” ");
INSERT INTO txq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Faik naa, hatahori noꞌuk ka tungga nenene Yesus. Ara deka-deka ro kota Yerusalem ena. Ara oo duꞌa rae, Ana nau nakalalaꞌok Manetualain parenda-koasan nai naa, nok bali manek esa boe. Boe ma Yesus tui sara lololek esa bali ");
INSERT INTO txq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","nae, “Hambu hatahori moꞌo-inahuuk esa. Ana nae neni nusa feꞌek neu, fo ara soꞌuk kana dadi manek. Basa naa, dei fo ana nau fali neu dadi manek nai ndia nusa-namo heli-helin. ");
INSERT INTO txq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Neu ana naole fo nae laꞌo ena, nanggou ndia hatahori mana maue-osan salahunu, de ana fee sara hatahori esa na, doi lilo mbilas esa. Ana parenda sara nae, ‘Ei pake doik ia dadi neu poko. Mete ma au fali, neu ko ei tui ei hambu bunak hida ena.’ Boe ma ana laꞌo. ");
INSERT INTO txq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tehuu ndia rau-inggun nara mburuk roon. De ara radenu nedenuk neu nafada nai naa nae, ‘Ai ta nau hatahori ia toꞌu parenda soa-neu ai.’ ");
INSERT INTO txq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Leo mae talo naa oo, tehuu ara soꞌuk kana nai naa boe. Basa boe ma ana fali. Losa uman, boe ma ana nanggou nala hatahori mana maue-osa kasalahunuk kara raa, de natane sara nae, ‘Ei hambu bunak hida numa doi lilo mbilas fo au fee ei naa ena?’ ");
INSERT INTO txq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hatahori mana maue-osa kaesan nafada nae, ‘Papa manek! Au hambu bunak lipa laꞌe salahunu numa poko fo au simbok naa mai!’ ");
INSERT INTO txq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Boe ma manek nafadan nae, ‘Malole! O ia, hatahori mana maue-osa neulauk. Huu au bisa amahere o nai dedeꞌa kadiꞌi anak, de hatematak ia au soꞌuk o fo parenda kota salahunu.’ ");
INSERT INTO txq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Boe ma hatahori mana maue-osa kaduan nafada nae, ‘Papa manek! Au hambu bunak doi lilo mbilas lima numa poko fo au simbok mai.’ ");
INSERT INTO txq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Boe ma manek naa koan nae, ‘Malole! Mete ma talo naa, au soꞌuk o fo parenda kota lima.’ ");
INSERT INTO txq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tehuu hatahori mana maue-osa katelun neni falik ndia doi lilo mbilan. De nafada nae, ‘Papa manek doin ndia! Au mbotin, basa de afunin no malole fo boso mopon. ");
INSERT INTO txq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Au tao talo naa, nahuu au amataꞌu. Au bubuluk papa ia, hatahori kalakak. Huu papa soa haꞌi nala hata fo ta papa enan, ma ketu-koru hata fo papa ta sele-tanden.’ ");
INSERT INTO txq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Manek namanene nala naa, boe ma ana mbokan nae, ‘O ia, hatahori sesesu taak! O kokolam fee hukun neu o ao heli-helim ena. O duꞌa mae au ia, hatahori kalakak fo haꞌi ala hata fo ta au enang, ma ketu-koru hata fo au ta sele-tanden. ");
INSERT INTO txq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mete ma talo naa, na, tao hata de o ta muu mbeda doik naa nai bank? Mita fo neu au fali, na, bisa hambu bunan. Leo mae baꞌu anak ka oo malole boe.’ ");
INSERT INTO txq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Boe ma manek naa nadenu hatahori laen marai naar nae, ‘Haꞌi mala doin naa, fo loo liman neu hatahori mana maue-osa bebeik kara fo mana hambu bunak salahunu.’ ");
INSERT INTO txq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tehuu ara ta rakaheik rae, ‘Papa! Hatahori naa, hambu dai ena. Tao hata de sangga haꞌi numa hatahori fo enan baꞌuk ka, fo tamban neu ndia bali?’ ");
INSERT INTO txq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Boe ma manek naa naselu nae, ‘Duꞌa matalolole! Hatahori fo mana nalela koladu hata fo hatahori fee nemeheherek neun ena, neu ko ana hambu tamba bali. Tehuu hatahori fo mana mbera koladu, neu ko ara haꞌi rabasa hata fo ndia enan. ");
INSERT INTO txq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hatematak ia ei miu humu mala au musung nggara fo ta mana hii au dadi manek nai ia. Mia sara ia mai, boe ma hala misa sara rai au matang. Miu leo!’ ” ");
INSERT INTO txq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus tui basa, boe ma ara laꞌok rakandoo reni Yerusalem reu. Yesus laꞌok nesik mata. ");
INSERT INTO txq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ara deka-deka ro nggorok dua, ndia Betfage ma Betania marai letek Setun tatain, boe ma Ana nadenu ana nunin dua laꞌok rakahuluk. ");
INSERT INTO txq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ana nadenu sara nae, “Ei dua ngga meni nggorok manai mata naa miu. Neu ko ei mete-mita banda keledei tenak esa neni paꞌak nai naa. Hatahorir bei ta saꞌe ritan. Ei sefi keledei naa talin fo leꞌa menin ia mai. ");
INSERT INTO txq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tehuu mete m