﻿USE sofia;
DROP TABLE IF EXISTS sofia.twiasante_vpl;
CREATE TABLE twiasante_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES twiasante_vpl WRITE;
INSERT INTO twiasante_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ahyɛaseɛ no Onyankopɔn bɔɔ ɔsoro ne asase. ");
INSERT INTO twiasante_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Na asase yɛ sakasaka ne hunu. Na esum kata nsubunu no ani. Na Onyankopɔn honhom butu nsuo no ani. ");
INSERT INTO twiasante_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Onyankopɔn hyɛɛ sɛ, ɛnyɛ hann! Na ɛyɛɛ hann. ");
INSERT INTO twiasante_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Onyankopɔn hunuu sɛ hann no yɛ enti, ɔtee hann no firii esum no ho. ");
INSERT INTO twiasante_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Onyankopɔn frɛɛ hann no sɛ adekyeeɛ, na esum no nso sɛ adesaeɛ. Adeɛ saeɛ na adeɛ kyeeɛ, ɛda a ɛdi ɛkan no no. ");
INSERT INTO twiasante_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Onyankopɔn kaa sɛ, “Nkyɛmu mmra nsuo no ntam, na ɛnkyekyɛ nsuo no mu.” ");
INSERT INTO twiasante_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Enti, Onyankopɔn yɛɛ nkyɛmu no de kyekyɛɛ nsuo a ɛwɔ nkyɛmu no ase firii nsuo a ɛwɔ nkyɛmu no atifi no mu. Na ɛyɛɛ saa. ");
INSERT INTO twiasante_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Onyankopɔn too atifi nkyɛmu no edin ewiem. Na esum duruiɛ ɛnna adeɛ kyeeɛ; yei ne ɛda a ɛtɔ so mmienu. ");
INSERT INTO twiasante_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Na Onyankopɔn kaa sɛ, “Nsuo a ɛwɔ nkyɛmu no ase no ano mmoa wɔ faako, na asase kesee nna ne ho adi.” Na ɛyɛɛ saa. ");
INSERT INTO twiasante_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Onyankopɔn too beaeɛ kesee no edin asase. Ɛnna nsuo a ɛboaa ne ho ano no nso, ɔtoo no edin ɛpo. Onyankopɔn hunuu sɛ ɛyɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Afei, Onyankopɔn kaa sɛ, “Afifideɛ mfifiri asase so; afifideɛ a ɛso aba, nnuaba ahodoɔ a ɛso aba ne deɛ, nʼaba hyehyɛ mu nyinaa mfifiri asase so.” Na ɛyɛɛ saa. ");
INSERT INTO twiasante_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Afifideɛ a ɛso aba ne nnua fifirii asase so na nʼaba no nyini yɛɛ nnua ne afifideɛ sɛ ne sɛso. Onyankopɔn hunuu sɛ, ɛyɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Na adeɛ saeɛ ɛnna adeɛ kyeeɛ. Yei ne ɛda a ɛtɔ so mmiɛnsa. ");
INSERT INTO twiasante_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Na Onyankopɔn kaa sɛ, “Hann mmra nkyɛmu a ɛwɔ ewiem no mu mmɛpae adekyeeɛ ne adesaeɛ mu. Na ɛmmɛyɛ nnyinasoɔ mma ɛberɛ nkyekyɛmu, nna ne mfeɛ ");
INSERT INTO twiasante_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","na ɛmma hann mmra nkyɛmu a ɛwɔ ewiem no mu, na ahyerɛn wɔ asase so.” Na ɛyɛɛ saa. ");
INSERT INTO twiasante_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Onyankopɔn yɛɛ nkanea akɛseɛ mmienu a ɛyɛ owia ne ɔbosome sɛ, owia no nni adekyeeɛ so na ɔbosome no nni anadwo so. Ɔbɔɔ nsoromma nso. ");
INSERT INTO twiasante_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Onyankopɔn de nkanea akɛseɛ mmienu yi sii nkyɛmu ewiem no mu sɛ, ɛnhyerɛn wɔ asase so, ");
INSERT INTO twiasante_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","na wɔnni adekyeeɛ ne adesaeɛ no so, na ɛnte hann no mfiri esum no ho. Na Onyankopɔn hunuu sɛ, ɛyɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Na adeɛ saeɛ, ɛnna adeɛ kyeeɛ. Ɛda a ɛtɔ so ɛnan ne no. ");
INSERT INTO twiasante_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Onyankopɔn kaa sɛ, “Abɔdeɛ a nkwa wɔ mu nhyɛ nsuo no ma, na nnomaa ntu mfa asase ne nkyɛmu a ɛwɔ ewiem no so.” ");
INSERT INTO twiasante_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Enti, Onyankopɔn bɔɔ ɛpo mu mmoa akɛseɛ ne mmoa ahodoɔ nyinaa a wɔwɔ nkwa na wɔkeka wɔn ho ne nnomaa ahodoɔ nyinaa. Na Onyankopɔn hunuu sɛ ɛyɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Onyankopɔn hyiraa abɔdeɛ no nyinaa so, ɛnna ɔkaa sɛ, “Monwo na monyɛ bebree na monhyɛ ɛpo no ma, na nnomaa ase ntrɛ wɔ asase so.” ");
INSERT INTO twiasante_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Na adeɛ saeɛ ɛnna adeɛ kyeeɛ. Ɛda a, ɛtɔ so enum ne no. ");
INSERT INTO twiasante_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Onyankopɔn kaa sɛ, “Abɔdeɛ a nkwa wɔ mu ahodoɔ nyinaa ne wɔn sɛso, anantwie ne mmoa a wɔwea wɔn afuru so ne mmoa ahodoɔ a wɔyɛ keka a wɔwɔ asase so nyinaa mmra asase so.” Na ɛyɛɛ saa. ");
INSERT INTO twiasante_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Onyankopɔn bɔɔ mmoa ahodoɔ, anantwie ahodoɔ ne wɔn sɛso ne mmoa a, wɔwea wɔn afuru so ne wɔn sɛso. Na Onyankopɔn hunuu sɛ, ɛyɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Onyankopɔn kaa sɛ, “Momma yɛmmɔ onipa sɛ yɛn sɛso, na ɔnni ɛpo mu mpataa, ewiem nnomaa, anantwie ne mmoa a wɔyɛ keka ne biribiara a ɛwea nʼafuru so wɔ asase so.” ");
INSERT INTO twiasante_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Enti, Onyankopɔn bɔɔ onipa sɛ ne sɛso; Onyankopɔn sɛso so na ɔbɔɔ wɔn; ɔbaa ne ɔbarima na ɔbɔɔ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Onyankopɔn hyiraa wɔn, ka kyerɛɛ wɔn sɛ, “Monwo na monyɛ asase so ma, na monni biribiara so. Monni ɛpo mu mpataa ne ewiem nnomaa ne abɔdeɛ biara a, nkwa wɔ mu a, ɛwɔ asase so no nyinaa so.” ");
INSERT INTO twiasante_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Afei, Onyankopɔn kaa sɛ, “Mede asase so afifideɛ a ɛso aba nyinaa, afifideɛ biara a aba hyɛ ne nnuaba mu wɔ asase yi so nyinaa hyɛ wo nsa. Ɛbɛyɛ wʼaduane. ");
INSERT INTO twiasante_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Mede nhahammono nyinaa ama aboa biara a ɔwɔ asase so, anomaa biara a ɔwɔ ewiem, biribiara a ɛwea nʼafuru so, biribiara a nkwa wɔ mu wɔ asase so sɛ wɔn aduane.” Na ɛyɛɛ saa. ");
INSERT INTO twiasante_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Onyankopɔn hwɛɛ deɛ wayɛ nyinaa hunuu sɛ ɛyɛ papa. Na adeɛ saeɛ na adeɛ kyeeɛ. Yei ne ɛda a ɛtɔ so nsia. ");
INSERT INTO twiasante_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Yei ne ɛkwan a Onyankopɔn faa so bɔɔ ɔsoro ne asase ne deɛ ɛwɔ mu nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ɛduruu ɛda a ɛtɔ so nson no, na Onyankopɔn awie nnwuma a ɔhyɛɛ aseɛ yɛeɛ no nyinaa. Enti, ɛda a ɛtɔ so nson no, ɔgyee nʼahome. ");
INSERT INTO twiasante_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Onyankopɔn hyiraa ɛda a ɛtɔ so nson no, na ɔtee ho. Ɛfiri sɛ, saa ɛda no na Onyankopɔn gyee nʼahome firii adebɔ nnwuma no nyinaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yei ne ɔsoro ne asase bɔ ho asɛm. Ɛberɛ a Awurade Onyankopɔn bɔɔ ɔsoro ne asase no. ");
INSERT INTO twiasante_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Na afifideɛ biara nni asase so, na wiram nnua biara nso nni hɔ. Ɛfiri sɛ, na Awurade Onyankopɔn mmaa nsuo ntɔɔ wɔ asase so, na onipa nso nni asase so a ɔbɛyɛ so adwuma. ");
INSERT INTO twiasante_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Nanso, nsutire puepue fifirii asase mu bɛpetee asase ani nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Awurade Onyankopɔn de asase no so dɔteɛ nwonoo onipa, na ɔhomee nkwa home guu ne hwene mu, maa onipa no bɛyɛɛ ɔteasefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Afei, Awurade Onyankopɔn yɛɛ turo wɔ Eden apueeɛ fam, na ɛhɔ na ɔde onipa a ɔnwonoo no no tenaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Awurade Onyankopɔn maa nnua ahodoɔ nyinaa fifirii asase no so; nnua a ɛyɛ fɛ na wɔdie. Turo no mfimfini no na nkwa dua, ɛnna papa ne bɔnehunu dua sisie. ");
INSERT INTO twiasante_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Na nsuo tene firi Eden bɛgugu turo no mu afifideɛ no so; ɛfiri hɔ a, na saa nsuo no mu apaapae ayɛ nsubɔntene ɛnan. ");
INSERT INTO twiasante_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Wɔtoo nsuo a apaapae no mu deɛ ɛdi ɛkan no edin Pison. Na ɛkontonkonton fa Hawila asase a sikakɔkɔɔ wɔ so no so nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Na saa asase no so sikakɔkɔɔ yɛ. Na ɛhyɛ a ɛyɛ hwam ne apopobibirieboɔ nso wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Asubɔnten a ɛtɔ so mmienu no din de Gihon. Na ɛno ara na abobare afa Kus asase ho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Asuo a ɛtɔ so mmiɛnsa no, na wɔfrɛ no Tigris a ɛtene kɔ asase kɛseɛ Asiria apueeɛ fam. Asuo a ɛtɔ so ɛnan no nso, na wɔfrɛ no Eufrate. ");
INSERT INTO twiasante_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Awurade Onyankopɔn faa onipa no de no kɔtenaa Eden turo mu hɔ sɛ ɔnyɛ mu adwuma, na ɔnhwɛ so. ");
INSERT INTO twiasante_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Na Awurade Onyankopɔn bɔɔ onipa no kɔkɔ sɛ, “Wowɔ ho ɛkwan sɛ, wodi dua biara so aba wɔ turo yi mu ha; ");
INSERT INTO twiasante_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","nanso wonni ho ɛkwan sɛ wodi papa ne bɔnehunu dua no so aba. Ɛda a wobɛdie no, deɛ ɛbɛyɛ biara, wobɛwu.” ");
INSERT INTO twiasante_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Afei, Awurade Onyankopɔn kaa sɛ, “Ɛnyɛ sɛ onipa nko ara tena; mɛbɔ ɔboafoɔ a ɔfata no ama no.” ");
INSERT INTO twiasante_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Saa ɛberɛ no na, Awurade Onyankopɔn de mfuturo abɔ wiram mmoa ne ewiem nnomaa nyinaa. Enti, ɔde wɔn brɛɛ onipa sɛ ɔnhwehwɛ edin ko a ɔde bɛtoto wɔn. Edin a onipa de too abɔdeɛ a nkwa wɔ mu biara no, ɛno ara na ɛyɛɛ edin a wɔde frɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Enti, onipa totoo nyɛmmoa, ewiem nnomaa ne wiram mmoa no nyinaa edin. Nanso, onipa deɛ, wannya ɔboafoɔ a ɔfata no. ");
INSERT INTO twiasante_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Enti, Awurade Onyankopɔn maa onipa daa nnahɔɔ. Ɛberɛ a onipa daa saa no, ɔyii ne mfe mu mpadeɛ baako, na ɔde honam taree deɛ ɔyii mpadeɛ hɔ no. ");
INSERT INTO twiasante_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Afei, Awurade Onyankopɔn de mfe mu mpadeɛ baako a ɔyi firii onipa mu no bɔɔ ɔbaa, de no maa onipa no. ");
INSERT INTO twiasante_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Na Adam kaa sɛ, “Mʼankasa me dompe ne me honam bi nie. Wɔbɛfrɛ yei ɔbaa ɛfiri sɛ, ɔbarima mu na wɔyii no firiiɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yei enti na ɔbarima gya nʼagya ne ne na de ne ho kɔbata ne yere ho sɛdeɛ wɔn baanu bɛyɛ nnipa korɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Saa ɛberɛ no, na ɔbarima ne ne yere nyinaa ho da hɔ, nanso na wɔmfɛre. ");
INSERT INTO twiasante_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Na ɔwɔ yɛ ɔdaadaafoɔ wɔ wiram mmoadoma a Awurade Onyankopɔn abɔ wɔn no nyinaa mu. Ɔwɔ no kɔɔ ɔbaa no nkyɛn kɔbisaa no sɛ, “Enti, ɛyɛ ampa ara sɛ, Onyankopɔn se, ‘Monnni turo yi mu aduaba biara?’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ɔbaa no buaa ɔwɔ sɛ, “Yɛtumi di nnua a ɛwɔ turo yi mu no so aduaba biara, ");
INSERT INTO twiasante_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","nanso Onyankopɔn kaa sɛ, ‘Ɛnsɛ sɛ yɛdi dua a ɛsi turo no mfimfini no so aduaba, na ɛnsɛ sɛ yɛde yɛn nsa mpo ka, anyɛ saa a, yɛbɛwuwu.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Na ɔwɔ no ka kyerɛɛ ɔbaa no sɛ, “Morenwuwu. ");
INSERT INTO twiasante_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Onyankopɔn nim sɛ, ɛda a mobɛdi no ara pɛ, mo ani bɛba mo ho so, ama moayɛ sɛ Onyankopɔn, na moahunu papa ne bɔne.” ");
INSERT INTO twiasante_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ɛberɛ a ɔbaa no hunuu sɛ dua a ɛsi mfimfini no so aba no wɔdi a, ɛbɛyɛ yie, na ɛyɛ akɔnnɔ, na afei ɛte ani no, ɔtee bi diiɛ, de bi ma ne kunu a na ɔne no wɔ hɔ maa ɔno nso diiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Wɔdi wieeɛ no, wɔn baanu ani baa wɔn ho so, na wɔhunuu sɛ wɔn nyinaa da adagya. Enti, wɔkekaa nhahan sisii animu de kataa wɔn adagya so. ");
INSERT INTO twiasante_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ɛda no anwummerɛ, wɔtee Awurade Onyankopɔn nka sɛ ɔnam turo no mu. Enti, Adam ne ne yere Hawa de wɔn ho kɔsiee nnua a ɛwɔ turo mu hɔ no mu sɛdeɛ Awurade Onyankopɔn renhunu wɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Enti, Awurade Onyankopɔn frɛɛ Adam bisaa no sɛ, “Mowɔ he?” ");
INSERT INTO twiasante_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adam buaa sɛ, “Metee wo nka wɔ turo no mu hɔ, nanso na mesuro, ɛfiri sɛ, na meda adagya enti mekɔtɛeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Na Onyankopɔn bisaa no sɛ, “Hwan na ɔka kyerɛɛ wo sɛ na woda adagya? Gyama dua a meka kyerɛɛ wo sɛ, nni so aba no, woadi nʼaba no bi?” ");
INSERT INTO twiasante_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adam kaa sɛ, “Aane. Ɔbaa no a wode no maa me sɛ me ne no ntena no na ɔde aduaba a ɔte firii dua no so no brɛɛ me ma mediiɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Enti, Awurade Onyankopɔn bisaa ɔbaa no sɛ, “Ɛdeɛn na woayɛ yi?” Ɔbaa no buaa sɛ, “Ɔwɔ no na ɔdaadaa me ma mediiɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Enti, Awurade Onyankopɔn ka kyerɛɛ ɔwɔ no sɛ, “Esiane saa adeɛ a woayɛ yi enti, “Wɔadome wo wɔ mmoa nyinaa ne nkekaboa mu. Wobɛwea wʼafuru so, na wo nkwa nna nyinaa woadi mfuturo. ");
INSERT INTO twiasante_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mede ɔtan bɛto wo ne ɔbaa no ne wʼasefoɔ ne nʼasefoɔ ntam. Ɔno na ɔbɛbɔ wo tire, na wo nso woaka ne nantin.” ");
INSERT INTO twiasante_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Afei, Awurade Onyankopɔn ka kyerɛɛ ɔbaa no nso sɛ, “Wobɛte ɔyea pa ara wɔ wʼawoɔ mu; ɔyea mu na wobɛwo mma. Yei nyinaa akyiri no, wʼani bɛgyina wo kunu na ɔbɛdi wo so.” ");
INSERT INTO twiasante_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Onyankopɔn ka kyerɛɛ Adam nso sɛ, “Esiane sɛ wotiee wo yere asɛm, na wodii dua a mehyɛɛ wo sɛ, ‘Nni so aba no’ enti, “Madome asase, na ɔbrɛ ne ɔhaw mu na wobɛdidi so wo nkwa nna nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ɛbɛfifiri nkasɛɛ ne nkyɛkyerɛ ama wo na woadi wiram nhahan. ");
INSERT INTO twiasante_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Wobɛsiam wʼanim fifire ansa na woanya aduane adi, kɔsi sɛ wobɛwu akɔ dɔteɛ mu, ɛfiri sɛ, dɔteɛ no mu na menwonoo wo firiiɛ; woyɛ dɔteɛ, na dɔteɛ mu na wobɛsane akɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam too ne yere no edin Hawa, ɛfiri sɛ, ɔno na ɔbɛyɛ ateasefoɔ nyinaa na. ");
INSERT INTO twiasante_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Awurade Onyankopɔn de aboa nwoma yɛɛ ntadeɛ maa Adam ne ne yere Hawa de kataa wɔn ho. ");
INSERT INTO twiasante_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Awurade Onyankopɔn kaa sɛ, “Afei, onipa no abɛyɛ sɛ yɛn ara a, wahunu papa ne bɔne. Ɛnsɛ sɛ yɛma no ɛkwan na ɔtene ne nsa kɔte nkwa dua no so aba no bi die, na ɔtena ase afebɔɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Enti, Awurade Onyankopɔn pamoo no firii Eden turo no mu sɛ ɔnkɔyɛ adwuma wɔ asase a, wɔnwonoo no firii mu no so. ");
INSERT INTO twiasante_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ɔpamoo onipa no. Na Eden turo no apueeɛ fam hɔ no, ɔde Kerubim ne afena a ɛredɛre twa ne ho fa baabiara no sii hɔ sɛ, ɛnwɛn ɛkwan a ɛkɔ nkwa dua no ho. ");
INSERT INTO twiasante_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Afei, Adam de ne ho kaa ne yere Hawa ma ɔnyinsɛne woo abarimaa a wɔfrɛ no Kain. Na ɔkaa sɛ, Awurade adaworoma, mawo ɔbabarima. ");
INSERT INTO twiasante_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Akyire no, ɔsane woo nʼakyiri ɔbabarima too no edin Habel. Na Habel bɛyɛɛ odwanhwɛfoɔ, ɛnna Kain nso bɛyɛɛ okuafoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Nna bi akyiri, Kain de nʼafuom nnɔbaeɛ bi kɔbɔɔ Awurade afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel nso de ne nyɛmmoa no mu mmakan a wɔadɔre sradeɛ kɔbɔɔ Onyankopɔn afɔdeɛ. Awurade ani sɔɔ Habel afɔrebɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Nanso Kain afɔrebɔdeɛ no deɛ, nʼani ansɔ. Asɛm no anyɛ Kain dɛ, na ne bo fuiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Awurade bisaa Kain sɛ, “Adɛn enti na wo bo afuo? Adɛn enti na woamuna saa? ");
INSERT INTO twiasante_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Sɛ woyɛ ade pa a, wɔbɛgye wo atom. Sɛ wonyɛ ade pa deɛ a, ɛnneɛ, hwɛ yie. Ɛfiri sɛ, bɔne retwɛn ako atia wo, asɛe wo, nanso ɛsɛ sɛ wodi ne so.” ");
INSERT INTO twiasante_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ɛda bi Kain ka kyerɛɛ ne nua Habel sɛ, “Ma yɛnkɔ afuom.” Ɛberɛ a wɔwɔ afuom hɔ no, Kain to hyɛɛ ne nua Habel so, kumm no. ");
INSERT INTO twiasante_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Awurade bisaa Kain sɛ, “Wo nua Habel wɔ he?” Kain buaa sɛ, “Mennim. Mɛyɛ dɛn mahunu? Me na mehwɛ me nua no so anaa?” ");
INSERT INTO twiasante_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Awurade bisaa Kain sɛ, “Ɛdeɛn na woayɛ yi? Tie! Wo nua mogya su firi asase so frɛ me. ");
INSERT INTO twiasante_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Seesei, wɔadome wo, apamo wo afiri asase a ɛbuee nʼano gyee wo nua mogya firii wo nsam no so. ");
INSERT INTO twiasante_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Sɛ woyɛ asase no so adwuma sɛ ɛdeɛn ara a, worennya nnɔbaeɛ biara mfiri so. Wobɛyɛ ɔkobɔfoɔ, akyinkyin asase so.” ");
INSERT INTO twiasante_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain kaa sɛ, “Awurade mʼasotweɛ boro me so. ");
INSERT INTO twiasante_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ɛnnɛ, woapam me afiri asase so ne wʼanim. Mɛyɛ ɔkobɔfoɔ akyinkyin asase so na obiara a ɔbɛnya me no bɛkum me.” ");
INSERT INTO twiasante_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Nanso, Awurade ka kyerɛɛ no sɛ, “Ɛnte saa koraa! Obiara a ɔbɛkum Kain no bɛnya Kain asotwe no mprɛnson.” Afei, Awurade hyɛɛ Kain agyiraeɛ bi sɛdeɛ ɛbɛyɛ a, obiara a ɔbɛhyia no no renkum no. ");
INSERT INTO twiasante_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Enti, Kain dwane firii Awurade anim, kɔtenaa Nod asase so wɔ Eden apueeɛ fam. ");
INSERT INTO twiasante_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain de ne ho kaa ne yere na ɔnyinsɛnee, woo ɔbabarima, too no edin Henok. Saa ɛberɛ no, Kain kyekyeree kuro bi de too ne ba Henok. ");
INSERT INTO twiasante_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henok woo Irad. Irad woo Mehuyael. Mehuyael woo Metusael. Metusael woo Lamek. ");
INSERT INTO twiasante_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek waree mmaa baanu a wɔn din de Ada ne Sila. ");
INSERT INTO twiasante_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada woo Yabal a nʼasefoɔ yɛ wɔn a wɔte ntomadan mu yɛn mmoa. ");
INSERT INTO twiasante_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Na Yabal nuabarima din de Yubal a nʼasefoɔ yɛ mmɛnhyɛnfoɔ ne asankubɔfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila woo ɔbabarima a wɔfrɛ no Tubal-Kain. Na ɔyɛ kɔbere dwumfoɔ ne nnadeɛ ahodoɔ nyinaa atomfoɔ agya. Na Tubal-Kain wɔ nuabaa bi a ne din de Naama. ");
INSERT INTO twiasante_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ɛda bi Lamek ka kyerɛɛ ne yerenom Ada ne Sila sɛ, “Montie me, me yerenom makum aberanteɛ bi a, ɔto hyɛɛ me so, piraa me. ");
INSERT INTO twiasante_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Sɛ Kain so aweretɔ bɛyɛ mprɛnson a, ɛnneɛ, me Lamek, deɛ ɔbɛkum me no, nʼasotwe bɛyɛ mpɛn aduɔson nson.” ");
INSERT INTO twiasante_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Akyire yi, Adam de ne ho kaa ne yere Hawa. Na ɔwoo ɔbabarima bio. Na wɔtoo no edin Set kaa sɛ, “Onyankopɔn ama me ɔba foforɔ asi Habel a Kain kumm no no ananmu.” ");
INSERT INTO twiasante_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set nso woo ɔbabarima na ɔtoo no edin Enos. Saa ɛberɛ no mu na nnipa hyɛɛ aseɛ bɔɔ Awurade edin. ");
INSERT INTO twiasante_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Sɛdeɛ Adam asefoɔ nnidisoɔ teɛ nie. Ɛberɛ a Onyankopɔn nwonoo onipa no, ɔnwonoo no sɛ ɔno ara ne sɛso. ");
INSERT INTO twiasante_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ɔbɔɔ ɔbaa ne ɔbarima, na ɔhyiraa wɔn. Ɔbɔɔ wɔn wieeɛ no, ɔtoo wɔn edin onipa. ");
INSERT INTO twiasante_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam dii mfeɛ ɔha aduasa no, ɔwoo ɔbabarima sɛ ɔno ara ne bɔbea ne ne sɛso. Ɔtoo no edin Set. ");
INSERT INTO twiasante_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ɔwoo Set no, Adam tenaa ase mfeɛ aha nwɔtwe a, ɔwowoo mmammarima ne mmammaa kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Sɛ wɔka Adam mfeɛ nyinaa bom a, ɔdii mfeɛ aha nkron aduasa, ansa na ɔrewu. ");
INSERT INTO twiasante_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set dii mfeɛ ɔha ne enum no, ɔwoo Enos. ");
INSERT INTO twiasante_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set woo Enos akyiri no, ɔtenaa ase, dii mfeɛ aha nwɔtwe ne nson, wowoo mmammarima ne mmammaa kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sɛ wɔka Set mfeɛ dodoɔ bom a, ɔdii mfeɛ aha nkron ne dumienu, ansa na ɔrewu. ");
INSERT INTO twiasante_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos dii mfeɛ aduɔkron no, ɔwoo Kenan. ");
INSERT INTO twiasante_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enos woo Kenan akyiri no, ɔtenaa ase mfeɛ aha nwɔtwe ne dunum, wowoo mmammarima ne mmammaa kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Sɛ wɔka Enos mfeɛ dodoɔ bom a, ɔdii mfeɛ aha nkron ne enum, ansa na ɔrewu. ");
INSERT INTO twiasante_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan dii mfeɛ aduɔson no, ɔwoo Mahalalel. ");
INSERT INTO twiasante_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan woo Mahalalel akyiri no, ɔtenaa ase mfeɛ aha nwɔtwe aduanan, wowoo mmammarima ne mmammaa kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Sɛ wɔka Kenan mfeɛ dodoɔ bom a, ɔdii mfeɛ aha nkron ne edu, ansa na ɔrewu. ");
INSERT INTO twiasante_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel dii mfeɛ aduosia enum no, ɔwoo Yared. ");
INSERT INTO twiasante_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel woo Yared akyiri no, ɔtenaa ase, dii mfeɛ aha nwɔtwe aduasa, wowoo mmammarima ne mmammaa kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Sɛ wɔka Mahalalel mfeɛ dodoɔ bom a, ɔdii mfeɛ aha nwɔtwe aduɔkron enum, ansa na ɔrewu. ");
INSERT INTO twiasante_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared dii mfeɛ ɔha aduosia mmienu no, ɔwoo Henok. ");
INSERT INTO twiasante_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yared woo Henok akyiri no, ɔtenaa ase mfeɛ aha nwɔtwe, wowoo mmammarima ne mmammaa kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Sɛ wɔka Yared mfeɛ dodoɔ bom a, ɔdii mfeɛ aha nkron aduosia mmienu, ansa na ɔrewu. ");
INSERT INTO twiasante_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henok dii mfeɛ aduosia enum no, ɔwoo Metusela. ");
INSERT INTO twiasante_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henok woo Metusela akyiri no, Henok de ne ho bataa Awurade ho mfeɛ ahasa, na ɔwowoo mmammarima ne mmammaa kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Sɛ wɔka Henok mfeɛ dodoɔ bom a, ɔdii mfeɛ ahasa aduosia enum. ");
INSERT INTO twiasante_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henok de ne ho bataa Onyankopɔn; afei, obi anhunu no bio, ɛfiri sɛ, Onyankopɔn faa no kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela dii mfeɛ ɔha aduɔwɔtwe nson no, ɔwoo Lamek. ");
INSERT INTO twiasante_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusela woo Lamek akyiri no, ɔtenaa ase mfeɛ ahanson aduɔwɔtwe mmienu, wowoo mmammarima ne mmammaa kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Sɛ wɔka Metusela mfeɛ dodoɔ bom a, ɔdii mfeɛ aha nkron aduosia nkron, ansa na ɔrewu. ");
INSERT INTO twiasante_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek dii mfeɛ ɔha ne aduɔwɔtwe mmienu no, ɔwoo ɔbabarima. ");
INSERT INTO twiasante_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ɔtoo no edin Noa, na ɔkaa sɛ, ɔno na ɔbɛma yɛanya ahomegyeɛ afiri kuayɛ mu adwumaden wɔ asase a Awurade adome no so. ");
INSERT INTO twiasante_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek woo Noa akyiri no, ɔtenaa ase mfeɛ ahanum aduɔkron enum, wowoo mmammarima ne mmammaa kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Sɛ wɔka Lamek mfeɛ dodoɔ bom a, ɔdii mfeɛ ahanson aduɔson nson, ansa na ɔrewu. ");
INSERT INTO twiasante_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa dii mfeɛ ahanum no, ɔwoo mmammarima baasa a, wɔfrɛ wɔn Sem, Ham ne Yafet. ");
INSERT INTO twiasante_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ɛberɛ a nnipa dɔɔso wɔ asase so no, wɔwoo mmammaa. ");
INSERT INTO twiasante_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Onyankopɔn mmammarima no hunuu sɛ nnipa mmammaa no ho yɛ fɛ enti, deɛ obiara pɛ no no, ɔfaa no wareeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Afei, Awurade kaa sɛ, “Me honhom rentena nnipa mu nkɔsi daa, ɛfiri sɛ, wɔyɛ ɔhonam; na wɔn nkwa nna bɛyɛ mfeɛ ɔha aduonu.” ");
INSERT INTO twiasante_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Saa ɛberɛ no, na nnipa akwabrane wɔ asase no so. Ɛberɛ a Onyankopɔn mmammarima yi kɔɔ nnipa mmammaa yi ho no, wɔne wɔn wowoeɛ. Saa nnipa yi ne kane tete nnipa atitire a na wɔyɛ akofoɔ a wɔgyee edin no. ");
INSERT INTO twiasante_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Awurade Onyankopɔn hunuu sɛ adasamma amumuyɛ adɔɔso wɔ asase so, na nnipa nsusuiɛ nyinaa yɛ bɔne nko ara. ");
INSERT INTO twiasante_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ɛyɛɛ Awurade Onyankopɔn awerɛhoɔ sɛ ɔbɔɔ wɔn bɛtenaa asase so. Saa bɔne no yɛɛ Awurade Onyankopɔn awerɛhoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Awurade kaa sɛ, “Mɛpepa nnipa a mabɔ wɔn no afiri asase so; mmoa ne mmoa a wɔwea asase so ne ewiem nnomaa, ɛfiri sɛ, ɛyɛ me ya sɛ mebɔɔ wɔn.” ");
INSERT INTO twiasante_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nanso, Noa deɛ, ɔnyaa adom Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noa awoɔ ntoatoasoɔ nie. Na Noa yɛ onipa teneneeni a ne ho nni asɛm wɔ ne berɛsofoɔ mu. Ɔyɛɛ Onyankopɔn apɛdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa woo mmammarima baasa na wɔn din de Sem, Ham ne Yafet. ");
INSERT INTO twiasante_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Na bɔne ahyɛ asase so ma a amumuyɛsɛm adɔɔso. ");
INSERT INTO twiasante_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Onyankopɔn hunuu saa bɔne yi nyinaa wɔ asase so, hunuu awurukasɛm ne amumuyɛsɛm, afanan nyinaa nso. ");
INSERT INTO twiasante_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Enti, Onyankopɔn ka kyerɛɛ Noa sɛ, “Esiane sɛ nnipa ama basabasa aba asase so enti, mɛsɛe nnipa ne asase a wɔte so no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Fa ɔwawa dua yɛ adaka. Yɛ adan wɔ Adaka no mu, na fa ama ka emu ne akyire nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Sei na ɛsɛ sɛ woyɛ no: ma ne tenten nyɛ anammɔn ahanan aduonum, ne trɛ anammɔn aduɔson enum, na ne ɔsorokɔ nso nyɛ anammɔn aduanan enum. ");
INSERT INTO twiasante_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Bɔ adaka no so. Ma ne ɔsorokɔ nyɛ bɛyɛ sɛ nsateakwaa dunwɔtwe. Fa ɛpono to adaka no nkyɛn, na yɛ nsamsoɔ mmiɛnsa; deɛ ɛdi ɛkan, deɛ ɛda ntam ne deɛ ɛwɔ soro. ");
INSERT INTO twiasante_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Tie! Mede nsuyire bɛkata asase so nyinaa, na mede asɛe abɔdeɛ a nkwa wɔ mu; biribiara a nkwa wɔ mu no, ne nyinaa bɛwuwu. ");
INSERT INTO twiasante_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Na wo deɛ, me ne wo bɛyɛ apam; na wo, wo mmammarima, wo yere ne wo mmammarima yerenom nyinaa ne wo bɛba Adaka no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ɛsɛ sɛ wode abɔdeɛ a nkwa wɔ mu nyinaa, mmienu mmienu a, ɛyɛ onini ne ɔbereɛ a, wo ne wɔn bɛtena adaka no mu nsuyire berɛ no a, wɔnwuwuo. ");
INSERT INTO twiasante_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Nnomaa ahodoɔ biara mmienu, mmoa biara mmienu, ne abɔdeɛ biara a ɛwea asase so mmienu bɛba wo nkyɛn, na woahwɛ wɔn, na wɔanwuwu. ");
INSERT INTO twiasante_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Afei, fa nnuane ahodoɔ a, wɔdie na kora. Ɛno na ɛbɛyɛ wo ne wɔn nnuane a mobɛdi.” ");
INSERT INTO twiasante_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa yɛɛ biribiara pɛpɛɛpɛ, sɛdeɛ Onyankopɔn ka kyerɛɛ no sɛ ɔnyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Afei, Awurade ka kyerɛɛ Noa sɛ, “Wo ne wo fiefoɔ nyinaa nkɔ Adaka no mu, ɛfiri sɛ, asase so nnipa nyinaa no, wo na mahunu sɛ woyɛ ɔteneneeni. ");
INSERT INTO twiasante_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Fa mmoa a wɔn ho te biara, anini nson ne abereɛ nson ka wo ho. Na fa mmoa biara a wɔn ho nte nso mmienu, onini ne ɔbereɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Na fa nnomaa biara anini nson ne abereɛ, sɛdeɛ ɛbɛyɛ a, nsuyire no akyiri no, wɔn ase bɛfɛe. ");
INSERT INTO twiasante_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Nnanson sɛ ɛnnɛ pɛpɛɛpɛ, mɛma osuo atɔ asase so awia ne anadwo adaduanan. Mɛpepa abɔdeɛ biara a nkwa wɔ mu a mabɔ afiri asase so.” ");
INSERT INTO twiasante_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noa dii nsɛm a Awurade ka kyerɛɛ no no nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ɛberɛ a nsuyire baa asase so no, na Noa adi mfeɛ aha nsia. ");
INSERT INTO twiasante_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa ne ne mmammarima ne ne yere ne ne nsenom mmaa kɔhyɛɛ adaka no mu sɛdeɛ ɛbɛyɛ a, nsuyire no renka wɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Mmoa a wɔn ho te ne wɔn a wɔn ho nte, nnomaa ne mmoa a wɔwea fam, ");
INSERT INTO twiasante_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","mmienu mmienu a wɔyɛ anini ne abereɛ kɔkaa Noa ho wɔ adaka no mu, sɛdeɛ Onyankopɔn ka kyerɛɛ Noa sɛ ɔnyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Na nnanson no akyiri no, nsuyire no hyɛɛ aseɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa dii mfeɛ ahansia no mu no, bosome a ɛtɔ so mmienu no ɛda a ɛtɔ so dunson no, nsutire a ɛwɔ asase mu no nyinaa bobɔeɛ, na ɛsoro mpomma nso buebueeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Osuo tɔɔ asase so awia ne anadwo adaduanan. ");
INSERT INTO twiasante_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Saa ɛda no ara, Noa ne ne mmammarima Sem, Ham ne Yafet ne ne yere ne ne mmammarima baasa no yerenom kɔhyɛɛ adaka no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Na wiram mmoa ahodoɔ ne nyɛmmoa ahodoɔ ne aboa biara a ɔnam asase so ne anomaa biara ne abɔdeɛ biara a ɛwɔ ntaban ka wɔn ho wɔ Adaka no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Abɔdeɛ biara a nkwa wɔ wɔn mu mmienu mmienu baa Noa nkyɛn bɛwuraa Adaka no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Mmoa a wɔwuraa mu no nyinaa, na wɔyɛ anini ne abereɛ, sɛdeɛ Onyankopɔn ka kyerɛɛ Noa no. Afei, Awurade kaa Noa hyɛɛ adaka no mu, too no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Nsuyire no toaa so adaduanan asase so. Ɛmaa Adaka no so ma ɛtɛɛ nsuo no ani. ");
INSERT INTO twiasante_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Nsuo no kɔɔ so yirii tɛnn wɔ asase so, ma Adaka no tɛɛ nsuo no ani. ");
INSERT INTO twiasante_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nsuo no yirii tɛntɛntɛn wɔ asase so ara kɔsii sɛ, ɛkataa mmepɔ atentene akɛseɛ a ɛwɔ asase so nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Nsuo no yirii ara kɔsii sɛ ɛkataa mmepɔ no so boroo so anammɔn aduonu. ");
INSERT INTO twiasante_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Abɔdeɛ biara a nkwa wɔ mu a ɛnam asase so te sɛ nnomaa, wiram mmoa a wɔwea asase so ne adasamma ase hyeeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Biribiara a ɛte asase kesee so nso ase hyeeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Wɔpepaa biribiara a nkwa wɔ mu a ɛte asase so no. Nnipa ne mmoa ne abɔdeɛ a wɔnam asase so ne ewiem nnomaa nyinaa nso, wɔpepaa wɔn firii asase so. Ɛkaa Noa ne wɔn a na wɔka ne ho wɔ adaka no mu nko ara. ");
INSERT INTO twiasante_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Nsuyire no toaa so asase so nnafua ɔha aduonum. ");
INSERT INTO twiasante_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nanso, Onyankopɔn kaee Noa ne wiram mmoa a na wɔne no wɔ adaka no mu no. Onyankopɔn maa mframa bɔ faa asase so, na nsuo no tweeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nsutire a ɛwɔ asase ase no mu nsuo a ɛbɔeɛ no gyaee ba, na ɛsoro mpomma no nso mu totoeɛ, maa nsuo no gyaee tɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Nsuo no toaa so twe firii asase so. Nnafua ɔha ne aduonum akyiri no, na nsuo no atwe koraa. ");
INSERT INTO twiasante_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Bosome a ɛtɔ so nson no ɛda a ɛtɔ so dunson so, Adaka no kɔtaa Ararat mmepɔ so. ");
INSERT INTO twiasante_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Nsuo no toaa so, tweeɛ ara kɔsii ɔbosome a ɛtɔ so edu no so. Na ɔbosome edu no ɛda a ɛdi ɛkan no, mmepɔ no atifi daa adi. ");
INSERT INTO twiasante_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Adaduanan akyiri no, Noa buee mpomma a ɔtwa too adaka no ho no, ");
INSERT INTO twiasante_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","na ɔsomaa kwaakwaadabi, ma ɔdii akɔneaba kɔsii sɛ nsuo no nyinaa we firii asase no so. ");
INSERT INTO twiasante_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Afei, ɔsomaa aborɔnoma sɛ, ɔnkɔhwɛ sɛ asase no so awo anaa. ");
INSERT INTO twiasante_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Nanso, aborɔnoma no annya baabi ansi, ɛfiri sɛ, na nsuo no akata asase no so nyinaa. Enti, ɔsane baa Noa nkyɛn, maa Noa tenee ne nsa sɔɔ ne mu de no baa Adaka no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noa twɛn nnanson, na ɛno akyiri no, ɔsane somaa aborɔnoma no bio. ");
INSERT INTO twiasante_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ɛberɛ a aborɔnoma no sane baa ne nkyɛn anwummerɛ no, na ngo dua ahahammono a wate tua nʼano. Ɛno na ɛmaa Noa hunuu sɛ, nsuo no atwe afiri asase no so. ");
INSERT INTO twiasante_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Noa twɛnee nnanson bio, na ɔsane somaa aborɔnoma no, nanso wansane amma ne nkyɛn bio. ");
INSERT INTO twiasante_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Na ɛbaa sɛ Noa dii mfeɛ ahansia ne baako, bosome a ɛdi ɛkan no mu ɛda a ɛdi ɛkan no, na nsuo no atwe afiri asase no so. Enti, Noa yii adaka no suhyɛ no, na ɔhunuu sɛ, asase so awo. ");
INSERT INTO twiasante_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ɔbosome a ɛtɔ so mmienu no ɛda a ɛtɔ so aduonu nson so no na asase no so woo koraa. ");
INSERT INTO twiasante_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Onyankopɔn ka kyerɛɛ Noa sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Wo ne wo yere ne wo mmammarima ne wɔn yerenom mfiri adaka no mu mfi. ");
INSERT INTO twiasante_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Afei, yi abɔdeɛ biara a nkwa wɔ mu a wɔwɔ wo nkyɛn, a ɛyɛ nnomaa, mmoa ne mmoa a wɔnam asase so nyinaa firi adaka no mu sɛdeɛ ɛbɛyɛ a, wɔn ase bɛdɔre wɔ asase so.” ");
INSERT INTO twiasante_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Enti, Noa ne ne mmammarima ne ne yere ne ne mmammarima yerenom firii adaka no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Mmoa no nyinaa ne abɔdeɛ a wɔnam asase so nyinaa ne nnomaa nyinaa ne biribiara a ɛnam asase so ahodoɔ nyinaa firii Adaka no mu saa ara mmaako mmaako. ");
INSERT INTO twiasante_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Afei, Noa sii afɔrebukyia maa Awurade. Ɔfaa mmoa ne nnomaa a wɔn ho te, de bɔɔ ɔhyeɛ afɔdeɛ wɔ afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Awurade tee afɔdeɛ no a Noa bɔeɛ no hwam a ɛyɛ no, ɔkaa wɔ nʼakoma mu sɛ, “Ɛwom sɛ bɔne ahyɛ onipa akoma ma firi ne mmɔfraase deɛ, nanso merenni onipa akyiri nnome asase bio. Na merensɛe abɔdeɛ a nkwa wɔ mu bio sɛdeɛ mayɛ yi. ");
INSERT INTO twiasante_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Mmerɛ dodoɔ a asase da so wɔ hɔ yi, oguo ne otwa, awɔ ne ahuhuro, asusɔ ne ɔpɛ, owia ne anadwo rentwam da.” ");
INSERT INTO twiasante_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Afei, Onyankopɔn hyiraa Noa ne ne mmammarima no ka kyerɛɛ wɔn sɛ, “Monwo, na monyɛ bebree nhyɛ asase so ma. ");
INSERT INTO twiasante_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mo ho hu ne mo ho suro bɛtɔ mmoa a wɔwɔ asase so nyinaa ne ewiem nnomaa nyinaa ne abɔdeɛ biara a wɔnam asase so ne nsuo mu mpataa nyinaa so. Wɔn nyinaa hyɛ mo nsa. ");
INSERT INTO twiasante_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Biribiara a nkwa wɔ mu, na ɛkeka ne ho no bɛyɛ mo aduane. Sɛdeɛ mede nhahammono hyɛɛ mo nsa no, afei deɛ, mede biribiara ma mo. ");
INSERT INTO twiasante_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Nanso, ɛnsɛ sɛ mowe aboa a wɔntwaa ne mene mmaa ne mogya no nguiɛ no ɛnam. ");
INSERT INTO twiasante_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Wo nkwa deɛ, deɛ ɛbɛyɛ biara, mɛbisa ho akontabuo. Onipa a ɔkum ne yɔnko onipa no, mɛbisa no ho asɛm. Mpo, aboa biara a ɔbɛkum onipa no, mewɔ saa aboa no nso asɛmmisa. Mɛbisa onipa kra ho asɛm. ");
INSERT INTO twiasante_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Obiara a ɔhwie onipa mogya guo no, onipa so na wɔnam bɛhwie ɔno nso mogya aguo, ɛfiri sɛ, Onyankopɔn no ara sɛso na ɔbɔɔ onipa. ");
INSERT INTO twiasante_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mo deɛ, monwo, na monyɛ bebree. Mo ase mfɛe asase so, na monnɔɔso.” ");
INSERT INTO twiasante_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Afei, Onyankopɔn ka kyerɛɛ Noa ne ne mmammarima a wɔka ne ho no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ɛnnɛ, me ne mo ne mo asefoɔ a wɔbɛwo wɔn no ");
INSERT INTO twiasante_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ne abɔdeɛ biara a nkwa wɔ mu a na wɔwɔ mo nkyɛn wɔ adaka no mu yɛ apam: nnomaa, nyɛmmoa ne wiram mmoa a wɔne mo firi adaka no mu no baeɛ nyinaa, ne abɔdeɛ biara a nkwa wɔ mu a wɔwɔ asase so. ");
INSERT INTO twiasante_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Me ne mo yɛ mʼapam sɛ: Meremfa nsuyire nsɛe abɔdeɛ biara a nkwa wɔ mu a ɛwɔ asase so. Saa ara nso na meremfa nsuyire nsɛe asase bio da.” ");
INSERT INTO twiasante_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Na Onyankopɔn kaa sɛ, “Yei ne apam a me, Onyankopɔn, ne mo ne abɔdeɛ a nkwa wɔ mu biara a wɔka mo ho no ne nkyirimma nyinaa reyɛ no ho nsɛnkyerɛnneɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mato me nyankontɔn wɔ omununkum mu. Ɛno na ɛbɛyɛ apam a ɛbɛda me ne asase ntam. ");
INSERT INTO twiasante_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ɛberɛ biara a mede omununkum bɛba asase ani, na sɛ nyankontɔn pue wɔ omununkum no mu a, ");
INSERT INTO twiasante_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","mɛkae mʼapam a ɛda me ne mo ne abɔdeɛ a nkwa wɔ mu ahodoɔ no nyinaa ntam. Nsuyire a ɛbɛsɛe abɔdeɛ a nkwa wɔ mu no nyinaa remma da biara da bio. ");
INSERT INTO twiasante_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ɛberɛ biara a nyankontɔn bɛto wɔ omununkum mu no, mɛhunu, na makae apam a ɛwɔ hɔ daa a ɛda me, Onyankopɔn, ne abɔdeɛ a nkwa wɔ mu ahodoɔ nyinaa a wɔwɔ asase yi so ntam no.” ");
INSERT INTO twiasante_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Enti, Onyankopɔn ka kyerɛɛ Noa sɛ, “Yei ne apam a me ne abɔdeɛ biara a nkwa wɔ mu a, wɔwɔ asase yi so ayɛ no ho nsɛnkyerɛnneɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Yeinom ne Noa mmammarima a wɔfiri adaka no mu baeɛ: Sem, Ham ne Yafet. Ham na ɔwoo Kanaan. ");
INSERT INTO twiasante_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Yeinom ne Noa mmammarima. Wɔn mu na nnipa a, wɔahwete wɔ asase so nyinaa firi baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa yɛ okuafoɔ a ɔdii ɛkan. Ɔyɛɛ bobefuo. ");
INSERT INTO twiasante_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ɛda bi, ɔnom bobesa no bi boroeɛ, ma ɔdaa ne ntomadan mu adagya. ");
INSERT INTO twiasante_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham a ɔwoo Kanaan no kɔtoo nʼagya Noa sɛ ɔda adagya. Ɔfirii hɔ no, ɔkɔbɔɔ ne nuammarima baanu no amaneɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Enti, Sem ne Yafet faa atadeɛ de guu wɔn mmati so, kɔɔ nkyirinkyire de kɔkataa wɔn agya adagya so. Na wɔn ani nkyerɛ wɔn agya enti, wɔanhunu nʼadagya mu. ");
INSERT INTO twiasante_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ɛberɛ a Noa ani so tetee no, na ɔhunuu deɛ ne kaakyire no ayɛ no, ");
INSERT INTO twiasante_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ɔkaa sɛ, “Nnome nka Ham asefoɔ a wɔyɛ Kanaanfoɔ. Wɔbɛyɛ wɔn nuanom mu nkoa mu nkoa.” ");
INSERT INTO twiasante_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Noa kaa bio sɛ, “Me nhyira a ɛfiri Awurade, me Onyankopɔn, nkyɛn no nka Sem! Kanaan nyɛ Sem akoa. ");
INSERT INTO twiasante_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Onyankopɔn ntrɛ Yafet ase ne nʼasase mu. Yafet ntena Sem ntomadan mu, na Kanaan nyɛ nʼakoa.” ");
INSERT INTO twiasante_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nsuyire no akyiri no, Noa tenaa ase mfeɛ ahasa ne aduonum. ");
INSERT INTO twiasante_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa dii mfeɛ aha nkron ne aduonum, ansa na ɔrewu. ");
INSERT INTO twiasante_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Yeinom ne Noa mmammarima: Wɔn ne Sem, Ham ne Yafet asefoɔ. Wɔwowoo mmammarima nsuyire no akyiri. ");
INSERT INTO twiasante_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafet asefoɔ nie: Gomer, Magog, Media, Yawan, Tubal, Mesek ne Tiras. ");
INSERT INTO twiasante_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer asefoɔ nie: Askenas, Rifat ne Togarma. ");
INSERT INTO twiasante_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawan asefoɔ nie: Elisa, Tarsis, Kitim ne Rodanim. ");
INSERT INTO twiasante_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Na wɔn asefoɔ bɛyɛɛ ɛpo so adwumayɛfoɔ wɔ nsase ahodoɔ so a na abusuakuo biara ka ne kasa nko. ");
INSERT INTO twiasante_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham asefoɔ nie: Kus, Misraim, Put ne Kanaan. ");
INSERT INTO twiasante_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus asefoɔ nie: Seba, Hawila, Sabta, Raama ne Sabteka. Na Raama asefoɔ nso ne: Saba ne Dedan. ");
INSERT INTO twiasante_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus woo Nimrod. Na Nimrod bɛyɛɛ ɔkofoɔ kɛseɛ wɔ asase so. ");
INSERT INTO twiasante_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Na ɔyɛ ɔbɔmmɔfoɔ kɛseɛ a Awurade ahyira no, na wɔbɔ ne din ka asɛm. Na obiara a ɔyɛ akokoɔdurusɛm no, wɔde no toto Nimrod a na ɔyɛ ɔbɔmmɔfoɔ kɛseɛ a Awurade ahyira no no ho. ");
INSERT INTO twiasante_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nʼahennie hyɛɛ aseɛ wɔ Babilonia, Erek, Akad ne Kalne a, ne nyinaa wɔ Sinear asase so. ");
INSERT INTO twiasante_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ɔfirii saa asase no so trɛɛ nʼahennie mu kɔɔ Asiria, kɔkyekyeree Ninewe. Rehobot-Ir, Kala ne ");
INSERT INTO twiasante_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resen a ɛda Ninewe ne Kala ntam; ɛno na ɛyɛ kuro kɛseɛ wɔ saa ahemman no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Na Misraim woo Ludfoɔ, Anamfoɔ, Lehabfoɔ, Naftuhfoɔ, ");
INSERT INTO twiasante_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusfoɔ, Kasluhfoɔ ne Kaftorfoɔ a wɔyɛ Filistifoɔ agyanom. ");
INSERT INTO twiasante_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Na Kanaan woo nʼabakan Sidon ne Het. ");
INSERT INTO twiasante_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusifoɔ, Amorifoɔ, Girgasifoɔ, ");
INSERT INTO twiasante_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hewifoɔ, Arkifoɔ, Sinifoɔ, ");
INSERT INTO twiasante_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwadfoɔ, Semarifoɔ ne Hamatifoɔ. Akyire yi, Kanaanfoɔ mmusua no peteeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaan nsase ahyeɛ trɛ firii Sidon kɔduruu Gerar de kɔsii Gasa kɔduruu Sodom ne Gomora, Adma, Seboim de kɔsi Lasa. ");
INSERT INTO twiasante_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Yeinom ne Ham asefoɔ a wɔn mmusuakuo, wɔn kasa, wɔn nsase ne wɔn aman da wɔn adi. ");
INSERT INTO twiasante_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem a na ne nua panin ne Yafet no nso woo mmammarima. Sem nananom ne Eber mma. ");
INSERT INTO twiasante_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem asefoɔ nie: Elam, Asur, Arfaksad, Lud ne Aram. ");
INSERT INTO twiasante_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram asefoɔ nie: Us, Hul, Geter ne Mas. ");
INSERT INTO twiasante_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Na Arfaksad woo Sela, ɛnna Sela woo Eber. ");
INSERT INTO twiasante_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber woo mmammarima baanu. Abakan no din de Peleg a asekyerɛ ne “nkyekyɛmu” ɛfiri sɛ, ne berɛ so na nnipa a wɔwɔ ewiase mu kyekyɛ kɔɔ kasa ahodoɔ mu na wɔbɔ hweteeɛ. Nʼakyiri ba no din de Yoktan. ");
INSERT INTO twiasante_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan woo Almodada, Selef, Hasarmawet, Yera, ");
INSERT INTO twiasante_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO twiasante_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO twiasante_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila ne Yobab. ");
INSERT INTO twiasante_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Asase a wɔte so no trɛ firi Mesa kɔsi Sefar, ɔmantam a ɛda bepɔ so wɔ apueeɛ fam no. ");
INSERT INTO twiasante_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Yeinom ne Sem mmammarima, sɛdeɛ wɔn mmusua ne wɔn kasa, wɔn nsase ne wɔn amanaman te no. ");
INSERT INTO twiasante_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Yeinom ne Noa mmammarima mmusua, sɛdeɛ wɔn awoɔ ntoatoasoɔ te wɔ wɔn amanaman mu. Na ɛfiri yeinom mu na nsuyire no akyiri amanaman petee asase so. ");
INSERT INTO twiasante_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ɛberɛ bi, na nnipa a wɔwɔ asase so nyinaa ka kasa korɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Saa nnipa yi tu baa apueeɛ fam no, wɔbɛtoo asase tamaa wɔ Babilonia asase so, na wɔtenaa hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wɔdwennwenee ho sɛ, “Momma yɛntwa ntayaa na yɛnto mma ɛmmen yie.” Wɔde ntayaa no sii aboɔ anan na wɔde ama hyehyɛɛ ntam. ");
INSERT INTO twiasante_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Afei, wɔdwennwenee ho bio sɛ, “Momma yɛnkyekyere kuro kɛseɛ, na yɛnsi abantenten a ne sorɔnsorɔmmea duru sorosoro wɔ kuro no mu, na yɛnnye edin, na yɛanhwete wɔ asase so.” ");
INSERT INTO twiasante_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Awurade siane firii soro baa fam, bɛhunuu kuro kɛseɛ a wɔrekyekyere no ne abantenten a wɔresi no. ");
INSERT INTO twiasante_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Afei, Awurade kaa sɛ, “Sɛ nnipa korɔ a wɔka kasa baako afiti aseɛ redi saa dwuma yi a, ɛnneɛ biribiara a wɔbɔ wɔn tirim sɛ wɔbɛyɛ no renyɛ wɔn den. ");
INSERT INTO twiasante_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mommra na yɛnkɔ asase so, na yɛnkɔtoto wɔn kasa, na obiara nya ne kasa, sɛdeɛ obiara nte ne yɔnko kasa.” ");
INSERT INTO twiasante_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ɛnam yei so maa Awurade hwetee nnipa no nyinaa mu, ma wɔpetee asase so nyinaa, ma wɔgyaee kuro kɛseɛ no kyekyere. ");
INSERT INTO twiasante_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ɛno enti na wɔfrɛɛ kuro kɛseɛ no Babel, ɛfiri sɛ, ɛhɔ na Awurade totoo kasa baako a na wɔka wɔ ewiase nyinaa saa ɛberɛ no, maa wɔn kasa hodoɔ. Ɛfiri hɔ na Awurade hwetee nnipa no nyinaa mu, ma wɔpetee asase so nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Yei ne Sem asefoɔ ho asɛm. Nsuyire no akyiri, mfeɛ mmienu no a na Sem adi mfeɛ ɔha no, ɔwoo Arfaksad. ");
INSERT INTO twiasante_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sem woo Arfaksad akyiri no, ɔtenaa ase mfeɛ aha enum, wowoo mmammarima ne mmammaa bi nso kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaksad nso dii mfeɛ aduasa enum no, ɔwoo Sela. ");
INSERT INTO twiasante_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arfaksad woo Sela no, akyire yi, ɔtenaa ase mfeɛ ahanan ne mmiɛnsa, wowoo mmammarima ne mmammaa bi nso kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela dii mfeɛ aduasa no, ɔwoo Eber. ");
INSERT INTO twiasante_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sela woo Eber no, akyire yi, ɔtenaa ase mfeɛ ahanan ne mmiɛnsa, wowoo mmammarima ne mmammaa bi nso kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber dii mfeɛ aduasa ɛnan no, ɔwoo Peleg. ");
INSERT INTO twiasante_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber woo Peleg no, akyire yi, ɔtenaa ase mfeɛ ahanan ne aduasa, wowoo mmammarima ne mmammaa bi nso kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg dii mfeɛ aduasa no, ɔwoo Reu. ");
INSERT INTO twiasante_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg woo Reu no, akyire yi, ɔtenaa ase mfeɛ ahanu ne nkron, wowoo mmammarima ne mmammaa bi nso kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu dii mfeɛ aduasa mmienu no, ɔwoo Serug. ");
INSERT INTO twiasante_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu woo Serug no, akyire yi, ɔtenaa ase mfeɛ ahanu ne nson, wowoo mmammarima ne mmammaa bi nso kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug dii mfeɛ aduasa no, ɔwoo Nahor. ");
INSERT INTO twiasante_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug woo Nahor no, akyire yi, ɔtenaa ase mfeɛ ahanu wowoo mmammarima ne mmammaa bi nso kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor dii mfeɛ aduonu nkron no, ɔwoo Tera. ");
INSERT INTO twiasante_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor woo Tera no, akyire yi, ɔtenaa ase mfeɛ ɔha ne dunkron, wowoo mmammarima ne mmammaa bi nso kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera dii mfeɛ aduɔson no, ɔwoo Abram, Nahor ne Haran. ");
INSERT INTO twiasante_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Yei ne Tera asefoɔ ho asɛm. Tera woo Abram, Nahor ne Haran. Na Haran woo Lot. ");
INSERT INTO twiasante_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ɛberɛ a Haran agya Tera te ase no, Haran wuu baabi a wɔwoo no a wɔfrɛ hɔ Ur a, ɛwɔ Kaldea asase so no. ");
INSERT INTO twiasante_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram ne Nahor warewareeɛ. Na Abram yere din de Sarai, na Nahor nso yere din de Milka a, na ɔyɛ Haran babaa. Saa Haran yi na ɔwowoo Milka ne Iska. ");
INSERT INTO twiasante_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Na Sarai yɛ obonini; na ɔnni ba. ");
INSERT INTO twiasante_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera faa ne babarima Abram ne ne nana Lot, a ɔyɛ Haran babarima ne nʼase baa Sarai, a na ɔyɛ ne babarima Abram yere no, ne wɔn nyinaa siim firii Ur a ɛwɔ Kaldea asase so sɛ, wɔrekɔ Kanaan asase so. Na wɔduruu Haran no, wɔtenaa hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera dii mfeɛ ahanu ne enum, na ɔwuu wɔ Haran. ");
INSERT INTO twiasante_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Awurade Onyankopɔn ka kyerɛɛ Abram sɛ, “Gya wo ɔman, wo nkurɔfoɔ ne wo agya fiefoɔ, na kɔ asase a mɛkyerɛ wo no so. ");
INSERT INTO twiasante_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Mɛma wo ayɛ ɔman kɛseɛ, na mɛhyira wo. Mɛma wo din atrɛ, na woayɛ nhyira ama nnipa bebree. ");
INSERT INTO twiasante_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mɛhyira wɔn a wɔhyira wo, na obiara a ɔdome wo no, mɛdome no. Ɛnam wo so na wɔbɛhyira nnipa a wɔwɔ asase so nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Enti, Abram kɔeɛ, sɛdeɛ Awurade Onyankopɔn ka kyerɛɛ no no. Na Lot ne no kɔeɛ. Ɛberɛ a Abram refiri Haran asase so akɔ no, na wadi mfeɛ aduɔson enum. ");
INSERT INTO twiasante_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Na Abram faa ne yere Sarai ne ne nuabarima Haran babarima Lot, nʼagyapadeɛ ne nʼasomfoɔ a ɔnyaa wɔn wɔ Haran nyinaa, siim kɔɔ Kanaan asase so. ");
INSERT INTO twiasante_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Wɔfaa asase no so ara kɔsii baabi a wɔfrɛ hɔ Sekem, kɔduruu odum dua bi a ɛsi baabi a wɔfrɛ hɔ More. Ɛhɔ na wɔsii wɔn ntomadan. Saa ɛberɛ no, na Kanaanfoɔ na wɔte asase no so. ");
INSERT INTO twiasante_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Afei, Awurade Onyankopɔn yii ne ho adi kyerɛɛ Abram ka kyerɛɛ no sɛ, “Mede saa asase yi bɛma wʼaseni.” Enti, Abram sii afɔrebukyia wɔ hɔ, de kaee Awurade Onyankopɔn a ɔdaa ne ho adi kyerɛɛ no no. ");
INSERT INTO twiasante_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Akyire yi, Abram firii hɔ, de nʼani kyerɛɛ mmepɔ bi a ɛwɔ apueeɛ fam, sii ne ntomadan wɔ hɔ. Na Bet-El da atɔeɛ fam, na Ai nso da apueeɛ fam. Ɛhɔ na ɔsii afɔrebukyia maa Awurade Onyankopɔn, sɔree no wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Afei, Abram dii atutena ara, kɔɔ anafoɔ fam. ");
INSERT INTO twiasante_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Saa ɛberɛ no, ɛkɔm kɛseɛ bi sii asase a na Abram te so no so. Enti, ɔtu kɔtenaa Misraim asase so kakra, ɛfiri sɛ, ɛkɔm a ɛbaa asase no so no, na ano yɛ den yie. ");
INSERT INTO twiasante_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ɔreyɛ aduru Misraim asase so no, ɔka kyerɛɛ ne yere Sarai sɛ, “Menim sɛ woyɛ ɔbaa a wo ho yɛ fɛ yie. ");
INSERT INTO twiasante_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Sɛ Misraimfoɔ no hunu wo a, wɔbɛka sɛ, ‘Ne yere nie. Momma yɛnkum no, na yɛmfa no.’ ");
INSERT INTO twiasante_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Na sɛ woka sɛ woyɛ me nuabaa a, Misraimfoɔ no bɛhwɛ me yie, ɛfiri sɛ, wɔn ani wɔ wo ho, ɛno enti, wɔrenkum me.” ");
INSERT INTO twiasante_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ɛberɛ a wɔduruu Misraim asase so no, Misraimfoɔ no hunuu sɛ, ɔbaa no ho yɛ fɛ yie. ");
INSERT INTO twiasante_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Na ɔhene Farao mpanimfoɔ hunuu no no, wɔkamfoo nʼahoɔfɛ, kɔbɔɔ no amaneɛ. Enti, ɔhene Farao soma ma wɔkɔfaa ɔbaa no baa nʼahemfie hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Esiane ɔbaa no ahoɔfɛ enti, ɔhene Farao hwɛɛ Abram yie, maa no nnwan, anantwie, afunumunini ne afunumubereɛ, nkoa, mfenaa ne nyoma. ");
INSERT INTO twiasante_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Na ɛsiane Abram yere Sarai te a na ɔte Farao ahemfie hɔ no enti, Awurade Onyankopɔn maa ɔyaredɔm baa Farao ne ne fiefoɔ so. ");
INSERT INTO twiasante_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Yei enti, Farao frɛɛ Abram bisaa no sɛ, “Ɛdeɛn na woayɛ me yi? Adɛn enti na woanka ankyerɛ me sɛ, ɔbaa no yɛ wo yere? ");
INSERT INTO twiasante_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Adɛn enti na wokaa sɛ, ‘Ɔyɛ me nuabaa’ na woama maware no? Sɛ saa na ɛteɛ deɛ a, gye wo yere. Wo yere nie! Fa wʼadeɛ kɔ!” ");
INSERT INTO twiasante_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Na Farao hyɛɛ asraafoɔ sɛ, wɔnkɔgya Abram ne ne yere ɛkwan a wɔn fiefoɔ ne wɔn agyapadeɛ nyinaa ka ho. ");
INSERT INTO twiasante_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram tu firii Misraim. Ɔno, ne yere, Lot, nʼagyapadeɛ ne ne fiefoɔ nyinaa baa Negeb. ");
INSERT INTO twiasante_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Saa ɛberɛ no na Abram anya ne ho a ɔwɔ nyɛmmoa, dwetɛ ne sikakɔkɔɔ pii. ");
INSERT INTO twiasante_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ɔfirii Negeb hɔ no, ɔdii atutena ara kɔduruu Bet-El, baabi a ɔdii ɛkan sii ne ntomadan a ɛwɔ Bet-El ne Ai ntam no. ");
INSERT INTO twiasante_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ɛhɔ na kane no ɔsii nʼafɔrebukyia. Ɛhɔ nso na ɔkɔɔ so somm Awurade. ");
INSERT INTO twiasante_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Na Lot a ɔne Abram nam no nso yɛ ɔdefoɔ a ɔwɔ nnwan, anantwie ne asomfoɔ bebree. ");
INSERT INTO twiasante_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Esiane sɛ saa ɛberɛ no na Abram ne Lot nyinaa anya wɔn ho, na wɔwɔ nnwan, anantwie ne asomfoɔ pii enti, na wɔnsene asase no so. ");
INSERT INTO twiasante_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Na akasakasa taa baa Abram mmoahwɛfoɔ ne Lot mmoahwɛfoɔ no ntam. Saa ɛberɛ no na Kanaanfoɔ ne Perisifoɔ nso tete asase no so. ");
INSERT INTO twiasante_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Enti, Abram ka kyerɛɛ Lot sɛ, “Mesrɛ wo, mma akasakasa mma me ne wo anaa me mmoahwɛfoɔ ne wo mmoahwɛfoɔ ntam, ɛfiri sɛ, yɛyɛ anuanom. ");
INSERT INTO twiasante_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ɛnyɛ asase no nyinaa na ɛda wʼanim yi? Ma yɛnni mpaapaemu. Sɛ wokɔ benkum a, mɛkɔ nifa, na sɛ wokɔ nifa nso a, mɛkɔ benkum.” ");
INSERT INTO twiasante_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot hwɛɛ ne ho hyiaeɛ, hunuu sɛ asase a ɛda Yordan ho no yɛ asasebereɛ. Na nsuo wɔ mu baabiara te sɛ Eden turom anaasɛ Misraim asase a ɛda Soar fam hɔ no ara pɛ. Saa ɛberɛ no, na Awurade nnya nsɛee Sodom ne Gomora. ");
INSERT INTO twiasante_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Na Lot de nʼani kyerɛɛ apueeɛ fam, faa asase a ɛda Yordan ho no. Yei ne ɛkwan a Abram ne Lot faa so dii ntetemu no. ");
INSERT INTO twiasante_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram tenaa Kanaan asase so. Ɛnna Lot nso dii atutena wɔ nkuropɔn a ɛwowɔ nsase tamaa no so, na ɔkɔsii ne ntomadan wɔ baabi a ɛbɛn Sodom. ");
INSERT INTO twiasante_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Na nnipa a wɔwɔ Sodom kuro no mu no yɛ amumuyɛfoɔ a daa wɔyɛ bɔne akɛseakɛseɛ de tia Awurade. ");
INSERT INTO twiasante_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot tee ne ho firii Abram ho akyiri no, Awurade ka kyerɛɛ Abram sɛ, “Afei, ma wʼani so hwɛ atifi fam, anafoɔ fam, apueeɛ fam ne atɔeɛ fam. ");
INSERT INTO twiasante_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Mede asasetam a wʼani tua yi nyinaa bɛma wo ne wʼasefoɔ afebɔɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mɛma wʼasefoɔ adɔɔso sɛ asase so mfuturo a obiara ntumi nkan. ");
INSERT INTO twiasante_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Sɔre, kɔ na kɔhwehwɛ asase no so nyinaa, ɛfiri sɛ, mede rema wo.” ");
INSERT INTO twiasante_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Enti, Abram tutuu ne ntomadan bɛtenaa odum kwaeɛ bi a ɛyɛ Mamrɛ dea wɔ Hebron. Ɛhɔ na ɔsii afɔrebukyia maa Awurade. ");
INSERT INTO twiasante_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Na ɛbaa sɛ Babiloniahene Amrafel, Elasarhene Ariok, Elamhene Kedorlaomer, Goiimhene Tideal berɛ so, ");
INSERT INTO twiasante_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","na saa ahemfo yi ne Sodomhene Birsa, Gomorahene Birsa, Admahene Sinab, Seboimhene Semeber ne Belahene a na wɔfrɛ no Soar no dii ako. ");
INSERT INTO twiasante_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Saa ahemfo yi a ɛyɛ Sodomhene, Gomorahene, Admahene, Seboimhene ne Belahene boaboaa wɔn akodɔm ano wɔ Sidim subɔnhwa a ɛno ne Nkyene Ɛpo no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Wɔsomm Kedorlaomer mfeɛ dumienu, na afe a ɛtɔ so dumiɛnsa mu no, wɔtee atua. ");
INSERT INTO twiasante_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Afe akyiri no, Kedorlaomer ne ahemfo a wɔbɛkaa ne ho no tuu ɔsa. Na wɔko dii saa nnipa yi so nkonim: Refaimfoɔ, a wɔwɔ Asterot-Karnaim ne Susifoɔ a wɔwɔ Ham ne Emifoɔ a wɔwɔ Kiriataim ");
INSERT INTO twiasante_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ne Horifoɔ a wɔwɔ bepɔ Seir so de kɔsi El-Paran a ɛda ɛserɛ ano no. ");
INSERT INTO twiasante_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Afei, wɔsane wɔn akyiri baa En-Mispat a, akyire no, wɔfrɛɛ no Kades bɛkunkumm Amalekfoɔ ne Amorifoɔ nso a na wɔte Hasason-Tamar, sɛee wɔn ɔman no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Afei, saa ahemfo baanum yi a wɔn ne Sodomhene, Gomorahene, Admahene, Seboimhene ne Belahene a akyire yi, wɔfrɛ no Soar no kɔɔ ");
INSERT INTO twiasante_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","saa ahemfo baanan yi a wɔn ne Elamhene Kedorlaomer, Goiimhene Tideal, Sinearhene Amrafel ne Elasarhene Ariok nkyɛn. Wɔkɔhyiaa wɔ Sidim subɔnhwa mu. ");
INSERT INTO twiasante_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Na nkomena pii wɔ Sidim Bɔnhwa no mu a wɔatu ama wɔ hɔ pɛn. Enti, ɛbaa sɛ Sodomhene ne Gomorahene akodɔm no redwane no, wɔn mu bi kɔtotɔɔ nkomena no mu, na nkaeɛ no nso dwane kɔɔ mmepɔ a na ɛwɔ hɔ no so. ");
INSERT INTO twiasante_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ahemfo baanan a wɔdii nkonim no fom Sodom ne Gomorafoɔ ahodeɛ ne wɔn nnuane nyinaa de kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Esiane sɛ na Abram nuabarima ba Lot te Sodom asase so no enti, nkonimdifoɔ no faa ɔno ne nʼagyapadeɛ nyinaa kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Na Sodom ne Gomora adwanefoɔ no mu baako bɛbɔɔ Hebrini Abram ɔko no mu amaneɛ. Saa ɛberɛ no, na Abram abɔ ne ho atenaseɛ wɔ odum kwaeɛ bi a ɛyɛ Amorini Mamrɛ dea no ase. Mamrɛ yi nso, na ne nuanom ne Eskol ne Aner a na wɔyɛ Abram aboafoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ɛberɛ a Abram tee sɛ wɔafa ne busuani Lot dommum no, ɔboaboaa ne fiefoɔ nnipa ahasa ne dunwɔtwe a wɔatete wɔn sɛ akofoɔ ano, ma wɔtii atamfoɔ no, kɔsii kuro bi a wɔfrɛ no Dan mu. ");
INSERT INTO twiasante_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ɛda no anadwo, Abram kyekyɛɛ nʼakodɔm no mu, ma wɔto hyɛɛ atamfoɔ no so, kunkumm wɔn, taa wɔn kɔduruu kuro bi a wɔfrɛ no Hoba a ɛwɔ Damasko atifi fam no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram gyee ɔko mu nneɛma a wɔfaeɛ no nyinaa faa ne busuani Lot ne nʼagyapadeɛ ne mmaa ne nnipa foforɔ a wɔkyekyee wɔn no nyinaa sane baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram kɔdii Kedorlaomer ne ahemfo a na wɔka ne ho no so nkonim akyiri no, Sodomhene bɛhyiaa no wɔ Sawe bɔnhwa a ɛno ara na wɔfrɛ no Ɔhene Bɔnhwa no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Na Salemhene Melkisedek a na ɔyɛ Ɔsorosoro Awurade Onyankopɔn ɔsɔfoɔ no de burodo ne nsã brɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Afei, Melkisedek hyiraa Abram sɛ: “Ɔsorosoro Onyankopɔn a ɔbɔɔ soro ne asase, nhyira nka wo, Abram. ");
INSERT INTO twiasante_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Na nhyira nka Ɔsorosoro Onyankopɔn, a ɔde wʼatamfoɔ ahyɛ wo nsam no.” Na Abram maa Melkisedek nneɛma a ne nsa kaeɛ no nyinaa mu biara nkyekyɛmu edu mu baako. ");
INSERT INTO twiasante_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Afei, Sodomhene ka kyerɛɛ Abram sɛ, “Fa me nnipa a wofaa wɔn no ma me kɛkɛ, na wo nso, fa nneɛma a aka no nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Nanso, Abram ka kyerɛɛ Sodomhene sɛ, “Madi nse aka ntam akyerɛ Ɔsorosoro Onyankopɔn, ɔsoro ne asase yɛfoɔ sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Merennye biribiara, sɛ ɛyɛ asaawa ahoma baako anaa mpaboa so ahoma mpo, mfiri wo nkyɛn, na woanka da sɛ, ‘Me na memaa Abram nyaa ne ho.’ ");
INSERT INTO twiasante_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Merennye hwee mfiri wo nkyɛn, gye deɛ me mmarima yi adi nko. Me nkurɔfoɔ Aner, Eskol ne Mamrɛ deɛ, ma wɔn wɔn kyɛfa.” ");
INSERT INTO twiasante_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Yeinom akyiri no, Awurade kasa kyerɛɛ Abram wɔ anisoadehunu mu sɛ, “Abram, nsuro. Meyɛ wo kyɛm. Meyɛ wo kyɛfa a ɛsom bo.” ");
INSERT INTO twiasante_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram nso buaa sɛ, “Ao, Awurade Onyankopɔn, ɛdeɛn na wode bɛma me wɔ ɛberɛ a menni ɔba. Onipa a ɔbɛdi mʼadeɛ no yɛ Damaskoni Elieser?” ");
INSERT INTO twiasante_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Na Abram toaa so sɛ, “Wommaa me mma enti, akoa a wɔwoo no wɔ me fie no na ɔbɛdi mʼadeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ɛnna Awurade ka kyerɛɛ Abram sɛ, “Saa ɔbarima yi renni wʼadeɛ da, agye wʼankasa wo yafumma.” ");
INSERT INTO twiasante_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Onyankopɔn de Abram kɔɔ afikyire, na ɔka kyerɛɛ no sɛ, “Pagya wʼani hwɛ soro na hwɛ sɛ wobɛtumi akan ɔsoro nsoromma anaa.” Afei, Onyankopɔn ka kyerɛɛ Abram sɛ, “Saa ara na wʼasefoɔ bɛdɔɔso.” ");
INSERT INTO twiasante_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram gyee asɛm a Awurade kaeɛ no diiɛ. Ne saa enti, Awurade buu no onipa tenenee. ");
INSERT INTO twiasante_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Awurade Onyankopɔn kyerɛɛ Abram bio sɛ, “Mene Awurade a mede wo firi Ur a ɛwɔ Kaldeafoɔ asase so baeɛ sɛ mede saa asase yi rema wo sɛ wʼagyapadeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Nanso, Abram kaa sɛ, “Ao, Ɔsorosoro Awurade, ɛbɛyɛ sɛn na mɛhunu sɛ, asase no bɛyɛ me dea?” ");
INSERT INTO twiasante_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Awurade ka kyerɛɛ Abram sɛ, “Fa nantwie ba a wadi mfeɛ mmiɛnsa, abirekyibereɛ a wadi mfeɛ mmiɛnsa, odwennini a wadi mfeɛ mmiɛnsa, anyankuku ne aborɔnoma ba brɛ me.” ");
INSERT INTO twiasante_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram de yeinom nyinaa brɛɛ Onyankopɔn, paapae wɔn mu mmienu, na ɔde afaafa no kyerɛkyerɛɛ animu, de guguu hɔ. Na nnomaa no deɛ, wampaapae wɔn mu. ");
INSERT INTO twiasante_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Na apete bɛsisii mmoa no afunu so no, Abram pamoo wɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ɛberɛ a owia rekɔtɔ no, Abram daa hatee, na esum kabii a ɛyɛ hu tɔɔ ne so. ");
INSERT INTO twiasante_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Afei, Awurade ka kyerɛɛ Abram sɛ, “Gye di sɛ wʼasefoɔ bɛyɛ ahɔhoɔ wɔ asase a ɛnyɛ wɔn dea so. Wɔbɛyɛ nkoa wɔ ɔman no mu, asom, na wɔayɛ wɔn ayayadeɛ mfeɛ ahanan. ");
INSERT INTO twiasante_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Nanso, mɛtwe saa ɔman a wʼasefoɔ bɛsom wɔn no aso, na ɛno akyiri no, wɔbɛfiri ɔman a wɔsom mu no mu aba sɛ adefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Wo deɛ, wobɛwu asomdwoeɛ mu. Wobɛnyini akyɛre yie ansa na woawu. ");
INSERT INTO twiasante_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nanso, awoɔ ntoatoasoɔ a ɛtɔ so ɛnan no mu, wʼasefoɔ bɛsane aba saa ɔman yi mu bio. Ɛfiri sɛ, saa ɛberɛ yi, Amorifoɔ a wɔte saa asase yi so ɛnnɛ yi bɔne a wɔyɛ no nnya nnuruu deɛ wɔtwe wɔn aso ma ɛyɛ yie.” ");
INSERT INTO twiasante_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Na ɛbaa sɛ owia kɔtɔeɛ, na esum duruiɛ no, Abram hunuu egyakukuo bi sɛ ɛrefiri wisie ne ogyatɛn a ɛrederɛ bɛfaa mmoa a wɔakum wɔn no afunu afaafa no ntam. ");
INSERT INTO twiasante_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Saa ɛda no ara, Awurade ne Abram yɛɛ apam, kaa sɛ, “Mede saa asase a ɛfiri Misraim asubɔnten no ho, de kɔsi asubɔnten kɛseɛ Eufrate ho bɛma wo ne wʼasefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Saa ara nso na mede Kenifoɔ, Kenesifoɔ, Kadmonifoɔ, ");
INSERT INTO twiasante_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hetifoɔ, Perisifoɔ, Refaimfoɔ, ");
INSERT INTO twiasante_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorifoɔ, Kanaanfoɔ, Girgasifoɔ ne Yebusifoɔ nsase nyinaa bɛma wo ne wʼasefoɔ no.” ");
INSERT INTO twiasante_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saa ɛberɛ yi, na Sarai nwoo ɔba mmaa Abram. Na ɔwɔ Misraimni abaawa bi a wɔfrɛ no Hagar; ");
INSERT INTO twiasante_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","enti Sarai ka kyerɛɛ Abram sɛ, “Wo ara wonim sɛ Awurade ama mayɛ obonini; manwo ɔba! Mesrɛ wo, kɔ na wo ne mʼabaawa Hagar nkɔda; ebia ɛnam ne so na manya mma.” Abram penee asɛm a Sarai ka kyerɛɛ no no so. ");
INSERT INTO twiasante_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abram tenaa Kanaan asase so mfeɛ edu akyiri no, ne yere Sarai de Misraimni abaawa Hagar no kɔmaa ne kunu no sɛ, ɔnware no. ");
INSERT INTO twiasante_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram ne Hagar daeɛ, na ɔnyinsɛneeɛ. Ɛberɛ a Hagar hunuu sɛ wanyinsɛn no, ɔhyɛɛ aseɛ buu nʼawuraa Sarai animtia. ");
INSERT INTO twiasante_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Enti Sarai ka kyerɛɛ Abram sɛ, “Saa ɔhaw a aba me so yi nyinaa firi wo! Mede mʼabaawa maa wo; afei a wahunu sɛ wanyinsɛn no enti, ɔtiatia mʼanim. Awurade mmu me ne wo ntam atɛn.” ");
INSERT INTO twiasante_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Nanso, Abram ka kyerɛɛ Sarai sɛ, “Ɔyɛ wʼabaawa. Deɛ wopɛ sɛ wode yɛ no biara, fa yɛ no.” Ɛfiri saa ɛberɛ no, Sarai tanee nʼabaawa Hagar ani, ma ɔdwane firii ne nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Awurade ɔbɔfoɔ hunuu Hagar wɔ nsuo aniwa bi ho wɔ ɛserɛ no so. Na saa nsuo aniwa no da ɛkwan a ɛkɔ kuro bi a wɔfrɛ no Sur no nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ɔbɔfoɔ no bisaa Hagar sɛ, “Sarai abaawa Hagar, wofiri he, na worekɔ he?” Hagar buaa no sɛ, “Meredwane afiri mʼawuraa Sarai nkyɛn.” ");
INSERT INTO twiasante_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Na Awurade ɔbɔfoɔ no ka kyerɛɛ Hagar sɛ, “Sane kɔ wʼawuraa no nkyɛn, na kɔbrɛ wo ho ase ma no.” ");
INSERT INTO twiasante_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ɔbɔfoɔ no ka kaa ho sɛ, “Mɛma wʼase afɛe a, wɔkan a, ɛnyɛ yie.” ");
INSERT INTO twiasante_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Awurade ɔbɔfoɔ no sane ka kyerɛɛ Hagar sɛ, “Woanyinsɛn, na wobɛwo ɔbabarima. Wobɛto no edin Ismael, ɛfiri sɛ, Awurade ate wʼamanehunu. ");
INSERT INTO twiasante_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ɔbɛyɛ sɛ ɛserɛ so afunumu. Ɔbɛtia nnipa nyinaa, na nnipa nyinaa nso bɛtia no; atutupɛ so na ɔne ne nuanom bɛtena.” ");
INSERT INTO twiasante_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Yei akyiri ɔde edin foforɔ maa Awurade. Ɔkaa sɛ, “Mahunu Deɛ ɔhunu me.” Ɛno enti, ɔde edin El-Roi a aseɛ ne “Onyankopɔn a ɔhunu me” no, too no. ");
INSERT INTO twiasante_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ɛno enti na wɔfrɛ nsuo aniwa no sɛ Beer-Lahai-Roi a aseɛ ne “Onyankopɔn Teasefoɔ a ɔhunu me abura.” Ɛda Kades ne Bered ntam bɛsi ɛnnɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Enti Hagar woo ɔbabarima maa Abram. Abram too abɔfra no edin Ismael. ");
INSERT INTO twiasante_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hagar woo Ismael no, na Abram adi mfeɛ aduɔwɔtwe nsia. ");
INSERT INTO twiasante_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram dii mfeɛ aduɔkron nkron no, Awurade yii ne ho adi kyerɛɛ no kaa sɛ, “Mene Otumfoɔ Onyankopɔn, nante mʼanim na yɛ pɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mɛsi apam a ɛda me ne wo ntam no so dua, na mama wʼasefoɔ adɔɔso.” ");
INSERT INTO twiasante_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram de nʼanim butuu fam, na Onyankopɔn ka kyerɛɛ no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Me fa mu deɛ, saa apam yi na ɛda me ne wo ntam: wobɛyɛ aman bebree agya. ");
INSERT INTO twiasante_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Wɔremfrɛ wo Abram bio. Wɔbɛfrɛ wo Abraham, ɛfiri sɛ, mayɛ wo aman bebree agya. ");
INSERT INTO twiasante_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mɛma wʼasefoɔ adɔɔso. Wɔbɛyɛ amanaman bebree na ahemfo nso afiri wɔn mu. ");
INSERT INTO twiasante_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Mɛma mʼapam no ayɛ daapem apam a ɛbɛda me ne wo ne wʼasefoɔ ne awoɔ ntoatoasoɔ a ɛbɛba no ntam. Na mɛyɛ wo ne wʼasefoɔ Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Mede Kanaan asase a ɛnnɛ wote so sɛ ɔhɔhoɔ no nyinaa bɛma wo ne wʼasefoɔ a wɔbɛba akyire no nyinaa. Ɛbɛyɛ asase a ɛyɛ wʼagyapadeɛ afebɔɔ. Na mɛyɛ wɔn Onyankopɔn.” ");
INSERT INTO twiasante_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Afei, Onyankopɔn ka kyerɛɛ Abraham sɛ, “Wo deɛ, ɛsɛ sɛ wo ne wʼasefoɔ ne wʼasefoɔ a wɔbɛba akyire no di mʼapam no so. ");
INSERT INTO twiasante_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Yei ne mʼapam a ɛda me ne wo ntam a ɛsɛ sɛ wo ne wʼasefoɔ ne wʼasefoɔ a wɔbɛba akyire no di so. Ɛsɛ sɛ wɔtwa ɔbarima biara twetia. ");
INSERT INTO twiasante_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ɛsɛ sɛ motwa twetia. Ɛno na ɛbɛyɛ apam a ɛda me ne mo ntam no ho nsɛnkyerɛnneɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ɔbarima biara a ɔyɛ wʼaseni a wɔbɛwo no no, ɔdi nnawɔtwe pɛ a, ɛsɛ sɛ wɔtwa no twetia. Nkoa a wɔwoo wɔn wɔ wo fie ne ɔnanani biara a woyii sika tɔɔ no firii ɔmamfrani nkyɛn a ɔnyɛ wʼaseni no nso, ɛsɛ sɛ wɔtwa no twetia saa ara. ");
INSERT INTO twiasante_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Sɛ wɔwoo no wo fie oo, sɛ nso, wokarii sika kɔtɔɔ no oo, ɛsɛ sɛ wɔtwa no twetia. Saa honam mu apam yi bɛyɛ daapem apam. ");
INSERT INTO twiasante_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Wɔbɛpam ɔbarima biara a wɔntwaa no twetia no afiri ne nkurɔfoɔ mu, ɛfiri sɛ, saa onipa no anni mʼapam no so.” ");
INSERT INTO twiasante_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Onyankopɔn sane ka kyerɛɛ Abraham sɛ, “Ɛfa wo yere Sarai ho nso, ɛfiri ɛnnɛ rekɔ, woremfrɛ no Sarai bio. Wobɛfrɛ no Sara. ");
INSERT INTO twiasante_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mɛhyira no, na mɛma no awo ɔbabarima ama wo. Mɛhyira no ma wabɛyɛ aman nyinaa maame. Nʼasefoɔ mu na amanaman mu ahemfo bɛfiri.” ");
INSERT INTO twiasante_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham de nʼanim butuu fam bio. Ɔsere bisaa ne ho sɛ, “Ɛbɛtumi aba sɛ ɔbarima a wadi mfeɛ ɔha bɛwo ɔba anaa? Sara nso a wadi mfeɛ aduɔkron no nso, ɔbɛtumi awo ɔba anaa?” ");
INSERT INTO twiasante_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Na Abraham ka kyerɛɛ Onyankopɔn sɛ, “Ao, Onyankopɔn ɛnneɛ, hyira Ismael!” ");
INSERT INTO twiasante_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Na Onyankopɔn kaa sɛ, “Mmom, wo yere Sara bɛwo ɔbabarima ama wo, na wobɛto no edin Isak, a aseɛ ne Sereɛ. Me ne no bɛyɛ daapem apam a ɛbɛtena hɔ ama nʼasefoɔ a wɔbɛba akyire no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Na Ismael ho asɛm a wokaeɛ no nso, mate. Mɛhyira no ama nʼase adɔre bebree. Ɔbɛyɛ aberempɔn dumienu agya. Na mɛma no ayɛ ɔman kɛseɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Nanso, me ne Isak a Sara bɛwo no, afe sɛsɛɛ no, na ɛbɛyɛ mʼapam no.” ");
INSERT INTO twiasante_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Onyankopɔn kasa kyerɛɛ Abraham wieeɛ no, ɔgyaa no hɔ kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Saa ɛda no ara, Abraham faa ne babarima Ismael ne mmarima a wɔwoo wɔn wɔ ne fie ne mmarima a wɔtɔɔ wɔn firii ananafoɔ nkyɛn, twitwaa wɔn nyinaa twetia, sɛdeɛ Onyankopɔn ka kyerɛɛ no no. ");
INSERT INTO twiasante_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Wɔtwaa Abraham twetia no, na wadi mfeɛ aduɔkron nkron. ");
INSERT INTO twiasante_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ne babarima Ismael nso, wɔtwaa no twetia no, na wadi mfeɛ dumiɛnsa. ");
INSERT INTO twiasante_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Saa ɛda no ara, na wɔtwaa Abraham ne ne ba Ismael nyinaa twetia. ");
INSERT INTO twiasante_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ɔbarima biara a ɔwɔ Abraham fie, wɔn a wɔwoo wɔn wɔ Abraham fie ne ɔbarima biara a wɔtɔɔ no firii ɔnanani bi nkyɛn no, wɔtwitwaa wɔn nyinaa twetia, kaa Abraham ho. ");
INSERT INTO twiasante_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Awia ketee bi a Abraham te ne ntomadan a ɛwɔ Mamrɛ odum kwaeɛ ɛkwan ano no, Awurade yii ne ho adi bio kyerɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham maa nʼani so no, ɔhunuu sɛ mmarima baasa bi apue ne ntentenesoɔ. Ɔhunuu wɔn no, ɔtuu mmirika firii ne ntomadan no kwan ano kɔhyiaa wɔn, kotoo wɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Abraham kaa sɛ, “Me wura, sɛ manya adom wɔ wʼanim a, ntwa me a meyɛ wʼakoa ho nkɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Momma wɔmfa nsuo bi mmrɛ mo nhohoro mo nan ase, na monhome wɔ nnua yi ase kakra. ");
INSERT INTO twiasante_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Moaba mo akoa nkyɛn yi, momma mempɛ aduane kakra bi mma monka mo ano, na monnya ahoɔden nkɔ mo kwan.” Nnipa no penee so kaa sɛ, “Ɛyɛ, yɛ deɛ wopɛ sɛ woyɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Enti, Abraham de ahoɔherɛ kɔɔ ne yere Sara nkyɛn wɔ ntomadan no mu, ka kyerɛɛ no sɛ, “Ka wo ho fa asikyiresiam pa susukora mmiɛnsa, na fɔtɔ na fa to burodo.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Afei, Abraham yɛɛ ntɛm kɔɔ nʼanantwibuo no mu, kɔkyeree nantwie ba a ɔyɛ na wadɔre sradeɛ de no maa ne ɔsomfoɔ, ma ɔde ahoɔherɛ yɛɛ ne ho adwuma. ");
INSERT INTO twiasante_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Afei, ɔfaa nufosuo ani sradeɛ ne nufosuo ne nantwie ba a ɔde anoa aduane no, de too nnipa baasa no ɛpono. Ɛberɛ a nnipa no gu so redidie no, na ɔgyina wɔn nkyɛn wɔ nnua no ase. ");
INSERT INTO twiasante_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nnipa no bisaa Abraham sɛ, “Wo yere Sara wɔ he?” Abraham buaa wɔn sɛ, “Ɔwɔ ntomadan no mu.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Afei, Awurade kaa sɛ, “Deɛ ɛbɛyɛ biara, afe sɛsɛɛ mɛba wo nkyɛn, na mɛba no, na wo yere Sara awo ɔbabarima.” Saa ɛberɛ no, na Sara gyina ntomadan no ɛpono akyiri, retie nkɔmmɔ no. ");
INSERT INTO twiasante_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Na Abraham ne Sara nyinaa anyinyini yie a wɔn mfeɛ akɔ animu koraa enti, na Sara awoɔ apa ho. ");
INSERT INTO twiasante_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara tee asɛm no, ɔseree ne tirim, kaa sɛ, “Manya awie aberewabɔ, na me kunu nso abɔ akɔkoraa yi, ɛbɛyɛ sɛn na manya saa anigyedeɛ yi?” ");
INSERT INTO twiasante_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Enti, Awurade bisaa Abraham sɛ, “Adɛn enti na Sara sere bisaa sɛ, ‘Ampa ara sɛ manyini aduru seyie yi, mɛtumi awo ba?’ ");
INSERT INTO twiasante_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Biribi boro Awurade ahoɔden so sɛ ɔbɛyɛ? Afe sɛsɛɛ a mɛsane aba sɛdeɛ mahyɛ wo ho bɔ no, na wo yere Sara awo ɔbabarima.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Na Sara suro enti, ɔtwaa atorɔ sɛ, “Mansere.” Nanso, Onyankopɔn kaa sɛ, “Ɛyɛ nokorɛ turodoo sɛ wosereeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mmarima no kraa sɛ wɔrekɔ no, wɔde wɔn ani kyerɛɛ Sodom. Abraham kɔgyaa wɔn kwan. ");
INSERT INTO twiasante_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Afei, Awurade kaa sɛ, “Adeɛ a mabɔ me tirim sɛ mɛyɛ no, memfa nsie Abraham anaa? ");
INSERT INTO twiasante_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ɛyɛ nokorɛ turodoo sɛ Abraham bɛyɛ ɔman kɛseɛ a ɛwɔ tumi. Na ɛnam Abraham so na wɔbɛhyira amanaman a ɛwɔ asase so nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ɛfiri sɛ, mapa Abraham sɛ ɔbɛkyerɛkyerɛ ne mma ne ne fiefoɔ Awurade kwan. Na wɔayɛ ade pa ne ade tenenee a ɛsɔ Awurade ani. Sɛdeɛ ɛbɛyɛ a Awurade bɔ a ɔhyɛɛ Abraham no bɛba mu.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Afei, Awurade kaa sɛ, “Mate nnebɔne a ɛyɛ duru a ɛrekɔ so wɔ Sodom ne Gomora no. ");
INSERT INTO twiasante_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mɛkɔ hɔ makɔhwɛ sɛ, deɛ wɔyɛ no yɛ bɔne a ɛyɛ duru, sɛdeɛ mate no anaa. Sɛ ɛnte saa nso a, mɛhunu.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Na mmarima baasa no mu baanu danee wɔn ani kyerɛɛ Sodom. Nanso, Abraham deɛ, na ɔda so gyina Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Afei, Abraham twe bɛn Onyankopɔn bisaa no sɛ, “Wobɛsɛe nnipa tenenee ne nnipa bɔnefoɔ nyinaa afra anaa? ");
INSERT INTO twiasante_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Na sɛ nnipa tenenee aduonum wɔ kuro no mu a wobɛsɛe kuro no a worenhwɛ saa nnipa tenenee aduonum no ho nnyae kuro no sɛeɛ? ");
INSERT INTO twiasante_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ɛmpare wo sɛ wobɛyɛ saa, sɛ wobɛkum nnipa tenenee ne nnipa bɔnefoɔ afra, de asotwe korɔ no ara bɛma nnipa tenenee ne nnipa bɔnefoɔ. Ɛmpare wo! Deɛ ɔbu asase nyinaa atɛn no remmu atɛntenenee anaa?” ");
INSERT INTO twiasante_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Na Awurade kaa sɛ, “Sɛ mehunu nnipa tenenee aduonum wɔ Sodom kuro no mu a, wɔn enti, merensɛe kuro no.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Na Abraham bisaa sɛ, “Afei, me a meyɛ nsõ ne dɔteɛ a mensɛ hwee, nanso masi me bo ne Awurade akasa yi, ");
INSERT INTO twiasante_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","sɛ ɛba sɛ nnipa tenenee no dodoɔ yɛ aduanan enum nso ɛ? Esiane saa nnipa enum a wɔafiri nnipa tenenee aduonum no so ama aka nnipa tenenee aduanan enum no enti, wobɛsɛe kuro mu no nyinaa anaa?” Onyankopɔn buaa sɛ, “Sɛ mehunu nnipa tenenee aduanan enum wɔ kuro no mu a, merensɛe no.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham toaa nʼadebisa no so sɛ, “Sɛ ɛba sɛ, nnipa tenenee aduanan pɛ na wɔwɔ kuro no mu ɛ?” Na Awurade buaa Abraham sɛ, “Nnipa tenenee aduanan no enti, merensɛe kuro no.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham kɔɔ so srɛɛ bio sɛ, “Mesrɛ wo, Awurade, mma wo bo mfu me, ma menkasa. Sɛ ɛba sɛ nnipa tenenee aduasa na wɔwɔ kuro no mu nso ɛ?” Awurade buaa sɛ, “Sɛ mehunu nnipa tenenee aduasa a, merensɛe kuro no.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Afei, Abraham bisaa sɛ, “Masi me bo ne Awurade akasa yi, ɛba sɛ nnipa tenenee aduonu pɛ na wɔwɔ kuro no mu ɛ?” Onyankopɔn buaa sɛ, “Saa nnipa tenenee aduonu no enti, merensɛe kuro no.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham kɔɔ so bisaa sɛ, “Ao, Awurade, mma wo bo mfu me; ma memmisa mʼasɛm baako pɛ a ɛtwa toɔ. Sɛ ɛba sɛ, nnipa tenenee edu na wɔwɔ kuro no mu nso ɛ?” Awurade buaa sɛ, “Saa nnipa tenenee edu no enti, merensɛe kuro no.” ");
INSERT INTO twiasante_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ɛberɛ a Awurade ne Abraham kasa wieeɛ no, ɔgyaa Abraham hɔ kɔeɛ. Abraham nso sane kɔɔ nʼatenaeɛm. ");
INSERT INTO twiasante_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ɔsoro abɔfoɔ baanu no duruu Sodom anwummerɛ. Na Lot te kuro no ɛpono ano. Ɛberɛ a Lot hunuu sɛ wɔreba no, ɔsɔre kɔhyiaa wɔn ɛkwan. Ɔbuu nkotodwe, de nʼanim butuu fam, nam so maa wɔn akwaaba. ");
INSERT INTO twiasante_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ɔkaa sɛ, “Me wuranom, mesrɛ mo, mommɛsoɛ mo akoa fie, na memma mo nsuo nhohoro mo nan ho, na monna, na ɔkyena anɔpatutuutu, moatoa mo akwantuo no so.” Nanso, abɔfoɔ no buaa sɛ, “Dabi, mmom, yɛbɛda adwabɔeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Nanso, Lot kɔɔ so srɛɛ wɔn anibereɛ so enti, wɔne no kɔɔ ne fie. Ɔtoo burodo a wamfa mmɔreka amfra ɛda no ara, de too wɔn ɛpono, ma wɔdiiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ansa na wɔbɛkɔ akɔda no, Sodomfoɔ mpanin ne mmɔfra nyinaa firi kuro no afanan bɛtwaa efie no ho hyiaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Wɔteateaam frɛɛ Lot bisaa no sɛ, “Mmarima a wɔbaa wo nkyɛn anadwo yi wɔ he? Fa wɔn brɛ yɛn, na yɛne wɔn nkɔda.” ");
INSERT INTO twiasante_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot firii adi, too ne ɛpono mu, kɔhyiaa Sodom mmarima no. ");
INSERT INTO twiasante_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ɔka kyerɛɛ wɔn sɛ, “Me nuanom, mesrɛ mo, monnyɛ amumuyɛsɛm a ɛte saa. ");
INSERT INTO twiasante_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Montie! Mewɔ mmammaa baanu a wɔnhunuu mmarima da. Momma memfa wɔn mmrɛ mo, na deɛ mopɛ biara, moayɛ wɔn. Na saa mmarima baanu yi deɛ, mommfa mo nsa nka wɔn, ɛfiri sɛ, wɔaba me suhyɛ banbɔ mu.” ");
INSERT INTO twiasante_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ɛdɔm no teateaam sɛ, “Twe wo ho! Woyɛ hwan? Yɛn na yɛama wo baabi atena wɔ ha, na afei deɛ worebɛkyerɛ yɛn deɛ yɛnyɛ. Yɛne wo bɛdi no anibereɛ so asene nkurɔfoɔ no.” Ɛdɔm no twi faa Lot so, na wɔhyɛɛ aseɛ bubuu apono no. ");
INSERT INTO twiasante_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Nanso, ɔsoro abɔfoɔ baanu a wɔhyɛ efie hɔ no pue bɛtwee Lot kɔhyɛɛ efie hɔ, too ɛpono no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ɔsoro abɔfoɔ baanu no maa mpanin ne mmɔfra a wɔgyinagyina ɛpono no akyiri no ani firafiraeɛ enti, wɔanhunu ɛpono no koraa. ");
INSERT INTO twiasante_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Afei, ɔsoro abɔfoɔ baanu no bisaa Lot sɛ, “Wowɔ abusuafoɔ bi wɔ kurom ha sɛ ɛyɛ wo nsenom, wo mmammaa, wo mmammarima anaa obi foforɔ bi a ɔyɛ wo ho onipa? Yi wɔn nyinaa firi ha, ");
INSERT INTO twiasante_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ɛfiri sɛ, yɛrebɛsɛe saa kuro yi pasaa. Amumuyɛsɛm a ɛtia nnipa yi a aduru Awurade anim no ano den enti, wasoma yɛn sɛ yɛmmɛsɛe kuro yi.” ");
INSERT INTO twiasante_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Enti, Lot firii adi, kɔbɔɔ mmarima bi a wɔahyɛ bɔ sɛ wɔbɛwareware ne mmammaa no amaneɛ. Ɔka kyerɛɛ wɔn sɛ, “Monyɛ no ntɛm, na momfiri kuro yi mu, ɛfiri sɛ, Awurade Onyankopɔn rebɛsɛe kuro yi!” Nanso, na saa mmarima yi susu sɛ ɔredi fɛ bi. ");
INSERT INTO twiasante_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Anɔpahema no, ɔsoro abɔfoɔ no hyɛɛ Lot sɛ, “Ntɛm! Ka wo ho, na fa wo yere ne wo mmammaa baanu a wɔwɔ ha no firi ha kɔ; anyɛ saa a, wɔde mo bɛfra kuro no, asɛe mo.” ");
INSERT INTO twiasante_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ɔtwentwɛnee ne nan ase no, ɔsoro abɔfoɔ no sosɔɔ Lot ne ne yere ne ne mmammaa baanu no nsa, twee wɔn, de wɔn firii kuro no mu asomdwoeɛ mu, ɛfiri sɛ, Awurade hunuu wɔn mmɔbɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ɔsoro abɔfoɔ no yii Lot mmammaa baanu no firii kuro no mu ara pɛ, abɔfoɔ no mu baako kaa sɛ, “Monnwane nnye mo kra nkwa; monnhwɛ mo akyiri. Monnnyina baabiara. Monnwane nkɔ mmepɔ no so, anyɛ saa a, mobɛwuwu!” ");
INSERT INTO twiasante_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Nanso, Lot ka kyerɛɛ wɔn sɛ, “Ao, dabi me wuranom! ");
INSERT INTO twiasante_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mo akoa anya mo anim adom, na moayɛ me adɔeɛ kɛseɛ de agye me nkwa. Nanso, me deɛ, merentumi nnwane nkɔ mmepɔ no so, ɛfiri sɛ, mesuro sɛ anhwɛ a, saa amanehunu yi bɛto me, ama mawu. ");
INSERT INTO twiasante_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Hwɛ, kuro ketewa bi bɛn ha. Mesrɛ mo, momma menkɔhinta hɔ mmom, na manhwere me nkwa. Kuro no nsua anaa?” ");
INSERT INTO twiasante_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ɔsoro abɔfoɔ no ka kyerɛɛ Lot sɛ, “Ɛyɛ, mepene wʼabisadeɛ yi so; merensɛe saa kuro ketewa no. ");
INSERT INTO twiasante_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ɛnneɛ, dwane kɔ hɔ ntɛm, ɛfiri sɛ, sɛ wonnuruu hɔ a, merenyɛ biribiara.” Ɛfiri saa ɛberɛ no, na wɔfrɛɛ kuro no Soar a aseɛ ne kuro ketewa. ");
INSERT INTO twiasante_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ɛberɛ a Lot duruu Soar no, na owia apue. ");
INSERT INTO twiasante_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Afei, Awurade maa sɔfe ne ogya tɔ firii soro, guu Sodom ne Gomora so. ");
INSERT INTO twiasante_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Saa ɛkwan yi so na wɔfa de sɛee saa nkuropɔn mmienu ne asasetam no nyinaa. Nnipa a na wɔtete saa nkuropɔn no so ne asase no so afifideɛ nso nyinaa sɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nanso, Lot yere twaa nʼani hwɛɛ nʼakyiri ma ɔdanee nkyene esie. ");
INSERT INTO twiasante_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Adeɛ kyee anɔpatutuutu no, Abraham kɔɔ baabi a ɔgyinaa Awurade anim no. ");
INSERT INTO twiasante_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ɔmaa nʼani so hwɛɛ Sodom ne Gomora fam ne asasetam no so nyinaa, hunuu wisie kumɔnn a abua asase no so te sɛ wisie a ɛfiri fononoo mu. ");
INSERT INTO twiasante_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ɛberɛ a Onyankopɔn sɛee nkuro a ɛwɔ asase tamaa no so no, Onyankopɔn kaee Abraham, na ɔyii Lot firii ɔsɛeɛ a ɛbaa nkuro a na Lot te so no mu no. ");
INSERT INTO twiasante_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Afei, Lot ne ne mmammaa baanu no tu firii Soar kɔtenaa ɔbodan bi a na ɛwɔ mmepɔ no mu, ɛfiri sɛ, na ɔsuro sɛ ɔbɛtena Soar. ");
INSERT INTO twiasante_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ɛda koro bi, ɔbabaa panin no ka kyerɛɛ akumaa no sɛ, “Yɛn agya abɔ akɔkoraa, na ɔbarima biara nso nni ha a ɔne yɛn bɛda, sɛdeɛ wɔyɛ no ewiase baabiara no. ");
INSERT INTO twiasante_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ne saa enti, ma yɛmma yɛn agya nsã nnom, na afei, yɛne no nna, sɛdeɛ ɛbɛyɛ a yɛnam ne so bɛma yɛn ase adɔre.” ");
INSERT INTO twiasante_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Saa anadwo no, wɔmaa wɔn agya nsã nomeeɛ. Na ɔbabaa panin no ne no kɔdaeɛ. Lot anhunu ɛberɛ korɔ a ne babaa panin no de bɛdaa hɔ ne ɛberɛ korɔ a ɔsɔre kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Adeɛ kyeeɛ no, ɔbabaa panin no ka kyerɛɛ akumaa no sɛ, “Nnora anadwo, me ne mʼagya daeɛ. Saa anadwo yi, ma yɛnsane mma no nsã nnom, na wo nso, wo ne no nkɔda, sɛdeɛ ɛbɛyɛ a yɛnam yɛn agya so bɛma yɛn ase adɔre.” ");
INSERT INTO twiasante_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Saa anadwo no nso, wɔmaa wɔn agya nsã nomeeɛ. Na akumaa no nso ne nʼagya kɔdaeɛ. Bio, Lot anhunu ɛberɛ ko a akumaa no de bɛdaa hɔ ne ɛberɛ ko a ɔsɔre kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Enti, Lot ne ne mmammaa baanu no nyinsɛneeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ne babaa panin no woo ɔbabarima, na ɔtoo no edin Moab. Ɔno na ɔyɛ Moabfoɔ agya de bɛsi ɛnnɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Akumaa no nso woo ɔbabarima, na ɔtoo no edin Ben-Ami; ɔno nso ne Amon mma agya de bɛsi ɛnnɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Afei, Abraham tu firii hɔ kɔɔ anafoɔ mantam asase bi a wɔfrɛ no Negeb kɔtenaa nkuro Kades ne Sur ntam. Ɔtenaa Gerar kakra. ");
INSERT INTO twiasante_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham maa nnipa no tee aseɛ sɛ, Sara yɛ ne nuabaa. Enti, Gerarhene Abimelek soma kɔfaa Sara baa nʼahemfie. ");
INSERT INTO twiasante_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Nanso, Onyankopɔn soo Abimelek daeɛ, ka kyerɛɛ no sɛ, “Wosɛ owuo, ɛfiri sɛ, ɔbaa a woakɔfa no no yɛ obi yere.” ");
INSERT INTO twiasante_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Nanso, na Abimelek nnya ne Sara nnaeɛ, enti ɔkaa sɛ, “Awurade, enti wobɛsɛe onipa a ɔnyɛɛ bɔne bi? ");
INSERT INTO twiasante_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham ka kyerɛɛ me sɛ, ‘Ɔyɛ me nuabaa.’ Na Sara no nso kaa sɛ, ‘Ɔyɛ me nuabarima.’ Enti mede adwenem fann ne akoma mu teɛ na meyɛɛ deɛ meyɛeɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Afei, Onyankopɔn soo Abimelek daeɛ bio ka kyerɛɛ no sɛ, “Ɛyɛ nokorɛ turodoo sɛ, wode adwenem fann ne akoma mu teɛ na ɛyɛɛ deɛ woyɛeɛ no; ɛno enti, mamma woanyɛ bɔne antia me. Ɛno enti na mamma woamfa wo ho anka no no. ");
INSERT INTO twiasante_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ne saa enti sane fa ɔbarima no yere no kɔma no, ɛfiri sɛ, saa ɔbarima no yɛ odiyifoɔ a ɔbɛtumi abɔ mpaeɛ ama wo, ama woatena. Na sɛ woansane amfa no ankɔma no a, hunu sɛ, wo ne wʼasefoɔ nyinaa bɛwuwu.” ");
INSERT INTO twiasante_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Adeɛ kyee anɔpatutuutu no, ntɛm ara, Abimelek frɛɛ ne mpanimfoɔ nyinaa bɔɔ wɔn nsɛm a asisie no ho amaneɛ. Na wɔsuroo yie. ");
INSERT INTO twiasante_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Afei, Abimelek frɛɛ Abraham ka kyerɛɛ no sɛ, “Ɛdeɛn na woayɛ yɛn yi? Bɔne bɛn na mayɛ wo a woakɔfa afɔbusɛm kɛseɛ a ɛte sɛɛ yi abɛto me ne me ɔman so yi? Adeɛ a wode ayɛ me yi nyɛ adeɛ a anka ɛsɛ sɛ wode yɛ me.” ");
INSERT INTO twiasante_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Afei, Abimelek bisaa Abraham sɛ, “Ɛdeɛn adwene na ɛkaa wo a ɛmaa woyɛɛ saa?” ");
INSERT INTO twiasante_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham buaa sɛ, “Mesusuu sɛ, nokorɛm, Onyankopɔn biara nni mo mu, ne saa enti, me yere enti, mobɛtumi akum me. ");
INSERT INTO twiasante_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Yei akyiri no, ampa ara, ɔyɛ me nuabaa. Yɛfiri agya korɔ. Yɛmfiri ɛna korɔ. Ɛno enti na mewaree no no. ");
INSERT INTO twiasante_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Na ɛberɛ a Onyankopɔn ka kyerɛɛ me Abraham sɛ, mentu mfiri mʼagya fie nkɔ asase a ɔbɛkyerɛ me so no, me nso, meka kyerɛɛ Sara sɛ, ‘Adɔeɛ a ɛsɛ sɛ woyɛ me nie: baabiara a yɛbɛduru no, ka sɛ, meyɛ wo nuabarima.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Enti, Abimelek de nnwan, anantwie, nkoa ne mfenaa brɛɛ Abraham. Na ɔde ne yere Sara sane brɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek kaa sɛ, “Mʼasasetam na ɛda wʼanim yi, ɛso baabiara a wopɛ sɛ wotena no, fa.” ");
INSERT INTO twiasante_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abimelek ka kyerɛɛ Sara nso sɛ, “Mede dwetɛ kilogram dubaako ne fa rema wo nuabarima no. Yei ne mpatadeɛ a mede rema wo wɔ bɔne a wɔde too wo so no, wɔ wɔn a wɔka wo ho no nyinaa anim. Asodie biara nna wo so.” ");
INSERT INTO twiasante_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Enti, Abraham bɔɔ mpaeɛ, srɛɛ Onyankopɔn sɛ, ɔnsa ɔhene Abimelek, ɔhemmaa ne mfenaa a wɔwɔ efie hɔ yadeɛ, ma wɔnwo mma. ");
INSERT INTO twiasante_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Esiane Abraham yere Sara enti, Awurade too Abimelek fiefoɔ nyinaa yafunu mu, de twee Abimelek aso. ");
INSERT INTO twiasante_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Afei, Awurade hunuu Sara mmɔbɔ, sɛdeɛ ɔhyɛɛ no bɔ no. ");
INSERT INTO twiasante_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara nyinsɛneeɛ, na ɔwoo ɔbabarima maa Abraham wɔ ne nkɔkoraaberɛm, ɛberɛ a Awurade hyɛɛ no bɔ no mu pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham too ɔbabarima a Sara woo no maa no no edin Isak, a aseɛ ne Sereɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ɛberɛ a Isak dii nnawɔtwe no, ɔtwaa no twetia, sɛdeɛ Onyankopɔn hyɛɛ no no. ");
INSERT INTO twiasante_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Wɔwoo Isak maa Abraham no, na wadi mfeɛ ɔha. ");
INSERT INTO twiasante_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Afei, Sara kaa sɛ, “Onyankopɔn ama masere. Na obiara a ɔbɛte saa asɛm yi ne me bɛbom asere.” ");
INSERT INTO twiasante_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Sara ka kaa ho sɛ, “Hwan na ɔsoo ho daeɛ ka kyerɛɛ Abraham sɛ, Sara bɛwo mma. Nanso, ne nkɔkoraaberɛm yi, mawo ɔbabarima ama no.” ");
INSERT INTO twiasante_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Abɔfra no nyiniiɛ, ma wɔtwaa no nufoɔ. Ɛda a wɔtwaa Isak nufoɔ no, Abraham too ɛpono kɛseɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Nanso, Sara hunuu sɛ, ɔbabarima a nʼafenawa Misraimni Hagar woo no maa Abraham no redi Isak ho fɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Enti, Sara ka kyerɛɛ Abraham sɛ, “Pam saa afenaa yi ne ne babarima yi firi ha; na Isak ne saa afenaa babarima yi nni wʼagyadeɛ biara mu kyɛfa.” ");
INSERT INTO twiasante_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham tee saa asɛm no, ɛsiane ne babarima Ismael enti, ne werɛ hoo yie. ");
INSERT INTO twiasante_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Nanso, Onyankopɔn ka kyerɛɛ Abraham sɛ, “Mma wo babarima Ismael ne wʼafenaa Hagar ho asɛm no nnha wo bebree. Asɛm biara a Sara bɛka akyerɛ wo no, tie, ɛfiri sɛ, Isak so na wɔnam bɛkan wʼasefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mɛma afenaa no babarima Ismael no nso asefoɔ ayɛ ɔman kɛseɛ, ɛfiri sɛ, ɔno nso yɛ wʼaseni.” ");
INSERT INTO twiasante_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Adeɛ kyee anɔpatutuutu no, Abraham faa aduane ne nsuo a ɛgu aboa nwoma mu, de maa Hagar. Ɔde aduane no ne nsuo no sisii Hagar mmati so, ka kyerɛɛ ɔne ne ba Ismael no sɛ, wɔnkɔ. Ɔfirii hɔ kɔkyinkyinii Beer-Seba ɛserɛ so a na ɔnhunu baabi a ɔrekɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Nsuo a ɛwɔ aboa nwoma no mu saeɛ no, ɔde ne babarima no kɔhintaa wira no mu baabi. ");
INSERT INTO twiasante_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Afei, ɔkɔtenaa akyiri baabi a woto ɛboɔ a ɛbɛtɔ, kaa sɛ, “Merentumi nhwɛ sɛ abarimaa no bɛwu.” Na ɛberɛ a Hagar te hɔ saa no, ɔhyɛɛ aseɛ suiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Onyankopɔn tee sɛ abarimaa no resu. Onyankopɔn ɔbɔfoɔ frɛɛ Hagar firi soro bisaa no sɛ, “Hagar! Asɛm bɛn na ɛha wo? Nsuro, ɛfiri sɛ, Onyankopɔn ate abarimaa no su wɔ baabi a ɔda no. ");
INSERT INTO twiasante_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Pagya abarimaa no, ɛfiri sɛ, mɛma no ayɛ ɔman kɛseɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Afei, Onyankopɔn buee Hagar ani, ma ɔhunuu subura bi. Ɔde aboa nwoma no kɔsaa nsuo ma, ɛnna ɔmaa abarimaa no bi nomeeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Onyankopɔn adom enti, abarimaa no nyiniiɛ. Ɔtenaa ɛserɛ no so hunuu agyantoɔ yie. ");
INSERT INTO twiasante_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ɛberɛ a ɔte Paran ɛserɛ so no, ne maame kɔfaa ɔbaa firi Misraim asase so de no brɛɛ no awadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Saa ɛberɛ no mu, ɔhene Abimelek ne ne sahene Pikol baa Abraham nkyɛn bɛka kyerɛɛ no sɛ, “Biribiara a woyɛ no, Onyankopɔn ka wo ho. ");
INSERT INTO twiasante_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Enti afei, di nse ka ntam wɔ Onyankopɔn anim kyerɛ me wɔ ha sɛ, worentwa me mma anaa mʼasefoɔ nkontompo. Saa ayamyɛ a mayɛ wo no, saa ara na fa yɛ me ne ɔman a wote so sɛ ɔmamfrani no.” ");
INSERT INTO twiasante_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham penee so sɛ, “Meka saa ntam no!” ");
INSERT INTO twiasante_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Afei, Abraham de subura bi a Abimelek nkoa de aniɛden afa no ho asɛm kɔtoo Abimelek anim. ");
INSERT INTO twiasante_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Nanso, Abimelek kaa sɛ, “Mennim onipa ko a ɔyɛɛ saa adeɛ no. Woammɔ me ho amaneɛ. Ɛnnɛ na mate saa asɛm yi.” ");
INSERT INTO twiasante_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Enti, Abraham de nnwan ne anantwie brɛɛ Abimelek. Na mmarima baanu yi de yɛɛ apam. ");
INSERT INTO twiasante_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham yii nnwanten mma abereɛ nson firii nnwankuo no mu gyinaa fa. ");
INSERT INTO twiasante_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Na Abimelek bisaa Abraham sɛ, “Nnwanten mma abereɛ nson a woayi wɔn agyina fa yi ase kyerɛ sɛn?” ");
INSERT INTO twiasante_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham buaa sɛ, “Nʼasekyerɛ ara ne sɛ, ɛyɛ akyɛdeɛ a mede rema wo de adi adanseɛ sɛ, me na metuu saa abura yi.” ");
INSERT INTO twiasante_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ɛfiri saa ɛberɛ no rekorɔ no, wɔfrɛɛ saa abura no, Beer-Seba a aseɛ ne Ntanka Abura, ɛfiri sɛ, ɛhɔ na wɔn baanu yɛɛ apam no. ");
INSERT INTO twiasante_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Wɔyɛɛ apam no wiee wɔ Beer-Seba no, ɔhene Abimelek ne ne Sahene Pikol sane kɔɔ Filistifoɔ asase so. ");
INSERT INTO twiasante_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham nso duaa dua bi a wɔfrɛ no ɛsɛnteɛ wɔ abura no ho wɔ Beer-Seba. Ɛhɔ na daa na ɔsom Awurade teasefoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham tenaa Filistifoɔ asase no so sɛ ɔmamfrani nna bebree. ");
INSERT INTO twiasante_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Yeinom nyinaa akyiri, Onyankopɔn sɔɔ Abraham hwɛeɛ. Ɔfrɛɛ Abraham sɛ, “Abraham!” Abraham buaa sɛ, “Me nie!” ");
INSERT INTO twiasante_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Onyankopɔn ka kyerɛɛ no sɛ, “Fa wo ba, wo ba korɔ Isak a wodɔ no no kɔ Moria asase so, na fa no kɔbɔ ɔhyeɛ afɔdeɛ wɔ mmepɔ a ɛwɔ hɔ no mu baako a mɛkyerɛ wo no so.” ");
INSERT INTO twiasante_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham sɔree anɔpatutuutu hyehyɛɛ nʼafunumu. Ɔfaa ne nkoa no mu baanu ne ne ba Isak kaa ne ho. Ɔtwitwaa egya a ɛbɛso ɔhyeɛ afɔdeɛ no bɔ no, ɔsiim kɔɔ baabi a Onyankopɔn kyerɛɛ no sɛ ɔnkɔ no. ");
INSERT INTO twiasante_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ne nnansa so no, Abraham too nʼani hunuu sɛ baabi a ɔrekɔ no wɔ akyirikyiri. ");
INSERT INTO twiasante_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Na Abraham ka kyerɛɛ ne nkoa no sɛ, “Mo ne afunumu no ntwɛn ha, na me ne abarimaa no nkɔ animu kakra, nkɔsom. Sɛ yɛsom wie a, yɛbɛsane aba.” ");
INSERT INTO twiasante_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham faa anyina a wɔde rekɔbɔ ɔhyeɛ afɔdeɛ no de soaa ne ba Isak. Ɛnna ɔno nso faa egya ne sekammoa kuraeɛ. Ɛberɛ a wɔrekɔ no, ");
INSERT INTO twiasante_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isak frɛɛ nʼagya Abraham sɛ, “Agya!” Ɛnna Abraham buaa sɛ, “Me ba, asɛm bɛn?” Isak bisaa no sɛ, “Egya ne anyina no nie, na odwammaa a yɛde no rekɔbɔ ɔhyeɛ afɔdeɛ no wɔ he?” ");
INSERT INTO twiasante_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham buaa sɛ, “Onyankopɔn no ankasa bɛma yɛn afɔredwan a yɛde rekɔbɔ ɔhyeɛ afɔdeɛ no.” Afei, wɔn baanu no toaa so kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Wɔbɛduruu baabi a Onyankopɔn kyerɛɛ no no, Abraham sii afɔrebukyia wɔ hɔ, hyehyɛɛ anyina no wɔ so. Ɔkyekyeree ne ba Isak, de no too anyina no so wɔ afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham twee sekammoa no, pagyaa sɛ ɔde rebɛtwa ne ba no mene akum no. ");
INSERT INTO twiasante_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ɛhɔ ara na Awurade ɔbɔfoɔ frɛɛ no firi soro sɛ, “Abraham! Abraham!” Ɛnna Abraham gyee so sɛ, “Me nie.” ");
INSERT INTO twiasante_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Awurade ɔbɔfoɔ no kaa sɛ, “Mfa wo nsa nka abɔfra no. Ɛnyɛ no bɔne biara. Esiane sɛ woamfa wo dɔ ba, wo ba korɔ no ankame me no enti, mahunu sɛ wosuro Onyankopɔn.” ");
INSERT INTO twiasante_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham maa nʼani so hunuu sɛ nkyɛkyerɛ bi asɔ odwennini bi mmɛn mu wɔ wira no mu hɔ. Abraham kɔkyeree odwennini no de no bɔɔ ɔhyeɛ afɔdeɛ wɔ afɔrebukyia no so, sii ne ba no ananmu. ");
INSERT INTO twiasante_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham too beaeɛ no din sɛ Awurade De Bɛma. Ɛbɛsi ɛnnɛ no wɔka sɛ, “wɔde bɛma wɔ Awurade bepɔ no so.” ");
INSERT INTO twiasante_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Awurade ɔbɔfoɔ no frɛɛ Abraham firii soro deɛ ɛtɔ so mmienu kaa sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Maka me ho ntam sɛ, ɛsiane sɛ woayɛ yei, na woamfa wo ba, wo ba korɔ no ankame me enti, ");
INSERT INTO twiasante_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","hyira na mɛhyira wo na mama wʼase adɔre sɛ ɔsoro nsoromma ne mpoano anwea. Na wʼasefoɔ bɛgye wɔn atamfoɔ nkuropɔn adi so. ");
INSERT INTO twiasante_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Wɔnam wʼasefoɔ so na wɔbɛhyira ewiase amanaman nyinaa, ɛfiri sɛ, woadi mʼasɛm so.” ");
INSERT INTO twiasante_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Afei, Abraham sane kɔɔ nʼasomfoɔ no nkyɛn ne wɔn siim kɔɔ Beer-Seba kɔtenaa hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Yeinom nyinaa akyiri no, wɔka kyerɛɛ Abraham sɛ, “Milka nso yɛ ɔbaatan a wawo mmammarima ama wo nuabarima Nahor. Wɔn din na ɛdidi so yi: ");
INSERT INTO twiasante_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us yɛ abakan, Us nuabarima Bus na ɔtɔ so mmienu. Deɛ ɔdi so ne Kemuel, a ɔyɛ Aram agya. ");
INSERT INTO twiasante_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Wɔn a wɔaka no ne Kesed, Haso, Pildas, Yidlaf ne Betuel.” ");
INSERT INTO twiasante_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Saa Betuel yi na ɔwoo Rebeka. Milka ne Abraham nua Nahor na wɔwowoo saa mmammarima baawɔtwe yi. ");
INSERT INTO twiasante_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor ne ne mpena Rehuma nso wowoo mma baanan a wɔn din de, Teba, Gaham, Tahas ne Maaka. ");
INSERT INTO twiasante_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara dii mfeɛ ɔha aduonu nson. ");
INSERT INTO twiasante_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ɔwuu wɔ Kiriat-Arba a ɛno ara ne Hebron a ɛwɔ Kanaan asase so. Abraham kɔgyam ne yere Sara, suu no wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abraham gyaa ne yere Sara amu no hɔ, kɔɔ Hetifoɔ mpanimfoɔ nkyɛn, kɔsrɛɛ wɔn sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Meyɛ ɔhɔhoɔ ne mamfrani a mete mo mu. Mesrɛ mo, montɔn mo asase yi bi mma me, na mensie me yere wɔ so.” ");
INSERT INTO twiasante_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hetifoɔ no buaa Abraham sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Owura, yɛsrɛ wo, tie asɛm a yɛrebɛka yi. Woyɛ Onyankopɔn ɔsomfoɔ kɛseɛ wɔ yɛn mu. Yɛn boda biara a ɛsɔ wʼani a wopɛ sɛ wosie wo yere wɔ hɔ no, yɛma wo ho kwan, kɔsie no. Yɛn mu biara remfa ne boda nkame wo.” ");
INSERT INTO twiasante_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ɛhɔ ara, Abraham sɔre bɔɔ ne mu ase wɔ Hetifoɔ no anim, ");
INSERT INTO twiasante_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ka kyerɛɛ wɔn sɛ, “Sɛ moapene so sɛ mensie mʼamu no wɔ ha deɛ a, mepa mo kyɛw, monsrɛ Efron a ɔyɛ Sohar babarima no mma me, ");
INSERT INTO twiasante_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","na ɔntɔn Makpela ɔboda a ɛwɔ nʼafuo ano no mma me. Monka nkyerɛ no na ɔntɔn no sɛdeɛ ne boɔ die pɛpɛɛpɛ mma me, na mede hɔ ayɛ me ne mʼabusuafoɔ amusieeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Saa ɛberɛ no na Hetini Efron a ɔte ne manfoɔ mu no buaa Abraham maa ne nkurɔfoɔ a wɔahyia wɔ kuro no ɛpono ano nyinaa tee sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Dabi, me wura, tie me! Mede afuo no ne ɔboda a ɛwɔ mu no kyɛ wo. Megyina me manfoɔ anim, na mede kyɛ wo. Kɔsie wʼamu no wɔ hɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Bio Abraham de obuo ne anidie bɔɔ ne mu ase wɔ ɔmanfoɔ no anim, ");
INSERT INTO twiasante_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ka kyerɛɛ Efron maa wɔn a wɔahyia wɔ hɔ no nyinaa tee asɛm a ɔkaeɛ no sɛ, “Mesrɛ mo, ɔmanfoɔ, monyɛ aso mma me. Momma mentua asase no ka. Mompene so mma me, na mennya ɛkwan nkɔsie mʼamu no.” ");
INSERT INTO twiasante_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron buaa Abraham sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Me wura, tie me! Asase no boɔ yɛ dwetɛ kilogram ɛnan ne fa. Yɛnyɛ nnipa baako anaa? Meregye saa sika yi ayɛ ɛdeɛn? Kɔsie wʼamu no!” ");
INSERT INTO twiasante_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham penee Efron asɛm no so. Ɔkarii dwetɛ kilogram ɛnan ne fa a ɛyɛ asase no boɔ de maa Efron. Saa ara na na adwadifoɔ tɔn asase wɔ Hetifoɔ ɔman mu, na Hetifoɔ mpanimfoɔ no dii dwumadie no ho adanseɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Enti, wɔde Efron asase a ɛwɔ Makpela a ɛbɛn Mamrɛ, a ɛyɛ afuo no, ɔboda a ɛwɔ mu no, nnua a ɛwɔ afuo no mu ne nʼahyeɛ so nyinaa maa ");
INSERT INTO twiasante_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abraham sɛ nʼagyapadeɛ. Yei nyinaa sii wɔ Hetifoɔ no ne wɔn a wɔbaa kuro no ɛpono no ano nyinaa anim. ");
INSERT INTO twiasante_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Afei, Abraham siee ne yere Sara wɔ ɔboda a ɛwɔ Makpela afuo a ɛbɛn Mamrɛ a ɛno ara ne Hebron a ɛwɔ Kanaan asase so no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Enti, Hetifoɔ no yɛɛ nhyehyɛeɛ de afuo no ne ɔboda a ɛwɔ mu no maa Abraham sɛ, nʼagyapadeɛ ne nʼamusieeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Na Abraham anyini a ne mfeɛ kɔ ɛkan yie. Awurade hyiraa no akwan ahodoɔ nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ɛda koro bi, Abraham ka kyerɛɛ ne ɔsomfoɔ panin a ɔhwɛ nʼagyapadeɛ nyinaa so sɛ, “Fa wo nsa ka me srɛ ase. ");
INSERT INTO twiasante_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Mepɛ sɛ woka Awurade a ɔyɛ ɔsoro ne asase Onyankopɔn ntam sɛ, worenware Kanaanfoɔ a me ne wɔn te yi babaa biara mma me babarima Isak. ");
INSERT INTO twiasante_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Na mmom, wobɛkɔ me ɔman mu, mʼabusuafoɔ nkyɛn, akɔware ɔbaa abrɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ɔsomfoɔ no bisaa Abraham sɛ, “Me wura, na sɛ ɛba sɛ ɔbaa no ampene so sɛ ɔne me bɛba ɔman yi mu a, na mereyɛ no ɛdeɛn? Memfa wo babarima no nkɔ wo ɔman no mu anaa?” ");
INSERT INTO twiasante_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham kaa sɛ, “Hwɛ yie na woamfa me babarima no ankɔ hɔ da. ");
INSERT INTO twiasante_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Awurade, ɔsoro Onyankopɔn a ɔde me firi mʼagya fie ne mʼasase so baa ha, na ɔkaa ntam hyɛɛ me bɔ sɛ, ‘Mede saa asase yi bɛma wʼasefoɔ no.’ Ɔno ara na ɔbɛsoma ne ɔbɔfoɔ adi wʼanim akɔ sɛdeɛ ɛbɛyɛ a, wobɛnya ɔyere afiri hɔ ama me babarima no. ");
INSERT INTO twiasante_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Sɛ ɛba sɛ, ɔbaa no ampene sɛ ɔne wo bɛba a, wo ntam a wokaeɛ no nkyekyere wo. Ɛnsɛ sɛ wode me babarima no kɔ hɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Enti, ɔsomfoɔ no de ne nsa kaa ne wura Abraham srɛ ase, kaa saa asɛm yi ho ntam. ");
INSERT INTO twiasante_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Afei, ɔsomfoɔ no faa ne wura nyoma no mu edu kɔeɛ. Ɔrebɛkɔ no, ɔgyee ne wura Abraham nkyɛn nnepa ahodoɔ bebree kaa ho. Ɔde nʼani kyerɛɛ Mesopotamia, kɔduruu Nahor kuro mu. ");
INSERT INTO twiasante_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ɔduruu Nahor kurotia no, ɔmaa nyoma no butubutuu abura bi a ɛwɔ hɔ ho. Na onwunu adwo a ɛyɛ ɛberɛ a mmaa bɛto nsuo wɔ abura no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Na ɔsomfoɔ no bɔɔ mpaeɛ sɛ, “Ao, Awurade, me wura Abraham Onyankopɔn, hunu me wura Abraham mmɔbɔ, na boa me, na mʼakwantuo yi nsi yie. ");
INSERT INTO twiasante_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Hwɛ, megyina abura yi so, na kuro yi mu mmabaawa rebɛto nsuo. ");
INSERT INTO twiasante_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ma ɛmmra mu sɛ, ababaawa biara a mɛka akyerɛ no sɛ, ‘Mesrɛ wo, soɛ na ma me wo sukuruwa no mu nsuo no bi nnom no,’ sɛ ɔka sɛ, ‘Nom bi, na mɛma wo yoma no nso bi anom’ a, ɔnyɛ ababaawa a woapa no ama wʼakoa Isak. Ɛnam yei so bɛma mahunu sɛ, woahunu me wura mmɔbɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ɔgu so rebɔ mpaeɛ no na Rebeka baeɛ a ne sukuruwa si nʼabati so. Saa Rebeka no yɛ Betuel ba. Betuel no nso yɛ Abraham nuabarima Nahor ne ne yere Milka babarima. ");
INSERT INTO twiasante_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Na Rebeka no yɛ ɔbaabunu a ne ho yɛ fɛ yie. Na ɔbarima biara mfaa ne ho nkaa no da. Ɔsiane kɔɔ abura no so, kɔhyɛɛ ne sukuruwa no nsuo ma, sane baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ɔsomfoɔ no de ahoɔherɛ kɔhyiaa Rebeka, ka kyerɛɛ no sɛ, “Mesrɛ wo, hwie wo sukuruwa no mu nsuo no kakra ma mennom.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ntɛm ara, ɔsoɛɛ ne sukuruwa no kaa sɛ, “Me wura, gye bi nom.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Rebeka maa ɔsomfoɔ no nsuo no bi nom wieeɛ no, ɔkaa sɛ, “Mɛsane akɔtwe nsuo no bi abrɛ wo nyoma no nyinaa nso anom.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Enti, Rebeka de ahoɔherɛ hwiee ne nsuo no guu anomeeɛ bi mu, sane kɔtwee nsuo a ɛbɛso nyoma no nyinaa nom de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ɔsomfoɔ no hwɛɛ Rebeka komm, karii no pɛɛ sɛ ɔhunu sɛ Awurade ama nʼakwantuo no asi no yie anaa. ");
INSERT INTO twiasante_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Nyoma no nom nsuo no wieeɛ no, ɔsomfoɔ no yii sikakɔkɔɔ hwenemukawa a emu duru kari gram nsia ne sikakɔkɔɔ nkapo mmienu a ɛno nso mu duru yɛ gram ɔha dunan. ");
INSERT INTO twiasante_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Afei, ɔbisaa sɛ, “Hwan ba ne wo? Mesrɛ wo, yɛbɛnya daberɛ wɔ wo agya fie ama adeɛ akye anaa?” ");
INSERT INTO twiasante_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebeka buaa no sɛ, “Betuel babaa ne me. Me nananom ne Milka ne Nahor.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ɔka kaa ho sɛ, “Yɛwɔ ɛserɛ ne mmoa aduane bebree ne baabi a, mo nso, mobɛda.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Afei, ɔsomfoɔ no buu nkotodwe, sɔree Awurade Onyankopɔn sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Nhyira nka Awurade, me wura Abraham Onyankopɔn, sɛ ɔnnyaee nokorɛdie ne ayamyɛ a ɔyɛ ma me wura no. Me deɛ, Awurade adi mʼanim wɔ mʼakwantuo yi mu, de me abɛduru me wura abusuafoɔ fie.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebeka tuu mmirika kɔkaa nsɛm a asisie no nyinaa kyerɛɛ ne maame fiefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Na Rebeka wɔ nuabarima bi a ne din de Laban. Laban tee asɛm no, ɔde ahoɔherɛ kɔɔ ɔbarima no nkyɛn wɔ abura no so. ");
INSERT INTO twiasante_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Laban hunuu hwenemukawa no ne nkapo a ɛgu ne nuabaa no nsa no, na ɔtee asɛm a ɔbarima no ka kyerɛɛ Rebeka no, ɔkɔɔ ɔbarima no nkyɛn kɔhunuu sɛ ɔgyina nyoma no ho wɔ asubura no so. ");
INSERT INTO twiasante_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban ka kyerɛɛ ɔsomfoɔ no sɛ, “Bra, wo a Awurade ahyira wo.” Ɔbisaa ɔsomfoɔ no sɛ, “Adɛn enti na wogyina kurotia ha? Masiesie wo daberɛ ne baabi a nyoma no nso bɛda.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Enti, ɔsomfoɔ no kɔɔ efie hɔ maa Laban yiyii nneɛma a ɛsoso nyoma no. Wɔmaa nyoma no ɛserɛ ne aduane, afei Laban maa ɔsomfoɔ no ne nnipa a wɔka ne ho no nsuo de hohoroo wɔn nan ho. ");
INSERT INTO twiasante_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Yei akyiri no, ɔtoo wɔn ɛpono. Nanso, ɔsomfoɔ no kaa sɛ, “Merempɛ sɛ mɛdidi, gye sɛ mabɔ mʼamanneɛ.” Laban kaa sɛ, “Bɔ wʼamanneɛ ɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Enti, ɔsomfoɔ no bɔɔ nʼamanneɛ sɛ, “Meyɛ Abraham ɔsomfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Awurade ahyira me wura bebree, ama wayɛ ɔdefoɔ. Wama no nnwan ne anantwie, dwetɛ ne sikakɔkɔɔ, nkoa ne mfenaa ne nyoma ne mfunumu. ");
INSERT INTO twiasante_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Bio, me wura yere Sara awo ɔbabarima ama no wɔ ne mmerewaberɛ mu; Awurade na ɔde deɛ ɔwɔ nyinaa ama no. ");
INSERT INTO twiasante_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Me wura maa mekaa ntam sɛ, ‘Worenware Kanaanfoɔ a me ne wɔn te yi babaa biara mma me babarima Isak. ");
INSERT INTO twiasante_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Na mmom, wobɛkɔ me ɔman mu, mʼabusuafoɔ nkyɛn, akɔware ɔbaa wɔ hɔ abrɛ me babarima Isak.’ ");
INSERT INTO twiasante_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Na mebisaa me wura sɛ, ‘Na sɛ ɛba sɛ, ɔbaa no ampene so sɛ ɔne me bɛba ɔman yi mu a, na mereyɛ no ɛdeɛn?’ ");
INSERT INTO twiasante_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Me wura Abraham buaa sɛ, ‘Awurade a manante nʼanim no bɛsoma ne ɔbɔfoɔ, adi wʼanim, sɛdeɛ ɛbɛyɛ a, wʼakwantuo no bɛsi yie, na woanya ɔyere ama me babarima afiri mʼabusua mu a ɛyɛ mʼagya fie no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Afei, sɛ ɛba sɛ, woba mʼabusua mu, na sɛ wɔamfa ɔbaa no amma wo a, wo ntam a wokaeɛ no renkyekyere wo.’ ");
INSERT INTO twiasante_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Mebaa asubura no so ɛnnɛ no, mesrɛɛ sɛ, ‘Ao, Awurade, me wura Abraham Onyankopɔn, sɛ ɛyɛ wo pɛ a, ma akwantuo yi nsi me yie! ");
INSERT INTO twiasante_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Hwɛ, megyina abura yi so. Sɛ ababaawa bi bɛto nsuo wɔ ha, na meka kyerɛ no sɛ, “Mesrɛ wo, soɛ na ma me wo sukuruwa no mu nsuo no kakra nnom” no, ");
INSERT INTO twiasante_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","na sɛ ɔka sɛ, “Nom bi, na mɛma wo nyoma no nso bi anom” a, ɔnyɛ ababaawa a Awurade apa no ama me wura Abraham babarima Isak no.’ ");
INSERT INTO twiasante_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ansa na mɛwie mʼakoma mu mpaeɛbɔ no, Rebeka puee a sukuruwa si ne batiri so. Rebeka kɔɔ abura no so, kɔtoo nsuo, na meka kyerɛɛ no sɛ, ‘Mesrɛ wo, ma me nsuo no bi nnom.’ ");
INSERT INTO twiasante_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Ntɛm ara, ɔsoɛɛ ne sukuruwa no kaa sɛ, ‘Me wura, gye bi nom na mɛsane atwe nsuo no bi abrɛ wo nyoma no nyinaa nso anom.’ Enti, menom nsuo no bi, na ɔmaa nyoma no nyinaa nso bi nomeeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Mebisaa no sɛ, ‘Hwan ba ne wo?’ “Rebeka buaa sɛ, ‘Betuel ba ne me. Me nananom ne Milka ne Nahor.’ “Ɛhɔ ara na mede hwenemukawa no hyɛɛ ne hwenemu, ɛnna mede nkapo no nso guu ne nsa. ");
INSERT INTO twiasante_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Afei, mebɔɔ me mu ase sɔree Awurade. Mekamfoo Awurade a ɔyɛ me wura, Abraham Onyankopɔn, a wadi mʼanim de me afa ɛkwan pa so, ama manya me wura nuabarima nana aware ama ne babarima no. ");
INSERT INTO twiasante_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Afei, sɛ wobɛyɛ me wura adɔeɛ adi no nokorɛ a, ka kyerɛ me. Sɛ ɛnte saa nso a, ka kyerɛ me, sɛdeɛ ɛbɛyɛ a, mɛhunu ɛkwan ko a mɛfa so.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban ne Betuel buaa sɛ, “Saa asɛm yi firi Awurade enti, yɛnni ho asɛm biara. ");
INSERT INTO twiasante_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka ni. Momfa no nkɔ, na ɔnkɔware mo wura no babarima no, sɛdeɛ Awurade ahyɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ɛberɛ a Abraham ɔsomfoɔ no tee deɛ wɔkaeɛ no, ɔbuu nkotodwe wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Afei, ɔsomfoɔ no yii sikakɔkɔɔ ne dwetɛ nnwinneɛ ne ntadeɛ maa Rebeka. Ɔsane de nneɛma a ɛsom bo yie yɛɛ Rebeka nuabarima ne ne maame ayɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Afei, ɔsomfoɔ no ne nnipa a wɔka ne ho no didi nomeeɛ, na wɔda maa adeɛ kyeeɛ. Adeɛ kyee anɔpa a wɔsɔreeɛ no, ɔsomfoɔ no kaa sɛ, “Monnya me ɛkwan, na mensane nkɔ me wura nkyɛn.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Nanso, Rebeka nuabarima no ne ne maame buaa ɔsomfoɔ no sɛ, “Ma ababaawa no ntena yɛn nkyɛn bɛyɛ sɛ dadu bi, na ɛno akyiri, wode no akɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Akoa no buaa wɔn sɛ, “Awurade ahyira mʼakwantuo yi so ama me yi deɛ, mesrɛ mo, monnnye me nka ha. Monnya me ɛkwan, na mensane nkɔ me wura nkyɛn.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Afei, wɔsii gyinaeɛ sɛ, “Momma yɛmfrɛ ababaawa no, na yɛmmisa nʼadwene.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Enti, wɔfrɛɛ Rebeka bisaa no sɛ, “Wopɛ sɛ wo ne saa ɔbarima yi kɔ anaa?” Rebeka buaa sɛ, “Aane, mɛkɔ!” ");
INSERT INTO twiasante_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Enti, wɔgyaa Rebeka ne ɔbaa a ɔgyegyee no ne nkwadaaberɛm ne Abraham ɔsomfoɔ no ne ne nkurɔfoɔ ɛkwan. ");
INSERT INTO twiasante_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Wɔhyiraa Rebeka sɛ, “Onuabaa, Awurade nka wo ho, na wʼase nnɔ mpempem! Awurade mma wʼasefoɔ no nni wɔn atamfoɔ nyinaa so nkonim.” ");
INSERT INTO twiasante_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Afei, Rebeka ne ne mmaawa siesiee wɔn ho, tenatenaa wɔn nyoma so ne Abraham ɔsomfoɔ no kɔeɛ. Yei ne ɛkwan a Abraham ɔsomfoɔ no faa so de Rebeka kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Saa ɛberɛ no, na Isak a na anka ɔte Negeb no firi hɔ abɛtena Beer-Lahai-Roi. ");
INSERT INTO twiasante_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ɛda koro anwummerɛ bi a Isak kɔtuu mpase srɛ so refa adwene no, ɔtoo nʼani hunuu sɛ nyoma sa so reba. ");
INSERT INTO twiasante_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka nso too nʼani, na ɔhunuu Isak. Rebeka si firii ne yoma no so, ");
INSERT INTO twiasante_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","bisaa Abraham ɔsomfoɔ no sɛ, “Ɔbarima bɛn na ɔnam ɛserɛ yi so rebɛhyia yɛn yi?” Ɔsomfoɔ no buaa sɛ, “Ɔyɛ me wura babarima.” Enti, Rebeka yii ne nkatanimu de kataa nʼanim. ");
INSERT INTO twiasante_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Abraham ɔsomfoɔ no bɔɔ Isak nsɛm a asisie no nyinaa ho amaneɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isak de Rebeka kɔɔ ne maame Sara ntomadan mu. Na ɔwaree no, ma ɔbɛyɛɛ ne yere. Na ɔdɔ no yie. Yei maa Isak werɛ kyekyereeɛ wɔ ne maame Sara wuo akyiri. ");
INSERT INTO twiasante_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham waree ɔbaa foforɔ bi a ne din de Ketura. ");
INSERT INTO twiasante_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Abraham ne Ketura wowoo saa mma a wɔn din didi so yi: Simran, Yoksan, Medan, Midian, Yisbak ne Sua. ");
INSERT INTO twiasante_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan woo Seba ne Dedan. Dedan asefoɔ ne Asurfoɔ, Letusfoɔ ne Leumfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian woo Efa, Efer, Henok, Abida ne Eldaa. Yeinom nyinaa yɛ Ketura asefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham de nʼagyapadeɛ nyinaa maa Isak. ");
INSERT INTO twiasante_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Nanso, ɛberɛ a ɔte ase no, ɔmaa ne mpena mma akyɛdeɛ, na ɔyii wɔn firii ne babarima Isak nkyɛn, ma wɔkɔɔ apueeɛ fam asase bi so. ");
INSERT INTO twiasante_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham nkwanna nyinaa kɔsii mfeɛ ɔha aduɔson enum. ");
INSERT INTO twiasante_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham nyini bɔɔ akɔkoraa posoposo ansa na ɔrewu akɔka ne mpanimfoɔ ho. ");
INSERT INTO twiasante_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ne mmammarima Isak ne Ismael siee no wɔ Makpela boda a ɛwɔ Efron no mu. Na ɛhɔ yɛ Hetini Sohar babarima no afuo a ɛwɔ Mamrɛ apueeɛ fam. ");
INSERT INTO twiasante_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Yei ne asase a Abraham tɔ firii Hetifoɔ nkyɛn no. Ɛhɔ na wɔsiee Abraham ne ne yere Sara. ");
INSERT INTO twiasante_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham wuo akyiri no, Onyankopɔn hyiraa ne ba Isak a na saa ɛberɛ no ɔte Beer-Lahai-Roi abura no ho no. ");
INSERT INTO twiasante_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Yei ne Abraham babarima Ismael a Sara afenaa Hagar a ɔyɛ Misraimni no woo no maa Abraham no asefoɔ ho asɛm. ");
INSERT INTO twiasante_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Wɔn a wɔdidi so yi yɛ Ismael mmammarima a wɔabobɔ wɔn edin mpanin mu no. Na Nebaiot yɛ Ismael abakan. Wɔn a wɔdidi so yi nso yɛ Kedar, Adbeel, Mibsam, ");
INSERT INTO twiasante_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO twiasante_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetur, Nafis ne Kedema. ");
INSERT INTO twiasante_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Saa edin a wɔabobɔ yi yɛ Ismael mmammarima no. Saa edin yi na ɛdeda mmusuakuo dumienu ne wɔn atenaeɛ so. ");
INSERT INTO twiasante_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael dii mfirinhyia ɔha aduasa nson ansa na ɔrewu. Ɔwuiɛ ma wɔsiee no wɔ ne nkurɔfoɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismael asefoɔ yi tenatenaa nsase a ɛfiri Hawila kɔsi Sur a ɛbɛn Misraim pɛɛ wɔ Asiria ntenesoɔ. Daa na akokoakoko wɔ mmusuakuo yi ntam. ");
INSERT INTO twiasante_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham babarima Isak ne nʼasefoɔ ho asɛm nie. Abraham woo Isak. ");
INSERT INTO twiasante_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isak dii mfirinhyia aduanan no, ɔwaree Rebeka a ɔyɛ Aramni Betuel a ɔfiri Paddan-Aram no babaa. Rebeka yɛ Aramni Laban nuabaa. ");
INSERT INTO twiasante_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isak waree Rebeka mfeɛ bebree a na wɔnwo. Enti, Isak bɔɔ Awurade mpaeɛ, srɛɛ ɔba maa ne yere. Akyire yi, Awurade tiee ne mpaeɛbɔ, maa ne yere Rebeka nyinsɛneeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ɛberɛ a Rebeka nyinsɛneeɛ no, ɛtɔ da a, na mmɔfra no di apereapereɛ wɔ ne yafunu mu. Sɛ ɛba saa a, ɔbisa ne ho sɛ, “Ɛdeɛn na ɛreyɛ me yi?” Afei, ɔbɔɔ mpaeɛ bisaa Awurade nkyɛn asekyerɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Awurade buaa no sɛ, “Aman mmienu na wɔwɔ wo yafunu mu. Wɔbɛtete nnipa baanu a wɔwɔ wo yafunu mu no mu. Mmɔfra baanu no, ɔbaako asefoɔ bɛyɛ ahoɔdenfoɔ asene ne nua a ɔka ne ho no asefoɔ. Na ɔpanin no bɛsom akumaa no.” ");
INSERT INTO twiasante_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rebeka awoɔ duruu so no, ɔwoo ntaten. ");
INSERT INTO twiasante_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Na deɛ ɔdi ɛkan baeɛ no yɛ kɔkɔɔ a ne ho nwi yɛ kuhaa te sɛ deɛ ɔhyɛ nwi atadeɛ. Enti, wɔtoo no edin Esau. ");
INSERT INTO twiasante_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Yei akyiri no, ne nua no baeɛ. Na ne nsa kura Esau nantin; enti wɔtoo ne din Yakob. Rebeka woo wɔn no, na Isak adi mfeɛ aduosia. ");
INSERT INTO twiasante_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Mmɔfra no nyiniiɛ no, Esau bɛyɛɛ ɔbɔmmɔfoɔ a, ɔto a, ɔmfom. Na ɔyɛ ha fa wiram baabiara. Yakob nso bɛyɛɛ obi a ɔyɛ komm a ɔmpɛ ne ho asɛm. Na ɛberɛ biara, ɔpɛ sɛ ɔtena fie. ");
INSERT INTO twiasante_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Na Isak pɛ Esau asɛm yie, ɛfiri sɛ, na ɛberɛ biara ɔkɔyɛ ha de hanam a Isak pɛ ba fie. Nanso, na Rebeka deɛ, ɔpɛ Yakob asɛm. ");
INSERT INTO twiasante_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ɛda bi a Esau firi wiram baeɛ a na ɛkɔm de no yie no, ɔbɛtoo sɛ ne nua kumaa Yakob nso renoa aduane bi a ani yɛ kɔkɔɔ na ɛyɛ akɔnnɔ nso. ");
INSERT INTO twiasante_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ɔka kyerɛɛ Yakob sɛ, “Mesrɛ wo, ma me wʼaduane a woanoa yi bi nni!” (Ɛno enti na wɔfrɛ Esau sɛ Edom, a asekyerɛ ne ade kɔkɔɔ). ");
INSERT INTO twiasante_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakob buaa sɛ, “Tɔn wo panin no ma me ansa.” ");
INSERT INTO twiasante_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau kaa sɛ, “Ɔkɔm rekum me, na mede panin reyɛ ɛdeɛn?” ");
INSERT INTO twiasante_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakob buaa Esau sɛ, “Mate, ka ntam kyerɛ me wɔ Onyankopɔn anim sɛ, panin no yɛ me dea.” Esau kaa ntam no de tɔn ne panin no maa ne nua kumaa Yakob. ");
INSERT INTO twiasante_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Enti, Yakob maa Esau aduane no bi, ma ɔdiiɛ. Ɔnom nsuo guu so, sɔre kɔɔ ne kwan. Yei ne ɛkwan a Esau faa so tɔn ne panin no. ");
INSERT INTO twiasante_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Afei, ɛkɔm kɛseɛ bi baa asase no so. Saa ɛkɔm kɛseɛ no sene deɛ ɛbaa Abraham berɛ so no. Ɛno enti, Isak tu kɔtenaa Gerar a ɛyɛ Filistifoɔ ɔhene Abimelek kuro mu. ");
INSERT INTO twiasante_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ɛhɔ na Awurade yii ne ho adi kyerɛɛ Isak, ka kyerɛɛ no sɛ, “Nkɔ Misraim, na mmom, tena asase a mɛkyerɛ wo no so. ");
INSERT INTO twiasante_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Tena asase yi so kakra, ɛfiri sɛ, mede saa asase no nyinaa bɛma wo ne wʼasefoɔ, na mede asi ɛbɔ a mehyɛɛ wʼagya Abraham no so dua. ");
INSERT INTO twiasante_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mɛma wʼasefoɔ adɔɔso te sɛ nsoromma a ɛwɔ soro, na mede saa nsase yi nyinaa ama wɔn. Ɛnam wʼasefoɔ so na wɔbɛhyira ewiase aman ahodoɔ nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ɛfiri sɛ, Abraham tiee me nne, dii me nsɛm, mʼahyɛdeɛ ne me mmara nyinaa so.” ");
INSERT INTO twiasante_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Enti, Isak tenaa Gerar. ");
INSERT INTO twiasante_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ɛberɛ a Gerar mmarima bisaa Isak yere Rebeka ho asɛm no, ɔkaa sɛ, “Ɔyɛ me nuabaa.” Ɛfiri sɛ, na ɔsuro sɛ ɔbɛka sɛ, “Ɔyɛ me yere.” Ɔkaa saa asɛm yi, ɛfiri sɛ, na ɔsusu sɛ, ɛsiane ne yere Rebeka ahoɔfɛ enti, anhwɛ a, na kurom hɔ mmarima akum no. ");
INSERT INTO twiasante_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak tenaa hɔ kyɛɛ kakra no, ɛda bi, Filistifoɔ ɔhene Abimelek gyina ne mpomma mu na ɔhunuu sɛ Isak regoro ne yere Rebeka ho. ");
INSERT INTO twiasante_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ɛno enti, Abimelek soma ma wɔkɔfrɛɛ Isak. Isak baeɛ no, ɔbisaa no sɛ, “Ɔbaa no yɛ wo yere ankasa. Adɛn enti na woka sɛ, ‘Ɔyɛ me nuabaa?’ ” Isak buaa no sɛ, “Mesusuu sɛ, sɛ meka sɛ ɔyɛ me yere a, ne enti, ebia, na wɔakum me.” ");
INSERT INTO twiasante_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ɛnna ɔhene Abimelek kaa sɛ, “Ɛdeɛn asɛm na wo ne yɛn adi yi? Nokorɛ a woamma anna adi enti, anka obi bɛtumi afa wo yere no, na wode mmusuo aba yɛn so.” ");
INSERT INTO twiasante_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ɛno enti, Abimelek bɔɔ ne manfoɔ no kɔkɔ sɛ, “Obiara a ɔde ne nsa bɛka saa ɔbarima yi, anaa ne yere no, ɛkwan biara so, wɔbɛkum no.” ");
INSERT INTO twiasante_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Saa afe no ara Yakob dɔɔ afuo. Na Awurade hyiraa nʼadwumadeɛ so. Ne nnɔbaeɛ baa bebree. ");
INSERT INTO twiasante_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isak yɛɛ ɔdefoɔ. Nʼahonya kɔɔ so dɔɔso, ma ɔdii taamu. ");
INSERT INTO twiasante_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ɔnyaa nnwan, anantwie, ne asomfoɔ bebree, ma ɛyɛɛ saa maa Filistifoɔ no ani beree no yie. Saa anibereɛ yi enti, Filistifoɔ no de dɔteɛ kɔsisii ");
INSERT INTO twiasante_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","abura ahodoɔ a nʼagya Abraham maa ne nkoa tutuu wɔ ne berɛ so no nyinaa ano. ");
INSERT INTO twiasante_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ɛbaa saa no, ɔhene Abimelek ka kyerɛɛ Isak sɛ, “Tu firi yɛn asase so, ɛfiri sɛ, wʼahonya dodoɔ aka yɛn ahyɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isak tu firii Gerar kuro no mu, kɔɔ Gerar subɔnhwa mu de hɔ kɔyɛɛ nʼatenaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Enti, Isak maa ne nkoa sane tutuu mmura a nʼagya Abraham maa ne nkoa tutuiɛ a ne wuo akyiri no, Filistifoɔ no sisii ne nyinaa no. Ɔsane de edin korɔ no ara a nʼagya Abraham de totoo mmura no totoo no bio. ");
INSERT INTO twiasante_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isak nkoa no tuu abura foforɔ bi wɔ Gerar subɔnhwa no mu, kɔtoo nsuo a ɛyɛ korɔgyenn. ");
INSERT INTO twiasante_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Nanso, Gerar nnwanhwɛfoɔ ne Isak nnwanhwɛfoɔ gyee abura no ho akyinnyeɛ. Gerar nnwanhwɛfoɔ no kaa sɛ, “Abura yi yɛ yɛn dea.” Yei maa Isak too saa abura no edin Esek, a aseɛ kyerɛ akyinnyegyeɛ abura. ");
INSERT INTO twiasante_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Isak nkoa no sane tuu abura foforɔ, nanso Gerar nnwanhwɛfoɔ no sane ne wɔn kasakasaa ɛno nso so. Yei maa Isak sane too saa abura no nso edin Sitna, a aseɛ kyerɛ Aperedie. ");
INSERT INTO twiasante_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isak gyaa saa abura no hɔ kɔtuu abura foforɔ. Afei, nnipa a wɔne no te hɔ no gyaee no haw a obiara ne no ankasa so bio. Yei maa Isak too saa abura yi edin Rehobot a aseɛ ne “Afei deɛ Awurade abɔ yɛn atenaseɛ na yɛbɛnya yɛn ho wɔ asase yi so.” ");
INSERT INTO twiasante_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isak tu firii hɔ kɔɔ Beer-Seba. ");
INSERT INTO twiasante_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Anadwo no, Awurade yii ne ho adi kyerɛɛ no, ka kyerɛɛ no sɛ, “Mene wʼagya, Abraham Onyankopɔn. Nsuro, ɛfiri sɛ, me ne wo na ɛwɔ hɔ. Ɛbɔ a mahyɛ mʼakoa Abraham enti, mɛhyira wo, na mama wʼasefoɔ adɔɔso, na wɔayɛ ɔman kɛseɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isak sii afɔrebukyia, somm Awurade wɔ hɔ. Ɔsii ntomadan, tenaa hɔ, na ne nkoa nso tuu abura maa no. ");
INSERT INTO twiasante_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ɛda bi, ɔhene Abimelek ne ne fotufoɔ Ahusad ne ne sahene Pikol firi Gerar bɛsraa Isak. ");
INSERT INTO twiasante_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isak bisaa wɔn sɛ, “Adɛn enti na mo a na mo ne me nka, na mopamoo me firii mo nkyɛn aba me ha ɛnnɛ sɛ morebɛsra me?” ");
INSERT INTO twiasante_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Wɔbuaa no sɛ, “Yɛhunu pefee sɛ Awurade wɔ wʼafa enti, yɛasi gyinaeɛ sɛ, yɛne wo bɛyɛ apam. Apam no bɛda wo ne yɛn ntam. Pene so, na yɛne wo nyɛ saa apam no, ");
INSERT INTO twiasante_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ka yɛn ntam sɛ, worenha yɛn, sɛdeɛ yɛn nso, yɛanha wo no. Yɛne wo tenaa yie. Yɛgyaa wo kwan asomdwoeɛ mu. Afei, hwɛ sɛdeɛ Awurade ahyira wo.” ");
INSERT INTO twiasante_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isak too wɔn ɛpono, na wɔdidi nomeeɛ de twɛn apam a wɔne no rebɛyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Adeɛ kyee anɔpa no, Isak ne mmarima no kekaa wɔn ho wɔn ho ntam, de sii wɔn apam a wɔayɛ no so dua. Afei, Isak gyaa wɔn kwan, ma wɔkɔɔ asomdwoeɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ɛda no ara, Isak asomfoɔ bɛkaa abura a na wɔretu no ho asɛm kyerɛɛ no sɛ, “Yɛato nsuo.” ");
INSERT INTO twiasante_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isak too abura no edin Seba, a aseɛ kyerɛ sɛ “Ntanka abura.” Kuro a akyire no wɔkyekyeree wɔ hɔ no, wɔtoo hɔ edin Beer-Seba a ɛbɛsi ɛnnɛ, wɔda so frɛ hɔ saa ara. ");
INSERT INTO twiasante_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau dii mfeɛ aduanan no, ɔwaree ababaawa bi a na wɔfrɛ no Yudit. Na nʼagya yɛ Hetini bi a ne din de Beeri. Esau sane waree Basmat a nʼagya yɛ Hetini bi a ne din de Elon. ");
INSERT INTO twiasante_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Nanso, Isak ne Rebeka bo annwo saa awadeɛ no so. ");
INSERT INTO twiasante_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isak bɔɔ akɔkoraa a nʼani so ayɛ no wisiwisi na ɔnhunu adeɛ papa no, ɛda koro bi, ɔfrɛɛ ne babarima panin Esau. “Me ba.” Ɛnna Esau gyee so sɛ, “Agya, menie.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak kaa sɛ, “Seesei mabɔ akɔkoraa, na mennim ɛda a mɛwu. ");
INSERT INTO twiasante_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Fa wʼagyan ne wo bɛmma, na kɔ wiram kɔpɛ hanam bi brɛ me. ");
INSERT INTO twiasante_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Fa noa mʼakɔnnɔduane no bi brɛ me, na menni, na menhyira wo ansa na mawu.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ɛberɛ a Isak ne ne ba Esau rekasa no, na Rebeka retie. Enti, ɛberɛ a Esau kɔɔ sɛ ɔrekɔkum ɛnam no aba pɛ, ɛnna ");
INSERT INTO twiasante_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka ka kyerɛɛ ne ba Yakob sɛ, “Yakob tie! Metee sɛ wʼagya reka akyerɛ wo nua Esau sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Kɔpɛ hanam bi fa noa mʼakɔnnɔduane no bi brɛ me, na menni, na menhyira wo wɔ Awurade anim, ansa na mawu.’ ");
INSERT INTO twiasante_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Afei, me ba, tie asɛm a merebɛka akyerɛ wo yi yie, na di so. ");
INSERT INTO twiasante_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kɔ nnwankuo no mu, na kɔkyere nnwan mmienu a wɔadɔre sradeɛ brɛ me, na memfa nnoa akɔnnɔduane, sɛdeɛ wʼagya pɛ no pɛpɛɛpɛ mma no. ");
INSERT INTO twiasante_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Sɛ menoa wie a, fa kɔma no, na ɔnni, na ɔnhyira wo ansa na wawu.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakob ka kyerɛɛ ne maame Rebeka sɛ, “Wonim sɛ me nua Esau ho wɔ nwi, na me nso, me ho yɛ toromtorom. ");
INSERT INTO twiasante_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Sɛ ɛba sɛ mʼagya de ne nsa fa me ho, na ɔhunu sɛ ɛnyɛ Esau a, ɛbɛyɛ sɛ gyama meredaadaa no, na wadome me mmom, sene sɛ anka ɔbɛhyira me.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Yakob maame ka kyerɛɛ no sɛ, “Me ba, ma nnome no mmra me so. Wo deɛ, yɛ deɛ maka akyerɛ wo no ara. Kɔ na kɔkyere nnwan no brɛ me.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Enti, Yakob tiee ne maame Rebeka asɛm, kɔkyeree nnwan no brɛɛ no. Na ɔkumm wɔn, de noaa akɔnnɔduane bi, sɛdeɛ Isak pɛ no pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ɛno akyiri no, Rebeka faa ne ba panin Esau atadeɛ papa bi a ɛwɔ fie hɔ de maa ne ba Yakob hyɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Afei, ɔde nnwan a wɔkumm wɔn no nwoma yɛɛ ahyɛnsa, kataa Yakob nsa ho. Ɔde bi kataa ne kɔn ho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ɔde burodo a wato no foforɔ kaa akɔnnɔduane a wanoa no ho, de maa ne ba Yakob. ");
INSERT INTO twiasante_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakob de aduane no kɔmaa nʼagya Isak wɔ ne dan mu. Ɔduruu hɔ no, ɔkaa sɛ, “Agya!” Isak buaa sɛ, “Mewɔ hɔ na wo hwan a?” ");
INSERT INTO twiasante_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakob ka kyerɛɛ nʼagya sɛ, “Ɛyɛ me wʼabakan Esau. Mayɛ deɛ woka kyerɛɛ me sɛ menyɛ no. Mede hanam a wopɛ no bi anoa wʼakɔnnɔduane no abrɛ wo, enti mesrɛ wo, sɔre tena ase, na didi, na sɛ wodidi wie a, woahyira me.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isak bisaa ne ba no sɛ, “Ɛyɛɛ sɛn na wo ho ayɛ hare sɛɛ yi?” Yakob buaa sɛ, “Awurade, wo Onyankopɔn no, na ɔgyinaa mʼakyi maa me nsa kaa hanam no bi ntɛm.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Afei, Isak ka kyerɛɛ Yakob sɛ, “Me ba, twe bɛn me, na memfa me nsa nka wo nhwɛ sɛ, wo ne me ba Esau no ampa anaa.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakob twe bɛn nʼagya Isak, na ɔde ne nsa kekaa ne ho kaa sɛ, “Nne yi yɛ Yakob nne, nanso nsa yi yɛ Esau deɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isak anhunu sɛ ɛyɛ Yakob, ɛfiri sɛ, na ne nsa ho wɔ nwi te sɛ ne nua Esau pɛpɛɛpɛ. Enti, ɔhyiraa no. ");
INSERT INTO twiasante_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isak sane bisaa Yakob sɛ, “Enti, ampa ara sɛ wo ne me ba Esau no?” Yakob buaa sɛ, “Aane, me ne Esau.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Afei, Isak kaa sɛ, “Me ba, fa wʼaduane no brɛ me na menni, na medi wie a, mahyira wo.” Yakob de aduane no brɛɛ nʼagya Isak, na ɔdiiɛ; ɔsane de nsã brɛɛ no ma ɔnomeeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Isak wieeɛ no, ɔka kyerɛɛ Yakob sɛ, “Me ba, bra bɛfe mʼano!” ");
INSERT INTO twiasante_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Enti, Yakob kɔɔ nʼagya Isak nkyɛn kɔfee nʼano. Ɛberɛ a Isak huaa Yakob atadeɛ mu, na ɔgye too mu sɛ, ɛyɛ ne ba Esau no, ɔhyiraa no sɛ, “Ampa ara! Me ba ho hwa te sɛ ehwa a ɛfiri afuo a Awurade ahyira so no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Onyankopɔn mma wo ɔsoro bosuo ne asase mu sradeɛ, na afuom aduane ne nsã mmu wo so. ");
INSERT INTO twiasante_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Amanaman bɛsom wo, na nnipa nyinaa abu wo nkotodwe. Wobɛdi wo nuanom so, na wo maame mma nso akoto wo. Wɔbɛdome wɔn a wɔdome wo nyinaa, na wɔn a wɔhyira wo nyinaa nso, wɔbɛhyira wɔn.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak hyiraa Yakob wieeɛ, na ɔfirii nʼagya nkyɛn kɔeɛ ara pɛ, na ne nua Esau firi nʼahayɔ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ɔno nso noaa akɔnnɔduane brɛɛ nʼagya. Na ɔka kyerɛɛ no sɛ, “Agya, sɔre na di me hanamduane no, na hyira me.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Nʼagya Isak bisaa no sɛ, “Na hwan nie?” Esau buaa sɛ, “Ɛyɛ me wʼabakan Esau.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isak tee saa asɛm yi pɛ, ne ho hyɛɛ aseɛ wosoo biribiribiri, na ɔbisaa sɛ, “Ɛnneɛ, na hwan na ɔkɔɔ ahayɔ kɔkumm ɛnam de noaa aduane brɛɛ me yi. Medidi wieeɛ hyiraa onipa ko no pɛ na wobaeɛ yi? Nokorɛ mu ni, nhyira a mahyira no no, sɛ mesane mʼano a, ɛrenyɛ yie!” ");
INSERT INTO twiasante_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ɛberɛ a Esau tee asɛm a nʼagya kaeɛ no, ɔno nso de awerɛhoɔ teaam dendeenden, ka kyerɛɛ nʼagya sɛ, “Agya! Hyira me. Hyira me nso bi!” ");
INSERT INTO twiasante_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Nanso, Isak kaa sɛ, “Ɛnneɛ, na wo nua na ɔde nnaadaa abɛgye wo nhyira kɔ!” ");
INSERT INTO twiasante_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau kaa sɛ, “Ɛnyɛ nwanwa sɛ wɔfrɛ no Yakob a aseɛ kyerɛ nantitwitwafoɔ. Yei ne ne mprenu so a wadaadaa me. Deɛ ɛdi ɛkan ne sɛ, ɔdaadaa me gyee me panin. Deɛ ɛtɔ so mmienu nso ne sɛ, ɔde nnaadaa agye me nhyira!” Afei, Esau bisaa nʼagya sɛ, “Enti, woannya me nhyira no bi a wode bɛhyira me nso?” ");
INSERT INTO twiasante_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak buaa Esau sɛ, “Manya de no ayɛ wo wura dada. Mede ne nuanom nyinaa ayɛ ne nkoa. Mahyira no sɛ, ɔbɛnya afuom nnuane ne nsã foforɔ bebree. Na afei, ɛdeɛn bio na aka a mɛtumi ayɛ ama wo, me ba?” ");
INSERT INTO twiasante_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau bisaa nʼagya sɛ, “Agya, enti nhyira baako pɛ na wowɔ? Ao, agya, hyira me nso bi!” ");
INSERT INTO twiasante_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Afei, nʼagya Isak buaa no sɛ, “Tie! Asase kesee so na wobɛtena, na ɛsoro bosuo rentɔ wɔ so. ");
INSERT INTO twiasante_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Wode wo akofena na ɛbɛtena ase, na woasom wo nua kumaa. Nanso, daakye bi, sɛ wokentene wo ho a, wobɛfiri wo nua no som ase.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esiane Esau nhyira a Yakob kɔdaadaa wɔn agya Isak gyeeɛ no enti, Esau tanee Yakob. Esau kaa wɔ ne tirim sɛ, “Ɛrenkyɛre, na mʼagya Isak awu. Sɛ ɔnya wu a, mɛkum me nua Yakob.” ");
INSERT INTO twiasante_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Obi tee adwene a Esau afa wɔ ne nua kumaa Yakob ho no, ɔkɔbɔɔ wɔn maame Rebeka amanneɛ. Enti, Rebeka soma kɔfrɛɛ ne ba kumaa Yakob, na ɔka kyerɛɛ no sɛ, “Wo nua Esau abɔ ne tirim sɛ, sɛ ɔnya wo a, ɔbɛkum wo ansa na ne bo atɔ ne yam. ");
INSERT INTO twiasante_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Enti, me ba, tie asɛm a merebɛka akyerɛ wo yi yie. Dwane ntɛm kɔ me nua Laban nkyɛn wɔ Haran. ");
INSERT INTO twiasante_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Tena ne nkyɛn kakra wɔ hɔ, kɔsi sɛ, wo nua Esau bo bɛdwo. ");
INSERT INTO twiasante_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Sɛ wo nua akoma tɔ ne yam, na ne werɛ firi deɛ woyɛɛ no, na ɔgyaa mu ma ɛka a, mɛsoma abɛka akyerɛ wo, na woafiri Haran aba. Adɛn enti na ɛsɛ sɛ metena hɔ hwɛ, na me mma baanu bom wu ɛda koro?” ");
INSERT INTO twiasante_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Enti, Rebeka ka kyerɛɛ Isak sɛ, “Saa Hetifoɔ mmabaawa yi koraa ama asetena afono me. Sɛ ɛkɔba sɛ Yakob nso kɔware Hetifoɔ asase so mmabaawa yi bi a, mmaa te sɛ yeinom bi a, ɛnneɛ, na mewuiɛ koraa a, anka ɛyɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isak frɛɛ Yakob, hyiraa no hyɛɛ no sɛ, “Nware saa Kanaanfoɔ mmaa yi bi da. ");
INSERT INTO twiasante_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ka wo ho kɔ Betuel a ɔyɛ wo maame Rebeka agya no nkyɛn wɔ Paddan-Aram, na kɔware wo wɔfa Laban mmammaa no mu baako. ");
INSERT INTO twiasante_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Otumfoɔ Onyankopɔn no nhyira wo. Ɔmma wʼase nnɔre bebree, na wʼasefoɔ no abɛyɛ ɔman kɛseɛ a mmusuakuo bebree bɛfiri mu aba. ");
INSERT INTO twiasante_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Onyankopɔn mfa nhyira a ɔde hyiraa Abraham no nhyira wo ne wʼasefoɔ. Ɔmma asase a ɛnnɛ wote so sɛ ɔhɔhoɔ yi a ɛyɛ asase a Onyankopɔn de maa Abraham no nyɛ wo dea.” ");
INSERT INTO twiasante_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Sɛdeɛ Isak gyaa ne ba Yakob ɛkwan nie: Yakob kɔɔ Laban a ɔyɛ Aramni Betuel babarima nkyɛn wɔ Paddan-Aram. Na saa Laban yi yɛ Esau ne Yakob maame Rebeka nuabarima. ");
INSERT INTO twiasante_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau tee sɛ Isak ahyira Yakob, na wagya no kwan ma ɔkɔ Paddan-Aram sɛ ɔnkɔware wɔ hɔ. Ɔhyiraa no no, ɔhyɛɛ no sɛ, “Nware saa Kanaanfoɔ mmaa yi bi da.” ");
INSERT INTO twiasante_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yakob tiee nʼagya ne ne maame afotuo no siim kɔɔ Paddan-Aram. ");
INSERT INTO twiasante_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau hunuu sɛ nʼagya Isak mpɛ Kanaanfoɔ mmaa asɛm. ");
INSERT INTO twiasante_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Enti, ɔsiim kɔɔ Abraham babarima Ismael nkyɛn, kɔwaree ne babaa Mahalat. Na Mahalat yɛ Nebaiot nuabaa, na ɔyɛ Ismael a ɔno nso yɛ Abraham babarima babaa. Esau waree Mahalat kaa ne yerenom ho. ");
INSERT INTO twiasante_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakob firii Beer-Seba de nʼani kyerɛɛ Haran. ");
INSERT INTO twiasante_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ɔduruu baabi na onwunu redwoɔ no, ɔpɛɛ baabi soɛeɛ, ɛfiri sɛ, na adeɛ resa. Ɔfaa ɛboɔ bi wɔ baabi a waduru hɔ de yɛɛ sumiiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ɔdaeɛ no, ɔsoo daeɛ bi. Daeɛ no mu, ɔhunuu sɛ atwedeɛ bi si fam a nʼatifi ka ewiem, na Onyankopɔn abɔfoɔ redi so aforosiane. ");
INSERT INTO twiasante_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ɔhunuu sɛ Onyankopɔn gyina atwedeɛ no atifi. Onyankopɔn ka kyerɛɛ no sɛ, “Mene Awurade, Abraham Onyankopɔn, ne wʼagya Isak Onyankopɔn. Mede asase a woda so yi bɛma wo ne wʼasefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Wʼasefoɔ bɛyɛ sɛ asase so mfuturo, na mobɛtrɛtrɛ akɔ apueeɛ ne atɔeɛ, atifi ne anafoɔ nyinaa. Wo ne wʼasefoɔ mu na wɔfiri bɛhyira ewiase mmusuakuo nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Yeinom nyinaa akyiri no, mɛka wo ho, na baabiara a wobɛkɔ no, mɛdi wʼakyi, na mɛsane de wo aba saa asase yi so. Merennyaa wo da, kɔsi sɛ ɛbɔ a mahyɛ wo yi nyinaa bɛba mu.” ");
INSERT INTO twiasante_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakob nyaneeɛ no, ɔkaa wɔ ne tirim sɛ, “Ampa ara, sɛɛ na Awurade wɔ saa beaeɛ ha yi, a na mennim!” ");
INSERT INTO twiasante_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakob suroeɛ, na ɔkɔɔ so kaa wɔ ne tirim sɛ, “Ɛha yɛ hu papa. Ɛha nyɛ baabiara sɛ Onyankopɔn fie. Ɔsoro ɛpono ano ne ha.” ");
INSERT INTO twiasante_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Enti, Yakob sɔree anɔpatutuutu maa ɛboɔ a ɔde yɛɛ sumiiɛ no so sii hɔ, hwiee ngo guu so. ");
INSERT INTO twiasante_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ɔtoo beaeɛ no edin Bet-El a aseɛ kyerɛ Onyame fie. Kane no na anka wɔfrɛ saa kuro no Lus. ");
INSERT INTO twiasante_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Afei, Yakob kaa ntam sɛ, “Sɛ Onyankopɔn bɛka me ho, ahwɛ me so wɔ saa akwantuo yi mu, ama me aduane adi, ama me ntoma afira, ");
INSERT INTO twiasante_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","sɛdeɛ ɛbɛyɛ a mɛsane aba mʼagya fie asomdwoeɛ mu a, ɛnneɛ, Awurade bɛyɛ me Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Saa ɛboɔ a mede asi hɔ sɛ nkaeɛdum yi bɛyɛ Onyankopɔn fie. Biribiara a wo, Onyankopɔn, de bɛma me no, mede mu nkyɛmu edu mu baako bɛma wo.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakob toaa nʼakwantuo so kɔduruu apueeɛfoɔ asase so. ");
INSERT INTO twiasante_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Asase no so baabi na ɔkɔhunuu abura bi a nnwankuo mmiɛnsa butubutu ho. Ɛfiri sɛ, saa abura no mu nsuo na wɔsa ma nnwan no nom. Na ɛboɔ kɛseɛ bi na ɛkata abura no so. ");
INSERT INTO twiasante_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ɛberɛ biara a nnwankuo no bɛboa wɔn ho ano wɔ hɔ no, nnwanhwɛfoɔ no pire ɛboɔ no firi abura no ano ma nnwan no nsuo nom. Sɛ nnwan no nom nsuo no wie a, na nnwanhwɛfoɔ no asane de ɛboɔ no akata abura no ano. ");
INSERT INTO twiasante_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakob bisaa wɔn sɛ, “Anuanom, mofiri he na mobaa ha?” Wɔbuaa Yakob sɛ, “Yɛfiri Haran.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakob sane bisaa wɔn sɛ, “Monim Nahor nana Laban anaa?” Nnwanhwɛfoɔ no nso buaa no sɛ, “Aane, yɛnim no.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Afei, Yakob bisaa wɔn sɛ, “Na ne ho te sɛn?” Wɔbuaa no sɛ, “Ne ho yɛ. Na ne babaa Rahel koraa na ɔne ne nnwan reba yi.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakob kaa sɛ, “Monhwɛ. Owia no ano yɛ den dodo. Ɛberɛ a ɛsɛ sɛ wɔboaboa mmoa no ano nnuruiɛ. Momma wɔn nsuo nnom, na monka wɔn nkɔ wɔn adidibea.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nnwanhwɛfoɔ no buaa Yakob sɛ, “Sɛ yɛmmoaboaa nnwan no nyinaa ano, na yɛmpiree ɛboɔ no mfirii abura no ano a, yɛrentumi mma wɔn nsuo nnom.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakob gu so ne wɔn rekasa no ara na Rahel a ɔno nso yɛ odwanhwɛfoɔ no de nʼagya nnwan baa hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ɛberɛ a Yakob hunuu ne maame nuabarima Laban babaa Rahel ne ne wɔfa Laban nnwan no, ɔkɔpiree ɛboɔ no firii abura no ano. Afei, wɔmaa nnwan no nsuo nomeeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Afei, Yakob fee Rahel ano, na ɔsuiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Na Yakob aka akyerɛ Rahel sɛ, ɔno Yakob yɛ Rahel no agya busuani a ɔsane yɛ nʼagya Laban no nuabaa Rebeka babarima. Enti, Rahel tuu mmirika kɔka kyerɛɛ nʼagya. ");
INSERT INTO twiasante_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban tee ne nuabaa Rebeka ba Yakob ho asɛm no, ɔyɛɛ ntɛm kɔhyiaa no. Laban yɛɛ no atuu, fee nʼano, de no baa ne fie, maa Yakob bɔɔ no nʼananteseɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban ka kyerɛɛ no sɛ, nokorɛ ni, “woyɛ me busuani.” Na Yakob tenaa Laban nkyɛn bosome. ");
INSERT INTO twiasante_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ɛda koro bi, Laban ka kyerɛɛ Yakob sɛ, “Ɛwom sɛ woyɛ me busuani deɛ, nanso ɛno nkyerɛ sɛ, sɛ woyɛ adwuma ma me a ɛnsɛ sɛ metua wo ka. Kyerɛ me akatua a wopɛ na memfa mma wo.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Na Laban wɔ mmammaa baanu. Na ɔpanin no din de Lea ɛnna akumaa no nso de Rahel. ");
INSERT INTO twiasante_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Na Lea aniwa aba yɛ fɛ, ɛnna Rahel yɛ ɔbaa fɛfɛ a nʼanim yɛ nyam yie. ");
INSERT INTO twiasante_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Na Yakob dɔ Rahel awadeɛ kwan so, enti ɔka kyerɛɛ Rahel agya Laban sɛ, “Sɛ wode wo babaa kumaa Rahel bɛma me aware a, anka me nso mɛsom wo mfeɛ nson.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban kaa sɛ, “Mepene so! Ɛyɛ sɛ mede no bɛma wo aware mmom sene sɛ mede no bɛma obi foforɔ bi a mennim no. Enti, tena me nkyɛn.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Esiane ɔdɔ a na Yakob dɔ Rahel enti, ɔsomm Laban mfeɛ nson, na wanhunu koraa sɛ, wasom akyɛre saa. Ɛyɛɛ no sɛ gyama ɔsomee nnansa bi pɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yakob som wieeɛ no, ɔka kyerɛɛ Laban sɛ, “Masom awie enti, fa Rahel ma me na menware no.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ɛno enti, Laban too ɛpono kɛseɛ, na ɔtoo nsa frɛɛ nnipa a na ɔne wɔn wɔ hɔ nyinaa baa apontoɔ no ase. ");
INSERT INTO twiasante_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Na ɛduruu anadwo a esum aduru no, Laban de ne babaa Lea kɔmaa Yakob, maa ɔne no daeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ɛno akyiri no, Laban de nʼafenawa Silpa kaa Lea ho sɛ ɔnkɔsom no. ");
INSERT INTO twiasante_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Adeɛ kyeeɛ no, ɔhunuu sɛ Lea mmom na ɔda nʼakyi. Ɛnna Yakob bisaa Laban sɛ, “Asɛm bɛn na wo ne me adi yi? Ɛnyɛ Rahel enti na mesom wo? Adɛn enti na woadaadaa me sei?” ");
INSERT INTO twiasante_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban buaa Yakob sɛ, “Ɛha deɛ, ɛnyɛ yɛn amanneɛ sɛ yɛde ɔbabaa kumaa ma aware wɔ ɛberɛ a ɔpanin no nwareeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ma Lea nni nnawɔtwe wɔ wo nkyɛn, na nnawɔtwe no akyiri no, sɛ wopɛ Rahel ara a, mɛma woasane asom mfirinhyia nson bio, na mede no ama wo aware.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakob penee so ne Lea tenaa nnawɔtwe. Ɛno akyiri, ɔsomm mfeɛ nson ansa na Laban de ne babaa Rahel nso maa no wareeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban de nʼafenawa Bilha nso maa ne babaa Rahel sɛ ɔnkɔsom no. ");
INSERT INTO twiasante_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakob de ne ho kaa Rahel nso. Na ɔdɔ Rahel sene Lea. Yakob tenaa Laban nkyɛn, somm no mfirinhyia nson bio sɛdeɛ ɔne no hyehyɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Awurade hunuu sɛ Yakob ani nnye Lea ho no, ɔbuee ne yafunu mu, nanso Rahel deɛ, na ɔnwo. ");
INSERT INTO twiasante_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea nyinsɛneeɛ, woo ɔbabarima. Ɔtoo no edin Ruben a asekyerɛ ne “Awurade ahunu mmɔborɔ a meyɛ.” Na Lea kaa sɛ, “Awurade ahunu me mmɔbɔ. Nokorɛm, afei na me kunu ani bɛgye me ho.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea nyinsɛnee bio na ɔsane woo ɔbabarima bio no, ɔkaa sɛ, “Esiane sɛ Awurade hunuu sɛ me kunu ani nnye me ho enti, wasane akyɛ me ɔbabarima bio.” Enti, ɔtoo ne din Simeon a asekyerɛ ne “Awurade ate!” ");
INSERT INTO twiasante_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lea sane nyinsɛnee bio. Na ɔwoo ɔbabarima bio no, ɔkaa sɛ, “Afei deɛ, me kunu de ne ho bɛfam me ho, ɛfiri sɛ, mawo mmammarima baasa ama no.” Ɛno enti, ɔtoo no edin Lewi a asekyerɛ ne “Ahofam.” ");
INSERT INTO twiasante_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lea sane nyinsɛnee. Ɛberɛ a ɔsane woo ɔbabarima bio no, ɔkaa sɛ, “Saa ɛberɛ yi deɛ, mɛkamfo Awurade.” Ɛno enti, ɔtoo no edin Yuda, a asekyerɛ ne “Nkamfoɔ.” Yei akyiri no, ɔhomee awoɔ so. ");
INSERT INTO twiasante_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ɛberɛ a Rahel hunuu sɛ ɔne Yakob nwo no, nʼani beree ne nuabaa no. Enti, ɔka kyerɛɛ Yakob sɛ, “Sɛ wo ne me anwo mma a, mɛwu!” ");
INSERT INTO twiasante_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakob bo fuu Rahel, ma ɔkaa sɛ, “Meyɛ Onyankopɔn? Ɔno na wasi wo yafunu ano.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ɛnna Rahel ka kyerɛɛ Yakob sɛ, “Mʼafenaa Bilha nie, wo ne no nkɔda, na ɔnwo mma me, na ɛnam ne so ama me nso manya abusua.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Enti, Rahel de nʼafenaa Bilha maa Yakob wareeɛ. Yakob ne no daeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ɔnyinsɛn, woo babarima maa Yakob. ");
INSERT INTO twiasante_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Na Rahel kaa sɛ, “Onyankopɔn adi mʼasɛm ama me. Wate mʼadesrɛ ama me ɔbabarima.” Ne saa enti, ɔtoo no edin Dan a asekyerɛ ne, “Onyankopɔn adi mʼasɛm ama me.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahel afenaa Bilha nyinsɛnee bio, woo ɔbabarima a ɔtɔ so mmienu maa Yakob. ");
INSERT INTO twiasante_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Na Rahel kaa sɛ, “Me ne me nua Lea adi yɛn ho aperedie na madi nkonim.” Ɛno enti, ɔtoo abɔfra no edin Naftali a asekyerɛ ne, “Mʼakodie.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ɛberɛ a Lea hunuu sɛ nʼawoɔ ate kɔ no, ɔno nso de nʼafenaa Silpa maa Yakob wareeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Lea afenaa Silpa woo ɔbabarima maa Yakob. ");
INSERT INTO twiasante_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Na Lea kaa sɛ, “Akrayɛ bɛn nie.” Enti, ɔtoo abɔfra no edin Gad a asekyerɛ ne, “Asi me yie.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Lea afenaa Silpa woo ɔbabarima a ɔtɔ so mmienu maa Yakob. ");
INSERT INTO twiasante_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Na Lea kaa sɛ, “Mʼani agye! Afei deɛ, mmaa no bɛfrɛ me anigyeɛ.” Enti, ɔtoo no edin Aser a asekyerɛ ne “Anigyeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ayuotwaberɛ mu ɛda bi, Ruben kɔɔ afuom kɔhunuu afifideɛ bi a wɔfrɛ no dudaim. Ɔde bi brɛɛ ne maame Lea. Rahel ka kyerɛɛ Lea sɛ, “Mesrɛ wo, ma me wo ba no dudaim no bi.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Nanso, Lea de abufuo buaa sɛ, “Woabɛgye me kunu akyiri no, woresane abɛgye me ba dudaim a ɔde abrɛ me no bi apaa so?” Na Rahel de awerɛhoɔ kaa sɛ, “Ɛyɛ, ɛnneɛ, Yakob mmɛda wo nkyɛn ɛnnɛ anadwo yi, na ma me dudaim no bi.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Enti, ɛda no anwummerɛ a Yakob firi afuom reba no, Lea kɔhyiaa no, ka kyerɛɛ no sɛ, “Ɛsɛ sɛ wobɛda me nkyɛn ɛnnɛ anadwo yi, ɛfiri sɛ, mede me ba dudaim atɔ wo.” Enti, Yakob kɔdaa Lea nkyɛn anadwo no. ");
INSERT INTO twiasante_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Onyankopɔn tiee Lea mpaeɛbɔ, na ɔnyinsɛn, woo ɔbabarima a ɔtɔ so enum maa Yakob. ");
INSERT INTO twiasante_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Na Lea kaa sɛ, “Mede mʼafenaa Silpa maa me kunu Yakob no, Onyankopɔn adom me.” Enti, wɔtoo abɔfra no edin Isakar a asekyerɛ ne “Akyɛdeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea sane nyinsɛnee bio, na ɔwoo ne babarima a ɔtɔ so nsia maa Yakob. ");
INSERT INTO twiasante_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Enti, Lea kaa sɛ, “Onyankopɔn akyɛ me akyɛdeɛ a ɛsom bo yie. Afei deɛ, manya me kunu anim animuonyam. Ɔde obuo ne anidie bɛma me, ɛfiri sɛ, mawo mmammarima baasia ama no. Enti, ɔtoo abarimaa no edin Sebulon a, asekyerɛ ne Animuonyam.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Akyire no, Lea woo ɔbabaa too no edin Dina. ");
INSERT INTO twiasante_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Afei, Onyankopɔn kaee Rahel, tiee ne mpaeɛbɔ, buee nʼawotwaa ano. ");
INSERT INTO twiasante_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rahel nyinsɛne, woo ɔbabarima, na ɔkaa sɛ, “Afei deɛ, Onyankopɔn apepa mʼanimguaseɛ, ama me nso mawo ɔba.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Rahel too ne ba no edin Yosef a asekyerɛ ne “Awurade mfa ɔbabarima baako nka me ho.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rahel woo Yosef no, ankyɛre na ɛda koro bi, Yakob ka kyerɛɛ Laban sɛ, “Mepɛ sɛ mesane kɔ mʼankasa mʼasase so ne me fie enti, mesrɛ wo, gya me ɛkwan na menkɔ, ");
INSERT INTO twiasante_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Fa me yerenom ne me mma a wɔn enti mebɛsom wo no ka ho. Wʼankasa ara wonim ɔsom pa a masom wo.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban buaa sɛ, “Mesrɛ wo, nkɔ nnya me. Makɔ abisa ahunu sɛ, nhyira dodoɔ a manya yi nyinaa firi te a wote me nkyɛn yi so.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Laban ka kaa ho sɛ, “Kyerɛ me akatua biara a wobɛgye, na mɛtua.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakob buaa Laban sɛ, “Wʼankasa wonim som a masom wo, ne sɛdeɛ mahwɛ wʼanantwie ne wo nnwan ama wɔn ase afɛe afa. ");
INSERT INTO twiasante_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Wʼahodeɛ kakra a na wowɔ ɛberɛ a mebaeɛ no, ɛnnɛ, adɔɔso, abu so. Biribiara a meyɛ maa wo no nso, Awurade ahyira so. Na me nso, ɛberɛ bɛn na mɛtumi apɛ biribi de agya mʼabusuafoɔ?” ");
INSERT INTO twiasante_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban bisaa Yakob sɛ, “Akatua ahe na memfa mma wo?” Yakob nso buaa sɛ, “Mma me hwee, na mmom, sɛ wobɛyɛ mʼabisadeɛ baako pɛ yi ama me deɛ a, mɛkɔ so ayɛn wo mmoa no. ");
INSERT INTO twiasante_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ɛnnɛ, ma menkɔhwehwɛ wo mmoa no nyinaa mu, na mennyi odwan biara a ne ho yɛ ntokontrama, odwan ba biara a ɔyɛ tuntum ne abirekyie biara a ɔyɛ ntokontrama. Yeinom na ɛbɛyɛ mʼakatua. ");
INSERT INTO twiasante_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Yei bɛma woahunu sɛ, medi nokorɛ anaa menni nokorɛ. Sɛ wohunu nnwan anaa mmirekyie a wɔyɛ fufuo, na wɔnyɛ ntokontrama wɔ me mmoa no mu a, na ɛkyerɛ sɛ mawia wɔn afiri wo deɛ mu.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban buaa Yakob sɛ, “Ɛyɛ, yɛ no sɛdeɛ woaka no.” ");
INSERT INTO twiasante_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ɛda no ara, Laban yiyii nnwennini a wɔyɛ ntokontrama no nyinaa ne nnwammedeɛ a wɔyɛ ntokontrama no nso; mmoa no mu biara a fufuo wɔ ne ho ne odwan ba biara a ɔyɛ tuntum no, ɔde wɔn kɔmaa ne mmammarima. ");
INSERT INTO twiasante_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Na Laban mma no faa mmoa no, de wɔn twaa nnansa ɛkwan, firii baabi a na Yakob wɔ hɔ. Saa ɛberɛ no mu, Yakob tenaa hɔ, hwɛɛ Laban nnwan no. ");
INSERT INTO twiasante_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Na Yakob faa saa nnua yi: ɔsɛsɛ, ɛdwono ne ɔkyɛnkyɛn mman mono, yiyii ho akamakam, ma ɛkɔtoo dua kwatii no. ");
INSERT INTO twiasante_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Afei, ɔde mman mono a wayiyi ho no nyinaa guguu mmoa no adidi nnaka mu, sɛdeɛ ɛba sɛ, mmoa no ba sɛ wɔrebɛnom nsuo no bi a, wɔbɛhunu. Saa ɛberɛ no na anini no foro abereɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Enti, sɛ mmoa no hyia mu wɔ dua mman ntokontrama no ho, na wɔnyinsɛn na wɔwowo a, wɔn mma no ho yɛ ntokontrama. ");
INSERT INTO twiasante_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ɔnam saa ɛkwan yi so yii Laban nnwankuo no mu abereɛ no guu faako, ma ɛkaa anini no. Na ɔmaa wɔne Yakob nnwan a wɔyɛ tuntum no hyiaa mu. Saa ɛkwan yi so na ɔfa gyinaa ne nnwankuo firii Laban deɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ɛduru ɛberɛ a nnwammedeɛ a wɔwɔ ahoɔden no pɛ sɛ wɔhyia nnwennini no a, Yakob de mman a wayiyi ho akamakam no gu wɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Nanso, wanyɛ nnwan abereɛ a wɔyɛ mmerɛ no saa. Enti, nnwammaa a wɔnni ahoɔden no bɛyɛɛ Laban dea, ɛnna wɔn a wɔwɔ ahoɔden no nso bɛyɛɛ Yakob dea. ");
INSERT INTO twiasante_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ɛnam yei so maa Yakob nyaa ne ho tam. Ɔnyaa mmoa, mfenaa, nkoa, nyoma ne mfunumu bebree. ");
INSERT INTO twiasante_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakob tee sɛ Laban mmammarima no reka sɛ, “Yakob afa yɛn agya ho nneɛma nyinaa. Nʼahonya nyinaa firi yɛn agya nneɛma a wafa no.” ");
INSERT INTO twiasante_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakob hunuu sɛ, afei deɛ, Laban nte nʼanim nkyerɛ no sɛ kane no. ");
INSERT INTO twiasante_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Afei, Awurade ka kyerɛɛ Yakob sɛ, “Sane kɔ wʼabusuafoɔ ne wo nkurɔfoɔ asase so, na mɛdi wʼakyi.” ");
INSERT INTO twiasante_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Enti, Yakob soma ma wɔkɔfrɛɛ ne yerenom Rahel ne Lea sɛ, wɔmmra ne nkyɛn wɔ ɛserɛ no so, faako a ɔne ne nnwankuo no wɔ no. ");
INSERT INTO twiasante_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Wɔbaeɛ no, ɔka kyerɛɛ wɔn sɛ, “Mahunu sɛ, afei deɛ, mo agya Laban anim nyɛ me fɛ sɛ kane no, nanso Onyankopɔn a mʼagya Isak somm no no ka me ho. ");
INSERT INTO twiasante_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Monim sɛ, mayi me yam, de mʼahoɔden nyinaa ayɛ adwuma, ama mo agya; ");
INSERT INTO twiasante_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","nanso mo agya nam nsisie kwan so, asesa mʼakatua mu mprɛdu. Nanso, yei nyinaa akyiri, Onyankopɔn amma no ɛkwan amma wanyɛ me bɔne. ");
INSERT INTO twiasante_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Sɛ ɔka sɛ, ‘Mmoa a wɔn ho yɛ ntokontrama no bɛyɛ wʼakatua,’ na sɛ mmoa no wo a, na wɔawo mma a wɔn ho yɛ ntokontrama. Sɛ ɔka sɛ, ‘Mmoa a wɔn ho yɛ nsensaneɛ no bɛyɛ wʼakatua’ a, na wɔawowo mma a wɔn ho yɛ nsensaneɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ɛkwan a Onyankopɔn nam so agye mo agya nsam nyɛmmoa no de wɔn ama me ama mayɛ ɔdefoɔ no ne no. ");
INSERT INTO twiasante_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Ɛduruu ɛberɛ a mmoa no hyiam no, mesoo daeɛ hunuu sɛ, nnwennini a wɔforo nnwammedeɛ no ho yɛ ntokontrama, nsensaneɛ anaa nsisimu. ");
INSERT INTO twiasante_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Onyankopɔn ɔbɔfoɔ frɛɛ me wɔ daeɛ no mu ka kyerɛɛ me sɛ, ‘Yakob!’ Ɛnna megyee so sɛ, ‘Me nie!’ ");
INSERT INTO twiasante_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ɛnna ɔsoro abɔfoɔ no ka kyerɛɛ me sɛ, ‘Hwɛ na hunu sɛ, nnwennini a wɔforo nnwammedeɛ no nyinaa ho yɛ nsensaneɛ, ntokontrama anaa nsisimu, na mahunu ɛkwan a Laban de wo fa so no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mene Onyankopɔn a meyii me ho adi kyerɛɛ wo wɔ Bet-El, beaeɛ a wode ɛboɔ sii hɔ, hwiee ngo guu so, somm me, hyɛɛ me bɔ sɛ, wobɛsom me no. Afei, tu firi saa asase yi so ntɛm ara, na sane kɔ asase a wɔwoo wo wɔ so no so.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Na Rahel ne Lea bisaa sɛ, “Enti, saa tebea a yɛwɔ mu yi, yɛwɔ kyɛfa bi wɔ yɛn agya agyapadeɛ mu anaa? ");
INSERT INTO twiasante_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Yɛn agya mfa yɛn sɛ yɛyɛ ahɔhoɔ? Watɔn yɛn, na yɛn tiri sika a ɔgyeeɛ no nso, wadi. ");
INSERT INTO twiasante_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ɛyɛ nokorɛ turodoo sɛ, yɛn agya ahodeɛ a Onyankopɔn gyeeɛ no nyinaa yɛ yɛn ne yɛn mma dea. Enti, biribiara a Onyankopɔn aka akyerɛ wo sɛ yɛ no, yɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ɛda bi, Yakob de ne mma ne ne yerenom tenatenaa nyoma so. ");
INSERT INTO twiasante_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ɔkaa ne mmoa nyinaa, agyapadeɛ a wanya nyinaa ne mmoa a ɔnyaa wɔ Paddan-Aram nyinaa dii nʼanim sɛ, ɔrekɔ nʼagya Isak nkyɛn wɔ Kanaan asase so. ");
INSERT INTO twiasante_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ɛberɛ a Laban kɔɔ wiram sɛ ɔrekɔtwitwa ne nnwan ho nwi no, Rahel faa nʼakyi kɔwiaa nʼagya fie abosom. ");
INSERT INTO twiasante_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakob daadaa Aramni Laban a wamma wanhunu sɛ, ɔredwane. ");
INSERT INTO twiasante_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yakob de nʼahodeɛ nyinaa dwaneeɛ. Ɔtwaa Asubɔnten Eufrate, de nʼani kyerɛɛ bepɔ asase Gilead no so. ");
INSERT INTO twiasante_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Yakob ne nʼabusuafoɔ dwaneeɛ no, nnansa akyiri ansa na Laban tee sɛ wɔkɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban faa ne fiefoɔ, kaa ne ho, de anibereɛ tii Yakob. Nnanson akyiri ansa na ɔkɔtoo Yakob ne ne nkurɔfoɔ no wɔ bepɔ Gilead so. ");
INSERT INTO twiasante_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Saa ɛda no ara anadwo, Onyankopɔn yii ne ho adi wɔ daeɛ mu kyerɛɛ Aramni Laban. Ɔka kyerɛɛ no wɔ daeɛ no mu sɛ, “Hwɛ yie na woankɔka asɛm biara, sɛ ɛyɛ asɛm pa anaa asɛmmɔne ankyerɛ Yakob.” ");
INSERT INTO twiasante_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ɛberɛ a Laban ne ne fiefoɔ kɔtoo Yakob no, na Yakob asisi ne ntomadan wɔ bepɔ Gilead atifi. Laban ne ne fiefoɔ no nso sisii wɔn ntomadan wɔ bepɔ no ayaase. ");
INSERT INTO twiasante_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Afei, Laban kɔɔ Yakob nkyɛn kɔbisaa no sɛ, “Woadaadaa me. Asɛm bɛn na wode adi me yi? Woakyekyere me mmammaa de wɔn redwane te sɛ nnommumfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Adɛn enti na wodaadaa me, na wodwane firii me nkyɛn a woankra? Sɛ wokraa me a, anka mɛto wo ɛpono, na mama nnipa abɛbɔ sankuo, ato nnwom wɔ apontoɔ no ase, de agya wo kwan. ");
INSERT INTO twiasante_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Woamma mankyeakyea me nananom ne me mmammaa yi nsam mpo, amfa annya wɔn kwan. Woadi nkwaseasɛm. ");
INSERT INTO twiasante_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mewɔ tumi sɛ anka meyɛ wo bɔne, nanso, nnora anadwo, Onyankopɔn a wo agya somm no no ka kyerɛɛ me wɔ daeɛ mu sɛ, ‘Hwɛ yie na woanka asɛm biara, sɛ ɛyɛ asɛm pa anaa asɛmmɔne, ankyerɛ Yakob.’ ");
INSERT INTO twiasante_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Esiane sɛ wʼani agyina wo agya fie enti, na ɛsɛ sɛ wokɔ ara, na adɛn enti na wowiaa mʼabosom, de kaa wo nneɛma ho?” ");
INSERT INTO twiasante_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakob buaa Laban sɛ, “Na mesuro. Na ɛyɛ me sɛ wode tumi bɛgye wo mmammaa no afiri me nsam. ");
INSERT INTO twiasante_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nanso, obiara a wobɛhunu wʼabosom no wɔ ne nkyɛn no, ɔsɛ owuo. Wʼankasa hwehwɛ, sɛ wobɛhunu biribiara a ɛyɛ wo dea wɔ me nneɛma yi mu wɔ yɛn nuanom yi anim. Sɛ wohunu biribiara a ɛyɛ wo dea a, fa wʼadeɛ.” Ɛberɛ a Yakob kaa saa asɛm yi no, na ɔnnim sɛ Rahel na wawia nʼagya Laban abosom no. ");
INSERT INTO twiasante_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ɛno enti, Laban kɔɔ Yakob, Lea, ne nʼasomfoɔ Bilha ne Silpa ntomadan mu kɔhwehwɛɛ hɔ, nanso wanhunu biribiara. Afei, ɔkɔwuraa Rahel ntomadan mu. ");
INSERT INTO twiasante_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ɛfiri sɛ, na Rahel awia abosom no de ahyehyɛ ne yoma no atɛ ase, atena so. Enti, Laban kɔhwehwɛɛ nneɛma a ɛwɔ Rahel ntomadan no nyinaa mu, nanso wanhunu abosom no. ");
INSERT INTO twiasante_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Afei, Rahel ka kyerɛɛ nʼagya sɛ, “Agya, mma wo bo mfu me sɛ mete hɔ wɔ wʼanim na mensɔre nnyina hɔ, ɛfiri sɛ, makɔ afikyire.” Enti, Laban toaa so hwehwɛɛ abosom no ara, nanso wanhunu. ");
INSERT INTO twiasante_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ɛyɛɛ saa no, Yakob bo fuu Laban yie, bisaa no sɛ, “Bɔne bɛn na mayɛ? Amumuyɛsɛm bɛn na madi a ɛno enti, woataa me ara yi?” ");
INSERT INTO twiasante_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Wohwehwɛɛ me nneɛma nyinaa mu yi, ɛdeɛn adeɛ na wohunuiɛ a ɛyɛ wo ne wo fiefoɔ dea? Deɛ wohunuiɛ biara no, fa bɛto dwa wɔ me nuanom ne wo nuanom a wɔahyia ha yi nyinaa anim, na wɔnkyerɛ deɛ ɛyɛ ne dea. ");
INSERT INTO twiasante_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Mfirinhyia aduonu a wo ne me tenaeɛ, wo nnwan ne wo mmirekyie abereɛ no ampompɔn, na mankum wo nnwennini yi bi amfiri wo nnwankuo yi mu, anwe da. ");
INSERT INTO twiasante_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mamfa wʼaboa biara a akekaboa bi atete ne mu ammrɛ wo; wɔn a mmoa kumm wɔn no, mʼankasa mehyɛɛ anan mu. Afei sɛ ɛba sɛ wɔwia wo mmoa no bi, anadwo anaa awia a, woma metua ka. ");
INSERT INTO twiasante_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Saa na asetena a me ne wo teɛ no teɛ. Meyɛɛ wʼadwuma awia maa owia hyee me. Meyɛɛ wʼadwuma anadwo maa awɔ dee me, maa sɛ, mekɔ kɛtɛ so koraa a, mentumi nna. ");
INSERT INTO twiasante_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Mfirinhyia aduonu a metenaa wo nkyɛn nyinaa, na saa na mʼasetena teɛ. Mede mfirinhyia dunan na ɛyɛɛ adwuma maa wo, de waree wo mmammaa baanu no. Ɛnna mede mfirinhyia nsia nso hwɛɛ wo nnwan. Deɛ ɛtwa toɔ koraa ne sɛ, wosesaa mʼakatua mpɛn edu. ");
INSERT INTO twiasante_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Sɛ ɛnyɛ Onyankopɔn a mʼagya somm no, Onyankopɔn a Abraham somm no a ɔwɔ mafa ne suro a mesuro mʼagya Isak a, anka nokorɛm nie, wopamoo me, maa mede me nsapan kɔeɛ. Nanso Onyankopɔn hunuu mʼamanehunu ne me nsa ano adwuma enti na nnora anadwo ɔkaa wʼanim no.” ");
INSERT INTO twiasante_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban buaa Yakob sɛ, “Mmaa no yɛ me mmammaa, mmɔfra no nso yɛ me nananom, ɛnna nnwankuo no nso yɛ me nnwankuo. Nneɛma a wohunu yi nyinaa yɛ me dea. Ɛbɛyɛ dɛn na matumi ayɛ mʼankasa me mmammaa ne me nananom bɔne? ");
INSERT INTO twiasante_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Afei, bra na me ne wo nyɛ apam a ɛbɛdi me ne wo ntam adanseɛ. Saa apam no so na yɛbɛdi wɔ yɛn asetena nyinaa mu.” ");
INSERT INTO twiasante_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Enti, Yakob faa ɛboɔ de sii hɔ yɛɛ nkaeɛdum. ");
INSERT INTO twiasante_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakob kyerɛɛ ne nuanom no sɛ, “Montase aboɔ!” Enti, wɔtasee aboɔ boaa ano. Afei, wɔn nyinaa tenaa ho didiiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban frɛɛ aboɔ kuo no Yegar-Sahaduta a asekyerɛ ne Adanseɛ Kuo. Yakob nso frɛɛ saa aboɔ kuo no Gal-Ed, a asekyerɛ ne Adanseɛ Kuo saa ara. ");
INSERT INTO twiasante_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Afei, Laban kaa sɛ, “Aboɔ Kuo yi na ɛdi me ne wo ntam adanseɛ ɛnnɛ!” Ɛno enti na wɔfrɛ no Gal-Ed no. ");
INSERT INTO twiasante_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Na wɔsane frɛ aboɔ nkaeɛdum no nso bio sɛ, “Mispa” ɛfiri sɛ, Laban kaa sɛ, “Awurade mmoa yɛn, na sɛ yɛn ntam tete mpo a, yɛn mu biara bɛdi saa apam yi so. ");
INSERT INTO twiasante_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Sɛ woanhwɛ me mmammaa yi yie anaasɛ woware mmaa foforɔ ka me mmammaa yi ho a, ɛwom sɛ merenhunu, nanso Onyankopɔn deɛ, ɔbɛhunu.” ");
INSERT INTO twiasante_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban sane ka kyerɛɛ Yakob sɛ, “Aboɔ Kuo yi ni. Nkaeɛdum a mede asi me ne wo ntam no nso nie. ");
INSERT INTO twiasante_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Aboɔ Kuo yi ne nkaeɛdum yi nyɛ adanseɛ sɛ, me Laban, merentra saa Aboɔ Kuo yi ne nkaeɛdum yi mma baabi a wowɔ mmɛtoa wo. Na wo Yakob nso, worentra saa Aboɔ kuo yi ne nkaeɛdum yi mma baabi a mewɔ mmɛtoa me. ");
INSERT INTO twiasante_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ma Abraham Onyankopɔn ne Nahor Onyankopɔn, wɔn agyanom Onyankopɔn nyɛ ɔtemmufoɔ wɔ me ne wo ntam.” Enti, Yakob de nʼagya Isak Onyankopɔn ho suro kaa ntam sɛ, ɔrentra ɛhyeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Afei, Yakob bɔɔ Onyankopɔn afɔdeɛ wɔ bepɔ no atifi, na ɔhyiahyiaa ne nnamfonom bɛdidiiɛ. Ɛno akyiri no, wɔdaa ne nkyɛn wɔ bepɔ no so. ");
INSERT INTO twiasante_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laban sɔree anɔpatutuutu fefee ne nananom ne ne mmammaa no ano, hyiraa wɔn. Ɛno akyiri no, ɔsane nʼakyi kɔɔ ne kurom. ");
INSERT INTO twiasante_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakob ne ne fiefoɔ toaa nʼakwantuo no so. Onyankopɔn abɔfoɔ bɛhyiaa no. ");
INSERT INTO twiasante_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakob hunuu wɔn no, ɔkaa sɛ, “Ɛha yɛ Onyankopɔn fie!” Enti ɔtoo saa beaeɛ hɔ edin “Mahanaim,” a asekyerɛ ne Onyankopɔn asase. ");
INSERT INTO twiasante_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakob somaa abɔfoɔ dii nʼanim kɔɔ ne nua Esau nkyɛn wɔ Seir a ɛwɔ Edom asase so. ");
INSERT INTO twiasante_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Nkra a ɔde maa wɔn nie: “Monka nkyerɛ me wura Esau sɛ, ‘Wʼakoa Yakob se, yɛn wɔfa Laban nkyɛn na makɔtena sɛ ɔhɔhoɔ ara de bɛsi ɛnnɛ yi. ");
INSERT INTO twiasante_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ɛnnɛ deɛ, mewɔ anantwie ne mfunumu, nnwan ne mmirekyie, nkoa ne mfenaa bebree. Masoma mʼabɔfoɔ yi aba wo, me wura nkyɛn, sɛ wɔmmɛka nkyerɛ wo sɛ, mereba. Mewɔ anidasoɔ nso sɛ, mɛnya wʼanim animuonyam ama woagye me fɛ so.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Asomafoɔ no sane baa Yakob nkyɛn no, wɔbɛka kyerɛɛ no sɛ, “Yɛkɔɔ wo nua Esau nkyɛn kɔkaa wo nkra no kyerɛɛ no, na ɔse ɔreba abɛhyia wo, na mmarima ahanan na wɔka ne ho reba.” ");
INSERT INTO twiasante_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakob de ehu ne awerɛhoɔ kyekyɛɛ nnipa a ɔne wɔn nam no ne mmoa no mu akuo mmienu. ");
INSERT INTO twiasante_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ɔkaa wɔ ne tirim sɛ, “Sɛ ɛba sɛ, Esau ne ne dɔm no ba bɛto hyɛ ekuo baako so a, ekuo a ɛtɔ so mmienu no bɛdwane.” ");
INSERT INTO twiasante_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Afei, Yakob bɔɔ Awurade mpaeɛ sɛ, “Ao, Awurade Onyankopɔn a mʼagya Abraham ne mʼagya Isak somm wo, Ao, Awurade a woka kyerɛɛ me sɛ, ‘Sane kɔ wʼasase so ne wʼabusua mu, na mɛma woayɛ ɔdefoɔ.’ ");
INSERT INTO twiasante_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Wʼadɔeɛ a wode ayɛ me ne nokorɛ a woadi wʼakoa no mu kakra bi mpo, mfata me. Ɛda a mefirii fie kɔtwaa Asubɔnten Yordan no, na me poma nko ara na ɛkura me, nanso ɛnnɛ, me na mekura ɛdɔm ahodoɔ mmienu yi. ");
INSERT INTO twiasante_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Mesrɛ wo, gye me firi me nua Esau nsam. Mesuro sɛ ɔbɛto ahyɛ me ne me yerenom ne me mma so. ");
INSERT INTO twiasante_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nanso, wo na woahyɛ me bɔ sɛ, ‘Nokorɛ mu, mɛma woanya wo ho, na mama wʼase afɛe ayɛ sɛ mpoano anwea a wɔntumi nkan.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Saa ɛda no, ɔdaa hɔ. Na ɔyii nʼagyapadeɛ no bi sɛ akyɛdeɛ a ɔde bɛma ne nua Esau. ");
INSERT INTO twiasante_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Nneɛma no nie: Mmirekyibereɛ ahanu, mpapo aduonu, nnwammedeɛ ahanu, nnwennini aduonu. ");
INSERT INTO twiasante_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Nyoma bereɛ aduasa ne wɔn mma, anantwibereɛ aduanan, anantwinini edu, mfunumubereɛ aduonu, mfunumunini edu. ");
INSERT INTO twiasante_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ɔkyekyɛɛ mmoa no mu akuakuo, de maa nʼasomfoɔ a ekuo baako biara hyɛ ɔsomfoɔ baako nsa. Ɔka kyerɛɛ nʼasomfoɔ no sɛ, “Monni mʼanim nkɔ, na mmom, momma akwan nneda mmoa akuakuo no ntam.” ");
INSERT INTO twiasante_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yakob sane ka kyerɛɛ nʼasomfoɔ a wɔdi ɛkan no sɛ, “Sɛ me nua Esau hyia mo, na ɔbisa mo sɛ, ‘Hwan asomfoɔ ne mo? Mofiri he na morekɔ he na hwan mmoa na mode wɔn nam yi a,’ ");
INSERT INTO twiasante_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","monka nkyerɛ no sɛ, ‘Mmoa no yɛ wʼakoa Yakob dea. Ne nyinaa yɛ akyɛdeɛ a ɔde rebrɛ ne wura Esau, na nʼankasa di akyire reba.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Saa ara nso na Yakob ka kyerɛɛ nʼasomfoɔ a wɔtɔ so mmienu, mmiɛnsa ne wɔn a wɔdidi so a wɔde mmoa no rekɔ no sɛ, “Sɛ mohyia Esau a, monka saa asɛm korɔ no ara nkyerɛ no. Monka nka ho sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘Wʼakoa Yakob ankasa di yɛn akyiri reba.’ ” Ɛfiri sɛ, na Yakob ayɛ nʼadwene sɛ, “Mede akyɛdeɛ ahodoɔ a mede asoma adi ɛkan yi bɛpata no, na sɛ akyire no ɔhunu me a, wagye me ato mu.” ");
INSERT INTO twiasante_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Enti, wɔde Yakob akyɛdeɛ ahodoɔ no dii ɛkan kɔeɛ. Na nʼankasa deɛ, ɔdaa nʼatenaeɛ hɔ anadwo no. ");
INSERT INTO twiasante_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Anadwo no ara, Yakob sɔre faa ne yerenom baanu ne ne mfenaa baanu no ne ne mma dubaako no, de wɔn twaa Asubɔnten Yordan wɔ Yabok asutwareɛ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ɔde wɔn twaa asubɔnten no wieeɛ no, ɔsane bɛfaa nʼagyapadeɛ a aka nyinaa de twaa asuo no. ");
INSERT INTO twiasante_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Afei, ɛkaa Yakob nko ara wɔ nʼatenaeɛ hɔ. Anadwo no, obi ne no bɛtentameeɛ ara kɔsii adekyeɛ wɛɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ɛberɛ a ɔbarima a ɔne no tentameeɛ no hunuu sɛ ɔrentumi nni Yakob so no, ɔbɔɔ Yakob dwonku, ma ɛhwaneeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Afei, ɔbarima no ka kyerɛɛ Yakob sɛ, “Adeɛ akye enti, gyaa me ma menkɔ.” Nanso, Yakob buaa no sɛ, “Sɛ woanhyira me a, meremma wonkɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ɔbarima no bisaa Yakob sɛ, “Wo din de sɛn?” Ɔbuaa sɛ, “Me din de Yakob.” ");
INSERT INTO twiasante_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ɔbarima no kaa sɛ, “Ɛfiri ɛnnɛ, wɔremfrɛ wo Yakob bio, na mmom, wɔbɛfrɛ wo Israel, ɛfiri sɛ, wo ne Onyankopɔn ne nnipa atentam, na woadi nkonim.” ");
INSERT INTO twiasante_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakob bisaa sɛ, “Mesrɛ wo, wɔfrɛ wo sɛn?” Ɔbarima no nso bisaa no sɛ, “Adɛn enti na worebisa me din?” Yei akyiri no, ɔhyiraa Yakob. ");
INSERT INTO twiasante_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ɛmaa Yakob too beaeɛ hɔ edin Peniel, a asekyerɛ ne “Onyankopɔn Anim.” Na ɔkaa sɛ, “Mahunu Onyankopɔn animuanimu, nanso meda so te nkwa mu ara.” ");
INSERT INTO twiasante_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakob refiri Peniel no na owia agyina. Esiane ne dwonku a na ahwan no enti, na ɔtɔ gu ne nan no so. ");
INSERT INTO twiasante_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ɛno enti na ɛbɛsi ɛnnɛ yi, Israelfoɔ nwe aboa dwonku koraa sɛ nkaedeɛ no. Saa ntini kɛseɛ a ɛwɔ Yakob dwonku no na ɔbarima a ɔne no tentameeɛ no bɔeɛ, maa Yakob dwonku hwaneeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakob pagyaa nʼani hunuu sɛ Esau ne ne mmarima ahanan a wɔka no ho firi akyirikyiri reba. Enti, ɔkyekyɛɛ ne mma no mu maa Lea, Rahel ne nʼasomfoɔ baanu no. ");
INSERT INTO twiasante_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ɔmaa asomfoɔ no ne wɔn mma dii ɛkan. Lea ne ne mma nso dii hɔ. Ɛnna Rahel ne ne ba Yosef nso dii akyire. ");
INSERT INTO twiasante_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakob deɛ, ɔdii wɔn anim. Ɔreyɛ abɛn ne nua Esau no, ɔbɔɔ ne mu ase mprɛnson. ");
INSERT INTO twiasante_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau tuu mmirika kɔhyiaa Yakob, yɛɛ no atuu. Ɔbam Yakob, fee nʼano. Na wɔn baanu nyinaa suiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Afei, Esau maa nʼani so hunuu mmaa no ne mmɔfra no. Ɔbisaa Yakob sɛ, “Yeinom yɛ ɛhefoɔ?” Ɔbuaa sɛ, “Wɔyɛ mma a Onyankopɔn de wɔn adom me a meyɛ wʼakoa.” ");
INSERT INTO twiasante_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Afei, Yakob asomfoɔ ne wɔn mma twe bɛn Esau bɛkotoo no. ");
INSERT INTO twiasante_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Saa ara na Lea ne ne mma nso bɛkotoo no. Afei, Yosef ne ne maame Rahel nso ba bɛkotoo no. ");
INSERT INTO twiasante_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau bisaa sɛ, “Nnwan ne anantwie ne mmoa bebrebe a wɔsa so reba yi nso, aseɛ ne sɛn?” Yakob buaa sɛ, “Me wura, ɛyɛ akyɛdeɛ a mede rebrɛ wo, na manya wʼanim animuonyam.” ");
INSERT INTO twiasante_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Nanso, Esau sere buaa no sɛ, “Me nua, mewɔ saa mmoa yi bebree ma ɛboro so. Enti, fa deɛ wode rebrɛ me yi ka wo deɛ ho.” ");
INSERT INTO twiasante_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakob kaa sɛ, “Dabi, sɛ woagye me fɛ so deɛ a, mesrɛ wo, gye akyɛdeɛ a mede rebrɛ wo yi. Nokorɛ ni, ɛsiane sɛ wogyee me ɔdɔ so enti, mehunuu wʼanim no, na ayɛ me sɛdeɛ mahunu Onyankopɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Mesrɛ wo, gye mʼakyɛdeɛ a mede rebrɛ wo yi, ɛfiri sɛ, Awurade adom me ama mayɛ ɔdefoɔ.” Esiane sɛ Yakob kɔɔ so srɛɛ no ara sɛ ɔnnye nʼakyɛdeɛ no enti, Esau gyeeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Afei, Esau kaa sɛ, “Ma yɛnkɔ. Yɛbɛdi mo anim ne mo akɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Nanso, Yakob buaa no sɛ, “Me wura ankasa nim sɛ, mmɔfra no bi susua. Ɛsɛ sɛ mehwɛ anantwie ne nnwan ne mmoa a wɔawowo no nso ka wɔn so brɛoo. Sɛ meka wɔn so den ɛda koro pɛ mpo a, wɔn nyinaa bɛwuwu. ");
INSERT INTO twiasante_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Enti, me wura, di yɛn ɛkan na yɛne nyɛmmoa no bɛdi wʼakyi nkakrankakra abɛto wo wɔ Seir.” ");
INSERT INTO twiasante_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Enti, Esau kaa sɛ, “Anyɛ bi koraa no, ma mennya me mmarima na wɔnni wʼanim, mmɔ wo ho ban.” Yakob kaa sɛ, “Ɛho nhia sɛ ɛsɛ sɛ woyɛ me saa adɔeɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Enti, ɛda no ara, Esau sane nʼakyiri kɔɔ Seir. ");
INSERT INTO twiasante_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Nanso, Yakob deɛ, ɔkɔɔ Sukot kɔsisii ne ntomadan, pɛɛ baabi a ne mmoa no nso bɛda, de hɔ yɛɛ nʼatenaeɛ. Ɛno enti na wɔfrɛ saa beaeɛ hɔ Sukot, a asekyerɛ ne Asese no. ");
INSERT INTO twiasante_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakob firii Paddan-Aram no, ɔkɔduruu Sekem kuro a ɛwɔ Kanaan asase so asomdwoeɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yakob tɔɔ asase a ɔtenaa so no nnwetɛ mpɔ ɔha firii Sekem agya Hamor mma nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Wɔsii afɔrebukyia wɔ hɔ, too saa afɔrebukyia no edin El-Elohe-Israel, a asekyerɛ ne Onyankopɔn, Israel Onyankopɔn Afɔrebukyia. ");
INSERT INTO twiasante_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ɛda koro bi, Lea ne Yakob ba Dina firii adi kɔsraa mmabaawa a wɔwɔ wɔn mpɔtam hɔ no. ");
INSERT INTO twiasante_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ɛberɛ a Hewifoɔhene Hamor babarima Sekem hunuu Dina no, ɔkyeree no kɔtoo no monnaa. ");
INSERT INTO twiasante_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ɛfiri saa ɛberɛ no, Sekem tuu nʼani sii Yakob ba Dina so. Ɔbɔɔ mmɔden ara sɛ, ɔne no bɛkasa ama wapene so, na waware no. ");
INSERT INTO twiasante_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ɛno enti, Sekem dii ho nkɔmmɔ kyerɛɛ nʼagya Hamor sɛ, “Mepɛ sɛ meware ababaawa yi, enti kɔka ne ho asɛm ma me!” ");
INSERT INTO twiasante_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ɛberɛ a Yakob tee sɛ Sekem akɔkyere ne babaa Dina, akɔto no monnaa no, na ne mmammarima no nyinaa ne wɔn agya anantwie wɔ wiram. Enti, Yakob anka hwee kɔsii sɛ wɔbaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Asɛm yi akyiri no, Sekem agya Hamor kɔɔ Yakob nkyɛn ne no kɔdii nkɔmmɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yakob mmammarima no tee wɔn nuabaa Dina ho asɛm pɛ, wɔfiri wiram hɔ baeɛ. Wɔn werɛ hoeɛ na wɔn bo nso fuu yie, ɛfiri sɛ Sekem ayɛ aniwudeɛ wɔ Israel. Ɔne Yakob babaa daeɛ, na yei yɛ akyiwadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Nanso, Hamor ka kyerɛɛ Yakob sɛ, “Me ba Sekem ani gye wo ba Dina ho. Mesrɛ wo, fa no ma no, na ɔnware no. ");
INSERT INTO twiasante_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mo ne yɛnni awadeɛ. Momfa mo mmammaa mma yɛn, na yɛnware wɔn, na yɛn nso, yɛmfa yɛn mmammaa mma mo awadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mobɛtumi ne yɛn atena. Asase yi nyinaa yɛ mo dea. Montena so, nni dwa wɔ so, mpɛ mu agyapadeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Afei, Sekem ka kyerɛɛ Dina agya ne ne nuammarima no sɛ “Monnye me ntom. Biribiara a mobɛgye me no, mɛtua. ");
INSERT INTO twiasante_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ɔbaa no ti adeɛ ne biribiara a mobɛgye aka ho no, mommɔ ɛboɔ biara a mopɛ, na mɛtua. Deɛ ɛhia me ara ne sɛ, mode ababaawa no bɛma me aware.” ");
INSERT INTO twiasante_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Esiane sɛ na Sekem agu wɔn nuabaa Dina ho fi no enti, mmuaeɛ a wɔmaa Sekem ne nʼagya Hamor no anyɛ nokorɛ. Na mmom, na wɔwɔ adwene foforɔ bi wɔ akyire. ");
INSERT INTO twiasante_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Yakob mmammarima no ka kyerɛɛ Sekem ne nʼagya Hamor sɛ, “Yɛrentumi mfa yɛn nuabaa mma ɔbarima a ɔntwaa twetia awadeɛ. Sɛ yɛyɛ saa a, na yɛagu yɛn ho anim ase. ");
INSERT INTO twiasante_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ansa na yɛde yɛn nuabaa bɛma wo awadeɛ no, gye sɛ woatwitwa wo mmarima nyinaa twetia te sɛ yɛn. ");
INSERT INTO twiasante_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Sɛ moyɛ saa deɛ a, yɛne mo bɛdi awadeɛ. Mobɛware yɛn mmaa, na yɛn nso, yɛaware mo mmaa. Yɛne mo bɛtena fɛfɛɛfɛ sɛ nnipa baako. ");
INSERT INTO twiasante_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Sɛ moampene so amma wɔantwitwa mo twetia deɛ a, yɛbɛgye yɛn nuabaa de no akɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Asɛm a wɔkaeɛ no tɔɔ Hamor ne ne ba Sekem asom. ");
INSERT INTO twiasante_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sekem a na ɔyɛ aberanteɛ a ɔdi mu wɔ nʼagya mma nyinaa mu no antwentwɛn ne nan ase koraa. Ɔkɔtwaa twetia no, sɛdeɛ Yakob mma no kaeɛ no, ɛfiri sɛ, na ɔpɛ Yakob babaa no yie. ");
INSERT INTO twiasante_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Enti, Hamor ne ne ba Sekem kɔbɔɔ dwa wɔ kuro no ɛpono ano ne ɛhɔ mmarima kɔkasaeɛ sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Yakob ne ne mma yi ne yɛn te yie. Mompene so na wɔne yɛn ntena yɛn asase yi so, na yɛnni edwa. Ɛfiri sɛ, yɛn asase yi so a yɛne wɔn bɛsene so. Yɛbɛtumi aware wɔn mmammaa, na wɔn nso bɛtumi aware yɛn deɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nanso, ansa na wɔn mmarima no bɛpene so ne yɛn atena sɛ nnipa korɔ no, gye sɛ yɛn mmarima nyinaa twitwa twetia, sɛdeɛ wɔn nso wɔatwitwa twetia no. ");
INSERT INTO twiasante_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Sɛ ɛba saa a, wɔn mmoa, wɔn agyapadeɛ ne wɔn mmoa ahodoɔ a ɛkeka ho no nyinaa remmɛyɛ yɛn dea anaa? Enti, momma yɛmpene so mma wɔn, na yɛne wɔn ntena.” ");
INSERT INTO twiasante_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Mmarima a wɔkɔhyiaa Hamor ne ne ba Sekem wɔ kuro no ɛpono ano no nyinaa ne wɔn yɛɛ adwene maa mmarima a wɔwɔ kurom hɔ nyinaa twitwaa twetia. ");
INSERT INTO twiasante_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Nnansa akyiri a na twetiatwa no enti, kurom hɔ mmarima no nyinaa deda hɔ a wɔgye wɔn ho a ɛnnye no, Yakob mmammarima baanu Simeon ne Lewi a wɔyɛ Dina nuammarima no faa wɔn mpea. Wɔkɔto hyɛɛ kuro no so, ɛberɛ a wɔn ani nna wɔn ho so, kunkumm mmarima a wɔwɔ kurom hɔ nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Wɔde pea kumm Hamor ne ne ba Sekem, na wɔfaa wɔn nuabaa Dina firii Sekem fie de no kɔɔ wɔn nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yakob mmammarima a wɔaka no nso to hyɛɛ kuro no so. Wɔtiatiaa nnipa a wɔawuwu no so, fom kuro no mu nneɛma nyinaa pasaa, ɛfiri sɛ, ɛhɔ na Sekem guu wɔn nuabaa Dina ho fi. ");
INSERT INTO twiasante_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Wɔfom wɔn anantwie, wɔn nnwan, wɔn mfunumu ne wɔn agyapadeɛ biara a ɛwɔ kuro no mu ne deɛ ɛwɔ wiram nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Wɔfaa wɔn ahodeɛ, wɔn yerenom ne wɔn mmaa, fom wɔn afie mu nneɛma nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Afei, Yakob ka kyerɛɛ Simeon ne Lewi sɛ, “Mode ɔhaw abɛto me so, ama ɛnnɛ me ho koraa abɔn Perisifoɔ ne Kanaanfoɔ a mete wɔn asase so yi. Yɛn nnɔɔso. Sɛ wɔka wɔn ho bom, bɛto hyɛ yɛn so a, wɔbɛhye me ne mʼasefoɔ nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Na wɔbuaa wɔn agya sɛ, “Enti, anka yɛntena hɔ nhwɛ na ɔnyɛ yɛn nuabaa sɛ odwamanfoɔ anaa?” ");
INSERT INTO twiasante_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Afei, Onyankopɔn ka kyerɛɛ Yakob sɛ, “Kɔ Bet-El kɔtena hɔ. Sɛ woduru hɔ a, si afɔrebukyia ma me. Me na meyii me ho adi kyerɛɛ wo ɛberɛ a na woredwane afiri wo nua Esau nkyɛn no.” ");
INSERT INTO twiasante_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Enti, Yakob ka kyerɛɛ ne fiefoɔ ne wɔn a wɔka ne ho nyinaa sɛ, “Monsɛe mo anyame a mode wɔn firi amanɔne baeɛ no nyinaa. Monwira mo ho, na monsesa mo ntadeɛ nso.” ");
INSERT INTO twiasante_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ɔtoaa so sɛ, “Yɛrebɛtu ɛkwan akɔ Bet-El. Na sɛ yɛduru hɔ a, yɛbɛsi afɔrebukyia ama Onyankopɔn a ɔtiee me mpaeɛbɔ wɔ mʼamanehunu mu, na ɔkaa me ho wɔ mʼakwantuo mu no.” ");
INSERT INTO twiasante_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Enti, wɔn nyinaa de wɔn ahoni ne nsonkawa maa Yakob. Yakob tuu fam wɔ odum bi ase wɔ Sekem, de ne nyinaa hyɛɛ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Afei, wɔsiim. Wɔrekɔ no, Onyankopɔn bɔɔ nkuro a wɔfaa so no nyinaa mu nnipa no hu a, ɛno enti obiara antumi anti wɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakob ne ne nkurɔfoɔ a wɔka ne ho no bɛduruu Lus a ɛno ara ne Bet-El a ɛwɔ Kanaan asase so no. ");
INSERT INTO twiasante_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ɔsii afɔrebukyia wɔ hɔ, too hɔ edin El-Bet-El, ɛfiri sɛ, ɛhɔ na ɛberɛ a ɔredwane afiri ne nua Esau nkyɛn no, Onyankopɔn yii ne ho adi kyerɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Yei akyiri no, Debora a ɔyɛ Rebeka bagyegyefoɔ no wuiɛ, ma wɔsiee no wɔ odum bi a ɛwɔ Bet-El bɔn mu no ase. Ɛfiri saa ɛberɛ no, wɔtoo beaeɛ hɔ edin Alon-Bakut, a asekyerɛ ne Agyaadwotwa Dum. ");
INSERT INTO twiasante_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakob firi Paddan-Aram bɛduruu Bet-El no, Onyankopɔn sane yii ne ho adi kyerɛɛ no, hyiraa no. ");
INSERT INTO twiasante_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Onyankopɔn ka kyerɛɛ no sɛ, “Ɛwom sɛ wɔfrɛ wo Yakob deɛ, nanso ɛfiri ɛnnɛ, wɔremfrɛ wo Yakob bio, na mmom, wɔbɛfrɛ wo Israel a asekyerɛ ne Onipa a ɔne Onyankopɔn adi asie. Enti Onyankopɔn too ne din sɛ, Israel.” ");
INSERT INTO twiasante_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Onyankopɔn ka kyerɛɛ Yakob sɛ, “Mene Onyankopɔn tumfoɔ no. Wʼase nnɔre, na wʼase mfɛe. Ɔman ne aman asafo bɛfiri wo mu aba. Saa ara na ahemfo nso bɛfiri wo mu aba. ");
INSERT INTO twiasante_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mede asase a mede maa Abraham ne Isak no bɛma wo. Aane, mede saa asase korɔ yi ara bɛma wʼasefoɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Yei akyiri no, Onyankopɔn firii beaeɛ a na ɔne Yakob rekasa hɔ no kɔɔ ɔsoro. ");
INSERT INTO twiasante_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Afei, Yakob sii ɔbodum wɔ hɔ, hwiee afɔresa guu so, de bɔɔ Onyankopɔn afɔdeɛ. Ɔsane de afɔrengo sraa odum no ho. ");
INSERT INTO twiasante_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakob too beaeɛ a Onyankopɔn ne no kasaeɛ no Bet-El, a asekyerɛ ne Onyankopɔn fie. ");
INSERT INTO twiasante_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakob ne ne fiefoɔ siim firii Bet-El, de wɔn ani kyerɛɛ Efrat. Wɔrekɔ no, awoɔ kaa Rahel wɔ akwantemfi. ");
INSERT INTO twiasante_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ɛberɛ a ɔreko awoɔ no, ɔbaa ɔwogyefoɔ no ka kyerɛɛ no sɛ, “Nsuro na worebɛwo ɔbabarima bio.” ");
INSERT INTO twiasante_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Nanso, Rahel koo awoɔ tɔeɛ. Na ɛberɛ a ne kra refiri ne mu na ɔreyɛ awuo no, ɔtoo ne babarima a wawo no no edin Ben-Oni, a asekyerɛ ne Mʼawerɛhoɔ Mu Ba. “Nanso, nʼagya sane too no edin Benyamin, a asekyerɛ ne Me dɔba.” ");
INSERT INTO twiasante_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rahel wuiɛ, ma wɔsiee no wɔ Efrat a ɛno ara ne Betlehem no akwantemfi. ");
INSERT INTO twiasante_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakob yɛɛ nkaeɛdum sii Rahel ɛda no so a ɛda so wɔ hɔ bɛsi ɛnnɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel toaa nʼakwantuo no so, kɔsii ne ntomadan wɔ Edir abantenten no akyiri nohoa baabi. ");
INSERT INTO twiasante_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ɛberɛ a Israel te saa asase no so no, ɔtee sɛ ne ba panin Ruben ne Bilha a ɔyɛ nʼagya afenaa a waware no no akɔda. Na Yakob wɔ mmammarima dumienu: ");
INSERT INTO twiasante_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea mma na wɔn din didi so yi: Ruben a ɔno ne Israel abakan, Simeon, Lewi, Yuda, Isakar ne Sebulon. ");
INSERT INTO twiasante_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel nso mmammarima baanu no ne Yosef ne Benyamin. ");
INSERT INTO twiasante_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel afenaa Bilha mmammarima baanu no ne Dan ne Naftali ");
INSERT INTO twiasante_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea afenaa Silpa nso mmammarima baanu no ne Gad ne Aser. Yeinom ne Yakob mmammarima a wɔwoo wɔn wɔ Paddan-Aram no. ");
INSERT INTO twiasante_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Akyire no, Yakob baa nʼagya Isak nkyɛn wɔ Mamrɛ wɔ Kiriat-Arba, a ɛno ara ne Hebron, baabi a Abraham ne Isak tenaa sɛ ahɔhoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isak dii mfeɛ ɔha ne aduɔwɔtwe. ");
INSERT INTO twiasante_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isak wuiɛ, ma wɔfaa no kɔkaa ne mpanimfoɔ ho; na wabɔ akɔkoraa posoposo. Ne mmammarima Esau ne Yakob na wɔsiee no. ");
INSERT INTO twiasante_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Yeinom ne Esau a wɔfrɛ no Edom no asefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau waree Kanaanfoɔ mmaa baasa. Wɔn din de Ada a ɔyɛ Hetini Elon babaa, Ana babaa Oholibama a ɔsane yɛ Hewini Sibeon nana ne ");
INSERT INTO twiasante_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basmat a ɔyɛ Ismael babaa na ɔyɛ Nebaiot nuabaa. ");
INSERT INTO twiasante_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada woo Elifas maa Esau. Basmat woo Reuel. ");
INSERT INTO twiasante_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama nso woo Yeus, Yalam ne Kora. Saa nnipa a wɔabobɔ wɔn din yi ne mmammarima a Esau yerenom baasa no wowoo wɔn maa no wɔ Kanaan asase so no. ");
INSERT INTO twiasante_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau faa ne yerenom, ne mmammarima, ne mmammaa, ne fiefoɔ nyinaa, ne nyɛmmoa ne mmoa a aka nyinaa ne nʼagyapadeɛ biara a ɔbrɛ nyaa no wɔ Kanaan asase so nyinaa, tu firii ne nua Yakob nkyɛn, kɔɔ asase bi so akyirikyiri. ");
INSERT INTO twiasante_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ɛfiri sɛ, na wɔn ahonyadeɛ no dɔɔso sɛ ɔne ne nua Yakob bɛtumi atena faako. Na wɔn mmoa dodoɔ enti, wɔn baanu no nsene asase a wɔte so no so. ");
INSERT INTO twiasante_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ɛno enti, Esau a wɔfrɛ no Edom no kɔbɔɔ nʼatenaeɛ wɔ Seir bepɔ so. ");
INSERT INTO twiasante_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Yeinom ne Esau a ɔyɛ Edomfoɔ agya no asefoɔ a wɔwoo wɔn maa no ɛberɛ a na ɔwɔ Seir bepɔ so no. ");
INSERT INTO twiasante_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau mmammarima no din na ɛdidi so yi: Elifas, a ɔyɛ Esau yere panin Ada babarima ne Reuel a ɔyɛ Basmat babarima. ");
INSERT INTO twiasante_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifas nso mmammarima din na ɛdidi so yi: Teman, Omar, Sefo, Gatam ne Kenas. ");
INSERT INTO twiasante_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Na Esau babarima Elifas nso wɔ mpena bi a ne din de Timna a ɔne no woo ba a wɔfrɛ no Amalek. Edin a wɔabobɔ yi yɛ Esau yere Ada nananom. ");
INSERT INTO twiasante_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel mmammarima din na ɛdidi so yi: Nahat, Serah, Sama ne Misa. Saa edin a wɔabobɔ yi yɛ Esau yere Basmat nso nananom. ");
INSERT INTO twiasante_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau yere Oholibama a ɔyɛ Ana babaa, na ɔsane yɛ Sibeon nana no mmammarima a ɔwoo wɔn maa Esau no ne yeinom: Yeus, Yalam ne Kora. ");
INSERT INTO twiasante_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Yeinom ne Esau asefoɔ no mu atitire: Elifas a ɔyɛ Esau abakan no nso mmammarima din na ɛdidi so yi: Atitire Teman, Omar, Sefo, Kenas, ");
INSERT INTO twiasante_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam ne Amalek. Saa edin a wɔabobɔ yi ne Elifas a ɔyɛ Esau abakan no asefoɔ atitire a wɔwowoo wɔn wɔ Edom asase so. Na saa atitire yi yɛ Ada nananom. ");
INSERT INTO twiasante_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau babarima Reuel mmammarima din na ɛdidi so yi: Otitire Nahat, Otitire Serah, Otitire Sama ne Otitire Misa. Saa edin a wɔabobɔ yi ne Ruel a ɔyɛ Esau ba a ɔtɔ so mmienu no nnipa atitire a wɔwoo wɔn wɔ Edom asase so. Na wɔyɛ Esau yere Basmat nananom. ");
INSERT INTO twiasante_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau yere Oholibama mmammarima din na ɛdidi so yi: Otitire Yeus, Otitire Yalam ne Otitire Kora. Saa edin a wɔabobɔ yi ne Esau yere Oholibama a ɔyɛ Ana babaa no asefoɔ nnipa atitire no. ");
INSERT INTO twiasante_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Saa edin a wɔabobɔ yi ne Esau a ɔno ara ne Edom no mmammarima. Wɔn ara nso na wɔyɛ wɔn nnipa atitire no. ");
INSERT INTO twiasante_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Yeinom ne Horini Seir mmammarima a na saa ɛberɛ no wɔtete Seir asase so no: Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO twiasante_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eser ne Disan. Saa nnipa a wɔabobɔ wɔn din yi ne Horini Seir mmammarima a na wɔtete Edom asase so no nnipa atitire no. ");
INSERT INTO twiasante_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan mmammarima ne yeinom: Hori ne Homam. Na Timna yɛ Lotan nuabaa. ");
INSERT INTO twiasante_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal nso mmammarima ne yeinom: Alwan, Manahat, Ebal, Sefo ne Onam. ");
INSERT INTO twiasante_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Na yeinom ne Sibeon mmammarima: Aya ne Ana. Saa Ana yi ne abarimaa a, ɛberɛ bi ɔde nʼagya Sibeon mfunumu kɔɔ adidi wɔ ɛserɛ no so a ɔkɔhunuu asuo aniwa bi a na nsuohyeɛ firi mu ba no. ");
INSERT INTO twiasante_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana mma nie: Dison ne Oholibama a ɔyɛ Ana babaa no. ");
INSERT INTO twiasante_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison mmammarima nie: Hemdan, Esban, Yitran ne Keran. ");
INSERT INTO twiasante_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser mmammarima ne yeinom: Bilhan, Saawan ne Akan. ");
INSERT INTO twiasante_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Yeinom ne Disan mma: Us ne Aran. ");
INSERT INTO twiasante_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Yeinom ne Horifoɔ nnipa atitire: Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO twiasante_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Eser ne Disan. Saa nnipa a wɔabobɔ wɔn din yi ne Horifoɔ nnipa atitire a ɛberɛ a na wɔwɔ Seir asase so no, wɔdii wɔn mmusua no so. ");
INSERT INTO twiasante_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Yeinom ne nnipa a wɔdii ɛkan dii ɔhene wɔ Edom asase so ansa na Israelni biara rebɛdi Israel mma so ɔhene: ");
INSERT INTO twiasante_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela a ɔyɛ Beor babarima bɛdii ɔhene wɔ Edom asase so. Na nʼahenkuro din de Dinhaba. ");
INSERT INTO twiasante_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Na Bela wuiɛ no, Serah babarima Yobab a ɔfiri Bosra bɛdii nʼadeɛ sɛ ɔhene. ");
INSERT INTO twiasante_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Na Yobab wuiɛ no, Husam a ɔfiri Teman asase so bɛdii nʼadeɛ sɛ ɔhene. ");
INSERT INTO twiasante_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam wuo akyiri Hadad a ɔyɛ Bedad babarima a ɔkɔdii Midian so nkonim wɔ Moab asase so no na ɔdii nʼadeɛ sɛ ɔhempɔn. Wɔtoo nʼahenkuro no edin Hawit. ");
INSERT INTO twiasante_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad wuiɛ no, Samla a ɔfiri Masreka kuropɔn mu bɛyɛɛ ɔhene. ");
INSERT INTO twiasante_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla wuiɛ no, Saulo a ɔfiri Rehobot a ɛda asuo Eufrate ho no bɛdii ɔhene. ");
INSERT INTO twiasante_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Na Saulo wuiɛ no, Akbor babarima Baal-Hanan bɛdii ɔhene. ");
INSERT INTO twiasante_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akbor babarima Baal-Hanan nso wuiɛ no, Hadad bɛdii nʼadeɛ, tenaa nʼahennwa so sɛ ɔhempɔn. Na ɔhene Hadad ahenkuro no din de Pau, ɛnna ne yere nso din de Mehetabel a ɔyɛ Matred babaa ne Me-Sahab nso nana. ");
INSERT INTO twiasante_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Sɛdeɛ wɔn a wɔdidi so yi a wɔyɛ Esau asefoɔ no mmusua ne wɔn tenabea te nie: Timna abusua, Alwa abusua, Yetet abusua, ");
INSERT INTO twiasante_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama abusua, Ela abusua, Pinon abusua, ");
INSERT INTO twiasante_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas abusua, Teman abusua, Mibsar abusua, ");
INSERT INTO twiasante_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel abusua ne Iram abusua. Yeinom ne Edom mmusua a wɔde wɔn atenaeɛ no edin totoeɛ. Na wɔn nyinaa yɛ Edomfoɔ a wɔyɛ Esau asefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yosef tenaa Kanaan asase a na nʼagya te so sɛ ɔhɔhoɔ no so. ");
INSERT INTO twiasante_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yosef abusua ho asɛm nie: Ɛberɛ a Yakob ba Yosef dii mfirinhyia dunson no, na ɔne ne nuanom hwɛ wɔn agya Yakob nnwan so. Na ɔyɛ Bilha ne Silpa a wɔyɛ nʼagya yerenom no mmammarima no ɔboafoɔ. Na ɔyɛ obi a nneɛma a ne nuanom no yɛ a ɛnyɛ no, ɔtaa bɛka kyerɛ wɔn agya Yakob. ");
INSERT INTO twiasante_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Na Israel pɛ ne ba Yosef asɛm sene ne mma a aka no nyinaa, ɛfiri sɛ, ɔwoo no ne nkɔkoraaberɛ mu; ɛno enti, ɔpam batakari bi a ɛyɛ fɛ maa no. ");
INSERT INTO twiasante_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ɛberɛ a ne nuanom no hunuu sɛ wɔn agya pɛ nʼasɛm sene wɔn nyinaa no, wɔtan no a na wɔnka abodwosɛm nkyerɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ɛda bi, Yosef soo daeɛ. Ɔkaa daeɛ a ɔsoeɛ no kyerɛɛ ne nuanom mmarima no, wɔtan no kyɛnee kane no mpo. ");
INSERT INTO twiasante_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yosef ka kyerɛɛ ne nuanom no sɛ, “Montie daeɛ bi a maso. ");
INSERT INTO twiasante_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Mesoo daeɛ, na yɛrekyekyere aburoo afiafi wɔ afuom. Ɛberɛ a yɛgu so rekyekyere aburoo no, amonom hɔ ara, me afiafi a makyekyere no sɔre gyinaa ntenten. Mo afiafi a moakyekyere no nso twaa me deɛ no ho hyiaeɛ, kotoo no.” ");
INSERT INTO twiasante_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Yosef nuanom no bisaa no sɛ, “Enti, wʼadwene ne sɛ wobɛdi yɛn so anaa? Wogye di sɛ, ampa ara, wobɛtumi aka yɛn ahyɛ?” Esiane ne daeɛ a ɔsoeɛ no ne asɛm a ɔkaeɛ no enti, ɛmaa ne nuanom no kyirii no kɔkɔɔkɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Afei, ɔsane soo daeɛ bio. Ɔkaa daeɛ a ɔsoeɛ no kyerɛɛ ne nuanom no sɛ, “Montie: Maso daeɛ foforɔ bio. Mesoo daeɛ, na owia, ɔsrane ne nsoromma dubaako rekoto me.” ");
INSERT INTO twiasante_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Saa daeɛ yi deɛ, ɔka kyerɛɛ nʼagya ne ne nuammarimanom no. Nʼagya tee saa daeɛ no, ɔkaa nʼanim sɛ, “Ɛdeɛn daeɛ na woaso yi? Wopɛ sɛ wokyerɛ sɛ ampa ara, wo maame ne me ne wo nuammarimanom no bɛba abɛkoto wo anaa?” ");
INSERT INTO twiasante_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Yei maa ne nuammarimanom no ani beree no mmorosoɔ. Nanso, nʼagya deɛ, ɔdwenee asɛm no ho kɔɔ akyiri. ");
INSERT INTO twiasante_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ɛda bi, Yosef nuammarimanom no de wɔn agya nnwan kɔɔ adidi wɔ Sekem. ");
INSERT INTO twiasante_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israel ka kyerɛɛ Yosef sɛ, “Sɛdeɛ wonim no, wo nuanom no de mmoa no kɔ adidi wɔ Sekem. Bra, na mensoma wo wɔn nkyɛn.” Yosef buaa sɛ, “Yoo, agya, mate.” ");
INSERT INTO twiasante_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Enti, Israel ka kyerɛɛ Yosef sɛ, “Kɔ na kɔhwɛ sɛ wo nuanom ho te sɛn, na nnwan no nso, na sane bɛka biribi kyerɛ me.” Enti, Israel somaa Yosef firii Hebron subɔnhwa no mu. Ɛberɛ a Yosef duruu Sekem no, ");
INSERT INTO twiasante_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ɔbarima bi hunuu no sɛ ɔnenam wura no mu. Ɔbarima no bisaa no sɛ, “Worehwehwɛ ɛdeɛn?” ");
INSERT INTO twiasante_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yosef buaa no sɛ, “Merehwehwɛ me nuammarima. Mesrɛ wo, wobɛtumi akyerɛ me baabi a wɔde wɔn nnwan no kɔ adidi?” ");
INSERT INTO twiasante_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ɔbarima no buaa no sɛ, “Wo nuammarimanom no afiri ha kɔ. Metee sɛ wɔreka sɛ, ‘Momma yɛnkɔ Dotan.’ ” Enti, Yosef tii ne nuanom no, kɔtoo wɔn wɔ Dotan hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ɛberɛ a Yosef fitiiɛ no, wɔhunuu no wɔ akyirikyiri sɛ ɔreba. Ansa na ɔreduru wɔn nkyɛn no, wɔbɔɔ ne ho pɔ sɛ wɔbɛkum no. ");
INSERT INTO twiasante_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Wɔkeka kyerɛkyerɛɛ wɔn ho wɔn ho sɛ, “Monhwɛ! Ɔdaeɛsofoɔ no na ɔreba no! ");
INSERT INTO twiasante_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mommra seesei ara, na yɛnkum no, na yɛnto no ntwene amena no bi mu, na yɛnkɔka nkyerɛ yɛn agya sɛ, aboa bi akye no awe, na yɛnhwɛ sɛ biribi bɛfiri ne daeɛ ahodoɔ no mu aba anaa.” ");
INSERT INTO twiasante_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben a ɔyɛ wɔn nua panin tee saa asɛm yi no, ɔbɔɔ mmɔden sɛ ɔbɛgye Yosef nkwa. Ɔkaa sɛ, “Mommma yɛnkum no. ");
INSERT INTO twiasante_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Monnhwie mogya ngu. Momma yɛnto no ntwene amena a ɛwɔ ɛserɛ yi so no bi mu. Na mommma yɛmfa yɛn nsa nka no.” Ruben kaa saa asɛm yi de gyee no firii wɔn nsam, sɛdeɛ ɔbɛnya ɛkwan de no akɔhyɛ wɔn agya nsa. ");
INSERT INTO twiasante_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yosef bɛduruu ne nuammarimanom no nkyɛn no, wɔworɔɔ ne batakari fɛfɛ a ɛhyɛ no no. ");
INSERT INTO twiasante_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Afei, wɔtoo no twenee amena bi mu. Saa amena no, na nsuo biara nni mu. ");
INSERT INTO twiasante_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Afei, ɛberɛ a anuanom no tenaa ase sɛ wɔredidi no, wɔtoo wɔn ani hunuu sɛ nyoma bebree sa so reba faako a na wɔrebɛdidi hɔ no. Wɔhunuu sɛ saa nkurɔfoɔ no yɛ Ismaelfoɔ adwadifoɔ bi a wɔsoso hyehwam, akyenkyennuro ne kurobo a wɔde firi Gilead rekɔtɔn no wɔ Misraim asase so. ");
INSERT INTO twiasante_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda ka kyerɛɛ ne nuanom no sɛ, “Sɛ yɛkum yɛn nua yi, kata ne mogya so a, ɛdeɛn mfasoɔ na yɛbɛnya. ");
INSERT INTO twiasante_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Momma yɛnyi no, na yɛntɔn no mma Ismaelfoɔ adwadifoɔ yi, sene sɛ yɛbɛkum no. Ɛkɔsi sɛn ara a, ɔyɛ yɛn nua kumaa a ɔyɛ yɛn busuani.” Ne nuanom mmarima no penee nʼadebisa no so. ");
INSERT INTO twiasante_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ɛberɛ a Midian adwadifoɔ no bɛduru hɔ no, Yosef nuanom no yii no firii amena no mu, tɔn no gyee dwetɛ gram ahanu aduonu nwɔtwe (228) maa Ismaelfoɔ no, maa wɔde no kɔɔ Misraim. ");
INSERT INTO twiasante_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruben sane nʼakyi baa amena no ho, na ɔhunuu sɛ Yosef nni amena no mu no, ɔsunsuanee ne ntadeɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ɔkɔɔ ne nuammarimanom no hɔ, kɔka kyerɛɛ wɔn sɛ, “Abarimaa no nni hɔ oo! Enti, seesei menyɛ me ho dɛn ni!” ");
INSERT INTO twiasante_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Afei, anuanom no faa Yosef batakari no, kumm abirekyie, de batakari no nuu ne mogya no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Wɔde Yosef batakari fɛfɛ no kɔɔ wɔn agya nkyɛn, kɔka kyerɛɛ no sɛ, “Yɛhunuu saa atadeɛ yi wɔ wura mu hɔ baabi. Hwɛ sɛ ɛyɛ Yosef atadeɛ anaa?” ");
INSERT INTO twiasante_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Wɔn agya hunuiɛ ampa, kaa sɛ, “Nokorɛ, ɛyɛ me ba Yosef atadeɛ! Aboa bi akye no awe. Ampa ara sɛ, aboa ko no atete Yosef ɛnam pasaa.” ");
INSERT INTO twiasante_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Na Yakob sunsuanee ne ntadeɛ mu, hyɛɛ ayitadeɛ, suu ne ba no nna bebree. ");
INSERT INTO twiasante_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ne mmammarima ne ne mmammaa nyinaa bɛtwaa ne ho hyiaeɛ, kyekyeree ne werɛ, nanso ankɔsi hwee. Yakob kaa sɛ, “Dabi, mede awerɛhoɔ bɛwu akɔto me ba no asamando.” Enti, nʼagya Yakob suu no. ");
INSERT INTO twiasante_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Deɛ ɛbaeɛ ne sɛ, Midianfoɔ no nso kɔtɔn Yosef maa Potifar wɔ Misraim. Saa Potifar no na ɔyɛ ɔhene Farao dabehene ne nʼawɛmfoɔ so panin. ");
INSERT INTO twiasante_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ɛbaa sɛ saa ɛberɛ no ara mu, Yuda tu firii ne nuammarimanom no nkyɛn ne Adulamni ɔbarima bi a wɔfrɛ no Hira kɔtenaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ɛhɔ na Yuda kɔhyiaa Kanaanni ɔbaa bi a ɔyɛ ɔbarima bi a wɔfrɛ no Sua no babaa. Yuda waree Sua babaa no. ");
INSERT INTO twiasante_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Sua babaa no nyinsɛneeɛ, woo ɔbabarima, na wɔtoo no edin Er. ");
INSERT INTO twiasante_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Sua babaa no sane nyinsɛneeɛ woo ɔbabarima bio. Wɔtoo abɔfra no edin Onan. ");
INSERT INTO twiasante_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Sua babaa no nyinsɛneeɛ ne mprɛnsa so wɔ Kesib, woo ɔbabarima bio. Saa abarimaa no nso, wɔtoo no edin Sela. ");
INSERT INTO twiasante_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ɛberɛ a Yuda abakan Er nyiniiɛ no, wɔwaree ababaawa bi a wɔfrɛ no Tamar maa no. ");
INSERT INTO twiasante_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Esiane sɛ na Yuda abakan Er yɛ omumuyɛfoɔ wɔ Awurade anim no enti, Awurade kumm no. ");
INSERT INTO twiasante_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Er wuo akyiri no, Yuda ka kyerɛɛ Er akyiri ba Onan sɛ, “Ɛsɛ sɛ woware okunafoɔ Tamar, sɛdeɛ yɛn amanneɛ te no, na sɛ wo ne no wo a, mma no ayɛ wo nua no adedifoɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Esiane sɛ na Onan mpɛ sɛ ɔbɛwo akyɛ a mmɔfra no renyɛ nʼankasa mma enti, sɛ ɔne okunafoɔ Tamar kɔda a, ɔmma nʼahobaa no ngu ɔbaa no mu. Mmom, ɔma no gu fam sɛdeɛ ɛbɛyɛ a, ɔrenwo ɔba a ɛbɛyɛ ne nua owufoɔ no deɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Esiane sɛ deɛ ɔyɛeɛ no nsɔ Awurade ani, sɛ ɔmpɛ sɛ ɔwo ba ma ne nua owufoɔ no enti, ɔno nso, ɔkumm no. ");
INSERT INTO twiasante_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Afei, Yuda ka kyerɛɛ nʼase okunafoɔ Tamar sɛ, “Tu na kɔtena wʼagya fie sɛ okunafoɔ kɔsi sɛ me babarima Sala bɛnyini.” Na ɔsuro sɛ, Sela nso bɛwu, sɛdeɛ ne nuanom mpanimfoɔ Er ne Onan wuwuiɛ no. Enti, Tamar tu kɔtenaa nʼagya fie hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ɛwɔ hɔ ara na Yuda yere a ɔyɛ Sua babaa no nso wuiɛ. Ɛberɛ a wɔyii Yuda firii kuna mu no, ɔkɔɔ ne nnwanhotwitwafoɔ nkyɛn wɔ Timna. Ɔrekɔ no, ɔne nʼadamfo Adulamni Hira na ɛkɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Obi bɛbɔɔ Tamar amaneɛ sɛ, “Wʼase Yuda rebɛtwam akɔ Timna akɔtwitwa ne nnwan ho nwi.” ");
INSERT INTO twiasante_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Enti, Tamar yii ne kuna ntadeɛ no guu hɔ. Ɔfaa nkatanimu kataa nʼanim, sɛdeɛ ɛbɛyɛ a obiara nhunu sɛ ɛyɛ ɔno Tamar. Afei, ɔkɔtenaa Enaim kurotia wɔ Timna ɛkwan so. Ɛfiri sɛ, ɔhunuu sɛ Sela anyini deɛ, nanso na Yuda mmaa ne babarima no kwan mmaa ɔmmɛwaree no. ");
INSERT INTO twiasante_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ɛberɛ a Yuda hunuu Tamar no, na ɔdwene sɛ ɔyɛ ɔbaa dwamanfoɔ bi, ɛfiri sɛ, na wakata nʼanim. ");
INSERT INTO twiasante_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yuda kɔɔ Tamar nkyɛn wɔ ɛkwankyɛn hɔ a, na ɔnnim sɛ ɔyɛ nʼase. Yuda ka kyerɛɛ no sɛ, “Ma yɛnkɔ seesei ara na me ne wo nkɔda.” Tamar bisaa no sɛ, “Sɛ me ne wo kɔda a, wobɛma me ɛdeɛn?” ");
INSERT INTO twiasante_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda buaa sɛ, “Mɛma wɔde ɔpapo afiri me nnwankuo no mu abrɛ wo.” Tamar bisaa no bio sɛ, “Ansa na wode ɔpapo no bɛba no, ɛdeɛn na wode bɛdi wo ho agyinamu?” ");
INSERT INTO twiasante_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda nso bisaa no sɛ, “Ɛdeɛn adeɛ na wopɛ sɛ mede di me ho agyinamu?” Tamar buaa sɛ, “Deɛ fa di wo ho agyinamu ne wo nsa so kawa ne nʼahoma ne saa poma a ɛkura wo yi.” Enti, Yuda de saa nneɛma yi nyinaa maa Tamar ne no kɔdaeɛ, ma ɔnyinsɛneeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamar firii hɔ akyiri no, ɔkɔyii ne nkatanimu no guu hɔ, sane faa ne kunatam firaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda de ɔpapo no maa nʼadamfo Adulamni no sɛ, ɔmfa nkɔma ɔbaa no, na ɔnnye nneɛma a ɔde dii ne ho agyinamu no mmrɛ no no, wanhu no. Enti, Adulamni no ");
INSERT INTO twiasante_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","bisaa kurom hɔfoɔ no sɛ, “Ɛhe na hyiadan mu ɔbaa odwamanfoɔ a na ɔte Enaim kwankyɛn frɛfrɛ mmarima no wɔ?” Wɔbuaa no sɛ, “Yɛnni hyiadan mu ɔbaa odwamanfoɔ biara wɔ ha.” ");
INSERT INTO twiasante_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Enti, ɔsane kɔɔ Yuda hɔ, kɔka kyerɛɛ no sɛ, “Manhunu no. Ɛnna kurom hɔfoɔ nso kaa sɛ, ‘Hyiadan mu ɔbaa odwamanfoɔ biara nni ha.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda nso kaa sɛ, “Ma no mfa nneɛma no, na anyɛ saa a wɔbɛsere yɛn. Wo ara wodi ho adanseɛ sɛ memaa wode ɔpapo no kɔeɛ, nanso woanhunu no.” ");
INSERT INTO twiasante_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ɛbɛyɛ abosome mmiɛnsa akyiri no, Yuda tee sɛ nʼase Tamar abɔ adwaman, anyinsɛn. Ɔtee saa asɛm no, ɔkaa sɛ, “Monkɔkye no mmra, na yɛnhye no, nku no.” ");
INSERT INTO twiasante_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Wɔkɔkyeree Tamar de no reba abɛkum no no, ɔsoma ma wɔkɔka kyerɛɛ nʼase Yuda sɛ, “Onipa a ne nneɛma nie no na ɔne me nyinsɛneeɛ. Monhwɛ sɛ mobɛhunu onipa ko a saa nsa so kawa ne nʼahoma ne poma yi yɛ ne dea no anaa.” ");
INSERT INTO twiasante_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda gye too mu sɛ, saa nneɛma no yɛ ne dea. Ɔtoaa so sɛ, “Ɔbaa yi yɛ ɔteneneeni sen me, ɛfiri sɛ, mamfa no amma me babarima Sela anware.” Ɛfiri saa ɛberɛ no, Yuda ankɔ Tamar ho bio. ");
INSERT INTO twiasante_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar awoɔ duruu so no, ɔwoo nta. ");
INSERT INTO twiasante_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ɛberɛ a ɔrewo no, nta no mu baako de ne nsa dii ɛkan baeɛ. Enti, ɔbaa a ɔregye no awoɔ no de asaawa kɔkɔɔ bɔɔ abɔfra no abakɔn, kaa sɛ, “Yei na wɔwoo no kane.” ");
INSERT INTO twiasante_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Saa abɔfra no twee ne nsa sane kɔɔ mu. Ɔsane twee ne nsa kɔɔ mu no, wɔwoo ne nua a ɔka ne ho no mmom. Na ɔwogyefoɔ no kaa sɛ, “Ɛdeɛn abususɛm ni!” Wɔtoo no edin Peres. ");
INSERT INTO twiasante_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Akyire no, ɔwoo ne nuabarima a na asaawa kɔkɔɔ bɔ nʼabakɔn no. Wɔtoo ɔno nso edin Serah. ");
INSERT INTO twiasante_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Wɔde Yosef kɔɔ Misraim. Misraimni Potifar a na ɔyɛ Misraimhene Farao dabehene a na ɔtua asraafodɔm ano no na ɔtɔɔ Yosef firii Ismaelfoɔ adwadifoɔ no nsam. ");
INSERT INTO twiasante_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Na Awurade ka Yosef ho enti, nʼabrabɔ sii no yie. Ɔtenaa ne wura Misraimni no fie. ");
INSERT INTO twiasante_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Yosef wura no hunuu sɛ, Awurade ka ne ho, na ɔyɛeɛ no, Awurade hyiraa so maa no na ");
INSERT INTO twiasante_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","nʼabrabɔ sɔɔ ne wura no ani, maa ɔde no yɛɛ ne ɔboafoɔ. Ankyɛre koraa na Potifar de Yosef sii ne fiefoɔ so panin, de nʼagyapadeɛ ne nʼadwumadeɛ nyinaa hyɛɛ ne nsa. ");
INSERT INTO twiasante_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ɛberɛ a Potifar de Yosef sii ne fiefoɔ so panin, de nʼadwumadeɛ nyinaa hyɛɛ ne nsa no, ɛsiane Yosef enti, Awurade hyiraa Misraimni Potifar fie so. Awurade hyiraa nʼagyapadeɛ a ɛwɔ fie ne ne mfuo nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Enti, ɔde nʼagyapadeɛ nyinaa hyɛɛ Yosef nsa. Esiane sɛ Potifar de nʼagyapadeɛ ne nʼadwumadeɛ nyinaa hyɛɛ Yosef nsa enti, wannwene biribiara ho sɛ aduane a ɔbɛdi nko ara. Na Yosef yɛ aberanteɛ a ɔwɔ nnyinasoɔ, na ne ho nso yɛ fɛ yie. ");
INSERT INTO twiasante_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ankyɛre ahe biara na Yosef wura Potifar yere tuu nʼani sii ne so. Ɛda bi, Potifar yere no ka kyerɛɛ Yosef sɛ, “Bra, na wo ne me mmɛda!” ");
INSERT INTO twiasante_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Nanso, Yosef ampene so, ka kyerɛɛ ne wura yere no sɛ, “Esiane sɛ efie ha biribiara hyɛ me nsa enti, me wura nnwene efie ha biribiara ho. Ɔde nʼagyapadeɛ nyinaa ahyɛ me nsa. ");
INSERT INTO twiasante_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Obiara nni tumi nsene me wɔ efie ha. Me wura mmfa biribiara nkame me wɔ efie ha sɛ wo nko ara, ɛfiri sɛ, woyɛ ne yere. Onyame mpa ngu sɛ mɛyɛ adeɛ a ɛte saa. Ɛbɛyɛ dɛn na matumi ayɛ amumuyɛdeɛ a ɛte seyie! Ɛbɛyɛ bɔne kɛseɛ atia Onyankopɔn.” ");
INSERT INTO twiasante_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ɛwom sɛ ɛda biara da na Potifar yere no de saa asɛm yi dwan Yosef ho deɛ, nanso Yosef antwe ammɛn no mpo, na akɔwie sɛ ɔne no bɛda. ");
INSERT INTO twiasante_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ɛda koro bi, Yosef kɔɔ efie hɔ sɛ ɔrekɔyɛ nʼadwuma. Ɔduruu hɔ no, na asomfoɔ no mu biara nni hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Potifar yere no sɔɔ Yosef atadeɛ mu, ka kyerɛɛ no sɛ, “Bra na wo ne me mmɛda!” Nanso, Yosef paa nʼatadeɛ no guu ne so, dwane firii efie hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Potifar yere no hunuu sɛ Yosef apa nʼatadeɛ agu ne so, na wadwane afiri efie hɔ no, ");
INSERT INTO twiasante_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ɔfrɛɛ ne fiefoɔ, de nteateam ka kyerɛɛ wɔn sɛ, “Monhwɛ! Me kunu akɔfa Hebrini bi aba efie ha sɛ ɔmmɛgu yɛn anim ase. Ɔbaa ha sɛ ɔrebɛto me monnaa na meteateaam. ");
INSERT INTO twiasante_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ɔtee sɛ mereteateam no, ɔpaa nʼatadeɛ guu me so, dwane firii fie ha.” ");
INSERT INTO twiasante_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Potifar yere no de Yosef atadeɛ a ɔpa guu ne so no sieeɛ, kɔsii sɛ ne kunu baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ɔbaa no bɔɔ ne kunu amaneɛ sɛ, “Hebrini akoa no a wokɔtɔɔ no brɛɛ yɛn no baa me nkyɛn sɛ anka ɔrebɛto me monnaa. ");
INSERT INTO twiasante_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Meteateaam no na ɔdwane firii efie ha, gyaa nʼatadeɛ hɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ɛberɛ a Yosef wura Potifar tee asɛm a ne yere ka kyerɛɛ no sɛ, “Ɔkwan a wʼakoa no de me faa so nie” no, ne bo fuu yie. ");
INSERT INTO twiasante_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Yosef wura Potifar tee asɛm no no, ɔkyeree Yosef kɔtoo afiase, faako a ɔhene nneduafoɔ guo no. Ɛberɛ a Yosef da afiase hɔ no, ");
INSERT INTO twiasante_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","na Awurade ka ne ho. Awurade yɛɛ no adɔeɛ, maa ɛno enti, afiase sohwɛfoɔ panin no pɛɛ nʼasɛm yie. ");
INSERT INTO twiasante_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ɛyɛɛ saa maa afiase sohwɛfoɔ panin no de Yosef sii nneduafoɔ no nyinaa so panin, a na biribiara a wɔyɛ wɔ afiase hɔ no hyɛ ne nsa. ");
INSERT INTO twiasante_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Esiane sɛ na Awurade ka Yosef ho no enti, na afiase sohwɛfoɔ panin no nha ne ho nyɛ adwuma. Ɛfiri sɛ, biribiara a Yosef bɛyɛ no nso, Awurade hyira so ma ɛsi yie. ");
INSERT INTO twiasante_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Mmerɛ tiawa bi akyiri no, ɛbaa sɛ Misraimhene Farao nsãhyɛfoɔ panin ne ne burodotofoɔ panin fom no. ");
INSERT INTO twiasante_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farao bo fuu ne nsãhyɛfoɔ panin no ne ne burodotofoɔ panin no yie. ");
INSERT INTO twiasante_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Enti, ɔde wɔn too afiase wɔ ɔwɛmfoɔ panin Potifar no fie, baabi korɔ no ara a wɔde Yosef kɔtoeɛ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ɔwɛmfoɔ panin Potifar de wɔn hyɛɛ Yosef nsa sɛ, ɔnhwɛ na ɔnyɛ deɛ ɛhia wɔn nyinaa mma wɔn. Wɔdaa afiase hɔ kyɛɛ kakraa no, ");
INSERT INTO twiasante_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","nnipa baanu no nyinaa a na wɔyɛ ɔhene Farao burodotofoɔ panin ne nsãhyɛfoɔ panin a na wɔgu afiase hɔ no sosoo daeɛ anadwo korɔ no ara. Na saa daeɛ mmienu no mu biara wɔ ne nkyerɛaseɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Adeɛ kyeeɛ a Yosef baa nneduafoɔ baanu no nkyɛn no, ɔhunuu sɛ wɔn nyinaa ayeyɛ mosomosoo. ");
INSERT INTO twiasante_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Enti, ɔbisaa Farao fie mpanimfoɔ nneduafoɔ a na wɔne no gu afiase hɔ no sɛ, “Adɛn enti na ɛnnɛ deɛ, mo werɛ aho mo ho sɛɛ?” ");
INSERT INTO twiasante_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nneduafoɔ no buaa Yosef sɛ, “Anadwo yi, yɛn baanu nyinaa sosoo daeɛ, nanso yɛnnya obiara wɔ ha nkyerɛ yɛn aseɛ.” Yosef nso ka kyerɛɛ wɔn sɛ, “Ɛwom sɛ Onyankopɔn na ɔkyerɛ daeɛ ase deɛ, nanso monka mo daeɛ a mososoeɛ no nkyerɛ me.” ");
INSERT INTO twiasante_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Enti, Farao nsãhyɛfoɔ panin no dii ɛkan kaa ne daeɛ a ɔsoeɛ no kyerɛɛ Yosef sɛ, “Me daeɛ mu no, mehunuu bobe dua. ");
INSERT INTO twiasante_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Na saa bobe dua no apan mman mmiɛnsa. Ɛguu nhyerɛnne, hyehyɛeɛ, nyiniiɛ, yɛɛ siaka bereeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na mekura ɔhene Farao nsã kuruwa. Metetee bobe aba no, kyikyi guu ɔhene Farao nsã kuruwa no mu, de maa no sɛ ɔnnom.” ");
INSERT INTO twiasante_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosef ka kyerɛɛ nsãhyɛfoɔ panin deduani no sɛ, “Wo daeɛ no ase nie: mman mmiɛnsa a wohunuiɛ no kyerɛ nnansa. ");
INSERT INTO twiasante_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nnansa ntam no, Farao bɛyi wo, ama woakɔdi wo dibea sɛ ɔhene nsãhyɛfoɔ panin. Na wode Farao kuruwa bɛhyɛ ne nsa sɛdeɛ na woyɛ no kane no. ");
INSERT INTO twiasante_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Na sɛ ɛsi wo yie a, kae me. Mesrɛ wo, ɛyɛ a, ka me ho asɛm kyerɛ ɔhene Farao, na ɔmma wɔmmɛyi me mfiri afiase ha. ");
INSERT INTO twiasante_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ɛfiri sɛ, nokorɛ ni, manyɛ bɔne biara na wɔkyeree me firii me manfoɔ Hebrifoɔ asase so de mebaa ha. Na ɛha nso mpo a meda yi, manyɛ afɔdisɛm biara a ɛsɛ sɛ wɔgyina so de me to afiase.” ");
INSERT INTO twiasante_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ɛberɛ a burodotofoɔ panin deduani no hunuu sɛ Yosef akyerɛ nsãhyɛfoɔ panin no daeɛ no ase, ama atɔ asom no, ɔka kyerɛɛ Yosef sɛ, “Me nso, mesoo daeɛ bi. Me daeɛ no mu, na mesoso nkɛntɛn mmiɛnsa a burodo gugu mu. ");
INSERT INTO twiasante_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kɛntɛn a ɛsi ɛsoro pɛɛ no, na nnuane ahodoɔ a wɔato a mede rekɔma Farao gu mu a na nnomaa sisi aduane no so wɔ mʼatifi, redi.” ");
INSERT INTO twiasante_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosef ka kyerɛɛ no sɛ, “Wo daeɛ a wosoeɛ no asekyerɛ ni. Nkɛntɛn mmiɛnsa no gyina hɔ ma nnansa. ");
INSERT INTO twiasante_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nnansa ntam no, Farao bɛma wɔabɛyi wo afiri afiase ha, atwa wo ti, de wo kuntunsini no akɔsɛn dua so, ama nnomaa asosɔ wo ɛnam.” ");
INSERT INTO twiasante_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ne nnansa so no, na Farao redi nʼawoda. Enti, ɔtoo ɛpono kɛseɛ bi maa ne mpanimfoɔ ne ne fiefoɔ nyinaa. Ɔsoma ma wɔkɔyii ne burodotofoɔ panin ne ne nsãhyɛfoɔ panin nneduafoɔ no firii afiase hɔ baa nʼanim. ");
INSERT INTO twiasante_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ɔhene Farao sane de ne nsãhyɛfoɔ panin no sii ne siberɛ, ma ɔhyɛɛ ɔhene Farao nsã. ");
INSERT INTO twiasante_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Nanso, ne burodotofoɔ panin no deɛ, Farao ma wɔkɔsɛn no sɛdeɛ Yosef kyerɛɛ ne daeɛ no ase kyerɛɛ no no pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Nsãhyɛfoɔ panin no nso werɛ firii Yosef a wankae no koraa. ");
INSERT INTO twiasante_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Mfeɛ mmienu akyiri no, Farao soo daeɛ bi. Na ɔgyina Asubɔnten Nil ho. ");
INSERT INTO twiasante_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ɔhunuu wɔ daeɛ no mu sɛ, anantwie nson a wɔadodɔre sradeɛ, na wɔn ho tua wɔn firii asubɔnten no mu baeɛ bɛwee ɛserɛ a na ɛwɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Anantwie akɛseɛ nson no akyiri no, anantwie nson foforɔ a wɔafonfɔn ayeyɛ kanyakanya firii Asubɔnten Nil mu ba bɛgyinaa anantwie a wɔadodɔ sradeɛ no ho wɔ asuo no konkɔn so. ");
INSERT INTO twiasante_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Anantwie nson a wɔafonfɔn ayeyɛ kanyakanya no memenee anantwie nson a wɔadodɔre sradeɛ no! Saa ɛberɛ no ara mu na Farao bɔɔ pitiri nyaneeɛ! ");
INSERT INTO twiasante_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Yei akyiri, nna faa Farao bio ma ɔsane soo daeɛ foforɔ. Ɔhunuu wɔ daeɛ no mu sɛ, ɛmo asiaka nson a ɛwɔ ahoɔden na ɛyɛ fɛ aso wɔ ɛmo nan baako so. ");
INSERT INTO twiasante_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Akyiri no prɛko pɛ, siaka nson bi soo wɔ nan no ho. Apueeɛ mframa bɔɔ no ma ɛtwintwamee. ");
INSERT INTO twiasante_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ɛmo ntweantweaa no memenee ɛmo a ɛwɔ ahoɔden na ɛyɛ fɛ no. Farao sane nyanee bio, hunuu sɛ, sɛɛ na nneɛma a ɔhunuiɛ no nyinaa yɛ daeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Adeɛ kyeeɛ no, nʼadwenem yɛɛ no basaa. Enti, Farao soma ma wɔkɔfrɛɛ nkonyaayifoɔ ne anyansafoɔ a wɔwɔ Misraim asase so nyinaa baa ne fie. Farao kaa daeɛ a ɔsoeɛ no nyinaa kyerɛɛ wɔn, nanso wɔn mu biara antumi ankyerɛ aseɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ɛhɔ na Farao nsãhyɛfoɔ panin no ka kyerɛɛ Farao sɛ, “Ɛnnɛ na saa asɛm yi ama makae me mfomsoɔ bi a mayɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Mmerɛ bi a atwam no, wo Farao bo fuu wʼasomfoɔ yie. Ɛnam so maa wode me ne wo burodotofoɔ panin kɔtoo afiase wɔ dabehene fie. ");
INSERT INTO twiasante_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Yɛn baanu nyinaa soo daeɛ anadwo korɔ no ara a na ɛsono sɛdeɛ yɛn mu biara daeɛ no si teɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Saa ɛberɛ no, na Hebrini aberantewaa bi a na ɔyɛ dabehene Potifar ɔsomfoɔ ka yɛn ho wɔ afiase hɔ. Yɛkaa yɛn daeɛ a yɛsosoeɛ no kyerɛɛ no no, ɔkyerɛɛ yɛn mu biara daeɛ ase, kyerɛɛ no pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Na sɛdeɛ ɔsi fa kyerɛɛ yɛn daeɛ no ase no baa mu saa pɛpɛɛpɛ. Mesane kɔdii me dibea, ɛnna burodotofoɔ panin no, wɔsɛn no.” ");
INSERT INTO twiasante_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Amonom hɔ ara, Farao soma ma wɔkɔyii Yosef firii afiase hɔ baeɛ. Ɔfiri afiase hɔ baeɛ no, ɔyii nʼabɔgyesɛ, sesaa nʼatadeɛ, baa Farao anim. ");
INSERT INTO twiasante_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao ka kyerɛɛ Yosef sɛ, “Maso daeɛ bi a obiara ntumi nkyerɛ aseɛ. Nanso, mate sɛ wo deɛ, sɛ obi ka ne daeɛ kyerɛ wo a, wotumi kyerɛ aseɛ. Ɛno enti na masoma abɛfrɛ wo yi.” ");
INSERT INTO twiasante_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosef buaa Farao sɛ, “Me ara merentumi mfiri me tumi mu nkyerɛ daeɛ no ase. Onyankopɔn na ɔbɛkyerɛ wo daeɛ no ase.” ");
INSERT INTO twiasante_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Afei, Farao ka kyerɛɛ Yosef sɛ, “Me daeɛ no mu, na megyina Asubɔnten Nil konkɔn so. ");
INSERT INTO twiasante_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Mehunuu wɔ daeɛ no mu sɛ, anantwie nson a wɔadodɔre sradeɛ, na wɔn ho tua wɔn firii asubɔnten no mu baeɛ bɛnantee wira no mu, hyɛɛ aseɛ wee serɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Anantwie akɛseɛ nson no akyiri no, anantwie nson foforɔ a wɔafonfɔn ayeyɛ kanyakanya firii Asubɔnten Nil mu ba bɛgyinaa anantwie a wɔadodɔ sradeɛ no ho wɔ asuo no konkɔn so. Ɛfiri sɛ wɔwoo me, menhunuu anantwie a wɔn ho yɛ tan saa da wɔ Misraim asase yi so. ");
INSERT INTO twiasante_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Anantwie nson a wɔafonfɔn ayeyɛ kanyakanya no memenee anantwie nson a wɔadodɔre sradeɛ na wɔn ho tua wɔn a wɔdii ɛkan baeɛ no! ");
INSERT INTO twiasante_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Nanso wɔmemenee wɔn nyinaa akyiri no, na sɛdeɛ wɔte ara na wɔte, ɛfiri sɛ, na wɔn ho da so yɛ tan kanyakanya no ara. Saa ɛberɛ no ara mu na mebɔɔ pitiri nyaneeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Mesane soo daeɛ bio hunuu sɛ, ɛmo siaka nson a ɛyɛ fɛ na ɛwɔ ahoɔden sɛ aso wɔ ɛmo nan baako so. ");
INSERT INTO twiasante_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Yeinom akyiri no, ɛmo asiaka nson bi a apueeɛ mframa abɔ no, ama akusa, ayeyɛ ntweantweaa soo wɔ ɛmo nan no so. ");
INSERT INTO twiasante_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ɛmo ntweantweaa no memenee ɛmo nson a ɛyɛ fɛ na ɛwɔ ahoɔden no. Mekaa me daeɛ no nyinaa kyerɛɛ nkonyaayifoɔ no, wɔn mu biara antumi ankyerɛ me aseɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ɛnna Yosef ka kyerɛɛ Farao sɛ, “Wo daeɛ mmienu a wososoeɛ no nyinaa nkyerɛaseɛ yɛ pɛ. Onyankopɔn nam wo daeɛ no so, reda biribi a ɔrebɛma asi wɔ Misraim asase so no adi akyerɛ wo. ");
INSERT INTO twiasante_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Anantwie nson a wɔadodɔre sradeɛ no ne ɛmo siaka nson a ɛyɛ fɛ, na ɛwɔ ahoɔden no nso, ase kyerɛ sɛ, mfeɛ nson a ɛdi anim a ɛreba no bɛyɛ mfeɛ pa ama ɔman no. ");
INSERT INTO twiasante_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Anantwie nson a wɔafonfɔn, na wɔayeyɛ kanyakanya no ne ɛmo siaka nson a akusa ayeyɛ ntweantweaa no nso kyerɛ sɛ, mfeɛ pa nson no akyiri no, ɛkɔm bɛba mfeɛ nson. ");
INSERT INTO twiasante_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Enti, Onyankopɔn akyerɛ wo deɛ ɔrebɛyɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Mfeɛ nson a ɛdi ɛkan no, aduane bɛbu wɔ Misraim asase so nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Nanso, akyire no, ɛkɔm kɛseɛ bi bɛba mfeɛ nson, ama nnipa werɛ afiri asetena pa a wɔnyaa no mfeɛ nson a ɛdi ɛkan no mu no. Ɛkɔm bɛmene asase no. ");
INSERT INTO twiasante_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Esiane ɛkɔm a ɛbɛdi mmerɛ pa a atwam no akyiri no ano den a ɛbɛyɛ no enti, saa ɛberɛ no, wɔrenkae mmerɛ pa no bio wɔ asase no so. ");
INSERT INTO twiasante_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Saa daeɛ mmienu a wosoeɛ no kyerɛ sɛdeɛ ɛkɔm no ano bɛyɛ den afa. Ɛkyerɛ sɛ, deɛ ɛbɛyɛ biara, asɛm a maka akyerɛ wo no bɛba mu saa pɛpɛɛpɛ. Ɛfiri sɛ, Onyankopɔn na wasi gyinaeɛ pi saa. Na ɛrenkyɛre koraa, ɛbɛba mu saa. ");
INSERT INTO twiasante_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Enti, mʼafotuo ne sɛ, hwehwɛ onyansafoɔ kɛseɛ a ɔwɔ nhunumu wɔ Misraim asase yi so, na fa ɔman yi mu kuadwuma ho asɛm nyinaa hyɛ ne nsa. ");
INSERT INTO twiasante_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ma ɔhene Farao nyiyi nnipa, ntuatua amansini ahodoɔ enum no ano. Na saa nnipa a wɔde wɔn bɛtuatua amansini no ano no nyiyi nnɔbaeɛ a ɛbɛba mmerɛ pa mfeɛ nson no mu no nkyɛmu enum mu baako, mfa nsie. ");
INSERT INTO twiasante_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ɛsɛ sɛ saa nnipa a wɔtuatua amansini no ano no boaboa nnuane a wɔbɛgyegye mmerɛ pa mfeɛ nson a nnuane bɛbu no, de gu asan so wɔ ɔhene Farao edin mu. Wɔmfa saa nnuane no nhyehyɛ asan so wɔ nkuro akɛseɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nnuane yi na mfeɛ nson a ɛkɔm bɛba Misraim asase so no, ɔmanfoɔ no bɛdi. Saa nnuane yi na wɔde bɛsie ama ɔman no. Sɛ anyɛ saa a, akyinnyeɛ biara nni ho sɛ, ɛkɔm bɛbɔ ɔman no.” ");
INSERT INTO twiasante_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Farao ne ne mpanimfoɔ no gyee asɛm a Yosef ka kyerɛɛ wɔn no nyinaa too mu. ");
INSERT INTO twiasante_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ɛberɛ a wɔredwennwene onipa ko a ɛsɛ sɛ wɔde saa adwuma kɛseɛ yi hyɛ ne nsa no ho no, Farao bisaa sɛ, “Hwan koraa na ɔbɛtumi ayɛ adwuma kɛseɛ a ɛte sɛɛ yi asene Yosef? Ɛfiri sɛ, ɔyɛ onipa bi a, akwan nyinaa mu, ɛda adi pefee sɛ, Onyankopɔn honhom ahyɛ no ma.” ");
INSERT INTO twiasante_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Afei, Farao danee nʼani ka kyerɛɛ Yosef sɛ, “Onyankopɔn ayi saa daeɛ yi ne nʼasekyerɛ akyerɛ wo yi, hwan bio na ɔyɛ onyansafoɔ a ɔwɔ nhunumu sene wo wɔ Misraim ɔman yi mu! ");
INSERT INTO twiasante_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ɛnnɛ, mede saa adwuma kɛseɛ yi nyinaa hyɛ wo nsa. Asɛm biara a wobɛka afa saa adwuma yi ho no, obiara nni ho asɛm ka wɔ Misraim nyinaa. Mʼahennwa a me Farao, mete so no nko ara na ɛma meyɛ kɛse sene wo.” ");
INSERT INTO twiasante_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Enti, Farao ka kyerɛɛ Yosef sɛ, “Ɛfiri ɛnnɛ de rekorɔ, mede Misraim asase nyinaa ahyɛ wo nsa.” ");
INSERT INTO twiasante_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Afei, Farao worɔɔ ne nsɔano kawa de hyɛɛ Yosef nsa. Ɔde serekye batakari papa bi hyɛɛ Yosef, de sika ntweaban yan no. ");
INSERT INTO twiasante_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ɔmaa Yosef teaseɛnam tenaa mu sɛ nʼabadiakyire. Baabiara a Yosef bɛkɔ no, na nnipa di nʼanim teateaam sɛ, “monkoto no!” Saa ɛkwan yi so na ɔhene Farao fa de Misraim asase nyinaa hyɛɛ Yosef nsa. ");
INSERT INTO twiasante_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Afei, Farao ka kyerɛɛ Yosef sɛ, “Mene Farao Misraimhene deɛ, nanso obiara ntumi mfiri wʼakyi nyɛ biribiara wɔ Misraiman yi mu baabiara, gye sɛ woama ho kwan ansa.” ");
INSERT INTO twiasante_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao maa Yosef ahene din sɛ Safnat-Panea. Farao maa Yosef ɔbaa nso wareeɛ. Na ababaawa no din de Asnat a ɔyɛ ɔbosom On kɔmfoɔ Potifera babaa. Ɛnam yei so maa Yosef nyaa tumi maa ne din hyetaa Misraim asase so nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ɛberɛ a Yosef kɔɔ ɔhene Farao adwa ase no, na wadi mfirinhyia aduasa. Farao maa Yosef ɛkwan ma ɔbɔɔ aporɔ faa Misraim asase so nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mfeɛ nson a ɛdi ɛkan no mu no, aduane buu so wɔ Misraim asase so yie. ");
INSERT INTO twiasante_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Saa mfeɛ nson no mu no, Yosef boaboaa nnuane a ɛbuu so wɔ Misraiman mu no ano kɔkoraa no wɔ nkuropɔn a ɛwowɔ Misraim no mu. Aduane biara a wɔnya firii kuro biara mu no bi no, wɔde sie wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Mfeɛ nson akyiri no, na Yosef akora nnuane wɔ nnuanekorabea hɔ, ama abu so ara kɔsii sɛ, afei na obiara mmu ho nkonta bio. ");
INSERT INTO twiasante_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ansa na ɛkɔm kɛseɛ no rebɛba no, na Yosef yere Asnat, a ɔyɛ ɔbosom On kɔmfoɔ Potifera babaa no, awo mmammarima baanu. ");
INSERT INTO twiasante_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosef too nʼabakan no edin Manase, a asekyerɛ ne Onyankopɔn ama me werɛ afiri mʼamanehunu ne mʼagya fie nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Yosef babarima a ɔtɔ so mmienu no nso, wɔtoo no edin Efraim, a asekyerɛ ne Onyankopɔn ama mʼase afɛe wɔ asase a mebaa so sɛ akoa no so. ");
INSERT INTO twiasante_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Afei, mfeɛ nson a aduane buu so wɔ Misraim asase so no twaam. ");
INSERT INTO twiasante_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Sɛdeɛ Yosef hyɛɛ nkɔm no, ɛkɔm a ɛbɛba mfeɛ nson a ɛdi so no hyɛɛ aseɛ. Ɛkɔm kɛseɛ sii nsase a na atwa Misraim ho ahyia no nyinaa so, nanso Misraim asase ankasa so deɛ, na aduane abu so. ");
INSERT INTO twiasante_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ɛberɛ a ɛkɔm no sii dendeenden wɔ Misraim asase so no, ɔmanfoɔ no su frɛɛ Farao. Farao ka kyerɛɛ Misraimfoɔ nyinaa sɛ, “Monkɔ Yosef nkyɛn, na biribiara a ɔbɛka akyerɛ mo sɛ monyɛ no, monyɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ɛberɛ a ɛkɔm kɛseɛ no trɛtrɛɛ ɔman no nyinaa mu no, Yosef buebuee ne nnuane korabea no nyinaa ano, tɔnee aburoo maa Misraimfoɔ no, ɛfiri sɛ, na ɛkɔm no ano yɛ den yie ma wɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Enti, na aman a atwa Misraim ho ahyia no nyinaa kɔtɔ aduane wɔ Yosef nkyɛn wɔ Misraim, ɛfiri sɛ, na ɛkɔm a aba no ano yɛ den yie. ");
INSERT INTO twiasante_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ɛberɛ a Yakob tee sɛ aburoo wɔ Misraim no, ɔka kyerɛɛ ne mmammarima no sɛ, “Adɛn enti na moatete agyinagyina rehwehwɛhwehwɛ mo ho mo ho anim yi?” ");
INSERT INTO twiasante_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Yakob toaa so sɛ, “Mate sɛ aburoo wɔ Misraim. Monkɔ hɔ, na monkɔtɔ bi mmra na ɛkɔm ankum yɛn.” ");
INSERT INTO twiasante_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Enti, Yosef nuammarima mpanimfoɔ edu no kɔɔ Misraim sɛ wɔrekɔtɔ aburoo no bi. ");
INSERT INTO twiasante_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Nanso, Yakob amma Benyamin a ɔyɛ Yosef nua kumaa no ankɔ bi, ɛfiri sɛ, na ɔsuro sɛ biribi bɛyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Enti, Israel mmammarima no de wɔn ho bɔɔ atɔfoɔ a wɔfifiri aman ahodoɔ so kɔtɔ aburoo wɔ Misraim no ho, ɛfiri sɛ, na ɛkɔm no atrɛ akɔduru Kanaan asase so mmaa nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Na Yosef yɛ amrado wɔ Misraim asase so. Ɔno na ɔtɔn aburoo ma nnipa nyinaa wɔ ɔman no mu. Yosef nuammarima no kɔduruu nʼanim no, wɔbuu no nkotodwe, de wɔn anim nso butubutuu fam. ");
INSERT INTO twiasante_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ɛberɛ a Yosef ani bɔɔ anuanom no so ara pɛ, ɔhunuu sɛ wɔyɛ ne nuanom, nanso ɔyɛɛ ne ho sɛdeɛ ɔnnim wɔn, kasaa anihanehane so kyerɛɛ wɔn. Ɔpoopoo nʼani, bisaa wɔn sɛ, “Mofiri he?” Anuanom no buaa no sɛ, “Yɛfiri Kanaan asase so, na yɛaba sɛ yɛrebɛtɔ aduane.” ");
INSERT INTO twiasante_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ɛwom sɛ na Yosef ahunu wɔn sɛ ne nuanom, nanso ne nuanom no deɛ, na wɔnhunuu sɛ, ɔno ne Yosef. ");
INSERT INTO twiasante_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yosef kaee daeɛ a mmerɛ bi ɔso faa wɔn ho no. Ɔka kyerɛɛ wɔn sɛ, “Moyɛ akwansrafoɔ! Morebɛhwɛ sɛdeɛ ɛkɔm yi ama yɛn asase yi agyigya.” ");
INSERT INTO twiasante_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Anuanom no teaam sɛ, “Dabi yɛn wura, ɛnte saa. Yɛbaeɛ sɛ yɛrebɛtɔ aduane. ");
INSERT INTO twiasante_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Yɛn nyinaa firi agya baako. Yɛyɛ nnipa pa, na yɛnyɛ akwansrafoɔ saa.” ");
INSERT INTO twiasante_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Nanso, Yosef ka tii mu sɛ, “Dabi, morebɛhwɛ sɛdeɛ asase no asi agyigya afa.” ");
INSERT INTO twiasante_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Anuanom no buaa sɛ, “Yɛn, wʼasomfoɔ, yɛyɛ anuanom dumienu. Yɛyɛ ɔpanin bi a ɔte Kanaan asase so mma. Seesei, yɛn kaakyire no wɔ yɛn agya nkyɛn, ɛnna ɔbaako nso afiri mu.” ");
INSERT INTO twiasante_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Nanso, Yosef ka kyerɛɛ wɔn sɛ, “Asɛm a meka kyerɛɛ mo sɛ moyɛ akwansrafoɔ no, ɛno ara ne no. ");
INSERT INTO twiasante_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ɛkwan a mepɛ sɛ mefa so de sɔ mo hwɛ nie: mmerɛ dodoɔ a Farao te ase yi, meremma mo mfiri Misraim asase so ha nkɔ da, kɔsi sɛ mode mo kaakyire no bɛba. ");
INSERT INTO twiasante_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Monsoma mo mu baako, na ɔnkɔfa mo kaakyire no mmra. Mede mo a moaka no nyinaa bɛgu afiase. Ɛno na ɛbɛma yɛahunu sɛ, mo asɛm a moreka no yɛ nokorɛ anaa ɛnyɛ nokorɛ. Sɛ ɛkɔba sɛ monni nuabarima kumaa a ɔyɛ mo kaakyire a, mmerɛ dodoɔ a Farao te ase yi, na ɛkyerɛ sɛ moyɛ akwansrafoɔ ampa!” ");
INSERT INTO twiasante_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Enti, ɔde wɔn guu afiase hɔ nnansa. ");
INSERT INTO twiasante_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ne nnansa so no, Yosef ka kyerɛɛ ne nuanom no sɛ, “Meyɛ onyamesuroni. Ɛno enti, merebɛma mo ɛkwan ama moasane mo ho sɛ monyɛ akwansrafoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Sɛ moyɛ nokwafoɔ ampa ara a, momma mo nua baako nna afiase ha. Mo a moaka no nso, monkɔtɔ aburoo no bi nkɔma mo fiefoɔ a ɛkɔm rekum wɔn no. ");
INSERT INTO twiasante_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Nanso, ɛkwan biara so no, momfa mo nua kumaa no mmɛkyerɛ me. Ɛno na ɛbɛma mahunu sɛ, asɛm a moreka no yɛ nokorɛ anaasɛ ɛnyɛ nokorɛ. Na sɛ nokorɛ na moreka deɛ a, mɛgyaa mo.” Wɔpenee abisadeɛ a Yosef de too wɔn anim no so. ");
INSERT INTO twiasante_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Afei, wɔkeka kyerɛkyerɛɛ wɔn ho wɔn ho sɛ, “Nokorɛm, yɛn nuabarima yi enti na wɔretwe yɛn aso. Yɛhunuu sɛdeɛ wabɔ huboa ne sɛdeɛ ɔsrɛɛ ne nkwa no, nanso yɛantie. Ɛno enti na saa amanehunu yi a aba yɛn so ɛnnɛ yi.” ");
INSERT INTO twiasante_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Afei, anuanom no mu panin a wɔfrɛ no Ruben no kaa sɛ, “Manka mankyerɛ mo sɛ monnyɛ bɔne biara ntia abarimaa no? Nanso moantie! Afei na ɛsɛ sɛ yɛbu ne mogya ho akonta” ");
INSERT INTO twiasante_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Esiane sɛ na obi kyerɛ nsɛm a Yosef ka no ase kyerɛ wɔn no enti, na wɔnnim sɛ Yosef te wɔn kasa. ");
INSERT INTO twiasante_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yosef sɔre firii wɔn nkyɛn kɔsuiɛ. Ɔsane baeɛ ne wɔn bɛkasaa bio. Ɔyii Simeon firii wɔn mu, ma wɔkyekyeree no wɔ wɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosef hyɛɛ sɛ, wɔnhyɛ wɔn nkotokuo no aburoo ma ma, na wɔnsane mfa obiara sika a anka ɔde rebɛtɔ aburoo nhyɛ ne kotokuo mu, na wɔmma wɔn akwansoduane nso nka ho. Wɔyɛɛ yei maa wɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Wɔhyehyɛɛ wɔn aburoo nkotokuo no wɔ mfunumu no so, siim sɛ wɔrekɔ wɔn kurom. ");
INSERT INTO twiasante_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Wɔrekɔ no ara, wɔgyinaa ɛkwan so anadwo homeeɛ. Ɛhɔ na wɔn mu baako sanee ne kotokuo ano sɛ ɔrema nʼafunumu aduane adi. Ɔsanee ne kotokuo no ano no, ɔhunuu sɛ ne sika a anka ɔde rekɔtɔ aburoo no hyɛ kotokuo no fa baabi. ");
INSERT INTO twiasante_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ɔka kyerɛɛ ne nuanom no sɛ, “Wɔde me sika no asane ahyɛ me kotokuo no mu. Monhwɛ. Ɛno nie!” Saa asɛm yi maa wɔn akoma tutuiɛ. Enti, wɔhwehwɛɛ wɔn ho wɔn ho anim kaa sɛ, “Ɛdeɛn anwanwadeɛ na Onyankopɔn ayɛ yɛn yi?” ");
INSERT INTO twiasante_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Wɔduruu wɔn agya Yakob nkyɛn wɔ Kanaan no, wɔbɔɔ no nsɛm a asisi no nyinaa ho amaneɛ. Wɔkaa sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Yɛduruu Misraim asase so no, ɔbarima a ɔhwɛ asase no so no a ɔyɛ asase no so ɔhene ɔboafoɔ no poopoo nʼani, kasaa anihanehane so kyerɛɛ yɛn sɛ, yɛyɛ akwansrafoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nanso, yɛbuaa no sɛ, ‘Yɛyɛ nnipa pa, na yɛnyɛ akwansrafoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Yɛyɛ anuanom dumienu a yɛfiri agya baako. Ɔbaako afiri mu. Seesei, yɛn kaakyire no wɔ yɛn agya nkyɛn wɔ Kanaan.’ ");
INSERT INTO twiasante_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Afei, ɔbarima a ɔhwɛ asase no so ka kyerɛɛ yɛn sɛ, ‘Ɛkwan a mepɛ sɛ mefa so de sɔ mo hwɛ nie: Monnya mo nuanom baako wɔ me nkyɛn ha, na monkɔtɔ aburoo no bi nkɔma mo fiefoɔ a ɛkɔm rekum wɔn no. ");
INSERT INTO twiasante_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Nanso, momfa mo nua kumaa no mmɛkyerɛ me. Ɛno na ɛbɛma mahunu sɛ monyɛ akwansrafoɔ na moyɛ nnipa pa. Na mede mo nua no bɛma mo, na mobɛtumi abɛtɔ aburoo no bi wɔ asase yi so mpɛn dodoɔ biara a mopɛ.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ɛberɛ a wɔrehwiehwie wɔn aburoo no afiri wɔn nkotokuo no mu no, obiara hunuu ne sika a anka ɔde rekɔtua aburoo no ka wɔ ne kotokuo no ano. Wɔne wɔn agya hunuu sika no, wɔn akoma tutuiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ɛyɛɛ saa maa wɔn agya Yakob ka kyerɛɛ wɔn sɛ, “Moama mahwere me mma. Yosef nni hɔ; Simeon nso nni hɔ; afei mopɛ sɛ mofa Benyamin nso ka ho! Biribiara ko tia me.” ");
INSERT INTO twiasante_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben ka kyerɛɛ nʼagya sɛ, “Sɛ mamfa Benyamin ansane amma a, wowɔ ho kwan sɛ wokum me mmammarima baanu no si anan. Fa no hyɛ me nsa, na mɛsane mede no abrɛ wo.” ");
INSERT INTO twiasante_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Nanso, Yakob buaa sɛ, “Me babarima no ne monnkɔ hɔ, ɛfiri sɛ, ne nuabarima awu ama aka ɔno nko. Sɛ saa akwantuo a morebɛtu yi, asiane bi kɔsiane no a, mɛwu.” ");
INSERT INTO twiasante_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Saa ɛberɛ no mu no, na ɛkɔm no ano da so yɛ den wɔ asase no so nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Enti, ɛberɛ a aduane a wɔkɔtɔ firii Misraim baeɛ no reyɛ asa no, wɔn agya Yakob ka kyerɛɛ wɔn sɛ, “Monsane nkɔ, nkɔtɔ aduane kakra mmra bio.” ");
INSERT INTO twiasante_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Nanso, Yuda ka kyerɛɛ nʼagya Yakob sɛ, “Owura no suae kyerɛɛ yɛn dendeenden sɛ, ‘Sɛ moamfa mo nua kumaa no anka mo ho amma a, monnsi mʼanim ha bio.’ ");
INSERT INTO twiasante_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Sɛ wobɛma yɛne yɛn nua kumaa no akɔ deɛ a, ɛnneɛ, yɛbɛsane akɔ akɔtɔ aduane no bi abrɛ wo. ");
INSERT INTO twiasante_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Nanso, sɛ woamma yɛamfa no ankɔ deɛ a, yɛrenkɔ, ɛfiri sɛ, owura no suaee dendeenden sɛ, ‘Sɛ mo nua kumaa no nka mo ho a, monnsi mʼanim bio.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel bisaa ne mma no sɛ, “Adɛn enti na moka kyerɛɛ owura no sɛ mowɔ nua kumaa bi wɔ hɔ, na mode saa ɔhaw yi abɛto me so?” ");
INSERT INTO twiasante_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Anuanom no buaa wɔn agya Israel sɛ, “Owura no nyaa adagyeɛ, too ne bo ara bisaa yɛn ne yɛn abusuafoɔ ho nsɛm nyinaa sɛ, ‘Mo agya da so te ase anaa? Mowɔ onua foforɔ bi ka mo ho?’ Nsɛm a ɔbisaa yɛn no na yɛbuaa no. Na yɛnnim sɛ ɔbɛka se, ‘Momfa mo nua kumaa no mmra.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ɛhɔ na Yuda ka kyerɛɛ nʼagya Israel sɛ, “Fa yɛn nua no hyɛ me nsa, na yɛnsi mu nkɔ ntɛm nkɔtɔ aduane no bi mmra, na ɛkɔm ankum yɛn ne wo ne yɛn mma. ");
INSERT INTO twiasante_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mʼankasa mɛhwɛ abɔfra no so. Sɛ mamfa no amma a, bisa me. Sɛ mamfa no amma, ammɛgyina wʼanim ha, amma woanhunu sɛ wo ba no ni a, saa asodie no nna me so me nkwanna nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Sɛ yɛantwentwɛn yɛn nan ase a, anka saa ɛberɛ yi, yɛakɔ aba bɛyɛ mprenu.” ");
INSERT INTO twiasante_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Afei, wɔn agya Israel ka kyerɛɛ wɔn sɛ, “Sɛ meyɛ ho hwee na ɛrenyɛ yie deɛ a, ɛnneɛ, momfa asase yi so nnepa a ebi ne akyenkyennuro kakra, ɛwoɔ kakra, aduhwam, kurobo, nkateɛ ne sorɔno aba nhyɛ mo nkotokuo mu, nkɔyɛ owura no ayɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Sika a mode rekɔ no nso, monyɛ no mmɔho mmienu, ɛfiri sɛ, ɛsɛ sɛ mosane de sika a kane no mode kɔeɛ na ɔsane de hyɛɛ mo nnesoa mu baeɛ no kɔma no. Ebia, na ɛyɛɛ no anifasoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Momfa mo nua no nso nka mo ho, na monsim ntɛm ntɛm nkɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Otumfoɔ Onyankopɔn nnyina mo akyiri, na owura no nhunu mo mmɔbɔ, na ɔnnyaa mo nua panin Simeon, na ɔmfa Benyamin nso nka mo ho, na mo nyinaa nsane mmra. Sɛ ɛsɛ sɛ medi wɔn wuo ho awerɛhoɔ nso a, menni asɛm biara ka.” ");
INSERT INTO twiasante_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Enti, Israel mma no faa akyɛdeɛ ahodoɔ a wɔde rekɔ akɔyɛ owura no ayɛ no, ne wɔn sika mmɔho mmienu, ne wɔn nua kumaa Benyamin kaa wɔn ho, siim kɔeɛ. Wɔduruu Misraim no, wɔkɔyii wɔn ho adi kyerɛɛ Yosef. ");
INSERT INTO twiasante_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ɛberɛ a Yosef hunuu sɛ Benyamin ka wɔn ho no, ɔka kyerɛɛ ne fie ɔsomfoɔ panin no sɛ, “Fa nkurɔfoɔ no kɔ me fie, na kum aboa bi, na wɔmfa nnoa aduane, na awia me ne wɔn bɛdidi.” ");
INSERT INTO twiasante_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ɔsomfoɔ panin no yɛɛ sɛdeɛ Yosef kaeɛ no pɛpɛɛpɛ. Ɔde nkurɔfoɔ no kɔɔ Yosef fie. ");
INSERT INTO twiasante_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ɔde wɔn duruu Yosef fie no, wɔsuroeɛ. Wɔkaa sɛ, “Gyama ɛsiane dwetɛ a wɔde hyehyɛɛ yɛn nkotokuo mu no enti na ɔde yɛn aba ha. Ɔpɛ sɛ ɔde korɔno to yɛn so, na ɔfa yɛn sɛ ne nkoa, na ɔsane fa yɛn mfunumu no nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Wɔduruu Yosef fie kwan no ano no, wɔkɔɔ Yosef ɔsomfoɔ panin no nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Wɔka kyerɛɛ no sɛ, “Yɛn wura, yɛsrɛ wo, yɛbaa ha ɛberɛ bi a atwam bɛtɔɔ aduane. ");
INSERT INTO twiasante_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ɛberɛ a yɛresane akɔ yɛn kurom a adeɛ saeɛ, na yɛsoɛsoɛɛ no, asoeɛ hɔ na yɛbuebuee yɛn nkotokuo ano, na yɛhunuu sɛ obiara sika a ɛkura no a anka ɔde rekɔtɔ aburoo no hyɛ ne kotokuo no mu pɛpɛɛpɛ. Ɛno enti, yɛasane de aba. ");
INSERT INTO twiasante_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Yɛasane de sika foforɔ aba sɛ yɛde rebɛtɔ aduane. Yɛnnim onipa ko a ɔde saa sika no hyehyɛɛ yɛn nkotokuo no mu.” ");
INSERT INTO twiasante_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ɔsomfoɔ panin no ka kyerɛɛ wɔn sɛ, “Ɛnyɛ asɛm biara. Monnsuro. Onyame a mosom no ne mo agya Onyame a ɔsom no na ɔde saa sika no hyehyɛɛ mo nkotokuo no mu maa mo. Na mo sika no deɛ, yɛgyeeɛ.” Afei, ɔyii Simeon firii afiase hɔ de no brɛɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ɔsomfoɔ panin no de wɔn kɔɔ Yosef fie, maa wɔn nsuo hohoroo wɔn nan ase, ɛnna ɔmaa wɔn mfunumu no nso aduane diiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Wɔboaboaa akyɛdeɛ a wɔde bɛma Yosef no ano de twɛn no, ɛfiri sɛ, na wɔate sɛ wɔbɛdidi wɔ efie hɔ awia no. ");
INSERT INTO twiasante_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ɛberɛ a Yosef baeɛ no, anuanom no buu no nkotodwe, de wɔn akyɛdeɛ no maa no. ");
INSERT INTO twiasante_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yosef bisaa wɔn sɛdeɛ wɔn ho te. Ɔtoaa so sɛ, “Mo agya akɔkoraa a mokaa ne ho asɛm no ho te sɛn? Ɔda so te ase anaa?” ");
INSERT INTO twiasante_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wɔbuaa no sɛ, “Wʼakoa a ɔyɛ yɛn agya no ho yɛ. Ɔda so te ase.” Wɔde obuo ne anidie bɔɔ wɔn mu ase wɔ nʼanim. ");
INSERT INTO twiasante_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ɛberɛ a nʼani tɔɔ ne maame ba Benyamin anim no, ɔbisaa sɛ, “Yei ne mo nua kumaa a mokaa ne ho asɛm kyerɛɛ me no anaa?” Ɔtoaa so sɛ, “Me ba, Onyankopɔn nnom wo!” ");
INSERT INTO twiasante_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yosef hunuu ne nua kumaa Benyamin no, ne werɛ hoeɛ enti, ɔyɛɛ ntɛm firii adi kɔhyɛɛ ne piam, kɔsuiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ɔsu wieeɛ no, ɔhohoroo nʼanim, sane baeɛ de animia kaa sɛ, “Momma yɛnnidi!” ");
INSERT INTO twiasante_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Wɔtoo Yosef ɛpono wɔ baabi, ɛnna wɔtoo anuanom no nso ɛpono wɔ baabi wɔ ɛdan korɔ no ara mu. Misraimfoɔ a wɔyɛ Yosef asomfoɔ no nso didii wɔ baabi foforɔ, ɛfiri sɛ, Misraimfoɔ ne Hebrifoɔ nto nsa nnidi, ɛyɛ wɔn akyiwadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Wɔde Yosef nuanom no tenatenaa ase mpanin mu. Ɛyɛɛ saa maa anuanom no de ahodwirie hwehwɛhwehwɛɛ wɔn ho wɔn ho anim. ");
INSERT INTO twiasante_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Wɔtetee nnuane no firi Yosef ɛpono so kɔmaa wɔn, nanso Benyamin deɛ, na ne deɛ no dɔɔso sene ne nua biara deɛ mprenum. Ɛmaa wɔne Yosef de anigyeɛ ne ahosɛpɛ didi nomeeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Afei, Yosef hyɛɛ ne ɔsomfoɔ panin no sɛ, “Fa aduane dodoɔ biara a mmarima no bɛtumi asoa no hyɛ wɔn nkotokuo no ma ma, na fa obiara sika nso hyɛ ne kotokuo mu ma no. ");
INSERT INTO twiasante_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Afei, fa me dwetɛ kuruwa no ka akumaa no aduane no sika ho, na fa hyɛ ne kotokuo no mu.” Na ɔsomafoɔ panin no yɛɛ sɛdeɛ Yosef kaeɛ no pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Adeɛ kyee anɔpa no, ɔgyaa anuanom no ne wɔn mfunumu no kwan. ");
INSERT INTO twiasante_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Wɔannuru akyiri baabiara, na Yosef ka kyerɛɛ ne ɔsomfoɔ panin no sɛ, “Ti nkurɔfoɔ no ntɛm so, na sɛ woto wɔn a, bisa wɔn sɛ, ‘Adɛn enti na mode bɔne tua papa so ka? Adɛn enti na moawia me dwetɛ kuruwa? ");
INSERT INTO twiasante_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ɛnyɛ saa kuruwa yi a me wura nom ano na ɔhwɛ mu ka nhunumusɛm no nie? Yei yɛ bɔne kɛseɛ a moayɛ.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ɔkɔtoo wɔn no, ɔtii saa asɛm korɔ yi ara mu kyerɛɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nanso, anuanom no buaa no sɛ, “Adɛn enti na yɛn wura keka saa nsɛm yi? Ɛmpare wo nkoa sɛ wɔbɛyɛ adeɛ a ɛte saa! ");
INSERT INTO twiasante_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Sika a yɛhunuu wɔ yɛn nkotokuo mu no, yɛansane amfa amfiri Kanaan ammrɛ mo anaa? Adɛn enti na ɛsɛ sɛ yɛwia dwetɛ anaa sikakɔkɔɔ firi wo wura fie? ");
INSERT INTO twiasante_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Sɛ wohunu saa kuruwa no wɔ wo nkoa no biara nkyɛn a, okum na ɛsɛ sɛ wokum saa onipa no. Na sɛ ɛba saa nso a, yɛn nyinaa bɛyɛ wo wura nkoa afebɔɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ɔsomfoɔ no buaa sɛ, “Ɛyɛ, na deɛ ɔwiaeɛ no nko na ɔbɛyɛ mʼakoa. Na mo a moaka no bɛfa mo ho adi.” ");
INSERT INTO twiasante_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Anuanom no nyinaa yiyii wɔn nnesoa no firii mfunumu no so, guu fam, sane sanee wɔn nkotokuo no ano. ");
INSERT INTO twiasante_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Afei, ɔsomfoɔ panin no firii aseɛ, hwehwɛɛ wɔn nkotokuo no mu firi ɔpanin no so kɔsii akumaa no so. Wɔhunuu kuruwa no wɔ Benyamin kotokuo no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ɛbaa saa no, anuanom no sunsuanee wɔn ntadeɛ mu. Afei, wɔn nyinaa sane hyehyɛɛ wɔn nnesoa no wɔ wɔn mfunumu no so, sanee wɔn akyiri, kɔɔ kuro no mu bio. ");
INSERT INTO twiasante_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ɛberɛ a Yuda ne ne nuanom no kɔduruu kuro no mu hɔ no, na Yosef da so wɔ ne fie hɔ. Enti, wɔn nyinaa totoo wɔn ho guu fam wɔ nʼanim. ");
INSERT INTO twiasante_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosef bisaa wɔn sɛ, “Ɛdeɛn adeɛ na moayɛ yi? Monnim sɛ onipa a ɔte sɛ me nam nhunumusɛm so bɛtumi ahunu biribiara mu?” ");
INSERT INTO twiasante_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda buaa sɛ, “Anoyie bɛn na yɛbɛtumi ayi wɔ me wura anim? Asɛm bɛn na yɛwɔ ka? Yɛbɛyɛ dɛn na yɛatumi ama woahunu sɛ yɛnni saa asɛm yi ho fɔ? Onyame ada yɛn wʼasomfoɔ afɔdie yi adi. Yɛne deɛ wɔhunuu kuruwa no wɔ no nkyɛn no nyinaa yɛ yɛn wura nkoa”. ");
INSERT INTO twiasante_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Nanso, Yosef kaa sɛ, “Ɛmpare me sɛ mɛyɛ adeɛ a ɛte saa. Onipa a wɔhunuu kuruwa no wɔ ne nkyɛn no nko ara na ɔbɛyɛ mʼakoa. Mo a moaka no deɛ, monsane nkɔ mo agya nkyɛn asomdwoeɛ mu.” ");
INSERT INTO twiasante_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda sɔre kɔɔ Yosef anim, ka kyerɛɛ no sɛ, “Ma me a meyɛ wʼakoa no ɛkwan na me ne wo, me wura, nkasa. Ɛwom sɛ, wo ne Farao yɛ pɛ deɛ, nanso mesrɛ wo, nya aboterɛ ma wo ɔsomfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Me wura bisaa nʼasomfoɔ no sɛ, ‘Mowɔ agya anaa onuabarima bi?’ ");
INSERT INTO twiasante_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Na yɛbuaa sɛ, ‘Yɛwɔ agya a wabɔ akɔkoraa ne yɛn kaakyire a ɔwoo no ne nkɔkoraaberɛ mu. Ne nuabarima a ɔka ne ho no awu. Na ɔno nko ara ne ne maame ba a waka. Nʼagya pɛ nʼasɛm yie.’ ");
INSERT INTO twiasante_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Na ɔka kyerɛɛ wʼasomfoɔ sɛ, ‘Momfa no mmra, na menhwɛ no.’ ");
INSERT INTO twiasante_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Yɛka kyerɛɛ me wura sɛ, ‘Abarimaa no rentumi nte ne ho mfiri nʼagya ho. Na sɛ ɛba sɛ ɔte ne ho firi nʼagya ho a, nʼagya no bɛwu.’ ");
INSERT INTO twiasante_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ɛnna woka kyerɛɛ wʼasomfoɔ sɛ. ‘Sɛ moamfa mo nua kumaa no anka mo ho amma a, monnsi mʼanim bio.’ ");
INSERT INTO twiasante_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Yɛsane kɔɔ wʼakoa, yɛn agya nkyɛn no, yɛkaa wo a woyɛ yɛn wura no nsɛm a woka kyerɛɛ yɛn no nyinaa kyerɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Ɛnna yɛn agya kaa sɛ, ‘Monsane nkɔ bio nkɔtɔ aduane kakra mmra.’ ");
INSERT INTO twiasante_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nanso, yɛka kyerɛɛ yɛn agya sɛ, ‘Yɛrentumi nkɔ, gye sɛ yɛn nua kumaa no ka yɛn ho. Sɛ yɛamfa yɛn nua kumaa no anka yɛn ho ankɔ a, yɛrentumi nkɔ owura no anim.’ ");
INSERT INTO twiasante_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Afei, wo ɔsomfoɔ, yɛn agya ka kyerɛɛ yɛn sɛ, ‘Monim sɛ me ne me yere woo mmammarima baanu. ");
INSERT INTO twiasante_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Wɔn mu baako firii me nkyɛn kɔeɛ a, manhunu no bio, ma mekaa sɛ, “Aboa bi atete no pasaa.” Ɛfiri saa ɛberɛ no, menhunuu no bio. ");
INSERT INTO twiasante_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Sɛ mofa yei firi me nkyɛn, na asiane bi kɔsiane no wɔ ɛkwan so a, me nso, mede awerɛhoɔ bɛwu bi.’ ");
INSERT INTO twiasante_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Enti, saa ɛberɛ yi, sɛ yɛkɔpue firi wʼakoa, yɛn agya, anim na abɔfra yi nka yɛn ho a, ɛnneɛ, sɛdeɛ nʼakoma da abɔfra no ho fa no, ");
INSERT INTO twiasante_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","sɛ ɔhunu sɛ abɔfra no nka yɛn ho a, ɔbɛwu. Wo nkoa bɛma wɔn agya adi awerɛhoɔ, de ne tiri so dwono akɔ asaman. ");
INSERT INTO twiasante_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Wʼakoa a ɔde ne ho dii abɔfra no agyinamu sɛ ɔde no bɛba kaa sɛ, ‘Sɛ mamfa no ansane ammrɛ wo a, ɛho asodie no mmɛda me so, me nkwanna nyinaa.’ ");
INSERT INTO twiasante_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Afei, mesrɛ wo, ma wʼakoa nsi abɔfra no ananmu wɔ ha, na ma abɔfra no ne ne nuammarima no nsane nkɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Na sɛ abɔfra no anka me ho ankɔ a, mɛyɛ dɛn makɔpue mʼagya anim. Dabi! Merentumi nnyina ahohiahia a ɛbɛto mʼagya wɔ saa asɛm yi ho no ano.” ");
INSERT INTO twiasante_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Afei, na Yosef yɛ ne ho biribiara a, ɛnyɛ yie wɔ nʼasomfoɔ no nyinaa anim. Enti, ɔteaam kyerɛɛ nʼasomfoɔ no sɛ, “Obiara mfiri ha nkɔ.” Enti, ɛberɛ a ɔyii ne ho adi kyerɛɛ ne nuanom no, na asomfoɔ no mu biara nni hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ɔsuu dendeenden maa Misraimfoɔ no teeɛ. Ɛyɛɛ saa ma ɛduruu Farao fiefoɔ asom. ");
INSERT INTO twiasante_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Afei, Yosef ka kyerɛɛ ne nuammarimanom no sɛ, “Mene Yosef! Mʼagya te ase anaa?” Asɛm no yɛɛ wɔn nwanwa yie ma ɛtɔree wɔn mumu wɔ nʼanim. ");
INSERT INTO twiasante_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yosef ka kyerɛɛ ne nuammarimanom no sɛ, “Montwe mmɛn me.” Wɔtwe bɛn no no, ɔka kyerɛɛ wɔn sɛ, “Mene mo nuabarima Yosef. Me na motɔnee me maa wɔde me kɔɔ Misraim no. ");
INSERT INTO twiasante_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Mommma biribiara nha mo. Na monnkasakasa so sɛ motɔnee me maa wɔde mebaa ha. Onyankopɔn na ɔyɛeɛ. Ɔno na ɔsomaa me, dii mo anim baa ha sɛ memmɛgye mo nkwa. ");
INSERT INTO twiasante_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Mfeɛ mmienu ni a ɛkɔm baa asase yi so. Mfeɛ enum a ɛreba yi nso, obiara rennua, na obiara nso rentwa. ");
INSERT INTO twiasante_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Onyankopɔn asoma me ha sɛ, memma mo ne mo fiefoɔ ntena nkwa mu, na moayɛ ɔman kɛseɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Enti, ɛnyɛ mo na mode mebaa ha, na ɛyɛ Onyankopɔn ankasa! Wayɛ me Farao fotufoɔ ne ne fie sohwɛfoɔ, ɛnna ɔde Misraiman nyinaa nso ahyɛ me nsa. ");
INSERT INTO twiasante_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Afei, monka mo ho nkɔ mʼagya nkyɛn nkɔka nkyerɛ no sɛ, ‘Sɛdeɛ wo babarima Yosef seɛ ni, Onyankopɔn ayɛ me Misraiman nyinaa sohwɛfoɔ. Enti, ntwentwɛn wo nan ase koraa, na bra Misraim! ");
INSERT INTO twiasante_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Wobɛba abɛtena Gosen asase so, na woabɛn me. Fa wo mma, wo nananom, wo nnwan ne wʼanantwie ne biribiara a wowɔ bra. ");
INSERT INTO twiasante_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Sɛ woba hɔ a, mɛhwɛ wo, ɛfiri sɛ saa ɛkɔm kɛseɛ yi aka mfeɛ enum. Sɛ anyɛ saa a, wo ne wo fiefoɔ ne wɔn a wɔka wo ho nyinaa bɛdi hia buruburoo.’ ");
INSERT INTO twiasante_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Mo ne me nua Benyamin nyinaa di adanseɛ sɛ, ampa ara, ɛyɛ me Yosef na me ne morekasa yi. ");
INSERT INTO twiasante_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Monka animuonyam a Onyame adom enti, wɔahyɛ me wɔ Misraim asase so ne biribiara a mo ankasa mode mo ani abɛhunu no nyinaa ho asɛm nkyerɛ mʼagya. Monkɔfa mʼagya nsiane mmrɛ me ntɛm so.” ");
INSERT INTO twiasante_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ɔyɛɛ Benyamin atuu, suiɛ, a anigyeɛ ne awerɛhoɔ adi afra. Benyamin nso firii aseɛ suiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ɔfefee ne nuanom no nyinaa ano suiɛ, na ɛno akyiri no, wɔtumi ne no kasaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ɛberɛ a wɔtee wɔ Farao fie sɛ Yosef nuanom no aba no, Farao ne ne mpanimfoɔ a wɔka ne ho no nyinaa ani gyeeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Afei, Farao ka kyerɛɛ Yosef sɛ, “Ka kyerɛ wo nuanom no se, wɔmfa nneɛma nsoasoa wɔn mmoa no, na wɔnkɔ Kanaan asase so, ");
INSERT INTO twiasante_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","na wɔnkɔfa wɔn agya ne wɔn abusuafoɔ nyinaa mmra Misraim asase so ha mmɛtena ha. Ka kyerɛ wɔn sɛ, ‘Farao bɛma mo Misraim asase no fa a ɛyɛ pa ara atena so. Wɔbɛdi asase no so nnepa!’ ");
INSERT INTO twiasante_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Ka kyerɛ wɔn sɛ, ‘Momfa nteaseɛnam mfiri Misraim ha nkɔfa mo yerenom ne mo mma. Momfa mo agya nso nka ho mmra. ");
INSERT INTO twiasante_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Monnha mo ho wɔ mo agyapadeɛ ho, ɛfiri sɛ, mede nnepa a ɛwɔ Misraim asase so nyinaa no bi bɛma mo.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Enti, Yosef maa wɔn nteaseɛnam ne nnuane a wɔbɛdi wɔ ɛkwan so, sɛdeɛ Farao hyɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ɔmaa ne nuanom no mu biara atadeɛ foforɔ, nanso Benyamin deɛ, ɔmaa no ntadeɛ ahodoɔ enum ne dwetɛ kilogram mmiɛnsa ne fa. ");
INSERT INTO twiasante_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Saa nneɛma a ɛdidi so yi nso na Yosef de kɔmaa nʼagya Israel: mfunumunini edu a wɔahyehyɛ Misraim nneɛma pa wɔ wɔn so, mfunumubereɛ edu a wɔsoso aburoo, burodo ne nnuane ahodoɔ ne nʼakwansoduane. ");
INSERT INTO twiasante_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ɔgyaa ne nuanom no kwan, na akwannya no mu no, ɔka kyerɛɛ wɔn sɛ, “Monnkɔkasakasa wɔ ɛkwan so.” ");
INSERT INTO twiasante_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Enti, wɔfirii Misraiman mu kɔɔ wɔn agya Israel nkyɛn wɔ Kanaan asase so. ");
INSERT INTO twiasante_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wɔduruiɛ no, wɔde anigyeɛ bɔɔ wɔn agya amaneɛ sɛ, “Yosef te ase! Nokwasɛm nie, ɔno na ɔdi Misraiman nyinaa so!” Israel tee saa asɛm yi no, ne ho dwirii no. Wannye anni. ");
INSERT INTO twiasante_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Na ɛberɛ a wɔkaa nsɛm a Yosef ka kyerɛɛ wɔn sɛ wɔmmɛka no wieeɛ no, na ɔhunuu nteaseɛnam a Yosef de somaa sɛ wɔmfa mmɛfa no no, wɔn agya Yakob ho sanee no. ");
INSERT INTO twiasante_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Afei, Israel kaa sɛ, “Magye nsɛm no nyinaa adi. Ɛyɛ nokorɛ turodoo sɛ, Yosef te ase. Mɛkɔ makɔhunu no ansa na mawu.” ");
INSERT INTO twiasante_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Enti, Israel de nʼahodeɛ nyinaa siim kɔduruu Beer-Seba. Ɔbɔɔ Onyankopɔn a na nʼagya Isak somm no no afɔdeɛ wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Anadwo anisoadehunu mu no, Onyankopɔn frɛɛ Yakob sɛ, “Yakob! Yakob!” Yakob gyee so sɛ, “Me nie.” ");
INSERT INTO twiasante_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Onyankopɔn ka kyerɛɛ no sɛ, “Mene Onyankopɔn. Onyankopɔn a wʼagya somm no. Nsuro sɛ wobɛkɔ Misraim, ɛfiri sɛ, mɛma wʼase adɔre ayɛ ɔman kɛseɛ wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mʼankasa me ne wo bɛkɔ Misraim, na masane ne wo aba ha bio. Ɛduru ɛberɛ a worebɛwu a, wobɛwu Yosef anim.” ");
INSERT INTO twiasante_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Afei, Yakob siim firii Beer-Seba. Israel mma no de wɔn agya Yakob, wɔn yerenom ne wɔn mma tenatenaa nteaseɛnam a Farao soma maa wɔde bɛfaa wɔn no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Wɔfaa wɔn mmoa ne wɔn agyapadeɛ a wɔanya wɔ Kanaan asase so nyinaa kaa wɔn ho kɔɔ Misraim. Yakob ne nʼasefoɔ nyinaa siim kɔɔ Misraim. ");
INSERT INTO twiasante_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Israel de ne mmammarima, ne nananom, ne mmammaa ne wɔn mma a wɔn nyinaa yɛ nʼasefoɔ kaa ne ho kɔɔ Misraim. ");
INSERT INTO twiasante_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Edin a ɛdidi so yi yɛ Israelfoɔ, Yakob asefoɔ a ɔde wɔn kɔɔ Misraim. Ruben yɛ Yakob abakan. ");
INSERT INTO twiasante_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben nso mmammarima edin na ɛdidi so yi: Hanok, Palu, Hesron ne Karmi. ");
INSERT INTO twiasante_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon nso mmammarima yɛ: Yemuel, Yamin, Ohad, Yakin, Sohar ne Saulo a ne na yɛ Kanaanni. ");
INSERT INTO twiasante_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi mmammarima din na ɛdidi so yi: Gerson, Kohat ne Merari. ");
INSERT INTO twiasante_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda nso mmammarima yɛ: Er, Onan, Sela, Peres ne Serah. Nanso Er ne Onan deɛ, wɔwuwuiɛ wɔ Kanaan asase so, ansa na Israel reba Misraim asase so. Peres mmammarima yɛ: Hesron ne Hamul. ");
INSERT INTO twiasante_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakar mmammarima nso yɛ: Tola, Puwa, Hiob ne Simron. ");
INSERT INTO twiasante_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon mmammarima nso yɛ: Sered, Elon ne Yakleel. ");
INSERT INTO twiasante_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Wɔn a wɔabobɔ wɔn din yi yɛ Lea mma a ɔne Yakob woeɛ wɔ Paddan-Aram a ne babaa Dina nso ka ho. Saa mmammarima ne ne babaa yi nyinaa dodoɔ si nnipa aduasa mmiɛnsa. ");
INSERT INTO twiasante_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad nso mma din na ɛdidi so yi: Sifion, Hagi, Suni, Esbon, Eri, Arodi ne Areli. ");
INSERT INTO twiasante_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser nso mma din na ɛdidi so yi: Yimna, Isua, Isui ne Beria ne wɔn nuabaa Sera. Beria nso mma yɛ: Heber ne Malkiel. ");
INSERT INTO twiasante_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Yeinom nso ne Silpa, afenaa a Laban de no maa ne babaa Lea a ɔno nso de no maa ne kunu Yakob wareeɛ no mma. Wɔn nyinaa dodoɔ ano si nnipa dunsia. ");
INSERT INTO twiasante_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakob yere Rahel mma yɛ: Yosef ne Benyamin. ");
INSERT INTO twiasante_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosef ne ne yere Asnat, a ɔyɛ Potifera a ɔyɛ On bosomfoɔ babaa woo Manase ne Efraim wɔ Misraim. ");
INSERT INTO twiasante_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin nso mmammarima din na ɛdidi so yi: Bela, Beker, Asbel, Gera, Naaman, Ehi, Ros, Mupim, Hupim ne Ard. ");
INSERT INTO twiasante_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Saa nnipa a wɔabobɔ wɔn din yi yɛ Rahel mmammarima a ɔne Yakob woeɛ. Wɔn nyinaa dodoɔ ano si nnipa dunan. ");
INSERT INTO twiasante_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan babarima yɛ Husim. ");
INSERT INTO twiasante_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali nso mmammarima din na ɛdidi so yi: Yahseel, Guni, Yeser ne Silem. ");
INSERT INTO twiasante_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bilha a ɔyɛ Laban afenaa a ɔde no maa ne babaa Rahel mmammarima a ɔne Yakob woeɛ no na wɔabobɔ wɔn din yi. Na wɔn dodoɔ ano si nnipa baason. ");
INSERT INTO twiasante_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Nnipa a Yakob de wɔn kɔɔ Misraim nyinaa, a wɔyɛ nʼasefoɔ ankasa, a ne mmammarima yerenom nka ho dodoɔ ano si aduosia nsia. ");
INSERT INTO twiasante_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Sɛ wɔde Yosef mmammarima baanu a ɔwoo wɔn wɔ Misraim no ka ho a, na Yakob asefoɔ a ɔde wɔn kɔɔ Misraim no nyinaa dodoɔ ano si nnipa aduɔson. ");
INSERT INTO twiasante_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Israel somaa Yuda, ma ɔdii ɛkan kɔɔ Yosef hɔ kɔbisaa no Gosen ɛkwan. Akyire no, wɔkɔduruu Gosen. ");
INSERT INTO twiasante_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosef siesiee ne nteaseɛnam ma wɔkɔɔ Gosen kɔhyiaa nʼagya Israel. Yosef duruu nʼagya Yakob anim pɛ, ɔbam no, suiɛ ara kwansin. ");
INSERT INTO twiasante_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel ka kyerɛɛ Yosef sɛ, “Ohunu a mahunu wo sɛ wote ase yi enti, sɛ owuo bɛfa me ɛnnɛ koraa a, mepɛ.” ");
INSERT INTO twiasante_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yosef ka kyerɛɛ ne nuanom no ne nʼagya fiefoɔ no sɛ, “Mɛkɔ makɔka makyerɛ Farao sɛ, ‘Me nuammarimanom ne mʼagya fiefoɔ a na anka wɔte Kanaan asase so nyinaa aba ha abɛka me ho. ");
INSERT INTO twiasante_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mmarima no yɛ nnwanhwɛfoɔ. Wɔhwɛ mmoa so. Na wɔde wɔn nnwan ne wɔn anantwie ne biribiara a wɔwɔ aba.’ ");
INSERT INTO twiasante_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Sɛ Farao frɛ mo, na ɔbisa mo sɛ, ‘Adwuma bɛn na moyɛ a,’ ");
INSERT INTO twiasante_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","momma no mmuaeɛ sɛ, ‘Wo nkoa ayɛn mmoa firi wɔn mmɔfraase, te sɛ deɛ yɛn agyanom yɛeɛ no ara pɛpɛɛpɛ.’ Sɛ moka saa kyerɛ no a, ɔbɛma mode Gosen ayɛ mo atenaeɛ, ɛfiri sɛ, Misraimfoɔ kyiri nnwanhwɛfoɔ kɔkɔɔkɔ.” ");
INSERT INTO twiasante_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yakob mma no bɛduruu Misraim asase so no, Yosef kɔka kyerɛɛ Farao sɛ, “Mʼagya ne me nuanom no de wɔn nnwan ne wɔn anantwie ne wɔn agyapadeɛ nyinaa firi Kanaan asase so aba, na wɔwɔ Gosen asase so”. ");
INSERT INTO twiasante_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yosef yii ne nuammarima no mu baanum de wɔn kɔkyeaa Farao. ");
INSERT INTO twiasante_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao bisaa anuanom no sɛ, “Adwuma bɛn na moyɛ?” Wɔbuaa no sɛ, “Wo nkoa yɛ nnwanhwɛfoɔ, sɛdeɛ na yɛn agyanom nso yɛ nnwanhwɛfoɔ no.” ");
INSERT INTO twiasante_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Anuanom no toaa so sɛ, “Yɛaba ha sɛ amamfrafoɔ a yɛrebɛtena ha kakra, ɛfiri sɛ, ɛkɔm no ano yɛ den yie wɔ Kanaan asase so hɔ, na wo nkoa nnwan nnya aduane nni. Enti, yɛresrɛ wo kwan na yɛatena Gosen asase so ha.” ");
INSERT INTO twiasante_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Farao ka kyerɛɛ Yosef sɛ, “Wʼagya ne wo nuanom aba wo nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Misraim asase nyinaa hyɛ wo nsa. Ma wʼagya ne wo nuammarima baabi pa na wɔntena. Ma wɔntena Gosen asase so. Sɛ wonim wɔn mu bi a wɔwɔ mmoayɛn ho nimdeɛ a, ma wɔnhwɛ me nnwan so mma me.” ");
INSERT INTO twiasante_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Afei, Yosef kɔfaa nʼagya Yakob de no bɛkyiaa Farao maa Yakob hyiraa no. ");
INSERT INTO twiasante_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao bisaa Yakob sɛ, “Woadi mfeɛ ahe?” ");
INSERT INTO twiasante_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob buaa Farao sɛ, “Madi mfeɛ ɔha ne aduasa a ɔhaw ne abɛbrɛsɛ wɔ mu. Mennuru mʼagyanom nkwanna a wɔde tenaa asase so no ho hwee.” ");
INSERT INTO twiasante_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Na Yakob hyiraa Farao, na ɔfirii nʼanim kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Enti, Yosef bɔɔ nʼagya ne ne nuanom no atenaseɛ wɔ Misraim asase so. Ɔmaa wɔn agyapadeɛ wɔ asase no fa baabi a ɛyɛ pa ara wɔ Rameses mansini mu, sɛdeɛ Farao hyɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yosef maa nʼagya ne ne nuanom no aduane sɛdeɛ wɔn mma dodoɔ te. ");
INSERT INTO twiasante_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Na aduane nni hɔ baabiara, ɛfiri sɛ, na ɛkɔm a aba no ano ayɛ den yie. Saa ɛkɔm yi kaa Misraim ne Kanaan asase nyinaa maa emu nnipa ne mfudeɛ twintwameeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yosef prapraa Misraim ne Kanaan asase so sika nyinaa a ɔnya firii aduanetɔn no mu no baa Farao ahemfie. ");
INSERT INTO twiasante_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ɛberɛ a nnipa a wɔwɔ Misraim ne Kanaan asase so ho sika nyinaa saeɛ no, Misraim nnipa nyinaa baa Yosef nkyɛn bɛka kyerɛɛ no sɛ, “Yɛn ho sika nyinaa asa, enti ma yɛn aduane nni! Adɛn enti na ɛsɛ sɛ yɛwuwu?” ");
INSERT INTO twiasante_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosef buaa wɔn sɛ, “Sɛ mo sika asa deɛ a, momfa mo nnwan ne mo anantwie mmra mmɛgye aduane.” ");
INSERT INTO twiasante_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Enti, wɔde wɔn mmoa no brɛɛ Yosef. Mmoa a wɔde wɔn bɛsesaa aduane no yɛ apɔnkɔ, nnwan, mpɔnkye, anantwie ne mfunumu. Saa afe no mu no, wɔde wɔn mmoa nyinaa bɛsesaa aduane. ");
INSERT INTO twiasante_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Afe akyiri no, Misraimfoɔ no nyinaa baa Yosef nkyɛn bɛkaa sɛ, “Yɛrentumi mfa biribiara nhinta yɛn wura. Yɛn ho sika nyinaa asa, na yɛn anantwie nso yɛ wo dea. Biribiara bio nni hɔ a yɛbɛtumi de abrɛ wo, yɛn wura, sɛ yɛn nnipadua ne yɛn nsase nko. ");
INSERT INTO twiasante_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Adɛn enti na ɛsɛ sɛ yɛhwere yɛn nkwa ne yɛn nsase wɔ wʼanim! Afei, ma yɛmfa yɛn nnipadua ne yɛn nsase nyinaa mmɛsesa aduane. Yɛde yɛn ho ne yɛn nsase nyinaa bɛkɔ nkoasom mu. Ma yɛn aburoo, na ɛkɔm ankum yɛn, amma asase no nso anna mpan.” ");
INSERT INTO twiasante_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Enti, Yosef tɔɔ Misraim nsase nyinaa maa Farao. Esiane ɛkɔm no ano den enti, Misraimfoɔ no tɔn wɔn nsase no nyinaa. Ɛyɛɛ saa maa nsase no nyinaa bɛdii Farao nsam. ");
INSERT INTO twiasante_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ɛfiri Misraim tire kɔsi tire, Yosef de mu nnipa nyinaa bɛyɛɛ ne nkoa. ");
INSERT INTO twiasante_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Asɔfoɔ nko ara nsase na wantɔ, ɛfiri sɛ, asɔfoɔ no deɛ, na Farao atwa anoduane bi de ama wɔn. Ne saa enti na wɔn deɛ, wɔantɔn wɔn nsase no. ");
INSERT INTO twiasante_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yosef ka kyerɛɛ nnipa no sɛ, “Afei a matɔ mo ne nsase de ama Farao yi, mo nso, monnye aburoo nkɔdua. ");
INSERT INTO twiasante_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Na sɛ aburoo no yɛ yie, na motwa a, momfa nkyɛmu enum mu baako mmrɛ Farao. Na nkyɛmu enum mu ɛnan a ɛbɛka no, mo ne mo fiefoɔ ne mo mma nni bi, na monnya bi nso a mobɛdua.” ");
INSERT INTO twiasante_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Wɔkaa sɛ, “Anokwa, woagye yɛn nkwa. Ka kyerɛ yɛn wura Farao sɛ, ɔnnye yɛn ntom, na yɛnyɛ nkoa.” ");
INSERT INTO twiasante_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ɛnam saa asɛm yi so maa mmara a Yosef hyɛeɛ sɛ, wɔmfa asase no so nnɔbaeɛ nyinaa mu nkyɛmu enum mu baako mma Farao no da so wɔ hɔ bɛsi ɛnnɛ. Asɔfoɔ no nsase nko ara na ankɔdi Farao nsam. ");
INSERT INTO twiasante_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israelfoɔ no bɔɔ atenaseɛ wɔ Gosen mansini a ɛwɔ Misraim asase so no so. Wɔnyaa agyapadeɛ wɔ hɔ, na wɔn ase nso dɔree yie. ");
INSERT INTO twiasante_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakob tenaa Misraim mfeɛ dunson. Ɔdii mfirinhyia ɔha ne aduanan nson ansa na ɔrewu. ");
INSERT INTO twiasante_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ɛduruu sɛ Yakob rebɛwuo no, ɔfrɛɛ ne ba Yosef, ka kyerɛɛ no sɛ, “Me ba, sɛ wodɔ me deɛ a, ka ntam di nse sɛ, wobɛyɛ me adɔeɛ, adi me nokorɛ. Sɛ mewu a, nsie me wɔ Misraim ha. ");
INSERT INTO twiasante_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Sɛ mewu a, momfa me mfiri Misraim ha, nkɔsie me wɔ baabi a wɔsiee me mpanimfoɔ no.” Yosef hyɛɛ bɔ sɛ, “Mɛdi asɛm a woaka no so.” ");
INSERT INTO twiasante_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakob kaa bio sɛ, “Ka ntam kyerɛ me.” Yosef kaa ntam no, na Israel nso butuu ne poma so sɔree Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Yei akyiri no, wɔka kyerɛɛ Yosef sɛ, “Wʼagya yare.” Enti, Yosef faa ne mmammarima baanu, Efraim ne Manase kaa ne ho kɔsraa no. ");
INSERT INTO twiasante_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ɛberɛ a wɔbɔɔ Yakob amaneɛ sɛ, “Wo ba Yosef aba wo nkyɛn rebɛsra wo” no, Yakob miaa nʼani sɔre tenaa ne mpa so maa no akwaaba. ");
INSERT INTO twiasante_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ɛnna Yakob ka kyerɛɛ Yosef sɛ, “Otumfoɔ Onyankopɔn yii ne ho adi kyerɛɛ me wɔ Lus a ɛwɔ Kanaan asase so. Ɛhɔ na ɔhyiraa me, ");
INSERT INTO twiasante_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ka kyerɛɛ me sɛ, ‘Mɛma woawo, ama wʼase afɛe. Mɛma wʼasefoɔ ayɛ ɔman kɛseɛ. Mede saa asase yi bɛma wʼasefoɔ sɛ wɔn agyapadeɛ afebɔɔ.’ ");
INSERT INTO twiasante_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Ɛno enti, mede wo mma baanu a wɔwoo wɔn maa wo ansa na mereba wo nkyɛn wɔ Misraim asase so ha no bɛka me mma no ho. Efraim ne Manase bɛka me mma ho, sɛdeɛ Ruben ne Simeon yɛ me mma no. ");
INSERT INTO twiasante_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mma foforɔ biara a wobɛwo wɔn wɔ Efraim ne Manase akyiri no na wɔbɛyɛ wo dea. Wɔde wɔn bɛka wɔn nuanom no ho wɔ asase a wɔde bɛma wɔn sɛ wɔn agyapadeɛ no so. ");
INSERT INTO twiasante_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ɛberɛ a mefiri Paddan-Aram reba no, ababaawa Rahel wuu wɔ ɛkwan mu, ma ɛyɛɛ me ya. Na aka akwansini kakra na yɛaduru Efrat. Ɛno enti, mesiee no wɔ Eufrate, a wɔfrɛ no Betlehem no kwankyɛn baabi.” ");
INSERT INTO twiasante_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ɛberɛ a Israel hunuu Yosef mmammarima no, ɔbisaa sɛ, “Na yeinom yɛ ɛhefoɔ?” ");
INSERT INTO twiasante_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosef buaa nʼagya sɛ, “Wɔyɛ mmammarima a Onyankopɔn de wɔn adom me wɔ ha.” Na Israel kaa sɛ, “Fa wɔn bra mʼanim ha na menhyira wɔn.” ");
INSERT INTO twiasante_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Saa ɛberɛ no, ɛsiane onyini enti, na Israel ani so ayɛ wisiwisi a, ɔnhunu adeɛ papa. Ne saa enti, Yosef de ne mma no kɔɔ ne nkyɛn pɛɛ, ma ɔyɛɛ wɔn atuu, fefee wɔn ano. ");
INSERT INTO twiasante_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel ka kyerɛɛ Yosef sɛ, “Manna mannwene sɛ mɛhunu wʼanim bio da, nanso hwɛ deɛ Onyame ayɛ. Wama me ho kwan ama mahunu wo mma nso.” ");
INSERT INTO twiasante_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yosef pagyaa wɔn firii Israel kotodwe anim, ɛnna ɔno ara nso buu nkotodwe de nʼanim butuu fam. ");
INSERT INTO twiasante_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ɔpagyaa ne mu no, ɔde ne nsa nifa sɔɔ Efraim mu, de no gyinaa Yakob benkum so, ɛnna ɔde ne nsa benkum sɔɔ Manase mu, de no gyinaa Yakob nifa so bɛn no pɛɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israel tenee ne nsa nifa de too Efraim a ɔyɛ akumaa no apampam, ɛnna ɔde ne nsa benkum no too Manase nso apampam. Ɛwom sɛ na Manase yɛ abakan deɛ, nanso ɔde ne nsa benkum na ɛtoo nʼapampam. ");
INSERT INTO twiasante_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ɔhyiraa Yosef sɛ, “Onyankopɔn a mʼagyanom Abraham ne Isak nantee nʼanim, ne me Onyankopɔn a ɔhwɛɛ me sɛ odwanhwɛfoɔ de bɛsi ɛnnɛ no, ");
INSERT INTO twiasante_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ɔsoro ɔbɔfoɔ a ɔgyee me firii ɔhaw nyinaa mu no, ɔnhyira saa mmarimaa yi. Wɔmfa me din ne mʼagyanom, Abraham ne Isak edin ntoto wɔn, na wɔn ase mfɛe wɔ asase so.” ");
INSERT INTO twiasante_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ɛberɛ a Yosef hunuu sɛ nʼagya de ne nsa nifa ato Efraim apampam no, anyɛ no dɛ. Enti, ɔyii nʼagya nsa nifa no firii Efraim apampam, kɔtoo Manase apampam. ");
INSERT INTO twiasante_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yosef ka kyerɛɛ nʼagya sɛ, “Dabi, mʼagya, yei ne mʼabakan, enti fa wo nsa nifa to nʼapampam.” ");
INSERT INTO twiasante_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Nanso, nʼagya ampene so kaa sɛ, “Me ba, menim saa. Ɔno nso bɛyɛ ɔman, na wayɛ kɛse. Nanso, ne nua kumaa no bɛyɛ kɛse asene no, na nʼasefoɔ bɛyɛ amanaman bebree.” ");
INSERT INTO twiasante_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Enti ɛda no, Yakob hyiraa mmarimaa no sɛ, “Israelfoɔ nyinaa nam mo din so bɛhyirahyira wɔn ho wɔn ho. Wɔbɛka sɛ, ‘Onyankopɔn bɛhyirahyira mo, ama moakɔ so frɔmfrɔm te sɛ Efraim ne Manase.’ ” Saa ɛkwan yi so na Yakob fa maa Efraim bɛdii Manase anim. ");
INSERT INTO twiasante_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Na Israel ka kyerɛɛ Yosef sɛ, “Merebɛwu, nanso Onyankopɔn bɛhwɛ mo so, na wasane de mo akɔ Kanaan, mo agyanom asase so bio. ");
INSERT INTO twiasante_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Wo a seesei woabɛyɛ wo nuanom nyinaa so panin no, mede asase a menam me sekan ne mʼagyan so gye firii Amorifoɔ nkyɛn no rema wo.” ");
INSERT INTO twiasante_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakob frɛɛ ne mmammarima nyinaa ka kyerɛɛ wɔn sɛ, “Mommɛtwa me ho nhyia, na menka mo deɛ ɛbɛba mo so. ");
INSERT INTO twiasante_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Yakob mmammarima, mommoaboa mo ho ano, na montie; montie mo agya Israel. ");
INSERT INTO twiasante_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, wo na woyɛ mʼabakan. Wo na woyɛ me tumi ne mʼahoɔden nsɛnkyerɛnneɛ a ɛdi ɛkan a ɛboro animuonyam ne tumi so. ");
INSERT INTO twiasante_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Woyɛ kirikiri sɛ asorɔkye, nanso worenkɔ so bio, ɛfiri sɛ, woforoo wʼagya mpa ne ne yere kɔdaeɛ, de guu mʼanim ase. ");
INSERT INTO twiasante_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon ne Lewi yɛ anuanom. Wɔgyina hɔ ma basabasayɛ ne nsisie. ");
INSERT INTO twiasante_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mma me nkɔka wɔn agyinatuo ho, ɛfiri sɛ, wɔnam wɔn abufuo so akunkum nnipa, na wɔkunkumm anantwie de gyee wɔn ani. ");
INSERT INTO twiasante_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nnome nka wɔn abufuo, ɛfiri sɛ, ano yɛ den, na ɛyɛ atirimuɔdensɛm! Ɛno enti, mɛbɔ wɔn asefoɔ ahwete Israelman mu nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda, wo nuammarimanom bɛyi wo ayɛ. Wobɛsɛe wʼatamfoɔ nyinaa. Wʼagya mmammarima bɛkoto wo. ");
INSERT INTO twiasante_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ao, Yuda, woyɛ gyata ba a woawe wʼatamfoɔ ɛnam awie. Wote sɛ gyata a wabutu. Hwan na ɔbɛtumi akɔka no? ");
INSERT INTO twiasante_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ahempoma remfiri Yuda nsam, na saa ara nso na ahempoma remfiri ne nan ntam, kɔsi sɛ, deɛ ɛyɛ ne dea a aman nyinaa bɛtie no no bɛba. ");
INSERT INTO twiasante_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ɔbɛsa nʼafunumu wɔ bobe dua mu. Ɔde nʼafunumu ba bɛsa bobe pa mman mu. Ɔbɛsi ne ntoma wɔ nsã mu, na wasi nʼatadeɛ nso wɔ bobesa kɔɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Nʼaniwa aba bɛbiri asene bobesa. Ne se bɛyɛ fitaa asene nufosuo. ");
INSERT INTO twiasante_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebulon bɛtena mpoano. Ɔbɛsisi ahyɛngyinabea ama ahyɛn. Nʼahyeɛ so bɛtrɛ akɔsi Sidon. ");
INSERT INTO twiasante_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakar yɛ afunumu hoɔdenfoɔ a ɔbutu hɔ rehome wɔ nnwankuo mu. ");
INSERT INTO twiasante_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Sɛ ɔhunu sɛdeɛ nʼahomegyebea yɛ fa a, ne sɛdeɛ nʼasase no so dwo a, ɔbɛkuntunu agye adesoa, na wapene so sɛ akoa ama ɔhyɛ adwuma. ");
INSERT INTO twiasante_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan bɛbu ne manfoɔ atɛn sɛ Israel mmusuakuo no baako. ");
INSERT INTO twiasante_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan bɛyɛ sɛ ɔtweaseɛ a ɔda kwankyɛn; ɔbɛyɛ sɛ ahuritia a ɔnam tempɔn mu a ɔka ɔpɔnkɔ nantin, sɛdeɛ ɛbɛma ne sotefoɔ ate ahwe nʼakyiri. ");
INSERT INTO twiasante_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Ao, Awurade, wo nkwagyeɛ na meretwɛn. ");
INSERT INTO twiasante_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Nnipa bɔnefoɔ bɛto ahyɛ Gad so, na ɔno nso bɛti wɔn ato ahyɛ wɔn so. ");
INSERT INTO twiasante_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aser aduane a ɔdi no bɛyɛ aduane pa. Na ɔbɛma ahennuane a ɛyɛ akɔnnɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali te sɛ ɔforoteɛ a wɔagyaa no a ɔwo mma ahoɔfɛfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yosef yɛ ngo dua a ɛso aba, a ɛsi asutene ho, na ne mman tra afasuo. ");
INSERT INTO twiasante_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Agyantofoɔ kaa no hyɛeɛ, de abufuo to hyɛɛ ne so. ");
INSERT INTO twiasante_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Nanso, ne bɛma no gyinaa pintinn, na ne basa mu yɛɛ den; esiane Otumfoɔ Onyankopɔn a Yakob somm no no a ɔyɛ odwanhwɛfoɔ ne Israel botantim no; ");
INSERT INTO twiasante_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","esiane Onyankopɔn a wʼagya somm no a ɔboa wo no; Otumfoɔ a ɔde ɔsoro nhyira bɛhyira wo; nhyira a ɛfiri asase ase pɛɛ; nhyira a ɛfiri nufoɔ ne yafunu mu no. ");
INSERT INTO twiasante_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Wʼagya nhyira a wɔahyira no no bɛdɔɔso asene tete ntredee mmepɔ ne nkokoɔ a ɛtintim hɔ daa no so nnɔbaeɛ. Yeinom nyinaa mmra Yosef a ɔda mu fua a wɔpaa no firii ne nuanom mu no so. ");
INSERT INTO twiasante_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benyamin yɛ pataku a ɔyɛ nam; ɔbɔ aporɔ anɔpa, kye nʼahaboa we, na ɛduru anwummerɛ a, ɔkyekyɛ ɛnam nkaeɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Yei ne nhyira a Israel mmusuakuo dumienu no agya de hyiraa wɔn; obiara ne sɛdeɛ ɛfata no. ");
INSERT INTO twiasante_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yakob rebɛwuo no, ɔka kyerɛɛ wɔn hyɛɛ wɔn sɛ, “Aka kakraa bi, na wɔrebɛfa me akɔka me mpanimfoɔ ho. Sɛ mewu a, monsie me wɔ ɔboda a ɛwɔ Hetini Efron afuo a wɔsiee me mpanimfoɔ mu no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ɛno ne ɔboda ne afuo a ɛwɔ Makpela, a ɛbɛn Mamrɛ a ɛwɔ Kanaan asase so no. Abraham tɔɔ saa ɔboda no firii Hetini Efron nkyɛn, de yɛɛ amusieeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Saa ɔboda no mu na wɔsiee Abraham ne ne yere Sara. Ɛhɔ ara nso na wɔsiee Isak ne ne yere Rebeka, na mesiee Lea nso. ");
INSERT INTO twiasante_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Me nana Abraham tɔɔ afuo no ne ɔboda a ɛka ho no nyinaa firii Hetifoɔ no nkyɛn.” ");
INSERT INTO twiasante_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ɛberɛ a Yakob kasa kyerɛɛ ne mma no wieeɛ no, ɔmaa ne nan so guu ne mpa so wuiɛ. Wɔkɔsiee no wɔ ne mpanimfoɔ nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Afei, Yosef too ne ho hwee nʼagya so suiɛ, fee nʼano. ");
INSERT INTO twiasante_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ɛno akyiri no, Yosef maa nʼaduruyɛfoɔ bɛhyɛɛ nʼagya Israel akyenkyennuro, sɛdeɛ ɛbɛyɛ a, ɔrensɛe. Enti, aduroyɛfoɔ no hyɛɛ no akyenkyennuro. ");
INSERT INTO twiasante_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Wɔde adaduanan na ɛhyɛɛ Israel akyenkyennuro no, ɛfiri sɛ, saa nna dodoɔ no na ɛsɛ sɛ wɔde hyɛ no aduro no. Misraimfoɔ suu no nnafua aduɔson. ");
INSERT INTO twiasante_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Wɔsuu no wieeɛ no, Yosef kasa kyerɛɛ Farao fiefoɔ sɛ, “Sɛ manya mo anim animuonyam a, monka nkyerɛ Farao mma me sɛ, ");
INSERT INTO twiasante_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Mʼagya maa mekaa ntam,’ na ɔkaa sɛ: Hwɛ, aka kakra na mawu. Enti, sɛ mewu a, ɔboda a mʼankasa metwaa wɔ Kanaan asase so no mu na monkɔsie me. ‘Enti, mommisa otumfoɔ Farao ɛkwan mma me na menkɔsie mʼagya, na mɛsane maba.’ ” ");
INSERT INTO twiasante_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao penee akwansra no so, kaa sɛ, “Kɔ na kɔsie wʼagya, sɛdeɛ ɔmaa wo kaa no ntam no.” ");
INSERT INTO twiasante_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ɛno enti, Yosef kɔ kɔsiee nʼagya. Farao asomfoɔ nyinaa ne ne mpanimfoɔ ne nʼatenankonnwa ne Misraim nnipa titire nyinaa kɔgyaa Yosef ayie. ");
INSERT INTO twiasante_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ɛno akyiri, Yosef fiefoɔ nyinaa a ne nuammarimanom ne nʼagya fiefoɔ ka ho ne no kɔɔ ayie no. Wɔn mma ne wɔn nnwan ne wɔn anantwie nko ara na wɔgyaa wɔn wɔ Gosen asase so hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Nteaseɛnam ne apɔnkɔsotefoɔ nso kaa wɔn ho kɔɔ ayie no bi. Nnipadɔm pa ara na wɔkɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Wɔduruu Atad a nʼasekyerɛ ne baabi a wɔpo atokoɔ, a ɛwɔ Asubɔnten Yordan atɔeɛ fam no, wɔde nnanson twaa agyaadwoɔ, yɛɛ Yosef agya Israel ayi kɛseɛ wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ɛberɛ a Kanaanfoɔ a na wɔte asase no so hunuu sɛdeɛ wɔsi yɛɛ ayie no wɔ Atad no, wɔkaa sɛ, “Yei yɛ ayi kɛseɛ bi a Misraimfoɔ ayɛ.” Ɛno enti, Kanaanfoɔ a wɔte asase no so no too hɔ edin Abel-Misraim, a asekyerɛ ne Misraimfoɔ ayi kɛseɛ yɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Enti, Yakob mmammarima no yɛɛ sɛdeɛ wɔn agya kyerɛɛ wɔn sɛ wɔnyɛ no pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Wɔsoaa no, de no kɔɔ Kanaan asase so, kɔsiee no wɔ ɔboda a ɛwɔ Makpela a ɛbɛn Mamrɛ afuo a na Abraham atɔ afiri Hetini Efron nkyɛn de ayɛ amusieeɛ no mu. ");
INSERT INTO twiasante_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosef siee nʼagya wieeɛ no, ɔne ne nuanom ne wɔn a wɔkɔgyaa no ayie no nyinaa sane baa Misraim. ");
INSERT INTO twiasante_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yosef agya wuo akyiri no, ne nuanom no de ehu ka kyerɛɛ wɔn ho wɔn ho sɛ, “Sɛ ɛba sɛ Yosef da so wɔ yɛn ho menasepɔ, na ɔtua yɛn bɔne ahodoɔ a yɛayɛ no nyinaa so ka a, na yɛreyɛ no ɛdeɛn.” ");
INSERT INTO twiasante_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Enti, wɔtuu nnipa kɔɔ Yosef hɔ kɔka kyerɛɛ no sɛ, “Wʼagya kaa saa asɛm yi ansa na ɔrewu. ");
INSERT INTO twiasante_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Asɛm yi na ɛsɛ sɛ moka kyerɛ Yosef: Mesrɛ wo, fa bɔne ahodoɔ a wo nuanom ayɛ wo no nyinaa kyɛ wɔn.’ Enti, afei mesrɛ wo, fa Onyankopɔn a wʼagya somm no no nkoa bɔne kyɛ wɔn.” Ɛberɛ a Yosef tee asɛm a ne nuanom no kaeɛ no, ɔsuiɛ. ");
INSERT INTO twiasante_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Yosef nuammarima no bɛtotoo wɔn ho guguu nʼanim, kaa sɛ, “Yɛyɛ wo nkoa.” ");
INSERT INTO twiasante_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Nanso, Yosef ka kyerɛɛ wɔn sɛ, “Monnsuro me! Meyɛ Onyankopɔn a mɛtumi abu mo atɛn, atwe mo aso anaa? ");
INSERT INTO twiasante_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ɛwom sɛ moyɛɛ mo adwene sɛ mobɛyɛ me bɔne deɛ, nanso na Onyankopɔn adwene ne sɛ, ɛbɛdane ade pa, sɛdeɛ ɛbɛyɛ a, ɔbɛtumi agye nnipa dodoɔ nkwa, sɛdeɛ ɔreyɛ no ɛnnɛ yi. ");
INSERT INTO twiasante_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Enti, monnsuro! Mʼankasa mede biribiara a ɛhia mo ne mo mma nyinaa bɛma mo.” Yosef nam saa kasakyerɛ yi so hyɛɛ wɔn bɔ sɛ, ɔrenyɛ wɔn bɔne biara. ");
INSERT INTO twiasante_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosef ankasa ne ne nuanom ne nʼagya abusuafoɔ nyinaa tenaa Misraim asase so. Ɔdii mfeɛ ɔha ne edu ansa na ɔrewu. ");
INSERT INTO twiasante_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yosef hunuu Efraim mma nana ne Manase ba Makir mma nso. Wɔwoo wɔn guu ne srɛ so. ");
INSERT INTO twiasante_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Afei, Yosef ka kyerɛɛ ne nuammarima no sɛ, “Ɛrenkyɛre biara na mawu. Nanso, Onyankopɔn bɛboa mo, ayi mo afiri saa asase yi so, de mo akɔ bɔhyɛ asase a ɔkaa ho ntam sɛ ɔde bɛma Abraham, Isak ne Yakob no so.” ");
INSERT INTO twiasante_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yosef maa Israel mmammarima no kaa ntam, na Yosef kaa sɛ, “Nokorɛm, Onyankopɔn bɛdi aboa mo. Sɛ mewu nso a, monsoa me nnompe mfiri ha nkɔ Kanaan asase so.” ");
INSERT INTO twiasante_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yosef dii mfeɛ ɔha ne edu, na ɔwuiɛ. Wɔhyɛɛ no akyenkyennuro de no too efunu adaka mu wɔ Misraim.");
INSERT INTO twiasante_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yakob mma ne wɔn abusuafoɔ a wɔne no tu kɔtenaa no din na ɛdidi so yi. ");
INSERT INTO twiasante_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Lewi ne Yuda; ");
INSERT INTO twiasante_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakar, Sebulon ne Benyamin; ");
INSERT INTO twiasante_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali; Gad ne Aser. ");
INSERT INTO twiasante_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yakob asefoɔ a ɔne wɔn kɔeɛ no nyinaa ano si aduɔson. Na Yosef wɔ Misraim dada. ");
INSERT INTO twiasante_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yosef ne ne nuanom ne wɔn ɛberɛ sofoɔ no nyinaa wuwuiɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","nanso Israelfoɔ no ase dɔreeɛ, na wɔyɛɛ bebree, hyɛɛ asase no so ma. ");
INSERT INTO twiasante_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Na ɔhene foforɔ bi bɛdii adeɛ wɔ Misraim a na ɔnnim Yosef ho asɛm. ");
INSERT INTO twiasante_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ɔka kyerɛɛ ne mamfoɔ no sɛ, “Monhwɛ, Israelfoɔ yi ase adɔre, wɔreyɛ adɔɔso dodo ama yɛn. ");
INSERT INTO twiasante_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Momma yɛmpɛ ɛkwan bi na yɛmfa so nsi saa dɔre a wɔredɔre no ano. Sɛ yɛanyɛ saa na ɔko bi si a, wɔbɛdɔm yɛn atamfoɔ ne wɔn ako atia yɛn na wɔafiri ɔman yi mu.” ");
INSERT INTO twiasante_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Enti wɔde nkoa sohwɛfoɔ gyinagyinaa wɔn kɔn so ma wɔyɛɛ adwuma den de kyekyeree adekora nkuropɔn Pitom ne Rameses maa Farao. ");
INSERT INTO twiasante_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Nanso mpɛn dodoɔ a Misraimfoɔ no hyɛɛ wɔn so no, dɔ ara na Israelfoɔ no dɔɔso. Yei maa Misraimfoɔ no suroo Israelfoɔ ");
INSERT INTO twiasante_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","na wɔkɔɔ so hyɛɛ Israelfoɔ no so ketee. ");
INSERT INTO twiasante_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wɔde adwumadenyɛ dii Israelfoɔ no nya. Wɔma wɔyɛɛ ntayaa ne dɔteɛ ho adwuma a ɛyɛ den ne mfuom nnwuma ahodoɔ. Yeinom nyinaa akyiri no Misraimfoɔ yɛɛ atirimuɔden akwan bebree so kyerɛɛ Israelfoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Misraimhene ka kyerɛɛ Hebrifoɔ awogyefoɔ a wɔn din ne Sifra ne Pua sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Sɛ mokɔgye Hebrini biara awoɔ, na awoeɛ hɔ mohunu sɛ ɔyɛ ɔbabarima a, monkum no, na sɛ ɔyɛ ɔbabaa deɛ a, monnyɛ no hwee.” ");
INSERT INTO twiasante_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Esiane sɛ na awogyefoɔ no yɛ onyamesurofoɔ no enti, wɔanni mmara a ɔhene no hyɛɛ wɔn no so maa mmarimaa a wɔwowoo wɔn no tenaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ɔhene no frɛɛ wɔn bisaa wɔn sɛ, “Adɛn enti na moanni mmara a mehyɛeɛ no so na moama mmarimaa a Hebrifoɔ no wowoo wɔn no atena?” ");
INSERT INTO twiasante_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Wɔbuaa no sɛ, “Hebrifoɔ mmaa no de ahoɔden wo ɔherɛ so enti yɛbɛduru hɔ no, na wɔawo dada. Wɔnte sɛ Misraimfoɔ mmaa no.” ");
INSERT INTO twiasante_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Onyankopɔn hyiraa awogyefoɔ no. Na Israelfoɔ no dɔɔso ara bɛyɛɛ ɔman kɛseɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Esiane sɛ na awogyefoɔ no yɛ nyamesurofoɔ enti, Onyankopɔn domm wɔn mma. ");
INSERT INTO twiasante_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Afei, Farao hyɛɛ mmara sɛ Herbrifoɔ mmarimaa a wɔbɛwo wɔn foforɔ no, wɔnto wɔn ngu Asubɔnten Nil mu na mmaayewa a wɔbɛwo wɔn foforɔ no deɛ, wɔntena hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Saa ɛberɛ no mu, Lewini bi waree abaayewa bi firii Lewi abusuakuo mu. ");
INSERT INTO twiasante_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ɔbaa no nyinsɛnee, woo abarimaa. Abɔfra no maame hunuu sɛ ne ho yɛ fɛ yie enti ɔde no siee efie abosome mmiɛnsa. ");
INSERT INTO twiasante_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ɛduruu ɛberɛ bi no, na ɔde no sie a ɛnyɛ yie enti, ɔde mmɛwa nwonoo kɛntɛn bi de ɛhyɛ ne aman faa ho sɛdeɛ ɛbɛyɛ a, nsuo ntumi nkɔ mu. Ɔde abɔfra no too mu de no kɔsii asuo Nil konkɔn so wɔ wura a na ɛwɔ hɔ no bi mu. ");
INSERT INTO twiasante_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Abɔfra no nuabaa kɔgyinaa akyiri baabi a na ɔwɛn no. ");
INSERT INTO twiasante_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Farao babaa kɔɔ nsuo no mu sɛ ɔrekɔdware. Ɛberɛ a ɔne ne mmaawa nam asuo no konkɔn so no, ɔhunuu kɛntɛn no sɛ ɛhyɛ wiram hɔ baabi, enti ɔsomaa ne mmaawa no mu baako sɛ ɔnkɔfa mmrɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ɔde baeɛ a ɔbuee so no, ɔhunuu sɛ abarimaa bi da mu a ɔresu. Asɛm no yɛɛ no awerɛhoɔ. Ɔkaa sɛ, “Ɔyɛ Hebrifoɔ yi binom ba.” ");
INSERT INTO twiasante_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Abɔfra no nuabaa a na ɔrewɛn no no kɔɔ ɔhene babaa no nkyɛn kɔbisaa no sɛ, “Menkɔfrɛ Hebrifoɔ mmaa no baako na ɔmmɛhwɛ no mma wo anaa?” ");
INSERT INTO twiasante_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ɔhene babaa no buaa sɛ, “Aane.” Enti, abaayewa no tuu mmirika kɔɔ efie kɔfrɛɛ abɔfra no maame de no baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ɔhene babaa no ka kyerɛɛ no sɛ, “Fa abɔfra no kɔ efie na kɔhwɛ no ma me na mɛtua wo ho ka.” Enti, ɔde no kɔɔ efie kɔhwɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ɔnyinii kakra no, ɔde no brɛɛ ɔhene babaa no ma ɔgyee no de no yɛɛ ne ba. Ɔkaa sɛ, “Mɛto ne edin Mose ɛfiri sɛ meyii no firii nsuo mu.” ");
INSERT INTO twiasante_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mose nyiniiɛ no, ɛda bi, ɔkɔsraa ne manfoɔ Hebrifoɔ no. Ɔduruu hɔ no, ɔhunuu sɛ ne manfoɔ no reyɛ adwumaden. Nsrahwɛ no mu na Mose hunuu sɛ Misraimni bi reboro Hebrini a ɔyɛ ne nua. ");
INSERT INTO twiasante_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mose hwɛɛ ha hwɛɛ ha hunuu sɛ obiara nni hɔ no, ɔkumm Misraimni no tutuu fam de no hyɛɛ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Adeɛ kyeeɛ no, ɔsane kɔɔ Hebrifoɔ no hɔ nsrahwɛ. Ɔduruu hɔ no, na wɔn mu baanu reko. Ɔbisaa deɛ nʼasɛm nyɛ dɛ no sɛ, “Ɛdeɛn na woreyɛ yi a worebobɔ wo nua Hebrini saa?” ");
INSERT INTO twiasante_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ɔbarima no nso bisaa no sɛ, “Wofiri he? Hwan na ɔde wo yɛɛ yɛn sodifoɔ ne ɔtemmufoɔ? Anaasɛ woayɛ wʼadwene sɛ wobɛkum me sɛdeɛ nnora wokumm Misraimni no?” Mose hunuu sɛ bɔne a wayɛ no ho ada hɔ no, ɔsuroeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Na Farao nso tee asɛm no, ɔhyɛɛ sɛ wɔnkɔfa Mose mmra na wɔnkum no. Nanso, Mose dwane kɔɔ Midian asase so. Ɛda bi a Mose kɔtenaa abura bi ho wɔ hɔ no, ");
INSERT INTO twiasante_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midian ɔsɔfoɔ mmammaa baason bi baa hɔ sɛ wɔrebɛto nsuo de akɔma wɔn agya nnwan. ");
INSERT INTO twiasante_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Nanso, nnwanhwɛfoɔ bi pampam mmaayewa no. Mose bɛgyee wɔn firii nnwanhwɛfoɔ no nsam maa mmaayewa no nnwan no nyaa nsuo nomeeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Wɔsane kɔduruu wɔn agya Reuel nkyɛn no, ɔbisaa wɔn sɛ, “Ɛyɛɛ dɛn na ɛnnɛ deɛ monyaa nsuo maa nnwan yi nom ntɛm seyie?” ");
INSERT INTO twiasante_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Wɔka kyerɛɛ wɔn agya sɛ, “Misraimni bi na ɔgyee yɛn firii nnwanhwɛfoɔ no nsam. Ɔno ara na ɔtoo nsuo maa yɛn nnwan no nomeeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Wɔn agya bisaa sɛ, “Na ɔwɔ he? Mogyaa no hɔ anaa? Monkɔfrɛ no na ɔmmɛdidi.” ");
INSERT INTO twiasante_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mose kɔɔ Reuel frɛ no. Akyire yi no, ɔne wɔn kɔtenaeɛ ma Reuel de ne babaa Sipora maa no awadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Wɔwoo ɔbabarima ma Mose too no edin Gersom, aseɛ ne Ɔhɔhoɔ, ɛfiri sɛ, Mose kyerɛ aseɛ sɛ, “Meyɛ ɔhɔhoɔ wɔ ananafoɔ asase so.” ");
INSERT INTO twiasante_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Mfeɛ bi akyiri no, Misraimhene no wuiɛ. Na Israelfoɔ no resi apinie wɔ wɔn nkoasom no mu. Enti na wɔresu frɛ Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Onyankopɔn nso tiee wɔn sufrɛ no, kae ɛbɔ a ɔhyɛɛ Abraham, Isak ne Yakob sɛ ɔde nʼasefoɔ bɛsane aba Kanaan asase so no. ");
INSERT INTO twiasante_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Onyankopɔn hwɛ hunuu sɛ ɛberɛ aduru sɛ ɔgye wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ɛda bi na Mose rehwɛ nʼase Yetro a ɔyɛ Midian ɔsɔfoɔ nnwan. Ɔde nnwan no wuraa ɛserɛ no mu kɔɔ akyirikyiri kɔduruu Horeb a ɛyɛ Onyankopɔn bepɔ no so. ");
INSERT INTO twiasante_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Prɛko pɛ, na Awurade ɔbɔfoɔ daa ne ho adi sɛ gyaframa wɔ wira no mu kyerɛɛ no. Mose hunuu sɛ wira no redɛre nanso na ɛnhye. ");
INSERT INTO twiasante_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Enti, Mose kaa sɛ, “Mɛkɔ akɔhwɛ anwanwadeɛ yi ahunu deɛ enti a wira no nhye.” ");
INSERT INTO twiasante_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ɛberɛ a Awurade hunuu sɛ ɔrekɔhwɛ no, ɔfrɛɛ no firii wira no mu sɛ, “Mose! Mose!” Mose gyee so sɛ, “Me nie.” ");
INSERT INTO twiasante_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Onyankopɔn ka kyerɛɛ no sɛ, “Mmɛn me. Yi wo nan mu mpaboa na baabi a wogyina no yɛ asase kronkron.” ");
INSERT INTO twiasante_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ɔtoaa so sɛ, “Mene wʼagyanom Onyankopɔn—Abraham Onyankopɔn, Isak Onyankopɔn ne Yakob Onyankopɔn.” Mose kataa nʼanim, ɛfiri sɛ, na ɔsuro sɛ ɔbɛhwɛ Onyankopɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Awurade ka kyerɛɛ no sɛ, “Mahunu amanehunu a me manfoɔ a wɔwɔ Misraim no wɔ mu, na mate wɔn nkotosrɛ a ɛfa wɔn nnwuma wuranom ho, na menim wɔn ahohiahia. ");
INSERT INTO twiasante_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Maba sɛ merebɛgye wɔn afiri Misraimfoɔ nsam na mayi wɔn afiri Misraim asase so de wɔn akɔ asase pa so—asase a ɛtrɛ; asase a ɛwoɔ ne nufosuo wɔ so—asase a Kanaanfoɔ, Hetifoɔ, Amorifoɔ, Perisifoɔ, Hewifoɔ ne Yebusifoɔ te soɔ no so. ");
INSERT INTO twiasante_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Mate Israelfoɔ no su, na mahunu nya a Misraimfoɔ di wɔn no. ");
INSERT INTO twiasante_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Afei, merebɛsoma wo akɔ Farao nkyɛn, akɔyi me ɔman Israel afiri Misraim.” ");
INSERT INTO twiasante_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mose bisaa sɛ, “Mene hwan a mɛtumi akɔ Farao anim akɔka sɛ merebɛyi Israelfoɔ afiri Misraim asase so?” ");
INSERT INTO twiasante_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Onyankopɔn buaa no sɛ, “Mɛka wo ho. Adansedeɛ a ɛkyerɛ sɛ me na masoma wo no nie. Sɛ woyi nnipa no firi Misraim a, mobɛsom Onyankopɔn wɔ saa bepɔ yi so.” ");
INSERT INTO twiasante_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mose bisaa sɛ, “Sɛ mekɔ Israelfoɔ no nkyɛn kɔka sɛ, wɔn agyanom Onyankopɔn na wasoma me na wɔbisa me sɛ. ‘Onyankopɔn bɛn na mereka ne ho asɛm no’ a, mmuaeɛ bɛn na memfa mma wɔn?” ");
INSERT INTO twiasante_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ɔbuaa Mose sɛ, ka sɛ, “Mene deɛ ɔwɔ hɔ daa no. Ka kyerɛ wɔn sɛ, ‘Me Ara na wasoma me mo nkyɛn.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Onyankopɔn toaa so sɛ, “Awurade a ɔyɛ mo nananom Abraham, Isak ne Yakob Onyankopɔn na wasoma me mo nkyɛn.” Yei ne me edin a wɔde bɛkae me ɛda biara firi awoɔ ntoatoasoɔ so kɔsi awoɔ ntoatoasoɔ so. ");
INSERT INTO twiasante_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Onyankopɔn ka kyerɛɛ no sɛ, “Frɛ Israelfoɔ mpanimfoɔ nyinaa hyia na ka hunu a wohunuu Awurade wɔ wira a na ɛredɛre mu no kyerɛ wɔn. Afei, ka asɛm a meka kyerɛɛ wo sɛ, ‘Makɔsra me nkurɔfoɔ na mahunu deɛ aba wɔn so wɔ Misraim no kyerɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Mehyɛ bɔ sɛ mɛyi wɔn afiri amanehunu ne animguaseɛ a wɔwɔ mu no mu na mede wɔn akɔ asase a Kanaanfoɔ, Hetifoɔ, Amorifoɔ, Perisifoɔ, Hewifoɔ ne Yebusifoɔ te so ɛnnɛ yi a ɛwoɔ ne nufosuo wɔ so no so.’ ");
INSERT INTO twiasante_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Israelfoɔ mpanimfoɔ bɛtie wʼasɛm na wɔne wo akɔ Misraimhene hɔ akɔka akyerɛ no sɛ, ‘Awurade, Hebrifoɔ Onyankopɔn, ne yɛn ahyia na waka akyerɛ yɛn sɛ, yɛntu nnansa ɛkwan nkɔ ɛserɛ so nkɔbɔ afɔdeɛ mma no. Enti, ma yɛn ɛkwan.’ ");
INSERT INTO twiasante_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Nanso, menim sɛ Misraimhene remma mo ɛkwan da, gye sɛ wɔhyɛ no ketee. ");
INSERT INTO twiasante_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Enti, mɛhyɛ no ketee sɛdeɛ ɛsɛ. Menam anwanwakwan so bɛsɛe Misraim na akyire no, wama mo akɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Mɛma mo anim aba nyam Misraimfoɔ no anim na wɔahyehyɛ akyɛdeɛ ama mo, na moankɔ no nsapan. ");
INSERT INTO twiasante_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ɔbaa biara mmisa dwetɛ ne sikakɔkɔɔ adwinneɛ ne ntoma pa mfiri nʼafipamfoɔ ne ne fiefoɔ mmaa nkyɛn na wɔmfa nsiesie wɔn mmammarima ne wɔn mmammaa ho. Wɔnam saa yɛ so bɛpansam Misraimfoɔ ahonyadeɛ te sɛ deɛ wɔafom asadeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Na Mose buaa no sɛ, “Wɔrennye me nni. Asɛm a mɛka no, wɔrenni so. Wɔbɛka sɛ, ‘Awurade nyii ne ho adi nkyerɛɛ wo!’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Awurade bisaa no sɛ, “Ɛdeɛn na wokura yi?” Ɔbuaa sɛ, “Odwanhwɛfoɔ poma.” ");
INSERT INTO twiasante_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Awurade ka kyerɛɛ no sɛ, “To twene fam.” Enti ɔto twenee fam ma ɛdanee ɔwɔ. Mose dwane firii aboa no ho. ");
INSERT INTO twiasante_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Afei, Awurade ka kyerɛɛ Mose sɛ, “Sɔ ɔwɔ no dua mu kyere no!” Ɔsɔɔ ne dua mu kyeree no no, ɛsane danee poma no bio. ");
INSERT INTO twiasante_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Awurade ka kyerɛɛ no sɛ, “Kɔyɛ saa na wɔbɛgye wo adi. Ɛbɛma wɔahunu sɛ wo agyanom Abraham, Isak ne Yakob Onyankopɔn ada ne ho adi akyerɛ wo ampa. ");
INSERT INTO twiasante_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","“Afei, fa wo nsa hyɛ wo bo.” Ɔde ne nsa hyɛɛ ne bo na ɔyiiɛ no, na kwata ayɛ ne nsa ho fitaa. ");
INSERT INTO twiasante_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Awurade ka kyerɛɛ no bio sɛ, “Fa wo nsa hyɛ wo bo bio.” Ɔde ne nsa hyɛɛ ne bo bio na ɔyiiɛ no, na kwata no agyae ama ne nsa no ho ayɛ sɛdeɛ ɛte kane no. ");
INSERT INTO twiasante_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Awurade ka kyerɛɛ no sɛ, “Sɛ wɔannye anwanwadeɛ a ɛdi ɛkan no anni a, wɔbɛgye deɛ ɛtɔ so mmienu no adi. ");
INSERT INTO twiasante_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Na sɛ nsɛnkyerɛnneɛ mmienu yi akyiri wɔannye wo anni a, kɔsa nsuo firi Asubɔnten Nil mu na bɛhwie gu asase wesee bi so na ɛbɛdane mogya.” ");
INSERT INTO twiasante_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Nanso, Mose srɛɛ sɛ, “Ao, Awurade, mennim kasa. Ɛbɛsi ɛnnɛ anaa ɛfiri ɛberɛ a wo ne me kasaeɛ mpo no, mʼano nte.” ");
INSERT INTO twiasante_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Awurade bisaa no sɛ, “Hwan na ɔyɛɛ onipa ano? Ɛnyɛ me Awurade na meyɛeɛ? Hwan na ɔbɔ onipa ma ɔtumi kasa anaa ɔmma no nkasa? Hwan na ɔma no hunu adeɛ anaa ɔmma no nhunu adeɛ? Hwan na ɔma no tumi te asɛm anaa ɔmma no nte asɛm? ");
INSERT INTO twiasante_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Afei, kɔ na kɔyɛ deɛ maka akyerɛ wo no na mɛboa wo ama woatumi akasa yie, na mɛkyerɛ wo deɛ wobɛka nso.” ");
INSERT INTO twiasante_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Nanso Mose kaa sɛ, “Awurade mesrɛ wo, soma onipa foforɔ.” ");
INSERT INTO twiasante_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Awurade bo fuiɛ enti ɔkaa sɛ, “Na wo nua Aaron, Lewini no nso ɛ? Menim sɛ nʼano ate. Na hwɛ ɔno na ɔrebɛhyia wo no, na sɛ ɔhunu wo a, nʼani bɛgye. ");
INSERT INTO twiasante_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Wobɛkasa akyerɛ no na woaka deɛ ɛsɛ sɛ ɔka akyerɛ no. Mɛboa mo baanu ama moakasa, na makyerɛ mo deɛ mobɛyɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ɔbɛyɛ wo ɔkyeame ɔman no anim, na wo nso woayɛ sɛ ne Onyankopɔn aka asɛm a wopɛ sɛ ɛda edwa akyerɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Sɛ worekɔ a, fa wo poma no sɛdeɛ ɛbɛyɛ a, wobɛtumi de ayɛ anwanwadeɛ a makyerɛ wo no.” ");
INSERT INTO twiasante_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mose kɔɔ efie kɔbɔɔ nʼase Yetro nsɛm a asie no ho amanneɛ. “Mɛsrɛ wo ɛkwan na makɔ Misraim makɔsra mʼabusuafoɔ. Mennim mpo sɛ, wɔte ase.” Yetro penee so sɛ, “Kɔ. Mehyira wo kosɛkosɛ.” ");
INSERT INTO twiasante_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ansa na Mose rebɛfiri Midian no, Awurade ka kyerɛɛ no sɛ, “Nsuro sɛ wobɛsane akɔ Misraim, ɛfiri sɛ, wɔn a na wɔrehwehwɛ wo akum wo no nyinaa awuwu.” ");
INSERT INTO twiasante_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Enti, Mose faa ne yere ne ne mma de wɔn tenatenaa mfunumu so sɛ ɔrekɔ Misraim a na Onyankopɔn poma no hyɛ ne nsam. ");
INSERT INTO twiasante_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Awurade ka kyerɛɛ Mose sɛ, “Sɛ woduru Misraim a, kɔ Farao hɔ na kɔyɛ anwanwadeɛ a makyerɛ wo yi kyerɛ no, nanso mɛma nʼaso ayɛ den, enti ɔremma nnipa no nkɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Na sɛ ɛba no saa a, ka kyerɛ no sɛ, ‘Awurade se, Israel yɛ mʼabakan ");
INSERT INTO twiasante_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","na mahyɛ wo sɛ, “Ma no ɛkwan na ɔnkɔ na ɔnkɔsom me.” Nanso woampene enti mɛkum wʼabakan.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mose ne nʼabusuafoɔ nam no, adeɛ saa wɔn ma wɔpɛɛ baabi daeɛ. Awurade daa ne ho adi kyerɛɛ Mose na ɔhunahunaa no sɛ ɔbɛkum no. ");
INSERT INTO twiasante_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Enti, ne yere Sipora faa sekammoa de twaa ne babarima kumaa twetia to twenee Mose nan ase kaa sɛ, “Mmogya ayeforɔkunu ne wo.” ");
INSERT INTO twiasante_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Enti Awurade gyaa Mose. Na Sipora kaa sɛ, “Woyɛ okunu a twetiatwa ama mogya aka wo.” ");
INSERT INTO twiasante_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Afei, Awurade ka kyerɛɛ Aaron sɛ, “Kɔ ɛserɛ no so kɔhyia Mose.” Enti, Aaron kɔɔ Onyankopɔn Bepɔ Horeb so kɔhyiaa Mose wɔ hɔ. Wɔhyiaeɛ no, wɔde mfeano kyeakyeaa wɔn ho fɛw so. ");
INSERT INTO twiasante_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mose kaa nsɛm a Awurade ka kyerɛɛ no ɛberɛ a ɔresoma no no ne anwanwadeɛ a ɔhyɛɛ no sɛ ɔnyɛ nyinaa kyerɛɛ Aaron. ");
INSERT INTO twiasante_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Enti, Mose ne Aaron sane kɔɔ Misraim frɛɛ Israelfoɔ mpanimfoɔ nyinaa ne wɔn yɛɛ nhyiamu. ");
INSERT INTO twiasante_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron kaa nsɛm a Awurade aka akyerɛ Mose no nyinaa kyerɛɛ wɔn enti, Mose yɛɛ anwanwadeɛ no ma wɔhwɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Yei maa mpanimfoɔ no gye dii sɛ, ampa, Awurade na wasoma wɔn. Afei, wɔtee sɛ Awurade akɔsra wɔn, na ɛnam so ama wahunu wɔn haw, na enti wayɛ nʼadwene sɛ ɔbɛgye wɔn afiri saa ɔhaw no mu no, wɔde anigyeɛ buu nkotodwe sɔreeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Mose ne Aaron yɛɛ anwanwadeɛ yi kyerɛɛ mpanimfoɔ no wieeɛ no, wɔkɔhunuu Farao. Wɔka kyerɛɛ no sɛ, “Awurade, Israel Onyankopɔn se yɛmmɛka asɛm bi nkyerɛ wo. Ɔse, ‘Ma me nkurɔfoɔ mfiri ha nkɔ ɛserɛ so nkɔbɔ afahyɛdwa kronkron wɔ hɔ mfa nsɔre me.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Farao bisaa sɛ, “Ampa? Na hwan ne Awurade a ɛsɛ sɛ metie no na mema Israelfoɔ no kɔ? Mennim Awurade biara enti meremma Israelfoɔ no nkɔ.” ");
INSERT INTO twiasante_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Nanso, Aaron ne Mose tii mu bio sɛ, “Hebri Onyankopɔn ne yɛn ahyia. Ɛsɛ sɛ yɛtu nnansa ɛkwan kɔ ɛserɛ so kɔbɔ afɔdeɛ wɔ hɔ de ma Awurade, yɛn Onyankopɔn. Na sɛ yɛantie no a, ɔyaredɔm anaa sekan ano na yɛbɛwuwuo.” ");
INSERT INTO twiasante_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Farao bisaa sɛ, “Mose ne Aaron, adɛn enti na morema nkurɔfoɔ no agyae wɔn nnwuma? Monkɔ mo nnwuma so ntɛm!” ");
INSERT INTO twiasante_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Farao toaa so sɛ, “Seesei, saa nnipa no dɔɔso sene ɔmanfoɔ no, nanso mopɛ sɛ moma ahɔhoɔ no gyae adwumayɛ.” ");
INSERT INTO twiasante_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ɛda no ara, Farao somaa nnipa maa wɔkɔka kyerɛɛ wɔn a wɔhwɛ Israelfoɔ no so no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Mommma nnipa no ɛserɛ a wɔde bɛyɛ ntayaa no bio! Momma wɔn ankasa nkɔtwa ɛserɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Afei, ntayaa dodoɔ a wɔtwa no nso, monnte so baako koraa, ɛfiri sɛ, asɛm a wɔaka no da no adi pefee sɛ, wɔyɛ akwadwofoɔ enti na wɔreka sɛ wɔrekɔ ɛserɛ so akɔbɔ wɔn Awurade afɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Momma wɔn adwuma no mu nyɛ den, na ɛmmee wɔn na wɔankɔtie atosɛm biara.” ");
INSERT INTO twiasante_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Enti, adwumasohwɛfoɔ ne wɔn akwankyerɛfoɔ no ka kyerɛɛ Hebrifoɔ no sɛ, “Farao aka akyerɛ yɛn sɛ yɛmmma mo ɛserɛ bio. ");
INSERT INTO twiasante_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mo ara monkɔkyini nhwehwɛ bi, nanso ntayaa a motwa no, montwa dodoɔ saa ara.” ");
INSERT INTO twiasante_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Enti, Hebrifoɔ kyinkyinii Misraim asase so nyinaa sɛ wɔrekɔhwehwɛ ɛserɛ no bi. ");
INSERT INTO twiasante_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Adwumasohwɛfoɔ no hyɛɛ wɔn atirimuɔden so sɛ, “Montwa ntayaa dodoɔ sɛdeɛ na motwa no.” ");
INSERT INTO twiasante_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Afei, Misraimfoɔ adwumasohwɛfoɔ no kaa Hebrifoɔ mpanimfoɔ a wɔde wɔn atuatua adwuma no ano sɛ akwankyerɛfoɔ no mmaa, bisaa wɔn sɛ, “Adɛn enti na moanwie ntayaa a wɔahyɛ sɛ montwa no nnora ne ɛnnɛ no nyinaa sɛdeɛ na moyɛ kane no?” ");
INSERT INTO twiasante_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Mpanimfoɔ yi kɔɔ Farao nkyɛn kɔsrɛɛ no sɛ, “Yɛsrɛ wo, nha yɛn saa, ");
INSERT INTO twiasante_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ɛfiri sɛ, wɔmma yɛn ɛserɛ nso wɔhyɛ yɛn sɛ yɛntwa ntayaa dodoɔ sɛdeɛ na yɛtwa no. Wɔka yɛn mmaa ɛberɛ a yɛnyɛɛ mfomsoɔ biara. Mfomsoɔ no mfiri yɛn. Ɛfiri adwumasohwɛfoɔ no, ɛfiri sɛ, wɔhyɛ yɛn sɛ yɛnyɛ adwuma a ɛboro yɛn ahoɔden so.” ");
INSERT INTO twiasante_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Nanso, Farao buaa sɛ, “Monni dwuma bi di, na sɛ mowɔ dwuma bi di a, anka morenka sɛ, ‘Momma yɛnkɔbɔ afɔdeɛ mma Awurade.’ ");
INSERT INTO twiasante_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Monsane nkɔyɛ adwuma ntɛm. Obiara remma mo ɛserɛ, nanso ntayaa dodoɔ a motwa no daa no, saa ara na mobɛtwa.” ");
INSERT INTO twiasante_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ɛberɛ a wɔka kyerɛɛ Israelfoɔ mpanimfoɔ a wɔdi adwuma no anim sɛ akwankyerɛfoɔ no sɛ ɛsɛ sɛ wɔtwa ntayaa no dodoɔ sɛdeɛ wɔyɛ daa no, wɔhunuu sɛ ahokyere aba. ");
INSERT INTO twiasante_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ɛberɛ a wɔfiri Farao anim baeɛ a wɔhunuu sɛ Mose ne Aaron retwɛn wɔn wɔ ahemfie no ho no, ");
INSERT INTO twiasante_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","wɔka kyerɛɛ wɔn sɛ, “Awurade mmu mo atɛn sɛ moama Farao ne ne nkurɔfoɔ anya yɛn ho menasepɔ, na enti wama wɔn ɛkwan sɛ wɔnkum yɛn.” ");
INSERT INTO twiasante_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Asɛm yi maa Mose kɔɔ Awurade nkyɛn kɔka kyerɛɛ no sɛ, “Awurade, adɛn enti na woma wo manfoɔ brɛ saa? Sɛ wonim sɛ wobɛyɛ wɔn saa a, adɛn enti na wosomaa me? ");
INSERT INTO twiasante_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ɛfiri ɛberɛ a mekɔkaa wo nkra no kyerɛɛ Farao no, tan ara na ɔretan wɔn ani, nanso wonnyee wɔn ɛkwan biara so!” ");
INSERT INTO twiasante_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Awurade ka kyerɛɛ Mose sɛ, “Wobɛhunu deɛ mede bɛyɛ Farao. Menam me tumi so bɛhyɛ no na wama me nkurɔfoɔ no akɔ. Nokorɛm, mɛhyɛ no ama wapam wɔn afiri asase no so.” ");
INSERT INTO twiasante_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Na Onyankopɔn ka kyerɛɛ Mose sɛ, “Mene Awurade no. ");
INSERT INTO twiasante_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Meyii me ho adi kyerɛɛ Abraham, Isak ne Yakob sɛ Onyankopɔn tumfoɔ. Nanso, mammɔ me din sɛ Awurade no ankyerɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Na me ne wɔn hyehyɛɛ apam sɛ mede Kanaan asase a na tete no wɔte so sɛ ahɔhoɔ no bɛma wɔn ne wɔn asefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Afei, mate Israelfoɔ apinisie ne nya a Misraimfoɔ di wɔn no nyinaa na makae me ne wɔn apam no. ");
INSERT INTO twiasante_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Enti, ka kyerɛ Israelfoɔ no sɛ, ‘Me, Awurade, menam me tumi so bɛyɛ anwanwadeɛ de ayi wɔn afiri nkoasom mu ama wɔade wɔn ho. ");
INSERT INTO twiasante_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mɛgye wɔn atom sɛ me nkurɔfoɔ na mayɛ wɔn Onyankopɔn. Na wɔbɛhunu sɛ mene Awurade, wɔn Onyankopɔn a wagye wɔn afiri Misraimfoɔ nsam no. ");
INSERT INTO twiasante_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mede wɔn bɛba asase a mehyɛɛ bɔ sɛ mede bɛma Abraham, Isak ne Yakob no so. Saa asase no bɛyɛ mo agyapadeɛ. Mene Awurade no.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Enti, Mose kaa asɛm a Onyankopɔn ka kyerɛɛ no no kyerɛɛ nnipa no, nanso wɔantie, ɛsiane abasamutuo a ɛfiri ɔhyɛ ntrasoɔ enti. ");
INSERT INTO twiasante_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Sane kɔ Farao nkyɛn kɔka kyerɛ no sɛ ɔmma Israelfoɔ no ɛkwan na wɔnkɔ.” ");
INSERT INTO twiasante_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Nanso, Mose kaa sɛ, “Dabi, afei deɛ, me ara me nkurɔfoɔ no rentie asɛm a mɛka biara bio. Na mʼano nso nteeɛ yi, ɛbɛyɛ dɛn na matumi akasa ama atɔ Farao asom?” ");
INSERT INTO twiasante_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Afei, Awurade hyɛɛ Mose ne Aaron sɛ wɔnsane nkɔ Israelfoɔ no ne Farao a ɔyɛ Misraimfoɔ ɔhene no nkyɛn nkɔka nkyerɛ no sɛ ɔmma Israelfoɔ no ɛkwan na wɔmfiri Misraim asase so nkɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Nnipa a na wɔtuatua Israel mmusuakuo no ano no edin na ɛdidi so yi: Ruben a ɔyɛ Israel abakan mmammarima yɛ: Hanok, Palu, Hesron, Karmi. Yeinom na wɔwoo Ruben asefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeon mmammarima: Yemuel, Yamin, Ohad, Yakin, Sohar ne Saulo a na ne maame yɛ Kanaanni. Yeinom na wɔwoo Simeon asefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lewi mmammarima: Gerson, Kohat, Merari. (Lewi dii mfeɛ ɔha aduasa nson.) ");
INSERT INTO twiasante_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gerson mmammarima: Libni, Simei a wɔyɛ mmusua ti. ");
INSERT INTO twiasante_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohat mmammarima: Amram, Ishar, Hebron, Usiel. (Kohat dii mfeɛ ɔha aduasa mmiɛnsa.) ");
INSERT INTO twiasante_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari mmammarima: Mahli, Musi. Saa nnipa a wɔabobɔ wɔn edin mpanin mu no no yɛ Lewi abusuafoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram waree nʼagya nuabaa Yokebed na wɔwoo Mose ne Aaron. (Amram dii mfeɛ ɔha aduasa nson.) ");
INSERT INTO twiasante_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ishar mmammarima: Kora, Nefeg, Sikri. ");
INSERT INTO twiasante_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usiel mmammarima: Misael, Elsafan, Sitri. ");
INSERT INTO twiasante_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron waree Aminadab babaa Elisaba a ɔyɛ Nahson nuabaa Wɔn mma edin nie: Nadab, Abihu, Eleasa ne Itamar. ");
INSERT INTO twiasante_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora mmammarima: Asir, Elkana, Abiasaf. Yeinom ne Kora asefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaron babarima Eleasa waree Putiel mmammaa no baako. Na Pinehas yɛ wɔn mma no mu baako. Nnipa a wɔabobɔ wɔn edin yi ne wɔn a na wɔtuatua Lewifoɔ mmusuakuo no ano. ");
INSERT INTO twiasante_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Saa Aaron ne Mose yi ara na Awurade ka kyerɛɛ wɔn sɛ, “Monkɔyi Israelfoɔ nyinaa mfiri Misraim asase so” no. ");
INSERT INTO twiasante_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Na wɔn na wɔkɔɔ Farao hɔ kɔsrɛɛ no ɛkwan sɛ ɔmma wɔnni Israelfoɔ no anim nyi wɔn mfiri asase no so. ");
INSERT INTO twiasante_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ɛda a Awurade kasa kyerɛɛ Mose wɔ Misraim asase so no, ");
INSERT INTO twiasante_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ɔkaa sɛ, “Mene Awurade no. Ka asɛm biara a mereka yi kyerɛ Farao a ɔyɛ Misraim ɔhempɔn no.” ");
INSERT INTO twiasante_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Na Mose ka kyerɛɛ Awurade bio sɛ “Mʼano nteeɛ yi, ɛbɛyɛ dɛn na asɛm a mɛka no bɛtɔ Farao asom ama watie me?” ");
INSERT INTO twiasante_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Na Awurade ka kyerɛɛ Mose sɛ, “Mayi wo sɛ mʼananmusini wɔ Farao anim na Aaron ayɛ wo ɔkyeame. ");
INSERT INTO twiasante_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Asɛm biara a mɛka akyerɛ wo no, ka kyerɛ Aaron, na ɔno nso nka nkyerɛ Farao sɛ ɔmma Israelfoɔ no ɛkwan na wɔmfiri Misraim. ");
INSERT INTO twiasante_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Na nna no mu, mɛma Farao ayɛ akomaden, na mayɛ anwanwadeɛ ahodoɔ bebree wɔ Misraim. ");
INSERT INTO twiasante_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Anwanwadeɛ ahodoɔ no akyiri, ɔbɛkɔ so ayɛ akomaden ara, enti mɛtɔre wɔn ase na madi me manfoɔ anim, ayi wɔn afiri asase no so. ");
INSERT INTO twiasante_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Na sɛ mekyerɛ me tumi kyerɛ Misraimfoɔ no a, wɔbɛhunu sɛ, nokorɛ, mene Awurade no, na wɔama me nkurɔfoɔ no ɛkwan ama wɔakɔ.” ");
INSERT INTO twiasante_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Enti, Mose ne Aaron yɛɛ sɛdeɛ Awurade kyerɛɛ wɔn no. ");
INSERT INTO twiasante_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ɛberɛ a Mose ne Aaron kɔhyiaa Farao no, na Mose adi mfeɛ aduɔwɔtwe, ɛnna Aaron nso adi mfeɛ aduɔwɔtwe mmiɛnsa. ");
INSERT INTO twiasante_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Awurade ka kyerɛɛ Mose ne Aaron sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Farao bɛhwehwɛ sɛ mobɛyɛ anwanwadeɛ akyerɛ no ama wahunu sɛ, nokorɛ, Onyankopɔn na wasoma mo. Sɛ ɔbisa saa a, Aaron nto ne poma no ntwene fam na ɛbɛdane ɔwɔ.” ");
INSERT INTO twiasante_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Enti, Mose ne Aaron kɔɔ Farao nkyɛn kɔyɛɛ anwanwadeɛ no sɛdeɛ Awurade akyerɛ wɔn no. Aaron too ne poma no twenee fam wɔ Farao ne ne nkurɔfoɔ anim ma ɛdanee ɔwɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Farao nso frɛɛ nʼanyansafoɔ ne ne nkonyaayifoɔ a wɔwɔ Misraim ma wɔn nso bɛyɛɛ anwanwadeɛ korɔ no ara bi. ");
INSERT INTO twiasante_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Wɔn nso, wɔn poma tumi danee ɔwɔ. Nanso, Aaron ɔwɔ no menee wɔn deɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Farao kɔɔ so yɛɛ akomaden a na ɔmpɛ sɛ ɔtie asɛm a Awurade kaeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Awurade ka kyerɛɛ Mose sɛ, “Farao apirim nʼakoma enti, ɔbɛkɔ so asi nnipa no ɛkwan sɛ ɔremma wɔnkɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Nanso Awurade kaa sɛ: Sane kɔ Farao nkyɛn anɔpa a ɔrekɔ asubɔnten no mu. Kɔgyina asuo no konkɔn so na hyia no wɔ hɔ a wo poma a ɛdanee ɔwɔ no kura wo. ");
INSERT INTO twiasante_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ka kyerɛ no sɛ, ‘Awurade, Hebrifoɔ Onyankopɔn asane asoma me wo nkyɛn sɛ ma nnipa no ɛkwan na wɔnkɔ nkɔsom me wɔ ɛserɛ so. Woayɛ asoɔden. ");
INSERT INTO twiasante_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Afei, Awurade se: Wobɛhunu sɛ, mene Awurade no. Ɛfiri sɛ, maka akyerɛ Mose sɛ ɔmfa ne poma no mmɔ Nil nsuo no mu na nsuo no bɛdane mogya. ");
INSERT INTO twiasante_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nsuomnam a wɔwɔ asubɔnten no mu nyinaa bɛwuwu ama nsuo no abɔn a Misraimfoɔ no rentumi nnom.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Afei, Awurade ka kyerɛɛ Mose sɛ, “Ka kyerɛ Aaron na ɔmfa ne poma no nkyerɛ nsuo a ɛwɔ Misraim no nyinaa; wɔn nsubɔntene, wɔn nsuwa, wɔn atadeɛ ne wɔn nsuo a ɛtaataa hɔ ne nsuo a ɛwɔ afie mu nyinaa so na ɛbɛdane mogya.” ");
INSERT INTO twiasante_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Enti, Mose ne Aaron yɛɛ sɛdeɛ Awurade hyɛɛ wɔn no. Ɛberɛ a Farao ne ne mpanimfoɔ gyinagyina hɔ rehwɛ wɔn no, Aaron de poma no bɔɔ Nil ani maa asubɔnten no danee mogya. ");
INSERT INTO twiasante_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nsuomnam a wɔwɔ mu nyinaa wuwuiɛ maa nsuo no bɔnee enti, na Misraimfoɔ no ntumi nnom. Misraim asase so nyinaa danee mogya. ");
INSERT INTO twiasante_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Nkonyaayifoɔ a wɔwɔ Misraim nso nam wɔn nkonyaayie so maa nsuo danee mogya enti, Farao kɔɔ so pirim nʼakoma a na ɔntie asɛm a Awurade aka akyerɛ Mose ne Aaron sɛ wɔnka nkyerɛ no no. ");
INSERT INTO twiasante_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ɔsane kɔɔ nʼahemfie a hwee ampusu no. ");
INSERT INTO twiasante_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Misraimfoɔ no tutuu nsubura wɔ asubɔnten no konkɔn so sɛdeɛ wɔbɛnya nsuo anom, ɛfiri sɛ, na wɔntumi nsa nsuo wɔ asubɔnten no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Asubɔnten a ɛdanee mogya no dii nnawɔtwe. ");
INSERT INTO twiasante_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Awurade ka kyerɛɛ Mose sɛ, “Kɔ Farao hɔ bio na kɔka kyerɛ no sɛ, ‘Awurade se, Ma me nkurɔfoɔ no ɛkwan na wɔnkɔsom me. ");
INSERT INTO twiasante_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Sɛ woampene so amma wɔankɔ a, mɛma mpɔtorɔ abɛhyɛ asase no so ma. ");
INSERT INTO twiasante_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Wɔbɛyɛ Asubɔnten Nil ma, na wɔabɛhyɛ mo afie ma ma, na wɔakɔ mo mpia mu, na afoforɔ akɔ mo mpa so. ");
INSERT INTO twiasante_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Mpɔtorɔ bɛhyɛ efie biara a ɛwɔ Misraim no mu ma. Wɔbɛhyɛ mo fononoo ne deɛ mode fɔtɔ asikyiresiam gu mu nyinaa ma ma. Na mpɔtorɔ no bɛbu afa mo so.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Awurade ka kyerɛɛ Mose sɛ, “Ka kyerɛ Aaron na ɔmfa poma no nkyerɛ nsubɔntene, nsuwa ne atadeɛ a ɛwɔ Misraim nyinaa so sɛdeɛ ɛbɛyɛ a, mpɔtorɔ bɛbu so wɔ ɔman no afanan nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaron yɛɛ saa maa mpɔtorɔ bɛhyɛɛ ɔman no mu nyinaa ma tɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Nanso, nkonyaayifoɔ no nso yɛɛ saa ara maa mpɔtorɔ baa asase no so. ");
INSERT INTO twiasante_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Afei, Farao ka kyerɛɛ Mose ne Aaron sɛ, “Monkɔsrɛ Awurade na ɔnyi mpɔtorɔ no mfiri asase yi so, na mɛma mo nkurɔfoɔ no ɛkwan na wɔakɔbɔ no afɔdeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose nso ka kyerɛɛ no sɛ, “Kyerɛ me ɛberɛ ko a wopɛ sɛ wɔkɔ. Me nso mɛbɔ ho mpaeɛ ama mpɔtorɔ no nyinaa awuwu wɔ baabiara wɔ ɛberɛ a wobɛhyɛ me no mu, na aka asubɔnten no mu mpɔtorɔ no nko ara.” ");
INSERT INTO twiasante_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Farao kaa sɛ, “Monyɛ no ɔkyena nko ara.” Mose buaa sɛ, “Mate, ɛbɛba mu sɛdeɛ woaka no na ama woahunu sɛ obiara nni hɔ sɛ Awurade, yɛn Onyankopɔn, no nko ara. ");
INSERT INTO twiasante_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Mpɔtorɔ no nyinaa bɛwuwu ama aka wɔn a wɔwɔ asubɔnten no mu no.” ");
INSERT INTO twiasante_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mose ne Aaron firii Farao anim kɔeɛ. Mose kɔsrɛɛ Awurade sɛ ɔnyi mponkyerɛne a ɔde wɔn abɛgu Farao so no. ");
INSERT INTO twiasante_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Awurade tiee Mose nkotosrɛ no. Mponkyerɛne wuwu hyɛɛ ɔman no mu ne afie mu ma tɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Wɔboaboaa mponkyerɛne a wɔawuwuo no ano akuo akɛseakɛseɛ maa ɔman no mu bɔn yie. ");
INSERT INTO twiasante_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Nanso, Farao hunuu sɛ mponkyerɛne no kɔ no, ɔsane pirim nʼakoma bio enti wamma nnipa no ankɔ sɛdeɛ Awurade aka ato hɔ no. ");
INSERT INTO twiasante_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Na Awurade ka kyerɛɛ Mose sɛ, “Ka kyerɛ Aaron na ɔmfa ne poma no mmɔ mfuturo na ɛbɛdane ntontom ahyɛ Misraim asase no so ma tɔ.” ");
INSERT INTO twiasante_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Enti, Mose ne Aaron yɛɛ deɛ Onyankopɔn hyɛɛ wɔn no maa ntontom bɛhyɛɛ ɔman mu no ne mu nnipa ne wɔn nyɛmmoa so ma tɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Nkonyaayifoɔ no pɛɛ sɛ wɔn nso de wɔn nyankomadeɛ yɛ saa ara, nanso wɔantumi. ");
INSERT INTO twiasante_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Nkonyaayifoɔ no kyerɛɛ Farao sɛ, “Yei deɛ, Onyankopɔn nsa wɔ mu.” Nanso, Farao pirim nʼakoma enti wantie wɔn sɛdeɛ Awurade aka ato hɔ no. ");
INSERT INTO twiasante_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Afei, Awurade ka kyerɛɛ Mose sɛ, “Sɔre anɔpatutuutu kɔhyia Farao na sɛ ɔrebɛdware asubɔnten no mu a, woaka akyerɛ no sɛ, ‘Awurade se: Ma me nkurɔfoɔ nkɔsom me. ");
INSERT INTO twiasante_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Na sɛ wantie a, mɛma nwansena agye Misraim afa. Mo afie mu ne asase no nyinaa bɛyɛ nwansena manyamanya. ");
INSERT INTO twiasante_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Na nsonsonoeɛ kɛseɛ bɛda ɛha ne Gosen asase a Israelfoɔ no te so no ntam, ɛfiri sɛ, nwansena biara renkɔ hɔ. Na ɛbɛma woahunu sɛ, me Awurade mewɔ tumi wɔ Misraim asase yi so. ");
INSERT INTO twiasante_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Na mɛma wo nkurɔfoɔ ho ada nso afiri me nkurɔfoɔ ho. Ɔkyena nko ara nsɛm a maka yi nyinaa bɛba mu.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Awurade yɛɛ deɛ ɔkaeɛ no, enti nwansena bɛbu faa ɔman no so maa ebi kɔhyɛɛ Farao ahemfie ne Misraim afie nyinaa mu ma tɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Farao hunuu saa no, ntɛm ara, ɔfrɛɛ Mose ne Aaron ka kyerɛɛ wɔn sɛ, “Ɛyɛ, monkɔbɔ afɔdeɛ mma mo Onyankopɔn, nanso mommɔ saa afɔdeɛ no wɔ ɔman yi ara mu. Monnkɔ ɛserɛ so.” ");
INSERT INTO twiasante_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Nanso Mose kaa sɛ, “Saa deɛ, ɛrenyɛ yie. Yɛn afɔdeɛ a yɛbɔ ma Awurade yɛn Onyankopɔn no yɛ Misraimfoɔ akyiwadeɛ, enti sɛ yɛbɔ saa afɔdeɛ no wɔ ha a, wɔbɛkum yɛn. ");
INSERT INTO twiasante_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ɛsɛ sɛ yɛtu nnansa ɛkwan kɔ ɛserɛ so, na yɛkɔbɔ afɔdeɛ ma Awurade, yɛn Onyankopɔn, sɛdeɛ wakyerɛ yɛn sɛ yɛnyɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farao kaa sɛ, “Ɛyɛ, mɛma mo ɛkwan akɔ ɛserɛ so akɔbɔ afɔdeɛ, na mmom, monnkɔ akyiri. Monka mo ho na monkɔkoto nsrɛ Awurade, mo Onyankopɔn mma me.” ");
INSERT INTO twiasante_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mose kaa sɛ, “Sɛ me firi ha pɛ a, mɛbɔ Awurade mpaeɛ na ɔkyena nwansena bebrebe no ase bɛtɔre wɔ wo, wo mpanimfoɔ ne wo nkurɔfoɔ mu. Nanso, merebɔ wo kɔkɔ sɛ, hwɛ na woanhyɛ bɔ sɛ wobɛma nnipa no akɔ na akyire yi, woasesa wʼadwene.” ");
INSERT INTO twiasante_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Enti, Mose firii Farao nkyɛn kɔsrɛɛ Awurade sɛ, ɔntɔre nwansena no nyinaa ase. ");
INSERT INTO twiasante_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Na Awurade yɛɛ Mose abisadeɛ no, tɔree nwansena no nyinaa ase. ");
INSERT INTO twiasante_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Nanso, Farao sane pirim nʼakoma, enti wamma nnipa no ankɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Awurade hyɛɛ Mose sɛ, “Sane kɔ Farao nkyɛn na kɔka kyerɛ no sɛ, Awurade a ɔyɛ Hebrifoɔ Onyankopɔn no pɛ sɛ wobɛma ne nkurɔfoɔ akɔbɔ afɔdeɛ ama no.” ");
INSERT INTO twiasante_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Sɛ wampene a, ");
INSERT INTO twiasante_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Awurade tumi mu ɔyaredɔm bɛba abɛkum mo apɔnkɔ, mo mfunumu, mo nyoma, mo anantwie, mo nnwan ne mo mpɔnkye nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Nanso, Awurade de nsonsonoeɛ bɛto Israelfoɔ mmoa ne Misraimfoɔ mmoa ntam. Israelfoɔ mmoa deɛ, ɔbaako mpo renwu. ");
INSERT INTO twiasante_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Awurade ahyɛ ɛberɛ pɔtee a ɔde ɔyaredɔm no bɛba. Ɔkaa sɛ adeɛ kye a, ɔbɛma ɔyaredɔm no aba asase no so. ");
INSERT INTO twiasante_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Na ɛbaa saa. Adeɛ kyeeɛ no, nyɛmmoa a wɔwɔ Misraim no hyɛɛ aseɛ wuwuiɛ, nanso Israelman mu deɛ, ayɛmmoa baako mpo koraa anyare. ");
INSERT INTO twiasante_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao somaa nnipa kɔɔ Israel kɔhwɛɛ sɛ ampa ara ɛhɔ nyɛmmoa no bi anwu koraa anaa. Nnipa no bɛbɔɔ Farao amanneɛ sɛ Israelfoɔ nyɛmmoa baako mpo koraa anwu nanso, nʼadwene ansesa. Wamma nnipa no ankɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Enti, Awurade ka kyerɛɛ Mose ne Aaron sɛ, “Monkɔsa nso mfiri fononoo mu, na Mose nto mpete ewiem wɔ Farao anim. ");
INSERT INTO twiasante_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Na ɛbɛbɔ apete Misraim asase so nyinaa sɛ mfuturo ama mpɔmpɔnini asisi nnipa ne mmoa a wɔwɔ ɔman no mu nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Enti, wɔkɔsaa nso firii fononoo mu de kɔɔ Farao anim, na ɔrehwɛ no, Mose to petee ewiem na ɛdanee mpɔmpɔnini sisii nnipa ne mmoa a wɔwɔ Misraim nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ɛbaa saa no, nkonyaayifoɔ no antumi ne Mose anni asie, ɛfiri sɛ, na mpɔmpɔnini no bi asisi wɔn nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Nanso, Farao pirim nʼakoma ara, enti wantie asɛm a Awurade nam Mose so ka kyerɛɛ no no. ");
INSERT INTO twiasante_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Awurade ka kyerɛɛ Mose sɛ, “Sɔre kɔ Farao nkyɛn anɔpahema na kɔka kyerɛ no sɛ, Hebrifoɔ Awurade Onyankopɔn no se, ma me nkurɔfoɔ nkɔsom me. ");
INSERT INTO twiasante_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Afei deɛ, mede ɔhaw na ɛbɛto mo so na ɛno na ɛbɛma wo ne wʼadwumayɛfoɔ ne Misraimfoɔ nyinaa ahunu sɛ, Onyankopɔn biara nni asase yi so ka me ho. ");
INSERT INTO twiasante_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Sɛ mepɛ a anka matɔre mo nyinaa ase, anka mede ɔyaredɔm bɛkum mo nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Nanso manyɛ no saa, ɛfiri sɛ, na mepɛ sɛ meda me tumi adi wɔ ewiase afanan nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Woayɛ kyɛnkyerɛnn wɔ me nkurɔfoɔ so a ɛno enti, womma wɔnkɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ɔkyena saa ɛberɛ yi ara mu, mɛma asukɔtweaa a ano yɛ den a ebi ntɔɔ Misraiman mu da atɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ntɛm! Monka mo anantwie a mode wɔn kɔ adidi no mmra efie. Ɛfiri sɛ, asukɔtweaa no bɛkum nnipa ne mmoa a wɔbɛka wiram no nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Misraimfoɔ a asɛm no bɔɔ wɔn hu no de wɔn anantwie ne wɔn asomfoɔ nyinaa baa efie. ");
INSERT INTO twiasante_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Na wɔn a wɔammu Awurade asɛm a ɔkaeɛ no gyaa wɔn anantwie ne wɔn asomfoɔ wɔ wiram maa asukɔtweaa no kaa wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Awurade ka kyerɛɛ Mose sɛ, “Tene wo nsa kyerɛ ɔsoro na ma ampariboɔ no ntɔ ngu nnipa, mmoa ne nnua a ɛwɔ Misraiman nyinaa so.” ");
INSERT INTO twiasante_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Enti, Mose de ne nsa kyerɛɛ ewiem maa Awurade maa ayerɛmo ne aprannaa dwidwaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Na ɛyɛ asɛm a ɛyɛ hu yie. Ɛfiri sɛ, ɛberɛ a wɔkyekyeree Misraim kɔsi saa ɛberɛ no, na aprannaa mpaapae saa da. ");
INSERT INTO twiasante_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Misraiman sɛee pasaa. Biribiara a ɛkaa wiram, sɛ ɛyɛ nnipa anaa mmoa no, wɔn nyinaa wuwuiɛ. Nnua nso bubuiɛ maa afudeɛ sɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Baabi a ampariboɔ no antɔ wɔ ɔman no mu no yɛ Gosen asase so a na Israelfoɔ no te hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Afei, Farao soma ma wɔkɔfrɛɛ Mose ne Aaron ka kyerɛɛ wɔn sɛ, “Afei deɛ, mahunu me mfomsoɔ. Awurade di bem na me ne me nkurɔfoɔ ayɛ bɔne ama atra so. ");
INSERT INTO twiasante_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Monsrɛ Awurade mma me, na ɔmma aprannaa ne ampariboɔ dodoɔ yi to ntwa na mɛma mo akɔ ntɛm so.” ");
INSERT INTO twiasante_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose kaa sɛ, “Sɛ mefiri kuropɔn yi mu ara pɛ a, mɛma me nsa so abɔ Awurade mpaeɛ na aprannaa no ne ampariboɔ no agyae. Yei bɛma mo ahunu sɛ Awurade na asase nyinaa hyɛ ne nsa. ");
INSERT INTO twiasante_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Nanso, menim yie sɛ wo ne wo mpanimfoɔ deɛ, yeinom nyinaa akyiri no, mobɛpirim mo akoma.” ");
INSERT INTO twiasante_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Aprannaa no sɛee wɔn ayuo ne wɔn asaawa a na ɛreso aba no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Nanso, atokoɔ ne aburoo deɛ, ansɛe, ɛfiri sɛ, na ɛmfifiriɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Enti Mose firii Farao anim wɔ kuro no mu maa ne nsa so kyerɛɛ Awurade maa aprannaa no ne asukɔtweaa no ne osuo no gyaee tɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Farao ne ne mpanimfoɔ hunuu sɛ biribiara ayɛ yie wɔ hɔ no, wɔkɔɔ so pirim wɔn akoma yɛɛ bɔne de buu ɛbɔ a wɔhyɛɛ Awurade no so. ");
INSERT INTO twiasante_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Enti, Farao amma nkurɔfoɔ no ankɔ sɛdeɛ Awurade hyɛɛ ho nkɔm kyerɛɛ Mose no. ");
INSERT INTO twiasante_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Awurade ka kyerɛɛ Mose sɛ, “Sane kɔ Farao nkyɛn na kɔbisa no deɛ mahyɛ sɛ ɔnyɛ mma wo no. Nanso, mapirim ɔne ne mpanimfoɔ nyinaa akoma sɛdeɛ ɛbɛyɛ a, mɛtumi ayɛ anwanwadeɛ bebree akyerɛ wɔn ama wɔahunu me tumi. ");
INSERT INTO twiasante_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Na ɛnam so ma woatumi aka anwanwadeɛ a mayɛ wɔ Misraim asase so no akyerɛ wo mma ne wo mmanananom. Ka sɛdeɛ memaa Misraimfoɔ no yɛɛ wɔn adeɛ sɛ nkwaseafoɔ wɔ mʼanim no ne sɛdeɛ mema wɔhunuu sɛ mene Awurade no kyerɛ wɔn.” ");
INSERT INTO twiasante_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Enti, Mose ne Aaron kɔhunuu Farao ka kyerɛɛ no sɛ, “Awurade a ɔyɛ Hebrifoɔ Onyankopɔn se memmisa wo sɛ, ‘Nna dodoɔ sɛn na wopɛ sɛ wode bu me animtia? Ma me nkurɔfoɔ nkɔ na wɔnkɔsom me. ");
INSERT INTO twiasante_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Na sɛ woamma wɔn ankɔ a, ɔkyena nko ara mɛma ntutummɛ aba wʼasase yi so. ");
INSERT INTO twiasante_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Wɔbɛkata asase no ani nyinaa. Na wɔbɛsɛe biribiara a ɛkaeɛ a asukɔtweaa a ɛtɔeɛ no ansɛe no no nyinaa a wiram nnua nyinaa ka ho. ");
INSERT INTO twiasante_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mmoa no bɛhyɛ wʼahemfie hɔ, wo mpanimfoɔ afie mu ne Misraimfoɔ afie nyinaa ma tɔ. Ɛbɛyɛ ɔhaw a, ɛfiri ɛberɛ a mo agyanom bɛtenaa asase yi so de bɛsi ɛnnɛ no, ebi nsii saa da.’ ” Na Mose firii Farao anim kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Afei, mpanimfoɔ a wɔwɔ Farao asɛnniiɛ no bɛbisaa no sɛ, “Nkɔsi da bɛn na wobɛma saa ɔbarima yi afa yɛn nnommum? Wonhunuu sɛ Misraim nyinaa adane amamfo? Ma nnipa no ɛkwan na wɔnkɔ nkɔsom Awurade wɔn Onyankopɔn!” ");
INSERT INTO twiasante_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Enti, wɔsane de Mose ne Aaron baa Farao anim bio bɛbisaa Farao ɛkwan. Farao kaa sɛ, “Ɛyɛ, monkɔsom Awurade, mo Onyankopɔn no. Na ɛhefoɔ na mo ne wɔn bɛkɔ?” ");
INSERT INTO twiasante_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose buaa Farao sɛ, “Yɛde mmɔfra ne mpanin, yɛn mmammarima, yɛn mmammaa, yɛn nnwan ne yɛn anantwie na ɛbɛkɔ. Yɛde yɛn agyapadeɛ nyinaa na ɛbɛtu saa ɛkwan no, ɛfiri sɛ, ɛsɛ sɛ yɛn nyinaa kɔ Awurade afahyɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farao de abufuo buaa sɛ, “Sɛ mɛma mode mmɔfra nketewa yi kɔ a, ɛnneɛ Awurade ankasa nka mo ho. Mahunu sɛ mowɔ adwemmɔne. ");
INSERT INTO twiasante_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ɛnsɛ sɛ ɛba saa. Mo mmarima no, monkɔsom Awurade, ɛfiri sɛ, ɛno na mobisaa me.” Farao pamoo wɔn firii nʼahemfie hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Awurade ka kyerɛɛ Mose sɛ, “Tene wo nsa wɔ Misraim so na ntutummɛ mmɛkata asase no nyinaa so, na wɔnni biribiara a asukɔtweaa no ansɛe no no.” ");
INSERT INTO twiasante_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Enti Mose maa ne poma so kyerɛɛ Misraim asase so maa Awurade bɔɔ mframa bi firii apueeɛ fam awia ne anadwo. Adeɛ kyeeɛ no, na apueeɛ mframa no de ntutummɛ no abɛgu asase no so nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ntutummɛ no kataa Misraim asase no so mmaa nyinaa. Misraim abakɔsɛm kyerɛ sɛ, ntutummɛ mmaa ɔman no mu saa da na ebi nso remma saa bio. ");
INSERT INTO twiasante_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Mmoa no kataa asase ani nyinaa ma wɔsii owia ani enti wɔmaa esum duruu asase no so. Wɔwee biribiara a asukɔtweaa no ansɛe no no; biribiara a ɛyɛ ahahammono anka; sɛ ɛyɛ dua anaa afifideɛ a ɛwɔ ɔman no mu baabiara no. ");
INSERT INTO twiasante_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ntɛm pa ara Farao tuu abɔfoɔ kɔfrɛɛ Mose ne Aaron ka kyerɛɛ wɔn sɛ, “Mayɛ bɔne atia Awurade, mo Onyankopɔn no, ne mo nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Me nkotosrɛ a ɛdi akyire nie; momfa saa bɔne no nkyɛ me na monsrɛ Awurade mo Onyankopɔn sɛ ɔnyi owuo yi mfiri yɛn so.” ");
INSERT INTO twiasante_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Enti, Mose firii Farao anim kɔsrɛɛ Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Awurade bɔɔ atɔeɛ fam mframa denden bi ma ɛpiaa ntutummɛ no nyinaa kɔguu Ɛpo Kɔkɔɔ no mu, a anka ɔbaako pɛ koraa wɔ Misraim asase no so. ");
INSERT INTO twiasante_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Nanso, Awurade pirim Farao akoma enti wamma Israelfoɔ no ankɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Awurade ka kyerɛɛ Mose sɛ, “Tene wo nsa kyerɛ ɔsoro ma esum kabii mmɛduru Misraim asase so.” ");
INSERT INTO twiasante_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Enti, Mose tenee ne nsa hwɛɛ soro maa esum kabii bɛduruu Misraim asase no so nnansa. ");
INSERT INTO twiasante_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Esum no duruu saa no, na obiara ntumi ntu ne nan, nanso Israelfoɔ no deɛ, na deɛ wɔte hɔ yɛ hann. ");
INSERT INTO twiasante_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Farao frɛɛ Mose ka kyerɛɛ no sɛ, “Kɔ na kɔsom Awurade. Wobɛtumi de wo mma aka wo ho akɔ; nanso wo nnwan ne wʼanantwie no deɛ, ma wɔnka ha.” ");
INSERT INTO twiasante_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Nanso, Mose buaa sɛ, “Dabi, ɛsɛ sɛ yɛde yɛn nnwan ne yɛn anantwie kɔ na yɛde wɔn mu bi bɔ ɔhyeɛ afɔdeɛ ma Awurade yɛn Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Aboa tɔte koraa yɛrennya wɔ ha; ɛsɛ sɛ yɛbɔ Awurade, yɛn Onyankopɔn no afɔdeɛ. Yɛnnim deɛ ɔbɛpɛ gye sɛ yɛduru hɔ.” ");
INSERT INTO twiasante_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Nanso, Awurade pirim Farao akoma enti wamma wɔn ankɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao teateaa Mose sɛ, “Firi ha kɔ ntɛm. Mma menhunu wo ha bio. Ɛda a wobɛba ha bio no, wobɛwu.” ");
INSERT INTO twiasante_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mose buaa sɛ, “Ɛyɛ, merenhunu wo bio.” ");
INSERT INTO twiasante_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Afei, Awurade ka kyerɛɛ Mose sɛ, “Mɛma ɔhaw a ɛtwa toɔ aba Farao ne nʼasase so. Na ɛno akyiri no, ɔbɛma mo akɔ. Nokorɛm, ne ho bɛpere no sɛ mobɛfiri ne ho ama ɔno ara apamo mo afiri ɔman no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Monka nkyerɛ Israelfoɔ mmarima ne mmaa nyinaa sɛ, wɔmmisa wɔn amannifoɔ Misraimfoɔ no na wɔmma wɔn sikakɔkɔɔ ne dwetɛ adwinneɛ.” ");
INSERT INTO twiasante_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Awurade maa Misraimfoɔ no hunuu Israelfoɔ no mmɔbɔ, na Mose nso yɛɛ onipa kɛseɛ a na Farao mpanimfoɔ ne Misraimfoɔ no bu no yie wɔ ɔman no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mose bɔɔ Farao amaneɛ sɛ, “Awurade se menka nkyerɛ wo sɛ, ‘Anadwo nnɔndumienu mɛtwam wɔ Misraim asase so. ");
INSERT INTO twiasante_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Na Misraim fie biara mu ɔbabarima panin bɛwu. Ɛfiri Farao babarima panin so, ne dehyeɛ a ɔbɛdi nʼadeɛ, ne ɔsomfoɔ mu ɔsomfoɔ kumaa koraa ba panin ne ne nyɛmmoa abakan nyinaa bɛwuwu. ");
INSERT INTO twiasante_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Na owuo no ho agyaadwotwa bɛduru Misraim asase so nyinaa. Awerɛhoɔ a ɛte saa mmaa Misraim asase so da, na ebi nso remma da bio. ");
INSERT INTO twiasante_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Na Israelfoɔ mu deɛ, biribiara bɛyɛ dwoodwoo na ɔkraman mpo rempɔ.’ Na ɛbɛma woahunu sɛ, Awurade de nsonsonoeɛ ato Misraimfoɔ ne Israelfoɔ ntam! ");
INSERT INTO twiasante_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Wo mpanimfoɔ yi nyinaa bɛtu mmirika, adi mʼakyiri, akoto asrɛ sɛ, ‘Yɛpa wo kyɛw, firi ha ntɛm na kɔfa wo nkurɔfoɔ nyinaa ka wo ho kɔ.’ Sɛ ɛba saa a ansa na mɛkɔ!” Mose wiee kasa no, ɔde abufuhyeɛ firii ahemfie hɔ kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Na Awurade aka akyerɛ Mose sɛ, “Asɛm a wobɛka no, Farao rentie. Na ɛno so na mɛgyina ayɛ anwanwadeɛ de ada me tumi adi.” ");
INSERT INTO twiasante_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ɛwom sɛ Mose ne Aaron yɛɛ saa anwanwadeɛ no nyinaa wɔ Farao anim nanso Awurade pirim nʼakoma sɛdeɛ ɔremma nnipa no mfiri asase no so nkɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ɛberɛ a na Mose ne Aaron da so wɔ Misraim asase so no, Awurade ka kyerɛɛ wɔn sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ɛfiri ɛnnɛ rekorɔ, bosome yi bɛyɛ bosome a ɛdi ɛkan wɔ Yudafoɔ asranna so. ");
INSERT INTO twiasante_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ka kyerɛ Israelfoɔ nyinaa sɛ, saa bosome yi ɛda a ɛtɔ so edu no, ɛsɛ sɛ ɔbarima biara pɛ odwammaa baako de ma nʼabusua. Ɛsɛ sɛ efie biara nya odwammaa no baako. ");
INSERT INTO twiasante_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Sɛ abusua bi mu nnipa sua a wɔrentumi nwe odwammaa no a, wɔtumi ne abusua bi a ɛbɛn wɔn wɔ mpasua no so a wɔn nso sua kyɛ odwammaa no. Aboa no kyɛ wɔ saa ɛkwan no so no gyina abusua no kɛseɛ ne ɛnam dodoɔ a wɔbɛtumi awe so. ");
INSERT INTO twiasante_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ɛsɛ sɛ aboa no yɛ deɛ wadi afe. Ɛsɛ sɛ ɔyɛ odwan anaa abirekyie a ɔnnii dɛm. ");
INSERT INTO twiasante_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Monhwɛ saa mmoa a moayiyi wɔn yi yie nkɔsi ɔbosome a ɛdii ɛkan no ɛda a ɛtɔ so dunan no anwummerɛ. Afei Israel asafo nyinaa nkunkum wɔn nnwammaa no dasuo mu. ");
INSERT INTO twiasante_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Wɔmfa wɔn mogya nsra efie biara aponnwa ho. Odwammaa a wɔbɛwe no wɔ fie hɔ no mogya na wɔmfa nyɛ saa ahyɛdeɛ yi. ");
INSERT INTO twiasante_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Anadwo, obiara bɛwe aboa no a wɔatoto no nam no bi. Wɔmfa burodo a ɛnkaeɛ ne awɔnwono nni. ");
INSERT INTO twiasante_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Wɔnnnoa ɛnam no na wɔnnwe no mono nso, na mmom, wɔntoto aboa mu no nyinaa, a ne ti ne nan ne nʼayamdeɛ nyinaa ka ho. ");
INSERT INTO twiasante_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Sɛ moantumi anwe ne nyinaa anadwo no a, deɛ ɛbɛka no, sɛ adeɛ kye so a, monnwe na mmom monhye no. ");
INSERT INTO twiasante_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Sɛdeɛ monwe ɛnam no nie: monwe wɔ ɛberɛ a mo ntadeɛ a mode tu ɛkwan hyehyɛ mo. Monsiesie mo ho mma ɛkwan tenten twa. Monhyɛ mo asopatere na momfa mo mpoma nkurakura. Monwe no ɔherɛ so. Saa adeyɛ yi, wɔbɛfrɛ no Awurade Twam Afahyɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Na mɛtwam afa Misraim asase so anadwo yi na mmammarima a wɔyɛ mmakan ne mmoa mmakan a wɔwɔ Misraim asase so nyinaa, mɛkum wɔn, na mabu anyame a wɔwɔ Misraim nyinaa atɛn, ɛfiri sɛ, mene Awurade! ");
INSERT INTO twiasante_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Mogya a mode bɛyɛ aponnwa no ho no bɛyɛ agyinahyɛdeɛ enti, sɛ mehunu mogya no a, mɛtwam akɔ, na sɛ merekum Misraim mmakan a, merenkum mo deɛ bi. ");
INSERT INTO twiasante_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Yei yɛ ɛda a ɛsɛ sɛ mokaeɛ. Afe biara, ɛfiri awontoatoasoɔ kɔsi awontoatoasoɔ ɛsɛ sɛ mohyɛ ɛfa no sɛ afahyɛ sononko ma Awurade. Yei yɛ mmara a ɛbɛtena hɔ ɛda biara. ");
INSERT INTO twiasante_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Nnanson no mu, monni burodo a wɔmfaa mmɔreka mfraeɛ nko ara. Afahyɛ no ɛda a ɛdi ɛkan no, monyiyi mmɔreka biara mfiri mo afie mu. Obiara a saa ɛberɛ yi mu ɔbɛbu saa afahyɛ yi mmara yi so no, wɔbɛtwa no asuo afiri Israelman mu. ");
INSERT INTO twiasante_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Afahyɛ no ɛda a ɛdi ɛkan ne ne nnanson soɔ no, nnipa no nyinaa bɛdi ɛda no sɛ ɛda a wɔayi asi hɔ ama nhyiamu kronkron. Na nna no mu, aduanenoa akyiri no, obiara nnyɛ adwuma foforɔ biara. ");
INSERT INTO twiasante_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Sɛ modi Apiti Afahyɛ yi a, ɛbɛma mo akae daa sɛ, saa ɛda no na meyii mo firii Misraim asase so. Enti, ɛsɛ sɛ afe biara, modi saa dapɔnna yi firi awo ntoatoasoɔ so kɔsi awo ntoatoasoɔ so. ");
INSERT INTO twiasante_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ɔbosome a ɛdi ɛkan no ɛda a ɛtɔ so dunan no anwummerɛ kɔsi nʼadaduonu ɛda baako so no, burodo a mmɔreka mfra mu nko ara na monni. ");
INSERT INTO twiasante_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Saa nnanson no mu, ɛnsɛ sɛ wɔhunu mmɔreka kakra bi koraa wɔ mo afie mu. Enti, obiara a ɔbɛdi aduane a mmɔreka wɔ mu no, wɔbɛyi no afiri Israel asafo kuo no mu. Saa mmara yi ka amamfrafoɔ a wɔne mo te ne wɔn a wɔwoo wɔn wɔ asase yi so nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Mesane meti mu bio sɛ, saa nna no mu monnni biribiara a wɔde mmɔreka afra mu; monni burodo a mmɔreka mfra mu.” ");
INSERT INTO twiasante_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Afei, Mose frɛɛ Israel mpanimfoɔ nyinaa ka kyerɛɛ wɔn sɛ, “Monkɔkyekyere odwammaa anaa abirekyie ba mma abusua biara, na monkum no sɛ Twam Afahyɛ aboa. ");
INSERT INTO twiasante_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Montwa odwan no mogya ngu kyɛnsee bi mu. Momfa hisope mmɔ mogya no mu na momfa mpete aponnwatifi ne aponnwa mmienu a aka no ho sɛdeɛ mogya no bɛda ho. Mowie a, mo mu biara mmfiri nkɔ abɔntene saa anadwo no. ");
INSERT INTO twiasante_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Awurade bɛtwam afa asase yi so akunkum Misraimfoɔ. Na sɛ ɔhunu sɛ mogya wɔ aponnwatifi no ne aponnwa mmienu no ho a, ɔbɛtwa saa efie no ho akɔ a ɔremma ɔsɛefoɔ no nwura hɔ nkunkum mo mmakan. ");
INSERT INTO twiasante_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Na monkae sɛ yei yɛ mmara a ɛwɔ hɔ daa ma mo ne mo asefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Na sɛ moba asase a Awurade de bɛma mo sɛdeɛ ɔhyɛɛ mo ho bɔ no so a, mobɛkɔ so adi afahyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na sɛ mo mma bisa mo sɛ, ‘Yeinom nyinaa ase ne sɛn; saa afahyɛ yi fa ɛdeɛn ho a, ");
INSERT INTO twiasante_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","mobɛbua wɔn sɛ, ɛyɛ Twam Afahyɛ afɔdeɛ ma Awurade. Ɔtwaa Israelfoɔ afie ho wɔ Misraim. Ɛwom sɛ ɔkunkumm Misraimfoɔ deɛ, nanso ɔgyaa yɛn mmusua.’ ” Ɛberɛ a Mose kasa wieeɛ no, nnipa no nyinaa koto sɔreeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Na Israelfoɔ no dii Mose ne Aaron ahyɛdeɛ no so. ");
INSERT INTO twiasante_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ɛda no ara anadwo dasuo mu Awurade kunkumm mmarimaa a wɔyɛ abakan a wɔwɔ Misraim asase so nyinaa, ɛfiri Farao babarima panin so kɔsi odeduani babarima panin ne anantwie nso mmakan nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Afei, Farao ne ne mpanimfoɔ ne nnipa a wɔwɔ Misraim nyinaa sɔree anadwo no. Misraiman no nyinaa twaa agyaadwoɔ, ɛfiri sɛ, efie biara nni hɔ a onipa anwu wɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Enti, Farao frɛɛ Mose ne Aaron anadwo no ka kyerɛɛ wɔn sɛ, “Mesrɛ mo, mo nyinaa montu mfiri ha. Monkɔsom Awurade sɛdeɛ mokaeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Momfa mo nnwan ne mo anantwie na monkɔ. Nanso monhyira me ansa na moakɔ.” ");
INSERT INTO twiasante_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misraimfoɔ no nyinaa ani beree Israelfoɔ no so pampam wɔn sɛ wɔmfiri asase no so ntɛm, ɛfiri sɛ, wɔkaa sɛ, “Yɛbɛwuwu.” ");
INSERT INTO twiasante_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Israelfoɔ no faa wɔn mmɔre a wɔafɔtɔ a mmɔreka mfra mu, na wɔde wɔn ntadeɛ kyekyeree wɔn mmɔrefɔtɔ nnaka de sisii wɔn mmati so. ");
INSERT INTO twiasante_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Na Israelfoɔ no asrɛsrɛ dwetɛ ne sikakɔkɔɔ adwinneɛ ne ntadeɛ afiri Misraimfoɔ no nkyɛn sɛdeɛ Mose kaa sɛ wɔnyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Awurade maa Misraimfoɔ no hunuu Israelfoɔ no mmɔbɔ enti wɔmaa wɔn wɔn abisadeɛ nyinaa. Ɛnam saa yɛ so maa Israelfoɔ no twee Misraimfoɔ ahonyadeɛ nyinaa kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Anadwo no ara, Israelfoɔ no siim firii Rameses kɔɔ Sukot. Na wɔn dodoɔ yɛ nnipa mpem ahansia a wɔnam fam, a mmaa ne mmɔfra de wɔankan wɔn anka ho. ");
INSERT INTO twiasante_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Nnipa ahodoɔ pii bi a wɔnyɛ Israelfoɔ kaa wɔn ho kɔeɛ. Wɔde wɔn nnwan ne wɔn anantwie nyinaa kaa wɔn ho. ");
INSERT INTO twiasante_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Wɔduruu baabi a wɔpɛ sɛ wɔdidi no, wɔde mmɔre a wɔamfa mmɔreka amfra a wɔde kɔeɛ no bi too burodo diiɛ. Na mmɔreka nni mu, ɛfiri sɛ, Misraimfoɔ no pamoo wɔn. Ɛno enti wɔannya mu ɛkwan anyɛ aduane a wɔbɛdi wɔ ɛkwan so. ");
INSERT INTO twiasante_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israelfoɔ no tenaa Misraim mfeɛ ahanan ne aduasa. ");
INSERT INTO twiasante_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Na ɛda a wɔdii mfeɛ ahanan ne aduasa no pɛ na Awurade nkurɔfoɔ nyinaa firii asase no so. ");
INSERT INTO twiasante_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Saa anadwo no ne ɛberɛ a Awurade yi too hɔ de gyee ne nkurɔfoɔ firii Misraim asase so. Enti, saa anadwo korɔ no ara na Israelfoɔ no yi de too hɔ sɛ ɛda a Onyankopɔn gyee wɔn no afirinhyia ɛda. ");
INSERT INTO twiasante_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Afei, Awurade ka kyerɛɛ Mose ne Aaron sɛ, “Twam Afahyɛ no ho mmara ni: “Ahɔhoɔ biara nnwe odwammaa no ɛnam no bi. ");
INSERT INTO twiasante_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Nanso, ɔsomfoɔ biara a wɔtee sika tɔɔ no no, sɛ wɔatwa no twetia deɛ a, ɔtumi we bi. ");
INSERT INTO twiasante_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ɔpaani anaa ɔhɔhoɔ biara nnwe bi. ");
INSERT INTO twiasante_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Ɛsɛ sɛ wɔwe Twam Afahyɛ aboa biara wɔ efie baako mu. Ɛsɛ sɛ wɔwe ɛnam no wɔ fie. Ɛnsɛ sɛ wɔwe ɛnam no fa biara wɔ abɔntene. Ɛnsɛ sɛ mobɔ dompe mu. ");
INSERT INTO twiasante_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ɛsɛ sɛ Israelfoɔ nyinaa di saa nkaeɛda yi berɛ korɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Ahɔhoɔ a mo ne wɔn te no nso, sɛ wɔpɛ sɛ wɔdi Twam Afahyɛ no bi a, ɛsɛ sɛ mmarima a wɔwɔ wɔn mu no nyinaa twa twetia ansa na wɔaba ne mo abɛdi. Na sɛ ɛyɛ saa a, wɔbɛyɛ deɛ wɔwoo wɔn too mu mu. ");
INSERT INTO twiasante_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Saa mmara yi ka Israelfoɔ ne ahɔhoɔ a wɔne mo te no nso.” ");
INSERT INTO twiasante_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Enti, Israelfoɔ no nyinaa dii Awurade mmara no so sɛdeɛ ɔhyɛɛ Mose ne Aaron no. ");
INSERT INTO twiasante_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ɛda no ara na Awurade yii Israelfoɔ no firii Misraim asase so. ");
INSERT INTO twiasante_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Te Israelfoɔ mmammarima ne aboa biara abakan ho ma me; wɔn nyinaa yɛ me dea.” ");
INSERT INTO twiasante_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Na Mose ka kyerɛɛ nnipa no sɛ, “Ɛnnɛ yɛ ɛda a ɛsɛ sɛ mokae ɛda biara—ɛda a motu firii Misraim asase a na moyɛ nkoa wɔ so no. Awurade ayɛ anwanwadeɛ akɛseɛ bebree akyerɛ mo. Enti, monkae sɛ, sɛ afe duru na moredi afahyɛ yi a, mommfa mmɔreka mfra mo aduane; na mommfa bi nkɔ mo afie nso mu koraa. ");
INSERT INTO twiasante_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Afe biara mu Abib bosome awieeɛ (bɛyɛ Ɔbenem awieeɛ), monkae saa atutena yi. ");
INSERT INTO twiasante_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Awurade de mo baa Kanaanfoɔ, Hetifoɔ, Amorifoɔ, Hewifoɔ ne Yebusifoɔ nsase a ɛwoɔ ne nufosuo sen so a ɔkaa ho ntam sɛ ɔde bɛma mo no so. ");
INSERT INTO twiasante_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mobɛdi burodo a mmɔreka nni mu nko ara nnanson. Na ɛda a ɛtɔ so nson no, monto ɛpono kɛseɛ mma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ɛnsɛ sɛ obiara kora mmɔreka wɔ ne fie anaa mo asase no ahyeɛ so baabiara. ");
INSERT INTO twiasante_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ɛduru afirinhyia na moredi nna yi a, monkyerɛ mo mma deɛ enti a moredi saa afahyɛ no. Ɛyɛ afahyɛ a mode bɛkae deɛ Awurade yɛ maa mo ɛberɛ a motu firii Misraim asase so no. ");
INSERT INTO twiasante_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Saa afe biara mu nnawɔtwe afahyɛ yi, ɛnyɛ nsɛnkyerɛnneɛ te sɛ agyiraeɛhyɛdeɛ a wɔde abɔ mo nsa ho anaa mo moma so sɛ nkae adeɛ. Momma Awurade mmara ntena mo anom, ɛfiri sɛ tumi kɛseɛ na ɔde yii mo firii Misraim. ");
INSERT INTO twiasante_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Afe biara, ɛrekɔ Abib (bɛyɛ Ɔbɛnem) awieeɛ no, monni afahyɛ yi. ");
INSERT INTO twiasante_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Sɛ Awurade de mo ba asase a ɔhyɛɛ mo agyanom ho bɔ tete no a Kanaanfoɔ te so seesei no so a, monkae sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","mo mmammarima a wɔyɛ mmakan nyinaa ne nyɛmmoa mmakan a wɔyɛ mmarima no nyinaa yɛ Awurade dea. Enti momfa mma no. ");
INSERT INTO twiasante_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Motumi de odwan ba anaa abirekyie ba kɔsesa afunumu ba abakan. Na sɛ woyɛ wʼadwene sɛ woremfa afunumu no nni nsesa a, ɛsɛ sɛ wobu afunumu no kɔn mu kum no. Nanso mo mmammarima abakan deɛ, ɛsɛ sɛ motɔ wɔn ti. ");
INSERT INTO twiasante_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Na sɛ daakye bi mo mma bisa mo sɛ, ‘Yeinom nyinaa ase ne sɛn a, monka nkyerɛ wɔn sɛ, Awurade nam anwanwadeɛ akɛseɛ a ɔyɛeɛ so na ɔyii yɛn firii nkoasom mu wɔ Misraim. ");
INSERT INTO twiasante_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Na Farao mpɛ sɛ ɔma yɛn ɛkwan ma yɛkɔ enti, Awurade kumm mmammarima ne mmoanini a wɔyɛ mmakan a wɔwɔ Misraim asase so nyinaa. Ɛno enti na yɛde mmammarima a wɔyɛ mmakan rema Awurade yi, nanso nnipa mmammarima mmakan no deɛ, wɔtɔ wɔn ti.’ ");
INSERT INTO twiasante_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Meti mu meka bio sɛ, saa afahyɛ yi bɛda mo nso sɛ moyɛ Onyankopɔn mma te sɛ deɛ ɔde nʼagyiraeɛhyɛdeɛ abɔ mo moma so sɛ ɔdedea. Ɛyɛ nkaedeɛ a ɛkyerɛ sɛ Awurade nam ne tumi kɛseɛ no so na ɔde yii yɛn firii Misraim.” ");
INSERT INTO twiasante_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Akyire no, Farao maa nnipa no kɔeɛ. Ɛwom sɛ na ɛsɛ sɛ wɔfa Filistifoɔ asase a ɛkwan no da mu tee kɔsi Bɔhyɛ Asase no so, nanso Onyankopɔn ma wɔfaa ɛkwan foforɔ so. Deɛ enti a Onyankopɔn ma wɔfaa ɛkwan foforɔ so no ne sɛ, na ɔsusu sɛ, ɛwom sɛ wɔkura wɔn akodeɛ deɛ, nanso sɛ wɔkɔ na wɔkɔhyia akodie bi a, wɔn aba mu bɛbu ama wɔasane aba Misraim. ");
INSERT INTO twiasante_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Enti, Onyankopɔn dii wɔn anim de wɔn faa ɛserɛ so kɔntɔnkyekwan a ɛrekɔ Ɛpo Kɔkɔɔ no ho no so. ");
INSERT INTO twiasante_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mose rekɔ no, ɔfaa Yosef nnompe de kaa ne ho kɔeɛ, ɛfiri sɛ, na Yosef ama Israel mma aka Onyankopɔn ntam sɛ, “Sɛ ɔreyi wɔn afiri Misraim a, wɔde ne nnompe bɛkɔ bi, ɛfiri sɛ, na ɔnim sɛ Onyankopɔn bɛyi wɔn afiri Misraim asase so.” ");
INSERT INTO twiasante_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Wɔfiri Sukot no, wɔkɔkyeree sraban wɔ Etam ɛserɛ no ano. ");
INSERT INTO twiasante_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Awurade de omununkum kyerɛɛ wɔn ɛkwan awia na ɔde ogya nso kyerɛɛ wɔn ɛkwan anadwo. Enti na wɔtumi tu wɔn kwan no awia ne anadwo nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ɛberɛ biara na wɔhunu omununkum ne ogya no. ");
INSERT INTO twiasante_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ka kyerɛ nnipa no na wɔmmane mfa Pihahirot a ɛwɔ Migdol ne ɛpo no ntam na ɛne Baal-Sefon di nhwɛanimu no. Sɛ wɔduru hɔ a, wɔnsi wɔn ntomadan wɔ mpoano hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Sɛ wɔyɛ saa a, Farao bɛsusu sɛ, ‘Saa Israelfoɔ no aka ɛserɛ no ne ɛpo no ntam.’ ");
INSERT INTO twiasante_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Na mɛsane mapirim Farao akoma bio ama wataa mo. Mayɛ saa nhyehyɛeɛ yi sɛdeɛ ɛbɛma manya animuonyam ne anidie wɔ Farao ne nʼasraafoɔ mu na ama Misraimfoɔ no nso ahunu sɛ, mene Awurade no.” Enti, wɔsii ntomadan wɔ baabi a wɔkyerɛɛ wɔn hɔ no. ");
INSERT INTO twiasante_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Nnansa akyi a Misraimhene no tee sɛ Israelfoɔ no abɔ wɔn tirim sɛ wɔrensane mma Misraim bio na mmom kɔ ara na wɔrekɔ no, Farao ne nʼahokafoɔ akoma sɔree bio. Wɔbisaa sɛ, “Ɛdeɛn na yɛayɛ yi a yɛama nkoa yi ɛkwan ama wɔkɔ?” ");
INSERT INTO twiasante_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Enti, Farao faa ne teaseɛnam dii nʼasraafoɔ no anim taa wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ɔmaa Misraim apɔnkɔsotefoɔ dɔm a wɔn dodoɔ yɛ ahansia ne apɔnkɔ foforɔ bi a asraafoɔ tete wɔn so sram wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Farao taa Israelfoɔ no so, ɛfiri sɛ, na wɔde Misraimfoɔ agyapadeɛ bebree kɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Farao de nʼapɔnkɔdɔm nyinaa taa Israelfoɔ no so bɛtoo wɔn sɛ wɔasisi wɔn ntomadan wɔ Pihahirot mpoano wɔ Baal-Sefon anim. ");
INSERT INTO twiasante_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ɛberɛ a Misraim asraafoɔ no rebɛn Israelfoɔ no, Israelfoɔ no hunuu wɔn firi akyiri sɛ wɔde mmirika reba enti wɔn akoma tuiɛ, na wɔsu frɛɛ Awurade sɛ ɔmmoa wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ɛmaa wɔn ani beree Mose so bisaa no sɛ, “Wode yɛn aba ɛserɛ yi so sɛ yɛmmɛwuwu wɔ ha, ɛfiri sɛ, adamena nni Misraim a sɛ yɛwuwu a wɔbɛsie yɛn wɔ mu? Adɛn enti na womaa yɛtu firii Misraim? ");
INSERT INTO twiasante_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ɛberɛ a yɛwɔ nkoasom mu no, yɛanka ankyerɛ wo sɛ ma yɛmpɛ yɛn baabi ntena? Yɛkaeɛ sɛ yɛpɛ sɛ yɛbɛhyɛ nkoasom ase wɔ Misraim sene sɛ yɛbɛwuwu agu ɛserɛ so ha.” ");
INSERT INTO twiasante_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Nanso, Mose ka kyerɛɛ nnipa no sɛ, “Monnsuro. Monnyina pintinn na monhwɛ biribi. Na mobɛhunu anwanwakwan a Awurade nam so bɛgye mo afiri atamfoɔ nsam ɛnnɛ. Misraimfoɔ a mohunu wɔn seesei yi, morenhunu wɔn bio. ");
INSERT INTO twiasante_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Awurade bɛko ama mo a monha mo ho koraa!” ");
INSERT INTO twiasante_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Afei, Awurade ka kyerɛɛ Mose sɛ, “Adɛn enti na wosu frɛ me? Ka kyerɛ Israelfoɔ no na wɔnkɔ wɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Fa wo poma no. Fa kyerɛ nsuo no so na ɛpo no mu bɛpae ama ɛkwan ada mu ma Israelfoɔ no afa asase wesee so. ");
INSERT INTO twiasante_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mɛpirim Misraimfoɔ no akoma ama wɔaka mo so na di a mɛdi Farao ne ne dɔm so bɛma mo ahunu mʼanimuonyam. ");
INSERT INTO twiasante_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Na Misraimfoɔ nyinaa bɛhunu sɛ, mene Awurade.” ");
INSERT INTO twiasante_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Afei, Onyankopɔn ɔbɔfoɔ a ɔdi Israelfoɔ anim no twee ne ho bɛdii Israelfoɔ no akyi. Na omununkum dum nso bɛdii Israelfoɔ no akyi. ");
INSERT INTO twiasante_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ɛbɛtwaa Israelfoɔ no ne Misraimfoɔ no ntam. Na anadwo no, ɛdanee ogya maa esum tɔɔ Misraimfoɔ no so maa ne hann no kyerɛɛ Israelfoɔ no ɛkwan. Enti Misraimfoɔ no anhunu Israelfoɔ no akyiri kwan. ");
INSERT INTO twiasante_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mose tenee ne nsa wɔ ɛpo no so, na anadwo no nyinaa Awurade de apueeɛ mframa denden maa ɛpo no sanee nʼakyiri ma asase no yɛɛ wesee. ");
INSERT INTO twiasante_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Enti Israelfoɔ no faa ɛpo ɛkwan a emu wesee no so. Na nsuo no yɛɛ afasuo wɔ benkum ne nifa maa wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Afei, Misraimfoɔ no nso ne Farao apɔnkɔ, nteaseɛnam ne apɔnkɔsotefoɔ tii wɔn kɔduruu ɛpo no mfimfini. ");
INSERT INTO twiasante_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Na anɔpahema no, Awurade de ogya ne mununkudum no too Misraim dɔm no so maa wɔn ho yeraa wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Wɔn nteaseɛnam no nan tutuiɛ enti na wɔntumi nkɔ bio. Enti Misraimfoɔ no kaa sɛ, “Momma yɛnnwane mfiri Israelfoɔ anim, ɛfiri sɛ, Awurade reko ma wɔn na yɛn deɛ, ɔreko tia yɛn.” ");
INSERT INTO twiasante_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Awurade ka kyerɛɛ Mose sɛ, “Tene wo nsa wɔ ɛpo no so, na nsuo no nsane mmra Misraimfoɔ ne wɔn nteaseɛnam ne apɔnkɔsotefoɔ no so.” ");
INSERT INTO twiasante_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mose yɛɛ saa, na adeɛ kyee anɔpa no, ɛpo no sane nʼakyi tenee sɛdeɛ na ɛteɛ. Misraimfoɔ no pɛɛ sɛ wɔdwane, nanso Awurade maa nsuo no faa wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nsuo no kataa ɛkwan no ne nteaseɛnam ne apɔnkɔsotefoɔ no nyinaa so. Farao asraafoɔ dodoɔ a wɔfaa ɛpo no mu taa Israelfoɔ no nso, anka ɔbaako koraa. ");
INSERT INTO twiasante_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Israelfoɔ no nante faa asase wesee a nsuo yɛ ɔfasuo wɔ benkum ne nifa no so. ");
INSERT INTO twiasante_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Saa ɛda no Awurade gyee Israelfoɔ firii Misraimfoɔ nsa mu. Na Israelfoɔ no hunuu Misraimfoɔ no sɛ wɔawuwu deda mpoano. ");
INSERT INTO twiasante_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ɛberɛ a Israelfoɔ hunuu tumi a Awurade ada no adie de atia Misraimfoɔ no, wɔsuroo Awurade, na wɔgyee Awurade ne nʼakoa Mose diiɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Afei, Mose ne Israelfoɔ too saa dwom yi de kamfoo Awurade: “Mɛto dwom mama Awurade, ɛfiri sɛ, wadi nkonim animuonyam mu; Wato ɔpɔnkɔ ne ne sotefoɔ no agu ɛpo mu. ");
INSERT INTO twiasante_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Awurade yɛ mʼahoɔden, me dwom ne me nkwagyeɛ. Ɔyɛ me Onyankopɔn, na mɛkamfo no. Ɔyɛ mʼagya Onyankopɔn—Mɛma no so. ");
INSERT INTO twiasante_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Awurade yɛ ɔkofoɔ; Aane, ne din ne Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Farao nteaseɛnam ne nʼakodɔm, wato wɔn agu Ama wɔamem Ɛpo Kɔkɔɔ mu. Misraim akofoɔ atitire awuwu asorɔkye ase. ");
INSERT INTO twiasante_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Nsuo akata wɔn so. Wɔmemem subunu mu sɛ ɛboɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Wo nsa nifa, Ao, Awurade, tumi ne animuonyam ahyɛ no ma. Wo nsa nifa, Ao, Awurade, atete atamfoɔ mu pasaa. ");
INSERT INTO twiasante_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“Wo tumi kɛseɛ no mu, wotuu wɔn a wɔtia wo no guiɛ. Womaa wʼabufuhyeɛ bɛhyee wɔn sɛ ogya hye ɛserɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Wogu ahome a, nsuo mu pae. Ɛgyinaa sɛ afasuo ma ɛpo taa ɛfa ne ɛfa. ");
INSERT INTO twiasante_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ɔtamfoɔ de ahomasoɔ kaeɛ sɛ, ‘Mɛtaa wɔn, mɛto wɔn, asɛe wɔn. Na makyɛ afodeɛ no mu. Mɛtwe mʼakofena wɔ wɔn so atwitwa wɔn asinasini.’ ");
INSERT INTO twiasante_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nanso, Onyankopɔn bɔɔ ne mframa maa ɛpo kataa wɔn so. Wɔmemem sɛ sumpii wɔ subunu no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Hwan na ɔte sɛ Awurade wɔ anyame mu? Hwan na ɔte sɛ wo? Ɔberempɔn wɔ kronkronyɛ mu; deɛ yɛde surokronkron ma nʼanimuonyam, na ɔyɛ anwanwadeɛyɛfoɔ Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“Wotenee wo nsa nifa na asase menee wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Woadi nnipa a wogyee wɔn no anim, wʼayamyɛ mu. Wonam anwanwakwan so adi wɔn anim de wɔn aba wʼasase kronkron no so. ");
INSERT INTO twiasante_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Amanaman tee asɛm a ɛsiiɛ ma wɔn ho popoeɛ. Ehu aka nnipa a wɔwɔ Filistia. ");
INSERT INTO twiasante_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edom mpanimfoɔ ho adwiri wɔn. Atumfoɔ a wɔwɔ Moab ho woso. Na nnipa a wɔwɔ Kanaan nyinaa abɔ huboa. ");
INSERT INTO twiasante_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ehu ne suro afa wɔn so. Ao, Awurade, wo tumi enti, wɔremma yɛn so! Wo nkurɔfoɔ a wotɔɔ wɔn bɛtwa wɔn ho asomdwoeɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Wode wɔn bɛba abɛdua wɔn wɔ wo bepɔ so, wo ara wo efie hɔ, Awurade— Kronkronbea a woasiesie sɛ wo tenabea no. ");
INSERT INTO twiasante_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“Awurade bɛdi ɔhene akɔsi daa.” ");
INSERT INTO twiasante_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Farao apɔnkɔ, nʼapɔnkɔkafoɔ ne ne nteaseɛnam pɛɛ sɛ wɔfa ɛpo no mu; nanso, Awurade buu nsuo afasuo no guu wɔn so ɛberɛ a na Israelfoɔ no nam mu sɛ asase wesee no. ");
INSERT INTO twiasante_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ɛhɔ na Odiyifoɔ baa Miriam a ɔyɛ Aaron nuabaa faa twene bi bɔ de dii mmaa no anim ma wɔsaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ɛnna Miriam too saa dwom yi: “Monto dwom mma Awurade na wadi nkonim animuonyam mu. Wama ɔpɔnkɔ ne ne sotefoɔ amem ɛpo ase.” ");
INSERT INTO twiasante_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Afei, Mose dii Israelfoɔ no anim ne wɔn tu firii Ɛpo Kɔkɔɔ no ho kɔɔ Sur ɛserɛ so. Na wɔnantee ɛserɛ no so nnansa a wɔannya nsuo annom. ");
INSERT INTO twiasante_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Wɔduruu Mara no, wɔantumi annom ɛhɔ nsuo, ɛfiri sɛ, na ɛyɛ nwono. Ɛno enti na wɔfrɛ hɔ Mara no; aseɛ ne: Nwononwono. ");
INSERT INTO twiasante_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Afei, nnipa no danee wɔn ani tiaa Mose sɛ, “Osukɔm nku yɛn anaa?” ");
INSERT INTO twiasante_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mose srɛɛ Awurade sɛ ɔmmoa wɔn, na Awurade kyerɛɛ no dua bi. Na ɔtoo dubaa no too nsuo no mu, na ɛyɛɛ dɛ maa wɔtumi nomeeɛ. Mara hɔ na Awurade hyɛɛ saa mmara yi maa wɔn sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“Sɛ mobɛtie Awurade mo Onyankopɔn nne, na moayɛ ɔsetie, ayɛ ade tenenee deɛ a, yadeɛ a mema ɛbɔɔ Misraimfoɔ no, meremma bi mmɔ mo, ɛfiri sɛ, mene Awurade a mesa mo nyarewa.” ");
INSERT INTO twiasante_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Wɔbaa Elim a ɛhɔ na na nsubura dumienu ne mmɛdua aduɔson wɔ enti, wɔsisii wɔn ntomadan, tenaa nsubura no ho. ");
INSERT INTO twiasante_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Afei, wɔtu firii Elim baa Sin ɛserɛ so a ɛda Elim ne Bepɔ Sinai ntam. Wɔtu firii Misraim no, bosome a ɛtɔ so mmienu dadu nnanum so na wɔduruu hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Wɔduruu hɔ no nso, nnipa no kasa tiaa Mose ne Aaron sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“Ao! Sɛ yɛwɔ Misraim bio na anka Awurade rekunkum yɛn wɔ hɔ a, anka yɛpɛ. Na yɛnya nnuane bebree di wɔ hɔ. Nanso, mode yɛn abɛgu ɛserɛ so ha ama ɛkɔm rekum yɛn.” ");
INSERT INTO twiasante_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ɛnna Awurade ka kyerɛɛ Mose sɛ, “Merebɛtɔ aduane firi soro abɛgu asase so ama wɔn. Obiara bɛtumi akɔboaboa dodoɔ biara a ɔpɛ ano ama deɛ ɔbɛdi no ɛda koro. Mede yei bɛsɔ wɔn ahwɛ sɛ wɔbɛdi mʼahyɛdeɛ so anaasɛ wɔrenni so. ");
INSERT INTO twiasante_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ka kyerɛ wɔn na nnawɔtwe biara mu ɛda a ɛtɔ so nsia no, wɔmmoaboa aduane no ano sɛdeɛ daa wɔboaboa no no, mmɔho mmienu.” ");
INSERT INTO twiasante_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Enti, Mose ne Aaron frɛɛ Israelfoɔ no nyinaa ne wɔn hyiaeɛ ka kyerɛɛ wɔn sɛ, “Anwummerɛ yi, mobɛhunu sɛ Awurade na ɔyii mo firii Misraim asase so. ");
INSERT INTO twiasante_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Sɛ ɛduru anɔpa a, mobɛhunu nʼanimuonyanneɛ bebree; ɛfiri sɛ, wate mo anwiinwii a monwiinwii tia no no. Na yɛn ne hwan a monnwiinwii tia yɛn? ");
INSERT INTO twiasante_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Anwummerɛ yi, Awurade bɛma mo ɛnam awe, na wama mo aduane anɔpa. Ɛfiri sɛ, wate mo anwiinwii a monwiinwii tia no no. Moannwiinwii antia yɛn, na monwiinwii tiaa Awurade.” ");
INSERT INTO twiasante_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Na Mose ka kyerɛɛ Aaron sɛ, “Ka kyerɛ Israelfoɔ no nyinaa sɛ wɔmmra Awurade anim na wɔmmɛtie wɔn anwiinwii no ho mmuaeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Enti, Aaron frɛɛ wɔn boaa ano, na prɛko pɛ, wɔmaa wɔn ani so kyerɛɛ baabi a omununkum a ɛrekyerɛ wɔn ɛkwan no wɔ no, Awurade firii mu daa nʼanimuonyam kɛseɛ no adi. ");
INSERT INTO twiasante_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Mate wɔn anwiinwii no, ka kyerɛ wɔn sɛ, ‘Anwummerɛ, mobɛnya ɛnam awe na anɔpa nso mobɛnya aduane pii adi na mobɛhunu sɛ mene Awurade, mo Onyankopɔn, no.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Anwummerɛ no, nnomaa pii bɛbuu so wɔ wɔn atenaeɛ hɔ na anɔpa no, obosuo tɔ guu ɛserɛ no so ma ɛyɛɛ fɔkyee; ");
INSERT INTO twiasante_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","obosuo no tuiɛ no akyire no, biribi te sɛ nsenseneeɛ bi a ɛte sɛ nkyenkyeneeɛ bɛguu asase no so. ");
INSERT INTO twiasante_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israelfoɔ no hunuiɛ no, wɔbisabisaa wɔn ho wɔn ho sɛ, “Ɛdeɛbɛn nie?” Na Mose buaa wɔn sɛ, “Ɛyɛ aduane a Awurade de ama mo sɛ monni no. ");
INSERT INTO twiasante_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Awurade aka sɛ, ‘Obiara mmoaboa dodoɔ biara a ɛbɛso ɔne ne fiefoɔ die ano.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Enti, Israelfoɔ no firii adi kɔboaboaa aduane no bi ano. Ebi faa pii ɛnna ebi faa kakraa bi. ");
INSERT INTO twiasante_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Wɔhwiee deɛ wɔaboaboa ano no nyinaa guu susukoraa mu no, na ɛdɔɔso sɛ obiara bɛnya bi. Wɔn a wɔnyaa pii no, ebi anka, ɛnna wɔn a wɔnyaa kakra bi no nso, ɛsoo wɔn. Efie biara nyaa ne so ne ne deɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mose ka kyerɛɛ wɔn sɛ, “Mommma adeɛ nkye so.” ");
INSERT INTO twiasante_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Nanso, ebinom yɛɛ asoɔden maa adeɛ kyee so. Adeɛ kyee so no, na adɔre nsaama ma ɛbɔn enti Mose bo fuu wɔn yie. ");
INSERT INTO twiasante_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Afei, na wɔkɔtase aduane no anɔpa biara, na wɔtase dodoɔ biara a, ɛso efie biara. Na awia bɔɔ dendeenden guu so no, aduane no nyinaa naneeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ɛda a ɛtɔ so nsia no, wɔtasee sɛdeɛ wɔtase no daa no mmɔho mmienu. Wɔtasee susukoraa nsia, nanso daa na wɔtase susukoraa mmiɛnsa. Mpanimfoɔ a wɔtuatua nnipa no ano no bɛbisaa Mose deɛ enti a aba saa. ");
INSERT INTO twiasante_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mose buaa wɔn sɛ, “Ɛfiri sɛ, Awurade aka ato hɔ sɛ, ‘Ɔkyena yɛ homeda. Ɛyɛ homeda kronkron ma Awurade a ɛnsɛ sɛ yɛyɛ yɛn nnwuma biara. Enti, monnoa dodoɔ biara a mopɛ ɛnnɛ, na deɛ ɛbɛka no, monnya ma adeɛ nkye so.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Na adeɛ kyee so no, na ɛyɛ a nsaama biara nni mu na ɛmmɔn nso. ");
INSERT INTO twiasante_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose kaa sɛ, “Ɛnnɛ, mo aduane nie, ɛfiri sɛ, ɛnnɛ yɛ Awurade homeda enti aduane biara rentɔ ngu asase so. ");
INSERT INTO twiasante_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Momfa nna nsia mmoaboa aduane ano, ɛfiri sɛ, ɛda a ɛtɔ so nson no yɛ homeda enti morennya aduane biara saa ɛda no.” ");
INSERT INTO twiasante_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Homeda no, nnipa no bi firii adi sɛ wɔrekɔpɛ aduane no bi, nanso na ebi nni hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Awurade bisaa Mose sɛ, “Saa nnipa yi bɛyɛ asoɔden akɔsi da bɛn? ");
INSERT INTO twiasante_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Wɔnhunu sɛ nna nsia so no, memaa wɔn mmɔho mmienu sɛdeɛ ɛbɛso wɔn nnanu? Awurade se momfa ɛda a ɛtɔ so nson no sɛ homeda; montena mo ntomadan mu. Mommfiri adi nkɔtase aduane mfiri asase so.” ");
INSERT INTO twiasante_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Enti, ɛda a ɛtɔ so nson no, nnipa no homee. ");
INSERT INTO twiasante_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israelfoɔ no too aduane no edin sɛ, Mana aseɛ ne “Ɛyɛ ɛdeɛn?” Ɛyɛ fitaa sɛ wisa aba na ɛyɛ dɛ te sɛ taterɛ a ɛwoɔ wɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mose kaa asɛm a Awurade ka kyerɛɛ no sɛ ɔnka nkyerɛ wɔn sɛ wɔmfa aduane no susukoraa mmiɛnsa na wɔmfa nkɔsie wɔn adekorabea afebɔɔ sɛdeɛ ɛbɛyɛ a, nkyirimma bɛhunu aduane a Awurade de maa wɔn dii wɔ ɛserɛ so ɛberɛ a ɔyii wɔn firii Misraim no. ");
INSERT INTO twiasante_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mose ka kyerɛɛ Aaron sɛ ɔmfa kyɛnsee na ɔmfa mana lita mmiɛnsa ngu mu na ɔmfa nsie kronkronbea bi mma nkyirimma. ");
INSERT INTO twiasante_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aaron yɛɛ sɛdeɛ Awurade kyerɛɛ Mose sɛ ɔnyɛ no na ɔkɔkoraa no wɔ Apam Adaka no mu wɔ kronkronbea hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Enti, Israelfoɔ dii mana yi mfeɛ aduanan kɔsii sɛ wɔduruu Kanaan asase so a ɛhɔ deɛ, na afuomduane wɔ no. ");
INSERT INTO twiasante_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Omer na na wɔde susu mana no. Omer yɛ lita mmiɛnsa. ");
INSERT INTO twiasante_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Afei, Awurade hyɛeɛ maa Israelfoɔ no firii Sin ɛserɛ no so kokɔɔ nkuro nkuro so, kɔduruu Refidim. Wɔduruu hɔ no, na nsuo a wɔbɛnom biara nni hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ɛha nso, nnipa no nwiinwii bio tiaa Mose sɛ, “Ma yɛn nsuo nnom!” Mose ka kyerɛɛ wɔn sɛ, “Monyɛ dinn! Adɛn enti na mo ne me regye akyinnyeɛ? Adɛn enti na mopɛ sɛ mosɔ Awurade hwɛ?” ");
INSERT INTO twiasante_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Na osukɔm a ade wɔn no enti, wɔteateaam sɛ, “Adɛn enti na woyii yɛn firii Misraim? Adɛn enti na wode yɛn baa ha? Yɛn, yɛn mma ne yɛn anantwie nyinaa bɛwuwu!” ");
INSERT INTO twiasante_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mose su frɛɛ Awurade sɛ, “Ɛdeɛn na menyɛ saa nkurɔfoɔ yi? Wɔpɛ sɛ wɔsi me aboɔ.” ");
INSERT INTO twiasante_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Awurade ka kyerɛɛ Mose sɛ, “Fa Israelfoɔ mpanimfoɔ no bi ka wo ho na fa poma a wode bɔɔ Nil mu no na di wɔn anim fa wɔn kɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mɛhyia wo wɔ ɔbotan a ɛwɔ bepɔ Horeb ho. Sɛ woduru hɔ a, fa wo poma no bɔ ɔbotan no mu sɛdeɛ wode bɔɔ Nil mu no na nsuo bɛfiri mu aba ama obiara anya bi anom amee.” Mose yɛɛ deɛ Awurade kaeɛ no wɔ Israel mpanimfoɔ no anim maa nsuo tue firii ɔbotan no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Enti, Mose too beaeɛ hɔ edin Masa a aseɛ ne Sɔhwɛbea ne Meriba a aseɛ ne Akyinnyegyebea ɛfiri sɛ, ɛhɔ na Israelfoɔ ne Mose gyee akyinnyeɛ, sɔɔ Onyankopɔn hwɛeɛ, bisaa sɛ, “Awurade bɛhwɛ yɛn so anaasɛ ɔrenhwɛ yɛn so?” ");
INSERT INTO twiasante_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Afei, akofoɔ a wɔfiri Amalek bɛto hyɛɛ Israelfoɔ no so wɔ Refidim ne wɔn koeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mose ka kyerɛɛ Yosua sɛ, “Yi asraafoɔ ma yɛn na yɛne Amalekfoɔ nkɔko. Ɔkyena mɛgyina bepɔ no apampam a Onyankopɔn poma no kura me.” ");
INSERT INTO twiasante_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Enti, Yosua ne ne dɔm kɔtoaa Amalekfoɔ akodɔm no ne wɔn koeɛ. Saa ɛberɛ no ara, Mose ne Aaron ne Hur foro kɔɔ bepɔ no apampam pɛɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mmerɛ dodoɔ a Mose kura poma no mu kyerɛ soro na Israelfoɔ no redi nkonim na sɛ ɔbrɛ poma no ase a, na Amalekfoɔ no nso redi Israelfoɔ no so. ");
INSERT INTO twiasante_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mose brɛeɛ a na ɔntumi mma poma no so bio enti Aaron ne Hur piree ɛboɔ bi too hɔ ma ɔtenaa so. Wɔgyinagyinaa Mose benkum ne nifa memaa ne nsa mmienu no so kɔsii sɛ owia kɔtɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ɛbaa saa no, Yosua ne ne dɔm dii Amalekfoɔ no so, kunkumm wɔn wɔ akofena ano. ");
INSERT INTO twiasante_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Afei, Awurade ka kyerɛɛ Mose sɛ, “Twerɛ yei ma ɛnna hɔ afebɔɔ ma wɔnkae daa na ka kyerɛ Yosua sɛ, mɛtɔre Amalekfoɔ nyinaa ase.” ");
INSERT INTO twiasante_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mose sii afɔrebukyia hɔ na ɔtoo no edin Awurade Nissi a aseɛ ne Awurade ne mʼakofrankaa. ");
INSERT INTO twiasante_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Mose kaa sɛ, “Ɛfiri sɛ wɔapagya wɔn nsa akyerɛ Awurade ahennwa enti, Awurade ne Amalekfoɔ bɛdi ako afiri awo ntoatoasoɔ so akɔsi awoɔ ntoatoasoɔ so.” ");
INSERT INTO twiasante_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ankyɛre biara na Mose ase, Midian ɔsɔfoɔ Yetro, tee anwanwadeɛ a Onyankopɔn ayɛ ama ne nkurɔfoɔ Israelfoɔ ne Mose, ne sɛdeɛ Awurade ayi wɔn afiri Misraim asase so no. ");
INSERT INTO twiasante_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mose de ne yere Sipora kɔeɛ no, nʼase Yetro gyee no ");
INSERT INTO twiasante_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","a na ne mmammarima baanu ka ne ho. Mose too ne babarima a na ɔyɛ nʼabakan no edin Gersom a ɔkyerɛ aseɛ sɛ, “Mabɛyɛ ɔhɔhoɔ ananafoɔ asase so.” ");
INSERT INTO twiasante_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Na ne babarima a ɔtɔ so mmienu no nso, ɔtoo ne edin Elieser a ɔkyerɛ aseɛ sɛ “Mʼagyanom Onyankopɔn no yɛ me ɔboafoɔ. Ɔgyee me firii Farao akofena ano.” ");
INSERT INTO twiasante_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yetro kɔsraa Mose. Ɔde Mose yere ne ne mmammarima baanu no kaa ne ho. Wɔduruiɛ no, na Mose ne nnipa no abɔ atenaeɛ wɔ Onyankopɔn bepɔ no ho. ");
INSERT INTO twiasante_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Wɔka kyerɛɛ Mose sɛ, “Wʼase Yetro reba abɛsra wo. Wo yere ne wo mmammarima baanu no ka ne ho.” ");
INSERT INTO twiasante_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mose sɔre kɔhyiaa nʼase. Ɔkotoo no anidie mu gyee no fɛ so. Wɔbisabisaa wɔn ho wɔn ho sɛdeɛ wɔn apɔ mu te. Afei, wɔkɔɔ Mose ntomadan no mu kɔtoaa wɔn amanneɛdie so. ");
INSERT INTO twiasante_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mose kaa nsɛm a asisie nyinaa kyerɛɛ nʼase no. Ɔkaa deɛ Awurade ayɛ atia Farao ne Misraimfoɔ a ɔnam so agye Israelfoɔ, ayi wɔn afiri Misraim, asane ayi wɔn afiri ɔhaw ne abɛbrɛsɛ mu no nso kyerɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetro tee deɛ Awurade ayɛ ama Israel, ne titire no, sɛdeɛ ɔyii wɔn firii Misraim no, nʼani gyee yie. ");
INSERT INTO twiasante_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetro kaa sɛ, “Nhyira nka Awurade sɛ wagye mo afiri Misraimfoɔ ne Farao nsam, na wagye ɔman Israel nso. ");
INSERT INTO twiasante_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Afei, mahunu sɛ Awurade yɛ kɛse sene onyame biara, ɛfiri sɛ, wagye ne nkurɔfoɔ afiri Misraimfoɔ ahantanfoɔ ne atirimuɔdenfoɔ nsam.” ");
INSERT INTO twiasante_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Yetro de ɔhyeɛ afɔrebɔdeɛ baeɛ na ɔbɔɔ afɔdeɛ maa Onyankopɔn. Akyire no, Aaron ne Israel mpanimfoɔ no baa Yetro nkyɛn. Wɔn nyinaa too nsa dii afɔreduane no wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Adeɛ kyeeɛ no, Mose tenaa ase firii anɔpa kɔsii anwummerɛ tiee nsɛmpɔ a asisi wɔ nnipa no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mose ase no hunuu brɛ a ɔrebrɛ nnipa no ho no, ɔbisaa no sɛ, “Adɛn enti na wopɛ sɛ wo nko ara wodi dwuma kɛseɛ yi a enti nnipa gyina wo so saa ara firi anɔpa kɔsi anwummerɛ yi?” ");
INSERT INTO twiasante_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose buaa sɛ, “Nnipa no de akasakasa bi a asisi wɔn ntam bɛtoo mʼanim sɛ memmisa Onyankopɔn akwankyerɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Sɛ akyinnyeɛ bi ba wɔn ntam a, wɔba ma mesiesie. Mekyerɛ wɔn Onyankopɔn mmara ne nʼapɛdeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Nʼase no kaa sɛ, “Deɛ woreyɛ no nyɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Worekum wo ho na sɛ wowu a, nnipa yi bɛyɛ dɛn? Mose, adwuma yi so dodo sɛ wo nko ara wobɛyɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Tie fo a merebɛtu wo yi na Onyankopɔn bɛhyira wo. Kɔ so ara si nnipa no anan wɔ Onyankopɔn anim na fa wɔn haw to nʼanim. ");
INSERT INTO twiasante_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kyerɛ wɔn Onyankopɔn akwan a wɔmfa so ntena ase. ");
INSERT INTO twiasante_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Na hwehwɛ nnipa bi a wɔyɛ nyamesurofoɔ na wɔyɛ nokwafoɔ a wɔmpɛ adanmudegyeɛ, na wɔn mu baako biara nyɛ nnipa apem so ɔtemmufoɔ. Ɛsɛ sɛ saa onipa no nya atemmufoɔ edu hyɛ nʼase na wɔn mu baako biara ahwɛ nnipa ɔha so. Na wɔn ase no, wɔbɛyi atemmufoɔ baanu a wɔbɛhwɛ nnipa aduonum so, na wɔn nso, atemmufoɔ baanum bɛhyɛ wɔn mu biara ase na wɔatu nnipa edu fo. ");
INSERT INTO twiasante_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ma saa nnipa yi nni wɔn ho ni na wɔnni nokorɛ daa. Asɛm biara a ɛho hia anaa ɛkyere adwene no, wɔmfa mmra wʼanim. Wɔn ankasa nhwɛ nka nsɛm nketenkete a ɛbɛba wɔn anim. Sɛ wofa saa ɛkwan yi so a, adwuma no bɛyɛ mmerɛ ama wo, ɛfiri sɛ, woakyekyɛ nnwuma no ama wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Sɛ wotie afotuo no na Onyankopɔn nso pene so a, wobɛtumi agyina asɛm biara ano na asomdwoeɛ aba.” ");
INSERT INTO twiasante_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose tiee nʼase afotuo no dii so pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ɔyiyii nnipa pa a wɔwɔ Israelman mu nyinaa de wɔn yɛɛ atemmufoɔ—apem apem, ɔha ɔha, aduonum aduonum ne edu edu. ");
INSERT INTO twiasante_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Na wɔbuu ɔman no atɛn berɛ nyinaa mu. Wɔde nsɛm akɛseɛ no maa Mose na wɔn nso dii nsɛm nketewa no. ");
INSERT INTO twiasante_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Akyire no, Mose gyaa nʼase ɛkwan ma ɔkɔɔ ne kurom. ");
INSERT INTO twiasante_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Anadwo a Israelfoɔ no tu firii Misraim no, nʼabosome mmiɛnsa so na wɔde kɔduruu Sinai ɛserɛ so. ");
INSERT INTO twiasante_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Wɔtu firii Refidim no, wɔbɛduruu Sinai Bepɔ ase bɔɔ atenaseɛ wɔ hɔ. Mose foro kɔɔ bepɔ no so kɔhyiaa Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mose kɔɔ Onyankopɔn nkyɛn wɔ bepɔ no so na Awurade frɛɛ no firii bepɔ no so kaa sɛ, “Ka saa nsɛm yi kyerɛ Yakob asefoɔ Israelman sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Moahunu deɛ meyɛɛ Misraimfoɔ no ne ɛkwan a menam so de mo baa me nkyɛn te sɛ deɛ na mote ɔkɔdeɛ ntaban so no. ");
INSERT INTO twiasante_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Sɛ mobɛtie me, na moadi mʼahyɛdeɛ so a, mobɛyɛ me nnwankuo ketewa wɔ asase so aman nyinaa mu, ɛfiri sɛ, asase nyinaa yɛ me dea. ");
INSERT INTO twiasante_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Na mobɛyɛ asɔfoɔ ahemman a ɛyɛ ɔman kronkron ama Onyankopɔn.’ Saa nsɛm yi na ka kyerɛ Israelfoɔ no.” ");
INSERT INTO twiasante_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mose siane firii bepɔ no so baeɛ no, ɔfrɛɛ mpanimfoɔ a wɔtuatua nnipa no ano nyinaa na ɔkaa asɛm a Awurade ka kyerɛɛ no no kyerɛɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Wɔtee asɛm no, wɔn nyinaa bɔ gyee so sɛ, “Yɛbɛyɛ biribiara a Awurade aka sɛ yɛnyɛ no nyinaa.” Enti, Mose kɔkaa nsɛm a nnipa no aka no kyerɛɛ Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Awurade ka kyerɛɛ Mose sɛ, “Merebɛba wo nkyɛn sɛ omununkum sɛdeɛ ɛbɛyɛ na me ne wo kasa a, nnipa no bɛte me nne na ɛnam so ama wɔagye wo adi daa. ");
INSERT INTO twiasante_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","“Siane kɔ nnipa no nkyɛn na kɔhwɛ sɛ wɔasiesie wɔn ho rehwɛ me ɛkwan. Fa ɛnnɛ ne ɔkyena te wɔn ho. Ma wɔnsi wɔn nneɛma nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Na ɔkyena akyiri mɛsiane aba Sinai Bepɔ no so a ɔmanfoɔ nyinaa rehwɛ ɛkwan. ");
INSERT INTO twiasante_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Twitwa ahyeɛ sɛdeɛ nnipa no rentra na ka kyerɛ wɔn sɛ, ‘Monhwɛ yie. Mommforo nkɔ bepɔ no atifi na monnkɔ nʼahyeɛ no nso so; obiara a ɔbɛbu saa mmara yi so no, ɔbɛwu. ");
INSERT INTO twiasante_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Sɛ ɔyɛ onipa anaa a, obiara nsɔ ne mu. Na mmom, wɔbɛsi no aboɔ anaasɛ wɔbɛtoto agyan awowɔ no ama wawu.’ Montwe mo ho mfiri bepɔ no ho koraa kɔsi sɛ totorobɛnto bi bɛhyɛne ntwemu so; sɛ ɛba saa a, momforo nkɔ bepɔ no so!” ");
INSERT INTO twiasante_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mose siane firii bepɔ no so kɔɔ nnipa no nkyɛn kɔtee wɔn ho ma wɔsii wɔn nneɛma nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ɔka kyerɛɛ wɔn sɛ, “Monsiesie mo ho, na aka nnansa na Onyankopɔn aba, enti obiara nnkɔ ɔbaa ho.” ");
INSERT INTO twiasante_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Nnansa so anɔpa pɛpɛɛpɛ, aprannaa a ano yɛ den bobɔɔ mu, ma ayerɛmo pepaeɛ, ma omununkum kabii bi siane firii bepɔ no so. Totorobɛnto bi hyɛnee ntwemu so ma nnipa a wɔwɔ hɔ no nyinaa ho popoeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mose dii nnipa no anim firi wɔn atenaeɛ hɔ sɛ wɔrekɔhyia Onyankopɔn. Wɔn nyinaa kɔboaa wɔn ho ano wɔ bepɔ no ase. ");
INSERT INTO twiasante_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Wisie kumɔnn kataa Sinai Bepɔ no so, ɛfiri sɛ, Awurade siane baa so sɛ ogya. Wisie buaa ewiem nyinaa te sɛ deɛ ɛfiri fononoo mu, na asasewosoɔ wosoo bepɔ no dendeenden. ");
INSERT INTO twiasante_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Totorobɛnto no hyɛnee dendeenden pa ara no, Mose kasaeɛ na Onyankopɔn nso de nne kɛseɛ buaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Enti, Awurade baa Sinai Bepɔ no atifi, na ɔfrɛɛ Mose maa ɔforo kɔɔ ne nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Nanso, Awurade ka kyerɛɛ Mose sɛ, “Sane wʼakyi kɔ nnipa no nkyɛn na kɔbɔ wɔn kɔkɔ sɛ wɔnntra ahyeɛ no. Wɔnnyɛ wɔn adwene nso sɛ wɔreforo aba soro ha abɛhwɛ Awurade. Wɔn a wɔbɛyɛ saa no bɛwuwu. ");
INSERT INTO twiasante_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Asɔfoɔ a wɔwɔ wɔn nnwuma so no mpo nnwira wɔn ho, anyɛ saa a, Awurade bɛsɛe wɔn.” ");
INSERT INTO twiasante_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose nso buaa Awurade sɛ, “Nnipa no deɛ, wɔremforo mma bepɔ no atifi, ɛfiri sɛ, woabɔ wɔn kɔkɔ dada. Woka kyerɛɛ me sɛ mentwitwa ahyeɛ mfa bepɔ no ho na menka nkyerɛ nnipa no sɛ, obiara nnkɔ hɔ, ɛfiri sɛ, ɛhɔ yɛ Onyankopɔn dea.” ");
INSERT INTO twiasante_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Awurade ka kyerɛɛ Mose sɛ, “Siane kɔ fam na kɔfa Aaron bra. Mma asɔfoɔ no ne nnipa no ntra ahyeɛ no sɛ wɔreba ha. Wɔyɛ saa a, mɛsɛe wɔn.” ");
INSERT INTO twiasante_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Enti, Mose siane kɔɔ bepɔ no ase kɔkaa asɛm a Onyankopɔn aka akyerɛ no no kyerɛɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Afei, Onyankopɔn kaa nsɛm yi kyerɛɛ wɔn: ");
INSERT INTO twiasante_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Mene Awurade, mo Onyankopɔn a meyii mo firii nkoasom mu wɔ Misraim no. ");
INSERT INTO twiasante_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Monnsom onyame foforɔ biara nnka me ho. ");
INSERT INTO twiasante_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Monnyɛ ohoni anaa biribiara a ɛsɛ adeɛ a ɛwɔ ewiem, anaa deɛ ɛwɔ asase so, anaa deɛ ɛwɔ nsuo mu, anaa deɛ ɛwɔ asase ase. ");
INSERT INTO twiasante_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Monnkoto ohoni biara nsom no ɛkwan biara so, na me, Awurade mo Onyankopɔn, meyɛ ninkunfoɔ. Na me ne onyame foforɔ bi nkyɛ mo dɔ a modɔ me no. Na sɛ nnipa bi bɔne a wayɛ enti metwe wɔn aso a, metwe wɔn aso kɔsi wɔn awontoatoasoɔ a wɔtan me no nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Na medɔ awoɔ ntoatoasoɔ mpem a wɔdɔ me na wɔdi mʼahyɛdeɛ so. ");
INSERT INTO twiasante_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Mommmɔ Awurade Onyankopɔn din basabasa. Sɛ moyɛ saa a, ɔbɛbu mo fɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Monkae homeda na monni no sɛ ɛda kronkron. ");
INSERT INTO twiasante_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Nnansia na momfa nyɛ mo nnwuma nyinaa, ");
INSERT INTO twiasante_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","na ɛda a ɛtɔ so nson no yɛ homeda ma Awurade Onyankopɔn. Saa ɛda no, ɛnsɛ sɛ moyɛ adwuma biara; ɛnsɛ sɛ mo mmammarima, mo mmabaa anaa mo asomfoɔ anaa mo anantwie anaa mo ahɔhoɔ yɛ adwuma biara. ");
INSERT INTO twiasante_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ɛfiri sɛ, Awurade de nna nsia na ɛbɔɔ ɛsoro, asase ne ɛpo ne biribiara a ɛwɔ ne nyinaa mu, ɛnna ɔhomee ne nnanson so; enti ɔhyiraa homeda no so sɛ wɔmfa nhome. ");
INSERT INTO twiasante_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Di wʼagya ne wo maame ni na wo nna aware wɔ asase a Awurade, wo Onyankopɔn, de bɛma wo no. ");
INSERT INTO twiasante_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Nni awu. ");
INSERT INTO twiasante_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Nsɛe awadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Mmɔ korɔno. ");
INSERT INTO twiasante_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Nni adansekurumu. ");
INSERT INTO twiasante_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Mma wʼani mmerɛ wo yɔnko fie anaa ne yere anaa nʼasomfoɔ anaa nʼanantwie anaa ne mfunumu anaa biribiara a ɛyɛ ne dea.” ");
INSERT INTO twiasante_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nnipa no nyinaa hunuu ayerɛmo ne wisie kumɔnn wɔ bepɔ no so. Wɔtee aprannaa ne totorobɛnto nne a ɛyɛ hu a ɛrebɔ dendeenden. Enti, wɔte gyinaeɛ a ehu ama wɔn ho rewoso. ");
INSERT INTO twiasante_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Wɔka kyerɛɛ Mose sɛ, “Ka asɛm biara a Onyankopɔn aka akyerɛ wo sɛ ka kyerɛ yɛn, na yɛbɛtie. Na mma Onyankopɔn ankasa nkasa nkyerɛ yɛn na yɛanwuwu.” ");
INSERT INTO twiasante_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mose nso ka kyerɛɛ wɔn sɛ, “Monnsuro na Onyankopɔn pɛ sɛ ɔda ne tumi adi kyerɛ mo sɛdeɛ ɛbɛyɛ a, ɛfiri ɛnnɛ rekɔ, mobɛsuro sɛ mobɛyɛ bɔne atia no.” ");
INSERT INTO twiasante_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Nanso, nnipa no tee wɔn ho gyinaa akyirikyiri baabi. Mose deɛ, ɔwuraa esum kabii no mu kɔɔ baabi a Onyankopɔn wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Awurade ka kyerɛɛ Mose sɛ, “Ka saa asɛm yi kyerɛ Israelfoɔ no. ‘Modi ho adanseɛ nokorɛm sɛ, mefiri soro ada me pɛ adi akyerɛ mo. ");
INSERT INTO twiasante_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Monkae sɛ ɛnsɛ sɛ moyɛ anaa mosom ahoni a wɔde sika anaa dwetɛ anaa biribi foforɔ ayɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Dɔteɛ afɔrebukyia na monyɛ mma me. Ɛso na mommɔ mo afɔdeɛ mma me. Mo ɔhyeɛ afɔdeɛ ne asomdwoeɛ afɔdeɛ a mode nnwan ne anantwie bɔ no nyinaa mommɔ mma me. Baabi a mɛkyerɛ mo sɛ monsi afɔrebukyia no na monsi na mɛba hɔ abɛhyira mo. ");
INSERT INTO twiasante_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Motumi de aboɔ nso si afɔrebukyia, nanso aboɔ a wɔntwaeɛ na momfa nsi. Sɛ mode afidie bi twa aboɔ no di no adwini a, ɛnyɛ sɛ wɔde si, ɛfiri sɛ, moagu ho fi. ");
INSERT INTO twiasante_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Monnyɛ atrapoe mma afɔrebukyia no anyɛ saa a, obi bɛhwɛ mo ntadeɛ ase ahunu mo adagya mu.’ ");
INSERT INTO twiasante_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Mmara no nkaeɛ a ɛsɛ sɛ woka kyerɛ wɔn no nie: ");
INSERT INTO twiasante_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Sɛ wotɔ akoa a ɔyɛ Hebrini a, ma no nsom wo mfeɛ nsia, na afe a ɛtɔ so nson no, gyaa no na ɔnkɔ ne baabi kwa a ɔntua hwee. ");
INSERT INTO twiasante_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Sɛ ɔbɛyɛɛ wʼakoa no na ɔyɛ osigyani na sɛ akyire no ɔware a, ɔno nko ara na sɛ mfeɛ nson no duru a ɔbɛkɔ. Na sɛ nso na waware ansa na ɔrebɛyɛ akoa deɛ a, ɔne ne yere no na ɛbɛkɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Sɛ nso ne wura no na ɔmaa no ɔbaa wareeɛ wɔ ne nkoasom no mu, na sɛ wɔwo mmammarima ne mmammaa a, ɔyere ne mma no bɛyɛ owura no dea na okunu no akɔ ne baabi. ");
INSERT INTO twiasante_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Na sɛ ɔbarima no pae mu ka sɛ ‘Mepɛ me wura ne me yere ne me mma asɛm enti merenkɔ’ a, ");
INSERT INTO twiasante_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ne wura no de no bɛba atemmufoɔ anim na wɔde fitiiɛ afiti nʼasom badwa mu na watena ne wura no nkyɛn sɛ akoa afebɔɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Sɛ ɔbarima bi tɔn ne babaa sɛ afenaa a, mfeɛ nsia no duru a, wɔrennyaa no sɛdeɛ wɔgyaa mmarima nkoa no. ");
INSERT INTO twiasante_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Sɛ ne som no nsɔ onipa a ɔtɔɔ no no ani a, onipa ko a ɔtɔn no no wɔ ho ɛkwan sɛ ɔsane bɛtɔ no bio. Nanso afenaa no wura no nni ho ɛkwan sɛ ɔtɔn no ma ɔnanani biara, ɛfiri sɛ, sɛ ɔyɛ saa a, na wabu ɔtɔn no ho nhyehyɛeɛ so. ");
INSERT INTO twiasante_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Na sɛ afenaawura no de afenaa no ma ne babarima aware a, afenaa no bɛyɛ owura no babaa. ");
INSERT INTO twiasante_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Sɛ ɔno ara ankasa ware no na ɔsane ware foforɔ a, ɛnsɛ sɛ ɔte nʼaduane ne ntoma a ɔde ma no no so; na ɛnsɛ sɛ ɔkame no nna sɛ ɔyere. ");
INSERT INTO twiasante_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Na sɛ wantumi anni saa ahyɛdeɛ mmiɛnsa yi so a, afenaa a ɔyɛ ɔyere no tumi kɔ kwa a ɔntua sika biara. ");
INSERT INTO twiasante_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Obiara a ɔbɛbɔ obi akum no no, wɔbɛkum no bi. ");
INSERT INTO twiasante_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Sɛ ɛyɛ asiane a ɛyɛ Onyankopɔn nhyehyɛeɛ a wanhyɛ da a, mɛkyerɛ onii no baabi a ɔnnwane nkɔhinta. ");
INSERT INTO twiasante_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Sɛ obi boapa taataa ɔfoforɔ so pɛ sɛ ɔkum no a, onii no gyina afɔrebukyia anim koraa a, montwe no nkɔkum no. ");
INSERT INTO twiasante_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Deɛ ɔbɔ nʼagya anaa ne maame no, kum na ɛsɛ sɛ wɔkum no. ");
INSERT INTO twiasante_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Obi a ɔwia onipa no, sɛ wɔkyere no sɛ saa onipa no wɔ ne nsam anaasɛ watɔn no a, wɔnkum no. ");
INSERT INTO twiasante_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Deɛ ɔdome nʼagya anaa ne maame no, kum na ɛsɛ sɛ wɔkum no. ");
INSERT INTO twiasante_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Sɛ mmarima baanu reko na wɔn mu baako de ɛboɔ anaa kuturuku bɔ ɔbaako no pira no, na wanwu, nanso ɛka no to mpa so, ");
INSERT INTO twiasante_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","na akyire no, ɔtumi sɔre nante na mpo sɛ ɔtɔ ne nan so a, ɔbarima a ɔbɔɔ ne yɔnko no di bem, nanso ɔbaako no berɛ a wasɛe no no, ɔbɛtua ho sika ama no, asane atua nʼayaresa ka nyinaa kɔsi sɛ ne ho bɛtɔ no. ");
INSERT INTO twiasante_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Sɛ obi hwe nʼakoa anaa nʼafenawa ma no wu a, ɛsɛ sɛ wɔtwe nʼaso. ");
INSERT INTO twiasante_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Nanso, sɛ nna bi akyi akoa no anwu a, ɛnneɛ, owura no renkɔ asotwe biara mu, ɛfiri sɛ, akoa no yɛ nʼagyapadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Sɛ mmarima baanu reko na ɔko no mu wɔpira ɔpemfoɔ ma ɔpɔn, nanso wanwu a, wɔbɛbɔ ɔbarima a ɔpiraa no no ka biara a ɔpemfoɔ no kunu de bɛto atemmufoɔ anim ama wɔapene so no. ");
INSERT INTO twiasante_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Na sɛ opira no mu no, ɔbaa no nam so wu a, wɔnkum saa ɔbarima no. ");
INSERT INTO twiasante_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Sɛ ɔpemfoɔ no pira nʼani a, pira ɔbarima no nso ani; sɛ ne se tu a, tu ne deɛ bi. Nsa nsi nsa anan, ɛnan nsi ɛnan anan, ");
INSERT INTO twiasante_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ɔhyeɛ nsi ɔhyeɛ anan, apirakuro nsi apirakuro anan na ntampeɛ nsi ntampeɛ anan. ");
INSERT INTO twiasante_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Sɛ ɔbarima bi bɔ nʼakoa anaa nʼafenawa ani so ma nʼani bɔ a, ɛsiane nʼani no enti, ɛsɛ sɛ akoa anaa afenaa no kɔ ne baabi kwa. ");
INSERT INTO twiasante_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Sɛ owura tu nʼakoa se a, ne se no enti, ɔmma no nkɔ ne baabi. ");
INSERT INTO twiasante_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Sɛ nantwie pem ɔbaa anaa ɔbarima ma no wu a, wɔnsi nantwie no aboɔ. Wɔnnwe ne nam no. Ne wura no nso, obiara mmfa ne nsa nka no, ");
INSERT INTO twiasante_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","gye sɛ wɔate sɛ mmerɛ bi a atwam no, nantwie no pempem nnipa ma wɔabɔ ne wura no amaneɛ a ɔnka ho hwee; sɛ ɛba saa na sɛ ɔkum obi a, wɔnsi nantwie no aboɔ na ne wura no nso, wɔnkum no. ");
INSERT INTO twiasante_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Sɛ nso owufoɔ no abusuafoɔ pɛ a, wɔbɛbɔ nantwiewura no ka. Atemmufoɔ na wɔbɛkyerɛ ɛka no ano. ");
INSERT INTO twiasante_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Mmara korɔ no ara kyere nantwie a ɔbɛpem abarimaa anaa abaayewa. ");
INSERT INTO twiasante_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Na sɛ nantwie no pem akoa anaa afenaa a, wɔbɛma akoa anaa afenaa no wura dwetɛ gram ahasa ne aduanan mmienu (342), na wɔasi nantwie no aboɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Sɛ ɔbarima bi tu abura, na wankata so, na nantwie anaa afunumu kɔtɔ mu a, ");
INSERT INTO twiasante_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ɛka biara a aboa no wura bɛbɔ abura no wura no, ɛsɛ sɛ abura wura no tua na ɔfa aboa a wawu no. ");
INSERT INTO twiasante_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Sɛ ɔbarima bi nantwie pira nantwie foforɔ na sɛ ɔwu a, mmoawuranom baanu no bɛtɔn aboa a ɔnwuiɛ no na wɔakyɛ sika no mu. Wɔn mu biara nso bɛfa aboa a wawu no fa. ");
INSERT INTO twiasante_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Na sɛ aboa no pempem dada na sɛ ne wura no abu nʼani agu so deɛ a, ɛnneɛ, sika mu kyɛ biara remma; na mmom, ɔbarima a ne nantwie wɔ hɔ no bɛtua nantwie a wawu no ho ka nyinaa na wafa no. ");
INSERT INTO twiasante_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Sɛ obi kɔwia nantwie anaa odwan na ɔkum no anaa ɔtɔn no a, ɔde anantwie enum bɛsi nantwie baako ananmu. Na ɔde nnwan ɛnan asi odwan baako biara ananmu. ");
INSERT INTO twiasante_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Sɛ mohunu ɔkorɔmfoɔ sɛ ɔrebu efie bi awura mu na wɔkum no a, deɛ ɔkumm no no nni fɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Na sɛ asɛm no si awia deɛ a, wɔmfa no sɛ ɛyɛ awudie enti onipa a ɔkumm ɔkorɔmfoɔ no di fɔ. “Sɛ mokyere ɔkorɔmfoɔ bi a, momma ɔntua nneɛma a wawia no nyinaa ho ka na sɛ wantumi antua a, montɔn no sɛ akoa mfa no ntua ɛka no. ");
INSERT INTO twiasante_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Sɛ mokyere no sɛ ɔrewia nantwie anaa afunumu anaa odwan a ɔnwuiɛ anaa biribi foforɔ bi a, mommɔ no dekodeɛ a ɔwiaeɛ no ho ka mpemanim. ");
INSERT INTO twiasante_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Sɛ obi boapa gyaa nʼaboa ma ɔkɔ obi afuom kɔdidi hɔ, sɛe afudeɛ a, ɔmfa ɔno ara nʼafudeɛ mu deɛ ɛsɔ ani pa ara no mmɛtua ka. ");
INSERT INTO twiasante_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Sɛ obi rehye nʼafuo, na ogya no tra kɔtɔ ɔfoforɔ afuo mu, hye, sɛe nʼafudeɛ a, deɛ ɔsɔɔ ogya no bɛtua afudeɛ a asɛe no nyinaa ho ka. ");
INSERT INTO twiasante_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Sɛ obi ma ɔfoforɔ sika anaa ade foforɔ bi sɛ ɔmfa nsie ma no na wɔwia na sɛ wɔkyere ɔkorɔmfoɔ no a, ɔbɛtua no mpemanim. ");
INSERT INTO twiasante_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Na sɛ wɔankyere ɔkorɔmfoɔ no a, wɔde onipa a wɔde agyapadeɛ no hyɛɛ ne nsa no bɛba Onyankopɔn anim abɛhwehwɛ sɛ nʼankasa na ɔwiaa ne yɔnko no anaasɛ ɛnyɛ ɔno. ");
INSERT INTO twiasante_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Sɛ ɛba sɛ nantwie, afunumu, odwan, ntoma anaa biribi foforɔ bi yera na deɛ nʼadeɛ ayera no de nʼani kari obi sɛ ɔno na wafa dekodeɛ no, na onii no sane sɛ ɛnyɛ ɔno na wafa a, ɛsɛ sɛ wɔde nnipa baanu no nyinaa ba Onyankopɔn anim ma ɔhwehwɛ mu. Ɔhwehwɛ mu na deɛ ɔbɛdi fɔ no, ɔbɛtua adeɛ a ɛyeraeɛ no ho ka mmɔho mmienu ama ɔbaako no. ");
INSERT INTO twiasante_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Sɛ obi de afunumu, nantwie, odwan anaa aboa foforɔ bi ma ne yɔnko bi ayɛn na aboa no wu anaa ɔpira anaa ɔdwane na sɛ obi anhunu ammɛka a, ");
INSERT INTO twiasante_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ɛsɛ sɛ deɛ ɔgyee aboa no ayɛn no ka ntam wɔ Awurade anim sɛ ɛnyɛ ɔno na wawia aboa no na deɛ ne dea no gye to mu a, ɔnnye biribiara nsi ananmu. ");
INSERT INTO twiasante_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Nanso, sɛ wia na wɔwiaa aboa no anaa dekodeɛ no wɔ ne nkyɛn deɛ a, na ɛsɛ sɛ sohwɛfoɔ a wɔwiaa aboa no anaa dekodeɛ no firii ne nkyɛn no tua ne wura no ka. ");
INSERT INTO twiasante_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Sɛ akekaboa na ɔkumm no a, ɛsɛ sɛ ɔde aboa no funu ba bɛkyerɛ. Ɔyɛ no saa a, ɔrentua ho ka biara. ");
INSERT INTO twiasante_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Sɛ obi fɛm aboa bi anaa biribi foforɔ bi firi ne yɔnko nkyɛn na sɛ aboa no wu anaa ɔpira ɛberɛ a ne wura no nni hɔ a, ɛsɛ sɛ onipa a ɔfɛm saa aboa no tua ka. ");
INSERT INTO twiasante_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Na sɛ ne wura no wɔ hɔ deɛ a, ɛnsɛ sɛ ɔfɛmfoɔ no tua ka, ɛfiri sɛ, wɔbuu yei nyinaa fraa ɔfɛm no ho akatua mu. ");
INSERT INTO twiasante_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Sɛ ɔbarima bi kɔdaadaa abaayewa bi a ɔnyɛɛ ne ho adeɛ na ɔne no da a, ɛsɛ sɛ ɔyɛ ne ho adeɛ na ɔware no. ");
INSERT INTO twiasante_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Sɛ abaayewa no agya se ɔmpene awadeɛ no so a, ɛsɛ sɛ ɔbarima no tua ne tiri sika. ");
INSERT INTO twiasante_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Monkum mmaa nkonyaayifoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Ɔbarima biara a ɔbɛfa aboa bi no, wɔnkum no. ");
INSERT INTO twiasante_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Obiara a ɔbɛfiri Awurade akyiri abɔ onyame foforɔ bi afɔdeɛ no, wɔnkum no. ");
INSERT INTO twiasante_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Monnhyɛ ɔhɔhoɔ aniɛyaadeɛ ɛkwan biara so; na monkae sɛ, na mo nso moyɛ ahɔhoɔ wɔ Misraim asase so. ");
INSERT INTO twiasante_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Monnsisi akunafoɔ anaa nwisiaa; ");
INSERT INTO twiasante_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","na sɛ moyɛ saa na wɔsu frɛ me a, mɛgye wɔn so. ");
INSERT INTO twiasante_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Mede mʼabufuo bɛtia mo na mama atamfoɔ dɔm akum mo na mo yerenom nso adane akunafoɔ ama mo mma nso ayɛ nwisiaa bi. ");
INSERT INTO twiasante_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Sɛ wobɔ wo yɔnko Hebrini bosea a, nnye ho mfɛntom biara. ");
INSERT INTO twiasante_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Sɛ wogye ne ntoma de si awowa a, anadwo no ara, fa nʼadeɛ kɔma no. ");
INSERT INTO twiasante_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ɛfiri sɛ, ebia na ntoma a ɔwɔ de kata ne ho de ka ne ho hye ara ne no; woagye yi, ɛbɛyɛ dɛn na watumi ada? Sɛ woamfa ankɔma no na sɛ ɔsu frɛ me a, mɛtie na mahunu no mmɔbɔ, ɛfiri sɛ, meyɛ mmɔborɔhunufoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Monnkasa ntia Onyankopɔn na monnome aban mu mpanimfoɔ anaa mo atemmufoɔ anaa wɔn a wɔdi mo so. ");
INSERT INTO twiasante_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Momfa mo nnɔbaeɛ mu nkyɛ mu edu mu baako mmrɛ me ntɛm so. “Saa ara nso na montua mo mmakan mmarima nkwagyeɛ ho ka no. ");
INSERT INTO twiasante_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ma wo nantwie anaa wo dwan abakan no ne ne maame ntena nnanson, na ɛda a ɛtɔ so nwɔtwe no, fa no brɛ me. ");
INSERT INTO twiasante_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Esiane sɛ moyɛ kronkron ma me enti, monnwe aboa biara a akekaboa akyere no akum no. Monnya ne funu no ma nkraman mmɛwe. ");
INSERT INTO twiasante_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Nkeka nkontomposɛm. Wo ne ɔbɔnefoɔ nni nsawɔsoɔ, na woanni adansekurumu. ");
INSERT INTO twiasante_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Mfa wo ho nhyehyɛ nnipadɔm bi a wɔpɛ sɛ wɔyɛ bɔne mu. Sɛ woredi adanseɛ a, nhwɛ nnipa dodoɔ bi so nni mma wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Nka sɛ obi yɛ ohiani enti wobɛdi adanseɛ ama no. ");
INSERT INTO twiasante_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Sɛ wohunu wo ɔtamfoɔ nantwie anaa nʼafunumu a wayera a, kyere no kɔma ne wura no. ");
INSERT INTO twiasante_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Sɛ wokɔto sɛ wo ɔtamfoɔ repagya nʼafunumu agyina ne nan so wɔ adesoa duruduru ase a, ntwa ne ho nkɔ. Boa no. ");
INSERT INTO twiasante_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Sɛ obi yɛ ohiani a, ɛnkyerɛ sɛ ɛsɛ sɛ wɔbu tia no. ");
INSERT INTO twiasante_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Mfa asɛm a wonhunuiɛ nto obi so; mma wɔnkum obi a ɔnyɛɛ bɔne biara. Merempene so saa. ");
INSERT INTO twiasante_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Nnye adanmudeɛ na adanmudegyeɛ fira onipa ani. Adanmudegyeɛ fira anyansafoɔ ani ma wɔsi gyinaeɛ de tia onyamesuroni asɛm. ");
INSERT INTO twiasante_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Nhyɛ ahɔhoɔ so; wonim sɛdeɛ woyɛ ɔmamfrani a ɛteɛ. Kae deɛ wohunuu wɔ Misraim asase so hɔ no. ");
INSERT INTO twiasante_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Dua na twa na ɛntoatoa so saa ara nkɔsi mfeɛ nsia. ");
INSERT INTO twiasante_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Na mfeɛ nson so deɛ, ma asase no nna hɔ kwa na ma ahiafoɔ ntwa nnɔbaeɛ biara a ɛbɛnyini wɔ so no; nkaeɛ no, gya ma mmoa nwe. Wo bobe turo ne wo ngo dua turo hyɛ saa mmara yi ase. ");
INSERT INTO twiasante_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Nnansia na fa yɛ adwuma na home ne nnanson so. Yei bɛma wʼanantwie, wo mfunumu, wo fiefoɔ, wʼasomfoɔ ne wʼahɔhoɔ nso ahome. ");
INSERT INTO twiasante_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Monni nsɛm a maka yi nyinaa so na monkae nso sɛ, ɛnsɛ sɛ mobɔ onyame foforɔ biara din. ");
INSERT INTO twiasante_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Afe biara mu, monhyɛ fa mprɛnsa mfa nhyɛ me animuonyam. ");
INSERT INTO twiasante_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Deɛ ɛdi ɛkan no, monni Apiti Afahyɛ. Sɛ ɛduru so a, nnanson mu, obiara nni burodo a mmɔreka nni mu sɛdeɛ mehyɛɛ mo no. Ɛsɛ sɛ afe biara mohyɛ saa fa yi wɔ ɔbosome Abib mu, bosome a mode tu firii Misraim no mu. “Ɛduru saa ɛberɛ no a, obiara mmrɛ me afɔrebɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Ɛno akyiri, Otwa Afahyɛ na ɛdi so. Saa afahyɛ yi duru so a, momfa mo aduanekan mmrɛ me. “Deɛ ɛtwa toɔ yɛ afudeɛ anoboa afahyɛ a ɛsɛ sɛ wɔdi no ɔtwa berɛ no akyiri. ");
INSERT INTO twiasante_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Afahyɛ ahodoɔ mmiɛnsa yi mu nyinaa, ɛsɛ sɛ Israel mmarima nyinaa ba Awurade Onyankopɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Mfa mmoa a wɔde wɔn bɔɔ afɔdeɛ no mogya nka burodo a mmɔreka wɔ mu ho mma me. “Saa ara nso na mmoa a wɔde wɔn bɔɔ afɔdeɛ no sradeɛ no, mommma adeɛ nnkye so. ");
INSERT INTO twiasante_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Sɛ motwa mo mfudeɛ a, momfa otwakane mu nyiyimu a ɛsɔ ani mmrɛ me; wɔde bɛma Awurade mo Onyankopɔn. “Nnoa abirekyie ba wɔ ne maame nufosuo mu. ");
INSERT INTO twiasante_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Meresoma ɔbɔfoɔ na wadi mo anim de mo akɔ asase a masiesie ama mo no so dwoodwoo. ");
INSERT INTO twiasante_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Momfa anidie mma no na monni ne nsɛm so; monnsɔre ntia no, ɛfiri sɛ, ɔremfa mo amumuyɛ nkyɛ mo. Ɔyɛ mʼananmusini, na me din na ɛda ne so. ");
INSERT INTO twiasante_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Na sɛ moto mo bo ase, na motie no, di me nsɛm nyinaa so a, mɛyɛ ɔtamfoɔ matia mo atamfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Me ɔbɔfoɔ bɛdi mo anim de mo aba Amorifoɔ, Hetifoɔ, Perisifoɔ, Kanaanfoɔ, Hewifoɔ ne Yebusifoɔ asase so na moatena hɔ. Na mɛsɛe saa nnipa no nyinaa wɔ mo anim. ");
INSERT INTO twiasante_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Monnsom anyame a saa aman yi som wɔn no bi, na mommmɔ afɔdeɛ mma wɔn ɛda biara da. Monnni saa abosonsomfoɔ yi akyi. Monni wɔn so na mommubu wɔn ahoni a ɛyɛ animguasedeɛ no ngu. ");
INSERT INTO twiasante_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Mo Awurade, mo Onyankopɔn nko ara na monsom no. Na mɛhyira mo ama mo anya aduane ne nsuo na mɛyi nyarewa nyinaa afiri mo so. ");
INSERT INTO twiasante_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Apɔn anaa abonini remma mo asase no so na mɛma mo nna amee mo. ");
INSERT INTO twiasante_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Awurade ho hu bɛka aman a mobɛdi wɔn so no so nnipa nyinaa na wɔadwane wɔ mo anim. ");
INSERT INTO twiasante_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mɛma kotokurodu abɛpam Hewifoɔ, Kanaanfoɔ ne Hetifoɔ afiri mo anim. ");
INSERT INTO twiasante_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Merenyɛ yeinom nyinaa afe baako pɛ mu na asase no annane ɛserɛ amma nkekaboa ammu amfa mo so. ");
INSERT INTO twiasante_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Mɛpam wɔn nkakrankakra kɔsi sɛ mobɛdɔɔso, atumi ahyɛ asase no so ma. ");
INSERT INTO twiasante_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Mɛto mo ahyeɛ afiri Ɛpo Kɔkɔɔ no ano akɔsi Filistifoɔ mpoano na mede afiri ɛserɛ a ɛwɔ anafoɔ fam no so akɔsi Asuo Eufrate, na mɛma mo adi nnipa a wɔte asase no so no so, na moapam wɔn afiri mo anim. ");
INSERT INTO twiasante_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Mo ne wɔn nnyɛ apam biara, na saa ara nso na mo ne wɔn anyame no nnyɛ biribiara. ");
INSERT INTO twiasante_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Mommma wɔmmɛtena mo mu, ɛfiri sɛ, sɛ wɔbɛtena mo mu a, wɔde wɔn abosonsom no bɛsane mo na sɛ ɛba saa nso a, ɛbɛgu mo asu.” ");
INSERT INTO twiasante_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Afei, Awurade ka kyerɛɛ Mose sɛ, “Wo ne Aaron, Nadab, Abihu ne Israelfoɔ mpanimfoɔ aduɔson mforo mmra ha. Mo nyinaa, momma me ne mo ntam ntwe na monsom me. ");
INSERT INTO twiasante_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mose nko ara na ɔbɛbɛn Awurade; na monkae nso sɛ, ɛnsɛ sɛ wɔn a wɔaka no twe bɛn bepɔ no koraa.” ");
INSERT INTO twiasante_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mose kaa mmara a Awurade hyɛɛ no no nyinaa kyerɛɛ nnipa no ma wɔn nyinaa bɔ gyee so sɛ, “Yɛbɛdi ne nyinaa so.” ");
INSERT INTO twiasante_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mose twerɛɛ Awurade mmara no nyinaa guu hɔ. Adeɛ kyee anɔpa no, ɔsii afɔrebukyia wɔ bepɔ no ase. Ɔde adum dumienu twaa ho hyiaeɛ, ɛfiri sɛ, na Israel mmusuakuo no yɛ dumienu. ");
INSERT INTO twiasante_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Afei, ɔsomaa mmabunu a wɔwɔ wɔn mu no bi sɛ wɔnkɔbɔ ɔhyeɛ afɔdeɛ ne asomdwoeɛ afɔdeɛ mma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mose sɔnee mmoa no mogya no fa de guu nkankyee mu, ɛnna ɔtoo ɛfa a aka no petee afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ɔkan nwoma a watwerɛ a ɛyɛ Apam Nwoma a Awurade akwankyerɛ ne ne mmara wɔ mu no kyerɛɛ nnipa no. Nnipa no bɔ gyee so bio sɛ, “Yɛhyɛ bɔ sɛ, yɛbɛdi mmara no nyinaa so.” ");
INSERT INTO twiasante_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Afei, Mose de mogya a ɛwɔ nkankyee no mu no petee nnipa no so kaa sɛ, “Saa mogya yi hyɛ apam a mo ne Awurade apam ne mmara a ɔde ama mo no mu den.” ");
INSERT INTO twiasante_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Afei Mose, Aaron, Nadab, Abihu ne Israelfoɔ mpanimfoɔ aduɔson no foro kɔɔ bepɔ no so. ");
INSERT INTO twiasante_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Wɔhunuu Israel Onyankopɔn. Na ne nan ntiasoɔ hyerɛn te sɛ aboɔdemmoɔ a ne hyerɛn te sɛ ɔsoro hyerɛn. ");
INSERT INTO twiasante_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ɛwom sɛ mpanimfoɔ no hunuu Onyankopɔn deɛ, nanso wansɛe wɔn. Nokorɛm, wɔn nyinaa bɔɔ mu didii wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Na Awurade ka kyerɛɛ Mose sɛ, “Foro bra me nkyɛn wɔ bepɔ so ha na tena ha kɔsi sɛ mede mmaransɛm a matwerɛ agu ɛboɔ so no bɛma wo, na wonam so akyerɛkyerɛ nnipa no.” ");
INSERT INTO twiasante_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Enti, Mose ne ne ɔboafoɔ Yosua foro kɔɔ Onyankopɔn bepɔ no so. ");
INSERT INTO twiasante_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ɔka kyerɛɛ mpanimfoɔ no sɛ, “Montena ha ntwɛn yɛn kɔsi sɛ yɛbɛba. Merekɔ yi, sɛ asɛm bi kyere mo so a, monka nkyerɛ Aaron ne Hur.” ");
INSERT INTO twiasante_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mose foro kɔɔ bepɔ no so hɔ na ɔyeraa wɔ omununkum mu. ");
INSERT INTO twiasante_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Na Awurade animuonyam hyɛɛ Sinai bepɔ no so ma. Na omununkum sii bepɔ no so nnansia. Ne nnanson so no, ɔfrɛɛ Mose firii omununkum no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Wɔn a wɔwɔ bepɔ no ase no hunuu anwanwadeɛ no. Na Awurade animuonyam a ɛwɔ bepɔ no so no te sɛ ogya a ɛrederɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Na Mose yeraa wɔ bepɔ no so wɔ omununkum no mu. Ɔdii bepɔ no so adaduanan. ");
INSERT INTO twiasante_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ka kyerɛ Israelfoɔ no sɛ, wɔmmɔ afɔdeɛ mma me. ");
INSERT INTO twiasante_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Saa nneɛma a ɛdidi so yi mu na wɔmfiri mmɔ me afɔdeɛ no: “sikakɔkɔɔ, dwetɛ, kɔbere, ");
INSERT INTO twiasante_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ntoma tuntum, koogyan bibire tam; koogyan tam, serekye, abirekyie ho nwi, ");
INSERT INTO twiasante_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","odwennini nhoma a wɔahyɛ no kɔkɔɔ, mmirekyie nwoma a wɔahyɛ, okuo dua, ");
INSERT INTO twiasante_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","kanea ngo, ɔsra ngo, nnuhwam a wɔhyeɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","apopobibirieboɔ, aboɔdemmoɔ a wɔde bɛtuatua asɔfotadeɛ ne adaaboɔ no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Mepɛ sɛ Israelfoɔ si asɔredan kronkron ma me, sɛdeɛ ɛbɛyɛ a, mɛtumi atena wɔn mu. ");
INSERT INTO twiasante_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Me fie no bɛyɛ ntomadan. Mɛkyerɛ mo ɛkwan a mepɛ sɛ mosi saa dan no ne sɛdeɛ mobɛsiesie mu na moagyina so asi. ");
INSERT INTO twiasante_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Momfa okuo dua nyɛ Apam Adaka a ne ntentenemu yɛ basafa baako ne fa, ne tɛtrɛtɛ nyɛ anammɔn mmienu ne kakra na ne korɔn nso nyɛ anammɔn mmienu ne kakra. ");
INSERT INTO twiasante_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Na momfa sikakɔkɔɔ mapa nnura ɛho ne emu nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Momfa sikakɔkɔɔ nkawa ɛnan nhyehyɛ adaka no nan ɛnan no ho, wɔ fam pɛɛ. Ma nkawa no mmienu nkɔ ɛfa baako na mmienu a aka no nso nkɔ ɛfa. ");
INSERT INTO twiasante_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Fa okuo sene mpoma, na fa sikakɔkɔɔ duradura ho, ");
INSERT INTO twiasante_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","na fa hyehyɛ nkawa no mu na wɔde apam adaka no asoa. ");
INSERT INTO twiasante_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Monnyiyi nnua a wɔde soa adaka no mfiri nkawa no mu. Momma ɛnhyehyɛ mu afebɔɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Mowie adaka no a, momfa ɛboɔ a matwerɛ Mmaransɛm Edu no agu so no nto mu. ");
INSERT INTO twiasante_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Momfa sikakɔkɔɔ nyɛ adaka no mmuasoɔ a wɔfrɛ no Mpata Dwa. Ne ntentenemu yɛ anammɔn mmiɛnsa ne fa, ɛnna ne tɛtrɛtɛ nso yɛ anammɔn mmienu ne fa. Ɛha ne beaeɛ a mobɛnya mo bɔne so ahummɔborɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Momfa sikakɔkɔɔ a wɔaboro nyɛ Kerubim mmienu. Momfa ɔbaako nsi adaka no nkatasoɔ atifi na momfa ɔbaako nsi anafoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Fa Kerubim no tetare adaka no ti ne nʼanafoɔ na ɛne adaka no nkatasoɔ no nyɛ mua. ");
INSERT INTO twiasante_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kerubim a wɔyɛ abɔfoɔ no bɛdi nhwɛanimu a wɔasisi wɔn ti ase rehwɛ mpatadwa no na wɔatrɛtrɛ wɔn ntaban mu akata so. ");
INSERT INTO twiasante_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Momfa ɛboɔ twerɛpono a mede bɛma mo no nto adaka no mu, na momfa ne ti no nkata so. ");
INSERT INTO twiasante_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Na mɛhyia mo wɔ hɔ na makasa afiri mpata beaeɛ wɔ soro hɔ afa abɔfoɔ no ntam. Na adaka no mu na wɔbɛkora mʼapam no ho mmara. Ɛhɔ na mɛda me mmaransɛm a mode bɛma Israelfoɔ no adi akyerɛ mo. ");
INSERT INTO twiasante_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Momfa okuo dua nyɛ ɛpono a ne ntentenemu yɛ anammɔn mmiɛnsa, ne tɛtrɛtɛ yɛ anammɔn baako ne fa na ne ɔsorokɔ yɛ anammɔn mmienu ne fa. ");
INSERT INTO twiasante_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Momfa sikakɔkɔɔ nnura ho na momfa sikakɔkɔɔ hankra ntwa ho nhyia. ");
INSERT INTO twiasante_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Yɛ adaka no ho mfomfamho a ne tɛtrɛtɛ yɛ nsateakwaa ɛnan twa ɛpono no ntɛntɛnoa ho hyia, na fa sikakɔkɔɔ hankra fa ho. ");
INSERT INTO twiasante_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Yɛ sikakɔkɔɔ nkawa ɛnan na fa nkawa ɛnan no tuatua ne nan ɛnan no biara akyi ");
INSERT INTO twiasante_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","twɛtwɛwaso wɔ soro. Wɔde nnua no bɛhyehyɛ saa nkawa no mu na wɔde apagya ɛpono no asoa. ");
INSERT INTO twiasante_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Fa okuo yɛ nnua no, na fa sikakɔkɔɔ dura ho. ");
INSERT INTO twiasante_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Momfa sikakɔkɔɔ amapa nyɛ nwowaa, ntere, nhina ne nsatoa. ");
INSERT INTO twiasante_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ɛda biara, fa burodo to ɛpono no so wɔ mʼanim. ");
INSERT INTO twiasante_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Momfa sikakɔkɔɔ a wɔaboro nyɛ kaneadua. Kaneadua no ase, nʼabaa, nkanea no nhwiren ne ɛho nsiesie no nyinaa nyɛ adeɛ baako. ");
INSERT INTO twiasante_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kaneadua a ɛhyɛ mfimfini no bɛnya nkorabata nsia a mmiɛnsa wɔ ɛfa na mmiɛnsa nso wɔ ɛfa. ");
INSERT INTO twiasante_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Momfa nhwiren mmiɛnsa nsiesie nkorabata biara ho. ");
INSERT INTO twiasante_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Na kaneadua no, momfa nhwiren a ɛyɛ fɛ nni adwini mfa nsiesie no. ");
INSERT INTO twiasante_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Nhwiren no bi bɛwɔ ne dua no ase wɔ nkorabata mmienu biara ase. Afei, nhwiren no bi bɛwɔ nkorabata mmienu a ɛwɔ aseɛ no ase, ɛnna ebi nso bɛwɔ nkorabata mmienu a ɛwɔ ɔsoro no so. ");
INSERT INTO twiasante_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Saa nneɛma a wɔde siesie kaneadua no ne ne nkorabata no nyinaa nyɛ adeɛ fua a wɔde sikakɔkɔɔ amapa a wɔaboro ayɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Monyɛ nkanea dua ntuatuaho nson wɔ kaneadua no ho wɔ ɛkwan bi so a ne hyerɛn no bɛto ne hann agu nʼanim. ");
INSERT INTO twiasante_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Kanea ntomaban akapɛ no ne ne mpampaa no nso, momfa sikakɔkɔɔ amapa nyɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Sikakɔkɔɔ kilogram aduasa ɛnan na ɛho bɛhia sɛ mode yɛ kaneadua no ne ɛho nneɛma nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Biribiara a mobɛyɛ no nso, monyɛ no pɛpɛɛpɛ sɛdeɛ merekyerɛ mo wɔ bepɔ so ha yi no. ");
INSERT INTO twiasante_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Fa asaawa a ɛyɛ fɛ a wɔafira yɛ nsɛnanotam edu a emu bi yɛ tuntum, bibire ne koogyan a wɔanwono Kerubim agu mu, na fa si Ahyiaeɛ Ntomadan no. ");
INSERT INTO twiasante_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ɛsɛ sɛ nsɛnanotam edu no nyinaa kɛseɛ yɛ pɛ. Emu biara tenten yɛ anammɔn aduanan mmienu na ne tɛtrɛtɛ nso yɛ anammɔn nsia. ");
INSERT INTO twiasante_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Mompam saa ntoma no enum mmɔ mu ma ɛnyɛ baako. Enum a aka no nso, monyɛ no saa ara. ");
INSERT INTO twiasante_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Momfa ntoma bibire bamma aduonum nwurawura ntoma no afa mmienu a ɛsensɛn hɔ no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ɛsɛ sɛ ɛfa biara, mobɔ nkantankorowa aduonum ma ɛdi nhwɛanimu. ");
INSERT INTO twiasante_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Bɔ sikakɔkɔɔ nkɔtɔkorɔ aduonum na fa sosɔ nkantankorowa no mu, sɛdeɛ ɛbɛyɛ a nsɛnanotam ahodoɔ mmienu no bɛyɛ nsɛnanotam baako. ");
INSERT INTO twiasante_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Nsɛnanotam no akyi no, momfa ntoma nkatasoɔ dubaako a wɔde mmirekyie nwi ayɛ mfa mmɔ Ahyiaeɛ Ntomadan no so. ");
INSERT INTO twiasante_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ntoma nkatasoɔ dubaako no nyinaa tenten ne ne tɛtrɛtɛ nyɛ pɛpɛɛpɛ. Ne tenten nyɛ anammɔn aduanan enum na ne tɛtrɛtɛ nyɛ anammɔn nsia. ");
INSERT INTO twiasante_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ka saa nkatasoɔ enum yi sisi anim ma ɛnyɛ adeɛ tɛtrɛtɛ baako; na fa nsia a aka no bɔ mu na ɛno nso nyɛ adeɛ tɛtrɛtɛ baako. Wɔbɛbu nkatasoɔ ɛtɔ so nsia no ato so ama asensɛn fam sɛ ɛdan kronkron no nkatano. ");
INSERT INTO twiasante_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Fa yaawa nkantankorowa aduonum a wɔabɔ no hyehyɛ ntoma asinasini mmienu no ano. ");
INSERT INTO twiasante_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Na yɛ nsosɔmu aduonum na fa saa nsosɔmu no hyehyɛ nkantankorowa no mu na ɛnka asɔredan no mmɔ mu na ɛnyɛ mua. ");
INSERT INTO twiasante_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ɛdan no mmɔsotam anammɔn baako ne fa bɛsensɛn Ahyiaeɛ Ntomadan no akyi, ");
INSERT INTO twiasante_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","na anammɔn baako ne fa nso asensɛn animu. ");
INSERT INTO twiasante_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Momfa nneɛma ahodoɔ mmienu mmɔ ɛdan no so. Deɛ ɛdi ɛkan no nyɛ odwennini wedeɛ a wɔahyɛ no kɔkɔɔ, deɛ ɛtɔ so mmienu nyɛ abirekyie wedeɛ a ɛsɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Fa okuo yɛ ntaaboo na fatwa Ahyiaeɛ Ntomadan no ho. ");
INSERT INTO twiasante_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Taaboo biara ɔsorokɔ nyɛ anammɔn dunum na ne tɛtrɛtɛ nyɛ anammɔn mmienu ne kakra. ");
INSERT INTO twiasante_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ɛsɛ sɛ nkɔtɔkorɔ mmienu wɔ taaboo biara ase, na taaboo biara yɛ pɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Mobɛyɛ Ahyiaeɛ Ntomadan no ntaaboo ama emu aduonu akyerɛ nʼanafoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Wɔde bɛsisi dwetɛ nsisisoɔ aduanan so; nsisisoɔ no mmienu mmienu nhyehyɛ taaboo biara ase. ");
INSERT INTO twiasante_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ahyiaeɛ Ntomadan no atifi fam nso, wɔbɛyɛ ntaaboo aduonu atwa ho. ");
INSERT INTO twiasante_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Ɛno nso wɔde bɛsisi dwetɛ nsisisoɔ aduanan so a taaboo baako bɛsi nsisisoɔ mmienu so. ");
INSERT INTO twiasante_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ahyiaeɛ Ntomadan no fa a ɛkyerɛ atɔeɛ fam no bɛyɛ nʼakyi. Ɛno nso, wɔde ntaaboo nsia na wɔde bɛtwa ho ");
INSERT INTO twiasante_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","a ntaaboo mmienu sisi ntwea biara. ");
INSERT INTO twiasante_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Wɔde nkɔtɔkorɔ bɛsosɔ ntaaboo mmienu no soro ne ne fam. ");
INSERT INTO twiasante_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Wɔka ne nyinaa bom a, ntaaboo wɔtwe na wɔde bɛyɛ ɛdan no fa hɔ a wɔde bɛsisi dwetɛ nsisisoɔ dunsia so. Taaboo biara bɛfa nsisisoɔ mmienu. ");
INSERT INTO twiasante_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Fa okuo sene mmeamu nnua bi na fa beabea ntaaboo no mu. Mmeamu nnua no enum nkɔ ɛdan no fa baako, ");
INSERT INTO twiasante_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","na enum a aka no nso nkɔ ɛfa baako. Fa mmeamu nnua no enum bɔ ntaaboo a ɛwɔ ntomadan no akyi, a ani kyerɛ atɔeɛ fam no. ");
INSERT INTO twiasante_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Bɔ mmeamu dua baako fa bea ntaaboo no mfimfini na ɛmfiri tire nkɔka tire. ");
INSERT INTO twiasante_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Fa sikakɔkɔɔ dura ntaaboo no ho na fa sikakɔkɔɔ nkawa sosɔ mmeamu dua no mu na ɛnnyina. Fa sikakɔkɔɔ dura mmeamu dua no nso ho. ");
INSERT INTO twiasante_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Fa hyehyɛbea a mekyerɛɛ wo wɔ bepɔ no so hɔ no so pɛpɛɛpɛ si Ahyiaeɛ Ntomadan no. ");
INSERT INTO twiasante_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Fa ntoma tuntum, koogyan bibire, koogyan ne asaawatam a ɛyɛ fɛ yɛ ntwamutam a wɔanwono Kerubim sɛso agu mu no. ");
INSERT INTO twiasante_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Fa sɛn okuo nnua fadum nan a wɔde sikakɔkɔɔ adura ho a sikakɔkɔɔ nsosɔmu nan sosɔ ano no so. Ma fadum ɛnan no mu biara nsi dwetɛ ntaaboo ɛnan no baako so. ");
INSERT INTO twiasante_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Fa ntwamutam no sensɛn nsosɔmu no so na fa tware ɛdan no mu. Fa adaka a ɛboɔ a wɔatwerɛ Onyankopɔn mmara agu so no da mu no si ntoma ntwamu no akyiri. Ntoma ntwamu no bɛtwa kronkronbea hɔ ne kronkron mu kronkron no ntam. ");
INSERT INTO twiasante_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Afei, fa adaka no mmuasoɔ a wɔde sikakɔkɔɔ ayɛ no bua so na fa si kronkron mu kronkron hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Fa ɛpono no ne kaneadua no tware dan no mu wɔ ntwamutam no akyi. Kaneadua no bɛsi kronkronbea no anafoɔ, ɛnna ɛpono no asi nʼatifi. ");
INSERT INTO twiasante_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Fa ntoma foforɔ a ɛyɛ koogyan bibire ne koogyan asaawatam yɛ Ahyiaeɛ Ntomadan no ano nkatano. ");
INSERT INTO twiasante_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Fa saa ntwamutam no sɛn okuo mpunan enum a wɔde sikakɔkɔɔ adura ho no nsosɔmu no so. Wɔde saa mpunan no bɛsisi yaawa ntaeaseɛ enum no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Fa okuo yɛ afɔrebukyia ma ɛnyi ahinanan a nʼafanan no mu biara yɛ anammɔn nson ne fa na ne ɔsorokɔ nso yɛ anammɔn ɛnan ne fa. ");
INSERT INTO twiasante_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Yɛ mmɛn ɛnan tuatua afɔrebukyia no ntwea ɛnan no nyinaa so, na fa kɔbere dura ne nyinaa ho. Okuo no a wode bɛyɛ afɔrebukyia no, ɛno ara bi na wode bɛyɛ mmɛn no. ");
INSERT INTO twiasante_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Bokiti a nsõ bɛgu mu, sofi, atam, adinam ne nsramma nkyɛnsee nyinaa, yaawa na fa yɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Fa kɔbere yɛ otwidadeɛ na fa dadeɛ nkawa hyehyɛ ne ntwea ɛnan no so. ");
INSERT INTO twiasante_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Fa otwidadeɛ no hyɛ nsramma kyɛnsee no mu na fa si afɔrebukyia no basa a wɔayɛ no so. ");
INSERT INTO twiasante_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Fa okuo sene nnua a wɔde kɔbere adura ho a wɔde bɛsoa afɔrebukyia no. ");
INSERT INTO twiasante_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Sɛ moresoa a, momfa nnua no nhyehyɛ nkawa a mode atuatua afɔrebukyia no ho no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ntaaboɔ na momfa nyɛ afɔrebukyia no. Momma emu nna ɛkwan sɛdeɛ mede kyerɛɛ mo wɔ bepɔ no so no. ");
INSERT INTO twiasante_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Twa adihɔ ma Ahyiaeɛ Ntomadan no na fa ntoma a wɔde asaawa a ɛyɛ fɛ ayɛ sensɛn ho. Nsɛnanotam a ɛsɛn anafoɔ no tenten nyɛ anammɔn ɔha aduonum ");
INSERT INTO twiasante_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","a kɔbere nnua aduonu a ɛsisi kɔbere nnyinasoɔ aduonu mu sosɔ mu. Dwetɛ nkɔtɔkorɔ ne dwetɛ ntweaa a ɛfomfam dwetɛ afadum no ho no na ɛbɛsosɔ nsɛnanimu no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Adihɔ a ɛkyerɛ atifi fam no nso, saa ara na wɔnyɛ no. Nsɛnanimu a ne tenten yɛ anammɔn ɔha aduonum, na nnua aduonu sisi kɔbere nnyinasoɔ mu a dwetɛ nkɔtɔkorɔ ne ne ntweaa fomfam ho na ɛbɛgyina no. ");
INSERT INTO twiasante_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Adihɔ no fa a ɛkyerɛ atɔeɛ fam no tɛtrɛtɛ bɛyɛ anammɔn aduɔson enum a ɛkura nnua edu a ntokuro edu deda mu mu. ");
INSERT INTO twiasante_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Apueeɛ fam nso bɛyɛ anammɔn aduɔson enum saa ara ");
INSERT INTO twiasante_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Baabi a ne kwan da nʼapueeɛ fam no, wɔmfa nsɛnanotam a ne tenten yɛ anammɔn aduonu mmienu ne fa a nnua mmiɛnsa a ɛsisi ntokuro mmiɛnsa mu sosɔ mu nsɛn ano. ");
INSERT INTO twiasante_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Baabi a ne kwan da wɔ nʼatɔeɛ fam no nso, wɔmfa nsɛnanotam a ne tenten yɛ anammɔn aduonu mmienu ne fa nsɛn ano. Nnua mmiɛnsa a ɛsisi ntokuro mmiɛnsa mu na ɛbɛsosɔ nsɛnanotam no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Adihɔ hɔ no ano ɛkwan nyɛ ntoma nsɛnanimu a ne tɛtrɛtɛ yɛ anammɔn aduasa. Wɔde asaawa tuntum, bibire ne koogyan bɛdi mu adwini fɛfɛɛfɛ. Wɔde nnua ɛnan a ɛsisi ne nnyinasoɔ mu no nso bɛsosɔ nsɛnanotam no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ɛsɛ sɛ nnua a ɛwɔ adihɔ hɔ no nyinaa wɔde dwetɛ ntweaa a dwetɛ sosɔ mu na nʼase no nso, wɔde hyehyɛ kɔbere nnyinasoɔ pipiripie mu. ");
INSERT INTO twiasante_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Enti, adihɔ hɔ ntentenemu bɛyɛ anammɔn ɔha ne aduonum, ɛnna ne tɛtrɛtɛ nso ayɛ anammɔn aduɔson enum. Wɔde nsɛnanotam a wɔde asaawatam bɛyɛ ne fasuo, a ne ɔsorokɔ nso bɛyɛ anammɔn nson ne fa. Ɛsɛ sɛ wɔde nnua a atwa adihɔ hɔ no ho ahyia no sisi kɔbere nnyinasoɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Kɔbere na ɛsɛ sɛ wɔde yɛ Ahyiaeɛ Ntomadan mu hɔ nkyɛnsee a wɔde nneɛma gu mu, ne mpɛɛwa a wɔde nkyɛnsee bɛsensɛn so wɔ ɔfasuo ho wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Ka kyerɛ Israelfoɔ no na wɔmmrɛ wo ngo kronn na fa sɔ kanea a ɛnnum da no. ");
INSERT INTO twiasante_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaron ne ne mmammarima na wɔde nkanea a ɛnnum da no bɛsi Ahyiaeɛ Ntomadan no mu. Wɔbɛhwɛ so daa ama Awurade sɛdeɛ ɛbɛyɛ a, ɛrennum. Yei yɛ mmara a ɛsɛ sɛ Israelfoɔ di so daa. ");
INSERT INTO twiasante_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Yi wo nua Aaron ne ne mmammarima Nadab, Abihu, Eleasa ne Itamar na te wɔn ho na wɔnyɛ asɔfoɔ nsom me. ");
INSERT INTO twiasante_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Pam atadeɛ kronkron ma wo nua Aaron na ama animuonyam aba nʼadwuma no ho. Pam atadeɛ no na ɛnyɛ fɛ, sɛdeɛ ɛbɛma afata nʼadwuma no. ");
INSERT INTO twiasante_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ka kyerɛ nnipa a mama wɔn adepam ho nyansa na wɔmpam atadeɛ no. Ɛno na ɛbɛma ne ho ada nso wɔ nʼafɛfoɔ mu na ama watumi asom me. ");
INSERT INTO twiasante_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ntadeɛ ahodoɔ a wɔbɛpam no nie: adaaboɔ asɔfotadeɛ, asɔfotadeɛ, atadeɛ yuu, atadeɛ kɔnsini a ɛyɛ damedame, abɔtiten ne abɔwomu. Wɔbɛpam ntadeɛ kronkron bi nso de ama Aaron mmammarima no. ");
INSERT INTO twiasante_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Wɔde ntoma tuntum, bibire ne koogyan a wɔde asaawatam pa na anwono na ɛbɛpam. ");
INSERT INTO twiasante_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Ma ntomanwono mu adwumfoɔ papa mfa sikakɔkɔɔ ne bibire ne asaawa a ɛberedum ne koogyan ne asaawa fitaa a wɔafira nyɛ asɔfotadeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Wɔbɛpam no asinasini mmienu a ɛyɛ animu ne akyire a wɔapam ne mmatire no so abɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Abɔwomu no bɛyɛ ntoma korɔ no ara bi. Ɛbɛyɛ nsaawatam a ɛyɛ akokɔsradeɛ, tuntum, bibire ne koogyan. ");
INSERT INTO twiasante_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Fa apopobibirieboɔ mmienu na twerɛ Israelfoɔ mmusuakuo no din gu so. ");
INSERT INTO twiasante_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Aboɔdenboɔ biara, wɔntwerɛ edin nsia ngu so, sɛdeɛ ɛbɛyɛ a, wɔn nyinaa din bɛdidi so mpanin mu. ");
INSERT INTO twiasante_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Fa ɛkwan a aboɔdenboɔtwafoɔ si fa twa edin gu adwinneɛ so, na twerɛ edin ahodoɔ no sɛdeɛ Israel mma no din te, na fa sika ntotoano twa ho hyia. ");
INSERT INTO twiasante_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Fa aboɔdemmoɔ mmienu no sisi asɔfotadeɛ no mmati so na ɛnyɛ nkaedeɛ mma Israelfoɔ. Na daa Aaron nso nam so akae, abɔ wɔn din akyerɛ Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Yɛ sikakɔkɔɔ ntweaban a wɔakyinkyim mmienu. ");
INSERT INTO twiasante_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Na fa mmobareeɛ mmienu a wɔde sikakɔkɔɔ ayɛ tetare mfomfamho a ɛwɔ asɔfotadeɛ no mmati so no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Momma odwumfoɔ a nʼadwinnie yɛ fɛ na ɔnyɛ atemmuo adaaboɔ no. Momfa asaawatam a ɛyɛ akokɔsradeɛ, tuntum, bibire ne koogyan na mompam adaaboɔ no sɛdeɛ mode pam asɔfotadeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Montwa ntomasini no ahinanan na ɛfa biara nyɛ nsateakwaa nkron na mompam mfam so mma ɛnyɛ sɛ kotokuo. ");
INSERT INTO twiasante_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Momfa aboɔdemmoɔ nsasoɔ ɛnan mmobɔ mu. Nsasoɔ a ɛdi ɛkan no nyɛ bogyanamboɔ, deɛ ɛtɔ so mmienu no nyɛ akarateboɔ na deɛ ɛtwa toɔ no nyɛ ɛboɔ a ɛte sɛ ahahammonoboɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Nsasoɔ a ɛtɔ so mmienu no nyɛ nsrammaboɔ, aboɔdemmoɔ ne dɛnkyɛmmoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Nsasoɔ a ɛtɔ so mmiɛnsa no nso bɛyɛ akutuhonoboɔ, mfrafraeɛboɔ ne beredumboɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Nsasoɔ a ɛtɔ so nan no bɛyɛ sikabereɛboɔ, apopobibirieboɔ ne ahwehwɛboɔ. Sikakɔkɔɔ ntotoano ntwa ne nyinaa ho nhyia. ");
INSERT INTO twiasante_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Aboɔdemmoɔ no baako biara bɛgyina hɔ ama Israel mmusuakuo no baako. Na wɔbɛtwerɛ abusua ko no din agu so sɛ nsɔanodeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Ɛkwan a mobɛfa so de adaaboɔ no afam asɔfotadeɛ no mu nie: yɛ sikakɔkɔɔ mmobareeɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","na yɛ sikakɔkɔɔ nkawa mmienu, na fa tare adaaboɔ no apampam twɛtwɛwa so; ");
INSERT INTO twiasante_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","wɔde sikakɔkɔɔ mmobareeɛ mmienu no bɛhyehyɛ adaaboɔ no nkawa mmienu no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Nhoma mmienu no a aka no, kyekyere biara ti bɔ sikakɔkɔɔ no a ɛbɔ asɔfotadeɛ no abatiri so no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Yɛ sika nkawa mmienu na fa hyehyɛ adaaboɔ ntwea mmienu a ɛwɔ asɔfotadeɛ no nkyɛn mu. ");
INSERT INTO twiasante_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Sane yɛ sikakɔkɔɔ nkawa mmienu hyehyɛ asɔfotadeɛ no ntwea so wɔ fam ma ɛnka abɔwomu no. ");
INSERT INTO twiasante_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Fa bibire nhoma kyekyere adaaboɔ no ase na fa hyehyɛ nkawa a ɛwɔ asɔfotadeɛ no ase no mu. Yei remma adaaboɔ no mfiri asɔfotadeɛ no ho nte ntwontwɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Aaron bɛfa saa ɛkwan yi so na ɔde Israel mmusuakuo no din a ɛwɔ adaaboɔ no so no bɛkɔ kronkronbea hɔ; na yei na ɛbɛma Awurade akae Israelman ɛberɛ nyinaa mu. ");
INSERT INTO twiasante_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Sɛ Aaron rekɔ Awurade anim a, ɔmfa Urim ne Tumim a aseɛ ne hann ne pɛyɛ nhyɛ adaaboɔ a ɛda ne koko so no kotokuo mu. Saa ara na daa Aaron bɛsoa nneɛma a wɔnam so kyerɛ Awurade apɛdeɛ de ma ne nkurɔfoɔ ɛberɛ biara a ɔbɛkɔ Awurade anim no. ");
INSERT INTO twiasante_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Wɔde ntoma tuntum na ɛbɛpam asɔfotadeɛ no ");
INSERT INTO twiasante_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","a wɔagya ɛkwan bi a Aaron de ne tiri bɛwura mu. Ɛsɛ sɛ wɔtwa mfimfini tokuro ma ano no yɛ den sɛdeɛ wɔhyɛ a ɛrentete. ");
INSERT INTO twiasante_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Wɔde ntoma tuntum, bibire ne koogyan na ɛbɛpam ato ano. ");
INSERT INTO twiasante_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Ɛsɛ sɛ wɔde sikakɔkɔɔ nnɔmma ne ateaa aba a ɛdi afrafra twa asɔfotadeɛ no mmuano ho hyia. ");
INSERT INTO twiasante_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ɛberɛ biara a Aaron bɛkɔ Awurade anim akɔsɔre no, saa asɔfotadeɛ yi na ɔbɛhyɛ. Ɔredi akɔneaba wɔ Awurade anim hɔ wɔ kronkronbea hɔ no, na ɛdɔn no rewoso sɛdeɛ ɛbɛyɛ a, ɔrenwu. ");
INSERT INTO twiasante_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Afei, boro sikakɔkɔɔ amapa ma ɛnyɛ trawa sɛ prɛte na twerɛ so sɛdeɛ wɔkurukyire nsɔanodeɛ so no sɛ: Kronkron Ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Wɔde ntoma tuntum bɛsɔ mu asensɛn Aaron abotire no anim. ");
INSERT INTO twiasante_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aaron de saa adeɛ no bɛbɔ ne moma so sɛdeɛ ɛbɛyɛ a, sɛ Israelfoɔ no bɔ afɔdeɛ biara na mfomsoɔ ba ho a, ɛho asodie bɛda ne so, na Awurade agye nnipa no, na ɔde wɔn bɔne nso akyɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Fa asaawatam a ɛyɛ fɛ nwono Aaron atadeɛ kɔnsini no. Ma ɛnyɛ damedame na fa ntoma korɔ no ara bi pam abotire na nwono biribi gu ne nkatakɔnmu no nso mu. ");
INSERT INTO twiasante_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Pam atadeɛ yuu ne abɔwomu ne abotire ma Aaron mmammarima na momfa obuo ne anidie mma wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Saa ntadeɛ yi na momfa nhyɛ Aaron ne ne mmammarima na momfa ngo ngu wɔn tirim mfa nhyɛ wɔn asɔfoɔ wɔ ɔsom no mu, na momfa nte wɔn ho sɛ asɔfoɔ a wɔyɛ me dea. ");
INSERT INTO twiasante_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Mompam serekye ntadeɛ a ɛfiri wɔn sisi kɔka wɔn nan ase, na wɔhyɛ ansa a, wɔahyɛ wɔn ntadeɛ no agu so. ");
INSERT INTO twiasante_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Ɛberɛ biara a Aaron ne ne mmammarima no rekɔ Ahyiaeɛ Ntomadan mu hɔ anaasɛ wɔrekɔ afɔrebukyia no anim wɔ kronkronbea hɔ no, wɔnhyɛ. Anyɛ saa a, afɔbuo bɛba wɔn so ma wɔawuwu. “Yei yɛ daa apam a wɔahyɛ ama Aaron ne ne mmammarima. ");
INSERT INTO twiasante_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Ɛkwan a ɛsɛ sɛ mofa so hyɛ Aaron ne ne mma asɔfoɔ nie: momfa nantwie ba ne nnwennini mmienu a wɔn ho nni dɛm; ");
INSERT INTO twiasante_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","afei momfa esiam muhumuhu a mmɔreka nni mu nyɛ burodo a ɛyɛ dɛ ne taterɛ a wɔde ngo afra ne ɔfam a wɔde ngo agu so. ");
INSERT INTO twiasante_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Fa burodo no gu kɛntɛn mu na fa nantwie ba no ne odwennini no ka ho bra Ahyiaeɛ Ntomadan no ano. ");
INSERT INTO twiasante_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Momfa Aaron ne ne mmammarima no mmra Ahyiaeɛ Ntomadan no kwan ano hɔ, na momfa nsuo nnware wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Afei, momfa Aaron atadeɛ yuu no nhyɛ no. Monhyɛ no atadekɔnsini no, ne asɔfotadeɛ no ne adaaboɔ no ne abɔwomu no, ");
INSERT INTO twiasante_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","na momfa abotire a sikakɔkɔɔ kronkron bobɔ mu no mmɔ no. ");
INSERT INTO twiasante_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Afei, momfa srango no na monhwie ngu ne tiri so. ");
INSERT INTO twiasante_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ne mmammarima no nso, momfa wɔn ntadeɛ yuu no nhyehyɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Momfa wɔn abɔwomu no ne ɛkyɛ nka wɔn ho. Saa ɛkwan yi so na momfa nhyɛ Aaron ne ne mma ne wɔn asefoɔ ma wɔnyɛ asɔfoɔ daa nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Mode nantwie ba no bɛba Ahyiaeɛ Ntomadan no anim na Aaron ne ne mmammarima de wɔn nsa agu aboa no apampam. ");
INSERT INTO twiasante_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Afei, monkum no wɔ Awurade anim wɔ Ahyiaeɛ Ntomadan no kwan ano. ");
INSERT INTO twiasante_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Momfa ne mogya nsrasra mmɛn a ɛtuatua afɔrebukyia no ho no so. Momfa mo nsateaa na ɛnyɛ, na monhwie mogya a ɛbɛka no ngu afɔrebukyia no ase. ");
INSERT INTO twiasante_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Monyi ne mu sradeɛ no ne ne berɛboɔ kotokuo no ne ne sawa mmienu no ne sradeɛ a ɛwɔ ho no na monhye no wɔ afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Afei, momfa aboa no ne ne wedeɛ ne nʼagyanan no mfiri beaeɛ hɔ na monkɔhye no sɛ bɔne ho afɔrebɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Sɛ wɔrebɛkum nnwennini no nso a, Aaron ne ne mmammarima no mfa wɔn nsa ngu aboa no baako apampam ");
INSERT INTO twiasante_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","na wɔnkum no. Wɔnsɔ ne mogya no na wɔmfa mpete afɔrebukyia no ho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Twitwa odwennini no asinasini na hohoro nʼayamdeɛ no mu ne ne nnyawa no ho; fa ne ti no ne deɛ moatwitwa no gu faako ");
INSERT INTO twiasante_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","na monhye no wɔ afɔrebukyia no so; ɛyɛ ɔhyeɛ afɔdeɛ a ɛsɔ Awurade ani. ");
INSERT INTO twiasante_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Afei, momfa odwennini a aka no na Aaron ne ne mmammarima mfa wɔn nsa ngu nʼapampam, ");
INSERT INTO twiasante_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","na wɔnkum no. Monsɔ mogya no bi na momfa ketewaa bi nsosɔ Aaron ne ne mmammarima no aso nifa, wɔn kokurobetie nifa ne wɔn nan nifa kokurobetie so. Afei mompete nkaeɛ no ngu afɔrebukyia no ho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Montwerɛ mogya a ɛwɔ afɔrebukyia no so no bi na momfa mfra srango na momfa mpete Aaron ne ne mmammarima so ne wɔn ntadeɛ mu. Ɛnam saa so bɛma wɔne wɔn ntadeɛ ho ate wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Momfa odwennini no sradeɛ ne ne duapuo ne ne mu sradeɛ ne ne berɛboɔ kotokuo ne ne sawa mmienu ne ɛho sradeɛ ne ne srɛ nifa—yei ne odwennini a wɔde bɛhyɛ Aaron ne ne mmammarima asɔfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Momfa burodo mua baako ne taterɛ a wɔde srango afra, na monyi ɔfam baako mfiri kɛntɛn a wɔde burodo a mmɔreka nni mu agu mu a wɔde asi Awurade anim no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Momfa yeinom nhyɛ Aaron ne ne mmammarima nsam na wɔmfa nkyerɛ sɛ ɔhim afɔrebɔdeɛ mma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ɛno akyi, monnye mfiri wɔn nsam na monhye no afɔrebukyia no so sɛ ohwam afɔdeɛ mma no. ");
INSERT INTO twiasante_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Afei, momfa Aaron asɔfohyɛdwan no yan na monhim no Awurade anim, mfa nkyerɛ sɛ, morebɔ no afɔdeɛ; ɛno akyi momfa ");
INSERT INTO twiasante_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","odwennini a moate ne ho no yan ne ne srɛ ");
INSERT INTO twiasante_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","mma Aaron ne ne mmammarima. Ɛsɛ sɛ daa ɛyɛ Israelfoɔ asɛdeɛ sɛ wɔbɛboa saa afɔrebɔ yi—sɛ ɛyɛ asomdwoeɛ afɔrebɔ anaa aseda afɔrebɔ, de hyɛ Awurade animuonyam. ");
INSERT INTO twiasante_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Aaron ntadeɛ kronkron yi, wɔbɛkora na wɔate ho de ama ne mmammarima a daakye wɔbɛdi nʼadeɛ, sɛdeɛ sɛ wɔn asɔfohyɛ duru so a, wɔbɛtumi de ahyɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ɔsɔfopanin biara a ɔbɛdi Aaron adeɛ no bɛhyɛ saa ntadeɛ yi nnanson ansa na wafiri nʼasɔfodwuma ase wɔ Ahyiaeɛ Ntomadan no mu ne kronkronbea hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Fa odwennini no nam a wɔate ho no ne odwennini nam a wɔde hyɛɛ ɔsɔfoɔ no na monnoa no baabi a ɛhɔ te. ");
INSERT INTO twiasante_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron ne ne mmammarima bɛdi burodo a ɛwɔ kɛntɛn no mu no, na wɔde ɛnam no abɔ so wɔ Ahyiaeɛ Ntomadan no ano. ");
INSERT INTO twiasante_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Wɔn nko ara na wɔbɛwe ɛnam no adi nnuane a wɔde tee wɔn ho no. Nnipa a wɔmfra asɔfoɔ abusua no mu no renni bi, ɛfiri sɛ, wɔate ho. ");
INSERT INTO twiasante_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Sɛ ɛba sɛ adeɛ kye ɛnam anaa burodo no bi so a, monhye no. Ɛnsɛ sɛ wɔdi, ɛfiri sɛ, ɛyɛ kronkron. ");
INSERT INTO twiasante_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Yei ne ɛkwan a momfa so nhyɛ Aaron ne ne mmammarima no asɔfoɔ. Nnanson na wɔmfa nni saa asɔfohyɛ no ho dwuma. ");
INSERT INTO twiasante_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ɛda biara, mode nantwie ba bɛbɔ afɔdeɛ de adwira mo ho. Ɛno akyi, pra afɔrebukyia no ho bɔne nyinaa na yɛ no kronkron na hwie ngo gu so fa te ho. ");
INSERT INTO twiasante_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Te afɔrebukyia no ho na daa yɛ no kronkron saa ara nnanson ma Onyankopɔn. Ɛno akyi, afɔrebukyia no ho bɛte yie sɛdeɛ biribiara a wɔde bɛka no no bɛyɛ Onyankopɔn dea. ");
INSERT INTO twiasante_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Ɛda biara, mommɔ nnwanten mma mmienu afɔdeɛ wɔ afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Momfa odwammaa no baako mmɔ afɔdeɛ no anɔpa na momfa baako nso mmɔ afɔdeɛ anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Afɔrebɔ no mu baako, momfa asikyiresiam lita mmienu ne fa a wɔayam no muhumuhu mfra ngo a wɔakyi firi ngo dua mu nkɔtoa mmienu ne fa; saa ara na momfa bobesa lita baako nyɛ ahwiesa. ");
INSERT INTO twiasante_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Momfa odwammaa no baako a waka no mmɔ anwummerɛ afɔdeɛ a asikyiresiam ne nsã ka ho te sɛ anɔpa deɛ no ara. Ɛbɛyɛ ɔhyeɛ afɔrehwam ama Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Saa afɔrebɔ yi bɛkɔ so ɛda biara wɔ Ahyiaeɛ Ntomadan no ɛpono ano wɔ Awurade anim. Ɛhɔ na mɛhyia mo ne mo akasa. ");
INSERT INTO twiasante_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Na mɛhyia Israel mma wɔ hɔ na mʼanimuonyam ate Ahyiaeɛ Ntomadan no ho. ");
INSERT INTO twiasante_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Ampa ara, mɛte Ahyiaeɛ Ntomadan no ne afɔrebukyia no ho ne Aaron ne ne mmammarima a wɔyɛ mʼasɔfoɔ no ho. ");
INSERT INTO twiasante_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Na mɛtena Israelfoɔ mu na mayɛ wɔn Onyankopɔn, ");
INSERT INTO twiasante_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","na wɔbɛhunu sɛ mene Awurade, wɔn Onyankopɔn. Mede wɔn firi Misraim baeɛ sɛdeɛ ɛbɛyɛ a, mɛtena wɔn mu. Mene Awurade wɔn Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Fa okuo yɛ afɔrebukyia ketewa bi a wobɛhye aduhwam wɔ so. ");
INSERT INTO twiasante_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ma ɛnyɛ ahinanan a ne fa biara susu nsateakwaa dunwɔtwe, na ne ɔsorokɔ nso nyɛ anammɔn mmiɛnsa a wɔasene mmɛn a ɛfiri dua a wɔde yɛɛ afɔrebukyia no ara mu ama ɛtuatua ho. Ɛnsɛ sɛ ɛyɛ mmɛn a wɔsene firi baabi bɛtuatuaa ho. ");
INSERT INTO twiasante_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Fa sikakɔkɔɔ kata ne soro, ne nkyɛn ne mmɛn a ɛwɔ afɔrebukyia no ho no nyinaa. Na fa sikakɔkɔɔ ntotoano twa afɔrebukyia no ho nyinaa hyia. ");
INSERT INTO twiasante_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Fa sikakɔkɔɔ nkawa mmienu bobɔ afɔrebukyia no afanu no nkyɛn mu ase na wɔde nnua a wɔde bɛsoa no awurawura mu. ");
INSERT INTO twiasante_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Wɔmfa okuo na ɛnyɛ nnua no, na wɔmfa sikakɔkɔɔ nnura ho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Fa afɔrebukyia no si ntwamutam no akyi wɔ mpata beaeɛ hɔ a ɛbɔ faako a Apam Adaka a Mmaransɛm Edu no wɔ hɔ no ho ban. Mɛhyia mo hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Ɛda biara anɔpa, sɛ Aaron resiesie kanea no a, ɔbɛhye aduhwam wɔ afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Anwummerɛ biara, sɛ ɔsɔ kanea no a, ɔbɛhye aduhwam wɔ Awurade anim. Yei bɛtoa so firi awoɔ ntoatoasoɔ so akɔsi awo ntoatoasoɔ so. ");
INSERT INTO twiasante_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Monhye aduhwam a wɔama ho ɛkwan wɔ afɔrebukyia no so. Mommmɔ ɔhyeɛ afɔdeɛ ne aduane afɔdeɛ wɔ so, na mommfa ahwiesa ngu so. ");
INSERT INTO twiasante_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Afe biara, ɛsɛ sɛ Aaron dwira afɔrebukyia no ho yɛ no kronkron. Ɔde mogya bɛsrasra mmɛn a ɛtuatua ho no so sɛ mpatadeɛ. Ɛsɛ sɛ afe biara wɔte afɔrebukyia no ho yɛ no kronkron firi awoɔ ntoatoasoɔ so kɔsi awo ntoatoasoɔ so, ɛfiri sɛ, ɛyɛ Awurade afɔrebukyia kronkron.” ");
INSERT INTO twiasante_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Ɛberɛ biara a wobɛkan Israelfoɔ no, obiara a wɔbɛkan no no mfa ne mpatadeɛ mmrɛ Awurade mma ne kra, sɛdeɛ ɛbɛyɛ a, ɔyaredɔm biara remma wɔn mu bi so. ");
INSERT INTO twiasante_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ɛsɛ sɛ obiara a wɔkan no no ma dwetɛbena fa, a emu duru yɛ gram nsia (sɛdeɛ kronkronbea mu dwetɛbena boɔ teɛ no). ");
INSERT INTO twiasante_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Obiara a wadi mfeɛ aduonu rekorɔ no na ɔbɛbɔ saa afɔdeɛ yi. ");
INSERT INTO twiasante_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ɛnsɛ sɛ adefoɔ ma ma ɛboro sika a wɔatwa ato hɔ no so. Ɛnsɛ sɛ ahiafoɔ nso ma deɛ ɛsua sene saa, ɛfiri sɛ, ɛyɛ Awurade afɔdeɛ a ɔde rete yɛn ho ama yɛn. ");
INSERT INTO twiasante_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Momfa saa sika yi nsiesie Ahyiaeɛ Ntomadan no. Sɛ moyɛ saa a, ɛbɛma Awurade ani aba mo, Israelfoɔ so, na ayɛ mpatadeɛ nso ama mo.” ");
INSERT INTO twiasante_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Awurade ka kyerɛɛ Mose sɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Fa kɔbere yɛ atam a ne nnyinasoɔ nso yɛ kɔbere. Fa si Ahyiaeɛ Ntomadan no ne afɔrebukyia no ntam na fa nsuo gu mu. ");
INSERT INTO twiasante_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ɛhɔ na Aaron ne ne mmammarima bɛhohoro wɔn nsa ne wɔn nan ho ");
INSERT INTO twiasante_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ɛberɛ a wɔrekɔ Ahyiaeɛ Ntomadan no mu de wɔn ho akɔkyerɛ Awurade, anaasɛ nso wɔrekɔ akɔbɔ afɔdeɛ wɔ afɔrebukyia no so ama Awurade no. Ɛberɛ biara a wɔrekɔdi saa dwuma yi no, ɛsɛ sɛ wɔhohoro wɔn ho; anyɛ saa a, wɔbɛwuwu. ");
INSERT INTO twiasante_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Yei ne mmara a wɔahyɛ ama Aaron ne ne mmammarima firi awo ntoatoasoɔ so kɔsi awo ntoatoasoɔ so no.” ");
INSERT INTO twiasante_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Hwehwɛ nnuhwam papa sɛ kurobo, kilogram nsia, sinamon kilogram mmiɛnsa ne mmɛtire hwamhwam kilogram mmiɛnsa. ");
INSERT INTO twiasante_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Kurobo dodoɔ a mobɛfa no nyɛ sɛ sinamon no dodoɔ na momfa ngo dua mu ngo lita ɛnan. ");
INSERT INTO twiasante_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Awurade ahyɛ nnuhwamfrafoɔ a wɔaben yie, sɛ wɔmfra saa nnuhwam yi ma ɛnyɛ ngo kronkron a wɔde te onipa ho. ");
INSERT INTO twiasante_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Awurade kaa sɛ, momfa yei nte Ahyiaeɛ Ntomadan ne Apam Adaka, ");
INSERT INTO twiasante_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ne ɛpono ne ɛho nkyɛnsee ne ɔhyeɛ afɔrebukyia no ho. ");
INSERT INTO twiasante_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Saa ara nso na momfa nte afɔrebukyia no ne ɛho nneɛma ne atam ne deɛ ɛsi mu no ho. ");
INSERT INTO twiasante_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Monte ho na ɛnyɛ kronkron; biribiara a ɛbɛka saa nneɛma yi ho bɛte. ");
INSERT INTO twiasante_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Momfa nsra Aaron ne ne mmammarima ho sɛdeɛ ɛbɛyɛ a wɔn ho bɛte na wɔatumi ayɛ asɔfodwuma ama me. ");
INSERT INTO twiasante_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Na monka nkyerɛ Israelfoɔ sɛ, ‘Yei ne me srango kronkron. ");
INSERT INTO twiasante_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ɛnsɛ sɛ wɔhwie gu obiara so kwa, na ɛnsɛ sɛ mo ara ankasa nso moyɛ bi, ɛfiri sɛ, ɛyɛ kronkron enti ɛsɛ sɛ mo nso moyɛ no kronkron. ");
INSERT INTO twiasante_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Obiara a ɔbɛfra aduhwam a ɛte sɛ no anaa ɔbɛhwie bi agu obi a ɔnyɛ ɔsɔfoɔ so no, wɔbɛtwa no asuo.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Awurade hyɛɛ mmara a ɛfa aduhwam no ho maa Mose sɛ, “Fa nnuhwam aneneduro ne nworahwam ne prɛkɛsɛ hwamhwam ne ohwamfufuo gyenegyene na wɔnsusu ne nyinaa mu duru ma ɛnyɛ pɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","na fa yɛ aduhwam a wɔhyeɛ a aduhwamfrani a waben yɛ no bi, na wɔmfa nkyene mfra mu; na ɛbɛyɛ aduhwam kronkron. ");
INSERT INTO twiasante_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Monyam bi ma ɛnyɛ muhumuhu na momfa bi nsi Apam Adaka no anim baabi a mɛhyia mo wɔ Ahyiaeɛ Ntomadan no mu hɔ no. Saa aduhwam yi ne deɛ ɛyɛ kronkron koraa wɔ ne nyinaa mu. ");
INSERT INTO twiasante_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Monnyɛ bi mfa, ɛfiri sɛ, wɔakora ama Awurade enti, ɛsɛ sɛ mohunu sɛ ɛyɛ kronkron. ");
INSERT INTO twiasante_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Obiara a ɔbɛyɛ bi afa no, wɔbɛtwa no asuo.” ");
INSERT INTO twiasante_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Mayi Besaleel a ɔyɛ Uri babarima na ɔyɛ Hur nana a ɔfiri Yuda abusua mu ");
INSERT INTO twiasante_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","de Onyankopɔn Honhom ahyɛ no ma. Mama no nyansa, tumi ne adwene a ɔde bɛsi Ahyiaeɛ Ntomadan no ayɛ biribiara a ɛwɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ɔyɛ sika, dwetɛ ne kɔbere ho dwumfoɔ kɛseɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Ɔwɔ agudeɛ adwinneɛ ne nnuasene ho nimdeɛ nso. ");
INSERT INTO twiasante_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Mayi Ahisamak ba Oholiab a ɔfiri Dan abusua mu sɛ ɔnyɛ ne ɔboafoɔ. “Ɛno akyi no, mama adwumayɛfoɔ no nyinaa nimdeɛ sononko bi sɛdeɛ ɛbɛyɛ a, wɔbɛtumi adi dwuma biara a mɛkyerɛ wɔn sɛ wɔnni no: ");
INSERT INTO twiasante_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“sɛ ɛyɛ Ahyiaeɛ Ntomadan, sɛ ɛyɛ Apam Adaka, ne ahummɔborɔbea; sɛ ɛyɛ Ahyiaeɛ Ntomadan no mu ahyehyɛdeɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","sɛ ɛyɛ ɛpono no ne ɛso nneɛma; sɛ ɛyɛ sikakɔkɔɔ kaneadua ne ɛho nneɛma; sɛ ɛyɛ ohwam afɔrebukyia; ");
INSERT INTO twiasante_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","sɛ ɛyɛ ɔhyeɛ afɔrebukyia ne ɛho nneɛma; sɛ ɛyɛ kuduo ne ne nnyinasoɔ; ");
INSERT INTO twiasante_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","sɛ ɛyɛ ɔsɔfoɔ Aaron ntadeɛ kronkron fɛfɛ no ne ne mma ntadeɛ sɛdeɛ wɔbɛtumi adi asɔfoɔ; ");
INSERT INTO twiasante_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","anaasɛ ɔsra ngo no ne kronkronbea hɔ aduhwam. “Ɛsɛ sɛ wɔfa ɛkwan a mɛkyerɛ wo no so na wɔyɛ yeinom nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Ka kyerɛ wo nkurɔfoɔ Israelfoɔ no sɛ, ‘Sɛ ɛduru homeda a, wɔnhome, ɛfiri sɛ, saa homeda no na daa ɛkae apam a me ne mo apam no. Ɛboa mo ma mokae sɛ mene Awurade a meyɛ mo kronkron no. ");
INSERT INTO twiasante_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Monhome homeda no, ɛfiri sɛ, ɛyɛ ɛda kronkron. Obiara a ɔbɛbu saa mmara yi so no, ɔbɛwu. Na deɛ ɔbɛyɛ adwuma saa ɛda no nso, wɔbɛkum no. ");
INSERT INTO twiasante_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Nnansia na mode bɛyɛ adwuma. Na nnanson so no yɛ homeda a wɔntoto no ase a ɛyɛ kronkron ma Awurade. Obiara a ɔbɛyɛ adwuma homeda no, wɔbɛkum no. ");
INSERT INTO twiasante_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Momfa nna nsia nyɛ mo nnwuma nyinaa, ɛfiri sɛ, ɛda a ɛtɔ so nson no yɛ homeda kronkron ma Awurade. Saa mmara yi yɛ apam ne ahyɛdeɛ a ɛwɔ hɔ daa ma Israelfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ɛbɛyɛ daa apam a ɛda me ne Israelfoɔ ntam no ho nsɛnkyerɛnneɛ. Ɛfiri sɛ, nna nsia mu na Awurade de bɔɔ ɔsoro ne asase, ɛnna ɔhomee ɛda a ɛtɔ so nson no.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Onyankopɔn kasa kyerɛɛ Mose wɔ Sinai Bepɔ so wieeɛ no, ɔde aboɔ apono mmienu a ɔde ne nsa atwerɛ Mmaransɛm Edu no wɔ so no maa no. ");
INSERT INTO twiasante_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mose kyɛree wɔ bepɔ no so saa no, nnipa no nyinaa kɔɔ Aaron so kɔka kyerɛɛ no sɛ, “Ntɛm, yɛ anyame a wɔbɛdi yɛn anim ma yɛn, ɛfiri sɛ, yɛnhunu baabi a Mose a ɔdii yɛn anim de yɛn firi Misraim asase so baa ha no afa; ebia na biribi ayɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron nso ka kyerɛɛ wɔn sɛ, “Monyiyi mo sika nsonkawa nyinaa mmra.” ");
INSERT INTO twiasante_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Wɔyiyii wɔn nsonkawa no maa Aaron—mmaa ne mmarima ne mmarimaa ne mmaayewa nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aaron nanee sikakɔkɔɔ nsonkawa no de bɔɔ nantwie ba ohoni. Nnipa no nyinaa teaam sɛ, “Ao, Israel, yei ne mo anyame a ɔyii mo firii Misraim asase so baeɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaron hunuu sɛ nnipa no ani agye sika nantwie ba ohoni no ho no, ɔsii afɔrebukyia sii nantwie ba no anim kaa sɛ, “Ɔkyena yɛbɛhyɛ fa ama Awurade.” ");
INSERT INTO twiasante_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Wɔsɔree anɔpahema firii aseɛ bɔɔ ɔhyeɛ afɔdeɛ ne asomdwoeɛ afɔdeɛ de maa nantwie ba ohoni no. Ɛno akyi, wɔtoo ɛpono kɛseɛ bi, didi nomee, goroo abosomgorɔ, yɛɛ ahuhudeɛ hodoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Afei, Awurade ka kyerɛɛ Mose sɛ, “Yɛ ntɛm na siane kɔ wo nkurɔfoɔ a wode wɔn firi Misraim asase so baeɛ no nkyɛn, ɛfiri sɛ, wɔagu wɔn ho fi, ");
INSERT INTO twiasante_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","na wɔabu me mmara nyinaa nso so. Wɔayɛ sika nantwie ba a wɔsom no, asane abɔ afɔdeɛ nso ama no aka sɛ, ‘Ao, Israel, yei ne mo nyame a ɔyii mo firii Misraim asase so baeɛ no.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Awurade kaa sɛ, “Mahunu sɛdeɛ saa nnipa yi yɛ asoɔden na wɔsane yɛ adɔnyɛfoɔ fa. ");
INSERT INTO twiasante_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Enti afei, mede mʼabufuhyeɛ bɛtɔre wɔn ase na mama wo Mose mmom ayɛ ɔman kɛseɛ.” ");
INSERT INTO twiasante_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Nanso, Mose srɛɛ Onyankopɔn sɛ ɔnnyɛ saa. Ɔkɔɔ so sɛ, “Awurade, adɛn enti na wo bo afu atia wo ara wo nkurɔfoɔ a wonam anwanwakwan ne wo tumi so yii wɔn firii Misraim asase so yi? ");
INSERT INTO twiasante_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Wopɛ sɛ Misraimfoɔ no ka sɛ, ‘Onyankopɔn daadaa wɔn sɛ wɔmmra bepɔ no so sɛdeɛ ɔbɛnya wɔn akum wɔn, atɔre wɔn ase afiri asase so?’ Ma wo bo ntɔ wo yam na gyae adwene a woafa sɛ wode rebɛtia wo nkurɔfoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kae ɛbɔ a wohyɛɛ wʼasomfoɔ Abraham, Isak ne Israel no. Wo ara wokaa ntam sɛ, ‘Mɛma mo asefoɔ adɔɔso sɛ ɛsoro nsoromma na mede saa asase a mahyɛ mo ho bɔ yi nyinaa bɛma mo asefoɔ na wɔatena so afebɔɔ.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Na Awurade sesaa nʼadwene de wɔn ho kyɛɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Afei, Mose siane firii bepɔ no so baeɛ a ɔkura Mmaransɛm Edu no a wɔatwerɛ agu aboɔ apono mmienu akyi ne animu no. ");
INSERT INTO twiasante_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Onyankopɔn no ankasa na ɔtwerɛɛ mmaransɛm no wɔ apono no so. ");
INSERT INTO twiasante_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ɛberɛ a Yosua tee sɛ nnipa bi reyɛ gyegyeegye no, ɔka kyerɛɛ Mose sɛ, “Ɛyɛ me sɛ wɔreboaboa wɔn ho akɔ ɔko!” ");
INSERT INTO twiasante_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ɛnna Mose nso buaa no sɛ, “Ɛnnyɛ nkonimdie mu anigyeɛ anaa, nkoguo na mmom, ɛyɛ nnwontoɔ.” ");
INSERT INTO twiasante_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Wɔbɛduruu atenaeɛ hɔ, Mose hunuu nantwie ba no ne asa a wɔresa. Enti, ɔde abufuhyeɛ too twerɛ apono no hwee fam ma ɛbubuu wɔ bepɔ no ase. ");
INSERT INTO twiasante_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ɔfaa nantwie ba no nanee no wɔ ogya mu na ɛdwoeɛ no, ɔyam no muhumuhu de guu nsuo mu maa nnipa no nomeeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Afei, ɔbisaa Aaron sɛ, “Ɛdeɛn nko ara na nnipa no ka kyerɛɛ wo a enti ɛnam so maa wode saa bɔne kɛseɛ yi baa wɔn so?” ");
INSERT INTO twiasante_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron buaa no sɛ, “Mma wo bo mfu. Wo ara wonim sɛdeɛ wo nkurɔfoɔ yi yɛ nnipa bɔne fa. ");
INSERT INTO twiasante_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Wɔn ara na wɔka kyerɛɛ me sɛ, ‘Yɛ onyame bi ma yɛn na ɔnkyerɛ yɛn ɛkwan na biribi ayɛ saa Mose a ɔdii yɛn anim firii Misraim no.’ ");
INSERT INTO twiasante_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Enti, me nso mekaa sɛ, ‘Monyiyi mo sikakɔkɔɔ nsonkawa mma me.’ Wɔyiyi de maa me na mede guu ogya mu. Ɛne saa nantwie ba no.” ");
INSERT INTO twiasante_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mose hunuu sɛ Aaron ama nnipa no adane adwamammɔfoɔ ama wɔn atamfoɔ anya wɔn no, ");
INSERT INTO twiasante_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ɔgyinaa wɔn atenaeɛ hɔ ɛpono no ano teaam sɛ, “Mo a mowɔ Awurade afa no, mommra me nkyɛn.” Lewifoɔ no nyinaa kɔɔ ne nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ɔka kyerɛɛ wɔn sɛ, “Awurade Israel Onyankopɔn se, ‘Momfa mo akofena nhyehyɛ mo ho na monni mo atenaeɛ hɔ akɔneaba, na monkunkum mo nuanom, mo nnamfonom ne mo afipamfoɔ.’ ” ");
INSERT INTO twiasante_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Enti, wɔyɛɛ saa maa nnipa bɛyɛ mpensa totɔɔ ɛda no. ");
INSERT INTO twiasante_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Afei, Mose ka kyerɛɛ Lewifoɔ no sɛ, “Ɛnnɛ, moatu mo ho akyɛ sɛ mobɛsom Awurade, ɛfiri sɛ, moayɛ ɔsetie ama no ama mpo, monam so akunkum mo mma ne mo nuanom, enti ɔbɛhyira mo bebree.” ");
INSERT INTO twiasante_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Adeɛ kyee anɔpa no, Mose ka kyerɛɛ nkurɔfoɔ no sɛ, “Moayɛ bɔne a ɛso bi mmaa da, nanso mɛsane akɔ Awurade nkyɛn wɔ bepɔ no so akɔhwɛ sɛ ebia, mɛnya bɔnefakyɛ ama mo anaa.” ");
INSERT INTO twiasante_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Enti, Mose sane kɔɔ Awurade nkyɛn kɔka kyerɛɛ no sɛ, “Ao, saa nnipa yi ayɛ bɔne a ɛso bi mmaa da, na wɔde sikakɔkɔɔ ayɛ wɔn anyame. ");
INSERT INTO twiasante_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Enti, meredi ama wɔn sɛ, fa wɔn bɔne kyɛ wɔn, na sɛ ɛnte saa nso a, pepa me din firi nwoma a woatwerɛ no mu.” ");
INSERT INTO twiasante_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Awurade buaa Mose sɛ, “Obiara a wayɛ me bɔne no, mɛpepa no afiri me nwoma mu. ");
INSERT INTO twiasante_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Enti afei, kɔ na di nkurɔfoɔ no anim kɔ beaeɛ a mekyerɛɛ woɔ no na mehyɛ wo bɔ sɛ, mɛma me ɔbɔfoɔ adi wʼanim; nanso sɛ mebɛsra nkurɔfoɔ no a, mɛtwe wɔn aso wɔ wɔn bɔne no ho.” ");
INSERT INTO twiasante_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Na ɛsiane sɛ nnipa no somm Aaron nantwie ba no enti, ɔtee yadeɛ guu wɔn so. ");
INSERT INTO twiasante_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Awurade ka kyerɛɛ Mose sɛ, “Di saa nnipa a wode wɔn firi Misraim asase so no anim kɔ asase a mede hyɛɛ Abraham, Isak ne Yakob bɔ no so, ɛfiri sɛ, mekaa sɛ, ‘Mede saa asase yi bɛma wʼasefoɔ.’ ");
INSERT INTO twiasante_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mɛsoma ɔbɔfoɔ adi wʼanim na wapam Kanaanfoɔ, Amorifoɔ, Hetifoɔ, Perisifoɔ, Hewifoɔ ne Yebusifoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ɛyɛ asase a ɛwoɔ ne nufosuo sene wɔ so. Na me ne mo rentu saa ɛkwan no ɛfiri sɛ, moyɛ asoɔden ne basabasayɛfoɔ. Sɛ me ne mo kɔ a, anhwɛ a, mɛsɛe mo wɔ ɛkwan so.” ");
INSERT INTO twiasante_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Nnipa yi tee saa nsɛnhyeɛ yi, wɔtwaa agyaadwoɔ. Afei, wɔworɔworɔɔ wɔn ho nkawa ne ahyehyɛdeɛ nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Awurade ka kyerɛɛ Mose sɛ ɔnka nkyerɛ wɔn sɛ, “Moyɛ nnipa basabasayɛfoɔ ne asoɔden. Na sɛ me ne mo tena bɛyɛ simma baako pɛ koraa mpo a, anka mɛtɔre mo ase. Monworɔworɔ mo nkawa ne agudeɛ a ɛhyehyɛ mo no nyinaa kɔsi ɛberɛ a mɛhunu deɛ mɛyɛ mo.” ");
INSERT INTO twiasante_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Yei akyi no, obiara worɔɔ nʼagudeɛ wɔ Bepɔ Horeb so. ");
INSERT INTO twiasante_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Na Mose sii hyiabea ntomadan wɔ sraban no akyi a obiara a ɔpɛ sɛ ɔne Awurade di nkutaho no kɔ hɔ. Wɔtoo dan no edin “Ahyiaeɛ Ntomadan.” ");
INSERT INTO twiasante_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ɛberɛ biara a Mose bɛkɔ Ahyiaeɛ Ntomadan no mu no, nnipa no nyinaa sɔre bɛgyina wɔn ntomadan ano hwɛ no kɔsi sɛ ɔbɛduru ɛdan no ano. ");
INSERT INTO twiasante_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ɔrewura mu a, omununkum fadum bɛhyia no wɔ ɛkwan no ano na Awurade nam mu ne Mose akasa. ");
INSERT INTO twiasante_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Na nnipa no nyinaa agyina wɔn ntomadan apono ano akoto asɔre omununkum fadum no. ");
INSERT INTO twiasante_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ɛdan no mu, na Awurade kasa kyerɛ Mose animu ne animu, sɛdeɛ obi ne nʼadamfo di nkɔmmɔ. Na sɛ Mose sane kɔ nsraban no hɔ a, aberanteɛ a ɔboa no a wɔfrɛ no Yosua (Nun ba) no deɛ, ɔtena Ahyiaeɛ Ntomadan no mu ara kɔsi sɛ Mose bɛsane aba. ");
INSERT INTO twiasante_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mose ka kyerɛɛ Awurade sɛ, “Daa woka kyerɛ me sɛ, ‘Fa saa nnipa yi kɔ bɔhyɛ asase no so, nanso wonkyerɛɛ me onipa a ɔnka me ho ne me nkɔ. Wose woyɛ mʼadamfo a woayɛ me adɔeɛ bebree.’ ");
INSERT INTO twiasante_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Na sɛ saa na ɛte a, di mʼanim kyerɛ me baabi a ɛyɛ wo pɛ sɛ mefa na ama mate wo aseɛ na mafa wo kwan so pɛpɛɛpɛ. Na mma wo werɛ mfiri sɛ saa ɔman yi yɛ wo nkurɔfoɔ.” ");
INSERT INTO twiasante_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Na Awurade buaa no sɛ, “Mʼankasa me ne wo bɛkɔ na woadi nkonim.” ");
INSERT INTO twiasante_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Nanso Mose kaa sɛ, “Sɛ wo ne yɛn renkɔ deɛ a, mma yɛnntu yɛn nan mfiri ha. ");
INSERT INTO twiasante_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Sɛ wo ne yɛn ankɔ a, hwan na ɔbɛhunu sɛ me ne me nkurɔfoɔ anya wo hɔ adom a ama nsonsonoeɛ abɛda yɛn ne asase sofoɔ a aka no ntam?” ");
INSERT INTO twiasante_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Awurade buaa Mose sɛ, “Ampa ara, mɛyɛ wʼabisadeɛ ama wo, ɛfiri sɛ, woanya ahummɔborɔ afiri me nkyɛn na woyɛ mʼadamfo.” ");
INSERT INTO twiasante_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Na Mose srɛɛ sɛ ɔpɛ sɛ ɔhunu Onyankopɔn animuonyam. ");
INSERT INTO twiasante_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Awurade buaa sɛ, “Mɛma mo ahunu mʼadɔeɛ na mɛbɔ me din Awurade no akyerɛ mo. Deɛ mepɛ sɛ mehunu no mmɔbɔ no, mɛhunu no mmɔbɔ, na deɛ mepɛ sɛ meyɛ no adɔeɛ nso, mɛyɛ no adɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Nanso, morenhunu mʼanimuonyam, ɛfiri sɛ, obi bi renhunu mʼanim ntena nkwa mu. ");
INSERT INTO twiasante_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“Nanso gyina ɔbotan yi so wɔ me nkyɛn ha. ");
INSERT INTO twiasante_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Na sɛ mʼanimuonyam resene a, mede wo bɛhyɛ ɔbotan no mu na mede me nsa akata wo so kɔsi sɛ mɛtwam. ");
INSERT INTO twiasante_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Afei, mɛyi me nsa na woahunu mʼakyi, na mʼanim deɛ, worenhunu.” ");
INSERT INTO twiasante_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Awurade ka kyerɛɛ Mose sɛ, “Yɛ aboɔ twerɛ apono mmienu te sɛ deɛ woyɛɛ kane no na mɛtwerɛ mmara korɔ no ara sɛdeɛ na ɛwɔ deɛ wobubuu mu no so ara pɛ ama wo. ");
INSERT INTO twiasante_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Siesie wo ho na bra Sinai Bepɔ so anɔpa na fa wo ho bɛkyerɛ me. ");
INSERT INTO twiasante_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Mfa obiara nka wo ho na ɛnsɛ sɛ obiara bɛn bepɔ no ho baabiara. Mma mmoa biara nkɔ adidi mmɛn bepɔ no.” ");
INSERT INTO twiasante_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Enti, Mose twaa twerɛ apono mmienu te sɛ kane deɛ no de kɔɔ Sinai Bepɔ so anɔpahema sɛdeɛ Awurade hyɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Awurade siane baa sɛ omununkum fadum bɛgyinaa Mose ho bɔɔ ne din kronkron Awurade no. ");
INSERT INTO twiasante_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Awurade faa nʼanim frɛɛ no kaa sɛ, “Me, Awurade, Onyankopɔn mmɔborɔhunufoɔ ne ɔdomfoɔ a me bo kyɛre fu na mewɔ ɔdɔ na medi nokorɛ nso; ");
INSERT INTO twiasante_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","me Awurade, me dɔ nnipa mpempem na mede atirimuɔden, atuateɛ ne bɔne kyɛ. Metwe afɔdie aso na metwe Agyanom, mma ne mmanananom kɔsi awoɔ ntoatoasoɔ mmiɛnsa ne ɛnan aso.” ");
INSERT INTO twiasante_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mose kotoo Awurade somm no. ");
INSERT INTO twiasante_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ɔkaa sɛ, “Sɛ ɛyɛ nokorɛ pa ara sɛ woagye me atom deɛ a, Ao Awurade, wo ne yɛnkɔ bɔhyɛ asase no so. Saa nnipa yi yɛ asoɔden deɛ, nanso fa yɛn bɔne kyɛ yɛn na gye yɛn sɛ wo ara wo nnipa.” ");
INSERT INTO twiasante_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Awurade buaa sɛ, “Ɛyɛ, me ne wo bɛyɛ nhyehyɛeɛ bi. Merebɛyɛ anwanwadeɛ bi a ebi nsii asase so da, na ɛnam so ama Israelfoɔ nyinaa ahunu tumi a Awurade wɔ. Menam wo so na mɛyɛ saa tumideɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Wo fam deɛ a wobɛyɛ ara ne sɛ, wobɛtie nsɛm a mɛhyɛ wo no na woayɛ ne nyinaa; na sɛ ɛba saa a, mɛpam Amorifoɔ, Kanaanfoɔ, Hetifoɔ, Perisifoɔ, Hewifoɔ ne Yebusifoɔ no nyinaa afiri wʼanim. ");
INSERT INTO twiasante_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Hwɛ wo ho so yie pa ara na wo ne ɔman a worekɔ mu no mufoɔ ampam, ɛfiri sɛ, sɛ woyɛ saa a, ɛbɛma wo nso woayɛ nnebɔne a wɔyɛ no bi. ");
INSERT INTO twiasante_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Bubu wɔn abosonsom afɔrebukyia no. Sɛe wɔn aboɔ adum no na montutu wɔn abosom no ngu. ");
INSERT INTO twiasante_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Na monnsom onyame foforɔ biara nka Awurade ho, na ɔno nko ara ne Onyankopɔn a ɛsɛ sɛ mosom no. ");
INSERT INTO twiasante_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Wone onipa biara a ɔte asase no so nnyɛ asomdwoeɛ apam biara, ɛfiri sɛ, wɔnni me nokorɛ, na wɔbɔ afɔdeɛ ma wɔn anyame de tia me. Sɛ wo ne wɔn fa yɔnko a, wɔbɛto nsa afrɛ wo sɛ ma yɛnkɔsom yɛn anyame na anhwɛ yie a, wobɛkɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Afei, ɛyɛ saa a, mobɛgye wɔn mmammaa aware ama mo mmammarima no akɔsom wɔn yerenom no anyame bi de atia me. ");
INSERT INTO twiasante_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Monnsom ahoni biara. ");
INSERT INTO twiasante_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Bɔ mmɔden sɛ wɔbɛdi Apiti Afahyɛ no nnanson sɛdeɛ meka kyerɛɛ wo no. Di no afe biara mu ɔbosome Abib (Yudafoɔ bosome a ɛdi ɛkan) mu. Saa bosome no mu na motu firii Misraim. ");
INSERT INTO twiasante_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Abakan biara yɛ me dea, sɛ ɛyɛ nantwie, odwan anaa abirekyie. ");
INSERT INTO twiasante_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Afunumu ba a ɔyɛ abakan deɛ, wɔmfa no nsesa odwammaa. Na sɛ wompɛ sɛ wode no di nsesa deɛ a, bu ne kɔn mu. Mo mmammarima deɛ, monsesa wɔn nyinaa. “Obiara mma mʼanim a ɔnkura akyɛdeɛ bi. ");
INSERT INTO twiasante_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Nnansia pɛ na momfa nyɛ adwuma. Ɛda a ɛtɔ so nson no deɛ, monnni dwuma biara. Ofuntumberɛ anaa otwaberɛ mpo, momfa nna nsia nyɛ adwuma. Ɛda a ɛtɔ so nson no, monhome. ");
INSERT INTO twiasante_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Monkae na monni saa afahyɛ mmiɛnsa a ɛwɔ afe mu no nyinaa. Yeinom ne: Otwaberɛ Afahyɛ (anaasɛ Pentekoste), Atokoɔ a ɛdi ɛkan Afahyɛ ne Otwa Afahyɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Saa afahyɛ mmiɛnsa yi mu biara duru so a, ɛsɛ sɛ Israelfoɔ mmarima ne mmarimaa nyinaa ba Awurade wo Onyankopɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Sɛ mokɔ Awurade, mo Onyankopɔn, anim saa mprɛnsa no nyinaa afe biara mu a, obiara nni hɔ a ɔbɛtoa mo abɛdi mo asase no so. Mɛpam saa aman no wɔ mo anim na matrɛ mo ahyeɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Mommfa burodo a mmɔreka wɔ mu mmɔ me afɔdeɛ. Na Twam Afahyɛ ɛnam no nso, mommfa bi nsi hɔ mma adeɛ nkye so. ");
INSERT INTO twiasante_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Sɛ motwa mo mfudeɛ a, momfa otwakane mu nyiyimu a ɛsɔ ani mmrɛ me; wɔde bɛma Awurade mo Onyankopɔn. “Nnoa abirekyie ba wɔ ne maame nufosuo mu.” ");
INSERT INTO twiasante_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Na Awurade ka kyerɛɛ Mose sɛ, “Twerɛ saa mmara a mede ama wo yi nyinaa gu hɔ, ɛfiri sɛ, ɛgyina hɔ ma me ne wo ne Israel apam.” ");
INSERT INTO twiasante_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mose ne Awurade de adaduanan, awia ne anadwo, dii nkutaho wɔ bepɔ no so, na saa ɛberɛ no, Mose annidi annom. Saa ɛberɛ no, Onyankopɔn twerɛɛ Mmaransɛm Edu no guu ɛboɔ twerɛpono so. ");
INSERT INTO twiasante_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ɛberɛ a Mose de twerɛ apono no fi Onyankopɔn nkyɛn resiane bepɔ no, na ɔnnim sɛ nʼanim rehyerɛn. ");
INSERT INTO twiasante_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Esiane nʼanim hyerɛn a na ɛhyerɛn no enti, Aaron ne Israelfoɔ no hunuu Mose no, wɔsuroeɛ sɛ wɔbɛbɛn no. ");
INSERT INTO twiasante_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Nanso, Mose frɛɛ wɔn baa ne nkyɛn maa Aaron ne ɔman no mu ntuanofoɔ ne no bɛkasaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Akyire no, nnipa no nyinaa baa ne nkyɛn maa ɔde mmaransɛm a Awurade de maa no wɔ bepɔ no so hɔ no maa wɔn. ");
INSERT INTO twiasante_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mose ne wɔn kasa wieeɛ no, ɔde nkatanimu kataa nʼanim, ");
INSERT INTO twiasante_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","na ɛberɛ biara a ɔbɛkɔ Ahyiaeɛ Ntomadan mu hɔ ne Awurade akɔkasa no, ɔyi nkatanimu no kɔsi sɛ ɔbɛsane aba bio; ɔba saa a, asɛm biara a Onyankopɔn aka akyerɛ no no, na ɔno nso aka akyerɛ nnipa no ");
INSERT INTO twiasante_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","a wɔhunu sɛ nʼanim ayɛ hyerɛn. Akyire no, ɔde nkatanimu no kata nʼanim bio kɔsi sɛ ɔbɛkɔ Onyankopɔn nkyɛn na ɔne no akɔkasa. ");
INSERT INTO twiasante_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Afei, Mose frɛɛ nnipa no nyinaa ne wɔn yɛɛ nhyiamu ka kyerɛɛ wɔn sɛ, “Yei ne Awurade mmara a ɛsɛ sɛ modi so. ");
INSERT INTO twiasante_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Monyɛ adwuma nnansia. Na ɛda a ɛtɔ so nson no deɛ, momfa nhome; ɛyɛ ɛda kronkron a ɛsɛ sɛ mode som Awurade. Obiara a ɔbɛyɛ adwuma biara saa ɛda no, ɔbɛwu. ");
INSERT INTO twiasante_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ɛda no, ogya mpo, monnsɔ bi ano wɔ mo afie mu.” ");
INSERT INTO twiasante_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mose ka kyerɛɛ nnipa no nyinaa sɛ, “Nsɛm a Awurade ahyɛ sɛ monyɛ nie. ");
INSERT INTO twiasante_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Obiara a ɔpɛ no mfa saa afɔrebɔdeɛ yi mu biara mmrɛ Awurade: “sikakɔkɔɔ, dwetɛ, kɔbere mfrafraeɛ; ");
INSERT INTO twiasante_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ntoma a wɔde asaawa tuntum, bibire ne koogyan ayɛ ne abirekyie nwi, ");
INSERT INTO twiasante_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","odwennini nhoma a wɔahyɛ no kɔkɔɔ ne mmirekyie nhoma a wɔahyɛ, okuo dua; ");
INSERT INTO twiasante_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","kanea ngo, ɔsra ngo; nnuhwam a wɔhyeɛ; ");
INSERT INTO twiasante_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","aboɔ a ɛte sɛ apopobibirieboɔ ne aboɔdemmoɔ a wɔde bɛhyehyɛ asɔfotadeɛ no ne adaaboɔ no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Mo a mowɔ nimdeɛ wɔ biribi yɛ ho no, mo nyinaa mommra na monyɛ deɛ Awurade aka no nyinaa te sɛ: ");
INSERT INTO twiasante_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“Ahyiaeɛ Ntomadan no so ntoma ne ne nkatasoɔ, nkɔtɔkorɔ, aponnwa nnua a ɛsisi mu, adum ne nnyinasoɔ; ");
INSERT INTO twiasante_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Apam Adaka no ne nnua a ɛsisi ho; Mpata Beaeɛ ntwamutam a ɛkata kronkronbea hɔ, ");
INSERT INTO twiasante_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Ɛpono ne nnua a wɔde soa ne ɛho nneɛma nyinaa, Hyiadan mu Burodo; ");
INSERT INTO twiasante_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","nkanea nnua ne nʼakanea ne ngo; ");
INSERT INTO twiasante_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","aduhwam afɔrebukyia ne nnua a wɔde bɛsoa; srango ne aduhwam a ɛyi hwa pa, nsɛnanimu a wɔde bɛsɛn Ahyiaeɛ Ntomadan no ɛpono ano; ");
INSERT INTO twiasante_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","kɔbere Afɔrebukyia a wɔde bɛbɔ ɔhyeɛ afɔdeɛ, kɔbere otwitwadeɛ ne nnua a wɔde bɛsoa ho nneɛma, ne deɛ wɔsi mu nneɛma ne ne ntaamu, ");
INSERT INTO twiasante_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","adihɔ hɔ no ntwamutam, adum ne ne nnyinasoɔ, ntoma a wɔde bɛkata adihɔ hɔ ɛkwan ano, ");
INSERT INTO twiasante_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Ahyiaeɛ Ntomadan no adihɔ hɔ nnua ne ne ntampehoma, ");
INSERT INTO twiasante_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","asɔfotadeɛ a wɔapam no fɛfɛɛfɛ a wɔhyɛ kɔ kronkronbea hɔ no brɛɛ no ma ɔhwɛeɛ. Afei, wɔde Aaron asɔfotadeɛ kronkron no nso ne ne mmammarima deɛ a wɔbɛhyɛ de ayɛ asɔfodwuma no bɛkyerɛɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Enti, nnipa no nyinaa kɔɔ wɔn ntomadan mu kɔyɛɛ akyɛdeɛ no ho ahoboa. ");
INSERT INTO twiasante_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Wɔn a Onyankopɔn honhom kaa wɔn akoma no de wɔn akyɛdeɛ a wɔde bɛsi Ahyiaeɛ Ntomadan no ne ɛho nneɛma ne deɛ wɔde bɛpam atadeɛ kronkron no brɛɛ Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Mmaa ne mmarima a asɛm no kaa wɔn akoma no nyinaa baeɛ. Wɔde sikakɔkɔɔ, agudeɛ, nsonkawa, nkawa, kɔnmuadeɛ ne sikadwinneɛ bebree brɛɛ Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Wɔn a wɔwɔ ntoma pa, kuntu a ɛyɛ tuntum, bibire, abirekyie nhoma a wɔahyɛ, odwennini nhoma a wɔahyɛ no kɔkɔɔ anaa aboa nhoma a ɛyɛ fɛ nso de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Afoforɔ nso de dwetɛ ne kɔbere brɛɛ Awurade sɛ wɔn akyɛdeɛ. Ebinom de okuo nnua nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Mmaa no bi a wɔnim adepam yie no too asaawa tuntum, bibire ne koogyan de yɛɛ ntoma a ɛyɛ fɛ de brɛɛ Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Afoforɔ nso de anigyeɛ nam wɔn dom akyɛdeɛ so de abirekyie nwi yɛɛ ntoma. ");
INSERT INTO twiasante_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Mpanimfoɔ a wɔdi wɔn anim no de aboɔ a ɛte sɛ apopobibirieboɔ baeɛ sɛ wɔmfa nyɛ asɔfotadeɛ no ne nʼadaaboɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Wɔde nnuhwam ne ngo a wɔde bɛgu nkanea mu ne deɛ wɔde bɛfra srango no ne nnuhwam no ma adi mu no nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Yei di ho adanseɛ sɛ Israel mmarima ne mmaa a na wɔpɛ sɛ wɔboa dwumadie a Awurade nam Mose so de hyɛɛ wɔn nsa no firi wɔn pɛ mu de wɔn akyɛdeɛ brɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mose ka kyerɛɛ Israelfoɔ no sɛ, “Awurade ayi Besaleel, Uri ba a ɔyɛ Hur a ɔfiri Yuda abusua mu nana ");
INSERT INTO twiasante_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","no sɛ ɔno Onyankopɔn Honhom ahyɛ no ma. Wama no nyansa, tumi ne adwene a ɔde bɛsi Ahyiaeɛ Ntomadan no ayɛ biribiara a ɛwɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ɔbɛtumi adi adwini afiri sikakɔkɔɔ, dwetɛ, ne kɔbere mu. ");
INSERT INTO twiasante_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Ɔwɔ agudeɛ adwinneɛ ne nnuasene ho nimdeɛ nso. ");
INSERT INTO twiasante_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Na Onyankopɔn ama ɔno ne Oholiab a ɔyɛ Ahisamak a ɔfiri Dan abusuakuo mu babarima adom akyɛdeɛ a wɔnam so kyerɛ afoforɔ adeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Onyankopɔn ama wɔn baanu akyɛdeɛ sononko sɛ adwumfoɔ, duadwumfoɔ, adenwonofoɔ a wɔtumi nwono nneɛma a ɛyɛ fɛ gu ntoma pa a ɛyɛ tuntum, bibire ne koogyan mu. Wɔnim saa adwinneɛ yi nyinaa di ma ɛboro so. ");
INSERT INTO twiasante_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Adwumfoɔ a wɔaka a Onyankopɔn ama wɔn adom akyɛdeɛ no nyinaa bɛboa Besaleel ne Oholiab na wɔasi asiesie Ahyiaeɛ Ntomadan no mu, sɛdeɛ Awurade kaeɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Enti, Mose ka kyerɛɛ Besaleel ne Oholiab ne wɔn a wɔaka na wɔte nka sɛ ɛsɛ sɛ wɔboa dwumadie no sɛ wɔnhyɛ aseɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Mose de nneɛma a nnipa no de bɛkyɛeɛ no maa wɔn, na adekyeeɛ biara nso, na wɔnya akyɛdeɛ foforɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Akyire no, adwumayɛfoɔ no nyinaa gyaee wɔn adwumayɛ no ");
INSERT INTO twiasante_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","kɔɔ Mose nkyɛn kɔka kyerɛɛ no sɛ, “Nneɛma a yɛn nsa aka no dɔɔso sen deɛ yɛhia.” ");
INSERT INTO twiasante_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Enti, Mose somaa obi ma ɔkɔɔ wɔn nyinaa so kɔka kyerɛɛ wɔn sɛ, afei deɛ, obiara mmɛkyɛ wɔn adeɛ bio. Na obiara amfa hwee amma bio. ");
INSERT INTO twiasante_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ɛfiri sɛ, na nneɛma a wɔwɔ no bɛso dwuma no die aboro so mpo. ");
INSERT INTO twiasante_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Deɛ ɛdi ɛkan, Ahyiaeɛ Ntomadan no sie no, adenwonofoɔ pa ara no de asaawa a wɔafira yɛɛ nsɛnanotam edu a emu bi yɛ tuntum, bibire ne koogyan a wɔanwono Kerubim agu mu. ");
INSERT INTO twiasante_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Nsɛnanotam edu no nyinaa kɛseɛ yɛ pɛ. Emu biara tenten yɛ anammɔn aduanan mmienu na ne tɛtrɛtɛ nso yɛ anammɔn nsia. ");
INSERT INTO twiasante_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Wɔkekaa ntoma bamma enum sisii animu nyaa nsɛnanotam baako. Ɛnna wɔkekaa ntoma bamma enum a aka no nso sisii animu nyaa nsɛnanotam foforɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Wɔde ntoma bibire bamma aduonum wurawuraa nsɛnanotam a wɔkeka sisii animu no mu biara ano ");
INSERT INTO twiasante_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","a kantankorowa baako biara ne baako di nhwɛanimu. ");
INSERT INTO twiasante_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Afei, wɔyɛɛ sika nkɔtɔkorɔ aduonum de sosɔɔ nkantankorowa no mu maa nsɛnanotam ahodoɔ mmienu no yɛɛ nsɛnanotam baako. ");
INSERT INTO twiasante_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Wɔde ntoma nkatasoɔ dubaako a wɔde mmirekyie nwi na ayɛ ");
INSERT INTO twiasante_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","a ne nyinaa tenten yɛ anammɔn aduanan enum na ne tɛtrɛtɛ yɛ anammɔn nsia kataa Ntomadan no so. ");
INSERT INTO twiasante_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Besaleel kekaa saa nkatasoɔ yi enum sisii animu ma ɛyɛɛ bamma tenten baako ɛnna ɔsane de afoforɔ nsia sisii animu maa ɛno nso yɛɛ bamma tenten baako. ");
INSERT INTO twiasante_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Afei, ɔbobɔɔ nkantankorowa aduonum wɔ emu biara ano ");
INSERT INTO twiasante_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ɛnna ɔyɛɛ kɔbere nkɔtɔkorɔ aduonum de koakoaa nkantankorowa no, sɛdeɛ ɛbɛma nkataho no bɛkyere pintinn. ");
INSERT INTO twiasante_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Wɔsiesiee nneɛma ahodoɔ mmienu de kataa ɛdan no so. Deɛ ɛdi ɛkan no yɛ odwennini wedeɛ a wɔahyɛ no kɔkɔɔ, deɛ ɛtɔ so mmienu yɛ abirekyie wedeɛ a ɛsɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Wɔde okuo yɛɛ ntaaboo de twaa Ahyiaeɛ Ntomadan no ho. ");
INSERT INTO twiasante_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Taaboo biara ɔsorokɔ no yɛ anammɔn dunum na ne tɛtrɛtɛ nyɛ anammɔn mmienu ne kakra. ");
INSERT INTO twiasante_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Nkɔtɔkorɔ mmienu wɔ taaboo biara ase, na taaboo biara yɛ pɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Na Ahyiaeɛ Ntomadan no ntaaboo aduonu kyerɛ nʼanafoɔ ");
INSERT INTO twiasante_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","a wɔn ase sisi dwetɛ nsisisoɔ aduanan so. Nsisisoɔ no mmienu mmienu hyehyɛ taaboo biara ase. ");
INSERT INTO twiasante_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ahyiaeɛ Ntomadan no atifi fam nso, na wɔde ntaaboo aduonu atwa ho ");
INSERT INTO twiasante_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","a ɛsisi dwetɛ nsisisoɔ aduanan so a taaboo baako bɛsi nsisisoɔ mmienu so. ");
INSERT INTO twiasante_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ahyiaeɛ Ntomadan no fa a ɛkyerɛ atɔeɛ fam no yɛ nʼakyi. Ɛno nso, wɔde ntaaboo nsia na ɛtwa ho, ");
INSERT INTO twiasante_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ɛnna ne twɛtwɛwa biara so nso, ntaaboo mmienu sisi. ");
INSERT INTO twiasante_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Wɔde nkɔtɔkorɔ bɛsosɔ ntaaboo mmienu no soro ne ne fam. ");
INSERT INTO twiasante_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Enti, ntaaboo nwɔtwe na wɔde bɛyɛ ɛdan no fa hɔ a wɔde bɛsisi dwetɛ nsisisoɔ dunsia so. Taaboo biara bɛfa nsisisoɔ mmienu. ");
INSERT INTO twiasante_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Afei, ɔyɛɛ okuo nnua bi de beabeaa ntaaboo no mu. Mmeamu nnua no enum kɔ ntaaboo no fa baako. ");
INSERT INTO twiasante_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Wɔyɛɛ afoforɔ enum nso kɔɔ ɛfa baako. Na mmeamu nnua no enum nso bɔ ntaaboo a ɛwɔ ntomadan no akyi, a ani kyerɛ atɔeɛ fam no. ");
INSERT INTO twiasante_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Wɔbɔɔ mmeamu dua baako de bɔɔ ntaaboo no mfimfini. Wɔde twaa mu firi tire kɔkaa tire. ");
INSERT INTO twiasante_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Na wɔde sikakɔkɔɔ adura ntaaboo no ho, na wɔde sikakɔkɔɔ nkawa asosɔ mmeamu nnua no mu ama no agyina. Na sikakɔkɔɔ dura mmeamu nnua no nso ho. ");
INSERT INTO twiasante_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Wɔde ntoma pa a ɛyɛ tuntum, bibire ne koogyan a wɔanwono Kerubim agu mu fɛfɛɛfɛ na ayɛ ntwamutam wɔ Ntomadan no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Na wɔyɛɛ okuo nnua fadum ɛnan a wɔde sikakɔkɔɔ adura ho ne sikakɔkɔɔ nsosɔmu ɛnan maa ntwamutam no. Na fadum ɛnan no mu biara si dwetɛ nnyinasoɔ ɛnan so. ");
INSERT INTO twiasante_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Afei, wɔyɛɛ Ahyiaeɛ Ntomadan no ano nkatanimu. Wɔde asaawatam a ɛyɛ fɛ a wɔde tuntum, bibire ne koogyan adi mu adwini na ɛyɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Wɔde nkɔtɔkorɔ enum na asosɔ saa nkatanimu yi de akyekyere nnua enum no. Nnua no ne ɛho nneɛma ne mpomma no nyinaa, wɔde sikakɔkɔɔ adura ho na ne nnyinasoɔ enum no nso, wɔde kɔbere na ɛyɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Afei, Besaleel yɛɛ Apam Adaka no. Ɔde okuo na ɛyɛeɛ. Na ne tenten yɛ anammɔn mmiɛnsa ne fa, ne tɛtrɛtɛ nso yɛ anammɔn mmienu ne fa ɛnna ne ɔsorokɔ nso yɛ anammɔn mmienu ne fa. ");
INSERT INTO twiasante_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Na wɔde sikakɔkɔɔ duraa ɛho ne emu nyinaa ɛnna wɔde sikakɔkɔɔ hankra twaa ho hyiaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Na wɔde sikakɔkɔɔ nkawa ahyehyɛ ne nan ɛnan no ho, a nkawa mmienu wɔ ɛfa baako na mmienu a aka no nso wɔ ɛfa baako. ");
INSERT INTO twiasante_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ɔsenee okuo nnua bi de sikakɔkɔɔ duraa ho. ");
INSERT INTO twiasante_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ɛnna wɔde nnua no hyehyɛɛ adaka no nkyɛn nkawa no mu, na wɔde asoa. ");
INSERT INTO twiasante_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Afei, ɔde sikakɔkɔɔ mapa yɛɛ ne mmuasoɔ a wɔfrɛ no Mpata Dwa. Na ne ntentenemu yɛ anammɔn mmiɛnsa ne fa, ɛnna ne tɛtrɛtɛ nso yɛ anammɔn mmienu ne fa. ");
INSERT INTO twiasante_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ɔboroo sikakɔkɔɔ ma ɛyɛɛ trawa de yɛɛ Kerubim mmienu ɛnna ɔde tetaree adaka no mmuasoɔ etire ne etire. ");
INSERT INTO twiasante_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Wɔde Kerubim no tetare adaka no ti ne nʼanafoɔ, na ɛne adaka no nkatasoɔ no yɛɛ mua. ");
INSERT INTO twiasante_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Na Kerubim no di nhwɛanimu a wɔasisi wɔn ti ase rehwɛ Mpata Dwa no na wɔatrɛtrɛ wɔn ntaban mu akata so. ");
INSERT INTO twiasante_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Afei, ɔde okuo yɛɛ ɛpono a ne tenten yɛ anammɔn mmiɛnsa; ne tɛtrɛtɛ yɛ anammɔn baako ne fa ɛnna ne ɔsorokɔ yɛ anammɔn mmienu ne fa. ");
INSERT INTO twiasante_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Na wɔde sikakɔkɔɔ adura ho, ɛnna wɔayɛ ɛho sika hankra ahyia. ");
INSERT INTO twiasante_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Wɔyɛɛ adaka no ho mfomfamho a ne tɛtrɛtɛ yɛ nsateakwaa ɛnan twaa ɛpono no ntɛntɛnoa ho hyiaeɛ, na wɔde sikakɔkɔɔ hankra faa ho. ");
INSERT INTO twiasante_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Afei, ɔyɛɛ sikakɔkɔɔ nkawa ɛnan na ɔde hyehyɛɛ ɛpono no nan ɛnan no nyinaa ase. ");
INSERT INTO twiasante_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ɔde nnua no hyehyɛɛ saa nkawa no mu a wɔde bɛpagya ɛpono no asoa. ");
INSERT INTO twiasante_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ɔde okuo nnua a ɔde sikakɔkɔɔ agu ho yɛɛ nnua a wɔde bɛsoa. ");
INSERT INTO twiasante_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ɔde sikakɔkɔɔ amapa yɛɛ nwowaa, nsukuruwa ne nkoraa. Saa nneɛma yi na wɔde bɛdi ahwiesa afɔrebɔ ho dwuma. ");
INSERT INTO twiasante_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Bio, ɔde sikakɔkɔɔ a wɔaboro yɛɛ kaneadua. Ne nnyinasoɔ, nʼabaa, deɛ wɔde nkanea no hyehyɛ mu ne nhwiren a wɔde siesiee no nyinaa bom yɛ adeɛ fua. ");
INSERT INTO twiasante_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Kaneadua no wɔ nkorabata nsia a mmiɛnsa wɔ ɛfa na mmiɛnsa nso wɔ ɛfa. ");
INSERT INTO twiasante_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Wɔde nhwiren mmiɛnsa siesiee nkorabata biara ho. ");
INSERT INTO twiasante_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na saa ara nso na kaneadua no, wɔadi nhwiren a ɛyɛ fɛ bi adwini de asiesie no. ");
INSERT INTO twiasante_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Nhwiren no bi wɔ ne dua no ase wɔ nkorabata mmienu biara ase. Afei, nhwiren no bi wɔ nkorabata mmienu a ɛwɔ aseɛ no ase, ɛnna ebi nso wɔ nkorabata mmienu a ɛwɔ ɔsoro no so. Ne nyinaa yɛ nsia. ");
INSERT INTO twiasante_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Deɛ wɔde siesiee kaneadua no ne ne nkorabata no nyinaa yɛ adeɛ fua a sikakɔkɔɔ amapa a wɔaboro na wɔde yɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Afei, ɔyɛɛ nkanea nson, adaban akapɛ, ne apaawa. Ne nyinaa wɔde sikakɔkɔɔ amapa na ɛyɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Na kaneadua no ne ɛho nneɛma mu duru yɛ kilogram aduasa ɛnan a ne nyinaa yɛ sikakɔkɔɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Wɔde okuo na ɛyɛɛ aduhwam afɔrebukyia no. Wɔyɛɛ no ahinanan a ne fa biara susu nsateakwaa dunwɔtwe. Na ne ɔsorokɔ yɛ anammɔn mmiɛnsa a mmɛn a ɛtuatua ne ntweaso ntweaso no nso nyinaa ka bom ma ɛyɛ adeɛ fua. ");
INSERT INTO twiasante_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ɔde sikakɔkɔɔ kataa ne soro, ne nkyɛn ne mmɛn a ɛwɔ afɔrebukyia no ho no nyinaa. Na ɔde sikakɔkɔɔ ntotoano twaa afɔrebukyia no ho nyinaa hyiaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Na ɔyɛɛ sikakɔkɔɔ nkawa mmienu de bobɔɔ afɔrebukyia no afanu nkyɛn mu wɔ aseɛ hɔ a wɔde nnua a wɔde bɛsoa no bɛwurawura mu. ");
INSERT INTO twiasante_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Nnua a na wɔde soa no yɛ okuo nnua a wɔde sikakɔkɔɔ adura ho. ");
INSERT INTO twiasante_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ɔfaa nnuhwamyɛfoɔ mu abenfoɔ ɛkwan so yɛɛ srango kronkron a wɔde sra asɔfoɔ ne ɔhyeɛ nnuhwam nso. ");
INSERT INTO twiasante_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ɔhyeɛ afɔrebukyia no nso, okuo na wɔde yɛeɛ. Wɔyii no ahinanan a ne fa biara susu anammɔn nson ne fa na ne ɔsorokɔ nso yɛ anammɔn ɛnan ne fa. ");
INSERT INTO twiasante_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ne ntweaso ɛnan no nyinaa na mmɛn tuatua ho a ne nyinaa ka bom ma ɛyɛ adeɛ fua a wɔde kɔbere adura ho. ");
INSERT INTO twiasante_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Wɔyɛɛ afɔrebukyia no ho nneɛma te sɛ nkukuo, sofi, atam, adinam ne nkyɛnsee a wɔbɛnoa mu de kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Afei, ɔde kɔbere nwonoo afɔrebukyia no ho otwidadeɛ a ɛte sɛ atena de sii adaka a ɛbɛdeda egya adaka no mfimfini. ");
INSERT INTO twiasante_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Wɔde nkawa ɛnan ɛnan sensɛnee otwidadeɛ no fa biara a wɔde nnua a wɔde bɛsoa no hyehyɛɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Okuo nnua a wɔde kɔbere adura ho na wɔde yɛɛ nnua a wɔde bɛsoa. ");
INSERT INTO twiasante_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Wɔde nnua a wɔde soa no hyehyɛɛ nkawa no a ɛbobɔ afɔrebukyia no nkyɛn no mu. Ntaaboɔ na wɔde yɛeɛ. Na emu da ɛkwan nso. ");
INSERT INTO twiasante_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Wɔde kɔbere a wɔatwa afiri kɔbere ahwehwɛ a mmaa a wɔsom wɔ Ahyiaeɛ Ntomadan no ano no de kyɛeɛ no na ɛyɛɛ adeɛ a wɔsi mu nneɛma ne ne ntaaseɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Afei, wɔyɛɛ adihɔ. Fasuo a ɛwɔ nʼanafoɔ no, na ne tenten yɛ anammɔn ɔha aduonum a wɔde nnurahotam a wɔde asaawatam a ɛyɛ fɛ na ɛyɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Nnua aduonu a ɛsisi kɔbere nnyinasoɔ aduonu mu na ɛsosɔ mu. Dwetɛ nkɔtɔkorɔ ne dwetɛ ntweaa a ɛfomfam dwetɛ afadum no ho no nso sosɔ nsɛnanimu no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Na atifi ɔfasuo no tenten yɛ anammɔn ɔha ne aduonum a kɔbere nnua aduonu ne ne nnyinasoɔ a dwetɛ nkɔtɔkorɔ ne mpomma ka ho. ");
INSERT INTO twiasante_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Atɔeɛ fam ɔfasuo no tɛtrɛtɛ yɛ anammɔn aduɔson enum. Wɔde nnurahotam na ɛyɛɛ ɔfasuo no. Nnua edu, ne nnyinasoɔ ne dwetɛ nkɔtɔkorɔ ne ntweaa na na ɛma saa ɔfasuo no gyina. ");
INSERT INTO twiasante_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Apueeɛ fam nso, na ne trɛ yɛ anammɔn aduɔson enum. ");
INSERT INTO twiasante_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Na adihɔ hɔ ɛkwan no wɔ apueeɛ fam a wɔde nkatanimu mmienu akata hɔ. Na nkatanimu a ɛwɔ nifa so no tenten yɛ anammɔn aduonu mmienu ne fa. Na nnua mmiɛnsa a ɛsisi nnyinasodeɛ mmiɛnsa mu na na ɛkura mu. ");
INSERT INTO twiasante_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Na nkatanimu a ɛwɔ benkum so no nso tenten yɛ anammɔn aduonu mmienu ne fa a nnua mmiɛnsa a ɛsisi nnyinasodeɛ mmiɛnsa mu kura mu. ");
INSERT INTO twiasante_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Asaawatam a ɛyɛ fɛ na wɔde nwonoo nnurahotam a wɔde twaa adihɔ hɔ no ho. ");
INSERT INTO twiasante_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Na dua biara wɔ ne kɔbere nnyinasodeɛ, nanso ɛho nkɔtɔkorɔ ne mpomma no yɛ dwetɛ; nnua no atifi nyinaa na wɔde dwetɛ agu so na mpomma a wɔde bɛsosɔ nnurahotam no mu no nso, na ne nyinaa yɛ dwetɛ amapa. ");
INSERT INTO twiasante_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Asaawatam a wɔde tuntum, bibire ne koogyan anwono mu fɛfɛɛfɛ na wɔde yɛɛ nnurahotam kataa adihɔ hɔ ɛkwan no ano. Na ne tenten yɛ anammɔn aduasa na ne tɛtrɛtɛ nso yɛ anammɔn nson ne fa te sɛ nnurahotam a wɔde duraa adihɔ hɔ afasuo no ho no. ");
INSERT INTO twiasante_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Nnua ɛnan na na ɛsɛn so, na nnua no nso gyina kɔbere nnyinasodeɛ ɛnan a dwetɛ nkɔtɔkorɔ ne mpomma ka ho nso. Nnua no so nyinaa yɛ dwetɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Nnadewa a wɔde sii Ahyiaeɛ Ntomadan no ne adihɔ hɔ no nyinaa yɛ kɔbere. ");
INSERT INTO twiasante_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Yei ne ɛkwan a wɔfaa so sii Ahyiaeɛ Ntomadan a wɔde Apam Adaka no bɛsi mu no sɛdeɛ ɛbɛyɛ a Lewifoɔ no bɛtumi ayɛ wɔn asɔfodwuma. Ɛkwan a Mose kyerɛɛ wɔn sɛ wɔmfa so nsi no ara so na wɔfaeɛ. Ɔsɔfoɔ Aaron ba Itamar na ɔhwɛɛ dwumadie no so. ");
INSERT INTO twiasante_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Na Hur ba Uri ba Besaleel a ɔfiri Yuda abusuakuo mu no yɛɛ deɛ Awurade hyɛɛ Mose nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ne ɔboafoɔ ne Oholiab a ɔyɛ Ahisamak a ɔfiri Dan abusua mu ba. Na ɔno nso yɛ odwumfoɔ a ɔtumi twa atwerɛ gu nneɛma mu. Afei na ɔyɛ adenwonofoɔ a ɔtumi de asaawatam tuntum, bibire ne koogyan di adwini gu ntoma mu. ");
INSERT INTO twiasante_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Nnipa no de sikakɔkɔɔ kilogram apem baeɛ. Wɔde ne nyinaa nso yɛɛ Ahyiaeɛ Ntomadan no ho adwuma. ");
INSERT INTO twiasante_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Dwetɛ a asafo no mu nnipa no de baeɛ yɛ kilogram mpem mmiɛnsa ne ahanan (3,400). ");
INSERT INTO twiasante_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Saa dwetɛ yi firi ɛtoɔ a wɔtwa maa mmarima a wɔadi mfeɛ aduonu rekorɔ a wɔkan wɔn no. Wɔgye firii mmarima mpem ahansia ne mmiɛnsa, ahanum ne aduonum hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Kronkronbea hɔ nnyinasoɔ ɔha ne mpunan a ɛsosɔ ntwamutam no mu no bɛhia dwetɛ kilogram mpem mmiɛnsa ne ahanan. Enti nnyinasoɔ biara bɛyɛ dwetɛ kilogram aduasa ɛnan. ");
INSERT INTO twiasante_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Dwetɛ kilogram aduonu a ɛkaeɛ no nso, wɔde yɛɛ nnua no de bi duraa apampam, de bi yɛɛ mpomma no ne nkɔtɔkorɔ no. ");
INSERT INTO twiasante_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Kɔbere mfrafraeɛ a wɔde baeɛ no nso, na ɛyɛ kilogram mpem mmienu ne ahanan (2,400). ");
INSERT INTO twiasante_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ɛno na wɔde yɛɛ adum no nnyinasoɔ wɔ Ahyiaeɛ Ntomadan no ɛkwan ano. Ɛno bi ara na wɔde yɛɛ kɔbere mfrafraeɛ afɔrebukyia, kɔbere mfrafraeɛ otwidadeɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","afɔrebukyia no so nneɛma, adum no nnyinasodeɛ a ɛkura nnurahotam a ɛtwa adihɔ no ho hyia no ne nnadewa a wɔde si Ahyiaeɛ Ntomadan no de yɛɛ adihɔ hɔ adwuma nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Nnipa no de ntoma tuntum, bibire ne koogyan a ɛyɛ fɛ pam asɔfotadeɛ maa asɔfoɔ no a wɔde bɛsom wɔ kronkronbea hɔ. Saa ntadetam no ara bi na wɔde pam Aaron ntadeɛ kronkron no sɛdeɛ Awurade ka kyerɛɛ Mose no. ");
INSERT INTO twiasante_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Wɔde asaawatam bi a wɔanwono afiri asaawa a wɔafira mu na wɔpam asɔfotadeɛ nkataseɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Besaleel boroo sikakɔkɔɔ ma ɛyɛɛ trawa, ɛnna ɔtwitwaa no nteawanteawa sɛ ahoma na ɔde bobɔɔ ntoma tuntum, bibire ne koogyan no mu. Ɛyɛ nsaanoadwuma a ɛte apɔ yie. ");
INSERT INTO twiasante_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Wɔde nhoma a wɔapam sosɔɔ nkataseɛ no mu firi aseɛ bɛsii mmati nhoma mmienu no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ɛnna wɔde abɔwomu no yɛɛ ntoma korɔ no ara bi. Na ɛyɛ nsaawatam a ɛyɛ akokɔsradeɛ, tuntum, bibire ne koogyan, sɛdeɛ Awurade ka kyerɛɛ Mose no. ");
INSERT INTO twiasante_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Apopobibirieboɔ mmienu a wɔtwa de fomfamm mmati nhoma mmienu no a ɛsɔ asɔfotadeɛ no nkataseɛ no mu no, wɔde sikakɔkɔɔ twerɛɛ Israelfoɔ mmusuakuo no nyinaa din guu so sɛdeɛ wɔtwerɛ nsateaa so kawa so no. ");
INSERT INTO twiasante_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Saa aboɔdemmoɔ yi sisi asɔfotadeɛ no mmati so, na ɛyɛ nkaedeɛ de ma Awurade fa Israelfoɔ ho, na wɔyɛɛ ne nyinaa sɛdeɛ Awurade ka kyerɛɛ Mose sɛ wɔnyɛ no no ara pɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Adaaboɔ no, wɔpamm no te sɛ asɔfotadeɛ a wɔde nwera amapa yɛeɛ, na wɔde sikakɔkɔɔ ahoma ne asaawa tuntum, bibire ne koogyan anwene mu. ");
INSERT INTO twiasante_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ɛyɛ ntomasini bi a wɔatwa no ahinanan na ɛfa biara susu nsateakwaa nkron a wɔapam afam so ama ayɛ sɛ kotokuo ");
INSERT INTO twiasante_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","a aboɔdemmoɔ a wɔde asesa so nsesasoɔ nsesasoɔ ɛnan wɔ mu. Nsesasoɔ a ɛdi ɛkan no yɛ bogyanamboɔ, akarateboɔ ne ahahammonoboɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Nsesasoɔ a ɛtɔ so mmienu no yɛ nsrammaboɔ, aboɔdemmoɔ ne dɛnkyɛmmoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Deɛ ɛtɔ so mmiɛnsa no yɛ akutuhonoboɔ, mfrafraeɛboɔ ne beredumboɔ ");
INSERT INTO twiasante_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ɛnna deɛ ɛtɔ so ɛnan no yɛ sikabereɛboɔ, apopobibirieboɔ ne ahwehwɛboɔ a emu biara wɔde sikakɔkɔɔ atwa ho ahyia. ");
INSERT INTO twiasante_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Wɔyɛɛ aboɔdemmoɔ no te sɛ nsɔanodeɛ bi twerɛɛ Israel mmusuakuo dumienu no din guu so. ");
INSERT INTO twiasante_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Sɛdeɛ ɛbɛyɛ a wɔbɛtumi de adaaboɔ no asɔ asɔfotadeɛ no mu no, wɔde sikakɔkɔɔ nkawa hyehyɛɛ asɔfotadeɛ no mmati ntaresoɔ mmienu no so. ");
INSERT INTO twiasante_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Wɔsane yɛɛ sikakɔkɔɔ nkawa mmienu de hyehyɛɛ adaaboɔ no ntwɛtwɛaso soro. ");
INSERT INTO twiasante_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Wɔde sikakɔkɔɔ nhoma mmienu no hyehyɛɛ sikakɔkɔɔ nkawa a ɛwɔ adaaboɔ no mu no. ");
INSERT INTO twiasante_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Wɔbɛkyekyere nhoma mmienu no ti de abobɔ sikakɔkɔɔ no a ɛbɔ asɔfotadeɛ no abatiri so no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Wɔde sikakɔkɔɔ nkawa mmienu nso hyehyɛɛ adaaboɔ no ntwea mmienu no so a ɛgu asɔfotadeɛ no so pɛɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Wɔde sikakɔkɔɔ nkawa mmienu sosɔɔ asɔfotadeɛ no mmati ntaresoɔ no mu ma ɛbɛnee abɔwomu a wɔanwono no fɛfɛɛfɛ ne asɔfotadeɛ no ahyiaeɛ so. ");
INSERT INTO twiasante_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Sɛdeɛ ɛbɛyɛ na adaaboɔ no bɛgyina pɛpɛɛpɛ wɔ abɔwomu fɛfɛ no so enti, wɔde ntoma tuntum kyekyeree nkawa a ɛsosɔ adaaboɔ no ne asɔfotadeɛ no mu. Yeinom nyinaa, Awurade na ɔhyɛɛ Mose sɛ wɔnyɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Asɔfotadeɛ no fa kɛseɛ no ara deɛ, wɔde ntoma tuntum na ɛnwonoeɛ ");
INSERT INTO twiasante_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","na wɔtwaa mfimfini tokuro pempam bi faa so maa ano no yɛɛ den sɛdeɛ wɔhyɛ a ɛrentete. ");
INSERT INTO twiasante_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Na wɔde bibire ne ateaa a ɛberedum ne koogyan a wɔafira yɛɛ biribi te sɛ ateaa aba de sensɛnee batakari no ase mmuano no ano. ");
INSERT INTO twiasante_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Na wɔde sikakɔkɔɔ yɛɛ nnɔnnɔmma na wɔde biribi te sɛ ateaa aba no hyehyɛɛ ntam ne ntam wɔ batakari no ase mmuano no ano de twaa ho hyiaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Sɛ Aaron hyɛ asɔfotadeɛ yi a wɔde sikakɔkɔɔ nnɔmma ne ateaa aba agu ano a, na ɛkyerɛ sɛ ɔrekɔsom Awurade sɛdeɛ Awurade hyɛɛ Mose sɛ ɔnyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Wɔde asaawatam a ɛyɛ fɛ pam asɔfotadeɛ no bi maa Aaron ne ne mmammarima. ");
INSERT INTO twiasante_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Wɔde ntoma a ɛyɛ fɛ na ɛpam adaaboɔ, abotire, ɛkyɛ ne nhyɛasetam ahodoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Bio, wɔde ntoma a ɛyɛ fɛ na ɛpam abɔwomu no na wɔde asaawa tuntum, bibire ne koogyan dii mu adwini sɛdeɛ Awurade kyerɛɛ Mose sɛ ɔnyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Na afei, wɔboroo sikakɔkɔɔ amapa ma ɛyɛɛ trawa sɛ prɛte a wɔatwerɛ so: Kronkron Ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Wɔde ntoma tuntum na asina abɔnimu no abɔ abotire no mu sɛdeɛ Awurade kyerɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Yei nyinaa akyi, wɔwiee Ahyiaeɛ Ntomadan no si sɛdeɛ Awurade kyerɛɛ Mose sɛ wɔnsi no no. ");
INSERT INTO twiasante_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Afei, wɔde Ahyiaeɛ Ntomadan no ne emu nneɛma nyinaa brɛɛ Mose: Nkyerewa, nnyinasoɔ, mmeamu nnua, mpunan ne nsisisoɔ; ");
INSERT INTO twiasante_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","nnwennini nhoma a wɔahyɛ no kɔkɔɔ, abirekyie nhoma a wɔahyɛ, nsɛnanotam, ");
INSERT INTO twiasante_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","adaka no a Mmaransɛm Edu no wɔ mu ne nnua a wɔde soa Mpata Dwa no; ");
INSERT INTO twiasante_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Ɛpono no ne ɛho nneɛma ne Hyiadan mu Burodo; ");
INSERT INTO twiasante_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Sika nkaneadua ne nʼakanea, ɛho nneɛma ne ngo ");
INSERT INTO twiasante_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Sikakɔkɔɔ afɔrebukyia, srango, aduhwam ne Ahyiaeɛ Ntomadan no nsɛnanotam; ");
INSERT INTO twiasante_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Kɔbere afɔrebukyia, kɔbere otwidadeɛ, nnua no ne ɛho nneɛma, deɛ wɔsi mu nneɛma ne ne ntaamu; ");
INSERT INTO twiasante_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ntwahotam a wɔde twa adihɔ hɔ ɔfasuo ho, ne ɛho nnua a ɛsosɔ mu, nnyinasodeɛ ne ntwahotam a ɛwɔ adihɔ ɛpono ano, ntampehoma ne nnadewa ne biribiara a wɔde boaa Ahyiaeɛ Ntomadan no sie. ");
INSERT INTO twiasante_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Wɔde asɔfotadeɛ a wɔapam no fɛfɛɛfɛ a wɔhyɛ kɔ kronkronbea hɔ no brɛɛ no ma ɔhwɛeɛ. Afei, wɔde Aaron asɔfotadeɛ kronkron no nso ne ne mmammarima deɛ a wɔbɛhyɛ de ayɛ asɔfodwuma no bɛkyerɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Enti, Israelfoɔ no dii nsɛm a Awurade ka kyerɛɛ Mose sɛ ɔnka nkyerɛ wɔn no nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Na Mose hwɛɛ nnwuma no nyinaa hunuu sɛ biribiara ntɔ kyema wɔ ho no, ɔhyiraa wɔn, ɛfiri sɛ, sɛdeɛ Awurade kaeɛ no ara pɛ na wɔyɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Afei Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Bosome a ɛdi ɛkan no ɛda a ɛdi ɛkan no na si Ahyiaeɛ Ntomadan no. ");
INSERT INTO twiasante_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Wosi wie a, fa Apam Adaka a Mmaransɛm Edu no wɔ mu no si mu. Na fa ntwamutam no tware Apam Adaka no anim ma ɛnhyɛ kronkron mu kronkron hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Afei, fa ɛpono no bɛsi hɔ na fa ɛho nneɛma nyinaa gu so na fa kaneadua no bra na sɔ kanea no. ");
INSERT INTO twiasante_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Fa sikakɔkɔɔ afɔrebukyia a wɔbɛhye aduhwam wɔ so no bɛsi Apam Adaka no anim. Fa ɛpono no nkatanimu sɛn Ahyiaeɛ Ntomadan no ano. ");
INSERT INTO twiasante_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Fa ɔhyeɛ afɔdeɛ afɔrebukyia no si Ahyiaeɛ Ntomadan no ɛkwan ano. ");
INSERT INTO twiasante_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Fa atam no si Ahyiaeɛ Ntomadan no ne afɔrebukyia no ntam na hyɛ no nsuo ma. ");
INSERT INTO twiasante_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Afei, siesie adihɔ bi twa Ahyiaeɛ Ntomadan no ho hyia na fa nsɛnanimu no sɛn ne kwan no ano. ");
INSERT INTO twiasante_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Fa srango no na pete gu Ahyiaeɛ Ntomadan no so baabiara ne biribiara a ɛwɔ mu ne nneɛma a ɛwɔ hɔ nyinaa ne nkonnwa so, na fa te ho. ");
INSERT INTO twiasante_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ɔhyeɛ afɔdeɛ afɔrebukyia no ne ɛho nneɛma nyinaa nso, pete ɔsra ngo no bi gu so na te ho na ɛnyɛ kronkron. ");
INSERT INTO twiasante_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Afei, fa ngo no bi sra atam no ne ne ntaamu no so fa te ho. ");
INSERT INTO twiasante_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Afei, fa Aaron ne ne mmammarima no bra Ahyiaeɛ Ntomadan no ɛkwan ano na fa nsuo hohoro wɔn ho ");
INSERT INTO twiasante_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","na fa atadeɛ kronkron no hyɛ Aaron, na sra no ngo na ne ho nte na ɔmmɛyɛ me ɔsɔfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Afei, fa ne mmammarima no bra na fa wɔn ntadeɛ hyehyɛ wɔn ");
INSERT INTO twiasante_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","na pete ngo gu wɔn so sɛdeɛ woyɛɛ wɔn agya no, sɛdeɛ wɔbɛsom me sɛ asɔfoɔ. Wɔn ngosra no bɛtena hɔ daa firi awo ntoatoasoɔ so akɔsi awo ntoatoasoɔ so. Na daa wɔn asefoɔ bɛyɛ asɔfoɔ.” ");
INSERT INTO twiasante_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Enti, Mose kɔ kɔyɛɛ sɛdeɛ Awurade akyerɛ no no. ");
INSERT INTO twiasante_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Afe a ɛtɔ so mmienu no mu bosome a ɛdi ɛkan no ɛda a ɛdi ɛkan no, wɔkekaa Ahyiaeɛ Ntomadan no sisii animu. ");
INSERT INTO twiasante_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mose sii Ahyiaeɛ Ntomadan no; ɔde nsisisoɔ no sisii wɔn afa, de nnyinasoɔ no hyehyɛɛ mu de mmeamu nnua beabeaa mu de mpunan sisii wɔn afa. ");
INSERT INTO twiasante_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Afei, ɔde nkurusoɔ no kuruu mponnwa no so de ne ngugusoɔ guguu so sane de ngugusoɔ a ɛdi akyire kuruu so sɛdeɛ Awurade se ɔnyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ɔde aboɔ a wɔatwerɛ Mmaransɛm Edu no wɔ so no guu Apam Adaka no mu de nnua a wɔdebɛsoa no sosɔɔ mu. Ɔde ne nkatasoɔ a wɔde sikakɔkɔɔ ayɛ a ɛyɛ mpata nkatasoɔ no kataa so. ");
INSERT INTO twiasante_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Afei, ɔde Apam Adaka no bɛsii Ahyiaeɛ Ntomadan no mu de ntwamutam no twaa mu, sɛdeɛ Awurade hyɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Afei, ɔde ɛpono no sii Ahyiaeɛ Ntomadan no atifi fam wɔ ntwamutam no akyi, ");
INSERT INTO twiasante_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","de Ɔkyerɛ Burodo no too so wɔ Awurade anim sɛdeɛ Awurade hyɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ɔde kaneadua no sii ɛpono no nkyɛn wɔ Ahyiaeɛ Ntomadan no anafoɔ fam. ");
INSERT INTO twiasante_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Afei, ɔsɔɔ kanea no wɔ Awurade anim sɛdeɛ Awurade kyerɛɛ no no pɛpɛɛpɛ, ");
INSERT INTO twiasante_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ɛnna ɔde sikakɔkɔɔ afɔrebukyia sii ntwamutam no ho pɛɛ wɔ Ahyiaeɛ Ntomadan no mu. ");
INSERT INTO twiasante_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Afei, wɔde ohwam hyee nnuhwam sɛdeɛ Awurade hyɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ɔde Ahyiaeɛ Ntomadan no ano nsɛnanotam sɛnee ano. ");
INSERT INTO twiasante_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ɔde afɔrebukyia a wɔbɔ ɔhyeɛ afɔdeɛ wɔ so no si bɛn Ahyiaeɛ Ntomadan ɛkwan no ano, ɛnna ɔbɔɔ so ɔhyeɛ afɔdeɛ ne aduane afɔdeɛ sɛdeɛ Awurade hyɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Yei akyi, ɔde atam a wɔsi mu nneɛma no sii Ahyiaeɛ Ntomadan no ne afɔrebukyia no ntam na wɔhyɛɛ no nsuo ma sɛdeɛ asɔfoɔ no bɛnya bi ahohoro wɔn ho. ");
INSERT INTO twiasante_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mose ne Aaron ne Aaron mmammarima hohoroo wɔn nsa ho ne wɔn nan ase wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ɛberɛ biara a wɔbɛfa afɔrebukyia no ho akɔ Ahyiaeɛ Ntomadan no mu no, wɔgyina hohoroo wɔn ho sɛdeɛ Awurade kyerɛɛ Mose no. ");
INSERT INTO twiasante_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ɔsii biribi twaa Ahyiaeɛ Ntomadan no ne afɔrebukyia no ho hyiaeɛ na wɔde nsɛnanotam sɛnee ano. Enti Mose yɛɛ yei de wiee nʼadwumayɛ. ");
INSERT INTO twiasante_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Omununkum no bɛkataa Ahyiaeɛ Ntomadan no so maa Awurade animuonyam hyɛɛ no ma. ");
INSERT INTO twiasante_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Esiane sɛ na omununkum no asi wɔ hɔ no enti, Mose antumi ankɔ mu na Awurade animuonyam hyɛɛ Ahyiaeɛ Ntomadan no ma. ");
INSERT INTO twiasante_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ɛberɛ biara a omununkum no bɛpagya ne ho atu atene no, na Israelfoɔ no nso di akyire. ");
INSERT INTO twiasante_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Na sɛ ɛgyina a, na wɔn nso agyina kɔsi sɛ ɛbɛtu atene bio. ");
INSERT INTO twiasante_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Awiaberɛ mu deɛ, Awurade omununkum no gyina Ahyiaeɛ Ntomadan no so na sɛ ɛduru anadwo a, na ogya asɔ wɔ omununkum no mu sɛdeɛ Israelfoɔ no nyinaa bɛhunu. Yei toaa so saa ara wɔ wɔn akwantuo no nyinaa mu.");
INSERT INTO twiasante_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Afei, Awurade kasa firii Ahyiaeɛ Ntomadan no mu kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Kyerɛ Israelfoɔ no sɛ, ‘sɛ morebɔ Awurade afɔdeɛ a, momfa mo anantwie ne mo nnwan no bi na mommɔ saa afɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Sɛ mo afɔrebɔdeɛ a mode rebɛbɔ ɔhyeɛ afɔdeɛ no yɛ nantwie a ɔfiri mo nantwibuo mu a, momfa nantwie a ɔnnii dɛm na mommɔ saa afɔdeɛ no sɛdeɛ ɛbɛsɔ Awurade ani. Fa aboa no kɔ Ahyiaeɛ Ntomadan no ɛpono ano na ɛhɔ na asɔfoɔ no bɛgye wʼayɛyɛdeɛ a wode rebrɛ Awurade no. ");
INSERT INTO twiasante_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ɛsɛ sɛ onipa a ɔde aboa no reba no de ne nsa gu aboa no tiri so sɛ mpatadeɛ ma afɔrebɔni no. Onyankopɔn bɛpɛ aboa no wuo sene sɛ afɔrebɔni a ɔde saa aboa no bɛba no bɛwu sɛ ne bɔne so akatua. ");
INSERT INTO twiasante_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Afɔrebɔni no bɛkum aboa no wɔ hɔ wɔ Awurade anim. Na Aaron mmammarima asɔfoɔ no asɔ aboa no mogya de akyerɛ Awurade. Na wɔde mogya no apete afɔrebukyia a ɛsi Ahyiaeɛ Ntomadan no kwan no ano no ne ɛho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Afei, asɔfoɔ no bɛpa aboa no ho nhoma na wɔabobɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Na ɔsɔfoɔ Aaron mmammarima no bɛsɔ ogya wɔ afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Na wɔde aboa no afaafa bi ne ne ti ne ne sradeɛ agu nnyensin no so. ");
INSERT INTO twiasante_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Wɔnhohoro nʼayamdeɛ ne ne nan ho na asɔfoɔ no nhye no wɔ afɔrebukyia no so na ayɛ ɔhyeɛ afɔdeɛ a ɛsɔ Awurade ani. ");
INSERT INTO twiasante_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Sɛ aboa a wɔde no rebɔ ɔhyeɛ afɔdeɛ no yɛ odwan anaa abirekyie a, ɛsɛ sɛ ɔyɛ onini a ne ho nni dɛm biara. ");
INSERT INTO twiasante_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Onipa a ɔde no baeɛ no bɛkum no Awurade anim wɔ afɔrebukyia no atifi na Aaron mmammarima asɔfoɔ no apete mogya no agu afɔrebukyia no so ne ɛho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ɔbɛhyehyɛ ɛnam no na asɔfoɔ no de nʼasinasini no ne botire no ne ne sradeɛ no agu nnyensin a ɛgu afɔrebukyia no so no so. ");
INSERT INTO twiasante_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Wɔde nsuo bɛhohoro nʼayamdeɛ ne ne nan no ho ansa na asɔfoɔ no ahye no afɔrebukyia no so de ama Awurade; ɛfiri sɛ, ɔhyeɛ afɔdeɛ sɔ Awurade ani. ");
INSERT INTO twiasante_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Sɛ obi pɛ sɛ ɔde anomaa bɔ ɔhyeɛ afɔdeɛ a, ɔmfa nturukuku anaa mmorɔnoma mma. ");
INSERT INTO twiasante_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Ɔsɔfoɔ no bɛfa anomaa no de no akɔ afɔrebukyia no so na wate ne ti ahye no, na ne mogya no, ɔbɛsɔne agu afɔrebukyia no nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Afei, ɔsɔfoɔ no bɛyi ne mene ase, atutu ne ntakra no na wato agu nsõ no mu wɔ afɔrebukyia no apueeɛ fam. ");
INSERT INTO twiasante_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Afei, ɔbɛtwe nʼatabu mu ama emu ntini no atete asensɛn hɔ. Na ɔsɔfoɔ no ahye no wɔ afɔrebukyia no so na Awurade de anigyeɛ bɛgye saa afɔrebɔ yi. ");
INSERT INTO twiasante_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Obiara a ɔpɛ sɛ ɔbɔ aduane afɔdeɛ de ma Awurade no, ɛsɛ sɛ ɔde asikyiresiam a ɛyɛ fɛ a wahwie ngo agu so de aduhwam afra na ɛbɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Ɛsɛ sɛ ɔsa ne nsabuo ma de si aduane no nyinaa anan de ma asɔfoɔ no mu baako hye sɛ afɔrebɔdeɛ, na ɛbɛyɛ Awurade anisɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ɛsɛ sɛ wɔde asikyiresiam no nkaeɛ ma Aaron ne ne mmammarima sɛ wɔn aduane; nanso wɔfa ne nyinaa sɛ afɔdeɛ kronkron a wɔabɔ ama Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Sɛ wɔde burodo a wɔato no fononoo mu brɛ Awurade sɛ afɔrebɔdeɛ a, ɛsɛ sɛ wɔde asikyiresiam a wɔayam no muhumuhu a wɔde ngo afra ato a mmɔreka nni mu na ɛbɔ saa afɔdeɛ no. Motumi de burodo ntrawa dɛɛdɛ a mmɔreka nni mu na mode ngo afa so nso bɔ afɔdeɛ ma ɛyɛ yie. ");
INSERT INTO twiasante_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Sɛ afɔrebɔdeɛ no yɛ aduane a wɔato no dadeɛ so a, asikyiresiam muhumuhu a mmɔreka mfra mu na mode ngo afra na momfa mmɔ saa afɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Mommubu mu asinasini na monhwie ngo ngu so na ɛnyɛ sɛ atokoɔ afɔdeɛ ara pɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Sɛ monoa mo afɔdeɛ no wɔ kyɛnsee mu a, ɛno nso, momfa asikyiresiam muhumuhu a mode ngo afra na ɛmmɔ saa afɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Sɛ moyɛ aduane bi, sɛ motooɛ, sɛ mokyeeɛ anaasɛ mohoeɛ no, ɛsɛ sɛ mode saa afɔrebɔdeɛ no kɔma ɔsɔfoɔ na ɔno nso de kɔ afɔrebukyia no anim de kɔma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Afɔrebɔdeɛ no mu kakra bi na ɛsɛ sɛ asɔfoɔ no hye, nanso Awurade ani bɛsɔ ade mu no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Deɛ ɛbɛka no yɛ asɔfoɔ no dea, nanso wɔfa no sɛ ne nyinaa yɛ ɔhyeɛ afɔdeɛ kronkron a wɔabɔ de ama Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Afɔrebɔ a mode asikyiresiam na ɛbɔ no, mommfa mmɔreka mfra mu, ɛfiri sɛ, ɛnsɛ sɛ ɔhyeɛ afɔdeɛ biara a mobɛbɔ ama Awurade no, mode mmɔreka anaa ɛwoɔ fra mu. ");
INSERT INTO twiasante_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Mode bɛbrɛ Awurade sɛ aduanekan afɔrebɔdeɛ, nanso ɛnsɛ sɛ wɔhye wɔ afɔrebukyia no so sɛ afɔdeɛ a ɛsɔ Awurade ani. ");
INSERT INTO twiasante_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Momfa nkyene mfra afɔrebɔdeɛ biara, ɛfiri sɛ, nkyene yɛ nkaedeɛ wɔ Onyankopɔn apam no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Sɛ mode mo mfudeɛ a ɛdi ɛkan mu aba kane rebɛbɔ afɔdeɛ a, emu aburoo no monhwane ho na monkye na momfa mma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Momfa ngo ne aduhwam nyɛ ho, ɛfiri sɛ, ɛyɛ atokoɔ afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Na asɔfoɔ no bɛhye aburoo no bi a wɔde ngo ne aduhwam afra no sɛ nkaedeɛ wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Sɛ obiara pɛ sɛ ɔbɔ asomdwoeɛ afɔdeɛ ma Awurade a, ɔtumi de nantwinini anaa nantwibereɛ bɔ, nanso ɛsɛ sɛ aboa no yɛ deɛ ne ho nni dɛm biara. ");
INSERT INTO twiasante_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Onipa a ɔde aboa no aba no de ne nsa bɛgu aboa no apampam na wakum no wɔ Ahyiaeɛ Ntomadan no ano. Na Aaron mmammarima no apete aboa no mogya agu afɔrebukyia no ho, ");
INSERT INTO twiasante_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","na wɔahye aboa no ayamdeɛ ne ɛho sradeɛ nyinaa ");
INSERT INTO twiasante_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ne ne sawa mmienu no ne ne sisia ne ne sawa kotokuo wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Na ɛbɛsɔ Awurade ani yie. ");
INSERT INTO twiasante_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Sɛ abirekyie anaa odwan na mode bɛbɔ asomdwoeɛ afɔdeɛ ama Awurade a, ɛnsɛ sɛ ɛdɛm biara ba ne ho na ɛsɛ sɛ ɔyɛ onini anaa ɔbereɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Sɛ mode odwan ba sɛ mo akyɛdeɛ a, ");
INSERT INTO twiasante_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","momfa mo nsa ngu nʼapampam na monkum no wɔ Ahyiaeɛ Ntomadan no kwan ano. Afei, Aaron mmammarima no bɛpete mogya no agu afɔrebukyia no ho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Saa asomdwoeɛ afɔrebɔdeɛ yi, fa bi na wɔmfa mma Awurade sɛ ɔhyeɛ afɔrebɔdeɛ a ne dua ne mu nneɛma ne ɛho sradeɛ, sradeɛ a ɛwɔ ne yam adeɛ nyinaa ho, ");
INSERT INTO twiasante_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ne sawa mmienu ne ɛho sradeɛ a ɛbɛn ne sisia ne ne berɛboɔ a wɔbɛyi ɛno ne ne sawa no ka ho. ");
INSERT INTO twiasante_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ɔsɔfoɔ no bɛhye no wɔ afɔrebukyia no so sɛ aduane a ɛyɛ ɔhyeɛ afɔdeɛ ama Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Sɛ obi de abirekyie brɛ Awurade sɛ nʼafɔrebɔdeɛ a, ");
INSERT INTO twiasante_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","fa wo nsa gu aboa no apampam naku no wɔ Ahyiaeɛ Ntomadan no kwan ano. Aaron mmammarima de aboa no mogya bɛpete afɔrebukyia no ho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ɛsɛ sɛ wɔhye saa afɔrebɔdeɛ yi fa bi ma Awurade. Saa afɔrebɔdeɛ fa no yɛ aboa no yam sradeɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ne sawa mmienu ne ɛho sradeɛ a ɛbɛn nʼasene mu ne ne berɛboɔ a wɔbɛyi aka ne sawa no ho. ");
INSERT INTO twiasante_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Ɔsɔfoɔ no bɛhye wɔ afɔrebukyia no so sɛ ɔhyeɛ afɔdeɛ. Awurade ani bɛsɔ saa ɔhyeɛ afɔdeɛ no. Kae sɛ sradeɛ no nyinaa yɛ Awurade dea. ");
INSERT INTO twiasante_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Yei ne mmara a monni so daa nyinaa wɔ asase yi so baabiara. Monnni sradeɛ anaa mogya.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Afei Awurade hyɛɛ mmara foforɔ maa Mose sɛ: ");
INSERT INTO twiasante_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Ka kyerɛ Israelfoɔ sɛ, ‘saa mmara yi na ɛwɔ hɔ ma obiara a wanhyɛ da na ɔbɛbu Awurade mmara no bi so. ");
INSERT INTO twiasante_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Sɛ ɔsɔfoɔ bi anhyɛ da na ɔfom mmara bi na ɛnam so de afɔbuo ba nnipa no so a, ɛsɛ sɛ ɔde nantwinini ba a ɔnnii dɛm bɔ bɔne ho afɔdeɛ de ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ɛsɛ sɛ ɔde aboa no ba Ahyiaeɛ Ntomadan no ɛpono ano na ɔde ne nsa gu nʼapampam na ɔkum no wɔ hɔ wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ɔsɔfoɔ no de aboa no mogya bɛkɔ Ahyiaeɛ Ntomadan no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ɔde ne nsateaa baako bɛbɔ mogya no mu apete no mprɛnson wɔ Awurade anim wɔ ntoma a ɛsɛn kronkron mu kronkron no anim. ");
INSERT INTO twiasante_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Afei, ɔsɔfoɔ no de mogya no bi bɛgu aduhwam no toa a ɛsi afɔrebukyia no so no wɔ Awurade anim wɔ Ahyiaeɛ Ntomadan no mu; mogya no a ɛbɛka no, wɔbɛhwie agu afɔrebukyia no ase de abɔ ɔhyeɛ afɔdeɛ wɔ Ahyiaeɛ Ntomadan no kwan ano. ");
INSERT INTO twiasante_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Afei ɔbɛtete sradeɛ a ɛwɔ ne nsono no ho nyinaa, ");
INSERT INTO twiasante_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ne sawa mmienu no ne sisia sradeɛ ne ne berɛboɔ kotokuo, ");
INSERT INTO twiasante_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","na wahye no wɔ ɔhyeɛ afɔrebukyia no so te sɛ nantwinini anaa nantwibereɛ a wɔde no bɔ asomdwoeɛ afɔdeɛ no pɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Nanso nantwie ba no ho nneɛma a ɛbɛka a ɛyɛ ne nhoma, ne nam, ne ti, ne nan, nʼayamdeɛ, ne ne nsono no deɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","wɔmfa nkɔ afahyɛbea bi a ɛhɔ te wɔ akyiri baabi a wɔde nsõ firi afɔrebukyia no so kɔ hɔ kɔhye no nnyensin so no. ");
INSERT INTO twiasante_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Sɛ Israelfoɔ nyinaa yɛ bɔne a ɛtia Awurade, na sɛ ɛnyɛ boapa yɛ a, nnipa no nyinaa bɛdi ho fɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Na sɛ wɔhunu wɔn bɔne a, wɔde nantwie ba bɛba abɛbɔ bɔne ho afɔdeɛ wɔ Ahyiaeɛ Ntomadan no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Sɛ wɔrebɔ saa afɔdeɛ no a, ɔman no mu mpanimfoɔ de wɔn nsa bɛgu aboa no apampam na wɔakum no wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Na ɔsɔfoɔ no de ne mogya aba Ahyiaeɛ Ntomadan no mu, ");
INSERT INTO twiasante_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","na ɔde ne nsateaa baako abɔ mogya no mu apete no mprɛnson wɔ Awurade ne ntoma a ɛtwa ɛdan no mu no anim. ");
INSERT INTO twiasante_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ɔde mogya bɛgu mmɛn a ɛtuatua afɔrebukyia no ho no so wɔ Ahyiaeɛ Ntomadan no mu wɔ Awurade anim. Afei ɔbɛhwie mogya a aka wɔ ɔhyeɛ afɔdeɛ no afɔrebukyia no ase no agu wɔ Ahyiaeɛ Ntomadan no kwan ano. ");
INSERT INTO twiasante_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Sradeɛ a ɛwɔ aboa no mu nyinaa, ɛsɛ sɛ wɔyi na wɔhye no wɔ afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ɔbɛfa ɛkwan a wɔfa so bɔ bɔne ho afɔdeɛ no so pɛpɛɛpɛ. Yei bɛma ɔsɔfoɔ no abɛyɛ mpatadeɛ ama ɔman no na wɔde obiara bɔne bɛkyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Afei asɔfoɔ no bɛtwe nantwinini ba no de no akɔ beaeɛ foforɔ bi so akɔhye no wɔ hɔ te sɛ deɛ ɔrebɔ ɔbaakofoɔ bɔne ho afɔdeɛ no. Nanso yei deɛ, ɛyɛ ɔman mu no nyinaa afɔrebɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Sɛ mpanimfoɔ no bi yɛ bɔne a ɔnnim sɛ wafom Awurade Onyankopɔn mmara no baako ");
INSERT INTO twiasante_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","na wɔma no te ne ho ase a, ɛsɛ sɛ ɔde ɔpapo a ne ho nni dɛm ba sɛ nʼafɔrebɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ɔde ne nsa bɛgu aboa no apampam na wakum no wɔ beaeɛ a wɔkum ɔhyeɛ afɔdeɛ mmoa no de ama Awurade no. Yei yɛ ne bɔne ho afɔrebɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Afei, ɔsɔfoɔ no de ne nsateaa baako bɛbɔ afɔrebɔdeɛ mogya no mu na ɔde afɔre afɔrebukyia a wɔbɔ ɔhyeɛ afɔdeɛ wɔ so no mmɛn no ho; na afei wɔahwie mogya no nkaeɛ agu afɔrebukyia no ase. ");
INSERT INTO twiasante_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Wɔbɛhye sradeɛ no nyinaa wɔ afɔrebukyia no so te sɛ deɛ wɔhye asomdwoeɛ afɔdeɛ sradeɛ no ara pɛ; ɛkyerɛ sɛ, ɔsɔfoɔ no nam saa afɔrebɔ yi so bɛpata ama ɔpanin ko no wɔ ne bɔne no ho na wɔde ne bɔne no bɛkyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Sɛ ɔpapahwekwaa bi yɛ bɔne a ɔnnim sɛ wafom a, ɔdi ho fɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Nanso ɔnya te ne ho ase ara pɛ a, ɛsɛ sɛ ɔde abirekyibereɛ a ne ho nni dɛm ba ma wɔde pata ne bɔne no. ");
INSERT INTO twiasante_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ɔde no bɛba beaeɛ a wɔde mmoa a wɔde wɔn ba ma wɔkum wɔn de wɔn bɔ ɔhyeɛ afɔdeɛ hɔ no, na ɔde ne nsa ato bɔne ho afɔrebɔdeɛ no apampam na wakum no. ");
INSERT INTO twiasante_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Na ɔsɔfoɔ no de mogya no bi afɔre ne nsateaa baako ho na ɔde afɔre ɔhyeɛ afɔrebukyia mmɛn no ho. Afei, ɔsɔfoɔ no bɛhwie mogya no nkaeɛ no agu afɔrebukyia no ase. ");
INSERT INTO twiasante_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Wɔbɛyi sradeɛ no nyinaa afiri mu te sɛ deɛ wɔfa bɔ asomdwoeɛ afɔdeɛ no ara. Na ɔsɔfoɔ no bɛhye no wɔ afɔrebukyia no so. Na Awurade ani bɛsɔ. Ɛkyerɛ sɛ, ɔsɔfoɔ no nam saa afɔrebɔ yi so bɛpata ama saa onipa no na wɔde ne bɔne bɛkyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Na sɛ ɔpɛ sɛ ɔde odwammaa bɛbɔ ne bɔne ho afɔdeɛ nso a, ɛsɛ sɛ ɔyɛ ɔbereɛ a ɛdɛm biara nni ne ho. ");
INSERT INTO twiasante_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ɔde no bɛba beaeɛ a wɔde mmoa a wɔde wɔn ba ma wɔkum wɔn de wɔn bɔ ɔhyeɛ afɔdeɛ hɔ no, na ɔde ne nsa ato bɔne no afɔrebɔdeɛ no apampam na wakum no sɛ bɔne ho afɔrebɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Na ɔsɔfoɔ no de mogya no bi afɔre ne nsateaa baako ho na ɔde afɔre ɔhyeɛ afɔrebukyia mmɛn no ho. Na wahwie mogya no nkaeɛ no agu afɔrebukyia no ase. ");
INSERT INTO twiasante_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Wɔbɛyɛ sradeɛ no sɛdeɛ wɔyɛ asomdwoeɛ odwammaa sradeɛ no. Ɔsɔfoɔ no bɛhye sradeɛ no wɔ afɔrebukyia no so te sɛ afɔdeɛ ahodoɔ a wɔde ogya bɔ ma Awurade no ara pɛ. Ɔsɔfoɔ no nam saa afɔrebɔ yi so bɛpata ama onipa ko no, na wɔde ne bɔne bɛkyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Obiara a ɔnka bɔne bi a ɔnim ho biribi ho hwee no di ho fɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Obiara a ɔde ne nsa ka adeɛ bi a amanneɛ kwan so, ɛho nte, te sɛ aboa bi a ne ho nteɛ no funu, sɛ ɔyɛ wiram aboa, sɛ ɔyɛ afieboa anaa aboa a ɔwea fam no, mpo sɛ wɔnnim sɛ wɔn ho agu fi a, wɔbɛfa no sɛ wɔn ho nte na wɔdi fɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Sɛ obi anhyɛ da na ɔde ne nsa ka biribi a ɛfiri onipa mu a ɛho nte na ɔte ne ho ase sɛ wayɛ saa adeɛ no a, ɔdi ho fɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Sɛ obi ka ntam a, sɛ ntam no yɛ anaa ɛyɛ ntanhunu no, sɛ ɔhunu sɛ ɛyɛ ntanhunu a, ɔdi ho fɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Sɛ obi di yeinom bi ho fɔ a, ɛsɛ sɛ ɔka ne bɔne no mu nokorɛ ");
INSERT INTO twiasante_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","na ɔde odwanbereɛ anaa abirekyibereɛ bɔ afɔdeɛ ma Awurade. Ɔsɔfoɔ na ɔbɛbɔ onipa ko no bɔne no ho afɔdeɛ ama no. Ɔsɔfoɔ no nam saa afɔrebɔ yi so bɛpata ama no. ");
INSERT INTO twiasante_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Sɛ ɔyɛ ohiani a ɔrennya odwammaa mfa mma Awurade a, ɔmfa nturukuku mmienu anaa mmorɔnoma mma mmienu mmra sɛ ne bɔne ho afɔrebɔdeɛ. Nnomaa no mu baako bɛyɛ ne bɔne no afɔrebɔdeɛ na ɔbaako ayɛ ne hyeɛ afɔrebɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ɔde bɛma ɔsɔfoɔ no na ɔde anomaa a ɔdi ɛkan no abɔ bɔne afɔdeɛ no. Ɔbɛkyinsa aboa no kɔn nanso ɔrente ne ti mfiri so, ");
INSERT INTO twiasante_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","na wapete ne mogya no bi agu afɔrebukyia no ho. Mogya no nkaeɛ no, ɔbɛhwie agu afɔrebukyia no ase. Yei ne afɔrebɔ kwan a ɛpepa bɔne. ");
INSERT INTO twiasante_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ɔde anomaa a ɔtɔ so mmienu no bɛbɔ ɔhyeɛ afɔdeɛ sɛdeɛ ɔbɔɔ afɔdeɛ a ɛdi ɛkan no ara pɛ. Ɔsɔfoɔ no nam saa afɔrebɔ yi so bɛpata ama deɛ wayɛ bɔne no, na ɛnam so ma wɔde ne bɔne akyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Sɛ ɔyɛ ohiani buruburo a ɔrentumi mfa nturukuku anaa mmorɔnoma mma mmɛbɔ ne bɔne ho afɔdeɛ a, ɔde asikyiresiam papa lita mmienu ne fa bɛba sɛ ne bɔne ho afɔrebɔdeɛ. Ɛnsɛ sɛ ɔde ɔsra ngo fra. Ɛnsɛ sɛ ɔde aduhwam nso gu so, ɛfiri sɛ, ɛyɛ bɔne afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ɔde bɛma ɔsɔfoɔ no. Na ɔsɔfoɔ no asa ne nsabuo ma de asi ne nyinaa anan na wahye no afɔrebukyia no so ama Awurade sɛ afɔrebɔdeɛ biara. Yei bɛyɛ ne bɔne ho afɔrebɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Sɛ ɛba saa a, ɔsɔfoɔ no nam saa afɔrebɔ yi so bɛpata ama onipa no na wɔde ne bɔne no bɛkyɛ no. Asikyiresiam a aka no, wɔde bɛma ɔsɔfoɔ no te sɛ afudeɛ afɔrebɔdeɛ no ara pɛ.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Awurade hyɛɛ mmara maa Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Sɛ obi anhyɛ da na ɔgu ade kronkron ho fi a, ɔde odwennini a ne ho nni dɛm a ɔfata sɛ mpatadeɛ wɔ ne fɔ no ho bɛba abɛbɔ Awurade afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ade kronkron a onipa no guu ho fi no nso, ɔde foforɔ bɛsi anan na watua dekodeɛ no boɔ ɔha mu nkyɛmu aduonu aka ho sɛ asotwe. Ɔde ne nyinaa bɛma ɔsɔfoɔ na ɔde odwennini no abɔ bɔne afɔdeɛ no na wɔde ne bɔne akyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Sɛ obi anhyɛ da na ɔbu Awurade mmara no bi so a, ɔdi fɔ enti ɛsɛ sɛ ɔtua afɔbudeɛ a Mose bɛhyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ɛsɛ sɛ ɔde odwennini anaa ɔpapo a ɔnni dɛm brɛ ɔsɔfoɔ sɛ ne bɔne no ho afɔrebɔdeɛ. Na ɔsɔfoɔ no de ayɛ mpatadeɛ ama no sɛdeɛ bɔne biara a ɔyɛeɛ a wanhyɛ da no, na wɔde ne bɔne bɛkyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ɛsɛ sɛ wɔbɔ saa afɔdeɛ no sɛ afɔdie afɔrebɔ, ɛfiri sɛ, ɔdi fɔ pefee wɔ Awurade anim.” ");
INSERT INTO twiasante_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Na Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Sɛ obi yɛ bɔne tia me, sɛ ebia, ɔmpɛ sɛ ɔsane de biribi a wɔde ama no asie kɔto baabi a ɛda anaasɛ ɔbɔ korɔno, anaa ɔsisi ne yɔnko, ");
INSERT INTO twiasante_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","anaa ɔtu ahunu na ɔka ntam sane wɔ ho sɛ dekodeɛ no nni ne nkyɛn a, ");
INSERT INTO twiasante_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","sɛ obi yɛ bɔne na ɔdi ho fɔ a, ɔbɛsane de ne korɔnodeɛ no anaa ne tintinnyɛdeɛ anaa deɛ wɔde maa no sieeɛ anaa agyapadeɛ a wɔde ahyɛ ne nsa, anaa adeɛ a ayera no aba. ");
INSERT INTO twiasante_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Biribiara a waka ho ntanhunu no nso, ɔbɛsane de ne nyinaa aba na ɔde ho mfɛntom ɔha mu nkyɛmu aduonu aka ho abrɛ onipa ko a ne dea no, ɛda a ɔrebɔ afɔdie ho afɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Nʼafɔdie ho afɔrebɔdeɛ no bɛyɛ odwennini a ɔnni dɛm. Ɛsɛ sɛ ɔdi ɛboɔ biara a wɔbɛbɔ no no. Ɔde no bɛma ɔsɔfoɔ ");
INSERT INTO twiasante_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","na ɔsɔfoɔ no de no ayɛ mpatadeɛ ama no wɔ Awurade anim na wɔde ne bɔne akyɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Fa saa mmara a ɛfa ɔhyeɛ afɔdeɛ ho yi ma Aaron ne ne mmammarima. ‘Wɔbɛgya ɔhyeɛ afɔrebɔdeɛ no wɔ ogya no so anadwo mu no nyinaa a afɔrebukyia ogya no gu so rehye. ");
INSERT INTO twiasante_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Adeɛ kye a, ɔsɔfoɔ no bɛhyɛ nʼasɔfotadeɛ nahanaha wɔ aseɛ na wahyɛ atadetam korɔ no ara bi ngugusoɔ na wakɔpra ɔhyeɛ afɔdeɛ nsõ no de agu afɔrebukyia no nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Afei, ɔbɛsesa ne ntadeɛ no na wasoa nsõ no afiri beaeɛ hɔ de akɔgu beaeɛ foforɔ a wɔate hɔ no. ");
INSERT INTO twiasante_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Saa ɛberɛ yi nyinaa ɛsɛ sɛ ogya a ɛwɔ afɔrebukyia no so no dɛre. Ɛnsɛ sɛ ɛdum. Anɔpa biara ɔsɔfoɔ no de ogya foforɔ bɛhyɛ mu na ɔde ɛda biara ɔhyeɛ afɔdeɛ agu so, na wahye sradeɛ a wɔde bɔ ɛda biara asomdwoeɛ afɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ɛsɛ sɛ ɛberɛ biara ogya no kɔ so dɛre. Ɛnsɛ sɛ ɛdum. ");
INSERT INTO twiasante_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Atokoɔ afɔdeɛ ho mmara nso nie: Aaron mmammarima bɛgyina afɔrebukyia no anim na wɔde atokoɔ afɔrebɔ no ama Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Ɔsɔfoɔ no bɛsa asikyiresiam a wɔayam no muhumuhu no ne nsabuo ma na ɔde ngo ne aduhwam afra ahye no wɔ afɔrebukyia no so sɛ ananmusideɛ ama Awurade; na Awurade ani bɛsɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ɔsa ne nsabuo ma wie a, deɛ ɛbɛka no yɛ Aaron ne ne mmammarima dea a wɔbɛdie. Wɔbɛdi a wɔremfa mmɔreka mfra wɔ Ahyiaeɛ Ntomadan no adihɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Si so dua sɛ, sɛ wɔto a, wɔmmfa mmɔreka mfra mu. Mede saa ɔhyeɛ afɔdeɛ a wɔbɔ maa me no bi ama asɔfoɔ no. Esiane sɛ ne nyinaa yɛ bɔne ne afɔdie ho afɔrebɔ enti, ɛyɛ kronkron. ");
INSERT INTO twiasante_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Aaron asefoɔ mmarima ne asɔfoɔ na wɔnni mfiri awoɔ ntoatoasoɔ so nkɔsi awoɔ ntoatoasoɔ so. Nanso asɔfoɔ no nko ara na wɔnni afɔrebɔdeɛ a wɔabɔ no ogya so ama Awurade no.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Ɛda a wɔbɛsra Aaron ne ne mmammarima ngo no, ɛsɛ sɛ wɔde asikyiresiam lita mmienu ne fa brɛ Awurade. Wɔde fa bɛba anɔpa na wɔde fa aba anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Wɔde ngo bɛfra ato wɔ dadeɛ apaawa so. Ɛsɛ sɛ wɔto no yie na wɔde brɛ Awurade sɛ nʼafɔrebɔdeɛ a ɛsɔ nʼani yie. ");
INSERT INTO twiasante_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ɔsɔfoɔ a ɔfiri Aaron mmammarima mu a wɔrehyɛ no ɔsɔfoɔ ma wasi nʼagya anan no de bɛma Awurade sɛdeɛ wɔahyɛ ho mmara afebɔɔ sɛ wɔnhye ne nyinaa no. ");
INSERT INTO twiasante_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ɔsɔfoɔ biara atokoɔ afɔdeɛ a ɔbɛbɔ no, ɛsɛ sɛ wɔhye ne nyinaa. Ɛnsɛ sɛ wɔdi.” ");
INSERT INTO twiasante_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Afei Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Ka kyerɛ Aaron ne ne mmammarima sɛ bɔne afɔrebɔ ho mmara nie: Saa afɔrebɔdeɛ yi ho yɛ kronkron yie enti ɛsɛ sɛ wɔkum no Awurade anim wɔ beaeɛ a wɔkum ɔhyeɛ afɔrebɔdeɛ wɔ hɔ no. ");
INSERT INTO twiasante_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ɛsɛ sɛ ɔsɔfoɔ a ɔyɛ afɔrebɔ no ho adwuma no we afɔrebɔdeɛ no wɔ Ahyiaeɛ Ntomadan no adihɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Wɔn a wɔate wɔn ho a wɔyɛ asɔfoɔ nko ara na wɔwɔ ho kwan sɛ wɔde wɔn nsa ka ɛnam no bi; na sɛ ɛba sɛ aboa no mogya bi pete wɔn ntadeɛ mu a, ɛsɛ sɛ wɔsi ntadeɛ no wɔ beaeɛ a wɔate ho hɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Kukuo a wɔnoaa ɛnam no wɔ mu no, ɛsɛ sɛ wɔbɔ no; na sɛ ɛyɛ kɔbere nso a, ɛsɛ sɛ wɔtwi mu, na wɔde nsuo hohoro mu nyinaa yie. ");
INSERT INTO twiasante_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ɔbarima biara a ɔfra asɔfoɔ no mu no bɛdi afɔrebɔdeɛ no bi—wɔn nko ara—ɛfiri sɛ, ɛyɛ kronkron yie. ");
INSERT INTO twiasante_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Sɛ wɔde bɔne ho afɔrebɔdeɛ no mogya no bi kɔ Ahyiaeɛ Ntomadan mu hɔ de kɔyɛ mpatadeɛ wɔ kronkronbea hɔ a, ɔsɔfoɔ biara renwe bi. Ɛsɛ sɛ wɔde ogya hye aboa no nyinaa wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Amanneɛ a ɛfa bɔne afɔrebɔ a ɛyɛ kronkron no nie: ");
INSERT INTO twiasante_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Wɔbɛkum aboa a wɔde no rebɔ afɔdeɛ no wɔ beaeɛ a wɔkumm aboa a wɔde no bɔ ɔhyeɛ afɔdeɛ no na wɔde ne mogya no apete afɔrebukyia no ho ahyia. ");
INSERT INTO twiasante_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ɔsɔfoɔ no de aboa no mu sradeɛ nyinaa, ne dua, ");
INSERT INTO twiasante_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ne sawa mmienu ne ne sisia sradeɛ ne ne berɛboɔ kotokuo no nyinaa bɛgu nkyɛn de abɔ saa afɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Asɔfoɔ no bɛhye no afɔrebukyia no so sɛ ɛfɔdie ho afɔdeɛ de ama Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Mmarima a wɔfra asɔfoɔ no mu nko ara na wɔbɛwe ɛnam no bi. Wɔnwe no beaeɛ a ɛhɔ yɛ kronkron, ɛfiri sɛ, ɛyɛ afɔrebɔdeɛ a ɛho te yie. ");
INSERT INTO twiasante_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘Amanneɛ korɔ no ara na wɔbɛfa so abɔ bɔne afɔdeɛ ne ɛfɔdie afɔdeɛ no. Ɔsɔfoɔ a ɔdi mmaratodeɛ no ho dwuma no na ɛsɛ sɛ ɔwe ɛnam no. ");
INSERT INTO twiasante_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Sɛ afɔrebɔ no yɛ ɔhyeɛ afɔrebɔ a, wɔde aboa no ho nhoma no bɛma ɔsɔfoɔ a ɔbɛdi dwuma no. ");
INSERT INTO twiasante_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Sɛ asɔfoɔ a wɔbɔ atokoɔ ho afɔdeɛ ma Awurade no wie saa afɔrebɔ no a, wɔde atokoɔ no nkaeɛ bɛma wɔn. Sɛ afɔrebɔdeɛ no, wɔto o, wɔkye o, wɔnoa o, amanneɛ korɔ no ara ase na ɛhyɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Atokoɔ afɔrebɔ biara a aka no, sɛ wɔde ngo fra anaa wɔamfa ngo amfra a, ɛyɛ Aaron mmammarima nyinaa dea. ");
INSERT INTO twiasante_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Amanneɛ a ɛfa asomdwoeɛ afɔdeɛ sononko a wɔbɔ ma Awurade no nie: ");
INSERT INTO twiasante_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Sɛ ɛyɛ asomdwoeɛ afɔdeɛ a, wɔmfa burodo a mmɔreka nni mu a wɔde ngo afra nka ho. Saa ara na wɔmfa burodo ntrawa bi a wɔde ngo agu so ne asikyiresiam mfrafraeɛ a wɔde afra ngo nka saa afɔrebɔdeɛ no ho. ");
INSERT INTO twiasante_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Wɔmfa burodo a wɔde mmɔreka afra nka saa aseda asomdwoeɛ afɔdeɛ yi ho. ");
INSERT INTO twiasante_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Wɔde saa afɔrebɔdeɛ yi bi bɛgyina afɔrebukyia no anim na wɔahim no afɔrebukyia no anim akɔ fa aba fa de akyerɛ sɛ, wɔde ama Awurade. Afei, wɔbɛdane afɔrebɔdeɛ no ama ɔsɔfoɔ a ɔpete aboa a wɔde no bɛbɔ afɔdeɛ no mogya a ɔboa dwumadie no. ");
INSERT INTO twiasante_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Sɛ wɔde aboa no bɔ Awurade afɔdeɛ de ma no sɛ asomdwoeɛ afɔrebɔ de kyerɛ sɛ ɛyɛ anisɔ ne asedadeɛ a, wɔbɛwe ne nam ɛda no ara. Ɛnsɛ sɛ ebi ka na adeɛ kye a wɔawe. ");
INSERT INTO twiasante_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Na sɛ obi de afɔrebɔdeɛ bi ba a ɛnyɛ asomdwoeɛ afɔdeɛ na mmom, sɛ ɛyɛ bɔhyɛ anaa ɛfiri nʼakoma mu na ɔde rebrɛ Awurade deɛ a, deɛ ɛbɛka biara wɔ afɔrebɔ no akyi no, sɛ adeɛ kye so a, wɔtumi we. ");
INSERT INTO twiasante_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Biribiara a ɛbɛka a ɛbɛdi nnansa no deɛ, wɔnhye no. ");
INSERT INTO twiasante_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Sɛ obi we deɛ adi nnansa no bi a, Awurade rennye afɔrebɔdeɛ no; na ɛrenni mu sɛ afɔrebɔdeɛ, na onipa a ɔde baeɛ sɛ wɔmfa mmɔ saa afɔdeɛ no rennya ho mfasoɔ biara. Ɔsɔfoɔ a ɔbɛwe no nso bɛdi ho fɔ, ɛfiri sɛ, ɛyɛ akyiwadeɛ ma Awurade; na onipa a ɔbɛwe saa ɛnam no, ɛsɛ sɛ ɔyi ne ho ano wɔ saa bɔne no ho. ");
INSERT INTO twiasante_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Ɛnam biara a ɛka biribi a wɔntee ho no, wɔnnwe; wɔnhye no. Ɛnam biara a aka deɛ, obiara a ne ho te wɔ ho kwan sɛ ɔwe. ");
INSERT INTO twiasante_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ɔsɔfoɔ biara a ne ho nte na ɔbɛdi asomdwoeɛ afɔdeɛ no bi no, wɔbɛtwa no asuo, ɛfiri sɛ, wagu ade kronkron ho fi. ");
INSERT INTO twiasante_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Obiara a ɔde ne nsa bɛka biribi a ɛho nte no, sɛ ɛyɛ onipa anaa aboa na ɔguu ho fi na ɔbɛdii asomdwoeɛ afɔrebɔdeɛ no bi no, wɔbɛtwa no asuo, ɛfiri sɛ, wagu ade kronkron ho fi.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Ka kyerɛ Israelfoɔ no sɛ wɔnnni sradeɛ, sɛ ɛfiri anantwie, nnwan anaa mmirekyie mu. ");
INSERT INTO twiasante_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Sɛ yadeɛ bi bɔ aboa bi na ɔwu anaasɛ mmoa bɔne bi taataa aboa foforɔ bi so kum no a, wɔnnni ne sradeɛ na mmom, wɔmfa nyɛ ade foforɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Obiara a ɔbɛdi sradeɛ a ɛfiri afɔrebɔdeɛ a wɔbɔ no ogya so de ma Awurade no, wɔbɛtwa no asuo. ");
INSERT INTO twiasante_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Monnni mogya—sɛ ɛyɛ nnomaa anaa ntɔteboa. ");
INSERT INTO twiasante_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Obiara a ɔbɛyɛ saa no, wɔbɛtwa no asuo.” ");
INSERT INTO twiasante_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Ka kyerɛ Israelfoɔ sɛ, obiara a ɔpɛ sɛ ɔbɔ Awurade asomdwoeɛ afɔdeɛ no, ɔno ara mfa nkura ne nsam mfa mmra. ");
INSERT INTO twiasante_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ɔmfa afɔrebɔdeɛ a ɛyɛ sradeɛ ne ne yan a wɔbɛhim no afɔrebukyia no anim de ama Awurade no mmra. ");
INSERT INTO twiasante_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Afei, ɔsɔfoɔ no bɛhye sradeɛ no wɔ afɔrebukyia no so na ne yan no deɛ, Aaron ne ne mmammarima bɛfa, ");
INSERT INTO twiasante_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","na ɔsɔfoɔ a ɔredi dwuma no afa ne srɛ nifa no. ");
INSERT INTO twiasante_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Na Aaron mmammarima no mu deɛ ɔde mogya ne sradeɛ a ɛfiri afɔrebɔdeɛ no mu bɛba afɔrebukyia no so na ɔbɛfa srɛ nifa no. ");
INSERT INTO twiasante_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Mahyɛ sɛ wɔmfa ne yan no ne ne srɛ no mma sɛ akyɛdeɛ a ɛfiri Israelfoɔ nkyɛn a wɔde rebrɛ Aaron mmammarima. Ɛberɛ biara, wɔmfa saa afɔrebɔdeɛ no kyɛfa yi no mma Aaron ne ne mmammarima.” ");
INSERT INTO twiasante_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Wɔn akatua ne no: Ɔhyeɛ afɔrebɔ no, wɔde bɛto nkyɛn na wɔde ama wɔn a wɔayi wɔn sɛ Awurade asɔfoɔ a ɛyɛ Aaron ne ne mmammarima. ");
INSERT INTO twiasante_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ɛfiri sɛ, ɛda a Awurade sraa wɔn ngo no, ɔhyɛɛ sɛ Israelfoɔ mfa saa kyɛfa no mma wɔn; ɛyɛ wɔn kyɛfa daa daa firi awoɔ ntoatoasoɔ so kɔsi awoɔ ntoatoasoɔ so. ");
INSERT INTO twiasante_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Yeinom ne amanneɛ a ɛfa ɔhyeɛ afɔrebɔ, atokoɔ afɔrebɔ, bɔne afɔrebɔ, ɛfɔdie afɔrebɔ, ahoteɛ afɔrebɔ ne asomdwoeɛ afɔrebɔ ho. ");
INSERT INTO twiasante_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Awurade de saa mmara yi maa Mose wɔ Sinai Bepɔ so sɛ ɔno nso mfa mma Israelfoɔ no sɛdeɛ ɛbɛyɛ a, wɔbɛhunu ɛkwan a ɛsɛ sɛ wɔfa so bɔ wɔn afɔdeɛ ahodoɔ no de ma Onyankopɔn wɔ Sinai ɛserɛ so hɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Afei fa Aaron ne ne mmammarima bra Ahyiaeɛ Ntomadan no kwan no ano. Wɔmfa wɔn ntadeɛ, ɔsra ngo, nantwie ba a wɔde no bɛbɔ bɔne afɔdeɛ, nnwennini mmienu ne burodo a mmɔreka nni mu nkɛntɛmma mmienu ");
INSERT INTO twiasante_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","na frɛ Israelfoɔ no nyinaa na wɔmmra hɔ bi.” ");
INSERT INTO twiasante_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Enti nnipa no nyinaa hyiaeɛ wɔ Ahyiaeɛ Ntomadan no kwan ano. ");
INSERT INTO twiasante_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mose ka kyerɛɛ wɔn sɛ, “Adeɛ a merebɛyɛ yi, Awurade na wahyɛ me sɛ menyɛ.” ");
INSERT INTO twiasante_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Afei, ɔfaa Aaron ne ne mmammarima de nsuo hohoroo wɔn ho, ");
INSERT INTO twiasante_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","de Aaron atadeɛ sononko a ne mmeamu ka ho de ne batakari a asɔfotadeɛ a wɔde tam a ɛyɛ fɛ ayɛ nʼabɔwomu hyɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Afei, Mose de adaaboɔ fam Aaron bo de Urim ne Tumim no hyɛɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ɔbɔɔ Aaron abotire a ɛwɔ sika abɔnimu kronkron sɛdeɛ Awurade hyɛɛ no sɛ ɔnyɛ no ara pɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Afei, Mose faa ɔsra ngo no de bi petee Ahyiaeɛ Ntomadan no ankasa ne biribiara a ɛwɔ mu ho de tee ne nyinaa ho. ");
INSERT INTO twiasante_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ɔduruu afɔrebukyia no so no, ɔpetee so mprɛnson. Afei, ɔpetee nkukuo a ɛwɔ afɔrebukyia no so no ne atam ne ne ntaamu ho de tee ho. ");
INSERT INTO twiasante_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Afei, ɔhwiee ɔsra ngo no guu Aaron tirim de tee ne ho sɛ ɔnhyɛ nʼadwuma ase. ");
INSERT INTO twiasante_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Deɛ ɛdi hɔ ne sɛ, Mose de mmatakari no hyehyɛɛ Aaron mmammarima a abɔwomu ne ɛkyɛ ka ho sɛdeɛ Awurade hyɛɛ no sɛ ɔnyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Afei, ɔfaa nantwinini ba sɛ ɔde no rekɔbɔ bɔne ho afɔdeɛ. Aaron ne ne mmammarima de wɔn nsa guu aboa no apampam, ");
INSERT INTO twiasante_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ma Mose kumm no. Ɔde ne nsateaa baako bɔɔ ne mogya mu de yɛɛ afɔrebukyia mmɛn nan no ho ne afɔrebukyia no ankasa ho de tee ho, ɛnna ɔhwiee mogya no nkaeɛ no guu afɔrebukyia no ase de tee ho sɛ mpatadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ɔfaa nʼayamdeɛ ho sradeɛ ne ne berɛboɔ ho sradeɛ ne ne sawa mmienu no ne ɛho sradeɛ hyee ne nyinaa wɔ afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Wɔhyee nantwinini ba no ne ne nhoma ne nʼagyanan wɔ sraban no akyi sɛdeɛ Awurade hyɛɛ Mose no. ");
INSERT INTO twiasante_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Afei, ɔde odwennini maa Awurade sɛ ɔhyeɛ afɔdeɛ. Aaron ne ne mmammarima de wɔn nsa guu aboa no apampam ");
INSERT INTO twiasante_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","na Mose kumm no de ne mogya no bi petee afɔrebukyia no ho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Afei, ɔbobɔɔ odwennini no nam na ɔhyee asinasini no a ne ti ne ne sradeɛ ka ho. ");
INSERT INTO twiasante_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Na ɔde nsuo hohoroo nʼayamdeɛ ne ne nan no ho hyee no wɔ afɔrebukyia no so maa ne nyinaa hyee pasaa wɔ Awurade anim. Ɛyɛ ɔhyeɛ afɔdeɛ a ɛsɔɔ Awurade ani yie, ɛfiri sɛ, Mose dii Awurade akwankyerɛ no nyinaa so pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Afei, Mose de odwennini baako a ɔyɛ ahoteɛ dwennini baeɛ. Aaron ne ne mmammarima de wɔn nsa guu nʼapampam. ");
INSERT INTO twiasante_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mose kumm no na ɔde mogya no bi kaa Aaron aso nifa ase ne ne nsa nifa kokurobetie ne ne nan nifa kokurobetie. ");
INSERT INTO twiasante_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ɔde mogya no bi yɛɛ Aaron mmammarima no nso aso nifa ase ne wɔn nsa nifa kokurobetie ne wɔn nan nifa kokurobetie. Ɔde mogya no nkaeɛ petee afɔrebukyia no ho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Afei, ɔfaa sradeɛ no, ne dua, ne ne mu sradeɛ, ne berɛboɔ kotokuo, ne sawa mmienu no ne ɛho sradeɛ ne nʼabati nifa ");
INSERT INTO twiasante_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ɛnna ɔde saa burodo ntrawa a mmɔreka nni mu no baako nso ne burodo ntrawa no baako a wɔde ngo agu so ne burodo ntrawa baako a wɔfaa ne nyinaa firii kɛntɛn a wɔde bɛsii hɔ wɔ Awurade anim no mu guguu yeinom nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Wɔde yeinom nyinaa hyɛɛ Aaron ne ne mmammarima nsa sɛ wɔnhim no afɔrebukyia no anim sɛ ɔhim afɔrebɔ mma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mose gyee ne nyinaa firii wɔn nsam hyee no wɔ afɔrebukyia no so de maa Awurade; na afɔrebɔ no sɔɔ Awurade ani. ");
INSERT INTO twiasante_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Afei Mose faa ne yan no hinhim no Awurade anim; yei ne Mose kyɛfa wɔ ahoteɛ odwennini no mu sɛdeɛ Awurade ka kyerɛɛ no sɛ ɔnyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Afei ɔfaa ɔsra ngo no ne mogya a ɔde apete afɔrebukyia no so no bi de petee Aaron ne ne mmammarima ntadeɛ mu de tee Aaron ne ne mmammarima ne wɔn ntadeɛ ho maa Awurade dwumadie. ");
INSERT INTO twiasante_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mose ka kyerɛɛ Aaron ne ne mmammarima no sɛ, “Monnoa ɛnam no wɔ Ahyiaeɛ Ntomadan no kwan ano na momfa nni burodo a ɛwɔ kɛntɛn a asɔfohyɛ afɔrebɔdeɛ wɔ mu no sɛdeɛ meka kyerɛɛ mo no. ");
INSERT INTO twiasante_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ɛnam ne burodo biara a ɛbɛka no, monhye. ");
INSERT INTO twiasante_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Bio, ɔka kyerɛɛ wɔn sɛ wɔntena Ahyiaeɛ Ntomadan no ano nnanson, mfa nwie asɔfohyɛ dwumadie no. ");
INSERT INTO twiasante_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Mose kaa bio sɛ, deɛ ɔyɛɛ no ɛda no nyinaa no, Awurade na ɔhyɛɛ no sɛ ɔnyɛ mfa nyɛ mpata mma wɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ɔsane hyɛɛ Aaron ne ne mmammarima no sɛ wɔntena Ahyiaeɛ Ntomadan no ano anadwo ne awia nnanson. Ɔka kyerɛɛ wɔn sɛ, ‘Sɛ mofiri hɔ a, mobɛwuwu. Yei ne asɛm a Awurade aka.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Enti, Aaron ne ne mmammarima dii nsɛm a Awurade nam Mose so hyɛɛ wɔn sɛ wɔnyɛ no nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ahodwira no akyi ɛda a ɛtɔ so nwɔtwe no, Mose frɛɛ Aaron ne ne mmammarima ne Israel mpanimfoɔ nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ɔka kyerɛɛ Aaron sɛ, ɔnkɔkyere nantwinini ba mfiri anantwie no mu na ɔmfa no mmɔ bɔne afɔdeɛ, na ɔnkyere odwennini a ne ho nni dɛm mfa no mmɔ ɔhyeɛ afɔdeɛ. Ɔka kyerɛɛ no sɛ ɔmmɔ saa afɔdeɛ yi nyinaa wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Afei Mose kyerɛɛ wɔn sɛ, “Monka nkyerɛ Israelfoɔ na wɔnyi ɔpapo mfa no mmɔ bɔne afɔdeɛ mma wɔn ho, na wɔmfa nantwie a wadi afe ne odwammaa a wadi afe a wɔn ho nni dɛm biara mmɔ wɔn ɔhyeɛ afɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Bio, ka kyerɛ wɔn sɛ wɔmfa nantwinini ne odwennini mmɔ asomdwoeɛ afɔdeɛ na wɔmfa asikyiresiam a wɔde ngo afra mmɔ aduane afɔdeɛ. Ka kyerɛ ma wɔmfa saa afɔrebɔdeɛ yi nyinaa mma Awurade, ɛfiri sɛ ɛnnɛ, Awurade bɛyi ne ho adi akyerɛ mo.” ");
INSERT INTO twiasante_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Enti wɔde saa nneɛma yi nyinaa baa Ahyiaeɛ Ntomadan no kwan ano sɛdeɛ Mose hyɛeɛ no. Nnipa no nyinaa bɛgyinagyinaa Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mose ka kyerɛɛ wɔn sɛ, “Sɛ modi Awurade mmara so a, mobɛnya nʼanimuonyam.” ");
INSERT INTO twiasante_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mose ka kyerɛɛ Aaron sɛ ɔnkɔ afɔrebukyia no so na ɔnkɔbɔ bɔne ne ɔhyeɛ afɔdeɛ no mfa nyɛ mpatadeɛ mma ne ho ansa na ato nnipa no sɛdeɛ Awurade hyɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Enti Aaron foro kɔɔ afɔrebukyia no so. Ɔkumm nantwie ba no de bɔɔ ɔno ara ne bɔne ho afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ne mmammarima no de mogya no brɛɛ no ɛnna ɔde ne nsateaa baako bɔɔ mu fɔree mmɛn a ɛwɔ afɔrebukyia no ho no ɛnna ɔhwiee nkaeɛ no guu afɔrebukyia no ase. ");
INSERT INTO twiasante_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Afei, ɔhyee sradeɛ, sawa, berɛboɔ, berɛboɔ nkotokuo a ɛfiri bɔne afɔrebɔdeɛ no mu sɛdeɛ Awurade hyɛɛ Mose no. ");
INSERT INTO twiasante_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Na ɛnam no deɛ, ɔhyee no ne ne nhoma wɔ sraban no akyi. ");
INSERT INTO twiasante_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Deɛ ɛdi hɔ ne sɛ, ɔkumm ɔhyeɛ afɔdeɛ aboa no maa ne mmammarima sɔɔ mogya no maa ɔde petee afɔrebukyia no ho nyinaa, ");
INSERT INTO twiasante_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Wɔde aboa no brɛɛ no asinasini a ne ti ka ho. Ɔhyee aboa no akwaa biara wɔ afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Afei, ɔhoroo aboa no ayamdeɛ ne ne nan ho hyee no afɔrebukyia no so sɛ ɔhyeɛ afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Afei, ɔbɔɔ afɔdeɛ maa ɔmanfoɔ. Ɔkumm abirekyie nanso ɔfaa ɛkwan korɔ a ɔfaa so bɔɔ bɔne afɔdeɛ maa ne ho no so bɔɔ afɔdeɛ maa ne ho. ");
INSERT INTO twiasante_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Saa ɛkwan no so na ɔfa bɔɔ wɔn ɔhyeɛ afɔdeɛ de maa Awurade sɛdeɛ Onyankopɔn mmara kyerɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Afei, ɔbɔɔ atokoɔ afɔdeɛ no, ɔfaa ne nsabuo ma ɛnna ɔhyee no afɔrebukyia no so de kaa anɔpa ɔhyeɛ afɔrebɔ no ho. ");
INSERT INTO twiasante_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ɔkumm nantwie ne odwennini no a ɛyɛ nnipa no asomdwoeɛ afɔrebɔdeɛ no. Aaron mmammarima no de mogya no brɛɛ no maa ɔde petee afɔrebukyia no ho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ɔyii nantwie no ne odwennini no sradeɛ. Ɔyii wɔn padua mu sradeɛ ne wɔn ayamdeɛ sradeɛ, ne wɔn sawa ne wɔn berɛboɔ kotokuo. ");
INSERT INTO twiasante_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Wɔde sradeɛ no guu mmoa no ayan so na Aaron hyee no afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Na ɔhim ayan no ne mmoa no mmati nifa no wɔ Awurade anim de kyerɛɛ sɛ afɔdeɛ no yɛ ne dea sɛdeɛ Mose hyɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Afei, Aaron trɛɛ ne nsam wɔ nnipa no so hyiraa wɔn, ɛnna ɔsiane firii afɔrebukyia no ho sii fam. ");
INSERT INTO twiasante_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mose ne Aaron kɔɔ Ahyiaeɛ Ntomadan mu hɔ na wɔsane baa bio no, wɔhyiraa nnipa no na Awurade animuonyam baa nnipa no nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Na ogya firi Awurade nkyɛn bɛhyee ɔhyeɛ afɔrebɔdeɛ no ne sradeɛ a ɛwɔ afɔrebukyia no so no. Na nnipa no hunuu yei no, wɔn nyinaa teateaam butubutuu fam wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Na Aaron mma Nadab ne Abihu de ogya guu wɔn aduhwamhyeɛ adeɛ mu. Wɔde aduhwam no petee ogya no so ma wɔnam saa ɛkwan yi so buu Awurade mmara so, ɛfiri sɛ wɔde ogya a ɛnyɛ deɛ Awurade ahyɛ baa nʼanim. ");
INSERT INTO twiasante_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Enti ogya dɛreɛ firi Awurade nkyɛn bɛhyee wɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mose ka kyerɛɛ Aaron sɛ, “Awurade kaa sɛ, “ ‘Mede me ho kronkron bɛkyerɛ wɔn a wɔbɛn me na nnipa nyinaa ahyɛ me animuonyam no, aseɛ ne no.’” Na asɛm no tɔree Aaron mumu. ");
INSERT INTO twiasante_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Afei, Mose soma ma wɔkɔfrɛɛ Misael ne Elsafan a wɔyɛ Aaron agya nuabarima mma brɛɛ no. Ɔka kyerɛɛ wɔn sɛ, “Monkɔtwe nnipa a wɔahye no nyinaa mfiri Ahyiaeɛ Ntomadan no anim mfa wɔn nkɔ sraban no akyi.” ");
INSERT INTO twiasante_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Na wɔkɔsoaa wɔn wɔ wɔn ntadeɛ mu sɛdeɛ Mose aka akyerɛ wɔn no. ");
INSERT INTO twiasante_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mose ka kyerɛɛ Aaron ne ne mmammarima Eleasa ne Itamar sɛ, “Monnsu. Mommma mo tirinwi nsensɛn hɔ yuu mmfa nkyerɛ sɛ moretwa agyaadwoɔ. Monnsunsuane mo ntadeɛ mu nso. Sɛ moyɛ saa a, Onyankopɔn bɛkum mo nso na nʼabufuo bɛba Israelfoɔ nyinaa so. Nanso Israelfoɔ a wɔaka no deɛ, ɛsiane ogya a Awurade de baeɛ no enti, wɔtumi di Nadab ne Abihu wuo no ho awerɛhoɔ tumi su wɔn nso. ");
INSERT INTO twiasante_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Na mommfiri Ahyiaeɛ Ntomadan no ano, anyɛ saa a mobɛwuwu, ɛfiri sɛ, Awurade ngosra wɔ mo so.” Na wɔdii asɛm a Mose kaeɛ no so. ");
INSERT INTO twiasante_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Afei, Awurade hyɛɛ Aaron sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Sɛ wokɔ Ahyiaeɛ Ntomadan no mu a, nnom bobesa anaa nsã a ano yɛ den. Woyɛ saa a, wobɛwu. Saa mmara yi ka wo mmammarima ne wʼasefoɔ nyinaa firi awoɔ ntoatoasoɔ so kɔsi awoɔ ntoatoasoɔ so. ");
INSERT INTO twiasante_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Wo nnwuma ne sɛ, wobɛdi wo nkurɔfoɔ ntam nsɛm akyerɛ wɔn nsonsonoeɛ a ɛda deɛ ɛho te ne deɛ ɛyɛ teta ntam ne deɛ ɛyɛ kronkron ne deɛ ɛnyɛ kronkron ntam, ");
INSERT INTO twiasante_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","na kyerɛ wɔn mmara a Awurade nam Mose so de ama no nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Afei, Mose ka kyerɛɛ Aaron ne ne mmammarima Eleasa ne Itamar sɛ, “Sɛ mohye Awurade afɔrebɔdeɛ no nsabuo ma Awurade a, monni deɛ ɛbɛka no wɔ afɔrebukyia no ho. Monhwɛ sɛ mmɔka nni mu ɛfiri sɛ ɛyɛ kronkron. ");
INSERT INTO twiasante_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Enti monni no kronkronbea hɔ. Ɛyɛ wo ne wo mmammarima dea, na ɛyɛ wo ne wo mmammarima no kyɛfa a ɛfiri afɔdeɛ a wɔde ogya bɔ maa Awurade no mu. Yei na wɔahyɛ sɛ menyɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Nanso, ne yan ne ne srɛ a mohim no Awurade anim no, motumi we no beaeɛ biara a amanneɛ kwan so no ɛhɔ teɛ. Ɛyɛ wo, wo mmammarima ne wo mmammaa kyɛfa wɔ Israelfoɔ Asomdwoeɛ afɔrebɔdeɛ no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ne srɛ ne ne yan a wohim no, ɛsɛ sɛ wɔde ka sradeɛ afɔrebɔdeɛ a wɔhye de ma Awurade no ho. Afei ɛbɛyɛ wo ne wʼasefoɔ dea daa sɛdeɛ Awurade ahyɛ no.” ");
INSERT INTO twiasante_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Ɛberɛ a Mose bisaa deɛ ayɛ abirekyie a wɔde no bɛbɔ bɔne afɔdeɛ no ho asɛm no, ɔhunuu sɛ wɔahye no. Ɛno enti, ne bo fuu Eleasa ne Itamar a na wɔyɛ Aaron mmammarima no. ");
INSERT INTO twiasante_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Ɔbisaa wɔn sɛ, ‘Adɛn enti na moanwe bɔne afɔrebɔdeɛ no wɔ kronkronbea hɔ? Ɛyɛ afɔrebɔdeɛ kronkron! Wɔde maa mo sɛ momfa nyi nnipa no afɔdie na ɛnyɛ mpatadeɛ mma wɔn wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Esiane sɛ wɔamfa ne mogya ankɔ kronkronbea hɔ no enti, anka mobɛtumi awe no hɔ ara sɛdeɛ mehyɛeɛ no.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaron srɛɛ Mose maa ne mma no sɛ, “Ɛnnɛ me mma no bɔɔ wɔn bɔne afɔdeɛ ne ɔhyeɛ afɔdeɛ maa Awurade. Nanso hwɛ asɛm yi a ato me. Sɛ mewee bɔne afɔdeɛ ɛnam yi bi ɛnnɛ a, anka Awurade ani bɛsɔ anaa?” ");
INSERT INTO twiasante_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Na Mose tee saa no, ɔgye too mu. ");
INSERT INTO twiasante_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Afei, Awurade ka kyerɛɛ Mose ne Aaron sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Monka nkyerɛ Israelfoɔ no sɛ, ‘yei ne mmoa a mobɛtumi awe wɔ asase so mmoa no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Motumi we aboa biara a ne tɔte mu apae na ɔpu wesa no. ");
INSERT INTO twiasante_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Monnnwe mmoa a ɛdidi so yi. Yoma, ɛfiri sɛ, ɔpu wesa nanso ne tɔte mu mpaeɛ; ");
INSERT INTO twiasante_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Atwaboa, ɛfiri sɛ, ɔpu wesa nanso ne tɔte mu mpaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Adanko, ɛfiri sɛ, ɔpu wesa nanso ne tɔte mu mpaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ɔprako, ɛfiri sɛ, ne tɔte mu apae nanso ɔmpu nwesa. ");
INSERT INTO twiasante_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Monnnwe wɔn nam anaa mommfa mo nsa nka wɔn funu; wɔyɛ akyiwadeɛ nnuane ma mo. ");
INSERT INTO twiasante_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Monni nsuomnam biara a ɛwɔ ntɛtɛ ne abon a ɛfiri nsubɔntene anaa ɛpo mu; ");
INSERT INTO twiasante_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","nanso nsuomnam a aka no deɛ, mokyi. ");
INSERT INTO twiasante_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ɛnsɛ sɛ mowe wɔn nam anaa mode mo nsa ka wɔn afunu. ");
INSERT INTO twiasante_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Meti mu bio sɛ, nsuomnam biara a ɛnni ntɛtɛ anaa abon no, mokyi. ");
INSERT INTO twiasante_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Nnomaa a mokyi no korakora nso ne: ɔkɔdeɛ, ne ɔkɔrewa ne ɔkomfufuo, ");
INSERT INTO twiasante_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ɔkompete (wɔn ahodoɔ nyinaa), ɔsansa, ");
INSERT INTO twiasante_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","anene (wɔn ahodoɔ nyinaa), ");
INSERT INTO twiasante_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","sohori, anadwokorɔma, ɛpo so akorɔma, akorɔma (wɔn ahodoɔ nyinaa), ");
INSERT INTO twiasante_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ɔpatuo, ɛserɛ so patuo, patukɛseɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","bakanoma, nantwinoma, opete, ");
INSERT INTO twiasante_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","asukɔnkɔn (wɔn ahodoɔ nyinaa), asɔkwaa ne apan. ");
INSERT INTO twiasante_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Ntuboa a wɔnante no, ɛnsɛ sɛ wɔwe ");
INSERT INTO twiasante_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","agye wɔn a wɔhuri; ");
INSERT INTO twiasante_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ntutummɛ ahodoɔ nyinaa, nketekyire, ne mmɛbɛ nyinaa motumi we. ");
INSERT INTO twiasante_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Nanso mmoawa a wɔtu na wɔwɔ nan ɛnan no deɛ, mokyi. ");
INSERT INTO twiasante_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Obiara a ɔde nsa bɛka wɔn funu no mpo ho bɛgu fi kɔsi anwummerɛ ");
INSERT INTO twiasante_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","na amonom hɔ ara, ɛsɛ sɛ onii no si ne ntoma na ɔtwe ne ho firi nnipa mu kɔsi anwummerɛ de kyerɛ sɛ, ne ho agu fi. ");
INSERT INTO twiasante_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Obiara a ɔde ne nsa bɛka aboa biara a ne tɔte mu mpae nwieeɛ anaa aboa a ɔmpu nnwesa no, wagu ne ho fi. ");
INSERT INTO twiasante_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Aboa biara a ne nan yɛ ɛnan na ɔnam ne mmɔwerɛ so no, mokyiri ne nam. Obiara a ɔde ne nsa bɛka aboa a ɔte saa funu no ho agu fi kɔsi anwummerɛ; ɛyɛ mo akyiwadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Obiara a ɔbɛfa saa aboa no funu no, ɛsɛ sɛ ɔsi ne ntoma na ne ho nnte ara kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Mmoa a wɔwea fam a wɔn ho nte no nie: Kɔkɔbo, okusie, akura, ");
INSERT INTO twiasante_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","efiewura, ɔmampam, ɔkoterɛ, srɛ so koterɛ, abosomakoterɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Obiara a ɔde ne nsa bɛka wɔn mu bi funu no ho bɛyɛ fi kɔsi anwummerɛ ");
INSERT INTO twiasante_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","na biribiara a wɔn funu no ho bɛka no nso ho bɛgu fi, sɛ ɛyɛ dua, ntoma, kuntu, kotokuo; biribiara a wɔn ho bɛka no, wɔmfa ngu nsuo mu nkɔsi anwummerɛ. Ɛno akyi, wɔtumi de di dwuma bio. ");
INSERT INTO twiasante_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kukuo biara a ebi bɛtɔ mu no, deɛ ɛwɔ mu biara ho bɛgu fi enti ɛsɛ sɛ wɔbɔ saa kukuo no. ");
INSERT INTO twiasante_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Nsuo a wɔde bɛhohoro nneɛma a ɛho nte wɔ kukuo no mu no, sɛ ebi ka aduane bi a, ɛgu aduane no ho fi. Na nsã biara a ɛwɔ kukuo a ɛho agu fi no mu no nso ho gu fi saa ara. ");
INSERT INTO twiasante_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Sɛ aboa biara a ne ho agu fi funu ka fononoo a wɔde ɛboɔ anwono a, na ɛno nso ho agu fi enti ɛsɛ sɛ wɔbubu guo. ");
INSERT INTO twiasante_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Sɛ aboa no te hwe asutire anaa abura bi a nsuo wɔ mu mu a, nsuo no ho nguu fi, na mmom, onipa a ɔbɛyi aboa no ho agu fi. ");
INSERT INTO twiasante_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Na sɛ aboa no funu ka aduane a wɔbɛdua no afuom a, ɛho nguu fi, ");
INSERT INTO twiasante_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","nanso sɛ wɔfɔ aba no na efunu no te tɔ so a, aba no ho agu fi. ");
INSERT INTO twiasante_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Sɛ yadeɛ bi kum aboa a wɔama wo ho kwan sɛ we ne nam a, obi a ɔde ne nsa bɛka ne funu no no ho gu fi kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Saa ara nso na onipa a ɔbɛwe ne ɛnam no bɛsi ne ntoma na ne ho agu fi akɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Monnnwe mmoa a wɔwea fam no ɛnam. ");
INSERT INTO twiasante_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Wɔn a wɔtwe wɔn ho ase fa wɔn afuru so ne wɔn a wɔnam wɔn nan ɛnan so nyinaa ka ho. Monnnwe wɔn a wɔwɔ nan bebree na wɔwea no nam nso, ɛfiri sɛ, wɔn ho agu fi. ");
INSERT INTO twiasante_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Mfa wo ho nka wɔn na wo ho angu fi. ");
INSERT INTO twiasante_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Mene Awurade wo Onyankopɔn. Momma mo ho nte wɔ saa nneɛma yi nyinaa ho na monyɛ kronkron, ɛfiri sɛ, meyɛ kronkron. Yei enti, mommfa mo nsa nkɔka mmoa a wɔwea fam yi mu biara mfa ngu mo ho fi. ");
INSERT INTO twiasante_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Mene Awurade a meyii mo firii Misraim de mo bɛyɛɛ mo Onyankopɔn no. Ɛno enti, ɛsɛ sɛ moyɛ kronkron, ɛfiri sɛ, meyɛ kronkron. ");
INSERT INTO twiasante_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Yei ne mmara a ɛfa mmoa, nnomaa, nsuomnam ne wɔn a wɔwea asase so no ho. ");
INSERT INTO twiasante_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Yei ne nsonsonoeɛ a ɛda mmoa a wɔn ho te a ɛsɛ sɛ wɔwe wɔn ɛnam ne wɔn a wɔn ho nte a ɛnsɛ sɛ wɔwe wɔn ɛnam wɔ mmoa a wɔwɔ asase so no ntam.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Awurade ka kyerɛɛ Mose sɛ ɔnhyɛ Israelfoɔ mmara sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Sɛ ɔbaa bi wo ɔbabarima a, ne ho nnte nnanson, te sɛ deɛ ɔkɔ afikyire a ne ho nteɛ no ara. ");
INSERT INTO twiasante_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ne nnawɔtwe so no, ɛsɛ sɛ wɔtwa abarimaa no twetia. ");
INSERT INTO twiasante_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Na nnafua aduasa mmiɛnsa a ɛda nʼanim a ɔde rete ne ho no, ɛnsɛ sɛ ɔsɔ biribiara a ɛyɛ kronkron mu na ɔnni ho kwan sɛ ɔkɔ hyiadan mu nso. ");
INSERT INTO twiasante_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Sɛ ɔbaa bi wo ɔbabaa a, ne ho nnte nnawɔtwe mmienu, te sɛ deɛ ɔkɔ afikyire a ne ho nteɛ no ara. Afei ɛsɛ sɛ ɔtwɛn nnafua aduosia nsia ma ne ho twa. ");
INSERT INTO twiasante_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Sɛ saa ahoteɛ nna yi twam a (mmara a ɛdi so yi ka ɔbaa a wawo abarimaa anaa abaayewa ho asɛm), ɛsɛ sɛ ɔde odwammaa a wadi afe bɛbɔ ɔhyeɛ afɔdeɛ na ɔde aborɔnoma anaa aturukuku ba bɛbɔ bɔne ho afɔdeɛ. Ɛsɛ sɛ ɔde wɔn kɔ Ahyiaeɛ Ntomadan no ano kɔma ɔsɔfoɔ no, ");
INSERT INTO twiasante_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","na ɔsɔfoɔ no de ama Awurade de ayɛ mpatadeɛ ama ɛna no; ɛba saa a, ne ho te bio wɔ nʼawoɔ mu mogyaguo ho. “Yei ne awoɔ akyi ahyɛdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Na sɛ ɔyɛ ohiani a ɔrennya odwammaa no a, ɛnneɛ, ɛsɛ sɛ ɔde mmorɔnoma mmienu anaa nturukuku mma mmienu ba. Wɔde baako bɛbɔ ɔhyeɛ afɔdeɛ na wɔde baako abɔ bɔne ho afɔdeɛ. Ɔsɔfoɔ no de yeinom bɛyɛ mpatadeɛ ama no, sɛdeɛ ɛbɛyɛ a ne ho bɛte bio.” ");
INSERT INTO twiasante_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Awurade ka kyerɛɛ Mose ne Aaron sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Sɛ obi hunu sɛ biribi ahono ne honam ani, anaa pɔmpɔ anaa sowanini asi no na adidi kɔ ne honam mu a, ɔnhunu sɛ ɛyɛ kwata. Ɛsɛ sɛ wɔde saa onipa no kɔma ɔsɔfoɔ Aaron anaa ne mmammarima no mu baako ");
INSERT INTO twiasante_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","na ɔhwɛ ahonoeɛ no. Sɛ enwi a ɛsi ahonoeɛ hɔ dane yɛ fitaa na ahonoeɛ no atɔ honam no mu a, na ɛyɛ kwata a ɛsɛ sɛ ɔsɔfoɔ no da no adi sɛ ɔyarefoɔ no yɛ ɔkwatani. ");
INSERT INTO twiasante_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Na sɛ ahonoeɛ no ntɔɔ honam no mu na sɛ ahonoeɛ hɔ nwi no nso nyɛɛ fitaa a, ɛsɛ sɛ ɔsɔfoɔ no yi ɔyarefoɔ no firi nnipa mu nnanson. ");
INSERT INTO twiasante_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Nnanson no duru a, ɔsɔfoɔ no bɛhwɛ no bio na sɛ ahonoeɛ no nsesaeɛ na ɛntrɛtrɛɛ honam no ani a, ɔsɔfoɔ no bɛsane atwa no asuo nnanson bio. ");
INSERT INTO twiasante_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Afei ne nnanson so no, ɔsɔfoɔ no bɛhwɛ ne honam ani bio, na sɛ ɔhunu sɛ yadeɛ no ano abrɛ ase a ɛntrɛtrɛɛ a, ɔsɔfoɔ no bɛka ato dwa sɛ, ɔyarefoɔ no ho atɔ no; ɔbɛkyerɛ mu sɛ ɛyɛ nsawa bi na ɛguu no berɛ tiawa bi mu. Enti sɛ ɔyarefoɔ no si ne ntoma a wɔbɛfa no sɛ wanya ayaresa awie. ");
INSERT INTO twiasante_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Na sɛ nso ɔyarefoɔ no ba ɔsɔfoɔ no nkyɛn ma ɔhwɛ no na yadeɛ no atrɛtrɛ a, ɛsɛ sɛ ɔsane ba ɔsɔfoɔ no nkyɛn bio ");
INSERT INTO twiasante_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","na ɔhwɛ no na sɛ yadeɛ no atrɛtrɛ ɔhonam no ani a, afei, ɔbɛpae mu aka sɛ amanneɛ kwan so no, ne ho nte na ɛyɛ ɔhonam ani nsaneyadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Sɛ obi nya ɔhonam ani nsaneyadeɛ a, ɛsɛ sɛ wɔde no kɔkyerɛ ɔsɔfoɔ na ɔhwɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Sɛ ɔsɔfoɔ no hunu sɛ nwi no bi ayɛ fitaa na ekuro atɔ saa beaeɛ hɔ a, ");
INSERT INTO twiasante_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","na ɛkyerɛ sɛ ɛyɛ ɔhonam ani nsaneyadeɛ, na ɛsɛ sɛ ɔsɔfoɔ no de to dwa sɛ amanneɛ kwan so no, onipa no ho nte. Ɛba saa a, wɔnhwehwɛ yadeɛ no mu bio, ɛfiri sɛ ɛda adi pefee sɛ honam no ayɛ kwata. ");
INSERT INTO twiasante_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Nanso sɛ ɔsɔfoɔ no hunu sɛ kwata no adidi ne honam nyinaa firi ne tiri so kɔsi ne nan ase nyinaa a, ");
INSERT INTO twiasante_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ɔsɔfoɔ no bɛpae mu aka sɛ ne ho te, ɛfiri sɛ, ne honam nyinaa adane ayɛ fitaa. ");
INSERT INTO twiasante_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Na sɛ akuro no bi pue ne honam no baabi foforɔ a, wɔbɛpae mu ka sɛ onipa no yɛ ɔkwatani. ");
INSERT INTO twiasante_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Ɛsɛ sɛ ɔsɔfoɔ no pae mu ka ntɛm ara a ɔhunu ekuro wɔ honam no fa baabi, ɛfiri sɛ akuro no kyerɛ sɛ kwata wɔ honam no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Na sɛ akuro no wu na ɛdane yɛ fitaa sɛ honam a aka no a, ɔkwatani no bɛkɔ ɔsɔfoɔ no hɔ bio. ");
INSERT INTO twiasante_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ɔsɔfoɔ no bɛhwɛ no na sɛ honam no fa hɔ ayɛ fitaa deɛ a, ɔsɔfoɔ no bɛpae mu aka sɛ ne ho atɔ no. ");
INSERT INTO twiasante_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Sɛ pɔmpɔ si obi na ɛgyae ");
INSERT INTO twiasante_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","na sɛ baabi a pɔmpɔ no siiɛ no biribi hyɛnn, bi anaa deɛ ɛbere kakra hono wɔ hɔ a, ɛsɛ sɛ ɔde ne ho kɔkyerɛ ɔsɔfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Na sɛ ɔsɔfoɔ no hwɛ na yadeɛ no adidi kɔ ne honam mu na enwi a ɛwɔ honam no hɔ no ayɛ fitaa a, ɔsɔfoɔ no bɛpae mu aka sɛ ɔyarefoɔ no ho nte, ɛfiri sɛ, kwata apue afiri pɔmpɔ no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Nanso sɛ ɔsɔfoɔ no hwɛ na ɔhunu sɛ enwi fitaa biara nni baabi a yadeɛ no wɔ hɔ no, na yadeɛ no nnidi nkɔɔ honam no mu, na ahosuo no yɛ nsonso a, ɔsɔfoɔ no bɛyi no afiri nnipa mu nnanson. ");
INSERT INTO twiasante_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Saa ɛberɛ no mu sɛ beaeɛ hɔ no trɛtrɛ a, ɔsɔfoɔ no bɛpae mu aka sɛ, onipa no yare kwata. ");
INSERT INTO twiasante_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Na sɛ beaeɛ a ɛhɔ ayɛ hyɛnn no anhono bio na antrɛtrɛ a, na ɛyɛ pɔmpɔ no twa kɛkɛ enti ɔsɔfoɔ no bɛpae mu aka sɛ, ne ho te. ");
INSERT INTO twiasante_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Sɛ obi hyehye na sɛ nhyehyeeɛ no mu yɛ kɔkɔɔ ne fitaa anaa fitaa a, ");
INSERT INTO twiasante_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ɛsɛ sɛ ɔsɔfoɔ no hwɛ nhyehyeeɛ hɔ. Sɛ nwi a ɛwɔ beaeɛ a ɛhɔ nnii dɛm biara no dane yɛ fitaa na sɛ ɛyɛ adeɛ a adidi kɔ honam no mu a, na ɛyɛ kwata na apue afiri nhyehyeeɛ no mu, enti ɛsɛ sɛ ɔsɔfoɔ no pae mu ka sɛ onipa no yɛ ɔkwatani. ");
INSERT INTO twiasante_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Na sɛ ɔsɔfoɔ no hwɛ hunu sɛ nwi fitaa nni beaeɛ a ɛhɔ yɛ hyɛnn no, na sɛ hyɛnn no nnidi nkɔɔ honam no mu, na yadeɛ no regyae a, ɔsɔfoɔ no bɛyi no afiri nnipa mu nnanson ");
INSERT INTO twiasante_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","na wahwɛ no bio ne nnanson so. Sɛ yadeɛ no trɛ fa ɔhonam no ani a, ɛsɛ sɛ ɔsɔfoɔ no pae mu ka sɛ kwata ayɛ onipa no. ");
INSERT INTO twiasante_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Nanso sɛ honam no fa hɔ a ayɛ hyɛnn no antrɛtrɛ honam no ani, na sɛ ɛyɛ sɛ deɛ ɛhɔ retwintwam no a, wɔbɛfa no sɛ ɛyɛ nhyehyeeɛ twa bi, enti ɔsɔfoɔ no bɛda no adi sɛ ɔnyare kwata. ");
INSERT INTO twiasante_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Sɛ ekuro da ɔbarima anaa ɔbaa bi tirim anaa nʼafono ho a, ");
INSERT INTO twiasante_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ɛsɛ sɛ ɔsɔfoɔ no hwɛ; sɛ ɔhwɛ na ɔhunu sɛ yadeɛ no adidi kɔ honam no mu na ɔsane hunu enwi a ɛte sɛ akokɔsradeɛ wɔ ekuro no mu a, ɛsɛ sɛ ɔpae mu ka sɛ onipa no yare kwata. ");
INSERT INTO twiasante_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Na sɛ ɔsɔfoɔ no hwɛ na ɔhunu sɛ yadeɛ no nnidi nkɔɔ honam no mu, na mmom, ɛwɔ honam no ani a enwi tuntum wɔ mu a, ɛsɛ sɛ wɔyi onipa no firi nnipa mu nnanson, ");
INSERT INTO twiasante_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","na ne nnanson so no, wɔsane hwɛ no bio. Sɛ yadeɛ no ntrɛtrɛeɛ na enwi a ɛte sɛ akokɔsradeɛ nnaa ne ho adi wɔ mu na ɛnnidi nkɔɔ honam no mu a, ");
INSERT INTO twiasante_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ɔbɛwerɛ enwi a atwa ekuro no ho ahyia nyinaa (na mmom ɛnyɛ ekuro no mu ankasa) na ɔsɔfoɔ no ayi no afiri nnipa mu nnanson bio. ");
INSERT INTO twiasante_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ne nnanson so, ɔbɛsane ahwɛ no bio na sɛ yadeɛ no ntrɛtrɛeɛ, nnidi nkɔɔ honam no mu a, ɔsɔfoɔ no bɛpae mu aka sɛ onipa no ho ate na sɛ ɔsi ne ntoma wie a, na afei wadi mu. ");
INSERT INTO twiasante_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Na sɛ akyire no saa yadeɛ no trɛtrɛ a, ");
INSERT INTO twiasante_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ɛsɛ sɛ ɔsɔfoɔ no hwɛ no bio a ɔnhwɛ sɛ enwi a ɛte sɛ akokɔsradeɛ fra yadeɛ no mu na ɔpae mu ka sɛ, onipa no yare kwata. ");
INSERT INTO twiasante_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Na sɛ yadeɛ no trɛ a ɛretrɛtrɛ no gyae na sɛ enwi tuntum fu wɔ beaeɛ hɔ a, na ɛkyerɛ sɛ, ne ho atɔ no a kwata biara nni ne ho enti ɛsɛ sɛ ɔsɔfoɔ no pae mu ka sɛ, ne ho ate. ");
INSERT INTO twiasante_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Sɛ ɔbarima anaa ɔbaa bi honam ani yɛ fitaa nahanaha, ");
INSERT INTO twiasante_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","na akyire no, honam no ani dum ara na ɛredum a, na ɛnkyerɛ sɛ kwata ayɛ onipa no, na mmom, ɛyɛ yare foforɔ bi. ");
INSERT INTO twiasante_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Sɛ obi tiri so pa a, ɛwom sɛ ne tiri so apa deɛ, nanso ɛno nkyerɛ sɛ ɔyɛ ɔkwatani! ");
INSERT INTO twiasante_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Sɛ obi tiri so pa firi ne moma so a, na ne moma so ara na apa, na ɛnkyerɛ sɛ ɛyɛ kwata. ");
INSERT INTO twiasante_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Na mmom, sɛ nsisiiɛ nkɔkɔɔ a fitaa frafra mu wɔ atipa no so a, na ɛkyerɛ sɛ, ebia, kwata pɛ sɛ ɛyɛ saa onipa no. ");
INSERT INTO twiasante_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Sɛ ɛba saa a, ɔsɔfoɔ no bɛhwɛ no na sɛ biribi kɔkɔɔ aboa ne ho baabi te sɛ kwata a, ");
INSERT INTO twiasante_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","na ɛkyerɛ sɛ, kwata ayɛ no, enti ɛsɛ sɛ ɔsɔfoɔ no pae mu ka sɛ, onipa no yare kwata. ");
INSERT INTO twiasante_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Onipa biara a wɔbɛhunu sɛ ɔyare kwata no, ɛsɛ sɛ ɔfira ntoma a atete na ɔma ne tirinwi fu, twa mpɛsɛmpɛsɛ na ɔkata nʼanim fa na ɔnam a ɔteateam sɛ, ‘Me ho nte! Me ho nte!’ ");
INSERT INTO twiasante_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Na nna dodoɔ a yadeɛ no nkɔeɛ no deɛ, wɔbɛfa ɔyarefoɔ no sɛ ne ho nte enti ɛsɛ sɛ ɔtena kuro no akyi baabi. ");
INSERT INTO twiasante_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Sɛ kwata ho nsɛnkyerɛnneɛ bi ka atadeɛ mu ");
INSERT INTO twiasante_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","kuntutam anaa nweratam, aboa nhoma anaa biribiara a wɔde aboa nwoma ayɛ mu, ");
INSERT INTO twiasante_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","na sɛ nsisiiɛ ahahammono anaa kɔkɔɔ wɔ mu a, ebia na ɛyɛ kwata, enti ɛsɛ sɛ wɔde kɔma ɔsɔfoɔ na ɔhwɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Ɔsɔfoɔ no de bɛkɔ akɔsie nnanson ");
INSERT INTO twiasante_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","na nnanson so no, wasane ahwɛ bio. Na sɛ ɔhunu sɛ nsisiiɛ no atrɛtrɛ a, na ɛkyerɛ sɛ, ɛyɛ kwata a ɛtumi sane nnipa, ");
INSERT INTO twiasante_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","enti ɛsɛ sɛ ɔde ogya hye ntoma, kuntu ne ntadetam ne aboa nhoma no nyinaa, ɛfiri sɛ, ɛnam yeinom so bɛtumi ama yadeɛ no asane nnipa. ");
INSERT INTO twiasante_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Na sɛ ne nnanson so no ɔhwɛ na sɛ nsisiiɛ no ntrɛtrɛeɛ a, ");
INSERT INTO twiasante_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ɔsɔfoɔ no bɛhyɛ ama wɔasi nneɛma a wɔdwene sɛ yadeɛ no bi wɔ mu no no nyinaa na wɔakora no baabi bio nnanson. ");
INSERT INTO twiasante_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Sɛ nnanson bio akyi faako a yadeɛ no wɔ hɔ no nsesaa nʼahosuo na ɛntrɛtrɛɛ a, wɔbɛfa no sɛ ɛyɛ kwata enti ɛsɛ sɛ wɔhye adeɛ no, ɛfiri sɛ, yadeɛ no adidi kɔ mu ara yie. ");
INSERT INTO twiasante_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Na sɛ ɔsɔfoɔ no hunu sɛ nneɛmasie no akyi, nsisiiɛ no ano abrɛ ase a, ɔbɛtwa hɔ afiri ntoma anaa aboa nhoma a wɔde adi dwuma bi no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Na sɛ ɛsane ba bio deɛ a, na ɛyɛ kwata enti ɛsɛ sɛ wɔhye no. ");
INSERT INTO twiasante_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Sɛ wɔsi na asɛm biara amma ho a, wɔtumi de di dwuma biara ɛberɛ a wɔasane asi bio no.” ");
INSERT INTO twiasante_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Yeinom ne mmara a ɛfa kwata a ɛwɔ ntoma anaa biribiara a wɔde aboa nwoma ayɛ a wɔnam so da no adi sɛ kwata wɔ dekodeɛ no mu anaa ebi nni mu no ho. ");
INSERT INTO twiasante_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Ɛda a wɔbɛdwira ɔkwatani ho no, ɛho mmara nie: Wɔde no bɛkɔ akɔma ɔsɔfoɔ, ");
INSERT INTO twiasante_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","na ɔsɔfoɔ no ahwɛ no wɔ sraban no akyi. Na sɛ ɔsɔfoɔ no hunu sɛ kwata no agyae a, ");
INSERT INTO twiasante_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ɔbɛbisa nnomaa mmienu bi a wɔwe, na afei wɔde ntweneduro, koogyan ahoma ne hisope mman a wɔde bɛyɛ ahodwira ahyɛdeɛ ama ɔkwatani no abrɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ɔsɔfoɔ no bɛka ama wɔakum nnomaa no mu baako wɔ ayowaa a nsuo wɔ mu so. ");
INSERT INTO twiasante_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Na anomaa a wɔnnya nkum no no nso, wɔde ɔno ne ntweneduro no ne koogyan ahoma no ne hisope mman no bɛhyɛ anomaa a wɔkumm no no mogya no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Na ɔsɔfoɔ no apete mogya no agu ɔkwatani a ne ho afiri no so mprɛnson, na wapae mu aka sɛ ne ho ate na wagyaa anomaa a wɔnkum no no. ");
INSERT INTO twiasante_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Na ɔyarefoɔ a ne ho atɔ no no bɛsi ne ntoma nyinaa. Ɔbɛyi ne ho nwi nyinaa nso. Ɔbɛdware na wasane abɛtena baabi a kane no na ɔte hɔ bio; nanso ɛsɛ sɛ ɔtena ne ntomadan akyi nnanson. ");
INSERT INTO twiasante_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Nnanson no so no, ɔbɛyi ne ho nwi nyinaa bio, ɔbɛyi nʼabɔgyesɛ ayi nʼanintɔn nwi na wayi ne ho nwi a aka nyinaa, na wadware, na afei wɔapae mu aka sɛ ne ho ate. ");
INSERT INTO twiasante_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Ɛda a ɛdi so a ɛyɛ nnawɔtwe so no, ɔbɛfa nnwammaa anini mmienu a wɔn ho nni dɛm ne odwammaa bereɛ baako a ɔno nso ho nni dɛm, asikyiresiam muhumuhu lita nsia a wɔde ngo afra ne ngo a wɔmfa mfraa hwee lita fa. ");
INSERT INTO twiasante_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Afei ɔsɔfoɔ a ɔbɛhwehwɛ ɔyarefoɔ no ho ahwɛ sɛ ne ho atɔ no no de onipa no ne nʼafɔrebɔdeɛ bɛba Awurade anim wɔ Ahyiaeɛ Ntomadan no ano. ");
INSERT INTO twiasante_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Ɔsɔfoɔ no bɛfa nnwammaa no baako ne ngotoa baako no na ɔde ama Awurade sɛ ɛfɔdie afɔrebɔ a wɔhim no wɔ afɔrebukyia no anim. ");
INSERT INTO twiasante_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Afei, wɔbɛkum odwammaa no wɔ beaeɛ a wɔbɔ bɔne ne ɔhyeɛ afɔdeɛ no wɔ kronkronbea hɔ. Wɔde saa afɔdie afɔrebɔdeɛ yi bɛma ɔsɔfoɔ no sɛdeɛ wɔyɛ no bɔne afɔrebɔ mu no ara pɛ. Ɛyɛ afɔrebɔ a ɛyɛ kronkron ankasa. ");
INSERT INTO twiasante_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ɔsɔfoɔ no bɛfa saa ɛfɔdie afɔrebɔdeɛ mogya na ɔde akeka ɔyarefoɔ a wɔrete ne ho no aso nifa ase ne ne nsa nifa kokurobetie ne ne nan nifa kokurobetie. ");
INSERT INTO twiasante_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Afei, ɔsɔfoɔ no bɛfa ngo no bi ahwie agu ne nsa benkum mu ");
INSERT INTO twiasante_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","na ɔde ne nsa nifa abɔ mu, na watu apete mprɛnson wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ngo no a ɛbɛka ne nsa benkum mu no, ɔsɔfoɔ no de bɛka onipa no aso nifa ase ne ne nsa nifa kokurobetie ne ne nan nifa kokurobetie sɛdeɛ ɔde ɛfɔdie mogya yɛeɛ wɔ ɛfɔdie afɔrebɔ no mu no ara pɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ɔde ngo no nkaeɛ a ɛwɔ ne nsam no bɛfɔ ɔbarima no tiri ho. Yei bɛkyerɛ sɛ, ɔsɔfoɔ no de ne ho ayɛ mpatadeɛ ama onipa no wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Afei, ɛsɛ sɛ ɔsɔfoɔ no bɔ bɔne afɔdeɛ na ɔsane yɛ mpatadeɛ ho adeɛ ma onipa a wɔrehohoro ne ho afiri ne kwata mu no ho; ɛno akyi, ɔsɔfoɔ no bɛkum ɔhyeɛ afɔrebɔdeɛ no ");
INSERT INTO twiasante_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","na ɔde abɔ ɛne atokoɔ afɔdeɛ wɔ afɔrebukyia no so de ayɛ mpatadeɛ ama ɔbarima no na afei, wapae mu aka sɛ ne ho afiri. ");
INSERT INTO twiasante_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Sɛ ɔyɛ ohiani a ɔrentumi ntɔ nnwammaa mmienu no a, ɛnneɛ, ɔde odwammaanini baako bɛbɔ ɛfɔdie afɔdeɛ no de ama Awurade sɛ mpatadeɛ a wɔhim no afɔrebukyia no anim; na wɔde asikyiresiam fitaa muhumuhu lita mmienu ne fa a wɔde ngo afra de abɔ atokoɔ afɔdeɛ no a ngo akɔtoa ka ho. ");
INSERT INTO twiasante_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Ɛno akyi, ɔde mmorɔnoma mmienu anaa nturukuku mma mmienu mu biara a ɔbɛnya no mu baako bɛbɔ bɔne afɔdeɛ na ɔde baako a ɔbɛka no nso abɔ ɔhyeɛ afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Ɛda a ɛtɔ so nnwɔtwe no, ɔde ne nyinaa bɛkɔ akɔma ɔsɔfoɔ no wɔ Ahyiaeɛ Ntomadan no ano na ɔsɔfoɔ no de adwira no wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ɔsɔfoɔ no bɛfa odwammaa no de abɔ ɛfɔdie afɔdeɛ. Ɔde ngo toa ma bɛka ho na wahim no afɔrebukyia no anim de akyerɛ sɛ, wɔde rema Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Afei, wɔbɛkum odwammaa no de no abɔ ɛfɔdie afɔdeɛ na ɔde ne mogya no bi akeka ɔbarima a wɔredwira no no aso nifa ase. Ɔde mogya no bi bɛka ne nsa nifa kokurobetie ne ne nan nifa kokurobetie. ");
INSERT INTO twiasante_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ɔsɔfoɔ no bɛhwie ngo agu ɔno ara ne nsa benkum mu ");
INSERT INTO twiasante_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","na ɔde ne nsateaa nifa abɔ mu apete bi mprɛnson wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Na ɛsɛ sɛ ɔde ngo a ɛwɔ ne nsam no bi ka ɔbarima no aso nifa ase ne ne nsa nifa kokurobetie ne ne nan nifa kokurobetie sɛdeɛ ɔyɛɛ mogya no ɛberɛ a ɔrebɔ ɛfɔdie afɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ngo no a ɛbɛka wɔ ne nsam no, ɛsɛ sɛ ɔde fɔ ɔbarima a wɔredwira no no tiri ho de yɛ mpatadeɛ wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Afei, ɛsɛ sɛ ɔde nturukuku mmienu anaa mmorɔnoma mmienu no mu biara a ɔtumi tɔeɛ no ba. ");
INSERT INTO twiasante_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Wɔde mmienu a ɔnyaeɛ no mu baako bɛbɔ bɔne afɔdeɛ na baako a aka no, ɔde abɔ ɔhyeɛ afɔdeɛ a saa ɛberɛ no ara mu wɔbɛbɔ atokoɔ afɔdeɛ nso, na ɔsɔfoɔ no bɛyɛ mpatadeɛ ama ɔbarima no wɔ Awurade anim.” ");
INSERT INTO twiasante_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Yeinom ne mmara a ɛfa wɔn a wɔte wɔn ho ma wɔn ho fi kwata mu nanso wɔntumi mfa afɔrebɔdeɛ a ɛho hia no nyinaa mma no. ");
INSERT INTO twiasante_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Afei, Awurade ka kyerɛɛ Mose ne Aaron sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Sɛ moduru Kanaan asase a mede ama mo no so, na sɛ mede kwata kɔ afie bi mu a, ");
INSERT INTO twiasante_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ɛnneɛ, efiewura no nyi ne ho adi nkyerɛ ɔsɔfoɔ no na ɔnka sɛ, ‘Ɛyɛ me sɛ kwata wɔ me fie ha!’ ");
INSERT INTO twiasante_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ɔsɔfoɔ no bɛhyɛ ama wɔatu efie hɔ nneɛma nyinaa ansa na wahwɛ hɔ sɛdeɛ ɛbɛyɛ a, sɛ ɔka sɛ kwata wɔ fie hɔ a, ɛrengu biribi foforɔ ho fi wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Sɛ ɔhunu nsensaneɛ ahahammono anaa kɔkɔɔ wɔ efie no afasuo ho a anonom kɔ afasuo no mu a, ");
INSERT INTO twiasante_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ɔbɛto efie no mu nnanson ");
INSERT INTO twiasante_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","na ne nnanson so no, wasane aba bio abɛhwɛ. Na sɛ nsensaneɛ awurawura afasuo no mu a, ");
INSERT INTO twiasante_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ɛnneɛ, ɔsɔfoɔ no bɛhyɛ ama wɔawerɛwerɛ nsisiiɛ no afiri hɔ na wɔato nwerɛwerɛeɛ no agu baabi a ɛhɔ ho nte wɔ kuro no akyi baabi. ");
INSERT INTO twiasante_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Afei, ɔbɛhyɛ ama afasuo a ɛwɔ efie no mu no, wɔawerɛwerɛ no yie na wɔato nwerɛwerɛeɛ no agu baabi a ɛhɔ nte wɔ kuro no akyi baabi. ");
INSERT INTO twiasante_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Na wɔde aboɔ foforɔ bi abɛhyɛ deɛ wɔwerɛwerɛeɛ no anan na wɔde dɔteɛ foforɔ asra efie no ho. ");
INSERT INTO twiasante_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Na sɛ nsisiiɛ no ba bio a, ");
INSERT INTO twiasante_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ɔsɔfoɔ no bɛba bio abɛhwɛ na sɛ ɔhunu sɛ nsisiiɛ no atrɛtrɛ a, na ɛyɛ kwata na ɛkyerɛ sɛ efie no ho nte. ");
INSERT INTO twiasante_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Sɛ ɛba saa a, ɔbɛhyɛ ama wɔabubu efie no agu. Wɔbɛtwe mmubuiɛ no mu aboɔ, nnua ne dɔteɛ no nyinaa afiri kuro no mu de akɔgu kuro no akyi baabi a ɛhɔ ho nte. ");
INSERT INTO twiasante_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Obiara a ɔbɛwura efie a wɔato mu no mu no ho nte kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Na obiara a ɔbɛda hɔ anaa ɔbɛdidi wɔ efie hɔ no bɛsi ne nneɛma nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Na sɛ wɔsra efie no ho bio na ɔsɔfoɔ no bɛhwɛ na nsisiiɛ no mmaa bio a, ɔbɛpae mu aka sɛ wɔate efie no ho na kwata no nso kɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ɔbɛdi efie no ahodwira ho dwuma. Ɔde nnomaa mmienu, sida dua, asaawa kɔkɔɔ ne hisope mman na ɛbɛdi saa dwuma no. ");
INSERT INTO twiasante_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ɔbɛkum nnomaa no baako wɔ nsu pa a ɛwɔ ayowaa mu so, ");
INSERT INTO twiasante_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","na ɔde sida dua no ne hisope mman ne ahoma kɔkɔɔ ne anomaa a wɔnkum no no anu anomaa a wakum no nsu pa no so no mogya mu na wɔde apete efie no mprɛnson. ");
INSERT INTO twiasante_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Wɔyɛ yei de te efie no ho. ");
INSERT INTO twiasante_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Afei, ɔbɛgyae anomaa a ɔnwuiɛ no ama watu akɔ kuro no akyi baabi. Yei ne ɛkwan a wɔfa so de yɛ mpatadeɛ de ma efie sane de dwira ho no.” ");
INSERT INTO twiasante_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Yeinom ne mmara a ɛfa mmeammea a kwata ba hɔ ho. ");
INSERT INTO twiasante_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Sɛ ɛyɛ atadeɛ mu anaa efie mu, ");
INSERT INTO twiasante_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","anaa honam ani nhonhonoeɛ, anaa ɔhyehyeɛ mu mpumpunnya anaa honam ani baabi a ɛhɔ ayɛ hyɛnn. ");
INSERT INTO twiasante_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Saa ɛkwan yi so na wɔbɛfa ahunu sɛ ɛyɛ kwata anaa ɛnyɛ kwata. Yei enti na wɔhyɛɛ saa mmara yi. ");
INSERT INTO twiasante_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Awurade ka kyerɛɛ Mose ne Aaron sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Monhyɛ saa mmara yi mma Israelfoɔ: ‘Ɔbarima biara a ne ho bɛsene aguo no, ne ho agu fi. ");
INSERT INTO twiasante_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ɛberɛ a ne ho resene guo ne ɛberɛ a agyae no nyinaa ma ne ho gu fi. ");
INSERT INTO twiasante_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Mpa a ɔbɛda so ne biribiara a ɔbɛtena so nso ho gu fi; ");
INSERT INTO twiasante_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","enti obiara a ɔde ne ho ka ɔbarima no mpa ho gu fi kɔsi anwummerɛ, enti ɛsɛ sɛ ɔsi ne ntoma na ɔdware. ");
INSERT INTO twiasante_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Obiara a ɔbɛtena akonnwa a ɔbarima no atena so so ho gu fi kɔsi anwummerɛ, enti ɛsɛ sɛ ɔsi ne ntoma na ɔdware. ");
INSERT INTO twiasante_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Saa mmara yi ka obiara a ɔde ne ho bɛka ɔbarima no. ");
INSERT INTO twiasante_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Obiara a ɔbarima no bɛte ntasuo agu ne so no ho nte kɔsi anwummerɛ enti ɛsɛ sɛ onii no si ne ntoma na ɔdware. ");
INSERT INTO twiasante_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Ɔpɔnkɔ adwa biara a ɔbɛtena so no ho agu fi. ");
INSERT INTO twiasante_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Obiara a ne ho bɛka biribiara a aka saa onipa no ase no ho nte kɔsi anwummerɛ, enti ɛsɛ sɛ ɔsi ne ntoma na ɔdware. ");
INSERT INTO twiasante_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Sɛ onipa a ne ho nte no rekɔsɔ obi mu na wanhohoro ne nsa ansa a, ɛsɛ sɛ onipa ko no si ne ntoma, dware ne ho, ɛfiri sɛ, ne ho nte kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Sɛ saa onipa no sɔ ayowaa biara mu a, ɛsɛ sɛ wɔbɔ no na sɛ ɛyɛ mukaase biribi a wɔde dua na asene deɛ a, ɛsɛ sɛ wɔde nsuo hohoro ho. ");
INSERT INTO twiasante_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Sɛ nʼahosene no twa a, ɛsɛ sɛ ɔde nnanson firi ahodwira ho ahosiesie ase na ɔsi ne ntoma na ɔkɔdware wɔ asubɔnten mu. ");
INSERT INTO twiasante_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ɛda a ɛtɔ so nwɔtwe no, ɔde nturukuku mmienu anaa mmorɔnoma mma mmienu bɛba Awurade anim wɔ Ahyiaeɛ Ntomadan no ano na ɔde ama ɔsɔfoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Ɔsɔfoɔ no de wɔn bɛbɔ afɔdeɛ a baako yɛ bɔne ho afɔdeɛ na baako no nso yɛ ɔhyeɛ afɔdeɛ; na ɛkyerɛ sɛ, ɔsɔfoɔ no bɛyɛ mpatadeɛ wɔ Awurade anim ama ɔbarima no, ɛnam nʼahosene no enti. ");
INSERT INTO twiasante_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Sɛ ɔbarima biara ahobaa gu a, ɛsɛ sɛ ɔdware ne ho nyinaa, ɛfiri sɛ, ne ho nso nte kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ntoma anaa mpasotam biara a ahobaa no bi bɛgu mu no, ɛsɛ sɛ wɔsi, ɛfiri sɛ, ɛho nte kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Sɛ ɔbarima fa ɔbaa a, wɔn nna no akyi, ɛsɛ sɛ ɔbaa no ne ɔbarima no nyinaa dware, ɛfiri sɛ, wɔn ho nte kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Sɛ ɔbaa kɔ afikyire a, ne ho nte nnanson mu. Saa ɛberɛ no mu, obiara a ɔde ne ho bɛka no no nso ho nte kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Biribiara a ɔbɛda so anaa ɔbɛtena so saa ɛberɛ no mu no nso ho agu fi. ");
INSERT INTO twiasante_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Obiara a ɔde ne nsa bɛka ne mpa anaa biribiara a ɔtena so no bɛsi ne ntoma, adware, ɛfiri sɛ, onii no ho agu fi kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Sɛ obi sɔ biribi a watena so mu nso a, ɛsɛ sɛ ɔsi ne ntoma na ɔdware, ɛfiri sɛ, ne ho agu fi kɔsi anwummerɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","sɛ ɛyɛ ne mpasotam anaa nʼakonnwa. ");
INSERT INTO twiasante_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Sɛ ɔbarima ne no da saa ɛberɛ yi mu a, ɔbarima no ho gu fi nnanson; na mpa biara a ɔbarima no bɛda so no nso ho gu fi. ");
INSERT INTO twiasante_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Sɛ ɛberɛ duru sɛ ɔfiri nanso mogya da so ba anaasɛ mogya ba ɛberɛ a ɛnsɛ mu wɔ bosome no mu a, mmara korɔ no ara na wɔde ka ho asɛm, ");
INSERT INTO twiasante_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","na ɛkyerɛ sɛ, biribiara a ɔbɛda so saa ɛberɛ no ho agu fi te sɛ deɛ nʼafikyikɔ berɛ mu ɔtena biribi so a, ɛho gu fi no ara pɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Obiara a ɔde ne nsa bɛka ne mpa anaa biribiara a ɔtena so no ho agu fi a ɛsɛ sɛ ɔsi ne ntoma, sane dware, ɛfiri sɛ, ne ho nte kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Nnanson akyi, sɛ afikyikɔ no twa a, na ɔnni efi mu bio. ");
INSERT INTO twiasante_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ɛda a ɛtɔ so nwɔtwe no, ɔde nturukuku mmienu anaa mmorɔnoma mma mmienu bɛkɔ akɔma ɔsɔfoɔ no wɔ Ahyiaeɛ Ntomadan no kwan ano ");
INSERT INTO twiasante_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","na ɔsɔfoɔ no de baako abɔ bɔne ho afɔdeɛ na ɔde baako abɔ ɔhyeɛ afɔdeɛ na ayɛ mpatadeɛ ama ɔbaa no wɔ Awurade anim wɔ nʼafikyikɔ no ho fi no ho. ");
INSERT INTO twiasante_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Saa ɛkwan yi so na sɛ Israelfoɔ no bi ho gu fi a, mobɛfa de ate wɔn ho anyɛ saa a, ɛsiane sɛ wɔagu mʼAhyiaeɛ Ntomadan a ɛsi wɔn mu no ho fi enti, wɔbɛwuwu.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Yeinom ne mmara a ɛwɔ hɔ ma ɔbarima a ne ho sene ");
INSERT INTO twiasante_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ne ɔbaa a wakɔ afikyire ne obiara a ɔde ne ho ka ɔsakyimafoɔ wɔ ɛberɛ a ne ho nteɛ no mu no. ");
INSERT INTO twiasante_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aaron mmammarima baanu a wɔwuwuu wɔ Awurade anim wuo akyi no, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“Bɔ wo nua Aaron kɔkɔ sɛ, ɔnnkɔ kronkronbea hɔ wɔ ntwamutam no akyi beaeɛ a apam adaka no si ne mmɔborɔhunu beaeɛ hɔ kwa. Ɔkɔ hɔ a ɔbɛwu, ɛfiri sɛ, mʼankasa mewɔ omununkum a ɛkata mpata beaeɛ so no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Sɛ ɔpɛ sɛ ɔkɔ hɔ a, deɛ ɛsɛ sɛ ɔyɛ nie: Ɛsɛ sɛ ɔde nantwinini ba ba ma wɔde bɔ bɔne ho afɔdeɛ na ɔde odwennini nso ba ma wɔde bɔ ɔhyeɛ afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ɛsɛ sɛ ɔdware na ɔhyɛ atadeɛ nahanaha ne ne nhyɛaseɛ na ɔbɔ abɔwomu ne abotire. ");
INSERT INTO twiasante_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Afei, Israelfoɔ bɛbrɛ no mmirekyie mmienu a wɔde bɛbɔ wɔn bɔne ho afɔdeɛ ne odwennini a wɔde bɛbɔ wɔn ɔhyeɛ afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Deɛ ɛdi ɛkan no, ɔde nantwie ba no bɛma Awurade sɛ bɔne ho afɔdeɛ a ɔrebɔ ama ne ho de ayɛ mpatadeɛ ama ne ho ne ne fiefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Afei, ɔde mmirekyie mmienu no bɛba Awurade anim wɔ Ahyiaeɛ Ntomadan no ano ");
INSERT INTO twiasante_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","na wɔabɔ wɔn so ntonto ahunu Awurade deɛ, ne deɛ ɛsɛ sɛ wɔsane de no korɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaron de abirekyie a wɔde no rebɛbɔ Awurade afɔdeɛ no bɛbɔ bɔne ho afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Wɔrenkum abirekyie baako a aka no na wɔde no aba Awurade anim. Wɔbɛyɛ mpatadeɛ ho dwumadie bi agu ne so na wɔde no akɔ ɛserɛ so akɔgya no wɔ hɔ sɛ mpatadwan. ");
INSERT INTO twiasante_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aaron de nantwinini ba no abɔ bɔne ho afɔdeɛ ama ne ho ne ne fiefoɔ awie no, ");
INSERT INTO twiasante_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ɔbɛfa adeɛ a wɔhye aduhwam wɔ mu a egyasramma a wɔfaa no Awurade afɔrebukyia no so ayɛ no ma. Afei ɔde aduhwam a wɔayam no muhumuhu bɛyɛ ne nsam na ɔde akɔ ntwamutam no akyi. ");
INSERT INTO twiasante_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ɛhɔ na ɔde aduhwam no bɛgu bidie no so wɔ Awurade anim na ayi wisie kumɔnn wɔ mpata beaeɛ apam ne adaka (a aboɔ apono a wɔatwerɛ Mmaransɛm Edu agu so wɔ mu) no so nyinaa sɛdeɛ ɛbɛyɛ a ɔrenwu. ");
INSERT INTO twiasante_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Na ɔde nantwinini ba no mogya no bi bɛba na ɔde ne nsateaa baako abɔ mu apete mpata beaeɛ hɔ apueeɛ fam na wapete no mprɛnson wɔ animu. ");
INSERT INTO twiasante_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Afei, ɛsɛ sɛ ɔfiri adi na ɔde abirekyie no kɔbɔ ɔmanfoɔ no bɔne ho afɔdeɛ na wɔde ne mogya no ba ntwamutam no akyi na wɔpete gu mpata beaeɛ hɔ ne animu sɛdeɛ ɔde nantwinini ba no mogya no yɛeɛ no ara pɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Na ɛkyerɛ sɛ, wayɛ mpatadeɛ ama beaeɛ kronkron hɔ, ɛfiri sɛ, Israelfoɔ bɔne ama efi aka beaeɛ hɔ ne Ahyiaeɛ Ntomadan no a wɔasi wɔ wɔn mfimfini hɔ no. ");
INSERT INTO twiasante_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Sɛ Aaron wura Ahyiaeɛ Ntomadan no mu kɔ kronkronbea hɔ rekɔyɛ mpatadwuma no a, ɛnni ho kwan sɛ obiara kɔ hɔ bi, gye sɛ ɔyɛ mpatadeɛ no ma ne ho ne ne fiefoɔ ne Israelfoɔ nyinaa wie. ");
INSERT INTO twiasante_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Afei, ɔbɛkɔ afɔrebukyia no ho wɔ Awurade anim akɔyɛ mpatadeɛ ama afɔrebukyia no. Ɛsɛ sɛ ɔde nantwinini ba no ne abirekyie mogya no fɔre mmɛn a ɛtuatua afɔrebukyia no ho no ho, ");
INSERT INTO twiasante_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","na ɔde ne nsateaa baako pete mogya no mprɛnson gu afɔrebukyia no so de te ho firi Israelfoɔ bɔne no ho yɛ no kronkron. ");
INSERT INTO twiasante_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Sɛ ɔwie mpatadeɛ a ɛfa kronkronbea hɔ ne Ahyiaeɛ Ntomadan no ho nsɛm nyinaa ne afɔrebukyia no ho a, ɔde abirekyie no bɛba anikann ");
INSERT INTO twiasante_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","de ne nsa mmienu agu aboa no apampam, na waka atirimuɔden ne atuateɛ a Israelfoɔ ayɛ, wɔn bɔne nyinaa de agu abirekyie no apampam, na obi a wɔayi no sɛ ɔnyɛ saa adwuma no de aboa no bɛkɔ ɛserɛ so. ");
INSERT INTO twiasante_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Enti abirekyie no bɛsoa nnipa no bɔne nyinaa de akɔ asase a obi nte so no so na onii no agyaa no wɔ ɛserɛ so hɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Afei, Aaron bɛkɔ Ahyiaeɛ Ntomadan mu hɔ bio akɔworɔ nʼatadeɛ nahanaha a ɔhyɛɛ wɔ ntwamutam no akyi no na wagya no wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ɔbɛkɔ akɔdware wɔ baabi a wɔate hɔ ho na wahyɛ ne ntadeɛ no bio na wafiri adi akɔbɔ ɔno ankasa ɔhyeɛ afɔdeɛ asane abɔ ɔhyeɛ afɔdeɛ ama nnipa no na wayɛ mpatadeɛ ama ne ho ne wɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ɔbɛhye sradeɛ de abɔ bɔne ho afɔdeɛ wɔ afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Akyire no, ɔbarima a ɔde abirekyie no kɔɔ ɛserɛ so no bɛsi ne ntoma na wadware na wasane aba beaeɛ hɔ bio. ");
INSERT INTO twiasante_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Na nantwie ba ne abirekyie a wɔde bɔɔ bɔne ho afɔdeɛ no a Aaron de wɔn mogya kɔɔ kronkronbea hɔ kɔyɛɛ mpatadeɛ no, wɔde wɔn bɛkɔ sraban no akyiri baabi akɔhye a wɔn ho nhoma ne wɔn ayamdeɛ ka ho. ");
INSERT INTO twiasante_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Akyire yi, onipa a ɔrebɛhye afɔrebɔdeɛ no bɛsi ne ntoma, adware na wasane akɔ beaeɛ hɔ bio. ");
INSERT INTO twiasante_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Yei yɛ mmara a ɛwɔ hɔ daa. Ɔbosome a ɛtɔ so nson dadu so no, ɛnsɛ sɛ moyɛ adwuma biara, na mmom, momfa saa ɛda no nkari mo ho nhwɛ wɔ ahobrɛaseɛ mu. Saa mmara yi ka wɔn a wɔwoo wɔn wɔ asase yi so anaa ahɔhoɔ a wɔne Israelfoɔ teɛ; ");
INSERT INTO twiasante_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ɛfiri sɛ, ɛda yi na wɔde kae mo mpata ne mo ahodwira wɔ mo bɔne ho wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ɛyɛ homeda a ɛsɛ sɛ mode home enti ɛsɛ sɛ modi ɛda no dinn wɔ ahobrɛaseɛ mu. Ɛyɛ mmara a ɛwɔ hɔ daa. ");
INSERT INTO twiasante_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Saa ahyɛdeɛ yi, awoɔ ntoatoasoɔ akyi, Ɔsɔfopanin a wɔasra no no na ɔbɛsi ne nana Aaron anan adi ho dwuma wɔ beaeɛ hɔ. Ɔno nko ara na ɔwɔ ho kwan sɛ ɔhyɛ atadeɛ kronkron nahanaha no ");
INSERT INTO twiasante_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","na ɔyɛ mpatadeɛ wɔ kronkronbea hɔ wɔ Ahyiaeɛ Ntomadan mu hɔ, afɔrebukyia no so, de ma asɔfoɔ no ne nnipa no. ");
INSERT INTO twiasante_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Yei bɛyɛ mmara a ɛbɛtena hɔ daa ama mo, na Israelfoɔ bɔne enti, moagyina so afe biara de ayɛ mpatadeɛ ama Israelfoɔ afiri wɔn bɔne nyinaa mu.” Na Mose dii mmara a Awurade hyɛ maa no nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Hyɛ saa mmara a ɛfiri Awurade nkyɛn yi ma Aaron ne ne mma ne Israelfoɔ no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Israelni biara a ɔde nantwie, odwammaa anaa abirekyie bɛbɔ afɔdeɛ wɔ sraban mu anaa akyire no ");
INSERT INTO twiasante_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","a anka ɛsɛ sɛ ɔde no ba Ahyiaeɛ Ntomadan no ano hɔ de no ma Awurade sɛ afɔrebɔdeɛ wɔ Awurade Ahyiaeɛ Ntomadan no ano no, wɔbɛfa saa onipa no sɛ wahwie mogya agu enti ɛsɛ sɛ wɔtwa no asuo firi ne manfoɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Saa mmara yi bɛbra Israelfoɔ no a ɛremma wɔmfa mmoa mmɔ afɔdeɛ wɔ wiram baabiara kwa. Ɛbɛhyɛ wɔn ama wɔde afɔrebɔdeɛ no abrɛ ɔsɔfoɔ no wɔ Ahyiaeɛ Ntomadan no kwan ano sɛdeɛ ɔsɔfoɔ no bɛtumi de ama Awurade sɛ asomdwoeɛ afɔrebɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Sɛ wɔfa saa ɛkwan no so a, ɔsɔfoɔ no bɛtumi apete mogya agu Awurade afɔrebukyia no so wɔ Ahyiaeɛ Ntomadan no kwan ano na wɔahye sradeɛ no sɛ ohwam ama Awurade ani asɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Na ama ɔmanfoɔ agyae afɔdeɛ a wɔbɔ ma ahonhommɔne wɔ wiram no. Yei bɛyɛ mmara a ɛbɛtena hɔ daa ama mo firi awoɔ ntoatoasoɔ so akɔsi awoɔ ntoatoasoɔ so. ");
INSERT INTO twiasante_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Meti mu bio sɛ, ‘Hyɛ saa mmara yi nso ma wɔn. Sɛ Israelfoɔ anaa ahɔhoɔ a wɔne mo te no de ɔhyeɛ afɔrebɔdeɛ no anaa afɔrebɔ no ba, ");
INSERT INTO twiasante_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","na sɛ wɔamfa amma Ahyiaeɛ Ntomadan no kwan ano amfa amma Awurade a, wɔbɛtwa mo asuo afiri ɔmanfoɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Na mɛdane mʼani matia obiara a ɔbɛdi mogya ɛkwan biara so no; ɛmfa ho sɛ ɔyɛ Israelni anaa ɔhɔhoɔ a ɔte mo mu. ");
INSERT INTO twiasante_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ɛfiri sɛ, ɔhonam no nkwa wɔ mogya no mu, na mama mo mogya sɛ momfa mpete afɔrebukyia no so sɛ mpatadeɛ mma mo akra; nkwa a ɛwɔ mogya mu enti na wɔde yɛ mpatadeɛ ma onipa kra. ");
INSERT INTO twiasante_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ɛno enti, mereka akyerɛ Israelfoɔ sɛ, “Mma wɔn anaa ahɔhoɔ a wɔte wɔn mu no nni mogya.” ");
INSERT INTO twiasante_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Israelni anaa ɔhɔhoɔ biara a ɔte wɔn mu a ɔbɛkɔ ahayɔ na ɔbɛkum aboa anaa anomaa biara a wɔwe ne nam no, ɔnsɔne ne mogya na ɔmfa mfuturo nkata so, ");
INSERT INTO twiasante_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ɛfiri sɛ, aboa biara nkwa ne ne mogya. Ɛno enti na meka kyerɛɛ Israelfoɔ sɛ, “Monnni mmogya, ɛfiri sɛ, nnomaa anaa aboa biara nkwa yɛ ne mogya. Enti obiara a ɔdi mogya no, ɛsɛ sɛ wɔtwa no asuo.” ");
INSERT INTO twiasante_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Obiara a ɔwe aboafunu a ɔno ara awuo anaasɛ akekaboa bi na ɔkumm no no, ɛsɛ sɛ ɔsi ne ntoma na ɔdware, ɛfiri sɛ, ne ho nte kɔsi anwummerɛ; ɛno akyi, ɛsɛ sɛ wɔpae mu ka sɛ ne ho ate. ");
INSERT INTO twiasante_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Na sɛ wansi ne ntoma annware a, wɔne no bɛdi no sɛdeɛ mmara no seɛ.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Awurade ka kyerɛɛ Mose sɛ, “Ka kyerɛ Israelfoɔ no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","‘Mene Awurade mo Onyankopɔn, ");
INSERT INTO twiasante_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","enti mommmɔ mo bra sɛ abosonsomfoɔ. Monnyɛ sɛ nnipa a na mo ne wɔn te wɔ Misraim anaa Kanaan wɔ baabi a mede mo rekɔ no. Monnsuasua wɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Me mmara ne mʼahyɛdeɛ ara so na ɛsɛ sɛ modi; na ɛsɛ sɛ modi so pɛpɛɛpɛ, ɛfiri sɛ, mene Awurade mo Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Sɛ modi so a, mobɛnya nkwa. Mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Mo mu biara nni ho ɛkwan sɛ ɔware obusuani a ɔbɛn no. Mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Ɛnsɛ sɛ abaayewa ware nʼagya anaasɛ ɔbabarima ware ne maame. ");
INSERT INTO twiasante_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Anaa nʼagya yerenom mu bi. ");
INSERT INTO twiasante_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Anaa ne nuabaa anaa nʼagya babaa anaa ne maame babaa, sɛ wɔwoo no efie no mu anaa efie foforɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Ɛnsɛ sɛ moware mo nanabaa, sɛ ɔyɛ mo babarima babaa anaa mo babaa babaa, ɛfiri sɛ, ɔyɛ obusuani. ");
INSERT INTO twiasante_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Ɛnsɛ sɛ woware wo nuabaa a ɔyɛ wʼagya yerenom bi babaa. ");
INSERT INTO twiasante_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Anaa wo sewaa—wo agya nuabaa, ɛfiri sɛ, ɔyɛ wʼagya abusuani pɛɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Saa ara na ɛnsɛ sɛ woware wo maame a ɔyɛ wo maame nuabaa, ɛfiri sɛ, ɔyɛ wo maame abusuani pɛɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Wʼagya nuabarima yere nso, wonni ho ɛkwan sɛ woware no. ");
INSERT INTO twiasante_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Wonni ho ɛkwan sɛ woware wo babarima yere, ɛfiri sɛ, ɔyɛ wʼase. ");
INSERT INTO twiasante_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Saa ara nso na wontumi nnware wo nuabarima yere, ɛfiri sɛ, ɔyɛ wo nuabarima dea. ");
INSERT INTO twiasante_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Worentumi nware ɔbaa bi nsane nware ne babaa anaa ne nanabaa nka ho, ɛfiri sɛ, wɔn nyinaa yɛ abusuafoɔ pɛɛ na ɛyɛ awudisɛm nso. ");
INSERT INTO twiasante_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Ɛnsɛ sɛ woware anuanom mmaa baanu, ɛfiri sɛ, wɔbɛtwe kora. Na sɛ ɛba sɛ wo yere wu na woware ne nuabaa bi deɛ a, ɛyɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Ɛnsɛ sɛ wofa ɔbaa a wakɔ afikyire. ");
INSERT INTO twiasante_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Ɛnsɛ sɛ wofa wo yɔnko yere de gu wo ho fi. ");
INSERT INTO twiasante_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Mfa wo mma mu biara mma Molek na ɔmmfa no mmɔ afɔdeɛ wɔ n’afɔrebukyia so. Ngu wo Onyankopɔn din ho fi, ɛfiri sɛ, mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Ɔbarima a ɔne ne yɔnko barima da yɛ akyiwadeɛ kɛseɛ na ɛyɛ bɔne a ɛso nso. ");
INSERT INTO twiasante_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Ɛnsɛ sɛ ɔbarima fa aboa de gu ne ho fi. Saa ara nso na ɛnsɛ sɛ ɔbaa de ne ho ma aboanini ma ɔfa no. Ɛyɛ akyiwadeɛ kɛseɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Monngu mo ho fi wɔ saa akwan ahodoɔ yi biara so na yeinom ne deɛ abosonsomfoɔ yɛ. Esiane sɛ wɔyɛ saa enti, merebɛyi wɔn afiri asase a morekɔ so no so. ");
INSERT INTO twiasante_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Saa ahohwibra no agu ɔman mu no nyinaa ho fi; ɛno enti na meretwe nnipa a wɔte hɔ no aso na mɛyi wɔn afiri asase no so. ");
INSERT INTO twiasante_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ɛsɛ sɛ modi me mmara ne mʼahyɛdeɛ no nyinaa so pɛpɛɛpɛ na ɛnsɛ sɛ moyɛ saa akyiwadeɛ yi mu bi koraa. Saa mmara yi ka mo a wɔwoo mo Israelman mu ne ahɔhoɔ a wɔne mo te nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Ampa ara, ɛfiri sɛ daa nnipa a wɔte saa asase a mede mo rekɔ so no so yɛ saa akyiwadeɛ yi enti, asase no ho agu fi. ");
INSERT INTO twiasante_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Monnyɛ saa adeɛ no bi, anyɛ saa a, mɛpam mo afiri asase no so sɛdeɛ mɛyɛ wɔn a wɔte hɔ seesei no. ");
INSERT INTO twiasante_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Obiara a ɔbɛyɛ akyiwadeɛ yi mu bi no, wɔbɛtwa no asuo afiri ɔman yi mu. ");
INSERT INTO twiasante_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Enti monhwɛ sɛ mobɛdi me mmara no so na monnyɛ saa abusudeɛ kɛseɛ yi bi. Monnkɔyɛ abususɛm a wɔn a wɔte asase a morekɔ so no yɛ no bi mmfa ngu mo ho fi. Mene Awurade mo Onyankopɔn.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Ka kyerɛ Israelfoɔ no sɛ, ‘Ɛsɛ sɛ moyɛ kronkron, ɛfiri sɛ, me Awurade a meyɛ mo Onyankopɔn no, meyɛ kronkron. ");
INSERT INTO twiasante_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Ɛsɛ sɛ mode anidie ma mo maamenom ne mo agyanom na modi me homeda mmara no so, ɛfiri sɛ, meyɛ Awurade mo Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Monnsom ahoni, ɛfiri sɛ, meyɛ Awurade mo Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Ɛsɛ sɛ mobɔ asomdwoeɛ afɔdeɛ ma Awurade a momfa ɛkwan pa so mmɔ na asɔ Awurade ani. ");
INSERT INTO twiasante_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ɛda a mobɛbɔ saa afɔdeɛ no, monni no ɛda no ara, na aboro so koraa na ɛsɛ sɛ modi no adekyeeɛ. Monhye deɛ ɛbɛdi nnansa no. ");
INSERT INTO twiasante_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Na deɛ mobɛdi no nnansa so no yɛ akyiwadeɛ ma me, enti mɛpo. ");
INSERT INTO twiasante_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Sɛ modi no nnansa so a, modi ho fɔ na moagu Awurade kronkronyɛ nso ho fi, na wɔbɛtwa mo asuo afiri Awurade nkurɔfoɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Sɛ motwa mo nnɔbaeɛ a, monntwa nnɔbaeɛ a ɛwɔ mo mfuo nhanoa no. Sɛ moretwa a, aba a ɛbɛgu fam no nso, monntase. ");
INSERT INTO twiasante_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Saa ara na mo bobe so aba no nso, ɛnsɛ sɛ mote so nyinaa. Na deɛ ɛbɛte agu aseɛ no nso, monntase. Monnya mma ahiafoɔ ne akwantufoɔ a wɔbɛfa hɔ no na mene Awurade mo Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Mommmɔ korɔno. “ ‘Monntwa atorɔ. “ ‘Na monnsisi obiara. ");
INSERT INTO twiasante_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Monnka ntanhunu mfa ngu mo Onyankopɔn din ho fi, ɛfiri sɛ, mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Nwia wo yɔnko na monnsisi obi. “ ‘Na mo apaafoɔ nso, montua wɔn ka ntɛm na mommma adeɛ nkye so. ");
INSERT INTO twiasante_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Monnnome ɔsotifoɔ na monntwintwane onifirani akwan mu. Monsuro mo Onyankopɔn; Mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Ɛsɛ sɛ ɛberɛ biara atemmufoɔ bu atɛntenenee a wɔnhwɛ sɛ deɛ wɔrebu no atɛn no yɛ ohiani anaa osikani. Ɛsɛ sɛ daa wɔn atemmuo yɛ pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Monnni nsekuro. “ ‘Mfa bɔne bi ho asɛm nto wo yɔnko so, na mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Ntane wo nua. Ka obiara a ɔyɛ bɔne anim; mma ɔbɔnefoɔ mfa ne ho nni. Sɛ woyɛ saa a, wo nso wodi ho fɔ saa ara. ");
INSERT INTO twiasante_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Ntɔ were. Nnya obi ho menasepɔ; na mmom, dɔ wo yɔnko sɛ wo ho, na mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Monni me mmara so: “ ‘Mma wo nantwie mforo aboa foforɔ bi. “ ‘Nnua afifideɛ a ɛgu ahodoɔ mmienu wɔ wʼafuo mu. “ ‘Nhyɛ atadeɛ a ɛfa yɛ kuntu na ɛfa nso yɛ serekye. ");
INSERT INTO twiasante_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Sɛ obi bɔ afenaa bi a obi asi no asiwaa asɔn a, ɛsɛ sɛ wɔdi wɔn asɛm wɔ asɛnniiɛ nanso ɛnsɛ sɛ wɔkum wɔn, ɛfiri sɛ, afenaa no nne ne ho. ");
INSERT INTO twiasante_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ɔbarima no na ɔde ne fɔdie afɔrebɔdeɛ bɛbrɛ Awurade wɔ Ahyiaeɛ Ntomadan no kwan ano. Ɛsɛ sɛ afɔrebɔdeɛ no yɛ odwennini. ");
INSERT INTO twiasante_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ɔsɔfoɔ no de odwennini no bɛyɛ mpatadeɛ ama ɔbarima no bɔne a ɔyɛeɛ no na ama wɔde ne bɔne no akyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Sɛ mokɔ asase bi so kɔdua nnuaba ahodoɔ pii wɔ so a, nnɔbaetwa mmiɛnsa a ɛdi ɛkan no, monnni, ɛfiri sɛ, wɔbu no sɛ ɛho agu fi. ");
INSERT INTO twiasante_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Na ne mfeɛ ɛnan so no, momfa aba no nyinaa mma Awurade mfa nkamfo no. ");
INSERT INTO twiasante_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Na ne mfeɛ enum so no, aba no yɛ mo dea. Mene Awurade mo Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Monnwe aboa biara a wɔnsɔnee ne mu mogya ɛnam. “ ‘Na mommfa mo ho nto ntafowayie anaa bayie so. ");
INSERT INTO twiasante_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Ɛnsɛ sɛ motwitwa mo moma so nwi twitwa mo abɔgyesɛ so sɛdeɛ abosonsomfoɔ yɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Mommotabota mo ho mma ayiyɛ, na monnyɛ nsohyɛdeɛ wɔ mo honam ani nso. Mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Mma wo babaa nkɔbɔ adwaman mfa ngu ne ho fi na asase no annane abɔnefoɔ asase. ");
INSERT INTO twiasante_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Monni me homeda mmara no so na monni mʼAhyiaeɛ Ntomadan no ni, ɛfiri sɛ, mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Monnkɔ abisa wɔ adebisafoɔ ne abayifoɔ nkyɛn mmfa ngu mo ho fi, na mene Awurade mo Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Momfa obuo ne anidie mma mpanimfoɔ wɔ Onyamesuro mu. Mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Mommfa no sɛ yɛwɔ ahɔhoɔ wɔ yɛn ɔman yi mu enti yɛbɛsisi wɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Mommu wɔn sɛdeɛ mobu onipa biara. Monnodɔ wɔn sɛ mo ho na monkae sɛ, na mo nso moyɛ ahɔhoɔ wɔ Misraim asase so. Mene Awurade mo Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Ɛnsɛ sɛ mobu ntɛnkyea wɔ adesusuo, adekari anaa ade dodoɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Ɛsɛ sɛ mo nsania ne mo nkariboɔ yɛ pɛpɛɛpɛ. Adeɛ a mode susu nsunsudeɛ ne nneɛma a ɛnyɛ nsunsu no nso, ɛsɛ sɛ ɛyɛ pɛpɛɛpɛ, ɛfiri sɛ, mene Awurade mo Onyankopɔn a mede mo firi Misraim baeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Ɛsɛ sɛ modi me mmaransɛm ne mʼahyɛdeɛ no nyinaa so, na mene Awurade.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Awurade ka kyerɛɛ Mose sɛ ɔnka nkyerɛ Israelfoɔ no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Obiara a ɔfiri mo mu a ɔde ne ba bɛbɔ ɔhyeɛ afɔdeɛ ama Molek no, sɛ ɔyɛ Israelni anaa ɔhɔhoɔ no, wɔbɛsi no aboɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Na mʼankasa mɛtia saa onipa no na matwa no asuo afiri ne nkurɔfoɔ mu, ɛfiri sɛ, ɔde ne ba ama Molek ama mʼAhyiaeɛ Ntomadan adane baabi a metena a ɛnyɛ yie, na wagu me din kronkron no nso ho fi. ");
INSERT INTO twiasante_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Na sɛ nnipa a wɔte mpɔtam hɔ no nso boapa yɛ wɔn ho sɛ wɔnnim sɛ ɔbarima no de ne ba abɔ afɔdeɛ ama Molek na wɔankum no a, mʼankasa mɛtia ");
INSERT INTO twiasante_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ɔbarima no ne ne fiefoɔ na matwa ɔno ne nnipa a wɔde wɔn ho to anyame foforɔ so no nyinaa asuo. ");
INSERT INTO twiasante_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Mɛtia obiara a ɔkɔ adebisafoɔ ne abayifoɔ hɔ abisa na ɔkɔdi wɔn akyi adwaman kwan so, na matwa saa onipa no asuo afiri ne nkurɔfoɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Enti monte mo ho na monyɛ kronkron na mene Awurade mo Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ɛsɛ sɛ modi me mmara nyinaa so, ɛfiri sɛ, mene Awurade a meyɛ mo kronkron no. ");
INSERT INTO twiasante_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Obiara a ɔbɛdome nʼagya anaa ne maame no, ɛkwan biara so wɔbɛkum no, ɛfiri sɛ, wadome nʼankasa ne honam ne ne mogya. ");
INSERT INTO twiasante_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Sɛ ɔbarima bi kɔfa obi yere a, ɛsɛ sɛ wɔkum ɔbarima no ne ɔbaa no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Sɛ ɔbarima bi ne nʼagya yere da a, ɛsɛ sɛ wɔkum ɔbarima no ne ɔbaa no, ɛfiri sɛ, wɔn nyinaa ayɛ bɔne kɛseɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Na sɛ ɔbarima bi kɔfa nʼase a ɔyɛ ne babarima yere a, ɛsɛ sɛ wɔkum wɔn baanu no nyinaa; wɔn ankasa na wɔagu wɔn ho wɔn ho fi. ");
INSERT INTO twiasante_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Sɛ ɔbarima bi fa ne yɔnko barima a, wɔnkum wɔn baanu no nyinaa. Wɔn ara na wɔpɛ wɔn wuo. ");
INSERT INTO twiasante_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Sɛ ɔbarima bi fa ɔbaa bi na ɔsane kɔfa ɔbaa no maame ka ho a, ɛyɛ bɔne kɛseɛ. Wɔbɛhye saa nnipa baasa yi nyinaa anikann de apepa amumuyɛsɛm afiri mo mu. ");
INSERT INTO twiasante_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Sɛ ɔbarima bi fa aboa a, wɔbɛkum ɔbarima no na wɔakum aboa no nso. ");
INSERT INTO twiasante_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Sɛ ɔbaa nso ma aboa fa no a, monkum ɔbaa no ne aboa no nyinaa, ɛfiri sɛ, saa asotwe no fata wɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Sɛ ɔbarima ne ne nuabaa da a, sɛ ɛyɛ nʼagya babaa o, sɛ nso ɛyɛ ne maame babaa o, ɛyɛ animguasesɛm, enti wɔbɛgyina badwa mu atwa wɔn asuo afiri Israelfoɔ mu. Ɔbarima no ara bɛsoa nʼafɔdie. ");
INSERT INTO twiasante_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Sɛ ɔbarima bi kɔfa ɔbaa a wabu ne nsa a, wɔbɛtwa wɔn baanu no nyinaa asuo, ɛfiri sɛ, ɔbarima no ada ɔbaa no ho a ɛnte no adi. ");
INSERT INTO twiasante_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Sɛ obi ne nʼagya nuabaa da a, ɛyɛ akyiwadeɛ. Saa ara nso na ɔne ne maame nuabaa da a, ɛyɛ akyiwadeɛ ara ne no, ɛfiri sɛ, wɔn nyinaa yɛ mogya baako. Ɛsɛ sɛ wɔtwe wɔn aso. ");
INSERT INTO twiasante_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Sɛ ɔbarima bi fa nʼagya nuabarima yere a, wafa adeɛ a ɛyɛ nʼagya nuabarima no dea; wɔn asotweɛ ne sɛ, wɔbɛsoa wɔn bɔne awu a wɔnwo ba. ");
INSERT INTO twiasante_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Sɛ ɔbarima bi ware ne nua yere a, ɛyɛ afideɛ, ɛfiri sɛ, wafa ne nua adeɛ na wɔn nyinaa renwo ba. ");
INSERT INTO twiasante_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Ɛsɛ sɛ modi me mmara nyinaa so na mampam mo amfiri mo asase foforɔ yi so. ");
INSERT INTO twiasante_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Monnni ɔman no amanneɛ a maka no wɔ mo anim sɛ ɛnyɛ no akyi, ɛfiri sɛ, nneɛma a wɔyɛ a ɛnyɛ no nyinaa, mabɔ mo ho kɔkɔ dada. Ɛno enti na mekyiri saa aman no. ");
INSERT INTO twiasante_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Mahyɛ mo wɔn asase no ho bɔ sɛ mede bɛma mo. Ɛyɛ asase a nufosuo ne ɛwoɔ sen wɔ so. Mene Awurade mo Onyankopɔn a mama mo ada nso wɔ aman a aka no nyinaa mu. ");
INSERT INTO twiasante_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Ɛsɛ sɛ mo nso mohunu nnomaa ne mmoa a mama mo ho ɛkwan sɛ monwe wɔn nam ne wɔn a ɛnsɛ sɛ mowe wɔn nam no ntam nsonsonoeɛ. Ɛwom sɛ mmoa ne nnomaa a mabra sɛ monnnwe no, wɔabu so wɔ asase no so deɛ, nanso monnnwe mfa ngu mo ho fi nhyɛ me abufuo. ");
INSERT INTO twiasante_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Mobɛyɛ kronkron ama me ɛfiri sɛ, me Awurade, meyɛ kronkron na mayi mo afiri nnipa nyinaa mu asi nkyɛn sɛ moyɛ me dea. ");
INSERT INTO twiasante_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Ɔbarima anaa ɔbaa a ɔyɛ samanfrɛfoɔ anaasɛ ɔsumanni wɔ mo mu no, ɛsɛ sɛ mokum wɔn. Ɛsɛ sɛ mosi wɔn aboɔ. Ɛyɛ bɔne kɛseɛ.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Awurade ka kyerɛɛ Mose sɛ, “Ka kyerɛ asɔfoɔ no sɛ, ‘Wɔnnsɔ efunu mu mfa ngu wɔn ho fi. ");
INSERT INTO twiasante_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Sɛ wɔbɛsɔ efunu mu a, na ɛyɛ wɔn fieni, sɛ ebia, ɛna, agya, ɔbabarima, ɔbabaa, onuabarima ");
INSERT INTO twiasante_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","anaa onuabaa a ɔyɛ ɔbaabunu a ɔte ase no na ɔdan ɔsɔfoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ɛfiri sɛ, ɔsɔfoɔ no yɛ obi a ɔtua ne nkurɔfoɔ ano a ɛnsɛ sɛ ɔgu ne ho fi sɛdeɛ onipa foforɔ bi bɛtumi agu ne ho fi no. ");
INSERT INTO twiasante_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Asɔfoɔ no nni ho kwan sɛ wɔbɔ’, yi wɔn abɔgyesɛ anaasɛ wɔsesa wɔn ho. ");
INSERT INTO twiasante_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ɛsɛ sɛ wɔyɛ kronkron ma wɔn Onyankopɔn. Ɛnsɛ sɛ wɔgu ne din ho fi. Sɛ ɛba saa a, wɔremfata sɛ wɔde ogya bɛbɔ aduane afɔdeɛ ama Awurade wɔn Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Ɛnsɛ sɛ ɔsɔfoɔ ware odwamanfoɔ anaa ɔbaa bi a ɔfiri ɔman foforɔ so. Ɔnni ho kwan sɛ ɔware ɔbaa bi a wagyae awadeɛ, ɛfiri sɛ, ɔsɔfoɔ yɛ onipa kronkron ma Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Wɔayi ɔsɔfoɔ no asi hɔ sɛ ɔmmɔ mo Onyankopɔn afɔdeɛ; ɔyɛ kronkron na me Awurade a mete mo ho ma moyɛ kronkron no nso, meyɛ kronkron. ");
INSERT INTO twiasante_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Ɔsɔfoɔ babaa biara a ɔbɛbɔ adwaman no gu nʼagya ne ɔno ankasa ho fi, enti ɛsɛ sɛ wɔhye no. ");
INSERT INTO twiasante_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Ɛnsɛ sɛ ɔsɔfopanin a wɔde ngo sononko bi asra no ahyɛ no atadeɛ sononko no gyaa ne tirinwi ma ɛsensɛn wɔ ayiyɛ mu. Saa ara nso na ɔnni ho kwan sɛ ɔsunsuane nʼatadeɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ɔnni ho kwan sɛ ɔkɔ efunu ho—nʼagya anaa ne maame funu koraa ɔnni ho kwan sɛ ɔkɔ ho. ");
INSERT INTO twiasante_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Sɛ ɔgu so reyɛ nʼasɔfodwuma wɔ kronkronbea hɔ a, ɔnni ho kwan sɛ ɔfiri adi. Ɛnsɛ sɛ ɔfa mʼAhyiaeɛ Ntomadan sɛ efie bi kɛkɛ, ɛfiri sɛ, ne Onyankopɔn ngo a wɔde tee ne ho no da so wɔ ne so. Mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Ɛsɛ sɛ ɔware ɔbaabunu. ");
INSERT INTO twiasante_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ɛnsɛ se ɔware okunafoɔ anaa ɔbaa bi a wagyae awadeɛ anaa odwamanfoɔ. Ɛsɛ sɛ ɔbaa a ɔbɛware no no yɛ ɔbaabunu a ɔfiri ne ɔman mu, ");
INSERT INTO twiasante_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","sɛdeɛ ɛbɛyɛ a ɔngu ne mma ho fi wɔ ne nkurɔfoɔ mu. Mene Awurade a metee ne ho no.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Ka kyerɛ Aaron sɛ, ɛfiri awoɔ ntoatoasoɔ so kɔsi awoɔ ntoatoasoɔ so no, nʼasefoɔ biara a wɔadi dɛm no nni ho kwan sɛ wɔbɔ Onyankopɔn afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Obi a wadi dɛm mmɛm me: onifirani anaa apakye anaa deɛ ɔwɔ honam akwaa mu sintɔ; ");
INSERT INTO twiasante_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","obi a ɔyɛ abasin anaa nansin, ");
INSERT INTO twiasante_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","anaa deɛ ɔyɛ afu anaa akwatia anaa deɛ nʼani nyɛ anaa deɛ ekuro atutu no anaa deɛ ɔyɛ ɛtwo. ");
INSERT INTO twiasante_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ɔsɔfoɔ Aaron aseni biara a wadi dɛm mma mmɛbɔ ɔhyeɛ afɔdeɛ mma Awurade. Wadi dɛm, ɛno enti ɛnsɛ sɛ ɔtwe bɛn sɛ ɔde ne Onyankopɔn aduane rebrɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Nanso sɛ wɔbɔ afɔdeɛ no wie a, ɔsɔfoɔ no tumi ma no Onyankopɔn afɔdeɛ no aduane no bi di a ɛmfa ho sɛ ɛyɛ afɔdeɛ kronkron. ");
INSERT INTO twiasante_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Nanso ne dɛm no enti, ɔnni ho kwan sɛ ɔkɔ ntwamutam no akyi anaa ɔbɛn afɔrebukyia no. Yei bɛgu me kronkronbea hɔ ho fi na ɛyɛ Awurade na wate hɔ ho.” ");
INSERT INTO twiasante_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Enti Mose hyɛɛ mmara yi maa Aaron ne ne mmammarima ne Israelfoɔ nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Ka kyerɛ Aaron ne ne mmammarima sɛ, wɔmfa anidie mma afɔrebɔdeɛ kronkron a Israelfoɔ ate ho ama me no, sɛdeɛ ɛbɛyɛ a wɔnngu me din ho fi. Mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Ɛfiri ɛnnɛ rekorɔ, sɛ ɔsɔfoɔ biara a ne ho agu fi de ne nsa ka mmoa anaa akyɛdeɛ biara a nnipa no de aba sɛ wɔmfa mmɔ afɔdeɛ mma Awurade a, wɔbɛworɔ nʼatadeɛ. Mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Ɔsɔfoɔ biara a ɔwɔ honam ani nsane yadeɛ biara nni ho kwan sɛ ɔdi afɔrebɔdeɛ kronkron no bi gye sɛ, wɔasa no yadeɛ ama ne ho afiri ansa. Ɔsɔfoɔ biara a ɔde ne nsa bɛka funu anaa ɛnam ahosene enti ne ho bɛgu fi no, ");
INSERT INTO twiasante_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","anaa ɔde ne nsa bɛka aboa biara a ɔwea fam anaa akyiwadeɛ bi anaa obi a biribi enti, wɔagu ne ho fi no, ");
INSERT INTO twiasante_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","saa ɔsɔfoɔ no ho bɛgu fi kɔsi anwummerɛ. Ɔrenni afɔrebɔdeɛ a wɔate ho no bi kɔsi anwummerɛ a ɔbɛdware. ");
INSERT INTO twiasante_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Sɛ owia kɔtɔ a, ne ho bɛte na ɛno akyi ɔbɛtumi adi afɔrebɔdeɛ kronkron no bi, ɛfiri sɛ, ɛyɛ nʼaduane. ");
INSERT INTO twiasante_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ɛnsɛ sɛ ɔdi aboa funu anaa deɛ akekaboa bi atete ne mu, na amma ne ho angu fi. Mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Bɔ asɔfoɔ no kɔkɔ na wɔnni saa mmara yi so yie, anyɛ saa a, wɔbɛtwe wɔn aso na wɔawuwu sɛ wɔabu saa mmara yi so enti. Mene Awurade a mate wɔn ho. ");
INSERT INTO twiasante_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Obiara nni ho kwan sɛ ɔdi afɔrebɔdeɛ kronkron no bi gye sɛ ɔyɛ ɔsɔfoɔ. Ɔhɔhoɔ a wabɛsra ɔsɔfoɔ no nni ho kwan sɛ ɔdi bi. Na saa ara nso na ɔsomfoɔ a wɔtua no ka nni ho kwan sɛ ɔdi bi. ");
INSERT INTO twiasante_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Nanso sɛ ɛba sɛ ɔsɔfoɔ no de ɔno ara ne sika tɔ akoa a, saa akoa no tumi di bi. Na akoa no mma biara a ɔbɛwo wɔn wɔ fie hɔ no wɔ ho kwan sɛ wɔdi bi. ");
INSERT INTO twiasante_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Sɛ ɔsɔfoɔ babaa kɔware firi abusuakuo no akyi baabi a, ɔnni ho kwan sɛ ɔdi afɔrebɔdeɛ kronkron no bi. ");
INSERT INTO twiasante_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Na sɛ ɔyɛ okunafoɔ anaa obi a wɔagyaa no awadeɛ na ɔnni babarima a ɔbɛhwɛ no na ɛno enti ɔsane ba nʼagya nkyɛn a, ɔtumi di nʼagya aduane no bi bio. Yeinom akyi no, asɔfoɔ no abusuafoɔ nko ara na wɔwo ho kwan sɛ wɔdi afɔrebɔdeɛ kronkron no. ");
INSERT INTO twiasante_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Sɛ obi anhunu na ɔkɔdi saa afɔrebɔdeɛ kronkron no bi a, ɛsɛ sɛ ɔtua ho ka na ɔsane bɔ ho nkyɛmu ɔha mu aduonu de ka ho. ");
INSERT INTO twiasante_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Ɛfiri sɛ, afɔrebɔdeɛ kronkron a Israelfoɔ de aba no, ɛnsɛ sɛ nnipa a wɔmmaa wɔn ho kwan sɛ wɔnni bi no di bi, ɛfiri sɛ, Awurade na ɔde saa afɔrebɔdeɛ yi nyinaa abrɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Na obiara a ɔbɛbu saa mmara yi so no di ho fɔ, na asɛm da ne so, ɛfiri sɛ, wadi afɔrebɔdeɛ kronkron. Na mene Awurade a mete afɔrebɔdeɛ nyinaa ho.” ");
INSERT INTO twiasante_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Ka kyerɛ Aaron ne ne mmammarima ne Israelfoɔ nyinaa sɛ, ‘Sɛ Israelni anaa obi a ɔne mo te bɔ ɔhyeɛ afɔdeɛ ma Awurade a, sɛ ɛyɛ afɔrebɔdeɛ a ɛyɛ bɔhyɛ bi enti anaa ɔno ara ne pɛ mu na ɔrebɔ no, ");
INSERT INTO twiasante_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","sɛ afɔrebɔdeɛ no yɛ aboanini a ne ho nni dɛm biara a ɔyɛ nantwie ba anaa odwan anaa abirekyie no, Awurade bɛgye. ");
INSERT INTO twiasante_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ɛnsɛ sɛ wɔde biribiara a ɛdɛm wɔ ho bɔ afɔdeɛ, ɛfiri sɛ, wɔrennye. ");
INSERT INTO twiasante_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Obiara a ɔfiri nʼanantwie anaa ne nnwan mu sɛ ɔrebɔ asomdwoeɛ afɔdeɛ ama Awurade no, sɛ ɛyɛ bɔhyɛ bi ho afɔrebɔ anaa ɔno ara ne pɛ mu no, ɛnsɛ sɛ ɔde aboa a wadi dɛm na ɛbɔ saa afɔdeɛ no, ɛfiri sɛ, wɔrennye. ");
INSERT INTO twiasante_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Aboa a nʼani abɔ anaa wadi dɛm anaa wapira anaa ekuro anaa nweweeɛ wɔ ne ho, anaa wedeɛ ani yadeɛ ayɛ no no, ɛnsɛ sɛ wɔde no bɔ afɔdeɛ ma Awurade. Ɔmfata sɛ wɔde no ba afɔrebukyia so bɛbɔ afɔdeɛ ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Sɛ biribi a ɛboro so anaa ɛtɔ sin wɔ nantwie ba anaa odwan ba a wɔde no rebrɛ Awurade no ho a, ɛsɛ sɛ wɔde no bɔ ɔpɛ mu afɔdeɛ na mmom, ɛnyɛ bɔhyɛ afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ɛnsɛ sɛ wɔde aboa a wɔasa no bɔ Awurade afɔdeɛ ɛkwan biara so. ");
INSERT INTO twiasante_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Saa mmara yi da hɔ ma ahɔhoɔ a wɔfra mo mu a wɔpɛ sɛ wɔbɔ afɔdeɛ ne mo ankasa, ɛfiri sɛ, aboa biara a wadi dɛm no nyɛ mma saa afɔrebɔ no.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Sɛ wɔwo nantwie, odwan anaa abirekyie a, ɛsɛ sɛ aboa no tena ne maame nkyɛn nnanson. Na ɛfiri nnawɔtwe rekorɔ no, sɛ wɔde no bɔ ogya afɔdeɛ a, Awurade bɛgye. ");
INSERT INTO twiasante_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ɛnsɛ sɛ mokum aboa bi ne ne ba ɛda koro, sɛ ɔyɛ nantwie anaa odwan. ");
INSERT INTO twiasante_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Sɛ morebɔ asomdwoeɛ afɔdeɛ ama Awurade a, ɛsɛ sɛ mofa ɛkwan pa so, ");
INSERT INTO twiasante_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ɛne sɛ, mobɛwe aboa a wɔde no bɔɔ afɔdeɛ no nam ɛda no ara a wɔkumm no no. Mommma adeɛ nnkye ebi so. Mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Monni me mmarahyɛ nyinaa so na mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ɛnsɛ sɛ mogu me din kronkron ho fi. Monni me ni na me, Awurade, na metee mo ho de mo bataa me ho, ");
INSERT INTO twiasante_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","nam so gyee mo firii Misraim ma mobɛyɛɛ mʼankasa me nnipa! Mene Awurade.” ");
INSERT INTO twiasante_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Ma Israelfoɔ nte sɛ, ‘Ɛsɛ sɛ wɔdi Awurade afahyɛ ahodoɔ no mmerɛ a Israelfoɔ nyinaa bɛhyia asom me no. ");
INSERT INTO twiasante_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Mowɔ nna nsia a mode yɛ adwuma, na ɛda a ɛtɔ so nson no yɛ Homeda a mode home, ɛda a moyɛ nhyiamu kronkron. Ɛnsɛ sɛ moyɛ adwuma biara wɔ baabi a moteɛ. Ɛyɛ Homeda ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Yeinom ne Awurade apontoɔ, nhyiamu kronkron a ɛsɛ sɛ mobɔ ho dawuro wɔ ɛberɛ a wɔahyɛ: ");
INSERT INTO twiasante_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Wɔfiri Awurade Twam Afahyɛ no ase wɔ ɔbosome a ɛdi ɛkan no ɛda ɛtɔ so dunan no anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Awurade Apiti Afahyɛ nso, wɔfiri aseɛ saa ɔbosome no ɛda a ɛtɔ so dunum; na mobɛdi apiti nnanson. ");
INSERT INTO twiasante_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ɛda a ɛdi saa afahyɛ yi ɛkan no, mobɛyɛ nhyiamu kronkron, na monnyɛ adwuma biara. ");
INSERT INTO twiasante_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Nnanson no mu no, mommɔ ɔhyeɛ afɔdeɛ mma Awurade ɛda biara. Na ɛda a ɛtɔ so nson no, mobɛyɛ nhyiamu kronkron a obiara renyɛ adwuma.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Kasa kyerɛ Israelfoɔ no sɛ, ‘Sɛ moduru asase a mede bɛma mo no so na motwa mo nnɔbaeɛ a, momfa nnɔbaeɛ afiafi no mu baako nkɔma ɔsɔfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ɔbɛhim no wɔ Awurade anim de akyerɛ sɛ ɔde rema no na Awurade bɛgye sɛ mo akyɛdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ɛda no ara, mode odwennini a wadi afe a ɔnnii dɛm bɛbɔ Awurade ɔhyeɛ afɔdeɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ne nʼaduane afɔrebɔdeɛ a ɛyɛ esiam kilogram mmiɛnsa a wɔde ngo afra. Ɛbɛyɛ ɔhyeɛ afɔdeɛ a ɛyi hwa dɛɛdɛ ma Awurade. Wɔde nsã lita ɛnan ne fa afɔrebɔdeɛ bɛka ho. ");
INSERT INTO twiasante_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ɛnsɛ sɛ modi burodo biara, sɛ ɛyɛ aduane a wɔato anaa ɛyɛ foforɔ, kɔsi ɛda a mode saa afɔrebɔdeɛ yi bɛbrɛ mo Onyankopɔn. Yei bɛyɛ ahyɛdeɛ a ɛbɛtena hɔ daa ama awoɔ ntoatoasoɔ a ɛbɛba no wɔ baabiara a mobɛtena. ");
INSERT INTO twiasante_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Homeda no akyi ɛda a ɛdi ɛkan a wɔmaa atokoɔ afiafi mu baako so him no Awurade anim sɛ afɔrebɔdeɛ no, mobɛfiti aseɛ abubu nnawɔtwe nson. ");
INSERT INTO twiasante_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Monkan adaduonum a ɛkɔsi homeda a ɛtɔ so nson no akyi ɛda koro na momfa atokoɔ foforɔ mmɛbɔ afɔdeɛ mma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Yei bɛyɛ burodo mmienu a mode bɛfiri mo afie mu bɛba. Na wɔbɛhim no wɔ Awurade anim sɛ afɔrebɔ no. Momfa asikyiresiam lita ɛnan a wɔde mmɔreka afra nto saa burodo yi. Ɛyɛ mo aduane a ɛdi ɛkan afɔrebɔdeɛ a mode rema Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Mode burodo ne nsã bɛka nnwan mma nson a wɔadi afe a ɛdɛm biara nni wɔn ho ne nantwie ba baako ne nnwennini mmienu ho abɔ ɔhyeɛ afɔdeɛ ama Awurade. Yeinom nyinaa yɛ ogya afɔrebɔdeɛ a ɛsɔ Awurade ani yie. ");
INSERT INTO twiasante_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Mode ɔpapo baako bɛbɔ bɔne afɔdeɛ. Na mode nnwammaa mmienu a wɔn mu biara adi afe no abɔ asomdwoeɛ afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Asɔfoɔ no bɛhim saa afɔrebɔdeɛ yi ne burodo mmienu a ɛsi mo mfudeɛ a ɛdi akyire no ananmu no wɔ Awurade anim. Ɛyɛ kronkron ma Awurade na wɔde bɛma asɔfoɔ no sɛ wɔn aduane. ");
INSERT INTO twiasante_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ɛda no, ɛsɛ sɛ mobɔ nhyiamu kronkron ho dawuro, na monnyɛ adwuma biara. Yei bɛyɛ ahyɛdeɛ a ɛbɛtena hɔ daa ama awoɔ ntoatoasoɔ a ɛbɛba no wɔ baabiara a mobɛtena. ");
INSERT INTO twiasante_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Sɛ motwa mo mfuo mu nnɔbaeɛ a, monntwa ntu aseɛ nnɔbaeɛ no, na deɛ aporo agu fam no nso, monntase. Monnya mma ahiafoɔ ne ahɔhoɔ a wɔte mo mu a wɔnni asase bi a wɔdidi so no. Mene Awurade mo Onyankopɔn!’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Ka kyerɛ Israelfoɔ sɛ: ‘Ɔbosome a ɛtɔ so nson no ɛda a ɛdi ɛkan no, ɛsɛ sɛ mohome ɛda no, na moyɛ nhyiamu kronkron na mohyɛn totorobɛnto dendeenden de kae. ");
INSERT INTO twiasante_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Saa ɛda no, obiara nni ho ɛkwan sɛ ɔyɛ adwuma, na mmom, mommɔ ogya so afɔdeɛ mma Awurade.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Saa bosome a ɛtɔ so nson yi ɛda a ɛtɔ so edu ne Mpata Ɛda no. Monyɛ nhyiamu kronkron, monni abuada na mommɔ ogya so afɔdeɛ mma Awurade ");
INSERT INTO twiasante_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Monnyɛ adwuma biara saa ɛda no, ɛfiri sɛ, ɛyɛ Mpata Ɛda, ɛberɛ a wɔpata ma mo wɔ Awurade mo Onyankopɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Obiara a wanni ɛda no ahonu ne awerɛhoɔ so wɔ ne bɔne ho no, wɔbɛyi no afiri ne nkurɔfoɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Obiara a ɔbɛyɛ adwuma saa ɛda no, mɛsɛe no. ");
INSERT INTO twiasante_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Monnyɛ adwuma biara koraa. Yei bɛyɛ ahyɛdeɛ a ɛbɛtena hɔ daa ama awoɔ ntoatoasoɔ a ɛbɛba no, wɔ baabiara a mobɛtena. ");
INSERT INTO twiasante_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ɛyɛ Homeda a wɔde home ma mo. Ɛsɛ sɛ mobrɛ mo kra ase. Ɛfiri ɛda a ɛtɔ so nkron kɔsi ɛda edu no anwummerɛ no, ɛsɛ sɛ modi mo Homeda.” ");
INSERT INTO twiasante_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Ka kyerɛ Israelfoɔ sɛ, ‘Bosome a ɛtɔ so nson no ɛda a ɛtɔ so dunum no, wɔnhyɛ Awurade Asese Afahyɛ no ase, na mode nnanson na ɛbɛdi. ");
INSERT INTO twiasante_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ɛda a ɛdi ɛkan no yɛ nhyiamu kronkron ɛda; monnyɛ adwuma biara. ");
INSERT INTO twiasante_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ɛda biara wɔ nnanson no mu, ɛsɛ sɛ mobɔ ogya so afɔdeɛ ma Awurade. Ɛda a ɛtɔ so nwɔtwe no, mobɛyɛ nhyiamu kronkron na moabɔ ogya so afɔdeɛ ama Awurade. Ɛyɛ nhyiamu a ɛtwa toɔ. Monnyɛ adwuma biara. ");
INSERT INTO twiasante_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘Yeinom ne afahyɛ ahodoɔ a Awurade ahyehyɛ sɛ mommɔ ho dawuro sɛ ɛyɛ nhyiamu kronkron a wɔde afɔrebɔdeɛ a wɔhye no ogya so ma Awurade no ba: ɔhyeɛ afɔdeɛ ne aduane afɔdeɛ, afɔrebɔdeɛ ahodoɔ ne nsã afɔrebɔdeɛ a ɛho hia ɛda biara. ");
INSERT INTO twiasante_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Monni saa afahyɛ yi nka Awurade Homeda no ho. Na mode saa afɔrebɔdeɛ nso bɛka mo ankasa ayɛyɛdeɛ, ɛbɔ a moahyɛ ne deɛ mofiri mo pɛ mu de ma Awurade ho. ");
INSERT INTO twiasante_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Enti ɛfiri bosome a ɛtɔ so nson no ɛda a ɔtɔ so dunum no a moatwa asase no so nnɔbaeɛ no, momfa nnanson nni afahyɛ mma Awurade. Ɛda a ɛdi ɛkan ne deɛ ɛtɔ so nnwɔtwe yɛ ahomegyeɛ nna. ");
INSERT INTO twiasante_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ɛda a ɛdi ɛkan no, montwitwa nnuaba mman a aba wɔ so, ne mmerɛnkɛnsono ne mman a nhahan wɔ so na momfa mmɔ asese na momma mo ani nnye wɔ mo Awurade Onyankopɔn anim nnanson. ");
INSERT INTO twiasante_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ɛsɛ sɛ saa afe biara mu nnanson adidie mmara yi tena hɔ daa firi awoɔ ntoatoasoɔ so kɔsi awoɔ ntoatoasoɔ so. ");
INSERT INTO twiasante_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Saa nnanson no mu, mo a moyɛ Israelfoɔ mma no, ɛsɛ sɛ motena asese no ase. ");
INSERT INTO twiasante_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Nkyerɛaseɛ a ɛwɔ mu ara ne sɛ, ɛkae Israelfoɔ no firi awoɔ ntoatoasoɔ so kɔsi awoɔ ntoatoasoɔ so sɛ, me na megyee mo firii Misraim ma mobɛtenaa asese ase. Mene Awurade mo Onyankopɔn.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Yeinom ne Awurade afahyɛ ahodoɔ a wahyehyɛ a Mose ka kyerɛɛ Israelfoɔ no. Enti, Mose kyerɛɛ afahyɛ ahodoɔ a Israelfoɔ no bɛbɔ ama Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Ka kyerɛ Israelfoɔ na wɔmmrɛ wo ngo kronn na fa sɔ kanea a ɛnnum da, ");
INSERT INTO twiasante_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","adanseɛ ntwamutam no akyi wɔ Ahyiaeɛ Ntomadan no mu, Aaron bɛhwɛ nkanea a ɛwɔ Awurade anim no so, firi anwummerɛ kɔsi anɔpa biara. Ɛyɛ daa ahyɛdeɛ ma mo awoɔ ntoatoasoɔ nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ɛsɛ sɛ wɔhwɛ nkanea a ɛsisi sikakɔkɔɔ kaneadua so wɔ Awurade anim no so ɛberɛ biara. ");
INSERT INTO twiasante_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Momfa asikyiresiam muhumuhu nto burodo amuamua dumienu. Momfa esiam lita ɛnan ne fa nto burodo mua biara. ");
INSERT INTO twiasante_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Monhyehyɛ no akyerɛpɛn mmienu, a nsia biara wɔ kyerɛpɛn baako so wɔ sikakɔkɔɔ amapa ɛpono so wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Mode aduhwam pa bɛgu kyerɛpɛn biara ho de asi burodo no anan mu ayɛ afɔrebɔdeɛ a wɔhye wɔ ogya so ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ɛsɛ sɛ wɔde saa burodo yi sisi Awurade anim Homeda biara; ɛbɛyɛ apam a ɛnni awieeɛ ama Israelfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Burodo yi yɛ Aaron ne ne mmammarima dea, na ɛsɛ sɛ wɔdi wɔ kronkronbea hɔ, ɛfiri sɛ, ɛyɛ kronkron pa ara wɔ wɔn kyɛfa a ɛwɔ afɔrebɔdeɛ a wɔhye ma Awurade no mu.” ");
INSERT INTO twiasante_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ɛda bi aberanteɛ bi a ne maame yɛ Israelni na nʼagya nso yɛ Misraimni ne Israelfoɔ no baako nyaa ntɔkwa wɔ wɔn atenaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ntɔkwa no mu no, Israelni babarima no domee Onyankopɔn enti wɔde no baa Mose nkyɛn sɛ wɔmmu no atɛn. Na ne maame din de Selomit a ɔyɛ Dibri a ɔfiri Dan abusua mu. ");
INSERT INTO twiasante_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Wɔde no too afiase twɛn Awurade akwankyerɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Fa obusuyɛni no firi atenaeɛ ha kɔ na kɔka kyerɛ wɔn a wɔtee asɛm a ɔkaeɛ no nyinaa na wɔmfa wɔn nsa ngu nʼapampam; afei nnipa no nyinaa nsi no aboɔ nku no. ");
INSERT INTO twiasante_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ka kyerɛ Israelfoɔ no sɛ, ‘Obiara a ɔbɛdome Onyankopɔn no, ɛsɛ sɛ ɔnya ho asotwe: ");
INSERT INTO twiasante_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","obiara a ɔgu Awurade din ho fi no, ɛsɛ sɛ wɔkum no. Ɛsɛ sɛ ɛdɔm no nyinaa si no aboɔ. Ɔhɔhoɔ anaa Israelni biara a ɔbɛgu Awurade din ho fi no, ɛsɛ sɛ wɔkum no. ");
INSERT INTO twiasante_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Obiara a ɔkum ne yɔnko onipa no, ɛsɛ sɛ wɔkum no. ");
INSERT INTO twiasante_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Obiara a ɔkum aboa bi a ɛnyɛ ne dea no, ɛsɛ sɛ ɔhyɛ ananmu. ");
INSERT INTO twiasante_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Sɛ obi pira ne yɔnko a, ɔyɔnko no nso bɛpira no bi saa ara. ");
INSERT INTO twiasante_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Dompe mu bu nsi dompe mu bu ananmu; ani nsi ani ananmu; ɛse nsi ɛse ananmu. Sɛdeɛ obi pira ɔfoforɔ no, saa ara na wɔmpira ɔno nso. ");
INSERT INTO twiasante_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Obiara a ɔbɛkum aboa bi no, ɛsɛ sɛ ɔhyɛ anan mu; nanso sɛ obi kum onipa a, ɛsɛ sɛ wɔkum no bi. ");
INSERT INTO twiasante_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Mmara korɔ no ara wɔ hɔ ma ɔhɔhoɔ ne kuromani. Mene Awurade, mo Onyankopɔn.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Enti Mose kasa kyerɛɛ Israelfoɔ no, na wɔyii obusuyɛni no firii atenaeɛ hɔ kɔsii no aboɔ. Israelfoɔ no yɛɛ sɛdeɛ Awurade hyɛɛ Mose no. ");
INSERT INTO twiasante_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mose wɔ Sinai Bepɔ so no, Awurade ka kyerɛɛ no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Kasa kyerɛ Israelfoɔ no sɛ, ‘Sɛ moduru asase a mede rebɛma mo no so a, mfeɛ nson biara, momma asase no nya Awurade mu homeda. ");
INSERT INTO twiasante_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Momfa mfeɛ nsia nnua mo nnɔbaeɛ wɔ mo mfuo mu na monyiyi mo bobe turo mu na montwa mo nnɔbaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Na mfeɛ nson so no, asase no nna hɔ kwa wɔ Awurade anim. Monnyɛ so hwee. Monnnua so aba. Afe no nyinaa mu, monnyiyi mo bobe turo no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Na aba biara a moadua no, monnte mfa, na bobe no nso, mommmoaboa ano mfa. Ɛfiri sɛ, ɛyɛ afe a ɛsɛ sɛ asase no home. ");
INSERT INTO twiasante_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Nanso, aba biara a asase no bɛma saa afe no bɛyɛ aduane ama wo ne wʼakoa, wʼafenaa, wo paani ne wo hɔhoɔ, ");
INSERT INTO twiasante_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","wʼayɛmmoa ne wiram mmoa a ɛwɔ asase no so nyinaa. Monni biribiara a asase no bɛma biara. ");
INSERT INTO twiasante_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Bubu Homeda mfeɛ nson, mfeɛ nson ahodoɔ nson, na wobɛnya mfeɛ aduanan nkron. ");
INSERT INTO twiasante_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Afei, bosome a ɛtɔ so nson no ɛda edu no yɛ Mpata Ɛda. Monhyɛn totorobɛnto wɔ baabiara. Mpata Ɛda no, monhyɛn totorobɛnto no dendeenden nkyɛ wɔ ɔman no mu baabiara. ");
INSERT INTO twiasante_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Monte mfeɛ aduonum no ho na mompae ahofadie mma wɔn a wɔtete asase no so mmaa nyinaa. Ɛbɛyɛ mfirinhyia aduonum afahyɛ ama mo, na mo mu biara bɛsane akɔ asase a wɔde ama mo agyanom no so, na moakɔka mo abusuafoɔ ho. ");
INSERT INTO twiasante_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Aane, mfeɛ aduonum no bɛyɛ mfirinhyia aduonum afahyɛ ama mo; monnnua biribiara na monntwa nnɔbaeɛ biara, na bobe a moadua nso, monnte so aba. ");
INSERT INTO twiasante_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Ɛfiri sɛ, ɛyɛ mfirinhyia aduonum afahyɛ, na ɛsɛ sɛ ɛyɛ sononko na ɛho teɛ. Monni deɛ monya firi asase no mu nko ara. ");
INSERT INTO twiasante_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Saa mfirinhyia aduonum afahyɛ yi, obiara bɛkɔ asase a wɔde maa nʼagyanom no so. ");
INSERT INTO twiasante_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Sɛ wo ne wo yɔnko yɛ nhyehyɛeɛ a wonam so retɔ anaa woretɔn agyapadeɛ bi a, ɛnsɛ sɛ obi sisi ne yɔnko. ");
INSERT INTO twiasante_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Sɛ woretɔ asase afiri wo yɔnko nkyɛn a, mobɛkan mfeɛ dodoɔ no so fa afiri Mfirinhyia Aduonum Afahyɛ a ɛtwaam no. Ɔdetɔnfoɔ no bɛgye wo boɔ a ɛgyina mfeɛ dodoɔ a aka ansa na mfirinhyia aduonum afahyɛ a ɛreba no. ");
INSERT INTO twiasante_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Mfeɛ no dodoɔ na ɛma ɛboɔ no kɔ soro. Saa ara nso na mfeɛ kakra bi ma ɛboɔ no kɔ fam. Yeinom nyinaa mu, onipa a ɔretɔn asase no retɔn otwa dodoɔ a wɔbɛtwa afiri asase no so. ");
INSERT INTO twiasante_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Monsuro mo Onyankopɔn na moammɔ ɛboɔ a ɛboro so! Na mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Sɛ mopɛ sɛ motena asase no so asomdwoeɛ mu deɛ a, monni me mmara so. ");
INSERT INTO twiasante_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Sɛ moyɛ ɔsetie a, aduane bɛbu so wɔ asase no so na moadi amee wɔ asomdwoeɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Nanso, mobɛbisa sɛ, “Na sɛ wɔse yɛnnnua anaa yɛnntwa saa afe no so a, ɛdeɛn na mfeɛ nson no so yɛbɛdie?” ");
INSERT INTO twiasante_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mmuaeɛ ara ne sɛ, mfeɛ nsia no so, mɛhyira mo ama nnɔbaeɛ aba abu so kɔsi sɛ mobɛtwa mfeɛ nwɔtwe mu nnɔbaeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Sɛ modua nnɔbaeɛ wɔ mfeɛ nwɔtwe no mu a, mobɛkɔ so adi afe a ɛtwaam no mu nnuane. Nokorɛm, nnuane dada no na mobɛdi kɔsi sɛ otwaberɛ bɛduru so mfeɛ nkron no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Na monkae sɛ asase no yɛ me dea enti monni ho ɛkwan sɛ motɔn no afebɔɔ. Moyɛ ahɔhoɔ na meyɛ asasewura ma mo. ");
INSERT INTO twiasante_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Asasetɔn mu no, ɛsɛ sɛ moyɛ nhyehyɛeɛ sɛ asasetɔnfoɔ no tumi sane bɛgye asase no ɛberɛ biara. ");
INSERT INTO twiasante_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Sɛ ohia hia obi ma ɔtɔn nʼasase fa bi a, nʼabusuafoɔ tumi bɛgye. ");
INSERT INTO twiasante_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Sɛ ɔnni obi a ɔbɛgye ama no na sɛ nʼankasa nya sika a, ");
INSERT INTO twiasante_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","wɔbɛsese ɛso nnɔbaeɛ a wɔatwa ansa na Ahosɛpɛ Afe no reba na wɔagyina so atua ɛka no, na deɛ ɔtɔeɛ no nso adane asase no ama no. ");
INSERT INTO twiasante_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Na sɛ deɛ asase no yɛ ne dea no ankasa antumi annye a, ɛnneɛ, ɛbɛyɛ deɛ ɔtɔeɛ no dea ara kɔsi Mfirinhyia Aduonum Afahyɛ no, na deɛ ɔtɔeɛ no de onii no adeɛ asane ama no. ");
INSERT INTO twiasante_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Sɛ obi tɔn efie wɔ kurom a, ɔwɔ afe a ɔtumi sane gye nʼadeɛ a biribiara nsi no ho ɛkwan. ");
INSERT INTO twiasante_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Na sɛ afe no mu wantumi annye a, ɛbɛyɛ deɛ ɔtɔeɛ no dea korakora. Ahosɛpɛ Afe no mu, ɔrensane mfa mma onipa a kane no na ɛyɛ ne dea no bio. ");
INSERT INTO twiasante_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Nanso akuraase dan a wɔntoo ɔfasuo ntwaa ho nhyiaeɛ te sɛ agyapadeɛ a ɛwɔ wiram deɛ, wɔtumi sane kɔgye no ɛberɛ biara, na Mfeɛ Aduonum Afahyɛ mu no, ɛsɛ sɛ wɔsane de ma ne wura ankasa. ");
INSERT INTO twiasante_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Asɛm baako bi na ɛnka ho. Lewifoɔ afie a ɛwɔ nkuro a wɔde afasuo atwa ho mu no, wɔtumi sane gye ɛberɛ biara, ");
INSERT INTO twiasante_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","na wɔde ama wɔn wuranom Ahosɛpɛ Afe no mu. Na Lewifoɔ no deɛ, wɔremma wɔn mfuo nsase te sɛ mmusuakuo a aka no, na mmom, wɔbɛma wɔn afie wɔ wɔn nkuro ne wɔn mfuo a atwa wɔn ho ahyia no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Mma wɔnntɔn nsase a atwa Lewifoɔ nkuro ho ahyia, ɛfiri sɛ, yeinom yɛ wɔn agyapadeɛ afebɔɔ a ɛnsɛ sɛ wɔne obiara kyɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Sɛ ohia hia wo nua a, ɛsɛ sɛ woboa no; ma no mmra ma ɔmmɛtena hɔ bi. ");
INSERT INTO twiasante_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Suro wo Onyankopɔn na ma wo nua ntena wo nkyɛn; na sɛ wobɔ no bosea a, nnye no ho ba. ");
INSERT INTO twiasante_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Kae sɛ, worennye ho nsiho biara, na aduane a wode ma no nso, nnye ho nsiho biara. Mpɛ mfasoɔ! ");
INSERT INTO twiasante_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ɛfiri sɛ, me Awurade a meyɛ mo Onyankopɔn yii mo firii Misraim de Kanaan asase maa mo sɛdeɛ mɛyɛ mo Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Sɛ ohia hia wo yɔnko Israelni na ɔtɔn ne ho ma wo a, nhyɛ ne so sɛ ɔdɔnkɔ ");
INSERT INTO twiasante_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","na mmom, yɛ no sɛ obi a wotua no ne som a ɔsom ho ka, anaa fa no sɛ wo hɔhoɔ na ɔnsom wo nkɔsi Mfirinhyia Aduonum Afahyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Ɛduru saa mmerɛ no a, ɔne ne mma nyinaa tumi tu de wɔn agyapadeɛ nyinaa kɔ wɔn abusuafoɔ nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Me na mede mo firi Misraim asase so baeɛ sɛ mommɛsom me sɛdeɛ obi rentumi ntɔn mo sɛ nnipa hunu bi ");
INSERT INTO twiasante_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","na obi nso ntumi nha mo; monsuro mo Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Nanso mobɛtumi atɔ asomfoɔ afiri aman foforɔ a atwa mo ho ahyia no so. ");
INSERT INTO twiasante_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Saa ara nso na motumi tɔ ahɔhoɔ a mo ne wɔn te no mma a ɛmfa ho sɛ wɔte mo mu. ");
INSERT INTO twiasante_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Wɔbɛyɛ nkoa afebɔɔ ama mo ne mo nkyirimma, nanso mo nuanom Israelfoɔ no deɛ, ɛnsɛ sɛ moyɛ wɔn saa. ");
INSERT INTO twiasante_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Sɛ ɔhɔhoɔ a ɔte mo mu no bɛyɛ osikani, na sɛ Israelni di hia, na ɔtɔn ne ho ma ɔhɔhoɔ no anaa ɔhɔhoɔ no abusuafoɔ a, ");
INSERT INTO twiasante_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ne nuanom bi tumi bɛgye no. ");
INSERT INTO twiasante_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Saa ara nso na ne wɔfa, ne wɔfaase anaa ne ho onipa bi a ɔbɛn no tumi gye no ara ne no. Sɛ ɔno ara nso bɛnya sika a, ɔtumi de bɛgye ne ho. ");
INSERT INTO twiasante_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Nʼahogyeɛ no gyina mfeɛ a aka na Mfirinhyia Aduonum Afahyɛ no aduro ne sika dodoɔ a sɛ anka wɔde kɔfaa ɔsomfoɔ a, anka ɔbɛgye saa mfeɛ a aka no mu. ");
INSERT INTO twiasante_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Sɛ aka mfeɛ pii ansa na Ahosɛpɛ Afe no aso a, ɔbɛtua sika a ɔgyeeɛ wɔ ɛberɛ a ɔtɔn ne ho no nyinaa; ");
INSERT INTO twiasante_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","na sɛ mfeɛ no pii atwam ama aka kakra na Mfirinhyia Aduonum Afahyɛ no aduru a, ɛnneɛ, ɔbɛtua sika a ɔgyeeɛ ɛberɛ a ɔtɔn ne ho no mu kakraa bi. ");
INSERT INTO twiasante_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Sɛ ɔtɔn ne ho ma ɔhɔhoɔ a, ɔhɔhoɔ no bɛfa no sɛ ne ɔsomfoɔ a ɔtua no ka. Ɛnsɛ sɛ ɔfa no sɛ ne ɔsomfoɔ buruburo anaa nʼagyapadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Sɛ Mfirinhyia Aduonum Afahyɛ no duru na wɔnnyee no a, wɔbɛgyaa ɔne ne mma nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Israelfoɔ yɛ mʼasomfoɔ. Mede wɔn firi Misraim na ɛbaeɛ. Mene Awurade mo Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Monnyɛ abosom. Monnsisi ahoni anaa aboɔ mma mo ho. Mommfa aboɔ a wɔatwa nsisi mo asase so sɛ morebɛkoto wɔn. Mene Awurade mo Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Ɛsɛ sɛ modi me Homeda, na mode anidie ma me kronkronbea. Mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Sɛ modi me mmara no nyinaa so a, ");
INSERT INTO twiasante_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","daa mɛtɔ osuo ama mo ama mo nnɔbaeɛ ayɛ yie abu so, na mo nnua nso bɛso aba a ɛbɛkyɛre wɔ nnua no so. ");
INSERT INTO twiasante_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Na sɛ ɛduru odua berɛ so bio koraa a, mo borɔdɔma bɛkɔ so abere. Mobɛdidi amee na moatena asase no so asomdwoeɛ mu, ");
INSERT INTO twiasante_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Ɛfiri sɛ, mɛma mo asomdwoeɛ, na mɛma mo ada a monnsuro hwee. Mɛpam mmoa bɔne afiri mo ho. ");
INSERT INTO twiasante_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mobɛpam mo atamfoɔ; na wɔbɛwuwu wɔ mo asekan ano. ");
INSERT INTO twiasante_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Mo mu baanum bɛka ɔha agu, na mo mu ɔha aka ɔpedu agu! Mo atamfoɔ bɛtotɔ wɔ akofena ano wɔ mo anim. ");
INSERT INTO twiasante_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘Mɛhwɛ mo so na mama mo adɔre, na madi apam a me ne mo pameeɛ no so. ");
INSERT INTO twiasante_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mo nnɔbaeɛ bɛbu so a sɛ otwa berɛ foforɔ duru so a, morenhunu deɛ mode bɛyɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Na mɛtena mo mu, na meremmu mo animtiaa. ");
INSERT INTO twiasante_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Me ne mo bɛnante, na mayɛ mo Onyankopɔn, na moayɛ me nkurɔfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mene Awurade mo Onyankopɔn a ɔde mo firi Misraim asase so baeɛ sɛ ɔmpɛ sɛ moyɛ nkoa bio no. Mabubu mo nkɔnsɔnkɔnsɔn mu, na mɛma mo anante animuonyam so. ");
INSERT INTO twiasante_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Na sɛ moantie me, anni mʼasɛm so, ");
INSERT INTO twiasante_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","na mopo me mmara a, ");
INSERT INTO twiasante_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","deɛ mɛyɛ mo nie: Mɛma mo akoma atutu na mama nsamanwa ayɛ mo, na atiridiinini abɔ mo. Mo ani bɛtutu, na mo nkwa so ahwan. Mobɛdua nnɔbaeɛ agu kwa, ɛfiri sɛ, mo atamfoɔ na wɔbɛdie. ");
INSERT INTO twiasante_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Mɛyi mʼani afiri mo so, na moadwane afiri mo atamfoɔ anim. Wɔn a wɔtan mo bɛdi mo so. Mobɛdwane ɛberɛ a obiara mpam mo. ");
INSERT INTO twiasante_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘Na sɛ mokɔ so yɛ asoɔden a, mɛtwe mo aso mmɔho nson a emu yɛ den wɔ mo bɔne no ho. ");
INSERT INTO twiasante_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Mɛsɛe mo ahantan tumi no na mayɛ mo soro sɛ dadeɛ ne mo fam sɛ kɔbere. ");
INSERT INTO twiasante_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Mobɛsɛe mo ahoɔden kwa, na mo asase nnya nnɔbaeɛ biara, na ɛso nnua nso renso aba. ");
INSERT INTO twiasante_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘Na sɛ tie ara na monntie me a, mo bɔne enti, mede ɔyaredɔm mmɔho nson bɛgu mo so. ");
INSERT INTO twiasante_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Mɛma nkekaboa abɛkunkum mo mma na wɔakunkum mo anantwie, na mate mo dodoɔ so, na mo akwan bɛda mpan a obi mfa so bio. ");
INSERT INTO twiasante_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘Na sɛ yei antumi ansesa mo, na mokɔ so tia mʼapɛdeɛ a, ");
INSERT INTO twiasante_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","me nso, mɛtia mo apɛdeɛ, na me ara mʼankasa mɛtwe mo aso mprɛnson wɔ mo bɔne ho. ");
INSERT INTO twiasante_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Menam ɔko so bɛbu mʼapam so ako atia mo de atua mo so ka. Mobɛdwane akɔ mo nkuro mu, na mede nyarewa bɛtoa mo wɔ hɔ. Na mo atamfoɔ bɛdi mo so. ");
INSERT INTO twiasante_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Mɛsɛe mo nnuane a mobɛnya nyinaa kɔsi sɛ mpo, fononoo baako burodo a ɛbɛto no na mmusuakuo edu bɛdi. Aduane kakra a mobɛdi no akyi, ɛkɔm bɛde mo. ");
INSERT INTO twiasante_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘Na sɛ mokɔ so yɛ asoɔden a, ");
INSERT INTO twiasante_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","mo bɔne enti, me bo bɛfu mo na matwe mo aso a emu yɛ den mmɔho nson. ");
INSERT INTO twiasante_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mobɛwe mo mmammarima ne mo mmammaa ɛnam. ");
INSERT INTO twiasante_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Mɛsɛe mo sorɔnsorɔmmea. Mɛtwitwa mo aduhwam afɔrebukyia agu, na mahyehyɛ mo afunu wɔ mo ahoni a ɛnni nkwa no so; na mɛpo mo. ");
INSERT INTO twiasante_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Mɛma mo nkuro ayɛ amamfo na masɛe baabi a mosom nyinaa, na mapo mo ohwam afɔrebɔ no. ");
INSERT INTO twiasante_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ampa ara, mɛma mo asase so ada mpan na mo atamfoɔ atena so, na deɛ mɛyɛ mo no ayɛ mo nwanwa. ");
INSERT INTO twiasante_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Mɛbɔ mo apete aman no a morekɔ so nyinaa, na mede ɔko asɛe mo. Mo asase bɛda mpan na wɔasɛe mo nkuro. ");
INSERT INTO twiasante_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Akyire no, asase no bɛda hɔ ahome de asi mfeɛ dodoɔ a moamma anhome no anan; ɛbɛda hɔ wɔ mmerɛ a mowɔ atamfoɔ nsam wɔ wɔn nsase so no nyinaa. Na asase no ahome, na anya ne home nna nso. ");
INSERT INTO twiasante_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ɛberɛ a asase no da mpan nyinaa, ɛbɛnya home a moamma annya wɔ Homeda dodoɔ a motenaa soɔ no. ");
INSERT INTO twiasante_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Wɔn a wɔgyaa wɔn hɔ a wɔnwuiɛ no nso, mɛma wɔatwe wɔn akɔ akyirikyiri nsase so sɛ ɔko mu nneduafoɔ ne nkoa. Ɛhɔ na wɔbɛtena daa wɔ ehu mu. Wɔte sɛ mframa rebɔ ahahan koraa a, wɔbɛdwane te sɛ deɛ obi a ɔkura akofena repam wɔn; wɔbɛhwehwe ase wɔ ɛberɛ a obi mpam wɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Obiara rempamo wɔn nanso ehu enti, wɔbɛsuntisunti wɔn ho wɔn ho te sɛ deɛ wɔredwane afiri akono a wɔnni tumi biara a wɔde bɛgyina wɔn atamfoɔ anim no. ");
INSERT INTO twiasante_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mobɛyera wɔ aman mu, na mo atamfoɔ asɛe mo. ");
INSERT INTO twiasante_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Wɔn a wɔbɛka no, wɔn bɔne enti, wɔn ho bɛyera wɔn wɔ atamfoɔ nsase so, bɔne a wɔn agyanom yɛeɛ no enti. ");
INSERT INTO twiasante_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Nanso akyire no, me nkurɔfoɔ bɛka wɔn bɔne ne wɔn agyanom bɔne. Wɔbɛka sɛdeɛ wɔdii me hwammɔ na wɔtiaa me no. ");
INSERT INTO twiasante_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Sɛ me nso metia wɔn te sɛ deɛ ɛsɛ na mede wɔn kɔ wɔn atamfoɔ asase so a, afei, wɔn akomaden no ano bɛbrɛ ase, na wɔbɛtua wɔn bɔne so ka. ");
INSERT INTO twiasante_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Afei, mɛkae apam a me ne Yakob, Isak ne Abraham ayɛ, na mɛkae asase no. ");
INSERT INTO twiasante_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Asase no da hɔ dinn no, ɛbɛdi ne homeda. Nanso akyire no, wɔbɛnya wɔn asotwe sɛ wɔanni me nhyehyɛeɛ so na wɔtiaa me mmara. ");
INSERT INTO twiasante_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Na deɛ wɔyɛɛ no nyinaa akyi no, merensɛe wɔne mʼapam no korakora, ɛfiri sɛ, mene Awurade wɔn Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Mɛkae tete apam a me ne wɔn agyanom a meyii wɔn firii Misraim, ɛberɛ a amanaman nyinaa rehwɛ no, yɛeɛ no. Me Awurade ne wɔn Onyankopɔn.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Yeinom ne mmara ne ahyɛdeɛ a Awurade nam Mose so de maa Israelfoɔ no wɔ Sinai Bepɔ so no. ");
INSERT INTO twiasante_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Ka kyerɛ Israelfoɔ no sɛ, ‘Sɛ onipa bi hyɛ bɔ sɛ ɔde obi bɛma Awurade a, na sɛ ɔpɛ sɛ ɔtua sika mmom a, ");
INSERT INTO twiasante_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ɔbɛtua dwetɛ gram ahanum ne aduɔson (570) ama ɔbarima a wadi mfeɛ aduonu kɔsi mfeɛ aduosia, ");
INSERT INTO twiasante_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","sɛ ɔyɛ ɔbaa a wadi mfeɛ aduonu kɔsi aduosia a, wɔbɛtua dwetɛ gram ahasa ne aduanan (340), ");
INSERT INTO twiasante_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","abarimaa a wadi mfeɛ enum kɔsi aduonu no nso wɔbɛtua dwetɛ gram ahanu ne aduasa (230). Sɛ ɔyɛ ɔbaa a, wɔbɛtua dwetɛ gram ɔha ne dunum (115). ");
INSERT INTO twiasante_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Abarimaa a wadi bosome kɔsi mfeɛ enum no wɔbɛtua dwetɛ gram 60; na abaayewa nso wɔatua dwetɛ gram 35. ");
INSERT INTO twiasante_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ɔbarima a wadi boro mfeɛ aduosia no wɔbɛtua dwetɛ gram ɔha aduɔson (170); na ɔbaa nso wɔatua dwetɛ gram ɔha ne dunum (115). ");
INSERT INTO twiasante_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Na sɛ obi yɛ ohiani a ɔrentumi ntua saa sika yi a, ɔde saa onipa no bɛba ɔsɔfoɔ anim, na ɔsɔfoɔ no akyerɛ no sika a ɔbɛtumi atua. ");
INSERT INTO twiasante_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Sɛ ɔde aboa hyɛ bɔ sɛ afɔrebɔdeɛ a ɛfata ma Awurade a, saa aboa no a ɔde ama Awurade no bɛyɛ kronkron. ");
INSERT INTO twiasante_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ɛnsɛ sɛ ɔsesa saa aboa no. Ɛnsɛ sɛ ɔde deɛ ɛyɛ sesa deɛ ɛnyɛ anaa sɛ ɔde deɛ ɛnyɛ sesa deɛ ɛyɛ. Sɛ ɛba sɛ wɔyɛ saa nsesayɛ yi a, wɔbɛfa no sɛ mmoa mmienu no nyinaa ho te. ");
INSERT INTO twiasante_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Sɛ aboa a ɔde rema Awurade no ho nte na ɛmfata sɛ wɔde yɛ afɔrebɔdeɛ ma Awurade a, ɛsɛ sɛ ne wura no de brɛ ɔsɔfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ɔno na ɔbɛhwɛ sɛ aboa no di mu anaa sɛ ɔnte saa, na wakyerɛ sika dodoɔ a ɛsɛ sɛ ɔtua de si aboa no anan. ");
INSERT INTO twiasante_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Sɛ aboa no yɛ deɛ ɛsɛ sɛ wɔde no bɔ afɔdeɛ nanso onipa a ɔde no reba no pɛ sɛ ɔsane gye nʼadeɛ a, ɔbɛtua sika ɔha mu nkyɛmu aduonu aka ɛboɔ a ɔsɔfoɔ no bɛtwa ama no sɛ ɔntua no ho. ");
INSERT INTO twiasante_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Sɛ obi de ne fie ma Awurade na sɛ ɔpɛ sɛ ɔsane gye a, ɔsɔfoɔ no bɛsese ne boɔ a ɔnte so, ");
INSERT INTO twiasante_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","na saa onipa no atua, asane atua ɛbo korɔ no ara ɔha mu nkyɛmu aduonu aka ho ansa na efie no abɛyɛ ne dea bio. ");
INSERT INTO twiasante_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Sɛ ɔbarima bi pɛ sɛ ɔde nʼabusua asase fa bi bɔ afɔdeɛ ma Awurade a, wɔbɛgyina aba kɛntɛnma dodoɔ a ɛbɛhia sɛ wɔbɛdua wɔ so no so atwa asase no boɔ; aba kɛntɛnma biara boɔ yɛ dwetɛ gram ahanum ne aduɔson (570). ");
INSERT INTO twiasante_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Mfirinhyia Aduonum Afahyɛ mu no, sɛ obi de nʼafuo kyɛ a, ne boɔ no rensesa. ");
INSERT INTO twiasante_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Na sɛ ɔde asase no ma wɔ Mfirinhyia Aduonum Afahyɛ no akyi a, ɔsɔfoɔ no bɛgyina mfeɛ a aka ansa na Mfirinhyia Aduonum Afahyɛ a ɛdi so no so asese ne boɔ, na wɔbɛtumi ate so. ");
INSERT INTO twiasante_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Na sɛ ɔbarima no pɛ sɛ ɔgye nʼasase a, ɔsɔfoɔ no boɔ a ɔbɛbɔ no, ɔbɛtua ɔha mu nkyɛmu aduonu aka ho ansa na asase no abɛyɛ ne dea bio. ");
INSERT INTO twiasante_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Na sɛ nso ɔyɛ nʼadwene sɛ ɔmpɛ sɛ ɔgye asase no bio, anaasɛ sɛ watɔn asase no ama obi foforɔ a, ɛnneɛ wɔrentumi nnye bio. ");
INSERT INTO twiasante_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Sɛ wɔdane asase no ma wɔ Mfirinhyia Aduonum Afahyɛ no mu a, ɛbɛyɛ asase kronkron. Wɔde ato hɔ ama Awurade. Ɛbɛyɛ asɔfoɔ no agyapadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Sɛ obi bi de asase a watɔ ma Awurade, na sɛ asase no nyɛ nʼabusua asase a, ");
INSERT INTO twiasante_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ɔsɔfoɔ no bɛgyina mfeɛ a aka ama wɔadi Mfirinhyia Aduonum Afahyɛ no so asese ne boɔ. Ɛsɛ sɛ onipa ko no tua ɛboɔ no ɛda no ara, na ɛyɛ afɔrebɔdeɛ kronkron ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Mfirinhyia Aduonum Afahyɛ no duru so a, asase no bɛsane akɔ deɛ ɔtɔneɛ no nkyɛn anaasɛ deɛ na ɔyɛ asase no wura no. ");
INSERT INTO twiasante_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Wɔbɛsese ɛho ka no nyinaa wɔ nnwetɛbena a wɔgye wɔ hyiadan mu, a ɛyɛ gram dubaako. ");
INSERT INTO twiasante_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Ɛnsɛ sɛ obiara de aboa bi abakan ma Awurade, ɛfiri sɛ abakan biara, sɛ ɔyɛ nantwie anaa odwan no, yɛ Awurade dea dada. ");
INSERT INTO twiasante_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Sɛ ɔyɛ mmoa a wɔn ho nteɛ no bi a, onipa no bɛtumi atua ne boɔ no, na ɔde ɛboɔ no mu nkyɛmu enum mu baako aka ho. Sɛ onipa no antɔ bio deɛ a, wɔbɛtɔn aboa no sɛdeɛ ne boɔ teɛ. ");
INSERT INTO twiasante_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Adeɛ biara a wɔde ama Awurade no, sɛ ɛyɛ nnipa, mmoa anaa abusuasase no, ɛnsɛ sɛ wɔtɔn anaa wɔsane gye, ɛfiri sɛ, biribiara a ɛte saa no yɛ kronkron ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Onipa biara a Awurade ayi no asi nkyɛn ama ɔsɛeɛ no, wɔmmfa biribi ntua ne tiri ka. Ɛsɛ sɛ wɔkum no. ");
INSERT INTO twiasante_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Asase no so nnɔbaeɛ nkyɛmu edu mu baako, sɛ ɛyɛ aburoo anaa aduaba no yɛ Awurade dea. Ɛyɛ kronkron. ");
INSERT INTO twiasante_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Sɛ obi pɛ sɛ ɔsane tɔ saa aduaba anaa aburoo no a, ɛsɛ sɛ ɔde ne boɔ nkyɛmu enum mu baako ka ho. ");
INSERT INTO twiasante_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Anantwie ne nnwan no ntotosoɔ dudu nyinaa, aboa biara a ɔtɔ so edu a ɔfa odwanhwɛfoɔ nsam no yɛ kronkron ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Aboa a ɔtɔ so edu a wɔde bɛma Awurade no, wɔnhwɛ sɛ ɔyɛ anaa ɔnyɛ, na wɔmmfa biribiara nsi nʼananmu, ɛfiri sɛ, sɛ wɔde biribiara si ananmu a, ne nyinaa bɛyɛ kronkron, a obiara rentumi nnye bio.’ ” ");
INSERT INTO twiasante_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Yeinom ne mmara a Awurade de maa Mose wɔ Sinai Bepɔ so sɛ ɔnka nkyerɛ Israelfoɔ no.");
INSERT INTO twiasante_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Awurade kasa kyerɛɛ Mose wɔ Ahyiaeɛ Ntomadan a ɛwɔ Sinai anweatam so. Yei siiɛ wɔ mfeɛ mmienu a Israelfoɔ firii Misraim no akyi, ɔbosome a ɛtɔ so mmienu no no ɛda a ɛdi ɛkan. Ɔkaa sɛ: ");
INSERT INTO twiasante_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Gyina Israelfoɔ no mmusuakuo ne wɔn mmusua so kan wɔn nyinaa. Twerɛ ɔbarima biara din. ");
INSERT INTO twiasante_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Wo ne Aaron na mobɛkan mmarima a wɔadi mfeɛ aduonu no ne deɛ ɛboro saa a wɔtumi kɔ ɔsa. ");
INSERT INTO twiasante_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ɔbarima a ɔfiri abusuakuo biara mu a ɔyɛ ntuanoni na ɔbɛboa mo. ");
INSERT INTO twiasante_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Mmarima a wɔbɛboa mo no edin nie: “Ruben abusuakuo no ntuanoni yɛ Sedeur babarima Elisur; ");
INSERT INTO twiasante_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeon abusuakuo no ntuanoni yɛ Surisadai babarima Selumiel; ");
INSERT INTO twiasante_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yuda abusuakuo no ntuanoni yɛ Aminadab babarima Nahson; ");
INSERT INTO twiasante_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Isakar abusuakuo no ntuanoni yɛ Suar babarima Netanel; ");
INSERT INTO twiasante_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Sebulon abusuakuo no ntuanoni yɛ Helon babarima Eliab; ");
INSERT INTO twiasante_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yosef mmammarima no: Efraim abusuakuo no ntuanoni yɛ Amihud babarima Elisama; Manase abusuakuo no ntuanoni yɛ Pedahsur babarima Gamaliel; ");
INSERT INTO twiasante_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Benyamin abusuakuo ntuanoni yɛ Gideoni babarima Abidan; ");
INSERT INTO twiasante_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan abusuakuo ntuanoni yɛ Amisadai babarima Ahieser; ");
INSERT INTO twiasante_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Aser abusuakuo ntuanoni yɛ Okran babarima Pagiel; ");
INSERT INTO twiasante_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gad abusuakuo ntuanoni yɛ Deguel babarima Eliasaf; ");
INSERT INTO twiasante_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Naftali abusuakuo ntuanoni yɛ Enan babarima Ahira.” ");
INSERT INTO twiasante_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Yeinom ne mmarima a wɔyii wɔn firii nnipa no mu, a wɔyɛ ntuanofoɔ ma wɔn agyanom mmusua no. ");
INSERT INTO twiasante_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mose ne Aaron faa saa nnipa yi a wɔabobɔ wɔn edin yi, ");
INSERT INTO twiasante_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","na ɛda a ɛdi ɛkan wɔ ɔbosome a ɛtɔ so mmienu no mu no, wɔfrɛɛ ɔmanfoɔ no nyinaa. Nnipa no nam wɔn mmusuakuo ne wɔn mmusua so kyerɛɛ wɔn mmusuadua na wɔtwerɛɛ mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa no edin mmaako mmaako ");
INSERT INTO twiasante_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","sɛdeɛ Awurade hyɛɛ Mose no. Enti ɔkan wɔn wɔ Sinai ɛserɛ so. ");
INSERT INTO twiasante_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ruben a ɔyɛ Israel abakan asefoɔ: Mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa a wɔtumi kɔ ɔsa no, wɔtwerɛɛ wɔn edin mmaako mmaako sɛdeɛ wɔn mmusua teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Nnipa dodoɔ a wɔfiri Ruben abusuakuo mu yɛ mpem aduanan nsia ne ahanum (46,500). ");
INSERT INTO twiasante_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simeon asefoɔ: Mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa a wɔbɛtumi akɔ ɔsa no, wɔtwerɛɛ wɔn edin mmaako mmaako sɛdeɛ wɔn mmusua teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Nnipa dodoɔ a wɔfiri Simeon abusuakuo mu yɛ mpem aduonum nkron ne ahasa (59,300). ");
INSERT INTO twiasante_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gad asefoɔ: Mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa a wɔbɛtumi akɔ ɔsa no, wɔtwerɛɛ wɔn edin sɛdeɛ wɔn mmusua teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Nnipa dodoɔ a wɔfiri Gad abusuakuo mu yɛ mpem aduanan enum ahansia ne aduonum (45,650). ");
INSERT INTO twiasante_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Yuda asefoɔ: Mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa a wɔbɛtumi akɔ ɔsa no, wɔtwerɛɛ wɔn edin sɛdeɛ wɔn mmusua teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Nnipa dodoɔ a wɔfiri Yuda abusuakuo mu yɛ mpem aduɔson ɛnan ne ahansia (74,600). ");
INSERT INTO twiasante_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Isakar asefoɔ: Mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa a wɔbɛtumi akɔ ɔsa no, wɔtwerɛɛ wɔn edin sɛdeɛ wɔn mmusua teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Nnipa dodoɔ a wɔfiri Isakar abusuakuo no yɛ mpem aduonum ɛnan ne ahanan (54,400). ");
INSERT INTO twiasante_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Sebulon asefoɔ: Mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa a wɔbɛtumi akɔ ɔsa no, wɔtwerɛɛ wɔn edin sɛdeɛ wɔn mmusua teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Nnipa dodoɔ a wɔfiri Sebulon abusuakuo no mu yɛ mpem aduonum nson ne ahanan (57,400). ");
INSERT INTO twiasante_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Yosef mmammarima no: Efraim asefoɔ: Mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa a wɔbɛtumi akɔ ɔsa no, wɔtwerɛɛ wɔn edin sɛdeɛ wɔn mmusua teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Nnipa dodoɔ a wɔfiri Efraim abusuakuo no mu yɛ mpem aduanan ne ahanum (40,500). ");
INSERT INTO twiasante_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manase asefoɔ: Mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa a wɔbɛtumi akɔ ɔsa no, wɔtwerɛɛ wɔn edin sɛdeɛ wɔn mmusua teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Nnipa dodoɔ a wɔfiri Manase abusuakuo no mu yɛ mpem aduasa mmienu ne ahanu (32,200). ");
INSERT INTO twiasante_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Benyamin asefoɔ: Mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa a wɔbɛtumi akɔ ɔsa no, wɔtwerɛɛ wɔn edin sɛdeɛ wɔn mmusua teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Nnipa dodoɔ a wɔfiri Benyamin abusuakuo no mu yɛ mpem aduasa enum ne ahanan (35,400). ");
INSERT INTO twiasante_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan asefoɔ: Mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa a wɔbɛtumi akɔ ɔsa no, wɔtwerɛɛ wɔn edin sɛdeɛ wɔn mmusua teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Nnipa dodoɔ a wɔfiri Dan abusuakuo no mu yɛ mpem aduosia mmienu ne ahanson (62,700). ");
INSERT INTO twiasante_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Aser asefoɔ: Mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa a wɔbɛtumi akɔ ɔsa no, wɔtwerɛɛ wɔn edin sɛdeɛ wɔn mmusua teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Nnipa dodoɔ a wɔfiri Aser abusuakuo no mu yɛ mpem aduanan baako ne ahanum (41,500). ");
INSERT INTO twiasante_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Naftali asefoɔ: Mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa a wɔbɛtumi akɔ ɔsa no, wɔtwerɛɛ wɔn edin sɛdeɛ wɔn mmusua teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Nnipa dodoɔ a wɔfiri Naftali abusuakuo no mu yɛ mpem aduonum mmiɛnsa ne ahanan (53,400). ");
INSERT INTO twiasante_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Yeinom ne mmarima a Mose ne Aaron ne Israel mmusuakuo dumienu no ntuanofoɔ kan wɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Israelfoɔ a na wɔadi mfeɛ aduonu anaa deɛ ɛboro saa no a wɔbɛtumi adɔm Israel akodɔm no nso, wɔgyinaa wɔn mmusua so kan wɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Na wɔn nyinaa dodoɔ yɛ mpem ahansia ne mmiɛnsa ne ahanum aduonum (603,550). ");
INSERT INTO twiasante_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Mmusua a wɔwɔ Lewi abusuakuo no deɛ, wɔankan wɔn anka wɔn a aka no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Na Awurade aka akyerɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Nkan Lewifoɔ abusuakuo no, na mfa wɔn nka Israelfoɔ a wɔaka no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Fa Ahyiaeɛ Ntomadan no ho dwumadie hyɛ Lewifoɔ no nsa. Wɔnhwɛ nneɛma a wɔde asiesie mu ne deɛ ɛkeka ho nyinaa so. Wɔn na wɔbɛsoa Ahyiaeɛ Ntomadan no ne emu nneɛma, wɔbɛhwɛ so na wɔatenatena ho. ");
INSERT INTO twiasante_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ɛberɛ biara a ɛsɛ sɛ wɔtu Ahyiaeɛ Ntomadan no, Lewifoɔ no na ɛsɛ sɛ wɔtutu, na baabiara a wɔde bɛsi no, wɔn na wɔbɛyɛ. Onipa foforɔ biara a ɔbɛbɛn ho no, wɔbɛkum no. ");
INSERT INTO twiasante_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israel abusuakuo biara bɛnya nʼatenaeɛ ne ne frankaa. ");
INSERT INTO twiasante_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Lewifoɔ no bɛsisi wɔn ntomadan atwa Ahyiaeɛ Ntomadan no ho ahyia, sɛdeɛ ɛbɛyɛ a Onyankopɔn abufuhyeɛ remma Israelfoɔ no so. Lewifoɔ no na wɔbɛhwɛ Ahyiaeɛ Ntomadan no so.” ");
INSERT INTO twiasante_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israelfoɔ no yɛɛ yeinom nyinaa sɛdeɛ Awurade hyɛɛ Mose no. ");
INSERT INTO twiasante_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Awurade ka kyerɛɛ Mose ne Aaron sɛ: ");
INSERT INTO twiasante_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Abusua biara bɛnya nʼafa wɔ atenaeɛ hɔ, na ekuo biara bɛtena nʼabusua frankaa ase. Na mmusua no atenaeɛ ahodoɔ no mfimfini na wɔde Ahyiaeɛ Ntomadan no bɛsi.” ");
INSERT INTO twiasante_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Apueeɛ fam, baabi a owia pue firi hɔ no na ɛsɛ sɛ Yuda nnipa nkyekyɛmu ahodoɔ no nyinaa bɔ wɔn atenaeɛ wɔ wɔn frankaa ase. Yudafoɔ ntuanoni ne Aminadab ba Nahson. ");
INSERT INTO twiasante_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Na ne dɔm no ano si mpem aduɔson ɛnan ne ahansia (74,600). ");
INSERT INTO twiasante_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Isakar abusuakuo na wɔbɛdi so. Wɔn ntuanoni ne Suar babarima Netanel. ");
INSERT INTO twiasante_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Na ne dɔm no ano si mpem aduonum ɛnan ne ahanan (54,400). ");
INSERT INTO twiasante_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Sebulon abusuakuo na wɔbɛdi so. Wɔn ntuanoni ne Helon babarima Eliab. ");
INSERT INTO twiasante_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Na ne dɔm no ano si mpem aduonum nson ne ahanan (57,400). ");
INSERT INTO twiasante_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Enti na nnipa dodoɔ a wɔwɔ Yuda atenaeɛ no nyinaa sɛdeɛ wɔn nkyekyɛmu teɛ no ano si mpem ɔha aduɔwɔtwe nsia ne ahanan (186,400). Sɛ Israelfoɔ no tu a, saa mmusuakuo mmiɛnsa yi na ɛdi ɛkan. ");
INSERT INTO twiasante_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Anafoɔ fam na Ruben nnipa nkyekyɛmu ahodoɔ no nyinaa bɛbɔ wɔn atenaeɛ de wɔn frankaa asi. Wɔn ntuanoni ne Sedeur babarima Elisur. ");
INSERT INTO twiasante_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ne dɔm ano si mpem aduanan nsia ne ahanum (46,500). ");
INSERT INTO twiasante_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Simeon abusuakuo na wɔbɛdi so. Wɔn ntuanoni ne Surisadai babarima Selumiel. ");
INSERT INTO twiasante_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ne dɔm ano si mpem aduonum nkron ne ahasa (59,300). ");
INSERT INTO twiasante_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Gad abusuakuo na wɔbɛdi so. Wɔn ntuanoni ne Reuel babarima Eliasaf. ");
INSERT INTO twiasante_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Na ne dɔm ano si mpem aduanan enum ahansia ne aduonum (45,650). ");
INSERT INTO twiasante_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Na mmarima a wɔwɔ Ruben atenaeɛ ne sɛdeɛ wɔn nkyekyɛmu teɛ no ano si mpem ɔha aduonum baako ahanan ne aduonum (151,450). Na sɛ Israelfoɔ tu a, wɔn na wɔtɔ so mmienu. ");
INSERT INTO twiasante_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Afei Lewifoɔ no de Ahyiaeɛ Ntomadan bɛfiri wɔn atenaeɛ mfimfini hɔ akɔ. Mmusuakuo no nyinaa bɛkɔ no nnidisoɔ sɛdeɛ wɔn atenaeɛ nhyehyɛeɛ teɛ, wɔ wɔn mmusuakuo mfrankaa akyi. ");
INSERT INTO twiasante_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Efraim abusuakuo bɛfa atenaeɛm hɔ atɔeɛ fam adi wɔn abusua frankaa akyi. Wɔn ntuanoni ne Amihud babarima Elisama. ");
INSERT INTO twiasante_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ne dɔm ano si mpem aduanan ne ahanum (40,500). ");
INSERT INTO twiasante_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Manase abusuakuo na wɔbɛdi so. Wɔn ntuanoni ne Pedahsur babarima Gamaliel. ");
INSERT INTO twiasante_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ne dɔm ano si mpem aduasa mmienu ne ahanum (32,200). ");
INSERT INTO twiasante_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Benyamin abusuakuo na wɔdi so. Wɔn ntuanoni ne Gideoni babarima Abidan. ");
INSERT INTO twiasante_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ne dɔm ano si mpem aduasa enum ne ahanan (35,400). ");
INSERT INTO twiasante_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Na mmarima a wɔwɔ Efraim atenaeɛ ne sɛdeɛ wɔn nkyekyɛmu teɛ no ano si mpem ɔha ne nnwɔtwe ne ɔha baako (108,100). Na sɛ Israelfoɔ tu a, wɔn na wɔtɔ so mmiɛnsa. ");
INSERT INTO twiasante_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Dan abusuakuo bɛfa atifi fam adi wɔn abusua frankaa akyi. Wɔn ntuanoni ne Amisadai babarima Ahieser. ");
INSERT INTO twiasante_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ne dɔm ano si mpem aduosia mmienu ne ahanson (62,700). ");
INSERT INTO twiasante_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Aser abusuakuo no bɛdi so. Wɔn ntuanoni ne Okran babarima Pagiel. ");
INSERT INTO twiasante_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ne dɔm ano si mpem aduanan baako ne ahanum (41,500). ");
INSERT INTO twiasante_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Naftali abusuakuo no bɛdi so. Wɔn ntuanoni ne Enan ba Ahira. ");
INSERT INTO twiasante_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ne dɔm ano si mpem aduonum mmiɛnsa ne ahanan (53,400). ");
INSERT INTO twiasante_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Mmarima a wɔwɔ Dan atenaeɛ no ano si mpem ɔha aduonum nson ne ahansia (157,600). ");
INSERT INTO twiasante_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Sei na Israelfoɔ a wɔkan wɔn mmusuakuo mmusuakuo no teɛ. Wɔn a wɔwɔ atenaeɛ hɔ nyinaa, sɛdeɛ wɔn nkyekyɛmu teɛ no ano si mpem ahansia ne mmiɛnsa ahanum ne aduonum (603,550). ");
INSERT INTO twiasante_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Sɛdeɛ Awurade hyɛɛ Mose no, wɔankan Lewifoɔ no anka Israelfoɔ no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Enti Israelfoɔ yɛɛ biribiara sɛdeɛ Awurade hyɛɛ Mose no. Wɔbobɔɔ wɔn atenaeɛ, tenatenaa wɔn frankaa ahodoɔ ase, na wɔnantee nnidisoɔ nnidisoɔ sɛdeɛ wɔn mmusua ne wɔn afie teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ɛberɛ a Awurade kasa kyerɛɛ Mose wɔ Sinai Bepɔ so no. ");
INSERT INTO twiasante_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Na yeinom ne Aaron ne Mose abusua. Aaron mmammarima edin na ɛdidi soɔ yi: Nadab, nʼabakan, Abihu, Eleasa ne Itamar. ");
INSERT INTO twiasante_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Yeinom ne Aaron mma a wɔasra wɔn ngo na wɔayi wɔn asi hɔ sɛ asɔfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab ne Abihu deɛ, wɔwuwuu wɔ Awurade anim ɛberɛ a wɔhyee afɔrebɔdeɛ wɔ ogya a ɛmfata so wɔ Sinai ɛserɛ so. Na wɔnni mma enti, Eleasa ne Itamar nko ara na wɔsomm sɛ asɔfoɔ, ɛberɛ a wɔn agya Aaron te ase. ");
INSERT INTO twiasante_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Awurade ka kyerɛɛ Mose sɛ: ");
INSERT INTO twiasante_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Frɛ Lewifoɔ no, na fa wɔn ma ɔsɔfoɔ Aaron sɛ nʼaboafoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Wɔbɛyɛ adwuma wɔ Ahyiaeɛ Ntomadan no mu ama ɔsɔfoɔ Aaron ne nnipa no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Afei, wɔbɛhwɛ nneɛma a wɔde siesie Ahyiaeɛ Ntomadan mu no so, de asi Israelfoɔ no no anan mu ayɛ asodie a wɔyɛ wɔ Ahyiaeɛ Ntomadan no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Fa Lewifoɔ no ma Aaron ne ne mmammarima; wɔn ne Israelfoɔ a wɔde wɔn bɛma no korakora. ");
INSERT INTO twiasante_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ma Aaron ne ne mmammarima no nsom sɛ asɔfoɔ; onipa foforɔ biara a ɔbɛbɛne kronkronbea hɔ no, ɛsɛ sɛ wɔkum no.” ");
INSERT INTO twiasante_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Mayi Lewifoɔ no afiri Israelfoɔ no mu de wɔn asi Israel babaa biara abakan a ɔyɛ ɔbarima anan mu. Lewifoɔ no yɛ me dea, ");
INSERT INTO twiasante_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ɛfiri sɛ abakan biara wɔ me. Ɛberɛ a mekunkum mmakan wɔ Misraim no, megyaa Israel mmakan, sɛ wɔyɛ nnipa anaa mmoa. Wɔyɛ me dea. Mene Awurade.” ");
INSERT INTO twiasante_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Afei, Awurade ka kyerɛɛ Mose wɔ Sinai ɛserɛ so sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Kan Lewifoɔ no wɔ wɔn mmusua ne afie mu. Kan ɔbarima biara firi deɛ wadi bosome baako so.” ");
INSERT INTO twiasante_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Enti Mose kanee wɔn sɛdeɛ Awurade hyɛɛ no no. ");
INSERT INTO twiasante_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Yeinom ne Lewi mmammarima: Gerson, Kohat ne Merari. ");
INSERT INTO twiasante_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gerson asefoɔ nie: Libni ne Simei. ");
INSERT INTO twiasante_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohat asefoɔ: Amram, Ishar, Hebron ne Usiel. ");
INSERT INTO twiasante_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari asefoɔ: Mahli ne Musi. Yeinom ne Lewifoɔ sɛdeɛ wɔn mmusua ne wɔn afie teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gerson asefoɔ no na wɔyɛ mmusua a wɔfiri Libni ne Simei ase. ");
INSERT INTO twiasante_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Na Gersonfoɔ mmarima a wɔadi bosome ne deɛ ɛboro saa a wɔfiri Gerson mmusua mu no dodoɔ yɛ mpem ahanson ne ahanum (7,500). ");
INSERT INTO twiasante_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Wɔn atenaeɛ wɔ Ahyiaeɛ Ntomadan no akyi wɔ atɔeɛ fam. ");
INSERT INTO twiasante_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Na Gersonfoɔ no ntuanoni ne Lael babarima Eliasaf. ");
INSERT INTO twiasante_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Saa mmusuakuo mmienu yi na na wɔhwɛ Ahyiaeɛ Ntomadan no ne ne nkataho no ne ɛkwan nsɛnanotam no so. ");
INSERT INTO twiasante_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Afei, na wɔhwɛ adihɔ nsɛnanotam a ɛtwa Ahyiaeɛ Ntomadan no ho ne afɔrebukyia ne adihɔ nsɛnanotam, nhoma ne ɛhɔ nneɛma a wɔde di dwuma ahodoɔ no nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kohat asefoɔ yɛ mmusua a wɔfiri Amram, Ishar, Hebron ne Usiel ase. ");
INSERT INTO twiasante_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Na Kehat mmusua no mu mmarima a wɔadi bosome ne deɛ ɛboro saa dodoɔ yɛ mpem aha nwɔtwe ne ahansia (8,600). Wɔn na na wɔhwɛ kronkronbea mu hɔ so. ");
INSERT INTO twiasante_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Wɔmaa wɔn atenaeɛ wɔ Ahyiaeɛ Ntomadan no anafoɔ fam. ");
INSERT INTO twiasante_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Na Kohatfoɔ ntuanoni no ne Usiel babarima Elisafan. ");
INSERT INTO twiasante_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Saa mmusua ɛnan yi na na wɔhwɛ apam adaka, ɛpono, kaneadua, afɔrebukyia hodoɔ, ne deɛ ɛkeka ho a na wɔde di dwuma wɔ kronkronbea hɔ, mfimfini ntwamutam ne nneɛma a wɔde di dwuma ahodoɔ wɔ hɔ nyinaa no so. ");
INSERT INTO twiasante_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Aaron babarima ɔsɔfoɔ Eleasa no na na ɔyɛ ɔpanin wɔ Lewifoɔ no nyinaa so. Ɔyɛɛ no panin wɔ asɔfoɔ a wɔhwɛ kronkronbea no so. ");
INSERT INTO twiasante_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Na Merari asefoɔ no yɛ mmusua a wɔfiri Mahli ne Musi ase. ");
INSERT INTO twiasante_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Merarifoɔ mmusua no mu na mmarima a wɔadi bosome ne deɛ ɛboro saa dodoɔ yɛ mpem nsia ne ahanu (6,200). ");
INSERT INTO twiasante_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merari abusua no ntuanoni ne Abihail babarima Suriel, na wɔtenaa Ahyiaeɛ Ntomadan no atifi fam. ");
INSERT INTO twiasante_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Dwumadie a wɔde hyɛɛ saa mmusuakuo mmienu yi nsa ne sɛ, wɔbɛhwɛ Ahyiaeɛ Ntomadan no nnyinasoɔ so. Afei, wɔbɛhwɛ mmeamu nnua, mpunan, nsisisoɔ ne ɛho nneɛma a wɔde di dwuma nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Afei, mpunan a ɛwɔ adihɔ hɔ nyinaa ne ne nsisisoɔ, mpɛɛwa, ne ntampehoma nyinaa, wɔbɛhwɛ so. ");
INSERT INTO twiasante_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ahyiaeɛ Ntomadan no apueeɛ fam, deɛ owia pue firi no, wɔgya maa Mose ne Aaron ne ne mmammarima sɛ wɔnsisi wɔn ntomadan wɔ hɔ. Saa nnipa yi na na wɔsi Israelfoɔ no anan mu di Ahyiaeɛ Ntomadan no ho dwuma nyinaa. Onipa foforɔ biara a ɔbɛbɛn kronkronbea hɔ no, wɔbɛkum no. ");
INSERT INTO twiasante_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Lewifoɔ a Awurade hyɛɛ Mose ne Aaron sɛ wɔnkan wɔn sɛdeɛ wɔn mmusua teɛ a ɔbarima biara a wɔadi bosome ne deɛ ɛboro saa ka ho no dodoɔ yɛ mpem aduonu mmienu (22,000). ");
INSERT INTO twiasante_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Awurade ka kyerɛɛ Mose sɛ, “Kan Israelfoɔ mmakan a wɔyɛ mmarima na wɔadi bosome ne deɛ ɛboro saa no, na twerɛ wɔn edin. ");
INSERT INTO twiasante_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Lewifoɔ no bɛyɛ me dea. Ma wɔnsi Israelfoɔ mmakan nyinaa anan mu, na Lewifoɔ nyɛmmoa mmakan nsi Israelfoɔ nyɛmmoa mmakan anan mu. Mene Awurade.” ");
INSERT INTO twiasante_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Enti Mose kanee Israelfoɔ mmakan nyinaa sɛdeɛ Awurade hyɛɛ no no. ");
INSERT INTO twiasante_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Mmammarima mmakan a wɔadi bosome ne deɛ ɛboro saa no a ɔtwerɛɛ wɔn edin no ano si mpem aduonu mmienu ahanu ne aduɔson mmiɛnsa (22,273). ");
INSERT INTO twiasante_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Ma Lewifoɔ nsi Israelfoɔ mmakan ananmu. Na Lewifoɔ nyɛmmoa mmakan nso nsi Israelfoɔ nyɛmmoa mmakan ananmu. Lewifoɔ yɛ me dea. Mene Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ansa na mobɛgye Israelfoɔ mmakan ahanu aduɔson mmiɛnsa no a wɔboro Lewifoɔ no dodoɔ so no, ");
INSERT INTO twiasante_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","momma wɔntua tiadeɛ, sɛdeɛ hyiadan mu nnwetɛbena teɛ, a emu duru yɛ gram aduonum nson. ");
INSERT INTO twiasante_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Fa tiadeɛ sika no ma Aaron ne ne mma.” ");
INSERT INTO twiasante_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Enti Mose gyegyee Israelfoɔ ahanu aduɔson mmiɛnsa a na wɔboro Lewifoɔ no dodoɔ so no tiadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Sika a wɔgyegyeeɛ no nyinaa ano sii dwetɛ kilogram dunum ne fa. ");
INSERT INTO twiasante_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Na Mose de maa Aaron ne ne mmammarima sɛdeɛ Awurade hyɛɛ no no. ");
INSERT INTO twiasante_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Afei Awurade ka kyerɛɛ Mose ne Aaron sɛ: ");
INSERT INTO twiasante_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Kan Kohatfoɔ no dodoɔ a wɔwɔ Lewifoɔ no abusua mu. ");
INSERT INTO twiasante_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Saa nnipakan yi bɛyɛ mmarima nko ara a wɔadi firi mfeɛ aduasa kɔsi aduonum a wɔbɛtumi ayɛ adwuma wɔ Ahyiaeɛ Ntomadan mu. ");
INSERT INTO twiasante_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Kohat mma no dwumadie ne sɛ wɔbɛhwɛ akronkronneɛ no so wɔ Ahyiaeɛ Ntomadan no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Sɛ wɔretu afiri atenaeɛ hɔ a, Aaron ne ne mma mmarima na wɔbɛdi ɛkan akɔ Ahyiaeɛ Ntomadan no mu akɔfa nkatanimu no de akata adaka no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Afei, wɔde abirekyie nwoma bɛkata nkatanimu no ho na wɔde ntoma tuntum akata abirekyie nhoma no ho na wɔde nnua a wɔde soa adaka no ahyehyɛ ne nkawa no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Afei, wɔmfa ntoma tuntum nsɛ ɛpono a Hyiadan mu Burodo no da so no so, na wɔmfa nyowaa, ntere, dwaresɛn akɛseɛ, nkuruwa ne Burodo no ngu ntoma no so. ");
INSERT INTO twiasante_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Wɔde ntoma kɔkɔɔ bɛkata so na wɔasane de abirekyie nhoma akata ntoma kɔkɔɔ no so. Na afei, wɔde nnua a wɔde bɛsoa no ahyehyɛ ɛpono no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Afei, ɛsɛ sɛ wɔde ntoma tuntum kata kaneadua no, nkanea no, adaawa no, nkukuo apaawa no ne ngo toa no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Saa nneɛma yi nyinaa nso, wɔde abirekyie nhoma bɛkata ho na wɔde nkyekyereeɛ yi nyinaa abɛgu ɛpono so. ");
INSERT INTO twiasante_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Ɛsɛ sɛ wɔde ntoma tuntum kata sikakɔkɔɔ afɔrebukyia no so na wɔsane de abirekyie nhoma kata so bio na wɔde nnua a wɔde soa no hyehyɛ afɔrebukyia no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Hyiadan no mu som no ho nneɛma a aka no nyinaa, ɛsɛ sɛ wɔde ntoma bibire kyekyere ho a wɔde abirekyie nhoma asane akyekyere ho na wɔde to mpata a wɔde soa no so. ");
INSERT INTO twiasante_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Ɛsɛ sɛ wɔtu nsõ no nyinaa firi afɔrebukyia no mu guo, na wɔde ntoma kɔkɔɔ bibire kyekyere ho. ");
INSERT INTO twiasante_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ɛsɛ sɛ wɔde afɔrebukyia no ho ɔsom nneɛma nyinaa gu ntoma no so. Saa nneɛma no ne nkyɛnsee a wɔnoa mu, nsosɔmu, sofi, kyɛnsee kɛseɛ ne nneɛma a wɔkora mu nneɛma gu ntoma no so na wɔde abirekyie nhoma kata ne nyinaa so. Na afei, wɔde nnua a wɔde soa no gu faako a ɛsɛ sɛ wɔde guo. ");
INSERT INTO twiasante_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Sɛ Aaron ne ne mma mmarima no wie kronkronbea hɔ nneɛma no anoboa a, Kohat ne nʼabusuafoɔ bɛba abɛsoa akɔ baabiara a wɔretu nneɛma akɔ. Nanso wɔnni ho kwan sɛ wɔde wɔn nsa ka nneɛma a ɛho te no bi. Wɔyɛ saa a, wɔbɛwuwu. Kohat mma na ɛsɛ sɛ wɔsoa nneɛma a ɛwɔ Ahyiaeɛ Ntomadan no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Aaron babarima Eleasa na ɔbɛhwɛ ngo a wɔde bɛsɔ kanea, nnuhwam, daa aduane a wɔde bɔ afɔdeɛ, ɔsra ngo ne Ahyiaeɛ Ntomadan no nyinaa so. Biribibiara a ɛwɔ Ahyiaeɛ Ntomadan no mu no nso, ɔbɛhwɛ so.” ");
INSERT INTO twiasante_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Afei, Awurade ka kyerɛɛ Mose ne Aaron sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Monntwa Kohatfoɔ abusuakuo no mfiri Lewifoɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Sɛ wɔresoa nneɛma a ɛho te no a, deɛ ɛsɛ sɛ wɔyɛ a wɔrenwuwu nie: Ɛsɛ sɛ Aaron ne ne mma mmarima no ne wɔn kɔ hɔ kɔkyerɛ wɔn adeɛ a ɛsɛ sɛ wɔn mu biara soa. ");
INSERT INTO twiasante_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Sɛ wɔanyɛ saa a, ɛnsɛ sɛ wɔkɔ kronkronbea hɔ koraa. Sɛ wɔyɛ saa a, wɔbɛhunu nneɛma a ɛho te no na ɛrenkyɛre koraa wɔawuwu.” ");
INSERT INTO twiasante_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Kan Gerson asefoɔ a wɔfra Lewifoɔ abusua mu no, ");
INSERT INTO twiasante_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","firi mmarima a wɔadi mfeɛ aduasa kɔsi aduonum a wɔbɛtumi ayɛ adwuma kronkron wɔ Ahyiaeɛ Ntomadan mu hɔ so. ");
INSERT INTO twiasante_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Gerson mmusua no dwuma a wɔbɛdie nie: ");
INSERT INTO twiasante_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Wɔbɛsoa ntoma a ɛtwa Ahyiaeɛ Ntomadan mu hɔ, Ahyiaeɛ Ntomadan no ankasa ne deɛ ɛkata ho, abirekyie nhoma nkurusoɔ ne ntoma a ɛsɛn Ahyiaeɛ Ntomadan no ano no. ");
INSERT INTO twiasante_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Afei, wɔbɛsoa nkataho a ɛkata adihɔ hɔ ɔfasuo no ho no. Wɔbɛsoa ntoma a ɛtwa adihɔ hɔ ɛkwan no ano ne afɔrebukyia ne Ahyiaeɛ Ntomadan no ntam no. Wɔbɛsoa afɔrebukyia no, ntampehoma ne deɛ ɛkeka ho nyinaa. Wɔn na ɛsɛ sɛ wɔhwɛ, twe yeinom nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aaron anaa ne mmammarima no bi tumi ma Gerson asefoɔ no bi dwuma di. ");
INSERT INTO twiasante_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Nanso Gersonfoɔ no bɛhyɛ Aaron Itamar ase. ");
INSERT INTO twiasante_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Afei, kan Merari asefoɔ a wɔfra Lewifoɔ abusua mu no ");
INSERT INTO twiasante_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ɛfiri mmarima a wɔadi mfeɛ aduasa kɔsi aduonum so a wɔbɛtumi ayɛ adwuma wɔ Ahyiaeɛ Ntomadan mu hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Sɛ wɔpagya Ahyiaeɛ Ntomadan no a, wɔn na ɛsɛ sɛ wɔsoa ne nnyinasoɔ, nnua a ɛsisi mu, ne nsisisoɔ ");
INSERT INTO twiasante_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","mpunan a wɔde yɛɛ adihɔ hɔ afasuo no ne ne nsisisoɔ, mpɛɛwa, ntampehoma ne biribiara a wɔde di ho dwuma. Fa dwumadie ahodoɔ no hyɛ nnipa a wobɛbobɔ wɔn edin nsa. ");
INSERT INTO twiasante_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Merari asefoɔ no, Aaron babarima Itamar na ɔbɛhwɛ wɔn so.” ");
INSERT INTO twiasante_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Enti Mose ne Aaron ne mpanimfoɔ no bi kɔkan Kohatfoɔ ");
INSERT INTO twiasante_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","a mmarima a wɔadi mfeɛ aduasa kɔsi aduonum nyinaa a wɔbɛtumi ayɛ Ahyiaeɛ Ntomadan mu adwuma ka ho, ");
INSERT INTO twiasante_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","na wɔhunuu sɛ wɔn nyinaa dodoɔ yɛ mpem mmienu ne ahanson aduonum. ");
INSERT INTO twiasante_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Wɔyɛɛ yeinom nyinaa de dii Awurade ahyɛdeɛ a ɔhyɛɛ Mose no so. ");
INSERT INTO twiasante_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Wɔkan Gersonfoɔ no mmusua ne wɔn mmusuakuo. ");
INSERT INTO twiasante_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Wɔkan mmarima a wɔadi mfeɛ aduasa kɔsi aduonum a wɔbɛtumi ayɛ adwuma wɔ Ahyiaeɛ Ntomadan no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Wɔn nyinaa dodoɔ yɛɛ mpem mmienu ahansia ne aduasa. ");
INSERT INTO twiasante_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Enti na Gersonfoɔ a wɔfata sɛ wɔsom wɔ Ahyiaeɛ Ntomadan no mu no nyinaa dodoɔ ne no. Mose ne Aaron na wɔkan wɔn sɛdeɛ Awurade hyɛɛ wɔn no. ");
INSERT INTO twiasante_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Merarifoɔ no nso, wɔkan wɔn mmusua ne wɔn mmusuakuo. ");
INSERT INTO twiasante_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Wɔkan wɔn mmarima a wɔadi mfeɛ aduasa kɔsi aduonum a wɔfata sɛ wɔyɛ adwuma wɔ Ahyiaeɛ Ntomadan no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Wɔn nyinaa dodoɔ yɛɛ mpem mmiɛnsa ne ahanu. ");
INSERT INTO twiasante_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Enti Merarifoɔ a wɔfata sɛ wɔsom wɔ Ahyiaeɛ Ntomadan no mu no nyinaa dodoɔ ne no. Mose ne Aaron na wɔkan wɔn sɛdeɛ Awurade hyɛɛ Mose no. ");
INSERT INTO twiasante_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Enti Mose ne Aaron ne Israel mpanimfoɔ nam Lewifoɔ no mmusua ne wɔn afie so kan wɔn nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Mmarima a na wɔadi firi mfeɛ aduasa kɔsi mfeɛ aduonum no nyinaa a na wɔfata sɛ wɔyɛ adwuma wɔ Ahyiaeɛ Ntomadan no mu hɔ no ne wɔn a wɔbɛsoa akɔ no ");
INSERT INTO twiasante_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","dodoɔ yɛ mpem aha nwɔtwe ahanum ne aduɔwɔtwe. ");
INSERT INTO twiasante_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Awurade hyɛ a ɔhyɛɛ Mose no enti na wɔnam so kanee nnipa no. ");
INSERT INTO twiasante_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yei ne mmara a Awurade sane hyɛ maa Mose: ");
INSERT INTO twiasante_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Ka kyerɛ Israelfoɔ no sɛ, ɛsɛ sɛ wɔpam akwatafoɔ nyinaa firi atenaeɛ hɔ. Wɔn a ekuro atutu wɔn ne wɔn a wɔde wɔn nsa akɔka efunu enti wɔn ho agu fi nyinaa no, ɛsɛ sɛ wɔpam wɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Mmarima ne mmaa nyinaa ka ho. Yi wɔn nyinaa firi hɔ sɛdeɛ ɛbɛyɛ na atenaeɛ hɔ a me ne mo bɛtena no ho rengu fi”. ");
INSERT INTO twiasante_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Wɔdii Awurade mmara no so. ");
INSERT INTO twiasante_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Ka kyerɛ Israelfoɔ no sɛ, sɛ ɔbarima o, ɔbaa o, ɔdi Awurade hwammɔ a, ɛyɛ bɔne. ");
INSERT INTO twiasante_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Ɛsɛ sɛ ɔka ne bɔne na adeɛ a ɔwiaeɛ no, ɔtua ho ka nyinaa na ɔsane de ɛho ka no nkyɛmu ɔha mu aduonu ka ho de ma onipa ko a ɔbɔɔ no korɔno no. ");
INSERT INTO twiasante_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Na sɛ onipa ko a ɔyɛɛ no bɔne no awu na ɔnni obusuani biara a ɔbɛn no a wɔbɛtua ho ka ama no no a, ɛsɛ sɛ, sɛ ɔtua ka no ma ɔsɔfoɔ a, odwennini ka ho sɛ mpatadeɛ. Ɛyɛ Awurade dea. ");
INSERT INTO twiasante_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Akyɛdeɛ kronkron a Israelfoɔ de bɛkyɛ ɔsɔfoɔ no yɛ ne dea. ");
INSERT INTO twiasante_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ɔsɔfoɔ biara bɛfa akyɛdeɛ kronkron biara a ne nsa bɛka.” ");
INSERT INTO twiasante_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Ka kyerɛ Israelfoɔ no sɛ, sɛ ɔbarima bi yere kɔbɔ adwaman ");
INSERT INTO twiasante_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","nanso ɔnhunu asɛm no mu nokorɛ na ɔnnya ɔdanseni ");
INSERT INTO twiasante_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","na ɔtwe ho ninkunu na ɔnte ne ho ase a, ");
INSERT INTO twiasante_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ɔbarima no de ne yere no bɛkɔ ɔsɔfoɔ anim a ɔbaa no ho afɔrebɔdeɛ a ɛyɛ atokosiam a wɔmfaa ohwam ngo mfraeɛ lita mmienu ka ho. Ɛfiri sɛ, ɛyɛ ninkuntwe afɔrebɔ. Ɛno na ɛbɛma nokorɛ ada adie ama wɔahunu sɛ ɔbaa no di fɔ anaa ɔdi bem. ");
INSERT INTO twiasante_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Ɔsɔfoɔ no de ɔbaa no bɛba Awurade anim, ");
INSERT INTO twiasante_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","na wasa Ahyiaeɛ Ntomadan no mu mfuturo de afra nsuo kronkron a ɛgu asansuo kɛseɛ bi mu no. ");
INSERT INTO twiasante_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ɔbɛsane ne ti a wakyekyere no na ɔde ninkunu afɔrebɔdeɛ no agu ne nsam de ahwɛ sɛ ɔbarima no nsusuiɛ no yɛ nokorɛ ampa ara anaasɛ ɛnyɛ nokorɛ. Ɔsɔfoɔ no bɛgyina nʼanim a ɔkura nsuo nwononwono a ɛde mmusuo ba no. ");
INSERT INTO twiasante_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","22","Ɔbɛma no aka ntam sɛ ɔnnim asɛm no ho hwee na waka akyerɛ no sɛ, sɛ wo ne ɔbarima biara nnaeɛ ka wo kunu nko ara ho deɛ a, ɛnneɛ, wo ho nte mfiri nsuo nwononwono a ɛde mmusuo ba yi ho. Na sɛ woabɔ adwaman a, ɛnneɛ, Awurade bɛdome wo wɔ wo nkurɔfoɔ mu. Ɔbɛma wo srɛ aporɔ na wo yafunu ahono. Na ɔbaa no bɛka sɛ, ‘Aane, saa na ɛsɛ sɛ ɛba.’ ");
INSERT INTO twiasante_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Ɔsɔfoɔ no bɛtwerɛ nnome yi nyinaa agu nwoma bi mu na wahohoro agu nsuo nwononwono no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Sɛ ɛsɛ sɛ ɔbaa no nom nsuo no na sɛ ɔnom wɔ ɛberɛ a wayɛ bɔne a, ɛyɛ nwononwononwono wɔ ne mu. ");
INSERT INTO twiasante_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Afei, ɔsɔfoɔ no bɛgye ninkunu afɔrebɔdeɛ no afiri ɔbaa no nsam na wahinhim no Awurade anim na ɔde akɔ afɔrebukyia no so. ");
INSERT INTO twiasante_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Ɔbɛsa ne nsabuo ma de asi ne nyinaa anan na wahye no wɔ afɔrebukyia no so na wama ɔbaa no anom nsuo no. ");
INSERT INTO twiasante_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Sɛ ne ho agu fi na wabɔ adwaman no atia ne kunu a, nsuo a wanom no bɛyɛ nwononwononwono wɔ ne mu na ne yafunu ahono na ne srɛ aporɔ na wayɛ nnome wɔ ne nkurɔfoɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Sɛ ɔyɛ kronn a ɔmmɔɔ adwaman a, wɔrenha no, na ɛrenkyɛre, ɔbɛnyinsɛn. ");
INSERT INTO twiasante_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Yei ne mmara a ɛfa ɔbaa a ne bra nyɛ na ne kunu twe ne ho ninkunu ");
INSERT INTO twiasante_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","de hwehwɛ mu hunu sɛ ɔdi ne kunu nokorɛ anaa ɔnni no nokorɛ no ho. Ɔde no bɛba Awurade anim na ɔsɔfoɔ no adi dwuma a wɔabobɔ so no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Wɔrenni ne kunu no asɛm wɔ baabiara sɛ wama yare bɔne bi aba ne yere so, ɛfiri sɛ, ɛyɛ ɔno ara na ɔma ɛbaa saa.” ");
INSERT INTO twiasante_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Awurade sane ka kyerɛɛ Mose sɛ ");
INSERT INTO twiasante_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","ɔnka nkyerɛ Israelfoɔ no sɛ, “Sɛ ɔbarima anaa ɔbaa kɔyɛ Nasareni de te ne ho wɔ Awurade anim a, ");
INSERT INTO twiasante_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ɛno akyi, saa ɛberɛ a ɔwɔ ahoteɛ no mu no, ɔnni ho kwan sɛ ɔnom nsã a ɛyɛ den anaa bobesa anaa nsã a emu ka. ");
INSERT INTO twiasante_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Saa ɛberɛ no mu no, ɔnni ho kwan sɛ ɔdi biribiara a ɛfiri bobe mu, sɛ ɛyɛ nʼaba anaa ne hono. ");
INSERT INTO twiasante_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Saa ɛberɛ no mu no, ɛnsɛ sɛ ɔyi ne tirinwi, ɛfiri sɛ, ɔyɛ kronkron na wɔate ne ho ama Awurade; ɛno enti na ɛsɛ sɛ ɔma ne tirinwi fu no. ");
INSERT INTO twiasante_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“Awurade bɔhyɛ no nna no mu no, ɔnni ho kwan sɛ ɔkɔ owufoɔ ho. ");
INSERT INTO twiasante_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Sɛ owufoɔ no yɛ nʼagya, ne maame, ne nuabarima anaa ne nuabaa koraa a, ɔnnkɔ ne ho, ɛfiri sɛ, ne bɔ a ɔhyɛ de tee ne ho no, ɔda so hyɛ aseɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","na saa ɛberɛ no mu nyinaa, wɔate ne ho ama Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Sɛ obi wu tɔ ne nkyɛn de gu ne ho fi a, nnanson akyi, ɛsɛ sɛ ɔyi ne tirinwi a ɛho agu fi no. Afei, wɔbɛdwira ne ho afiri efi a owufoɔ no de aka no no. ");
INSERT INTO twiasante_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Nʼadekyeeɛ a ɛyɛ ɛda a ɛtɔ so nwɔtwe no, ɛsɛ sɛ ɔde nturukuku mmienu anaa mmorɔnoma mma mmienu brɛ ɔsɔfoɔ wɔ Ahyiaeɛ Ntomadan no kwan ano. ");
INSERT INTO twiasante_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ɔsɔfoɔ no de nnomaa no mu baako bɛbɔ bɔne ho afɔdeɛ na ɔde ɔbaako abɔ ɔhyeɛ afɔdeɛ, na ayɛ mpatadeɛ ama deɛ ne ho agu fi no. Na ɛda no ara, ɛsɛ sɛ ɔti ne bɔhyɛ mu na ɔsane ma ne tirinwi no fu bio. ");
INSERT INTO twiasante_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Nna dodoɔ a ɔdii ne bɔhyɛ a ɛdi ɛkan no so no nyinaa ahye agu. Ɔbɛhyɛ Awurade bɔ foforɔ de afiri aseɛ, na ɔde odwennini ba a wadi afe bɛba abɛbɔ ɛfɔdie ho afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Ɛda a ne bɔhyɛ a ɛte ɔno ne Awurade ntam no wie duru no, ɛsɛ sɛ ɔkɔ Ahyiaeɛ Ntomadan no ano ");
INSERT INTO twiasante_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","kɔbɔ ɔhyeɛ afɔdeɛ ma Awurade. Ɔde odwan ba a wadi afe a ɔnnii dɛm na ɛbɛbɔ saa afɔdeɛ no. Ɛsɛ sɛ ɔde odwanbereɛ a wadi afe a ɔnnii dɛm bɔ bɔne ho afɔdeɛ na ɔde odwennini a ɔnnii dɛm bɔ asomdwoeɛ afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Nneɛma a ɔde bɛka ho no ne burodo a mmɔreka mfra mu, asikyiresiam taterɛ a wɔde ngo afra; burodo ntrawa bi a mmɔreka mfra mu a wɔde ngo ayɛ so a aduane ne nsã afɔrebɔdeɛ ka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Ɔsɔfoɔ no de saa afɔrebɔdeɛ yi nyinaa bɛba Awurade anim. Deɛ ɔde bɛdi ɛkan aba no yɛ bɔne ho afɔdeɛ ne ɔhyeɛ afɔdeɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","afei, odwennini a wɔde no bɛbɔ asomdwoeɛ afɔdeɛ a burodo kɛntɛnma a mmɔreka nni mu nso ka ho. Na deɛ ɛtwa toɔ a ɔde bɛba no ne aduane ne nsã afɔdeɛ a ɔde bɛma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Afei, ɔhotuafo no bɛyi ne tirinwi a afu kuhaa no; ɛno ne nsɛnkyerɛnnedeɛ a ɛkyerɛ sɛ, ɔnhyɛ bɔhyɛ no ase bio. Wɔbɛyɛ yei wɔ Ahyiaeɛ Ntomadan no ano, na wɔde nwi no agu asomdwoeɛ afɔdeɛ a wɔrebɔ no wɔ ogya mu no ahye no. ");
INSERT INTO twiasante_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Wɔayi ɔbarima no tirinwi no awie no, ɔsɔfoɔ no de odwennini no basa a wɔatoto, taterɛ a mmɔreka nni mu no baako ne burodo ntrawa a mmɔreka nni mu bɛhyɛ ɔbarima no nsam. ");
INSERT INTO twiasante_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Ɔsɔfoɔ no bɛhim no akɔ nʼanim aba nʼakyi wɔ Awurade anim a ɛkyerɛ ma a ɔde rema Awurade. Ne nyinaa yɛ kyɛfa a ɛho te ma ɔsɔfoɔ no. Wɔbɛyɛ no sɛdeɛ wɔyɛ odwennini no basa mu mfempadeɛ a wɔhim no wɔ Awurade anim no. Yei akyi no, ɔhotuafoɔ no tumi nom bobesa a ɛkyerɛ sɛ, wɔayi no afiri ne bɔhyɛ no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Yeinom ne mmara a ɛda hɔ ma Nasareni a wahyɛ nʼahofama ho bɔ awie, na ɔde afɔrebɔ ahodoɔ brɛ Awurade. Saa afɔrebɔ yi akyi no, ɔtumi de afɔrebɔdeɛ biara a ɔrebɛyɛ Nasareni no, ɔhyɛɛ ho bɔ sɛ ɔde bɛba no ba.” ");
INSERT INTO twiasante_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Ka kyerɛ Aaron ne ne mmammarima no sɛ ɛsɛ sɛ wɔhyira Israelfoɔ yi sononko sɛ: ");
INSERT INTO twiasante_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Awurade nhyira mo na ɔnhwɛ mo so. ");
INSERT INTO twiasante_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Awurade nte nʼanim nkyerɛ mo na ɔnnom mo. ");
INSERT INTO twiasante_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Awurade mma nʼani so nhwɛ mo na ɔmma mo asomdwoeɛ.’ ");
INSERT INTO twiasante_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Saa na ɛsɛ sɛ Aaron ne ne mmammarima hyira Israelfoɔ, na mʼankasa nso mɛhyira wɔn.” ");
INSERT INTO twiasante_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ɛda a Mose wiee Ahyiaeɛ Ntomadan no hyehyɛ no, ɔsraa ho nyinaa ngo, tee ho nyinaa a afɔrebukyia no ne ɛho nneɛma nyinaa ka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Afei, Israel mpanimfoɔ ne mmusuakuo no mu mpanin a wɔhwɛɛ nnipakan no so no nyinaa de wɔn afɔrebɔdeɛ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Wɔde nteaseɛnam nsia a wɔakatakata ho ne anantwie dumienu na wɔde baeɛ. Na nteaseɛnam no baako biara yɛ mpanimfoɔ mmienu dea, a nantwie baako yɛ wɔn mu biara dea. Wɔde ne nyinaa maa Awurade wɔ Ahyiaeɛ Ntomadan no anim. ");
INSERT INTO twiasante_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Gye wɔn akyɛdeɛ no na fa nteaseɛnam no yɛ Ahyiaeɛ Ntomadan no ho adwuma. Fa ma Lewifoɔ no na wɔmfa nni dwuma biara a ɛho hia wɔn.” ");
INSERT INTO twiasante_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Enti Mose de nteaseɛnam no ne anantwie no maa Lewifoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ɔmaa Gerson ne ne nkurɔfoɔ nteaseɛnam mmienu ne anantwie ɛnan ");
INSERT INTO twiasante_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ɛnna ɔmaa Merari ne ne nkurɔfoɔ nso nteaseɛnam ɛnan ne anantwie nwɔtwe a Aaron babarima Itamar na na ɔdi so panin. ");
INSERT INTO twiasante_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Wɔamma Kohat nkurɔfoɔ nteaseɛnam no bi, ɛfiri sɛ, na ɛsɛ sɛ wɔsoa wɔn kyɛfa a ɛfa Ahyiaeɛ Ntomadan no ho nneɛma no ho no wɔ wɔn mmatire. ");
INSERT INTO twiasante_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ɛda no, mpanimfoɔ a wɔdi anim no nso de atenaseɛbɔ akyɛdeɛ bɛguu afɔrebukyia no anim da a wɔresra afɔrebukyia no ngo no. ");
INSERT INTO twiasante_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Awurade ka kyerɛɛ Mose sɛ, “Kyekyɛ nna a obiara de nʼatenasebɔdeɛ bɛba afɔrebukyia no so.” ");
INSERT INTO twiasante_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Aminadab babarima Nahson a ɔfiri Yuda abusuakuo mu na ɔde nʼatenasebɔdeɛ baa ɛda a ɛdi ɛkan no. ");
INSERT INTO twiasante_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Nneɛma a ɔde baeɛ no yɛ: dwetɛ prɛte baako a emu duru yɛ kilogram baako ne fa, dwetɛ kyɛnsee bi a ɛbɛyɛ kilogram baako a ne nyinaa na wɔde asikyiresiam muhumuhu a wɔde ngo afra ahyɛ no ma ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Afei, ɔde sikakɔkɔɔ adaka ketewa bi a ɛkari gram ɔha ne dunan (114) a wɔde aduhwam ahyɛ no ma baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Ɔde nantwinini ba, odwennini ne odwammaa a wadi afe baeɛ sɛ ɔhyeɛ afɔrebɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Wɔde abirekyie baeɛ sɛ bɔne ho afɔrebɔdeɛ ");
INSERT INTO twiasante_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","na asomdwoeɛ afɔrebɔdeɛ no deɛ, anantwie mmienu, nnwennini enum, mmirekyie enum ne nnwammaa enum a wɔadi afe na wɔde wɔn baeɛ. Yei ne afɔdeɛ a Nahson babarima Aminadab de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ɛda a ɛtɔ so mmienu no, Suar babarima Netanel a ɔda Isakar abusuakuo ano no de nʼafɔrebɔdeɛ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Na nʼafɔrebɔdeɛ no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ kyɛnsee a emu duru yɛ kilogram baako a wɔde atokoɔ afɔrebɔdeɛ a ɛyɛ asikyiresiam muhumuhu a wɔde ngo afra ahyehyɛ no ma ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Ɔde sikakɔkɔɔ akoradeɛ bi a ɛkari gram ɔha ne dunan (114) a wɔde aduhwam ahyɛ no ma nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Ɔde nantwie ba, odwennini ne odwammaa a wadi afe baeɛ sɛ ɔhyeɛ afɔdeɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ɔpapo sɛ bɔne ho afɔdeɛ ");
INSERT INTO twiasante_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ne anantwie mmienu, nnwennini enum, mpapo enum ne nnwammaa enum a wɔn mu biara adi afe sɛ asomdwoeɛ afɔdeɛ. Yei ne afɔdeɛ a Suar babarima Netanel de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ne nnansa so no, Helon babarima Eliab a ɔda Sebulon abusuakuo ano no de nʼafɔrebɔdeɛ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Na nʼafɔrebɔdeɛ no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ kyɛnsee a emu duru yɛ kilogram baako. Na wɔde atokoɔ afɔrebɔdeɛ a ɛyɛ asikyiresiam a wɔayam no muhumuhu a wɔde ngo afra ahyɛ no ma ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Ɔde sikakɔkɔɔ akoradeɛ a emu duru yɛ gram ɔha ne dunan (114) a wɔde aduhwam ahyɛ ma nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Ɔde nantwie ba, odwennini ne odwammaa a wadi afe baeɛ sɛ ɔhyeɛ afɔdeɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ɔpapo sɛ bɔne ho afɔdeɛ; ");
INSERT INTO twiasante_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ne anantwie mmienu, nnwennini enum ne mmirekyinini enum sɛ asomdwoeɛ afɔdeɛ. Yei ne afɔdeɛ a Helon babarima Eliab de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ne nnanan so no, Sedeur babarima Elisur a ɔda Ruben abusuakuo ano no de nʼafɔrebɔdeɛ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Na nʼafɔrebɔdeɛ no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ kyɛnsee a emu duru yɛ kilogram baako a wɔde afɔrebɔdeɛ a ɛyɛ asikyiresiam a wɔayam no muhumuhu a wɔde ngo afra ahyɛ no ma ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Afei, ɔde sikakɔkɔɔ akoradeɛ a emu duru yɛ gram ɔha ne dunan (114) a wɔde aduhwam ahyɛ no ma nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Ɔde nantwie ba, odwennini ne odwammaanini a wadi afe baeɛ sɛ ɔhyeɛ afɔdeɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ɔpapo sɛ bɔne ho afɔdeɛ; ");
INSERT INTO twiasante_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ne anantwie mmienu, nnwennini enum, mpapo enum ne nnwammaa enum a wɔn mu biara adi afe. Yei ne afɔdeɛ a Sedeur babarima Elisur de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ne nnanum so no, Surisadai babarima Selumiel a ɔda Simeon abusuakuo ano no de nʼafɔrebɔdeɛ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Na nʼafɔrebɔdeɛ no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ kyɛnsee a emu duru yɛ kilogram baako na wɔde atokoɔ afɔrebɔdeɛ a ɛyɛ asikyiresiam a wɔayam no muhumuhu a wɔde ngo afra ahyɛ no ma ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Afei, ɔde sikakɔkɔɔ akoradeɛ a emu duru bɛyɛ gram ɔha ne dunan (114) a wɔde aduhwam ahyɛ no ma nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Ɔde nantwie ba, odwennini ne odwammaanini a wɔadi afe baeɛ sɛ ɔhyeɛ afɔdeɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ɔpapo sɛ bɔne ho afɔdeɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ne anantwie mmienu, nnwennini enum, mmirekyinini enum ne nnwammaa enum a wɔn mu biara adi afe sɛ asomdwoeɛ afɔdeɛ. Yei ne afɔdeɛ a Surisadai ba Selumiel de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ne nna nsia so no, Deguel babarima Eliasaf a ɔda Gad abusuakuo ano no de nʼafɔrebɔdeɛ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Na nʼafɔrebɔdeɛ no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ kyɛnsee a emu duru yɛ kilogram baako. Na wɔde atokoɔ afɔrebɔdeɛ a ɛyɛ asikyiresiam muhumuhu a wɔde ngo afra ahyehyɛ no ma ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Ɔde sikakɔkɔɔ akoradeɛ bi a ɛkari gram ɔha ne dunan (114) wɔde aduhwam ahyɛ no ma nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Ɔde nantwie ba, odwennini ne odwammaa a wadi afe baeɛ sɛ ɔhyeɛ afɔdeɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ɔpapo sɛ bɔne ho afɔdeɛ; ");
INSERT INTO twiasante_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ne nantwie mmienu, nnwennini enum, mpapo enum ne nnwammaa enum a wɔn mu biara adi afe sɛ asomdwoeɛ afɔdeɛ. Yei ne afɔdeɛ a Deguel ba Eliasaf de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ne nnanson so no, Amihud babarima Elisama a ɔda Efraim abusuakuo ano no de nʼafɔrebɔdeɛ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Na nʼafɔrebɔdeɛ no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ kyɛnsee a emu duru yɛ kilogram baako. Na wɔde atokoɔ afɔrebɔdeɛ a ɛyɛ asikyiresiam muhumuhu a wɔde ngo afra ahyehyɛ no ma ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Ɔde sikakɔkɔɔ akoradeɛ bi a ɛkari gram ɔha ne dunan (114) a wɔde aduhwam ahyɛ no ma nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Ɔde nantwie ba, odwennini ne odwammaa a wadi afe baeɛ sɛ ɔhyeɛ afɔdeɛ; ");
INSERT INTO twiasante_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ɔpapo sɛ bɔne ho afɔdeɛ; ");
INSERT INTO twiasante_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ne nantwie mmienu, nnwennini enum, mpapo enum ne nnwammaa enum a wɔn mu biara adi afe sɛ asomdwoeɛ afɔdeɛ. Yei ne afɔdeɛ a Amihud babarima Elisama de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ne nnawɔtwe so no, Pedahsur babarima Gamaliel a ɔda Manase abusuakuo ano no de nʼafɔrebɔdeɛ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Na nʼafɔrebɔdeɛ no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ kyɛnsee a emu duru yɛ kilogram baako. Na wɔde atokoɔ afɔrebɔdeɛ a ɛyɛ asikyiresiam muhumuhu a wɔde ngo afra ahyehyɛ no ma ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Ɔde sikakɔkɔɔ akoradeɛ bi a ɛkari gram ɔha ne dunan (114) a wɔde aduhwam ahyɛ no ma nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Ɔde nantwie ba, odwennini ne odwammaa a wadi afe baeɛ sɛ ɔhyeɛ afɔdeɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ɔpapo sɛ bɔne ho afɔdeɛ; ");
INSERT INTO twiasante_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ne nantwie mmienu, nnwennini enum, mpɔnkyenini enum ne nnwammaa enum a wɔn mu biara adi afe sɛ asomdwoeɛ afɔdeɛ. Yei ne afɔdeɛ a Pedahsur ba Gamaliel de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ne nna nkron so no, Gideoni babarima Abidan a ɔda Benyamin abusuakuo ano no de nʼafɔrebɔdeɛ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Na nʼafɔrebɔdeɛ no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ kyɛnsee a emu duru yɛ kilogram baako. Na wɔde atokoɔ afɔrebɔdeɛ a ɛyɛ asikyiresiam muhumuhu a wɔde ngo afra ahyehyɛ no ma ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Ɔde sikakɔkɔɔ akoradeɛ bi a ɛkari gram ɔha ne dunan (114) a wɔde aduhwam ahyɛ no ma nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Ɔde nantwie ba, odwennini ne odwammaa a wadi afe baeɛ sɛ ɔhyeɛ afɔdeɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ɔpapo sɛ bɔne ho afɔdeɛ ");
INSERT INTO twiasante_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ne anantwie mmienu, nnwennini enum, mpapo enum ne nnwammaa enum a wɔn mu biara adi afe sɛ asomdwoeɛ afɔdeɛ. Yei ne afɔdeɛ a Gideoni babarima Abidan de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ne dadu so no, Amisadai babarima Ahieser a ɔda Dan abusuakuo ano no de nʼafɔrebɔdeɛ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Na nʼafɔrebɔdeɛ no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ kyɛnsee a emu duru yɛ kilogram baako. Na wɔde atokoɔ afɔrebɔdeɛ a ɛyɛ asikyiresiam a wɔayam no muhumuhu a wɔde ngo afra ahyehyɛ no ma ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Afei, ɔde sikakɔkɔɔ akoradeɛ a ɛkari gram ɔha ne dunan (114) a wɔde aduhwam ahyɛ no ma nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Ɔde nantwie ba, odwennini ne odwammaanini a wadi afe baeɛ sɛ ɔhyeɛ afɔdeɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ɔpapo sɛ bɔne ho afɔdeɛ; ");
INSERT INTO twiasante_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ne anantwie mmienu, nnwennini enum, mmirekyinini enum ne nnwammaa enum a wɔn mu biara adi afe sɛ asomdwoeɛ afɔdeɛ. Yei ne afɔdeɛ a Amisadai babarima Ahieser de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ne dadu da baako so no, Okran babarima Pagiel a ɔda Aser abusuakuo ano no de nʼafɔrebɔdeɛ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Na nʼafɔrebɔdeɛ no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ kyɛnsee a emu duru yɛ kilogram baako. Na wɔde atokoɔ afɔrebɔdeɛ a ɛyɛ asikyiresiam a wɔayam no muhumuhu a wɔde ngo afra ahyehyɛ no ma ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Afei, ɔde sikakɔkɔɔ akoradeɛ a ɛkari gram ɔha ne dunan (114) a wɔde aduhwam ahyɛ no ma nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Ɔde nantwie ba, odwennini ne odwammaanini a wadi afe baeɛ sɛ ɔhyeɛ afɔdeɛ; ");
INSERT INTO twiasante_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ɔpapo sɛ bɔne ho afɔdeɛ; ");
INSERT INTO twiasante_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ne anantwie mmienu, nnwennini enum, mmirekyinini enum ne nnwammaa enum a wɔn mu biara adi afe sɛ asomdwoeɛ afɔdeɛ. Yei ne afɔdeɛ a Okran babarima Pagiel de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ne dadu nna mmienu so no, Enan babarima Ahira a ɔda Naftali abusuakuo ano no de nʼafɔrebɔdeɛ baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Na nʼafɔrebɔdeɛ no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ kyɛnsee a emu duru yɛ kilogram baako. Na wɔde atokoɔ afɔrebɔdeɛ a ɛyɛ asikyiresiam a wɔayam no muhumuhu a wɔde ngo afra ahyehyɛ no ma ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Afei, ɔde sikakɔkɔɔ akoradeɛ a ɛkari gram ɔha ne dunan (114) a wɔde aduhwam ahyɛ no ma nso baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Ɔde nantwie ba, odwennini ne odwammaanini a wadi afe baeɛ sɛ ɔhyeɛ afɔdeɛ; ");
INSERT INTO twiasante_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ɔpapo sɛ bɔne ho afɔdeɛ; ");
INSERT INTO twiasante_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ne anantwie mmienu, nnwennini enum, mpapo enum ne nnwammaa enum a wɔn mu biara adi afe sɛ asomdwoeɛ afɔdeɛ. Yei ne afɔdeɛ a Enan babarima Ahira de baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Enti, yei ne afɔrebukyia no afɔrebɔdeɛ a Israel mpanimfoɔ de ba bɛsraa afɔrebukyia no nam so bɔɔ no atenaseɛ: dwetɛ mprɛte dumienu, dwetɛ hweaseammɔ dumienu ne sikakɔkɔɔ aduhwam akoradeɛ dumienu. ");
INSERT INTO twiasante_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ne nyinaa mu, na dwetɛ nneɛma no nyinaa kari bɛyɛ kilogram aduasa. Na prɛte biara kari kilogram baako ne fa, na dwetɛ kyɛnsee no nso kari kilogram baako. ");
INSERT INTO twiasante_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Sikakɔkɔɔ a wɔde bɛkyɛeɛ no mu duru yɛɛ bɛyɛ kilogram baako ne fa a ɛkyerɛ sɛ, sikakɔkɔɔ no akoradeɛ no mu biara duru yɛ nnwetɛbena edu a wɔde aduhwam ahyɛ no ma. ");
INSERT INTO twiasante_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Wɔde anantwie dumienu ne nnwennini a wɔn mu biara adi afe na wɔde bɛbɔɔ ɔhyeɛ afɔdeɛ no a atokoɔ afɔrebɔ nso ka ho. Wɔde mpapo bɛbɔɔ bɔne ho afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Asomdwoeɛ afɔdeɛ nneɛma a wɔde baeɛ nie: anantwinini mma aduonu ɛnan, nnwennini aduosia, mmirekyie aduosia, nnwammaanini a wɔn mu biara adi afe aduosia. ");
INSERT INTO twiasante_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ɛberɛ a Mose kɔɔ Ahyiaeɛ Ntomadan no mu sɛ ɔne Awurade rekɔkasa no, ɔtee nne bi firi soro a ɛrekasa kyerɛ no firi Mpata Beaeɛ no atifi hɔ, wɔ adaka no ho baabi a Kerubim mmienu no sisi no ntam. ");
INSERT INTO twiasante_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Ka kyerɛ Aaron sɛ, sɛ ɔsɔ nkanea nson a ɛwɔ kaneadua no so no a, ɔnsɔ no sɛdeɛ ɛbɛyɛ a, ɛbɛto ne hann no akɔ nʼanim.” ");
INSERT INTO twiasante_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Enti, Aaron yɛɛ saa. ");
INSERT INTO twiasante_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Kaneadua no ne nhwiren a wɔde asiesie nʼase ne ne mman no nyinaa, sikakɔkɔɔ a wɔaboro na wɔde yɛeɛ. Wɔyɛɛ no sɛdeɛ Awurade kyerɛɛ Mose sɛ wɔnyɛ no no. ");
INSERT INTO twiasante_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Yi Lewifoɔ no firi Israelfoɔ no mu na te wɔn ho. ");
INSERT INTO twiasante_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Fa ahodwira nsuo pete wɔn so. Ma wɔnyi wɔn ho nwi nyinaa, na wɔnsi wɔn nneɛma nyinaa, afei wɔn ho bɛte. ");
INSERT INTO twiasante_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Afei, ma wɔmfa nantwinini ba ne aduane afɔrebɔdeɛ a ɛyɛ asikyiresiam a wɔayam no muhumuhu a wɔde ngo afra a nantwinini ba baako ka ho a wɔde no bɛbɔ bɔne ho afɔdeɛ mmra. ");
INSERT INTO twiasante_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Afei, frɛ Israelfoɔ no nyinaa hyia na fa Lewifoɔ no bra Ahyiaeɛ Ntomadan no ɛpono ano. ");
INSERT INTO twiasante_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ɛhɔ, wɔ Awurade anim, mpanimfoɔ a wɔtuatua mmusuakuo no ano no de wɔn nsa bɛgu wɔn so ");
INSERT INTO twiasante_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","na Aaron ayɛ nsɛnkyerɛnneɛ bi sɛ ɔde wɔn rema Awurade sɛ akyɛdeɛ a ɛfiri Israel manfoɔ nyinaa nkyɛn. Lewifoɔ bɛsi nnipa no nyinaa anan asom Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Afei, Lewifoɔ mpanimfoɔ no de wɔn nsa bɛgu nantwie mma no apampam na wɔde wɔn ama Awurade. Wɔde baako bɛbɔ bɔne ho afɔdeɛ na wɔde baako nso abɔ ɔhyeɛ afɔdeɛ de ayɛ mpatadeɛ ama Lewifoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Afei, wɔde Lewifoɔ no bɛma Aaron ne ne mma te sɛ deɛ wɔde afɔrebɔdeɛ biara fa asɔfoɔ so de ma Awurade no. ");
INSERT INTO twiasante_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Monam saa ɛkwan yi so bɛyi Lewifoɔ no afiri Israelfoɔ no mu ama me, na wɔayɛ me dea. ");
INSERT INTO twiasante_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Sɛ mote wɔn ho na mofa saa ɛkwan yi so de wɔn ma me a, afei, wɔbɛdi ahyɛnfirie wɔ Ahyiaeɛ Ntomadan no mu, adi wɔn dwuma. ");
INSERT INTO twiasante_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Israelfoɔ mu nyinaa, wɔn na wɔyɛ me nkurɔfoɔ, na magye wɔn atom asi Israelfoɔ mmakan nyinaa anan. Mafa Lewifoɔ no sɛ wɔn ananmusifoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ɛfiri sɛ, Israelfoɔ mmakan nyinaa yɛ me dea—nnipa ne mmoa nyinaa. Anadwo a mekumm Misraimfoɔ mmakan nyinaa no ara na mefaa wɔn de wɔn yɛɛ me nkurɔfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Mafa Lewifoɔ no asi Israelfoɔ mmakan nyinaa anan mu. ");
INSERT INTO twiasante_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Na mede Lewifoɔ no bɛkyɛ Aaron ne ne mmammarima. Lewifoɔ no na wɔbɛyɛ Ahyiaeɛ Ntomadan no mu nnwuma kronkron a anka ɛsɛ sɛ Israelfoɔ no na wɔyɛ, na wɔn na wɔbɛbɔ afɔdeɛ ama nkurɔfoɔ de ayɛ mpatadeɛ ama wɔn. Ɔyaredɔm biara renka Israelfoɔ no, nanso sɛ nnipa afoforɔ biara kɔ Ahyiaeɛ Ntomadan no mu a, wɔbɛyareyare.” ");
INSERT INTO twiasante_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Enti, Mose ne Aaron ne Israelfoɔ no nyinaa faa ɛkwan a Awurade kyerɛɛ Mose no so pɛpɛɛpɛ de Lewifoɔ no maa Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lewifoɔ no dwiraa wɔn ho, sii wɔn nneɛma ɛnna Aaron de wɔn hyɛɛ Awurade nsa. Ɔyɛɛ wɔn ho mpatadwuma de tee wɔn ho. ");
INSERT INTO twiasante_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ɛno akyi, wɔkɔɔ Ahyiaeɛ Ntomadan no mu sɛ Aaron ne ne mmammarima aboafoɔ. Wɔyɛɛ biribiara sɛdeɛ Awurade hyɛɛ Mose sɛ wɔnyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Sɛ Lewini biara di mfeɛ aduonu enum a, ma no mfiri aseɛ nsom wɔ Ahyiaeɛ Ntomadan mu, ");
INSERT INTO twiasante_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","na wɔdi mfeɛ aduonum a, wɔapɔn wɔn ho. ");
INSERT INTO twiasante_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Sɛ wɔpɔn wɔn ho a, wɔtumi di dwuma nketenkete wɔ Ahyiaeɛ Ntomadan mu hɔ. Wɔrenyɛ nnwuma a daa ɛbɛgye wɔn berɛ.” ");
INSERT INTO twiasante_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Bosome a ɛdi ɛkan no mu afe a ɛtɔ so mmienu no mu a wɔafiri Misraim no na Awurade kaa saa asɛm yi kyerɛɛ Mose ɛberɛ a ɔne Israelfoɔ wɔ Sinai ɛserɛ no so no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Ɛsɛ sɛ afe biara mu bosome a ɛdi ɛkan no dadu nna ɛnan no, Israelfoɔ di Twam Afahyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ɛsɛ sɛ wɔhyɛ afahyɛ no ase owiatɔberɛ. Ɛsɛ sɛ modi mmara biara a ɛfa saa afahyɛ yi die ho so.” ");
INSERT INTO twiasante_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Enti Mose kaa sɛ, wɔbɛhyɛ Twam Afahyɛ no die ase ɛda a ɛtɔ so dunan no anwummerɛ ");
INSERT INTO twiasante_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","wɔ Sinai asase pɔ no so sɛdeɛ Awurade ahyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Na asɛm a ɛsiiɛ ne sɛ, afei na na nnipa no bi firi ayie aba enti, ɛsiane sɛ wɔde wɔn ho aka owufoɔ enti, na wɔn ho agu fi. Yei enti anadwo no, wɔantumi anwe Twam Afahyɛ dwammaa no bi. Wɔbaa Mose ne Aaron nkyɛn ");
INSERT INTO twiasante_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","bɛkyerɛkyerɛɛ nsɛm a ɛha wɔn mu kyerɛɛ wɔn. Wobisaa sɛ, “Yɛde yɛn ho aka funu, nanso ɛdeɛn enti na yɛne Israelfoɔ nyinaa rentumi mfa yɛn afɔrebɔdeɛ mmrɛ Awurade sɛdeɛ nhyehyɛeɛ no teɛ no?” ");
INSERT INTO twiasante_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mose kaa sɛ ɔbɛbisa Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ɔbisaa Awurade no, mmuaeɛ a ɔnyaeɛ nie: ");
INSERT INTO twiasante_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Israelni biara a ɔbɛsɔ efunu mu, sɛ ɔyɛ nnɛmma anaa ɔfiri awoɔ ntoatoasoɔ a ɛreba no mu no, sɛ ɛyɛ Twam Afahyɛberɛ a, ne ho agu fi, ɛfiri sɛ, wasɔ efunu mu. Sɛ wɔnam akwantuo mu enti wɔantumi amma a, wɔtumi di Awurade Twam Afahyɛ no bosome akyi; ");
INSERT INTO twiasante_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","bosome a ɛtɔ so mmienu no ɛda a ɛtɔ so dunan no anwummerɛ na ɛsɛ sɛ wɔhyɛ aseɛ. Saa ɛberɛ no na ɛsɛ sɛ wɔwe odwammaa no a burodo a mmɔreka nni mu ka ho a ahahan nwononwono bi ka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ɛnsɛ sɛ wɔgya bi ma adeɛ kye so. Ɛnsɛ sɛ wɔbɔ ne dompe mu. Na ɛsɛ sɛ wɔdi Twam Afahyɛ no mmara no nyinaa so pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Nanso obiara a ne ho nguu fi anaa obi a ɔntuu kwan no nanso wanni Twam Afahyɛ no wɔ ne berɛ ano no, wɔbɛtwa no asuo afiri Israelfoɔ no mu, ɛfiri sɛ, ɔboa pa sɛ ɔremmɔ afɔdeɛ mma Awurade ɛberɛ a ɛsɛ mu, enti ɛsɛ sɛ ɛho afɔdie ba ne so. ");
INSERT INTO twiasante_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Sɛ ɔhɔhoɔ bi fra mo mu na ɔpɛ sɛ ɔdi Twam Afahyɛ no bi de hyɛ Awurade animuonyam a, ɛsɛ sɛ ɔdi mmara korɔ no ara so. Mmara baako na ɛwɔ hɔ ma mo nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ɛda a wɔmaa Ahyiaeɛ Ntomadan no so sii hɔ no, omununkum kataa so. Anwummerɛ no ara, omununkum no dane yɛɛ sɛ ogya na ɛyɛɛ saa ara anadwo mu no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Saa ara na ɛte ɛberɛ biara, na ɛduru anadwo a, omununkum no dane yɛ sɛ ogya. ");
INSERT INTO twiasante_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Omununkum no maa ne ho so no, Israelfoɔ no dii akyire kɔsii baabiara a ɛkɔ kɔgyinaeɛ ma wɔbɔɔ hɔ atenaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Yei kyerɛ sɛ, sɛ Awurade ka sɛ wɔnkɔ a, wɔkɔ, na sɛ ɔka sɛ wɔnnyina a, wɔgyina. Na sɛ Omununkum no gyina a, wɔn nso gyina kɔsi mmerɛ dodoɔ a ɛgyina hɔ no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Sɛ ɛgyina baabi kyɛ a, wɔn nso gyina hɔ kyɛ. Na sɛ ɛgyina hɔ nna kakra bi a, wɔn nso gyina hɔ nna kakra bi saa ara, ɛfiri sɛ, saa na Awurade ahyɛ wɔn sɛ wɔnyɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ɛtɔ da bi a, omununkum no tena Ahyiaeɛ Ntomadan no so nna kakraa bi. Sɛ ɛba saa a, nnipa no nso tena nna kakraa bi. Na Awurade nhyɛ mu, wɔtu firii wɔn atenaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ɛtɔ da bi nso a, omununkum no tena anadwo na akɔ adekyeeɛ. Nanso sɛ ɛyɛ awia anaa anadwo na omununkum no ma ne ho so a, nnipa no tu fi atenaeɛ hɔ di akyi. ");
INSERT INTO twiasante_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Sɛ omununkum no ba Ahyiaeɛ Ntomadan no atifi na ɛdi nnanu, bosome anaa afe a, saa nna no ara so na Israelfoɔ no hwɛ de tena hɔ. Nanso ɛnya tu ara pɛ, na wɔn nso atu. ");
INSERT INTO twiasante_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Yei kyerɛ sɛ, wɔn atenaseɛbɔ ne wɔn akwantuo nyinaa gyina Awurade mmara a ɔhyɛ ma wɔn so; na biribiara a Awurade ka kyerɛɛ Mose sɛ wɔnyɛ no, wɔyɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Fa dwetɛ a wɔaboro yɛ ntotorobɛnto mmienu na wɔahyɛn de afrɛ nnipa no, na watu ntomadan no akɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Sɛ wɔhyɛn ntotorobɛnto mmienu no a, nnipa no bɛhunu sɛ, ɛsɛ sɛ wɔboa wɔn ho ano wɔ Ahyiaeɛ Ntomadan no ano. ");
INSERT INTO twiasante_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Na sɛ wɔhyɛn baako pɛ a, na ɛkyerɛ sɛ Israel mmusua no mu mpanimfoɔ na ɛsɛ sɛ wɔba wo nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Sɛ mohyɛn de kyerɛ sɛ monkɔ mo anim a, mmusuakuo a wɔwɔ Ahyiaeɛ Ntomadan apueeɛ fam no bɛtu wɔn atenaeɛ hɔ na wɔakɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Sɛ mohyɛn deɛ ɛtɔ so mmienu no a, mmusuakuo a wɔwɔ anafoɔ fam no bɛdi so. Monhyɛn no ntiantia mu mfa nkyerɛ sɛ wɔnkɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Na sɛ mofrɛ nnipa no ma wɔbɛhyia a, momfa ɛkwan foforɔ so nhyɛne ntotorobɛnto no. ");
INSERT INTO twiasante_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Aaron mmammarima asɔfoɔ nko ara na wɔbɛma wɔn ɛkwan ama wɔahyɛn ntotorobɛnto no. Yei yɛ mmara a ɛbɛtena hɔ daa afiri awoɔ ntoatoasoɔ so akɔsi awoɔ ntoatoasoɔ so. ");
INSERT INTO twiasante_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Sɛ moduru Bɔhyɛ Asase no so na mo ne mo atamfoɔ ko na mohyɛn ntotorobɛnto no a, Awurade, mo Onyankopɔn bɛtie mo na wagye mo afiri mo atamfoɔ nsam. ");
INSERT INTO twiasante_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Anigyeberɛ mu nso, monhyɛn ntotorobɛnto no. Afe mu dapɔnna nso, monhyɛn. Bosome biara ahyɛaseɛ nso, monhyɛ mfa nnye mo ani wɔ ɔhyeɛ afɔdeɛ ne asomdwoeɛ afɔdeɛ ho. Sɛ moyɛ saa a, ɛbɛkae Onyankopɔn apam a ɔne mo apam no. Na mene Awurade mo Onyankopɔn.” ");
INSERT INTO twiasante_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Bosome a ɛtɔ so mmienu no ɛda a ɛtɔ so aduonu no a ɛyɛ mfeɛ mmienu a Israelfoɔ firii Misraim no, omununkum no pagyaa ne ho firii Ahyiaeɛ Ntomadan no so, ");
INSERT INTO twiasante_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","enti Israelfoɔ no firii Sinai ɛserɛ so hɔ dii omununkum no akyi kɔsii sɛ ɛkɔgyinaa Paran ɛserɛ so. ");
INSERT INTO twiasante_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ɛberɛ a ɛsɛ sɛ wɔtu no duruiɛ no, Awurade nam Mose so ka kyerɛɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Akwantuo no mu no, mmusua a wɔhyɛ Yuda abusuakuo no ase, a Aminadab babarima Nahson tua ano na ɔtu wɔn frankaa na wɔdi ɛkan. ");
INSERT INTO twiasante_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Wɔn a wɔdi so ne Isakar abusuakuo a Suar babarima Netanel na ɔdi wɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Sebulon abusuakuo na wɔdi hɔ a Helon babarima Eliab na ɔdi wɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Wɔtutuu Ahyiaeɛ Ntomadan no, na Gerson ne Merari mmusua a wɔfiri Lewifoɔ mu no soaa Ahyiaeɛ Ntomadan no dii wɔn afa wɔ santen no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Afei, Ruben abusuakuo tuu wɔn frankaa de dii so a Sedeur babarima Elisur na na ɔdi wɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Wɔn a na wɔdi so ne Simeon abusuakuo a Surisadai babarima Selumiel na na ɔdi wɔn anim; ");
INSERT INTO twiasante_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gad abusuakuo nso, na Deguel babarima Eliasaf na na ɔdi wɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ɛnna Kohatfoɔ no nso na na wɔdi hɔ a wɔsoso kronkronbea hɔ nneɛma. Wɔduruu hɔ no, na wɔahyehyɛ Ahyiaeɛ Ntomadan no wɔ beaeɛ foforɔ hɔ dada. ");
INSERT INTO twiasante_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Wɔn a na wɔdi so ne Efraim abusuakuo a na wɔdi wɔn frankaa akyi a Amihud babarima Elisama na ɔdi wɔn anim; ");
INSERT INTO twiasante_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ɛnna wɔn a na wɔdi so ne Manase abusuakuo a Pedahsur babarima Gamaliel na na ɔdi wɔn anim; ");
INSERT INTO twiasante_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","afei, Benyamin abusuakuo na na wɔdi so a Gideoni babarima Abidan na na ɔdi wɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Wɔn a na wɔtwa toɔ koraa no ne abusuakuo a na Dan abusuakuo frankaa di wɔn anim a na wɔn panin ne Amisadai babarima Ahieser no. ");
INSERT INTO twiasante_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Okran babarima Pagiel na na ɔdi Aser abusuakuo anim. ");
INSERT INTO twiasante_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ɛnna na Enan babarima Ahira nso di Naftali abusuakuo anim. ");
INSERT INTO twiasante_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Saa nhyehyɛeɛ yi na mmusuakuo yi faa so tuu wɔn kwan no. ");
INSERT INTO twiasante_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ɛda bi, Mose ka kyerɛɛ nʼakonta Hobab, Midiani Reuel ba sɛ, “Yei nyinaa akyi no, yɛrekɔ Bɔhyɛ Asase no so. Bra na yɛnkɔ na yɛbɛhwɛ wo so yie; ɛfiri sɛ, Awurade ahyɛ Israelfoɔ bɔ a emu yɛ den!” ");
INSERT INTO twiasante_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Nanso nʼakonta no buaa no sɛ, “Dabi, ɛsɛ sɛ mekɔ mʼasase so ne mʼabusuafoɔ nkyɛn.” ");
INSERT INTO twiasante_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mose srɛɛ sɛ, “Tena yɛn nkyɛn, ɛfiri sɛ, wo na wonim sɛdeɛ ɛserɛ so asetena teɛ enti wo ho bɛba mfasoɔ ama yɛn. ");
INSERT INTO twiasante_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Sɛ woba a, nneɛma pa a Awurade de bɛma yɛn no nyinaa, wobɛnya bi.” ");
INSERT INTO twiasante_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Wɔfiri Awurade Bepɔ so no, wɔnantee nnansa a Awurade Adaka no di wɔn anim sɛ wɔrekɔpɛ baabi a wɔbɛsoeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Wɔfirii wɔn akwantuo no ase awia a wɔrekɔ no nyinaa na Awurade omununkum no di wɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Wɔmaa adaka no so kɔɔ wɔn anim kakra no, Mose teaam sɛ, “Ao, Awurade, sɔre! Na hwete wʼatamfoɔ; ma wɔn nyinaa nnwane mfiri wʼanim.” ");
INSERT INTO twiasante_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Wɔsoɛɛ adaka no, ɔkaa sɛ, “Ao, Awurade, sane bra Israelfoɔ ɔpepe no mu.” ");
INSERT INTO twiasante_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ankyɛre biara na nnipa no firii aseɛ nwiinwii sɛ nneɛma nkɔ yie mma wɔn, na Awurade teeɛ. Nʼabufuhyeɛ kɔɔ wɔn so wɔ wɔn anwiinwii no ho. Yei enti, Awurade maa ogya bɛhyee beaeɛ a na wɔte hɔ no mfikyire. ");
INSERT INTO twiasante_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Wɔteateaam frɛɛ Mose sɛ ɔmmɛgye wɔn. Mose bɔɔ mpaeɛ srɛɛ Awurade maa wɔn na ogya no dumiiɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ɛfiri saa ɛberɛ no, wɔtoo beaeɛ hɔ edin sɛ Tabera a asekyerɛ ne “Ahyeɛ”, ɛfiri sɛ, ogya a ɛfiri Awurade nkyɛn no hyee wɔn atenaeɛ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Misraimfoɔ a na wɔwɔ wɔn ntam no kɔn dɔɔ nneɛma pa a na ɛwɔ Misraim no. Yei amma Israelfoɔ no ani ansɔ baabi a na wɔwɔ hɔ no, enti wɔsuu sɛ, “Hwan na ɔbɛma yɛn aduane adi? ");
INSERT INTO twiasante_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ɛberɛ a na yɛwɔ Misraim no, na yɛnya ɛnam ne nsuomnam we. Saa ara nso na na yɛnya kokumba, ɛferɛ, gyeene ne galik nso die. ");
INSERT INTO twiasante_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Nanso, seesei deɛ, yɛn ahoɔden so ate na ɛda biara yɛnnya biribiara sɛ mana nko ara.” ");
INSERT INTO twiasante_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Na mana no kɛseɛ te sɛ wisa aba na ɛsɛ ɛhyɛ a awaawae firi dubona ho agu fam. ");
INSERT INTO twiasante_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Nnipa no tasee firi fam na wɔayam anaa wɔasi no waduro mu ama adane esiam. Wɔwie a, wɔnoa de bi yɛ taterɛ. Woka wʼano a, ɛte sɛ taterɛ a wɔakye wɔ nhahamma ngo mu. ");
INSERT INTO twiasante_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Anadwo bosuo mu na mana no tɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mose tee sɛ mmusuakuo no nyinaa gyinagyina, atwa wɔn ntomadan ho ahyia resu. Yei hyɛɛ Awurade abufuo yie. Na anyɛ Mose nso abodwo koraa. ");
INSERT INTO twiasante_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Mose bisaa Awurade sɛ, “Adɛn enti na woyɛ me saa na wode saa nnipa a wɔte seyie yi nyinaa adesoa abɛsoa me? ");
INSERT INTO twiasante_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Wɔyɛ me mma anaasɛ me nso meyɛ wɔn agya? Yei enti na wode wɔn ama me sɛ menhwɛ wɔn sɛ nkɔkoaa kɔsi sɛ yɛbɛduru asase a wohyɛɛ wɔn agyanom ho bɔ no? ");
INSERT INTO twiasante_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ɛhefa na merekɔfa ɛnam abrɛ nnipa yi? Wɔsu kyerɛ me sɛ, ‘Ma yɛn ɛnam!’ ");
INSERT INTO twiasante_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mʼankasa merentumi nsoa ɔman yi! Adesoa no mu yɛ duru ma me dodo! ");
INSERT INTO twiasante_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Na sɛ saa na wo ne me bɛdi no deɛ a, mesrɛ, kum me seesei ara; ɛbɛyɛ adom ama me! Yi me firi saa ahokyere yi mu!” ");
INSERT INTO twiasante_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Awurade ka kyerɛɛ Mose sɛ, “Frɛ Israelfoɔ mpanimfoɔ no mu aduɔson ma me; fa wɔn bra Ahyiaeɛ Ntomadan no mu na wo ne wɔn nnyina hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Mɛba hɔ na me ne wo abɛkasa na honhom a ɛwɔ wo so no, mɛfa na mede akɔgu wɔn nso so bi; ɛba saa a, wɔne wo bɛsoa nnipa no adesoa sɛdeɛ ɛrenyɛ wo nko ara wʼadesoa. ");
INSERT INTO twiasante_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Ka kyerɛ nnipa no na wɔnnwira wɔn ho na ɔkyena, wɔbɛnya ɛnam awe. Ka kyerɛ wɔn sɛ, ‘Awurade ate mo sufrɛ a ɛfa nneɛma a mogyaa no Misraim no ho na ɔrebɛma mo ɛnam. Mobɛwe; ");
INSERT INTO twiasante_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ɛnyɛ ɛda koro anaa nnanu anaa nnanum anaa dadu anaa adaduonu! ");
INSERT INTO twiasante_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Na bosome baako mu, mobɛwe ɛnam ara ma apuro mo ama afa mo hwene mu. Ɛfiri sɛ, moapo Awurade a ɔka mo ho wɔ ha no, na moasu ama Misraim nso.’ ” ");
INSERT INTO twiasante_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mose kaa sɛ, “Mmarima nko ara mpem ahansia na wɔwɔ ha, ɛnna woahyɛ wɔn bɔ sɛ wobɛma wɔn ɛnam awe ara bosome! ");
INSERT INTO twiasante_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Sɛ yɛkum yɛn nnwan ne yɛn anantwie nyinaa koraa a, ɛrenso wɔn so. Ɛsɛ sɛ yɛkyere ɛpo mu ɛnam nyinaa ansa na yɛatumi adi wo bɔhyɛ no so!” ");
INSERT INTO twiasante_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Na Awurade bisaa Mose sɛ, “Da bɛn na meyɛɛ mmerɛ? Afei wobɛhunu sɛ mʼasɛm yɛ nokorɛ anaa ɛnyɛ nokorɛ.” ");
INSERT INTO twiasante_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Enti Mose firii Ahyiaeɛ Ntomadan no mu hɔ kɔkaa nsɛm a Awurade ka kyerɛɛ no no nyinaa kyerɛɛ nnipa no. Ɔboaboaa mpanimfoɔ aduɔson ano ma wɔtwaa Ahyiaeɛ Ntomadan no ho hyiaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Na Awurade nam omununkum mu baa fam ne Mose kasaeɛ, na ɔfaa honhom a ɛwɔ Mose so no de guu mpanimfoɔ aduɔson no so. Ɛberɛ a honhom no baa wɔn so kakra no, wɔhyɛɛ nkɔm mmerɛ tiawa bi mu. ");
INSERT INTO twiasante_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Nanso na mpanimfoɔ aduɔson no mu baanu a wɔfrɛ wɔn Eldad ne Medad da so wɔ wɔn atenaeɛ hɔ. Na mmerɛ a honhom no baa wɔn so wɔ hɔ no, wɔhyɛɛ nkɔm wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mmeranteɛ bi tuu mmirika kɔbɔɔ Mose asɛm a asie no ho amaneɛ ");
INSERT INTO twiasante_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","na Nun babarima Yosua a na wɔayi no sɛ ɔnyɛ Mose ɔboafoɔ no ampene so, na ɔkaa sɛ, “Owura, ma wɔnnyae!” ");
INSERT INTO twiasante_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mose bisaa no sɛ, “Me ho na woretwe ninkunu yi? Ɛkaa me nko a, na anka Awurade nkurɔfoɔ nyinaa yɛ adiyifoɔ a Awurade de ne honhom agu wɔn nyinaa so!” ");
INSERT INTO twiasante_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Afei, Mose ne Israel mpanimfoɔ no sane kɔɔ wɔn atenaeɛ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Awurade bɔɔ ahum maa ɛde mmoko firi ɛpo mu bɛguu atenaeɛ hɔ ne ɛho mmaa nyinaa. Baabiara a obi bɛfa no, na nnomaa yi bi atu nenam asase ani bɛyɛ anammɔn ɛnan. ");
INSERT INTO twiasante_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Enti ɛda mu no nyinaa, nnipa kyekyeree mmoko no bi kunkumm wɔn awia ne anadwo ne nʼadekyeeɛ nso. Deɛ wannya bi no koraa na ɔnyaa susukora ɔha! Mmoko buu so wɔ atenaeɛ hɔ nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Na nnipa no firii aseɛ wee mmoa no bi. Wɔhyɛɛ aseɛ weeɛ no, Awurade bo sane fuu wɔn maa ɔde ɔyaredɔm kumm wɔn mu fa kɛseɛ no ara. ");
INSERT INTO twiasante_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Enti wɔtoo beaeɛ hɔ edin sɛ Kibrot-Hataawa a asekyerɛ ne, “Akɔnnɔ damena” ɛfiri sɛ, wɔn a na wɔn ani bere ɛnam na wɔn kɔn adɔ Misraim tena no na wɔsiee wɔn wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ɔman no tu firii hɔ kɔtenaa Haserot kakra. ");
INSERT INTO twiasante_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Ɛda koro bi Miriam ne Aaron kasa tiaa Mose sɛ ne yere yɛ Etiopiani. ");
INSERT INTO twiasante_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Afei, wɔkaa sɛ, “Mose nko ara na Awurade akasa afa ne so? Na yɛn nso ɔnnkasa mfa yɛn so bi anaa?” Na Awurade tee wɔn anwiinwii no. ");
INSERT INTO twiasante_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Na Mose yɛ ɔhobrɛaseni sene obiara a ɔte asase yi so. ");
INSERT INTO twiasante_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ntɛm so, ɔfrɛɛ Mose, Aaron ne Miriam kɔɔ Ahyiaeɛ Ntomadan no mu. Ɔhyɛɛ wɔn sɛ, “Mo baasa no mommra ha.” Enti wɔbɛgyinagyinaa Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Afei, Awurade nam omununkum no mu siane ba bɛgyinaa Ahyiaeɛ Ntomadan no kwan ano, na ɔfrɛɛ Aaron ne Miriam. Ɛberɛ a wɔtwe kɔɔ wɔn anim no, ");
INSERT INTO twiasante_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ɔka kyerɛɛ wɔn sɛ, “Montie me, “Sɛ Awurade odiyifoɔ wɔ mo mu a, menam anisoadehunu so da me ho adi kyerɛ no, me kasa kyerɛ no daeɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Nanso ɛnte saa wɔ me ɔsomfoɔ Mose ho. Me fie nyinaa mu, ɔyɛ ɔnokwafoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Me ne no kasa animu ne animu, kasa a emu da hɔ na ɛnyɛ abɛbuo. Na ɔhunu Awurade sɛdeɛ ɔteɛ. Adɛn enti na moansuro sɛ mobɛkasa atia me ɔsomfoɔ Mose?” ");
INSERT INTO twiasante_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Afei, Awurade bo fuu wɔn denden pa ara ɛnna ɔfirii hɔ kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ɛberɛ a omununkum no refiri Ahyiaeɛ Ntomadan no atifi no, amonom hɔ ara, kwata bɛduruu Miriam ho fitaa. Aaron hunuu asɛm a asi no, ");
INSERT INTO twiasante_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ɔteaam sɛ, “Ao, Owura, nnyina saa bɔne yi so nntwe yɛn aso; yɛyɛ nkwaseafoɔ sɛ yɛyɛɛ adeɛ a ɛte saa. ");
INSERT INTO twiasante_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Mma no nyɛ sɛ owufoɔ a ne fa aporɔ firi nʼawoɔ mu.” ");
INSERT INTO twiasante_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Na Mose teaam frɛɛ Awurade sɛ, “Ao, Onyankopɔn, mesrɛ wo sɛ sa no yadeɛ!” ");
INSERT INTO twiasante_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Awurade ka kyerɛɛ Mose sɛ, “Sɛ nʼagya tee ntasuo guu nʼanim a, anka ne ho bɛgu fi nnanson. Monyi no mfiri atenaeɛ ha nkɔhyɛ baabi nnanson na akyire no, ɔbɛtumi aba bio.” ");
INSERT INTO twiasante_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Enti wɔtwaa Miriam asuo firii atenaeɛ hɔ ma ɔkɔdii nnanson. Nnipa no twɛn kɔsii sɛ wɔsane de no baeɛ ansa na wɔretu kwan no bio. ");
INSERT INTO twiasante_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ɛno akyi, wɔfirii Haserot bɛbɔɔ atenaeɛ wɔ Paran ɛserɛ so. ");
INSERT INTO twiasante_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Soma akwansrafoɔ na wɔnkɔ Kanaan asase so—asase a mede rema; soma mmusuakuo dumienu no mu biara ntuanoni.” ");
INSERT INTO twiasante_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Enti Mose yɛɛ sɛdeɛ Awurade hyɛɛ no no. Ɔsomaa mmarima dumienu a wɔn nyinaa yɛ mmusuakuo ntuanofoɔ firi wɔn atenaeɛ wɔ Paran ɛserɛ so. ");
INSERT INTO twiasante_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Saa mmusuakuo no ne wɔn mpanimfoɔ no edin na ɛdidi so yi: Ruben abusuakuo no ntuanoni ne Sakur babarima Samua; ");
INSERT INTO twiasante_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeon abusuakuo no ntuanoni ne Hori babarima Safat; ");
INSERT INTO twiasante_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yuda abusuakuo no ntuanoni ne Yefune babarima Kaleb; ");
INSERT INTO twiasante_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isakar abusuakuo no ntuanoni ne Yosef babarima Igal; ");
INSERT INTO twiasante_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efraim abusuakuo no ntuanoni ne Nun babarima Hosea; ");
INSERT INTO twiasante_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Benyamin abusuakuo no ntuanoni ne Rafu babarima Palti; ");
INSERT INTO twiasante_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Sebulon abusuakuo no ntuanoni ne Sodi babarima Gadiel; ");
INSERT INTO twiasante_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Manase abusuakuo (a ɛyɛ Yosef abusuakuo no mu fa) no ntuanoni ne Susi babarima Gadi; ");
INSERT INTO twiasante_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan abusuakuo no ntuanoni ne Gemali babarima Amiel; ");
INSERT INTO twiasante_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aser abusuakuo no ntuanoni ne Mikael babarima Setur; ");
INSERT INTO twiasante_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Naftali abusuakuo no ntuanoni ne Wofsi babarima Nahbi ");
INSERT INTO twiasante_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gad abusuakuo no ntuanoni ne Maki babarima Geuel. ");
INSERT INTO twiasante_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Nnipa yi na Mose somaa wɔn ma wɔkɔsraa Kanaan asase no. Mose na ɔmaa Nun ba Hosea edin Yosua. ");
INSERT INTO twiasante_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mose ka kyerɛɛ wɔn sɛ, “Monkɔ atifi fam wɔ Negeb bepɔ no so ");
INSERT INTO twiasante_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","na monhwɛ sɛdeɛ ɛhɔ asase no te; afei, monhwɛ wɔn a wɔte hɔ no nso tebea mu sɛ wɔwɔ ahoɔden anaa wɔyɛ mmerɛ, sɛ wɔdɔɔso anaa wɔsua ");
INSERT INTO twiasante_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","anaasɛ asase no mu wɔ sradeɛ anaasɛ nso sradeɛ nni mu, ne nkuro a ɛwɔ hɔ, sɛ ɛyɛ nkuraa anaa wɔabɔ ho ban, ");
INSERT INTO twiasante_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","sɛ asase no yɛ asasebereɛ anaa asasenini anaasɛ nnua pii wɔ so. Monnsuro na momfa ɛhɔ nnɔbaeɛ no bi mmra.” Saa ɛberɛ no na wɔrete bobe atekane. ");
INSERT INTO twiasante_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Enti wɔkɔsraa asase no firi Sin ɛserɛ so kɔsii Rehob a ɛbɛn Hamat no. ");
INSERT INTO twiasante_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Wɔrekɔ atifi fam no, wɔdii ɛkan faa Negeb bɛduruu Hebron. Ɛhɔ na wɔhunuu Anak asefoɔ a wɔfrɛ wɔn Ahiman, Sesai ne Talmai. Hebron yɛ kuro dada. Wɔkyekyeree saa kuro no ansa na wɔrekyekyere Soan a ɛwɔ Misraim no. ");
INSERT INTO twiasante_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Afei, wɔbaa baabi a seesei wɔfrɛ hɔ “Eskol” a aseɛ ne “Siaka”, ɛfiri sɛ, wɔhunuu bobe siaka bebree wɔ hɔ! Wɔtwaa siaka baako a nnipa baanu na wɔwuraa no dua soaeɛ. Ɛnna wɔfaa ateaa ne borɔdɔma aba sɛ adekyerɛdeɛ de kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Saa ɛberɛ no, Israelfoɔ no too subɔnhwa hɔ edin sɛ “Eskol” a asekyerɛ ne “Siaka”, ɛfiri sɛ, wɔhunuu bobe no siaka pii wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Adaduanan akyi, wɔfirii wɔn akwantuo no mu baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Wɔkaa deɛ wɔkɔhunuiɛ nyinaa kyerɛɛ Mose ne Aaron ne nnipa a wɔwɔ Israel nyinaa ne wɔn a wɔwɔ Paran ɛserɛ so wɔ Kades na wɔde aduaba a wɔde baeɛ no kyerɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Asɛm a wɔbɛkaeɛ ne sɛ, “Yɛduruu asase a wosomaa yɛn sɛ yɛnkɔsra so no so, na nokwasɛm, ɛyɛ ɔman a ɛyɛ fɛ—asase a ɛwoɔ ne nufosuo sen wɔ so. Aduaba a yɛde baeɛ yi di ho adanseɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Nanso na nnipa a wɔtete hɔ no yɛ den. Wɔn nkuro no soso na wɔabɔ ho ban nso. Yɛhunuu Anak asefoɔ akantinka nso wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalekfoɔ te anafoɔ ɛnna Hetifoɔ, Yebusifoɔ ne Amorifoɔ nso tete mmepɔ so. Ɛnna Kanaanfoɔ nso tete ntam ɛpo no ne Yordan subɔnhwa ntam.” ");
INSERT INTO twiasante_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Na ɛberɛ a nnipa no gyina Mose anim no, Kaleb sane hyɛɛ wɔn nkuran sɛ, “Momma yɛmforo nkɔ hɔ prɛko pɛ na yɛnkɔgye wɔn nsam, ɛfiri sɛ, yɛbɛtumi adi wɔn so nkonim.” ");
INSERT INTO twiasante_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Akwansrafoɔ no bi kaa sɛ, “Nanso ɛnyɛ ahoɔdenfoɔ sei na ɛsɛ sɛ yɛne wɔn di asie. Wɔbɛtɔre yɛn ase!” ");
INSERT INTO twiasante_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Akwansrafoɔ no mu fa kɛseɛ no ara asɛm a wɔkaeɛ no maa Israelfoɔ no aba mu buiɛ. Wɔkaa sɛ, “Akofoɔ bebree wɔ asase no so na ɛhɔ nnipa nso yɛ ahoɔdenfoɔ, ");
INSERT INTO twiasante_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","na yɛhunuu Anakfoɔ no bi a ɛfiri awoɔ ntoatoasoɔ mu wɔyɛ abrane no. Sɛ yɛne wɔn gyina hɔ a, na yɛayɛ te sɛ mmɛbɛ wɔ yɛn ani so. Na saa nso na yɛyɛɛ wɔ wɔn ani soɔ.” ");
INSERT INTO twiasante_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Afei, nnipa no nyinaa firii aseɛ suu dendeenden anadwo no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Wɔde nne korɔ kasa tiaa Mose ne Aaron. Wɔsuu sɛ, “Sɛ yɛwuwuu wɔ Misraim anaa ɛserɛ so ha a, anka yɛpɛ no saa ara ");
INSERT INTO twiasante_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","sen sɛ wɔde yɛn bɛkɔ kuro a ɛwɔ yɛn anim no so. Awurade bɛkum yɛn wɔ hɔ na yɛn yerenom ne yɛn mma ayɛ nkoa wɔ hɔ. Momma yɛmfiri ha na yɛnkɔ Misraim!” ");
INSERT INTO twiasante_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Saa asɛm yi dii wɔn nyinaa tirim dɛm. Enti wɔteaam sɛ, “Momma yɛnyi ɔpanin bi na ɔnni yɛn anim nsane mfa yɛn nkɔ Misraim.” ");
INSERT INTO twiasante_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Afei, Mose ne Aaron de wɔn anim butubutuu fam wɔ Israelfoɔ no anim. ");
INSERT INTO twiasante_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Akwansrafoɔ baanu, a wɔn ne Nun babarima Yosua ne Yefune babarima Kaleb sunsuanee wɔn ntadeɛ mu ");
INSERT INTO twiasante_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","na wɔka kyerɛɛ nnipa no nyinaa sɛ, “Asase a ɛda yɛn anim no yɛ asase pa. ");
INSERT INTO twiasante_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Na sɛ yɛsɔ Awurade ani a, ɔde yɛn bɛduru asase no so dwoodwoo na ɔde hɔ ahyɛ yɛn nsa. Ɛyɛ asase bereɛ, asase a nufosuo ne ɛwoɔ sen wɔ soɔ, na ɔde bɛma yɛn. ");
INSERT INTO twiasante_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ao, monnyɛ dɔm ntia Awurade, na monnsuro nnipa a wɔwɔ asase no so no nso. Na wɔte sɛ burodo bi a yɛdie ma yɛn! Awurade ne yɛn wɔ hɔ na wɔn deɛ, wayi ne nsa afiri wɔn so! Monnsuro wɔn!” ");
INSERT INTO twiasante_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Nanso mmuaeɛ a nnipa no maeɛ ara ne sɛ, wɔbɛsi wɔn aboɔ. Afei, Awurade animuonyam baeɛ ");
INSERT INTO twiasante_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","na Awurade bisaa Mose sɛ, “Nnipa yi bɛbu me animtia akɔsi da bɛn? Anwanwadeɛ dodoɔ a mayɛ akyerɛ wɔn yi nyinaa akyi no, wɔnnye me nni? ");
INSERT INTO twiasante_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mɛgye wɔn nsam nneɛma a mede ama wɔn nyinaa na mama ɔyaredɔm asɛe wɔn na mayɛ mo ɔman kɛseɛ a ɛso sene wɔn!” ");
INSERT INTO twiasante_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mose srɛɛ Awurade sɛ, “Na sɛ Misraimfoɔ yi te a, ɛdeɛn asɛm na wɔbɛdwene? Wɔn nyinaa hunuu tumi a wonam so de gyee wo nkurɔfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Wɔaka saa asɛm yi akyerɛ wɔn a wɔte asase yi so a wɔnim, Awurade, sɛ wowɔ Israel afa, na wo ne wɔn kasa anim ne anim. Wɔhunu omununkum dum ne ogya sɛ ɛgyina yɛn atifi, na wɔnim sɛ wodi yɛn anim bɔ yɛn ho ban awia ne anadwo. ");
INSERT INTO twiasante_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Na sɛ wokum wo nkurɔfoɔ nyinaa a, aman a wɔate wo din no bɛka sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘ɛsɛ sɛ Awurade kum wɔn, ɛfiri sɛ, wantumi anhwɛ wɔn so wɔ ɛserɛ so hɔ. Ɔnni ahoɔden a ɔnam so bɛtumi de wɔn aba asase a ɔkaa ho ntam sɛ ɔde bɛma wɔn no so.’ ");
INSERT INTO twiasante_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Ao, mesrɛ wo, fa wo tumi kɛseɛ a ntoboaseɛ wɔ mu no so fa yɛn bɔne kyɛ yɛn, na dɔ yɛn yie. Ɛwom sɛ woaka sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Awurade bo kyɛre fu na nʼadɔeɛ dɔɔso. Nanso ɔbɔnefoɔ remfa ne ho nni a wɔntwe nʼaso; nanso, fa yɛn bɔne kyɛ yɛn. Yɛnim sɛ wonam agyanom bɔne so twee wɔn mma a wɔwɔ awoɔ ntoatoasoɔ mmiɛnsa ne nan mu no aso.’ ");
INSERT INTO twiasante_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ao, mesrɛ wo, fa saa nnipa yi bɔne kyɛ wɔn, ɛfiri sɛ, wo dɔ enti, wode wɔn bɔne akyɛ wɔn firi Misraim abɛsi saa ɛberɛ yi.” ");
INSERT INTO twiasante_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Awurade kaa sɛ, “Ɛyɛ, mede bɛkyɛ wɔn sɛdeɛ woabisa no. ");
INSERT INTO twiasante_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Nanso, sɛ mete ase yi, na Awurade animuonyam ahyɛ asase nyinaa ma yi, ");
INSERT INTO twiasante_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","saa nnipa yi mu biara rensi asase no so ɛda biara da. Wɔahunu mʼanimuonyam ne anwanwadeɛ a meyɛɛ wɔ Misraim ne ɛserɛ so no, nanso ɛberɛ biara wɔyɛ asoɔden de sɔ me hwɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Wɔrenhunu asase a mede hyɛɛ wɔn agyanom bɔ no. Wɔn a wɔyɛɛ asoɔden kyerɛɛ me no mu biara rensi hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Nanso, mʼakoa Kaleb yɛ onipa sononko. Wadi me nsɛm so pɛpɛɛpɛ. Mede no bɛkɔ asase a ɔkɔɔ so sɛ ɔkwansrafoɔ no, na nʼasefoɔ anya ɛhɔ mu kyɛfa. ");
INSERT INTO twiasante_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Nanso, ɛsiane sɛ Israelfoɔ suro Amalekfoɔ na Kanaanfoɔ tete bɔnhwa mu no enti, ɔkyena, ɛsɛ sɛ mosane de mo ani kyerɛ Po Kɔkɔɔ no kɔ ɛserɛ so.” ");
INSERT INTO twiasante_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Awurade bisaa Mose ne Aaron sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Da bɛn na saa nnipa bɔnefoɔ yi bɛgyae me ho nkɔmmɔdie? Na mate nsɛm a wɔka fa me ho nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ka kyerɛ wɔn sɛ, ‘Awurade ka ntam sɛ ɔbɛyɛ deɛ mosuro. ");
INSERT INTO twiasante_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mo nyinaa mobɛwuwu wɔ ɛserɛ so ha: Ɛfiri wɔn a wɔadi mfeɛ aduonu rekorɔ no a wɔadi me ho nkɔmmɔ no, ");
INSERT INTO twiasante_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","wɔn mu biara renkɔ Bɔhyɛ Asase no so. Wɔn a wɔbɛkɔ hɔ ara ne Yefune babarima Kaleb ne Nun babarima Yosua. ");
INSERT INTO twiasante_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Moka sɛ mo mma bɛyɛ nnipa a wɔte asase no so no nkoa. Ɛyɛ, mede wɔn bɛkɔ asase no so dwoodwoo ama wɔakɔfa deɛ mose mompɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Na mo deɛ, mo amu na ɛbɛka ɛserɛ so ha. ");
INSERT INTO twiasante_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ɛsɛ sɛ mokyini ɛserɛ so ha sɛ atutenafoɔ mfeɛ aduanan. Saa ɛkwan yi so na mobɛfa atua mo gyidie a monni ho ka kɔsi sɛ onipa a ɔtwa toɔ no bɛwu atɔ ɛserɛ so ha. ");
INSERT INTO twiasante_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Esiane sɛ akwansrafoɔ no tenaa asase no so adaduanan no enti, ɛsɛ sɛ mo nso mokyinkyini ɛserɛ no so mfeɛ aduanan a afe biara gyina hɔ ma ɛda koro a ɛyɛ mo bɔne so akatua. Sɛ meyɛ obi ɔtamfoɔ a mobɛhunu sɛdeɛ ɛteɛ.’ ");
INSERT INTO twiasante_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Me, Awurade, na makasa. Mo mu biara a wayɛ dɔm atia me no bɛwu wɔ ɛserɛ so ha.” ");
INSERT INTO twiasante_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Akwansrafoɔ edu no a wɔbɔɔ nnipa no hu ma wɔyɛɛ dɔm tiaa Awurade no, ");
INSERT INTO twiasante_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","wɔkunkumm wɔn wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Akwansrafoɔ no nyinaa, Kaleb ne Yosua nko ara na wɔtenaa ase. ");
INSERT INTO twiasante_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mose kɔkaa nsɛm a Onyankopɔn ka kyerɛɛ no no kyerɛɛ nnipa no no, wɔn nyinaa werɛ hoeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Wɔsɔree anɔpahema sɛ wɔrekɔ Bɔhyɛ Asase no so. Wɔkaa sɛ, “Yɛahunu sɛ yɛayɛ bɔne, nanso, yɛasiesie yɛn ho sɛ yɛbɛkɔ asase a Awurade hyɛɛ yɛn ho bɔ no so.” ");
INSERT INTO twiasante_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Nanso, Mose kaa sɛ, “Aka akyi. Afei, morebu Awurade asɛm a ɔkaa sɛ monsane nkɔ ɛserɛ so no so. ");
INSERT INTO twiasante_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Monnkɔ sɛdeɛ moasusu no, anyɛ saa a, atamfoɔ no bɛdi mo so, ɛfiri sɛ, Awurade nni mo afa. ");
INSERT INTO twiasante_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Mo werɛ afiri sɛ Amalekfoɔ ne Kanaanfoɔ wɔ hɔ? Moapa Awurade enti ɔno nso bɛpa mo.” ");
INSERT INTO twiasante_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Nanso, wɔtoaa so foro kɔɔ bepɔ no so a ɛmfa wɔn ho sɛ Awurade adaka no ne Mose mu biara amfiri atenaeɛ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Afei, Amalekfoɔ ne Kanaanfoɔ a wɔte bepɔ no so no siane baa fam bɛto hyɛɛ wɔn so boroo wɔn ara kɔsii Horma. ");
INSERT INTO twiasante_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Ka kyerɛ Israelfoɔ no sɛ, ‘Sɛ mokɔtena asase a mede ama mo no so ");
INSERT INTO twiasante_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","na mopɛ sɛ mobɔ ɔhyeɛ afɔdeɛ anaa afɔdeɛ biara a wɔbɔ no ogya so ma ɛsɔ Awurade ani a, ɛsɛ sɛ afɔrebɔdeɛ no yɛ aboa a ɔfiri mo nnwankuo anaa anantwibuo mu. Sɛ ɛyɛ ɔhyeɛ afɔdeɛ, anaa afɔrebɔ a wɔde hyɛ bɔ, anaa afɔrebɔ a ɛfiri ɔpɛ mu, anaa afɔrebɔ a wɔbɔ no afirinhyia mu nnapɔnna bi mu no a, ɛsɛ sɛ wɔde aduane afɔrebɔdeɛ ka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Deɛ ɔde ba no, ɛsɛ sɛ ɔde aduane afɔrebɔdeɛ a ɛyɛ esiam kilogram mmienu a wɔde ngo lita baako afra ka ho ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Odwammaa biara a wɔde bɔ ɔhyeɛ afɔdeɛ no, ɛsɛ sɛ wɔde nsã afɔrebɔdeɛ a ɛyɛ bobesa lita baako ka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Sɛ odwennini na wode rebɔ afɔdeɛ a, fa esiam lita mmiɛnsa fra ngo lita baako, ");
INSERT INTO twiasante_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ne bobesa lita baako sɛ ɔnom afɔrebɔdeɛ. Yei ne afɔrebɔ a ɛbɛsɔ Awurade ani. ");
INSERT INTO twiasante_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Sɛ wosiesie nantwie ba ma ɔhyeɛ afɔdeɛ anaa afɔrebɔdeɛ de hyɛ bɔ sononko bi anaa ayɔnkofa asikyiresiam afɔdeɛ a worebɔ ama Awurade a, ");
INSERT INTO twiasante_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","fa atokoɔ afɔrebɔdeɛ a ɛyɛ asikyiresiam a wɔayam no muhumuhu lita nsia ne fa ne ngo lita mmienu ka nantwie no ho ");
INSERT INTO twiasante_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","a bobesa lita mmienu ka ho sɛ ɔnom afɔrebɔdeɛ. Egya na wɔde bɛbɔ saa afɔdeɛ yi na asɔ Awurade ani. ");
INSERT INTO twiasante_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Yei ne mmara a ɛka nantwie, odwennini, odwammaa anaa abirekyie ba a wɔde bɔ afɔdeɛ ho. ");
INSERT INTO twiasante_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Afɔrebɔdeɛ biara a mo mu biara de bɛkɔ no, ɛsɛ sɛ ɔfa saa ɛkwan yi so. ");
INSERT INTO twiasante_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Ɛsɛ sɛ Israelfoɔ ne ahɔhoɔ a wɔne mo teɛ a wɔpɛ sɛ wɔfa ogya afɔrebɔ so sɔ Awurade ani no nyinaa di saa mmara yi so. ");
INSERT INTO twiasante_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Na sɛ ahɔhoɔ a wɔte mo mu no pɛ sɛ wɔbɔ ɔhyeɛ afɔdeɛ ma ɛsɔ Awurade ani a, ɛsɛ sɛ wɔfa saa ɛkwan korɔ no ara so. ");
INSERT INTO twiasante_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Mmara no wɔ hɔ ma mo nyinaa—ɔmanfoɔ ne ahɔhoɔ; na ɛyɛ nokorɛ a ɛtim hɔ daa firi awoɔ ntoatoasoɔ so kɔsi awoɔ ntoatoasoɔ so sɛ wɔn nyinaa yɛ pɛ wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Mmara baako na ɛwɔ hɔ ma mo nyinaa.’ ” ");
INSERT INTO twiasante_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Awurade ka kyerɛɛ Mose saa ɛberɛ no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Ka kyerɛ Israelfoɔ no sɛ, sɛ wɔduru asase a mede rebɛma wɔn no so ");
INSERT INTO twiasante_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","na wɔdi asase no so aduane a, wɔmfa bi mmɔ afɔdeɛ mma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Atokoɔ a mobɛyam a ɛdi ɛkan no, momfa nto ɔfam nto nkyɛn sɛ akyɛdeɛ sɛdeɛ moyɛ atokoɔ otwakane no wɔ ayuporobea no. ");
INSERT INTO twiasante_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ɛfiri awoɔ ntoatoasoɔ a ɛbɛba no, ɛsɛ sɛ mode saa afɔdeɛ a ɛfiri mo aduane a ɛdi ɛkan a moanya mu yi ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Sɛ mo mu bi firi awerɛfirie mu bu saa mmara a Awurade nam Mose so de ama mo yi so, ");
INSERT INTO twiasante_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","na sɛ daakye mo asefoɔ bu mmara ahodoɔ a Awurade nam Mose so de ama mo yi so, ");
INSERT INTO twiasante_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","na sɛ wɔfom awerɛfirie mu a nnipa no nnim a, ɛsɛ sɛ wɔde aduane afɔrebɔdeɛ ne ɔnom afɔrebɔdeɛ ne ɔpapo a wɔde no bɛbɔ bɔne ho afɔdeɛ ka ho ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Na ɔsɔfoɔ no ayɛ mpatadeɛ ama Israelfoɔ nyinaa na wɔde wɔn bɔne akyɛ wɔn; ɛfiri sɛ, ɛyɛ mfomsoɔ, na wɔnam ɔhyeɛ afɔrebɔ so abɔ afɔdeɛ wɔ Awurade anim a wɔn bɔne afɔrebɔdeɛ ka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Wɔde nnipa no nyinaa a ahɔhoɔ a wɔte wɔn mu ka ho no bɔne bɛkyɛ wɔn, ɛfiri sɛ, ɔmanfoɔ no nyinaa na wɔyɛɛ mfomsoɔ a wɔanhyɛ da; na wɔde akyɛ wɔn nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Sɛ obi yɛ mfomsoɔ awerɛfirie mu a, ɛsɛ sɛ ɔde abirekyibereɛ ba a wadi afe bɛbɔ bɔne ho afɔdeɛ ");
INSERT INTO twiasante_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","na ɔsɔfoɔ no ayɛ mpatadeɛ ama no wɔ Awurade anim na wɔde ne bɔne akyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Saa mmara yi wɔ hɔ ma Israelfoɔ ne ananafoɔ a wɔte mu mu no. ");
INSERT INTO twiasante_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Na sɛ obi boapa yɛ mfomsoɔ a, sɛ ɔyɛ Israelni anaa ɔnanani no, ɔgu Awurade din ho fi, enti wɔbɛyi no afiri nnipa no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Mperɛ dodoɔ a wɔabu Awurade asɛm animtiaa na wɔboapa abu Awurade mmara so no, ɛsɛ sɛ wɔyi no firi nnipa no mu na ne bɔne gu ne tiri so.’ ” ");
INSERT INTO twiasante_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ɛda bi a Israelfoɔ no wɔ ɛserɛ so no, wɔkyeree wɔn mu baako sɛ ɔrebubu mmabaa homeda. ");
INSERT INTO twiasante_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Wɔkyeree no de no kɔɔ Mose ne Aaron ne atemmufoɔ bi anim. ");
INSERT INTO twiasante_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Wɔde no too afiase kɔsii sɛ wɔhunuu Awurade adwene a ɔwɔ wɔ saa onipa no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Afei, Awurade ka kyerɛɛ Mose sɛ, “Ɛsɛ sɛ wɔkum saa onipa no. Nnipa no nyinaa nsi no aboɔ wɔ atenaeɛ no akyi baabi.” ");
INSERT INTO twiasante_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Enti wɔde no kɔɔ atenaeɛ no akyi baabi kɔsii no aboɔ sɛdeɛ Awurade hyɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Ka kyerɛ Israelfoɔ na wɔmma biribi nsensɛne wɔn ntadeɛ ano mfiri awoɔ ntoatoasoɔ so nkɔsi awoɔ ntoatoasoɔ so a ɛbɛyɛ mmara a ɛtim hɔ daa na wɔmfa ahoma tuntum nkyekyere sɛ nkaeɛ adeɛ mfam ntadeɛ ano. ");
INSERT INTO twiasante_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Saa mmara yi botaeɛ ne sɛ, ɛberɛ biara a mobɛhunu saa adeɛ yi no, mobɛkae Awurade mmara a wɔahyɛ mo no, na moadi nʼapɛdeɛ so, na moamfa mo ankasa mo akwan sɛdeɛ na moyɛ de som anyame afoforɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ɛbɛkae mo ama moayɛ kronkron ama Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mene Awurade mo Onyankopɔn a mede mo firi Misraim asase so baeɛ no. Aane, mene Awurade mo Onyankopɔn.” ");
INSERT INTO twiasante_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Ɛda koro bi Kora, Ishar a ɔyɛ Lewi babarima Kohat aseni ne Datan ne Abiram a wɔyɛ Eliab mmammarima ne On a ɔyɛ Pelet babarima a wɔn baasa no firi Ruben abusuakuo mu bɔɔ pɔ ");
INSERT INTO twiasante_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","tiaa Mose. Na mpanimfoɔ atitire ahanu aduonum a wɔn nyinaa fra agyinatukuo no mu no ka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Wɔkɔɔ Mose ne Aaron hɔ kɔka kyerɛɛ wɔn sɛ. “Mo ahomasoɔ no amee yɛn; monnyɛ kronn nsene obiara. Awurade na wayi obiara a ɔwɔ Israel ha na ɔka yɛn nyinaa ho. Adɛn enti na moma mo ho so sene obiara wɔ ɛberɛ a yɛn nyinaa yɛ Awurade mma?” ");
INSERT INTO twiasante_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mose tee saa asɛm yi no, ɔde nʼanim butuu fam. ");
INSERT INTO twiasante_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ɔka kyerɛɛ Kora ne wɔn a wɔka ne ho no sɛ, “Anɔpa, Awurade bɛkyerɛ mo wɔn a wɔyɛ ne dea ne deɛ ɔyɛ kronkron ne deɛ wɔayi no sɛ ne ɔsɔfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Deɛ ɛsɛ sɛ moyɛ nie: Wo, Kora, ne wɔn a wɔka wo ho, ɔkyena momfa aduhwamhyeɛ nkukuo ");
INSERT INTO twiasante_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","na monhye aduhwam wɔ mu wɔ Awurade anim. Na yɛbɛhunu deɛ Awurade ayi no sɛ ne kronkronni. Afei deɛ, Lewifoɔ moayɛ ama aboro so.” ");
INSERT INTO twiasante_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mose sane bisaa Kora sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","“Yi a Israel Onyankopɔn ayi wo afiri nnipa bebree mu ama woabɛn no pɛɛ no, a woyɛ Awurade Ahyiaeɛ Ntomadan mu adwuma, na wotumi gyina nnipa anim yɛ asɔfodwuma no yɛ wo ade kumaa? ");
INSERT INTO twiasante_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ɛnyɛ wo anisɔ sɛ ɔde saa adwuma yi ahyɛ Lewifoɔ nko ara nsa? Afei deɛ, woagyina pintinn sɛ woregye asɔfodwuma no ayɛ? ");
INSERT INTO twiasante_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Deɛ worehwehwɛ ara ne no! Ɛno enti na woreyɛ dɔm atia Awurade. Na ɛdeɛn na Aaron ayɛ a wompɛ?” ");
INSERT INTO twiasante_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Afei Mose frɛɛ Eliab mmammarima Datan ne Abiram, nanso wɔankɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Wɔkaa sɛ, “Wosusu sɛ ɛyɛ asɛnketewa sɛ wode yɛn firi yɛn asase pa Misraim so de yɛn aba ɛserɛ so sɛ worebɛkum yɛn, na afei, wopɛ sɛ wodi yɛn so ɔhene? ");
INSERT INTO twiasante_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Afei, womfaa yɛn mmaa asase pa a wohyɛɛ yɛn ho bɔ no so, ɛnna nso wommaa yɛn asase biara a yɛnyɛ so adwuma. Hwan na worepɛ no abu no kwasea? Yɛremma”. ");
INSERT INTO twiasante_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mose bo fuiɛ na ɔka kyerɛɛ Awurade sɛ, “Nnye wɔn afɔrebɔdeɛ biara! Menwiaa wɔn afunumu baako mpo na menyɛɛ wɔn mu biara bɔne bi.” ");
INSERT INTO twiasante_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mose ka kyerɛɛ Kora sɛ, “Ɔkyena wo ne wo nnamfonom nyinaa mmra Awurade anim wɔ ha. Aaron nso bɛba ha bi. ");
INSERT INTO twiasante_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Monkae na momfa mo aduhwamhyeɛ nkukuo a aduhwam gu so mmra. Obiara mfa aduhwamhyeɛ kukuo mmra. Ne nyinaa dodoɔ yɛ ahanu aduonum, na momfa mmrɛ Awurade. Na Aaron nso de ne deɛ bɛba ha bi.” ");
INSERT INTO twiasante_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Enti wɔyɛɛ saa. Wɔde wɔn aduhwamhyeɛ nkukuo baeɛ. Wɔsɔɔ ano de aduhwam guu so na wɔne Mose ne Aaron bɛgyinagyinaa Ahyiaeɛ Ntomadan no ano. ");
INSERT INTO twiasante_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Na Kora ahwanyane ɔman no nyinaa atia Mose ne Aaron enti, na wɔn nyinaa aboa wɔn ho ano rehwɛ. Afei, Awurade de animuonyam baa nnipa no nyinaa so ");
INSERT INTO twiasante_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","na Awurade ka kyerɛɛ Mose ne Aaron sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Montwe mo ho mfiri saa nnipa yi ho na manya ɛkwan asɛe wɔn ntɛm.” ");
INSERT INTO twiasante_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Nanso, Mose ne Aaron de wɔn anim butubutuu fam wɔ Awurade anim. Wɔsrɛɛ sɛ, “Ao, Onyankopɔn, amansan nyinaa Onyankopɔn, sɛ onipa baako yɛ bɔne a, na ɛsɛ sɛ wo bo fu nnipa no nyinaa?” ");
INSERT INTO twiasante_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Ɛnneɛ ka kyerɛ nnipa no na wɔmfiri Kora, Datan ne Abiram ntomadan no mu.” ");
INSERT INTO twiasante_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Enti, Mose yɛɛ ntɛm kɔɔ Datan ne Abiram ntomadan no mu a Israel mpanimfoɔ ahanu aduonum di nʼakyi. Ɔka kyerɛɛ nnipa no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","“Ntɛm, momfiri saa nnipabɔnefoɔ yi ntomadan mu na mommfa mo nsa nka wɔn biribiara. Sɛ moyɛ saa a, wɔde mo bɛka wɔn bɔne a wɔayɛ no ho na wɔbɛsɛe mo ne wɔn nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Enti, nnipa no firii Kora, Datan ne Abiram ntomadan no mu kɔgyinagyinaa akyire. Ɛnna Datan ne Abiram nso ne wɔn yerenom ne wɔn mma bɛgyinagyinaa wɔn ntomadan no akwan ano. ");
INSERT INTO twiasante_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mose kaa sɛ, “Ɛnam yei so bɛma moahunu sɛ, Awurade na ɔsomaa me sɛ menyɛ deɛ mayɛ yi nyinaa. Ɛnyɛ me ara me tumi mu na mefiri yɛɛ saa. ");
INSERT INTO twiasante_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Sɛ owuo nko ara na ɛbɛto saa nnipa yi, anaa sɛ wɔhunu deɛ ɛtaa ba nnipa so nko ara a, na ɛnyɛ Awurade na wasoma me. ");
INSERT INTO twiasante_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Na sɛ Awurade nam anwanwakwan so pae asase mu ma emu bue na ɛmene wɔn ne wɔn ahodeɛ na sɛ wɔkɔ asamando anikann a, ɛbɛma moahunu sɛ, saa nnipa yi bu Awurade animtia.” ");
INSERT INTO twiasante_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Wankasa anwie koraa, asase a ɛwɔ wɔn ase no mu paee prɛko pɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","na ɛmenee wɔn ne wɔn ntomadan, wɔn abusuafoɔ, wɔn nnamfonom a na wɔgyinagyina wɔn ho ne wɔn agyapadeɛ nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Enti, wɔwuraa asase mu anikann kɔɔ asamando na asase no sane ka too mu ma wɔyeraeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Israelfoɔ nyinaa de nteateamu dwaneeɛ, ɛfiri sɛ, “Nna wɔsuro sɛ asase no bɛmene wɔn nso!” ");
INSERT INTO twiasante_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Afei, ogya firi Awurade nkyɛn bɛhyee nnipa ahanu aduonum a na wɔrehye aduhwam no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Ka kyerɛ ɔsɔfoɔ Aaron babarima Eleasa sɛ ɔnyi aduhwamhyeɛ nkukuo no mfiri ogya no mu, ɛfiri sɛ, ɛyɛ kronkron, na ɔnyi gyasramma no ");
INSERT INTO twiasante_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","mfiri saa nnipa a wɔayɛ bɔne awu no aduhwamhyeɛ nkukuo no aseɛ. Ɔbɛboro aduhwamhyeɛ nkukuo no ama ayɛ trawa na ɔde akata afɔrebukyia no so. Saa aduhwamhyeɛ nkukuo yi yɛ kronkron, ɛfiri sɛ, wɔde adi dwuma wɔ Awurade anim. Na afɔrebukyia no nkatasoɔ yi bɛyɛ kɔkɔbɔ ama Israelfoɔ.” ");
INSERT INTO twiasante_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Enti, ɔsɔfoɔ Eleasa faa aduhwamhyeɛ nkukuo ahanu aduonum no na ɔboro ma ɛyɛɛ ntrawa na ɔde kataa afɔrebukyia no so, ");
INSERT INTO twiasante_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","na Israelfoɔ no nam so akae sɛ obiara a wɔmmaa no ho kwan anaa ɔmfiri Aaron ase no, ɔnni ho kwan sɛ ɔba Awurade anim bɛhye aduhwam. Sɛ ɔyɛ saa a, asɛm a ɛtoo Kora ne nʼahokafoɔ no bi bɛto no. Sei na Mose yɛɛ deɛ Awurade ka kyerɛɛ no sɛ ɔnyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Adeɛ kyee anɔpa no, nnipa no nyinaa firii aseɛ nwiinwii tiaa Mose ne Aaron sɛ, “Moakum Awurade nkurɔfoɔ.” ");
INSERT INTO twiasante_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ankyɛre koraa, nnipa no nyinaa boaa wɔn ho ano. Wɔgu so rehwɛ Ahyiaeɛ Ntomadan no, prɛko pɛ, omununkum no pueeɛ ma wɔhunuu Awurade animuonyam nwanwaso no. ");
INSERT INTO twiasante_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mose ne Aaron bɛgyinaa Ahyiaeɛ Ntomadan no kwan ano, ");
INSERT INTO twiasante_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","na Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Twe wo ho firi saa nnipa yi mu na matumi asɛe wɔn prɛko pɛ.” Nanso, Mose ne Aaron de wɔn anim butubutuu fam wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Na Mose ka kyerɛɛ Aaron sɛ, “Ntɛm, fa aduhwamhyeɛ kukuo no na yi ogya firi afɔrebukyia no so gu mu. Fa aduhwam gu so na fa fa nnipa no mu ntɛm so fa kɔyɛ mpatadeɛ ma wɔn, ɛfiri sɛ, Awurade abufuo aduru wɔn so. Ɔyaredɔm no afiri aseɛ.” ");
INSERT INTO twiasante_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aaron yɛɛ deɛ Mose hyɛɛ no sɛ ɔnyɛ no, na ɔtuu mmirika faa nnipa no mu. Na ɔyaredɔm no aba ampa, na ɔhyee aduhwam no de yɛɛ mpatadeɛ maa wɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Na ɔgyinaa ateasefoɔ ne awufoɔ ntam, na ɔyaredɔm no gyaeeɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","nanso, na nnipa mpem dunan ne ahanson awuwu dada abɛka wɔn a wɔne Kora wuwuiɛ ɛda a ɛdi animu no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ɔyaredɔm no gyaeeɛ no, Aaron sane kɔɔ Mose nkyɛn wɔ Ahyiaeɛ Ntomadan no ano. ");
INSERT INTO twiasante_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Ka kyerɛ Israelfoɔ no sɛ, abusua biara ɔdaanoni no ntwa poma na ɔntwerɛ ne din wɔ ho. ");
INSERT INTO twiasante_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Aaron din na wɔbɛtwerɛ agu Lewi abusuakuo poma no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Momfa mpoma yi ngu Ahyiaeɛ Ntomadan no mu ahyiaeɛm wɔ baabi a mehyia mo wɔ adaka no anim hɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Menam mpoma yi so bɛkyerɛ onipa a mɛyi no no, na ne poma no ho bɛfefɛ! Ɛno akyi, anwiinwii a wɔnwiinwii tia wo no nyinaa to bɛtwa.” ");
INSERT INTO twiasante_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Enti, Mose hyɛɛ saa mmara yi maa nnipa no maa ahemfo dumienu no a Aaron ka wɔn ho de wɔn mpoma brɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ɔde guu Awurade anim wɔ Adanseɛ Ntomadan no mu hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Adeɛ kyeeɛ a ɔkɔɔ mu no, ɔhunuu sɛ Aaron poma a ɛwɔ hɔ ma Lewi abusuakuo no afefɛ ayɛ frɔmm, aso aba a ɛsensɛn so. ");
INSERT INTO twiasante_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ɛberɛ a Mose de firii Awurade hɔ baeɛ sɛ ɔde rebɛkyerɛ nkurɔfoɔ no, wɔhunuiɛ no, wɔn ho dwirii wɔn. Afei, obiara gyee ne poma, gye Aaron nko. ");
INSERT INTO twiasante_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Awurade ka kyerɛɛ Mose sɛ ɔmfa Aaron poma no nto adaka no ho pɛɛ na ɔmfa nkae saa adɔnyɛ no. Na ɛsɛ sɛ ɔde ba bɛkyerɛ nnipa no bio na sɛ anwiinwii bi wɔ hɔ a ɛtia Aaron tumi a, ɛbɛsi amanehunu foforɔ a anka ɛbɛba nnipa no so no ano. ");
INSERT INTO twiasante_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Enti, Mose yɛɛ deɛ Awurade hyɛɛ no sɛ ɔnyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Nanso Israelfoɔ no kɔɔ so nwiinwiiɛ sɛ, “Yɛyɛ teaseawuo. ");
INSERT INTO twiasante_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Obiara a ɔbɛbɛn Awurade Ahyiaeɛ Ntomadan no ho no wu. Ɛsɛ sɛ yɛn nyinaa ase hye anaa?” ");
INSERT INTO twiasante_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Awurade kasa kyerɛɛ Aaron sɛ, “Wo, wo mmammarima ne wʼabusuafoɔ a wɔfiri Lewi abusuakuo mu no, mfomsoɔ biara a ɛfa kronkronbea hɔ no ho asodie bɛda mo so. Na sɛ biribi ankɔ so yie wɔ asɔfodwuma no mu a, wɔbɛbisa wo ne wo mmammarima ho asɛm. ");
INSERT INTO twiasante_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Fa wo nkurɔfoɔ a wɔwɔ Lewi abusuakuo no mu ma wɔmmoa wo mmammarima wɔ dwumadie kronkron no a wɔyɛ no Ahyiaeɛ Ntomadan no anim. ");
INSERT INTO twiasante_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ɛsɛ sɛ Lewifoɔ no hwɛ yie na wɔansɔ biribiara a ɛyɛ kronkron wɔ afɔrebukyia no so mu. Sɛ wɔyɛ saa a, mɛsɛe wo ne wɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Obiara a ɔmfiri Lewi abusua mu nni ho kwan sɛ ɔboa wo ɛkwan biara so. ");
INSERT INTO twiasante_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Kae sɛ asɔfoɔ no nko ara na ɛsɛ sɛ wɔdi dwuma a ɛho te wɔ kronkronbea hɔ ne afɔrebukyia no so. Sɛ wodi saa mmara yi so a, Onyankopɔn abufuo no remma Israelfoɔ no so bio sɛ wɔabu mmara yi so. ");
INSERT INTO twiasante_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Meka bio sɛ, Lewifoɔ a wɔyɛ wo nkurɔfoɔ no na wɔmmoa wo wɔ Ahyiaeɛ Ntomadan no mu dwumadie no. Wɔyɛ akyɛdeɛ firi Awurade hɔ ma wo. ");
INSERT INTO twiasante_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Nanso, wo ne wo mmammarima asɔfoɔ no ankasa na mobɛdi dwuma a ɛho te wɔ afɔrebukyia no so ne deɛ ɛwɔ ntwamutam no mu, na asɔfodwuma no deɛ, ɛyɛ mo ara mo dom akyɛdeɛ dwumadie. Onipa foforɔ biara a ɔbɛyɛ nʼadwene sɛ ɔbɛdi dwuma no bi no bɛwu.” ");
INSERT INTO twiasante_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Awurade sane ka kyerɛɛ Aaron sɛ: “Mede akyɛdeɛ a nkurɔfoɔ de abrɛ Awurade no nyinaa ama asɔfoɔ no; saa akyɛdeɛ yi a wɔhim no Awurade anim nam so de kyɛɛ no wɔ afɔrebukyia no anim no no, daa daa mmara enti, ɛyɛ mo ne mo mmammarima dea. ");
INSERT INTO twiasante_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Aduane afɔrebɔ, bɔne afɔrebɔ ne afɔbuo afɔrebɔ nyinaa yɛ mo dea, agye emu bi a wɔhye no wɔ afɔrebukyia so de kyɛ Awurade no nko ara. Yeinom nyinaa yɛ afɔrebɔdeɛ a ɛyɛ kronkron pa ara. ");
INSERT INTO twiasante_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ɛsɛ sɛ wɔdi no baabi a ɛyɛ kronkron pa ara. Na mmarima nko ara na ɛsɛ sɛ wɔdie. ");
INSERT INTO twiasante_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Akyɛdeɛ afoforɔ a wɔnam him a wɔbɛhim wɔ afɔrebukyia no so de bɛkyɛ me no yɛ wo ne wʼabusuafoɔ, wo mmammarima ne wo mmammaa nyinaa dea. Na wʼabusuafoɔ nyinaa tumi di bi, agye obi a saa ɛberɛ no na ne ho nte. ");
INSERT INTO twiasante_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Otwa berɛ a ɛdi ɛkan mu akyɛdeɛ a nnipa no de bɛba sɛ afɔrebɔdeɛ a wɔde rebrɛ Awurade no a ɛyɛ ngo pa, bobesa pa, aburoo ne afudeɛ biara no, ne nyinaa yɛ mo dea. ");
INSERT INTO twiasante_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Sɛ mo abusuafoɔ hwɛ na wɔn ho te a, wɔtumi di yeinom nyinaa bi. ");
INSERT INTO twiasante_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Deɛ wɔde bɛma Awurade biara yɛ mo dea. ");
INSERT INTO twiasante_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Israelfoɔ abakan ne wɔn mmoa nyinaa abakan a wɔde brɛ Awurade yɛ mo dea. Nanso mmoa a memmaa mo ɛkwan sɛ wɔnwe wɔn nam no deɛ, monnnye wɔn abakan. Na mmom, ɛsɛ sɛ wɔtua sika kakra de si abakan biara anan. ");
INSERT INTO twiasante_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Sɛ abakan no di bosome a, na ɛsɛ sɛ wɔde ɔgye boɔ a ɛyɛ dwetɛ gram aduonum nsia sɛdeɛ kronkronbea hɔ nkariboɔ a ɛyɛ gram dubaako ne nkyemu anum mu baako no teɛ no ba. ");
INSERT INTO twiasante_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Nanso anantwie, nnwan ne mpɔnkye mmakan deɛ, ɛnsɛ sɛ wɔgye wɔn. Ɛsɛ sɛ wɔde wɔn bɔ afɔdeɛ ma Awurade. Wɔn mogya na ɛsɛ sɛ wɔde pete afɔrebukyia no so na wɔhye wɔn sradeɛ no sɛ ogya afɔdeɛ. Ɛyɛ adeɛ a Awurade ani sɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Saa mmoa yi nyinaa ɛnam bɛyɛ mo dea. Ne yan ne ne srɛ nifa a wɔbɛhim no afɔrebukyia no anim de akyerɛ sɛ wɔde ama Awurade no nso, mobɛfa. ");
INSERT INTO twiasante_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Mede afɔrebɔdeɛ a Israelfoɔ de bɛbrɛ Awurade a wɔbɛhim no no nyinaa ma mo ne mo abusuafoɔ. Mo ne mo abusuafoɔ mfa na monni. Yei yɛ bɔhyɛ a ɛda mo ne Awurade ne mo asefoɔ ntam daa nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Awurade ka kyerɛɛ Aaron sɛ, “Mo asɔfoɔ no nso, ɛnsɛ sɛ mopɛ agyapadeɛ ne akatua foforɔ biara. Na me ara na me ho hia mo. ");
INSERT INTO twiasante_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Na Lewi abusuakuo deɛ, wɔfiri Israel asase so ho adwumadeɛ ntotosoɔ dudu no mu na ɛbɛtua wɔn ka. ");
INSERT INTO twiasante_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Ɛfiri ɛnnɛ rekorɔ, Israelfoɔ a wɔnyɛ asɔfoɔ ne Lewifoɔ no nni ho kwan sɛ wɔkɔ kronkron mu kronkron hɔ. Wɔyɛ saa a, wɔbɛbu wɔn fɔ na wɔawuwu. ");
INSERT INTO twiasante_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Lewifoɔ no nko ara na wɔbɛyɛ adwuma wɔ hɔ. Sɛ wɔanyɛ a, wɔbɛbu wɔn fɔ. Ɛyɛ mmara a ɛda hɔ afebɔɔ sɛ ɛnsɛ sɛ Lewini biara nya agyapadeɛ wɔ Israelman mu. ");
INSERT INTO twiasante_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Mmom, ntotosoɔ dudu a ɔmanfoɔ de ba ma wɔhim no afɔrebukyia no anim de ma Awurade no na ɛsɛ sɛ Lewifoɔ no fa. Yei yɛ agyapadeɛ, enti ɛho nhia sɛ wɔpɛ agyapadeɛ foforɔ bi bio.” ");
INSERT INTO twiasante_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Awurade sane ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Ka kyerɛ Lewifoɔ no sɛ, ntotosoɔ dudu a wɔnya no, wɔmfa nkyɛmu edu mu baako mma Awurade. Ɛbɛyɛ ntotosoɔ dudu mu ntotosoɔ dudu a wɔnam him a wɔbɛhim no afɔrebukyia no anim de ama Awurade no so. ");
INSERT INTO twiasante_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Na Awurade bɛgye no sɛ mo afɔrebɔdeɛ a ɛdi ɛkan a ɛyɛ aduane ne nsã a mode rema no sɛdeɛ ɛfiri mo ara mo agyapadeɛ mu. ");
INSERT INTO twiasante_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Saa ntotosoɔ dudu mu ntotosoɔ dudu yi a mobɛnya yi mu na mode bɛma ɔsɔfoɔ Aaron sɛ Awurade kyɛfa. ");
INSERT INTO twiasante_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Biribiara a wɔde bɛma mo no, momfa emu deɛ ɛyɛ pa ara na ɛyɛ kronkron no mma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Na wɔbɛfa no sɛ deɛ ɛfiri mo ankasa mo ayuporobea ne mo nsakyibea hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Aaron ne ne mmammarima ne nʼabusuafoɔ bɛtumi adi no wɔ wɔn fie anaa baabiara a wɔpɛ, ɛfiri sɛ, ɛyɛ wɔn adwuma a wɔyɛ no wɔ Ahyiaeɛ Ntomadan mu no ho akatua. ");
INSERT INTO twiasante_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Mo Lewifoɔ no, sɛ mogye Awurade ntotosoɔ dudu no na mode emu nkyɛmu edu a ɛsɔ ani mu baako ma asɔfoɔ no a, monni afɔbuo biara. Nanso, monhwɛ yie na akyɛdeɛ kronkron a Israelfoɔ de aba no, moammu no ade teta bi. Sɛ moyɛ saa a, mobɛwuwu.” ");
INSERT INTO twiasante_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Awurade ka kyerɛɛ Mose ne Aaron sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Me som ho mmara foforɔ nie: Ka kyerɛ Israelfoɔ sɛ wɔmfa nantwie ba bereɛ kɔkɔɔ a ɔnnii dɛm na ɔntwee nneɛma da mmrɛ me. ");
INSERT INTO twiasante_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Momfa no mma ɔsɔfoɔ Eleasa na ɔde no bɛkɔ atenaeɛ no akyi baabi na obi akum no ɛberɛ a ɔno ara nso rehwɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleasa de ne nsateaa bɛbɔ mogya no mu na ɔde apete Ahyiaeɛ Ntomadan no anim mprɛnson. ");
INSERT INTO twiasante_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Afei, ɔbɛhwɛ ama obi ahye nantwie ba no. Ɔbɛhye ne ho nwoma, ne nam, ne mogya ne nʼagyanan nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Na ɛgu so rehye no, Eleasa bɛfa odum dua ne hisope mman ne asaawa kɔkɔɔ na wato agu nneɛma a wɔrehye no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Yei akyi, ɛsɛ sɛ ɔsi ne ntadeɛ na ɔdware na afei ɔkɔ atenaeɛ hɔ a wɔfa no sɛ ne ho agu fi kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Onipa a ɔhyee aboa no nso, ɛsɛ sɛ ɔsi ne ntadeɛ, na ɔdware, ɛfiri sɛ, ɔno nso ho agu fi kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Afei, obi a ne ho nguu fi no bɛsesa aboa a wɔhyee no no nsõ de akɔ atenaeɛ no akyi baabi a ɛhɔ yɛ kronkron na wakɔkora no wɔ hɔ. Israelfoɔ no de bɛgu wɔn nsuo a wɔde dwira wɔn ho de pam wɔn bɔne no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Onipa a ɔbɛboaboa nantwie ba no nsõ no ano no nso, ɛsɛ sɛ ɔsi ne ntadeɛ, ɛfiri sɛ, ne ho gu fi kɔsi anwummerɛ; yei yɛ mmara a ɛwɔ hɔ daa a ɛho wɔ mfasoɔ ma Israelfoɔ no ne ahɔhoɔ a wɔte wɔn mu no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Obiara a ɔbɛsɔ efunu mu no ho bɛgu fi nnanson. ");
INSERT INTO twiasante_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Na ne nnansa ne ne nnanson so no, ɔde nsuo a wɔde dwira wɔn ho no adwira ne ho ama ne ho ate. Sɛ ne nnansa so wanyɛ yei a, ne nnanson akyi nyinaa na ne ho agu fi. ");
INSERT INTO twiasante_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Wɔn a wɔsɔ efunu mu na wɔnnwira wɔn ho sɛdeɛ makyerɛ yi no, wɔgu Awurade Ahyiaeɛ Ntomadan ho fi, na ɛsɛ sɛ wɔyi saa nnipa no firi Israelfoɔ mu. Esiane sɛ wɔamfa ahodwira nsuo no bi ampete wɔn ho no enti, wɔn ho agu fi ara. ");
INSERT INTO twiasante_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Sɛ obi wu wɔ ntomadan mu a, ɛho mmara nie: Obiara a ɔbɛwura saa ntomadan no mu ne wɔn a wɔwɔ mu dada ansa na onipa no rewuo no nyinaa ho gu fi nnanson. ");
INSERT INTO twiasante_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Adeɛ biara a wɔde biribi gu mu a ɛnni mmuasoɔ no nso ho gu fi. ");
INSERT INTO twiasante_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Sɛ obi a ɔwɔ abɔntene de ne nsa ka obi a ɔtɔɔ wɔ akofena ano funu anaa sɛ obi a ɔnyɛ ɔtɔfoɔ funu, anaasɛ obi de ne nsa ka onipa dompe anaa damena a, ne ho bɛgu fi nnanson. ");
INSERT INTO twiasante_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Ansa na ne ho bɛte bio no, gye sɛ wɔde nantwie ba kɔkɔɔ no nsõ a wɔde bɔ bɔne ho afɔdeɛ no fra nsuo a wɔde agu asuhina mu. ");
INSERT INTO twiasante_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Na obi a ne ho te afa hisope mman na ɔde abɔ nsuo no mu de apete ntomadan no so ne nkuku ne nkaka a ɛwɔ ntomadan no mu no nso so ne obiara a na ɔwɔ ntomadan no mu a ne ho agu fi no so. Saa ara nso na obi a ɔsɔɔ dompe mu anaa ɔsɔɔ obi a wɔakum no anaa deɛ ɔde ne ho aka damena no nso, wɔdwira ne ho. ");
INSERT INTO twiasante_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Wɔyɛ yei ne nnansa ne ne nnanson so. Na deɛ ne ho agu fi no nso, ɛsɛ sɛ ɔsi ne ntadeɛ na ɔdware, na ɛduru anwummerɛ a, afei ne ho ate. ");
INSERT INTO twiasante_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Nanso, obiara a ne ho agu fi na wannwira ne ho no, wɔbɛtwa no asuo, ɛfiri sɛ, wɔagu Awurade kronkronbea hɔ ho fi. Ɛfiri sɛ wɔmfaa nsuo a ɛsɛ sɛ wɔde pete ne so no mpetee ne so no enti, ne ho agu fi. ");
INSERT INTO twiasante_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Yei yɛ mmara a ɛwɔ hɔ afebɔɔ. “Onipa a ɔbɛtu nsuo no apete no nso, ɛsɛ sɛ akyire no, ɔsi ne ntadeɛ, na obiara a ɔde ne nsa bɛka nsuo no nso ho gu fi kɔsi anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Na biribiara a obi a ne ho agu fi no bɛsɔ mu no nso ho gu fi kɔsi anwummerɛ.” ");
INSERT INTO twiasante_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Israelfoɔ no duruu Sin ɛserɛ so bosome a ɛdi ɛkan no mu. Wɔsisii wɔn ntomadan wɔ Kades, na ɛhɔ na Miriam wuiɛ ma wɔsiee no. ");
INSERT INTO twiasante_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Na nsuo a wɔbɛnom nni hɔ enti, nnipa no sɔre tiaa Mose ne Aaron. ");
INSERT INTO twiasante_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Nnipa no bɔɔ Mose soboɔ sɛ, “Sɛ yɛne yɛn nuanom wuwuu wɔ Awurade anim a anka yɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Mode Awurade ɔman ne yɛn nnwan ne yɛn anantwie aba ɛserɛ yi so sɛ yɛmmewuwu? ");
INSERT INTO twiasante_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Adɛn enti na moyii yɛn firii Misraim de yɛn baa asase bɔne yi so? Borɔdɔma, atokoɔ, bobe ne ateaa nni asase yi so. Nsuo a yɛbɛnom nso nni ha.” ");
INSERT INTO twiasante_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mose ne Aaron sɔre kɔɔ Ahyiaeɛ Ntomadan no ano de wɔn anim butubutuu fam wɔ Awurade anim; na wɔhunuu Awurade animuonyam. ");
INSERT INTO twiasante_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Na Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Momfa Aaron abaa no na wo ne Aaron mfrɛ nnipa no nyinaa. Wɔrehwɛ mo no, kasa kyerɛ ɔbotan a ɛwɔ nohoa no sɛ nsuo mfiri mu mmra. Mobɛnya wɔn nsuo a ɛbɛso wɔne wɔn anantwie afiri ɔbotan no mu!” ");
INSERT INTO twiasante_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mose yɛɛ deɛ Awurade kaeɛ no. Ɔfaa abaa no firii baabi a wɔde asie wɔ Awurade anim, ");
INSERT INTO twiasante_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","na Mose ne Aaron frɛɛ nnipa no nyinaa ma wɔbɛboaa ɔbotan no ho na wɔka kyerɛɛ wɔn sɛ, “Adɔnyɛfoɔ, montie! Yɛmma nsuo mfiri saa ɔbotan yi mu mmra anaa?” ");
INSERT INTO twiasante_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Afei Mose maa abaa no so de bɔɔ ɔbotan no mprenu maa nsuo bebree firii mu baeɛ maa nnipa no ne wɔn anantwie nomeeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Nanso, Awurade ka kyerɛɛ Mose ne Aaron sɛ, “Esiane sɛ moante me ho wɔ Israelfoɔ no anim no enti, moremfa wɔn nkɔ asase a mehyɛɛ wɔn ho bɔ no so!” ");
INSERT INTO twiasante_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Wɔfrɛɛ beaeɛ hɔ Meriba a aseɛ ne: Adɔnyɛ Nsuo, ɛfiri sɛ, ɛhɔ ne baabi a Israelfoɔ tee Awurade atua na, ɛhɔ ara nso na Awurade daa ne ho adi kyerɛɛ wɔn sɛ ɔyɛ kronkron. ");
INSERT INTO twiasante_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Ɛberɛ a Mose wɔ Kades no, ɔsomaa nnipa ma wɔkɔɔ Edomhene nkyɛn sɛ wɔnkɔka nkyerɛ no sɛ: “Saa nkra yi firi wʼabusuafoɔ a wɔyɛ Israelfoɔ nkyɛn. Wonim abɛbrɛsɛ a yɛafa mu, ");
INSERT INTO twiasante_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","sɛdeɛ yɛn agyanom kɔtenaa Misraim. Yɛtenaa hɔ mfeɛ bebree na yɛhunuu amane sɛ Misraimfoɔ nkoa. ");
INSERT INTO twiasante_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Nanso, yɛsu frɛɛ Awurade no, ɔtiee yɛn na ɔsomaa ɔbɔfoɔ ma ɔbɛyii yɛn firii Misraim. “Seesei yɛwɔ Kades wɔ mo asase hyeɛ so. ");
INSERT INTO twiasante_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Yɛsrɛ mo sɛ, momma yɛntwa mu mfa mo ɔman yi mu. Yɛbɛhwɛ yie sɛ yɛremfa mo mfuo ne mo bobe nturo mu. Na mpo, yɛrennom mo abura mu nsuo. Yɛbɛfa ɔhene kwantempɔn so na yɛremfiri so kɔsi sɛ yɛbɛtra mo hyeɛ a ɛwɔ ɛfa nohoa no.” ");
INSERT INTO twiasante_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Nanso, Edomhene kaa sɛ, “Mommfa mʼasase so, anyɛ saa a mede akodɔm bɛhyia mo!” ");
INSERT INTO twiasante_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Israelfoɔ no buaa sɛ, “Owura, yɛbɛfa tempɔn no so. Sɛ yɛn ayɛmmoa nom mo nsuo a, yɛbɛtua ka. Yɛpɛ sɛ yɛtwam wɔ mo asase so na yɛnni adwemmɔne bi.” ");
INSERT INTO twiasante_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Nanso Edomhene buaa sɛ, “Mommfa yɛn asase so!” Ɔboaboaa nʼakodɔm ano de wɔn kɔɔ ɛhyeɛ no so. ");
INSERT INTO twiasante_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Esiane sɛ Edom amma wɔn ɛkwan amma Israelfoɔ no amfa wɔn ɔman mu no enti, wɔmane faa nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Wɔfirii Kades kɔɔ Bepɔ Hor so. ");
INSERT INTO twiasante_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Afei, Awurade ka kyerɛɛ Mose ne Aaron wɔ Bepɔ Hor a ɛwɔ Edom hyeɛ so sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Ɛberɛ aduru sɛ Aaron wuo, na ɔrenkɔ asase a mede ama Israelfoɔ no so bi, ɛfiri sɛ, mo baanu yɛɛ me dɔm wɔ Meriba nsuo no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Afei, fa Aaron ne ne babarima Eleasa kɔ Bepɔ Hor so. ");
INSERT INTO twiasante_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ɛhɔ na wobɛyi Aaron asɔfotadeɛ no de ahyɛ ne babarima Eleasa. Ɛhɔ na Aaron bɛwu na watoa nʼagyanom.” ");
INSERT INTO twiasante_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Enti, Mose yɛɛ deɛ Awurade hyɛɛ no sɛ ɔnyɛ no. Wɔn baasa nyinaa kɔɔ bepɔ Hor so a nnipa no nyinaa hwɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Wɔduruu bepɔ no apampam no, Mose yii Aaron asɔfotadeɛ no de hyɛɛ ne babarima Eleasa, na Aaron wuu wɔ bepɔ no apampam. Mose ne Eleasa sane wɔn akyi, ");
INSERT INTO twiasante_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","na wɔbɔɔ nnipa no wu a Aaron awuo no ho amaneɛ no, wɔsuu no adaduasa. ");
INSERT INTO twiasante_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Arad ɔhene a ɔyɛ Kanaanni a ɔte Negeb tee sɛ Israelfoɔ nam Atarim ɛkwan so reba. Ɔboaboaa nʼakodɔm ano kɔto hyɛɛ Israelfoɔ no so kyekyeree binom sɛ nneduafoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Afei, Israelfoɔ no kaa ntam kyerɛɛ Awurade sɛ, sɛ ɔbɛboa wɔn ama wɔadi Arad ɔhene ne de dɔm so a, anka wɔbɛgu nkuro akɛseɛ a ɛwɔ hɔ nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Awurade tiee wɔn abisadeɛ no, enti ɔmaa wɔdii Kanaanfoɔ no so; Israelfoɔ no sɛee wɔn ne wɔn nkuro akɛseɛ pasaa. Wɔtoo hɔ edin Horma a aseɛ ne “Ɔsɛeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Afei, Israelfoɔ no sane kɔɔ Bepɔ Hor so. Wɔfiri hɔ no, wɔkɔɔ anafoɔ fam ɛkwan a ɛkɔ Ɛpo Kɔkɔɔ no so no so sɛdeɛ ɛbɛyɛ a, wɔbɛtumi atwa kanko afa Edom ho. Nnipa no aba mu buiɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Wɔhyɛɛ aseɛ nwiinwii tiaa Onyankopɔn enti wɔkaa wɔn ahiasɛm kyerɛɛ Mose sɛ, “Adɛn enti na woayi yɛn afiri Misraim de yɛn aba sɛ yɛmmɛwuwu ɛserɛ yi so? Aduane a yɛbɛdie nni ha. Nsuo a yɛbɛnom nso nni ha. Mana yi nso deɛ, afono yɛn.” ");
INSERT INTO twiasante_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Enti, Awurade maa awɔ a wɔn ano wɔ borɔ yie kɔkekaa wɔn mu bebree ma wɔwuwuiɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Afei, nnipa no baa Mose nkyɛn bɛsrɛɛ sɛ, “Yɛayɛ bɔne, ɛfiri sɛ, yɛakasa atia Awurade ne wo. Bɔ mpaeɛ kyerɛ Awurade na awɔ no nkɔ.” Mose bɔɔ mpaeɛ maa nnipa no. ");
INSERT INTO twiasante_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Awurade ka kyerɛɛ Mose sɛ, “Fa kɔbere yɛ saa awɔ yi mu baako sɛso na fa no sɛn poma bi so, na sɛ awɔ no bi ka obi na onii no hwɛ no kɛkɛ a, ɔrenwu.” ");
INSERT INTO twiasante_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Enti, Mose yɛɛ ɔwɔ sɛso no; na obiara a ɔwɔ no bi bɛka no no, sɛ ɔpagya nʼani hwɛ no a, ɔnwu. ");
INSERT INTO twiasante_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israelfoɔ no firi hɔ no, wɔtoaa wɔn akwantuo no so kɔɔ Obot kɔtenaa hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Afei, wɔtoaa so kɔɔ Iye-Abarim wɔ ɛserɛ so wɔ Moab apueeɛ fam. ");
INSERT INTO twiasante_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Wɔfiri hɔ no, wɔtoaa so kɔɔ asuwa Sered Subɔnhwa mu kɔbɔɔ atenaeɛ wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Afei, wɔtu kɔɔ akyirikyiri fam wɔ Asubɔnten Arnon nkyɛn hɔ baabi a wɔne Amorifoɔ bɔ hyeɛ. Asubɔnten Arnon na ɛyɛ ɛhyeɛ a ɛda Moabfoɔ ne Amorifoɔ ntam. ");
INSERT INTO twiasante_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Enti, wɔkaa saa asɛm yi wɔ Awurade akodie nwoma no mu sɛ, asubɔnten Arnon subɔnhwa ne kuro Waheb ");
INSERT INTO twiasante_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","da Amorifoɔ ne Moabfoɔ ntam. ");
INSERT INTO twiasante_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Afei, Israelfoɔ no toaa wɔn akwantuo no so kɔɔ Beer a aseɛ ne “Abura.” Ɛha na Awurade ka kyerɛɛ Mose sɛ, “Frɛfrɛ nnipa no nyinaa bra na mɛma wɔn nsuo.” ");
INSERT INTO twiasante_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ɛhɔ na Israelfoɔ too dwom sɛ, “Tue Ao, Abura! To ho dwom! ");
INSERT INTO twiasante_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","To abura yi ho dwom, mmapɔmma na wɔtuiɛ; na akunini titii mu wɔde wɔn ahempoma ne wɔn poma.” Afei, Israelfoɔ no firii ɛserɛ no so kɔfaa Matana, ");
INSERT INTO twiasante_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Nahaliel ne Bamot. ");
INSERT INTO twiasante_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Afei wɔkɔɔ Pisga atifi a ɛwɔ Moab bɔnhwa no mu, baabi a wogyina a wohunu asase tamaa no. ");
INSERT INTO twiasante_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Afei, Israelfoɔ tuu abɔfoɔ ma wɔde nkra yi kɔmaa Amorifoɔhene Sihon sɛ: ");
INSERT INTO twiasante_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Momma yɛntwa mu mfa mo ɔman yi mu. Yɛbɛfa ɛkwan tempɔn so, na yɛremfiri so kɔsi sɛ yɛbɛtra mo hyeɛ. Yɛrentiatia mo mfudeɛ so, yɛremfa yɛn nsa nka mo bobe nturo, na yɛrennom mo abura mu nsuo.” ");
INSERT INTO twiasante_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Nanso ɔhene Sihon ampene so. Na mmom, ɔboaboaa nʼakodɔm ano kɔto hyɛɛ Israelfoɔ so wɔ ɛserɛ so hɔ ne wɔn koo wɔ Yahas. ");
INSERT INTO twiasante_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Nanso Israelfoɔ no kunkumm wɔn faa wɔn asase a ɛfiri Asubɔnten Arnon kɔsi asuo Yabok ho toaa so kɔsii Amorifoɔ ahyeɛ so, nanso wɔkɔhyiaa Amon mma ahoɔdenfoɔ bi a wɔakyere sraban enti wɔantumi anko ankɔ wɔn anim bio. ");
INSERT INTO twiasante_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Enti Israelfoɔ no faa Amorifoɔ no nkuro akɛseɛ nyinaa a Hesbon kuropɔn ne ne nkuraase nyinaa ka ho tenaa mu. ");
INSERT INTO twiasante_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Na Hesbon yɛ Amorifoɔhene Sihon Kuropɔn. Sihon na ɛda bi ɔko tiaa Moabhene faa ne nsase nyinaa bɛsii Asubɔnten Arnon no. ");
INSERT INTO twiasante_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ne sei enti tete, anwensɛm twerɛfoɔ twerɛɛ yei faa ne ho sɛ, “Bra Hesbon, Sihon kuropɔn, yɛnkyekyere na ɛnsi ne dada mu. ");
INSERT INTO twiasante_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Egya turi firii Hesbon Ogyaframa firii Sihon ahenkuro mu, Ɛhyee Ar kuropɔn a ɛwɔ Moab; ɛsɛee sodifoɔ a wɔwɔ Arnon mmepɔ so. ");
INSERT INTO twiasante_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ao Moabfoɔ, mosɛeɛ bɛba mu! Wɔawie mo, mo a mosom Kemos! Kemos agya ne mmammarima sɛ atutenafoɔ, Ne ne mmammaa sɛ Amorifoɔhene Sihon nnommumfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Yɛasɛe wɔn pasaa, ɛfiri Hesbon tɔnn kɔsi Dibon. Yɛasɛe wɔn ara akɔsi Nofa De kɔ ara kɔsi Medeba.” ");
INSERT INTO twiasante_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Enti Israelfoɔ no tenaa Amorifoɔ asase so. ");
INSERT INTO twiasante_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mose somaa akwansrafoɔ sɛ wɔnkɔsrasra Yaser fa mu hɔ. Ɔde asraafoɔ toaa wɔn, faa wɔn nkuro nyinaa, pamoo Amorifoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Afei, wɔde wɔn ani kyerɛɛ kuro kɛseɛ Basan, nanso Basanhene Og de nʼasraafoɔ hyiaa wɔn wɔ Edrei. ");
INSERT INTO twiasante_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Awurade ka kyerɛɛ Mose sɛ ɔnnsuro na wadi atamfoɔ no so dada. Awurade sane hyɛɛ Mose nkuran sɛ asɛm a ɛtoo ɔhene Sihon wɔ Hesbon no, saa asɛm korɔ no ara bi na ɛbɛto no. ");
INSERT INTO twiasante_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ampa ara, Israelfoɔ dii nkonim na wɔkumm ɔhene Og ne ne mmammarima ne ne nkurɔfoɔ nyinaa a anka wɔn mu baako mpo. Enti Israelfoɔ no tenaa asase no so. ");
INSERT INTO twiasante_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Afei, Israelfoɔ no kɔɔ Moab tata so kɔtenaa Asubɔnten Yordan apueeɛ fam a ɛhɔ ne Yeriko di nhwɛanimu no. ");
INSERT INTO twiasante_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Sipor babarima Moabhene Balak hunuu deɛ Israelfoɔ ayɛ Amorifoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Ɛberɛ a ɔhunuu Israelfoɔ dodoɔ a wɔwɔ hɔ no, ɔne ne nkurɔfoɔ bɔɔ huboa. ");
INSERT INTO twiasante_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ntɛm ara, wɔne Midian mpanimfoɔ tuu agyina. Wɔkaa sɛ, “Saa dɔm yi bɛwe biribiara a wɔhunu sɛdeɛ nantwie we serɛ.” Enti, Moab ɔhene Balak ");
INSERT INTO twiasante_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","somaa nnipa ma wɔkɔɔ Beor babarima Balaam nkyɛn wɔ Petor a ɛbɛn Asubɔnten Eufrate ho. Ɔsrɛɛ Balaam sɛ ɔmmɛboa no. Ɔkaa sɛ, “Nnipadɔm bi firi Misraim aba. Wɔkata asase ani nyinaa na wɔrehunahuna me. ");
INSERT INTO twiasante_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Mɛsrɛ wo, bra na bɛdome wɔn ma me, ɛfiri sɛ wɔdɔɔso dodo. Ebia metumi adi wɔn so nkonim na mapam wɔn afiri asase no so. Na menim nhyira a ɛba wɔn a wohyira wɔn no so, ɛnna menim musuo a ɛba wɔn a wodome wɔn so.” ");
INSERT INTO twiasante_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Nnipa a ɔsomaa wɔn no yɛ atitire a wɔfiri Moab ne Midian. Wɔfaa sika sɛ wɔde rekɔtua Balaam ka ama wadome Israelfoɔ. Enti wɔkɔɔ Balaam nkyɛn kɔkaa deɛ ɛhia Balak kyerɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam kaa sɛ, “Monna ma adeɛ nkye mo. Adeɛ kye a, deɛ Awurade bɛkyerɛ me sɛ menyɛ no, mɛka akyerɛ mo.” Enti wɔdaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Anadwo no, Onyankopɔn baa Balaam nkyɛn bɛbisaa no sɛ, “Saa nnipa yi yɛ ɛhefoɔ?” ");
INSERT INTO twiasante_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Ɔbuaa sɛ, “Wɔfiri Moabhene Balak nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Na nnipadɔm bi firi Misraim aba ne hyeɛ so, na ɔpɛ sɛ mekɔ hɔ ntɛm so na mekɔdome wɔn sɛdeɛ ɛbɛyɛ a, ɔbɛtumi adi wɔn so.” ");
INSERT INTO twiasante_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Onyankopɔn ka kyerɛɛ no sɛ, “Nkɔ. Ɛnsɛ sɛ wodome wɔn, ɛfiri sɛ, mahyira wɔn!” ");
INSERT INTO twiasante_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Adeɛ kyeeɛ no, anɔpa, Balaam ka kyerɛɛ nnipa no sɛ, “Monsane nkɔ fie! Awurade rempene mma mennyɛ saa.” ");
INSERT INTO twiasante_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Enti, ɔhene Balak ananmusifoɔ no sane wɔn akyi bɛbɔɔ amaneɛ sɛ ɔse ɔremma. ");
INSERT INTO twiasante_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak sɔ hwɛɛ bio. Saa ɛberɛ no deɛ, ɔsomaa nnipa dodoɔ pa ara a animuonyamfoɔ a wɔkyɛn kane dɔm no fra wɔn mu. ");
INSERT INTO twiasante_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Wɔbaa Balaam nkyɛn bɛka kyerɛɛ no sɛ, “Ɔhene Balak se ɔsrɛ wo sɛ bra. ");
INSERT INTO twiasante_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ɔbɛhyɛ wo animuonyam na sika biara a wɔbɛgye no no nso, ɔbɛtua. Ka sika a wobɛgye! Ɔse, wo deɛ, bra na bɛdome saa nnipa no ma yɛn.” ");
INSERT INTO twiasante_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Nanso, Balaam buaa sɛ, “Sɛ ɔma me ahemfie a wɔde dwetɛ ne sikakɔkɔɔ ahyɛ no ma tɔ koraa a, merentumi nyɛ biribiara mmu saa ahyɛdeɛ a Awurade a ɔyɛ me Onyankopɔn no ahyɛ no so. ");
INSERT INTO twiasante_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Nanso, monna ha ma adeɛ nkye na yɛnhwɛ sɛ Awurade bɛka asɛm foforɔ bi aka deɛ waka dada no ho anaa.” ");
INSERT INTO twiasante_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Anadwo no, Onyankopɔn ka kyerɛɛ Balaam sɛ, “Sɔre na wo ne saa nnipa no nkɔ na mmom, hwɛ yie na yɛ deɛ mɛkyerɛ wo sɛ yɛ no nko ara.” ");
INSERT INTO twiasante_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Adeɛ kyee anɔpa no, ɔhyehyɛɛ nʼafunumu, tenaa ne so ne wɔn hyɛɛ aseɛ kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Nanso, Onyankopɔn bo fuu Balaam ahopere a ɔde kɔeɛ no; enti ɔsomaa ɔsoro Awurade ɔbɔfoɔ kɔgyinaa akwantemfi sɛ ɔnkum no wɔ hɔ. Ɛberɛ a Balaam ne asomfoɔ baanu rekorɔ no, ");
INSERT INTO twiasante_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","prɛko pɛ, Balaam afunumu no hunuu Awurade ɔbɔfoɔ no sɛ ɔkura sekan gyina ɛkwan no mfimfini. Aboa no kwae faa wiram nanso Balaam kaa ne so sɛdeɛ ɛbɛyɛ a, ɔbɛfa ɛkwan mu. ");
INSERT INTO twiasante_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Baabi a na Awurade ɔbɔfoɔ no gyina hɔ no yɛ bobefuo afasuo mmienu ntam. ");
INSERT INTO twiasante_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ɛberɛ a afunumu no hunuu Awurade ɔbɔfoɔ no, ɔde ne ho twee ɔfasuo no ho maa Balaam nan pɛkyɛeɛ. Nanso, Balaam kɔɔ so hwee aboa no bio. ");
INSERT INTO twiasante_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Afei, Awurade ɔbɔfoɔ no kɔɔ ɛkwan no anafoɔ kɔgyinaa baabi a ɛhɔ kyere pa ara a na afunumu no nnya baabi mfa. ");
INSERT INTO twiasante_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Enti, ɔbutuu ɛkwan no mu. Balaam de abufuo kaa aboa no mmaa. ");
INSERT INTO twiasante_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Afei, Awurade hyɛɛ afunumu no ma ɔkasaeɛ! Ɔbisaa ne wura no sɛ, “Ɛdeɛn na mayɛ enti a ɛsɛ sɛ wohwe me mprɛnsa?” ");
INSERT INTO twiasante_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam nso buaa no sɛ, “Ɛfiri sɛ, woama masɛ ɔkwasea. Na sɛ mekura sekan a, anka mɛkum wo.” ");
INSERT INTO twiasante_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Afunumu no nso bisaa no sɛ, “Me ne wo tenaeɛ yi, mayɛ sei pɛn?” Ne wura no buaa sɛ, “Dabi.” ");
INSERT INTO twiasante_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Afei, Awurade buee Balaam ani ma ɔhunuu ɔsoro ɔbɔfoɔ no sɛ watwe sekan gyina ɛkwan no mfimfini enti ɔkɔbutuu nʼanim. ");
INSERT INTO twiasante_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Awurade ɔbɔfoɔ no bisaa no sɛ, “Adɛn enti na wohwe wʼafunumu no mprɛnsa saa? Maba sɛ merebɛka ama woagyae, ɛfiri sɛ, worepɛ adeɛ asɛe. ");
INSERT INTO twiasante_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Afunumu no hunuu me mprɛnsa a emu biara ɔkwae faa baabi; anyɛ saa a, anka mɛkum wo na magyaa no.” ");
INSERT INTO twiasante_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Afei, Balaam ka kyerɛɛ Awurade ɔbɔfoɔ no sɛ, “Mafom. Na mennim sɛ wowɔ hɔ. Sɛ wompɛ sɛ metoa mʼakwantuo no so deɛ a, meresane akɔ efie.” ");
INSERT INTO twiasante_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Nanso, Awurade ɔbɔfoɔ no ka kyerɛɛ no sɛ, “Wo ne nnipa no nkɔ, nanso asɛm a mɛka akyerɛ wo no nko na ka.” Enti Balaam ne wɔn kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ɛberɛ a ɔhene Balak tee sɛ Balaam reba no, ɔfirii kuro no mu kɔhyiaa no Asubɔnten Arnon ho wɔ ne hyeɛ so. ");
INSERT INTO twiasante_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ɔbisaa Balaam sɛ, “Adɛn enti na wokyɛɛ saa? Anaasɛ, mehyɛɛ wo bɔ sɛ mɛhyɛ wo animuonyam no na wonnye nni?” ");
INSERT INTO twiasante_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam buaa sɛ, “Ɛwom sɛ maba deɛ, nanso menni tumi biara a mɛka asɛm biara agye asɛm a Onyankopɔn bɛka akyerɛ me sɛ menka no nko na mɛka.” ");
INSERT INTO twiasante_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam kaa ɔhene no ho ne no kɔɔ Kiria-Husot, ");
INSERT INTO twiasante_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","baabi a ɔhene Balak de anantwie ne nnwan bɔɔ afɔdeɛ na ɔde mmoa no bi maa Balaam ne ne mpanimfoɔ sɛ wɔmfa mmɔ afɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Adeɛ kyee anɔpa no, Balak faa Balaam de no kɔɔ Bamot-Baal atifi. Ɔfiri hɔ too nʼani hunuu sɛ Israelfoɔ no sam aseɛ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam ka kyerɛɛ ɔhene no sɛ, “Si afɔrebukyia nson wɔ ha, na siesie anantwie mma nson ne nnwennini nson fa wɔn bɔ afɔdeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak tiee Balaam asɛm no, enti ɔde nantwie ba ne odwennini ba bɔɔ afɔrebukyia nson no biara so afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Afei Balaam ka kyerɛɛ ɔhene no sɛ, “Sɔre gyina wo ɔhyeɛ afɔdeɛ no ho na mɛhwɛ sɛ Awurade bɛhyia me, na asɛm a ɔbɛka akyerɛ me no nso, mɛka akyerɛ wo.” Enti, ɔforo kɔɔ apampam baabi. ");
INSERT INTO twiasante_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ɛhɔ na Onyankopɔn hyiaa no. Balaam ka kyerɛɛ Awurade sɛ, “Masiesie afɔrebukyia nson. Mabɔ afɔrebukyia no biara so nantwie ba ne odwennini ba afɔdeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Afei, Awurade de nkra maa Balaam sɛ ɔnkɔka nkyerɛ ɔhene Balak. ");
INSERT INTO twiasante_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ɛberɛ a Balaam sane baeɛ no, na ɔhene no ne ahenemma a wɔfiri Moab no gyina ɔhyeɛ afɔdeɛ no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Nkɔmhyɛ a Balaam de maaeɛ no nie: “Ɔhene Balak soma bɛfrɛɛ me firii Aram. Moabhene frɛɛ me firii apueeɛ fam nkokoɔ so. Ɔkaa sɛ, ‘Bra bɛdome Yakob ma me! Bra bɛka mmusuo a ɛbɛba Israelfoɔ so.’ ");
INSERT INTO twiasante_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ɛbɛyɛ dɛn na matumi madome wɔn a Onyankopɔn nnomee wɔn? Ɛbɛyɛ dɛn na matumi abu wɔn fɔ, nnipa a Awurade mmuu wɔn fɔ? ");
INSERT INTO twiasante_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Mehunu wɔn firi abotan atifi; mehwɛ wɔn firi nkokoɔ so. Mehunu nnipa a wɔte wɔn ho ase, a wɔayi wɔn afiri amanaman mu. ");
INSERT INTO twiasante_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Hwan na ɔbɛtumi akan Yakob asefoɔ, wɔdɔɔso sɛ mfuturo? Hwan na ɔbɛtumi akan Israelfoɔ nkyɛmu ɛnan mu baako? Ma menwu sɛ ɔteneneeni; na mawieɛ nyɛ sɛ wɔn deɛ.” ");
INSERT INTO twiasante_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Ɔhene Balak bisaa Balaam sɛ, “Ɛdeɛn na woayɛ me yi? Mede wo baa sɛ bɛdome mʼatamfoɔ, nanso woahyira wɔn!” ");
INSERT INTO twiasante_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Nanso, Balaam buaa sɛ, “Metumi aka biribi a Awurade nkaa sɛ menka anaa?” ");
INSERT INTO twiasante_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Afei, Balak ka kyerɛɛ no sɛ, “Bra na yɛnkɔ baabi foforɔ. Yɛduru hɔ a, wobɛhunu ɔman Israel fa bi wɔ hɔ. Dome wɔn a wobɛhu wɔn wɔ hɔ no nyinaa.” ");
INSERT INTO twiasante_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ɔhene Balak faa Balaam de no kɔɔ Sofim bepɔ Pisga atifi. Ɔsii afɔrebukyia nson wɔ hɔ. Ɛnna ɔde nantwie ba ne odwennini bɔɔ afɔrebukyia biara so afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Afei, Balaam ka kyerɛɛ ɔhene no sɛ, “Gyina wo ɔhyeɛ afɔdeɛ no ho wɔ ha na me nso merekɔhyia Awurade.” ");
INSERT INTO twiasante_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Awurade hyiaa Balaam na ɔkaa asɛm a ɔnkɔka kyerɛɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Enti, ɔsane baa baabi a ɔhene no ne Moab ahenemma no wɔ a wɔgyina wɔn ɔhyeɛ afɔdeɛ no ho. Ɔhene no de ahopere bisaa sɛ, “Awurade aka sɛn?” ");
INSERT INTO twiasante_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Nkɔmhyɛ a Balaam de maaeɛ no nie: “Balak, sɔre na tie; Sipor babarima tie me. ");
INSERT INTO twiasante_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Onyankopɔn nnyɛ onipa na wadi atorɔ; Ɔnyɛ onipa na wasesa nʼadwene. Wakasa a wanyɛ anaa? Wahyɛ bɔ bi pɛn a wanni so anaa? ");
INSERT INTO twiasante_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Wɔhyɛɛ me sɛ menhyira; wahyira, na merentumi nnane no! ");
INSERT INTO twiasante_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Menhunu amanehunu bi a ɛbɛba Yakob so. Ɔhaw biara nni hɔ mma Israel! Awurade, wɔn Onyankopɔn ka wɔn ho. Ɔne wɔn ɔhene! ");
INSERT INTO twiasante_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Onyankopɔn ayi wɔn afiri Misraim; ɔte sɛ nantwie hoɔdenfoɔ ma wɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Nnome biara renka Yakob, abayisɛm biara nni tumi wɔ Israel so. Na wɔbɛka wɔ Yakob ho sɛ, ‘Hwɛ anwanwadeɛ a Onyankopɔn ayɛ ama Israel!’ ");
INSERT INTO twiasante_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Saa nnipa yi sɔre sɛ gyataburu. Wɔgyina hɔ sɛ gyata hoɔdenfoɔ. Ɔnnye nʼahome kɔsi sɛ ɔbɛwe nʼahaboa awie na wanom ne mogya nyinaa!” ");
INSERT INTO twiasante_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ɔhene no ka kyerɛɛ Balaam sɛ, “Sɛ worennome wɔn a, ɛnneɛ nhyira wɔn.” ");
INSERT INTO twiasante_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Nanso Balaam buaa no sɛ, “Manka ankyerɛ wo sɛ asɛm a Awurade bɛka akyerɛ me sɛ menka no na mɛka?” ");
INSERT INTO twiasante_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Afei, ɔhene no ka kyerɛɛ Balaam sɛ, “Mede wo bɛkɔ baabi foforɔ. Ebia, ɛhɔ bɛyɛ anisɔ ama Onyankopɔn sɛ wobɛgyina hɔ adome wɔn.” ");
INSERT INTO twiasante_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Enti, ɔhene Balak faa Balaam de no kɔɔ bepɔ Peor a ani kyerɛ anweatam no atifi pɛɛ so. ");
INSERT INTO twiasante_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Bio, Balaam ka kyerɛɛ ɔhene no sɛ ɔnsi afɔrebukyia nson na ɔnsiesie nantwie mma nson ne nnwennini mma nson mma afɔrebɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Ɔhene no yɛɛ deɛ Balaam kaeɛ no, enti ɔde nantwie ba ne odwennini ba bɔɔ afɔdeɛ wɔ afɔrebukyia nson no biara so. ");
INSERT INTO twiasante_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Afei, Balaam hunuu sɛ Awurade pɛ sɛ ɔhyira Israel. Yei enti, wankɔ abisa sɛdeɛ ɔtaa yɛ no. Na mmom, ɔtoo nʼani hwɛɛ ɛserɛ no so, ");
INSERT INTO twiasante_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","hunuu sɛ Israelfoɔ mmusuakuo no abobɔ wɔn atenaeɛ. Afei, Onyankopɔn honhom baa ne so, ");
INSERT INTO twiasante_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","na yei ne nkɔmhyɛ a ɔmaaeɛ: “Beor ba Balaam nkɔmhyɛ no nie; nkɔmhyɛ a ɛfiri ɔbarima a nʼani hunu adeɛ yie, ");
INSERT INTO twiasante_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","deɛ ɔte Onyankopɔn asɛm; deɛ ɔhunu anisoadeɛ a ɛfiri Otumfoɔ hɔ; na ɔda fam, a nʼani gu so: ");
INSERT INTO twiasante_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Ao Yakob, mo ntomadan yɛ fɛ, Ao Israel, mo afie yɛ ahomeka. ");
INSERT INTO twiasante_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Ɛsam mʼanim te sɛ mmɛfuo, te sɛ nturo frɔmfrɔm wɔ asubɔnten ho. Wɔte sɛ pɛperɛ a Awurade adua, te sɛ ntweneduro a ɛbɛn nsuo ho. ");
INSERT INTO twiasante_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Wɔbɛnya nsuo bebree. Wɔn mma bɛnya deɛ ɛhia wɔn nyinaa. “Wɔn ɔhene bɛyɛ kɛse akyɛn Agag; wɔn ahennie bɛkorɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Onyankopɔn de wɔn firi Misraim aba; ɔtwee wɔn sɛ wiram nantwie. Ɔsɛe amanaman a wɔtia no nyinaa, ɔbubu wɔn nnompe mu asinasini, ɔto bɛmma wowɔ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Israel butu hɔ sɛ gyata; ɔte sɛ gyataburu, na hwan na ɔbɛtumi anyane no? “Ao Israel, nhyira nka obiara a ɔhyira wo, na nnome nka obiara a ɔdome wo.” ");
INSERT INTO twiasante_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ɔhene Balak bo fuu Balaam. Ɔde Abufuo bɔɔ ne nsam guu ne so teaam sɛ, “Mefrɛɛ wo sɛ bɛdome, mʼatamfoɔ nanso woahyira wɔn mprɛnsa. ");
INSERT INTO twiasante_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Firi me so kɔ! Sane kɔ wo nkyi! Meyɛɛ mʼadwene sɛ anka mɛhyɛ wo animuonyam, nanso, Awurade de akame wo!” ");
INSERT INTO twiasante_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam buaa no sɛ, “Wonkae asɛm a meka kyerɛɛ wʼasomafoɔ no? Mekaa sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Sɛ Balak ma me ahemfie a wɔde dwetɛ ne sikakɔkɔɔ ahyɛ hɔ ma koraa a, menni tumi sɛ mɛyɛ biribi atia Awurade apɛdeɛ.’ Meka kyerɛɛ wo sɛ asɛm a Awurade aka no nko ara na mɛka. ");
INSERT INTO twiasante_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Afei, meresane akɔ me nkurɔfoɔ nkyɛn. Nanso, deɛ ɛdi ɛkan no, ma menka deɛ Israelfoɔ no bɛyɛ wo nkurɔfoɔ daakye no nkyerɛ wo.” ");
INSERT INTO twiasante_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Yei ne nkɔmhyɛ a Balaam de maeɛ: “Beor ba Balaam nkɔmhyɛ no nie; nkɔmhyɛ a ɛfiri ɔbarima a nʼani hunu adeɛ yie, ");
INSERT INTO twiasante_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","deɛ ɔte Onyankopɔn asɛm; deɛ ɔwɔ nyansa a ɛfiri Ɔsorosoroni no deɛ ɔhunu anisoadeɛ a ɛfiri Otumfoɔ hɔ; na ɔda fam, a nʼani gu so: ");
INSERT INTO twiasante_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Mɛhunu no, nanso ɛnyɛ seesei; mehwɛ no wɔ daakye akyirikyiri. Nsoromma bɛpue afiri Yakob mu! Ahempoma bɛfiri Israel mu. Ɔbɛyam Moabfoɔ tiri, na wapaapae Moab mma tikwankora. ");
INSERT INTO twiasante_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Wɔbɛfa Edom, na Seir a ɔyɛ ne ɔtamfoɔ no, wɔbɛdi ne so nkonim, na Israel bɛkɔ so adi nkonim. ");
INSERT INTO twiasante_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Ɔhene bi bɛsɔre wɔ Yakob mu ɔno na ɔbɛsɛe Ir nkaeɛfoɔ.” ");
INSERT INTO twiasante_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Afei, Balaam hwɛɛ Amalekfoɔ fie hyɛɛ nkɔm sɛ, “Amalek na na ɛyɛ aman nyinaa abakan, nanso ne hyɛberɛ ne ɔsɛeɛ!” ");
INSERT INTO twiasante_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Afei, ɔhwɛɛ Kenifoɔ hyɛɛ nkɔm sɛ, “Mo atenaeɛ yɛ pa ara, wanwono mo pirebuo wɔ abotan mu. ");
INSERT INTO twiasante_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Nanso, wɔbɛsɛe Kenifoɔ ɛberɛ a Asurhene afa mo nnomum.” ");
INSERT INTO twiasante_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Nsɛm a ɔde wiee ne nkɔmhyɛ no ne sɛ: “Aa, sɛ Onyankopɔn yɛ sei a, hwan na ɔbɛtena nkwa mu? ");
INSERT INTO twiasante_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ahyɛn bɛfiri Kipro mpoano aba Na abɛka Eber ne Asur ahyɛ. Nanso wɔn nso, wɔbɛsɛe wɔn pasaa.” ");
INSERT INTO twiasante_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Enti, Balaam ne Balak sane kɔɔ wɔn kurom. ");
INSERT INTO twiasante_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ɛberɛ a Israelfoɔ bɔɔ atenaseɛ wɔ Sitim no, wɔn mu mmarima no bi hyɛɛ aseɛ ne Moab mmabaawa no bɔɔ adwaman de guu wɔn ho fi. ");
INSERT INTO twiasante_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Saa mmabaawa yi too nsa frɛɛ wɔn sɛ wɔmmra wɔn afɔdeɛ a wɔbɔ ma wɔn anyame no ase. Ankyɛre biara, mmarima no kɔɔ wɔn apontoɔ ase na wɔsomm Moab anyame. ");
INSERT INTO twiasante_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ɛberɛ tiawa bi akyi, Israelfoɔ no nyinaa kɔsom Baal-peor a ɔyɛ Moabfoɔ nyame. Yei maa Awurade bo fuu ne nkurɔfoɔ no yie. ");
INSERT INTO twiasante_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ɔhyɛɛ saa mmara yi maa Mose sɛ, “Kunkum mpanimfoɔ a wɔtuatua Israel mmusuakuo no ano no nyinaa. Sɛn wɔn wɔ Awurade anim awia ketee sɛdeɛ ɛbɛyɛ a, nʼabufuo a ano yɛ den no bɛfiri wɔn so.” ");
INSERT INTO twiasante_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Enti, Mose hyɛɛ atemmufoɔ no ma wɔkunkumm wɔn a wɔsomm Baal-peor no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Nanso, Israelni ɔhantanni bi de Midiani ababaawa bi baa wɔn atenaeɛ hɔ maa Mose ne nnipa no nyinaa hunuu no ɛberɛ a na wɔn nyinaa gyina Ahyiaeɛ Ntomadan no ɛpono akyi retwa adwo no. ");
INSERT INTO twiasante_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ɛberɛ a Pinehas a ɔyɛ Eleasa babarima a na ɔyɛ ɔsɔfoɔ Aaron nana hunuu yei no, ɔhuri sɔɔ pea mu ");
INSERT INTO twiasante_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","taa saa ɔbarima no so de no kɔwuraa ne ntomadan mu baabi a ɔfaa ɔbaa no. Ɔde pea no wowɔɔ ɔbarima no sane de wɔɔ ɔbaa no yafunu mu. Enti, ɔhaw no to twaa wɔ Israelfoɔ no mu, ");
INSERT INTO twiasante_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","nanso ɛkɔsi saa ɛberɛ no, na nnipa mpem aduonu ɛnan awuwu dada. ");
INSERT INTO twiasante_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Eleasa babarima Pinehas a ɔyɛ ɔsɔfoɔ Aaron nana adwodwo mʼabufuo ano, ɛfiri sɛ, ɔbɔɔ mmɔden te sɛ me ara wɔ mʼanimuonyam ho, enti sɛdeɛ meyɛɛ mʼadwene sɛ mɛsɛe Israelfoɔ nyinaa no, magyae. ");
INSERT INTO twiasante_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Enti ka kyerɛ no sɛ, me ne no rebɛyɛ asomdwoeɛ apam. ");
INSERT INTO twiasante_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Saa apam yi mu, ɔno ne nʼasefoɔ bɛyɛ asɔfoɔ afebɔɔ, ɛfiri sɛ watwe me, ne Onyankopɔn, ho ninkunu wɔ Israelfoɔ mu de ayɛ mpata ama wɔn.” ");
INSERT INTO twiasante_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ɔbarima a wɔkumm no ne Midiani ababaawa no, na ne din de Simri a na ɔyɛ Salu a ɔtua Simeon abusuakuo ano no babarima. ");
INSERT INTO twiasante_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ɔbaa no nso, na ne din de Kosbi a na ɔyɛ Midianhene babarima Sur babaa. ");
INSERT INTO twiasante_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“To hyɛ Midianfoɔ no so na sɛe wɔn, ");
INSERT INTO twiasante_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ɛfiri sɛ, wɔfaa mo sɛ atamfoɔ, na wɔdaadaa mo ma mosomm Baal-peor, ne Kosbi a ɔyɛ Midian ntuanoni babaa a wɔkumm no wɔ Peor ɔyaredɔm ɛda no.” ");
INSERT INTO twiasante_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ɔyaredɔm no akyi no, Awurade ka kyerɛɛ Mose ne ɔsɔfoɔ Aaron babarima Eleasa sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Monkan Israelfoɔ mmarima a wɔadi mfeɛ aduonu ne deɛ ɛboro saa nyinaa na monhwɛ dodoɔ a wɔbɛtumi akɔ ɔsa wɔ abusua biara mu.” ");
INSERT INTO twiasante_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Saa ɛberɛ no, na Israelman no nyinaa abɔ atenaeɛ wɔ Moab tata so, wɔ Asubɔnten Yordan ho a na wɔne Yeriko di nhwɛanimu. Enti Mose ne ɔsɔfoɔ Eleasa kaa nhyehyɛeɛ a ɛfa nnipakan no ho kyerɛɛ Israelfoɔ ntuanofoɔ no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Monkan mmarima a wɔwɔ Israel a wɔadi mfeɛ aduonu ne deɛ ɛboro saa sɛdeɛ Awurade hyɛɛ Mose no.” Sɛdeɛ nnipakan no a ɛfa Israel mma a wɔfiri Misraim baeɛ no ano kɔsiiɛ nie. ");
INSERT INTO twiasante_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Yeinom ne mmusua a wɔyɛ Yakob babarima panin Ruben asefoɔ: Hanokfoɔ abusua, wɔde too wɔn tete agya Hanok; Palufoɔ abusua, wɔde too a wɔn tete agya Palu; ");
INSERT INTO twiasante_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hesronfoɔ abusua, wɔde too wɔn tete agya Hesron; Karmifoɔ abusua, wɔde too wɔn tete agya Karmi. ");
INSERT INTO twiasante_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Mmarima a na wɔwɔ Ruben mmusua nyinaa mu no dodoɔ yɛ mpem aduanan mmiɛnsa ahanson aduasa (43,730). ");
INSERT INTO twiasante_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Na Palu yɛ Eliab aseni, ");
INSERT INTO twiasante_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","na Nemuel na ɔwoo Eliab, Datan ne Abiram. Saa Datan ne Abiram yi ara na wɔyɛ nnipa no ntuanofoɔ a wɔne Kora yɛɛ adwene tiaa Mose ne Aaron, de buu Awurade animtia. ");
INSERT INTO twiasante_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Na asase mu bue menee wɔn ne Kora. Egya firi Awurade nkyɛn bɛsɛee wɔn akyidifoɔ ahanu aduonum. Yei yɛɛ kɔkɔbɔ maa Israelman nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Nanso, Kora mmammarima deɛ, wɔanwuwu da no. ");
INSERT INTO twiasante_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Yeinom ne mmusua a wɔfiri Simeon mmammarima mu: Nemuelfoɔ abusua, wɔde too wɔn tete agya Nemuel. Yaminfoɔ abusua, wɔde too wɔn tete agya Yamin. Yakinfoɔ abusua, wɔde too wɔn tete agya Yakin. ");
INSERT INTO twiasante_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Serafoɔ abusua, wɔde too wɔn tete agya Serah; Saulfoɔ abusua, wɔde too wɔn tete agya Saulo. ");
INSERT INTO twiasante_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Mmarima a na wɔwɔ Simeon mmusua mu nyinaa dodoɔ yɛ mpem aduonu mmienu ne ahanu. ");
INSERT INTO twiasante_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Yeinom ne mmusua a wɔfiri Gad mmammarima mu: Sefonfoɔ abusua, wɔde too wɔn tete agya Sefon; Hagifoɔ abusua, wɔde too wɔn tete agya Hagi. Sunifoɔ abusua no, wɔde too wɔn tete agya Suni. ");
INSERT INTO twiasante_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Osnifoɔ abusua, wɔde too wɔn tete agya Osni. Erifoɔ abusua, wɔde too wɔn tete agya Eri; ");
INSERT INTO twiasante_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arodfoɔ abusua, wɔde too wɔn agya Arod. Arelifoɔ abusua, wɔde too wɔn tete agya Areli. ");
INSERT INTO twiasante_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Mmarima a na wɔwɔ Gad mmusua mu no dodoɔ yɛ mpem aduanan ne ahanum (40,500). ");
INSERT INTO twiasante_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Na Yuda wɔ mmammarima baanu a wɔn edin de Er ne Onan a na wɔawuwu wɔ Kanaan asase so. ");
INSERT INTO twiasante_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Nanso, mmusua a ɛdidi so yi firi Yuda mmammarima a na wɔte ase no ase. Selafoɔ abusua, wɔde too wɔn tete agya Sela. Peresfoɔ abusua, wɔde too wɔn tete agya Peres. Serafoɔ abusua, wɔde too wɔn tete agya Serah. ");
INSERT INTO twiasante_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Yeinom ne mmusua nketewa wɔfiri Peresfoɔ ase. Hesronfoɔ abusua, a wɔde too wɔn tete agya Hesron. Hamulfoɔ abusua, wɔde too wɔn tete agya Hamul. ");
INSERT INTO twiasante_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Mmarima a na wɔwɔ Yuda mmusua mu no nyinaa dodoɔ yɛ mpem aduɔson nsia ne ahanum. ");
INSERT INTO twiasante_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Yeinom ne mmusua a wɔfiri Isakar mmammarima ase: Tolafoɔ abusua, wɔde too wɔn tete agya Tola. Puwafoɔ abusua, wɔde too wɔn tete agya Puwa. ");
INSERT INTO twiasante_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yasubfoɔ abusua, wɔde too wɔn tete agya Yasub. Simronfoɔ abusua, wɔde too wɔn tete agya Simron. ");
INSERT INTO twiasante_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Mmarima a na wɔwɔ Isakar mmusua no mu no nyinaa dodoɔ yɛ mpem aduosia nan ne ahasa (64,300). ");
INSERT INTO twiasante_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Yeinom ne mmusua a wɔfiri Sebulon mmammarima ase: Seredfoɔ abusua, wɔde too wɔn tete agya Sered. Elonfoɔ abusua, wɔde too wɔn tete agya Elon. Yakleefoɔ abusua, wɔde too wɔn tete agya Yakleel. ");
INSERT INTO twiasante_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Mmarima a na wɔwɔ Sebulon mmusua no mu no nyinaa dodoɔ yɛ mpem aduosia ne ahanum. ");
INSERT INTO twiasante_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ɛnam Manase ne Efraim so na mmusua mmienu firii Yosef mu baeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manase asefoɔ: Makirfoɔ abusua, wɔde too wɔn tete agya Makir. Gileadfoɔ abusua, wɔde too wɔn tete agya, Makir babarima, Gilead. ");
INSERT INTO twiasante_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Yeinom ne mmusua nketewa a wɔfiri Gileadfoɔ ase: Yeserfoɔ abusua, wɔde too wɔn tete agya Yeser. Helekfoɔ abusua, wɔde too wɔn agya Helek. ");
INSERT INTO twiasante_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asrielfoɔ abusua, wɔde too wɔn tete agya Asriel. Sekemfoɔ abusua, wɔde too wɔn tete agya Sekem. ");
INSERT INTO twiasante_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semidafoɔ abusua, wɔde too wɔn tete agya Semida. Heferfoɔ abusua, wɔde too wɔn tete agya Hefer. ");
INSERT INTO twiasante_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Na Hefer babarima Selofehad annya mmammarima nanso na ɔwɔ mmammaa a wɔn edin de Mahla, Noa, Hogla, Milka ne Tirsa. ");
INSERT INTO twiasante_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Mmarima a na wɔwɔ Manase mmusua no nyinaa mu dodoɔ yɛ mpem aduonum mmienu ne ahanson (52,700). ");
INSERT INTO twiasante_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Yeinom ne mmusua a wɔfiri Efraim mmammarima ase: Sutelafoɔ abusua, wɔde too wɔn tete agya Sutela. Bekerfoɔ abusua, wɔde too wɔn tete agya Beker. Tahanfoɔ abusua, wɔde too wɔn tete agya Tahan. ");
INSERT INTO twiasante_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Na yei yɛ abusua nketewa a wɔfiri Sutela ase: Eranfoɔ abusua, wɔde too wɔn tete agya Eran. ");
INSERT INTO twiasante_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Mmarima a na wɔwɔ Efraim mmusua nketewa no nyinaa mu dodoɔ yɛ mpem aduasa mmienu ne ahanum (32,500). Manase ne Efraim mmusua nyinaa yɛ Yosef asefoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Yeinom ne mmusua a wɔfiri Benyamin mmammarima mu. Belafoɔ abusua no, wɔde too wɔn tete agya Bela. Asbelfoɔ abusua no, wɔde too wɔn tete agya Asbel. Ahiramfoɔ abusua no, wɔde too wɔn tete agya Ahiram. ");
INSERT INTO twiasante_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sufamfoɔ abusua no, wɔde too wɔn tete agya Sufam. Hufamfoɔ abusua no, wɔde too wɔn tete agya Hufam. ");
INSERT INTO twiasante_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Yeinom ne mmusua a wɔfiri Belafoɔ mu. Ardfoɔ a wɔde too wɔn tete agya Ard. Naamanfoɔ a wɔde too wɔn tete agya Naaman. ");
INSERT INTO twiasante_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Na mmarima a na wɔwɔ Benyamin mmusua no mu nyinaa dodoɔ yɛ mpem aduanan enum ne ahansia (45,600). ");
INSERT INTO twiasante_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Yei ne abusua a ɛfiri Dan babarima asefoɔ mu. Suhamfoɔ abusua no, wɔde too wɔn tete agya Suham. Na Dan mmusua no nyinaa yɛ Suhamfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Mmarima a na wɔwɔ saa mmusua no mu nyinaa dodoɔ yɛ mpem aduosia ɛnan ne ahanan (64,400). ");
INSERT INTO twiasante_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Yeinom ne mmusua a wɔfiri Aser mmammarima mu. Yimnafoɔ abusua no, wɔde too wɔn tete agya Yimna. Isuifoɔ abusua no, wɔde too wɔn tete agya Isui. Beriafoɔ abusua no, wɔde too wɔn tete agya Beria. ");
INSERT INTO twiasante_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Yeinom ne mmusua a wɔfiri Beriafoɔ mu. Heberfoɔ de wɔn ho too wɔn tete agya Heber. Malkielfoɔ de wɔn ho too wɔn tete agya Malkiel. ");
INSERT INTO twiasante_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Na Aser wɔ ɔbabaa bi a ne din de Sera. ");
INSERT INTO twiasante_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Mmarima a na wɔwɔ Aser mmusua nyinaa mu no dodoɔ yɛ mpem aduonum mmiɛnsa ne ahanan (53,400). ");
INSERT INTO twiasante_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Yeinom ne mmusua a wɔfiri Naftali mmammarima mu. Yakseelfoɔ abusua no, wɔde too wɔn tete agya Yakseel. Gunifoɔ abusua no, wɔde too wɔn agya Guni. ");
INSERT INTO twiasante_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yeserfoɔ abusua no, wɔde too wɔn tete agya Yeser. Silemfoɔ abusua no, wɔde too wɔn tete agya Silem. ");
INSERT INTO twiasante_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Mmarima a na wɔwɔ Naftali mmusua nyinaa mu no dodoɔ yɛ mpem aduanan enum ne ahanan (45,400). ");
INSERT INTO twiasante_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Enti, nnipa dodoɔ a wɔkan wɔn no ano si mpem ahansia ne baako ahanson aduasa (601,730). ");
INSERT INTO twiasante_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Kyekyɛ asase no ma mmusua no sɛdeɛ wɔn dodoɔ teɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ma abusua a ɛso no asase kɛseɛ na abusua a ɛsua no asase ketewa. ");
INSERT INTO twiasante_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Hwɛ sɛ wɔnam ntontobɔ so bɛkyekyɛ asase no. Deɛ ɛsɛ sɛ ekuo biara nya no bɛgyina nʼagyanom abusuakuo edin dodoɔ so. ");
INSERT INTO twiasante_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ɛsɛ sɛ wɔbɔ ntonto wɔ agyapadeɛ no kyekyɛ so wɔ akuo akɛseɛ ne nketewa no mu.” ");
INSERT INTO twiasante_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Nnipakan no, na Lewifoɔ mmusua no mu nnipa nie: Wɔde Gersonfoɔ too wɔn tete agya Gerson. Wɔde Kohatfoɔ too wɔn tete agya Kohat. Wɔde Merarifoɔ too wɔn tete agya Merari. ");
INSERT INTO twiasante_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Yeinom nso yɛ Lewifoɔ mmusua: Libnifoɔ, Hebronfoɔ, Mahlifoɔ, Musifoɔ ne Korafoɔ. Kohat yɛ Amram tete agya; ");
INSERT INTO twiasante_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Ɛberɛ a Lewi wɔ Misraim no, wɔwoo ɔbabaa a ne din de Yokebed. Kehat babarima Amram waree no. Wɔn na wɔwoo Aaron, Mose ne Miriam. ");
INSERT INTO twiasante_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaron woo Nadab, Abihu, Eleasa ne Itamar. ");
INSERT INTO twiasante_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nanso, ɛberɛ a Nadab ne Abihu de ogya a ɛnyɛ kronkron brɛɛ Awurade no, wɔwuwuiɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Nnipakan no mu na Lewifoɔ nyinaa dodoɔ yɛ mpem aduonu mmiɛnsa (23,000). Wɔkan mmarima a wɔadi firi bosome kɔsi mpanimfoɔ so. Nanso, wɔammu Lewifoɔ no ano anka Israel nnipakan no ho, ɛfiri sɛ, wɔrekyɛ nsase no ama mmusuakuo no, wɔamma Lewifoɔ no bi. ");
INSERT INTO twiasante_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Enti, sɛdeɛ Mose ne ɔsɔfoɔ Eleasa fa kyerɛɛ nnipa no ano wɔ Moab bepɔ a ɛbɛn Asubɔnten Yordan na ɛne Yeriko di nhwɛanimu no ne no. ");
INSERT INTO twiasante_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Saa nnipa yi nyinaa, wɔn mu baako mpo nni hɔ a nnipakan a ɛdi ɛkan no, wɔkan no wɔ Sinai ɛserɛ so hɔ, ");
INSERT INTO twiasante_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ɛfiri sɛ, na mfeɛ aduanan atwam enti na wɔn a wɔkan wɔn kane no nyinaa awuwu sɛdeɛ Awurade kaeɛ sɛ. “Wɔbɛwuwu wɔ ɛserɛ so” no. Wɔn a ɛkaa wɔn ara ne Yefune ba Kaleb ne Nun babarima Yosua. ");
INSERT INTO twiasante_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Ɛda koro bi, Hefer babarima Selofehad mmammaa a wɔn edin ne Mahla, Noa, Hogla, Milka ne Tirsa baa Ahyiaeɛ Ntomadan no ano sɛ wɔde adesrɛ bi rebɛto Mose, ɔsɔfoɔ Eleasa ne mmusua panin ne afoforɔ a wɔwɔ hɔ no anim. ");
INSERT INTO twiasante_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Na mmaa no yɛ Yosef babarima Manase abusuafoɔ fa bi. Na wɔn ase firi Makir a ɔyɛ Manase babarima no fie. Na Manase babarima Gilead yɛ wɔn nana nkansowa ɛnna ne babarima Hefer nso yɛ wɔn nana ɛnna wɔn babarima Selofehad yɛ wɔn agya. ");
INSERT INTO twiasante_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Wɔkaa sɛ, “Yɛn agya wuu ɛserɛ so nanso na ɔnka wɔn a wɔne Kora yɛɛ dɔm tiaa Awurade a enti ɛmaa wɔwuwuiɛ no ho. Ɔno ankasa bɔne enti na ɔwuiɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Adɛn enti na ɛsiane sɛ yɛn agya anwo ɔbabarima enti ne din ayera? Yɛgye di sɛ, ɛsɛ sɛ wɔma yɛn agyapadeɛ a yɛn agya nuammarimanom anya no bi.” ");
INSERT INTO twiasante_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Enti Mose de wɔn asɛm too Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Awurade buaa Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Asɛm a Selofehad mmammaa no ka no yɛ nokorɛ. Ma wɔn ne wɔn agya nuanom no asase. Fa agyapadeɛ a sɛ wɔn agya no te ase a anka ɔbɛnya no ma wɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Deɛ ɛdi hɔ bio ne sɛ, ɛsiane sɛ ɛyɛ mo mmara sɛ, sɛ obi wu na ɔnni mmammarima a wɔbɛdi nʼadeɛ a ɛsɛ sɛ nʼagyapadeɛ kɔ ne mmammaa hɔ enti, monyɛ no saa. ");
INSERT INTO twiasante_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Na sɛ ɔnni ɔbabaa nso a, ɛsɛ sɛ agyapadeɛ no kɔ ne nuammarima nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Na sɛ ɔnni nuammarima a, ɛkɔ ne wɔfanom nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Na sɛ ɔnni wɔn mu biara bi a, ɛkɔ ne busuani bi a ɔbɛn no nkyɛn. Ɛsɛ sɛ Israelfoɔ di saa mmara a Awurade hyɛɛ Mose no so.” ");
INSERT INTO twiasante_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Ɛda bi, Awurade ka kyerɛɛ Mose sɛ, “Kɔ bepɔ a ɛwɔ Abarim mmepɔ no so na to wʼani fa asubɔnten a ɛda hɔ no so ma ɛnkɔsi asase a mede maa Israelfoɔ no so. ");
INSERT INTO twiasante_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Sɛ wohwɛ wie a, wobɛwu sɛdeɛ wo nua Aaron wuiɛ no, ");
INSERT INTO twiasante_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ɛfiri sɛ, wosɔre tiaa me mmara wɔ Sin ɛserɛ so hɔ. Ɛberɛ a Israelfoɔ no sɔre tiaa me no, woamma wɔanhunu me kronkronyɛ wɔ nsuo no ho.” Na ɔretwe nʼadwene aba Meriba nsuo “Akoeɛ” a ɛwɔ Kades a ɛwɔ Sin ɛserɛ so no so. ");
INSERT INTO twiasante_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mose ka kyerɛɛ Awurade sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Ao Awurade, Onyankopɔn a woyɛ nnipa nyinaa honhom ti ansa na worebɛfa me no, mesrɛ, yi obi si mʼanan ");
INSERT INTO twiasante_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","a ɔde wɔn bɛkɔ ɔko na ɔbɛhwɛ wɔn so sɛdeɛ ɛbɛyɛ a Awurade nnipa bɛnya odwanhwɛfoɔ a ɔbɛhwɛ wɔn so.” ");
INSERT INTO twiasante_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Awurade buaa no sɛ, “Kɔ na kɔfrɛ Nun babarima Yosua a ɔwɔ Honhom no wɔ ne mu no, ");
INSERT INTO twiasante_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","na fa no kɔ ɔsɔfoɔ Eleasa nkyɛn, na nnipa no nyinaa rehwɛ mo no, fa nnipa no animdie so tumi hyɛ ne nsa. ");
INSERT INTO twiasante_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Fa wo tumi ma no wɔ badwam sɛdeɛ ɛbɛyɛ a, Israelfoɔ nyinaa bɛtie no. ");
INSERT INTO twiasante_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Sɛ wɔhia akwankyerɛ a ɛfiri Awurade hɔ a, Yosua bɛgyina ɔsɔfoɔ Eleasa anim, na ɔsɔfoɔ Eleasa abɔ ntonto kronkron de abisa Awurade apɛdeɛ. Saa ɛkwan yi so na Yosua ne Israelfoɔ no bɛfa so ahwehwɛ deɛ ɛsɛ sɛ wɔyɛ.” ");
INSERT INTO twiasante_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Enti, Mose yɛɛ deɛ Awurade hyɛɛ no sɛ ɔnyɛ no. Ɔde Yosua kyerɛɛ ɔsɔfoɔ Eleasa ne nnipa no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Mose de ne nsa guu no so, de nʼadwuma hyɛɛ ne nsa sɛdeɛ Awurade hyɛeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Ka kyerɛ Israelfoɔ sɛ, afɔrebɔdeɛ a mohye no wɔ afɔrebukyia so no yɛ mʼaduane a mʼani gye ho. ‘Enti, hwɛ na wɔmfa mmra wɔ ɛberɛ-ano-berɛ-ano na wɔmfa mmɔ afɔdeɛ sɛdeɛ mahyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Sɛ mobɔ ɔhyeɛ afɔdeɛ a, momfa nnwennini mma a wɔadi afe a wɔnni dɛm biara na ɛmmɔ Awurade afɔdeɛ no. Ɛda biara, momfa mmienu mmɔ afɔdeɛ. Mommɔ no wɔ berɛ-ano-berɛ ano. ");
INSERT INTO twiasante_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Momfa odwammaa no baako mmɔ afɔdeɛ anɔpa na momfa baako mmɔ anwummerɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Sɛ morebɔ saa afɔdeɛ no a, momfa aburoo lita mmienu ne fa a wɔayam no muhumuhu na wɔde ngo afra nka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Yei ne ɔhyeɛ afɔdeɛ a wɔhyɛɛ aseɛ wɔ Sinai Bepɔ so a ɛsɛ sɛ wɔbɔ no wɔ berɛ-ano-berɛ-ano ma ɛyi hwa. Ɛyɛ afɔdeɛ a wɔde ogya bɔ de ma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Ɛsɛ sɛ wɔde ɔnom afɔrebɔdeɛ a ɛyɛ nsã a apae lita baako a odwammaa ka ho ka afɔrebɔdeɛ no ho a wɔbɛhwie agu beaeɛ bi a ɛhɔ yɛ kronkron wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Momfa odwammaa a ɔtɔ so mmienu no mmɔ afɔdeɛ anwummerɛ a aburoo ne nsã afɔrebɔdeɛ ka ho. Ɛno nso yɛ Awurade hwam. Ɛyɛ ɔhyeɛ afɔrebɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Sɛ ɛduru homeda a, momfa nnwammaa a wɔadi afe a wɔnnii dɛm biara ne afɔrebɔdeɛ ahodoɔ a ɛsɛ sɛ mode ka ho no mmɔ afɔdeɛ. Ɛsɛ sɛ aburoo afɔrebɔdeɛ lita ɛnan ne fa a wɔayam no muhumuhu de ngo afra a nsã ka ho saa ara na wɔde bɔ saa afɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Yei ne ɔhyeɛ afɔdeɛ a wɔbɔ no homeda biara de ka ɛberɛ ano ɔhyeɛ afɔdeɛ ne nsã afɔrebɔ ho no. ");
INSERT INTO twiasante_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘Saa ara nso na ɛda a ɛdi ɛkan wɔ bosome biara mu no, ɛsɛ sɛ mobɔ ɔhyeɛ afɔdeɛ foforɔ bi ka ho de ma Awurade. Afɔrebɔdeɛ no bɛyɛ nantwinini mma mmienu, odwennini baako ne nnwammaa nson a wɔadi afe a wɔnnii dɛm biara. ");
INSERT INTO twiasante_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Deɛ ɛsɛ sɛ mode ka ho ne asikyiresiam lita nsia ne ɛfa a wɔayam no muhumuhu de ngo afra. Ɛno na mode bɛka nantwie baako biara ho. Afei, mode asikyiresiam a wɔayam no muhumuhu lita ɛnan a wɔde ngo afra bɛbɔ aburoo afɔdeɛ a odwennini no ka ho; ");
INSERT INTO twiasante_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","na odwammaa biara nso, mode asikyiresiam lita mmienu ne ɛfa. Saa afɔrebɔdeɛ yi wɔde ogya na ɛbɛhye, na ɛbɛsɔ Awurade ani. ");
INSERT INTO twiasante_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Afɔrebɔdeɛ biara no, nsã afɔrebɔ ka ho. Nantwie biara, nsã ntoa nsia ka ho. Odwennini biara, nsã ntoa ɛnan ka ho. Odwammaa biara nso, nsã ntoa mmiɛnsa ka ho. Afe mu no nyinaa mu, yei na ɛbɛyɛ ɔhyeɛ afɔdeɛ wɔ bosome biara mu. ");
INSERT INTO twiasante_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Afei, bosome biara mu ɛda a ɛdi ɛkan no, mode ɔpapo bɛbɔ bɔne ho afɔdeɛ ama Awurade. Mobɛbɔ saa afɔdeɛ yi de aka ɔhyeɛ afɔdeɛ ne nsã afɔdeɛ a mobɔ no wɔ berɛ-ano-berɛ-ano no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Afe biara bosome a ɛdi ɛkan no ɛda a ɛtɔ so dunan no nso, mobɛdi Awurade Twam Afahyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ɛda a ɛdi so no, mobɛfiti aseɛ adi dapɔnna a wɔde anigyeɛ di no nnanson no, nanso, morenni burodo a mmɔreka wɔ mu. ");
INSERT INTO twiasante_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Afahyɛ no ɛda a ɛdi ɛkan no, nnipa no nyinaa bɛbɔ ahoteɛ dwa na obiara renyɛ adwuma biara. ");
INSERT INTO twiasante_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Mode nantwie mma mmienu, odwennini baako ne nnwammaa a wɔadi afe a wɔnnii dɛm bɛbɔ ɔhyeɛ afɔdeɛ ama Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Mode esiam lita nson a mode ngo afra bɛka nantwie baako biara ho. Afei, mode esiam lita enum bɛka odwennini no ho, ");
INSERT INTO twiasante_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","na nnwan nson no biara nso, mode esiam lita mmiɛnsa aka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Ɛsɛ sɛ mode ɔpapo bɔ bɔne ho afɔdeɛ sɛ mpatadeɛ ma mo ho. ");
INSERT INTO twiasante_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Mode saa afɔrebɔdeɛ yi bɛka deɛ daadaa mobɔ no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Nna nson no mu ɛda biara adidie mu no, mobɛbɔ saa afɔdeɛ korɔ yi ara bi. Ɛbɛyɛ Awurade anisɔ yie. ");
INSERT INTO twiasante_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Ɛda a ɛtɔ so nson no, ɛbɛyɛ ɛda kronkron bio a nnipa no nyinaa bɛhyia mu na saa ɛda no, obiara renyɛ adwuma biara. ");
INSERT INTO twiasante_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Aduanekan ɛda no a wɔfrɛ no Nnawɔtwe mu Afahyɛ anaasɛ Pentekoste no, ɛsɛ sɛ nnipa no nyinaa bɔ nhyiamu kronkron ho dawuro de di Otwa berɛ Afahyɛ no. Ɛda no, ɛsɛ sɛ mode mo mfuo mu nnɔbaeɛ foforɔ bɛbɔ Awurade aduane afɔdeɛ. Ɛnsɛ sɛ mo mu biara yɛ adwuma saa ɛda no. ");
INSERT INTO twiasante_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Ɔhyeɛ afɔdeɛ sononko a ɛsɔ ani na ɛsɛ sɛ saa ɛda no, mobɔ ma Awurade. Afɔrebɔdeɛ no bɛyɛ anantwie mma mmienu, odwennini baako ne nnwammaa anini a wɔadi mfeɛ nson. ");
INSERT INTO twiasante_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Mode mo aburoo lita nsia ne fa a wɔayam no muhumuhu a mode ngo afra bɛka nantwie baako ho. Mode lita ɛnan bɛka odwennini no ho; ");
INSERT INTO twiasante_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","na mode lita mmienu ne fa bɛka nnwammaa nson no biara ho. ");
INSERT INTO twiasante_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Afei, momfa ɔpapo baako nyɛ mpatadeɛ mma mo ho. ");
INSERT INTO twiasante_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Saa afɔdeɛ ahodoɔ sononko yi ka daa ɔhyeɛ afɔdeɛ, aburoo afɔdeɛ ne nsã afɔdeɛ no ho. Monhwɛ sɛ mmoa a mode wɔn rekɔbɔ saa afɔdeɛ no nnii dɛm biara ansa na mode wɔn abɔ saa afɔdeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘Bosome a ɛtɔ so nson no ɛda a ɛdi ɛkan wɔ afe biara mu no, monhyɛ totorobɛnto afahyɛ no. Nnipa no nyinaa de kommyɛ bɛhyia na obiara renyɛ adwuma biara. ");
INSERT INTO twiasante_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Saa ɛda no, mode nantwie ba baako, odwennini baako ne nnwammaanini nson a wɔadi afe a wɔnnii dɛm bɛbɔ ɔhyeɛ afɔdeɛ. Yeinom yɛ afɔrebɔdeɛ a Awurade ani bɛsɔ na nʼani nso bɛgye ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Mode aburoo lita nsia ne fa a wɔayam no muhumuhu a wɔde ngo afra bɛbɔ aburoo afɔdeɛ no a nantwie no ka ho. Wɔde lita ɛnan bɛka odwennini no ho ");
INSERT INTO twiasante_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ɛnna lita mmienu ne fa nso ka nnwammaa no baako biara ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Ɛsɛ sɛ mosane de ɔpapo bɔ bɔne ho afɔdeɛ de yei yɛ mo mpatadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Saa afɔrebɔ sononko yi ka ɔhyeɛ afɔdeɛ a mobɔ no bosome biara ne ɛda no deɛ no ho; afei nso, ɛka daa ɔhyeɛ afɔdeɛ a mobɔ a aburoo ne nsã afɔrebɔ ka ho no ho sɛdeɛ afɔrebɔ no ho mmara teɛ no. Ɛyɛ ɔhyeɛ afɔdeɛ a ɛsɔ Awurade ani. ");
INSERT INTO twiasante_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘Bosome a ɛtɔ so nson no ɛda a ɛtɔ so edu no, ɛsɛ sɛ nnipa no nyinaa sane hyia bio. Ɛyɛ ɛda a ɛsɛ sɛ nnipa no nyinaa yɛ komm ahobrɛaseɛ mu wɔ Awurade anim, na ɛnsɛ sɛ wɔn mu biara yɛ adwuma biara. ");
INSERT INTO twiasante_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Saa ɛda no, mobɛbɔ ɔhyeɛ afɔdeɛ ama Awurade—nʼani bɛsɔ. Afɔrebɔdeɛ no yɛ nantwie ba baako, odwennini baako, nnwammaanini nson a wɔadi afe a wɔnnii dɛm biara. ");
INSERT INTO twiasante_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Fa nantwie ba no siesie atokoɔ afɔdeɛ a mode asikyiresiam a wɔayam no muhumuhu ne ngo lita nsia ne fa afra. ");
INSERT INTO twiasante_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Lita ɛnan na mode bɛka odwennini no ho ɛnna mode lita mmienu ne fa aka odwammaa baako biara ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Ɛsɛ sɛ mode ɔpapo baako bɔ bɔne ho afɔdeɛ. Yei ka bɔne afɔrebɔdeɛ a wɔbɔ de pata ne ɔhyeɛ afɔdeɛ a wɔbɔ no daadaa a aduane afɔrebɔdeɛ ne nsã afɔdeɛ ka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘Bosome a ɛtɔ so nson no ɛda a ɛtɔ so dunum no, ɛsɛ sɛ nnipa no nyinaa sane hyia bio. Ɛnsɛ sɛ ɛda no, obiara yɛ adwuma. Ɛyɛ nnanson afahyɛ ahyɛaseɛ wɔ Awurade anim. ");
INSERT INTO twiasante_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Nneɛma a mode bɛbɔ saa afɔdeɛ sononko yi ama Awurade ani asɔ no bɛyɛ nantwie mma dumiɛnsa, nnwennini mmienu ne nnwammaanini a wɔadi afe a wɔnnii dɛm biara dunan. ");
INSERT INTO twiasante_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Ɛsɛ sɛ, sɛdeɛ moyɛ no daa no, mode atokoɔ afɔrebɔdeɛ, asikyiresiam a wɔayam no muhumuhu lita nsia ne fa ka anantwie mma dumiɛnsa no biara ho. Lita ɛnan ka nnwennini no baako biara ho ");
INSERT INTO twiasante_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ɛnna lita mmienu ne fa aka nnwammaa dunan no baako biara ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Ɛsɛ sɛ mode ɔpapo bɔ bɔne ho afɔdeɛ ka daa ɔhyeɛ afɔdeɛ a mobɔ no ho a aburoo ne nsã afɔdeɛ ka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘Ɛda a ɛtɔ so mmienu wɔ saa nnanson afahyɛ no mu no, mode anantwie mma dumienu, nnwennini mmienu ne nnwammaanini a wɔadi afe dunan a wɔnnii dɛm biara bɛbɔ afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Saa afɔrebɔdeɛ yi mu biara, mode anantwinini, nnwennini ne nnwammaa no ho aduane ne nsã afɔrebɔdeɛ a wɔahyɛ no bɛka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Ɔhyeɛ afɔrebɔ a mobɔ no daa akyi no, mode ɔpapo bɛka atokoɔ afɔrebɔdeɛ ne nsã afɔrebɔdeɛ no ho abɔ bɔne ho afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘Afahyɛ ɛda a ɛtɔ so mmiɛnsa no so no, mode anantwie mmaa dubaako, nnwennini mmienu, nnwammaanini a wɔadi afe no dunan a wɔnnii dɛm biara ");
INSERT INTO twiasante_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","a sɛdeɛ moyɛ no daa no, mode anantwie, nnwennini ne nnwammaa no ne aduane ne nsã afɔrebɔdeɛ bɛka afɔrebɔdeɛ biara ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Ɛsɛ sɛ mode ɔpapo bɔ bɔne ho afɔdeɛ de ka daa ɔhyeɛ afɔrebɔ no ho a atokoɔ afɔrebɔdeɛ ne nsã afɔrebɔdeɛ ka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘Afahyɛ a ɛtɔ so nan no, mode anantwie mma edu, nnwennini mmienu, ne nnwammaanini a wɔadi afe no dunan a wɔnnii dɛm biara ");
INSERT INTO twiasante_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","a mode atokoɔ afɔrebɔdeɛ ne nsã afɔrebɔdeɛ bɛka wɔn mu biara ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Afei, momfa ɔpapo a sɛdeɛ moyɛ daa no atokoɔ ne nsã afɔrebɔdeɛ ka ho nka afɔrebɔ a mobɔ no daa no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘Afahyɛ ɛda a ɛtɔ so enum no, momfa anantwie mma nkron, nnwennini mmienu ne nnwammaanini a wɔadi afe no dunan a wɔnnii dɛm biara. ");
INSERT INTO twiasante_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Sɛdeɛ moyɛ no daa no, mode atokoɔ afɔrebɔdeɛ ne nsã afɔrebɔdeɛ bɛka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Momfa ɔpapo a aburoo afɔrebɔdeɛ ne nsã afɔrebɔdeɛ ka ho mmɔ bɔne ho afɔdeɛ sononko nka afɔdeɛ ahodoɔ a mobɔ no daa no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘Afahyɛ ɛda a ɛtɔ so nsia no, mode anantwie mma nwɔtwe, nnwennini mmienu ne nnwammaanini a wɔadi afe a wɔnnii dɛm biara dunan ");
INSERT INTO twiasante_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","bɛka wɔn atokoɔ ne wɔn nsã afɔrebɔdeɛ no ho sɛdeɛ moyɛ no daa no. ");
INSERT INTO twiasante_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Momfa ɔpapo a atokoɔ afɔrebɔdeɛ ne nsã afɔrebɔdeɛ ka ho mmɔ bɔne ho afɔdeɛ sɛdeɛ moyɛ no daa no. ");
INSERT INTO twiasante_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘Afahyɛ ɛda a ɛtɔ so nson no, mode anantwie mma nson, nnwennini mmienu ne nnwammaanini a wɔadi afe a wɔnnii dɛm biara dunan ");
INSERT INTO twiasante_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","a mode atokoɔ ne nsã afɔrebɔdeɛ bɛka wɔn mu biara ho bɛbɔ afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Afei, mode ɔpapo baako bɛbɔ bɔne ho afɔdeɛ a atokoɔ ne nsã afɔrebɔdeɛ ka ho aka daa afɔrebɔ no ho sɛdeɛ moyɛ no daa no. ");
INSERT INTO twiasante_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘Ɛda a ɛtɔ so nwɔtwe no, frɛ nnipa no nyinaa na wɔnhyia kommyɛ so. Ɛnsɛ sɛ moyɛ adwuma biara saa ɛda no. ");
INSERT INTO twiasante_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Mommɔ ɔhyeɛ afɔdeɛ. Awurade ani sɔ saa afɔdeɛ no. Momfa nantwie ba baako, odwennini baako, nnwammaanini a wɔadi afe a wɔnnii dɛm nson mmɔ afɔdeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Na sɛ morebɔ saa afɔdeɛ no a, momfa atokoɔ ne nsã afɔrebɔdeɛ nka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Afei, mode ɔpapo baako bɛbɔ bɔne ho afɔdeɛ a atokoɔ ne nsã afɔrebɔdeɛ ka ho a daa afɔdeɛ a mobɔ no nso ka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Sɛ mohyia didi afirinhyia no mu a, twa ara na ɛtwa sɛ mobɔ saa afɔdeɛ yi ma Awurade. Na ɛka mo afɔrebɔ a mobɔ fa ɛbɔ a moahyɛ anaa deɛ ɛfiri mo pɛ mu a ɛyɛ ɔhyeɛ afɔdeɛ, atokoɔ afɔdeɛ, nsã afɔdeɛ anaa asomdwoeɛ afɔdeɛ no ho.’ ” ");
INSERT INTO twiasante_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Mose kaa saa mmara yi nyinaa kyerɛɛ Israelfoɔ no sɛdeɛ Awurade hyɛɛ no no. ");
INSERT INTO twiasante_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Afei, Mose hyiaa Israel mmusua no mu mpanimfoɔ no ka kyerɛɛ wɔn sɛ, “Awurade ahyɛ sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","sɛ obi hyɛ Awurade bɔ anaa ɔka ntam hyɛ bɔ no, ɛnsɛ sɛ ɔbu so. Ɛsɛ sɛ ɔyɛ deɛ ɔka sɛ ɔbɛyɛ no pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Sɛ ababaawa bi hyɛ Awurade bɔ anaa ɔka ntam hyɛ bɔ ɛberɛ a ɔda so te nʼagya fie, ");
INSERT INTO twiasante_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","na nʼagya no te sɛ ne ba no ahyɛ bɔ, na wanka hwee a, ne bɔhyɛ no di mu. ");
INSERT INTO twiasante_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Nanso sɛ ɛba sɛ nʼagya no si no bɔhyɛ no ho ɛkwan ɛda a ɔbɛte no a, ɔde sɛe bɔhyɛ no. Awurade de bɛkyɛ ababaawa no, ɛfiri sɛ, nʼagya ampene sɛ ɔbɛdi so. ");
INSERT INTO twiasante_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Sɛ ɔhyɛ bɔ a ɛnyɛ na akyire no ɔkɔware ");
INSERT INTO twiasante_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","na ne kunu no te saa bɔhyɛ no ho asɛm nanso wanka ho hwee ɛda no ara a, ne bɔhyɛ no di dwuma. ");
INSERT INTO twiasante_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Na sɛ ne kunu no po bɔhyɛ bɔne no a, po a ɔpoeɛ no di mu enti, Awurade de bɛkyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Sɛ ɔbaa yɛ okunafoɔ anaa wɔagyaa no aware a, ɛkwan biara so, ɛsɛ sɛ ɔdi ne bɔhyɛ nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Sɛ waware na ɔte ne kunu fie a ɛhɔ na ɔhyɛɛ ɛbɔ no, ");
INSERT INTO twiasante_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","na ne kunu no teeɛ na wanka ho hwee a, ne bɔhyɛ no di mu. ");
INSERT INTO twiasante_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Na sɛ ɛda no ara a ɔteeɛ no, sɛ wampene so a, ne bɔhyɛ no nni mu na Awurade de bɛkyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Enti, ne kunu na ɔbɛsi so dua anaasɛ ɔbɛkasa atia bɔhyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Sɛ ɛda mu no nyinaa wanka ho hwee deɛ a, na ɛkyerɛ sɛ, ɔpene so. ");
INSERT INTO twiasante_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Sɛ ɔtwɛn ma ɛda koro fa so na sɛ ɔbɛka sɛ bɔhyɛ no nni mu a, ɛho asotwe biara a ɔbaa no penee so no bɛba ɔbarima no so.” ");
INSERT INTO twiasante_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Yei ne mmara a Awurade nam Mose so de maa ɔbarima ne ne yere ne agya ne ne babaa a wɔn nyinaa te efie baako mu no. ");
INSERT INTO twiasante_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Afei, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Esiane sɛ Midianfoɔ daadaa mo de mo kɔɔ abosonsom mu no enti, tɔ wɔn so awere. Yei akyi no wɔbɛwu na wɔakɔ wɔn agyanom nkyɛn.” ");
INSERT INTO twiasante_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Mose ka kyerɛɛ nkurɔfoɔ no sɛ, “Monyi mmarima no mu bi na wɔnkɔ Awurade aweretɔ sa a ɔde tia Midianfoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Momfa Israel abusua biara mu nnipa apem nkɔ ɔsa no.” ");
INSERT INTO twiasante_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Wɔyɛɛ saa nyaa mmarima mpem dumienu siesie wɔn maa ɔko no. ");
INSERT INTO twiasante_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Afei Mose ma wɔkɔeɛ, nnipa apem baako a wɔfiri abusuakuo biara mu. Ɔsɔfoɔ Eleasa babarima Pinehas na ɔdii wɔn anim kɔɔ ɔko no. Wɔrekɔ no, wɔde kronkronneɛ a ɛwɔ kronkronbea hɔ ne totorobɛnto a wɔbɛhyɛn akanyane akodɔm no kɔeɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Na sɛdeɛ Awurade hyɛeɛ no, wɔkumm Midian mmarima nyinaa wɔ ɔko no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Wɔn a wɔkumm wɔn no bi ne Midian ahemfo baanum a wɔn edin de Ewi, Rekem, Sur, Hur ne Reba. Beor babarima Balaam nso, wɔkumm no. ");
INSERT INTO twiasante_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Afei, Israel asraafoɔ no kyekyeree Midian mmaa ne mmɔfra nyinaa ne wɔn anantwie ne wɔn nnwan fom nneɛma pii kaa ho. ");
INSERT INTO twiasante_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Wɔtoo Midian nkuro ne nkuraa nyinaa mu ogya, hyee no pasaa. ");
INSERT INTO twiasante_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Wɔfaa asadeɛ ne afodeɛ a nnipa no ne mmoa ka ho. ");
INSERT INTO twiasante_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Wɔde nneduafoɔ no ne ɔko no mu nneɛma a wɔnyaeɛ no nyinaa brɛɛ Mose, ɔsɔfoɔ Eleasa ne Israelfoɔ a na wɔabɔ wɔn atenaseɛ wɔ Moab bepɔ so baabi a na ɛbɛn Asubɔnten Yordan a wɔtwa firi Yeriko ba hɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mose ne ɔsɔfoɔ Eleasa ne mpanimfoɔ a wɔtuatua nnipa no ano no kɔhyiaa nkonimdifoɔ no ɛkwan. ");
INSERT INTO twiasante_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Nanso, Mose bo fuu mpanimfoɔ a wɔtuatua akodɔm no ano no. ");
INSERT INTO twiasante_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Ɔbisaa wɔn sɛ, “Adɛn enti na moankunkum mmaa no? ");
INSERT INTO twiasante_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Yeinom ara ne nnipa no a wɔtie Balaam enti wɔmaa Israelfoɔ gyaa Awurade kɔsom abosom wɔ bepɔ Peor so a enti ɛmaa ɔhaw ne abɛbrɛsɛ bebree baa yɛn so bɛsɛee yɛn no. ");
INSERT INTO twiasante_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Monkunkum mmarimaa no nyinaa. Afei, monkunkum mmaa a wɔne mmarima adeda no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mommfa mo nsa nka mmaayewa nketewa no. Wɔn deɛ, momfa wɔn na mo ne wɔn nkɔtena. ");
INSERT INTO twiasante_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Afei, momfiri atenaeɛ ha nkɔtena baabi nnanson, ɛfiri sɛ, mo nyinaa moakum nnipa anaa mode mo nsa aka efunu. Monnwira mo ho ne mo nneduafoɔ ne nnansa ne ne nnanson so. ");
INSERT INTO twiasante_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Monkae na monnwira mo ntadeɛ ne biribiara a wɔde aboa nwoma, abirekyie nwi anaa dua ayɛ.” ");
INSERT INTO twiasante_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Afei, ɔsɔfoɔ Eleasa ka kyerɛɛ mmarima a wɔkɔɔ ɔko no sɛ, “Yei ne mmara a Awurade ahyɛ a waka akyerɛ Mose. ");
INSERT INTO twiasante_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Biribiara a ɛtumi gyinaa ogya ano te sɛ sikakɔkɔɔ, dwetɛ, kɔbere, dadeɛ, sanya anaa sumpii no, ");
INSERT INTO twiasante_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ɛsɛ sɛ wɔde ka ogya sɛdeɛ ɛho bɛte. Yei akyi, ɛsɛ sɛ wɔde ahodwira nsuo dwira ho ma ɛho te. Nanso, biribiara a ɛrentumi nnyina ogya ano no deɛ, wɔmfa nsuo nnwira ho. ");
INSERT INTO twiasante_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Nnanson so, ɛsɛ sɛ mosi mo ntadeɛ na modwira mo ho ansa na moasane aba atenaeɛ hɔ.” ");
INSERT INTO twiasante_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Ɛsɛ sɛ wo ne ɔsɔfoɔ Eleasa ne mmusua no mpanimfoɔ nyinaa twerɛ afodeɛ a nnipa ne mmoa ka ho a monyaa no ɔko no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Afei, monkyɛ afodeɛ no mu mmienu. Momfa ɛfa mma mmarima a wɔkɔɔ ɔko no na momfa ɛfa a aka no mma nnipa a aka no. ");
INSERT INTO twiasante_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Nanso, deɛ ɛdi ɛkan no, ɛsɛ sɛ Awurade nya kyɛfa a ɛyɛ nneduafoɔ, anantwie, mfunumu, ne nnwan a ɛfiri akofoɔ no kyɛfa mu. Awurade kyɛfa no bɛyɛ ahanum biara mu baako. ");
INSERT INTO twiasante_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Fa saa kyɛfa yi ma ɔsɔfoɔ Eleasa na ɔnhim no afɔrebukyia no anim mfa mma Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Afei Israelfoɔ a wɔaka no kyɛfa no, monyi aduonum biara mu baako. Momfa yei mma Lewifoɔ a wɔhwɛ Awurade Ahyiaeɛ Ntomadan no so no.” ");
INSERT INTO twiasante_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Enti, Mose ne ɔsɔfoɔ Eleasa yɛɛ deɛ Awurade hyɛɛ wɔn sɛ wɔnyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Afodeɛ a ɛkaeɛ a akofoɔ no faeɛ no dodoɔ yɛ nnwan mpem ahansia aduɔson enum (675,000); ");
INSERT INTO twiasante_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","anantwie mpem aduɔson mmienu (72,000); ");
INSERT INTO twiasante_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","mfunumu mpem aduosia baako (61,000); ");
INSERT INTO twiasante_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ne mmaayewa mpem aduasa mmienu (32,000). ");
INSERT INTO twiasante_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Nneɛma no fa a wɔde maa asraafoɔ no dodoɔ nie: Nnwan mpem ahasa aduasa nson ne ahanum (337,500) ");
INSERT INTO twiasante_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","a wɔde mu ahansia aduɔson enum (675) maa Awurade; ");
INSERT INTO twiasante_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Anantwie mpem aduasa nsia (36,000) a wɔde mu aduɔson mmienu (72) maa Awurade; ");
INSERT INTO twiasante_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","mfunumu mpem aduasa ne ahanum (30,500) a emu aduosia baako (61) yɛ Awurade kyɛfa; ");
INSERT INTO twiasante_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","mmaayewa mpem dunsia (16,000); wɔde wɔn mu aduasa mmienu (32) maa Awurade. ");
INSERT INTO twiasante_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Wɔde Awurade kyɛfa no nyinaa maa ɔsɔfoɔ Eleasa sɛdeɛ Awurade kyerɛɛ Mose sɛ ɔnyɛ no ara pɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Afodeɛ no a Israelfoɔ no nyaa no na ɛdidi soɔ yi: ");
INSERT INTO twiasante_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","nnwan mpem ahasa aduasa nson ne ahanum (337,500), ");
INSERT INTO twiasante_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","anantwie mpem aduasa nsia (36,000), ");
INSERT INTO twiasante_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","mfunumu Mpem aduasa ne ahanum (30,500) ne ");
INSERT INTO twiasante_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","mmaayewa mpem dunsia (16,000). ");
INSERT INTO twiasante_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Nnipa no kyɛfa a wɔnyaeɛ no, Mose yiyii nneduafoɔ ne mmoa aduonum biara mu baako de maa Lewifoɔ a wɔhwɛ Awurade Ahyiaeɛ Ntomadan so no. Wɔyɛɛ yei nyinaa sɛdeɛ Awurade hyɛɛ Mose no. ");
INSERT INTO twiasante_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Afei, asraafoɔ mpanimfoɔ baa Mose nkyɛn bɛka kyerɛɛ no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","“Owura yɛabu nnipa a yɛde wɔn kɔɔ ɔko no nyinaa ano akyerɛ wo na yɛn mu baako koraa anyera. ");
INSERT INTO twiasante_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ɛno enti, yɛfiri deɛ yɛnyaa no ɔko no mu no bi mu rebɛda Awurade ase. Yɛn asedadeɛ no yɛ sika adwinneɛ, nkapo, nkawa, nsonkawa ne kɔnmuadeɛ. Yeinom bɛyɛ mpatadeɛ ama yɛn kra wɔ Awurade anim.” ");
INSERT INTO twiasante_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mose ne ɔsɔfoɔ Eleasa gyee saa akyɛdeɛ yi a ɛyɛ sikakɔkɔɔ ne adwinneɛ firii asraafoɔ mpanimfoɔ no nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Ne nyinaa mu sikakɔkɔɔ a asahene no de baeɛ sɛ akyɛdeɛ a wɔde rebrɛ Awurade no ano si nkariboɔ kilogram ɔha ne aduɔkron. ");
INSERT INTO twiasante_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Na asraafoɔ no afa ɔko no mu nneɛma a wɔnyaeɛ no bi. ");
INSERT INTO twiasante_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Enti Mose ne Eleasa gyee akyɛdeɛ no firii asraafoɔ mpanimfoɔ no hɔ, na wɔde sikakɔkɔɔ no baa Ahyiaeɛ Ntomadan no mu sɛ ɛnyɛ nkaeɛ adeɛ mma Awurade sɛ Israelfoɔ yɛ ne dea. ");
INSERT INTO twiasante_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Na Ruben ne Gad mmusuakuo no wɔ nyɛmmoa pii, enti wohunuu sɛ Yaser ne Gilead nsase no bɛyɛ ama wɔn nnwan ne anantwie no, ");
INSERT INTO twiasante_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","wɔkɔɔ Mose ne ɔsɔfoɔ Eleasa ne nnipa no ntuanofoɔ no nkyɛn. Wɔka kyerɛɛ wɔn sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarot, Dibon, Yaser, Nimra, Hesbon, Eleale, Sebam, Nebo ne Beon. ");
INSERT INTO twiasante_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Saa nsase yi nyinaa, Awurade ako, agye ama Israelfoɔ. Ɛbɛyɛ ama yɛn nnwan ne yɛn anantwie. ");
INSERT INTO twiasante_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Sɛ yɛanya adom wɔ mo anim a, yɛsrɛ mo momfa saa asase yi mma yɛn sɛ yɛn kyɛfa na monnyae Asubɔnten Yordan fa nohoa a mopɛ sɛ mode ma yɛn no.” ");
INSERT INTO twiasante_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mose nso bisaa Rubenfoɔ ne Gadfoɔ no sɛ, “Mokyerɛ sɛ, mopɛ sɛ motena ha wɔ ɛberɛ a mo nuanom atwa mu rekɔko? ");
INSERT INTO twiasante_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Mopɛ sɛ mobu nnipa a aka no aba mu ma wɔsane sɛ wɔrenkɔ asase a Awurade de ama wɔn no so no? ");
INSERT INTO twiasante_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Ade koro yi ara na mo agyanom yɛeɛ. Mesomaa wɔn firii Kades-Barnea sɛ wɔnkɔsra asase no ");
INSERT INTO twiasante_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","nanso ɛberɛ a wɔwiee nsra no na wɔfiri Eskol subɔnhwa mu baeɛ no, wɔbuu nnipa no aba mu sɛ wɔrenkɔ Awurade Bɔhyɛ Asase no so. ");
INSERT INTO twiasante_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Na Awurade bo fuu wɔn enti ɔkaa ntam sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","wɔn a wɔayi wɔn afiri Misraim asase so no, wɔn mu biara nni hɔ a wadi boro mfirinhyia aduonu a ɔbɛhunu asase a ɔhyɛɛ Abraham, Isak ne Yakob ho bɔ no, ɛfiri sɛ, wɔanni ne mmara so. ");
INSERT INTO twiasante_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Agye Kenesini Yefune babarima Kaleb ne Nun babarima Yosua na wɔnka ho, ɛfiri sɛ, wɔde wɔn akoma nyinaa dii Awurade akyi, hyɛɛ nnipa nkuran sɛ wɔnkɔ Bɔhyɛ Asase no so. ");
INSERT INTO twiasante_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Awurade ma yɛkyinkyinii ɛserɛ no so hɔ mfirinhyia aduanan kɔsii sɛ saa awoɔ ntoatoasoɔ amumuyɛfoɔ no nyinaa wuwuiɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Nanso, monhwɛ, abɔnefoɔ, moreyɛ saa bɔne koro no ara bi. Esiane sɛ mo dɔɔso enti, Awurade bo a afu Israel no ano bɛyɛ den sen kane no. ");
INSERT INTO twiasante_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Sɛ motwe mo ho firi Onyankopɔn ho sei a, ɔbɛma nnipa no atena ɛserɛ so hɔ akyɛre na sɛ nnome bi ba wɔn so a, ɛho asodie da mo so.” ");
INSERT INTO twiasante_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Wɔteaam sɛ, “Ɛnte saa koraa! Yɛbɛyɛ yɛn nnwammuo na yɛakyekyere nkuro akɛseɛ asi nketewa no anan ");
INSERT INTO twiasante_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","na yɛn ankasa de akodeɛ bɛhyehyɛ yɛn ho adi Israelfoɔ a aka no anim kɔsi sɛ yɛde wɔn bɛba asomdwoeɛ mu ama wɔabɛfa wɔn agyapadeɛ. Na deɛ ɛdi ɛkan no, ɛsɛ sɛ yɛkyekyere nkuro a yɛbɛgye afasuo afa ho ama yɛn nkurɔfoɔ atena mu na ɛhɔfoɔ no ankɔto anhyɛ wɔn so. ");
INSERT INTO twiasante_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Sɛ Israelfoɔ no nsa nkaa wɔn agyapadeɛ no a, yɛrentena ha. ");
INSERT INTO twiasante_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Yɛmpɛ Yordan ho asase biara. Mmom, yɛpɛ asase a ɛda apueeɛ fam hɔ no.” ");
INSERT INTO twiasante_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mose kaa sɛ, “Ɛyɛ. Sɛ mobɛyɛ sɛdeɛ moaka no, na mode akodeɛ ahyehyɛ mo ho ama Awurade ɔko no, ");
INSERT INTO twiasante_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","na mode mo akodɔm no atware Yordan kɔsi sɛ Awurade bɛpamo nʼatamfoɔ no a, ");
INSERT INTO twiasante_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ɛnneɛ, sɛ asase no ho asɛm dwo brɛoo wɔ Awurade anim a, motumi sane ba. Ɛba saa a, na ɛkyerɛ sɛ, moayɛ mo asɛdeɛ ama Awurade ne Israelfoɔ nyinaa. Na asase a ɛda apueeɛ no nso, Awurade de bɛma mo. ");
INSERT INTO twiasante_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Sɛ moanni asɛm a moaka no so a, na moayɛ bɔne atia Awurade, na sɛ ɛba saa a, monhunu sɛ, ɛho asotwe bɛba mo so. ");
INSERT INTO twiasante_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Monkɔ so nkyekyere nkuro mma mo fiefoɔ na monyɛ nnwammuo mma mo nnwan na monni asɛm a mokaeɛ no nyinaa so.” ");
INSERT INTO twiasante_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Ruben ne Gad nkurɔfoɔ no kaa sɛ, “Yɛbɛdi wʼahyɛdeɛ no so pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Yɛn mma, yɛn yerenom, yɛn nnwan ne yɛn anantwie bɛtena Gilead nkuropɔn mu. ");
INSERT INTO twiasante_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Nanso, yɛn a wɔakyere yɛn sɛ asraafoɔ no bɛko ama Awurade sɛdeɛ woaka no.” ");
INSERT INTO twiasante_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Enti, Mose penee so ka kyerɛɛ Eleasa, Yosua ne mpanimfoɔ a wɔtuatua Israel mmusuakuo ano no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Sɛ Gad ne Ruben abusuakuo mu mmarima nyinaa a wɔakyere wɔn ahyɛ sraa mu sɛ wɔnkɔko mma Awurade no ne me kɔ Yordan na sɛ wɔkɔko di nkonim wɔ hɔ a, momfa Gilead asase no mma wɔn; ");
INSERT INTO twiasante_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","na sɛ wɔankɔ a, ɛnneɛ wɔmpene so mfa nsase a mowɔ wɔ Kanaan asase so no bi.” ");
INSERT INTO twiasante_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gad ne Ruben abusuafoɔ kaa bio sɛ, “Yɛbɛdi Awurade asɛm so; ");
INSERT INTO twiasante_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","yɛde akodeɛ bɛhyehyɛ yɛn ho adi Awurade akyi akɔ Kanaan nanso, yɛn ara yɛn asase bɛda Yordan fa ha.” ");
INSERT INTO twiasante_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Enti, Mose maa wɔde Amorifoɔhene Sihon ne Basanhene Og nsasetam ne wɔn nkuro akɛseɛ maa Gad, Ruben ne Yosef babarima Manase mmusuakuo. ");
INSERT INTO twiasante_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gad nkurɔfoɔ na wɔkyekyeree saa nkuro yi: Dibon, Atarot, Aroer. ");
INSERT INTO twiasante_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrot-Sofan, Yaser Yogbeha, ");
INSERT INTO twiasante_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet-Nimra ne Betharan. Na ɛyɛ nkuro a nnwan wɔ mu yie. ");
INSERT INTO twiasante_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ruben mmammarima na wɔkyekyeree saa nkuro a ɛdidi so yi: Hesbon, Eleale Kiriataim, ");
INSERT INTO twiasante_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal-Meon ne Sibma. Wɔtotoo nkuro a wɔakyekyere no edin foforɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Afei, Makir asefoɔ a wɔfiri Manase abusuakuo mu kɔɔ Gilead kɔko dii hɔ so pamoo Amorifoɔ a saa ɛberɛ no na wɔte hɔ no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Enti, Mose de Gilead maa Makirfoɔ, Manase asefoɔ, ma wɔtenaa hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Manase abusuakuo mu nnipa foforɔ bi a wɔfiri Yair nso tenatenaa Gilead nkuro bebree so, sesaa beaeɛ a wɔwɔ hɔ no din frɛɛ hɔ Hafrotyair. ");
INSERT INTO twiasante_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Ɔbarima bi a ne din de Noba dii asraafoɔ bi anim de wɔn kɔɔ Kenat ne ne nkuraaseɛ kɔbɔɔ wɔn atenaeɛ wɔ hɔ, enti ɔde ne din Noba too saa beaeɛ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Yei ne akwantuo nhyehyɛeɛ a Israelfoɔ dii so ɛberɛ a Mose ne Aaron de wɔn firi Misraim no. ");
INSERT INTO twiasante_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Mose twerɛɛ faako a wɔfaeɛ nyinaa sɛdeɛ Awurade kyerɛɛ no sɛ ɔnyɛ no. Yeinom ne mmea mmea a wɔsoɛɛ wɔ wɔn akwantuo no mu. ");
INSERT INTO twiasante_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Wɔsiim firii Rameses kuropɔn no mu wɔ Twam Afahyɛ a ɛdi ɛkan no akyi bosome a ɛdi ɛkan ɛda a ɛtɔ so dunum. Wɔde akokoɔduru firii hɔ a Misraimfoɔ no rehwɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Saa ɛberɛ no, na Misraimfoɔ no resie wɔn mmakan a Awurade kunkumm wɔn anadwo a adeɛ rebɛkye ama wɔatu ɛkwan no no. Awurade nam atemmuo nnwuma akɛseɛ yi so dii Misraimfoɔ anyame no nyinaa so nkonim. ");
INSERT INTO twiasante_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Wɔfirii Rameses no, wɔbaa Sukot. ");
INSERT INTO twiasante_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Wɔfirii Sukot bɛbɔɔ atenaeɛ wɔ Etam, ɛserɛ no ano. ");
INSERT INTO twiasante_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Wɔfirii Etam sane wɔn akyi baa Pihahirot a ɛne Baal-Sefon di nhwɛanimu, na wɔbɔɔ atenaeɛ wɔ bepɔ Migdol ho. ");
INSERT INTO twiasante_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Wɔfiri Pihahirot, na wɔtwaa Ɛpo Kɔkɔɔ no kɔɔ ɛserɛ so. Wɔde nnansa nante kɔɔ Etam ɛserɛ so kɔbɔɔ atenaeɛ wɔ Mara. ");
INSERT INTO twiasante_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Wɔfirii Mara no, wɔbaa Elim; baabi a na nsuwa dumienu ne mmɛdua aduɔson wɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Wɔfirii Elim no, wɔbɔɔ atenaeɛ wɔ Ɛpo Kɔkɔɔ no ho. ");
INSERT INTO twiasante_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Wɔfirii Ɛpo Kɔkɔɔ no ho, kɔbɔɔ atenaeɛ wɔ Sin anweatam so. ");
INSERT INTO twiasante_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Wɔtu firii Sin kɔɔ Dofka. ");
INSERT INTO twiasante_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Wɔfirii Dofka kɔbɔɔ atenaeɛ wɔ Alus. ");
INSERT INTO twiasante_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Wɔfirii Alus kɔbɔɔ atenaeɛ wɔ Refidim, baabi a na wɔnnya nsuo mma nnipa no nnom. ");
INSERT INTO twiasante_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Wɔfirii Refidim no, wɔkɔɔ Sinai ɛserɛ so. ");
INSERT INTO twiasante_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Wɔfirii Sinai ɛserɛ so no, wɔkɔɔ atenaeɛ wɔ Kibrot-Hataawa. ");
INSERT INTO twiasante_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Wɔfirii Kibrot-Hataawa kɔɔ Haserot. ");
INSERT INTO twiasante_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Wɔfirii Haserot kɔɔ Ritma. ");
INSERT INTO twiasante_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Wɔfirii Ritma kɔɔ Rimon Peres. ");
INSERT INTO twiasante_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Wɔfirii Rimon Peres kɔɔ Libna. ");
INSERT INTO twiasante_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Wɔfirii Libna kɔɔ Risa. ");
INSERT INTO twiasante_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Wɔfirii Risa kɔɔ Kahelata. ");
INSERT INTO twiasante_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Wɔfirii Kahelata kɔbɔɔ atenaeɛ wɔ Sefer Bepɔ so. ");
INSERT INTO twiasante_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Wɔfirii Sefer Bepɔ so kɔɔ Harada. ");
INSERT INTO twiasante_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Wɔfirii Harada kɔɔ Makhelot. ");
INSERT INTO twiasante_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Wɔfirii Makhelot kɔɔ Tahat. ");
INSERT INTO twiasante_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Wɔfirii Tahat kɔbɔɔ atenaeɛ wɔ Tera. ");
INSERT INTO twiasante_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Wɔfirii Tera kɔɔ Mitka. ");
INSERT INTO twiasante_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Wɔfirii Mitka kɔɔ Hasmona. ");
INSERT INTO twiasante_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Wɔfirii Hasmona kɔɔ Moserot. ");
INSERT INTO twiasante_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Wɔfirii Moserot kɔɔ Beneyaakan. ");
INSERT INTO twiasante_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Wɔfirii Beneyaakan kɔɔ Horhagidgad. ");
INSERT INTO twiasante_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Wɔfirii Horhagidgad kɔɔ Yotbata. ");
INSERT INTO twiasante_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Wɔfirii Yotbata kɔɔ Abrona. ");
INSERT INTO twiasante_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Wɔfirii Abrona kɔɔ Esion-Geber. ");
INSERT INTO twiasante_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Wɔfirii Esion-Geber kɔbɔɔ atenaeɛ wɔ Kades, wɔ Sin ɛserɛ so. ");
INSERT INTO twiasante_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Wɔfirii Kades kɔbɔɔ atenaeɛ wɔ Bepɔ Hor so, wɔ Edom hyeɛ ano. ");
INSERT INTO twiasante_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Ɛberɛ a wɔduruu Bepɔ Hor ase no, Awurade ka kyerɛɛ ɔsɔfoɔ Aaron sɛ ɔnkɔ bepɔ no atifi, na ɛhɔ na ɔkɔwuiɛ. Asɛm yi sii mfeɛ aduanan so a Israelfoɔ tu firii Misraim no. ");
INSERT INTO twiasante_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaron dii mfeɛ ɔha aduonu mmiɛnsa, na ɔwuiɛ wɔ Bepɔ Hor so. ");
INSERT INTO twiasante_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Saa ɛberɛ no ara mu na Kanaanhene Arad a ɔtenaa Negeb wɔ Kanaan asase so no tee sɛ Israelfoɔ no reba nʼasase so. ");
INSERT INTO twiasante_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Israelfoɔ no toaa wɔn akwantuo no so firi Bepɔ Hor so kɔbɔɔ atenaeɛ wɔ Salmona. ");
INSERT INTO twiasante_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Wɔfirii Salmona kɔtenaa Punon. ");
INSERT INTO twiasante_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Wɔfirii Punon kɔtenaa Obot. ");
INSERT INTO twiasante_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Wɔtoaa so kɔɔ Iye-Abarim, Moab hyeɛ so. ");
INSERT INTO twiasante_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Wɔfirii hɔ no, wɔkɔɔ Dibon Gad. ");
INSERT INTO twiasante_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Wɔfirii Dibon Gad kɔɔ Almon Diblataim. ");
INSERT INTO twiasante_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Wɔfirii Almon Diblataim kɔtenaa Abarim mmepɔ a ɛbɛn Nebo no so. ");
INSERT INTO twiasante_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Na akyire no, wɔtu kɔbɔɔ atenaeɛ wɔ Moab tata so a ɛbɛn Asubɔnten Yordan a ɛne Yeriko di nhwɛanimu no. ");
INSERT INTO twiasante_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Wɔwɔ saa beaeɛ hɔ no, wɔtenaa mmeaeɛ bebree a ɛbɛn Asubɔnten Yordan ho—ɛfiri Bet-Yesimot kɔsi Abel Sitim a ɛwɔ Moab tata so no. ");
INSERT INTO twiasante_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Ɛberɛ a wɔabɔ atenaseɛ hɔ no na Awurade nam Mose so kasa kyerɛɛ Israelfoɔ no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Sɛ motwam Asubɔnten Yordan kɔduru Kanaan asase so a, ");
INSERT INTO twiasante_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","mompam nnipa a wɔte hɔ no nyinaa na monsɛe wɔn abosom ne ahoni a wɔde aboɔ ayɛ ne asɔreeɛ a wɔasisi no petee mu wɔ mmepɔ so ne beaeɛ a wɔsom wɔn ahoni no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Mede asase no ama mo. Momfa na montena so. ");
INSERT INTO twiasante_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Mo mmusua mu nnipa dodoɔ so na wɔbɛhwɛ ama mo asase. Wɔn a wɔdɔɔso no, wɔbɛma wɔn asase kɛseɛ na wɔn a wɔsua no nso bɛnya asase ketewa. ");
INSERT INTO twiasante_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“Sɛ moampam nnipa a wɔte hɔ no a, wɔbɛyɛ mo ani ase mpe ne mo honam mu nkasɛɛ. Wɔbɛha mo wɔ asase no so. ");
INSERT INTO twiasante_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Na mede deɛ mahyɛ sɛ mɛyɛ wɔn no bɛyɛ mo.” ");
INSERT INTO twiasante_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Ka kyerɛ Israelfoɔ no sɛ, ‘Sɛ mobɛduru Kanaan asase no so a, asase a mede rema mo sɛ mo ankasa asase no a, sɛi na mo ahyeɛ bɛyɛ: ");
INSERT INTO twiasante_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘Asase no anafoɔ fam no bɛyɛ Sin ɛserɛ so a ɛda Edom ano. Anafoɔ hyeɛ no ano bɛfiri Nkyene Ɛpo no. ");
INSERT INTO twiasante_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Ɛbɛtoa so akɔtra Akrabbim wɔ anafoɔ hɔ a ɛrekɔ Sin no. Nʼanafoɔ pa ara no bɛyɛ Kades-Barnea, na ɛfiri hɔ akɔsi Hasarada de akɔwie Asmon. ");
INSERT INTO twiasante_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Ɛfiri Asmon a, ɛhyeɛ no bɛkɔ ara akɔsi Misraim asuwa no mu na ano akɔpem Po Kɛseɛ no ano. ");
INSERT INTO twiasante_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Mo hyeɛ a ɛwɔ atɔeɛ no bɛyɛ Po Kɛseɛ a ɛda hɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Mo hyeɛ a ɛda atifi no bɛfiti aseɛ wɔ Po Kɛseɛ no ano, na atoa so akɔ apueeɛ fam akɔsi bepɔ Hor, ");
INSERT INTO twiasante_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","de akɔ Lebo Hamat na akɔ Sedad ");
INSERT INTO twiasante_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ne Sifron akɔ Hasar-Enan. ");
INSERT INTO twiasante_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Apueeɛ hyeɛ no bɛfiri Hasar-Enan anafoɔ akɔ Sefam ");
INSERT INTO twiasante_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","akɔsi Ribla wɔ Ain apueeɛ fam. Ɛfiri hɔ a, ɛbɛkɔ akɔpem Kineret ɛpo no wɔ apueeɛ fam, ");
INSERT INTO twiasante_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","na asiane afiri Asubɔnten Yordan, na akɔpem Nkyene Ɛpo no. “ ‘Sɛdeɛ mo asase ahyeɛ teɛ nie.’ ” ");
INSERT INTO twiasante_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Afei Mose ka kyerɛɛ Israelfoɔ no sɛ, “Yei ne asase a mobɛbɔ so ntonto akyekyɛ afa no. Awurade ahyɛ sɛ mmusua nkron ne fa a aka no na wɔbɛkyekyɛ mu afa. ");
INSERT INTO twiasante_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Ruben ne Gad mmusuakuo no ne Manase abusua fa no deɛ, wɔama wɔn asase no bi ");
INSERT INTO twiasante_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","wɔ Yordan apueeɛ fam a ɛne Yeriko di nhwɛanimu no.” ");
INSERT INTO twiasante_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Nnipa a wɔn edin didi so yi na mayi wɔn sɛ wɔnkyekyɛ asase no mu: ɔsɔfoɔ Eleasa, Nun babarima Yosua. ");
INSERT INTO twiasante_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Yi abusua biara mu ɔpanin baako na ɔmmoa wɔn nni saa dwuma yi. ");
INSERT INTO twiasante_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“Wɔn edin na ɛdidi soɔ yi: “Yuda abusuakuo ntuanoni, Yefune babarima Kaleb; ");
INSERT INTO twiasante_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simeon abusuakuo ntuanoni, Amihud babarima Semuel; ");
INSERT INTO twiasante_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Benyamin abusuakuo ntuanoni, Kislon babarima Elidad; ");
INSERT INTO twiasante_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dan abusuakuo ntuanoni, Yogli babarima Buki; ");
INSERT INTO twiasante_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Yosef babarima Manase abusuakuo ntuanoni, Efod babarima Haniel; ");
INSERT INTO twiasante_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Yosef babarima Efraim abusuakuo ntuanoni, Siftan babarima Kemuel; ");
INSERT INTO twiasante_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Parknak babarima Elisafan, Sebulon abusuakuo ntuanoni; ");
INSERT INTO twiasante_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Asan babarima Paltiel, Isakar abusuakuo ntuanoni; ");
INSERT INTO twiasante_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Selomi babarima Ahihud, Aser abusuakuo ntuanoni; ");
INSERT INTO twiasante_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Amihud babarima Pedahel, Naftali abusuakuo ntuanoni.” ");
INSERT INTO twiasante_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Saa nnipa yi na Awurade yii wɔn sɛ wɔnhwɛ nkyekyɛ Kanaan asase no mu mma Israelfoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Ɛberɛ a Israelfoɔ bɔɔ atenaseɛ wɔ Yordan ho, Moab tata so a ɛne Yeriko di nhwɛanimu no, Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Ka kyerɛ Israelfoɔ no na wɔmfa wɔn agyapadeɛ no mu bi a ɛyɛ nkuro ne ɛho mmoa adidibea mma Lewifoɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Nkuro no mu na wɔbɛtena na wɔn anantwie, wɔn nnwan ne wɔn mmoa a aka no nso akɔ adidi wɔ adidibea hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Wɔn mmoa adidibea no kɛseɛ bɛfiri kuro no afasuo ho a ne fa biara tɛtrɛtɛ yɛ anammɔn apem ne ahanum. ");
INSERT INTO twiasante_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Monsusu anammɔn mpensa mfiri kuro no afasuo no ho wɔ nʼafanan nyinaa. Yei bɛyɛ adidibea kɛseɛ ama nkuro no. ");
INSERT INTO twiasante_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Momma Lewifoɔ no dwanekɔbea nkuropɔn nsia, baabi a obi a wafom akum ɔfoforɔ no bɛtumi adwane akɔ. Momfa nkuro aduanan mmienu nka wɔn ho. ");
INSERT INTO twiasante_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Ne nyinaa bɛyɛ nkuro aduanan nwɔtwe ne ho adidibea. ");
INSERT INTO twiasante_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Saa nkuro yi bɛfiri Israelfoɔ no agyapadeɛ mu. Mmusuakuo no mu akɛseɛ bɛma Lewifoɔ no nkuro bebree na mmusuakuo nketewa no ama kakraa. Abusuakuo biara bɛma sɛdeɛ nʼagyapadeɛ kɛseɛ teɛ.” ");
INSERT INTO twiasante_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Awurade ka kyerɛɛ Mose sɛ, ");
INSERT INTO twiasante_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Ka kyerɛ nnipa no sɛ, sɛ wɔduru asase no so a, ");
INSERT INTO twiasante_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","wɔnyi Dwanekɔbea Nkuro a wɔde bɛma obiara a wafom akum onipa na ɔpɛ sɛ ɔdwane kɔ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Saa nkuro yi bɛyɛ dwanekɔbea ama owudifoɔ no afiri owufoɔ no abusuafoɔ a wɔpɛ sɛ wɔtɔ owufoɔ no wuo so awere; na ɛnsɛ sɛ wɔkum owudifoɔ no, gye sɛ wɔadi nʼasɛm abu no kumfɔ. ");
INSERT INTO twiasante_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Ɛsɛ sɛ wɔsisi Dwanekɔbea Nkuro yi mu mmiɛnsa wɔ Kanaan asase so ");
INSERT INTO twiasante_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","na wɔsisi mmiɛnsa nso wɔ Asubɔnten Yordan apueeɛ fam. ");
INSERT INTO twiasante_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Ɛnyɛ Israelfoɔ nko na ɛhɔ bɛyɛ wɔn dwanekɔbea, na mmom, ɛbɛyɛ dwanekɔbea ama ahɔhoɔ ne akwantufoɔ nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“Nanso, sɛ obi de dadeɛ poma sin bi bɔ obi kum no a, wɔfa no sɛ wadi awu, enti ɛsɛ sɛ wɔkum owudifoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Anaasɛ, sɛ wɔde ɛboɔ kɛseɛ bi bɔɔ owufoɔ no a, ɛyɛ awudie enti ɛsɛ sɛ wɔkum owudifoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Saa ara nso na sɛ wɔde dua na wɔde kumm no a, ɛte ara ne no. ");
INSERT INTO twiasante_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Sɛ ɔweretɔfoɔ no hyia owudifoɔ no baabiara a, ɔwɔ ho kwan sɛ ɔkum no bi. ");
INSERT INTO twiasante_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Enti, sɛ obi nam ɔtan so to biribi bɔ obi, anaasɛ ɔtetɛ no, ");
INSERT INTO twiasante_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","anaa ɔde abufuo bɔ no kuturuku na onii no wu a, ɔyɛ owudifoɔ enti ɛsɛ sɛ ɔweretɔfoɔ no kum owudifoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“Na sɛ nkwanhyia no mu, sɛ obi anhyɛ da na ɔtoo biribi anaa ɛboɔ bi a wanto no abufuo so, na ɔnnim sɛ ɛbɛbɔ obi ");
INSERT INTO twiasante_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","anaasɛ ɛnyɛ nʼadwene sɛ ɔbɛha ne ɔtamfoɔ, na sɛ onipa ko no wu a, ");
INSERT INTO twiasante_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ɛsɛ sɛ wɔdi asɛm no. Wɔbɛhwɛ sɛ ɛyɛ nkwanhyia anaa ɛnyɛ nkwanhyia, anaasɛ ɛsɛ sɛ wɔde saa onipa no hyɛ owufoɔ no weretɔni nsa anaa wɔmmfa no nhyɛ ne sa. ");
INSERT INTO twiasante_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Sɛ wɔsi gyinaeɛ sɛ ɛyɛ nkwanhyia a, nnipa no bɛgye owudifoɔ no afiri ɔweretɔfoɔ no nsam. Wɔbɛma owudifoɔ no atena Dwanekɔbea Kuro no mu hɔ ara akɔsi sɛ ɔsɔfopanin bɛwu. ");
INSERT INTO twiasante_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“Sɛ owudifoɔ no firi kuro no mu ");
INSERT INTO twiasante_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","na ɔweretɔni no hyia no na ɔkum no tua ka a, wɔmmfa no sɛ ɛyɛ awudie, ");
INSERT INTO twiasante_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ɛfiri sɛ, anka ɛsɛ sɛ owudifoɔ no tena kuro no mu kɔsi mmerɛ a ɔsɔfopanin no bɛwu. Ɔsɔfopanin no wuo akyi no, owudifoɔ no tumi kɔ ne kurom. ");
INSERT INTO twiasante_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“Yei yɛ Israelfoɔ mmara a ɛwɔ hɔ daa firi awoɔ ntoatoasoɔ so kɔsi awoɔ ntoatoasoɔ so. ");
INSERT INTO twiasante_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“Ɛsɛ sɛ wɔkum awudifoɔ nyinaa. Nanso gye sɛ adansefoɔ boro onipa baako di tia no ansa na ɛsɛ sɛ wɔkum no. Sɛ onipa baako di adanseɛ tia no nso a, ɛnsɛ sɛ wɔkum no. ");
INSERT INTO twiasante_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“Ɛberɛ biara a wɔbɛbua obi kumfɔ no, ɛsɛ sɛ ɔwuo a wɔnnye mpata biara. ");
INSERT INTO twiasante_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“Odwanefoɔ bi a ɔhyɛ Dwanekɔbea Kuropɔn no mu no nso nni ho ɛkwan sɛ ɔtua sika ma wɔma no ɛkwan kɔ ne kurom ansa na ɔsɔfopanin no awu. ");
INSERT INTO twiasante_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“Yei na ɛbɛma awerɛhyɛmu sɛ asase a mote so no ho rengu fi, ɛfiri sɛ, awudie gu asase ho fi. Wɔrentumi nyɛ mpatadeɛ foforɔ biara mma awudie gye sɛ wɔkum owudifoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Monngu asase a morekɔtena so no ho fi, ɛfiri sɛ, Me, Awurade mete hɔ bi. Mene Awurade a mete Israelfoɔ mu no.” ");
INSERT INTO twiasante_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Afei, Gilead abusua no ntuanofoɔ, Makir a ɔyɛ Manase babarima ne Yosef nana asefoɔ kɔɔ Mose ne Israel ntuanofoɔ nkyɛn de adesrɛdeɛ kɔtoo wɔn anim. ");
INSERT INTO twiasante_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Wɔkaa sɛ, “Awurade ka kyerɛɛ wo sɛ bɔ ntonto kronkron na gyina so kyekyɛ asase no ma Israelfoɔ. Awurade ka kyerɛɛ wo sɛ fa yɛn nuabarima Selofehad agyapadeɛ ma ne mmammaa. ");
INSERT INTO twiasante_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Na sɛ ɛba sɛ wɔn mu bi kɔware wɔ abusua foforɔ mu a, ɔde asase a wɔde ama no no bɛkɔ awadeɛ. Sɛ ɛba saa a, yɛn abusua no asase kɛseɛ so bɛte. ");
INSERT INTO twiasante_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Sɛ Mfirinhyia Aduonum Afahyɛ no duru so a, saa agyapadeɛ no bɛka hɔ ara. Na ɛbɛfiri abusuakuo a anka ɛwɔ no no nsam koraa.” ");
INSERT INTO twiasante_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Enti Mose de saa ɔhyɛ nsɛm a ɛfiri Awurade yi maa Israelfoɔ no: “Yosef abusuakuo mu nnipa no asɛm no yɛ nokorɛ. ");
INSERT INTO twiasante_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Awurade ɔhyɛ nsɛm a ɛfa Selofehad mmammaa no ho no nie: wɔtumi ware ɔbarima biara a wɔpɛ a ɔfiri wɔn agya abusuakuo mu. ");
INSERT INTO twiasante_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Ɛnsɛ sɛ agyapadeɛ biara firi abusuakuo bi nsam kɔ abusuakuo foforɔ nsam, ɛfiri sɛ, ɛsɛ sɛ abusuakuo biara agyapadeɛ tena hɔ sɛdeɛ ɛteɛ firi kane no. ");
INSERT INTO twiasante_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Mmammaa a wɔwɔ Israel mmusuakuo mu nyinaa a agyapadeɛ tumi kɔ wɔn nsam no, ɛsɛ sɛ wɔwareware wɔ wɔn mmusuakuo mu na wɔn agyapadeɛ amfiri wɔn abusuakuo mu. ");
INSERT INTO twiasante_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Ɛnsɛ sɛ agyapadeɛ biara firi abusuakuo bi nsam kɔdi ɔfoforɔ nsam, ɛsɛ sɛ Israel abusuakuo biara bɔ nʼagyapadeɛ ho ban.” ");
INSERT INTO twiasante_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Selofehad mmammaa no yɛɛ sɛdeɛ Awurade hyɛɛ Mose no. ");
INSERT INTO twiasante_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Mahla, Tirsa, Hogla, Milka ne Noa nyinaa warewaree wɔn agyanom nuammarima mma. ");
INSERT INTO twiasante_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Wɔwarewaree wɔ Yosef babarima Manase mmusua mu enti wɔn agyapadeɛ no kaa wɔn abusuakuo mu. ");
INSERT INTO twiasante_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Yei ne mmara ne nhyehyɛeɛ a Awurade nam Mose so de maa Israelfoɔ ɛberɛ a wɔbɔɔ atenaeɛ wɔ Moab tata so so, wɔ Asubɔnten Yordan a ɛne Yeriko di nhwɛanimu no ho.");
INSERT INTO twiasante_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Yei ne nsɛm a Mose ka kyerɛɛ Israelfoɔ nyinaa wɔ ɛserɛ no so wɔ Yordan apueeɛ. Wɔbɔɔ atenaeɛ wɔ Yordan bɔnhwa a ɛbɛn Suf, wɔ Paran, Tofel, Laban, Haserot ne Di-Sahab ntam no. ");
INSERT INTO twiasante_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Ɛfiri Horeb de kɔ Kades-Barnea no, ɛkwan a ɛfa bepɔ Seir no yɛ nnafua dubaako kwan. ");
INSERT INTO twiasante_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Israelfoɔ firii Bepɔ Sinai no, afe a ɛtɔ so aduanan no bosome dubaako no ɛda a ɛdi ɛkan no, Mose kaa nsɛm a Awurade hyɛɛ no sɛ ɔnka nkyerɛ Israelfoɔ no pɛpɛɛpɛ kyerɛɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Ɔkaa saa asɛm yi wɔ ɛberɛ a na wɔadi Amorifoɔ ɔhene Sihon a na ɔdi adeɛ wɔ Hesbon ne Basanhene Og a na ɔdi adeɛ wɔ Astarot ne Edrei so nkonim. ");
INSERT INTO twiasante_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Yordan agya a ɛwɔ Moab asase so na Mose firii aseɛ kyerɛkyerɛɛ mmara no mu sɛ: ");
INSERT INTO twiasante_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Awurade ka kyerɛɛ yɛn wɔ Horeb sɛ: “Moatena saa bepɔ yi so akyɛre dodo. ");
INSERT INTO twiasante_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Montutu nkɔtena Amorifoɔ nkokoɔ so; monkɔtena nnipa a wɔbemmɛn Araba mmepɔ no mu ne atɔeɛ mmepɔ ayaase nyinaa mu; monkɔ Negeb na momfa mpoano nkɔsi Kanaanfoɔ asase so ne Lebanon nkɔduru Asubɔnten Eufrate ho. ");
INSERT INTO twiasante_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Montie! Mede saa asase yi ama mo. Monkɔ na monkɔfa asase a Awurade hyɛɛ bɔ sɛ ɔde bɛma mo agyanom Abraham, Isak ne Yakob ne wɔn asefoɔ no.” ");
INSERT INTO twiasante_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Saa ɛberɛ no, meka kyerɛɛ nnipa no sɛ, “Me nko ara merentumi nyɛ mo ho adwuma. ");
INSERT INTO twiasante_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Awurade, mo Onyankopɔn, ama moadɔre enti ɛnnɛ yi, mo ase afɛe te sɛ ɔsoro nsoromma. ");
INSERT INTO twiasante_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Awurade mo agyanom Onyankopɔn mma mo nnɔre mmɔho mpempem na ɔnhyira mo sɛdeɛ wahyɛ mo bɔ no. ");
INSERT INTO twiasante_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Na ɛbɛyɛ dɛn na me nko mɛtumi masoa mo haw ne mo nnesoa ne mo aperedie? ");
INSERT INTO twiasante_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Monyi mmarima bi a wɔwɔ nyansa, nteaseɛ, na wɔwɔ edin pa mfiri abusuakuo biara mu na memfa wɔn ntuatua mo ano.” ");
INSERT INTO twiasante_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Mobuaa me sɛ, “Dwuma a woasusu sɛ wobɛdi no yɛ.” ");
INSERT INTO twiasante_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Enti, mede mo mmusuakuo mu mmarima atitire, anyansafoɔ a wɔn anim wɔ nyam no tuatuaa mo ano apem apem, ɔha ɔha, aduonum aduonum ne edu edu so mpanin ne mo mmusuakuo so sɛ ahwɛfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Na atemmufoɔ a wɔwɔ hɔ saa ɛberɛ no nso, mehyɛɛ wɔn sɛ, sɛ akasakasa ba anuanom ntam, sɛ asɛm no yɛ Israelni ne ne nua bi anaa Israelni ne ɔhɔhoɔ bi a, monhwɛ na mommu atɛntenenee. ");
INSERT INTO twiasante_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Mo atemmuo mu, mommmu ntɛnkyea. Montie ɔketewa ne ɔkɛseɛ pɛ. Monnsuro onipa biara, ɛfiri sɛ, Onyankopɔn na ɔbu atɛn. Asɛm a ɛyɛ den ma mo no, momfa mmrɛ me na menni. ");
INSERT INTO twiasante_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Na saa ɛberɛ no, mekaa biribiara a ɛsɛ sɛ moyɛ kyerɛɛ mo. ");
INSERT INTO twiasante_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Na sɛdeɛ Awurade hyɛɛ yɛn no, yɛfirii Horeb de yɛn ani kyerɛɛ Amorifoɔ bepɔ a yɛnam ɛserɛ pradada a moahunu no so kɔduruu Kades-Barnea. ");
INSERT INTO twiasante_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Afei, meka kyerɛɛ mo sɛ, “Moaduru Amorifoɔ bepɔman a Awurade de rema yɛn no so. ");
INSERT INTO twiasante_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Awurade, mo Onyankopɔn, de asase no ama mo. Momforo nkɔfa sɛdeɛ Awurade, mo agyanom Onyankopɔn, ka kyerɛɛ mo no. Monnsuro: mommma obi ntu mo aba mu.” ");
INSERT INTO twiasante_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Ɛnna mo nyinaa baa me nkyɛn bɛkaa sɛ, “Momma yɛnsoma mmarima nni yɛn anim na wɔnkɔsra asase no mma yɛn na wɔmmɛka deɛ wɔbɛhunu nkyerɛ yɛn na ɛno na ɛbɛkyerɛ yɛn ɛkwan ne nkuro ko a yɛbɛfa so.” ");
INSERT INTO twiasante_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Na saa nsusuiɛ yi yɛ ma me enti meyii akwansrafoɔ dumienu a ɔbaako biara firi mo mmusuakuo dumienu no mu. ");
INSERT INTO twiasante_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Wɔforoo bepɔ no na wɔkɔduruu Eskol subɔnhwa mu sraa hɔ. ");
INSERT INTO twiasante_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Na wɔfaa asase no so aba bi de brɛɛ yɛn. Na wɔkaa sɛ, asase a Awurade yɛn Onyankopɔn de ama yɛn no yɛ asase pa. ");
INSERT INTO twiasante_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Nanso, na mompɛ sɛ moforo kɔ soro. Motee Awurade asɛm so atua. ");
INSERT INTO twiasante_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Monwiinwii wɔ mo ntomadan mu kaa sɛ, “Awurade tan yɛn enti na ɔde yɛn firi Misraim de yɛn abɛhyɛ Amorifoɔ nsam sɛ wɔnkunkum yɛn. ");
INSERT INTO twiasante_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Yɛrekɔ no sɛn? Yɛn akwansrafoɔ no amanneɛbɔ no abu yɛn aba mu. ‘Wɔka sɛ asase no so nnipa yɛ atentene ahoɔdenfoɔ sene yɛn. Wɔn nkuro yɛ akɛseɛ a afasuo a wɔatoto afa ho no kɔ ɔsorosoro. Na mpo, yɛhunuu Anakfoɔ mma no bi wɔ hɔ!’ ” ");
INSERT INTO twiasante_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Na meka kyerɛɛ mo sɛ, “Monnsuro! ");
INSERT INTO twiasante_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Awurade di mo anim. Ɔbɛko ama mo sɛdeɛ mohunuu no sɛ ɔyɛɛ wɔ Misraim no. ");
INSERT INTO twiasante_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Na mohunuu nso sɛdeɛ Awurade kɔɔ so hwɛɛ mo ntoatoasoɔ wɔ ɛserɛ so ha sɛdeɛ agya hwɛ ne ba no. Afei, ɔde mo abɛduru beaeɛ ha.” ");
INSERT INTO twiasante_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Nanso, deɛ ɔyɛ maa mo no nyinaa akyi no, moannye Awurade anni. ");
INSERT INTO twiasante_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","Ɔdii mo anim pɛɛ beaeɛ pa maa mo tenaeɛ, de ogyadum kyerɛɛ mo ɛkwan anadwo de omununkum dum kyerɛɛ mo ɛkwan awia. ");
INSERT INTO twiasante_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Awurade tee sɛ morenwiinwii no, ne bo fuu yie na ɔkaa ntam sɛ, ");
INSERT INTO twiasante_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Saa awoɔ ntoatoasoɔ bɔne yi mu, onipa baako koraa nni hɔ a ɔbɛhunu asase pa a maka ho ntam sɛ mede bɛma mo agyanom ");
INSERT INTO twiasante_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","agye Yefune babarima Kaleb. Ɔno na ɔbɛhunu saa asase yi. Mede asase a ne nan sii so no bɛma ɔne nʼasefoɔ, ɛfiri sɛ, wadi Awurade akyi nokorɛm.” ");
INSERT INTO twiasante_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Me nso, ɛsiane mo enti, Awurade bo fuu me. Ɔka kyerɛɛ me sɛ, “Wo nan rensi Bɔhyɛ Asase no so da! ");
INSERT INTO twiasante_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Na mmom, wo ɔboafoɔ Nun babarima Yosua na ɔbɛdi ɔmanfoɔ no anim akɔ asase no so. Na sɛ ɔreboa ne ho akɔ hɔ a, hyɛ no nkuran. ");
INSERT INTO twiasante_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Mede asase no bɛma wo mma a wɔnnim biribiara. Wo mma a wɔnnim papa nnim bɔne no. Na mosuro sɛ wɔbɛfa wɔn nnommum, nanso wɔn na mede asase no bɛma wɔn. Wɔn na wɔbɛtena asase no so. ");
INSERT INTO twiasante_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Na mo deɛ, monnane mo ani nkɔ ɛserɛ so a ɛrekɔ Ɛpo Kɔkɔɔ no so hɔ.” ");
INSERT INTO twiasante_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Ɛnna mogye too mu sɛ “Yɛayɛ bɔne atia Awurade. Yɛbɛkɔ asase no so akɔko sɛdeɛ Awurade aka akyerɛ yɛn no.” Enti, wɔfaa wɔn akodeɛ miaeɛ. Na wɔgye di sɛ ɛhɔ sodie bɛyɛ mmerɛ ama wɔn. ");
INSERT INTO twiasante_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Nanso, Awurade ka kyerɛɛ me sɛ, “Ka kyerɛ wɔn sɛ, ‘Mma wɔnnkɔko, ɛfiri sɛ, wɔkɔ a merenni wɔn akyi. Wɔn atamfoɔ no bɛdi wɔn so.’ ” ");
INSERT INTO twiasante_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Asɛm a meka kyerɛɛ mo ni, nanso moantie. Na mmom, mosɔre tiaa Awurade ahyɛdeɛ no bio nam ahomasoɔ so kɔɔ asase no so kɔkoeɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Amorifoɔ a wɔte bepɔ no so nso sɔre baa sɛ nwowa ne mo koeɛ. Wɔtaa mo kunkumm mo firii Seir kɔduruu Horma. ");
INSERT INTO twiasante_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Afei, mosane baa mo akyi bɛsuu wɔ Awurade anim, nanso wantie. ");
INSERT INTO twiasante_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Enti, motenaa Kades nna bebree. ");
INSERT INTO twiasante_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Afei, yɛsane yɛn akyi de yɛn ani kyerɛɛ ɛserɛ so wɔ baabi a Ɛpo Kɔkɔɔ no da hɔ sɛdeɛ Awurade kyerɛɛ me sɛ menyɛ no. Yɛnantenante faa Seir bepɔ ho nna bebree. ");
INSERT INTO twiasante_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Akyire no, Awurade ka kyerɛɛ me sɛ, ");
INSERT INTO twiasante_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Moatwa afa saa bepɔ yi ho akyɛre yie enti monnane mo ani nkyerɛ atifi fam. ");
INSERT INTO twiasante_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Hyɛ ɔman no sɛ, ‘Mobɛfa mo nuanom Edomfoɔ a wɔyɛ Esau asefoɔ a wɔte Seir no asase so. Edomfoɔ no bɛsuro mo, nanso monhwɛ yie. ");
INSERT INTO twiasante_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Monnhyɛ wɔn abufuo a ɛde ɔko bɛba, na meremfa wɔn nsase no mu biara mma mo; mpo, baabi a mode mo nan bɛtia, ɛfiri sɛ, mede Seir bepɔ kuro ama Esau sɛ nʼatenaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Aduane biara a mobɛdi ne nsuo biara a mobɛnom no, montua wɔn ho ka.’ ” ");
INSERT INTO twiasante_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Awurade ahyira mo nsa ano nnwuma nyinaa. Wahwɛ mo so wɔ mo akwantuo wɔ ɛserɛ kakraa yi nyinaa so. Saa mfeɛ aduanan yi nyinaa mu, Awurade aka mo ho na hwee ho anhia mo. ");
INSERT INTO twiasante_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Yɛtwa faa yɛn nuanom a wɔyɛ Esau asefoɔ a wɔte Seir no ho. Yɛfaa Araba subɔnhwa ɛkwan no a ɛfiri Elat ne Esion-Geber no so na yɛbɛfaa Moab ɛserɛ so ɛkwan no so. ");
INSERT INTO twiasante_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Awurade ka kyerɛɛ me sɛ, “Monnha Moabfoɔ no anaa monnteetee wɔn sɛdeɛ ɛde ɔko bɛba, na meremfa wɔn nsase no mu biara mma mo. Ɛfiri sɛ, mede Ar ama Lot asefoɔ sɛ agyapadeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Kane no na Emifoɔ na wɔte hɔ. Na wɔsoso na wɔdɔɔso a wɔwoware te sɛ Anakfoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Wɔn nso, na wɔyɛ abrane sɛ Anakfoɔ no ara pɛ, a na wɔfrɛ wɔn Refaimfoɔ, nanso Moabfoɔ deɛ, na wɔfrɛ wɔn Emifoɔ. ");
INSERT INTO twiasante_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Kane no na Horifoɔ na wɔte Seir, nanso Esau asefoɔ tuu wɔn firii hɔ. Wɔsɛee Horifoɔ no tenaa wɔn ananmu sɛdeɛ Israel yɛɛ wɔ asase a Awurade de maa wɔn sɛ wɔn agyapadeɛ no so no pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Awurade kaa sɛ, “Afei, sɔre na kɔtwa asuwa Sered no.” Na yɛkɔtwaa asuwa Sered. ");
INSERT INTO twiasante_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Na nna dodoɔ a yɛde nante firi Kades-Barnea bɛsii sɛ yɛtwaa asuwa Sered no yɛ mfirinhyia aduasa nwɔtwe. Saa ɛberɛ no, na mmarima a wɔanyinyini yie a wɔbɛtumi akɔ ɔko no nyinaa awuwu wɔ ɛserɛ no so sɛdeɛ Awurade kaeɛ no. ");
INSERT INTO twiasante_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Na Awurade nsa tiaa wɔn ara kɔsi sɛ wɔn nyinaa bɛwuwuu wɔ wɔn atenaeɛ hɔ. ");
INSERT INTO twiasante_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Akofoɔ no nyinaa wuwu firii nnipa no mu pɛ, ");
INSERT INTO twiasante_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Awurade ka kyerɛɛ me sɛ, ");
INSERT INTO twiasante_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Ɛnnɛ, ɛsɛ sɛ wofa Ar kɔsi Moab mantam mu. ");
INSERT INTO twiasante_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Na sɛ woduru Amonfoɔ mu a, nha wɔn anaa nhyɛ wɔn ahometeɛ a ɛde wɔn bɛkɔ ɔko mu, ɛfiri sɛ, meremma mo Amorifoɔ nsase no bi. Mede ama Lot asefoɔ sɛ agyapadeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Saa beaeɛ hɔ na abrane akɛseɛ a na Amonfoɔ frɛ wɔn Samsumin no na wɔte kane no. ");
INSERT INTO twiasante_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Na wɔyɛ nnipa ahoɔdenfoɔ a wɔdɔɔso na wɔwoware te sɛ Anakfoɔ no. Na Awurade sɛee Samsumifoɔ no wɔ Amonfoɔ anim ma wɔtuu wɔn tenaa wɔn anan mu. ");
INSERT INTO twiasante_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Saa ara na Awurade sɛee Horifoɔ wɔ Esau asefoɔ a na wɔte Seir no anim ma wɔtuu wɔn, tenaa wɔn anan mu de bɛsi ɛnnɛ yi. ");
INSERT INTO twiasante_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Na Awifoɔ nso a wɔtenaa nkuraa nkuraa hwete kɔduruu Gasa no nso, Kaftorfoɔ a wɔfiri Kaftor bɛsɛee wɔn, tenaa wɔn anan mu. ");
INSERT INTO twiasante_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Sɔre kɔtwa Arnon subonhwa. Mede Hesbonhene Sihon a ɔyɛ Amorini no ne nʼasase ahyɛ wo nsa. Kɔto hyɛ ne so, na monko, na fa nʼasase no. ");
INSERT INTO twiasante_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Ɛfiri ɛnnɛ yi ara, mede mo ho suro ne hu bɛhyɛ aman a wɔwɔ ɔsoro ase nyinaa mu. Wɔbɛte mo ho nsɛm na wɔn ho bɛpopo na mo enti, wɔanya adwenemhaw.” ");
INSERT INTO twiasante_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Metuu abɔfoɔ firii Kedemot ɛserɛ so kɔɔ Hesbonhene Sihon nkyɛn asomdwoeɛ so kɔka kyerɛɛ no sɛ, ");
INSERT INTO twiasante_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Ma yɛntwam wʼasase so ha. Yɛbɛfa ɛkwan tempɔn mu a yɛremmane mfa benkum anaa nifa so baabiara. ");
INSERT INTO twiasante_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Tɔn aduane ma yɛnni na tɔn nsuo nso ma yɛnnom. Deɛ yɛrehwehwɛ ara ne ɛkwan a wobɛma yɛn ama yɛatwam wɔ wʼasase so, ");
INSERT INTO twiasante_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","sɛdeɛ Esau asefoɔ a na wɔte Seir ne Moabfoɔ a na wɔte Ar yɛɛ yɛn no. Ma yɛntwam nkɔsi sɛ yɛbɛtwam Yordan akɔsi asase a Awurade de ama yɛn no so.” ");
INSERT INTO twiasante_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Nanso, Hesbonhene Sihon amma yɛamfa nʼasase so antwam. Ɛfiri sɛ, Awurade yɛɛ ne honhom sisirii, pirim nʼakoma sɛdeɛ ɔnam so de no bɛhyɛ wo nsam nam so adi wɔn so nkonim sɛdeɛ wayɛ no ɛnnɛ yi. ");
INSERT INTO twiasante_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Awurade ka kyerɛɛ me sɛ, “Mafiti aseɛ de Sihon ne ne ɔman ahyɛ wo nsam. Afei, fiti aseɛ na di wɔn so, na fa nʼasase no.” ");
INSERT INTO twiasante_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Ɛberɛ a Sihon ne ne dɔm bɛhyiaa yɛn ɔko so wɔ Yahas no, ");
INSERT INTO twiasante_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Awurade de no maa yɛn ma yɛdii ɔno, ne ne manfoɔ nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Na yɛfaa ne nkuro nyinaa saa ɛberɛ no sɛee ne mmarima, mmaa ne mmɔfra a wɔwɔ kuropɔn biara mu a yɛannya obiara, ");
INSERT INTO twiasante_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","gye afieboa nko na yɛfomm wɔn faeɛ, ɛnna nkuro a yɛfaeɛ no mu asadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Ɛfiri Aroer a ɛda Arnon subɔnhwa ano ne kuro a ɛda subɔnhwa no mu no so de kɔsi Gilead no, kuro biara nni hɔ a na ɛsodie yɛ den ma yɛn; Awurade de ne nyinaa hyɛɛ yɛn nsa. ");
INSERT INTO twiasante_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Nanso, yɛammɛn Amorifoɔ a na wɔwɔ Asubɔnten Yabok ho ne mmepɔ no so nkuro no baabiara a Awurade yɛn Onyankopɔn hyɛɛ yɛn sɛ yɛnnkɔ no. ");
INSERT INTO twiasante_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Afei, yɛde yɛn ani kyerɛɛ Basan ɛkwan so. Basanhene Og ne nʼasraadɔm firi bɛhyiaa yɛn wɔ Edrei ne yɛn koeɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Nanso, Awurade ka kyerɛɛ me sɛ, “Nsuro no, ɛfiri sɛ, mede ɔno ne nʼakodɔm ne nʼasase nyinaa ahyɛ wo nsa. Asɛm a ɛtoo Amorifoɔhene Sihon wɔ Hesbon no, saa asɛm korɔ no ara bi na ɛbɛto no.” ");
INSERT INTO twiasante_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Enti, Awurade, yɛn Onyankopɔn, sane de Basanhene Og ne nʼakodɔm nyinaa hyɛɛ yɛn nsa. Yɛbɔɔ wɔn guiɛ a anka wɔn mu baako koraa. ");
INSERT INTO twiasante_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Saa ɛberɛ no, yɛfaa wɔn nkuropɔn nyinaa. Nkuropɔn aduosia no mu baako koraa nni hɔ a yɛannye amfiri wɔn nsam. Argob mantam a ɛyɛ Og ahenkuro wɔ Basan nyinaa ka ho. ");
INSERT INTO twiasante_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Saa nkuropɔn yi nyinaa, na wɔato afasuo atentene afa ho de nnadeɛ apono atoto ano. Saa ɛberɛ korɔ no ara mu, yɛfaa nkuraa a na wɔntoo afasuo mfaa ho bebree. ");
INSERT INTO twiasante_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Yɛsɛee Basan kuropɔn no korakora sɛdeɛ yɛsɛee Hesbonhene Sihon no. Yɛsɛee nkuro no ne emu mmarima, mmaa ne mmɔfra nyinaa pasapasa. ");
INSERT INTO twiasante_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Nanso, afieboa nyinaa ne nkuro no mu asadeɛ deɛ, yɛfom faeɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Amorifoɔ ahemfo baanu nsase a na ɛdeda Asubɔnten Yordan apueeɛ fam no nyinaa, yɛfaeɛ—nsase a ɛfiri Arnon subɔnhwa kɔsi bepɔ Hermon so nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Sidonfoɔ frɛ no Hermon Sirion ɛnna Amorifoɔ frɛ no Senir. ");
INSERT INTO twiasante_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Yɛadi nkuropɔn a ɛwɔ bepɔ no apampam no nyinaa so a Gilead ne Basan ka ho de kɔsi nkuro a ɛwɔ Saleka ne Edrei, a na ɛyɛ Og ahemman wɔ Basan no nso ka ho bi. ");
INSERT INTO twiasante_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Abrane no deɛ, Basanhene Og nko na na waka. Ne dadeɛ mpa tenten boro anammɔn dumiɛnsa ɛnna ne tɛtrɛtɛ yɛ anammɔn nsia. Ɛda so wɔ Amonfoɔ kuropɔn Raba mu seesei ara. ");
INSERT INTO twiasante_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Yɛfaa asase no, mede asase no fa a ɛda firi Aroer Arnon subɔnhwa mu ne Gilead bepɔ fa ne ne nkuro no maa Rubenfoɔ ne Gadfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Afei, mede asase no nkaeɛ a ɛyɛ Gilead ne Basan nyinaa a ɛyɛ na anka ɛyɛ Og ahemman no maa Manase abusua fa no. Saa Basan no nyinaa na wɔfrɛ no abrane asase. ");
INSERT INTO twiasante_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Manase abusua ɔkannifoɔ Yair faa Argob asase no nyinaa a ɛne Basan kɔsii Gesurfoɔ ne Maakatfoɔ hyeɛ so. Ɔde ne din too asase no frɛɛ hɔ Hawot-Yair de bɛsi ɛnnɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Mede Gilead maa Makir, ");
INSERT INTO twiasante_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Rubenfoɔ ne Gadfoɔ no, memaa wɔn asase bi a ɛfiri Gilead fa bi, kɔsi Arnon subɔnhwa ho, de kɔsi Asubɔnten Yabok a ɛyɛ Amonfoɔ hyeɛ no so. ");
INSERT INTO twiasante_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Atɔeɛ hyeɛ no firi Asubɔnten Yordan a ɛda Araba a ɛfiri Kineret kɔsi Nkyene Ɛpo a ɛda Pisga bepɔ ayaase no. ");
INSERT INTO twiasante_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Na mehyɛɛ mo saa ɛberɛ no sɛ, “Awurade mo Onyankopɔn de asase yi ama mo sɛ momfa. Nanso mo mmarima akofoɔ nyinaa nhyɛ akodeɛ nni mo nuanom Israelfoɔ anim ntwa Yordan. ");
INSERT INTO twiasante_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Mo yerenom, mo mma ne mo afieboa bebrebe no deɛ, monnya wɔn wɔ mo akyi wɔ nkuro a mede ama mo no so. ");
INSERT INTO twiasante_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Sɛ Awurade bɔ Israelfoɔ a wɔaka no ho ban na wɔtena asase a Awurade de ama wɔn a ɛtwam Asubɔnten Yordan no so a, afei motumi sane mo akyi ba asase a mede ama mo no so.” ");
INSERT INTO twiasante_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Saa ɛberɛ no, meka kyerɛɛ Yosua sɛ, “Woahunu deɛ Awurade wo Onyankopɔn ayɛ saa ahemfo baanu yi. Saa ara na ɔbɛyɛ ahemman a ɛwɔ Yordan atɔeɛ fam no nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Nsuro aman a wɔwɔ hɔ no na Awurade bɛko ama wo.” ");
INSERT INTO twiasante_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Saa ɛberɛ no, mesrɛɛ Awurade sɛ, ");
INSERT INTO twiasante_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Ao Otumfoɔ Awurade, meyɛ wʼakoa. Afei, na worekyerɛ me wo kɛseyɛ ne wo tumi. Onyame bɛn na ɔwɔ ɔsoro anaa asase so a ɔbɛtumi ayɛ mmaninneɛ te sɛ wo? ");
INSERT INTO twiasante_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Mesrɛ wo, ma me ntwa Yordan nkɔhwɛ asase nwanwa a ɛda ɛfa hɔ, ɔman fɛfɛ no ne Lebanon mmepɔ no.” ");
INSERT INTO twiasante_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Nanso ɛsiane mo enti, Awurade bo fuu me. Na wantie me. Na Awurade ka kyerɛɛ me sɛ “Ɛyɛ, nka saa asɛm yi ho hwee bio nkyerɛ me. ");
INSERT INTO twiasante_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Foro kɔ Pisga na hwɛ atɔeɛ ne atifi ne anafoɔ ne apueeɛ. Esiane sɛ, worentwa Yordan no enti, wʼankasa fa wʼani hwɛ asase no. ");
INSERT INTO twiasante_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Nanso, tu Yosua na bɔ nʼaba so, na hyɛ no den na ɔno na ɔbɛdi saa nnipa yi anim atwa na wama wɔadi asase a wʼani tua yi so.” ");
INSERT INTO twiasante_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Ɛno enti, yɛtenaa subɔnhwa a ɛbɛn Bet-Peor. ");
INSERT INTO twiasante_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Afei, Israel montie mmara ne nhyehyɛeɛ a merebɛkyerɛkyerɛ mo yi yie. Monni so na moanya nkwa, na moatumi akɔ asase a Awurade mo agyanom Onyankopɔn de rema mo no so na moatena hɔ. ");
INSERT INTO twiasante_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Mommfa bi nka ho, na monnyi biribiara nso mfiri mmara a Awurade mo Onyankopɔn de ama me sɛ memfa mma mo no mu, na mmom monni so. ");
INSERT INTO twiasante_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Mode mo ani hunuu deɛ Awurade yɛɛ mo wɔ Baal-peor no. Ɔsɛee nnipa pii a na wɔsom abosom no. ");
INSERT INTO twiasante_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Nanso, wɔn a na wɔdi Awurade mo Onyankopɔn nokorɛ nyinaa da so te ase bɛsi ɛnnɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Sɛ moduru asase a mobɛtena so no so a, yeinom ne mmara a ɛsɛ sɛ modi so. Ɛfiri Awurade, yɛn Onyankopɔn, nkyɛn. Ɔde ama me sɛ memfa mma mo. ");
INSERT INTO twiasante_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Sɛ modi so a, ɛbɛma mo agye nim wɔ adwene ne nyansa mu. Na sɛ aman a wɔatwa mo ho ahyia no te saa mmara yi a, wɔbɛteam sɛ, “Ɔman bɛn na wɔwɔ nyansa ne adwene sɛ Israel!” ");
INSERT INTO twiasante_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Ɔman kɛseɛ bɛn na ɛwɔ onyame a ɔbɛn wɔn pɛɛ te sɛ Awurade, yɛn Onyankopɔn, a yɛfrɛ no a ɔgye yɛn so yi? ");
INSERT INTO twiasante_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Na ɔman bɛn na ɛwɔ edin sei a ɛwɔ mmara pa te sɛ saa mmara yi a mede rema mo ɛnnɛ yi? ");
INSERT INTO twiasante_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Monhwɛ yie! Monhwɛ yie pa ara na mo werɛ amfiri deɛ moahunu sɛ Awurade yɛ ma mo. Sɛ mote ase yi, mommma saa nsɛm yi mfiri mo adwene mu da! Na monhwɛ nso sɛ mo mma ne mo nananom nso bɛte. ");
INSERT INTO twiasante_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Ka kyerɛ wɔn, ne titire no, ɛda a mokɔgyinaa Awurade mo Onyankopɔn anim wɔ bepɔ Horeb a ɔka kyerɛɛ me sɛ, “Frɛ ɔmanfoɔ no wɔ mʼanim na mɛkyerɛ wɔn deɛ wɔnyɛ no. Sɛ ɛba saa a, wɔbɛsua sɛdeɛ wɔbɛdi me ni berɛ dodoɔ a wɔte ase no, na ɛnam so ma wɔatumi akyerɛ wɔn mma mmara no.” ");
INSERT INTO twiasante_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Mobɛgyina bɛnee bepɔ no ayaase ɛberɛ a na bepɔ no rehye no. Egyaframa no tu kɔɔ soro a omununkum ne esum kabii aduru no. ");
INSERT INTO twiasante_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Na Awurade kasa faa ogya no mu kyerɛɛ mo. Motee nsɛm no, nanso moanhunu no. Ɛnne kɛkɛ na ɛbaeɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Ɔdaa nʼapam a ɔkyerɛɛ mo sɛ monni so no adi; mmaransɛm edu a ɔtwerɛɛ guu aboɔ ɛpono mmienu so no. ");
INSERT INTO twiasante_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Saa ɛberɛ no na Awurade hyɛɛ me sɛ memfa mmara a ɛsɛ sɛ modi so wɔ asase a morebɛhyɛne so akɔtena so no mma mo. ");
INSERT INTO twiasante_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Monhwɛ yie! Ɛberɛ a Awurade kasa faa ogya mu kyerɛɛ mo firi bepɔ Horeb so no, moanhunu no. ");
INSERT INTO twiasante_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Ɛno enti, Monnnaadaa mo ho nyɛ mfoni hunu bi wɔ mo tirim sɛ ɔyɛ ɔbaa anaa ɔbarima, ");
INSERT INTO twiasante_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","aboa anaa anomaa, ");
INSERT INTO twiasante_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","aboa a ɔwea fam anaa nsuomnam. ");
INSERT INTO twiasante_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Na sɛ mohwɛ ewiem na mohunu owia, ɔsrane ne nsoromma a, mma wɔnntwetwe mo nkɔsom wɔn. Awurade, mo Onyankopɔn, yɛɛ saa ewiem abɔdeɛ yi maa nnipa a wɔwɔ asase so nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Na mo deɛ, Awurade yii mo firii dadeɛ fononoo mu wɔ Misraim sɛ mommɛyɛ nʼadedifoɔ sɛdeɛ mote ɛnnɛ yi. ");
INSERT INTO twiasante_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Mo enti, Awurade bo fuu me yie. Ɔkaa ntam sɛ, merentwa Asubɔnten Yordan nkɔ asase pa a Awurade, mo Onyankopɔn, de rema mo sɛ mo agyapadeɛ sononko no so da. ");
INSERT INTO twiasante_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Ɛwom sɛ mobɛtwa Yordan akɔtena hɔ asase no so, na me deɛ, mɛwu wɔ asuo no fa ha. ");
INSERT INTO twiasante_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Enti, monhwɛ yie na moammu apam a Awurade, mo Onyankopɔn, ne mo ayɛ no so. Sɛ moyɛ abosom sɛso biara a mo Awurade mo Onyankopɔn abra mo no a, na ɛkyerɛ sɛ, moabu apam no so. ");
INSERT INTO twiasante_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Awurade, mo Onyankopɔn, yɛ Onyame ninkunfoɔ ne ogya a ɔhye adeɛ Onyankopɔn. ");
INSERT INTO twiasante_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Moawowo mma ne mmanana akyi, na moatena asase no so akyɛre no, sɛ bɔne fa mo na moyɛ ohoni bi nam so yɛ bɔne wɔ Awurade mo Onyankopɔn ani so nam so hyɛ no Abufuo a, ");
INSERT INTO twiasante_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","mefrɛ ɔsoro ne fam sɛ mʼadansefoɔ de tia mo saa ɛda yi sɛ, ntɛm so, mobɛhye afiri asase a moretwam wɔ so akɔ Yordan akɔfa no so. Morentena hɔ nkyɛ na wɔasɛe mo pasapasa. ");
INSERT INTO twiasante_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Na Awurade bɛbɔ mo apansam aman mu a mo mu kakra bi na wɔbɛtena ase. ");
INSERT INTO twiasante_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ɛhɔ a ɛyɛ ahɔhosase no so na mobɛsom ahoni a wɔde nnua ne aboɔ na ayɛ, anyame a wɔnhunu adeɛ na wɔnte asɛm na wɔnnidi nte hwa no. ");
INSERT INTO twiasante_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Ɛhɔ na mobɛpere bio ahwehwɛ Awurade mo Onyankopɔn. Na sɛ mode mo akoma ne mo kra nyinaa hwehwɛ no a, mobɛhunu no. ");
INSERT INTO twiasante_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Sɛ ɔhaw bi to mo na yeinom nyinaa ba mo so a, akyire no, mobɛsane akɔ Awurade mo Onyankopɔn nkyɛn na moayɛ ɔsetie ama no. ");
INSERT INTO twiasante_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Ɛfiri sɛ, mo Awurade mo Onyankopɔn no yɛ mmɔborɔhunu Onyankopɔn. Ɔrennya mo na ɔrensɛe mo anaa ne werɛ remfiri apam a ɔne mo agyanom pameeɛ a ɔkaa ntam sii so no. ");
INSERT INTO twiasante_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Hwehwɛ abakɔsɛm mu firi ɛberɛ a Onyankopɔn bɔɔ nnipa wɔ asase so bɛsi ɛnnɛ yi. Afei, hwehwɛ firi ɔsoro ano kɔsi ɔsoro ano. Hwɛ sɛ biribi kɛseɛ a ɛte sɛ yei asi pɛn anaasɛ woate biribi saa pɛn? ");
INSERT INTO twiasante_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Ɔman bi ate Onyankopɔn nne sɛ ɔrekasa afiri ogya mu sɛdeɛ moteeɛ na wɔda so te ase yi anaa? ");
INSERT INTO twiasante_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Onyame foforɔ bi nam ɔgye a ɔnam amanehunu, nsɛnkyerɛnneɛ a ɛyɛ nwanwa, ɔko, tumidie ne ahodwiredeɛ so agye ɔman bi afiri ɔman foforɔ bi nsam afa sɛ ne dea anaa? Nanso, saa na Awurade, mo Onyankopɔn, yɛ maa mo wɔ Misraim a mo ani hunuiɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Ɔdaa yeinom nyinaa adi kyerɛɛ mo sɛdeɛ ɛbɛyɛ a mobɛhunu sɛ Awurade yɛ Onyankopɔn a nʼakyi obi nni hɔ. ");
INSERT INTO twiasante_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Ɔmaa motee ne nne firi soro nam so tenetenee mo so. Ɔmaa mohunuu ne ogya fadum wɔ asase so, ɛnna motee ne nne firii ogya no mfimfini. ");
INSERT INTO twiasante_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Esiane sɛ na ɔpɛ mo agyanom asɛm, na ɔpɛɛ sɛ ɔhyira wɔn asefoɔ enti na ɔno ara nam ne tumi kɛseɛ so yii mo firii Misraim no. ");
INSERT INTO twiasante_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Ɔpamoo saa aman yi a na wɔn ho yɛ den sene mo wɔ mo anim sɛdeɛ mobɛba wɔn asase so abɛdi so sɛdeɛ ɛte ɛnnɛ yi. ");
INSERT INTO twiasante_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Enti, monkae na momma no ntim mo akoma mu: Awurade yɛ Onyankopɔn wɔ ɔsoro ne asase so, na onyame bi nka ne ho bio! ");
INSERT INTO twiasante_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Sɛ moyɛ ɔsetie ma mmara no ne ahyɛdeɛ no a mede bɛma mo ɛnnɛ no a, ɛbɛsi mo ne mo mma yie. Mobɛnyini akyɛre wɔ asase a Awurade mo Onyankopɔn de rema mo afebɔɔ no so. ");
INSERT INTO twiasante_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Afei, Mose yii nkuropɔn mmiɛnsa bi wɔ Yordan apueeɛ fam ");
INSERT INTO twiasante_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","a, sɛ ɛba sɛ obi akum obi a wanhyɛ da na ɔnni onipa ko no ho menasepɔ bi a, ɔtumi dwane kɔ hɔ kɔbɔ ne ho adwaa. ");
INSERT INTO twiasante_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Ɔyii Beser a ɛda ɛserɛ ne asase tata so no maa Rubenfoɔ. Ɔde Ramot a ɛwɔ Gilead no maa Gadfoɔ ɛnna ɔde Golan a ɛwɔ Basan no nso maa Manase abusuakuo. ");
INSERT INTO twiasante_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Yeinom ne mmara a Mose de maa Israelfoɔ no. ");
INSERT INTO twiasante_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Israelfoɔ no firii Misraim no, yeinom ne akwankyerɛ, mmara ne ahyɛdeɛ a Mose de maa wɔn ");
INSERT INTO twiasante_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","ɛberɛ a wɔduruu bɔnhwa a ɛbɛn Bet-Peor a ɛda Asubɔnten Yordan apueeɛ fam. Kane no, na Amorifoɔ na wɔte asase yi so ɛberɛ a wɔn ɔhene Sihon a ɔfiri Hesbon di adeɛ. Mose ne Israelfoɔ firi Misraim ɛreba no, wɔsɛe ɔhene yi ne nkurɔfoɔ. ");
INSERT INTO twiasante_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Wɔfaa nʼasase no sane faa Basanhene Og asase nso kaa ho. Saa ahemfo baanu yi na wɔyɛ Amorifoɔ ahemfo a wɔte Yordan apueeɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Saa asase yi na ɛfiri Aroer a ɛda Arnon subɔnhwa ano kɔsi Sion bepɔ, a wɔfrɛ no Hermon no ho. ");
INSERT INTO twiasante_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Israelfoɔ no sane faa nsaase a ɛfiri Araba ɛpo no ano kɔsi bepɔ Pisga ase. ");
INSERT INTO twiasante_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Mose frɛɛ Israelfoɔ nyinaa ka kyerɛɛ wɔn sɛ: Montie mmara ne ahyɛdeɛ a mede rema mo ɛnnɛ no yie. Monsua na monni so. ");
INSERT INTO twiasante_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Ɛberɛ a yɛwɔ Horeb no, Awurade yɛn Onyankopɔn ne yɛn yɛɛ apam bi. ");
INSERT INTO twiasante_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Ɛnyɛ yɛn agyanom na Awurade ne wɔn yɛɛ apam tete no, na mmom, ɔne yɛn a yɛte ase ɛnnɛ yi na ɛyɛeɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Awurade ne mo kasaa animuanimu firi ogyaframa no mu. ");
INSERT INTO twiasante_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Megyinaa mo ne Awurade ntam, ɛfiri sɛ, na mosuro ogya no enti, moamforo bepɔ no. Ɔkasa kyerɛɛ me na me nso mekaa nsɛm a ɔkaeɛ no kyerɛɛ mo. Nsɛm a ɔkaeɛ no nie: ");
INSERT INTO twiasante_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Mene Awurade mo Onyankopɔn a meyii mo firii nkoasom wɔ Misraim no. ");
INSERT INTO twiasante_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Monnsom onyame foforɔ biara nka me ho. ");
INSERT INTO twiasante_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Monnyɛ ohoni anaa biribiara a ɛsɛ adeɛ a ɛwɔ ewiem, anaa deɛ ɛwɔ asase so, anaa deɛ ɛwɔ nsuo mu, anaa deɛ ɛwɔ asase ase. ");
INSERT INTO twiasante_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Monnkoto ohoni biara nsom no ɛkwan biara so, na me, Awurade mo Onyankopɔn, meyɛ ninkunfoɔ. Na me ne onyame foforɔ bi nkyɛ mo dɔ a modɔ me no. Na sɛ nnipa bi bɔne a wayɛ enti metwe wɔn aso a, metwe wɔn aso kɔsi wɔn awontoatoasoɔ a wɔtan me no nyinaa so. ");
INSERT INTO twiasante_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Na medɔ awoɔ ntoatoasoɔ mpem a wɔdɔ me na wɔdi mʼahyɛdeɛ so. ");
INSERT INTO twiasante_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Mommmɔ Awurade Onyankopɔn din basabasa. Sɛ moyɛ saa a, ɔbɛbu mo fɔ. ");
INSERT INTO twiasante_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Monkae homeda na monni no sɛ ɛda kronkron, sɛdeɛ Awurade ahyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Nnansia na momfa nyɛ mo nnwuma nyinaa, ");
INSERT INTO twiasante_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","na ɛda a ɛtɔ so nson no yɛ homeda ma Awurade Onyankopɔn. Saa ɛda no, ɛnsɛ sɛ moyɛ adwuma biara; ɛnsɛ sɛ mo mmammarima, mo mmabaa anaa mo asomfoɔ anaa mo anantwie ne mo afunumu anaa mo ahɔhoɔ yɛ adwuma biara. ");
INSERT INTO twiasante_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Monkae sɛ berɛ bi a atwam no na moyɛ nkoa wɔ Misraim, na Awurade, mo Onyankopɔn, nam anwanwa tumi ne tumi nnwuma so na ɔyii mo firii hɔ. Ɛno enti na Awurade mo Onyankopɔn hyɛ mo sɛ monni homeda no. ");
INSERT INTO twiasante_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Di wʼagya ne wo maame ni sɛdeɛ Awurade, mo Onyankopɔn, hyɛ mo no. Na ɛbɛma wo nkwa nna aware wɔ asase a Awurade wo Onyankopɔn de bɛma wo no so. ");
INSERT INTO twiasante_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Nni awu. ");
INSERT INTO twiasante_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Nsɛe awadeɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Mmɔ korɔno ");
INSERT INTO twiasante_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Nni wo yɔnko ho adansekurumu ");
INSERT INTO twiasante_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Mma wʼani mmere wo yɔnko yere. Mma wʼani mmere wo yɔnko fie anaa nʼasase anaa nʼakoa anaa nʼafenawa, ne nʼanantwie, nʼafunumu anaa biribiara a ɛyɛ wo yɔnko dea.” ");
INSERT INTO twiasante_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Awurade de nne kɛseɛ a ɛfiri ogyaframa no mu ka kyerɛɛ mo firii omununkum a esum kabii atwa ho ahyia mu. Nsɛm a ɔkaeɛ ara ni na ɔtwerɛɛ ne nsɛm no guu aboɔ ɛpono mmienu so na ɔde maa me. ");
INSERT INTO twiasante_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Motee nne no firii esum mu ɛberɛ a bepɔ no ogya redɛre framfram no, mmusuakuo mu ntuanofoɔ no nyinaa baa me nkyɛn. ");
INSERT INTO twiasante_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Wɔkaa sɛ, “Awurade yɛn Onyankopɔn, akyerɛ yɛn nʼanimuonyam ne ne tumi na yɛate ne nne afiri ogya mu. Ɛnnɛ, yɛahunu sɛ, sɛ Onyankopɔn ne onipa kasa koraa a, onipa tumi tena ase. ");
INSERT INTO twiasante_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Na afei, adɛn enti na ɛsɛ sɛ yɛwuwu? Sɛ Awurade, yɛn Onyankopɔn, kasa kyerɛ yɛn bio a, akyinnyeɛ biara nni ho sɛ yɛbɛwuwu na ogya no ahye yɛn pasaa. ");
INSERT INTO twiasante_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Enti, ɔkra teasefoɔ bɛtumi ate Onyankopɔn teasefoɔ no nne afiri ogyaframa no mu na watena ase anaa? ");
INSERT INTO twiasante_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Wo, kɔ na kɔtie deɛ Awurade yɛn Onyankopɔn no ka. Na afei, bra na bɛka biribiara a ɔka kyerɛɛ wo no kyerɛ yɛn, na yɛbɛtie na yɛadi so.” ");
INSERT INTO twiasante_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Awurade tee mo nne ɛberɛ a mokasa kyerɛɛ me no, Awurade ka kyerɛɛ me sɛ, “Mate nsɛm a nnipa ka kyerɛɛ wo no. Nsɛm a wɔkaaeɛ no nyinaa yɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Ao, sɛ daa wɔbɛnya akoma sɛdeɛ ɛbɛma wɔasuro me na wɔadi mʼahyɛdeɛ nyinaa so a, anka ɛbɛyɛ ama wɔn ne wɔn asefoɔ nyinaa afebɔɔ. ");
INSERT INTO twiasante_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“Kɔ na kɔka kyerɛ wɔn sɛ, wɔnsane mmra wɔn ntomadan mu. ");
INSERT INTO twiasante_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Nanso, wo deɛ, wo ne me ntena ha sɛdeɛ ɛbɛyɛ a mɛtumi de me nhyɛ ne me mmara ama wo. Wobɛkyerɛkyerɛ nnipa no sɛdeɛ wɔbɛtie wɔ asase a mede rema wɔn no so sɛ wɔn agyapadeɛ.” ");
INSERT INTO twiasante_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Enti, Mose ka kyerɛɛ nnipa no sɛ, “Monyɛ ɔsetie mma Awurade mo Onyankopɔn ahyɛdeɛ nyinaa, na monni ne nkyerɛkyerɛ so pɛpɛɛpɛ. ");
INSERT INTO twiasante_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Akwan a Awurade mo Onyankopɔn ahyɛ mo sɛ monnante so no so, monnante so. Na moatena ase nna tenten na asi mo yie wɔ asase a morebɛkɔ akɔtena so no so.” ");
INSERT INTO twiasante_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Yeinom ne ahyɛdeɛ, mmara ne nhyehyɛeɛ a Awurade mo Onyankopɔn ka kyerɛɛ me sɛ menkyerɛ mo na monni so wɔ asase a moretwa Yordan akɔtena so no, ");
INSERT INTO twiasante_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","sɛdeɛ ɛbɛyɛ a mo, mo mma ne wɔn mma bɛsuro Awurade mo Onyankopɔn mmerɛ dodoɔ a mote ase. Sɛ modi ne mmara ne nʼahyɛdeɛ nyinaa so a, mo nkwa nna bɛware. ");
INSERT INTO twiasante_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Montie, Ao Israel, na monhwɛ yie nni so sɛdeɛ ɛbɛyɛ a, ɛbɛsi mo yie na mo ase atrɛ yie wɔ asase a nufosuo ne ɛwoɔ resene wɔ so sɛdeɛ Awurade, mo agyanom Onyankopɔn, hyɛɛ mo ho bɔ no. ");
INSERT INTO twiasante_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Tie, Ao Israel, Awurade yɛn Onyankopɔn yɛ Awurade koro. ");
INSERT INTO twiasante_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Dɔ Awurade wo Onyankopɔn firi wʼakoma mu nyinaa ne wo kra nyinaa mu ne wʼahoɔden nyinaa mu. ");
INSERT INTO twiasante_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Momma saa mmaransɛm a mede rema wo ɛnnɛ yi ntena mo akoma mu. ");
INSERT INTO twiasante_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Momfa nhyɛ mo mma mu. Sɛ mowɔ fie anaa monam ɛkwan so, sɛ moda hɔ anaa mosɔre anɔpa a, monkyerɛkyerɛ wɔn. ");
INSERT INTO twiasante_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Monkyekyere no sɛ agyinahyɛdeɛ mmɔ mo nsa na momfa bi mmɔ abotire. ");
INSERT INTO twiasante_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Montwerɛ ngu mo fie aponnwa ne mo aboboanopono ho. ");
INSERT INTO twiasante_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Ɛrenkyɛre biara, Awurade mo Onyankopɔn de mo bɛba asase a ɔkaa ntam sɛ ɔde bɛma mo agyanom Abraham, Isak ne Yakob no. Ɛyɛ asase a animuonyam nkuropɔn a ɛnyɛ mo na mokyekyereeɛ ahyɛ so ma. ");
INSERT INTO twiasante_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","Wɔde nneɛma pa a ɛnyɛ mo na moyɛeɛ bɛhyɛ no ma. Mobɛto nsuo afiri abura a ɛnyɛ mo na motuiɛ mu, na mobɛdidi afiri turo a ɛnyɛ mo na moyɛeɛ mu ne ngo nnua a ɛnyɛ mo na moduaeɛ. Sɛ modidi mee wɔ saa asase yi so wie a, ");
INSERT INTO twiasante_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","monhwɛ yie na mo werɛ amfiri Awurade a ɔgyee mo firii nkoasom mu Misraim asase so no. ");
INSERT INTO twiasante_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Ɛsɛ sɛ mosuro Awurade, mo Onyankopɔn, na mosom ɔno nko ara. Ne din nko ara na momfa nka ntam. ");
INSERT INTO twiasante_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Monnni anyame foforɔ akyi—anyame a wɔyɛ nnipa a wɔatwa mo ho ahyia no dea; ");
INSERT INTO twiasante_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","na Awurade mo Onyankopɔn a ɔwɔ mo ntam no yɛ Onyankopɔn ninkunfoɔ a nʼabufuhyeɛ no bɛhye mo na ɔbɛsɛe mo afiri asase so. ");
INSERT INTO twiasante_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Monnsɔ Awurade, mo Onyankopɔn, nhwɛ sɛdeɛ moyɛeɛ ɛberɛ a na mowɔ Masa no. ");
INSERT INTO twiasante_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Ɛsɛ sɛ modi Awurade mo Onyankopɔn ahyɛdeɛ so pɛpɛɛpɛ—monni mmara no mu nsɛm nyinaa so sɛdeɛ ɔde ama mo no. ");
INSERT INTO twiasante_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Monyɛ deɛ ɛtene na ɛyɛ wɔ Awurade ani so na biribiara awie mo yie. Na moakɔ akɔtena asase pa a Awurade hyɛɛ ho bɔ kyerɛɛ mo agyanom no. ");
INSERT INTO twiasante_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Mobɛpam atamfoɔ a wɔte mo asase no so nyinaa sɛdeɛ Awurade ka kyerɛɛ mo sɛ ɔbɛyɛ no. ");
INSERT INTO twiasante_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Daakye bi, mo mma bɛbisa mo sɛ, “Saa mmara ne nʼahyɛdeɛ a Awurade, yɛn Onyankopɔn de ama yɛn yi aseɛ ne sɛn?” ");
INSERT INTO twiasante_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Monka nkyerɛ wɔn sɛ “Na yɛyɛ Farao nkoa wɔ Misraim, nanso Awurade nam anwanwatumi so yii yɛn firii Misraim. ");
INSERT INTO twiasante_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Yɛhunuu Awurade nsɛnkyerɛnneɛ nnwuma a ɔyɛ tiaa Misraim, Farao ne ne nkurɔfoɔ nyinaa. ");
INSERT INTO twiasante_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Ɔyii yɛn firii Misraim sɛdeɛ ɛbɛyɛ a, ɔbɛtumi de asase a wahyɛ yɛn agyanom ho bɔ no ama yɛn. ");
INSERT INTO twiasante_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Na Awurade yɛn Onyankopɔn hyɛɛ yɛn sɛ yɛnni mmara no nyinaa so na yɛmfa obuo ne anidie mma no sɛdeɛ ɛbɛma daakye asi yɛn yie sɛdeɛ ɛte ɛnnɛ yi. ");
INSERT INTO twiasante_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Ɛfiri sɛ, sɛ yɛdi mmara no nyinaa a Awurade, yɛn Onyankopɔn, de ama yɛn no so a, ɛbɛma yɛayɛ ateneneefoɔ.” ");
INSERT INTO twiasante_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Sɛ Awurade mo Onyankopɔn de mo ba asase a morebɛkɔ akɔtena so no so a, ɔbɛpam amanaman pii a wɔwɔ mo anim no a wɔyɛ Hetifoɔ, Girgasifoɔ, Amorifoɔ, Kanaanfoɔ, Perisifoɔ, Hewifoɔ ne Yebusifoɔ. Yeinom yɛ aman nson a wɔsoso na wɔyɛ den sen mo. ");
INSERT INTO twiasante_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Sɛ Awurade mo Onyankopɔn de saa aman yi hyɛ mo nsa na modi wɔn so a, monsɛe wɔn pasapasa. Mo ne wɔn nnhyehyɛ apam biara na monnhunu wɔn mmɔbɔ. ");
INSERT INTO twiasante_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Mo ne wɔn nni awadeɛ na mommma mo mmammaa ne mo mmammarima nnware wɔn mmammarima ne wɔn mmammaa. ");
