﻿USE sofia;
DROP TABLE IF EXISTS sofia.twi_vpl;
CREATE TABLE twi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES twi_vpl WRITE;
INSERT INTO twi_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Mfiase no Onyankopɔn bɔɔ ɔsoro ne asase. ");
INSERT INTO twi_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Na asase yɛ basaa a na ɛda mpan, na sum kata bun no ani, na Onyankopɔn Honhom butuw nsu no ani. ");
INSERT INTO twi_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Onyankopɔn hyɛe se, “Ɛnyɛ hann,” na ɛyɛɛ hann. ");
INSERT INTO twi_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Onyankopɔn huu sɛ hann no ye, na ɔtew hann no fii sum no ho. ");
INSERT INTO twi_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Onyankopɔn frɛɛ hann no se, “adekyee,” na sum no nso se, “adesae.” Ade sae na ade kyee, da a edi kan ne no. ");
INSERT INTO twi_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Onyankopɔn kae se, “Nkyemu mmra nsu no ntam, na ɛnkyekyɛ nsu no mu.” ");
INSERT INTO twi_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Enti Onyankopɔn yɛɛ nkyɛmu no, de kyekyɛɛ nsu a ɛwɔ nkyɛmu no ase fii nsu a ɛwɔ nkyɛmu no atifi no mu. Na ɛyɛɛ saa. ");
INSERT INTO twi_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Onyankopɔn too atifi nkyɛmu no din wim. Na ade sae, na ade kyee; eyi ne da a ɛto so abien. ");
INSERT INTO twi_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Na Onyankopɔn kae se, “Nsu a ɛwɔ nkyɛmu no ase no ano mmoa wɔ faako, na asase kesee nna ne ho adi.” Na ɛyɛɛ saa. ");
INSERT INTO twi_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Onyankopɔn too beae kesee ne din “asase.” Na nsu a ɛboaa ne ho ano no nso, ɔtoo no din “ɛpo.” Onyankopɔn hui sɛ eye. ");
INSERT INTO twi_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Afei Onyankopɔn kae se, “Afifide mfifi wɔ asase so; afifide a ɛsow aba, nnuaba ahorow a ɛsow aba ne nea nʼaba hyehyɛ mu nyinaa mfifi wɔ asase so.” Na ɛyɛɛ saa. ");
INSERT INTO twi_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Afifide a ɛsow aba ne nnua fifii wɔ asase so na nʼaba no nyin yɛɛ nnua ne afifide sɛ ne sɛso. Onyankopɔn hui sɛ eye. ");
INSERT INTO twi_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Na ade sae, na ade kyee. Eyi ne da a ɛto so abiɛsa. ");
INSERT INTO twi_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Na Onyankopɔn kae se, “Hann mmra nkyɛmu a ɛwɔ wim no mu, na ɛmmɛpae adekyee ne adesae mu. Na ɛmmɛyɛ nnyinaso mma bere nkyekyɛmu, nna ne mfe, ");
INSERT INTO twi_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","na ɛmma hann mmra nkyɛmu a ɛwɔ wim no mu, na ahyerɛn wɔ asase so.” Na ɛyɛɛ saa. ");
INSERT INTO twi_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Onyankopɔn yɛɛ akanea akɛse abien a ɛyɛ owia ne ɔsram sɛ, owia no nni adekyee so na ɔsram no nni anadwo so. Ɔbɔɔ nsoromma nso. ");
INSERT INTO twi_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Onyankopɔn de akanea akɛse abien yi sii nkyɛmu a ɛwɔ wim no mu sɛ ɛnhyerɛn wɔ asase so, ");
INSERT INTO twi_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","na wonni adekyee ne adesae no so, na ɛntew hann no mfi sum no ho. Na Onyankopɔn hui sɛ eye. ");
INSERT INTO twi_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Na ade sae, na ade kyee. Da a ɛto so anan ne no. ");
INSERT INTO twi_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Onyankopɔn kae se, “Abɔde a nkwa wɔ mu nhyɛ nsu no ma, na nnomaa ntu mfa asase ne nkyɛmu a ɛwɔ wim no so.” ");
INSERT INTO twi_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Enti Onyankopɔn bɔɔ po mu mmoa akɛse ne mmoa ahorow nyinaa a wɔwɔ nkwa na wɔkeka wɔn ho ne nnomaa ahorow nyinaa. Na Onyankopɔn hui sɛ eye. ");
INSERT INTO twi_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Onyankopɔn hyiraa abɔde no nyinaa so, kae se, “Monwo na monyɛ bebree na monhyɛ po no mu nsu no ma, na nnomaa ase ntrɛw wɔ asase so.” ");
INSERT INTO twi_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Na ade sae, na ade kyee. Da a ɛto so anum ne no. ");
INSERT INTO twi_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Onyankopɔn kae se, “Abɔde a nkwa wɔ mu ahorow nyinaa ne wɔn sɛso, anantwi ne mmoa a wɔwea wɔn afuru so ne mmoa ahorow a wɔyɛ keka a wɔwɔ asase so nyinaa mmra asase so.” Na ɛyɛɛ saa. ");
INSERT INTO twi_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Onyankopɔn bɔɔ mmoa ahorow, anantwi ahorow ne wɔn sɛso ne mmoa a wɔwea wɔn afuru so ne wɔn sɛso. Na Onyankopɔn hui sɛ eye. ");
INSERT INTO twi_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Onyankopɔn kae se, “Momma yɛmmɔ onipa sɛ yɛn sɛso, na onni po mu mpataa, wim nnomaa, anantwi ne mmoa a wɔyɛ keka ne biribiara a ɛwea nʼafuru so wɔ asase so no so.” ");
INSERT INTO twi_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Enti Onyankopɔn bɔɔ onipa sɛ ne sɛso; Onyankopɔn sɛso so na ɔbɔɔ wɔn; ɔbarima ne ɔbea na ɔbɔɔ wɔn. ");
INSERT INTO twi_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Onyankopɔn hyiraa wɔn, ka kyerɛɛ wɔn se, “Monwo na monyɛ asase so ma, na munni biribiara so. Munni po mu mpataa ne wim nnomaa ne abɔde biara a nkwa wɔ mu a ɛwɔ asase so no nyinaa so.” ");
INSERT INTO twi_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Afei Onyankopɔn kae se, “Mede asase so afifide a ɛsow aba nyinaa, afifide biara a aba hyɛ ne nnuaba mu wɔ asase yi so nyinaa hyɛ wo nsa. Ɛbɛyɛ wʼaduan. ");
INSERT INTO twi_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Mede nhabammono nyinaa ama aboa biara a ɔwɔ asase so, anomaa biara a ɔwɔ wim, biribiara a ɛwea nʼafuru so, biribiara a nkwa wɔ mu wɔ asase so sɛ wɔn aduan.” Na ɛyɛɛ saa. ");
INSERT INTO twi_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Onyankopɔn hwɛɛ nea wayɛ nyinaa huu sɛ ɛyɛ papa. Na ade sae, na ade kyee. Eyi ne da a ɛto so asia. ");
INSERT INTO twi_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Eyi ne ɔkwan a Onyankopɔn faa so bɔɔ ɔsoro ne asase ne nea ɛwɔ mu nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Eduu da a ɛto so ason no, na Onyankopɔn awie nnwuma a ofii ase yɛe no nyinaa. Enti da a ɛto so ason no, ogyee nʼahome. ");
INSERT INTO twi_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Enti Onyankopɔn hyiraa da a ɛto so ason no, na ɔtew ho, efisɛ saa da no na Onyankopɔn gyee nʼahome fii adebɔ nnwuma no nyinaa mu. ");
INSERT INTO twi_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Eyi ne ɔsoro ne asasebɔ ho asɛm. Bere a Awurade Nyankopɔn bɔɔ ɔsoro ne asase no. ");
INSERT INTO twi_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Na afifide biara nni asase so, na wuram nnua biara nso nni hɔ. Efisɛ, na Awurade Nyankopɔn mmaa osu ntɔɔ wɔ asase so, na onipa nso nni asase so a ɔbɛyɛ so adwuma. ");
INSERT INTO twi_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Nanso nsuti puepue fifii asase mu bɛfɔw asase ani nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Awurade Nyankopɔn de asase no so dɔte nwen onipa, na ɔhomee nkwa home guu ne hwenem, maa onipa no bɛyɛɛ ɔteasefo. ");
INSERT INTO twi_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Afei Awurade Nyankopɔn yɛɛ turo wɔ Eden apuei fam, na ɛhɔ na ɔde onipa a ɔnwen no no tenae. ");
INSERT INTO twi_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Awurade Nyankopɔn maa nnua ahorow nyinaa fifi fii asase no mu; nnua a ɛyɛ fɛ na wodi. Na nkwa dua ne papa ne bɔnehu dua sisi turo no mfimfini. ");
INSERT INTO twi_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Na asu sen fii Eden bɛfɔw turo no mu afifide no; efi hɔ a, na saa asu no mu apaapae ayɛ nsubɔnten anan. ");
INSERT INTO twi_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Wɔtoo asu a apaapae no mu nea edi kan no din Pison. Na ɛkɔntɔn fa Hawila asase a sikakɔkɔɔ wɔ so no so nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Na saa asase no so sikakɔkɔɔ ye. Na ɛhyɛ a ɛyɛ huam ne apopobibiribo nso wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Asubɔnten a ɛto so abien no din de Gihon. Na ɛno ara na ɛkɔntɔnkɔntɔn fa Kus asase ho nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Asu a ɛto so abiɛsa no, na wɔfrɛ no Tigris a ɛsen kɔ asase kɛse Asiria apuei fam no. Asu a ɛto so anan no nso, na wɔfrɛ no Eufrate. ");
INSERT INTO twi_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Awurade Nyankopɔn faa onipa no de no kɔtenaa Eden turo mu hɔ sɛ ɔnyɛ mu adwuma, na ɔnhwɛ so. ");
INSERT INTO twi_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Na Awurade Nyankopɔn bɔɔ onipa no kɔkɔ se, “Wowɔ ho kwan sɛ wudi dua biara so aba wɔ turo yi mu ha; ");
INSERT INTO twi_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","nanso wunni ho kwan sɛ wudi papa ne bɔnehu dua no so aba. Da a wubedi no, nea ɛbɛyɛ biara no, wubewu.” ");
INSERT INTO twi_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Afei Awurade Nyankopɔn kae se, “Enye sɛ onipa nko tena; mɛbɔ ɔboafo a ɔfata no ama no.” ");
INSERT INTO twi_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Saa bere no na Awurade Nyankopɔn de mfutuma abɔ wuram mmoa ne wim nnomaa nyinaa. Enti, ɔde wɔn brɛɛ onipa sɛ ɔnhwehwɛ din ko a ɔde bɛtoto wɔn; na din a onipa de too abɔde a nkwa wɔ mu biara no, ɛno ara na ɛyɛɛ din a wɔde frɛɛ no. ");
INSERT INTO twi_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Enti onipa totoo nyɛmmoa, wim nnomaa ne wuram mmoa no nyinaa din. Nanso onipa de, wannya ɔboafo a ɔfata. ");
INSERT INTO twi_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Enti Awurade Nyankopɔn maa onipa daa nnahɔɔ. Bere a onipa daa saa no, oyii ne mfe mu mparow baako, na ɔde honam taree baabi a oyii mparow hɔ no. ");
INSERT INTO twi_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Afei Awurade Nyankopɔn de mfe mu mparow baako a oyi fii onipa mu no bɔɔ ɔbea, de no maa onipa no. ");
INSERT INTO twi_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Na Adam kae se, “Mʼankasa me dompe ne me honam bi ni. Wɔbɛfrɛ oyi ɔbea efisɛ ɔbarima mu na woyii no fii.” ");
INSERT INTO twi_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Eyi nti na ɔbarima gyaw nʼagya ne ne na de ne ho kɔbɔ ne yere ho sɛnea wɔn baanu no bɛyɛ nnipa koro. ");
INSERT INTO twi_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Saa bere no, na ɔbarima ne ne yere nyinaa ho da hɔ, nanso na wɔmfɛre. ");
INSERT INTO twi_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Na ɔwɔ yɛ ɔdaadaafo wɔ wuram mmoadoma a Awurade Nyankopɔn abɔ wɔn no nyinaa mu. Ɔwɔ no kɔɔ ɔbea no nkyɛn kobisaa no se, “Enti ɛyɛ ampa ara sɛ, Onyankopɔn se, ‘Munnni turo yi mu aduaba biara?’ ” ");
INSERT INTO twi_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ɔbea no buaa ɔwɔ se, “Yetumi di nnua a ɛwɔ turo yi mu no so aduaba biara, ");
INSERT INTO twi_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","nanso Onyankopɔn kae se, ‘Ɛnsɛ sɛ yedi dua a esi turo no mfimfini no so aduaba, na ɛnsɛ sɛ yɛde yɛn nsa mpo ka, anyɛ saa a yebewu.’ ” ");
INSERT INTO twi_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Na ɔwɔ no ka kyerɛɛ ɔbea no se, “Morenwuwu. ");
INSERT INTO twi_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mmom, Onyankopɔn nim sɛ, da a mubedi no ara pɛ, mo ani bɛba mo ho so, ama moayɛ sɛ Onyankopɔn, na moahu papa ne bɔne.” ");
INSERT INTO twi_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Bere a ɔbea no huu sɛ dua a esi mfimfini no so aba no wodi a, ɛbɛyɛ yie, na ɛyɛ akɔnnɔ, na afei ɛtew ani no, ɔtew bi dii, de bi maa ne kunu a na ɔne no wɔ hɔ no, maa ɔno nso dii. ");
INSERT INTO twi_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Wodi wiee no, wɔn baanu ani baa wɔn ho so, na wohuu sɛ wɔn nyinaa da adagyaw. Enti wɔkekaa nhaban sisii anim, de kataa wɔn adagyaw so. ");
INSERT INTO twi_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Da no anwummere, wɔtee Awurade Nyankopɔn nka sɛ ɔnam turo no mu; enti Adam ne ne yere Hawa de wɔn ho kosiee nnua a ɛwɔ turo mu hɔ no mu sɛnea Awurade Nyankopɔn renhu wɔn. ");
INSERT INTO twi_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Na Awurade Nyankopɔn frɛɛ Adam bisaa no se, “Mowɔ he?” ");
INSERT INTO twi_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adam buae se, “Metee wo nka wɔ turo no mu hɔ, nanso na misuro, efisɛ na meda adagyaw nti mekɔtɛwee.” ");
INSERT INTO twi_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Na Onyankopɔn bisaa no se, “Hena na ɔka kyerɛɛ wo se na woda adagyaw? Woadi dua a meka kyerɛɛ wo se nni so aba no bi ana?” ");
INSERT INTO twi_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adam kae se, “Yiw, nanso ɔbea no a wode no maa me sɛ me ne no ntena no na ɔde aduaba a ɔtew fii dua no so no brɛɛ me maa midii.” ");
INSERT INTO twi_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Enti Awurade Nyankopɔn bisaa ɔbea no se, “Dɛn na woayɛ yi?” Ɔbea no buae se, “Ɔwɔ no na ɔdaadaa me ma midii.” ");
INSERT INTO twi_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Enti Awurade Nyankopɔn ka kyerɛɛ ɔwɔ no se, “Esiane saa ade a woayɛ yi nti, “Wɔadome wo wɔ mmoa nyinaa ne nkekaboa mu. Wobɛwea wʼafuru so, na wo nkwanna nyinaa woadi mfutuma. ");
INSERT INTO twi_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mede ɔtan bɛto wo ne ɔbea no ne wʼasefo ne nʼasefo ntam. Ɔno na ɔbɛbɔ wo ti, na wo nso woaka ne nantin.” ");
INSERT INTO twi_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Afei, Awurade Nyankopɔn ka kyerɛɛ ɔbea no nso se, “Wobɛte ɔyaw pa ara wɔ wʼawo mu; ɔyaw mu na wobɛwo mma. Eyi nyinaa akyi no, wʼani begyina wo kunu na obedi wo so.” ");
INSERT INTO twi_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Onyankopɔn ka kyerɛɛ Adam nso se, “Esiane sɛ wutiee wo yere asɛm, na wudii dua a mehyɛɛ wo se, ‘nni so aba no’ nti, “Madome asase, na ɔbrɛ ne ɔhaw mu na wubedidi so wo nkwanna nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ebefifi nsɔe ne nkyɛkyerɛ ama wo na woadi wuram nhaban. ");
INSERT INTO twi_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Wubesiam wʼanim fifiri ansa na woanya aduan adi, kosi sɛ wubewu akɔ dɔte mu, efisɛ dɔte no mu na menwen wo fii; woyɛ dɔte, na dɔte mu na wobɛsan akɔ.” ");
INSERT INTO twi_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam too ne yere no din Hawa, efisɛ ɔno na ɔbɛyɛ ateasefo nyinaa na. ");
INSERT INTO twi_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Awurade Nyankopɔn de aboa nhoma yɛɛ ntade maa Adam ne ne yere Hawa de kataa wɔn ho. ");
INSERT INTO twi_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Awurade Nyankopɔn kae se, “Afei, onipa no abɛyɛ sɛ yɛn ara a, wahu papa ne bɔne. Ɛnsɛ sɛ yɛma no kwan na ɔteɛ ne nsa kɔtew nkwa dua no so aba no bi di, na ɔtena ase afebɔɔ.” ");
INSERT INTO twi_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Enti Awurade Nyankopɔn pam no fii Eden turo no mu sɛ ɔnkɔyɛ adwuma wɔ asase a wɔnwenee no fii mu no so. ");
INSERT INTO twi_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ɔpam onipa no, ɔde Kerubim ne afoa a ɛdɛw twaa ne ho fa baabiara no sii Eden turo no apuei fam sɛ ɛnwɛn ɔkwan a ɛkɔ nkwa dua no ho no. ");
INSERT INTO twi_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam de ne ho kaa ne yere Hawa ma onyinsɛn, woo abarimaa a wɔfrɛ no Kain. Na ɔkae se, Awurade adaworoma, mawo ɔbabarima. ");
INSERT INTO twi_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Akyiri no, ɔsan woo nʼakyi babarima too no din Habel. Na Habel bɛyɛɛ oguanhwɛfo, na Kain nso bɛyɛɛ okuafo. ");
INSERT INTO twi_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Nna bi akyi no, Kain de nʼafum nnɔbae bi kɔbɔɔ Awurade afɔre. ");
INSERT INTO twi_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel nso de ne nyɛmmoa no mu mmakan a wɔadodɔ srade kɔbɔɔ Onyankopɔn afɔre. Awurade ani sɔɔ Habel afɔrebɔ no. ");
INSERT INTO twi_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Nanso Kain afɔrebɔ no de, nʼani ansɔ. Asɛm no anyɛ Kain dɛ, na ne bo fuwii. ");
INSERT INTO twi_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Awurade bisaa Kain se, “Adɛn nti na wo bo afuw? Adɛn nti na woamuna saa? ");
INSERT INTO twi_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Sɛ woyɛ ade pa a, anka wɔrennye wo nto mu ana? Sɛ wonyɛ ade pa de a, bɔne gyina wo pon ano, ɛrehwehwɛ wo ako atia wo, nanso ɛsɛ sɛ wudi no so.” ");
INSERT INTO twi_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Da bi Kain ka kyerɛɛ ne nua Habel se, “Ma yɛnkɔ afum.” Bere a wɔwɔ afum hɔ no, Kain tow hyɛɛ ne nua Habel so, kum no. ");
INSERT INTO twi_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Awurade bisaa Kain se, “Wo nua Habel wɔ he?” Kain buae se, “Minnim. Mɛyɛ dɛn ahu? Me na mehwɛ me nua so ana?” ");
INSERT INTO twi_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Awurade bisaa Kain se, “Dɛn na woayɛ yi? Tie! Wo nua mogya su fi asase so frɛ me. ");
INSERT INTO twi_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Mprempren, wɔadome wo, apam wo afi asase a ebuee nʼano gyee wo nua mogya fii wo nsam no so. ");
INSERT INTO twi_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Sɛ woyɛ asase no so adwuma sɛ dɛn ara a, worennya nnɔbae biara mfi so. Wobɛyɛ ɔkobɔfo, akyinkyin asase so.” ");
INSERT INTO twi_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain kae se, “Awurade mʼasotwe boro me so. ");
INSERT INTO twi_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Nnɛ, woapam me afi asase so ne wʼanim. Mɛyɛ ɔkobɔfo akyinkyin asase so na obiara a obenya me no bekum me.” ");
INSERT INTO twi_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Nanso Awurade ka kyerɛɛ no se, “Ɛnte saa koraa! Obiara a obekum Kain no benya Kain asotwe no mpɛn ason.” Afei, Awurade hyɛɛ Kain agyirae bi sɛnea ɛbɛyɛ a, obiara a obehyia no no renkum no. ");
INSERT INTO twi_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Enti Kain guan fii Awurade anim, kɔtenaa Nod asase so wɔ Eden apuei fam. ");
INSERT INTO twi_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain de ne ho kaa ne yere na onyinsɛn, woo ɔbabarima, too no din Henok. Saa bere no, Kain kyekyeree kurow bi de too ne ba Henok. ");
INSERT INTO twi_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henok woo Irad. Irad woo Mehuyael. Mehuyael woo Metusael. Metusael woo Lamek. ");
INSERT INTO twi_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek waree mmea baanu a wɔn din de Ada ne Sila. ");
INSERT INTO twi_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada woo Yabal a nʼasefo yɛ wɔn a wɔte ntamadan mu yɛn mmoa. ");
INSERT INTO twi_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Na Yabal nuabarima din de Yubal a nʼasefo yɛ mmɛnhyɛnfo ne sankubɔfo. ");
INSERT INTO twi_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila woo ɔbabarima a wɔfrɛ no Tubal-Kain. Na ɔyɛ kɔbere atomfo ne nnade ahorow nyinaa atomfo agya. Na Tubal-Kain wɔ nuabea bi a ne din de Naama. ");
INSERT INTO twi_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Da bi, Lamek ka kyerɛɛ ne yerenom Ada ne Sila se, “Muntie me, me yerenom makum aberante bi a, ɔtow hyɛɛ me so, piraa me. ");
INSERT INTO twi_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Sɛ Kain so aweretɔ bɛyɛ mpɛn ason a, ɛno de, me Lamek de, nea obekum me no, nʼasotwe bɛyɛ mpɛn aduɔson ason.” ");
INSERT INTO twi_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Akyiri no, Adam de ne ho kaa ne yere Hawa. Na ɔwoo ɔbabarima bio. Na wɔtoo no din Set kae se, “Onyankopɔn ama me ɔba foforo asi Habel a Kain kum no no anan mu.” ");
INSERT INTO twi_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set nso woo ɔbabarima na ɔtoo no din Enos. Saa bere no mu na nnipa fitii ase bɔɔ Awurade din. ");
INSERT INTO twi_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Sɛnea Adam asefo nnidiso te ni. Bere a Onyankopɔn nwen onipa no, ɔnwen no sɛ ɔno ara ne sɛso. ");
INSERT INTO twi_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ɔbɔɔ ɔbea ne ɔbarima, na ohyiraa wɔn. Ɔbɔɔ wɔn wiee no, ɔtoo wɔn din onipa. ");
INSERT INTO twi_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam dii mfe ɔha aduasa no, ɔwoo ɔbabarima sɛ ɔno ara ne bɔbea ne ne sɛso. Ɔtoo ne din Set. ");
INSERT INTO twi_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ɔwoo Set no, Adam tenaa ase mfe ahanwɔtwe a ɔwowoo mmabarima ne mmabea kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Sɛ wɔka Adam mfe nyinaa bɔ mu a, odii mfe ahankron aduasa, ansa na ɔrewu. ");
INSERT INTO twi_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set dii mfe ɔha ne anum no, ɔwoo Enos. ");
INSERT INTO twi_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set woo Enos akyi no, ɔtenaa ase, dii mfe ahanwɔtwe ne ason, wowoo mmabarima ne mmabea kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sɛ wɔka Set mfe dodow bɔ mu a, odii mfe ahankron ne dumien, ansa na ɔrewu. ");
INSERT INTO twi_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos dii mfe aduɔkron no, ɔwoo Kenan. ");
INSERT INTO twi_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enos woo Kenan akyi no, ɔtenaa ase mfe ahanwɔtwe ne dunum, wowoo mmabarima ne mmabea kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Sɛ wɔka Enos mfe dodow bɔ mu a, odii mfe ahankron ne anum, ansa na ɔrewu. ");
INSERT INTO twi_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan dii mfe aduɔson no, ɔwoo Mahalalel. ");
INSERT INTO twi_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan woo Mahalalel akyi no, ɔtenaa ase mfe ahanwɔtwe aduanan, wowoo mmabarima ne mmabea kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Sɛ wɔka Kenan mfe dodow bɔ mu a, odii mfe ahankron ne du, ansa na ɔrewu. ");
INSERT INTO twi_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel dii mfe aduosia anum no, ɔwoo Yared. ");
INSERT INTO twi_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel woo Yared akyi no, ɔtenaa ase, dii mfe ahanwɔtwe aduasa, wowoo mmabarima ne mmabea kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Sɛ wɔka Mahalalel mfe dodow bɔ mu a, odii mfe ahanwɔtwe aduɔkron anum, ansa na ɔrewu. ");
INSERT INTO twi_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared dii mfe ɔha aduosia abien no, ɔwoo Henok. ");
INSERT INTO twi_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yared woo Henok akyi no, ɔtenaa ase mfe ahanwɔtwe, wowoo mmabarima ne mmabea kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Sɛ wɔka Yared mfe dodow bɔ mu a, odii mfe ahankron aduosia abien, ansa na ɔrewu. ");
INSERT INTO twi_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henok dii mfe aduosia anum no, ɔwoo Metusela. ");
INSERT INTO twi_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henok woo Metusela akyi no, Henok de ne ho bataa Awurade ho mfe ahaasa, na ɔwowoo mmabarima ne mmabea kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Sɛ wɔka Henok mfe dodow bɔ mu a, odii mfe ahaasa aduosia anum. ");
INSERT INTO twi_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henok de ne ho bataa Onyankopɔn; afei, obi anhu no bio, efisɛ Onyankopɔn faa no kɔe. ");
INSERT INTO twi_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela dii mfe ɔha aduɔwɔtwe ason no, ɔwoo Lamek. ");
INSERT INTO twi_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusela woo Lamek akyi no, ɔtenaa ase mfe ahanson aduɔwɔtwe abien, wowoo mmabarima ne mmabea kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Sɛ wɔka Metusela mfe dodow bɔ mu a, odii mfe ahankron aduosia akron, ansa na ɔrewu. ");
INSERT INTO twi_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek dii mfe ɔha ne aduɔwɔtwe abien no, ɔwoo ɔbabarima. ");
INSERT INTO twi_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ɔtoo no din Noa, na ɔkae se, “Ɔno na ɔbɛma yɛanya ahomegye afi kuayɛ mu adwumaden wɔ asase a Awurade adome no so.” ");
INSERT INTO twi_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek woo Noa akyi no, ɔtenaa ase mfe ahannum aduɔkron anum, wowoo mmabarima ne mmabea kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Sɛ wɔka Lamek mfe dodow bɔ mu a, odii mfe ahanson aduɔson ason, ansa na ɔrewu. ");
INSERT INTO twi_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa dii mfe ahannum no, ɔwoo mmabarima baasa a wɔfrɛ wɔn Sem, Ham ne Yafet. ");
INSERT INTO twi_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Bere a nnipa dɔɔso wɔ asase so na wɔwoo mmabea no, ");
INSERT INTO twi_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Onyankopɔn mmabarima no huu sɛ nnipa mmabea no ho yɛ fɛ, nti nea obiara pɛ no no, ɔfaa no waree. ");
INSERT INTO twi_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Na Awurade kae se, “Me honhom rentena nnipa mu nkosi daa, efisɛ wɔyɛ ɔhonam; na wɔn nkwa nna bɛyɛ mfe ɔha aduonu.” ");
INSERT INTO twi_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Saa bere no, na nnipa abran wɔ asase no so. Bere a Onyankopɔn mmabarima yi kɔɔ nnipa mmabea yi ho no, wɔne wɔn wowoe. Saa nnipa yi ne kan tete nnipa atitiriw a wogyee din no. ");
INSERT INTO twi_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Awurade Nyankopɔn huu sɛ adesamma amumɔyɛ adɔɔso wɔ asase so, na nnipa nsusuwii nyinaa yɛ bɔne nko ara. ");
INSERT INTO twi_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Awurade Nyankopɔn nuu ne ho sɛ ɔbɔɔ wɔn bɛtenaa asase so. Saa bɔne no yɛɛ Awurade Nyankopɔn awerɛhow. ");
INSERT INTO twi_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Awurade kae se, “Mɛpepa nnipa a mabɔ wɔn no afi asase so; mmoa ne mmoa a wɔwea asase so ne wim nnomaa, efisɛ manu me ho sɛ mebɔɔ wɔn.” ");
INSERT INTO twi_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nanso Noa de, onyaa adom Awurade anim. ");
INSERT INTO twi_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noa awo ntoatoaso ni. Na Noa yɛ onipa ɔtreneeni a ne ho nni asɛm wɔ ne bere sofo no mu. Ɔyɛɛ Onyankopɔn apɛde. ");
INSERT INTO twi_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa woo mmabarima baasa na wɔn din de Sem, Ham ne Yafet. ");
INSERT INTO twi_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Na bɔne ahyɛ asase so ma a, amumɔyɛsɛm adɔɔso. ");
INSERT INTO twi_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Onyankopɔn huu saa bɔne yi nyinaa wɔ asase so, huu awurukasɛm ne amumɔyɛsɛm wɔ mmaa nyinaa nso. ");
INSERT INTO twi_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Enti Onyankopɔn ka kyerɛɛ Noa se, “Esiane sɛ nnipa ama basabasa aba asase so nti, mɛsɛe nnipa ne asase a wɔte so no nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Fa ɔwawa dua yɛ adaka. Yɛ adan wɔ Adaka no mu, na fa ama ka mu ne akyi nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Sɛɛ na ɛsɛ sɛ woyɛ no: ma ne tenten nyɛ anammɔn ahannan aduonum, ne trɛw anammɔn aduɔson anum, na ne sorokɔ nso nyɛ anammɔn aduanan anum. ");
INSERT INTO twi_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Bɔ adaka no so. Ma ne sorokɔ nyɛ bɛyɛ sɛ nsateaa dunwɔtwe. Fa ɔpon to adaka no nkyɛn, na yɛ nsɛmso abiɛsa; nea edi kan, nea ɛda ntam ne nea ɛwɔ soro. ");
INSERT INTO twi_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Tie! Mede nsuyiri rebɛkata asase so nyinaa, na mede asɛe abɔde a nkwa wɔ mu; biribiara a nkwa wɔ mu no, ne nyinaa bewuwu. ");
INSERT INTO twi_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Na wo de, me ne wo bɛyɛ apam; na wo, wo mmabarima, wo yere ne wo mmabarima yerenom nyinaa ne wo bɛba Adaka no mu. ");
INSERT INTO twi_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ɛsɛ sɛ wode abɔde a nkwa wɔ mu nyinaa, abien abien a ɛyɛ onini ne ɔbere, a wo ne wɔn bɛtena adaka no mu nsuyiri bere no a wonnwuwu. ");
INSERT INTO twi_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Nnomaa ahorow biara abien, mmoa biara abien, ne abɔde biara a ɛwea asase so abien bɛba wo nkyɛn, na woahwɛ wɔn, na wɔanwuwu. ");
INSERT INTO twi_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Afei, fa nnuan ahorow a wodi na kora. Ɛno na ɛbɛyɛ wo ne wɔn nnuan a mubedi.” ");
INSERT INTO twi_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa yɛɛ biribiara pɛpɛɛpɛ, sɛnea Onyankopɔn ka kyerɛɛ no sɛ ɔnyɛ no. ");
INSERT INTO twi_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Afei, Awurade ka kyerɛɛ Noa se, “Wo ne wo fifo nyinaa nkɔ Adaka no mu, efisɛ asase so nnipa nyinaa mu no, wo na mahu sɛ woyɛ ɔtreneeni. ");
INSERT INTO twi_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Fa mmoa a wɔn ho tew biara, anini ason ne abere ason ka wo ho. Na fa mmoa biara a wɔn ho ntew nso abien, onini ne ɔbere. ");
INSERT INTO twi_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Na fa nnomaa biara anini ason ne abere, sɛnea ɛbɛyɛ a nsuyiri no akyi no, wɔn ase bɛfɛe. ");
INSERT INTO twi_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Nnanson akyi no mɛma osu atɔ wɔ asase so awia ne anadwo adaduanan. Mɛpepa abɔde biara a nkwa wɔ mu a mabɔ afi asase so.” ");
INSERT INTO twi_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noa dii nsɛm a Awurade ka kyerɛɛ no no nyinaa so. ");
INSERT INTO twi_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Bere a nsuyiri baa asase so no, na Noa adi mfe ahansia. ");
INSERT INTO twi_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa ne ne mmabarima ne ne yere ne ne nsenom mmea kɔhyɛɛ adaka no mu sɛnea ɛbɛyɛ a nsuyiri no renka wɔn. ");
INSERT INTO twi_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Mmoa a wɔn ho tew ne wɔn a wɔn ho ntew, nnomaa ne mmoa a wɔwea fam, ");
INSERT INTO twi_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","abien abien a wɔyɛ anini ne abere kɔkaa Noa ho wɔ adaka no mu, sɛnea Onyankopɔn ka kyerɛɛ Noa sɛ ɔnyɛ no. ");
INSERT INTO twi_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Na nnanson no akyi no, nsuyiri no fii ase. ");
INSERT INTO twi_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa dii mfe ahansia no mu no, ɔsram a ɛto so abien no da a ɛto so dunson no, nsuti a ɛwɔ asase mu no nyinaa bobɔe, na ɔsoro mfɛnsere nso buebuei. ");
INSERT INTO twi_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Osu tɔɔ wɔ asase so awia ne anadwo adaduanan. ");
INSERT INTO twi_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Saa da no ara, Noa ne ne mmabarima Sem, Ham ne Yafet ne ne yere ne ne mmabarima baasa no yerenom kɔhyɛɛ adaka no mu. ");
INSERT INTO twi_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Na wuram mmoa ahorow ne nyɛmmoa ahorow ne aboa biara a ɔnam asase so ne anomaa biara ne abɔde biara a ɛwɔ ntaban ka wɔn ho wɔ Adaka no mu. ");
INSERT INTO twi_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Abɔde biara a nkwa wɔ wɔn mu abien abien baa Noa nkyɛn bewuraa Adaka no mu. ");
INSERT INTO twi_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Mmoa a wowuraa mu no nyinaa, na wɔyɛ anini ne abere, sɛnea Onyankopɔn ka kyerɛɛ Noa no. Afei, Awurade kaa Noa hyɛɛ adaka no mu, too no mu. ");
INSERT INTO twi_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Nsuyiri no toaa so adaduanan wɔ asase so. Ɛmaa Adaka no so maa ɛtɛn nsu no ani. ");
INSERT INTO twi_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Nsu no kɔɔ so yirii tɛnn wɔ asase so, maa Adaka no tɛn nsu no ani. ");
INSERT INTO twi_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nsu no yirii tɛnn wɔ asase so ara kosii sɛ ɛkataa mmepɔw atenten akɛse a ɛwɔ asase so nyinaa so. ");
INSERT INTO twi_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Nsu no yirii ara kosii sɛ ɛkataa mmepɔw no so boroo so anammɔn aduonu. ");
INSERT INTO twi_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Abɔde biara a nkwa wɔ mu a ɛnam asase so te sɛ nnomaa, wuram mmoa a wɔwea asase so ne adesamma ase hyewee. ");
INSERT INTO twi_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Biribiara a ɛte asase ani no nso ase hyewee. ");
INSERT INTO twi_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Wɔpepaa biribiara a nkwa wɔ mu a ɛte asase so no. Nnipa ne mmoa ne abɔde a wɔnam asase so ne wim nnomaa nyinaa nso wɔpepaa wɔn fii asase so. Ɛkaa Noa ne wɔn a na wɔka ne ho wɔ adaka no mu no nko ara. ");
INSERT INTO twi_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Nsuyiri no toaa so wɔ asase so nnafua ɔha aduonum. ");
INSERT INTO twi_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nanso Onyankopɔn kaee Noa ne wuram mmoa a na wɔne no wɔ Adaka no mu no, na ɔmaa mframa bɔ faa asase so, na nsu no twee. ");
INSERT INTO twi_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Asuti a ɛwowɔ asase ase no mu nsu a ɛbobɔe no gyaee ba, na ɔsoro mfɛnsere no nso mu toto maa osu no gyaee tɔ. ");
INSERT INTO twi_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Nsu no toaa so twe fii asase so. Nnafua ɔha ne aduonum akyi no, na nsu no atwe koraa. ");
INSERT INTO twi_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ɔsram a ɛto so ason no da a ɛto so dunson so, Adaka no kɔtaa Ararat mmepɔw so. ");
INSERT INTO twi_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Nsu no toaa so, twee ara kosii ɔsram a ɛto so du no so. Na ɔsram no da a edi kan no, mmepɔw no atifi daa adi. ");
INSERT INTO twi_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Adaduanan akyi no, Noa buee mfɛnsere a otwa too Adaka no ho no, ");
INSERT INTO twi_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","na ɔsomaa kwaakwaadabi ma odii akɔneaba kosii sɛ nsu no nyinaa yow fii asase no so. ");
INSERT INTO twi_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Afei, ɔsomaa aborɔnoma sɛ ɔnkɔhwɛ sɛ asase no so awo ana. ");
INSERT INTO twi_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Nanso aborɔnoma no annya baabi ansi, efisɛ na nsu no akata asase no so nyinaa. Enti ɔsan baa Noa nkyɛn ma Noa teɛɛ ne nsa soo ne mu de no baa Adaka no mu. ");
INSERT INTO twi_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noa twɛn nnanson, na ɛno akyi no, ɔsan somaa aborɔnoma no bio. ");
INSERT INTO twi_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Bere a aborɔnoma no san baa ne nkyɛn anwummere no, na ngodua ahabammono a watew tua nʼano. Ɛno na ɛmaa Noa huu sɛ nsu no atwe afi asase no so. ");
INSERT INTO twi_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Noa twɛn nnanson bio, na ɔsan somaa aborɔnoma no, nanso wansan amma ne nkyɛn bio. ");
INSERT INTO twi_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Na ɛbaa sɛ Noa dii mfe ahansia ne baako, ɔsram a edi kan no mu da a edi kan no, na nsu no atwe afi asase no so. Enti Noa yii Adaka no suhyɛ no, na ohuu sɛ asase so awo. ");
INSERT INTO twi_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ɔsram a ɛto so abien no da a ɛto so aduonu ason so no na asase no so woo koraa. ");
INSERT INTO twi_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Onyankopɔn ka kyerɛɛ Noa se, ");
INSERT INTO twi_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Wo ne wo yere ne wo mmabarima ne wɔn yerenom mfi Adaka no mu mpue. ");
INSERT INTO twi_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Yi abɔde biara a nkwa wɔ mu a wɔwɔ wo nkyɛn, a ɛyɛ nnomaa, mmoa ne mmoa a wɔnam asase so nyinaa fi Adaka no mu sɛnea ɛbɛyɛ a, wɔn ase bɛdɔ wɔ asase so.” ");
INSERT INTO twi_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Enti Noa ne ne mmabarima ne ne yere ne ne mmabarima yerenom fii Adaka no mu. ");
INSERT INTO twi_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Mmoa no nyinaa ne abɔde a wɔnam asase so nyinaa ne nnomaa nyinaa ne biribiara a ɛnam asase so nyinaa fii Adaka no mu saa ara mmaako mmaako. ");
INSERT INTO twi_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Na Noa sii afɔremuka maa Awurade. Ɔfaa mmoa ne nnomaa a wɔn ho tew, de bɔɔ ɔhyew afɔre wɔ afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Awurade tee afɔre a Noa bɔe no huam no, ɔkaa wɔ ne koma mu se, “Ɛwɔ mu sɛ bɔne ahyɛ onipa koma ma fi ne mmofraase de, nanso merenni onipa akyi nnome asase bio. Na merensɛe abɔde a nkwa wɔ mu bio sɛnea mayɛ yi. ");
INSERT INTO twi_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Mmere dodow a asase da so wɔ hɔ yi, ogu ne otwa, awɔw ne ahuhuru, asusow ne ɔpɛ, awia ne anadwo to rentwa da.” ");
INSERT INTO twi_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Afei, Onyankopɔn hyiraa Noa ne ne mmabarima no ka kyerɛɛ wɔn se, “Monwo, na monyɛ bebree nhyɛ asase so ma. ");
INSERT INTO twi_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mo ho hu ne mo ho suro bɛtɔ mmoa a wɔwɔ asase so nyinaa ne wim nnomaa nyinaa ne abɔde a wɔwɔ asase so ne nsu mu mpataa nyinaa so. Wɔn nyinaa hyɛ mo nsa. ");
INSERT INTO twi_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Biribiara a nkwa wɔ mu, na ɛkeka ne ho no bɛyɛ mo aduan. Sɛnea mede nhabammono hyɛɛ mo nsa no, afei de, mede biribiara ma mo. ");
INSERT INTO twi_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Nanso ɛnsɛ sɛ mowe aboa a wontwaa ne mene mmaa ne mogya no ngui no nam. ");
INSERT INTO twi_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Na wo nkwa de, nea ɛbɛyɛ biara, mebisa ho akontaabu. Onipa a okum ne yɔnko nipa no, mebisa no ho asɛm. Mpo, aboa biara a obekum onipa no, mewɔ saa aboa no nso asɛmmisa. Mebisa onipa kra ho asɛm. ");
INSERT INTO twi_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Obiara a ohwie onipa mogya gu no, onipa so na wɔnam behwie ɔno nso mogya agu, efisɛ Onyankopɔn no ara sɛso na ɔbɔɔ onipa. ");
INSERT INTO twi_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mo de, monwo, na monyɛ bebree. Mo ase mfɛe wɔ asase so, na monnɔɔso.” ");
INSERT INTO twi_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Afei, Onyankopɔn ka kyerɛɛ Noa ne ne mmabarima a wɔka ne ho no se, ");
INSERT INTO twi_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Nnɛ, me ne mo ne mo asefo a wɔbɛwo wɔn no ");
INSERT INTO twi_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ne abɔde biara a nkwa wɔ mu a na wɔwɔ mo nkyɛn wɔ Adaka no mu yɛ apam: nnomaa, nyɛmmoa ne wuram mmoa a wɔne mo fi Adaka no mu bae no nyinaa, ne abɔde biara a nkwa wɔ mu a wɔwɔ asase so. ");
INSERT INTO twi_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Me ne mo yɛ mʼapam sɛ: Meremfa nsuyiri nsɛe abɔde biara a nkwa wɔ mu a ɛwɔ asase so. Saa ara nso na meremfa nsuyiri nsɛe asase bio da.” ");
INSERT INTO twi_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Na Onyankopɔn kae se, “Eyi ne apam a me, Onyankopɔn, ne mo ne abɔde a nkwa wɔ mu biara a wɔka mo ho no ne nkyirimma nyinaa reyɛ no ho nsɛnkyerɛnne. ");
INSERT INTO twi_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mato me nyankontɔn wɔ omununkum mu. Ɛno na ɛbɛyɛ apam a ɛbɛda me ne asase ntam. ");
INSERT INTO twi_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Bere biara a mede omununkum bɛba asase ani, na sɛ nyankontɔn pue wɔ omununkum no mu a, ");
INSERT INTO twi_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","mɛkae mʼapam a ɛda me ne mo ne abɔde a nkwa wɔ mu ahorow no nyinaa ntam. Nsuyiri a ɛbɛsɛe abɔde a nkwa wɔ mu no nyinaa remma da biara da bio. ");
INSERT INTO twi_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Bere biara a nyankontɔn bɛto wɔ omununkum mu no, mehu na makae apam a ɛwɔ hɔ daa a ɛda me, Onyankopɔn, ne abɔde a nkwa wɔ mu ahorow nyinaa a wɔwɔ asase yi so no ntam no.” ");
INSERT INTO twi_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Enti Onyankopɔn ka kyerɛɛ Noa se, “Eyi ne apam a me ne abɔde biara a nkwa wɔ mu a wɔwɔ asase yi so ayɛ no ho nsɛnkyerɛnne.” ");
INSERT INTO twi_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Eyinom ne Noa mmabarima a wofi Adaka no mu bae: Sem, Ham ne Yafet. Ham na ɔwoo Kanaan. ");
INSERT INTO twi_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Eyinom ne Noa mmabarima. Wɔn mu na nnipa a wɔahwete wɔ asase so nyinaa fi bae. ");
INSERT INTO twi_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa yɛ okuafo a odii kan. Ɔyɛɛ bobeturo. ");
INSERT INTO twi_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Da bi, ɔnom bobesa no bi bow ma ɔdaa ne ntamadan mu adagyaw. ");
INSERT INTO twi_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham a ɔwoo Kanaan no kɔtoo nʼagya Noa sɛ ɔda adagyaw. Ofii hɔ no, ɔkɔbɔɔ ne nuabarimanom baanu no amanneɛ. ");
INSERT INTO twi_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Enti Sem ne Yafet faa atade de guu wɔn mmati so, kɔɔ nkyirinkyiri de kɔkataa wɔn agya adagyaw so. Na wɔn ani nkyerɛ wɔn agya nti, wɔanhu nʼadagyaw mu. ");
INSERT INTO twi_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Bere a Noa ani so tetew no, na ohuu sɛnea ne kaakyiri no ayɛ no, ");
INSERT INTO twi_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ɔkae se, “Nnome nka Ham asefo a wɔyɛ Kanaanfo. Wɔbɛyɛ wɔn nuanom mu nkoa mu nkoa.” ");
INSERT INTO twi_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Noa kaa bio se, “Me nhyira a efi Awurade, me Nyankopɔn, nkyɛn no nka Sem! Kanaan nyɛ Sem akoa. ");
INSERT INTO twi_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Onyankopɔn ntrɛw Yafet ase ne nʼasase mu. Yafet ntena Sem ntamadan mu, na Kanaan nyɛ nʼakoa.” ");
INSERT INTO twi_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nsuyiri no akyi no, Noa tenaa ase mfe ahaasa ne aduonum. ");
INSERT INTO twi_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa dii mfe ahankron ne aduonum, ansa na ɔrewu. ");
INSERT INTO twi_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Eyinom ne Noa mmabarima: Wɔne Sem, Ham ne Yafet asefo. Wɔwowoo mmabarima nsuyiri no akyi. ");
INSERT INTO twi_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafet asefo ni: Gomer, Magog, Media, Yawan, Tubal, Mesek ne Tiras. ");
INSERT INTO twi_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer asefo ni: Askenas, Rifat ne Togarma. ");
INSERT INTO twi_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawan asefo ni: Elisa, Tarsis, Kitim ne Rodanim. ");
INSERT INTO twi_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Na wɔn asefo bɛyɛɛ po so adwumayɛfo wɔ nsase ahorow so a na abusuakuw biara ka ne kasa nko. ");
INSERT INTO twi_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham asefo ni: Kus, Misraim, Put ne Kanaan. ");
INSERT INTO twi_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus asefo ni: Seba, Hawila, Sabta, Raama ne Sabteka. Na Raama asefo nso ne: Saba ne Dedan. ");
INSERT INTO twi_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus woo Nimrod. Na Nimrod bɛyɛɛ ɔkofo kɛse wɔ asase so. ");
INSERT INTO twi_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Na ɔyɛ ɔbɔmmɔfo kɛse a Awurade ahyira no, na wɔbɔ ne din ka asɛm. Na obiara a ɔyɛ akokodurusɛm no, wɔde no toto Nimrod a na ɔyɛ ɔbɔmmɔfo kɛse a Awurade ahyira no no ho. ");
INSERT INTO twi_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nʼahenni fii ase wɔ Babilonia, Erek, Akad ne Kalne a ne nyinaa wɔ Sinear asase so. ");
INSERT INTO twi_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ofii saa asase no so trɛw nʼahenni mu kɔɔ Asiria, kɔkyekyeree Ninewe. Rehobot-Ir, Kala ne ");
INSERT INTO twi_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resen a ɛda Ninewe ne Kala ntam; ɛno na ɛyɛ kurow kɛse wɔ saa ahemman no mu. ");
INSERT INTO twi_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Na Misraim woo Ludfo, Anamfo, Lehabfo, Naftuhfo, ");
INSERT INTO twi_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusfo, Kasluhfo ne Kaftorfo a wɔn ase na Filistifo fi. ");
INSERT INTO twi_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Na Kanaan woo nʼabakan Sidon ne Het. ");
INSERT INTO twi_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusifo, Amorifo, Girgasifo, ");
INSERT INTO twi_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hewifo, Arkifo, Sinifo, ");
INSERT INTO twi_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwadfo, Semarifo ne Hematifo. Akyiri no, Kanaanfo mmusua no petee. ");
INSERT INTO twi_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaan nsase ahye trɛw fii Sidon koduu Gerar de kosii Gasa koduu Sodom ne Gomora, Adma, Seboim de kosi Lasa. ");
INSERT INTO twi_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Eyinom ne Ham asefo a wɔn mmusuakuw, wɔn kasa, wɔn nsase ne wɔn aman da wɔn adi. ");
INSERT INTO twi_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem a na ne nua panyin ne Yafet no nso woo mmabarima. Sem nananom ne Eber mma. ");
INSERT INTO twi_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem asefo ni: Elam, Asur, Arfaksad, Lud ne Aram. ");
INSERT INTO twi_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram asefo ni: Us, Hul, Geter ne Mas. ");
INSERT INTO twi_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Na Arfaksad woo Sela, na Sela woo Eber. ");
INSERT INTO twi_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber woo mmabarima baanu. Wɔtoo ɔbaako din Peleg a ase kyerɛ Nkyekyɛmu, efisɛ nʼawobere mu na kasa ahorow nti, nnipa a wɔwɔ asase so mu kyekyɛe ma wɔhwetee. Na wɔtoo ne nua a ɔka ne ho no din Yoktan. ");
INSERT INTO twi_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan woo Almodada, Selef, Hasarmawet, Yera, ");
INSERT INTO twi_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO twi_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO twi_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila ne Yobab. ");
INSERT INTO twi_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Asase a wɔte so no trɛw fi Mesa kosi Sefar, ɔmantam a ɛda bepɔw so wɔ apuei fam no. ");
INSERT INTO twi_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Eyinom ne Sem mmabarima, sɛnea wɔn mmusua ne wɔn kasa, wɔn nsase ne wɔn amanaman te no. ");
INSERT INTO twi_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Eyinom ne Noa mmabarima mmusua, sɛnea wɔn awo ntoatoaso te wɔ wɔn amanaman mu. Na efi eyinom mu na nsuyiri no akyi no amanaman petee asase so. ");
INSERT INTO twi_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bere bi, na nnipa a wɔwɔ asase so nyinaa ka kasa koro. ");
INSERT INTO twi_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Saa nnipa yi tu baa apuei fam no, wɔbɛtoo asase tamaa wɔ Babilonia asase so, na wɔtenaa hɔ. ");
INSERT INTO twi_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wosisee wɔn ho wɔn ho se, “Momma yentwa ntayaa na yɛnto mma ɛmmen yiye.” Na wɔde ntayaa ne ama na esi adan. ");
INSERT INTO twi_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Na wɔkae bio se, “Momma yɛnkyekye kurow kɛse, na yensi abantenten a ne sorɔnsorɔmmea du ɔsorosoro wɔ kurow no mu, na yennye din, na yɛanhwete wɔ asase so.” ");
INSERT INTO twi_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Awurade sian fii ɔsoro baa fam, behuu kurow kɛse a wɔrekyekyere no ne abantenten a wɔresi no. ");
INSERT INTO twi_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Awurade kae se, “Sɛ nnipa koro a wɔka kasa baako afi ase redi saa dwuma yi a, ɛno de biribiara a wɔbɔ wɔn tirim sɛ wɔbɛyɛ no renyɛ wɔn den. ");
INSERT INTO twi_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mommra na yɛnkɔ asase so, na yɛnkɔtoto wɔn kasa, na obiara nnya ne kasa, sɛnea obiara nte ne yɔnko kasa.” ");
INSERT INTO twi_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ɛnam eyi so maa Awurade hwetee nnipa no nyinaa mu ma wɔpetee asase so nyinaa, maa wogyaee kurow kɛse no kyekyere. ");
INSERT INTO twi_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ɛno nti na wɔfrɛɛ kurow kɛse no Babel, efisɛ, ɛhɔ na Awurade totoo kasa baako a na wɔka wɔ wiase nyinaa saa bere no, maa wɔn kasa ahorow. Efi hɔ na Awurade hwetee nnipa no nyinaa mu ma wɔpetee asase so nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Eyi ne Sem asefo ho asɛm. Nsuyiri no akyi, mfe abien no a na Sem adi mfe ɔha no, ɔwoo Arfaksad. ");
INSERT INTO twi_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sem woo Arfaksad akyi no ɔtenaa ase mfe ahannum, wowoo mmabarima ne mmabea bi nso kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaksad nso dii mfe aduasa anum no, ɔwoo Sela. ");
INSERT INTO twi_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arfaksad woo Sela akyi no ɔtenaa ase mfe ahannan ne abiɛsa, wowoo mmabarima ne mmabea bi nso kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela dii mfe aduasa no, ɔwoo Eber. ");
INSERT INTO twi_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sela woo Eber akyi no ɔtenaa ase mfe ahannan ne abiɛsa, wowoo mmabarima ne mmabea bi nso kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber dii mfe aduasa anan no, ɔwoo Peleg. ");
INSERT INTO twi_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber woo Peleg akyi no ɔtenaa ase mfe ahannan ne aduasa, wowoo mmabarima ne mmabea bi nso kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg dii mfe aduasa no, ɔwoo Reu. ");
INSERT INTO twi_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg woo Reu akyi no ɔtenaa ase mfe ahannu ne akron, wowoo mmabarima ne mmabea bi nso kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu dii mfe aduasa abien no, ɔwoo Serug. ");
INSERT INTO twi_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu woo Serug akyi no ɔtenaa ase mfe ahannu ne ason, wowoo mmabarima ne mmabea bi nso kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug dii mfe aduasa no, ɔwoo Nahor. ");
INSERT INTO twi_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug woo Nahor akyi no ɔtenaa ase mfe ahannu wowoo mmabarima ne mmabea bi nso kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor dii mfe aduonu akron no, ɔwoo Tera. ");
INSERT INTO twi_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor woo Tera akyi no ɔtenaa ase mfe ɔha ne dunkron, wowoo mmabarima ne mmabea bi nso kaa ho. ");
INSERT INTO twi_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera dii mfe aduɔson no, ɔwoo Abram, Nahor ne Haran. ");
INSERT INTO twi_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Eyi ne Tera asefo ho asɛm. Tera woo Abram, Nahor ne Haran. Na Haran woo Lot. ");
INSERT INTO twi_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Bere a Haran agya Tera te ase no, Haran wuu wɔ faako a wɔwoo no a wɔfrɛ hɔ Ur, a ɛwɔ Kaldea asase so no. ");
INSERT INTO twi_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram ne Nahor warewaree. Na Abram yere din de Sarai, na Nahor nso yere din de Milka a na ɔyɛ Haran babea. Saa Haran yi na ɔwoo Milka ne Iska. ");
INSERT INTO twi_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Na Sarai yɛ obonin; na onni ba. ");
INSERT INTO twi_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera faa ne babarima Abram ne ne nena Lot, a ɔyɛ Haran babarima ne nʼasebea Sarai, a na ɔyɛ ne babarima Abram yere no, ne wɔn nyinaa sii mu fii Ur a ɛwɔ Kaldea asase so sɛ wɔrekɔ Kanaan asase so. Na woduu Haran no, wɔtenaa hɔ. ");
INSERT INTO twi_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera dii mfe ahannu ne anum, na owui wɔ Haran. ");
INSERT INTO twi_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Awurade ka kyerɛɛ Abram se, “Fi wʼabusuafo nkyɛn ne wʼasase so kɔ asase a mɛkyerɛ wo no so. ");
INSERT INTO twi_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Mɛma wo ayɛ ɔman kɛse, na mehyira wo. Mɛma wo din atrɛw, na woayɛ nhyira ama nnipa bebree. ");
INSERT INTO twi_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mehyira wɔn a wohyira wo, na obiara a ɔdome wo no, mɛdome no. Ɛnam wo so na wobehyira nnipa a wɔwɔ asase so nyinaa.” ");
INSERT INTO twi_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Enti Abram kɔe, sɛnea Awurade Nyankopɔn ka kyerɛɛ no no. Na Lot ne no kɔe. Bere a Abram refi Haran asase so akɔ no, na wadi mfe aduɔson anum. ");
INSERT INTO twi_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Na Abram faa ne yere Sarai ne ne nuabarima Haran babarima Lot, nʼagyapade ne nʼasomfo a onyaa wɔn wɔ Haran nyinaa, sii mu kɔɔ Kanaan asase so. ");
INSERT INTO twi_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Wɔfaa asase no so ara kosii baabi a wɔfrɛ hɔ Sekem, koduu odum dua bi a esi baabi a wɔfrɛ hɔ More. Ɛhɔ na wosii wɔn ntamadan. Saa bere no, na Kanaanfo na wɔte asase no so. ");
INSERT INTO twi_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Afei, Awurade Nyankopɔn yii ne ho adi kyerɛɛ Abram ka kyerɛɛ no se, “Mede saa asase yi bɛma wʼaseni.” Enti Abram sii afɔremuka wɔ hɔ, de kaee Awurade Nyankopɔn a ɔdaa ne ho adi kyerɛɛ no no. ");
INSERT INTO twi_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Akyiri no, Abram fii hɔ, de nʼani kyerɛɛ mmepɔw bi a ɛwɔ apuei fam, sii ne ntamadan wɔ hɔ. Na Bet-El da atɔe fam, na Ai nso da apuei fam. Ɛhɔ na osii afɔremuka maa Awurade Nyankopɔn, sɔree no wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Na Abram fii hɔ toaa so de nʼani kyerɛɛ Negeb. ");
INSERT INTO twi_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Saa bere no, ɔkɔm kɛse bi sii asase a na Abram te so no so. Enti otu kɔtenaa Misraim asase so kakra, efisɛ ɔkɔm a ɛbaa asase no so no, na ano yɛ den yiye. ");
INSERT INTO twi_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ɔreyɛ adu Misraim asase so no, ɔka kyerɛɛ ne yere Sarai se, “Minim sɛ woyɛ ɔbea a wo ho yɛ fɛ yiye. ");
INSERT INTO twi_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Sɛ Misraimfo no hu wo a, wɔbɛka se, ‘Ne yere ni. Momma yenkum no, na yɛmfa no.’ ");
INSERT INTO twi_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Na sɛ woka sɛ woyɛ me nuabea a, Misraimfo no bɛhwɛ me yiye, efisɛ wɔn ani wɔ wo ho nti wɔrenkum me.” ");
INSERT INTO twi_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Bere a woduu Misraim asase so no, Misraimfo no huu sɛ ɔbea no ho yɛ fɛ yiye. ");
INSERT INTO twi_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Na ɔhene Farao mpanyimfo huu no no, wɔkamfoo nʼahoɔfɛ, kɔbɔɔ no amanneɛ. Enti ɔhene Farao soma ma wɔkɔfaa ɔbea no baa nʼahemfi hɔ. ");
INSERT INTO twi_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Esiane ɔbea no ahoɔfɛ nti, ɔhene Farao hwɛɛ Abram yiye, maa no nguan, anantwi, afurumnini ne afurumbere, nkoa, mfenaa ne yoma. ");
INSERT INTO twi_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Na esiane Abram yere Sarai te a na ɔte Farao ahemfi hɔ no nti, Awurade Nyankopɔn maa ɔyaredɔm baa Farao ne ne fifo so. ");
INSERT INTO twi_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Eyi nti, Farao frɛɛ Abram bisaa no se, “Dɛn na woayɛ me yi? Adɛn nti na woanka ankyerɛ me sɛ ɔbea no yɛ wo yere? ");
INSERT INTO twi_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Adɛn nti na wokae se, ‘Ɔyɛ me nuabea’ na woama maware no? Sɛ saa na ɛte de a, gye wo yere. Wo yere ni! Fa wʼade kɔ!” ");
INSERT INTO twi_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Na Farao hyɛɛ asraafo sɛ wonkogya Abram ne ne yere kwan a wɔn fifo ne wɔn agyapade nyinaa ka ho. ");
INSERT INTO twi_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram tu fii Misraim. Ɔno, ne yere, Lot, nʼagyapade ne ne fifo nyinaa baa Negeb. ");
INSERT INTO twi_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Saa bere no na Abram anya ne ho a ɔwɔ nyɛmmoa, dwetɛ ne sikakɔkɔɔ pii. ");
INSERT INTO twi_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ofii Negeb hɔ no, odii atutena ara koduu Bet-El, faako a odii kan sii ne ntamadan a ɛwɔ Bet-El ne Ai ntam no. ");
INSERT INTO twi_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ɛhɔ na kan no osii nʼafɔremuka. Ɛhɔ nso na ɔkɔɔ so som Awurade. ");
INSERT INTO twi_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Na Lot a ɔne Abram nam no nso yɛ ɔdefo a ɔwɔ nguan, anantwi ne asomfo bebree. ");
INSERT INTO twi_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Esiane sɛ saa bere no na Abram ne Lot nyinaa anya wɔn ho, na wɔwɔ nguan, anantwi ne asomfo pii nti, na wɔnsen asase no so. ");
INSERT INTO twi_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Na akasakasa taa baa Abram mmoahwɛfo ne Lot mmoahwɛfo no ntam. Saa bere no na Kanaanfo ne Perisifo nso tete asase no so. ");
INSERT INTO twi_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Enti Abram ka kyerɛɛ Lot se, “Mesrɛ wo, mma akasakasa mma me ne wo anaa me mmoahwɛfo ne wo mmoahwɛfo ntam, efisɛ yɛyɛ anuanom. ");
INSERT INTO twi_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ɛnyɛ asase no nyinaa na ɛda wʼanim yi? Ma yenni mpaapaemu. Sɛ wokɔ benkum a, mɛkɔ nifa, na sɛ wokɔ nifa nso a, mɛkɔ benkum.” ");
INSERT INTO twi_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot hwɛɛ ne ho hyiae, huu sɛ asase a ɛda Yordan ho no yɛ asasebere. Na nsu wɔ mu baabiara te sɛ Eden turo mu anaasɛ Misraim asase a ɛda Soar fam hɔ no ara pɛ. Saa bere no, na Awurade nnya nsɛee Sodom ne Gomora ɛ. ");
INSERT INTO twi_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Na Lot de nʼani kyerɛɛ apuei fam, faa asase a ɛda Yordan ho no. Eyi ne ɔkwan a Abram ne Lot faa so dii ntetewmu no. ");
INSERT INTO twi_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram tenaa Kanaan asase so. Na Lot nso dii atutena wɔ nkuropɔn a ɛwowɔ nsase tamaa no so, na okosii ne ntamadan wɔ baabi a ɛbɛn Sodom. ");
INSERT INTO twi_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Na nnipa a wɔwɔ Sodom kurow no mu no yɛ amumɔyɛfo a daa wɔyɛ bɔne akɛseakɛse de tia Awurade. ");
INSERT INTO twi_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot tew ne ho fii Abram ho akyi no, Awurade ka kyerɛɛ Abram se, “Afei, ma wʼani so hwɛ atifi fam, anafo fam, apuei fam ne atɔe fam. ");
INSERT INTO twi_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Mede asasetam a wʼani tua yi nyinaa bɛma wo ne wʼasefo afebɔɔ. ");
INSERT INTO twi_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mɛma wʼasefo adɔɔso sɛ asase so mfutuma a obiara ntumi nkan. ");
INSERT INTO twi_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Sɔre, kɔ na kɔhwehwɛ asase no so nyinaa, efisɛ mede rema wo.” ");
INSERT INTO twi_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Enti Abram tutuu ne ntamadan bɛtenaa odum kwae bi a ɛyɛ Mamrɛ de wɔ Hebron no. Ɛhɔ na osii afɔremuka maa Awurade. ");
INSERT INTO twi_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Na ɛbaa sɛ Babiloniahene Amrafel, Elasarhene Ariok, Elamhene Kedorlaomer, Goiimhene Tideal bere so, ");
INSERT INTO twi_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","na saa ahemfo yi ne Sodomhene Birsa, Gomorahene Birsa, Admahene Sinab, Seboimhene Semeber ne Belahene a na wɔfrɛ no Soar no dii ako. ");
INSERT INTO twi_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Saa ahemfo yi a wɔyɛ Sodomhene, Gomorahene, Admahene, Seboimhene ne Belahene boaboaa wɔn asraafo ano wɔ Sidim subon a ɛno ne Nkyene Po no mu. ");
INSERT INTO twi_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Wɔsom Kedorlaomer mfe dumien, na afe a ɛto so dumiɛnsa mu no, wɔtew atua. ");
INSERT INTO twi_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Afe akyi no, Kedorlaomer ne ahemfo a wɔbɛkaa ne ho no tuu ɔsa. Na wɔko dii saa nnipa yi so nkonim: Refaimfo, a wɔwɔ Asterot-Karnaim ne Susifo a wɔwɔ Ham ne Emifo a wɔwɔ Kiriataim ");
INSERT INTO twi_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ne Horifo a wɔwɔ bepɔw Seir so de kosi El-Paran a ɛda sare ano no. ");
INSERT INTO twi_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Afei, wɔsan wɔn akyi baa En-Mispat a akyiri no, wɔfrɛɛ no Kades bekunkum Amalekfo ne Amorifo nso a na wɔte Hasason-Tamar, sɛee wɔn man no nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Afei, saa ahemfo baanum yi a wɔne Sodomhene, Gomorahene, Admahene, Seboimhene ne Belahene a wɔfrɛ no Soar no kɔɔ ");
INSERT INTO twi_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","saa ahemfo baanan yi a wɔne Elamhene Kedorlaomer, Goiimhene Tideal, Sinearhene Amrafel ne Elasarhene Ariok nkyɛn. Wokohyiaa wɔ Sidim subon mu. ");
INSERT INTO twi_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Na nkomoa pii wɔ Sidim Bon no mu a wɔatu ama wɔ hɔ pɛn. Enti ɛbaa sɛ Sodomhene ne Gomorahene asraafo no reguan no, wɔn mu bi kɔtotɔɔ nkomoa no mu, na nkae no nso guan kɔɔ mmepɔw a na ɛwɔ hɔ no so. ");
INSERT INTO twi_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ahemfo baanan a wodii nkonim no fom Sodom ne Gomorafo ahode ne wɔn nnuan nyinaa de kɔe. ");
INSERT INTO twi_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Esiane sɛ na Abram nuabarima ba Lot te Sodom asase so no nti, nkonimdifo no faa ɔno ne nʼagyapade nyinaa kɔe. ");
INSERT INTO twi_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Na Sodom ne Gomora aguanfo no mu baako bɛbɔɔ Hebrini Abram ɔko no mu amanneɛ. Saa bere no, na Abram abɔ ne ho atenase wɔ odum kwae bi a ɛyɛ Amorini Mamrɛ de no ase. Mamrɛ yi nso, na ne nuanom ne Eskol ne Aner a na wɔyɛ Abram aboafo no. ");
INSERT INTO twi_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Bere a Abram tee sɛ wɔafa ne busuani Lot dommum no, ɔboaboaa ne fifo nnipa ahaasa ne dunwɔtwe a wɔatetew wɔn sɛ akofo ano, maa wotiw atamfo no, kosii kurow bi a wɔfrɛ no Dan mu. ");
INSERT INTO twi_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Da no anadwo, Abram kyekyɛɛ nʼakofo no mu ma wɔtow hyɛɛ atamfo no so, kunkum wɔn, taa wɔn koduu kurow bi a wɔfrɛ no Hoba a ɛwɔ Damasko atifi fam no mu. ");
INSERT INTO twi_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram gyee ɔko mu nneɛma a wɔfaa no nyinaa faa ne busuani Lot ne nʼagyapade ne mmea ne nnipa foforo a wɔkyekyeree wɔn no nyinaa san bae. ");
INSERT INTO twi_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram kodii Kedorlaomer ne ahemfo a na wɔka ne ho no so nkonim akyi no, Sodomhene behyiaa no wɔ Sawe bon a ɛno ara na wɔfrɛ no Ɔhene Bon no mu. ");
INSERT INTO twi_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Na Salemhene Melkisedek a na ɔyɛ Ɔsorosoro Nyankopɔn sɔfo no de brodo ne nsa brɛɛ no, ");
INSERT INTO twi_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","behyiraa Abram se: “Ɔsorosoro Nyankopɔn a ɔbɔɔ ɔsoro ne asase, Nhyira nka wo, Abram. ");
INSERT INTO twi_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Na nhyira nka Ɔsorosoro Nyankopɔn a ɔde wʼatamfo ahyɛ wo nsam no.” Na Abram maa Melkisedek nneɛma a ne nsa kae no nyinaa mu biara nkyekyɛmu du mu baako. ");
INSERT INTO twi_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodomhene no ka kyerɛɛ Abram se, “Fa me nnipa a wofaa wɔn no ma me na wo nso, fa nneɛma a aka no nyinaa.” ");
INSERT INTO twi_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Nanso Abram ka kyerɛɛ Sodomhene no se, “Madi nsew aka ntam akyerɛ AWURADE, Ɔsorosoro Nyankopɔn, ɔsoro ne asase yɛfo se, ");
INSERT INTO twi_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Merennye biribiara, sɛ ɛyɛ asaawa hama baako anaa mpaboa so hama mpo, mfi wo nkyɛn, na woanka da sɛ, ‘Me na memaa Abram nyaa ne ho.’ ");
INSERT INTO twi_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Merennye hwee mfi wo nkyɛn, gye nea me mmarima yi adi nko. Me nkurɔfo Aner, Eskol ne Mamrɛ de, ma wɔn wɔn kyɛfa.” ");
INSERT INTO twi_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Eyinom akyi no, Awurade kasa kyerɛɛ Abram wɔ anisoadehu mu se, “Abram, nsuro. Meyɛ wo nkatabo. Meyɛ wo kyɛfa a ɛsom bo.” ");
INSERT INTO twi_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram nso buae se, “Awurade Nyankopɔn, dɛn na wode bɛma me wɔ bere a minni ɔba. Onipa a obedi mʼade no yɛ Damaskoni Elieser?” ");
INSERT INTO twi_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Na Abram toaa so se, “Wommaa me mma nti, akoa a wɔwoo no wɔ me fi no na obedi mʼade.” ");
INSERT INTO twi_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Na Awurade ka kyerɛɛ Abram se, “Saa ɔbarima yi renni wʼade da, gye wʼankasa wo yafunumma.” ");
INSERT INTO twi_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Onyankopɔn de Abram kɔɔ afikyiri, na ɔka kyerɛɛ no se, “Ma wʼani so hwɛ soro na hwɛ sɛ wubetumi akan soro nsoromma ana.” Afei, Onyankopɔn ka kyerɛɛ Abram se, “Saa ara na wʼasefo bɛdɔɔso nen.” ");
INSERT INTO twi_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram gyee asɛm a Awurade kae no dii. Ne saa nti, Awurade buu no onipa trenee. ");
INSERT INTO twi_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Awurade Nyankopɔn ka kyerɛɛ Abram bio se, “Mene Awurade a mede wo fi Ur a ɛwɔ Kaldeafo asase so bae sɛ mede saa asase yi rema wo sɛ wʼagyapade.” ");
INSERT INTO twi_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Nanso Abram kae se, “Ɔsorosoro Awurade, ɛbɛyɛ dɛn na mehu sɛ asase no bɛyɛ me dea?” ");
INSERT INTO twi_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Awurade ka kyerɛɛ Abram se, “Fa nantwi ba a wadi mfe abiɛsa, abirekyibere a wadi mfe abiɛsa, Odwennini a wadi mfe abiɛsa, agyenkuku ne aborɔnoma ba brɛ me.” ");
INSERT INTO twi_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram de eyinom nyinaa brɛɛ Onyankopɔn, paapae wɔn mu abien abien, na ɔde afaafa no kyerɛkyerɛɛ anim, de guguu hɔ. Na nnomaa no de, wampaapae wɔn mu. ");
INSERT INTO twi_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Na apete besisii mmoa no afunu so no, Abram pam wɔn. ");
INSERT INTO twi_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Bere a owia rekɔtɔ no, Abram daa hatee, na sum kabii a ɛyɛ hu tɔɔ ne so. ");
INSERT INTO twi_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Afei, Awurade ka kyerɛɛ Abram se, “Gye di sɛ wʼasefo bɛyɛ ahɔho wɔ asase a ɛnyɛ wɔn dea so. Wɔbɛyɛ nkoa wɔ ɔman no mu, asom, na wɔayɛ wɔn ayayade mfe ahannan. ");
INSERT INTO twi_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Nanso mɛtwe saa ɔman a wʼasefo bɛsom wɔn no aso, na ɛno akyi no, wobefi ɔman a wɔsom mu no mu aba sɛ adefo. ");
INSERT INTO twi_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Wo de, wubewu asomdwoe mu. Wubenyin akyɛ yiye ansa na woawu. ");
INSERT INTO twi_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nanso awo ntoatoaso a ɛto so anan no mu, wʼasefo bɛsan aba saa ɔman yi mu bio. Efisɛ saa bere yi, Amorifo a wɔte saa asase yi so nnɛ yi bɔne a wɔyɛ no nnya nnuu nea wɔtwe wɔn aso ma ɛyɛ yiye ɛ.” ");
INSERT INTO twi_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Na ɛbaa sɛ owia kɔtɔe, na sum durui no, Abram huu ogyaframa bi sɛ ɛrefi wusiw ne ogyatɛn a ɛredɛw bɛfaa mmoa a wɔakum wɔn no afunu afaafa no ntam. ");
INSERT INTO twi_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Saa da no ara, Awurade ne Abram yɛɛ apam, kae se, “Mede saa asase a efi Misraim asubɔnten no ho, de kosi asubɔnten kɛse Eufrate ho bɛma wo ne wʼasefo. ");
INSERT INTO twi_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Saa ara nso na mede Kenifo, Kenesifo, Kadmonifo, ");
INSERT INTO twi_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hetifo, Perisifo, Refaimfo, ");
INSERT INTO twi_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorifo, Kanaanfo, Girgasifo ne Yebusifo nsase nyinaa bɛma wo ne wʼasefo no.” ");
INSERT INTO twi_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saa bere no, na Sarai nwoo ɔba mmaa Abram ɛ. Na ɔwɔ Misraimni abaawa bi a wɔfrɛ no Hagar; ");
INSERT INTO twi_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","enti Sarai ka kyerɛɛ Abram se, “Wo ara wunim sɛ Awurade ama mayɛ obonin; manwo ɔba! Mesrɛ wo, kɔ na wo ne mʼabaawa Hagar nkɔda; ebia ɛnam ne so na manya mma.” Abram penee asɛm a Sarai ka kyerɛɛ no no so. ");
INSERT INTO twi_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abram tenaa Kanaan asase so mfe du akyi no, ne yere Sarai de Misraimni abaawa Hagar no kɔmaa ne kunu no sɛ ɔnware no. ");
INSERT INTO twi_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram ne Hagar dae, na onyinsɛnee. Bere a Hagar huu sɛ wanyinsɛn no, ofii ase buu nʼawuraa Sarai animtiaa. ");
INSERT INTO twi_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Enti Sarai ka kyerɛɛ Abram se, “Saa ɔhaw a aba me so yi nyinaa fi wo! Mede mʼabaawa maa wo; afei a wahu sɛ wanyinsɛn no nti, otiatia mʼanim. Awurade mmu me ne wo ntam atɛn.” ");
INSERT INTO twi_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Nanso Abram ka kyerɛɛ Sarai se, “Ɔyɛ wʼabaawa. Nea wopɛ sɛ wode yɛ no biara, fa yɛ no.” Efi saa bere no, Sarai tan nʼabaawa Hagar ani ma oguan fii ne nkyɛn. ");
INSERT INTO twi_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Awurade bɔfo huu Hagar wɔ nsu aniwa bi ho wɔ sare no so. Na saa nsu aniwa no da ɔkwan a ɛkɔ kurow bi a wɔfrɛ no Sur no nkyɛn. ");
INSERT INTO twi_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ɔbɔfo no bisaa Hagar se, “Sarai abaawa Hagar, wufi he, na worekɔ he?” Hagar buaa no se, “Mereguan afi mʼawuraa Sarai nkyɛn.” ");
INSERT INTO twi_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Na Awurade bɔfo no ka kyerɛɛ Hagar se, “San kɔ wʼawuraa no nkyɛn, na kɔbrɛ wo ho ase ma no.” ");
INSERT INTO twi_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ɔbɔfo no ka kaa ho se, “Mɛma wʼase afɛe a, wɔkan a ɛnyɛ yiye.” ");
INSERT INTO twi_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Awurade bɔfo no san ka kyerɛɛ Hagar se, “Woanyinsɛn, na wobɛwo ɔbabarima. Wobɛto no din Ismael, efisɛ Awurade ate wʼamanehunu. ");
INSERT INTO twi_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ɔbɛyɛ sɛ sare so afurum. Obetia nnipa nyinaa, na nnipa nyinaa nso betia no; atutuwpɛ so na ɔne ne nuanom bɛtena.” ");
INSERT INTO twi_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Eyi akyi no ɔkae se, “Mahu Nea ohu me.” Ɛno nti, ɔde din El-Roi a ase ne “Onyankopɔn a ohu me” no too no. ");
INSERT INTO twi_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ɛno nti na wɔfrɛ nsu aniwa no se Beer-Lahai-Roi a ase ne “Onyankopɔn Teasefo a ohu me abura.” Ɛda Kades ne Bered ntam besi nnɛ. ");
INSERT INTO twi_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Enti Hagar woo ɔbabarima maa Abram. Abram too abofra no din Ismael. ");
INSERT INTO twi_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hagar woo Ismael no, na Abram adi mfe aduɔwɔtwe asia. ");
INSERT INTO twi_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram dii mfe aduɔkron akron no, Awurade yii ne ho adi kyerɛɛ no kae se, “Mene Otumfo Nyankopɔn, nantew mʼanim na yɛ pɛ. ");
INSERT INTO twi_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mesi apam a ɛda me ne wo ntam no so dua, na mama wʼasefo adɔɔso.” ");
INSERT INTO twi_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram de nʼanim butuu fam, na Onyankopɔn ka kyerɛɛ no se, ");
INSERT INTO twi_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Me fa mu de, saa apam yi na ɛda me ne wo ntam: wobɛyɛ aman bebree agya. ");
INSERT INTO twi_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Wɔremfrɛ wo Abram bio. Wɔbɛfrɛ wo Abraham, efisɛ mayɛ wo aman bebree agya. ");
INSERT INTO twi_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mɛma wʼasefo adɔɔso. Wɔbɛyɛ amanaman bebree na ahemfo nso afi wɔn mu. ");
INSERT INTO twi_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Mɛma mʼapam no ayɛ daapem apam a ɛbɛda me ne wo ne wʼasefo ne awo ntoatoaso a ɛbɛba no ntam. Na mɛyɛ wo ne wʼasefo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Mede Kanaan asase a nnɛ wote so sɛ ɔhɔho no nyinaa bɛma wo ne wʼasefo a wɔbɛba akyiri no nyinaa. Ɛbɛyɛ wʼagyapade a wo ne obi mmɔ mu hye afebɔɔ. Na mɛyɛ wɔn Nyankopɔn.” ");
INSERT INTO twi_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Afei, Onyankopɔn ka kyerɛɛ Abraham se, “Wo de, ɛsɛ sɛ wo ne wʼasefo ne wʼasefo a wɔbɛba akyiri no di mʼapam no so. ");
INSERT INTO twi_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Eyi ne mʼapam a ɛda me ne wo ntam a ɛsɛ sɛ wo ne wʼasefo ne wʼasefo a wɔbɛba akyiri no di so. Ɛsɛ sɛ wotwa ɔbarima biara twetia. ");
INSERT INTO twi_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ɛsɛ sɛ mutwa twetia. Ɛno na ɛbɛyɛ apam a ɛda me ne mo ntam no ho nsɛnkyerɛnne. ");
INSERT INTO twi_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ɔbarima biara a ɔyɛ wʼaseni a wɔbɛwo no no, odi nnaawɔtwe pɛ a, ɛsɛ sɛ wotwa no twetia. Nkoa a wɔwoo wɔn wɔ wo fi ne ɔnanani biara a wuyii sika tɔɔ no fii ɔmamfrani nkyɛn a ɔnyɛ wʼaseni no nso, ɛsɛ sɛ wotwa no twetia saa ara. ");
INSERT INTO twi_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Sɛ wɔwoo no wo fi oo, sɛ nso wɔkarii sika kɔtɔɔ no oo, ɛsɛ sɛ wotwa no twetia. Saa honam mu apam yi bɛyɛ daapem apam. ");
INSERT INTO twi_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Wɔbɛpam ɔbarima biara a wontwaa no twetia no afi ne nkurɔfo mu, efisɛ saa onipa no anni mʼapam no so.” ");
INSERT INTO twi_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Onyankopɔn san ka kyerɛɛ Abraham se, “Ɛfa wo yere Sarai ho nso, efi nnɛ rekɔ, woremfrɛ no Sarai bio. Wobɛfrɛ no Sara. ");
INSERT INTO twi_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mehyira no, na mɛma no awo ɔbabarima ama wo. Mehyira no ama wabɛyɛ aman nyinaa na. Nʼasefo mu na amanaman mu ahemfo befi.” ");
INSERT INTO twi_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham de nʼanim butuw fam bio. Ɔserew bisaa ne ho se, “Ebetumi aba sɛ ɔbarima a wadi mfe ɔha bɛwo ɔba ana? Sara nso a wadi mfe aduɔkron no nso, obetumi awo ɔba ana?” ");
INSERT INTO twi_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Na Abraham ka kyerɛɛ Onyankopɔn se, “Onyankopɔn ɛno de, hyira Ismael!” ");
INSERT INTO twi_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Na Onyankopɔn kae se, “Mmom, wo yere Sara bɛwo ɔbabarima ama wo, na wobɛto no din Isak, a ase ne Serew. Me ne no bɛyɛ daapem apam a ɛbɛtena hɔ ama nʼasefo a wɔbɛba akyiri no nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Na Ismael ho asɛm a wokae no nso, mate. Mehyira no ama nʼase adɔ bebree. Ɔbɛyɛ abirɛmpɔn dumien agya. Na mɛma no ayɛ ɔman kɛse. ");
INSERT INTO twi_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Nanso me ne Isak a Sara bɛwo no afe sesɛɛ no na ɛbɛyɛ mʼapam no.” ");
INSERT INTO twi_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Onyankopɔn kasa kyerɛɛ Abraham wiee no, ogyaw no hɔ kɔe. ");
INSERT INTO twi_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Saa da no ara, Abraham faa ne babarima Ismael ne mmarima a wɔwoo wɔn wɔ ne fi ne mmarima a wɔtɔɔ wɔn fii ananafo nkyɛn, twitwaa wɔn nyinaa twetia, sɛnea Onyankopɔn ka kyerɛɛ no no. ");
INSERT INTO twi_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Wotwaa Abraham twetia no, na wadi mfe aduɔkron akron. ");
INSERT INTO twi_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ne babarima Ismael nso, wotwaa no twetia no, na wadi mfe dumiɛnsa. ");
INSERT INTO twi_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Saa da no ara, na wotwaa Abraham ne ne ba Ismael nyinaa twetia. ");
INSERT INTO twi_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ɔbarima biara a ɔwɔ Abraham fi, wɔn a wɔwoo wɔn wɔ Abraham fi ne ɔbarima biara a wɔtɔɔ no fii ɔnanani bi nkyɛn no, wotwitwaa wɔn nyinaa twetia, kaa Abraham ho. ");
INSERT INTO twi_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Awia ketee bi a Abraham te ne ntamadan a ɛwɔ Mamrɛ odum kwae kwan ano no, Awurade yii ne ho adi bio kyerɛɛ no. ");
INSERT INTO twi_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham maa nʼani so no, ohuu sɛ mmarima baasa bi apue ne ntentenso. Ohuu wɔn no, otuu mmirika fii ne ntamadan no kwan ano kohyiaa wɔn, kotow wɔn. ");
INSERT INTO twi_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Abraham kae se, “Me wura, sɛ manya adom wɔ wʼanim a, ntwa me a meyɛ wʼakoa ho nkɔ. ");
INSERT INTO twi_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Momma wɔmfa nsu bi mmrɛ mo nhohoro mo anan ase, na monhome wɔ nnua yi ase kakra. ");
INSERT INTO twi_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Moaba mo akoa nkyɛn yi, momma mempɛ aduan kakra bi mma monka mo ano, na munnya ahoɔden nkɔ mo kwan.” Nnipa no penee so kae se, “Eye, yɛ nea wopɛ sɛ woyɛ.” ");
INSERT INTO twi_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Enti Abraham de ahoɔhare kɔɔ ne yere Sara nkyɛn wɔ ntamadan no mu, kɔka kyerɛɛ no se, “Ka wo ho fa asikresiam pa susukoraa abiɛsa, na fɔtɔw na fa to brodo.” ");
INSERT INTO twi_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Afei, Abraham yɛɛ ntɛm kɔɔ nʼanantwibuw no mu, kɔkyeree nantwi ba a oye na wadɔ srade de no maa ne somfo ma ɔde ahoɔhare yɛɛ ne ho adwuma. ");
INSERT INTO twi_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Afei, ɔfaa nufusu ani srade ne nufusu ne nantwi ba a ɔde anoa aduan no, de too nnipa baasa no pon. Bere a nnipa no gu so redidi no, na ogyina wɔn nkyɛn wɔ nnua no ase. ");
INSERT INTO twi_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nnipa no bisaa Abraham se, “Wo yere Sara wɔ he?” Abraham buaa wɔn se, “Ɔwɔ ntamadan no mu.” ");
INSERT INTO twi_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Afei, Awurade kae se, “Nea ɛbɛyɛ biara, afe sesɛɛ mɛba wo nkyɛn, na mɛba no na wo yere Sara awo ɔbabarima.” Saa bere no, na Sara gyina ntamadan no pon akyi, retie nkɔmmɔ no. ");
INSERT INTO twi_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Na Abraham ne Sara nyinaa anyinyin yiye a wɔn mfe akɔ anim koraa nti, na Sara awo apa ho. ");
INSERT INTO twi_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara tee asɛm no, ɔserew ne tirim, kae se, “Manya awie aberewabɔ, na me kunu nso abɔ akwakoraa yi, ɛbɛyɛ dɛn na manya saa anigyede yi?” ");
INSERT INTO twi_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Enti Awurade bisaa Abraham se, “Adɛn nti na Sara serew bisae se, ‘Ampa ara sɛ manyin adu sɛɛ yi, metumi awo ba ana?’ ");
INSERT INTO twi_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Biribi boro Awurade ahoɔden so sɛ ɔbɛyɛ? Afe sesɛɛ a mɛsan aba sɛnea mahyɛ wo ho bɔ no, na wo yere Sara awo ɔbabarima.” ");
INSERT INTO twi_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Na Sara suro nti, otwaa atoro se, “Manserew.” Nanso Onyankopɔn kae se, “Ɛyɛ nokware turodoo sɛ woserewee.” ");
INSERT INTO twi_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mmarima no kraa sɛ wɔrekɔ no, wɔde wɔn ani kyerɛɛ Sodom. Abraham kogyaa wɔn kwan. ");
INSERT INTO twi_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Afei, Awurade kae se, “Ade a mabɔ me tirim sɛ mɛyɛ no memfa nsie Abraham ana? ");
INSERT INTO twi_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ɛyɛ nokware turodoo sɛ Abraham bɛyɛ ɔman kɛse a ɛwɔ tumi. Na ɛnam Abraham so na wobehyira amanaman a ɛwɔ asase so nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Efisɛ mapaw Abraham sɛ ɔbɛkyerɛkyerɛ ne mma ne ne fifo Awurade kwan. Na wɔayɛ ade pa ne ade trenee a ɛsɔ Awurade ani. Sɛnea ɛbɛyɛ a Awurade bɔ a ɔhyɛɛ Abraham no bɛba mu.” ");
INSERT INTO twi_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Afei, Awurade kae se, “Mate nnebɔne a ɛyɛ duru a ɛrekɔ so wɔ Sodom ne Gomora no. ");
INSERT INTO twi_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mɛkɔ hɔ akɔhwɛ sɛ, nea wɔyɛ no yɛ bɔne a ɛyɛ duru sɛnea mate no ana. Sɛ ɛnte saa nso a, mehu.” ");
INSERT INTO twi_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Na mmarima baasa no mu baanu dan wɔn ani kyerɛɛ Sodom. Nanso Abraham de, na ɔda so gyina Awurade anim. ");
INSERT INTO twi_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Na Abraham twiw bɛn Onyankopɔn bisaa no se, “Wobɛsɛe nnipa trenee ne nnipa bɔnefo nyinaa afra ana? ");
INSERT INTO twi_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Na sɛ nnipa trenee aduonum wɔ kurow no mu a, wobɛsɛe kurow no a worenhwɛ saa nnipa trenee aduonum no ho nnyae kurow no sɛe ana? ");
INSERT INTO twi_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ɛmpare wo sɛ wobɛyɛ saa, sɛ wubekum nnipa trenee ne nnipa bɔnefo afra, de asotwe koro no ara bɛma nnipa trenee ne nnipa bɔnefo. Ɛmpare wo! Nea obu asase nyinaa atɛn no remmu atɛntrenee ana?” ");
INSERT INTO twi_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Na Awurade kae se, “Sɛ mihu nnipa trenee aduonum wɔ Sodom kurow no mu a, wɔn nti merensɛe kurow no.” ");
INSERT INTO twi_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Na Abraham bisae se, “Afei, me a meyɛ nsõ ne dɔte a mensɛ hwee, nanso masi me bo ne Awurade akasa yi, ");
INSERT INTO twi_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","sɛ ɛba sɛ nnipa trenee no dodow yɛ aduanan anum nso ɛ? Esiane saa nnipa anum a wɔafi nnipa trenee aduonum no so ama aka nnipa trenee aduanan anum no nti, wobɛsɛe kurow mu no nyinaa ana?” Onyankopɔn buae se, “Sɛ mihu nnipa trenee aduanan anum wɔ kurow no mu a, merensɛe no.” ");
INSERT INTO twi_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham toaa nʼadebisa no so se, “Sɛ ɛba sɛ, nnipa trenee aduanan pɛ na wɔwɔ kurow no mu ɛ?” Na Awurade buaa Abraham se, “Nnipa trenee aduanan no nti, merensɛe kurow no.” ");
INSERT INTO twi_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham kɔɔ so srɛɛ bio se, “Mesrɛ wo, Awurade, mma wo bo mfuw me, ma menkasa. Sɛ ɛba sɛ nnipa trenee aduasa na wɔwɔ kurow no mu nso ɛ?” Awurade buae se, “Sɛ mihu nnipa trenee aduasa a, merensɛe kurow no.” ");
INSERT INTO twi_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Afei, Abraham bisae se, “Masi me bo ne Awurade akasa yi, ɛba sɛ nnipa trenee aduonu pɛ na wɔwɔ kurow no mu ɛ?” Onyankopɔn buae se, “Saa nnipa trenee aduonu no nti, merensɛe kurow no.” ");
INSERT INTO twi_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham kɔɔ so bisae se, “Awurade, mma wo bo mfuw me; ma mimmisa mʼasɛm baako pɛ a etwa to. Sɛ ɛba sɛ, nnipa trenee du na wɔwɔ kurow no mu nso ɛ?” Awurade buae se, “Saa nnipa trenee du no nti, merensɛe kurow no.” ");
INSERT INTO twi_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Bere a Awurade ne Abraham kasa wiee no, ogyaw Abraham hɔ kɔe. Abraham nso san kɔɔ nʼatenae. ");
INSERT INTO twi_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ɔsoro abɔfo baanu no duu Sodom anwummere. Na Lot te kurow no pon ano. Bere a Lot huu sɛ wɔreba no, ɔsɔre kohyiaa wɔn kwan. Obuu nkotodwe, de nʼanim butuw fam, nam so maa wɔn akwaaba. ");
INSERT INTO twi_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ɔkae se, “Me wuranom, mesrɛ mo, mommɛsoɛ mo akoa fi na memma mo nsu nhohoro mo anan ho, na monna, na ɔkyena anɔpatutuutu, moatoa mo akwantu no so.” Nanso abɔfo no buae se, “Dabi, mmom, yɛbɛda aguabɔbea.” ");
INSERT INTO twi_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Nanso Lot kɔɔ so srɛɛ wɔn anibere so nti, wɔne no kɔɔ ne fi. Ɔtoo brodo a wamfa mmɔkaw amfra da no ara, de too wɔn pon ma wodii. ");
INSERT INTO twi_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ansa na wɔbɛkɔ akɔda no, Sodomfo mpanyin ne mmofra nyinaa fi kurow no afanan betwaa ofi no ho hyiae. ");
INSERT INTO twi_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Wɔteɛteɛɛ mu frɛɛ Lot bisaa no se, “Mmarima a wɔbaa wo nkyɛn anadwo yi wɔ he? Fa wɔn brɛ yɛn, na yɛne wɔn nkɔda.” ");
INSERT INTO twi_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot fii adi, too ne pon mu, kohyiaa Sodom mmarima no. ");
INSERT INTO twi_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ɔka kyerɛɛ wɔn se, “Me nuanom, mesrɛ mo, munni amumɔyɛsɛm a ɛte saa. ");
INSERT INTO twi_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Muntie! Mewɔ mmabea baanu a wonhuu mmarima da. Momma memfa wɔn mmrɛ mo, na nea mopɛ biara, moayɛ wɔn. Na saa mmarima baanu yi de, mommfa mo nsa nka wɔn, efisɛ wɔaba me suhyɛ bammɔ mu.” ");
INSERT INTO twi_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Dɔm no teɛteɛɛ mu se, “Twe wo ho! Woyɛ hena? Yɛn na yɛama wo baabi atena wɔ ha, na afei de worebɛkyerɛ yɛn nea yɛnyɛ. Yɛne wo bedi no anibere so asen nkurɔfo no.” Dɔm no twiw faa Lot so, na wofii ase bubuu apon no. ");
INSERT INTO twi_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Nanso ɔsoro abɔfo baanu a wɔhyɛ fie hɔ no pue bɛtwee Lot kɔhyɛɛ fie hɔ, too pon no mu. ");
INSERT INTO twi_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ɔsoro abɔfo baanu no maa mpanyin ne mmofra a wogyinagyina ɔpon no akyi no ani furafurae, enti wɔanhu ɔpon no koraa. ");
INSERT INTO twi_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mmarima baanu no bisaa Lot se, “Wowɔ abusuafo bi wɔ kurom ha sɛ ɛyɛ wo nsenom, wo mmabea, wo mmabarima anaa obi foforo bi a ɔyɛ wo ho nipa? Yi wɔn nyinaa fi ha, ");
INSERT INTO twi_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","efisɛ yɛrebɛsɛe saa kurow yi pasaa. Amumɔyɛsɛm a etia nnipa yi a adu Awurade anim no ano den nti, wasoma yɛn sɛ yɛmmɛsɛe kurow yi.” ");
INSERT INTO twi_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Enti Lot fii adi kɔbɔɔ mmarima bi a wɔahyɛ bɔ sɛ wɔbɛwareware ne mmabea no amanneɛ. Ɔka kyerɛɛ wɔn se, “Monyɛ no ntɛm, na mumfi kurow yi mu, efisɛ Awurade Nyankopɔn rebɛsɛe kurow yi!” Nanso na saa mmarima yi susuw sɛ ɔredi fɛw bi. ");
INSERT INTO twi_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Anɔpahema no, ɔsoro abɔfo no hyɛɛ Lot se, “Ntɛm! Ka wo ho, na fa wo yere ne wo mmabea baanu a wɔwɔ ha no fi ha kɔ; anyɛ saa a, wɔde mo bɛfra kurow no, asɛe mo.” ");
INSERT INTO twi_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ɔtwentwɛn ne anan ase no, ɔsoro abɔfo no susoo Lot ne yere ne ne mmabea baanu no nsa, twee wɔn, de wɔn fii kurow no mu asomdwoe mu, efisɛ Awurade huu wɔn mmɔbɔ. ");
INSERT INTO twi_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ɔsoro abɔfo no yii Lot mmabea baanu no fii kurow no mu ara pɛ, abɔfo no mu baako kae se, “Munguan nnye mo kra nkwa; monnhwɛ mo akyi. Munnnyina baabiara. Munguan nkɔ mmepɔw no so, anyɛ saa a mubewuwu!” ");
INSERT INTO twi_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Nanso Lot ka kyerɛɛ wɔn se, “Dabi me wuranom! ");
INSERT INTO twi_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mo akoa anya mo anim adom, na moayɛ me adɔe kɛse de agye me nkwa. Nanso me de, merentumi nguan nkɔ mmepɔw no so, efisɛ misuro sɛ anhwɛ a, saa amanehunu yi bɛto me, ama mawu. ");
INSERT INTO twi_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Hwɛ, kurow ketewa bi bɛn ha. Mesrɛ mo, momma minkohintaw hɔ mmom, na manhwere me nkwa. Kurow no nsua ana?” ");
INSERT INTO twi_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ɔsoro abɔfo no ka kyerɛɛ Lot se, “Eye, Mɛpene wʼabisade yi so; merensɛe saa kurow ketewa no. ");
INSERT INTO twi_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ɛno de, guan kɔ hɔ ntɛm, efisɛ sɛ wunnuu hɔ a, merenyɛ biribiara.” Efi saa bere no na wɔfrɛɛ kurow no Soar a ase ne kurow ketewa. ");
INSERT INTO twi_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Bere a Lot duu Soar no, na owia apue. ");
INSERT INTO twi_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Afei, Awurade maa sufre ne ogya tɔ fii soro, guu Sodom ne Gomora so. ");
INSERT INTO twi_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Saa ɔkwan yi so na wɔfa de sɛee saa nkuropɔn abien ne asasetam no nyinaa. Nnipa a na wɔtete saa nkuropɔn no so ne asase no so afifide nso nyinaa sɛee. ");
INSERT INTO twi_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nanso Lot yere twaa nʼani hwɛɛ nʼakyi ma ɔdan nkyene siw. ");
INSERT INTO twi_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ade kyee anɔpatutuutu no, Abraham kɔɔ baabi a ogyinaa Awurade anim no. ");
INSERT INTO twi_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ɔmaa nʼani so hwɛɛ Sodom ne Gomora fam ne asasetam no so nyinaa, huu wusiw kumɔnn a abua asase no so te sɛ wusiw a efi fononoo mu. ");
INSERT INTO twi_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Bere a Onyankopɔn sɛee nkurow a ɛwɔ asase tamaa no so no, Onyankopɔn kaee Abraham, na oyii Lot fii ɔsɛe a ɛbaa nkurow a na Lot te so no mu no. ");
INSERT INTO twi_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot ne ne mmabea baanu no tu fii Soar kɔtenaa ɔbodan bi a na ɛwɔ mmepɔw no so no mu, efisɛ na osuro sɛ ɔbɛtena Soar. ");
INSERT INTO twi_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Da koro bi, ɔbabea panyin no ka kyerɛɛ akumaa no se, “Yɛn agya abɔ akwakoraa, na ɔbarima biara nso nni ha a ɔne yɛn bɛda, sɛnea wɔyɛ wɔ wiase baabiara no. ");
INSERT INTO twi_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ne saa nti, ma yɛmma yɛn agya nsa nnom, na afei yɛne no nna, sɛnea ɛbɛyɛ a yɛnam ne so bɛma yɛn ase afɛe.” ");
INSERT INTO twi_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Saa anadwo no, wɔmaa wɔn agya nsa nomee. Na ɔbabea panyin no ne no kɔdae. Lot anhu bere ko a ne babea panyin no de bɛdaa hɔ ne bere ko a ɔsɔre kɔe. ");
INSERT INTO twi_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ade kyee no, ɔbabea panyin no ka kyerɛɛ akumaa no se, “Nnɛra anadwo, me ne mʼagya dae. Saa anadwo yi, ma yɛnsan mma no nsa nnom, na wo nso, wo ne no nkɔda, sɛnea ɛbɛyɛ a yɛnam yɛn agya so bɛma yɛn ase afɛe.” ");
INSERT INTO twi_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Saa anadwo no nso, wɔmaa wɔn agya nsa nomee. Na akumaa no nso ne nʼagya kɔdae. Bio, Lot anhu bere ko a akumaa no de bɛdaa hɔ ne bere ko a ɔsɔre kɔe. ");
INSERT INTO twi_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Enti Lot ne ne mmabea baanu no nyinsɛnee. ");
INSERT INTO twi_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ne babea panyin no woo ɔbabarima, na ɔtoo no din Moab. Ɔno na ɔyɛ Moabfo agya de besi nnɛ. ");
INSERT INTO twi_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Akumaa no nso woo ɔbabarima, na ɔtoo no din Ben-Ami; ɔno nso ne Amon mma agya de besi nnɛ. ");
INSERT INTO twi_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Afei, Abraham tu fii hɔ kɔɔ anafo mantam asase bi a wɔfrɛ no Negeb kɔtenaa nkurow Kades ne Sur ntam. Ɔtenaa Gerar kakra. ");
INSERT INTO twi_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham maa nnipa no tee ase sɛ, Sara yɛ ne nuabea. Enti, Gerarhene Abimelek soma kɔfaa Sara baa nʼahemfi. ");
INSERT INTO twi_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Nanso Onyankopɔn soo Abimelek dae, ka kyerɛɛ no se, “Wosɛ owu, efisɛ ɔbea a woakɔfa no no yɛ obi yere.” ");
INSERT INTO twi_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Nanso na Abimelek nnya ne Sara nnae, enti ɔkae se, “Awurade, enti wobɛsɛe onipa a ɔnyɛɛ bɔne bi? ");
INSERT INTO twi_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham ka kyerɛɛ me se, ‘Ɔyɛ me nuabea.’ Na Sara no nso kae se, ‘Ɔyɛ me nuabarima.’ Enti mede adwene mu fann ne koma mu tew na ɛyɛɛ nea meyɛe no.” ");
INSERT INTO twi_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Na Onyankopɔn soo Abimelek dae bio ka kyerɛɛ no se, “Ɛyɛ nokware turodoo sɛ, wode adwene mu fann ne koma mu tew na ɛyɛɛ nea woyɛe no; ɛno nti, mamma woanyɛ bɔne antia me. Ɛno nti na mamma woamfa wo ho anka no no. ");
INSERT INTO twi_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ne saa nti san fa ɔbarima no yere no kɔma no, efisɛ saa ɔbarima no yɛ odiyifo a obetumi abɔ mpae ama wo ama woatena. Na sɛ woansan amfa no ankɔma no a, hu sɛ, wo ne wʼasefo nyinaa bewuwu.” ");
INSERT INTO twi_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ade kyee anɔpatutuutu no, Abimelek frɛɛ ne mpanyimfo nyinaa bɔɔ wɔn nsɛm a asisi no ho amanneɛ. Na wosuroo yiye. ");
INSERT INTO twi_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Afei, Abimelek frɛɛ Abraham ka kyerɛɛ no se, “Dɛn na woayɛ yɛn yi? Bɔne bɛn na mayɛ wo a woakɔfa afɔbusɛm kɛse a ɛte sɛɛ yi abɛto me ne me man so yi? Ade a wode ayɛ me yi nyɛ ade a anka ɛsɛ sɛ wode yɛ me.” ");
INSERT INTO twi_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Afei, Abimelek bisaa Abraham se, “Dɛn adwene na ɛkaa wo a ɛma woyɛɛ saa?” ");
INSERT INTO twi_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham buae se, “Misusuwii sɛ nokware, Onyankopɔn biara nni mo mu, na me yere nti, mubekum me. ");
INSERT INTO twi_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Eyi akyi no, ampa ara, ɔyɛ me nuabea. Yefi agya koro na yemfi ɛna koro. Ɛno nti na mewaree no no. ");
INSERT INTO twi_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Na bere a Onyankopɔn ka kyerɛɛ me Abraham se mintu mfi mʼagya fi nkɔ asase a ɔbɛkyerɛ me so no. Me nso, meka kyerɛɛ Sara se, ‘Adɔe a ɛsɛ sɛ woyɛ me ni: baabiara a yebedu no, ka se meyɛ wo nuabarima.’ ” ");
INSERT INTO twi_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Enti Abimelek de nguan, anantwi, nkoa ne mfenaa brɛɛ Abraham. Na ɔde ne yere Sara san brɛɛ no. ");
INSERT INTO twi_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek kae se, “Mʼasasetam na ɛda wʼanim yi, ɛso baabiara a wopɛ sɛ wotena no, fa.” ");
INSERT INTO twi_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abimelek ka kyerɛɛ Sara nso se, “Mede dwetɛ kilogram dubaako ne fa rema wo nuabarima no. Eyi ne mpata a mede rema wo wɔ bɔne a wɔde too wo so no, wɔ wɔn a wɔka wo ho no nyinaa anim. Asodi biara nna wo so.” ");
INSERT INTO twi_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Enti Abraham bɔɔ mpae, srɛɛ Onyankopɔn sɛ ɔnsa ɔhene Abimelek, ɔhemmea ne mfenaa a wɔwɔ fie hɔ no yare mma wɔnwo mma. ");
INSERT INTO twi_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Esiane Abraham yere Sara nti, Awurade too Abimelek fifo nyinaa yafunu mu de twee Abimelek aso. ");
INSERT INTO twi_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Afei, Awurade dom Sara sɛnea ɔhyɛɛ no bɔ no. ");
INSERT INTO twi_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara nyinsɛnee, na ɔwoo ɔbabarima maa Abraham wɔ ne nkwakoraabere mu, bere a Awurade hyɛɛ no bɔ no mu pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham too ɔbabarima a Sara woo no maa no no din Isak, a ase ne Serew. ");
INSERT INTO twi_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Bere a Isak dii nnaawɔtwe no, otwaa no twetia, sɛnea Onyankopɔn hyɛɛ no no. ");
INSERT INTO twi_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Wɔwoo Isak maa Abraham no, na wadi mfe ɔha. ");
INSERT INTO twi_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara kae se, “Onyankopɔn ama maserew. Na obiara a ɔbɛte saa asɛm yi ne me bɛbɔ mu aserew.” ");
INSERT INTO twi_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Sara ka kaa ho se, “Hena na ɔsoo ho dae ka kyerɛɛ Abraham se Sara bɛwo mma. Nanso ne nkwakoraabere mu yi, mawo ɔbabarima ama no.” ");
INSERT INTO twi_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Abofra no nyin ma wotwaa no nufu. Da a wotwaa Isak nufu no, Abraham too pon kɛse. ");
INSERT INTO twi_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Nanso Sara hui sɛ, ɔbabarima a nʼafenaa Misraimni Hagar woo no maa Abraham no redi Isak ho fɛw. ");
INSERT INTO twi_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Enti Sara ka kyerɛɛ Abraham se, “Pam saa afenaa yi ne ne babarima yi fi ha; na Isak ne saa afenaa babarima yi nni wʼagyapade biara mu kyɛfa.” ");
INSERT INTO twi_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham tee saa asɛm no, esiane ne babarima Ismael nti, ne werɛ how yiye. ");
INSERT INTO twi_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Nanso Onyankopɔn ka kyerɛɛ Abraham se, “Mma wo babarima Ismael ne wʼafenaa Hagar ho asɛm no nhaw wo bebree. Asɛm biara a Sara bɛka akyerɛ wo no, tie, efisɛ Isak so na wɔnam bɛkan wʼasefo. ");
INSERT INTO twi_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mɛma afenaa no babarima Ismael no nso asefo ayɛ ɔman kɛse, efisɛ ɔno nso yɛ wʼaseni.” ");
INSERT INTO twi_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ade kyee anɔpatutuutu no, Abraham faa aduan ne nsu a egu aboa nhoma mu de maa Hagar. Ɔde aduan no ne nsu no sisii Hagar mmati so, ka kyerɛɛ ɔne ne ba Ismael no se wɔnkɔ. Ofii hɔ kokyinkyin Beer-Seba sare so a na onhu baabi a ɔrekɔ. ");
INSERT INTO twi_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Nsu a ɛwɔ aboa nhoma no mu sae no, ɔde ne babarima no kohintaw wura no mu baabi. ");
INSERT INTO twi_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Na ɔkɔtenaa akyiri baabi a wotow ɔbo a ɛbɛtɔ, kae se, “Merentumi nhwɛ sɛ abarimaa no bewu.” Na bere a Hagar te hɔ saa no, ofii ase sui. ");
INSERT INTO twi_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Onyankopɔn tee sɛ abarimaa no resu. Onyankopɔn bɔfo fi ɔsoro frɛɛ Hagar bisaa no se, “Hagar! Ɛyɛ dɛn? Nsuro, efisɛ Onyankopɔn ate abarimaa no su wɔ faako a ɔda no. ");
INSERT INTO twi_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ma abarimaa no so, efisɛ mɛma no ayɛ ɔman kɛse.” ");
INSERT INTO twi_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Na Onyankopɔn buee Hagar ani ma ohuu asubura bi. Ɔde aboa nhoma no kɔsaw nsu ma, na ɔmaa abarimaa no bi nomee. ");
INSERT INTO twi_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Onyankopɔn adom nti, abarimaa no nyinii. Ɔtenaa sare no so huu agyantow yiye. ");
INSERT INTO twi_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Bere a ɔte Paran sare so no, ne na kɔfaa ɔbea fi Misraim asase so de no brɛɛ no aware. ");
INSERT INTO twi_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Saa bere no mu, ɔhene Abimelek ne ne sahene Pikol baa Abraham nkyɛn bɛka kyerɛɛ no se, “Biribiara a woyɛ no, Onyankopɔn ka wo ho. ");
INSERT INTO twi_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Enti afei, di nsew ka ntam wɔ Onyankopɔn anim kyerɛ me wɔ ha se, worentwa me mma anaa mʼasefo nkontompo. Saa ayamye a mayɛ wo no, saa ara na fa yɛ me ne ɔman a wote so sɛ ɔnanani no.” ");
INSERT INTO twi_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham penee so se, “Meka saa ntam no!” ");
INSERT INTO twi_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Na Abraham de asubura bi a Abimelek nkoa de anuɔden afa no ho asɛm kɔtoo Abimelek anim. ");
INSERT INTO twi_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Nanso Abimelek kae se, “Minnim onipa ko a ɔyɛɛ saa ade no. Woammɔ me ho amanneɛ. Nnɛ na mate saa asɛm yi.” ");
INSERT INTO twi_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Enti Abraham de nguan ne anantwi brɛɛ Abimelek. Na mmarima baanu yi de yɛɛ apam. ");
INSERT INTO twi_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham yii nguantenmma abere ason fii nguankuw no mu gyinaa nkyɛn, ");
INSERT INTO twi_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","na Abimelek bisaa Abraham se, “Nguantenmma abere ason a woayi wɔn agyina nkyɛn yi ase kyerɛ dɛn?” ");
INSERT INTO twi_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham buae se, “Ne nkyerɛase ara ne sɛ, ɛyɛ akyɛde a mede rema wo de adi adanse sɛ, me na mituu saa abura yi.” ");
INSERT INTO twi_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Efi saa bere no rekɔ no, wɔfrɛɛ saa abura no Beer-Seba, a ase ne Ntanka Abura, efisɛ ɛhɔ na wɔn baanu yɛɛ apam no. ");
INSERT INTO twi_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Wɔyɛɛ apam no wiee wɔ Beer-Seba no, ɔhene Abimelek ne ne Sahene Pikol san kɔɔ Filistifo asase so. ");
INSERT INTO twi_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham nso duaa dua bi a wɔfrɛ no asantɛw wɔ abura no ho wɔ Beer-Seba. Ɛhɔ na na ɔsom Awurade teasefo no daa. ");
INSERT INTO twi_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham tenaa Filistifo asase no so sɛ ɔnanani nna bebree. ");
INSERT INTO twi_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nna bi akyi no, Onyankopɔn sɔɔ Abraham hwɛe. Ɔfrɛɛ Abraham se, “Abraham!” Abraham buae se, “Me ni!” ");
INSERT INTO twi_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Onyankopɔn ka kyerɛɛ no se, “Fa wo ba, wo ba koro Isak a wodɔ no no kɔ Moria asase so, na fa no kɔbɔ ɔhyew afɔre wɔ mmepɔw a ɛwɔ hɔ no mu baako a mɛkyerɛ wo no so.” ");
INSERT INTO twi_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham sɔree anɔpatutuutu hyehyɛɛ nʼafurum. Ɔfaa ne nkoa no mu baanu ne ne ba Isak kaa ne ho. Otwitwaa ogya a ɛbɛso ɔhyew afɔre no bɔ no, osii mu kɔɔ faako a Onyankopɔn kyerɛɛ no sɛ ɔnkɔ no. ");
INSERT INTO twi_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ne nnansa so no, Abraham too nʼani huu sɛ baabi a ɔrekɔ no wɔ akyirikyiri. ");
INSERT INTO twi_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Na Abraham ka kyerɛɛ ne nkoa no se, “Mo ne afurum no ntwɛn wɔ ha, na me ne abarimaa no nkɔ anim kakra nkɔsom. Sɛ yɛsom wie a, yɛbɛsan aba.” ");
INSERT INTO twi_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham faa nnyina a wɔde rekɔbɔ ɔhyew afɔre no de soaa ne ba Isak. Na ɔno nso faa ogya ne sekan kurae. Bere a wɔrekɔ no, ");
INSERT INTO twi_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isak frɛɛ nʼagya Abraham se, “Agya!” Na Abraham buae se, “Me ba, asɛm bɛn?” Isak bisaa no se, “Ogya ne nnyina no ni, na oguamma a yɛde no rekɔbɔ ɔhyew afɔre no wɔ he?” ");
INSERT INTO twi_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham buae se, “Onyankopɔn no ankasa bɛma yɛn afɔre guan no a yɛde rekɔbɔ ɔhyew afɔre no.” Na wɔn baanu no toaa so kɔe. ");
INSERT INTO twi_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Wokoduu faako a Onyankopɔn kyerɛɛ no no, Abraham sii afɔremuka wɔ hɔ, hyehyɛɛ nnyina no wɔ so. Ɔkyekyeree ne ba Isak, de no too nnyina no so wɔ afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham twee sekan no, maa so sɛ ɔde rebetwa ne ba no mene akum no. ");
INSERT INTO twi_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ɛhɔ ara na Awurade bɔfo frɛɛ no fi ɔsoro se, “Abraham! Abraham!” Na Abraham gyee so se, “Me ni.” ");
INSERT INTO twi_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Awurade bɔfo no kae se, “Mfa wo nsa nka abofra no. Nyɛ no bɔne biara. Esiane sɛ woamfa wo dɔba, wo ba koro no ankame me no nti, mahu sɛ wusuro Onyankopɔn.” ");
INSERT INTO twi_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham maa nʼani so huu sɛ nkyɛkyerɛ bi aso Odwennini bi mmɛn mu wɔ wura no mu hɔ. Abraham kɔkyeree Odwennini no de no bɔɔ ɔhyew afɔre wɔ afɔremuka no so sii ne ba no anan mu. ");
INSERT INTO twi_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham too beae no din se Awurade De Bɛma. Ebesi nnɛ no wɔka se, “Wɔde bɛma wɔ Awurade bepɔw no so.” ");
INSERT INTO twi_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Awurade bɔfo no frɛɛ Abraham fii ɔsoro nea ɛto so abien kae se, ");
INSERT INTO twi_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Maka me ho ntam se, esiane sɛ woayɛ eyi, na woamfa wo ba, wo ba koro no ankame me nti, ");
INSERT INTO twi_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","hyira na mehyira wo na mama wʼase adɔ sɛ ɔsoro nsoromma ne mpoano nwea. Na wʼasefo begye wɔn atamfo nkuropɔn adi so. ");
INSERT INTO twi_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Wɔnam wʼasefo so na wobehyira wiase amanaman nyinaa, efisɛ woadi mʼasɛm so.” ");
INSERT INTO twi_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Na Abraham san kɔɔ nʼasomfo no nkyɛn ne wɔn sii mu kɔɔ Beer-Seba kɔtenaa hɔ. ");
INSERT INTO twi_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nna bi akyi no, wɔka kyerɛɛ Abraham se, “Milka nso yɛ ɔbeatan a wawo mmabarima ama wo nuabarima Nahor: ");
INSERT INTO twi_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us yɛ abakan, Us nuabarima a odi so ne Bus. Kemuel a ɔto so abiɛsa na ɔwoo Aram. ");
INSERT INTO twi_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Wɔn a wɔaka no ne Kesed, Haso, Pildas, Yidlaf ne Betuel.” ");
INSERT INTO twi_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel bɛyɛɛ Rebeka nʼagya. Milka ne Abraham nua Nahor na wɔwowoo saa mmabarima baawɔtwe yi. ");
INSERT INTO twi_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor ne ne mpena Rehuma nso woo mma baanan a wɔn din de, Teba, Gaham, Tahas ne Maaka. ");
INSERT INTO twi_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara dii mfe ɔha aduonu ason. ");
INSERT INTO twi_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Owui wɔ Kiriat-Arba a ɛno ara ne Hebron a ɛwɔ Kanaan asase so. Abraham kogyam ne yere Sara, suu no wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abraham gyaw ne yere Sara amu no wɔ hɔ, kɔɔ Hetifo mpanyimfo nkyɛn, kɔsrɛɛ wɔn se, ");
INSERT INTO twi_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Meyɛ ɔhɔho ne mamfrani a mete mo mu. Mesrɛ mo, montɔn mo asase yi bi mma me, na minsie me yere wɔ so.” ");
INSERT INTO twi_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hetifo no buaa Abraham se, ");
INSERT INTO twi_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Owura, yɛsrɛ wo, tie asɛm a yɛrebɛka yi. Woyɛ Onyankopɔn somfo kɛse wɔ yɛn mu. Yɛn boda biara a ɛsɔ wʼani a wopɛ sɛ wusie wo yere wɔ hɔ no, yɛma wo ho kwan, kosie no. Yɛn mu biara remfa ne boda nkame wo.” ");
INSERT INTO twi_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ɛhɔ ara na Abraham sɔre bɔɔ ne mu ase wɔ Hetifo no anim, ");
INSERT INTO twi_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ka kyerɛɛ wɔn se, “Sɛ moapene so sɛ minsie mʼamu no wɔ ha de a, mepa mo kyɛw, monsrɛ Efron a ɔyɛ Sohar babarima no mma me, ");
INSERT INTO twi_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","na ɔntɔn Makpela ɔboda a ɛwɔ nʼafuw ano no mma me. Monka nkyerɛ no na ɔntɔn no sɛnea ne bo di pɛpɛɛpɛ mma me, na mede hɔ ayɛ me ne mʼabusuafo amusiei.” ");
INSERT INTO twi_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Saa bere no na Hetini Efron a ɔte ne manfo mu no buaa Abraham, maa ne nkurɔfo a wɔahyia wɔ kurow no pon ano nyinaa tee sɛ, ");
INSERT INTO twi_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Dabi, me wura, tie me! Mede afuw no ne ɔboda a ɛwɔ mu no kyɛ wo. Migyina me manfo anim, na mede kyɛ wo. Kosie wʼamu no wɔ hɔ.” ");
INSERT INTO twi_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Bio Abraham de obu ne nidi bɔɔ ne mu ase wɔ ɔmanfo no anim, ");
INSERT INTO twi_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ka kyerɛɛ Efron maa wɔn a wɔahyia hɔ no nyinaa tee asɛm a ɔkae no se, “Mesrɛ mo, ɔmanfo, monyɛ aso mma me. Momma mintua asase no ka. Mompene so mma me, na minnya kwan nkosie mʼamu no.” ");
INSERT INTO twi_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron buaa Abraham se, ");
INSERT INTO twi_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Me wura, tie me! Asase no bo yɛ dwetɛ kilogram anan ne fa. Yɛnyɛ nnipa baako ana? Meregye saa sika yi ayɛ dɛn? Kosie wʼamu no!” ");
INSERT INTO twi_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham penee Efron asɛm no so. Ɔkarii dwetɛ kilogram anan ne fa a ɛyɛ asase no bo a ɔbɔ maa Hetifo no tee no de tuaa ka. ");
INSERT INTO twi_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Enti wɔde Efron asase a ɛwɔ Makpela a ɛbɛn Mamrɛ, a ɛyɛ afuw no, ɔboda a ɛwɔ mu no, nnua a ɛwɔ afuw no mu ne nʼahye so nyinaa maa ");
INSERT INTO twi_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abraham sɛ nʼagyapade. Eyi nyinaa sii wɔ Hetifo no ne wɔn a wɔbaa kurow no pon no ano nyinaa anim. ");
INSERT INTO twi_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Akyiri no, Abraham siee ne yere Sara wɔ ɔboda a ɛwɔ Makpela afuw a ɛbɛn Mamrɛ a ɛno ara ne Hebron a ɛwɔ Kanaan asase so no mu. ");
INSERT INTO twi_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Enti Hetifo no yɛɛ nhyehyɛe de afuw no ne ɔboda a ɛwɔ mu no maa Abraham sɛ nʼagyapade ne nʼamusiei. ");
INSERT INTO twi_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Na Abraham anyin a ne mfe akɔ anim yiye. Awurade hyiraa no wɔ akwan ahorow nyinaa so. ");
INSERT INTO twi_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Da koro bi, Abraham ka kyerɛɛ ne somfo panyin a ɔhwɛ nʼagyapade nyinaa so no se, “Fa wo nsa ka me srɛ ase. ");
INSERT INTO twi_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Mepɛ sɛ woka Awurade a ɔyɛ ɔsoro ne asase Nyankopɔn ntam sɛ, worenware Kanaanfo a me ne wɔn te yi babea biara mma me babarima Isak. ");
INSERT INTO twi_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Na mmom, wobɛkɔ me man mu, mʼabusuafo nkyɛn, akɔware ɔbea abrɛ no.” ");
INSERT INTO twi_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ɔsomfo no bisaa Abraham se, “Me wura, na sɛ ɛba sɛ ɔbea no ampene so sɛ ɔne me bɛba ɔman yi mu a, na mereyɛ no dɛn? Memfa wo babarima no nkɔ wo man no mu ana?” ");
INSERT INTO twi_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham kae se, “Hwɛ yiye na woamfa me babarima no ankɔ hɔ da. ");
INSERT INTO twi_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Awurade, ɔsoro Nyankopɔn a ɔde me fi mʼagya fi ne mʼasase so baa ha na ɔkaa ntam hyɛɛ me bɔ se, ‘Mede saa asase yi bɛma wʼasefo no,’ ɔno ara na ɔbɛsoma ne bɔfo adi wʼanim akɔ, sɛnea ɛbɛyɛ a wubenya ɔyere afi hɔ ama me babarima no. ");
INSERT INTO twi_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Sɛ ɛba sɛ, ɔbea no ampene sɛ ɔne wo bɛba a, wo ntam a wokae no nkyekyere wo. Ɛnsɛ sɛ wode me babarima no kɔ hɔ.” ");
INSERT INTO twi_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Enti, ɔsomfo no de ne nsa kaa ne wura Abraham srɛ ase, kaa saa asɛm yi ho ntam. ");
INSERT INTO twi_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Na, ɔsomfo no faa ne wura yoma no mu du kɔe. Ɔrebɛkɔ no, ogyee ne wura Abraham nkyɛn nnepa ahorow bebree kaa ho. Ɔde nʼani kyerɛɛ Mesopotamia, koduu Nahor kurow mu. ");
INSERT INTO twi_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Oduu Nahor kurotia no, ɔmaa yoma no butubutuw abura bi a ɛwɔ hɔ no ho. Na onwini adwo a ɛyɛ bere a mmea bɛtow nsu wɔ abura no mu. ");
INSERT INTO twi_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Na ɔsomfo no bɔɔ mpae se, “Awurade, me wura Abraham Nyankopɔn, hu me wura Abraham mmɔbɔ, na boa me, na mʼakwantu yi nsi yiye. ");
INSERT INTO twi_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Hwɛ, migyina abura yi so, na kurow yi mu mmabaa rebɛtow nsu. ");
INSERT INTO twi_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ma ɛmmra mu sɛ, ababaa biara a mɛka akyerɛ no se, ‘Mesrɛ wo, soɛ na ma me wo sukuruwa no mu nsu no bi nnom no,’ sɛ ɔka se, ‘Nom bi, na mɛma wo yoma no nso bi anom’ a, ɔnyɛ ababaa a woapaw no ama wʼakoa Isak. Ɛnam eyi so bɛma mahu sɛ, woahu me wura mmɔbɔ.” ");
INSERT INTO twi_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ogu so rebɔ mpae no na Rebeka bae a ne sukuruwa si ne bati so. Saa Rebeka no yɛ Betuel ba. Betuel no nso yɛ Abraham nuabarima Nahor ne ne yere Milka babarima. ");
INSERT INTO twi_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Na Rebeka no yɛ ɔbabun a ne ho yɛ fɛ yiye. Na ɔbarima biara mfaa ne ho nkaa no da. Osian kɔɔ abura no so, kɔhyɛɛ ne sukuruwa no nsu ma, san bae. ");
INSERT INTO twi_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ɔsomfo no de ahoɔhare kohyiaa Rebeka, ka kyerɛɛ no se, “Mesrɛ wo, hwie wo sukuruwa no mu nsu no kakra ma mennom.” ");
INSERT INTO twi_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ntɛm ara, ɔsoɛɛ ne sukuruwa no kae se, “Me wura, gye bi nom.” ");
INSERT INTO twi_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Rebeka maa ɔsomfo no nsu no bi nom wiee no, ɔkae se, “Mɛsan akɔsaw nsu no bi abrɛ wo yoma no nyinaa nso anom.” ");
INSERT INTO twi_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Enti Rebeka de ahoɔhare hwiee ne nsu no guu anomee bi mu, san kɔsaw nsu a ɛbɛso yoma no nyinaa nom de bae. ");
INSERT INTO twi_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ɔsomfo no hwɛɛ Rebeka komm, karii no pɛɛ sɛ ohu sɛ Awurade ama nʼakwantu no asi no yiye ana. ");
INSERT INTO twi_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Yoma no nom nsu no wiee no, ɔsomfo no yii sikakɔkɔɔ hwenemkaa a emu duru kari gram asia ne nkapo abien a ɛno nso mu duru yɛ gram ɔha dunan. ");
INSERT INTO twi_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Na obisae se, “Hena ba ne wo? Mesrɛ wo, yebenya nnabea wɔ wʼagya fi ama ade akye ana?” ");
INSERT INTO twi_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebeka buaa no se, “Betuel babea ne me. Me nananom ne Milka ne Nahor.” ");
INSERT INTO twi_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ɔka kaa ho se, “Yɛwɔ sare ne mmoa aduan bebree ne baabi a mo nso mobɛda.” ");
INSERT INTO twi_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Na ɔsomfo no buu nkotodwe, sɔree Awurade Nyankopɔn se, ");
INSERT INTO twi_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Nhyira nka Awurade, me wura Abraham Nyankopɔn, sɛ onnyaee nokwaredi ne ayamye a ɔyɛ ma me wura no. Me de, Awurade adi mʼanim wɔ mʼakwantu yi mu, de me abedu me wura abusuafo fi.” ");
INSERT INTO twi_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebeka tuu mmirika kɔkaa nsɛm a asisi no nyinaa kyerɛɛ ne na fifo. ");
INSERT INTO twi_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Na Rebeka wɔ nuabarima bi a ne din de Laban. Laban tee asɛm no, ɔde ahoɔhare kɔɔ ɔbarima no nkyɛn wɔ abura no so. ");
INSERT INTO twi_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Laban huu hwenemkaa no ne nkapo a egu ne nuabea no nsa no, na ɔtee asɛm a ɔbarima no ka kyerɛɛ Rebeka no, ɔkɔɔ ɔbarima no nkyɛn kohuu sɛ ogyina yoma no ho wɔ asubura no so. ");
INSERT INTO twi_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban ka kyerɛɛ ɔsomfo no se, “Bra, wo a Awurade ahyira wo.” Obisaa ɔsomfo no se, “Adɛn nti na wugyina kurotia ha? Masiesie wo nnabea ne baabi a yoma no nso bɛda.” ");
INSERT INTO twi_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Enti ɔsomfo no kɔɔ fie hɔ maa Laban yiyii nneɛma a ɛwɔ yoma no so no. Wɔmaa yoma no sare ne aduan, afei Laban maa ɔsomfo no ne nnipa a wɔka ne ho no nsu de hohoroo wɔn anan ho. ");
INSERT INTO twi_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Eyi akyi no, ɔtoo wɔn pon. Nanso ɔsomfo no kae se, “Merempɛ sɛ medidi, gye sɛ mabɔ mʼamanneɛ.” Laban kae se, “Bɔ wʼamanneɛ ɛ.” ");
INSERT INTO twi_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Enti ɔsomfo no bɔɔ nʼamanneɛ se, “Meyɛ Abraham somfo. ");
INSERT INTO twi_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Awurade ahyira me wura bebree, ama wayɛ ɔdefo. Wama no nguan ne anantwi, dwetɛ ne sikakɔkɔɔ, nkoa ne mfenaa ne yoma ne mfurum. ");
INSERT INTO twi_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Bio, me wura yere Sara awo ɔbabarima ama no wɔ ne mmerewabere mu; Awurade na ɔde nea ɔwɔ nyinaa ama no. ");
INSERT INTO twi_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Me wura ma mekaa ntam se, ‘Worenware Kanaanfo a me ne wɔn te yi babea biara mma me babarima Isak. ");
INSERT INTO twi_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Na mmom, wobɛkɔ me man mu, mʼabusuafo nkyɛn, akɔware ɔbea wɔ hɔ abrɛ me babarima Isak.’ ");
INSERT INTO twi_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Na mibisaa me wura se, ‘Na sɛ ɛba sɛ, ɔbea no ampene so sɛ ɔne me bɛba ɔman yi mu a, na mereyɛ no dɛn?’ ");
INSERT INTO twi_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Me wura Abraham buae se, ‘Awurade a manantew nʼanim no bɛsoma ne bɔfo, adi wʼanim, sɛnea ɛbɛyɛ a, wʼakwantu no besi yiye, na woanya ɔyere ama me babarima afi mʼabusua mu a ɛyɛ mʼagya fi no mu. ");
INSERT INTO twi_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Afei, sɛ ɛba sɛ, woba mʼabusua mu, na sɛ wɔamfa ɔbea no amma wo a, wo ntam a wokae no renkyekyere wo.’ ");
INSERT INTO twi_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Mebaa asubura no so nnɛ no, mesrɛe sɛ, ‘Awurade, me wura Abraham Nyankopɔn, sɛ ɛyɛ wo pɛ a, ma akwantu yi nsi me yiye! ");
INSERT INTO twi_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Hwɛ, migyina abura yi so. Sɛ ababaa bi bɛtow nsu wɔ ha, na meka kyerɛ no se, “Mesrɛ wo, soɛ na ma me wo sukuruwa no mu nsu no kakra nnom” no, ");
INSERT INTO twi_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","na sɛ ɔka se, “Nom bi, na mɛma wo yoma no nso bi anom” a, ɔnyɛ ababaa a Awurade apaw no ama me wura Abraham babarima Isak no.’ ");
INSERT INTO twi_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ansa na mewie me koma mu mpaebɔ no, Rebeka puee a sukuruwa si ne bati so. Rebeka kɔɔ abura no so, kɔtow nsu, na meka kyerɛɛ no se, ‘Mesrɛ wo, ma me nsu no bi nnom.’ ");
INSERT INTO twi_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Ntɛm ara, ɔsoɛɛ ne sukuruwa no kae se, ‘Me wura, gye bi nom na mɛsan asaw nsu no bi abrɛ wo yoma no nyinaa nso anom.’ Enti menom nsu no bi, na ɔmaa yoma no nyinaa nso bi nomee. ");
INSERT INTO twi_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Mibisaa no se, ‘Hena ba ne wo?’ “Rebeka buae se, ‘Betuel ba ne me. Me nenanom ne Milka ne Nahor.’ “Ɛhɔ ara na mede hwenemkaa no hyɛɛ ne hwenem, na mede nkapo no nso guu ne nsa. ");
INSERT INTO twi_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Afei, mebɔɔ me mu ase sɔree Awurade. Mekamfoo Awurade a ɔyɛ me wura, Abraham Nyankopɔn, a wadi mʼanim de me afa ɔkwan pa so, ama manya me wura nuabarima nena aware ama ne babarima no. ");
INSERT INTO twi_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Afei, sɛ wobɛyɛ me wura adɔe adi no nokware a, ka kyerɛ me. Sɛ ɛnte saa nso a, ka kyerɛ me, sɛnea ɛbɛyɛ a, mehu ɔkwan ko a mɛfa so.” ");
INSERT INTO twi_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban ne Betuel buae se, “Saa asɛm yi fi Awurade nti, yenni ho asɛm biara. ");
INSERT INTO twi_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka ni. Momfa no nkɔ, na ɔnkɔware mo wura no babarima no, sɛnea Awurade ahyɛ no.” ");
INSERT INTO twi_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Bere a Abraham somfo no tee nea wɔkae no, obuu nkotodwe wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Na ɔsomfo no yii sikakɔkɔɔ ne dwetɛ nnwinne ne ntade maa Rebeka. Ɔsan de nneɛma a ɛsom bo yiye yɛɛ Rebeka nuabarima ne ne na ayɛ. ");
INSERT INTO twi_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Afei, ɔsomfo no ne nnipa a wɔka ne ho no didi nomee, na wɔda maa ade kyee. Ade kyee anɔpa a wɔsɔree no, ɔsomfo no kae se, “Munnya me kwan, na mensan nkɔ me wura nkyɛn.” ");
INSERT INTO twi_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Nanso Rebeka nuabarima no ne ne na buaa ɔsomfo no se, “Ma ababaa no ntena yɛn nkyɛn bɛyɛ sɛ nnafua du bi, na ɛno akyi, wode no akɔ.” ");
INSERT INTO twi_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Akoa no buaa wɔn se, “Awurade ahyira mʼakwantu yi so ama me yi de, mesrɛ mo, monnnye me nnka ha. Munnya me kwan, na mensan nkɔ me wura nkyɛn.” ");
INSERT INTO twi_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Afei, wosii gyinae sɛ, “Momma yɛmfrɛ ababaa no, na yemmisa nʼadwene.” ");
INSERT INTO twi_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Enti wɔfrɛɛ Rebeka bisaa no se, “Wopɛ sɛ wo ne saa ɔbarima yi kɔ ana?” Rebeka buae se, “Yiw, mɛkɔ!” ");
INSERT INTO twi_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Enti wogyaa Rebeka ne ɔbea a ogyigyee no ne mmofraase no ne Abraham somfo no ne ne nkurɔfo kwan. ");
INSERT INTO twi_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Wohyiraa Rebeka se, “Onuabea, Awurade nka wo ho, na wʼase nnɔ mpempem! Awurade mma wʼasefo no nni wɔn atamfo nyinaa so nkonim.” ");
INSERT INTO twi_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Na Rebeka ne ne mmaawa siesiee wɔn ho, tenatenaa wɔn yoma so ne Abraham somfo no kɔe. Eyi ne ɔkwan a Abraham somfo no faa so de Rebeka kɔe. ");
INSERT INTO twi_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Saa bere no na Isak a na anka ɔte Negeb no fi hɔ abɛtena Beer-Lahai-Roi. ");
INSERT INTO twi_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Da koro anwummere bi a Isak kotuu mpase wɔ sare so refa adwene no, ɔtoo nʼani huu sɛ yoma sa so reba. ");
INSERT INTO twi_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka nso too nʼani, na ohuu Isak. Rebeka si fii ne yoma no so, ");
INSERT INTO twi_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","bisaa Abraham somfo no se, “Ɔbarima bɛn na ɔnam sare yi so rebehyia yɛn yi?” Ɔsomfo no buae se, “Ɔyɛ me wura babarima.” Enti Rebeka yii ne nkataanim de kataa nʼanim. ");
INSERT INTO twi_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Abraham somfo no bɔɔ Isak nsɛm a asisi no nyinaa ho amanneɛ. ");
INSERT INTO twi_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isak de Rebeka kɔɔ ne na Sara ntamadan mu. Na ɔwaree no ma ɔbɛyɛɛ ne yere. Na ɔdɔ no yiye. Eyi maa Isak werɛ kyekyee wɔ ne na Sara wu akyi. ");
INSERT INTO twi_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham waree ɔbea foforo bi a ne din de Ketura. ");
INSERT INTO twi_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Abraham ne Ketura woo saa mma a wɔn din didi so yi: Simran, Yoksan, Medan, Midian, Yisbak ne Sua. ");
INSERT INTO twi_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan woo Seba ne Dedan. Dedan asefo ne Asurfo, Letusfo ne Leumfo. ");
INSERT INTO twi_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian woo Efa, Efer, Henok, Abida ne Eldaa. Eyinom nyinaa yɛ Ketura asefo. ");
INSERT INTO twi_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham de nʼagyapade nyinaa maa Isak. ");
INSERT INTO twi_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Nanso bere a ɔte ase no, ɔmaa ne mpenamma akyɛde, na oyii wɔn fii ne babarima Isak nkyɛn ma wɔkɔɔ apuei fam asase bi so. ");
INSERT INTO twi_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham nkwanna nyinaa kosii mfe ɔha aduɔson anum. ");
INSERT INTO twi_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham nyin bɔɔ akwakoraa posoposo ansa na ɔrewu akɔka ne mpanyimfo ho. ");
INSERT INTO twi_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ne mmabarima Isak ne Ismael siee no wɔ Makpela boda a ɛwɔ Efron no mu. Na ɛhɔ yɛ Hetini Sohar babarima no afuw a ɛwɔ Mamrɛ apuei fam. ");
INSERT INTO twi_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Eyi ne asase a Abraham tɔ fii Hetifo nkyɛn no. Ɛhɔ na wosiee Abraham ne ne yere Sara. ");
INSERT INTO twi_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham wu akyi no, Onyankopɔn hyiraa ne ba Isak a na saa bere no ɔte Beer-Lahai-Roi abura no ho no. ");
INSERT INTO twi_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Eyi ne Abraham babarima Ismael a Sara afenaa Hagar a ɔyɛ Misraimni no woo no maa Abraham no asefo ho asɛm. ");
INSERT INTO twi_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Wɔn a wodidi so yi yɛ Ismael mmabarima a wɔabobɔ wɔn din fi mpanyin mu no. Na Nebaiot yɛ Ismael abakan. Wɔn a wodidi so yi nso yɛ Kedar, Adbeel, Mibsam, ");
INSERT INTO twi_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO twi_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetur, Nafis ne Kedema. ");
INSERT INTO twi_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Saa din a wɔabobɔ yi yɛ Ismael mmabarima no. Saa din yi na ɛdeda mmusuakuw dumien ne wɔn atenae so. ");
INSERT INTO twi_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael dii mfirihyia ɔha aduasa ason ansa na ɔrewu. Owu ma wosiee no wɔ ne nkurɔfo mu. ");
INSERT INTO twi_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismael asefo yi tenatenaa nsase a efi Hawila kosi Sur a ɛbɛn Misraim pɛɛ wɔ Asiria ntentenso. Daa na akokoakoko wɔ mmusuakuw yi ntam. ");
INSERT INTO twi_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham babarima Isak ne nʼasefo ho asɛm ni. Abraham woo Isak. ");
INSERT INTO twi_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isak dii mfirihyia aduanan no, ɔwaree Rebeka a ɔyɛ Aramni Betuel a ofi Paddan-Aram no babea. Rebeka yɛ Aramni Laban nuabea. ");
INSERT INTO twi_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isak waree Rebeka mfe bebree a na wɔnwo. Enti Isak bɔɔ Awurade mpae, srɛɛ ɔba maa ne yere. Akyiri no, Awurade tiee ne mpaebɔ, maa ne yere Rebeka nyinsɛnee. ");
INSERT INTO twi_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Bere a Rebeka nyinsɛnee no, ɛtɔ da a, na mmofra no di aperepere wɔ ne yafunu mu. Sɛ ɛba saa a, obisa ne ho se, “Dɛn na ɛreyɛ me yi?” Afei, ɔbɔɔ mpae bisaa Awurade nea ɛkyerɛ. ");
INSERT INTO twi_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Awurade buaa no se, “Aman abien na wɔwɔ wo yafunu mu. Wɔbɛtetew nnipa baanu a wɔwɔ wo yafunu mu no mu. Mmofra baanu no, ɔbaako asefo bɛyɛ ahoɔdenfo asen ne nua a ɔka ne ho no asefo. Na ɔpanyin no bɛsom akumaa no.” ");
INSERT INTO twi_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rebeka awo duu so no, ɔwoo ntaten. ");
INSERT INTO twi_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Na nea odii kan bae no yɛ ɔkɔkɔɔ a ne ho nwi yɛ kuhaa te sɛ nea ɔhyɛ nwi atade. Enti wɔtoo no din Esau. ");
INSERT INTO twi_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Eyi akyi no, ne nua no bae a na ne nsa kura Esau nantin; enti wɔtoo ne din Yakob. Rebeka woo wɔn no, na Isak adi mfe aduosia. ");
INSERT INTO twi_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Mmofra no nyin no, Esau bɛyɛɛ ɔbɔmmɔfo a ɔtow a, ɔmfom. Na ɔyɛ ha fa wuram baabiara. Yakob nso bɛyɛɛ obi a ɔyɛ komm a ɔmpɛ ne ho asɛm. Na bere biara, ɔpɛ sɛ ɔtena fie. ");
INSERT INTO twi_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Na Isak pɛ Esau asɛm yiye, efisɛ na bere biara ɔkɔyɛ ha de hanam a Isak pɛ ba fie. Nanso na Rebeka de, ɔpɛ Yakob asɛm. ");
INSERT INTO twi_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Da bi a Esau fi wuram bae a na ɔkɔm de no yiye no, ɔbɛtoo sɛ ne nua kumaa Yakob nso renoa aduan bi a ani yɛ kɔkɔɔ na ɛyɛ akɔnnɔ nso. ");
INSERT INTO twi_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ɔka kyerɛɛ Yakob se, “Mesrɛ wo, ma me wʼaduan a woanoa yi bi nni!” Ɛno nti na wɔfrɛ Esau sɛ Edom, a nkyerɛase ne ade kɔkɔɔ. ");
INSERT INTO twi_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakob buae se, “Tɔn wo panyin no ma me ansa.” ");
INSERT INTO twi_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau kae se, “Ɔkɔm rekum me, na mede panyin reyɛ dɛn?” ");
INSERT INTO twi_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakob buaa Esau se, “Mate, ka ntam kyerɛ me wɔ Onyankopɔn anim sɛ, panyin no yɛ me dea.” Esau kaa ntam no de tɔn ne panyin no maa ne nua kumaa Yakob. ");
INSERT INTO twi_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Enti Yakob maa Esau aduan no bi ma odii. Ɔnom nsu guu so, sɔre kɔɔ ne kwan. Eyi ne ɔkwan a Esau faa so tɔn ne panyin no. ");
INSERT INTO twi_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Na ɔkɔm kɛse bi baa asase no so; ɛsono ɔkɔm kɛse a ɛbaa Abraham bere so no. Ɛno nti, Isak tu kɔtenaa Gerar a ɛyɛ Filistifo hene Abimelek kurow mu. ");
INSERT INTO twi_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ɛhɔ na Awurade yii ne ho adi kyerɛɛ Isak, ka kyerɛɛ no se, “Nkɔ Misraim, na mmom, tena asase a mɛkyerɛ wo no so. ");
INSERT INTO twi_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Tena asase yi so kakra, efisɛ mede saa asase no nyinaa bɛma wo ne wʼasefo, na mede asi bɔ a mehyɛɛ wʼagya Abraham no so dua. ");
INSERT INTO twi_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mɛma wʼasefo adɔɔso te sɛ nsoromma a ɛwɔ soro, na mede saa nsase yi nyinaa ama wɔn. Ɛnam wʼasefo so na wobehyira wiase aman ahorow nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Efisɛ Abraham tiee me nne, dii me nsɛm, mʼahyɛde ne me mmara nyinaa so.” ");
INSERT INTO twi_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Enti Isak tenaa Gerar. ");
INSERT INTO twi_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Bere a Gerar mmarima bisaa Isak yere Rebeka ho asɛm no, ɔkae se, “Ɔyɛ me nuabea.” Efisɛ na osuro sɛ ɔbɛka se, “Ɔyɛ me yere.” Ɔkaa saa asɛm yi, efisɛ na osusuw sɛ, esiane ne yere Rebeka ahoɔfɛ nti, anhwɛ a na kurom hɔ mmarima akum no. ");
INSERT INTO twi_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak tenaa hɔ kyɛɛ kakra no, da bi, Filistifo hene Abimelek gyina ne mfɛnsere mu na ohuu sɛ Isak regoru ne yere Rebeka ho. ");
INSERT INTO twi_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ɛno nti, Abimelek soma ma wɔkɔfrɛɛ Isak. Isak bae no, obisaa no se, “Ɔbea no yɛ wo yere ankasa. Adɛn nti na woka se, ‘Ɔyɛ me nuabea?’ ” Isak buaa no se, “Misusuwii sɛ, sɛ meka se ɔyɛ me yere a, ne nti, ebia na wɔakum me.” ");
INSERT INTO twi_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Na ɔhene Abimelek kae se, “Dɛn asɛm na wo ne yɛn adi yi? Nokware a woamma anna adi nti, anka obi betumi afa wo yere no, na wode mmusu aba yɛn so.” ");
INSERT INTO twi_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ɛno nti, Abimelek bɔɔ ne manfo no kɔkɔ se, “Obiara a ɔde ne nsa bɛka saa ɔbarima yi, anaa ne yere no, ɔkwan biara so no wobekum no.” ");
INSERT INTO twi_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Saa afe no ara Isak dɔw afuw. Na Awurade hyiraa nʼadwumade so. Ne nnɔbae baa bebree. ");
INSERT INTO twi_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isak yɛɛ ɔdefo. Nʼahonya kɔɔ so dɔɔso ma odii taamu. ");
INSERT INTO twi_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Onyaa nguan, anantwi, ne asomfo bebree ma ɛyɛɛ saa ma Filistifo no ani beree no yiye. Saa anibere yi nti, Filistifo no de dɔte kosisiw ");
INSERT INTO twi_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","abura ahorow a nʼagya Abraham maa ne nkoa tutuu wɔ ne bere so no nyinaa ano. ");
INSERT INTO twi_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ɛbaa saa no, ɔhene Abimelek ka kyerɛɛ Isak se, “Tu fi yɛn asase so, efisɛ wʼahonya dodow no aka yɛn ahyɛ.” ");
INSERT INTO twi_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isak tu fii Gerar kurow no mu, kɔɔ Gerar subon mu de hɔ kɔyɛɛ nʼatenae. ");
INSERT INTO twi_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Enti Isak maa ne nkoa san tutuu mmura a nʼagya Abraham maa ne nkoa tutuu na ne wu akyi no Filistifo no sisiw ne nyinaa no. Ɔsan de din koro no ara a nʼagya Abraham de totoo mmura no totoo no bio. ");
INSERT INTO twi_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isak nkoa no tuu abura foforo bi wɔ Gerar subon no mu, kɔtoo nsu a ɛyɛ kurunnyenn. ");
INSERT INTO twi_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Nanso Gerar nguanhwɛfo ne Isak nguanhwɛfo gyee abura no ho akyinnye. Gerar nguanhwɛfo no kae se, “Abura yi yɛ yɛn de.” Eyi maa Isak too saa abura no din Esek, a ase kyerɛ akyinnyegye abura. ");
INSERT INTO twi_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Isak nkoa no san tuu abura foforo, nanso Gerar nguanhwɛfo no san ne wɔn kasakasaa ɛno nso so. Eyi maa Isak san too saa abura no nso din Sitna, a ase kyerɛ Aperedi. ");
INSERT INTO twi_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isak gyaw saa abura no hɔ kotuu abura foforo. Afei, nnipa a wɔne no te hɔ no gyaee no haw a obiara ne no ankasa so bio. Eyi maa Isak too saa abura yi din Rehobot a ase ne “Afei de Awurade abɔ yɛn atenase na yebenya yɛn ho wɔ asase yi so.” ");
INSERT INTO twi_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isak tu fii hɔ kɔɔ Beer-Seba. ");
INSERT INTO twi_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Anadwo no, Awurade yii ne ho adi kyerɛɛ no, ka kyerɛɛ no se, “Mene wʼagya, Abraham Nyankopɔn. Nsuro, efisɛ me ne wo na ɛwɔ hɔ. Bɔ a mahyɛ mʼakoa Abraham nti, mehyira wo na mama wʼasefo adɔɔso, na wɔayɛ ɔman kɛse.” ");
INSERT INTO twi_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isak sii afɔremuka, som Awurade wɔ hɔ. Osii ntamadan tenaa hɔ, na ne nkoa nso tuu abura maa no. ");
INSERT INTO twi_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Da bi, ɔhene Abimelek ne ne fotufo Ahusad ne ne sahene Pikol fi Gerar bɛsraa Isak. ");
INSERT INTO twi_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isak bisaa wɔn se, “Adɛn nti na mo a na mo ne me nka, na mopam me fii mo nkyɛn aba me ha nnɛ sɛ morebɛsra me?” ");
INSERT INTO twi_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Wobuaa no se, “Yehu pefee sɛ Awurade wɔ wʼafa nti, yɛasi gyinae sɛ, yɛne wo bɛyɛ apam. Apam no bɛda wo ne yɛn ntam. Pene so, na yɛne wo nyɛ saa apam no ");
INSERT INTO twi_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","sɛ worenhaw yɛn, sɛnea yɛn nso, yɛanhaw wo no. Yɛne wo tenaa yiye. Yegyaa wo kwan asomdwoe mu. Na afei, hwɛ sɛnea Awurade ahyira wo.” ");
INSERT INTO twi_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isak too wɔn pon, na wodidi nomee de twɛn apam a wɔne no rebɛyɛ no. ");
INSERT INTO twi_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ade kyee anɔpa no, Isak ne mmarima no kekaa wɔn ho wɔn ho ntam, de sii wɔn apam a wɔayɛ no so dua. Na Isak gyaa wɔn kwan ma wɔkɔɔ asomdwoe mu. ");
INSERT INTO twi_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Da no ara, Isak asomfo bɛkaa abura a na wɔretu no ho asɛm kyerɛɛ no se, “Yɛato nsu.” ");
INSERT INTO twi_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isak too abura no din Seba a, ase kyerɛ sɛ “Ntanka abura.” Kurow a akyiri no wɔkyekyeree wɔ hɔ no, wɔtoo hɔ din Beer-Seba a ebesi nnɛ, wɔda so frɛ hɔ saa ara. ");
INSERT INTO twi_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau dii mfe aduanan no, ɔwaree ababaa bi a na wɔfrɛ no Yudit. Na nʼagya yɛ Hetini bi a ne din de Beeri. Esau san waree Basmat a nʼagya yɛ Hetini bi a ne din de Elon. ");
INSERT INTO twi_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Nanso Isak ne Rebeka bo annwo wɔ saa aware no ho. ");
INSERT INTO twi_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isak bɔɔ akwakoraa a nʼani so ayɛ no wusiwusi na onhu ade papa no, da koro bi, ɔfrɛɛ ne babarima panyin Esau. “Me ba.” Na Esau gyee so se, “Agya, mini.” ");
INSERT INTO twi_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak kae se, “Mprempren mabɔ akwakoraa, na minnim da a mewu. ");
INSERT INTO twi_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Fa wʼagyan ne wo bɛmma, na kɔ wuram kɔhwehwɛ hanam bi brɛ me. ");
INSERT INTO twi_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Fa noa mʼakɔnnɔduan no bi brɛ me, na minni, na minhyira wo ansa na mawu.” ");
INSERT INTO twi_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Bere a Isak ne ne ba Esau rekasa no, na Rebeka retie. Enti bere a Esau kɔɔ sɛ ɔrekokum nam no aba pɛ, na ");
INSERT INTO twi_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka ka kyerɛɛ ne ba Yakob se, “Yakob tie! Metee sɛ wʼagya reka akyerɛ wo nua Esau se, ");
INSERT INTO twi_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Kɔhwehwɛ hanam bi fa noa mʼakɔnnɔduan no bi brɛ me, na minni, na minhyira wo wɔ Awurade anim, ansa na mawu.’ ");
INSERT INTO twi_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Afei, me ba, tie asɛm a merebɛka akyerɛ wo yi yiye, na di so. ");
INSERT INTO twi_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kɔ nguankuw no mu, na kɔkyere nguan abien a wɔadodɔ srade brɛ me, na memfa nnoa akɔnnɔduan, sɛnea wʼagya pɛ no pɛpɛɛpɛ mma no. ");
INSERT INTO twi_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Sɛ menoa wie a, fa kɔma no, na onni, na onhyira wo ansa na wawu.” ");
INSERT INTO twi_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakob ka kyerɛɛ ne na Rebeka se, “Wunim sɛ me nua Esau ho wɔ nwi, na me nso, me ho yɛ trontrom. ");
INSERT INTO twi_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Sɛ ɛba sɛ mʼagya de ne nsa fa me ho, na ohu sɛ ɛnyɛ Esau a, ɛbɛyɛ sɛ gyama meredaadaa no, na wadome me mmom, sen sɛ anka obehyira me.” ");
INSERT INTO twi_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Yakob ne na ka kyerɛɛ no se, “Me ba, ma nnome no mmra me so. Wo de, yɛ nea maka akyerɛ wo no ara. Kɔ na kɔkyere nguan no brɛ me.” ");
INSERT INTO twi_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Enti Yakob tiee ne na Rebeka asɛm, kɔkyeree nguan no brɛɛ no. Na okum wɔn, de noaa akɔnnɔduan bi, sɛnea Isak pɛ no pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ɛno akyi no, Rebeka faa ne ba panyin Esau atade papa bi a ɛwɔ fie hɔ de maa ne ba Yakob hyɛe. ");
INSERT INTO twi_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Afei, ɔde nguan a wokum wɔn no nhoma yɛɛ ahyɛnsa, kataa Yakob nsa ho. Ɔde bi kataa ne kɔn ho nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ɔde brodo a wato no foforo kaa akɔnnɔduan a wanoa no ho, de maa ne ba Yakob. ");
INSERT INTO twi_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakob de aduan no kɔmaa nʼagya Isak wɔ ne dan mu. Oduu hɔ no, ɔkae se, “Agya!” Isak buae se, “Mewɔ hɔ na ɛyɛ hena?” ");
INSERT INTO twi_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakob ka kyerɛɛ nʼagya se, “Ɛyɛ me wʼabakan Esau. Mayɛ nea woka kyerɛɛ me sɛ menyɛ no. Mede hanam a wopɛ no bi anoa wʼakɔnnɔduan no abrɛ wo, enti mesrɛ wo, sɔre tena ase, na didi, na sɛ wudidi wie a, woahyira me.” ");
INSERT INTO twi_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isak bisaa ne ba no se, “Ɛyɛɛ dɛn na wo ho ayɛ hare sɛɛ yi?” Yakob buae se, “Awurade, wo Nyankopɔn no, na ogyinaa mʼakyi maa me nsa kaa hanam no bi ntɛm.” ");
INSERT INTO twi_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Afei, Isak ka kyerɛɛ Yakob se, “Me ba, twiw bɛn me, na memfa me nsa nka wo nhwɛ sɛ, wo ne me ba Esau no ampa ana.” ");
INSERT INTO twi_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakob twiw bɛn nʼagya Isak, na ɔde ne nsa kekaa ne ho kae se, “Nne yi yɛ Yakob nne, nanso nsa yi yɛ Esau de.” ");
INSERT INTO twi_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isak anhu sɛ ɛyɛ Yakob, efisɛ na ne nsa ho wɔ nwi te sɛ ne nua Esau pɛpɛɛpɛ. Enti, ohyiraa no. ");
INSERT INTO twi_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isak san bisaa Yakob se, “Enti ampa ara sɛ wo ne me ba Esau no?” Yakob buae se, “Yiw, me ne Esau.” ");
INSERT INTO twi_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Afei, Isak kae se, “Me ba, fa wʼaduan no brɛ me na minni, na midi wie a, mahyira wo.” Yakob de aduan no brɛɛ nʼagya Isak, na odii; ɔsan de nsa brɛɛ no maa ɔnomee. ");
INSERT INTO twi_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Isak wiee no, ɔka kyerɛɛ Yakob se, “Me ba, bra befew mʼano!” ");
INSERT INTO twi_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Enti Yakob kɔɔ nʼagya Isak nkyɛn kofew nʼano. Bere a Isak huam Yakob atade mu, na ogye too mu sɛ, ɛyɛ ne ba Esau no, ohyiraa no se, “Ampa ara! Me ba ho hua te sɛ hua a efi afuw a Awurade ahyira so no mu. ");
INSERT INTO twi_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Onyankopɔn mma wo ɔsoro bosu ne asase mu srade, na afum aduan ne nsa mmu wo so. ");
INSERT INTO twi_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Amanaman bɛsom wo, na nnipa nyinaa abu wo nkotodwe. Wubedi wo nuanom so, na wo na mma nso akotow wo. Wɔbɛdome wɔn a wɔdome wo nyinaa, na wɔn a wohyira wo nyinaa nso, wobehyira wɔn.” ");
INSERT INTO twi_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak hyiraa Yakob wiei, na ofii nʼagya nkyɛn kɔe ara pɛ, na ne nua Esau fi nʼahayɛ bae. ");
INSERT INTO twi_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ɔno nso noaa akɔnnɔduan brɛɛ nʼagya. Na ɔka kyerɛɛ no se, “Agya, sɔre na di me hanam aduan no, na hyira me.” ");
INSERT INTO twi_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Nʼagya Isak bisaa no se, “Na hena ni?” Esau buae se, “Ɛyɛ me wʼabakan Esau.” ");
INSERT INTO twi_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isak tee saa asɛm yi pɛ, ne ho fii ase wosow biribiribiri, na obisae se, “Ɛno de, na hena na ɔkɔɔ ahayɛ kokum nam de noaa aduan brɛɛ me yi. Mididi wie hyiraa onipa ko no pɛ na wobaa yi. Nokware ni, nhyira a mahyira no no, sɛ mesan mʼano a, ɛrenyɛ yiye!” ");
INSERT INTO twi_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Bere a Esau tee asɛm a nʼagya kae no, ɔno nso de awerɛhow teɛɛ mu denneennen, ka kyerɛɛ nʼagya se, “Agya! Hyira me. Hyira me nso bi!” ");
INSERT INTO twi_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Nanso Isak kae se, “Ɛno de, na wo nua na ɔde nnaadaa abegye wo nhyira kɔ!” ");
INSERT INTO twi_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau kae se, “Ɛnyɛ nwonwa sɛ wɔfrɛ no Yakob a ase kyerɛ nantintwitwafo. Eyi ne ne mprenu so a wadaadaa me. Nea edi kan ne sɛ, ɔdaadaa me gyee me panyin. Nea ɛto so abien nso ne sɛ, ɔde nnaadaa agye me nhyira!” Afei, Esau bisaa nʼagya se, “Enti woannyaw me nhyira no bi a wode behyira me nso?” ");
INSERT INTO twi_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak buaa Esau se, “Manya de no ayɛ wo wura dedaw. Mede ne nuanom nyinaa ayɛ ne nkoa. Mahyira no sɛ, obenya afum nnuan ne nsa foforo bebree. Na afei, dɛn bio na aka a metumi ayɛ ama wo, me ba?” ");
INSERT INTO twi_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau bisaa nʼagya se, “Agya, enti nhyira baako pɛ na wowɔ? Agya, hyira me nso bi!” ");
INSERT INTO twi_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Afei, nʼagya Isak buaa no se, “Tie! Asase kesee so na wobɛtena, na ɔsoro bosu rentɔ wɔ so. ");
INSERT INTO twi_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Wode wo afoa na ɛbɛtena ase, na woasom wo nua kumaa. Nanso daakye bi, sɛ wokanyan wo ho a, wubefi wo nua no som ase.” ");
INSERT INTO twi_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esiane Esau nhyira a Yakob kɔdaadaa wɔn agya Isak gyee no nti, Esau tan Yakob. Esau kaa wɔ ne tirim se, “Ɛrenkyɛ, na mʼagya Isak awu. Sɛ owu a, mekum me nua Yakob.” ");
INSERT INTO twi_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Obi tee adwene a Esau afa wɔ ne nua kumaa Yakob ho no, ɔkɔbɔɔ wɔn na Rebeka amanneɛ. Enti Rebeka soma kɔfrɛɛ ne ba kumaa Yakob, na ɔka kyerɛɛ no se, “Wo nua Esau abɔ ne tirim sɛ, sɛ onya wo a, obekum wo ansa na ne bo atɔ ne yam. ");
INSERT INTO twi_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Enti me ba, tie asɛm a merebɛka akyerɛ wo yi yiye. Guan ntɛm kɔ me nua Laban nkyɛn wɔ Haran. ");
INSERT INTO twi_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Tena ne nkyɛn kakra wɔ hɔ, kosi sɛ wo nua Esau bo bedwo. ");
INSERT INTO twi_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Sɛ wo nua koma tɔ ne yam, na ne werɛ fi nea woyɛɛ no, na ogyaa mu ma ɛka a, mɛsoma abɛka akyerɛ wo, na woafi Haran aba. Adɛn nti na ɛsɛ sɛ metena hɔ hwɛ, na me mma baanu bɔ mu wu da koro?” ");
INSERT INTO twi_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Enti Rebeka ka kyerɛɛ Isak se, “Saa Hetifo mmabaa yi koraa ama asetena afono me. Sɛ ɛkɔba sɛ Yakob nso kɔware Hetifo asase so mmabaa yi bi a, mmea a wɔte sɛ eyinom bi a, ɛno de, na miwuu koraa a, anka eye.” ");
INSERT INTO twi_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isak frɛɛ Yakob, hyiraa no hyɛɛ no se, “Nware saa Kanaanfo mmea yi bi da. ");
INSERT INTO twi_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ka wo ho kɔ Betuel a ɔyɛ wo na Rebeka agya no nkyɛn wɔ Paddan-Aram, na kɔware wo wɔfa Laban mmabea no mu baako. ");
INSERT INTO twi_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Otumfo Nyankopɔn no nhyira wo. Ɔmma wʼase nnɔ bebree, na wʼasefo no abɛyɛ ɔman kɛse a mmusuakuw bebree befi mu aba. ");
INSERT INTO twi_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Onyankopɔn mfa nhyira a ɔde hyiraa Abraham no nhyira wo ne wʼasefo. Ɔmma asase a nnɛ wote so sɛ ɔhɔho yi, a ɛyɛ asase a Onyankopɔn de maa Abraham no nyɛ wo dea.” ");
INSERT INTO twi_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Sɛnea Isak gyaa ne ba Yakob kwan ni: Yakob kɔɔ Laban a ɔyɛ Aramni Betuel babarima nkyɛn wɔ Paddan-Aram. Na saa Laban yi yɛ Esau ne Yakob mama Rebeka ne nuabarima. ");
INSERT INTO twi_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau tee sɛ Isak ahyira Yakob, na wagya no kwan ma ɔkɔ Paddan-Aram sɛ ɔnkɔware wɔ hɔ. Ohyiraa no no, ɔhyɛɛ no se, “Nware saa Kanaanfo mmea yi bi da.” ");
INSERT INTO twi_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yakob tiee nʼagya ne ne na afotu no sii mu kɔɔ Paddan-Aram. ");
INSERT INTO twi_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau huu sɛ nʼagya Isak mpɛ Kanaanfo mmea asɛm. ");
INSERT INTO twi_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Enti osii mu kɔɔ Abraham babarima Ismael nkyɛn, kɔwaree ne babea Mahalat. Na Mahalat yɛ Nebaiot nuabea, na ɔyɛ Ismael a ɔno nso yɛ Abraham babarima no babea. Esau waree Mahalat kaa ne yerenom ho. ");
INSERT INTO twi_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakob fii Beer-Seba de nʼani kyerɛɛ Haran. ");
INSERT INTO twi_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Oduu baabi na onwini redwo no, ɔpɛɛ baabi soɛe, efisɛ na ade resa. Ɔfaa ɔbo bi wɔ faako a wadu hɔ de yɛɛ sumii. ");
INSERT INTO twi_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ɔdae no, ɔsoo dae bi. Dae no mu no, ohuu sɛ antweri bi si fam a nʼatifi ka wim, na Onyankopɔn abɔfo redi so aforosian. ");
INSERT INTO twi_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ohuu sɛ Onyankopɔn gyina antweri no atifi. Onyankopɔn ka kyerɛɛ no se, “Mene Awurade, Abraham Nyankopɔn, ne wʼagya Isak Nyankopɔn. Mede asase a woda so yi bɛma wo ne wʼasefo. ");
INSERT INTO twi_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Wʼasefo bɛyɛ sɛ asase so mfutuma, na mobɛtrɛtrɛw akɔ apuei ne atɔe, atifi ne anafo nyinaa. Wo ne wʼasefo mu na wofi behyira wiase mmusuakuw nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Eyinom nyinaa akyi no, mɛka wo ho, na baabiara a wobɛkɔ no, medi wʼakyi, na mɛsan de wo aba saa asase yi so. Merennyaw wo da, kosi sɛ bɔ a mahyɛ wo yi nyinaa bɛba mu.” ");
INSERT INTO twi_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakob nyanee no, ɔkaa wɔ ne tirim se, “Ampa ara, sɛɛ na Awurade wɔ saa beae ha yi, a na minnim!” ");
INSERT INTO twi_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakob suroe, na ɔkɔɔ so kaa wɔ ne tirim se, “Ɛha yɛ hu papa. Ɛha nyɛ baabiara sɛ Onyankopɔn fi. Ɔsoro pon ano ne ha.” ");
INSERT INTO twi_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Enti Yakob sɔree anɔpatutuutu maa ɔbo a ɔde yɛɛ sumii no so sii hɔ, hwiee ngo guu so. ");
INSERT INTO twi_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ɔtoo beae no din Bet-El a ase kyerɛ Onyame fi. Kan no na anka wɔfrɛ saa kurow no Lus. ");
INSERT INTO twi_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Na Yakob kaa ntam se, “Sɛ Onyankopɔn bɛka me ho, ahwɛ me so wɔ saa akwantu yi mu, ama me aduan adi, ama me ntama afura, ");
INSERT INTO twi_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","sɛnea ɛbɛyɛ a mɛsan aba mʼagya fi asomdwoe mu a, ɛno de, Awurade bɛyɛ me Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Saa ɔbo a mede asi hɔ sɛ nkaedum yi bɛyɛ Onyankopɔn fi. Biribiara a wo, Onyankopɔn, de bɛma me no, mede mu nkyɛmu du mu baako bɛma wo.” ");
INSERT INTO twi_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakob toaa nʼakwantu so koduu apueifo asase so. ");
INSERT INTO twi_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Asase no so baabi na okohuu abura bi a nguankuw abiɛsa butubutuw ho. Efisɛ saa abura no mu nsu na na wɔsaw ma nguan no nom. Na ɔbo kɛse bi na ɛkata abura no so. ");
INSERT INTO twi_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Bere biara a nguankuw no bɛboa wɔn ho ano wɔ hɔ no, nguanhwɛfo no pirew ɔbo no fi abura no ano ma nguan no nsu nom. Sɛ nguan no nom nsu no wie a, na nguanhwɛfo no asan de ɔbo no akata abura no ano. ");
INSERT INTO twi_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakob bisaa wɔn se, “Anuanom, mufi he na mobaa ha?” Wobuaa Yakob se, “Yefi Haran.” ");
INSERT INTO twi_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakob san bisaa wɔn se, “Munim Nahor nena Laban ana?” Nguanhwɛfo no nso buaa no se, “Yiw, yenim no.” ");
INSERT INTO twi_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Na Yakob bisaa wɔn se, “Na ne ho te dɛn?” Wobuaa no se, “Ne ho ye. Na ne babea Rahel koraa na ɔne ne nguan reba yi.” ");
INSERT INTO twi_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakob kae se, “Monhwɛ. Owia no ano yɛ den dodo. Bere a ɛsɛ sɛ wɔboaboa mmoa no ano nnui. Momma wɔn nsu nnom, na monka wɔn nkɔ wɔn adidibea.” ");
INSERT INTO twi_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nguanhwɛfo no buaa Yakob se, “Sɛ yɛmmoaboaa nguan no nyinaa ano, na yempirew ɔbo no mfii abura no ano a, yɛrentumi mma wɔn nsu nnom.” ");
INSERT INTO twi_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakob gu so ne wɔn rekasa no ara na Rahel a ɔno nso yɛ oguanhwɛfo no de nʼagya nguan baa hɔ. ");
INSERT INTO twi_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Bere a Yakob huu ne na nuabarima Laban babea Rahel ne ne wɔfa Laban nguan no, okopirew ɔbo no fii abura no ano. Afei, wɔmaa nguan no nsu nomee. ");
INSERT INTO twi_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Afei, Yakob few Rahel ano, na osui. ");
INSERT INTO twi_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Na Yakob aka akyerɛ Rahel se, ɔno Yakob yɛ Rahel no agya busuani a ɔsan yɛ nʼagya Laban no nuabea Rebeka babarima. Enti Rahel tuu mmirika kɔka kyerɛɛ nʼagya. ");
INSERT INTO twi_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban tee ne nuabea Rebeka ba Yakob ho asɛm no, ɔyɛɛ ntɛm kohyiaa no. Laban yɛɛ no atuu, few nʼano, de no baa ne fi maa Yakob bɔɔ no nʼanantese. ");
INSERT INTO twi_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban ka kyerɛɛ no se, “Woyɛ me dehye.” Na Yakob tenaa Laban nkyɛn ɔsram. ");
INSERT INTO twi_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Da koro bi, Laban ka kyerɛɛ Yakob se, “Ɛwɔ mu sɛ woyɛ me busuani de, nanso ɛno nkyerɛ sɛ, sɛ woyɛ adwuma ma me a ɛnsɛ sɛ mitua wo ka. Kyerɛ me akatua a wopɛ na memfa mma wo.” ");
INSERT INTO twi_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Na Laban wɔ mmabea baanu. Na ɔpanyin no din de Lea na akumaa no nso de Rahel. ");
INSERT INTO twi_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Na Lea aniwa aba yɛ fɛ, na Rahel yɛ ɔbea fɛfɛ a nʼanim yɛ nyam yiye. ");
INSERT INTO twi_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Na Yakob dɔ Rahel wɔ aware kwan so, nti ɔka kyerɛɛ Rahel agya Laban se, “Sɛ wode wo babea kumaa Rahel bɛma me aware a, anka me nso mɛsom wo mfe ason.” ");
INSERT INTO twi_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban kae se, “Mepene so! Eye sɛ mede no bɛma wo aware mmom sen sɛ mede no bɛma obi foforo bi a minnim no. Enti tena me nkyɛn.” ");
INSERT INTO twi_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Esiane ɔdɔ a na Yakob dɔ Rahel nti, ɔsom Laban mfe ason, na wanhu koraa sɛ wasom akyɛ saa. Ɛyɛɛ no sɛ gyama ɔsomee nnansa bi pɛ. ");
INSERT INTO twi_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yakob som wiee no, ɔka kyerɛɛ Laban se, “Masom awie nti, fa Rahel ma me na menware no.” ");
INSERT INTO twi_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ɛno nti, Laban too pon kɛse, na ɔtoo nsa frɛɛ nnipa a na ɔne wɔn wɔ hɔ nyinaa baa aponto no ase. ");
INSERT INTO twi_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Na eduu anadwo a sum aduru no, Laban de ne babea Lea kɔmaa Yakob, maa ɔne no dae. ");
INSERT INTO twi_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ɛno akyi no, Laban de nʼafenaa Silpa kaa Lea ho sɛ ɔnkɔsom no. ");
INSERT INTO twi_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ade kyee no, ohuu sɛ Lea mmom na ɔda nʼakyi. Ɛnna Yakob bisaa Laban se, “Asɛm bɛn na wo ne me adi yi? Ɛnyɛ Rahel nti na mesom wo? Adɛn nti na woadaadaa me sɛɛ?” ");
INSERT INTO twi_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban buaa Yakob se, “Ɛha de, ɛnyɛ yɛn amanne sɛ yɛde ɔbabea kumaa ma aware wɔ bere a ɔpanyin no nwaree ɛ. ");
INSERT INTO twi_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ma Lea nni nnaawɔtwe wɔ wo nkyɛn, na nnaawɔtwe no akyi no, sɛ wopɛ Rahel ara a, mɛma woasan asom mfirihyia ason bio, na mede no ama wo aware.” ");
INSERT INTO twi_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakob penee so ne Lea tenaa nnaawɔtwe. Ɛno akyi no, ɔsom mfe ason ansa na Laban de ne babea Rahel nso maa no waree. ");
INSERT INTO twi_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban de nʼafenaa Bilha nso maa ne babea Rahel sɛ ɔnkɔsom no. ");
INSERT INTO twi_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakob de ne ho kaa Rahel nso. Na ɔdɔ Rahel sen Lea. Yakob tenaa Laban nkyɛn, som no mfirihyia ason bio sɛnea ɔne no hyehyɛe no. ");
INSERT INTO twi_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Awurade huu sɛ Yakob ani nnye Lea ho no, obuee ne yafunu mu, nanso Rahel de, na ɔnwo. ");
INSERT INTO twi_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea nyinsɛn woo ɔbabarima. Ɔtoo no din Ruben a nkyerɛase ne “Awurade ahu mmɔbɔ a meyɛ.” Na Lea kae se, “Awurade ahu me mmɔbɔ. Nokware, afei na me kunu ani begye me ho.” ");
INSERT INTO twi_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea nyinsɛnee bio na ɔsan woo ɔbabarima bio no, ɔkae se, “Esiane sɛ Awurade huu sɛ me kunu ani nnye me ho nti, wasan akyɛ me ɔbabarima bio.” Enti, ɔtoo ne din Simeon a nkyerɛase ne “Awurade ate!” ");
INSERT INTO twi_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lea san nyinsɛnee bio. Na ɔwoo ɔbabarima bio no, ɔkae se, “Afei de, me kunu de ne ho bɛfam me ho, efisɛ mawo mmabarima baasa ama no.” Ɛno nti, ɔtoo no din Lewi a nkyerɛase ne “Ahofam.” ");
INSERT INTO twi_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lea san nyinsɛnee. Bere a ɔsan woo ɔbabarima bio no, ɔkae se, “Saa bere yi de, mɛkamfo Awurade.” Ɛno nti, ɔtoo no din Yuda, a ne nkyerɛase ne “Nkamfo.” Eyi akyi no, ɔhomee awo so. ");
INSERT INTO twi_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Bere a Rahel huu sɛ ɔne Yakob nwo no, nʼani beree ne nuabea no. Enti ɔka kyerɛɛ Yakob se, “Sɛ wo ne me anwo mma a, mewu!” ");
INSERT INTO twi_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakob bo fuw Rahel ma ɔkae se, “Meyɛ Onyankopɔn? Ɔno na wasiw wo yafunu ano.” ");
INSERT INTO twi_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Na Rahel ka kyerɛɛ Yakob se, “Mʼafenaa Bilha ni, wo ne no nkɔda, na ɔnwo mma me, na ɛnam ne so ama me nso manya abusua.” ");
INSERT INTO twi_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Enti Rahel de nʼabaawa Bilha maa Yakob waree. Yakob ne no dae. ");
INSERT INTO twi_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Onyinsɛn woo ɔbabarima maa Yakob. ");
INSERT INTO twi_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Na Rahel kae se, “Onyankopɔn adi mʼasɛm ama me. Wate mʼadesrɛ ama me ɔbabarima.” Ne saa nti, ɔtoo no din Dan a ne nkyerɛase ne, “Onyankopɔn adi mʼasɛm ama me.” ");
INSERT INTO twi_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahel afenaa Bilha nyinsɛnee bio, woo ɔbabarima a ɔto so abien maa Yakob. ");
INSERT INTO twi_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Na Rahel kae se, “Me ne me nua Lea adi yɛn ho aperepere na madi nkonim.” Ɛno nti, ɔtoo abofra no din Naftali a ne nkyerɛase ne, “Mʼakodi.” ");
INSERT INTO twi_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Bere a Lea huu sɛ nʼawo atew kɔ no, ɔno nso de nʼafenaa Silpa maa Yakob waree. ");
INSERT INTO twi_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Lea afenaa Silpa woo ɔbabarima maa Yakob. ");
INSERT INTO twi_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Na Lea kae se, “Akraye bɛn ni!” Enti ɔtoo abofra no din Gad a ne nkyerɛase ne, “Asi me yiye.” ");
INSERT INTO twi_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Lea afenaa Silpa woo ɔbabarima a ɔto so abien maa Yakob. ");
INSERT INTO twi_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Na Lea kae se, “Mʼani agye! Afei de, mmea no bɛfrɛ me anigye.” Enti, ɔtoo no din Aser a ne nkyerɛase ne “Anigye.” ");
INSERT INTO twi_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Awitwabere mu da bi, Ruben kɔɔ afum kohuu afifide bi a wɔfrɛ no dudaim. Ɔde bi brɛɛ ne na Lea. Rahel ka kyerɛɛ Lea se, “Mesrɛ wo, ma me wo ba no dudaim no bi.” ");
INSERT INTO twi_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Nanso Lea de abufuw buae se, “Woabegye me kunu akyi no, woresan abegye me ba dudaim a ɔde abrɛ me no bi apaa so?” Na Rahel de awerɛhow kae se, “Eye, ɛno de, Yakob mmɛda wo nkyɛn nnɛ anadwo yi, na ma me dudaim no bi.” ");
INSERT INTO twi_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Enti da no anwummere a Yakob fi afum reba no, Lea kohyiaa no, ka kyerɛɛ no se, “Ɛsɛ sɛ wobɛda me nkyɛn anadwo yi, efisɛ mede me ba dudaim atɔ wo.” Enti Yakob kɔdaa Lea nkyɛn anadwo no. ");
INSERT INTO twi_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Onyankopɔn tiee Lea mpaebɔ, na onyinsɛn woo ɔbabarima a ɔto so anum maa Yakob. ");
INSERT INTO twi_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Na Lea kae se, “Mede mʼafenaa Silpa maa me kunu Yakob no, Onyankopɔn adom me.” Enti wɔtoo abofra no din Isakar a nkyerɛase ne “Akyɛde.” ");
INSERT INTO twi_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea san nyinsɛnee bio, na ɔwoo ne babarima a ɔto so asia maa Yakob. ");
INSERT INTO twi_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Enti Lea kae se, “Onyankopɔn ama me akyɛde a ɛsom bo yiye. Afei de, manya me kunu anim anuonyam. Ɔde obu ne nidi bɛma me, efisɛ mawo mmabarima baasia ama no. Enti ɔtoo abarimaa no din Sebulon a ne nkyerɛase ne Anuonyam.” ");
INSERT INTO twi_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Akyiri no, Lea woo ɔbabea too no din Dina. ");
INSERT INTO twi_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Afei, Onyankopɔn kaee Rahel, tiee ne mpaebɔ, buee nʼawotwaa ano. ");
INSERT INTO twi_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rahel nyinsɛn woo ɔbabarima, na ɔkae se, “Afei de, Onyankopɔn apepa mʼanimguase ama me nso mawo ɔba.” ");
INSERT INTO twi_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Rahel too ne ba no din Yosef a ne nkyerɛase ne “Awurade mfa ɔbabarima baako nka me ho.” ");
INSERT INTO twi_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rahel woo Yosef no, ankyɛ na da koro bi, Yakob ka kyerɛɛ Laban se, “Mepɛ sɛ mesan kɔ mʼankasa mʼasase so ne me fi, enti mesrɛ wo, gya me kwan na menkɔ. ");
INSERT INTO twi_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Fa me yerenom ne me mma a wɔn nti mebɛsom wo no ka ho. Wʼankasa ara wunim ɔsom pa a masom wo.” ");
INSERT INTO twi_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban buae se, “Mesrɛ wo, nkɔ nnya me. Makɔ abisa ahu sɛ, nhyira dodow a manya yi nyinaa fi te a wote me nkyɛn yi.” ");
INSERT INTO twi_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Laban ka kaa ho se, “Kyerɛ me akatua biara a wubegye, na metua.” ");
INSERT INTO twi_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakob buaa Laban se, “Wʼankasa wunim som a masom wo, ne sɛnea mahwɛ wʼanantwi ne wo nguan ama wɔn ase afɛe afa. ");
INSERT INTO twi_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Wʼahode kakra a na wowɔ bere a mebae no, nnɛ, adɔɔso abu so. Biribiara a meyɛ maa wo no nso, Awurade ahyira so. Na me nso, bere bɛn na metumi apɛ biribi de agyaw mʼabusuafo?” ");
INSERT INTO twi_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban bisaa Yakob se, “Akatua ahe na memfa mma wo?” Yakob nso buae se, “Mma me hwee, na mmom, sɛ wobɛyɛ mʼabisade baako pɛ yi ama me de a, mɛkɔ so ayɛn wo mmoa no. ");
INSERT INTO twi_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nnɛ, ma menkɔhwehwɛ wo mmoa no nyinaa mu, na minnyi oguan biara a ne ho yɛ ntokontrama, oguan ba biara a ɔyɛ tuntum ne abirekyi biara a ɔyɛ ntokontrama. Eyinom na ɛbɛyɛ mʼakatua. ");
INSERT INTO twi_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Eyi bɛma me nokwaredi adi me adanse, bere biara a wobɛhwehwɛ akatua a wode ama me no mu no. Sɛ wuhu abirekyi biara a ɔnyɛ ntokontrama anaa oguan biara a nʼahosu mmiri wɔ me mmoa no mu a, na ɛkyerɛ sɛ mawia wɔn afi wo de mu.” ");
INSERT INTO twi_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban buaa Yakob se, “Eye, yɛ no sɛnea woaka no.” ");
INSERT INTO twi_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Da no ara, Laban yiyii adwennini a wɔyɛ ntokontrama no nyinaa ne nguanbere a wɔyɛ ntokontrama no nso; mmoa no mu biara a fufu wɔ ne ho ne oguan ba biara a ɔyɛ tuntum no, ɔde wɔn kɔmaa ne mmabarima. ");
INSERT INTO twi_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Na Laban mma no faa mmoa no de wɔn twaa nnansa kwan, fii baabi a na Yakob wɔ hɔ. Saa bere no mu no, Yakob tenaa hɔ, hwɛɛ Laban nguan no. ");
INSERT INTO twi_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Na Yakob faa saa nnua yi: ɔsɛsɛ, odwen ne ɔfo mman amono, yiyii ho akamakam ma ɛkɔtoo dua kwatii no. ");
INSERT INTO twi_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Afei, ɔde mman amono a wayiyi ho no nyinaa guguu mmoa no adidi nnaka mu, sɛnea ɛba sɛ, mmoa no ba sɛ wɔrebɛnom nsu no bi a, wobehu. Saa bere no na anini no foro abere no. ");
INSERT INTO twi_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Enti sɛ mmoa no hyia mu wɔ dua mman ntokontrama no ho, na wonyinsɛn na wɔwowo a, wɔn mma no ho yɛ ntokontrama. ");
INSERT INTO twi_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ɔnam saa kwan yi so yii Laban nguankuw no mu abere no guu faako ma ɛkaa anini no. Na ɔmaa wɔne Yakob nguan a wɔyɛ tuntum no hyiaa mu. Saa ɔkwan yi so na ɔfa tew nʼankasa ne nguankuw fii Laban de ho. ");
INSERT INTO twi_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Edu bere a nguanbere a wɔwɔ ahoɔden no pɛ sɛ wohyia adwennini no a, Yakob de mman a wayiyi ho akamakam no gu wɔn anim. ");
INSERT INTO twi_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Nanso wanyɛ nguan abere a wɔyɛ mmerɛw no saa. Enti nguantenmma a wonni ahoɔden no bɛyɛɛ Laban dea, na wɔn a wɔwɔ ahoɔden no nso bɛyɛɛ Yakob dea. ");
INSERT INTO twi_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ɛnam eyi so maa Yakob nyaa ne ho tam. Onyaa mmoa, mfenaa, nkoa, yoma ne mfurum bebree. ");
INSERT INTO twi_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakob tee sɛ Laban mmabarima no reka se, “Yakob afa yɛn agya ho nneɛma nyinaa. Nʼahonya nyinaa fi yɛn agya nneɛma a wafa no.” ");
INSERT INTO twi_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakob huu sɛ afei de, Laban ntew nʼanim nkyerɛ no sɛ kan no. ");
INSERT INTO twi_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Na Awurade ka kyerɛɛ Yakob se, “San kɔ wʼabusuafo ne wo nkurɔfo asase so, na medi wʼakyi.” ");
INSERT INTO twi_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Enti Yakob soma ma wɔkɔfrɛɛ ne yerenom Rahel ne Lea se wɔmmra ne nkyɛn wɔ sare no so, faako a ɔne ne nguankuw no wɔ no. ");
INSERT INTO twi_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Wɔbae no, ɔka kyerɛɛ wɔn se, “Mahu sɛ afei de, mo agya Laban anim nyɛ me fɛ sɛ kan no, nanso Onyankopɔn a mʼagya Isak som no no ka me ho. ");
INSERT INTO twi_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Munim sɛ mayi me yam de mʼahoɔden nyinaa ayɛ adwuma ama mo agya; ");
INSERT INTO twi_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","nanso mo agya nam asisi kwan so asesa mʼakatua mu mpɛn du. Nanso eyi nyinaa akyi no, Onyankopɔn amma no kwan amma wanyɛ me bɔne. ");
INSERT INTO twi_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Sɛ ɔka se, ‘Mmoa a wɔn ho yɛ ntokontrama no bɛyɛ wʼakatua,’ na sɛ mmoa no wo a, na wɔawo mma a wɔn ho yɛ ntokontrama. Sɛ ɔka se, ‘Mmoa a wɔn ho yɛ nsensanee no bɛyɛ wʼakatua’ a, na wɔawowo mma a wɔn ho yɛ nsensanee. ");
INSERT INTO twi_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ɔkwan a Onyankopɔn nam so agye mo agya nsam nyɛmmoa no de wɔn ama me ama mayɛ ɔdefo no ne no. ");
INSERT INTO twi_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Eduu bere a mmoa no hyia mu no, mesoo dae huu sɛ adwennini a wɔforo nguanbere no ho yɛ ntokontrama, nsensanee anaa nsisimu. ");
INSERT INTO twi_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Onyankopɔn bɔfo frɛɛ me wɔ dae no mu ka kyerɛɛ me se, ‘Yakob!’ Na migyee so se, ‘Me ni!’ ");
INSERT INTO twi_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Na ɔsoro abɔfo no ka kyerɛɛ me se, ‘Hwɛ na hu sɛ adwennini a wɔforo nguanbere no nyinaa ho yɛ nsensanee, ntokontrama anaa nsisimu, na mahu ɔkwan a Laban de wo fa so no nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mene Onyankopɔn a miyii me ho adi kyerɛɛ wo wɔ Bet-El, faako a wode ɔbo sii hɔ, hwiee ngo guu so, som me, hyɛɛ me bɔ sɛ, wobɛsom me no. Afei, tu fi saa asase yi so ntɛm ara, na san kɔ asase a wɔwoo wo wɔ so no so.’ ” ");
INSERT INTO twi_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Na Rahel ne Lea bisae se, “Enti saa tebea a yɛwɔ mu yi, yɛwɔ kyɛfa bi wɔ yɛn agya agyapade mu ana? ");
INSERT INTO twi_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Yɛn agya mfa yɛn sɛ yɛyɛ ahɔho? Watɔn yɛn, na yɛn ti sika a ogyee no nso, wadi. ");
INSERT INTO twi_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ɛyɛ nokware turodoo sɛ yɛn agya ahode a Onyankopɔn gyei no nyinaa yɛ yɛn ne yɛn mma dea. Enti biribiara a Onyankopɔn aka akyerɛ wo sɛ yɛ no, yɛ.” ");
INSERT INTO twi_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Na Yakob de ne mma ne ne yerenom tenatenaa yoma so. ");
INSERT INTO twi_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ɔkaa ne mmoa nyinaa, agyapade a wanya nyinaa ne mmoa a onyaa wɔ Paddan-Aram nyinaa dii nʼanim sɛ, ɔrekɔ nʼagya Isak nkyɛn wɔ Kanaan asase so. ");
INSERT INTO twi_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Bere a Laban kɔɔ wuram sɛ ɔrekotwitwa ne nguan ho nwi no, Rahel faa nʼakyi kowiaa nʼagya fi abosom. ");
INSERT INTO twi_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakob daadaa Aramni Laban a wamma wanhu sɛ ɔreguan. ");
INSERT INTO twi_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yakob de nʼahode nyinaa guanee. Otwaa Asubɔnten Eufrate, de nʼani kyerɛɛ bepɔw asase Gilead no so. ");
INSERT INTO twi_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Yakob ne nʼabusuafo guanee no, nnansa akyi ansa na Laban tee sɛ wɔkɔ. ");
INSERT INTO twi_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban faa ne fifo kaa ne ho, de anibere tiw Yakob. Nnanson akyi ansa na ɔkɔtoo Yakob ne ne nkurɔfo no wɔ bepɔw Gilead so. ");
INSERT INTO twi_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Saa da no ara anadwo, Onyankopɔn yii ne ho adi wɔ dae mu kyerɛɛ Aramni Laban. Ɔka kyerɛɛ no wɔ dae no mu se, “Hwɛ yiye na woankɔka asɛm biara; sɛ ɛyɛ asɛm pa anaa asɛmmɔne ankyerɛ Yakob.” ");
INSERT INTO twi_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Bere a Laban ne ne fifo kɔtoo Yakob no, na Yakob asisi ne ntamadan wɔ bepɔw Gilead atifi. Laban ne ne fifo no nso sisii wɔn ntamadan wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Na Laban kɔɔ Yakob nkyɛn kobisaa no se, “Asɛm bɛn na wode adi me yi? Woadaadaa me, akyekyere me mmabea de wɔn reguan te sɛ nnommumfo. ");
INSERT INTO twi_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Adɛn nti na wodaadaa me, na wuguan fii me nkyɛn a woankra? Sɛ wokraa me a, anka mɛto wo pon, na mama nnipa abɛbɔ sanku, ato nnwom wɔ aponto no ase, de agya wo kwan. ");
INSERT INTO twi_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Woamma mankyiakyia me nenanom ne me mmabea yi nsam annya wɔn kwan mpo. Woadi nkwaseasɛm. ");
INSERT INTO twi_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mewɔ tumi sɛ anka meyɛ wo bɔne, nanso nnɛra anadwo, Onyankopɔn a wo agya som no no ka kyerɛɛ me wɔ dae mu se, ‘Hwɛ yiye na woanka asɛm biara, sɛ ɛyɛ asɛm pa anaa asɛmmɔne ankyerɛ Yakob.’ ");
INSERT INTO twi_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Esiane sɛ wʼani agyina wʼagya fi nti, na ɛsɛ sɛ wokɔ ara. Na adɛn nti na wuwiaa mʼabosom de kaa wo nneɛma ho?” ");
INSERT INTO twi_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakob buaa Laban se, “Na misuro. Na ɛyɛ me sɛ wode tumi begye wo mmabea no afi me nsam. ");
INSERT INTO twi_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nanso obiara a wubehu wʼabosom no wɔ ne nkyɛn no, ɔsɛ owu. Wʼankasa hwehwɛ sɛ wubehu biribiara a ɛyɛ wo de wɔ me nneɛma yi mu wɔ yɛn nuanom yi anim. Sɛ wuhu biribiara a ɛyɛ wo de a, fa wʼade.” Bere a Yakob kaa saa asɛm yi no, na onnim sɛ Rahel na wawia nʼagya Laban abosom no. ");
INSERT INTO twi_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ɛno nti, Laban kɔɔ Yakob, Lea, ne nʼasomfo Bilha ne Silpa ntamadan mu kɔhwehwɛɛ hɔ, nanso wanhu biribiara. Afei, okowuraa Rahel ntamadan mu. ");
INSERT INTO twi_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Na Rahel awia abosom no de ahyehyɛ ne yoma no agua ase, atena so. Enti Laban kɔhwehwɛɛ nneɛma a ɛwɔ Rahel ntamadan no nyinaa mu, nanso wanhu abosom no. ");
INSERT INTO twi_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahel ka kyerɛɛ nʼagya se, “Agya, mma wo bo mfuw me sɛ mete hɔ wɔ wʼanim na mennsɔre nnyina hɔ, makɔ afikyiri.” Enti Laban toaa so hwehwɛɛ abosom no ara, nanso wanhu. ");
INSERT INTO twi_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ɛyɛɛ saa no, Yakob bo fuw Laban yiye, bisaa no se, “Bɔne bɛn na mayɛ? Amumɔyɛsɛm bɛn na madi a ɛno nti, woataa me ara yi?” ");
INSERT INTO twi_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Wohwehwɛɛ me nneɛma nyinaa mu yi, dɛn ade na wuhuu a ɛyɛ wo ne wo fifo de? Nea wuhuu biara no, fa bɛto gua wɔ me nuanom ne wo nuanom a wɔahyia ha yi nyinaa anim, na wɔnkyerɛ nea ɛyɛ ne de. ");
INSERT INTO twi_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Mfirihyia aduonu a wo ne me tenae, wo nguan ne wo mmirekyi abere no ampɔmpɔn, na mankum wʼadwennini yi bi amfi wo nguankuw yi mu anwe da. ");
INSERT INTO twi_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mamfa wʼaboa biara a akekaboa bi atetew ne mu ammrɛ wo; wɔn a mmoa kum wɔn no, mʼankasa mehyɛɛ anan mu. Afei sɛ ɛba sɛ wowia wo mmoa no bi, anadwo anaa awia a, woma mitua ka. ");
INSERT INTO twi_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Eyi ne tebea a na mewɔ mu: Meyɛɛ wʼadwuma awia maa owia hyee me ne anadwo maa awɔw dee me; nam so maa nna yera fii mʼaniwa mu. ");
INSERT INTO twi_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tebea a na mewɔ mu mfirihyia aduonu a metenaa wo nkyɛn no nyinaa ni. Mede mfirihyia dunan na ɛyɛɛ adwuma maa wo, de waree wo mmabea baanu no. Na mede mfirihyia asia nso hwɛɛ wo nguan, na wosesaa mʼakatua mpɛn du. ");
INSERT INTO twi_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Sɛ ɛnyɛ Onyankopɔn a mʼagya som no, Onyankopɔn a Abraham som no a ɔwɔ mʼafa ne suro a misuro mʼagya Isak a, anka nokware ni, wopam me maa mede me nsa pan kɔe. Nanso Onyankopɔn huu mʼamanehunu ne me nsa ano adwuma nti na nnɛra anadwo ɔkaa wʼanim no.” ");
INSERT INTO twi_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban buaa Yakob se, “Mmea no yɛ me mmabea, mmofra no nso yɛ me nenanom, na nguankuw no nso yɛ me nguankuw. Nneɛma a wuhu yi nyinaa yɛ me de. Ɛbɛyɛ dɛn na matumi ayɛ mʼankasa me mmabea ne me nenanom bɔne? ");
INSERT INTO twi_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Afei, bra na me ne wo nyɛ apam a ebedi me ne wo ntam adanse. Saa apam no so na yebedi wɔ yɛn asetena nyinaa mu.” ");
INSERT INTO twi_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Enti Yakob faa ɔbo de sii hɔ yɛɛ nkaedum. ");
INSERT INTO twi_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakob kyerɛɛ ne nuanom no se, “Montase abo!” Enti wɔtasee abo boaa ano, na wɔn nyinaa tenaa ho didii. ");
INSERT INTO twi_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban frɛɛ abo kuw no Yegar-Sahaduta a ne nkyerɛase ne Adanse Kuw. Yakob nso frɛɛ saa abo kuw no Gal-Ed, a ne nkyerɛase ne Adanse Kuw saa ara. ");
INSERT INTO twi_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban kae se, “Abo Kuw yi na edi me ne wo ntam adanse nnɛ!” Ɛno nti na wɔfrɛ no Gal-Ed no. ");
INSERT INTO twi_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Na wɔsan frɛ abo nkaedum no nso bio sɛ, “Mispa” efisɛ Laban kae se, “Awurade mmoa yɛn, na sɛ yɛn ntam tetew mpo a, yɛn mu biara bedi saa apam yi so. ");
INSERT INTO twi_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Sɛ woanhwɛ me mmabea yi yiye anaasɛ woware mmea foforo ka me mmabea yi ho a, ɛwɔ mu sɛ merenhu, nanso Onyankopɔn de, obehu.” ");
INSERT INTO twi_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban san ka kyerɛɛ Yakob se, “Abo Kuw yi ni. Nkaedum a mede asi me ne wo ntam no nso ni. ");
INSERT INTO twi_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Abo Kuw yi, ne nkaedum yi nyɛ adanse sɛ, me Laban, merentra saa Abo Kuw yi ne nkaedum yi mma baabi a wowɔ mmɛtoa wo. Na wo Yakob nso, worentra saa Abo kuw yi ne nkaedum yi mma baabi a mewɔ mmɛtoa me. ");
INSERT INTO twi_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ma Abraham Nyankopɔn ne Nahor Nyankopɔn, wɔn agyanom Nyankopɔn nyɛ otemmufo wɔ me ne wo ntam.” Enti Yakob de nʼagya Isak Nyankopɔn ho suro kaa ntam sɛ, ɔrentra ɔhye no. ");
INSERT INTO twi_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakob bɔɔ Onyankopɔn afɔre wɔ bepɔw no atifi, na ohyiahyiaa ne nnamfonom ma wobedidii. Ɛno akyi no, wɔdaa ne nkyɛn wɔ bepɔw no so. ");
INSERT INTO twi_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laban sɔree anɔpatutuutu few ne nenanom ne ne mmabea no ano, hyiraa wɔn. Na ɔsan nʼakyi kɔɔ ne kurom. ");
INSERT INTO twi_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakob nso toaa nʼakwantu no so. Onyankopɔn abɔfo behyiaa no. ");
INSERT INTO twi_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakob huu wɔn no, ɔkae se, “Ɛha yɛ Onyankopɔn fi!” Enti ɔtoo saa beae hɔ din “Mahanaim,” a ne nkyerɛase ne Onyankopɔn asase. ");
INSERT INTO twi_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakob somaa abɔfo dii nʼanim kɔɔ ne nua Esau nkyɛn wɔ Seir a ɛwɔ Edom asase so. ");
INSERT INTO twi_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Nkra a ɔde maa wɔn ni: “Monka nkyerɛ me wura Esau se, ‘Wʼakoa Yakob se, yɛn wɔfa Laban nkyɛn na makɔtena sɛ ɔhɔho ara de besi nnɛ yi. ");
INSERT INTO twi_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Nnɛ de, mewɔ anantwi ne mfurum, nguan ne mmirekyi, nkoa ne mfenaa bebree. Masoma mʼabɔfo yi aba wo, me wura nkyɛn, sɛ wɔmmɛka nkyerɛ wo se, mereba. Mewɔ anidaso nso sɛ, menya wʼanim anuonyam ama woagye me fɛw so.’ ” ");
INSERT INTO twi_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Asomafo no san baa Yakob nkyɛn no, wɔbɛka kyerɛɛ no se, “Yɛkɔɔ wo nua Esau nkyɛn kɔkaa wo nkra no kyerɛɛ no, na ose ɔreba abehyia wo, na mmarima ahannan na wɔka ne ho reba.” ");
INSERT INTO twi_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakob de ehu ne awerɛhow kyekyɛɛ nnipa a ɔne wɔn nam no ne mmoa no mu akuw abien. ");
INSERT INTO twi_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ɔkaa wɔ ne tirim se, “Sɛ ɛba sɛ Esau ne ne dɔm no ba bɛtow hyɛ kuw baako so a, kuw a ɛto so abien no betumi aguan.” ");
INSERT INTO twi_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Na Yakob bɔɔ Awurade mpae se, “Ao, Awurade Nyankopɔn a mʼagya Abraham ne mʼagya Isak som wo, Awurade a woka kyerɛɛ me se, ‘San kɔ wʼasase so ne wʼabusua mu, na mɛma woayɛ ɔdefo.’ ");
INSERT INTO twi_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Wʼadɔe a wode ayɛ me ne nokware a woadi wʼakoa no mu kakraa bi mpo, mfata me. Da a mifii fie kotwaa Asubɔnten Yordan no, na me pema nko ara na mikurae, nanso nnɛ, me na mikura dɔm ahorow abien yi. ");
INSERT INTO twi_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Mesrɛ wo, gye me fi me nua Esau nsam. Misuro sɛ ɔbɛtow ahyɛ me ne me yerenom ne me mma so. ");
INSERT INTO twi_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nanso wo na woahyɛ me bɔ se, ‘Nokware mu, mɛma woanya wo ho, na mama wʼase afɛe ayɛ sɛ mpoano nwea a wontumi nkan.’ ” ");
INSERT INTO twi_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Saa da no, ɔdaa hɔ. Na oyii nʼagyapade no bi sɛ akyɛde a ɔde bɛma ne nua Esau. ");
INSERT INTO twi_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Nneɛma no ni: Mmirekyibere ahannu, mpapo aduonu, nguanmmere ahannu, adwennini aduonu. ");
INSERT INTO twi_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Yomabere aduasa ne wɔn mma, anantwibere aduanan, anantwinini du, mfurummmere aduonu, mfurumnini du. ");
INSERT INTO twi_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ɔkyekyɛɛ mmoa no mu akuwakuw, de maa nʼasomfo a kuw baako biara hyɛ ɔsomfo baako nsa. Ɔka kyerɛɛ nʼasomfo no se, “Munni mʼanim nkɔ, na mmom, momma akwan nneda mmoa akuwakuw no ntam.” ");
INSERT INTO twi_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yakob san ka kyerɛɛ nʼasomfo a wodi kan no se, “Sɛ me nua Esau hyia mo, na obisa mo se, ‘Hena asomfo ne mo, mufi he na morekɔ he na hena mmoa na mode wɔn nam yi a?’ ");
INSERT INTO twi_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Monka nkyerɛ no se, ‘Mmoa no yɛ wʼakoa Yakob de. Ne nyinaa yɛ akyɛde a ɔde rebrɛ ne wura Esau, na nʼankasa di akyi reba.’ ” ");
INSERT INTO twi_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Saa ara nso na Yakob ka kyerɛɛ nʼasomfo a wɔto so abien, abiɛsa ne wɔn a wodidi so a wɔde mmoa no rekɔ no se, “Sɛ muhyia Esau a, monka saa asɛm koro no ara nkyerɛ no. Monka nka ho se, ");
INSERT INTO twi_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘Wʼakoa Yakob ankasa di yɛn akyi reba.’ ” Efisɛ na Yakob ayɛ nʼadwene sɛ, “Mede akyɛde ahorow a mede asoma adi kan yi bɛpata no, na sɛ akyiri yi ohu me a, wagye me ato mu.” ");
INSERT INTO twi_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Enti wɔde Yakob akyɛde ahorow no dii kan kɔe. Na ɔno ankasa de, ɔdaa nʼatenae hɔ anadwo no. ");
INSERT INTO twi_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Anadwo no ara, Yakob sɔre faa ne yerenom baanu ne ne mfenaa baanu no ne ne mma dubaako no, de wɔn twaa Asubɔnten Yordan wɔ Yabok asutwabea hɔ. ");
INSERT INTO twi_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ɔde wɔn twaa asubɔnten no wiee no, ɔsan bɛfaa nʼagyapade a aka nyinaa de twaa asu no. ");
INSERT INTO twi_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Enti ɛkaa Yakob nko ara wɔ nʼatenae hɔ. Anadwo no, obi ne no bɛtentamee ara kosii adekyee wɛɛ. ");
INSERT INTO twi_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Bere a ɔbarima a ɔne no tentamee no huu sɛ ɔrentumi nni Yakob so no, ɔbɔɔ Yakob dwonku ma ehuanee. ");
INSERT INTO twi_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Na ɔbarima no ka kyerɛɛ Yakob se, “Ade akye nti, gyaa me ma menkɔ.” Nanso Yakob buaa no se, “Sɛ woanhyira me a, meremma wo nkɔ.” ");
INSERT INTO twi_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ɔbarima no bisaa Yakob se, “Wo din de dɛn?” Obuae se, “Me din de Yakob.” ");
INSERT INTO twi_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ɔbarima no kae se, “Efi nnɛ, wɔremfrɛ wo Yakob bio, na mmom wɔbɛfrɛ wo Israel. Efisɛ wo ne Onyankopɔn ne nipa atentam, na woadi nkonim.” ");
INSERT INTO twi_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakob bisae se, “Mesrɛ wo, wɔfrɛ wo dɛn?” Ɔbarima no nso bisaa no se, “Adɛn nti na worebisa me din?” Na ohyiraa Yakob wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ɛmaa Yakob too beae hɔ din Peniel, a ne nkyerɛase ne “Onyankopɔn Anim.” Na ɔkae se, “Mahu Onyankopɔn anikann, nanso meda so te nkwa mu.” ");
INSERT INTO twi_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakob refi Penuel no na owia agyina. Esiane ne dwonku a na ahuan no nti, na ɔka ne nan mu. ");
INSERT INTO twi_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ɛno nti na ebesi nnɛ yi, Israelfo nwe aboa dwonku koraa sɛ nkae ade no; efisɛ saa ntin kɛse a ɛwɔ Yakob dwonku no na ɔbarima a ɔne no tentamee no bɔe, maa dwonku no huanee no. ");
INSERT INTO twi_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakob maa nʼani so na ohuu sɛ Esau ne ne mmarima ahannan a wɔka ne ho no fi akyirikyiri reba. Enti ɔkyekyɛɛ ne mma no mu maa Lea, Rahel ne nʼasomfo baanu no. ");
INSERT INTO twi_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ɔmaa asomfo no ne wɔn mma dii kan. Lea ne ne mma nso dii hɔ; na Rahel ne ne ba Yosef nso dii akyi. ");
INSERT INTO twi_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakob de, odii wɔn anim. Ɔreyɛ abɛn ne nua Esau no, ɔbɔɔ ne mu ase mpɛn ason. ");
INSERT INTO twi_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau tuu mmirika kohyiaa Yakob, yɛɛ no atuu. Ɔbam Yakob, few nʼano. Na wɔn baanu nyinaa sui. ");
INSERT INTO twi_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Na Esau maa nʼani so huu mmea no ne mmofra no. Obisaa Yakob se, “Eyinom yɛ hefo.” Obuae se, “Wɔyɛ mma a Onyankopɔn de wɔn adom me a meyɛ wʼakoa no.” ");
INSERT INTO twi_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Na Yakob asomfo ne wɔn mma twiw bɛn Esau bɛkotow no. ");
INSERT INTO twi_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Saa ara na Lea ne ne mma nso bɛkotow no. Na Yosef ne ne na Rahel nso ba bɛkotow no. ");
INSERT INTO twi_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau bisae se, “Nguan ne anantwi ne mmoa bebrebe a wɔsa so reba yi nso ase ne dɛn?” Yakob buae se, “Me wura, ɛyɛ akyɛde a mede rebrɛ wo, na manya wʼanim anuonyam.” ");
INSERT INTO twi_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Nanso Esau buaa no se, “Me nua, mewɔ saa mmoa yi bebree ma ɛboro so. Enti fa nea wode rebrɛ me yi ka wo de ho.” ");
INSERT INTO twi_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakob kae se, “Dabi, sɛ woagye me fɛw so de a, mesrɛ wo, gye akyɛde a mede rebrɛ wo yi. Nokware ni, esiane sɛ wugyee me ɔdɔ so nti, mihuu wʼanim no, na ayɛ me sɛnea mahu Onyankopɔn anim. ");
INSERT INTO twi_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Mesrɛ wo, gye mʼakyɛde a mede rebrɛ wo yi, efisɛ Awurade adom me ama mayɛ ɔdefo.” Esiane sɛ Yakob kɔɔ so srɛɛ no ara sɛ onnye nʼakyɛde no nti, Esau gyei. ");
INSERT INTO twi_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Na Esau kae se, “Ma yɛnkɔ. Yebedi mo anim ne mo akɔ.” ");
INSERT INTO twi_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Nanso Yakob buaa no se, “Me wura ankasa nim sɛ mmofra no bi susua. Ɛsɛ sɛ mehwɛ anantwi ne nguan ne mmoa a wɔawowo no nso ka wɔn brɛoo. Sɛ meka wɔn so da koro pɛ mpo a, wɔn nyinaa bewuwu. ");
INSERT INTO twi_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Enti me wura, di yɛn kan na yɛne nyɛmmoa no bedi wʼakyi nkakrankakra abɛto wo wɔ Seir.” ");
INSERT INTO twi_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Enti Esau kae se, “Ɛno de, ma minnyaw me mmarima no bi mma wo.” Yakob kae se, “Adɛn na woyɛ saa? Me wura, ma minya wʼanim anuonyam kɛkɛ.” ");
INSERT INTO twi_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Enti da no ara, Esau san nʼakyi kɔɔ Seir. ");
INSERT INTO twi_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Nanso Yakob de, ɔkɔɔ Sukot kosisii ne ntamadan, pɛɛ baabi a ne mmoa no nso bɛda, de hɔ yɛɛ nʼatenae. Ɛno nti na wɔfrɛ saa beae hɔ Sukot, a ne nkyerɛase ne Asese no. ");
INSERT INTO twi_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakob fii Paddan-Aram no, okoduu Sekem kurow a ɛwɔ Kanaan asase so no mu asomdwoe mu. ");
INSERT INTO twi_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yakob tɔɔ asase a ɔtenaa so no dwetɛ mpɔw ɔha fii Sekem agya Hamormma nkyɛn. ");
INSERT INTO twi_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Wosii afɔremuka wɔ hɔ, too saa afɔremuka no din El-Elohe-Israel, a ne nkyerɛase ne Onyankopɔn, Israel Nyankopɔn Afɔremuka. ");
INSERT INTO twi_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Da koro bi, Lea ne Yakob ba Dina fii adi kɔsraa mmabaa a wɔwɔ wɔn mpɔtam hɔ no. ");
INSERT INTO twi_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Bere a Hewifohene Hamor babarima Sekem huu Dina no, ɔkyeree no kɔtoo no mmonnaa. ");
INSERT INTO twi_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Efi saa bere no, Sekem tuu nʼani sii Yakob ba Dina so. Ɔbɔɔ mmɔden ara sɛ ɔne no bɛkasa ama wapene so, na waware no. ");
INSERT INTO twi_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ɛno nti, Sekem dii ho nkɔmmɔ kyerɛɛ nʼagya Hamor se, “Mepɛ sɛ meware ababaa yi, enti kɔka ne ho asɛm ma me!” ");
INSERT INTO twi_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Bere a Yakob tee sɛ Sekem akɔkyere ne babea Dina akɔto no mmonnaa no, na ne mmabarima no nyinaa ne wɔn agya anantwi wɔ wuram. Enti Yakob anka hwee kosii sɛ wɔbae. ");
INSERT INTO twi_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sekem nʼagya Hamor kɔɔ Yakob nkyɛn ne no kodii nkɔmmɔ. ");
INSERT INTO twi_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yakob mmabarima no tee wɔn nuabea Dina ho asɛm no pɛ, wofii wuram hɔ bae. Wɔn werɛ howee na wɔn bo nso fuw yiye, efisɛ Sekem ayɛ aniwude wɔ Israel. Ɔne Yakob babea dae, na eyi yɛ akyiwade. ");
INSERT INTO twi_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Nanso Hamor ka kyerɛɛ Yakob se, “Me ba Sekem ani gye wo ba Dina ho. Mesrɛ wo, fa no ma no na ɔnware no. ");
INSERT INTO twi_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mo ne yenni aware. Momfa mo mmabea mma yɛn, na yɛnware wɔn, na yɛn nso, yɛmfa yɛn mmabea mma mo aware. ");
INSERT INTO twi_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mubetumi ne yɛn atena. Asase yi nyinaa yɛ mo dea. Montena so, nni gua wɔ so, mpɛ mu agyapade.” ");
INSERT INTO twi_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Na Sekem ka kyerɛɛ Dina nʼagya ne ne nuabarimanom no se “Munnye me nto mu. Biribiara a mubegye me no, metua. ");
INSERT INTO twi_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ɔbea no ti ade ne biribiara a mubegye aka ho no, mommɔ bo biara a mopɛ, na metua. Nea ehia me ara ne sɛ, mode ababaa no bɛma me aware.” ");
INSERT INTO twi_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Esiane sɛ na Sekem agu wɔn nuabea Dina ho fi no nti, mmuae a wɔmaa Sekem ne nʼagya Hamor no anyɛ nokware. Na mmom, na wɔwɔ adwene foforo bi wɔ akyi. ");
INSERT INTO twi_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Yakob mmabarima no ka kyerɛɛ Sekem ne nʼagya Hamor se, “Yɛrentumi mfa yɛn nuabea mma ɔbarima a ontwaa twetia aware. Sɛ yɛyɛ saa a, na yɛagu yɛn ho anim ase. ");
INSERT INTO twi_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ansa na yɛde yɛn nuabea bɛma wo aware no, gye sɛ woatwitwa wo mmarima nyinaa twetia te sɛ yɛn. ");
INSERT INTO twi_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Sɛ moyɛ saa de a, yɛne mo bedi aware. Mobɛware yɛn mmea, na yɛn nso, yɛaware mo mmea. Yɛne mo bɛtena fɛfɛɛfɛ sɛ nnipa baako. ");
INSERT INTO twi_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Sɛ moampene so amma wɔantwitwa mo twetia de a, yebegye yɛn nuabea de no akɔ.” ");
INSERT INTO twi_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Asɛm a wɔkae no tɔɔ Hamor ne ne ba Sekem asom. ");
INSERT INTO twi_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sekem a na ɔyɛ aberante a odi mu wɔ nʼagya mma nyinaa mu no antwentwɛn ne nan ase koraa. Okotwaa twetia no, sɛnea Yakob mma no kae no, efisɛ na ɔpɛ Yakob babea no yiye. ");
INSERT INTO twi_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Enti Hamor ne ne ba Sekem kɔbɔɔ gua wɔ kurow no pon ano ne ɛhɔ mmarima kɔkasae se, ");
INSERT INTO twi_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Yakob ne ne mma yi ne yɛn te yiye. Mompene so na wɔne yɛn ntena yɛn asase yi so, na yenni gua. Efisɛ yɛn asase yi so a yɛne wɔn bɛsen so. Yebetumi aware wɔn mmabea, na wɔn nso betumi aware yɛn de. ");
INSERT INTO twi_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nanso ansa na wɔn mmarima no bɛpene so ne yɛn atena sɛ nnipa koro no, gye sɛ yɛn mmarima nyinaa twitwa twetia, sɛnea wɔn nso wɔatwitwa twetia no. ");
INSERT INTO twi_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Sɛ ɛba saa a, wɔn mmoa, wɔn agyapade ne wɔn mmoa ahorow a ɛkeka ho no nyinaa remmɛyɛ yɛn de ana? Enti momma yɛmpene so mma wɔn, na yɛne wɔn ntena.” ");
INSERT INTO twi_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Mmarima a wokohyiaa Hamor ne ne ba Sekem wɔ kurow no pon ano no nyinaa ne wɔn yɛɛ adwene maa mmarima a wɔwɔ kurom hɔ nyinaa twitwaa twetia. ");
INSERT INTO twi_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Nnansa akyi a na twetiatwa no nti, kurom hɔ mmarima no nyinaa deda hɔ a wogye wɔn ho a ennye no, Yakob mmabarima baanu Simeon ne Lewi a wɔyɛ Dina nuabarimanom no faa wɔn mpeaw. Wɔkɔtow hyɛɛ kurow no so bere a wɔn ani nna wɔn ho so, kunkum mmarima a wɔwɔ kurom hɔ nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Wɔde peaw kum Hamor ne ne ba Sekem, na wɔfaa wɔn nuabea Dina fii Sekem fi de no kɔɔ wɔn nkyɛn. ");
INSERT INTO twi_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yakob mmabarima a wɔaka no nso tow hyɛɛ kurow no so. Wotiatiaa nnipa a wɔawuwu no so, fom kurow no mu nneɛma nyinaa pasaa, efisɛ ɛhɔ na Sekem guu wɔn nuabea Dina ho fi. ");
INSERT INTO twi_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Wɔfom wɔn mmoa, wɔn anantwi, wɔn nguan, wɔn mfurum ne wɔn agyapade biara a ɛwɔ kurow no mu ne nea ɛwɔ wuram nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Wɔfaa wɔn ahode, wɔn yerenom ne wɔn mmea, fom wɔn afi mu nneɛma nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Na Yakob ka kyerɛɛ Simeon ne Lewi se, “Mode ɔhaw abɛto me so, ama nnɛ me ho koraa abɔn Perisifo ne Kanaanfo a mete wɔn asase so yi. Yɛnnɔɔso. Sɛ wɔka wɔn ho bo mu bɛtow hyɛ yɛn so a, wɔbɛhyew me ne mʼasefo nyinaa.” ");
INSERT INTO twi_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Na wobuaa wɔn agya se, “Enti anka yɛntena hɔ nhwɛ na ɔnyɛ yɛn nuabea sɛ oguamanfo ana?” ");
INSERT INTO twi_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Na Onyankopɔn ka kyerɛɛ Yakob se, “Kɔ Bet-El kɔtena hɔ. Sɛ wudu hɔ a, si afɔremuka ma me. Me na miyii me ho adi kyerɛɛ wo bere a na woreguan afi wo nua Esau nkyɛn no.” ");
INSERT INTO twi_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Enti Yakob ka kyerɛɛ ne fifo ne wɔn a wɔka ne ho nyinaa se, “Monsɛe mo anyame a mode wɔn fi amannɔne bae no nyinaa. Munnwira mo ho, na monsesa mo ntade nso.” ");
INSERT INTO twi_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ɔtoaa so se, “Yɛrebetu kwan akɔ Bet-El. Na sɛ yedu hɔ a, yebesi afɔremuka ama Onyankopɔn a otiee me mpaebɔ wɔ mʼamanehunu mu, na ɔkaa me ho wɔ mʼakwantu mu no.” ");
INSERT INTO twi_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Enti wɔn nyinaa de wɔn ahoni ne asokaa maa Yakob. Yakob tuu fam wɔ odum bi ase wɔ Sekem, de ne nyinaa hyɛɛ hɔ. ");
INSERT INTO twi_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Na wosii mu. Wɔrekɔ no, Onyankopɔn bɔɔ nkurow a wɔfaa so no nyinaa mu nnipa no hu a ɛno nti obiara antumi antaa wɔn. ");
INSERT INTO twi_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakob ne ne nkurɔfo a wɔka ne ho no beduu Lus a ɛno ara ne Bet-El a ɛwɔ Kanaan asase so no. ");
INSERT INTO twi_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Osii afɔremuka wɔ hɔ, too hɔ din El-Bet-El, efisɛ ɛhɔ na bere a ɔreguan afi ne nua Esau nkyɛn no, Onyankopɔn yii ne ho adi kyerɛɛ no. ");
INSERT INTO twi_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Eyi akyi no, Debora a ɔyɛ Rebeka bagyigyefo no wu ma wosiee no wɔ odum bi a ɛwɔ Bet-El bon mu no ase. Efi saa bere no, wɔtoo beae hɔ din Alon-Bakut, a ne nkyerɛase ne Agyaadwotwa Dum. ");
INSERT INTO twi_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakob fi Paddan-Aram beduu Bet-El no, Onyankopɔn san yii ne ho adi kyerɛɛ no, hyiraa no. ");
INSERT INTO twi_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Onyankopɔn ka kyerɛɛ no se, “Ɛwɔ mu sɛ wɔfrɛ wo Yakob de, nanso efi nnɛ, wɔremfrɛ wo Yakob bio, na mmom, wɔbɛfrɛ wo Israel a ne nkyerɛase ne Onipa a ɔne Onyankopɔn adi asi.” Enti Onyankopɔn too ne din se Israel. ");
INSERT INTO twi_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Onyankopɔn ka kyerɛɛ Yakob se, “Mene Onyankopɔn tumfo no. Wʼase nnɔ, na wʼase mfɛe. Ɔman ne aman asafo befi wo mu aba. Saa ara na ahemfo nso befi wo mu aba. ");
INSERT INTO twi_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mede asase a mede maa Abraham ne Isak no bɛma wo. Yiw, mede saa asase koro yi ara bɛma wʼasefo.” ");
INSERT INTO twi_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Na Onyankopɔn fii faako a na ɔne Yakob rekasa hɔ no kɔɔ ɔsoro. ");
INSERT INTO twi_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakob sii ɔbodum wɔ hɔ, hwiee afɔresa guu so, de bɔɔ Onyankopɔn afɔre. Ɔsan de afɔrengo sraa odum no ho. ");
INSERT INTO twi_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakob too beae a Onyankopɔn ne no kasae no Bet-El, a ne nkyerɛase ne Onyankopɔn fi. ");
INSERT INTO twi_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakob ne ne fifo sii mu fii Bet-El, de wɔn ani kyerɛɛ Efrat. Wɔrekɔ no, awo kaa Rahel wɔ akwantemfi. ");
INSERT INTO twi_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Bere a ɔreko awo no, ɔbea ɔwogyefo no ka kyerɛɛ no se, “Nsuro na worebɛwo ɔbabarima bio.” ");
INSERT INTO twi_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Nanso Rahel koo awo tɔe. Na bere a ne kra refi ne mu na ɔreyɛ awu no, ɔtoo ne babarima a wawo no no din Ben-Oni, a ne nkyerɛase ne Mʼawerɛhow Mu Ba. “Nanso nʼagya san too no din Benyamin a, ne nkyerɛase ne Me dɔba.” ");
INSERT INTO twi_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rahel wu ma wosiee no Efrat a ɛno ara ne Betlehem no akwantemfi. ");
INSERT INTO twi_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakob yɛɛ nkaedum sii Rahel da no so a ɛda so wɔ hɔ besi nnɛ. ");
INSERT INTO twi_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel toaa nʼakwantu no so, kosii ne ntamadan wɔ Edir abantenten no akyi nohɔ baabi. ");
INSERT INTO twi_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Bere a Israel te saa asase no so no, ɔtee sɛ ne ba panyin Ruben ne Bilha a ɔyɛ nʼagya afenaa a waware no no akɔda. Na Yakob wɔ mmabarima dumien: ");
INSERT INTO twi_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea mma na wɔn din didi so yi: Ruben a ɔno ne Israel abakan, Simeon, Lewi, Yuda, Isakar ne Sebulon. ");
INSERT INTO twi_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel nso mmabarima baanu no ne Yosef ne Benyamin. ");
INSERT INTO twi_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel afenaa Bilha mmabarima baanu no ne Dan ne Naftali ");
INSERT INTO twi_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea afenaa Silpa nso mmabarima baanu no ne Gad ne Aser. Eyinom ne Yakob mmabarima a wɔwoo wɔn wɔ Paddan-Aram no. ");
INSERT INTO twi_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Akyiri yi no, Yakob baa nʼagya Isak nkyɛn wɔ Mamrɛ wɔ Kiriat-Arba, a ɛno ara ne Hebron, faako a Abraham ne Isak tenaa sɛ ahɔho no. ");
INSERT INTO twi_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isak dii mfe ɔha ne aduɔwɔtwe. ");
INSERT INTO twi_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isak wu ma wɔfaa no kɔkaa ne mpanyimfo ho; na wabɔ akwakoraa posoposo. Ne mmabarima Esau ne Yakob na wosiee no. ");
INSERT INTO twi_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Eyinom ne Esau a wɔfrɛ no Edom no asefo. ");
INSERT INTO twi_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau waree Kanaanfo mmea baasa. Wɔn din de Ada a ɔyɛ Hetini Elon babea, Ana babea Oholibama a ɔsan yɛ Hewini Sibeon nena ne ");
INSERT INTO twi_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basmat a ɔyɛ Ismael babea na ɔyɛ Nebaiot nuabea. ");
INSERT INTO twi_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada woo Elifas maa Esau. Basmat woo Reuel. ");
INSERT INTO twi_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama nso woo Yeus, Yalam ne Kora. Saa nnipa a wɔabobɔ wɔn din yi ne mmabarima a Esau yerenom baasa no wowoo wɔn maa no wɔ Kanaan asase so no. ");
INSERT INTO twi_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau faa ne yerenom, ne mmabarima, ne mmabea, ne fifo nyinaa, ne nyɛmmoa ne mmoa a aka nyinaa ne nʼagyapade biara a ɔbrɛ nyaa no wɔ Kanaan asase so nyinaa, tu fii ne nua Yakob nkyɛn, kɔɔ asase bi so wɔ akyirikyiri. ");
INSERT INTO twi_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Efisɛ na wɔn ahonyade no dɔɔso sɛ ɔne ne nua Yakob betumi atena faako. Na wɔn mmoa dodow nti, wɔn baanu no nsen asase a wɔte so no so. ");
INSERT INTO twi_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ɛno nti, Esau a wɔfrɛ no Edom no, kɔbɔɔ nʼatenae wɔ Seir bepɔw so. ");
INSERT INTO twi_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Eyinom ne Esau a ɔyɛ Edomfo agya no asefo a wɔwoo wɔn maa no bere a na ɔwɔ Seir bepɔw so no. ");
INSERT INTO twi_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau mmabarima no din na edidi so yi: Elifas, a ɔyɛ Esau yere panyin Ada babarima ne Reuel a ɔyɛ Basmat babarima. ");
INSERT INTO twi_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifas nso mmabarima din na edidi so yi: Teman, Omar, Sefo, Gatam ne Kenas. ");
INSERT INTO twi_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Na Esau babarima Elifas nso wɔ mpena bi a ne din de Timna a ɔne no woo ba a wɔfrɛ no Amalek. Din a wɔabobɔ yi yɛ Esau yere Ada nenanom. ");
INSERT INTO twi_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel mmabarima din na edidi so yi: Nahat, Serah, Sama ne Misa. Saa din a wɔabobɔ yi yɛ Esau yere Basmat nso nenanom. ");
INSERT INTO twi_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau yere Oholibama a ɔyɛ Ana babea, na ɔsan yɛ Sibeon nena no mmabarima a ɔwoo wɔn maa Esau no ne eyinom: Yeus, Yalam ne Kora. ");
INSERT INTO twi_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Eyinom ne Esau asefo no mu atitiriw: Elifas a ɔyɛ Esau abakan no nso mmabarima din na edidi so yi: Atitiriw Teman, Omar, Sefo, Kenas, ");
INSERT INTO twi_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam ne Amalek. Saa din a wɔabobɔ yi ne Elifas a ɔyɛ Esau abakan no asefo atitiriw a wɔwowoo wɔn wɔ Edom asase so. Na saa atitiriw yi yɛ Ada nenanom. ");
INSERT INTO twi_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau babarima Reuel mmabarima din na edidi so yi: Otitiriw Nahat, Otitiriw Serah, Otitiriw Sama ne Otitiriw Misa. Saa din a wɔabobɔ yi ne Reuel a ɔyɛ Esau ba a ɔto so abien no nnipa atitiriw a wɔwoo wɔn wɔ Edom asase so. Na wɔyɛ Esau yere Basmat nenanom. ");
INSERT INTO twi_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau yere Oholibama mmabarima din na edidi so yi: Otitiriw Yeus, Otitiriw Yalam ne Otitiriw Kora. Saa din a wɔabobɔ yi ne Esau yere Oholibama a ɔyɛ Ana babea no asefo nnipa atitiriw no. ");
INSERT INTO twi_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Saa din a wɔabobɔ yi ne Esau a ɔno ara ne Edom no mmabarima. Wɔn ara nso na wɔyɛ wɔn nnipa atitiriw no. ");
INSERT INTO twi_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Eyinom ne Horini Seir mmabarima a na saa bere no wɔtete Seir asase so no: Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO twi_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eser ne Disan. Saa nnipa a wɔabobɔ wɔn din yi ne Horini Seir mmabarima a na wɔtete Edom asase so no nnipa atitiriw no. ");
INSERT INTO twi_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan mmabarima ne eyinom: Hori ne Homam. Na Timna yɛ Lotan nuabea. ");
INSERT INTO twi_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal nso mmabarima ne eyinom: Alwan, Manahat, Ebal, Sefo ne Onam. ");
INSERT INTO twi_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Na eyinom ne Sibeon mmabarima: Aya ne Ana. Saa Ana yi ne abarimaa a, bere bi ɔde nʼagya Sibeon mfurum kɔɔ adidi wɔ sare no so a okohuu asu aniwa bi a na nsuɔhyew fi mu ba no. ");
INSERT INTO twi_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana mma ni: Dison ne Oholibama a ɔyɛ Ana babea no. ");
INSERT INTO twi_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disan mmabarima ni: Hemdan, Esban, Yitran ne Keran. ");
INSERT INTO twi_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser mmabarima ne eyinom: Bilhan, Saawan ne Akan. ");
INSERT INTO twi_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Eyinom ne Disan mma: Us ne Aran. ");
INSERT INTO twi_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Eyinom ne Horifo nnipa atitiriw: Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO twi_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disan, Eser ne Disan. Saa nnipa a wɔabobɔ wɔn din yi ne Horifo nnipa atitiriw a bere a na wɔwɔ Seir asase so no, wodii wɔn mmusua no so. ");
INSERT INTO twi_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Eyinom ne nnipa a wodii kan dii hene wɔ Edom asase so ansa na Israelni biara rebedi Israelmma so hene: ");
INSERT INTO twi_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela a ɔyɛ Beor babarima bedii hene wɔ Edom asase so. Na nʼahenkurow din de Dinhaba. ");
INSERT INTO twi_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Na Bela wui no, Serah babarima Yobab a ofi Bosra bedii nʼade sɛ ɔhene. ");
INSERT INTO twi_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Na Yobab wui no, Husam a ofi Teman asase so bedii nʼade sɛ ɔhene. ");
INSERT INTO twi_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam wu akyi Hadad a ɔyɛ Bedad babarima a okodii Midian so nkonim wɔ Moab asase so no na odii nʼade sɛ ɔhempɔn. Wɔtoo nʼahenkurow no din Hawit. ");
INSERT INTO twi_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad wui no, Samla a ofi Masreka kuropɔn mu bɛyɛɛ ɔhene. ");
INSERT INTO twi_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla wui no, Saulo a ofi Rehobot a ɛda asu Eufrate ho no bedii hene. ");
INSERT INTO twi_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Na Saulo wui no, Akbor babarima Baal-Hanan bedii hene. ");
INSERT INTO twi_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akbor babarima Baal-Hanan nso wui no, Hadad bedii nʼade, tenaa nʼahengua so sɛ ɔhempɔn. Na ɔhene Hadad ahenkurow no din de Pau, na ne yere nso din de Mehetabel a ɔyɛ Me-Sahab babea a ɔno nso yɛ Matred babea. ");
INSERT INTO twi_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Sɛnea wɔn a wodidi so yi a wɔyɛ Esau asefo no mmusua ne wɔn tenabea te ni: Timna abusua, Alwa abusua, Yetet abusua, ");
INSERT INTO twi_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama abusua, Ela abusua, Pinon abusua, ");
INSERT INTO twi_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas abusua, Teman abusua, Mibsar abusua, ");
INSERT INTO twi_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel abusua ne Iram abusua. Eyinom ne Edom mmusua a wɔde wɔn atenae no din totoe. Na wɔn nyinaa yɛ Edomfo a wɔyɛ Esau asefo. ");
INSERT INTO twi_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yosef tenaa Kanaan asase a na nʼagya te so sɛ ɔhɔho no so. ");
INSERT INTO twi_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yosef abusua ho asɛm ni: Bere a Yakob ba Yosef dii mfirihyia dunson no, na ɔboa ne nuanom a wɔyɛ Bilha ne Silpa a wɔyɛ nʼagya yerenom no mmabarima no hwɛ wɔn agya nguan so. Na ɔtaa bɛka nneyɛe bɔne a ɛkɔ so fa ne nuanom no ho no kyerɛ wɔn agya. ");
INSERT INTO twi_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Na Israel pɛ ne ba Yosef asɛm sen ne mma a wɔaka no nyinaa, efisɛ ɔwoo no ne nkwakoraabere mu; ɛno nti, ɔpam batakari bi a ɛyɛ fɛ maa no. ");
INSERT INTO twi_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Bere a ne nuanom no huu sɛ wɔn agya pɛ nʼasɛm sen wɔn nyinaa no, wɔtan no a na wɔnka abodwosɛm nkyerɛ no. ");
INSERT INTO twi_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Da bi, Yosef soo dae. Ɔkaa dae a ɔsoo no kyerɛɛ ne nuanom mmarima no, wɔtan no sen kan no mpo. ");
INSERT INTO twi_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yosef ka kyerɛɛ ne nuanom no se, “Muntie dae bi a maso. ");
INSERT INTO twi_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Mesoo dae, na yɛrekyekyere aburow afiafi wɔ afum. Bere a yegu so rekyekyere aburow no, amono mu hɔ ara, mʼafiafi a makyekyere no sɔre gyinaa ntenten. Mo afiafi a moakyekyere no nso twaa me de no ho hyia kotow no.” ");
INSERT INTO twi_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Yosef nuanom no bisaa no se, “Enti wʼadwene ne sɛ wubedi yɛn so ana? Wugye di sɛ, ampa ara, wubetumi aka yɛn ahyɛ?” Esiane ne dae a ɔsoo no ne asɛm a ɔkae no nti, ɛmaa ne nuanom no kyii no kɔkɔɔkɔ. ");
INSERT INTO twi_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Na ɔsoo dae bio. Ɔkaa dae a ɔsoo no kyerɛɛ ne nuanom no se, “Muntie: Maso dae foforo bio. Mesoo dae, na owia, ɔsram ne nsoromma dubaako rekotow me.” ");
INSERT INTO twi_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ɔkaa dae no kyerɛɛ nʼagya ne ne nuabarimanom no, nʼagya kaa nʼanim se, “Dae bɛn na woaso yi? Wopɛ sɛ wokyerɛ sɛ ampa ara, wo na ne me ne wo nuabarimanom no bɛba abɛkotow wo ana?” ");
INSERT INTO twi_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Eyi maa ne nuabarimanom no ani beree no mmoroso. Nanso nʼagya de, ɔdwenee asɛm no ho kɔɔ akyiri. ");
INSERT INTO twi_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Da bi, Yosef nuabarimanom no de wɔn agya nguan kɔɔ adidi wɔ Sekem. ");
INSERT INTO twi_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israel ka kyerɛɛ Yosef se, “Sɛnea wunim no, wo nuanom no de mmoa no kɔ adidi wɔ Sekem. Bra, na mensoma wo wɔn nkyɛn.” Yosef buae se, “Yoo, agya, mate.” ");
INSERT INTO twi_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Enti Israel ka kyerɛɛ Yosef se, “Kɔ na kɔhwɛ sɛ wo nuanom ne nguan no ho te dɛn, na san bɛka biribi kyerɛ me.” Enti Israel somaa Yosef fii Hebron subon no mu. Bere a Yosef duu Sekem no, ");
INSERT INTO twi_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ɔbarima bi huu no sɛ ɔnenam wura no mu. Ɔbarima no bisaa no se, “Worehwehwɛ dɛn?” ");
INSERT INTO twi_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yosef buaa no se, “Merehwehwɛ me nuabarimanom. Mesrɛ wo, wubetumi akyerɛ me baabi a wɔde wɔn nguan no kɔ adidi?” ");
INSERT INTO twi_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ɔbarima no buaa no se, “Wo nuabarimanom no afi ha kɔ. Metee sɛ wɔreka se, ‘Momma yɛnkɔ Dotan.’ ” Enti Yosef tiw ne nuanom no, kɔtoo wɔn wɔ Dotan hɔ. ");
INSERT INTO twi_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Bere a Yosef puei no, wohuu no wɔ akyirikyiri sɛ ɔreba. Ansa na ɔredu wɔn nkyɛn no, wɔbɔɔ ne ho pɔw sɛ wobekum no. ");
INSERT INTO twi_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Wɔkeka kyerɛkyerɛɛ wɔn ho wɔn ho se, “Monhwɛ! Ɔdaesofo no na ɔreba no! ");
INSERT INTO twi_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mommra mprempren ara mma yenkum no, na yɛntow no nkyene amoa no bi mu, na yɛnkɔka nkyerɛ yɛn agya se, aboa bi akyere no awe, na yɛnhwɛ sɛ biribi befi ne dae ahorow no mu aba ana.” ");
INSERT INTO twi_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben a ɔyɛ wɔn nua panyin tee saa asɛm no, ɔbɔɔ mmɔden sɛ obegye Yosef nkwa. Ɔkae se, “Mommma yenkum no. ");
INSERT INTO twi_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Munnhwie mogya ngu. Momma yɛntow no nkyene amoa a ɛwɔ sare yi so no bi mu. Na mommma yɛmfa yɛn nsa nka no.” Ruben kaa saa asɛm yi de gyee no fii wɔn nsam, sɛnea obenya kwan de no akɔhyɛ wɔn agya nsa. ");
INSERT INTO twi_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yosef beduu ne nuabarimanom no nkyɛn no, wɔworɔw ne batakari fɛfɛ a na ɔhyɛ no, ");
INSERT INTO twi_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","na wɔtow no kyenee amoa bi mu. Na nsu biara nni amoa no mu. ");
INSERT INTO twi_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Bere a anuanom no tenaa ase sɛ wɔredidi no, wɔtoo wɔn ani huu sɛ yoma bebree sa so reba faako a na wɔrebedidi hɔ no. Wohuu sɛ saa nkurɔfo no yɛ Ismaelfo aguadifo bi a wɔsoso atomude, akyenkyennuru ne kurobow a wɔde fi Gilead rekɔtɔn no wɔ Misraim asase so. ");
INSERT INTO twi_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda ka kyerɛɛ ne nuanom no se, “Sɛ yekum yɛn nua yi, kata ne mogya so a, mfaso bɛn na yebenya? ");
INSERT INTO twi_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Momma yenyi no, na yɛntɔn no mma Ismaelfo aguadifo yi, sen sɛ yebekum no. Ɛdan dɛn ara a, ɔyɛ yɛn nua kumaa, yɛn ankasa yɛn mogya.” Ne nuanom no penee so. ");
INSERT INTO twi_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Bere a Midian aguadifo no beduu hɔ no, Yosef nuanom no yii no fii amoa no mu, tɔn no maa Ismaelfo no gyee dwetɛ gram ahannu aduonu awotwe (228) ma wɔde no kɔɔ Misraim. ");
INSERT INTO twi_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruben san nʼakyi baa amoa no ho, na ohuu sɛ Yosef nni amoa no mu no, osunsuan ne ntade mu. ");
INSERT INTO twi_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ɔkɔɔ ne nuabarimanom no hɔ, kɔka kyerɛɛ wɔn se, “Abarimaa no nni hɔ oo! Enti mprempren menyɛ me ho dɛn?” ");
INSERT INTO twi_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Na anuanom no faa Yosef batakari no, kum abirekyi, de batakari no nuu ne mogya no mu. ");
INSERT INTO twi_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Wɔde Yosef batakari fɛfɛ no kɔɔ wɔn agya nkyɛn kɔka kyerɛɛ no se, “Yehuu saa atade yi wɔ wura mu hɔ baabi. Hwɛ sɛ ɛyɛ Yosef atade ana?” ");
INSERT INTO twi_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Wɔn agya hui, na ɔkae se, “Nokware, ɛyɛ me ba Yosef atade! Aboa bɔne bi akyere no awe. Ampa ara, aboa ko no atetew Yosef nam pasaa.” ");
INSERT INTO twi_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Na Yakob sunsuan ne ntade mu, hyɛɛ atweaatam, suu ne ba no nna bebree. ");
INSERT INTO twi_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ne mmabarima ne ne mmabea nyinaa betwaa ne ho hyia kyekyee ne werɛ, nanso ankosi hwee. Yakob kae se, “Dabi, mede awerɛhow bewu akɔto me ba no wɔ asaman.” Enti nʼagya Yakob suu no. ");
INSERT INTO twi_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Nea ɛbae ne sɛ, Midianfo no nso kɔtɔn Yosef maa Potifar wɔ Misraim. Saa Potifar no na ɔyɛ ɔhene Farao dabehene ne nʼawɛmfo so panyin. ");
INSERT INTO twi_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Saa bere no mu ara na Yuda tu fii ne nuabarimanom no nkyɛn ne Adulamni barima bi a wɔfrɛ no Hira kɔtenae. ");
INSERT INTO twi_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ɛhɔ na Yuda kohyiaa Kanaanni beae bi a ɔyɛ ɔbarima bi a wɔfrɛ no Sua no babea. Yuda waree Sua babea no. ");
INSERT INTO twi_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Sua babea no nyinsɛn woo ɔbabarima, na wɔtoo no din Er. ");
INSERT INTO twi_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Sua babea no san nyinsɛn woo ɔbabarima bio. Wɔtoo abofra no din Onan. ");
INSERT INTO twi_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Sua babea no nyinsɛn ne mprɛnsa so wɔ Kesib, woo ɔbabarima bio. Saa abarimaa no nso wɔtoo no din Sela. ");
INSERT INTO twi_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Bere a Yuda abakan Er nyin no, wɔwaree ababaa bi a wɔfrɛ no Tamar maa no. ");
INSERT INTO twi_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Esiane sɛ na Yuda abakan Er yɛ omumɔyɛfo wɔ Awurade anim no nti, Awurade kum no. ");
INSERT INTO twi_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Er wu akyi no, Yuda ka kyerɛɛ Er akyiba Onan se, “Ɛsɛ sɛ woware okunafo Tamar, sɛnea yɛn amanne te no, na sɛ wo ne no wo a, mma no ayɛ wo nua no diadefo.” ");
INSERT INTO twi_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Esiane sɛ na Onan mpɛ sɛ ɔbɛwo akyɛ a mmofra no renyɛ nʼankasa mma nti, sɛ ɔne okunafo Tamar kɔda a, ɔmma ne ho nsu no ngu ɔbea no mu. Mmom, ɔma no gu fam sɛnea ɛbɛyɛ a, ɔrenwo ɔba a ɛbɛyɛ ne nua owufo no de. ");
INSERT INTO twi_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Esiane sɛ nea ɔyɛe no ansɔ Awurade ani, sɛ ɔmpɛ sɛ ɔwo ba ma ne nua owufo no nti, okum ɔno nso. ");
INSERT INTO twi_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Na Yuda ka kyerɛɛ nʼase okunafo Tamar se, “Tu na kɔtena wʼagya fi sɛ okunafo kosi sɛ me babarima Sala benyin.” Na osuro sɛ, Sela nso bewu, sɛnea ne nuanom mpanyimfo Er ne Onan wuwui no. Enti Tamar tu kɔtenaa nʼagya fi hɔ. ");
INSERT INTO twi_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Mmere bi akyi no, Yuda yere a ɔyɛ Sua babea no nso wui. Bere a woyii Yuda fii kuna mu no, ɔkɔɔ ne nguanhotwitwafo nkyɛn wɔ Timna. Ɔrekɔ no, ɔne nʼadamfo Adulamni Hira na ɛkɔe. ");
INSERT INTO twi_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Obi bɛbɔɔ Tamar amanneɛ se, “Wʼase Yuda rebɛsen akɔ Timna akotwitwa ne nguan ho nwi.” ");
INSERT INTO twi_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Enti Tamar yii ne kuna ntade no guu hɔ. Ɔfaa nkataanim kataa nʼanim, sɛnea ɛbɛyɛ a obiara nhu sɛ ɛyɛ ɔno Tamar, na ɔkɔtenaa Enaim kurotia wɔ Timna kwan so. Efisɛ ohuu sɛ Sela anyin de, nanso na Yuda mmaa ne babarima no kwan mma ɔmmɛwaree no ɛ. ");
INSERT INTO twi_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Bere a Yuda huu Tamar no, na osusuw sɛ ɔyɛ ɔbea guamanfo bi, efisɛ na wakata nʼanim. ");
INSERT INTO twi_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yuda kɔɔ Tamar nkyɛn wɔ kwankyɛn hɔ a, na onnim sɛ ɔyɛ nʼase. Yuda ka kyerɛɛ no se, “Ma yɛnkɔ mprempren ara na me ne wo nkɔda.” Tamar bisaa no se, “Sɛ me ne wo kɔda a, wobɛma me dɛn?” ");
INSERT INTO twi_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda buae se, “Mɛma wɔde ɔpapo afi me nguankuw no mu abrɛ wo.” Tamar bisaa no bio se, “Ansa na wode ɔpapo no bɛba no, dɛn na wode bedi wo ho akagyinamu?” ");
INSERT INTO twi_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda nso bisaa no se, “Dɛn ade na wopɛ sɛ mede di me ho akagyinamu?” Tamar buae se, “Nea wode bedi wo ho akagyinamu ne wo nsa so kaa ne ne hama ne saa pema a wukura yi.” Enti Yuda de saa nneɛma yi nyinaa maa Tamar ne no kɔda ma onyinsɛnee. ");
INSERT INTO twi_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamar fii hɔ akyi no, okoyii ne nkataanim no guu hɔ, san faa ne kunatam no furae. ");
INSERT INTO twi_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda de ɔpapo no maa nʼadamfo Adulamni no sɛ, ɔmfa nkɔma ɔbea no, na onnye nneɛma a ɔde dii ne ho akagyinamu no mmrɛ no, nanso wanhu no. ");
INSERT INTO twi_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Obisaa kurom hɔfo no se, “Ɛhe na hyiadan mu ɔbea guamanfo a na ɔte Enaim kwankyɛn frɛfrɛ mmarima no wɔ?” Wobuaa no se, “Yenni hyiadan mu ɔbea guamanfo biara wɔ ha.” ");
INSERT INTO twi_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Enti ɔsan kɔɔ Yuda hɔ, kɔka kyerɛɛ no se, “Manhu no. Na kurom hɔfo nso kae se, ‘Hyiadan mu ɔbea oguamanfo biara nni ha.’ ” ");
INSERT INTO twi_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda nso kae se, “Ma no mfa nneɛma no, na anyɛ saa a wɔbɛserew yɛn. Wo ara wudi ho adanse sɛ memaa wode ɔpapo no kɔe, nanso woanhu no.” ");
INSERT INTO twi_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ɛbɛyɛ asram abiɛsa akyi no, Yuda tee sɛ nʼase Tamar abɔ aguaman, anyinsɛn. Ɔtee saa asɛm no, ɔkae se, “Monkɔkyere no mmra, na yɛnhyew no nkum no.” ");
INSERT INTO twi_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Wɔkɔkyeree Tamar de no reba abekum no no, ɔsoma ma wɔkɔka kyerɛɛ nʼase Yuda se, “Onipa a ne nneɛma ni no na ɔne me nyinsɛnee. Monhwɛ sɛ mubehu onipa ko a saa nsa so kaa ne ne hama ne pema yi yɛ ne de no ana.” ");
INSERT INTO twi_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda gye too mu se, saa nneɛma no yɛ ne dea. Ɔtoaa so se, “Ɔbea yi yɛ ɔtreneeni sen me, efisɛ mamfa no amma me babarima Sela anware.” Efi saa bere no, Yuda ankɔ Tamar ho bio. ");
INSERT INTO twi_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar awo duu so no, ɔwoo nta. ");
INSERT INTO twi_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Bere a ɔrewo no, nta no mu baako de ne nsa dii kan bae. Enti ɔbea a ɔregye no awo no de asaawa kɔkɔɔ bɔɔ abofra no bakɔn, kae se, “Oyi na wɔwoo no kan.” ");
INSERT INTO twi_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Saa abofra no twee ne nsa san kɔɔ mu. Ɔsan twee ne nsa kɔɔ mu no, wɔwoo ne nua a ɔka ne ho no mmom. Na ɔwogyefo no kae se, “Abususɛm bɛn ni!” Wɔtoo no din Peres. ");
INSERT INTO twi_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Akyiri no, ɔwoo ne nuabarima a na asaawa kɔkɔɔ bɔ ne nsakɔn no. Wɔtoo ɔno nso din Serah. ");
INSERT INTO twi_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Wɔde Yosef kɔɔ Misraim. Misraimni Potifar a na ɔyɛ Misraimhene Farao dabehene a na otua asraafodɔm ano no na ɔtɔɔ Yosef fii Ismaelfo aguadifo no nsam. ");
INSERT INTO twi_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Na Awurade ka Yosef ho nti, nʼabrabɔ sii no yiye. Ɔtenaa ne wura Misraimni no fi. ");
INSERT INTO twi_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Yosef wura no huu sɛ Awurade ka ne ho, na nea na ɔyɛ biara no, Awurade hyiraa so maa no, na ");
INSERT INTO twi_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yosef nyaa nʼanim adom ma ɔde no yɛɛ ne boafo. Ankyɛ koraa na Potifar de Yosef sii ne fifo so panyin, de nea ɔwɔ nyinaa hyɛɛ ne nsa. ");
INSERT INTO twi_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Bere a Potifar de Yosef sii ne fifo so panyin, de nea ɔwɔ nyinaa hyɛɛ ne nsa no, Awurade hyiraa Misraimni Potifar fie so, esiane Yosef nti. Awurade hyiraa nʼagyapade a ɛwɔ fi ne ne mfuw nyinaa so. ");
INSERT INTO twi_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Enti ɔde nʼagyapade nyinaa hyɛɛ Yosef nsa. Esiane sɛ Potifar de nʼagyapade ne nʼadwumade nyinaa hyɛɛ Yosef nsa nti, wannwene biribiara ho sɛ aduan a obedi nko ara. Na Yosef yɛ aberante a ɔwɔ nnyinaso, na ne ho nso yɛ fɛ yiye. ");
INSERT INTO twi_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ankyɛ ahe biara na Yosef wura Potifar yere tuu nʼani sii ne so, ka kyerɛɛ Yosef se, “Bra, na wo ne me mmɛda!” ");
INSERT INTO twi_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Nanso Yosef ampene so, ka kyerɛɛ ne wura yere no se, “Esiane sɛ fie ha biribiara hyɛ me nsa nti, me wura nnwen fie ha biribiara ho. Ɔde nʼagyapade nyinaa ahyɛ me nsa. ");
INSERT INTO twi_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Obiara nni tumi nsen me wɔ fie ha. Me wura mfa biribiara nkame me wɔ fie ha sɛ wo nko ara, efisɛ woyɛ ne yere. Onyame mpa ngu sɛ mɛyɛ ade a ɛte saa. Ɛbɛyɛ dɛn na matumi ayɛ amumɔyɛde a ɛte sɛɛ! Ɛbɛyɛ bɔne kɛse atia Onyankopɔn.” ");
INSERT INTO twi_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ɛwɔ mu sɛ da biara na Potifar yere no de saa asɛm yi hiahia Yosef ho de, nanso Yosef antwiw ammɛn no mpo, na akowie sɛ ɔne no bɛda. ");
INSERT INTO twi_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Da koro bi, Yosef kɔɔ fie hɔ sɛ ɔrekɔyɛ nʼadwuma. Oduu hɔ no, na asomfo no mu biara nni hɔ. ");
INSERT INTO twi_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Potifar yere no soo Yosef atade mu kyeree no, ka kyerɛɛ no se, “Bra na wo ne me mmɛda!” Nanso Yosef yii nʼatade no guu ne so, guan fii fie hɔ. ");
INSERT INTO twi_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Potifar yere no huu sɛ Yosef agyaw nʼatade wɔ ne nsam aguan afi fie hɔ no, ");
INSERT INTO twi_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ɔfrɛɛ ne fifo, de nteɛteɛmu ka kyerɛɛ wɔn se, “Monhwɛ! Me kunu akɔfa Hebrini bi aba fie ha sɛ ommegu yɛn anim ase. Ɔbaa ha sɛ ɔrebɛto me mmonnaa na meteɛteɛɛ mu. ");
INSERT INTO twi_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ɔtee sɛ mereteɛteɛ mu no, oyii nʼatade guu me so, guan fii fie ha.” ");
INSERT INTO twi_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Potifar yere no de Yosef atade a oyi guu ne so no siei, kosii sɛ ne kunu bae. ");
INSERT INTO twi_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ɔbea no bɔɔ ne kunu amanneɛ se, “Hebrini akoa no a wokɔtɔɔ no brɛɛ yɛn no baa me nkyɛn sɛ anka ɔrebɛto me mmonnaa. ");
INSERT INTO twi_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Meteɛteɛ mu no na oguan fii fie ha, gyaw nʼatade.” ");
INSERT INTO twi_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Bere a Yosef wura Potifar tee asɛm a ne yere ka kyerɛɛ no se, “Ɔkwan a wʼakoa no de me faa so ni” no, ne bo fuw yiye. ");
INSERT INTO twi_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Yosef wura Potifar tee asɛm no no, ɔkyeree Yosef kɔtoo afiase, faako a ɔhene nneduafo gu no. Bere a Yosef da afiase hɔ no, ");
INSERT INTO twi_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","na Awurade ka ne ho. Awurade yɛɛ no adɔe ma ɛno nti, afiase sohwɛfo panyin no pɛɛ nʼasɛm yiye. ");
INSERT INTO twi_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ɛyɛɛ saa maa afiase sohwɛfo panyin no de Yosef sii nneduafo no nyinaa so panyin, a na biribiara a wɔyɛ wɔ afiase hɔ no hyɛ ne nsa. ");
INSERT INTO twi_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Esiane sɛ na Awurade ka Yosef ho no nti, na afiase sohwɛfo panyin no nhaw ne ho nyɛ adwuma. Efisɛ biribiara a Yosef bɛyɛ no, Awurade hyira so ma esi yiye. ");
INSERT INTO twi_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Mmere bi akyi no, ɛbaa sɛ Misraimhene Farao nsahyɛfo panyin ne ne brodotofo panyin fom no. ");
INSERT INTO twi_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farao bo fuw ne nsahyɛfo panyin no ne ne brodotofo panyin no yiye. ");
INSERT INTO twi_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Enti ɔde wɔn koguu afiase wɔ ɔwɛmfo panyin Potifar no fi, beae koro no ara a wɔde Yosef kɔtoo no. ");
INSERT INTO twi_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ɔwɛmfo panyin Potifar de wɔn hyɛɛ Yosef nsa sɛ, ɔnhwɛ na ɔnyɛ nea ehia wɔn nyinaa mma wɔn. Wɔdaa afiase hɔ kyɛɛ kakraa no, ");
INSERT INTO twi_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","nnipa baanu no nyinaa a na wɔyɛ ɔhene Farao brodotofo panyin ne nsahyɛfo panyin a na wogu afiase hɔ no sosoo adae anadwo koro no ara. Na saa adae abien no mu biara wɔ ne nkyerɛase. ");
INSERT INTO twi_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ade kyee a Yosef baa nneduafo baanu no nkyɛn no, ohuu sɛ wɔn nyinaa ayeyɛ bosobosoo. ");
INSERT INTO twi_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Obisaa Farao fi mpanyimfo nneduafo a na wɔne no gu afiase hɔ no se, “Adɛn nti na nnɛ de, mo werɛ ahow mo ho sɛɛ?” ");
INSERT INTO twi_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nneduafo no buaa Yosef se, “Anadwo yi, yɛn baanu nyinaa sosoo adae, nanso yennya obiara wɔ ha nkyerɛ yɛn ase.” Yosef nso ka kyerɛɛ wɔn se, “Ɛwɔ mu sɛ Onyankopɔn na ɔkyerɛ dae ase de, nanso monka mo dae a mososoe no nkyerɛ me.” ");
INSERT INTO twi_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Enti Farao nsahyɛfo panyin no dii kan kaa ne dae a ɔsoo no kyerɛɛ Yosef se, “Me dae mu no, mihuu bobe dua. ");
INSERT INTO twi_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Na saa bobe dua no wɔ mman abiɛsa. Eguu nhwiren, hyehyɛ nyin yɛɛ kasiaw beree. ");
INSERT INTO twi_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na mikura ɔhene Farao nsa kuruwa. Metetew bobe aba no, kyikyi guu ɔhene Farao nsa kuruwa no mu, de maa no sɛ ɔnnom.” ");
INSERT INTO twi_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosef ka kyerɛɛ nsahyɛfo panyin deduani no se, “Wo dae no ase ni: mman abiɛsa a wuhui no kyerɛ nnansa. ");
INSERT INTO twi_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nnansa ntam no, Farao beyi wo, ama woakodi wo dibea sɛ ɔhene nsahyɛfo panyin. Na wode Farao kuruwa bɛhyɛ ne nsa sɛnea na woyɛ no kan no. ");
INSERT INTO twi_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Na sɛ esi wo yiye a, kae me na yɛ me adɔe; ka me ho asɛm kyerɛ ɔhene Farao, na ɔmma wommeyi me mfi afiase ha. ");
INSERT INTO twi_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Efisɛ manyɛ bɔne biara na wɔkyeree me fii me manfo Hebrifo asase so de me baa ha. Na ɛha nso mpo a meda yi, manyɛ mfomso biara a ɛsɛ sɛ wogyina so de me to afiase.” ");
INSERT INTO twi_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Bere a brodotofo panyin deduani no huu sɛ Yosef akyerɛ nsahyɛfo panyin no dae no ase, ama atɔ asom no, ɔka kyerɛɛ Yosef se, “Me nso, mesoo dae bi. Me dae no mu no, na meso nkɛntɛn abiɛsa a brodo gugu mu. ");
INSERT INTO twi_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kɛntɛn a esi soro pɛɛ no, na nnuan ahorow a wɔato a mede rekɔma Farao gu mu a na nnomaa sisi aduan no so wɔ mʼatifi redi.” ");
INSERT INTO twi_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosef ka kyerɛɛ no se, “Wo dae a wosoo no nkyerɛase ni, Nkɛntɛn abiɛsa no gyina hɔ ma nnansa. ");
INSERT INTO twi_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nnansa ntam no, Farao bɛma wɔabeyi wo afi afiase ha, atwa wo ti, de wo sin no akɔsɛn dua so, ama nnomaa asosɔw wo nam.” ");
INSERT INTO twi_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ne nnansa so no, na Farao redi nʼawoda. Enti ɔtoo pon kɛse bi maa ne mpanyimfo ne ne fifo nyinaa. Ɔsoma ma wokoyii ne brodotofo panyin ne ne nsahyɛfo panyin nneduafo no fii afiase hɔ baa nʼanim. ");
INSERT INTO twi_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ɔhene Farao san de ne nsahyɛfo panyin no sii ne sibea ma ɔhyɛɛ ɔhene Farao nsa. ");
INSERT INTO twi_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Nanso ne brodotofo panyin no de, Farao ma wɔkɔsɛn no sɛnea Yosef kyerɛɛ ne dae no ase kyerɛɛ no no pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Nsahyɛfo panyin no nso werɛ fii Yosef a wankae no koraa. ");
INSERT INTO twi_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Mfe abien akyi no, Farao soo dae bi. Na ogyina Asubɔnten Nil ho. ");
INSERT INTO twi_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ohuu wɔ dae no mu sɛ anantwi ason a wɔadodɔ srade, na wɔn ho tua wɔn ho fii asubɔnten no mu ba bɛwee sare a na ɛwɔ hɔ no. ");
INSERT INTO twi_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Anantwi akɛse ason no akyi no, anantwi ason foforo a wɔafonfɔn ayeyɛ nkanyankanya fii Asubɔnten Nil mu ba begyinaa anantwi a wɔadodɔ srade no ho wɔ asu no konkɔn so. ");
INSERT INTO twi_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Anantwi ason a wɔafonfɔn ayeyɛ nkanyankanya no memenee anantwi ason a wɔadodɔ srade no. Na Farao bɔɔ pitiri nyanee! ");
INSERT INTO twi_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nna faa Farao bio ma ɔsoo dae a ɛto so abien. Ohuu wɔ dae no mu sɛ, ɔmo kasiaw ason a ɛwɔ ahoɔden na ɛyɛ fɛ asow wɔ ɔmo dua baako so. ");
INSERT INTO twi_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Akyiri no, kasiaw ason bi a ɛyɛ nkanyankanya a apuei mframa abɔ no ama atwintwam nso fifii. ");
INSERT INTO twi_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ɔmo nkanyankanya no memenee ɔmo a ɛwɔ ahoɔden na ɛyɛ fɛ no. Farao nyanee, na ohuu sɛ sɛɛ na nea ohuu no nyinaa yɛ ɔdae. ");
INSERT INTO twi_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ade kyee no, nʼadwene mu yɛɛ no basaa. Enti Farao soma ma wɔkɔfrɛɛ nkonyaayifo ne anyansafo a wɔwɔ Misraim asase so nyinaa baa ne fi. Farao kaa dae a ɔsoo no nyinaa kyerɛɛ wɔn, nanso wɔn mu biara antumi ankyerɛ ase. ");
INSERT INTO twi_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ɛhɔ na Farao nsahyɛfo panyin no ka kyerɛɛ Farao se, “Nnɛ na wɔakae me me sintɔ. ");
INSERT INTO twi_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Mmere bi a atwa mu no, wo Farao bo fuw wʼasomfo yiye. Ɛnam so ma wode me ne wo brodotofo panyin kɔtoo afiase wɔ awɛmfo panyin fi. ");
INSERT INTO twi_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Yɛn baanu nyinaa sosoo adae anadwo koro no ara a na ɛsono sɛnea yɛn mu biara dae no si te. ");
INSERT INTO twi_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Saa bere no, na Hebrini aberantewa bi a na ɔyɛ awɛmfo panyin Potifar somfo ka yɛn ho wɔ afiase hɔ. Yɛkaa yɛn dae a yɛsosoo no kyerɛɛ no no, ɔkyerɛɛ yɛn mu biara dae ase pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Na ne nkyerɛase a ɔmaa no baa mu saa pɛpɛɛpɛ. Mesan kodii me dibea, na wɔsɛn brodotofo panyin no nso.” ");
INSERT INTO twi_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Amono mu hɔ ara, Farao soma ma wokoyii Yosef fii afiase hɔ bae. Ofi afiase hɔ no, oyii nʼabogyesɛ, sesaa nʼatade, na ɔbaa Farao anim. ");
INSERT INTO twi_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao ka kyerɛɛ Yosef se, “Maso dae bi a obiara ntumi nkyerɛ ase. Nanso mate sɛ wo de, sɛ obi ka ne dae kyerɛ wo a, wutumi kyerɛ ase. Ɛno nti na masoma abɛfrɛ wo yi.” ");
INSERT INTO twi_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosef buaa Farao se, “Me ara merentumi mfi me tumi mu nkyerɛ dae no ase. Onyankopɔn na ɔbɛkyerɛ wo dae no ase.” ");
INSERT INTO twi_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Na Farao ka kyerɛɛ Yosef se, “Mʼadaeso no mu no, na migyina Asubɔnten Nil konkɔn so. ");
INSERT INTO twi_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Mihuu sɛ anantwi ason a wɔadodɔ srade, na wɔn ho tua wɔn ho fi asubɔnten no mu ba bɛnantew wura no mu, fii ase wee sare. ");
INSERT INTO twi_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Anantwi akɛse ason no akyi no, anantwi ason foforo a wɔafonfɔn ayeyɛ nkanyankanya nso puei; minhuu anantwi a wɔyɛ tan bi saa wɔ Misraim asase so da. ");
INSERT INTO twi_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Anantwi ason a wɔafonfɔn ayeyɛ nkanyankanya no memenee anantwi ason a wɔadodɔ srade na wɔn ho tua wɔn ho a wodii kan puei no. ");
INSERT INTO twi_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Nanso wɔmemenee wɔn nyinaa akyi no, hwee ankyerɛ sɛ wɔayɛ saa, na wɔn ho da so yɛ nkanyankanya, tantan no ara. Na mebɔɔ pitiri nyanee. ");
INSERT INTO twi_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Mesan soo dae bio hui sɛ, ɔmo kasiaw ason a ɛyɛ fɛ na ɛwɔ ahoɔden sɛ asow wɔ ɔmo dua baako so. ");
INSERT INTO twi_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Eyinom akyi no, ɔmo kasiaw ason bi a apuei mframa abɔ no, ama akisa ayeyɛ nkanyankanya nso fifii. ");
INSERT INTO twi_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ɔmo nkanyankanya no memenee ɔmo ason a ɛyɛ fɛ na ɛwɔ ahoɔden no. Mekaa me dae no nyinaa kyerɛɛ nkonyaayifo no, wɔn mu biara antumi ankyerɛ me ase.” ");
INSERT INTO twi_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ɛnna Yosef ka kyerɛɛ Farao se, “Wo dae abien a wososoe no nyinaa nkyerɛase yɛ pɛ. Onyankopɔn nam dae no so reda biribi a ɔrebɛyɛ no adi akyerɛ wo. ");
INSERT INTO twi_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Anantwi ason a wɔadodɔ srade no ne ɔmo kasiaw ason a ɛyɛ fɛ, na ɛwɔ ahoɔden no ase kyerɛ mfe ason; ɛyɛ dae koro. ");
INSERT INTO twi_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Anantwi ason a wɔafonfɔn, na wɔayeyɛ nkanyankanya no yɛ mfe ason, na saa ara na ɔmo kasiaw ason a ayeyɛ nhweanhweaa a apuei mframa ama akisa no te: ɛyɛ ɔkɔm a ɛbɛba mfe ason. ");
INSERT INTO twi_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ɛyɛ sɛnea meka kyerɛɛ Ɔhene no: Onyankopɔn akyerɛ wo nea ɔrebɛyɛ. ");
INSERT INTO twi_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Mfe ason a edi kan no, aduan bebu wɔ Misraim asase so nyinaa, ");
INSERT INTO twi_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","nanso akyiri no, ɔkɔm kɛse bi bɛba mfe ason. Na nnipa werɛ befi asetena pa a wonyaa no mfe ason a edi kan no mu no. Ɔkɔm bɛposa asase no. ");
INSERT INTO twi_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Esiane ɔkɔm a ebedi mmere pa a atwa mu no akyi no ano den a ɛbɛyɛ no nti, saa bere no wɔrenkae mmere pa no bio wɔ asase no so. ");
INSERT INTO twi_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Saa dae abien a wosoo no kyerɛ sɛnea ɔkɔm no ano bɛyɛ den afa. Ɛkyerɛ sɛ, nea ɛbɛyɛ biara, asɛm a maka akyerɛ wo no bɛba mu saa pɛpɛɛpɛ. Efisɛ Onyankopɔn na wasi gyinae pi saa. Na ɛrenkyɛre koraa ɛbɛba mu saa. ");
INSERT INTO twi_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Enti wɔmma Ɔhene hwehwɛ onyansafo kɛse a ɔwɔ nhumu wɔ Misraim asase yi so, na ɔmfa ɔman yi mu kuadwuma ho asɛm nyinaa hyɛ ne nsa. ");
INSERT INTO twi_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ma ɔhene Farao nyiyi nnipa, ntuatua amansin ahorow anum no ano. Na saa nnipa a wɔde wɔn betuatua amansin no ano no nyiyi nnɔbae a ɛbɛba mmere pa mfe ason no mu no nkyɛmu anum mu baako, mfa nsie. ");
INSERT INTO twi_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ɛsɛ sɛ saa nnipa a wotuatua amansin no ano no boaboa nnuan a wobegyigye mmere pa mfe ason a nnuan bebu no, de gu asan so wɔ ɔhene Farao din mu. Wɔmfa saa nnuan no nhyehyɛ asan so wɔ nkurow akɛse mu. ");
INSERT INTO twi_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nnuan yi na mfe ason a ɔkɔm bɛba wɔ Misraim asase so no, ɔmanfo no bedi. Saa nnuan yi na wɔde besie ama ɔman no. Sɛ anyɛ saa a, akyinnye biara nni ho sɛ, ɔkɔm bɛbɔ ɔman no.” ");
INSERT INTO twi_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Farao ne ne mpanyimfo no gyee asɛm a Yosef ka kyerɛɛ wɔn no nyinaa too mu. ");
INSERT INTO twi_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Enti Farao bisaa wɔn se, “So yebenya obi a ɔte sɛ ɔbarima yi, nea Onyankopɔn honhom ahyɛ no ma?” ");
INSERT INTO twi_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Na Farao dan nʼani ka kyerɛɛ Yosef se, “Onyankopɔn ayi saa dae yi ne ne nkyerɛase akyerɛ wo yi, obiara nni hɔ a ɔyɛ onyansafo a ɔwɔ nhumu wɔ Misraimman yi mu sɛ wo. ");
INSERT INTO twi_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Mede saa adwuma kɛse yi nyinaa hyɛ wo nsa. Asɛm biara a wobɛka afa saa adwuma yi ho no, obiara nni ho asɛm ka wɔ Misraim nyinaa. Mʼahengua a me Farao, mete so no nko ara na ɛma meyɛ ɔkɛse sen wo.” ");
INSERT INTO twi_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Enti Farao ka kyerɛɛ Yosef se, “Mede Misraim asase nyinaa ahyɛ wo nsa.” ");
INSERT INTO twi_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Na Farao worɔw ne nsɔwano kaa de hyɛɛ Yosef nsa. Ɔde sirikyi batakari papa bi hyɛɛ Yosef, de sika ntweaban yan no. ");
INSERT INTO twi_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ɔmaa Yosef teaseɛnam tenaa mu sɛ nʼabediakyiri. Baabiara a Yosef bɛkɔ no, na nnipa di nʼanim teɛteɛɛ mu se, “Momma kwan!” Saa ɔkwan yi so na ɔhene Farao fa de Misraim asase nyinaa hyɛɛ Yosef nsa. ");
INSERT INTO twi_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Na Farao ka kyerɛɛ Yosef se, “Mene Farao, Misraimhene de, nanso obiara ntumi mfi wʼakyi nyɛ biribiara wɔ Misraimman yi mu baabiara, gye sɛ woama ho kwan ansa.” ");
INSERT INTO twi_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao maa Yosef ahennin se Safnat-Panea. Farao maa Yosef ɔbea nso waree. Na ababaa no din de Asnat a ɔyɛ ɔbosom On kɔmfo Potifera babea. Ɛnam eyi so maa Yosef nyaa tumi maa ne din hyetaa wɔ Misraim asase so nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Bere a Yosef kɔɔ ɔhene Farao agua ase no, na wadi mfirihyia aduasa. Farao maa Yosef kwan maa ɔbɔɔ aporɔw faa Misraim asase so nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mfe ason a edi kan no mu no, aduan buu so wɔ Misraim asase so yiye. ");
INSERT INTO twi_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Saa mfe ason no mu no, Yosef boaboaa nnuan a ebuu so wɔ Misraimman mu no ano kɔkoraa wɔ nkuropɔn a ɛwowɔ Misraim no mu. Wɔde aduan biara a wonya fii kurow biara mu no bi siee wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Mfe ason akyi no, na Yosef akora nnuan wɔ nnuankorabea hɔ, ama abu so ara kosii sɛ afei na obiara mmu ho nkontaa bio. ");
INSERT INTO twi_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ansa na ɔkɔm kɛse no rebɛba no, na Yosef yere Asnat a ɔyɛ ɔbosom On kɔmfo Potifera babea no awo mmabarima baanu. ");
INSERT INTO twi_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosef too nʼabakan no din Manase, a nkyerɛase ne Onyankopɔn ama me werɛ afi mʼamanehunu ne mʼagya fi nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Yosef babarima a ɔto so abien no nso, wɔtoo no din Efraim, a nkyerɛase ne Onyankopɔn ama mʼase afɛe wɔ asase a mebaa so sɛ akoa no so. ");
INSERT INTO twi_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Mfe ason a aduan buu so wɔ Misraim asase so no twaa mu. ");
INSERT INTO twi_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Sɛnea Yosef hyɛɛ nkɔm no, ɔkɔm a ɛbɛba mfe ason a edi so no fii ase. Ɔkɔm kɛse sii nsase a na atwa Misraim ho ahyia no nyinaa so, nanso Misraim asase ankasa so de, na aduan abu so. ");
INSERT INTO twi_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Bere a ɔkɔm no sii denneennen wɔ Misraim asase so no, ɔmanfo no su frɛɛ Farao. Farao ka kyerɛɛ Misraimfo nyinaa se, “Monkɔ Yosef nkyɛn, na biribiara a ɔbɛka akyerɛ mo sɛ monyɛ no, monyɛ.” ");
INSERT INTO twi_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Bere a ɔkɔm kɛse no trɛw faa ɔman no nyinaa mu no, Yosef buebuee ne nnuankorabea no nyinaa ano, tɔn aburow maa Misraimfo no, efisɛ na ɔkɔm no ano yɛ den yiye ma wɔn. ");
INSERT INTO twi_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Enti na aman a atwa Misraim ho ahyia no nyinaa kɔtɔ aduan wɔ Yosef nkyɛn wɔ Misraim, efisɛ na ɔkɔm a aba no ano yɛ den yiye. ");
INSERT INTO twi_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Bere a Yakob tee sɛ aburow wɔ Misraim no, ɔka kyerɛɛ ne mmabarima no se, “Adɛn nti na morehwehwɛhwehwɛ mo ho mo ho anim kɛkɛ yi?” ");
INSERT INTO twi_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Yakob toaa so se, “Mate sɛ aburow wɔ Misraim. Monkɔ hɔ, na monkɔtɔ bi mmra na ɔkɔm ankunkum yɛn.” ");
INSERT INTO twi_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Enti Yosef nuabarimanom mpanyimfo du no kɔɔ Misraim sɛ wɔrekɔtɔ aburow no bi. ");
INSERT INTO twi_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Nanso Yakob amma Benyamin a ɔyɛ Yosef nua kumaa no ankɔ bi, efisɛ na osuro sɛ biribi bɛyɛ no. ");
INSERT INTO twi_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Enti Israel mmabarima no de wɔn ho bɔɔ atɔfo a wofifi aman ahorow so kɔtɔ aburow wɔ Misraim no ho, efisɛ na ɔkɔm no atrɛw akodu Kanaan asase so mmaa nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Na Yosef yɛ amrado wɔ Misraim asase so. Ɔno na ɔtɔn aburow ma nnipa nyinaa wɔ ɔman no mu. Yosef nuabarimanom no koduu nʼanim no, wobuu no nkotodwe, de wɔn anim nso butubutuw fam. ");
INSERT INTO twi_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Bere a Yosef ani bɔɔ anuanom no so no, ohuu wɔn, nanso ɔyɛɛ ne ho sɛnea onnim wɔn ma ɔhaahaa nʼani kasa kyerɛɛ wɔn se, “Mufi he?” Anuanom no buaa no se, “Yefi Kanaan asase so, na yɛaba sɛ yɛrebɛtɔ aduan.” ");
INSERT INTO twi_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Na Yosef ahu ne nuanom no de, nanso wɔn de, na wonhuu no ɛ. ");
INSERT INTO twi_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yosef kaee dae a mmere bi ɔso faa wɔn ho no ma ɔka kyerɛɛ wɔn se, “Moyɛ akwansrafo! Morebɛhwɛ baabi a yɛn asase yi nni bammɔ.” ");
INSERT INTO twi_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Anuanom no buae se, “Dabi da yɛn wura, wo nkoa bae sɛ yɛrebɛtɔ aduan. ");
INSERT INTO twi_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Yɛn nyinaa fi agya baako. Wo nkoa yɛ anokwafo, na yɛnyɛ akwansrafo.” ");
INSERT INTO twi_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Nanso Yosef tii mu se, “Dabi da, morebɛhwɛ baabi a yɛn asase yi nni bammɔ.” ");
INSERT INTO twi_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Anuanom no buae se, “Na wo nkoa yɛ anuanom dumien, ɔpanyin bi a ɔte Kanaan asase so mma. Mprempren, yɛn kaakyiri no wɔ yɛn agya nkyɛn, na ɔbaako nso afi mu.” ");
INSERT INTO twi_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosef ka kyerɛɛ wɔn se, “Asɛm no ara na meka kyerɛɛ mo no: Moyɛ akwansrafo! ");
INSERT INTO twi_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ɔkwan a mɛfa so de asɔ mo ahwɛ ni: Sɛ Farao te ase yi, moremfi ha nkɔ da, kosi sɛ mode mo kaakyiri no bɛba. ");
INSERT INTO twi_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Monsoma mo mu baako, na ɔnkɔfa mo kaakyiri no mmra. Mede mo a moaka no nyinaa begu afiase. Ɛno na ɛbɛma yɛahu sɛ mo asɛm a moreka no yɛ nokware. Sɛ ɛnte saa a na Farao te ase yi, na moyɛ akwansrafo!” ");
INSERT INTO twi_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Na ɔde wɔn nyinaa guu afiase nnansa. ");
INSERT INTO twi_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Nnansa so no, Yosef ka kyerɛɛ ne nuanom no se, “Meyɛ onyamesuroni. Ɛno nti, monyɛ eyi na moanya nkwa. ");
INSERT INTO twi_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Sɛ moyɛ nokwafo ampa ara a, momma mo nua baako nna afiase ha na mo a moaka no nso nkɔtɔ aburow no bi nkɔma mo fifo a ɔkɔm rekum wɔn no. ");
INSERT INTO twi_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Nanso nea ɛte biara no, momfa mo nua kumaa no mmɛkyerɛ me. Ɛno na ɛbɛma mahu mo nsɛm no mu nokware na moanwuwu.” Wɔyɛɛ nea ɔkaa no. ");
INSERT INTO twi_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Wɔkeka kyerɛkyerɛɛ wɔn ho wɔn ho se, “Nokware, yɛn nuabarima yi nti na wɔretwe yɛn aso. Yehuu sɛnea ɔpaa yɛn kyɛw sɛ yenyaa no nanso yɛantie no; ɛno nti na saa amanehunu yi aba yɛn so no.” ");
INSERT INTO twi_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben buae se, “Manka ankyerɛ mo sɛ monnyɛ bɔne biara ntia abarimaa no? Nanso moantie! Afei na ɛsɛ sɛ yebu ne mogya ho akontaa” ");
INSERT INTO twi_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Esiane sɛ na obi kyerɛ nsɛm a Yosef ka no ase kyerɛ wɔn no nti, na wonnim sɛ Yosef te wɔn kasa no. ");
INSERT INTO twi_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yosef sɔre fii wɔn nkyɛn kosui. Ɔsan bae ne wɔn bɛkasae bio. Oyii Simeon fii wɔn mu, maa wɔkyekyeree no wɔ wɔn anim. ");
INSERT INTO twi_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosef hyɛɛ sɛ, wɔnhyɛ wɔn nkotoku no aburow amaama, na wɔnsan mfa obiara sika a anka ɔde rebɛtɔ aburow no nhyɛ ne kotoku mu, na wɔmma wɔn akwansoduan nso nka ho. Wɔyɛɛ eyi maa wɔn. ");
INSERT INTO twi_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Wɔhyehyɛɛ wɔn aburow nkotoku no wɔ wɔn mfurum no so ma wofii hɔ. ");
INSERT INTO twi_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Wɔrekɔ no ara, wogyinaa kwan so anadwo homee. Ɛhɔ na wɔn mu baako san ne kotoku sɛ ɔrema nʼafurum aduan adi. Ɔsan ne kotoku no, ohuu sɛ ne sika a anka ɔde rekɔtɔ aburow no hyɛ kotoku no fa baabi. ");
INSERT INTO twi_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ɔka kyerɛɛ ne nuanom no se, “Wɔde me sika no asan ahyɛ me kotoku no mu. Monhwɛ. Ɛno ni!” Saa asɛm yi maa wɔn koma tutui. Enti wɔhwehwɛɛ wɔn ho wɔn ho anim kae se, “Dɛn na Onyankopɔn ayɛ yɛn yi?” ");
INSERT INTO twi_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Woduu wɔn agya Yakob nkyɛn wɔ Kanaan no, wɔbɔɔ no nsɛm a asisi no nyinaa ho amanneɛ. Wɔkae se, ");
INSERT INTO twi_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Yeduu Misraim asase so no, ɔbarima a ɔhwɛ asase no so no poopoo nʼani, kyerɛɛ yɛn sɛ yɛyɛ akwansrafo. ");
INSERT INTO twi_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nanso yebuaa no se, ‘Yɛyɛ nnipa pa, na yɛnyɛ akwansrafo. ");
INSERT INTO twi_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Yɛyɛ anuanom dumien a yefi agya baako. Ɔbaako afi mu. Mprempren, yɛn kaakyiri no wɔ yɛn agya nkyɛn wɔ Kanaan.’ ");
INSERT INTO twi_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Na ɔbarima a ɔhwɛ asase no so ka kyerɛɛ yɛn se, ‘Ɔkwan a mepɛ sɛ mefa so sɔ mo hwɛ ni: Munnyaw mo nuanom baako wɔ me nkyɛn ha, na monkɔtɔ aburow no bi nkɔma mo fifo a ɔkɔm rekum wɔn no. ");
INSERT INTO twi_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Nanso momfa mo nua kumaa no mmɛkyerɛ me. Ɛno na ɛbɛma mahu sɛ monyɛ akwansrafo na moyɛ nnipa pa. Na mede mo nua no bɛma mo, na mubetumi adi gua wɔ asase yi so.’ ” ");
INSERT INTO twi_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bere a wɔrehwiehwie wɔn aburow no afi wɔn nkotoku no mu no, obiara huu ne sika a anka ɔde rekotua aburow no ka wɔ ne kotoku no ano. Wɔne wɔn agya huu sika no, wɔn koma tutui. ");
INSERT INTO twi_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ɛyɛɛ saa maa wɔn agya Yakob ka kyerɛɛ wɔn se, “Moama mahwere me mma. Yosef nni hɔ; Simeon nso nni hɔ; afei mopɛ sɛ mofa Benyamin nso ka ho! Biribiara ko tia me.” ");
INSERT INTO twi_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben ka kyerɛɛ nʼagya se, “Sɛ mamfa Benyamin ansan amma a, wowɔ ho kwan sɛ wukum me mmabarima baanu no si anan. Fa no hyɛ me nsa, na mɛsan de no abrɛ wo.” ");
INSERT INTO twi_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Nanso Yakob buae se, “Me babarima no ne morenkɔ hɔ, efisɛ ne nuabarima awu ama aka ɔno nko. Sɛ saa kwan a morebetu yi, asiane bi kosiane no a, mewu.” ");
INSERT INTO twi_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Saa bere no mu no, na ɔkɔm no ano da so yɛ den wɔ asase no so nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Enti bere a aduan a wɔkɔtɔ fii Misraim bae no reyɛ asa no, wɔn agya Yakob ka kyerɛɛ wɔn se, “Monsan nkɔ nkɔtɔ aduan kakra mmra bio.” ");
INSERT INTO twi_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Nanso Yuda ka kyerɛɛ nʼagya Yakob se, “Owura no sua kyerɛɛ yɛn denneennen se, ‘Sɛ moamfa mo nua kumaa no anka mo ho amma a, munnsi mʼanim ha bio.’ ");
INSERT INTO twi_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Sɛ wobɛma yɛne yɛn nua kumaa no akɔ de a, ɛno de, yɛbɛsan akɔ akɔtɔ aduan no bi abrɛ wo. ");
INSERT INTO twi_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Nanso sɛ woamma yɛamfa no ankɔ de a, yɛrenkɔ, efisɛ owura no suaa denneennen se, ‘Sɛ mo nua kumaa no nka mo ho a, munnsi mʼanim bio.’ ” ");
INSERT INTO twi_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel bisaa ne mma no se, “Adɛn nti na moka kyerɛɛ owura no se mowɔ nua kumaa bi wɔ hɔ, na mode saa ɔhaw yi abɛto me so?” ");
INSERT INTO twi_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Anuanom no buaa wɔn agya Israel se, “Owura no nyaa adagyew, tɔɔ ne bo ase bisaa yɛn ne yɛn abusuafo ho nsɛm nyinaa se, ‘Mo agya da so te ase ana? Mowɔ onua foforo bi ka mo ho?’ Nsɛm a obisaa yɛn no na yebuaa no. Na yennim sɛ ɔbɛka se, ‘Momfa mo nua kumaa no mmra.’ ” ");
INSERT INTO twi_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ɛhɔ na Yuda ka kyerɛɛ nʼagya Israel se, “Fa yɛn nua no hyɛ me nsa, na yensi mu nkɔ ntɛm nkɔtɔ aduan no bi mmra, na ɔkɔm ankum yɛn ne wo ne yɛn mma. ");
INSERT INTO twi_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mʼankasa mɛhwɛ abofra no so. Sɛ mamfa no amma a, bisa me. Sɛ mamfa no amma, ammegyina wʼanim ha, amma woanhu sɛ wo ba no ni a, saa asodi no nna me so me nkwanna nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Sɛ yɛantwentwɛn yɛn nan ase a, anka saa bere yi, yɛakɔ aba bɛyɛ mprenu.” ");
INSERT INTO twi_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Afei, wɔn agya Israel ka kyerɛɛ wɔn se, “Sɛ meyɛ ho hwee na ɛrenyɛ yiye de a, ɛno de, momfa asase yi so nnepa a bi ne akyenkyennuru kakra, ɛwo kakra, aduhuam, kurobow, nkate ne ɔsonkoran aba nhyɛ mo nkotoku mu, nkɔyɛ owura no ayɛ. ");
INSERT INTO twi_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Sika a mode rekɔ no nso, monyɛ no mmɔho efisɛ ɛsɛ sɛ mosan de sika a kan no mode kɔe na ɔsan de hyɛɛ mo nnesoa mu bae no kɔma no. Ebia na ɛyɛɛ no anipaso. ");
INSERT INTO twi_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Momfa mo nua no nso nka mo ho, na munsi mu ntɛmntɛm nkɔ. ");
INSERT INTO twi_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Otumfo Nyankopɔn nnyina mo akyi, na owura no nhu mo mmɔbɔ, na onyaa mo nua panyin Simeon, na ɔmfa Benyamin nso nka mo ho, na mo nyinaa nsan mmra. Sɛ ɛsɛ sɛ midi wɔn wu ho awerɛhow nso a, minni asɛm biara ka.” ");
INSERT INTO twi_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Enti Israelmma no faa akyɛde ahorow a wɔde rekɔ akɔyɛ owura no ayɛ no, ne wɔn sika mmɔho abien, ne wɔn nua kumaa Benyamin kaa wɔn ho, sii mu kɔe. Woduu Misraim no, wokoyii wɔn ho adi kyerɛɛ Yosef. ");
INSERT INTO twi_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Bere a Yosef huu sɛ Benyamin ka wɔn ho no, ɔka kyerɛɛ ne fi somfo panyin no se, “Fa nkurɔfo no kɔ me fi, na kum aboa bi, na wɔmfa nnoa aduan, na awia me ne wɔn bedidi.” ");
INSERT INTO twi_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ɔsomfo panyin no yɛɛ sɛnea Yosef kae no ma ɔde nkurɔfo no kɔɔ Yosef fi. ");
INSERT INTO twi_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ɔde wɔn duu Yosef fi no, wosuroe. Wɔkae se, “Gyama esiane dwetɛ a yɛbɛtɔɔ aduan a edi kan no wɔde hyehyɛɛ yɛn nkotoku mu no nti na ɔde yɛn aba ha. Ɔpɛ sɛ ɔde korɔn to yɛn so, na ɔfa yɛn sɛ ne nkoa, na ɔsan fa yɛn mfurum no nyinaa.” ");
INSERT INTO twi_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Woduu Yosef fi kwan no ano no, wɔkɔɔ Yosef somfo panyin no nkyɛn. ");
INSERT INTO twi_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Wɔka kyerɛɛ no se, “Yɛn wura, yɛsrɛ wo, yɛbaa ha bere bi a atwa mu bɛtɔɔ aduan. ");
INSERT INTO twi_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Bere a yɛresan akɔ yɛn kurom a ade sae, na yɛsoɛsoɛɛ no, asoɛe hɔ na yebuebuee yɛn nkotoku ano, na yehuu sɛ obiara sika a okurae a anka ɔde rekɔtɔ aburow no hyɛ ne kotoku no mu pɛpɛɛpɛ. Ɛno nti, yɛasan de aba. ");
INSERT INTO twi_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Yɛasan de sika foforo aba sɛ yɛde rebɛtɔ aduan. Yennim onipa ko a ɔde saa sika no hyehyɛɛ yɛn nkotoku no mu.” ");
INSERT INTO twi_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ɔsomfo panyin no ka kyerɛɛ wɔn se, “Ɛnyɛ asɛm biara. Munnsuro. Onyame a mosom no ne mo agya Nyame a ɔsom no no na ɔde saa sika no hyehyɛɛ mo nkotoku no mu maa mo. Na mo sika no de, yegyei.” Afei, oyii Simeon fii afiase hɔ de no brɛɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ɔsomfo panyin no de wɔn kɔɔ Yosef fi, maa wɔn nsu hohoroo wɔn anan ase, na ɔmaa wɔn mfurum no nso aduan dii. ");
INSERT INTO twi_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Wɔboaboaa akyɛde a wɔde bɛma Yosef no ano de twɛn no, efisɛ na wɔate sɛ wobedidi wɔ fie hɔ awia no. ");
INSERT INTO twi_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Bere a Yosef bae no, anuanom no buu no nkotodwe, de wɔn akyɛde no maa no. ");
INSERT INTO twi_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yosef bisaa wɔn sɛnea wɔn ho te. Ɔtoaa so se, “Mo agya akwakoraa a mokaa ne ho asɛm no ho te dɛn? Ɔda so te ase ana?” ");
INSERT INTO twi_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wobuaa no se, “Wʼakoa a ɔyɛ yɛn agya no ho ye. Ɔda so te ase.” Wɔde obu ne nidi bɔɔ wɔn mu ase wɔ nʼanim. ");
INSERT INTO twi_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Bere a nʼani tɔɔ ne na ba Benyamin anim no, obisae se, “Oyi ne mo nua kumaa a mokaa ne ho asɛm kyerɛɛ me no ana?” Ɔtoaa so se, “Me ba, Onyankopɔn nnom wo!” ");
INSERT INTO twi_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yosef huu ne nua kumaa Benyamin no, ne werɛ howee, enti ɔyɛɛ ntɛm fii adi kɔhyɛɛ ne pia mu kosui. ");
INSERT INTO twi_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Osu wiee no, ɔhohoroo nʼanim, san bae de animia kae se, “Momma yennidi!” ");
INSERT INTO twi_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Wɔtoo Yosef pon wɔ baabi, na wɔtoo anuanom no nso pon wɔ baabi wɔ ɔdan koro no ara mu. Misraimfo a wɔyɛ Yosef asomfo no nso didii wɔ baabi foforo, efisɛ Misraimfo no mmu Hebrifo, na wɔne wɔn ato nsa adidi. ");
INSERT INTO twi_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Wɔde Yosef nuanom no tenatenaa ase mpanyin mu. Ɛyɛɛ saa maa anuanom no de ahodwiriw hwehwɛɛ wɔn ho wɔn ho anim. ");
INSERT INTO twi_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Wotitii nnuan no fi Yosef pon so kɔmaa wɔn no, na Benyamin de no dɔɔso sen ne nua biara de mpɛn anum. Ɛmaa wɔne Yosef de anigye ne ahosɛpɛw didi nomee. ");
INSERT INTO twi_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Afei, Yosef hyɛɛ ne somfo panyin no se, “Fa aduan dodow biara a mmarima no betumi asoa no hyɛ wɔn nkotoku no amaama, na fa obiara sika nso hyɛ ne kotoku mu ma no. ");
INSERT INTO twi_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Na fa me dwetɛ kuruwa no ka akumaa no aduan no sika ho, na fa hyɛ ne kotoku no mu.” Na ɔyɛɛ sɛnea Yosef kaa no pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ade kyee anɔpa no, ogyaa anuanom no ne wɔn mfurum no kwan. ");
INSERT INTO twi_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Wɔannu akyiri baabiara, na Yosef ka kyerɛɛ ne somfo panyin no se, “Tiw nkurɔfo no ntɛm, na sɛ woto wɔn a, bisa wɔn se, ‘Adɛn nti na mode bɔne tua papa ka? Adɛn nti na moawia me dwetɛ kuruwa? ");
INSERT INTO twi_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ɛnyɛ saa kuruwa yi a me wura nom ano na ɔhwɛ mu ka nhumusɛm no ni? Eyi yɛ bɔne kɛse a moayɛ.’ ” ");
INSERT INTO twi_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ɔkɔtoo wɔn no, otii saa asɛm koro yi ara mu kyerɛɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nanso anuanom no buaa no se, “Adɛn nti na yɛn wura keka saa nsɛm yi? Ɛmpare wo nkoa sɛ wɔbɛyɛ ade a ɛte saa! ");
INSERT INTO twi_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Sika a yehuu wɔ yɛn nkotoku mu no, yɛansan amfa amfi Kanaan ammrɛ mo ana? Adɛn nti na ɛsɛ sɛ yewia dwetɛ anaa sikakɔkɔɔ fi wo wura fi? ");
INSERT INTO twi_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Sɛ wuhu saa kuruwa no wɔ wo nkoa no biara nkyɛn a, okum na ɛsɛ sɛ wukum saa onipa no. Na sɛ ɛba saa nso a, yɛn nyinaa bɛyɛ wo wura nkoa.” ");
INSERT INTO twi_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ɔsomfo no buae se, “Eye, na nea owiae no nko na ɔbɛyɛ mʼakoa; na mo a moaka no bɛfa mo ho adi.” ");
INSERT INTO twi_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Anuanom no nyinaa yiyii wɔn nnesoa no fii mfurum no so guu fam, sansan wɔn nkotoku no ano. ");
INSERT INTO twi_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Na ɔsomfo no fii ase, hwehwɛɛ wɔn nkotoku no mu fi ɔpanyin no so kosii akumaa no so. Wohuu kuruwa no wɔ Benyamin kotoku no mu. ");
INSERT INTO twi_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ɛbaa saa no, anuanom no sunsuan wɔn ntade mu. Afei, wɔn nyinaa san hyehyɛɛ wɔn nnesoa no wɔ wɔn mfurum no so, san kɔɔ kurow no mu. ");
INSERT INTO twi_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Bere a Yuda ne ne nuanom no koduu kurow no mu hɔ no, na Yosef da so wɔ ne fi hɔ. Enti wɔn nyinaa totow wɔn ho guu fam wɔ nʼanim. ");
INSERT INTO twi_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosef bisaa wɔn se, “Dɛn ade na moayɛ yi? Munnim sɛ onipa a ɔte sɛ me nam nhumusɛm so betumi ahu biribiara mu ana?” ");
INSERT INTO twi_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda buae se, “Anoyi bɛn na yebetumi ayi wɔ me wura anim? Asɛm bɛn na yɛwɔ ka? Yɛbɛyɛ dɛn na yɛatumi ama woahu sɛ yenni saa asɛm yi ho fɔ? Onyame ada yɛn wʼasomfo afɔdi yi adi. Yɛne nea wohuu kuruwa no wɔ no nkyɛn no nyinaa yɛ yɛn wura nkoa.” ");
INSERT INTO twi_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Nanso Yosef kae se, “Ɛmpare me sɛ mɛyɛ ade a ɛte saa. Onipa a wohuu kuruwa no wɔ ne nkyɛn no nko ara na ɔbɛyɛ mʼakoa. Mo a moaka no de, monsan nkɔ mo agya nkyɛn asomdwoe mu.” ");
INSERT INTO twi_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda sɔre kɔɔ Yosef anim, ka kyerɛɛ no se, “Ma me a meyɛ wʼakoa no kwan na me ne wo, me wura, nkasa. Ɛwɔ mu sɛ wo ne Farao yɛ pɛ de, nanso mesrɛ wo, nya ntoboase ma wʼakoa. ");
INSERT INTO twi_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Me wura bisaa nʼasomfo no se, ‘Mowɔ agya anaa onuabarima bi?’ ");
INSERT INTO twi_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Na yebuae se, ‘Yɛwɔ agya a wabɔ akwakoraa ne yɛn kaakyiri a ɔwoo no ne nkwakoraabere mu. Ne nuabarima a ɔka ne ho no awu. Na ɔno nko ara ne ne na ba a waka. Nʼagya pɛ nʼasɛm yiye.’ ");
INSERT INTO twi_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Na ɔka kyerɛɛ wʼasomfo se, ‘Momfa no mmra, na menhwɛ no.’ ");
INSERT INTO twi_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Yɛka kyerɛɛ me wura se, ‘Abarimaa no rentumi ntew ne ho mfi nʼagya ho. Na sɛ ɛba sɛ ɔtew ne ho fi nʼagya ho a, nʼagya no bewu.’ ");
INSERT INTO twi_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ɛnna woka kyerɛɛ wʼasomfo se. ‘Sɛ moamfa mo nua kumaa no anka mo ho amma a, munnsi mʼanim bio.’ ");
INSERT INTO twi_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Yɛsan kɔɔ wʼakoa, yɛn agya nkyɛn no, yɛkaa wo a woyɛ yɛn wura no nsɛm a woka kyerɛɛ yɛn no nyinaa kyerɛɛ no. ");
INSERT INTO twi_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Na yɛn agya kae se, ‘Monsan nkɔ bio nkɔtɔ aduan kakra mmra.’ ");
INSERT INTO twi_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nanso yɛka kyerɛɛ yɛn agya se, ‘Yɛrentumi nkɔ, gye sɛ yɛn nua kumaa no ka yɛn ho. Sɛ yɛamfa yɛn nua kumaa no anka yɛn ho ankɔ a, yɛrentumi nkɔ owura no anim.’ ");
INSERT INTO twi_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Wʼakoa, yɛn agya, ka kyerɛɛ yɛn se, ‘Munim sɛ me ne me yere woo mmabarima baanu. ");
INSERT INTO twi_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Wɔn mu baako fii me nkyɛn kɔe a manhu no bio ma mekae se, “Aboa bi atetew no pasaa.” Efi saa bere no, minhuu no bio. ");
INSERT INTO twi_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Sɛ mofa oyi fi me nkyɛn, na asiane bi kosiane no wɔ kwan so a, me nso, mede awerɛhow bewu bi.’ ");
INSERT INTO twi_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Enti saa bere yi, sɛ yekopue fi wʼakoa, yɛn agya, anim na abofra yi nka yɛn ho, ne sɛnea ne koma da abofra no so fa no, ");
INSERT INTO twi_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","sɛ ohu sɛ abofra no nka yɛn ho a, obewu. Wo nkoa bɛma wɔn agya de ne ti so dwen akɔ asaman awerɛhow mu. ");
INSERT INTO twi_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Wʼakoa a ɔde ne ho dii abofra no akagyinamu sɛ ɔde no bɛba no kae se, ‘Sɛ mamfa no ansan ammrɛ wo a, ɛho asodi no mmɛda me so, me nkwanna nyinaa.’ ");
INSERT INTO twi_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Afei, mesrɛ wo, ma wʼakoa nsi abofra no anan mu wɔ ha, na ma abofra no ne ne nuabarimanom no nsan nkɔ. ");
INSERT INTO twi_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Na sɛ abofra no anka me ho ankɔ a, mɛyɛ dɛn na makopue wɔ mʼagya anim? Dabi! Merentumi nnyina ahohia a ɛbɛto mʼagya wɔ saa asɛm yi ho no ano.” ");
INSERT INTO twi_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Afei, na Yosef yɛ ne ho hwee a, ɛnyɛ yiye wɔ nʼasomfo no nyinaa anim. Enti ɔteɛɛ mu kyerɛɛ nʼasomfo no se, “Obiara mfi ha nkɔ.” Enti bere a oyii ne ho adi kyerɛɛ ne nuanom no, na asomfo no mu biara nni hɔ. ");
INSERT INTO twi_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Osuu denneennen maa Misraimfo no tee, Farao fifo tee asɛm no. ");
INSERT INTO twi_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosef ka kyerɛɛ ne nuabarimanom no se, “Mene Yosef! Mʼagya te ase ana?” Nanso asɛm no bɔɔ wɔn piriw ma wɔtotɔɔ mum wɔ nʼanim. ");
INSERT INTO twi_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yosef ka kyerɛɛ ne nuabarimanom no se, “Montwiw mmɛn me.” Wotwiw bɛn no no, ɔka kyerɛɛ wɔn se, “Mene mo nuabarima Yosef. Me na motɔn me ma wɔde me kɔɔ Misraim no. ");
INSERT INTO twi_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Mommma biribiara nhaw mo. Na monnkasakasa so sɛ motɔn me ma wɔde me baa ha. Onyankopɔn na ɔyɛe. Ɔno na ɔsomaa me, dii mo anim baa ha sɛ mimmegye mo nkwa. ");
INSERT INTO twi_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Mfe abien ni a ɔkɔm baa asase yi so. Mfe anum a ɛreba yi nso, obiara rennua, na obiara nso rentwa. ");
INSERT INTO twi_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Onyankopɔn asoma me ha sɛ memma mo ne mo fifo ntena nkwa mu, na moayɛ ɔman kɛse. ");
INSERT INTO twi_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Enti ɛnyɛ mo na mode me baa ha, na ɛyɛ Onyankopɔn ankasa! Wayɛ me Farao fotufo ne ne fi sohwɛfo, na ɔde Misraiman nyinaa nso ahyɛ me nsa. ");
INSERT INTO twi_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Afei, monka mo ho nkɔ mʼagya nkyɛn nkɔka nkyerɛ no se, ‘Sɛnea wo babarima Yosef se ni, Onyankopɔn ayɛ me Misraiman nyinaa sohwɛfo. Enti ntwentwɛn wʼanan ase koraa, na bra Misraim! ");
INSERT INTO twi_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Wobɛba abɛtena Gosen asase so, na woabɛn me. Fa wo mma, wo nananom, wo nguan ne wʼanantwi ne biribiara a wowɔ bra. ");
INSERT INTO twi_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Sɛ woba hɔ a, mɛhwɛ wo, efisɛ aka saa ɔkɔm kɛse yi mfe anum. Sɛ anyɛ saa a, wo ne wo fifo ne wɔn a wɔka wo ho nyinaa bedi hia buruburoo.’ ");
INSERT INTO twi_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Mo ne me nua Benyamin nyinaa di adanse sɛ, ampa ara, ɛyɛ me Yosef na me ne morekasa yi. ");
INSERT INTO twi_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Monka anuonyam a Onyame adom nti, wɔahyɛ me wɔ Misraim asase so ne biribiara a mo ankasa mode mo ani abehu no nyinaa ho asɛm nkyerɛ mʼagya. Monkɔfa mʼagya nsian mmrɛ me ntɛm.” ");
INSERT INTO twi_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ɔyɛɛ Benyamin atuu, sui, a anigye ne awerɛhow adi afra. Benyamin nso fii ase sui. ");
INSERT INTO twi_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ofifew ne nuanom no nyinaa ano sui, na ɛno akyi no, wotumi ne no kasae. ");
INSERT INTO twi_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Bere a wɔtee wɔ Farao fi sɛ Yosef nuanom no aba no, Farao ne ne mpanyimfo a wɔka ne ho no nyinaa ani gyei. ");
INSERT INTO twi_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farao ka kyerɛɛ Yosef se, “Ka kyerɛ wo nuanom no se, wɔmfa nneɛma nsoasoa wɔn mmoa no, na wɔnkɔ Kanaan asase so, ");
INSERT INTO twi_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","na wɔnkɔfa wɔn agya ne wɔn abusuafo nyinaa mmra Misraim asase so ha mmɛtena ha. Ka kyerɛ wɔn se, ‘Farao bɛma mo Misraim asase no fa a eye pa ara atena so. Wobedi asase no so nnepa!’ ");
INSERT INTO twi_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Ka kyerɛ wɔn se, ‘Momfa nteaseɛnam mfi Misraim ha nkɔfa mo yerenom ne mo mma. Momfa mo agya nso nka ho mmra. ");
INSERT INTO twi_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Monnhaw mo ho wɔ mo agyapade ho, efisɛ mede nnepa a ɛwɔ Misraim asase so nyinaa no bi bɛma mo.’ ” ");
INSERT INTO twi_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Enti Yosef maa wɔn nteaseɛnam ne nnuan a wobedi wɔ ɔkwan so, sɛnea Farao hyɛe no. ");
INSERT INTO twi_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ɔmaa ne nuanom no mu biara atade foforo, nanso Benyamin de, ɔmaa no ntade ahorow anum ne dwetɛ kilogram abiɛsa ne fa. ");
INSERT INTO twi_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Saa nneɛma a edidi so yi nso na Yosef de kɔmaa nʼagya Israel: mfurumnini du a wɔahyehyɛ Misraim nneɛma pa wɔ wɔn so, mfurummmere du a wɔsoso aburow, brodo ne nnuan ahorow ne nʼakwansoduan. ");
INSERT INTO twi_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ogyaa ne nuanom no kwan, na akwannya no mu no, ɔka kyerɛɛ wɔn se, “Monnkɔkasakasa wɔ ɔkwan so.” ");
INSERT INTO twi_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Enti wofii Misraimman mu kɔɔ wɔn agya Israel nkyɛn wɔ Kanaan asase so. ");
INSERT INTO twi_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wodui no, wɔde anigye bɔɔ wɔn agya amanneɛ se, “Yosef te ase! Nokwasɛm ni, ɔno na odi Misraiman nyinaa so!” Israel tee saa asɛm no, ne ho dwiriw no. Wannye anni. ");
INSERT INTO twi_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Na bere a wɔkaa nsɛm a Yosef ka kyerɛɛ wɔn sɛ wɔmmɛka no wiee no, na ohuu nteaseɛnam a Yosef de somaa sɛ wɔmfa mmɛfa no no, wɔn agya Yakob ho san no. ");
INSERT INTO twi_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Na Israel kae se, “Magye nsɛm no nyinaa adi. Me ba Yosef da so te ase. Mɛkɔ akohu no ansa na mawu.” ");
INSERT INTO twi_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Enti Israel de nʼahode nyinaa sii mu koduu Beer-Seba. Ɔbɔɔ Onyankopɔn a na nʼagya Isak som no no afɔre wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Anadwo anisoadehu mu no, Onyankopɔn frɛɛ Yakob se, “Yakob! Yakob!” Yakob gyee so se, “Me ni.” ");
INSERT INTO twi_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Onyankopɔn ka kyerɛɛ no se, “Mene Onyankopɔn. Onyankopɔn a wʼagya som no. Nsuro sɛ wobɛkɔ Misraim, efisɛ mɛma wʼase adɔ ayɛ ɔman kɛse wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mʼankasa ne wo bɛkɔ Misraim, na masan de wo aba ha. Edu bere a worebewu a, wubewu wɔ Yosef nsam.” ");
INSERT INTO twi_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Na Yakob sii mu fii Beer-Seba. Israelmma no de wɔn agya Yakob, wɔn yerenom ne wɔn mma tenatenaa nteaseɛnam a Farao soma ma wɔde bɛfaa wɔn no mu. ");
INSERT INTO twi_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Wɔfaa wɔn mmoa ne wɔn agyapade a wɔanya wɔ Kanaan asase so no nyinaa kaa wɔn ho kɔɔ Misraim. Yakob ne nʼasefo nyinaa sii mu kɔɔ Misraim. ");
INSERT INTO twi_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Israel de ne mmabarima, ne nenanom, ne mmabea ne wɔn mma a wɔn nyinaa yɛ nʼasefo kaa ne ho kɔɔ Misraim. ");
INSERT INTO twi_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Din a edidi so yi yɛ Israelfo, Yakob asefo a ɔde wɔn kɔɔ Misraim. Ruben yɛ Yakob abakan. ");
INSERT INTO twi_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben nso mmabarima din na edidi so yi: Hanok, Palu, Hesron ne Karmi. ");
INSERT INTO twi_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon nso mmabarima yɛ: Yemuel, Yamin, Ohad, Yakin, Sohar ne Saulo a ne na yɛ Kanaanni. ");
INSERT INTO twi_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi mmabarima din na edidi so yi: Gerson, Kohat ne Merari. ");
INSERT INTO twi_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda nso mmabarima yɛ: Er, Onan, Sela, Peres ne Serah. Nanso Er ne Onan de, wowuwuu wɔ Kanaan asase so ansa na Israel reba Misraim asase so. Peres mmabarima yɛ: Hesron ne Hamul. ");
INSERT INTO twi_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakar mmabarima nso yɛ: Tola, Puwa, Hiob ne Simron. ");
INSERT INTO twi_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon mmabarima nso yɛ: Sered, Elon ne Yakleel. ");
INSERT INTO twi_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Wɔn a wɔabobɔ wɔn din yi yɛ Lea mma a ɔne Yakob woo wɔ Paddan-Aram a ne babea Dina nso ka ho. Saa mmabarima ne ne babea yi nyinaa dodow si nnipa aduasa abiɛsa. ");
INSERT INTO twi_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad nso mma din na edidi so yi: Sifion, Hagi, Suni, Esbon, Eri, Arodi ne Areli. ");
INSERT INTO twi_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser nso mma din na edidi so yi: Yimna, Isua, Isui ne Beria ne wɔn nuabea Sera. Beria nso mma yɛ: Heber ne Malkiel. ");
INSERT INTO twi_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Eyinom nso ne Silpa, afenaa a Laban de no maa ne babea Lea a ɔno nso de no maa ne kunu Yakob waree no mma. Wɔn nyinaa dodow ano si nnipa dunsia. ");
INSERT INTO twi_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakob yere Rahel mma yɛ: Yosef ne Benyamin. ");
INSERT INTO twi_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosef ne ne yere Asnat, a ɔyɛ Potifera a ɔyɛ On bosomfo babea woo Manase ne Efraim wɔ Misraim. ");
INSERT INTO twi_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin nso mmabarima din na edidi so yi: Bela, Beker, Asbel, Gera, Naaman, Ehi, Ros, Mupim, Hupim ne Ard. ");
INSERT INTO twi_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Saa nnipa a wɔabobɔ wɔn din yi yɛ Rahel mmabarima a ɔne Yakob woe. Wɔn nyinaa dodow yɛ nnipa dunan. ");
INSERT INTO twi_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan babarima yɛ Husim. ");
INSERT INTO twi_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali nso mmabarima din na edidi so yi: Yahseel, Guni, Yeser ne Silem. ");
INSERT INTO twi_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bilha a ɔyɛ Laban afenaa a ɔde no maa ne babea Rahel mmabarima a ɔne Yakob woo no na wɔabobɔ wɔn din yi. Na wɔn dodow yɛ nnipa baason. ");
INSERT INTO twi_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Nnipa a Yakob de wɔn kɔɔ Misraim nyinaa, a wɔyɛ nʼasefo ankasa, a ne mmabarima yerenom nka ho dodow yɛ aduosia asia. ");
INSERT INTO twi_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Sɛ wɔde Yosef mmabarima baanu a ɔwoo wɔn wɔ Misraim no ka ho a, na Yakob asefo a ɔde wɔn kɔɔ Misraim no nyinaa dodow yɛ nnipa aduɔson. ");
INSERT INTO twi_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Israel somaa Yuda ma odii kan kɔɔ Yosef hɔ kobisaa no Gosen kwan. Akyiri no, wokoduu Gosen. ");
INSERT INTO twi_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosef siesiee ne nteaseɛnam ma wɔkɔɔ Gosen kohyiaa nʼagya Israel. Yosef duu nʼagya Yakob anim pɛ na ɔbam no, sui ara kwansin. ");
INSERT INTO twi_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel ka kyerɛɛ Yosef se, “Ohu a mahu wo sɛ wote ase yi nti, sɛ owu bɛfa me nnɛ koraa a, mepɛ.” ");
INSERT INTO twi_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yosef ka kyerɛɛ ne nuanom no ne nʼagya fifo no se, “Mɛkɔ akɔka akyerɛ Farao se, ‘Me nuabarimanom ne mʼagya fifo a na anka wɔte Kanaan asase so nyinaa aba ha abɛka me ho. ");
INSERT INTO twi_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mmarima no yɛ nguanhwɛfo. Wɔhwɛ mmoa so. Na wɔde wɔn nguan ne wɔn anantwi ne biribiara a wɔwɔ aba.’ ");
INSERT INTO twi_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Sɛ Farao frɛ mo, na obisa mo se, ‘Adwuma bɛn na moyɛ a,’ ");
INSERT INTO twi_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","momma no mmuae se, ‘Wo nkoa ayɛn mmoa fi wɔn mmofraase, te sɛ nea yɛn agyanom yɛe no ara pɛpɛɛpɛ.’ Sɛ moka saa kyerɛ no a, ɔbɛma mode Gosen ayɛ mo atenae, efisɛ Misraimfo kyi nguanhwɛfo kɔkɔɔkɔ.” ");
INSERT INTO twi_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yakob mma no beduu Misraim asase so no, Yosef kɔka kyerɛɛ Farao se, “Mʼagya ne me nuanom no de wɔn nguan ne wɔn anantwi ne wɔn agyapade nyinaa afi Kanaan asase so aba, na wɔwɔ Gosen asase so.” ");
INSERT INTO twi_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yosef yii ne nuabarimanom no mu baanum de wɔn kokyia Farao. ");
INSERT INTO twi_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao bisaa anuanom no se, “Adwuma bɛn na moyɛ?” Wobuaa no se, “Wo nkoa yɛ nguanhwɛfo, sɛnea na yɛn agyanom nso yɛ nguanhwɛfo no.” ");
INSERT INTO twi_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Anuanom no toaa so se, “Yɛaba ha sɛ ananafo a yɛrebɛtena ha kakra, efisɛ ɔkɔm no ano yɛ den yiye wɔ Kanaan asase so hɔ, na wo nkoa nguan nnya aduan nni. Enti yɛresrɛ wo kwan na yɛatena Gosen asase so ha.” ");
INSERT INTO twi_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Farao ka kyerɛɛ Yosef se, “Wʼagya ne wo nuanom aba wo nkyɛn. ");
INSERT INTO twi_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Misraim asase nyinaa hyɛ wo nsa. Ma wʼagya ne wo nuabarimanom baabi pa na wɔntena. Ma wɔntena Gosen asase so. Sɛ wunim wɔn mu bi a wɔwɔ mmoayɛn ho nimdeɛ a, ma wɔnhwɛ me nguan so mma me.” ");
INSERT INTO twi_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Afei, Yosef kɔfaa nʼagya Yakob de no bekyiaa Farao ma Yakob hyiraa no. ");
INSERT INTO twi_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao bisaa Yakob se, “Woadi mfe ahe?” ");
INSERT INTO twi_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob buaa Farao se, “Madi mfe ɔha ne aduasa a ɔhaw ne abɛbrɛsɛ wɔ mu. Minnu mʼagyanom nkwanna a wɔde tenaa asase so no ho hwee.” ");
INSERT INTO twi_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Na Yakob hyiraa Farao, na ofii nʼanim kɔe. ");
INSERT INTO twi_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Enti Yosef bɔɔ nʼagya ne ne nuanom no atenase wɔ Misraim asase so. Ɔmaa wɔn agyapade wɔ asase no fa baabi a eye pa ara wɔ Rameses mansin mu, sɛnea Farao hyɛe no. ");
INSERT INTO twi_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yosef maa nʼagya ne ne nuanom no aduan sɛnea wɔn mma dodow te. ");
INSERT INTO twi_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Na aduan nni hɔ baabiara, efisɛ na ɔkɔm a aba no ano ayɛ den yiye. Saa ɔkɔm yi kaa Misraim ne Kanaan asase nyinaa ma emu nnipa ne nnɔbae twintwamee. ");
INSERT INTO twi_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yosef prapraa Misraim ne Kanaan asase so sika nyinaa a onya fii aduantɔn no mu no baa Farao ahemfi. ");
INSERT INTO twi_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Bere a nnipa a wɔwɔ Misraim ne Kanaan asase so ho sika nyinaa sae no, Misraim nnipa nyinaa baa Yosef nkyɛn bɛka kyerɛɛ no se, “Yɛn ho sika nyinaa asa, enti ma yɛn aduan nni! Adɛn nti na ɛsɛ sɛ yewuwu?” ");
INSERT INTO twi_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosef buaa wɔn se, “Sɛ mo sika asa de a, momfa mo nguan ne mo anantwi mmra mmegye aduan.” ");
INSERT INTO twi_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Enti wɔde wɔn mmoa no brɛɛ Yosef. Mmoa a wɔde wɔn bɛsesaa aduan no yɛ apɔnkɔ, nguan, mmirekyi, anantwi ne mfurum. Saa afe no mu no, wɔde wɔn mmoa nyinaa bɛsesaa aduan. ");
INSERT INTO twi_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Afe akyi no, Misraimfo no nyinaa baa Yosef nkyɛn bɛkae se, “Yɛrentumi mfa biribiara nhintaw yɛn wura. Yɛn ho sika nyinaa asa, na yɛn anantwi nso yɛ wo dea. Hwee nni hɔ bio a yebetumi de abrɛ wo, yɛn wura, sɛ yɛn nnipadua ne yɛn nsase nko. ");
INSERT INTO twi_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Adɛn nti na ɛsɛ sɛ yɛhwere yɛn nkwa ne yɛn nsase wɔ wʼanim! Afei, ma yɛmfa yɛn nnipadua ne yɛn nsase nyinaa mmɛsesa aduan. Yɛde yɛn ho ne yɛn nsase nyinaa bɛkɔ nkoasom mu. Ma yɛn aburow, na ɔkɔm ankum yɛn, amma asase no nso anna mpan.” ");
INSERT INTO twi_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Enti Yosef tɔɔ Misraim nsase nyinaa maa Farao. Esiane ɔkɔm no ano den nti, Misraimfo no tɔn wɔn nsase no nyinaa. Ɛyɛɛ saa ma nsase no nyinaa bedii Farao nsam. ");
INSERT INTO twi_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Efi Misraim ti kosi ti, Yosef de mu nnipa nyinaa bɛyɛɛ ne nkoa. ");
INSERT INTO twi_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Asɔfo nko ara nsase na wantɔ, efisɛ asɔfo no de, na Farao atwa anoduan bi de ama wɔn. Ne saa nti na wɔn de, wɔantɔn wɔn nsase no. ");
INSERT INTO twi_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yosef ka kyerɛɛ nnipa no se, “Afei a matɔ mo ne nsase de ama Farao yi, mo nso, munnye aburow nkodua. ");
INSERT INTO twi_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Na sɛ aburow no yɛ yiye, na mutwa a, momfa nkyɛmu anum mu baako mmrɛ Farao. Na nkyɛmu anum mu anan a ɛbɛka no, mo ne mo fifo ne mo mma nni bi, na munnyaw bi nso a mubedua.” ");
INSERT INTO twi_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Wɔkae se, “Anokwa, woagye yɛn nkwa. Ka kyerɛ yɛn wura Farao se, onnye yɛn nto mu, na yɛnyɛ nkoa.” ");
INSERT INTO twi_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ɛnam saa asɛm yi so maa mmara a Yosef hyɛe sɛ wɔmfa asase no so nnɔbae nyinaa mu nkyɛmu anum mu baako mma Farao no da so wɔ hɔ besi nnɛ. Asɔfo no nsase nko ara na ankodi Farao nsam. ");
INSERT INTO twi_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israelfo no bɔɔ atenase wɔ Gosen mansin a ɛwɔ Misraim asase so no so. Wonyaa agyapade wɔ hɔ, na wɔn ase nso fɛee yiye. ");
INSERT INTO twi_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakob tenaa Misraim mfe dunson. Odii mfirihyia ɔha ne aduanan ason ansa na ɔrewu. ");
INSERT INTO twi_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Eduu sɛ Yakob rebewu no, ɔfrɛɛ ne ba Yosef, ka kyerɛɛ no se, “Me ba, sɛ wodɔ me de a, ka ntam di nsew sɛ, wobɛyɛ me adɔe, adi me nokware. Sɛ miwu a, nsie me wɔ Misraim ha. ");
INSERT INTO twi_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Sɛ miwu a, momfa me mfi Misraim ha, nkosie me wɔ faako a wosiee me mpanyimfo no.” Yosef hyɛɛ bɔ se, “Medi asɛm a woaka no so.” ");
INSERT INTO twi_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakob kaa bio se, “Ka ntam kyerɛ me.” Yosef kaa ntam no, na Israel nso butuw ne pema so sɔree Onyankopɔn. ");
INSERT INTO twi_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Mmere bi akyi no, wɔka kyerɛɛ Yosef se, “Wʼagya yare.” Enti Yosef faa ne mmabarima baanu, Efraim ne Manase kaa ne ho kɔsraa no. ");
INSERT INTO twi_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Bere a wɔbɔɔ Yakob amanneɛ se, “Wo ba Yosef aba wo nkyɛn rebɛsra wo” no, Yakob miaa nʼani sɔre tenaa ne mpa so. ");
INSERT INTO twi_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakob ka kyerɛɛ Yosef se, “Otumfo Nyankopɔn yii ne ho adi kyerɛɛ me wɔ Lus a ɛwɔ Kanaan asase so. Ɛhɔ na ohyiraa me, ");
INSERT INTO twi_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ka kyerɛɛ me se, ‘Mɛma woawo, ama wʼase afɛe. Mɛma wʼasefo ayɛ ɔman kɛse. Mede saa asase yi bɛma wʼasefo afebɔɔ sɛ wɔn agyapade.’ ");
INSERT INTO twi_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Ɛno nti, mede wo mma baanu a wɔwoo wɔn maa wo ansa na mereba wo nkyɛn wɔ Misraim asase so ha no bɛka me mma no ho. Efraim ne Manase bɛka me mma ho, sɛnea Ruben ne Simeon yɛ me mma no. ");
INSERT INTO twi_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mma foforo biara a wobɛwo wɔn wɔ Efraim ne Manase akyi no na wɔbɛyɛ wo de. Wɔde wɔn bɛka wɔn nuanom no ho wɔ asase a wɔde bɛma wɔn sɛ wɔn agyapade no so. ");
INSERT INTO twi_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Bere a mifi Paddan-Aram reba no, ababaa Rahel wuu wɔ ɔkwan mu ma ɛyɛɛ me yaw. Na aka akwansin kakraa bi na yɛadu Efrat. Ɛno nti, misiee no wɔ Eufrate, a wɔfrɛ no Betlehem no kwankyɛn baabi.” ");
INSERT INTO twi_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Bere a Israel huu Yosef mmabarima no, obisae se, “Na eyinom yɛ hefo?” ");
INSERT INTO twi_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosef buaa nʼagya se, “Wɔyɛ mmabarima a Onyankopɔn de wɔn adom me wɔ ha.” Na Israel kae se, “Fa wɔn bra mʼanim ha na minhyira wɔn.” ");
INSERT INTO twi_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Saa bere no, esiane onyin nti, na Israel ani so ayɛ wusiwusi a onhu ade papa. Ne saa nti, Yosef de ne mma no kɔɔ ne nkyɛn pɛɛ ma ɔyɛɛ wɔn atuu, fifew wɔn ano. ");
INSERT INTO twi_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel ka kyerɛɛ Yosef se, “Manna mannwene sɛ mehu wʼanim bio da, nanso hwɛ nea Onyame ayɛ. Wama me ho kwan ama mahu wo mma nso.” ");
INSERT INTO twi_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yosef maa wɔn so fii Israel kotodwe anim, na ɔno ara nso buu nkotodwe de nʼanim butuw fam. ");
INSERT INTO twi_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ɔsɔre no, ɔde ne nsa nifa soo Efraim mu, de no gyinaa Yakob benkum so, na ɔde ne nsa benkum soo Manase mu, de no gyinaa Yakob nifa so bɛn no pɛɛ. ");
INSERT INTO twi_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israel teɛɛ ne nsa nifa de too Efraim a ɔyɛ akumaa no apampam, na ɔde ne nsa benkum no too Manase nso apampam. Ɛwɔ mu sɛ na Manase yɛ abakan de, nanso ɔde ne nsa benkum na ɛtoo nʼapampam. ");
INSERT INTO twi_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ohyiraa Yosef se, “Onyankopɔn a mʼagyanom Abraham ne Isak nantew nʼanim, ne me Nyankopɔn a ɔhwɛɛ me sɛ oguanhwɛfo de besi nnɛ no, ");
INSERT INTO twi_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ɔsoro bɔfo a ogyee me fii ɔhaw nyinaa mu no, onhyira saa mmarimaa yi. Wɔmfa me din ne mʼagyanom, Abraham ne Isak din ntoto wɔn, na wɔn ase mfɛe wɔ asase so.” ");
INSERT INTO twi_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Bere a Yosef huu sɛ nʼagya de ne nsa nifa ato Efraim apampam no, anyɛ no dɛ. Enti oyii nʼagya nsa nifa no fii Efraim apampam, kɔtoo Manase apampam. ");
INSERT INTO twi_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yosef ka kyerɛɛ nʼagya se, “Dabi, mʼagya, oyi ne mʼabakan, nti fa wo nsa nifa to nʼapampam.” ");
INSERT INTO twi_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Nanso nʼagya ampene so kae se, “Me ba, minim saa. Ɔno nso bɛyɛ ɔman, na wayɛ ɔkɛse. Nanso ne nua kumaa no bɛyɛ ɔkɛse asen no, na nʼasefo bɛyɛ aman bebree.” ");
INSERT INTO twi_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Enti da no, Yakob hyiraa mmarimaa no se, “Israelfo nyinaa nam mo din so behyirahyira wɔn ho wɔn ho. Wɔbɛka se, ‘Onyankopɔn behyirahyira mo, ama moakɔ so frɔmfrɔm te sɛ Efraim ne Manase.’ ” Saa ɔkwan yi so na Yakob fa maa Efraim bedii Manase anim. ");
INSERT INTO twi_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Na Israel ka kyerɛɛ Yosef se, “Merebewu, nanso Onyankopɔn bɛhwɛ mo so, na wasan de mo akɔ Kanaan, mo agyanom asase so bio. ");
INSERT INTO twi_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Wo a mprempren woabɛyɛ wo nuanom nyinaa so panyin no, mede asase a menam me afoa ne mʼagyan so gye fii Amorifo nkyɛn no rema wo.” ");
INSERT INTO twi_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakob frɛɛ ne mmabarima nyinaa ka kyerɛɛ wɔn se, “Mummetwa me ho nhyia, na menka mo nea ɛbɛba mo so daakye. ");
INSERT INTO twi_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Yakob mmabarima, mommoaboa mo ho ano, na muntie; muntie mo agya Israel. ");
INSERT INTO twi_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, wo na woyɛ mʼabakan. Wo na woyɛ me tumi ne mʼahoɔden nsɛnkyerɛnne a edi kan a ɛboro anuonyam ne tumi so. ");
INSERT INTO twi_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Woyɛ kitikiti sɛ asorɔkye, nanso worenkɔ so bio, efisɛ woforoo wʼagya mpa ne ne yere kɔdae, de guu mʼanim ase. ");
INSERT INTO twi_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon ne Lewi yɛ anuanom. Wogyina hɔ ma basabasayɛ ne asisi. ");
INSERT INTO twi_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mma me nkɔka wɔn agyinatu ho, efisɛ wɔnam wɔn abufuw so akunkum nnipa, na wokunkum anantwi de gyee wɔn ani. ");
INSERT INTO twi_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nnome nka wɔn abufuw, efisɛ ano yɛ den, na ɛyɛ atirimɔdensɛm! Ɛno nti, mɛbɔ wɔn asefo ahwete Israelman mu nyinaa. ");
INSERT INTO twi_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda, wo nuabarimanom beyi wo ayɛ. Wobɛsɛe wʼatamfo nyinaa. Wʼagya mmabarima bɛkotow wo. ");
INSERT INTO twi_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, woyɛ gyata ba a woawe wʼatamfo nam awie. Wote sɛ gyata a wabutuw. Hena na obetumi akɔka no? ");
INSERT INTO twi_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ahempema remfi Yuda nsam, na saa ara nso na ahempema remfi nʼanan ntam, kosi sɛ, nea ɛyɛ ne dea a aman nyinaa betie no no bɛba. ");
INSERT INTO twi_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ɔbɛsa nʼafurum wɔ bobe dua mu. Ɔde nʼafurum ba bɛsa bobe pa mman mu. Ɔbɛhoro ne ntama wɔ nsa mu, na wahoro nʼatade nso wɔ bobesa kɔɔ mu. ");
INSERT INTO twi_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Nʼaniwa aba bebiri asen bobesa. Ne se bɛyɛ fitaa asen nufusu. ");
INSERT INTO twi_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebulon bɛtena mpoano. Obesisi ahyɛngyinabea ama ahyɛn. Nʼahye so bɛtrɛw akosi Sidon. ");
INSERT INTO twi_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakar yɛ afurum hoɔdenfo a obutuw hɔ rehome wɔ nguankuw mu. ");
INSERT INTO twi_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Sɛ ohu sɛnea nʼahomegyebea ye fa, ne sɛnea nʼasase no so dwo a, obekuntun agye adesoa, na wapene so sɛ akoa ama ɔhyɛ adwuma. ");
INSERT INTO twi_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan bebu ne manfo atɛn sɛ Israel mmusuakuw no baako. ");
INSERT INTO twi_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan bɛyɛ sɛ ɔwɔ a ɔda kwankyɛn; ɔbɛyɛ sɛ ahurutoa a ɔnam ɔtempɔn mu a ɔka ɔpɔnkɔ nantin, sɛnea ɛbɛma ne sotefo atew ahwe nʼakyi. ");
INSERT INTO twi_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Awurade, wo nkwagye na meretwɛn. ");
INSERT INTO twi_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Nnipa bɔnefo bɛtow ahyɛ Gad so, na ɔno nso betiw wɔn atow ahyɛ wɔn so. ");
INSERT INTO twi_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aser aduan a odi no bɛyɛ aduan pa. Na ɔbɛma ahennuan a ɛyɛ akɔnnɔ. ");
INSERT INTO twi_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali te sɛ ɔforote a wɔagyaa no a ɔwo mma ahoɔfɛfo. ");
INSERT INTO twi_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yosef yɛ ngodua a ɛsow aba, a esi asuten ho, na ne mman tra afasu. ");
INSERT INTO twi_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Agyantowfo kaa no hyɛe, de abufuw tow hyɛɛ ne so. ");
INSERT INTO twi_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Nanso ne bɛma no gyinaa pintinn, na ne basa mu yɛɛ den; esiane Otumfo Nyankopɔn a Yakob som no no a ɔyɛ oguanhwɛfo ne Israel botantim no; ");
INSERT INTO twi_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","esiane Onyankopɔn a wʼagya som no a ɔboa wo no; Otumfo a ɔde ɔsoro nhyira behyira wo; nhyira a efi asase ase pɛɛ; nhyira a efi nufu ne ɔyafunu mu no. ");
INSERT INTO twi_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Wʼagya nhyira a wɔahyira no no bɛdɔɔso asen tete nteredee mmepɔw ne nkoko a etintim hɔ daa no so nnɔbae. Eyinom nyinaa mmra Yosef ti so, engugu anuanom no mu nea wɔapaw no no anintɔn so. ");
INSERT INTO twi_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benyamin yɛ pataku a ɔyɛ nam; ɔbɔ aporɔw anɔpa, kyere ne hanam we, na edu anwummere a, ɔkyekyɛ nam nkae no.” ");
INSERT INTO twi_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Eyi ne nhyira a Israel mmusuakuw dumien no agya de hyiraa wɔn; obiara ne sɛnea ɛfata no. ");
INSERT INTO twi_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yakob rebewu no, ɔka kyerɛɛ wɔn hyɛɛ wɔn se, “Aka kakraa bi, na wɔrebɛfa me akɔka me mpanyimfo ho. Sɛ miwu a, munsie me wɔ ɔboda a ɛwɔ Hetini Efron afuw a wosiee me mpanyimfo wɔ mu no mu. ");
INSERT INTO twi_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ɛno ne ɔboda ne afuw a ɛwɔ Makpela, a ɛbɛn Mamrɛ a ɛwɔ Kanaan asase so no. Abraham tɔɔ saa ɔboda no fii Hetini Efron nkyɛn, de yɛɛ amusiei. ");
INSERT INTO twi_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Saa ɔboda no mu na wosiee Abraham ne ne yere Sara. Ɛhɔ ara nso na wosiee Isak ne ne yere Rebeka, na misiee Lea nso. ");
INSERT INTO twi_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Me nena Abraham tɔɔ afuw no ne ɔboda a ɛka ho no nyinaa fii Hetifo no nkyɛn.” ");
INSERT INTO twi_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Bere a Yakob kasa kyerɛɛ ne mma no wiee no, ɔmaa ne nan so guu ne mpa so wui. Wokosiee no wɔ ne mpanyimfo nkyɛn. ");
INSERT INTO twi_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yosef tow ne ho hwee nʼagya so suu no, na ofew nʼano. ");
INSERT INTO twi_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ɛno akyi no, Yosef maa ne duruyɛfo bɛhyɛɛ nʼagya Israel akyenkyennuru, sɛnea ɛbɛyɛ a, ɔrensɛe. Enti oduruyɛfo no hyɛɛ no akyenkyennuru. ");
INSERT INTO twi_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Wɔde adaduanan na ɛhyɛɛ Israel akyenkyennuru no, efisɛ saa nna dodow no na ɛsɛ sɛ wɔde hyɛ no aduru no. Misraimfo suu no nnafua aduɔson. ");
INSERT INTO twi_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Wosuu no wiee no, Yosef kasa kyerɛɛ Farao fifo se, “Sɛ manya mo anim anuonyam a, monka nkyerɛ Farao mma me se, ");
INSERT INTO twi_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Mʼagya ma mekaa ntam,’ na ɔkae se: Hwɛ, aka kakra na mawu. Enti sɛ miwu a, ɔboda a mʼankasa mitwaa wɔ Kanaan asase so no mu na munkosie me. ‘Enti momma me kwan mma minkosie mʼagya, na mɛsan aba.’ ” ");
INSERT INTO twi_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao penee akwansrɛ no so, kae se, “Kɔ na kosie wʼagya, sɛnea ɔmaa wo kaa no ntam no.” ");
INSERT INTO twi_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Enti Yosef kɔ kosiee nʼagya. Farao asomfo nyinaa ne ne mpanyimfo ne nʼatenankongua ne Misraim nnipa titiriw nyinaa kogyaa Yosef ayi ");
INSERT INTO twi_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","kaa Yosef fifo nyinaa a ne nuabarimanom ne nʼagya fifo no ho. Wɔn mma ne wɔn nguan ne wɔn anantwi nko ara na wogyaw wɔn wɔ Gosen asase so hɔ. ");
INSERT INTO twi_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Nteaseɛnam ne apɔnkɔsotefo nso kaa wɔn ho kɔɔ ayi no bi. Nnipadɔm pa ara na wɔkɔe. ");
INSERT INTO twi_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Woduu Atad a ne nkyerɛase ne baabi a wɔpo atoko, a ɛbɛn Asubɔnten Yordan no, wɔde nnanson twaa agyaadwo, yɛɛ Yosef agya Israel ayi kɛse wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Bere a Kanaanfo a na wɔte asase no so huu sɛnea wosi yɛɛ ayi no wɔ Atad no, wɔkae se, “Eyi yɛ ayi kɛse bi a Misraimfo ayɛ.” Ɛno nti, Kanaanfo a wɔte asase no so no too hɔ din Abel-Misraim, a ne nkyerɛase ne Misraimfo reyɛ ayi kɛse. ");
INSERT INTO twi_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Enti Yakob mmabarima no yɛɛ sɛnea wɔn agya kyerɛɛ wɔn sɛ wɔnyɛ no pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Wɔsoaa no, de no kɔɔ Kanaan asase so, kosiee no wɔ ɔboda a ɛwɔ Makpela a ɛbɛn Mamrɛ afuw a na Abraham atɔ afi Hetini Efron nkyɛn de ayɛ amusiei no mu. ");
INSERT INTO twi_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosef siee nʼagya wiee no, ɔne ne nuanom ne wɔn a wokogyaa no ayi no nyinaa san baa Misraim. ");
INSERT INTO twi_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yosef agya wu akyi no, ne nuanom no de ehu ka kyerɛɛ wɔn ho wɔn ho se, “Sɛ ɛba sɛ Yosef da so wɔ yɛn ho menasepɔw, na otua yɛn bɔne ahorow a yɛayɛ no nyinaa so ka a, na yɛreyɛ no dɛn?” ");
INSERT INTO twi_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Enti wotuu nnipa kɔɔ Yosef hɔ kɔka kyerɛɛ no se, “Wʼagya kaa saa asɛm yi ansa na ɔrewu. ");
INSERT INTO twi_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Asɛm yi na ɛsɛ sɛ moka kyerɛ Yosef: Mesrɛ wo, fa bɔne ahorow a wo nuanom ayɛ wo no nyinaa kyɛ wɔn.’ Enti afei mesrɛ wo, fa Onyankopɔn a wʼagya som no no nkoa bɔne kyɛ wɔn.” Bere a Yosef tee asɛm a ne nuanom no kae no, osui. ");
INSERT INTO twi_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Yosef nuabarimanom no bɛtotow wɔn ho guguu nʼanim, kae se, “Yɛyɛ wo nkoa.” ");
INSERT INTO twi_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Nanso Yosef ka kyerɛɛ wɔn se, “Munnsuro me! Meyɛ Onyankopɔn a metumi abu mo atɛn, atwe mo aso ana? ");
INSERT INTO twi_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ɛwɔ mu sɛ moyɛɛ mo adwene sɛ mobɛyɛ me bɔne de, nanso na Onyankopɔn adwene ne sɛ, ɛbɛdan ade pa, sɛnea ɛbɛyɛ a obetumi agye nnipa dodow nkwa, sɛnea ɔreyɛ no nnɛ yi. ");
INSERT INTO twi_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Enti munnsuro! Mʼankasa mede biribiara a ehia mo ne mo mma nyinaa bɛma mo.” Yosef nam saa kasakyerɛ yi so hyɛɛ wɔn bɔ sɛ, ɔrenyɛ wɔn bɔne biara. ");
INSERT INTO twi_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosef ankasa ne ne nuanom ne nʼagya abusuafo nyinaa tenaa Misraim asase so. Odii mfe ɔha ne du ansa na ɔrewu. ");
INSERT INTO twi_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yosef huu Efraim mma nena ne Manase ba Makir mma nso. Wɔwoo wɔn guu ne srɛ so. ");
INSERT INTO twi_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Na, Yosef ka kyerɛɛ ne nuabarimanom no se, “Ɛrenkyɛ biara na mawu. Nanso Onyankopɔn bɛboa mo, ayi mo afi saa asase yi so, de mo akɔ bɔhyɛ asase a ɔkaa ho ntam sɛ ɔde bɛma Abraham, Isak ne Yakob no so.” ");
INSERT INTO twi_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yosef maa Israel mmabarima no kaa ntam, na Yosef kae se, “Nokware, Onyankopɔn bedi aboa mo. Sɛ miwu nso a, monsoa me nnompe mfi ha nkɔ Kanaan asase so.” ");
INSERT INTO twi_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yosef dii mfe ɔha ne du, na owui. Wɔhyɛɛ no akyenkyennuru de no too funnaka mu wɔ Misraim.");
INSERT INTO twi_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yakob mma ne wɔn abusuafo a wɔne no tu kɔtenaa no din na edidi so yi. ");
INSERT INTO twi_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Lewi ne Yuda; ");
INSERT INTO twi_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakar, Sebulon ne Benyamin; ");
INSERT INTO twi_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali; Gad ne Aser. ");
INSERT INTO twi_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yakob asefo a ɔne wɔn kɔe no nyinaa ano si aduɔson. Na Yosef wɔ Misraim dedaw. ");
INSERT INTO twi_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yosef ne ne nuanom ne wɔn bere sofo no nyinaa wuwui, ");
INSERT INTO twi_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","nanso Israelfo no ase fɛee, na wɔyɛɛ bebree, hyɛɛ asase no so ma. ");
INSERT INTO twi_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Na ɔhene foforo bi bedii ade wɔ Misraim a na onnim Yosef ho asɛm. ");
INSERT INTO twi_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ɔka kyerɛɛ ne manfo no se, “Monhwɛ, Israelfo yi ase adɔ, wɔreyɛ adɔɔso dodo ama yɛn. ");
INSERT INTO twi_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Momma yɛmpɛ ɔkwan bi na yɛmfa so nsiw saa dɔ a wɔredɔ no ano. Sɛ yɛanyɛ saa na ɔko bi si a, wɔbɛdɔm yɛn atamfo ne wɔn ako atia yɛn na wɔafi ɔman yi mu.” ");
INSERT INTO twi_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Enti wɔde nkoa sohwɛfo gyinagyinaa wɔn kɔn so ma wɔyɛɛ adwumaden de kyekyeree adekora nkuropɔn Pitom ne Rameses maa Farao. ");
INSERT INTO twi_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Nanso mpɛn dodow a Misraimfo no hyɛɛ wɔn so no, na dɔ ara na Israelfo no redɔɔso. Eyi maa Misraimfo no suroo Israelfo ");
INSERT INTO twi_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","na wɔkɔɔ so hyɛɛ Israelfo no so ketee. ");
INSERT INTO twi_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wɔde adwumadenyɛ dii Israelfo no nya. Wɔma wɔyɛɛ ntayaa ne dɔte ho adwuma a ɛyɛ den ne mfum nnwuma ahorow. Eyinom nyinaa akyi no Misraimfo faa akwan bebree so daa atirimɔden adi kyerɛɛ Israelfo no. ");
INSERT INTO twi_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Misraimhene ka kyerɛɛ Hebrifo awogyefo a wɔn din ne Sifra ne Pua se, ");
INSERT INTO twi_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Sɛ mukogye Hebrini biara awo, na awoe hɔ muhu sɛ ɔyɛ ɔbabarima a, munkum no, na sɛ ɔyɛ ɔbabea de a, monnyɛ no hwee.” ");
INSERT INTO twi_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Esiane sɛ na awogyefo no yɛ nyamesurofo no nti, wɔanni mmara a ɔhene no hyɛɛ wɔn no so, maa mmarimaa a wɔwowoo wɔn no tenae. ");
INSERT INTO twi_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ɔhene no frɛɛ wɔn bisaa wɔn se, “Adɛn nti na moanni mmara a mehyɛe no so na moama mmarimaa a Hebrifo no wowoo wɔn no atena?” ");
INSERT INTO twi_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Wobuaa no se, “Hebrifo mmea no de ahoɔden wo ɔhare so nti yebedu hɔ no, na wɔawo dedaw. Wɔnte sɛ Misraimfo mmea no.” ");
INSERT INTO twi_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Onyankopɔn hyiraa awogyefo no. Na Israelfo no dɔɔso ara bɛyɛɛ ɔman kɛse. ");
INSERT INTO twi_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Esiane sɛ na awogyefo no yɛ nyamesurofo nti, Onyankopɔn dom wɔn mma. ");
INSERT INTO twi_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Na Farao hyɛɛ mmara sɛ Hebrifo mmarimaa a wɔbɛwo wɔn foforo no, wɔntow wɔn ngu Asubɔnten Nil mu na mmeawa a wɔbɛwo wɔn foforo no de, wɔntena hɔ. ");
INSERT INTO twi_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Na Lewini bi waree ɔbea bi fii Lewi abusuakuw mu. ");
INSERT INTO twi_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ɔbea no nyinsɛn woo abarimaa. Abofra no na huu sɛ ne ho yɛ fɛ yiye nti ɔde no siee fie asram abiɛsa. ");
INSERT INTO twi_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Eduu bere bi no, na ɔde no sie a ɛnyɛ yiye nti, ɔde mfea nwenee kɛntɛn bi de ɛhyɛ ne ama faa ho sɛnea ɛbɛyɛ a, nsu rentumi nkɔ mu. Ɔde abofra no too mu de no kosii asu Nil konkɔn so wɔ wura a na ɛwɔ hɔ no bi mu. ");
INSERT INTO twi_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Abofra no nuabea kogyinaa akyiri baabi a na ɔwɛn no. ");
INSERT INTO twi_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Farao babea kɔɔ asu no mu sɛ ɔrekoguare. Bere a ɔne ne mmaawa nam asu no konkɔn so no, ohuu kɛntɛn no sɛ ɛhyɛ wuram hɔ baabi, enti ɔsomaa ne mmaawa no mu baako sɛ ɔnkɔfa mmrɛ no. ");
INSERT INTO twi_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ɔde bae a obuee so no, ohuu sɛ abarimaa bi da mu a ɔresu. Asɛm no yɛɛ no awerɛhow. Ɔkae se, “Ɔyɛ Hebrifo yi bi ba.” ");
INSERT INTO twi_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Abofra no nuabea a na ɔrewɛn no no kɔɔ ɔhene babea no nkyɛn kobisaa no se, “Menkɔfrɛ Hebrifo mmea no baako na ɔmmɛhwɛ no mma wo ana?” ");
INSERT INTO twi_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ɔhene babea no buae se, “Yiw.” Enti, abeawa no tuu mmirika kɔɔ fie kɔfrɛɛ abofra no na de no bae. ");
INSERT INTO twi_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ɔhene babea no ka kyerɛɛ no se, “Fa abofra no kɔ fie na kɔhwɛ no ma me na metua wo ho ka.” Enti ɔde no kɔɔ fie kɔhwɛɛ no. ");
INSERT INTO twi_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Onyin kakra no, ɔde no brɛɛ ɔhene babea no ma ogyee no de no yɛɛ ne ba. Ɔkae se, “Mɛto ne din Mose efisɛ miyii no fii nsu mu.” ");
INSERT INTO twi_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mose nyin no, da bi, ɔkɔsraa ne manfo Hebrifo no. Oduu hɔ no, ohuu sɛ ne manfo no reyɛ adwumaden. Nsrahwɛ no mu na Mose huu sɛ Misraimni bi reboro Hebrini a ɔyɛ ne nua. ");
INSERT INTO twi_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mose hwɛɛ ha hwɛɛ ha huu sɛ obiara nni hɔ no, okum Misraimni no tutuu nwea mu de no hyɛɛ hɔ. ");
INSERT INTO twi_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ade kyee no, ɔsan kɔɔ Hebrifo no nsrahwɛ. Oduu hɔ no, na wɔn mu baanu reko. Obisaa nea nʼasɛm nyɛ dɛ no se, “Dɛn na woreyɛ yi a worebobɔ wo nua Hebrini saa?” ");
INSERT INTO twi_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ɔbarima no nso bisaa no se, “Wufi he? Hena na ɔde wo yɛɛ yɛn sodifo ne temmufo? Anaasɛ woayɛ wʼadwene sɛ wobekum me sɛnea nnɛra wukum Misraimni no?” Mose huu sɛ bɔne a wayɛ no ho ada hɔ no, osuroe. ");
INSERT INTO twi_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Na Farao nso tee asɛm no, ɔhyɛɛ sɛ wɔnkɔfa Mose mmra na wonkum no. Nanso Mose guan kɔɔ Midian asase so. Da bi a Mose kɔtenaa abura bi ho wɔ hɔ no, ");
INSERT INTO twi_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midian sɔfo mmabea baason bi baa hɔ sɛ wɔrebɛtow nsu de akɔma wɔn papa nguan. ");
INSERT INTO twi_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Nanso nguanhwɛfo bi pampam mmeawa no. Mose begyee wɔn fii nguanhwɛfo no nsam maa mmeawa no nguan no nsu nomee. ");
INSERT INTO twi_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Wɔsan koduu wɔn agya Reuel nkyɛn no, obisaa wɔn se, “Ɛyɛɛ dɛn na nnɛ de, munyaa nsu maa nguan yi nom ntɛm sɛɛ?” ");
INSERT INTO twi_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Wɔka kyerɛɛ wɔn agya se, “Misraimni bi na ogyee yɛn fii nguanhwɛfo no nsam. Ɔno ara na ɔtow nsu no maa yɛn nguan no nomee.” ");
INSERT INTO twi_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Wɔn agya bisae se, “Na ɔwɔ he? Mugyaw no wɔ hɔ ana? Monkɔfrɛ no na ommedidi.” ");
INSERT INTO twi_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mose kɔɔ Reuel frɛ no. Akyiri no, ɔne wɔn kɔtenae, maa Reuel de ne babea Sipora maa no aware. ");
INSERT INTO twi_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Wɔwoo ɔbabarima maa Mose too no din Gersom, ase ne Ɔhɔho, efisɛ Mose kyerɛ ase se, “Meyɛ ɔhɔho wɔ ananafo asase so.” ");
INSERT INTO twi_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Mfe bi akyi no, Misraimhene no wui. Na Israelfo no resi apini wɔ wɔn nkoasom no mu. Enti na wɔresu frɛ Onyankopɔn. ");
INSERT INTO twi_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Onyankopɔn nso tiee wɔn sufrɛ no, kaee bɔ a ɔhyɛɛ Abraham, Isak ne Yakob sɛ ɔde nʼasefo bɛsan aba Kanaan asase so no. ");
INSERT INTO twi_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Onyankopɔn hwɛ huu sɛ bere adu sɛ ogye wɔn. ");
INSERT INTO twi_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Na Mose rehwɛ nʼase Yetro a ɔyɛ Midian sɔfo nguan. Ɔde nguan no wuraa sare no mu kɔɔ akyirikyiri koduu Horeb a ɛyɛ Onyankopɔn bepɔw no so. ");
INSERT INTO twi_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Prɛko pɛ, na Awurade bɔfo nam wura bi gyaframa mu yii ne ho adi kyerɛɛ Mose. Mose huu sɛ wura no redɛw nanso na ɛnhyew. ");
INSERT INTO twi_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Enti Mose kae se, “Mɛkɔ akɔhwɛ anwonwade yi ahu nea nti a wura no nhyew.” ");
INSERT INTO twi_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Bere a Awurade huu sɛ ɔrekɔhwɛ no, ɔfrɛɛ no fii wura no mu se, “Mose! Mose!” Mose gyee so se, “Me ni.” ");
INSERT INTO twi_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Onyankopɔn ka kyerɛɛ no se, “Mmɛn me. Yi wo mpaboa na faako a wugyina no yɛ asase kronkron.” ");
INSERT INTO twi_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ɔtoaa so se, “Mene wʼagyanom Nyankopɔn, Abraham Nyankopɔn, Isak Nyankopɔn ne Yakob Nyankopɔn no.” Mose kataa nʼanim, efisɛ na osuro sɛ ɔbɛhwɛ Onyankopɔn anim. ");
INSERT INTO twi_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Awurade ka kyerɛɛ no se, “Mahu amanehunu a me manfo a wɔwɔ Misraim no wɔ mu no, na mate wɔn nkotosrɛ a ɛfa wɔn nnwuma wuranom ho, na minim wɔn ahohia. ");
INSERT INTO twi_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Maba sɛ merebegye wɔn afi Misraimfo nsam na mayi wɔn afi Misraim asase so de wɔn akɔ asase pa a ɛso bae so, asase a ɛwo ne nufusu wɔ so; asase a Kanaanfo, Hetifo, Amorifo, Perisifo, Hewifo ne Yebusifo te so no so. ");
INSERT INTO twi_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Mate Israelfo no su na mahu nya a Misraimfo di wɔn no. ");
INSERT INTO twi_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Enti afei, merebɛsoma wo akɔ Farao nkyɛn, na woakoyi me man Israel afi Misraim.” ");
INSERT INTO twi_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mose kae se, “Mene hena a ɛsɛ sɛ mekɔ Farao anim akoyi Israelfo afi Misraim asase so?” ");
INSERT INTO twi_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Onyankopɔn buaa no se, “Mɛka wo ho. Adansede a ɛkyerɛ sɛ me na masoma wo no ni. Sɛ wuyi nnipa no fi Misraim a, mobɛsom Onyankopɔn wɔ saa bepɔw yi so.” ");
INSERT INTO twi_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mose bisae se, “Sɛ mekɔ Israelfo no nkyɛn kɔka se wɔn agyanom Nyankopɔn na wasoma me na wobisa me se, ‘Onyankopɔn bɛn na mereka ne ho asɛm no’ a, mmuae bɛn na memfa mma wɔn?” ");
INSERT INTO twi_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Obuaa Mose se, ka se, “Mene nea ɔwɔ hɔ daa no. Ka kyerɛ wɔn se, ‘Mene Nea Mene na wasoma me mo nkyɛn.’ ” ");
INSERT INTO twi_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Onyankopɔn toaa so se, “Ka kyerɛ Israelfo no se, ‘Awurade a ɔyɛ mo agyanom Abraham, Isak ne Yakob Nyankopɔn na wasoma me mo nkyɛn.’ ” Eyi ne me din a wɔde bɛkae me daa fi awo ntoatoaso so kosi awo ntoatoaso so. ");
INSERT INTO twi_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Kɔ, frɛ Israelfo mpanyimfo na ka kyerɛ wɔn se, ‘Awurade, Abraham, Isak ne Yakob Nyankopɔn no daa ne ho adi kyerɛɛ me, kae se: Mawɛn mo na mahu nea wɔde ayɛ mo wɔ Misraim. ");
INSERT INTO twi_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Mehyɛ bɔ sɛ meyi mo afi mo awerɛhow mu wɔ Misraim de mo akɔ asase a Kanaanfo, Hetifo, Amorifo, Perisifo, Hewifo ne Yebusifo te so nnɛ yi a ɛwo ne nufusu wɔ so no so.’ ");
INSERT INTO twi_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Israelfo mpanyimfo betie wʼasɛm no. Na ɛsɛ sɛ wo ne mpanyimfo no kɔ Misraimhene hɔ kɔka kyerɛ no se, ‘Awurade, Hebrifo Nyankopɔn, ne yɛn ahyia na waka akyerɛ yɛn se, yentu nnansa kwan nkɔ sare so nkɔbɔ afɔre mma no.’ ");
INSERT INTO twi_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Nanso minim sɛ Misraimhene remma mo kwan da, gye sɛ nsa bi a ɛyɛ duru hyɛ no ketee. ");
INSERT INTO twi_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Enti mɛteɛ me nsa na mede anwonwade ahorow a mɛyɛ wɔ wɔn mu no nyinaa atia wɔn. Ɛno akyi no, ɔbɛma mo akɔ. ");
INSERT INTO twi_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Mɛma mo anim aba nyam wɔ Misraimfo no anim na wɔahyehyɛ akyɛde ama mo, na moankɔ no nsapan. ");
INSERT INTO twi_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ɔbea biara mmisa dwetɛ ne sikakɔkɔɔ adwinne ne ntama pa mfi nʼafipamfo ne ne fifo mmea nkyɛn na wɔmfa nsiesie wɔn mmabarima ne wɔn mmabea ho. Saayɛ so na mobɛfa afow Misraimfo no.” ");
INSERT INTO twi_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Na Mose buaa no se, “Sɛ wɔannye me anni anaa wɔantie asɛm a mɛka no, na wɔka se, ‘Awurade nyii ne ho adi nkyerɛɛ wo ɛ?’ ” ");
INSERT INTO twi_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Awurade bisaa no se, “Dɛn na wukura yi?” Obuae se, “Oguanhwɛfo pema.” ");
INSERT INTO twi_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Awurade ka kyerɛɛ no se, “Tow kyene fam.” Enti ɔtow kyenee fam ma ɛdan ɔwɔ. Mose guan fii aboa no ho. ");
INSERT INTO twi_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Na Awurade ka kyerɛɛ Mose se, “So ɔwɔ no dua mu na kyere no!” Osoo ne dua mu kyeree no no, ɛsan dan pema no. ");
INSERT INTO twi_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Awurade ka kyerɛɛ no se, “Kɔyɛ saa na wobegye wo adi. Ɛbɛma wɔahu sɛ wɔn agyanom Abraham, Isak ne Yakob Nyankopɔn ada ne ho adi akyerɛ wo ampa.” ");
INSERT INTO twi_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Afei, Awurade kae se, “Fa wo nsa hyɛ wʼatade mu.” Mose de ne nsa hyɛɛ nʼatade mu, na oyii no, na kwata ayɛ ne nsa ho; ayɛ fitaa sɛ sukyerɛmma. ");
INSERT INTO twi_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Awurade ka kyerɛɛ no bio se, “Fa wo nsa hyɛ wʼatade mu bio.” Enti Mose san de ne nsa hyɛɛ nʼatade mu, na oyii no, na kwata no agyae ama ne nsa no ho ayɛ sɛnea ɛte kan no. ");
INSERT INTO twi_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Awurade ka kyerɛɛ no se, “Sɛ wɔannye anwonwade a edi kan no anni a, wobegye nea ɛto so abien no adi. ");
INSERT INTO twi_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Na sɛ nsɛnkyerɛnne abien yi akyi no wɔannye wo anni a, kɔsaw nsu fi Asubɔnten Nil mu na behwie gu asase wosee bi so na ɛbɛdan mogya.” ");
INSERT INTO twi_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Nanso Mose srɛe se, “Awurade, minnim kasa. Ebesi nnɛ anaa efi bere a wo ne me kasae mpo no, mʼano ntew.” ");
INSERT INTO twi_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Awurade bisaa no se, “Hena na ɔyɛɛ onipa ano? Ɛnyɛ me Awurade na meyɛe? Hena na ɔbɔ onipa ma otumi kasa anaa ɔmma no nkasa. Hena na ɔma no hu ade anaa ɔmma no nhu ade. Hena na ɔma no tumi te asɛm anaa ɔmma no nte asɛm? ");
INSERT INTO twi_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Afei kɔ, na kɔyɛ nea maka akyerɛ wo no na mɛboa wo ama woatumi akasa yiye, na mɛkyerɛ wo nea wobɛka nso.” ");
INSERT INTO twi_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Nanso Mose kae se, “Awurade wʼakoa resrɛ wo, soma onipa foforo.” ");
INSERT INTO twi_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Awurade bo fuwii, enti ɔkaa se, “Na wo nua Aaron, Lewini no nso ɛ, minim sɛ nʼano atew. Na hwɛ ɔno na ɔrebehyia wo no, na sɛ ohu wo a, nʼani begye. ");
INSERT INTO twi_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Wobɛkasa akyerɛ no na woaka nsɛm ahyɛ nʼanom; mɛboa mo baanu no ama moakasa, na makyerɛ mo nea mobɛyɛ. ");
INSERT INTO twi_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ɔbɛyɛ wo kyeame wɔ ɔman no anim, na wo nso woayɛ sɛ ne Nyankopɔn aka asɛm a wopɛ sɛ ɛda gua akyerɛ no. ");
INSERT INTO twi_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Sɛ worekɔ a, fa wo pema no sɛnea ɛbɛyɛ a, wubetumi de ayɛ anwonwade a makyerɛ wo no.” ");
INSERT INTO twi_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mose kɔɔ fie kɔka kyerɛɛ nʼase Yetro se, “Mɛsrɛ wo kwan na makɔ Misraim akɔsra mʼabusuafo akɔhwɛ sɛ wɔtete ase ana.” Yetro penee so se, “Kɔ. Mihyira wo kosɛkosɛ.” ");
INSERT INTO twi_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ansa na Mose rebefi Midian no, Awurade ka kyerɛɛ no se, “Nsuro sɛ wobɛsan akɔ Misraim, efisɛ wɔn a na wɔrehwehwɛ wo akum wo no nyinaa awuwu.” ");
INSERT INTO twi_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Enti Mose faa ne yere ne ne mma de wɔn tenatenaa mfurum so sii mu sɛ ɔrekɔ Misraim. Na ɔfaa Onyankopɔn pema no kitae. ");
INSERT INTO twi_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Awurade ka kyerɛɛ Mose se, “Sɛ wudu Misraim a, kɔ Farao hɔ na kɔyɛ anwonwade a makyerɛ wo yi kyerɛ no, nanso mepirim ne koma sɛnea ɔremma nnipa no nkɔ. ");
INSERT INTO twi_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Na ka kyerɛ no se, ‘Awurade se, Israel yɛ mʼabakan ");
INSERT INTO twi_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","na mehyɛɛ wo sɛ, “Ma no kwan na ɔnkɔ na ɔnkɔsom me.” Nanso woampene; nti mekum wʼabakan.’ ” ");
INSERT INTO twi_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mose ne nʼabusuafo nam no, ade saa wɔn ma wɔpɛɛ baabi dae. Awurade daa ne ho adi kyerɛɛ Mose na ohunahunaa no sɛ obekum no. ");
INSERT INTO twi_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Enti ne yere Sipora faa sekan de twaa ne babarima kumaa twetia tow kyenee Mose nan ase kae se, “Mogya ayeforokunu ne wo.” ");
INSERT INTO twi_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Enti Awurade gyaa Mose. (Na Sipora kae se, “Woyɛ mogya ayeforokunu,” a na ɔde rekyerɛ twetiatwa.) ");
INSERT INTO twi_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Awurade ka kyerɛɛ Aaron se, “Kɔ sare no so kohyia Mose.” Enti Aaron kɔɔ Onyankopɔn Bepɔw no so kohyiaa Mose few nʼafono. ");
INSERT INTO twi_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Na Mose kaa nsɛm a Awurade ka kyerɛɛ no bere a ɔresoma no no ne anwonwade a ɔhyɛɛ no sɛ ɔnyɛ no nyinaa kyerɛɛ Aaron. ");
INSERT INTO twi_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mose ne Aaron hyiaa Israelfo mpanyimfo no nyinaa, ");
INSERT INTO twi_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","na Aaron kaa nsɛm a Awurade aka akyerɛ Mose no nyinaa kyerɛɛ wɔn, na Mose yɛɛ anwonwade no kyerɛɛ wɔn ");
INSERT INTO twi_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ma wogye dii. Na wɔtee sɛ Awurade dwen wɔn ho na wahu wɔn awerɛhowdi no, wobuu nkotodwe sɔree no. ");
INSERT INTO twi_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Mose ne Aaron yɛɛ anwonwade yi kyerɛɛ mpanyimfo no wiee no, wokohuu Farao ka kyerɛɛ no se, “Nea Israel Nyankopɔn se ni, ‘Ma me nkurɔfo mfi ha nkɔ sare so nkɔbɔ afahyɛgua kronkron wɔ hɔ mfa nsɔre me.’ ” ");
INSERT INTO twi_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Farao bisae se, “Hena ne Awurade a ɛsɛ sɛ mitie no na mema Israelfo no kɔ? Minnim Awurade biara enti meremma Israelfo no nkɔ.” ");
INSERT INTO twi_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Na Aaron ne Mose tii mu se, “Hebri Nyankopɔn ne yɛn ahyia. Ɛsɛ sɛ yetu nnansa kwan kɔ sare so kɔbɔ afɔre wɔ hɔ de ma Awurade, yɛn Nyankopɔn. Na sɛ yɛantie no a, ɔyaredɔm anaa afoa ano na yebewuwu.” ");
INSERT INTO twi_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Farao bisae se, “Mose ne Aaron, adɛn nti na morema nkurɔfo no agyae wɔn nnwuma? Monkɔ mo nnwuma so ntɛm!” ");
INSERT INTO twi_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Farao toaa so se, “Mprempren, saa nnipa no dɔɔso sen ɔmanfo no, nanso mopɛ sɛ moma ahɔho no gyae adwumayɛ.” ");
INSERT INTO twi_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Da no ara, Farao somaa nnipa ma wɔkɔka kyerɛɛ wɔn a wɔhwɛ Israelfo no so no se, ");
INSERT INTO twi_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Mommma nnipa no sare a wɔde bɛyɛ ntayaa no bio! Momma wɔn ankasa nkotwa sare no. ");
INSERT INTO twi_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Na ntayaa dodow a wotwa no nso, monntew so baako koraa, efisɛ asɛm a wɔaka no da no adi pefee sɛ wɔyɛ akwadwofo nti na wɔreka se wɔrekɔ sare so akɔbɔ wɔn Awurade afɔre no. ");
INSERT INTO twi_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Momma wɔn adwuma no mu nyɛ den, na ɛmmee wɔn na wɔankotie atosɛm biara.” ");
INSERT INTO twi_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Enti adwumasohwɛfo ne wɔn akwankyerɛfo no ka kyerɛɛ Hebrifo no se, “Farao aka akyerɛ yɛn se yɛmmma mo sare bio. ");
INSERT INTO twi_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mo ara munkokyin nhwehwɛ bi, nanso ntayaa a mutwa no, muntwa dodow saa ara.” ");
INSERT INTO twi_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Enti Hebrifo no kyinkyinii Misraim asase so nyinaa sɛ wɔrekɔhwehwɛ sare no bi. ");
INSERT INTO twi_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Adwumasohwɛfo no hyɛɛ wɔn atirimɔden so se, “Muntwa ntayaa dodow sɛnea na mutwa no.” ");
INSERT INTO twi_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Na Misraimfo adwumasohwɛfo no kaa Hebrifo mpanyimfo a wɔde wɔn atuatua adwuma no ano sɛ akwankyerɛfo no mmaa, bisaa wɔn se, “Adɛn nti na moanwie ntayaa a wɔahyɛ sɛ muntwa no nnɛra ne nnɛ no nyinaa sɛnea na moyɛ kan no?” ");
INSERT INTO twi_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Mpanyimfo yi kɔɔ Farao nkyɛn kɔsrɛɛ no se, “Adɛn na woyɛ wo nkoa saa? ");
INSERT INTO twi_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Wɔmma wo nkoa sare biara, nanso wɔka kyerɛ yɛn se, ‘Montwa ntayaa!’ Wɔka yɛn mmaa nanso mfomso no fi wʼankasa wo nkurɔfo no.” ");
INSERT INTO twi_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Nanso Farao buae se, “Munni dwuma bi di, na sɛ mowɔ dwuma bi di a, anka morenka se, ‘Momma yɛnkɔbɔ afɔre mma Awurade.’ ");
INSERT INTO twi_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Monsan nkɔyɛ adwuma ntɛm. Obiara remma mo sare, nanso ntayaa dodow a mutwa no daa no, saa ara na mubetwa.” ");
INSERT INTO twi_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Bere a wɔka kyerɛɛ Israelfo mpanyimfo a wodi adwuma no anim sɛ akwankyerɛfo no se ɛsɛ sɛ wotwa ntayaa no dodow sɛnea wɔyɛ daa no, wohuu sɛ ahokyere aba. ");
INSERT INTO twi_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Bere a wofi Farao anim bae a wohuu sɛ Mose ne Aaron retwɛn wɔn wɔ ahemfi no ho no, ");
INSERT INTO twi_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","wɔka kyerɛɛ wɔn se, “Awurade mmu mo atɛn sɛ moama Farao ne ne nkurɔfo anya yɛn ho menasepɔw, na mode afoa ahyɛ wɔn nsa sɛ wonkunkum yɛn.” ");
INSERT INTO twi_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Asɛm yi maa Mose kɔɔ Awurade nkyɛn kɔka kyerɛɛ no se, “Awurade, adɛn nti na woma wo manfo brɛ saa? So eyi nti na wosomaa me? ");
INSERT INTO twi_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Efi bere a mekɔkaa wo nkra no kyerɛɛ Farao no, tan ara na ɔretan wɔn ani, nanso wunnyee wɔn wɔ ɔkwan biara so ɛ.” ");
INSERT INTO twi_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Awurade ka kyerɛɛ Mose se, “Wubehu nea mede bɛyɛ Farao. Menam me tumi so bɛhyɛ no na wama me nkurɔfo no akɔ; me basa kokuroo no bɛma wapam wɔn afi ɔman no mu.” ");
INSERT INTO twi_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Na Onyankopɔn ka kyerɛɛ Mose se, “Mene Awurade no. ");
INSERT INTO twi_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Miyii me ho adi kyerɛɛ Abraham, Isak ne Yakob sɛ Onyankopɔn tumfo. Nanso mammɔ me din sɛ Awurade no ankyerɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Na me ne wɔn hyehyɛɛ apam sɛ mede Kanaan asase a na tete no wɔte so sɛ ahɔho no bɛma wɔn ne wɔn asefo. ");
INSERT INTO twi_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Bio, mate Israelfo apinisi ne nya a Misraimfo di wɔn no nyinaa na makae me ne wɔn apam no. ");
INSERT INTO twi_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Enti ka kyerɛ Israelfo no se, ‘Me, Awurade, menam me tumi so bɛyɛ anwonwade de ayi wɔn afi nkoasom mu ama wɔade wɔn ho. ");
INSERT INTO twi_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Megye wɔn ato mu sɛ me nkurɔfo na mayɛ wɔn Nyankopɔn. Na wobehu sɛ mene Awurade, wɔn Nyankopɔn a wagye wɔn afi Misraimfo nsam no. ");
INSERT INTO twi_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mede wɔn bɛba asase a mehyɛɛ bɔ sɛ mede bɛma Abraham, Isak ne Yakob no so. Saa asase no bɛyɛ mo agyapade. Mene Awurade no.’ ” ");
INSERT INTO twi_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Enti Mose kaa asɛm a Onyankopɔn ka kyerɛɛ no no kyerɛɛ nnipa no, nanso wɔantie, esiane abawpa a efi ɔhyɛ ntraso nti. ");
INSERT INTO twi_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Afei, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“San kɔ Farao nkyɛn kɔka kyerɛ no sɛ ɔmma Israelfo no mfi ne man no mu nkɔ.” ");
INSERT INTO twi_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Nanso Mose kae se, “Sɛ Israelfo no rentie me a, ɛbɛyɛ dɛn na Farao betie me, bere a mʼano ntewee yi?” ");
INSERT INTO twi_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Afei, Awurade hyɛɛ Mose ne Aaron sɛ wɔnsan nkɔ Israelfo no ne Farao a ɔyɛ Misraimfo hene no nkyɛn nkɔka nkyerɛ no se ɔmma Israelfo no kwan na womfi Misraim asase so nkɔ. ");
INSERT INTO twi_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Nnipa a na wotuatua Israel mmusuakuw no ano no din na edidi so yi: Ruben a ɔyɛ Israel abakan mmabarima yɛ: Hanok, Palu, Hesron, Karmi. Eyinom na wɔwoo Ruben asefo. ");
INSERT INTO twi_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeon mmabarima: Yemuel, Yamin, Ohad, Yakin, Sohar ne Saulo a na ne na yɛ Kanaanni. Eyinom na wɔwoo Simeon asefo. ");
INSERT INTO twi_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lewi mmabarima: Gerson, Kohat, Merari Lewi dii mfe ɔha aduasa ason. ");
INSERT INTO twi_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gerson mmabarima: Libni, Simei a wɔyɛ mmusua ti. ");
INSERT INTO twi_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohat mmabarima: Amram, Ishar, Hebron, Usiel. Kohat dii mfe ɔha aduasa abiɛsa. ");
INSERT INTO twi_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari mmabarima: Mahli, Musi. Saa nnipa a wɔabobɔ wɔn din mpanyin mu no no yɛ Lewi abusuafo. ");
INSERT INTO twi_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram waree nʼagya nuabea Yokebed na wɔwoo Mose ne Aaron. Amram dii mfe ɔha aduasa ason. ");
INSERT INTO twi_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ishar mmabarima: Kora, Nefeg, Sikri. ");
INSERT INTO twi_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usiel mmabarima: Misael, Elsafan, Sitri. ");
INSERT INTO twi_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron waree Aminadab babea Elisaba a ɔyɛ Nahson nuabea. Wɔn mma din ni: Nadab, Abihu, Eleasar ne Itamar. ");
INSERT INTO twi_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora mmabarima: Asir, Elkana, Abiasaf Eyinom ne Kora asefo. ");
INSERT INTO twi_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaron babarima Eleasar waree Putiel mmabea no baako. Na Pinehas yɛ wɔn mma no mu baako. Nnipa a wɔabobɔ wɔn din yi ne wɔn a na wotuatua Lewifo mmusuakuw no ano. ");
INSERT INTO twi_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Saa Aaron ne Mose yi ara na Awurade ka kyerɛɛ wɔn se, “Munkoyi Israelfo nyinaa mfi Misraim asase so” no. ");
INSERT INTO twi_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Na wɔn na wɔkɔɔ Farao hɔ kɔkaa se ɔmma Israelfo no mfi Misraim no. ");
INSERT INTO twi_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Da a Awurade kasa kyerɛɛ Mose wɔ Misraim asase so no, ");
INSERT INTO twi_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ɔkae se, “Mene Awurade no. Ka asɛm biara a mereka yi kyerɛ Farao a ɔyɛ Misraim hempɔn no.” ");
INSERT INTO twi_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Na Mose ka kyerɛɛ Awurade bio se, “Mʼano ntewee yi, ɛbɛyɛ dɛn na asɛm a mɛka no bɛtɔ Farao asom ama watie me?” ");
INSERT INTO twi_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Na Awurade ka kyerɛɛ Mose se, “Mayɛ wo sɛ Onyankopɔn ama Farao na wo nua Aaron nso bɛyɛ wo diyifo. ");
INSERT INTO twi_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Asɛm biara a mɛka akyerɛ wo no, ka kyerɛ Aaron, na ɔno nso nka nkyerɛ Farao sɛ ɔmma Israelfo no kwan na womfi Misraim. ");
INSERT INTO twi_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Na mepirim Farao koma, na mayɛ anwonwade ahorow bebree wɔ Misraim ");
INSERT INTO twi_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","nanso ɔrentie mo. Na mɛfa atemmu a mu yɛ den so de me nsa ato Misraim so na mayi me nkurɔfo Israelfo no. ");
INSERT INTO twi_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Na sɛ mekyerɛ me tumi kyerɛ Misraimfo no a, wobehu sɛ mene Awurade no, na mayi me nkurɔfo no afi mu.” ");
INSERT INTO twi_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mose ne Aaron yɛɛ sɛnea Awurade hyɛɛ wɔn no. ");
INSERT INTO twi_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Bere a Mose ne Aaron kohyiaa Farao no, na Mose adi mfe aduɔwɔtwe, na Aaron nso adi mfe aduɔwɔtwe abiɛsa. ");
INSERT INTO twi_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Awurade ka kyerɛɛ Mose ne Aaron se, ");
INSERT INTO twi_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Farao bɛhwehwɛ sɛ mobɛyɛ anwonwade akyerɛ no ama wahu sɛ, nokware, Onyankopɔn na wasoma mo. Sɛ obisa saa a, Aaron ntow ne pema no nkyene fam na ɛbɛdan ɔwɔ.” ");
INSERT INTO twi_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Enti Mose ne Aaron kɔɔ Farao nkyɛn kɔyɛɛ anwonwade no sɛnea Awurade akyerɛ wɔn no. Aaron tow ne pema no kyenee fam wɔ Farao ne ne nkurɔfo anim ma ɛdan ɔwɔ. ");
INSERT INTO twi_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Farao nso frɛɛ nʼanyansafo ne ne nkonyaayifo a wɔwɔ Misraim ma wɔn nso bɛyɛɛ anwonwade koro no ara bi. ");
INSERT INTO twi_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Wɔn nso pema tumi dan ɔwɔ. Nanso Aaron ɔwɔ no menee wɔn de no. ");
INSERT INTO twi_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Farao kɔɔ so yɛɛ komaden a na ɔmpɛ sɛ otie asɛm a Awurade kae no. ");
INSERT INTO twi_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Awurade ka kyerɛɛ Mose se, “Farao apirim ne koma nti, ɔbɛkɔ so asiw nnipa no kwan sɛ ɔremma wɔnkɔ. ");
INSERT INTO twi_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Nanso Awurade kae se: San kɔ Farao nkyɛn anɔpa a ɔrekɔ asubɔnten no mu. Kogyina asu no konkɔn so na hyia no wɔ hɔ a wukura wo pema a ɛdan ɔwɔ no. ");
INSERT INTO twi_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ka kyerɛ no se, ‘Awurade, Hebrifo Nyankopɔn asan asoma me wo nkyɛn sɛ ma nnipa no kwan na wɔnkɔ nkɔsom me wɔ sare so. Woayɛ asoɔden. ");
INSERT INTO twi_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Afei, Awurade se: Wubehu sɛ mene Awurade no. Efisɛ maka akyerɛ Mose sɛ ɔmfa ne pema no mmɔ Nil asu no mu na nsu no bɛdan mogya. ");
INSERT INTO twi_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Mpataa a wɔwɔ asubɔnten no mu nyinaa bewuwu ama nsu no abɔn a Misraimfo no rentumi nnom.’ ” ");
INSERT INTO twi_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Awurade ka kyerɛɛ Mose se, “Ka kyerɛ Aaron na ɔmfa ne pema no nkyerɛ nsu a ɛwɔ Misraim no nyinaa; wɔn nsubɔnten, wɔn nsuwa, wɔn atare ne wɔn nsu a ɛtaataa hɔ ne nsu a ɛwɔ afi mu nyinaa so na ɛbɛdan mogya.” ");
INSERT INTO twi_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mose ne Aaron yɛɛ sɛnea Awurade ahyɛ wɔn no. Bere a Farao ne ne mpanyimfo gyinagyina hɔ rehwɛ wɔn no, Aaron de pema no bɔɔ Nil ani maa asubɔnten no dan mogya. ");
INSERT INTO twi_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Mpataa a wɔwɔ mu nyinaa wuwu maa nsu no bɔnee, enti na Misraimfo no ntumi nnom. Misraim asase so nyinaa dan mogya. ");
INSERT INTO twi_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Nkonyaayifo a wɔwɔ Misraim nso nam wɔn nkonyaayi so maa nsu dan mogya, nti Farao kɔɔ so pirim ne koma a na ontie asɛm a Awurade aka akyerɛ Mose ne Aaron sɛ wɔnka nkyerɛ no no. ");
INSERT INTO twi_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ɔsan kɔɔ nʼahemfi a hwee ampusuw no. ");
INSERT INTO twi_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Misraimfo no tutuu mmura wɔ asubɔnten no konkɔn so sɛnea wobenya nsu anom, efisɛ na wontumi nnom asubɔnten no mu nsu. ");
INSERT INTO twi_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Asubɔnten a ɛdan mogya no dii nnaawɔtwe. ");
INSERT INTO twi_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Na Awurade ka kyerɛɛ Mose se, “Kɔ Farao hɔ bio na kɔka kyerɛ no se, ‘Awurade se, Ma me nkurɔfo no kwan na wɔnkɔsom me. ");
INSERT INTO twi_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Sɛ woampene so amma wɔankɔ a, mɛma mpɔtorɔ abɛhyɛ asase no so ma. ");
INSERT INTO twi_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mpɔtorɔ bɛhyɛ Asubɔnten Nil ma. Wɔbɛba wʼahemfi, na wɔakɔ mo mpia mu, na afoforo akɔ mo mpa so, mo nkurɔfo ne mpanyimfo afi mu, ne mo fononoo ne nea mode fɔtɔw asikresiam nyinaa amaama. ");
INSERT INTO twi_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Mpɔtorɔ no bɛba mo nkurɔfo ne mpanyimfo nyinaa so.’ ” ");
INSERT INTO twi_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Awurade ka kyerɛɛ Mose se, “Ka kyerɛ Aaron na ɔmfa pema no nkyerɛ nsubɔnten, nsuwa ne atare a ɛwɔ Misraim nyinaa so sɛnea ɛbɛyɛ a, mpɔtorɔ bebu so wɔ ɔman no afanan nyinaa.” ");
INSERT INTO twi_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaron teɛɛ ne nsa wɔ Misraim nsu so maa mpɔtorɔ bɛhyɛɛ ɔman no mu nyinaa ma tɔ. ");
INSERT INTO twi_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Nanso nkonyaayifo no nso yɛɛ saa ara maa mpɔtorɔ baa asase no so. ");
INSERT INTO twi_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Afei, Farao frɛɛ Mose ne Aaron ka kyerɛɛ wɔn se, “Monkɔsrɛ Awurade na onyi mpɔtorɔ no mfi asase yi so, na mɛma mo nkurɔfo no kwan na wɔakɔbɔ no afɔre.” ");
INSERT INTO twi_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose nso ka kyerɛɛ no se, “Kyerɛ me bere ko a wopɛ sɛ wɔkɔ. Me nso mɛbɔ ho mpae ama mpɔtorɔ no nyinaa awuwu wɔ baabiara wɔ bere a wobɛhyɛ me no mu, na aka asubɔnten no mu mpɔtorɔ no nko ara.” ");
INSERT INTO twi_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Farao kae se, “Monyɛ no ɔkyena nko ara.” Mose buae se, “Mate, ɛbɛba mu sɛnea woaka no na ama woahu sɛ obiara nni hɔ sɛ Awurade, yɛn Nyankopɔn, no nko ara. ");
INSERT INTO twi_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Mpɔtorɔ no nyinaa bewuwu ama aka wɔn a wɔwɔ asubɔnten no mu no.” ");
INSERT INTO twi_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mose ne Aaron fii Farao anim kɔe. Mose kɔsrɛɛ Awurade sɛ onyi mpɔtorɔ a ɔde wɔn abegu Farao so no. ");
INSERT INTO twi_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Awurade tiee Mose nkotosrɛ no. Mpɔtorɔ wuwu hyɛɛ ɔman no mu ne afi mu ma tɔ. ");
INSERT INTO twi_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Wɔboaboaa mpɔtorɔ a wɔawuwu no ano akuw akɛseakɛse maa ɔman no mu bɔn yiye. ");
INSERT INTO twi_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Nanso Farao huu sɛ mpɔtorɔ no kɔ no, ɔsan pirim ne koma bio enti wamma nnipa no ankɔ sɛnea Awurade aka ato hɔ no. ");
INSERT INTO twi_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Na Awurade ka kyerɛɛ Mose se, “Ka kyerɛ Aaron se, ‘Teɛ wo pema no bɔ fam mfutuma na ɛbɛdan ntontom ahyɛ Misraim asase no so ma tɔ.’ ” ");
INSERT INTO twi_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Mose ne Aaron yɛɛ nea Awurade hyɛɛ wɔn no maa ntontom bɛhyɛɛ ɔman mu no ne mu nnipa ne wɔn nyɛmmoa so ma tɔ. Misraim mfutuma nyinaa dan ntontom. ");
INSERT INTO twi_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Nkonyaayifo no pɛɛ sɛ wɔn nso de wɔn anyankamade yɛ saa ara, nanso wɔantumi. ");
INSERT INTO twi_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Nkonyaayifo no kyerɛɛ Farao se, “Eyi de Onyankopɔn nsa wɔ mu.” Nanso Farao pirim ne koma enti wantie wɔn sɛnea Awurade aka ato hɔ no. ");
INSERT INTO twi_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Na Awurade ka kyerɛɛ Mose se, “Sɔre anɔpatutuutu kohyia Farao bere a ɔrekɔ asubɔnten no mu no na, ka akyerɛ no se, ‘Awurade se: Ma me nkurɔfo nkɔ na wɔnkɔsom me. ");
INSERT INTO twi_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Na sɛ woamma me nkurɔfo ankɔ a, mɛma nwansena agye Misraim afa. Mo afi mu ne asase no nyinaa bɛyɛ nwansena manyamanya. ");
INSERT INTO twi_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Na nsonoe kɛse bɛda ɛha ne Gosen asase a Israelfo no te so no ntam, efisɛ nwansena biara renkɔ hɔ. Na ɛbɛma woahu sɛ, me Awurade mewɔ asase yi so. ");
INSERT INTO twi_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Na mɛma wo nkurɔfo ho ada nsow afi me nkurɔfo ho. Saa nsɛnkyerɛnne yi besi ɔkyena.’ ” ");
INSERT INTO twi_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Awurade yɛɛ nea ɔkae no, enti nwansena bebu faa ɔman no so maa bi kɔhyɛɛ Farao ahemfi ne Misraim afi nyinaa mu amaama. ");
INSERT INTO twi_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Na Farao frɛɛ Mose ne Aaron ka kyerɛɛ wɔn se, “Monkɔbɔ afɔre mma mo Nyankopɔn wɔ ɔman yi ara mu.” ");
INSERT INTO twi_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Nanso Mose kae se, “Saa de, ɛrenyɛ ye. Yɛn afɔre a yɛbɔ ma Onyankopɔn no yɛ Misraimfo no ani so akyiwade, so wɔrensiw yɛn abo ana? ");
INSERT INTO twi_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ɛsɛ sɛ yetu nnansa kwan kɔ sare so, na yɛkɔbɔ afɔre ma Awurade, yɛn Nyankopɔn, sɛnea ɔhyɛ yɛn no.” ");
INSERT INTO twi_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farao kae se, “Mɛma mo kwan akɔ sare so akɔbɔ afɔre, na mmom, monnkɔ akyiri. Afei, mommɔ mpae mma me.” ");
INSERT INTO twi_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mose buae se, “Sɛ mifi ha pɛ a, mɛbɔ Awurade mpae na ɔkyena nwansena bebrebe no ase bɛtɔre afi wo, wo mpanyimfo ne wo nkurɔfo so. Nanso Farao nhwɛ yiye sɛ ɔrennaadaa bio a ɔremma nnipa no nkɔ nkɔbɔ afɔre mma Awurade.” ");
INSERT INTO twi_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Enti Mose fii Farao nkyɛn kɔbɔɔ Awurade mpae, ");
INSERT INTO twi_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","na Awurade yɛɛ Mose abisade no. Nwansena no nyinaa ase tɔre fii Farao ne ne mpanyimfo so; anka ɔbaako mpo. ");
INSERT INTO twi_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Nanso Farao san pirim ne koma a wamma nnipa no ankɔ. ");
INSERT INTO twi_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Awurade hyɛɛ Mose se, “San kɔ Farao nkyɛn na kɔka kyerɛ no se, ‘Sɛnea Awurade a ɔyɛ Hebrifo Nyankopɔn no se ni,’ Ma me nkurɔfo no nkɔ na wɔatumi abɔ afɔre ama me.” ");
INSERT INTO twi_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Sɛ wampene amma wɔn ankɔ a, ");
INSERT INTO twi_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Onyankopɔn nsa de ɔyaredɔm bɛba abekum mo apɔnkɔ, mo mfurum, mo yoma, mo anantwi, mo nguan ne mo mmirekyi nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Nanso Awurade de nsonoe bɛto Israelfo mmoa ne Misraimfo mmoa ntam. Israelfo mmoa de, ɔbaako mpo renwu. ");
INSERT INTO twi_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Awurade ahyɛ bere pɔtee na ɔkae se, Ɔkyena, Awurade bɛyɛ eyi wɔ asase no so. ");
INSERT INTO twi_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Na ade kyee no, nyɛmmoa a wɔwɔ Misraim no wuwui, nanso Israelfo no ayɛmmoa baako mpo koraa anwu. ");
INSERT INTO twi_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao somaa nnipa kɔɔ Israel kɔhwɛɛ sɛ ampa ara ɛhɔ nyɛmmoa no bi anwu koraa ana. Nnipa no bɛbɔɔ Farao amanneɛ se Israelfo nyɛmmoa baako mpo koraa anwu, nanso nʼadwene ansesa. Wamma nnipa no ankɔ. ");
INSERT INTO twi_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Enti Awurade ka kyerɛɛ Mose ne Aaron se, “Monkɔsaw nso mfi fononoo mu, na Mose ntow mpete wim wɔ Farao anim. ");
INSERT INTO twi_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Na ɛbɛbɔ apete Misraim asase so nyinaa sɛ mfutuma ama mpɔmpɔnini abobɔ nnipa ne mmoa a wɔwɔ ɔman no mu nyinaa.” ");
INSERT INTO twi_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Enti wɔkɔsaw nso fii fononoo mu de kɔɔ Farao anim, na ɔrehwɛ no, Mose tow petee wim na ɛdan mpɔmpɔnini bobɔɔ nnipa ne mmoa a wɔwɔ Misraim nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ɛbaa saa no, nkonyaayifo no antumi ne Mose anni asi, efisɛ na mpɔmpɔnini no bi asisi wɔn nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Nanso Farao pirim ne koma ara, enti wantie asɛm a Awurade nam Mose so ka kyerɛɛ no no. ");
INSERT INTO twi_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Awurade ka kyerɛɛ Mose se, “Sɔre kɔ Farao nkyɛn anɔpahema na kɔka kyerɛ no se, Hebrifo Awurade Nyankopɔn no se, Ma me nkurɔfo nkɔsom me, ");
INSERT INTO twi_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","anyɛ saa a, mede ɔhaw na ɛbɛto mo so na ɛno na ɛbɛma wo ne wʼadwumayɛfo ne Misraimfo nyinaa ahu sɛ Onyankopɔn biara nni asase yi so ka me ho. ");
INSERT INTO twi_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Sɛ mepɛ a anka matɔre mo nyinaa ase, anka mede ɔyaredɔm bekum mo nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Nanso manyɛ no saa, efisɛ na mepɛ sɛ meda me tumi adi kyerɛ wo ne asase sofo nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Woayɛ kyenkyenee wɔ me nkurɔfo so a ɛno nti, womma wɔnkɔ. ");
INSERT INTO twi_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ɔkyena saa bere yi ara mu, mɛma mparuwbo a ano yɛ den a bi ntɔɔ Misraimman mu da atɔ. ");
INSERT INTO twi_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ntɛm! Monka mo anantwi a mode wɔn kɔ adidi no mmra fie. Efisɛ mparuwbo no bekum nnipa ne mmoa a wɔbɛka wuram no nyinaa.” ");
INSERT INTO twi_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Misraimfo a asɛm no bɔɔ wɔn hu no de wɔn anantwi ne wɔn asomfo nyinaa baa fie. ");
INSERT INTO twi_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Na wɔn a wɔammu Awurade asɛm a ɔkae no gyaw wɔn anantwi ne wɔn asomfo wɔ wuram maa mparuwbo no kaa wɔn. ");
INSERT INTO twi_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Awurade ka kyerɛɛ Mose se, “Teɛ wo nsa kyerɛ soro na ma mparuwbo no ntɔ ngu nnipa, mmoa ne nnua a ɛwɔ Misraim nyinaa so.” ");
INSERT INTO twi_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Enti Mose de ne nsa kyerɛɛ wim maa Awurade maa anyinam ne aprannaa twitwae. ");
INSERT INTO twi_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Na ɛyɛ asɛm a ɛyɛ hu yiye. Efisɛ efi Misraim abɔse de kosi saa bere no, na aprannaa mmobɔɔ saa da. ");
INSERT INTO twi_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Misraimman sɛee pasaa. Biribiara a ɛkaa wuram, sɛ ɛyɛ nnipa anaa mmoa no, wɔn nyinaa wuwui. Nnua nso bubu maa nnɔbae sɛesɛee. ");
INSERT INTO twi_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Faako a mparuwbo no antɔ wɔ ɔman no mu no yɛ Gosen asase so a na Israelfo no te hɔ no. ");
INSERT INTO twi_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Afei, Farao soma ma wɔkɔfrɛɛ Mose ne Aaron ka kyerɛɛ wɔn se, “Afei de, mahu me mfomso. Awurade di bem na me ne me nkurɔfo ayɛ bɔne ama atra so. ");
INSERT INTO twi_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Monsrɛ Awurade mma me, na ɔmma aprannaa ne mparuwbo dodow yi to ntwa na mɛma mo akɔ ntɛm so.” ");
INSERT INTO twi_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose kae se, “Sɛ mifi kuropɔn yi mu ara pɛ a, mɛma me nsa so abɔ Awurade mpae na aprannaa no ne mparuwbo no agyae. Eyi bɛma mo ahu sɛ Awurade na asase nyinaa hyɛ ne nsa. ");
INSERT INTO twi_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Nanso minim yiye sɛ wo ne wo mpanyimfo de, eyinom nyinaa akyi no, mubepirim mo koma.” ");
INSERT INTO twi_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Aprannaa no sɛee wɔn awi ne wɔn asaawa a na ɛresow aba no nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Nanso atoko ne aburow de, ansɛe, efisɛ na emfifii ɛ. ");
INSERT INTO twi_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Enti Mose fii Farao anim wɔ kurow no mu maa ne nsa so kyerɛɛ Awurade maa aprannaa no ne mparuwbo no ne osu no gyaee tɔ. ");
INSERT INTO twi_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Farao ne ne mpanyimfo huu sɛ biribiara ayɛ yiye wɔ hɔ no, wɔkɔɔ so pirim wɔn koma yɛɛ bɔne de buu bɔ a wɔhyɛɛ Awurade no so. ");
INSERT INTO twi_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Enti Farao amma nkurɔfo no ankɔ sɛnea Onyankopɔn hyɛɛ ho nkɔm kyerɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Awurade ka kyerɛɛ Mose se, “San kɔ Farao nkyɛn efisɛ mapirim ɔne ne mpanyimfo nyinaa koma sɛnea ɛbɛyɛ a metumi ayɛ me nsɛnkyerɛnne ahorow yi wɔ wɔn mu ");
INSERT INTO twi_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","na ɛnam so ama woatumi aka anwonwade a mayɛ wɔ Misraim asase so no akyerɛ wo mma ne wo nenanom, sɛnea me ne Misraimfo no dii no nwenweenwen ne sɛnea meyɛɛ nsɛnkyerɛnne ahorow wɔ wɔn mu no, na ama woahu sɛ mene Awurade no.” ");
INSERT INTO twi_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Enti Mose ne Aaron kohuu Farao ka kyerɛɛ no se, “Awurade a ɔyɛ Hebrifo Nyankopɔn no se mimmisa wo se, ‘Enkosi da bɛn na wubebu me animtiaa? Ma me nkurɔfo nkɔ na wɔnkɔsom me. ");
INSERT INTO twi_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Sɛ woamma wɔn ankɔ a, ɔkyena nko ara mɛma mmoadabi aba wo man yi mu. ");
INSERT INTO twi_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Wɔbɛkata asase no ani nyinaa. Na wɔbɛwe biribiara a ɛkae a mparuwbo a ɛtɔe no ansɛe no no nyinaa a wuram nnua nyinaa ka ho. ");
INSERT INTO twi_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mmoa no bɛhyɛ wʼahemfi hɔ, wo mpanyimfo afi mu ne Misraimfo afi nyinaa ma tɔ. Ɛbɛyɛ ɔhaw a, efi bere a mo agyanom bɛtenaa asase yi so de besi nnɛ no, bi nsii saa da.’ ” Na Mose fii Farao anim kɔe. ");
INSERT INTO twi_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Farao mpanyimfo bisaa no se, “Enkosi da bɛn na saa ɔbarima yi bɛyɛ yɛn konnua? Wunhuu sɛ Misraim nyinaa adan amamfo? Ma nnipa no kwan na wɔnkɔ nkɔsom Awurade wɔn Nyankopɔn no!” ");
INSERT INTO twi_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Enti wɔsan de Mose ne Aaron baa Farao anim. Farao kae se, “Eye, monkɔsom Awurade, mo Nyankopɔn no. Na ɛhefo na mo ne wɔn bɛkɔ?” ");
INSERT INTO twi_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose buaa Farao se, “Yɛde mmofra ne mpanyin, yɛn mmabarima, yɛn mmabea, yɛn nguan ne yɛn anantwi na ɛbɛkɔ. Yɛde yɛn agyapade nyinaa na ebetu saa kwan no, efisɛ ɛsɛ sɛ yɛn nyinaa kɔ Awurade afahyɛ no.” ");
INSERT INTO twi_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farao de abufuw buae se, “Sɛ mɛma mode mmofra nketewa yi akɔ a, ɛno de, Awurade ankasa nka mo ho. Mahu sɛ mowɔ adwemmɔne. ");
INSERT INTO twi_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ɛnsɛ sɛ ɛba saa. Mo mmarima no, monkɔsom Awurade, efisɛ ɛno na mobisaa me.” Farao pam wɔn fii nʼahemfi hɔ. ");
INSERT INTO twi_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Awurade ka kyerɛɛ Mose se, “Teɛ wo nsa wɔ Misraim so na mmoadabi mmɛkata asase no nyinaa so, na wonni biribiara a mparuwbo no ansɛe no no.” ");
INSERT INTO twi_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Enti Mose maa ne pema so kyerɛɛ Misraim asase so maa Awurade bɔɔ mframa bi fii apuei fam awia ne anadwo. Ade kyee no, na apuei mframa no de mmoadabi no abegu asase no so nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Mmoadabi no kataa Misraim asase no so mmaa nyinaa. Misraim abakɔsɛm kyerɛ se, mmoadabi mmaa ɔman no mu saa da na bi nso remma saa bio. ");
INSERT INTO twi_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Mmoa no kataa asase ani nyinaa ma wosiw owia ani enti wɔmaa sum duruu asase no so. Wɔwee biribiara a mparuwbo no ansɛe no no; biribiara a ɛyɛ ahabammono anka; sɛ ɛyɛ dua anaa afifide a ɛwɔ ɔman no mu baabiara no. ");
INSERT INTO twi_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ntɛm pa ara Farao tuu abɔfo kɔfrɛɛ Mose ne Aaron ka kyerɛɛ wɔn se, “Mayɛ bɔne atia Awurade, mo Nyankopɔn no, ne mo nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Afei, momfa me bɔne nkyɛ me bio na monsrɛ Awurade, mo Nyankopɔn no, sɛ onyi owu yi mfi yɛn so.” ");
INSERT INTO twi_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Enti Mose fii Farao anim kɔsrɛɛ Awurade. ");
INSERT INTO twi_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Awurade bɔɔ atɔe fam mframa dennen bi ma epiaa mmoadabi no nyinaa koguu Po Kɔkɔɔ no mu, a anka ɔbaako pɛ koraa wɔ Misraim asase no so. ");
INSERT INTO twi_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Nanso Awurade pirim Farao koma nti wamma Israelfo no ankɔ. ");
INSERT INTO twi_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Awurade ka kyerɛɛ Mose se, “Teɛ wo nsa kyerɛ soro mma sum kabii mmeduru Misraim asase so.” ");
INSERT INTO twi_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Enti Mose teɛɛ ne nsa hwɛɛ soro maa sum kabii beduruu Misraim asase no so nnansa. ");
INSERT INTO twi_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Sum no duruu saa no, na obiara nhu hwee na wontumi ntu wɔn anan nso nnansa. Nanso Israelfo no de, na nea wɔte hɔ yɛ hann. ");
INSERT INTO twi_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Farao frɛɛ Mose ka kyerɛɛ no se, “Kɔ na kɔsom Awurade. Wubetumi de wo mma aka wo ho akɔ; nanso wo nguan ne wʼanantwi no de, ma wɔnka ha.” ");
INSERT INTO twi_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Nanso Mose buae se, “Dabi, ɛsɛ sɛ yɛde yɛn nguan ne yɛn anantwi kɔ na yɛde wɔn mu bi bɔ ɔhyew afɔre ma Awurade, yɛn Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Aboa tɔte koraa yɛrennyaw wɔ ha; ɛsɛ sɛ yɛbɔ Awurade, yɛn Nyankopɔn no afɔre. Yennim nea ɔbɛpɛ gye sɛ yedu hɔ.” ");
INSERT INTO twi_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Nanso Awurade pirim Farao koma nti wamma wɔn ankɔ. ");
INSERT INTO twi_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao teɛteɛɛ Mose se, “Fi mʼani so kɔ! Mɛhwɛ sɛ woremma mʼanim bio! Da a wubehu mʼanim no, wubewu.” ");
INSERT INTO twi_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mose buae se, “Meremma wʼanim bio sɛnea woreka no pɛpɛɛpɛ.” ");
INSERT INTO twi_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Afei, Awurade ka kyerɛɛ Mose se, “Mɛma ɔhaw a etwa to aba Farao ne nʼasase so. Na ɛno akyi no, ɔbɛma mo akɔ. Nokware, ne ho bɛpere no sɛ mubefi ne ho ama ɔno ara apam mo afi ɔman no mu. ");
INSERT INTO twi_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Monka nkyerɛ Israelfo mmarima ne mmaa nyinaa se wɔnsrɛ wɔn amannifo Misraimfo no na wɔmma wɔn sikakɔkɔɔ ne dwetɛ adwinne.” ");
INSERT INTO twi_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Awurade maa Misraimfo no huu Israelfo no mmɔbɔ, na Mose nso yɛɛ onipa kɛse a na Farao mpanyimfo ne Misraimfo no bu no yiye wɔ ɔman no mu. ");
INSERT INTO twi_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mose bɔɔ Farao amanneɛ se, “Nea Awurade se ni, ‘Anadwo nnɔndumien metwa mu wɔ Misraim asase so. ");
INSERT INTO twi_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Na Misraim fi biara mu ɔbabarima panyin bewu. Efi Farao babarima panyin so, ne dehye a obedi nʼade, ne somfo mu somfo kumaa koraa ba panyin ne ne nyɛmmoa abakan nyinaa bewuwu. ");
INSERT INTO twi_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Na owu no ho agyaadwotwa bedu Misraim asase so nyinaa. Awerɛhow a ɛte saa mmaa Misraim asase so da, na bi nso remma da bio. ");
INSERT INTO twi_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Na Israelfo mu de, biribiara bɛyɛ dwoodwoo na ɔkraman mpo rempɔw.’ Na ɛbɛma woahu sɛ, Awurade de nsonoe ato Misraimfo ne Israelfo ntam! ");
INSERT INTO twi_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Wo mpanyimfo yi nyinaa betu mmirika, adi mʼakyi, akotow asrɛ sɛ, ‘Yɛpa wo kyɛw, fi ha ntɛm na kɔfa wo nkurɔfo nyinaa ka wo ho kɔ.’ Sɛ ɛba saa a ansa na mɛkɔ!” Mose wiee kasa no, ɔde abufuwhyew fii ahemfi hɔ kɔe. ");
INSERT INTO twi_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Na Awurade aka akyerɛ Mose se, “Asɛm a wobɛka no, Farao rentie. Na ɛno so na megyina ayɛ anwonwade de ada me tumi adi.” ");
INSERT INTO twi_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ɛwɔ mu sɛ Mose ne Aaron yɛɛ saa anwonwade no nyinaa wɔ Farao anim de, nanso Awurade pirim ne koma sɛnea ɔremma nnipa no mfi asase no so nkɔ. ");
INSERT INTO twi_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Bere a na Mose ne Aaron da so wɔ Misraim asase so no, Awurade ka kyerɛɛ wɔn se, ");
INSERT INTO twi_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Efi nnɛ rekɔ, ɔsram yi bɛyɛ ɔsram a edi kan wɔ Yudafo asranna so. ");
INSERT INTO twi_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ka kyerɛ Israelfo nyinaa se, saa ɔsram yi da a ɛto so du no, ɛsɛ sɛ ɔbarima biara pɛ oguamma baako de ma nʼabusua. Ɛsɛ sɛ ofi biara nya oguamma no baako. ");
INSERT INTO twi_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Sɛ abusua bi mu nnipa sua a wɔrentumi nwe oguamma no a, wotumi ne abusua bi a ɛbɛn wɔn wɔ mpɔtam hɔ a wɔn nso sua kyɛ oguamma no. Aboa no kyɛ wɔ saa kwan no so no gyina abusua no kɛse ne nam dodow a wobetumi awe so. ");
INSERT INTO twi_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ɛsɛ sɛ aboa no yɛ nea wadi afe. Ɛsɛ sɛ ɔyɛ oguan anaa abirekyi a onnii dɛm. ");
INSERT INTO twi_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Monhwɛ saa mmoa a moayiyi wɔn yi yiye nkosi ɔsram a edii kan no da a ɛto so dunan no anwummere. Afei Israel asafo nyinaa nkunkum wɔn nguantenmma no ɔdasu mu. ");
INSERT INTO twi_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Wɔmfa wɔn mogya nsra ofi biara apongua ho. Oguamma a wɔbɛwe no wɔ fie hɔ no mogya na wɔmfa nyɛ saa ahyɛde yi. ");
INSERT INTO twi_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Anadwo no ara, obiara bɛwe aboa a wɔatoto no no nam no bi. Wɔmfa brodo a wɔamfa mmɔkaw anyɛ ne awɔnwen na enni. ");
INSERT INTO twi_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Wɔnnnoa nam no na wɔnnwe no amono nso, na mmom, wɔntoto aboa mu no nyinaa, a ne ti, nʼanan ne nʼayamde nyinaa ka ho. ");
INSERT INTO twi_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Sɛ moantumi anwe ne nyinaa anadwo no a, nea ɛbɛka no, sɛ ade kye so a, monnnwe na mmom monhyew no. ");
INSERT INTO twi_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Sɛnea monwe nam no ni: monwe wɔ bere a mo ntade a mode tu kwan hyehyɛ mo. Munsiesie mo ho mma ɔkwan tententwa. Monhyɛ mo mpaboa na momfa mo pema nkurakura. Monwe no ntɛmntɛm. Saa nneyɛe yi, wɔbɛfrɛ no Awurade Twam Afahyɛ. ");
INSERT INTO twi_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Na metwa mu afa Misraim asase so anadwo yi na mmabarima a wɔyɛ mmakan ne mmoa mmakan a wɔwɔ Misraim asase so nyinaa, mekum wɔn, na mabu anyame a wɔwɔ Misraim nyinaa atɛn, efisɛ mene Awurade! ");
INSERT INTO twi_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Mogya a mode bɛyɛ apongua no ho no bɛyɛ agyiraehyɛde, enti sɛ mihu mogya no a, metwa mu akɔ, na sɛ merekunkum Misraim mmakan a, merenkum mo de bi. ");
INSERT INTO twi_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Eyi yɛ da a ɛsɛ sɛ mudi; na awo ntoatoaso a ɛbɛba no bedi no sɛ afahyɛ ama Awurade. Eyi yɛ mmara a ɛbɛtena hɔ daa. ");
INSERT INTO twi_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Nnanson no mu, munni brodo a wɔmfaa mmɔkaw mfrae nko ara. Afahyɛ no da a edi kan no, munyiyi mmɔkaw biara mfi mo afi mu. Obiara a saa bere no obebu saa afahyɛ yi mmara yi so no, wobetwa no asu afi Israelman mu. ");
INSERT INTO twi_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Afahyɛ no da a edi kan ne ne nnanson so no, nnipa no nyinaa bedi da no sɛ da a wɔayi asi hɔ ama nhyiamu kronkron. Na nna no mu, aduannoa akyi no, obiara nnyɛ adwuma foforo biara. ");
INSERT INTO twi_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Sɛ mudi Apiti Afahyɛ yi a, ɛbɛma mo akae daa sɛ, saa da no na miyii mo fii Misraim asase so. Munni saa dapɔnna yi sɛ daa ahyɛde mfi awo ntoatoaso so nkosi awo ntoatoaso so. ");
INSERT INTO twi_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ɔsram a edi kan no da a ɛto so dunan no anwummere kosi ne da a ɛto so aduonu baako so no, brodo a mmɔkaw mfra mu nko ara na munni. ");
INSERT INTO twi_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Saa nnanson no mu no, ɛnsɛ sɛ wohu mmɔkaw kakraa bi koraa wɔ mo afi mu. Enti obiara a obedi aduan a mmɔkaw wɔ mu no, wobeyi no afi Israel asafo kuw no mu. Saa mmara yi ka ananafo a wɔne mo te ne wɔn a wofi ɔman no mu no nyinaa nso. ");
INSERT INTO twi_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Miti mu sɛ, saa nna no mu, munnni biribiara a wɔde mmɔkaw afra mu; munni brodo a mmɔkaw mfra mu.” ");
INSERT INTO twi_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Na Mose frɛɛ Israel mpanyimfo nyinaa ka kyerɛɛ wɔn se, “Monkɔkyekyere oguamma anaa abirekyi ba mma abusua biara, na munkum no sɛ Twam Afahyɛ aboa. ");
INSERT INTO twi_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Muntwa oguan no mogya ngu kuruwa bi mu. Momfa adwerɛ mmɔ mogya no mu na momfa mpete apongua no atifi ne apongua abien a aka no ho sɛnea mogya no bɛda ho. Muwie a, mo mu biara mmfi nkɔ abɔnten saa anadwo no. ");
INSERT INTO twi_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Awurade betwa mu afa asase yi so akunkum Misraimfo. Na sɛ ohu sɛ mogya wɔ apongua no atifi ne apongua abien no ho a, obetwa saa ofi no ho akɔ a ɔremma ɔsɛefo no nwura hɔ nkunkum mo mmakan. ");
INSERT INTO twi_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Na monkae sɛ eyi yɛ mmara a ɛwɔ hɔ daa ma mo ne mo asefo. ");
INSERT INTO twi_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Na sɛ moba asase a Awurade de bɛma mo sɛnea ɔhyɛɛ mo ho bɔ no so a, mobɛkɔ so adi afahyɛ no. ");
INSERT INTO twi_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na sɛ mo mma bisa mo se, ‘Eyinom nyinaa ase ne dɛn; saa afahyɛ yi fa dɛn ho a, ");
INSERT INTO twi_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","mummua wɔn se, ɛyɛ Twam Afahyɛ afɔre ma Awurade. Otwaa Israelfo afi ho wɔ Misraim. Ɛwɔ mu sɛ okunkum Misraimfo de, nanso ogyaw yɛn mmusua.’ ” Bere a Mose kasa wiee no, nnipa no nyinaa kotow sɔree. ");
INSERT INTO twi_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Na Israelfo no dii Mose ne Aaron ahyɛde no so. ");
INSERT INTO twi_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Da no ara anadwo nnɔndumien Awurade kunkum mmarimaa a wɔyɛ abakan a wɔwɔ Misraim asase so nyinaa, efi Farao babarima panyin so kosi odeduani babarima panyin ne anantwi nso mmakan nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Afei, Farao ne ne mpanyimfo ne nnipa a wɔwɔ Misraim nyinaa sɔree anadwo no. Misraiman no nyinaa twaa agyaadwo, efisɛ ofi biara nni hɔ a onipa anwu wɔ mu. ");
INSERT INTO twi_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Enti Farao frɛɛ Mose ne Aaron anadwo no ka kyerɛɛ wɔn se, “Mesrɛ mo, mo nyinaa muntu mfi ha. Monkɔsom Awurade sɛnea mokae no. ");
INSERT INTO twi_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Momfa mo nguan ne mo anantwi na monkɔ. Nanso munhyira me ansa na moakɔ.” ");
INSERT INTO twi_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misraimfo no nyinaa ani beree Israelfo no so pampam wɔn sɛ womfi asase no so ntɛm, efisɛ wɔkae se, “Yebewuwu.” ");
INSERT INTO twi_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Israelfo no faa wɔn mmɔre a wɔafɔtɔw a mmɔkaw mfra mu, na wɔde wɔn ntade kyekyeree wɔn mmɔre nnaka de sisii wɔn mmati so. ");
INSERT INTO twi_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Na Israelfo no asrɛsrɛ dwetɛ ne sikakɔkɔɔ adwinne ne ntade afi Misraimfo no nkyɛn sɛnea Mose kaa se wɔnyɛ no. ");
INSERT INTO twi_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Awurade maa Misraimfo no huu Israelfo no mmɔbɔ enti wɔmaa wɔn wɔn abisade nyinaa. Ɛnam saayɛ so maa Israelfo no twee Misraimfo ahonyade nyinaa kɔe. ");
INSERT INTO twi_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Anadwo no ara, Israelfo no sii mu fii Rameses kɔɔ Sukot. Na wɔn dodow yɛ nnipa mpem ahansia a wɔnam fam, a mmea ne mmofra de wɔankan wɔn anka ho. ");
INSERT INTO twi_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Nnipa ahorow pii bi a wɔnyɛ Israelfo kaa wɔn ho kɔe. Wɔde wɔn nguan ne wɔn anantwi nyinaa kaa wɔn ho. ");
INSERT INTO twi_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Woduu baabi a wɔpɛ sɛ wodidi no, wɔde mmɔre a wɔamfa mmɔkaw amfra a wɔde kɔe no bi too brodo dii. Na mmɔkaw nni mu, efisɛ Misraimfo no pam wɔn. Ɛno nti wɔannya kwan anyɛ aduan a wobedi wɔ ɔkwan so. ");
INSERT INTO twi_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israelfo no tenaa Misraim mfe ahannan ne aduasa. ");
INSERT INTO twi_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Na da a wodii mfe ahannan ne aduasa no pɛ na Awurade nkurɔfo nyinaa fii asase no so. ");
INSERT INTO twi_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Saa anadwo no ne bere a Awurade yi too hɔ de gyee ne nkurɔfo fii Misraim asase so. Enti saa anadwo koro no ara na Israelfo no yi de too hɔ sɛ da a Onyankopɔn gyee wɔn no afirihyia da. ");
INSERT INTO twi_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Awurade ka kyerɛɛ Mose ne Aaron se, “Twam Afahyɛ no ho mmara ni: “Ahɔho biara nnwe oguamma no nam no bi. ");
INSERT INTO twi_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Nanso ɔsomfo biara a wɔtew sika tɔɔ no no, sɛ wɔatwa no twetia de a, otumi we bi. ");
INSERT INTO twi_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ɔpaani anaa ɔhɔho biara nnwe bi. ");
INSERT INTO twi_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Ɛsɛ sɛ wɔwe Twam Afahyɛ aboa biara wɔ ofi biara mu. Ɛsɛ sɛ wɔwe nam no wɔ fie. Ɛnsɛ sɛ wɔde nam no fa biara kɔ abɔnten. Ɛnsɛ sɛ mobɔ dompe biara mu. ");
INSERT INTO twi_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ɛsɛ sɛ Israelfo nyinaa di da no. ");
INSERT INTO twi_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Ahɔho a mo ne wɔn te no nso, sɛ wɔpɛ sɛ wodi Twam Afahyɛ no bi a, ɛsɛ sɛ mmarima a wɔwɔ wɔn mu no nyinaa twa twetia ansa na wɔaba ne mo abedi; na ama wɔayɛ sɛnea wɔwoo wɔn too mo mu no. ");
INSERT INTO twi_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Saa mmara yi ka Israelfo ne ahɔho a wɔne mo te no nso.” ");
INSERT INTO twi_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Enti Israelfo no nyinaa dii Awurade mmara no so sɛnea ɔhyɛɛ Mose ne Aaron no. ");
INSERT INTO twi_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Da no ara na Awurade yii Israelfo no fii Misraim asase so. ");
INSERT INTO twi_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Tew Israelfo mmabarima ne aboa biara abakan ho ma me; wɔn nyinaa yɛ me dea.” ");
INSERT INTO twi_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Na Mose ka kyerɛɛ nnipa no se, “Nnɛ yɛ da a ɛsɛ sɛ mokae daa—da a mutu fii Misraim asase a na moyɛ nkoa wɔ so no so. Awurade ayɛ anwonwade akɛse bebree akyerɛ mo. Enti monkae sɛ, sɛ afe du na moredi afahyɛ yi a, mommfa mmɔkaw mfra mo aduan; na mommfa bi nkɔ mo afi nso mu koraa. ");
INSERT INTO twi_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Afe biara mu Abib ɔsram awiei (bɛyɛ Ɔbɛnem awiei), monkae saa otukɔ yi. ");
INSERT INTO twi_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Awurade de mo baa Kanaanfo, Hetifo, Amorifo, Hewifo ne Yebusifo nsase a ɛwo ne nufusu sen so a ɔkaa ho ntam sɛ ɔde bɛma mo no so. ");
INSERT INTO twi_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mubedi brodo a mmɔkaw nni mu nko ara nnanson. Na da a ɛto so ason no, monto pon kɛse mma Awurade. ");
INSERT INTO twi_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ɛnsɛ sɛ obiara kora mmɔkaw wɔ ne fi anaa mo asase no ahye so baabiara. ");
INSERT INTO twi_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Edu afirihyia na moredi nna yi a, monkyerɛ mo mma nea enti a moredi saa afahyɛ no. Ɛyɛ afahyɛ a mode bɛkae nea Awurade yɛ maa mo bere a mutu fii Misraim asase so no. ");
INSERT INTO twi_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Saa afe biara mu nnaawɔtwe afahyɛ yi nyɛ nsɛnkyerɛnne te sɛ agyiraehyɛde a wɔde abɔ mo nsa ho anaa mo moma so sɛ nkae ade. Momma Awurade mmara ntena mo anom, efisɛ tumi kɛse na ɔde yii mo fii Misraim. ");
INSERT INTO twi_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Afe biara, ɛrekɔ Abib (bɛyɛ Ɔbɛnem) awiei no, munni afahyɛ yi. ");
INSERT INTO twi_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Sɛ Awurade de mo ba asase a ɔhyɛɛ mo agyanom ho bɔ tete no a Kanaanfo te so mprempren no so a, monkae sɛ ");
INSERT INTO twi_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","mo mmabarima a wɔyɛ mmakan nyinaa ne nyɛmmoa mmakan a wɔyɛ mmarima no nyinaa yɛ Awurade dea. Enti momfa mma no. ");
INSERT INTO twi_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mutumi de oguan ba anaa abirekyi ba bɛsesa afurum ba abakan. Na sɛ woyɛ wʼadwene sɛ woremfa afurum no nni nsesa a, ɛsɛ sɛ wubu afurum no kɔn mu kum no. Nanso mo mmabarima abakan de, ɛsɛ sɛ motɔ wɔn ti. ");
INSERT INTO twi_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Na sɛ daakye bi mo mma bisa mo se, ‘Eyinom nyinaa ase ne dɛn a, monka nkyerɛ wɔn se, Awurade nam anwonwade akɛse a ɔyɛe so na oyii yɛn fii nkoasom mu wɔ Misraim. ");
INSERT INTO twi_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Na Farao mpɛ sɛ ɔma yɛn kwan ma yɛkɔ nti, Awurade kum mmabarima ne mmoanini a wɔyɛ mmakan a wɔwɔ Misraim asase so nyinaa. Ɛno nti na yɛde mmabarima a wɔyɛ mmakan rema Awurade yi, nanso nnipa mmabarima mmakan no de, wɔtɔ wɔn ti.’ ");
INSERT INTO twi_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Na afahyɛ yi bɛda mo nsow sɛ moyɛ Onyankopɔn mma te sɛnea ɔde nʼagyiraehyɛde abɔ mo moma so a ɛkyerɛ sɛ Awurade nam ne tumi kɛse no so na ɔde yii yɛn fii Misraim.” ");
INSERT INTO twi_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Farao maa nnipa no kwan sɛ wɔnkɔ no, Onyankopɔn amma wɔamfa ɔkwan a ɛfa Filistifo man no mu a na ɛyɛ tiaa no so. Efisɛ Onyankopɔn kae se, “Sɛ wokohyia ɔko a, ebia na wɔasesa wɔn adwene ama wɔasan akɔ Misraim.” ");
INSERT INTO twi_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Enti Onyankopɔn dii wɔn anim de wɔn faa sare so de wɔn ani kyerɛɛ Po Kɔkɔɔ. Israelfo no sii mu fii Misraim a na wɔasiesie wɔn ho ama ɔko. ");
INSERT INTO twi_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mose rekɔ no, ɔfaa Yosef nnompe de kaa ne ho kɔe, efisɛ na Yosef ama Israel mma aka Onyankopɔn ntam sɛ, “Sɛ ɔreyi wɔn afi Misraim a, wɔde ne nnompe bɛkɔ bi, efisɛ na onim sɛ Onyankopɔn beyi wɔn afi Misraim asase so.” ");
INSERT INTO twi_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Wofi Sukot no, wɔkɔkyeree nsraban wɔ Etam sare no ano. ");
INSERT INTO twi_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Awurade de omununkum kyerɛɛ wɔn kwan awia na ɔde ogya nso kyerɛɛ wɔn kwan anadwo. Enti na wotumi tu wɔn kwan no awia ne anadwo nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Awia mununkum fadum anaa anadwo gya fadum no amfi nʼafa wɔ nnipa no anim da. ");
INSERT INTO twi_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ka kyerɛ nnipa no na wɔmman mfa Pihahirot a ɛwɔ Migdol ne po no ntam a ɛne Baal-Sefon di nhwɛanim no. Sɛ wodu hɔ a, wonsi wɔn ntamadan wɔ mpoano hɔ. ");
INSERT INTO twi_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Sɛ wɔyɛ saa a, Farao besusuw sɛ, ‘Saa Israelfo no aka sare no ne po no ntam.’ ");
INSERT INTO twi_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Na mɛsan apirim Farao koma bio ama wataa mo. Mayɛ saa nhyehyɛe yi, sɛnea ɛbɛma manya anuonyam ne nidi wɔ Farao ne nʼasraafo mu na ama Misraimfo no nso ahu sɛ, mene Awurade no.” Enti wosii ntamadan wɔ faako a wɔkyerɛɛ wɔn hɔ no. ");
INSERT INTO twi_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Nnansa akyi a Misraimhene no tee sɛ Israelfo no abɔ wɔn tirim sɛ wɔrensan mma Misraim bio na mmom kɔ ara na wɔrekɔ no, Farao ne ne dɔm koma sɔree bio. Wobisae se, “Dɛn na yɛayɛ yi? Yɛama Israelfo no kwan ma wɔkɔ ama yɛahwere wɔn som!” ");
INSERT INTO twi_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Enti Farao faa ne teaseɛnam dii nʼasraafo no anim taa wɔn. ");
INSERT INTO twi_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ɔmaa Misraim apɔnkɔsotefo dɔm a wɔn dodow yɛ ahansia ne apɔnkɔ foforo bi a asraafo tete wɔn so ka wɔn. ");
INSERT INTO twi_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Farao taa Israelfo no, efisɛ na wɔde Misraimfo agyapade bebree kɔ. ");
INSERT INTO twi_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Farao de nʼapɔnkɔdɔm nyinaa taa Israelfo no bɛtoo wɔn sɛ wɔasisi wɔn ntamadan wɔ Pihahirot mpoano wɔ Baal-Sefon anim. ");
INSERT INTO twi_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Bere a Farao asraafo no rebɛn no, Israelfo no huu wɔn sɛ wɔde mmirika reba enti wɔn koma tui, na wosu frɛɛ Awurade sɛ ɔmmoa wɔn. ");
INSERT INTO twi_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ɛmaa wɔn ani beree Mose so bisaa no se, “Wode yɛn aba sare yi so sɛ yemmewuwu wɔ ha, efisɛ nna nni Misraim a sɛ yewuwu a wobesie yɛn wɔ mu ana? Adɛn nti na woma yetu fii Misraim? ");
INSERT INTO twi_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Bere a yɛwɔ nkoasom mu no, yɛanka ankyerɛ wo se ma yɛmpɛ yɛn baabi ntena? Yɛkae se yɛpɛ sɛ yɛbɛhyɛ nkoasom ase wɔ Misraim sen sɛ yebewu agu sare so ha.” ");
INSERT INTO twi_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Nanso Mose ka kyerɛɛ nnipa no se, “Munnsuro. Munnyina pintinn na mubehu anwonwakwan a Awurade nam so begye mo nnɛ. Misraimfo a muhu wɔn nnɛ yi, morenhu wɔn bio. ");
INSERT INTO twi_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Awurade bɛko ama mo; montɛm dinn kɛkɛ!” ");
INSERT INTO twi_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Na Awurade ka kyerɛɛ Mose se, “Adɛn nti na wusu frɛ me? Ka kyerɛ Israelfo no na wɔnkɔ wɔn anim. ");
INSERT INTO twi_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Fa wo pema no. Fa kyerɛ nsu no so na po no mu bɛpae ama ɔkwan ada mu ma Israelfo no afa asase wosee so. ");
INSERT INTO twi_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mepirim Misraimfo no koma ama wɔataa mo na di a medi Farao ne ne dɔm so no bɛma moahu mʼanuonyam. ");
INSERT INTO twi_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Na Misraimfo nyinaa behu sɛ, mene Awurade.” ");
INSERT INTO twi_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Onyankopɔn bɔfo a odi Israelfo anim no twee ne ho bedii Israelfo no akyi. Na omununkum dum no nso bedii Israelfo no akyi. ");
INSERT INTO twi_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ebetwaa Israelfo no ne Misraimfo no ntam. Na anadwo no, ɛdan ogya maa sum tɔɔ Misraimfo no so maa ne hann no kyerɛɛ Israelfo no kwan. Enti Misraimfo no anhu Israelfo no akyi kwan. ");
INSERT INTO twi_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mose teɛɛ ne nsa wɔ po no so, na anadwo no nyinaa Awurade de apuei mframa dennen maa po no san nʼakyi maa asase no yɛɛ wosee. ");
INSERT INTO twi_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Enti Israelfo no faa po kwan a mu wosee no so. Na nsu no yɛɛ afasu wɔ benkum ne nifa maa wɔn. ");
INSERT INTO twi_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Misraimfo no nso ne Farao apɔnkɔ, nteaseɛnam ne apɔnkɔsotefo no tiw wɔn koduu po no mfimfini. ");
INSERT INTO twi_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Na anɔpahema no, Awurade de ogya ne omununkum dum no too Misraimdɔm no so maa wɔn ho yeraw wɔn. ");
INSERT INTO twi_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Wɔn nteaseɛnam no nan tutui, enti na wontumi nkɔ bio. Enti Misraimfo no kae se, “Momma yenguan mfi Israelfo anim, efisɛ Awurade reko ama wɔn na yɛn de, ɔreko atia yɛn.” ");
INSERT INTO twi_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Awurade ka kyerɛɛ Mose se, “Teɛ wo nsa wɔ po no so, na nsu no nsan mmra Misraimfo ne wɔn nteaseɛnam ne apɔnkɔsotefo no so.” ");
INSERT INTO twi_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mose yɛɛ saa, na ade kyee anɔpa no, po no san nʼakyi bɛsen sɛnea na ɛte. Misraimfo no pɛɛ sɛ woguan, nanso Awurade maa nsu no faa wɔn. ");
INSERT INTO twi_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nsu no kataa kwan no ne nteaseɛnam ne apɔnkɔsotefo no nyinaa so. Farao asraafo dodow a wɔfaa po no mu taa Israelfo no nso, anka ɔbaako koraa. ");
INSERT INTO twi_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Israelfo no nantew faa asase wosee a nsu yɛ ɔfasu wɔ benkum ne nifa no so. ");
INSERT INTO twi_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Saa da no Awurade gyee Israelfo fii Misraimfo nsam. Na Israelfo no huu Misraimfo no sɛ wɔawuwu deda mpoano. ");
INSERT INTO twi_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Bere a Israelfo huu tumi a Awurade ada no adi de atia Misraimfo no, wosuroo Awurade, na wogyee Awurade ne nʼakoa Mose dii. ");
INSERT INTO twi_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Na Mose ne Israelfo no too saa dwom yi de kamfoo Awurade: “Mɛto dwom ama Awurade, efisɛ wadi nkonim anuonyam mu; Watow ɔpɔnkɔ ne ne sotefo no agu po mu. ");
INSERT INTO twi_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Awurade yɛ mʼahoɔden, me dwom ne me nkwagye. Ɔyɛ me Nyankopɔn, na mɛkamfo no. Ɔyɛ mʼagya Nyankopɔn, mɛma no so. ");
INSERT INTO twi_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Awurade yɛ ɔkofo; ne din ne Awurade. ");
INSERT INTO twi_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Farao nteaseɛnam ne nʼakofo, watow wɔn agu po mu. Wɔamemem wɔ Po Kɔkɔɔ mu. Misraim akofo atitiriw awuwu asorɔkye ase. ");
INSERT INTO twi_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Nsu akata wɔn so. Wɔmemem asubun mu sɛ ɔbo. ");
INSERT INTO twi_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Wo nsa nifa, Awurade, tumi ne anuonyam ahyɛ no ma; wo nsa nifa, Awurade, atetew atamfo mu pasaa. ");
INSERT INTO twi_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“Wo tumi kɛse no mu na wonam tuu wɔn a wotia wo no gui. Womaa wʼabufuw bɛhyew wɔn sɛnea ogya hyew sare. ");
INSERT INTO twi_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Wugu ahome a, nsu mu pae. Egyinaa sɛ afasu maa po taa fa ne fa. ");
INSERT INTO twi_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ɔtamfo kae se, ‘Mɛtaa wɔn, mɛto wɔn, asɛe wɔn. Mɛtwe mʼafoa wɔ wɔn so atwitwa wɔn asinasin.’ ");
INSERT INTO twi_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nanso Onyankopɔn bɔɔ ne mframa ma po kataa wɔn so. Wɔmemem sɛ sumpii wɔ subun no mu. ");
INSERT INTO twi_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Hena na ɔte sɛ Awurade wɔ anyame mu? Hena na ɔte sɛ wo? Obirɛmpɔn, wɔ kronkronyɛ mu; nea yɛde osuro kronkron ma nʼanuonyam, Ɔnwonwani Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“Woteɛɛ wo nsa nifa na asase menee wɔn. ");
INSERT INTO twi_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Woadi nnipa a wugyee wɔn no anim. Wʼayamye mu, wubedi wo nkurɔfo a woagye wɔn anim. Wʼahoɔden mu, wobɛkyerɛ wɔn kwan akɔ wo tenabea kronkron hɔ. ");
INSERT INTO twi_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Amanaman bɛte ama wɔn ho apopo. Ehu bɛka nnipa a wɔwɔ Filistia. ");
INSERT INTO twi_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edom mpanyimfo besuro. Atumfo a wɔwɔ Moab ho bɛwosow. Na nnipa a wɔwɔ Kanaan nyinaa bɛbɔ huboa. ");
INSERT INTO twi_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ehu ne suro bɛtɔ wɔn so. Awurade, wo tumi nti, wɔremma yɛn so! Wo nkurɔfo a wotɔɔ wɔn Betwa wɔn ho asomdwoe mu. ");
INSERT INTO twi_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Wode wɔn bɛba abedua wɔn wɔ wo bepɔw so, wo ara wo fi hɔ, Awurade— Kronkronbea a woasiesie sɛ wo tenabea no. ");
INSERT INTO twi_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“Awurade bedi hene akosi daa.” ");
INSERT INTO twi_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Farao apɔnkɔ, nʼapɔnkɔkafo ne ne nteaseɛnam pɛɛ sɛ wɔfa po no mu; nanso Awurade buu nsu afasu no guu wɔn so bere a na Israelfo no nam mu sɛ asase wosee so. ");
INSERT INTO twi_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ɛhɔ na Odiyifobea Miriam a ɔyɛ Aaron nuabea faa akyene bi bɔ de dii mmea no anim ma wɔsawee. ");
INSERT INTO twi_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ɛnna Miriam too saa dwom yi: “Monto dwom mma Awurade na wadi nkonim anuonyam mu. Wama ɔpɔnkɔ ne ne sotefo amem po ase.” ");
INSERT INTO twi_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Afei, Mose dii Israelfo no anim ne wɔn tu fii Po Kɔkɔɔ no ho kɔɔ Sur sare so. Na wɔnantew sare no so nnansa a wɔannya nsu annom. ");
INSERT INTO twi_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Woduu Mara no, wɔantumi annom ɛhɔ nsu, efisɛ na ɛyɛ nwene. Ɛno nti na wɔfrɛ hɔ Mara no; ase ne: Nweenwen. ");
INSERT INTO twi_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Enti nnipa no nwiinwii tiaa Mose sɛ, “Dɛn na yɛnnom?” ");
INSERT INTO twi_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mose srɛɛ Awurade sɛ ɔmmoa wɔn, na Awurade kyerɛɛ no dubaa bi. Na ɔtow too nsu no mu, na ɛyɛɛ dɛ maa wotumi nomee. Mara hɔ na Awurade hyɛɛ saa mmara yi maa wɔn se, ");
INSERT INTO twi_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“Sɛ mubetie Awurade mo Nyankopɔn nne, na moayɛ osetie ayɛ ade trenee de a, ɔyare a mema ɛbɔɔ Misraimfo no, meremma bi mmɔ mo, efisɛ mene Awurade a mesa mo nyarewa.” ");
INSERT INTO twi_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Wɔbaa Elim a ɛhɔ na na mmura dumien ne mmedua aduɔson wɔ, nti wosisii wɔn ntamadan, tenaa mmura no ho. ");
INSERT INTO twi_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Afei, wotu fii Elim baa Sin sare a ɛda Elim ne Bepɔw Sinai ntam no so. Wotu fii Misraim no, ɔsram a ɛto so abien no nnaawɔtwe abien so na woduu hɔ. ");
INSERT INTO twi_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Woduu hɔ no nso, nnipa no kasa tiaa Mose ne Aaron se, ");
INSERT INTO twi_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“Sɛ yɛwɔ Misraim na anka Awurade rekunkum yɛn wɔ hɔ a, anka yɛpɛ. Na yenya nnuan bebree di wɔ hɔ. Nanso mode yɛn abegu sare so ha ama ɔkɔm rekum yɛn.” ");
INSERT INTO twi_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Na Awurade ka kyerɛɛ Mose se, “Merebɛtɔ aduan afi ɔsoro abegu asase so ama wɔn. Obiara betumi akɔboaboa dodow biara a ɔpɛ ano ama nea obedi no da koro. Mede eyi bɛsɔ wɔn ahwɛ sɛ wobedi mʼahyɛde so anaasɛ wɔrenni so. ");
INSERT INTO twi_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ka kyerɛ wɔn na nnaawɔtwe biara mu da a ɛto so asia no, wɔmmoaboa aduan no ano sɛnea daa wɔboaboa no no, mmɔho abien.” ");
INSERT INTO twi_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Enti Mose ne Aaron frɛɛ Israelfo no nyinaa ne wɔn hyia ka kyerɛɛ wɔn se, “Anwummere yi, mubehu sɛ Awurade na oyii mo fii Misraim asase so. ");
INSERT INTO twi_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Sɛ edu anɔpa a, mubehu nʼanuonyam bebree; efisɛ wate sɛnea munwiinwii tia no no. Na yɛn ne hena a munwiinwii tia yɛn? ");
INSERT INTO twi_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Anwummere yi, Awurade bɛma mo nam awe, na wama mo aduan anɔpa, efisɛ wate mo anwiinwii a etia no no. Moannwiinwii antia yɛn, na munwiinwii tiaa Awurade.” ");
INSERT INTO twi_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Na Mose ka kyerɛɛ Aaron se, “Ka kyerɛ Israelfo no nyinaa sɛ wɔmmra Awurade anim na wommetie wɔn anwiinwii no ho mmuae.” ");
INSERT INTO twi_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Enti Aaron frɛɛ wɔn boaa ano, na prɛko pɛ, wɔmaa wɔn ani so kyerɛɛ baabi a omununkum a ɛrekyerɛ wɔn kwan no wɔ no, Awurade fii mu daa nʼanuonyam kɛse no adi. ");
INSERT INTO twi_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Mate wɔn anwiinwii no, ka kyerɛ wɔn se, ‘Anwummere, mubenya nam awe na anɔpa nso mubenya aduan pii adi na mubehu sɛ mene Awurade, mo Nyankopɔn, no.’ ” ");
INSERT INTO twi_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Anwummere no, nnomaa pii bebuu so wɔ wɔn atenae hɔ na anɔpa no, obosu tɔ guu sare no so maa ɛyɛɛ fɔkyee. ");
INSERT INTO twi_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Obosu no yowee no, nsinsenii nketenkete bi a ɛte sɛ sukyerɛmma beguu asase no so. ");
INSERT INTO twi_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israelfo no hui no, wobisabisaa wɔn ho wɔn ho se, “Dɛn ni?” Na Mose buaa wɔn se, “Ɛyɛ aduan a Awurade de ama mo sɛ munni no. ");
INSERT INTO twi_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Awurade aka se, ‘Obiara mmoaboa dodow biara a ɛbɛso ɔne ne fifo di no ano.’” ");
INSERT INTO twi_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Enti Israelfo no fii adi kɔboaboaa aduan no bi ano. Ebinom faa pii na bi nso faa kakraa bi. ");
INSERT INTO twi_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Wohwiee nea wɔaboaboa ano no nyinaa guu susukoraa mu no, na ɛdɔɔso sɛ obiara benya bi. Wɔn a wonyaa pii no, ebi anka, na wɔn a wonyaa kakraa bi no nso, ɛsoo wɔn. Ofi biara nyaa ne so ne ne de. ");
INSERT INTO twi_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mose ka kyerɛɛ wɔn se, “Mommma ade nkye so.” ");
INSERT INTO twi_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Nanso ebinom yɛɛ asoɔden maa ade kyee so. Ade kyee so no, na adɔ nsaammoa ma ɛbɔn enti Mose bo fuw wɔn yiye. ");
INSERT INTO twi_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Afei na wɔkɔtase aduan no anɔpa anɔpa, na wɔtase dodow biara a, ɛso ofi biara. Na awia bɔɔ denneennen guu so no, aduan no nyinaa nanee. ");
INSERT INTO twi_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Da a ɛto so asia no, wɔtasee sɛnea wɔtase no daa no mmɔho abien. Wɔtasee susukoraa asia, nanso daa na wɔtase susukoraa abiɛsa. Mpanyimfo a wotuatua nnipa no ano no bebisaa Mose nea nti a aba saa. ");
INSERT INTO twi_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mose buaa wɔn se, “Efisɛ Awurade aka ato hɔ se, ‘Ɔkyena yɛ homeda. Ɛyɛ homeda kronkron ma Awurade a ɛnsɛ sɛ yɛyɛ yɛn nnwuma biara. Enti monnoa dodow biara a mopɛ nnɛ, na nea ɛbɛka no, munnyaw mma ade nkye so.’ ” ");
INSERT INTO twi_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Na ade kyee so no, na nsaammoa biara nni mu na ɛmmɔn nso. ");
INSERT INTO twi_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose kae se, “Nnɛ, mo aduan ni, efisɛ nnɛ yɛ Awurade homeda enti aduan biara rentɔ ngu asase so. ");
INSERT INTO twi_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Momfa nnansia mmoaboa aduan ano, efisɛ da a ɛto so ason no yɛ homeda enti morennya aduan biara saa da no.” ");
INSERT INTO twi_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Homeda no, nnipa no bi fii adi sɛ wɔrekɔpɛ aduan no bi, nanso na ebi nni hɔ. ");
INSERT INTO twi_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Awurade bisaa Mose se, “Saa nnipa yi bɛyɛ asoɔden akosi da bɛn? ");
INSERT INTO twi_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Wonhu sɛ nnansia so no, memaa wɔn mmɔho abien sɛnea ɛbɛso wɔn nnaanu? Awurade se momfa da a ɛto so ason no sɛ homeda; montena mo ntamadan mu. Mummfi adi nkɔtase aduan mfi asase so.” ");
INSERT INTO twi_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Enti da a ɛto so ason no, nnipa no homee. ");
INSERT INTO twi_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israelfo no too aduan no din se Mana, ase ne “Ɛyɛ dɛn?” Ɛyɛ fitaa sɛ wusa aba na ɛyɛ dɛ te sɛ tetare a ɛwo wɔ mu. ");
INSERT INTO twi_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mose kaa asɛm a Awurade ka kyerɛɛ no sɛ ɔnka nkyerɛ wɔn sɛ wɔmfa aduan no susukoraa abiɛsa na wɔmfa nkosie wɔn adekorabea afebɔɔ sɛnea ɛbɛyɛ a, nkyirimma behu aduan a Awurade de maa wɔn dii wɔ sare so bere a oyii wɔn fii Misraim no. ");
INSERT INTO twi_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mose ka kyerɛɛ Aaron se ɔmfa kuruwa na ɔmfa mana lita abiɛsa ngu mu na ɔmfa nsie kronkronbea bi mma nkyirimma. ");
INSERT INTO twi_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aaron yɛɛ sɛnea Awurade kyerɛɛ Mose sɛ ɔnyɛ no na ɔnkora no wɔ Apam Adaka no mu wɔ kronkronbea hɔ. ");
INSERT INTO twi_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Enti Israelfo dii mana yi mfe aduanan kosii sɛ woduu Kanaan asase so a ɛhɔ de, na afumduan wɔ no. ");
INSERT INTO twi_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Lita abiɛsa yɛ omer baako. ");
INSERT INTO twi_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Awurade hyɛe maa Israelfo no fii Sin sare no so kokɔɔ nkurow nkurow so, koduu Refidim. Woduu hɔ no, na nsu a wɔbɛnom biara nni hɔ. ");
INSERT INTO twi_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ɛha nso nnipa no nwiinwii bio tiaa Mose sɛ, “Ma yɛn nsu nnom!” Mose ka kyerɛɛ wɔn se, “Monyɛ dinn! Adɛn nti na mo ne me regye akyinnye? Adɛn nti na mopɛ sɛ mosɔ Awurade hwɛ?” ");
INSERT INTO twi_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Na osukɔm a ɛde wɔn no nti, wɔteɛteɛɛ mu se, “Adɛn nti na wuyii yɛn fii Misraim? Adɛn nti na wode yɛn baa ha? Yɛn, yɛn mma ne yɛn anantwi nyinaa bewuwu!” ");
INSERT INTO twi_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mose su frɛɛ Awurade se, “Dɛn na menyɛ saa nkurɔfo yi? Wɔpɛ sɛ wosiw me abo.” ");
INSERT INTO twi_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Awurade ka kyerɛɛ Mose se, “Fa Israelfo mpanyimfo no bi ka wo ho na fa pema a wode bɔɔ Nil mu no na di wɔn anim fa wɔn kɔ. ");
INSERT INTO twi_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mehyia wo wɔ ɔbotan a ɛwɔ bepɔw Horeb ho. Sɛ wudu hɔ a, fa wo pema no bɔ ɔbotan no mu sɛnea wode bɔɔ Nil mu no na nsu befi mu aba ama obiara anya bi anom amee.” Mose yɛɛ nea Awurade kae no wɔ Israel mpanyimfo no anim maa nsu tue fii ɔbotan no mu. ");
INSERT INTO twi_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Enti Mose too beae hɔ din Masa a ase ne Sɔhwɛbea ne Meriba a ase ne Akyinnyegyebea, efisɛ ɛhɔ na Israelfo ne Mose gyee akyinnye, sɔɔ Onyankopɔn hwɛe, bisae se, “Awurade ka yɛn ho anaa ɔnka yɛn ho?” ");
INSERT INTO twi_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Afei, akofo a wofi Amalek bɛtow hyɛɛ Israelfo no so wɔ Refidim ne wɔn koe. ");
INSERT INTO twi_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mose ka kyerɛɛ Yosua se, “Yi asraafo ma yɛn na yɛne Amalekfo no nkɔko. Ɔkyena megyina bepɔw no apampam a mikura Onyankopɔn pema no.” ");
INSERT INTO twi_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Enti Yosua ne ne dɔm kɔtoaa Amalekfo asraafo no ne wɔn koe sɛnea na Mose ahyɛ no, na Mose ne Aaron ne Hur foro kɔɔ bepɔw no apampam pɛɛ. ");
INSERT INTO twi_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mmere dodow a Mose kura pema no mu kyerɛ soro na Israelfo no redi nkonim na sɛ ɔbrɛ pema no ase a, na Amalekfo no nso redi Israelfo no so. ");
INSERT INTO twi_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mose brɛ a na ontumi mma pema no so bio enti Aaron ne Hur pirew ɔbo bi too hɔ ma ɔtenaa so. Wogyinagyinaa Mose benkum ne nifa memaa ne nsa abien no so kosii sɛ owia kɔtɔe. ");
INSERT INTO twi_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ɛbaa saa no, Yosua ne ne dɔm dii Amalekfo no so, kunkum wɔn wɔ afoa ano. ");
INSERT INTO twi_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Afei, Awurade ka kyerɛɛ Mose se, “Kyerɛw eyi ma ɛnna hɔ afebɔɔ ma wɔnkae daa na ka kyerɛ Yosua se, mɛtɔre Amalekfo nyinaa ase wɔ ɔsoro ase.” ");
INSERT INTO twi_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mose sii afɔremuka hɔ na ɔtoo no din Awurade Nissi a ase ne Awurade ne me frankaa. ");
INSERT INTO twi_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Mose kae se, “Efisɛ wɔama wɔn nsa so atia Awurade ahengua nti, Awurade ne Amalekfo bedi ako afi awo ntoatoaso so akosi awo ntoatoaso so.” ");
INSERT INTO twi_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ankyɛ biara na Mose ase, Midian sɔfo Yetro, tee anwonwade a Onyankopɔn ayɛ ama ne nkurɔfo Israelfo ne Mose, ne sɛnea wayi wɔn afi Misraim asase so no. ");
INSERT INTO twi_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mose de ne yere Sipora kɔe no, nʼase Yetro gyee no ");
INSERT INTO twi_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","a na ne mmabarima baanu ka ne ho. Mose too ne babarima a na ɔyɛ nʼabakan no din Gersom a ɔkyerɛ ase se, “Mabɛyɛ ɔhɔho wɔ ananafo asase so.” ");
INSERT INTO twi_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Na ne babarima a ɔto so abien no nso, ɔtoo ne din Elieser a ɔkyerɛ ase se “Mʼagyanom Nyankopɔn no yɛ me boafo. Ogyee me fii Farao afoa ano.” ");
INSERT INTO twi_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yetro kɔsraa Mose. Ɔde Mose yere ne ne mmabarima baanu no kaa ne ho. Wodui no, na Mose ne nnipa no abɔ atenae wɔ Onyankopɔn bepɔw no ho. ");
INSERT INTO twi_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Wɔka kyerɛɛ Mose se, “Wʼase Yetro reba abɛsra wo. Wo yere ne wo mmabarima baanu no ka ne ho.” ");
INSERT INTO twi_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mose sɔre kohyiaa nʼase. Ɔkotow no nidi mu gyee no fɛw so. Wokyiakyiaa wɔn ho wɔn ho na wɔkɔɔ Mose ntamadan mu. ");
INSERT INTO twi_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mose kaa nsɛm a asisi nyinaa kyerɛɛ nʼase no. Ɔkaa nea Awurade ayɛ atia Farao ne Misraimfo a ɔnam so agye Israelfo, ayi wɔn afi Misraim, asan ayi wɔn afi ɔhaw ne abɛbrɛsɛ mu no nso kyerɛɛ no. ");
INSERT INTO twi_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetro tee nea Awurade ayɛ ama Israel, ne titiriw no, sɛnea oyii wɔn fii Misraim no, nʼani gyee yiye. ");
INSERT INTO twi_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetro kae se, “Nhyira nka Awurade sɛ wagye mo afi Misraimfo ne Farao nsam, na wagye ɔman Israel nso. ");
INSERT INTO twi_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Afei, mahu sɛ Awurade yɛ ɔkɛse sen onyame foforo biara, efisɛ wayɛ eyi ama wɔn a wɔde ahantan di wɔn so no.” ");
INSERT INTO twi_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Yetro de ɔhyew afɔrebɔde bae, na ɔbɔɔ afɔre maa Onyankopɔn. Akyiri no, Aaron ne Israel mpanyimfo no baa Yetro nkyɛn. Wɔn nyinaa too nsa dii afɔreguan no wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ade kyee no, Mose tenaa ase fii anɔpa kosii anwummere tiee ntawntaw a asisi wɔ nnipa no mu. ");
INSERT INTO twi_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mose ase no huu brɛ a ɔrebrɛ nnipa no ho no, obisaa no se, “Adɛn nti na wopɛ sɛ wo nko ara wudi dwuma kɛse yi a enti nnipa gyina wo so saa ara fi anɔpa kosi anwummere yi?” ");
INSERT INTO twi_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose buae se, “Nnipa no de akasakasa bi a asisi wɔn ntam bɛtoo mʼanim sɛ mimmisa Onyankopɔn hɔ akwankyerɛ. ");
INSERT INTO twi_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Sɛ ntawntaw bi ba wɔn ntam a, wɔba ma misiesie. Mekyerɛ wɔn Onyankopɔn mmara ne nʼapɛde.” ");
INSERT INTO twi_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Nʼase no kae se, “Nea woreyɛ no nye. ");
INSERT INTO twi_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Worekum wo ho na sɛ wuwu a, nnipa yi bɛyɛ dɛn? Mose, adwuma yi so dodo sɛ wo nko ara wobɛyɛ. ");
INSERT INTO twi_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Tie fo a merebetu wo yi na Onyankopɔn behyira wo. Kɔ so ara si nnipa no anan wɔ Onyankopɔn anim na fa wɔn haw to nʼanim. ");
INSERT INTO twi_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kyerɛ wɔn Onyankopɔn akwan a wɔmfa so ntena ase. ");
INSERT INTO twi_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Na hwehwɛ nnipa bi a wɔyɛ nyamesurofo na wɔyɛ nokwafo a wɔmpɛ adanmudegye, na wɔn mu baako biara nyɛ nnipa apem so otemmufo. Ɛsɛ sɛ saa onipa no nya atemmufo du hyɛ nʼase na wɔn mu baako biara ahwɛ nnipa ɔha so. Na wɔn ase no, wobeyi atemmufo baanu a wɔbɛhwɛ nnipa aduonum so, na wɔn nso, atemmufo baanum bɛhyɛ wɔn mu biara ase na wɔatu nnipa du fo. ");
INSERT INTO twi_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ma saa nnipa yi nni wɔn ho ni na wonni nokware daa. Asɛm biara a ɛho hia anaa ɛkyere adwene no, wɔmfa mmra wʼanim. Wɔn ankasa nhwɛ nka nsɛm nketenkete a ɛbɛba wɔn anim no. Sɛ wofa saa kwan yi so a, adwuma no bɛyɛ mmerɛw ama wo, efisɛ woakyekyɛ nnwuma no ama wɔn. ");
INSERT INTO twi_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Sɛ wutie afotu no na Onyankopɔn nso pene so a, wubetumi agyina asɛm biara ano na asomdwoe aba.” ");
INSERT INTO twi_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose tiee nʼase afotu no dii so pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Oyiyii nnipa pa a wɔwɔ Israelman mu nyinaa de wɔn yɛɛ atemmufo—apem apem, ɔha ɔha, aduonum aduonum ne du du. ");
INSERT INTO twi_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Na wobuu ɔman no atɛn bere nyinaa mu. Wɔde nsɛm akɛse no maa Mose na wɔn nso dii nsɛm nketenkete no. ");
INSERT INTO twi_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Akyiri no, Mose gyaa nʼase kwan ma ɔkɔɔ ne kurom. ");
INSERT INTO twi_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Anadwo a Israelfo no tu fii Misraim no, nʼasram abiɛsa so na wɔde koduu Sinai sare so. ");
INSERT INTO twi_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Wotu fii Refidim no, wokoduu Sinai sare so na wɔbɔɔ atenase wɔ Sinai Bepɔw no ase. ");
INSERT INTO twi_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mose foro kɔɔ Onyankopɔn nkyɛn na Awurade frɛɛ no fii bepɔw no so kae se, “Ka saa nsɛm yi kyerɛ Yakob asefo Israelman se, ");
INSERT INTO twi_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Moahu nea meyɛɛ Misraimfo no ne ɔkwan a mefaa so soaa mo wɔ ɔkɔre ntaban so de mo baa me nkyɛn no. ");
INSERT INTO twi_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Sɛ mubetie me, na moadi mʼahyɛde so a, mobɛyɛ me nguankuw ketewa wɔ asase so aman nyinaa mu, efisɛ asase nyinaa yɛ me dea. ");
INSERT INTO twi_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Na mobɛyɛ asɔfo ahemman a ɛyɛ ɔman kronkron ama Onyankopɔn.’ Saa nsɛm yi na ka kyerɛ Israelfo no.” ");
INSERT INTO twi_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mose sian fii bepɔw no so bae no, ɔfrɛɛ mpanyimfo a wotuatua nnipa no ano nyinaa na ɔkaa asɛm a Awurade ahyɛ no sɛ ɔnka no kyerɛɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Wɔtee asɛm no, wɔn nyinaa bɔ gyee so se, “Yɛbɛyɛ biribiara a Awurade aka sɛ yɛnyɛ no nyinaa.” Enti Mose kɔkaa nsɛm a nnipa no aka no kyerɛɛ Awurade. ");
INSERT INTO twi_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Awurade ka kyerɛɛ Mose se, “Merebɛba wo nkyɛn sɛ omununkum sɛnea ɛbɛyɛ na me ne wo kasa a, nnipa no bɛte me nne na ɛnam so ama wɔagye wo adi daa.” ");
INSERT INTO twi_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Na Awurade ka kyerɛɛ Mose se, “Sian kɔ nnipa no nkyɛn na kɔtew wɔn ho nnɛ ne ɔkyena. Ma wɔnhoro wɔn nneɛma nyinaa, ");
INSERT INTO twi_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","na siesie wo ho ma ɔkyena akyi efisɛ saa da no mesian aba Sinai Bepɔw no so a ɔmanfo nyinaa ani tua me. ");
INSERT INTO twi_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Twitwa ahye sɛnea nnipa no rentra na ka kyerɛ wɔn se, ‘Monhwɛ yiye. Mommforo nkɔ bepɔw no atifi na monnkɔ nʼahye no nso so; obiara a obebu saa mmara yi so no, obewu. ");
INSERT INTO twi_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Sɛ ɔyɛ onipa anaa aboa a, obiara nso ne mu. Na mmom, wobesiw no abo anaasɛ wɔbɛtotow agyan awowɔ no ama wawu.’ Montwe mo ho mfi bepɔw no ho koraa kosi sɛ torobɛnto bi bɛhyɛn denneennen ansa na moaforo akɔ bepɔw no so.” ");
INSERT INTO twi_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mose sian fii bepɔw no so kɔɔ nnipa no nkyɛn kɔtew wɔn ho ma wɔhoroo wɔn nneɛma nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ɔka kyerɛɛ wɔn se, “Munsiesie mo ho, na aka nnansa na Onyankopɔn aba, enti obiara nnkɔ ɔbea ho.” ");
INSERT INTO twi_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Nnansa so anɔpa pɛpɛɛpɛ, aprannaa a ano yɛ den bobɔɔ mu, maa anyinam pepae, maa omununkum kabii bi sian fii bepɔw no so. Torobɛnto bi hyɛn twee mu maa nnipa a wɔwɔ hɔ no nyinaa ho popoe. ");
INSERT INTO twi_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mose dii nnipa no anim fi wɔn atenae hɔ sɛ wɔrekohyia Onyankopɔn. Wɔn nyinaa kɔboaa wɔn ho ano wɔ bepɔw no ase. ");
INSERT INTO twi_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Wusiw kumɔnn kataa Sinai Bepɔw no so, efisɛ Awurade sian baa so sɛ ogya. Wusiw buaa wim nyinaa te sɛ nea efi fononoo mu, na asasewosow wosoo bepɔw no denneennen. ");
INSERT INTO twi_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Torobɛnto no hyɛn denneennen pa ara no, Mose kasae na Onyankopɔn nso de nne kɛse buae. ");
INSERT INTO twi_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Enti Awurade baa Sinai Bepɔw no atifi, na ɔfrɛɛ Mose ma ɔforo kɔɔ ne nkyɛn ");
INSERT INTO twi_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","na Awurade ka kyerɛɛ Mose se, “San kɔ nnipa no nkyɛn na kɔbɔ wɔn kɔkɔ sɛ wɔnntra ahye no. Wɔnnyɛ wɔn adwene nso sɛ wɔreforo aba soro ha abɛhwɛ Awurade. Wɔn a wɔbɛyɛ saa no bewuwu. ");
INSERT INTO twi_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Asɔfo a wɔwɔ wɔn nnwuma so no mpo nnwira wɔn ho, anyɛ saa a, Awurade bɛsɛe wɔn.” ");
INSERT INTO twi_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose nso buaa no se, “Nnipa no de, wɔremforo mma bepɔw no atifi, efisɛ wʼankasa bɔɔ wɔn kɔkɔ se, ‘Twitwa ahye fa bepɔw no ho na gyaw hɔ sɛ kronkronbea.’ ” ");
INSERT INTO twi_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Awurade ka kyerɛɛ Mose se, “Sian kɔ fam na kɔfa Aaron bra. Mma asɔfo no ne nnipa no ntra ahye no sɛ wɔreba ha. Wɔyɛ saa a, mɛsɛe wɔn.” ");
INSERT INTO twi_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Enti Mose sian kɔɔ nnipa no nkyɛn kɔka kyerɛɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Na Onyankopɔn kaa nsɛm yi yi nyinaa: ");
INSERT INTO twi_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Mene Awurade, mo Nyankopɔn, a miyii mo fii nkoasom mu wɔ Misraim no. ");
INSERT INTO twi_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Monnsom onyame foforo biara nka me ho. ");
INSERT INTO twi_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Monnyɛ ohoni anaa biribiara a ɛsɛ ade a ɛwɔ wim, anaa nea ɛwɔ asase so, anaa nea ɛwɔ nsu mu, anaa nea ɛwɔ asase ase. ");
INSERT INTO twi_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Monnkotow ohoni biara nsom no wɔ ɔkwan biara so, na me, Awurade, mo Nyankopɔn, meyɛ ninkufo a metwe mma a wɔtan me no aso wɔ awofonom bɔne a wɔyɛ no ho kɔ awo ntoatoaso abiɛsa ne anan mu, ");
INSERT INTO twi_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","nanso meda ɔdɔ adi kyerɛ awo ntoatoaso mpem a wɔdɔ me na wodi mʼahyɛde so no. ");
INSERT INTO twi_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Mommmɔ Awurade, mo Nyankopɔn no, din basabasa. Sɛ moyɛ saa a, obebu mo fɔ. ");
INSERT INTO twi_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Monkae homeda na munni no sɛ da kronkron. ");
INSERT INTO twi_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Nnansia na momfa nyɛ mo nnwuma nyinaa, ");
INSERT INTO twi_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","na da a ɛto so ason no yɛ homeda ma Awurade, mo Nyankopɔn. Saa da no, ɛnsɛ sɛ moyɛ adwuma biara; ɛnsɛ sɛ mo mmabarima, mo mmabea anaa mo asomfo anaa mo anantwi anaa mo ahɔho yɛ adwuma biara. ");
INSERT INTO twi_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Efisɛ Awurade de nnansia na ɛbɔɔ ɔsoro, asase ne po ne biribiara a ɛwɔ ne nyinaa mu, na ɔhomee ne nnanson so; enti ohyiraa homeda no so sɛ wɔmfa nhome. ");
INSERT INTO twi_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Di wʼagya ne wo na ni na wo nna aware wɔ asase a Awurade, wo Nyankopɔn, de rema wo no so. ");
INSERT INTO twi_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Nni awu. ");
INSERT INTO twi_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Nsɛe aware. ");
INSERT INTO twi_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Mmɔ korɔn. ");
INSERT INTO twi_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Nni adansekurum. ");
INSERT INTO twi_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Mma wʼani mmere wo yɔnko fi anaa ne yere anaa nʼasomfo anaa nʼanantwi anaa ne mfurum anaa biribiara a ɛyɛ ne de.” ");
INSERT INTO twi_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nnipa no nyinaa huu anyinam ne wusiw kumɔnn wɔ bepɔw no so. Wɔtee aprannaa ne torobɛnto nne a ɛyɛ hu a ɛrebɔ denneennen. Enti wɔtew gyinae a ehu ama wɔn ho rewosow. ");
INSERT INTO twi_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Wɔka kyerɛɛ Mose se, “Ka asɛm biara a Onyankopɔn aka akyerɛ wo sɛ ka kyerɛ yɛn, na yebetie. Na mma Onyankopɔn ankasa nkasa nkyerɛ yɛn na yɛanwuwu.” ");
INSERT INTO twi_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mose nso ka kyerɛɛ wɔn se, “Munnsuro na Onyankopɔn pɛ sɛ ɔda ne tumi adi kyerɛ mo sɛnea ɛbɛyɛ a, efi nnɛ rekɔ no, mubesuro sɛ mobɛyɛ bɔne atia no.” ");
INSERT INTO twi_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Nanso, nnipa no tew wɔn ho gyinaa akyirikyiri baabi. Mose de, owuraa sum kabii no mu kɔɔ faako a Onyankopɔn wɔ hɔ no. ");
INSERT INTO twi_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Awurade ka kyerɛɛ Mose se, “Ka saa asɛm yi kyerɛ Israelfo no. ‘Mudi ho adanse sɛ, mifi ɔsoro ada me pɛ adi akyerɛ mo. ");
INSERT INTO twi_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Monkae sɛ ɛnsɛ sɛ moyɛ anaa mosom ahoni a wɔde sika anaa dwetɛ anaa biribi foforo ayɛ. ");
INSERT INTO twi_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Dɔte afɔremuka na monyɛ mma me. Ɛso na mommɔ mo afɔre mma me. Mo ɔhyew afɔre ne asomdwoe afɔre a mode nguan ne anantwi bɔ no nyinaa mommɔ mma me. Faako a mɛkyerɛ mo sɛ munsi afɔremuka no na munsi na mɛba hɔ abehyira mo. ");
INSERT INTO twi_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Mutumi de abo nso si afɔremuka, nanso abo a wontwae na momfa nsi. Sɛ mode afiri bi twa abo no di no adwinni a, enye sɛ wɔde si, efisɛ moagu ho fi. ");
INSERT INTO twi_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Monnyɛ atrapoe mma afɔremuka no anyɛ saa a, obi bɛhwɛ mo ntade ase ahu mo adagyaw mu.’ ");
INSERT INTO twi_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Mmara a ɛsɛ sɛ woka kyerɛ wɔn no ni: ");
INSERT INTO twi_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Sɛ wotɔ akoa a ɔyɛ Hebrini a, ma no nsom wo mfe asia, na afe a ɛto so ason no, ɔmfa ne ho nni a ontua hwee. ");
INSERT INTO twi_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Sɛ ɔbɛyɛɛ wʼakoa no na ɔyɛ osigyani na sɛ akyiri no ɔware a, ɔno nko ara na sɛ mfe ason no du a ɔbɛkɔ. Na sɛ nso na waware ansa na ɔrebɛyɛ akoa de a, ɔne ne yere no na wɔbɛkɔ. ");
INSERT INTO twi_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Sɛ nso ne wura no na ɔmaa no ɔbea waree wɔ ne nkoasom no mu, na sɛ wɔwo mmabarima ne mmabea a, ɔyere ne mma no bɛyɛ owura no de, na okunu no akɔ ne baabi. ");
INSERT INTO twi_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Na sɛ ɔbarima no pae mu ka se, ‘Mepɛ me wura ne me yere ne me mma asɛm nti merenkɔ’ a, ");
INSERT INTO twi_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ne wura no de no bɛba atemmufo anim na wɔde fitii afiti nʼasom bagua mu na watena ne wura no nkyɛn sɛ akoa afebɔɔ. ");
INSERT INTO twi_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Sɛ ɔbarima bi tɔn ne babea sɛ afenaa a, mfe asia no du a, wɔrennyaa no sɛnea wogyaa mmarima nkoa no. ");
INSERT INTO twi_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Sɛ ne som no nsɔ onipa a ɔtɔɔ no no ani a, onipa ko a ɔtɔn no no wɔ ho kwan sɛ ɔsan tɔ no bio. Nanso afenaa no wura no nni ho kwan sɛ ɔtɔn no ma ɔnanani biara, efisɛ sɛ ɔyɛ saa a, na wabu ɔtɔn no ho nhyehyɛe so. ");
INSERT INTO twi_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Na sɛ afenaa wura no de afenaa no ma ne babarima aware a, afenaa no bɛyɛ owura no babea. ");
INSERT INTO twi_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Sɛ ɔno ara ankasa ware no na ɔsan ware foforo a, ɛnsɛ sɛ ɔtew nʼaduan ne ntama a ɔde ma no no so; na ɛnsɛ sɛ ɔkame no nna sɛ ɔyere. ");
INSERT INTO twi_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Na sɛ wantumi anni saa ahyɛde abiɛsa yi so a, afenaa a ɔyɛ ɔyere no tumi kɔ kwa a ontua sika biara.” ");
INSERT INTO twi_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Obiara a ɔbɛbɔ obi akum no no, wobekum no bi. ");
INSERT INTO twi_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Sɛ ɛyɛ asiane a ɛyɛ Onyankopɔn nhyehyɛe a wanhyɛ da a, mɛkyerɛ onii no baabi a onguan nkohintaw. ");
INSERT INTO twi_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Sɛ obi hyɛ da taataa ɔfoforo so pɛ sɛ okum no a, onii no gyina afɔremuka anim koraa a, montwe no nkokum no. ");
INSERT INTO twi_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Nea ɔbɔ nʼagya anaa ne na no, kum na ɛsɛ sɛ wokum no. ");
INSERT INTO twi_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Obi a owia onipa no, sɛ wɔkyere no sɛ saa onipa no wɔ ne nsam anaasɛ watɔn no a, wonkum no. ");
INSERT INTO twi_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Nea ɔdome nʼagya anaa ne na no, kum na ɛsɛ sɛ wokum no. ");
INSERT INTO twi_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Sɛ mmarima baanu reko na wɔn mu baako de ɔbo anaa kuturuku bɔ ɔbaako no pira no, na wanwu, nanso ɛka no to mpa so, ");
INSERT INTO twi_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","na akyiri no, otumi sɔre nantew na mpo sɛ ɔtɔ ne nan so a, ɔbarima a ɔbɔɔ ne yɔnko no di bem, nanso ɔbaako no bere a wasɛe no no, obetua ho sika ama no, asan atua nʼayaresa ka nyinaa kosi sɛ ne ho bɛtɔ no. ");
INSERT INTO twi_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Sɛ obi hwe nʼakoa anaa nʼafenaa ma no wu a, ɛsɛ sɛ wɔtwe nʼaso. ");
INSERT INTO twi_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Nanso sɛ nna bi akyi no akoa no anwu a, ɛno de, owura no renkɔ asotwe biara mu, efisɛ akoa no yɛ nʼagyapade. ");
INSERT INTO twi_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Sɛ mmarima baanu reko na ɔko no mu wopira ɔpemfo ma ɔpɔn, nanso wanwu a, wɔbɛbɔ ɔbarima a opiraa no no ka biara a ɔpemfo no kunu de bɛto atemmufo anim ama wɔapene so no. ");
INSERT INTO twi_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Na sɛ opira no ma ɔbea no wu a, wonkum saa ɔbarima no. ");
INSERT INTO twi_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Sɛ ɔpemfo no pira nʼani a, pira ɔbarima no nso ani; sɛ ne se tu a, tu ne de bi. Nsa nsi nsa anan, nan nsi nan anan, ");
INSERT INTO twi_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ɔhyew nsi ɔhyew anan, apirakuru nsi apirakuru anan na atape nsi atape anan. ");
INSERT INTO twi_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Sɛ owura bi bɔ nʼakoa anaa nʼafenaa ani so ma nʼani bɔ a, esiane nʼani no nti, ɛsɛ sɛ akoa anaa afenaa no de ne ho hyɛ anan. ");
INSERT INTO twi_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Sɛ owura tu nʼakoa se a, ne se no nti, ɔmma ɔnne ne ho mfa nhyɛ anan. ");
INSERT INTO twi_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Sɛ nantwi si ɔbea anaa ɔbarima ma no wu a, wonsiw nantwi no abo. Wɔnnwe ne nam no. Ne wura no nso, obiara mmfa ne nsa nka no, ");
INSERT INTO twi_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","gye sɛ wɔate sɛ mmere bi a atwa mu no, nantwi no sisii nnipa ma wɔbɔɔ ne wura no amanneɛ a wanka ho hwee; sɛ ɛba saa na sɛ okum obi a, wonsiw nantwi no abo na ne wura no nso, wonkum no. ");
INSERT INTO twi_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Sɛ nso owufo no abusuafo pɛ a, wɔbɛbɔ nantwi wura no ka. Atemmufo na wɔbɛkyerɛ nea ontua. ");
INSERT INTO twi_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Mmara koro no ara kyere nantwi a obesi abarimaa anaa ɔbea. ");
INSERT INTO twi_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Na sɛ nantwi no si akoa anaa afenaa a, wɔbɛma akoa anaa afenaa no wura dwetɛ gram ahaasa ne aduanan (342) abien, na wɔasiw nantwi no abo. ");
INSERT INTO twi_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Sɛ ɔbarima bi tu abura, na wankata so, na nantwi anaa afurum kɔtɔ mu a, ");
INSERT INTO twi_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ka biara a aboa no wura bɛbɔ abura no wura no, ɛsɛ sɛ abura wura no tua na ɔfa aboa a wawu no. ");
INSERT INTO twi_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Sɛ ɔbarima bi nantwi pira nantwi foforo na sɛ owu a, mmoa wuranom baanu no bɛtɔn aboa a onwui no na wɔakyɛ sika no mu. Wɔn mu biara nso bɛfa aboa a wawu no fa. ");
INSERT INTO twi_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Na sɛ aboa no taa sisi na ne wura no abu nʼani agu so de a, ɛno de, sikakyɛ biara remma; na mmom, ɔbarima a ne nantwi wɔ hɔ no betua nantwi a wawu no ho ka nyinaa na wafa no. ");
INSERT INTO twi_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Sɛ obi kowia nantwi anaa oguan na okum no anaa ɔtɔn no a, ɔde anantwi anum besi nantwi baako anan mu. Na ɔde nguan anan asi oguan baako biara anan mu. ");
INSERT INTO twi_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Sɛ wohu ɔkorɔmfo sɛ ɔrewura ofi bi mu anadwo na wokum no a, nea okum no no nni fɔ. ");
INSERT INTO twi_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Na sɛ asɛm no si awia de a, wɔmfa no sɛ ɛyɛ awudi enti onipa a okum ɔkorɔmfo no di fɔ. “Sɛ mokyere ɔkorɔmfo bi a, momma ontua nneɛma a wawia no nyinaa ho ka na sɛ wantumi antua a, montɔn no sɛ akoa mfa no ntua ka no. ");
INSERT INTO twi_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Sɛ mokyere no sɛ ɔrewia nantwi anaa afurum anaa oguan a onwui anaa biribi foforo bi a, mommɔ no dekode a owiae no ho ka mpemanim. ");
INSERT INTO twi_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Sɛ obi hyɛ da gyaa nʼaboa ma ɔkɔ obi afum kodidi wɔ hɔ, sɛe nnɔbae a, ɔmfa ɔno ara ne nnɔbae mu nea ɛsɔ ani pa ara no mmetua ka. ");
INSERT INTO twi_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Sɛ obi rehyew nʼafuw, na ogya no tra kɔtɔ ɔfoforo afuw mu, hyew, sɛe ne nnɔbae a, nea ɔsɔɔ gya no betua nnɔbae a asɛe no nyinaa ho ka. ");
INSERT INTO twi_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Sɛ obi ma ɔfoforo sika anaa ade foforo bi sɛ ɔmfa nsie mma no na wowia na sɛ wɔkyere ɔkorɔmfo no a, obetua ne mpemanim. ");
INSERT INTO twi_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Na sɛ wɔankyere ɔkorɔmfo no a, wɔde onipa a wɔde agyapade no hyɛɛ ne nsa no bɛba Onyankopɔn anim abɛhwehwɛ sɛ ɔno ankasa na owiaa ne yɔnko no anaasɛ ɛnyɛ ɔno. ");
INSERT INTO twi_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Sɛ ɛba sɛ nantwi, afurum, oguan, ntama anaa biribi foforo bi yera na nea nʼade ayera no de nʼani kari obi sɛ ɔno na wafa dekode no, na onii no san se ɛnyɛ ɔno na wafa a, ɛsɛ sɛ wɔde nnipa baanu no nyinaa ba Onyankopɔn anim ma ɔhwehwɛ mu. Ɔhwehwɛ mu na nea obedi fɔ no, obetua ade a ɛyerae no ho ka mmɔho abien ama ɔbaako no. ");
INSERT INTO twi_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Sɛ obi de afurum, nantwi, oguan anaa aboa foforo bi ma ne yɔnko bi ayɛn na aboa no wu anaa opira anaa oguan na sɛ obi anhu ammɛka a, ");
INSERT INTO twi_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ɛsɛ sɛ nea ogyee aboa no ayɛn no ka ntam sɛ ɛnyɛ ɔno na wawia aboa no, na ne wura no gye to mu a, onnye biribiara nsi anan mu. ");
INSERT INTO twi_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Nanso sɛ wia na wowiaa aboa no anaa dekode no wɔ ne nkyɛn de a, na ɛsɛ sɛ sohwɛfo a wowiaa aboa no anaa dekode no fii ne nkyɛn no tua ne wura no ka. ");
INSERT INTO twi_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Sɛ akekaboa na okum no a, ɛsɛ sɛ ɔde aboa no funu ba bɛkyerɛ. Ɔyɛ no saa a, ɔrentua ho ka biara. ");
INSERT INTO twi_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Sɛ obi fɛm aboa bi anaa biribi foforo bi fi ne yɔnko nkyɛn na sɛ aboa no wu anaa opira, bere a ne wura no nni hɔ a, ɛsɛ sɛ onipa a ɔfɛm saa aboa no tua ka. ");
INSERT INTO twi_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Na sɛ ne wura no wɔ hɔ de a, ɛnsɛ sɛ ɔfɛmfo no tua ka, efisɛ wobuu eyi nyinaa fraa ɔfɛm no ho akatua mu. ");
INSERT INTO twi_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Sɛ ɔbarima bi kɔdaadaa ɔbea bi a ɔnyɛɛ ne ho ade na ɔne no da a, ɛsɛ sɛ ɔyɛ ne ho ade na ɔware no. ");
INSERT INTO twi_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Sɛ ɔbea no agya se ɔmpene aware no so a, ɛsɛ sɛ ɔbarima no tua ne ti sika. ");
INSERT INTO twi_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Munkum mmea nkonyaayifo. ");
INSERT INTO twi_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Ɔbarima biara a ɔbɛfa aboa bi no, wonkum no. ");
INSERT INTO twi_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Obiara a obefi Awurade akyi abɔ onyame foforo bi afɔre no, wonkum no. ");
INSERT INTO twi_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Monnyɛ ɔhɔho ayayade, efisɛ na mo nso moyɛ ahɔho wɔ Misraim. ");
INSERT INTO twi_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Munnsisi akunafo anaa ayisaa; ");
INSERT INTO twi_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","na sɛ moyɛ saa na wosu frɛ me a, megye wɔn so. ");
INSERT INTO twi_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Mede mʼabufuw betia mo na mama atamfo dɔm akum mo na mo yerenom nso adan akunafo ama mo mma nso ayɛ ayisaa bi. ");
INSERT INTO twi_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Sɛ wobɔ wo yɔnko Hebrini bosea a, nnye ho mfɛntom biara. ");
INSERT INTO twi_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Sɛ wugye ne ntama de si awowa a, anadwo no ara, fa nʼade kɔma no. ");
INSERT INTO twi_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Efisɛ ebia na ntama a ɔwɔ de kata ne ho de ka ne ho hyew ara ne no; woagye yi, ɛbɛyɛ dɛn na watumi ada? Sɛ woamfa ankɔma no na sɛ osu frɛ me a, metie na mahu no mmɔbɔ, efisɛ meyɛ mmɔborɔhunufo. ");
INSERT INTO twi_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Monnkasa ntia Onyankopɔn na monnome aban mu mpanyimfo anaa mo atemmufo anaa wɔn a wodi mo so. ");
INSERT INTO twi_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Momfa mo nnɔbae mu nkyɛmu du mu baako mmrɛ me ntɛm so. “Saa ara nso na muntua mo mmakan mmarima nkwagye ho ka no. ");
INSERT INTO twi_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ma wo nantwi anaa wo guan abakan no ne ne na ntena nnanson, na da a ɛto so awotwe no, fa no brɛ me. ");
INSERT INTO twi_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Esiane sɛ moyɛ kronkron ma me nti, monnwe aboa biara a akekaboa akyere no akum no. Munnyaw ne funu no mma akraman mmɛwe. ");
INSERT INTO twi_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Monkeka nkontomposɛm. Mo ne ɔbɔnefo nni nsawɔso, na moanni adansekurum. ");
INSERT INTO twi_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Mommfa wo ho nhyehyɛ nnipadɔm bi a wɔpɛ sɛ wɔyɛ bɔne mu. Sɛ moredi adanse a, monnhwɛ nnipa bi dodow so nni mmoa wɔn, ");
INSERT INTO twi_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","na munni adanse mmoa ohiani wɔ asennibea. ");
INSERT INTO twi_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Sɛ muhu mo tamfo nantwi anaa nʼafurum a wayera a, monkyere no nkɔma ne wura no. ");
INSERT INTO twi_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Sɛ mokɔto sɛ mo tamfo bi repagyaw nʼafurum agyina ne nan so wɔ adesoa duruduru ase a, monntwa ne ho nkɔ, mmom mommoa no. ");
INSERT INTO twi_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Mommfa atɛntrenee nkame ahiafo wɔ asennibea. ");
INSERT INTO twi_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Mommfa asɛm a munhui nto obi a odi bem anaa ɔnokwafo so mma wonkum no, efisɛ merennyaa ɔfɔdifo. ");
INSERT INTO twi_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Munnye adanmude na adanmudegye fura onipa ani. Adanmudegye ma nea nʼasɛm yɛ dɛ no asɛm sɛe. ");
INSERT INTO twi_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Monnhyɛ ɔnanani so; mo ankasa munim sɛnea ɔnananiyɛ te, efisɛ na moyɛ ananafo wɔ Misraim. ");
INSERT INTO twi_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Munnua na muntwa no nnɔbae ntoatoa so saa ara nkosi mfe asia, ");
INSERT INTO twi_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","nanso afe a ɛto so ason so de, momma asase no nna hɔ kwa mma ahiafo ntwa nnɔbae biara a ebenyin wɔ so no; nkae no, munnyaw mma mmoa nwe. Saa ara na monyɛ mo bobeturo ne wo ngonnua turo nso. ");
INSERT INTO twi_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Nnansia na momfa nyɛ adwuma na monhome ne nnanson so. Eyi bɛma mo anantwi, mo mfurum, mo fifo, mo asomfo ne mo ahɔho nso ahome. ");
INSERT INTO twi_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Munni asɛm biara a maka no so. Monnkankye mmɔ onyame foforo biara din; momma wɔnnte bi mmfi mo ano.” ");
INSERT INTO twi_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Afe biara mu, monhyɛ fa mprɛnsa mfa nhyɛ me anuonyam. ");
INSERT INTO twi_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Nea edi kan no, munni Apiti Afahyɛ no. Sɛ edu so a, munnni brodo a mmɔkaw wɔ mu nnanson, sɛnea mehyɛɛ mo no. Ɛsɛ sɛ afe biara mohyɛ saa fa yi wɔ ɔsram Abib mu, ɔsram a mode tu fii Misraim no mu. “Edu saa bere no a, obiara mmrɛ me afɔrebɔde. ");
INSERT INTO twi_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Ɛno akyi no, Otwabere Afahyɛ na edi so. Saa afahyɛ yi du so a, momfa mo aduankan mmrɛ me. “Nea etwa to yɛ nnɔbae anoboa afahyɛ a ɛsɛ sɛ wodi no otwa bere no akyi. ");
INSERT INTO twi_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Afahyɛ ahorow abiɛsa yi mu nyinaa, ɛsɛ sɛ Israel mmarima nyinaa ba Awurade Nyankopɔn anim. ");
INSERT INTO twi_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Mommfa biribiara a mmɔkaw wɔ mu mmɔ mogya afɔre mma me. “Saa ara na ɛnsɛ sɛ mʼafahyɛ afɔrebɔde mu srade no tena hɔ ma ade kye so. ");
INSERT INTO twi_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Sɛ mutwa mo nnɔbae a, Momfa mo nnɔbae mu nea ɛsɔ ani koraa no mmra Awurade mo Nyankopɔn fi. “Monnoa abirekyi ba wɔ ne na nufusu mu. ");
INSERT INTO twi_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Meresoma ɔbɔfo na wadi mo anim de mo akɔ asase a masiesie ama mo no so dwoodwoo. ");
INSERT INTO twi_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Momfa nidi mma no na munni ne nsɛm so; monnsɔre ntia no, efisɛ ɔremfa mo amumɔyɛ nkyɛ mo. Ɔyɛ me nsiananmu, na me din na ɛda ne so. ");
INSERT INTO twi_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Na sɛ motɔ mo bo ase, na mutie no, di me nsɛm nyinaa so a, mɛyɛ ɔtamfo atia mo atamfo. ");
INSERT INTO twi_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Me bɔfo bedi mo anim de mo aba Amorifo, Hetifo, Perisifo, Kanaanfo, Hewifo ne Yebusifo asase so na moatena hɔ. Na mɛsɛe saa nnipa no nyinaa wɔ mo anim. ");
INSERT INTO twi_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Monnsom anyame a saa aman yi som wɔn no bi, na mommmɔ afɔre mma wɔn da biara da. Munnni saa abosonsomfo yi akyi. Munni wɔn so na mummubu wɔn ahoni a ɛyɛ animguasede no ngu. ");
INSERT INTO twi_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Mo Awurade, mo Nyankopɔn nko ara na monsom no. Na mehyira mo ama moanya aduan ne nsu na meyi nyarewa nyinaa afi mo so. ");
INSERT INTO twi_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ɔpɔn anaa abonin remma mo asase no so na mɛma mo nna amee mo. ");
INSERT INTO twi_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Awurade ho hu bɛka aman a mubedi wɔn so no so nnipa nyinaa na wɔaguan wɔ mo anim. ");
INSERT INTO twi_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mɛma kotokurodu abɛpam Hewifo, Kanaanfo ne Hetifo afi mo anim. ");
INSERT INTO twi_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Merenyɛ eyinom nyinaa afe baako pɛ mu na asase no annan sare amma nkekaboa ammu amfa mo so. ");
INSERT INTO twi_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Mɛpam wɔn nkakrankakra kosi sɛ mobɛdɔɔso, atumi ahyɛ asase no so ma. ");
INSERT INTO twi_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Mɛto mo ahye afi Po Kɔkɔɔ no ano akosi Filistifo mpoano, na mede afi sare a ɛwɔ anafo fam no so akosi Asu Eufrate, na mɛma mo adi nnipa a wɔte asase no so no so, na moapam wɔn afi mo anim. ");
INSERT INTO twi_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Mo ne wɔn nnyɛ apam biara, na saa ara nso na mo ne wɔn anyame no nnyɛ biribiara. ");
INSERT INTO twi_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Mommma wɔmmɛtena mo mu, anyɛ saa a wɔbɛma mo ayɛ bɔne atia me; esiane sɛ ɛnyɛ dɛn ara a, wɔn abosonsom no som bɛyɛ afiri a ebeyi mo.” ");
INSERT INTO twi_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Afei, Awurade ka kyerɛɛ Mose se, “Wo ne Aaron, Nadab, Abihu ne Israelfo mpanyimfo aduɔson mforo mmra ha. Mo nyinaa, momma me ne mo ntam ntwe na monsom me. ");
INSERT INTO twi_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mose nko ara na ɔbɛbɛn Awurade; na monkae nso sɛ, ɛnsɛ sɛ wɔn a wɔaka no twiw bɛn bepɔw no koraa.” ");
INSERT INTO twi_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mose kaa mmara a Awurade hyɛɛ no no nyinaa kyerɛɛ nnipa no ma wɔn nyinaa bɔ gyee so se, “Yebedi ne nyinaa so.” ");
INSERT INTO twi_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mose kyerɛw Awurade mmara no nyinaa guu hɔ. Ade kyee anɔpa no, osii afɔremuka wɔ bepɔw no ase. Ɔde adum dumien twaa ho hyiae, efisɛ na Israel mmusuakuw no yɛ dumien. ");
INSERT INTO twi_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Afei, ɔsomaa mmabun a wɔwɔ wɔn mu no bi sɛ wɔnkɔbɔ ɔhyew afɔre ne asomdwoe afɔre mma Awurade. ");
INSERT INTO twi_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mose sɔn mmoa no mogya no fa de guu nkankyee mu, na ɔtow fa a aka no petee afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ɔkenkan nhoma a wakyerɛw a ɛyɛ Apam Nhoma a Awurade akwankyerɛ ne ne mmara wɔ mu no kyerɛɛ nnipa no. Nnipa no bɔ gyee so bio se, “Yɛhyɛ bɔ sɛ, yebedi mmara no nyinaa so.” ");
INSERT INTO twi_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Afei, Mose de mogya a ɛwɔ nkankye no mu no petee nnipa no so kae se, “Saa mogya yi hyɛ apam a mo ne Awurade ayɛ ne mmara a ɔde ama mo no mu den.” ");
INSERT INTO twi_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mose, Aaron, Nadab, Abihu ne Israelfo mpanyimfo aduɔson no foro kɔɔ bepɔw no so ");
INSERT INTO twi_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","na wohuu Israel Nyankopɔn. Na nʼanan ntiaso hyerɛn te sɛ hoabo a ne hyerɛn te sɛ wim ahosu. ");
INSERT INTO twi_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ɛwɔ mu sɛ mpanyimfo no huu Onyankopɔn de, nanso wansɛe wɔn. Nokwarem, wɔn nyinaa bɔɔ mu didii wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Na Awurade ka kyerɛɛ Mose se, “Foro bra me nkyɛn wɔ bepɔw so ha na tena ha, na mede mmaransɛm a makyerɛw agu ɔbo so no bɛma wo, na woafa so akyerɛkyerɛ nnipa no.” ");
INSERT INTO twi_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Enti Mose ne ne boafo Yosua foro kɔɔ Onyankopɔn bepɔw no so. ");
INSERT INTO twi_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ɔka kyerɛɛ mpanyimfo no se, “Montena ha ntwɛn yɛn kosi sɛ yɛbɛba. Sɛ asɛm bi kyere obi so a, obetumi akɔ Aaron ne Hur nkyɛn.” ");
INSERT INTO twi_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mose foro kɔɔ bepɔw no so hɔ na ɔyeraa wɔ omununkum mu. ");
INSERT INTO twi_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Na Awurade anuonyam hyɛɛ Sinai bepɔw no so ma. Na omununkum sii bepɔw no so nnansia. Ne nnanson so no, ɔfrɛɛ Mose fii omununkum no mu. ");
INSERT INTO twi_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Wɔn a wɔwɔ bepɔw no ase no huu anwonwade no. Na Awurade anuonyam a ɛwɔ bepɔw no so no te sɛ ogya a ɛredɛw. ");
INSERT INTO twi_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Na Mose yeraa wɔ bepɔw no so mununkum no mu. Odii bepɔw no so adaduanan. ");
INSERT INTO twi_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ka kyerɛ Israelfo no se, wɔmmɔ afɔre mma me. ");
INSERT INTO twi_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Saa nneɛma a edidi so yi mu na womfi mmɔ me afɔre no: “sikakɔkɔɔ, dwetɛ, kɔbere, ");
INSERT INTO twi_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ntama tuntum, koogyan bibiri tam; koogyan tam, sirikyi, abirekyi ho nwi, ");
INSERT INTO twi_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","odwennini nhoma a wɔahyɛ no kɔkɔɔ, mmirekyi nhoma, ɔkanto dua, ");
INSERT INTO twi_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","kanea ngo, ɔsra ngo, nnuhuam a wɔhyewee, ");
INSERT INTO twi_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","abo a nʼahosu te sɛ apopobibiri, abo a wɔde betuatua asɔfotade ne nkatabo mu. ");
INSERT INTO twi_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Afei monyɛ kronkronbea mma me, na mɛtena wɔn mu. ");
INSERT INTO twi_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Monyɛ ntamadan yi ne ne nsiesiemu nyinaa sɛnea mɛkyerɛ mo no pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Momfa ɔkanto dua nyɛ Apam Adaka a ne ntwemu yɛ anammɔn abiɛsa ne fa, ne trɛw nyɛ anammɔn abien ne fa na ne sorokɔ nso nyɛ anammɔn abien ne fa. ");
INSERT INTO twi_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Na momfa sikakɔkɔɔ ankasa nnura ho ne mu nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Momfa sikakɔkɔɔ nkaa anan nhyehyɛ adaka no anan anan no ho, wɔ fam pɛɛ. Ma nkaa no abien nkɔ ɔfa baako na abien a aka no nso nkɔ fa. ");
INSERT INTO twi_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Fa ɔkanto sen mmaa, na fa sikakɔkɔɔ duradura ho. ");
INSERT INTO twi_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Fa mmaa no hyehyɛ nkaa no mu na wɔde asoa apam adaka no. ");
INSERT INTO twi_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Munnyiyi nnua a wɔde soa adaka no mfi nkaa no mu. Momma ɛnhyehyɛ mu afebɔɔ. ");
INSERT INTO twi_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Muwie adaka no a, momfa ɔbo a makyerɛw Mmaransɛm Du no agu so no nto mu. ");
INSERT INTO twi_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Momfa sikakɔkɔɔ nyɛ adaka no ti a ne ntwemu yɛ basafa abien ne fa na ne trɛw nso yɛ anammɔn abien ne kakra. Ɛha ne baabi a mubenya mo bɔne so ahummɔbɔ afi. ");
INSERT INTO twi_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Momfa sikakɔkɔɔ a wɔaboro nyɛ kerubim abien. Momfa ɔbaako nsi adaka no nkataso atifi na momfa ɔbaako nsi anafo. ");
INSERT INTO twi_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Fa kerubim no tetare adaka no ti ne nʼanafo na ɛne adaka no nkataso no nyɛ mua. ");
INSERT INTO twi_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kerubim a wɔyɛ abɔfo no bedi nhwɛanim a wɔasisi wɔn ti ase rehwɛ mpata agua no na wɔatrɛtrɛw wɔn ntaban mu akata so. ");
INSERT INTO twi_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Momfa ɔbo kyerɛwpon a mede bɛma mo no nto adaka no mu, na momfa ne ti no nkata so. ");
INSERT INTO twi_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Na mehyia mo wɔ hɔ na makasa afi mpata agua wɔ soro hɔ afa abɔfo no ntam. Na adaka no mu na wɔbɛkora mʼapam no ho mmara. Ɛhɔ na mɛda me mmaransɛm a mode bɛma Israelfo no adi akyerɛ mo. ");
INSERT INTO twi_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Momfa ɔkanto dua nyɛ ɔpon a ne ntwemu mu yɛ anammɔn abiɛsa, ne trɛw yɛ ɔnammɔn baako ne fa na ne sorokɔ yɛ anammɔn abien ne fa. ");
INSERT INTO twi_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Momfa sikakɔkɔɔ nnura ho na momfa sikakɔkɔɔ hankare ntwa ho nhyia. ");
INSERT INTO twi_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Yɛ adaka no ho ntetareho a ne trɛw yɛ nsateaa anan twa ɔpon no ano ho hyia, na fa sikakɔkɔɔ hankare fa ho. ");
INSERT INTO twi_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Yɛ sikakɔkɔɔ nkaa anan na fa nkaa anan no tuatua nʼanan anan no biara akyi ");
INSERT INTO twi_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","twɔtwɔw so wɔ soro. Wɔde nnua no bɛhyehyɛ saa nkaa a wɔde bɛma ɔpon no so asoa no mu. ");
INSERT INTO twi_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Fa ɔkanto yɛ nnua no, na fa sikakɔkɔɔ dura ho. ");
INSERT INTO twi_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Momfa sikakɔkɔɔ nyɛ nsanka, mprɛte, ntere, nhina ne nsatoa. ");
INSERT INTO twi_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Da biara, fa brodo to ɔpon no so wɔ mʼanim. ");
INSERT INTO twi_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Momfa sikakɔkɔɔ a wɔaboro nyɛ kaneadua. Kaneadua no ase, nʼabaa, akanea no nhwiren ne ɛho asiesie no nyinaa nyɛ ade baako. ");
INSERT INTO twi_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kaneadua a ɛhyɛ mfimfini no benya nkorata asia a abiɛsa wɔ fa na abiɛsa nso wɔ fa. ");
INSERT INTO twi_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Momfa nhwiren abiɛsa nsiesie nkorata biara ho. ");
INSERT INTO twi_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Na kaneadua no, momfa nhwiren a ɛyɛ fɛ nni adwinni mfa nsiesie no. ");
INSERT INTO twi_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Nhwiren no bi bɛwɔ ne dua no ase wɔ nkorata abien biara ase. Afei, nhwiren no bi bɛwɔ nkorata abien a ɛwɔ ase no ase, na bi nso bɛwɔ nkorata abien a ɛwɔ soro no so. ");
INSERT INTO twi_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Saa nneɛma a wɔde siesie kaneadua no ne ne nkorabata no nyinaa nyɛ ade baako a wɔde sikakɔkɔɔ ankasa a wɔaboro ayɛ. ");
INSERT INTO twi_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Monyɛ akanea dua ntuatuaho ason wɔ kaneadua no ho wɔ ɔkwan bi so a ne hyerɛn no bɛtow hann agu nʼanim. ");
INSERT INTO twi_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Kanea ntamabamma adabaw no ne ne mpampaa no nso, momfa sikakɔkɔɔ ankasa nyɛ. ");
INSERT INTO twi_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Sikakɔkɔɔ kilogram aduasa anan na ɛho behia sɛ mode bɛyɛ kaneadua no ne ɛho nneɛma nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Biribiara a mobɛyɛ no nso, monyɛ no pɛpɛɛpɛ sɛnea makyerɛ mo wɔ bepɔw so ha yi no. ");
INSERT INTO twi_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Fa asaawa a ɛyɛ fɛ a woafura bamma du ne ntama a wɔahyɛ no aduru tuntum, ɔtam bibiri, koogyan a wɔanwen kerubim sɛso agu mu si Ahyiae Ntamadan no. ");
INSERT INTO twi_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ɛsɛ sɛ nkataano du no nyinaa kɛse yɛ pɛ. Emu biara tenten yɛ anammɔn aduanan abien na ne trɛw nso yɛ anammɔn asia. ");
INSERT INTO twi_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Mompam saa ntama no anum mmɔ mu mma ɛnyɛ baako. Anum a aka no nso, monyɛ no saa ara. ");
INSERT INTO twi_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Momfa ntama bibiri bamma aduonum nwurawura ntama no afa abien a ɛsensɛn hɔ no mu. ");
INSERT INTO twi_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ɛsɛ sɛ mobɔ nkɔtɔkoro aduonum ma edi nhwɛanim wɔ ɔfa biara. ");
INSERT INTO twi_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Bɔ sikakɔkɔɔ nkɔtɔkoro aduonum na fa kyekyere nkɔtɔkoro no bɔ mu, sɛnea ɛbɛyɛ na Ahyiae Ntamadan hɔ no bɛyɛ ɔdan baako. ");
INSERT INTO twi_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Monwen mmirekyi nwi mfa nkuru Ahyiae Ntamadan no so. Ɛsɛ sɛ nkuruso no dodow yɛ dubaako. ");
INSERT INTO twi_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Nkurusotam dubaako no nyinaa tenten ne ne trɛw nyɛ pɛpɛɛpɛ. Ne tenten nyɛ anammɔn aduanan anum na ne trɛw nyɛ anammɔn asia. ");
INSERT INTO twi_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ka saa nkataso yi anum bɔ mu na ɛnyɛ ade tɛtrɛɛ baako; na fa asia a aka no bɔ mu na ɛno nso nyɛ ade tɛtrɛɛ baako. Wobebu nkuruso a ɛto so asia no ato so ama asensɛn fam sɛ ɔdan kronkron no nhiniano. ");
INSERT INTO twi_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Yɛ nkɔtɔkoro aduonum aduonum a wɔabobɔ hyehyɛ ntama asinasin akuw abien no biara ano. ");
INSERT INTO twi_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Na yɛ nsusomu aduonum na fa saa nsusomu no hyehyɛ nkɔtɔkoro no mu na ɛnka asɔredan no mmɔ mu na ɛnyɛ mua. ");
INSERT INTO twi_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ɔdan no nkurusotam anammɔn baako ne fa bɛsensɛn Ahyiae Ntamadan no akyi, ");
INSERT INTO twi_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","na anammɔn baako ne fa nso asensɛn anim. ");
INSERT INTO twi_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Momfa nneɛma ahorow abien mmɔ ɔdan no so. Nea edi kan no nyɛ odwennini were a wɔahyɛ no kɔkɔɔ, nea ɛto so abien nyɛ abirekyi were a ɛsɔ. ");
INSERT INTO twi_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Fa ɔkanto yɛ ntaaboo na fa twa Ahyiae Ntamadan no ho. ");
INSERT INTO twi_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Mpuran biara sorokɔ nyɛ anammɔn dunum na ne trɛw nyɛ anammɔn abien ne kakra. ");
INSERT INTO twi_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ɛsɛ sɛ nkɔtɔkoro abien wɔ mpuran biara ase, na mpuran biara yɛ pɛ. ");
INSERT INTO twi_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Mobɛyɛ Ahyiae Ntamadan no ntaaboo ama emu aduonu akyerɛ nʼanafo. ");
INSERT INTO twi_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Wɔde besisi dwetɛ nnyinaso aduanan so; nnyinaso no abien abien nhyehyɛ mpuran biara ase. ");
INSERT INTO twi_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ahyiae Ntamadan no atifi fam nso, wɔbɛyɛ ntaaboo aduonu atwa ho. ");
INSERT INTO twi_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Ɛno nso wɔde besisi dwetɛ nnyinaso aduanan so a mpuran baako besi nnyinaso abien so. ");
INSERT INTO twi_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ahyiae Ntamadan no fa a ɛkyerɛ atɔe fam no bɛyɛ nʼakyi. Ɛno nso wɔde ntaaboo asia na ebetwa ho ");
INSERT INTO twi_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","a ntaaboo abien sisi twea biara. ");
INSERT INTO twi_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Wɔde nkɔtɔkoro besuso ntaaboo abien no soro ne ne fam. ");
INSERT INTO twi_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Wɔka ne nyinaa bɔ mu a, ntaaboo awotwe na wɔde bɛyɛ ɔdan no fa hɔ a wɔde besisi dwetɛ nsisiso dunsia so. Mpuran biara bɛfa nsisiso abien. ");
INSERT INTO twi_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Fa ɔkanto sen mmeamu nnua bi na fa bea ntaaboo no mu. Mmeamu nnua no anum nkɔ ntaaboo no fa baako ");
INSERT INTO twi_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","na anum a aka no nso nkɔ ɔfa baako. Fa mmeamu nnua no anum bobɔ ntaaboo a ɛwɔ ntamadan no akyi, a ani kyerɛ atɔe fam no. ");
INSERT INTO twi_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ma mmeamu dua a ɛbea mfimfini no nkɔ ntaaboo no soro kakra mma emfi ti nkɔka ti. ");
INSERT INTO twi_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Fa sikakɔkɔɔ dura ntaaboo no ho na fa sikakɔkɔɔ nkaa suso mmeamu dua no mu na ennyina. Fa sikakɔkɔɔ dura mmeamu dua no nso ho. ");
INSERT INTO twi_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Fa hyehyɛbea a mekyerɛɛ wo wɔ bepɔw no so hɔ no so pɛpɛɛpɛ si Ahyiae Ntamadan no. ");
INSERT INTO twi_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Fa ntama tuntum, koogyan bibiri, koogyan ne asaawatam a ɛyɛ fɛ yɛ ntwamtam a wɔanwen kerubim sɛso agu mu no. ");
INSERT INTO twi_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Fa sɛn ɔkanto nnua fadum anan a wɔde sikakɔkɔɔ adura ho a sikakɔkɔɔ nsusomu anan suso ano no so. Ma ɔfadum anan no mu biara nsi dwetɛ nnyinaso anan no baako so. ");
INSERT INTO twi_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Fa ntwamtam no sensɛn nsusomu no so na fa twa ɔdan no mu. Fa adaka a ɔbo a wɔakyerɛw Onyankopɔn mmara agu so no da mu no si ntama ntwamu no akyi. Ntama ntwamu no betwa kronkronbea hɔ ne kronkron mu kronkron no ntam. ");
INSERT INTO twi_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Afei, fa adaka no mmuaso a wɔde sikakɔkɔɔ ayɛ no bua so na fa si kronkron mu kronkron hɔ. ");
INSERT INTO twi_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Fa ɔpon no ne kaneadua no twa dan no mu wɔ ntwamtam no akyi. Kaneadua no besi kronkronbea no anafo, na ɔpon no asi nʼatifi. ");
INSERT INTO twi_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Fa ntama foforo a ɛyɛ ɔtam bibiri ne koogyan asaawatam yɛ Ahyiae Ntamadan no ano nkataanim. ");
INSERT INTO twi_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Fa saa ntwamtam no sɛn ɔkanto mpuran anum a wɔde sikakɔkɔɔ adura ho no nsusomu no so. Wɔde saa mpuran no besisi ayowa ntaease anum no mu. ");
INSERT INTO twi_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Fa ɔkanto yɛ afɔremuka ma enyi ahinanan a nʼafanan no mu biara yɛ anammɔn ason ne fa na ne sorokɔ nso yɛ anammɔn anan ne fa. ");
INSERT INTO twi_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Yɛ mmɛn anan tuatua afɔremuka no ntwea anan no nyinaa so, na fa kɔbere dura ne nyinaa ho. Ɔkanto a wode bɛyɛ afɔremuka no, ɛno ara bi na wode bɛyɛ mmɛn no. ");
INSERT INTO twi_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Bokiti a nsõ begu mu, sofi, hweaseammɔ, adinam ne nsramma nkankye nyinaa, kɔbere na fa yɛ. ");
INSERT INTO twi_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Fa kɔbere yɛ ntwitae na fa dade nkaa hyehyɛ ne ntwea anan no so. ");
INSERT INTO twi_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Fa ntwitae no hyɛ nsramma kuruwa no mu na fa si afɔremuka no basa a wɔayɛ no so. ");
INSERT INTO twi_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Fa ɔkanto sen nnua a wɔde kɔbere adura ho a wɔde bɛsoa afɔremuka no. ");
INSERT INTO twi_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Sɛ moresoa a, momfa nnua no nhyehyɛ nkaa a mode atuatua afɔremuka no ho no mu. ");
INSERT INTO twi_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ntaaboo na momfa nyɛ afɔremuka no. Momma emu nna kwan sɛnea mede kyerɛɛ mo wɔ bepɔw no so no. ");
INSERT INTO twi_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Twa adiwo ma Ahyiae Ntamadan no na fa ntama a wɔde asaawa a ɛyɛ fɛ ayɛ sensɛn ho. Nkataano a ɛsɛn anafo no tenten no nyɛ anammɔn ɔha aduonum ");
INSERT INTO twi_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","a kɔbere nnua aduonu a esisi kɔbere nnyinaso aduonu mu no suso mu. Dwetɛ nkɔtɔkoro ne dwetɛ ntwea a ɛtetare dwetɛ afadum no ho no na ebesuso nsɛnanim no mu. ");
INSERT INTO twi_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Adiwo a ɛkyerɛ atifi fam no nso, saa ara na wɔnyɛ no. Nsɛnanim a ne tenten yɛ anammɔn ɔha aduonum, na nnua aduonu sisi kɔbere nnyinaso mu a dwetɛ nkɔtɔkoro ne ne ntwea tetare ho na ebegyina no. ");
INSERT INTO twi_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Adiwo no fa a ɛkyerɛ atɔe fam no trɛw bɛyɛ anammɔn aduɔson anum a ekura nnua du a ntokuru du deda mu. ");
INSERT INTO twi_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Apuei fam nso bɛyɛ anammɔn aduɔson anum saa ara. ");
INSERT INTO twi_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Baabi a ne kwan da nʼapuei fam no, wɔmfa nsɛnanotam a ne tenten yɛ anammɔn aduonu abien ne fa a nnua abiɛsa a esisi ntokuru abiɛsa mu suso mu no nsɛn ano. ");
INSERT INTO twi_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Baabi a ne kwan da wɔ nʼatɔe fam no nso, wɔmfa nsɛnanotam a ne tenten yɛ anammɔn aduonu abien ne fa nsɛn ano. Nnua abiɛsa a esisi ntokuru abiɛsa mu na ebesuso nsɛnanotam no mu. ");
INSERT INTO twi_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Adiwo hɔ no ano kwan nyɛ ntama nsɛnanim a ne trɛw yɛ anammɔn aduasa. Wɔde asaawa tuntum, bibiri ne koogyan bedi mu adwinni fɛfɛɛfɛ. Wɔde nnua anan a esisi ne nnyinaso mu no nso besuso nsɛnanotam no mu. ");
INSERT INTO twi_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ɛsɛ sɛ nnua a ɛwɔ adiwo hɔ no nyinaa wɔde dwetɛ ntwea a dwetɛ suso mu, na nʼase no nso wɔde hyehyɛ kɔbere nnyinaso apipiripi mu. ");
INSERT INTO twi_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Enti adiwo hɔ tenten mu bɛyɛ anammɔn ɔha ne aduonum, na ne trɛw nso ayɛ anammɔn aduɔson anum. Wɔde nkataano a wɔde asaawatam bɛyɛ ne fasu, a ne sorokɔ nso bɛyɛ anammɔn ason ne fa. Ɛsɛ sɛ wɔde nnua a atwa adiwo hɔ no ho ahyia no sisi kɔbere nnyinaso no mu. ");
INSERT INTO twi_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Kɔbere na ɛsɛ sɛ wɔde yɛ Ahyiae Ntamadan mu hɔ nkankye a wɔde nneɛma gu mu, ne nnyinaso a wɔde nkankyee bɛsensɛn so wɔ ɔfasu ho no wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Ka kyerɛ Israelfo no na wɔmfa ngo kronkron a wɔde begu akanea a daa nyinaa ebesi so no mmrɛ wo. ");
INSERT INTO twi_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaron ne ne mmabarima na wɔde akanea a ennum da no besi Ahyiae Ntamadan no mu. Wɔbɛhwɛ so daa ama Awurade, sɛnea ɛbɛyɛ a ɛrennum. Eyi yɛ mmara a ɛsɛ sɛ Israelfo di so daa. ");
INSERT INTO twi_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Yi wo nua Aaron ne ne mmabarima Nadab, Abihu, Eleasar ne Itamar na tew wɔn ho na wɔnyɛ asɔfo nsom me. ");
INSERT INTO twi_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Pam atade kronkron ma wo nua Aaron na ama anuonyam aba nʼadwuma no ho. Pam atade no na ɛnyɛ fɛ, sɛnea ɛbɛma afata nʼadwuma no. ");
INSERT INTO twi_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ka kyerɛ nnipa a mama wɔn adepam ho nyansa na wɔmpam atade no. Ɛno na ɛbɛma no ada nsow wɔ ne mfɛfo mu na ama watumi asom me. ");
INSERT INTO twi_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ntade ahorow a wɔbɛpam no ni: adɛbo asɔfotade, atade yuu, atade kɔnsin a ɛyɛ adamadam, abotiri ne nkyekyeremu. Wɔbɛpam ntade kronkron bi nso de ama Aaron mmabarima no. ");
INSERT INTO twi_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Wɔde ntama tuntum, bibiri ne koogyan a wɔde asaawatam pa na anwen na ɛbɛpam. ");
INSERT INTO twi_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Ma ntamanwen mu adwumfo papa mfa sikakɔkɔɔ ne bibiri ne asaawa a ɛbere dum ne koogyan ne asaawa fitaa a wɔafura nyɛ asɔfotade no. ");
INSERT INTO twi_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Wɔbɛpam no asinasin abien a ɛyɛ anim ne akyi a wɔapam ne mmati no so abɔ mu. ");
INSERT INTO twi_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Nkyekyeremu no bɛyɛ ntama koro no ara bi. Ɛbɛyɛ asaawatam a ɛyɛ akokɔsrade, tuntum, bibiri ne koogyan. ");
INSERT INTO twi_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Fa apopobibiri abo abien na kyerɛw Israelfo mmusuakuw no din gu so. ");
INSERT INTO twi_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ɔbo biara, wɔnkyerɛw din asia ngu so, sɛnea ɛbɛyɛ a, wɔn nyinaa din bedidi so mpanyin mu. ");
INSERT INTO twi_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Fa ɔkwan a aboɔdemmotwafo si fa twa din gu adwinne so no so kyerɛw din ahorow no sɛnea Israel mma no din te, na fa sika mmuano twa ho hyia. ");
INSERT INTO twi_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Fa abo abien no sisi asɔfotade no mmati so na ɛnyɛ nkae ade mma Israelfo. Na daa Aaron nso nam so akae, abɔ wɔn din akyerɛ Awurade. ");
INSERT INTO twi_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Yɛ sikakɔkɔɔ ntweaban a wɔakyinkyim ");
INSERT INTO twi_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ne ntweaban abien a wɔde sikakɔkɔɔ ayɛ tetare ntetareho a ɛwɔ asɔfotade no mmati so no mu. ");
INSERT INTO twi_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Momma odwumfo a nʼadwinni yɛ fɛ na ɔnyɛ atemmu adɛbo no. Momfa asaawatam a ɛyɛ akokɔsrade, tuntum, bibiri ne koogyan na ɛmpam adɛbo no sɛnea mode pam asɔfotade no. ");
INSERT INTO twi_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Mummu adɛbo no nto so na ɛnyɛ sɛ ntama nkotoku. ");
INSERT INTO twi_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Momfa abo a ɛsom bo a ɛsesa so anan mmobɔ mu. Nea a edi kan no nyɛ bogyanambo, nea ɛto so abien no nyɛ akraatebo na nea etwa to no nyɛ ɔbo a ɛte sɛ ahabammono. ");
INSERT INTO twi_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Nsaso a ɛto so abien no nyɛ nsrammabo, hoabo ne dɛnkyɛmmo. ");
INSERT INTO twi_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Nsaso a ɛto so abiɛsa no nso bɛyɛ akutuhonobo, mfrafraebo ne beredumbo. ");
INSERT INTO twi_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Nsaso a ɛto so anan no bɛyɛ sikabereɛbo, apopobibiribo ne ahwehwɛbo. Sikakɔkɔɔ mmuano ntwa ne nyinaa ho nhyia. ");
INSERT INTO twi_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ɔbo no baako biara begyina hɔ ama Israel mmusuakuw no baako. Na wɔbɛkyerɛw abusua ko no din agu so sɛ nsɔwanode. ");
INSERT INTO twi_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Ɔkwan a mobɛfa so de adɛbo no afam asɔfotade no mu ni: yɛ sikakɔkɔɔ ntweaban. ");
INSERT INTO twi_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Yɛ sikakɔkɔɔ nkaa abien, na fa tetare adɛbo no twɔtwɔw so. ");
INSERT INTO twi_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Fa sikakɔkɔɔ ntweaban abien no hyehyɛ adɛbo no nkaa abien no twɔtwɔw so, ");
INSERT INTO twi_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ntweaban abien a aka no fa biara nso, wɔmfa ntare ɔbo a ɛte sɛ apopobibiri no apɔw abien no so nsan mfa ntare asɔfotade no mmati so. ");
INSERT INTO twi_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Yɛ sika nkaa abien na fa hyehyɛ adɛbo ntwea abien a ɛwɔ fam no mu. ");
INSERT INTO twi_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","San yɛ sikakɔkɔɔ nkaa abien hyehyɛ asɔfotade no ntwea so wɔ fam ma ɛnka nkyekyeremu no. ");
INSERT INTO twi_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Fa bibiri hama kyekyere adɛbo no ase na fa hyehyɛ nkaa a ɛwɔ asɔfotade no ase no mu. Eyi remma adɛbo no mfi asɔfotade no ho ntew nsensɛn. ");
INSERT INTO twi_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Aaron bɛfa saa kwan yi so na ɔde Israel mmusuakuw no din a ɛwɔ adɛbo no so no bɛkɔ kronkronbea hɔ; na eyi na ɛbɛma Awurade akae Israelman bere nyinaa mu. ");
INSERT INTO twi_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Sɛ Aaron rekɔ Awurade anim a, ɔmfa Urim ne Tumim a ase ne hann ne pɛyɛ nhyɛ adɛbo a ɛda ne koko so no kotoku mu. Saa ara na daa Aaron bɛsoa nneɛma a wɔnam so kyerɛ Awurade apɛde de ma ne nkurɔfo no bere biara a ɔbɛkɔ Awurade anim no. ");
INSERT INTO twi_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Wɔde ntama tuntum na ɛbɛpam asɔfotade no ");
INSERT INTO twi_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","na wɔagyaw ɔkwan bi a Aaron de ne ti bewura mu. Ɛsɛ sɛ wɔde ntama a wɔanwen to atade no kɔn mu hyia, na ansuane amfa mu. ");
INSERT INTO twi_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Wɔde ntama tuntum, bibiri ne koogyan na ɛbɛpam ato ano. ");
INSERT INTO twi_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Ɛsɛ sɛ wɔde sikakɔkɔɔ adɔmma ne atoaa aba a edi afrafra twa asɔfotade no mmuano ho hyia. ");
INSERT INTO twi_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Bere biara a Aaron bɛkɔ Awurade anim akɔsɔre no, saa asɔfotade yi na ɔbɛhyɛ. Ɔredi akɔneaba wɔ Awurade anim hɔ wɔ kronkronbea hɔ no, na dɔn no rewosow sɛnea ɛbɛyɛ a ɔrenwu. ");
INSERT INTO twi_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Afei, boro sikakɔkɔɔ ankasa ma ɛnyɛ tratraa sɛ prɛte na kyerɛw so sɛnea wokurukyerɛw nsɔwanode so no se: Kronkron Ma Awurade. ");
INSERT INTO twi_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Wɔde ntama tuntum beso mu asensɛn Aaron abotiri no anim. ");
INSERT INTO twi_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aaron de saa ade no bɛbɔ ne moma so sɛnea ɛbɛyɛ a, sɛ Israelfo no bɔ afɔre biara na mfomso ba ho a, ɛho asodi bɛda ne so, na Awurade agye nnipa no, na ɔde wɔn bɔne nso akyɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Fa asaawatam a ɛyɛ fɛ nwen Aaron atade kɔnsin no. Ma ɛnyɛ adamadam na fa ntama koro no ara bi pam abotiri na nwen biribi gu ne nkatakɔnmu no nso mu. ");
INSERT INTO twi_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Pam atade yuu ne nkyekyeremu ne abotiri ma Aaron mmabarima na momfa obu ne nidi mma wɔn. ");
INSERT INTO twi_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Saa ntade yi na momfa nhyɛ Aaron ne ne mmabarima na momfa ngo ngu wɔn tirim mfa nhyɛ wɔn asɔfo wɔ ɔsom no mu, na momfa ntew wɔn ho sɛ asɔfo a wɔyɛ me dea. ");
INSERT INTO twi_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Mompam sirikyi ntade a efi wɔn sisi kɔka wɔn nan ase, na wɔhyɛ ansa a, wɔahyɛ wɔn ntade no agu so. ");
INSERT INTO twi_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Bere biara a Aaron ne ne mmabarima no rekɔ Ahyiae Ntamadan mu hɔ anaasɛ wɔrekɔ afɔremuka no anim wɔ kronkronbea hɔ no, wɔnhyɛ. Anyɛ saa a afɔbu bɛba wɔn so ama wɔawuwu. “Eyi yɛ daa apam a wɔahyɛ ama Aaron ne ne mmabarima. ");
INSERT INTO twi_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Ɔkwan a ɛsɛ sɛ mofa so hyɛ Aaron ne ne mma asɔfo ni: Momfa nantwi ba ne adwennini abien a wɔn ho nni dɛm. ");
INSERT INTO twi_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Na momfa esiam muhumuhu a mmɔkaw nni mu nyɛ brodo a ɛyɛ dɛ ne tetare a wɔde ngo afra ne ɔfam a wɔde ngo agu so. ");
INSERT INTO twi_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Fa brodo no gu kɛntɛn mu na fa nantwi ba no ne odwennini no ka ho bra Ahyiae Ntamadan no ano. ");
INSERT INTO twi_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Momfa Aaron ne ne mmabarima no mmra Ahyiae Ntamadan no kwan ano hɔ, na momfa nsu nguare wɔn. ");
INSERT INTO twi_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Momfa Aaron atade yuu no nhyɛ no. Monhyɛ no atade kɔnsin no, nʼasɔfotade no ne adɛbo no ne nkyekyeremu no, ");
INSERT INTO twi_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","na momfa abotiri a sikakɔkɔɔ bobɔ mu no mmɔ no. ");
INSERT INTO twi_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Momfa ɔsrango no na munhwie ngu ne ti so. ");
INSERT INTO twi_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ne mmabarima no nso, momfa wɔn ntade yuu no nhyehyɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Momfa wɔn nkyekyeremu no nka wɔn ho. Saa kwan yi so na momfa nhyɛ Aaron ne ne mma ne wɔn asefo mma wɔnyɛ asɔfo daa nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Mode nantwi ba no bɛba Ahyiae Ntamadan no anim na Aaron ne ne mmabarima de wɔn nsa agu aboa no apampam. ");
INSERT INTO twi_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Munkum no wɔ Awurade anim wɔ Ahyiae Ntamadan no kwan ano. ");
INSERT INTO twi_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Momfa ne mogya nsrasra mmɛn a etuatua afɔremuka no ho no so. Momfa mo nsateaa na ɛnyɛ, na munhwie mogya a ɛbɛka no ngu afɔremuka no ase. ");
INSERT INTO twi_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Munyi ne mu srade no ne ne bɔnwoma kotoku no ne ne asaabo abien no ne srade a ɛwɔ ho no na monhyew no wɔ afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Mmom momfa aboa no ne ne were ne nʼagyanan no mfi hɔ nkɔ afikyiri na monkɔhyew no sɛ bɔne ho afɔrebɔ. ");
INSERT INTO twi_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Sɛ wɔrebekum adwennini no nso a, Aaron ne ne mmabarima no mfa wɔn nsa ngu aboa no baako apampam ");
INSERT INTO twi_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","na wonkum no. Wɔnsɔw ne mogya no na wɔmfa mpete afɔremuka no ho nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Twitwa odwennini no asinasin na hohoro nʼayamde no mu ne nʼanan no ho; fa ne ti no ne nea moatwitwa no gu faako ");
INSERT INTO twi_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","na monhyew no wɔ afɔremuka no so; ɛyɛ ɔhyew afɔre a ɛsɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Momfa odwennini a aka no na Aaron ne ne mmabarima mfa wɔn nsa ngu nʼapampam, ");
INSERT INTO twi_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Munkum no na monsɔw mogya no bi na momfa ketewaa bi nsosɔ Aaron ne ne mmabarima no aso nifa, wɔn kokurobeti nifa ne wɔn anan nifa kokurobeti so. Afei mompete nkae no ngu afɔremuka no ho nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Montworɔw mogya a ɛwɔ afɔremuka no so no bi na momfa mfra ɔsrango na momfa mpete Aaron ne ne mmabarima no so ne wɔn ntade mu. Ɛnam saa so bɛma wɔn ne wɔn ntade ho atew wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Momfa odwennini no srade ne ne dua ne ne mu srade ne ne bɔnwoma kotoku ne nʼasaabo abien ne ɛho srade ne ne srɛ nifa. Eyi ne odwennini a wɔde bɛhyɛ Aaron ne ne mmabarima asɔfo no. ");
INSERT INTO twi_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Momfa brodo mua baako ne tetare a wɔde ɔsrango afra, na munyi ɔfam baako mfi kɛntɛn a wɔde brodo a mmɔkaw nni mu agu mu a wɔde asi Awurade anim no mu. ");
INSERT INTO twi_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Momfa eyinom nhyɛ Aaron ne ne mmabarima nsam na wɔmfa nkyerɛ sɛ afɔrebɔde mma Awurade. ");
INSERT INTO twi_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ɛno akyi no, munnye mfi wɔn nsam na monhyew no wɔ afɔremuka no so sɛ ohuam afɔre mma no. ");
INSERT INTO twi_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Momfa Aaron asɔfohyɛguan no yan no a munhim wɔ Awurade anim sɛ ohim afɔrebɔ, na ɛbɛyɛ mo kyɛfa. ");
INSERT INTO twi_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Montew asɔfohyɛ dwennini no akwaa, ne koko a wohimii ne ne srɛ a wɔde mae a ɛyɛ Aaron ne ne mmabarima de no ho. ");
INSERT INTO twi_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ɛsɛ sɛ eyi yɛ Israelfo asɛde sɛ wɔbɛyɛ ama Aaron ne ne mmabarima. Ɛyɛ Israelfo no fam asomdwoe afɔre a ɛsɛ sɛ wɔbɔ ma Awurade. ");
INSERT INTO twi_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Aaron ntade kronkron yi bɛyɛ nʼasefo de na wɔatumi ahyɛ ama wɔasra wɔn ngo ahyɛ wɔn asɔfo. ");
INSERT INTO twi_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ɔsɔfopanyin biara a obedi Aaron ade no bɛhyɛ saa ntade yi nnanson ansa na wafi nʼasɔfodwuma ase wɔ Ahyiae Ntamadan no mu ne kronkronbea hɔ. ");
INSERT INTO twi_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Fa odwennini no nam a wɔatew ho no ne odwennini nam a wɔde hyɛɛ ɔsɔfo no na monnoa no wɔ baabi a ɛhɔ tew. ");
INSERT INTO twi_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron ne ne mmabarima bedi brodo a ɛwɔ kɛntɛn no mu no, na wɔde nam no abɔ so wɔ Ahyiae Ntamadan no ano. ");
INSERT INTO twi_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Wɔn nko ara na wɔbɛwe nam no adi nnuan a wɔde tew wɔn ho no. Nnipa a wɔmfra asɔfo abusua no mu no renni bi, efisɛ wɔatew ho. ");
INSERT INTO twi_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Sɛ ade kye asɔfohyɛ dwennini anaa brodo no bi so a, monhyew. Ɛnsɛ sɛ wodi, efisɛ ɛyɛ kronkron. ");
INSERT INTO twi_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Eyi ne ɔkwan a momfa so nhyɛ Aaron ne ne mmabarima no asɔfo. Nnanson na wɔmfa nni saa asɔfohyɛ no ho dwuma. ");
INSERT INTO twi_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Da biara, mode nantwi ba bɛbɔ afɔre de adwira mo ho. Ɛno akyi no, mompra afɔremuka no ho bɔne nyinaa na monyɛ no kronkron na monhwie ngo ngu so mfa ntew ho. ");
INSERT INTO twi_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Montew afɔremuka no ho na daa monyɛ no kronkron saa ara nnanson mma Onyankopɔn. Ɛno akyi no, afɔremuka no ho bɛtew yiye sɛnea biribiara a wɔde bɛka no no bɛyɛ Onyankopɔn dea. ");
INSERT INTO twi_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Da biara, momfa nguanten mma abien a wɔadi afe mmɔ afɔre wɔ afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Momfa oguamma no baako mmɔ afɔre no anɔpa na momfa baako nso mmɔ afɔre anwummere. ");
INSERT INTO twi_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Afɔrebɔ a edi kan no, momfa asikresiam lita abien ne fa a wɔayam no muhumuhu mfra ngo a wɔakyi afi ngodua mu lita baako; saa ara na momfa bobesa lita baako nyɛ ahwiesa. ");
INSERT INTO twi_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Momfa oguan no baako a waka no mmɔ anwummere afɔre a asikresiam ne nsa ka ho te sɛ anɔpa de no ara. Ɛbɛyɛ ɔhyew afɔrehuam ama Awurade. ");
INSERT INTO twi_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Saa afɔrebɔ yi bɛkɔ so da biara wɔ Ahyiae Ntamadan no pon ano wɔ Awurade anim. Ɛhɔ na mehyia mo ne mo akasa. ");
INSERT INTO twi_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Na mehyia Israelmma wɔ hɔ na mʼanuonyam atew Ahyiae Ntamadan no ho. ");
INSERT INTO twi_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Ampa ara, mɛtew Ahyiae Ntamadan no ne afɔremuka no ho ne Aaron ne ne mmabarima a wɔyɛ mʼasɔfo no ho. ");
INSERT INTO twi_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Na mɛtena Israelfo mu na mayɛ wɔn Nyankopɔn, ");
INSERT INTO twi_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","na wobehu sɛ mene Awurade, wɔn Nyankopɔn. Mede wɔn fi Misraim bae sɛnea ɛbɛyɛ a, mɛtena wɔn mu. Mene Awurade wɔn Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Fa ɔkanto yɛ afɔremuka ketewa bi a wobɛhyew aduhuam wɔ so. ");
INSERT INTO twi_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ma ɛnyɛ ahinanan a ne fa biara susuw nsateaa dunwɔtwe, na ne sorokɔ nso nyɛ anammɔn abiɛsa a wɔasen; ne mmɛn a baako tua ho. ");
INSERT INTO twi_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Fa sikakɔkɔɔ dura ne soro, ne nkyɛn ne ne mmɛn a ɛwɔ afɔremuka no ho no nyinaa. Na fa sikakɔkɔɔ mmuano twa afɔremuka no ho nyinaa hyia. ");
INSERT INTO twi_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Fa sikakɔkɔɔ nkaa abien hyehyɛ mmuano no a ɛwɔ afanu no ase na wɔde nnua a wɔde bɛsoa no awurawura mu. ");
INSERT INTO twi_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Wɔmfa ɔkanto na ɛnyɛ nnua no, na wɔmfa sikakɔkɔɔ nnura ho nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Fa afɔremuka no si ntwamtam no akyi wɔ mpatabea hɔ a ɛbɔ faako a Apam Adaka a Mmaransɛm Du no wɔ no ho ban. Mehyia mo wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Da biara anɔpa, sɛ Aaron resiesie kanea no a, ɔbɛhyew aduhuam wɔ afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Anwummere biara, sɛ ɔsɔ kanea no a, ɔbɛhyew aduhuam wɔ Awurade anim ama awo ntoatoaso a ɛbɛba nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Monhyew aduhuam a wɔama ho kwan wɔ afɔremuka no so. Mommmɔ ɔhyew afɔre ne aduan afɔre wɔ so, na mommfa ahwiesa ngu so. ");
INSERT INTO twi_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Afe biara, ɛsɛ sɛ Aaron dwira afɔremuka no ho yɛ no kronkron. Ɔde mogya bɛsrasra mmɛn a etuatua ho no so sɛ mpata. Ɛsɛ sɛ afe biara wɔtew afɔremuka no ho yɛ no kronkron ma awo ntoatoaso a ɛbɛba no so kosi awo ntoatoaso so. Ɛyɛ kronkron ma Awurade.” ");
INSERT INTO twi_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Bere biara a wobɛkan Israelfo no, obiara a wɔbɛkan no no mfa ne kra ho mpata mmrɛ Awurade, sɛnea ɛbɛyɛ a ɔyaredɔm biara remma wɔn mu bi so. ");
INSERT INTO twi_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ɛsɛ sɛ obiara a wɔkan no no ma dwetɛbona fa, a emu duru yɛ gram asia (sɛnea kronkronbea mu dwetɛbona bo te no.) ");
INSERT INTO twi_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Obiara a wadi mfe aduonu rekɔ no na ɔbɛbɔ saa afɔre yi. ");
INSERT INTO twi_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ɛnsɛ sɛ adefo ma ma ɛboro sika a wɔatwa ato hɔ no so. Ɛnsɛ sɛ ahiafo nso ma nea esua sen saa, efisɛ ɛyɛ Awurade afɔre a ɔde retew yɛn ho ama yɛn. ");
INSERT INTO twi_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Momfa saa sika yi nsiesie Ahyiae Ntamadan no. Sɛ moyɛ saa a, ɛbɛma Awurade ani aba mo, Israelfo, so na ayɛ mpata nso ama mo.” ");
INSERT INTO twi_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Awurade ka kyerɛɛ Mose se. ");
INSERT INTO twi_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Fa kɔbere yɛ hweaseammɔ a ne nnyinaso nso yɛ kɔbere. Fa si Ahyiae Ntamadan no ne afɔremuka no ntam na fa nsu gu mu. ");
INSERT INTO twi_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ɛhɔ na Aaron ne ne mmabarima bɛhohoro wɔn nsa ne wɔn anan ho ");
INSERT INTO twi_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","bere a wɔrekɔ Ahyiae Ntamadan no mu de wɔn ho akɔkyerɛ Awurade, anaasɛ wɔrekɔ akɔbɔ afɔre wɔ afɔremuka no so ama Awurade no. Saa ara na bere biara a wɔrekodi saa dwuma yi no, ");
INSERT INTO twi_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ɛsɛ sɛ wɔhohoro wɔn ho na wɔanwuwu. Ɛsɛ sɛ eyi yɛ mmara a ɛbɛtena hɔ daa ama Aaron ne nʼasefo, awo ntoatoaso a ɛbɛba nyinaa.” ");
INSERT INTO twi_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Afei, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Hwehwɛ nnuhuam papa sɛ kurobow a ɛyɛ kilogram asia, sinamon kilogram abiɛsa ne mmetire huamhuam kilogram abiɛsa. ");
INSERT INTO twi_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Kurobow dodow a mobɛfa no nyɛ sɛ sinamon no dodow na momfa ngodua mu ngo lita anan. ");
INSERT INTO twi_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Awurade ahyɛ nnuhuamfrafo a wakwadaw ne yɛ mu yiye, sɛ wɔmfra saa nnuhuam yi mma ɛnyɛ ngo kronkron a wɔde tew onipa ho. ");
INSERT INTO twi_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Na momfa eyi ntew Ahyiae Ntamadan ne Apam Adaka, ");
INSERT INTO twi_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ɔpon no ne ɛho nkankyee nyinaa, kaneadua no ɛho nneɛma, nnuhuam afɔremuka no, ");
INSERT INTO twi_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ɔhyew afɔre ne ho nkankyee, ne hweaseammɔ ne nea esi so. ");
INSERT INTO twi_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Montew ho na ɛnyɛ kronkron na biribiara a ɛbɛka saa nneɛma yi no ho atew. ");
INSERT INTO twi_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Monsra Aaron ne ne mmabarima no sɛnea ɛbɛyɛ a wɔn ho bɛtew na wɔatumi ayɛ asɔfodwuma de asom me. ");
INSERT INTO twi_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Na monka nkyerɛ Israelfo se, ‘Eyi bɛyɛ me srango kronkron ama awo ntoatoaso a ɛbɛba no. ");
INSERT INTO twi_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ɛnsɛ sɛ wohwie gu obiara so kwa, na ɛnsɛ sɛ mo ankasa nso moyɛ bi, efisɛ ɛyɛ kronkron enti ɛsɛ sɛ mo nso moyɛ no kronkron. ");
INSERT INTO twi_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Obiara a ɔbɛfra aduhuam a ɛte sɛ ɛno na obehwie bi agu obi a ɔnyɛ ɔsɔfo so no, sɛ sɛ wo twa no asu.’ ” ");
INSERT INTO twi_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Awurade hyɛɛ mmara a ɛfa aduhuam no ho maa Mose se, “Fa nnuhuam atomude ne nworahuam ne prɛkɛsɛ huamhuam ne ohuamfufu gyenennyenen na wonsusuw ne nyinaa mu duru mma ɛnyɛ pɛ, ");
INSERT INTO twi_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","na fa yɛ aduhuam a wɔhyewee a aduhuamfrani a waben yɛ no bi, na wɔmfa nkyene mfra mu; na ɛbɛyɛ aduhuam kronkron. ");
INSERT INTO twi_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Monyam bi mma ɛnyɛ muhumuhu na momfa bi nsi Apam Adaka no anim faako a mehyia mo wɔ Ahyiae Ntamadan no mu hɔ no. Saa aduhuam yi ne nea ɛyɛ kronkron koraa wɔ ne nyinaa mu. ");
INSERT INTO twi_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Monnyɛ bi mfa, efisɛ wɔakora ama Awurade enti ɛsɛ sɛ moyɛ no kronkron. ");
INSERT INTO twi_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Obiara a ɔbɛyɛ bi afa no, wontwa no asu.” ");
INSERT INTO twi_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Mapaw Besaleel a ɔyɛ Uri babarima na ɔyɛ Hur nena a ofi Yuda abusua mu no ");
INSERT INTO twi_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","de Onyankopɔn Honhom, nyansa, ntease, nimdeɛ ne nnepa ahorow nyinaa ahyɛ no mma ");
INSERT INTO twi_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","sɛ ɔmfa nyɛ sika, dwetɛ ne kɔbere nnwinne ahorow, ");
INSERT INTO twi_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","sɛ ɔmfa nyɛ abo ne dua dwumfo ne adwinni ahorow nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Bio, mayi Ahisamak ba Oholiab a ofi Dan abusua mu sɛ ɔnyɛ ne boafo. “Ɛno akyi no, mama adwumayɛfo no nyinaa nimdeɛ sononko bi sɛnea ɛbɛyɛ a, wobetumi adi dwuma biara a makyerɛ sɛ munni no: ");
INSERT INTO twi_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“Ahyiae Ntamadan, Apam Adaka ne mpata agua ne Ahyiae Ntamadan no mu ahyehyɛde nkae no nyinaa; ");
INSERT INTO twi_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ɔpon no ne so nneɛma, sikakɔkɔɔ kaneadua ne ho nneɛma, ohuam afɔremuka; ");
INSERT INTO twi_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ɔhyew afɔremuka ne ho nneɛma, nsankason ne ne nnyinaso; ");
INSERT INTO twi_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ɔsɔfo Aaron ntade kronkron fɛɛfɛ no ne ne mma ntade bere a wɔsom sɛ asɔfo no; ");
INSERT INTO twi_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ne ɔsra ngo ne Kronkronbea hɔ aduhuam no. “Ɛsɛ sɛ wɔfa kwan a mɛkyerɛ wo no so na wɔyɛ eyinom nyinaa.” ");
INSERT INTO twi_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Afei, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Ka kyerɛ Israelfo no se, ‘Sɛ edu Homeda a, monhome. Eyi ne nsɛnkyerɛnne a ɛda me ne mo ne awo ntoatoaso a ɛbɛba no ntam, na moahu sɛ mene Awurade a meyɛ mo kronkron no.’ ");
INSERT INTO twi_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Munni Homeda no, efisɛ ɛyɛ da kronkron. Obiara a obebu saa mmara yi so no, obewu. Na nea ɔbɛyɛ adwuma saa da no nso, wobekum no. ");
INSERT INTO twi_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Nnansia na mode bɛyɛ adwuma. Na nnanson so no yɛ Homeda a wɔntoto no ase a ɛyɛ kronkron ma Awurade. Ɛsɛ sɛ wokum obiara a ɔbɛyɛ adwuma Homeda no. ");
INSERT INTO twi_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ɛsɛ sɛ Israelfo no di Homeda no, wonni mma awo ntoatoaso no nhu sɛ ɛyɛ apam afebɔɔ. ");
INSERT INTO twi_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ɛbɛyɛ daa apam a ɛda me ne Israelfo ntam no ho nsɛnkyerɛnne. Efisɛ nnansia mu na Awurade de bɔɔ ɔsoro ne asase, na ɔhomee da a ɛto so ason no.’ ” ");
INSERT INTO twi_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Onyankopɔn kasa kyerɛɛ Mose wɔ Sinai Bepɔw so wiee no, ɔde abo pon abien a ɔde ne nsa akyerɛw Mmaransɛm Du no wɔ so no maa no. ");
INSERT INTO twi_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mose kyɛe wɔ bepɔw no so saa no, nnipa no nyinaa kɔɔ Aaron so kɔka kyerɛɛ no se, “Ntɛm, yɛ anyame a wobedi yɛn anim ma yɛn, efisɛ yenhu baabi a Mose a odii yɛn anim de yɛn fi Misraim asase so baa ha no afa; ebia na biribi ayɛ no.” ");
INSERT INTO twi_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron nso ka kyerɛɛ wɔn se, “Munyiyi mo sika nsonkaa nyinaa mmra.” ");
INSERT INTO twi_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Wɔn nyinaa yiyii wɔn nsonkaa brɛɛ Aaron. ");
INSERT INTO twi_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aaron nan sikakɔkɔɔ nsonkaa no, na ɔde oguu nantwi ba ohoni. Nnipa no nyinaa kae se, “Israel, oyi ne mo nyame a oyii mo fii Misraim asase so bae no.” ");
INSERT INTO twi_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaron huu sɛ nnipa no ani agye sika nantwi ba ohoni no ho no, osii afɔremuka sii nantwi ba no anim kae se, “Ɔkyena yɛbɛhyɛ fa ama Awurade.” ");
INSERT INTO twi_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Wɔsɔree anɔpahema fii ase bɔɔ ɔhyew afɔre ne asomdwoe afɔre de maa nantwi ba ohoni no. Ɛno akyi no, wɔtoo pon kɛse, didi nomee, goruu abosongoru, yɛɛ ahuhude. ");
INSERT INTO twi_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Afei, Awurade ka kyerɛɛ Mose se, “Yɛ ntɛm na sian kɔ wo nkurɔfo a wode wɔn fi Misraim asase so bae no nkyɛn, efisɛ wɔagu wɔn ho fi, ");
INSERT INTO twi_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","na wɔabu me mmara nyinaa nso so. Wɔabɔ sika nantwi ba a wɔsom no, asan abɔ afɔre nso ama no aka se, ‘Israel, oyi ne mo nyame a oyii mo fii Misraim asase so bae no.’ ” ");
INSERT INTO twi_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Awurade kae se, “Mahu sɛnea saa nnipa yi si yɛ asoɔden na wɔsan yɛ atuatewfo fa. ");
INSERT INTO twi_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Afei, ma me kwan na memma mʼabufuw nnɛw ntia wɔn mma mensɛe wɔn. Na mɛyɛ wo ɔman kɛse.” ");
INSERT INTO twi_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Nanso Mose srɛɛ Onyankopɔn sɛ ɔnyɛ saa. Ɔkɔɔ so se, “Awurade, adɛn nti na ɛsɛ sɛ wʼabufuw dɛw atia wo ara wo nkurɔfo a wonam anwonwakwan ne wo tumi so yii wɔn fii Misraim asase so yi? ");
INSERT INTO twi_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Adɛn nti na ɛsɛ sɛ Misraimfo no ka se, ‘Onyankopɔn daadaa wɔn sɛ wɔmmra bepɔw no so sɛnea obenya wɔn akum wɔn, atɔre wɔn ase afi asase so?’ Ma wo bo ntɔ wo yam na gyae ɔsɛe a wopɛ sɛ wode ba wo nkurɔfo no so no. ");
INSERT INTO twi_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kae bɔ a wohyɛɛ wʼasomfo Abraham, Isak ne Israel no. Wo ara wokaa ntam se, ‘Mɛma mo asefo adɔɔso sɛ ɔsoro nsoromma na mede saa asase a mahyɛ mo ho bɔ yi nyinaa bɛma mo asefo na wɔatena so afebɔɔ.’ ” ");
INSERT INTO twi_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Na Awurade sesaa nʼadwene de wɔn ho kyɛɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Afei, Mose sian fii bepɔw no so bae a okura Mmaransɛm Du no a wɔakyerɛw agu abo apon abien akyi ne anim no. ");
INSERT INTO twi_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Onyankopɔn no ankasa na ɔkyerɛw mmaransɛm no wɔ apon no so. ");
INSERT INTO twi_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Bere a Yosua tee sɛ nnipa bi reyɛ gyegyeegye no, ɔka kyerɛɛ Mose se, “Ɛyɛ me sɛ wɔreboaboa wɔn ho akɔ ɔko!” ");
INSERT INTO twi_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ɛnna Mose nso buaa no se, “Ɛnyɛ nkonimdi mu nnyigyei na ɛnyɛ nkogu de, na mmom, ɛyɛ nnwonto nnyigyei na mete.” ");
INSERT INTO twi_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Wobeduu atenae hɔ, Mose huu nantwi ba no ne asaw a wɔresaw. Enti ɔde abufuwhyew tow kyerɛwapon no hwehwee fam ma ebubuu wɔ bepɔw no ase. ");
INSERT INTO twi_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ɔfaa nantwi ba no nan no wɔ ogya mu na edwoe no, ɔyam no muhumuhu de guu nsu mu maa nnipa no nomee. ");
INSERT INTO twi_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Obisaa Aaron se, “Dɛn nko ara na saa nnipa no yɛɛ wo a enti wudii wɔn anim ma wɔyɛɛ saa bɔne kɛse yi?” ");
INSERT INTO twi_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron buaa no se, “Mma wo bo mmfuw. Wo ara wunim sɛnea wo nkurɔfo yi yɛ nnipa bɔne fa. ");
INSERT INTO twi_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Wɔn ara na wɔka kyerɛɛ me se, ‘Yɛ onyame bi ma yɛn na ɔnkyerɛ yɛn kwan na yennim nea ayɛ saa Mose a odii yɛn anim fii Misraim no.’ ");
INSERT INTO twi_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Enti me nso mekae se, ‘Munyiyi mo sikakɔkɔɔ nsonkaa mma me.’ Woyiyi de maa me na mede guu gya mu. Ɛne saa nantwi ba no!” ");
INSERT INTO twi_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mose huu sɛ Aaron ama nnipa no adan aguamammɔfo ama wɔn atamfo anya wɔn no, ");
INSERT INTO twi_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ogyinaa wɔn atenae hɔ pon no ano teɛɛ mu se, “Mo a mowɔ Awurade afa no, mommra me nkyɛn.” Lewifo no nyinaa kɔɔ ne nkyɛn. ");
INSERT INTO twi_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ɔka kyerɛɛ wɔn se, “Awurade Israel Nyankopɔn se, ‘Momfa mo afoa nhyehyɛ mo ho na munni mo atenae hɔ akɔneaba, na munkunkum mo nuanom, mo nnamfonom ne mo afipamfo.’ ” ");
INSERT INTO twi_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Enti wɔyɛɛ saa maa nnipa bɛyɛ mpensa totɔɔ da no. ");
INSERT INTO twi_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Afei, Mose ka kyerɛɛ Lewifo no se, “Nnɛ, moatu mo ho asi hɔ sɛ mobɛsom Awurade, efisɛ moayɛ osetie ama no ama mpo, monam so akunkum mo mma ne mo nuanom, enti obehyira mo bebree.” ");
INSERT INTO twi_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ade kyee anɔpa no, Mose ka kyerɛɛ nkurɔfo no se, “Moayɛ bɔne a ɛso bi mmaa da, nanso mɛsan akɔ Awurade nkyɛn wɔ bepɔw no so akɔhwɛ sɛ ebia, menya bɔnefakyɛ ama mo ana.” ");
INSERT INTO twi_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Enti Mose san kɔɔ Awurade nkyɛn kɔka kyerɛɛ no se, “Ao, saa nnipa yi ayɛ bɔne a ɛso bi mmaa da, na wɔde sikakɔkɔɔ ayɛ wɔn anyame. ");
INSERT INTO twi_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Enti meredi ama wɔn sɛ, fa wɔn bɔne kyɛ wɔn, na sɛ ɛnte saa nso a, pepa me din fi nhoma a woakyerɛw no mu.” ");
INSERT INTO twi_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Awurade buaa Mose se, “Obiara a wayɛ me bɔne no, mɛpepa no afi me nhoma mu. ");
INSERT INTO twi_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Enti afei, kɔ na di nkurɔfo no anim kɔ baabi a mekyerɛɛ wo no na mehyɛ wo bɔ sɛ mɛma me bɔfo adi wʼanim; nanso sɛ mebɛsra nkurɔfo no a, mɛtwe wɔn aso wɔ wɔn bɔne no ho.” ");
INSERT INTO twi_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Na esiane sɛ nnipa no som Aaron nantwi ba no nti, ɔtew ɔyare guu wɔn so. ");
INSERT INTO twi_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Awurade ka kyerɛɛ Mose se, “Di saa nnipa a wode wɔn fi Misraim asase so no anim kɔ asase a mede hyɛɛ Abraham, Isak ne Yakob bɔ no so, efisɛ mekae se, ‘Mede saa asase yi bɛma wʼasefo.’ ");
INSERT INTO twi_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mɛsoma ɔbɔfo adi wʼanim na wapam Kanaanfo, Amorifo, Hetifo, Perisifo, Hewifo ne Yebusifo. ");
INSERT INTO twi_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ɛyɛ asase a ɛwo ne nufusu sen wɔ so. Na me ne mo rentu saa kwan no efisɛ moyɛ nnipa a mo aso yɛ den, na anyɛ a na makɔsɛe mo wɔ ɔkwan so.” ");
INSERT INTO twi_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Nnipa yi tee saa nsɛnhyew yi no, wotwaa agyaadwo na wɔworɔworɔw wɔn ho nkaa ne nnwinne nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Awurade ka kyerɛɛ Mose se ɔnka nkyerɛ wɔn se, “Moyɛ nnipa a mo aso yɛ den. Na sɛ me ne mo tena bɛyɛ simma baako pɛ koraa mpo a, anyɛ a na matɔre mo ase. Monworɔworɔw mo nkaa ne mo nnwinne a mohyehyɛ no nyinaa na mehu nea mɛyɛ mo.” ");
INSERT INTO twi_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Eyi akyi no, obiara worɔw ne nnwinne wɔ Bepɔw Horeb so. ");
INSERT INTO twi_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Na Mose sii ahyiae ntamadan wɔ nsraban no akyi a obiara a ɔpɛ sɛ ɔne Awurade di nkitaho no kɔ hɔ. Wɔtoo dan no din Ahyiae. ");
INSERT INTO twi_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Bere biara a Mose bɛkɔ Ahyiae Ntamadan no mu no, nnipa no nyinaa sɔre begyina wɔn ntamadan no ano hwɛ no kosi sɛ obedu ɔdan no ano. ");
INSERT INTO twi_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ɔrewura mu a, omununkum fadum behyia no wɔ ɔkwan no ano na Awurade nam mu ne Mose akasa. ");
INSERT INTO twi_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Bere biara a nnipa no behu omununkum fadum no sɛ egyina ntamadan no pon ano no, wɔn nyinaa bɛsɔre akotow nea wobehu wɔ wɔn ntamadan no pon ano no. ");
INSERT INTO twi_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ɔdan no mu, na Awurade kasa kyerɛ Mose anim ne anim, sɛnea obi ne nʼadamfo di nkɔmmɔ. Na sɛ Mose san kɔ nsraban no hɔ a, aberante a ɔboa no a wɔfrɛ no Yosua (Nun ba) no de, ɔtena Ahyiae Ntamadan no mu ara kosi sɛ Mose bɛsan aba. ");
INSERT INTO twi_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mose ka kyerɛɛ Awurade se, “Daa woka kyerɛ me se, ‘Fa saa nnipa yi kɔ bɔhyɛ asase no so, nanso wonkyerɛɛ me onipa a ɔnka me ho ne me nkɔ. Wuse woyɛ mʼadamfo a woayɛ me adɔe bebree.’ ");
INSERT INTO twi_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Na sɛ saa na ɛte a, di mʼanim kyerɛ me faako a ɛyɛ wo pɛ sɛ mefa na ama mate wo ase na mafa wo kwan so pɛpɛɛpɛ. Na mma wo werɛ mfi sɛ saa ɔman yi yɛ wo nkurɔfo.” ");
INSERT INTO twi_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Na Awurade buaa no se, “Mʼankasa me ne wo bɛkɔ na woadi nkonim.” ");
INSERT INTO twi_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Nanso Mose kae se, “Sɛ wo ne yɛn renkɔ de a, mma yemmfi ha nnkɔ. ");
INSERT INTO twi_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Sɛ wo ne yɛn ankɔ a, hena na obehu sɛ me ne me nkurɔfo anya wo hɔ adom a ama nsonoe abɛda yɛn ne asase sofo a wɔaka no ntam?” ");
INSERT INTO twi_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Awurade buaa Mose se, “Ampa ara, mɛyɛ wʼabisade ama wo, efisɛ woanya ahummɔbɔ afi me nkyɛn na woyɛ mʼadamfo.” ");
INSERT INTO twi_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Na Mose srɛɛ sɛ ɔpɛ sɛ ohu Onyankopɔn anuonyam. ");
INSERT INTO twi_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Awurade buae se, “Mɛma mo ahu mʼadɔe, na mɛbɔ me din Awurade no akyerɛ mo. Nea mepɛ sɛ mihu no mmɔbɔ no, mehu no mmɔbɔ, na nea mepɛ sɛ meyɛ no adɔe nso, mɛyɛ no adɔe. ");
INSERT INTO twi_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Nanso morenhu mʼanuonyam, efisɛ obiara renhu mʼanim ntena nkwa mu. ");
INSERT INTO twi_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“Nanso gyina ɔbotan yi so wɔ me nkyɛn ha. ");
INSERT INTO twi_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Na sɛ mʼanuonyam resen a, mede wo bɛhyɛ ɔbotan no mu na mede me nsa akata wo so akosi sɛ metwa mu. ");
INSERT INTO twi_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Afei, meyi me nsa na woahu mʼakyi, na mʼanim de, ɛnsɛ sɛ wohu.” ");
INSERT INTO twi_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Awurade ka kyerɛɛ Mose se, “Yɛ abo kyerɛw apon abien te sɛ nea woyɛɛ kan no na mɛkyerɛw mmara koro no ara sɛnea na ɛwɔ nea wububuu mu no so ara pɛ ama wo. ");
INSERT INTO twi_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Siesie wo ho na bra Sinai Bepɔw so anɔpa na fa wo ho bɛkyerɛ me. ");
INSERT INTO twi_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Mfa obiara nka wo ho na ɛnsɛ sɛ obiara bɛn bepɔw no ho baabiara. Mma mmoa biara nkɔ adidi mmɛn bepɔw no.” ");
INSERT INTO twi_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Enti Mose twaa kyerɛw apon abien te sɛ kan de no de kɔɔ Sinai Bepɔw so anɔpahema sɛnea Awurade hyɛe no no. ");
INSERT INTO twi_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Awurade sian baa sɛ omununkum fadum begyinaa Mose ho bɔɔ ne din kronkron Awurade no. ");
INSERT INTO twi_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Awurade faa Mose anim frɛɛ no kae se, “Me, Awurade, Onyankopɔn mmɔborɔhunufo ne ɔdomfo a me bo kyɛ fuw na mewɔ ɔdɔ na midi nokware nso; ");
INSERT INTO twi_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","me Awurade, medɔ nnipa mpempem na mede atirimɔden, atuatew ne bɔne kyɛ. Nanso metwe afɔdi aso na metwe Agyanom, mma ne nananom aso kosi awo ntoatoaso abiɛsa ne anan aso.” ");
INSERT INTO twi_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mose kotow Awurade som no. ");
INSERT INTO twi_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ɔkae se, “Sɛ ɛyɛ nokware pa ara sɛ woagye me ato mu de a, Awurade, wo ne yɛnkɔ bɔhyɛ asase no so. Saa nnipa yi aso yɛ den de, nanso fa yɛn bɔne kyɛ yɛn na gye yɛn sɛ wo ara wo nnipa.” ");
INSERT INTO twi_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Awurade buae se, “Eye, me ne wo bɛyɛ nhyehyɛe bi. Merebɛyɛ anwonwade bi a bi nsii asase so da, na ɛnam so ama Israelfo nyinaa ahu tumi a Awurade wɔ. Menam wo so na mɛyɛ saa tumide no. ");
INSERT INTO twi_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Wo fam de a wobɛyɛ ara ne sɛ, wubetie nsɛm a mɛhyɛ wo no na woayɛ ne nyinaa; na sɛ ɛba saa a, mɛpam Amorifo, Kanaanfo, Hetifo, Perisifo, Hewifo ne Yebusifo no nyinaa afi wʼanim. ");
INSERT INTO twi_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Hwɛ wo ho so yiye pa ara na wo ne ɔman a worekɔ mu no mufo ampam, anyɛ saa a, wɔbɛyɛ mfiri wɔ mo mu a ebeyiyi mo. ");
INSERT INTO twi_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Bubu wɔn abosonsom afɔremuka no. Sɛe wɔn abo adum no na muntutu wɔn abosom no ngu. ");
INSERT INTO twi_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Na monnsom onyame foforo biara nka Awurade ho, na ɔno nko ara ne Onyankopɔn a ɛsɛ sɛ mosom no. ");
INSERT INTO twi_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Wo ne onipa biara a ɔte asase no so nnyɛ asomdwoe apam biara, efisɛ wonni me nokware, na wɔbɔ afɔre ma wɔn anyame de tia me. Sɛ wo ne wɔn yɛ adwene a, wɔbɛto nsa afrɛ wo ama woakodi wɔn abosom so nnuan. ");
INSERT INTO twi_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Afei nso, ɛyɛ saa a, mubegye wɔn mmabea aware ama mo mmabarima no akɔsom wɔn yerenom no anyame bi de atia me. ");
INSERT INTO twi_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Monnyɛ ahoni biara. ");
INSERT INTO twi_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Munni Apiti Afahyɛ no. Munni brodo a mmɔkaw nni mu nnanson sɛnea meka kyerɛɛ mo no. Monyɛ eyi afe biara mu ɔsram Abib (Yudafo ɔsram a edi kan) mu, efisɛ saa ɔsram no mu na mutu fii Misraim. ");
INSERT INTO twi_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Abakan biara yɛ me dea, sɛ ɛyɛ nantwi, oguan anaa abirekyi. ");
INSERT INTO twi_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Afurum ba a ɔyɛ abakan de, wɔmfa no nsesa oguamma. Na sɛ wompɛ sɛ wode no di nsesa de a, bu ne kɔn mu. Mo mmabarima de, munnye wɔn nyinaa. “Obiara mma mʼanim a onkura akyɛde bi. ");
INSERT INTO twi_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Nnansia pɛ na momfa nyɛ adwuma. Da a ɛto so ason no de, munnni dwuma biara. Ofuntumbere anaa otwabere mpo, momfa nnansia nyɛ adwuma. Da a ɛto so ason no, monhome. ");
INSERT INTO twi_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Monkae na munni saa afahyɛ abiɛsa a ɛwɔ afe mu no nyinaa. Eyinom ne: Otwabere Afahyɛ (anaasɛ Pentekoste), Atoko a edi kan Afahyɛ ne Asese Afahyɛ. ");
INSERT INTO twi_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Saa afahyɛ abiɛsa yi mu biara du so a, ɛsɛ sɛ Israelfo mmarima ne mmarimaa nyinaa ba Awurade anim. ");
INSERT INTO twi_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Sɛ mokɔ Awurade mo Nyankopɔn anim saa mprɛnsa no nyinaa afe biara mu a, obiara nni hɔ a ɔbɛtoa mo abedi mo asase no so. Mɛpam saa aman no wɔ mo anim na matrɛw mo ahye mu. ");
INSERT INTO twi_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Mommfa brodo a mmɔkaw wɔ mu mmɔ me afɔre. Na Twam Afahyɛ nam no nso, mommfa bi nsi hɔ mma ade nkye so. ");
INSERT INTO twi_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Sɛ mutwa mo nnɔbae a, Momfa mo nnɔbae mu nea ɛsɔ ani koraa no mmra Awurade mo Nyankopɔn fi. “Monnoa abirekyi ba wɔ ne na nufusu mu.” ");
INSERT INTO twi_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Na Awurade ka kyerɛɛ Mose se, “Kyerɛw saa mmara a mede ama wo yi nyinaa gu hɔ, efisɛ ɛyɛ me ne wo, Israel ntam apam.” ");
INSERT INTO twi_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mose ne Awurade de adaduanan, awia ne anadwo, dii nkitaho wɔ bepɔw no so, na saa bere no, Mose annidi, annom. Saa bere no, Onyankopɔn kyerɛw Mmaransɛm Du no guu ɔbo kyerɛwpon no so. ");
INSERT INTO twi_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Bere a Mose de kyerɛw apon no fi Onyankopɔn nkyɛn resian bepɔw no, na onnim sɛ nʼanim rehyerɛn. ");
INSERT INTO twi_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Esiane nʼanim hyerɛn a na ɛhyerɛn no nti, Aaron ne Israelfo no huu Mose no, wosuroe sɛ wɔbɛbɛn no. ");
INSERT INTO twi_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Nanso Mose frɛɛ wɔn baa ne nkyɛn maa Aaron ne ɔman no mu ntuanofo ne no bɛkasae. ");
INSERT INTO twi_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Akyiri no, nnipa no nyinaa baa ne nkyɛn ma ɔde mmaransɛm a Awurade de maa no wɔ bepɔw no so hɔ no maa wɔn. ");
INSERT INTO twi_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mose ne wɔn kasa wiee no, ɔde nkataanim kataa nʼanim, ");
INSERT INTO twi_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","na bere biara a ɔbɛkɔ Ahyiae Ntamadan mu hɔ ne Awurade akɔkasa no, oyi nkataanim no kosi sɛ ɔbɛsan aba bio; ɔba saa a, asɛm biara a Onyankopɔn aka akyerɛ no no, na ɔno nso ka kyerɛ nnipa no ");
INSERT INTO twi_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","a wohu sɛ nʼanim ayɛ hyerɛnn no. Akyiri no, ɔde nkataanim no kata nʼanim bio kosi sɛ ɔbɛkɔ Onyankopɔn nkyɛn na ɔne no akɔkasa. ");
INSERT INTO twi_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Afei, Mose frɛɛ Israelmma nyinaa ne wɔn yɛɛ nhyiamu ka kyerɛɛ wɔn se, “Eyi ne Awurade mmara a ɛsɛ sɛ mudi so. ");
INSERT INTO twi_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Monyɛ adwuma nnansia. Na da a ɛto so ason no de, momfa nhome; ɛyɛ da kronkron a ɛsɛ sɛ mode som Awurade. Obiara a ɔbɛyɛ adwuma biara saa da no, ɛsɛ sɛ wokum no. ");
INSERT INTO twi_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Da no, ogya mpo, monnsɔ bi ano wɔ mo afi mu.” ");
INSERT INTO twi_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mose ka kyerɛɛ nnipa no nyinaa se, “Nsɛm a Awurade ahyɛ sɛ monyɛ ni: ");
INSERT INTO twi_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Obiara a ɔpɛ no mfa saa afɔrebɔde yi mu biara mmrɛ Awurade: “Sikakɔkɔɔ, dwetɛ, kɔbere mfrafrae; ");
INSERT INTO twi_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ntama a wɔde asaawa tuntum, bibiri ne koogyan ayɛ ne abirekyi nwi, ");
INSERT INTO twi_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","odwennini nwoma a wɔahyɛ no aduru kɔkɔɔ ne abirekyi nwoma a wɔahyɛ, ɔkanto dua; ");
INSERT INTO twi_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ngo a wɔde begu akanea no mu, ɔhyew nnuhuam a wɔde bɛyɛ ɔsrango ne; ɔhyew aduhuam; ");
INSERT INTO twi_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","abo a ɛte sɛ apopobibiri ne abo a wɔde bɛhyehyɛ asɔfotade no ne nʼadɛbo no mu. ");
INSERT INTO twi_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Mo a mowɔ nimdeɛ wɔ biribiyɛ ho no, mo nyinaa mommra na monyɛ nea Awurade aka no nyinaa te sɛ: ");
INSERT INTO twi_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“Ahyiae Ntamadan no so ntama ne ne nkataso, nkɔtɔkoro, mpuran nnua a esisi mu, adum ne nnyinaso; ");
INSERT INTO twi_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Apam Adaka no ne nnua a esisi ho; Mpata agua ntwamtam a ɛkata kronkronbea hɔ, ");
INSERT INTO twi_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ɔpon ne nnua a wɔde soa ne ɛho nneɛma nyinaa, Ɔkyerɛ Brodo; ");
INSERT INTO twi_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","akanea nnua ne nʼakanea ne ngo; ");
INSERT INTO twi_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","aduhuam afɔremuka ne nnua a wɔde bɛsoa; ɔsrango ne aduhuam a eyi hua pa, nsɛnanim a wɔde bɛsɛn Ahyiae Ntamadan no pon ano; ");
INSERT INTO twi_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","kɔbere Afɔremuka a wɔde bɛbɔ ɔhyew afɔre, kɔbere ntwitae ne nnua a wɔde bɛsoa ho nneɛma, ne nea wɔhoro mu nneɛma ne ne ntaamu, ");
INSERT INTO twi_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","adiwo hɔ no ntwamtam, adum ne ne nnyinaso, ntama a wɔde bɛkata adiwo hɔ kwan ano, ");
INSERT INTO twi_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Ahyiae Ntamadan no adiwo hɔ nnua ne ne ntampehama, ");
INSERT INTO twi_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","asɔfotade a ɛyɛ fɛ a ɔsɔfo no bɛhyɛ asɔre wɔ kronkronbea hɔ ne Aaron ntade kronkron a sɛ ne mmabarima no yɛ asɔfodwuma a, wɔbɛhyɛ bi.” ");
INSERT INTO twi_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Na Israelmma nyinaa fii Mose anim, ");
INSERT INTO twi_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","na wɔn a Onyankopɔn honhom kaa wɔn koma no de wɔn akyɛde a wɔde besi Ahyiae Ntamadan no ne ɛho nneɛma ne nea wɔde bɛpam atade kronkron no bae. ");
INSERT INTO twi_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Mmea ne mmarima a asɛm no kaa wɔn koma no nyinaa bae. Wɔde sikakɔkɔɔ, agude, nsonkaa, nkaa, kɔnmuade ne sika adwinne bebree brɛɛ Awurade. ");
INSERT INTO twi_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Wɔn a wɔwɔ ntama pa, kuntu a ɛyɛ tuntum, bibiri, abirekyi nwoma a wɔahyɛ, odwennini nwoma a wɔahyɛ no kɔkɔɔ anaa aboa nwoma a ɛyɛ fɛ nso de bae. ");
INSERT INTO twi_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Afoforo nso de dwetɛ ne kɔbere brɛɛ Awurade sɛ wɔn akyɛde. Ebinom de ɔkanto nnua nso bae. ");
INSERT INTO twi_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Mmea no bi a wonim adepam yiye no too asaawa tuntum, bibiri ne koogyan de yɛɛ ntama a ɛyɛ fɛ de brɛɛ Awurade. ");
INSERT INTO twi_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Afoforo nso de anigye nam wɔn dom akyɛde so de abirekyi nwi yɛɛ ntama. ");
INSERT INTO twi_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Mpanyimfo a wodi wɔn anim no de abo a ɛte sɛ apopobibiri bae sɛ wɔmfa nyɛ asɔfotade no ne nʼadɛbo. ");
INSERT INTO twi_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Wɔde nnuhuam ne ngo a wɔde begu akanea mu ne nea wɔde bɛfra ɔsrango no ne nnuhuam no ama adi mu no nso bae. ");
INSERT INTO twi_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Eyi di ho adanse sɛ Israel mmarima ne mmea a na wɔpɛ sɛ wɔboa dwumadi a Awurade nam Mose so de hyɛɛ wɔn nsa no fi wɔn pɛ mu de wɔn akyɛde brɛɛ no. ");
INSERT INTO twi_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mose ka kyerɛɛ Israelfo no se, “Awurade ayi Besaleel, Uri ba a ɔyɛ Hur a ofi Yuda abusua mu nena ");
INSERT INTO twi_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","no sɛ ɔno Onyankopɔn Honhom ahyɛ no ma. Wama no nyansa, tumi ne adwene a ɔde besi Ahyiae Ntamadan no ayɛ biribiara a ɛwɔ mu. ");
INSERT INTO twi_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Obetumi adi adwinni afi sikakɔkɔɔ, dwetɛ, ne kɔbere mu. ");
INSERT INTO twi_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Obetumi adi abo adwinni na obetumi asen nnua nso; nokware mu, ɔwɔ ɔdom akyɛde bebree. ");
INSERT INTO twi_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Na Onyankopɔn ama ɔno ne Oholiab a ɔyɛ Ahisamak a ofi Dan abusuakuw mu babarima ɔdom akyɛde a wɔnam so kyerɛ afoforo ade. ");
INSERT INTO twi_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Onyankopɔn ama wɔn baanu akyɛde sononko sɛ adwumfo, duadwumfo, adenwenfo a wotumi nwen nneɛma a ɛyɛ fɛ gu ntama pa a ɛyɛ tuntum, bibiri ne koogyan mu. Wonim saa adwinne yi nyinaa di ma ɛboro so. ");
INSERT INTO twi_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Adwumfo a wɔaka a Onyankopɔn ama wɔn ɔdom akyɛde no nyinaa bɛboa Besaleel ne Oholiab na wɔasi asiesie Ahyiae Ntamadan no mu sɛnea Awurade ahyɛ no.” ");
INSERT INTO twi_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Enti Mose ka kyerɛɛ Besaleel ne Oholiab ne wɔn a wɔaka na wɔte nka sɛ ɛsɛ sɛ wɔboa dwumadi no sɛ womfiti ase. ");
INSERT INTO twi_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Mose de nneɛma a nnipa no de bɛkyɛɛ no maa wɔn, na adekyee biara nso, na wonya akyɛde foforo. ");
INSERT INTO twi_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Akyiri no, adwumayɛfo no nyinaa gyaee wɔn adwumayɛ no ");
INSERT INTO twi_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","kɔɔ Mose nkyɛn kɔka kyerɛɛ no se, “Nneɛma a yɛn nsa aka no dɔɔso sen nea yehia.” ");
INSERT INTO twi_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Enti Mose somaa obi maa ɔkɔɔ wɔn nyinaa so kɔka kyerɛɛ wɔn se, afei de, obiara mmmɛkyɛ wɔn ade bio. Na obiara amfa hwee amma bio. ");
INSERT INTO twi_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Efisɛ na nneɛma a wɔwɔ no bɛso dwuma no di ama aboro so mpo. ");
INSERT INTO twi_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Wɔn a wonim adwinni pa ara no de asaawa a wɔanwen yɛɛ Ntamadan no nsɛnanotam du a emu bi yɛ tuntum, bibiri ne koogyan a wɔayɛ kerubim agu mu. ");
INSERT INTO twi_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Nkataano du no nyinaa kɛse yɛ pɛ. Emu biara tenten yɛ anammɔn aduanan abien na ne trɛw nso yɛ anammɔn asia. ");
INSERT INTO twi_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Wɔkekaa ntama bamma anum sisii anim nyaa nkataano baako. Na wɔkekaa ntama bamma anum a aka no nso sisii anim nyaa nkataano foforo. ");
INSERT INTO twi_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Wɔde ntama bibiri bamma aduonum wurawuraa nkataano a wɔkeka sisii anim no mu biara ano ");
INSERT INTO twi_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","a hentia baako biara ne baako di nhwɛanim. ");
INSERT INTO twi_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Afei, wɔyɛɛ sika nkɔtɔkoro aduonum de susoo nkɔtɔkoro no mu maa nkataano ahorow abien no yɛɛ nkataano baako. ");
INSERT INTO twi_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Wɔde ntama nkataso dubaako a wɔde mmirekyi nwi na ayɛ ");
INSERT INTO twi_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","a ne nyinaa tenten yɛ anammɔn aduanan anum na ne trɛw yɛ anammɔn asia kataa Ntamadan no so. ");
INSERT INTO twi_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Besaleel kekaa saa nkataso yi anum sisii anim ma ɛyɛɛ bamma tenten baako na ɔsan de afoforo asia sisii anim maa ɛno nso yɛɛ bamma tenten baako. ");
INSERT INTO twi_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Afei, ɔbobɔɔ nkɔtɔkoro aduonum wɔ emu biara ano ");
INSERT INTO twi_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","na ɔyɛɛ kɔbere nkɔtɔkoro aduonum de koakoaa nkɔtɔkoro no, sɛnea ɛbɛma nkataho no akyere pintinn. ");
INSERT INTO twi_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Wosiesiee nneɛma ahorow abien de bɔɔ ɔdan no so. Nea edi kan no yɛ odwennini were a wahyɛ no kɔkɔɔ, nea ɛto so abien yɛ abirekyi were a ɛsɔ. ");
INSERT INTO twi_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Wɔde ɔkanto yɛɛ ntaaboo de twaa Ahyiae Ntamadan no ho. ");
INSERT INTO twi_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Mpuran biara sorokɔ nyɛ anammɔn dunum na ne trɛw nyɛ anammɔn abien ne kakra, ");
INSERT INTO twi_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","nkɔtɔkoro abien wɔ mpuran biara ase, na mpuran biara yɛ pɛ. ");
INSERT INTO twi_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Na Ahyiae Ntamadan no ntaaboo aduonu kyerɛ nʼanafo ");
INSERT INTO twi_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","a wɔn ase sisi dwetɛ nnyinaso aduanan so. Nnyinaso no abien abien hyehyɛ mpuran biara ase. ");
INSERT INTO twi_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ahyiae Ntamadan no atifi fam nso, na wɔde ntaaboo aduonu atwa ho ");
INSERT INTO twi_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","a esisi dwetɛ nnyinaso aduanan so a mpuran baako besi nnyinaso abien so. ");
INSERT INTO twi_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ahyiae Ntamadan no fa a ɛkyerɛ atɔe fam no yɛ nʼakyi. Ɛno nso, wɔde ntaaboo asia na atwa ho, ");
INSERT INTO twi_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","na ne twɔtwɔw biara so nso ntaaboo abien sisi hɔ. ");
INSERT INTO twi_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Na mpuran a ɛbobɔ so abien abien sisi twɔtwɔw abien no biara so fi ase de kosi soro a wɔde nkaa asuso mu a ne nyinaa yɛ pɛ. ");
INSERT INTO twi_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Enti mpuran awotwe ne dwetɛ nnyinaso dunsia a abien wɔ mpuran biara ase na wɔde yɛe. ");
INSERT INTO twi_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Afei, ɔyɛɛ ɔkanto nnua bi de beabeaa ntaaboo no mu. Mmeamu nnua no anum kɔ mpuran no fa baako. ");
INSERT INTO twi_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Wɔyɛɛ afoforo anum nso kɔɔ ɔfa baako. Na mmeamu nnua no anum bɔ ntaaboo a ɛwɔ ntamadan no akyi a ani kyerɛ atɔe fam. ");
INSERT INTO twi_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Wɔbɔɔ mmeamu dua baako de bɔɔ ntaaboo no mfimfini. Wɔde twaa mu fi ti kɔkaa ti. ");
INSERT INTO twi_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Na wɔde sikakɔkɔɔ adura ntaaboo no ho, na wɔde sikakɔkɔɔ nkaa asuso mmeamu dua no mu ama no agyina. Na sikakɔkɔɔ dura mmeamu dua no nso ho. ");
INSERT INTO twi_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Wɔde ntama pa a ɛyɛ tuntum, bibiri ne koogyan a wɔanwen kerubim agu mu fɛfɛɛfɛ na ayɛ ntwamtam no wɔ Ntamadan no mu. ");
INSERT INTO twi_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Na wɔyɛɛ ɔkanto nnua afadum anan a wɔde sikakɔkɔɔ adura ho ne sikakɔkɔɔ nsusomu anan maa ntwamtam no. Na afadum anan no mu biara si dwetɛ nnyinaso anan no baako so. ");
INSERT INTO twi_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Afei, wɔyɛɛ Ahyiae Ntamadan no ano nkataanim. Wɔde asaawatam a ɛyɛ fɛ a wɔde tuntum, bibiri ne koogyan adi mu adwinni na ɛyɛe. ");
INSERT INTO twi_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Wɔde nkɔtɔkoro anum na asuso saa nkataanim yi mu de akyekyere nnua anum no. Nnua no ne ɛho nneɛma ne pema no nyinaa, wɔde sikakɔkɔɔ adura ho na ne nnyinaso anum no nso, wɔde kɔbere na ɛyɛe. ");
INSERT INTO twi_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Afei, Besaleel yɛɛ Apam Adaka no. Ɔde ɔkanto na ɛyɛe. Na ne tenten yɛ anammɔn abiɛsa ne fa, ne trɛw nso yɛ anammɔn abien ne fa ne ntwemu ne sorokɔ nso yɛ anammɔn abien ne fa. ");
INSERT INTO twi_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Na wɔde sikakɔkɔɔ duraa ho ne emu nyinaa na wɔde bi beabea ho nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Na wɔde sikakɔkɔɔ nkaa hyehyɛɛ nʼanan anan no a nkaa abien wɔ ɔfa biara. ");
INSERT INTO twi_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Osen ɔkanto nnua bi de sikakɔkɔɔ duraa ho. ");
INSERT INTO twi_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Na wɔde nnua no hyehyɛɛ adaka no nkyɛn nkaa no mu wɔde bɛsoa. ");
INSERT INTO twi_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Afei, ɔde sikakɔkɔɔ ankasa yɛɛ ne mmuaso a wɔfrɛ no Mpata Agua. Na ne ntwemu yɛ anammɔn abiɛsa ne fa, na ne trɛw nso yɛ anammɔn abien ne fa. ");
INSERT INTO twi_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ɔboroo sikakɔkɔɔ ma ɛyɛɛ tratraa de yɛɛ kerubim abien na ɔde tetaree adaka no mmuaso no ti ne ti. ");
INSERT INTO twi_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Wɔde kerubim no tetaree adaka no atifi ne nʼanafo na ɛne adaka no nkataso no yɛɛ baako. ");
INSERT INTO twi_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Na kerubim no di nhwɛanim a wɔasisi wɔn ti ase rehwɛ Mpata Agua no na wɔatrɛtrɛw wɔn ntaban mu akata so. ");
INSERT INTO twi_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Afei, ɔde ɔkanto yɛɛ ɔpon a ne ntwemu yɛ anammɔn abiɛsa; ne trɛw yɛ ɔnammɔn baako ne fa na ne sorokɔ yɛ anammɔn abien ne fa. ");
INSERT INTO twi_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Na wɔde sikakɔkɔɔ duraa ho na woguu bi wɔ ne ntwea so nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Wɔyɛɛ adaka no ho ntetareho a ne trɛw yɛ nsateaa anan twaa ɔpon no ano ho hyiae, na wɔde sikakɔkɔɔ hankare faa ho. ");
INSERT INTO twi_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Afei, wɔyɛɛ sikakɔkɔɔ nkaa anan, na ɔde hyehyɛɛ ɔpon no anan anan no nyinaa ase. ");
INSERT INTO twi_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Wɔde nnua no hyehyɛɛ saa nkaa no mu a wɔde bɛma ɔpon no so asoa. ");
INSERT INTO twi_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Wɔde ɔkanto nnua a wɔde sikakɔkɔɔ agu ho yɛɛ nnua a wɔde bɛsoa. ");
INSERT INTO twi_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Wɔde sikakɔkɔɔ yɛɛ nsanka, mprɛte, nsukuruwa ne nkoraa. Saa nneɛma yi na wɔde bedi ahwiesa afɔrebɔ ho dwuma. ");
INSERT INTO twi_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Bio, wɔde sikakɔkɔɔ a wɔaboro yɛɛ kaneadua. Ne nnyinaso, nʼabaa, nea wɔde akanea no hyehyɛ mu ne nhwiren a wɔde siesiee no nyinaa bɔ mu yɛ ade baako. ");
INSERT INTO twi_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Kaneadua a ɛhyɛ mfimfini no wɔ nkorata asia a abiɛsa wɔ fa na abiɛsa nso wɔ fa. ");
INSERT INTO twi_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Wɔde nhwiren abiɛsa siesiee nkorata biara ho. ");
INSERT INTO twi_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na saa ara nso na kaneadua no, wodii nhwiren a ɛyɛ fɛ bi adwinni de siesiee no. ");
INSERT INTO twi_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Nhwiren no bi wɔ ne dua no ase wɔ nkorata abien biara ase. Afei, nhwiren no bi wɔ nkorata abien a ɛwɔ ase no ase, na bi nso wɔ nkorata abien a ɛwɔ soro no so. Ne nyinaa yɛ asia. ");
INSERT INTO twi_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Nea wɔde siesiee kaneadua no ne ne nkorata no nyinaa yɛ ade baako a sikakɔkɔɔ ankasa a wɔaboro na wɔde yɛe. ");
INSERT INTO twi_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Afei, ɔyɛɛ akanea ason, adaban adabaw, ne apampaa. Ne nyinaa wɔde sikakɔkɔɔ ankasa na ɛyɛe. ");
INSERT INTO twi_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Na kaneadua no ne ho nneɛma no mu duru yɛ kilogram aduasa anan a ne nyinaa yɛ sikakɔkɔɔ. ");
INSERT INTO twi_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Wɔde ɔkanto na ɛyɛɛ aduhuam afɔremuka no. Wɔyɛɛ no ahinanan a ne fa biara susuw nsateaa dunwɔtwe. Na ne sorokɔ yɛ basafa baako a mmɛn a etuatua ne ntwea so ntwea so no nso nyinaa ka bɔ mu ma ɛyɛ ade baako. ");
INSERT INTO twi_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Wɔde sikakɔkɔɔ duraa ne nyinaa ho, na oguu bi nso wɔ ne ntwea so nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Wɔde sika nkaa abien abien susoo afanu no mu wɔ nea wɔyɛɛ nguguho no ase a wɔde besuso nnua a wɔde bɛsoa no mu. ");
INSERT INTO twi_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Nnua a na wɔde soa no yɛ ɔkanto nnua a wɔde sikakɔkɔɔ adura ho. ");
INSERT INTO twi_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Wɔfaa nnuhuamyɛfo mu abenfo kwan so fii nnuhuam mu yɛɛ ɔsrango kronkron a wɔde sra asɔfo ne ɔhyew nnuhuam no nso. ");
INSERT INTO twi_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ɔhyew afɔremuka no nso, ɔkanto na wɔde yɛe. Woyii no ahinanan a ne fa biara susuw anammɔn ason ne fa na ne sorokɔ nso yɛ anammɔn anan ne fa. ");
INSERT INTO twi_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Na ne ntwea so anan no nyinaa mmɛn tuatua ho a ne nyinaa ka bɔ mu ma ɛyɛ ade baako a wɔde kɔbere adura ho. ");
INSERT INTO twi_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Wɔyɛɛ afɔremuka no ho nneɛma te sɛ nkuku, sofi, hweaseammɔ, adinam ne nkankyee a wɔbɛnoa mu de kaa ho. ");
INSERT INTO twi_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Afei, wɔde kɔbere nwenee afɔremuka no ho twitae a ɛte sɛ atena de sii adaka a ɛbɛdeda ogya adaka no mfimfini. ");
INSERT INTO twi_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Wɔde nkaa anan anan sensɛn twaa ne fa biara ma wɔde nnua a wɔde bɛsoa no hyehyɛɛ mu. ");
INSERT INTO twi_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ɔkanto nnua a wɔde kɔbere adura ho na wɔde yɛɛ nnua a wɔde bɛsoa no. ");
INSERT INTO twi_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Wɔde nnua a wɔde soa no hyehyɛɛ nkaa no a ɛbobɔ afɔremuka no nkyɛn no mu. Ntaaboo na wɔde yɛe. Na emu da kwan nso. ");
INSERT INTO twi_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Wɔde kɔbere a wɔatwa afi kɔbere ahwehwɛ a mmea a wɔsom wɔ Ahyiae Ntamadan no ano no de kyɛe no na ɛyɛɛ ade a wɔhoro mu nneɛma ne ne ntaease no. ");
INSERT INTO twi_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Afei, wɔyɛɛ adiwo. Na ɔfasu a ɛwɔ nʼanafo no ne tenten yɛ anammɔn ɔha aduonum a wɔde nnurahotam a wɔde asaawatam a ɛyɛ fɛ na ɛyɛe. ");
INSERT INTO twi_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Nnua aduonu na wɔde besuso nnurahotam no mu. Ne nnyinaso yɛ kɔbere a dwetɛ nkɔtɔkoro ne pema ka ho. ");
INSERT INTO twi_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Na atifi ɔfasu no tenten yɛ anammɔn ɔha ne aduonum a kɔbere nnua aduonu ne ne nnyinaso a dwetɛ nkɔtɔkoro ne pema ka ho. ");
INSERT INTO twi_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Atɔe fam fasu no trɛw yɛ anammɔn aduɔson anum. Wɔde nnurahotam faa ɔfasu no ho. Nnua du, ne nnyinaso ne dwetɛ nkɔtɔkoro ne ntwea na na ɛma saa ɔfasu no gyina. ");
INSERT INTO twi_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Na apuei fam no nso trɛw yɛ anammɔn aduɔson anum. ");
INSERT INTO twi_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Na adiwo hɔ kwan no wɔ apuei fam a wɔde nkataanim abien akata hɔ. Na nkataanim a ɛwɔ nifa so no tenten yɛ anammɔn aduonu abien ne fa, na nnua abiɛsa a esisi nnyinasode abiɛsa so na ekura mu, ");
INSERT INTO twi_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","na nkataanim a ɛwɔ benkum so no nso tenten yɛ anammɔn aduonu abien ne fa a nnua abiɛsa a esisi nnyinasode abiɛsa so kura mu. ");
INSERT INTO twi_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Asaawatam a ɛyɛ fɛ na wɔde nwenee nnurahotam a wɔde twaa adiwo hɔ no ho. ");
INSERT INTO twi_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Na dua biara wɔ ne kɔbere nnyinasode, nanso ɛho nkɔtɔkoro ne mfɛnsere no yɛ dwetɛ; nnua no atifi nyinaa na wɔde dwetɛ agu, na mfɛnsere a wɔde besuso nnurahotam no mu no nso, na ne nyinaa yɛ dwetɛ ankasa. ");
INSERT INTO twi_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Asaawatam a wɔde tuntum, bibiri ne koogyan anwen mu fɛfɛɛfɛ na wɔde yɛɛ nnurahotam kataa adiwo hɔ kwan no ano. Na ne tenten yɛ anammɔn aduasa na ne trɛw nso yɛ anammɔn ason ne fa te sɛ nnurahotam a wɔde duraa adiwo hɔ afasu no ho no. ");
INSERT INTO twi_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Nnua anan na na ɛsensɛn so, na nnua no nso gyina kɔbere nnyinasode anan a dwetɛ nkɔtɔkoro ne mfɛnsere ka ho nso. Nnua no so nyinaa yɛ dwetɛ. ");
INSERT INTO twi_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Nnadewa a wɔde sii Ahyiae Ntamadan no ne adiwo hɔ no nyinaa yɛ kɔbere. ");
INSERT INTO twi_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Eyi ne ɔkwan a wɔfaa so sii Ahyiae Ntamadan a wɔde Apam Adaka no besi mu no sɛnea ɛbɛyɛ a Lewifo no betumi ayɛ wɔn asɔfodwuma. Ɔkwan a Mose kyerɛɛ wɔn sɛ wɔmfa so nsi no ara so na wɔfae. Ɔsɔfo Aaron ba Itamar na ɔhwɛɛ dwumadi no so. ");
INSERT INTO twi_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Odwumfo dansifo a na ɔwɔ ho nso ne Uri ba Besaleel a ɔyɛ Hur a ofi Yuda abusua mu no nena. ");
INSERT INTO twi_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ne boafo ne Oholiab a ɔyɛ Ahisamak a ofi Dan abusua mu ba. Na ɔno nso yɛ odwumfo a otumi twa nkyerɛw gu nneɛma mu. Afei na ɔyɛ adenwenfo a otumi de asaawatam tuntum, bibiri ne koogyan di adwinni gu ntama mu. ");
INSERT INTO twi_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Nnipa no de sikakɔkɔɔ kilogram apem bae. Wɔde ne nyinaa nso yɛɛ Ahyiae Ntamadan no ho adwuma. ");
INSERT INTO twi_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Dwetɛ a asafo no mu nnipa no de bae yɛ kilogram mpem abiɛsa ne ahannan (3,400). ");
INSERT INTO twi_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Saa dwetɛ yi fi tow a wotwa maa mmarima a wɔadi mfe aduonu rekɔ a wɔkan wɔn no. Wogye fii mmarima mpem ahansia ne abiɛsa, ahannum ne aduonum hɔ. ");
INSERT INTO twi_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Kronkronbea hɔ nnyinaso ɔha ne mpuran a esuso ntwamtam no mu no behia dwetɛ kilogram mpem abiɛsa ne ahannan Enti nnyinaso biara bɛyɛ dwetɛ kilogram aduasa anan. ");
INSERT INTO twi_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Dwetɛ kilogram aduonu no a ɛkae no nso, wɔde yɛɛ nnua no de bi duraa apampamu, de bi yɛɛ mfɛnsere no ne nkɔtɔkoro no. ");
INSERT INTO twi_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Kɔbere mfrafrae a wɔde bae no nso, na ɛyɛ kilogram mpem abien ne ahannan (2,400). ");
INSERT INTO twi_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ɛno na wɔde yɛɛ adum no nnyinaso wɔ Ahyiae Ntamadan no kwan ano. Ɛno bi ara na wɔde yɛɛ kɔbere mfrafrae afɔremuka, kɔbere mfrafrae ntwitae, ");
INSERT INTO twi_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","afɔremuka no so nneɛma, adum no nnyinasode a ekura nnurahotam a etwa adiwo no ho hyia no ne nnadewa a wɔde si Ahyiae Ntamadan no de yɛɛ adiwo hɔ adwuma nyinaa. ");
INSERT INTO twi_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Nnipa no de ntama tuntum, bibiri ne koogyan a ɛyɛ fɛ pam asɔfotade maa asɔfo no a wɔde bɛsom wɔ kronkronbea hɔ. Saa ntadetam no ara bi na wɔde pam Aaron ntade kronkron no sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Wɔde asaawatam bi a wɔanwen afi asaawa a wɔato mu na ɛpam asɔfotade nkataase no. ");
INSERT INTO twi_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Besaleel boroo sikakɔkɔɔ ma ɛyɛɛ tratraa, ɛnna otwitwaa no nteanteaa sɛ hama na ɔde bobɔɔ ntama tuntum, bibiri ne koogyan no mu. Ɛyɛ nsaanoadwuma a ɛte apɔw yiye. ");
INSERT INTO twi_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Wɔde nwoma a wɔapam susoo nkataase no mu fi ase besii mmati ahama abien no mu. ");
INSERT INTO twi_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Na wɔde ntama tuntum, bibiri, koogyan ne sikakɔkɔɔ yɛɛ nkyekyeremu sɛnea Onyankopɔn hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Abo apopobibiri abien a wotwa de femfam mmati ahama abien no a eso asɔfotade no nkataase no mu no, sikakɔkɔɔ na wɔde kyerɛw Israelfo mmusuakuw no nyinaa din guu so sɛnea wɔkyerɛw nsateaa so kaa so no. ");
INSERT INTO twi_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Saa abo yi yɛ nkae ade de ma Awurade fa Israelfo ho, na wɔyɛɛ ne nyinaa sɛnea Awurade hyɛɛ Mose sɛ wɔnyɛ no no ara pɛ. ");
INSERT INTO twi_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Wɔpam adɛbo no te sɛ asɔfotade a wɔde nwera ankasa yɛe, na wɔde sikakɔkɔɔ hama ne asaawa tuntum, bibiri ne koogyan na ɛnwen mu. ");
INSERT INTO twi_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Na ɛyɛ ahinanan a ne fa biara susuw nsateaa akron a wɔabu abɔ so. ");
INSERT INTO twi_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Na wɔhyehyɛɛ abo a ɛsom bo sesaa so nnidiso nnidiso anan wɔ mu. Nnidiso a edi kan no yɛ bogyanambo, akraatebo ne ahabammono bo; ");
INSERT INTO twi_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","nnidiso a ɛto so abien no yɛ nsrammabo, hoabo ne dɛnkyɛmmo; ");
INSERT INTO twi_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","nea ɛto so abiɛsa no yɛ akutuhonobo, mfrafraebo ne beredumbo; ");
INSERT INTO twi_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","na nea ɛto so anan no yɛ sikabereɛbo, apopobibiribo ne ahwehwɛbo a wɔde sikakɔkɔɔ atwa emu biara ho ahyia. ");
INSERT INTO twi_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Wɔyɛɛ abo no te sɛ nsɔwanode bi kyerɛw Israel mmusuakuw dumien no din guu so. ");
INSERT INTO twi_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Sɛnea ɛbɛyɛ a wobetumi de adɛbo no aso asɔfotade no mu no, wɔde sikakɔkɔɔ nkaa hyehyɛɛ asɔfotade no mmati ntareso abien no so. ");
INSERT INTO twi_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Wɔsan yɛɛ sikakɔkɔɔ nkaa abien de hyehyɛɛ adɛbo no ntwɔtwɔw so wɔ soro. ");
INSERT INTO twi_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Wɔde sikakɔkɔɔ ahama abien no hyehyɛɛ sikakɔkɔɔ nkaa a ɛwɔ adɛbo no mu no mu. ");
INSERT INTO twi_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Wɔde ahama no ti no bobɔɔ sikakɔkɔɔ no a esuso asɔfotade no mu no mu. ");
INSERT INTO twi_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Wɔde sikakɔkɔɔ nkaa abien nso hyehyɛɛ adɛbo no ntwea abien no a egu asɔfotade no so pɛɛ no so. ");
INSERT INTO twi_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Wɔde sikakɔkɔɔ nkaa abien susoo asɔfotade no mmati ntareso no mu ma ɛbɛn nkyekyeremu a wɔanwen no fɛfɛɛfɛ ne asɔfotade no ahyiae so no. ");
INSERT INTO twi_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Sɛnea ɛbɛyɛ na adɛbo no begyina pɛpɛɛpɛ wɔ nkyekyeremu fɛfɛ no so nti, wɔde ntama tuntum kyekyeree nkaa a esuso adɛbo no ne asɔfotade no mu. Eyinom nyinaa, Awurade na ɔhyɛɛ Mose sɛ wɔnyɛ. ");
INSERT INTO twi_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Asɔfotade no fa kɛse no ara de, wɔde ntama tuntum na ɛnwenee ");
INSERT INTO twi_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","na wotwaa mfimfini tokuru pempam bi faa so maa ano no yɛɛ den sɛnea wɔhyɛ a ɛrentetew. ");
INSERT INTO twi_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Na wɔde bibiri ne asaawa a ɛbere dum ne koogyan a wɔanwen yɛɛ biribi te sɛ atoaa aba de sensɛn batakari no ase mmuano no ano. ");
INSERT INTO twi_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Na wɔde sikakɔkɔɔ yɛɛ nnɔnnɔmma na wɔde biribi te sɛ atoaa aba no hyehyɛɛ ntam ne ntam wɔ batakari no ase mmuano no ano de twaa ho hyiae. ");
INSERT INTO twi_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Sɛ Aaron hyɛ asɔfotade yi a, na ɛkyerɛ sɛ ɔrekɔsom Awurade sɛnea Awurade hyɛɛ Mose sɛ ɔnyɛ no. ");
INSERT INTO twi_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Wɔde asaawatam a ɛyɛ fɛ pam asɔfotade no bi maa Aaron ne ne mmabarima. ");
INSERT INTO twi_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Wɔde ntama a ɛyɛ fɛ na ɛpam adɛbo, abotiri, kyɛw ne nhyɛasetam ahorow no. ");
INSERT INTO twi_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Bio, wɔde ntama a ɛyɛ fɛ na ɛpam nkyekyeremu no na wɔde asaawa tuntum, bibiri ne koogyan dii mu adwinni sɛnea Awurade hyɛɛ Mose sɛ ɔnyɛ no. ");
INSERT INTO twi_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Na afei, wɔde sikakɔkɔɔ yɛɛ abɔanim a wɔakyerɛw so: Kronkron Ma Awurade. ");
INSERT INTO twi_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Wɔde ntama tuntum na asina abɔanim no abɔ abotiri no mu sɛnea Awurade hyɛe no. ");
INSERT INTO twi_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Eyi nyinaa akyi no, wowiee Ahyiae Ntamadan no si sɛnea Awurade kyerɛɛ Mose sɛ wonsi no no. ");
INSERT INTO twi_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Afei, wɔde Ahyiae Ntamadan no ne emu nneɛma nyinaa brɛɛ Mose: Nkyerewa, nnyinaso, mmeamu nnua, mpuran ne nsisiso; ");
INSERT INTO twi_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","adwennini nwoma a wɔahyɛ no kɔkɔɔ, abirekyi nwoma a wɔahyɛ, nkataano, ");
INSERT INTO twi_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","adaka no a Mmaransɛm Du no wɔ mu no, nnua a wɔde soa Mpata agua; ");
INSERT INTO twi_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ɔpon no ne ɛho nneɛma, Ɔkyerɛ Brodo, ");
INSERT INTO twi_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","sika akaneadua ne nʼakanea, ɛho nneɛma ne ngo wɔde sɔ kanea; ");
INSERT INTO twi_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","sikakɔkɔɔ afɔremuka, ɔsrango, aduhuam ne Ahyiae Ntamadan no nkataano, ");
INSERT INTO twi_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","kɔbere Afɔremuka, kɔbere ntwitae, nnua no ne ɛho nneɛma, nea wɔhoro mu nneɛma ne ne ntaamu, ");
INSERT INTO twi_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ntwahotam a wɔde twa adiwo hɔ fasu ho, ne ɛho nnua a esuso mu, nnyinasode ne ntwahotam a ɛwɔ adiwo pon ano, ntampehama ne nnadewa ne biribiara a wɔde boaa Ahyiae Ntamadan no si. ");
INSERT INTO twi_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Wɔde asɔfotade a wɔapam no fɛfɛɛfɛ a wɔhyɛ kɔ kronkronbea hɔ no brɛɛ no ma ɔhwɛe. Afei, wɔde Aaron asɔfotade kronkron no nso ne ne mmabarima de a wɔbɛhyɛ de ayɛ asɔfodwuma no bɛkyerɛɛ no. ");
INSERT INTO twi_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Enti Israelfo no dii nsɛm a Awurade hyɛɛ Mose sɛ ɔnka nkyerɛ wɔn no nyinaa so. ");
INSERT INTO twi_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Na Mose hwɛɛ nnwuma no nyinaa huu sɛ biribiara ntɔ kyima wɔ ho no, ohyiraa wɔn, efisɛ sɛnea Awurade hyɛe no ara pɛ na wɔyɛe. ");
INSERT INTO twi_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Afei Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ɔsram a edi kan no da a edi kan no na si Ahyiae Ntamadan no. ");
INSERT INTO twi_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Wusi wie a, fa Apam Adaka a Mmaransɛm Du no wɔ mu no si mu. Na fa ntwamtam no twa Apam Adaka no anim ma ɛnhyɛ kronkron mu kronkron hɔ. ");
INSERT INTO twi_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Afei, fa ɔpon no besi hɔ na fa ɛho nneɛma nyinaa gu so na fa kaneadua no bra na sɔ kanea no. ");
INSERT INTO twi_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Fa sikakɔkɔɔ afɔremuka a wɔbɛhyew aduhuam wɔ so no besi Apam Adaka no anim na fa ɔpon no nkataanim sɛn Ahyiae Ntamadan no ano. ");
INSERT INTO twi_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Fa ɔhyew afɔremuka no si Ahyiae Ntamadan no kwan ano. ");
INSERT INTO twi_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Fa hweaseammɔ no si Ahyiae Ntamadan no ne afɔremuka no ntam na hyɛ no nsu ma. ");
INSERT INTO twi_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Siesie adiwo twa Ahyiae Ntamadan no ho hyia na fa nsɛnanim no sɛn ne kwan no ano. ");
INSERT INTO twi_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Fa ɔsrango no na pete gu Ahyiae Ntamadan no so baabiara ne biribiara a ɛwɔ mu ne nneɛma a ɛwɔ hɔ nyinaa ne nkongua so, na fa tew ho. ");
INSERT INTO twi_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ɔhyew afɔremuka no ne ɛho nneɛma nyinaa nso, pete ɔsra ngo no bi gu so na tew ho na ɛnyɛ kronkron. ");
INSERT INTO twi_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Sra hweaseammɔ no ne ne ntaease no ngo na fa tew ho. ");
INSERT INTO twi_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Fa Aaron ne ne mmabarima no bra Ahyiae Ntamadan no kwan ano na fa nsu hohoro wɔn ho. ");
INSERT INTO twi_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Na fa atade kronkron no hyɛ Aaron, na sra no ngo na ne ho ntew na ɔmmɛyɛ me sɔfo. ");
INSERT INTO twi_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Fa ne mmabarima no bra na fa wɔn ntade hyehyɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Sra wɔn ngo sɛnea woyɛɛ wɔn agya no, sɛnea wɔbɛsom me sɛ asɔfo. Wɔn ngosra no bɛyɛ asɔfodi wɔ wɔn awo ntoatoaso nyinaa mu.” ");
INSERT INTO twi_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mose yɛɛ biribiara sɛnea Awurade hyɛɛ no no. ");
INSERT INTO twi_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Afe a ɛto so abien no mu ɔsram a edi kan no da a edi kan no, wɔkekaa Ahyiae Ntamadan no sisii anim. ");
INSERT INTO twi_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mose sii Ahyiae Ntamadan no; ɔde nsisiso no sisii wɔn afa, de nnyinaso no hyehyɛɛ mu de mmeamu nnua beabea mu de mpuran sisii wɔn afa. ");
INSERT INTO twi_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Afei, ɔde nkuruso no kuruu mpuran no so de ne nguguso guguu so san de nguguso a edi akyi kuruu so sɛnea Awurade hyɛɛ no no. ");
INSERT INTO twi_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ɔde abo a wɔakyerɛw Mmaransɛm Du no wɔ so no guu Apam Adaka no mu de nnua a wɔde bɛsoa no susoo mu. Ɔde ne nkataso a wɔde sikakɔkɔɔ ayɛ a ɛyɛ mpata nkataso no kataa so. ");
INSERT INTO twi_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Afei, ɔde Apam Adaka no besii Ahyiae Ntamadan no mu de ntwamtam no twaa mu, sɛnea Awurade hyɛɛ no no. ");
INSERT INTO twi_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Afei, ɔde ɔpon no sii atifi fam wɔ ɔdan no mu wɔ ntwamtam no akyi, ");
INSERT INTO twi_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","de Ɔkyerɛ Brodo no too so wɔ Awurade anim sɛnea Awurade hyɛe no. ");
INSERT INTO twi_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ɔde kaneadua no sii ɔpon no nkyɛn wɔ Ahyiae Ntamadan no anafo fam. ");
INSERT INTO twi_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Afei, ɔsɔɔ kanea no wɔ Awurade anim sɛnea Awurade hyɛɛ no no. ");
INSERT INTO twi_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Mose de sikakɔkɔɔ afɔremuka sii ntwamtam no ho pɛɛ wɔ Ahyiae Ntamadan no mu ");
INSERT INTO twi_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","na ɔhyew nnuhuam wɔ so sɛnea Awurade hyɛe no. ");
INSERT INTO twi_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ɔde Ahyiae Ntamadan no ano nkataano sɛn ano. ");
INSERT INTO twi_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ɔde afɔremuka a esi akyi a wɔbɔ ɔhyew afɔre wɔ so no si bɛn ɔkwan no ano, na ɔbɔɔ so ɔhyew afɔre ne aduan afɔre sɛnea Awurade hyɛe no. ");
INSERT INTO twi_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ɔde hweaseammɔ sii Ahyiae Ntamadan no ne afɔremuka no ntam na wɔhyɛɛ no nsu ma, sɛnea asɔfo no benya bi ahohoro wɔn ho, ");
INSERT INTO twi_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","na Mose ne Aaron ne Aaron mmabarima hohoroo wɔn nsa ho ne wɔn anan ase wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Bere biara a wɔbɛfa afɔremuka no ho akɔ Ahyiae Ntamadan no mu no, wogyina hohoroo wɔn ho sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Na Mose sii biribi twaa Ahyiae Ntamadan no ne afɔremuka no ho hyiae na wɔde nsɛnanotam sɛn ano. Ɛnna Mose wiee nʼadwuma. ");
INSERT INTO twi_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Omununkum no bɛkataa Ahyiae Ntamadan no so maa Awurade anuonyam hyɛɛ no ma. ");
INSERT INTO twi_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Esiane sɛ na omununkum no asi wɔ hɔ no nti, Mose antumi ankɔ mu na Awurade anuonyam hyɛɛ Ahyiae Ntamadan no ma. ");
INSERT INTO twi_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Bere biara a omununkum no bɛma ne ho so no, na Israelfo no nso di akyi. ");
INSERT INTO twi_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Na sɛ egyina a, na wɔn nso agyina akosi sɛ ɛbɛma ne ho so bio. ");
INSERT INTO twi_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Awia de, omununkum no gyina Ahyiae Ntamadan no so na sɛ edu anadwo a, na ogya asɔ wɔ omununkum no mu sɛnea Israelfo no nyinaa behu. Eyi toaa so saa ara wɔ wɔn akwantu no nyinaa mu.");
INSERT INTO twi_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Afei, Awurade kasa fii Ahyiae Ntamadan no mu kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Kyerɛ Israelfo no se, ‘sɛ morebɔ Awurade afɔre a, momfa mo anantwi ne mo nguan no bi na mommɔ saa afɔre no. ");
INSERT INTO twi_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Sɛ mo ɔhyew afɔrebɔde no yɛ nantwi a ofi mo nantwibuw mu a, momfa nantwi a onnii dɛm na ɛmmɔ saa afɔre no sɛnea ɛbɛsɔ Awurade ani. Fa aboa no kɔ Ahyiae Ntamadan no pon ano na ɛhɔ na asɔfo no begye wʼayɛyɛde a wode rebrɛ Awurade no. ");
INSERT INTO twi_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ɛsɛ sɛ onipa a ɔde aboa no reba no de ne nsa gu aboa no ti so sɛ mpata ma afɔrebɔni no. Onyankopɔn bɛpɛ aboa no wu sen sɛ afɔrebɔni a ɔde saa aboa no bɛba no bewu sɛ ne bɔne so akatua. ");
INSERT INTO twi_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Afɔrebɔni no bekum aboa no wɔ hɔ wɔ Awurade anim. Na Aaron mmabarima asɔfo no asɔw aboa no mogya de akyerɛ Awurade. Na wɔde mogya no apete afɔremuka a esi Ahyiae Ntamadan no kwan no ano no ne ho nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Afei, asɔfo no bɛpa aboa no ho nwoma na wɔabobɔw. ");
INSERT INTO twi_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Na ɔsɔfo Aaron mmabarima no bɛsɔ gya wɔ afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Na wɔde aboa no akwaa bi ne ne ti ne ne srade ka ho agu nnyansin no so. ");
INSERT INTO twi_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Momfa nsu nhohoro nʼayamde ne ne nan ho na asɔfo no nhyew no wɔ afɔremuka no so. Ɛyɛ ɔhyew afɔre, aduan afɔrebɔ, ehua a ɛsɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Sɛ afɔrebɔ no yɛ ɔhyew afɔre na aboa no yɛ oguan anaa abirekyi a, ɛsɛ sɛ ɔyɛ onini a ne ho nni dɛm biara. ");
INSERT INTO twi_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Onipa a ɔde no bae no bekum no Awurade anim wɔ afɔremuka no atifi na Aaron mmabarima asɔfo no apete mogya no agu afɔremuka no so ne ɛho nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ɔbɛhyehyɛ nam no na asɔfo no de nʼasinasin no ne ti no ne ne srade no agu nnyansin a egu afɔremuka no so no so. ");
INSERT INTO twi_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Wɔde nsu bɛhohoro nʼayamde ne ne nan no ho ansa na asɔfo no ahyew wɔ afɔremuka no so de ama Awurade; efisɛ ɔhyew afɔre sɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Sɛ obi pɛ sɛ ɔde anomaa bɔ ɔhyew afɔre a, ɔmfa nturukuku anaa mmorɔnomamma. ");
INSERT INTO twi_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Ɔsɔfo no bɛfa anomaa no de no akɔ afɔremuka no so na watew ne ti ahyew no, na wasɔn ne mogya no agu afɔremuka no nkyɛn. ");
INSERT INTO twi_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Afei, ɔsɔfo no beyi ne mene ase, atutu ne ntakra no na watow agu nsõ no mu wɔ afɔremuka no apuei fam. ");
INSERT INTO twi_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Afei, ɔbɛtwe ne ntaban mu ama emu ntin no atetew asensɛn hɔ, na ɔsɔfo no ahyew no wɔ afɔremuka no so. Ɛyɛ ɔhyew afɔre, aduan afɔrebɔ, ehua a ɛsɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Obiara a ɔpɛ sɛ ɔbɔ aduan afɔre de ma Awurade no, ɛsɛ sɛ afɔrebɔde no yɛ asikresiam muhumuhu koraa. Wonhwie ngo ngu so mfa aduhuam mfra ");
INSERT INTO twi_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","nkɔma Aaron mma asɔfo no. Ɔsɔfo no bɛsaw siam ne ngo no nsa mma de aka aduhuam no nyinaa ho na wahyew eyi sɛ afɔremuka no nkae ade, aduan afɔrebɔ, ehua a ɛsɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ɛsɛ sɛ wɔde asikresiam nkae no ma Aaron ne ne mmabarima sɛ wɔn aduan; nanso wɔfa ne nyinaa sɛ afɔre kronkron a wɔabɔ ama Awurade. ");
INSERT INTO twi_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Sɛ wɔde brodo a wɔato no fononoo mu brɛ Awurade sɛ afɔrebɔde a, ɛsɛ sɛ wɔde asikresiam a wɔayam no muhumuhu a wɔde ngo afra ato a mmɔkaw nni mu na ɛbɔ saa afɔre no. Mutumi de brodo ntrantraa dɛdɛ a mmɔkaw nni mu na mode ngo afa so nso bɔ afɔre ma ɛyɛ yiye. ");
INSERT INTO twi_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Sɛ afɔrebɔde no yɛ aduan a wɔato wɔ dade so a, asikresiam muhumuhu a mmɔkaw mfra mu, na mode ngo afra na momfa mmɔ saa afɔre no. ");
INSERT INTO twi_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Mummubu mu asinasin na munhwie ngo ngu so na ɛnyɛ sɛ atoko afɔre ara pɛ. ");
INSERT INTO twi_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Sɛ monoa mo afɔre no wɔ kuruwa mu a, ɛno nso, momfa asikresiam muhumuhu a mode ngo afra na ɛmmɔ saa afɔre no. ");
INSERT INTO twi_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Sɛ moyɛ aduan bi, sɛ motoe, sɛ mokyewee anaasɛ mohowee no, ɛsɛ sɛ mode saa afɔrebɔde no kɔma ɔsɔfo na ɔno nso de kɔ afɔremuka no anim de kɔma Awurade. ");
INSERT INTO twi_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Afɔrebɔde no mu kakraa bi na ɛsɛ sɛ asɔfo no hyew, nanso Awurade ani bɛsɔ ade mu no nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Nea ɛbɛka no yɛ asɔfo no dea, nanso wɔfa no sɛ ne nyinaa yɛ ɔhyew afɔre kronkron a wɔabɔ de ama Awurade. ");
INSERT INTO twi_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Afɔre a mode asikresiam na ɛbɔ no, mommfa mmɔkaw mmfra mu, efisɛ ɛnsɛ sɛ ɔhyew afɔre biara a mobɛbɔ ama Awurade no, mode mmɔkaw anaa ɛwo fra mu. ");
INSERT INTO twi_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Mode bɛbrɛ Awurade sɛ aduankan afɔrebɔde, nanso ɛnsɛ sɛ wɔhyew wɔ afɔremuka no so sɛ afɔre a ɛsɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Momfa nkyene mfra afɔrebɔde biara. Munnyi mo Nyankopɔn apam mu nkyene mmfi mo atoko afɔrebɔ mu; momfa nkyene nka mo afɔrebɔ nyinaa ho. ");
INSERT INTO twi_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Sɛ mode mo nnɔbae a edi kan mu aba kan rebɛbɔ afɔre a, emu aburow no munhuan ho na montoto na momfa mma Awurade. ");
INSERT INTO twi_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Momfa ngo ne aduhuam nyɛ ho; ɛyɛ atoko afɔre. ");
INSERT INTO twi_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Na ɔsɔfo no bɛhyew aburow a wɔayam ne ngo no nkae de aduhuam afra sɛ aduan afɔrebɔde a wɔde aba Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Sɛ obiara pɛ sɛ ɔbɔ asomdwoe afɔre ma Awurade a, otumi de nantwinini anaa nantwibere bɔ, nanso ɛsɛ sɛ aboa no yɛ nea ne ho nni dɛm biara. ");
INSERT INTO twi_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Onipa a ɔde aboa no aba no de ne nsa begu aboa no apampam na wakum no wɔ Ahyiae Ntamadan no ano. Na Aaron mmabarima asɔfo no apete aboa no mogya agu afɔremuka no ho. ");
INSERT INTO twi_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Ɛsɛ sɛ mufi asomdwoe afɔre mu de nʼayamde ne srade a ɛwɔ ho nyinaa bɛbɔ aduan afɔre ma Awurade, ");
INSERT INTO twi_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","a nʼasaabo abien no ne ne sisi ne nea ne mmerɛbo sa so a mubeyi aka asaabo no ho no. ");
INSERT INTO twi_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Na ɛsɛ sɛ Aaron mma hyew wɔ afɔremuka no so, wɔ ɔhyew afɔre a ɛda dua a ɛrehyew no so; ɛyɛ aduan afɔre, ehua a ɛsɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Sɛ abirekyi anaa oguan na mode bɛbɔ asomdwoe afɔre ama Awurade a, ɛnsɛ sɛ dɛm biara ba ne ho na ɛsɛ sɛ ɔyɛ onini anaa ɔbere. ");
INSERT INTO twi_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Sɛ mode oguan ba sɛ mo akyɛde a, ");
INSERT INTO twi_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","momfa mo nsa ngu nʼapampam na munkum no wɔ Ahyiae Ntamadan no kwan ano. Afei, Aaron mmabarima no bɛpete mogya no agu afɔremuka no ho nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Saa asomdwoe afɔrebɔde yi fa bi na wɔmfa mma Awurade sɛ ɔhyew afɔrebɔde a ne dua ne mu nneɛma ne ɛho srade, srade a ɛwɔ nʼayamde ho no nyinaa, ");
INSERT INTO twi_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ne asaabo abien ne ɛho srade a ɛbɛn ne sisia ne ne merɛbo a wobeyi a nʼasaabo ka ho no. ");
INSERT INTO twi_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ɔsɔfo no bɛhyew no wɔ afɔremuka no so sɛ aduan a ɛyɛ ɔhyew afɔre ama Awurade. ");
INSERT INTO twi_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Sɛ wode abirekyi brɛ Awurade sɛ wʼafɔrebɔde a, ");
INSERT INTO twi_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","fa wo nsa gu aboa no apampam na kum no wɔ Ahyiae Ntamadan no kwan ano. Aaron mmabarima de aboa no mogya bɛpete afɔremuka no ho nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ɛsɛ sɛ wɔhyew saa afɔrebɔde yi fa bi ma Awurade. Saa afɔrebɔde fa no yɛ aboa no yam srade, ");
INSERT INTO twi_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","nʼasaabo abien ne ɛho srade a ɛbɛn nʼasen mu ne ne mmerɛbo a wobeyi aka ne asaabo no ho no. ");
INSERT INTO twi_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Ɔsɔfo no bɛhyew wɔ afɔremuka no so sɛ ɔhyew afɔre. Awurade ani bɛsɔ saa ɔhyew afɔre no. Kae sɛ srade no nyinaa yɛ Awurade dea. ");
INSERT INTO twi_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Eyi ne mmara a munni so daa nyinaa wɔ asase yi so baabiara. Munnni srade anaa mogya.’ ” ");
INSERT INTO twi_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Afei Awurade hyɛɛ mmara foforo maa Mose sɛ: ");
INSERT INTO twi_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Ka kyerɛ Israelfo se saa mmara yi na ɛwɔ hɔ ma obiara a wanhyɛ da na obebu me mmara no bi so. ");
INSERT INTO twi_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Sɛ ɔsɔfo bi anhyɛ da na ɔfom mmara bi na ɛnam so de afɔbu ba nnipa no so a, ɛsɛ sɛ ɔde nantwinini ba a onnii dɛm bɔ bɔne ho afɔre de ma Awurade. ");
INSERT INTO twi_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ɛsɛ sɛ ɔde aboa no ba Ahyiae Ntamadan no pon ano na ɔde ne nsa gu nʼapampam na okum no wɔ hɔ wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ɔsɔfo no de aboa no mogya bɛkɔ Ahyiae Ntamadan no mu. ");
INSERT INTO twi_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ɔde ne nsateaa baako bɛbɔ mogya no mu apete mpɛn ason wɔ Awurade anim wɔ ntama a ɛsɛn kronkron mu kronkron no anim. ");
INSERT INTO twi_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Afei, ɔsɔfo no de mogya no bi begu aduhuam no tumpan a esi afɔremuka no so no wɔ Awurade anim wɔ Ahyiae Ntamadan no mu; mogya no a ɛbɛka no, wobehwie agu afɔremuka no ase de abɔ ɔhyew afɔre wɔ Ahyiae Ntamadan no kwan ano. ");
INSERT INTO twi_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Afei ɔbɛtetew srade a ɛwɔ ne nsono no ho nyinaa, ");
INSERT INTO twi_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ne asaabo abien no ne sisia srade ne ne bɔnwoma kotoku, ");
INSERT INTO twi_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","na wahyew no wɔ ɔhyew afɔremuka no so te sɛ nantwinini anaa nantwibere a wɔde no bɔ asomdwoe afɔre no pɛ. ");
INSERT INTO twi_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Nanso nantwi ba no ho nneɛma a ɛbɛka a ɛyɛ ne nwoma, ne nam, ne ti, ne nan, nʼayamde, ne ne nsono no de, ");
INSERT INTO twi_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","wɔmfa nkɔ afahyɛbea bi a ɛhɔ tew wɔ akyiri baabi a wɔde nsõ fi afɔremuka no so kɔ hɔ kɔhyew no nnyansin so no. ");
INSERT INTO twi_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Sɛ Israelfo nyinaa yɛ bɔne a etia Awurade, na sɛ ɛnyɛ ɔboayɛ a, nnipa no nyinaa bedi ho fɔ. ");
INSERT INTO twi_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Na sɛ wohu wɔn bɔne a, wɔde nantwi ba bɛba abɛbɔ bɔne ho afɔre wɔ Ahyiae Ntamadan no mu. ");
INSERT INTO twi_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Sɛ wɔrebɔ saa afɔre no a, ɔman no mu mpanyimfo de wɔn nsa begu aboa no apampam na wɔakum no wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Na ɔsɔfo no de ne mogya aba Ahyiae Ntamadan no mu, ");
INSERT INTO twi_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","na ɔde ne nsateaa baako abɔ mogya no mu apete mpɛn ason wɔ Awurade ne ntama a etwa ɔdan no mu no anim. ");
INSERT INTO twi_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ɔde mogya begu mmɛn a etuatua afɔremuka no ho no so wɔ Ahyiae Ntamadan no mu wɔ Awurade anim. Afei obehwie mogya a aka wɔ ɔhyew afɔre no afɔremuka no ase no agu wɔ Ahyiae Ntamadan no kwan ano. ");
INSERT INTO twi_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ɛsɛ sɛ woyi na wɔhyew srade a ɛwɔ aboa no mu no nyinaa wɔ afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ɔbɛfa ɔkwan a wɔfa so bɔ bɔne ho afɔre no so pɛpɛɛpɛ. Eyi bɛma ɔsɔfo no abɛyɛ mpata ama ɔman no, na wɔde obiara bɔne bɛkyɛ no. ");
INSERT INTO twi_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Afei asɔfo no bɛtwe nantwinini ba no de no akɔ beae foforo bi akɔhyew no wɔ hɔ te sɛnea ɔrebɔ ɔbaakofo bɔne ho afɔre no. Nanso eyi de, ɛyɛ ɔman mu no nyinaa afɔrebɔde. ");
INSERT INTO twi_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Sɛ mpanyimfo no bi yɛ bɔne a onnim sɛ wafom Onyankopɔn mmara no baako ");
INSERT INTO twi_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","na wɔma no te ne ho ase a, ɛsɛ sɛ ɔde ɔpapo a ne ho nni dɛm ba sɛ nʼafɔrebɔde. ");
INSERT INTO twi_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ɔde ne nsa begu aboa no apampam na wakum no wɔ beae a wokum ɔhyew afɔre mmoa no de ama Awurade no. Eyi yɛ ne bɔne ho afɔrebɔde. ");
INSERT INTO twi_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Afei, ɔsɔfo no de ne nsateaa baako bɛbɔ afɔrebɔde mogya no mu na ɔde asra afɔremuka a wɔbɔ ɔhyew afɔre wɔ so no mmɛn no ho; na afei wɔahwie mogya no nkae agu afɔremuka no ase. ");
INSERT INTO twi_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Wɔbɛhyew srade no nyinaa wɔ afɔremuka no so te sɛ nea wɔhyew asomdwoe afɔre srade no ara pɛ; ɛkyerɛ sɛ, ɔsɔfo no nam saa afɔrebɔ yi so bɛpata ama ɔpanyin ko no wɔ ne bɔne no ho; na wɔde ne bɔne no bɛkyɛ no. ");
INSERT INTO twi_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Sɛ apapahwekwa bi yɛ bɔne a onnim sɛ wafom a, odi ho fɔ. ");
INSERT INTO twi_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Nanso onya te ne ho ase ara pɛ a, ɛsɛ sɛ ɔde abirekyibere a ne ho nni dɛm ba ma wɔde pata ne bɔne no. ");
INSERT INTO twi_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ɔde no bɛba beae a wɔde mmoa a wɔde wɔn ba ma wokum wɔn de wɔn bɔ ɔhyew afɔre hɔ no, na ɔde ne nsa ato bɔne ho afɔrebɔde no apampam na wɔakum no. ");
INSERT INTO twi_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Na ɔsɔfo no de mogya no bi asra ne nsateaa baako ho na ɔde asra ɔhyew afɔremuka mmɛn no ho. Afei, ɔsɔfo no behwie mogya no nkae no agu afɔremuka no ase. ");
INSERT INTO twi_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Wobeyi srade no nyinaa afi mu te sɛ nea wɔfa bɔ asomdwoe afɔre no ara. Na ɔsɔfo no bɛhyew no wɔ afɔremuka no so. Na Awurade ani bɛsɔ. Ɛkyerɛ sɛ, ɔsɔfo no nam saa afɔrebɔ yi so bɛpata ama saa onipa no na wɔde ne bɔne bɛkyɛ no. ");
INSERT INTO twi_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Na sɛ ɔpɛ sɛ ɔde oguamma bɛbɔ ne bɔne ho afɔre nso a, ɛsɛ sɛ ɔyɛ ɔbere a dɛm biara nni ne ho. ");
INSERT INTO twi_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ɔde no bɛba beae a wɔde mmoa a wɔde wɔn ba ma wokum wɔn de wɔn bɔ ɔhyew afɔre hɔ no, na ɔde ne nsa ato bɔne ho afɔrebɔde no apampam na wakum no sɛ bɔne ho afɔrebɔde. ");
INSERT INTO twi_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Na ɔsɔfo no de mogya no bi asra ne nsateaa baako ho na ɔde asra ɔhyew afɔremuka mmɛn no ho. Na wahwie mogya no nkae no agu afɔremuka no ase. ");
INSERT INTO twi_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Wɔbɛyɛ srade no sɛnea wɔyɛ asomdwoe oguamma srade no. Ɔsɔfo no bɛhyew srade no wɔ afɔremuka no so te sɛ afɔre ahorow a wɔde ogya bɔ ma Awurade no ara pɛ. Ɔsɔfo no nam saa afɔrebɔ yi so bɛpata ama onipa ko no, na wɔde ne bɔne bɛkyɛ no. ");
INSERT INTO twi_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Obiara a ɔnka bɔne bi a onim ho biribi ho hwee no di ho fɔ. ");
INSERT INTO twi_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Obiara a ɔde ne nsa ka ade bi a amanne kwan so no ɛho ntew, te sɛ aboa bi a ne ho ntew funu, sɛ ɔyɛ wuram aboa, sɛ ɔyɛ afieboa anaa aboa a ɔwea wɔ fam no, mpo sɛ onnim sɛ ne ho agu fi na akyiri no ogye nʼafɔdi to mu, ");
INSERT INTO twi_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","anaa sɛ obi anhyɛ da na ɔde ne nsa ka biribi a efi onipa mu a ɛho ntew na ɔte ne ho ase sɛ odi ho fɔ, ");
INSERT INTO twi_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","anaa sɛ obi annwene ho na ɔka ntam sɛ ɔbɛyɛ biribi a eye anaa ennye na akyiri no ohu nʼafɔdi; ");
INSERT INTO twi_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","sɛ obi ani ba ne ho so wɔ eyinom biara mu a, ɛsɛ sɛ ɔpae mu ka ne bɔne a wayɛ. ");
INSERT INTO twi_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ɛsɛ sɛ ɔde oguammere anaa abirekyibere bɔ afɔre ma Awurade wɔ ne bɔne ho asotwe ho. Ɔsɔfo na ɔbɛbɔ onipa ko no bɔne no ho afɔre ama no. Ɔsɔfo no nam saa afɔrebɔ yi so bɛpata ama no. ");
INSERT INTO twi_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Sɛ ɔyɛ ohiani a ɔrennya oguamma mfa mma Awurade a, ɔmfa nturukuku abien anaa mmorɔnomamma abien mmra sɛ ne bɔne ho afɔrebɔde. Nnomaa no mu baako bɛyɛ ne bɔne no afɔrebɔde na ɔbaako ayɛ ne hyew afɔrebɔde. ");
INSERT INTO twi_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ɔde bɛma ɔsɔfo no na ɔde anomaa a odi kan no abɔ bɔne afɔre no. Obekyim aboa no kɔn nanso ɔrentew ne ti mfi so, ");
INSERT INTO twi_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","na wapete ne mogya no bi agu afɔremuka no ho. Mogya no nkae no, obehwie agu afɔremuka no ase. Eyi ne afɔrebɔ kwan a ɛpepa bɔne. ");
INSERT INTO twi_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Na ɔsɔfo no de anomaa a ɔto so abien no bɛbɔ ɔhyew afɔre sɛnea ɔbɔɔ afɔre a edi kan no ara pɛ. Ɔsɔfo no nam saa afɔrebɔ yi so bɛpata ama nea wayɛ bɔne no, na ɛnam so ama wɔde ne bɔne akyɛ no. ");
INSERT INTO twi_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Sɛ ɔyɛ ohiani buruburoo a ɔrentumi mfa nturukuku anaa mmorɔnomamma mmɛbɔ ne bɔne ho afɔre a, ɔde asikresiam muhumuhu lita abien ne fa bɛba sɛ ne bɔne ho afɔrebɔde. Ɛnsɛ sɛ ɔde ɔsra ngo fra. Ɛnsɛ sɛ ɔde aduhuam nso gu so, efisɛ ɛyɛ bɔne afɔre. ");
INSERT INTO twi_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ɔde bɛma ɔsɔfo no. Na ɔsɔfo no asaw ne nsa ma de asi ne nyinaa anan na wahyew no wɔ afɔremuka no so ama Awurade sɛ afɔrebɔde biara. Eyi bɛyɛ ne bɔne ho afɔrebɔ. ");
INSERT INTO twi_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Sɛ ɛba saa a, ɔsɔfo no nam saa afɔrebɔ yi so bɛpata ama onipa no na wɔde ne bɔne no bɛkyɛ no. Asikresiam a aka no, wɔde bɛma ɔsɔfo no te sɛ nnɔbae afɔrebɔde no ara pɛ.’ ” ");
INSERT INTO twi_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Awurade hyɛɛ mmara maa Mose se, ");
INSERT INTO twi_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Sɛ obi anhyɛ da na ogu ade kronkron ho fi a, ɔde odwennini a ne ho nni dɛm a ɔfata sɛ mpata wɔ nʼafɔdi no ho bɛba abɛbɔ Awurade afɔre. ");
INSERT INTO twi_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ade kronkron a nipa no guu ho fi no nso, ɔde foforo besi anan na watua dekode no bo ɔha mu nkyɛmu aduonu aka ho sɛ asotwe. Ɔde ne nyinaa bɛma ɔsɔfo na ɔde Odwennini no abɔ bɔne afɔre no na wɔde ne bɔne akyɛ no. ");
INSERT INTO twi_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Sɛ obi anhyɛ da na obu Awurade mmara no bi so a, odi fɔ nti ɛsɛ sɛ otua afɔbude a Mose bɛhyɛ no. ");
INSERT INTO twi_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ɛsɛ sɛ ɔde odwennini anaa ɔpapo a onni dɛm brɛ ɔsɔfo sɛ ne bɔne no ho afɔrebɔde. Na ɔsɔfo no de ayɛ mpata ama no wɔ bɔne biara a ɔyɛe a wanhyɛ da no ho, na wɔde ne bɔne bɛkyɛ no. ");
INSERT INTO twi_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ɛsɛ sɛ wɔbɔ saa afɔre no sɛ afɔdi afɔre, efisɛ odi fɔ pefee wɔ Awurade anim.” ");
INSERT INTO twi_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Na Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Sɛ obi yɛ bɔne tia me, sɛ ebia, ɔbɛdaadaa ne yɔnko wɔ biribi a wɔde ahyɛ ne nsa anaa ade a wɔawia na wɔde abegyaw no no ho, anaasɛ osisi ne yɔnko, ");
INSERT INTO twi_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","anaa otu ahu na ɔka ntam san wɔ ho se dekode no nni ne nkyɛn a, ");
INSERT INTO twi_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","sɛ obi yɛ bɔne na odi ho fɔ a, ɔbɛsan de ne akorɔnne no anaa ne tintimgye ade anaa nea wɔde maa no siei anaa agyapade a wɔde ahyɛ ne nsa, anaa ade a ayera no aba, ");
INSERT INTO twi_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","biribiara a waka ho ntamhunu no nso, ɔbɛsan de ne nyinaa aba na ɔde ho mfɛntom ɔha mu nkyɛmu aduonu aka ho abrɛ onipa ko a ɛyɛ ne de no wɔ da a ɔrebɔ afɔdi ho afɔre no. ");
INSERT INTO twi_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Nʼafɔdi ho afɔrebɔde no sɛ ɔde odwennini a onni dɛm na ɔsom bo kɔma ɔsɔfo. ");
INSERT INTO twi_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Na ɔsɔfo no de no bɛyɛ mpata ama no wɔ Awurade anim na wɔde ne bɔne akyɛ no.” ");
INSERT INTO twi_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Afei, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Fa saa mmara a ɛfa ɔhyew afɔre ho yi ma Aaron ne ne mmabarima. ‘Wobegyaw ɔhyew afɔrebɔde no wɔ ogya no so anadwo mu no nyinaa, na ɛsɛ sɛ afɔremuka gya no kɔ so dɛw. ");
INSERT INTO twi_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ade kye a, ɔsɔfo no bɛhyɛ nʼasɔfotade hyerɛnhyerɛn wɔ ase na wahyɛ atadetam koro no ara bi nguguso na wakɔpra ɔhyew afɔre nsõ no de agu afɔremuka no nkyɛn. ");
INSERT INTO twi_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Afei, ɔbɛsesa ne ntade no na wasoa nsõ no afi beae hɔ de akogu beae foforo a wɔatew hɔ no. ");
INSERT INTO twi_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Saa bere yi nyinaa ɛsɛ sɛ ogya a ɛwɔ afɔremuka no so no dɛw. Ɛnsɛ sɛ edum. Anɔpa biara ɔsɔfo no de ogya foforo bɛhyɛ mu na ɔde da biara ɔhyew afɔre agu so, na wahyew srade a wɔde bɔ da biara asomdwoe afɔre no. ");
INSERT INTO twi_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ɛsɛ sɛ bere biara ogya no kɔ so dɛw wɔ afɔremuka no so; ɛnsɛ sɛ edum. ");
INSERT INTO twi_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Atoko afɔre ho mmara nso ni: Aaron mmabarima begyina afɔremuka no anim na wɔde atoko afɔrebɔ no ama Awurade. ");
INSERT INTO twi_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Ɔsɔfo no bɛsaw asikresiam a wɔayam no muhumuhu no ne nsa ma na ɔde ngo ne aduhuam afra ahyew no wɔ afɔremuka no so sɛ ehua a ɛsɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ɔsaw ne nsa ma wie a, nea ɛbɛka no yɛ Aaron ne ne mmabarima de a wobedi. Wobedi wɔ Ahyiae Ntamadan no adiwo hɔ a wɔremfa mmɔkaw mfra. ");
INSERT INTO twi_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Si so dua sɛ, sɛ wɔto a, wɔmmfa mmɔkaw mmfra mu. Mede saa ɔhyew afɔre a wɔbɔ maa me no bi ama asɔfo no. Esiane sɛ ne nyinaa yɛ bɔne ne afɔdi ho afɔrebɔ, nti ɛyɛ kronkron. ");
INSERT INTO twi_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Aaron asefo mmarima ne asɔfo na wonni mfi awo ntoatoaso so nkosi awo ntoatoaso so. Nanso asɔfo no nko ara na wonni afɔrebɔde a wɔabɔ no ogya so ama Awurade no. Biribiara a ɛbɛka wɔn no bɛyɛ kronkron.’ ” ");
INSERT INTO twi_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Da a wɔbɛsra Aaron ne ne mmabarima ngo no, ɛsɛ sɛ wɔde asikresiam lita abien ne fa brɛ Awurade. Wɔde fa bɛba anɔpa na wɔde fa aba anwummere. ");
INSERT INTO twi_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Wɔde ngo bɛfra ato wɔ dade apampaa so. Ɛsɛ sɛ wɔto no yiye na wɔde ba sɛ ehua a ɛsɔ Awurade nʼani. ");
INSERT INTO twi_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ɔsɔfo a ofi Aaron mmabarima mu a wɔrehyɛ no sɔfo ma wasi nʼagya anan no de bɛma Awurade sɛnea wɔahyɛ ho mmara afebɔɔ sɛ wɔnhyew ne nyinaa no. ");
INSERT INTO twi_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ɛsɛ sɛ wɔhyew ɔsɔfo biara atoko afɔre a ɔbɛbɔ no nyinaa; ɛnsɛ sɛ wodi.” ");
INSERT INTO twi_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Afei Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Ka kyerɛ Aaron ne ne mmabarima sɛ bɔne afɔrebɔ ho mmara ni: ‘Saa afɔrebɔde yi ho yɛ kronkron yiye enti ɛsɛ sɛ wokum no Awurade anim wɔ beae a wokum ɔhyew afɔrebɔde no. ");
INSERT INTO twi_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ɛsɛ sɛ ɔsɔfo a ɔyɛ afɔrebɔ no ho adwuma no we afɔrebɔde no wɔ Ahyiae Ntamadan no adiwo hɔ. ");
INSERT INTO twi_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Wɔn a wɔatew wɔn ho a wɔyɛ asɔfo nko ara na wɔwɔ ho kwan sɛ wɔde wɔn nsa ka nam no bi; na sɛ ɛba sɛ aboa no mogya bi pete wɔn ntade mu a, ɛsɛ sɛ wɔhoro ntade no wɔ beae a wɔatew ho hɔ. ");
INSERT INTO twi_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ɛsɛ sɛ wɔbɔ kuku a wɔnoaa nam no wɔ mu no; na sɛ ɛyɛ kɔbere nso a, ɛsɛ sɛ wotwiw mu, na wɔde nsu hohoro mu nyinaa yiye. ");
INSERT INTO twi_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ɔbarima biara a ɔfra asɔfo no mu no bedi afɔrebɔde no bi—wɔn nko ara—efisɛ ɛyɛ kronkron yiye. ");
INSERT INTO twi_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Sɛ wɔde bɔne ho afɔrebɔde no mogya no bi kɔ Ahyiae Ntamadan mu hɔ de kɔyɛ mpata wɔ kronkronbea hɔ a, ɔsɔfo biara renwe bi. Ɛsɛ sɛ wɔde ogya hyew aboa no nyinaa wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Amanne a ɛfa afɔdi afɔrebɔ a ɛyɛ kronkron ho no ni: ");
INSERT INTO twi_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Wobekum aboa a wɔde no rebɔ afɔdi afɔre no wɔ beae a wokum aboa a wɔde no bɔ ɔhyew afɔre no na wɔde ne mogya no apete afɔremuka no ho ahyia. ");
INSERT INTO twi_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ɔsɔfo no de aboa no mu srade nyinaa, ne dua, ");
INSERT INTO twi_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","nʼasaabo abien ne ne sisia srade ne ne bɔnwoma kotoku no nyinaa begu nkyɛn de abɔ saa afɔre no. ");
INSERT INTO twi_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Ɔsɔfo no bɛhyew no afɔremuka no so sɛ aduan afɔrebɔ a wɔde rema Awurade. Ɛyɛ afɔdi afɔre. ");
INSERT INTO twi_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ɔbarima a ɔfra asɔfo abusua mu no mu tumi we nam no bi. Ɛsɛ sɛ wɔwe wɔ beae a ɛhɔ yɛ kronkron, efisɛ ɛyɛ afɔrebɔde a ɛho tew yiye. ");
INSERT INTO twi_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘Amanne koro no ara na wɔbɛfa so abɔ bɔne afɔre ne afɔdi afɔre no. Ɛyɛ ɔsɔfo a ɔyɛɛ mpata maa wɔn no de. ");
INSERT INTO twi_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ɔsɔfo a odii ɔhyew afɔrebɔ no ho dwuma no betumi afa aboa no ho nwoma no. ");
INSERT INTO twi_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Sɛ asɔfo a wɔbɔ atoko ho afɔre ma Awurade no wie saa afɔrebɔ no a, wɔde atoko no nkae bɛma wɔn. Sɛ afɔrebɔde no, wɔto o, wɔkyew o, wɔnoa o, amanne koro no ara ase na ɛhyɛ. ");
INSERT INTO twi_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Atoko afɔrebɔ biara a aka no, sɛ wɔde ngo fra anaa wɔamfa ngo amfra a, ɛyɛ Aaron mmabarima nyinaa dea. ");
INSERT INTO twi_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Amanne a ɛfa asomdwoe afɔre sononko a wɔbɔ ma Awurade no ho no ni: ");
INSERT INTO twi_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Sɛ ɛyɛ asomdwoe afɔre a, wɔmfa brodo a mmɔkaw nni mu a wɔde ngo afra nka ho. Saa ara na wɔmfa brodo ntrantraa bi a wɔde ngo agu so ne asikresiam mfrafrae a wɔde afra ngo nka saa afɔrebɔde no ho. ");
INSERT INTO twi_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Wɔmfa brodo a emu piw a wɔde mmɔkaw afra nka saa aseda asomdwoe afɔre yi ho. ");
INSERT INTO twi_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Wɔde saa afɔrebɔde yi bi begyina afɔremuka no anim na wɔahim wɔ afɔremuka no anim akɔ fa aba fa de akyerɛ sɛ wɔde ama Awurade. Afei, wɔbɛdan afɔrebɔde no ama ɔsɔfo a ɔpete aboa a wɔde no bɛbɔ afɔre no mogya a ɔboa dwumadi no. ");
INSERT INTO twi_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Sɛ wɔde aboa no bɔ Awurade afɔre de ma no sɛ asomdwoe afɔrebɔ de kyerɛ sɛ ɛyɛ anisɔ ne asedade a, ɛsɛ sɛ wɔwe ne nam da no ara. Ɛnsɛ sɛ bi ka ma ade kye so. ");
INSERT INTO twi_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Na sɛ obi de afɔrebɔde bi ba a ɛnyɛ asomdwoe afɔre na mmom, sɛ ɛyɛ bɔhyɛ anaa efi ne koma mu na ɔde rebrɛ Awurade de a, nea ɛbɛka biara wɔ afɔrebɔ no akyi no, sɛ ade kye so a, wotumi we. ");
INSERT INTO twi_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Afɔrebɔ nam biara a ebedi nnansa no de, wɔnhyew. ");
INSERT INTO twi_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Sɛ obi we nea adi nnansa no bi a, Awurade rennye afɔrebɔde no; na ɛrenni mu sɛ afɔrebɔde, na onipa a ɔde bae sɛ wɔmfa mmɔ saa afɔre no rennya so mfaso biara. Ɔsɔfo a ɔbɛwe no nso bedi ho fɔ, efisɛ ɛyɛ akyiwade ma Awurade; na onipa a ɔbɛwe saa nam no, ɛsɛ sɛ oyi ne ho ano wɔ saa bɔne no ho. ");
INSERT INTO twi_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Nam biara a ɛka biribi a wɔntew ho no, wɔnnwe; wɔnhyew. Nam biara a aka de, obiara a ne ho tew wɔ ho kwan sɛ ɔwe. ");
INSERT INTO twi_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ɔsɔfo biara a ne ho ntew na obedi asomdwoe afɔre no bi no, wobetwa no asu, efisɛ wagu ade kronkron ho fi. ");
INSERT INTO twi_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Obiara a ɔde ne nsa bɛka biribi a ɛho ntew no, sɛ ɛyɛ onipa anaa aboa na oguu ho fi na obedii asomdwoe afɔrebɔde no bi no, wobetwa no asu, efisɛ wagu ade kronkron ho fi.’ ” ");
INSERT INTO twi_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Afei, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Ka kyerɛ Israelfo no se wonnni srade, sɛ efi anantwi, nguan anaa mmirekyi mu. ");
INSERT INTO twi_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Sɛ ɔyare bi bɔ aboa bi na owu anaasɛ mmoa bɔne bi taataa aboa foforo bi kum no a, wonnni ne srade na mmom, wɔmfa nyɛ ade foforo. ");
INSERT INTO twi_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Obiara a obedi srade a efi afɔrebɔde a wɔbɔ no ogya so de ma Awurade no, ɛsɛ sɛ wotwa no asu. ");
INSERT INTO twi_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Munnni mogya—sɛ ɛyɛ nnomaa anaa ntɔteboa. ");
INSERT INTO twi_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Obiara a ɔbɛyɛ saa no, ɛsɛ sɛ wotwa no asu.” ");
INSERT INTO twi_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Ka kyerɛ Israelfo se obiara a ɔpɛ sɛ ɔbɔ Awurade asomdwoe afɔre no, ɔno ara nkita mmra. ");
INSERT INTO twi_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ɔmfa afɔrebɔde a ɛyɛ srade ne ne yan a wobehim wɔ afɔremuka no anim de ama Awurade no mmra. ");
INSERT INTO twi_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Afei, ɔsɔfo no bɛhyew srade no wɔ afɔremuka no so na ne yan no de, Aaron ne ne mmabarima bɛfa. ");
INSERT INTO twi_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ɛsɛ sɛ mode mo asomdwoe afɔrebɔde no srɛ nifa no ma ɔsɔfo no sɛ mo fam de. ");
INSERT INTO twi_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Na Aaron mmabarima no mu nea ɔde mogya ne srade a efi afɔrebɔde no mu no bɛba afɔremuka no so no na ɔbɛfa srɛ nifa no. ");
INSERT INTO twi_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Mahyɛ sɛ wɔmfa ne yan no ne ne srɛ no mma sɛ akyɛde a efi Israelfo nkyɛn a wɔde rebrɛ Aaron mmabarima. Bere biara, wɔmfa saa afɔrebɔde no kyɛfa yi no mma Aaron ne ne mmabarima.” ");
INSERT INTO twi_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Wɔn akatua ne no: Ɔhyew afɔrebɔ no, wɔde bɛto nkyɛn na wɔde ama wɔn a wɔayi wɔn sɛ Awurade asɔfo a ɛyɛ Aaron ne ne mmabarima no. ");
INSERT INTO twi_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Efisɛ da a Awurade sraa wɔn ngo no, ɔhyɛɛ sɛ Israelfo mfa saa kyɛfa no mma wɔn; ɛyɛ wɔn kyɛfa daa daa wɔ awo ntoatoaso ɛbɛba nyinaa mu. ");
INSERT INTO twi_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Eyinom ne amanne a ɛfa ɔhyew afɔrebɔ, atoko afɔrebɔ, bɔne afɔrebɔ, afɔdi afɔrebɔ, ahotew afɔrebɔ ne asomdwoe afɔrebɔ ho. ");
INSERT INTO twi_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Awurade de saa mmara yi maa Mose wɔ Sinai Bepɔw so sɛ ɔno nso mfa mma Israelfo no, sɛnea ɛbɛyɛ a wobehu ɔkwan a ɛsɛ sɛ wɔfa so bɔ wɔn afɔre ahorow no de ma Onyankopɔn wɔ Sinai sare so hɔ. ");
INSERT INTO twi_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Afei fa Aaron ne ne mmabarima bra Ahyiae Ntamadan no kwan no ano. Wɔmfa wɔn ntade, ɔsra ngo, nantwi ba a wɔde no bɛbɔ bɔne ho afɔre, adwennini abien ne brodo a mmɔkaw nni mu nkɛntɛn abien ");
INSERT INTO twi_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","na frɛ Israelfo no nyinaa na wɔmmra hɔ bi.” ");
INSERT INTO twi_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mose yɛɛ sɛnea Awurade hyɛɛ no no, na wohyiaa wɔ Ahyiae Ntamadan kwan no ano. ");
INSERT INTO twi_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mose ka kyerɛɛ wɔn se, “Ade a merebɛyɛ yi, Awurade na wahyɛ me sɛ menyɛ.” ");
INSERT INTO twi_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Afei, Mose de Aaron ne ne mmabarima no baa anim, na ɔde nsu hohoroo wɔn ho. ");
INSERT INTO twi_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ɔde Aaron atade sononko bi a ne mmeamu ka ho ne batakari a asɔfotade a wɔde tam a ɛyɛ fɛ ayɛ nʼabɔso hyɛɛ no. ");
INSERT INTO twi_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Afei, Mose de adɛbo fam Aaron bo de Urim ne Tumim a ase ne hann ne pɛyɛ no hyɛɛ mu. ");
INSERT INTO twi_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ɔbɔɔ Aaron abotiri kɛse bi a ɛwɔ sika abɔanim sɛnea Awurade hyɛɛ no sɛ ɔnyɛ no ara pɛ. ");
INSERT INTO twi_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Afei, Mose faa ɔsra ngo no de bi petee Ahyiae Ntamadan no ankasa ne biribiara a ɛwɔ mu ho de tew ne nyinaa ho. ");
INSERT INTO twi_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ɔpetee afɔremuka no so mpɛn ason. Afei, ɔpetee nkuku a ɛwɔ afɔremuka no so no ne hweaseammɔ ne ne ntaamu ho de tew ho. ");
INSERT INTO twi_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Afei, ohwiee ɔsra ngo no guu Aaron tirim de tew ne ho sɛ omfiti nʼadwuma ase. ");
INSERT INTO twi_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Nea edi hɔ ne sɛ, Mose de batakari hyehyɛɛ Aaron mmabarima a nkyekyeremu ne kyɛw ka ho, sɛnea Awurade hyɛɛ no sɛ ɔnyɛ no. ");
INSERT INTO twi_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Afei, ɔfaa nantwinini ba sɛ ɔde no rekɔbɔ bɔne ho afɔre. Aaron ne ne mmabarima de wɔn nsa guu aboa no apampam. ");
INSERT INTO twi_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mose kum no. Ɔde ne nsateaa baako bɔɔ ne mogya mu de yɛɛ afɔremuka mmɛn nan no ho ne afɔremuka no ankasa ho de tew ho, na ohwiee mogya no nkae no guu afɔremuka no ase de tew ho sɛ mpata. ");
INSERT INTO twi_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ɔfaa nʼayamde ho srade ne ne mmerɛbo ho srade ne nʼasaabo abien no ne ɛho srade hyew ne nyinaa wɔ afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Nanso ɔhyew nantwinini ba no ne ne nwoma ne ne nsono wɔ nsraban no akyi sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Afei, ɔde odwennini no maa Awurade sɛ ɔhyew afɔre. Aaron ne ne mmabarima de wɔn nsa guu aboa no apampam. ");
INSERT INTO twi_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Na Mose kum no de ne mogya no bi petee afɔremuka no ho nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Otwitwaa odwennini no nam na ɔhyew asinasin no a ne ti ne ne srade ka ho. ");
INSERT INTO twi_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Na ɔde nsu hohoroo nʼayamde ne nʼanan no ho hyew no wɔ afɔremuka no so maa ne nyinaa hyew dwerɛbee. Na ɛyɛ ɔhyew afɔre, ehua a ɛsɔ ani, aduan afɔre a wɔbɔ maa Awurade, sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Afei, Mose de odwennini baako a ɔyɛ asɔfohyɛ dwennini no bae. Aaron ne ne mmabarima de wɔn nsa guu nʼapampam. ");
INSERT INTO twi_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mose kum no na ɔde mogya no bi kaa Aaron aso nifa ase ne ne nsa nifa kokurobeti ne ne nan nifa kokurobeti. ");
INSERT INTO twi_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ɔde mogya no bi yɛɛ Aaron mmabarima no nso aso nifa ase ne wɔn nsa nifa kokurobeti ne wɔn anan nifa kokurobeti. Ɔde mogya no nkae petee afɔremuka no ho nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Afei, ɔfaa srade no, ne dua, ne ne mu srade, ne bɔnwoma kotoku, nʼasaabo abien no ne ɛho srade ne ne srɛ nifa no. ");
INSERT INTO twi_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Na ɔde saa brodo ntrantraa a mmɔkaw nni mu no baako nso ne brodo ntrantraa no baako a wɔde ngo agu so ne brodo ntrantraa baako a wɔfaa ne nyinaa fii kɛntɛn a wɔde besii hɔ wɔ Awurade anim no mu guguu eyinom nyinaa so. ");
INSERT INTO twi_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Wɔde eyinom nyinaa hyɛɛ Aaron ne ne mmabarima nsa na wonhim no wɔ Awurade anim sɛ ohim afɔrebɔ. ");
INSERT INTO twi_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mose gyee ne nyinaa fii wɔn nsam hyew no wɔ afɔremuka no so wɔ ɔhyew afɔre no so sɛ asɔfohyɛ afɔrebɔ, ehua a ɛsɔ ani, aduan afɔre a wɔbɔ ma Awurade. ");
INSERT INTO twi_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Afei Mose nso faa ne yan no a na ɛyɛ ne kyɛfa wɔ asɔfohyɛ dwennini nam no mu no hinhim wɔ Awurade anim sɛ ohim afɔrebɔ, sɛnea Awurade hyɛɛ no sɛ ɔnyɛ no. ");
INSERT INTO twi_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Afei ɔfaa ɔsra ngo no ne mogya a ɔde apete afɔremuka no so no bi de petee Aaron ne ne mmabarima ntade mu de tew Aaron ne ne mmabarima ne wɔn ntade ho maa Awurade dwumadi. ");
INSERT INTO twi_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mose ka kyerɛɛ Aaron ne ne mmabarima no se, “Monnoa nam no wɔ Ahyiae Ntamadan no kwan ano na momfa nni brodo a ɛwɔ kɛntɛn a asɔfohyɛ afɔrebɔde wɔ mu no sɛnea meka kyerɛɛ mo no. ");
INSERT INTO twi_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Nam ne brodo biara a ɛbɛka no, monhyew. ");
INSERT INTO twi_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Bio, ɔka kyerɛɛ wɔn se wɔntena Ahyiae Ntamadan no ano nnanson, mfa nwie asɔfohyɛ dwumadi no. ");
INSERT INTO twi_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Mose kaa bio se nea ɔyɛɛ no da no nyinaa no, Awurade na ɔhyɛɛ no sɛ ɔnyɛ mfa nyɛ mpata mma wɔn. ");
INSERT INTO twi_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ɔsan hyɛɛ Aaron ne ne mmabarima no sɛ wɔntena Ahyiae Ntamadan no ano anadwo ne awia nnanson. Ɔka kyerɛɛ wɔn se, ‘Sɛ mufi hɔ a, mubewuwu. Eyi ne asɛm a Awurade aka.’ ” ");
INSERT INTO twi_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Enti Aaron ne ne mmabarima dii nsɛm a Awurade nam Mose so hyɛɛ wɔn sɛ wɔnyɛ no nyinaa so. ");
INSERT INTO twi_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ahodwira no akyi da a ɛto so awotwe no, Mose frɛɛ Aaron ne ne mmabarima ne Israel mpanyimfo nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ɔka kyerɛɛ Aaron se ɔnkɔkyere nantwinini ba mfi anantwi no mu na ɔmfa no mmɔ bɔne afɔre, na ɔnkyere odwennini a ne ho nni dɛm mfa no mmɔ ɔhyew afɔre. Ɔka kyerɛɛ no se ɔmmɔ saa afɔre yi nyinaa wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Afei Mose ka kyerɛɛ wɔn se, “Monka nkyerɛ Israelfo na wonyi ɔpapo mfa no mmɔ bɔne afɔre mma wɔn ho, na wɔmfa nantwi a wadi afe ne oguamma a wadi afe a wɔn ho nni dɛm biara mmɔ wɔn ɔhyew afɔre no, ");
INSERT INTO twi_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","na wɔmfa nantwinini ne odwennini mmɔ asomdwoe afɔre na wɔmfa asikresiam a wɔde ngo afra mmɔ aduan afɔre mma Awurade, efisɛ nnɛ, Awurade beyi ne ho adi akyerɛ mo.” ");
INSERT INTO twi_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Enti wɔde saa nneɛma yi nyinaa baa Ahyiae Ntamadan no kwan ano sɛnea Mose hyɛe no. Nnipa no nyinaa begyinagyinaa Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mose ka kyerɛɛ wɔn se, “Eyi na Awurade ahyɛ mo sɛ monnyɛ na Awurade anuonyam ada ne ho adi akyerɛ mo.” ");
INSERT INTO twi_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mose ka kyerɛɛ Aaron se ɔnkɔ afɔremuka no so na ɔnkɔbɔ bɔne ne ɔhyew afɔre no mfa nyɛ mpata mma ne ho ansa na ato nnipa no sɛnea Awurade hyɛe no. ");
INSERT INTO twi_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Enti Aaron foro kɔɔ afɔremuka no so. Okum nantwi ba no de bɔɔ ɔno ara ne bɔne ho afɔre. ");
INSERT INTO twi_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ne mmabarima no de mogya no brɛɛ no na ɔde ne nsateaa baako bɔɔ mu sraa mmɛn a ɛwɔ afɔremuka no ho no na ohwiee nkae no guu afɔremuka no ase. ");
INSERT INTO twi_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Afei, ɔhyew srade, asaabo, bɔnwoma, bɔnwoma nkotoku a efi bɔne afɔrebɔde no mu sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Na nam no de, ɔhyew ne ne nwoma wɔ nsraban no akyi. ");
INSERT INTO twi_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Nea edi hɔ ne sɛ, okum ɔhyew afɔre aboa no maa ne mmabarima sɔw mogya no ma ɔde petee afɔremuka no ho nyinaa, ");
INSERT INTO twi_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Wɔde aboa no brɛɛ no asinasin a ne ti ka ho. Ɔhyew aboa no akwaa biara wɔ afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Afei, ɔhoroo aboa no ayamde ne ne nan ho hyew wɔ afɔremuka no so sɛ ɔhyew afɔre. ");
INSERT INTO twi_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Afei, ɔbɔɔ afɔre maa ɔmanfo. Okum abirekyi nanso ɔfaa ɔkwan koro a ɔfaa so bɔɔ bɔne afɔre maa ne ho no so bɔɔ afɔre maa ne ho. ");
INSERT INTO twi_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Saa ɔkwan no so na ɔfa bɔɔ wɔn ɔhyew afɔre de maa Awurade sɛnea Onyankopɔn mmara kyerɛ no. ");
INSERT INTO twi_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Afei, ɔbɔɔ atoko afɔre no, ɔfaa ne nsa mma na ɔhyew wɔ afɔremuka no so de kaa anɔpa ɔhyew afɔrebɔ no ho. ");
INSERT INTO twi_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Okum nantwi ne odwennini no a ɛyɛ nnipa no asomdwoe afɔrebɔde no. Aaron mmabarima no de mogya no brɛɛ no ma ɔde petee afɔremuka no ho nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Oyii nantwi no ne odwennini no srade. Oyii wɔn dua mu srade ne wɔn ayamde srade, ne wɔn asaabo ne wɔn bɔnwoma kotoku no. ");
INSERT INTO twi_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Wɔde srade no guu mmoa no yan so na Aaron hyew wɔ afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Na ohim yan no ne mmoa no mmati nifa no wɔ Awurade anim de kyerɛɛ sɛ afɔre no yɛ ne dea, sɛnea Mose hyɛe no. ");
INSERT INTO twi_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Afei, Aaron trɛw ne nsam wɔ nnipa no so hyiraa wɔn, na osian fii afɔremuka no ho sii fam. ");
INSERT INTO twi_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mose ne Aaron kɔɔ Ahyiae Ntamadan mu hɔ na wɔsan baa bio no, wohyiraa nnipa no na Awurade anuonyam baa nnipa no nyinaa so. ");
INSERT INTO twi_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Na ogya fi Awurade nkyɛn bɛhyew ɔhyew afɔrebɔde no ne srade a ɛwɔ afɔremuka no so no. Na nnipa no huu eyi no, wɔn nyinaa teɛteɛɛ mu butubutuw fam wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Na Aaron mma Nadab ne Abihu de ogya guu wɔn aduhuamyɛfo ade mu. Wɔde aduhuam no petee ogya no so ma wɔnam saa kwan yi so buu Awurade mmara so, efisɛ wɔde ogya a ɛnyɛ nea Awurade ahyɛ baa nʼanim. ");
INSERT INTO twi_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Enti ogya dɛw fii Awurade nkyɛn bɛhyew wɔn. ");
INSERT INTO twi_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mose ka kyerɛɛ Aaron se, Awurade kae se, “ ‘Mɛda me ho kronkronyɛ adi akyerɛ wɔn a wɔba me nkyɛn; wɔbɛhyɛ me anuonyam wɔ nnipa nyinaa anim no, na nea ɔrekyerɛ nen.’” Na asɛm no tɔɔ Aaron mum. ");
INSERT INTO twi_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mose soma ma wɔkɔfrɛɛ Misael ne Elsafan a wɔyɛ Aaron agya nuabarima mma brɛɛ no. Ɔka kyerɛɛ wɔn se, “Monkɔtwe nnipa a wɔahyew no nyinaa mfi Ahyiae Ntamadan no anim mfa wɔn nkɔ nsraban no akyi.” ");
INSERT INTO twi_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Na wɔkɔsoaa wɔn wɔ wɔn ntade mu sɛnea Mose aka akyerɛ wɔn no. ");
INSERT INTO twi_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mose ka kyerɛɛ Aaron ne ne mmabarima Eleasar ne Itamar se, “Munnsu. Mommma mo tinwi nsensɛn hɔ yuu mmfa nkyerɛ sɛ moretwa agyaadwo. Munnsunsuane mo ntade mu nso. Sɛ moyɛ saa a, Onyankopɔn bekum mo nso na nʼabufuw bɛba Israelfo nyinaa so. Nanso Israelfo a wɔaka no de, esiane ogya a Awurade de bae no nti, wotumi di Nadab ne Abihu wu no ho awerɛhow, tumi su wɔn nso. ");
INSERT INTO twi_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Na mummfi Ahyiae Ntamadan no ano, anyɛ saa a mubewuwu, efisɛ Awurade ngosra wɔ mo so.” Na wodii asɛm a Mose kae no so. ");
INSERT INTO twi_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Afei, Awurade hyɛɛ Aaron se, ");
INSERT INTO twi_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Sɛ wokɔ Ahyiae Ntamadan no mu a, nnom bobesa anaa nsa a ano yɛ den. Woyɛ saa a, wubewu. Saa mmara yi bɛtena hɔ afebɔɔ ama awo ntoatoaso a ɛbɛba no nyinaa, ");
INSERT INTO twi_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","na ama moatumi ahu nsonoe a ɛda kronkron ne nea ɛyɛ teta, nea ɛho tew ne nea ɛho ntew no tam, ");
INSERT INTO twi_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","na woatumi akyerɛkyerɛ Israelfo mmara a Awurade nam Mose so de ama mo no nyinaa.” ");
INSERT INTO twi_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mose ka kyerɛɛ Aaron ne ne mmabarima Eleasar ne Itamar se, “Momfa atoko afɔrebɔde nkae wɔ aduan afɔrebɔ a mmɔkaw nni mu a wɔde brɛɛ Awurade no na munni wɔ afɔremuka no ho, efisɛ ɛyɛ kronkron koraa. ");
INSERT INTO twi_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Munni wɔ kronkronbea hɔ. Ɛyɛ wo ne wo mmabarima no dea, na ɛyɛ wo ne wo mmabarima no kyɛfa a efi aduan afɔrebɔ a wɔde brɛɛ Awurade no mu; efisɛ saa na wɔahyɛ sɛ menyɛ. ");
INSERT INTO twi_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Nanso ne yan ne ne srɛ a muhim no Awurade anim no, mutumi we no beae biara a amanne kwan so no ɛhɔ tew. Ɛyɛ wo, wo mmabarima ne wo mmabea kyɛfa wɔ Israelfo Asomdwoe afɔrebɔde no mu. ");
INSERT INTO twi_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ne srɛ ne ne yan a wohim no, ɛsɛ sɛ wɔde ka srade afɔrebɔde a wɔhyew de ma Awurade no ho. Eyi bɛyɛ wo ne wʼasefo kyɛfa daa, sɛnea Awurade ahyɛ no.” ");
INSERT INTO twi_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Bere a Mose bisaa nea ayɛ abirekyi a wɔde no bɛbɔ bɔne afɔre no ho asɛm no, ohuu sɛ wɔahyew no. Ɛno nti, ne bo fuw Eleasar ne Itamar a na wɔyɛ Aaron mmabarima no, bisae se, ");
INSERT INTO twi_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Adɛn nti na moanwe bɔne afɔrebɔde no wɔ kronkronbea hɔ? Ɛyɛ afɔrebɔde kronkron! Wɔde maa mo sɛ momfa nyi nnipa no afɔdi na ɛnyɛ mpata mma wɔn wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Esiane sɛ wɔamfa ne mogya ankɔ kronkronbea hɔ no nti, anka mubetumi awe wɔ hɔ ara sɛnea mehyɛe no.” ");
INSERT INTO twi_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaron buaa Mose se, “Nnɛ wɔbɔɔ wɔn bɔne afɔre ne ɔhyew afɔre maa Awurade. Nanso hwɛ asɛm yi a ato me. Sɛ mewee bɔne afɔre nam yi bi nnɛ a, anka Awurade ani bɛsɔ ana?” ");
INSERT INTO twi_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Na Mose tee saa no, ne bo dwoe. ");
INSERT INTO twi_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Afei, Awurade ka kyerɛɛ Mose ne Aaron se, ");
INSERT INTO twi_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Monka nkyerɛ Israelfo no se, ‘eyi ne mmoa a mubetumi awe wɔ asase so mmoa no mu. ");
INSERT INTO twi_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Mutumi we aboa biara a ne tɔte mu apae kosi nea opuw wosaw so. ");
INSERT INTO twi_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Monnnwe mmoa a wodidi so yi. Yoma, efisɛ opuw wosaw nanso ne tɔte mu mpae; ne ho ntew mma mo. ");
INSERT INTO twi_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Atwaboa, efisɛ opuw wosaw nanso ne tɔte mu mpae; ne ho ntew mma mo. ");
INSERT INTO twi_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Adanko, efisɛ opuw wosaw nanso ne tɔte mu mpae; ne ho ntew mma mo. ");
INSERT INTO twi_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Prako, efisɛ ne tɔte mu apae nanso ompuw nwosaw; ne ho ntew mma mo. ");
INSERT INTO twi_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Monnnwe wɔn nam anaa mommfa mo nsa nka wɔn funu; wɔn ho ntew mma mo. ");
INSERT INTO twi_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Munni nsumnam biara a ɛwɔ ntɛtɛ ne abon a efi nsubɔnten anaa po mu. ");
INSERT INTO twi_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Nanso nsumnam a aka no de, mukyi. ");
INSERT INTO twi_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ɛnsɛ sɛ mowe wɔn nam anaa mode mo nsa ka wɔn afunu; wɔn ho ntew. ");
INSERT INTO twi_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Miti mu sɛ, nsumnam biara a enni ntɛtɛ anaa abon no, mukyi, wɔn ho ntew. ");
INSERT INTO twi_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Nnomaa a ɛsɛ sɛ mubu wɔn sɛ wɔn ho ntew nti mukyi no korakora nso ne: ɔkɔre, ne opete ne opetebiri, ");
INSERT INTO twi_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ɔkompete, ɔsansa, ");
INSERT INTO twi_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","kwaakwaadabi, ");
INSERT INTO twi_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","sohori, patukɛse, po so akorɔma, akorɔma, ");
INSERT INTO twi_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","patu, sare so patu, patukɛse, ");
INSERT INTO twi_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","bakanoma, nantwinoma, opete, ");
INSERT INTO twi_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","asukɔnkɔn, asuɔkwaa ne ampan. ");
INSERT INTO twi_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Mmoawa a wotu a wɔn anan yɛ anan no nso nyɛ mmoa a wɔn ho tew; ɛnsɛ sɛ mowe. ");
INSERT INTO twi_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Mmom, wɔn a wɔn anan bɔ mu a wɔde huruwhuruw wɔ fam no de mutumi we. ");
INSERT INTO twi_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ebi ne mmoadabi ahorow nyinaa, nketekre, ne tɛwtɛw nyinaa mutumi we. ");
INSERT INTO twi_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Nanso mmoawa a wotu na wɔwɔ anan anan no de, munhu sɛ wɔn ho ntew. ");
INSERT INTO twi_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Obiara a ɔde ne nsa bɛka wɔn funu no mpo ho begu fi kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Obiara a ɔbɛfa bi no ɛsɛ sɛ ɔhoro ne ntama na ɔtwe ne ho fi nnipa mu kosi anwummere de kyerɛ sɛ ne ho agu fi. ");
INSERT INTO twi_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Obiara a ɔde ne nsa bɛka aboa biara a ne tɔte mu mpae nwiei anaa aboa a ompuw nwosaw no, wagu ne ho fi. ");
INSERT INTO twi_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Aboa biara a nʼanan yɛ anan na ɔnam nʼawerɛw so no, mukyi ne nam. Obiara a ɔde ne nsa bɛka aboa a ɔte saa funu no ho begu fi kosi anwummere; ɛyɛ mo akyiwade. ");
INSERT INTO twi_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Obiara a ɔbɛfa saa aboa no funu no, ɛsɛ sɛ ɔhoro ne ntama na ne ho rentew ara kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Mmoa a wɔwea wɔ fam a wɔn ho ntew no ni: Ahweaa, okisi, ɔketew abusua a wɔsoso, ");
INSERT INTO twi_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","opo, ɔmampam, ɔdan ne na, ɔketew, ne ɔbosomaketew. ");
INSERT INTO twi_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Wɔn a wɔwea no nyinaa ho ntew mma mo, obiara a ɔde ne nsa bɛka wɔn mu bi funu no ho begu fi akosi anwummere ");
INSERT INTO twi_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Biribiara a wɔn funu no bɛka no nso ho begu fi, sɛ ɛyɛ dua, ntama, kuntu, kotoku; biribiara a ɛbɛka no, wɔmfa ngu nsu mu nkosi anwummere. Ɛno akyi no, ɛho bɛtew. ");
INSERT INTO twi_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kuku biara a bi bɛtɔ mu no, nea ɛwɔ mu biara ho begu fi enti ɛsɛ sɛ wɔbɔ saa kuku no. ");
INSERT INTO twi_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Nsu a wɔde bɛhohoro nneɛma a ɛho ntew no ho wɔ kuku no mu no, sɛ bi ka aduan bi a, ebegu aduan no ho fi. Na nsã biara a ɛwɔ kuku a ɛho agu fi no mu no nso ho begu fi saa ara. ");
INSERT INTO twi_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Sɛ aboa biara a ne ho agu fi funu ka fononoo a wɔde ɔbo anwen a, na ɛno nso ho agu fi enti ɛsɛ sɛ wobubu gu. ");
INSERT INTO twi_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Sɛ aboa no tew hwe asuti anaa abura bi a nsu wɔ mu a, nsu no ho rengu fi, na mmom, onipa a obeyi aboa no ho na ebegu fi. ");
INSERT INTO twi_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Na sɛ aboa no funu ka aduan a wobedua wɔ afum a, ɛho rengu fi, ");
INSERT INTO twi_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Nanso sɛ wɔfɔw aba no nsu na funu no tɔ so a, aba no ho begu fi. ");
INSERT INTO twi_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Sɛ ɔyare bi kum aboa a wɔama wo ho kwan sɛ we ne nam a, obi a ɔde ne nsa bɛka ne funu no no ho begu fi akosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Saa ara nso na onipa a ɔbɛwe ne nam no bɛhoro ne ntama na ne ho agu fi akosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Monnnwe mmoa a wɔwea wɔ fam no nam. ");
INSERT INTO twi_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Wɔn a wɔtwe wɔn ho ase fa wɔn afuru so ne wɔn a wɔnam wɔn anan anan so nyinaa ka ho. Monnnwe wɔn a wɔwɔ anan bebree na wɔwea no nam nso, efisɛ wɔn ho agu fi. ");
INSERT INTO twi_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Mfa wo ho nka wɔn na wo ho angu fi. ");
INSERT INTO twi_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Mene Awurade wo Nyankopɔn. Momma mo ho ntew wɔ saa nneɛma yi nyinaa ho na monyɛ kronkron, efisɛ meyɛ kronkron. Eyi nti, mommfa mo nsa nkɔka mmoa a wɔwea wɔ fam yi mu biara mfa ngu mo ho fi. ");
INSERT INTO twi_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Mene Awurade a miyii mo fii Misraim de mo bɛyɛɛ mo Nyankopɔn no. Ɛno nti, ɛsɛ sɛ moyɛ kronkron, efisɛ meyɛ kronkron. ");
INSERT INTO twi_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Eyi ne mmara a ɛfa mmoa, nnomaa, nsumnam ne wɔn a wɔwea asase so no ho. ");
INSERT INTO twi_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Eyi ne nsonoe a ɛda mmoa a wɔn ho tew a ɛsɛ sɛ wɔwe wɔn nam ne wɔn a wɔn ho ntew a ɛnsɛ sɛ wɔwe wɔn nam wɔ mmoa a wɔwɔ asase so no ntam.’ ” ");
INSERT INTO twi_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Awurade ka kyerɛɛ Mose se, “Ka kyerɛ Israelfo no se, ");
INSERT INTO twi_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","‘Sɛ ɔbea bi wo ɔbabarima a, ne ho ntew nnanson, te sɛ nea ɔkɔ afikyiri a ne ho ntew no ara. ");
INSERT INTO twi_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ne nnaawɔtwe so no, ɛsɛ sɛ wotwa abarimaa no twetia. ");
INSERT INTO twi_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Na nnafua aduasa abiɛsa a ɛda nʼanim a ɔde retew ne ho no, ɛnsɛ sɛ oso biribiara a ɛyɛ kronkron mu na onni ho kwan sɛ ɔkɔ hyiadan mu nso. ");
INSERT INTO twi_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Sɛ ɔbea bi wo ɔbabea a, ne ho ntew nnaawɔtwe abien, te sɛ nea ɔkɔ afikyiri a ne ho ntew no ara. Afei ɛsɛ sɛ ɔtwɛn nnafua aduosia asia ma ne ho twa. ");
INSERT INTO twi_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Sɛ saa ahotew nna yi twa mu a, ɛsɛ sɛ ɔde oguamma a wadi afe bɛbɔ ɔhyew afɔre na ɔde aborɔnoma anaa aturukuku ba bɛbɔ bɔne ho afɔre. Ɛsɛ sɛ ɔde wɔn kɔ Ahyiae Ntamadan no ano kɔma ɔsɔfo no. ");
INSERT INTO twi_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Na ɔsɔfo no de wɔn bɛma Awurade de ayɛ mpata ama ɛna no; ɛba saa a, ne ho tew bio wɔ nʼawo mu mogyagugu ho. “ ‘Eyinom ne awo akyi ahyɛde. ");
INSERT INTO twi_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Na sɛ ɔyɛ ohiani a ɔrennya oguamma no a, ɛno de, ɛsɛ sɛ ɔde mmorɔnoma abien anaa nturukuku mma abien ba. Wɔde ɔbaako bɛbɔ ɔhyew afɔre na wɔde ɔbaako abɔ bɔne ho afɔre. Ɔsɔfo no bɛfa saa kwan yi so ayɛ mpata ama no, sɛnea ɛbɛyɛ a ne ho bɛtew bio.’ ” ");
INSERT INTO twi_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Awurade ka kyerɛɛ Mose ne Aaron se, ");
INSERT INTO twi_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Sɛ obi hu sɛ biribi ahon ne honam ani, anaa pɔmpɔ anaa atape asi no na adidi akɔ ne honam mu a, onhu sɛ ɛyɛ kwata. Ɛsɛ sɛ wɔde saa onipa no kɔma ɔsɔfo Aaron anaa ne mmabarima no mu baako ");
INSERT INTO twi_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","na ɔhwɛ kuru no. Sɛ nwi a esi kuru no hɔ dan yɛ fitaa na kuru no atu atɔ ɔhonam no mu a, na ɛyɛ kwata a ɛsɛ sɛ ɔsɔfo no da no adi sɛ ɔyarefo no yɛ ɔkwatani. ");
INSERT INTO twi_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Na sɛ kuru no ntɔɔ ɔhonam no mu na sɛ kuru no hɔ nwi no nso nyɛɛ fitaa a, ɛsɛ sɛ ɔsɔfo no yi ɔyarefo no fi nnipa mu nnanson. ");
INSERT INTO twi_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Nnanson no du a, ɔsɔfo no bɛhwɛ no bio na sɛ kuru no nsakrae na ɛntrɛwee wɔ ɔhonam no ani a, ɔsɔfo no bɛsan atwa no asu nnanson bio. ");
INSERT INTO twi_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Afei ne nnanson so no, ɔsɔfo no bɛhwɛ ne honam ani bio, na sɛ ohu sɛ ɔyare no ano abrɛ ase a ɛntrɛwee a, ɔsɔfo no bɛka ato gua sɛ, ɔyarefo no ho atɔ no; ɔbɛkyerɛ mu sɛ ɛyɛ ntwom bi na eguu no bere tiaa bi mu. Enti sɛ ɔyarefo no horo ne ntama a, wɔbɛfa no sɛ wanya ayaresa awie. ");
INSERT INTO twi_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Na sɛ nso ɔyarefo no ba ɔsɔfo no nkyɛn ma ɔhwɛ no na ɔyare no atrɛtrɛw a, ɛsɛ sɛ ɔsan ba ɔsɔfo no nkyɛn bio ");
INSERT INTO twi_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","na ɔhwɛ no na sɛ ɔyare no atrɛtrɛw wɔ ɔhonam no ani a, afei, ɔbɛpae mu aka sɛ amanne kwan so no, ne ho ntew na ɛyɛ ɔhonam ani nsanyare. ");
INSERT INTO twi_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Sɛ obi nya ɔhonam ani nsanyare a, ɛsɛ sɛ wɔde no kɔkyerɛ ɔsɔfo na ɔhwɛ no. ");
INSERT INTO twi_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Sɛ ɔsɔfo no hu sɛ nwi no bi ayɛ fitaa na kuru atɔ saa beae hɔ a, ");
INSERT INTO twi_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","na ɛkyerɛ sɛ ɛyɛ ɔhonam ani nsanyare, na ɛsɛ sɛ ɔsɔfo no de to gua sɛ amanne kwan so no, onipa no ho ntew. Ɛba saa a, wɔnhwehwɛ ɔyare no mu bio, efisɛ ɛda adi pefee sɛ ɔhonam no ayɛ kwata. ");
INSERT INTO twi_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Nanso sɛ ɔsɔfo no hu sɛ kwata no adidi ne honam nyinaa fi ne ti so kosi ne nan ase nyinaa a, ");
INSERT INTO twi_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ɔsɔfo no bɛpae mu aka se ne ho tew, efisɛ ne honam nyinaa adan ayɛ fitaa. ");
INSERT INTO twi_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Na sɛ akuru no bi pue ne honam no baabi foforo a, wɔbɛpae mu aka sɛ onipa no yɛ ɔkwatani. ");
INSERT INTO twi_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Ɛsɛ sɛ ɔsɔfo no pae mu ka ntɛm ara a ohu kuru wɔ honam no fa baabi, efisɛ akuru no kyerɛ sɛ kwata wɔ ɔhonam no mu. ");
INSERT INTO twi_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Na sɛ akuru no wu na ɛdan yɛ fitaa sɛ ɔhonam a aka no a, ɔkwatani no bɛkɔ ɔsɔfo no hɔ bio. ");
INSERT INTO twi_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ɔsɔfo no bɛhwɛ no na sɛ ɔhonam no fa hɔ ayɛ fitaa de a, ɔsɔfo no bɛpae mu aka sɛ ne ho atɔ no. ");
INSERT INTO twi_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Sɛ pɔmpɔ si obi na agyae ");
INSERT INTO twi_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","na sɛ baabi a pɔmpɔ no sii no biribi hyerɛnn bi, anaa nea ɛbere kakra hon wɔ hɔ a, ɛsɛ sɛ ɔde ne ho kɔkyerɛ ɔsɔfo. ");
INSERT INTO twi_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Na sɛ ɔsɔfo no hwɛ na ɔyare no adidi kɔ ne honam mu na nwi a ɛwɔ ɔhonam no hɔ no ayɛ fitaa a, ɔsɔfo no bɛpae mu aka se ɔyarefo no ho ntew, efisɛ kwata apue afi pɔmpɔ no mu. ");
INSERT INTO twi_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Nanso sɛ ɔsɔfo no hwɛ na ohu sɛ nwi fitaa biara nni baabi a ɔyare no wɔ hɔ no, na ɔyare no nnidi nkɔɔ honam no mu, na ahosu no yɛ nsonso a ɔsɔfo no beyi no afi nnipa mu nnanson. ");
INSERT INTO twi_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Saa bere no mu sɛ beae hɔ no trɛtrɛw a, ɔsɔfo no bɛpae mu aka se, onipa no yare kwata. ");
INSERT INTO twi_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Na sɛ beae a ɛhɔ ayɛ hyerɛnn no anhon bio na antrɛtrɛw a, na ɛyɛ pɔmpɔ no twa kɛkɛ enti ɔsɔfo no bɛpae mu aka se ne ho tew. ");
INSERT INTO twi_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Sɛ obi hyehyew na sɛ ɔhyehyew no mu yɛ kɔkɔɔ ne fitaa anaa fitaa a, ");
INSERT INTO twi_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ɛsɛ sɛ ɔsɔfo no hwɛ faako a ɔhyehyew no wɔ. Sɛ nwi a ɛwɔ beae a ɛhɔ nnii dɛm biara no dan yɛ fitaa na sɛ ɛyɛ ade a adidi kɔ ɔhonam no mu a, na ɛyɛ kwata na apue afi ɔhyehyew no mu, enti ɛsɛ sɛ ɔsɔfo no pae mu ka sɛ onipa no yɛ ɔkwatani. ");
INSERT INTO twi_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Na sɛ ɔsɔfo no hwɛ hu sɛ nwi fitaa nni beae a ɛhɔ yɛ hyerɛnn no, na sɛ hyerɛnn no nnidi nkɔɔ ɔhonam no mu, na ɔyare no regyae a, ɔsɔfo no beyi no afi nnipa mu nnanson ");
INSERT INTO twi_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","na wahwɛ no ne nnanson so bio. Sɛ ɔyare no trɛw fa ɔhonam no ani a, ɛsɛ sɛ ɔsɔfo no pae mu ka se kwata ayɛ onipa no. ");
INSERT INTO twi_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Nanso sɛ ɔhonam no fa hɔ a ayɛ hyerɛnn no antrɛtrɛw ɔhonam no ani, na sɛ ɛyɛ sɛ nea ɛhɔ retwintwam no a, wɔbɛfa no sɛ ɛyɛ ɔhyehyew twa bi, enti ɔsɔfo no bɛda no adi sɛ ɔnyare kwata. ");
INSERT INTO twi_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Sɛ kuru da ɔbarima anaa ɔbea bi tirim anaa nʼafono ho a, ");
INSERT INTO twi_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ɛsɛ sɛ ɔsɔfo no hwɛ; sɛ ɔhwɛ na ohu sɛ ɔyare no adidi kɔ ɔhonam no mu na ɔsan hu nwi a ɛte sɛ akokɔsrade wɔ kuru no mu a, ɛsɛ sɛ ɔpae mu ka se onipa no yare kwata. ");
INSERT INTO twi_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Na sɛ ɔsɔfo no hwɛ na ohu sɛ ɔyare no nnidi nkɔɔ ɔhonam no mu, na mmom, ɛwɔ ɔhonam no ani a nwi tuntum wɔ mu a, ɛsɛ sɛ woyi onipa no fi nnipa mu nnanson, ");
INSERT INTO twi_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","na ne nnanson so no, wɔsan hwɛ no bio. Sɛ ɔyare no ntrɛtrɛwee, na nwi a ɛte sɛ akokɔsrade nnaa ne ho adi wɔ mu na ennidi nkɔɔ ɔhonam no mu a, ");
INSERT INTO twi_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ɔbɛtwerɛw nwi a atwa kuru no ho ahyia nyinaa (na mmom ɛnyɛ kuru no mu ankasa) na ɔsɔfo no ayi no afi nnipa mu nnanson bio. ");
INSERT INTO twi_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ne nnanson so no, ɔbɛsan ahwɛ no, na sɛ ɔyare no ntrɛtrɛw nnidi nkɔɔ ɔhonam no mu a, ɔsɔfo no bɛpae mu aka se onipa no ho atew na sɛ ɔhoro ne ntama wie a, na afei wadi mu. ");
INSERT INTO twi_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Na sɛ akyiri no saa ɔyare no trɛtrɛw a, ");
INSERT INTO twi_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ɛsɛ sɛ ɔsɔfo no hwɛ no bio a ɔhwɛ sɛ nwi a ɛte sɛ akokɔsrade fra ɔyare no mu na ɔpae mu ka se, onipa no yare kwata. ");
INSERT INTO twi_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Na sɛ ɔyare no trɛw a ɛtrɛtrɛw no gyae na sɛ nwi tuntum fuw wɔ beae hɔ a, na ɛkyerɛ sɛ, ne ho atɔ no a kwata biara nni ne ho enti ɛsɛ sɛ ɔsɔfo no pae mu ka se ne ho atew. ");
INSERT INTO twi_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Sɛ ɔbarima anaa ɔbea bi honam ani yɛ fitaa hanahana, ");
INSERT INTO twi_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","na akyiri no ɔhonam no ani dum ara na ɛredum a, na ɛnkyerɛ sɛ kwata ayɛ onipa no, na mmom, ɛyɛ ɔyare foforo bi. ");
INSERT INTO twi_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Sɛ obi ti so pa a, ɛwɔ mu sɛ ne ti so apa de, nanso ɛno nkyerɛ sɛ ɔyɛ ɔkwatani! ");
INSERT INTO twi_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Sɛ obi ti so pa fi ne moma so a, na ne moma so ara na apa, na ɛnkyerɛ sɛ ɛyɛ kwata. ");
INSERT INTO twi_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Na mmom, sɛ nsisii akɔkɔɔ a fitaa frafra mu wɔ tipae no so a, na ɛkyerɛ sɛ ebia kwata pɛ sɛ ɛyɛ saa onipa no. ");
INSERT INTO twi_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Sɛ ɛba saa a, ɔsɔfo no bɛhwɛ no na sɛ biribi kɔkɔɔ aboa ne ho baabi te sɛ kwata a, ");
INSERT INTO twi_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","na ɛkyerɛ sɛ, kwata ayɛ no, enti ɛsɛ sɛ ɔsɔfo no pae mu ka se, onipa no yare kwata. ");
INSERT INTO twi_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Onipa biara a wobehu sɛ ɔyare kwata no, ɛsɛ sɛ ofura ntama a atetew na ɔma ne tinwi fuw, twa mpɛsɛmpɛsɛ na ɔkata nʼanim fa na ɔnam a ɔteɛteɛ mu se, ‘Me ho ntew! Me ho ntew!’ ");
INSERT INTO twi_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Na nna dodow a ɔyare no nkɔe no de, wɔbɛfa ɔyarefo no sɛ ne ho ntew enti ɛsɛ sɛ ɔtena kurow no akyi baabi. ");
INSERT INTO twi_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Sɛ kwata ho nsɛnkyerɛnne bi ka atade, ");
INSERT INTO twi_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","kuntutam anaa nweratam, aboa nhoma anaa biribiara a wɔde aboa nwoma ayɛ mu, ");
INSERT INTO twi_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","na sɛ nsisii ahabammono anaa kɔkɔɔ wɔ mu a, ebia na ɛyɛ kwata, enti ɛsɛ sɛ wɔde kɔma ɔsɔfo na ɔhwɛ. ");
INSERT INTO twi_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Ɔsɔfo no de bɛkɔ akosie nnanson. ");
INSERT INTO twi_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Nnanson so no, wasan ahwɛ bio. Na sɛ ohu sɛ nsisii no atrɛtrɛw a, na ɛkyerɛ sɛ, ɛyɛ kwata a etumi san nnipa. ");
INSERT INTO twi_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ɛsɛ sɛ ɔde ogya hyew ntama, kuntu ne ntadetam ne aboa nwoma no nyinaa, efisɛ, ɛnam eyinom so betumi ama ɔyare no asan nnipa. ");
INSERT INTO twi_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Na sɛ ne nnanson so no ɔhwɛ na sɛ nsisii no ntrɛtrɛwee a, ");
INSERT INTO twi_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ɔsɔfo no bɛhyɛ ama wɔahoro nneɛma a wodwen sɛ ɔyare no bi wɔ mu no no nyinaa na wɔakora no baabi bio nnanson. ");
INSERT INTO twi_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Sɛ nnanson bio akyi faako a ɔyare no wɔ hɔ no nsesaa nʼahosu na ɛntrɛwee a, wɔbɛfa no sɛ ɛyɛ kwata nti ɛsɛ sɛ wɔhyew ade no, efisɛ ɔyare no adidi kɔ mu ara yiye. ");
INSERT INTO twi_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Na sɛ ɔsɔfo no hu sɛ nneɛmahoro no akyi, nsisii no ano abrɛ ase a, obetwa hɔ afi ntama anaa aboa nwoma a wɔde adi dwuma bi no mu. ");
INSERT INTO twi_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Na sɛ ɛsan ba bio de a, na ɛyɛ kwata enti ɛsɛ sɛ wɔhyew no. ");
INSERT INTO twi_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Sɛ wɔhoro na asɛm biara amma ho a, wotumi de di dwuma biara bere a wɔasan ahoro no.” ");
INSERT INTO twi_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Eyinom ne mmara a ɛfa kwata a ɛwɔ ntama anaa biribiara a wɔde aboa nhoma ayɛ a wɔnam so da no adi sɛ kwata wɔ dekode no mu anaa bi nni mu no ho. ");
INSERT INTO twi_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Onyankopɔn ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Da a wobedwira ɔkwatani ho no, ɛho mmara ni: Wɔde no bɛkɔ akɔma ɔsɔfo, ");
INSERT INTO twi_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","na ɔsɔfo no ahwɛ no wɔ nsraban no akyi. Na sɛ ɔsɔfo no hu sɛ kwata no agyae a, ");
INSERT INTO twi_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","obebisa nnomaa abien bi a wɔwe, na afei wɔde sida dua, koogyan hama ne adwerɛ mman a wɔde bɛyɛ ahodwira ahyɛde ama ɔkwatani no abrɛ no. ");
INSERT INTO twi_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ɔsɔfo no bɛka ama wɔakum nnomaa no mu baako wɔ asanka a nsu wɔ mu so. ");
INSERT INTO twi_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Na anomaa a wonnya nkum no no nso, wɔde ɔno ne sida dua no ne koogyan hama no ne adwerɛ mman no bɛhyɛ anomaa a wokum no no mogya no mu. ");
INSERT INTO twi_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Na ɔsɔfo no apete mogya no agu ɔkwatani a ne ho afi no so mpɛn ason, na wapae mu aka se ne ho atew na wagyaa anomaa a wonkum no no. ");
INSERT INTO twi_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Na ɔyarefo a ne ho atɔ no no bɛhoro ne ntama nyinaa. Obeyi ne ho nwi nyinaa nso. Obeguare na wasan abɛtena faako a kan no na ɔte hɔ no bio; nanso ɛsɛ sɛ ɔtena ne ntamadan akyi nnanson. ");
INSERT INTO twi_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Nnanson no so no, obeyi ne ho nwi nyinaa bio, obeyi nʼabogyesɛ ayi nʼanintɔn nwi na wayi ne ho nwi a aka nyinaa, na waguare, na afei wɔapae mu aka sɛ ne ho atew. ");
INSERT INTO twi_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Da a edi so a ɛyɛ nnaawɔtwe so no, ɔbɛfa adwennini abien a wɔn ho nni dɛm ne oguamma bere baako a ɔno nso ho nni dɛm, asikresiam muhumuhu lita asia ne fa a wɔde ngo afra ne ngo a wɔmfa mfraa hwee lita fa. ");
INSERT INTO twi_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Afei ɔsɔfo a ɔbɛhwehwɛ ɔyarefo no ho ahwɛ sɛ ne ho atɔ no no de onipa no ne nʼafɔrebɔde bɛba Awurade anim wɔ Ahyiae Ntamadan no ano. ");
INSERT INTO twi_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Ɔsɔfo no bɛfa nguantenmma no baako ne ngotoa baako no na ɔde ama Awurade sɛ afɔdi afɔrebɔ a wohim no wɔ afɔremuka no anim. ");
INSERT INTO twi_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Afei, wobekum oguamma no wɔ beae a wɔbɔ bɔne ne ɔhyew afɔre no wɔ kronkronbea hɔ. Wɔde saa afɔdi afɔrebɔde yi bɛma ɔsɔfo no sɛnea wɔyɛ no bɔne afɔrebɔ mu no ara pɛ. Ɛyɛ afɔrebɔ a ɛyɛ kronkron ankasa. ");
INSERT INTO twi_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ɔsɔfo no bɛfa saa afɔdi afɔrebɔde mogya na ɔde akeka ɔyarefo a wɔretew ne ho no aso nifa ase ne ne nsa nifa kokurobeti ne ne nan nifa kokurobeti. ");
INSERT INTO twi_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Afei, ɔsɔfo no bɛfa ngo no bi ahwie agu ne nsa benkum mu ");
INSERT INTO twi_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","na ɔde ne nsa nifa abɔ mu, na watu apete mpɛn ason wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ngo no a ɛbɛka ne nsa benkum mu no, ɔsɔfo no de bɛka onipa no aso nifa ase ne ne nsa nifa kokurobeti ne ne nan nifa kokurobeti sɛnea ɔde afɔdi mogya yɛe wɔ afɔdi afɔrebɔ no mu no ara pɛ. ");
INSERT INTO twi_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ɔde ngo no nkae a ɛwɔ ne nsam no bɛfɔw ɔbarima no ti ho. Eyi bɛkyerɛ sɛ, ɔsɔfo no de ne ho ayɛ mpata ama onipa no wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Afei, ɛsɛ sɛ ɔsɔfo no bɔ bɔne afɔre na ɔsan yɛ mpata ho ade ma onipa a wɔrehohoro ne ho afi ne kwata mu no ho; ɛno akyi no, ɔsɔfo no bekum ɔhyew afɔrebɔde no ");
INSERT INTO twi_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","na ɔde abɔ ɛne atoko afɔre wɔ afɔremuka no so de ayɛ mpata ama ɔbarima no na afei, wapae mu aka sɛ ne ho afi no. ");
INSERT INTO twi_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Sɛ ɔyɛ ohiani a ɔrentumi ntɔ nguamma abien no a, ɛno de, ɔde oguamma nini baako bɛbɔ afɔdi afɔre no de ama Awurade sɛ mpata a wohim wɔ afɔremuka no anim; na wɔde asikresiam fitaa muhumuhu lita abien ne fa a wɔde ngo afra de abɔ atoko afɔre no a ngo tumpan ka ho. ");
INSERT INTO twi_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Ɛno akyi no, ɔde mmorɔnoma abien anaa nturukuku mma abien mu biara a obenya no mu baako bɛbɔ bɔne afɔre na ɔde baako a ɛbɛka no nso abɔ ɔhyew afɔre. ");
INSERT INTO twi_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Da a ɛto so awotwe no, ɔde ne nyinaa bɛkɔ akɔma ɔsɔfo no wɔ Ahyiae Ntamadan no ano na ɔsɔfo no de adwira no wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ɔsɔfo no bɛfa oguamma no de abɔ afɔdi afɔre. Ɔde ngo tumpan ma bɛka ho na wahim wɔ afɔremuka no anim de akyerɛ sɛ, wɔde rema Awurade. ");
INSERT INTO twi_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Afei, wobekum oguamma no de no abɔ afɔdi afɔre na ɔde ne mogya no bi akeka ɔbarima a wɔredwira no no aso nifa ase. Ɔde mogya no bi bɛka ne nsa nifa kokurobeti ne ne nan nifa kokurobeti. ");
INSERT INTO twi_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ɔsɔfo no behwie ngo agu ɔno ara ne nsa benkum mu ");
INSERT INTO twi_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","na ɔde ne nsateaa nifa abɔ mu apete bi mpɛn ason wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Na ɛsɛ sɛ ɔde ngo a ɛwɔ ne nsam no bi ka ɔbarima no aso nifa ase ne ne nsa nifa kokurobeti ne ne nan nifa kokurobeti sɛnea ɔyɛɛ mogya no, bere a ɔrebɔ afɔdi afɔre no. ");
INSERT INTO twi_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ngo no a ɛbɛka wɔ ne nsam no, ɛsɛ sɛ ɔde fɔw ɔbarima a wɔredwira no no ti ho de yɛ mpata wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Afei, ɛsɛ sɛ ɔde nturukuku abien anaa mmorɔnoma abien no mu biara a otumi tɔe no ba. ");
INSERT INTO twi_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Wɔde abien a onyae no mu baako bɛbɔ bɔne afɔre na baako a aka no, ɔde abɔ ɔhyew afɔre a saa bere no ara mu wɔbɛbɔ atoko afɔre nso, na ɔsɔfo no bɛyɛ mpata ama ɔbarima no wɔ Awurade anim.” ");
INSERT INTO twi_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Eyinom ne mmara a ɛfa wɔn a wɔtew wɔn ho ma wɔn ho fi kwata mu nanso wontumi mfa afɔrebɔde a ɛho hia no nyinaa mma no. ");
INSERT INTO twi_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Afei, Awurade ka kyerɛɛ Mose ne Aaron se, ");
INSERT INTO twi_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Sɛ mudu Kanaan asase a mede ama mo no so, na sɛ mede kwata kɔ afi bi mu a, ");
INSERT INTO twi_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ɛno de, ofiwura no nyi ne ho adi nkyerɛ ɔsɔfo no na ɔnka se, ‘Ɛyɛ me sɛ kwata wɔ me fi ha!’ ");
INSERT INTO twi_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ɔsɔfo no bɛhyɛ ama wɔatu ofie hɔ nneɛma nyinaa ansa na wahwɛ hɔ sɛnea ɛbɛyɛ a, sɛ ɔka se kwata wɔ fie hɔ a, ɛrengu biribi foforo ho fi wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Sɛ ohu nsensansensan ahabammono anaa kɔkɔɔ wɔ ofie no afasu ho a anonom kɔ afasu no mu a, ");
INSERT INTO twi_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ɔbɛto ofi no mu nnanson ");
INSERT INTO twi_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","na ne nnanson so no, wasan aba bio abɛhwɛ. Na sɛ nsensansensan awurawura afasu no mu a, ");
INSERT INTO twi_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ɛno de, ɔsɔfo no bɛhyɛ ama wɔawerɛwerɛw nsisii no afi hɔ na wɔatow nwerɛwerɛwee no agu baabi a ɛhɔ ntew wɔ kurow no akyi baabi. ");
INSERT INTO twi_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Afei, ɔbɛhyɛ ama afasu a ɛwɔ ofi no mu no, wɔawerɛwerɛw no yiye na wɔatow nwerɛwerɛwee no agu baabi a ɛhɔ ntew wɔ kurow no akyi baabi. ");
INSERT INTO twi_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Na wɔde abo foforo bi abɛhyɛ nea wɔwerɛwerɛw no anan na wɔde dɔte foforo asra ofi no ho. ");
INSERT INTO twi_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Na sɛ nsisii no ba bio a, ");
INSERT INTO twi_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ɔsɔfo no bɛba bio abɛhwɛ na sɛ ohu sɛ nsisii no atrɛtrɛw a, na ɛyɛ kwata na ɛkyerɛ sɛ ofi no ho ntew. ");
INSERT INTO twi_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Sɛ ɛba saa a, ɔbɛhyɛ ama wɔabubu ofi no agu. Wɔbɛtwe mmubui no mu abo, nnua ne dɔte no nyinaa afi kurow no mu de akogu kurow no akyi baabi a ɛhɔ ntew. ");
INSERT INTO twi_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Obiara a obewura ofi a wɔato mu no mu no ho ntew kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Na obiara a ɔbɛda hɔ anaa obedidi wɔ fie hɔ no bɛhoro ne nneɛma nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Na sɛ wɔsra ofi no ho bio na ɔsɔfo no bɛhwɛ na nsisii no mmaa bio a, ɔbɛpae mu aka se wɔatew ofi no ho na kwata no nso kɔ. ");
INSERT INTO twi_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Obedi ofi no ahodwira ho dwuma. Ɔde nnomaa abien, sida dua, asaawa kɔkɔɔ ne adwerɛ mman na ebedi saa dwuma no. ");
INSERT INTO twi_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Obekum nnomaa no baako wɔ nsu pa a ɛwɔ asanka mu so, ");
INSERT INTO twi_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","na ɔde sida dua no ne adwerɛ mman ne hama kɔkɔɔ ne anomaa a wonkum no no anu anomaa a wɔakum no nsu pa no so no mogya mu na wɔde apete ofi no mpɛn ason. ");
INSERT INTO twi_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Wɔyɛ eyi de tew ofi no ho. ");
INSERT INTO twi_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Afei, obegyaa anomaa a onwui no ama watu akɔ kurow no akyi baabi. Eyi ne ɔkwan a wɔfa so de yɛ mpata de ma ofi san de dwira ho no.” ");
INSERT INTO twi_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Eyinom ne mmara a ɛfa mmeaemmeae a kwata ba hɔ no ho. ");
INSERT INTO twi_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Sɛ ɛyɛ atade mu anaa ofi mu, ");
INSERT INTO twi_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","anaa ɔhonam ani ahonhon, anaa ɔhyehyew mu mpumpunnya anaa ɔhonam ani baabi a ɛhɔ ayɛ hyerɛnn. ");
INSERT INTO twi_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Saa ɔkwan yi so na wɔbɛfa ahu sɛ ɛyɛ kwata anaa ɛnyɛ kwata. Eyi nti na wɔhyɛɛ saa mmara yi. ");
INSERT INTO twi_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Awurade ka kyerɛɛ Mose ne Aaron se, ");
INSERT INTO twi_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Monhyɛ saa mmara yi mma Israelfo: ‘Ɔbarima biara a ne ho bɛsen nsu no, saa nsu no yɛ fi. ");
INSERT INTO twi_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Sɛ ɛkɔ so sen o, egyae o, agu ne ho fi. Fi a nsu a egu no no de bɛba ni: ");
INSERT INTO twi_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Mpa a ɔbɛda so ne biribiara a ɔbɛtena so nso ho gu fi. ");
INSERT INTO twi_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Obiara a ɔde ne ho ka ɔbarima no mpa ho gu fi kosi anwummere, enti ɛsɛ sɛ ɔhoro ne ntama na oguare. ");
INSERT INTO twi_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Obiara a ɔbɛtena akongua a ɔbarima no atena so so ho gu fi kosi anwummere, enti ɛsɛ sɛ ɔhoro ne ntama na oguare. ");
INSERT INTO twi_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Saa mmara yi ka obiara a ɔde ne ho bɛka ɔbarima no. ");
INSERT INTO twi_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Obiara a ɔbarima no bɛte ntasu agu ne so no ho ntew kosi anwummere, enti ɛsɛ sɛ onii no horo ne ntama na oguare. ");
INSERT INTO twi_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Ɔpɔnkɔ agua biara a ɔbɛtena so no ho agu fi. ");
INSERT INTO twi_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Obiara a ne ho bɛka biribiara a aka saa onipa no ase no ho ntew kosi anwummere, enti ɛsɛ sɛ ɔhoro ne ntama na oguare. ");
INSERT INTO twi_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Sɛ onipa a ne ho ntew no koso obi mu na wanhohoro ne nsa ansa a, ɛsɛ sɛ onipa ko no horo ne ntama, guare, efisɛ ne ho ntew kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Sɛ saa onipa no so asanka biara mu a, ɛsɛ sɛ wɔbɔ no na sɛ ɛyɛ mukaase biribi a wɔde dua na asen de a, ɛsɛ sɛ wɔde nsu hohoro ho. ");
INSERT INTO twi_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Sɛ nʼahosen no twa a, ɛsɛ sɛ ɔde nnanson fi ahodwira ho ahosiesie ase na ɔhoro ne ntama na okoguare wɔ asubɔnten mu. ");
INSERT INTO twi_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Da a ɛto so awotwe no, ɔde nturukuku abien anaa mmorɔnomamma abien bɛba Awurade anim wɔ Ahyiae Ntamadan no ano na ɔde ama ɔsɔfo no. ");
INSERT INTO twi_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Ɔsɔfo no de wɔn bɛbɔ afɔre a baako yɛ bɔne ho afɔre na baako no nso yɛ ɔhyew afɔre; na ɛkyerɛ sɛ, ɔsɔfo no bɛyɛ mpata wɔ Awurade anim ama ɔbarima no, esiane nʼahosen no nti. ");
INSERT INTO twi_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Sɛ ɔbarima biara ho nsu gu a, ɛsɛ sɛ oguare ne ho nyinaa, efisɛ ne ho nso ntew kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ntama anaa mpasotam biara a ho nsu no bi begu mu no, ɛsɛ sɛ wɔhoro, efisɛ ɛho ntew kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Sɛ ɔbarima fa ɔbea a, wɔn nna no akyi, ɛsɛ sɛ ɔbea no ne ɔbarima no nyinaa guare, efisɛ wɔn ho ntew kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Sɛ ɔbea kɔ afikyiri a, ne ho ntew nnanson mu. Saa bere no mu, obiara a ɔde ne ho bɛka no no nso ho ntew kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Biribiara a ɔbɛda so anaa ɔbɛtena so saa bere no mu no nso ho agu fi. ");
INSERT INTO twi_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Obiara a ɔde ne nsa bɛka ne mpa anaa biribiara a ɔtena so no bɛhoro ne ntama, aguare, efisɛ onipa no ho agu fi kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Sɛ obi so biribi a watena so mu nso a, ɛsɛ sɛ ɔhoro ne ntama na oguare, efisɛ ne ho agu fi kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Sɛ ɛyɛ ne mpasotam anaa nʼakongua, obiara a ne ho bɛka no ho begu fi akosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Sɛ ɔbarima ne no da saa bere yi mu a, ɔbarima no ho gu fi nnanson; na mpa biara a ɔbarima no bɛda so no nso ho gu fi. ");
INSERT INTO twi_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Sɛ bere du sɛ ofi nanso mogya da so ba anaasɛ mogya ba bere a ɛnsɛ mu wɔ ɔsram no mu a, mmara koro no ara na wɔde ka ho asɛm, ");
INSERT INTO twi_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","na ɛkyerɛ sɛ, biribiara a ɔbɛda so saa bere no ho agu fi te sɛ nea nʼafikyikɔ bere mu ɔtena biribi so a, ɛho gu fi no ara pɛ. ");
INSERT INTO twi_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Obiara a ɔde ne nsa bɛka ne mpa anaa biribiara a ɔtena so no ho agu fi a ɛsɛ sɛ ɔhoro ne ntama, san guare, efisɛ ne ho ntew kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Nnanson akyi, sɛ afikyikɔ no twa a, na onni efi mu bio. ");
INSERT INTO twi_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Da a ɛto so awotwe no, ɔde nturukuku abien anaa mmorɔnomamma abien bɛkɔ akɔma ɔsɔfo no wɔ Ahyiae Ntamadan no kwan ano. ");
INSERT INTO twi_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Ɛsɛ sɛ ɔsɔfo no de baako bɔ bɔne ho afɔre na ɔde baako bɔ ɔhyew afɔre na ayɛ mpata ama ɔbea no wɔ Awurade anim wɔ nʼafikyikɔ mu no ho. ");
INSERT INTO twi_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Saa ɔkwan yi so na sɛ Israelfo no bi ho gu fi a, mobɛfa de atew wɔn ho; anyɛ saa a, esiane sɛ wɔagu mʼAhyiae Ntamadan a esi wɔn mu no ho fi nti, wobewuwu.’ ” ");
INSERT INTO twi_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Eyinom ne mmara a ɛwɔ hɔ ma ɔbarima a ne ho sen ");
INSERT INTO twi_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ne ɔbea a wakɔ afikyiri ne obiara a ɔde ne ho ka ɔsakyimafo wɔ bere a ne ho ntew no mu no. ");
INSERT INTO twi_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aaron mmabarima baanu a wowuwuu wɔ Awurade anim no wu akyi no, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“Bɔ wo nua Aaron kɔkɔ sɛ, ɔnnkɔ kronkronbea hɔ wɔ ntwamtam no akyi; beae a apam adaka no si ne mmɔborɔhunu beae hɔ kwa. Ɔkɔ hɔ a obewu, efisɛ mʼankasa mewɔ omununkum a ɛkata mpata beae so no mu. ");
INSERT INTO twi_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Sɛ ɔpɛ sɛ ɔkɔ hɔ a, nea ɛsɛ sɛ ɔyɛ ni: Ɛsɛ sɛ ɔde nantwinini ba ba ma wɔde bɔ bɔne ho afɔre na ɔde odwennini nso ba ma wɔde bɔ ɔhyew afɔre. ");
INSERT INTO twi_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ɛsɛ sɛ oguare na ɔhyɛ atade hanahana ne ne nhyɛase na ɔbɔ nkyekyeremu ne abotiri. ");
INSERT INTO twi_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Afei, Israelfo bɛbrɛ no mmirekyi abien a wɔde bɛbɔ wɔn bɔne ho afɔre ne odwennini a wɔde bɛbɔ wɔn ɔhyew afɔre. ");
INSERT INTO twi_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Ɛsɛ sɛ Aaron de nantwi ba no bɛma Awurade sɛ bɔne ho afɔre a ɔrebɔ ama ne ho de ayɛ mpata ama ne ho ne ne fifo. ");
INSERT INTO twi_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Afei, ɔde mmirekyi abien no bɛba Awurade anim wɔ Ahyiae Ntamadan no ano. ");
INSERT INTO twi_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ɛsɛ sɛ ɔbɔ mmirekyi no so ntonto hu Awurade de, ne nea ɛsɛ sɛ wɔsan de no kɔ. ");
INSERT INTO twi_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaron de abirekyi a wɔde no rebɛbɔ Awurade afɔre no bɛbɔ bɔne ho afɔre. ");
INSERT INTO twi_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Wɔrenkum abirekyi baako a waka no na wɔde no aba Awurade anim. Wɔbɛyɛ mpata ho dwumadi bi agu ne so na wɔde no akɔ sare so akogyaw no wɔ hɔ sɛ mpata guan. ");
INSERT INTO twi_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aaron de nantwinini ba no bɛbɔ bɔne ho afɔre ama ne ho ne ne fifo. ");
INSERT INTO twi_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ɛsɛ sɛ ɔfa ade a wɔhyew aduhuam wɔ mu a nnyansramma a wɔfaa wɔ Awurade afɔremuka no so ayɛ no ma. Afei ɔde aduhuam a wɔayam no muhumuhu bɛyɛ ne nsam na ɔde akɔ ntwamtam no akyi. ");
INSERT INTO twi_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ɛhɔ na ɔde aduhuam no begu ogya no so wɔ Awurade anim na ayɛ wusiw kumɔnn wɔ mpata beae apam ne adaka (a abo apon a wɔakyerɛw Mmaransɛm Du agu so wɔ mu) no so nyinaa sɛnea ɛbɛyɛ a ɔrenwu. ");
INSERT INTO twi_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Na ɔde nantwinini ba no mogya no bi bɛba na ɔde ne nsateaa baako abɔ mu apete mpata beae hɔ apuei fam na wapete no mpɛn ason wɔ anim. ");
INSERT INTO twi_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Afei, ɛsɛ sɛ ofi adi na ɔde abirekyi no kɔbɔ ɔmanfo no bɔne ho afɔre na wɔde ne mogya no ba ntwamtam no akyi na wɔpete gu mpata hɔ ne anim sɛnea ɔde nantwinini ba no mogya no yɛe no ara pɛ. ");
INSERT INTO twi_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Na ɛkyerɛ sɛ wayɛ mpata ama beae kronkron hɔ, efisɛ Israelfo bɔne ama efi aka beae hɔ ne Ahyiae Ntamadan no a wɔasi wɔ wɔn mfimfini hɔ no. ");
INSERT INTO twi_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Sɛ Aaron wura Ahyiae Ntamadan no mu kɔ kronkronbea hɔ rekɔyɛ mpata adwuma no a, ɛnsɛ sɛ obiara kɔ hɔ bi, gye sɛ ɔyɛ mpata no ma ne ho ne ne fifo ne Israelfo nyinaa wie. ");
INSERT INTO twi_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Afei, ɔbɛkɔ afɔremuka no ho wɔ Awurade anim akɔyɛ mpata ama afɔremuka no. Ɛsɛ sɛ ɔde nantwinini ba no ne abirekyi mogya no sra mmɛn a etuatua afɔremuka no ho no ho. ");
INSERT INTO twi_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Na ɔde ne nsateaa baako bɛpete mogya no mpɛn ason agu afɔremuka no so de atew ho afi Israelfo bɔne no ho ayɛ no kronkron. ");
INSERT INTO twi_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Sɛ owie mpata a ɛfa kronkronbea hɔ ne Ahyiae Ntamadan no ho nsɛm nyinaa ne afɔremuka no ho a, ɔde abirekyi no bɛba anikann. ");
INSERT INTO twi_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Na ɔde ne nsa abien agu aboa no apampam, na waka atirimɔden ne atuatew a Israelfo ayɛ, wɔn bɔne nyinaa de agu abirekyi no apampam, na obi a wɔayi no sɛ ɔnyɛ saa adwuma no de aboa no bɛkɔ sare so. ");
INSERT INTO twi_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Enti abirekyi no bɛsoa nnipa no bɔne nyinaa de akɔ asase a obi nte so no so na nipa no agyaa no wɔ sare so hɔ. ");
INSERT INTO twi_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Afei, Aaron bɛkɔ Ahyiae Ntamadan mu hɔ bio akɔworɔw nʼatade hanahana a ɔhyɛɛ wɔ ntwamtam no akyi no na wagyaw wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ɔbɛkɔ akoguare wɔ faako a wɔatew hɔ ho na wahyɛ ne ntade no bio na wafi adi akɔbɔ ɔno ankasa ɔhyew afɔre asan abɔ ɔhyew afɔre ama nnipa no na wayɛ mpata ama ne ho ne wɔn. ");
INSERT INTO twi_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ɔbɛhyew srade de abɔ bɔne ho afɔre wɔ afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Akyiri no, ɔbarima a ɔde abirekyi no kɔɔ sare so kogyaa no no bɛhoro ne ntama na waguare na wasan aba beae hɔ bio. ");
INSERT INTO twi_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Na nantwi ba ne abirekyi a wɔde bɔɔ bɔne ho afɔre no a Aaron de wɔn mogya kɔɔ kronkronbea hɔ kɔyɛɛ mpata no, wɔde wɔn bɛkɔ nsraban no akyi baabi akɔhyew a wɔn ho nwoma ne wɔn ayamde ka ho. ");
INSERT INTO twi_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Akyiri no, onipa a ɔrebɛhyew afɔrebɔde no bɛhoro ne ntama, aguare na wasan akɔ beae hɔ bio. ");
INSERT INTO twi_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Eyi yɛ mmara a ɛwɔ hɔ daa. Ɔsram a ɛto so ason no nnafua du so no, ɛnsɛ sɛ moyɛ adwuma biara, na mmom, momfa saa da no nkari mo ho nhwɛ wɔ ahobrɛase mu. Saa mmara yi ka wɔn a wɔwoo wɔn wɔ asase yi so anaa ahɔho a wɔne Israelfo te; ");
INSERT INTO twi_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","efisɛ da yi na wɔde kae mo mpata ne mo ahodwira wɔ mo bɔne ho wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ɛyɛ homeda a ɛsɛ sɛ mode home enti ɛsɛ sɛ mudi da no dinn wɔ ahobrɛase mu. Ɛyɛ mmara a ɛbɛtena hɔ daa. ");
INSERT INTO twi_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Saa ahyɛde yi, Ɔsɔfopanyin a wɔasra no no a obesi ne nena Aaron anan na obedi ho dwuma wɔ beae hɔ. Ɔno nko ara na ɔwɔ ho kwan sɛ ɔhyɛ atade kronkron hanahana no ");
INSERT INTO twi_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","na ɔyɛ mpata wɔ kronkronbea hɔ wɔ Ahyiae Ntamadan mu hɔ, wɔ afɔremuka no so de ma asɔfo no ne nnipa no. ");
INSERT INTO twi_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Eyi bɛyɛ mmara a ɛbɛtena hɔ daa ama mo, na Israelfo bɔne nti, moagyina so afe biara de ayɛ mpata ama Israelfo afi wɔn bɔne nyinaa mu.” Na Mose dii mmara a Awurade hyɛ maa no no nyinaa so. ");
INSERT INTO twi_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Hyɛ saa mmara a efi Awurade nkyɛn yi ma Aaron ne ne mma ne Israelfo no nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Israelni biara a ɔde nantwi, oguamma anaa abirekyi bɛbɔ afɔre wɔ nsraban mu anaa akyi no, ");
INSERT INTO twi_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","a anka ɛsɛ sɛ ɔde no ba Ahyiae Ntamadan no ano hɔ de no ma Awurade sɛ afɔrebɔde wɔ Awurade Ahyiae Ntamadan no ano no, wɔbɛfa saa onipa no sɛ wahwie mogya agu enti ɛsɛ sɛ wotwa no asu fi ne manfo mu. ");
INSERT INTO twi_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Saa mmara yi bɛbra Israelfo no a ɛremma wɔmfa mmoa mmɔ afɔre wɔ wuram baabiara kwa. Ɛbɛhyɛ wɔn ama wɔde afɔrebɔde no abrɛ ɔsɔfo no wɔ Ahyiae Ntamadan no kwan ano sɛnea ɔsɔfo no betumi de ama Awurade sɛ asomdwoe afɔrebɔde. ");
INSERT INTO twi_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Sɛ wɔfa saa kwan no so a, ɔsɔfo no betumi apete mogya agu Awurade afɔremuka no so wɔ Ahyiae Ntamadan no kwan ano na wɔahyew srade no sɛ ohuam ama Awurade ani asɔ. ");
INSERT INTO twi_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Na ama ɔmanfo agyae afɔre a wɔbɔ ma ahonhommɔne wɔ wuram no. Eyi bɛyɛ mmara a ɛbɛtena hɔ daa ama mo fi awo ntoatoaso so akosi awo ntoatoaso so. ");
INSERT INTO twi_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Miti mu sɛ, ‘Hyɛ saa mmara yi nso ma wɔn. Sɛ Israelni anaa ɔhɔho a ɔne mo te no de ɔhyew afɔrebɔde no anaa afɔrebɔ no ba, ");
INSERT INTO twi_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","na sɛ wamfa amma Ahyiae Ntamadan no kwan ano amfa amma Awurade a, ɛsɛ sɛ wotwa no asu fi ɔmanfo no mu. ");
INSERT INTO twi_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Na mɛdan mʼani atia obiara a obedi mogya wɔ ɔkwan biara so no; ɛmfa ho sɛ ɔyɛ Israelni anaa ɔhɔho a ɔte mo mu. ");
INSERT INTO twi_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Efisɛ ɔhonam no nkwa wɔ mogya no mu, na mama mo mogya sɛ momfa mpete afɔremuka no so sɛ mpatade mma mo akra; nkwa a ɛwɔ mogya mu nti na wɔde yɛ mpatade ma onipa kra. ");
INSERT INTO twi_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ɛno nti, mereka akyerɛ Israelfo se, “Wɔn anaa ahɔho a wɔte wɔn mu no nni mogya.” ");
INSERT INTO twi_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Israelni anaa ɔhɔho biara a ɔte wɔn mu a ɔbɛkɔ ahayɛ na obekum aboa anaa anomaa biara a wɔwe ne nam no, ɔnsɔn ne mogya na ɔmfa mfutuma nkata so, ");
INSERT INTO twi_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","efisɛ aboa biara nkwa ne ne mogya. Ɛno nti na meka kyerɛɛ Israelfo se wonnni mogya no, efisɛ nnomaa anaa aboa biara nkwa yɛ ne mogya. Enti obiara a odi mogya no, ɛsɛ sɛ wotwa no asu. ");
INSERT INTO twi_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Obiara a ɔwe aboafunu a ɔno ara awu anaasɛ akekaboa bi na okum no no, ɛsɛ sɛ ɔhoro ne ntama na oguare, efisɛ ne ho ntew kosi anwummere; ɛno akyi no, ɛsɛ sɛ wɔpae mu ka se ne ho atew. ");
INSERT INTO twi_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Na sɛ wanhoro ne ntama anguare a, wɔne no bedi no sɛnea mmara no se.’ ” ");
INSERT INTO twi_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Awurade ka kyerɛɛ Mose se, “Ka kyerɛ Israelfo no se, ");
INSERT INTO twi_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","‘Mene Awurade mo Nyankopɔn, ");
INSERT INTO twi_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","enti mommmɔ mo bra sɛ abosonsomfo. Monnyɛ sɛ nnipa a na mo ne wɔn te wɔ Misraim anaa Kanaan wɔ faako a mede mo rekɔ no. Munnsuasua wɔn. ");
INSERT INTO twi_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Me mmara ne mʼahyɛde ara so na ɛsɛ sɛ mudi; na ɛsɛ sɛ mudi so pɛpɛɛpɛ, efisɛ mene Awurade mo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Sɛ mudi so a, mubenya nkwa. Mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Mo mu biara nni ho kwan sɛ ɔware obusuani a ɔbɛn no. Mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Ɛnsɛ sɛ ɔbabea ware nʼagya anaasɛ ɔbabarima ware ne na. ");
INSERT INTO twi_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Ɛnsɛ sɛ wo ne wʼagya yerenom mu bi da; ebebu wʼagya animtiaa. ");
INSERT INTO twi_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Ɛnsɛ sɛ wo ne wo nuabea anaa wʼagya babea anaa wo na babea da, sɛ wɔwoo no ofi no mu anaa ofi foforo mu. ");
INSERT INTO twi_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Ɛnsɛ sɛ moware mo nenabea, sɛ ɔyɛ mo babarima babea anaa mo babea babea, efisɛ ebebu mo animtiaa. ");
INSERT INTO twi_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Ɛnsɛ sɛ woware wo nuabea a ɔyɛ wʼagya yerenom bi babea. ");
INSERT INTO twi_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Anaa wo sewaa—wo agya nuabea, efisɛ ɔyɛ wʼagya busuani pɛɛ. ");
INSERT INTO twi_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Saa ara na ɛnsɛ sɛ woware wo na a ɔyɛ wo na nuabea, efisɛ, ɔyɛ wo na busuani pɛɛ. ");
INSERT INTO twi_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Wʼagya nuabarima yere nso, wunni ho kwan sɛ woware no. ");
INSERT INTO twi_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Wunni ho kwan sɛ woware wo babarima yere, efisɛ ɔyɛ wʼase. ");
INSERT INTO twi_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Saa ara nso na wuntumi nnware wo nuabarima yere, efisɛ ɔyɛ wo nuabarima dea. ");
INSERT INTO twi_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Worentumi nware ɔbea bi nsan nware ne babea anaa ne nenabea nka ho, efisɛ wɔn nyinaa yɛ abusuafo pɛɛ na ɛyɛ awudisɛm nso. ");
INSERT INTO twi_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Ɛnsɛ sɛ woware nuabeanom baanu sɛ akorafo, bere a wo yere te ase. ");
INSERT INTO twi_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Ɛnsɛ sɛ wofa ɔbea a ɔwɔ afikyirikɔ mu. ");
INSERT INTO twi_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Ɛnsɛ sɛ wofa wo yɔnko yere de gu mo ho fi. ");
INSERT INTO twi_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Mfa wo mma mu biara mma Molek mma ɔmmfa no mmɔ afɔre wɔ nʼafɔremuka so. Ngu wo Nyankopɔn din ho fi, efisɛ mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Ɔbarima a ɔne ne yɔnko barima da yɛ akyiwade kɛse na ɛyɛ bɔne a ɛso nso. ");
INSERT INTO twi_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Ɛnsɛ sɛ ɔbarima fa aboa de gu ne ho fi. Saa ara nso na ɛnsɛ sɛ ɔbea de ne ho ma aboanini ma ɔfa no. Ɛyɛ akyiwade kɛse. ");
INSERT INTO twi_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Munngu mo ho fi wɔ saa akwan ahorow yi biara so na eyinom ne nea abosonsomfo yɛ. Esiane sɛ wɔyɛ saa nti, merebeyi wɔn afi asase a morekɔ so no so. ");
INSERT INTO twi_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Saa ahohwibra no agu ɔman mu no nyinaa ho fi; ɛno nti na meretwe nnipa a wɔte hɔ no aso na mayi wɔn afi asase no so. ");
INSERT INTO twi_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ɛsɛ sɛ mudi me mmara ne mʼahyɛde no nyinaa so pɛpɛɛpɛ na ɛnsɛ sɛ moyɛ saa akyiwade yi mu bi koraa. Saa mmara yi ka mo a wɔwoo mo Israelman mu ne ahɔho a wɔne mo te nyinaa bi. ");
INSERT INTO twi_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Ampa ara, efisɛ daa nnipa a wɔte saa asase a mede mo rekɔ so no so yɛ saa akyiwade yi nti, asase no ho agu fi. ");
INSERT INTO twi_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Monnyɛ saa ade no bi, anyɛ saa a, mɛpam mo afi asase no so sɛnea mɛyɛ wɔn a wɔte hɔ mprempren no. ");
INSERT INTO twi_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Obiara a ɔbɛyɛ akyiwade yi mu bi no, ɛsɛ sɛ wotwa no asu fi ɔman no mu. ");
INSERT INTO twi_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Enti monhwɛ sɛ mubedi me mmara no so na monnyɛ saa abusude kɛse yi bi. Monnkɔyɛ abususɛm a wɔn a wɔte asase a morekɔ so no yɛ no bi mmfa ngu mo ho fi. Mene Awurade mo Nyankopɔn.’ ” ");
INSERT INTO twi_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Ka kyerɛ Israelfo no se, ‘Monyɛ kronkron, efisɛ me Awurade a meyɛ mo Nyankopɔn no, meyɛ kronkron. ");
INSERT INTO twi_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Ɛsɛ sɛ mode nidi ma mo nanom ne mo agyanom na mudi me homeda mmara no so, efisɛ meyɛ Awurade mo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Monnsom ohoni, anaa monnyɛ nnade anyame bi mma mo ho. Mene Awurade mo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Sɛ mobɔ asomdwoe afɔre ma Awurade a momfa ɔkwan pa so mmɔ na asɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Da a mobɛbɔ saa afɔre no, munni no da no ara, na aboro so koraa na ɛsɛ sɛ mudi no adekyee. Monhyew nea ebedi nnansa no. ");
INSERT INTO twi_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Na nea mubedi no nnansa so no yɛ akyiwade ma me, enti mɛpo. ");
INSERT INTO twi_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Sɛ mudi no nnansa so a, mudi ho fɔ na moagu Awurade kronkronyɛ nso ho fi, na wobetwa mo asu afi Awurade nkurɔfo mu. ");
INSERT INTO twi_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Sɛ mutwa mo nnɔbae a, munntwa nnɔbae a ɛwɔ mo mfuw nhanoa no. Sɛ moretwa a, aba a ebegu fam no nso, monntase. ");
INSERT INTO twi_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Saa ara na mo bobe so aba no nso, ɛnsɛ sɛ motew ne nyinaa. Na nea ɛbɛtew agu ase no nso, monntase. Munnyaw mma ahiafo ne akwantufo a wɔbɛfa hɔ no na mene Awurade mo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Mommmɔ korɔn. “ ‘Munntwa atoro. “ ‘Na munnsisi obiara. ");
INSERT INTO twi_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Monnka ntamhunu mfa ngu mo Nyankopɔn din ho fi, efisɛ mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Nwia wo yɔnko na munnsisi obi. “ ‘Na mo apaafo nso, muntua wɔn ka ntɛm. Na sɛ ɛka bi bɛtɔ mo ne wɔn ntam a, mommma ade nkye so. ");
INSERT INTO twi_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Monnnome ɔsotifo na munntwintwan onifuraefo akwan mu. Munsuro mo Nyankopɔn; Mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Ɛsɛ sɛ bere biara atemmufo bu atɛntrenee a wɔnhwɛ sɛ nea worebu no atɛn no yɛ ohiani anaa ɔdefo. Ɛsɛ sɛ daa wɔn atemmu yɛ pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Munnni nseku. “ ‘Mfa bɔne bi ho asɛm nto wo yɔnko so, na mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Ntan wo nua. Ka obiara a ɔyɛ bɔne anim; mma ɔbɔnefo mfa ne ho nni. Sɛ woyɛ saa a, wo nso wudi ho fɔ saa ara. ");
INSERT INTO twi_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Ntɔ were. Nnya obi ho menasepɔw; na mmom, dɔ wo yɔnko sɛ wo ho, na mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Munni me mmara so. “ ‘Mma wo nantwi mforo aboa foforo bi. “ ‘Nnua afifide a egu ahorow abien wɔ wʼafuw mu. “ ‘Nhyɛ atade a wɔde atam ahorow abien na anwen. ");
INSERT INTO twi_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Sɛ obi ne afenaa bi a obi asi no asiwa da a, ɛsɛ sɛ wodi wɔn asɛm wɔ asennii nanso ɛnsɛ sɛ wokum wɔn, efisɛ afenaa no nne ho. ");
INSERT INTO twi_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ɔbarima no na ɔde nʼafɔdi afɔrebɔde bɛbrɛ Awurade wɔ Ahyiae Ntamadan no kwan ano. Ɛsɛ sɛ afɔrebɔde no yɛ odwennini. ");
INSERT INTO twi_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ɔsɔfo no de odwennini no bɛyɛ mpata ama ɔbarima no bɔne a ɔyɛe no na ama wɔde ne bɔne no akyɛ no. ");
INSERT INTO twi_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Sɛ mokɔ asase bi so kodua nnuaba ahorow pii a, nnɔbaetwa abiɛsa a edi kan no, munnni, efisɛ wobu no sɛ ɛho agu fi. ");
INSERT INTO twi_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Na ne mfe anan so no, momfa aba no nyinaa mma Awurade mfa nkamfo no. ");
INSERT INTO twi_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Na ne mfe anum so no, aba no yɛ mo dea. Eyi bɛma mo nnɔbae so ato. Mene Awurade mo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Monnwe aboa biara a wɔnsɔnee ne mu mogya no nam. “ ‘Mommfa mo ho nkɔ asumansɛm anaa abayisɛm mu. ");
INSERT INTO twi_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Ɛnsɛ sɛ mutwitwa mo moma so nwi twitwa mo abɔgyesɛ so. ");
INSERT INTO twi_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Munntwitwa mo honam mma awufo anaa monnyɛ agyiraehyɛde ahorow wɔ mo ho. Mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Mma wo babea nkɔbɔ aguaman mfa ngu ne ho fi na asase no annan abɔnefo ne nguamanfo asase. ");
INSERT INTO twi_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Munni me homeda mmara no so na munni me kronkronbea no ni, efisɛ mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Monnkɔ asuman anaa ahonhom nkyɛn abisa mmfa ngu mo ho fi, na mene Awurade mo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Momfa obu ne nidi mma mpanyimfo wɔ Onyamesuro mu. Mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Sɛ ɔhɔho bɛtena mo mu a munnsisi no. ");
INSERT INTO twi_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Mummu wɔn sɛnea mubu onipa biara. Monnodɔ wɔn sɛ mo ho na monkae sɛ, na mo nso moyɛ ahɔho wɔ Misraim asase so. Mene Awurade mo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Mommfa atoro nsusuwde nsusuw, nkari anaa nkan mo biribiara. ");
INSERT INTO twi_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Momfa nokware nsania, nkaribo ne asusuwde a eye. Mene Awurade mo Nyankopɔn a mede mo fi Misraim bae no. ");
INSERT INTO twi_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Munni me mmaransɛm ne mʼahyɛde no nyinaa so, na mene Awurade.’ ” ");
INSERT INTO twi_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Awurade ka kyerɛɛ Mose se, “Ka kyerɛ Israelfo no se, ");
INSERT INTO twi_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","‘Obiara a ofi mo mu a ɔde ne ba bɛbɔ ɔhyew afɔre ama Molek no, sɛ ɔyɛ Israelni anaa ɔhɔho no, ɛsɛ sɛ wokum no. Ɛsɛ sɛ wosiw no abo. ");
INSERT INTO twi_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Na mʼankasa metia saa onipa no na mayi no afi ne nkurɔfo mu, efisɛ ɔde ne ba ama Molek ama wagu me kronkronbea ne me din kronkron no ho fi. ");
INSERT INTO twi_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Na sɛ nnipa a wɔte mpɔtam hɔ no nso boapa yɛ wɔn ho sɛ wonnim sɛ ɔbarima no de ne ba abɔ afɔre ama Molek na wɔankum no a, mʼankasa metia ");
INSERT INTO twi_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ɔbarima no ne ne fifo na matwa ɔno ne nnipa a wɔde wɔn ho to anyame foforo so no nyinaa afi wɔn nkurɔfo mu. ");
INSERT INTO twi_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Metia obiara a ɔkɔ asuman ne ahonhom nkyɛn okodi wɔn akyi aguaman so, na matwa saa onipa no afi ne nkurɔfo mu. ");
INSERT INTO twi_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Enti montew mo ho na monyɛ kronkron na mene Awurade mo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ɛsɛ sɛ mudi me mmara nyinaa so, efisɛ mene Awurade a meyɛ mo kronkron no. ");
INSERT INTO twi_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Obiara a ɔbɛdome nʼagya anaa ne na no, ɛsɛ sɛ wokum no, efisɛ wadome ne na ne nʼagya, ne mogya begu nʼatifi. ");
INSERT INTO twi_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Sɛ ɔbarima bi kɔfa obi yere a, ɛsɛ sɛ wokum ɔbarima no ne ɔbea no nyinaa wɔabɔ aguaman. ");
INSERT INTO twi_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Sɛ ɔbarima bi ne nʼagya yere da a, ɛsɛ sɛ wokum ɔbarima no ne ɔbea no, wɔn mogya begu wɔn atifi. ");
INSERT INTO twi_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Na sɛ ɔbarima bi kɔfa nʼase a ɔyɛ ne babarima yere a, ɛsɛ sɛ wokum wɔn baanu no nyinaa; wɔn ankasa na wɔagu wɔn ho wɔn ho fi; wɔn mogya begu wɔn atifi. ");
INSERT INTO twi_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Sɛ ɔbarima bi fa ne yɔnko barima a, wonkum wɔn baanu no nyinaa; wɔn mogya begu wɔn ankasa atifi. ");
INSERT INTO twi_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Sɛ ɔbarima bi fa ɔbea bi na ɔsan kɔfa ɔbea no na ka ho a, ɛyɛ atiwuisɛm. Ɛsɛ sɛ wɔhyew saa nnipa baasa yi nyinaa anikann de apepa amumɔyɛsɛm no afi mo mu. ");
INSERT INTO twi_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Sɛ ɔbarima bi fa aboa a, ɛsɛ sɛ wokum ɔbarima no na wokum aboa no nso. ");
INSERT INTO twi_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Sɛ ɔbea nso ma aboa fa no a, munkum ɔbea no ne aboa no nyinaa; wɔn mogya begu wɔn ankasa atifi. ");
INSERT INTO twi_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Sɛ ɔbarima ne ne nuabea da a, sɛ ɛyɛ nʼagya babea o, sɛ nso ɛyɛ ne na babea o, ɛyɛ animguasesɛm, wobegyina bagua mu ayi wɔn afi wɔn nkurɔfo mu. Ɔbarima no ara bɛsoa nʼafɔdi. ");
INSERT INTO twi_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Sɛ ɔbarima bi kɔfa ɔbea a wabu ne nsa a, ɛsɛ sɛ woyi wɔn fi wɔn nkurɔfo mu, efisɛ ɔbarima no ada ɔbea no adagyaw adi. ");
INSERT INTO twi_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Sɛ obi ne nʼagya nuabea da a, ɛyɛ akyiwade. Saa ara nso na ɔne ne na nuabea da a, ɛyɛ akyiwade ara ne no, efisɛ, wɔn nyinaa yɛ mogya baako. Wɔn baanu nyinaa bɛsoa wɔn afɔdi. ");
INSERT INTO twi_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Sɛ ɔbarima bi fa nʼagya nuabarima yere a, wafa ade a ɛyɛ nʼagya nuabarima no dea; wɔn asotwe ne sɛ, wɔbɛsoa wɔn bɔne awu a wɔrenwo ba. ");
INSERT INTO twi_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Sɛ ɔbarima bi ware ne nua yere a, ɛyɛ afide, efisɛ wafa ne nua ade na wɔn nyinaa renwo ba. ");
INSERT INTO twi_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Ɛsɛ sɛ mudi me mmara nyinaa so na mampam mo amfi mo asase foforo yi so. ");
INSERT INTO twi_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Munnni ɔman no amanne a maka no mo anim sɛ enye no akyi, efisɛ nneɛma a wɔyɛ a enye no nyinaa, mabɔ mo ho kɔkɔ dedaw. Ɛno nti na mikyi saa aman no. ");
INSERT INTO twi_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Mahyɛ mo wɔn asase no ho bɔ sɛ mede bɛma mo. Ɛyɛ asase a nufusu ne ɛwo sen wɔ so. Mene Awurade mo Nyankopɔn a mama mo ada nsow wɔ aman a aka no nyinaa mu. ");
INSERT INTO twi_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Ɛsɛ sɛ mo nso muhu nnomaa ne mmoa a mama mo ho kwan sɛ monwe wɔn nam ne wɔn a ɛnsɛ sɛ mowe wɔn nam no ntam nsonoe. Ɛwɔ mu sɛ mmoa ne nnomaa a mabra sɛ monnnwe no, wɔabu so wɔ asase no so de, nanso monnnwe mfa ngu mo ho fi nhyɛ me abufuw. ");
INSERT INTO twi_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Mobɛyɛ kronkron ama me, efisɛ me Awurade, meyɛ kronkron na mayi mo afi nnipa nyinaa mu asi nkyɛn sɛ moyɛ me de. ");
INSERT INTO twi_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Ɔbarima anaa ɔbea a ɔyɛ samanfrɛfo anaasɛ osumanni wɔ mo mu no, ɛsɛ sɛ mukum no. Ɛsɛ sɛ musiw no abo; ne mogya begu nʼankasa atifi.’ ” ");
INSERT INTO twi_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Awurade ka kyerɛɛ Mose se, “Ka kyerɛ Aaron mma asɔfo no se, ‘wonnso funu mu mfa ngu wɔn ho fi. ");
INSERT INTO twi_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Sɛ wobeso funu mu a, na ɛyɛ wɔn fini, sɛ ebia, ɛna, agya, ɔbabarima, ɔbabea, onuabarima ");
INSERT INTO twi_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","anaa onuabea a ɔyɛ ɔbabun a onni kunu na ɔte ase no na ɔdan ɔsɔfo no. ");
INSERT INTO twi_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ɛnsɛ sɛ ɔware ne busuani bi na ɔfa so gu ne ho fi. ");
INSERT INTO twi_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Asɔfo no nni ho kwan sɛ wɔbɔ tikwaw, yi wɔn abogyesɛ anaasɛ wɔsesa wɔn ho. ");
INSERT INTO twi_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ɛsɛ sɛ wɔyɛ kronkron ma wɔn Onyankopɔn. Ɛnsɛ sɛ wogu ne din ho fi. Sɛ ɛba saa a, wɔremfata sɛ wɔde ogya bɛbɔ aduan afɔre ama Awurade wɔn Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Ɛnsɛ sɛ ɔsɔfo ware oguamanfo anaa ɔbea bi a ofi ɔman foforo so. Onni ho kwan sɛ ɔware ɔbea bi a wagyae aware, efisɛ ɔsɔfo yɛ onipa kronkron ma Onyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Wɔayi ɔsɔfo no asi hɔ sɛ ɔmmɔ mo Nyankopɔn afɔre; ɔyɛ kronkron na me Awurade a metew mo ho ma moyɛ kronkron no nso meyɛ kronkron. ");
INSERT INTO twi_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Ɔsɔfo babea biara a ɔbɛbɔ aguaman no gu nʼagya ne ɔno ankasa ho fi, enti ɛsɛ sɛ wɔhyew no. ");
INSERT INTO twi_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Ɛnsɛ sɛ ɔsɔfopanyin a wɔde ngo sononko bi asra no ahyɛ no atade sononko no gyaa ne tinwi a onni no ni anaasɛ ebetwa ne ntama mu. ");
INSERT INTO twi_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Onni ho kwan sɛ ɔkɔ beae a funu da hɔ; nʼagya anaa ne na funu koraa, onni ho kwan sɛ ɔkɔ ho na ɔde agu ne ho fi ");
INSERT INTO twi_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","anaa nso sɛ ogu so reyɛ nʼasɔfodwuma wɔ kronkronbea hɔ a, ɛnsɛ sɛ ofi adi. Ɛnsɛ sɛ ɔfa me kronkronbea no sɛ ofi bi kɛkɛ, efisɛ ne Nyankopɔn ngo a wɔde tew ne ho no da so wɔ ne so. Mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Ɛsɛ sɛ ɔware ɔbabun. ");
INSERT INTO twi_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ɛnsɛ se ɔware okunafo anaa ɔbea bi a wagyae aware anaa oguamanfo. Ɛsɛ sɛ ɔbea a ɔbɛware no no yɛ ɔbabun a ofi ne man mu, ");
INSERT INTO twi_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","sɛnea ɛbɛyɛ a ongu ne mma ho fi wɔ ne nkurɔfo mu. Mene Awurade a metew ne ho no.’ ” ");
INSERT INTO twi_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Ka kyerɛ Aaron se, efi awo ntoatoaso a ɛbɛba no so rekɔ no, wʼaseni biara a wadi dɛm no nni ho kwan sɛ ɔbɔ Onyankopɔn afɔre. ");
INSERT INTO twi_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Obi a wadi dɛm mmɛn me: onifuraefo anaa apakye anaa nea ɔwɔ honam akwaa mu sintɔ; ");
INSERT INTO twi_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","obi a ɔyɛ abasin anaa nansin, ");
INSERT INTO twi_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","anaa nea ɔyɛ afu anaa akwatia anaa nea nʼani nye anaa nea kuru atutu no anaa nea ɔyɛ twow. ");
INSERT INTO twi_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ɔsɔfo Aaron aseni biara a wadi dɛm mma mmɛbɔ ɔhyew afɔre mma Awurade. Wadi dɛm, ɛno nti ɛnsɛ sɛ otwiw bɛn sɛ ɔde ne Nyankopɔn aduan rebrɛ no. ");
INSERT INTO twi_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Nanso sɛ wɔbɔ afɔre no wie a, ɔsɔfo no tumi ma no Onyankopɔn afɔre no aduan no bi di a ɛmfa ho sɛ ɛyɛ afɔre kronkron. ");
INSERT INTO twi_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Nanso ne dɛm no nti, onni ho kwan sɛ ɔkɔ ntwamtam no akyi anaa ɔbɛn afɔremuka no. Eyi begu me kronkronbea hɔ ho fi na ɛyɛ Awurade na watew hɔ ho.” ");
INSERT INTO twi_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Enti Mose hyɛɛ mmara yi maa Aaron ne ne mmabarima ne Israelfo nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Ka kyerɛ Aaron ne ne mmabarima se wɔmfa nidi mma afɔrebɔde kronkron a Israelfo atew ho ama me no, sɛnea ɛbɛyɛ a wɔrengu me din ho fi. Mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Efi nnɛ rekɔ, sɛ ɔsɔfo biara a ne ho agu fi de ne nsa ka mmoa anaa akyɛde biara a nnipa no de aba sɛ wɔmfa mmɔ afɔre mma Awurade a, wɔbɛworɔw nʼatade. Mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Ɔsɔfo biara a ɔwɔ ɔhonam ani nsanyare biara nni ho kwan sɛ odi afɔrebɔde kronkron no bi, gye sɛ wɔasa no yare ama ne ho afi ansa. Ɔsɔfo biara a ɔde ne nsa bɛka funu anaa ɛnam ahosian nti ne ho begu fi no, ");
INSERT INTO twi_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","anaa ɔde ne nsa bɛka aboa biara a ɔwea fam anaa akyiwade bi anaa obi a biribi nti, wɔagu ne ho fi no, ");
INSERT INTO twi_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","saa ɔsɔfo no ho begu fi akosi anwummere. Ɔrenni afɔrebɔde a wɔatew ho no bi kosi anwummere a obeguare. ");
INSERT INTO twi_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Sɛ owia kɔtɔ a, ne ho bɛtew na ɛno akyi no obetumi adi afɔrebɔde kronkron no bi, efisɛ ɛyɛ nʼaduan. ");
INSERT INTO twi_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ɛnsɛ sɛ odi aboa funu anaa nea akekaboa bi atetew ne mu, na amma ne ho angu fi. Mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Bɔ asɔfo no kɔkɔ na wonni saa mmara yi so yiye, anyɛ saa a, wɔbɛtwe wɔn aso na wɔawuwu sɛ wɔabu saa mmara yi so nti. Mene Awurade a matew wɔn ho. ");
INSERT INTO twi_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Obiara nni ho kwan sɛ odi afɔrebɔde kronkron no bi gye sɛ ɔyɛ ɔsɔfo. Ɔhɔho a wabɛsra ɔsɔfo no nni ho kwan sɛ odi bi. Na saa ara nso na ɔsomfo a wotua no ka nni ho kwan sɛ odi bi. ");
INSERT INTO twi_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Nanso sɛ ɛba sɛ ɔsɔfo no de ɔno ara ne sika tɔ akoa a, saa akoa no tumi di bi. Na akoa no mma biara a ɔbɛwo wɔn wɔ fie hɔ no wɔ ho kwan sɛ wodi bi. ");
INSERT INTO twi_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Sɛ ɔsɔfo babea kɔware fi abusuakuw no akyi baabi a, onni ho kwan sɛ odi afɔrebɔde kronkron no bi. ");
INSERT INTO twi_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Na sɛ ɔyɛ okunafo anaa obi a wɔagyaa no aware na onni babarima a ɔbɛhwɛ no na ɛno nti ɔsan ba nʼagya nkyɛn a, otumi di nʼagya aduan no bi bio. Eyinom akyi no, asɔfo no abusuafo nko ara na wɔwɔ ho kwan sɛ wodi afɔrebɔde kronkron no. ");
INSERT INTO twi_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Sɛ obi anhu na okodi saa afɔrebɔde kronkron no bi a, ɛsɛ sɛ otua ho ka na ɔsan bɔ ho nkyɛmu ɔha mu aduonu de ka ho. ");
INSERT INTO twi_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Afɔrebɔde kronkron a Israelfo de aba no, ɛnsɛ sɛ nnipa a wɔmmaa wɔn ho kwan sɛ wonni bi no di bi, efisɛ Awurade na ɔde saa afɔrebɔde yi nyinaa abrɛ no. ");
INSERT INTO twi_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Na obiara a obebu saa mmara yi so no di ho fɔ, na asɛm da ne so, efisɛ wadi afɔrebɔde kronkron. Na mene Awurade a metew afɔrebɔde nyinaa ho.” ");
INSERT INTO twi_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Ka kyerɛ Aaron ne ne mmabarima ne Israelfo nyinaa se, ‘Sɛ Israelni anaa obi a ɔne mo te bɔ ɔhyew afɔre ma Awurade a, sɛ ɛyɛ afɔrebɔde a ɛyɛ bɔhyɛ bi nti anaa ɔno ara ne pɛ mu na ɔrebɔ no, ");
INSERT INTO twi_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","sɛ afɔrebɔde no yɛ aboanini a ne ho nni dɛm biara a ɔyɛ nantwi ba anaa oguan anaa abirekyi no, Awurade begye. ");
INSERT INTO twi_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ɛnsɛ sɛ wɔde biribiara a ɛho tɔ kyima bɔ afɔre, efisɛ wɔrennye wɔ wo din mu. ");
INSERT INTO twi_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Obiara a ofi nʼanantwi anaa ne nguan mu sɛ ɔrebɔ asomdwoe afɔre ama Awurade no, sɛ ɛyɛ bɔhyɛ bi ho afɔrebɔ anaa ɔno ara ne pɛ mu no, ɛnsɛ sɛ ɔde aboa a wadi dɛm na ɛbɔ saa afɔre no na ama wɔagye. ");
INSERT INTO twi_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Aboa a nʼani abɔ anaa wadi dɛm anaa wapira anaa kuru anaa nwewee wɔ ne ho, anaa were ani yare ayɛ no no, ɛnsɛ sɛ wɔde no bɔ afɔre ma Awurade. Ɔmfata sɛ wɔde no ba afɔremuka so bɛbɔ afɔre ama Awurade. ");
INSERT INTO twi_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Sɛ biribi a ɛboro so anaa ɛtɔ sin wɔ nantwi ba anaa oguan ba a wɔde no rebrɛ Awurade no ho a, ɛsɛ sɛ wɔde no bɔ ɔpɛ mu afɔre na mmom, ɛnyɛ bɔhyɛ afɔre. ");
INSERT INTO twi_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ɛnsɛ sɛ wɔde aboa a wɔasa no bɔ Awurade afɔre. Monnyɛ eyi wɔ mo ankasa asase so, ");
INSERT INTO twi_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","na munnye saa mmoa no mmfi ahɔho a wɔfra mo mu hɔ mmfa mmɔ aduan afɔre mma mo Nyankopɔn. Wɔrennye, efisɛ wɔtɔ kyima na wɔadi dɛm.’ ” ");
INSERT INTO twi_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Sɛ wɔwo nantwi, oguan anaa abirekyi ba a, ɛsɛ sɛ aboa no tena ne na nkyɛn nnanson. Na efi nnaawɔtwe rekɔ no, sɛ wɔde no bɔ ogya afɔre a, Awurade begye. ");
INSERT INTO twi_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Munnkum aboa bi ne ne ba da koro, sɛ ɔyɛ nantwi anaa oguan. ");
INSERT INTO twi_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Sɛ morebɔ aseda afɔre ama Awurade a, ɛsɛ sɛ mofa ɔkwan pa so na wɔagye wɔ mo din mu. ");
INSERT INTO twi_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ɛsɛ sɛ, mowe aboa a wɔde no bɔɔ afɔre no nam da no ara a wokum no no. Mommma ade nkye bi so. Mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Munni me mmaransɛm nyinaa so na mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ɛnsɛ sɛ mugu me din kronkron no ho fi. Munni me ni na mene Awurade, a meyɛ mo kronkron ");
INSERT INTO twi_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","na me na mede mo fii Misraim bae sɛ mɛyɛ mo Nyankopɔn. Mene Awurade.” ");
INSERT INTO twi_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Ma Israelfo nte sɛ, ‘Eyinom ne mʼafahyɛ ahorow a mahyehyɛ, Awurade afahyɛ ahorow no a ɛsɛ sɛ mudi no sɛ nhyiamu kronkron. ");
INSERT INTO twi_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Mowɔ nnansia a mode yɛ adwuma, na da a ɛto so ason no yɛ Homeda a mode home, da a moyɛ nhyiamu kronkron. Ɛnsɛ sɛ moyɛ adwuma biara wɔ faako a mote. Ɛyɛ Homeda ma Awurade. ");
INSERT INTO twi_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Eyinom ne Awurade aponto, nhyiamu kronkron a ɛsɛ sɛ mobɔ bere a wɔahyɛ no ho dawuru: ");
INSERT INTO twi_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Wofi Awurade Twam Afahyɛ no ase wɔ ɔsram a edi kan no da ɛto so dunan no anwummere. ");
INSERT INTO twi_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Awurade Apiti Afahyɛ nso, wofi ase saa ɔsram no da a ɛto so dunum; na mubedi apiti nnanson. ");
INSERT INTO twi_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Afahyɛ no da a edi kan no, nnipa no nyinaa bɛbɔ ahotew gua na obiara renyɛ adwuma a ɛyɛ den biara. ");
INSERT INTO twi_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Nnanson no mu no, mommɔ ɔhyew afɔre mma Awurade da biara. Na da a ɛto so ason no, mobɛyɛ nhyiamu kronkron a obiara renyɛ adwuma.’ ” ");
INSERT INTO twi_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Kasa kyerɛ Israelfo no se, ‘Sɛ mudu asase a mede bɛma mo no so na mutwa mo nnɔbae a, momfa nnɔbae afiafi no mu baako nkɔma ɔsɔfo. ");
INSERT INTO twi_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Obehim no wɔ Awurade anim de akyerɛ sɛ ɔde rema no na Awurade begye sɛ mo akyɛde. ");
INSERT INTO twi_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Da no ara, mode odwennini a wadi afe a onnii dɛm bɛbɔ Awurade ɔhyew afɔre, ");
INSERT INTO twi_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ne nʼaduan afɔrebɔde a ɛyɛ esiam kilogram abiɛsa a wɔde ngo afra. Ɛbɛyɛ ɔhyew afɔre a eyi hua dɛdɛ ma Awurade. Wɔde nsa lita anan ne fa afɔrebɔde bɛka ho. ");
INSERT INTO twi_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ɛnsɛ sɛ mudi brodo biara, sɛ ɛyɛ aduan a wɔato anaa ɛyɛ foforo, kosi da a mode saa afɔrebɔde yi bɛbrɛ mo Nyankopɔn. Eyi bɛyɛ ahyɛde a ɛbɛtena hɔ daa ama awo ntoatoaso a ɛbɛba no wɔ baabiara a mobɛtena. ");
INSERT INTO twi_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Homeda no akyi da a edi kan a wɔmaa atoko afiafi mu baako so him no Awurade anim sɛ afɔrebɔde no, mubefi ase abubu nnaawɔtwe ason. ");
INSERT INTO twi_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Monkan adaduonum a ekosi homeda a ɛto so ason no akyi da koro na momfa atoko foforo mmɛbɔ afɔre mma Awurade. ");
INSERT INTO twi_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Eyi bɛyɛ brodo abien a mode befi mo afi mu bɛba. Na wobehim no wɔ Awurade anim sɛ afɔrebɔ no. Momfa asikresiam lita anan a wɔde mmɔkaw afra nto saa brodo yi. Ɛyɛ mo aduan a edi kan afɔrebɔde a mode rema Awurade. ");
INSERT INTO twi_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Mode brodo ne nsa bɛka nguamma ason a wɔadi afe a dɛm biara nni wɔn ho ne nantwi ba baako ne adwennini abien ho abɔ ɔhyew afɔre ama Awurade. Eyinom nyinaa yɛ ogya afɔrebɔde a ɛsɔ Awurade ani yiye. ");
INSERT INTO twi_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Mode ɔpapo baako bɛbɔ bɔne afɔre. Na mode nguantenmma abien a wɔn mu biara adi afe no abɔ asomdwoe afɔre. ");
INSERT INTO twi_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Asɔfo no behim saa afɔrebɔde yi ne brodo abien a esi mo nnɔbae a edi akyi no anan mu no wɔ Awurade anim. Ɛyɛ kronkron ma Awurade na wɔde bɛma asɔfo no sɛ wɔn aduan. ");
INSERT INTO twi_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Da no, ɛsɛ sɛ mobɔ nhyiamu kronkron no ho dawuru, na monnyɛ adwuma biara. Eyi bɛyɛ ahyɛde a ɛbɛtena hɔ daa ama awo ntoatoaso a ɛbɛba no wɔ baabiara a mobɛtena. ");
INSERT INTO twi_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Sɛ mutwa mo mfuw mu nnɔbae a, munntwa ntu nnɔbae no ase, na nea aporow agu fam no nso, monntase. Munnyaw mma ahiafo ne ahɔho a wɔte mo mu a wonni asase bi a wodidi so no. Mene Awurade mo Nyankopɔn!’ ” ");
INSERT INTO twi_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Ka kyerɛ Israelfo se, ‘Ɔsram a ɛto so ason no da a edi kan no, ɛsɛ sɛ mohome da no, na moyɛ nhyiamu kronkron na mohyɛn torobɛnto denneennen de kae. ");
INSERT INTO twi_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Saa da no, obiara nni ho kwan sɛ ɔyɛ adwuma, na mmom, mommɔ ogya so afɔre mma Awurade.’ ” ");
INSERT INTO twi_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Saa ɔsram a ɛto so ason yi da a ɛto so du ne Mpata Da no. Monyɛ nhyiamu kronkron, munni abuada na mommɔ ogya so afɔre mma Awurade ");
INSERT INTO twi_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Monnyɛ adwuma biara saa da no, efisɛ ɛyɛ Mpata Da, bere a wɔpata ma mo wɔ Awurade mo Nyankopɔn anim. ");
INSERT INTO twi_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Obiara a wanni da no ahonu ne awerɛhow so wɔ ne bɔne ho no, wobeyi no afi ne nkurɔfo mu. ");
INSERT INTO twi_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Obiara a ɔbɛyɛ adwuma saa da no mɛsɛe no. ");
INSERT INTO twi_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Monnyɛ adwuma biara koraa. Eyi bɛyɛ ahyɛde a ɛbɛtena hɔ daa ama awo ntoatoaso a ɛbɛba no wɔ baabiara a mobɛtena. ");
INSERT INTO twi_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ɛyɛ Homeda a wɔde home ma mo. Ɛsɛ sɛ mobrɛ mo kra ase. Efi da a ɛto so akron kosi da a ɛto so du no anwummere no, ɛsɛ sɛ mudi mo Homeda.” ");
INSERT INTO twi_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Ka kyerɛ Israelfo se, ‘Ɔsram a ɛto so ason no da a ɛto so dunum no, wɔnhyɛ Awurade Asese Afahyɛ no ase, na mode nnanson na ebedi. ");
INSERT INTO twi_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Da a edi kan no yɛ nhyiamu kronkron da; monnyɛ adwuma biara. ");
INSERT INTO twi_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Da biara wɔ nnanson no mu no, ɛsɛ sɛ mobɔ ogya so afɔre ma Awurade. Da a ɛto so awotwe no, mobɛyɛ nhyiamu kronkron na moabɔ ogya so afɔre ama Awurade. Ɛyɛ nhyiamu a etwa to. Monnyɛ adwuma biara. ");
INSERT INTO twi_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘Eyinom ne afahyɛ ahorow a Awurade ahyehyɛ sɛ mommɔ ho dawuru sɛ ɛyɛ nhyiamu kronkron a wɔde afɔrebɔde a wɔhyew no ogya so ma Awurade no ba: ɔhyew afɔre ne aduan afɔre, afɔrebɔde ahorow ne nsa afɔrebɔde a ɛho hia da biara. ");
INSERT INTO twi_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Munni saa afahyɛ yi nka Awurade Homeda no ho. Na mode saa afɔrebɔde nso bɛka mo ankasa ayɛyɛde, bɔ a moahyɛ ne nea mufi mo pɛ mu de ma Awurade ho. ");
INSERT INTO twi_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Enti efi ɔsram a ɛto so ason no da a ɛto so dunum no a moatwa asase no so nnɔbae no, momfa nnanson nni afahyɛ mma Awurade. Da a edi kan ne nea ɛto so awotwe yɛ ahomegyenna. ");
INSERT INTO twi_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Da a edi kan no, muntwitwa nnuaba mman a aba wɔ so, ne mmerɛnkɛnsono ne mman a nhaban wɔ so na momfa mmɔ asese na momma mo ani nnye wɔ mo Awurade Nyankopɔn anim nnanson. ");
INSERT INTO twi_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ɛsɛ sɛ saa afe biara mu nnanson adidi mmara yi tena hɔ daa wɔ awo ntoatoaso nyinaa mu. ");
INSERT INTO twi_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Saa nnanson no mu no, mo a moyɛ Israelfo mma no, ɛsɛ sɛ motena asese no ase. ");
INSERT INTO twi_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Nkyerɛase a ɛwɔ mu ara ne sɛ, ɛkae Israelfo no fi awo ntoatoaso so kosi awo ntoatoaso so sɛ, me na migyee mo fii Misraim ma mobɛtenaa asese ase. Mene Awurade mo Nyankopɔn.’ ” ");
INSERT INTO twi_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Eyinom ne Awurade afahyɛ ahorow a wahyehyɛ a Mose ka kyerɛɛ Israelfo no. Enti Mose kyerɛɛ afahyɛ ahorow a Israelfo no bedi ama Awurade. ");
INSERT INTO twi_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Ka kyerɛ Israelfo na wɔmmrɛ wo ngo kronkron na fa sɔ kanea sɛnea ɛrennum da. ");
INSERT INTO twi_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Wɔ kaneadua a wɔde sikakɔkɔɔ ayɛ a esi ntwamtam a etwa kronkron mu kronkron no akyi no. Efi anwummere kosi anɔpa biara, Aaron bɛhwɛ akanea a ɛwɔ Awurade anim no so. Eyi bɛyɛ ayɛde a ɛbɛtena hɔ daa wɔ awo ntoatoaso nyinaa mu. ");
INSERT INTO twi_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ɛsɛ sɛ wɔhwɛ akanea a esisi sikakɔkɔɔ kaneadua so wɔ Awurade anim no so bere biara. ");
INSERT INTO twi_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Momfa asikresiam muhumuhu nto brodo amuamu dumien a mua biara mode esiam lita anan ne fa na ɛbɛto. ");
INSERT INTO twi_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Monhyehyɛ no ntaataaso abien, a asia wɔ ntaataaso baako biara mu wɔ sikakɔkɔɔ kann pon no so wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Mode aduhuam pa begu kyerɛpɛn biara ho de asi brodo no anan mu ayɛ afɔrebɔde a wɔhyew wɔ ogya so ma Awurade. ");
INSERT INTO twi_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ɛsɛ sɛ wɔde saa brodo yi sisi Awurade anim Homeda biara; ɛbɛyɛ apam a enni awiei ama Israelfo. ");
INSERT INTO twi_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Brodo yi yɛ Aaron ne ne mmabarima de, na ɛsɛ sɛ wodi wɔ kronkronbea hɔ, efisɛ ɛyɛ kronkron pa ara wɔ wɔn kyɛfa a ɛwɔ afɔrebɔde a wɔhyew ma Awurade no mu.” ");
INSERT INTO twi_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Da bi, aberante bi a ne na yɛ Israelni na nʼagya nso yɛ Misraimni ne Israelfo no baako nyaa ntɔkwaw wɔ wɔn atenae. ");
INSERT INTO twi_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ntɔkwaw no mu no, Israelni babarima no domee Onyankopɔn enti wɔde no baa Mose nkyɛn sɛ wommu no atɛn. Na ne na din de Selomit a ɔyɛ Dibri a ofi Dan abusua mu no babea. ");
INSERT INTO twi_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Wɔde no too afiase twɛn Awurade akwankyerɛ. ");
INSERT INTO twi_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Fa obusuyɛni no fi atenae ha kɔ na kɔka kyerɛ wɔn a wɔtee asɛm a ɔkae no nyinaa na wɔmfa wɔn nsa ngu nʼapampam; afei nnipa no nyinaa nsiw no abo nkum no. ");
INSERT INTO twi_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ka kyerɛ Israelfo no se, ‘Obiara a ɔbɛdome Onyankopɔn no, ɛsɛ sɛ onya ho asotwe: ");
INSERT INTO twi_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","obiara a ogu Awurade din ho fi no, ɛsɛ sɛ wokum no. Ɛsɛ sɛ dɔm no nyinaa siw no abo. Ɔhɔho anaa Israelni biara a obegu Awurade din ho fi no, ɛsɛ sɛ wokum no. ");
INSERT INTO twi_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Obiara a okum ne yɔnko nipa no, ɛsɛ sɛ wokum no. ");
INSERT INTO twi_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Obiara a okum aboa bi a ɛnyɛ ne dea no, ɛsɛ sɛ ɔhyɛ anan mu. ");
INSERT INTO twi_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Sɛ obi pira ne yɔnko a, ɔyɔnko no nso bepira no bi saa ara. ");
INSERT INTO twi_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Dompe mu bu nsi dompe mu bu anan mu; ani nsi ani anan mu; ɛse nsi ɛse anan mu. Sɛnea obi pira ɔfoforo, no saa ara na wompira ɔno nso. ");
INSERT INTO twi_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Obiara a obekum aboa bi no, ɛsɛ sɛ ɔhyɛ anan mu; nanso sɛ obi kum onipa a, ɛsɛ sɛ wokum no bi. ");
INSERT INTO twi_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Mmara koro no ara wɔ hɔ ma ɔhɔho ne kuroni. Mene Awurade, mo Nyankopɔn.’ ” ");
INSERT INTO twi_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Enti Mose kasa kyerɛɛ Israelfo no, na woyii obusuyɛni no fii atenae hɔ kosiw no abo. Israelfo no yɛɛ sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mose wɔ Sinai Bepɔw so no, Awurade ka kyerɛɛ no se, ");
INSERT INTO twi_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Ka kyerɛ Israelfo no se, ‘Sɛ mudu asase a mede rebɛma mo no so a, mfe ason biara, momma asase no nya Awurade mu homeda. ");
INSERT INTO twi_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Momfa mfe asia nnua mo nnɔbae wɔ mo mfuw mu na munyiyi mo bobe nturo mu na muntwa mo nnɔbae. ");
INSERT INTO twi_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Na mfe ason so no, asase no nna hɔ kwa wɔ Awurade anim. Monnyɛ so hwee. Munnnua so aba. Afe no nyinaa mu, munnyiyi mo bobe nturo no mu. ");
INSERT INTO twi_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Na aba biara a ebefifi no, monntew mfa, na bobe no nso, mommmoaboa ano mfa. Efisɛ ɛyɛ afe a ɛsɛ sɛ asase no home. ");
INSERT INTO twi_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Nanso aba biara a asase no bɛma saa afe no bɛyɛ aduan ama wo ne wʼakoa, wʼafenaa, wo paani ne wo hɔho, ");
INSERT INTO twi_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","wo nyɛmmoa ne wuram mmoa a ɛwɔ asase no so nyinaa. Munni biribiara a asase no bɛma biara. ");
INSERT INTO twi_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Bubu Homeda mfe ason, mfe ason ahorow ason, na wubenya mfe aduanan akron. ");
INSERT INTO twi_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Afei, ɔsram a ɛto so ason no da du no yɛ Mpata Da. Monhyɛn torobɛnto wɔ baabiara. Mpata Da no, monhyɛn torobɛnto no denneennen nkyɛ wɔ ɔman no mu baabiara. ");
INSERT INTO twi_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Montew mfe aduonum no ho na mompae ahofadi mma wɔn a wɔtete asase no so mmaa nyinaa. Ɛbɛyɛ mfirihyia aduonum afahyɛ ama mo, na mo mu biara bɛsan akɔ asase a wɔde ama mo agyanom no so, na moakɔka mo abusuafo ho. ");
INSERT INTO twi_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Mfe aduonum so no bɛyɛ mfirihyia aduonum afahyɛ ama mo; munnnua biribiara na munntwa nnɔbae biara, na bobe a moadua nso, monntew so aba. ");
INSERT INTO twi_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Efisɛ ɛyɛ mfirihyia aduonum afahyɛ, na ɛsɛ sɛ ɛyɛ sononko na ɛho tew. Munni nea munya fi asase no mu nko ara. ");
INSERT INTO twi_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Saa mfirihyia aduonum afahyɛ yi, obiara bɛkɔ asase a wɔde maa nʼagyanom no so. ");
INSERT INTO twi_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Sɛ wo ne wo yɔnko yɛ nhyehyɛe a wonam so retɔ anaa woretɔn agyapade bi a, ɛnsɛ sɛ obi sisi ne yɔnko. ");
INSERT INTO twi_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Sɛ woretɔ asase afi wo yɔnko nkyɛn a, mobɛkan mfe dodow no so fa afi Mfirihyia Aduonum Afahyɛ a etwaa mu no. Ɔdetɔnfo no begye wo bo a egyina mfe dodow a aka ansa na mfirihyia aduonum afahyɛ a ɛreba no. ");
INSERT INTO twi_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Mfe no dodow na ɛma ɛbo no kɔ soro. Saa ara nso na mfe kakra bi ma ɛbo no kɔ fam. Eyinom nyinaa mu no, onipa a ɔretɔn asase no retɔn otwa dodow a wobetwa afi asase no so. ");
INSERT INTO twi_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Munsuro mo Nyankopɔn na obi ansisi ne yɔnko. Na mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Sɛ mopɛ sɛ motena asase no so asomdwoe mu de a, munni me mmara so. ");
INSERT INTO twi_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Sɛ moyɛ osetie a, aduan bebu so wɔ asase no so na moadi amee wɔ asomdwoe mu. ");
INSERT INTO twi_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Mubebisa se, “Na sɛ wose yennnua anaa yenntwa saa afe no so a, dɛn na yebedi wɔ mfe ason no so no?” ");
INSERT INTO twi_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mmuae ara ne sɛ, mfe asia no so, mehyira mo ama nnɔbae aba abu so kosi sɛ mubetwa mfe awotwe mu nnɔbae no. ");
INSERT INTO twi_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Sɛ mudua nnɔbae wɔ mfe awotwe no mu a, mobɛkɔ so adi afe a etwaa mu no mu nnuan. Nokware, nnuan dedaw no na mubedi akosi sɛ otwabere bedu so mfe akron no mu. ");
INSERT INTO twi_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Na monkae sɛ asase no yɛ me dea enti munni ho kwan sɛ motɔn no afebɔɔ. Moyɛ ahɔho na meyɛ asase wura ma mo. ");
INSERT INTO twi_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Asasetɔn mu no, ɛsɛ sɛ moyɛ nhyehyɛe sɛ asasetɔnfo no tumi san begye asase no bere biara. ");
INSERT INTO twi_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Sɛ ohia hia obi ma ɔtɔn nʼasase fa bi a, nʼabusuafo tumi begye. ");
INSERT INTO twi_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Sɛ onni obi a obegye ama no na sɛ ɔno ankasa nya sika a, ");
INSERT INTO twi_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","wɔbɛsese ɛso nnɔbae a wɔatwa ansa na Ahosɛpɛw Afe no reba na wɔagyina so atua ka no, na nea ɔtɔe no nso adan asase no ama no. ");
INSERT INTO twi_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Na sɛ nea asase no yɛ ne de no ankasa antumi annye a, ɛno de, ɛbɛyɛ nea ɔtɔ no dea ara kosi Mfirihyia Aduonum Afahyɛ no, na nea ɔtɔe no de onipa no ade asan ama no. ");
INSERT INTO twi_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Sɛ obi tɔn ofi wɔ kurom a, ɔwɔ afe a otumi san gye nʼade a biribiara nsiw no ho kwan. ");
INSERT INTO twi_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Na sɛ afe no mu wantumi annye a, ɛbɛyɛ nea ɔtɔe no de korakora. Ɔrensan mfa mma onipa a kan no na ɛyɛ ne dea no wɔ Ahosɛpɛw Afe no mu. ");
INSERT INTO twi_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Nanso akuraa dan a wɔntoo ɔfasu ntwaa ho nhyiae te sɛ agyapade a ɛwɔ wuram de, wotumi san kogye no bere biara, na Mfe Aduonum Afahyɛ mu no, ɛsɛ sɛ wɔsan de ma ne wura ankasa. ");
INSERT INTO twi_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Asɛm baako bi na ɛnka ho. Lewifo afi a ɛwɔ nkurow a wɔde afasu atwa ho mu no, wotumi san gye no bere biara. ");
INSERT INTO twi_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Enti Lewifo de, wotumi gye wɔn agyapade; wɔn kurow biara mu ofi a wɔtɔnee, ɛsɛ sɛ wɔdan ma wɔn wuranom wɔ Ahosɛpɛw Afe no mu, efisɛ afi no yɛ wɔn dea. ");
INSERT INTO twi_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ɛnsɛ sɛ wɔtɔn nsase a atwa Lewifo no nkurow ho ahyia, efisɛ eyinom yɛ wɔn agyapade afebɔɔ a ɛnsɛ sɛ wɔne obiara kyɛ. ");
INSERT INTO twi_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Sɛ ohia hia wo nua a, ɛsɛ sɛ woboa no; ma no mmra ma ɔmmɛtena hɔ bi. ");
INSERT INTO twi_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Suro wo Nyankopɔn na ma wo nua ntena wo nkyɛn; na sɛ wobɔ no bosea a, nnye no ho mfɛntom. ");
INSERT INTO twi_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Kae sɛ worennye ho mfɛntom biara; na ma no biribiara a ɛho hia no na ɛnyɛ wo ka. Mpɛ mfaso! ");
INSERT INTO twi_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Efisɛ me Awurade a meyɛ mo Nyankopɔn no yii mo fii Misraim de Kanaan asase maa mo sɛnea mɛyɛ mo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Sɛ ohia hia wo yɔnko Israelni na ɔtɔn ne ho ma wo a, nhyɛ ne so sɛ ɔdɔnkɔ; ");
INSERT INTO twi_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","na mmom, yɛ no sɛ obi a wutua no ne som a ɔsom ho ka, anaa fa no sɛ wo hɔho na ɔnsom wo nkosi Mfirihyia Aduonum Afahyɛ no. ");
INSERT INTO twi_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Edu saa bere no a, ɔne ne mma nyinaa tumi tu de wɔn agyapade nyinaa kɔ wɔn abusuafo nkyɛn. ");
INSERT INTO twi_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Efisɛ Israelfo no yɛ mʼasomfo a mede wɔn fi Misraim asase so bae; ɛnsɛ sɛ wɔtɔn wɔn sɛ nkoa. ");
INSERT INTO twi_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Mommfa atirimɔden nni wɔn so; munsuro mo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Nanso mubetumi atɔ asomfo afi aman afoforo a atwa mo ho ahyia no so. ");
INSERT INTO twi_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Saa ara nso na mutumi tɔ ahɔho a mo ne wɔn te no mma a ɛmfa ho sɛ wɔte mo mu. ");
INSERT INTO twi_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Mubetumi ayɛ wɔn nkoa afebɔɔ ama mo ne mo nkyirimma, nanso mo nuanom Israelfo no de, ɛnsɛ sɛ moyɛ wɔn saa. ");
INSERT INTO twi_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Sɛ ɔhɔho a ɔte mo mu no bɛyɛ ɔdefo, na sɛ Israelni di hia, na ɔtɔn ne ho ma ɔhɔho no anaa ɔhɔho no abusuafo a, ");
INSERT INTO twi_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ɔwɔ kwan sɛ wogye no wɔ ne tɔn akyi; ne nuanom bi tumi begye no. ");
INSERT INTO twi_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Saa ara nso na ne wɔfa, ne wɔfaase anaa ne ho nipa bi a ɔbɛn no tumi gye no ara ne no. Sɛ ɔno ara nso benya sika a, otumi de begye ne ho. ");
INSERT INTO twi_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ne ho a obegye no gyina mfe a aka na Mfirihyia Aduonum Afahyɛ no adu ne sika dodow a sɛ anka wɔde kɔfaa ɔsomfo a, anka obegye saa mfe a aka no mu no so. ");
INSERT INTO twi_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Sɛ aka mfe pii ansa na Ahosɛpɛw Afe no aso a, obetua sika a ogyee wɔ bere a ɔtɔn ne ho no nyinaa. ");
INSERT INTO twi_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Sɛ mfe no pii atwam ama aka kakra na Mfirihyia Aduonum Afahyɛ no adu a, ɛno de, obetua sika a ogyee bere a ɔtɔn ne ho no mu kakraa bi. ");
INSERT INTO twi_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Sɛ ɔtɔn ne ho ma ɔhɔho a, ɔhɔho no bɛfa no sɛ ne somfo a otua no ka. Ɛnsɛ sɛ ɔfa no sɛ ne somfo koraa anaa nʼagyapade. ");
INSERT INTO twi_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Sɛ Mfirihyia Aduonum Afahyɛ no du na wonnyee no a, wobegyaa ɔne ne mma nyinaa, ");
INSERT INTO twi_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","efisɛ wɔyɛ mʼasomfo. Mede wɔn fi Misraim na ɛbae. Mene Awurade mo Nyankopɔn no. ");
INSERT INTO twi_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Monnyɛ abosom. Munnsisi ahoni anaa abo mma mo ho. Mommfa abo a wɔatwa nsisi mo asase so sɛ morebɛkotow wɔn. Mene Awurade mo Nyankopɔn no. ");
INSERT INTO twi_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Ɛsɛ sɛ mudi me Homeda, na mode nidi ma me kronkronbea. Mene Awurade. ");
INSERT INTO twi_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Sɛ mudi me mmara no nyinaa so a, ");
INSERT INTO twi_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","daa mɛtɔ osu ama mo ama mo nnɔbae ayɛ yiye abu so, na mo nnua nso bɛsow aba a ɛbɛkyɛ wɔ nnua no so. ");
INSERT INTO twi_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Na sɛ edu odua bere so bio koraa a, mo borɔdɔma bɛkɔ so abere. Mubedidi amee na moatena asase no so asomdwoe mu. ");
INSERT INTO twi_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Mɛma mo asomdwoe, na mɛma mo ada a munnsuro hwee. Mɛpam mmoa bɔne afi mo ho. ");
INSERT INTO twi_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mobɛtaa mo atamfo; na wobewuwu wɔ mo afoa ano. ");
INSERT INTO twi_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Mo mu baanum bɛka ɔha agu, na mo mu ɔha aka mpem du agu! Mo atamfo bɛtotɔ wɔ afoa ano wɔ mo anim. ");
INSERT INTO twi_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘Mɛhwɛ mo so na mama mo adɔ, na madi apam a me ne mo pamee no so. ");
INSERT INTO twi_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mo nnɔbae bebu so a sɛ otwabere foforo du so a, morenhu nea mode bɛyɛ. ");
INSERT INTO twi_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Na mɛtena mo mu, na merenkyi mo. ");
INSERT INTO twi_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Me ne mo bɛnantew, na mayɛ mo Nyankopɔn, na moayɛ me nkurɔfo. ");
INSERT INTO twi_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mene Awurade mo Nyankopɔn a ɔde mo fi Misraim asase so bae sɛnea morenyɛ Misraimfo nkoa bio no. Mibubuu mo konnua nkɔnsɔnkɔnsɔn, na ɛma mo anantew anuonyam so. ");
INSERT INTO twi_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Na sɛ moantie me, anni mʼasɛm so, ");
INSERT INTO twi_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","na mopo mʼahyɛde ne me mmara na moanni so, bu mʼapam so a, ");
INSERT INTO twi_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","nea mɛyɛ mo ni: Mɛma mo koma atutu na mama nsamanwaw ayɛ mo, na atiridiinini abɔ mo. Mo ani betutu, na mo nkwa so ahuan. Mubedua nnɔbae agu kwa, efisɛ mo atamfo na wobedi. ");
INSERT INTO twi_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Meyi mʼani afi mo so, na moaguan afi mo atamfo anim. Wɔn a wɔtan mo no bedi mo so. Mubeguan bere a obiara ntaa mo mpo. ");
INSERT INTO twi_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘Na sɛ mokɔ so yɛ asoɔden a, mɛtwe mo bɔne no so aso mmɔho ason. ");
INSERT INTO twi_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Mɛsɛe mo ahantan tumi no na mayɛ mo soro sɛ dade ne mo fam sɛ kɔbere. ");
INSERT INTO twi_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Mobɛsɛe mo ahoɔden kwa, na mo asase rennya nnɔbae biara, na ɛso nnua nso rensow aba. ");
INSERT INTO twi_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘Na sɛ tie ara na morentie me a, mo bɔne nti, mede ɔyaredɔm mmɔho ason a ɛfata mo bɔne no begu mo so. ");
INSERT INTO twi_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Mɛma nkekaboa abekunkum mo mma na wɔakunkum mo anantwi, na matew mo dodow so, na mo akwan bɛda mpan a obi mfa so bio. ");
INSERT INTO twi_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘Na sɛ eyi antumi ansakra mo, na mokɔ so tia mʼapɛde a, ");
INSERT INTO twi_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","me nso, metia mo apɛde, na me ara mʼankasa mɛtwe mo aso mpɛn ason wɔ mo bɔne ho. ");
INSERT INTO twi_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Menam ɔko so bebu mʼapam so ako atia mo de atua mo so ka. Mubeguan akɔ mo nkurow mu, na mede nyarewa bɛtoa mo wɔ hɔ. Na mo atamfo bedi mo so. ");
INSERT INTO twi_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Mɛsɛe mo nnuan a mubenya nyinaa akosi sɛ mpo, fononoo baako brodo a ɛbɛto no na mmusuakuw du bedi. Aduan kakra a mubedi no akyi, ɔkɔm bɛde mo. ");
INSERT INTO twi_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘Na sɛ mokɔ so yɛ asoɔden a, ");
INSERT INTO twi_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","mo bɔne nti, me bo befuw mo na matwe mo aso a emu yɛ den mmɔho ason. ");
INSERT INTO twi_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mobɛwe mo mmabarima ne mo mmabea nam. ");
INSERT INTO twi_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Mɛsɛe mo sorɔnsorɔmmea. Metwitwa mo aduhuam afɔremuka agu, na mahyehyɛ mo afunu wɔ mo ahoni a enni nkwa no so; na mɛpo mo. ");
INSERT INTO twi_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Mɛma mo nkurow ayɛ amamfo na masɛe baabi a mosom nyinaa, na mapo mo ohuam afɔrebɔ no. ");
INSERT INTO twi_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ampa ara, mɛma mo asase so ada mpan na mo atamfo atena so, na nea mɛyɛ mo no ayɛ mo nwonwa. ");
INSERT INTO twi_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Mɛbɔ mo apete aman no a morekɔ so nyinaa so, na mede ɔko asɛe mo. Mo asase bɛda mpan na wɔasɛe mo nkurow. ");
INSERT INTO twi_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Akyiri no, asase no bɛda hɔ ahome de asi mfe dodow a moamma anhome no anan; ɛbɛda hɔ wɔ mmere a mowɔ atamfo nsam wɔ wɔn nsase so no nyinaa. Na asase no ahome, na anya ne home nna nso. ");
INSERT INTO twi_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Bere a asase no da mpan nyinaa, ebenya home a moamma annya wɔ Homeda dodow a motenaa so no. ");
INSERT INTO twi_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Wɔn a wogyaw wɔn hɔ a wonwui no nso, mɛma wɔatwe wɔn akɔ akyirikyiri nsase so sɛ ɔko mu nneduafo ne nkoa. Ɛhɔ na wɔbɛtena daa wɔ ehu mu. Wɔte sɛ mframa rebɔ ahaban koraa a, wobeguan te sɛ nea obi a okura afoa repam wɔn; wɔbɛhwehwe ase wɔ bere a obi ntaa wɔn. ");
INSERT INTO twi_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Obiara rentaa wɔn nanso ehu nti, wobehintihintiw wɔn ho wɔn ho te sɛnea wɔreguan afi akono a wonni tumi biara a wɔde begyina wɔn atamfo anim no. ");
INSERT INTO twi_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mobɛyera wɔ aman mu, na mo atamfo asɛe mo. ");
INSERT INTO twi_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Wɔn a wɔbɛka no, wɔn bɔne nti, wɔn ho bɛyeraw wɔn wɔ atamfo nsase so, bɔne a wɔn agyanom yɛe no nti. ");
INSERT INTO twi_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Nanso akyiri no, me nkurɔfo bɛka wɔn bɔne ne wɔn agyanom bɔne. Wɔbɛka sɛnea wodii me huammɔ na wotiaa me no. ");
INSERT INTO twi_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Sɛ me nso mitia wɔn sɛ nea ɛsɛ na mede wɔn kɔ wɔn atamfo asase so a, afei, wɔn komaden no ano bɛbrɛ ase, na wobetua wɔn bɔne so ka. ");
INSERT INTO twi_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Afei, mɛkae apam a mene Yakob, Isak ne Abraham ayɛ, na mɛkae asase no. ");
INSERT INTO twi_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Asase no da hɔ dinn no, ebedi ne homeda. Nanso akyiri no, wobenya wɔn asotwe sɛ wɔanni me nhyehyɛe so na wɔpoo mʼahyɛde. ");
INSERT INTO twi_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Na nea wɔyɛɛ no nyinaa akyi no, merensɛe wɔn ne mʼapam no korakora, efisɛ mene Awurade wɔn Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Mɛkae tete apam a me ne wɔn agyanom a miyii wɔn fii Misraim, bere a amanaman nyinaa rehwɛ no yɛe no. Me Awurade ne wɔn Nyankopɔn.’ ” ");
INSERT INTO twi_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Eyinom ne mmara ne ahyɛde a Awurade nam Mose so de maa Israelfo no wɔ Sinai Bepɔw so no. ");
INSERT INTO twi_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Ka kyerɛ Israelfo no se, ‘Sɛ onipa bi hyɛ bɔ sɛ ɔde obi bɛma Awurade a, na sɛ ɔpɛ sɛ otua sika mmom a, ");
INSERT INTO twi_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","obetua dwetɛ gram ahannum ne aduoson (570) ama ɔbarima a wadi mfe aduonu kosi mfe aduosia, ");
INSERT INTO twi_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","sɛ ɔyɛ ɔbea a wadi mfe aduonu kosi aduosia a, wobetua dwetɛ gram ahaasa ne aduanan (340), ");
INSERT INTO twi_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","abarimaa a wadi mfe anum kosi aduonu no nso wobetua dwetɛ gram ahannu ne aduasa (230). Sɛ ɔyɛ ɔbea a, wobetua dwetɛ gram ɔha ne dunum (115). ");
INSERT INTO twi_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Abarimaa a wadi ɔsram kosi mfe anum no wobetua dwetɛ gram 60; na ɔbabea nso wɔatua dwetɛ gram 35. ");
INSERT INTO twi_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ɔbarima a wadi boro mfe aduosia no wobetua dwetɛ gram ɔha aduoson (170); na ɔbea nso wɔatua dwetɛ gram ɔha ne dunum (115). ");
INSERT INTO twi_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Na sɛ obi yɛ ohiani a ɔrentumi ntua saa sika yi a, ɔde saa onipa no bɛba ɔsɔfo anim, na ɔsɔfo no akyerɛ no sika a obetumi atua. ");
INSERT INTO twi_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Sɛ ɔde aboa hyɛ bɔ sɛ afɔrebɔde a ɛfata ma Awurade a, saa aboa no a ɔde ama Awurade no bɛyɛ kronkron. ");
INSERT INTO twi_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ɛnsɛ sɛ ɔsesa saa aboa no. Ɛnsɛ sɛ ɔde nea eye sesa nea enye anaa sɛ ɔde nea enye sesa nea eye. Sɛ ɛba sɛ wɔyɛ saa nsesae yi a, wɔbɛfa no sɛ mmoa abien no nyinaa ho tew. ");
INSERT INTO twi_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Sɛ aboa a ɔde rema Awurade no ho ntew na ɛmfata sɛ wɔde yɛ afɔrebɔde ma Awurade a, ɛsɛ sɛ ne wura no de brɛ ɔsɔfo, ");
INSERT INTO twi_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","na wahwɛ sɛ aboa no di mu anaa sɛ onni mu, na wakyerɛ sika dodow a ɛsɛ sɛ otua de si aboa no anan. ");
INSERT INTO twi_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Sɛ aboa no yɛ nea ɛsɛ sɛ wɔde no bɔ afɔre nanso onipa a ɔde no reba no pɛ sɛ ɔsan gye nʼade a, obetua sika ɔha mu nkyɛmu aduonu aka bo a ɔsɔfo no betwa ama no sɛ ontua no ho. ");
INSERT INTO twi_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Sɛ obi de ne fi ma Awurade na sɛ ɔpɛ sɛ ɔsan gye a, ɔsɔfo no bɛsese ahu sɛ eye anaasɛ enye. Bo biara a ɔsɔfo no bɛkyerɛ no na ɛsɛ sɛ wotua. ");
INSERT INTO twi_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Sɛ nea ɔde ofi no mae no pɛ sɛ ɔsan gye a ɛsɛ sɛ otua ne bo no nkyɛmu ɔha mu aduonu ka ho na ama ofi no asan abɛyɛ ne de. ");
INSERT INTO twi_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Sɛ ɔbarima bi pɛ sɛ ɔde nʼabusua asase fa bi bɔ afɔre ma Awurade a, wobegyina aba kɛntɛnma dodow a ebehia sɛ wobedua wɔ so no so atwa asase no bo; aba kɛntɛnma biara bo yɛ dwetɛ gram ahannum ne aduoson (570). ");
INSERT INTO twi_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Mfirihyia Aduonum Afahyɛ mu no, sɛ obi de nʼafuw kyɛ a, ne bo no rensesa. ");
INSERT INTO twi_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Na sɛ ɔde asase no ma wɔ Mfirihyia Aduonum Afahyɛ no akyi a, ɔsɔfo no begyina mfe a aka ansa na Mfirihyia Aduonum Afahyɛ a edi so no so asese ne bo no, na wobetumi atew so. ");
INSERT INTO twi_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Na sɛ ɔbarima no pɛ sɛ ogye nʼasase a, ɔsɔfo no bo a ɔbɛbɔ no, obetua ɔha mu nkyɛmu aduonu aka ho ansa na asase no abɛyɛ ne dea bio. ");
INSERT INTO twi_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Na sɛ nso ɔyɛ nʼadwene sɛ ɔmpɛ sɛ ogye asase no bio, anaasɛ sɛ watɔn asase no ama obi foforo a, ɛno de, wɔrentumi nnye bio. ");
INSERT INTO twi_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Sɛ wɔdan asase no ma wɔ Mfirihyia Aduonum Afahyɛ no mu a, ɛbɛyɛ asase kronkron. Wɔde bɛto hɔ ama Awurade. Ɛbɛyɛ asɔfo no agyapade. ");
INSERT INTO twi_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Sɛ obi de asase a watɔ ma Awurade, na sɛ asase no nyɛ nʼabusua asase a, ");
INSERT INTO twi_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ɔsɔfo no begyina mfe a aka ama wɔadi Mfirihyia Aduonum Afahyɛ no so asese ne bo. Ɛsɛ sɛ onipa ko no tua ka no da no ara, na ɛyɛ afɔrebɔde kronkron ma Awurade. ");
INSERT INTO twi_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Mfirihyia Aduonum Afahyɛ no du so a, asase no bɛsan akɔ nea ɔtɔnee no anaasɛ nea na ɔyɛ asase no wura no nkyɛn. ");
INSERT INTO twi_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Wɔbɛsese ho ka no nyinaa wɔ nnwetɛbona a wogye wɔ hyiadan mu no ho, a ɛyɛ gram dubaako. ");
INSERT INTO twi_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Ɛnsɛ sɛ obiara de aboa bi abakan ma Awurade, efisɛ abakan biara, sɛ ɔyɛ nantwi anaa oguan no, yɛ Awurade de dedaw. ");
INSERT INTO twi_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Sɛ ɔyɛ mmoa a wɔn ho ntew no bi a, onipa no betumi atua ne bo no, na ɔde ɛbo no ɔha mu nkyɛmu aduonu aka ho. Sɛ onipa no antɔ bio de a, wɔbɛtɔn aboa no sɛnea ne bo te. ");
INSERT INTO twi_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Ade biara a wɔde ama Awurade no, sɛ ɛyɛ nnipa, mmoa anaa abusuasase no, ɛnsɛ sɛ wɔtɔn anaa wɔsan gye, efisɛ biribiara a ɛte saa no yɛ kronkron ma Awurade. ");
INSERT INTO twi_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Onipa biara a Awurade ayi no ama ɔsɛe no, wɔmmfa biribi ntua ne ti ka. Ɛsɛ sɛ wokum no. ");
INSERT INTO twi_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Asase no so nnɔbae nkyɛmu du mu baako, sɛ ɛyɛ aburow anaa aduaba no yɛ Awurade dea. Ɛyɛ kronkron. ");
INSERT INTO twi_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Sɛ obi pɛ sɛ ɔsan tɔ saa aduaba anaa aburow no a, ɛsɛ sɛ ɔde ne bo nkyɛmu anum mu baako ka ho. ");
INSERT INTO twi_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Anantwi ne nguan no ntotoso du du nyinaa, aboa biara a ɔto so du a ɔfa oguanhwɛfo nsam no yɛ kronkron ma Awurade. ");
INSERT INTO twi_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Aboa a ɔto so du a wɔde bɛma Awurade no, wɔnnhwɛ sɛ oye anaa onye, na wɔmmfa biribiara nsi nʼanan mu, efisɛ sɛ wɔde biribiara si anan mu a, ne nyinaa bɛyɛ kronkron, a obiara rentumi nnye bio.’ ” ");
INSERT INTO twi_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Eyinom ne ahyɛde a Awurade de maa Mose wɔ Sinai Bepɔw so sɛ ɔnka nkyerɛ Israelfo no.");
INSERT INTO twi_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Awurade kasa kyerɛɛ Mose wɔ Ahyiae Ntamadan a ɛwɔ Sinai nweatam so. Eyi sii wɔ mfe abien a Israelfo fii Misraim no akyi, ɔsram a ɛto so abien no da a edi kan. Ɔkae se: ");
INSERT INTO twi_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Gyina Israelfo no mmusuakuw ne wɔn mmusua so kan wɔn nyinaa. Kyerɛw ɔbarima biara din. ");
INSERT INTO twi_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Wo ne Aaron na mobɛkan mmarima a wɔadi mfe aduonu no ne nea ɛboro saa a wotumi kɔ ɔsa. ");
INSERT INTO twi_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ɔbarima a ofi abusuakuw biara mu a ɔyɛ ntuanoni na ɛsɛ sɛ ɔboa mo. ");
INSERT INTO twi_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Mmarima a wɔbɛboa mo no din ni: “Ruben abusuakuw no ntuanoni ne Sedeur babarima Elisur; ");
INSERT INTO twi_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeon abusuakuw no ntuanoni ne Surisadai babarima Selumiel; ");
INSERT INTO twi_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yuda abusuakuw no ntuanoni ne Aminadab babarima Nahson; ");
INSERT INTO twi_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Isakar abusuakuw no ntuanoni ne Suar babarima Netanel; ");
INSERT INTO twi_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Sebulon abusuakuw no ntuanoni ne Helon babarima Eliab; ");
INSERT INTO twi_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yosef mmabarima no: Efraim abusuakuw no ntuanoni ne Amihud babarima Elisama; Manase abusuakuw no ntuanoni ne Pedahsur babarima Gamaliel; ");
INSERT INTO twi_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Benyamin abusuakuw ntuanoni ne Gideoni babarima Abidan; ");
INSERT INTO twi_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan abusuakuw ntuanoni ne Amisadai babarima Ahieser; ");
INSERT INTO twi_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Aser abusuakuw ntuanoni ne Okran babarima Pagiel; ");
INSERT INTO twi_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gad abusuakuw ntuanoni ne Deguel babarima Eliasaf; ");
INSERT INTO twi_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Naftali abusuakuw ntuanoni ne Enan babarima Ahira.” ");
INSERT INTO twi_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Eyinom ne mmarima a woyii wɔn fii nnipa no mu, a wɔyɛ wɔn agyanom mmusua no ntuanofo. ");
INSERT INTO twi_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mose ne Aaron faa saa nnipa a wɔabobɔ wɔn din yi, ");
INSERT INTO twi_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","na da a edi kan wɔ ɔsram a ɛto so abien no mu no, wɔfrɛɛ ɔmanfo no nyinaa. Nnipa no nam wɔn mmusuakuw ne wɔn mmusua so kyerɛɛ wɔn anato na wɔkyerɛw mmarima a wɔadi mfe aduonu ne nea ɛboro saa no din mmaako mmaako, ");
INSERT INTO twi_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","sɛnea Awurade hyɛɛ Mose no. Enti ɔkan wɔn wɔ Sinai sare so. ");
INSERT INTO twi_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ruben a ɔyɛ Israel abakan asefo: Wɔkyerɛw mmarima a wɔadi mfe aduonu ne nea ɛboro saa a wotumi kɔ ɔsa no, wɔkyerɛw wɔn din mmaako mmaako sɛnea wɔn mmusua te. ");
INSERT INTO twi_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Nnipa dodow a wofi Ruben abusuakuw no mu no yɛ mpem aduanan asia ne ahannum (46,500). ");
INSERT INTO twi_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simeon asefo: Mmarima a wɔadi mfe aduonu ne nea ɛboro saa a wobetumi akɔ ɔsa no, wɔkyerɛw wɔn din mmaako mmaako sɛnea wɔn mmusua te. ");
INSERT INTO twi_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Nnipa dodow a wofi Simeon abusuakuw no mu no yɛ mpem aduonum akron ne ahaasa (59,300). ");
INSERT INTO twi_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gad asefo: Wɔkyerɛw mmarima a wɔadi mfe aduonu ne nea ɛboro saa a wobetumi akɔ ɔsa no din sɛnea wɔn mmusua te. ");
INSERT INTO twi_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Nnipa dodow a wofi Gad abusuakuw no mu no yɛ mpem aduanan anum ahansia ne aduonum (45,650). ");
INSERT INTO twi_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Yuda asefo: Wɔkyerɛw mmarima a wɔadi mfe aduonu ne nea ɛboro saa a wobetumi akɔ ɔsa no din sɛnea wɔn mmusua te. ");
INSERT INTO twi_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Nnipa dodow a wofi Yuda abusuakuw no mu no yɛ mpem aduɔson anan ne ahansia (74,600). ");
INSERT INTO twi_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Isakar asefo: Wɔkyerɛw mmarima a wɔadi mfe aduonu ne nea ɛboro saa a wobetumi akɔ ɔsa no din sɛnea wɔn mmusua te. ");
INSERT INTO twi_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Nnipa dodow a wofi Isakar abusuakuw no mu no yɛ mpem aduonum anan ne ahannan (54,400). ");
INSERT INTO twi_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Sebulon asefo: Wɔkyerɛw mmarima a wɔadi mfe aduonu ne nea ɛboro saa a wobetumi akɔ ɔsa no din sɛnea wɔn mmusua te. ");
INSERT INTO twi_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Nnipa dodow a wofi Sebulon abusuakuw no mu no yɛ mpem aduonum ason ne ahannan (57,400). ");
INSERT INTO twi_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Yosef mmabarima no: Efraim asefo: Wɔkyerɛw mmarima a wɔadi mfe aduonu ne nea ɛboro saa a wobetumi akɔ ɔsa no din sɛnea wɔn mmusua te. ");
INSERT INTO twi_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Nnipa dodow a wofi Efraim abusuakuw no mu no yɛ mpem aduanan ne ahannum (40,500). ");
INSERT INTO twi_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manase asefo: Wɔkyerɛw mmarima a wɔadi mfe aduonu ne nea ɛboro saa a wobetumi akɔ ɔsa no din sɛnea wɔn mmusua te. ");
INSERT INTO twi_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Nnipa dodow a wofi Manase abusuakuw no mu no yɛ mpem aduasa abien ne ahannu (32,200). ");
INSERT INTO twi_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Benyamin asefo: Wɔkyerɛw mmarima a wɔadi mfe aduonu ne nea ɛboro saa a wobetumi akɔ ɔsa no din sɛnea wɔn mmusua te. ");
INSERT INTO twi_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Nnipa dodow a wofi Benyamin abusuakuw no mu no yɛ mpem aduasa anum ne ahannan (35,400). ");
INSERT INTO twi_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan asefo: Wɔkyerɛw mmarima a wɔadi mfe aduonu ne nea ɛboro saa a wobetumi akɔ ɔsa no din sɛnea wɔn mmusua te. ");
INSERT INTO twi_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Nnipa dodow a wofi Dan abusuakuw no mu no yɛ mpem aduosia abien ne ahanson (62,700). ");
INSERT INTO twi_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Aser asefo: Wɔkyerɛw mmarima a wɔadi mfe aduonu ne nea ɛboro saa a wobetumi akɔ ɔsa no din sɛnea wɔn mmusua te. ");
INSERT INTO twi_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Nnipa dodow a wofi Aser abusuakuw no mu no yɛ mpem aduanan baako ne ahannum (41,000). ");
INSERT INTO twi_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Naftali asefo: Wɔkyerɛw mmarima a wɔadi mfe aduonu ne nea ɛboro saa a wobetumi akɔ ɔsa no din sɛnea wɔn mmusua te. ");
INSERT INTO twi_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Nnipa dodow a wofi Naftali abusuakuw no mu no yɛ mpem aduonum abiɛsa ne ahannan (53,400). ");
INSERT INTO twi_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Eyinom ne mmarima a Mose ne Aaron ne Israel mmusuakuw dumien no ntuanofo kan wɔn. ");
INSERT INTO twi_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Israelfo a na wɔadi mfe aduonu anaa nea ɛboro saa no a wobetumi adɔm Israel asraafodɔm no nso, wogyinaa wɔn mmusua so kan wɔn. ");
INSERT INTO twi_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Na wɔn nyinaa dodow yɛ mpem ahansia ne abiɛsa ne ahannum aduonum (603,550). ");
INSERT INTO twi_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Mmusua a wɔwɔ Lewi abusuakuw no de, wɔankan wɔn anka wɔn a aka no ho. ");
INSERT INTO twi_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Na Awurade aka akyerɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Nkan Lewifo abusuakuw no, na mfa wɔn nka Israelfo a wɔaka no ho. ");
INSERT INTO twi_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Fa Ahyiae Ntamadan no ho dwumadi hyɛ Lewifo no nsa. Wɔnhwɛ nneɛma a wɔde asiesie mu ne nea ɛkeka ho nyinaa so. Wɔn na wɔbɛsoa Ahyiae Ntamadan no ne mu nneɛma, wɔbɛhwɛ so na wɔatenatena ho. ");
INSERT INTO twi_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Bere biara a ɛsɛ sɛ wotu Ahyiae Ntamadan no, Lewifo no na ɛsɛ sɛ wotutu, na baabiara a wɔde besi no, wɔn na wɔbɛyɛ. Onipa foforo biara a ɔbɛbɛn ho no, wobekum no. ");
INSERT INTO twi_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israel abusuakuw biara benya ne tenabea ne ne frankaa. ");
INSERT INTO twi_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Lewifo no besisi wɔn ntamadan atwa Ahyiae Ntamadan no ho ahyia, sɛnea ɛbɛyɛ a Onyankopɔn abufuwhyew remma Israelfo no so. Lewifo no na wɔbɛhwɛ Ahyiae Ntamadan no so.” ");
INSERT INTO twi_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israelfo no yɛɛ eyinom nyinaa sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Awurade ka kyerɛɛ Mose ne Aaron se: ");
INSERT INTO twi_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Abusua biara benya nʼafa wɔ atenae hɔ, na kuw biara bɛtena nʼabusua frankaa ase. Na mmusua no atenae ahorow no mfimfini na wɔde Ahyiae Ntamadan no besi.” ");
INSERT INTO twi_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Apuei fam, baabi a owia pue fi hɔ no na ɛsɛ sɛ Yuda nnipa nkyekyɛmu ahorow no nyinaa bɔ wɔn atenae wɔ wɔn frankaa ase. Yudafo ntuanoni ne Aminadab ba Nahson. ");
INSERT INTO twi_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Na ne dɔm no ano si mpem aduɔson anan ne ahansia (74,600). ");
INSERT INTO twi_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Isakar abusuakuw na wobedi so. Wɔn ntuanoni ne Suar babarima Netanel. ");
INSERT INTO twi_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Na ne dɔm no ano si mpem aduonum anan ne ahannan (54,400). ");
INSERT INTO twi_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Sebulon abusuakuw na wobedi so. Wɔn ntuanoni ne Helon babarima Eliab. ");
INSERT INTO twi_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Na ne dɔm no ano si mpem aduonum ason ne ahannan (57,400). ");
INSERT INTO twi_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Enti na nnipa dodow a wɔwɔ Yuda atenae no nyinaa sɛnea wɔn nkyekyɛmu te no ano si mpem ɔha aduɔwɔtwe asia ne ahannan (186,400). Sɛ Israelfo no tu a, saa mmusuakuw abiɛsa yi na edi kan. ");
INSERT INTO twi_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Anafo fam na Ruben nnipa nkyekyɛmu ahorow no nyinaa bɛbɔ wɔn atenae de wɔn frankaa asi. Wɔn ntuanoni ne Sedeur babarima Elisur. ");
INSERT INTO twi_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ne dɔm ano si mpem aduanan asia ne ahannum (46,500). ");
INSERT INTO twi_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Simeon abusuakuw na wobedi so. Wɔn ntuanoni ne Surisadai babarima Selumiel. ");
INSERT INTO twi_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ne dɔm ano si mpem aduonum akron ne ahaasa (59,300). ");
INSERT INTO twi_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Gad abusuakuw na wobedi so. Wɔn ntuanoni ne Reuel babarima Eliasaf. ");
INSERT INTO twi_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Na ne dɔm ano si mpem aduanan anum ahansia ne aduonum (45,650). ");
INSERT INTO twi_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Na mmarima a wɔwɔ Ruben atenae ne sɛnea wɔn nkyekyɛmu te no ano si mpem ɔha aduonum baako ahannan ne aduonum (151,450). Na sɛ Israelfo tu a, wɔn na wɔto so abien. ");
INSERT INTO twi_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Afei Lewifo no de Ahyiae Ntamadan befi wɔn atenae mfimfini hɔ akɔ. Mmusuakuw no nyinaa bɛkɔ no nnidiso sɛnea wɔn atenae nhyehyɛe te wɔ wɔn mmusuakuw mfrankaa akyi. ");
INSERT INTO twi_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Efraim abusuakuw bɛfa atenae hɔ atɔe fam adi wɔn abusua frankaa akyi. Wɔn ntuanoni ne Amihud babarima Elisama. ");
INSERT INTO twi_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ne dɔm ano si mpem aduanan ne ahannum (40,500). ");
INSERT INTO twi_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Manase abusuakuw na wobedi so. Wɔn ntuanoni ne Pedahsur babarima Gamaliel. ");
INSERT INTO twi_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ne dɔm ano si mpem aduasa abien ne ahannu (32,200). ");
INSERT INTO twi_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Benyamin abusuakuw na wodi so. Wɔn ntuanoni ne Gideoni babarima Abidan. ");
INSERT INTO twi_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ne dɔm ano si mpem aduasa anum ne ahannan (35,400). ");
INSERT INTO twi_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Na mmarima a wɔwɔ Efraim atenae ne sɛnea wɔn nkyekyɛmu te no ano si mpem ɔha ne awotwe ne ɔha baako (108,100). Na sɛ Israelfo tu a, wɔn na wɔto so abiɛsa. ");
INSERT INTO twi_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Dan abusuakuw bɛfa atifi fam adi wɔn abusua frankaa akyi. Wɔn ntuanoni ne Amisadai babarima Ahieser. ");
INSERT INTO twi_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ne dɔm ano si mpem aduosia abien ne ahanson (62,700). ");
INSERT INTO twi_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Aser abusuakuw no bedi so. Wɔn ntuanoni ne Okran babarima Pagiel. ");
INSERT INTO twi_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ne dɔm ano si mpem aduanan baako ne ahannum (41,500). ");
INSERT INTO twi_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Naftali abusuakuw no bedi so. Wɔn ntuanoni ne Enan ba Ahira. ");
INSERT INTO twi_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ne dɔm ano si mpem aduonum abiɛsa ne ahannan (53,400). ");
INSERT INTO twi_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Mmarima a wɔwɔ Dan atenae no ano si mpem ɔha aduonum ason ne ahansia (157,600). ");
INSERT INTO twi_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Sɛɛ na Israelfo a wɔkan wɔn mmusuakuw mmusuakuw no te. Wɔn a wɔwɔ atenae hɔ nyinaa, sɛnea wɔn nkyekyɛmu te no ano si mpem ahansia ne abiɛsa ahannum ne aduonum (603,550). ");
INSERT INTO twi_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Sɛnea Awurade hyɛɛ Mose no, wɔankan Lewifo no anka Israelfo no ho. ");
INSERT INTO twi_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Enti Israelfo yɛɛ biribiara sɛnea Awurade hyɛɛ Mose no. Wɔbobɔɔ wɔn atenae, tenatenaa wɔn frankaa ahorow ase, na wɔnantew nnidiso nnidiso sɛnea wɔn mmusua ne wɔn afi te. ");
INSERT INTO twi_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Eyi ne nea ɛfa Aaron ne Mose mmusua ho bere a Awurade kasa kyerɛɛ Mose wɔ Sinai Bepɔw so no. ");
INSERT INTO twi_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaron mmabarima din na edidi so yi: Nadab, nʼabakan, Abihu, Eleasar ne Itamar. ");
INSERT INTO twi_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Eyinom ne Aaron mma a wɔasra wɔn ngo na wɔayi wɔn asi hɔ sɛ asɔfo. ");
INSERT INTO twi_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab ne Abihu de, wowuwuu wɔ Awurade anim bere a wɔhyew afɔrebɔde wɔ ogya a ɛmfata so wɔ Sinai sare so no. Na wonni mma nti, Eleasar ne Itamar nko ara na wɔsom sɛ asɔfo, bere a wɔn agya Aaron te ase no. ");
INSERT INTO twi_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Awurade ka kyerɛɛ Mose se: ");
INSERT INTO twi_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Frɛ Lewifo no, na fa wɔn ma ɔsɔfo Aaron sɛ nʼaboafo. ");
INSERT INTO twi_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Wɔbɛyɛ adwuma wɔ Ahyiae Ntamadan no mu ama ɔsɔfo Aaron ne nnipa no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Afei, wɔbɛhwɛ nneɛma a wɔde siesie Ahyiae Ntamadan mu no so de asi Israelfo no anan mu ayɛ asodi a wɔyɛ wɔ Ahyiae Ntamadan no mu. ");
INSERT INTO twi_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Fa Lewifo no ma Aaron ne ne mmabarima; wɔn ne Israelfo a wɔde wɔn bɛma no korakora. ");
INSERT INTO twi_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ma Aaron ne ne mmabarima no nsom sɛ asɔfo; onipa foforo biara a ɔbɛbɛn kronkronbea hɔ no, ɛsɛ sɛ wokum no.” ");
INSERT INTO twi_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Mayi Lewifo no afi Israelfo no mu de wɔn asi Israel babea biara abakan a ɔyɛ ɔbarima anan mu. Lewifo no yɛ me de, ");
INSERT INTO twi_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","efisɛ abakan biara wɔ me. Bere a mikunkum mmakan wɔ Misraim no, migyaw Israel mmakan, sɛ wɔyɛ nnipa anaa mmoa. Wɔyɛ me dea. Mene Awurade.” ");
INSERT INTO twi_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Afei, Awurade ka kyerɛɛ Mose wɔ Sinai sare so se, ");
INSERT INTO twi_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Kan Lewifo no wɔ wɔn mmusua ne afi mu. Kan ɔbarima biara fi nea wadi ɔsram baako so.” ");
INSERT INTO twi_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Enti Mose kan wɔn sɛnea Awurade hyɛɛ no no. ");
INSERT INTO twi_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Eyinom ne Lewi mmabarima: Gerson, Kohat ne Merari. ");
INSERT INTO twi_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gerson asefo ni: Libni ne Simei. ");
INSERT INTO twi_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohat asefo: Amram, Ishar, Hebron ne Usiel. ");
INSERT INTO twi_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari asefo: Mahli ne Musi. Eyinom ne Lewifo, sɛnea wɔn mmusua ne wɔn afi te. ");
INSERT INTO twi_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gerson asefo no na wɔyɛ mmusua a wofi Libni ne Simei ase. ");
INSERT INTO twi_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Na Gersonfo mmarima a wɔadi ɔsram ne nea ɛboro saa a wofi Gerson mmusua mu no dodow yɛ mpem ahanson ne ahannum (7,500). ");
INSERT INTO twi_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Wɔn atenae wɔ Ahyiae Ntamadan no akyi wɔ atɔe fam. ");
INSERT INTO twi_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Na Gersonfo no ntuanoni ne Lael babarima Eliasaf. ");
INSERT INTO twi_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Saa mmusua abien yi na na wɔhwɛ Ahyiae Ntamadan no ne ne nkataho no ne ɔkwan nkataano no so. ");
INSERT INTO twi_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Afei, na wɔhwɛ adiwo nkataano a etwa Ahyiae Ntamadan no ho ne afɔremuka ne adiwo nkataano nhoma ne ɛhɔ nneɛma a wɔde di dwuma ahorow no nyinaa so. ");
INSERT INTO twi_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kohat asefo yɛ mmusua a wofi Amram, Ishar, Hebron ne Usiel ase. ");
INSERT INTO twi_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Na Kehat mmusua no mu mmarima a wɔadi ɔsram ne nea ɛboro saa no dodow yɛ mpem awotwe ne ahansia (8,600). Wɔn na na wɔhwɛ kronkronbea no so. ");
INSERT INTO twi_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Wɔmaa wɔn atenae wɔ Ahyiae Ntamadan no anafo fam. ");
INSERT INTO twi_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Na Kohatfo ntuanoni no ne Usiel babarima Elisafan. ");
INSERT INTO twi_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Saa mmusua anan yi na na wɔhwɛ apam adaka, ɔpon, kaneadua, afɔremuka ahorow, ne nea ɛkeka ho a na wɔde di dwuma wɔ kronkronbea hɔ, mfimfini ntwamtam ne nneɛma a wɔde di dwuma ahorow wɔ hɔ nyinaa no so. ");
INSERT INTO twi_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Aaron babarima ɔsɔfo Eleasar no na na ɔyɛ ɔpanyin wɔ Lewifo no nyinaa so. Ɔyɛɛ no panyin wɔ asɔfo a wɔhwɛ kronkronbea no so. ");
INSERT INTO twi_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Na Merari asefo no yɛ mmusua a wofi Mahli ne Musi ase. ");
INSERT INTO twi_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Merarifo mmusua no mu na mmarima a wɔadi ɔsram ne nea ɛboro saa no dodow yɛ mpem asia ne ahannu (6,200). ");
INSERT INTO twi_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merari abusua no ntuanoni ne Abihail babarima Suriel, na wɔtenaa Ahyiae Ntamadan no atifi fam. ");
INSERT INTO twi_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Dwumadi a wɔde hyɛɛ saa mmusuakuw abien yi nsa ne sɛ, wɔbɛhwɛ Ahyiae Ntamadan no nnyinaso so. Afei, wɔbɛhwɛ mmeamu nnua, mpuran, nsisiso ne ɛho nneɛma a wɔde di dwuma no nyinaa, ");
INSERT INTO twi_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ne mpuran a ɛwɔ adiwo hɔ nyinaa ne ne nsisiso, nnyinaso, ne ntampehama nyinaa, wɔbɛhwɛ so. ");
INSERT INTO twi_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ahyiae Ntamadan no apuei fam, nea owia pue fi no, wogyaw maa Mose ne Aaron ne ne mmabarima sɛ wonsisi wɔn ntamadan wɔ hɔ. Saa nnipa yi na na wosi Israelfo no anan mu di Ahyiae Ntamadan no ho dwuma nyinaa. Obi foforo biara a ɔbɛbɛn kronkronbea hɔ no, ɛsɛ sɛ wokum no. ");
INSERT INTO twi_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Lewifo a Awurade hyɛɛ Mose ne Aaron sɛ wɔnkan wɔn sɛnea wɔn mmusua te a ɔbarima biara a wɔadi ɔsram ne nea ɛboro saa ka ho no dodow yɛ mpem aduonu abien (22,000). ");
INSERT INTO twi_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Awurade ka kyerɛɛ Mose se, “Kan Israelfo mmakan a wɔyɛ mmarima na wɔadi ɔsram ne nea ɛboro saa no, na kyerɛw wɔn din. ");
INSERT INTO twi_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Lewifo no bɛyɛ me de. Ma wonsi Israelfo mmakan nyinaa anan mu, na Lewifo nyɛmmoa mmakan nsi Israelfo nyɛmmoa mmakan anan mu. Mene Awurade.” ");
INSERT INTO twi_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Enti Mose kan Israelfo mmakan nyinaa sɛnea Awurade hyɛɛ no no. ");
INSERT INTO twi_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Mmakan mmarima a wɔadi ɔsram ne nea ɛboro saa no a ɔkyerɛw wɔn din no ano si mpem aduonu abien ahannu ne aduɔson abiɛsa (22,273). ");
INSERT INTO twi_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Afei, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Ma Lewifo nsi Israelfo mmakan anan mu. Na Lewifo nyɛmmoa mmakan nso nsi Israelfo nyɛmmoa mmakan anan mu. Lewifo yɛ me dea. Mene Awurade. ");
INSERT INTO twi_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ansa na mubegye Israelfo mmakan ahannu aduɔson abiɛsa no a wɔboro Lewifo no dodow so no, ");
INSERT INTO twi_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","momma wontua ti ade, sɛnea hyiadan mu nnwetɛbona te, a emu duru yɛ gram aduonum nson. ");
INSERT INTO twi_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Fa ti ade sika no ma Aaron ne ne mma.” ");
INSERT INTO twi_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Enti Mose gyigyee Israelfo ahannu aduɔson abiɛsa a na wɔboro Lewifo no dodow so no ti ade. ");
INSERT INTO twi_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Sika a wogyigyee no nyinaa ano sii dwetɛ kilogram dunum ne fa. ");
INSERT INTO twi_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Na Mose de maa Aaron ne ne mmabarima sɛnea Awurade hyɛɛ no no. ");
INSERT INTO twi_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Awurade ka kyerɛɛ Mose ne Aaron se: ");
INSERT INTO twi_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Kan Kohatfo no dodow a wɔwɔ Lewifo no abusua mu. ");
INSERT INTO twi_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Saa nnipakan yi bɛyɛ mmarima nko ara a wɔadi fi mfe aduasa kosi aduonum a wobetumi ayɛ adwuma wɔ Ahyiae Ntamadan mu. ");
INSERT INTO twi_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Kohat mma no dwumadi ne sɛ wɔbɛhwɛ akronkronne no so wɔ Ahyiae Ntamadan no mu. ");
INSERT INTO twi_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Sɛ wɔretu afi atenae hɔ a, Aaron ne ne mma mmarima na wobedi kan akɔ Ahyiae Ntamadan no mu akɔfa nkataanim no de akata adaka no ho. ");
INSERT INTO twi_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Afei, wɔde abirekyi nhoma bɛkata nkataanim no ho na wɔde ntama tuntum akata abirekyi nhoma no ho na wɔde nnua a wɔde soa adaka no ahyehyɛ ne nkaa no mu. ");
INSERT INTO twi_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Afei, wɔmfa ntama tuntum nsɛw ɔpon a Daa Daa Brodo no da so no so; na wɔmfa mprɛte, nsanka, ne adidi nkankyee ne ɔnom afɔre nkuruwa no; brodo no ngu ntama no so ara. ");
INSERT INTO twi_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Wɔde ntama kɔkɔɔ bɛkata so na wɔasan de abirekyi nhoma akata ntama kɔkɔɔ no so. Na afei, wɔde nnua a wɔde bɛsoa no ahyehyɛ ɔpon no mu. ");
INSERT INTO twi_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Ɛsɛ sɛ wɔde ntama tuntum kata kaneadua no, akanea no, adabaw no, nkuku apampaa no ne ngo tumpan no ho. ");
INSERT INTO twi_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Saa nneɛma yi nyinaa nso wɔde abirekyi nhoma a ɛyɛ den bɛkata ho na wɔde nea wɔakyekyere no nyinaa abegu ɔpon no so. ");
INSERT INTO twi_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Ɛsɛ sɛ wɔde ntama tuntum kata sikakɔkɔɔ afɔremuka no so na wɔsan de abirekyi nhoma kata so bio na wɔde nnua a wɔde soa no hyehyɛ afɔremuka no mu. ");
INSERT INTO twi_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Hyiadan no mu som no ho nneɛma a aka no nyinaa, ɛsɛ sɛ wɔde ntama bibiri kyekyere ho a wɔde abirekyi nhoma asan akyekyere ho na wɔde ato mpata a wɔde soa no so. ");
INSERT INTO twi_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Ɛsɛ sɛ wotu nsõ no nyinaa fi afɔremuka no mu gu, na wɔde ntama kɔkɔɔ kyekyere ho. ");
INSERT INTO twi_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ɛsɛ sɛ wɔde afɔremuka no ho ɔsom nneɛma nyinaa gu ntama no so. Saa nneɛma no ne nkankyee a wɔnoa mu, adinam, sofi, ne nkankyee a wɔde nsu a wɔde pete gu mu. Ɛsɛ sɛ wɔde abirekyi nhoma kata ne nyinaa so na wɔde nnua a wɔde soa no gu faako a ɛsɛ sɛ wɔde gu. ");
INSERT INTO twi_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Sɛ Aaron ne ne mma mmarima no wie kronkronbea hɔ nneɛma no anoboa a, Kohat ne nʼabusuafo bɛba abɛsoa akɔ baabiara a wɔretu nneɛma akɔ. Nanso wonni ho kwan sɛ wɔde wɔn nsa ka nneɛma a ɛho tew no bi. Wɔyɛ saa a, wobewuwu. Ɛsɛ sɛ Kohat mmabarima no soa nneɛma a ɛwɔ Ahyiae Ntamadan no mu no. ");
INSERT INTO twi_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Aaron babarima Eleasar a ɔyɛ ɔsɔfo no na ɔbɛhwɛ ngo a wɔde bɛsɔ kanea, nnuhuam, daa aduan a wɔde bɔ afɔre, ɔsra ngo ne Ahyiae Ntamadan no nyinaa so. Biribiara a ɛwɔ Ahyiae Ntamadan no mu no nso, ɔbɛhwɛ so.” ");
INSERT INTO twi_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Afei, Awurade ka kyerɛɛ Mose ne Aaron se, ");
INSERT INTO twi_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Monhwɛ sɛ wɔrentwa Kohatfo abusuakuw no mfi Lewifo mu. ");
INSERT INTO twi_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Sɛ wɔresoa nneɛma a ɛho tew no a, nea ɛsɛ sɛ wɔyɛ a wɔrenwuwu ni: Ɛsɛ sɛ Aaron ne ne mma mmarima no ne wɔn kɔ hɔ kɔkyerɛ wɔn ade a ɛsɛ sɛ wɔn mu biara soa. ");
INSERT INTO twi_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ɛnsɛ sɛ Kohatfo no kɔ hɔ kɔhwɛ akronkronne no koraa, na wɔanwuwu.” ");
INSERT INTO twi_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Kan Gerson asefo a wɔfra Lewifo abusua mu no, ");
INSERT INTO twi_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","fi mmarima a wɔadi mfe aduasa kosi aduonum a wobetumi ayɛ adwuma kronkron wɔ Ahyiae Ntamadan mu hɔ no so. ");
INSERT INTO twi_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Gerson mmusua no dwuma a wobedi ni: ");
INSERT INTO twi_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Wɔbɛsoa ntama a etwa Ahyiae Ntamadan mu hɔ, Ahyiae Ntamadan no ankasa ne nea ɛkata ho, abirekyi nhoma nkuruso ne ntama a ɛsɛn Ahyiae Ntamadan no ano no. ");
INSERT INTO twi_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Afei, wɔbɛsoa nkataho a ɛkata adiwo hɔ fasu no ho no. Wɔbɛsoa ntama a etwa adiwo hɔ kwan no ano ne afɔremuka ne Ahyiae Ntamadan no ntam no. Wɔbɛsoa afɔremuka no, ntampehama ne nea ɛkeka ho nyinaa. Wɔn na ɛsɛ sɛ wɔhwɛ twe eyinom nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aaron anaa ne mmabarima no bi tumi ma Gerson asefo no bi dwuma di. ");
INSERT INTO twi_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Eyi ne Gersonfo no adwuma wɔ Ahyiae Ntamadan no mu. Ɛsɛ sɛ wodi Aaron ba Itamar a ɔyɛ ɔsɔfo no nan ase. ");
INSERT INTO twi_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Kan Merari asefo a wɔfra Lewifo abusua mu no. ");
INSERT INTO twi_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Kan mmarima a wɔadi mfe aduasa kosi aduonum so a wobetumi ayɛ adwuma wɔ Ahyiae Ntamadan mu hɔ. ");
INSERT INTO twi_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Sɛ wɔpagyaw Ahyiae Ntamadan no a, wɔn na ɛsɛ sɛ wɔsoa ne nnyinaso, nnua a esisi mu, ne nsisiso, ");
INSERT INTO twi_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","mpuran a wɔde yɛɛ adiwo hɔ afasu no ne ne nsisiso, nnyinaso, ntampehama ne biribiara a wɔde di ho dwuma. Fa dwumadi ahorow no hyɛ nnipa a wobɛbobɔ wɔn din no nsa. ");
INSERT INTO twi_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Merari asefo no, Aaron babarima Itamar na ɔbɛhwɛ wɔn so.” ");
INSERT INTO twi_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Enti Mose ne Aaron ne mpanyimfo no bi kɔkan Kohatfo ");
INSERT INTO twi_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","a mmarima a wɔadi mfe aduasa kosi aduonum nyinaa a wobetumi ayɛ Ahyiae Ntamadan mu adwuma ka ho, ");
INSERT INTO twi_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","na wohuu sɛ wɔn nyinaa dodow yɛ mpem abien ne ahanson aduonum. ");
INSERT INTO twi_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Eyinom ne Kohat asefo dodow a na wɔsom wɔ Ahyiae Ntamadan no mu Wɔyɛɛ eyinom nyinaa de dii Awurade ahyɛde a ɔmaa Mose no so. ");
INSERT INTO twi_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Wɔkan Gersonfo no mmusua ne wɔn mmusuakuw. ");
INSERT INTO twi_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Wɔkan mmarima a wɔadi mfe aduasa kosi aduonum a wobetumi ayɛ adwuma wɔ Ahyiae Ntamadan no mu. ");
INSERT INTO twi_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Wɔn nyinaa dodow yɛɛ mpem abien ahansia ne aduasa. ");
INSERT INTO twi_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Enti na Gersonfo a wɔfata sɛ wɔsom wɔ Ahyiae Ntamadan no mu no nyinaa dodow ne no. Mose ne Aaron na wɔkan wɔn sɛnea Awurade hyɛɛ wɔn no. ");
INSERT INTO twi_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Merarifo no nso, wɔkan wɔn mmusua ne wɔn mmusuakuw. ");
INSERT INTO twi_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Wɔkan wɔn mmarima a wɔadi mfe aduasa kosi aduonum a wɔfata sɛ wɔyɛ adwuma wɔ Ahyiae Ntamadan no mu. ");
INSERT INTO twi_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Wɔn nyinaa dodow yɛɛ mpem abiɛsa ne ahannu. ");
INSERT INTO twi_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Enti Merarifo a wɔfata sɛ wɔsom wɔ Ahyiae Ntamadan no mu no nyinaa dodow ne no. Mose ne Aaron na wɔkan wɔn sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Enti Mose ne Aaron ne Israel mpanyimfo nam Lewifo no mmusua ne wɔn afi so kan wɔn nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Mmarima a na wɔadi fi mfe aduasa kosi mfe aduonum no nyinaa a na wɔfata sɛ wɔyɛ adwuma wɔ Ahyiae Ntamadan no mu hɔ no ne wɔn a wɔbɛsoa akɔ no ");
INSERT INTO twi_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","dodow yɛ mpem ahanwɔtwe ahannum ne aduɔwɔtwe. ");
INSERT INTO twi_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Awurade hyɛ a ɔhyɛɛ Mose no nti na wɔnam so kan nnipa no. ");
INSERT INTO twi_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Eyi ne mmara a Awurade san hyɛ maa Mose: ");
INSERT INTO twi_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Ka kyerɛ Israelfo no se, ɛsɛ sɛ wɔpam akwatafo nyinaa fi atenae hɔ. Wɔn a kuru atutu wɔn ne wɔn a wɔde wɔn nsa akɔka funu nti wɔn ho agu fi nyinaa no, ɛsɛ sɛ wɔpam wɔn. ");
INSERT INTO twi_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Mmarima ne mmea nyinaa ka ho. Yi wɔn nyinaa fi hɔ, sɛnea ɛbɛyɛ na atenae a me ne mo bɛtena no ho rengu fi.” ");
INSERT INTO twi_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Wodii Awurade mmara no so. ");
INSERT INTO twi_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Afei, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Ka kyerɛ Israelfo no se, sɛ ɔbarima o, ɔbea o, odi Awurade huammɔ a, ɛyɛ bɔne. ");
INSERT INTO twi_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Ɛsɛ sɛ ɔka ne bɔne na ade a owiae no, otua ho ka nyinaa na ɔsan de ɛho ka no nkyɛmu ɔha mu aduonu ka ho de ma onipa ko a ɔbɔɔ no korɔn no. ");
INSERT INTO twi_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Na sɛ onipa ko a wɔyɛɛ no bɔne no awu na onni obusuani biara a ɔbɛn no a wobetua ho ka ama no, na ɛsɛ sɛ wotua ma ɔsɔfo a, ɛsɛ sɛ wɔde odwennini ka ho sɛ mpatade. Ɛyɛ Awurade de. ");
INSERT INTO twi_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Akyɛde kronkron a Israelfo de bɛkyɛ ɔsɔfo no yɛ ne de. ");
INSERT INTO twi_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ɔsɔfo biara bɛfa akyɛde kronkron biara a ne nsa bɛka.” ");
INSERT INTO twi_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Ka kyerɛ Israelfo no se, sɛ ɔbarima bi yere kɔbɔ aguaman ");
INSERT INTO twi_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","nanso onhu asɛm no mu nokware na onya ɔdanseni ");
INSERT INTO twi_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","na ɔtwe ho ninkunu na ɔnte ne ho ase a, ");
INSERT INTO twi_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ɔbarima no de ne yere no bɛkɔ ɔsɔfo anim a ɔbea no ho afɔrebɔde a ɛyɛ atokosiam a wɔmfaa ohuam ngo mfrae lita abien ka ho. Efisɛ ɛyɛ ninkutwe afɔrebɔ. Ɛno na ɛbɛma nokware ada adi ama wɔahu sɛ ɔbea no di fɔ anaa odi bem. ");
INSERT INTO twi_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Ɔsɔfo no de ɔbea no bɛba Awurade anim, ");
INSERT INTO twi_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","na wasaw Ahyiae Ntamadan no mu mfutuma de afra nsu kronkron a egu asuhina kɛse bi mu no. ");
INSERT INTO twi_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ɔbɛsan ne ti a wakyekyere no na ɔde ninkunu afɔrebɔde no agu ne nsam de ahwɛ sɛ ɔbarima no nsusuwii no yɛ nokware ampa ara anaasɛ ɛnyɛ nokware. Ɔsɔfo no begyina nʼanim a okura nsu nwenweenwen a ɛde mmusu ba no. ");
INSERT INTO twi_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","22","Ɔbɛma no aka ntam sɛ onnim asɛm no ho hwee na waka akyerɛ no se, sɛ wo ne ɔbarima biara nnae ka wo kunu nko ara ho de a, ɛno de, wo ho ntew mfi nsu nwenweenwen a ɛde mmusu ba yi ho. Na sɛ woabɔ aguaman a, ɛno de, Awurade bɛdome wo wɔ wo nkurɔfo mu. Ɔbɛma wo srɛ aporɔw na wo yafunu ahon. Na ɔbea no bɛka se, ‘Yiw, saa na ɛsɛ sɛ ɛba.’ ");
INSERT INTO twi_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Ɔsɔfo no bɛkyerɛw nnome yi nyinaa agu nhoma bi mu na wahohoro agu nsu nwenweenwen no mu. ");
INSERT INTO twi_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Sɛ ɛsɛ sɛ ɔbea no nom nsu no na sɛ ɔnom wɔ bere a wayɛ bɔne a, ɛyɛ nwenweenwen wɔ ne mu. ");
INSERT INTO twi_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Afei, ɔsɔfo no begye ninkunu afɔrebɔde no afi ɔbea no nsam na wahinhim wɔ Awurade anim na ɔde akɔ afɔremuka no so. ");
INSERT INTO twi_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Ɔbɛsaw ne nsa ma de asi ne nyinaa anan na wahyew no wɔ afɔremuka no so na wama ɔbea no anom nsu no. ");
INSERT INTO twi_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Sɛ ne ho agu fi na wabɔ aguaman atia ne kunu a, nsu a wanom no bɛyɛ nwenweenwen wɔ ne mu na ne yafunu ahon na ne srɛ aporɔw na wayɛ nnome wɔ ne nkurɔfo mu. ");
INSERT INTO twi_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Sɛ ɔyɛ kronkron a ɔmmɔɔ aguaman a, wɔrenhaw no, na ɛrenkyɛ, obenyinsɛn. ");
INSERT INTO twi_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Eyi ne mmara a ɛfa ɔbea a ne bra nye na ne kunu twe ne ho ninkunu ");
INSERT INTO twi_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","de hwehwɛ mu hu sɛ odi ne kunu nokware anaa onni no nokware no ho. Ɔde no bɛba Awurade anim na ɔsɔfo no adi dwuma a wɔabobɔ so no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Wɔrenni ne kunu no asɛm wɔ baabiara sɛ wama ɔyare bɔne bi aba ne yere so, efisɛ ɛyɛ ɔno ara na ɔma ɛbaa saa.” ");
INSERT INTO twi_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Awurade san ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Ka kyerɛ Israelfo no se, sɛ ɔbarima anaa ɔbea kɔyɛ Nasareni de tew ne ho wɔ Awurade anim a, ");
INSERT INTO twi_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ɛno akyi, saa bere a ɔwɔ ahotew no mu no, onni ho kwan sɛ ɔnom nsa a ɛyɛ den anaa bobesa anaa nsa a emu kaw. ");
INSERT INTO twi_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Saa bere no mu no, onni ho kwan sɛ odi biribiara a efi bobe mu, sɛ ɛyɛ nʼaba anaa ne hono. ");
INSERT INTO twi_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Saa bere no mu no, ɛnsɛ sɛ oyi ne tinwi, efisɛ ɔyɛ kronkron na wɔatew ne ho ama Awurade; ɛno nti na ɛsɛ sɛ ɔma ne tinwi fuw no. ");
INSERT INTO twi_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“Ne bɔhyɛ no nna no mu a watew ne ho ama Awurade no, onni ho kwan sɛ ɔkɔ owufo ho. ");
INSERT INTO twi_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Sɛ owufo no yɛ nʼagya, ne na, ne nuabarima anaa ne nuabea koraa a, ɔnnkɔ ne ho, efisɛ ɔda so hyɛ ne bɔ a ɔhyɛ de tew ne ho maa Onyankopɔn no ase. ");
INSERT INTO twi_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Saa bere no mu nyinaa, wɔatew ne ho ama Awurade. ");
INSERT INTO twi_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Sɛ obi wu tɔ ne nkyɛn de gu ne ho fi a, nnanson akyi no, ɛsɛ sɛ oyi ne tinwi a ɛho agu fi no. Afei, wobedwira ne ho afi fi a owufo no de aka no no ho. ");
INSERT INTO twi_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Nʼadekyee a ɛyɛ da a ɛto so awotwe no, ɛsɛ sɛ ɔde nturukuku abien anaa mmorɔnoma mma abien brɛ ɔsɔfo wɔ Ahyiae Ntamadan no kwan ano. ");
INSERT INTO twi_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ɔsɔfo no de nnomaa no mu baako bɛbɔ bɔne ho afɔre na ɔde ɔbaako abɔ ɔhyew afɔre, na ayɛ mpata ama nea ne ho agu fi no. Na da no ara, ɛsɛ sɛ oti ne bɔhyɛ mu na ɔsan ma ne tinwi no fuw bio. ");
INSERT INTO twi_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Nna dodow a odii wɔ ne bɔhyɛ a edi kan no mu no nyinaa ahyew agu. Ɔbɛhyɛ Awurade bɔ foforo de afi ase, na ɔde odwennini ba a wadi afe bɛba abɛbɔ afɔdi ho afɔre. ");
INSERT INTO twi_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Da a ne bɔhyɛ a ɛtew ɔno ne Awurade ntam no wie du no, ɛsɛ sɛ ɔkɔ Ahyiae Ntamadan no ano. ");
INSERT INTO twi_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Ɛhɔ na ɔbɛbɔ ɔhyew afɔre ama Awurade. Ɔde oguan ba a wadi afe a onnii dɛm na ɛbɛbɔ saa afɔre no. Ɛsɛ sɛ ɔde oguammere a wadi afe a onnii dɛm bɔ bɔne ho afɔre na ɔde odwennini a onnii dɛm bɔ asomdwoe afɔre. ");
INSERT INTO twi_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Nneɛma a ɔde bɛka ho no ne brodo a mmɔkaw mfra mu, asikresiam tetare a wɔde ngo afra; brodo ntrantraa bi a mmɔkaw mfra mu a wɔde ngo ayɛ so a aduan ne nsa afɔrebɔde ka ho. ");
INSERT INTO twi_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Ɛsɛ sɛ Ɔsɔfo no de saa afɔrebɔde yi nyinaa ba Awurade anim na wabɛbɔ bɔne ho afɔre ne ɔhyew afɔre. ");
INSERT INTO twi_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ɛsɛ sɛ ɔde odwennini a wɔde no bɛbɔ asomdwoe afɔre a brodo kɛntɛnma a mmɔkaw nni mu nso ka ho na ɔde abɛbɔ aduan ne nsa afɔre. ");
INSERT INTO twi_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Afei, ɔhotuafo no beyi ne tinwi a afuw kuhaa no; ɛno ne nsɛnkyerɛnne a ɛkyerɛ sɛ ɔnhyɛ bɔhyɛ no ase bio. Wɔbɛyɛ eyi wɔ Ahyiae Ntamadan no ano, na wɔde nwi no agu asomdwoe afɔre a wɔrebɔ no wɔ gya mu no ahyew no. ");
INSERT INTO twi_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Wɔayi ɔbarima no tinwi no awie no, ɔsɔfo no de odwennini no basa a wɔatoto tetare a mmɔkaw nni mu no baako ne brodo ntrantraa a mmɔkaw nni mu bɛhyɛ ɔbarima no nsam. ");
INSERT INTO twi_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Ɔsɔfo no behim akɔ nʼanim aba nʼakyi wɔ Awurade anim a ɛkyerɛ ma a ɔde rema Awurade. Ne nyinaa yɛ kyɛfa a ɛho tew ma ɔsɔfo no. Wɔbɛyɛ no sɛnea wɔyɛ odwennini no basa mu mfe mparow a wohim no wɔ Awurade anim no. Eyi akyi no, ɔhotuafo no tumi nom bobesa a ɛkyerɛ sɛ wɔayi no afi ne bɔhyɛ no mu. ");
INSERT INTO twi_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Eyinom ne mmara a ɛda hɔ ma Nasareni a wahyɛ nʼahofama ho bɔ awie, na ɔde afɔrebɔ ahorow brɛ Awurade. Saa afɔrebɔ yi akyi no, otumi de afɔrebɔde biara a ɔrebɛyɛ Nasareni no, ɔhyɛɛ ho bɔ sɛ ɔde bɛba no ba.” ");
INSERT INTO twi_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Afei, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Ka kyerɛ Aaron ne ne mmabarima no se, ɛsɛ sɛ wohyira Israelfo yi sononko sɛ: ");
INSERT INTO twi_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Awurade nhyira mo na ɔnhwɛ mo so. ");
INSERT INTO twi_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Awurade ntew nʼanim nkyerɛ mo na ɔnnom mo. ");
INSERT INTO twi_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Awurade mma nʼani so nhwɛ mo na ɔmma mo asomdwoe.’ ");
INSERT INTO twi_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Saa na ɛsɛ sɛ Aaron ne ne mmabarima hyira Israelfo, na mʼankasa nso mehyira wɔn.” ");
INSERT INTO twi_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Da a Mose wiee Ahyiae Ntamadan no hyehyɛ no, ɔsraa ho nyinaa ngo, tew mu nneɛma nyinaa ho. Ɔsan sraa afɔremuka ne ho nkuku ne nkaka nyinaa ngo, tew ho nso. ");
INSERT INTO twi_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Afei, Israel mpanyimfo ne mmusuakuw no mu mpanyin a wɔhwɛɛ nnipakan no so no nyinaa de wɔn afɔrebɔde bae. ");
INSERT INTO twi_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Wɔde nteaseɛnam asia a wɔakatakata ho ne anantwi dumien na ɛbae. Na nteaseɛnam no baako biara yɛ mpanyimfo baanu de, a nantwi baako yɛ wɔn mu biara de. Wɔde ne nyinaa maa Awurade wɔ Ahyiae Ntamadan no anim. ");
INSERT INTO twi_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Gye wɔn akyɛde no na fa nteaseɛnam no yɛ Ahyiae Ntamadan no ho adwuma. Fa ma Lewifo no na obiara mfa nni dwuma biara a ɛsɛ sɛ odi.” ");
INSERT INTO twi_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Enti Mose de nteaseɛnam no ne anantwi no maa Lewifo no. ");
INSERT INTO twi_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ɔmaa Gerson ne ne nkurɔfo nteaseɛnam abien ne anantwi anan sɛnea na ehia ma wɔn dwumadi, ");
INSERT INTO twi_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","na ɔmaa Merari ne ne nkurɔfo nso nteaseɛnam anan ne anantwi awotwe a Aaron babarima Itamar na na odi so panyin. ");
INSERT INTO twi_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Wɔamma Kohat nkurɔfo nteaseɛnam no bi, efisɛ na ɛsɛ sɛ wɔsoa wɔn kyɛfa a ɛfa Ahyiae Ntamadan no ho nneɛma no ho no wɔ wɔn mmati so. ");
INSERT INTO twi_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Mpanyimfo a wodi anim no nso de nsrabɔ akyɛde beguu afɔremuka no anim da a wɔresra afɔremuka no ngo no. ");
INSERT INTO twi_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Awurade ka kyerɛɛ Mose se, “Kyekyɛ nna a obiara de nʼafɔrebɔde bɛba afɔremuka no so.” ");
INSERT INTO twi_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Aminadab babarima Nahson a ofi Yuda abusuakuw mu na ɔde nʼafɔrebɔde baa da a edi kan no. ");
INSERT INTO twi_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Nneɛma a ɔde bae no yɛ: dwetɛ prɛte baako a emu duru yɛ kilogram baako ne fa, dwetɛ kuruwa kɛse bi a ɛbɛyɛ kilogram baako a ne nyinaa na wɔde asikresiam muhumuhu a wɔde ngo afra ahyɛ no amaama; ");
INSERT INTO twi_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","sikakɔkɔɔ adaka baako a ɛkari gram ɔha ne dunan (114) a wɔde aduhuam ahyɛ no ma; ");
INSERT INTO twi_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ɔde nantwinini ba, odwennini ne oguamma a wadi afe bae sɛ ɔhyew afɔrebɔde. ");
INSERT INTO twi_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Wɔde ɔpapo bae sɛ bɔne ho afɔrebɔde ");
INSERT INTO twi_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ne anantwi abien, adwennini anum, mmirekyi anum ne nguantenmma a wɔn mu biara adi afe, anum bae sɛ wɔn asomdwoe afɔrebɔde. Eyi ne Nahson, Aminadab ba afɔrebɔde. ");
INSERT INTO twi_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Da a ɛto so abien no, Suar babarima Netanel a ɔda Isakar abusuakuw ano no de nʼafɔrebɔde bae. ");
INSERT INTO twi_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Na nʼafɔrebɔde no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ hweaseammɔ a emu duru yɛ kilogram baako a wɔde atoko afɔrebɔde a ɛyɛ asikresiam muhumuhu a wɔde ngo afra ahyehyɛ no amaama. ");
INSERT INTO twi_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Sikakɔkɔɔ nnwetɛbona baako a ɛkari gram ɔha ne dunan (114) a wɔde aduhuam ahyɛ no ma; ");
INSERT INTO twi_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","nantwi ba, odwennini ne oguamma a wɔadi afe bae sɛ ɔhyew afɔre, ");
INSERT INTO twi_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ɔpapo sɛ bɔne ho afɔre ");
INSERT INTO twi_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ne anantwi abien, adwennini anum, mpapo anum ne nguantenmma anum a wɔn mu biara adi afe sɛ asomdwoe afɔre. Eyi ne afɔre a Suar babarima Netanel de bae. ");
INSERT INTO twi_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ne nnansa so no, Helon babarima Eliab a ɔda Sebulon abusuakuw ano no de nʼafɔrebɔde bae. ");
INSERT INTO twi_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Na nʼafɔrebɔde no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ hweaseammɔ a emu duru yɛ kilogram baako. Na wɔde atoko afɔrebɔde a ɛyɛ asikresiam a wɔayam no muhumuhu a wɔde ngo afra ahyɛ no amaama; ");
INSERT INTO twi_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","sikakɔkɔɔ akorade a emu duru yɛ gram ɔha ne dunan (114) a wɔde aduhuam ahyɛ no ma; ");
INSERT INTO twi_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","nantwi ba, odwennini ne oguamma a wɔadi afe bae sɛ ɔhyew afɔre, ");
INSERT INTO twi_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ɔpapo sɛ bɔne ho afɔre ");
INSERT INTO twi_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ne anantwi abien, adwennini anum ne mpapo anum sɛ asomdwoe afɔre. Eyi ne afɔre a Helon babarima Eliab de bae. ");
INSERT INTO twi_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ne nnaanan so no, Sedeur babarima Elisur a ɔda Ruben abusuakuw ano no de nʼafɔrebɔde bae. ");
INSERT INTO twi_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Na nʼafɔrebɔde no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa. Na wɔde atoko afɔrebɔde a ɛyɛ asikresiam a wɔayam no muhumuhu a wɔde ngo afra ahyɛ no amaama. ");
INSERT INTO twi_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Sikakɔkɔɔ akorade a emu duru yɛ gram ɔha ne dunan (114) a wɔde aduhuam ahyɛ no ma. ");
INSERT INTO twi_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Nantwi ba, odwennini ne oguamma onini a wadi afe bae sɛ ɔhyew afɔre, ");
INSERT INTO twi_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ɔpapo sɛ bɔne ho afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ne anantwi abien, adwennini anum, mpapo anum ne nguantenmma anum a wɔn mu biara adi afe. Eyi ne afɔre a Sedeur babarima Elisur de bae. ");
INSERT INTO twi_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ne nnaanum so no, Surisadai babarima Selumiel a ɔda Simeon abusuakuw ano no de nʼafɔrebɔde bae. ");
INSERT INTO twi_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Na nʼafɔrebɔde no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ hweaseammɔ a emu duru yɛ kilogram baako na wɔde atoko afɔrebɔde a ɛyɛ asikresiam a wɔayam no muhumuhu a wɔde ngo afra ahyɛ no amaama; ");
INSERT INTO twi_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","sikakɔkɔɔ akorade a emu duru yɛ gram ɔha ne dunan (114) a wɔde aduhuam ahyɛ no ma; ");
INSERT INTO twi_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","nantwi ba, odwennini ne oguamma onini a wɔadi afe bae sɛ ɔhyew afɔre, ");
INSERT INTO twi_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ɔpapo sɛ bɔne ho afɔre, ");
INSERT INTO twi_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ne anantwi abien, adwennini anum, mpapo anum ne nguantenmma anum a wɔn mu biara adi afe sɛ asomdwoe afɔre bae. Eyi ne afɔre a Surisadai ba Selumiel de bae. ");
INSERT INTO twi_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ne nnansia so no, Deguel babarima Eliasaf a ɔda Gad abusuakuw ano no de nʼafɔrebɔde bae. ");
INSERT INTO twi_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Na nʼafɔrebɔde no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ hweaseammɔ a emu duru yɛ kilogram baako a wɔde atoko afɔrebɔde a ɛyɛ asikresiam muhumuhu a wɔde ngo afra ahyehyɛ no amaama; ");
INSERT INTO twi_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","sikakɔkɔɔ akorade bi a ɛkari gram ɔha ne dunan (114) a wɔde aduhuam ahyɛ no ma; ");
INSERT INTO twi_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","nantwi ba, odwennini ne oguamma a wadi afe bae sɛ ɔhyew afɔre, ");
INSERT INTO twi_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ɔpapo sɛ bɔne ho afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","anantwi abien, adwennini anum, mpapo anum ne nguantenmma anum a wɔn mu biara adi afe sɛ asomdwoe afɔre. Eyi ne afɔre a Deguel ba Eliasaf de bae. ");
INSERT INTO twi_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ne nnanson so no, Amihud babarima Elisama a ɔda Efraim abusuakuw ano no de nʼafɔrebɔde bae. ");
INSERT INTO twi_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Na nʼafɔrebɔde no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ hweaseammɔ a emu duru yɛ kilogram baako. Na wɔde atoko afɔrebɔde a ɛyɛ asikresiam muhumuhu a wɔde ngo afra ahyehyɛ no amaama; ");
INSERT INTO twi_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","sikakɔkɔɔ akorade a ɛkari gram ɔha ne dunan (114) a wɔde aduhuam ahyɛ no ma; ");
INSERT INTO twi_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","nantwi ba, odwennini ne oguamma a wadi afe bae sɛ ɔhyew afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ɔpapo sɛ bɔne ho afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ne anantwi abien, adwennini anum, mpapo anum ne nguantenmma anum a wɔn mu biara adi afe sɛ asomdwoe afɔre. Eyi ne afɔre a Amihud babarima Elisama de bae. ");
INSERT INTO twi_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ne nnaawɔtwe so no, Pedahsur babarima Gamaliel a ɔda Manase abusuakuw ano no de nʼafɔrebɔde bae. ");
INSERT INTO twi_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Na nʼafɔrebɔde no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ hweaseammɔ a emu duru yɛ kilogram baako. Na wɔde atoko afɔrebɔde a ɛyɛ asikresiam muhumuhu a wɔde ngo afra ahyehyɛ no amaama; ");
INSERT INTO twi_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","sikakɔkɔɔ akorade bi a ɛkari nnwetɛbona du a wɔde aduhuam ahyɛ no ma; ");
INSERT INTO twi_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","nantwi ba, odwennini ne oguamma a wadi afe bae sɛ ɔhyew afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ɔpapo sɛ bɔne ho afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ne anantwi abien, adwennini anum, mpapo anum ne nguantenmma anum a wɔn mu biara adi afe sɛ asomdwoe afɔre. Eyi ne afɔre a Pedahsur ba Gamaliel de bae. ");
INSERT INTO twi_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ne nnankron so no, Gideoni babarima Abidan a ɔda Benyamin abusuakuw ano no de nʼafɔrebɔde bae. ");
INSERT INTO twi_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Na nʼafɔrebɔde no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ hweaseammɔ a emu duru yɛ kilogram baako. Na wɔde atoko afɔrebɔde a ɛyɛ asikresiam muhumuhu a wɔde ngo afra ahyehyɛ no amaama; ");
INSERT INTO twi_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","sikakɔkɔɔ akorade a ɛkari gram ɔha ne dunan (114) a wɔde aduhuam ahyɛ no ma; ");
INSERT INTO twi_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","nantwi ba, odwennini ne oguamma a wadi afe bae sɛ ɔhyew afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ɔpapo sɛ bɔne ho afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ne nantwi abien, adwennini anum, mpapo anum ne nguantenmma anum a wɔn mu biara adi afe sɛ asomdwoe afɔre. Eyi ne afɔre a Gideoni babarima Abidan de bae. ");
INSERT INTO twi_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ne nnadu so no, Amisadai babarima Ahieser a ɔda Dan abusuakuw ano no de nʼafɔrebɔde bae. ");
INSERT INTO twi_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Na nʼafɔrebɔde no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ hweaseammɔ a emu duru yɛ kilogram baako. Na wɔde atoko afɔrebɔde a ɛyɛ asikresiam a wɔayam no muhumuhu a wɔde ngo afra ahyehyɛ no amaama; ");
INSERT INTO twi_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","sikakɔkɔɔ akorade a ɛkari gram ɔha ne dunan (114) a wɔde aduhuam ahyɛ no ma; ");
INSERT INTO twi_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","nantwi ba, odwennini ne oguamma onini a wadi afe bae sɛ ɔhyew afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ɔpapo sɛ bɔne ho afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ne anantwi abien, adwennini anum, mpapo anum ne nguantenmma anum a wɔn mu biara adi afe sɛ asomdwoe afɔre. Eyi ne afɔre a Amisadai babarima Ahieser de bae. ");
INSERT INTO twi_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ne nna dubaako so no, Okran babarima Pagiel a ɔda Aser abusuakuw ano no de nʼafɔrebɔde bae. ");
INSERT INTO twi_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Na nʼafɔrebɔde no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ hweaseammɔ a emu duru yɛ kilogram baako. Na wɔde atoko afɔrebɔde a ɛyɛ asikresiam a wɔayam no muhumuhu a wɔde ngo afra ahyehyɛ no amaama; ");
INSERT INTO twi_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","sikakɔkɔɔ akorade a ɛkari gram ɔha ne dunan (114) a wɔde aduhuam ahyɛ no ma; ");
INSERT INTO twi_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","nantwi ba, odwennini ne oguamma onini a wadi afe bae sɛ ɔhyew afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ɔpapo sɛ bɔne ho afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ne anantwi abien, adwennini anum, mmirekyinini anum ne nguantenmma anum a wɔn mu biara adi afe sɛ asomdwoe afɔre. Eyi ne afɔre a Okran babarima Pagiel de bae. ");
INSERT INTO twi_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ne nnadumien so no, Enan babarima Ahira a ɔda Naftali abusuakuw ano no de nʼafɔrebɔde bae. ");
INSERT INTO twi_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Na nʼafɔrebɔde no yɛ: dwetɛ prɛte a ɛyɛ kilogram baako ne fa ne dwetɛ hweaseammɔ a emu duru yɛ kilogram baako. Na wɔde atoko afɔrebɔde a ɛyɛ asikresiam a wɔayam no muhumuhu a wɔde ngo afra ahyehyɛ no amaama; ");
INSERT INTO twi_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","sikakɔkɔɔ akorade a ɛkari gram ɔha ne dunan (114) a wɔde aduhuam ahyɛ no ma; ");
INSERT INTO twi_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","nantwi ba, odwennini ne oguamma onini a wadi afe bae sɛ ɔhyew afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ɔpapo sɛ bɔne ho afɔre; ");
INSERT INTO twi_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ne anantwi abien, adwennini anum, mpapo anum ne nguantenmma anum a wɔn mu biara adi afe sɛ asomdwoe afɔre. Eyi ne afɔre a Enan babarima Ahira de bae. ");
INSERT INTO twi_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Eyinom ne afɔremuka no afɔrebɔde a Israel mpanyimfo de ba bɛsraa afɔremuka no, nam so bɔɔ no atenase: dwetɛ mprɛte dumien, dwetɛ hweaseammɔ dumien ne sikakɔkɔɔ aduhuam nnwetɛbona dumien. ");
INSERT INTO twi_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ne nyinaa mu, na dwetɛ nneɛma no kari bɛyɛ kilogram aduasa, na prɛte biara kari bɛyɛ kilogram baako ne fa, na hweaseammɔ no nso mu duru yɛ kilogram baako. ");
INSERT INTO twi_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Sikakɔkɔɔ a wɔde bɛkyɛe no mu duru yɛɛ bɛyɛ kilogram baako ne fa a ɛkyerɛ sɛ, sikakɔkɔɔ no akorade no mu biara duru yɛ nnwetɛbona du a wɔde aduhuam ahyɛ no ma. ");
INSERT INTO twi_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Wɔde anantwi dumien ne adwennini a wɔn mu biara adi afe na ɛbɛbɔɔ ɔhyew afɔre no a atoko afɔrebɔ nso ka ho. Wɔde mpapo bɛbɔɔ bɔne ho afɔre. ");
INSERT INTO twi_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Asomdwoe afɔre nneɛma a wɔde bae ni: nantwininimma aduonu anan, adwennini aduosia, mmirekyi aduosia, adwennini a wɔn mu biara adi afe aduosia. ");
INSERT INTO twi_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Bere a Mose kɔɔ Ahyiae Ntamadan no mu sɛ ɔne Awurade rekɔkasa no, ɔtee nne bi fi soro a ɛrekasa kyerɛ no fi Mpata Beae no atifi hɔ, wɔ adaka no ho baabi a kerubim abien no sisi no ntam. Awurade faa saa kwan yi so kasa kyerɛɛ no. ");
INSERT INTO twi_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Ka kyerɛ Aaron se, ‘Sɛ wosɔ akanea ason a ɛwɔ kaneadua no so no a, sɔ no sɛnea ɛbɛyɛ a, ɛbɛtow ne hann no akɔ kaneadua no nʼanim.’ ” ");
INSERT INTO twi_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaron yɛɛ saa; ɔsɔɔ akanea no ma ɛtow hann kɔɔ kaneadua no anim, sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Sɛnea Wosi yɛɛ kaneadua no ni: Sikakɔkɔɔ a wɔaboro na wɔde yɛ fii nʼase kosi ne soro. Wɔyɛɛ no sɛnea Awurade kyerɛɛ Mose sɛ wɔnyɛ no ara pɛ. ");
INSERT INTO twi_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Na Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Yi Lewifo no fi Israelfo no mu na tew wɔn ho. ");
INSERT INTO twi_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Sɛ ɛbɛyɛ a wɔn ho ni yɛ eyi: Fa ahodwira nsu pete wɔn so. Ma wonyi wɔn ho nwi nyinaa, na wɔnhoro wɔn nneɛma nyinaa, na ama wɔn ho atew. ");
INSERT INTO twi_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Afei, ma wɔmfa nantwinini ba ne aduan afɔrebɔde a ɛyɛ asikresiam a wɔayam no muhumuhu a wɔde ngo afra a nantwinini ba baako ka ho a wɔde no bɛbɔ bɔne ho afɔre mmra. ");
INSERT INTO twi_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Frɛ Israelfo no nyinaa hyia na fa Lewifo no bra Ahyiae Ntamadan no pon ano. ");
INSERT INTO twi_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ɛhɔ na mpanyimfo a wotuatua mmusuakuw no ano no de wɔn nsa begu wɔn so. ");
INSERT INTO twi_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Ɛsɛ sɛ Aaron yɛ nsɛnkyerɛnne bi sɛ ɔde wɔn rema Awurade sɛ akyɛde a efi Israel manfo nyinaa nkyɛn, na asiesie Lewifo no ama wɔayɛ Awurade adwuma. ");
INSERT INTO twi_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Afei, Lewifo mpanyimfo no de wɔn nsa begu nantwimma no apampam na wɔde wɔn ama Awurade. Wɔde ɔbaako bɛbɔ bɔne ho afɔre na wɔde ɔbaako nso abɔ ɔhyew afɔre de ayɛ mpata ama Lewifo no. ");
INSERT INTO twi_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Afei, wɔde Lewifo no bɛma Aaron ne ne mma te sɛnea wɔde afɔrebɔde biara fa asɔfo so de ma Awurade no.” ");
INSERT INTO twi_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Mobɛfa saa kwan yi so ayi Lewifo no afi Israelfo no mu ama me, na wɔayɛ me dea. ");
INSERT INTO twi_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Sɛ motew wɔn ho na mofa saa kwan yi so de wɔn ma me a, afei, wobedi ahyɛmfiri wɔ Ahyiae Ntamadan no mu, adi wɔn dwuma. ");
INSERT INTO twi_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Israelfo mu nyinaa, wɔn na wɔyɛ me nkurɔfo, na magye wɔn ato mu asi Israelfo mmakan nyinaa anan, Israelni bea biara abakan barima. ");
INSERT INTO twi_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Israel abakan biara yɛ me de; nnipa ne mmoa nyinaa. Bere a mikunkum Misraimfo mmakan nyinaa no ara na mefaa wɔn de wɔn yɛɛ me nkurɔfo. ");
INSERT INTO twi_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Mafa Lewifo no asi Israelfo mmakan nyinaa anan mu. ");
INSERT INTO twi_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Na mede Lewifo no bɛkyɛ Aaron ne ne mmabarima. Lewifo no na wɔbɛyɛ Ahyiae Ntamadan no mu nnwuma kronkron a anka ɛsɛ sɛ Israelfo no na wɔyɛ, na wɔn na wɔbɛbɔ afɔre ama nkurɔfo de ayɛ mpata ama wɔn sɛnea sɛ Israelfo no kɔ kronkronbea hɔ a ɔyaredɔm biara renka wɔn.” ");
INSERT INTO twi_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mose ne Aaron ne Israelfo no nyinaa faa ɔkwan a Awurade kyerɛɛ Mose no so pɛpɛɛpɛ de Lewifo no maa Awurade. ");
INSERT INTO twi_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lewifo no dwiraa wɔn ho, horoo wɔn nneɛma. Na Aaron de wɔn hyɛɛ Awurade nsa sɛ ohim afɔre na ɔyɛɛ wɔn ho mpata adwuma de tew wɔn ho. ");
INSERT INTO twi_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ɛno akyi no, Lewifo no kɔyɛɛ adwuma wɔ Ahyiae Ntamadan no mu a na Aaron ne ne mmabarima no hwɛ wɔn so Wɔyɛɛ biribiara sɛnea Awurade hyɛɛ Mose sɛ wɔnyɛ no. ");
INSERT INTO twi_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Eyi kɔ ma Lewifo no: Sɛ Lewini barima biara di mfe aduonu anum a, ma no nsom wɔ Ahyiae Ntamadan mu, ");
INSERT INTO twi_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","na sɛ wodi mfe aduonum a, ɛsɛ sɛ wɔapɔn fi adwuma mu a wɔnnyɛ adwuma bio. ");
INSERT INTO twi_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Sɛ wɔpɔn a, wotumi adi dwuma wɔ Ahyiae Ntamadan mu hɔ de boa wɔn nuanom, mmom wɔn ankasa de, ɛnsɛ sɛ wɔhyɛ da yɛ adwuma. Eyi ne ɔkwan a momfa so mma Lewifo no adwuma nyɛ.” ");
INSERT INTO twi_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Ɔsram a edi kan no mu afe a ɛto so abien no mu a wɔafi Misraim no na Awurade kaa saa asɛm yi kyerɛɛ Mose bere a ɔne Israelfo wɔ Sinai sare no so no se, ");
INSERT INTO twi_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Ma Israelfo no nni Twam Afahyɛ no wɔ ne bere ano. ");
INSERT INTO twi_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Munni no wɔ ne bere ano, na mofa ne mmara akwan ahorow no nyinaa so nni wɔ ɔsram yi da a ɛto so dunan no anwummere.” ");
INSERT INTO twi_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Enti Mose ka kyerɛɛ Israelfo no se wonni Twam Afahyɛ no, ");
INSERT INTO twi_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","na wɔyɛɛ saa wɔ Sinai Nweatam no so wɔ ɔsram a edi kan no da a ɛto so dunan no anwummere. Na Israelfo no yɛɛ biribiara pɛpɛɛpɛ sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Nanso na nnipa no bi fi ayi aba a esiane sɛ wɔde wɔn ho aka owufo nti na wɔn ho agu fi. Eyi nti wɔantumi anni Twam Afahyɛ no bi. Enti wɔbaa Mose ne Aaron nkyɛn da no ara ");
INSERT INTO twi_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","bɛka kyerɛɛ Mose se, “Yɛde yɛn ho aka funu ama yɛn ho agu fi, nanso dɛn nti na yɛne Israelfo nyinaa rentumi mfa yɛn afɔrebɔde mmrɛ Awurade sɛnea nhyehyɛe no te no?” ");
INSERT INTO twi_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mose buaa wɔn se, “Montwɛn mma mimmisa sɛnea Awurade mmara no ka fa mo ho.” ");
INSERT INTO twi_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Na Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Ka kyerɛ Israelfo no se, Obiara a obeso funu mu, sɛ ɔyɛ nnɛmma anaa ofi awo ntoatoaso a ɛreba no mu wɔ Twam Afahyɛ bere a ɛbɛma ne ho agu fi anaa ɔnam akwantu so nti wɔantumi amma no tumi di Awurade Twam Afahyɛ no, ");
INSERT INTO twi_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","nanso ɔsram a ɛto so abien no da a ɛto so dunan no anwummere na ɛsɛ sɛ wodi. Saa bere no na ɛsɛ sɛ wɔwe oguamma no a brodo a mmɔkaw nni mu ka ho a naban nweenwen ka ho. ");
INSERT INTO twi_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ɛnsɛ sɛ wogyaw bi ma ade kye so, anaa wɔbɔ ne dompe mu. Na ɛsɛ sɛ wodi Twam Afahyɛ no mmara no nyinaa so pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Nanso obiara a ne ho nguu fi anaa obi a ontuu kwan nanso wanni Twam Afahyɛ no wɔ ne bere ano no, ɛsɛ sɛ wotwa no asu afi Israelfo no mu wɔ afɔre a wamma ammɛbɔ amma Awurade bere a ɛsɛ mu no nti. Wɔbɛsoa wɔn afɔdi ho sodi. ");
INSERT INTO twi_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Ɛsɛ sɛ ɔhɔho a ɔfra mo mu no fa mmara koro no ara so di Awurade Twam Afahyɛ no. Ɛsɛ sɛ ɔhɔho ne okuroni nyinaa di mmara koro no so.” ");
INSERT INTO twi_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Da a wɔmaa Ahyiae Ntamadan no so sii hɔ no, omununkum kataa so. Anwummere no ara, omununkum no dan yɛɛ sɛ ogya na ɛyɛɛ saa ara anadwo mu no nyinaa de kosii adekyee. ");
INSERT INTO twi_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Saa ara na ɛte bere biara, na edu anadwo a, mununkum no dan yɛ sɛ ogya. ");
INSERT INTO twi_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Omununkum no maa ne ho so no, Israelfo no dii akyi kosii baabiara a ɛkɔ kogyina ma wɔbɔɔ hɔ atenae. ");
INSERT INTO twi_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Eyi kyerɛ sɛ, sɛ Awurade ka se wɔnkɔ a, wɔkɔ, na sɛ ɔka se wonnyina a, wogyina. Na sɛ Omununkum no gyina a, wɔn nso gyina mmere dodow a egyina hɔ no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Sɛ egyina baabi kyɛ a, wɔn nso gyina hɔ kyɛ. Na sɛ egyina hɔ nna kakraa bi a, wɔn nso gyina hɔ nna kakraa bi saa ara, efisɛ saa na Awurade ahyɛ wɔn sɛ wɔnyɛ. ");
INSERT INTO twi_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ɛtɔ da bi a, omununkum no tena Ahyiae Ntamadan no so nna kakraa bi. Sɛ ɛba saa a, nnipa no nso tena nna kakraa bi. Na Awurade nhyɛ mu, wotu fii wɔn atenae. ");
INSERT INTO twi_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ɛtɔ da bi nso a, omununkum no tena anadwo na akɔ adekyee. Nanso sɛ ɛyɛ awia anaa anadwo na omununkum no ma ne ho so a, nnipa no tu fi atenae hɔ di akyi. ");
INSERT INTO twi_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Sɛ omununkum no ba Ahyiae Ntamadan no atifi na edi nnaanu, ɔsram anaa afe a, saa nna no ara so na Israelfo no hwɛ de tena hɔ. Nanso enya tu ara pɛ a, na wɔn nso atu. ");
INSERT INTO twi_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Eyi kyerɛ sɛ, wɔn nsrabɔ ne wɔn akwantu nyinaa gyina Awurade mmara a ɔhyɛ ma wɔn no so; na biribiara a Awurade ka kyerɛɛ Mose sɛ wɔnyɛ no, wɔyɛe. ");
INSERT INTO twi_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Afei, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Fa dwetɛ a wɔaboro yɛ ntorobɛnto abien, na ɛyɛ a wɔahyɛn de afrɛ nnipa no, na edu ntamadan no tu so nso a, wɔahyɛn. ");
INSERT INTO twi_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Sɛ wɔhyɛn ntorobɛnto abien no a, nnipa no behu sɛ, ɛsɛ sɛ wɔboa wɔn ho ano wɔ Ahyiae Ntamadan no ano. ");
INSERT INTO twi_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Na sɛ wɔhyɛn baako pɛ a, na ɛkyerɛ sɛ Israel mmusua no mu mpanyimfo na ɛsɛ sɛ wɔba wo nkyɛn. ");
INSERT INTO twi_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Sɛ mohyɛn de kyerɛ sɛ monkɔ mo anim a, mmusuakuw a wɔwɔ Ahyiae Ntamadan apuei fam no betu afi wɔn atenae hɔ na wɔakɔ. ");
INSERT INTO twi_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Sɛ mohyɛn nea ɛto so abien no a, mmusuakuw a wɔwɔ anafo fam no bedi so. Monhyɛn no ntiantia mu mfa nkyerɛ sɛ wɔnkɔ. ");
INSERT INTO twi_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Na sɛ mofrɛ nnipa no ama wɔabehyia a, momfa ɔkwan foforo so nhyɛn ntorobɛnto no. ");
INSERT INTO twi_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Aaron mmabarima asɔfo nko ara na wɔbɛma wɔn kwan ama wɔahyɛn ntorobɛnto no. Eyi yɛ mmara a ɛbɛtena hɔ daa ama awo ntoatoaso a ɛbɛba no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Sɛ mudu Bɔhyɛ Asase no so na mo ne mo atamfo a wɔhyɛ mo so no ko a mohyɛn ntorobɛnto no. Na, Awurade, mo Nyankopɔn bɛkae mo na wagye mo afi mo atamfo nsam. ");
INSERT INTO twi_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Anigyebere mu nso, monhyɛn ntorobɛnto no. Afe mu dapɔnna nso, monhyɛn. Ɔsram biara mfiase nso, monhyɛn mfa nnye mo ani wɔ ɔhyew afɔre ne asomdwoe afɔre ho. Sɛ moyɛ saa a, ɛbɛkae Onyankopɔn apam a ɔne mo wɔ no. Na mene Awurade mo Nyankopɔn.” ");
INSERT INTO twi_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ɔsram a ɛto so abien no da a ɛto so aduonu no a ɛyɛ mfe abien a Israelfo fii Misraim no, omununkum no pagyaw ne ho fii Ahyiae Ntamadan no so, ");
INSERT INTO twi_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","enti Israelfo no fii Sinai sare so hɔ dii omununkum no akyi kosii sɛ ekogyinaa Paran sare so. ");
INSERT INTO twi_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Bere a ɛsɛ sɛ wotu no duu no, Awurade nam Mose so ka kyerɛɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Akwantu no mu no, mmusua a wɔhyɛ Yuda abusuakuw no ase, a Aminadab babarima Nahson tua ano na otuu wɔn frankaa ma wodii kan. ");
INSERT INTO twi_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Wɔn a wodii so ne Isakar abusuakuw a Suar babarima Netanel di wɔn anim. ");
INSERT INTO twi_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Sebulon abusuakuw na wodii hɔ a Helon babarima Eliab na na odi wɔn anim. ");
INSERT INTO twi_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Wotutuu Ahyiae Ntamadan no, na Gerson ne Merari mmusua a wofi Lewifo mu no soaa Ahyiae Ntamadan no dii wɔn afa wɔ santen no mu. ");
INSERT INTO twi_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ruben abusuakuw tuu wɔn frankaa de dii so a Sedeur babarima Elisur di wɔn anim. ");
INSERT INTO twi_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Wɔn a na wodi so ne Simeon abusuakuw a Surisadai babarima Selumiel di wɔn anim; ");
INSERT INTO twi_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gad abusuakuw nso, na Deguel babarima Eliasaf na odi wɔn anim. ");
INSERT INTO twi_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Na Kohatfo no nso na na wodi hɔ a wɔsoso kronkronbea hɔ nneɛma. Na ɛsɛ sɛ wɔhyehyɛ Ahyiae Ntamadan no wɔ beae foforo hɔ ansa na wɔadu hɔ. ");
INSERT INTO twi_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Wɔn a na wodi so ne Efraim abusuakuw a na wodi wɔn frankaa no akyi a Amihud babarima Elisama na odi wɔn anim; ");
INSERT INTO twi_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Wɔn a na wodi so ne Manase abusuakuw a Pedahsur babarima Gamaliel di wɔn anim; ");
INSERT INTO twi_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","na Benyamin abusuakuw na na wodi so a Gideoni babarima Abidan di wɔn anim. ");
INSERT INTO twi_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Wɔn a na wotwa to koraa no ne Dan abusuakuw a wɔyɛ wɔn nyinaa awɛmfo na Amisadai babarima Ahieser da wɔn ano na frankaa di wɔn anim. ");
INSERT INTO twi_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Okran babarima Pagiel na na odi Aser abusuakuw anim, ");
INSERT INTO twi_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","na Enan babarima Ahira nso di Naftali abusuakuw anim. ");
INSERT INTO twi_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Saa nhyehyɛe yi na Israel mmusuakuw yi faa so tuu wɔn kwan no. ");
INSERT INTO twi_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Afei, Mose ka kyerɛɛ nʼase Hobab, Midiani Reuel ba se, “Eyi nyinaa akyi no, yɛrekɔ beae a Awurade kae se, ‘Mede bɛma mo no.’ Bra na yɛnkɔ na yɛbɛhwɛ wo so yiye; efisɛ Awurade ahyɛ Israelfo nnepa ho bɔ.” ");
INSERT INTO twi_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Obuae se, “Dabi, merenkɔ; merekɔ mʼasase so ne mʼabusuafo nkyɛn.” ");
INSERT INTO twi_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Nanso Mose kae se, “Mesrɛ wo, nnyaw yɛn. Wo na wunim faako a ɛsɛ sɛ yɛtena wɔ sare no so, na wubetumi ayɛ yɛn kwankyerɛfo. ");
INSERT INTO twi_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Sɛ wo ne yɛn kɔ a, nneɛma pa a Awurade de bɛma yɛn no nyinaa, wubenya bi.” ");
INSERT INTO twi_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Enti wofi Awurade Bepɔw so nantew nnansa. Awurade Apam Adaka no dii wɔn anim hwehwɛɛ baabi a wɔbɛsoɛ maa wɔn. ");
INSERT INTO twi_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Wofii wɔn akwantu no ase awia a wɔrekɔ no nyinaa na Awurade mununkum no di wɔn anim. ");
INSERT INTO twi_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Bere biara a wɔbɛma adaka no so asi mu no, Mose teɛ mu se, “Awurade, sɔre! Ma wʼatamfo nhwete; ma wɔn nyinaa nguan mfi wʼanim.” ");
INSERT INTO twi_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Bere biara a wɔbɛsoɛ adaka no, ɔka se, “Awurade, san bra Israelfo mpempem a wontumi nkan wɔn no mu.” ");
INSERT INTO twi_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ankyɛ biara na nnipa no fii ase nwiinwii sɛ nneɛma nkɔ yiye mma wɔn, na Awurade tee. Nʼabufuw sɔree wɔ wɔn anwiinwii no ho. Eyi nti, Awurade maa ogya bɛhyew beae a na wɔte hɔ no mfikyiri baabi. ");
INSERT INTO twi_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Wɔteɛteɛɛ mu frɛɛ Mose sɛ ommegye wɔn no, ɔbɔɔ mpae srɛɛ Awurade maa wɔn na ogya no dumii. ");
INSERT INTO twi_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Efi saa bere no, wɔtoo beae hɔ din se Tabera a ne nkyerɛase ne “Ahyewee,” efisɛ ogya a efi Awurade nkyɛn no hyew wɔn atenae hɔ. ");
INSERT INTO twi_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Misraimfo a na wɔwɔ wɔn ntam no kɔn dɔɔ nneɛma pa a na ɛwɔ Misraim no. Eyi amma Israelfo no ani ansɔ baabi a na wɔwɔ hɔ no, enti wosui se, “Hena na ɔbɛma yɛn aduan adi? ");
INSERT INTO twi_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Yɛkae nsumnam a yɛwee wɔ Misraim mpoano no. Saa ara nso na na yenya kokumba, ɛfere, gyeene ne galik di no. ");
INSERT INTO twi_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Nanso mprempren de, yɛn anom ato; yenhu hwee sɛ mana nko ara.” ");
INSERT INTO twi_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Na mana no kɛse te sɛ wusa aba na ɛsɛ ɛhyɛ a awaawae afi dubona ho agu fam. ");
INSERT INTO twi_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Nnipa no tase fii fam na wɔayam anaa wɔasiw wɔ ɔwaduru mu ma adan esiam. Wowie a, wɔnoa de bi yɛ tetare. Woka wʼano a, ɛte sɛ tetare a wɔakyew wɔ nhabamma ngo mu. ");
INSERT INTO twi_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Obosu tɔ wɔ wɔn atenae hɔ Anadwo a na mana no nso tɔ. ");
INSERT INTO twi_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mose tee sɛ mmusuakuw no nyinaa gyinagyina, atwa wɔn ntamadan ho ahyia resu. Eyi hyɛɛ Awurade abufuw yiye, na ɛhaw Mose nso. ");
INSERT INTO twi_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Mose bisaa Awurade se, “Adɛn nti na wode ɔhaw sɛɛ aba wʼakoa so? Dɛn na mayɛ atia wo a na wode saa nnipa a wɔte sɛɛ yi nyinaa adesoa abɛsoa me? ");
INSERT INTO twi_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Me na minyinsɛn nnipa yi nyinaa? Me na mewoo wɔn? Adɛn nti na wuse minturu wɔn wɔ me nsa so sɛ nkokoaa nkosi sɛ yebedu asase a wohyɛɛ wɔn agyanom ho bɔ no so? ");
INSERT INTO twi_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ɛhefa na merekɔfa nam abrɛ nnipa yi? Wosu kyerɛ me se, ‘Ma yɛn nam nwe!’ ");
INSERT INTO twi_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Me nko ara rentumi nsoa ɔman yi! Adesoa no mu yɛ duru ma me dodo! ");
INSERT INTO twi_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Na sɛ saa na wo ne me bedi no de a, mesrɛ, kum me, sɛ manya wʼanim anuonyam a, na mma minnhyia mʼankasa me sɛe.” ");
INSERT INTO twi_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Awurade ka kyerɛɛ Mose se, “Frɛ Israelfo mpanyimfo no mu aduɔson ma me; fa wɔn bra Ahyiae Ntamadan no mu na wo ne wɔn nnyina hɔ. ");
INSERT INTO twi_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Mɛba hɔ na me ne wo abɛkasa na honhom a ɛwɔ wo so no, mɛfa na mede akogu wɔn nso so bi; ɛba saa a, wɔne wo bɛsoa nnipa no adesoa sɛnea ɛrenyɛ wo nko ara wʼadesoa. ");
INSERT INTO twi_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Ka kyerɛ nnipa no se: Munnwira mo ho na ɔkyena, mubenya nam awe. Ka kyerɛ wɔn se, ‘Awurade ate mo sufrɛ a ɛfa nneɛma a mugyaw no Misraim no ho na ɔrebɛma mo nam na mobɛwe. ");
INSERT INTO twi_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ɛnyɛ da koro anaa nnaanu anaa nnaanum anaa nnadu anaa aduonu! ");
INSERT INTO twi_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Na ɔsram baako mu, mobɛwe nam ara ama afono mo ama afa mo hwene mu. Efisɛ moapo Awurade a ɔka mo ho wɔ ha no, na moasu wɔ nʼanim se, adɛn nti na yefii Misraim?’ ” ");
INSERT INTO twi_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mose kae se, “Mmarima nko ara mpem ahansia na wɔwɔ ha, ɛno na woahyɛ wɔn bɔ sɛ wobɛma wɔn nam awe ara ɔsram! ");
INSERT INTO twi_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Sɛ yekum nguan ne anantwi ma wɔn a ɛbɛso wɔn ana? Sɛ wɔkyere po mu nam nyinaa ma wɔn a ɛbɛso wɔn ana?” ");
INSERT INTO twi_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Na Awurade bisaa Mose se, “So Awurade basa yɛ tiaa dodo ana? Afei wubehu sɛ mʼasɛm yɛ nokware anaa ɛnyɛ nokware.” ");
INSERT INTO twi_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Enti Mose fii Ahyiae Ntamadan no mu hɔ kɔkaa nsɛm a Awurade ka kyerɛɛ no no nyinaa kyerɛɛ nnipa no. Ɔboaboaa mpanyimfo aduɔson ano ma wotwaa Ahyiae Ntamadan no ho hyiae. ");
INSERT INTO twi_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Na Awurade nam omununkum mu baa fam ne Mose kasae, na ɔfaa honhom a ɛwɔ Mose so no de guu mpanyimfo aduɔson no so. Bere a honhom no baa wɔn so kakra no, wɔhyɛɛ nkɔm mmere tiaa bi mu. ");
INSERT INTO twi_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Nanso na mpanyimfo aduɔson no mu baanu a wɔfrɛ wɔn Eldad ne Medad da so wɔ wɔn atenae hɔ. Na bere a honhom no baa wɔn so wɔ hɔ no, wɔhyɛɛ nkɔm wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mmerante bi tuu mmirika kɔbɔɔ Mose asɛm a asi no ho amanneɛ ");
INSERT INTO twi_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","na Nun babarima Yosua a na wɔayi no sɛ ɔnyɛ Mose boafo no ampene so, na ɔkae se, “Me wura Mose, ma wonnyae!” ");
INSERT INTO twi_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mose bisaa no se, “Me ho na woretwe ninkunu yi? Ɛkaa me nko a, na anka Awurade nkurɔfo nyinaa yɛ adiyifo a Awurade de ne honhom agu wɔn nyinaa so!” ");
INSERT INTO twi_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Na Mose ne Israel mpanyimfo no san kɔɔ wɔn atenae hɔ. ");
INSERT INTO twi_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Na Awurade bɔɔ ahum maa ɛde mmoko fi po mu beguu atenae hɔ ne ɛho mmaa nyinaa. Baabiara a obi bɛfa no, na nnomaa yi bi atu nenam asase ani bɛyɛ anammɔn anan. ");
INSERT INTO twi_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Enti da mu no nyinaa, nnipa kyekyeree mmoko no bi kunkum wɔn awia ne anadwo ne nʼadekyee nso. Nea wannya bi no koraa na onyaa susukoraa ɔha! Mmoko buu so wɔ atenae hɔ nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Na nnipa no fii ase wee mmoa no bi no, Awurade bo san fuw wɔn maa ɔde ɔyaredɔm kum wɔn mu fa kɛse no ara. ");
INSERT INTO twi_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Enti wɔtoo beae hɔ din se Kibrot-Hataawa a nkyerɛase ne, “Akɔnnɔ ɔda” efisɛ wɔn a na wɔn ani bere nam na wɔn kɔn adɔ Misraim tena no na wosiee wɔn wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ɔman no tu fii Kibrot-Hataawa hɔ kɔtenaa Haserot. ");
INSERT INTO twi_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriam ne Aaron kasa tiaa Mose sɛ ne yere yɛ Etiopiani. ");
INSERT INTO twi_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Wɔkae se, “Mose nko ara na Awurade akasa afa ne so ana? Na yɛn nso ɔnkasa mfa yɛn so bi ana?” Na Awurade tee wɔn anwiinwii no. ");
INSERT INTO twi_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Na Mose yɛ ɔhobrɛaseni sen obiara a ɔte asase yi so. ");
INSERT INTO twi_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ntɛm so, Awurade frɛɛ Mose, Aaron ne Miriam kɔɔ Ahyiae Ntamadan no mu. Ɔhyɛɛ wɔn se, “Mo baasa no mommra Ahyiae Ntamadan mu ha.” Enti wobegyinagyinaa Awurade anim. ");
INSERT INTO twi_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Afei, Awurade nam omununkum fadum mu sian ba begyinaa Ahyiae Ntamadan no kwan ano, na ɔfrɛɛ Aaron ne Miriam. Bere a wotwiw kɔɔ wɔn anim no, ");
INSERT INTO twi_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ɔkae se, “Muntie me nsɛm: “Sɛ odiyifo wɔ mo mu a, Me, Awurade, menam anisoadehu so da me ho adi kyerɛ no, me kasa kyerɛ no wɔ dae mu. ");
INSERT INTO twi_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Nanso ɛnte saa wɔ me somfo Mose ho. Me fi nyinaa mu no, ɔyɛ ɔnokwafo. ");
INSERT INTO twi_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Me ne no kasa anim ne anim, kasa a emu da hɔ na ɛnyɛ abisae mu. Na ohu Awurade sɛnea ɔte. Adɛn nti na moansuro sɛ mobɛkasa atia me somfo Mose?” ");
INSERT INTO twi_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Awurade bo fuw wɔn dennen pa ara na ofii hɔ kɔe. ");
INSERT INTO twi_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Bere a omununkum no fii Ahyiae Ntamadan no atifi no, kwata beduruu Miriam ho fitaa sɛ sukyerɛmma. Aaron twaa nʼani huu sɛ ɔwɔ ɔhonam ani yare a ɛyɛ fi no, ");
INSERT INTO twi_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ɔka kyerɛɛ Mose se, “Me wura, mesrɛ wo, nnyina saa bɔne a yɛnam nkwaseasɛm so adi yi so ntwe yɛn aso. ");
INSERT INTO twi_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Mma no nyɛ sɛ akokoaa a wawu wɔ ne yam a ne fa aporɔw.” ");
INSERT INTO twi_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Na Mose teɛɛ mu frɛɛ Awurade se, “Onyankopɔn, mesrɛ wo sɛ sa no yare!” ");
INSERT INTO twi_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Awurade buaa Mose se, “Sɛ nʼagya tew ntasu guu nʼanim a, anka nʼanim rengu ase nnanson? Munyi no mfi atenae ha nkɔhyɛ baabi nnanson na akyiri no, obetumi asan aba.” ");
INSERT INTO twi_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Enti wotwaa Miriam asu fii atenae hɔ ma okodii nnanson. Nnipa no twɛn kosii sɛ wɔsan de no bae ansa na wɔretu kwan no bio. ");
INSERT INTO twi_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ɛno akyi no, wofii Haserot bɛbɔɔ atenae wɔ Paran sare so. ");
INSERT INTO twi_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Na Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Soma akwansrafo na wɔnkɔ Kanaan asase so; asase a mede rema Israelfo no. Soma mmusuakuw dumien no mu biara ntuanoni.” ");
INSERT INTO twi_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Enti Mose yɛɛ sɛnea Awurade hyɛɛ no no. Ɔsomaa mmarima dumien a wɔn nyinaa yɛ mmusuakuw ntuanofo fi wɔn atenae wɔ Paran sare so. ");
INSERT INTO twi_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Saa mmusuakuw no ne wɔn mpanyimfo no din na edidi so yi: Ruben abusuakuw no ntuanoni ne Sakur babarima Samua; ");
INSERT INTO twi_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeon abusuakuw no ntuanoni ne Hori babarima Safat; ");
INSERT INTO twi_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yuda abusuakuw no ntuanoni ne Yefune babarima Kaleb; ");
INSERT INTO twi_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isakar abusuakuw no ntuanoni ne Yosef babarima Igal; ");
INSERT INTO twi_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efraim abusuakuw no ntuanoni ne Nun babarima Hosea; ");
INSERT INTO twi_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Benyamin abusuakuw no ntuanoni ne Rafu babarima Palti; ");
INSERT INTO twi_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Sebulon abusuakuw no ntuanoni ne Sodi babarima Gadiel; ");
INSERT INTO twi_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Manase abusuakuw (a ɛyɛ Yosef abusuakuw no mu fa) no ntuanoni ne Susi babarima Gadi; ");
INSERT INTO twi_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan abusuakuw no ntuanoni ne Gemali babarima Amiel; ");
INSERT INTO twi_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aser abusuakuw no ntuanoni ne Mikael babarima Setur; ");
INSERT INTO twi_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Naftali abusuakuw no ntuanoni ne Wofsi babarima Nahbi; ");
INSERT INTO twi_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gad abusuakuw no ntuanoni ne Maki babarima Geuel. ");
INSERT INTO twi_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Nnipa yi na Mose somaa wɔn ma wɔkɔsraa Kanaan asase no. Mose na ɔmaa Nun ba Hosea din Yosua. ");
INSERT INTO twi_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mose ka kyerɛɛ wɔn se, “Monkɔ atifi fam wɔ Negeb bepɔw no so. ");
INSERT INTO twi_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Monhwɛ sɛnea ɛhɔ asase no te; na monhwɛ wɔn a wɔte hɔ no nso tebea sɛ wɔwɔ ahoɔden anaa wɔyɛ mmerɛw, sɛ wɔdɔɔso anaa wosua. ");
INSERT INTO twi_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Asasesu bɛn na wɔte so? Eye anaasɛ enye? Nkurowsu bɛn na wɔtete mu? Ɛdeda hɔ petee anaasɛ afasu wowɔ ho? ");
INSERT INTO twi_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Dɔte no te dɛn? Srade wɔ mu anaasɛ ɛyɛ kwaboo? Nnua wɔ so anaasɛ nnua nni so? Mommɔ mmɔden na momfa ɛhɔ nnɔbae no bi mmra.” Saa bere no na wɔretew bobe aba kan. ");
INSERT INTO twi_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Enti wɔkɔsraa asase no fi Sin sare so kosii Rehob a ɛbɛn Hamat no. ");
INSERT INTO twi_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Wɔfaa atifi fam kɔfaa Negeb beduu Hebron. Ɛhɔ na wohuu Anak asefo a wɔfrɛ wɔn Ahiman, Sesai ne Talmai. Hebron yɛ kurow dedaw. Wɔkyekyeree saa kurow no mfe ason ansa na wɔrekyekyere Soan a ɛwɔ Misraim no. ");
INSERT INTO twi_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Woduu Eskol bon mu no, wotwaa mman a bobe kasiaw wɔ so. Mmarima baanu na wɔworaa no dua soa kaa borɔdɔma aba ho de kɔe. ");
INSERT INTO twi_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Saa bere no, Israelfo no too subon hɔ din sɛ “Eskol bon mu” a nkyerɛase ne “Kasiaw,” efisɛ wohuu bobe kasiaw pii wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Adaduanan akyi no, wofii wɔn akwansra no mu bae. ");
INSERT INTO twi_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Wɔkaa nea wokohui nyinaa kyerɛɛ Mose ne Aaron ne nnipa a wɔwɔ Israel nyinaa ne wɔn a wɔwɔ Paran sare so wɔ Kades na wɔde aduaba a wɔde bae no kyerɛe. ");
INSERT INTO twi_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Asɛm a wɔbɛkae ne sɛ, “Yeduu asase a wosomaa yɛn sɛ yɛnkɔsra so no so, na ɛwo ne nufusu sen wɔ so ampa! Ɛso aduaba a yɛde bae ni. ");
INSERT INTO twi_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Nanso na nnipa a wɔtete hɔ no yɛ den. Wɔn nkurow no soso na wɔabɔ ho ban nso. Yehuu Anak asefo wɔ hɔ mpo. ");
INSERT INTO twi_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalekfo te anafo na Hetifo, Yebusifo ne Amorifo nso tete mmepɔw so. Na Kanaanfo nso tete Ntam Po no ne Yordan subon ho.” ");
INSERT INTO twi_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Na Kaleb bɔɔ nnipa no ano wɔ Mose anim kae se, “Momma yɛmforo nkɔ hɔ prɛko pɛ na yɛnkɔfa asase no, efisɛ yebetumi adi wɔn so nkonim.” ");
INSERT INTO twi_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Nanso mmarima a wɔne no kɔe no kae se, “Yɛrentumi nkɔtoa saa nnipa yi; wɔn ho yɛ den sen yɛn.” ");
INSERT INTO twi_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Na wɔde asɛm a ɛmma akomatɔyam fa asase a wɔkɔsraa so no ho tene faa Israelfo no mu nyinaa. Wose, “Asase a yɛkɔsraa so no sofo no yɛ awudifo nkutoo. Nnipa a yehuu wɔn wɔ hɔ no yɛ abran. ");
INSERT INTO twi_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Yehuu Anakfo no bi a efi awo ntoatoaso mu wɔyɛ abran no. Sɛ yɛne wɔn gyina hɔ a, na yɛayɛ te sɛ nketekre wɔ yɛn ani so. Na saa ara nso na yɛyɛɛ wɔ wɔn ani so.” ");
INSERT INTO twi_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Saa anadwo no, nnipa no nyinaa fii ase suu denneennen. ");
INSERT INTO twi_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Wɔde nne koro nwiinwii tiaa Mose ne Aaron. Wɔkae se, “Sɛ yewuwuu wɔ Misraim anaa sare so ha a, anka eye. ");
INSERT INTO twi_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Adɛn nti na Awurade de yɛn reba ha sɛ yɛmmɛtotɔ wɔ mfoa ano? Wɔbɛfow yɛn yerenom ne yɛn mma. So ennye mma yɛn sɛ yɛbɛsan akɔ Misraim ana?” ");
INSERT INTO twi_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Na wosisee wɔn ho wɔn ho sɛ, “Ɛsɛ sɛ yɛpaw ɔkannifo na yɛsan kɔ Misraim.” ");
INSERT INTO twi_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Afei, Mose ne Aaron de wɔn anim butubutuu fam wɔ Israelfo a wɔahyia hɔ no nyinaa anim. ");
INSERT INTO twi_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Akwansrafo no mu baanu, a wɔne Nun babarima Yosua ne Yefune babarima Kaleb sunsuan wɔn ntade mu ");
INSERT INTO twi_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","na wɔka kyerɛɛ Israelfo no nyinaa se, “Asase a yɛfaa mu no yɛ asase pa yiye. ");
INSERT INTO twi_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Na sɛ yɛsɔ Awurade ani a, ɔde yɛn bedu asase no so dwoodwoo, asase bere a nufusu ne ɛwo sen wɔ so, na ɔde bɛma yɛn. ");
INSERT INTO twi_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Monnyɛ dɔm ntia Awurade. Na munnsuro nnipa a wɔwɔ asase no so no nso, efisɛ yɛbɛmemene wɔn. Wonni bammɔ, nanso Awurade ka yɛn ho. Munnsuro wɔn.” ");
INSERT INTO twi_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Nanso mmuae a nnipa no mae ara ne sɛ, wobesiw wɔn abo. Afei, Awurade anuonyam baa Ahyiae Ntamadan no mu kyerɛɛ Israelfo no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Awurade bisaa Mose se, “Nnipa yi bebu me animtiaa akosi da bɛn? Anwonwade dodow a mayɛ akyerɛ wɔn yi nyinaa akyi no, wonnye me nni ara? ");
INSERT INTO twi_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mɛma ɔyaredɔm abeduru wɔn na asɛe wɔn, nanso mɛyɛ mo ɔman kɛse a ɛwɔ ahoɔden sen wɔn.” ");
INSERT INTO twi_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mose ka kyerɛɛ Awurade se, “Na Misraimfo no bɛte! Wonam wo tumi so yii saa nnipa yi fii wɔn mu. ");
INSERT INTO twi_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Wɔaka saa asɛm yi akyerɛ wɔn a wɔte asase yi so a wonim sɛ wowɔ Israel afa, na wo ne wɔn kasa anim ne anim. Wohu omununkum dum ne ogya sɛ egyina yɛn atifi, na wonim sɛ wudi yɛn anim bɔ yɛn ho ban awia ne anadwo. ");
INSERT INTO twi_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Na sɛ wukum wo nkurɔfo yi nyinaa a, aman a wɔate wo din no bɛka se, ");
INSERT INTO twi_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Awurade kum wɔn wɔ sare no so, efisɛ wantumi amfa wɔn ankodu asase a ɔkaa ho ntam sɛ ɔde bɛma wɔn no so.’ ");
INSERT INTO twi_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Afei Awurade nna nʼahoɔden adi, sɛnea wahyɛ no: ");
INSERT INTO twi_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Awurade yɛ nyaa wɔ nʼabufuw mu, na ne dɔ ne bɔne ne atuatew so bɔnefakyɛ no boro so. Nanso onnyaw ɔfɔdifo a ɔntwe nʼaso; ɔtwe mma aso wɔ agyanom bɔne ho kosi awo ntoatoaso abiɛsa ne nan mu.’ ");
INSERT INTO twi_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Wo dɔ kɛse no nti, fa saa nnipa yi bɔne kyɛ wɔn sɛnea wode akyɛ wɔn afi Misraim abesi saa bere yi.” ");
INSERT INTO twi_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Awurade kaa se, “Mede akyɛ wɔn sɛnea woabisa no. ");
INSERT INTO twi_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Nanso sɛ mete ase yi, na Awurade anuonyam ahyɛ asase nyinaa ma yi, ");
INSERT INTO twi_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","saa nnipa yi a wohuu mʼanuonyam ne anwonwade a meyɛɛ wɔ Misraim ne sare so no nanso wɔyɛɛ asoɔden de sɔɔ me hwɛɛ mpɛn du no, ");
INSERT INTO twi_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","wɔn mu biara renhu asase a mekaa ntam de hyɛɛ wɔn agyanom bɔ no. Wɔn a wobuu me animtiaa no mu biara renhu. ");
INSERT INTO twi_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Nanso sɛnea ɛsono mʼakoa Kaleb honhom na ofi ne koma nyinaa mu di mʼakyi no nti mede no bɛkɔ asase a ɔkɔɔ so no so, na nʼasefo benya ɛhɔ mu kyɛfa. ");
INSERT INTO twi_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Esiane sɛ Amalekfo na Kanaanfo tete abon mu no nti, ɔkyena, momfa mo ani nkyerɛ Po Kɔkɔɔ no nkɔ sare no so.” ");
INSERT INTO twi_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Awurade bisaa Mose ne Aaron se, ");
INSERT INTO twi_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Enkosi da bɛn na saa nnipa bɔnefo yi benwiinwii atia me? Na mate saa Israelfo yi anwiinwiisɛm yi nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Enti ka kyerɛ wɔn se, ‘Awurade na ose, sɛ mete ase yi, mɛyɛ nea metee sɛ moreka no ama mo. ");
INSERT INTO twi_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mo nyinaa mubewuwu wɔ sare no so: Efi wɔn a wɔadi mfe aduonu rekɔ no a wɔkan wɔn bi na wɔka ho nwiinwii tiaa me no. ");
INSERT INTO twi_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Mo mu biara renkɔ Bɔhyɛ Asase no so. Wɔn a wɔbɛkɔ hɔ ara ne Yefune babarima Kaleb ne Nun babarima Yosua. ");
INSERT INTO twi_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Moka se mo mma bɛyɛ nnipa a wɔte asase no so no nkoa. Mede wɔn bɛkɔ asase no so dwoodwoo ama wɔakɔfa nea muse mompɛ no. ");
INSERT INTO twi_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Na mo de, mo amu na ɛbɛka sare so ha. ");
INSERT INTO twi_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Wɔbɛhwɛ mo mma so wɔ ha mfe aduanan, na wɔahu amane wɔ mo gyidi a munni no nti; akosi sɛ onipa a otwa to no bewu atɔ sare so ha. ");
INSERT INTO twi_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Esiane sɛ akwansrafo no tenaa asase no so adaduanan no nti, ɛsɛ sɛ mo nso mukyinkyin sare no so mfe aduanan a afe biara gyina hɔ ma da koro a ɛyɛ mo bɔne so akatua, na moahu sɛnea ɛte sɛ mɛsɔre atia mo.’ ");
INSERT INTO twi_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Me, Awurade, na makasa, na nea ɛte biara no mɛyɛ eyinom atia saa nnipa bɔnefo yi a wayɛ dɔm atia me no. Wobehu wɔn awiei wɔ sare yi so; ɛha na wobewuwu.” ");
INSERT INTO twi_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Enti mmarima a Mose somaa wɔ ma wɔkɔsraa asase no so no, wɔn a wɔsan ba bɛbɔɔ amanneɛ bɔne a ɛnam so maa nnipa no nyinaa nwiinwii tiaa me no, ");
INSERT INTO twi_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","wɔde ɔyare bɔne kunkum saa mmarima a wɔde amanneɛ bɔne tenee wɔ Awurade anim no. ");
INSERT INTO twi_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Akwansrafo no nyinaa, Nun ba Yosua ne Yefune ba Kaleb nko ara na wɔtenaa ase. ");
INSERT INTO twi_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mose kɔkaa nsɛm a Onyankopɔn ka kyerɛɛ no no kyerɛɛ nnipa no no, wɔn nyinaa werɛ howee yiye. ");
INSERT INTO twi_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Wɔsɔree anɔpahema sɛ wɔrekɔ Bɔhyɛ Asase no so. Wɔkae se, “Yɛahu sɛ yɛayɛ bɔne, nanso yɛasiesie yɛn ho sɛ yɛbɛkɔ asase a Awurade hyɛɛ yɛn ho bɔ no so.” ");
INSERT INTO twi_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Nanso Mose kae se, “Adɛn na morebu Awurade ahyɛde so? Eyi renyɛ ye! ");
INSERT INTO twi_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Monsan, mo atamfo no bedi mo so nkonim, efisɛ Awurade nka mo ho. ");
INSERT INTO twi_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amalekfo ne Kanaanfo no behyia mo wɔ hɔ wɔ hɔ? Esiane sɛ moapa Awurade nti, ɔrenka mo ho na mobɛtotɔ wɔ afoa no.” ");
INSERT INTO twi_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Nanso wofii wɔn nsusuwii mu foro kɔɔ bepɔw no so a amfa wɔn ho sɛ Awurade Apam adaka no ne Mose mu biara antu amfi atenae hɔ bi. ");
INSERT INTO twi_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Na Amalekfo ne Kanaanfo a wɔte bepɔw no so no sian ba bɛtow hyɛɛ wɔn so boroo wɔn ara kosii Horma. ");
INSERT INTO twi_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Ka kyerɛ Israelfo no se, ‘Sɛ mokɔtena asase a mede rema mo no so ");
INSERT INTO twi_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","na mopɛ sɛ mobɔ ɔhyew afɔre anaa afɔre biara a wɔbɔ a eyi hua a ɛsɔ Awurade ani a, ɛsɛ sɛ afɔrebɔde no yɛ aboa a ofi mo nguankuw anaa nantwibuw mu. Sɛ ɛyɛ ɔhyew afɔre, anaa afɔrebɔ a wɔde hyɛ bɔ, anaa afɔrebɔ a efi ɔpɛ mu, anaa afɔrebɔ a wɔbɔ no afirihyia mu nnapɔnna bi mu no a, ɛsɛ sɛ wɔde aduan afɔrebɔde ka ho. ");
INSERT INTO twi_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Nea ɔde ba no, ɛsɛ sɛ ɔde aduan afɔrebɔde a ɛyɛ esiam muhumuhu kilogram abien a wɔde ngo lita baako afra ka ho ma Awurade. ");
INSERT INTO twi_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Oguamma biara a wɔde bɔ ɔhyew afɔre no, ɛsɛ sɛ wɔde nsa afɔrebɔde a ɛyɛ bobesa lita baako ka ho. ");
INSERT INTO twi_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Sɛ odwennini na wode rebɔ afɔre a, fa esiam muhumuhu lita abiɛsa fra ngo lita baako, ");
INSERT INTO twi_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ne bobesa lita baako sɛ ɔnom afɔrebɔde. Mommɔ mma enyi hua a ɛbɛsɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Sɛ wosiesie nantwi ba ma ɔhyew afɔre anaa afɔrebɔde de hyɛ bɔ sononko bi anaa ayɔnkofa asikresiam afɔre a worebɔ ama Awurade a, ");
INSERT INTO twi_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","fa atoko afɔrebɔde a ɛyɛ asikresiam a wɔayam no muhumuhu lita asia ne fa ne ngo lita abien ka nantwi no ho ");
INSERT INTO twi_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","a bobesa lita abien ka ho sɛ ɔnom afɔrebɔde. Eyi bɛyɛ aduan afɔrebɔ a ebeyi hua asɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Ɛsɛ sɛ wɔfa saa kwan yi so siesie nantwi, odwennini, oguamma anaa abirekyi ba a wɔde bɔ afɔre no. ");
INSERT INTO twi_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Afɔrebɔde biara no, ɛsɛ sɛ mofa saa ɔkwan yi so siesie no. ");
INSERT INTO twi_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Ɛsɛ sɛ Israelni biara fa saa ɔkwan yi so siesie ne aduan afɔrebɔ a eyi hua na ɛsɔ Awurade ani na ɔde ba. ");
INSERT INTO twi_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Na sɛ ahɔho a wɔte mo mu no pɛ sɛ wɔbɔ ɔhyew afɔre ma eyi hua a ɛsɔ Awurade ani a, ɛsɛ sɛ wɔfa saa ɔkwan koro no ara so wɔ awo ntoatoaso a ɛbɛba no nyinaa mu. ");
INSERT INTO twi_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Mmara no wɔ hɔ ma mo nyinaa; ɔmanfo ne ahɔho; na ɛyɛ nokware a etim hɔ daa de kosi awo ntoatoaso a ɛbɛba no mu. Mo ne ahɔho nyinaa yɛ pɛ wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Mmara baako na ɛwɔ hɔ ma mo ne ahɔho a wɔtete mo mu no nyinaa.’ ” ");
INSERT INTO twi_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Kasa kyerɛ Israelfo no se: ‘Sɛ mudu asase a mede mo rekɔ so no so ");
INSERT INTO twi_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","na mudi asase no so aduan a, momfa bi mmɔ afɔre mma Awurade. ");
INSERT INTO twi_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Atoko a mobɛyam a edi kan no, momfa nto ɔfam nto nkyɛn sɛ akyɛde sɛnea moyɛ atoko otwakan no wɔ awiporowbea no. ");
INSERT INTO twi_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Awo ntoatoaso a ɛbɛba no nyinaa mu no, ɛsɛ sɛ mode saa afɔre a efi mo aduan a edi kan a moanya mu yi ma Awurade. ");
INSERT INTO twi_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Sɛ mo, sɛ nnipakuw, anhyɛ da na mubu saa mmara a Awurade nam Mose so de ama mo yi so, ");
INSERT INTO twi_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","mmara ahorow a Awurade nam ne so de ama mo yi so, efi da a Awurade de maa mo de fa awo ntoatoaso a ɛbɛba no nyinaa mu, ");
INSERT INTO twi_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","na sɛ wɔnam awerɛfiri so fom a nnipa no nyinaa nnim a, ɛsɛ sɛ ɔman no nyinaa de aduan afɔrebɔde ne ɔnom afɔrebɔde ne ɔpapo a wɔde no bɛbɔ bɔne ho afɔre ka ho. ");
INSERT INTO twi_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Na ɛsɛ sɛ ɔsɔfo no yɛ mpata ma Israelfo nyinaa na wɔde wɔn bɔne akyɛ wɔn; efisɛ, ɛyɛ mfomso, na wɔnam ɔhyew afɔrebɔ so abɔ afɔre wɔ Awurade anim a wɔn bɔne afɔrebɔde ka ho. ");
INSERT INTO twi_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Wɔde nnipa no nyinaa a ahɔho a wɔte wɔn mu ka ho no bɔne bɛkyɛ wɔn, efisɛ ɔmanfo no nyinaa na wɔyɛɛ mfomso a wɔanhyɛ da; na wɔde akyɛ wɔn nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Nanso sɛ onipa baako bi yɛ mfomso awerɛfiri mu a, ɛsɛ sɛ ɔde abirekyibere ba a wadi afe bɛbɔ bɔne ho afɔre. ");
INSERT INTO twi_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Ɛsɛ sɛ ɔsɔfo no yɛ mpata ma nea ɔfom no wɔ Awurade anim na wɔde ne bɔne akyɛ no. ");
INSERT INTO twi_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Saa mmara yi wɔ hɔ ma Israelfo ne ananafo a wɔte mo mu no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Na sɛ obi boa pa yɛ mfomso a, sɛ ɔyɛ Israelni anaa ɔnanani no, ogu Awurade din ho fi, enti ɛsɛ sɛ woyi no fi Israelfo no mu. ");
INSERT INTO twi_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Mpɛn dodow a wabu Awurade asɛm animtiaa na wahyɛ da abu Awurade mmara so no, ɛsɛ sɛ woyi no fi Israelfo no mu; na ne bɔne gu ne ti so.’ ” ");
INSERT INTO twi_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Bere a Israelfo no wɔ sare so no, wɔkyeree wɔn mu baako sɛ ɔrebubu mmabaa homeda. ");
INSERT INTO twi_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Wɔn a wɔkyeree no no de no kɔɔ Mose ne Aaron ne atemmufo no anim, ");
INSERT INTO twi_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","na wɔde no too afiase, efisɛ na wonhu ɔkwan pɔtee a ɛsɛ sɛ wɔde no fa so. ");
INSERT INTO twi_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Afei, Awurade ka kyerɛɛ Mose se, “Ɛsɛ sɛ wokum saa onipa no. Nnipa no nyinaa nsiw no abo wɔ atenae no akyi baabi.” ");
INSERT INTO twi_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Enti wɔde no kɔɔ atenae no akyi baabi kosiw no abo sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Kasa kyerɛ Israelfo no se: Awo ntoatoaso nyinaa mu no, momma biribi nsensɛn mo ntade ano na momfa hama tuntum nkyekyere sɛ nkae ade ntetare ntade no ano. ");
INSERT INTO twi_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Saa mmara yi botae ne sɛ, bere biara a mubehu saa ade yi no, mobɛkae Awurade mmara a wɔahyɛ mo no, na moadi nʼapɛde so, na moamfa mo ankasa mo akwan sɛnea na moyɛ de som anyame afoforo no. ");
INSERT INTO twi_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ɛbɛkae mo ama moadi me mmara nyinaa so na wɔbɛtew mo ho ama mo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mene Awurade, mo Nyankopɔn a mede mo fi Misraim asase so bae sɛ mɛyɛ mo Nyankopɔn. Mene Awurade mo Nyankopɔn no.” ");
INSERT INTO twi_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora, Ishar a ɔyɛ Lewi babarima Kohat aseni ne Datan ne Abiram a wɔyɛ Eliab mmabarima ne On a ɔyɛ Pelet babarima a wɔn baasa no fi Ruben abusuakuw mu no yɛɛ ahomaso ");
INSERT INTO twi_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","na wɔsɔre tiaa Mose. Na mpanyimfo atitiriw ahannu aduonum a wɔn nyinaa fra agyinatukuw no mu no ka ho. ");
INSERT INTO twi_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Wɔkɔɔ Mose ne Aaron hɔ kɔka kyerɛɛ wɔn se, “Mo ahomaso no amee yɛn; monnyɛ kronkron nsen obiara. Awurade na wayi obiara a ɔwɔ Israel ha na ɔka yɛn nyinaa ho. Tumi bɛn na mowɔ sɛ moma mo ho so sɛ moyɛ mpanyimfo a ɛsɛ sɛ yetie mo na afei moma mo ho so sen obiara wɔ bere a yɛn nyinaa yɛ Awurade mma?” ");
INSERT INTO twi_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mose tee saa asɛm no, ɔde nʼanim butuw fam. ");
INSERT INTO twi_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ɔka kyerɛɛ Kora ne wɔn a wɔka ne ho no se, “Anɔpa, Awurade bɛkyerɛ mo wɔn a wɔyɛ ne dea ne nea ɔyɛ kronkron ne nea wayi no sɛ ɔmmɛn no. ");
INSERT INTO twi_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Nea ɛsɛ sɛ wo, Kora ne wʼakyidifo nyinaa yɛ ni: Momfa aduhuamyɛfo nkuku ");
INSERT INTO twi_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","na ɔkyena monhyew aduhuam wɔ mu wɔ Awurade anim. Na nea Awurade bɛpaw no no na ɔbɛyɛ ɔkronkronni. Afei de, Lewifo moayɛ ama aboro so!” ");
INSERT INTO twi_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mose san bisaa Kora se, “Afei mo Lewifo, muntie! ");
INSERT INTO twi_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Yi a Israel Nyankopɔn ayi wo afi nnipa bebree mu ama woabɛn no pɛɛ no, a woyɛ Awurade Ahyiae Ntamadan mu adwuma, na wutumi gyina nnipa anim yɛ asɔfodwuma no sua ma wo ana? ");
INSERT INTO twi_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ɔde wo ne wo mfɛfo Lewifo nyinaa abɛn no pɛɛ, nanso afei de, woagyina pintinn sɛ woregye asɔfodwuma no nso. ");
INSERT INTO twi_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ɛyɛ Awurade na wo ne wʼakyidifo abɔ mu atia no no. Hena ne Aaron a wunwiinwii tia no?” ");
INSERT INTO twi_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Afei Mose frɛɛ Eliab mmabarima Datan ne Abiram, nanso wobuae se, “Yɛremma! ");
INSERT INTO twi_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","So esua ma wo sɛ wode yɛn fi yɛn asase a nufusu ne ɛwo sen wɔ so no so de yɛn aba sare so sɛ worebekum yɛn ana? Na afei, wopɛ sɛ wohyɛ yɛn so nso! ");
INSERT INTO twi_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Bio, womfaa yɛn mmaa asase a ɛwo ne nufusu sen wɔ so so anaa nso wommaa yɛn asase ne bobeturo biara sɛ yɛn agyapade. Wopɛ sɛ wode saa nnipa yi yɛ nkoa ana? Dabi, yɛremma.” ");
INSERT INTO twi_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mose bo fuw na ɔka kyerɛɛ Awurade se, “Nnye wɔn afɔrebɔde biara! Minwiaa wɔn afurum baako mpo na menyɛɛ wɔn mu biara bɔne bi.” ");
INSERT INTO twi_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mose ka kyerɛɛ Kora se, “Ɔkyena wo ne wʼakyidifo no nyinaa mmra Awurade anim wɔ ha; wo ne wɔn ne Aaron. ");
INSERT INTO twi_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Obiara mfa nʼaduhuamyɛfo nkuku a aduhuam gu so mmra. Obiara mfa aduhuamyɛfo kuku mmra. Ne nyinaa dodow yɛ ahannu aduonum; na momfa mmra Awurade anim. Mo ne Aaron na ɛsɛ sɛ mode ba.” ");
INSERT INTO twi_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Enti wɔn mu biara de nʼaduhuamyɛfo kuku a wasɔ aduhuam wɔ mu bae na wɔne Mose ne Aaron begyinagyinaa Ahyiae Ntamadan no ano. ");
INSERT INTO twi_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Bere a Kora aboa nʼakyidifo a wɔasɔre atia wɔn no nyinaa ano wɔ Ahyiae Ntamadan no ano no, Awurade daa nʼanuonyam adi kyerɛɛ nnipa no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Na Awurade ka kyerɛɛ Mose ne Aaron se, ");
INSERT INTO twi_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Montwe mo ho mfi saa nnipa yi ho na manya kwan asɛe wɔn prɛko.” ");
INSERT INTO twi_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Nanso Mose ne Aaron de wɔn anim butubutuw fam wɔ Awurade anim. Wɔsrɛe se, “Ao, Onyankopɔn, amansan nyinaa Nyankopɔn, sɛ onipa baako yɛ bɔne a, na ɛsɛ sɛ wo bo fu nnipa no nyinaa?” ");
INSERT INTO twi_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Ka kyerɛ nnipa no se, ‘Mumfi Kora, Datan ne Abiram ntamadan no mu.’ ” ");
INSERT INTO twi_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Enti Mose kɔɔ Datan ne Abiram ntamadan no mu a na Israel mpanyimfo di nʼakyi. Ɔka kyerɛɛ nnipa no se, ");
INSERT INTO twi_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ɔka kyerɛɛ nnipa no se, “Monsan mfi saa nnipabɔnefo yi ntamadan no mu! Mommfa mo nsa nka wɔn biribiara, anyɛ saa a wɔbɛsɛe mo ne wɔn nyinaa, esiane wɔn bɔne nti.” ");
INSERT INTO twi_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Enti nnipa no fii Kora, Datan ne Abiram ntamadan no mu. Na Datan ne Abiram nso ne wɔn yerenom ne wɔn mma begyinagyinaa wɔn ntamadan no akwan ano. ");
INSERT INTO twi_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mose kae se, “Ɛnam eyi so bɛma moahu sɛ, Awurade na ɔsomaa me sɛ menyɛ nea mayɛ yi nyinaa. Ɛnyɛ me ara mʼadwene mu na mifi yɛɛ saa. ");
INSERT INTO twi_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Sɛ owu nko ara na ɛbɛto saa nnipa yi, anaa sɛ wohu nea ɛtaa ba nnipa so nko ara a, na ɛnyɛ Awurade na wasoma me. ");
INSERT INTO twi_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Na sɛ Awurade ma ade a ɛyɛ foforo koraa ba, na asase bue nʼanom mene wɔn ne wɔn ahode na sɛ wɔkɔ asaman anikann a, ɛbɛma moahu sɛ, saa nnipa yi abu Awurade animtiaa.” ");
INSERT INTO twi_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ka a ɔkaa eyinom wiei ara pɛ, na asase a ɛwɔ wɔn ase no mu paee, ");
INSERT INTO twi_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","na ɛbaee nʼanom menee wɔn ne wɔn abusuafo, wɔn nnamfonom a na wogyinagyina wɔn ho ne wɔn agyapade nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Wowuraa asase mu anikann kɔɔ asaman na asase no san ka too mu ma wɔyera fii ɔman no mu. ");
INSERT INTO twi_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Israelfo nyinaa guanee a na wɔreteɛteɛ mu se, “Asase rebɛmene yɛn nso!” ");
INSERT INTO twi_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Na ogya fi Awurade nkyɛn bɛhyew nnipa ahannu aduonum a na wɔrehyew aduhuam no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Ka kyerɛ ɔsɔfo Aaron babarima Eleasar sɛ onyi aduhuamyɛfo nkuku no mfi nso no mu, efisɛ ɛyɛ kronkron, na ɔntrɛtrɛw nnyansramma no mu nkɔ akyiri ");
INSERT INTO twi_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","mfi saa nnipa a wɔayɛ bɔne awu no aduhuamyɛfo nkuku no ase. Boro aduhuamhyew nkuku no mma ɛnyɛ ntrantraa na momfa nkata afɔremuka no so. Saa aduhuamyɛfo nkuku yi yɛ kronkron, efisɛ wɔde baa Awurade anim. Ma ɛnyɛ nsɛnkyerɛnne mma Israelfo no.” ");
INSERT INTO twi_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Enti ɔsɔfo Eleasar faa wɔn a wɔahyew no aduhuamyɛfo nkuku no na ɔboro maa ɛyɛɛ ntrantraa na ɔde kataa afɔremuka no so, ");
INSERT INTO twi_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","sɛnea Awurade nam Mose so kyerɛɛ no no. Na Israelfo no nam so akae se obiara a omfi Aaron ase no nni ho kwan sɛ ɔba Awurade anim bɛhyew aduhuam. Sɛ ɔyɛ saa a, asɛm a ɛtoo Kora ne ne ne dɔm no bi bɛto no. ");
INSERT INTO twi_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ade kyee anɔpa no, Israelfo no nyinaa nwiinwii tiaa Mose ne Aaron se, “Moakum Awurade nkurɔfo.” ");
INSERT INTO twi_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Nanso bere a nnipa no nyinaa boaa wɔn ho ano sɛ wɔretia Mose ne Aaron na wotwaa wɔn ani hwɛɛ Ahyiae Ntamadan no, prɛko pɛ, omununkum no kataa so ma wohuu Awurade anuonyam. ");
INSERT INTO twi_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mose ne Aaron begyinaa Ahyiae Ntamadan no kwan ano, ");
INSERT INTO twi_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","na Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Twe wo ho fi saa nnipa yi mu na matumi asɛe wɔn prɛko pɛ.” Na Mose ne Aaron de wɔn anim butubutuu fam. ");
INSERT INTO twi_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Na Mose ka kyerɛɛ Aaron se, “Fa aduhuamyɛfo kuku no na yi ogya fi afɔremuka no so gu mu. Fa aduhuam gu so na fa nnipa no mu ntɛm so fa kɔyɛ mpata ma wɔn, efisɛ Awurade abufuw adu wɔn so. Ɔyaredɔm no afi ase.” ");
INSERT INTO twi_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aaron yɛɛ nea Mose hyɛɛ no no, na otuu mmirika kɔɔ nnipa no mu. Na ɔyaredɔm no aba ampa, na ɔhyew aduhuam no de yɛɛ mpata maa wɔn. ");
INSERT INTO twi_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Na ogyinaa ateasefo ne awufo ntam, na ɔyaredɔm no gyaee. ");
INSERT INTO twi_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Nanso na nnipa mpem dunan ne ahanson awuwu dedaw abɛka wɔn a wɔne Kora wuwui da a edi anim no ho. ");
INSERT INTO twi_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ɔyaredɔm no gyaee no, Aaron san kɔɔ Mose nkyɛn wɔ Ahyiae Ntamadan no ano. ");
INSERT INTO twi_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Afei, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Ka kyerɛ Israelfo no na wɔnyɛ pema dumien, abusua biara panyin ntwa baako. Kyerɛw obiara din wɔ ne de ho. ");
INSERT INTO twi_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Aaron din na wɔbɛkyerɛw agu Lewi abusuakuw pema no ho, efisɛ ɛsɛ sɛ abusuapanyin biara nya pema baako. ");
INSERT INTO twi_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Momfa pema yi ngu Ahyiae Ntamadan no mu ahyiae mu wɔ baabi a mihyia mo wɔ adaka no anim hɔ no. ");
INSERT INTO twi_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Menam pema yi so bɛkyerɛ onipa a meyi no no na ne pema no ho bɛfefɛw, na meyi Israelfo anwiinwii a wɔtaa nwiinwii tia wo no nyinaa afi hɔ.” ");
INSERT INTO twi_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Enti Mose maa Israelfo no maa no pema dumien a wɔn abusua no biara panyin de wɔ mu a na Aaron ka de ka ho bi. ");
INSERT INTO twi_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mose de guu Awurade anim wɔ Adanse Ntamadan no mu hɔ. ");
INSERT INTO twi_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ade kyee a ɔkɔɔ mu no, ohuu sɛ Aaron pema a ɛwɔ hɔ ma Lewi abusuakuw no afefɛw ayɛ frɔmm, asow aba a ɛsensɛn so. ");
INSERT INTO twi_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Na Mose de pema no fii Awurade anim ba bɛkyerɛɛ Israelfo no. Wɔhwɛe, na ɔpanyin biara faa ne pema. ");
INSERT INTO twi_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Awurade ka kyerɛɛ Mose se, “Fa Aaron pema no san kɔto adaka no anim na fa yɛ nsɛnkyerɛnne ma atuatewfo no. Eyi de anwiinwii a wonwiinwii tia me no bɛba awiei na wɔanwuwu.” Na ɛsɛ sɛ ɔde ba bɛkyerɛ nnipa no bio na sɛ anwiinwii bi wɔ hɔ a etia Aaron tumi a, ebesiw amanehunu foforo a anka ɛbɛba nnipa no so no ano. ");
INSERT INTO twi_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mose yɛɛ nea Awurade hyɛɛ no sɛ ɔnyɛ no pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Israelfo no ka kyerɛɛ Mose se, “Yebewuwu! Yɛayera, yɛayera! ");
INSERT INTO twi_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Mpo, obiara a ɔbɛbɛn Awurade Ahyiae Ntamadan no bewu. Yɛn nyinaa rebewuwu ana?” ");
INSERT INTO twi_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Awurade kasa kyerɛɛ Aaron se, “Wo, wo mmabarima ne wʼabusuafo a wofi Lewi abusuakuw mu no, mfomso biara a ɛfa kronkronbea hɔ no ho asodi bɛda mo so. Na sɛ biribi ankɔ so yiye wɔ asɔfodwuma no mu a, wobebisa wo ne wo mmabarima ho asɛm. ");
INSERT INTO twi_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Fa wo nkurɔfo a wɔwɔ Lewi abusuakuw no mu na wɔmmoa wo mmabarima no wɔ dwuma kronkron a wodi no Ahyiae Ntamadan no anim no ho. ");
INSERT INTO twi_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ɛsɛ sɛ Lewifo no hwɛ yiye na wɔammɛn biribiara a ɛyɛ kronkron wɔ afɔremuka no so. Sɛ wɔyɛ saa a, wo ne wɔn bewuwu. ");
INSERT INTO twi_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ɛsɛ sɛ wɔka mo ho na mohwɛ Ahyiae Ntamadan mu hɔ; ɛhɔ nnwuma nyinaa. Ɛnsɛ sɛ onipa foforo biara bɛn beae a wowɔ no. ");
INSERT INTO twi_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Wo na ɛsɛ sɛ wohwɛ kronkronbea hɔ ne afɔremuka no so, na mʼabufuwhyew amma Israelfo no so bio. ");
INSERT INTO twi_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mʼankasa na mapaw wo nkurɔfo Lewifo afi Israelfo mu sɛ akyɛde ama wo, atew wɔ ho ama Awurade sɛ wɔnyɛ adwuma wɔ Ahyiae Ntamadan no mu. ");
INSERT INTO twi_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Nanso wo ne wo mmabarima nkutoo na na mubedi dwuma sɛ asɔfo wɔ nea ɛfa afɔremuka ne nea ɛwɔ ntwamtam no mu no ho. Mede asɔfodwuma ɔsom rema mo sɛ akyɛde. Ɛsɛ sɛ wokum onipa foforo biara a ɔbɛbɛn kronkronbea hɔ no.” ");
INSERT INTO twi_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Awurade san ka kyerɛɛ Aaron se: “Mʼankasa na mede akyɛde a nkurɔfo de abrɛ Awurade no ahyɛ wo nsa; afɔrebɔde a Israelfo no de ma me no nyinaa no mede ma wo ne wo mmabarima sɛ mo kyɛfa; ɛyɛ mo kyɛfa afebɔɔ. ");
INSERT INTO twi_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Aduan afɔrebɔ, bɔne afɔrebɔ ne afɔbu afɔrebɔ nyinaa mowɔ mu kyɛfa. Eyinom nyinaa yɛ afɔrebɔde a ɛyɛ kronkron pa ara. ");
INSERT INTO twi_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Munni no sɛ ade a ɛyɛ kronkron pa ara; ɔbarima biara nni bi. Mummu no sɛ ade kronkron. ");
INSERT INTO twi_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Eyi nso yɛ mo de: nea wobeyi agu nkyɛn afi Israelfo ohim afɔrebɔde mu no. Mede ma wo ne wo mmabarima ne wo mmabea nyinaa sɛ mo kyɛfa afebɔɔ. Obiara a ɔwɔ wo fi na ne ho tew no tumi di bi. ");
INSERT INTO twi_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Aba a edi kan mu akyɛde a nnipa no de bɛba sɛ afɔrebɔde a wɔde rebrɛ Awurade no a ɛyɛ ngo pa, bobesa pa, aburow ne nnɔbae biara no, mede ma mo. ");
INSERT INTO twi_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Asase no so aba a edi kan a wɔde bɛbrɛ Awurade no bɛyɛ mo de. Obiara a ɔwɔ wo fi na ne ho tew no tumi di bi. ");
INSERT INTO twi_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Biribiara a ɛwɔ Israel a wɔde bɛma Awurade no yɛ mo de. ");
INSERT INTO twi_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Israelfo abakan ne wɔn mmoa nyinaa abakan a wɔde bɛma Awurade no yɛ mo dea. Nanso mmoa a memmaa mo kwan sɛ wɔnwe wɔn nam no de, munnnye wɔn abakan. Na mmom, ɛsɛ sɛ wotua sika kakra de si abakan biara anan. ");
INSERT INTO twi_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Sɛ abakan no di ɔsram a, na ɛsɛ sɛ wɔde ogye bo a ɛyɛ dwetɛ nkaribo gram aduonum asia sɛnea kronkronbea hɔ nkaribo a ɛyɛ gram dubaako ne nkyemu anum mu baako no te no ba. ");
INSERT INTO twi_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Nanso anantwi, nguan ne mmirekyi mmakan de, ɛnsɛ sɛ wogye wɔn; wɔyɛ kronkron. Fa wɔn mogya pete afɔremuka no so na hyew wɔn srade no sɛ aduan afɔre, ehua a ɛsɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Saa mmoa yi nyinaa nam bɛyɛ mo de te sɛnea ohim afɔrebɔde koko ne ne srɛ nifa yɛ mo de no. ");
INSERT INTO twi_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Biribiara a Israelfo de bɛbrɛ Awurade a wobefi afɔrebɔ kronkron mu ayi ato hɔ no, mede ma wo ne wo mmabarima ne wo mmabea sɛ mo kyɛfa afebɔɔ. Ɛyɛ ahyɛde a ɛda mo ne Awurade ne mo asefo ntam daa nyinaa.” ");
INSERT INTO twi_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Awurade ka kyerɛɛ Aaron se, “Morennya agyapade biara mfi wɔn asase mu, na morennya kyɛfa biara mfi wɔn mu; mene mo kyɛfa ne mo agyapade wɔ Israelfo no mu. ");
INSERT INTO twi_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Mede Israel ntotoso du du no nyinaa ma Lewifo no sɛ wɔn agyapade de retua wɔ som a wɔsom wɔ Ahyiae Ntamadan no mu no so ka. ");
INSERT INTO twi_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Efi nnɛ rekɔ, Israelfo no nni ho kwan sɛ wɔbɛn Ahyiae Ntamadan no mu; anyɛ saa a, wobɛsoa wɔn bɔne ho asodi ama wɔawuwu. ");
INSERT INTO twi_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Lewifo no nko ara na wɔbɛyɛ adwuma wɔ hɔ, na wɔasoa mfomso biara a wɔbɛyɛ no ho asodi. Ɛyɛ mmara a ɛda hɔ afebɔɔ ma awo ntoatoaso a ɛbɛba no. Wɔrennya agyapade biara wɔ Israelfo no mu. ");
INSERT INTO twi_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Mmom, ntotoso du du a Israelfo no de ba sɛ Awurade afɔrebɔde no na mede rema Lewifo no. Ɛno nti na meka faa wɔn ho se: ‘Wɔrennya agyapade wɔ Israelfo no mu no.’ ” ");
INSERT INTO twi_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Ka kyerɛ Lewifo no se, ‘Sɛ munya ntotoso du du a mede rema mo sɛ mo agyapade no fi Israelfo no nkyɛn a, momfa nkyɛmu du mu baako mmrɛ Awurade sɛ nʼafɔrebɔde. ");
INSERT INTO twi_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Na Awurade begye no sɛ mo afɔrebɔde a efi mo awiporowbea anaa nsa a efi mo nsakyi amoa mu. ");
INSERT INTO twi_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Saa ɔkwan yi so na mobɛfa de mo afɔrebɔ a efi ntotoso du du a mubenya afi Israelfo no nkyɛn no abrɛ Awurade. Mumfi ntotoso du du yi mu mfa Awurade kyɛfa no mma ɔsɔfo Aaron. ");
INSERT INTO twi_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Biribiara a wɔde bɛma mo no, momfa emu nea eye pa ara na ɛyɛ kronkron no mma Awurade.’ ");
INSERT INTO twi_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Ka kyerɛ Lewifo no se: ‘Sɛ mode emu nea eye pa ara no ba a, wɔbɛfa no sɛ nea efi mo ankasa mo awiporowbea anaa mo nsakyibea hɔ. ");
INSERT INTO twi_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Mo ne mo fifo betumi adi nkae no wɔ baabiara a mopɛ, efisɛ ɛyɛ mo adwuma a moyɛ no wɔ Ahyiae Ntamadan mu no so akatua. ");
INSERT INTO twi_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Sɛ mode emu nea ɛsɔ ani no ba a, munni eyi ho afɔbu; saayɛ remma mungu Israelfo no afɔrebɔ kronkron no ho fi, na morenwuwu.’ ” ");
INSERT INTO twi_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Awurade ka kyerɛɛ Mose ne Aaron se, ");
INSERT INTO twi_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Eyi yɛ mmara a ɛsɛ sɛ wodi so a Awurade ahyɛ: Ka kyerɛ Israelfo se wɔmfa nantwi ba bere kɔkɔɔ a onnii dɛm na ɔntwee nneɛma da mmrɛ me. ");
INSERT INTO twi_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Momfa no mma ɔsɔfo Eleasar na ɔde no bɛkɔ atenae no akyi baabi na wɔakum no wɔ nʼanim. ");
INSERT INTO twi_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Na ɔsɔfo Eleasar de ne nsateaa bɛbɔ mogya no mu na ɔde apete Ahyiae Ntamadan no anim mpɛn ason. ");
INSERT INTO twi_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Afei, ɔbɛhwɛ ama obi ahyew nantwi ba no. Wɔbɛhyew ne ho nhoma, ne nam, ne mogya ne ne nsono. ");
INSERT INTO twi_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Na egu so rehyew no, Eleasar bɛfa sida dua, adwerɛ ne asaawa kɔkɔɔ na watow agu nantwi ba bere a wɔrehyew no so. ");
INSERT INTO twi_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Eyi akyi no, ɛsɛ sɛ ɔsɔfo no horo ne ntade na oguare. Afei obetumi aba atenae hɔ, nanso ne ho rentew kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Onipa a ɔhyew aboa no nso, ɛsɛ sɛ ɔhoro ne ntade na oguare, na ɔno nso ho rentew kosi anwummere. ");
INSERT INTO twi_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Ɔbarima a ne ho nguu fi no bɛsesaw aboa a wɔhyew no no nsõ de akogu atenae no akyi baabi a ɛhɔ yɛ kronkron. Ɛsɛ sɛ Israelfo no de sie na wɔde agu wɔn ahodwira nsu mu; ɛyɛ nea wɔde dwira wɔn ho fi bɔne ho. ");
INSERT INTO twi_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Onipa a ɔbɛboaboa nantwi ba no nsõ no ano no nso, ɛsɛ sɛ ɔhoro ne ntade, na ɔno nso ho rentew kosi anwummere. Eyi bɛyɛ mmara a ɛbɛtena hɔ afebɔɔ ama Israelfo no ne ahɔho a wɔte wɔn mu no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Obiara a obeso onipa funu mu no ho begu fi nnanson. ");
INSERT INTO twi_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Na ne nnansa ne ne nnanson so no, ɛsɛ sɛ ɔde nsu dwira ne ho ma ne ho tew. Sɛ wannwira ne ho nnansa ne nnanson so a ne ho rentew. ");
INSERT INTO twi_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Wɔn a woso nnipa funu mu na wonnwira wɔn ho no, wogu Awurade Ntamadan no ho fi. Ɛsɛ sɛ woyi saa nnipa no fi Israelfo mu. Esiane sɛ wɔamfa ahodwira nsu no bi ampete wɔn ho no nti, wɔn ho ntew; wɔn ho a agu fi no da so wɔ wɔn so. ");
INSERT INTO twi_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Sɛ obi wu wɔ ntamadan mu a, ɛho mmara ni: Obiara a obewura saa ntamadan no mu ne wɔn a wɔwɔ mu dedaw ansa na onipa no rewu no nyinaa ho begu fi nnanson, ");
INSERT INTO twi_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","na ade biara a enni mmuaso na wɔde asa no nso ho begu fi. ");
INSERT INTO twi_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Sɛ obi a ɔwɔ abɔnten de ne nsa ka obi a ɔtɔɔ wɔ afoa ano funu anaasɛ obi a ɔnyɛ ɔtɔfo funu, anaasɛ obi de ne nsa ka onipa dompe anaa ɔda a, ne ho begu fi nnanson. ");
INSERT INTO twi_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Nea ne ho agu fi no, fa ahodwira nsõ no bi gu kuruwa mu na hwie nsu gu so. ");
INSERT INTO twi_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Na obi a ne ho tew no mfa adwerɛ mmɔ nsu no mu mpete ntamadan no so ne nkuku ne nkaka a ɛwɔ ntamadan no mu no nso so ne obiara a na ɔwɔ ntamadan no mu a ne ho agu fi no so. Saa ara nso na obi a osoo dompe mu anaa obi a wokum no anaa nea ɔde ne ho aka ɔda no nso, wodwira ne ho. ");
INSERT INTO twi_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Wɔyɛ eyi ne nnansa ne ne nnanson so. Na nea ne ho agu fi no nso, ɛsɛ sɛ ɔhoro ne ntade na oguare, na saa anwummere no ne ho bɛtew. ");
INSERT INTO twi_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Nanso sɛ wɔn a wɔn ho agu fi na annwira wɔn ho a, ɛsɛ sɛ wotwa wɔn asu, efisɛ wɔagu Awurade kronkronbea hɔ ho fi. Wɔmfaa ahodwira nsu mpetee wɔn so ɛ, na wɔn ho ntew. ");
INSERT INTO twi_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Eyi yɛ mmara a ɛbɛtena hɔ afebɔɔ ama wɔn. “Onipa a obetu ahodwira nsu no apete no nso, ɛsɛ sɛ ɔhoro ne ntade, na obiara a ɔde ne nsa bɛka ahodwira nsu no nso ho begu fi akosi anwummere. ");
INSERT INTO twi_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Na biribiara a obi a ne ho agu fi no beso mu no nso ho begu fi akosi anwummere.” ");
INSERT INTO twi_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Israelfo no nyinaa duu Sin sare so ɔsram a edi kan no mu, na wɔtenaa Kades. Ɛhɔ na Miriam wu maa wosiee no. ");
INSERT INTO twi_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Na nsu a wɔbɛnom nni hɔ nti, nnipa no sɔre tiaa Mose ne Aaron. ");
INSERT INTO twi_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Nnipa no ne Mose hamee se, “Sɛ yɛne yɛn nuanom wuwuu wɔ Awurade anim a anka yɛpɛ. ");
INSERT INTO twi_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Adɛn nti na mode Awurade man ne yɛn nguan ne yɛn anantwi aba sare yi so sɛ yemmewuwu? ");
INSERT INTO twi_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Adɛn nti na muyii yɛn fii Misraim de yɛn baa asase bɔne yi so? Borɔdɔma, atoko ne bobe nni asase yi so. Nsu a yɛbɛnom nso nni ha.” ");
INSERT INTO twi_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mose ne Aaron fii dɔm no hɔ kɔɔ Ahyiae Ntamadan no ano de wɔn anim butubutuw fam wɔ Awurade anim; na wohuu Awurade anuonyam. ");
INSERT INTO twi_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Na Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Fa abaa no na wo ne wo nua Aaron mfrɛ nnipa no nyinaa. Wɔrehwɛ mo no, kasa kyerɛ ɔbotan no na nsu befi mu aba. Mubenya wɔn nsu a ɛbɛso wɔn ne wɔn anantwi afi ɔbotan no mu!” ");
INSERT INTO twi_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mose yɛɛ nea Awurade hyɛe no. Ɔfaa abaa no fii baabi a wɔde asie wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mose ne Aaron frɛɛ nnipa no nyinaa ma wobehyiaa wɔ ɔbotan no anim na Mose ka kyerɛɛ wɔn se, “Atuatewfo, muntie! Yɛmma nsu mfi saa ɔbotan yi mu mmra ana?” ");
INSERT INTO twi_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Afei Mose maa ne nsa so de abaa no bɔɔ ɔbotan no mprenu maa nsu bebree fii mu ba maa nnipa no ne wɔn anantwi nomee. ");
INSERT INTO twi_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Nanso Awurade ka kyerɛɛ Mose ne Aaron se, “Esiane sɛ moannya me mu ahotoso anhyɛ me anuonyam sɛ ɔkronkronni wɔ Israelfo no ani so nti, moremfa wɔn nkɔ asase a mede rema wɔn no so.” ");
INSERT INTO twi_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Wɔfrɛɛ beae hɔ Meriba a ase ne: Atuatew Nsu, efisɛ ɛhɔ ne baabi a Israelfo tew Awurade atua, na ɛhɔ ara nso na Awurade daa ne ho adi kyerɛɛ wɔn sɛ ɔyɛ ɔkronkron. ");
INSERT INTO twi_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mose somaa abɔfo fii Kades kɔɔ Edomhene nkyɛn sɛ wɔnkɔka nkyerɛ no se: “Sɛɛ na wo nua Israelfo reka: Wunim abɛbrɛsɛ a yɛafa mu no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Yɛn agyanom kɔtenaa Misraim, yɛtenaa hɔ mfe bebree. Misraimfo no yɛɛ yɛne yɛn agyanom ayayade, ");
INSERT INTO twi_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","nanso yesu frɛɛ Awurade no, otiee yɛn na ɔsomaa ɔbɔfo ma obeyii yɛn fii Misraim. “Mprempren yɛwɔ Kades wɔ mo asase hye so. ");
INSERT INTO twi_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Yɛsrɛ mo sɛ, ma yentwa mu mfa wo man yi mu. Yɛbɛhwɛ yiye sɛ yɛremfa mo mfuw ne mo bobe nturo mu. Na mpo, yɛrennom mo abura mu nsu. Yɛbɛfa Ɔhene Tempɔn so na yɛremfi so kosi sɛ yɛbɛtra wo hye no.” ");
INSERT INTO twi_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Nanso Edomhene buae se, “Mommfa mʼasase so, anyɛ saa a mede asraafo ne afoa betua mo ano!” ");
INSERT INTO twi_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Israelfo no buae se, “Owura, yɛbɛfa ɔtempɔn no so. Sɛ yɛn nyɛmmoa nom mo nsu a, yebetua ka. Yɛpɛ sɛ yetwa mu wɔ mo asase so na yenni adwemmɔne bi.” ");
INSERT INTO twi_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Nanso Edomhene buae se, “Mommfa yɛn asase so!” Ɔboaboaa nʼakofo ano de wɔn kɔɔ ɔhye no so. ");
INSERT INTO twi_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Esiane sɛ Edom amma wɔn kwan amma Israelfo no amfa wɔn man mu no nti, wɔman faa nkyɛn. ");
INSERT INTO twi_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Israelfo no nyinaa fii Kades kɔɔ Bepɔw Hor so. ");
INSERT INTO twi_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Awurade ka kyerɛɛ Mose ne Aaron wɔ Bepɔw Hor a ɛwɔ Edom hye so no se, ");
INSERT INTO twi_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Bere adu sɛ Aaron wu, na ɔrenkɔ asase a mede ama Israelfo no so bi, efisɛ mo baanu no tew mʼahyɛde ho atua wɔ Meriba nsu no ho. ");
INSERT INTO twi_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Fa Aaron ne ne babarima Eleasar kɔ Bepɔw Hor so. ");
INSERT INTO twi_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ɛhɔ na wubeyi Aaron asɔfotade no de ahyɛ ne babarima Eleasar. Ɛhɔ na Aaron bewu na watoa nʼagyanom.” ");
INSERT INTO twi_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mose yɛɛ nea Awurade hyɛɛ no no. Wɔn baasa nyinaa kɔɔ bepɔw Hor so a nnipa no nyinaa hwɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mose yii Aaron asɔfotade no de hyɛɛ ne babarima Eleasar, na Aaron wuu wɔ bepɔw no apampam. Na Mose ne Eleasar san fii bepɔw no so bae, ");
INSERT INTO twi_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","na nnipa no tee Aaron wu no, Israelfo no suu no adaduasa. ");
INSERT INTO twi_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Arad hene a ɔyɛ Kanaanni a ɔte Negeb tee sɛ Israelfo nam Atarim kwan so reba no, ɔboaboaa nʼakofo ano kɔtow hyɛɛ Israelfo no so kyekyeree ebinom nnommum. ");
INSERT INTO twi_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Afei, Israelfo no kaa ntam kyerɛɛ Awurade se, “Sɛ wode saa nnipa yi bɛhyɛ yɛn nsa a, anka yebegu wɔn nkurow akɛse no.” ");
INSERT INTO twi_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Awurade tiee wɔn adesrɛ no na ɔde Kanaanfo no maa wɔn. Israelfo no sɛee wɔn ne wɔn nkurow akɛse pasaa; wɔtoo hɔ din Horma a ase ne “Ɔsɛe.” ");
INSERT INTO twi_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Afei, Israelfo no fii Bepɔw Hor so de wɔn ani kyerɛɛ Po Kɔkɔɔ sɛ wobetwa dantaban afa Edom ho. Nanso wɔrekɔ no nipa no aba mu bui; ");
INSERT INTO twi_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","wonwiinwii tiaa Onyankopɔn ne Mose se, “Adɛn nti na moayi yɛn afi Misraim de yɛn aba sɛ yemmewuwu wɔ sare yi so? Aduan nni ha! Nsu nni ha! Yɛmpɛ saa awerɛhow aduan yi!” ");
INSERT INTO twi_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Enti, Awurade maa awɔ a wɔn ano wɔ bɔre yiye kɔkekaa wɔn mu bebree ma wowuwui. ");
INSERT INTO twi_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Na nnipa no baa Mose nkyɛn bɛsrɛɛ se, “Yɛayɛ bɔne, efisɛ yɛakasa atia Awurade ne wo. Bɔ mpae kyerɛ Awurade na awɔ no nkɔ.” Enti Mose bɔɔ mpae maa nnipa no. ");
INSERT INTO twi_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Awurade ka kyerɛɛ Mose se, “Fa kɔbere yɛ saa awɔ yi mu baako sɛso na fa no sɛn abaa tenten bi so, na sɛ awɔ no bi ka obi na ɔhwɛ no a, ɔrenwu.” ");
INSERT INTO twi_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Enti Mose yɛɛ ɔwɔ sɛso no, de sɛn dua tenten so. Na obiara a ɔwɔ no bi bɛka no no, sɛ ɔma nʼani so hwɛ no a, onwu. ");
INSERT INTO twi_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israelfo no fi hɔ no, wɔtoaa wɔn akwantu no so kɔɔ Obot kɔtenaa hɔ. ");
INSERT INTO twi_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Afei, wɔtoaa so kɔɔ Iye-Haabarim wɔ sare so wɔ Moab apuei fam. ");
INSERT INTO twi_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Wofi hɔ no, wɔtoaa so kɔɔ asuwa Sered Subon mu kɔbɔɔ atenae wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Afei, wotu fii hɔ kɔɔ Asubɔnten Arnon nkyɛn hɔ baabi a wɔne Amorifo bɔ hye. Asubɔnten Arnon na ɛyɛ ɔhye a ɛda Moabfo ne Amorifo ntam. ");
INSERT INTO twi_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Ɛno nti na, wɔka wɔ Awurade akodi nhoma no mu se, asubɔnten Arnon subon ne kurow Waheb ");
INSERT INTO twi_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","da Amorifo ne Moabfo ntam. ");
INSERT INTO twi_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Israelfo no fi hɔ toaa wɔn akwantu no so kɔɔ Beer a ase ne “Abura.” Ɛha na Awurade ka kyerɛɛ Mose se, “Frɛfrɛ nnipa no nyinaa bra na mɛma wɔn nsu.” ");
INSERT INTO twi_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ɛhɔ na Israelfo too dwom yi, “Tue Ao, Abura! To ho dwom! ");
INSERT INTO twi_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","To dwom fa abura a mmapɔmma tutu no ho, sɛ nnipa mu akunini na wotitii mu; akunini a wokura ahempeaw ne pema.” Afei, Israelfo no fii sare no so kɔfaa Matana, ");
INSERT INTO twi_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Nahaliel ne Bamot, ");
INSERT INTO twi_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","na wɔkɔɔ Pisga atifi a ɛwɔ Moab bon no mu, baabi a wugyina a wuhu asase tamaa no. ");
INSERT INTO twi_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israelfo no tuu abɔfo ma wɔde nkra kɔmaa Amorihene Sihon se: ");
INSERT INTO twi_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Momma yentwa mu mfa mo man yi mu. Yɛbɛfa ɔtempɔn no so tee, na yɛremfi so kosi sɛ yɛbɛtra mo hye. Yɛrentiatia mo nnɔbae so, yɛremfa yɛn nsa nka mo bobe nturo, na yɛrennom mo abura mu nsu kosi sɛ yebefi mo man no mu.” ");
INSERT INTO twi_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Nanso ɔhene Sihon ampene so. Na mmom, ɔboaboaa nʼakofo ano kɔtow hyɛɛ Israelfo no so wɔ sare so hɔ ne wɔn koo wɔ Yahas. ");
INSERT INTO twi_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Nanso Israelfo no kunkum wɔn faa wɔn asase a efi Asubɔnten Arnon kosi asu Yabok ho toaa so kosii Amorifo ahye so a na bammɔ wɔ hɔ no. ");
INSERT INTO twi_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israelfo no faa Amorifo no nkurow akɛse nyinaa a Hesbon kuropɔn ne ne nkuraase nyinaa ka ho tenaa mu. ");
INSERT INTO twi_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Na Hesbon yɛ Amorihene Sihon kuropɔn. Sihon na da bi ɔko tiaa Moabhene faa ne nsase nyinaa besii Asubɔnten Arnon no. ");
INSERT INTO twi_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ne saa nti, tete anwensɛm kyerɛwfo kyerɛw eyi faa ne ho se, “Bra Hesbon, Sihon kuropɔn, yɛnkyekye na ensi ne dedaw mu. ");
INSERT INTO twi_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Ogya turuw fii Hesbon Ogyaframa fii Sihon ahenkurow mu, Ɛhyew Ar kuropɔn a ɛwɔ Moab; ɛsɛee kurowmma a wɔwɔ Arnon mmepɔw so. ");
INSERT INTO twi_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ao Moabfo, mo sɛe bɛba mu! Wɔawie mo, mo a mosom Kemos! Wagyaw ne mmabarima sɛ atutenafo, Ne ne mmabea sɛ Amorihene Sihon nnommum. ");
INSERT INTO twi_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Yɛatu wɔn agu, efi Hesbon tɔnn kosi Dibon. Yɛasɛe wɔn ara akosi Nofa De kɔ ara kosi Medeba.” ");
INSERT INTO twi_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Enti Israelfo no tenaa Amorifo asase no so. ");
INSERT INTO twi_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mose somaa akwansrafo sɛ wɔnkɔsrasra Yaser fa mu hɔ. Ɔde asraafo toaa wɔn, faa wɔn nkurow nyinaa, pam Amorifo no. ");
INSERT INTO twi_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Afei, wɔde wɔn ani kyerɛɛ kurow kɛse Basan, nanso Basanhene Og de nʼasraafo hyiaa wɔn wɔ Edrei. ");
INSERT INTO twi_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Awurade ka kyerɛɛ Mose se, “Nsuro no, efisɛ mede nʼasraafo ne nʼasase nyinaa ahyɛ wo nsa. Yɛ no sɛnea woyɛɛ Amorihene Sihon a odii Hesbon so no.” ");
INSERT INTO twi_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Israelfo dii nkonim na wokum ɔhene Og ne ne mmabarima ne ne nkurɔfo nyinaa a anka wɔn mu baako mpo. Na Israelfo no faa nʼasase no. ");
INSERT INTO twi_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Afei, Israelfo no kɔɔ Moab tataw so kɔtenaa Asubɔnten Yordan apuei fam a ɛhɔ ne Yeriko di nhwɛanim no. ");
INSERT INTO twi_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Sipor babarima Balak huu nea Israelfo ayɛ Amorifo no nyinaa, ");
INSERT INTO twi_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","na Moab huu Israelfo dodow a wɔwɔ hɔ no, ɔne ne nkurɔfo bɔɔ huboa. ");
INSERT INTO twi_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moabfo no ka kyerɛɛ Midian mpanyimfo no se, “Saa dɔm yi bɛwe biribiara a ɛwɔ ha no, sɛnea nantwi we sare.” Enti Sipor ba Balak a na ɔyɛ Moabhene saa bere no ");
INSERT INTO twi_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","somaa nnipa ma wɔkɔɔ Beor babarima Balaam nkyɛn wɔ Petor a ɛbɛn Asubɔnten Eufrate ho. Balak kae se, “Nnipadɔm bi fi Misraim aba. Wɔkata asase ani nyinaa na wɔabɛtena abɛn me. ");
INSERT INTO twi_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Mɛsrɛ wo, bra na bɛdome wɔn ma me, efisɛ wɔyɛ den sen me. Ebia ɛbɛma matumi adi wɔn so nkonim na mapam wɔn afi asase no so. Efisɛ minim nhyira a ɛba wɔn a wuhyira wɔn no so, na minim mmusu a ɛba wɔn a wodome wɔn no so nso.” ");
INSERT INTO twi_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Moab ne Midian mpanyimfo no fii hɔ a na wokita sika a wɔde rekotua Balaam ka ama wadome Israelfo no. Enti wɔkɔɔ Balaam nkyɛn kɔkaa nea ehia Balak no kyerɛɛ no. ");
INSERT INTO twi_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam kae se, “Monna mma ade nkye mo. Ade kye a, nea Awurade bɛkyerɛ me sɛ menyɛ no, mɛka akyerɛ mo.” Enti Moab mpanyimfo no dae. ");
INSERT INTO twi_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Anadwo no, Onyankopɔn baa Balaam nkyɛn bebisaa no se, “Saa nnipa yi yɛ hefo?” ");
INSERT INTO twi_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Obuae se, “Wɔde nkra afi Moabhene Balak nkyɛn abrɛ me se: ");
INSERT INTO twi_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Nnipadɔm bi fi Misraim aba ne hye so. Enti bra na bɛdome wɔn sɛnea ɛbɛyɛ a metumi ne wɔn ako apam wɔn.” ");
INSERT INTO twi_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Onyankopɔn ka kyerɛɛ Balaam se, “Nkɔ. Ɛnsɛ sɛ wodome wɔn, efisɛ mahyira wɔn!” ");
INSERT INTO twi_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ade kyee anɔpa no, Balaam ka kyerɛɛ Balak nkurɔfo no se, “Monsan nkɔ fie! Awurade ampene sɛ me ne mo nkɔ.” ");
INSERT INTO twi_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Enti Balak mpanyimfo no san bɛbɔɔ amanneɛ se, “Balaam ne yɛn amma.” ");
INSERT INTO twi_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak somaa nnipa dodow pa ara a anuonyamfo a wɔkyɛn kan dɔm no fra wɔn mu. ");
INSERT INTO twi_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Wɔbaa Balaam nkyɛn bɛka kyerɛɛ no se, “Sɛnea Sipor ba Balak se ni, ‘Mma biribiara nsiw wo kwan sɛ wobɛba me nkyɛn, ");
INSERT INTO twi_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","efisɛ metua wo ka yiye. Bra na bɛdome saa nnipa no ma me.’ ” ");
INSERT INTO twi_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Nanso, Balaam buae se, “Sɛ Balak ma me dwetɛ ne sikakɔkɔɔ a ɛwɔ nʼahemfi hɔ nyinaa mpo a, merentumi nyɛ biribiara mmu saa ahyɛde a Awurade a ɔyɛ me Nyankopɔn no ahyɛ no so. ");
INSERT INTO twi_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Nanso, monna ha mma ade nkye na yɛnhwɛ sɛ Awurade bɛka asɛm foforo bi aka nea waka dedaw no ho anaa.” ");
INSERT INTO twi_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Anadwo no, Onyankopɔn ka kyerɛɛ Balaam se, “Esiane sɛ nnipa no abɛfrɛ wo no nti, Sɔre na wo ne saa nnipa no nkɔ na mmom, hwɛ yiye na yɛ nea mɛkyerɛ wo sɛ yɛ no nko ara.” ");
INSERT INTO twi_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ade kyee anɔpa no, ɔhyehyɛɛ nʼafurum, tenaa ne so ne Moab mpanyimfo no sii mu. ");
INSERT INTO twi_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Nanso, Onyankopɔn bo fuw Balaam ahopere a ɔde kɔe no; enti ɔsomaa Awurade bɔfo ma ogyinaa akwantemfi sɛ onsiw no kwan. Na Balaam te nʼafurum so a nʼasomfo baanu ka ne ho. ");
INSERT INTO twi_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Afurum no huu Awurade bɔfo no sɛ okura afoa gyina kwan no mfimfini no, ɔman faa wuram. Balaam hwee no sɛnea ɛbɛyɛ a ɔbɛfa ɔkwan no so. ");
INSERT INTO twi_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Na Awurade ɔbɔfo no gyina ɔkwan hiahiaa bi a ɛwɔ bobeturo afasu abien ntam. ");
INSERT INTO twi_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Bere a afurum no huu Awurade bɔfo no, otwerii ɔfasu no ho maa Balaam nan pemee. Enti Balaam san hwee aboa no. ");
INSERT INTO twi_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Afei, Awurade bɔfo no kɔɔ nʼanim kogyinaa baabi a ɛhɔ kyere pa ara a na afurum no nnya baabi nnan ne ho mfa nifa anaa benkum. ");
INSERT INTO twi_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Enti obutuw ɔkwan no mu. Balaam bo fuw yiye ma ɔde abaa no hwee no. ");
INSERT INTO twi_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Afei, Awurade buee afurum no ano, na obisaa Balaam se, “Mayɛ wo dɛn na nti a wohwe me mprɛnsa saa?” ");
INSERT INTO twi_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam nso buaa no se, “Woama mayɛ ɔkwasea! Na sɛ mikura afoa a, anka mekum wo mprempren.” ");
INSERT INTO twi_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Afurum no nso bisaa no se, “Menyɛ wʼafurum a woatena me so daa de abesi nnɛ? So mayɛ sɛɛ pɛn?” Obuae se, “Dabi.” ");
INSERT INTO twi_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Afei, Awurade buee Balaam ani ma ohuu ɔsoro bɔfo no sɛ watwe afoa gyina ɔkwan no mfimfini. Enti ɔde nʼanim butuw fam. ");
INSERT INTO twi_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Awurade bɔfo no bisaa no se, “Adɛn nti na woahwe wʼafurum no mprɛnsa saa? Maba sɛ merebesiw wo kwan, efisɛ wʼakwan mu no wunni ahwɛyie wɔ mʼanim. ");
INSERT INTO twi_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Afurum no huu me a ɔman faa nkyɛn mprɛnsa. Sɛ wamman a, anka mekum wo na magyaa no.” ");
INSERT INTO twi_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam ka kyerɛɛ Awurade bɔfo no se, “Mafom. Na minnim sɛ wugyina ɔkwan no mu a worebesiw me kwan. Sɛ wʼani nnye ho a mɛsan akɔ.” ");
INSERT INTO twi_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Awurade bɔfo no ka kyerɛɛ no se, “Wo ne nnipa no nkɔ, nanso asɛm a mɛka akyerɛ wo no nko ara na ka.” Enti Balaam ne Balak mpanyimfo no kɔe. ");
INSERT INTO twi_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Bere a Balak tee sɛ Balaam reba no, ofii kurow no mu kohyiaa no wɔ Moabfo kurow mu wɔ Arnon hye so, wɔ nʼasase ano. ");
INSERT INTO twi_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak bisaa Balaam se, “Mamfrɛ wo ɔhare so ana? Adɛn nti na woamma me nkyɛn? So merentumi ntua wo ka ana?” ");
INSERT INTO twi_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam buae se, “Ɛwɔ mu sɛ maba de, nanso merentumi nka nea mepɛ biara. Asɛm a Onyankopɔn de bɛhyɛ mʼano no nko ara na ɛsɛ sɛ meka.” ");
INSERT INTO twi_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam kaa Balak ho ne no kɔɔ Kiria-Husot. ");
INSERT INTO twi_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak kum anantwi ne nguan bɔɔ afɔre na ɔde mmoa no bi maa Balaam ne ne mpanyimfo a wɔka ne ho. ");
INSERT INTO twi_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ade kyee anɔpa no, Balak faa Balaam de no kɔɔ Bamot-Baal atifi. Ofi hɔ too nʼani huu sɛ Israelfo no sam wɔn atenae hɔ. ");
INSERT INTO twi_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam ka kyerɛɛ ɔhene no se, “Si afɔremuka ason wɔ ha, na siesie anantwinini ason ne adwennini ason ma me.” ");
INSERT INTO twi_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak yɛɛ sɛnea Balaam kae no, na wɔn baanu no de nantwinini ne odwennini bɔɔ afɔremuka no biara so afɔre. ");
INSERT INTO twi_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Afei Balaam ka kyerɛɛ Balak se, “Tena wʼafɔre no ho na merekɔ nkyɛn. Ebia na Awurade bɛba abehyia me, na nea ɔbɛda no adi akyerɛ me biara no mɛka akyerɛ wo.” Enti, ɔforo kɔɔ sorosoro baabi a ɛhɔ yɛ petee. ");
INSERT INTO twi_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ɛhɔ na Onyankopɔn hyiaa no ma ɔkae se, “Masiesie afɔremuka ason, na mede nantwinini ne odwennini abɔ afɔre wɔ biara so.” ");
INSERT INTO twi_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Awurade de asɛm hyɛɛ Balaam anom se, “San kɔ Balak nkyɛn na kɔka asɛm yi kyerɛ no.” ");
INSERT INTO twi_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ɔsan bae no ɔbɛtoo no sɛ ɔne Moab mpanyimfo no nyinaa gyinagyina afɔre no ho. ");
INSERT INTO twi_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Na Balaam hyɛɛ ne nkɔm: “Balak soma bɛfrɛɛ me fii Aram, Moabhene frɛɛ me fii apuei fam nkoko so. Ɔkae se, ‘Bra bɛdome Yakob ma me; bra bɛka mmususɛm gu Israel so.’ ");
INSERT INTO twi_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ɛbɛyɛ dɛn na matumi adome wɔn a Onyankopɔn nnome ɛ? Ɛbɛyɛ dɛn na matumi aka mmususɛm agu wɔn a Awurade mmuu wɔn fɔ so? ");
INSERT INTO twi_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Mihu wɔn fi ɔbotan atifi; mehwɛ wɔn fi nkoko so. Mihu nnipa a wɔatew wɔn ho a wommu wɔn ho sɛ wɔyɛ aman no bi mu nnipa. ");
INSERT INTO twi_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Hena na obetumi akan Yakob mfutuma, anaa ɔbɛkan Israelfo nkyemu anan mu baako? Ma minwu atreneefo wu, na mʼawiei nyɛ sɛ wɔn de.” ");
INSERT INTO twi_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak bisaa Balaam se, “Dɛn na woayɛ me yi? Mede wo baa sɛ bɛdome mʼatamfo, nanso woahyira wɔn mmom!” ");
INSERT INTO twi_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Obuae se, “So ɛnsɛ sɛ meka nea Awurade de ahyɛ mʼano no ana?” ");
INSERT INTO twi_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Afei, Balak ka kyerɛɛ no se, “Bra na yɛnkɔ baabi foforo a yebehu wɔn; worenhu wɔn nyinaa, gye wɔn atenae no nkyɛn nkyɛn. Gyina hɔ na dome wɔn ma me.” ");
INSERT INTO twi_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Enti ɔde no kɔɔ Sofim bepɔw Pisga atifi. Osii afɔremuka ason wɔ hɔ na ɔde nantwinini ne odwennini bɔɔ afɔre afɔre wɔ afɔremuka biara so. ");
INSERT INTO twi_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaam ka kyerɛɛ Balak se, “Tena wʼafɔre no ho wɔ ha na me nso merekohyia Awuradewɔ hɔ.” ");
INSERT INTO twi_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Awurade hyiaa Balaam na ɔde asɛm hyɛɛ nʼanom se, “San kɔ Balak hɔ na kɔka asɛm yi kyerɛ no.” ");
INSERT INTO twi_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Enti ɔsan ba bɛtoo no no sɛ ogyina nʼafɔre no ho a Moab mpanyimfo no ka ne ho. Balak bisae se, “Awurade aka dɛn?” ");
INSERT INTO twi_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Na ɔhyɛɛ ne nkɔm: “Balak, sɔre na tie; Sipor babarima tie me. ");
INSERT INTO twi_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Onyankopɔn nyɛ onipa na wadi atoro; Ɔnyɛ onipa na wasesa nʼadwene. Ɔka asɛm a ɔnyɛ ana? Wahyɛ bɔ bi pɛn a wanni so ana? ");
INSERT INTO twi_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Wɔahyɛ me sɛ minhyira; wahyira, na merentumi nnan ani! ");
INSERT INTO twi_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Wonhu ɔyawdi bi wɔ Yakob mu, wonhuu awerɛhowdi biara wɔ Israel mu. Awurade, wɔn Nyankopɔn ka wɔn ho; Ɔhene ka wɔn ho! ");
INSERT INTO twi_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Onyankopɔn yii wɔn fii Misraim; ɔte sɛ nantwi hoɔdenfo ma wɔn. ");
INSERT INTO twi_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Nnome biara mmaa Yakob so ɛ, mmusu biara nni Israel so. Afei, wɔbɛka afa Yakob ne Israel ho se, ‘Hwɛ nea Onyankopɔn ayɛ!’ ");
INSERT INTO twi_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Nnipa no sɔre sɛ gyatabere. Wɔwosow wɔn ho sɛ gyata a onnye nʼahome de kosi sɛ ɔbɛtetew nea wakyere no no nam pasaa na ɔnom nea wakyere no no mogya.” ");
INSERT INTO twi_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Na Balak ka kyerɛɛ Balaam se, “Sɛ worennome wɔn a, ɛno de nhyira wɔn koraa.” ");
INSERT INTO twi_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaam buaa no se, “Manka ankyerɛ wo se nea Awurade bɛka biara na mɛyɛ ana?” ");
INSERT INTO twi_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Afei, Balak ka kyerɛɛ Balaam se, “Bra mma memfa wo nkɔ baabi foforo. Ebia, ɛhɔ bɛyɛ anisɔ ama Onyankopɔn sɛ wubegyina hɔ adome wɔn.” ");
INSERT INTO twi_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Na Balak faa Balaam de no kɔɔ bepɔw Peor a ani kyerɛ nweatam no atifi pɛɛ no so. ");
INSERT INTO twi_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Bio, Balaam kae se, “Si afɔremuka ason na siesie anantwinini ason ne adwennini ason ma me.” ");
INSERT INTO twi_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak yɛɛ nea Balaam kae no, enti ɔde nantwinini ne odwennini bɔɔ afɔre wɔ afɔremuka no biara so. ");
INSERT INTO twi_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Afei, Balaam huu sɛ ɛsɔ Awurade ani sɛ ohyira Israel no, wankɔ abisa sɛnea ɔtaa yɛ no; mmom, ɔtoo nʼani hwɛɛ sare no so. ");
INSERT INTO twi_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Bere a Balaam huu sɛ Israelfo no abobɔ wɔn atenae sɛnea wɔn mmusuakuw te no, Onyankopɔn honhom baa ne so, ");
INSERT INTO twi_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","na eyi ne nkɔmhyɛ a ɔmae: “Beor ba Balaam nkɔmhyɛ, nkɔmhyɛ a efi obi a nʼani hu ade yiye, ");
INSERT INTO twi_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","nea ɔte Onyankopɔn nsɛm nkɔmhyɛ; nea onya anisoadehu a efi Otumfo no hɔ; na ɔda fam, a nʼani hu ade: ");
INSERT INTO twi_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Yakob, mo ntamadan yɛ fɛ, Israel, mo atenae yɛ ahomeka! ");
INSERT INTO twi_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Ɛtrɛtrɛw sɛ abon, sɛ nturo a ɛwɔ asubɔnten ho. Wɔte sɛ pɛprɛ a Awurade adua, te sɛ sida a esisi nsu ho. ");
INSERT INTO twi_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Nsu bɛsen afi wɔn ahina mu. Wɔn aba benya nsu ama aboro so. “Wɔn hene bɛyɛ kɛse asen Agag; wɔn ahenni bɛkorɔn. ");
INSERT INTO twi_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Onyankopɔn de wɔn fii Misraim na ɛbae; wɔwɔ ahoɔden sɛ wuram nantwi. Wɔsɛe atirimɔdenfo aman na wobubu wɔn nnompe mu asinasin, wɔde wɔn bɛmma wowɔ wɔn. ");
INSERT INTO twi_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Wobutuw da sɛ gyata; te sɛ gyatabere, hena na obetumi agyigye wɔn? “Wobehyira wɔn a wohyira wo, na wɔbɛdome wɔn a wɔdome wo.” ");
INSERT INTO twi_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balak bo fuw Balaam. Ɔbɔɔ ne nsam guu ne so kae se, “Mefrɛɛ wo se bɛdome mʼatamfo, nanso woahyira wɔn mprɛnsa yi nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Fi ha kɔ wo nkyi ntɛm! Mekae se mɛkyɛ wo ade a ɛsom bo nanso, Awurade amma woannya akyɛde no.” ");
INSERT INTO twi_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam buaa no se, “So manka ankyerɛ abɔfo a wosomaa wɔn baa me nkyɛn no se, ");
INSERT INTO twi_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Sɛ Balak ma me dwetɛ ne sikakɔkɔɔ a ɛwɔ nʼahemfi hɔ nyinaa koraa a, minni tumi sɛ mɛyɛ biribi atia Awurade ahyɛde, sɛ ɛyɛ papa anaa bɔne.’ Mmom nea Awurade aka no nko ara na ɛsɛ sɛ meka. ");
INSERT INTO twi_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Afei, meresan akɔ me nkurɔfo nkyɛn. Nanso ma menka nea Israelfo no bɛyɛ wo nkurɔfo no daakye no nkyerɛ wo.” ");
INSERT INTO twi_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Eyi ne nkɔmhyɛ a Balaam de mae: “Beor ba Balaam nkɔmhyɛ, nkɔmhyɛ a efi ɔbarima a nʼani hu ade yiye, ");
INSERT INTO twi_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","nea ɔte Onyankopɔn nsɛm no nkɔmhyɛ, nea ɔwɔ nimdeɛ a efi Ɔsorosoroni no hɔ, nea onya anisoadehu a efi Otumfo no hɔ, na ɔda fam, a nʼani hu ade no: ");
INSERT INTO twi_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Mihu no, nanso ɛnyɛ mprempren; mehwɛ no, nanso ɔmmɛn. Nsoromma bepue afi Yakob mu; ahempema bepue afi Israel mu. Ɔbɛdwerɛw Moabfo ti, Moabfo nyinaa tikora. ");
INSERT INTO twi_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Wɔbɛfa Edom, na Seir a ɔyɛ ne tamfo no, wobedi ne so nkonim, na Israel bɛkɔ so ayɛ den. ");
INSERT INTO twi_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Ɔhene bi bɛsɔre wɔ Yakob mu ɔno na ɔbɛsɛe kurow no mu nkaefo.” ");
INSERT INTO twi_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Afei, Balaam hwɛɛ Amalekfo na ɔhyɛɛ nkɔm: “Amalek na na ɔyɛ aman nyinaa abakan, nanso nʼawiei bɛyɛ ɔsɛe pasaa.” ");
INSERT INTO twi_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Afei, ohuu Kenifo, na ɔhyɛɛ ne nkɔm: “Mo atenae wɔ bammɔ, wɔanwen mo berebuw wɔ abotan mu; ");
INSERT INTO twi_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Nanso wɔbɛsɛe mo Kenifo bere a Asur fa mo nnommum no.” ");
INSERT INTO twi_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Afei ɔhyɛɛ ne nkɔm: “Aa! Sɛ Onyankopɔn yɛ sɛɛ a, hena na ɔbɛtena nkwa mu? ");
INSERT INTO twi_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ahyɛn befi Kipro mpoano aba; wobedi Eber ne Asur so. Nanso wɔn nso, wɔbɛsɛe wɔn pasaa.” ");
INSERT INTO twi_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Afei, Balaam sɔree na ɔsan kɔɔ ne kurom, na Balak nso kɔɔ ne kwan. ");
INSERT INTO twi_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Bere a Israelfo no tenaa Sitim no, wɔn mu mmarima no bi fii ase ne Moab mmea no bɔɔ aguaman de guu wɔn ho fi. ");
INSERT INTO twi_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Saa mmea yi too nsa frɛɛ wɔn ma wɔkɔbɔɔ afɔre maa wɔn anyame. Wodii Moabfo anyame so afɔrebɔ nnuan na wɔkotow wɔn nso. ");
INSERT INTO twi_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Enti Baal a ɛwɔ Peor no som bɛyɛɛ ɔhyɛ maa Israelfo. Eyi maa Awurade bo fuw ne nkurɔfo no yiye. ");
INSERT INTO twi_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Awurade ka kyerɛɛ Mose se, “Fa saa nnipa yi ntuanofo no nyinaa, kunkum wɔn na fa wɔn gu owia so wɔ Awurade anim sɛnea ɛbɛyɛ a, nʼabufuwhyew no befi Israel so.” ");
INSERT INTO twi_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Enti Mose ka kyerɛɛ Israel atemmufo no no se, “Ɛsɛ sɛ mo mu biara kunkum mo nkurɔfo a wɔde wɔn ho akɔhyɛ Baal a ɛwɔ Peor no ase no nyinaa.” ");
INSERT INTO twi_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Na Israelni bi de Midiani bea bi baa wɔn atenae hɔ maa Mose ne nnipa no nyinaa huu wɔn bere a na wogyinagyina Ahyiae Ntamadan pon no ano retwa adwo no. ");
INSERT INTO twi_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Bere a Pinehas a ɔyɛ Eleasar babarima a na ɔyɛ ɔsɔfo Aaron nena huu eyi no, ofii wɔn mu, kɔfaa peaw kitae; ");
INSERT INTO twi_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","na odii Israelni no akyi kɔɔ ntamadan no mu. Ɔde peaw no wɔɔ ɔbarima no san de wɔɔ ɔbea no yafunu mu. Enti ɔyaredɔm a na aba Israelfo no so no to twae; ");
INSERT INTO twi_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","nanso saa bere no, na nnipa mpem aduonu anan (24,000) awuwu dedaw. ");
INSERT INTO twi_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Eleasar babarima Pinehas a ɔyɛ ɔsɔfo Aaron nena ayi mʼabufuw afi Israelfo no so. Esiane sɛ wako apere mʼanuonyam wɔ wɔn mu sɛnea mepɛ ayɛ no nti, sɛnea meyɛɛ mʼadwene sɛ mɛsɛe Israelfo no, magyae. ");
INSERT INTO twi_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Enti ka kyerɛ no se, me ne no rebɛyɛ asomdwoe apam. ");
INSERT INTO twi_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Saa apam yi mu, ɔno ne nʼasefo bɛyɛ asɔfo afebɔɔ, efisɛ watwe me ho ninkunu wɔ Israelfo mu de ayɛ mpata ama wɔn.” ");
INSERT INTO twi_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ɔbarima a wokum no ne Midiani bea no, na ne din de Simri a na ɔyɛ Salu a otua Simeon abusuakuw ano no babarima. ");
INSERT INTO twi_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ɔbea no nso, na ne din de Kosbi a na ɔyɛ Midianhene babarima Sur babea. ");
INSERT INTO twi_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Tow hyɛ Midianfo no so sɛ atamfo na kunkum wɔn. ");
INSERT INTO twi_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Efisɛ wɔfaa mo sɛ atamfo, na wɔdaadaa mo ma mo som Baal a ɛwɔ Peor, ne Kosbi a ɔyɛ Midian ntuanoni babea, a wokum no wɔ Peor ɔyaredɔm da no.” ");
INSERT INTO twi_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ɔyaredɔm no akyi no, Awurade ka kyerɛɛ Mose ne ɔsɔfo Aaron babarima Eleasar se, ");
INSERT INTO twi_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Monkan Israelfo mmarima a wɔadi mfe aduonu ne nea ɛboro saa nyinaa na monhwɛ dodow a wobetumi akɔ ɔsa ama Israel wɔ abusua biara mu.” ");
INSERT INTO twi_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Enti Mose ne ɔsɔfo Eleasar kasa kyerɛɛ wɔn wɔ Moab tataw so, wɔ Asubɔnten Yordan ho a na wɔatra Yeriko no se, ");
INSERT INTO twi_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Monkan mmarima a wɔadi mfe aduonu ne nea ɛboro saa sɛnea Awurade hyɛɛ Mose no.” Eyinom ne Israelfo a wofi Misraim bae no: ");
INSERT INTO twi_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Eyinom ne Yakob babarima panyin Ruben asefo: Hanokfo abusua, wɔde too wɔn tete agya Hanok; Palufo abusua, wɔde too a wɔn tete agya Palu; ");
INSERT INTO twi_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hesronfo abusua, wɔde too wɔn tete agya Hesron; Karmifo abusua, wɔde too wɔn tete agya Karmi. ");
INSERT INTO twi_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Mmarima a na wɔwɔ Ruben mmusua nyinaa mu no dodow yɛ mpem aduanan abiɛsa ahanson aduasa (43,730). ");
INSERT INTO twi_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Na Palu yɛ Eliab babarima, ");
INSERT INTO twi_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","na Eliab mmabarima ne Nemuel, Datan ne Abiram. Saa Datan ne Abiram yi ara na wɔyɛ nnipa no ntuanofo a wɔka Kora akyidifo a wɔyɛɛ adwene tiaa Mose ne Aaron, de buu Awurade animtiaa no ho. ");
INSERT INTO twi_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Na asase mu bue menee wɔne Kora. Ogya fi Awurade nkyɛn bɛsɛee wɔn akyidifo ahannu aduonum. Na wɔyɛɛ kɔkɔbɔ nsɛnkyerɛnne. ");
INSERT INTO twi_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Nanso Kora ase antɔre. ");
INSERT INTO twi_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Eyinom ne mmusua a wofi Simeon ase: Nemuelfo abusua, wɔde too wɔn tete agya Nemuel. Yaminfo abusua, wɔde too wɔn tete agya Yamin. Yakinfo abusua, wɔde too wɔn tete agya Yakin. ");
INSERT INTO twi_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Serafo abusua, wɔde too wɔn tete agya Serah; Saulfo abusua, wɔde too wɔn tete agya Saulo. ");
INSERT INTO twi_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Mmarima a na wɔwɔ Simeon mmusua mu nyinaa dodow yɛ mpem aduonu abien ne ahannu (22,200). ");
INSERT INTO twi_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Eyinom ne mmusua a wɔyɛ Gad asefo: Sefonfo abusua, wɔde too wɔn tete agya Sefon; Hagifo abusua, wɔde too wɔn tete agya Hagi; Sunifo abusua no, wɔde too wɔn tete agya Suni; ");
INSERT INTO twi_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Osnifo abusua, wɔde too wɔn tete agya Osni; Erifo abusua, wɔde too wɔn tete agya Eri; ");
INSERT INTO twi_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arodfo abusua, wɔde too wɔn agya Arod; Arelifo abusua, wɔde too wɔn tete agya Areli. ");
INSERT INTO twi_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Mmarima a na wɔwɔ Gad mmusua mu no dodow yɛ mpem aduanan ne ahannum (40,500). ");
INSERT INTO twi_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Na Yuda wɔ mmabarima baanu a wɔn din de Er ne Onan a wowuwuu wɔ Kanaan asase so. ");
INSERT INTO twi_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Yuda asefo mmusua a edidi so yi: Selafo abusua, wɔde too wɔn tete agya Sela; Peresfo abusua, wɔde too wɔn tete agya Peres; Serafo abusua, wɔde too wɔn tete agya Serah. ");
INSERT INTO twi_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Eyinom ne mmusua a wofi Peres ase. Hesronfo abusua, a wɔde too wɔn tete agya Hesron; Hamulfo abusua, wɔde too wɔn tete agya Hamul. ");
INSERT INTO twi_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Mmarima a na wɔwɔ Yuda mmusua mu no nyinaa dodow yɛ mpem aduɔson asia ne ahannum (76,500). ");
INSERT INTO twi_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Eyinom ne mmusua a wofi Isakar ase: Tolafo abusua, wɔde too wɔn tete agya Tola; Puwafo abusua, wɔde too wɔn tete agya Puwa; ");
INSERT INTO twi_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yasubfo abusua, wɔde too wɔn tete agya Yasub; Simronfo abusua, wɔde too wɔn tete agya Simron. ");
INSERT INTO twi_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Mmarima a na wɔwɔ Isakar mmusua no mu no nyinaa dodow yɛ mpem aduosia anan ne ahaasa (64,300). ");
INSERT INTO twi_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Eyinom ne mmusua a wofi Sebulon ase: Seredfo abusua, wɔde too wɔn tete agya Sered; Elonfo abusua, wɔde too wɔn tete agya Elon. Yakleefo abusua, wɔde too wɔn tete agya Yakleel. ");
INSERT INTO twi_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Mmarima a na wɔwɔ Sebulon mmusua no mu no nyinaa dodow yɛ mpem aduosia ne ahannum (60,500). ");
INSERT INTO twi_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ɛnam Manase ne Efraim so na mmusua abien fii Yosef mu bae. ");
INSERT INTO twi_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manase asefo: Makirfo abusua, wɔde too wɔn tete agya Makir; Gileadfo abusua, wɔde too wɔn tete agya, Makir babarima, Gilead. ");
INSERT INTO twi_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Eyinom ne mmusua a wofi Gileadfo ase: Yeserfo abusua, wɔde too wɔn tete agya Yeser; Helekfo abusua, wɔde too wɔn agya Helek. ");
INSERT INTO twi_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asrielfo abusua, wɔde too wɔn tete agya Asriel; Sekemfo abusua, wɔde too wɔn tete agya Sekem; ");
INSERT INTO twi_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semidafo abusua, wɔde too wɔn tete agya Semida; Heferfo abusua, wɔde too wɔn tete agya Hefer. ");
INSERT INTO twi_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Hefer babarima Selofehad annya mmabarima nanso na ɔwɔ mmabea a wɔn din de Mahla, Noa, Hogla, Milka ne Tirsa. ");
INSERT INTO twi_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Mmarima a na wɔwɔ Manase mmusua no nyinaa mu dodow yɛ mpem aduonum abien ne ahanson (52,700). ");
INSERT INTO twi_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Eyinom ne mmusua a wofi Efraim ase: Sutelafo abusua, wɔde too wɔn tete agya Sutela; Bekerfo abusua, wɔde too wɔn tete agya Beker; Tahanfo abusua, wɔde too wɔn tete agya Tahan. ");
INSERT INTO twi_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Eyinom ne Sutela asefo: Eranfo abusua, wɔde too wɔn tete agya Eran. ");
INSERT INTO twi_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Eyinom Efraim mmusua; wɔn dodow yɛ mpem aduasa abien ne ahannum (32,500). Eyinom ne mmusua a wɔyɛ Yosef asefo. ");
INSERT INTO twi_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Eyinom ne mmusua a wofi Benyamin ase. Belafo abusua no, wɔde too wɔn tete agya Bela; Asbelfo abusua no, wɔde too wɔn tete agya Asbel; Ahiramfo abusua no, wɔde too wɔn tete agya Ahiram; ");
INSERT INTO twi_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sufamfo abusua no, wɔde too wɔn tete agya Sufam; Hufamfo abusua no, wɔde too wɔn tete agya Hufam. ");
INSERT INTO twi_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Eyinom ne mmusua a wofi Belafo mu; Ardfo a wɔde wɔn too wɔn tete agya Ard; Naamanfo a wɔde wɔn too wɔn tete agya Naaman. ");
INSERT INTO twi_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Na mmarima a na wɔwɔ Benyamin mmusua no mu nyinaa dodow yɛ mpem aduanan anum ne ahansia (45,600). ");
INSERT INTO twi_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Eyi ne abusua a efi Dan ase. Suhamfo abusua no, wɔde too wɔn tete agya Suham. Na Dan asefo no nyinaa yɛ Suhamfo. ");
INSERT INTO twi_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Mmarima a na wɔwɔ saa mu no nyinaa dodow yɛ mpem aduosia anan ne ahannan (64,400). ");
INSERT INTO twi_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Eyinom ne mmusua a wofi Aser ase: Yimnafo abusua no, wɔde too wɔn tete agya Yimna; Isuifo abusua no, wɔde too wɔn tete agya Isui; Beriafo abusua no, wɔde too wɔn tete agya Beria. ");
INSERT INTO twi_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Eyinom ne mmusua a wofi Beria ase: Heberfo de wɔn ho too wɔn tete agya Heber; Malkielfo de wɔn ho too wɔn tete agya Malkiel. ");
INSERT INTO twi_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Na Aser wɔ ɔbabea bi a ne din de Sera. ");
INSERT INTO twi_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Mmarima a na wɔyɛ Aser asefo no nyinaa dodow yɛ mpem aduonum abiɛsa ne ahannan (53,400). ");
INSERT INTO twi_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Eyinom ne mmusua a wofi Naftali ase: Yakseelfo abusua no, wɔde too wɔn tete agya Yakseel; Gunifo abusua no, wɔde too wɔn agya Guni; ");
INSERT INTO twi_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yeserfo abusua no, wɔde too wɔn tete agya Yeser; Silemfo abusua no, wɔde too wɔn tete agya Silem. ");
INSERT INTO twi_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Mmarima a na wɔwɔ Naftali mmusua nyinaa mu no dodow yɛ mpem aduanan anum ne ahannan (45,400). ");
INSERT INTO twi_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Nnipa dodow a wɔkan wɔn no ano si mpem ahansia ne baako ahanson aduasa (601,730). ");
INSERT INTO twi_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Afei, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Kyekyɛ asase no ma mmusua no sɛ wɔn agyapade, sɛnea wɔn dodow te. ");
INSERT INTO twi_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ma abusua a ɛso no agyapade kɛse na abusua a esua no agyapade ketewa. ");
INSERT INTO twi_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Hwɛ sɛ wɔnam ntontobɔ so bɛkyekyɛ asase no. Nea ɛsɛ sɛ kuw biara nya no begyina nʼagyanom abusuakuw din dodow so. ");
INSERT INTO twi_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ɛsɛ sɛ wɔbɔ ntonto wɔ agyapade no kyekyɛ so wɔ akuw akɛse ne nketewa no mu.” ");
INSERT INTO twi_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Eyinom ne Lewifo a wɔnam wɔn mmusua so kan wɔn: Wɔde Gersonfo too wɔn tete agya Gerson. Wɔde Kohatfo too wɔn tete agya Kohat. Wɔde Merarifo too wɔn tete agya Merari. ");
INSERT INTO twi_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Eyinom nso yɛ Lewifo mmusua: Libnifo, Hebronfo, Mahlifo, Musifo ne Korafo. Kohat yɛ Amram tete agya. ");
INSERT INTO twi_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Bere a Lewi wɔ Misraim no, wɔwoo ɔbabea a ne din de Yokebed. Kehat babarima Amram waree no. Wɔn na wɔwoo Aaron, Mose ne Miriam. ");
INSERT INTO twi_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaron woo Nadab, Abihu, Eleasar ne Itamar. ");
INSERT INTO twi_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nanso, bere a Nadab ne Abihu de ogya a ɛnyɛ kronkron brɛɛ Awurade no, wowuwui. ");
INSERT INTO twi_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Nnipakan no mu no, na Lewifo nyinaa dodow yɛ mpem aduonu abiɛsa (23,000). Wɔkan mmarima a wɔadi fi ɔsram kosi mpanyimfo so. Nanso, wɔammu Lewifo no ano anka Israel nnipakan no ho, efisɛ wɔrekyɛ nsase no ama mmusuakuw no, wɔamma Lewifo no bi. ");
INSERT INTO twi_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Enti sɛnea Mose ne ɔsɔfo Eleasar fa kyerɛɛ nnipa no ano wɔ Moab bepɔw a ɛbɛn Asubɔnten Yordan a na wɔatwa Yeriko ne no. ");
INSERT INTO twi_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Na saa nnipa yi mu biara nni hɔ a ɔfra wɔn a Mose ne Aaron kan wɔn wɔ Sinai sare so no mu. ");
INSERT INTO twi_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Efisɛ Awurade ka kyerɛɛ saa Israelfo no se wobewuwu wɔ sare no so. Anka wɔn mu biara, gye Yefune ba Kaleb ne Nun babarima Yosua. ");
INSERT INTO twi_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Hefer a ɔyɛ Manase ba, Mika ba, Gilead ba no babarima Selofehad a wofi Manase mmusua a efi Yosef ase no mmabea a wɔn din ne Mahla, Noa, Hogla, Milka ne Tirsa sɔree. ");
INSERT INTO twi_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Wɔbaa Mose, ɔsɔfo Eleasar, mpanyimfo ne wɔn a wɔahyia wɔ Ahyiae Ntamadan no ano no nyinaa anim bɛkaa se, ");
INSERT INTO twi_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Yɛn agya wuu wɔ sare so nanso na ɔnka wɔn a wɔne Kora yɛɛ dɔm tiaa Awurade a enti ɛma wowuwuu no ho. Ɔno ankasa bɔne nti na owui a wannyaw mmabarima. ");
INSERT INTO twi_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Adɛn nti na esiane sɛ yɛn agya anwo ɔbabarima nti ne din ayera fi nʼabusua mu? Momma yɛn yɛn agya abusua mu agyapade no bi.” ");
INSERT INTO twi_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Enti Mose de wɔn asɛm too Awurade anim. ");
INSERT INTO twi_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Awurade buaa no se, ");
INSERT INTO twi_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Asɛm a Selofehad mmabea no ka no yɛ nokware. Ma wɔn ne wɔn agya nuanom no asase. Fa agyapade a sɛ wɔn agya no te ase a anka obenya no ma wɔn. ");
INSERT INTO twi_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Ka kyerɛ Israelfo no se sɛ obi wu na onni mmabarima a ɛsɛ sɛ nʼagyapade kɔ ne mmabea hɔ. ");
INSERT INTO twi_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Na sɛ onni ɔbabea nso a, ɛsɛ sɛ agyapade no kɔ ne nuabarimanom nkyɛn. ");
INSERT INTO twi_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Na sɛ onni nuabarimanom a, ɛkɔ ne wɔfanom nkyɛn. ");
INSERT INTO twi_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Na sɛ onni wɔn mu biara bi a, ɛkɔ ne busuani bi a ɔbɛn no nkyɛn. Ɛsɛ sɛ Israelfo di saa mmara a Awurade hyɛɛ Mose no so.” ");
INSERT INTO twi_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Awurade ka kyerɛɛ Mose se, “Kɔ bepɔw a ɛwɔ Abarim mmepɔw no so na hwɛ asase a mede maa Israelfo no. ");
INSERT INTO twi_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Sɛ wohwɛ wie a, wubewu sɛnea wo nua Aaron wui no, ");
INSERT INTO twi_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","efisɛ wɔsɔre tiaa me mmara wɔ Sin sare so hɔ, mo baanu no buu mʼahyɛde so na moanhyɛ me anuonyam sɛ ɔkronkronni wɔ wɔn ani so.” Na ɔretwe nʼadwene aba Meriba nsu “Akoe” a ɛwɔ Kades a ɛwɔ Sin sare so no so. ");
INSERT INTO twi_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mose ka kyerɛɛ Awurade se, ");
INSERT INTO twi_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Awurade, Onyankopɔn a woyɛ nnipa nyinaa honhom ti, yi obi ma onni dɔm yi anim ");
INSERT INTO twi_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","a ɔde wɔn befi adi na ɔde wɔn aba mu sɛnea ɛbɛyɛ a Awurade nnipa renyɛ sɛ nguan a wonni ɔhwɛfo.” ");
INSERT INTO twi_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Enti Awurade buaa Mose se, “Kɔ na kɔfrɛ Nun babarima Yosua a ɔwɔ akanni honhom wɔ ne mu no, na fa wo nsa to no so. ");
INSERT INTO twi_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Fa no kɔ ɔsɔfo Eleasar ne nnipa no nyinaa anim na fa ne dwumadi hyɛ ne nsa. ");
INSERT INTO twi_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Fa wo tumi no bi ma no sɛnea ɛbɛyɛ a Israelfo nyinaa betie no. ");
INSERT INTO twi_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Sɛ wohia akwankyerɛ a efi Awurade hɔ a, Yosua begyina ɔsɔfo Eleasar anim, na ɔsɔfo Eleasar abɔ ntonto kronkron de abisa Awurade apɛde. Ɔno na ɔbɛhyɛ ama Israelfo no nyinaa afi adi na wahyɛ ama wɔaba mu.” ");
INSERT INTO twi_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mose yɛɛ sɛnea Awurade hyɛɛ no no. Ɔde Yosua kyerɛɛ ɔsɔfo Eleasar ne nnipa no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Na ɔde ne nsa guu no so, de nʼadwuma hyɛɛ ne nsa sɛnea Awurade nam ne so hyɛe no. ");
INSERT INTO twi_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Ka kyerɛ Israelfo se, ‘Monhwɛ na momfa mʼaduan afɔre mmrɛ me wɔ ne bere ano sɛ ehua a ɛsɔ mʼani.’ ");
INSERT INTO twi_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ka kyerɛ wɔn se, ‘Eyi ne aduan afɔre a ɛsɛ sɛ mode brɛ Awurade: nguamma abien a wɔadi afe a dɛm nni wɔn ho; momfa mmra sɛ daa ɔhyew afɔre. ");
INSERT INTO twi_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Momfa oguamma no baako mmɔ afɔre anɔpa na momfa ɔbaako mmɔ anwummere, ");
INSERT INTO twi_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","na momfa aburow lita abien ne fa a wɔayam no muhumuhu na wɔde ngo lita baako afra nka ho. ");
INSERT INTO twi_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Eyi ne ɔhyew afɔre a wofii ase wɔ Sinai Bepɔw so a ɛsɛ sɛ wɔbɔ no bere ano bere ano ma eyi hua. Ɛyɛ aduan afɔre a wɔbɔ ma Awurade. ");
INSERT INTO twi_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Ɛsɛ sɛ wɔde ɔnom afɔrebɔde a ɛyɛ nsa a apae lita baako a oguamma ka ho ka afɔrebɔde no ho a wobehwie agu beae bi a ɛhɔ yɛ kronkron wɔ Awurade anim. ");
INSERT INTO twi_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Momfa oguamma a ɔto so abien no mmɔ afɔre anwummere a atoko ne nsa afɔrebɔ ka ho. Ɛno nso yɛ Awurade huam. Ɛyɛ ɔhyew afɔre.’ ");
INSERT INTO twi_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Sɛ edu homeda a, momfa nguantenmma a wɔadi afe a wonnii dɛm biara ne afɔrebɔde ahorow a ɛsɛ sɛ mode ka ho no mmɔ afɔre. Ɛsɛ sɛ atoko afɔrebɔde lita anan ne fa a wɔayam no muhumuhu de ngo afra a nsa ka ho saa ara na wɔde bɔ saa afɔre no. ");
INSERT INTO twi_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Eyi ne ɔhyew afɔre a wɔbɔ no homeda biara de ka bere ano ɔhyew afɔre ne nsa afɔre ho no. ");
INSERT INTO twi_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘Saa ara nso na da a edi kan wɔ ɔsram biara mu no, ɛsɛ sɛ mobɔ ɔhyew afɔre foforo bi ka ho de ma Awurade. Afɔrebɔde no bɛyɛ nantwinini abien, Odwennini baako ne nguantenmma ason a wɔadi afe a wonnii dɛm biara. ");
INSERT INTO twi_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Nantwinini biara no, ɛsɛ sɛ mode ka ho ne asikresiam lita asia ne fa a wɔayam no muhumuhu de ngo afra. Afei, mode asikresiam a wɔayam no muhumuhu lita anan ne fa a wɔde ngo afra bɛbɔ aburow afɔre a Odwennini no ka ho; ");
INSERT INTO twi_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","na oguamma biara nso, mode asikresiam lita abiɛsa. Eyi bɛyɛ ɔhyew afɔre a ɛsɔ ani, aduan afɔre a wɔbɔ ma Awurade. ");
INSERT INTO twi_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Nantwi biara, nsa afɔrebɔde lita abien ka ho. Odwennini biara, nsa afɔrebɔde lita baako ne fa ka ho. Oguamma biara nso, nsa afɔrebɔde lita baako ka ho. Afe mu no, eyi na ɛbɛyɛ ɔhyew afɔre wɔ ɔsram biara mu. ");
INSERT INTO twi_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Mo bere ano bere ano ɔhyew ne nsa afɔrebɔ akyi no, ɛsɛ sɛ mode ɔpapo bɛbɔ bɔne ho afɔre ma Awurade. ");
INSERT INTO twi_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Ɛsɛ sɛ mudi Awurade Twam Afahyɛ no afe biara sram a edi kan no da a ɛto so dunan no so. ");
INSERT INTO twi_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Da a edi so no, mubefi ase adi afahyɛ; munnni brodo a mmɔkaw wɔ mu nnanson. ");
INSERT INTO twi_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Afahyɛ no da a edi kan no, nnipa no nyinaa bɛbɔ ahotew gua na obiara renyɛ adwuma a ɛyɛ den biara. ");
INSERT INTO twi_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Momfa nantwimma anini abien, Odwennini baako ne nguantenmma ason a wɔadi afe a wonnii dɛm mmɛbɔ ɔhyew afɔre ama Awurade. ");
INSERT INTO twi_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Mode esiam muhumuhu lita ason a wɔde ngo afra bɛka nantwi baako biara ho. Afei, mode esiam lita anum bɛka odwennini no ho, ");
INSERT INTO twi_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","na nguanten ason no biara nso, mode esiam lita abiɛsa aka ho. ");
INSERT INTO twi_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Ɛsɛ sɛ mode ɔpapo bɔ bɔne ho afɔre sɛ mpata ma mo ho. ");
INSERT INTO twi_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Momfa saa afɔrebɔde yi nka nea daadaa mobɔ no ho. ");
INSERT INTO twi_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Momfa saa kwan yi so mmɔ aduan afɔre da biara saa ara nnanson sɛ ehua a ɛsɔ Awurade ani; ɛsɛ sɛ mobɔ ka ɔhyew afɔre ne nsa afɔre a mobɔ daa no ho. ");
INSERT INTO twi_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Da a ɛto so ason no, monyɛ nhyiamu kronkron na monnyɛ adwuma a ɛyɛ den biara. ");
INSERT INTO twi_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Aduankan da no a wɔfrɛ no Nnaawɔtwe mu Afahyɛ anaasɛ Pentekoste no, ɛsɛ sɛ nnipa no nyinaa de kronkronyɛ sononko hyia, de di Otwabere Afahyɛ no. Da no, ɛsɛ sɛ mode mo mfuw mu nnɔbae foforo bɛbɔ Awurade aduan afɔre. Ɛnsɛ sɛ moyɛ adwuma a ɛyɛ den biara. ");
INSERT INTO twi_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Momfa nantwimma anini abien, odwennini baako ne nguantenmma anini ason mmɛbɔ ɔhyew afɔre sɛ ehua a ɛsɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Mode mo aburow lita asia ne fa a wɔayam no muhumuhu a mode ngo afra bɛka nantwi baako biara ho. Mode lita anan bɛka Odwennini no ho; ");
INSERT INTO twi_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","na mode lita abiɛsa bɛka nguantenmma ason no biara ho. ");
INSERT INTO twi_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Momfa ɔpapo baako na wɔmfa nyɛ mpata mma mo. ");
INSERT INTO twi_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Saa afɔre ahorow yi ka daa ɔhyew afɔre, aburow afɔre ne nsa afɔre no ho. Monhwɛ sɛ mmoa a mode wɔn bɛbɔ saa afɔre no nnii dɛm biara ɛ. ");
INSERT INTO twi_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘Ɔsram a ɛto so ason no da a edi kan wɔ afe biara mu no, munni torobɛnto afahyɛ no. Monyɛ nhyiamu kronkron no na obiara nyɛ adwumaden biara. ");
INSERT INTO twi_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Momfa nantwi ba onini baako, Odwennini baako ne adwennini ason a wɔadi afe a wonnii dɛm mmɛbɔ ɔhyew afɔre a eyi hua a ɛsɔ Awurade ani. ");
INSERT INTO twi_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Momfa esiam lita asia ne fa a wɔayam no muhumuhu a wɔde ngo afra mmɔ atoko afɔre no a nantwi no ka ho. Odwennini no, momfa lita anan ne fa nka ho ");
INSERT INTO twi_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","na lita abien ne fa nso nka nguantenmma no biara ho. ");
INSERT INTO twi_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Momfa ɔpapo baako nka ho mmɔ bɔne ho afɔre mfa nyɛ mpata mma mo. ");
INSERT INTO twi_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Eyinom ka ɔhyew afɔre ne nsa afɔre a mobɔ no ɔsram biara ne daa de a wɔakyerɛ no ho. Ɛyɛ aduan afɔre a wɔde brɛ Awurade sɛ ehua a ɛsɔ ani. ");
INSERT INTO twi_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘Ɔsram a ɛto so ason no da a ɛto so du so no monyɛ nhyiamu kronkron. Ɛyɛ da a ɛsɛ sɛ nnipa no nyinaa yɛ komm ahobrɛase mu wɔ Awurade anim na ɛnsɛ sɛ biara yɛ adwuma biara. ");
INSERT INTO twi_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Mommɔ ɔhyew afɔre a eyi hua a ɛsɔ Awurade ani. Afɔrebɔde no yɛ nantwi ba baako, odwennini baako, nguamma a wɔadi afe ason a wonnii dɛm biara. ");
INSERT INTO twi_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Momfa nantwi ba no nsiesie atoko afɔre a mode asikresiam a wɔayam no muhumuhu ne ngo lita asia ne fa afra, ");
INSERT INTO twi_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","na momfa lita anan ne fa nka odwennini no ho na momfa lita abien ne fa aka nguamma ason no mu biara ho. ");
INSERT INTO twi_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Ɛsɛ sɛ mode ɔpapo baako bɔ bɔne ho afɔre. Eyi ka bɔne afɔrebɔde a wɔbɔ de pata ne ɔhyew afɔre a wɔbɔ no daadaa a aduan afɔrebɔde ne nsa afɔre ka ho no ho. ");
INSERT INTO twi_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘Monyɛ nhyiamu kronkron wɔ ɔsram a ɛto so ason no da a ɛto so dunum no so, na monnyɛ adwumaden biara. Munni afahyɛ no nnanson mma Awurade. ");
INSERT INTO twi_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Nneɛma a mode bɛbɔ ɔhyew afɔre na ama ayi hua a ɛsɔ Awurade ani no yɛ nantwimma anini dumiɛnsa, adwennini abien ne adwennini dunan a wɔadi afe na wonnii dɛm biara. ");
INSERT INTO twi_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Ɛsɛ sɛ mode asikresiam a wɔayam no muhumuhu lita asia ne fa a wɔde ngo afra ka nantwimma dumiɛnsa no biara ho. Lita anan ne fa nka adwennini no baako biara ho, ");
INSERT INTO twi_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","na lita abien ne fa nka nguantenmma dunan no biara ho. ");
INSERT INTO twi_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Momfa ɔpapo mmɔ bɔne ho afɔre nka daa ɔhyew afɔre, atoko ne nsa afɔre a mobɔ no daa no ho. ");
INSERT INTO twi_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘Da a ɛto so abien no, momfa anantwi anini mma dumien, adwennini abien ne adwennini a wɔadi afe dunan a wonnii dɛm biara mmɛbɔ afɔre. ");
INSERT INTO twi_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Saa afɔrebɔde yi mu biara no, mode anantwinini, adwennini ne nguantenmma no ho aduan ne nsa afɔrebɔde dodow a wɔahyɛ no bɛka ho. ");
INSERT INTO twi_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Ɔhyew afɔre a mobɔ no daa akyi no, mode ɔpapo bɛka atoko afɔrebɔde ne nsa afɔrebɔde no ho abɔ bɔne ho afɔre. ");
INSERT INTO twi_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘Afahyɛ no da a ɛto so abiɛsa no, mode anantwinini dubaako, adwennini abien, nguantenmma a wɔadi afe no dunan a wonnii dɛm biara; ");
INSERT INTO twi_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","na sɛnea moyɛ no daa no, mode anantwi, adwennini ne nguantenmma no ne aduan ne nsa afɔrebɔde bɛka afɔrebɔde biara ho. ");
INSERT INTO twi_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Ɛsɛ sɛ mode ɔpapo bɔ bɔne ho afɔre de ka daa ɔhyew afɔrebɔ no ho a atoko afɔrebɔde ne nsa afɔrebɔde ka ho. ");
INSERT INTO twi_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘Afahyɛ no da a ɛto so anan no, momfa anantwinini du, adwennini abien, ne nguantenmma a wɔadi afe no dunan a wonnii dɛm biara mmɔ afɔre. ");
INSERT INTO twi_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Momfa atoko afɔrebɔde ne nsa afɔrebɔde dodow a wɔakyerɛ no nka biara ho. ");
INSERT INTO twi_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Momfa ɔpapo baako nyɛ bɔne ho afɔrebɔ nka daa ɔhyew, atoko ne nsa afɔrebɔde no ho. ");
INSERT INTO twi_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘Afahyɛ no da a ɛto so anum no, momfa anantwinini akron, adwennini abien ne nguantenmma a wɔadi afe no dunan a wonnii dɛm biara mmɔ afɔre. ");
INSERT INTO twi_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Momfa atoko ne nsa afɔrebɔde dodow a wɔakyerɛ no nka anantwinini, adwennini ne nguamma afɔrebɔ no ho. ");
INSERT INTO twi_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Momfa ɔpapo baako nyɛ bɔne ho afɔrebɔ nka daa ɔhyew, atoko ne nsa afɔrebɔde no ho. ");
INSERT INTO twi_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘Afahyɛ no da a ɛto so asia no, momfa de anantwinini awotwe, adwennini abien ne nguantenmma a wɔadi afe dunan a wonnii dɛm biara mmɔ afɔre. ");
INSERT INTO twi_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Momfa atoko ne nsa afɔrebɔde dodow a wɔakyerɛ no nka anantwinini, adwennini ne nguantenmma afɔrebɔ no ho. ");
INSERT INTO twi_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Momfa ɔpapo baako mmɔ bɔne ho afɔrebɔ nka daa ɔhyew, atoko ne nsa afɔrebɔde no ho. ");
INSERT INTO twi_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘Afahyɛ no da a ɛto so ason no, momfa anantwinini ason, adwennini abien ne nguamma a wɔadi afe a wonnii dɛm biara dunan mmɔ afɔre. ");
INSERT INTO twi_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Momfa atoko ne nsa afɔrebɔde dodow a wɔakyerɛ no nka anantwinini, adwennini ne nguantenmma afɔrebɔ no ho. ");
INSERT INTO twi_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Momfa ɔpapo baako mmɔ bɔne ho afɔre nka daa ɔhyew, atoko ne nsa afɔrebɔde no ho. ");
INSERT INTO twi_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘Da a ɛto so awotwe no, monyɛ ɔpɔn nhyiamu sononko. Ɛnsɛ sɛ moyɛ adwumaden biara saa da no. ");
INSERT INTO twi_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Mommɔ aduan afɔre a ɔhyew afɔre a ɛwɔ hua a ɛsɔ Awurade ani wɔ mu. Momfa nantwinini baako, Odwennini baako, nguantenmma ason a wɔadi afe a wonnii dɛm mmɔ. ");
INSERT INTO twi_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Momfa atoko ne nsa afɔrebɔde dodow a wɔakyerɛ no nka nantwinini, odwennini ne nguantenmma no ho. ");
INSERT INTO twi_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Momfa ɔpapo baako mmɔ bɔne ho afɔre nka daa ɔhyew, atoko ne nsa afɔrebɔde no ho. ");
INSERT INTO twi_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Mommɔ afɔre yinom mma mo Awurade wɔ mo afahyɛ ahorow no nu: mo hyew, atoko, nsa ne asomdwoe afɔre no; na momfa nka afɔre a mufi mo pɛ mu hyɛ ho bɔ no no ho. Muhyia, didi afirihyia no mu a, twa ara na etwa sɛ mobɔ saa afɔre yi. Na ɛka mo afɔre a mobɔ fa bɔ a moahyɛ anaa nea efi mo pɛ mu a ɛyɛ ɔhyew afɔre, atoko afɔre, nsa afɔre anaa asomdwoe afɔre no ho.’ ” ");
INSERT INTO twi_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Mose kaa saa mmara yi nyinaa kyerɛɛ Israelfo no sɛnea Awurade hyɛɛ no no. ");
INSERT INTO twi_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mose hyiaa Israel mmusua no mu mpanyimfo no ka kyerɛɛ wɔn se, “Awurade ahyɛ se: ");
INSERT INTO twi_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Sɛ obi hyɛ Awurade bɔ anaa ɔka ntam hyɛ bɔ a, ɛnsɛ sɛ obu so. Ɛsɛ sɛ ɔyɛ nea ɔkaa se ɔbɛyɛ no pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Sɛ ababaa bi hyɛ Awurade bɔ anaa ɔka ntam hyɛ bɔ bere a ɔda so te nʼagya fi, ");
INSERT INTO twi_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","na nʼagya no te sɛ ne ba no ahyɛ bɔ, na wanka hwee a, ne bɔhyɛ ne ne ntam a ɔkaa no nyinaa no di mu. ");
INSERT INTO twi_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Nanso sɛ ɛba sɛ nʼagya no siw no bɔhyɛ no ho kwan a, etwa ne bɔhyɛ ne ntam a ɔkae no mu. Awurade de bɛkyɛ ababaa no, efisɛ nʼagya ampene sɛ obedi so. ");
INSERT INTO twi_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Sɛ ɔhyɛ bɔ anaa ɔka ntam ansa na ɔware na ɛbɛyɛ asodi ma no ");
INSERT INTO twi_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","na ne kunu no te saa bɔhyɛ no ho asɛm nanso wanka ho hwee a, na ne bɔhyɛ no gyina hɔ. ");
INSERT INTO twi_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Na sɛ ne kunu no te na osiw no ho kwan a na ɛkyerɛ sɛ watwa mu a bɔhyɛ no anaa ntam no ho asodi nna ne so bio, enti Awurade de ne ho bɛkyɛ no. ");
INSERT INTO twi_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Ɛsɛ sɛ ɔbea kunafo anaa nea wɔagyaa no aware no di ne ntam a ɔbɛka anaa bɔ a ɔbɛhyɛ no biara so. ");
INSERT INTO twi_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Sɛ waware na ɔte ne kunu fi na ɔhyɛ bɔ anaa ɔka ntam, ");
INSERT INTO twi_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","na ne kunu no te na wansiw no ho kwan a, na ɛkyerɛ sɛ ne bɔhyɛ no gyina hɔ. ");
INSERT INTO twi_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Na sɛ ne kunu no te na, sɛ wampene so na, otwa mu a, na ne bɔhyɛ no nni mu na Awurade de ne ho bɛkyɛ no. ");
INSERT INTO twi_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Enti ne kunu no betumi asi ne bɔ a ɔhyɛ anaa ntam a ɔka no so dua anaasɛ obetwa mu. ");
INSERT INTO twi_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Sɛ da mu no nyinaa wanka ho hwee ankyerɛ no de a, na ɛkyerɛ sɛ ɔpene so wɔ hwee a wanka amfa ho no nti. ");
INSERT INTO twi_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Sɛ ɔtwɛn ma mmere bi fa so ansa na ɔka se bɔhyɛ no nni mu a, ɛno de, ɛsɛ sɛ ɔsoa ɔbea no mfomso no ho asodi.” ");
INSERT INTO twi_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Eyinom ne mmara a Awurade nam Mose so de maa ɔbarima ne ne yere, ne agya ne ne babea a ɔda so te ne fi no. ");
INSERT INTO twi_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Esiane sɛ Midianfo daadaa mo de mo kɔɔ abosonsom mu no nti, tɔ so were ma Israelfo no. Eyi akyi no wubewu na woakɔ wʼagyanom nkyɛn.” ");
INSERT INTO twi_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Mose ka kyerɛɛ nkurɔfo so se, “Munyi mo mmarima no mu bi na wɔnkɔ Awurade aweretɔ sa a ɔde tia Midianfo no. ");
INSERT INTO twi_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Momfa Israel abusua biara mu nnipa apem nkɔ ɔsa no.” ");
INSERT INTO twi_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Wɔyɛɛ saa nyaa mmarima mpem dumien siesie wɔn maa ɔko no; Israel abusuakuw biara maa mmarima apem. ");
INSERT INTO twi_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Afei Mose ma wɔkɔe, nnipa apem baako a wofi abusuakuw biara mu. Ɔsɔfo Eleasar babarima Pinehas na odii wɔn anim kɔɔ ɔko no. Wɔrekɔ no, wɔde akronkronne a ɛwɔ kronkronbea hɔ ne ntorobɛnto a wɔbɛhyɛn de ama asraafo no nsɛnkyerɛnne kɔe. ");
INSERT INTO twi_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Wɔne Midiafo no koe, na sɛnea Awurade hyɛɛ Mose no wokum Midian mmarima no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Wɔn a wokum wɔn no bi ne Midian ahemfo baanum a wɔn din de Ewi, Rekem, Sur, Hur ne Reba. Beor babarima Balaam nso, wɔde afoa kum no. ");
INSERT INTO twi_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Afei, Israel asraafo no kyekyeree Midian mmea ne mmofra nyinaa ne wɔn anantwi ne wɔn nguan fom nneɛma pii kaa ho sɛ asade. ");
INSERT INTO twi_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Wɔtoo Midian no atenae, nkurow ne nkuraa nyinaa mu gya, hyew no pasaa. ");
INSERT INTO twi_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Wɔfaa asade ne afowde a nnipa no ne mmoa ka ho. ");
INSERT INTO twi_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Wɔde nnommum no ne ɔko no mu nneɛma a wonyae no nyinaa brɛɛ Mose, ɔsɔfo Eleasar ne Israelfo a na wɔabɔ wɔn atenase wɔ Moab tataw so baabi a na ɛbɛn Asubɔnten Yordan a wotwa fi Yeriko baa hɔ no. ");
INSERT INTO twi_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mose ne ɔsɔfo Eleasar ne mpanyimfo a wotuatua nnipa no ano no fii atenae hɔ kohyiaa nkonimdifo no kwan. ");
INSERT INTO twi_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Nanso Mose bo fuw mpanyimfo a wotuatua nsraadɔm apem ne ɔha no ano a wofi ɔsa no bae no. ");
INSERT INTO twi_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Obisaa wɔn se, “So moankunkum mmea no? ");
INSERT INTO twi_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Wɔn ne nnipa no a wotie Balaam nti wɔtwetwee Israelfo na amma wɔanni Awurade nokware kɔsom abosom wɔ bepɔw Peor so a enti ɛmaa ɔhaw ne abɛbrɛsɛ bebree baa Awurade nkurɔfo so no. ");
INSERT INTO twi_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Munkunkum mmarimaa no nyinaa. Na munkunkum mmea a wɔne mmarima adeda no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mmeawa nketewa a wɔne mmarima nnae no na munnyaa wɔn na mo ne wɔn ntena. ");
INSERT INTO twi_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Ɛsɛ sɛ obiara a wakum obi, anaa ɔde ne nsa kaa nea wɔakum no no, fi atenae ha nkɔtena baabi nnanson. Munnwira mo ho ne mo nnommum no nnansa ne ne nnanson so. ");
INSERT INTO twi_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Munnwira mo ntade ne biribiara a wɔde aboa nhoma, abirekyi nwi anaa dua ayɛ.” ");
INSERT INTO twi_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Afei, ɔsɔfo Eleasar ka kyerɛɛ mmarima a wɔkɔɔ ɔko no se, “Eyi ne mmara a Awurade ahyɛ a waka akyerɛ Mose: ");
INSERT INTO twi_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Sikakɔkɔɔ, dwetɛ, kɔbere, dade, sanyaa, sumpii ");
INSERT INTO twi_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ne biribiara a etumi etumi gyina ogya ano no ɛsɛ sɛ wɔde fa ogya mu sɛnea ɛho bɛtew. Eyi akyi, ɛsɛ sɛ wɔde ahodwira nsu dwira ho ma ɛtew ho. Nanso, biribiara a ɛrentumi nnyina ogya ano no de, wɔmfa nsu nnwira ho. ");
INSERT INTO twi_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Nnanson so no, ɛsɛ sɛ mohoro mo ntade na mo ho afi. Afei mubetumi asan aba atenae hɔ.” ");
INSERT INTO twi_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Ɛsɛ sɛ wo ne ɔsɔfo Eleasar ne mmusua no mpanyimfo nyinaa kan asade a nnipa ne mmoa a mofaa wɔ ɔko no mu no. ");
INSERT INTO twi_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Monkyɛ asade no mu abien pɛpɛɛpɛ mfa fa mma asraafo a wɔkɔɔ ɔko no na momfa fa a aka no mma nnipa a wɔaka no. ");
INSERT INTO twi_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Asraafo a wɔkoo no kyɛfa mu no, munyi ahannum biara so baako; sɛ ɛyɛ nnipa, anantwi, mfurum anaa nguan na momfa nsom Awurade. ");
INSERT INTO twi_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Fa saa kyɛfa yi ma ɔsɔfo Eleasar na onhim no afɔremuka no anim mfa mma Awurade. ");
INSERT INTO twi_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Afei Israelfo a wɔaka no kyɛfa no, munyi aduonum biara mu baako; sɛ ɛyɛ nnipa, anantwi, mfurum, nguanten anaa mmoa foforo biara no, momfa mma Lewifo a wɔhwɛ Awurade Ahyiae Ntamadan no so no.” ");
INSERT INTO twi_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Enti Mose ne ɔsɔfo Eleasar yɛɛ nea Awurade hyɛɛ wɔn sɛ wɔnyɛ no. ");
INSERT INTO twi_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Asade a ɛkae a akofo no fae no dodow yɛ nguan mpem ahansia ne aduɔson anum (675,000); ");
INSERT INTO twi_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","anantwi mpem aduɔson abien (72,000); ");
INSERT INTO twi_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","mfurum mpem aduosia baako (61,000); ");
INSERT INTO twi_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ne mmeawa mpem aduasa abien (32,000). ");
INSERT INTO twi_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Nneɛma no fa a wɔde maa asraafo no dodow ni: Nguan mpem ahaasa aduasa ason ne ahannum (337,500) ");
INSERT INTO twi_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","a wɔde mu ahansia aduɔson anum (675) som Awurade; ");
INSERT INTO twi_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Anantwi mpem aduasa asia (36,000) a wɔde mu aduɔson abien (72) som Awurade; ");
INSERT INTO twi_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","mfurum mpem aduasa ne ahannum (30,500) a wɔde emu aduosia baako (61) som Awurade; ");
INSERT INTO twi_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","mmeawa mpem dunsia (16,000); wɔde wɔn mu aduasa abien (32) som Awurade. ");
INSERT INTO twi_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Kyɛfa a wɔde Awurade no nyinaa no wɔde maa ɔsɔfo Eleasar sɛnea Awurade kyerɛɛ Mose sɛ ɔnyɛ no ara pɛ. ");
INSERT INTO twi_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Asade no a Israelfo no nyaa no na edidi so yi: ");
INSERT INTO twi_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","nguan mpem ahaasa aduasa ason ne ahannum (337,500), ");
INSERT INTO twi_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","anantwi mpem aduasa asia (36,000), ");
INSERT INTO twi_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","mfurum Mpem aduasa ne ahannum (30,500) ne ");
INSERT INTO twi_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","mmeawa mpem dunsia (16,000). ");
INSERT INTO twi_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Nnipa no kyɛfa a wonyae no, Mose yiyii nnommum ne mmoa aduonum biara mu baako de maa Lewifo a wɔhwɛ Awurade Ahyiae Ntamadan so no. Wɔyɛɛ eyi nyinaa sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Afei, asraafo no so mpanyimfo baa Mose nkyɛn ");
INSERT INTO twi_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","bɛka kyerɛɛ no se, “Yɛabu nnipa a yɛde wɔn kɔɔ ɔko no nyinaa ano akyerɛ wo na ɔbaako koraa anyera. ");
INSERT INTO twi_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ɛno nti, yefi nea yenyaa no ɔko no mu no bi mu rebɛda Awurade ase. Yɛn asedade no yɛ sika nnwinne, nkapo, nkaa, asokaa ne kɔnmuade. Eyinom bɛyɛ mpata ama yɛn kra wɔ Awurade anim.” ");
INSERT INTO twi_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mose ne ɔsɔfo Eleasar gyee saa akyɛde yi a ɛyɛ sikakɔkɔɔ ne nnwinne no fii asraafo mpanyimfo no nkyɛn. ");
INSERT INTO twi_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Ne nyinaa mu sikakɔkɔɔ a asahene no de bae sɛ akyɛde a wɔde rebrɛ Awurade no ano si nkaribo kilogram ɔha ne aduɔkron. ");
INSERT INTO twi_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Na asraafo no afa ɔko no mu nneɛma a wonyae no bi. ");
INSERT INTO twi_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Enti Mose ne Eleasar gyee akyɛde no fii asraafo mpanyimfo no hɔ, na wɔde sikakɔkɔɔ no baa Ahyiae Ntamadan no mu sɛ ɛnyɛ nkae ade mma Awurade sɛ Israelfo yɛ ne dea. ");
INSERT INTO twi_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Na Ruben ne Gad mmusuakuw no wɔ nyɛmmoa pii, enti wuhuu sɛ Yaser ne Gilead nsase no beye ama wɔn nguan ne anantwi no. ");
INSERT INTO twi_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Enti wɔkɔɔ Mose ne ɔsɔfo Eleasar ne nnipa no ntuanofo no nkyɛn kɔka kyerɛɛ wɔn se, ");
INSERT INTO twi_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarot, Dibon, Yaser, Nimra, Hesbon, Eleale, Sebam, Nebo ne Beon yɛ ");
INSERT INTO twi_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","nsase a Awurade ako, agye ama Israelfo na eye ma yɛn nguan ne yɛn anantwi. ");
INSERT INTO twi_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Sɛ yɛanya adom wɔ mo anim a, yɛsrɛ mo momfa saa asase yi mma yɛn sɛ yɛn kyɛfa na munnyae Asubɔnten Yordan agya nohɔ a mopɛ sɛ mode ma yɛn no.” ");
INSERT INTO twi_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mose nso bisaa Rubenfo ne Gadfo no se, “Mokyerɛ sɛ, mopɛ sɛ motena ha bere a mo nuanom atwa mu rekɔko? ");
INSERT INTO twi_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Adɛn nti na mopɛ sɛ mubu Israelfo no aba mu ma wɔsan sɛ wɔrenkɔ asase a Awurade de ama wɔn no so no? ");
INSERT INTO twi_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Ade koro yi ara na mo agyanom yɛe. Mesomaa wɔn fii Kades-Barnea sɛ wɔnkɔsra asase no. ");
INSERT INTO twi_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Wowiee nsra no na wofi Eskol subon mu bae no, wobuu nnipa no aba mu sɛ wɔnnkɔ asase a Awurade de ama wɔn no so. ");
INSERT INTO twi_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Da no Awurade abufuw sɔree na ɔkaa saa ntam yi: ");
INSERT INTO twi_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Esiane sɛ wɔamfi wɔn koma nyinaa mu anni mʼakyi nti wɔn mu biara nni hɔ a bere a wɔrefi Misraim no a na wadi mfe aduonu anaa nea ɛboro saa a no behu asase a mehyɛɛ Abraham, Isak ne Yakob ho bɔ no, ");
INSERT INTO twi_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ɔbaako mpo nni hɔ, gye Kenesini Yefune babarima Kaleb ne Nun babarima Yosua, efisɛ wɔde wɔn koma nyinaa dii Awurade akyi, hyɛɛ nnipa nkuran sɛ wɔnkɔ Bɔhyɛ Asase no so.’ ");
INSERT INTO twi_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Awurade maa yekyinkyin sare no so hɔ mfirihyia aduanan kosii sɛ saa awo ntoatoaso amumɔyɛfo no nyinaa wuwui. ");
INSERT INTO twi_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Nanso monhwɛ, abɔnefo, moregyina mo agyanom anan mu ama Awurade bo afuw Israel nea ɛkyɛn so. ");
INSERT INTO twi_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Sɛ mosan fi nʼakyi a, ɔbɛsan agyaw ne nnipa no nyinaa wɔ sare so hɔ na wɔn sɛe no befi mo.” ");
INSERT INTO twi_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Wɔteɛɛ mu se, “Ɛnte saa koraa! Yɛbɛyɛ yɛn nguannan na yɛakyekyere nkurow akɛse ama yɛn mmea ne mmofra. ");
INSERT INTO twi_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Na yɛn ankasa de akode bɛhyehyɛ yɛn ho adi Israelfo a wɔaka no anim akosi sɛ yɛde wɔn bɛba asomdwoe mu ama wɔabɛfa wɔn agyapade. Na nea edi kan no, ɛsɛ sɛ yɛkyekye nkurow a yebegye afasu afa ho ama yɛn nkurɔfo atena mu na ɛhɔfo no ankɔtow anhyɛ wɔn so. ");
INSERT INTO twi_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Sɛ Israelfo no nyinaa nsa nkaa wɔn agyapade no a, yɛrensan mma yɛn afi mu. ");
INSERT INTO twi_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Yɛne wɔn renkyɛ Yordan agya hɔ asase biara, efisɛ yɛanya yɛn agyapade no wɔ Yordan apuei fam hɔ.” ");
INSERT INTO twi_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mose kae se, “Sɛ mobɛyɛ sɛnea moaka no, sɛ mobɛhyehyɛ mo ho wɔ Awurade anim ama ɔko, ");
INSERT INTO twi_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","na mode mo asraafo no atwa Yordan kosi sɛ Awurade bɛpam nʼatamfo no, ");
INSERT INTO twi_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","na sɛ asase no ho asɛm dwo brɛoo wɔ Awurade anim a, ɛno de mutumi san ba. Ɛba saa a, na ɛkyerɛ sɛ, moayɛ mo asɛde ama Awurade ne Israelfo nyinaa. Na asase a ɛda apuei no nso, Awurade de bɛma mo. ");
INSERT INTO twi_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Sɛ moanni asɛm a moaka no so a, na moayɛ bɔne atia Awurade, munhu sɛ, ɛho asotwe bɛba mo so. ");
INSERT INTO twi_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Monkɔ so nkyekyere nkurow mma mo fifo na monyɛ nguannan mma mo nguan na munni asɛm a mokae no nyinaa so.” ");
INSERT INTO twi_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Ruben ne Gad nkurɔfo no kae se, “Yebedi wʼahyɛde no so pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Yɛn mma, yɛn yerenom, yɛn nguan ne yɛn anantwi bɛtena Gilead nkuropɔn mu. ");
INSERT INTO twi_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Nanso yɛn a wɔakyere yɛn sɛ asraafo no bɛko ama Awurade sɛnea woaka no.” ");
INSERT INTO twi_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Enti Mose penee so ka kyerɛɛ Eleasar, Yosua ne mpanyimfo a wotuatua Israel mmusuakuw ano no se, ");
INSERT INTO twi_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Sɛ Gad ne Ruben abusuakuw mu mmarima nyinaa a wɔakyere wɔn ayɛ wɔn asraafo sɛ wɔnkɔko mma Awurade no ne me kɔ Yordan na sɛ wɔkɔko di nkonim wɔ hɔ a, momfa Gilead asase no mma wɔn; ");
INSERT INTO twi_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","na sɛ wɔankɔ a, ɛno de, wɔmpene so mfa nsase a mowɔ wɔ Kanaan asase so no bi.” ");
INSERT INTO twi_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gad ne Ruben abusuafo kaa bio se, “Wo nkoa bedi Awurade asɛm so; ");
INSERT INTO twi_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","yɛde akode bɛhyehyɛ yɛn ho adi Awurade akyi akɔ Kanaan, nanso yɛn ara yɛn asase bɛda Yordan fa ha.” ");
INSERT INTO twi_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Enti Mose ma wɔde Amorihene Sihon ne Basanhene Og nsasetam ne wɔn nkurow akɛse maa Gad, Ruben ne Yosef babarima Manase mmusuakuw. ");
INSERT INTO twi_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gad nkurɔfo na wɔkyekyeree saa nkurow yi: Dibon, Atarot, Aroer. ");
INSERT INTO twi_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrot-Sofan, Yaser Yogbeha, ");
INSERT INTO twi_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet-Nimra ne Betharan. Na ɛyɛ nkurow a nguan wɔ mu yiye. ");
INSERT INTO twi_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ruben mmabarima na wɔkyekyeree saa nkurow a edidi so yi: Hesbon, Eleale ne Kiriataim, ");
INSERT INTO twi_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal-Meon a akyiri no wɔsesaa wɔn din, ne Sibma. Wɔtotoo nkurow a wɔsan kyekyee no din. ");
INSERT INTO twi_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Makir asefo a wofi Manase abusuakuw mu kɔɔ Gilead kɔko dii hɔ so pam Amorifo a saa bere no na wɔte hɔ no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Enti Mose de Gilead maa Makirfo a wɔyɛ Manase asefo no, ma wɔtenaa hɔ. ");
INSERT INTO twi_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Manase abusuakuw mu nnipa foforo bi a wofi Yair nso tenatenaa Gilead nkurow bebree so, sesaa beae a wɔwɔ hɔ no din frɛɛ hɔ Hafrotyair. ");
INSERT INTO twi_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Ɔbarima bi a ne din de Noba dii asraafo bi anim de wɔn kɔɔ Kenat ne ne nkuraase kɔbɔɔ wɔn atenae wɔ hɔ enti ɔde ne din Noba too saa beae hɔ. ");
INSERT INTO twi_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Eyi ne akwantu nhyehyɛe a Israelfo dii so bere a Mose ne Aaron de wɔn fi Misraim no. ");
INSERT INTO twi_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Mose kyerɛw faako a wɔfaa nyinaa sɛnea Awurade kyerɛɛ no sɛ ɔnyɛ no. Eyinom ne mmeae ahorow a wɔsoɛɛ wɔ wɔn akwantu no mu. ");
INSERT INTO twi_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Wosii mu fii Rameses kuropɔn no mu wɔ Twam Afahyɛ a edi kan no akyi ɔsram edi kan da ɛto so dunum. Wɔde akokoduru fii hɔ a Misraimfo no rehwɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Saa bere no na Misraimfo no resie wɔn mmakan a Awurade kunkum wɔn anadwo a ade rebɛkye ama wɔatu kwan no, efisɛ na Awurade de atemmu aba wɔn anyame no nyinaa so. ");
INSERT INTO twi_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Wofii Rameses no, wɔbɛbɔɔ atenae wɔ Sukot. ");
INSERT INTO twi_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Wofii Sukot bɛbɔɔ atenae wɔ Etam, sare no ano. ");
INSERT INTO twi_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Wofii Etam san wɔn akyi baa Pihahirot a ɛwɔ Baal-Sefon apuei fam, na wɔbɔɔ atenae bɛnee bepɔw Migdol. ");
INSERT INTO twi_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Wofi Pihahirot, na wotwaa Po Kɔkɔɔ no kɔɔ sare so. Wɔde nnansa nantew faa Etam sare so kɔbɔɔ atenae wɔ Mara. ");
INSERT INTO twi_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Wofii Mara no, wɔbaa Elim; baabi a na mmura dumien ne mmedua aduɔson wɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Wofii Elim no, wɔbɔɔ atenae wɔ Po Kɔkɔɔ no ho. ");
INSERT INTO twi_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Wofii Po Kɔkɔɔ no ho, kɔbɔɔ atenae wɔ Sin nweatam so. ");
INSERT INTO twi_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Wotu fii Sin sare so kɔbɔɔ atenae Dofka. ");
INSERT INTO twi_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Wofii Dofka kɔbɔɔ atenae wɔ Alus. ");
INSERT INTO twi_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Wofii Alus kɔbɔɔ atenae wɔ Refidim, baabi a na wonnya nsu mma nnipa no nnom. ");
INSERT INTO twi_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Wofii Refidim no, wɔkɔbɔɔ atenae wɔ Sinai sare so. ");
INSERT INTO twi_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Wofii Sinai sare so no, wɔkɔɔ atenae wɔ Kibrot-Hataawa. ");
INSERT INTO twi_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Wofii Kibrot-Hataawa no, wɔkɔbɔɔ atenae wɔ Haserot. ");
INSERT INTO twi_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Wofii Haserot kɔbɔɔ atenae wɔ Ritma. ");
INSERT INTO twi_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Wofii Ritma kɔbɔɔ atenae wɔ Rimon Peres. ");
INSERT INTO twi_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Wofii Rimon Peres kɔbɔɔ atenae wɔ Libna. ");
INSERT INTO twi_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Wofii Libna kɔbɔɔ atenae wɔ Risa. ");
INSERT INTO twi_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Wofii Risa kɔbɔɔ atenae wɔ Kahelata. ");
INSERT INTO twi_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Wofii Kahelata kɔbɔɔ atenae wɔ Sefer Bepɔw so. ");
INSERT INTO twi_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Wofii Sefer Bepɔw so kɔbɔɔ atenae wɔ Harada. ");
INSERT INTO twi_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Wofii Harada kɔbɔɔ atenae wɔ Makhelot. ");
INSERT INTO twi_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Wofii Makhelot kɔbɔɔ atenae wɔ Tahat. ");
INSERT INTO twi_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Wofii Tahat kɔbɔɔ atenae wɔ Tera. ");
INSERT INTO twi_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Wofii Tera kɔbɔɔ atenae wɔ Mitka. ");
INSERT INTO twi_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Wofii Mitka kɔbɔɔ atenae wɔ Hasmona. ");
INSERT INTO twi_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Wofii Hasmona kɔbɔɔ atenae wɔ Moserot. ");
INSERT INTO twi_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Wofii Moserot kɔbɔɔ atenae wɔ Beneyaakan. ");
INSERT INTO twi_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Wofii Beneyaakan kɔbɔɔ atenae wɔ Horhagidgad. ");
INSERT INTO twi_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Wofii Horhagidgad kɔbɔɔ atenae wɔ Yotbata. ");
INSERT INTO twi_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Wofii Yotbata kɔbɔɔ atenae wɔ Abrona. ");
INSERT INTO twi_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Wofii Abrona kɔbɔɔ atenae wɔ Esion-Geber. ");
INSERT INTO twi_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Wofii Esion-Geber kɔbɔɔ atenae wɔ Kades, wɔ Sin sare so. ");
INSERT INTO twi_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Wofii Kades kɔbɔɔ atenae wɔ Bepɔw Hor so, wɔ Edom hye ano. ");
INSERT INTO twi_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Bere a woduu Bepɔw Hor ase no, Awurade ka kyerɛɛ ɔsɔfo Aaron se ɔnkɔ bepɔw no atifi, na ɛhɔ na okowui. Asɛm yi sii mfe aduanan so a Israelfo tu fii Misraim no. ");
INSERT INTO twi_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaron dii mfe ɔha aduonu abiɛsa, bere a owuu wɔ Bepɔw Hor so no. ");
INSERT INTO twi_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Saa bere no ara mu na Kanaanhene Arad a ɔtenaa Negeb wɔ Kanaan asase so no tee sɛ Israelfo no reba nʼasase so. ");
INSERT INTO twi_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Israelfo no toaa wɔn akwantu no so fi Bepɔw Hor so kɔbɔɔ atenae wɔ Salmona. ");
INSERT INTO twi_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Wofii Salmona kɔtenaa Punon. ");
INSERT INTO twi_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Wofii Punon kɔtenaa Obot. ");
INSERT INTO twi_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Wɔtoaa so kɔɔ Iye-Abarim, Moab hye so kɔtenaa hɔ. ");
INSERT INTO twi_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Wofii hɔ no, wɔkɔtenaa Dibon Gad. ");
INSERT INTO twi_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Wofii Dibon Gad kɔtenaa Almon Diblataim. ");
INSERT INTO twi_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Wofii Almon Diblataim kɔtenaa Abarim mmepɔw a ɛbɛn Nebo no so. ");
INSERT INTO twi_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Akyiri no, wotutu fii hɔ twaa mu wɔ Yeriko kɔbɔɔ atenae wɔ Moab tataw so wɔ Asubɔnten Yordan ho. ");
INSERT INTO twi_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Wɔwɔ saa beae hɔ no, wɔtenaa mmeae bebree a ɛbɛn Asubɔnten Yordan ho—efi Bet-Yesimot kosi Abel Sitim a ɛwɔ Moab tataw so no. ");
INSERT INTO twi_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Bere a wɔabɔ atenase wɔ hɔ no na Awurade nam Mose so kasa kyerɛɛ Israelfo no se, ");
INSERT INTO twi_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Sɛ mutwa Asubɔnten Yordan kodu Kanaan asase so a, ");
INSERT INTO twi_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","mompam nnipa a wɔte hɔ no nyinaa na monsɛe wɔn abosom ne ahoni a wɔde abo ayɛ ne nsɔree a wɔasisi no petee mu wɔ mmepɔw so ne mmeae a wɔsom wɔn ahoni no nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Mede asase no ama mo. Momfa na montena so. ");
INSERT INTO twi_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Munnyina ntontobɔ so nkyekyɛ asase no, sɛnea mo mmusua no te. Wɔn a wɔdɔɔso no, wɔbɛma wɔn asase kɛse na wɔn a wosua no nso benya asase ketewa. Sɛnea ntonto no besi abɔ biara no na ɛbɛyɛ wɔn de. Monhwɛ mo agyanom mmusua so mfa nkyekyɛ. ");
INSERT INTO twi_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“Sɛ moampam nnipa a wɔte hɔ no a, wɔbɛyɛ mo ani ase mpe ne mo honam mu nsɔe. Wɔbɛhaw mo wɔ asase a mobɛtena so no so. ");
INSERT INTO twi_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Na mede nea masusuw sɛ mɛyɛ wɔn no, bɛyɛ mo.” ");
INSERT INTO twi_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Ka kyerɛ Israelfo no se: ‘Sɛ mubedu Kanaan asase no so a, asase a mede rema mo sɛ mo ankasa asase no a, sɛɛ na mo ahye bɛyɛ: ");
INSERT INTO twi_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘Asase no anafo fam no bɛyɛ Sin sare so a ɛda Edom hye ano no fa bi. Anafo hye no ano befi apuei fam, Nkyene Po no anafo. ");
INSERT INTO twi_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Ɛbɛtoa so akɔtra Akrabbim wɔ anafo hɔ a ɛrekɔ Sin no. Nʼanafo pa ara no bɛyɛ Kades-Barnea, na efi hɔ akosi Hasarada de akowie Asmon. ");
INSERT INTO twi_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Efi Asmon a, ɔhye no bɛkɔ ara akosi Misraim asuwa no mu na ano akɔpem Ntam Po no ano. ");
INSERT INTO twi_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Mo hye a ɛwɔ atɔe no bɛyɛ Ntam Po no ano. ");
INSERT INTO twi_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Mo hye a ɛda atifi no befi ase wɔ Ntam Po no ano na atoa so akosi bepɔw Hor, ");
INSERT INTO twi_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","de akɔ Lebo Hamat na akɔ Sedad ");
INSERT INTO twi_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","na atoa so akɔ Sifron na akowie wɔ Hasar-Enan. ");
INSERT INTO twi_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Apuei hye no befi Hasar-Enan akɔ Sefam. ");
INSERT INTO twi_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Ɔhye no besian afi Sefam akosi Ribla wɔ Ain apuei fam. Efi hɔ a, ebesiansian afa mmepɔw no ase wɔ Galilea Po no apuei fam. ");
INSERT INTO twi_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Ɔhye no besian afa Asubɔnten Yordan ho na akɔpem Nkyene Po no. “ ‘Sɛnea mo nsase ne mo ahye te ni.’ ” ");
INSERT INTO twi_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Afei Mose hyɛɛ Israelfo no se, “Momfa ntontobɔ so nkyekyɛ asase yi sɛ mo agyapade. Awurade ahyɛ sɛ wɔmfa mma mmusua akron ne fa no, ");
INSERT INTO twi_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","efisɛ Ruben ne Gad mmusuakuw no ne Manase abusua no fa no de, wɔanya wɔn agyapade dedaw. ");
INSERT INTO twi_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Saa mmusua abien ne fa yi anya wɔn agyapade wɔ Yeriko akyi, Yordan apuei fam a ɛhwɛ apuei no.” ");
INSERT INTO twi_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Nnipa a wɔn din didi so yi na mayi wɔn sɛ wɔnkyekyɛ asase no mu mma mo sɛ mo agyapade: Ɔsɔfo Eleasar ne, Nun babarima Yosua. ");
INSERT INTO twi_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Yi abusua biara mu ɔpanyin baako na ɔmmoa nkyekyɛ asase no. ");
INSERT INTO twi_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“Wɔn din na edidi so yi: “Yefune babarima Kaleb, Yuda abusuakuw ntuanoni; ");
INSERT INTO twi_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Amihud babarima Semuel, Simeon abusuakuw ntuanoni; ");
INSERT INTO twi_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Kislon babarima Elidad, Benyamin abusuakuw ntuanoni; ");
INSERT INTO twi_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Yogli babarima Buki, Dan abusuakuw ntuanoni; ");
INSERT INTO twi_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Efod babarima Haniel, Yosef babarima Manase abusuakuw ntuanoni; ");
INSERT INTO twi_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Siftan babarima Kemuel, Yosef babarima Efraim abusuakuw ntuanoni; ");
INSERT INTO twi_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Parknak babarima Elisafan, Sebulon abusuakuw ntuanoni; ");
INSERT INTO twi_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Asan babarima Paltiel, Isakar abusuakuw ntuanoni; ");
INSERT INTO twi_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Selomi babarima Ahihud, Aser abusuakuw ntuanoni; ");
INSERT INTO twi_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Amihud babarima Pedahel, Naftali abusuakuw ntuanoni.” ");
INSERT INTO twi_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Saa nnipa yi na Awurade yii wɔn sɛ wɔnhwɛ nkyekyɛ agyapade no mu mma Israelfo no wɔ Kanaan asase so no. ");
INSERT INTO twi_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Bere a Israelfo bɔɔ atenase wɔ Yordan ho, Moab tataw so wɔ Yeriko akyi no, Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Ka kyerɛ Israelfo no na wɔmfa wɔn agyapade no mu bi a ɛyɛ nkurow ne ɛho mmoa adidibea mma Lewifo no. ");
INSERT INTO twi_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Nkurow no mu na wɔbɛtena na wɔn anantwi, wɔn nguan ne wɔn mmoa a aka no nso akɔ adidi wɔ adidibea hɔ. ");
INSERT INTO twi_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Wɔn mmoa adidibea no kɛse befi kurow no afasu ho a ne fa biara trɛw yɛ anammɔn apem ne ahannum. ");
INSERT INTO twi_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Munsusuw anammɔn mpensa mfi kurow no afasu no ho wɔ nʼafanan nyinaa. Eyi bɛyɛ mmoa adidibea kɛse ama nkurow no. ");
INSERT INTO twi_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Nkurow a mode bɛma Lewifo no no mu asia bɛyɛ guankɔbea nkuropɔn, baabi a obi a wafom akum ɔfoforo no, betumi aguan akɔ. Momfa nkurow aduanan abien nka ho mma wɔn. ");
INSERT INTO twi_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Ne nyinaa bɛyɛ nkurow aduanan awotwe ne ho mmoa adidibea. ");
INSERT INTO twi_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Saa nkurow yi befi Israelfo no agyapade mu. Mmusuakuw no mu akɛse bɛma Lewifo no nkurow bebree na mmusuakuw nketewa no ama kakraa bi. Abusuakuw biara bɛma sɛnea nʼagyapade kɛse te.” ");
INSERT INTO twi_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Awurade ka kyerɛɛ Mose se, ");
INSERT INTO twi_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Ka kyerɛ Israelfo no se, ‘Sɛ mutwa Yordan du Kanaan a, ");
INSERT INTO twi_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","mompaw nkurow bi mfa nyɛ guankɔbea nkurow a, obiara a ɔbɛfom akum onipa no betumi aguan akɔ hɔ. ");
INSERT INTO twi_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Saa nkurow yi bɛyɛ guankɔbea a ebegye no afi owufo no abusuafo a wɔpɛ sɛ wɔtɔ owufo no wu so were no nsa mu; na ɛnsɛ sɛ wokum owudifo no gye sɛ wɔadi nʼasɛm abu no kumfɔ ansa. ");
INSERT INTO twi_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Ɛsɛ sɛ wosisi guankɔbea nkurow yi mu abiɛsa wɔ Kanaan asase so ");
INSERT INTO twi_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","na wosisi abiɛsa nso wɔ Asubɔnten Yordan apuei fam. ");
INSERT INTO twi_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Ɛnyɛ Israelfo nko na ɛhɔ bɛyɛ wɔn guankɔbea, na mmom, ɛbɛyɛ guankɔbea ama ahɔho ne akwantufo nyinaa. ");
INSERT INTO twi_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘Nanso sɛ obi de dade pema sin bi bɔ obi kum no a, wɔfa no sɛ wadi awu enti ɛsɛ sɛ wokum owudifo no. ");
INSERT INTO twi_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Anaasɛ, sɛ wɔde ɔbo kɛse bi bɔ obi ma owu a, ɛyɛ awudi enti ɛsɛ sɛ wokum owudifo no. ");
INSERT INTO twi_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Saa ara nso na sɛ wɔde dua na ekum no a ɛte ara ne no. ");
INSERT INTO twi_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Sɛ ɔweretɔni no hyia owudifo no wɔ baabiara a, ɔwɔ ho kwan sɛ okum no bi. ");
INSERT INTO twi_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Enti sɛ obi nam ɔtan so tow biribi bɔ obi, anaa, sɛ ɔtetɛw no, ");
INSERT INTO twi_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","anaa ɔde abufuw bɔ no kuturuku na onii no wu a, ɔyɛ owudifo nti ɛsɛ sɛ wokum no. ");
INSERT INTO twi_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘Na sɛ emfi ɔtan so na obi sum ɔfoforo, anaa wanhyɛ da na ɔtow biribi ma ɛkɔbɔ obi, ");
INSERT INTO twi_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","anaasɛ wanhu no na ogyaa ɔbo bi a ɛso a ebetumi akum no mu ma ekokum no a, esiane sɛ saa onipa no nyɛ ɔtamfo na onkura adwene bɔne bi nti, ");
INSERT INTO twi_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ɛyɛ bagua no asɛde sɛ wodi asɛm na wɔfa saa mmarakwan yi so bu ɔweretɔni no nea ne nsa apa no ntam atɛn. ");
INSERT INTO twi_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Ɛsɛ sɛ bagua no bɔ nea ne nsa apa no ho ban fi ɔweretɔni no nsam na wɔde nea ne nsa apa no san kɔ guankɔbea kuropɔn a oguan kɔɔ mu no mu. Ɛsɛ sɛ nea ne nsa apa no tena hɔ ara kosi sɛ ɔsɔfopanyin a wɔsraa no ngo bewu. ");
INSERT INTO twi_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘Nanso sɛ nea ne nsa apa no no fi guankɔbea kuropɔn a waguan akɔ mu no no ahye so ");
INSERT INTO twi_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","na ɔweretɔni no hu no wɔ hɔ a obetumi akum no a ɔrenni awudi ho fɔ. ");
INSERT INTO twi_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Ɛsɛ sɛ nea ne nsa apa no tena guankɔbea kuropɔn no mu ara kosi sɛ ɔsɔfopanyin bewu. Ɔsɔfopanyin wu akyi nkutoo na obetumi asan akɔ nʼankasa agyapade ho. ");
INSERT INTO twi_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘Ɛsɛ sɛ eyi yɛ mmara a mudi so wɔ awo ntoatoaso a ɛbɛba no nyinaa mu wɔ baabiara a mobɛtena. ");
INSERT INTO twi_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘Ɛsɛ sɛ wokum obiara a obekum obi, nanso gye sɛ nnansefo a wɔboro onipa baako di tia no ansa na ɛsɛ sɛ wokum no. Sɛ onipa baako pɛ na odi adanse tia no de a, ɛno de, ɛnsɛ sɛ wokum no. ");
INSERT INTO twi_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘Munnnye owudifo a ɛsɛ sɛ owu no ti mpata, nnyina so nnyaa no. Ɛsɛ sɛ wokum no. ");
INSERT INTO twi_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘Munnnye obi a waguan akɔ guankɔbea kuropɔn mu no ti mpata nnyina so mma no nsan mmɛtena nʼasase so bere a ɔsɔfopanyin bi nwui. ");
INSERT INTO twi_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘Munngu asase a mote so no ho fi. Awudi gu asase ho fi, na wɔrentumi nyɛ mpata foforo biara mma asase a wɔahwie mogya agu so gye sɛ wɔde nea ohwiee mogya gui no mogya yɛ okum owudifo no. ");
INSERT INTO twi_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Munngu asase a mote so ne faako a mete no ho fi, efisɛ Me, Awurade no, mete Israelfo no mu.’ ” ");
INSERT INTO twi_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Gilead abusua no ntuanofo, Makir a ɔyɛ Manase babarima ne Yosef nena asefo, kɔɔ Mose ne Israel mmusua ntuanofo no nkyɛn de adesrɛde kɔtoo wɔn anim. ");
INSERT INTO twi_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Wɔkae se, “Awurade hyɛɛ wo se bɔ ntonto na gyina so kyekyɛ asase no ma Israelfo no. Awurade ɔhyɛɛ wo se fa yɛn nuabarima Selofehad agyapade ma ne mmabea. ");
INSERT INTO twi_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Na sɛ ɛba sɛ wɔn mu bi kɔware wɔ abusua foforo mu a, ɔde asase a wɔde ama no no bɛkɔ aware. Sɛ ɛba saa a, yɛn abusua no asase a wɔde ama yɛn no so bɛtew. ");
INSERT INTO twi_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Sɛ Israelfo Mfirihyia Aduonum Afahyɛ no du so a, wɔde wɔn agyapade no bɛka abusua a wɔkɔwaree wɔ mu no de ho, na wobeyi afi yɛn agyanom abusua agyapade mu.” ");
INSERT INTO twi_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Enti Mose de saa ɔhyɛ nsɛm a efi Awurade yi maa Israelfo no: “Yosef abusuakuw mu nnipa no asɛm no yɛ nokware. ");
INSERT INTO twi_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Nea Awurade rehyɛ ama Selofehad mmabea no ni: Wotumi ware ɔbarima biara a wɔpɛ a ofi wɔn agya abusuakuw mu. ");
INSERT INTO twi_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Ɛnsɛ sɛ Israel agyapade biara fi abusuakuw bi mu kɔ abusuakuw foforo nsam, efisɛ ɛsɛ sɛ Israel agyanom abusuakuw biara agyapade tena hɔ sɛnea ɛte no. ");
INSERT INTO twi_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Ɛsɛ sɛ mmabea a wɔwɔ Israel mmusuakuw mu nyinaa a agyapade tumi kɔ wɔn nsam no wareware wɔ wɔn agyanom mmusuakuw mu na Israel abusuakuw biara agyanom agyapade amfi wɔn abusuakuw mu. ");
INSERT INTO twi_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Ɛnsɛ sɛ agyapade biara fi abusuakuw bi nsam kodi ɔfoforo nsam, ɛsɛ sɛ Israel Abusuakuw biara asase a wanya no tena hɔ.” ");
INSERT INTO twi_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Selofehad mmabea no yɛɛ sɛnea Awurade hyɛɛ Mose no. ");
INSERT INTO twi_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Mahla, Tirsa, Hogla, Milka ne Noa nyinaa wareware wɔn agyanom nuabarimanom mma. ");
INSERT INTO twi_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Wɔwarewaree wɔ Yosef babarima Manase mmusua mu enti wɔn agyapade no kaa wɔn abusuakuw no mu. ");
INSERT INTO twi_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Eyinom ne mmara ne nhyehyɛe a Awurade nam Mose so de maa Israelfo wɔ Moab tataw so no, wɔ Asubɔnten Yordan a na wɔafi Yeriko atwa no.");
INSERT INTO twi_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Eyi ne nsɛm a Mose ka kyerɛɛ Israelfo nyinaa wɔ sare no so wɔ Yordan apuei. Wɔbɔɔ atenae wɔ Yordan bon a ɛbɛn Suf, wɔ Paran, Tofel, Laban, Haserot ne Di-Sahab ntam no. ");
INSERT INTO twi_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Efi Horeb de kɔ Kades-Barnea no, ɔkwan a ɛfa bepɔw Seir no, yɛ nnafua dubaako kwan. ");
INSERT INTO twi_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Israelfo fii Bepɔw Sinai no, afe a ɛto so aduanan no ɔsram dubaako no da a edi kan no, Mose kaa nsɛm a Awurade hyɛɛ no sɛ ɔnka nkyerɛ Israelfo no pɛpɛɛpɛ kyerɛɛ wɔn. ");
INSERT INTO twi_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Ɔkaa saa asɛm yi wɔ bere a na wɔadi Amorifo hene Sihon a na odi ade wɔ Hesbon ne Basanhene Og a na odi ade wɔ Astarot ne Edrei so nkonim. ");
INSERT INTO twi_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Yordan apuei fam a ɛwɔ Moab asase so na Mose fii ase kyerɛkyerɛɛ mmara no mu se: ");
INSERT INTO twi_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Awurade ka kyerɛɛ yɛn wɔ Horeb se: “Moatena saa bepɔw yi so akyɛ dodo. ");
INSERT INTO twi_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Muntutu nkɔtena Amorifo nkoko no so; monkɔtena nnipa a wɔbemmɛn Araba mmepɔw no mu ne atɔe mmepɔw ayaase hɔ nyinaa mu; monkɔ Negeb na momfa mpoano nkosi Kanaanfo asase so ne Lebanon nkodu Asubɔnten Eufrate ho. ");
INSERT INTO twi_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Muntie! Mede saa asase yi ama mo. Monkɔ na monkɔfa asase a Awurade hyɛɛ bɔ sɛ ɔde bɛma mo agyanom Abraham, Isak ne Yakob ne wɔn asefo no.” ");
INSERT INTO twi_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Saa bere no, meka kyerɛɛ mo se, “Me nko ara merentumi nyɛ mo ho adwuma. ");
INSERT INTO twi_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Awurade, mo Nyankopɔn, ama mo ase adɔ enti nnɛ yi, mo ase afɛe te sɛ ɔsoro nsoromma. ");
INSERT INTO twi_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Awurade mo agyanom Nyankopɔn mma mo nnɔ mmɔho mpempem na onhyira mo sɛnea wahyɛ mo bɔ no! ");
INSERT INTO twi_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Na ɛbɛyɛ dɛn na me nko metumi asoa mo haw ne mo nnesoa ne mo ntawntaw? ");
INSERT INTO twi_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Mompaw mmarima bi a wɔwɔ nyansa, ntease na wɔwɔ din pa mfi abusuakuw biara mu na memfa wɔn ntuatua mo ano.” ");
INSERT INTO twi_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Mubuaa me se, “Dwuma a woasusuw sɛ wubedi no ye.” ");
INSERT INTO twi_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Enti mede mo mmusuakuw mu mmarima atitiriw, anyansafo a wɔn anim wɔ nyam no tuatuaa mo ano apem apem, ɔha ɔha, aduonum aduonum ne du du so mpanyin ne mo mmusuakuw so sɛ ahwɛfo. ");
INSERT INTO twi_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Na atemmufo a wɔwɔ hɔ saa bere no nso, mehyɛɛ wɔn sɛ, “Sɛ akasakasa ba anuanom ntam, sɛ asɛm no yɛ Israelni ne ne nua bi anaa Israelni ne ɔhɔho bi a, monhwɛ na mummu atɛntrenee. ");
INSERT INTO twi_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Mo atemmu mu, mummmu ntɛnkyew. Muntie ɔketewa ne ɔkɛse pɛ. Munnsuro onipa biara, efisɛ Onyankopɔn na obu atɛn. Asɛm a ɛyɛ den ma mo no, momfa mmrɛ me na minni.” ");
INSERT INTO twi_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Na saa bere no, mekaa biribiara a ɛsɛ sɛ moyɛ kyerɛɛ mo. ");
INSERT INTO twi_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Na sɛnea Awurade hyɛɛ yɛn no, yefii Horeb de yɛn ani kyerɛɛ Amorifo bepɔw a yɛnam sare pradada a moahu no so koduu Kades-Barnea. ");
INSERT INTO twi_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Afei, meka kyerɛɛ mo se, “Moadu Amorifo bepɔw man a Awurade de rema yɛn no so. ");
INSERT INTO twi_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Awurade, mo Nyankopɔn, de asase no ama mo. Momforo nkɔfa, sɛnea Awurade, mo agyanom Nyankopɔn, ka kyerɛɛ mo no. Munnsuro: mommma obi mmu mo aba mu.” ");
INSERT INTO twi_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Na mo nyinaa baa me nkyɛn bɛkae se, “Momma yɛnsoma mmarima nni yɛn anim na wɔnkɔsra asase no so mma yɛn na wɔmmɛka nea wobehu nkyerɛ yɛn na ɛno na ɛbɛkyerɛ yɛn kwan ne nkurow ko a yɛbɛfa so.” ");
INSERT INTO twi_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Na saa nsusuwii yi ye ma me nti mepaw akwansrafo dumien a mo mmusuakuw dumien no mu nnipa biara wɔ mu. ");
INSERT INTO twi_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Wɔforoo bepɔw no na wokoduu Eskol subon mu sraa hɔ. ");
INSERT INTO twi_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Na wɔfaa asase no so aba bi de brɛɛ yɛn. Na wɔkae se, asase a Awurade yɛn Nyankopɔn de ama yɛn no yɛ asase pa. ");
INSERT INTO twi_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Nanso na mompɛ sɛ moforo kɔ soro. Motew Awurade asɛm so atua. ");
INSERT INTO twi_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Munwiinwii wɔ mo ntamadan mu kae se, “Awurade tan yɛn nti na ɔde yɛn fi Misraim de yɛn abɛhyɛ Amorifo nsam sɛ wonkunkum yɛn no. ");
INSERT INTO twi_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Yɛrekɔ he? Yɛn akwansrafo no amanneɛbɔ no abu yɛn aba mu. ‘Wɔka se nnipa yɛ atenten ahoɔdenfo sen yɛn. Wɔn nkurow yɛ akɛse a afasu a wɔatoto afa ho no kɔ sorosoro. Na mpo, yehuu Anakfo wɔ hɔ!’ ” ");
INSERT INTO twi_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Na meka kyerɛɛ mo se, “Mommɔ hu, munnsuro wɔn. ");
INSERT INTO twi_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Awurade di mo anim. Ɔbɛko ama mo sɛnea muhuu no sɛ ɔyɛɛ wɔ Misraim no. ");
INSERT INTO twi_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Na muhuu nso sɛnea Awurade kɔɔ so hwɛɛ mo ntoatoaso wɔ sare so ha sɛnea agya hwɛ ne ba no. Moatwa kwan no nyinaa de abedu beae ha.” ");
INSERT INTO twi_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Nanso eyi nyinaa akyi no, moannya Awurade, mo Nyankopɔn no, mu awerehyɛmu. ");
INSERT INTO twi_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","Ɔno na odii mo akwantu no anim, pɛɛ beae pa maa mo tenae, de ogya dum kyerɛɛ mo kwan anadwo de omununkum dum kyerɛɛ mo kwan awia. ");
INSERT INTO twi_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Awurade tee sɛ morenwiinwii no, ne bo fuw yiye na ɔkaa ntam se, ");
INSERT INTO twi_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Saa awo ntoatoaso bɔne yi mu onipa baako koraa nni hɔ a obehu asase pa a, maka ho ntam sɛ mede bɛma mo agyanom no, ");
INSERT INTO twi_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","gye Yefune babarima Kaleb. Ɔno na obehu saa asase yi. Mede asase a ne nan sii so no bɛma ɔne nʼasefo, efisɛ ɔde ne koma nyinaa dii Awurade akyi.” ");
INSERT INTO twi_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Me nso, esiane mo nti, Awurade bo fuw me. Ɔka kyerɛɛ me se, “Wo nan rensi Bɔhyɛ Asase no so da. ");
INSERT INTO twi_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Na mmom, wo boafo Nun babarima Yosua na obedi ɔmanfo no anim akɔ asase no so. Hyɛ no nkuran, efisɛ obedi Israelfo no anim akɔfa asase no. ");
INSERT INTO twi_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Mede asase no bɛma wo mma a wonnim biribiara. Wo mma a wonnim papa nnim bɔne no a na wusuro sɛ wɔbɛkyere wɔn nnommum no na mede asase no bɛma wɔn. Wɔn na wɔbɛtena asase no so. ");
INSERT INTO twi_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Na wo de, dan wʼani kɔ sare so a ɛkeka kɔ Po Kɔkɔɔ no so hɔ.” ");
INSERT INTO twi_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Ɛno na mugye too mu se “Yɛayɛ bɔne atia Awurade. Yɛbɛkɔ asase no so akɔko sɛnea Awurade aka akyerɛ yɛn no.” Enti mo mu biara faa nʼakode hyehyɛe. Na mususuwii sɛ ɔman a ɛda bepɔw so no sokɔ yɛ mmerɛw. ");
INSERT INTO twi_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Nanso Awurade ka kyerɛɛ me se, “Ka kyerɛ wɔn se, ‘Monnkɔ hɔ nkɔko, efisɛ merenka mo ho nkɔ. Mo atamfo no bedi mo so.’ ” ");
INSERT INTO twi_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Meka kyerɛɛ mo, nanso moantie. Mosɔre tiaa Awurade ahyɛde no na monam ahomaso so foro kɔɔ asase no so kɔkoe. ");
INSERT INTO twi_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Amorifo a wɔte bepɔw no so nso sɔre baa mo so; wɔtaa mo sɛ nnowa, boroo mo fi Seir koduu Horma. ");
INSERT INTO twi_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Afei, mosan ba besuu wɔ Awurade anim, nanso osiw nʼaso a wantie mo su no. ");
INSERT INTO twi_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Ɛno nti, motenaa Kades nna bebree. ");
INSERT INTO twi_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Afei, yɛsan yɛn akyi de yɛn ani kyerɛɛ sare so wɔ baabi a Po Kɔkɔɔ no da hɔ sɛnea Awurade kyerɛɛ me sɛ menyɛ no. Yɛnantenantew faa Seir bepɔw man no ho nna bebree. ");
INSERT INTO twi_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Na Awurade ka kyerɛɛ me se, ");
INSERT INTO twi_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Moatwa afa saa ɔman a ɛda bepɔw yi so no ho mmere sann, enti monnan mo ani nkyerɛ atifi fam. ");
INSERT INTO twi_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Hyɛ ɔman no se, ‘Morebɛfa mo nuanom Edomfo, a wɔyɛ Esau asefo a wɔte Seir no asase so. Edomfo no besuro mo, nanso monhwɛ yiye. ");
INSERT INTO twi_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Monnhyɛ wɔn abufuw a ɛde ɔko bɛba na meremfa wɔn nsase no mu biara mma mo; mpo, baabi a mode mo anan besisi, efisɛ mede Seir bepɔw kurow ama Esau sɛ nʼatenae. ");
INSERT INTO twi_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Aduan biara a mubedi ne nsu biara a mobɛnom no, momfa dwetɛ ntua wɔn ho ka.’ ” ");
INSERT INTO twi_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Awurade, mo Nyankopɔn, ahyira mo nsa ano nnwuma nyinaa. Wahwɛ mo so wɔ mo akwantu wɔ sare kakraa yi nyinaa so. Saa mfe aduanan yi nyinaa mu no, Awurade aka mo ho na hwee ho anhia mo. ");
INSERT INTO twi_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Yetwa faa yɛn nuanom a wɔyɛ Esau asefo a wɔte Seir ho no. Yɛfaa Araba subon kwan no a efi Elat ne Esion-Geber no so na yɛbɛfaa Moab sare so kwan no so. ");
INSERT INTO twi_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Na Awurade ka kyerɛɛ me se, “Monnhaw Moabfo no anaa monhyɛ wɔn abufuw a ɛde ɔko bɛba, na meremfa wɔn nsase no mu biara mma mo. Efisɛ mede Ar ama Lot asefo sɛ agyapade.” ");
INSERT INTO twi_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Kan no na Emifo na wɔte hɔ. Na wɔsoso na wɔdɔɔso a wɔwoware te sɛ Anakfo no. ");
INSERT INTO twi_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Wɔn nso, na wɔyɛ abran sɛ Anakfo no ara pɛ, a na wɔfrɛ wɔn Refaitefo, nanso Moabfo de, na wɔfrɛ wɔn Emifo. ");
INSERT INTO twi_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Kan no na Horifo na wɔte Seir, nanso Esau asefo no tuu wɔn fii hɔ. Wɔsɛee Horifo no tenaa wɔn anan mu sɛnea Israel yɛɛ wɔ asase a Awurade de maa wɔn sɛ wɔn agyapade no so no pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Na Awurade kae se, “Afei, sɔre na kotwa Sered bon no.” Enti yekotwaa obon no. ");
INSERT INTO twi_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Na nna dodow a yɛde nantew fi Kades-Barnea besii sɛ yetwaa Sered bon no yɛ mfirihyia aduasa awotwe. Saa bere no, na mmarima a wɔanyinyin yiye a wobetumi akɔ ɔko no nyinaa awuwu wɔ sare no so sɛnea Awurade kaa ho ntam no. ");
INSERT INTO twi_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Na Awurade nsa tiaa wɔn ara kosi sɛ wɔn nyinaa wuwuu wɔ wɔn atenae hɔ. ");
INSERT INTO twi_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Saa nnipa yi mu akofo a otwa to wuu no pɛ, ");
INSERT INTO twi_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","na Awurade ka kyerɛɛ me se, ");
INSERT INTO twi_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Nnɛ, ɛsɛ sɛ wofa Ar wɔ Moab mantam mu. ");
INSERT INTO twi_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Na sɛ wudu Amonfo mu a, nhaw wɔn anaa nhyɛ wɔn abufuw a ɛde ɔko bɛba, efisɛ meremma mo Amorifo nsase no bi. Mede ama Lot asefo sɛ agyapade.” ");
INSERT INTO twi_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Saa beae hɔ na abran akɛse a na Amonfo frɛ wɔn Samsumifo no te kan no. ");
INSERT INTO twi_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Na wɔyɛ nnipa ahoɔdenfo a wɔdɔɔso na wɔwoware te sɛ Anakfo no. Na Awurade sɛee Samsumifo no wɔ Amonfo anim ma wɔpam wɔn tenaa wɔn anan mu. ");
INSERT INTO twi_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Saa ara na Awurade sɛee Horifo wɔ Esau asefo a na wɔte Seir no anim ma wɔpam wɔn, tenaa wɔn anan mu de besi nnɛ yi. ");
INSERT INTO twi_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Na Awifo a wɔtenaa nkuraa nkuraa trɛw koduu Gasa no nso, Kaftorfo a wofi Kaftor bɛsɛee wɔn, tenaa wɔn anan mu. ");
INSERT INTO twi_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Sɔre kotwa Arnon Subon. Mede Hesbonhene Sihon a ɔyɛ Amorini no ne man ahyɛ wo nsa. Kɔtow hyɛ ne so, na monko, na fa. ");
INSERT INTO twi_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Efi nnɛ yi ara, mede mo ho suro ne hu bɛhyɛ aman a wɔwɔ ɔsoro ase nyinaa mu. Wɔbɛte mo ho nsɛm na wɔn ho bɛpopo na mo nti, wɔanya adwenemhaw esiane mo nti.” ");
INSERT INTO twi_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Mituu abɔfo fii Kedemot sare so kɔɔ Hesbonhene Sihon nkyɛn asomdwoe so kɔka kyerɛɛ no se, ");
INSERT INTO twi_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Ma yentwa mu mfa wo man mu ha. Yɛbɛfa ɔtempɔn no so tee; yɛremman mfa benkum anaa nifa. ");
INSERT INTO twi_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Tɔn aduan ma yenni na tɔn nsu nso ma yɛnnom. Nea yɛrehwehwɛ ara ne ɔkwan a wobɛma yɛn ama yɛanantew atwa mu, ");
INSERT INTO twi_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","sɛnea Esau asefo a na wɔte Seir ne Moabfo a na wɔte Ar yɛɛ yɛn no akosi sɛ yebetwa Yordan akɔ asase a Awurade, yɛn Nyankopɔn, de rema yɛn no so.” ");
INSERT INTO twi_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Nanso Hesbonhene Sihon amma yɛantwa mu wɔ hɔ. Efisɛ na Awurade, mo Nyankopɔn, ayɛ ne honhom sisirii, apirim ne koma sɛnea ɔnam so de no bɛhyɛ mo nsam, sɛnea wayɛ no nnɛ yi. ");
INSERT INTO twi_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Awurade ka kyerɛɛ me se, “Hwɛ, mafi ase de Sihon ne ne man ahyɛ wo nsam. Afei, fi ase na di wɔn so, na fa nʼasase no.” ");
INSERT INTO twi_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Bere a Sihon ne ne dɔm behyiaa yɛn sɛ wɔne yɛn rebɛko wɔ Yahas no, ");
INSERT INTO twi_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Awurade, yɛn Nyankopɔn, yii no maa yɛn ma yɛbobɔɔ ɔno, ne mmabarima ne nʼasraafo nyinaa hwehwee. ");
INSERT INTO twi_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Na yɛfaa ne nkurow nyinaa saa bere no sɛee ne mmarima, mmea ne mmofra a yɛannyaw obiara. ");
INSERT INTO twi_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Mmom, nyɛmmoa ne asade ahorow a ɛwɔ nkurow a yedii so no mu no de, yɛsoa kɔe. ");
INSERT INTO twi_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Efi Aroer a ɛda Arnon Subon ano ne kurow a ɛda subon no mu no, ne mpo, de kosi Gilead no, kurow biara nni hɔ a na ɛsodi yɛ den ma yɛn; Awurade, yɛn Nyankopɔn de ne nyinaa hyɛɛ yɛn nsa. ");
INSERT INTO twi_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Nanso, yɛankɔ Amorifo asase ne asase a ɛda Asubɔnten Yabok ho ne mmepɔw no so nkurow no baabiara a Awurade yɛn Nyankopɔn hyɛɛ yɛn sɛ yɛnnkɔ so no so. ");
INSERT INTO twi_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Afei, yɛde yɛn ani kyerɛɛ Basan kwan so. Basanhene Og ne nʼasrafo nyinaa fi behyiaa yɛn wɔ Edrei ne yɛn koe. ");
INSERT INTO twi_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Nanso Awurade ka kyerɛɛ me se, “Nsuro no, efisɛ mede ɔno ne nʼakofo ne nʼasase nyinaa ahyɛ wo nsa. Sɛnea woyɛɛ Amorihene Sihon a odii ade wɔ Hesbon dii no, yɛ no saa ara.” ");
INSERT INTO twi_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Enti Awurade, yɛn Nyankopɔn, san de Basanhene Og ne nʼakofo nyinaa hyɛɛ yɛn nsa. Yɛbɔɔ wɔn gui a anka wɔn mu baako koraa. ");
INSERT INTO twi_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Saa bere no, yɛfaa ne nkuropɔn nyinaa. Nkuropɔn aduosia no mu baako koraa nni hɔ a yɛannye amfi wɔn nsam. Argob mantam a ɛyɛ Og ahemman wɔ Basan nyinaa. ");
INSERT INTO twi_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Na wɔato afasu atenten afa saa nkuropɔn yi nyinaa ho de nnade apon atoto ano. Saa bere koro no ara mu, yɛfaa nkuraa a na wɔntoo afasu mfaa ho no bebree. ");
INSERT INTO twi_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Yɛsɛee Basan kuropɔn no pasaa sɛnea yɛsɛee Hesbonhene Sihon no. Yɛsɛee nkurow no ne mu mmarima, mmea ne mmofra nyinaa pasapasa. ");
INSERT INTO twi_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Nanso nkuropɔn no mu nyɛmmoa ne asade ahorow no de, yɛsoa kɔe. ");
INSERT INTO twi_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Saa bere no, yɛfaa Amorifo ahemfo baanu no nsase a na ɛdeda Asubɔnten Yordan apuei fam no nyinaa; nsase a efi Arnon subon mu de kosi bepɔw Hermon so nyinaa. ");
INSERT INTO twi_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Sidonfo frɛ no Hermon Sirion na Amorifo frɛ no Senir. ");
INSERT INTO twi_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Yɛfaa nkuropɔn a ɛwɔ bepɔw no atifi no nyinaa so a Gilead ne Basan ka ho de kosi nkurow a ɛwɔ Saleka ne Edrei a na ɛyɛ Og ahemman wɔ Basan no nso ka ho bi. ");
INSERT INTO twi_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Abran no de, Basanhene Og nko na na waka. Ne dade mpa tenten boro anammɔn dumiɛnsa na ne trɛw yɛ anammɔn asia. Ɛda so wɔ Amonfo kuropɔn Raba mu mprempren ara. ");
INSERT INTO twi_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Nsase a yɛfaa no saa bere no, mede ne fa a ɛda fi Aroer Arnon subon mu ne ɔman a ɛda Gilead bepɔw no fa ne ne nkurow no maa Rubenfo ne Gadfo. ");
INSERT INTO twi_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Afei, mede asase no nkae a ɛyɛ Gilead ne Basan nyinaa a na anka ɛyɛ Og ahemman no maa Manase abusua fa no. Na wɔfrɛ Argob mantam a ɛwɔ Basan no nyinaa se Abran asase. ");
INSERT INTO twi_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Manase aseni bi a wɔfrɛ no Yair faa Argob mantam no nyinaa de kosii Gesurfo ne Maakatfo hye so. Ɔde ne din too asase no frɛɛ hɔ Hawot-Yair de besi nnɛ. ");
INSERT INTO twi_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Mede Gilead maa Makir, ");
INSERT INTO twi_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Rubenfo ne Gadfo no, memaa wɔn asase bi a efi Gilead fa bi, kosi Arnon subon ho, de kosii Asubɔnten Yabok a ɛyɛ Amonfo hye no so. ");
INSERT INTO twi_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Atɔe hye no fi Asubɔnten Yordan a ɛda Araba a efi Kineret kosi Araba Po (a ɛne Nkyene Po no) wɔ Pisga bepɔw no ase. ");
INSERT INTO twi_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Na mehyɛɛ mo saa bere no se, “Awurade, mo Nyankopɔn, de asase yi ama mo sɛ momfa. Nanso mo mmarima akofo nyinaa nhyɛ akode nni mo nuanom Israelfo no anim ntwa Yordan. ");
INSERT INTO twi_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Mo yerenom, mo mma ne mo nyɛmmoa bebrebe a minim sɛ mowɔ no de, mubetumi agyaw wɔ nkurow a mede ama mo no so. ");
INSERT INTO twi_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Sɛ Awurade bɔ Israelfo a wɔaka no ho ban na wɔtena asase a Awurade de rema wɔn wɔ Asubɔnten Yordan agya no so a, ansa na mo mu biara betumi asan akɔ asase a mede ama mo no so.” ");
INSERT INTO twi_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Saa bere no, meka kyerɛɛ Yosua se, “Wode wʼani ahu nea Awurade, wo Nyankopɔn, ayɛ saa ahemfo baanu yi nyinaa. Saa ara na ɔbɛyɛ ahemman a ɛwɔ faako a morekɔ no nso. ");
INSERT INTO twi_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Nsuro wɔn, na Awurade, wo Nyankopɔn, bɛko ama wo.” ");
INSERT INTO twi_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Saa bere no, mesrɛɛ Awurade se, ");
INSERT INTO twi_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Otumfo Awurade, woafi ase reda wo kɛseyɛ ne wo nsa a ɛyɛ den no adi akyerɛ wʼakoa. Na onyame bɛn na ɔwɔ ɔsoro anaa asase so a obetumi ayɛ mmaninne te sɛ wo? ");
INSERT INTO twi_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Mesrɛ wo, ma mintwa Yordan nkɔhwɛ asase pa a ɛda hɔ no, Lebanon mmepɔw asase fɛfɛ no.” ");
INSERT INTO twi_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Nanso esiane mo nti, Awurade bo fuw me. Na wantie me. Na Awurade ka kyerɛɛ me se, “Nka saa asɛm yi ho hwee bio nkyerɛ me. ");
INSERT INTO twi_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Foro kɔ Pisga na hwɛ atɔe, atifi, anafo ne apuei. Esiane sɛ, worentwa Yordan no nti, wʼankasa fa wʼani hwɛ asase no. ");
INSERT INTO twi_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Nanso soma Yosua, hyɛ no nkuran na hyɛ no den, efisɛ ɔno na obedi saa nnipa yi anim atwa na wama wɔadi asase a wʼani tua yi.” ");
INSERT INTO twi_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Ɛno nti, yɛtenaa subon a ɛbɛn Bet-Peor no mu. ");
INSERT INTO twi_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Afei, Israel, muntie mmara ne nhyehyɛe a merebɛkyerɛkyerɛ mo yi. Munni so na moanya nkwa, na moatumi akɔ asase a Awurade, mo agyanom Nyankopɔn, de rema mo no so akɔtena hɔ. ");
INSERT INTO twi_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Mommfa bi nka ho, na munnyi biribiara nso mmfi ahyɛde a Awurade, mo Nyankopɔn, de ama me se memfa mma mo no mu, na mmom munni so. ");
INSERT INTO twi_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Mode mo ani huu nea Awurade yɛɛ mo wɔ Baal-Peor no. Ɔsɛee onipa biara a na ɔsom Baal-Peor no. ");
INSERT INTO twi_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Nanso wɔn a na wodi Awurade mo Nyankopɔn nokware nyinaa da so te ase besi nnɛ. ");
INSERT INTO twi_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Sɛ mudu asase a mobɛtena so no so a, eyinom ne mmara ne ahyɛde a makyerɛkyerɛ mo a ɛsɛ sɛ mudi so. Efi Awurade, yɛn Nyankopɔn, nkyɛn. Ɔde ama me se memfa mma mo. ");
INSERT INTO twi_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Sɛ mudi so a, ɛbɛda mo nyansa ne ntease a mowɔ no adi akyerɛ aman a wɔbɛte saa ahyɛde yi nyinaa no na wɔaka se, “Ampa, nnipa yi yɛ ɔman kɛse a wonim nyansa na wɔwɔ ntease.” ");
INSERT INTO twi_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Ɔman kɛse bɛn na ɔwɔ onyame a ɔbɛn wɔn pɛɛ te sɛ Awurade, yɛn Nyankopɔn, a yɛfrɛ no a ogye yɛn so yi? ");
INSERT INTO twi_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Na ɔman kɛse bɛn na ɛwɔ trenee ahyɛde ne mmara sɛ saa mmara yi a mede rema mo nnɛ yi? ");
INSERT INTO twi_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Monhwɛ yiye, na mo ani nna hɔ yiye pa ara na nna dodow a mote nkwa mu no, mo werɛ amfi nea moahu, anaa ampa amfi mo koma mu. Monkyerɛkyerɛ mo mma na awo ntoatoaso a ɛbɛba no nhu. ");
INSERT INTO twi_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Ka kyerɛ wɔn, ne titiriw no, da a mokogyinaa Awurade, mo Nyankopɔn, anim wɔ bepɔw Horeb so a ɔka kyerɛɛ me se, “Frɛ nnipa no wɔ mʼanim na wontie me nsɛm na wɔasua sɛnea wobedi me ni bere dodow a wɔte asase no so na ama wɔatumi akyerɛkyerɛ wɔn mma.” ");
INSERT INTO twi_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Mubegyina bɛnee bepɔw no ase bere a na bepɔw no rehyew na ogyaframa no retu kɔ ɔsoro a omununkum ne esum kabii aduru no. ");
INSERT INTO twi_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Na Awurade kasa fii ogya no mu kyerɛɛ mo. Motee nsɛm no nanso, moanhu no, nne kɛkɛ na ɛbae. ");
INSERT INTO twi_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Ɔdaa nʼapam a ɔkyerɛɛ mo sɛ munni so no adi; Mmaransɛm du a ɔkyerɛw guu abo pon abien so no. ");
INSERT INTO twi_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Saa bere no na Awurade kyerɛɛ me sɛ menkyerɛkyerɛ mo ahyɛde ne mmara a ɛsɛ sɛ mudi so wɔ asase a morebetwa Yordan akɔfa no so. ");
INSERT INTO twi_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Da a Awurade kasa fii ogya mu kyerɛɛ mo wɔ bepɔw Horeb so no moanhu no. Enti monhwɛ mo akwan yiye, ");
INSERT INTO twi_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","na porɔwee annidi mo amma moanyɛ ɔbosom, ohoni bi sɛso; sɛ ɛyɛ ɔbarima anaa ɔbea sɛso, ");
INSERT INTO twi_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","anaa nea ɛsɛ asase so aboa bi, anaa anomaa a otu fa wim, ");
INSERT INTO twi_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","anaa nea ɛsɛ aboa bi a ɔwea wɔ fam anaa apataa bi a ɔwɔ nsu ase. ");
INSERT INTO twi_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Na sɛ mohwɛ wim na muhu owia, ɔsram ne nsoromma, wim abɔde nyinaa a, momma ɛnntwetwe mo mma monnkotow nsom nneɛma a Awurade, mo Nyankopɔn, de ama ɔsoro ase aman no nyinaa no. ");
INSERT INTO twi_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Na mo de, Awurade yii mo fii ogya framfram a ɛnan dade mu wɔ Misraim sɛ mommɛyɛ nʼadiadefo sɛnea mote nnɛ yi. ");
INSERT INTO twi_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Mo nti, Awurade bo fuw me yiye. Ɔkaa ntam se, merentwa Asubɔnten Yordan nkɔ asase pa a Awurade, mo Nyankopɔn, de rema mo sɛ mo agyapade no so. ");
INSERT INTO twi_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Mewu wɔ asase yi so; merentwa Yordan; nanso morebetwa akɔfa asase pa no. ");
INSERT INTO twi_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Monhwɛ yiye na moammu apam a Awurade, mo Nyankopɔn, ne mo ayɛ no so. Monyɛ abosom a ɛyɛ biribiara nsɛso a mo Awurade, mo Nyankopɔn, abra mo no. ");
INSERT INTO twi_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Efisɛ Awurade, mo Nyankopɔn no, yɛ Onyame ninkufo, ogya a ɔhyew ade. ");
INSERT INTO twi_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Moawowo mma anya nananom akyi no na moatena asase no so akyɛ no, sɛ moma porɔwee didi mo na moyɛ ohoni bi nam so yɛ bɔne wɔ Awurade mo Nyankopɔn ani so hyɛ no abufuw a, ");
INSERT INTO twi_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","mefrɛ ɔsoro ne asase sɛ nnansefo de tia mo saa da yi sɛ, mobɛhyew afi asase a moretwa Yordan akɔfa no so. Morentena hɔ nkyɛ na wɔbɛsɛe mo ampa. ");
INSERT INTO twi_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Na Awurade bɛbɔ mo apansam akɔ aman so a mo mu kakraa bi na ɛbɛka wɔ aman a Awuradebɛpam mo akɔ so no so. ");
INSERT INTO twi_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ɛhɔ na mobɛsom onipa nsa ano ahoni a wɔde nnua ne abo na ayɛ, anyame a wonhu ade na wɔnte asɛm na wonnidi nte hua no. ");
INSERT INTO twi_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Ɛhɔ na mobɛpere bio ahwehwɛ Awurade, mo Nyankopɔn no. Na sɛ mode mo koma ne mo kra nyinaa hwehwɛ no a, mubehu no. ");
INSERT INTO twi_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Sɛ ɔhaw bi to mo na eyinom nyinaa ba mo so a, akyiri no, mobɛsan akɔ Awurade, mo Nyankopɔn no, nkyɛn na moayɛ osetie ama no. ");
INSERT INTO twi_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Efisɛ Awurade, mo Nyankopɔn, no yɛ mmɔborɔhunu Nyankopɔn; ɔrennyaw mo na ɔrensɛe mo anaa ne werɛ remfi apam a ɔne mo agyanom pamee a ɔkaa ntam sii so no. ");
INSERT INTO twi_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Hwehwɛ abakɔsɛm mu fi bere a Onyankopɔn bɔɔ nnipa wɔ asase so besi nnɛ yi; hwehwɛ fi ɔsoro ti de kosi ti. Hwɛ sɛ biribi kɛse a ɛte sɛ eyi asi pɛn anaasɛ woate biribi saa pɛn? ");
INSERT INTO twi_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","So nnipa foforo bi ate Onyankopɔn nne sɛ ɔrekasa afi ogya mu sɛnea motee no na wɔda so te ase yi ana? ");
INSERT INTO twi_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","So onyame foforo bi nam ogye a ɔnam amanehunu, nsɛnkyerɛnne a ɛyɛ nwonwa, ɔko, tumidi ne ahodwiriwde so agye ɔman bi afi ɔman foforo bi nsam afa sɛ ne de, sɛnea Awurade, mo Nyankopɔn, yɛ maa mo wɔ Misraim a na mo ani tua no? ");
INSERT INTO twi_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Ɔdaa eyinom nyinaa adi kyerɛɛ mo sɛnea ɛbɛyɛ a mubehu sɛ Awurade yɛ Onyankopɔn a nʼakyi obi nni hɔ. ");
INSERT INTO twi_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Ɔma motee ne nne fi ɔsoro nam so teɛteɛɛ mo so. Ɔma muhuu ne gya fadum asase so na motee ne nsɛm fii ogya no mu. ");
INSERT INTO twi_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Esiane sɛ na ɔpɛ mo agyanom asɛm, na ɔpɛɛ sɛ ohyira wɔn asefo nti na ɔno ara de nʼanim ne ne tumi kɛse no yii mo fii Misraim no. ");
INSERT INTO twi_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Ɔpam aman a na wɔn ho yɛ den sen mo no wɔ mo anim sɛnea ɔde mo bɛba wɔn asase so abɛfa sɛ mo agyapade, sɛnea ɛte nnɛ yi. ");
INSERT INTO twi_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Enti munhu na momma ɛntena mo koma mu nnɛ yi sɛ Awurade yɛ Onyankopɔn wɔ ɔsoro ne asase so. Obi nni hɔ. ");
INSERT INTO twi_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Munni saa ahyɛde ne mmara yi a mede rema mo nnɛ no so na ama asi mo ne mo mma yiye, na moanyin akyɛ wɔ asase a Awurade mo Nyankopɔn de rema mo afebɔɔ no so. ");
INSERT INTO twi_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Afei, Mose yii nkuropɔn abiɛsa bi wɔ Yordan apuei fam ");
INSERT INTO twi_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","a, sɛ ɛba sɛ obi kum obi na wanhyɛ da na onni onipa ko no ho menasepɔw bi a otumi guan kɔ kɔ emu baako so kɔbɔ ne ho aguaa. ");
INSERT INTO twi_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Oyii Beser a ɛda sare ne asase tataw so no maa Rubenfo. Ɔde Ramot a ɛwɔ Gilead no maa Gadfo na ɔde Golan a ɛwɔ Basan no nso maa Manase abusuakuw. ");
INSERT INTO twi_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Eyinom ne mmara a Mose de maa Israelfo no. ");
INSERT INTO twi_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Israelfo no fii Misraim no, akwankyerɛ, mmara ne ahyɛde a Mose de maa wɔn ");
INSERT INTO twi_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","bere a na wɔwɔ obon a ɛbɛn Bet-Peor a ɛda Asubɔnten Yordan apuei fam, wɔ Amorifo hene Sihon a odii ade wɔ Hesbon, a na Mose ne Israelfo no fi Misraim ɛreba no, wɔko dii ne so no. ");
INSERT INTO twi_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Wɔfaa nʼasase no san faa Basanhene Og asase kaa ho. Saa ahemfo baanu yi na wɔyɛ Amorifo ahemfo a wɔte Yordan apuei fam. ");
INSERT INTO twi_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Saa asase yi na efi Aroer a ɛda Arnon subon no ano kosi Sion bepɔw a ɛyɛ Hermon ho. ");
INSERT INTO twi_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Israelfo no san faa nsase a ɛwɔ Araba po no ano wɔ Yordan apuei fam de kosi Nkyene Po wɔ Pisga mmepɔw no ase. ");
INSERT INTO twi_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Mose frɛɛ Israelfo no nyinaa ka kyerɛɛ wɔn se: Israel, muntie, mmara ne ahyɛde a mede rema mo nnɛ no. Munsua na munni so. ");
INSERT INTO twi_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Bere a yɛwɔ Horeb no, Awurade yɛn Nyankopɔn ne yɛn yɛɛ apam bi. ");
INSERT INTO twi_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Ɛnyɛ yɛn agyanom na Awurade ne wɔn yɛɛ apam no, na mmom, ɔne yɛn a yɛte ase nnɛ yi nyinaa na ɛyɛe. ");
INSERT INTO twi_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Awurade fi bepɔw so ogya mu ne mo kasaa anikann. ");
INSERT INTO twi_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Migyinaa mo ne Awurade ntam, na mekaa Awurade asɛm kyerɛɛ mo efisɛ na musuro ogya no nti, moamforo bepɔw no. Nsɛm a ɔkae no ni: ");
INSERT INTO twi_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Mene Awurade, mo Nyankopɔn, a miyii mo fii nkoasom mu wɔ Misraim no. ");
INSERT INTO twi_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Monnsom onyame foforo biara nka me ho. ");
INSERT INTO twi_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Monnyɛ ohoni anaa biribiara a ɛsɛ ade a ɛwɔ wim, anaa nea ɛwɔ asase so, anaa nea ɛwɔ nsu mu, anaa nea ɛwɔ asase ase. ");
INSERT INTO twi_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Monnkotow ohoni biara nsom no wɔ ɔkwan biara so, na me, Awurade, mo Nyankopɔn, meyɛ ninkufo a metwe mma a wɔtan me no aso wɔ awofonom bɔne a wɔyɛ no ho kɔ awo ntoatoaso abiɛsa ne anan mu, ");
INSERT INTO twi_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","nanso meda ɔdɔ adi kyerɛ awo ntoatoaso mpem a wɔdɔ me na wodi mʼahyɛde so no. ");
INSERT INTO twi_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Mommmɔ Awurade, mo Nyankopɔn no, din basabasa. Sɛ moyɛ saa a, obebu mo fɔ. ");
INSERT INTO twi_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Monkae homeda na munni no sɛ da kronkron. ");
INSERT INTO twi_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Nnansia na momfa nyɛ mo nnwuma nyinaa, ");
INSERT INTO twi_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","na da a ɛto so ason no yɛ Homeda ma Awurade, mo Nyankopɔn. Saa da no, ɛnsɛ sɛ moyɛ adwuma biara; ɛnsɛ sɛ mo mmabarima, mo mmabea anaa mo asomfo anaa mo anantwi ne mo mfurum anaa mo ahɔho yɛ adwuma biara. ");
INSERT INTO twi_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Monkae sɛ bere bi a atwa mu no na moyɛ nkoa wɔ Misraim na Awurade, mo Nyankopɔn, nam anwonwatumi ne tumi nnwuma so na oyii mo fii hɔ. Ɛno nti na Awurade mo Nyankopɔn hyɛ mo sɛ munni Homeda no. ");
INSERT INTO twi_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Di wʼagya ne wo na ni sɛnea Awurade, mo Nyankopɔn, ahyɛ mo no, na ama wo nkwanna aware, na asi wo yiye wɔ asase a Awurade wo Nyankopɔn de rema wo no so. ");
INSERT INTO twi_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Nni awu. ");
INSERT INTO twi_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Nsɛe aware. ");
INSERT INTO twi_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Mmɔ korɔn ");
INSERT INTO twi_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Nni wo yɔnko ho adansekurum ");
INSERT INTO twi_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Mma wʼani mmere wo yɔnko yere. Mma wʼani mmere wo yɔnko fi anaa nʼasase anaa nʼakoa anaa nʼafenaa, ne nʼanantwi, nʼafurum anaa biribiara a ɛyɛ wo yɔnko dea.” ");
INSERT INTO twi_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Eyinom ne mmaransɛm a Awurade de nne kɛse a efi ogyaframa no mu pae mu ka kyerɛɛ mo fii omununkum a esum kabii atwa ho ahyia mu wɔ bepɔw no so a wamfa hwee anka ho. Na ɔkyerɛw guu abo pon abien so de maa me. ");
INSERT INTO twi_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Motee nne no fii esum mu bere a bepɔw no so redɛw ogya framfram no, mmusuakuw mu ntuanofo no nyinaa baa me nkyɛn. ");
INSERT INTO twi_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Wɔkae se, “Awurade, yɛn Nyankopɔn, akyerɛ yɛn nʼanuonyam ne ne tumi na yɛate ne nne afi ogya no mu. Nnɛ, yɛahu sɛ, sɛ Onyankopɔn ne onipa kasa koraa a, onipa tumi tena ase. ");
INSERT INTO twi_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Na afei, adɛn nti na ɛsɛ sɛ yewuwu? Sɛ Awurade, yɛn Nyankopɔn, kasa kyerɛ yɛn bio a, akyinnye biara nni ho sɛ yebewu na ogya no ahyew yɛn pasaa. ");
INSERT INTO twi_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Efisɛ ɔkra teasefo bɛn na wate Onyankopɔn teasefo no nne sɛ ɛrekasa fi ogyaframa no mu na watena ase ana? ");
INSERT INTO twi_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Kɔ na kotie nea Awurade, yɛn Nyankopɔn no, ka no. Na afei, bra na bɛka biribiara a ɔka kyerɛɛ wo no kyerɛ yɛn, na yebetie na yɛadi so.” ");
INSERT INTO twi_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Awurade tee mo nne bere a mokasa kyerɛɛ me no, Awurade ka kyerɛɛ me se, “Mate nsɛm a saa nnipa yi ka kyerɛɛ wo no. Nsɛm a wɔkaa no nyinaa ye. ");
INSERT INTO twi_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Ao, sɛ daa wobenya koma sɛnea ɛbɛma wɔasuro me na wɔadi mʼahyɛde nyinaa so a, anka ebeye ama wɔn ne wɔn asefo nyinaa afebɔɔ. ");
INSERT INTO twi_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“Kɔ na kɔka kyerɛ wɔn se, wɔnsan mmra wɔn ntamadan mu. ");
INSERT INTO twi_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Nanso wo de, wo ne me ntena ha sɛnea ɛbɛyɛ a metumi de mʼahyɛde ne me mmara ama wo. Wobɛkyerɛkyerɛ nnipa no sɛnea wobetie wɔ asase a mede rema wɔn no so sɛ wɔn agyapade no.” ");
INSERT INTO twi_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Enti mohwɛ yiye na n monyɛ nea Awurade mo Nyankopɔn ahyɛ mo no; momman mfa nifa anaa benkum. ");
INSERT INTO twi_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Munni nea Awurade, mo Nyankopɔn, ahyɛ mo no nyinaa so na ama moanya nkwa, na asi mo yiye, na no nna aware wɔ asase a morekɔfa no so. ");
INSERT INTO twi_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Eyinom ne ahyɛde, mmara ne nhyehyɛe a Awurade mo Nyankopɔn ka kyerɛɛ me se menkyerɛkyerɛ mo na munni so wɔ asase a moretwa Yordan akɔfa no so, ");
INSERT INTO twi_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","sɛnea ɛbɛyɛ a mo mma ne wɔn mma besuro Awurade, mo Nyankopɔn, mmere dodow a mote ase no, na moadi ne mmara ne nʼahyɛde a mede ma mo no nyinaa so nyinaa so a mo nkwanna aware. ");
INSERT INTO twi_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Muntie, Ao Israel, na monhwɛ yiye nni so sɛnea ɛbɛyɛ a ebesi mo yiye na mo ase atrɛw yiye wɔ asase a nufusu ne ɛwo resen wɔ so no so sɛnea Awurade, mo agyanom Nyankopɔn, hyɛɛ mo ho bɔ no. ");
INSERT INTO twi_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Tie, Ao Israel, Awurade yɛn Nyankopɔn yɛ Awurade koro. ");
INSERT INTO twi_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Dɔ Awurade wo Nyankopɔn fi wo koma nyinaa mu ne wo kra nyinaa mu ne wʼahoɔden nyinaa mu. ");
INSERT INTO twi_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Momma saa mmaransɛm a mede rema wo nnɛ yi ntena mo koma mu. ");
INSERT INTO twi_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Momfa nhyɛ mo mma mu. Sɛ mote fie anaa monam ɔkwan so, sɛ moda hɔ anaa mosɔre a, monka ho asɛm. ");
INSERT INTO twi_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Monkyekye no sɛ agyiraehyɛde mmɔ mo nsa na momfa bi mmɔ abotiri. ");
INSERT INTO twi_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Monkyerɛw ngu mo afi apongua ne mo abobow ano apon so. ");
INSERT INTO twi_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Awurade mo Nyankopɔn de mo ba asase a ɔkaa ntam sɛ ɔde bɛma mo agyanom Abraham, Isak ne Yakob no, asase a nkuropɔn a ɛnyɛ mo na mokyekyeree ahyɛ so ma no so, ");
INSERT INTO twi_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","afi a nneɛma pa ahorow a ɛnyɛ mo na moyɛe ahyɛ no ma, mmura a ɛnyɛ mo na mututui, bobeturo a ɛnyɛ mo na moyɛe ne ngonnua a ɛnyɛ mo na muduae no so. Sɛ mudidi mee wɔ saa asase yi so a, ");
INSERT INTO twi_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","monhwɛ yiye na mo werɛ amfi Awurade a ogyee mo fii nkoasom mu wɔ Misraim asase so no. ");
INSERT INTO twi_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Ɛsɛ sɛ musuro Awurade, mo Nyankopɔn, na mosom ɔno nko ara. Ne din nko ara na momfa nka ntam. ");
INSERT INTO twi_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Munnni anyame foforo akyi; anyame a wɔyɛ nnipa a wɔatwa mo ho ahyia no anyame no; ");
INSERT INTO twi_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","na Awurade mo Nyankopɔn a ɔwɔ mo ntam no yɛ Onyankopɔn ninkufo a nʼabufuw no bɛhyew mo, na ɔbɛsɛe mo afi asase no so. ");
INSERT INTO twi_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Monnsɔ Awurade, mo Nyankopɔn, nhwɛ sɛnea moyɛe bere a na mowɔ Masa no. ");
INSERT INTO twi_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Ɛsɛ sɛ mudi Awurade, mo Nyankopɔn, ahyɛde ne nea ɛwɔ mmara a ɔde ama mo no mu no so pɛpɛɛpɛ. ");
INSERT INTO twi_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Monyɛ de ɛteɛ na eye wɔ Awurade ani so na biribiara awie mo yiye. Na moakɔ akɔfa asase pa a Awurade hyɛɛ ho bɔ kyerɛɛ mo agyanom no, ");
INSERT INTO twi_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","na moapam atamfo a wɔwɔ mo anim no nyinaa sɛnea Awurade kae no. ");
INSERT INTO twi_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Daakye bi, sɛ mo mma bisa mo se, “Saa mmara ne nʼahyɛde a Awurade, yɛn Nyankopɔn, de ama mo yi ase ne dɛn?” ");
INSERT INTO twi_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","a monka nkyerɛ wɔn se, “Na yɛyɛ Farao nkoa wɔ Misraim nanso Awurade nam anwonwatumi so yii yɛn fii Misraim. ");
INSERT INTO twi_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Yɛn ani tua Awurade nsɛnkyerɛnne ne anwonwade akɛse na ɛyɛ hu a ɔyɛ tiaa Misraim, Farao ne ne nkurɔfo nyinaa. ");
INSERT INTO twi_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Oyii yɛn fii Misraim sɛnea ɛbɛyɛ a, obetumi de asase a wahyɛ yɛn agyanom ho bɔ no ama yɛn. ");
INSERT INTO twi_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Na Awurade yɛn Nyankopɔn hyɛɛ yɛn sɛ yenni mmara no nyinaa so na yɛmfa obu ne nidi mma no sɛnea ɛbɛma asi yɛn yiye daakye sɛnea ɛte nnɛ yi. ");
INSERT INTO twi_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Efisɛ sɛ yedi mmara no nyinaa a Awurade, yɛn Nyankopɔn, de ama yɛn no so a, ɛbɛyɛ yɛn trenee.” ");
INSERT INTO twi_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Sɛ Awurade, mo Nyankopɔn, de mo ba asase a morebɛkɔ akɔtena so no so, na ɔpam amanaman pii a wɔwɔ mo anim, a wɔyɛ Hetifo, Girgasifo, Amorifo, Kanaanfo, Perisifo, Hewifo ne Yebusifo, aman ason a wɔwɔ so na wɔyɛ den sen mo, ");
INSERT INTO twi_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","na Awurade, mo Nyankopɔn, de saa aman yi hyɛ mo nsa na mudi wɔn so a, monsɛe wɔn pasapasa. Mo ne wɔn nhyehyɛ apam biara na munnhu wɔn mmɔbɔ. ");
INSERT INTO twi_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Mo ne wɔn nni aware na mommma mo mmabea ne mo mmabarima nware wɔn mmabarima ne wɔn mmabea. ");
INSERT INTO twi_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Efisɛ wɔbɛma mo mma asan afi mʼakyi akɔsom wɔn anyame foforo. Na Awurade abufuw bɛdɛw atia mo na wasɛe mo ntɛm. ");
INSERT INTO twi_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Nea ɛsɛ sɛ moyɛ wɔn ne sɛ, mummubu wɔn afɔremuka na munnwiriw wɔn abosom adum no ngu. Muntwitwa wɔn abosompɔw ngu na monhyew wɔn ahoni. ");
INSERT INTO twi_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Na moyɛ nnipa kronkron a moyɛ, Awurade, mo Nyankopɔn no, de. Nnipa a wɔwɔ asase so nyinaa mu no, mo na Awurade, mo Nyankopɔn, ayi mo sɛ nʼagyapade a ɛsom no bo. ");
INSERT INTO twi_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Ɛnyɛ sɛ modɔɔso sen nnipa a aka no nti na Awurade anya mo ho dɔ no, mo na na musua koraa wɔ nnipa no nyinaa mu. ");
INSERT INTO twi_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Na mmom, Awurade dɔɔ mo na odii ne ntam a ɔka kyerɛɛ mo agyanom sɛ ɔde ne nsa a tumi wɔ mu no beyi wɔn afi nkoasom asase so ne Misraimhene Farao tumi ase no. ");
INSERT INTO twi_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Enti munhu sɛ, Awurade, mo Nyankopɔn, yɛ Onyankopɔn; ɔyɛ nokware Nyankopɔn a odi wɔn a wɔdɔ no na wodi nʼahyɛde so no dɔ apam so kosi awo ntoatoaso apem so. ");
INSERT INTO twi_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Nanso, ɔntwentwɛn na ɔtwe wɔn a wokyi no no aso, sɛe wɔn. ");
INSERT INTO twi_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Ɛno nti, monhwɛ yiye na munni ahyɛde ne mmara a mede rema mo nnɛ yi nyinaa so. ");
INSERT INTO twi_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Sɛ mutie mmara yi na mudi ne nyinaa so nokware mu a, Awurade, mo Nyankopɔn no, nso bedi nʼapam a ofi ne nokware dɔ mu ne mo agyanom pamee no so. ");
INSERT INTO twi_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Ɔbɛdɔ mo na wahyira mo na wama mo ase afɛe. Obehyira mo yafunu mu ade; mo asase so nnɔbae, mo atoko, nsa foforo ne ngodua, mo nantwimma ne nguamma wɔ asase a ɔkaa ho ntam kyerɛɛ mo agyanom se ɔde bɛma mo no so. ");
INSERT INTO twi_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Wobehyira mo akyɛn aman a wɔwɔ asase so no nyinaa. Mo mmarima renyɛ asaadwe na mo mmea nso renyɛ abonin na mo nyɛmmoa nso bɛwowo. ");
INSERT INTO twi_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Na Awurade bɛbɔ mo ho ban afi ɔyare nyinaa ho. Ɔremma owuyare a bi bɔɔ mo wɔ Misraim no bi mmɔ mo na ɔde saa ɔyare no nyinaa begu mo atamfo so. ");
INSERT INTO twi_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Monsɛe aman a Awurade mo Nyankopɔn de bɛhyɛ mo nsa no nyinaa. Munhu wɔn mmɔbɔ na monnsom wɔn anyame. Sɛ moyɛ saa a, ebesum mo afiri. ");
INSERT INTO twi_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Mubebisa mo ho se, “Na sɛ saa aman yi yɛ den kyɛn yɛn. Ɛbɛyɛ dɛn na yɛatumi apam wɔn?” ");
INSERT INTO twi_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Nanso munnsuro wɔn. Monkae ade a Awurade, mo Nyankopɔn, de yɛɛ Farao ne ne manfo nyinaa wɔ Misraim no. ");
INSERT INTO twi_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Mode mo ankasa mo ani huu amanehunu, nsɛnkyerɛnne a ɛyɛ hu ne anwonwasɛm a ɛbaa wɔn so, tumi nsa ne abasa a wɔatrɛw mu a Awurade, mo Nyankopɔn, nam so yii mo fii hɔ no. Nnipa a musuro wɔn mprempren no, Awurade Nyankopɔn de wɔn bɛfa saa ɔkwan koro no ara so. ");
INSERT INTO twi_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Ɛno akyi no, Awurade, mo Nyankopɔn, bɛma mpenaa abɛpam kakra a wɔaka no afi wɔn ahintawee mu kosi sɛ wɔn ase bɛtɔre. ");
INSERT INTO twi_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Munnsuro saa aman no, efisɛ Awurade, mo Nyankopɔn, a ɔso na ne ho yɛ nwonwa no wɔ mo afa. ");
INSERT INTO twi_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Nkakrankakra, Awurade, mo Nyankopɔn, bedi mo anim kan apam saa aman no. Ɔrenyi wɔn nyinaa mfi hɔ prɛko pɛ; anyɛ saa a, nkekaboa no ase bɛdɔ ntɛm na wɔaba mo so. ");
INSERT INTO twi_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Nanso Awurade, mo Nyankopɔn, de wɔn bɛhyɛ mo nsa, na ɔbɛma wɔn adwene ayɛ basabasa akosi sɛ ɔbɛsɛe wɔn. ");
INSERT INTO twi_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Ɔde wɔn ahemfo bɛhyɛ mo nsa na mobɛpepa wɔn din afi ɔsoro ase. Obiara rentumi nsɔre ntia mo; mobɛsɛe wɔn. ");
INSERT INTO twi_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Momfa ogya nhyew wɔn anyame ahoni no. Mommma mo ani mmere dwetɛ anaa sikakɔkɔɔ a egugu so no na mommfa; anyɛ saa a ɛbɛyɛ mfiri ayi mo, efisɛ ɛyɛ Awurade, mo Nyankopɔn, akyiwade. ");
INSERT INTO twi_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Mommfa akyiwade biara mma mo fi na wɔanyi mo angu nkyɛn amma ɔsɛe sɛ ɛno ara pɛ. Munhu no sɛ enye a wokyi korakora; efisɛ wɔayi ato hɔ ama ɔsɛe. ");
INSERT INTO twi_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Monhwɛ yiye na munni ahyɛde a merema mo nnɛ yi biara so, sɛnea ɛbɛyɛ a mubenya nkwa na mo ase adɔ dɔɔso na moakɔfa asase a Awurade kaa ntam de hyɛɛ mo agyanom bɔ no atena so. ");
INSERT INTO twi_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Monkae sɛnea Awurade mo Nyankopɔn dii mo anim faa sare so mfe aduanan, nam so brɛɛ mo ase de sɔɔ mo suban hwɛe sɛ mubedi ne mmara so anaasɛ morenni so no. ");
INSERT INTO twi_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Nokware, ɔmaa ɔkɔm dee mo nam so brɛɛ mo ase na ɔmaa mo mana, aduan a na anka mo ne mo agyanom nnii bi da, dii. Ɔyɛɛ saa de kyerɛɛ mo sɛ, ɛnyɛ aduan nko ara na ɛho hia onipa wɔ nʼasetena mu, na mmom, asɛm biara a efi Awurade anom. ");
INSERT INTO twi_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Mfe aduanan yi nyinaa mu, mo ntade antetew na mo anan ammɔ mpumpunnya na anhonhon nso. ");
INSERT INTO twi_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Munhu wɔ mo koma mu sɛ, sɛnea ɔbeatan teɛ ne ba no, saa ara nso na Awurade, mo Nyankopɔn, teɛ mo de siesie mo no. ");
INSERT INTO twi_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Munni Awurade, mo Nyankopɔn, ahyɛde so na monnantew nʼakwan so na momfa nidi mma no. ");
INSERT INTO twi_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Efisɛ mo Awurade de mo rekɔ asase pa so; asase a nsuten, mmura ne nsuti sen wɔ abon ne mmepɔw mu; ");
INSERT INTO twi_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","asase a atoko, awi, bobe, borɔdɔma, atoaa, ngodua ne ɛwo wɔ so. ");
INSERT INTO twi_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Ɛyɛ asase a aduan abu wɔ so a wonni biribiara ho hia wɔ so; asase a ɛso abo yɛ adaban na wobetumi atu kɔbere wɔ ne mmepɔw mu. ");
INSERT INTO twi_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Sɛ mudidi mee a, munhyira Awurade, mo Nyankopɔn, wɔ asase pa a ɔde ama mo no nti. ");
INSERT INTO twi_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Na monhwɛ yiye na mo werɛ amfi Awurade, mo Nyankopɔn, sɛ morenni ne mmara ne nʼahyɛde a merehyɛ mo nnɛ yi so. ");
INSERT INTO twi_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Anyɛ saa na sɛ mudidi na momee na musisi mo afi afɛfɛ, na mokɔtenatena mu ");
INSERT INTO twi_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","na mo anantwi ne nguan ase dɔ, na munya dwetɛ ne sika pii, na mo agyapade nyinaa dɔɔso ");
INSERT INTO twi_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","a, saa bere no na ɛsɛ sɛ mohwɛ yiye. Monnyɛ ahomaso na mommma mo werɛ mmfi Awurade mo Nyankopɔn a oyii mo fii Misraim nkoasom asase so no. ");
INSERT INTO twi_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Ɔno na odii mo anim yii mo fii sare a na ɛso yɛ hu, asase sakoo a osukɔm wɔ so, na awɔ ne nkekantwɛre a wɔn ano wɔ bɔre wɔ so no so. Ɔmaa mo nsu fi ɔbotan mu. ");
INSERT INTO twi_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Ɔmaa mo mana aduan a mo agyanom nnim dii wɔ sare so. Ɔyɛɛ eyi de brɛɛ mo ase, de sɔɔ mo hwɛe na wama awiei no asi mo yiye. ");
INSERT INTO twi_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Ɔyɛɛ saa de kyerɛɛ mo sɛ, ɛnsɛ sɛ modwene sɛ mo ahonya no fi mo ankasa mo ahoɔden mu. ");
INSERT INTO twi_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Daa monkae sɛ Awurade, mo Nyankopɔn, a ɔma mo tumi ma moyɛ adefo no, ɔyɛ saa de di apam a ɔne mo agyanom hyɛe no so. ");
INSERT INTO twi_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Sɛ mo werɛ fi Awurade, mo Nyankopɔn, na mokodi anyame afoforo akyi, som wɔn, kotow wɔn a, sɛe na wɔbɛsɛe mo. ");
INSERT INTO twi_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Sɛnea Awurade asɛe amanaman a na wɔwɔ mo anim no, mo nso sɛ moantie Awurade, mo Nyankopɔn no a, saa ara na wɔbɛsɛe mo. ");
INSERT INTO twi_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Israel, muntie: Morekotwa Yordan na moawura mu akogye aman a ɛsoso na wɔwɔ ahoɔden kyɛn mo na wɔwɔ nkuropɔn akɛse wɔ mu na wɔn afasu kɔka sorosoro no, agyapade. ");
INSERT INTO twi_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Nnipa no wɔ ahoɔden na wɔwoware; Anakfo! Moate wɔn nka na moate sɛ wɔka se, “Hena na obetumi ne Anakfo agyina?” ");
INSERT INTO twi_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Nanso merehyɛ mo ase nnɛ sɛ, Awurade, mo Nyankopɔn, na ɔredi mo anim te sɛ ogyaframa a ɛresɛe ade. Ɔbɛsɛe wɔn. Ɔbɛbrɛ wɔn ase wɔ mo anim. Na moapam wɔn na moatɔre wɔn ase ntɛm pa ara sɛnea Awurade hyɛɛ mo bɔ no. ");
INSERT INTO twi_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Sɛ Awurade, mo Nyankopɔn, tu wɔn gu a, monnka wɔ mo koma mu se, “Esiane yɛn trenee nti na Awurade de saa asase yi ama yɛn.” Dabi, ɛyɛ aman no amumɔyɛsɛm nti na Awurade redi mo anim apam wɔn. ");
INSERT INTO twi_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Ɛnyɛ sɛ moyɛ atreneefo ne nokwafo nti na morekɔfa wɔn asase no; mmom, efi wɔn amumɔyɛ nti, Awurade, mo Nyankopɔn, bɛpam saa aman yi adi mo anim de ahyɛ ntam a wadi kan aka akyerɛ mo agyanom Abraham, Isak ne Yakob no ma. ");
INSERT INTO twi_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Monte ase sɛ, ɛnyɛ sɛ moyɛ atreneefo nti na Awurade, mo Nyankopɔn, de saa asase pa yi rema mo. Moyɛ ɔman a asoɔden ahyɛ mo ma. ");
INSERT INTO twi_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Monkae eyi na mommma mo werɛ mmfi sɛnea mohyɛɛ Awurade, mo Nyankopɔn abufuw wɔ sare so hɔ no. Efi bere a mutu fii Misraim besi sɛ muduu ha yi, moakɔ so atew Awurade anim atua. ");
INSERT INTO twi_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Mohyɛɛ Awurade abufuw wɔ Horeb a anka ɔpɛ sɛ ɔsɛe mo. ");
INSERT INTO twi_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Mekɔɔ bepɔw no so sɛ merekogye abo kyerɛwpon a na wɔakyerɛw apam a na Awurade ne mo apam no agu so no, metenaa hɔ nnafua aduanan, mannidi na mannom. ");
INSERT INTO twi_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Awurade de apam a ɛwɔ abo kyerɛwpon a Onyankopɔn ankasa akyerɛw nsɛm a ofi ogya a ɛwɔ bepɔw no so no mu ka kyerɛɛ mo no nyinaa maa me. ");
INSERT INTO twi_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Na awia ne anadwo adaduanan no baa awiei no, Awurade de abo pon abien a wɔakyerɛw apam no wɔ so no maa me. ");
INSERT INTO twi_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Afei, Awurade ka kyerɛɛ me se, “Sian fi ha ntɛm kɔ, efisɛ nnipa a wudii wɔn anim fi Misraim no adan abɔnefo. Wɔaman afi ahyɛde a memaa wɔn no ho na wɔayɛ ohoni afa.” ");
INSERT INTO twi_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Na Awurade ka kyerɛɛ me se, “Mahwɛ saa nnipa yi ara ahu sɛ, wɔn aso yɛ den pa ara. ");
INSERT INTO twi_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Ma me kwan na mensɛe na mempepa wɔn din mfi ɔsoro ase. Na menam so mayɛ wʼasefo ɔman kɛse; ɔman a ɛso na ɛwɔ ahoɔden sen sɛnea ɛte nnɛ yi.” ");
INSERT INTO twi_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Enti misian fii ogya bepɔw no so a na mikura abo apon abien a apam no wɔ so no. ");
INSERT INTO twi_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Mehwɛe no, mihuu sɛ moayɛ bɔne atia Awurade, mo Nyankopɔn; Moagu nantwi ba sɛso honi ama mo ho. Moaman afi Awurade kwan a ɔkyerɛɛ mo sɛ momfa so no so ntɛm. ");
INSERT INTO twi_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Enti memaa ɔbo apon no so kɔɔ soro na metow hwee fam. Mibubuu no wɔ mo anim. ");
INSERT INTO twi_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Afei, medaa Awurade anim awia ne anadwo adaduanan a manni brodo, annom nsu. Meyɛɛ eyi, efisɛ sɛ moayɛ ade a Awurade kyi nti, moayɛ bɔne na ɛnam so ama ne bo afuw yiye. ");
INSERT INTO twi_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Misuroo Awurade abufuw ne so asotwe, efisɛ na ne bo afuw yiye a obetumi asɛe mo. Nanso, otiee me bio. ");
INSERT INTO twi_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Na Awurade bo fuw Aaron a na anka ɔpɛ sɛ ɔsɛe no. Nanso mebɔɔ mpae maa Aaron nso. ");
INSERT INTO twi_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Mefaa mo bɔne, nantwi ba a moayɛ no, na menan no wɔ gya mu yam no muhumuhu. Metow ne mfutuma no guu asuwa bi a ɛsen fi bepɔw no mu no mu. ");
INSERT INTO twi_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Mohyɛɛ Awurade abufuw wɔ Tabera, Masa ne Kibrot-Hataawa nso. ");
INSERT INTO twi_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Kades-Barnea nso, Awurade somaa mo wɔ saa ɔhyɛ yi so se, “Monkɔ soro hɔ nkɔfa asase a mede ama mo no.” Nanso mubuu Awurade, mo Nyankopɔn no, ahyɛde so na moamfa mo ho anto no so antie nʼasɛm. ");
INSERT INTO twi_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Efi bere a mihuu mo no, daa mosɔre tia Awurade. ");
INSERT INTO twi_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Ɛno nti na bere a Awurade sii nʼadwene pi sɛ ɔbɛsɛe mo no, mekɔdaa nʼanim awia ne anadwo nnafua aduanan no. ");
INSERT INTO twi_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Mebɔɔ mpae srɛɛ Awurade se, “Otumfo Awurade, nsɛe wo man ne wʼagyapade a wode wo kɛseyɛ agye asi hɔ na wode wo nsa a ɛyɛ den ayi wɔn afi Misraim no. ");
INSERT INTO twi_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Yi wʼani fi saa nnipa yi komapirim ne asoɔden ne wɔn bɔne so na kae wo nkoa Abraham, Isak ne Yakob. ");
INSERT INTO twi_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Anyɛ saa a, Misraimfo no bɛka se, ‘Awurade sɛee wɔn, efisɛ wantumi amfa wɔn ankɔ asase a ɔkaa ntam sɛ ɔde bɛma wɔn no so. Anaasɛ nso, wɔbɛka se, ɔsɛee wɔn, efisɛ ɔtan wɔn; ɔde wɔn baa sare so sɛ ɔrekokunkum wɔn.’ ");
INSERT INTO twi_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Nanso wɔyɛ wo nkurɔfo ne wʼagyapade a wonam tumi a ɛso ne wʼabasa a woatrɛw mu so yii wɔn.” ");
INSERT INTO twi_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","Saa bere no, Awurade ka kyerɛɛ me se, “Twa abo apon no abien te sɛ kan de no na foro bra me nkyɛn wɔ bepɔw no so. Afei, yɛ dua adaka a wobɛkora wɔ mu. ");
INSERT INTO twi_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Mɛkyerɛw nsɛm a mekyerɛw guu abo apon abien a edi kan a wububuu mu no bi pɛpɛɛpɛ agu so. Na fa hyɛ adaka no mu.” ");
INSERT INTO twi_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Na mede dua ɔkanto yɛɛ adaka, sen abo apon abien sɛ kan de no, na meforoo bepɔw no a na mikura apon abien no. ");
INSERT INTO twi_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Awurade kyerɛw nsɛm a wakyerɛw bi dedaw, Mmaransɛm Du, a ɔkaa ho asɛm kyerɛɛ mo fi ogya mu wɔ bepɔw no so wɔ mo nhyiamu ase no guu apon no so. Na Awurade de maa me. ");
INSERT INTO twi_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Na misan fii bepɔw no so na mede abo apon no bɛhyɛɛ adaka a mayɛ no mu sɛnea Awurade hyɛɛ me sɛ menyɛ no, na ɛwɔ hɔ besi nnɛ. ");
INSERT INTO twi_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","Na Israelfo tu fii Beerot-Bene-Yaakan mmura ho kɔɔ Mosera. Ɛhɔ na Aaron wu ma wosiee no. Aaron babarima Eleasar sii nʼanan mu dii sɔfo. ");
INSERT INTO twi_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Wofi hɔ tu kɔɔ Gudgod. Wofi Gudgod no, wɔkɔɔ Yotbata, asase a nsuten pii wɔ so. ");
INSERT INTO twi_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Ɛhɔ na Awurade yii Lewifo abusuakuw sɛ wɔnsoa Awurade apam adaka no na wonnyina Awurade anim nsom no na wɔmfa ne din so nhyira, sɛnea wɔyɛ no nnɛ yi. ");
INSERT INTO twi_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Ɛno nti na Lewifo no nni agyapade wɔ wɔn mfɛfo Israelfo no mu no. Awurade no ankasa ne wɔn agyapade sɛnea Awurade, mo Nyankopɔn, ka kyerɛɛ wɔn no. ");
INSERT INTO twi_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Na metenaa bepɔw no so wɔ Awurade anim adaduanan, awia ne anadwo sɛnea meyɛɛ kan no. Na Awurade tiee me bio. Na ɛnyɛ ne pɛ sɛ ɔbɛsɛe mo. ");
INSERT INTO twi_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Awurade ka kyerɛɛ me se, “Sɔre na di nnipa no anim fa wɔn kɔ asase a mekaa ntam sɛ mede bɛma wɔn agyanom no so na wɔmfa no sɛ agyapade.” ");
INSERT INTO twi_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Na afei, Israel, dɛn na Awurade, mo Nyankopɔn, hwehwɛ afi mo nkyɛn? Ɔhwehwɛ sɛ musuro no na moyɛ nʼapɛde, na mode mo koma ne mo kra nyinaa dɔ no na mosom no, ");
INSERT INTO twi_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","na mudi Awurade ahyɛde ne ne mmara a mede rema mo nnɛ yi so, na asi mo yiye. ");
INSERT INTO twi_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Ɔsorosoro mu soro ne asase ne nea ɛwɔ mu nyinaa yɛ Awurade, mo Nyankopɔn no, de. ");
INSERT INTO twi_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Nanso Awurade nyaa abadae maa mo agyanom na ɔdɔ wɔn, na ɔpaw mo a moyɛ wɔn asefo gyaa aman nyinaa sɛnea ɛte nnɛ yi. ");
INSERT INTO twi_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Ɛno nti, monhohoro mo koma mu bɔne na munnyae asoɔden no. ");
INSERT INTO twi_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Na Awurade, mo Nyankopɔn, yɛ ahene mu hene ne anyame mu nyame. Ɔyɛ Onyankopɔn kɛse, otumfo ne ɔnwonwani a ɔnkyea nʼaso na onnye adanmude nso. ");
INSERT INTO twi_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Ɔko ma nyisaa ne akunafo, na ɔdɔ ahɔho a wɔte mo mu. Ɔma wɔn aduan ne ntama. ");
INSERT INTO twi_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Mo nso, ɛsɛ sɛ modɔ ahɔho, efisɛ bere bi na mo ankasa nso yɛ ahɔho wɔ Misraim asase so. ");
INSERT INTO twi_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Munsuro Awurade, mo Nyankopɔn, na mosom no. Moka mo ho mmata ne ho, na mo ntam a moka nyɛ ne din nko ara. ");
INSERT INTO twi_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Ɔyɛ mo Nyankopɔn a ɛsɛ sɛ mokamfo no. Ɔno na wayɛ anwonwade akɛse a mo nyinaa ahu bi. ");
INSERT INTO twi_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Na mo agyanom a wɔkɔɔ Misraim no nyinaa dodow yɛ aduɔson. Nanso afei, Awurade, mo Nyankopɔn no ama mo ase adɔ te sɛ soro nsoromma. ");
INSERT INTO twi_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Monnɔ Awurade mo Nyankopɔn na munni nʼapɛde, ne mmara ne nʼahyɛde so bere nyinaa. ");
INSERT INTO twi_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Nnɛ, muntie, sɛ ɛnyɛ mo mma na wonyaa osuahu, huu Awurade, mo Nyankopɔn no nteɛso, ne tumi, ne basa kɛse, ne nsa a wateɛ mu; ");
INSERT INTO twi_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","nsɛnkyerɛnne a ɔyɛe ne nneɛma a ɔyɛɛ wɔ Misraim pɛɛ maa bi kaa Misraimhene Farao ne ɔman mu no nyinaa no; ");
INSERT INTO twi_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","dwuma a odii Misraim asraafo, wɔn apɔnkɔ ne wɔn nteaseɛnam no; sɛnea ɔmaa Po Kɔkɔɔ yiri faa wɔn bere a wɔtaa mo no ne sɛnea Awurade sɛee wɔn bere a wɔtaa mo no; ne sɛnea Awurade de ɔsɛe a to ntwa baa wɔn so no. ");
INSERT INTO twi_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Ɛnyɛ mo mma na wohuu nea ɔyɛ maa mo wɔ sare so hɔ de kosii sɛ mubeduu ha yi; ");
INSERT INTO twi_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","ne nea ɔde yɛɛ Eliab a na ɔyɛ Rubenni no mma Datan ne Abiram bere a ɔmma asase buee nʼanom wɔ mo Israelfo no anim menee wɔn ne wɔn afi ne wɔn ntamadan ne biribiara a na ɛyɛ wɔn agyapade a nkwa wɔ mu no. ");
INSERT INTO twi_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Mmom, ɛyɛ mo ankasa mo ani na mode ahu saa nneɛma akɛse a Awurade ayɛ yi nyinaa. ");
INSERT INTO twi_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Enti munni mmara a merehyɛ mo nnɛ yi nyinaa so sɛnea ɛbɛyɛ a mubenya ahoɔden akɔfa asase a morebetwa Yordan akɔ so akɔfa yi, ");
INSERT INTO twi_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","na mo nna aware asase a nufusu ne ɛwo sen wɔ so a Awurade kaa ntam kyerɛɛ mo agyanom sɛ ɔde bɛma wɔn ne wɔn asefo no so. ");
INSERT INTO twi_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Asase a morekɔ so akɔfa no nte sɛ Misraim asase a mufi so bae no a na mudua nnɔbae a mode mo nan twa suka te sɛnea moyɛ atomude turo no. ");
INSERT INTO twi_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Na asase a moretwa Yordan akɔfa no yɛ mmepɔw ne abon a enya osu a efi ɔsoro. ");
INSERT INTO twi_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","Ɛyɛ asase a Awurade, mo Nyankopɔn no, ani wɔ ho. Daa Awurade, mo Nyankopɔn, ani wɔ so fi afe no mfiase de kosi nʼawie. ");
INSERT INTO twi_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Sɛ mufi nokwaredi mu di mmara a merehyɛ ama mo nnɛ yi so sɛ mode mo koma ne mo kra nyinaa bɛdɔ Awurade, mo Nyankopɔn no, na moasom no a, ");
INSERT INTO twi_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ɛno de, ɔbɛtɔ osu agu no asase so ne bere mu ama mo, na moatumi atwa mo awi, nsa foforo ne ngo. ");
INSERT INTO twi_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Ɔbɛma mo sare pii na mo anantwi awe na mo nso mubedidi amee. ");
INSERT INTO twi_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Monhwɛ yiye, anyɛ saa a wɔbɛtwetwe mo ama moakɔsom anyame afoforo na moakotow wɔn. ");
INSERT INTO twi_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Ɛno na ɛbɛma Awurade abufuw ahuru atia mo; na ɔbɛto ɔsoro mu, na osu rentɔ, na asase remmɔ aduan biara, na ɛrenkyɛ na moawuwu afi asase a Awurade de rema mo no so. ");
INSERT INTO twi_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Enti momma me nsɛm yi ntim wɔ mo koma ne mo adwene mu. Momfa nkyekyere mo nsa sɛ nkae ade na momfa mmɔ abotiri. ");
INSERT INTO twi_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Monkyerɛkyerɛ mo mma na monka ho asɛm nkyerɛ wɔn bere a mote fie ne bere a monam akwan so; bere a modeda hɔ ne bere a mosɔre. ");
INSERT INTO twi_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Monkyerɛw ngu mo afi apongua ne mo abobow ano apon so, ");
INSERT INTO twi_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","sɛnea ɛbɛyɛ a, ɔsoro da so kata asase ani yi, mo ne mo mma nkwa bɛware wɔ asase a Awurade kaa ho ntam sɛ ɔde bɛma mo agyanom no so. ");
INSERT INTO twi_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Sɛ mudi ahyɛde ahorow a mede rema mo sɛ munni so; sɛ monnɔ Awurade, mo Nyankopɔn, nyɛ osetie mma no na munni no ni, yi so pɛpɛɛpɛ a, ");
INSERT INTO twi_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","ɛno de, Awurade bɛpam saa aman yi nyinaa wɔ mo anim, na mubetu aman a ɛsoso na wɔyɛ den sen mo no agu. ");
INSERT INTO twi_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Baabiara a mode mo anan betia no bɛyɛ mo de. Mo ahye bɛtrɛw afi sare so akosi Lebanon, na afi Asubɔnten Eufrate akosi Ntam Po no. ");
INSERT INTO twi_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Obiara rentumi nsɔre ntia mo, efisɛ sɛnea Awurade, mo Nyankopɔn, ahyɛ bɔ no, ɔde mo ho huboa ne osuro bɛto asase no nyinaa so wɔ baabiara a mobɛkɔ. ");
INSERT INTO twi_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Hwɛ, nnɛ mede nhyira ne nnome resi mo anim; ");
INSERT INTO twi_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","sɛ mudi Awurade, mo Nyankopɔn, mmara a merehyɛ ama mo nnɛ yi so a, ɛbɛyɛ nhyira. ");
INSERT INTO twi_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Na sɛ mopo Awurade, mo Nyankopɔn mmara dan fi nʼakwan a merehyɛ mo nnɛ yi so, kɔsom anyame afoforo a, ɛbɛyɛ nnome. ");
INSERT INTO twi_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Na sɛ Awurade, mo Nyankopɔn, de mo du asase a morekɔ so akɔfa no a, monka nhyira nsɛm mfi Gerisim Bepɔw no so na monka nnome nsɛm nso mfi Ebal Bepɔw so. ");
INSERT INTO twi_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Sɛnea munim no, mmepɔw abien yi wɔ Asubɔnten Yordan agya wɔ atɔe fam, a ɛkyerɛ owitɔe na ɛbɛn More kwae wɔ Kanaanfo a wɔte Araba no asase so; faako a wɔn ani tua Gilgal no. ");
INSERT INTO twi_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Moreyɛ atwa Yordan akɔfa asase a Awurade, mo Nyankopɔn, de rema mo no. Sɛ mokɔfa saa asase no kɔtena so a, ");
INSERT INTO twi_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","monhwɛ yiye na munni mmara ne ahyɛde ahorow a mede rema mo nnɛ yi no nyinaa so. ");
INSERT INTO twi_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Eyinom ne mmara ne ahyɛde a ɛsɛ sɛ mohwɛ na mudi so, mmere dodow a mote asase a Awurade, mo agyanom Nyankopɔn, de ama mo no so. ");
INSERT INTO twi_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Sɛ mutu aman a wɔtete hɔ no fi hɔ a, mosɛe mmeae ahorow bi sɛ mmepɔw atifi, nkoko so, ne nnua a atrɛtrɛw no ase a wɔsom wɔn anyame no nyinaa. ");
INSERT INTO twi_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Mummubu wɔn afɔremuka nyinaa na monyam wɔn ɔsom adum no. Momfa ogya nhyew wɔn abosompɔw na mommobɔ wɔn ahoni a wɔayeyɛ no. Mompepa wɔn ahoni no din mfi mmeae ahorow a ɛwɔ no. ");
INSERT INTO twi_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Mommfa wɔn akwan no so nsom Awurade, mo Nyankopɔn. ");
INSERT INTO twi_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Na mmom, monhwehwɛ faako a Awurade, mo Nyankopɔn, beyi afi mo mmusuakuw mu ama mo no na munnyina ne din wɔ hɔ sɛ nʼatenae. Beae hɔ na ɛsɛ sɛ mokɔ. ");
INSERT INTO twi_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Ɛhɔ na momfa mo hyew afɔrebɔde mmra mmɛbɔ a mo ntotoso du du, akyɛde sononko, ade a moaka ho ntam sɛ mode bɛba ne afɔrebɔde a efi mo pɛ mu, mo anantwi ne mo nguan mu mmakan nso nka ho. ");
INSERT INTO twi_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Ɛhɔ, Awurade, mo Nyankopɔn no anim hɔ no, na mo ne mo abusuafo bedidi na mo ani agye wɔ biribiara a mode mo nsa aka ho, efisɛ Awurade, mo Nyankopɔn, ahyira mo. ");
INSERT INTO twi_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Nnɛ yi, nea mopɛ biara na moyɛ, nanso ɛnsɛ sɛ ɛba saa, ");
INSERT INTO twi_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","efisɛ munnuu ahomegyebea ne agyapade a Awurade, mo Nyankopɔn, de rebɛma mo no hɔ ɛ. ");
INSERT INTO twi_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Nanso mubetwa Asubɔnten Yordan akɔtena asase a Awurade, mo Nyankopɔn, de rema mo sɛ agyapade no so. Na ɔbɛma mo ahomegye ne bammɔ afi mo atamfo a wɔatwa mo ho ahyia no nsam na moatena ase dwoodwoo. ");
INSERT INTO twi_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","Momfa biribiara a mehyɛ mo sɛ momfa mmra sɛ ɛyɛ mo ɔhyew afɔrebɔde, ntotoso du du, akyɛde sononko ne mo ɔma ahorow no mfa nhyɛ mo ntanka no mu kena wɔ beae a Awurade, mo Nyankopɔn, beyi ama mo a sɛ monsɔre ne din wɔ hɔ no. ");
INSERT INTO twi_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Mo ne mo mmabarima, mo mmabea ne mo nkoa nyinaa nnye mo ani wɔ hɔ wɔ Awurade, mo Nyankopɔn no, anim. Na monkae Lewifo a wɔtete mo nkurow so no a wonni wɔn ankasa agyapade no. ");
INSERT INTO twi_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Monhwɛ yiye na moammɔ mo hyew afɔre wɔ baabiara a mopɛ. ");
INSERT INTO twi_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Mommɔ wɔ baabi pɔtee a Awurade ayi afi mo mmusua asase bi mu ama mo no nkutoo. Ɛhɔ na monyɛ biribiara a mehyɛ mo sɛ monyɛ no. ");
INSERT INTO twi_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Nanso kurow biara a mopɛ so no, mutumi kum mmoa we sɛnea mukum atwe ne adabɔ no. Mutumi we nam dodow biara a Awurade, mo Nyankopɔn, de behyira mo no. Wɔn a wɔn ho tew ne wɔn a wɔn ho ntew no nyinaa tumi we bi. ");
INSERT INTO twi_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Nanso ɛnsɛ sɛ mudi mogya no. Muntwa ngu fam te sɛ nsu. ");
INSERT INTO twi_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Ɛnsɛ sɛ mudi mo afɔre, ntotoso du du a efi mo atoko mu, mo nsa foforo ne ngo anaa mo anantwi ne mo nguan abakan wɔ mo kurow mu. Biribiara a moaka ho ntam sɛ mode bɛma Awurade anaa nea mufi mo koma mu ahyɛ ho bɔ anaa akyɛde sononko biara no, ɛnsɛ sɛ mudi. ");
INSERT INTO twi_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Mmom, ɛsɛ sɛ mudi wɔ Awurade, mo Nyankopɔn, anim wɔ faako a Awurade, mo Nyankopɔn no, bɛkyerɛ mo a mo, mo mmabarima ne mo mmabea, mo nkoa ne mo mfenaa ne Lewifo a wofi mo nkurow mu ka ho no, munnye mo ani wɔ Awurade, mo Nyankopɔn no, anim wɔ biribiara a mobɛyɛ no ho. ");
INSERT INTO twi_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Monhwɛ yiye na moanyi Lewifo no mu wɔ mmere dodow a mote mo asase so no. ");
INSERT INTO twi_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Sɛ Awurade, mo Nyankopɔn, trɛw mo hye mu sɛnea wahyɛ mo ho bɔ no, na sɛ mo kɔn dɔ nam ka se, “Yenya nam bi a anka yɛbɛwe” a, ɛno de, mubetumi awe nam dodow biara a mopɛ. ");
INSERT INTO twi_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Sɛ faako a Awurade, mo Nyankopɔn no, ayi ama mo sɛ monkamfo ne din hɔ no ne mmeae a mowɔ no ntam ware a, mutumi kum mo anantwi anaa nguan a Awurade de ama mo no dodow biara a mopɛ no wɔ mo afi mu sɛnea mahyɛ mo no. ");
INSERT INTO twi_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Monwe sɛnea mowe atwe anaa adabɔ. Wɔn a wɔn ho ntew ne wɔn a wɔn ho tew no nyinaa tumi we bi. ");
INSERT INTO twi_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Monhwɛ sɛ morenni mogya no, efisɛ mogya no ne nkwa no, na ɛnsɛ sɛ mudi nkwa no ne nam no. ");
INSERT INTO twi_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Munni mogya no; mmom, munhwie ngu fam sɛ nsu. ");
INSERT INTO twi_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Munnni mogya no na asi mo ne mo mma yiye, efisɛ moyɛ saa a na moayɛ nea ɛteɛ wɔ Awurade ani so. ");
INSERT INTO twi_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Momfa mo nneɛma a moatew ho ne nea moaka ho ntam sɛ mobɛma biara no, na monkɔ beae a Awurade bɛpaw no. ");
INSERT INTO twi_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Momfa mo ɔhyew afɔre, nam ne mogya no nyinaa, ngu Awurade, mo Nyankopɔn no, afɔremuka so. Ɛsɛ sɛ muhwie mo afɔrebɔde no mogya no gu Awurade, mo Nyankopɔn no, afɔremuka no nkyɛn. Mmom, mubetumi awe nam no. ");
INSERT INTO twi_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Monhwɛ sɛ mubedi mmara ahorow a mede rema mo yi nyinaa so, na asi mo ne mo mma a wɔbɛba wɔ mo akyi no yiye, efisɛ ɛno na ɛbɛyɛ nea eye ne nea ɛteɛ wɔ Awurade, mo Nyankopɔn no ani so. ");
INSERT INTO twi_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Na Awurade, mo Nyankopɔn no, bedi mo anim kan akɔsɛe aman a morekɔtoa wɔn no na mopam wɔn. Na sɛ mopam wɔn kɔtena wɔn nsase no so, ");
INSERT INTO twi_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","na sɛ wonya di mo anim sɛe wɔn a, monhwɛ yiye na moammisa wɔn anyame no ase anka se, “Ɔkwan bɛn so na saa aman yi fa som wɔn anyame? Yɛpɛ sɛ yɛyɛ saa bi,” amfa so ankɔtɔ afiri mu. ");
INSERT INTO twi_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Mommfa wɔn kwan so nsom Awurade, mo Nyankopɔn no, efisɛ wɔn anyame no som mu no, wɔyɛ akyiwade ahorow a Awurade kyi no nyinaa mpɛ. Mpo, wɔhyew wɔn mmabarima ne wɔn mmabea wɔ ogya sɛ wɔde rebɔ afɔre ama wɔn anyame no. ");
INSERT INTO twi_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Monhwɛ sɛ mubedi nea mahyɛ mo no nyinaa so; mommfa bi nka ho na munnyi bi nso mfi mu. ");
INSERT INTO twi_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Sɛ odiyifo anaa obi a ɔnam adaeso so ka ahintasɛm sɔre wɔ mo mu na ɔka nsɛnkyerɛnne a ɛyɛ hu ne anwonwasɛm kyerɛ mo, ");
INSERT INTO twi_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","na sɛ nsɛnkyerɛnne anaa anwonwasɛm no ba mu na ɔka se, “Momma yenni anyame afoforo akyi (anyame a munnim wɔn) na yɛnsom wɔn” a, ");
INSERT INTO twi_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","ɛnsɛ sɛ mutie saa odiyifo anaa ɔdaesofo no nsɛm. Awurade, mo Nyankopɔn, resɔ mo ahwɛ sɛ mufi mo koma ne mo kra mu nyinaa dɔ no ana. ");
INSERT INTO twi_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Awurade, mo Nyankopɔn no, na ɛsɛ sɛ mudi nʼakyi na ɔno na ɛsɛ sɛ mode obu ne nidi ma no. Munni ne mmara so na monyɛ osetie mma no; monsom no na mommata ne ho den. ");
INSERT INTO twi_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Ɛsɛ sɛ wokum saa odiyifo anaa ɔdaesofo no, efisɛ ɔkasa tia Awurade, mo Nyankopɔn no, a oyii mo fii Misraim nkoasom asase no so no; wayere ne ho sɛ ɔpɛ sɛ ɔtwe mo fi ɔkwan a Awurade, mo Nyankopɔn no, ahyɛ sɛ momfa so no so. Ɛsɛ sɛ mututu abɔnefo nyinaa fi mo mu. ");
INSERT INTO twi_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Sɛ wo nuabarima, wo babarima, wo babea, wo yere a wodɔ no anaa wʼadamfo pa bi fa sum ase twetwe wo, ka kyerɛ wo se, “Momma yɛnkɔsom anyame afoforo, anyame a wo anaa wʼagyanom nhuu bi da,” ");
INSERT INTO twi_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","anyame a ɛyɛ nnipa a atwa wo ho ahyia no de, sɛ wɔbɛn anaa wɔwɔ akyiri, fi asase ano kosi ano no a, ");
INSERT INTO twi_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","mommfa wo ho mma no anaasɛ ntie no. Nhu no mmɔbɔ. Mfa ne ho nkyɛ no na mmɔ ne ho ban nso. ");
INSERT INTO twi_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","Kum na ɛsɛ sɛ mukum no. Mo nsa na momma enni kan wɔ ne kum no mu ansa na nnipa nyinaa de wɔn nsa abɛka ho. ");
INSERT INTO twi_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Munsiw no abo nkum no, efisɛ ɔpɛɛ sɛ ɔtwe mo fi Awurade, mo Nyankopɔn no, a oyii mo fii Misraim nkoasom asase so no ho. ");
INSERT INTO twi_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Afei, Israel nyinaa bɛte na wɔasuro na obiara nni hɔ a obefi mo mu a, ɔbɛyɛ saa ade no bio. ");
INSERT INTO twi_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Sɛ ɛba sɛ mote wɔ nkurow a Awurade, mo Nyankopɔn, de rema mo no baako so sɛ ");
INSERT INTO twi_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","nnipa bɔnefo bi asɔre wɔ wɔn mu adi nnipa a wɔwɔ kurow no mu anim de wɔn akosi bɔne mu aka se, “Momma yɛnkɔsom anyame afoforo,” anyame a munhuu bi da a, ");
INSERT INTO twi_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","ɛsɛ sɛ mubisa mu, hwehwɛ mu yiye. Na sɛ ɛyɛ nokware na sɛ nhwehwɛmu ada no adi sɛ nneyɛe bɔne bi akɔ so wɔ mo mu a, ");
INSERT INTO twi_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","ɛsɛ sɛ wɔde afoa kunkum wɔn a wɔwɔ kurow no mu nyinaa. Monsɛe kurow no pasapasa, emu nnipa ne nyɛmmoa. ");
INSERT INTO twi_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","Afei, mommoaboa asade no nyinaa ano wɔ kurow no aguabɔbea na monhyew no. Monhyew kurow mu no ne emu nneɛma nyinaa mma ɛnyɛ sɛ ɔhyew afɔre mma Awurade, mo Nyankopɔn no. Saa kurow no nyɛ amamfo daa; ɛnsɛ sɛ wɔsan kyekyere bio. ");
INSERT INTO twi_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","Asade a wɔde agu nkyɛn sɛ wɔbɛsɛe no no, mommfa bi. Saayɛ na ɛbɛma Awurade adan afi nʼabufuwhyew no ho na wahu mo mmɔbɔ. Ne yam bɛhyehye no ama mo na wama mo adɔ sɛnea ɔkaa ntam hyɛɛ mo agyanom bɔ no, ");
INSERT INTO twi_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","efisɛ moyɛ osetie ma Awurade, mo Nyankopɔn no, na mudi ne mmara a mede rema mo nnɛ yi so na moyɛ nea ɛsɔ nʼani. ");
INSERT INTO twi_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Moyɛ Awurade, mo Nyankopɔn no, mma. Ɛno nti monnsesa mo ho anaa monntworɔtworɔw mo moma so mma awufo, ");
INSERT INTO twi_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","efisɛ, moyɛ nnipa kronkron ma Awurade, mo Nyankopɔn no. Nnipa a wɔwɔ asase so nyinaa, mo na Awurade ayi mo sɛ nʼagyapade a ɛsom bo. ");
INSERT INTO twi_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Munnni akyiwade biara. ");
INSERT INTO twi_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Eyinom ne mmoa a ɛsɛ sɛ mowe: nantwi, oguan, abirekyi ");
INSERT INTO twi_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","ɔforote, adowa, ɔwansan, ewi, ɔtwe, ne ɛko. ");
INSERT INTO twi_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","Na munni tɔteboa biara a ne tɔte mu apae abien na opuw wosaw. ");
INSERT INTO twi_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Nanso ntɔteboa a wopuw wosaw anaa wɔn tɔte mu apae abien no mu no, monnwe yoma, adanko ne atwaboa, efisɛ, wopuw wosaw de, nanso wɔn tɔte mu mpae; wɔn ho ntew mma mo. ");
INSERT INTO twi_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","Prako nso ho ntew. Ɛwɔ mu sɛ ne tɔte mu apae de, nanso ompuw nwosaw. Ɛnsɛ sɛ mowe ne nam anaa mode mo nsa so ne funu mu koraa. ");
INSERT INTO twi_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","Nsumnam a wɔwɔ ntɛtɛ ne abon nyinaa mutumi we. ");
INSERT INTO twi_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","Nanso nsumnam a wonni ntɛtɛ ne abon de, monnwe. Wɔn ho ntew mma mo. ");
INSERT INTO twi_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Anomaa biara a ne ho tew no, monwe. ");
INSERT INTO twi_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","Nnomaa a ɛnsɛ sɛ mowe ni: ɔkɔre, opete, asu so kɔre, ");
INSERT INTO twi_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","ɔkompete, nkorɔma ahorow nyinaa ");
INSERT INTO twi_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","kwaakwaadabi ahorow nyinaa, ");
INSERT INTO twi_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","sohori, anadwo akoroma, ɛpo so asomfena ne akoroma ahorow nyinaa, ");
INSERT INTO twi_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","patu, ɔpatukɛse, bakanoma ");
INSERT INTO twi_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","nantwinoma, opete ne ɛpo so kwaakwaadabi, ");
INSERT INTO twi_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","ne asukɔnkɔn ahorow nyinaa, asuɔkwaa ne ampan. ");
INSERT INTO twi_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","Ntummoa a wɔwea nyinaa ho ntew mma mo; monnwe. ");
INSERT INTO twi_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Nanso aboa a ɔwɔ ntaban a ne ho tew biara no motumi we. ");
INSERT INTO twi_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","Monnwe aboa biara a mubehu sɛ wawu. Momfa mma ɔhɔho a ɔne mo te, anaasɛ montɔn ma ɔnanani. Na mo ankasa de, monnwe, efisɛ wɔayi mo asi nkyɛn sɛ ɔman kronkron ama Awurade, mo Nyankopɔn no. Monnnoa abirekyi ba wɔ ne na nufusu mu. ");
INSERT INTO twi_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","Afe biara monhwɛ na munyi mo mfuw mu nnɔbae nkyɛmu du mu baako. ");
INSERT INTO twi_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","Munni mo atoko, nsa, ne ngo, ne mo anantwi ne nguan abakan wɔ Awurade, mo Nyankopɔn no, anim wɔ faako a ɔbɛpaw sɛ ɛyɛ atenae wɔ ne din mu na ama moasua sɛnea wosi di Awurade, mo Nyankopɔn no ni daa. ");
INSERT INTO twi_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Sɛ beae a Awurade, mo Nyankopɔn no, bɛkyerɛ mo sɛ monkamfo ne din no ne nea mote no ntam kwan ware a, ");
INSERT INTO twi_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","ɛno de, momfa mo ntotoso du du no nsesa dwetɛ na momfa dwetɛ no nkɔ beae a Awurade, mo Nyankopɔn no, bɛpaw no. ");
INSERT INTO twi_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","Sɛ mudu hɔ a, momfa sika no ntɔ biribiara a mo kɔn dɔ, sɛ ebia, nantwi, oguan, bobesa, anaa nsa biara a ɛyɛ den ne ade biara a mo kra pɛ na mo ne mo fifo nni wɔ Awurade, mo Nyankopɔn no, anim na mo ani nnye. ");
INSERT INTO twi_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Na mummu mo ani ngu Lewifo a wɔfra mo mu no so, efisɛ wonni wɔn ankasa wɔn agyapade biara. ");
INSERT INTO twi_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","Mfe abiɛsa biara awiei no, momfa mo nnɔbae so ntotoso du du no mmra mmɛkora wɔ mo nkurow mu, ");
INSERT INTO twi_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","sɛnea ɛbɛyɛ a Lewifo a wonni agyapade mu kyɛfa wɔ mo mu no ne ananafo a wɔwɔ mo nkurow so ne nyisaa ne akunafo a wɔwɔ mo nkurow so no betumi adidi amee; na ama Awurade, mo Nyankopɔn no, ahyira mo nsa ano nnwuma nyinaa so. ");
INSERT INTO twi_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","Muntwa mo aka mu mfe ason awiei biara. ");
INSERT INTO twi_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Ɔkwan a ɛsɛ sɛ mofa so ni: Ɛsɛ sɛ obiara a wabɔ ne yɔnko Israelni bosea no, de kyɛ no. Ɛnsɛ sɛ ɔdan ne yɔnko no anaa ne busuani ka, efisɛ wɔapae mu aka Awurade bere a wɔde ka kyɛ no. ");
INSERT INTO twi_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","Saa ka a wotwa mu yi ka mo yɔnkonom Israelfo no nko ara. Ahɔho a wɔte mo mu no de, sɛ mopɛ a mobɛma wɔn atua. ");
INSERT INTO twi_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","Mmom, ɛnsɛ sɛ ahiafo ba mo mu efisɛ, Awurade, mo Nyankopɔn no behyira mo wɔ asase a ɔde rema mo sɛ mo agyapade no so, ");
INSERT INTO twi_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","sɛ motɔ mo bo ase di Awurade, mo Nyankopɔn no, mmara a mede rema mo nnɛ yi nyinaa so a. ");
INSERT INTO twi_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Efisɛ Awurade, mo Nyankopɔn no, behyira mo sɛnea wahyɛ mo bɔ no. Mobɛbɔ aman bebree bosea, nanso moremmɔ obiara hɔ bosea da. Mubedi aman bebree so, nanso obiara renni mo so da. ");
INSERT INTO twi_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Sɛ mudu nkurow a Awurade, mo Nyankopɔn no, de rema mo no so na sɛ ehia mo yɔnkonom Israelfo no bi a, mummpirim mo koma anaa mommma mo nsam nyɛ den wɔ wɔn so. ");
INSERT INTO twi_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","Mmom, mungow mo nsam na momfɛm wɔn nea ehia wɔn biara. ");
INSERT INTO twi_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Monhwɛ na moannya saa adwemmɔne yi wɔ mo tirim sɛ: “Afe a ɛto so ason, afe a wotwa aka mu no, abɛn,” na moannyina so ammɔ mo mfɛfo Israelfo a ahia wɔn no atirimɔden a moremma wɔn hwee. Ɛba saa a, wobesu afrɛ Awurade de atia mo, na ɛbɛma wɔabu mo bɔne ho fɔ. ");
INSERT INTO twi_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Mumfi koma pa mu mma na Awurade, mo Nyankopɔn no, behyira mo wɔ mo nnwuma nyinaa ne biribiara a mode mo nsa bɛka no mu. ");
INSERT INTO twi_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Bere biara, mubehu ahiafo wɔ asase no so. Ɛno nti merehyɛ mo sɛ, biribiara a mowɔ no, mumfi ɔpɛ pa mu mma mo mfɛfo Israelfo a ahia wɔn wɔ asase no so no. ");
INSERT INTO twi_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Sɛ wo nua Hebrini, sɛ ɔyɛ barima anaa ɔbea, tɔn ne ho ma wo na ɔsom wo mfirihyia asia a, ɛsɛ sɛ wugyaa no ma ɔde ne ho afe a ɛto so ason no. ");
INSERT INTO twi_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","Na sɛ woregya no kwan a, mma no nkɔ nsapan. ");
INSERT INTO twi_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","Fa nsa a emu gow so ma no wo nguan no bi, wʼawiporowbea mu ade ne wo nsakyi amoa mu ade bi. Hwɛ sɛnea Awurade, wo Nyankopɔn no, asi ahyira wo no so na ma no. ");
INSERT INTO twi_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","Monkae sɛ na moyɛ nkoa wɔ Misraim na Awurade, mo Nyankopɔn, yii mo fii hɔ. Ɛno nti na mede saa mmara yi rema mo nnɛ yi. ");
INSERT INTO twi_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","Na sɛ ɛba sɛ wʼakoa ka kyerɛ wo se, “Merennyaw wo hɔ nkɔ,” efisɛ ɔpɛ wo ne wʼabusuafo asɛm na ne ho tɔ no wɔ wo nkyɛn a, ");
INSERT INTO twi_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","ɛno de, fa fitii bɔre nʼaso mu na ɔnyɛ wʼakoa daa. Wo mfenaa nso, yɛ wɔn saa ara. ");
INSERT INTO twi_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Momma no nyɛ wo den sɛ mubegyaa mo asomfo no ama wɔafa wɔn ho akodi. Monkae sɛ, mfe asia a wɔasom mo no sɛ wokɔfaa apaafo sɛ wɔnsom mo a, anka mubetua apaafo no sika mmɔho abien na Awurade, mo Nyankopɔn no, behyira mo wɔ biribiara a moyɛ ho. ");
INSERT INTO twi_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","Munyi mo anantwi ne mo nguan mmakan anini no nsi hɔ mma Awurade, mo Nyankopɔn no. Mo anantwi mmakan no, mommfa wɔn nkɔ mo mfuw mu nkɔyɛ adwuma, na munntwitwa mo nguan mmakan ho nwi nso. ");
INSERT INTO twi_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","Mmom, mo ne mo abusuafo na afe biara monwe saa mmoa yi wɔ baabi a Awurade, mo Nyankopɔn no, bɛpaw ama mo no wɔ nʼanim. ");
INSERT INTO twi_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Na sɛ ɛba sɛ abakan no bi adi dɛm, sɛ ebia, ɔtɔ apakye anaa nʼani afura anaa wadi dɛm foforo bi a, mommfa no mmɔ afɔre mma Awurade, mo Nyankopɔn no. ");
INSERT INTO twi_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","Mmom, momfa no nyɛ aduan mma abusuafo wɔ fie. Sɛ obi ho tew o, sɛ ne ho ntew o, otumi di bi sɛnea obiara tumi we ɔtwe anaa ɔdabɔ nam no. ");
INSERT INTO twi_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Nanso ɛnsɛ sɛ mudi mogya no. Munhwie ngu fam te sɛ nsu. ");
INSERT INTO twi_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Daa munni Twam Afahyɛ no wɔ ɔsram Abib no mu mma Awurade, mo Nyankopɔn, efisɛ ɔsram Abib mu da bi anadwo na Onyankopɔn yii mo fii Misraim. ");
INSERT INTO twi_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","Munkum anantwi anaa nguan sɛ Twam afɔrebɔde mma Awurade, mo Nyankopɔn no, wɔ faako a Awurade beyi sɛ atenae wɔ ne din mu no. ");
INSERT INTO twi_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Munnni mmɔkaw brodo nka ho; na mmom, nnanson so na munni apiti amanehunu brodo, efisɛ mufii Misraim ɔhare so, sɛnea ɛbɛyɛ a mo nkwanna nyinaa mu no mobɛkae bere a mutu fii Misraim no. ");
INSERT INTO twi_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","Mommma wonhu sɛ mowɔ mmɔkaw wɔ mo nkyɛn wɔ mo nsase nyinaa so nnanson. Mommma nam a mode bɔɔ afɔre da a edi kan no anwummere no nka gya so nkosi anɔpa. ");
INSERT INTO twi_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","Mommɔ Twam Afahyɛ afɔre no wɔ nkurow a Awurade, mo Nyankopɔn no, de rema mo no mu biara so, ");
INSERT INTO twi_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","gye faako a Awurade, mo Nyankopɔn no, beyi sɛ wɔnkamfo ne din wɔ hɔ no. Ɛhɔ na mommɔ Twam afɔre no anwummere mfa nni mo Misraimfi bere no afahyɛ. ");
INSERT INTO twi_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","Montoto na monwe no wɔ faako a Awurade, mo Nyankopɔn no, bɛpaw ama mo no. Na ade kye a, monsan nkɔ mo ntamadan mu. ");
INSERT INTO twi_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Nnansia na momfa nni apiti, na ne nnanson so no, nnipa no nyinaa nhyia wɔ Awurade, mo Nyankopɔn no, anim. Na saa da no, obiara nyɛ adwuma. ");
INSERT INTO twi_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","Mumfi bere a mubefi ase atwa atoko no nkan nnaawɔtwe ason. ");
INSERT INTO twi_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","Na monhwɛ sɛnea Awurade, mo Nyankopɔn no, asi ahyira mo no so mfi mo pɛ mu mmɔ afɔre, nnyina so nni Asese Afahyɛ no mma Awurade, mo Nyankopɔn no. ");
INSERT INTO twi_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","Na munnye mo ani wɔ Awurade, mo Nyankopɔn no, anim wɔ faako a ɔbɛpaw sɛ atenae ma ne din no. Mo ne mo mmabarima ne mo mmabea, mo nkoa ne mo mfenaa, Lewifo a wɔwɔ mo nkurow mu ne ahɔho, nyisaa ne akunafo a wɔne mo te nyinaa. ");
INSERT INTO twi_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","Monkae sɛ na moyɛ nkoa wɔ Misraim enti monhwɛ yiye na munni saa mmara yi nyinaa so. ");
INSERT INTO twi_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","Sɛ moboaboa mo awiporowbea ne mo nsakyi amoa mu ade ano wie a, momfa nnanson nni Asese Afahyɛ no. ");
INSERT INTO twi_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","Munnye mo ani wɔ mo afahyɛ yi se; mo ne mo abusuafo, mo asomfo ne Lewifo, ahɔho, nyisaa ne akunafo a wofi mo nkurow mu. ");
INSERT INTO twi_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","Momfa nnanson nni saa afahyɛ yi mfa nhyɛ Awurade, mo Nyankopɔn no, anuonyam wɔ faako a ɔbɛpaw, efisɛ Awurade, mo Nyankopɔn no, na ɔma mo nnɔbae bɔ pii na ohyira mo nnwuma nyinaa so; na mo anigye bewie pɛyɛ. ");
INSERT INTO twi_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","Afe biara mu no, ɛsɛ sɛ mo mmarima no nyinaa hyia wɔ mo Awurade, mo Nyankopɔn no, anim faako a ɔbɛpaw no mprɛnsa de ama Apiti Afahyɛ, Otwabere Afahyɛ ne Asese Afahyɛ no. Ɛnsɛ sɛ obiara ba Awurade anim nsapan. ");
INSERT INTO twi_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","Ɛsɛ sɛ obiara de akyɛde a ɛne nhyira a Awurade, mo Nyankopɔn no, nhyira no no sɛ ba. ");
INSERT INTO twi_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","Munsisi atemmufo ne mpanyimfo mfi mo mmusuakuw biara mu wɔ nkurow a Awurade, mo Nyankopɔn no, de rema mo no mu, na wobebu nnipa no atɛntrenee. ");
INSERT INTO twi_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","Mummmu ntɛnkyew anaa monnhwɛ nnipa anim mmu atɛn. Monnnye adanmude, efisɛ adanmude fura onyansafo ani ma ɔdan nea odi bem no asɛm ani. ");
INSERT INTO twi_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Mummu atɛntrenee nkutoo, na ama moatumi atena asase a Awurade, mo Nyankopɔn no, de rema mo no so. ");
INSERT INTO twi_vpl VALUES ("DT16_21","006_1