﻿USE sofia;
DROP TABLE IF EXISTS sofia.tvt_vpl;
CREATE TABLE tvt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tvt_vpl WRITE;
INSERT INTO tvt_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisu Kristo te awah Dewid sutoom loong, marah Abraham sutoom angta loong ah arah. ");
INSERT INTO tvt_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6a","Abraham dowa ih Dewid tuk ih arah loong te awah rah ang rumta: Abraham, Isak, Jaakob, Juda nyi soophoh loong; erah lilih Perej nyia Jera (Nyi nuh ah Tamar angta), Hejron, Ram, Aminadab, Nason, Salmon, Booj (heh nuh ah Raahab angta), Obed (heh nuh ah Ruth), Jiisi nyia luungwang Dewid. ");
INSERT INTO tvt_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","11","Dewid dowa ih Ijirel mina loong Bebiloon ni doksoon karumta tokdi te awah ah arah loong ah ang rumta: Dewid, Solomon (heh nuh rah langla Uriah minuh angta), Rehoboom, Abijah, Asa, Jehosaphat, Jehoram, Ujiah, Jotham, Ahaj, Hejekiah, Maniseh, Amon, Josiah, Jehochin nyia heh no loong ang rumta. ");
INSERT INTO tvt_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Bebiloon ni doksoon karumta dowa ih Jisu Kristo tupta mong adi te awah rah arah loong ah ang rumta: Jehoiachin, Siiltil, Jerubabel, Abiud, Eliakim, Ajor, Jaadok, Achim, Eliud, Eliajar, Matthan, Jaakob, nyia Jisu ah Kristo et poon rumta nuh Meeri kapte wah Josep. ");
INSERT INTO tvt_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Erah ang abah, Dewid dowa ih Abraham chamchi ni mina hasong ah asih roi baji angta, eno Dewid dowa ih Bebiloon ni hamat karumta mong adi asih roi baji angta erah damdi Bebiloon ni hamat karumta dowa ih Jisu tup ra taha chamchi adi uh asih roobaji angta. ");
INSERT INTO tvt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisu Kristo ah ame tupta. Heh nuh Meeri ah Josep damdi kakhat muita, enoothong maang nookmui nyuuka ngadi, Meeri suh Esa Chiiala nawa ih hemong ni heh sah ejen wok et thukta. ");
INSERT INTO tvt_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep ah saarookwih epun ih reete toongtang mina angta, ang abah uh heh ih Meeri asuh noksong dung nah erakri phoh eah ih thun ano; husah lam ih we paak haatmui suh taat thunta. ");
INSERT INTO tvt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Heh ih erah thunta tok adi, Teesu ih Rangsah ah heh mangphe di dongchap ano baat thukta, “Josep, Dewid sutoom, Meeri ah an sanuh et kap suh nakcho uh. Tumeah heh suh Esa Chiiala nawa ih sakjih ang thukla. ");
INSERT INTO tvt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Heh ih miwasah et dong tup ah, eno an ih heh men ah Jisu et men theng tumeah heh ih heh mina loong neng rangdah nawa puipang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Erah langla Teesu ih khowah suh baatta jengkhaap ah amiisak toom ang raaha ih ang thukla, ");
INSERT INTO tvt_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kateng Jaalah esiit heh sah wok ano heh sah ah miwasah ang ah, eno Imanuel et poon ah” (erah langla, “Rangte ah seng damdi”) ");
INSERT INTO tvt_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Eno Josep ah jup nawa saat ano, Rangsah ih baatta jun ih, Meeri ah kapta. ");
INSERT INTO tvt_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ang abah uh heh sah tup ngah di Meeri damdi taroom jupta. Eno Josep ih heh men ah Jisu et menta. ");
INSERT INTO tvt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jisu ah Judia ni Betlehem hadaang adi tupta, eno erah tokdi Hirod ah luungwang angta. Erah tup damdam, seek di saadongko nawa mararah mina riksih jatsokte loong Jerusalem ni thok rum taha ");
INSERT INTO tvt_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","eno cheng rumta, “Noodek Jehudi luungwang ih hoonte ah maradi tup ha? Seng ih saadongko ni heh reksih dong phaakta ah tupti, eno heh suh khorongngot thok hali.” ");
INSERT INTO tvt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Eno Hirod luungwang ih erah japchaat ano, rapne ih mongsaamta, erah damdi Jerusalem mina loong anep roong mongsaam rumta. ");
INSERT INTO tvt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Eno heh ih romwah phokhoh loong nyia Hootthe nyootte loong ah lompoon ano cheng rumta, “Kristo ah maradoh tup ah?” ");
INSERT INTO tvt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Judia nawa Betlehem hadaang adoh,” neng ih baat rumta. “Tumeah arah tiit ah khowah ih amet raangthiinta: ");
INSERT INTO tvt_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Juda hah dowa Betlehem, an ah Juda samnuthung adoh ehin tah angko; erah dowa an noksong pante ih dong uh Ijirel dowa nga mina loong ah ban koonchaate ah.’” ");
INSERT INTO tvt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Eno Hirod ih saadongko nawa jatwah loong ah husah lam ih ngoongthum lompoon ano riksih phangdongta saapoot ah chocheng rumta. ");
INSERT INTO tvt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Erah dowa ih heh ih neng ah Betlehem hadaang ni kaatthuk rum ano amet baat rumta: “Kah anno noodek maradi tup ha rah naririh et jam kah an, eno chotup anno, ngah suh baat he, ngah uh heh re nah khorongngot kaat suh thunhang.” ");
INSERT INTO tvt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Eno dokkhoomta, neng lam ni khoom rum adi, saadongko ni tup rumta reksih ah we kaptup rum ano, rapne ih roon rumta, neng suh tumthan thunghaan jih angta! Riksih ah nengngah nengngah ih ban kah ano maradi noodek tupta erah di tangchap kata. ");
INSERT INTO tvt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Neng ah nokmong ni nopkhoom rum ano, noodek ah heh nuh Meeri damdi ang arah tup rumta, eno neng lakuh di tongrum ano khorongngot rumta. Neng ih tenroon ih hun, Phontum nyia etingtak theng phontumkaang loong ah, heh suh laknoi et dokkoh rumta. ");
INSERT INTO tvt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Eno neng, ah neng deek ni lamhoh ko ih ngaakwang rumta, neng mangphe di Rangte ih Hirod jiinnah nak ngaak wang an ih dangdang ih baat rum kano ah. ");
INSERT INTO tvt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Neng dokkhoom rumta lini, Rangsah ah Josep mangphe ni dongchap ano baatta, “Hirod ih noodek ah tek haat et suh jam sok ette angla. Erah thoidi dokchap an, noodek nyi soonuh ah siit uno Ijip nah hutong kah an, eno erah nawa dokkhoom suh ngah ih maang baatbaat sen ban tongruh etheng. ");
INSERT INTO tvt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Eno Josep ah saatta, eno soonuh nyi ah siit ano, rangphe phe di Ijip ni karumta, ");
INSERT INTO tvt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","erah ni neng Hirod maang tektek ih tong karumta. Erah langla Teesu ih khowah suh mamet baatta erah jun ih amiisak angsuh re rumta, “Ngah ih nga sah ah Ijip nawa dokpoon ang.” ");
INSERT INTO tvt_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hirod luungwang ih saadongko nawa jatwah loong ih heh mokwaan rumta ah jat ano, rapne ih khata. Eno heh ih Betlehem nawa noodek miwasah loong ah tek haat et suh baatta, erah damdi uh hakhuung hatok nawa noodek paang nyi dowa ih khobaang loong ah tek haat suh baatta, erah langla heh ih saadongko nawa jatwah loong re nawa mamet chaatta erah jun ih riksih dong saapoot ah jat ano baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Erah langla khowah Jeremia ih mamet baatta erah jun ih amiisak ih langta; ");
INSERT INTO tvt_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Raama ni Mih riing Chaatta, rapne ih huungriing arah ah. Raakel ah heh sah loong thun huungla; heteenuh huungdiip ah edaan etta, tumeah neng tekmang angta.” ");
INSERT INTO tvt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hirod tek lini, Teesu Rangsah ih Ijip ni Josep mangphe di dong khoom ano ");
INSERT INTO tvt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","baatta, “Saat uh, soonuh nyi ah siit uno, Ijirel hadaang nah ngaak wang an, tumeah noodek tek haat chuungte wah ah etek eta.” ");
INSERT INTO tvt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Eno Josep ah saat ano, soonuh nyi ah siit ano, Ijirel hadaang ni ngaakwang rumta. ");
INSERT INTO tvt_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Enoothong Josep ih Hirod sah Arkeleus ah Juda ni luungwang we ih hoonla tih, ih chaat ano heh erah nah wangsuh echo eta. Heh suh heh mangphe di jaatrep ah banbaat etta, erah thoidi heh Galili hadaang ko ih wangta ");
INSERT INTO tvt_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","eno heh Najaret hadaang liiha adi tongsong wangta. Erah ah khowah loong ih banbaatta jengkhaap ah amiisak ih pun ra taha: “Heh suh Najaret hadaang mina et li ah.” ");
INSERT INTO tvt_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Erah tokdi Juungtemte Joon ih Judia hadaang phisaang hah mong ni Rangte tiit ah phang baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Sen rangdah nawa ngaak ehan,” heh ih baatta, “tumeah Rangmong Hasong ah thok nanah ih hala!” ");
INSERT INTO tvt_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Khowah Isaia ih banbaatta wah ah Juungtemte Joon angta eradi amet liita, “Mih esiit phisaang hah mong ni riingla, ‘Teesu raangtaan ih lam ban hoon thiin an; Heh khoom suh lamjun et hoon an!’” ");
INSERT INTO tvt_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juungtemte Joon nyuh akhat ah mokchongdoot roon nawa ih hoon arah angta; heh roomkhe ah siikhoop angta, erah damdi heh phaksat ah wotuute nyia woma nawa najui angta. ");
INSERT INTO tvt_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mina loong ah heh jiinni Jerusalem nawa kalomthok rumta, erah damdi Jordan juung re ko Judia juungkhuung re nawa loong nep thokta. ");
INSERT INTO tvt_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Neng ih neng rangdah loong ah dokbaat leh, Jordan adi juung ah tem rumta. ");
INSERT INTO tvt_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Heh ih Pharasi nyi Sadusi miloong juungtem lomthok rumha ah tup ano li rumta, “Pu sen loong ah—o ih baat tahan sen Rangte tenkhat ra hala dowa epi ete eah? ");
INSERT INTO tvt_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sen rangdah nawa elek elan ih jatjih reeraang pakna ah chaak re kah an. ");
INSERT INTO tvt_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Sen ih nakmok thun an Abraham suh sengte sengwah li ih no hepi kih eah. Ngah ih baat rumhala Rangte ih bah arah jong ah toon ano uh Abraham suh asah ejen hoon et ah! ");
INSERT INTO tvt_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chaang ah bang heh heng nah joot haat raang ih ban thiin eha; bang marah hetiik tatiikka loong abah joot ano we nah tak ah. ");
INSERT INTO tvt_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ngah ih sen juungtem rumhala ah langla sen rangdah nawa ngaaklek etan ih jat suh, enoothong nga lini wasiit ra hala rah ih bah Esa Chiiala nyia we nawa ih tem han. Heh ah nga nang ih elongthoon ang ah; ngah bah Heh lakhoop pak taajoh tha uh taliikang. ");
INSERT INTO tvt_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Heh di raan dannun theng chuulaang nep jeela. Heh ih raanteh hewong ah pung nah lomthiin ah, eno hephaang loong ah we babah uh lamettheng adoh mattak ah. ");
INSERT INTO tvt_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Erah tokdi Jisu ah Galili nawa thok haano Juungtemte Joon jiinni Jordan juung ni heh juungtem thuk suh ra taha. ");
INSERT INTO tvt_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Enoothong Joon ih heh tenthun ah lekthun thuk suh taat liita. “Nga juungtem botseh an ih temjih ang tahang,” Joon ih liita, ang abah uh an ah nga jiinni thok halu nih!” ");
INSERT INTO tvt_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Eno Jisu ih heh suh ngaak baatta, “Emah ju toom ang ah. Rangte ih jamha loong ah seng emamah ih re theng.” Erah thoidi Joon ih thangta. ");
INSERT INTO tvt_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisu ah juungtem nawa dokkhoom damdam rang kaasak ah daap eta, eno Rangte Chiiala ah wotuupi likhiik ih datpuh ra haano heh sak ni phaak raaha rah tupta. ");
INSERT INTO tvt_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Erah lilih root esiit dongjengta, “Arah ah nga mongnook Sah, heh suh ngah rapne ih roonlang.” ");
INSERT INTO tvt_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Eno Esa Chiiala ih Jisu ah phisaang hako ni Hakhoh luungwang suh phate kaat thukta. ");
INSERT INTO tvt_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jisu ah hephe phe rook baji hesa saarookbaji phaksat muh tong ano, ramtek angta. ");
INSERT INTO tvt_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Eno Juungbaan ah wang haano Jisu suh liita, “An ah Rangte sah ang ubah arah jong loong ah baanlo et hoon thuk thaak uh.” ");
INSERT INTO tvt_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Eno Jisu ih ngaak liita, “Rangteele ni liiha, ‘mina jih ajaat ah phaksat nawa ih luulu tathing tongka, erah nang ih bah Rangte jengkhaap jengta loong rah ih baajen thingtong ah.’” ");
INSERT INTO tvt_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Erah lilih Juungbaan ah ih Jisu ah Esa samnuthung adi , Jerusalem adi siitkaat ano Rangteenok khochoom adi chapwan thukta, ");
INSERT INTO tvt_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","eno baatta, “An ah Rangte sah ang uh bah, aadowa an teeteewah datti thaak uh, tumeah Rangteele ni liiha, ‘Rangte ih Rangsah loong asuh an tiit ah baat rum ah; eno neng lak ih an banjoh rumho, eno an lah taan uh jong nah tasat nak thuk ru.’” ");
INSERT INTO tvt_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisu ih ngaak liita, “Enoothong Rangteele ni amah uh eraang eha, ‘An Teesu Rangte ah nak taari uh.’” ");
INSERT INTO tvt_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Erah lidi Hakhoh Juungbaan ah ih Jisu ah kongchoong thoon adi siitwan ano mongrep nawa elong elang hasong ah noisokta. ");
INSERT INTO tvt_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Hakhoh Juungbaan ah ih liita, “An lakuh nah kotbon uno nga rangsoom hang bah, arah loong ah, ngah ih an suh koha.” ");
INSERT INTO tvt_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Eno Jisu ih we liita, “Soon uh, Soitaan! Rangteele ni liiha, an Teesu Rangte ah luulu ba soom uh!” ");
INSERT INTO tvt_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Erah lidi ba Hakhoh Juungbaan ah Jisu jiinnawa kok dokkhoom katta; eno rangsah loong ah thok rumha chosokboi ra rum taha. ");
INSERT INTO tvt_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Joon ah phaatak ni sak ha ih Jisu ih chaat ano, heh ah Galili ni doksoon kata. ");
INSERT INTO tvt_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Heh ah Najaret hadaang ni tatongta, erah nang ih bah Jabulun nyia Napthali juungkhuung Galili juungsitum kaang Kapernam hadaang adi, tong wangta. ");
INSERT INTO tvt_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Erah langla khowah Isaia ih baatta ah amiisak toom ang raaha ih reeta, ");
INSERT INTO tvt_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Jebulun nyi Napthali hadaang, Jordan juung saangko juungsih ni kala lam adi, Ranglajatte loong hadaang Galili adi! ");
INSERT INTO tvt_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Rangnak ni tongte miloong ih weephaak elong ah tup rum ah. Etek hadaang laamang ni tongte loong asuh weephaak ah kaangtook ah.” ");
INSERT INTO tvt_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Erah tok dowa ih Jisu ih Rangte tiitkhaap ah phang baat rumta: “Sen rangdah nawa engaak ehan, tumeah Rangmong hasong ah haniik ih thok hala!” ");
INSERT INTO tvt_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisu Galili juungsitum kaangko ih kah adi, heh ih soophoh wanyi nyah haate tupta, Simoon (Pitar ih poon rumta) nyia ah heh no Endriu ih juungsitum ni nyah ha nyu arah tupta. ");
INSERT INTO tvt_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisu ih nyi suh baatta, “Nga damdoh roongwang hansih ngah ih mih mamet joh ah erah nyoot nyuuha ");
INSERT INTO tvt_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Erah damdam soophoh nyi ah chaak ah thiinhaat nyu ano heh damdi roongwang nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Heh ih wahoh soophoh wanyi, Jeems nyia Joon we japtup wanta, nyi wah ah Jebidi angta. Nyi wah damdi khoonkhuung ni nyah joot suh chaak tin rum arah japtupta. Eno Jisu ih poon rumta, ");
INSERT INTO tvt_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","erah damdam nyi wah ah khoonkhuung adi thiinhaat nyu ano, Jisu damdam ih roongwang nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisu ah Galili hah noongrep ni riim thok khoomta, Jehudi rangsoomnok ni tum nyootsoot, Rangte Hasong Ruurang Ese ah baattaan, hephan dowa khoisatte mina loong ah riim deesiit etta. ");
INSERT INTO tvt_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Erah ruurang ah Siria deek akaan noongrep ni japchaat kaat rumta, erah dowa ih harep nawa mina loong ih hephan dowa khoisat, eput engam, echeek ebaang ekoong edook loong thoksiit rum taha eno Jisu ih erah loong ah deesiit rumta. ");
INSERT INTO tvt_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mina loong hantek Galili nawa, Hadaang Asih ih menha dowa, Jerusalem nawa, Judia nawa nyia Jordan juung saangko nawa ah heh lini roong phankhoom rumta. ");
INSERT INTO tvt_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisu ih miloong ah sok ano kong ni duungtong wangta. Eno heliphante loong heh reeni kooktong rumta loong asuh, ");
INSERT INTO tvt_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","phang nyootsoot rumta: ");
INSERT INTO tvt_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“O chiiala lam ni changthih anglang ih jat ha loong abah, tenroon ang ah; rangmong Hasong ah erah mina loong raangtaan ang ah! ");
INSERT INTO tvt_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“O mongjoong angla loong ah tenroon ang ah; Rangte ih erah loong asuh tenchaan koh ah! ");
INSERT INTO tvt_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“O toongtang angla loong ah tenroon ang ah; Rangte ih kakhamta loong ah choh ah! ");
INSERT INTO tvt_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Rangte ih jamha ah jen re suh thunte loong ah tenroon ang ah; Rangte ih neng tenchem thuk ah! ");
INSERT INTO tvt_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“O mihoh raang ih tenthet jeela loong ah tenroon ang ah; Rangte uh erah loong asuh tenthet je ah! ");
INSERT INTO tvt_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Esa tenthunte loong ah tenroon ang ah; Rangte ah neng ih japtup rum ah! ");
INSERT INTO tvt_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Semroongroong angsuh reete ah tenroon ang ah; Rangte ih neng suh heh sah et poon rum ah! ");
INSERT INTO tvt_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Rangte ih jamha jun ih mote loong siiwiiha ah tenroon ang ah; rangmong Hasong ah neng raangtaan ih ang ah! ");
INSERT INTO tvt_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nga liphan tungthoidi mih ih kaanju halan, siiwi halan adoleh sen tiit ah ethih lam ih leekbaat halan loong ah tenroon ang an! ");
INSERT INTO tvt_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tenroon ang an, tumeah sen raangtaan ih elongthoon thaangchojih Rangmong ni ban thiinha. Teewah dowa khowah loong ah emamah ih siiwi rumta. ");
INSERT INTO tvt_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Sen ah mina loong raangtaan ih sum likhiik. Enoothong sumwaan ah mok mah abah, takah we mi ngaak sum thukka. Erah thaangmuh ih hoon ah, piihaat ano mih ih ba noopnak kaat ah. ");
INSERT INTO tvt_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Sen ah mongrep mina raang ih weephaak likhiik. Kongchoong dowa samnuthung ah latup thang ih tajen hutongka. ");
INSERT INTO tvt_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","O eh uh weetook ah khoowaan khu nah tatookka: erah nang ih bah hetook thengnah ba took ah, ma dowa ih mina ah khom kaangtook ah erah doh ah. ");
INSERT INTO tvt_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Erah likhiikkhiik sen weephaak ah uh mina miksok doh emamah ih phaak theng, erah dowa ih ba mina ih ese mootkaat ah sok ano Rangmong nawa sen wah ah gu rum ah. ");
INSERT INTO tvt_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Moses Hootthe nyia khowah loong ih nyoot tahan loong ah thiinhaat suh ra hala ih nakmok thunhe. Ngah erah loong toohaat thuk suh taraarang, erah nang ih erah nyootsoot tahan loong ah amiisak angthuk suh ra halang. ");
INSERT INTO tvt_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Samthun et an arah rang nyia hah ah maang thoonthoon bah, arah Hootthe dowa ehin tiit angkojao adoleh jojang tiit angkojao lamat haat theng—jaatrep jaat raang loong ah maang thoonthoon bah ah. ");
INSERT INTO tvt_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Erah raangtaan ih, o ih bah uh jengdang dowa ehinsah tiit ang abah uh lakap thang ih, mihoh suh nep mok moong kiinyootsoot abah, Rangmong Hasong nah heh ah ehin et thiik ah. Emamah, o ih bah uh hootthe ah phan ano mihoh suh nep emamah ih nyootsootte abah, Rangmong Hasong heh ah elong et thiik ah. ");
INSERT INTO tvt_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Erah raang ih ngah ih baat rumhala, sen rangmong Hasong nah jen wang ean, sen tuungmaang laalom ah Hootthe nyootte nyia Rangte mootkaatte Phirasi loong nang ih ehan ih Rangte ih jamha jun ang anbah ah. ");
INSERT INTO tvt_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Sen ih chaat etan mina loong ih teewadi amet baat arah ah, ‘Mih nak tek haat theng; o ih mih tek haat ah erah mih ah erikri et ah.’ ");
INSERT INTO tvt_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Eno amadi sen suh baat rumhala: Senphoh senno damdoh mok khadah anbah sen ah erikri et han, senphoh senno suh amah mok li an, ‘An tumjih di uh tapun ko!’ Erah ang abah sen ah Ngoong awang dung nah thoksiit han, erah dam ih senphoh senno suh thaangmuh thungko mina ih mok li anbah, sen ah soolam dowa we adoh wangjih ih hoon an. ");
INSERT INTO tvt_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Erah raangtaan ih sen Rangte suh romthong nah tenroon lakkot kot thun ang andoh, senphoh senno damdi thichomui anrah mok samthun anbah, ");
INSERT INTO tvt_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tenroon lakkot ah romthong ngathong adoh ban thiin anno, echaan senphoh senno damdoh chaak punwaan wang an, eno ngaak hanno ba Rangte suh tenroon lakkot ah koh an. ");
INSERT INTO tvt_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“O ih bah uh sen miksuk halan, eno erah ih mat hoon nok nah maang thoksiit wan doh, saapoot ese pootdoh changrook tiit ah chaak huk punwaan etheng. Mat hoon nok nah jaasiit nopsiit tahan no bah, mat hoonte ih sen ah phaatak nah tongthuk suh pulit lak nah ba kohan. ");
INSERT INTO tvt_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ngah ih baat rumhala, erah nah bah chang maangthoon dokdok ih tongthuk han. ");
INSERT INTO tvt_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Sen ih amet baat arah chaat etan, ‘Mih minuh miwah damdoh laroomjup theng.’ ");
INSERT INTO tvt_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Eno amadi baat rumhala: O ih bah uh minuh ah sok ano eroomjup ih doh bah ih thunha rah ih botseh heh ten ni rangdah ah ejen moh eta. ");
INSERT INTO tvt_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Erah raangtaan ih sen mik jaawah ko rah ih rangdah mok ang thuk hanbah, doklot an no piihaat an! Sen sakpuh pan ih we nah khaamwang nang ih bah, sak nawa amasah chep mala ah ese laan ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sen lak jawah ko ih rangdah mok ang thuk hanbah, thadook anno piihaat an! Sen sakpuh pan soolam nah wang nang ih bah lakko ih tong ah ese laan ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Amah uh ebaat eta, ‘O ih bah uh heh minuh haat ah, erah ih le ah raang ano haat mu theng eah.’ ");
INSERT INTO tvt_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amadi ngah ih baat rumhala: O ih bah uh heh minuh mih damdoh laroomjupka doh haat ah, eno minuh ah mihoh damdoh mok we nook abah roomjup rangdah ah heh ih dah thukla; eno erah nuh we kapte warah uh emamah ih romjup rangdah ah dah ah. ");
INSERT INTO tvt_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ehak di mih loong ih amet baat arah uh echaat etan, ‘Thoomhoon jengkhaap ah lathet haat theng, erah nang ih Teesu damdi tumjih re suh thoomhoon tu rah ere etheng.’ ");
INSERT INTO tvt_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amadi ngah ih baat rumhala: sen ih jeng kakham an radoh thoom nakmok hoon an. Rang mendoh uh nak thoom an tumeah erah Rangte tongtheng; ");
INSERT INTO tvt_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","adoleh hatoh mendoh uh lathoom theng, tumeah erah Rangte lah dangnak theng; adoleh Jerusalem mendoh uh lathoom theng, erah Luungwanglong samnuthung. ");
INSERT INTO tvt_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Sen khoh uh lamenseh theng, tumeah khoroon tasiit taan uh sen ih epuung adoleh emak tajen hoon kan. ");
INSERT INTO tvt_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","‘Elang’ adoleh ‘Lalang’ erah ba jeng theng—jaat hoh jenglan abah Ethih ih jeng thuk halan. ");
INSERT INTO tvt_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Sen ih amet baat arah echaat etan, ‘Thetsok et ho bah ngaak thetsok et uh, pha ih phak abah pha ih ngaak phaktheng eah.’ ");
INSERT INTO tvt_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amadi ngah ih baat rumhala: O bah uh sen damdoh thetre ha bah phuh nak lek theng. O ih bah uh jawah ko the adoh buh hanbah, dak hekko the adoh boot buh thuk theng. ");
INSERT INTO tvt_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Erah damdoh o ih bah uh an samsong ah nge suh mat hoon nok nah thoksiit hanbah, sen samsongnuh anep laan wak khook koh an. ");
INSERT INTO tvt_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Erah damdoh o ih bah uh meesiit hajang nah huihui laatbaat hanbah, meenyi hah nah boot kowan an. ");
INSERT INTO tvt_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","O ih bah uh sen dowa tumjih tumpih suh hanbah ekot etheng; adoleh sen dowa o ih bah uh hukkhaak nam hanbah heh suh enam kot ettheng. ");
INSERT INTO tvt_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Sen ih amet baat arah echaat etan, ‘Sen joonte ah minchan etheng, sen piiara ah miksuk ettheng.’ ");
INSERT INTO tvt_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Eno amadi ngah ih baat rumhala: senpi senra ah minchan et an, sen siiwiite asuh rangsoom koh an, ");
INSERT INTO tvt_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","eno ba Rangmong nawa sen wah Rangte suh asah ih hoon an. Tumeah heh ih rangsa ah ethih ese mina khoni eliili ih phaakthukla, nyia rangphaat ah ethih ese reete loongtang suh eliili et phaat koha. ");
INSERT INTO tvt_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Rangte ih tumjih thaang ma kohan sen joonteete ah minchan anbah ah? Erah bah sokse seete loong nep reela! ");
INSERT INTO tvt_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nyia sen joonte damdam adi waantiit lan rah, mihoh lajen reejih ah tam re lan? Emah bah Rangnak mina nep reela! ");
INSERT INTO tvt_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sen ah rapne eseethoon jaatjaat angtheng—rangmong nawa sen Wah angla likhiik ah. ");
INSERT INTO tvt_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Sen ih dangdang ih thun an sen thooroom reeraang pakna ah mih suh noisok laklak naktoom ang ah, erah loong ah sen nokjat tangjat mok ih re anbah, rangmong dowa sen Wah jiin nawa sen hethaang chotheng tajeeka ang an. ");
INSERT INTO tvt_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Erah raang ih sen ih changthih noodek suh tumjih tumjih koh anbah, sen ih mih suh lanoisok theng, rangsoomnok ni nyia lam ni lonoite reeraang rumla likhiik ah. Neng erah reeraang rumla ah mih ih toom guuhe ih thun rumha. Ngah ih amiitiit baat rumhala, erah mina loong ah neng hethaang ejen choh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sen ih mina changthih noolih chosok andoh, sen joonte sen sak tiit taantaan ih botseh nak toom jat ah. ");
INSERT INTO tvt_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Erah husah lam ih chosok theng. Eno ba sen husah lam ih kohan ah sen Wah ih sok hanno, sen suh erah thaang ah kohan. ");
INSERT INTO tvt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Sen ih Rangsoom andoh, lonoite likhiik nak ang an! Erah miloong ah ih bah rangsoomnok ni nyia lamkaang ni toonchap ano midung ni soom suh ram rumla, mih ih toom japtup he ih thun rum ano ah. Ngah ih amiitiit baat rumhala, neng erah re rumla thaang ah thoontang ejen choh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sen ih Rangsoom andoh, nokmong nah wang anno kaaluung ah sak, eno sen mik ih latup kan, sen Wah Rang ah soom an. Eno sen Wah ih, sen ih husah di soom han rah tup hanno, rangsoom thaang ah kohan. ");
INSERT INTO tvt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Sen ih rangsoom andoh, lalangka jengkhaap loong ah nakloot jeng an, Rangte men lajatte loong reela likhiik ah, neng rangsoom eloot ang kano Rangte ih ehan et chaat ah ih thun rumha likhiik ah. ");
INSERT INTO tvt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sen erah miloong likhiik lah angtheng. Sen ih tumjih jam han erah sen Wah ih maang suh kan jaakhoni dook ejen jat etta. ");
INSERT INTO tvt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Rang ah amet soom an: ‘Rang ni tongte seng loong Wah: an men esa aju phoong ih; ");
INSERT INTO tvt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","an hasong ju toom raaha; an thung hatoh nah uh rangmong nawa likhiik toom ang raaha. ");
INSERT INTO tvt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Seng suh chiinyah wa phaksat ah kohe. ");
INSERT INTO tvt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Seng rangdah thetreeti loong ah biin anaan he, seng ih seng joonte thetre ah biin anaan hi likhiik ah. ");
INSERT INTO tvt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Echeh echaan lam nah nak phate thuk weehe, erah nang ih mikmuh Juungbaan nawa thong panghe.’ Tumeah an juuba rangmong hasong, chaan aphaan, nyia roitang raang ih men raksiit theng. Amen. ");
INSERT INTO tvt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Sen ih sen joonte thetre ah biin anaan anbah, Rangmong nawa sen wah reh uh biin anaan et han. ");
INSERT INTO tvt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Enoothong sen ih sen joonte ah lajen biin anaan kanbah, Rangmong nawa sen Wah reh uh sen rangdah ah tajen biin anaan ran. ");
INSERT INTO tvt_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nyia samurangsoom tong andoh, senthe senkhoh ah nak joongdat thuk an lonoite loong reeraang rumla likhiik ah. Nengthe nengkhoh thet haat rumha langla samurangsoom tongli ah mirep eh toom sok he ih thun rumha. Ngah ih baat rumhala, neng loong hethaang ejen choh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sen samuh ih rangsoom tong andoh, sen the ah met, khoh ah thit, ");
INSERT INTO tvt_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","mih wahoh ih samurangsoom ha ih naktoom jat han—sen mik ih latup kan sen Wah eba toomjat han. Sen ngiija ni reeraang lan ah sen Wah ih tup ih halan, eno hethaang ah kohan. ");
INSERT INTO tvt_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Arah hah adoh sen nyamka ah nak lomthiin an, arah dowa bah ram nyia soot ih thet haat ah, nyia ehuh loong ih longlaang ah. ");
INSERT INTO tvt_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Erah nang ih bah, sen raangtaan ih rangmong nah thong lomthiin an, erah nah bah soot nyia ram ih tajen thet haatka, ehuh eh uh tajen longka. ");
INSERT INTO tvt_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tumeah sen nyamka marah di angla sen tenthun uh erah doh ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mik ah sak raangtaan ih weetook likhiik. Sen mik ah esing ang anbah, sen sakputang ah weephaak ang ah; ");
INSERT INTO tvt_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","enoothong sen mik ah laseeka bah, sen sakputang laamang nah ang ah. Erah ang abah sen sak nawa weephaak ah laphaakka bah, tumthan echoojih ih nakdat ah. ");
INSERT INTO tvt_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Sen wasiit ah changte wanyi dah tami angkan; sen ah wasiit asuh seechoh ean, wasiit asuh thichoh ean; sen ih wasiit jeng ah chaat, wasiit jeng ah phaaki et an. Erah likhiik sen Rangte nyia ngun raangtaan ih eroom eh tajen mokan. ");
INSERT INTO tvt_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Erah raang ih ngah ih baat rumhala: ethingtong raangtaan ih juungjok phaksat, adoleh khooloop raang ih nyuh akhat suh lasootsaam theng. Seng roidong ah phaksat nang ih thaangchaan tanih angka? Nyia sen sak ah nyuh akhat nang ih thaangchaan tanih angka? ");
INSERT INTO tvt_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Phih awoh loong ah sokthaak an: neng ih cham uh tawenka, ehui uh tahuika pung ni uh talom thiinka; ang abah uh Rangmong nawa sen Wah ih neng ah ban kooncha ruh eha! Sen atang woh nang ih thaangchaan tanih ang kan? ");
INSERT INTO tvt_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sen erah suh taat sootsaam anno sen roidong amasah taan ejen loot tong nih ean? ");
INSERT INTO tvt_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Eno sen ah nyuh akhat suh tume sootsaam lan? Sokthaak an woma nawa popoong loong mame hakla; neng raangtaan ih moot uh tamoka adoleh nyuh akhat uh tawaat rumka. ");
INSERT INTO tvt_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Amadi ngah ih baat rumhala luungwang Solomon botseh nyamte wah taat ang arah ih arah popoong loong jaaseela likhiik tajen jaase kapta. ");
INSERT INTO tvt_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Erah Rangte juuba woma nawa kho anaam loong jaase thukte ah—kho anaam chiinyah angla loong ah rangkhah takah thok tongka, we nah ba mattak wan ah. Erah ang abah heh ih sen suh nyuh akhat ah tang tanih jen koran? Sen tuungmaang amasah taan uh laje mame lan! ");
INSERT INTO tvt_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Erah raang ih nakkah sootsaam an: ‘Nga phaksat juungjok ma nawa et ang eah? Nyia nga nyuh akhat ma nawa et ang eah?’ ");
INSERT INTO tvt_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Erah loong asuh bah Ranglajatte loong aboh sootsaam ah.) Rangmong nawa sen Wah ih jat et ha sen ih tumjaat jam han rah ah. ");
INSERT INTO tvt_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Erah nang ih, jaakhoh Rangte Hasong ah chaak jam an heh ih tumjih raang ih jam halan jun ih ah, eno bah sen suh erah loong jaatrep ah jam kohan. ");
INSERT INTO tvt_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Erah thoih rangkhah suh sen nak sootsaam an; rangkhah suh rangkhah ih jat ah. Rangwuung rookwih sootsaam theng khoboot doh nakboot sootsaam an. ");
INSERT INTO tvt_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Sen ih mih ladande theng, eno ba sen ah Rangte ih tadande ran, ");
INSERT INTO tvt_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","tumeah sen ih mih mamet dande han erah jun ih Rangte ih sen emamah ih dande han, nyia mih damdi mame re lan erah likhiik ih Rangte uh sen damdoh emamah ih reeha. ");
INSERT INTO tvt_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Erah bah, sen ih sen joonte mikmaang ah mamet mi beek an, sen mik dowa bangthah ah laphang dok haat kanbah ah? ");
INSERT INTO tvt_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Senphoh senno suh sen ih mamet mi li an ‘An mikmaang ah beek ha eah’ sen mik nah bangthah ah hui anno ah? ");
INSERT INTO tvt_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Lonoite sen loong! Jaakhoh sen mik nawa bangthah ah chaak beek haat an, sen ah miksing ang an no ba senphoh senno mikmaang ah mi beek haat an. ");
INSERT INTO tvt_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Hi suh esaajih ah nak koh an—neng ih an ba ngaak phak ho. Sen ih thaangchaan jekteh ah wak ngathong nah nak haat an—neng ih enoopnak ba et ah. ");
INSERT INTO tvt_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Echeng et an, echoh ean, ejam et an echojam et an, erengtok et anno ba kaaluung ah daap kohan. ");
INSERT INTO tvt_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","O mina ih echeng et ah erah ih choh ah, o ih jam et ah erah ih chojam ah, o ih erengtok et ah erah suh kaaluung ah daap koh ah. ");
INSERT INTO tvt_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sen hewah angte loong ah ih sen sah suh jong nih katoon koh an phaksat suh handi ah? ");
INSERT INTO tvt_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Adoleh sen dowa nyasi suh hanbah pu nih koh an? ");
INSERT INTO tvt_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","An mathan taat thih ubah uh, an ih jat et hu an sah suh eseejih ah mamet kottheng ah. Erah ang abah Rangmong dowa sen Wah ih tang echengte suh bah eseejih ah kot suh ejat dook et ah! ");
INSERT INTO tvt_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“An teewah raangtaan ih an mame reelu wahoh raangtaan ih uh emamah ih re uh: Erah reelan asuh liita Moses Hootthe nyia khowah loong ih nyootsoot theng jengkhaap eah. ");
INSERT INTO tvt_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Sen paakaawan ehin adoh nopwang an, tumeah soolam paakaawan ah elong eno erah lam adi khoom suh elaang, erah di khoomte loong hantek je ah. ");
INSERT INTO tvt_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Enoothong roidong paakaawan abah ehin, eno erah di khoom ah echaan, erah thoih erah lam adi khoomte ah eneeko ah. ");
INSERT INTO tvt_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Sen banban ih tong an emoong tiitbaatte khowah loong jiin nawa ah; neng sen miksok doh saapsah likhiik eh thok ha, enoothong amiimi nengten nengmong nah bah so likhiik angrum ah. ");
INSERT INTO tvt_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sen ih neng reeraang nawa ih jat an. Suh phook nah anggut tiik ah tami dong tiikka, nyia suh phook nah puksak tiik tami dong tiikka. ");
INSERT INTO tvt_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bang se adoh hetiik uh ese ih tiik ah, enoothong jootthih ehin bang adoh hetiik uh jootthih ju ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bang se elong adoh babah uh jootthih tadong tiikka, nyia bangthih adoh uh jaase tadong tiikka ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Eno marah bang hetiik tatiikka erah dook ano we nah tak ah. ");
INSERT INTO tvt_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Erah likhiik, tiit emoong baatte khowah loong ah sen ih neng reeraang nawa ih jat et an. ");
INSERT INTO tvt_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Warep ih ngah suh ‘Teesu, Teesu’ ih poon thaang ih Rangmong hasong nah tachoh wangka, erah nang ih bah marah Rangmong nawa seng Wah ih mamet jamha jun ih reete loong abah chowang ah. ");
INSERT INTO tvt_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Dande sa thok kohaano ba, warep ih ngah suh ‘Teesu, Teesu ih liihang! An mendi seng ih Rangte tiit ah baat etti, an mendi seng ih juung abaan nep dokphanti erah damdi epaatjaajih uh ephoop reeti!’ ");
INSERT INTO tvt_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Eno erah sa doh Ngah ih neng suh li ang, ‘Ngah ih sen babah uh tajat rum taha. Mih lajak loong nga re nawa soon ean!’ ");
INSERT INTO tvt_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Erah thoih, o ih nga tiit ah chaat ano naririh et kap ha erah ih heh nok jong khoni hoon arah likhiik. ");
INSERT INTO tvt_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Jong khoni hoonha nok ah rang ah phaat, juung ah nuung, pong ah pong ih abah uh, babah uh tarungdatka, tumeah erah jong khoni hoonta. ");
INSERT INTO tvt_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Enoothong o mina ih nga tiit ah chaat ano takapka erah loong abah, thungko mina ih heh nok phisaang khoni hoon arah likhiik ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Rang ah phaat, juung ah nuung, pong ah pong ih kano, rungdat eah. Eno tumthan echoojih ang ah erah rungdat sa doh ah!” ");
INSERT INTO tvt_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisu ih erah tiit loong ah thoonbaat rum kano, miloong ah rapne ih paatja rumta heh ih nyootta jengkhaap ah chaat rum ano ah. ");
INSERT INTO tvt_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Heh ah Hootthe nyootte loong likhiik tah angta; erah nang ih, chaan aphaan lam ih nyootsoot rumta. ");
INSERT INTO tvt_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisu kong nawa dat khoom raaha di, miloong ah heh lilih ih roong phankhoom rumta. ");
INSERT INTO tvt_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Eno engam wasiit heh jiinni thok taha, heh lakuh di kottong ano, Jisu suh baatta, “Chuupha, an ih jen tenthet hang bah, ngah ah saasiit weehang.’’ ");
INSERT INTO tvt_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisu ih heh lak ah janghaat ano taajota. Eno liita “Ngah ih saasiit et ha.” “Sa uh!” Erah jengta damdam mih ah laan de ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Eno Jisu ih heh suh baatta, “Boichaat uh! O suh uh nak baat uh, erah nang ih bah phangla romwah re nah wang uno heh ih toomhuk soksam ho; erah dowa ih ba an ede etu ih warep ih jat ho, eno Moses ih baatta jun ih an khosa lakkot ah koh ih wan uh.” ");
INSERT INTO tvt_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisu Kapernum hadaang ni wang adi, Roman hate Apit nawa saahaap wasiit chomui ra taha eno heh lasih joh damdi baatta: ");
INSERT INTO tvt_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Chuupha, nga laksuh ah nok ni emoh uh lami moh ih satla.” ");
INSERT INTO tvt_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Jisu ih ngaakbaatta, Ngah ih deesiit ih raahang.” ");
INSERT INTO tvt_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Apit nawa saahaap rah ih liita, emah tah angka, Chuupha.” “Ngah ih an nga nok nah jen poon theethe tah angkang. An aadoh jeng udoh ju de ruh eah. ");
INSERT INTO tvt_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngah, uh, esiit nga saahaap lathong ni tonglang, eno ngah di uh sipaahi loong nga lalih ni eje. Ngah ih, ‘Kah uh!’ et baat ang bah ekaat eah; ‘Wang ho!’ ih poon ang bah uh heh wang eha erah damdoh nga laksuh asuh, ‘Arah re uh!’ ih baat ang bah heh re eah.” ");
INSERT INTO tvt_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisu ih erah chaat ano paatja eta, eno heh dam dowa miloong asuh baat rumta, “Ngah ih baat rumhala, Ngah ih Ijirel hani arah wah tuungmaangla likhiik maani uh tataat tupkang. ");
INSERT INTO tvt_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ngah ih amiitiit baat rumhala warep mina saadong saanop nawa thok haano Abraham, Isak nyia Jaakob loong damdoh Rangmong hasong nah sadung thengnah roongtong ah. ");
INSERT INTO tvt_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Enoothong o mina erah Hasong adoh wangjih taat angte loong ah laamang nah dok haatkaat ah, erah doh neng ih neng pha ah phak ano huung rum ah.” ");
INSERT INTO tvt_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Eno Jisu ih saahaap asuh baatta, “An nok nah kah uh, eno marah raang ih an tuungmaang laalomlu rah elang eah, eno erah baatta damdam saahaap laksuh ah laan de ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisu Pitar nok ni wangta, eno erah ni Pitar hopnuh ah sokwi ih sat arah tup wangta. ");
INSERT INTO tvt_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Eno Jisu ih heh lak adi taajoh damdam ih heh khoisat ah laan de ruh eta, eno saat ano Jisu suh phak asat roong sokboita. ");
INSERT INTO tvt_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Rangja ko ih hoon damdam, warep ih chiithih laakhah pan ang arah Jisu jiinni thoksiit rum taha. Eno Jisu ih erah chiithih laakhah loong ah heh jengkhaap nawa ih dokphan rumta eno khoisatte loong ah de ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Heh ih erah loong ah khowah Isaia ih banbaatta ah amiisak toom ang raaha ih reeta, Khowah Isaia ih amet baatta: “Heh teeteewah ih seng khoisat toonhui ano deesiit tahe.” ");
INSERT INTO tvt_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisu ih miloong ih kookchap halang ih jat ano, heliphante loong suh juungsitum saangko adoh daan kaat suh baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hootthe nyootte Jisu jiinni thok ano baatta, “Nyootte,” “Ngah an maanah kah uh erah doh roong ra suh banban ih tonglang.” ");
INSERT INTO tvt_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisu ih ngaakbaatta, “Maaut loong di neng luung jeela, phih awoh di neng tep jeela, enoothong Mina Sah adi bah heh khowi theng taan uh tajeeka.” ");
INSERT INTO tvt_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Heliphante dowa wasiit ih liita, “Chuupha, Jaakhoh ngah ih sengwah mang ah chaak beng wang ang.” ");
INSERT INTO tvt_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“Jisu ih ngaakbaatta, Nga lih thong phanhang etekte ih neng mang ah neng bengbeng et ah.” ");
INSERT INTO tvt_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisu ah khoonkhuung ni duungtong wang kano heliphante loong anep roongtong wang rumta. ");
INSERT INTO tvt_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Eno baphuk ih juungsitum adi pong ah pong ra haano, khoonkhuung ah elekmot nanah angta. Jisu ah erah tokdi emokjup eta. ");
INSERT INTO tvt_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Heliphante loong ah heh reeni karum ano saatsiit rumta. Eno neng ih li rumta, “Pang weehe, Teesu!” “Seng ah etek nanah angli!” ");
INSERT INTO tvt_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","“Sen erathan mame choolan?” Jisu ih ngaak li rumta. “Sen tuungmaang ah amasah uh laje mameela. Eno heh ah saat ano pong aphaat asuh baatta, erah damdam pong aphaat ah laan semruh eta. ");
INSERT INTO tvt_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Eno warep paatja rumta. “Arah tumjaat mih ah?” neng ih liita. “Pong aphaat ih nep heh jeng chaat ha!” ");
INSERT INTO tvt_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisu Gadara hadaang juungsitum saang ni thok adi, erah di mih wanyi mangrut nawa wang nyu arah chomuita. Erah wanyi sak adi micho miphaan Juungbaan pan ang nyuuta eno erah lam adi o uh takah naan khoom rumta. ");
INSERT INTO tvt_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Erah damdam nyi ah riinghuung nyu ano li nyuuta, “Rangte Sah an ih, sek tumjih et chung hali tih? Saapoot rook maangliika doh chamthuk suh tam raahalu?” ");
INSERT INTO tvt_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wakjook rumta dowa ih neng ah haloot ni tah angta. ");
INSERT INTO tvt_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Erah thoih chiithih laakhah loong ih Jisu lasih ah joh rum ano li rumta, “An ih seng ah edokphan jaatjaat et he bah therah wak loong sak adoh nopkaat thuk weehe.” ");
INSERT INTO tvt_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Kah an,’ Jisu ih baatta; eno laathih loong ah wak sak loong adi nop karumta. Eno wak loong ah juungsitum kaang ko ih soon karum ano juung adi chum lupdat karumta. ");
INSERT INTO tvt_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Eno wak riimte loong ah hadaang ko ih soonwang rum ano, emok wanyi sak nawa chiithih laakhah loong dokphanta tiit ah mirep suh baatwan rumta. ");
INSERT INTO tvt_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Eno samthung dowa miloong ah Jisu jiinni chomui wang rum ano, neng juungkhuung dowa dokkhoom raangtaan ih heh lasih joh karumta. ");
INSERT INTO tvt_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisu khoonkhuung adi duungtong ano juungsitum saangko samthung adi ngaak kata, ");
INSERT INTO tvt_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","eno erah di mararah mih ih hiimuung juptheng khoni thok piijah rum taha. Eno Jisu ih heh suh tuungmaang rumta ah tup ano, heh ih hiimuung asuh baatta, “An tenchaan uh, nga sah! An rangdah ah biin anaan et taho.” ");
INSERT INTO tvt_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Eno Hootthe nyootte loong ah waan rumta, “Arah mih rah ih bah Rangte kaanju tiit boh baat ha!” ");
INSERT INTO tvt_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisu ih neng ih tumjih thun rumta rah jat eta, eno baat rumta, “Sen ih erah likhiik ethih tenthun ah tumjih suh thunhan? ");
INSERT INTO tvt_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mih suh ‘An rangdah ah biin anaan et taho’ ih baat ah adoleh ‘Saat uno khoom uh,’ ih baat ah elaang nih ang ah? ");
INSERT INTO tvt_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Eno bah, Ngah ih sen suh jatthuk rumha, arah hah adi Mina Sah ih rangdah jen biin anaan jih chaan eje eah.” Eno heh ih hiimuung asuh baatta, “Saat uh, an juptheng ah khoonpi uno nok nah wang uh!” ");
INSERT INTO tvt_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Eno erah mih ah saat ano nok ni wangta. ");
INSERT INTO tvt_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Miloong rah ih erah sok rum ano neng echo ih rumta, eno erah likhiik chaan apaan ah mina suh nep boh koha ih, Rangte ah phoongpha rumta. ");
INSERT INTO tvt_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisu erah dowa kah ano lam ni khoom adi, heh ih sokse seete wasiit apit ni tong arah japtupta, heh men ah Mathiu. Eno Jisu ih baatta, “Nga lih phanhang.” Eno Mathiu ah toonchap ano roong kata. ");
INSERT INTO tvt_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisu ih Mathiu nok ni phaksat phaksah adi, sokse seete nyia rangdah miloong Jisu nyia heliphante loong damdi teebun ni roong thok phaksah rumta. ");
INSERT INTO tvt_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mararah Pharasi ih erah tup rum ano heliphante suh cheng rumta, “Sen suh nyootte wah ih erah likhiik miloong damdi mamet roong phaksah ha?” ");
INSERT INTO tvt_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisu ih japchaat ano ngaakbaat rumta, “Mina eseete ih phonwah tajamka, khoisatte ih ba jam ah. ");
INSERT INTO tvt_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Rangteele ni arah jengla rah tumjih suh liita, erah sokkah an: ‘Ngah ih minchan ba jamhang, hiiawak ih siik hoon tajam kang. ‘Ngah esoomtu ette mina poon taraarang, edut haat cho mina loong poon ra halang.” ");
INSERT INTO tvt_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Eno Juungtemte Joon liphante loong ah Jisu jiinni ra rum haano cheng rumta, “Pharisi nyia seng loong ah samurangsoom etong kah eh ih, enoothong an liphante loong ah mamah latong erumla?” ");
INSERT INTO tvt_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisu ih ngaakbaatta, “Kuhoon sa doh jaalah kapte wah pandoh, wenwah loong ah thung joongjoong toom ih tong rum ah ih tam thunhan? Emah babah uh tami angka! Enoothong heh rangwuung saasiit thok eha jaalah kapte ah neng re nawa toonsiit wan suh ah, eno erah tokdoh ba neng ah samuh tong rum ah. ");
INSERT INTO tvt_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“O ih uh nyulep ena ih samsong ehak adoh talep phingka, tumeah nyuna lep ah ih ehak samsong ah eboot raap hoom et ah eno poolong thoon ih boot hoon thuk ah. ");
INSERT INTO tvt_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Adoleh kham ena rah siikhoop tiikook kham hak thiincho nah tathiinka tumeah tiikook nyia kham ah enyiinyi thih ah. Erah nang ih bah kham na ah tiikook ena nah ju thiin ah, eno ba tiikook nyia kham enyiinyi ese ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisu ih erah baat rum adi, Jehudi nok hah saahaap wasiit wang taha, eno heh lakuh di tong ano Jisu suh baatta, “Nga sah minusah ah amamadi tiila; enoothong an ah wangho no an lak ih taajoh ubah heh ething eah.” ");
INSERT INTO tvt_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Erah thoih Jisu ah heh lilih ih roong phankhoom wangta, eno heliphante loong anep heh damdi roongwang rumta. ");
INSERT INTO tvt_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Minuh esiit asih paang nyi heh sih jan arah Jisu lini chap wang ano heh nyukaangba ni taajota. ");
INSERT INTO tvt_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Heh ih heteeteenuh suh liita, “Ngah ih heh nyukaang adoh taan taajoh angbah nga khoisat ah ede eang.” ");
INSERT INTO tvt_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisu ih leksok ano erah nuh ah japtupta eno baatta, “An tenthun chaan uh, nga sah! An tuungmaang jun ih deelu.” Erah damdam ih minuh ah deeta. ");
INSERT INTO tvt_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Eno Jisu ah saahaap nok ni kah adi, mangbeng kaat suh boongkaat seehoon nyia miloong huung ariing ah sok ano ");
INSERT INTO tvt_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","liita, “loongtang dokkhoom an! Minusah ah etek tah eka—heh ejup boh ela! Eno loongtang ih ngit rumta. ");
INSERT INTO tvt_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Miloong ah dokkhoom rum ano, Jisu ah minusah jupta nokmong adi wang ano heh lak adi saat hoom kano saatta. ");
INSERT INTO tvt_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Erah tiit ah deek akaan noongrep ni ruurangta. ");
INSERT INTO tvt_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisu erah hah dowa lam ni dokkhoom kah adi, edook wanyi roongphan khoomta. Nengnyi ah riing nyuuta “Dewid sah sek minchan weeheetih!” ");
INSERT INTO tvt_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisu nokmong ni wang adi, mikdook wanyi ah heh jiinni wang nyu taha, eno Jisu ih cheng nyuuta, “Ngah ih set ejen deesiit et nyuuha ih hanpi nih et hali tih?” Nyi ih liita “Ehanpi et hi tih, Chuupha!” ");
INSERT INTO tvt_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Eno Jisu ih nyi mik adi taajoh ano liita, “Set hanpi jun ih toom ang raaha!”— ");
INSERT INTO tvt_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","eno nyi mik ah ngaaksing nyuuta. Jisu ih haam nyuuta, “Arah o suh uh nak baat ansih!” ");
INSERT INTO tvt_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ang abah uh nyi dokkhoom nyu ano erah ruurang tiit ah deek akaan noongrep ni tumbaat kaat nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Neng erah dowa dokkhoom rum adi, mararah mih ih Jisu jiinni engong, chiithih laakhah pan wasiit thoksiit taha. ");
INSERT INTO tvt_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Enoothong chiithih laakhah rah dokphan damdam, erah wah ah laan dongjeng ruh eta, eno warep paatja rumta. “Seng ih arah likhiik Ijirel deek akaan ni tathaak tupke!” Neng loong ah paatti rumta. ");
INSERT INTO tvt_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Enoothong Pharisi loong ih li rumta, Heh suh Hakhoh luungwang ih chiithih laakhah loong dokphanjih chaan ah koha.” ");
INSERT INTO tvt_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisu hadaang hadaang nyia samnuthung rep ni leng khoomta. Heh ih Jehudi rangsoomnok ni Ruurang Ese rangmong hasong tiit baat lam ih nyootsoot rumta, erah dam ih hephan dowa khoisat maasatte loong ah nep deesiit rumta. ");
INSERT INTO tvt_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Miloong ah sok rum ano, Jisu ah thungthita, tumeah neng ah menmiikeechan nyia sootsaamsaam ang rumta, saapsah loong saapriimte muh kah ang arah likhiik ah. ");
INSERT INTO tvt_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Eno heh ih heliphante loong suh baatta, “Cham ekhan theng ah rapne ehan, enoothong elom khante ah amasah. ");
INSERT INTO tvt_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Phek changte wah suh cham khante kaat thuk raang ih rangsoom an.” ");
INSERT INTO tvt_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisu ih heliphante asih wanyi ah lompoon rum ano neng suh chiithih laakhah loong jen dokphan suh nyia jaatrep khoisat maasat loong ah jen deesiit suh chaan korumta. ");
INSERT INTO tvt_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Heliphante asih wanyi loong ah arah: Phangkhothoon ah Simoon (Pitar et poonha rah) nyia heh no Endriu; Jebidi sah Jeems nyia heh no Joon, ");
INSERT INTO tvt_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip nyia Bartolomew; Thomas nyia sokseete Mathiu; Alphaeus sah Jeems nyia Thadaeus; ");
INSERT INTO tvt_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","deek akaan pangte Simoon nyia Jisu mokwaante Judas Eskerot. ");
INSERT INTO tvt_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisu ih arah asih wanyi asuh amet baat rum ano daapkaat rumta: “Ranglajatte juungkhuung adoleh Samaria samthung maadoh uh nak kah an. ");
INSERT INTO tvt_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Erah nang ih bah, saapsah mala loong Ijirel mina jiin adoh kah an. ");
INSERT INTO tvt_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kah an tumbaat kaat an, ‘Rangmong Hasong ah thok ih hala ih baatkaat an!’ ");
INSERT INTO tvt_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Khoisatte ah deesiit an, etekte ah ngaakthing thuk an, eput engam loong ah deesiit kah anno chiithih laakhah loong ah dokphan et an. Sen ih thaangmuh ih cholan, ah thaangmuh ih koh an. ");
INSERT INTO tvt_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sen ih sen khaakdaap nah ngun akom, hun achaak adoleh jaansaang ngun nak hui an; ");
INSERT INTO tvt_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","sen ih kunma khaak lahuitheng, adoleh samsong hedaap lahuitheng nyia lakhoop uh lahuitheng adoleh kiingthom uh lathutheng. Mootkaatte suh heh ih tumjih jamha rah ekot et ah. ");
INSERT INTO tvt_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Sen sam nah nyia hadaang nah thok an radoh, wang anno sen noppoonte ah chaak jam sok an, eno sen noppoonte wah nok adoh erah hah dowa maang dokkhoom khoom ih tong an. ");
INSERT INTO tvt_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Sen nok nah duungkhoom an radoh, ‘Semroongroong toomtong uh ih jengseera an.’ ");
INSERT INTO tvt_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Erah nok dowa mina rah ih sen ah tenroon lam ih noppoon hanbah, sen jengseera ah ban tongruh eah; enoothong lanoppoon ranbah, jengseera tan ah ngaaktoon et an. ");
INSERT INTO tvt_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Erah dam ih o ih neng nok nah adoleh neng hadaang nah lanoppoon ranbah adoleh sen jeng laboichaatka bah, erah hah adoh sen lah nawa bungwiik ah jaanak thiin anno dokkhoom an. ");
INSERT INTO tvt_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ngah ih dangdang et baat rumhala, Dande Sa thok ha doh Rangte ih Sodom nyia Gomora ah baalaan minchan ah erah hadaang dowa mina loong nang ih bah ah! ");
INSERT INTO tvt_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Boichaat an! Ngah ih sen loong ah so dung ni saap likhiik et daapkaat rumhala. Sen loong ah pu likhiik mongwah nyia wotuupi likhiik toongtang angtheng. ");
INSERT INTO tvt_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ban sok ruh ih an, mih ih sen loong ah jokhak hanno mat hoon nok nah siitkaat han eno, Jehudi rangsoomnok nah buh kaat han. ");
INSERT INTO tvt_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nga thoi thoidoh sen loong ah teesuh luungwang loong ngathong nah siiwi kaat han, erah doh neng loong suh nyia Ranglajatte loong suh Ruurang Ese tiit ah baat an. ");
INSERT INTO tvt_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Sen maatok doh siiwi han, erah doh mame jeng ang nyia tumjih jeng baat ang ih lacho theng; saapoot thok haano, sen tumjih jengjih ah erah jeng thuk han. ");
INSERT INTO tvt_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Marah jengkhaap sen jeng an, erah jengkhaap ah, sen jengkhaap lah angthang ih; sen Wah moong achaang ih sen ah jeng thuk han. ");
INSERT INTO tvt_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Miloong ih nengphoh nengno ah mih lak nah tek haat thuk ah, hewah loong ah ih uh neng sah loong ah emamah et ah; heh sah loong ah nuh awah damdoh piiara ehoon ano tek haat thuk ah. ");
INSERT INTO tvt_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Warep ih sen ah nga tungthoidoh miksuk et han. Enoothong o mina ih hethoon tuk ih Rangte suh tuungmaangte loong aba puirum ah. ");
INSERT INTO tvt_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Sen hasiit nah siiwi han adoh, hahoh nah toonsoon kah an. Ngah ih amiimi baat rumhala Mina Sah raak ngah nah sen ih Ijirel hadaang loong adoh sen mootkaat ah tajen thoon moh kan ang an. ");
INSERT INTO tvt_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“O noodek uh heh suh nyootte nang ih elong tajen angka; laksuh rah uh heh changte nang ih elong tajen angka. ");
INSERT INTO tvt_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Erah thoih noodek ah heh suh Nyootte likhiik ih hoontheng, eno laksuh rah heh changte likhiik ih hoontheng. Changka nawa phokhothoon asuh Beljibul et poon abah, heh jaatang asuh tang tumthan ethih et li ah! ");
INSERT INTO tvt_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Erah thoih mih ra lacho theng. Marah amadi hoppat cho angla ah daap et ah, erah dam ih marah husah ni angla ah wuungsa nah dongjat ah. ");
INSERT INTO tvt_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ngah ih laamang ni baat rumhala ah sen ih wuungsa nah we dong baat an, erah dam ih marah husah ni chaat han ah sen ih nok wokong nawa ih riingbaat jaat et an. ");
INSERT INTO tvt_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hansi tek haatte ra ah nakcho an neng ih chiiala tajen tek haatka; erah nang ih bah Rangte ra cho an, heh ih ba hansi nyia chiiala soolam nah jen tek haat ah. ");
INSERT INTO tvt_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Wosiksak enyi ah sen ih phaasiit ngunsah ih reh han, ang abah uh wosiksak esiit taan uh sen Rangte jengkhaap muh doh tatiika. ");
INSERT INTO tvt_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Sen loong ah sen khoroon botseh uh rookwet cho. ");
INSERT INTO tvt_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Erah thoih sen lacho theng; sen ah wosiksak loong nang ih botseh uh thaangchaan thoon! ");
INSERT INTO tvt_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“O mina ih noksong dung nah nga heh mina ih chaanghang bah, ngah ih uh Rangmong nah seng wah nganah emamah ih chaang ang. ");
INSERT INTO tvt_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Enoothong o ih ngah noksong dung nah thaangju hang, Ngah ih uh Rangmong dowa seng Wah ngathong nah emamah ih thaangju ang. ");
INSERT INTO tvt_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Sen ih nakthun an ngah arah mongrep adoh semroongroong ang thuk suh heh raak koha eah. Emah tah angka, ngah semroongroong angsuh taraarang erah nang ih bah lang apah ba jahang. ");
INSERT INTO tvt_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ngah ih heh sah loong ah neng wah damdoh miksuk muithuk suh, minusah loong ah neng nuh damdoh miksuk muithuk suh, neng nyam loong ah neng hopnuh damdoh miksuk muithuk suh ra tahang; ");
INSERT INTO tvt_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","sen piiara ethithoon ah sen jaajaatang nawa ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“O mina ih heh nuh heh wah ah nga nang ih ehan mongnook ha erah nga liphante angsuh tapunka; o mina ih heh sah ah nga nang ih ehan ih mongnook ha erah nga liphante angsuh tapunka. ");
INSERT INTO tvt_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","O mina ih heh bangphak ah hui ano ngah lih tajen phanrang erah mih ah nga liphante angsuh tapunka. ");
INSERT INTO tvt_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","O mina ih heh roidong puipang taat thunha erah ih mat haat et ah; enoothong o mina ih heh roidong ah nga raangtaan ih koh ah erah echoh eah. ");
INSERT INTO tvt_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“O mina ih an noppoon halu erah ih ngah noppoon halang; eno o mina ih ngah noppoon halang erah ih nga daapkaatte wah ah noppoonha. ");
INSERT INTO tvt_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","O mina ih Rangte kaamwah ah noppoonha, tumeah heh ah Rangte kaamwah angthoi ah, heh uh erah thaang ah roong choh ah. Erah dam ih o mina ih kateng mina ah noppoonha tumeah heh ah kateng ang thoidi, heh uh erah thaang ah roong choh ah. ");
INSERT INTO tvt_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Eno o mina ih nga liphante loong suh joong taan jok thuk abah, tumeah neng ah nga liphante angthoi ah, neng uh erah thaang ah roong choh ah.” ");
INSERT INTO tvt_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisu ih heliphante asih wanyi loong asuh thoon reenbaat rum ano, heh erah dowa hahoh ni dokkhoom ano hakhuung hatok hadaang adi tum nyootsoot kaatta. ");
INSERT INTO tvt_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juungtemte Joon ih phaatak ni Jisu Kristo reeraang loong ah japchaat ano, mararah heliphante loong ah Jisu jiinni daapkaatta. ");
INSERT INTO tvt_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Eno heliphante ih cheng rumta, “An tamanglu Juungtemte Joon ih wasiit raak eha ih baatta rah ah, tama seng ih wahoh bansokjih angkah?” ");
INSERT INTO tvt_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisu ih ngaakbaatta, “Ngaakwang anno Juungtemte Joon suh sen ih tup han nyia chaat han ah baatwan an: ");
INSERT INTO tvt_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","edook loong ih tup eha, lakoong ah mi khoom ela, eput engam loong ah ede ela, naabaang loong ah ih chaat eha, etekte ah ngaakthing ela, eno Ruurang Ese ah changthih loong suh nyootsoot ha. ");
INSERT INTO tvt_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tumthan tenroon ang ah o ngah suh mongchi lah angte loong rah ah!” ");
INSERT INTO tvt_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juungtemte Joon liphante loong ah dokkhoom rum adi Jisu ih miloong asuh Joon tiit ah baat rumta: “Sen Joon re nah phisaang hah ko ih kah tan adi, sen ih tumjih japtup ih, et thuntan? Naamphook loong ah pong ih pheekmoot arah tam tuptan? ");
INSERT INTO tvt_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Adoleh tumjih japtup raangtaan ih katan? Mih wasiit nyuse khatse nawa ih choomraang cho ang arah tup ih tam thuntan? Eme choomte mina bah luungwang nok nah ba tong ah! ");
INSERT INTO tvt_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Baat he, sen ih tumjaat japtup suh dokkhoom tan? Khowah tama? Elang eah, enoothong heh ah khowah nang ih elong ang arah japtup tan. ");
INSERT INTO tvt_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juungtemte Joon ah Rangteele ni raangthiinta wah ah: ‘Rangte ih liita, Nga kongphaak huite sen raangtaan ih lam ban laang suh sen ngah nah daapkaat hang.’ ");
INSERT INTO tvt_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngah ih ami tiit baat rumhala Juungtemte Joon likhiik elongthoon o mina uh maang dongka. Enoothong o mina rangmong Hasong nah ehinthoon ang ah erah mih ah Joon nang ih elong ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juungtemte Joon ih nyootsoot rumta tok dowa ih amatuk ih Rangmong Hasong nawa loong ah chamnaang thuk ruh eha, erah dam ih ethih miloong ah ih chaan ih rangmong Hasong ah ngeesuh taat chung rumha. ");
INSERT INTO tvt_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Rangmong Hasong tiit ah Moses nyia Khowah loong ih Juungtemte Joon phang angta tuk ih banbaatcho angta; ");
INSERT INTO tvt_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","eno sen ih erah jengkhaap ah hanpi thung ang anbah, Juungtemte Joon ah Elijah ang ah, heh raak tiit ah jaakhoh ni banbaatta jun ih ah. ");
INSERT INTO tvt_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Boichaat an, sen na je abah ah! ");
INSERT INTO tvt_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Amadoh, Ngah ih ahaangwa mina loong ah tumjih doh toobaat rum ang? Neng ah noodek loong thaangsang theng ni tong rum arah likhiik. Eno hedung hedung riingwaan rum arah likhiik, ");
INSERT INTO tvt_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Seng ih sen suh kuhoon saamtom koh idi sen ah tah boong aloom kan! Seng ah mangboong boong kino sen ah tahuungkan!’ ");
INSERT INTO tvt_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Joon samuh tong ra taha adi kham uh tajokta, eno warep ih li rumta, ‘Heh sak ni chiithih laakhah pan boh ah!’ ");
INSERT INTO tvt_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Eno Mina Sah ah ra haano, jok phaksata eno, warep ih liita, ‘Arah mih ah sok an! Heh bah mangda nyi kham kaanya adoleh sokse seete, nyia thaaju mina loong joonte!’ Erabah uh, Rangte mongtham ah, ami et dongjatjih ah heh mootkaat nah noisok ah.” ");
INSERT INTO tvt_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Maradi Jisu ih epaatjaajih ehan reeta erah hadaang mina loong ah neng rangdah nawa tangaak lekta, erah thoih heh ih erah hadaang loong ah ethetbaat etta. ");
INSERT INTO tvt_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korajin mina loong, sen suh tumthan echoojih ang ah! Betsaida mina loong sen suh uh tumthan echoojih ang ah! Marah epaatjaajih loong sen suh re tang ah Tairi nyia Sidoon hadaang nah re tang bah, erah nawa mina loong abah ehak doh dook khuupo nyuh ah kap rum ano laabot khonah jen tong ih thengta rangdah nawa ngaaklek eti ih noisok suh ah! ");
INSERT INTO tvt_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngah ih ami tiit baat rumhala, Dandeeja doh Rangte ih sen nang ih Tairi nyia Sidoon mina loong asuh ba heh minchan ehan noisok ah! ");
INSERT INTO tvt_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Eno sen Keparnam mina loong! Sen ih sen teeteewah suh rang nah chowang ih tam thunhan? Sen bah soolam nah dat haatte ang halan! Marah epaatjaajih sen suh re korum taha rah Sodom nah re doh bah, amadoh uh Sodom eje ang thengta! ");
INSERT INTO tvt_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Sen ih jat et theng Dandeeja doh Rangte ih sen nang ih ehan ah Sodom ah minchan ah!” ");
INSERT INTO tvt_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Erah tokdi Jisu ih rangsoomta, “Ewah, rang nyi hah Teesu! Ngah ih an suh lakookmi li hala tumeah an ih marah mongwah maakwah nyia ejatchoite asuh lajat thukthang ih huthiin uno lajatte loong asuh noisok hu. ");
INSERT INTO tvt_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","“Ewah, elang eh uh, erah ah an thungpun jun ih ju angla. ");
INSERT INTO tvt_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Seng Wah ih ngah suh jirep ah kohalang. O eh uh heh Sah ah tajatka heh Wah luulu ih ba jat ah, adoleh heh wah ah o eh uh tajatka heh Sah ih luulu ih ba jat ah, nyia heh Sah ih o mina erah jatthuk suh danjoh ah loong ih ba jat ah. ");
INSERT INTO tvt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nga jiinnah wanghan, o huijih ih naang pat halan loong ah, ngah ih naangtong thuk rumha. ");
INSERT INTO tvt_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nga kaangkoong ah kap an, eno ngah dowa nyoot he, tumeah ngah ah chiiala ni toongtang nyia thungsek; eno ba sen naangtong ah choh an. ");
INSERT INTO tvt_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kaangkoong marah ngah ih koh rumhala ah elaang, nyia marah ngah ih hui huithuk rumhala ah huichaang.” ");
INSERT INTO tvt_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Erah lini, Jehudi Naangtongsa di Jisu mararah phek ni chamtong ni daankhoomta. Heliphante loong ah ramtek ang rumta, erah thoih neng ih chamnam nawa raanteh ah phang thiiphak rumta. ");
INSERT INTO tvt_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pharisi loong ih erah tup rum ano, Jisu suh li rumta, “Sok uh, an liphante loong ih naangtongsa di erah re rumla ah seng Hootthe di tapunka!” ");
INSERT INTO tvt_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisu ih ngaakbaat rumta, “Sen ih taba jap wetan Dewid nyia heh mina loong neng ram ih tiita adi tumjih et rumta? ");
INSERT INTO tvt_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dewid ah Rangte nok ni wangta adi, heh nyia heh joonte loong ah ih baanlo Rangte suh kota ah phak rumta, neng Hootthe jun ih emiit taat ang abah uh ah—erah baanlo ah Romwah ih baajen phaksajih angta. ");
INSERT INTO tvt_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Adoleh sen ih Moses Hootthe ah tanih wetan naangtongsa rookwih romwah loong ih hootthe thetsiit ha rah ah, ang abah uh neng suh ethih taliika? ");
INSERT INTO tvt_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ngah ih baat rumhala, Rangteenok nang ih aradi tumjih boh uh elong eje. ");
INSERT INTO tvt_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Rangteele ni liita, ‘Ngah ih minchan ba jamhang, senli senmaan ih romhoon tajam kang.’ Sen ih amiisak ih jattan bah, sen ih lathika mih ah takaanju theng angtan; ");
INSERT INTO tvt_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","erah thoidi mina Sah ah naangtongsa raang ih Teesu ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisu erah hah dowa dokkhoom ano Jehudi rangsoomnok ni wangta, ");
INSERT INTO tvt_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","erah di heh lakkoong ang arah mih esiit angta. Mararah mina erah di Jisu ah thetre ela ih mat ih deejootte eje angta, erah thoidi neng ih heh suh cheng rumta, “Seng hootthe jun ih Jehudi naangtongsa doh khoisatte ah ejen deesiit nih et ah?” ");
INSERT INTO tvt_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisu ih ngaakbaat rumta, “Jengthaak ih sen wasiit thandoh sen saapsah ah Jehudi naangtongsa doh habeng nah dat abah, tanih toonsiit kan? ");
INSERT INTO tvt_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mina ah tang, saapsah nang ih thaangchaan thoon! Erah raang ih, seng Hootthe ih Jehudi naangtongsa doh ese raangtaan ih mih chosok abah tahaamka.” ");
INSERT INTO tvt_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Eno lakkoong asuh baatta, “An lak ah janghaat uh.” Heh lak ah janghaat kano, lakse ko ah likhiik, laan de ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Eno Pharisi loong ah erah dowa dokkhoom rum ano Jisu tek haat suh kaankoong rumta. ");
INSERT INTO tvt_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisu ih heh tek haat tiitwaan japchaat ano, erah hah dowa dokkhoom eta; eno heh damdi miloong ah hantek roong phankhoom rumta. Jisu ih khoisatte loongtang deesiit rumta ");
INSERT INTO tvt_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","eno heh tiit ah o suh uh labaat theng ih liita. ");
INSERT INTO tvt_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Heh ih erah reeta ah langla Rangte ih khowah Isaia suh mamet baatta erah jun ih amiisak toom ang raaha ih liita: ");
INSERT INTO tvt_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nga laksuh ngah ih danje tang ah arah, marah nga mongnook, nyia marah suh nga tenroon anglang ah. Nga jiin nawa Chiiala ah heh sak nah kaat thuk ang, eno ngah ih dande sa tiit ah deek akaan loong suh heh ih dongbaat ah. ");
INSERT INTO tvt_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Heh mih damdoh tadaan muika adoleh tariing raakka, adoleh taakkhuung nah erong ih tatum riingka. ");
INSERT INTO tvt_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Heh ih naam ekotdat ela ah tathahoomka, adoleh weetook emet nanah ah tathoon met thukka. Kateng mootkaat ah maang langlang heh ih tatooka, ");
INSERT INTO tvt_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","eno mirep laalom ah heh suh totoh ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Erah lidi mararah mih ih Jisu jiinni chiithih laakhah pan edook heh jeng uh lami jengka rah thoksiit rum taha. Eno Jisu ih erah wah ah deesiit kano dongjengta, nyia dong tupta. ");
INSERT INTO tvt_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jisu reeta loong ah sok rum ano miloong ah paatja ih rumta. “Heh ah Dewid sah tam angla? Neng ih chengta. ");
INSERT INTO tvt_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pharisi loong ih erah japchaat rum ano, ngaakbaat rumta, “Heh ih chiithih laakhah loong abah neng pante Beljibul ih chaan ah kot kano jen dokphan ha.” ");
INSERT INTO tvt_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisu ih neng ih tumjih thun rumha rah jat eta, eno baat rumta, “Marah deek akaan ang abah uh neng chamchi nah hedung hedung ih phe rookmui abah saatang tacheng tongka. Erah dam ih marah changka adoleh hadaang maama ih pheetong rum ano rookmui abah neng ah ethoon phaangjaang eah. ");
INSERT INTO tvt_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Erah ang abah Soitaan hasong adoh neng chamchi nah esiit esiit ih mok rookmui rum abah, erah langla neng ah maama maama ih ejen pheephaak ih rumta eno seek ih phaangjaang rum ah! ");
INSERT INTO tvt_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sen ih ngah suh li hali chiithih laakhah loong ah Beljibul chaan nawa ih dokphan ha eah. Emang abah sen liphante loong asuh chiithih laakhah dokphan theng chaan ah o ih koha? Sen liphante loong moh rumla jun ih bah sen ah emoong elan ih dongjat thuk ha! ");
INSERT INTO tvt_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Emah tah angka, Ngah suh Beljibul ih chaan takoh rang, Rangte ih kohang rah heh chaan aphaan nawa ih laathih loong ah jen dokphan hang, erah jun ih sen suh Rangte Hasong ah sen jiinni ejen thok ih taha ih jathuk halan. ");
INSERT INTO tvt_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“O ih ang abah uh tathat wah nok ah long ano hukkhaak ah dok suh li abah, jaakhoh heh teewah ah phang tangkhakjih; eno ba heh nok ah jen longwang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“O bah uh nga raangtaan tah angka erah nga miksukte; o bah uh nga damdi taroong moh ra erah esaapta eah. ");
INSERT INTO tvt_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Erah thoidi Ngah ih baat rumhala: mina rangdah nyia ethih jeng akong tumjaat ang abah uh ejen biin anaan et ah; enoothong o ih bah uh Esa Chiiala suh ethih li abah biin anaan tachoka ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","O ih bah uh Mina Sah asuh tumjih doh bah uh ethih li abah biin anaan et ah, enoothong o ih bah uh Esa Chiiala asuh ethih li abah roitang raang ih biin anaan tachoka ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Bangtiik tiikse ah chosuh heh bang ah bang se angjih; hebang jootthih ang abah, hetiik uh jootthih ih dong tiik ah. Bangthih bang se ah hetiik nawa ih danjat ha. ");
INSERT INTO tvt_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pu sen loong ah—sen ethih ang anbah ese jengkhaap ah ma nawa ma jeng an? Tumeah tenni tumjih ih meela tu ni erah dongjengla. ");
INSERT INTO tvt_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mina eseete ih heten hemong ni ese thunha rah ju dongjengla; ethih mina ih heh tenthun ni ethih thunha loong ah dongjengla. ");
INSERT INTO tvt_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Sen ih jat etheng Dande Sa doh sen lalangka jengkhaap jenglan loong ah erookwet kot etheng ang an. ");
INSERT INTO tvt_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sen jengkhaap khaap ah sen dandeete ang ah—toongtang tam emoong ang lan ah dongjat suh ah.” ");
INSERT INTO tvt_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Eno mararah Hootthe nyootte nyia Phirasi loong ih liita, “Nyootte,” “an ih epaatjaajih re uh rah sok suh nookli.” ");
INSERT INTO tvt_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jisu ah jengta, “Ahaangwa mina loong ah tumthan ethih nyia rangmuh ih tong rumla! “Sen ih nga dowa epaatjaajih nikah cheng he? Tah angka! Epaatjaajih sen suh kotheng abah khowah Joona tiit ah luulu ba. ");
INSERT INTO tvt_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Joona ah hephe pheejom hesa sa jom nyah mong ni tongta likhiik, Mina Sah rah uh arah hakhu adoh hesa sa jom hephe pheejom tong ah. ");
INSERT INTO tvt_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dande sa doh Ninewe mina loong ah toonchap rum ano sen suh ethih liihan, tumeah Joona ih nyootsoot rumta adi botseh chaat rum ano neng rangdah nawa ngaaklek ih rumta; eno ngah ih baat rumhala aradi tang, Joona nang ih elong! ");
INSERT INTO tvt_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dande sa doh Siba dowa Wangchaanah ah toonchap ano sen ah ethih liihan, tumeah heh ah hedeek hekaan ni luungwang Solomon jatwah jengkhaap japchaat suh noongrep ni tumkhoomta; eno ngah ih dangdang ih baat rumhala aradi Solomon nang ih tumjih bah uh elong eje! ");
INSERT INTO tvt_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Chiithih laakhah ah mih sak nawa doksoon ano, deek akaan hookpakpak adoh heh naangtong theng jam sokkah ah. Eno heh tongtheng ah lamok choka bah, ");
INSERT INTO tvt_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","heh teeteewah suh li ah, ‘Nga nok nah ngaakwang ang.’ Eno ngaakwang ano nok ah hahuung saachamcham nyia jaatrep ah toonriim cho et japtup wang ah. ");
INSERT INTO tvt_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Eno we ngaak kah ano heh damdoh heh nang ih ethithoon laathih sinet boot toonsiit kah ah eno tongwang rum ah. Eno erah loong ah langta no ba, erah mina ah ephang dowa nang ih ethithoon ih hoon ah. Ahaangwa ethih mina loong raang ih emah ih ang raaha.” ");
INSERT INTO tvt_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Heh nuh nyi no loong thok tokdi uh, Jisu ah miloong ah damdi thok waantiit ruh eta. Neng taakkhuung ni chap rum ano, heh damdoh chowaan suh baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Eno erah dowa mih wasiit ih baat wanta, “An nuh nyi no loong taakkhuung ni chap rumla, an damdoh chowaan suh li rumha tih.” ");
INSERT INTO tvt_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisu ih ngaakbaatta, “O ah seng nuh ah? Nyia nga no loong ah o ah?” ");
INSERT INTO tvt_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eno heh ih heliphante loong ah siingsuh ano liita, “Sok an! Arah loong ah ba seng nuh nyia nga no loong ah! ");
INSERT INTO tvt_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","O mina ih Rangmong dowa seng Wah ih jamha jun ih reeraangte loong aba seng nuh, adoleh ngaano ngaanah nyia Ngaaphoh ngaano ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Erah saasa di Jisu erah nok dowa dokkhoom ano juungsitum ko ih kata, eno erah di nyootsoot et suh tong kata. ");
INSERT INTO tvt_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Heh reeni kookchap kaatte miloong ah rapne hantek angta erah thoidi Jisu ah khoonkhuung ni duungtong wangta, eno miloong ah juungsitum kaang adi chap rumta. ");
INSERT INTO tvt_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Heh ih jirep tiit ah tiitthaak lam ih toobaat rumta. “Teewadi mih wasiit ih raanjih wenta. ");
INSERT INTO tvt_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Phek ni wenkaat adi, mararah raanteh ah lam ni datta, eno woh loong ih toontop kaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mararah raanteh ah jong hah ni datta, eno paak ah amasah ang thoidi, raanteh ah seek ih haapphokta. ");
INSERT INTO tvt_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Eno rangsa ah dong ano, champhook saloong ah tek raatta; tumeah hehing ah hanteng ni tasotta, erah thoidi champhook ah seek ih hookta. ");
INSERT INTO tvt_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mararah raanteh ah suh haang khui ni datta, eno hak ano champhook loong ah bukjota. ");
INSERT INTO tvt_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Enoothong mararah raanteh hah se ni datta loong ah, hak ano hetiik ah dong tiikta; mararah chaasiit ih dong tiikta, rukho ah rook arok, eno rukho ah rookjom.” ");
INSERT INTO tvt_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Eno Jisu ih thoonbaat rumta, “Chaat an sen na je abah ah!” ");
INSERT INTO tvt_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Eno heliphante loong ah Jisu jiinni thokrum ano cheng rumta, “An ih mih damdi waan uh di tiitthaak loong ah tumet suh katoobaat uh?” ");
INSERT INTO tvt_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisu ih ngaakbaatta, “Rangmong hasong lam thoijat raang ih sen suh thung atak korumhala, enoothong neng suh bah takokang. ");
INSERT INTO tvt_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","O mina di tumjih bah uh amasah jeela erah suh ehan ih boot kotheng, eno ba erah mih ah laboot labe ang ah; enoothong o mina di amasah taan uh amukte dowa amasah jeela rah uh ethoon nge et ah. ");
INSERT INTO tvt_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ngah ih tiitthaak toobaat korum hang ah langla neng ih sok et rum ah, ang abah uh, tatup rumka adoleh neng ih boichaat et rum ah, ang abah uh tachaat rumka nyia tasamjat rumka ang arah likhiik. ");
INSERT INTO tvt_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Erah thoidi Isaia khowah ih banbaatta jengkhaap ah neng raangtaan suh punla: ‘Arah miloong ah ih chaat ba chaat ah, ang abah uh tasamjat rumka; neng ih sok ba sok ah, ang abah uh tatup rumka, ");
INSERT INTO tvt_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","tumeah neng thung ah thungko, nyia neng na ah ekep et rumta nyia neng mik ah echup et rumta. Emah lah angta bah, neng mik ih tup ih thengta, neng na ih chaat et thengta, neng thung ah ih samjat et thengta, neng ah nga jiinko nah engaak ih rumtheng taha, Rangte ih liita, eno ba Ngah ih neng deesiit thengtang.’ ");
INSERT INTO tvt_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Sen loong abah, rapne khangraangse mina tumeah sen mik ih tup ehan nyia sen na ih chaat ehan! ");
INSERT INTO tvt_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ngah ih ami tiit baat rumhala warep khowah loong nyia Rangte mina loong ih sen ih marah tup han erah tup suh rapne taat ih ram rumla, ang abah uh tatup rumka, nyia sen ih marah chaat han ah chaat suh rapne taat ram rumla, ang abah uh tachaat rumka. ");
INSERT INTO tvt_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Erah thoih boichaat an, tiitthaak loong ah tumjih suh liiha rah toomjat an. ");
INSERT INTO tvt_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","O ih Hasong tiit ah chaat ano lajen samjat rumka ah raanteh lam nah dat arah likhiik. Ethih ah wanghaano erah wenta ah nge kaat ah. ");
INSERT INTO tvt_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Marah raanteh jong hah ni datta ah langla o mina ih Rangte jengkhaap ah chaat ano laan kap ruh eha erah loong asuh liita. ");
INSERT INTO tvt_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Enoothong nengten nengmong ni tatong thukka, erah thoih neng roitang tatongka. Rangte jengkhaap thoi, cham anaang nyia phate joonnaam thok kano laan toohaat ruh et ah. ");
INSERT INTO tvt_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Marah raanteh suhaang khui ni datta rah langla o ih Rangte jengkhaap ah chaat ano; hansi roidong suh sootsaam nyia changteng hoon tenthun ih erah jengkhaap ah phaaki thuk ah, eno neng tiik ah tadong tiikka. ");
INSERT INTO tvt_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Eno raanteh marah hase ni datta rah, o ih Rangte jengkhaap ah chaat ano heten hemong ni thiinha asuh liita: eno neng tiik ah dong tiik ah mararah ah chaasiit, rukho ah rook arok, eno rukho ah rookjom” ");
INSERT INTO tvt_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisu ih tiitthaak ehoh wakbaat rumta: “Rangmong Hasong ah arah likhiik. Mih wasiit ih raanjih jise heh phek ni wenta. ");
INSERT INTO tvt_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pheesiit, mina loong ejup ih rum adi, piiara ah wang haano champhook damdi theng ah wen wan ano ngaak kata. ");
INSERT INTO tvt_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Champhook loong ah hak ano chamnam ah phangdong ah, erah lilih theng loong ah wen wan ah. ");
INSERT INTO tvt_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mina laksuh ah wang haano baatta, ‘Chuupha, an ih phek ni raanjih wen tu abah jise angta; eno theng ah ma nawa roong dongla?’ ");
INSERT INTO tvt_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Eno ngaakbaatta, ‘Erah ah mararah seng piiara ih wenha.’ Eno neng ih ngaakcheng rumta, ‘Erah bah theng ah seng ih tam phiihaat kah ih?’ ");
INSERT INTO tvt_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Heh ih ngaakbaatta, ‘Nak phiihaat an,’ tumeah sen ih theng damdoh champhook nep phowak phiihaat an. ");
INSERT INTO tvt_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Theng nyia champhook ah eroom ih toom hak ah chamkhan tok maang langlang ah. Erah lidoh ba ngah ih cham khante loong suh baat ang, jaakhoh theng loong ah phi ano lomchaat khak an, eno we nah tak an erah lidoh ba raan ah nga pung nah lomthiin thuk rum ang.’” ");
INSERT INTO tvt_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisu ih tiitthaak ehoh we baatta: “Rangmong Hasong arah likhiik. Mih wasiit ih miinjaangjih ah heh phek nah wenkaat ah. ");
INSERT INTO tvt_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Erah loongtang nang ih ehin thoonjih, enoothong ehak eabah thoontang bangphook nang ih ehanthoon ang ah. Hebang ih hoon ano phih awoh ah hephaak nah neng tep nep tepwang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisu ih tiitthaak ehoh we boot baat rumta: “Rangmong Hasong ah, minuh nusiit ih wongbaan thekook siit ni to amasah ah woi ano maang sumsum ih thiin arah likhiik.” ");
INSERT INTO tvt_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisu ih miloong asuh jaatrep tiit baat suh tiitthaak loong ah maakta; heh ih neng suh tiitthaak muh ih tumjih tiit uh tabaatta. ");
INSERT INTO tvt_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Khowah loong ih mamet baat rumta erah jun ih amiisak toom ang raaha ih reeta, “Ngah neng damdoh waan ang doh tiitthaak loong ah maak ang; Ngah ih haphangsong dowa ih marah neng ih tajatka loong ah baat rum ang.” ");
INSERT INTO tvt_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","“Jisu ah miloong dung nawa dokkhoom ano nokmong ni wang adi, heliphante loong ah heh jiinni wang ano cheng rumta, “Phek nawa theng tiitthaak ah tumjih suh liitu erah baat kohe.” ");
INSERT INTO tvt_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisu ih ngaakbaatta, “Raanjih jise wente ah mina Sah asuh liiha; ");
INSERT INTO tvt_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","phek ah mongrep suh liiha; raanjih jise ah Hasong nawa mina asuh liiha; theng loong ah Ethih Wah mina loong asuh liiha; ");
INSERT INTO tvt_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","eno piiara ah theng wente ah Hakhoh luungwang asuh liiha. Chamkhan ah rangkuh thoon asuh liiha, eno cham khante ah Rangsah loong asuh liiha. ");
INSERT INTO tvt_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Theng loong ah lomtoon ano we nah tak arah likhiik, rangkuh thoon ano emamah ang ah: ");
INSERT INTO tvt_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mina Sah ih Rangsah loong ah daapjah haano heh hasong dowa ethih reete nyia mina ethih lampo ni dat hoomte loong ah lompoon ah, ");
INSERT INTO tvt_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","eno neng ah echoojih we adoh haattak wan rum ah, erah doh neng pha ah phak rum ano huung rum ah. ");
INSERT INTO tvt_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Eno Rangte mina loong ah neng Wah Hasong adoh rangsa phaakphaak ih phaak rum ah. Chaat an, sen na je abah ah! ");
INSERT INTO tvt_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Rangmong hasong ah arah likhiik. Mih wasiit ih phek ni nyamka hotthiin arah japtup ano we hopat thiin ah likhiik. Eno tenroon lam ih heh nyamka loong ah sang wang ano, erah phek ah ngaak reh kah arah likhiik. ");
INSERT INTO tvt_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Rangmong hasong ah arah likhiik nep. Mih wasiit ih jeksaang jaase thoon jam sok arah likhiik, ");
INSERT INTO tvt_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","eno jooho di latupka rah japtup ano heh nyamka loong ah sang ano erah jeksaang ah reh arah likhiik. ");
INSERT INTO tvt_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Rangmong hasong ah arah likhiik nep. Chaakwah ih juungsitum adoh chaak ah ha ano jaatrep nyah ah kap ah. ");
INSERT INTO tvt_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chaak adoh nyah loong ah me kano, saang nah toonhoom wan ah eno tong ano nyah loong ah dan phe thiin ah: ese se ah khaak nah thiin ah, nyah moong moong ah ehaat et arah likhiik. ");
INSERT INTO tvt_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Rangkuh thoon ano emamah ang ah: Rangsah loong ah kah ano ese mina dung nawa ethih mina loong lompoon rum ah ");
INSERT INTO tvt_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","eno micho miphaan ih luung arah we adoh haat wan ah, eno erah doh neng pha phak rum ano huung rum ah. ");
INSERT INTO tvt_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Sen ih arah tiit loong ah samjat nih ehan?” Jisu ih cheng rumta. “Samjat et hi,” neng ih ngaakbaatta. ");
INSERT INTO tvt_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Eno Jisu ih baat rumta, “Erah langla, Hootthe nyootte warep ah rangmong Hasong nah heliphante ih hoon adoh, nok changte wah ih hukkhaak ena reh ano ehak loong ah pung nawa dok haat arah likhiik ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisu ih erah tiitthaak loong ah thoonbaat ano, erah dowa dokkhoom eta ");
INSERT INTO tvt_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","eno heh hadaang ni ngaakwangta. Heh ih Jehudi Rangsoomnok ni nyootsoot rumta, eno erah tiit japchaatte loong ah rapne ih paatja rumta. “Heh ih erathan mongtham ah ma nawa chola? Neng ih chengta. “Nyia epaatjaajih loong ah mame jen reela? ");
INSERT INTO tvt_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Heh ah bangmaakwah wah sah ah tanih angka? Heh nuh ah Meeri tanih angka, erah dam ih Jeems, Josep, Simoon, nyia Judas loong phoh ah tanih ah? ");
INSERT INTO tvt_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Heh no minusah loong aani tongla tanih ah? Heh ih erathan mongtham ah ma nawa chola?” ");
INSERT INTO tvt_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Eno erah thoidi neng ih edut haat rumta. Jisu ih li rumta, “Khowah ah noongrep nah soongraang ah, heh nok hah nah nyia heh jaatang ih ba thaangju ah.” ");
INSERT INTO tvt_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tumeah neng tuungmaang tajeeta, eno heh ih erah ni epaatjaajih ehan tareeta. ");
INSERT INTO tvt_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Erah tokdi Galili luungwang Hirod ih Jisu tiit ah japchaatta. ");
INSERT INTO tvt_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“Eno heh ih apit nawa miloong asuh baat rumta, Juungtemte Joon ah amiisak tek nawa boh ngaak saatla.” “Erah thoidi heh di arah epaatjaatheng reejih chaan ah jeela.” ");
INSERT INTO tvt_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hirod ih jaakhoh ih dook Joon ah khakthuk cho angta, jaanruh ih kit ano phaatak ni sakta. Hirod ih erah khak thukta langla heh no Philip minuh kap tungthoidi, Hirodias ah maangdi heh no minuh angta. ");
INSERT INTO tvt_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tumeah Juungtemte Joon ih jaakhoni Hirod suh baatcho angta, “Hootthe jun ih bah an Hirodias damdoh tajen chosong ko!” ");
INSERT INTO tvt_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eno Hirod ih Juungtemte Joon tek haat ah taat chungta ang abah uh Jehudi loong ra choota, tumeah neng ih Juungtemte Joon asuh khowah et thiik rumta. ");
INSERT INTO tvt_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hirod tupsa di Hirodias sah minusah rah mirep miraang pandi boongta. Hirod ah rapne ih roonta ");
INSERT INTO tvt_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","eno minusah asuh kakhamta, “Ngah ih kakham hala an ih tumjih suhang erah koha!” ");
INSERT INTO tvt_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Heh nuh jengkhaap jun ih minusah rah ih suta, “Amadoh ngah suh khuung nah Juungtemte Joon khoh ah kohang!” ");
INSERT INTO tvt_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Eno luungwang ih rapne et thet thunta, ang abah uh heh ih wen loongdung ni kakham cho ang thoidi minusah ih suta ah ekot etheng ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Eno phaatak nawa Juungtemte Joon khoh ah thah kaat thukta. ");
INSERT INTO tvt_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Juungtemte Joon khoh ah khuung ni piiwanha no minusah asuh kota, eno minusah rah ih heh nuh suh we toom kota. ");
INSERT INTO tvt_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Joon liphante loong ah wang rum ano, heh mang ah toonwang rum ano beng kaat rumta, eno Jisu suh baatwan rumta. ");
INSERT INTO tvt_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisu ih Juungtemte Joon tiit ah chaat ano, erah dowa heh khoonkhuung ni duungtong ano heh laklak hatik ni kata. Miloong ah ih erah japchaat rum ano, neng hadaang ah thiinhaat rum ano saang lam ih heh lilih ih phankhoom karumta. ");
INSERT INTO tvt_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisu khoonkhuung nawa dokkhoom adi heh ih miloong hantek kaptup rum ano heh minchan ah dongta, eno heh ih khoisatte loong ah deesiitta. ");
INSERT INTO tvt_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Erah rangja adi heliphante loong ah heh jiinni wang rum ano baat rumta, “Rangsa ejen kaat eta, eno seng ah hatik ni. Miloong ah daap et uh neng phaksat hadaang loong dowa neng neng ih toom jam reh phaksah wang rum ah.” ");
INSERT INTO tvt_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisu ih ngaakbaat rumta, “Nak toom dokkhoom rum ah. Neng phaksat ah sensen ih jam koh an!” ");
INSERT INTO tvt_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Sengdi bah baanlo banga, nyasi enyi ba je ah,” neng ih ngaakbaatta. ");
INSERT INTO tvt_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Erah ang abah nga jiinnah piiwan han,” Jisu ih liita. ");
INSERT INTO tvt_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Heh ih miloong ah naam khoh adi tongthuk rumta; eno heh ih baanlo banga, nyasi enyi ah toonpi ano, rangko ih toonsok ano, Rangte suh lakookmi liita. Heh ih baanlo ah chepphiit ano heliphante loong asuh kota, eno heliphante loong ah ih miloong asuh phe kokaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Warep ih neng wok phoottang ih phaksah rumta. Eno heliphante loong ah ih asih hongnyi dakta rah lomtoon rumta. ");
INSERT INTO tvt_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Erah phaksatte loong ah minuh noodek loong ah larookweka di, miwah wah ah haajaat banga angta. ");
INSERT INTO tvt_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Eno Jisu ih heliphante loong ah khoonkhuung ni duungtong thuk rum ano juungsitum saangko ih ban kaat thuk rumta, erah pootdi heh ih miloong ah phe soon thukta. ");
INSERT INTO tvt_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Miloong ah phe soon thuk lini, heh kong adi rangsoom duung wangta. Rangja ko di nep, Jisu ah erah di heh luulu angta; ");
INSERT INTO tvt_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","erah tok adi khoonkhuung ah juungsitum, haloh ni juungtak ih moongmot kaatta, pong uh erah ko ih pong kaatta. ");
INSERT INTO tvt_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Chichurudi Jisu ah heliphante loong jiinni, juung khoni khoom katta. ");
INSERT INTO tvt_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Neng ih heh ah juung ni khoom arah tup rum ano, rapne ih cho rumta. “Erah jook!” neng ih liita, eno huung cho erumta. ");
INSERT INTO tvt_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Erah damdam Jisu ah jengta. “Sen tenchaan ang an!” heh ih liita. “Nakcho an. Ngah hanih!” ");
INSERT INTO tvt_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Eno Pitar eh liita. “Teesu, an amiimi ang ubah, ngah an jiinko juungkhoh nah khoom thuk hang.” ");
INSERT INTO tvt_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Eno Jisu ih poonta, “Raaho!” Eno Pitar ah khoonkhuung nawa dokkhoom ano juungkhoh ni Jisu jiinko ih katta. ");
INSERT INTO tvt_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Enoothong heh ih pong ah nge ah dongjat ano dong chota eno, juung adi taat lupdatta. Eno riinghuungta,Teesu! “Pang weehang.” ");
INSERT INTO tvt_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Erah damdam Jisu ah heh reeni kah ano tangjoh ano liita, “An tuungmaang laje mameelu! An mongchi mamanglu?” ");
INSERT INTO tvt_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nengnyi khoonkhuung ni duungtong damdam, pong ah laan semruh eta. ");
INSERT INTO tvt_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Eno heliphante loong ah ih Jisu rang ah soom rumta. “Amiisak an ah Rangte Sah!” neng ah paatja rumta. ");
INSERT INTO tvt_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Neng ih juungsitum ah daan rum ano Genesaret hadaang adi thok rumta, ");
INSERT INTO tvt_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","erah di miloong ih Jisu ah samjat rumta. Erah thoih harep niiwa khoisatte loong asuh baat rumta eno Jisu jiinni thoksiit rum taha. ");
INSERT INTO tvt_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Neng ih khoisatte loong asuh heh nyuh kaangba adoh tajoot suh heh lasih joh rumta; eno erah taajootte loong ah ede ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Eno mararah Phirasi nyia Hootthe nyootte loong Jerusalem nawa ih Jisu suh thok cheng ra rum taha, ");
INSERT INTO tvt_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“An liphante loong ah ih sengte sengwah ih kotahe banlam ah mamah lakap et rumha? Neng ih phaksat suh neng lak lati mamet rumha!” ");
INSERT INTO tvt_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisu ih ngaakbaat rumta, “Eno bah sen ih Rangte Jengdang ah lakap thang ih sen ih nyootsoot han ah mamet phanhan? ");
INSERT INTO tvt_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tumeah Rangte ih liita, ‘Sen nuh sen wah ah soongraang et an,’ eno ‘Sen nuh sen wah ah etam mok et an, erah tek haat etjih.’ ");
INSERT INTO tvt_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Eno sen ih amet nyoot han mina di nuh awah chosok theng tumjih bah uh eje taat angta, ang abah uh amet liihan ‘Arah Rangte suh kot theng eah,’ ");
INSERT INTO tvt_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nuh awah abah lathaam soongraangke bah uh ese ang ah eah. Emamah ih sen ih nyoot han ah phan suh, Rangte Jengdang ah phaaki han. ");
INSERT INTO tvt_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Lonoite sen loong! Sen tiit ah Isaia ih mamah ju et punbaat kota! ");
INSERT INTO tvt_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Rangte ih liiha, ‘Arah miloong ah ih ngah neng tui nawa ih ba soom rumhang, amiimi neng tenthun abah, nga jiin nawa haloh ni dook. ");
INSERT INTO tvt_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nga rangsoom ah neng suh thaangmuh angla, tumeah neng ih mina banlam ah, nga hootthe likhiik ih nyootsoot rumha!’” ");
INSERT INTO tvt_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Eno Jisu ih miloong ah heh reeni poon ano baat rumta, “Boichaat an no samjat an! ");
INSERT INTO tvt_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mina ah tui ni phaksah hi rah ih tanyaan siitka; erah nang ih bah mong nawa dong ra hala rah ih ba nyaansiit ha.” ");
INSERT INTO tvt_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Eno heliphante loong ah thokrum ano baat rumta, “An jengkhaap asuh Pharisi loong thichoh rumhala ah ejat nih et hu? ");
INSERT INTO tvt_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisu ih ngaakbaatta, “Rangmong nawa seng Wah ih lakiika bangphook loong abah ephiihaat et ah.” ");
INSERT INTO tvt_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Erah loong asuh nak sootsaam an! Neng ah edook loong dungni edook phansiitte loong; eno edook ih edook ah siit abah wanyi nyi beng nah dat ah.” ");
INSERT INTO tvt_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pitar ih baatta, “Erah jengtu rah seng suh huk jangbaat he.” ");
INSERT INTO tvt_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisu ih baat rumta, “Sen ih amadi uh mihoh loong nang ih maang boh jatkan. ");
INSERT INTO tvt_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tajaatjaat ni samjat kan? Tumjih bah uh sen tui ni sak han phaksat ah mong ni wangla eno sak nawa ewe ngaakkaat ela. ");
INSERT INTO tvt_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Eno tui ni tumjaat dong hala erah tenthun nawa ra hala, eno banlam di erah ih sen ah nyaansiit halan. ");
INSERT INTO tvt_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tumeah sen tenthun nawa ih ba ethih tenthun ah thok hala, erah tenthun ah ih mih tek haat thuk mui halan, mih sanuh sawah damdoh roomjup thuk halan, nyia jaat hoh ethih reeraang ah re thuk halan; mih put, eleek tiit baat, nyia mihoh tiit thetbaat thuk halan. ");
INSERT INTO tvt_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Erah loong ah ih sen ah nyaansaan thuk halan. Enoothong sen suh lakti muh ih nak phaksat an ih baat halan rah ih bah—mina tanyaan siit ran.” ");
INSERT INTO tvt_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisu erah hah dowa dokkhoom ano Tairi nyia Sidoon samnuthung juungkhuung ko ih wangta. ");
INSERT INTO tvt_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Erah ni tongte Kanan hate minuh heh jiinni thok haano riinghuungta, “Dewid Sah!” “Ngah minchan weehang, Chuupha! Nga sah minusah laathih ih amadi rapne ih chamthuk ha.” ");
INSERT INTO tvt_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Eno Jisu ah khaapsiit uh tatoon jengta. Heliphante loong ah heh jiinni wang rum ano heh lasih joh wang rumta, “Erah nuh ah haloh nah phanhaat uh! Heh seng lilih ih roongkhoom haano phaanjaang cheektiila!” ");
INSERT INTO tvt_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Eno Jisu ih ngaakbaat rumta, “Ngah Ijirel noksong dowa emat ela saapsah loong raang ih luulu kaat thuk tahang.” ");
INSERT INTO tvt_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Erah di minuh ah wang haano Jisu lasih jota, “Chuupha, ngah chosok weehang!” heh ih liita. ");
INSERT INTO tvt_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisu ih ngaakbaatta, “Noodek phaksat ah nge ano hui loong suh haat kot ah tapunka.” ");
INSERT INTO tvt_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Erah amiimi, Chuupha,” minuh rah ih ngaakbaatta, “ang abah uh hui loong ih uh neng changte teebun nawa phaksat thaaja arah toonsat kah ih rum ah.” ");
INSERT INTO tvt_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Eno Jisu ih ngaakbaatta, “Minuh an tuungmaang ah elong boh ah! An ih tumjaat jam hu erah an raangtaan ih elang eah.” Eno erah pootpoot di heh sah khoisat ah laan de ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisu erah dowa dokkhoom ano Galili juungsitum ko ih wang ano kongchoong ni tong wangta. ");
INSERT INTO tvt_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Miloong hantek heh jiinni thok wang rumta eno, edook, ekoong, engong ebaang, hiimuung nyia hephan dowa khoisatte loong ah Jisu jiinni thoksiit rum taha; eno khoisatte thoontang deesiit rumta. ");
INSERT INTO tvt_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Miloong ah rapne ih paatja rumta egong loong ah dongjeng, hiimuung loong ah de, ekoong ah khoom, eno edook loong ah ih dong tup; ih rum kano ah, erah thoidi Ijirel Rangte rang ah phoongpha rumta. ");
INSERT INTO tvt_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisu ih heliphante loong ah poon ano baat rumta, “Arah miloong raang ih rapne ih thetthun hang, tumeah neng nga damdi sa jom dowa ih dook roongtong rumhala, eno amadi phaksat theng uh amuh. Neng suh phaksat lakoh thang ih daap haat suh tanookkang, tumeah neng nok nah wang rum adoh lam nah neng leh thaap rum ah.” ");
INSERT INTO tvt_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Heliphante loong ih cheng rumta, “Phisaang hah arah dowa aathan miloong asuh jen khom kot theng ma nawa ma chojam ih?” ");
INSERT INTO tvt_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisu ih cheng rumta, “Sen jiinni baanlo mathan je ah?” Neng ih ngaakbaatta, “Baanlo sinet, nyia “ehin hin sah nyah amasah ba je ah.” ");
INSERT INTO tvt_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Eno Jisu ih miloong ah hah adi pheengtong thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Eno heh ih baanlo sinet nyia nyah ah toonpi ano, Rangte suh lakookmi liita, eno chepphiit ano heliphante loong suh kota; eno heliphante loong ih miloong asuh phe kokaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Neng ih neng wok laanphoot ruh ih phaksah rumta. Edak eta phaksat loong ah heliphante loong ih hong sinet et lomtoon rumta. ");
INSERT INTO tvt_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Phaksatte ah haajaat baji miwah angta, minuh nyi noodek loong larookweh thang di ah. ");
INSERT INTO tvt_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Eno Jisu ih miloong ah jen daap haat rum ano, Magadan juungkhuung ko ih kaat suh khoonkhuung ni duungtong kata. ");
INSERT INTO tvt_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mararah Phirasi nyia Sadusi loong Jisu jiinni wangte loong ah Jisu jeng ah mat et deenjoot suh phate rumta, erah thoidi neng suh epaatjaajih mootkaat noisok baat rumta, heh ah Rangte mina elang tam talangka erah dongjat suh ah. ");
INSERT INTO tvt_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Enoothong Jisu ih ngaakbaatta, “Rangsa lup adi rangtang ah saangdat kano, sen ih liihan, ‘Rang bah rangse ang ajoh, tumeah rangtang ah esaang ela eah. ");
INSERT INTO tvt_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Eno rangkhano di we liihan, ‘Rangphaatte joh, tumeah rang ah saangtek damdi nakdatla.’ Sen ih rangko ih sok anno rangmi rangphaat emi danjat ehan, enoothong ahaangwa saapoot tiit sin ah sen ih tami punbaat kan! ");
INSERT INTO tvt_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ahaangwa mina loong ah tumthan ethih nyia rangmuh ang rumla! Sen ih epaatjaajih noisok kabaat hali? Emah tah angka! Jona ih noisok tahan epaatjaajih ah ba choh an sen ah.” Eno neng jiin nawa dokkhoom kata. ");
INSERT INTO tvt_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Heliphante loong ah juungsitum jooko ih daan karum adi, neng ih baanlo hui ah beehaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisu ih baat rumta, “Phirasi nyia Saddusi loong to nawa pui suh; sen tenthun naririh ih banthun anjoh.” ");
INSERT INTO tvt_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Eno neng jaachi ni waan rumta, “Seng ih phaksat lahui koke no baat hali.” ");
INSERT INTO tvt_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisu ih neng waantiit ah jat ano cheng rumta, “Sen phaksat lahui thoidi tume thaam roongwaan lan? Sen tuungmaang ah ehin mamah ang lan! ");
INSERT INTO tvt_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Amadi uh sen ih taba samjat kan? Ngah ih haajaat banga miloong suh baanlo banga jen phe korumtang ah, tanih jen samthun kan? Erah di hedak sen ih hong mathan meesak tan? ");
INSERT INTO tvt_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nyia baanlo lo sinet dowa haajaat baji mina suh mamet kotang? Erah di sen ih hong mathan meesak tan? ");
INSERT INTO tvt_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ngah ih sen suh baanlo tiit labaat et rum taha rah mamah lasamjat ettan? Pharasi nyia Sadusi loong to nawa epui suh sen teeteewah naririh thong ih ban sok an!” ");
INSERT INTO tvt_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Eno ba heliphante loong ah ih kok samjat rumta heh ih baanlo ni mooktheng to asuh taboh liika, Phirasi nyia Saddusi loong tiitkhaap nyootsoot rumha dowa ah pui tiit boh baat ha eah. ");
INSERT INTO tvt_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisu Kaiseria Philippi hadaang reeko ih kata, erah di heliphante loong asuh chengta, “Miloong ih Mina Sah asuh o kah ih liirum ah?” ");
INSERT INTO tvt_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Mararah ih Juungtemte Joon et liiha, “neng ih ngaakbaat rumta. “Rukho ih Elija et li ha, rukho ih Jerimia nyia khowah et li ha.” ");
INSERT INTO tvt_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Sen ih aleh tumjih li hali?” heh ih cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoon Pitar ih ngaakbaatta, “An ah ething Rangte Sah, Kristo.” ");
INSERT INTO tvt_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Joona sah Simoon, an raangtaan ah ese!” Jisu ih ngaakbaatta. “Arah amiisak jengkhaap an sak ni mina tajeng raara, Rangmong nawa sengwah ih jeng thuk halu. ");
INSERT INTO tvt_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eno ngah ih baat hala Pitar: an ah jong, eno erah jong khoh adoh ngah ih nga chaas ah hoon ang, eno erah etek ih uh tajenka. ");
INSERT INTO tvt_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ngah ih an suh Rangmong hasong saabi ah koha; an ih mongrep nah marah haam uh rangmong nah uh ehaam et ah, nyia mongrep nah an ih marah tamiit ko erah rangmong nah uh tamiitka ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Erah lidi Jisu ih heliphante loong suh heh ah Kristo ih o suh labaat theng ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Erah sa dowa ih Jisu ih heh tiit ah heliphante loong suh jaatrep dokbaat korumta, “Ngah Jerusalem nah ekaatjih jaatjaat, erah nah ngah ngoong awang nyia romwah phokhoh, nyia Hootthe nyootte loong lak nah rapne ih chamnaang thukte ang halang. “Ngah etek haat et rumhang, enoothong sa jom lidoh we ngaakthing eang.” ");
INSERT INTO tvt_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pitar ih hiiksiit ano kanjaata. “Teesu, Rangte ih pang et ho!” Heh ih liita, “Erah likhiik an sak nah naktoom taangmaang ha!” ");
INSERT INTO tvt_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisu ih leksok ano Pitar suh liita, “Soitaan, nga re nawa soon eh uh! An ah nga lam tangte, an tenthun ah Rangte jiin nawa tah angka, mina dang ajang tenthun nawa.” ");
INSERT INTO tvt_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Eno Jisu ih heliphante loong asuh baatta, “Sen o ang anbah uh nga lih nah roongkhoom thunhan bah, sen ih senteewah ah beehaat jaatjaat etjih, eno sen bangphak ah hui, eno ngah lilih ih roongkhoom jih. ");
INSERT INTO tvt_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tumeah sen ih sen teeteewah roidong puipang thun anbah, emat haat et an; enoothong nga tungthoidoh sen roidong ah mat haat anbah, sen ih echojam et an. ");
INSERT INTO tvt_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mongrep dowa jaatrep ah choh ano sen roidong ah mat haat anbah tumjih dong choh an? Tumjih tachokan! Sen roidong we ngaak chosuh tumjih uh tajen dong kokan. ");
INSERT INTO tvt_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tumeah Mina Sah ah heh Wah rangka damdoh rangsah loong ah siit ano, ngaak ra saapoot ah chang ela, erah doh ba mina loong tumjih re rumta thaang ah kojaha. ");
INSERT INTO tvt_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ngah ih ami tiit baat rumhala amadi arah dung dowa rukho ah maang tek ang an, Mina Sah ah luungwang ih hoon ano raaha ah maang japtuptup ah.” ");
INSERT INTO tvt_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sa arok lini Jisu ih heh damdi Pitar nyia soophoh wanyi Jeems nyia Joon loong ah hatik ko ih neng luulu kongchoong ni siitwan rumta. ");
INSERT INTO tvt_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Neng miksok di, Jisu ah maama ih lekta: hethe hekhoh ah rangsa likhiik ih phaakta, eno henyuh hekhat ah pungkoopkoop ih phaakta. ");
INSERT INTO tvt_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Erah lidi heliphante wajom ah ih Jisu ah Moses nyia Elija damdi waan arah tup rumta. ");
INSERT INTO tvt_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Eno Pitar ih Jisu suh baatta, “Teesu, tumthan jaase ah seng aani roong ang heeno ah! An thungpun ubah, ngah ih nyutaap arah doh ejom than hoon ang joh, esiit ah an raangtaan ih, esiit ah Moses raangtaan ih eno esiit ah Elija raangtaan ih ah.” ");
INSERT INTO tvt_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Heh waan tokdi, jiingmuung ah phaakjaaja ih heh khothung ni ra taha, eno jiingmuung mong adi root dongjengta, “Arah nga mongnook amiisak nga Sah, heh suh Ngah eroon elang—heh jeng ah boichaat et an!” ");
INSERT INTO tvt_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Heliphante loong ah ih erah jeng ah japchaat rum ano rapne ih cho rumta eno hah ni pheengbon rumta. ");
INSERT INTO tvt_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisu ah neng reeni ra haano taajoh rumta. “Saat an,” heh ih liita. “Nakcho an!” ");
INSERT INTO tvt_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Eno toonsok rum adi heh damdi o uh tajeeta Jisu luulu angta. ");
INSERT INTO tvt_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Neng kong nawa dat ra rumha di, Jisu ih baat rumta, o suh uh labaat theng marah sen ih mot amang ni japtup tan rah ah, Mina Sah ah tek nawa maang ngaaksaatka ngakhoh nah ah. ");
INSERT INTO tvt_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Eno heliphante loong ih Jisu suh cheng rumta, “Hootthe nyootte loong ah ih Elija ah jaakhoh raaha ih mamet baat rumta?” ");
INSERT INTO tvt_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","“Jaakhoh Elija aju raaha,” Jisu ih liita, “Eno heh ih jaatrep ban khookham raaha. ");
INSERT INTO tvt_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Enoothong ngah ih baat rumhala, Elija abah ejen raak ih taha, mina loong ih ba heh ah tajen samjat rumka, heh damdi emungmaang ih reeraang rumla. Erah likhiik Mina Sah rah uh emamah et joonnaam rum ah.” ");
INSERT INTO tvt_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Eno heliphante loong ah ih Juungtemte Joon tiit boh baat ha ih dongjat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Neng miloong dung ni ngaak wang rum adi, wasiit Jisu ngathong ni heh lakudi tongwang ano ");
INSERT INTO tvt_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","liita, “Chuupha, nga sah ah minchan weeuh! Heh ah wakngak angla, baphuk ih we nyia juung ni choophaan phaan bondat leh mangtek kah eah. ");
INSERT INTO tvt_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ngah ih an liphante loong jiinni taatsiit jatahang, ang abah uh neng ih tajen deesiit rumta.” ");
INSERT INTO tvt_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisu ih ngaakbaat rumta, “Mina sen loong ah mamah lahanpi elan nyia moongtaang lan! Ngah sen damdam sa mathan ma jen roong tonghang nyia roong reehang? Noodek ah nga jiinko ih siitwan han!” ");
INSERT INTO tvt_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisu ih laathih ah kanjaata, eno noodek sak dowa laathih ah doksoon kata, eno erah radi noodek ah laan de ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Eno heliphante loong ah Jisu suh husah ih cheng rumta, “Laathih ah seng ih mamah lajen dokphan etti?” ");
INSERT INTO tvt_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“Erah langla sendi tuungmaang ah ehan laje kokan no,” Jisu ih ngaakbaat rumta. “Ngah ih amiimi baat rumhala sen tuungmaang ah miinjaangjih thanthan je bah, sen ih arah kong akaan asuh botseh ejen baat et an, ‘Arah dowa therah ko ih kah uh eah!’ Eno amiimiisak ih kah ah. Sen ih tumjih uh ejen re ean!” ");
INSERT INTO tvt_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Enoothong arah likhiik ah rangsoom nyia samurangsoom lam ih ba jen dokphan an; jaat hoh tumjih nawa re uh tajenka. ");
INSERT INTO tvt_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Heliphante loong Galili ni lomkhoom rumha di, Jisu ih baat rumta, “Mina Sah ah mih lak nah kot suh saapoot chang ela ");
INSERT INTO tvt_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","eno heh ah tek haat et rum ah; enoothong sa jom lih doh ewe engaakthing eah.” Heliphante loong ah rapne ih thungthih rumta. ");
INSERT INTO tvt_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisu nyia heliphante loong Kapernum hadaang ni thokrum adi, Rangteenok thaang sokseete loong Pitar jiinni wang haano cheng rumta, “Sen suh nyootte warah ih Rangteenok sokse ah ekot nikah et ah?” ");
INSERT INTO tvt_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Ekot kah et ah,” Pitar ih ngaakbaatta. Pitar ah nokmong ni wang adi, Jisu ih heh suh phang chengta, “Simoon, an ih tumjih thunhu? Arah mongrep dowa luungwang loong asuh lakbi thaang nyia sokse ah o ih kakoh ah? Heh deek akaan nawa ih tamkoh ah tama mideek nawa ih koh ah?” ");
INSERT INTO tvt_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Mihate ih koh ah,” Pitar ih ngaakbaatta. “Jisu ih liita, ese,” “Erah langla hanok ih bah lakotjih boh ah. ");
INSERT INTO tvt_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Enoothong seng ih arah loong ah emoong tahoon thuk ke. Erah raang ih juungsitum adoh riitchap kah anno nyathan than kah an. Eno marah jaakhothoon nyaan ah, erah nyah tui adoh jaan ngun choh an eno erah seng sokse kotheng laaleh ang ah. Erah pi anno sokse ah kokaat an.” ");
INSERT INTO tvt_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Erah tok adi heliphante loong Jisu jiinni wang rum ano, cheng rumta, “Rangmong Hasong ni elongthoon ah o ah?” ");
INSERT INTO tvt_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Eno Jisu ih noodek ah poon ano, neng ngathong ni chap thukta, ");
INSERT INTO tvt_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","eno baat rumta, “Ngah ih ami tiit baat rumhala sen arah noodek ah likhiik lalekkan bah, sen babah uh rangmong Hasong nah tachowang kan. ");
INSERT INTO tvt_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Rangmong Hasong nah bah toongtang mina arah noodek likhiik angte loong aba elongthoon ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Eno o mina ih arah likhiik noodek ah nga mendoh noppoon ah, erah ih ngah noppoon halang. ");
INSERT INTO tvt_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“O ih bah uh ngah suh hanpiite mina loong ah rangdah nah datsiit abah, erah mih rah ih jonglo ah bonjek ano juungsih nah lupdat ah eseethoon ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tumthan echoojih ah arah mongrep raangtaan ih ah, tumeah neng tuungmaang matsiitjih ah eje! Erah likhiik ah saarookwih banlang ruh eah—enoothong erah reete loong raang ih tumthan echoojih ang ah! ");
INSERT INTO tvt_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Anlak an lah ih an tuungmaang ah thetsiit halu bah, thadook uno haat uh! Laktuh latuh ih Rangmong nah chowang ah ese ang ah, lak alah pan ih roitang we nah khaamwang nang ih bah ah. ");
INSERT INTO tvt_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Erah dam ih an mik ih an tuungmaang ah thetsiit halu bah, doklot haat et uh! Mikko ih Rangmong nah wang ah ese ang ah mik hop soolam nah roitang we nah khaamwang nang ih bah ah. ");
INSERT INTO tvt_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Naririh ih ban sok an arah noodek loong ah babah uh nak thaangju an. Ngah ih baat rumhala, neng Rangsah loong ah saarookwih rangmong ni seng Wah damdi tong rumla. ");
INSERT INTO tvt_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tumeah Mina Sah ah saapsah emat ete loong pang raangtaan ih ra taha. ");
INSERT INTO tvt_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mih wasiit ih heh saapsah chaasiit dowa esiit ah mat haat abah, sen ih tumjih thun an? Heh ih rook akhuh akhuh ah kaanjang adoh naamphak thengnah thiinhaat ano esiit marah emat eta saapsah rah jam sokkah ah. ");
INSERT INTO tvt_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ngah ih baat rumhala, heh ah esiit emat eta ah japjam ano rook akhuh akhuh loong nang ih ehan ih roon ah. ");
INSERT INTO tvt_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Erah likhiik Rangmong nawa sen Wah reh uh arah noodek loong dowa esiit uh nak toom mah ah ih thunha. ");
INSERT INTO tvt_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Anphoh anno an damdoh rangdah mok re haabah, kah uno heh moongtaang ah dokbaat uh. Enoothong husah ih set cham chamchi nah hot baattaan mui theng. Heh ih an jeng ah thaangchaat abah, erah an ih engaak jen ettu. ");
INSERT INTO tvt_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Enoothong heh ih lathaang chaatka bah, an damdoh wasiit nyi than waksiit kaat uh, ‘tumeah wanyi wajom jengkhaap nawa ih esek ejih mok lang eah, ‘Rangteele ni jengla likhiik ah. ");
INSERT INTO tvt_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Eno erah uh heh ih lachaatka bah, chaas nah noksong suh dokbaat an. Erah taan uh lalaat chaatka bah, erah mih asuh Ranglajatte adoleh sokse seete ih ejen li et an. ");
INSERT INTO tvt_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Erah thoidi Ngah ih baat rumhala: marah sen ih arah hatoh ni ehaam et han rah rangmong nah uh ehaam et ah, nyia marah sen ih hatoh ni jen re thuk ehan erah rangmong nah uh ejen re ejih ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Erah dam ih Ngah ih boot baat rumhala: arah hatoh nah marah sen wanyi ah roomtong anno thungpun lam ih rangsoom anbah, erah ah Rangmong nawa seng Wah ih sen suh ehoonkot ehan. ");
INSERT INTO tvt_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tumeah o mina wanyi jom nga mendoh lomtong ah, erah doh Ngah sen damdoh eje ang hang.” ");
INSERT INTO tvt_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Erah lidi Pitar ih Jisu suh cheng wangta, “Teesu, ngaaphoh ngaano nga damdoh mok miksuk muiha bah, ngah ih ja mathan jen biin anaan ang? Jaasinet taan tama?” ");
INSERT INTO tvt_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Jaasinet tah angka,” Jisu ih ngaakbaatta, “Jaarook sinet jaasinet biin anaan theng, ");
INSERT INTO tvt_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","tumeah Rangmong hasong ah arah likhiik. Jaasiit luungwang wasiit ih heh laksuh loong dowa thaangsoot ngaaksuh rumta. ");
INSERT INTO tvt_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Luungwang ih thaang ah phang suh rum adi laksuh loong ah ih mih wasiit nopsiit wanrumta, erah mih adi luungwang thaangsoot hecha helaak tong arah angta. ");
INSERT INTO tvt_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Erah laksuh adi thaangsoot jen themtheng ngun taluita, erah thoidi luungwang ih laksuh asuh heh minuh nyia hesuh hesah nyia heh nyamka loong ah sang ano thaang ah toom them ah ih baatta. ");
INSERT INTO tvt_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Laksuh ah heh lakudi tong ano luungwang lasih jota. ‘Ngah biin anaan et weehang,’ ih chuut huungta, ngah ih ngaakthem et weeha!’ ");
INSERT INTO tvt_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Luungwang ih heh minchan ah dong ano heh thaangsoot uh lakah ngaaksuh thang ih biin anaan ano kaat thukta. ");
INSERT INTO tvt_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Eno erah laksuh ah dokkhoom kah ano heh joonte laksuh wasiit di chomui kata, erah wah ah dowa ngun amasah ngaak chojih eje angta. Heh ih erah wah ah joh ano heboh ni supphiitta. Eno liita, ‘Nga ngun nam tahang ah ngaak kohang!’ ");
INSERT INTO tvt_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Heh joonwah laksuh ah kottong ano heh lasih ah jota, ‘Ngah biin anaan et weehang, ngah ih ngaakthem et weeha!’ ");
INSERT INTO tvt_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ang abah uh heh tanookta; erah nang ih heh ih phaatak ni hethaang maang ngaakthem them et sakta. ");
INSERT INTO tvt_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Eno laksuh rukho loong ih erah sok rum ano rapne ih thungjoong rumta, eno luungwang asuh jaatrep baatwan rumta. ");
INSERT INTO tvt_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Eno luungwang ah ih laksuh ah noppoon wan ano liita. ‘Dah moong an ah! ‘Ngah ih botseh an dowa ngaak sujih angta ang ah biin anaan taha, an chuut huung thoidi ah. ");
INSERT INTO tvt_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","An ih uh an joonte ah minchan et jaat ba hanih, ngah ih an minchan taha likhiik ah.’ ");
INSERT INTO tvt_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Luungwang ah rapne ih khata, eno heh ih laksuh ah phaatak ni sak wanthuk ano hethaang maang ngaakthem them ih chamthukta.” ");
INSERT INTO tvt_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Eno Jisu ih thoonbaatta, “Erah raang ih rangmong nawa seng Wah reh uh emamah et han sen joonte ah sen ten nawa ih lajen biin anaan kanbah ah.” ");
INSERT INTO tvt_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisu ih erah loong tiit ah thoonbaat korum ano, heh Galili nawa dokkhoom ano Jordan juung saangko ni Judia juungkhuung ko ih katta. ");
INSERT INTO tvt_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Heh lini miloong hantek roong phankhoom rumta, loong ah thoontang deesiit rumta. ");
INSERT INTO tvt_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mararah Phirasi loong ah heh jiinni thokrum ano heh jeng matjoot suh phate cheng rumta, “Seng Hootthe jun ih miwah ih heh nusah tumjih thoidoh ang abah uh jen haat tamet ah?” ");
INSERT INTO tvt_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisu ih ngaakbaatta, “Rangteele ni raangha rah sen ih tanih chowetan, haphangsong di Rangte ih mina ah minuh miwah ih hoonta. ");
INSERT INTO tvt_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Rangte ih liita, ‘Erah raangtaan ih miwah rah ih henuh hewah ah thiinhaat ano heh sanuh damdoh room chosong ah, eno nengnyi ah esiit ih hoon ah.’ ");
INSERT INTO tvt_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Erah raang ih enyi takah angka esiit ih hoon nyu ah. Erah thoidi Rangte ih chosiit ha ah, o mina ih uh lapaak haat theng.” ");
INSERT INTO tvt_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pharisi loong ah ih heh suh cheng rumta, “Erah ang abah Moses Hootthe ih le ah raang ano haatmui theng ih tumet suh baatta?” ");
INSERT INTO tvt_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisu ih ngaakbaatta, Moses tokdi jen haatmui thuk tahan abah sen suh nyootsoot ah echaan angta. Enoothong haphangsong di bah emah tah angta. ");
INSERT INTO tvt_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Eno bah nga ih baat rumhala, miwah o ih bah uh heh sanuh ah mih damdoh lathet reeka doh haat ano nuhoh we kap abah, erah mih ah eroomjup rangdah ah dala,” ");
INSERT INTO tvt_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Heliphante loong ih heh suh li rumta, “Minuh miwah chamchi nah emah ang abah minuh lalaan kapka bah eseethoon angte.” ");
INSERT INTO tvt_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisu ih ngaakbaatta, “Erah jengkhaap ah mirep suh tapunka ang ah, mararah mina Rangte ih koha asuh ba jen ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tumeah mina ih minuh lakap thang ih tongla rah jaatrep thoidi: mararah mih ah daamhun ih tupla, rukho ah mih ih lanok muithuk suh lak hang ih hoonha, eno rukho ih bah Rangmong Hasong raangtaan ih minuh ah takapka. Arah nyootsoot hang ah o ih jen kap ah erah loong toom re ah.” ");
INSERT INTO tvt_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mararah miloong ih neng noodek Jisu jiinni heh lak ih taajoh ano rangsoom kotthuk suh siitjah rum taha, eno heliphante loong ah ih miloong kanja rumta. ");
INSERT INTO tvt_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisu ih baatta, “Noodek loong ah nga jiinnah toom wang rumha nak haam an, tumeah rangmong Hasong ah arah noodek loong ah likhiik.” ");
INSERT INTO tvt_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Heh ih noodek loong khoh adi taajoh ano dokkhoom kata. ");
INSERT INTO tvt_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Saasiit mih wasiit Jisu jiinni wang ano chengta, “Nyootte,” “Ngah ih babah uh lathoonka roidong ah chosuh eseejih tumjih re ang doh se ah?” ");
INSERT INTO tvt_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","“Eseejih ah ngah suh tumet suh cheng halang,” Jisu ih ngaakbaatta. “Ese abah Wasiit luulu ba. An roidong chosuh li ubah Rangte jengdang loong ah naririh et kap uh.” ");
INSERT INTO tvt_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Tumjih jengdang loong ah?” heh ih chengta. Jisu ih baatta, “Mih nak tek haat uh; mih minuh damdoh nak roomjup uh, mihot nak huh uh; mih suh lathika doh nak nan uh; ");
INSERT INTO tvt_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","annuh anwah ah soongraang et uh; erah dam ih ankhuung antok ah an teewah thanthan ih minchan uh.” ");
INSERT INTO tvt_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Ngah ih erah jengdang loong ah abah thoontang ejen kap etang,” Changteng warah ih ngaakbaatta. “Jaat hoh ngah tumjih boot reejih ah?” ");
INSERT INTO tvt_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisu ih ngaakbaatta, “An rapne eseethoon angsuh li ubah, an nyamka ah sang uno ngun ah changthih loong suh pheekokaat uh, eno ba an ah rangmong nah changteng ang uh; erah lidoh nga lih ah phan raahang.” ");
INSERT INTO tvt_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Erah chaat ano changteng wah ah thungjoong lam ih dokkhoom kata, tumeah heh nyamte angta. ");
INSERT INTO tvt_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Erah lidi Jisu ih heliphante loong suh baatta, “Ngah ih amiitiit baat rumhala: changteng loong ah Rangmong hasong nah chowang suh rapne echaan ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ngah ih we baat rumhala: Changteng loong ah Rangte Hasong nah chowang nang ih bah mokchongdoot ah mikkaan po nah baalaan nopsoon ah.” ");
INSERT INTO tvt_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Heliphante loong ah ih erah chaat rum ano rapne ih paatja rumta. “Erah ang abah, o ah piite angla?” neng ih chengta. ");
INSERT INTO tvt_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisu ah nengko ih toonsok ano liita. “Mina raangtaan ih bah erah lajen angjih ta ang anih enoothong Rangte doh bah jaatrep ejen lang eah.” ");
INSERT INTO tvt_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Eno Pitar ah toonjengta. “Seng ih jaatrep ah thiinhaat ih no an lih ah phanhi. Eno seng ah mamah ang ih? ");
INSERT INTO tvt_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisu ih baat rumta,” Roi Na thok ha doh Mina Sah ah chaan aphaan pan tongtheng adoh tong ah, eno Ijirel nawa asih jaatnyi ah pansuh nga liphante asih wanyi loong ah uh erah chaan aphaan pan tongtheng adoh roongtong rumha. ");
INSERT INTO tvt_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Erah damdi o mina ih henok hetap ah thiinhaat ano, adoleh hephoh henah, henuh hewah, hesuh hesah, hephek hephaang loong ah nga tungthoidoh thiinhaat abah, erah loong ah hantek ih choh ah, erah damdoh babah uh lathoonka roidong ah choh ah. ");
INSERT INTO tvt_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Enoothong o mina amadi jaakhoh angte loong ah liwang ih hoon ah, eno amadi liwang angte loong ah jaakhoh ih hoon ah. ");
INSERT INTO tvt_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Rangmong hasong ah arah likhiik. Saasiit mih wasiit ih rangkhano di heh potiik tong moot suh lakbiitte jamsun kata. ");
INSERT INTO tvt_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Heh ih lakbi thaang ah ngunkholok loosiit heh sa doh kotheng ih baat rum ano, heh phekmoot daapkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Heh thaangsang theng ni kaattiktom saapak akhuh di kah adi heh ih mih tumchap ruh ete japtupta, ");
INSERT INTO tvt_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","eno baat rumta, ‘sen nep nga phek nah potiik tong roongmoot kah an, ngah ih saasiit lakbi thaang koh et rumha.’ ");
INSERT INTO tvt_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Eno karumta. Erah lidi rangnithung saapoot asih nyi di nyia saasong saapoot ejom di nep heh ih mih emamah et daapkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kaandang ko saapoot banga di, heh thaangsang theng ni we kah adi uh emamah mih tumchap ruh eah rah we tupta. ‘Sen aadi nitang ih tumjih uh lare thang ih tumte thaaba lan?’ heh ih cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Seng biite o uh amuk,’ neng ih ngaakbaatta. ‘Ese, erah ang abah sen uh nga potiik tong ah roongmoot kah an.’ heh ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Rangjaako di, changte ih heh laksuh asuh baatta, ‘Phek mootte loong ah lompoon uno neng lakbi thaang ah korum uh, lithoon ih kaatte dowa phang korum uno jaakhothoon ih kaatte asuh lithoon et koh uh.’ ");
INSERT INTO tvt_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Rangsa kaandang angta tokdi kaatte loong asuh ngunkholok loosiit ru et korum uh. ");
INSERT INTO tvt_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Erah thoidi rangkhano di kaatte loong ah thok rumha no, neng ih seng bah ehan ih chotte ih thun rumta; ang abah uh neng suh uh ngunkholok loosiit ru et korumta. ");
INSERT INTO tvt_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Eno neng ih ngun ah thaang rum ano changte wah ah joobaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Neng ame jeng rumta, arah miloong ah lithoondi saapootsiit luulu ba mothukta, seng ah nitang saakhaam adi mootti, ang abah uh an ih seng suh kohali thanthan korum hu nih!’ ");
INSERT INTO tvt_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“‘Nga joonwah loong boichaat an, changte ih wasiit asuh liita, ‘Ngah ih sen tamokwaan rumra, sen suh saasiit lakbi ngunkholok loosiit kottheng ih waanti ah ekot et rumhala. ");
INSERT INTO tvt_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Amah ih sen lakbi ngun ah thaang ano nok nah wang an. Ngah ih lithoon ih ra taha loong asuh sen thanthan et kotsuh nooklang. ");
INSERT INTO tvt_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ngah ngun ah nga thungthung ih tanih jen maak kang? Adoleh sen ih nga thungpun lam ih kohang asuh tam siikhaam han?’” ");
INSERT INTO tvt_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Eno Jisu ih thoonbaat rumta, “Erah raangtaan ih o mina liwang thoon angla rah jaakhoh ih hoon ah, eno o jaakhoh thoon angte rah liwang thoon ih hoon ah.” ");
INSERT INTO tvt_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisu Jirusalem ko ih chookwang adi, lam ni asih wanyi heliphante loong ah hiiksiit rum ano husah tiit baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Boichaat an,” “Seng ah Jirusalem ni chookwangli, eno erah nah Mina Sah ah romwah phokhoh nyia Hootthe nyootte loong lak nah jokoh rum ah. Neng ih kaanju ano tek haat rum ah ");
INSERT INTO tvt_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","eno Ranglajatte loong lak nah korum ah, neng ih ngitkhuung rum ah, ruh ih nep buh rum ah, eno bangphak nah tek haat rum ah, enoothong sa jom lidoh we ngaaksaat eah.” ");
INSERT INTO tvt_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Eno Jebidi nusah heh sah miwasah nyi ah siit ano wang taha, eno heh lathong ni kotbon ano heh raangtaan ih re thuk suh, Jisu lasih ah jota. ");
INSERT INTO tvt_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“An tumjih suh nook uh?” Jisu ih chengta. Minuh rah ih ngaakbaatta, “An ih kakham hang, nga sah miwah sah nyia ah an luungwang ang udoh esiit ah dak hekko, esiit ah jaawah ko ih tongthuk uh.” ");
INSERT INTO tvt_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Set ih tumjih suh hansih erah tajat kansih,” nyi suh liita. “Ngah ih marah chamchoh khap dowa jok ang erah ejen roong jok ni et hansih?” “Ejen roong jok heetih,” nyi ih ngaakbaatta. ");
INSERT INTO tvt_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Jisu ih li nyuuta, setnyi eh ejen roong jok mok et hansih, “enoothong ngah dak hek jaawah o roong tongha erah ngah ih tajen dandje nyuura. Erah bah seng Wah ih o suh ban hoonha erah ba chotong ah.” ");
INSERT INTO tvt_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Heliphante wah asih loong ih erah chaat rum ano, soophonyi asuh rapne ih khah rumta. ");
INSERT INTO tvt_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Erah thoidi Jisu ih loongtang lompoon rum ano baat rumta, “Sen ih jat ehan ranglajatte mina loong pante adi jaatrep chaan jeela, eno mihak phokhoh loong adi jirep chaan aphaan jeela. ");
INSERT INTO tvt_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Erah bah uh, sen loong chamchi nah bah lah angjih. Sendung dowa o ih bah uh elong hoon tenthun ang anbah, wahoh laksuh jaatjaat chaak angjih; ");
INSERT INTO tvt_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","adoleh sendung dowa jaakhoh angsuh thunte je anbah, sen ah wahoh dah elang jaatjaat eejih— ");
INSERT INTO tvt_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mina Sah ah botseh mootkaat thuk suh tara taha, erah nang ih heteewah ah moh suh nyia mina hantek puipang suh ra taha.” ");
INSERT INTO tvt_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisu nyi heliphante loong Jeriko nawa dokkhoom rum adi, miloong hantek roong phankhoom rumta. ");
INSERT INTO tvt_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Edook wanyi lamkaang ni tong nyuutta wanyi ah ih Jisu daankhoom ah chaat nyu ano, toonriing nyuuta, “Dewid sah! Sek ah minchan we heetih. ");
INSERT INTO tvt_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Miloong ih nyi ah kanja rum ano suusu ih tong suh baat rumta. Ang abah uh nyi ah erong rongwah ih boot riing nyuuta, “Dewid sah! Chuupha, Sek ah minchan weehe tih!” ");
INSERT INTO tvt_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisu ih tangchap ano poon nyuuta. “Ngah ih set suh tumjih jen re konyu ha?” heh ih cheng nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Chuupha,” sek mik kaasiit jamhiitih!” ");
INSERT INTO tvt_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisu heh minchan ah dong ano nyi mik adi taajota; erah damdam nyi ih laantup ruh ih nyuuta, eno roong phankhoom nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisu nyia heliphante Jerusalem thok nanah di, neng Beetpheej ni Olip kong adi dung wang rumta. Jisu ih heliphante wanyi neng ngani ban wang thukta ");
INSERT INTO tvt_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","amet baat nyu ano ah: “Set ngah ni wa hadaang adoh wang ansih, erah nah moktoh heh sah reenah bonthiin arah laan japtup ruh ih wang ansih. Eno moktoh ah ja ansih no nga jiinnah siitjah hansih. ");
INSERT INTO tvt_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mih ih cheng hansih bah, Changte ih jamha ih baat ansih; eno ba moktoh nyi ah roong kaat thuk ha.” ");
INSERT INTO tvt_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Erah langla khowah ih banbaatta jengkhaap ah amiisak toom ang raaha ih ang thukta: ");
INSERT INTO tvt_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jaion samnuthung dowa miloong asuh baat an, Sok an, sen luungwang ah sen jiinni ra hala! Heh ah toongtang lam ih moktoh khoh nah raaha nyia moktoh heh sah damdoh raaha.” ");
INSERT INTO tvt_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Eno heliphante nyi ah wang nyu ano heh ih mamet baat nyuuta emamah ih re wang nyuutta: ");
INSERT INTO tvt_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","nyi ih moktoh heh sah damdi toonsiit wang nyuutta, eno moktoh tamkhoh adi nengnyuh nengkhat ah dekoh rum ano Jisu ah dung tongta. ");
INSERT INTO tvt_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Miloong hantek ih nengnyuh nengkhat ah lam adi dam rumta, rukho rah ih paam banglak ah dook dam ih karumta. ");
INSERT INTO tvt_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Miloong ah Jisu lih ah ngah ih khoom rum ano riingraak rumta, “Dewid sah ah phoong ih! Teesu mendi o ra hala erah suh Rangte ih romseetam koh ah! Rangte phoong ih! ");
INSERT INTO tvt_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisu Jerusalem ni nopwang adi, erah samnuthung adi noongrep ni paatja riingraak rumta. “Heh ah o angla?” Miloong ah ih cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Arah ah Galili juungkhuung, Najaret hadaang khowah Jisu ah,” Miloong ah ih ngaakbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisu Rangteenok ni wang ano erah nawa pheehoonte loong ah dokphan wang rumta. He ih ngun lekte teebun nyia tokparu sangte tongtheng ah toonhaat et wangta, ");
INSERT INTO tvt_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","eno neng suh li rumta, “Rangte jeng arah Rangteele ni raangha, ‘Nga Rangteenok asuh rangsoom theng nok et li ah. ‘Enoothong sen ih bah ehuh loong hottong theng et hoon han!” ");
INSERT INTO tvt_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Edook ekoong loong ah rangsoomnok ni ra rum taha eno Jisu ih deesiit rumta. ");
INSERT INTO tvt_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jisu epaatjaajih reeta loong ah Romwah phokhoh nyia Hootthe nyootte loong ih sok rum ano rapne ih khah rumta, erah dam ih noodek loong Rangteenok ni, “Dewid sah ah phoong ih!” ih riingraak rumta asuh nep khadah rumta. ");
INSERT INTO tvt_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Eno Jisu suh cheng rumta, “An ih chaat nih ih hu neng ih tumjih liita rah ah?” Eno Jisu ih ngaakbaat rumta, “Elang eah chaat ehang.” “Sen ih Rangteele ni amet raangha ah tanih jap wetan? ‘Sen ih noodek nyi khobaang loong suh Rangte rangphoong ah nyoot an eah.” ");
INSERT INTO tvt_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jisu erah dowa dokkhoom ano Bithani samnuthung adi jam kata. ");
INSERT INTO tvt_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Saalih rangkhano di Jisu ah samnuthung nawa lam ni ngaakwang adi, heh ram ih tiita. ");
INSERT INTO tvt_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Heh ih lamkaang ni puksak bang ah japtup eno hetiik sok kata, eno hetiik ah laje helak luulu angta. Erah thoidi bang asuh liita, “An tiik babah uh nak tiik uh!” Erah damdam puksak bang ah laan hookti ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Heliphante loong ah sok rum ano rapne ih paatja rumta. Eno cheng rumta, “Puksak bang ah seek mame hookla!” ");
INSERT INTO tvt_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisu ih ngaakbaat rumta, “Ngah ih ami tiit baat rumhala sen mongchi lah angthang ih hanpi anbah, ngah ih puksak bang hookthuk hang likhiik sen uh ejen re ean. Erah tokkhodoh sen ih arah kong akaan asuh nep jen baat an, ‘Juungsih adoh datti kah uh,’ eno amiimiisak ejen lang eah. ");
INSERT INTO tvt_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sen ih hanpi lam ih rangsoom anbah tumjih suh an erah echoh ean.” ");
INSERT INTO tvt_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisu Rangsoomnok ni ngaak wang haano; neng suh nyootsoot rum adi; romwah phokhoh nyia hadaang phokhoh loong heh jiinni wang rum ano cheng rumta, “Arah loong ah jen reejih an di tumjih chaan jeela? “O chaan ih jen reelu?” ");
INSERT INTO tvt_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisu ih ngaakbaat rumta, “Ngah ih sen suh tiit esiit cheng rumha, eno sen ih punbaat he bah, ngah ih arah loong o chaan nawa ih jen reelang erah baat rumha. ");
INSERT INTO tvt_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juungtemte Joon ih juungtem jen temjih chaan ah ma nawa chola: Rangte jiin nawa tam mina jiin nawa ah?” Eno neng neng chamchi ni waan rumta, “Seng ih mamet baat ih? ‘Rangte jiin nawa,’ ih baat ih bah, Heh ih seng suh liihe, ‘eno bah Joon asuh mamah lahanpi elan eah?’ ");
INSERT INTO tvt_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Erah dam ih seng ih ‘mina jiin nawa,’ ih li suh uh arah miloong ra ah chooli, tumeah neng ih Joon asuh khowah ih jen thiik rumta.” ");
INSERT INTO tvt_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Erah thoih neng ih ngaakbaatta, “Seng ih tajatke.” Eno Jisu ih baat rumta, “Erah ang abah, sen suh ngah o chaan nawa ih reetang ah tathaam baat rumra. ");
INSERT INTO tvt_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Amadoh, sen ih tumjih thunhan? Ehak di mih wasiit heh sah miwah sah wanyi angta. Phokhoh asuh kah ano baatta, ‘Nga sah, phek nah mokah uh.’ ");
INSERT INTO tvt_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Eno heh sah ih ngaakbaatta, takah kang,’ enoothong lini heh tenthun ah lek ano we kaat eta. ");
INSERT INTO tvt_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Erah lilih heh wah ah heh sah wasiit re adi we kah ano emamah ih we baat kaatta. Eno heh sah rah ih thang eta, ‘Om, Chuupha,’ ang abah uh heh takata. ");
INSERT INTO tvt_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Erah wanyi dowa rah ih marah ih hewah jeng ah kapta?” Neng ih ngaakbaatta, “Phokhoh rah ih.” Eno Jisu ih neng suh baatta, “Ngah ih baat rumhala: sokseete nyia minuh hansangte loong ah Rangte Hasong ni sen ngah ih wang rumla. ");
INSERT INTO tvt_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juungtemte Joon ah sen suh kateng lam suikot ra taha ang abah uh sen ih tahanpi tan; erah nang ih bah sokseete nyia hansangte loong ih ba heh jengkhaap ah hanpi rumta. Eno sen ih erah sok andi nep sen thung ah talekkan nyia tahanpi kan. ");
INSERT INTO tvt_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Jaat hoh tiitthaak ah we boichaat an,” Jisu ih baatta. “Teewadi phek changte wasiit di potiik phek angta, phek ah pa ih kookpa ano potiik jittheng habeng ah phek laktung adi thota, eno mih ban soktheng ah nok echoongwah ih hoonta. Eno heh ih potiik phek ah phekphoopte suh koh ano hahoh ni katta. ");
INSERT INTO tvt_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Potiik thiitok ah thok haano, heh laksuh loong ah phekphoop phekte jiinni heh dabbi ah sukwang thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Enoothong phekphoop phekte loong ah ih heh laksuh wasiit ah ebot erumta, esiit ah etek haat et rumta, eno esiit ah jong ih tekpat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Eno changte wah ih jaakhoh nawa nang ih laksuh wahoh hantek bootdaap wanta, eno phekphoop pkekte loong ah ih emamah we et tekbuh wanrumta. ");
INSERT INTO tvt_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lithoon adi Changte wah ih heh sah ah thoon daap wanta. ‘Nga sah abah neng ih esoomtu jaatjaat et rum ah,’ heh ih liita. ");
INSERT INTO tvt_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Enoothong phekphoop phekte loong ah ih heh sah ah tup rum ano jeng rumta, ‘Arah tang phek changte wah sah. Raahan, tek haat ih, heh nyamka ah seng ih toom kap ih!’ ");
INSERT INTO tvt_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eno pa phiini haatkaat rum ano phaakkhuh ni tekbuh kaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Erah ang abah, changte wah thok haano, phekphoop phekte loong ah tumjih et ah?” Jisu ih cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Eno ngaakbaat rumta, “Heh ih erah likhiik ethih mina loong abah tek haat laang etja.” “Eno phek ah wahoh suh koh ah heh suh phekphoop thaang jen kotte mina suh ah.” ");
INSERT INTO tvt_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisu ih baat rumta, “Rangteele ni raangha ah sen ih tanih jap wetan? ‘Nok hoonte ih marah jong thaangmuh et chiik haatta erah ah loongtang nang ih thaangchaan thoon ih hoonla. Erah ah Teesu ih hoon arah; tumthan epaatja theng ah!’ ");
INSERT INTO tvt_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jisu ih wakbaatta, “Erah thoih ngah ih baat rumhala,” Rangte Hasong ah sen jiin nawa toon ano o mina tiikse ih dong tiik ah, erah suh kokaat ah.” ");
INSERT INTO tvt_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Erah jong khoh adoh dattekte ah hechep hechep ih jopkhan ah; erah dam ih o sak khonah erah jong ah dat ah erah ah bungwiik et bunpat ah. ");
INSERT INTO tvt_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Romwah phokhoh nyi Phirasi loong ah ih Jisu tiitthaak ah chaat rum ano neng ih jat et rumta erah neng suh liita eah, ");
INSERT INTO tvt_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","erah thoidi neng ih Jisu ah ekhak et suh thun rumta. Enoothong, Jisu suh khowah ih thiik rumta, loong mina ra cho rumta. ");
INSERT INTO tvt_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisu ih tiitthaak ah mih suh nyootsoot suh maak ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Rangmong Hasong ah arah likhiik. Ehak di luungwang wasiit ih heh sah kuhoon raangtaan ih phaksat khookhamta. ");
INSERT INTO tvt_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Eno heh laksuh loong asuh wenwah loong ah kuhoon sadung raangtaan ih poonkaat thukta, enoothong miloong ah tanook rumta. ");
INSERT INTO tvt_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Erah thoih heh laksuh wahoh loong ah wenwah loong poon we daapkaatta, amet baat ano ah: ‘Amadi sadung tok elang ela; nga maanpong etot ah nyia maansah loong ah joot angno, kuhoon phaksat ah khookham etang. Kuhoon sadung ah phaksah wanghan!’ ");
INSERT INTO tvt_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Enoothong wenwah loong ah ih lathaang chaat thang ih maama mootkaat ni karumta: mararah heh phek ni kata, mararah pheehoon theng ni kata, ");
INSERT INTO tvt_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","rukho loong ah ih heh laksuh ah joh rum ano, tekbuh rumta. ");
INSERT INTO tvt_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","luungwang ah rapne ih khata; eno heh sipaahi loong ah daapkaat ano, laksuh tek haatte loong ah weethem tek haat, neng hadaang ah rok haat et rumta. ");
INSERT INTO tvt_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Eno heh laksuh loong ah lompoon rum ano baatta, ‘Kuhoon phaksat ah jen khookham cho, ngah ih maat rumtang wenwah loong ah aanah jen wang theethe tah ang rumka. ");
INSERT INTO tvt_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eno bah amadoh sen ih kah ano lam nah mina mathan japtup an erah thoontang poon wanhan.’ ");
INSERT INTO tvt_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Eno heh laksuh loong ah karum ano lam nawa mathan ethih ese mina chotup rumta loong ah lompoon wanrumta, eno kuhoon nok ah nep meeta. ");
INSERT INTO tvt_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Eno luungwang ah ih wenwah loong ah sokkah rum ano heh ih kuhoon choomdi lachoomte ah japtupta. ");
INSERT INTO tvt_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Nga joonwah, an aadi kuhoon choom muh mame nop halu?’ Luungwang ih chengta. Eno erah mih ah tumjih uh tajengta. ");
INSERT INTO tvt_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Eno luungwang ih heh laksuh loong asuh baatta, ‘Erah mih ah helak helah ah khak anno, laamang nah haatkaat an. Erah nah heh pha ah phak ano toom huung ah.’” ");
INSERT INTO tvt_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Eno Jisu ih thoonbaatta, “Mih hantek poonta, dowa ene ko ah danjeeha.” ");
INSERT INTO tvt_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pharisi loong ah dokkhoom rum ano Jisu suh mat deenjoot suh cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Eno Pharisi loong liphante nyi Hirod mina loong ih Jisu reeni daapkaat rumta. Eno neng ih liita, “Nyootte,” “Seng ih jat etti an ih ami tiit baat uh. Mina suh Rangte ih tumjih thunha erah jun ih nyootte an ah, mina ih tumjih liibaat ah ih an tasootsamko, tumeah an ih mina ah ehin elong tadandeeko. ");
INSERT INTO tvt_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Erah ang abah, seng suh baat he, an ih tumjih thunhu? Seng Hootthe jun ih Roman luungwang suh sokse ah ejen kot tam tajen koke?” ");
INSERT INTO tvt_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisu ih neng ethih tenthun ah ejat etta eno liita, “Lonoite loong! Sen loong ih nga mat deenjoot ah tumet suh taatwoot chung han? ");
INSERT INTO tvt_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Sokse o suh kotjih ah ngah suh jaanngun ah noisok thaak he!” Neng ih jaanngun ah piiwan rumta, ");
INSERT INTO tvt_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","eno heh ih neng suh chengta, “Arah ngun adi o theeakhoh nyia o men ah?” ");
INSERT INTO tvt_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Luungwanglong men, neng ih ngaakbaat rumta. Eno Jisu ih neng suh li rumta, “Ese, erah ang abah ah sen ih Luungwanglong thiik ah Luungwanglong suh koh an, Rangte thiik ah Rangte suh koh an.” ");
INSERT INTO tvt_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Neng ih erah chaat rum ano epaatja ih rumta, eno Jisu re nawa dokkhoom karumta. ");
INSERT INTO tvt_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Erah saasa adi mararah Sadusi loong Jisu jiinni wang rum haano mina tek nawa tangaaksaatka ih laat chaangmui rumta. ");
INSERT INTO tvt_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Nyootte,” Moses ih liita miwah heh sah maangje doh mok ti abah, heh minuh ah hephoh heno ih jaatjaat kapjih tumeah heh sah rah etek teewah sah et thiik suh ah. ");
INSERT INTO tvt_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ehak di soophoh wasinet aani tongte kah angta. Phokhothoon ah ih heh minuh ah kap ano heh sah maangje di mattiita, eno heh minuh rah heh no wasiit rah ih we kapta. ");
INSERT INTO tvt_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Eno erah warah uh emamah we tiita, erah lilih wasiit we mattiita, emamah soophoh wasinet ah matti wang rumta. ");
INSERT INTO tvt_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hethoondi, minuh ah thoon tiita. ");
INSERT INTO tvt_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Erah ang abah, etekte loong ah ngaaksaat jaadoh, erah nuh ah o minuh ang ah? Loongtang ah heh miwah totoh angta.” ");
INSERT INTO tvt_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisu ih ngaakbaat rumta, “Sen loong ih mamah lajat ehan! Tumeah sen ih Rangteele ni raangha rah nyia hechaan ah tajatkan. ");
INSERT INTO tvt_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Etek nawa ngaakthing adoh neng ah Rangsah loong likhiik ang ah, neng ih minuh takap rumka. ");
INSERT INTO tvt_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tek nawa ngaaksaat tiit ah Rangteele ni tanih jap wetan? Rangte ih liita, ");
INSERT INTO tvt_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ngah Abraham Rangte, Isak Rangte, nyia Jaakob Rangte.’ Heh ah tekcho Rangte tah angka ething Rangte.” ");
INSERT INTO tvt_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Miloong ah erah nyootta ah chaat rum ano, rapne ih paatja rumta. ");
INSERT INTO tvt_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisu ih Sadusi loong suh lakah miijeng thang ih li rumta ah Pharisi loong ih japchaat rum ano, neng ah lomkhoom rumta, ");
INSERT INTO tvt_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","eno neng dung nawa wasiit, Hootthe nyootte ih Jisu suh, mat deenjoot suh chengta. ");
INSERT INTO tvt_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Nyootte,” “Hootthe ni elongthoon jengdang tumjih ah?” ");
INSERT INTO tvt_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisu ih ngaakbaatta, “‘An Teesu Rangte ah anten anmong nyia anthung antak adoleh anchi anla ah koh uno minchan uh.’ ");
INSERT INTO tvt_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Erah ah ajuuba thoontang nang ih elongthoon nyia ehan et maakjih. ");
INSERT INTO tvt_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Erah lilih jengdang elongthoon ah arah likhiik: ‘Ankhuung antok ah an teewah thanthan ih minchan uh.’ ");
INSERT INTO tvt_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses Hootthe nyia khowah loong ih nyootta ah thoontang arah enyi jengdang adi roopla.” ");
INSERT INTO tvt_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mararah Pharisi loong lomtong rum adi, Jisu ih cheng rumta, ");
INSERT INTO tvt_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Sen ih Kristo asuh o ah et thunhan? Heh ah o suh o sah ah?” “Heh ah Dewid sutoom,” neng ih ngaakbaatta. ");
INSERT INTO tvt_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Eno Jisu ih chengta, erah ang abah, mamah ah,” “Chiiala ih Dewid suh ‘Teesu’ ih poon uh ih tam baatta? Dewid ih liita, ");
INSERT INTO tvt_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Rangte ih nga Teesu suh liita: arah doh nga jaawako adoh tong uh anpi anra loong ah ngah ih an lathong nah maang thokthok thiin ah.’ ");
INSERT INTO tvt_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Erah ang abah, Dewid ih ‘Teesu’ ih poon abah, Kristo ah Dewid sutoom mamangla? ");
INSERT INTO tvt_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","O reh uh Jisu suh tami ngaakbaat rumta, eno erah sa dowa ih o reh uh ehan jengkhaap tanaan cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Erah lidi Jisu ah heliphante nyia miloong damdi waantiitta. ");
INSERT INTO tvt_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Pharisi nyia Hootthe nyootte loong ah Moses Hootthe toombaat kotsuh chaan kotcho ang rumta. ");
INSERT INTO tvt_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Erah raang ih sen neng jengchaatchaat etheng, neng ih ere etheng ih baat han radoh ah, enoothong neng reeraang abah lanyoot theng, tumeah neng ih nyoot rumha jun ih tareeraang rumka. ");
INSERT INTO tvt_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Neng ih huijih nyia echeh echaan lajen huiji ah mih sakkhoh ni luulu khak korumha, eno neng ih erah huijih huite loong ah chosok suh neng laktiik tiksiit taan uh tamaak rumka. ");
INSERT INTO tvt_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jaatrep mih suh noisok suh ba reeraang rumla. Sok an neng khodek adi Rangte jengkhaap raangcho ang arah dek rum ano noisok rumha, neng sook adi khak et rum, eno neng ah elong hoonkap ih noisok rumha! Neng samsong adi jaannaat ah elootlootwah ih waangchi rum ano noisok rumha! ");
INSERT INTO tvt_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Neng ih sadung theng ni tongtheng ese ni tong suh nook rumla nyia Jehudi rangsoomnok ni neng tongtheng ah ban khookham cho et thiin arah suh nook rumha; ");
INSERT INTO tvt_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","thaangtaam theng ni karum adi uh mih ih jengkhaapse jenglam ih toom soom he ih thun rumha adoleh ‘Nyootte’ toom et poonhe ih thun rumha.’ ");
INSERT INTO tvt_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mih ih sen suh “Nyootte” ih nak toom poon han, tumeah sen soophoh soowah loong suh nyootte abah wasiit luulu. ");
INSERT INTO tvt_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Erah dam ih sen ih arah hatoh adoh ‘Ewah’ ih o uh nak poon an, tumeah sen wah wasiit luulu rangmong dowa ah. ");
INSERT INTO tvt_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Adoleh sen ih o suh uh ‘Phansiitte’ ih lapoon theng, tumeah sen phansiitte ah wasiit Kristo luulu. ");
INSERT INTO tvt_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sendung nawa elongthoon angsuh nookte ah sen loong laksuh angjih. ");
INSERT INTO tvt_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","O ih heh teeteewah suh elong ih thiik ha erah mih ah ehin ih hoon theng, eno o heh teeteewah suh ehin et thiik ha erah mih ah elong ih hoon ah. ");
INSERT INTO tvt_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Tumthan echoojih ang ah, sen Hootthe nyootte nyi Pharisi loong suh ah! Lonoite sen loong ah! Sen ih Rangmong Hasong kaasak ah mih uh lanop thuk ih tangsak han, senteewah uh tanop kan, erah dam ih erah doh nopte taatje abah uh sen ih tanghaam et han! ");
INSERT INTO tvt_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Tumthan echoojih ang ah sen, Hootthe nyootte nyi Pharisi loong suh ah! Lonoite sen loong! Sen ih thaknuh loong ah neng nok ni put kaleh, elootlootwah ih rangsoom jeng ah noisok et kohan! Erah loong ah tungthoidoh sen ethithoon ih cham thukte! ");
INSERT INTO tvt_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Tumthan echoojih ang ah, sen Hootthe nyootte nyi Pharisi loong suh ah! Lonoite sen loong! Sen ih mih wasiit leksiit suh juungko saangko deek akaan ni ih daankhoom lan, ang abah uh chojam ano erah mih ah ethithoon soolam ni we wang thuk lan sente senwah likhiikkhiik ah! ");
INSERT INTO tvt_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Tumthan echoojih ah, mih lamthih ni siitte sen loong ah! Sen ih nyoot han, ‘o ih Rangteenok mendoh thoomhoon ah erah tumjih uh tah angka; enoothong o mina ih Rangteenok ni thiinha hun mendoh thoomhoon ah, erah thoomhoon jun doh re ejih jaatjaat ang ah.’ ");
INSERT INTO tvt_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Edook lam ni siitte loong! Hun akom ah tam rakla tam ah Rangteenok ah rakla? ");
INSERT INTO tvt_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Sen ih amah nep et nyoot han, ‘O mina ih romthong mendoh thoomhoon ah erah tumjih uh tah angka; enoothong o ih lakkot lam ih romthong ni thoomhoon ah erah thoomhoon jun doh re ejih jaatjaat ang ah.’ ");
INSERT INTO tvt_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mamah lajat ehan! Marah ah rakla, lakkot ah tam rakla tam aleh lakkot saasiitte romthong ah rakla? ");
INSERT INTO tvt_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","O ih romthong mendi thoomhoonha erah romthong dowa hukkhaak loongtang mendi thoomla; ");
INSERT INTO tvt_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","erah dam ih o ih Rangteenok mendi thoomhoonha, erah Rangteenok ni tongte Rangte mendi thoomla; ");
INSERT INTO tvt_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","erah damdi o mina rangmong hasong mendi thoomla, erah Rangte nyia Rangte tongtheng ni o tongla erah mendi thoomla. ");
INSERT INTO tvt_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Tumthan echoojih ang ah sen, Hootthe nyootte nyia Pharisi loong suh ah! Sen lonoite loong! Sen ih Rangte suh asithiik hepoot phaksat, pochina, phantho nyia khokileeso botseh kohan, enoothong amiimi elong Hootthe jengkhaap loong ah phaang haat ehan, jengjuntiit nyia minchan adoleh toongtang reeraang loong ah. Erah loong Hootthe ah sen ih laphaang haat thang ih nyia mih uh laphaang thukthang ih, ban maak ruh etjih. ");
INSERT INTO tvt_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mih lamthih ni siitte loong! Sen ih joktheng joong nawa sewiik ah toonhaat et han, enoothong mokchongdoot ah elem et han! ");
INSERT INTO tvt_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Tumthan echoojih ang ah sen suh ah, Hootthe nyootte nyi Pharisi loong oh! Sen lonoite loong! Sen khuung akhaak ah rangkhoh ko ah laklak saachot han, hemong ko adi bah sen mongthet nyia nyamnyook loong ih boh nyaansiit han. ");
INSERT INTO tvt_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Edook Pharisi loong oh! Khuung akhaak ah hemong ko ah chaak saachot an erah lidoh ba rangkhoh ko ah we saachot an! ");
INSERT INTO tvt_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Tumthan echoojih ang ah sen Pharisi nyia Hootthe nyootte loong suh ah! Lonoite sen loong ah! Sen ah mangbeng nok puungmook arah likhiik boh ah, rangkhoh ah sok koleh puungchamcham hemong ah sok koleh mih mang nyia kiing araang loong namchaam arah likhiik ah. ");
INSERT INTO tvt_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Erah likhiik, rangkhoh ni ba ese ih noisok han, enoothong hemong ni bah ethih tenthun nyia rangdah loong laklak meela. ");
INSERT INTO tvt_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Tumthan echoojih ang ah, sen Hootthe nyootte nyia Pharisi sen loong suh ah! Lonoite sen loong! Sen ih khowah loong mangbeng theng ah jaaseemoong ih hoon han nyia elong elang loong mangbeng ah naririh ih choomraang han; ");
INSERT INTO tvt_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","eno sen ih chaang han, te awah hasong tokdoh seng mok roongjeeti bah khowah loong taroong tek haat thengti eah. ");
INSERT INTO tvt_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sen teeteewah ih jatthuk hali sen ah khowah loong tek haatte sutoom satoom eah! ");
INSERT INTO tvt_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Erah ang abah, sente senwah loong reeraang rumta rah sen we tuk reeraang an! ");
INSERT INTO tvt_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Pu sen loong nyia pu suh asah loong! Soolam nawa epi ete ih mamet mi banthun han? ");
INSERT INTO tvt_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Erah thoidi ngah ih baat rumhala, ngah ih khowah, jatwah nyia nyootte loong daapkaat hang; erah dowa sen ih mararah ah tek haat et an, mararah ah bangphak nah tek haat an, rukho ah Jehudi rangsoomnok nah ruh ih buh ano hadaang hadaang nah tum phanjoh an. ");
INSERT INTO tvt_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Erah raang ih, sen ih toongtang mina mathan tek haattan chamnaang ah sen sak nah dat ha, marah Abel dowa ih Berekia sah Jekaria tuk ih romthong nyia Rangteenok chamchi ni tek haattan loong ah. ");
INSERT INTO tvt_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ngah ih baat rumhala: erah tek haat rumta mat ah ahaangwa mina loong sak nah ang ah! ");
INSERT INTO tvt_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem! Rangte ih daapjah taha khowah loong nyia ruurang baatte loong ah jong ih tekpat han! Wonuh ih hejang khui ni wothaang loong khon arah likhiik, sen loong ah nga lak ih khonjoot suh tumthan taat thuntang, ang abah uh sen ih tare thukri! ");
INSERT INTO tvt_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Erah raangtaan ih Rangteenok ah hahuung et thiinhaatte anglan. ");
INSERT INTO tvt_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ngah ih baat rumhala aadowa ih bah, sen ih ngah babah uh takah we japtup ri, ‘Teesu mendi raakte asuh Rangte ih romseetam koh ah,’ ih sen ih maang liili bah ah.” ");
INSERT INTO tvt_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisu Rangteenok nawa dokkhoom kah adi, heliphante loong ah heh reeni ra rumha no baat rumta, “Arah nok loong ah sok uh.” ");
INSERT INTO tvt_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","“Om,” heh ih liita, “Sen ih arah loong ah ese hemok et sok han. Ngah ih baat rumhala: arah doh jong esiit taan uh takah dakka ang ah; loongtang toonhaat cho ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisu Olip kong ni tong adi, heliphante loong ah husah ih heh jiinni thok rumta. Eno cheng rumta, “Baat he arah loong ah maatok doh angte ah, adoleh seng ih tumjih ruurang japchaat ih an raak tok nyia rangkuh thoon ah jat suh ah.” ");
INSERT INTO tvt_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisu ih ngaakbaat rumta, “Sen teeteewah naririh et ban sok an, eno o eh uh naktoom jen joonnaam han. ");
INSERT INTO tvt_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nga mendoh mih hantek thok ha eno neng ih chaang rum ah, ‘Kristo ah ngah!’ Eno erah loong ih warep mina mokwaan rum ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Sen ih senre senko nyia haloot nah changrook ruurang chochaat an; enoothong nakmok sootsaam an. Erah loong ah elang jaatjaat eah enoothong erah suh rangkuh thoonla ih liijih tah angka. ");
INSERT INTO tvt_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Deek akaan loong ah erookmui eah, hasong esiit ah esiit damdoh rookmui rum ah. Erah tokdoh noongrep nah ramtek khamle nyia hasah moh ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Erah loong ah nootup suh kaphang sat arah likhiik ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Erah lidoh sen ah khak hanno mih lak nah chamnaang thuk han etek haat et han rah nep je ah. Mirep ih sen ah nga tungthoidoh miksuk et han. ");
INSERT INTO tvt_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Warep ih neng tuungmaang ah erah tokdoh emat haat et rum ah; neng esiit esiit suh miksuk siikhaam mu rum ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Erah lidoh Tiitmoong baatte khowah loong ah dong ano warep mokwaan ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Emamah ih ethih loong ah jaatjaang ano, mina ehanko loong ah neng jaachi nah minchan mui ah ethoon eah. ");
INSERT INTO tvt_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Enoothong o mina hethoon tuk ih jen rongchap ah, erah mina ah ba pui ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Eno arah Ruurang Ese Rangte Hasong tiit ah mongrep thoontang nah tumbaat ah, mirep suh haaki ang raangtaan ih ah; eno ba rangkuh thoon ah thok ha. ");
INSERT INTO tvt_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Khowah Daniel ih baatta tiit ah sen ih ‘Echoojih’ esiit japtup an. Erah langla esa hah nah chap ah.” (Ewette suh: samjat et an arah tumjih men et ha!) ");
INSERT INTO tvt_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Eno o mina Judia ni angte loong ah kong ko nah toonsoon wangjih jaatjaat ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","O mina sep khoh ni angte rah ih nokmong nawa heh hukkhaak latoon kaat theng. ");
INSERT INTO tvt_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","O mina phek ni angte rah heh nok nah henyuh hekhat latoon wangtheng. ");
INSERT INTO tvt_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tumthan echoojih ang ah erah tokdoh khoobaang nuh nyia sakjite loong raang ih ah! ");
INSERT INTO tvt_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Rangte suh rangsoom an erah tiisoon saakaan ah hahook nyia naangtongja doh naktoom chaatmaat ah! ");
INSERT INTO tvt_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tumeah erah tokdoh chamnaang ah echoojih angte, teewah dowa ih amah tuk ih babah uh lathaak angka rah ang raakte. Enoothong erah likhiik echoojih chamnaang erah dowa ih babah uh lakah angte. ");
INSERT INTO tvt_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Enoothong Rangte ih erah cham anaang saakaan ah ethoosiit etta; heh ih emah lamok hoonta bah o uh tapui thengta. Heh ih danjeeta mina loong raangtaan ih, Rangte ih erah saakaan ah ethoosiit et ha. ");
INSERT INTO tvt_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Eno, o ih bah uh sen suh amah mok ih baat han, ‘Sok, ‘Arah ni Kristo ah!’ Adoleh ‘therah ni thong heh ah!’ —erah suh sen lahanpi theng. ");
INSERT INTO tvt_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tumeah emoong Kristo nyia emoong khowah loong ah edong eha; neng ih epaatjaajih mootkaat elong elong ah re rum ah, jen lang abah Rangte mina danje cho loong anep ma mok jen mokwaan jioh eah. ");
INSERT INTO tvt_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Boichaat an! Ngah ih saapoot maang chang di arah banbaat rumhala. ");
INSERT INTO tvt_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Adoleh, mih ih sen suh baat han, ‘Sok an, heh bah phisaang hako ni—erah doh sen nakmok kah an; adoleh neng ih baat han, ‘Sok an, heh arah di hutongla!’ —erah jeng ah nakmok hanpi an. ");
INSERT INTO tvt_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tumeah Mina Sah abah rangsumphaang saadongko nawa saanop ko ni jap ah likhiik ih raaha. ");
INSERT INTO tvt_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Marah doh mang ang ah, erah doh hukunnuh loong lomkhoon ah.” ");
INSERT INTO tvt_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Erah cham anaang saakaan ah thoon damdam, rangsa ah nakdat eah, laaphiing ah takah phaakka, ritsih loong ah rang nawa datti ih raaha, rang nawa chaan aphaan loong ah edumdan eah. ");
INSERT INTO tvt_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Eno mina Sah raak ah jat suh rang nah jatsok etheng dong eha; eno hatoh nawa mina loong ah ehuung ih rum ah mina Sah ah rang nawa jiingmuung damdoh chaan aphaan nyia rangkaaka ih raaha ah tup rum ano ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Liirong ah rengmot et ah, eno heh ih Rangsah loong ah hatoh rongbaji nah daapkaat ha, eno heh ih heh mina danjeecho loong ah hatoh rongrep nawa thutsiit ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Puksak bang ih sen suh toom nyoot han. Bang phaak loong ah phang jang adi nyia hedem phangdem adi, sen ih jat han rangsoh thok hala eah. ");
INSERT INTO tvt_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Erah likhiik, erah loong ah tup anno, sen ih jat an saapoot ah elang esuh thok nanah ih ehala eah. ");
INSERT INTO tvt_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Samthun et an erah loong ah amadi mina ething angte loong ah maang tek rumka ngakhoh nah ang raaha. ");
INSERT INTO tvt_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Rang nyi hah abah emat eah, enoothong nga jengkhaap abah babah uh tamaka. ");
INSERT INTO tvt_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“O eh uh tajatka, rangwuung saapoot babah thok ha eah—rang nawa rangsah adoleh heh Sah eh uh tajatka; heh Wah luulu ih ba jat ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mina Sah raak ah teewadi Nuah tokdi mamah angta erah likhiik we ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Juung nuungta jaakhoni mina loong jokjok phakphak nyia minuh miwah kuhoon ih, Nuah khoonkhuung ni tong wangta tuk ih tong rumta; ");
INSERT INTO tvt_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ang abah uh mina loong ih juungnuung ih maangjap jaakhoni tajen dong thun rumta. Erah likhiik Mina Sah raaha tokdoh emamah ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Erah tokdoh phek mootte wanyi dowa; wasiit ah toonsiit wan ano wasiit ah thiinhaat et ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Minuh nunyi raanthut theng nawa; nusiit ah toonsiit et ah, nusiit ah thiinhaat et ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Erah raangtaan ih, sen ih naririh ih ban sok an, tumeah sen Teesu tumjih sa doh raaha ah tajatkan. ");
INSERT INTO tvt_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nok changte ehuh wang saapoot ah jatta bah, motseng ih tong ano heh nok ah tajap loongthuk thengta. ");
INSERT INTO tvt_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Erah raangtaan ih, sen uh saarookwih banban ih tongjih jaatjaat, tumeah Mina Sah ah sen ih lathunkan saapoot doh mok raaha. ");
INSERT INTO tvt_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Erah ang abah, laksuh jatwah nyia tuungmaangte o ah? Erah langla heh changte wah ih laksuh wahoh loong suh phak asat jamkotte et thiinha mih rah ang ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tumthan tenroon ang ah erah laksuh rah ah changte wangha tokdoh heh reerang ah japtup wangha doh ah! ");
INSERT INTO tvt_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Amiisak, Ngah ih baat rumhala, changte wah ih heh nyamka thoontang erah laksuh asuh ban sok thuk ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Enoothong heh ah mimoong mok ang abah heh teeteewah suh li ah heh changte wah ah seek tabaam ngaak wang ra eah, ");
INSERT INTO tvt_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","eno heh ih laksuh wahoh loong ah buh thom rum ah, eno khampa loong damdoh roong jok phaksah ah. ");
INSERT INTO tvt_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Eno erah laksuh changte ah saasiit heh ih labanthooka nyia lajatka sa doh ngaakwang ha. ");
INSERT INTO tvt_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Eno changte rah ih hechep hechep ih joopdook ano lonoite loong chamtheng adoh haat wan ah, heh pha ah phak ano huungriing wangtheng adoh ah. ");
INSERT INTO tvt_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Erah tokdoh Rangte Hasong ah arah likhiik ang ah. Ehak di saasiit jaalah nuh asih ih neng weetook ah piirum ano kuhoonte wah jiinni chomui karumta. ");
INSERT INTO tvt_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nuh banga ah thungko ang rumta, nuh banga ah maaknuh ang rumta. ");
INSERT INTO tvt_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Thungko loong ah ih weetook ah pi rum ano weejoong hedak tawak pi rumta, ");
INSERT INTO tvt_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","maaknuh loong ah ih neng weetook damdi tingkook ni weejoong ah wak pi rumta. ");
INSERT INTO tvt_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kuhoonte wang ah liin kah no, jaalah loong ah mokjup ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pheethungkham di miloong ah dong cheektiita, ‘Kuhoonte erah joh! Raahan heh damdoh chomui kah ih!’ ");
INSERT INTO tvt_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jaalah nuh asih loong ah saat rum ano neng weetook ah pak et rumta. ");
INSERT INTO tvt_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Eno thungko jaalah loong ah ih maaknuh loong dowa suh rumta, ‘seng suh weejoong ah koweehe, seng weejoong ah thoon luung eta.’ ");
INSERT INTO tvt_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Maaknuh jaalah loong ih ngaakbaat rumta, ‘Tajen koke,’ seng thoontang suh tarookliika ang ah, erah raangtaan ih sen ih thaangtaamte jiin nawa reh kah an.’ ");
INSERT INTO tvt_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Eno thungko jaalah loong ah thaangtaam theng ni weejoong riik karumta; eno neng kaat lidi kuhoonte wah ah thok taha. Jaalah nuh banga loong ah kuhoonte damdi sadung theng ni roongwang rumta, eno kaaluung ah tangsak et rumta. ");
INSERT INTO tvt_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Rekamdi thungko jaalah loong ah thokrum taha. ‘Chuupha, Chuupha! ih riingbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Eno kuhoonte warah ih ngaakbaatta, ‘Tajen nop ran! Ngah ih sen tajat rumra.’ ");
INSERT INTO tvt_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Eno Jisu ih thoonbaat rumta, “Sen teeteewah naririh et ban sok an, tumeah sen ih tajatkan heh rangwuung saapoot rah ah. ");
INSERT INTO tvt_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Erah tokdoh rangmong Hasong ah arah likhiik ang ah. Teewadi mih wasiit mihah nah tumkhoom kaat suh ih li ano; heh laksuh loong ah lompoon rumta eno, heh nyamka ah neng suh ban maak thuk suh pheekoh rumta. ");
INSERT INTO tvt_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Marah laksuh ih tumjaat jen re ah erah jun ih pheekoh rumta: wasiit asuh haajaat banga hun jaanngun kota, wasiit asuh haajaat nyi, erah dam ih wasiit asuh haajaat siit. Eno heh ah hahoh ni kata. ");
INSERT INTO tvt_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Marah haajaat banga ngun chota laksuh rah ih lakdamdam ih pheehoon ni maakkaat ano, haajaat banga boot niik kata. ");
INSERT INTO tvt_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Erah likhiik ih marah haajaat nyi chota laksuh ah eh uh pheehoon ni maakkaat ano haajaat nyi boot niik kata. ");
INSERT INTO tvt_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Enoothong haajaat siit chota laksuh rah ih changte wah ngun ah habeng ah thoh ano hotthiin kaatta. ");
INSERT INTO tvt_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Rekam lidi neng changte wah ah ngaakwang haano heh ngun ah o ih mamet maak rumta ah jat suh lomtong thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Haajaat banga chote laksuh rah wang ano heh ih haajaat banga bootpat kowanta. ‘An ih haajaat banga kotahang, Chuupha,’ heh ih liita, ‘Arah sok uh! Haajaat banga ehoh boot niik katang rah ah.’ ");
INSERT INTO tvt_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Changteewah ih liita, ‘Elang eh uh, ese ih reetu, an ah ese nyia toongtang laksuh! ‘An suh ngun amasah kotaha rah toongtang lam ih maaktu thaang ah, ngah ih ansuh ngun ehan boot maak thuk ha. Raaho, Nga damdoh tenroon ih roong tongho!’ ");
INSERT INTO tvt_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Eno haajaat nyi chota laksuh ah thok haano liita, ‘Chuupha, an ih ngah suh haajaat nyi ngun kotahang, Sok uh! Arah haajaat nyi boot niik katang,’ ");
INSERT INTO tvt_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Elang eh uh ese ih reetu, an ah toongtang nyia ese laksuh!’ Changte ih liita. ‘An suh amasah ngun kotaha ah toongtang nyia ese lam ih maaktu thaang ah, ngah ih an suh ehan ngun boot maak thuk ha. Raaho ngah damdoh tenroon ih roong tongho!” ");
INSERT INTO tvt_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Erah lidi haajaat siit ngun chota laksuh ah thok haano liita, ‘Chuupha, Ngah ih an ah mithih ih ejat ih taha; an ih hephook lakiiko dowa kakhan uh, nyia hejih lawenko dowa kalom hu uh. ");
INSERT INTO tvt_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Erah thoih ngah echo eh ang no, an ngun ah habeng ni hotthiin kaattang. Sokthaak uh! Arah an ngun rah ah.’ ");
INSERT INTO tvt_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Heh changte warah ih liita ‘An ethih nyi edem laksuh!’ ‘Ngah ih laki kang dowa kakhan ang rah, nyia hejih lawen kang dowa hu ang rah, an ih jat ih tahang nih? ");
INSERT INTO tvt_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Angta bah uh, an ih nga ngun ah ngunnok nah thiin kaattu bah, nga ngaakwang tokdoh heboot hepat pan ih ngaakchoh thengtang. ");
INSERT INTO tvt_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Amah ih, heh jiin nawa ngun ah nge anno haajaat asih kotang wah asuh bootkoh an. ");
INSERT INTO tvt_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tumeah, o mina di amasah jeela asuh ehan ih bootkoh ah, enoothong o di amasah jeela ah thoon nge et ah. ");
INSERT INTO tvt_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Erah likhiik lajak nyia thaangmuh laksuh abah—laamang nah haatkaat an; erah doh heh pha ah phak ano toom huung ah.’ ");
INSERT INTO tvt_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mina Sah ah Rangsah loong damdoh luungwang ih raaha doh, heh ah luungwang tongtheng adoh tong ah, ");
INSERT INTO tvt_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","eno deek akaan rep nawa miloong ah heh ngathong nah lompoon rum ah. Eno heh ih dung nyi ih phe tongthuk rum ah, saapriimte ih saap loong ah ki dung nawa danje arah likhiik ah. ");
INSERT INTO tvt_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Heh ih kateng loong ah jaawako ih tongthuk ah, rukho loong ah dak hekko ih tongthuk ah. ");
INSERT INTO tvt_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Eno luungwang ah ih jaawako ni tongte loong asuh li ah, ‘Wanghan seng Wah ih romseetam kohalan loong rah ah! Wanghan rangmong hasong adoh tongsong wanghan sen raangtaan ih mongrep phangdong siitta di dook ban khookhamta. ");
INSERT INTO tvt_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ngah ramtek angtang adi sen ih phaksat kotahe, khamle angtang adi joong kotahe; Ngah wenwah angtang adi sen ih sen nok ni noppoon tahe, ");
INSERT INTO tvt_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nyia nyumuh angtang adi nyuh kotahe; Ngah khoisat angtang adi sen ih sokboi tahe, phaatak ni tongtang adi sen chomui ra tahan.’ ");
INSERT INTO tvt_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Eno kateng mina loong ah ih ngaakbaat ah, Teesu, seng ih an ramtek khamle ang uh rah babah japtupti eno phak asat ah koti? ");
INSERT INTO tvt_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Seng noppoon suh an wenwah ang uh rah babah jatupti, adoleh an nyumuh ang uh rah nyuh akhat babah koti? ");
INSERT INTO tvt_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Seng ih an khoisat ang uh rah, nyia phaatak ni ang uh rah babah chomui ra tahe?’ ");
INSERT INTO tvt_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Luungwang ih ngaakbaat ah, ‘Ngah ih baat rumhala, sen ih changthih noodek arah loong ah nyia ngaaphoh ngaano sokboi tan aju, ngah sokboi tahe!’ ");
INSERT INTO tvt_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Erah lidoh dak hekko ni tongte loong asuh li ah, ‘Nga re nawa haloh ang an, sen loong suh Rangte ekhat ela! Babah uh lametka we adoh kah an Hakhoh luungwang nyia heh sah loong raangtaan ih ban khookhamta adoh ah! ");
INSERT INTO tvt_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngah ramtek angtang adi sen ih phaksat takoh tahe, khamle angtang adi joong takoh tahe; ");
INSERT INTO tvt_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ngah wenwah angtang adi sen ih sen nok ni tanopsiit tahe, nyumuh angtang adi sen ih nyuwok takoh tahe, Ngah khoisat nyia phaatak ni angtang adi sen ih tasokboi tahe.’ ");
INSERT INTO tvt_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Eno neng ih ngaakbaat ah, Teesu,” Maatokdi seng ih an ramtek khamle, adoleh wenwah, nyumuh, khoisat, adoleh phaatak ni ang uh rah tup eno lachosok mabah etti?’ ");
INSERT INTO tvt_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Luungwang ah ih ngaakbaat ah, ‘Ngah ih baat rumhala, sen ih changthih noodek arah loong chosok daan tan aju, Ngah chosok ah daan tahe.’ ");
INSERT INTO tvt_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Eno, erah lidoh babah uh lametka we adoh cham thuk suh daap haat ah, enoothong kateng mina loong abah babah uh lathoonka roidong ah chowang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisu ih erah loong ah jen thoon nyootsoot rum ano, heliphante loong asuh baatta, ");
INSERT INTO tvt_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Sen ih jat ehan, sa nyi mongdoh, Khopi Kuwaang angte, eno Mina Sah ah bangphak nah rapbot suh mih suh jokoh rum ah.” ");
INSERT INTO tvt_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Eno romwah phokhoh nyia hadaang phokhoh loong ah Romwah Phokhothoon Kaiaphas noklong ni lomtong rumta, ");
INSERT INTO tvt_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","eno Jisu ah jokhak ano tek haat suh ngoongthum huthum rumta. ");
INSERT INTO tvt_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Neng ih liita, “Seng ih erah kuwaang tokdoh lajaajaat reejih, adoleh miloong ah phophaang daanmui rum ah.” ");
INSERT INTO tvt_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Bithaani ni Jisu ah engam wah Simoon nok ni angta. ");
INSERT INTO tvt_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jisu phaksat phaksah tokdi, minuh nusiit ih kom thuung adi phontum ah pi ano wang taha eno Jisu lah adi lokta. ");
INSERT INTO tvt_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Heliphante loong ah ih erah sok rum ano ekhat ih rumta. “Arah loong ah tumet suh thaaja wan halu? Neng ih cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Arah phontum ah ngun hantek doh sang ano changthih loong suh kotjih boh angta!” ");
INSERT INTO tvt_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Neng ih tumjih li rumta erah Jisu ih ejat etta , eno baat rumta, “Arah nuh ah sen ih tumet suh paklak han? Nga raangtaan ih heh jaase jih nyia epunjih boh reela. ");
INSERT INTO tvt_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Changthih loong abah saarookwih sen damdam eje ang ha, enoothong ngah ah sen damdoh saarookwih lajeete. ");
INSERT INTO tvt_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Arah nuh reela ah langla, nga sak nah phontum ah lok ano nga mangbeng thengnah thiinkaat suh ban khookhamha. ");
INSERT INTO tvt_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Amadi, ngah ih amiimi tiit baat rumhala arah mongrep adoh ruurang ese marah nah thok ah, erah doh arah minuh reela ah labeehaat thang ih samthun jih ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Eno heliphante loongdung dowa wasiit—hemen ah Judas Eskeriot—romwah phokhothoon nok ni kah ano ");
INSERT INTO tvt_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","chengta, “Jisu ah jokoh ha bah an ih ngah suh tumjih kohang?” Neng ih ngunkholok lo rookjom ah rookweh rum ano Judas suh korumta. ");
INSERT INTO tvt_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Erah sa dowa ih Judas ih Jisu ah neng suh jootkot suh rangwuung ban sok ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Toomuh Baanlo Kuwaang saakhoh thoon adi heliphante loong ah Jisu jiinni thokrum ano cheng rumta, “Khopi Romhoon phaksat ah an raangtaan ih maradoh khookham thuk he?” ");
INSERT INTO tvt_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Heh ih baat rumta, “Samnuthung ni mih esiit je ah erah jiinnah kah an, eno heh suh baat an: ‘Nyootte ih liita, nga saapoot ah thok ehala; nga liphante nyia ngah ih Khopi Romhoon phaksat ah an nok nah phaksah ih eah.’” ");
INSERT INTO tvt_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Heliphante loong ah ih heh ih mamet baatta erah jun ih kuwaang phaksat ah khookham rumta. ");
INSERT INTO tvt_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Rangjaako di, Jisu nyia heliphante asih wanyi loong ah phaksat suh tong rumta. ");
INSERT INTO tvt_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Phaksat tokdi Jisu ih liita, “Ngah ih baat rumhala, sengdung dowa wasiit ih ngah ah mih suh khumtante ang hali.” ");
INSERT INTO tvt_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Heliphante loong ah rapne ih thungthih rum ano wasiit wasiit ih cheng rumta, Teesu, Amiisak ih ngah suh maamok li jang oh?” ");
INSERT INTO tvt_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisu ih ngaakbaat rumta, “Nga damdoh khuungsiit ni roong phaksatte ih khuumtante ang halang. ");
INSERT INTO tvt_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mina Sah abah etek ete Rangteele ni raangha jun ih ah, enoothong tumthan echoojih ang ah Mina Sah khuumtante wah raang ih ah! Erah mih ah lalaan dong tup taha bah ese ang thengta!” ");
INSERT INTO tvt_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas, Jisu mokwaante wah, ah toonjengta. “Nyootte, an ih amiimi ngah suh maamok li jang oh?” Judas ih chengta. Jisu ih ngaakbaatta, “An ih liihu ah ju angte.” ");
INSERT INTO tvt_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Neng phaksat phaksah rum adi, Jisu ih baanlo ah toonpi ano, Rangte suh lakookmi rangsoom ah soom ano, chepphiitta, eno heliphante loong asuh korum ano, “Phak an; ih baat rumta, “Arah ah nga sak.” ");
INSERT INTO tvt_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Erah lilih heh ih lokkep ah toon ano, Rangte suh lakookmi liita, eno heliphante loong asuh korumta. “Jok an,” heh ih baatta; ");
INSERT INTO tvt_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Arah ah nga sih, Rangte nyia mina chamchi ni nuumiijeng tangmiin ha, nga sih ah miloong rangdah biin anaan suh jan ah. ");
INSERT INTO tvt_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngah ih baat rumhala, ngah ih arah kham ah babah uh takah jokkang seng Wah hasong nah sen damdoh kham na ah maang jokjok ah.” ");
INSERT INTO tvt_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Eno neng rangsoom boong ah boong rum ano Olip kong ni dokkhoom wang rumta. ");
INSERT INTO tvt_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Eno Jisu ih neng suh baatta, “Niikja sen ih ngah ah thiinhaat heeno moongsoon ete, tumeah Rangteele ni liiha, ‘Rangte ih saapriimte ah tek haat et ah, eno saapsah loong phaangjaang eah.’ ");
INSERT INTO tvt_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Enoothong ngah ewe ngaakthing eh ang doh, Ngah sen jaakhoh nah Galili hadaang adoh kah ang.” ");
INSERT INTO tvt_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pitar ah toonjengta eno Jisu suh baatta, “Wahoh loong ih thiinhaat ho bah uh ngah ih bah tahiin haat ra!” ");
INSERT INTO tvt_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisu ih Pitar suh baatta, “Ngah ih baat hala niikja woh we ngah ngah an ih ngah suh tajatkang ih lekjom liihang.” ");
INSERT INTO tvt_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pitar ih ngaakbaatta, “An damdoh roongtek jih ang adoh botseh emah ngah tajeng kang!” Eno heliphante wahoh loong eh uh emamah ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Eno Jisu ah heliphante damdi Getsemani et liiha hah adi kata, eno heh ih baat rumta, “Adoh ban tong an ngah therah doh rangsoom wang ang.” ");
INSERT INTO tvt_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Heh ih heh damdi Pitar nyia Jebidi sah wanyi ah siitwanta. Heh thungthet nyia heh mongsaam ah dong eta, ");
INSERT INTO tvt_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","eno heh ih neng suh baatta, “Nga ten ah rapne ih satla etek thanthan ah. Adoh tong anno ngah bansok he.” ");
INSERT INTO tvt_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Heh amasah haloot ni heng khoomta, eno hah ni kotbon ano rangsoomta, “Ewah ejen lang eabah, arah ngah chamnaang lookkep ah toon et weeuh! Enoothong nga thung jun doh lah angthang ih, an thung jundoh ju toom ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Eno heliphante wajom jiinni ngaak kah adi, neng ah emokjup ih rum arah kaptupta; eno heh ih Pitar suh baatta, “Senjom ih saapootsiit taan uh mamah lajen bansok et hali? ");
INSERT INTO tvt_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Rangsoom nah banban ih tong an sen phate joonnaam nah naktoom dat an. Chiiala abah enook taat ela, enoothong hansi ah ba naangla.” ");
INSERT INTO tvt_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jisu leksiit rangsoom we wangta, “Ewah nga maang chamkang jaakhoh nah, chamchoh lookkep ah lajen toonhaat jih ang abah, an thung jun doh toom ang raaha.” ");
INSERT INTO tvt_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Heh we ngaak kah adi heliphante loong ah mokjup ruh eh arah we japtup kata; neng mik uh tajen daapsok rumta. ");
INSERT INTO tvt_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Eno Jisu ah lekjom we wang ano, erarah ah we soomwangta. ");
INSERT INTO tvt_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Eno we ngaak ra haano heliphante loong asuh liita, “Amadi uh sen thok naangjup ruh nih elan? Sok an! Mina Sah ah rangdah miloong lak nah kot suh saapoot echang ela. ");
INSERT INTO tvt_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Saat an, kah ih. Sok an, arah nga khuumtante mina rah ah!” ");
INSERT INTO tvt_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisu ih erah baat tokdi heliphante dung dowa Judas, dong khoom taha. Heh damdi mih loong hantek lang apah pan romwah phokhoh nyia hadaang phokhoh ih daapjah rum taha. ");
INSERT INTO tvt_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas ih miloong asuh jatthukta: “Marah mih chupphak ang erah mih ah sen ih jam han rah ang ah. Eno erah ah khak an!” ");
INSERT INTO tvt_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas Jisu reeni phangla ih wang ano liita, “Semroongroong toomtong uh, Nyootte,” eno chupphakta. ");
INSERT INTO tvt_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisu ih ngaakbaatta, “Nga joonwah, tumjih raang ih wang halu, echaan eh uh!” Eno mih loong ah wang rum ano, Jisu ah jokhak rumta. ");
INSERT INTO tvt_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jisu dam dowa mih wasiit ih heh lang ah heehoom ano Romwah Phokhoh dah, na ah chepdookta. ");
INSERT INTO tvt_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jisu ih baatta, “An lang ah hetoop nah we ngaaksak uh, “O mina ih lang toon ah erah mina ah lang doh ti ah. ");
INSERT INTO tvt_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Sen ih tanih jatkan nga pangsuh seng Wah ah ejen poon et thengtang, eno lakdam damdoh rangsah sipaahi loong ah asih wanyi nang ih ehan et daapkaat theng taha? ");
INSERT INTO tvt_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Enoothong, emah mok ang abah Rangteele ni elang jaatjaat etheng ih liiha ah amiisak doh mamah ma jen ang ah? ");
INSERT INTO tvt_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Eno Jisu ih miloong asuh liita, “Sen loong ah nga joot suh lang apah pan nih ra halan, ehuh elek jootjoot ah? Ngah ih Rangteenok ni tong ano saarookwih kah nyootsoot tang rah ah, erah di mamah lah joh ih tahe? ");
INSERT INTO tvt_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Enoothong arah loong ah khowah loong ih Rangteele ni raangthiin rumta ra amiisak toom ih pun raaha ih angla.” Eno heliphante loong ah heh ah thiinhaat rum ano thoontang moongsoon rumta. ");
INSERT INTO tvt_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jisu khakte loong ah ih Romwah Phokhothoon Kaiphas nok adi siitwan rumta, erah di Hootthe nyootte nyia hadaang phokhothoon loong lomtong rumta ");
INSERT INTO tvt_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pitar ah haloot nawa neng lilih ih wang ano Romwah Phokhothoon nok adi thok phanjoh wanta. Pitar ah nokmong ni nopkhoom wang ano, sipaahi loong damdi roongtong wang ano mamah angthaak ah ih ban sokta. ");
INSERT INTO tvt_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Romwah Phokhoh loong nyia ah Ngoong awang loong ah ih lalangka di Jisu jen tek haat theng mat ih joot suh taat chung rumta; ");
INSERT INTO tvt_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","enoothong warep ih Jisu tiit hahuung baat suh taat wang rumha bah uh, hahuung tiit baat suh lampo tajeeta. Hethoondi wanyi toonchap ano ");
INSERT INTO tvt_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","baat nyuuta, “Arah mih rah ih liita, ‘Ngah ih Rangteenok ah thaak haat ang no, sa jom doh we jen hoon ang eah.’” ");
INSERT INTO tvt_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Romwah Phokhothoon ah toonchap ano Jisu suh liita, “An tiit erah thetbaat halu adi ngaak jengjih tatam jeeka?” ");
INSERT INTO tvt_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Enoothong Jisu ah su su ih tongta. Eno Romwah Phokhothoon ah ih we chengta, “Ething Rangte mendi ngah ih an suh thoomhoon thuk hala: baat thaak uh, Rangte Sah Kristo ang uh bah ah.” ");
INSERT INTO tvt_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisu ih ngaakbaatta, “An ih liihu ah ju ang ah. Enoothong ngah ih sen loong suh baat rumhala: aadowa ih Mina Sah ah sen ih Elong Rangte damdoh jaawako nah tong arah nyia rangmong hasong nawa jiingmuung damdoh raaha rah tup an!” ");
INSERT INTO tvt_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Erah dowa ih Romwah Phokhothoon rah ih heh nyuh ah ranhoom ano liita, Rangte kaanju hu! Erah tokkhodoh wahoh haaki takah jamke! Sen ih Rangte kaanju tiit belam jengta rah echaat ettan. ");
INSERT INTO tvt_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sen ih mamet thunhan?” Miloong ah li rumta, “Heh emoong ela eno tek haat jaatjaat etjih.” ");
INSERT INTO tvt_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Eno heh the adi took rum ano buh rumta; erah dam ih heh botte rah ih ");
INSERT INTO tvt_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","liita, “Seng tiit ah taat ban jat thaak uh Kristo ang uh bah ah! Jatthaak uh o eh buh taho!” ");
INSERT INTO tvt_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pitar ah nok taakkhuung ni tong adi Romwah Phokhothoon laksuh minuh ah kah ano liita, “An nep Galili nawa Jisu damdi angtu.” ");
INSERT INTO tvt_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Eno heh ih loongtang dung ni daanta. “An ih tumjih tiit baat hu erah ngah ih tajatkang,” Pitar ih ngaakbaat ano, ");
INSERT INTO tvt_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","erah dowa kaawan ko ih dokkhoom kata. Romwah Phokhoh laksuh nuhoh ih we tup ano erah dowa miloong asuh baat rumta, “Najaret dowa Jisu damdi heh angta.” ");
INSERT INTO tvt_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Eno Pitar ih daan ano we ngaak liita, “Ngah ethoom nep jen eang ngah ih erah mih ah tajatkang!” ");
INSERT INTO tvt_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Amasah ritdi erah di chap rumta miloong ah Pitar reeni kata. “Amiimi anbah neng dam dowa ju angkoko,” Miloong ah ih liita. “Sen Galili nok hah loong ah sen jeng nawa ih jatjoh hi!” ");
INSERT INTO tvt_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Eno Pitar ih liita, “Ngah ih thoomhoon damdi ami tiit baat rumhala! Rangte ih toomjat kohang, ngah ih tajatkang liitang ah hahuung tiit baatkang bah ah! Ngah ih erah mih ah tajatkang!” Erah damdam woh ah weeta, ");
INSERT INTO tvt_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","eno Pitar ih Jisu jengta ah samthunta: “Woh maang weeka doh an ih tajatkang ih lekjom jeng uh.” Heh dokkhoom kah ano rapne ih huung kata. ");
INSERT INTO tvt_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Rangkhano ih loongtang Romwah Phokhoh nyia mihak phokhoh loong ih Jisu tek haat suh kaankoong rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Eno jaanruh ih khak rum ano, Roman kobono Pilat suh kowan rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jisu khumtante Judas, ih Jisu tek haat tiit ah jat ano, heh thetre ah dokthunta, eno ngunkholok lo rookjom ah romwah phokhoh nyia hadaang phokhoh loong asuh ngaak kokaatta. ");
INSERT INTO tvt_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas ih liita, ‘Ngah rangdah jih reelang, toongtang mina tiit ah leekbaat angno tek haat thuk kohang!” “Erah seng raangtaan ih tumjih ma thih aleh?” Miloong ah ih ngaak liita, “Erah bah an mat ba hanih!” ");
INSERT INTO tvt_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas ih ngunkholok ah Rangsoomnok ni piihaat wan ano; heh teeteewah chiiti kata. ");
INSERT INTO tvt_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Romwah Phokhoh rah ih ngunkholok ah toon ano liita, “Arah ngun ah sih thaang, seng Hootthe jun ih Rangsoomnok nah tami thiinke.” ");
INSERT INTO tvt_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Neng ih erah tiit ah jen punwaan rum ano, ngunkholok ah ih Paaktek hoonte wah Phek wenwah mangbeng theng et reh rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Erah thoidi erah phek asuh amadi uh “Sih Phek” et menha. ");
INSERT INTO tvt_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Eno khowah Jeremiah ih banbaatta jengkhaap ah amiisak angla: “Neng ih ngunkholok lo rookjom ah ekap et rumta, Ijirel mina ih roomwaan rum ano heh suh thaang et korumta rah ah, ");
INSERT INTO tvt_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","eno erah ngun ah ih paaktek hoonte wah phek reh rum ah, Teesu ih baat tahang jun ih ah.” ");
INSERT INTO tvt_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisu ah heh suh jengkhaap chengte Roman kobonor ngah ni chapwangta. “Jehudi luungwang an tam anglu?” heh ih chengta. “An ih liihu aju,” Jisu ih ngaakbaatta. ");
INSERT INTO tvt_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Eno heh ih Romwah phokhoh nyia hadaang phokhoh loong ih heh thet tiit baatta adi heh ih suusu boichaat ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Erah thoih Pilat ih heh suh liita, “Erah thetbaat rum halu an ih tanih chaatko?” ");
INSERT INTO tvt_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ang abah uh Jisu ah jaasiit uh tangaak jengta, erah thoidi Kobonor ah rapne ih paatjaata. ");
INSERT INTO tvt_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Khopi Kuwaang rookwih Roman kobonor ih phaatak ni tongte noksong ih marah jamha mina, o ang abah uh wasiit kadaap haatta. ");
INSERT INTO tvt_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Erah tokdi phaatak ni mirep ih jat arah mina hemen ah Jisas Barabas tongta. ");
INSERT INTO tvt_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Eno miloong ah lomthok rum kano, Pilat ih cheng rumta, “Sen ih marah wah ah daapthuk he, Jisas Barbabbas ah tama Jisu Kristo et liiha rah ah?” ");
INSERT INTO tvt_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilat ih samsek et jatta Jehudi ngoong awang loong ih Jisu Kristo ah miksuk et rum ano jokoh jarum halang eah. ");
INSERT INTO tvt_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilat ah mat hoon nok ni tong adi, heh minuh ih kongphaak esiit maat kaatta: “Tumjih uh nakkah et an, tumeah muphe nga mangphe di erah wah tungthoidi ngah rapne ih chamnaang tang.” ");
INSERT INTO tvt_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Romwah phokhoh nyia hadaang phokhoh loong ah ih miloong ah jeng thuk rumta, Pilat ih Barabas ah daap haat etjih toom ang ah eah nyia Jisu ah tek haat etjih toom ang ah eah. ");
INSERT INTO tvt_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Enoothong Pilat ih miloong asuh cheng rumta, “Arah wanyi dowa marah wah ah daap haat korumha?” “Barabbas ah!” Miloong ah ih ngaakbaatta. ");
INSERT INTO tvt_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Erah ang abah, Jisu Kristo ih liiha asuh ngah ih tumjih et ang?” Pilat ih cheng rumta. “Bangphak nah rapbot an!” mih loongtang ih ngaakbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Eno Pilat ih cheng rumta, “Heh tumjih thetre kota?” Miloong ah erong ih toonriing rumta: “Bangphak nah rapbot an!” ");
INSERT INTO tvt_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat ih miloong ah sok rum adi, heh tumjih uh lakah miijeng thang ih phaangrook rumta, eno heh ih khamteng ah toon ano, miloong miksok di helak ah saatiita eno liita, “Arah mina tek ah nga mat tah angka! Arah sen mat!” ");
INSERT INTO tvt_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Miloong ah ih ngaakbaatta, “Arah mih tekla mat ah seng sak nah nyia sengsuh sengsah sak nah toomdat ha!” ");
INSERT INTO tvt_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Eno Pilat ih neng suh Barabas ah daap korumta; Jisu ah ruh ih buthuk rum ano, bangphak nah rapbot suh korumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Eno Pilat sipaahi loong ih Jisu ah kobonor nok ni siitwan rum ano, loongtang ih kookchap wanrumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Neng ih henyuh hekhat ah khook rum ano nyusaang ah kap thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Erah lidi suh nawa ih khopok ah hoon rum ano heh khoh adi phokthuk rumta, eno kiingthom ah jaawako lak adi piithuk et rumta; eno neng ah heh lathong adi neng lakuh di kotbon rum leh joonnaam soomtu et rumta. “Jehudi luungwang ah roitang toomtong kah!” ih li rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Heh sak adi neng took ah ih took, heh kiingthom ah nge rum ano heh khoh adi buh et rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jen joonnaam rum ano heh sak dowa nyuh ah ngaakkhook rum ano henyuh hekhat ah we kap thuk rumta. Eno bangphak nah botwan suh doksiit kaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Neng dokkhoom ih karum adi Siren hadaang nawa wasiit hemen ah Simoon chomui rumta, eno sipaahi loong ah ih heh suh Jisu bangphak roong hui laatbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Neng hah esiit Golgotha, ih liiha adi thok rumta, erah langla, “Mih khoraang hah” ih liiha. ");
INSERT INTO tvt_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Erah di neng ih Jisu suh kham ekhah jih damdi woi rum ano jok thuk rumta, enoothong taat taajok ano Jisu ih erah jok ah edaan etta. ");
INSERT INTO tvt_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Neng ih Jisu ah bangphak ni rapbot rum ano henyuh hekhat ah joopche rum ano rangkhoni wenhaat rumta o ko nah nyuchep dat thaak ah eah. ");
INSERT INTO tvt_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Erah lilih neng erah di tong rum ano ban sok rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Heh khothung adi neng ih heh chickram le ah amet raang rum ano rapbot rumta: “Arah Jisu Jehudi luungwang.” ");
INSERT INTO tvt_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Erah di Jisu damdi ehuh wanyi, esiit ah dak hekko esiit ah jaawako ih wak rapbot rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Miloong erah di lengkhoomte loong ah ih neng tok ah nyoongleh Jisu ah chikram et rumta: ");
INSERT INTO tvt_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“An ih Rangteenok ah thaak uno sa jom mongdoh we hoonte laangma angtu! Rangte sah ang ubah an teeteewah pang et uh ba! Bangphak dowa dat khoom raaho!” ");
INSERT INTO tvt_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Emamah romwah phokhothoon nyia Hootthe nyootte loong erah dam ih hadaang phokhoh loong ih Jisu ah chekram ngitkhuung rumta: ");
INSERT INTO tvt_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Heh ih mihoh bah epang kah eta, enoothong heteewah ah tajen pangka nih! Heh ah Ijirel luungwang ah baata nih? Heh amadoh bangphak dowa ah jen datkhoom raaha bah, seng ih hesuh hanpi et ih! ");
INSERT INTO tvt_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Heh ih Rangte suh laalom ano heh teewah ah Rangte Sah kah ih thiikta. Ese ang ah, eno bah seng ih sokthaak ih amadoh heh Rangte ih tam pangra thaak ha!” ");
INSERT INTO tvt_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Heh damdi uh wanyi wakbot rumta nyi ah ih emamah roong chekram nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Rangnithung di deek akaan thoontang ni saapoot jom raang ih rangnak datta. ");
INSERT INTO tvt_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Saasongko saapoot jom taan di Jisu ah erong ih riinghuungta, “Eloi, Eloi, Lema Sabachthani?” erah langla, nga Rangte, nga Rangte, an ih ngah tumet suh thiinhaat halang?” ");
INSERT INTO tvt_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mararah mina erah di chapte loong ah ih japchaat rum ano li rumta, “Heh ih Elijah poonha!” ");
INSERT INTO tvt_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Erah damdam wasiit ah soonkah ano, chanthah tuiba adi nyutom ah khak ano, thaangne jih kham adi tem ano, Jisu suh taat jok thukta. ");
INSERT INTO tvt_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Rukho loong ah ih li rumta, “Ma ban sokthaak ih, Elijah ih heh tam pangra thaak ha!” ");
INSERT INTO tvt_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisu ah erongwah we ih riinghuung ano heh tak ah supta. ");
INSERT INTO tvt_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Eno Rangteenok ni nyuh tinta ah hekhoh dowa ih hetang tuk ih khoonyi ih khoodatta. Hah ah moh eta, jong loong ah khoodat etta, ");
INSERT INTO tvt_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mangbeng loong ah raapphok eta, eno Rangte mina tekchoote loong ah hantek ngaakthing rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Neng ih mangbeng ah thiinhaat rum ano, Jisu tek nawa ngaakthing lini, neng ah Esa Hadaang adi mirep ih japtup rum arah ih wang rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jisu ban sok rumta loong arami saahaap nyia sipaahi ah ih hah mota nyia erah di mamangta loong ah sok rum ano rapne ih cho rumta, eno jeng rumta, “Amiimi heh Rangte Sah angta joh!” ");
INSERT INTO tvt_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Erah di minuh loong hantek ih haloh nawa ih bansok rumta, neng ah Jisu lilih Galili nawa ih dook heh sokboite roong phankhoom rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Minuh loong dung adi Meeri Magdaleni, Jeems nuh Meeri ah lang, Josep nyia Jibedi minuh loong ah ang rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Rangja ko di, changteng wasiit Aramathea nawa thok taha, hemen ah Josep angta, heh uh Jisu liphante esiit angta. ");
INSERT INTO tvt_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Heh Pilat pandi nopwang ano Jisu mang ah suh wangta. Pilat ih Jisu mang ah Josep suh koh an ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Eno Josep ih mang ah toon ano, nyuleep ena ih khoonta, ");
INSERT INTO tvt_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","eno heh ih mangbeng luung ah jong khoni erarah ih thoh aradi thiin kaatta. Eno heh ih mangbeng luung kaawan adi jonglo elongwah ah tangkoong thiin ano kata. ");
INSERT INTO tvt_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meeri Magdelini nyia Meeri nusiit ah mangbeng ko ih soknyu ano tong nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jehudi loong naangtongsa saalih adi, romwah phokhoh nyia Phirasi loong ah Pilat damdi chotong rum ano ");
INSERT INTO tvt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","baat rumta, “Chuupha, eleek warah ih ething tokdi heh ame jengta rah dokthunhi, ‘Ngah sa jom lidoh we ngaakthing ete.’ ");
INSERT INTO tvt_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Erah thoih, baat rum uh, sa jom mong adoh heh mangbeng ah naririh toom et ban karum ah, heliphante loong ih heh mang ah nak toom jen hutoon karum asuh ah, miloong asuh tek nawa ngaaksaat eta ih phoh tumbaat rum ah. Eno bah arah lithoon ih leekbaat hi ah jaakhoh ni lekbaatti nang ih ehanthoon ih thette angla.” ");
INSERT INTO tvt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Naririh ih ban an,” Pilat ih baat rumta; mangbeng ah mathan jen bansok an et ban sokkah an.” ");
INSERT INTO tvt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Eno neng ah karum ano mangbeng dowa jonglo ah huk miinmook karum ano bante suh ban thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jehudi naangtongsa lih adi Meeri Megdelini nyia nuhoh Meeri ah naangtongsa rangkhano di mangbeng theng sokkah nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Baphuk ih erah di hasah mota; rang nawa rangsah ah ra haano, mangbeng dowa jonglo ah dokkoongta, eno erah khoh adi tongta. ");
INSERT INTO tvt_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Heju hela ah weephaak likhiik angta, eno henyuh hekhat ah nge likhiik puung chamcham angta. ");
INSERT INTO tvt_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bante loong ah tekmang likhiik ih dong mocho rumta. ");
INSERT INTO tvt_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Rangsah ih minuh nyi asuh liita. “Set nakcho ansih,” “Ngah ih jat ih nyu hala, set ih Jisu banphak ni tek haatta rah bansok hansih. ");
INSERT INTO tvt_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Heh aadi tajeeka; heh ih baatta jun ih ejen ngaaksaat eta. Heh juptheng ah sokwang hansih. ");
INSERT INTO tvt_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Echaan ih ngaakwang ansih no, heliphante loong suh thongbaat wan ansih, ‘Heh tek nawa ejen ngaaksaat eta eah, heh amadi set ngah ngah Galili ni kala; erah nah sen ih heh ah japtup an!’ Samthun et an ngah ih baat rumhala rah ah.” ");
INSERT INTO tvt_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Erah thoidi nengnyi ah mangbeng nawa echaan ih soonwang nyuuta, thako adi echo ih nyu thako adi tenroon ang nyuuta, eno heliphante loong asuh baatwan nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Baphuk ih Jisu ah nyi damdi chomui nyu ano baat nyuuta, “Semroonroong toomtong ansih.” Nengnyi ah Jisu reeni ra nyuuha no, heh lasih ah joh nyu ano soom nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Nakcho ansih,” Jisu ih baat nyuuta. “Galili nawa ngaaphoh ngaano loong asuh baatkaat ansih, neng ih ngah erah nah japtup rumhang.” ");
INSERT INTO tvt_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Minuh nyi ah lam ni wang nyu adi, mararah mangbeng bante sipaahi loong ah samnuthung ni ngaakwang rum ano romwah phokhoh suh mamah angta tiit loong ah baatwan rumta. ");
INSERT INTO tvt_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Romwah phokhoh loong ah hadaang phokhoh loong damdi chotong rum ano kaankoong rumta; eno neng ih bante sipaahi loong asuh ngun hantek et korum ano, ");
INSERT INTO tvt_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","baat rumta, “Sen ih Jisu mang ah heliphante loong ih rangphe di sen emokjup ih pootdi hutoon rumta ih tumbaat an.” ");
INSERT INTO tvt_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Eno Kobonor ih arah tiit ah japchaat abah, seng ih ma hukbaat ih sen tathih kan eah, sen erah suh nak sootsaam an.” ");
INSERT INTO tvt_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bante loong ah ih ngun ah thaang rum ano neng ih baatta jun ih re rumta. Eno erah tiit ah Jehudi loong chamchi ni chiinyah tuk ih tiiwaan rumla. ");
INSERT INTO tvt_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Heliphante asih wasiit loong ah Galili kong ni Jisu ih baat rumta hah adi wang rumta. ");
INSERT INTO tvt_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jisu ah tup rum ano heliphante loong mararah mongchi taat ang abah uh heh rangsoom rumta. ");
INSERT INTO tvt_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisu ah nengko ih tiitkhoom kah ano baat rumta, “Rangmong hasong nyia hatoh adi jaatrep chaan aphaan ngah suh kotahang. ");
INSERT INTO tvt_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Erah ang abah, sen kah anno, noongrep nawa mina loong ah nga liphante ih hoon kah an: Heh Wah, Heh Sah, nyia Esa Chiiala mendoh, juungtem tem kah an, ");
INSERT INTO tvt_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","eno ngah ih baat rumhala tiit ah mirep ih erah lam ah toomphan asuh nyootsoot kaat an. Eno Ngah ah sen damdoh rang nyia hah maang thoonthoon saarookwih roong tonghang.”");
INSERT INTO tvt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Arah Rangte sah, Jisu Kristo Ruurang Ese tiit. ");
INSERT INTO tvt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Erah jengkhaap ah khowah Isaia ih mamet baatta erah jun ih phang langta: “Rangte ih liita, ‘Ngah ih an ngah nah kaamwah an lam ban tan suh daapkaat hang.’ ");
INSERT INTO tvt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mih esiit phisaang hamong ni riingla, ‘Teesu raangtaan ih lam ban hoon thiin an; heh khoom raangtaan ih lamjun et hoon an!’” ");
INSERT INTO tvt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Eno Joon ah phisaang hah ni juungtem nyia Rangte tiit tumbaat lam ih dong taha. Heh ih mina loong suh baatta, “Sen rangdah loong nawa ngaaklek ano juungtem an, eno ba Rangte ih sen rangdah ah biin anaan han.” ");
INSERT INTO tvt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judia juungkhuung nyia Jerusalem samnuthung nawa mina loong ah Joon jengkhaap chaat karumta. Neng ih neng rangdah loong ah dokbaat rum ano Jordan Juung adi juung ah tem ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Joon ih mokchongdoot roon nawa ih hoon arah nyuh akhat kapta, heh room adi siikhoop roomkhe ah khe etta, eno heh phaksat ah wotuute nyi najui angta. ");
INSERT INTO tvt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Heh ih mina loong suh thaaraam lam ih baat rumta, “Mina wasiit nga lih nah raakte ang hala erah wah ah nga nang ih elongthoon ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngah bah heh lakhoop pak taajoh tha uh taliikang. Ngah ih juung nawa ih tem rumhala, heh ih bah Esa Chiiala nawa ih tem raahan.” ");
INSERT INTO tvt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Rekamdi Jisu ah Najaret hadaang Galili juungkhuung dowa thok taha, eno Joon ih Jordan juung ni Jisu juungtemta. ");
INSERT INTO tvt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Juung nawa Jisu dokkhoom damdam, rang ah laangdat ano Esa Chiiala ah wotuupi woh likhiik ih datpuh raaha rah tupta. ");
INSERT INTO tvt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Eno rang ni dongjengta, “An ah nga mongnook Sah. Ngah an suh eroon elang.” ");
INSERT INTO tvt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Erah damdam Esa Chiiala ih phisaang hah ko ni kaat thukta, ");
INSERT INTO tvt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","erah di heh saarookbaji tongta, eno Soitaan ih phateeta. Erah damdi woma siiawi nep angta, enoothong rangsah loong ra haano chosokboi rumta. ");
INSERT INTO tvt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Joon phaatak ni sakta lini, Galili ni Jisu ah kah ano Rangte re nawa Ruurang Ese loong ah tumbaat kaatta. ");
INSERT INTO tvt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Saapoot ese thok ah chang ela,” Jisu ih liita, Rangte Hasong ah thok ih hala! Sen rangdah loong nawa elek ean, eno Ruurang Ese ah hanpi an!” ");
INSERT INTO tvt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisu Kristo Galili juungsitum kaang ni khoom kah adi, heh ih nyah haate soophoh wanyi Simoon nyia heno Endriu chaak ha tokdi japtupta. ");
INSERT INTO tvt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisu ih nyi suh baatta, “Nga damdoh wang hansih ngah ih mih mamet joh ah erah nyoot nyuuha.” Jisu ih Pitar nyia Endriu khoonkhuung nawa poonta. ");
INSERT INTO tvt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Erah damdam chaak ah thiinhaat nyu ano heh damdi roongwang nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Amasah haloot ni wang adi, Jebidi sah soophonyi Jeems nyia Joon we japtupta. Nengnyi ih khoonkhuung ni chaak khookham tok ang nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisu ih tupnyu ano erah damdam laan poon ruh et nyuuta; eno nyi wah Jebidi ah neng ih lakbiitte ih siitkaat rumta ah damdi khoonkhuung ni thiinhaat nyu ano Jisu damdi roongwang nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisu nyi heliphante loong ah Keparnam hadaang adi thok rumta, Jehudi naangtongsa saalih adi, Jisu ah Jehudi rangsoomnok ni kah ano phang nyootsoot kata. ");
INSERT INTO tvt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Heh ih nyootsoot rumta ah chaat rum ano mina loong ah rapne ih paatja rumta, heh Hootthe nyootte loong ah ih nyootta ah likhiik lah angthang ih, chaan aphaan pan et nyootta. ");
INSERT INTO tvt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Erah damdam chiithih laakhah pan mih wasiit, Jehudi rangsoomnok ni thok haano riingta. ");
INSERT INTO tvt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Najaret nawa Jisu, an ih seng tumjih et he? Aani seng thet haat suh tam wang halu? Ngah ih jat et hala an o ah—an ah Rangte Esa kaamwah!” ");
INSERT INTO tvt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisu ih laathih asuh baatta, “Nak hoopti uh, arah mih sak dowa doksoon eh uh!” ");
INSERT INTO tvt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chiithih laakhah rah ih mih ah mootnyoong thiin ano, riinghuung lam ih doksoonta. ");
INSERT INTO tvt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Miloong ah rapne ih paatja rumta, eno neng chamchi ni wasiit wasiit suh phang chengmui rumta, “Arah tumjih ah? Arah tiit ah jaat hoh tiit na tam nyoot ha? Arah mih adi chiithih laakhah dok phanjih chaan nep bojeela! Heh jeng ah chiithih laakhah ih nep chaat ha ah!” ");
INSERT INTO tvt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Eno Jisu ruurang ah erah dowa ih Galili hakong noongrep ni ruurang kata. ");
INSERT INTO tvt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisu nyi heliphante, erah damdi Jeems nyia Joon, Jehudi rangsoomnok nawa dokkhoom rum ano phangla Simoon nyi Endriu nok ni karumta. ");
INSERT INTO tvt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simoon hopnuh ah sokwi ih sat ano jup eta, Jisu thok damdam, heh maasaat tiit ah laan banbaat ruh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jisu ah wang ano, heh lak adi joh ano deesiitta. Heh sokwi khoisat ah laan de ruh eta, eno neng suh phaksat ah jam koh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Rangsa lup damdam rangjaako di miloong ih Jisu jiinni khoisatte nyi echeek ebaang loong thutsiit jarum taha. ");
INSERT INTO tvt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Erah hah dowa mina loongtang erah nokka adi thutkhoom rumta. ");
INSERT INTO tvt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jisu ih hephan dowa khoisat maasaat ah deesiit ano mikmuh juungbaan loong ah phanhaatta. Jisu ih mikmuh juungbaan loong suh tumjih uh tami jeng thukta, tumeah Jisu ah o angla neng ih jat eta. ");
INSERT INTO tvt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Erah saalih rangkhano chichuruh di, Jisu ah saat ano, erah nok dowa dokkhoom kata. Erah hadaang dowa tikpakpak hani Rangsoom suh dokkhoom kata. ");
INSERT INTO tvt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Enoothong Simoon nyi heh joonte loong ah heh jam sok dokkhoom karumta, ");
INSERT INTO tvt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","eno japtup rum ano Jisu suh baat rumta, “Warep ih an ban sok halu.” ");
INSERT INTO tvt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Enoothong Jisu ih ngaakbaat rumta, “Seng arah rum dowa hahoh loong adoh ekaatjih jaatjaat ang ah. Ngah ih erah hah loong adoh uh nyootsoot jaatjaat etjih tumeah, ngah erah raangtaan ih ra tahang.” ");
INSERT INTO tvt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Eno Jisu ah Galili hakong noongrep ni tumkhoom ano Jehudi rangsoomnok loong adi tum nyootsootta, juungbaan ah riim dokphan etta. ");
INSERT INTO tvt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Engam ang arah wasiit, Jisu ngathong ni heh lakuh di tongwang taha, eno chosok ih weehang ih baatta. “An ih thun ubah, ngah ejen saasiit ehang.” heh ih liita. ");
INSERT INTO tvt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisu heh minchan ah dong ano, heh lak ah janghaat ano taajota. Eno liita, “Esaasiit et ha,” ‘Sa uh!” ");
INSERT INTO tvt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Lakdamdam di erah mih ah laan saade ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Eno Jisu ih erah wah asuh dangdang ih baat ano, echaan ih kaat thukta, ");
INSERT INTO tvt_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","jen baat ano liita, “boichaat uh, an ih o suh uh arah tiit ah nak baat uh. Enoothong phangla romwah jiinnah wang uno heh ih toomhuk sokboiho an khoisat deetu rah ah, mirep ih de eta ih toomjat rumho, Moses ih baatta jun ih an khosa ah kowan et uh.” ");
INSERT INTO tvt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Enoothong erah warah ih noongrep ni heh khoisat deeta tiit ah phang tiibaat kaatta. Erathan ih tiibaatta, Jisu ah erah hadaang adi saasa tanaan wangta. Erah nang ih, heh hatik ni tong katta, ang abah uh miloong ah heh jiinni noongrep nawa thokruh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Rekam ritdi Jisu Keparnam ni, ngaakwangta, eno heh nok ni eje ih tiibaat mui rumta. ");
INSERT INTO tvt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Erah thoidi miloong ah nokmong ni lathoh lathang ih lomkhoom rumta, kaasakthong ni nep hantek ang rumta. Jisu ih neng suh ruurang ese tiit nyootsoot rum adi ");
INSERT INTO tvt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","wabaji ih hiimuung wasiit Jisu reeni thokpi wanrumta. ");
INSERT INTO tvt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Enoothong mih hantek ang thoidi, Jisu jiinni erah mih ah tajen noppi rumta. Erah thoidi Jisu khothung pun nokkhoh adi loohoom rum ano dam khoh adi hiimuung ah jupthiin rum ano datthiin rumta. ");
INSERT INTO tvt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisu ih neng tuungmaang ah tup ano hiimuung ah suh baatta, “Nga sah, an rangdah loong ah biin anaan et halu.” ");
INSERT INTO tvt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Heh reeni tongta Hootthe nyootte loong ah ih erah chaat rum ano neng thungthung ni thun rumta, ");
INSERT INTO tvt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Heh emah mamah ih naan jengla? Arah ba Rangte kaanju tiit! Rangte heh luulu ih ba rangdah loong ah biin anaan jen hoon ah!” ");
INSERT INTO tvt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Erah damdam Jisu ih neng tenthun ah jat rum ano li rumta, “Emah sen ih mamet thunhan? ");
INSERT INTO tvt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Hiimuung asuh, ‘an rangdah loong ah biin anaan et taho ih baat ah laangpopoh nih ang ah,’ adoleh, ‘an dam ah toonpi uno wang uh ih baat ah elaang nih ang ah?’ ");
INSERT INTO tvt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Erah ang abah, ngah ih jatthuk rumha Mina Sah jiinni arah hatoh adi rangdah loong jen biin anaanjih chaan jeela eah.” Eno Jisu ih hiimuung asuh baatta, ");
INSERT INTO tvt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ngah ih baat hala, toonchap uh, dam ah toonpi uno nok nah wang uh!” ");
INSERT INTO tvt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Neng loongtang miksok di, erah wah ah toonchapta, eno heh dam ah toonpi ano seek ih toonsoonta. Neng loong ah rapne ih paatja rum ano Rangte rang ah phoong rum ano jeng rumta, “Arah likhiik babah uh tathaak tupke!” ");
INSERT INTO tvt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisu Galili juungsitum kaangko adi we ngaak kata. Miloong ah heh jiinni lomkhoon rumta, eno Jisu ih erah loong asuh phang nyootsoot rumta. ");
INSERT INTO tvt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Erah di lengkhoom adi, sokse seete Leewi Alphias sah, apit ni tong arah japtupta. Eno Jisu ih heh suh baatta, “Nga lilih eho.” Eno Leewi ah toonchap ano heh lilih eta. ");
INSERT INTO tvt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Rekamdi Jisu ih Leewi nok ni phaksat sata. Sokse seete loong nyia rangdah mina hantek Jisu lilih ih rumta, eno neng dung dowa rukho loong ah ih heliphante loong damdi teebun ni cham roong sah rumta. ");
INSERT INTO tvt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pharisi dung dowa mararah Hootthe nyootte loong ah ih Jisu ah sokse seete nyia rangdah mina loong damdi phaksah arah japtup rum ano, neng ih heliphante loong asuh cheng rumta, “Erah likhiik mina loong damdi mamet phaksah ha?” ");
INSERT INTO tvt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisu ih japchaat ano ngaak liirumta, “Mina sak eseete ih phonwah tajamka, khoisatte ih ba jamha. Ngah kateng mina poon tara tahang, rangdah mina loong raang ih ra tahang.” ");
INSERT INTO tvt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Saasiit Juungtemte Joon liphante loong nyia Pharisi loong ah samurangsoom tong rumta. Mararah mina Jisu jiinni wang rumha no chengrumta, “Juungtemte Joon liphante loong nyia Pharisi loong ah samurangsoom tong ela, enoothong an liphante loong ah tatong rumka nih?” ");
INSERT INTO tvt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisu ih ngaakbaat rumta, “Kuhoon sa doh wen loong ah samuh toom ngaakwang rum ah nih thunhan? Emah tah angka! Jaalakapte ah neng damdoh ang adoh, neng babah uh emah tareeka. ");
INSERT INTO tvt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Enoothong neng re nawa jaalah kapte ah toonsiit rangwuung ah thok eha, eno ba neng samurangsoom tong rum ah. ");
INSERT INTO tvt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“O eh uh samsong ehak ah nyulep ena ih talep phingka, emah mok et phing abah nyuna chep rah ih nyuh hak ah boot raap hoom ano poolong ih thoon boot hoon ah. ");
INSERT INTO tvt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Adoleh kham na ah siikhoop tiikook ehak adoh tasakka, emah mok ang abah tiikook ah ephok eah, eno kham nyia tiikook enyi nyi thih ah. Erah nang ih kham na ah tiikook ena nah sak theng.” ");
INSERT INTO tvt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jehudi naangtongsa di Jisu nyia heliphante loong ah chamtong ni daankhoom rum adi, heliphante loong ih raanteh ah phang thi phak rumta. ");
INSERT INTO tvt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Erah thoidi Pharisi loong ah ih Jisu suh liita, “Sok uh, an liphante loong ah ih naangtongsa di erah re rumla rah seng Hootthe di tapunka!” ");
INSERT INTO tvt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisu ih ngaakbaatta, “Dewid ah ram ih ti ano phaksat suh ramta tok adi tumjih etta? Heh nyia heh joonte loong neng ram ih ti rumta, ");
INSERT INTO tvt_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","eno heh Rangte nok ni wang ano Rangte suh kota baanlo ah phaksah wangta. Erah di Abiathar ah romwah phokhoh angta. Seng Hootthe jun ih bah baanlo ah romwah loong ih ba jen phaksah ah—enoothong Dewid ih phaksah ano heh mina loong suh nep kota.” ");
INSERT INTO tvt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisu ih thoonbaat rumta, “Jehudi naangtongsa ah mina ese raangtaan dongsiitta; mina ah Jehudi naangtongsa raangtaan ih tah angka. ");
INSERT INTO tvt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Erah thoidi Mina Sah ah naangtongsa asuh Teesu angla.” ");
INSERT INTO tvt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Eno Jehudi rangsoomnok ni Jisu ngaakwangta adi, erah ni lakkoong wasiit angta. ");
INSERT INTO tvt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Erah di mararah mina ih Jisu tumjih lasah thetreela ih bansokte eje angta, erah thoidi naangtongsa adoh mina maamok deesiit jaaoh ih ban sok rumta. ");
INSERT INTO tvt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisu ih erah mih asuh baatta, “Nga ngah ko ih chap raaho.” ");
INSERT INTO tvt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Erah lilih Jisu ih miloong asuh chengta, “Seng Hootthe ih naangtongsa doh tumjih ettheng ih baat hali? Ese re theng tam ethih re theng ah? Mih roidong ah pang tam etheng ah tam ah tek haat etheng ah?” Miloong ah tumjih uh tajengta. ");
INSERT INTO tvt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Miloong ah sok ano Jisu ah ekhat eta, thako adi neng thung ah jong ajaan likhiik ih thih rum kano heh tenthet dongta. Eno lakkoong wah asuh liita, “An lak ah janghaat uh.” Heh lak ah janghaat kah no ese we ih ngaak hoonta. ");
INSERT INTO tvt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Erah thoidi Pharisi loong ah Jehudi rangsomnok nawa dokkhoom rum ano Hirod mina loong damdi, neng ih Jisu tek haat suh kaankoong karumta. ");
INSERT INTO tvt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisu nyia heliphante loong ah Galili juungsitum ko ih dokkhoom karumta, eno Galili nawa miloong ah hantek neng lilih ih roong karumta. Miloong ah Judia nawa, ");
INSERT INTO tvt_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem nawa, Idumia hadaang nawa, Jordan juung saadongko hah nawa, erah damdi Tairi nyia Sidoon hah noongrep nawa lomkhoomta. Erah mina loongtang Jisu jiinni thokrum taha tumeah neng ih Jisu reeta ruurang ah japchaat et rumta. ");
INSERT INTO tvt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Miloong ah hantek ang thoidi Jisu ih heliphante loong asuh khoonkhuung heh duungchap suh jamthiin thuk rumta, miloong rah ih phojap nak rumhang eah. ");
INSERT INTO tvt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Heh ih mih hantek deesiitta, erah damdi uh khoisatte ephoop ih Jisu jap taajoh suh rapne ih tuutmui rumta. ");
INSERT INTO tvt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Chiithih laakhah pan miloong ah Jisu ah japtup rum leh loongdat emeleh riinghuung ih rumta, “An juuba Rangte sah ah!” ");
INSERT INTO tvt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jisu ih chiithih laakhah loong asuh heh tiit ah o suh uh latumbaat theng ih dangdang et baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Eno Jisu kong ni duung wang ano heh ih jamta mina loong heh damdoh wak wangsuh poon rumta eno neng loong ah heh reeni ra rum taha, erah lih adi ");
INSERT INTO tvt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","asih wanyi ah danje ano Kaamwah et men rumta. “Ngah ih sen loong ah nga damdoh ang raang ih danje rumhala,” neng suh baat rumta. “Ngah ih sen loong ah Rangte tiitkhaap tumbaat raangtaan ih nep kaatthuk rumha, ");
INSERT INTO tvt_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","eno sen suh chiithih laakhah loong dok phanjih chaan uh eje ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jisu ih danjeeta asih wanyi loong ah arah: Simoon (Jisu ih Pitar et menta), ");
INSERT INTO tvt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jebedi sah soophoh nyi, Jeems nyia Joon, (Jisu ih Boonergis et menta, erah langla “Rangphah mih”); ");
INSERT INTO tvt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endriu, Philip, Batholomi, Mathiu, Thomas, Alphias sah Jeems, Thadias, Simoon deek akaan raangtaan ih laatte wah ");
INSERT INTO tvt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nyia Judas Iskerot, Jisu khumtante wah ah. ");
INSERT INTO tvt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Eno Jisu ah nok ni wangta. Erah di uh mina loong hantek ih lom thutthi rumta, Jisu nyia heliphante loong chamsat saapoot uh lachoh thang ah. ");
INSERT INTO tvt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jisu suh, “Emok ih hoonla” ih li rum kano, heh jaatang ah heh toonsiit ra rum taha. ");
INSERT INTO tvt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mararah Jerusalem nawa Hootthe nyootte loong ra taha loong ah ih li rumta, “Arah mih abah Benjibul pan boh ah! Chiithih laakhah loong jen dokphan theng chaan kotte luungwang ah boh ah.” ");
INSERT INTO tvt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Erah thoidi Jisu ih heh reeni poon rum ano tiitthaak di toobaat rumta. “Soitaan ih Soitaan ah mamah mi et phanhaat ah?” ");
INSERT INTO tvt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Deek esiit ah neng laktung nah phe ano rookmui abah, erah deek ah phaangjaang eah. ");
INSERT INTO tvt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Changka siit laktung nah rookmui jengmui abah, erah changka ah phaangjaang eah. ");
INSERT INTO tvt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Erah thoidoh Soitaan hasong adoh neng laktung nah pheehoom mui abah, erah roitang tatongka, erah nang ih bah phaangjaang rum ano ethoon ba eah. ");
INSERT INTO tvt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Tathat mina nok ah long suh heh teewah ah lachaak tangkhakka bah heh hukkhaak ah tajen longka. ");
INSERT INTO tvt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ngah ih ami tiit baat rumhala, mina rangdah loong nyia neng ethih jengkhaap jengla loong ah biin anaan jenhoon mok et ah. ");
INSERT INTO tvt_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Enoothong o ih Esa Chiiala asuh ethih jengkhaap jeng abah, babah uh biin anaan tachoka, tumeah heh ih mabah uh lathoonjih rangdah ah mola.” ( ");
INSERT INTO tvt_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisu ih arah baatta ah langla, mararah mih ih amet li rumta, “Heh sak ni chiithih laakhah pan eah.”) ");
INSERT INTO tvt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Eno Jisu nuh nyia heh no loong ah thok rumta. Nokka ni chap rum ano, Jisu ah poonwang thuk rumta ");
INSERT INTO tvt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jisu ah miloong hantek ih kooktong rum adi baat rumta, “Sok uh, an nuh nyi an no loong ih nokka ni chap rum ano, an jam rum halu.” ");
INSERT INTO tvt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisu ih ngaakbaatta, “Seng nuh o ah? Nga no loong o ah?” ");
INSERT INTO tvt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Heh reeni kooktongta miloong ah sok ano liita, “Sok an! Ngah di bah arah loong ah seng nuh nyia ngaaphoh ngaano loong ah! ");
INSERT INTO tvt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","O ih Rangte jeng chaat ha erah loong abah seng nuh, seng nah nyia ngaapho ngaano ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisu ih Galili juungsitum kaangkook ni we phang nyootsoot rumta. Miloong hantek ang thoidi Jisu ah khoonkhuung ni duungtong kata. Eno miloong ah juungsih kaang adi chap rumta. ");
INSERT INTO tvt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Heh ih tiitthaak toobaat lam ih jaatrep tiit loong ah nyootsoot rumta, ame jeng ano ah: ");
INSERT INTO tvt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Chaat an! Jaasiit mih esiit ih chamwen kaatta. ");
INSERT INTO tvt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Phek ni chamwen adi, raanteh loong mararah ah lam ni datta, eno woh loong ih toontop wangtaha. ");
INSERT INTO tvt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mararah ah jong hah ni paak amasah ang arah di datta. Eno raanjih ah seek ih haapphookta, tumeah paak amasah ang thoidi ah. ");
INSERT INTO tvt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Eno rang ah mi kano champhooksah loong ah laan tek raat ruh eta, tumeah hehing ah hanteng ni lamiisot thoidi hephook ah seek ih hookdatta. ");
INSERT INTO tvt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mararah raanteh ah suh buk ni datta, eno suphook ah hak ano, champhook ah hetiik uh ladong tiik thuk thang ih tekbukta. ");
INSERT INTO tvt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Enoothong mararah raanteh ah hase ni datta loong abah, phook ano hak, eno hetiik ah dong tiikta: mararah ah tiik ah rookjom, rukho ah rook arok, rukho ah chaasiit ih dong tiikta.” ");
INSERT INTO tvt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Eno Jisu ih thoonbaat rumta, “Chaat an, sen na je abah ah!” ");
INSERT INTO tvt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisu heh laklak ang adi, ethok ih taha ih japchaatte miloong nyia heliphante Asih wanyi rah ih, tiitthaak loong ah huk jangbaat kohe ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","“Sen suh Rangte Hasong ni huthiinha mongtham ah jatthuk rumhala.” Jisu ih ngaakbaat rumta. “Erah tiitthaak loong abah wahoh loong ih toomchaat ah ih nyootbaat hang, ");
INSERT INTO tvt_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","mamah liidi, “Neng ih sok bah sok et ah, ang abah uh tatup rumka; neng ih chaat bah chaat et rum ah, ang abah uh tasamjat rumka. Tumeah neng ih erah jat rumta bah Rangte ko ngaak ih rumtheng taha, eno neng rangdah loong ah biin anaan et thengta.” ");
INSERT INTO tvt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Eno Jisu ih cheng rumta, “Sen ih arah tiitthaak ah tanih jatkan? Erah bah, jihoh tiitthaak tang nih ma jat an? ");
INSERT INTO tvt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Chamwente rah ih Rangte tiit wenha. ");
INSERT INTO tvt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mararah mih ah raanjih lam ni datta rah likhiik, neng ih Rangte tiit ah chaat damdam soitaan ah wangha no nge kaatla. ");
INSERT INTO tvt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Rukho mih ah raanjih jong khoni dat ah likhiik. Rangte tiit ah japchaat rum ano, tenroon lam ih kap rumha. ");
INSERT INTO tvt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Enoothong neng ten ni lathiin thoih saatang tatongka. Rangte tiit thoidoh phate joonnaam sa doh neng ih laan thiinhaat ruh et ah. ");
INSERT INTO tvt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Rukho mina ah langla raanjih suphook khoni datla likhiik. Rangte tiit abah chaat eha, ");
INSERT INTO tvt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","enoothong arah roidong suh sootsaam nyia changteng ehoon tenthun ih, nyia jaatrep jaatraang tenthun loong ih Rangte tiitkhaap ah matsiit ha, eno hetiik ah tadong tiik thukka. ");
INSERT INTO tvt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Rukho mina rah raanjih hase ni wen arah likhiik. Rangte tiit ah chaat ano, naririh et kap ha, eno hetiik ah dong tiik: rukho ah rookjom, rukho ah rook arok, rukho ah chaasiit.” ");
INSERT INTO tvt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisu ih toombaat ruh ih rumta, “O ih bah uh weetook ah khoowaan mong ni adoleh juptheng khu nah nikah took ah? Weetook ah hethiin theng ni tanih katookka? ");
INSERT INTO tvt_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tumjaat hotthiin abah uh wuungsa nah dongjat ah, nyia ebokloop etta loong ah edaap et ah. ");
INSERT INTO tvt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Boichaat an, sen na je abah ah!” ");
INSERT INTO tvt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jisu ih amah nep ih baat rumta, “Marah chaat han sen ih naririh et samthun an! An ih mih mamet dande hu erah likhiik Rangte eh uh an emamah et dande ho—erah tokkhoh doh uh ehan thong et dande ho. ");
INSERT INTO tvt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Marah mih asuh amasah jeela erah suh ehan ih bootkoh ah, marah mih asuh tumjih uh tajeeka, erah mih dowa amasah jeela rah uh ethoon nge et ah.” ");
INSERT INTO tvt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisu ih jangbaat kaatta, “Rangte Hasong ah arah likhiik. Mih wasiit ih phek ni chamwen kaatla. ");
INSERT INTO tvt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Rangwuung rangnak, heh jup ih koja oh saat ih koja oh, erah pootdi heh champhook ah haapphok ano toon hak ruh ela. Erah bah uh mamangla heh ih tajatka. ");
INSERT INTO tvt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hah heh heh ih hak thuk ano tiik thukla; jaakhothoon wotsuh phang edongla, eno kookchok ehoonla, erah lilih helak ah pa ano dongtiikla. ");
INSERT INTO tvt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Eno cham ah men kano cham khante ah ih khothep ah pi ano cham ah khan kala, tumeah chamkhan tok ah chang kano ah.” ");
INSERT INTO tvt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisu ih chengta, “Rangte Hasong asuh seng ih tumjih likhiik ih li ih?” “Tumjih tiitthaak nawa ih seng ih jangbaat theng ah? ");
INSERT INTO tvt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Erah langla arah likhiik. Mih wasiit ih arah mongrep dowa loongtang nang ih ehinjih thoon miinjaangjih ah toon ano, hah ni wenkaatla. ");
INSERT INTO tvt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Rekam lidi phook ano thoontang nang ih ehanthoon ih dong hakla. Eno hephook loong ah hak ano hephaak loong adi woh loong nep jen tepwang ah.” ");
INSERT INTO tvt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisu ih miloong asuh heh tiitkhaap ah jihoh tiitthaak loong nawa ih emamah ih toobaat rumta; neng ih mathan jen ih samjat rumta erah thanthan ih baattaan rumta ");
INSERT INTO tvt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Heh ih tiitthaak toobaat muh ih tumjih uh tabaat rumta, Enoothong heliphante loong damdi heh luulu ang adi, tumjih suh liita erah hukbaat korumta. ");
INSERT INTO tvt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Erah saasa rangjaako di Jisu ih heliphante loong suh baat rumta, “Seng loong ah juungsitum saangko adoh daan kah ih.” ");
INSERT INTO tvt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Erah thoidi neng ah miloong jiin nawa dokkhoom karumta; eno heliphante loong khoonkhuung ni Jisu bantong kata adi roong duungtong karumta, eno Jisu ah neng damdi waksiit kaat rumta. Khoonkhuung loong ehoh uh erah di eje angta. ");
INSERT INTO tvt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Baphuk ih pong ah pongta, eno khoonkhuung mong adi juung ah waak wang eta, eno khoonkhuung ah juung ih eme nanah eta. ");
INSERT INTO tvt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisu ah khoonkhuung liko adi khodang ah dang ano mokjupta. Heliphante loong ah ih saatsiit rum ano baat rumta, “Nyootte, seng etek taat kah eli ah an ih tanih thun ri?” ");
INSERT INTO tvt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisu ah toonchap ano pong asuh baatta, “Sem uh!” eno juungtak asuh we baatta, “Sem uh!” Erah damdam pong ah laan semruh eta, Pong ah toopong ano, tikpakpak ehoonta. ");
INSERT INTO tvt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Eno Jisu ih heliphante loong asuh liita, “Tume choolan? Amadi sen tuungmaang uh laje ah?” ");
INSERT INTO tvt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Eno neng loong ah rapne ih cho damdi neng chamchi ni roongwaan rumta, “Arah mih ah o angla? Pong nyia juungtak ih nep heh jeng chaatchaat ela ah!” ");
INSERT INTO tvt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisu nyia heliphante loong ah Galili juungsitum saangko Gerasa hadaang ni thok rumta. ");
INSERT INTO tvt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jisu khoonkhuung nawa dat khoom damdam mangbeng luung nawa wangha rah erah di mih wasiit chomuita. Erah mih sak adi chiithih laakhah pan ");
INSERT INTO tvt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","mangbeng ni tongte angta. O eh uh heh ah jaanruh ih takah jen tangkitta; ");
INSERT INTO tvt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","helak helah ah jaanruh ih taat kit rum abah uh helek helek jaanruh ah thahoom leh thaphui, emeleh heh lah ih soopnak kah eta. Heh rapne tathat ang thoidi mih ih tajen tangjota. ");
INSERT INTO tvt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Heh rangwuung rangphe mangbeng theng ni nyia kaanjang ni katum khoomta eno leh tum riinghuung, heh teeteewah jong ih jopkhan. ");
INSERT INTO tvt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jisu japtupta adi heh rekam loot ni angta; eno heh reeni soonkata, heh lakuh di Jisu ngathong adi chooktong kah ano, ");
INSERT INTO tvt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","erongwah ih riinghuungta, “Jisu, Echoong thoon ni tongte Rangte Sah! An ih tumjih ette ang halang? “Rangte mendoh, ngah nak thet haat weehang, ngah ih an lasih johala!” ( ");
INSERT INTO tvt_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Heh ih arah jengkhaap ah Jisu ih “Chiithih laakhah dokkhoom ho ih li kano jengta!”) ");
INSERT INTO tvt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Eno Jisu ih chengta, “An men o ah?” Erah mih rah ih ngaakbaatta, “Nga men ah ‘Ephoop’ —seng ah hantek!” ");
INSERT INTO tvt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Chiithih laakhah loong ah arah juungkhuung dowa nak dokphan weeuh ih heh ih Jisu lasih ah laat joh ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Neng reeni kaanjang adi wak loong jook arah angta. ");
INSERT INTO tvt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Erah thoidi chiithih laakhah loong ah ih Jisu lasih joh rumta, “Wak loong sak adoh kaat thuk weehe.” ");
INSERT INTO tvt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisu ih kaat thuk rum kano, chiithih laakhah loong ah mina sak dowa doksoon ano wak loong sak adi nop karumta. Wak loong ah rooproop ih haajaat nyi taan angta, Erah loong ah thoontang doruk rum ano kaangkom dowa juungsitum adi lupdat karumta. ");
INSERT INTO tvt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wak riimte loong ah erah dowa tiisoon rum ano erah ruurang ah hadaang rookwih nyia phek aphaang rookwih ni tumbaat wanrumta. Mina loong ah ih tumjih ang kola ih sokkah rumta, ");
INSERT INTO tvt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","eno neng Jisu jiinni ra rumha di, chiithih laakhah ephoop pan angta mih ah japtup rumta. Erah mih ah nyuh akhat rapne ne ih kap ano seklilih ih tong arah japtup karumta; eno neng ah echo ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chiithih laakhah pan mih nyia wak loong tupte loong ah ih, mamah angta erah loong tiit ah mih suh tumbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Erah thoidi neng ih Jisu suh neng juungkhuung dowa soon uh ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisu khoonkhuung ni duungtong kata adi maangdi chiithih laakhah pan angta warah ih liita, “An damdoh ngah nep roong ra weehang!” ");
INSERT INTO tvt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Enoothong Jisu ih tawak siitkaatta. Erah nang ih bah, Jisu ih amet baatta, “An nok nah ngaakwang uno an jaatang suh thongbaat wan uh, Teesu ih an raang ih tumjih reeta nyia mathan minchan halu loong rah ah.” ");
INSERT INTO tvt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Erah thoidi erah wah ah Hah Asih adi kah ano Jisu tumjaat reeta loong ah tumbaat kaatta. Erah japchaatte loong ah rapne ih paatja rumta. ");
INSERT INTO tvt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisu ah juungsitum saangko ni we ngaak daan kata. Erah juungsitum kaang adi miloong ah Jisu reeni thutthi rumta. ");
INSERT INTO tvt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jehudi rangsoomnok ni mootkaatte Jairas thok haano Jisu ah japtupta, eno Jisu ngathong ni kotbon kah ano ");
INSERT INTO tvt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","heh lasih ah jota, “Nga sah minusah rah rapne ih satla. An lak ih taajoh ra weeho, de ano ething toom tong we ah!” ");
INSERT INTO tvt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Eno Jisu ah heh damdi roong dokchap kata. Eno miloong ah uh Jisu damdi kookrak ih roong khoom karumta. ");
INSERT INTO tvt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Erah di minuh esiit asih paang nyi heh sih sik ih cham arah angta, ");
INSERT INTO tvt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","heh khoisat ah phonte loong suh noongrep ni taatsok thukta. Heh ngunteh loong ah thoon thaaja, erah bah uh ede lalek ih thang ih saarookwih ehan han ih boot satta. ");
INSERT INTO tvt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Heh ih Jisu raak ah japchaat ano, miloong dung ni heh lilih ih roong kata, ");
INSERT INTO tvt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","heh teeteenuh ih thunta, “Ngah ih Jisu nyuh ah taajoh ang bah, ede eang.” ");
INSERT INTO tvt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Heh ih Jisu nyusah ah taajoh ano, heh sih sik ah laan mah ruh eta; eno heh teenuh ih uh ede elang ih laanjat ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jisu sak nawa khoisat de theng chaan kaat ah laanjat ruh eta, erah thoidi miloong ko ih lengsok ano cheng rumta, “Nga nyuh ah o ih taajoh tahang?” ");
INSERT INTO tvt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Heliphante loong ah ih ngaakbaat rumta, “An ih tup ih hu an reeni mina ephoop tuutmuula eah; mamet cheng hu o ih taajoh halang eah?” ");
INSERT INTO tvt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Enoothong Jisu ih heh taajote ah lengsok ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Eno minuh rah ih heh khoisat deeta rah samthun ano echo damdi wangha no, heh lakuh di tong ano amiisak tiit loong ah dok baatta. ");
INSERT INTO tvt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisu ih erah nuh asuh liita, “Nga sah, an tuungmaang ih deesiit taho. Khooteng ih tongwang uh, an chamnaang nawa ede etu.” ");
INSERT INTO tvt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisu ih erah baat tokdi, Jairas nok nawa ruurang baatte loong wang rum taha eno Jairas suh baat rumta, “An sah bah etek ela. Nyootte ah nak thaam hoom kuh?” ");
INSERT INTO tvt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisu ih neng tiitwaan ah laboichaat thang ih, Jairas suh baatta, “Nakcho uh, tuungmaang ba et uh.” ");
INSERT INTO tvt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Eno Jisu ih ehanko miloong ah tang ano heh damdi Pitar, Jeems nyia heh no Joon ah ba siit kaatta. ");
INSERT INTO tvt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairas nok ni thokrum adi miloong huung ariing nyia neng paattek ah japchaat karumta. ");
INSERT INTO tvt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jisu ah nopwang ano baat rumta, “Tume paatja lan?” “Tume huung lan? Noodek ah etek tah eka—emokjup boh ela!” ");
INSERT INTO tvt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Miloong ah ih Jisu ah ngit et rumta, eno Jisu ih neng loong ah dokphan rum ano, heh nuh nyia heh wah nyia heliphante wajom, noodek jupthiinta nokmong adi nopwang rumta. ");
INSERT INTO tvt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jisu ih noodek lak adi joh ano liita, “Talitha, Koum,” erah langla, “Minusah, saat uh Ngah ih baat hala!” ");
INSERT INTO tvt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Erah damdam minusah ah toonchap ano laan khoom ruh eta. (Noodek ah asih paang nyi angta). Erah angta ah sok rum ano miloong ah rapne ih paatja rumta. ");
INSERT INTO tvt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Enoothong Jisu ih arah tiit ah o suh uh labaat theng ih baat rumta, “Heh suh phaksat thong jam koh an.’ ");
INSERT INTO tvt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Erah hadaang dowa Jisu ah dokkhoom kah ano, heliphante loong heh lilih ih heh hadaang ni roongwang rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jehudi naangtongsa rangwuung adi Jisu ih Jehudi rangsoomnok ni miloong asuh phang nyootsoot rumta, eno miloong ah ih erah chaat rum ano rapne ih paatja rumta; “Heh ih arah likhiik jeng ah ma nawa jen jat ha?” neng ih chengta. “Tumjih mongtham ih jen jatthuk ha? Erah than epaatjaajih mame jen reela? ");
INSERT INTO tvt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Arah bangmaakwah Meeri sah, Jeems, Josep, Judas nyia Simoon loong phoh ah tanih angka? Heh no minusah loong ani tongla ah tanih angka?” Eno neng ih Jisu ah thaangju ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisu ih baat rumta, “Khowah ah langla noongrep nah soomtu ah, enoothong heh hadaang nah heh sano joonte nyia heh jaatang ih ba thaangju ah.” ");
INSERT INTO tvt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Erah di Jisu ih epaatjaatheng tumjih uh tami reeta, khoisatte heh lak ih taajota mararah loong ah ba deeta. ");
INSERT INTO tvt_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Miloong jiinni tuungmaang laje thoidi Jisu ah epaatja eta. Eno Jisu ah mih nok hah loong adi lengkhoom kah ano, nyootsoot karumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Heliphante asih wanyi ah lompoon ano wanyi wanyi et daapkaatta. Neng suh chiithih laakhah loong dokphan suh chaan ah korum ");
INSERT INTO tvt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ano baat rumta, “Erah kah andoh sen sak nah tumjih uh nak hui an, kiingthom luulu ba pi an phaksat uh lahuitheng, kunma khaak uh lahuitheng, sen khaakdaap nah ngun uh lauitheng. ");
INSERT INTO tvt_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sen lakhoop ba khoop an enoothong samsong hedak lahuitheng.” ");
INSERT INTO tvt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jisu ih wakbaat rumta, “Marah nok adoh noppoon han, erah nok adoh erah dowa maang dokkhoom khoom ih tong an. ");
INSERT INTO tvt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sen samnuh nah raahan doh marah doh sen tanoppoon ran nyia sen jeng laboichaat ranbah, sen lah dowa bungwiik ah jaanak anno dokkhoom an. Erah neng raangtaan ih ethih ang ah!” ");
INSERT INTO tvt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","“Erah dowa neng ah dokkhoom karum ano mina ah rangdah nawa lek etheng ih tumbaat kaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Neng ih chiithih laakhah hantek dokphan karumta, eno Olib bangthiing ih hut leh khoisatte hantek deesiit rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Eno Hirod luungwang ih erah ruurang loong ah japchaatta, tumeah Jisu men ah noongrep ni phoongpha rumta. Mararah ih liita, “Juungtemte Joon ah ngaakthingla! Erah thoidi epaatjaajih loong jen re theng chaan ah jeela.” ");
INSERT INTO tvt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Rukho eh liirumta, “Heh Elija.” Rukho eh li rumta, “Heh ah Khowah, teewah dowa khowah loong ah likhiik heh uh esiit.” ");
INSERT INTO tvt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Eno Hirod ih erah japchaat ano liita, “Heh ah Juungtemte Joon ah, ngah ih heh khoh ah thah thuktang ah, heh ah we ngaakthingla!” ");
INSERT INTO tvt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hirod heh teeteewah ih Juungtemte Joon ah jokhak thukta, eno kit ano phaatak ni sak thukta. Hirod ih heh ih kapta Hirodias tungthoidi khak thukta, heh minuh ah langla heh no Philip minuh ang dowa. ");
INSERT INTO tvt_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juungtemte Joon ih Hirod suh banbaat ruh taat kah eta, “An no minuh abah tami kapko eah!” ");
INSERT INTO tvt_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erah thoidi Hirodias ih Joon ah tek haat et suh rapne ih khah ano dongthunta, erah bah uh Hirod tungthoidi tami tek haatta. ");
INSERT INTO tvt_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hirod ah Joon ra echo eta tumeah heh ih jat etta Joon ah mih sek nyia esa moong achaangte angta, rah thoidi Joon ah piita. Hirod ih heh tiitwaan ah chaat rookwih heh thung ah phaangdat eta, ang abah uh heh jeng ah nook boichaat ruh eta. ");
INSERT INTO tvt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lini Joon tek haat suh Hirodias raangtaan saapoot ese thok taha. Hirod tup rangwuung sa di mathan apit nawa saahaap loong ah, Sipaahi saahaap, nyia Galili dowa elong elang loong ah heh tup rangwuung sadung ni poon rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Erah sa adi Hirodias sah minusah ah boongwangta, eno erah sok rum ano Hirod nyia heh wenwah loong ah neng ten rapne ih roon rumta. Erah thoidi luungwang ih erah sah asuh chengta, ‘An tumjih suh nooklu? Ngah dowa tumjaat suh hang erah koha.” ");
INSERT INTO tvt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hirod luungwang ih minusah asuh kakhamta, “Ngah ih kakham hala an ih tumjih jam uh erah koha, ngah ih panhang hadaang thotliiko anep jen koha!” ");
INSERT INTO tvt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Eno minusah ah doksoon kah ano heh nuh suh cheng kaatta, “Ngah ih tumjih suh ang?” “Juungtemte Joon khoh ah suh uh, ih heh nuh ih baatta.” ");
INSERT INTO tvt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Minusah ah echaan ih we ngaak wang ano luungwang dowa suta, amamah ih khuung nah Juungtemte Joon khoh ah kohang!” ");
INSERT INTO tvt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Erah jengkhaap ah chaat ano luungwang ah rapne ih thungthita, ang abah uh heh wenwah loong ngathong ni kakham choi ang thoidi tajen daanta. ");
INSERT INTO tvt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Erah thoidi ra bante loong asuh Joon khoh ah laan thah kah ruh ih thukta. Raabante ah phaatak ni kah ano Joon khoh ah thadook kata; ");
INSERT INTO tvt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","eno minusah asuh khuung ni pi kowanta eno heh nuh asuh toom kota. ");
INSERT INTO tvt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Joon liphante loong ah ih erah chaat rum ano, heh mang ah toonpi wang rum ano beng kaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Heh Kaamwah loong ah Jisu jiinni ngaak chomui wang rum ano, neng ih nyootsootta nyia reeraang karumta loong ah heh suh baatwan rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Erah di miloong ewang ekaatte ephoop ang thoidi Jisu nyia heliphante loong ah neng phaksat saapoot taan uh tachoh rumta. Erah thoidi Jisu ih baat rumta, “Seng hatik nah chomre naangtong kah ih.” ");
INSERT INTO tvt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Eno neng ah khoonkhuung adi duungtong rum ano hatik adi neng kaatkaat ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Erabah uh miloong ah ih neng doksoon ela ih laanjat ruh ih rumta; erah thoidi harep nawa soonkah rum ano Jisu nyia heliphante loong maang thokdi neng lah ih neng ngah ni erah hah di jen banthok ih karumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Khoonkhuung nawa Jisu datchap adi miloong hantek, saapriimte muh saapsah likhiik et sok rum ano heh minchan dongta. Eno heh ih erah miloong asuh jirep tiit loong ah phang nyootsoot rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Rangsa ah tham kano, heliphante loong ah heh reeni wang rum haano baat rumta, “Seng jen tham eli eno arah hah ah hatik ni. ");
INSERT INTO tvt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Miloong ah kaat etthuk uh, neng phaksat ah nokphoh nokno nawa nyia phek aphaang nawa nengneng ih toom jam reh phaksah karum ah.” ");
INSERT INTO tvt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jisu ih ngaakbaat rumta, “Sensen ih neng suh phaksat ah jam koh an.” Neng ih Jisu suh chengta, “Seng ih ngunkholok chaanyi taan ih baanlo ah reh ih no miloong asuh kottheng tam et liihu?” ");
INSERT INTO tvt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Eno Jisu ih cheng rumta, “Sen jiinni baanlo mathan ah? Sokkah an.” Neng ih sokkah rum ano baat rumta, “Baanlo banga nyasi enyi.” ");
INSERT INTO tvt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jisu ih heliphante loong suh baatta, miloong ah naam khoh adoh hedung hedung et tongthuk an. ");
INSERT INTO tvt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Eno miloong ah dungsiit ni chaasiit, dungsiit ni rook banga, ih pheetong thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Eno Jisu ih baanlo banga nyia nyasi enyi ah toonpi ano rangko ih toonsok ano, Rangte suh lakookmi liita. Heh ih baanlo ah chepphiit ano heliphante loong suh koh ano, miloong asuh pheekokaat thuk rumta. Nyasi enyi ah uh emamah loongtang suh pheekoh thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Loongtang ih neng wok laanphoot ruh et phaksah rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Heliphante loong ih asih hongnyi baanlo nyi nyasi dak phaksata rah toon rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Phaksatte miwah loong ah erah di haajaat banga mina angta. ");
INSERT INTO tvt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Erah damdam ih heliphante loong ah khoonkhuung ni duungtong thuk ano juungsitum saangko Betsaida hadaang ko ni, heh ngani ban kaatthuk rumta. Erah pootdi heh ih miloong ah pheekhoom thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Miloong damdi raajeng lidi heteewah ah kongchoong ni rangsoom wangta. ");
INSERT INTO tvt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Rangja ang damdam khoonkhuung ah juungsitum laktung ni angta, Jisu ah heh laklak saang ni angta. ");
INSERT INTO tvt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jisu ih heliphante loong ah pong pong damdi chamthih naangkhah ih khoonkhuung daanjop arah japtup rumta. Rangkhano chichuruh saapoot ejom nyia arok chamchi ni Jisu ah neng jiinko juung khoni khoom kata. Eno neng re ni thokkhoom nanah di, ");
INSERT INTO tvt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jisu juung khoni khoom arah sok rumta. “Erah jook!” Neng ih mokthun rumta, eno toonriing rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Heh ah sok rum ano thoontang cho rumta. Erah damdam Jisu neng damdi waanta, “Sen tenchaan an!” Heh ih baatta “Ngah hanih. Nakcho an!” ");
INSERT INTO tvt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Erah dowa ih neng damdi khoonkhuung ni roong duungtong wangta, eno lakdamdam di pong ah laan semdat ruh eta. Heliphante loong ah rapne ih paatja rumta, ");
INSERT INTO tvt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tumeah neng ih haajaat banga mina suh phaksat jen kota tiit ah tajen samjat rumta; nengthung nengtak ni tali thun rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Neng ih juungsitum ah daan rum ano Genisaret hah adi thok rumta, eno erah di neng khoonkhuung ah tangtuk rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Khoonkhuung nawa dat khoom rum adi, miloong ah ih Jisu ah laanjat ruh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Erah thoidi miloong ah erah juungkhuung rep ni tumsoon rumta; marah di Jisu eje ih japchaat rumta erah di khoisatte loong ah dam khoni thokpi rumta. ");
INSERT INTO tvt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Eno Jisu ah noongrep ni kata, hadaang ni, samthung ni, adoleh phek aphaang ni, eno miloong ah ih khoisatte loong ah thaangtaam theng ni thokpi rumta, eno khoisatte loong ah heh nyuh kaangba adoh taan jap taajoh suh heh lasih joh rumta. Eno mathan ih taajoh rumta loong ah thoontang de ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pharisi nyia Hootthe nyootte loong Jerusalem nawa ra rum taha loong ah Jisu jiinni thok kookchap rum taha. ");
INSERT INTO tvt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Pharisi loong ih Jisu liphante loong mararah ih neng lak enyaan ih phaksah arah jatjoh rumta erah langla neng laktiimuh ih phaksah rumta eno erah ah Pharisi loong ih kah nyoot rumta jun ih tah angta. ( ");
INSERT INTO tvt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pharisi, nyia Jehudi, nok hah ih nengte nengwah ih nyootta banlam ah phan rumta: neng ih laktiimuh ih laphaksat jih, ");
INSERT INTO tvt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","adoleh thaangsang theng nawa tumjaat thok huiha bah uh jaakhoh saachot muh doh tajen phaksata. Erah damdi uh neng ih ephoop teewah banlam loong ah phan rumta, Jengthaak ih lookkep khaplang, khuung akhaak nyia juptheng loong ah uh saachot muh ih tamaak rumta.) ");
INSERT INTO tvt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Erah raangtaan ih Pharisi nyia Hootthe nyootte loong eh Jisu suh cheng rumta, “An liphante loong ih sengte sengwah ih kota banlam ah laphan mamet rumha, neng laktiimuh ih mamet phaksah rumha?” ");
INSERT INTO tvt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisu ih ngaakbaat rumta, “Isaia ih sen loong tiit ah mamet punbaat kota! Heh ih raangthiinta likhiik sen loong ah lonoite: ‘Rangte ih liita, arah miloong eh bah, neng tuikhoop nawa ih soomtu rumhang, amiimi doh bah neng tenthun ah nga jiin nawa haloh dook ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nga rangsoom rumha ah thaangmuh ang ah, tumeah neng eh mina ih hoon arah Hootthe ah nyoot rumha. Nga Hootthe ang arah likhiik ah!’ ");
INSERT INTO tvt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Sen ih Rangte jengdang ah thiinhaat anno mina ih nyootsoot ha ah kap han.” ");
INSERT INTO tvt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jisu ih toombaat ruh etta, “Sen ih Rangte hootthe ah mongwah maakwah tenthun lam ih dut haat han eno sen ih nyootsoot han banlam ah toonjoh han. ");
INSERT INTO tvt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses jengdang ni raangta, ‘Annuh anwah jengkhaap ah echaat etheng,’ erah damdi, ‘O ih heh nuh heh wah suh jengthih jengla erah etek haat etheng.’ ");
INSERT INTO tvt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Enoothong sen ih amet nyoot han, heh nuh heh wah chosok suh tumjih tumjih je abah, heh ih liita ‘Arah Korban’ (erah langla Rangte lakbi), ");
INSERT INTO tvt_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Erah likhiik sen Pharisi loong ah ih sennuh senwah lajap sokboi suh liitan. ");
INSERT INTO tvt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Emamah sen ih wahoh loong asuh ki nyootsoot anno Rangte jengkhaap ah takap thuk kan. Erah damdi uh jaatrep sen ih emamah moong reeraang kah anrah ephoop je ah.” ");
INSERT INTO tvt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Eno Jisu ih miloong ah we lompoon rum ano baatta, “Loongtang ih, nga jeng ah boichaat anno, samjat et an. ");
INSERT INTO tvt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tumjih bah uh sen sak ni rangkhoh nawa wangla rah ih sen ah tanyaan siit ran. Erah nang ih senten senmong nawa ra hala rah ih thong nyaansiit halan.” ");
INSERT INTO tvt_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Sen na je anbah, chaat et an! ");
INSERT INTO tvt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Midung nawa heh nok ni wangta adi, heliphante loong ah ih tiitthaak ah tumjih suh liita rah hukbaat suh cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“Sen ah mihoh loong nang ih jatwah maakwah taboh angkan,” Jisu ih liirumta. “Sen ih tanih samjat kan? Sen sak ni rangkhoh nawa wangla rah ih bah amiimi di tanyaan siit ran, ");
INSERT INTO tvt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tumeah erah sen ten ni tawangka wok ni ba wangla eno ewe ngaakkaat ela.” (Erah jen baat ano Jisu ih jaatrep phaksat ejen phaksah et ah ih dokbaat korumta.) ");
INSERT INTO tvt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Eno Jisu ih boot baat rumta, “Sen ten nawa tumjaat dong ra hala rah ih ba thetsiit halan. ");
INSERT INTO tvt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tumeah sen mong nawa ethih mongtham dong hala rah ih, sen ah jootthih mootkaat ni siit halan, mih put tenthun, etek haat tenthun, ");
INSERT INTO tvt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mih minuh miwah damdoh roomjup tenthun, nyamnyook tenthun, nyia jaatrep ethih loong tenthun; mookwaan mui tenthun, lapun lalam tenthun, miksuk mui tenthun, mih thetbaat tenthun, engaampo tenthun, nyia elang lalang ih reeraang tenthun loong adi siit halan— ");
INSERT INTO tvt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","erah ethih tenthun loong ah sen ten seng mong nawa dong hala eno sen ah enyaan ih hoon thuk halan.” ");
INSERT INTO tvt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Eno Jisu erah dowa dokkhoom ano Tairi samnuthung re ko ih kata. Nok esiit ni heh ah nop wangta eno heh erah di oih uh naktoom jat ah ih thunta, ang abah uh heh tajen hottongta. ");
INSERT INTO tvt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Minuh esiit, heh sah minusah sak ni chiithih laakhah pan ang arah, ih Jisu raak ah chaat ano echaan ih heh lathong ni kotbon kata. ");
INSERT INTO tvt_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Erah nuh rah hahote angta Phonisia deek Siria hadaang ni tup arah ah. Minuh rah ih heh sah sak nawa chiithih laakhah rah dokphan raangtaan ih Jisu lasih ah jota. ");
INSERT INTO tvt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Eno Jisu ih ngaakbaatta, “Jaakhoh noodek asuh phaksat raang kottheng. Noodek phaksat ah nge ano hui suh haatkoh ah tapunka. ");
INSERT INTO tvt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Minuh ah ih ngaak liita, “Chuupha,” “Teebun nawa phaksat thaaja arah botseh hui ih katoon sah ah!” ");
INSERT INTO tvt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Eno Jisu ih minuh asuh liita, “Epun baat et hu, an nok nah ngaak wang uh, an sah sak nawa chiithih laakhah rah doksoon cho tupwang uh!” ");
INSERT INTO tvt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eno erah nuh ah nok ni wang ano heh sah ah juptheng ni jup arah japtup wangta; chiithih laakhah rah heh sak nawa doksoon cho angta. ");
INSERT INTO tvt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Eno Jisu Tairi hadaang re ko nawa dokkhoom ano Sidoon lam ih Galili juungsitum ko ni nyia Samthung Hah Asih ko ih kata. ");
INSERT INTO tvt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Erah di mararah ih Jisu reeni naabaang nyia jengtah ang arah siitjah rum taha, eno Jisu suh an lak ih taajoh weeuh ih heh lasih joh rumta. ");
INSERT INTO tvt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Erah thoidi Jisu ih midung nawa heh laklak ih doksiit kaatta, eno heh laktiik ih heh na adi kepta, heh took ah phoh ano heh tuihih adi taajota. ");
INSERT INTO tvt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Eno Jisu ah rangko ih toonsok ano, thungthet lam ih erah mih asuh liita, “Ephphatha,” erah langla “Laang uh!” ih liita. ");
INSERT INTO tvt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Erah damdam heh na ah laangta, heh jeng uh laangloolo ih miijengta, eno latanyah thang ih waantiitta. ");
INSERT INTO tvt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisu ih erah tiitwaan ah o suh uh nak baat an ih miloong asuh baat rumta; erah bah uh mathan taat haam ah, erah thanthan ih jaawaan karumta. ");
INSERT INTO tvt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","O mina ih japchaatta loong ah rapne ih paatja rumta. “Erathan mame jen re la!” neng ih liita. “Engong nyia naabaang anep jen jeng thuk ha nyia jen chaat thuk ha!” ");
INSERT INTO tvt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Rekam ritdi erah di miloong dunghoh we thok khoon rumta. Nengdi phaksat theng laje thoidi, Jisu ih heliphante loong ah we khoonpoon ano baat rumta, ");
INSERT INTO tvt_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ngah arah mina loong asuh rapne ih thungthih lang, neng nga damdi sa jom roongtong rumhala, erah mong adi neng phaksat ah thoon ela. ");
INSERT INTO tvt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Miloong ah neng nok nah phaksat muh mok ngaakdaap ang bah, lam nah neng lethaap wang rum ah, tumeah rukho ah haloot nawa thok ra rum taha.” ");
INSERT INTO tvt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Heliphante loong ih chengta, seng ih arah than mina asuh arah likhiik woma mong nah ma nawa phaksat ma jen jam koh ih? ");
INSERT INTO tvt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisu ih cheng rumta, “Sen jiinni baanlo mathan ah?” “Lo sinet,” neng ih ngaakbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eno heh ih miloong asuh hah nah pheengtong an ih baat rumta. Heh ih lo sinet baanlo ah toon ano, Rangte suh lakookmi li ano, chepphiitta. Eno heliphante loong asuh pheekokaat thukta. ");
INSERT INTO tvt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Erah damdi nyasi amasah angta nep, Jisu ih lakookmi li ano we pheekoh kaat thukta. ");
INSERT INTO tvt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Warep ih neng wok laanphoot ruh ih phaksah rumta erah di mih ah haajaat baji taan ang rumta. Eno heliphante loong ah ih hong sinet dakta rah lomtoon rumta. Jisu ih miloong ah ngaakkaat thuk rum ano ");
INSERT INTO tvt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","heh uh erah damdam heliphante loong damdi khoonkhuung ni roong dungtong wangta eno Dalmanutha hadaang ko ih karumta. ");
INSERT INTO tvt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mararah Pharisi loong ah Jisu jiinni thokrum ano heh damdi daanmui karumta. Neng ih heh jeng ah mat ih joot suh ih thun rum ano, baat rumta, Rangte ah elang ekah ih jat suh seng suh epaatjaajih ah noisok he. ");
INSERT INTO tvt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Eno Jisu ah ekhat damdi thungthih ano liita, “Ahaangwa mina loong ah ih epaatjaajih ah mamet jam rumha?” Ngah ih baat rumhala! A likhiik mina loong asuh epaatjaajih tanoisok kang!” ");
INSERT INTO tvt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Eno heh neng re nawa dokkhoom ano, khoonkhuung ni ngaak tong wangta eno juung saangko ih daan karumta. ");
INSERT INTO tvt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Heliphante loong ih phaksat ehan et hui ah beehaat et rumta, khoonkhuung ni ang rum adi baanlo lo siit laklak ba dakta. ");
INSERT INTO tvt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","“Naririh ih ban tong an,” Jisu ih dangdang ih baat rumta, “Maama teewah naririh ih ban sok an Pharisi to nyi Hirod dowa pui suh ah.” ");
INSERT INTO tvt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Heliphante loong ah neng jaachi ni phang tuwaan rumta: “Heh ih baanlo lahu koke no baat hali arah ah.” ");
INSERT INTO tvt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisu ih jat etta neng waantiit rumta rah ah, eno heh ih cheng rumta, “Phaksat laje thoih tumte nang waantiit lan? Amadi uh sen ih maang nih jatkan? Sen thungko tam ang lan? ");
INSERT INTO tvt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Sen mik je choidi tatam tupkan? Sen na je choidi uh tatam chaat kan? Tanih jen samthun kan ");
INSERT INTO tvt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ngah ih baanlo banga dowa ih haajaat banga mina suh jen khom kotang rah ah? Sen ih hedak ah hongboot mathan toon tan?” “Asih hongboot nyi,” neng ih ngaakbaatta. ");
INSERT INTO tvt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Erah damdi baanlo sinet dowa reh haajaat baji mina suh kotang adi mathan dakta?” Jisu ih cheng rumta. “Hong sinet” neng ih ngaakbaatta. ");
INSERT INTO tvt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Eno sen ih amadi uh erah maang nih jatkan?” Heh ih cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Neng Betsaida hadaang ni thokrum adi mararah ih mikdook wasiit thoksiit rum taha, eno edook ah taajoh weeuh ih Jisu lasih joh rumta. ");
INSERT INTO tvt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisu ih heh lak ni toonhoom ano erah hadaang dowa doksiit kaatta. Heh mik adi Jisu ih heh took ih phoh ano, heh lak ih taajoh eno chengta, “Amadi japtup tam et hu?” ");
INSERT INTO tvt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eno edook warah ih toonsok ano baatta, “Tup ehang, ngah ih miloong anep tup hang, enoothong samsek latup thang ih bang loong khoomla likhiik et sok hang.” ");
INSERT INTO tvt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Eno Jisu ih heh mik adi we taajota. Erah dowa reh heh mik ah naririh ih ngaak singta, jaatrep wuungsing wuungla et tupta. ");
INSERT INTO tvt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jisu ih heh nok ni amet baat ano wang thukta, “Hadaang adoh nak ngaak wang uh joh.” ");
INSERT INTO tvt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Erah lidi Jisu nyia heliphante loong Kaisaria Philipi hadaang ko loong reeni wang rumta adi lam ni chengwan rumta. “Baat he mih ih Ngah suh o kah ih li rumhang?” ");
INSERT INTO tvt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Neng ih ngaakbaatta, “Rukho ih li halu Juungtemte Joon,” “Rukho ih li halu Elija, rukho ih khowah dung dowa esiit et li halu.” ");
INSERT INTO tvt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Sen ih tumjih li hali?” Jisu ih cheng rumta. “O et liihe ngah suh ah?” Pitar ih ngaakbaatta, “An ah Kristo.” ");
INSERT INTO tvt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Eno Jisu ih baat rumta, “Ngah tiit ah o suh uh nak baat an.” ");
INSERT INTO tvt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Eno Jisu ih heliphante loong asuh phang nyootsoot rumta: “Mina Sah abah rapne ih chamte angla eno mihak phokhoh loong, romwah phokhoh loong nyia Hootthe nyootte loong rah ih thaangju rumte. Heh ah tek haat et rum ah, enoothong sa jom lidoh we ngaakthing eah.” ");
INSERT INTO tvt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Heh ih neng suh samsek et baat korumta. Eno Pitar ih hiiksiit kaat ano Jisu ah kanjaata. ");
INSERT INTO tvt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Enoothong heliphante ko ih leksok ano, Jisu ih Pitar ah we kanjaata, “Soon uh Soitaan,” Heh ih liita. “An tenthun Rangte jiin nawa tah angka mina jiinko nawa!” ");
INSERT INTO tvt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Eno Jisu ih heliphante nyia miloong ah heh jiinni poon rum ano baatta, “Marah mina nga damdoh wangsuh nok lan,” “Erah mina rah ih heteewah ah beehaat etheng, heh tek ra lacho thang ih nga lih phan theng. ");
INSERT INTO tvt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tumeah senteewah roidong piipang suh thun anbah, sen emat haat et an; enoothong sen roidong ah nga raangtaan nyia ruurang ese raang ih mat haat anbah epui ean. ");
INSERT INTO tvt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mina ih mongrep hadaang adoh jaatrep ah kapjap ano, heh roidong ah maat haat abah tumjih choh ah? Tumjih uh tachoka! ");
INSERT INTO tvt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Heh roidong ngaakchosuh heh ih kottheng tumjih uh tajeeka. ");
INSERT INTO tvt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","O mina ngah suh nyia ngah ih nyootsoot hang asuh erakri ela arah rangkuh thih nyia Rangte lajat hadaang adi ah, erah ang abah Mina Sah rah uh Heh wah chaan aphaan nyia toongtang rangsah loong damdoh raaha doh erah mih ah raangtaan ih rakri eah.” ");
INSERT INTO tvt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Eno we boot baat rumta, “Ngah ih baat rumhala, Rangte Hasong chaan aphaan lam ih raaha ah maang japtup ngah khoh nah arah dowa rukho ah maang tekte eje ang an.” ");
INSERT INTO tvt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sa arok lini Jisu ih Pitar, Jeems nyia Joon ah siit ano, kongchoong ni neng luulu wang rumta. Neng miksok di Jisu, ah choocho ih lek arah sok rumta, ");
INSERT INTO tvt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","henyuh hekhat ah pungkoopkoop ih dong phaakta erah than ih puungta o eh uh arah hatoh adoh erathan tajen puung chotka. ");
INSERT INTO tvt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Erah lilih heliphante wajom ih Elija nyi Moses Jisu damdi waan arah japtup rumta. ");
INSERT INTO tvt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pitar ih Jisu suh baatta, “Nyootte, tumthan ese ah seng aani ang ih no ah! Seng ih nyutaap ejom than buk ih, esiit ah an raangtaan, esiit ah Elija raangtaan, esiit Moses raangtaan.” ");
INSERT INTO tvt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pitar nyia wahoh loong ah rapne ih cho rum ano Pitar ah mame jeng suh uh taseeta. ");
INSERT INTO tvt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Erah lilih jiingmuung ih neng loong ah loopjota, eno jiingmuung mong ni dongjeng ra taha, “Arah ngah di nga mongnook Sah miimi—heh jengkhaap chaat an!” ");
INSERT INTO tvt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Neng ih seek taat lengsok rum adi, o uh tajeeta; Neng damdi Jisu chap arah laklak tup rumta. ");
INSERT INTO tvt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Neng kong ni dat ra rumha di Jisu ih baat rumta, “O suh uh nak baat an sen ih tumjaat tuptan rah ah, mina sah tek nawa maang ngaaksaatka ngakhoh nah ah.” ");
INSERT INTO tvt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Neng ih heh jeng ah thang et rumta, ang abah uh neng chamchi ni bah erah tiit ah waan ruh ih rumta, “‘Tek nawa ngaaksaat’ ah tumjih suh liita?” ");
INSERT INTO tvt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Eno neng ih Jisu suh chengta, “Hootthe nyootte loong ih Elija jaakhoh raaha ih tumet suh liita?” ");
INSERT INTO tvt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jisu ih ngaak baatta, “Elang eah jaakhoh Elija aju raaha, jaatrep ban khookham raang ih ah. Enoothong Rangteele ni tumet suh liita Mina Sah ah rapne ih cham ah thaangju nep et rum ah eah? ");
INSERT INTO tvt_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nga ih baat rumhala, Elija ah jen ra ih taha eno mina loong ah ih neng ih mamet thunta erah jun ju re rumta, heh tiit ah Rangteele ni raangha likhiik ah.” ");
INSERT INTO tvt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Neng heliphante rukho loong ah damdi chokhoom wang rum adi, miloong hantek ih kookchap rum ano Hootthe nyootte loong damdi daanmu rum arah japtup rumta. ");
INSERT INTO tvt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Miloong ah ih Jisu ah tup rum ano paatja rumta, eno heh reeni soonkah rum ano jengseera rumta. ");
INSERT INTO tvt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisu ih heliphante loong suh cheng rumta, “Tumjih tungdi neng damdi daanmui lan?” ");
INSERT INTO tvt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mih dung ni wasiit ngaakjengta, “Nyootte, ngah ih an jiinni nga sah chiithih laakhah pan, heh jeng nep mah arah siitkaat halang. ");
INSERT INTO tvt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Chiithih laakhah pat adi heh teewah ah hah ni loongdat ano heh tui nawa tookwu ah dong, heh pha ah chektat ano kah laatdat ah, erah raang ih an liphante loong suh chiithih laakhah taat dokphan thuktang, eno tajen dok phan rumta.” ");
INSERT INTO tvt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisu ih liirumta, “Mamah lajen hanpi ehan mina sen loong ih ah! Ngah sen damdoh jaatjaat mathan ma jen roong tonghang? Ngah sen damdam mathan ma jen reehang? Noodek ah nga jiinnah siitwan han!” ");
INSERT INTO tvt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eno Jisu jiinni siitwan rumta. Erah damdam laathih rah ih Jisu ah tup ano, noodek ah hah ni loonghaat ano laatdat thukta, eno lengkoong ano heh tui ni tookwu loong ah dong eta. ");
INSERT INTO tvt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisu ih heh wah asuh chengta, “Arah likhiik ih sa mathan dowa ih angla?” “Noodek dowa ih dook,” heh warah ih ngaak baatta. ");
INSERT INTO tvt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Chiithih laakhah rah ih helek helek we nyia juung ni tek haat suh taatwoot chung ha. Minchan ih weehe, an tenthet nawa ih jen lang abah ah!” ");
INSERT INTO tvt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisu ih heh wah suh liita, “An teeteewah ih jen lang eah ih liihu bah ah! Tuungmaang ete raang ih bah jaatrep ejen lang eah.” ");
INSERT INTO tvt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Erah damdam heh wah ah huung ano jengta, “Ngah etuungmaang elang, enoothong ehan tajen tuungmaang kang. Ehan ih tuungmaang suh chosok weehang!” ");
INSERT INTO tvt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisu ih miloong tukhoom ah sok ano, chiithih laakhah asuh baatta. “Engong nyia ebaang chiiala” “Nga ih an suh baat hala arah noodek sak dowa dokkhoom hoono babah uh nak kah ngaak wang uh!” ");
INSERT INTO tvt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chiithih laakhah ah riinghuung ano noodek ah loonghaat thiinta, eno that that ih moh tekthuk ano heh ah doksoon kata. Noodek ah tekmang likhiik ih hoonta, eno warep ih liita, “Etek ela abah ah!” ");
INSERT INTO tvt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Eno Jisu ih noodek ah heh lak ih toonhoom ano chap thukta. ");
INSERT INTO tvt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jisu nokmong ni nopkhoom adi heliphante loong ih hucheng rumta, “Seng ih laathih ah mamah lajen dokphan eti?” ");
INSERT INTO tvt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisu ih baat rumta; “Aa likhiik chiithih laakhah ah rangsoom nawa luulu ih ba jen dokphan ah,” “Jaat hoh tumjih nawa reh uh tajenka.” ");
INSERT INTO tvt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisu nyia heliphante loong erah dowa Galili hadaang lam ih wang rumta. Jisu ih heteewah maani ah ih wahoh suh tajat thukta, ");
INSERT INTO tvt_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tumeah heliphante loong suh tiitwaan nyootsoot rumta; “Mina Sah rah mih lak nah tek haat et suh jokoh rum ah. Enoothong sa jom lih nah, we ngaakthing eah.” ");
INSERT INTO tvt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Erah jengkhaap nyootta rah heliphante loong ih tumjih suh liita ih tasamjat rumta, heh suh huk cheng ra uh echo ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Neng Keparnam hadaang ni thokrum taha, eno nokmong ni nop rumta lidi Jisu ih heliphante loong suh chengta, “Sen loong lam ni tumjih tungdi daanmui tan?” ");
INSERT INTO tvt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Neng ih tangaak baat rumta, tumeah neng chamchiini lam ni elongthoon ah o ah erah tiit tungdi daanmui rumta. ");
INSERT INTO tvt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisu ah tong ano asih wanyi heliphante loong ah poon rum ano baat rumta, “O ih phangkhothoon angsuh nook an erah lithoon nah angtheng eno heh ah loongtang laksuh angjih.” ");
INSERT INTO tvt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Eno heh ih noodek wasiit neng loong ngathong ni chap thukta. Heh lak ih khonjoh ano baat rumta, ");
INSERT INTO tvt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Oih arah noodek loong ah nga mendoh noppoon an, erah ih ngah poon halang; eno oih ngah noppoon halang, erah ih nga laklak tanoppoon rang, nga daapjatte ah anep wak noppoonha.” ");
INSERT INTO tvt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Joon ih heh suh baatta, “Nyootte, seng ih an mendi mih wasiit ih chiithih laakhah loong ah dokphan arah japtupti eno tanghaamti, tumeah heh sengjoon tah angta.” ");
INSERT INTO tvt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","“Nakmok tanghaam an,” Jisu ih baat rumta, tumeah o mina ih nga mendoh epaatjaajih loong ah jen re abah, liwang nah erah mina rah nga miksukte tah angka ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","O mina seng miksukte tah angka loong ah seng raangtaan ih ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ngah ih ami tiit baat rumhala, nga mina angkan no o ih sen suh juung jok thuk han erah mih ah amiisak heh thaang ah choh ah. ");
INSERT INTO tvt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Arah noodek loong ah ih ngah suh hanpi rum halang ah oih bah uh mok thetsiit rum ah, erah mina rah heh boh adoh jong ah bonchi ano juungsih nah mah abah ese ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Erah raang ih sen lak ih sen tuungmaang ah matsiit abah, thadook haat et an! Lak hop mabah uh lametka we adoh roitang ih khaamwang nang ih bah lakko ih mabah uh lathoon roidong adoh chowang ah ese ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Erah nah ‘neng phakte soot ah babah uh tatiika, nyia neng khaam theng we ah babah uh tametka ang ah.’ ");
INSERT INTO tvt_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Sen lah ih sen tuungmaang ah mok matsiit abah, thadook haat et an! Lah hop roitang we nah khaamwang nang ih bah lah ko lathoonka roidong adoh chowang ah ese ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Erah nah ‘neng phakte soot ah babah uh tatiika, nyia neng khaam theng we ah babah uh tametka ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Erah damdi sen mik ih dah thuk halan bah, doklot haat et an! Rangmong Hasong nah mikko ih wang ah ese ang ah mik hop ih roitang we nah khaamwang nang ih bah ah. ");
INSERT INTO tvt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Erah ni, ‘Neng phakte soot ah babah uh tatiika nyia neng khaam theng we ah babah uh tametka ang ah.’ ");
INSERT INTO tvt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Mireprep ah we nawa ih saasook ah sum ih siik hoon theng saasiit arah likhiik ah. ");
INSERT INTO tvt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sum ah ese; enoothong sumwaan ah sa abah, sen ih mamah we ih miingaak sumthuk an? “Joonte damdoh sum likhiik angtheng, eno warep damdoh semroongroong in songtong theng.” ");
INSERT INTO tvt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","“Eno Jisu erah hah dowa dokkhoom ano, Judia hah ko ni Jordan Juung ah daan wanta. Erah di miloong ephoop thok taha, eno heh ih saahoh di kanyoot arah likhiik ih we nyootsoot rumta. ");
INSERT INTO tvt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mararah Pharisi loong heh jiinni thokrum haano heh jeng matjoot suh chung rumta. “Seng suh baat he,” “Seng hootthe jun ih miwah ih heh minuh jen haat nih et ah?” ");
INSERT INTO tvt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisu ih cheng damdi ngaakbaatta, “Moses ih tumjaat Hootthe baat tahan?” ");
INSERT INTO tvt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Neng ih ngaakbaat rumta, “Moses ih bah miwah suh epaak leeraang ah raangkoh ano sen sanuh ah ejen haat et an ih baatta.” ");
INSERT INTO tvt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisu ih neng suh baatta, “Sen suh nyootsoot ah jong ajaan likhiik angkan no Moses ih erah Hootthe ah raangkoh tahan.” ");
INSERT INTO tvt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Enoothong haphangsong di, edongsiit saapoot di, ‘Rangte ih minuh miwah dong hoonta, ‘Rangteele ni liiha likhiik ah. ");
INSERT INTO tvt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Erah thoidi miwah rah ih heh nuh heh wah ah thiinhaat ano heh sanuh damdoh roomsong ah, ");
INSERT INTO tvt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","eno enyi ah esiit ih hoon ah.’ Erah thoidi nengnyi ah wanyi takah angka, esiit ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Erah raangtaan ih Rangte ih chosit ha ah, mina lajaatjaat paak haat theng.” ");
INSERT INTO tvt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Neng loong ah nok ni ngaak wang rum adi, heliphante loong ih erah tiit ah huk cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jisu ih ngaakbaat rumta, “O ih bah uh heh minuh ah haat ano nuhoh we kap abah, heh ah roomjup rangdah ah dah ah.” ");
INSERT INTO tvt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Erah likhiik, minuh ih miwah ah haat ano wahoh damdoh we nook abah eroomjup rangdah ah dah ah.” ");
INSERT INTO tvt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mararah miloong ah ih Jisu reeni noodek loong ah heh lak ih taajoh ano romseetam kot suh thoksiit rumta, eno heliphante loong ih kanja et rumta. ");
INSERT INTO tvt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisu ih erah kanja rumta ah jat ano, heliphante loong asuh ekhat eta eno baat rumta, “Noodek loong ah nga re nah toom wang rumha, sen ih nak tanghaam an, tumeah Rangte Hasong ah arah noodek loong likhiik raangtaan ih. ");
INSERT INTO tvt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ngah ih ami tiit baat rumhala, o mina arah noodek loong likhiik lah angko bah Rangte Hasong nah tachoh wang ko.” ");
INSERT INTO tvt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Eno noodek loong ah heh lak ni toonpi rum ano romseetam korumta. ");
INSERT INTO tvt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisu hahoh ni kaat suh we dokchap adi, mih wasiit soon ra haano heh lakuh di tong ano chengta, “Ese et Nyootte, mabah uh lathoonka roidong ah chosuh ngah ih tumjih et ang?” ");
INSERT INTO tvt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Ngah suh ese ih tumjih suh li halang?” Jisu ih chengta. “O uh ese tajeeka Rangte luulu ba ese ah. ");
INSERT INTO tvt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","An ih Rangte jengdang ah jat ehu: ‘mih latek haat theng; an minuh nyia an miwah lah angka bah mih damdoh nak roomjup theng; mih hot lahuh theng; mih lathika doh lanan theng; mih lamokwaan theng; nuh awah jeng chaat etheng.’” ");
INSERT INTO tvt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Erah wah rah ih liita “Nyootte,” “Erah loong jengdang abah ngah ih noodek dowa ih dook chaat jah halang.” ");
INSERT INTO tvt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Eno Jisu ih hetaangko ramram ih sok ano minchan lam ih baatta, “Andi jaatsiit boot reejih jeela. An nyamka loong ah sangkaat uno ngun ah changthih loong asuh pheekoh uh, eno an ah rangmong nah changteng ang uh, erah lidoh ba nga lih phanhang.” ");
INSERT INTO tvt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jisu jeng ah chaat ano, erah wah rah heh thungjoong ih heh the ah saanghaat ano dokkhoom kata, tumeah heh changteng angta. ");
INSERT INTO tvt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisu ih heliphante loong kooni lengsok ano baatta, “tumthan echaan ah changteng loong ah Rangte Hasong nah jen wangsuh ah!” ");
INSERT INTO tvt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Heliphante loong ah Jisu jengkhaap suh rapne ih paatja rumta, eno Jisu ih we baat rumta, “Ngaasuh ngaasah loong, Rangte Hasong nah chowang tumthan echaan ang ah! ");
INSERT INTO tvt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Changteng mina Rangte Hasong nah jen wang nang ih bah mikkaan po na mokchongdoot ba laan jen nopwang ah.” ");
INSERT INTO tvt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Erah tiit ah chaat rum ano heliphante loong ah rapne ih paatja rumta eno neng cheng chengmui ih rumta, “erah ang abah, o ah jen pui ah?” ");
INSERT INTO tvt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Heliphante loong taangko ih sok ano Jisu ih baatta, “Mina raangtaan ih bah erah echaan, enoothong Rangte di bah tachaanka; jaatrep ah Rangte raangtaan ebah elaang.” ");
INSERT INTO tvt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Eno Pitar dongjengta, “Sok uh, seng ih jaatrep thiinhaat eno an lih phanhi.” ");
INSERT INTO tvt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Um,” Jisu ih liita, “Ngah ih baat rumhala, o mina ih amadoh henok hetap, henuh hewah, hephoh, henah, hesuh, hesah nyi hephek hephaang ah nga raang ih nyia Ruurang Ese raang ih ahaangwa rangkuh adoh thiinhaat abah, ");
INSERT INTO tvt_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","heh suh romseetam ah amah dowa nang ih uh ehan ih choh ah. Henok hetap, hephoh, henah, henuh, heh sah, nyia hephek hephaang ah chaasiit nang ih ehan choh ah—nga raangtaan ih siiwi chamnaang et ah; erah damdoh heh lakngah nah babah uh lathoonka roidong ah choh ah. ");
INSERT INTO tvt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Enoothong mina loong amadi elong elang angla loong ah liwang nah ehin ih hoon ah, eno amadi ehin angla loong ah elong ih hoon ah.” ");
INSERT INTO tvt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisu nyi heliphante loong lam ni Jirusalem ni chookwang rum adi, Jisu ah neng ngah ni bankhoom wang ano, heliphante loong ah paatja ih rumta; heh lini phan khoomte miloong ah echo erumta. Eno Jisu ih heliphante loong ah hiiksiit ano heh tumjih angte angla erah tiit we baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Boichaat an,” Heh ih baat rumta, “Seng Jerusalem ni wangli adoh Mina Sah rah romwah phokhoh nyi Hootthe nyootte loong suh baat korum ah. Neng ih heh ah tek ejih et kaanju dut haat rum ah eno Ranglajatte loong suh baat korum ah, ");
INSERT INTO tvt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","neng ih chikram ngitkhuung et rum ah, ebot ih rum ah, neng took ah ih took rum ah, ruh ih buh rum ano tek haat rum ah; enoothong sa jom lidoh heh ah ewe ngaakthing eah.” ");
INSERT INTO tvt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Eno Jebedi sah Jeems nyia Joon, Jisu reeni ra taha. “Nyootte,” nyi ih liita, “Sek ih an suh tiit esiit sek suh reekotjih cheng suh liihiitih.” ");
INSERT INTO tvt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Tumjih ah?” Jisu ih chengta. ");
INSERT INTO tvt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nyi ih baatta, “Phaakjaaja Hasong adoh luungwang tongtheng nah tongwang uh doh, sek uh an damdoh waktong thuk we heetih, wasiit ah an dak hekko wasiit ah an jaawah ko ah.” ");
INSERT INTO tvt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisu ih we baat nyuuta, “Set ih tajat kansih tumjih suh hansih rah ah. Set ih ngah ih jok theng chamnaang lookkep dowa ejen jok nih et ansih? Nga juungtem ang rah likhiik ejen tem nih eh ansih?” ");
INSERT INTO tvt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Jen tem ettih,” nyi ih ngaakbaatta. Eno Jisu ih baat nyuuta, “Elang eah set ih nga chamnaang lookkep adoh ejen jok mok ih ansih nyia nga juungtem theng adoh ejen tem mok eh ansih. ");
INSERT INTO tvt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Enoothong nga ih set dak hek jaawah ko adoh o tong ah erah tajen dan baat nyuura. Erah Rangte ih jat ah, o mina raang ih ban hoonta nyia o suh kottheng rah ah.” ");
INSERT INTO tvt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Heliphante wah asih loong ah ih erah chaat rum ano Jeems nyi Joon suh ekhat erumta. ");
INSERT INTO tvt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Eno Jisu ih heliphante loongtang lompoon rum ano baat rumta, “Jehudi lah angka loong adi neng phansiite loong ah eje. Sen ih jat ehan erah phansiite loong ah ih nengchaan nengphaan ah mina loong asuh noisok suh nook rumla, nyia neng phansiite loong ah ih nengchaan nengphaan ah maak suh nook rumla. ");
INSERT INTO tvt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Enoothong erah likhiik bah sen loong chamchi nah nak angtheng. Sengdung dowa o ih bah uh elong angsuh nook anbah, sen wahoh loong laksuh jaatjaat chaak angjih; ");
INSERT INTO tvt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","nyia o bah uh ngakhoh angsuh nook anbah, sen ah loongtang dah jaatjaat chaak ang jih. ");
INSERT INTO tvt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mina Sah ah botseh mih suh mootthuk suh tara taha; erah nang ih mih raangtaan ih moh suh ra taha nyia mina loong ah puipang suh heh roidong ah kota.” ");
INSERT INTO tvt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Neng Jeriko hadaang ni thok rumta, eno Jisu nyia heliphante erah dam ih miloong ah dokkhoom rum adi, edook kunma heh men ah Bartimas Timas sah lamkaang ni tong ano ban thaang phaksata. ");
INSERT INTO tvt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Najaret nawa Jisu ra hala ih chaat ano, riing poonta, “Jisu! Dewid sah, ngah minchan ih weehang!” ");
INSERT INTO tvt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Miloong ih edook ah kanja rum ano nak hoopti uh ih baat rumta. Eno heh ah erong ih we huk riingta, “Dewid sah, ngah minchan weehang!” ");
INSERT INTO tvt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisu tangchap ano baat rumta, “Poon wanhan.” Eno neng ih mikdook warah poon rumta, “Eroon eh uba, an poon halu.” ");
INSERT INTO tvt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Heh nyusah ah khook buhaat ano Jisu jiinni toonpit wang taha. ");
INSERT INTO tvt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisu ih chengta, “Nga ih an suh tumjih jen re koha ih liihu?” Mikdook warah ih liita, “Nyootte,” “Nga mik ah we ngaaksing thuk weehang.” ");
INSERT INTO tvt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisu ih baatta, “Kah uh,” “An tuungmaang jun ih deelu.” Lakdamdam ih heh ih laantup ruh eta eno lam ni Jisu lilih ih roongphan khoomta. ");
INSERT INTO tvt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Betpheej nyia Bithani hadaang reeni Jerusalem thok nanah ih rum adi, neng loong ah Olip Kong adi wang rumta. Eno Jisu ih heliphante dowa wanyi ah jaakhoh ih ban kaat thukta ");
INSERT INTO tvt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","amet baat nyu ano ah, “Set ngah ni hadaang esiit je ah erah doh kah ansih, erah di moktoh sah bonthiin arah japtup kah ansih babah uh o ih lathaak siitka rah ah. Ja ansih no nga re nah siitwan hansih. ");
INSERT INTO tvt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mih ih tumet suh ja hansih ih cheng hansih bah, Changte wah ih liita belam seek we ih ngaak siitwan he ih baat ansih.” ");
INSERT INTO tvt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Eno kah nyu ano moktoh sah ah lam ni nok esiit ni kaawan thong ni bonthiin arah japtup kah nyuuta. Erah ja nyu adi, ");
INSERT INTO tvt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nyi reeni chapta miloong dowa mararah ih cheng rumta, “Moktoh sah ah tumet suh ja hansih?” ");
INSERT INTO tvt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Eno nyi ih Jisu ih mamet baatta erah jun ih ngaakbaat nyu kano miloong ah ih moktoh sah ah hoom wanthuk nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Eno Jisu reeni thok hoom wannyu ano, moktoh sah sakkhoh adi neng nyusah loong ah dekoh rum ano, Jisu ah duungtongta. ");
INSERT INTO tvt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Miloong ah ih neng nyusah loong ah lam adi ban dam wanrumta, rukho rah ih bangphaak ah phek dowa dook rum leh lam ni dam et rumta. ");
INSERT INTO tvt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Heh lih heh ngah ni khoomte miloong ah riing rumta, “Rangte rangphoong ih! Teesu mendi raakte loong asuh Rangte ih romseetam koh ah. ");
INSERT INTO tvt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Seng loong wah Dewid luungwang hasong thok hala asuh Rangte romseetam ah je ah! Rangte rangphoong ih!” ");
INSERT INTO tvt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisu Jerusalem ni thok ano Rangteenok ni wangta, erah di heh ih jaatrep ah sok wangta. Enoothong rangsa jen tham ih kaat kano, heliphante asih wanyi damdi Bithani ni kata. ");
INSERT INTO tvt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Erah saalih adi, Bithani nawa ngaak wang rum adi, Jisu heh ram ih tiita. ");
INSERT INTO tvt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Heh ih rekam loot nawa ih puksak lak loong ah japtup ano, hetiik ah taatsok kata. Eno sokkah ano, hetiik tiiktok lah ang thoidi heh lak luulu japtup kata. ");
INSERT INTO tvt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Eno Jisu ih puksak bang asuh liita, “O ih uh an tiik ah mabah uh naktoom kah we choh sah ho!” Erah jengta ah heliphante ih nep japchaatta. ");
INSERT INTO tvt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Neng Jerusalem ni thokrum ano, Jisu ah Rangteenok ni wangta, erah di thaangsangte nyi thaang riikte loong ah phang dokphan wang rumta. Neng ngun lek theng teebun nyia tokparu sangte tongtheng loong ah daanghaat et wangta. ");
INSERT INTO tvt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Eno heh ih O suh uh Rangteenok taakkhuung lam ih tumjih uh taleng hu thukta. ");
INSERT INTO tvt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Erah lih adi heh ih miloong asuh nyoot rumta, “Rangteele ni raangha, ‘Nga Rangteenok ah deek akaan rep raangtaan ih rangsoomnok et men ah.’ Enoothong sen ih ehuh loong hottong theng ih hoon han!” ");
INSERT INTO tvt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Romwah phokhoh nyi Hootthe nyootte loong ah ih erah tiit ah japchaat rum ano Jisu tek haat suh lampo phang jam rumta. Neng ah heh ra echo ih rumta tumeah mina loong suh epaatjaajih ih nyootsoot rum kano ah. ");
INSERT INTO tvt_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Rangjaako ih Jisu nyia heliphante loong ah erah samnuthung dowa dokkhoom ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Erah saalih rangkhah di neng lam ni khoom rum adi, satkom bang ah heh hingtuk ih hook arah japtup rumta. ");
INSERT INTO tvt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pitar ih tumjih angta rah dokthun ano Jisu suh baatta, “Nyootte, sok uh, an ih tamtu satkom bang ah ehook ela!” ");
INSERT INTO tvt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisu ih ngaakbaatta, “Rangte suh tuungmaang an.” ");
INSERT INTO tvt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ngah ih amiisak tiit baat rumhala o mina heh ten nah mongchi lah angthang ih hanpi ano arah kong akaan asuh toonchap uno juungsih adoh rukdat kah uh ih baat abah uh amiisak elang eah, enoothong tumjih suh an erah suh hanpi et ano ba jen lang ah. ");
INSERT INTO tvt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Erah raangtaan ih ngah ih sen suh baat rumhala: sen ih rangsoom lam ih tumjaat suh an, erah echoh etang ih hanpi an, eno ba sen ih tumjih suh an erah kohan. ");
INSERT INTO tvt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Erah dam ih maatok doh sen ih rangsoom suh toonchap an, sen miksukte o ang abah uh erah loong ah biin anaan chaak hoon an, erah doh ba rangmong nawa sen Wah ih sen thetre loong ah biin anaan han.” ");
INSERT INTO tvt_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Sen ih mihoh ah lajen biin anaan kanbah, Rangmong nawa sen Wah eh uh sen ah tajen biin anaan ran. ");
INSERT INTO tvt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Neng Jerusalem ni we thok rumta. Jisu Rangteenok ni lengkhoom adi, erah nawa romwah phokhoh loong, Hootthe nyootte nyia mihak phokhoh loong ah heh jiinni ra rumha no, ");
INSERT INTO tvt_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","cheng rumta, “Arah mamah jen reelu? An jen reejih o ih koh taho?” ");
INSERT INTO tvt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisu ih ngaakbaat rumta, “Ngah ih sen suh esiit than jengkhaap cheng rumha, erah ngaakbaat kohe no ba, ngah ih tumjih chaan nawa ih jen reelang loong ah baat korumha. ");
INSERT INTO tvt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jisu ih liita, baat an, Joon ih juungtem theng chaan ah ma nawa chota: Rangte jiin nawa tama mina jiin nawa chota?” ");
INSERT INTO tvt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Eno neng jaachi ni phang daanmui rumta, “Tumjih baat ih? ‘Rangte jiin nawa,’ mok et baat ih bah, heh ih liihe, erah ang abah ‘Joon ah tanih hanpi kan’ ");
INSERT INTO tvt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Eno, ‘Mina jiin nawa mok baat ih bah...’” (Neng ah miloong ra cho rumta tumeah Joon ah khowah ih loongtang ih jatcho angta.) ");
INSERT INTO tvt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Erah raangtaan ih Jisu suh, “Seng ih tajatke,” ih ngaakbaat rumta. Eno Jisu ih baat rumta, erah ang abah, “Ngah ih uh arah loong ah mame jen reelang erah tabaat rumra.” ");
INSERT INTO tvt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Eno Jisu ih tiitthaak loong ah baat lam ih li rumta: “Teewah di wasiit phek changte wah reh heh phek ni potiik phook loong ah ki ano, pa ih kookpaata, potiik jittheng haluung ah thoh ano bante tongtheng nok echoongwah ih hoon thiinta. Eno erah phek ah phekphoop phekte suh kothiin ano heh hahoh ni kata. ");
INSERT INTO tvt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Potiik hu tok ah thok kohaano phekphoopte jiinni heh dah wasiit daap wanta, heh chotheng thaang ah suk suh ah. ");
INSERT INTO tvt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Phekphoop phekte loong rah ih dah ah joh buh rum ano hahuung ngaak daapta. ");
INSERT INTO tvt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Erah lih adi changte wah ih dah wahoh we wang thukta; eno phekphoop phekte loong ih hekhoh adi buh rum ano heh rakri laandong ruh ih li wanrumta. ");
INSERT INTO tvt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Erah lidi changte wah ah ih dah wahoh daap wanta, eno erah ah tek haat ih rumta, emamah ih wahoh uh ephoop tek haat rumta rukho ah bot et rumta rukho ah tek haat et rumta. ");
INSERT INTO tvt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Phek changte wah adi ewangthuk etheng ah heh mongnook sah ah luulu ba dak tongta. Hethoondi heh sah ah phekphoop phekte loong jiinni daap wanta. ‘Ngah ih jat et hang nga sah abah soongraang et rum ah,’ changte wah ih thunta. ");
INSERT INTO tvt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Enoothong phekphoopte loong ah neng chamchi ni waan rumta, ‘Arah tang ah changte sah. Raahan tekbuh ih no heh nyamka ah seng doh toom ih hoon ah!’ ");
INSERT INTO tvt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eno heh sah ah joh rum ano tekbuh rum ano heh mang ah phaakkhuh ni haat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Erah ang abah phekphoopte loong ah changte wah ih tumjih et ah?” Jisu ih chengta. “Heh ah wangha no phekphoop phekte loong ah tekbuh ano wahoh suh lawe phek thuk ja. ");
INSERT INTO tvt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Sen ih Rangteele ni raangha amiimi ewet tam etan? ‘Nok hoonte ih jaakhoni jong taseeka ih chiik haatta jong ah loongtang nang ih ekapjih ese thoon jong ih hoonla. ");
INSERT INTO tvt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Erah Teesu ih hoonta; Tumthan epaatja theng sokjih ah!’” ");
INSERT INTO tvt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Eno Jehudi mihak phokhoh loong ih heh jootkhak suh chung rumta, tumeah neng ih jat et rumta erah tiitthaak ah neng teewah di nyoot baatta. Enoothong mih luulu ang kano neng ah echo ih rum ano matsoon rumta. ");
INSERT INTO tvt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mararah Pharisi nok hah nyia Hirod mina loong Jisu reeni heh jengthet matjoot suh daapkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jisu reeni thokrum ano cheng rumta, “Nyootte, seng ih jat et hi an ih ami tiit ju baat hu, mina ih thunha asuh lasootsaam thang ah. An ih mina ehin elong lathaam sok thang ih, Rangte ih ami tiit nyoot ha erah jun ju baat hu. Erah raang ih seng suh baat he, Roman luungwanglong asuh sokse kohi rah seng Hootthe ni eje tam tajeeka? Seng ih ekot tam takoke?” ");
INSERT INTO tvt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Enoothong Jisu ih, nga matjoot suh cheng rum halang ih jat ano, ngaakbaat rumta, “Sen ih nga matjoot tumet suh thunhan? Ngunkholok ah piijah han, ngah ih sokthaak ang.” ");
INSERT INTO tvt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Neng ih ngunkholok esiit piikaat rumta, eno heh ih cheng rumta, “Arah othe okhoh ah nyia omen ah?” “Luungwanglong the akhoh,” et baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Eno Jisu ih baat rumta, “Ese eno bah Luungwanglong chojih ah Luungwanglong suh koh an, Rangte chojih ah Rangte suh koh an.” Eno Jisu suh rapne ih paatja rumta. ");
INSERT INTO tvt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Eno mararah Sadusi mina tek nawa tangaaksaatka liite loong ah ih, Jisu suh cheng karumta. ");
INSERT INTO tvt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Neng ih liita, “Nyootte, Moses ih seng suh Hootthe amet raangthiinta: ‘Jengthaak ih mih wasiit heh sah maangje di tek ano heh minuh ah thiinhaat abah, heh no damdoh we jen chosong eah, eno heh sah ah heh phoh etekte wah mikkhang ang ah.’ ");
INSERT INTO tvt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Teewadi soophoh wasinet angta; phokhoh rah ih heh minuh ah kap ano, heh sah maangje di mattiita. ");
INSERT INTO tvt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Eno miidamwah damdi we chosong ano, heh uh emamah ih heh sah maangje di we mattiita. Erah lilih wasiit taat we chosong, erah uh emamah heh sah maangje di we matti, ");
INSERT INTO tvt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","eno soophoh wasinet net: loongtang erah nuh ah damdi taat chosong leh neng sah laje thang ih matti rumta. Hethoon adi minuh ah thoon tiita. ");
INSERT INTO tvt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Erah ang abah, tek nawa we ngaaksaat rum adoh, heh ah o minuh ang ah? Soophoh wasinet net ih kap thoidi ah.” ");
INSERT INTO tvt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisu ih ngaakbaat rumta, “Mame mokbaang lan! Sen loong ih Rangteele nyia Rangte chaan aphaan lajat thoidi mokjeng lan! ");
INSERT INTO tvt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Maatok doh tek nawa ngaaksaat ah, erah tokdoh rangmong nawa Rangsah loong likhiik ih hoon ah, erah nah mina takah nookmuika.” ");
INSERT INTO tvt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tek nawa ngaaksaat tiit ah: Moses ih raangthiinta leedap adi woma ni we luung damdi Rangte jengta ah taba japweh tan? Erah di Rangte ih Moses suh amet baatta. ‘Ngah Abraham Rangte, Esak Rangte nyi Jaakob Rangte.’ ");
INSERT INTO tvt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Heh ah ethingte loong Rangte, tekchoote Rangte tah angka. Sen loong ah rapne ih moong jenglan!” ");
INSERT INTO tvt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hootthe nyootte wasiit ih neng daanmui rumta ah japchaatta. Jisu ih Sadusi loong suh ese lam ih ngaakbaat rum arah japchaat ano, cheng kata: “Marah jengdang ah loongtang nang ih elongthoon ih kapjih ah?” ");
INSERT INTO tvt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisu ih baatta ehanthoon ih kapjih ah arah, Ijirel mina loong chaat an! Teesu seng Rangte luulu ah juuba Teesu wah. ");
INSERT INTO tvt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Erah raang ih, senthung sentak, senchi senla, sen tah nawa ih Rangte ah nook an. ");
INSERT INTO tvt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Erah lilih jengdang ehan kapjih ah arah: “Senkhuung sentok ah senteewah thanthan et minchan an. Erah nyi tokkhodi ehoh elong jengdang tajeeka.” ");
INSERT INTO tvt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Eno Hootthe nyootte rah ih Jisu ah guuta, “Elang eh uh, Nyootte! Epun baat et hu Teesu heh luulu abah Rangte, heh tokkhodi ranghoh tajeeka eah. ");
INSERT INTO tvt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Erah raangtaan ih seng ih Rangte ah seng tenthun mongtham nawa nyia sengthung sengtak adoleh seng tah nawa ih seechoh theng; eno sengkhuung sengtok ah seng teewah thanthan ih seechoh theng. Jaat hoh liiamaan nyi ngunteh seng khosa suh Rangte suh kohi ah nang ih uh arah jengdang enyi ah kapjih.” ");
INSERT INTO tvt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Erah wah rah ih mongwah maakwah lam ih ngaakbaatta ah jat ano, Jisu ih heh suh baatta, “An bah Rangte Hasong nawa haloot tah angko.” Erah lidi o ih uh Jisu suh tumjih uh tanaan boot cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisu ih Rangteenok ni nyootsoot rum adi, heh ih cheng rumta, “Hootthe nyootte loong ih Kristo ah Dewid sutoom ih mamet miibaat rum ah? ");
INSERT INTO tvt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Esa Chiiala ih Dewid suh jeng thukta: ‘Rangte ih nga Teesu suh baatta: Nga jaawah ko adoh tong uh an piiara loong ah ngah ih an lakhu nah maang thiinthiin ah.’ ");
INSERT INTO tvt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dewid ih heh teeteewah ih, ‘Teesu’ et liita; eno bah Kristo ah Dewid sutoom mamah mi ang ah?” Miloong ah ih Jisu tiit ah tenroon roon et banchaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Heh ih nyootsoot rumta adi baat rumta, “Hootthe nyootte loong dowa banban ih tong an, neng loong ah nyuh akhat eloot lootwah ih kap rum ano mih ih toom soomtu he ih pheehoon theng ni lengkhoom suh nook rumla, ");
INSERT INTO tvt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jehudi rangsoomnok ni tongtheng ese ban thiincho adoh tong suh nyia sadung theng ni tongtheng eseethoon adoh tong suh nook rumla. ");
INSERT INTO tvt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Neng ih thaknuh loong ah nep mokwaan rum leh neng nok nawa looso et rumha, mih miksok di rang eloot lootwah ih soom rum ano rangsoomte likhiik et noisok rumha. Neng chamnaang theng rapne ethih thoon ang ah!” ");
INSERT INTO tvt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisu Rangsoomnok ni ngun lomthiin theng re adi tong ano miloong ih neng ngun sak rum arah ban sokta. Nyamte loong ah ih hantek hantek ih sak rumta; ");
INSERT INTO tvt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","eno changthih thaknuh nusiit ah thok haano jaan ngun loonyi phaasiit nyi di to arah koh wan taha. ");
INSERT INTO tvt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Eno Jisu ih heliphante loong ah lompoon ano baat rumta, “Ngah ih baat rumhala, arah changthih thaknuh ih ngun bangkhok adi sak ha rah wahoh ih sak ha nang ih ehan thoon ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wahoh loong ih bah neng nyamka dowa hedak aba koha; eno arah changthih nuh rah ih bah heh laanyaang theng angta rah thoon koha.” ");
INSERT INTO tvt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisu Rangteenok nawa dokkhoom adi heliphante wasiit ih liita, “Nyootte, Sok uh! Arah nok loong nyia jong ah, tumthan milung miwaang ah!” ");
INSERT INTO tvt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisu ih ngaakbaatta, “An ih arah nok loong ah elong longwah tam et tup hu?” Arah nok abah saasiit erukdat eah, arah nok adoh jongteh tesiit taan uh tah dak tongka ang ah; loongtang rukdat ih ah.” ");
INSERT INTO tvt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Rangteenok ka ni Jisu Olib kong ni tong adi, Pitar, Jeems, Joon nyia Endriu loong ah huchomui wang rumtaha. ");
INSERT INTO tvt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Erah loong ah maatok doh angte angla, seng suh baat kohe,” neng ih cheng rumta, “Erah loong ah saapoot ah echang ela ih jat suh tumjih ih jatthuk he, erah nep baat kohe.” ");
INSERT INTO tvt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisu ih baat rumta, “Naririh ih ban tong an, mih ih naktoom mokwaan han. ");
INSERT INTO tvt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nga tiitbaatte mih hantek ih dong ah, ‘Jisu ah ngah’ ih chaangte nep dong ha! Eno neng ih hantek moong mokwaan ah. ");
INSERT INTO tvt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Sen ih haniik haloot nawa raamui tiit ephoop chochaat an, ang abah uh sen lasootsaam theng. Erah loong ah elang jaatjaat eah, enoothong erah suh rangkuh thoonla ih liijih tah angka. ");
INSERT INTO tvt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Hasong rookwih nah neng neng rookmui arah je ah, deek akaan ah deek akaan loong damdoh rookmui ah. Rongrep nah hasatek nyi ramtek khamle totoh ang ah. Erah loong ah, noonuh nootup suh kaphang sat arah likhiik ih ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Sen teeteewah sensen ih naririh ih ban sok an. Sen loong ah khak hanno mat hoon nok nah siitwan han. Sen loong ah Jehudi rangsoomnok loong nah buh kaat han; nga thoidoh sen loong ah mih luungwang loong ngathong nah chap anno ruurang ese tiit ah baat an. ");
INSERT INTO tvt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Enoothong rangkuh thoon jaakhoh nah mongrep dowa mirep miraang suh Rangte tiitkhaap ah baat jaatjaat etheng. ");
INSERT INTO tvt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Eno sen loong ah, maatok doh khak hanno mat hoon nok nah siitwan han doh tumjih jeng ang ih lasootsaam theng; saapoot thok ha doh an tumjih jeng thuk ho, erah jeng uh. Jengkhaap marah jeng uh erah an jeng tah angka ang ah; erah Esa Chiiala nawa jeng raaha. ");
INSERT INTO tvt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mina loong ah soophoh ah soophoh ih jootkot mui rum ano tek haatmui ah eno hewah loong ah ih emamah heh sah loong tek haat ah. Heh sah loong ah ih henuh hewah damdoh miksuk mui rum ano tek haatmui rum ah. ");
INSERT INTO tvt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nga tungthoidoh warep ih miksuk han. Enoothong o hethoon tuk ih ramram ih joh ah erah ba pui ah. ");
INSERT INTO tvt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Sen ih ‘Rapne Echoojih’ jaatrep jen thet haatte ah japtup et an, marah doh lah angtheng angta erah doh ang ah.” (Arah wette suh: esamjat etheng tumjih men et ha rah ah!) “Eno Judia nawa miloong ah kong akaan ko ih toonsoonjih jaatjaat ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","O bah uh nok khoni angte rah ih nokmong nawa hukkhaak toon suh lajaatjaat saathaam kaat jih ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","O mina phek nah ang ah, heh nok nawa nyuh akhat toon suh lajaatjaat ngaak wangjih. ");
INSERT INTO tvt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Erah tokdoh tumthan ethih ang ah sah wokte nyi khobaang nuh loong ah raang ih ah! ");
INSERT INTO tvt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Rangte rangsoom an erah rangwuung ah hahook doh nak toom ang ah! ");
INSERT INTO tvt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tumeah erah tokdoh chamchojih rah, Rangte ih hasong phangdong siitta dowa ih amatuk ih o uh lathaak chamka rah cham ah. Adoleh erah likhiikkhiik tumsa doh uh takah we angka. ");
INSERT INTO tvt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Enoothong Teesu ih erah saakaan rookweh ah ethoosiit thong et koha, lah angta bah, o uh ething tatong thengta. Heh ih danjeeta mina loong suh raamwe ih erah saakaan ah thoosiitta. ");
INSERT INTO tvt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Eno, o ih bah uh amah mok ih baat han, ‘Sok an, Kristo aani,’ adoleh mararah ih baat han ‘Kristo bah therah ni thong!—erah sen ih lahanpi theng. ");
INSERT INTO tvt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tumeah emoong Kristo nyia emoong khowah loong ephoop dong ha. Neng ih epaatjaajih nyia mih lungwaang theng ephoop noisok rum ah, jen lang abah Rangte ih danjeeta mina loong ah nep mokwaan suh ah. ");
INSERT INTO tvt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Sen teeteewah naririh ih ban sok an! Ngah ih jaatrep tiit ah rangwuung saakaan maang thok ra ngakhoni banbaat rumhala! ");
INSERT INTO tvt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Erah chamnaang loong saakaan lidoh rangsa ah emoon eah, laaphiing ah takah kaang phaakka ang ah, ");
INSERT INTO tvt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","rang nawa riksih loong ah datti ih raaha, rangkho nawa rangsa laaphiing loong ah dumdan eah. ");
INSERT INTO tvt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Erah lidoh, Mina Sah ah jiingmuung khuinah, chaan aphaan pan ih phaakjaaja ih dong raaha. ");
INSERT INTO tvt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Eno rangsah loong ah hatoh rongbaji adoh daapkaat ah, heh ih danjeeta mina loong ah mongrep noongrepwih dowa lom khoonsiit rum ah. ");
INSERT INTO tvt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Puksak bang ih sen suh toom nyoot han. Heh demdem suh hephaak ah jang ano dongkom raaha eno helak ah pa, erah di sen ih jat han rangsoh thok hala eah. ");
INSERT INTO tvt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Erah likhiik ih, sen ih sen mik ih erah loong chikrok ah tup anno ba, hethoon saapoot ah haniik ih thok hala ih samthun an. ");
INSERT INTO tvt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Banthun et an erah loong ah amah dowa mina thoontang maang matti rumka ngakhoh nah ang raaha. ");
INSERT INTO tvt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Rang nyia hah bah ethoon eah, nga jengkhaap loong abah babah uh tathoonka. ");
INSERT INTO tvt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“O mina reh uh rangwuung saakaan ah tajatka, tum sa doh, maatok doh raaha eah—rangmong nawa Rangsah reh uh tajatka; heh Sah reh uh tajatka, heh Wah luulu ih ba jat ah. ");
INSERT INTO tvt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Erah raang ih ban sok et an, nyia banban ih tong an, tumeah sen ih rangwuung saakaan ah tajatkan. ");
INSERT INTO tvt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Erah langla changte wah ih heh laksuh loong wasiit wasiit suh heh nok nawa reeraang loong ah baat koh thiin rum ano heh ah haloot nah moongkhoom kah arah likhiik ang ah. Eno heh maang ngaakwang wang et ban sok thuk arah likhiik. ");
INSERT INTO tvt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Erah raang ih naririh ih ban sok an! Tumeah sen ih tajatkan nok changte wah ah maatok doh ngaakwang koja, rangja ko doh tam pheethungkham doh, tama rangkhano doh, adoleh rangsa dong doh wang koja. ");
INSERT INTO tvt_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Heh baphuk ih raaha doh, sen emokjup ean rah nak toom kapjoh raahan. ");
INSERT INTO tvt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ngah ih sen loong suh baat rumhala rah, mirep suh baat hang: Banban ih tong an!” ");
INSERT INTO tvt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Khopui Kuwaang nyia Toomuh Baanlo Kuwaang phaksat thok suh saanyi tongta. Romwah phokhoh nyia Hootthe nyootte loong ih, Jisu ah husah lam ih khak ano tek haat suh lampo jam rumta. ");
INSERT INTO tvt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Kuwaang mong dobah seng lajaatjaat reejih, miloong ah phophaang jaang rum ah, neng liita.” ");
INSERT INTO tvt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Bithani hadaang ni Jisu ah Simoon maangdi engam angta wah nok adi roong tongta. Jisu phaksat tokdi minuh nusiit ih heh lak ni mojaang thuungsiit thaangchaan thaang phontum ah pi ano wangta. Eno moojaang kep ah thajop ano Jisu khoni keelokta. ");
INSERT INTO tvt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Erah dowa mararah miloong ah khah rum ano neng chamchi ni roongwaan rumta, “Erathan thaangchaan thaang phontum ah tumjih suh thaaja ha?” ");
INSERT INTO tvt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Erah bah chaajom nang ih ehan ngunkholok doh sang ano ngun ah changthih loong suh minchan kotjih boh angta!” Eno neng ih minuh ah rapne ih chikram li rumta. ");
INSERT INTO tvt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Enoothong Jisu ih li rumta, “Heh nak thaam paklak an! Heh suh sen tume sootsaam lan? Heh nga raangtaan ih eseejih reeraangla. ");
INSERT INTO tvt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Changthih loong abah saarookwih noongrep nah sen damdam ang ha, chosok ih suh li anbah tiimtok doh uh ejen chosok et an. Ngah ah sen damdoh saatangtang lakah roong tongte. ");
INSERT INTO tvt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Heh tumjih reejih angta erah reela; heh ih nga sak ni phontum ih lok halang ah langla saapoot maang angka ngakhoh nah nga mangbeng suh ban khookhamha. ");
INSERT INTO tvt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ngah ih ami tiit baat rumhala, mongrep thoontang nah ruurangese marah doh thok ah erah doh arah nuh reela tiit ah, ban samthun ruh ejih ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Eno asih wanyi heliphante dowa Judas Iskerot ih Romwah Phokhoh loong suh Jisu khumtan kaatta. ");
INSERT INTO tvt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Eno neng ah erah tiit ah chaat rum ano roon ih rumta, eno heh suh ngun kottheng ih kakham rumta. Erah dowa ih Judas ih Jisu ah ma doh jap jokoh rum ang ih saapoot bantho thakta. ");
INSERT INTO tvt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Toomuh Baanlo Kuwaang sa sakhothoon adi, neng banlam di Khopui Kuwaang doh phaksat suh saapsah loong kadook rumta, Jisu suh heliphante loong ih cheng rumta, “An ih seng maanah kaat thuk he, an raangtaan ih Khopui Kuwaang phaksat khookham raangtaan ih ah?” ");
INSERT INTO tvt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Eno heliphante dowa wanyi asuh amet baat ano kaat thukta: “Samnuthung adoh kah ansih, erah doh mih wasiit khamteng tek ah pi ano wangha rah chomui ansih, eno erah wah lilih ih roongwang ansih. ");
INSERT INTO tvt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Heh marah doh nop ah erah nok changte asuh cheng ansih: ‘Seng suh Nyootte wah ih liita, Nga liphante nyia ngah ih kuwaang phaksat sat theng nokkhok maani ah?’ ");
INSERT INTO tvt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eno heh ih rangkhoh thoon nokkhok elongwah esiit baat koh hansih, erah doh seng raang ih tongtheng thaatheng nyia jaatrep ban khookham cho japtup kah ansih. Eno set ih phaksat ah erah doh ban songwaang theng.” ");
INSERT INTO tvt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Eno wanyi ah samnuthung adi kah nyu ano Jisu ih mamet baatta erah jun ih jaatrep echoi et tup kah nyuuta. Eno nyi ih Khopui Kuwaang phaksat ah ban khookham kah nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Rangjaako ih hoon damdam Jisu nyia heliphante asih wanyi ah ra rum taha. ");
INSERT INTO tvt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Neng erah di teebun ni room phaksat tokdi Jisu ih liita, “Sengdung ni wasiit nga khumtante eje erah mih ah nga damdi room phaksah ih hala.” ");
INSERT INTO tvt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Heliphante loong ah rapne ih thungthih rum ano wasiit wasiit ih cheng rumta, “Ngah suh nih li halang?” ");
INSERT INTO tvt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisu ih liita, “Erah sen asih wanyi dung dowa, nga damdi khuung esiit ni baanlo roongtem phakte mina ang ah. ");
INSERT INTO tvt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mina Sah baleh etek haat jaatjaat ih rum ah, Rangteele ni mamet raangha jun ih ah. “Enoothong tumthan ethih angbaat ah Mina Sah khumtante raang ih ah. Erah mih abah lalaan tupta bah ese ang thengta!” ");
INSERT INTO tvt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Neng phaksat phaksah rum adi, Jisu ih baanlo ah toonpi ano Rangte suh lakookmi li ano chepphiitta, eno heliphante loong asuh pheekoh rumta, “Thaang an, arah nga sak,” Jisu ih liita. ");
INSERT INTO tvt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Erah lilih lokkep ah toon ano Rangte suh jengseeraata, eno erah lokkep dowa loongtang ih jok rumta. ");
INSERT INTO tvt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Heh ih liita, “Arah nga sih mina loong raang ih jan ra hala. Arah sih rah ih Rangte nyia heh mina loong chamchi ni jengdang kakhat ena ah Rangte ih hoonha. ");
INSERT INTO tvt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngah ih baat rumhala, aadowa ih ngah ih arah kham ah babah uh takah we jokkang. Heh rangwuung rookli ano kham na ah Rangte Hasong nah ba we jok ang.” ");
INSERT INTO tvt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eno neng rangsoom boong ah boong rum ano Olib Kong ni wang rumta. ");
INSERT INTO tvt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisu ih baat rumta, “Sen loong nga re nawa loongtang saapsoonte ang lan, Rangteele ni liiha, ‘Rangte ih saapriimte warah tek haat ano saapsah loong ah thaapnya khoom rum ah.’ ");
INSERT INTO tvt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Enoothong ngah etek nawa we ngaaksaat angno, Galili hah nah sen ngah nah ban kah ang.” ");
INSERT INTO tvt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pitar ih ngaakbaatta, “Ngah ih bah an babah uh tajen thiinhaat ra, wahoh loong ih thiinhaat ho bah uh ah!” ");
INSERT INTO tvt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisu ih Pitar suh liita, “Ngah ih baat hala niikja woh leknyi maang weeka nganah, an ih tajatkang ih lekjom jeng uh.” ");
INSERT INTO tvt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Eno Pitar ih ehan han ih we ngaakbaatta, “Ngah an damdoh waktek haat hang doh botseh, emah tajeng kang!” Heliphante wahoh loong ah uh emamah ih roongjeng rumta. ");
INSERT INTO tvt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Neng Getsimani hah adi thokrum ano, Jisu ih heliphante loong asuh baatta, “Ngah ih rangsoom ang pootdoh adoh tong an.” ");
INSERT INTO tvt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Heh damdi Pitar, Jeems nyia ah Joon ah waksiit wanta. Heh phang sootsaam nyia heh mong chikrok ano, ");
INSERT INTO tvt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jisu ih baat rumta, “Nga ten ehan thoon ih paattiila, ngah bah tek thanthan ih hoon lang.” “Adoh tong anno bantho he.” ");
INSERT INTO tvt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Amasah hiikkhoom ano, Jisu hani kotbon ano rangsoomta, jen lang eabah erah chamchoh saapoot ah nak chothuk weeuh, ");
INSERT INTO tvt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Ewah Jisu ih rangsoomta, “Seng Wah!” Andi bah jaatrep tachaanka, arah chamnaang lookkep ah nga re nawa toonhaat et weeuh. Enoothong nga thung jun lah angthang an thung jun ju toom ang ah.” ");
INSERT INTO tvt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Eno heliphante wajom jiinni ngaak adi neng ah emokjup ih rum arah japtup kata. Jisu ih Pitar suh liita, “Simoon mokjup nih elu? Sen saapootsiit taan uh motseng tanih jen tong kan?” ");
INSERT INTO tvt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Motseng ih tong an no chaan aphaan raangtaan ih rangsoom an phate joonnaam ih nak toom jen han. Chiiala ah enook ela, enoothong hansi ah naangla.” ");
INSERT INTO tvt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jisu we ngaak wang ano phosiitsiit ih we soomwangta. ");
INSERT INTO tvt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Eno we ngaak raaha di uh heliphante wajom ah thok mokjup ruh ih rumta; Neng mik uh lajen daapsok rum thang ah. Eno Jisu suh tumjih uh tami baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Heh rangsoom theng nawa takjom ngaak ha di uh neng ah hephoopho ih mokjup rumta, eno we li rumta, “Amadi uh thok naangjup ruh nih elan?” Erah than jup an chang ih ah! Saapoot chang ela! Sokthaak an, “Mina Sah ah amadoh rangdah mina loong lak nah koh ah. ");
INSERT INTO tvt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Saat an kah ih, erah sok an, “Nga khumtante wah rah ah!” ");
INSERT INTO tvt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisu ih baat tokdi heliphante asih wanyi dung nawa, Judas dong khoom taha. Heh damdi miloong langnuh pawah nyia kiingthom waangrak ih roong dong khoom rum taha, Romwah phokhoh loong, Hootthe nyootte loong nyia mihak phokhoh loong ih daapkaat rum taha. ");
INSERT INTO tvt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Heh khumtante wah rah ih miloong asuh hubaat rumta: “Ngah ih marah wah ah chupphak ang erah wah ah ang ah, sen ih jam han warah ah. Eno khak anno bante loong suh siitwan thuk an.” ");
INSERT INTO tvt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas heh laanthok khoom, Jisu reeni kah ano liita, “Nyootte!” Eno chupphakta. ");
INSERT INTO tvt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eno neng ih Jisu ah joh rum ano khak rumta. ");
INSERT INTO tvt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Eno erah chap rumta dung dowa wasiit ih heh lang ah dok hoom ano Romwah phokhothoon dah na ah chepdookta. ");
INSERT INTO tvt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Eno Jisu ah toon jeng ano li rumta, “Hootthe thet haatte jokah ah likhiik langpi papi nyia kiingthom waangrak nga joot tam ra tahan?” ");
INSERT INTO tvt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","“Saarookwih ngah sen damdi Rangteenok ni tonghang no kanyootsoot tang adi mamah lajoh khak ih tahe? Enoothong, Rangteele ni liiha amiisak jaatjaat ang raaha.” ");
INSERT INTO tvt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Eno heliphante loongtang heh ah thiinhaat rum ano saapsoon rumta. ");
INSERT INTO tvt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jaaro wasiit nyuleep di choom arah ih Jisu lini roongphan khoomta. Eno neng ih heh khak taat thot rumta, ");
INSERT INTO tvt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","enoothong heh ah boongloong henyuh hekhat ah khook haat thiin ano moong soonta. ");
INSERT INTO tvt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Eno Jisu ah Romwah Phokhothoon nok ni siitwan rumta, erah di Romwah Phokhoh loong, mihak phokhoh loong, nyia Hootthe Nyootte loong thoontang thutthi rumta. ");
INSERT INTO tvt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pitar ih haloot nawa ih rikwan ano Romwah Phokhothoon nok taakkhuung adi wangta. Erah di bante damdi weekaang ni roong hangtong wangta. ");
INSERT INTO tvt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Romwah Phokhoh loong nyi hadaang Ngoong awang loong ah ih Jisu kap tek haat suh heh thet tiitbaatte taat jam rumta, eno o uh tachojam rumta. ");
INSERT INTO tvt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jisu thetre tiit baat hantek ih taat leekbaat rumta, ang abah uh erah jeng loong adi tajun rumta. ");
INSERT INTO tvt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Eno mararah Jisu miksukte ih toonchap leh hahuung tiit ah leekbaat et rumta: ");
INSERT INTO tvt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Seng ih ame jeng arah chaatti, ‘Ngah ih arah mina ih hoonta Rangteenok ah thaak haat angno, sa jom lidoh mina ih lahoonka rah hoon ang.’” ");
INSERT INTO tvt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Neng thung nawa ih dong hoon arah tiit taatbaat rum abah uh tajunwaan rumta. ");
INSERT INTO tvt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Loongtang ngah ni Romwah Phokhothoon ah toonchap ano Jisu suh chengta, “An tiit erathan et thetbaat rum halu adi, an ih ngaakbaat jih tanih jeeka?” ");
INSERT INTO tvt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Enoothong Jisu ah khaapsiit uh tatoon jengta. Eno Romwah Phokhothoon rah ih we cheng, “An ah Kristo tama, marah seng ih soomtu hi Rangte sah rah ah?” ");
INSERT INTO tvt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisu ih liita, “Elang eah ngah, sen ih mina Sah ah Elongthoon Rangte heh jawah koh tongtheng adoh roongtong arah nep japtup an, erah damdoh rang nawa jiingmuung damdoh raaha arah nep kaptup an!” ");
INSERT INTO tvt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Eno Romwah Phokhothoon rah ih heh nyuh ah ranhoom ano liita, “Seng ih erah tokkhodoh an thet tiit baat suh haaki takah boot jamke! ");
INSERT INTO tvt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“Rangte kaanju tiit loongtang ih ejap chaat et han. Eno bah sen ih mamet thunhan?” Eno loongtang roongjeng rumta: elang eah ethih ela etek haat ju etjih. ");
INSERT INTO tvt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mararah ih Jisu ah neng took ih nep phang betook rumta, eno heh mik ah loop rum ano buh leh cheng et rumta. “Jat thaak he o ih buh halu!” Eno bante loong ah ih joh rum ano heh the adi baangbuh rumta.” ");
INSERT INTO tvt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pitar uh Romwah phokhoh danuh raak tokdi, nok taakkhuung ni thok tongruh eta. ");
INSERT INTO tvt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Erah nuh rah ih Pitar ah we ni hangtong arah japtup ano heh ah chiichi et sok ano liita, “An uh Nazareth nawa Jisu damdi roong angtu.” ");
INSERT INTO tvt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Eno Pitar ah leek eta. “Ngah ih tajatkang... Tumjih tiit baat hu erah ah, ngah ih tasamjat kang,” eno heh ah pa kaawan ko ih dokkhoom kata. Erah damdam woh ah weeta. ");
INSERT INTO tvt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Danuh rah ih Pitar we japtup ano, heh reeni chapta miloong asuh we baatta, “Arah uh Jisu damdi khoomte loongdung dowa wasiit!” ");
INSERT INTO tvt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Eno Pitar ah we leekta. Chomre lidi mih heh reeni chapta loong ih we li rumta, “An bah neng dung dowa ju angkoko nak leek kuh, tumeah an uh Galili nok hah nawa.” ");
INSERT INTO tvt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pitar ih liita, “Ngah ih ami tiit baat rumhala! Tiit huung baatkang bah Rang ih toom cham thuk kohang, ngah ih tajaatjaat jatkang sen ih o suh li han rah ah!” ");
INSERT INTO tvt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Erah damdam woh ah we weeta, eno Pitar ih Jisu ih mamet baatta rah dokthunta, “Woh jaanyi maang weeka doh an lekjom leek uh ngah ih tajatkang eah.” Eno Pitar ah thungthih ano huungta. ");
INSERT INTO tvt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Rangkhano di Romwah phokhoh ah mihak phokhoh, Hootthe Nyootte nyia Ngoong awang loong damdi kaankoong suh echaan ih chomui rumta. Neng ih Jisu ah jaanruh ih khak rum ano Pilat suh kowan rumta. ");
INSERT INTO tvt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat ih chengta, “Jehudi luungwang ah an tam angkoko?” Jisu ih ngaakbaatta, “Elang eah an ih liihu rah ah.” ");
INSERT INTO tvt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Romwah Phokhoh loong ah ih jirep di Jisu ah mat ih deejoh rumta, ");
INSERT INTO tvt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","eno Pilat ih we chengta, “An ih tanih ngaakbaat rumko? Boichaat thaak uh neng ih liilaang rum halu rah ah!” ");
INSERT INTO tvt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Erah di uh Jisu ah khaapsiit taan toon jeng suh tanookta, eno Pilat ah paatjaata. ");
INSERT INTO tvt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Khopui kuwaang rookwih Pilat ih phaatak ni tongte mina, marah noksong ih danje ah erah daap haat ah neng banlam angta. ");
INSERT INTO tvt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Erah tokdi mih wasiit heh men ah Barabas changrook di mih tek haat arah phaatak ni sakta. ");
INSERT INTO tvt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Paang hoh di mamah kah ih daap haat ah erah likhiik phaatak ni tongte daap haat suh miloong ah Pilat reeni wang rumha no cheng wang rum taha. ");
INSERT INTO tvt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat ih cheng rumta, “Ngah ih seng suh Jehudi luungwang ah toomdaap kohe ih tam li han?” ");
INSERT INTO tvt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Heh ih jatcho angta, Romwah phokhoh loong ih Jisu ah rapne ih miksuh rum ano jokoh wan rum tahang eah. ");
INSERT INTO tvt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Eno Romwah Phokhoh loong ih miloong asuh Jisu lah angthang ih Barabas ah daap haat theng ih Pilat reeni rojeng thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat ih miloong asuh we cheng rumta, “Erah ang abah, sen ih Jehudi luungwang et liihan asuh ngah ih tumjih et ang?” ");
INSERT INTO tvt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Neng ah ngaak riing rumta, “Bangphak nah tek rabbot theng!” ");
INSERT INTO tvt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat ih we chengta, “Heh tumjih thetre kota?” Miloong ah ih erong ih huk riing rumta, “Banphak nah tek rabbot theng!” ");
INSERT INTO tvt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Noksong ah roonthuk suh li ano, Pilat ih Barabas ah daapta. Eno Jisu ah ruh ih buh thuk ano bangphak nah rabbot suh korumta. ");
INSERT INTO tvt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Raabante loong ih Jisu ah Kobono nokmong ni neng joonte ah lompoon rum ano siitwan rumta. ");
INSERT INTO tvt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Neng ih Jisu ah elootwah saangjang songloh ih choom rum ano nyia suk khopok ah hoon rum ano, heh khoni pokkoh rumta. ");
INSERT INTO tvt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Eno neng ih lakkong ih soom rumta: “Jehudi loong luungwang ah Roitang toomtong kah!” ");
INSERT INTO tvt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jisu khoh adi chaanthah ih buh rum leh neng took rah ih took et rum, eno neng lakuh adi tong rum leh paanglaang soom et rumta. ");
INSERT INTO tvt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Eno neng ih jen thaangju joonnaam rum ano heh sak nawa saangjang samsong ah we ngaakkhook rumta, eno heh nyuh akhat ah we kap thuk rumta. Eno bangphak na tek haat wan suh siitwan rumta. ");
INSERT INTO tvt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lam ni mih wasiit heh men ah Simoon erah samnuthung adi heh deek nawa wangha rah chomui rumta, no heh suh raabante loong ih Jisu bangphak ah roong huiwanho ih laatbaat rumta. (Simoon langla Sirini nok hah angta, heh sah rah Alekjender nyia Rupus angta.) ");
INSERT INTO tvt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Neng ih Jisu ah Golgotha adi siitwan rumta. Golgotha rah, “Mih khoraang hah suh liita.” ");
INSERT INTO tvt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Erah di heh suh kham damdi phon ah woorum ano taat korumta, ang abah uh Jisu ih tajokta. ");
INSERT INTO tvt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eno neng ih bangphak adi tek rabbot rumta, henyuh hekhat ah jopche rum ano, o ih marah chep ah choh ah ih wenhaat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Heh ah rangkhah phek kaat tok saapoot akhuh di tek rapbotta. ");
INSERT INTO tvt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Heh kaanju jengkhaap amet raangta, “Jehudi luungwang.” ");
INSERT INTO tvt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jisu damdi ehuh wanyi, esiit ah dak hekko esiit ah jaawako ih wak rabbot rumta. ");
INSERT INTO tvt_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Emamah Rangteele ni liiha amiisak angta. Heh ah mih putte likhiik ih roong hoonta. ");
INSERT INTO tvt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Erah di daankhoomte miloong ih Jisu ah neng tok ah nyoongleh chikram kaanju et rumta: “Aleh! An ih bah Rangteenok ah thaak hoom angno sa jom mongdoh we hoon ang ih laangma liitu! ");
INSERT INTO tvt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Amadoh an teewah ah jen pang ubah, bangphak dowa edat khoom ih ho ba!” ");
INSERT INTO tvt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Erah likhiikkhiik romwah phokhoh loong nyia Hootthe Nyootte loong ah ih we kaanju liilaang rumta, “Heh ih mih abah pang kah eta, heteewah ah tajen pangka! ");
INSERT INTO tvt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Taat sokthaak ih arah Kristo ah, Ijirel luungwang ah, amadoh bangphak dowa jen dat khoom koha bah seng ih uh heh suh hanpi et ih!” Jisu reeni rabbotta wanyi rah ih uh emamah ih roong kaanju nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Rangnithung di deek rep ni rang ah nakdatta, eno erah koonta jom raang ih nakdatta. ");
INSERT INTO tvt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saasong saapoot jom di Jisu ah erongwah ih riinghuungta, “Eloi, Eloi, Lema Sabachthani?” erah langla, “Nga Rangte, Nga Rangte,” an ih ngah mamet thiinhaat halang?” ");
INSERT INTO tvt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Erah dowa mararah miloong ih japchaat rum ano jeng rumta, “Boichaat thaak an heh ih Elija poonha!” ");
INSERT INTO tvt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mih wasiit ih nyulep ah pi ano soon ra taha, eno nyulep ah thaangneejih kham adi tem ano, chaanthah tuuba adi rapkhakta. Eno chaanthah ah toonpi ano Jisu tui adi mook suta, eno liita, “Ma! Ban sok ih Elija ra haano bangphak dowa tam datthiin ra thaak ha!” ");
INSERT INTO tvt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jisu ah erongwah ih riinghuung ano tiita. ");
INSERT INTO tvt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Rangteenok ni nyuh tinta rah hekhoh nawa ih helah tuk ih kho nyi ih khoodatta. ");
INSERT INTO tvt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Arami saahaap ah bangphak ngathong ni chap adi Jisu mame tiita erah sok ano jengta, “Arah mih abah amiimi Rangte sah ju angta!” ");
INSERT INTO tvt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Erah di mararah minuh loong ih, haloot nawa ih ban sok rumta. Erah dung adi Meeri Megdalen, Jeems no nooliwah ah nyia Josep nuh Meeri erah damdi Salomi loong ah angta. ");
INSERT INTO tvt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Heh Galili ni ang tokdi neng loong ah Jisu lilih ih rum ano naririh kah ih sokboi rumta. Nuhoh loong uh hantek heh damdi Jerusalem ni roong raakte loong uh erah di eje roong ang rumta. ");
INSERT INTO tvt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Rangja ko ang damdam Arimathia nawa Josep thok taha. Heh uh Jehudi loong Ngoong awang dung ni esiit esoongraang mina angta, eno heh ih Rangte Hasong raak ah bansokte angta. Erah sa ah Ban khookham sa angta (erah langla Jehudi loong naangtongsa saakhoh rah angta), eno Josep ah lacho laphaan ih wang ano Pilat dowa Jisu mang ah cheng wangta. ");
INSERT INTO tvt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat ah Jisu jen tek etta ih chaat ano paatjaata. Arami saahaap ah poon ano Jisu abi dook nih tiita ih chengta. ");
INSERT INTO tvt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Saahaap ih baatta rah chaat ano, Pilat ih Josep suh heh mang ah jen toon et uh ih baatta. ");
INSERT INTO tvt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep ih heh mang loop nyuleep ah reh ano Jisu mang ah datthiin wangta, eno erah nyuh rah ih mang ah dek ano mangbeng theng, jong hah ni thoh aradi thiin kaatta. Eno mangbeng luung adi, jonglo elong tangkoong thiinta. ");
INSERT INTO tvt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meeri Megdalen nyia Josep nuh Meeri rah ih Jisu mang marah di beng ha ih sokkah nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jehudi naangtongsa rangja ko di, Meeri Megdalen, Jeems nuh Meeri nyia Salomi ih Jisu mang sak adoh hut suh phontum ah reh kah nyuuta. ");
INSERT INTO tvt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Naangtongsa rangkhah di, rangsa dong damdam, nengjom mangbeng theng ni karumta. ");
INSERT INTO tvt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Lam ni karum adi waan rumta, “O ih lekloong kobaat he jonglo heh mangbeng tangkepta rah ah?” (Jonglo ah elong angta.) Eno neng erah di thok ano sok rum adi jonglo ah dokkoong cho angta. ");
INSERT INTO tvt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Eno mangbeng luung adi nopkhoom wang rum adi jaaro wasiit jaawako adi songloot epuung ah song ano ban tongta—eno neng ah echo ih rumta. ");
INSERT INTO tvt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“Nakcho an,” heh ih liita. “Ngah ih jat ehang, sen ih Najaret nawa Jisu bangphak ni rapbotta ah jam sok han. Heh adi takah jeeka—heh ejen ngaaksaat eta! Sokthaak an ba heh adi thiin rumta rah ah. ");
INSERT INTO tvt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Amadoh wang an no heliphante loong asuh arah tiit ah baatwan an, Pitar asuh wakbaat et an: ‘Heh sen ngah ni Galili hah adi wangla; erah nah japtup an, Heh ih baat tahan rah jun ih ah.’” ");
INSERT INTO tvt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eno neng ah rapne ih mocho rum ano mangbeng dowa doksoon rumta. Eno erah tiit ah nengjom ih echo ih rum ano o suh uh tanaan baat rumta. ");
INSERT INTO tvt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Naangtongsa rangkhano di Jisu ngaaksaat lini, jaakhothoon ah Meeri Megdalen jiinni dongta, erah nuh sak dowa jaakhoni Jisu ih laathih sinet dokphanta. ");
INSERT INTO tvt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Heh ah kah ano heh joonte loong suh baat kaatta. Neng ah mongjoong ih ehuung tok ang rumta, ");
INSERT INTO tvt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","eno heh ih Jisu ah ething, ngah ih nep tuptang ih baat rum adi uh, neng ih tahanpi rumta. ");
INSERT INTO tvt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Erah lilih, heliphante wanyi jiinni Jisu ah jaat hoh phan hoh lam ih dongta, deek akaan lamko ni kah nyu adi ah. ");
INSERT INTO tvt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Eno nengnyi ah ngaakwang nyu ano heliphante wahoh loong asuh baatwan nyuuta, ang abah uh o reh uh nyi jeng ah tahanpi rumta. ");
INSERT INTO tvt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lithoon adi, Jisu asih wasiit heliphante loong reeni, neng chamsat tokdi dongta. Jisu ih kanja et rumta tumeah, neng tuungmaang laje koka no nyia neng ten ah jong ajaan likhiik ang kano ah, erah dam ih mih etupte loong ih ething ih baat rum adi uh lahanpi thang ih tong rumta. ");
INSERT INTO tvt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jisu ih neng suh baat rumta, “Kah an mongrep thoontang nah Ruurang Ese tiit ah mirep miraang suh tumbaat kaat an. ");
INSERT INTO tvt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","O ih hanpi ano juungtem ah erah mih ah epui eah; lahanpiite loong ah edut haat et ah. ");
INSERT INTO tvt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Hanpiite loong asuh epaatjaatheng jen reejih chaan koh ah: neng ih nga mendoh chiithih laakhah jen dokphan ah; neng jeng ena dongjeng ah; ");
INSERT INTO tvt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","neng ih puuthih jukkhah ah toonpi ah adoleh me asu mok jok abah neng tathet haatka; khoisatte ah neng lak ih taajoh abah ede eah.” ");
INSERT INTO tvt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Teesu Jisu ah neng damdi jen roongwaan ano, rang ni toonsiit wanta eno Rangte damdi jaawako tongtheng adi roongtong wangta. ");
INSERT INTO tvt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Heliphante loong ah noongrep ni karum ano Ruurang Ese ah tumbaat kaat rumta, eno Teesu ah neng damdi roong mokah no Rangte tiit baat rumta, neng ih epaatjaajih loong re rumta jun ih amiisak ah dongjat thuk rumta.");
INSERT INTO tvt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mongnook Thiophilas: Seng laktung ni Rangte mootkaat angta loong ah mina hantek ih lom raangthiin rumta. ");
INSERT INTO tvt_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Neng ih seng suh hephang di tumjih tup rumta loong ah nyia ruurang tumbaatte loong ih mamet baat tahe erah jun ih raang rumta. ");
INSERT INTO tvt_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Erah raang ih, Jatwah Thiophilas, ngah ih erah loong tiit ah hephang dowa dook ih naririh ih jatjah halang, eno samthun tang, ngah ih uh naririh ih le nah phanlan raangthiin angbah ese ang ah eah. ");
INSERT INTO tvt_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ngah arah reelang ah langla an ih amiisak tiit nyootsoottu loong ah ejat toom et uh ih raangthiin hang. ");
INSERT INTO tvt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judia ni Hirod luungwang angtokdi, romwah wasiit heh men ah Jekaria, Abija lilih heh romwah esiit angta. Heh minuh men ah Elijabet angta; heh uh esiit romwah jaatang nawa angta. ");
INSERT INTO tvt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nengnyi Rangte miksok di toongtang lam ih songtong nyuuta Teesu Hootthe jengdang loong ah naririh et kap nyu ano ah. ");
INSERT INTO tvt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elijabet ah samuh nuh ang tungthoi nengnyi sah uh tajeeta, heh miwah Jekaria nyia heh ah ekuh ekaang ih nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Heh romhoonsa thok kohaano saasiit Jekaria ah Rangteenok ni reeraang paknaata. ");
INSERT INTO tvt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Romwah loong Hootthe jun ih Rangteenok ni phontumkaang tingtak suh jongteh tootoon rum adi Jekaria men chapta. Eno heh Teesu rangsoom nokmongni wangta ");
INSERT INTO tvt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","phontumkaang tingtak tok ah chang kano miloong ah taakkhuung ni rangsoom rumta. ");
INSERT INTO tvt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Erah di heh reeni Rangsah ah dongchap taha, jaawako romthong phontumkaang tingtakta rum adi ah. ");
INSERT INTO tvt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jekaria ih erah japtup ano paatjaata eno echo nep eta. ");
INSERT INTO tvt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Enoothong Rangsah rah ih heh suh liita, “Nakcho uh, Jekaria! Rangte ih an rangsoom chaat eta, an minuh suh no miwasah an raangtaan ih koh ah. An ih heh men ah Joon et men theng. ");
INSERT INTO tvt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Heh tupsa doh tumthan tenroonjih ang ah an raangtaan ih ah, erah damdoh wahoh loong uh tumthan ih tenroon ang ah! ");
INSERT INTO tvt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Joon ah Teesu miksok doh elong mina esiit ang ah. Heh ih kham naktoom mok jok ah. Heh phang doktup damdam heh ah Esa Chiiala pan ang ah, ");
INSERT INTO tvt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","eno heh ih Ijirel mina loong neng Teesu Rangte ko ih ngaak thoksiit ah. ");
INSERT INTO tvt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Khowah Elija likhiik ih heh uh Teesu nganah chaan aphaan lam ih ban kah ah. Heh ih hewah heh sah loong we jun songtong thuk rum ah; heh ih Rangte jeng daante loong asuh kateng lampo jatthuk ah; heh ih Teesu mina loong heh raangtaan ih ban khookham thiin ah.” ");
INSERT INTO tvt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jekaria ih Rangsah asuh liita, “Emah mok ang abah ngah ih mamet jat ang? Ngah ah teekaang nih nga minuh uh wikuh ih hoonla nih.” ");
INSERT INTO tvt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","“Ngah Gabrel,” Rangsah rah ih ngaakbaatta. “Ngah Rangte pandi chaplang, heh ih ngah an suh arah Ruurang Ese ah baat suh kaat thuk halang. ");
INSERT INTO tvt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Enoothong an ih nga jengkhaap ah tahanpi ko, heh rangwuung thok ha doh amiisak ih langte lek ang kano ah. Nga jengkhaap lahanpi thoidoh an tami jengko ang uh; ngah ih an damdi kakham hala ah amiisak maang langlang an suusu ih tong uh.” ");
INSERT INTO tvt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Erah tok adi miloong ah ih Jekaria ah ban sok ruh ih rum ano Rangteenok ni saatang tumjih thaam eha ih paatja rumta. ");
INSERT INTO tvt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jekaria dokkhoomha no neng damdi heh tami waanta, eno neng ih jat rumta Rangteenok nok ni mot amang hetupta eah. Khaapsiit uh lami dongjeng thoi heh lakthaak pamaak ih waan rumta. ");
INSERT INTO tvt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Heh Rangteenok ni rangsoom phansiit saapoot ah thoon ano, Jekaria heh nok ni ngaakwangta. ");
INSERT INTO tvt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Eno rekam ritdi heh minuh Elijabet rah heh sah dong wokta, eno laabanga heh nok nawa tadok khoomta. ");
INSERT INTO tvt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Heh ih liita, “Nga Teesu ih hethoondi kok chosok halang. Heh ih ngah noksong dung nah rakri theng taat angtang rah toonhaat ha!” ");
INSERT INTO tvt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elijaabet sah la arok wok adi Rangte ih Rangsah Gabrel Galili samnuh Najaret hadaang adi daapkaatta. ");
INSERT INTO tvt_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Heh ih jaalah esiit suh tiitkhaap baatjih angta, jaalah ah Dewid luungwang sutoom Josep damdi nook suh kakhat muicho angta. Heh men ah Meeri angta. ");
INSERT INTO tvt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Rangsah ah ra haano heh suh baatta, “Khooteng toomtong uh! Teesu an damdi heh ih romseetam koh halu!” ");
INSERT INTO tvt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meeri ih Rangsah jeng ah chaat ano rapne ih mongsaamta, eno erah jengkhaap ah tumjih suh liita ih paatjaata. ");
INSERT INTO tvt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Rangsah ih liita, “Nakcho uh, Meeri; Rangte ih an minchan ih halu. ");
INSERT INTO tvt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","An sah wokte anglu eno miwasah et tup uh, heh men ah Jisu et men uh. ");
INSERT INTO tvt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Heh ah elong angte eno heh suh Elong Echoong ni tongte Rangte sah et li ah. Teesu Rangte ih heh ah luungwang et hoon ah, heh te Dewid likhiik ah, ");
INSERT INTO tvt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","eno heh ah Jaakob sutoom dowa rootang raang ih luungwang ang ah; Heh hasong ah babah uh lathoon thang angte!” ");
INSERT INTO tvt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meeri ih Rangsah asuh liita, “Ngah roibaamuh jaalah boh ah. Erah mamah maami ang ah?” ");
INSERT INTO tvt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Rangsah ih ngaakbaatta, “Esa Chiiala an sak nah raaha, eno Rangte chaan ah ansak nah tong raaha. Erah raangtaan ih esa noodek asuh Rangte Sah et poon ah. ");
INSERT INTO tvt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","An sano Elijabet ah taat samthun thaak uh. Heh suh samuh nuh ih kaliitan ah, amadi heh sah la arok angla, wikuh ih hoon adi nep ah. ");
INSERT INTO tvt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Rangte lajen reejih tumjih uh tajeeka.” ");
INSERT INTO tvt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","“Ngah ah Teesu laksuh,” Meeri ih liita; “An ih baattu jun ih toom ang raaha nga sak nah ah.” Eno Rangsah ah mat khoomta. ");
INSERT INTO tvt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Erah lilih Meeri phangla ih kong akaan deek Judia ko nah kaat suh dokchapta. ");
INSERT INTO tvt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Heh Jekaria nok ni nop kah ano Elijabet suh jengseeraata. ");
INSERT INTO tvt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elijabet ih Meeri jengseeraata ah japchaat damdam, heh mong nawa noodek ah jaapmota. Elijabet ah Esa Chiiala pan angta ");
INSERT INTO tvt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","eno erongwah ih jengta, “An ah minuh loong dungni romseetam choh cho mina, erah dam ih an ih tupte noodek asuh uh romseetam choh cho! ");
INSERT INTO tvt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Arathan elong ah nga taang ni mame ang raak kohala, Teesu nuh anep nga jiinni jen chomui jih ah? ");
INSERT INTO tvt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","An jengseera ah japchaat damdam, nga mong nawa noodek ah nep roon ano wookla. ");
INSERT INTO tvt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Teesu jengkhaap ah ansak nah amiisak ih ang raaha ih hanpi thoidoh an tumthan ih tenroonte anglu!” ");
INSERT INTO tvt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meeri ih liita, “Nga ten ih Teesu ah phoong ha; ");
INSERT INTO tvt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","nga pangte Rangte suh nga la roonla, ");
INSERT INTO tvt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","tumeah heh ih ngah, ehin laksuh ah dokthun thoi ah! aadowa ih miloong ah ih ngah suh tenroon mina et poonhang, ");
INSERT INTO tvt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tumeah Chaan apaan Rangte ih nga raang ih elongthoon moot ah reekot thoih ah. Heh men ah Esa; ");
INSERT INTO tvt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","roosiit tokkhodi roosiit Heh ih heh soomtuute asuh minchan noisok ha. ");
INSERT INTO tvt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Heh ih chaan apaan pan lak ah janghaat ano engaam ete loong nyia neng tenthun mongtham ah phaang thukla. ");
INSERT INTO tvt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Heh ih chaan apaan luungwang loong ah neng tongtheng nawa dattong thuk ano; ehin loong ah toonjoh ah. ");
INSERT INTO tvt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Heh ih ramtekte suh phaksat ese koha, eno changteng loong ah lak huung daap haat ha. ");
INSERT INTO tvt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Heh ih sengte sengwah suh kakham thiinta rah reeta, eno heh laksuh Ijirel ah chosok ra hala. ");
INSERT INTO tvt_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Heh ih sengte Abraham nyia heh sutoom satoom loong asuh, rootang raang ih minchan noisokta ah samthunha!” ");
INSERT INTO tvt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meeri ah Elijabet damdi laajom roongtongta eno heh nok ni ngaakwangta. ");
INSERT INTO tvt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elijabet sah tup rangwuung thok haano, heh sah ah miwasah ih tupta. ");
INSERT INTO tvt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hekhuung hetok nyia heh joonte sano loong ah ih chaat rum ano Teesu suh tumthan ih seela ih phoong rumta, eno neng ah heh damdi rapne ih roong roon rumta. ");
INSERT INTO tvt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Noodek ah saasinet ang adi, neng ah khoopkhan banlam hoon suh ra taha, eno heh men ah Jekaria, heh lilih et men theng ih liirumta. ");
INSERT INTO tvt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Enoothong heh nuh ih liita, “Tah angka! Heh men Joon et men theng.” ");
INSERT INTO tvt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Eno neng ih heh nuh asuh baat rumta, “Enoothong erah bah ante anwah men tah angka!” ");
INSERT INTO tvt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Eno neng ih heh wah suh neng tokmoot damdi cheng rumta, an ih mamet men ih doh se ah ih thunhu. ");
INSERT INTO tvt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jekaria ih eraangtheng jonglo ah suh ano, raangta, “heh men ah Joon.” Eno mirep rapne ih paatja rumta! ");
INSERT INTO tvt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Erah tok adi Jekaria we mi dongjengta, eno Rangte rang ah phoongta. ");
INSERT INTO tvt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Hekhuung hetok joonte loong ah neng cho dongta, eno erah ruurang ah Judia hah kong akaan noongrep ni thok ruurang kata. ");
INSERT INTO tvt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Warep ih erah tiit ah chaat rum ano samthun rumleh cheng et rumta, “Arah noodek ah mamah ih dong hakte angla?” Tumeah heh sak ni Teesu chaan aphaan ah samkhikhih angta. ");
INSERT INTO tvt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Joon wah Jekaria ah Esa Chiiala pan angta, eno heh ih Rangte jengkhaap ah baatta: ");
INSERT INTO tvt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Seng Teesu ah phoong ih Ijirel Rangte rah ah! Heh mina loong pang raangtaan ih ra taha eno neng ah puipangta. ");
INSERT INTO tvt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Heh ih seng suh chaan aphaan pan Khopiipangte kojah hali, Heh laksuh Dewid sutoom dowa ah. ");
INSERT INTO tvt_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Heh ih teewadi esa khowah loong damdi thoom hoonta ");
INSERT INTO tvt_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Heh ih seng piiara nawa panghe, seng miksukte hang achaan nawa jen toonpang raang ih ah. ");
INSERT INTO tvt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Heh ih liita sengte sengwah loong ah heh ih tenthet et ah eno heh ih esa nuumiijeng ah dokthun ah. ");
INSERT INTO tvt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Sengte sengwah Abraham, suh kakhamta Heh ih seng piiara loong nawa pang et he eno seng ah heh mootkaat ah lacho thang ih moh thuk he, ");
INSERT INTO tvt_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","eno ba seng ah heh ngah nah esa nyi epun jen ang ih seng roidong tang ih ah. ");
INSERT INTO tvt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Nga sah, an ah, Elong Echoong Rangte khowah ih poonho. An Teesu nganah kah uno heh raangtaan ih lam ban tan kah uh, ");
INSERT INTO tvt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","heh mina loong suh neng rangdah loong ah biin anaan rum ano neng khopui tiit ah baat suh ah. ");
INSERT INTO tvt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Seng Rangte ah minchan nyia tenthet Rangte. Heh ih khopiiroidong ah rangsa phaakla likhiik ih phaak thukla, ");
INSERT INTO tvt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","eno rang nawa ih warep kaangtook ah laamang nyia etek lampo ni tongte loong rah ah, seng khooteng lampo nah khoom thuk raangtaan ih ah.” ");
INSERT INTO tvt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Noodek ah hansi nyia chiiala ni rongtangtang ih hakta. Ijirel noksong damdi chomui suh rangwuung maang thokthok Joon ah woma mong ni tongta. ");
INSERT INTO tvt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Erah tokdi Luungwanglong Agastas ih Roman noksong loongtang rookweh thuk ano neng men ah le ni raangthiin thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Erah phang raang et thukta tok adi, Siria hate Kobono ah Kurinus angta. ");
INSERT INTO tvt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Eno, warep ih neng teewah men ah, maama hah ni raangwan rumta. ");
INSERT INTO tvt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep ah Galili hah Najeret nawa, Dewid luungwang tup hadaang Judia hah Betlehem ni kata. Tumeah Josep ah Dewid sutoom angta. ");
INSERT INTO tvt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep ih Meeri heh suh nook raang ih kakhatta damdi, heh men ah wak raang wanta. Heh ah sakjih angta, ");
INSERT INTO tvt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","eno neng Betlehem ni ang tokdi, nootup rangwuung ah thok taha. ");
INSERT INTO tvt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Heh sah phangkhoh rah miwasah eh tupta, eno nyuh rah ih khoon ano maan tokkhuung ni jupthiinta naangjam nok laje thoi eah. ");
INSERT INTO tvt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Erah deek adi mararah saapriimte loong rangphe pheetang ih phek ni, neng saapsah loong ban sok rumta. ");
INSERT INTO tvt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Rangsah rah neng reeni dongchapta, eno Teesu chaan ah neng khothung ni phaakta. Eno neng ah rapne ih cho rumta, ");
INSERT INTO tvt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","enoothong Rangsah rah ih liirumta, “Nakcho an! Ngah aradi sen suh Ruurang Ese huijah halang, erah ih mina loongtang suh rapne tenroon thuk ah. ");
INSERT INTO tvt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Chiinyah Dewid hadaang ni sen pangte tupta—Teesu Kristo ah! ");
INSERT INTO tvt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Eno sen suh erah jatthuk han: sen ih noodek esiit nyuh ih khoon ano maan tokkhuung nah jupthiin arah tup an.” ");
INSERT INTO tvt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Baphuk ih heh damdi rangsah loong hantek ih rang nawa dong taha, eno boongkaat lam ih Rangte rangphoong rumta: ");
INSERT INTO tvt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Rangte chaan ah echoong thoon rangmong ni phaakjaaja, erah dam ih hah nah semroongroong ang thuk ah heh thunghaanla loong asuh ah!” ");
INSERT INTO tvt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Rangsah loong ah neng re nawa rang ni ngaakwangta adi, saapriimte loong ah neng chamchi ni waan rumta, “Betlehem nah kah ih no, erah ni tumjih angla Teesu ih baat tahe loong ah sokkah ih.” ");
INSERT INTO tvt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eno neng ah echaan ih Meeri nyia Josep reeni karum ano noodek ah maan tokkhuung ni jupthiin arah japtup karumta. ");
INSERT INTO tvt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Saapriimte loong ah ih heh ah sok rum ano, Rangsah ih noodek tiit tumjih baatta loong ah neng suh we toombaat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Saapriimte loong ih baatta rah japchaatte loong ah paatja ih rumta. ");
INSERT INTO tvt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Meeri ih erah loong tiit ah dokthun ano rapne ih samthunta. ");
INSERT INTO tvt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Saapriimte loong ah ngaakwang rum ano, neng ih tup rumta nyia chaat rumta loong asuh boongkaat damdi neng Rangte ah phoongpha rumta; erah ah rangsah ih mamet baat rumta jun ih angta. ");
INSERT INTO tvt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Saasinet lini noodek ah heh khoopkhan banlam hoontok thok kohaano, heh ah Jisu et men rumta, marah rangsah ih heh nuh mong ni maangje tokdi dook ban menta men rah ah. ");
INSERT INTO tvt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moses Hootthe ih baatta jun ih Meeri nyia Josep, sak saasiit hoon banlam saapoot ah thok ih taha. Eno nyi noodek ah Jerusalem hadaang ni Teesu suh baat kokaat suh huikaat nyuuta, ");
INSERT INTO tvt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","erah langla Teesu Hootthe ni raangthiin cho angta: “Warep ih ephangtup ela phokhothoon noodek ah Teesu suh kottheng.” ");
INSERT INTO tvt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Erah damdi nyi ih tokparusah enyi adoleh wotuupi enyi, Teesu Hootthe jun ih nyi siik hoon et koh nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Erah tokdi Jerusalem hadaang ni mih wasiit heh men ah Simoon songtongta. Heh ah wase nyia Rangte ra choote mina angta, eno Ijirel mina loong khopui suh heh ih Rangte ah ban sok ruh eta. Esa Chiiala ah heh damdi angta ");
INSERT INTO tvt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","erah dam ih heh suh Teesu ih thoomhoon cho Kristo ah maang tuptup an tatiiko ih kakhamta. ");
INSERT INTO tvt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Chiiala ah ih siit ano Simoon ah rangsoomnok ni wangta. Heh jaatang ih khobaang Jisu ah rangsoomnok ni Hootthe ih jamha jun ih piijah nyuuha di, ");
INSERT INTO tvt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoon ih noodek ah heh lakkhoni toonpi ano Rangte suh lakookmi liita: ");
INSERT INTO tvt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Teesu, an ih thoomhoon jengdang ah thiincho, eno an laksuh ah semroongroong et kaat thuk uh. ");
INSERT INTO tvt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nga mikmik ih an jiin dowa khopiiroidong ah tup ih hang, ");
INSERT INTO tvt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","marah an ih loongtang pandi hoon thiin tu rah ah: ");
INSERT INTO tvt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jehudi lah angte loong suh an tenthun ah jathuk suh weephaak ah phaak ah no an mina Ijirel loong tenroon ih phaakjaaja ang rum ah.” ");
INSERT INTO tvt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simoon ih Jisu tiit baatta ah chaat nyu ano heh nuh nyi wah ah paatja ih nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simoon ih nyi suh romseetam koh nyuuta no heh nuh Meeri, suh baatta, “Arah noodek ah Rangte ih danje cho Ijirel loong thet haat nyia khopiipang raangtaan ih ah. Heh ah Rangte mikthe ang ano warep mina ih heh thetbaatte totoh ang ah ");
INSERT INTO tvt_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","erah thoi ih neng husah tenthun loong ah dongjat ah. Eno an ten ah langtheh ih dook arah likhiik, sattiiti ih sat uh.” ");
INSERT INTO tvt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Teewadi khonuh wikuh, thaknuh heh men ah Anna, Ashir nok hate Phanual sah angta. Heh sawah suh nookta dowa ih paang sinet ba angta eno heh miwah ah tiita. Heh paang rook asat paang baji angta. Heh ih Rangteenok ah babah uh tathiin haatta; rangwuung rangphe heh Rangte rangsoom, nyi samurangsoom ih tongta. ");
INSERT INTO tvt_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Erah pootdi Anna thok haano Rangte suh jengseeraata. Eno Jerusalem ah Rangte ih piipang et ah ih bansokte loong asuh noodek tiit ah baatta. ");
INSERT INTO tvt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep nyia Meeri ih Teesu Hootthe ih jamta loong ah jen khom hoon thiin nyu ano, nyi hah Galili ni Najaret hadaang adi ngaak wang nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Noodek ah rongkopkop ih hakta; mongtham ese ah heh jiinni hantek angta, eno Rangte ih heh suh romseetam kota. ");
INSERT INTO tvt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Paang rookwih Jisu jaatang ah Khopui Kuwaang di Jerusalem ni bankah ruh kah ih rumta. ");
INSERT INTO tvt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisu asih paang nyi ih hak adi, neng erah kuh adi paang hoh dowa likhiik ih karumta. ");
INSERT INTO tvt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kuh ah thoon kano neng ah ngaak wang ih rumta, enoothong noodek Jisu ah Jerusalem ni tangtongta. Erah ah heh jaatang ih tajat rumta; ");
INSERT INTO tvt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","neng ih thunta heh ah sengdung ni eje heh angla eah, rah thoi neng henih nitang mokkhoom rumta eno Rekamdi neng joonte sano dung ni phang jam sok rumta. ");
INSERT INTO tvt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Neng ih Heh ah tajap jam rumta, erah thoih ih neng Jerusalem ni ngaakwang rum ano eni jam sokwang rumta. ");
INSERT INTO tvt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Saajom di neng ih heh ah Rangteenok ni japtup rumta, Jehudi nok hate nyootte loong damdi, neng jeng boichaat nyia neng suh chengphi damdi tong arah ah. ");
INSERT INTO tvt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Warep ih heh tiit chaatte loong ah epaatja ih rumta heh ih jatwah jenglam ih ngaakbaat rum kano ah. ");
INSERT INTO tvt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Heh nuh nyi wah ah doonmoot ih rumta heh ah tup rum ano ah, eno heh nuh ih liita, “Nga sah, an ih tumjih hoon wan halu? “Sek ah anwah ah rapne ih sootsaam thuk haliitih, an ah noongrep ni taat tum jam sok hiitih.” ");
INSERT INTO tvt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jisu ih ngaakbaatta, “Ngah set ih tumet suh jam sok hali tih? Set ih tanih jattansih ngah seng wah nok ni eah?” ");
INSERT INTO tvt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jisu ih ngaakbaat rumta ah neng ih tajen samjat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Eno Jisu ah neng damdi Najaret ni roong ngaakwangta, heh nuh nyi heh wah jeng chaatchaat ah. Erah di mamah angta erah loong ah heh nuh ih heh tenni lomthun ruh eta. ");
INSERT INTO tvt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisu ah hansi nyia ese mongtham ni choocho ih hakta, mina nyi Rangte uh heko ih roopta. ");
INSERT INTO tvt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Luungwanglong Teberius ih asih paang banga phansiit adi; Pontius Pilat ah Judia ni Kobono angta, Hirod ah Galili phansiitte angta, heh no Philip ah langla Ituria nyia Trakonite phansiitte angta; Lisania ah Abilini hadaang phansiitte angta, ");
INSERT INTO tvt_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","eno Annas nyia Kaiphas ah romwah phokhothoon ang nyuuta. Erah tokdi phisaang hah ni Jekaria sah Joon suh Rangte ih jengkhaap baatta. ");
INSERT INTO tvt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Eno Joon ih Jordaan Juungko ni Rangte tiit ah tumbaat kaatta, “Sen rangdah nawa ngaak hanno juungtem an, eno ba Rangte ih sen rangdah ah biin anaan han.” ");
INSERT INTO tvt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Erah ah khowah Isaia leedap ni raangthiin cho angta: “Mih phisaang hah ni riingla; ‘Teesu raang ih lam ban hoon thiin an; Heh khoomtheng lamjun ih tan an! ");
INSERT INTO tvt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Hoongbeng haleng loong ah ebook et ah, kong akaan loong ah hoongthung hane ih hoon ah. lam koongkot loong ah lamjun ih hoon ah, lamthih loong ah lamse ih hoon ah. ");
INSERT INTO tvt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Rangte jiin nawa khopiiroidong ah warep ih tup ah!” ");
INSERT INTO tvt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Miloong hantek Joon ih juungtem toom tem he ih ra rum taha. Joon ih liirumta, “Pu sen loong ah!” “O ih baat tahan Rangte ih echamnaang theng daapkaat ha dowa sen epui etheng eah? ");
INSERT INTO tvt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Rangdah nawa elek elang ih sen reeraang pakna nawa ih noisok anbah. Sen chamchi nah seng Abraham sutoom ih laklak nakwaan an. Abraham sutoom bah Rangte ih jong ah toon ano botseh jen hoon et ah! ");
INSERT INTO tvt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bang hehing nah joot haat suh chaang ah ban thiin et ha; hetiikmuh bang loong ah joot haat ano we nah haattak ah.” ");
INSERT INTO tvt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Miloong ih heh suh cheng rumta, “Erah ang abah, seng ih tumjih et theng ah?” ");
INSERT INTO tvt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Heh ih ngaakbaat rumta, “O di samsong enyi jeela esiit ah samsong mute suh kotjih, erah damdi o di phaksat jeela rah ih pheekot et theng.” ");
INSERT INTO tvt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mararah sokse seete nep juungtem ra taha, eno cheng rumta, “Nyootte, seng ih tumjih reejih ah?” ");
INSERT INTO tvt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Eno Joon ih baat rumta, “Sokse mathan seejih ah erah ba se an erah tokkhodoh ehan nak mook se an.” ");
INSERT INTO tvt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mararah sipaahi ih nep heh suh cheng rumta, seng ih aleh? Tumjih etjih ah? Heh ih baat rumta, “Mih dowa ngun chaan ih nakmok suh an adoleh mih lathika doh ethih etu ih nak nan an. Sen ngun la di mathan cholan erah suh roon an.” ");
INSERT INTO tvt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mina loong ah ih choocho ih dong laalom rumta, eno neng ih Joon asuh Kristo tam angla ih thun rumta. ");
INSERT INTO tvt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Eno Joon ih loongtang suh baat rumta, “Ngah ih juung nawa ih juungtem rumhala, enoothong nga lini mih wasiit nga nang ih elong raaha. Ngah bah heh lakhoop pak taajoh tha uh taliikang. Heh ih bah Esa Chiiala nyia we nawa ih juungtem han. ");
INSERT INTO tvt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Heh jiinni nunrek je ah, erah ih raan ah dannun ano pung nah toonthiin ah, eno hephaang loong ah we nah babah uh lamettheng adoh tak ah.” ");
INSERT INTO tvt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Joon ih hejaat hejaat lam nawa ih miloong asuh Ruurang Ese ah nyootsoot leh neng roidong ah elek raangtaan ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Enoothong Joon ih Kobono Hirod asuh liita, tumeah heh ih Hirodias heh no minuh ah, kapta, erah damdi uh ethih loong ephoop reeta. ");
INSERT INTO tvt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hirod ih Joon ah phaatak ni sakta rah boot thetreeta. ");
INSERT INTO tvt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Miloong juungtem lini, Jisu ih nep heh juungtem ah we temta. Heh ih rangsoom adi, rang kaasak ah daap eta, ");
INSERT INTO tvt_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","eno Esa Chiiala ah hansi ni wotuupi likhiik heh khothung ni datpura taha. Eno rang ni root esiit dongjengta, “An ah nga mongnook sah. Ngah an suh eroon elang.” ");
INSERT INTO tvt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisu heh mootkaat phangmota tokdi, Heh ah paang rookjom taan angta. Heh ah miwasah, erah raang ih miloong ih, Josep sah ih thunta, Josep ah Heli sah angta, ");
INSERT INTO tvt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ah Mathat sah, Mathat ah Leewi sah, Leewi ah Melki sah, Melki ah Jannai sah, Jannai ah Josep sah, ");
INSERT INTO tvt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep ah Mattathias sah, Mattathias ah Amos sah, Amos ah Nahum sah, Nahum ah Esli sah, Esli ah Naggai sah, ");
INSERT INTO tvt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai ah Maath sah, Maath ah Mattatthias sah, Mattatthias ah Semin sah, Semin ah Joseek sah, Joseek ah Joda sah, ");
INSERT INTO tvt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ah Joonan sah, Joonan ah Resa sah, Resa ah Jerubabel sah, Jerubabel ah Siltiel sah, Siltiel ah Neri sah, ");
INSERT INTO tvt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ah Melki sah, Melki ah Addi sah, Adidi ah Kosam sah, Kosam ah Elmadiam sah, Elmadiam ah Er sah, ");
INSERT INTO tvt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ah Josua sah, Joshua ah Eliijer sah, Eliijer ah Jorim sah, Jorim ah Matthat sah, Matthat ah Leewi sah, ");
INSERT INTO tvt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leewi ah Simoon sah, Simoon ah Judah sah, Juda ah Josep sah, Josep ah Joonam sah, Joonam ah Elaikim sah ");
INSERT INTO tvt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaikim ah Melea sah, Melea ah Menna sah, Menna ah Mattatha sah, Mattatha ah Nathan sah, Nathan ah Dewid sah, ");
INSERT INTO tvt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dewid ah Jiisi sah, Jiisi ah Obed sah, Obed ah Booj sah, Booj ah Salmon sah, Salmon ah Nason sah, ");
INSERT INTO tvt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ah Aminadab sah, Aminadab ah Admin sah, Admin ah Arni sah, Arni ah Hejron sah, Hejron ah Perej sah, Perej ah Judah sah ");
INSERT INTO tvt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda ah Jaakob sah, Jakob ah Isak sah, Esak ah Abraham sah, Abraham ah Terah sah, Terah ah Nahor sah, ");
INSERT INTO tvt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ah Serug sah, Serug ah Reu sah, Reu ah Peleg sah, Peleg ah Eber sah, Eber ah Sela sah, ");
INSERT INTO tvt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela ah Kiinan sah, Kiinan ah Arphaksad sah, Arphaksad ah Sem sah, Sem ah Nuah sah, Nuah rah Lameek sah, ");
INSERT INTO tvt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameek ah Methuselah sah, Mathuselah ah Enook sah, Enook ah Jared sah, Jared ah Mahalalil sah, Mahalalil ah Kenan sah, ");
INSERT INTO tvt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ah Enosh sah, Enosh ah Seth sah, Seth ah Adam sah, Adam ah Rangte sah. ");
INSERT INTO tvt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisu Jordaan juung nawa Esa Chiiala pan ih ngaakwang taha eno moong achaang ih phisaang hako ih siit kaatta, ");
INSERT INTO tvt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","erah di heh saarookbaji Hakhoh juungbaan ih phate kaatta. Erah tokdi heh ih tumjih taphaksata, erah raangtaan ih hethoon sa adi heh ah ramtek angta. ");
INSERT INTO tvt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Hakhoh juungbaan ah ih liita, “An Rangte sah anglu bah, arah jong ah baanlo et hoon thuk thaak uh.” ");
INSERT INTO tvt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Eno Jisu ih ngaakbaatta, “Rangteele ni liiha, ‘Mina ah phaksat nawa ih laklak tathingka.’” ");
INSERT INTO tvt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Eno hakhoh juungbaan ah ih kongchoong ko ih siitwan ano mikkhojaap siit di mongrep hasong loong ah sok thukta. ");
INSERT INTO tvt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Nga ih an suh arah loong chaan nyia nyamka ah koha,” Hakhoh juungbaan ih heh suh baatta. “Arah loong ah ngah suh kotahang, eno nga ih o suh thunghaan ang erah suh ejen kot et ang. ");
INSERT INTO tvt_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Loongtang arah loong ah an raangtaan ang ah, an ih nga soomhang bah ah.” ");
INSERT INTO tvt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisu ih ngaakbaatta, “Rangteele ni liiha, ‘An Teesu Rangte rang aba soom uh eno heh raangtaan ih laklak ba moh uh!’” ");
INSERT INTO tvt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Erah lidi Juungbaan ah ih Jerusalem ni siitkaat ano Rangteenok nok khochoom thoon adi, siitwan ano baatta, “An Rangte Sah ang ubah, aadowa an teeteewah taat pit thaak uh. ");
INSERT INTO tvt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tumeah Rangteele ni amet liiha, ‘Rangte ih Rangsah loong asuh an ese tham ih ban kooncha thuk suh baat ah eah. ");
INSERT INTO tvt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Erah di amah nep et liiha, ‘Rangsah loong ih an neng lak ih banjoh hoono an lah taan uh jong nah tajap satnak thuk ru eah.’” ");
INSERT INTO tvt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Enoothong Jisu ih ngaakbaatta, “Rangteele ni liiha an Teesu Rangte ah an ih nak taari uh.’” ");
INSERT INTO tvt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Juungbaan ih Jisu ah jaatrep lam nawa ih jen joonnaam phate ano, heh erah dowa pootsiit raangtaan ih dokkhoom kata. ");
INSERT INTO tvt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Eno Jisu Galili ni ngaakwangta, Esa Chiiala moong achaang ah heh damdi angta. Heh tiit ah harep ni ruurangta. ");
INSERT INTO tvt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Heh ih Jehudi rangsoomnok ni nyootsoot rumta eno warep ih guuta. ");
INSERT INTO tvt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Erah lidi Jisu ah heh haktheng hadaang Najaret adi wangta, erah damdi Jehudi naangtongsa adi saahoh dowa likhiik Jehudi rangsoomnok ni wangta. Heh ih Rangteele ah wet suh toonchapta ");
INSERT INTO tvt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","eno khowah Isaia leedap ah heh suh kota. Heh ih Rangteele ah ja ano marah di raangta erah ah japtupta, ");
INSERT INTO tvt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Teesu Chiiala ah nga damdi, tumeah heh ih ngah ah changthih loong suh Ruurang Ese baatkaat suh danje tahang. Ekhak eha loong daap haat tiit ah baat suh daapkaat tahang nyia edook loong suh neng mik ih japtup thuk suh, mih lakhu ni chamte loong ah pang raangtaan ih ah ");
INSERT INTO tvt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nyia saapoot ah chang ela ih baat suh daap tahang erah saadoh Teesu ih heh mina loong ah epang et ah.” ");
INSERT INTO tvt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Eno Jisu ih Rangteele ah khoon ano, heh jeng chaatte asuh ngaak koh, ano tongta. Jehudi rangsoomnok nawa miloong ih heko totoh ih sok rumta, ");
INSERT INTO tvt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","eno heh ih neng suh baatta, “Arah Rangte jengkhaap ah chiinyah amiisak ih thok hala, erah wetang adi boichaat tan rah ah.” ");
INSERT INTO tvt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Neng ah heh suh rapne ih seechoh rumta heh jengkhaap ah laangpopoh ih chaat rum ano epaatja nep ih rumta. Eno liirumta, “Arah Josep sah ah tam angla?” ");
INSERT INTO tvt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Heh ih neng suh baatta, “Ngah ih jat ehang sen ih arah tiitthaak ah ngah suh nyootbaat ette, ‘Phonwah, ih an teeteewah deesiit uh.’ Sen ih Kapernum ni japchaat tan ah likhiikkhiik ngah suh uh arah nga hadaang adoh re thuk suh baat ette ang hali. ");
INSERT INTO tvt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ngah ih arah baat rumhala, Jisu ih boot baatta, “Khowah ah heh hadaang nah babah uh taseechoka.” ");
INSERT INTO tvt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Nga jeng ah boichaat an: arah amiisak tiit Elija tokdi Ijirel ni thaknuh ephoop angta, paang jom paangthom rangphaat laphaat thang angta adi ah nyia harep ni ramkhah angta tok adi ah. ");
INSERT INTO tvt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ang abah uh Elija rah Ijirel ni o reeni uh takaat thukta, Sidoon juungkhuung Jarephat hadaang dowa thaknuh jiin adi luulu ba kata. ");
INSERT INTO tvt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Erah damdi eni engam loong ephoop angta Ijirel ni khowah Elisa angta tokdi ah; ang abah uh o uh tade rumta, Siria nawa Naaman luulu ba deeta.” ");
INSERT INTO tvt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jehudi rangsoomnok nawa miloong ih erah chaat rum ano, neng ah ekhat ih rumta. ");
INSERT INTO tvt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Neng ah toonchap rum ano, erah samthung dowa Jisu ah dok hoom kaat rumta, eno samthung kongchoong ni angta dowa kaang adoh dat haat suh ih thun rum ano taat hoom wan rumta, ");
INSERT INTO tvt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ang abah uh Jisu ah miloong laktung adi dokkhoom ruh ih kata. ");
INSERT INTO tvt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Eno Jisu ah Galili ni Kapernaum samthung adi kata, Jehudi naangtongsa adi Heh ih miloong asuh nyootsoot rumta. ");
INSERT INTO tvt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Heh ih nyootsoot karumta asuh miloong ah rapne ih paatja rumta, tumeah heh ih chaan aphaan lam ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jehudi rangsoomnok ni Chiithih laakhah pan mih wasiit angta; heh erongwah ih riinghuungta, ");
INSERT INTO tvt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aah! Tumjih et he seng ah, Najaret nawa Jisu oh? An aadi seng thet haatte nih ah? An o ah nga ih jat ehala: an ah Rangte Esa kongphaak huite!” ");
INSERT INTO tvt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisu ih Chiithih laakhah asuh baatta, “Nak hoopti uh arah wah sak dowa suusu ih dokkhoom ho!” Laathih rah ih mih ah neng ngathong ni loonghaat thiin ano tumjih uh lah et thang heh sak dowa doksoon kata. ");
INSERT INTO tvt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Miloong ah rapne ih paatja rum ano neng chamchi ni waan rumta, “Arah tumjaat jengkhaap ah? Arah mih rah ih chaan aphaan lam ih laathih asuh baat kano, neng loong ah doksoon karum arah ah!” ");
INSERT INTO tvt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Eno Jisu tiit ah erah hah adi noongrep ni ruurang kata. ");
INSERT INTO tvt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisu ah Jehudi rangsoomnok nawa dokkhoom ano, Simoon nok ni kata. Simoon hopnuh ah sokwi ih rapne satta, eno neng Jisu damdi erah nuh tiit ah roongwaan rumta. ");
INSERT INTO tvt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jisu ah heh reeni chap wang ano sokwi khoisat ah dokphanta. Sokwi ah laan de ruh eta, eno erah damdam heh ah laan saatsoon ruh eta, eno neng suh phak asat nep jamjaang korumta. ");
INSERT INTO tvt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Rangsa lup lini loongtang ih neng joonte hephan dowa khoisatte loong ah Jisu reeni thutsiit jarum taha; warep sak ni heh lak ih taajoh leh deesiit et rumta. ");
INSERT INTO tvt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Laathih loong ah uh warep sak nawa doksoon leh riinghuung erumta, “An juuba Rangte sah ah!” Jisu ih laathih loong ah tajeng thuk rumta, tumeah neng ih jat et rumta heh ah Kristo eah. ");
INSERT INTO tvt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Erah saalih rangkhano di Jisu erah hah dowa hatik ni kata. Miloong ah ih heh ah laan matjam ruh et rumta, eno neng ih japtup rum ano heh ah lakaat thuk suh thun rumta. ");
INSERT INTO tvt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Enoothong heh ih baat rumta, “Ngah ih Ruurang Ese Rangte Hasong tiit ah hahoh nah nep uh ebaatjih jaatjaat, tumeah erah raangtaan ih Rangte ih ngah ah kaat thuk tahang.” ");
INSERT INTO tvt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Erah raang ih heh ih Jehudi loong rangsoomnok harep ni Rangte tiit ah baatta. ");
INSERT INTO tvt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Saasiit Jisu Genisaret juungsitum kaang ni chap adi miloong ah heh reeni Rangte tiit chaat suh tuutmui rumta. ");
INSERT INTO tvt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Heh ih khoonkhuung enyi juungkaang ni chaakwah loong ih neng chaak saachot kaat pootdi hoomthiin arah japtupta. ");
INSERT INTO tvt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Khoonkhuung esiit adi Jisu ah dung tongta—erah langla Simoon Khoonkhuung angta—eno heh suh amasah juungko nah hengtuut suh baatta. Jisu ah Khoonkhuung adi tong ano miloong asuh nyootsootta. ");
INSERT INTO tvt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Heh ih jen thoon nyootsoot rum ano, Simoon suh baatta, “Khoonkhuung ah juungsitum echoong koh et tuut uno, an joonte loong damdoh nyah joot suh chaak ah ha an.” ");
INSERT INTO tvt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Nyootte, “Simoon ih ngaakbaatta, “Seng ih pheetang taat haati takapke. Ang abah uh an ih li ubah, ngah ih eha et ang.” ");
INSERT INTO tvt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Neng ih chaak ah haata eno nyah loong ah hantek ih chaak laan ranpat ruh taantaan ih nyaanta. ");
INSERT INTO tvt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Erah raang ih neng ih khoonkhuung esiit dowa neng joonte ah neng lak khoh ih jap rum ano nyah loong ah roong joot thuk suh poon rumta. Neng wangrum taha adi nyah loong ah khoonkhuung nep luppat arah ih meeta. ");
INSERT INTO tvt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Eno Simoon Pitar ih tumjih angta rah loong ah sok ano, Jisu ngathong ni heh lakuh di tong ano baatta, “Nga re nawa hengkhoom uh, Teesu! Ngah rangdah mina!” ");
INSERT INTO tvt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoon nyia heh joonte loongtang rapne ih paatja rumta nyah loong hantek ih kap rum ano ah. ");
INSERT INTO tvt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simoon joonte Jebidi sah Jeems nyia Joon, uh paatja ih nyuuta. Jisu ih Simoon suh liita, “Nakcho an; adowa ih bah sen ih mina joh an.” ");
INSERT INTO tvt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Neng ih Khoonkhuung ah juung saangkook ni hoomthiin rumta, jirep thiinhaat rum ano Jisu lini roong phankhoom rumta. ");
INSERT INTO tvt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Saasiit Jisu samthung esiit ni ang adi mih wasiit engam angta. Eno heh ih Jisu ah tup ano, heh lakuh di kotbon ano liita, “Chuupha, an ih thunhang bah, saatsiit weehang!” ");
INSERT INTO tvt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisu ih heh lak ah janghaat ano taajota. “Ngah ih an deesiit suh thun ehala,” Heh ih liita. “De uh!” Erah damdam erah wah ah laan de ruh eta. ");
INSERT INTO tvt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisu ih heh suh baatta, “O suh nak baat uh, erah nang ih bah romwah jiinnah phangla ih kah uno heh ih toomhuk sokje ho; eno ba mih ih de etu ih jat ho, Moses ih baatta jun ih an khosa ah koh et kaat uh.” ");
INSERT INTO tvt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ang abah uh Jisu ruurang ah noongrep ni ehan han ih huk ruurang katta, eno miloong hantek heh jeng boichaat suh nyia neng khoisat de thuk suh lomthok rum taha. ");
INSERT INTO tvt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ang abah uh Jisu ah, hatik ni rangsoom dokkhoom kata. ");
INSERT INTO tvt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Saasiit Jisu ih nyoot rum adi, mararah Pharisi nyia Hootthe Nyootte loong erah di roongtongta Galili samthung nyia Judia nawa eno Jerusalem nawa ra rumha rah ah. Teesu chaan ah Jisu damdi mih khoisat deesiitjih eje angta. ");
INSERT INTO tvt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mararah mina ih hiimuung juptheng ni thokpi rum taha, eno neng ih nokmong ni noppi leh Jisu ngathong adoh thiinwan suh taatthun rumta. ");
INSERT INTO tvt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mih hantek ang tungthoidi, nokmong nah noppi suh lam tachoh rumta. Erah raangtaan ih neng ih nok khoni piiwan rum ano poohoom rum ano, juptheng pan ih miloong laktung Jisu ngah thong adi datthiin rumta. ");
INSERT INTO tvt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisu ih neng erathan tuungmaang rumta ah sok ano, heh ih mih asuh liita, “Nga joonwah, an rangdah loong ah biin anaan et halu.” ");
INSERT INTO tvt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hootthe Nyootte nyi Pharisi loong ah neng mongmong ni phang huthun rumta, “Arah mih ah o angla Rangte kaanju tiit baat ha! Rangte luulu baalek ah mih rangdah jen biin anaante ah!” ");
INSERT INTO tvt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisu ih neng tenthun ah jat ano baat rumta, “Sen ih emah tumet suh thunhan? ");
INSERT INTO tvt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘An rangdah ah biin anaan et taho,’ ih baat ah elaang nih ang ah, adoleh ‘Saat uno khoom uh’ ih baat ah elaang nih ang ah? ");
INSERT INTO tvt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ngah ih sen suh ejat etthuk rumha, erah ang abah ah, Mina Sah adi arah hah dowa mih rangdah jen biin anaan theng chaan eje eah.” Eno heh ih hiimuung wah asuh baatta, “Ngah ih baat hala, saat uh, an juptheng ah toonpi uno an nok nah wang uh!” ");
INSERT INTO tvt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Erah damdam erah mih ah neng ngathong ni toonchapta, heh juptheng ah toonpi ano, heh nok ni Rangte ah phoongpha ano wangta. ");
INSERT INTO tvt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Neng ah loongtang rapne ih paatja rumta! Echo damdi neng ih Rangte rangphoong rumta, “Chiinyah tumthan epaatja jih seng ih japtup hi!” ");
INSERT INTO tvt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Erah lidi, Jisu dokkhoom kah adi, sokse seete wah heh men ah Leewi, apit ni tong arah japtup kata. Jisu ih heh suh baatta, ‘Nga lih ah phanhang.” ");
INSERT INTO tvt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leewi ih jirep thiinhaat ano, heh lilih ih roong toonkhoomta. ");
INSERT INTO tvt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Eno Leewi ih heh nok ni kamkam saroom ih hoon ano Jisu ah poonta, eno wen loongdung adi sokse seete loong nyi wenhoh loong hantek angta. ");
INSERT INTO tvt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mararah Pharisi nyia Hootthe Nyootte loong ih Jisu liphante loong suh cheng rumta “Sen ih sokse seete nyia rangdah mina loong damdi mamet phaksah han?” Neng ih chengta. ");
INSERT INTO tvt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisu ih ngaakbaat rumta, “Mih eseete ih Phonwah ah tajamka, khoisatte ih ba jam ah. ");
INSERT INTO tvt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngah ih jatwah loong ah elek toom ih rum ah ih tapoon ra rumrang, erah nang ih bah rangdah mina loong poon ra halang.” ");
INSERT INTO tvt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mararah mih ih Jisu suh liita, “Joon liphante nyia Pharisi liphante loong ah uh samurangsoom etong rumla; enoothong an liphante loong ah ih jok phaksah ruh et rumha.” ");
INSERT INTO tvt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisu ih ngaakbaatta, “Sen ih kuhoon sa doh jalakapte wah pandoh wen loong ah samuh ngaakdaap ah ih nih thunhan? Emah tah angka! ");
INSERT INTO tvt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Enoothong kuhoonte warah neng re nawa toonsiit wan saakaan ah thok eha, eno erah doh ba neng samurangsoom tong ah.” ");
INSERT INTO tvt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisu ih arah tiitthaak tiit nep wakbaatta: O eh uh samsong ena rah ehak nah loopphing suh tajopcheeka. Emah mok et abah, heh ih samsong ena rah jopche etjih ang ah, eno ena lep ah ehak samsong damdoh tajunka ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Erah damdoh o eh uh kham na ah siikhoop tiikook ehak nah tasakka, tumeah kham na rah ih tiikook ehak ah eraapphok etthuk ah, eno kham ah emat jan eah, eno tiikook ah thih ah. ");
INSERT INTO tvt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Erah thatnang ih bah, kham na rah tiikook ena nah thiintheng! ");
INSERT INTO tvt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Erah damdi sen ih kham hak jok cho doh kham na ah tajam kan ang an. ‘Ehak ah seela,’ ih sen ih li an. ");
INSERT INTO tvt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jehudi naangtongsa di Jisu ah phek ni chamtong ko ih tumkhoom kata. Heliphante loong ah ih raanteh ah thi rum ano, neng lak ni saasek leh, phak et rumta. ");
INSERT INTO tvt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mararah Pharisi loong ih cheng rumta, “Sen ih tumjih et han seng Hootthe jun ih naangtongsa doh sen emah tajen re kan?” ");
INSERT INTO tvt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisu ih ngaakbaat rumta, “Dewid nyia heh joonte loong ih neng ram ih ti rumta adi tiim et rumta rah sen ih tanih wetan? ");
INSERT INTO tvt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Heh Rangteenok ni wang ano, Rangte suh kota baanlo ah toonphakta, eno heh mina loong suh nep kota. Erah uh seng Hootthe jun ih emiit angta, o mina reh uh tajen phaksata romwah ih luulu ba phaksata. ");
INSERT INTO tvt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Eno Jisu ih thoonbaatta, “Mina Sah rah naangtongsa raang ih Teesu.” ");
INSERT INTO tvt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Naangtongsa saahoh di Jisu ah Jehudi rangsoomnok ni kah ano nyootsoot rumta. Erah ni jaawako lakkoong ang arah mih wasiit angta. ");
INSERT INTO tvt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mararah Hootthe Nyootte nyia Pharisi loong ih Jisu ah tumjih doh lasah thetre ah ih thun rumta, erah thoidi naangtongsa doh mih maamok deesiit jaoh ih dangdang et ban sok rumta. ");
INSERT INTO tvt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Enoothong Jisu ih neng tenthun ah jat ano mih wasiit suh baatta, “Chap uh, ngakhoh ko ih raaho.” Eno erah wah ah toonchapta. ");
INSERT INTO tvt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Eno Jisu ih baat rumta, “Ngah ih cheng rumhala: seng Hootthe jun doh naangtongsa doh tumjijih ah jen re thuk he? Epang tam ah, ethet haat ah? Mih roidong ah epang tam ethet haat ah?” ");
INSERT INTO tvt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Heh ah nengko ni lengsok ano heh lakkoong wah asuh baatta, “An lak ah janghaat uh.” Eno heh lak ah janghaat kano ese we ih ngaak hoonta. ");
INSERT INTO tvt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Neng loong ah neng the ah saanghaat rum ano khah rumta eno neng chamchi ni waan rumta Jisu ah mamet ih eah. ");
INSERT INTO tvt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Erah tokdi Jisu kongchoong ni wang ano Rangte rang pheetang ih soomwangta. ");
INSERT INTO tvt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Rang ah wuung ano, heliphante loong ah heh reeni lompoon ano neng dung nawa asih wanyi danjeeta, heh ih erah loong men ah kaamwah et menta: ");
INSERT INTO tvt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoon (Heh ih Pitar et menta) erah damdi heh no Endriu; Jeems nyia Joon, Philip nyia Batholomi, ");
INSERT INTO tvt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mathiu Thomas, Jeems ah Alphaeus sah, erah damdi Simoon (hadaang pangte ih poonta), ");
INSERT INTO tvt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ah Jeems sah, erah damdi Judas Iskerot, mih khuumtante ih hoonte warah ah. ");
INSERT INTO tvt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisu kong nawa heh kaamwah loong damdi dat ra rumha di, heliphante hantek loong damdi hathung ni roong chapta. Miloong hantek erah di Judia hah noongrep nawa, Jerusalem nawa erah damdi juungkaang ko niiwa Tairi nyia Sidoon samnuthung dowa; ");
INSERT INTO tvt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","neng heh jeng boichaat nyia neng khoisat deesiit thuk suh thok rum taha. Chiithih laakhah ih paklakte loong anep ra rum taha enooleh de ih rumta. ");
INSERT INTO tvt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Warep ih heh sak nah taajoot totoh thun rumta, tumeah heh sak nawa chaan kala rah ih mirep deetsiitta. ");
INSERT INTO tvt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisu ih heliphante loong ko ih sok ano liita, “Changthih loong ah tenroon ang an; Rangte Hasong ah sendi! ");
INSERT INTO tvt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Amadi ramtekte loong ah tenroon ang an; sen suh ekot et han! “Amadi ehuungte loong ah tenroon ang an; sen engit ean! ");
INSERT INTO tvt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mina Sah tungthoidoh, sen mih ih miksuk halan, dut haat halan, kaanju ih halan, nyia ethih li halan adoh tenroon ang an! ");
INSERT INTO tvt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Erah saakkaan ah thok ha doh sen tenroon lam ih wook anno boong an, tumeah sen raangtaan ih elong thaangchojih Rangmong Hasong ni thiinha. Nengte nengwah ih uh emamah Rangte tiitbaatte loong damdi thetre rumta. ");
INSERT INTO tvt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Enoothong amadi nyamte loong asuh tumthan echoojih ang ah; sendi tenroon roidong ah elang eta! ");
INSERT INTO tvt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Amadi laboot beete loong asuh tumthan echoojih ang ah; sen ramtek tok ethok eha! “Amadi engitte loong asuh tumthan echoojih ang ah; sen ehuung nyia moongjoong ean! ");
INSERT INTO tvt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mina ih ese ih liite loong asuh tumthan echoojih ang ah; nengte nengwah reh uh emoong tiitbaatte suh emamah et li rumta. ");
INSERT INTO tvt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Enoothong nga jeng boichaatte suh baat rumhala: sen piiara ah mongnook et an, sen miksukte damdoh ese ih re an, ");
INSERT INTO tvt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","sen tamte loong asuh romseetam koh an, sen siiwiite asuh rangsoom koh an. ");
INSERT INTO tvt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","O ih bah uh an the nah buh ho bah haangko the adoh we wak buh thuk uh; o ih bah uh an samsong toon ah, erah suh samsong ehoh bootkoh uh. ");
INSERT INTO tvt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mih ih an dowa tumjih suho erah kot et uh, erah damdoh mih ih an hukkhaak toon abah, nakmok ngaaksuh uh. ");
INSERT INTO tvt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mih ih an suh mame reekot theng ih jam hu emamah an ih mih suh reekoh uh. ");
INSERT INTO tvt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“An mongnook halu mina damdam adoh mongnook ubah, romseetam ah mamah ma ih choh uh? Emah bah rangdah mina loong bah lengkot mui rumla, hephoopho thaang ah we ngaakchosuh ah! ");
INSERT INTO tvt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ese reeraang ah an damdi ese reete loong damdam adoh mok re ubah, romseetam ah mamah ma ih choh uh? Emah bah rangdah mina loong reela! ");
INSERT INTO tvt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","An suh jen ngaakthemte ah sok uno luulu nam koh ubah, romseetam ah mamah ma ih choh uh? Erah thaang thaang ah ngaakchosuh bah, rangdah mina loong nep nam kotmui rumla! ");
INSERT INTO tvt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Emah tah angka! Senpi senra loong ah mongnook anno neng damdoh ese ih re an; enam kot et an, eno engaak choh nak thuntak an. Eno ba sen thaang elong ah choh an, nyia sen ah Echoong Thoon Rangte suh asah ang an. Tumeah Heh ah lajak nyia jengse lajengte loong raangtaan ih uh ese. ");
INSERT INTO tvt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sen Wah tenthet jeela likhiik tenthet mina ang an. ");
INSERT INTO tvt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mihoh nak dande an, eno ba Rangte ih uh sen tadande ran; mihoh nak dut haat an, eno ba Rangte ih uh sen tadut haat ran; mih biin anaan et an, eno ba Rangte ih uh sen biin anaan et han. ");
INSERT INTO tvt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mih suh ekot et an, eno ba Rangte eh uh sen suh kohan. Amiisak ih, sen ehan ih ngaakchoh an, mih chosok thaang rah ah, sen ih mathan jenthaang an erathan—sen lak nah keekoja han. Marah saanthaak sen ih wahoh suh maak han erah saanthaak dowa ih Rangte ih sen ah maak han.” ");
INSERT INTO tvt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Eno Jisu ih arah tiitthaak ah baat rumta: “Edook wasiit ih mihoh edook ah tami siitka; emah mok ang abah, wanyi nyi beng nah ba dat nyu ah. ");
INSERT INTO tvt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","O Leewette noodek ah Nyootte nang ih ejat tami angka; enoothong noodek thoontang ih, neng suh nyootsootta ah jen jat rumta no ba, Nyootte likhiik neng ejen lang erum ah. ");
INSERT INTO tvt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Sen mik dowa bangtan ah lasamthun thang ih, Sen joonte mikmaang ehinsah ah mamet jam sok han? ");
INSERT INTO tvt_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Sen ih mamet mi li sen joonte suh ah, an mikmaang ah beeha, senteewah mik dowa bangtan ah laphang miisok kanbah ah? Sen lonoite loong! Sen mik dowa bangtan ah chaak dok haat anno ba sen pho senno mikmaang ehin ah samseksek mi samsok an, eno ba mi beek haat an. ");
INSERT INTO tvt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Bang se adoh tiikthih tatiikka, eno bangthih adoh uh tiikse tatiikka. ");
INSERT INTO tvt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bang ah hetiik tiikla dowa ih ba danjat ha; an ih puksak tiik ah subang nawa tachoh thiiko adoleh anggut tiik ah woma bang nawa tachoko. ");
INSERT INTO tvt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mina eseete ih heten hemong ni ese loong lomthiin ha dowa dong re ah; ethih mina rah ih heten hemong ni ethih lomthiinha ah dong noisok ah. Tumeah ten among ni tumjih jeela tuikhoop ni erah dongjeng ra hala. ");
INSERT INTO tvt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ngah ih baat rumhala lare thang di ngah ah Teesu, Teesu,’ ih tumet suh poon hali? ");
INSERT INTO tvt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","O bah uh nga re nah thok haano nga jeng ah boichaat ano kap ah—eno erah mih ah mamah ang ah, ngah ih noisok rumha. ");
INSERT INTO tvt_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Heh ah arah likhiik ang ah, o ih heh nok jong hah nah, halup ih thoh ano hoon arah likhiik ang ah. Juung ah nuung ano liim abah uh tamoka ang ah, tumeah erah rongkopkop ih hoonta. ");
INSERT INTO tvt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Enoothong o ih bah uh nga tiit ah chaat ano laphanka bah erah ih heh nok naririh jong hah ni lahoonka likhiik ang ah; eno erah nok ah juungnuung tak ih sot kano laan rungdat ruh eah—eno tumthan echoojih ih bundat ah!” ");
INSERT INTO tvt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisu ih erah loong tiit ah miloong asuh thoonbaat ano, heh Kapernum ni katta. ");
INSERT INTO tvt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Erani Roman saahaap laksuh heh rapne ih mongnook arah esiit angta; erah mih rah rapne ih sat ano etek nanah angta. ");
INSERT INTO tvt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Saahaap rah ih Jisu raak ah chaat ano, heh ih mararah Jehudi mihak suh heh laksuh ah toom deesiit raaha ih poonkaat thukta. ");
INSERT INTO tvt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Neng loong ah Jisu jiinni ra rumha no heh lasih joot lam ih baat rumta, “Arah mina abah an ih chosok udoh ju se ah. ");
INSERT INTO tvt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Seng mina loong ah heh ih rapne ih nook hali erah damdi uh heh ih Jehudi rangsoomnok nep hoonkot kotahe.” ");
INSERT INTO tvt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Eno Jisu ah neng damdi roongwangta. Saahaap ih ma dowa poonkaat thukta erah nok dowa ih heh haloot ni tah angta, “Nyootte, an nak thaam chamnaang uh. Ngah ih an nga nok nah poon theethe tah angkang, ");
INSERT INTO tvt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","adoleh nga teewah rah an re nah nga pupu ih jen chomui theethe tah angkang. An ih aadowa ih ba baat uh, eno bah nga laksuh ah ede eah. ");
INSERT INTO tvt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngah uh apit ni Elong saahaap loong lakhu ni esiit, eno nga khui ni raabante uh eje. Ngah ih erah loong asuh, ‘Kah uh!’ ih baatkang bah ekaat eah; ngah ih therah asuh, ‘Raaho!’ ih baatkang bah heh raak eha; erah damdi ngah ih nga laksuh asuh, ‘Arah re uh!’ ih baatkang bah heh ere eah.” ");
INSERT INTO tvt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisu ah epaatja eta erah chaat ano ah; eno heh ngaakchaap ano heh lini khoomte loong asuh baatta, “Ngah ih sen suh baat rumhala, a likhiik ih tuungmaang arah babah uh tathaak jatkang, Ijirel hah loongtang ni botseh uh tajeeka. ");
INSERT INTO tvt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jeng chaatte loong saahaap nok ni ngaakwang rum adi laksuh rah ejen de ih arah tupwang rumta. ");
INSERT INTO tvt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Erah damdam Jisu ah Nein samthung ni wangta, heh damdi mina loong nyia heliphante loong ah hantek ang rumta. ");
INSERT INTO tvt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Paathong ni thok damdam ih, mangbengte loong dokkhoom ra rumha ah chomuita. Etek ete wah ah thaknuh adi heh sah erah luulu angta, heh damdi samthung dowa miloong ah hantek ang rumta. ");
INSERT INTO tvt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Teesu ih erah nuh ah sok ano, heh tenthet dongta, eno baatta, “Nak huung uh.” ");
INSERT INTO tvt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Eno Jisu ah hengkhoom ano mangkhok ah taajota, eno mang piite loong ah tangchap rumta. Jisu ih baatta, “Jaaro! Ngah ih baat hala, Saat uh!” ");
INSERT INTO tvt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Etekte ah saattong ano neng damdi nep waantiitta, eno Jisu ih heh nuh suh kota. ");
INSERT INTO tvt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Neng loong thoontang echo damdi Rangte rangphoong rumta. “Elongthoon Khowah rah sengdung ni dong hala!” Neng ih liita, “Rangte ah heh mina pangsuh ra hala!” ");
INSERT INTO tvt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jisu tiit ah erah dowa ih deek akaan nyia juungkhuung rep ni ruurangta. ");
INSERT INTO tvt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Joon liphante loong ih heh suh jaatrep erah tiit loong ah baat rumta, eno heh ih neng dung nawa wanyi poonta, ");
INSERT INTO tvt_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","eno Teesu suh chengkaat thukta, “An tam angkoko Joon ih raak eha ih kabaatta rah ah, tam aleh seng ih wahoh banthoothak jih angka?” ");
INSERT INTO tvt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Neng Jisu jiinni thokrum ano cheng rumta, “Juungtemte Joon ih an suh cheng raang ih daapkaat hali heh ih banbaatta eraak ete eah erah ah an tam ang koko, tama seng ih wahoh banthoothak jih angka.” ");
INSERT INTO tvt_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Erah tokdi Jisu ih mina loong ah neng khoisat, maasat, nyia Chiithih laakhah paan nyia edook ekoong loong deesiit tok angta. ");
INSERT INTO tvt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Heh ih Joon jeng chaatte loong asuh ngaakbaatta, “Sen ih tumjih tup han nyia chaat han rah Juungtemte Joon suh amet ngaakbaat wan an: edook ih tup et ha, ekoong ah ekhoom ela, eput engam loong esaasiit eta, naabaang ih echaat ha, etekte ah ngaaksaat eta, erah damdi Ruurang Ese tiit rah changthih loongdung ni baat et ha. ");
INSERT INTO tvt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tumthan tenroon ah ngah suh mongchi lah angte loong rah ah!” ");
INSERT INTO tvt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Joon jeng chaatte loong wangta lini, Jisu ih heh tiit ah miloong asuh we baat rumta: “Sen Joon damdoh phisaang hani wangtan adi, sen ih tumjih japtup ih ebanthun tan? Pong ih naam pheekmot arah tama? ");
INSERT INTO tvt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tumjih japtup suh wangtan? Mih moongdong ih choom arah japtup suh tama? Emah ih choomchaakte loong abah kunuchangteng nok loong nah ba japtup an! ");
INSERT INTO tvt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Baat he, sen tumjih sok suh wangtan? Khowah sok tam? Elang eah, enoothong sen ih khowah nang ih elong ah tuptan. ");
INSERT INTO tvt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Joon ah Rangteele ni baat ha ah: ‘Rangte ih liita, ngah ih nga tiitbaatte sen nganah daapjah hang sen suh lamtan kot raang ih ah.” ");
INSERT INTO tvt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ngah ih baat rumhala,” Jisu ih boot baatta, “Joon ah o nang ih uh elongthoon heh juuba dongta. Enoothong o Rangte Hasong ni ehinsah angla erah ah Joon nang ih elongthoon ang ah.” ");
INSERT INTO tvt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Warep ih heh jeng ah chaat et rumta; loongtang nang ih ehanthoon ah sokse seete loong ah ih Rangte amiisak tiit ah thang rumta eno neng juung uh Joon ih tem rumta. ");
INSERT INTO tvt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Enoothong Pharisi nyia Hootthe Nyootte loong ah Rangte mongtham neng raangtaan suh taat angta rah daan et rumta erah thoidi Joon juungtem uh daan rumta. ");
INSERT INTO tvt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisu ih toombaat ruh eta, “Eno bah Ngah ih tumjih doh toobaat ang aahaangwa mina loong ah? Neng ah tumjih likhiik angla? ");
INSERT INTO tvt_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Neng ah noodek loong thaangsang theng ni tong arah likhiik boh ah. Noodek dungsiitte loong ah ih dunghote suh riingbaat ah, ‘Seng ih kuhoon boongkaat saamtom koh ih, ang abah uh sen taboong kan! Mangboong ah seng taat boongti, ang abah uh sen tahuung kan!’ ");
INSERT INTO tvt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juungtemte Joon ah ra haano, kham uh lajok thang ih samurangsoom tongta, eno sen ih liitan, ‘Heh sak ni laathih pan eah!’ ");
INSERT INTO tvt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mina Sah ah we ra haano heh ih jok phaksah, eno sen ih liihan, ‘Sok arah mih rah ah! Heh bah mangda nyia kham jokte boh ah, sokse seete loong nyia rangdah loong joonte boh ah!’ ");
INSERT INTO tvt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Rangte thung atak ah, o mina loong ih kap hi loong sak dowa ih amiisak et noisok ah.” ");
INSERT INTO tvt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharisi wasiit ih heh nok ni Jisu rangja phaksat poonta, eno Jisu ah kah ano phaksat suh tong kata. ");
INSERT INTO tvt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Erah samthung adi rangdah ni tongte minuh esiit angta. Minuh rah ih Jisu Pharisi nok ni cham saha ih chaat ano, phontum jongtek adi hemeesiit ih piijah taha ");
INSERT INTO tvt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","eno Jisu reeni ehuung damdi heh lathong ko ih chap ra taha, eno heh mikse rah ih Jisu lah adi siimseeta. Eno heh khoroon ih hook hut ano, heh lah adi chupphakta, eno phontum rah ih lokta. ");
INSERT INTO tvt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pharisi warah ih erah tup ano, heh teeteewah suh liita, “Arah wah ah amiimi khowah angta bah, heh ih jat etjih angta, arah minuh ah tumjaat mih ih taajoh halang eah; heh ih jat etjih angta arah minuh ah tumthan rangdah lam ni tongsongla eah!” ");
INSERT INTO tvt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisu ih heh suh liita, “Simoon, ngah ih an suh jaatsiit baatjih jeela.” “Um, Nyootte,” heh ih liita, “Baat hang.” ");
INSERT INTO tvt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisu ih phangbaatta “Ehak di mih wanyi ih ngun namte wah dowa ngun nam nyuuta.” “Wasiit ih ngunkholok chaabanga namta, wasiit rah ih rook banga namta.” ");
INSERT INTO tvt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Eno nyi ih lajen ngaakthem nyu koka no, ngun namte kotte warah ih nyi dowa lakah ngaaksuh thang ih toohaatta. Erah ang abah, marah wah asuh, ehan minchan ah?” ");
INSERT INTO tvt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoon ih liita, “Ngah ih thun angdi ehan ih namte wah ah.” “An ih punbaat et hu, Jisu ih liita. ");
INSERT INTO tvt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Eno Jisu ah minuh ko ih leksok ano Simoon suh baatta, “An ih arah nuh ah tup tam et hu? Ngah an nok ni ra tahang adi, an ih ngah lah chot suh juung taban kotahang, arah nuh rah ih bah nga lah ah heh mikse ih chot hangno heh khoroon ih hook hut tahang. ");
INSERT INTO tvt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","An ih ngah echupphak damdi taban thoothak tahang, eno arah nuh rah ih bah ra tahang dowa ih nga lah chupphak ah tatoohaatka. ");
INSERT INTO tvt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","An ih ngah Olip bangthiing ih nga khoh ni tamook tahang, eno arah nuh rah ih bah nga lah ni phontum ih hut halang. ");
INSERT INTO tvt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Erah raang ih, ngah ih baat hala, erah than elong minchan heh ih noisok halang rah ih heh rangdah loong biin anaan etta. Enoothong o amasah biin anaanta erah suh amasah minchan noisok ah.” ");
INSERT INTO tvt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Eno Jisu ih minuh asuh baatta, “An rangdah loong ah biin anaan et halu.” ");
INSERT INTO tvt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mihoh loong teebun ni tongte loong ah ih neng jengjeng eta, “O ah arah mih rah ah, mih rangdah nep biin anaante ah?” ");
INSERT INTO tvt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Eno Jisu ih minuh asuh baatta, “An tuungmaang ih puipang halu; semroonroong ih tong kah uh.” ");
INSERT INTO tvt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Rekam ritdi Jisu ih Ruurang Ese Rangte Hasong tiit ah tumbaat suh hadaang hadaang nyia samthung loong adi dokkhoomta. Asih wanyi heliphante loong uh heh damdi roong kata, ");
INSERT INTO tvt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","erah damdi minuh loong neng khoisat deesiitta nyia laathih pan deesiitte loong ah anep roong karumta: Meeri (Magdaleni ih poonta rah), heh sak nawa laathih sinet dokphanta nuh ah; ");
INSERT INTO tvt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joanna, heh sawah Chuja ah Hirod luungwang noklong ni saahaap angta rah. Erah damdi Susanna, nyia minuh ehoh loong Jisu nyia heliphante loong suh neng ngun ah koh ano chosok rumta rah lang ih rumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Miloong ah Jisu jiinni samthung harep nawa lomkhoom rum taha; eno miloong ah hantek lomthutthi kano, Jisu ih arah tiitthaak ah baat rumta: ");
INSERT INTO tvt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ehak di mih wasiit ih raanjih wen kaatta. Heh ih phek ni raanjih ah wenkaat adi, mararah raanjih ah lam ni datta, eno mih ih noopnak kaat, erah damdi woh ih nep toontop kaat. ");
INSERT INTO tvt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mararah ah jong hah ni datta, eno hephook ah dong ano, paakwaan ah laje thoidi laan hookti ruh eta. ");
INSERT INTO tvt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mararah raanteh ah suh haang rok ni datta, eno hak ano champhook ah suh haang rah ih loopjota. ");
INSERT INTO tvt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Eno mararah raanteh ah hah se ni datta; eno champhook ah hak ano, hetiik ah chaasiit chaasiit ih dong tiikta.” Jisu ih thoonbaat rumta, “Eno bah, chaat et an, sen na je abah ah!” ");
INSERT INTO tvt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Heliphante loong ah ih Jisu suh erah tiitthaak ah tumjih men ettu ih cheng rumta, ");
INSERT INTO tvt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","eno heh ih ngaakbaat rumta, “Rangte Hasong husalam ah jen thoijat suh sen suh bah thung atak koh rumhala, enoothong wahoh loong suh bah tiitthaak lam ih ju raaha, erah thoidoh neng ih taatsok rum abah uh tattup rumka ang ah, nyia chaat rum abah uh tasamjat rumka ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Tiitthaak tiit ah arah suh liiha: Raanjih ah Rangte tiitkhaap. ");
INSERT INTO tvt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Raanjih lam ni datta rah tiitkhaap chaatte asuh liita, enoothong Juungbaan luuwang ah thok haano neng ten nawa jengkhaap ah nge rum ah, Rangte suh hanpi rum ano neng khopi theng pho ang rum ah eah. ");
INSERT INTO tvt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jong hah ni datta raanjih ah langla, tiitkhaap ah chaat ano tenroon lam ih thaangchaatte asuh liiha. Neng ten ni dangdang tatongka, pootsiit raang ih hanpi rum ano, phate joonnaam saapoot ah thok kah no, neng laan dat ruh ih rumla. ");
INSERT INTO tvt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Suhaang rok ni datta raanjih ah langla echaat ete asuh liiha; enoothong sootsaam nyia changteng tenthun, erah dam ih arah hatoh dowa tenroon roidong loong ah ih loopjoh ah, eno neng tiik ah babah uh lasumka loong asuh liiha. ");
INSERT INTO tvt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hanoop ni datta raajih ah langla o ih jengkhaap ah thaangchaat ano neng tenni ese lam ih dangdang ih thiin rumha loong asuh liiha, eno hetiik maang dong tiik tiik ih bantongla asuh liiha. ");
INSERT INTO tvt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“O ih uh weetook ah took ano khoowaan ih tahopsongka adoleh phaangkhulu nah tatookka. Erah nang ih bah, mina ih weephaak ah chosuh, hethiin thengnah ba thiin ah. ");
INSERT INTO tvt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Tumjaat hotthiin et ha loong ah wuungsa nah dong ha, nyia tumjaat hoppat eha loong ah chotup ano weephaak nah dongthiin ah. ");
INSERT INTO tvt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Erah raang ih “Mamet chaat han erah naririh ih kap an; tumeah o di tumjih bah uh eje angte loong asuh ebootkot et ah, eno o di amuh ah, erah dowa amasah jeela ih taatthun rumha rah uh ethoon nge et ah.” ");
INSERT INTO tvt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jisu nuh nyia heh no loong heh jiinni thok rumta, enoothong miloong hantek ang thoidi tajen chomui rumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mararah ih Jisu suh baatta, “An nuh nyia an no loong an damdoh chomui suh taakkhuung ni chap rumla.” ");
INSERT INTO tvt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jisu ih thoontang suh baatta, “Nga nuh nyia nga no loong bah o ih Rangte tiit chaat ano naririh ih kapte loong ah!” ");
INSERT INTO tvt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Saasiit Jisu heliphante loong damdi Khoonkhuung ni dungtong ano baat rumta, “Seng therah juungsitum saangko adoh daan kah ih.” Eno karumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Neng khoonkhuung ni soon tokdi, Jisu ah emokjup eta. Eno baphuk di juungsitum adi pong pongta, khoonkhuung mong adi juungwaak ah wang eta, eno neng thoontang echoojih ih hoon rumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Heliphante loong ah ih Jisu ah saatsiit karumta, ame jeng rum ano ah: “Nyootte, Nyootte! Seng ah etek nanah angli!” Jisu ah saat ano pong aphaat asuh baat kano; pong aphaat loong ah laan tikmat ruh eta, eno tikpakpak ih semdatta. ");
INSERT INTO tvt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Eno heliphante loong asuh liita, “Sen tuungmaang ah maani ah?” Heliphante loong ah echo damdi paatja ih rumta, eno neng chamchi ni esiit esiit ih chengmui rumta, “Arah mih o angla? Heh ih pong aphaat suh nep baat ano heh jeng chaatchaat ih rumla!” ");
INSERT INTO tvt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jisu nyia heliphante loong khoonkhuung ah Gerasa juungkhuung ko ih jopkaat rumta, erah langla Galili juungsitum saangko adi angta. ");
INSERT INTO tvt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisu ah juungkaang adi datkhoomta, eno samthung dowa mih laathih pan ang arah wasiit chomuita. Rekam dowa ih dook erah mih ah nyumuh khatmuh, heh nok ni uh latong thang ih, mangbeng luung ni tong arah angta. ");
INSERT INTO tvt_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Heh ih Jisu ah tup ano, erongwah ih riinghuungta eno Jisu lathong ni heloong loongdat eta eno riingta, “Jisu Elong Echoong Rangte Sah! An ih ngah ah tumjih et suh chung halang? An lasih johala, nak chamnaang thuk weehang!” ");
INSERT INTO tvt_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Erah liita ah langla Jisu ih laathih asuh emok sak dowa doksoon uh ih li kano riingta. Lekrookwih laathih rah ih heh ah banjoh ruh eta, erah damdi helak helah ah jaanruh ih kitleh phaatak ni taat sak, ang abah uh thaphui leh laathih rah ih woma ni moongsiit kaat kah eta. ");
INSERT INTO tvt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisu ih chengta, “An men o ah?” “Nga men ah ‘Ephoop,’” heh ih ngaakbaatta tumeah heh sak ni laathih loong hantek nopta. ");
INSERT INTO tvt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Laathih loong rah ih Jisu suh neng ah hetangmuh haluung nah lakaat raang ih heh lasih joh rumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kaanjang adi wak loong ah hantek tek riimthuk arah angta. Eno laathih loong ah ih Jisu suh neng ah wak sak adoh kaat thuk raangtaan ih Jisu lasih joh rumta, eno emah ju et kaat thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Neng mih sak dowa doksoon rum ano wak sak adi nop karumta. Wak loong ah kaangphut adi loongtang doruk karum ano juungsitum adi lupdat karumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wak riimte loong ah ih tumjih ang rumla ih sok rumta, eno soon rum ano erah tiit ah samnuthung rep nyia phek aphaang loong adi tiibaat wanrumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Miloong ah tumjih ang kota ih sokkah rumta, eno Jisu jiinni thokrum adi, laathih heh sak nawa doksoonta wah ah Jisu lathong ni tongta, nyuh akhat pan thungsek ih ban tongta; eno miloong ah loongtang cho rumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Erah japtupte loong ah ih mihoh loong suh erah wah deeta tiit ah tumbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Eno erah juungkhuung dowa miloong ah ih Jisu suh haloot nah kaat baat rumta, tumeah neng ah rapne ih cho rumta. Erah thoidi Jisu ah khoonkhuung adi dungtong kata. ");
INSERT INTO tvt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Heh sak nawa laathih doksoonta warah ih Jisu lasih jota, “Ngah uh an damdoh roong ra weehang.” Ang abah uh Jisu ih ehoh ni kaat thukta, amet baat ano ah: ");
INSERT INTO tvt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Noknah ngaak wang uno Rangte ih tumjih deesiit taho erah baatwan uh.” Eno erah wah ah samnuthung lam ih wang ano, Jisu reeraang tiit loong ah baat wanta. ");
INSERT INTO tvt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisu juungsitum jooko nawa ngaak wang adi, miloong ih jengseera lam ih heh ah bantho rumta, tumeah neng loong ih heh ah jaatjaat ban sok rumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Eno mih wasiit heh men ah Jairas thok taha; heh ah Jehudi rangsoomnok ni mote angta. Heh teeteewah Jisu lathong ni kottong ano heh nok nah kaat raangtaan ih lasih jota, ");
INSERT INTO tvt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tumeah heh sah asih paang nyi minusah, esiit laklak ang arah, thoon tek nanah angta. Eno Jisu ah roong kata adi, miloong ah rongrep nawa thutkhoom rum taha. ");
INSERT INTO tvt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Neng dung ni minuh esiit asih paang nyi heh sih sih arah angta; heh ih jirep heh di tumjih jeeta loong ah Phonwah jiinni thoon thaaja arah angta, heh ah o ih uh lajen deesiitka rah mina angta. ");
INSERT INTO tvt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Heh miloong dung ni ra haano Jisu liko ni heh nyuh kaangba adi taajota, eno heh sih rah erah damdam laan tang ruh eta. ");
INSERT INTO tvt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisu ih chengta, “O ih taajoh tahang?” Eno mirep ih daan et rumta, eno Pitar ih liita, “Nyootte, miloong ephoop laangma kookchap halu.” ");
INSERT INTO tvt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ang abah uh Jisu ih liita, “O ih ang abah uh ngah taajoh ih tahang, tumeah ngah ih nga sak nawa chaan katta adi jattang.” ");
INSERT INTO tvt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Minuh rah ih sok ano thunta Jisu ih ejen japjoot ih halang eah, eno emoot cho damdi kah ano Jisu lathong ni kotbon kata. Erah di mirep ngathong ni baatta, heh ih tumjih thoih taajota nyia lakdamdam di mame deeta tiit rah ah. ");
INSERT INTO tvt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisu ih heh suh baatta, “Nga sah an tuungmaang nawa ih deelu, Semroongroong ih tong kah uh.” ");
INSERT INTO tvt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisu ih erah baat rum adi, saahaap nok nawa kongphaak huite thok taha. Eno Jairas suh baatta, “An sah bah etek ela,” “Nyootte ah nakcham thaam hoom kuh.” ");
INSERT INTO tvt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Enoothong Jisu ih erah japchaat ano Jairas suh baatta, “Nakcho uh; tuungmaang ba eh uh, ese ang ah an sah ah.” ");
INSERT INTO tvt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Eno heh nok ni thok rumta adi, Jisu ih o uh nokmong ni tanop thukta, Pitar, Jeems, nyia Joon erah damdi noodek nuh nyi wah ba nop rumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Warep erah di noodek thun huungte nyi mongjoongte luulu angta. Jisu ih baatta, “Nak huung an; noodek ah etek tah eka ejup boh ela!” ");
INSERT INTO tvt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Loongtang ih Heh ah engit et rumta, tumeah neng ih jat et rumta noodek ah jen tek eta eah. ");
INSERT INTO tvt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ang abah uh Jisu ih noodek ah heh lak ni saat hoom ano poonta, “Noodek oh, saat uh!” ");
INSERT INTO tvt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Eno heh tak ah dong heengta, erah damdam noodek laan saat ruh eta, eno Jisu ih phaksat jam koh an ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Heh nuh nyi wah loong ah rapne ih paatja rumta, enoothong Jisu ih o suh uh labaat thang arah tiit rah ah ih tanghaam rumta. ");
INSERT INTO tvt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisu ih asih wanyi heliphante loong ah lompoon ano neng suh Chiithih laakhah loong ah jen dokphan theng nyia khoisat deesiit theng chaan aphaan ah korumta. ");
INSERT INTO tvt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Eno heh ih neng loong ah Rangte Hasong tiit tumbaat nyia khoisatte loong ah deesiit suh kaat thuk rumta, ");
INSERT INTO tvt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","erah lilih amah we ih baatta, “Erah kah an doh sen sak nah tumjih uh nak hui an: kiingthom uh nak pi an, kunma khaak uh nak hui an, phaksat uh nak hui an, ngun akom uh nak hui an, samsong boseh hedak nak hui an. ");
INSERT INTO tvt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Marah doh sen noppoon han, erah nok adoh erah samthung dowa maang dokdok khoom ih tong an; ");
INSERT INTO tvt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","marah doh mih ih sen tanoppoon ran, erah samthung adoh sen lah nawa bungwiik ah jaanak thiin ano dokkhoom an, eno neng raang ih erah ethih banthoothak theng toom ang ah.” ");
INSERT INTO tvt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Heliphante loong ah harep ni tumkhoom rumta, Rangte Ruurang Ese ah tumbaat rum ano khoisatte loong ah harep nawa deesiit karumta. ");
INSERT INTO tvt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hirod, Galili phansiitte warah ih, erah tiit loong ah thoontang japchaat ano heh thung phaangta, tumeah mararah miloong ih liita Juungtemte Joon ngaakthingla. ");
INSERT INTO tvt_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","“Rukho loong ah ih li rumta Elijah dong hala, eno rukho loong ih li rumta teewah dowa khowah loongdung nawa ngaakthingla. ");
INSERT INTO tvt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hirod ih liita, “Joon khoh ah boleh ngah ih thah thuktang nih; eno arah chaat hang mih ah o angla?” Eno heh ih Jisu ah japtup raangtaan ih banthoota. ");
INSERT INTO tvt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Heh kaamwah loong ah ngaakwang rumha no Jisu suh neng ih tumjih reeta loong jaatrep baat rumta. Heh ih neng ah heh damdi siit rumta, eno Betsaida samthung liita adi neng kaatkaat ih rumta. ");
INSERT INTO tvt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Miloong ah ih erah japchaat rum ano, noongrep nawa roong phankhoom karumta. Heh ih ese ih ra halan ih li ano Rangte Hasong tiit ah baat rumta, erah dam ih khoisatte loong o ih jamta erah loong ah deesiit etta. ");
INSERT INTO tvt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Rangsa phanglup kah adi, heliphante asih wanyi ah heh reeni kah rum ano baatta, “Miloong ah daap et uh neng ih neng phaksat nyia ejup ejam theng arah hadaang loong re ko nah nyia phek aphaang loong adoh toom jam karum ah, tumeah arah hah ah heh luulu hatik ni.” ");
INSERT INTO tvt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ang abah uh Jisu ih baat rumta, “Mathan ang abah uh sensen ih phaksat ah jam kokaang an.” Neng ih ngaakbaatta, “Seng jiinni bah baanlo banga nyasi enyi ba jeela, an ih seng suh arah than mina loong asuh phaksat toom reh koka rum ah ih tam li hu?” ");
INSERT INTO tvt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Erah di haajaat banga taan mina angta.) Jisu ih heliphante loong suh baatta, “Miloong ah dungsiit nah rookbanga rookbanga ih pheetong thuk an.” ");
INSERT INTO tvt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Heliphante loong ih jen phe tongthuk ano, ");
INSERT INTO tvt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisu ih baanlo banga nyia nyasi enyi ah toon ano, rangko ih toonsokta, eno Rangte suh lakookmi li ano chepphiitta, eno heliphante loong suh koh ano miloong asuh pheekoh kaat thukta. ");
INSERT INTO tvt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Loongtang ih laanphoot ruh ih phaksah rumta, eno heliphante loong ih asih hongnyi dakta rah toon rumta. ");
INSERT INTO tvt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Saasiit Jisu ih heh laklak rangsoom adi, heliphante loong ah heh jiinni wang rumta. Jisu ih cheng rumta, “Miloong ih ngah suh o angla ih kah li rumhang?” ");
INSERT INTO tvt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Neng ih ngaakbaatta, “Mararah ih Juungtemte Joon ih liirum halu,” “Rukho rah ih Elijah ih liirum halu, rukho loong ah ih teewah khowah loongdung nawa wasiit ngaakthingla ih liirum halu.” ");
INSERT INTO tvt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Sen ih tumjih liihe?” Heh ih neng suh chengta. “Ngah suh o et liihe?” Pitar ih liita, “An ah Kristo Rangte.” ");
INSERT INTO tvt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Eno Jisu ih neng suh dangdang ih baat rumta erah tiit ah o suh uh labaat theng eah. ");
INSERT INTO tvt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Heh ih wakbaatta, “Mina Sah ah rapne ih cham jaatjaat eah eno mihak phokhoh, nyia romwah phokhoh loong, erah damdoh Hootthe Nyootte loong ih edanhaat nep et rum ah. Heh ah etek haat et rum ah, enoothong sa jom linah we ngaakthing eah.” ");
INSERT INTO tvt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Eno heh ih neng loongtang suh baatta, “O mina nga damdoh wangsuh nookla, heh ih heh teewah ah beehaat et theng, heh bangphak ah saarookwih huitheng, eno ba nga lih ah jenrik hang. ");
INSERT INTO tvt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tumeah o mina heh roidong ah pui raangtaan ih thunha erah emat eah, eno o ih heh roidong ah nga raangtaan ih mat haat ah erah ah epui eah. ");
INSERT INTO tvt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mina ih arah mongrep dowa jaatrep ah kap ano, heh teewah ah thet haat nyi maat haat abah tumjih choh ah? Emah tah angka! ");
INSERT INTO tvt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","O mina ngah suh nyia nga jengkhaap asuh erakri ean bah, Mina Sah rah uh heh chaan aphaan nyia heh Wah adoleh esa rangsah loong chaan aphaan rangwuung sa doh sen suh engaak rakri eah. ");
INSERT INTO tvt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngah ih kamkam ih baat rumhala arah di marah marah mih eje Rangte Hasong ah maang japtup doh latekte ah.” ");
INSERT INTO tvt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Heh ih sa sinet lini baatta, Jisu ih Pitar, Jeems nyia Joon ah siit ano kong ni rangsoom wangta, ");
INSERT INTO tvt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Heh ih rangsoom adi, hethe hekhoh ah lek eta, eno henyuh hekhat ah pungkoopkoop ih phaakta. ");
INSERT INTO tvt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Baphuk di mih wanyi dong taha eno Jisu damdi waan nyuuta. Erah nyi ah Moses nyia Elijah angta, ");
INSERT INTO tvt_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","rangmong weephaak lam ih dong nyuuha no Jisu damdi waantiit nyuuta, Rangte ih tumjih chungta erah ah heh ih Jerusalem nah tek ano mamah lamdoh jen phansiit theng tiit rah ah. ");
INSERT INTO tvt_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitar nyia heh joonte loong ah emokjup ih rumta, eno saat rum ano sok rum adi Jisu ah phaakjaaja angta eno heh damdi mih wanyi roong chapta. ");
INSERT INTO tvt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mih wanyi ah dokkhoom lini, Pitar ih Jisu suh liita, “Nyootte, tumthan ese ah seng aani ang ih no ah! Seng ih nyutaap ejom than hoon ih, esiit ah an raangtaan, esiit ah Moses raangtaan, eno esiit ah Elijah raangtaan.” (Amiimi di heh teeteewah ih tajatta heh ih tumjih suh liita rah ah). ");
INSERT INTO tvt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Heh ih tiit ah maang thoon baatka di, jiingmuung laaphaang ah ih wiithuk rumta; eno heliphante loong ah jiingmuung ih loopjoh rum kano echo erumta. ");
INSERT INTO tvt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Eno jiingmuung mong ni jeng arah japchaat rumta, “Arah nga sah, ngah ih daanje ang rah— heh jeng ah echaat et an!” ");
INSERT INTO tvt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jeng toojengta adi, Jisu ah heh luulu ih dong hoonta. Erah pootdi heliphante loong ah tikwaawa ih tikdat rumta, tumjih tup rumta tiit ah neng chamchi ni nep tanaan waantiit rumta. ");
INSERT INTO tvt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Saalih adi Jisu nyia Heliphante wajom kong nawa dat karum adi, miloong hantek Jisu damdi chomui rumta. ");
INSERT INTO tvt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Erah loongdung adi mih wasiit riingta, “Nyootte! An lasih johala, nga sah ah sokboi weeuh—nga sah ngah di heh luulu! ");
INSERT INTO tvt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Laathih rah baphuk ih eriing damdi heh sak adi patleh loonghaat eno leh mangtek thuk kah et ah, eno heh tu adi tookwu ah dong kah eah; emamah ban chamnaang thuk ruh et ha, chaan ih ba kadaap haat ah! ");
INSERT INTO tvt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ngah ih an liphante loong lasih taat joh rumtang, ang abah uh neng ih tajen dokphan rumta.” ");
INSERT INTO tvt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisu ih ngaakbaatta, “Sen loong lahanpiite nyia ethih mina loong boh ah! Ngah sen damdam sa mathan maajen roong tonghang? Sen damdam tonghang no sa mathan maajen toonjoh rumha?” Eno heh ih erah wah asuh baatta, “An sah rah aako et siit wanho.” ");
INSERT INTO tvt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Noodek ah wang damdam, laathih rah ih hah ni loonghaat ano mangtek thukta. Jisu ih laathih rah dokphan kano noodek ah laan de ruh eta, eno heh wah suh ngaak kota. ");
INSERT INTO tvt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Rangte chaan ah tup rum ano warep paatja rumta. Heliphante loong suh baat rumta tok adi, mina loong ah Jisu reeta asuh thok paatja ruh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ngah ih sen suh baat theng eje erah sen ih labeehaat theng! Mina Sah rah hansi chaan aphaan mina loong lak nah jokoh rumte angla.” ");
INSERT INTO tvt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ang abah uh heliphante loong ih tumjih suh liita erah tajat rumta. Erah jengkhaap ah neng suh tami dongjat thuk rumta, erah thoidi neng ih tajen samjat rumta, eno erah tiit ah cheng suh uh echo ih rumta. ");
INSERT INTO tvt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Heliphante loongdung ni elongthoon ah o angjih ah, erah tungthoidi daanmui rumta. ");
INSERT INTO tvt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisu ih neng tenthun ah ejat eta, eno heh ih noodek esiit toonsiit ano heh re adi chap thuk ano, ");
INSERT INTO tvt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","baat rumta, “O mina ih arah noodek nga mendoh noppoon ah, erah ih ngah noppoon halang; erah damdi o ih ngah noppoon halang, erah ih ngah daapkaat teewah anep noppoonha. Erah raang ih sengdung ni ehin thoon o ah erah ba elongthoon ang ah.” ");
INSERT INTO tvt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Joon ih liita, “Nyootte, seng ih mih wasiit ih an mendi laathih dokphan arah tupti, eno seng ih tanghaamti, tumeah heh ah sengjoon tah angta.” ");
INSERT INTO tvt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Nakmok tanghaam an,” Jisu ih heh suh liita eno wahoh loong heliphante loong asuh nep baatta, “Tumeah o mina sendi tadaan muira erah sen raangtaan ang ah.” ");
INSERT INTO tvt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisu ah rang nah toonsiit wan saapoot thok kohaano, heh thung ni Jerusalem nah kaat suh thunta eno dokkhoomta. ");
INSERT INTO tvt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Samaria ni hadaang esiit heh raangtaan ih jaatrep ah ban khookham suh, heh ih kongphaak kotte bandaap kaatta. ");
INSERT INTO tvt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Enoothong erah nok hate loong rah ih tabansok rumta, tumeah heh ah jatririh Jerusalem nah kaatte angta. ");
INSERT INTO tvt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jeems nyia Joon ih erah soknyu ano, li nyuuta, “Teesu, an ih sek suh arah mina loong ah tek haat raangtaan ih rang nawa we tam datpoon thuk he tih?” ");
INSERT INTO tvt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jisu ih ngaaksok ano kanja nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Eno Jisu nyi heliphante loong ah hahoh ko ih karumta. ");
INSERT INTO tvt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Neng lam ni karum adi, mih wasiit ih Jisu suh baatta, “An maako ih kah uh ngah an damdam ehang.” ");
INSERT INTO tvt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisu ih baatta, “Maaut di heluung jeela, woh de ah neng tep, enoothong Mina Sah raangtaan ih bah maani uh heh naangtong theng taan uh tajeeka.” ");
INSERT INTO tvt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Heh ih wahoh asuh we baatta, “Nga lilih eho.” Eno erah warah ih liita, “Nyootte, jaakhoh ngah ih sengwah mang chaak beng wang ang.” ");
INSERT INTO tvt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisu ih ngaakbaatta, “Etekte loong ah neng neng toom beng mui rum ah. An ih Rangte tiit thong tumbaat kaat uh.” ");
INSERT INTO tvt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Eno wahoh ih we baatta, “Chuupha, ngah an lilih ehang, enoothong ngah jaatang damdoh chaak raajeng wang ang.” ");
INSERT INTO tvt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisu ih heh suh baatta, “O bah uh phek ah taat phang moot ano heh lakkah ah ban ngaaksok ruh eha mina abah Rangte Hasong ni tapunka.” ");
INSERT INTO tvt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Erah lilih Teesu ih wahoh wah rook sinet wah nyi danje ano wanyi wanyi et daapkaatta, marah doh heh kaat theng ah erah hah adi hengah hengah ih ban kaat thukta. ");
INSERT INTO tvt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Heh ih neng suh baatta, “Chamkhan theng erah ni ephoop je ah, enoothong ekhante ah amasah. Phek changte wah asuh rangsoom koh an heh ih cham khante toomdaap jaha suh ah. ");
INSERT INTO tvt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kah an! Ngah ih sen so dung ni saapsah likhiik et daapkaat rumhala. ");
INSERT INTO tvt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sen ngunkhaak adoleh kunma khaak adoleh lah khoop sen ih lahuitheng; lam nah sen ih tangchap anno mih lasoom theng. ");
INSERT INTO tvt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Maatok doh sen mih nok nah nop an, erah doh jaakhoh sen ih li theng, ‘Arah nok adoh semroongroong toomtong an.’ ");
INSERT INTO tvt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Erah doh semroongroong ih tongsongte mina tong abah, sen ih marah jengkhaapse jengtan rah neng damdam toomtong ah; lah angka bah, marah semroongroong ih tong suh jengseeraatan ah ngaaktoon etheng. ");
INSERT INTO tvt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Erah noknok adoh tong anno neng ih tumjih kohan erah phaksah an, tumeah paknaate suh heh thaang ekotjih. Nok hoh nok hoh nah laleng tongtheng. ");
INSERT INTO tvt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mararah sa doh samthung ko ih kah andoh mih ih nok nah noppoon hanbah, tumjih kohan erah phaksah an, ");
INSERT INTO tvt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","erah samthung dowa khoisatte ah deesiit an, eno miloong asuh baat an, ‘Rangte Hasong ah sen reeni thok hala.’ ");
INSERT INTO tvt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Enoothong mararah samthung adoh sen tanoppoon ran, erah dowa taakkhuung nah dokkhoom anno li an, ");
INSERT INTO tvt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Sen hah nawa bungwiik seng lah ni rapla taan anep sen suh thichoh ih no saaphuk thiin hi. Enoothong samthun et an Rangte Hasong abah sen reeni thok ehala!’ ");
INSERT INTO tvt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngah ih amiimi et baat rumhala Daande Saadoh Rangte ih erah samthung nang ih Sodom hah asuh tenthet ehan noisok ah! ");
INSERT INTO tvt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Tumthan echoojih ang ah sen raangtaan suh ah, Korajin mina loong! Tumthan echo theng ang ah, Betsaida mina loong asuh nep ah! Epaatja jih marah sen suh noisok tahan erah Tairi nyia Sidoon suh noisokta bah, neng ih ehak doh dook khuupo nyuh ah wok rum ano, neng sak nah laabot pan ih neng ah rangdah nawa esa eti ih noisok theng rumta! ");
INSERT INTO tvt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Rangte ih sen nang ih Dande Saadoh Tairi nyia Sidoon suh heh tenthet ah ehan ih noisok ah. ");
INSERT INTO tvt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Eno Kapernum miloong! Sen teeteewah ah rang nah jen wang ih eh tam liitan? Sen ah soolam nah dat haatte ang halan!” ");
INSERT INTO tvt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisu ih heliphante loong suh baatta, “O mina ih sen jeng boichaat han erah ih nga jeng uh boichaat ehang; O ih sen danhaat han; erah ih ngah uh danhaat et hang; eno o ih ngah danhaat hang erah ih ngah daap teewah ah nep danhaat ha.” ");
INSERT INTO tvt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wah rook sinet wanyi ah tenroon lam ih ngaak wang rum taha, “Teesu,” neng ih liita,” Juungbaan ih nep seng jeng chaat eta seng ih an mendi dokphan kino ah!” ");
INSERT INTO tvt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisu ih ngaakbaatta rumta, “Ngah ih Soitaan ah rang nawa weephaak daat raaha rah likhiik tup ettang. ");
INSERT INTO tvt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Boichaat an! “Ngah ih sen suh ejenjih chaan koh rumhala, eno ba sen pu nyia siingngaangraang khonah nep jen khoom an erah damdoh sen Piiara chaan anep jen an, eno tumjih ih uh sen tathet haat ran. ");
INSERT INTO tvt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Enoothong sen jeng juungbaan ih chaat ha ih nak mokroon an; erah nang ih bah sen men ah rang ni raangha asuh thong roon an.” ");
INSERT INTO tvt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Erah tokdi Jisu ah Esa Chiiala ih tenroon thuk ano liita, “Ewah, rang nyia hah Teesu! ngah ih an suh lakookmi li hala tumeah an ih lajatte loong asuh jaatthuk hu marah jatwah loong re nawa taat huthiintu loong ah jatthuk hu. Elang euh, Ewah, erah ah an ih jamtu loong aju angla. ");
INSERT INTO tvt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Sengwah ih ngah suh jaatrep ah kotahang. O ih uh heh Sah ah tajatka heh wah luulu ih ba jat ha, erah damdi, o ih uh heh wah ah tajatka heh sah luulu ih ba jat ha eno o mina suh jatthuk suh heh Sah ih daanje ha erah ih baajat ha.” ");
INSERT INTO tvt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Erah dowa ih Jisu ih heliphante loong ko ih leksok ano neng suh ngiija ni dan baatta, “Sen tumthan khangraangse ah sen ih tumjih japtup han erah tup an no ah! ");
INSERT INTO tvt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ngah ih sen suh baat rumhala khowah nyia luungwang loong ih uh sen ih marah tup han erah ah tup suh taatthun rumha, ang abah uh neng ih tajaptup rumka, nyia sen ih marah chaat han, erah japchaat suh taatthun rumha ang abah uh neng ih tajap chaat rumka.” ");
INSERT INTO tvt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Hootthe Nyootte ah ra haano Jisu jeng matjoot thunta, eno heh ih chengta,” Nyootte,” “Babah uh lathoonka roidong ah chosuh, ngah ih tumjih et angdoh se ah?” ");
INSERT INTO tvt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisu ih ngaakbaatta, “Rangteele ni mamet liita leh? Sen ih erah mamah kah ih toombaat an?” ");
INSERT INTO tvt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Erah mih rah ih ngaakbaatta, “‘An Teesu Rangte ah an ten nawa ih minchan uh, an chiiala nawa, an tah nawa ih, an thung atak nawa ih minchan uh’ nyia ‘ankhuung antok ah an teewah thanthan ih minchan uh.’” ");
INSERT INTO tvt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisu ih ngaakbaatta, “An ih epun baat et hu,” Erah loong ah re uno ba khothing tong uh.” ");
INSERT INTO tvt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Enoothong Hootthe Nyootte warah ih jatririh di, Jisu suh chengta, “Khuung atok ah nga raang ih o ah ang ah?” ");
INSERT INTO tvt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisu ih ngaakbaatta, “Teewadi mih wasiit Jerusalem nawa Jeriko ni dat kah adi miputte loong ih joh rumta, eno put rum, ebot ah buh rum, eno lam ni etek nanah ih thiinhaat rum. ");
INSERT INTO tvt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Eno erah lam adi romwah wasiit dat khoom kata; eno mih rah tup ano, heh ih jiit khoom ano, lamhoh ko ih kata. ");
INSERT INTO tvt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Emamah Leewi nok hah we ra taha, no mih rah sok ano, lamhoh ko ih siip khoomta. ");
INSERT INTO tvt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Enoothong Samaria nok hah wasiit ra haano, mih ah sokta, eno erah sok ano, heh minchan dongta. ");
INSERT INTO tvt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Heh ah heh re ko ih kah ano, phonthiing nyia kham ih hema ah mook ano loopkhakta; no naangjam nokmong ko ih toon hu wan ano, naririh ih soksam wanta. ");
INSERT INTO tvt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Saalih adi heh ih jaan ngun loonyi dok ano nok bansokte asuh kota, eno baat thiinta, ‘Arah wah ah ban sok weeuh joh,’ ngah arah lam we ih ngaak wanghang adoh, an ngun mathan wang ah erah we ngaakthem et wan ah.’” ");
INSERT INTO tvt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Eno Jisu ih thoonbaatta, “An thung ni erah wajom tung dowa ih, miputte ih noopbuta wah ah marah ih hekhuung hetok likhiik noisokta?” ");
INSERT INTO tvt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Hootthe Nyootte rah ih ngaakbaatta, “Marah ih heh minchanta erah warah ih.” Jisu ih baatta, “An kah uno, emamah ih re uh.” ");
INSERT INTO tvt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisu nyia heliphante loong lam ni kaat tokdi, hadaang esiit adi minuh heh men ah Martha ih heh nok ni poonwanta. ");
INSERT INTO tvt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Erah nuh adi heh no esiit heh men ah Meeri angta, erah nuh rah Teesu lathong adi kottong ano heh jengkhaap ah boichaatta. ");
INSERT INTO tvt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martha ah mongjoong angta jaatrep pakna theng ah hesuh totoh thiinhaat kot kano ah, eno heh ah ra haano liita, “Teesu, “An ih tanih jatko nga no ih jaatrep pakna theng ah ngah suh totoh thiin haat kohalang rah ah? Baat weeuh nga damdoh toomroong pakna wang weeha! ");
INSERT INTO tvt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Teesu ih ngaakbaatta, “Martha, Martha! An ah jaatrep suh sootsaamlu nyia chamnaanglu, ");
INSERT INTO tvt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","enoothong esiit luulu ba an ih wakjamjih. Meeri ih epunjih lam ah danjeeha, eno erah ah heh dowa lah ngaak toonjih.” ");
INSERT INTO tvt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Saasiit hah esiit ni Jisu ih rangsoomta. Eno erah thoonsoom adi, heliphante wasiit ih heh suh baatta, “Teesu, seng suh rangsoom nyoot he, Joon ih heliphante loong suh kanyootta likhiik ah.” ");
INSERT INTO tvt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jisu ih baat rumta, “Sen ih rangsoom an doh, ame jeng an: ‘Ewah: An men esa ah toomphoong ho; an Hasong toom raaha. ");
INSERT INTO tvt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Seng suh roijang phaksat ah kohe. ");
INSERT INTO tvt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Seng rangdah ah biin anaan he, seng ih uh seng damdi thetreete loong ah biin anaan et ih. Eno seng thisusuh ih nak phate thuk he.” ");
INSERT INTO tvt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Eno Jisu ih heliphante suh baatta, “Jengthaak ah sen jiiwah nok nah mottom doh kah anno taat suh kah thaak an, ‘Nga jiiwah ngah suh baanlo loojom than nam kohang. ");
INSERT INTO tvt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nga nok ni nga jiiwah wen nawa amadi thok hala, eno ngah di phaksat heh suh kottheng taan uh tajeeweeka!’ ");
INSERT INTO tvt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Eno jengthaak ih an jiiwah rah ih nokmong nawa ih toom ngaakbaat thaak ho, ‘Nak paklak raahang! Kaasak ejen tangsak etang, seng nga saloong ejen jup eli. An suh tumjaat kot suh uh, tajen saat kang.’ ");
INSERT INTO tvt_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Eno bah mamah angtheng ah? Ngah ih baat rumhala an jiiwah mendi heh ih baanlo ah tajen kotaho, ang abah uh an ih larakri thang ih laat suruh et ubah heh saat ano an ih tumjih sutu erah ekot eho. ");
INSERT INTO tvt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Erah raang ih ngah ih baat rumhala: Cheng et uh, eno ba an choh uh; ejam et uh, eno bah an ih chojam uh, erah damdoh erengdok et uno ba an suh kaasak ah daap koho. ");
INSERT INTO tvt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tumeah o ih cheng ah erah mih choh ah, erah dam ih o mina ih jam ah erah ih chojam ah, nyia kaasak ah o ih rengdok ah erah suh ba daap koh ah. ");
INSERT INTO tvt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sen heh wah angte loong ah ih sen sah ih nyasi suh handi pu ni koh an? ");
INSERT INTO tvt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Adoleh wotih suh hanbah siingngaangraang ni koh an? ");
INSERT INTO tvt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tumthan ih thih ubah uh, an sah suh ese jih ah mamet kottheng abah ejat et hu. Erah ang abah, rang niiwa sen Wah rah ih tang, Esa Chiiala ah tumthan ehan koh ah o ih heh dowa chengha asuh ah!” ");
INSERT INTO tvt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisu ih engong juungbaan ah dokphanta, eno juungbaan ah doksoon kano, engong ah phang dongjengta. Eno miloong ah paatja ih rumta, ");
INSERT INTO tvt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","enoothong mararah mina ih li rumta, “Arah bah Beljibul boh ah juungbaan loong luungwang rah ah, heh suh neng jen dokphan theng chaan kotcho boh ah.” ");
INSERT INTO tvt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Rukho loong ah ih Jisu heh matjoot chungta, erah thoi ih neng ih heh suh epaatjaajih Rangte reeraang ah noisok he ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ang abah uh Jisu ih jat etta neng ih tumjih thunha rah loong ah, eno li rumta, “Marah deek akaan neng chamchi ni pheetong ano rookmuila loong ah roitang tatongka; changka siit ah pheerook ano tong abah ethet eah. ");
INSERT INTO tvt_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Erah raang ih juungbaan hasong adoh uh neng chamchi nah pheerook ano tong abah, mamah jen ih chengtong ah? Sen ih li hali ngah ih juungbaan dokphan hang chaan ah Beljibul luungwang ih koha eah. ");
INSERT INTO tvt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ngah ih dokphan hang ah emah ang abah, sen liphante loong ih mamet dokphanta? Sen liphanteete loong ih jatthuk ha sen ah emoong lan eah! ");
INSERT INTO tvt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Emah tah angka, arah bah Rangte Chaan nawa ih Chiithih laakhah loong dokphan hang, eno erah ih jatthuk halan Rangte Hasong ah sen reeni jen thok ih taha eah. ");
INSERT INTO tvt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Maradoh tathat mina ih, helang hepah pan ih, heh nok ah ban sok abah, heh damdi tumjih jeela loong ah pi eah. ");
INSERT INTO tvt_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Enoothong heh nang ih tathat wahoh ih mok we jen abah, heh laalom theng helang hepah loongtang soonpi ano pheekokaat ah. ");
INSERT INTO tvt_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“O mina nga miksukte loong ah nga raangtaan tah angka; o mina ih nga tachosok rang erah loong ah phaangjaang eah. ");
INSERT INTO tvt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Laathih ah mina sak nawa doksoon ano, deek akaan hookpakpak adoh heh naangtong theng jam sokkah ah. Eno heh ih esiit uh lachoh jamka bah heh ih heh teeteewah suh li ah, ‘Nga nok nah ngaakwang ang.’’ ");
INSERT INTO tvt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Eno heh ngaak wang ano nok ah saachamcham khookham cho et tupwang ah. ");
INSERT INTO tvt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Eno we ngaak kah ano heh damdoh laathih sinet boot poonkah ah heh nang ih uh ethithoon ang arah ah, eno neng erah nok adoh tongwang ah. Eno bah erah mina ah jaakhoh nawa nang ih ehanthoon ih thih arah ang ah.” ");
INSERT INTO tvt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisu erah baatta adi, midung ni minuh esiit jengta eno Jisu suh baatta, “Tumthan tenroonjih ah an dongtupte nyi an koonchaate rah ah!” ");
INSERT INTO tvt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Enoothong Jisu ih ngaakbaatta, “Erah thaknang ih bah, tumthan tenroonjih ah o mina ih Rangte jeng ah chaat ano kap ete loong rah ah!” ");
INSERT INTO tvt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Miloong ih Jisu ah kookchap rum adi, heh ih liirumta, “Ahaangwa mina loong ah tumthan ethih ah! Neng ih epaatjaajih cheng rum halang, enoothong epaatjaajih o suh uh takokang Joona suh kotang aju ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Khowah Joona ah Ninewe mina loong raangtaan suh nyootsok theng angta likhiik, mina Sah rah uh ahaangwa mina loong raangtaan ih nyootsok theng ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dande sa doh wangchaanuh Siba ih ahaangwa mina loong ah chamnaang thuk han, tumeah heh ah hedeek nawa luungwang Solomon jatwah jengkhaap chaat thok hala; eno ngah ih baat rumhala Solomon nang ih elong ah aani. ");
INSERT INTO tvt_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Dande sa doh Ninewe mina loong ih sen ah chamnaang thuk et han, tumeah neng ah rangdah nawa ngaaklek eta Joona ih Rangte tiit baatta ah kap rum ano ah; eno ngah ih amiimi tiit baat rumhala adi Joona nang ih uh elong ah seng damdi! ");
INSERT INTO tvt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“O ih uh weetook ah kaangtook ano tekmong nah tahuthiinka; erah nang ih bah, hethiin thengnah ba thiin ah, eno ba nokmong ni wangte mina ah khom kaangtook ah. ");
INSERT INTO tvt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sen mik ah sen sak raangtaan ih weephaak likhiik. Sen mik ah ese ang abah, sen sakpuh weephaak ang ah; enoothong sen mik ah laseeka bah, sen sakpuh ah laamang nah ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Naririh ih thun an, erah ang abah, sen sak nawa weephaak ah laamang maamok angja oh. ");
INSERT INTO tvt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sen sakputang ih weephaak nah ang abah, sen sak marah nah uh laamang tah angka, kaangjaaja ba ih phaak ah, weetook ih kaangtook ho di kah ang ah likhiik ah.” ");
INSERT INTO tvt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisu ih tiit ah thoonbaat kano, Pharisi wasiit ih heh nok ni phaksat poonta; eno heh phaksat suh roongtong kata. ");
INSERT INTO tvt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jisu ih laktiimuh ih phaksah arah sok ano Pharisi ah paatja eta. ");
INSERT INTO tvt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Eno Teesu ih heh suh liita, “Eno bah, Pharisi sen loong ih bah sen khuung akhaak nyia sen lokkep khaplang ah rangkhoh ah ba saachot han, enoothong sen mong ni bah changrook nyia ethih loong tenthun ah meela. ");
INSERT INTO tvt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Thungko ah loong! Rangkhoh hoonte wah Rangte ih, heh mong uh heh ih tanih hoonta? ");
INSERT INTO tvt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Enoothong sen lokkep nyi tek akhuung ni tumjih jeela rah changthih suh koh anbah, jirep ah an suh esa we ih hoon ah. ");
INSERT INTO tvt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Tumthan echoojih ang ah sen Pharisi loong asuh ah! Sen ih Rangte suh hekuung di khokileeso asih thiik uh ekot et han, jengthaak ih pochiina erah damdi uh jaat hoh mesih chaangtiik anep kohan, ang abah uh sen Rangte minchan nyia sen epun tenthun ah maat haat et han. Sen ih erah loong ah, marah uh lamaat haat thang ih reejih. ");
INSERT INTO tvt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tumthan echoojih ang ah sen Pharisi loong asuh ah! Sen ih rangsoomnok ni tongtheng ese ah ban thiin thuk suh nook lan, eno thaangsang thengnah uh mirep ih soomtu suh nook lan. ");
INSERT INTO tvt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tumthan echoojih ang ah sen suh ah! Sen loong ah mangbeng theng ni lajat thang ih khoomte mina loong likhiik.” ");
INSERT INTO tvt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hootthe Nyootte wasiit ih heh suh liita, “Nyootte, an ih erah jenglu adi seng nep wak kaanju hali!” ");
INSERT INTO tvt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisu ih ngaakbaatta, “Sen Hootthe nyootte loong raangtaan ih uh tumthan echoojih ang ah! Sen ih mih tamkhoni huijih ah lajen huitheng et huthuk han, eno sen ih neng huijih ah roong chaang hui suh sen laktiik taan uh tajanghaat kan. ");
INSERT INTO tvt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tumthan echoojih ang ah sen suh ah! Sen ih khowah loong mangbeng theng ah jaaseemoong ih hoonhan—erah khowah loong ah ih senwih sente tek haatte lek ang kano ah. ");
INSERT INTO tvt_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sen ih sen teeteewah ih noisok han, senwih sente tumjih reeta rah ah; neng ih khowah loong tek haat et rumta, eno sen ih neng mangbeng nok loong ah hoonkoh han. ");
INSERT INTO tvt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Erah thoih Rangte mongtham ese rah ih liita, ‘Ngah ih neng suh khowah nyia kongphaak baatte loong daapkaat ang; eno neng ih rukho ah tek haat rukho ah echamnaang toom et rum ah.’ ");
INSERT INTO tvt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Erah raang ih amah dowa mina loong asuh chamchojih ang ah teewah haphangsong di khowah loong tek haat rumta thaang rah ah, ");
INSERT INTO tvt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel phangtek haat rumta dowa ih Jekaria tek haat rumta tuk ih, marah Roomthong nyi Esa hah chamchi ni tek haatta rah ah. Elang eah, ngah ih baat rumhala, ahaangwa mina loong ah erah loong thaang ah cham thuk rum ah! ");
INSERT INTO tvt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Tumthan echoojih ang ah sen Hootthe nyootte loong asuh ah! Sen ih thung atak kaasak laang theng chaabi ah sen lak ni thiinhan; erah di sen teeteewah uh tawangkan, eno mihoh taat wangkah bah uh sen ih tanghaam et han!” ");
INSERT INTO tvt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisu erah dowa dokkhoom kata, Hootthe nyootte nyi Pharisi loong ih heh ah ethih ethih ih chikram rumta eno jaatrep jengkhaap cheng rumta, ");
INSERT INTO tvt_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","heh jeng lasah moong jengla, mat et joh suh ih thun rum ano ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bijaat haajaat mina loong lomthok rum taha eno, ejap nakmui nep ih rumta, eno Jisu ih jaakhoh heliphante loong asuh liita, “Naririh et ban sok an Pharisi loong to ih naktoom thet haat han—ngah ih neng lonoi asuh liitang. ");
INSERT INTO tvt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tumjaat hoppat cho ah erah daapcho ih hoon ah, erah damdoh jaatrep husah tiit loong ah dongjat et ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Erah raangtaan ih marah sen ih laamang ni baat han erah rangwuung nah japchaat ah, erah damdoh marah sen ih ngiija nokmong ni hubaat han erah nok rangkhoh nawa ih riingbaat ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ngah ih baat rumhala, nga joonte loong, sen marah ih hansi laklak tek haatte ra lacho theng jaat hoh ethih tumjih takah jen etka. ");
INSERT INTO tvt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ngah ih noisok rumha o ra choojih rah ah: Rangte ra cho an, etek lini, Heh di juuba soolam nah haat wan suh chaan jeela. Nga jeng ah tuungmaang an, esiit heh juuba sen choojih ah! ");
INSERT INTO tvt_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Wosiksak banga rah phaanyi di tanih kasangka? Wosiksak esiit taan uh Rangte ih tabeehaatka. ");
INSERT INTO tvt_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Sen khoroon ah botseh rookwet cho. Erah raangtaan ih nakcho an; sen ah wosiksak hantek thaknang ih uh thaangchaan! ");
INSERT INTO tvt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ngah ih amiisak ih baat rumhala, o mina ih noksong dung nah neng ah nga mina et dokbaat rum ah, Mina Sah eh uh Rangte rangsah loong ngathong nah neng suh emamah ih reekoh rum ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Enoothong o mina ih nokwah dung nah thaaju hang, Mina Sah eh uh emamah Rangte rangsah loong ngathong nah thaaju rum ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“O mina ih Mina Sah ah thetbaat abah ejen biin anaan et ah, enoothong marah ih Esa Chiiala tiit thetbaat ha abah biin anaan tachoka. ");
INSERT INTO tvt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Neng ih Jehudi rangsoomnok nah adoleh kobonor nyi hadaang pante loong ngathong nah phate suh siitwan hanbah, sen lapaatja theng senteewah ah mamet pangjih ah adoleh sen tumjih jengjih asuh ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tumeah Esa Chiiala ih erah tokdoh an tumjih jengjih ah heh ih nyoot han.” ");
INSERT INTO tvt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Midung ni mih wasiit ih Jisu suh baatta, “Nyootte, seng phoh suh baat uh seng wah ih thiinhaatta nyamka rah toom phe kohang.” ");
INSERT INTO tvt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisu ih ngaakbaatta, “Nga joonwah, ngah suh mih rikri nyia setnyi suh soophoh nyamka ah pheekot theng ih chaan o ih kot kotahang koh?” ");
INSERT INTO tvt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Eno heh ih erah tiit ah loongtang suh wakbaat rumta, “Sen teeteewah ah naririh ih ban sok an sen ah jaatrep doh maamok nyamnyook jan oh; tumeah mina tumthan nyamte wah taat ang abah uh, ami roidong ah heh nyamka nawa ih tajen hoonka.” ");
INSERT INTO tvt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Eno Jisu ih arah tiitthaak tiit ah baat rumta: “Ehak di changteng wah wasiit angta heh di cham seetheng phek hantek angta. ");
INSERT INTO tvt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Heh ih thunta, ‘Ngah di cham lomthiin theng tajeeka. Ngah ih tumjih et ang doh se ah? ");
INSERT INTO tvt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ngah ih amet ang,’ heh teeteewah suh liita; ‘ngah ih nga pung ah thaak haat angno ena elong we et huk hoon ang, erah doh nga cham nyia jaat hoh hukkhaak loong anep jen lomthiin ang. ");
INSERT INTO tvt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Eno ngah ih nga teewah suh li ang, Khangraangse wah! Andi jaatrep hukkhaak paang rookwih raangtaan ih jeela. Roidong amah ba hanih, jok oh, phak oh, eno roidong doh tenroon ih tong oh!’ ");
INSERT INTO tvt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Enoothong Rangte ih heh suh liita, ‘Thungko wah an! Niikja an roidong ah ethoon ete; eno nyamka nyi hukkhaak loong ah an raangtaan ih lomthiin hu loong ah o choh theng ah?” ");
INSERT INTO tvt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Eno Jisu ih thoonbaatta, “Marah ih heh nyamka loong taat lomthiin ha rah Rangte jiinko ni heh changteng tah angka.” ");
INSERT INTO tvt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Eno Jisu ih heliphante loong suh baatta, “Erah raangtaan ih ngah ih baat rumhala ethingtong raangtaan ih phaksat suh nak sootsaam an adoleh sen sak nah kap theng nyuh akhat suh nak sootsaam an. ");
INSERT INTO tvt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Roidong ah phaksat nang ih uh elongthoon, erah damdi sak ah nyuh akhat nang ih uh elongthoon. ");
INSERT INTO tvt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Wokhah loong ah sokthaak an: neng ih cham uh tawenka adoleh cham uh takhanka; nengdi cham lomthiin theng pung uh tajeeka; neng ah Rangte ih dung ha! Sen ah tang woh nang ih thaangchaan! ");
INSERT INTO tvt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Erah suh sootsaam anno amasah taan roiloh ejen tong tam ih an? ");
INSERT INTO tvt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sen ih erah likhiik ehinsah ah lajen phanlan kanbah, jaat hoh raangtaan ih tang tume thaam sootsaam lan? ");
INSERT INTO tvt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Sok an woma popoong loong hakla rah ah; neng moot ni uh takaka adoleh neng ih neng raangtaan ih nyuh uh tawaatka. Enoothong ngah ih baat rumhala Solomon luungwang di heh nyamka erah than ang adi botseh uh arah woma popoong loong jaaseela likhiik henyuh hekhat ah tajaaseeka. ");
INSERT INTO tvt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Erah woma naam suh nyuh akhat kotte rah ah Rangte, naam loong ah chiinyah bah eje enoothong rangkhah emat eah, we nah matkhaam ah. Erah ang abah heh ih sen suh nyuh akhat tanih jen koran? Sen laalom abah amasah boh ah! ");
INSERT INTO tvt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Erah raangtaan ih sen nak thungjoong an, ejok, ephak mamang ah eah. ");
INSERT INTO tvt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(Tumeah arah mongrep adi Rangte lajatte mina loong ih bah Saarookwih jok aphak ah raang ih ju sootsaamla.) Sen wah ih jat et ha sen suh erah loong ejamjih ih eah. ");
INSERT INTO tvt_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Erah nang ih bah, Rangte heh Hasong raangtaan ih thong sootsaam anbah, eno erah loong abah heh ih laajam kojan. ");
INSERT INTO tvt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Echo nak ih an, sen saapsah loong ah, tumeah sen Wah eroon ela eno sen suh Hasong ah ekot ehan. ");
INSERT INTO tvt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sen hukkhaak loong ah thoontang sang anno erah ngun ah changthih loong suh kokaat an. Sen ih lathet theng ngun khaak ah kap anno rangmong nah nyamte ang raangtaan ih lomthiin an, erah nah nyamka rah babah uh ene tah ih hoonka, tumeah erah ni ehuh tami nopka, erah damdoh ram eh uh taphakka. ");
INSERT INTO tvt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sen tenthun ah marah di sen nyamka ah erah nah ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Banthootho ih tong an tumjih thok ha bah uh, nyuh akhat ban kapcho nyia weetook ban took cho ah, ");
INSERT INTO tvt_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","laksuh ih neng changte wah kuhoon theng nawa ngaakwang eha ih kaban sok arah likhiik ah. Heh ah wang ano kaasak ah rengdok, erah damdam neng ih kaasak ah laanban daap ruh et ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tumthan tenroonjih ah erah laksuh loong ah neng changte wah ngaakwang tokdi motseng nyi banthootho ih japtup wang ano ah! Ngah ih baat rumhala, heh ih heh samsongnuh ah khookthiin ano, neng ah tongthuk rum ah, eno heh ih ban sok rum ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tumthan tenroonjih ah heh ih neng ah banthootho ih tong rum arah japtup ano ah, mottom di nyia mottom lini taat wang adi nep ah! ");
INSERT INTO tvt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Sen ih jat ehan nok changte ih ehuh wang saapoot ah jatta bah, heh ih ehuh asuh heh nok tajap long thuk thengta. ");
INSERT INTO tvt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Erah raang ih, sen uh, banthootho ih tong an, tumeah mina Sah rah uh sen reenah sen ih labantho kan pootdoh mok thok ha.” ");
INSERT INTO tvt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitar ih liita, “Teesu, erah tiitthaak tiit ah seng raangtaan suh elang tam eah, tama warep mina raangtaan suh baat hu?” ");
INSERT INTO tvt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Teesu ih ngaakbaatta, “Erah ang abah, laksuh hanpiite nyia maakwah ah o ang ah? Heh changte wah ih mootkaat phanlansiitte o hoon ah erah wah ah laangja, heh nok nep heh suh phanlan siit thuk ah erah damdoh laksuh wahoh loong suh neng chotheng phak asat kot saapoot erah warah ih phanlan ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tumthan tenroon ang ah erah laksuh rah ah, heh changte wah ih nok nah wang adoh heh pakna reeraang ah japtup wang aradoh ah! ");
INSERT INTO tvt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Elang eah, ngah ih baat rumhala, changte wah ih heh laksuh asuh jaatrep nyamka ban sok baat ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Enoothong erah laksuh rah ih nga changte wah ngaakwang eliin ela ih li ano heh ih laksuh ehoh loong ah minuh miwah thoontang riimbuh, eno jokjok phakphak ih tong, kham adoh mok eabah, ");
INSERT INTO tvt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","saasiit changte wah ah heh laksuh ih labansokka nyia lajatka sa doh ngaakwang ah. Eno changte wah ih heh ah jopjop ih dook ano heh jeng lachaatte loong chamtheng adoh cham thuk ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Marah laksuh ih heh changte wah ih heh suh tumjih reetheng baat ha ah jatcho di, laban re thang ih tong abah, erah laksuh ah rapne ih chamnaang thuk ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Enoothong marah laksuh ih heh changte wah ih tumjih jamha erah lajat thang ih thet reela, erah mih asuh amasah ju chamthuk ah. Ehan o suh kota erah jiin nawa ehan ju jam ah; ehan tokkhodi ehan o suh kotta erah jiin nawa emamah et jam ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ngah ih hatoh ah we ih rook suh ra halang, eno erah ejen luung ela ih thunhang! ");
INSERT INTO tvt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ngah ih lakngah ni nga juungtemjih jeela, eno erah loong ah maang thoonthoon ngah mathan ih moongsaamte anglang! ");
INSERT INTO tvt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sen ih ngah suh hatoh nah semroongroong ang thuk raaha ih tammok thun tahe? Tah angka, semroongroong tah angka, epheehoom thong ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Aadowa ih changka siit ni mih banga angte ah ephe eah, ejom ah enyi damdoh miksuk mui ah enyi ah ejom damdoh ih miksuk mui ah. ");
INSERT INTO tvt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Hewah loong ah neng sah damdoh miksuh mui ah, heh sah loong ah neng wah damdoh; heh nuh loong ah neng sah minusah damdoh miksuk mui ah, neng sah ah neng nuh damdoh, henuh loong ah neng nyam damdoh miksuh mui ah, neng nyam ah neng hopnuh damdoh miksuk mui ah.” ");
INSERT INTO tvt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisu ih miloong asuh wakbaatta, “Sen ih jiingmuung ah saanop ko ih sok damdam laanjeng ruh elan rangphaatte angla eah eno amiimi ih phaat. ");
INSERT INTO tvt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Erah damdi sen ih juungmeh ko nawa pong ih mot hanbah, sen ih liihan rangmi angte eno amiimiisak ih rang ah mi. ");
INSERT INTO tvt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Lonoite loong! Sen ih rang ahah ko ih sok anno rangmi rangphaat kemban jat han; erah ang abah, sen ih aahaangwa saapoot ah mamah ladan jat ehan? ");
INSERT INTO tvt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Sen ih sen teewah ah epun ih re suh mamah lami dande et han? ");
INSERT INTO tvt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","O ih bah uh sen thet ah jat ano hootthe jun ih mat hoon nok nah siitwanjih mok ang abah, sen ih mat hoon nok maangjap doh changrook ah mathan jen ang ah, esemsiit raangtaan ih thuntheng. Emah lah ekan bah, mat hoon nok nah mat hoonte jiinnah hoom wanhan, eno pulit lak nah kohan, erah dowa ih phaatak nah sak wanhan. ");
INSERT INTO tvt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ngah ih baat rumhala, erah nah sen chang maang dokdok ih tongthuk han.” ");
INSERT INTO tvt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Erah toktok di mararah miloong ih Jisu suh Galili nok hate loong ih Rangte suh neng khosa siik hoon wan rum adi Pilat ih tek haat rumta tiit ah baat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisu ih ngaakbaat rumta, “Galili nok hate loong erah tek haat rum kano, sen ih neng loong ah o nang ih uh rangdah thoon ang rumkano tek haatta ih tam thunhan? ");
INSERT INTO tvt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Emah, tah angka! Enoothong ngah ih baat rumhala sen rangdah nawa maang ngaak lelek bah, sen uh loongtang neng tekta likhiik ih ti an. ");
INSERT INTO tvt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloom hah ni asih wah asat mina nok echoong ah rungdat ano mamet tekpat rumta? Erah mih loong ah Jerusalem ni songtongte loong o nang ih uh rangdah thoon ang rum kano tekpat rumta ih tammok thunhan? ");
INSERT INTO tvt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Emah, tah angka! Enoothong ngah ih baat rumhala, sen rangdah nawa lah ngaak lekkan bah, sen uh emamah neng tek rumta likhiik ih ti an. ");
INSERT INTO tvt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Eno Jisu ih arah tiitthaak ah baat rumta: “Teewadi mih wasiit ih heh phek ni puksak bang kiita. Eno hetiik taat sokkah adi tatiikta. ");
INSERT INTO tvt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Eno heh ih phekbante wah asuh liita, ‘Sokthaak uh, ngah ih paang jom arah puksak bangtiik ah taatwoot sokwang halang, ang abah uh esiit uh tatup kang. Edook haat et uh! Hah ah tumet suh thaam haamtaam phook thuk ah?’ ");
INSERT INTO tvt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Enoothong phekbante warah ih ngaak baatta, Chuupha, belam paang siit than toom waktong ah; ngah ih hehing ah kookthoh angno phon maahaat thaak ang. ");
INSERT INTO tvt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ngaarang lek dong tiik abah eseethoon; latiikka bah, an ih erah doh dok haat theng.’” ");
INSERT INTO tvt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Saasiit Jehudi naangtongsa di Jisu ih Jehudi rangsoomnok ni nyootsoot rumta. ");
INSERT INTO tvt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Erah di minuh esiit asih paang asat laathih ih sat thuk arah angta; heh ah siingkot angta, eno amasah uh takah mi jun chapta. ");
INSERT INTO tvt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisu ih erah nuh ah tup ano, poonta, “Minuh, an khoisat ah ede elu!” ");
INSERT INTO tvt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Heh lak adi taajoh kano, lakdamdam di heh teenuh nuh laan mi jun chap ruh eta, eno Rangte ah phoongphaata. ");
INSERT INTO tvt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jisu ih naangtongsa di deesiit rum kano Jehudi rangsoomnok ni mote saahaap ah ekhat eta, eno miloong asuh baatta, “Seng suh sa arok jeela pakna reeraangjih ah; erah raang ih sa arok mong adoh raahan no sen khoisat ah deesiit theng, naangtongsa doh tah angka!” ");
INSERT INTO tvt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Eno Teesu ih heh suh ngaakbaatta, “Lonoite sen loong! Sen dowa o ih bah uh sen maanpong adoleh sen moktoh ah naangtongsa di taap nawa ja ano juung jok tanih kadok siitkan. ");
INSERT INTO tvt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Arah nuh ah Abraham susah Soitaan ih asih paang asat chamnaang ha; naangtongsa doh heh ah tanih jen deesiitka? ");
INSERT INTO tvt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","“Erah ngaakbaat rum kano heh raawah loong ah neng rakrakri ih rumta, mihoh loong abah heh epaatjaajih reeta asuh eroon ih rumta. ");
INSERT INTO tvt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisu ih chengta, “Rangte Hasong ah tumjih likhiik ah? Ngah ih tumjih doh toobaat ang? ");
INSERT INTO tvt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Erah ah arah likhiik. Mih wasiit ih miinjaangjih ah heh phek nah wenkaat arah likhiik. Eno hephook ah phook ano hebang ih donghak, eno heh phaak loong adoh woh ah tep.” ");
INSERT INTO tvt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisu ih we chengta, “Rangte Hasong ah tumjih doh toobaat ang? ");
INSERT INTO tvt_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Erah arah likhiik. Minuh esiit ih thekook siit wongbaan adoh to ah woi ano maang sumsum et thiin arah likhiik.” ");
INSERT INTO tvt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisu samthung nyia hadaang loong lam ih kah ano miloong asuh nyootsoot lamdi Jerusalem koh ih dokkhoom kaat chungta. ");
INSERT INTO tvt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mih wasiit ih chengta, “Chuupha, ene ko mina ah tam pi ah?” Jisu ih ngaakbaatta, ");
INSERT INTO tvt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kaawan ehin adoh jen nop suh sen ese mathan ih jen re an eme re an; tumeah warep ih erah doh wangsuh taatthun ah, ang abah uh tajen wangrumka ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nok changte ah saat ano kaasak ah tangsak et ah; eno sen ah kaasakthong adoh chap anno taat rengdok leh baat et an, ‘Chuuphaǃ Seng suh kaaluung ah daap koh weeheǃ’ Eno heh ih ngaakbaat han, ‘Ngah ih sen tajat rumra ma nawa thok halan!’ ");
INSERT INTO tvt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Eno sen ih ngaakbaat an, ‘Seng an damdi karoong jok phaksah tahe; eno seng hadaang ni nep an ih kah nyootsoot tahe loong ah!’ ");
INSERT INTO tvt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Eno heh ih we li han, ‘Ngah ih tajat rumra sen ma nawa thok halan rah ah. Soon an nga re nawa ah, mimoong sen loong!’ ");
INSERT INTO tvt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Eno sen tumthan ih huung an, sen pha ah saat anno ah, sen ih Abraham, Isak, nyia Jaakob, erah damdoh khowah loong ah Rangte Hasong nah tup anno ah, sen baleh erah doh dok haat cho ang an! ");
INSERT INTO tvt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mina loong ah saadong saanop ko nawa, juungkuh juungmeh nawa lomthok ha, eno Rangte Hasong nah kuwaang phaksat roong phaksah tong rum ah. ");
INSERT INTO tvt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Eno o amadi liwang angla loong ah jaakhoh ang ah, o jaakhoh angla loong ah liwang ang ah.” ");
INSERT INTO tvt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Eno erah toktok di mararah Pharisi loong ah thok haano Jisu suh baatta, “An aadowa maanah ang abah uh edok khoom jaatjaat eh uh, tumeah Hirod ih an tek haat chung halu.” ");
INSERT INTO tvt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisu ih ngaakbaat rumta, “Kah anno erah maut asuh baatkaat an: ‘Chiinyah nyia rangkhah ngah ih Chiithih laakhah loong ah dokphan ang, khoisatte ah deesiit et ang, eno sa jom doh thoon reeraang pakna ang.’ ");
INSERT INTO tvt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Enoothong Chiinyah, rangkhah nyia ngaarang ah ngah ah khoom ruh ete anglang, tumeah khowah ah hahoh nah tek haat ah tapunka ang ah, Jerusalem nah ba tek haat ah. ");
INSERT INTO tvt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem, Jerusalem! Sen ih khowah loong tek haat han, sen ih Rangte ih kongphaak huite daapjaha rah jong ih tekpat han! Ngah ih sen mina loong ah lomkhoon joot suh nga lak tumthan taat janghaat hang, woh ih heh sah loong ah hejang khui ni kakhon ah likhiik ah, ang abah uh sen ih talomjoot thukri! ");
INSERT INTO tvt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Erah raangtaan ih Rangteenok ah thiinhaat ete anglan. Ngah ih amiimi ih baat rumhala sen ih ngah tajap tupri ang an, saapoot rookli ano sen ih amah maang jengjeng, ‘Teesu mendi o ra hala asuh Rangte ih romseetam koh ah.’” ");
INSERT INTO tvt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sa siit Jehudi naangtongsa di Jisu Pharisi nok hate wasiit phokhoh nok ni phaksat phaksah kata; eno miloong ah ih Jisu ah teptep et ban sok rumta. ");
INSERT INTO tvt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mih wasiit heh sook nyia heh lah pheng arah Jisu reeni chap wang taha, ");
INSERT INTO tvt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","eno Jisu ih Hootthe nyootte nyi Pharasi loong asuh chengta, “Seng Hootthe jun ih Naangtongsa doh mih edeesiit tam tadeesiit thukka?” ");
INSERT INTO tvt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Eno neng tumjih uh tajeng rumta. Jisu ih khoisatte ah toonsiit ano deesiitta, eno kaat thukta. ");
INSERT INTO tvt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Eno baat rumta, “Sen wasiit thandoh sen sah adoleh seng maanpong Jehudi naangtongsa doh habeng nah mok datti abah, sen ih echaan ih erah saasa doh etoonsiit tam tatoonsiit kan?” ");
INSERT INTO tvt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Eno neng ih erah tiit ah tami ngaakbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wenwah loong ih neng tongtheng ese se ah jam rum arah Jisu ih jat ano, heh ih arah tiitthaak tiit ah neng suh baatta: ");
INSERT INTO tvt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“O ih bah uh sen kuhoon sadung nah poon han radoh, sen tongtheng eseethoon adoh latong theng. Sen nang ih elong mina uh mok poon et ah, ");
INSERT INTO tvt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","set wanyi nyi poontte changte ah ra haano mok baat ho, ‘Arah doh arah wah ah toomtong ah eah.’ Eno an ah rakmuurakke ih enum nah dattong jih ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Erah nang ih, an mih ih poonho doh, kah uno tongtheng enumthoon adoh tongka uh, eno changte ah ra haano toombaat jaho, ‘Ngah jiiwah wang ho, tongtheng ese ko ih tong wangho.’ Erah doh an ah wahoh wenwah loong miksok doh khosoong naaloong ang uh. ");
INSERT INTO tvt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tumeah o ih heteewah suh elong ih thiik ah erah ehin ih hoon ah, eno o mina ih heh teeteewah suh ehin ih thiik ah erah elong ih hoon ah.” ");
INSERT INTO tvt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Eno Jisu ih neng poonte wah asuh baatta, “An ih maatok doh rangnih phaksat adoleh rangja phaksat ang koja bah uh mih poon ubah, babah uh an jiiwah adoleh anphoh anno nyia an joonte adoleh ankhuung antok nawa changteng loong ah lapoon theng tumeah neng ih an ewe ngaak poon et ho, eno an ih marah taat koh rumtu erah hephoopho we ih ngaak koho. ");
INSERT INTO tvt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sen ih sadung phaksat hoon anbah, changthih, ekoong nyia edook loong ah poon an; ");
INSERT INTO tvt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","eno ba romseetam ah choh an, tumeah neng ih sen suh tajen ngaakthem ran. Rangte ih sen suh heh mina loong tek nawa ngaaksaatja doh ngaakthem han.” ");
INSERT INTO tvt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jisu damdi teebun ni roong tongte wenwah wasiit ih erah japchaat ano, Jisu suh liita, “Marah mina Rangte Hasong nah sadung adoh choh roong tongte loong ah tumthan tenroon ang ah!” ");
INSERT INTO tvt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisu ih heh suh baatta, “Teewadi mih wasiit ih saroom dungnuh ni warep mina lompoonta. ");
INSERT INTO tvt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Eno sadung tok ah chang kano, heh ih heh laksuh asuh wenwah loong ah poonkaat thukta, ‘Wanghan, jirep ah khookham cho!’ ");
INSERT INTO tvt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Eno miloong ah ih wasiit wasiit ih, jaat hoh kaatthet ah diipbaat rum ano tawang rumta. Jaakhothoon poonta warah ih laksuh asuh baatta, ‘Ngah ih phek ena retang erah sokkah ang: ethih nak choh uh.’ ");
INSERT INTO tvt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Erah lih dowa wasiit ah ih we liita, ‘Ngah ih maanpong asih retang ah loong ah phek nah phek bok thaak siitkaatte anglang, erah thoidoh tajap ra rang ethih nakthun uh.’ ");
INSERT INTO tvt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Erah lilih wasiit ih we liita, ngah ih amamah di nga kuhoon tang, erah thoidoh ngah tajen raarang.’ ");
INSERT INTO tvt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Eno laksuh ah ngaakwang ano jaatrep tiit heh changte asuh baat wanta. Changte ah rapne ih khah ano heh laksuh asuh baatta, ‘Echaan ih kah uno lam nawa nyia hadaang hadaang nawa, changthih loong ah nyia ekoong, edook loong ah, ngaak poonkah uh.’ ");
INSERT INTO tvt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Erah damdam laksuh rah ih liita, ‘An ih baat hu jengkhaap ah tadaanke, changte, enoothong nok abah balam uh jaachaak dook.’ ");
INSERT INTO tvt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Eno changte rah ih laksuh asuh baatta, deek akaan lamrep nah kah uno miloong ah poonkah uh eno nga nok ah eme toom eah. ");
INSERT INTO tvt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngah ih thoontang suh baat rumhala takkhoh taat poon rumtang loong ah rangja phaksat ah nak toom phaksah ra rumha!’” ");
INSERT INTO tvt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Saasiit mih hantek Jisu damdam ih roongkhoom rum adi, heh ih ngaak sok ano baat rumta, ");
INSERT INTO tvt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“O nga jiinni thokte rah nga liphante tajen angka, ngah ah nengnuh nengwah, neng minuh nyia neng sah, nyia neng phoh neng nah, eno neng teeteewah nang ih ehan lamok mongnook rumrang bah ah. ");
INSERT INTO tvt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","O ih neng teeteewah bangphak ah hui ano nga linah lajen roong khoom ra bah nga liphante tajen angka. ");
INSERT INTO tvt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Sen dowa o ih bah uh nok echoong hoon suh kaankoong anbah, jaakhothoon ah tong uh no ngun mathan taan wang ih chaak rookwet uh eno ba jat uh nok jen hoonjih ngun ah eli tam taliika eah. ");
INSERT INTO tvt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Emah lah angka bah, an nok thongbeng ah thootcho, thathom doh toohaat jih ih hoon ah; eno mih ih sok ho doh engiit jih ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Neng ih amet li ho ‘An ih an nok ah taat phang hoon uno etoohaat bowe hu nih! ");
INSERT INTO tvt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Luungwang wasiit ih haajaat asih mih ah siit ano luungwang wahoh ih, haajaat rooknyi mih siit arah damdoh rookmui suh, jaakhoh heh ih chaak samthun et ah erathan mina damdoh ejen muujih tam lajen muujih rah ah. ");
INSERT INTO tvt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Heh ih lajen taaka bah, kongphaak huite daapkaat ano luungwang damdoh chomui ah, eno nuumi hoon raangtaan ih baat ah maang rookmui rumka ngakhoh nah ah. ");
INSERT INTO tvt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Erah likhiik ih, “Jisu ih thoonbaatta, “O ang an bah uh jaatrep ah lajen thiinhaat kanbah nga liphante tajen angkan. ");
INSERT INTO tvt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sum ah ese, enoothong sumwaan ah mok thoon abah, lamhoh nawa ih sum ah we ngaak sumthuk jih tajeeka. ");
INSERT INTO tvt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Erah ah hah nah tumjih maak doh tachapka adoleh khaat et suh uh taseeka ang ah; ehaat etjih ba ang ah. Erah thoidi ih chaat et an, sen na je abah ah!” ");
INSERT INTO tvt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Saasiit sokse seete nyia danhaatcho mina loong Jisu jeng boichaat thokrum taha, ");
INSERT INTO tvt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pharisi nyia Hootthe Nyootte loong ah suusu ih waan rumta, “Arah mih rah ih danhaatcho mina loong ah poon ano neng damdi nep uh roong phaksah ruh eha!” ");
INSERT INTO tvt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Erah thoidi Jisu ih arah tiitthaak tiit ah baatta: ");
INSERT INTO tvt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Jengthaak ih sen wasiit thandoh chaasiit taan saapsah toom angthaak ah, eno erah dung dowa esiit ah emat eah bah—an ih tumjih theng ah? An ih rook akhuh akhuh rah naamphak ban riim thuk uno esiit moong khoomta saapsah rah maang japtuptup ih jam sokkah uh. ");
INSERT INTO tvt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Eno chojam uno, rapne ih roonsoon damdoh saapsah rah an sookkaang nah toonpi wan uh ");
INSERT INTO tvt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","eno an nok nah ngaak piiwan uh. Erah lidoh an joonte nyi ankhuung antok loong ah lompoon uno baat uh, ‘Ngah rapne ih roonlang nga saapsah mata ah japjam angno ah. Erah thoidi seng ih saroom hoon ih, raahan!’ ");
INSERT INTO tvt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Erah likhiik, ngah ih baat rumhala, mina wasiit heh rangdah nawa ngaaklek abah rangmong hasong nah rapne tenroon ang ah, rook akhuh akhuh elong elang mina loong neng rangdah nawa ngaaklek suh lanookka loong ah nang ih ah. ");
INSERT INTO tvt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Adoleh jengthaak ih minuh esiit ih ngunkholok lo asih dowa loosiit ah maat haat abah heh ih tumjih et ah? Heh ih weetook ah kaangtook ano, nok ah joom ano naririh maang japtuptup ih jam sok ah. ");
INSERT INTO tvt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Heh ih japtup ano, heh joonte nyia heh khuung atok loong ah lompoon ah, eno neng suh baat ah, ‘Ngah rapne ih roonlang nga jaan ngun mata rah japjam angno ah. Seng loong saroom room ih!’ ");
INSERT INTO tvt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Erah likhiik, ngah ih baat rumhala, Rangte Rangsah loong uh emamah ih roon ah wasiit taan rangdah nawa ngaaklek abah ah.” ");
INSERT INTO tvt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisu erah damdi wakbaatta, “Ehak di mih wasiit di heh sah wanyi angta. ");
INSERT INTO tvt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Noolih warah ih heh wah asuh baatta, ‘Ewah, nga dakbi nyamka ah ngah suh amadoh laan phe kohang.’ Eno heh warah ih heh sah nyi asuh pheekoh nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Sa nyi jom lini noolih warah ih heh dabbi nyamka ah sang ano nok nawa erah ngun ah hui ano moongkhoom kata. Heh mideek ni moongkhoom kata, eno heh ngun loong ah thaangmuh di lasootsaam thang ih thaaja kaatta. ");
INSERT INTO tvt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Heh jiinni mathan ngun jeeta angta thoontang jen thaaja lini, erah hah adi ramkhah dongta, eno heh jiinni tumjih uh tadakta. ");
INSERT INTO tvt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Erah thoidi heh erah deek adi mih nok ni lakniik jam kata eno wasiit ih heh phek ni wak ban sok thukta. ");
INSERT INTO tvt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Heh ih thunta wakjook theng wakcham ah tam laan sah ang eah, tumeah heh suh o ih uh phaksat kotte tajeeta. ");
INSERT INTO tvt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Hethoondi heh thung ni dongthunta eno liita, ‘Seng wah nok ni mote loong ih neng wok maang phootphoot kah ih phaksah rum ah, chiinyah ngah bah aadi ram ih the halang! ");
INSERT INTO tvt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ngah seng wah jiinnah ngaakwang angno baatwan ang, “Ewah, ngah ih Rangte damdi nyia an ngathong ni rapne ih rangdah molang. ");
INSERT INTO tvt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aadowa ih ngah an sah ih poon suh tapunkang; an ih ngah ah mootkaatte wasiit ih samthun hang.’ ");
INSERT INTO tvt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Eno heh ah dokchap ano heh wah jiinni ngaakwangta. “Heh wah ih japtupta tok adi heh ah nok nawa haloot ni dook angta; ang abah uh heh wah heh thungthet lam ih soonkah ano, heh sah rah khonjoh ano chupphakta. ");
INSERT INTO tvt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Ewah,’ heh sah rah ih liita, ‘Nga Rangte nyia an ngathong ni rapne ih rangdah molang. Ngah aadowa ih an sah et jen li suh takah pun kang.’ ");
INSERT INTO tvt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ang abah uh heh wah ih heh laksuh loong ah poon rum ano baatta, ‘Echaan!’ Heh ih liita, ‘Samsong jaase thoon ang arah jam koh jahan eno song thuk an. Heh lak nah laktiip ah tiipkoh eh an heh lah nah lakhoop ah khoop thuk ih an. ");
INSERT INTO tvt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Erah lilih maan etotot ah jowang anno joot an, eno seng loong ah saroom room ih! ");
INSERT INTO tvt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tumeah arah nga sah ah etek eta, eno amadi heh engaakthing ela; heh mat eta, eno amadi jap jamhi. Eno saroom phaksat ah phang choongchaam rumta. ");
INSERT INTO tvt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Erah tokdi heh sah phokhoh wah ah phek ni angta. Heh ngaakwang ha di, heh nok ko ih tiitthok damdam ih, heh ih boongkaat seehoon ang arah japchaatta. ");
INSERT INTO tvt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Eno heh ih laksuh wasiit ah poon ano chengta, ‘Tumjih angla?’ ");
INSERT INTO tvt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","An no ngaak wang taha,’ laksuh rah ih ngaakbaatta,’ eno an wah ih etotthoon maan ah joot thuk tahe, tumeah heh ah naririh punpiipi ih ngaak wang taha eah.’ ");
INSERT INTO tvt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Phokhoh wah ah rapne ih khata nok ni uh lawang thang ah; eno heh wah ah kah ano ‘nok nah wang ho’ ih heh lasih joh lam ih poon kata. ");
INSERT INTO tvt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Eno heh wah asuh liita, ‘Sokthaak hang, paangtang ih ngah ih an suh dah likhiik ih reeraang pakna lang, an jeng uh lanaan daan thang ah. Eno an ih ngah suh tumjih kohalang? Nga joonte damdoh roong joon phaksat suh ki esiit taan uh tatek haat thuk rang! ");
INSERT INTO tvt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Eno arah an sah rah ih an dowa nyamka ah pheesuh hoono hansangte minuh damdi ngun loong ah thaaja kaat ano, ngaakwang hala asuh an ih maan elongthoon ah kadook kohu nih!’ ");
INSERT INTO tvt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Nga sah,’ heh wah ih ngaakbaatta, ‘An ah aani saarookwih nga damdi, eno jirep nga dowa loong ah an raangtaan. ");
INSERT INTO tvt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Erah nang ih bah seng loong ih tenroon lam ih thong room phaksah theng, tumeah an no ah tek nawa, we ngaakthingla, heh jen mat eta, rah we jap jamhi.” ");
INSERT INTO tvt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisu ih heliphante loong suh baatta, “Teewadi changteng wasiit angta heh nyamka loong ah heh laksuh suh maak thukta. Changteng wah asuh baat rumta heh laksuh ih bah heh nyamka rah lalangka ni thaajaaha eah. ");
INSERT INTO tvt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Erah thoidi heh laksuh ah poon ano liita, ‘Arah ngah ih an tiit tumjih japchaat hang? Thoontang ngaakwanho an suh nga nyamka mathan ban maak thuk taha loong rah ah, tumeah an aadowa ih nga mootkaat phanlante takah angko.’ ");
INSERT INTO tvt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Laksuh rah ih heh teeteewah suh liita, ‘nga changte wah ih ngah ah arah motang dowa etoohaat et thukte. Eno bah ngah ih tumjih re ang? Ngah ih phek uh tabaam jen phekkang, eno bikthaang suh uh rakmuurakke nih. ");
INSERT INTO tvt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Amadi ngah tumjih reejih ah jat ih ang! Eno nga mootkaat ah thoon abah, nga joonte loong eje neng ih ngah neng nok nah poon et hang.’ ");
INSERT INTO tvt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Eno heh ih heh changte wah nyamka namte loong mih ah lompoon ano baat rumta. Heh ih jaakhoh wah thoon asuh chengta, ‘an ih nga changte wah dowa mathan nam tu?’ ");
INSERT INTO tvt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Olip bangthiing thuung chaasiit, heh ih ngaakbaatta. Mootkaat phanlante rah ih baatta; ‘an di arathan,’ ‘tong uh rook banga et raang uh.’ ");
INSERT INTO tvt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Eno heh ih wahoh suh we chengta, ‘an ih aleh mathan nam tu?’ ‘Ata tiik haajaat siit thekook namtang,’ heh ih ngaakbaatta. ‘Arah than an ih kotjih ah,’ Laksuh rah ih baatta; ‘Cha asaat et raang uh.’ ");
INSERT INTO tvt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Erah thoidi changte wah ih phanlante maakthiwah ah jeng lachaat thang ih reeraangta asuh egu etjih ih hoonta; tumeah, arah mongrep dowa mina loong ah maama nyamka phanlan suh maakthih totoh weephaak mina loong ah nang ih ah.” ");
INSERT INTO tvt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Erah dam ih Jisu ih li rumta, “Erah thoih ih ngah ih baat rumhala: sen ih arah hatoh nyamka ah maak anno sen joonte ah hoon an, eno erah nyamka loong ah thoon sa doh, sen ah roitang lathoon theng nok adoh soongraang noppoon han. ");
INSERT INTO tvt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","O mina ehinsah adi jen tuungmaang ah erah mina ah elongwah asuh uh ejen tuungmaang eah; o mina ehinsah nah phang thih abah elong nah uh ethih ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Erah ang abah, sen hatoh nyamka adoh laphang toongtang kanbah, amiisak nyamka asuh tang mame jen toongtang baat an? ");
INSERT INTO tvt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Erah dam ih mihoh hukkhaak asuh sen laphang toongtang kanbah, an hukkhaak loong ah an suh uh o ih ma koho? ");
INSERT INTO tvt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Laksuh wasiit ah changte wanyi nok nah tajen moka; heh ih wasiit asuh mongnook ano wasiit ah miksuk jaatjaat et ah; heh ih wasiit dam adoh toongtang ang ah eno wasiit dam adoh toongtangka tah angka ang ah. An ih Rangte nyia ngun enyiinyi an changte tajen et hoonko. ");
INSERT INTO tvt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisi loong ih erah japchaat rum ano, Jisu ah putbeek ngitkhuung rumta, tumeah neng ih ngun ah mongnook rumta. ");
INSERT INTO tvt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jisu ih baat rumta, “Sen loong ih senteewah ah mihoh miksok di epun et noisokte mina loong, enoothong sen tenthun ah Rangte ih jat ih halan. Tumeah marah suh mina ih thaangchaan thoon ih thiik ha ah Rangte raang ih thaangmuh ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses Hootthe nyia khowah loong ih raangta loong ah Juungtemte Joon tuk ih maak rumta; erah lih adi Ruurang Ese Rangte Hasong tiit ah baat rumha, eno erah hasong adoh nop suh laat tuutmui rumla. ");
INSERT INTO tvt_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Enoothong Hootthe nawa jengdang ehinsah esiit taan uh lamatjih erah nang ih bah rang nyi hah mat ah elaang laan ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“O mina ih heh nusah dowa paak ano mihoh weekap abah heh ih roomjup mat ah kap ha; eno epaakcho minuh we kapte warah eh uh roomjup mat ah kap ha. ");
INSERT INTO tvt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ehak di changteng wasiit angta heh ah thaangchaan nyuh akhat di choom ano saarookwih laboot labe ih songtongta. ");
INSERT INTO tvt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Erah di changthih wasiit heh men ah Lajaras, heh sak ah putang ih jeekma arah changteng wah nok kaaluung thong ni ban tongta, ");
INSERT INTO tvt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","changteng wah tuibung teebun khui ni thaaja arah bantoon phaksate angta. Heh ma adi hui loong ih nep miiklak ih rumta. ");
INSERT INTO tvt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Changthih wah ah tek ano rangsah loong ih Abraham re nah tongthuk suh siit wanrumta rangmong nawa sadung phaksat adi ah. Changteng wah ah tek ano bengkaatta, ");
INSERT INTO tvt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","eno soolam ni, heh rapne ih chamwangta, heh rangkho ko ih toonsok adi haloot ni Abraham ah japtupta, Lajaras ah Abraham re adi tongta. ");
INSERT INTO tvt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Eno heh ih poonta, ‘Ewah Abraham! Ngah minchan ih weehang, Lajaras ah daapkaat weeho heh laktiik ah juung adoh tem ano nga tuuhih adoh taan toom tengtem jah weehang, tumeah arah we adi ngah rapne ih chamlang!’ ");
INSERT INTO tvt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Eno Abraham ih liita,” Dokthun et uh, nga sah, an roidong di an suh jaatrep eseejih loong ah kotaho, erah di Lajaras ah jaatrep ethih loong ah chota. Erah thoidi amadi heh tenroon ih tongla, eno an ah cham elu. ");
INSERT INTO tvt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Erah loong tokkhodi, seng chamchi ni echoongwah haluung jeela, erah doh o mina uh aako nawa an reeko tami daankhoom raari, adoleh an reeko nawa uh aako nah tami daankhoom raaran.’ ");
INSERT INTO tvt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Changteng wah ih liita, ‘Erah ang abah, an lasih joh weehala, ewah Abraham, seng wah nok nah Lajaras ah kaat thuk weeuh, ");
INSERT INTO tvt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","erah di nga nooloong wah banga je ah. Heh kah ano toom choophaan kah weerum ah, arah than chamchojih adoh neng ah taan naktoom mok wang we rumha.’ ");
INSERT INTO tvt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraham ih baatta, ‘An nooloong di Moses nyia khowah loong eje neng suh baatte ah; neng ih erah loong jeng ah kapjih ang ah.’ ");
INSERT INTO tvt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Changteng wah ih ngaakbaatta, ‘Erah ah talaaleh weeka, ewah Abraham! Erah nah o ang abah uh tek nawa ngaaksaat ano neng reenah kah abah, neng rangdah nawa elek eah.’ ");
INSERT INTO tvt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ang abah uh Abraham ih liita, “Neng ih Moses nyia khowah loong jeng ah lachaat rumka bah, tek nawa ngaaksaatte taatje abah uh neng ih tabaam kapka.’” ");
INSERT INTO tvt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisu ih Heliphante loong suh baatta, “Mina rangdah nah dat hoom jih ah eje jaatjaat ang ah, enoothong erah loongdat hoomte ah raang ih tumthan ethih ang ah! ");
INSERT INTO tvt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Erah mina rah ih bah heh boh adoh jong ah bonchi ano juungsih nah datpit ah ese ang ah, nga liphante changthih noodek loong asuh rangdah dathuk nang ih bah ah. ");
INSERT INTO tvt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Erah raang ih an tumjih reelu erah ban sok et uh! “Anphoh anno ih rangdah re abah, kanja et uh, eno rangdah nawa elek eah abah, biin anaan et uh. ");
INSERT INTO tvt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Heh ih an damdoh saasiit doh jaasinet taan thetre leh, erah thetre ah saapoot rookwih an re nah baat ho, ‘Ngah rangdah nawa ngaaklek elang, biin anaan weehang eah, ‘An ih biin anaan et theng.” ");
INSERT INTO tvt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Heh kaamwah loong ih Teesu suh baat rumta, “Seng tuungmaang ah ehan han ang thuk he.” ");
INSERT INTO tvt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Teesu ih ngaakbaat rumta, “Sen doh sen tuungmaang ah miinjaangjih thanthan jen ang abah, sen ih arah potiik bang asuh jen baat et an, ‘An hing paan ih an loplopdat eh uh no juungsih adoh phook kah uh!’ Eno amiisak ih an jeng chaatchaat eah. ");
INSERT INTO tvt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Jengthaak ih sen wasiit thandoh laksuh phek bokte adoleh Saapriimte toom angthaak ah. Heh phek nawa thok ha doh, phaksat chaak phaksah uh eh nih banbaat uh? ");
INSERT INTO tvt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Emah tabaam baatko! Erah nang ih bah, an ih heh suh baat uh, nga phaksat chaak khookham kohang eno an choom ah jamkap uno nga phaksat juung jok tok ah ban sok hang; erah lidoh an ih we phaksah uh.’ ");
INSERT INTO tvt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Laksuh ah changte wah jeng chaat thaang lakookmi jengkhaap tabaam choka, emah ang tam eah? ");
INSERT INTO tvt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Emamah sen doh uh elang ela; sen suh mootkaat theng marah baat tahan ah thoon moh an no jeng an, ‘Seng bah jojang laksuh, seng reejih tumjih angta erah ba reeti.’” ");
INSERT INTO tvt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Eno Jisu Jirusalem nah kaat suh li ano Samaria nyia Galili chaamchi ko ih dokkhoom kata. ");
INSERT INTO tvt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Heh hadaang esiit ni nopwang adi engam wah asih chomuita. Neng haloot ni chap rum ");
INSERT INTO tvt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ano riing rumta, “Jisu! Nyootte! Seng minchan weehe!” ");
INSERT INTO tvt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisu ih neng ah tup rum ano baat rumta, “Kah an, eno romwah loong ih toom soksam han.” Neng loong ah lam ni saade rumta. ");
INSERT INTO tvt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Neng dung dowa wasiit rah ih heh deeta rah jat ano, ngaak wang taha, eno erong ih Rangte rang ah phoongphaata. ");
INSERT INTO tvt_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Eno Jisu lathong adi khopjup ano lakookmi jengkhaap ah raata. Erah mih ah Samariate angta. ");
INSERT INTO tvt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisu ih liita, “Khoisat deete ah wah asih boh ang rumta; wah akhuh ah mani ah? ");
INSERT INTO tvt_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Arah mihah wah ah Rangte suh lakookmi jengkhaap ra heh laklak mame ngaakwang hala? ” ");
INSERT INTO tvt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Eno Jisu ih heh suh baatta, “Toonchap uno wang uh; an tuungmaang ih an khoisat ah deesiit halu.” ");
INSERT INTO tvt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mararah Pharisi ih Jisu suh chengta Rangte Hasong ah maatok doh thok ha. Heh ih ngaakbaatta, “Rangte Hasong ah japtupjih tah ih thok ra. ");
INSERT INTO tvt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","O eh uh tabaatka ang ah, ‘Sok uh arah ni thok hala eah!’ adoleh, ‘Therah ni thok hala eah!’ tumeah Rangte Hasong ah sen damdam di.” ");
INSERT INTO tvt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Eno heliphante loong suh baatta, “Saapoot thok eha sen ih mina Sah ah sok suh ram an rah ah, ang abah uh sen ih tajaptup kan. ");
INSERT INTO tvt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Erah tokdoh sen suh mih ih baat han rah je ah, ‘Therah koh ih sokthaak uh!’ adoleh aako ih sokthaak ho!’ Enoothong, sen ih erah nakmok jam sokkah an. ");
INSERT INTO tvt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Rang ni rangsummeh ah rongsiit ni jap leh ronghoh ko kah ih phaak arah rah likhiik, mina Sah rah uh heh rangwuung saakaan thok ha doh emamah ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Enoothong jaakhoh heh ah chamjaatjaat ejih eno aahaangwa mina loong ih chiik haat nep chaak et ah. ");
INSERT INTO tvt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nuah tokdi angta likhiik Mina Sah tokdoh uh emamah ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Warep mina siiphak khamjok nyia minuh miwah kuhoon lam ih tongtha ah, eno Nuah ah Khoonkhuung adi dungtong ano erah pootdi juung ah nuung ano mina loong ah mata. ");
INSERT INTO tvt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Erah tok ah Loot tokdi angta rah likhiik ang ah. Mirep erah tokdoh ejok ephak tok, eriik esang tok, eki nyia ehoon tok ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sodom nawa Loot dokkhoomta lini, rang nawa we nyia koonthook ah rangphaat likhiik ih dat kah ano miloong ah chum tekhaat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mina Sah dong raaha sa doh emamah ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Erah sa doh o mina nok khoni angte rah ih nokmong nawa hukkhaak toon lajaatjaat datkaat jih; erah likhiikkhiik o mina phek ni angte rah nok nah tajaatjaat ngaak wangka. ");
INSERT INTO tvt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Loot nusah rah samthun an! ");
INSERT INTO tvt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","O mina ih heh roidong piipaang thun ah erah ih mat haat et ah; O mina ih heh roidong mat haat ah erah mih ah epi eah. ");
INSERT INTO tvt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ngah ih baat rumhala, erah rangphe ja, khokhom esiit nah mih enyi roomjup arah ang ah eno: wasiit ah toonsiit et ah wasiit ah thiinhaat et ah. ");
INSERT INTO tvt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Minuh enyi raanthom nah raan roomthu arah ang ah: esiit ah toon et ah, esiit ah thiinhaat et ah.” ");
INSERT INTO tvt_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mih wanyi phekmoot ah: wasiit ah toon et wasiit ah thiinhaat et ah. ");
INSERT INTO tvt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Heliphante loong ih cheng rumta, “Maanah ah, Teesu?” Jisu ih ngaakbaatta, “Marah doh mih mang ang ah, erah doh hukunnuh loong lomkhoon ah.” ");
INSERT INTO tvt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Eno Jisu ih heliphante loong suh tiitthaak baat lam ih nyootta neng ih saarookwih babah uh lathungjoong thang ih rangsoom nah tongtheng eah. ");
INSERT INTO tvt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Samthung esiit ni mat hoonte wasiit angta Rangte ra uh lacho eno mih suh mih lali thang ah. ");
INSERT INTO tvt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Erah hah adi thaknuh esiit heh reeni heh mat hoon thuk suh ban wang ruh ih taha, ‘Nga siikhaamte dowa pang weehang!’ ");
INSERT INTO tvt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mat hoonte warah ih erah nuh mat hoonkot ah ban daan ruh kah eta, eno hethoondi heh teeteewah ih lengthun ano liita, ‘Rangte nyia mina rah lacho kangbah uh, ");
INSERT INTO tvt_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","arah nuh rah ih nga ban sootroot ruh ih halang, erah thoidi ngah ih heh mat ah ehoonjih angla. Mat ah lahoon kokangbah, heh ban wang ruh eha eno ngah phaangphak ruh ete!” ");
INSERT INTO tvt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Eno Teesu ih toombaat ruh ih rumta, “Boichaat an erah mithih wah mat hoonte jengkhaap rah ah. ");
INSERT INTO tvt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Erah ang abah Rangte ih heh mina rangwuung rangphe ih huung rumla loong ko ih roop ano tanih dande kotkoka? Heh erah miloong minchan suh elaamse nih ekah? ");
INSERT INTO tvt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngah ih baat rumhala, Rangte ih nengko ih roop ano echaan ih hoonko rum ah. Enoothong Mina Sah rah ih heh raak sa doh hatoh nah tuungmaang lam ih tong arah tam japtup ra rumha?” ");
INSERT INTO tvt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jisu ih arah tiitthaak ah uh mina loong o ih heh teeteewah suh ese ih thun ano wahoh ah kaanju eha miloong asuh baatta. ");
INSERT INTO tvt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ehak di mih wanyi Rangsoomnok ni Rangteenok ni rangsoom wang nyuuta: wasiit ah Pharisi, wasiit ah sokse seete angta. ");
INSERT INTO tvt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisi rah ih toonchap ano heteewah raangtaan ih rangsoomta, ‘Ngah ih an suh lakookmi ih li hala, Rangte, ngah nyamnyook tah angkang, ngah eleek tah angkang, adoleh ngah minuh damdi romjupte tah angkang, mihoh loong kah ang ah likhiik ah. An suh lakookmi li hala ngah sokse seete loong kah ang ah likhiik tah angkang. ");
INSERT INTO tvt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ngah ih sa sinet mongdi sa nyi samuh rangsoom katong ang eno ngah ih an suh nga mootkaat nawa asih thiik uh ekot kah eha.’ ");
INSERT INTO tvt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Eno sokse seete wah ah haloot ni chap ano rangko uh lanaan toonsok thang ih, heh teekhuh ah buh ano liita, ‘Rangte ngah minchan et weehang, ngah rangdah mina!’ ");
INSERT INTO tvt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jisu ih liita, ngah ih baat hala, “Rangte ngah ni Pharisi nang ih sokse seete warah kateng angla, heh nok ni thok adi ah. O mina heh teeteewah suh elong ih thiik ha rah ehin ih hoon ah, o mina ehin et chaang ha rah elong ih hoon ah.” ");
INSERT INTO tvt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mararah mina ih neng nodeek loong Jisu reeni heh lak ih joh ano romse toom tamkoh ah ih siitjah rum taha. Heliphante loong ah ih erah tup rum ano miloong ah kanja rumta, ");
INSERT INTO tvt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ang abah uh Jisu ih noodek loong ah poon ano baat rumta, “Noodek loong ah nga re nah toom wang rumha sen ih nak tanghaam an, tumeah Rangte Hasong ah arah noodek loong likhiik angte loong raang ih. ");
INSERT INTO tvt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Arah dangthun et an! O mina noodek likhiik tah angka loong ah Rangte Hasong nah tajen wangka.” ");
INSERT INTO tvt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jehudi phansiitte ih Jisu suh chengta, “Ese et Nyootte, ngah ih babah uh lathoonka roidong ah chosuh tumjih etjih ang ah?” ");
INSERT INTO tvt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“An ih ngah suh Ese Nyootte ih tumjih suh li halang? Jisu ih heh suh chengta. “O uh ese tajeeka Rangte luulu ba. ");
INSERT INTO tvt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","An ih jengdang loong ah jat et hu: ‘Mih minuh miwah damdoh laroomjup theng; mih latek haat theng; mih hot lahuh theng; mih lathika doh lanan theng; nuh awah jeng echaat etheng.” ");
INSERT INTO tvt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Erah warah ih ngaakbaatta, “Erah loong jengdang abah noodek dowa ih dook reelang.” ");
INSERT INTO tvt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisu ih erah chaat ano baatta, “Erah damdi an di jaatsiit boot reejih jeela. An nyamka loong ah sang uno erah ngun ah changthih loong suh pheekoh uno ba an rangmong nah nyamte ang uh; eno ba raaho no nga lih rik hang.” ");
INSERT INTO tvt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Eno erah warah ih chaat ano, heh rapne ih thungthita, tumeah heh ah rapne changteng angta. ");
INSERT INTO tvt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisu ih heh thungthita ah tup ano liita, “Tumthan echaan ah changteng loong Rangte Hasong nah jen wangsuh ah! ");
INSERT INTO tvt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Changteng loong ah rang nah jen wang nang ih bah mokchongdoot ah mikkaan po nah nopsoon ah elaang ang ah.” ");
INSERT INTO tvt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Erah japchaatte miloong rah ih cheng rumta, “Erah ang abah, o ah pui theng ah?” ");
INSERT INTO tvt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisu ih ngaakbaatta, “Marah mina di echaan angla erah Rangte di tachaanka.” ");
INSERT INTO tvt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Erah lidi Pitar liita, “Sokthaak uh! Seng ih seng nok nep thiinhaat hi an liphan suh ah.” ");
INSERT INTO tvt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Elang eah,” Jisu ih baat rumta, ngah ih amiisak ih baat rumhala o mina ih henok hetap adoleh henuh hesah hephoh heno nyia hesuh hesah Rangte Hasong thoidoh thiinhaat ah ");
INSERT INTO tvt_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","erah mina rah heh roidong doh ehan romseetam ah choh ah erah damdoh lakngah nawa babah uh lathoonka roidong ah choh ah.” ");
INSERT INTO tvt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisu ih heliphante loong asih wanyi ah hiiksiit ano baat rumta, “Chaat an! Seng Jerusalem ni kah li eno erah nah khowah loong ih Mina Sah tiit mamet raangthiin rumta jun ih amiisak ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Heh ah Rangmen lajatte loong suh korum ah, eno neng ih chikram joonnaam, adoleh kaanju et rum ah, erah dam ih neng took ih nep took rum ah. ");
INSERT INTO tvt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Neng ih ruh ih buh rum ano tek haat rum ah, enoothong sa jom lidoh heh ewe ngaakthing eah.” ");
INSERT INTO tvt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Eno heliphante loong ih erah tumjih suh liita ih tajat rumta; erah tiit ah neng ih lajat than ih huttongta, erah thoidi neng ih Jisu ih tumjih tiit baat ha tajen samjat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisu Jeriko reeni thok ha di, edook wasiit lamkaang ni tong ano, bit banthaangta. ");
INSERT INTO tvt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Miloong daankhoom ah chaat ano, chengta, “Erah tumjih ah?” ");
INSERT INTO tvt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Najaret nawa Jisu daankhoom kala,” neng ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Eno heh ah riinghuungta, “Jisu! Dewid sah! Ngah minchan weehang!” ");
INSERT INTO tvt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Heh reeni chapta miloong ah ih kanja rum ano, suusu ih tong uh ih baat rumta. Ang abah uh heh ah erong we boot riingta, ”Dewid sah!” Ngah minchan weehang!” ");
INSERT INTO tvt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Eno Jisu ah tangchap ano edook ah heh jiinko ih siitkaat suh baatta. Eno, Jisu ih chengta. ");
INSERT INTO tvt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ngah ih an suh tumjih jen hoon koha ih thunhu?” “Nyootte,” heh ih liita, ngah ih nga mik ih ewe tup ih suh ramlang.” ");
INSERT INTO tvt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Eno Jisu ih baatta, “Erah ang abah tup uh! An tuungmaang ih deethuk halu.” ");
INSERT INTO tvt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Erah damdam ih heh ih laantup ruh eta eno heh ah Jisu lini roong khoomta, Rangte suh jengseera lam ih ah. Miloong ih erah tup rum ano loongtang ih Rangte rangphoong rumta. ");
INSERT INTO tvt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisu ah Jeriko hadaang ni wangta eno erah lam ih daankhoomta. ");
INSERT INTO tvt_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Erah di phokhothoon sokse seete heh men ah Jakaias, changteng wah angta. ");
INSERT INTO tvt_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Heh ih Jisu ah o angla ih jat suh taatwoot sokta, ang abah uh heh ah etho ang thoidi midung nawa ih Jisu ah tajap tupta. ");
INSERT INTO tvt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Erah thoidi miloong ngah ko ih soonkah ano Jisu daankhoom ah japtup suh puksak bangni duungta. ");
INSERT INTO tvt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisu ah erah rum adi thokkhoom haano, rangko ih toonsokta, eno Jakaias suh baatta, “Echaan ih dat raaho, Jakaias, tumeah chiinyah ngah an nok nah tong jaatjaat eh ang.” ");
INSERT INTO tvt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jakaias ah echaan ih dat kah no Jisu ah tenroon lam ih poon kaatta. ");
INSERT INTO tvt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Miloong loongtang erah sok rum ano tuwaan rumta, “Arah mih ah rangdah mina nok ni wenwah ih hoon kala nih!” ");
INSERT INTO tvt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jakaias toonchap ano Teesu asuh baatta, Chuupha! “Boichaat uh! Nga nyamka thotli ko ah changthih loong suh phe koh ang, erah damdoh ngah ih o mina dowa huda ih thaang phaksatang loong asuh lekbaji than ehan we ih boot korum ang.” ");
INSERT INTO tvt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisu ih heh suh baatta, “Khopiiroidong ah chiinyah arah nok adi thok hala, tumeah arah mih rah uh, Abraham sutoom satoom. ");
INSERT INTO tvt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mina Sah ah emat ete loong jam suh nyia pangsuh ra taha.” ");
INSERT INTO tvt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Miloong ih erah banchaat rum adi, Jisu ih tiitthaak tiit wakbaat rumta. Heh ah erah di Jerusalem mong ni ejen thok eta, eno miloong ah ih Rangte Hasong ah thok nanah heh ang kola ih samthun rumta. ");
INSERT INTO tvt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Eno heh ih liita, “Teewadi men anaam pan mih wasiit deek hoh haloot nah luungwang ih hoon kah ano heh nok nah we ngaak wangsuh thunta. ");
INSERT INTO tvt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Eno heh maang dokkhoom ngakhoh ni, heh laksuh wah asih ah lompoon rum ano heh ih hun jaan ngun esiit esiit ih koh ano baat rumta, ‘Ngah moongkhoom angdoh sen ih arah ngun rah ih jaat phe kaat an.’ ");
INSERT INTO tvt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amadi, heh mina loong ah ih heh ah miksuk et rumta, erah thoidi heh lilih ruurang baatte ah daapkaat rum ano jeng thuk rumta, ‘Arah mih ah seng ih seng luungwang et hoon suh tanookke.’ ");
INSERT INTO tvt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Eno erah mih ah luungwang jen hoon kah ano we ngaakwangta. Erah damdam heh ih heh laksuh loong ah heh jiinni lompoon thukta, neng ih mathan than et dongniik rumta erah jat suh ah. ");
INSERT INTO tvt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Phangkhothoon wah ah wangha no baatta, ‘Chuupha, an ih esiit kotahang dowa ih ngah ih hun lo asih boot niik tang,’ ");
INSERT INTO tvt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Ese ih reetu,’ heh ih liita, ‘An ah wah se laksuh! An amasah di tuungmaang uno jen reetu bah, Ngah ih an samnuthung hah asih soksamte ih thiinha.’ ");
INSERT INTO tvt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Erah lilih laksuh wasiit ah wangha no liita, ‘Chuupha, An ih lo siit kotahang dowa ih hun jaan ngun lo banga boot niik tang.’ ");
INSERT INTO tvt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Erah wah asuh liita, ‘An ah hah banga soksamte ang uh!’ ");
INSERT INTO tvt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Laksuh wasiit ah wangha no we baatta, “Chuupha, arah an hun jaan ngunsah rah ah; ngah ih nyulep ni thoopkhak angno huthiin tang. ");
INSERT INTO tvt_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ngah ih an ah mithih ih jat eh taha, eno cho etang. An ih andi lah angka ah kapte nyia an ih lakiiko dowa huite mina.’ ");
INSERT INTO tvt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Heh ih laksuh asuh liita, “Lajak, laksuh an ah! Ngah ih an jengjeng nawa dut haat hala! An ih jat et hu ngah mih chaan eah, ngah ih ngah di lah angka rah kakap ang nyia ngah ih lakiikang dowa kahui ang eah. ");
INSERT INTO tvt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ese ang ah, erah bah uh, an ih ngunnok ni taan lathiin wan mamet tu? Erah dobah ngunnok adoh hesut heboot taan ngah ngaakwang tokdoh eje ang thengta.” ");
INSERT INTO tvt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Eno heh ih erah di chaapte loong asuh baatta, ‘Hun ngunsah ah heh dowa esiit ah nge anno asih niikte laksuh asuh bootkoh an.’ ");
INSERT INTO tvt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Eno neng ih liita, ‘Chuupha, heh di hun ngunsah asih eje laangma ah!’ ");
INSERT INTO tvt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Heh ih ngaakbaat rumta, ‘Ngah ih amiisak tiit baat rumhala,’ ‘O di amasah jeela, erah suh ehaan et bootkoh ah, enoothong o di tajeeka, amasah taat angta rah uh ethoon nge et ah. ");
INSERT INTO tvt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Amadoh, nga pi nga ra loong ah o ih ngah suh seng luungwang naktoom ang ah ih liite loong ah, adoh siitwan hanno nga pandoh tek haat an!’” ");
INSERT INTO tvt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisu ih erah baat rum ano nengngah nengngah Jerusalem ko ih wangta. ");
INSERT INTO tvt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Neng Betpheej nyia Bethani reeni Olip kong ko ih thokrum adi, heliphante wanyi neng ngani daap wanta ");
INSERT INTO tvt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","amet baat ano ah: “Set ngah ni hadaang esiit je ah erah doh wang ansih; erah wang ansih doh, set ih moktosah bonthiincho tupwang ansih babah uh lathaak tumsiitka rah ah. Ja ansih no anah siitjah hansih. ");
INSERT INTO tvt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mih ih tumet suh ja hansih, et cheng hansih bah, erah suh baat theng changte ih jamha eah.” ");
INSERT INTO tvt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Eno nyi ah kah nyu ano Jisu ih baat nyuuta jun ih japtup nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Eno moktosah ah ja nyu adi changte wah ih cheng nyuuta, “Tumet suh ja hansih?” ");
INSERT INTO tvt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nyi ih ngaakbaat nyuuta, “Changte ih jamha,” ");
INSERT INTO tvt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","eno moktosah ah Jisu jiinni hoom wan nyuuta. Eno moktosah sakkhoh adi neng nyuh ah dekoh rum ano Jisu ah dung thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Eno Jisu ah moktosah khoni wang damdam, miloong ih nengnyuh nengkhat loong ah lam adi ban dam wanrumta. ");
INSERT INTO tvt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Neng Jerusalem reeni thokrum ano, Olip Kong lamko dat kata adi, mih hantek heliphante loong ah erong rongwah ih Rangte rangphoong lam ih lakookmi ih liirumta epaatja theng reeraang loong japtup rumta asuh ah: ");
INSERT INTO tvt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Rangte mendi ra taha luungwang asuh Teesu ih romseetam koh ah!” Rangmong nah semroongroong ang ah eno Rangte aju phaak ah!” ");
INSERT INTO tvt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Eno mararah Pharisi ih midung nawa ih Jisu suh liita. “Chuupha,” neng ih liita, “An liphante loong ah nak toom cheekti rum ih baat uh!” ");
INSERT INTO tvt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisu ih ngaakbaatta, “Ngah ih baat rumhala, nga liphante loong ah suusu taat ih tong rum abah uh, jong loong we toonriing rum ah.” ");
INSERT INTO tvt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Heh samnuthung ko ih tiitkhoom ano, sokta eno heh mikse ah jan eta, ");
INSERT INTO tvt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","eno liita, “Semroongroong ah mamah ang adoh se ih sen ih chiinyah taan ba lajattan! Enoothong amadoh ba sen ih takah tupkan! ");
INSERT INTO tvt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Senpi senra loong ih kooknak hanno sen lam ah wanrep nawa ih tangpa han rah saapoot ah thok eha. ");
INSERT INTO tvt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Neng ih sen nyia sen noksong loong ah tek haat et han; jongteh tesiit taan uh erah nah tadakka, tumeah sen pangsuh Rangte ra taha saapoot ah tasamjattan!” ");
INSERT INTO tvt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Eno Jisu ah Rangteenok nok ni wang ano thaangsangte loong ah dokphan wang rumta, ");
INSERT INTO tvt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","neng suh amet liirumta, “Rangteele ni raang arah Rangte amet liita, ‘Nga Rangsoomnok ah rangsoom theng ang ah.’ Enoothong sen ih ehuh loong hottong theng et hoon han!” ");
INSERT INTO tvt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Saarookwih Jisu ih Rangteenok ni nyootsoot rumta. Romwaphokhoh loong, Hootthe nyootte loong, nyia phokhoh mihak loong ih heh tek haat chung rumta, ");
INSERT INTO tvt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","enoothong neng ih heh tek haat lampo ah tajap jam rumta, tumeah miloong rah heh jeng ban boichaat ruh et rumta, tiitkhaap esiit taan laphut haat ih boichaat thung ang rumta. ");
INSERT INTO tvt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Saasiit Jisu ih Rangteenok ni miloong asuh nyootsootta nyia Ruurang Ese tiit baatta adi, romwah phokhoh nyia Hootthe nyootte loong, ah mihak phokhoh loong damdi roong ra rumha no ");
INSERT INTO tvt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","li rumta, “Baat thaak he, an arah loong ah o chaan nawa ih reeraang lu? Arah jen reetheng chaan ah an suh o ih kotaho?” ");
INSERT INTO tvt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jisu ih ngaakbaat rumta, “Amadoh sen suh jengkhaap chaak cheng rumha. Baat he, ");
INSERT INTO tvt_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Juungtemte Joon ih juungtem kahoon arah Rangte jiin nawa tama mina jiin nawa chota?” ");
INSERT INTO tvt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eno neng chamchiini phang daanmui rumta, “Seng ih mamet baat ih? Seng ih ‘Rangte re nawa’ et li ih bah, ‘Erah ang abah, sen ih Juungtemte Joon ah mamah lahanpi ih han?’ ih li baat he. ");
INSERT INTO tvt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Eno ‘Mina re nawa,’ ih mok baat ih bah, arah than miloong ah ih seng ah jong ih paat he, tumeah neng ih Joon ah khowah ih ejen jat et rumta.” ");
INSERT INTO tvt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Erah thoih ih neng ih amet ngaakbaat rumta, “Seng ih tajatke ma nawa ra taha rah ah.” ");
INSERT INTO tvt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Eno Jisu ih li rumta, “Erah ang abah, ngah marah nawa chaan ih jen reelang erah uh sen suh tabaat rumra.” ");
INSERT INTO tvt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Eno Jisu ih arah tiitthaak ah miloong suh baatta: “Teewadi mih wasiit ih potiik phek phekta, eno phekphoop phekte suh phek thukta, eno heh ah saaloh dook ih heh nok ni tangtong wangta. ");
INSERT INTO tvt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Eno anggut tiik huitok ah chang ano, changte warah ih phekphoop phekte wah jiinni heh dah ah daapwan ano heh dabbi ah suwang thukta. Enoothong phekphoop phekte loong ah ih dah ah buh rum ano hahuung we ngaakdaap rumta. ");
INSERT INTO tvt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Eno heh ih dah wahoh we daap wanta; erah uh phekphoop phekte loong ah ih emamah we buh rum ano, heh rakri laandong ruh ih li wanrumta, eno hahuung we ngaakkaat thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Eno changte warah ih takjom adi wasiit we daap wanta; phekphoop phekte loong ah ih erah warah uh rapne ih buh rum ano, haatkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Eno phek changte warah ih liita, ‘Ngah ih tumjih et ang nih? Ngah ih nga mongnook sah ah laan daapwan ang; neng ih boleh esoomtu jaatjaat et rum anih!’ ");
INSERT INTO tvt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Enoothong phekphoop phekte loong ah ih japtup rum ano, neng chamchi ni wasiit wasiit suh hubaat mui rumta, ‘Arah tang changte wah sah joh. Heh ah tek haat ih no, heh nyamka loong ah thong toom kap ih!’ ");
INSERT INTO tvt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eno neng ih tekbuh rum ano phaakkhuh ni haatkaat rumta. “Erah ang abah phek changte warah ih phekphoop phekte loong ah tumjih et ah?” Jisu ih cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Heh ah wangha no phekphoop phekte loong ah tek haat et ah, eno wahoh suh we phek thuk ah.” Miloong ah ih erah chaat rum ano edaan et rumta, “Emabah mabah uh tah angka!” ");
INSERT INTO tvt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisu ah nengko ih sok ano cheng rumta, “Erah ang abah, Rangteele ni arah raangha rah tumjih suh liita? ‘Nok hoonte ih jong ah maak di tachapka ih li ano thaangmuh jong et piihaatta rah, thoontang nang ih elongthoon maak di chapla.’ ");
INSERT INTO tvt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","O bah uh erah jong khoh adoh dat ah hechep hechep ih jopkhan ah; erah dam ih erah jong ah o sak khonah bah uh mok dat abah, erah mih ah bungwiik nah bunram ih matpat ah.” ");
INSERT INTO tvt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Romwah phokhoh nyia Hootthe Nyootte loong ih Jisu ah erarah doh khak suh taat chung rumta, tumeah neng ih ejat et rumta heh ih neng suh li thung ang ano erah tiitthaak ah baat ha eah; enoothong neng ah miloong ra cho rumta. ");
INSERT INTO tvt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Erah thoidi neng ih heh thetre ah hubansok ruh et rumta. Neng ih mararah mih asuh ngun ah hukoleh toongtang likhiik ih diip reeraang thuk rumta, eno leh Jisu reeni mat ih deejoot suh tumjih tumjih diipcheng wang thuk rumta, tumeah Room hate ngoong awang nyia Kobono suh jootkhak kot suh chung rumta. ");
INSERT INTO tvt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Heh juujeengte loong ih Jisu suh baatta, “Nyootte, seng ih jat ehi marah an ih nyoot hu rah epun eah. Seng ih jat ehi an ih o ang abah uh ehin elong tadandeeko, erah nang ih mina suh Rangte thungpunjih amiisak tiit ah nyootsoot hu. ");
INSERT INTO tvt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Baat thaak he, seng ih Roman Luungwanglong suh, seng Hootthe jun ih sokse ah ekot tam koke?” ");
INSERT INTO tvt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Enoothong Jisu ih neng mongtham ah jat ano li rumta, ");
INSERT INTO tvt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ngunkholok ah noisok thaak he. Arah ngun adi o laaphaang ah nyia o men ah?” “Luungwanglong men nyia heh laaphaang,” neng ih ngaak baatta. ");
INSERT INTO tvt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eno Jisu ih baat rumta, “Ese ang ah, erah ang abah Luungwanglong dabbi ah Luungwanglong suh ju koh an, eno Rangte dabbi ah Rangte suh ju koh an.” ");
INSERT INTO tvt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Erah di noksong ngathong ni neng ih hejeng matjoot jih tajap chaat rumta erah thoidi suusu ih tong rum ano, heh jeng ngaak asuh paatja rumta. ");
INSERT INTO tvt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Eno mararah Sadusi miloong ih, mina tek nawa tangaak thingka ih liite loong ah, ra rumha no Jisu suh cheng rumta, ");
INSERT INTO tvt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Nyootte, Moses ih seng suh arah Hootthe ah raangthiinta: ‘Miwah ah tek ano, heh minuh ah sah muh et thiinhaat abah, thaknuh rah etekte no rah ih kap jaatjaat ejih, eno heh sah ah dong tup ano etekte wah sah et thiik ah.’ ");
INSERT INTO tvt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Teewadi soophoh wasinet angta; phokhothoon ah ih heh minuh ah kap ano sah muh ih mattiita. ");
INSERT INTO tvt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Eno minuh rah miidamwah dam adi we chosongta, ");
INSERT INTO tvt_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","erah lilih noolih damdi we chosongta. Emamah soophoh wasinet ah neng sah muh ih matti rumta. ");
INSERT INTO tvt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lithoon adi, minuh ah thoon mattiita. ");
INSERT INTO tvt_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Eno bah, tek nawa ngaakthing sa doh, erah nuh ah o sanuh angtheng ah? Tumeah erah nuh ah soophoh wah sinetnet damdi chosongta.” ");
INSERT INTO tvt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisu ih ngaakbaat rumta, “Ahaang roi dowa minuh miwah loong ba nook mui rumla, ");
INSERT INTO tvt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","enoothong minuh miwah o ang abah uh tek nawa jen ngaakthing ete loong nyia lakngah nawa roidong adoh thingtongte loong abah tanook mui rumka ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Neng ah latek thang ih rangsah loong likhiik ang rum ah. Neng loong ah Rangte sah ang ah, tumeah neng tek nawa ngaaksaat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Eno Moses ih samsek ih jatthuk ha etekte ah ewe ngaakthing ete eah. Bangphook ni we luungta tiit raangha adi Moses ih Teesu suh Abraham Rangte, Isak Rangte nyia Jaakob Rangte ih liita.’ ");
INSERT INTO tvt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Heh ah ethingte loong Rangte, etekte Rangte tah angka, heh nawa ih thoontang ah ething.” ");
INSERT INTO tvt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mararah Hootthe nyootte loong ah toonjengta, “Ese ih ngaakbaat hali, Nyootte!” ");
INSERT INTO tvt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Eno erah tokkhodi neng ih takah naan cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisu ih cheng rumta, “Kristo ah Dewid sutoom ih mamet mi liita? ");
INSERT INTO tvt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tumeah Dewid heh teeteewah ih Dewid Boong leedap adi liiha, ‘Teesu ih nga Teesu suh liita: Nga jaawako adoh tong uh ");
INSERT INTO tvt_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","anpi anra loong ah ngah ih an lakhu nah maang langlang thuk ah.’ ");
INSERT INTO tvt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewid ih heh suh ‘Teesu’ et liita; erah ang abah, Kristo ah Dewid sutoom mamah mi ang ah?” ");
INSERT INTO tvt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Miloong ih heh jeng boichaat rumta adi, Jisu ih heliphante loong suh baatta, ");
INSERT INTO tvt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Sen teeteewah Hootthe nyootte loong dowa sokthun samthun ih tong an, neng samsong elootlootwah ih song rum ano thaangsang thengnah mih ih jengseera nyia soomtu ah seechoh rumha; neng ih Jehudi loong rangsoomnok ni tongtheng ese ban thiin thuk nyia sadung theng ni tongtheng ese nah tong suh thunte loong re nawa ah; ");
INSERT INTO tvt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","thaknuh loong kaanjuukhu et sok rum ano neng nok ah long et rumha, eno leh rangsoom jeng ah eloot lootwah ih jeng rum leh noisok et rumha! Neng chamnaang theng ah rapne ethithoon ang ah!” ");
INSERT INTO tvt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisu ih kooktum et lengsok adi changteng mina loong ih Rangteenok ngun khok adi neng lakkot ngun sak rum arah japtupta, ");
INSERT INTO tvt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","erah di changthinuh thaknuh nusiit ih taamlo ngunsah phaanyi sak arah nep tupta. ");
INSERT INTO tvt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Heh ih liita, “Ngah ih baat rumhala arah thaknuh rah ih o nang ih ehanthoon ih koha. ");
INSERT INTO tvt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tumeah wahoh loong ih bah neng di eje angthaang ih koha; eno changthih nuh rah ih bah, heh changthih mathan taat ang abah uh thoontang kojah hala.” ");
INSERT INTO tvt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mararah heliphante loong ah Rangsoomnok tiit waan rumta, eseejih jong ih hoonta rah nyia thaangmuh lakkot Rangte suh kota ah miksok di tumthan jaaseemoong ah. Eno Jisu baat rumta, ");
INSERT INTO tvt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Sen ih arah loong jo sok han ah—anoong saapoot changta no aadoh jongteh tesiit uh tajeeka ang ah; loongtang rukdat cho ang ah.” ");
INSERT INTO tvt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","“Nyootte,” neng ih chengta, “Erah maatok doh ang ah? Eno erah langsuh saapoot ah echang ela ih jatthuk suh tumjaat phang noisok he?” ");
INSERT INTO tvt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisu ih baatta, “Naririh ih ban sok an sen teeteewah ah; mih ih nak toom mokwaan han. Warep, nga tiitbaatte totoh ang ah, sen jiinnah ra haano baat han, erah wah ah ngah eah! Eno, ‘Rangkuh ah thok ih hala!’ Enoothong erah loong linah nakmok roong phankhoom an. ");
INSERT INTO tvt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Sen nakmok cho an raamui nyia changrook chaat anno ah; erah loong jaakhoh elang jaatjaat eah, ang abah uh erah suh rangkuh thoon ela ih liijih tah angka. ");
INSERT INTO tvt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Heh ih wakbaatta, “Deek akaan ah deek akaan doh rookmui ah hasong ah hasong doh rookmui ah. ");
INSERT INTO tvt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Erah tokdoh noongrep nah hasamoh ah, ram ah dong eah, eno thang ah dong eah; Rang nawa babah uh lathaak japtupke rah nyia echo ejih nep dong raaha. ");
INSERT INTO tvt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Erah loong ah maang angka doh, sen loong ah jokhak leh siiwi et han, sen loong ah phaatak nah sak suh Jehudi rangsoomnok nah chaak taari wanhan; nga tungthoidoh sen loong ah luungwang nyia nok atang pante reenah siitwan han. ");
INSERT INTO tvt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eno erah sen suh saapoot ese ang ah Ruurang Ese tiit ah neng suh japbaat suh ah. ");
INSERT INTO tvt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Erah raang ih sen nakmok sootsaam an tumjih jeng theng ah eah, ");
INSERT INTO tvt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","tumeah ngah ih sen suh erah likhiik jengkhaap nyia thung atak koh rumha, eno sen jeng ah senpi senra loong ih tajen thetbaat ran nyia tajen daan ran. ");
INSERT INTO tvt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Sen ah sennuh senwah ih, senphoh senno ih, sen sano ih, nyia sen jiiwah joonwah loong ih jokoh han; sen mararah ah etek haat nep et han. ");
INSERT INTO tvt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Warep ih nga tungthoidoh sen ah miksuk et han. ");
INSERT INTO tvt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Enoothong sen khoroon tasiit taan uh tah thaajaaka. ");
INSERT INTO tvt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Erah raang ih rongtangtang ang anno, sen teeteewah ah jenpang an. ");
INSERT INTO tvt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Sen ih Jerusalem ah arami loong ih kooknak arah tup anbah, erah doh sen ih jat etheng Jerusalem ah seek ih thet haatte eah. ");
INSERT INTO tvt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Erah lidoh Judia nawa loong ah kongchoong ko ih toonsoon jaatjaat ih rum ah; samnuthung dowa loong ah soonjaatjaat eah, eno mideek ni tongte loong ah erah samnuthung adoh takah wangka. ");
INSERT INTO tvt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Erah tok ah ‘Chamchoh Saakaan ang ah, ‘Rangteele ni raangha loong ah amiisak toom ih pun raaha eah. ");
INSERT INTO tvt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Erah tokdoh tumthan echoojih ang ah sawokte nyia khoobaang nuh loong ah raang ih ah! Echoojih chamnaang ah arah hah adoh thok ete, eno Rangte tenkhat ah erah mina loong sak nah kaatte. ");
INSERT INTO tvt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mararah ah lang apah ih tek haat ah, rukho ah phaatak nah sak ano deekrep nah tumhui ah; rangnak mina loong rah ih neng saapoot maang changchang Jerusalem ah damnak rum ah. ");
INSERT INTO tvt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Rangsa, laaphiing, nyia reksih loong adoh babah uh lathaak angka loong ah lang ah. Hatoh nawa deek akaan rep ah rapne ih sootsaam rum ah, juung huuk ra nyia juungtak ra cho rum ah. ");
INSERT INTO tvt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mina loong ah mongsaam lam ih echo ih rum ah hatoh nah tumjih angbaat ah eah, tumeah rangkhoh nawa chaan aphaan loong ah edumdan eah. ");
INSERT INTO tvt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Erah lidoh mina Sah ah jiingmuung khuinah hechaan hepaan lam ih dong ha. ");
INSERT INTO tvt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Erah loong ah phang ang adoh, sen loong ah toonchap anno sen khoh ah jutnoi an, tumeah sen khopiipang saapoot ah haniik ih thok ha.” ");
INSERT INTO tvt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Eno Jisu ih arah tiitthaak ah baatta: “Puksak bang nyia jaat hoh bang loong ah taat samthun thaak an. ");
INSERT INTO tvt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Heh lak phang pa arah tup anno sen ih jat an, rangsoh thok ehala eah. ");
INSERT INTO tvt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Erah likhiikkhiik, sen ih erah loong phang lang arah sok an doh, Rangte Hasong ah thok ehala ih jat an. ");
INSERT INTO tvt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Samthun et an erah loong ah amadi ething ih tongte loong maang tekka jaakhoh nah lang ah. ");
INSERT INTO tvt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Rang nyia hah ah emat eah, enoothong nga jengkhaap ah babah uh tamaka ang ah. ");
INSERT INTO tvt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Sen teeteewah naririh ih ban tong an! Sen arah hah adoh ehan mi ejok ephak nah nakmok tong an erah damdoh sen roidong raang ih mongsaam nak ih tong an, emah ang abah erah Rangwuung rah ih seek ih japjoh ho ");
INSERT INTO tvt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","phoong ni pat ah likhiik ah. Tumeah arah hah dowa mina loong warep puh nah thok ha. ");
INSERT INTO tvt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Erah raangtaan ih saapoot rookwih banban ih tong an. Eno saarep doh rangsoom nah tong an erah loong dowa pui anno Mina Sah raaha doh toom jen dongchap an.” ");
INSERT INTO tvt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Erah tokdi Jisu Rangteenok ni tong ano nyootsoot rumta, eno rangja angka no, heh ah Olip kong ko ih jam kata. ");
INSERT INTO tvt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Rangkhah rookwih miloong ah Rangteenok ni heh jeng boichaat wang rumta. ");
INSERT INTO tvt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Toomuh baanlo kuwaang Khopi romhoon kuh et menha ah thok suh saapoot rookli eta. ");
INSERT INTO tvt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Romwah phokhoh nyia Hootthe Nyootte loong ah miloong ra echo erumta, erah thoidi neng ih Jisu ah hotsu ih tek haat suh chung rumta. ");
INSERT INTO tvt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Eno Judas Iskerot sak ni Soitaan nopta, heh uh heliphante asih wanyi dung nawa esiit angta. ");
INSERT INTO tvt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Eno Judas kah ano romwah phokhoh nyia Rangteenok apit nawa phokhoh loong jiinni Jisu ah mamet mokwaan korum angdoh se ah ih roongwaan kata. ");
INSERT INTO tvt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Neng ah eroon ih rumta erah thoidi heh suh ngun hukot thun rumta. ");
INSERT INTO tvt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ih uh erah thang etta eno Jisu ah mih suh lajat thukthang ih neng suh marah pootdoh japjoh koh ang ih thunta. ");
INSERT INTO tvt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Toomuh baanlo phaksat kuwaang adoh Khopui romhoon suh saapsah tek haat rangwuung ah ethok ih taha. ");
INSERT INTO tvt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pitar nyia Joon suh Jisu ih amet baat nyu ano daapkaatta: “Kah ansih no Khopui romhoon kuwaang phaksat ah ban khookham kah ansih.” ");
INSERT INTO tvt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Maanah ban khookham kaat baat hali tih?” Nyi ih cheng nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jisu ih ngaakbaatta, “Set samnuthung adoh wang ansih erah doh mih wasiit khamteng khap ah pi ano raaha rah chomui ansih. Erah wah ah marah nok adoh nop ah heh lilih ih roongwang ansih, ");
INSERT INTO tvt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","eno nok changte asuh baat ansih: ‘Nyootte ih liita, Nokmong ah marah ah nga liphante nyia ngah ih Khopui romhoon phaksat phaksah theng rah ah?’ ");
INSERT INTO tvt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Eno heh ih rangkhoh nah elongwah tongtheng thaatheng pan nokmong baat koh hansih, erah doh jaatrep ah ban khookham cho japtup ansih.” ");
INSERT INTO tvt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eno kah nyu ano erah ni Jisu ih mamet baatta erah jun ih japtup nyuuta, eno Khopui romhoon kuwaang phaksat ah songwaang kah nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Saapoot ah rookli ano, Jisu ih teebun ni heh kaamwah loong damdi roongtongta. ");
INSERT INTO tvt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Heh ih neng suh baatta, “Ngah ih sen damdoh arah Khopui romhoon phaksat ah maang chamnaang kang doh room phaksat suh rapne ih ramlang! ");
INSERT INTO tvt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ngah ih baat rumhala, arah phaksat ah Rangte Hasong mootkaat maang langlang babah uh takah we phaksah kang.” ");
INSERT INTO tvt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Eno Jisu ih lookkep ah toonpi ano, Rangte suh lakookmi jengkhaap ah jeng ano liita, “Arah sen chamchi nah pheejok an. ");
INSERT INTO tvt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ngah ih baat rumhala Rangte Hasong maang thokthok ngah ih aadowa ih arah kham ah takah jokkang.” ");
INSERT INTO tvt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Erah lilih heh ih baanlo ah toonpi ano, Rangte suh lakookmi jengkhaap ah jeng ano, bunphiitta, eno neng suh koh rum ano liita, “Arah nga si, korumhala. Sen ih ngah toom samthun he ih korumhala.” ");
INSERT INTO tvt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Emamah phaksat lidi lookkep ah toon korum ano baatta, “Arah ah Rangte ena jengdang lookkep nga sih ih loop ha, erah sen raangtaan ih janla.” ");
INSERT INTO tvt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Enoothong, sok an! Mih wasiit nga jootkotte wah ah amadi nga damdi teebun ni roongtong hala! ");
INSERT INTO tvt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mina Sah abah Rangte ih mamet chung ha erah jun ih tek ah, enoothong heh jootkotte ah raang ih tumthan ethih ang ah!” ");
INSERT INTO tvt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Eno neng jaachiichi ni chengmui rumta eme reete ah o lek ang koji eah. ");
INSERT INTO tvt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Heliphante loong ah neng dung ni Elong thoon o ah lek angkoji ih daanmui rumta. ");
INSERT INTO tvt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisu ih neng suh baat rumta, “Rangnak mina loong luungwang ih neng noksong ah neng chaan nawa ih panha, eno erah pante loong ah ih neng jaat ah ‘Mina loong Joonte et chaang rumha.’ ");
INSERT INTO tvt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Enoothong sen bah erah loong likhiik lah ang theng; erah nang ih bah sengdung ni elongthoon angte wah ah loongtang nang ih ehin thoon likhiik jaatjaat angtheng, erah dam ih phansiitte ah laksuh ang arah likhiik jaatjaat angtheng. ");
INSERT INTO tvt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Elongthoon ah o ah, phaksat satte kaangkookla ah tama epheekotte rah ah? Marah ekaangkook ela ju ang ah. Enoothong sengdung ni bah epheekotte wah ah ngah. ");
INSERT INTO tvt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nga phate tokdi sen loong ah nga damdam ih roongtong halan; ");
INSERT INTO tvt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","eno seng wah ih ngah suh mih mamet panthuk halang, erah likhiik sen suh uh emamah ih panthuk rumha. ");
INSERT INTO tvt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nga Hasong adoh sen ih teebun nah jok phaksah an, eno luungwang tongtheng adoh tong anno asih jaatnyi Ijirel noksong ah panthuk rumha. ");
INSERT INTO tvt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simoon, Simoon! Boichaat uh! Soitaan ih sen phate suh chaan echoh ela, ese ah ethih nawa danjat suh ah, phek phekte ih raan nawa hephaang kadande arah likhiik ah. ");
INSERT INTO tvt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Enoothong, Simoon, an raangtaan ih rangsoom esoom et hang, an tuungmaang nawa ladat raangtaan ih ah. Eno an nga reeko nah ngaak ho doh, anpho anno loong ah chosok etheng.” ");
INSERT INTO tvt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pitar ih ngaakbaatta, “Teesu, ngah phaatak nah roongwang suh nyia eroong tek ih suh botseh banban ih tonglang!” ");
INSERT INTO tvt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Ngah ih baat hala, Pitar,” Jisu ih liita, niikja an ih ngah suh tajatkang ih lekjom maang jengjeng woh taweeka ang ah.” ");
INSERT INTO tvt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Eno Jisu ih heliphante loong suh chengta, “Ngah ih sen loong ah ngun muh, khaak muh nyia lakhoop muh kaat thuk rum taha adi, tumjih tumjih di bootbe nih etan?” “Tabootbeeti,” neng ih ngaakbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jisu ih liita, “Enoothong amadi, o mina di ngun nyia khaak jeela rah ih ehui jaatjaat et an; lang apah amukte ih an samsong ah sang uno esiit than reh uh. ");
INSERT INTO tvt_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tumeah ngah ih baat rum hala Rangteele ni nga tiit ah amet raangha, ‘Heh ah ehuh eleek mina et thiik ah,’ erah ah amiisak jaatjaat ih ang raaha, tumeah nga tiit mathan raangthiinta loong ah amiisak ih epun totoh ih ra hala.” ");
INSERT INTO tvt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Heliphante loong ah ih liita, “Sokthaak uh! Teesu, lang arah enyi je ah!” Heh ih ngaakbaatta. “Erah laaleh ang ah!” ");
INSERT INTO tvt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisu samnuthung dowa saahoh dowa likhiik ih dokkhoom ano, Olip Kong ni wangta; eno heh damdi heliphante loong nep roong wangta. ");
INSERT INTO tvt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Heh kong adi thok ano, baat rumta, “Phate joonnaam ih naktoom jen han suh rangsoom nah tong an.” ");
INSERT INTO tvt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Eno heh ah neng re nawa jong ih liipat theng than haloot ni kah ano heh lakudi tong ano rangsoomta. ");
INSERT INTO tvt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ewah,” heh liita, “An thung ang ubah, nga chamjih rah an ih toonhaat ih weeuh. Enoothong nga thung jun lah angthang ih, an thung jun ju toom ang ah.” ");
INSERT INTO tvt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Eno rang nawa rangsah dong haano heh suh chaan ah kota. ");
INSERT INTO tvt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Heh ah rapne ih thungthet lamdi erong ih rangsoomta; heh ranglom ah sih datjanla likhiik ih hah ni datjanta. ");
INSERT INTO tvt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Rangsoom theng nawa toonchap ano, heliphante loong reeni ngaak kah adi, neng thungjoong nawa ih mokjup rum arah japtup kaatta. ");
INSERT INTO tvt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Heh ih neng suh liita, “Sen tume jup lan? Saat anno rangsoom an sen phate joonnaam nawa toom pui an.” ");
INSERT INTO tvt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisu ih erah baat rum adi miloong ah dong taha, Judas, heliphante asih wanyi dung dowa esiit angta ah ih siit rum ano wang rum taha. Judas ah ra haano Jisu ah chupphakta. ");
INSERT INTO tvt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Enoothong Jisu ih liita, “Judas, an ih Mina Sah ah chupphak lam ih tam jokoh uh?” ");
INSERT INTO tvt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Heliphante Jisu dam dowa loong ah ih tumjih ang baat ah ih sok rum ano, cheng rumta, “Teesu, seng ih senglang sengpah ah tam maak ih?” ");
INSERT INTO tvt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Eno neng dung nawa wasiit ih Romwah phokhoh dah na jaawako ah dat dookta. ");
INSERT INTO tvt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Enoothong Jisu ih liita, “Erah than chang ah!” Eno erah wah na ah taajoh ano deesiitta. ");
INSERT INTO tvt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Eno Jisu ih romwah phokhoh nyia rangsoomnok apit ni tongte nyia mihak phokhoh erah di heh joot kaatte loong asuh liita, “Sen loong ih ngah mimoong ang angdi kaatkaat lang apah damdi nih ra halan? ");
INSERT INTO tvt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ngah Rangteenok ni saarookwih sen damdam kah ang tahang adi sen ih ngah takah thaak joh tahe nih. Enoothong rangnak ih pan halan saapoot ah thok ehala, amadi sen tumjih reeraangjih ah erah saapoot ah chang ela.” ");
INSERT INTO tvt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Neng ih Jisu ah khak ano Romwah phokhothoon nok ni siitwan rumta; eno Pitar ih haloot ni khoom ah ih neng lilih eta. ");
INSERT INTO tvt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Taakkhuung laktung adi we bantak rumta adi, Pitar ah weekaang adi roongtong wangta. ");
INSERT INTO tvt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Eno laksuh esiit minuh angta rah ih heh we ni roongtongta ah tup ano, heh jiinko ramram ih sok ano liita, “Arah mih rah uh Jisu damdi kah angta!” ");
INSERT INTO tvt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Eno Pitar ih daanta, “Minuh, ngah ih heh ah ejat uh tajatkang!” ");
INSERT INTO tvt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Eno amasah ritdi mih wasiit ih jat ano Pitar suh liita, “An uh neng damdi kah angkotu!” Pitar ih ngaakbaatta, “Jaaroh ngah tah ang kang!” ");
INSERT INTO tvt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Koonta siit ritdi wahoh wasiit ih ramram we ih liita, “Etuuteejih tah angka arah mih rah Jisu damdi kah angta, tumeah heh uh Galili nok hah!” ");
INSERT INTO tvt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Eno Pitar ih we liita, “Jaaroh, ngah ih tajatkang an ih tumjih suh liihu rah ah!” Erah jengta damdam, woh ah weeta. ");
INSERT INTO tvt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Eno Teesu ah Pitar ko phangla ih ngaaksok kano Pitar ih ramram ih sokta, eno Pitar ih Teesu ih baatta rah dokthunta, “Niikja woh maang weeka doh an ih ngah suh tajatkang ih lekjom jeng uh eah.” ");
INSERT INTO tvt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pitar ah dokkhoom kah ano rapne ih huung kata. ");
INSERT INTO tvt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Heh bante miloong ah ih Jisu ah kaanju leh buh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Neng ih heh mik ah loop rum ano cheng rumta, “O ih buh halu? Baat thaak he!” ");
INSERT INTO tvt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Erah damdi hejaat hejaat ih liirum leh kaanju et rumta. ");
INSERT INTO tvt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Rang ah wuung ano, phokhoh mihak nyia romwah phokhoh, Hootthe nyootte loong lomkhoon rum ano, Jisu ah Ngoong awang dung ni siitwan rumta. ");
INSERT INTO tvt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Baat he,” “An ah Kristo tam ah?” Neng ih chengta. Heh ah ngaakjengta, “Ngah ih baat rum koha bah sen ih tabaam hanpi kan; ");
INSERT INTO tvt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","eno ngah ih echeng et rum koha bah sen ih tabaam ngaakbaat ri. ");
INSERT INTO tvt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Adowa ih bah Mina Sah ah Rangte Elongthoon tongla jaawako adoh roongtong ah.” ");
INSERT INTO tvt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Eno neng loongtang ih li rumta, erah ang abah, an ah, Rangte Sah tam anglu?” Heh ih ngaakbaatta, “Sen ih li hali aju ngah ah.” ");
INSERT INTO tvt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Eno neng ih liita, “Seng ih arah tokkhodoh jihoh haaki takah jamke! Seng na na ih heh jeng arah chaat ehi!” ");
INSERT INTO tvt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Loongtang toonchap rum ano Jisu ah Pilat jiinni siit wanrumta, ");
INSERT INTO tvt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","erah di neng ih Jisu suh nan rumta: “Seng ih arah mih ah ih seng mina loong lamki ni siit arah jap johi, “Neng ih luungwanglong suh sokse lakot theng ih baat rumha eno heh teeteewah suh Kristo, luungwang ih liita.” ");
INSERT INTO tvt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat ih chengta, “An ah Jehudi loong luungwang tama?” “An ih liihu aju ang ah,” Jisu ih ngaakbaatta. ");
INSERT INTO tvt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Eno Pilat ih romwah phokhoh loong nyia miloong asuh baatta, “Ngah ih arah mih ah kaanju suh hemoong hetaang tajap jokang.” ");
INSERT INTO tvt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Eno miloong ah ih ehan han ih laabaat rumta, “Heh ih nyootsoot ano Judia hadaang ni haphaangla. Heh ih Galili ni phang phaang siit ano chiinyah arah di thok phaangphak ra hala.” ");
INSERT INTO tvt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilat ih erah chaat ano, chengta, “Heh ah Galili nok hate tama?” ");
INSERT INTO tvt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Heh ih Jisu ah Hirod ih panha nok hah dowa ih jat ano, heh ih Hirod jiinni siitwan thukta, erah tokdi heh uh Jerusalem ni angta. ");
INSERT INTO tvt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hirod ah Jisu japtup ano rapne ih roonta, tumeah heh ih jaakhoh ni Jisu tiit ah chaat ano heh japtup suh rapne kah ih ramta. Jisu ih epaatjaajih toom noisok hang ih heh ih thunta. ");
INSERT INTO tvt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Erah thoih Hirod ih jaatrep tiit taat chengta, ang abah uh Jisu ih tah ngaakbaatta. ");
INSERT INTO tvt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Romwah phokhoh loong nyia Hootthe nyootte loong ih Jisu suh ethih ih ram nan rumta. ");
INSERT INTO tvt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hirod nyia heh sipaahi loong ah ih Jisu ah rapne ih kaanju ngitkhuung rumta; eno samsong elootjih rah ih choom rum ano Pilat jiinni ngaaksiit kaat thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Erah sa dowa ih Hirod nyia Pilat ah jiiwah ih hoon nyuuta; erah ngakhoni bah nyi ah piiara kah ang nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilat ih romwah phokhoh loong, phansiitte loong nyia noksong loong ah lompoon ano ");
INSERT INTO tvt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","baat rumta, “Sen ih arah mih ah nga jiinni siitwan hanno baat hali heh ih mih lamki ni siit ha eah. Eno amadi, ngah ih sen ngathong ni thaakcheng angdi heh moong hetaang tiit ah tiim uh tajeeka. ");
INSERT INTO tvt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hirod ih uh heh moongtaang ah tachojoka, erah thoih heh ih seng jiinni ngaakdaap jahala. Arah mih ah etek haat etjih sengseng ih moong arah tumjih tajeeka. ");
INSERT INTO tvt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Erah thoidi ngah ih heh ah bot thuk angno ngaakdaap ang.” ");
INSERT INTO tvt_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Paangrep Khopui romhoon kuh di Pilat ih phaatak ni sak arah wasiit wasiit kah ih daap haatta. ");
INSERT INTO tvt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Eno miloong loongtang toonriing rumta, “Bangphak nah Rapbot etheng! Barabbas ah daap haat kohe!” ");
INSERT INTO tvt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabbas ah samnuthung ni haphaangsiitte, nyia mih tek haatte angta.) ");
INSERT INTO tvt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat ih Jisu ah daap haat thung angta, erah thoih miloong asuh we huk chengta. ");
INSERT INTO tvt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ang abah uh miloong ah we ngaak riing rumta, “Bangphak nah rapbot theng! Bangphak nah rapbot theng!” ");
INSERT INTO tvt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Eno Pilat ih takjom adi we cheng rumta, “Eno bah heh ih tumjih thetre kota? Ngah ih heh tek haat etjih bah emoong tumjih uh tajap jokang! Ngah ih buthuk angno daap haat ang.” ");
INSERT INTO tvt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Eno miloong ah erong rongwah ih huk riing rumta Jisu ah tek haat jaatjaat etheng eah, eno neng riingta jun ih tek haatta. ");
INSERT INTO tvt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Erah thoidi Pilat ih miloong ih jamta jun ih Jisu tek haat mat ah paatta. ");
INSERT INTO tvt_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilat ih mih tek haatte nyia hah phaangphakte Barnabbas ah miloong ih suk kano daap haatta, eno Jisu ah neng lak ni mamet rum abah uh ih korumta. ");
INSERT INTO tvt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sipaahi loong ah ih Jisu siitwan rumta adi, mih wasiit Sirini nawa heh men ah Simoon heh deek akaan nawa samnuthung ko ih kaatte ang arah chomui rumta. Eno neng ih joh rum ano, bangphak ah huithuk rumta, eno Jisu damdam ih roongkhoom thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Miloong ah hantek heh lilih ih roong phankhoom rumta; erah dung adi mararah minuh loong ah hethun huungte uh eje ang rumta. ");
INSERT INTO tvt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Eno Jisu ih ngaaksok ano baat rumta, “Jerusalem minuh loong! Nga raangtaan ih nak huung an, erah nang ih bah sensuh sensah nyia sen teenuh raangtaan ih thong huung an. ");
INSERT INTO tvt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tumeah mina loong ah ame ih jengjih rangwuung ah thok eha, ‘Tumthan khangraangse ah minuh heh sah lataat tupka rah ah, nyia heh sah babah uh lathaak koonchaate loong ah!’ ");
INSERT INTO tvt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Erah tokdoh mina loong ih kong akaan suh baat rum ah, ‘Seng khoh nah bokdat raaho!’ Nyia kong loong asuh baat rum ah ‘Seng hottong thuk we he!’ ");
INSERT INTO tvt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Erah loong ah bang ejang ang tokdoh mok lang abah, bang loong ehook eah doh tang mamangte ang ah?” ");
INSERT INTO tvt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wahoh wanyi ehuh ang arah, Jisu damdi waktek haat et suh siitwan rumta. ");
INSERT INTO tvt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Neng ah hah esiit, “Khoraang,” et menta adi thoksiit rum ano, Jisu ah erah di tek haat wanrumta, eno ehuh eleek wanyi ah, wasiit ah dak hekko wasiit jaawako ih tek haat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisu ah jengta,” Ewah! Biin anaan et rum uh, tumeah neng ih tajatka neng tumjih reela rah ah.” Henyuh hekhat ah neng chamchi ni jongteh ah tooloom rum ano pheehaat rumta. ");
INSERT INTO tvt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jehudi mihak phokhoh loong ih Jisu ah putbeek ngitkhuung rumta tokdi mih loong ah ih ban sok ruh et rumta: “Heh ih mihoh ah epuipang kah eta; Rangte ih danjeeta Kristo rah ang abah heh teeteewah rah toom puipang thaak ah!” ");
INSERT INTO tvt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sipaahi loong rah ih putbeek ngitkhuung et rumta: Jisu jiinni wang rum leh thaangneejih kham ah koh ih rumta, ");
INSERT INTO tvt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","eno li rumta, “Jehudi luungwang anglu bah an teeteewah ah puipang thaak uh!” ");
INSERT INTO tvt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Heh khothung adi amet raangta: “Arah Jehudi luungwang.” ");
INSERT INTO tvt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ehuh eleek wasiit heh reeni chiita warah ih Jisu suh kaanju lam ih liita: “An ah Kristo tanih angko? An teewah ah puipang sek ah puipang et heetih ba!” ");
INSERT INTO tvt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Eno wasiit ah ih, kanjaata, ame jeng ano ah “Rangte ra tanih cho ko? An chamlu ah likhiik heh uh emamah ih chamla. ");
INSERT INTO tvt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ang abah uh, sek chamliitih abah echamjih, tumeah sek ah ethetre ih thoidi chamliitih, enoothong heh bah tumjih uh lathika di cham kola.” ");
INSERT INTO tvt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Eno heh ih Jisu suh liita, Jisu ngah bah dokthun et weehang, luungwang ih hoon uno raaho doh ah!” ");
INSERT INTO tvt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisu ih baatta, “Ngah ih kakham hala, an chiinyah Jumlam nah nga damdoh roong angho.” ");
INSERT INTO tvt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Erah tok adi rangnithung asih saapoot nyi angta rangsa rah nakdat ano harep ni rangja ko saasong saapakjom tuk ih laamang ih hoonta; eno Rangteenok ni chiita nyuh loong ah khoonyi khoonyi ih khoodatta. ");
INSERT INTO tvt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jisu ah erong ih riinghuungta, “Ewah! Ngah ih ngaachi ngaala an lak ni kohala!” Erah ah jeng ano tiita. ");
INSERT INTO tvt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sipaahi saahaap ah ih erah loong ah tup ano, Rangte rang ah phoongta, ame jeng ano ah, “Amiisak heh bah mise ju ang kota!” ");
INSERT INTO tvt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tumjih angla ih sokte lomkhoon rumta mina loong ah neng nok ni ngaak wang rum adi, neng teekhuh ah buh rum ano thungthih rumta. ");
INSERT INTO tvt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jisu men jatte loong nyia Galili nawa minuh loong heh lilih ih phan khoomte loong ah haloot ni chap rum ano ban sok rumta. ");
INSERT INTO tvt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Erah di mih wasiit heh men ah Josep Arimathia nok hate, Judia hah nawa angta. Heh ah wase nyi mih ih soomtuute angta, heh ih Rangte Hasong kaat ah bansokte angta. Heh ah ngoong awang dung ni phokhoh taat ang abah uh, neng kaanthot nyia neng reeraang adi takah roong junta. ");
INSERT INTO tvt_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Heh ih Pilat pandi wang ano Jisu mang ah suh wangta. ");
INSERT INTO tvt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Eno heh ih mang ah datthiin ano, nyuleep nyuh ih khoon ano mangbeng ah jong jaan khoni thoh ano wahoh babah uh lathaak bengka adi thiin kaatta. ");
INSERT INTO tvt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Erah sa ah sa banga rangwuung angta, eno Jehudi naangtongsa ah thok ih taha. ");
INSERT INTO tvt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galili nawa Jisu lilih ih wang rum taha loong ah Josep damdi roongwang rum ano Jisu mang ah mamet thiin rumha ih mangbeng ah sokwang rumta. ");
INSERT INTO tvt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Eno neng nok ni ngaak wang rum ano etingtak etjih nyia phontum mang sak adoh hut suh jam wang rumta. Neng tongta sa ah Hootthe jun ih Jehudi naangtongsa angta. ");
INSERT INTO tvt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Naangtongsa rangkhano ih minuh loong ah mangbeng ni karumta, neng ih ban thiin rumta phontum loong ah piikaat et rumta. ");
INSERT INTO tvt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Eno neng ih mangbeng luung dowa jong ah dokkoong cho ih japtup karumta, ");
INSERT INTO tvt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","eno nopkhoom wang rum adi; Jisu mang ah tajaptup rumta. ");
INSERT INTO tvt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Neng erah di chap rum ano paatja rum adi, baphuk ih neng reeni mih wanyi nyuh akhat phaakjaaja ih phaak arah dongchap nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Rapne ih cho rum ano, minuh loong ah neng khorong ah ngot rum ano hah ni kotbon rumta, eno miwah nyi rah ih liita, “Sen ih tekmang dung ni ething ah mamet jam sok han? ");
INSERT INTO tvt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Heh aadi tah angka; heh ngaaksaat eta. Dokthun et an heh ih sen suh Galili ni baat tahan ah: ");
INSERT INTO tvt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mina Sah rangdah mina lak nah korum ah eno, siiwi rum ano Bangphak nah rapbot rum ah, eno sa jom doh ewe ngaakthing eah.’” ");
INSERT INTO tvt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Eno minuh loong ah ih heh jengkhaap ah dokthun rumta, ");
INSERT INTO tvt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","mangbeng nawa ngaak wang rum ano heliphante asih wasiit nyia miloong asuh baatwan rumta. ");
INSERT INTO tvt_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Minuh loong men ah Meeri Megdalini, Joon nah, nyia Jeems nuh Meeri loong ah ang rumta; neng nyia minuh wahoh loong ah ih heh kaamwah loong asuh baatwan rumta. ");
INSERT INTO tvt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Enoothong kaamwah loong ah ih minuh jengkhaap asuh lalangka tiit ih li rumta, eno neng ih tahanpi rumta. ");
INSERT INTO tvt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Enoothong Pitar ah mangbeng ko ni doksoon kah ano; kotbon ano sok kata eno tumjih uh takaptupta mang loop nyuleep laklak ba angta. Eno paatja rum ano nok ni ngaakwang rumta tumjih angla eah. ");
INSERT INTO tvt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Erah saasa adi Jisu liphante wanyi Emmais hadaang ni kah nyuuta, erah hah ah Jerusalem nawa ih me sinet taan haloh angta, ");
INSERT INTO tvt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","eno nengnyi ih erah mamah angta tiit loong ah thoidi waan kah nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nengnyi erah tiit ah thoidi roongwaan lam ih khoom nyu adi, Jisu ah nengnyi reeni dong haano nyi damdi roong khoom kata; ");
INSERT INTO tvt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","eno nengnyi ih Jisu ah tup bah tup et nyuuta ang abah uh, tasamjat nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisu ih nyi suh liita, “Setnyi lam khoom damdi, tumjih tiit waan lansih?” Nyi ah thungjoong damdi chap ruh ih nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Eno wasiit, heh men Koleopas, rah ih heh suh chengta, “Jerusalem ni dongkhoomte an luulu tam anglu miinyah manbah tumjih angti loong ah lajat thang ah?” ");
INSERT INTO tvt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Tumjih akoh?” heh ih we ngaak chengta. “Najaret nawa Jisu angta tiit ah,” nyi ih ngaakbaat nyuuta. “Erah mina ah khowah angta eno Rangte nyia mina loong ih uh heh suh chaan apaan mih et thiikta heh jengkhaap nyia heh reeraang loong asuh ah. ");
INSERT INTO tvt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Seng romwah phokhoh loong nyia hadaang phansiitte loong ih heh ah tek haat thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Eno seng ih heh suh taat laalomti Ijirel mina loong pangte heh esiit eah! Erah ang khodi, chiinyah dowa ih hesa sa jom angla. ");
INSERT INTO tvt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Sengdung nawa minuh loong ih paatja thuk hali, neng rangkhano mangbeng ni taat sokkah rum ano, ");
INSERT INTO tvt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","heh mang ah tajaptup karumta. Neng ih mot amang ni rangsah thong japtup rumta tih eno Jisu bah ejen ngaakthing eta ih baat rum arah tiit ah ngaakbaat wan rumhala. ");
INSERT INTO tvt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Eno sengdung dowa marah marah ih sokkah rum ano minuh loong ih baatta rah amiisak angta, eno neng ih heh mang ah takap tup rumta.” ");
INSERT INTO tvt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Eno Jisu ih neng suh li rumta, “Sen mame thungko lan, khowah ih baat tahan jengkhaap loong ah adi mamah lahanpi elan! ");
INSERT INTO tvt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kristo ah emamah ih chamnaang ano heh men raksiit jih taba angta?” ");
INSERT INTO tvt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Eno Jisu ih heh teewah tiitwaan Rangteele ni mamet raangta loong rah huk jangbaat korumta, Moses leedap nawa phang baat ano wahoh khowah loong leedap ni raangta tiit loong anep baat korumta. ");
INSERT INTO tvt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Neng marah hadaang ni karumta erah hah re adi thokkhoom rum adi, Jisu ah nengnyi miksok di haloot ni moongkhoom kala likhiik ih reeraangta; ");
INSERT INTO tvt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","erah thoidi nyi ih tang nyuuta, “Sek damdoh roongtang jamho; rangsa tham ih kala. “Erah thoih ih heh nyi damdi roongtang jamta. ");
INSERT INTO tvt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Heh ah nengnyi damdi phaksat suh roongtong adi, baanlo ah toonpi ano, romseetam jengkhaap jengta; eno baanlo ah bunphiit ano nyi suh koh nyuuta. ");
INSERT INTO tvt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Erah lidi ba nengnyi mik ah laang ano heh ah kok samjat nyuutta, enoothong nyi miktup nawa emat eta. ");
INSERT INTO tvt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Eno waan nyuuta, “Heh lam ni sek damdi Rangteele ni raangha tiit roongwaan taha adi sek sak ni weeluungla likhiik angta ni ih?” ");
INSERT INTO tvt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Eno echaan ih Jerusalem ko ih ngaakwang nyuuta, eno erah di heliphante loong asih wasiit ah miloong damdi eroom ih lomtong rum arah japtup wang nyuuta ");
INSERT INTO tvt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","eno baat nyuuta, “Teesu ah amiimi ih ngaakthing eta! Heh Simoon reeni nep dong taha!” ");
INSERT INTO tvt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nyi ih lam ni tumjih angta loong ah neng suh jangbaat koh nyuuta, nyi ih Teesu ih baanlo bunphiitta adi mamet jat nyuuta loong tiit anep baat korumta. ");
INSERT INTO tvt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Neng suh erah tiit ah baat nyu adi Teesu ah heh teeteewah neng dung ni dongchap ano baat rumta, “Semroongroong ih toomtong an.” ");
INSERT INTO tvt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Neng ah echo ih rumta, jook japtup hi et thun rum ano ah. ");
INSERT INTO tvt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Enoothong heh ih neng suh liirumta, “Sen tume paatja lan? Sen thung ni erah mongchi tenthun ah mame thok hala? ");
INSERT INTO tvt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ngaalak ngaalah ah sokthaak he, eno jat an arah nga teeteewah hanih. Taajoot et thaak he ba eno laajat jan, tumeah jook doh bah heh han nyia heh raang amuk ang ah, Nga sak nawa likhiik ah.” ");
INSERT INTO tvt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Heh ih erah baat rum ano helak helah ah noisok rumta. ");
INSERT INTO tvt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Erah di uh neng ih tajen hanpi rumta, neng tenroon lam ih rapne ih paatja rumta; eno Jisu ih cheng rumta, “Sen jiinni phaksat jih eje nih ah?” ");
INSERT INTO tvt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Neng ih nyasi eniin thasiit korumta, ");
INSERT INTO tvt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","eno heh ih neng panpan di phakta. ");
INSERT INTO tvt_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Eno neng suh baat rumta, “Arah loong tiit ah ngah sen damdi roongtong tahang adi kabaat rum taha: jaatrep nga raangtaan suh Moses Hootthe ni, raangthiinta nyia khowah loong ih raangta erah damdi Dewid Boongle ni raangta loong ah amiisak angla.” ");
INSERT INTO tvt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Eno Rangteele ni raangta loong ah toomjat rum ah ih neng thung ah laangsiit korumta, ");
INSERT INTO tvt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","eno baat rumta, “Erah tiit ah amet raangha: Kristo ah chamnaang jaatjaat eah eno sa jom lidoh tek nawa ngaaksaat eah, ");
INSERT INTO tvt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","eno heh mendoh mina sekthun tiit jengkhaap nyia rangdah biin anaan tiit ah deek rep mina suh tumbaat koh ah phangkhothoon ah Jerusalem nah baat ah. ");
INSERT INTO tvt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Arah loong tiit haaki ah sen loong. ");
INSERT INTO tvt_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Eno nga teeteewah ih sen suh seng wah ih tumjih kotsuh kakhamta rah koh rumha. Enoothong sen ah samnuthung nah ban tong jaatjaat ejih ang ah, sen sak nah rang nawa chaan maang raakraak ah.” ");
INSERT INTO tvt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Eno neng loong ah samnuthung nawa Bethani mathan loot ah erathan ih siitkaat rumta, erah di heh lak ah toon ano romseetam korumta. ");
INSERT INTO tvt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jisu ih romse ah tamkoh rum ano, neng re nawa dokkhoom ano rang ni toonsiit wanta. ");
INSERT INTO tvt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Neng ih heh rang ah soom rum ano, tenroon woksoon ih Jerusalem ni ngaakwang rumta, ");
INSERT INTO tvt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","eno Rangteenok ni saapoot rookwih rangsoom rangtu ih Rangte suh jengseera rumta.");
INSERT INTO tvt_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mongrep maang dongsiitka di, Rangte Jengkhaap ah eje angta; heh Rangte damdi angta, eno Jengkhaap ah Rangte angta. ");
INSERT INTO tvt_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ephangdong dowa ih Jengkhaap ah Rangte damdi angta. ");
INSERT INTO tvt_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Rangte ih jirep ah heh jun ih dongsiitta; jaatrep dongsiitta dowa esiit taan uh heh jun ih ladongka rah tajeeka. ");
INSERT INTO tvt_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jengkhaap ah roidong choh lampo angta, eno roidong erah ih mina raangtaan ih weephaak thukta. ");
INSERT INTO tvt_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Weephaak ah rangnak khoni phaakta, eno rangnak ih erah weephaak ah mabah uh tajen met siitta. ");
INSERT INTO tvt_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Rangte ih weephaak tiit ah mina suh baat thuksuh, mih wasiit Joon ngeh ih kongphaak kotte kaat thukta, ");
INSERT INTO tvt_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","tiimnge liidi, heh tiitkhaap ah loongtang ih chaat rum ano hanpi toom ih rum ah. ");
INSERT INTO tvt_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Heh teewah bah amiisak di weephaak tah angta; weephaak tiit ah ba baatkaat taha. ");
INSERT INTO tvt_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Erah baatta langla amiisak weephaak ah angta, erah weephaak ah arah mongrep adi ra haano mina loongtang suh kaangtook koha. ");
INSERT INTO tvt_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jengkhaap ah langla arah mongrep adi angta, arah mongrep ah Rangte ih heh mendi hoonta bah uh, arah mongrep dowa mina ih tasamjat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Heh teewah deek akaan ni ra taha, erabah uh heh miloong ah ih heh jeng ah takap rumta. ");
INSERT INTO tvt_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Enoothong, o mina ih heh jeng ah kap ih rum ano hanpi rumta, erah miloong ah Rangte suh asah eh hoon suh epun e ah. ");
INSERT INTO tvt_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Neng loong ah Rangte sah ih hoonta, mina hansi nuh awah nawa tup arah tah angta; Rangte ah neng loong raangtaan ih neng Wah eh hoonta. ");
INSERT INTO tvt_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jengkhaap ah mina eh donghoonta eno minchan nyia amiisak pan angta, seng loong damdi roong songtong taha. Heh rangka ah seng ih tup eti, erah rangka ah Hewah jiin nawa Hesah heh luulu ang thoidi choha. ");
INSERT INTO tvt_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Joon ih heh tiit baatta adoh erongrongwah ih riibaatta, “Arah tiit ah ngah ih amah kabaat rum taha, ‘Heh nga lidoh raaha, enoothong nga nang ih heh elong ang ah, tiimnge liidi ngah maang tup diidook heh eje angta.’” ");
INSERT INTO tvt_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Heh jiinni minchan ehan je thoidi loongtang suh romseetam koh hali, seng loong asuh esiit esiit suh romseetam koh hali. ");
INSERT INTO tvt_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Rangte ih Moses jun ih Hootthe kota, enoothong minchan nyia amiisak tiit ah Jisu Kristo jun ih koh hali. ");
INSERT INTO tvt_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Rangte ah oh ih uh tathaak tupka. Rangte reeni Hewah tooto ih tongla, Hesah asuh luulu ba jatthuk ha. ");
INSERT INTO tvt_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalem dowa Jehudi ngoong awang loong ah ih romwah nyia Lewi nok hah marah marah loong ah Joon reeni kaat thuk rum ano, chengkaat thuk rumta, “An o anglu?” ");
INSERT INTO tvt_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Joon ih neng suh ngaakbaat ah tah daanta, enoothong neng suh saasa ih dokbaat rumta, Heh ih baat rumta: <<Ngah Kristo tah angkang.>> ");
INSERT INTO tvt_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","<<Eno bah, an ah o anglu?>> Neng ih ngaak chengta. <<An Elija tam ah?>> “Tah angkang,” Joon ih ngaakbaat rumta. “An Khowah tam anglu?” Neng loong ah ih ngaakcheng rumta. “Tah angkang,” Joon ih ngaakbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Eno bah an ah o anglu baat he,” neng loong ah ih cheng rumta. “Seng daap kaatte loong asuh an o anglu erah tiit ah ngaakbaat wantheng. An teewah suh an ih tiimjih li hu?>> ");
INSERT INTO tvt_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Khowah Isaia Jengkhaap ah baat ano ngaak jengta; <<Phisang hah mong ni riila root ah langla ngah; Teesu lengkhoom suh lamjun in ban tan an!>> ");
INSERT INTO tvt_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pharisi nok hah, ih kaat thukta kongphaak kotte, loong ah ih ");
INSERT INTO tvt_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Joon suh cheng rumta, <<An Kristo uh tah angko, Elija uh tah angko adoleh Khowah uh tah angko, eno bah juutem ah mamah ih temhu?>> ");
INSERT INTO tvt_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Joon ih ngaakbaat rumta, <<Ngah ih ju nawa ih juutem rumhala, enoothong sengdung ni wasiit chapla ah sen ih tajatkan. ");
INSERT INTO tvt_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Erah mih ah nga lih ni ra hala, enoothong ngah bah heh lakhoop adoleh heh lasong khook haattha uh taluikang.>> ");
INSERT INTO tvt_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Arah tiit ah Bethani ni Joon ih Jordan ju saadongko ni juutemta erah di roongwaan rumta. ");
INSERT INTO tvt_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Erah saalih adi Jisu heh taang ni wangha rah Joon ih japtup ano, liita, <<Rangte Saapsah ah arah, arah mongrep dowa rangdah saasiitte ah erah wang hala! ");
INSERT INTO tvt_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ngah roongwaan tahang adi arah warah tiit laangbo baat rum taha, ngah ih amah baat rum taha, ‘Nga lidoh mih wasiit raaha, enoothong heh ngah nang ih elong, tiimnge liidi heh ngah maang tupdoh heh eje angta.’ ");
INSERT INTO tvt_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ngah ih heh o ang ah ngeh ih tah jattang, enoothong, heh ah Ijirel noksong ih toomjat rum ah ngeh ih juutem ra tahang.>> ");
INSERT INTO tvt_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Eno Joon ih heteewah tiitkhaap tiit baat rumta: <<Ngah ih Chiiala ah wotuupi likhiik rang nawa ra haano heh sakkhoh ni dangra ha rah tuptang. ");
INSERT INTO tvt_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Erabah uh ngah ih tajattang heh o angla. Enoothong juutem kaat thuk tahang Rangte ah ih baat tahang, ‘An ih Chiiala ra haano mih wasiit sak nah tong raaha rah japtup uh; Esa Chiiala nawa ih juutemte warah heh ang ah.’ ");
INSERT INTO tvt_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ngah ih tup ehang,” Joon ih liita, <<eno ngah ih baat rumhala Rangte Sah ah bah heh ju.>> ");
INSERT INTO tvt_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Erah saalih adi heliphante wanyi damdi Joon we toonchap adi, ");
INSERT INTO tvt_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jisu lengkhoom ah japtup ano liita. <<Rangte Saapsah ah the warah aleh!>> ");
INSERT INTO tvt_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Heliphante wanyi ah ih Joon jeng ah japchaat nyu ano Jisu damdi roong kanyuuta. ");
INSERT INTO tvt_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisu lekchap ih adi, nengnyi helilih ih kah arah japtup nyu ano cheng nyuuta, <<Set ih tiimjih jamsok hansih?>> Nengnyi ih ngaakbaat nyuuta, <<An mani tonglu Rabbi?>> (Rabbi ah Hebrew lam ih <<Nyootte<< suh liiha) ");
INSERT INTO tvt_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","<<Sok raathaak hansih ba,” heh ih ngaakbaat nyuuta. (Erah tokdi rangsa lup nanah angta.) Erah thoidi heh damdi roong kah nyu ano heh mani songtongta rah japtup kanyuuta eno erah sa adi heh damdi naangjam nyuuta. ");
INSERT INTO tvt_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Erah nyi dowa wasiit ah Simon Pitar no Andriu angta. ");
INSERT INTO tvt_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Erah damdam heh phoh Simon ah japtup ano baatta, <<Seknyi Misia chomui li tih.>> (Misia ah <<Kristo<< suh liiha) ");
INSERT INTO tvt_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Eno heh ih Simon ah Jisu taang ni siitwanta. Jisu heh taangko sok ano liita, <<An Joon sah Simon, enoothong an ah Sephas ngeh ih poonho.>> (Erah langla Pitar suh <<jong<< ngeh ih liita likhiik) ");
INSERT INTO tvt_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Erah saalih adi Jisu Galili ni kaat chungta. Heh ih Philip ah japtup ano baatta, <<Nga damdoh roongra ho!>> ( ");
INSERT INTO tvt_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip ah Pitar nyia Andriu tongla hah, Betsaida nawa angta.) ");
INSERT INTO tvt_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip ih Nathanel ah japtup ano heh suh baatta, <<Hootthe leedap ni Moses nyia khowah loong ih nep raangta ah seng ih japtup ehi. Heh langla Jisu, Najaret hadaang dowa Josep sah ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","<<Najaret nawa tiim bah uh ese thok nih eha?>> Nathanel ih chengta. <<Raaho no sok uh,” Philip ih ngaak baatta. ");
INSERT INTO tvt_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisu ih Nathanel ah heh reeni kaat ah tup ano liita, <<Ijirel mina mi abah arah; heh tiim ni uh tathika!>> ");
INSERT INTO tvt_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanel ih heh suh chengta, An ih ngah mamah ih jat halang?>> Jisu ih ngaak baatta, <<Philip ih maang poon ruudi phuksak bang lathong ni ang uh rah jap tup taha.>> ");
INSERT INTO tvt_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","<<Nyootte<< Nathanel ih ngaak baatta, <<an juuba Rangte Sah! An Ijirel Luuwang!>> ");
INSERT INTO tvt_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisu ih chengta, <<Phuksak bang lathong ni angtu adi japtup taha ngeh ih li kohaano tam hanpi halang? An ih erah tokkhodoh elong japtup uh!>> ");
INSERT INTO tvt_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Eno neng suh li rumta, <<Ngah ih amiisak tiit ah baat rumhala: Rangmong ah laangdaap adoh Rangsah loong ah Mina Sah reenah chookwang datkah ih lengkhoom arah japtup an. ");
INSERT INTO tvt_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Saanyi lidi Kana samnuthung ko Galili hah ni kuhoonta. Jisu nuh uh erah ni angta, ");
INSERT INTO tvt_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jisu nyia heliphante loong ah nep kuhoon thengni poon rumta. ");
INSERT INTO tvt_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kham ah thoonphe korum ano, heh nuh ih Jisu suh baatta, <<Neng jiinni kham ah takah jeeka.>> ");
INSERT INTO tvt_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jisu ih liita, <<tiimjih etheng ah ngasuh nakbaat hang.>> <<Nga saapoot maang thokra.>> ");
INSERT INTO tvt_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Eno Jisu nuh ih neng laksuh loong asuh baatta, <<Heh ih tiim etheng baat han erah re anjoh.>> ");
INSERT INTO tvt_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jehudi loong juusaakaat ah neng banlam angta, erah raangtaan ih jong tekpoh arok ah banthiin roh ih rumta, tekpoh esiit ni ju ah rooknyi rookjom piipa taan thosak theng angta. ");
INSERT INTO tvt_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisu ih heh laksuh loong asuh baatta, <<Arah tekpoh loong adoh joong ah meeke an.>> Neng loong ah ih hesiitsiit ih meeke rum kano, ");
INSERT INTO tvt_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jisu ih baat rumta. <<Bolam bah joong ah we ngaakke anno saroom phaksat sokboite warah asuh kokaat an.>> Heh laksuh loong ah ih ju ah phaksat sokboite warah asuh kokaat rumta, ");
INSERT INTO tvt_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","eno erah kham eh hoonta, erah warah ih thaakjok ih adi kham sumsum eta. Heh ih kham ah manawa angta erah tajatta, (enoothong, joongkeete loong ah ih ba jat eta); erah thoidi jaalah kapte warah poon ano ");
INSERT INTO tvt_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","heh suh liita. <<Mirep ih kham eseethoon ah jaakhoh phe koha, eno wenwah loong ih phootjok taano, thaangne kham ah pheekoh ah. Erabah uh amadi tuk ih kham eseethoon ah thokthiin hu!>> ");
INSERT INTO tvt_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisu ih paatjaajih ah Kana hadaang Galili ni phang mokata, erah di hechaan hephaan ah jatthuk rumta, eno heliphante loong ah ih hanpi ih rumta. ");
INSERT INTO tvt_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Erah lih adi Jisu nyia heh nuh, hephoh heno, erah damdi heh laksuh loong ah Kaparnam ni wang rum ano saajombaji tongwang rumta. ");
INSERT INTO tvt_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Khopi kuwaang lang nanah ang kano, Jisu Jerusalem ni kata. ");
INSERT INTO tvt_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Erah ni miwah loong ah Rangteenook ni luiamaan, saap, tokparu sangte nyia ngun lekte teebun ni thiin arah japtup kata. ");
INSERT INTO tvt_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Erah thoidi Jisu ih luiamaan nyia saap loong ah ruh nawa ih Rangteenok dowa phanbuta; ngun lekte teebun ah loonghaat ano jaan ngunsah loong ah wenhaat eta; ");
INSERT INTO tvt_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","eno tokparu sangte loong asuh baatta, <<Adowa dokpi ih kaat an! Sengwah nok ah thaangsang theng nak hoon an!>> ");
INSERT INTO tvt_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Heliphante loong ah ih Rangteele ni emah ih raangha ah samthun rumta, <<O Rangte, an nok suh mongmah lang ah nga ten ni weelu ah likhiik luula.>> ");
INSERT INTO tvt_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jehudi ngoong awang loong ah ih ngaakwang rum haano Jisu suh cheng rumta, <<An ih emah jen re ang ngeh ih noisok suh an ih seng suh paatjaajih tiimjih jen noisok he?>> ");
INSERT INTO tvt_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisu ih ngaakbaat rumta, <<Arah Rangteenook ah thaak haat ih an, sa jom lidoh Ngah ih weengaak hoon ih ang.>> ");
INSERT INTO tvt_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","<<An ih sa jom doh weengaak hoon ih uh nih?>> Neng ih cheng rumta. <<Arah Rangteenook ah tomhoon suh rookbaji paang arok laakiita!>> ");
INSERT INTO tvt_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Enoothong Jisu ih Rangteenook tiit baatta ah heh sakpuh tiit baatta. ");
INSERT INTO tvt_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Erah raangtaan ih heh tek nawa ngaaksaat taadoh, erah jengta ah heliphante loong ih samthun ih rumta, eno neng ih Rangteele ni liiha ah nyia Jisu jengta rah hanpi ih rumta. ");
INSERT INTO tvt_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Khopi Kuwaang haangdi Jisu Jerusalem ni angta doh, heh ih paatjaajih loong ah re kano mina hantek ih hanpi rumta. ");
INSERT INTO tvt_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Enoothong Jisu ih neng tenthun ah jat ano heteewah neng suh talaalom rumta. ");
INSERT INTO tvt_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mina loong tiit ah heh suh mih ih baattheng ju tah angta, tiimnge liidi neng tenthun ah heh teewah ih jat ih rumta. ");
INSERT INTO tvt_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jehudi noksong phansiitte Nikodimas ngeh ih Pharisi mih wasiit angta. ");
INSERT INTO tvt_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Pheesiit Jisu reeni wang ano li wangta, <<Chuupha, seng ih jat ehi an Rangte ih kaat thuk ho rah nyootte warah ah. Rangte heh damdoh lah angka bah an reelu paatjaajih loong ah o uh tajen reeka. ");
INSERT INTO tvt_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisu ih ngaakbaatta, “Ngah ih amiisak tiit ah baat hala; o uh weedop tup lah eka bah Rangte hasong ah mabah uh tachoh tupka ang ah.” ");
INSERT INTO tvt_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“Mihak ah mamah ma we ngaak dongtup ah?” Nikodimas ih chengta. “Amiimi dobah heh nuh mong nah tami ngaak nopka eno dopnyi tami doptup ka!” ");
INSERT INTO tvt_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","“Ngah ih amiisak tiit ah baat hala,” Jisu ih ngaakbaatta, “Ju nyia Chiiala nah latupka bah Rangte Hasong nah o uh tajen nop wangka. ");
INSERT INTO tvt_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mina ah hansi ni henuh hewah ih dongtup ha; enoothong chiiala lam dobah Chiiala nawa ih tup ah. ");
INSERT INTO tvt_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sen loong ah weedop tup jaatjaat etheng ngeh ih baatrum kohaano nak paatja an. ");
INSERT INTO tvt_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Pong ah madi pongtheng ah erah di pongla; sen ih pong huuk ah ba chaat han, enoothong manawa pongwang hala nyia maako pong kala erah an ih tajatko. Erah raangtaan ih o mina Chiiala nawa ih tup ha mirep erah likhiik ang ah.” ");
INSERT INTO tvt_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Emah mamah mi ang ah?” Nikodimas ih chengta. ");
INSERT INTO tvt_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisu ih ngaakbaatta. “Ijirel ni nyootte elong laangma ang uh, eno an ih erah tanih jatko? ");
INSERT INTO tvt_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ngah ih amiisak tiit ah baat hala: Seng ih marah jat hi erah jengli nyia marah tup hi erah ah baat hi, erabah uh sen loong ah ih o ih uh seng jengkhaap ah tathang kan. ");
INSERT INTO tvt_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Arah mongrep dowa jaatrep tiit baat rumhala ah sen ih tahanpi ri; eno, Rangmong hasong tiit baat rumhala tang ah, mamah ma ih hanpi an? ");
INSERT INTO tvt_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Eno rangmong ni wasiit taan uh maang thaak wangka, rangmong nawa ra taha Mina Sah ah luulu ba.” ");
INSERT INTO tvt_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Phisaang hani Moses ih jaanmeen nawa hoon arah pu ah thong ni toonbotta, erah likhiik ih Mina Sah ah toonbot jaatjaat ih ah, ");
INSERT INTO tvt_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tiimnge liidi o mina ih heh hanpi ah erah mih rah ih lathoon roidong ah choh ah. ");
INSERT INTO tvt_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Rangte ih mongrep ah erah than ih minchanha Hesah wasiit luulu ah thoonkota, tiimnge liidi o mina ih heh hanpi ah erah tatiika erah nang ebah lathoon roidong ah ba choh ah. ");
INSERT INTO tvt_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Rangte ih Hesah ah arah mongrep dandeete tadaap jataha, erah nang ih khopui pang suh daapkaat taha. ");
INSERT INTO tvt_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","O mina ih Hesah ah hanpiiha erah tadande ka ang ah; enoothong o mina ih lahanpiika erabah jen dande eta, tiimnge liidi heh ih Rangte Sah heh luulu ah tahanpiika. ");
INSERT INTO tvt_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Dande ah emamah ih dande kaat ah; weephaak ah mongrep ni phaak e ra hala, enoothong mina loong ah ih weephaak nang ih laamang asuh ese choha, tiimnge liidi neng reeraang ah ethih. ");
INSERT INTO tvt_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","O mina ethih mokala erah mih ah ih weephaak ah echiik eha eno weephaak ni tawangra, tiimnge liidi neng ethih reeraang loong ah noisok suh tanook rumka. ");
INSERT INTO tvt_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Enoothong o mina ih amiisak moot ah mokala erah loong ah ba weephaak adoh thok haano heh reeraangta ah Rangte jeng chaatchaat ih reeta ngeh ih weephaak ah ih noisok rum ah. ");
INSERT INTO tvt_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Erah lilih, Jisu nyia heliphante loong ah Judia hadaang ko ih karumta, erah ni Jisu neng damdi chomroe saapoot roongtong ano juutem thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aenon ni ju ah hantek ang kano, Joon ih uh erah hah ni juutem rumta, erah hah ah Salim dowa ih haloh tah angta. Miloong ah heh reeni karumta, eno Joon ih ju ah tem ih rumta. ( ");
INSERT INTO tvt_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Erah langla Joon phaatak ni maangsak kaadi.) ");
INSERT INTO tvt_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Joon liphante loong dowa mararah ah Jehudi damdi neng banlam juusaakaat thoidi daanmui rumta. ");
INSERT INTO tvt_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Erah thoidi Joon reeni wangrum ano liiwang rumta, <<Nyootte, Jordan ju saadongko adi an damdi angta wah ah dokthun thaak uh, an ih kabaattu warah ah? Heh ih amadi juutem rumha, eno loongtang heh reeni karumla!>> ");
INSERT INTO tvt_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Joon ih ngaakbaat rumta, <<O suh uh Rangte ih lakoka bah tiim uh tachoka. ");
INSERT INTO tvt_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ngah ih baatrum taha nga haaki ah sen loong ah, ‘Ngah Kristo tah angkang, enoothong heh ngah ni ngah ban kaat thuk halang.’ ");
INSERT INTO tvt_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jaaro suh nookte jaalah ah heteenuh kapte jaaro ah raangtaan ih; eno jaalah kapte warah reeni chapla joonte loong ah heh root ah japchaat rum ano eroon ela. Nga tenroon ah emamah ih ang ah. ");
INSERT INTO tvt_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jisu ah nga nang ih elong jaatjaat ang ah ngah ehin.>> ");
INSERT INTO tvt_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","O khothung nawa ra hala ah loongtang nang ih elongthoon. O arah hah nawa dongla erabah arah hah raangtaan eno heh ih bah arah hatoh hadaang tiit baat ah, enoothong o rangmong nawa ra hala erabah loongtang nang ih echoong ni. ");
INSERT INTO tvt_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Heh ih tiimjaat tupta nyia chaatta ah baat ha, erabah uh heh tiitkhaap ah o ih uh takapka. ");
INSERT INTO tvt_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Enoothong o ih heh tiitkhaap ah kap eha erah dowa ih jattheng Rangte ah amiisak ju. ");
INSERT INTO tvt_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Rangte ih marah wasiit daapjah hala heh Rangte jeng jengla, tiimnge liidi heh suh Rangte ih Chiiala thoontang koha. ");
INSERT INTO tvt_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Hewah ih Hesah ah rapne ih minchan thoidi jirep ah heh chaan hephaan khui ni thiinkoha. ");
INSERT INTO tvt_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","O ih Hesah ah hanpi eha erah taang ni lathoon roidong ah jeela; Hesah jeng laboichaatte loong asuh bah roidong tajeeka, erah nang ebah Rangte tenkhat khui nah cham ah. ");
INSERT INTO tvt_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Joon liphante loong nang ih Jisu ih juutem ehan japtem rum arah Pharisi loong ih japchaat rumta. ( ");
INSERT INTO tvt_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Amimiidi bah, Jisu heteewah ih wasiit taan uh tatem rumta; heliphante loong ih luulu juutem rumta.) ");
INSERT INTO tvt_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Eno Jisu ih erah baatmui rumta ah japchaat ano Judia nawa doksoon ano Galili ni ngaak wangta; ");
INSERT INTO tvt_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","heh wang ih adoh Samaria lam ih wangte jaatjaat angta. ");
INSERT INTO tvt_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Heh Samaria ni Sikar samnuh adi wang taha, erah hah ah Jaakob ih heh sah Josep suh kota phek dowa ih haloh tah angta. ");
INSERT INTO tvt_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jaakob naatbeng ah erah di angta, eno enaang ih ano Jisu lam ni erah re adi naangtongta. Erah tokdi rangnithung angta. ");
INSERT INTO tvt_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samariate minuh nusiit ju khoot wang kohaano, Jisu ih baatta, <<Ngah suh ju ah jok thuk weehang.>> ( ");
INSERT INTO tvt_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Heliphante loong ah erah pootdi samnuh ni phaksat jamriik karumta.) ");
INSERT INTO tvt_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Minuh rah ih ngaak liita, <<An Jehudi nok hah, ngah ah Samaria nok hah —eno an ih nga jiin nawa joong mamah mi sujok hang?>> (Jehudi loong ah ih Samariate ih maak ha huuikhaak ah tami room maakka) ");
INSERT INTO tvt_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisu ih liita, “Rangte ih tiimjaat koha erah ah jat ubah nyia an jiin nawa joong sukjokte warah jattu bah, an ih suk ih thengtu, eno heh ih an suh roidong ju ah kottheng taho.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Minuh ah ih liita, <<Chuupha,” <<an jiinni joongpi theng uh amuh, eno naatbeng ah uh echoong dook. An ih erah roidong ju ah manawa ma choh uh? ");
INSERT INTO tvt_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Arah naatbeng ah sengte sengwah Jaakob ih kohe rah; helui hemaan, heh sah loong nyia heteewah ih arah jok dowa. Jaakob nang ih elong ngeh nakmok thun uh, emah nih mokthun hu?>> ");
INSERT INTO tvt_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisu ih erah nuh asuh liita, <<O ih arah ju ah jok ah heh joongle ih we le e ah, ");
INSERT INTO tvt_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","enoothong ngah ih koh angrah ju ah jok abah mabah uh joongle ih takah we leeka . Ngah ih koh angrah ju abah heh roidong juumik eh hoon ah eno erah juumik rah ih roidong ju ah koh ano lathoon roidong ah koh ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","<<Chuupha<< minuh rah ih liita, <<erah joong ah ngasuh kohang! Enooba ngah joongle ih mabah uh takah leekang, arah doh joong khoot uh takah raarang ang ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisu ih baatta, <<An miwah poonkah uh,” eno <<ngaakwang ho.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","<<Nga miwah tajeeka,” erah nuh rah ih ngaak baatta. Jisu ih ngaak liita, <<An miwah amuh liihu ah an punjeng elu. ");
INSERT INTO tvt_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Amadi tuk ih wabangnga suh nooklu, eno amadi o damdi tonglu erah uh amiisak di an miwah tah angka. An ih amiitiit ah ju baat halang.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","<<Chuupha ngah ih jat ih hala, an khowah,” minuh ah ih ngaak liita. ");
INSERT INTO tvt_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sengwih sengte Samaria nok hah loong ah ih arah kong adi Rangte kah soomtu rumta, enoothong Jehudi sen loong ah ih seng subah Jerusalem hah nah soomtu theng ngeh liihan.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisu ih erah nuh asuh baatta, <<An ih nga jeng ah hanpi hang, saapoot jaasiit thok eha mina loong ah ih Jerusalem nah adoleh arah kong adoh Hewah rang lasoom thang ih tong rum arah ah. ");
INSERT INTO tvt_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samriate sen loong ah ih o rangsoom han amiimi tajatkan; enoothong seng Jehudi nok hah ih bah jat ehi o rangsoom hi erah ah, tiimnge liidi khopiiroidong ah Jehudi nawa ra hala. ");
INSERT INTO tvt_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Enoothong saapoot thok eha amadi jen thok e hala, tiimtok doh mina loong ah ih Rangte Chiiala chaan nawa ih Hewah ah amiisak di mamah ah erah likhiik ih phoongpha adoh, heh ih mamah ih thunha erah tenthun jun ih phoongpha ah. ");
INSERT INTO tvt_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Rangte ah Chiiala, eno mina loong ah ih Chiiala jun ebah heh mamah ah erah likhiik ih somtu rum ah.” ");
INSERT INTO tvt_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Minuh ah ih Jisu suh baatta, <<Ngah ih jat ehang Kristo ah erak eha, eno Heh raaha doh, jirep ah baat ehe.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jisu ih ngaak baatta, <<Erah liihu ah ngah hanih, amadi an damdi o waan hala warah ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Erah pootdi Jisu liphante loong ah ngaakwang e rum taha, eno minuh damdi roongwaan ah japtup rum ano rapne ih paatja rumta. Enoothong neng loong dowa o ih uh minuh asuh tali rumta, <<an ih tiimjih jamhu ngeh ih uh tali rumta?>> Adoleh Jisu suh uh tacheng rumta, <<an arah nuh ah damdi tiimnge roongwaan lu ngeh ah?>> ");
INSERT INTO tvt_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Eno minuh rah ih heh joong khoot tek ah thinhaat ano samnuh ni ngaak wangta, eno erah dowa miloong asuh baatwan rumta, ");
INSERT INTO tvt_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","<<Nga roidong di jirep reeraang tang erah dok baat halang mih ah sok ra thaak han. Heh Kristo ah ma angja oh?>> ");
INSERT INTO tvt_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Erah thoidi erah samnuh dowa dokkhoom rum ano Jisu jiinni karumta. ");
INSERT INTO tvt_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Erah saapoot adi hehliphante loong ah ih Jisu lasih joh rumta, <<Nyootte, tiim ah tiim phaksah uh!>> ");
INSERT INTO tvt_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Enoothong Jisu ih ngaakbaat rumta, <<Nga jiinni phaksat theng eje eno sen ih erah tiit ah tajatkan.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Erah thoidi heliphante loong ah neng jaachi ni phang chengmui rumta, <<Heh suh o ih bah uh phaksat pi tam ih kaat rum taha?>> ");
INSERT INTO tvt_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisu ih li rumta, <<nga phaksat ah langla nga daapkaatte warah ih mootkaat baat halang ah thoon pakna reeraang theng nyia boichaat theng.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Sen tiitthaak ni eje, ‘Chamkhan suh la baji tongla.’ Enoothong ngah ih baat rumhala, phek ah rapniine ih sok an; chamloong ah amadi khan esuh jen men ela! ");
INSERT INTO tvt_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","O mina ih chamkhanha erah suh kot eha nyia lathoonka roidong cham ah lomkhan thuk ha; erah thoidoh o ih wenha nyia o ih khanha nengnyi eroom ih tenroon ang ah. ");
INSERT INTO tvt_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tiitthaak ah amiisak, ‘Wasiit ih wen eha, wasiit ah ih khan eha.’ ");
INSERT INTO tvt_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Sen loong marah phek adi tamoh katan erah dowa khan kaat thuk rumhala; erah di wahoh mokata, eno neng mokata dowa sen ih dakchoh an.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Erah samthung adi songtongte Samariate hantek ih minuh ah ih baatrum kano Jisu ah hanpi ih rumta, <<Ngah reeraang tang jirep ah dokbaat tahang.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Eno Samariate loong ah Jisu taang ni wangrum haano, neng damdoh roongtong suh heh lasih jorumta, eno erah ni Jisu ah saanyi tongthiinta. ");
INSERT INTO tvt_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Heh tiitkhaap ah chaat rum ano hantek ih we boot hanpi rumta, ");
INSERT INTO tvt_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","eno minuh asuh li rumta, <<Seng ih hanpi ehi, an jeng chaat raang ih tahanpiike, enoothong seng teeteewah ih heh jeng ah chaat enooba hanpi hi, seng ih jat ehi amiisak heh ah mongrep puipangte.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Erah ni saanyi tongthiin ano Jisu Galili ni dokkhoom wangta. ");
INSERT INTO tvt_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jisu heh teeteewah ih baatta, <<Khowah loong ah nengdeek nengkaan ni tachoom joka.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jisu Galili ni thok adi, erah dowa miloong ah ih jengse banra rumta, tiimnge liidi Khopi Kuwaang adi neng loong ah Jerusalem ni karumta adoh kuwaang adi jaatrep reeraangta loong ah neng ih japtup ih rumta. ");
INSERT INTO tvt_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Eno Jisu ah Galili hah Kaana samthung adi ngaakwangta, maradi heh ih joong ah kham eh lek hoonthukta hah adi ah. Erah ni apit ni mootte saahaap wasiit angta eno heh sah ah langkoleh Keparnam ni khoisat angta. ");
INSERT INTO tvt_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Judia nawa Galili ni Jisu kaat ah japchaat ano erah warah Jisu jiinni wangta, eno heh sah khoisat deesiit Keparnam nah kaat weetheng ngeh ih baat wanta, erah sah ah tek nanah ih satta. ");
INSERT INTO tvt_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisu ih heh suh baatta, “Sen ih paatjaajih latup kanbah o ih uh tahanpi kan” ");
INSERT INTO tvt_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","“Chuupha,” saahaap ih ngaak baatta, “Nga sah maangti kaadoh wakra weeho.” ");
INSERT INTO tvt_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisu ih heh suh baatta, <<Kah uh, an sah ething ang ah!>> Erah warah ih Jisu jengkhaap ah hanpi ano kata. ");
INSERT INTO tvt_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Heh nok ni ngaak kah adi heh laksuh loong ah lamni chomui rum ano baat rumta, <<An sah bah ese joh, thingtong e ah!>> ");
INSERT INTO tvt_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Heh ih cheng rumta tiim saapoot di heh sah ah deeta, eno ngaakbaat rumta. <<Miinnyah rangnithung lidi saapak esiit di heh khoisat ah deeta.>> ");
INSERT INTO tvt_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Eno hewah ah ih erah saapoot adi Jesu ih <<An sah ah ething<< ngeh ih baatta rah dokthunta. Erah thoidi neng jaatang changtom ih hanpi rumta. ");
INSERT INTO tvt_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judia nawa Galili ni kaat lidi Jisu ih epaatjaajih reeraang ah taknyi noisokta. ");
INSERT INTO tvt_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Erah lih adi, Jisu Jerusalem ni kuwaang raangtaan ih wangta. ");
INSERT INTO tvt_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem ni Saap Paakaawan reeni juutum esiit je ah erah di taapbulaang bangnga angta; Hebrew jengdi erah suh Bethjatha liiha. ");
INSERT INTO tvt_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Erah taapbulaang khui adi khoisatte hantek jupthiin rumta erah di edook, ekoong, nyia huuimu nang angta. ");
INSERT INTO tvt_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Neng loong ah juutum lengphui ah bansok rumta, erah juutum ah Teesu rangsah ah kah ano ju ah kalengphui thukta, o mina tiimjaat khoisat ang abah uh erah juutum lengphui adi o jaakhoh temkata erah kadeeta. ");
INSERT INTO tvt_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Erah di mih wasiit rookjom pang asat sat arah angta. ");
INSERT INTO tvt_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisu ih erah di loongjupta mih ah japtup ano, sa hantek satla ngeh ih jat eta; erah thoidi chengta, <<An de esuh enook nih ih lu?>> ");
INSERT INTO tvt_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Khoisatte ah ih ngaakbaatta, <<Chuupha, juutum ah lengphui adi nga datthiin kaatte o uh takajeeka; erah tokdi nopwang taatchung leh, jaakhoh wahoh kanop wang ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jisu ih heh suh liita, <<toonchap uh, an dam ah toonpi uno, khoom uh.>> ");
INSERT INTO tvt_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Erah baat kano erah mih ah lakdamdam ih deeta; heh dam ah toonpi ano phang toonkhoomta. Erah sa ah Jehudi naangtongsa ja angta, ");
INSERT INTO tvt_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","erah thoidi Jehudi ngoong awang loong ih khoisat deeta warah suh li rumta, <<Chiinnyah Jehudi naangtongsa, erah raangtaan ih an dam toonpi ah seng hootthe jun ih tapunka.>> ");
INSERT INTO tvt_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Heh ih ngaakbaat rumta, <<Nga khoisat deesiitte warah ih dam ah toonpi thuk hangno khoom thuk tahang.>> ");
INSERT INTO tvt_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Neng ih chengta, <<An suh emah re thukte ah o ah?>> ");
INSERT INTO tvt_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Enoothong khoisat deeta warah ih Jisu ah o angta ah tajatta, erah di mih hantek angkano, Jisu ah erah dowa doksoon ih kata. ");
INSERT INTO tvt_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Lini, Jisu ih erah mih ah Rangteenook ni japtup ano baatta, <<Boichaat uh, amadi an khoisat ah de etu; erah raangtaan ih rangdajih lakah reetheng erah khodoh ethih phomok cham uh.>> ");
INSERT INTO tvt_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Eno erah mih ah doksoon kah ano Jehudi ngoong awang loong asuh baatkaat rumta heh khoisat deesiitte ah Jisu angta ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Erah thoidi Jehudi naangtongsa di deesiit kano, Jehudi loong ah ih Jisu ah phang siikhaam rumta. ");
INSERT INTO tvt_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisu ih ngaakbaat rumta, <<Seng Wah ah saarookwet ih mokala, eno Ngah uh emamah ih mokah ang.>> ");
INSERT INTO tvt_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Heh jengkhaap ah ih Jehudi ngoong awang loong ah heh tek haat suh ehanhan ih samthun thuk rumta; naangtongsa hootthe luulu lathet hoom, Rangte asuh seng Wah ngeh ih li ano Rangte ah heteewah thanthan ih samthunha. ");
INSERT INTO tvt_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Erah thoidi Jisu ih ngaakbaat rumta, <<Ngah ih amiisak baat rumhala; Hesah ah heh thungthung ih tiim uh tami reeka; Hewah tiim mokala erah sok ano reela. Hewah tiim reela, Hesah uh erah re ah. ");
INSERT INTO tvt_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tiimnge liidi Hewah ih Hesah ah rapne ih minchanha eno heh tiimjih mokala erah ah noisok ha. Arah nang ih elong mootkaatjih uh noisok ih ah, eno sen loong erah suh paatja e an. ");
INSERT INTO tvt_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Hewah ih tek nawa ngaaksaat thuk ano roidong koha, erah likhiik ih Hesah ih uh o suh kotthung ah erah suh roidong koh ah. ");
INSERT INTO tvt_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Adoleh Hewah ih wasiit taan uh tadande ka. Hesah suh jen dande ih thuk ha, ");
INSERT INTO tvt_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tiimnge liidi Hesah ah Hewah likhiik ih toom choomjoh rum ah ngeh ah. O ih Hesah lasoomtu ka heh daapkaatte Hewah rah uh tasoomtu ka. ");
INSERT INTO tvt_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","<<Ngah ih amiisak baat rumhala; o mina ih nga jeng boichaat ano nga daapkaatte ah hanpi ha erah mina taang ni lathoonka roidong ah je ah. Heh abah tadande ka ang ah, heh tek lam dowa roidong ko jen nopwang eta. ");
INSERT INTO tvt_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ngah ih amiisak baat rumhala; saapoot ah thok e hala—jenthok ih taha—tekte loong ah ih Rangte Sah root japchaat adoh, boichaatte loong ah ih roidong choh ah. ");
INSERT INTO tvt_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Hewah heteteewah ah, roidong lampo angla likhiik, Hesah rah uh erah likhiikkhiik roidong lampo. ");
INSERT INTO tvt_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Eno Hesah asuh mi dande esuh chaan aphaan ah koha, tiimnge liidi heh ah Mina Sah. ");
INSERT INTO tvt_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Arah suh nak paatja an; tekte loong ah ih heh root boichaat saapoot ah ethok ehala ");
INSERT INTO tvt_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","eno neng loong ah mangbeng nawa dokkhoom eha; oh jaase ih mokata erah loong ah ngaaksaat ano ething tong ah, eno o ethih mokata erabah ngaaksaat ih adoh dut haat ih ah. ");
INSERT INTO tvt_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","<<Nga chaan nawa ih ngah ih tiim uh tajen reekang; Rangte ih baat halang jun ih ba dande hang, erah raangtaan ih ngah ih dande hang ah epun ang ah, tiimnge liidi nga tenthun nawa ih tareekang, enoothong nga daapkaatte warah ih tiim thun ha erah mootkaatte . ");
INSERT INTO tvt_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","<<Mih suh nga teewah tiit ah mokbaat angbah, ngah ih marah baat hang erah elang ekah ngeh ih mih ih takapka ang ah. ");
INSERT INTO tvt_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Enoothong nga tiit baatte wahoh eje, eno ngah ih jat ehang nga tiit marah heh ih baat ha erah amiisak tiit ah baat ha. ");
INSERT INTO tvt_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Sen ih Joon reeni heh jeng boichaat suh mih daap wantan, eno Joon ih ami tiit ah baatta. ");
INSERT INTO tvt_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ngah mina dowa haaki eje jaatjaat angtheng ngeh ih taliikang; arah jenglang abah sen khoh toompui an ngeh ih jenglang. ");
INSERT INTO tvt_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Joon ah weetook phaakjaaja ih lu arah likhiik, eno sen loong ah heh weephaak asuh pootsiit eroon etan. ");
INSERT INTO tvt_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Enoothong Joon ih haaki kotahan nang ih nga teeteewah ih haaki korumhala ah elong; ngah ih tiimjih mokalang, erah seng Wah ih mootkaat thuk halang, erah mokalang loong ah jun ih nga ah seng Wah ih kaatthuk halang ngeh ih jatthuk rumhala. ");
INSERT INTO tvt_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Eno nga daapkaatte, seng Wah ih uh, nga teewah tiit ah ju jatthuk halan. Sen ih heh root uh maang taat chaatkan nyia hethe hekhoh uh maang thaak tupkan, ");
INSERT INTO tvt_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","eno heh tiitkhaap uh sen ten ni tathiin kan, tiimnge liidi heh daapkaatte warah ah tahanpi kan. ");
INSERT INTO tvt_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Sen ih Rangteele ah wet ehan, sen ih mokthun han erah doh lathoonka roidong ah choh e ih ngeh ah. Eno Rangteele adi nga tiit baat ha! ");
INSERT INTO tvt_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Rah bah uh lathoonka roidong chosuh nga reeni wangsuh o uh tanook kan. ");
INSERT INTO tvt_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","<<Ngah ih mina ih phoongpha tajamkang. ");
INSERT INTO tvt_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Enoothong sen tiimjaat mina ah ngah ih jat ih rumhala, eno ngah ih jat ih rumhala sen ten ni Rangte minchan ah taje kan. ");
INSERT INTO tvt_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Seng Wah chaan ah kap angno ra halang, enoothong sen ih nga jeng ah tathang kan; erah thaknang eh, marah marah heh chaan nawa ih ra hala, erah jeng ah ba thang han. ");
INSERT INTO tvt_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sen ih sen jaachi ni phoongpha mui ah jamhan, enoothong Rangte taangnawa ra hala esiit luulu ah ih toom gu hang ngeh ih tasamthun kan; erah raangtaan ih sen ih mamah ma ih hanpi he? ");
INSERT INTO tvt_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nakmok thun an, seng Wah suh ngah ih sen tiit thetbaatte ngeh ah. Sen thetbaatte abah, sen ih tuumaang han, Moses ah ba ang ah. ");
INSERT INTO tvt_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sen ih Moses ah amiisak ih hanpi tanbah, sen ih ngah uh hanpi etheng ang tahe, tiimnge liidi Moses ih nga tiit ah raangta. ");
INSERT INTO tvt_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Enoothong heh ih tiim raangta erah lahanpi phiino, Ngah ih liihang ah batang ah mamah ma ih hanpi an?>> ");
INSERT INTO tvt_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Arah lidi, Jisu Galili Juusitum ah daansoon kata (erah suh, Taiberia Juusitum ngeh uh men eha). ");
INSERT INTO tvt_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Khoisatte loong ah epaatja etheng ih deesiitta ah tuprum ano miloong ah helilih ih phankhoom rumta. ");
INSERT INTO tvt_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisu kong adi duuwaang ano heliphante loong ah damdi roongtong wangta. ");
INSERT INTO tvt_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Khopi Kuwaang saapoot ah thok ih taha. ");
INSERT INTO tvt_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisu ih miloong ah jamsok adi hantek heh reeni wang arah japtupta, erah thoidi Philip suh chengta, <<Aathan mina suh kotsuh manawa phaksat choh reh ih?>> ( ");
INSERT INTO tvt_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Heh ih Philip suh thamtham ih thaak chengta; amiidi baleh heh ih tiim etheng erah jat eta.) ");
INSERT INTO tvt_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip ih ngaakbaatta, “Baanlo ah loongtang ih cheeru phak raangtaan ih botseh, chaanyi nang ih ehan ngunkholok ih ba lui reh ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Heliphante changdowa wahoh, Andriu, ngeh ih Simon Pitar no angta ah ih liita, ");
INSERT INTO tvt_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","<<Adi miwasah wasiit je ah, heh taang ni wong nawa hoon arah baanlo bangnga je ah erah damdi nyasi enyi. Enoothong erah than mina suh tabaam luika.>> ");
INSERT INTO tvt_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","<<Miloong ah tongthuk an,” Jisu ih baat rumta. (Erah di naam nang angta.) Erah thoidi miloong ah tong rumta; erah di miwah rooproop ih haajaat bangnga ang rumta. ");
INSERT INTO tvt_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisu ih baanlo ah toonpi ano, Rangte suh lakookmi liita, eno erah di tongte loong asuh pheekokaat thuk rumta. Nyasi ah uh emamah ih pheekoh rumta, eno neng ih mathan ih phaksah ah erah than ih korumta. ");
INSERT INTO tvt_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Neng wok ah phoot phaksah rum ano, heliphante loong asuh baatta, <<baanlo chep dakla loong ah khoontoon ih an; amasah uh lathaaja theng.>> ");
INSERT INTO tvt_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Baanlo bangnga dowa miloong ah ih dakphakta ah asih hongnyi ni lomtoon rumta. ");
INSERT INTO tvt_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jisu ih epaatjaajih reeta ah tuprum ano, miloong ah ih liita, “Mongrep ni kaatte Khowah abah amiisak di heh ju!>> ");
INSERT INTO tvt_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisu ih jat eta miloong ah wangrum haano neng Luuwang laat angthuk suh jowang rumha ngeh ah; erah raangtaan ih Jisu heluulu kong ko soonwangta. ");
INSERT INTO tvt_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Rangja ang kano, Jisu liphante loong ah juusitum ko ih karumta, ");
INSERT INTO tvt_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","eno khoonkhu adi duukah rum ano, juusitum lam ih Kaparnam ko ih daansoon wang rumta. Rang jennak ih adi uh, Jisu neng taang ni tangaak ra taha. ");
INSERT INTO tvt_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Neng taangko pong ah rapne ih pong ano ju ah rapne ih mootmotta. ");
INSERT INTO tvt_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Heliphante loong ah meejombaji taan daanjop rum adi, Jisu ju khoni khoom arah japtup rumta, heh khoonkhu ko ih ra taha eno neng loong ah echo ih rumta. ");
INSERT INTO tvt_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","<<Nakcho an,” Jisu ih baat rumta, <<Ngah hanih!>> ");
INSERT INTO tvt_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Erah lih adi khoonkhu ni toonhui rumta, eno neng kaat theng ko ih juukaang ni khoonkhu ah seek ih thoksoon kata. ");
INSERT INTO tvt_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Erah saalih adi juusitum saangko dowa miloong ah ih dokthun rumta erah di khoonkhu ah esiit luulu ka ang ah ngeh ah. Neng ih jat eta Jisu heliphante loong ah damdi erah di takata, enoothong Jisu ah thiinhaat rum ano neng luulu karumta. ");
INSERT INTO tvt_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Taiberia dowa, khoonkhu ehoh loong ah, juukaang ni raarum taha maradi Teesu Jisu ih lakookmi li ano baanlo pheekoh rumta re adi ah. ");
INSERT INTO tvt_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Miloong ah ih, Jisu nyia helihphante loong ah, erah di lajaptup rum kaano Kaparnam ko wangte khoonkhu adi duuwang rum ano tumjam wang rumta. ");
INSERT INTO tvt_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mina loong ah ih Jisu ah juusitum saangko japtup rum ano li rumta, <<Nyootte, an aradi mabah ra taho?>> ");
INSERT INTO tvt_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisu ih ngaakbaat rumta, <<Ngah ih sen loong asuh amiisak ih baat rumhala; ngah ih jat ehang sen loong ah ih baanlo ah sen wok laanphoot roh ih phak anno jam hali, paatjaajih reelang ah jat anno tah angka. ");
INSERT INTO tvt_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ethet ela phaksat raangtaan ih nak mokah an; erah nang ebah, lathoonka roidong phaksat raang ih mokah an, eno erah langla Mina Sah rah ih kohan, tiimnge liidi, Rangte Hewah ih heh mendi sin hoon thiinta.>> ");
INSERT INTO tvt_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Erah thoidi neng ih cheng rumta, <<Rangte ih seng suh reethuk suh liiha jun ih tiimjih jen re ih?>> ");
INSERT INTO tvt_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisu ih ngaakbaat rumta, <<Rangte ih sen suh tiimre thukjih ah langla heh ih wasiit kaat thuk hala ah hanpi an. ");
INSERT INTO tvt_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Neng loong ah ih ngaakbaatta, <<Seng ih hanpi suh an ih paatjaajih tiimjih noisok he? An tiimjih re uh? ");
INSERT INTO tvt_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Phisaang hah ni sengte sengwah loong ih manna phakta, erah Rangteele ni liiha likhiik, ‘Neng loong asuh rangmong nawa Heh ih baanlo phakthuk rumta.’” ");
INSERT INTO tvt_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","“Ngah ih amiisak baat rumhala,” Jisu ih baat rumta, <<Moses ih tiimjih koh tahan erah rangmong nawa baanlo tah angta; rangmong nawa amiisak baanlo kottte abah seng Wah. ");
INSERT INTO tvt_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Rangte ih koha baanlo ah langla o rangmong nawa ra hala erah, eno mongrep mina suh roidong koha.>> ");
INSERT INTO tvt_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","“Chuupha,” miloong ah ih surumta, “Arah baanlo ah saarookwet kohe.” ");
INSERT INTO tvt_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","“Roidong baanlo ah Ngah,” Jisu ih baat rumta. “O mina nga taang ni wang hala heh mabah uh ram ih tatiika; o mina ih ngah hanpi halang erah mih ah mabah uh joongle ih taleeka. ");
INSERT INTO tvt_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngah ih, baat rumhala sen ih tup ih he bah uh tahanpi kan. ");
INSERT INTO tvt_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","O mina seng Wah ih ngasuh kohalang ah nga taangnah wangha. Nga taang ni thokte ah o uh taphanhaat kang, ");
INSERT INTO tvt_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","tiimnge liidi ngah rangmong nawa nga tenthun jun ih reesuh tara tahang enoothong ngah o ih daapkaat halang erah tenthun jun ih re suh ra tahang. ");
INSERT INTO tvt_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Eno nga daapkaatte tenthun ah langla ngasuh o koh halang erah loong ah ngah ih lamat haat theng, erah nang ebah rangthoon doh neng loong ah roidong raang ih ngaaksaat thuk ang. ");
INSERT INTO tvt_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tiimnge liidi seng Wah ih jamha langla o ih Hesah ah japtup ano heh hanpi ha erah loong ah ih lathoonka roidong ah choh ah. Eno ngah ih neng loong ah rangthoon doh roidong chosuh ngaak saatsiit ang.>> ");
INSERT INTO tvt_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Miloong ah Jisu thoidi phang jengmui rumta, tiimnge liidi Jisu ih liita, <<Rangmong nawa ra taha baanlo ah ngah.>> ");
INSERT INTO tvt_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Erah thoidi neng ih liita, <<Arah mih ah Joseph sah, Jisu tanih angka? Heh nuwah uh seng ih jat ehi. Eno, heh ih, rangmong nawa ra halang ngeh mamah ih miili ah?>> ");
INSERT INTO tvt_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisu ih ngaakbaat rumta, <<Sen jaachi ni jengmui ah toihaat ih an. ");
INSERT INTO tvt_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nga daapkaatte seng Wah ih lathoksiit raabah o uh nga taangnah tami wangra; eno erah mih ah rangthoon doh roidong kot suh ngah ih ngaak saatsiit ih ang. ");
INSERT INTO tvt_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Khowah loong ih raangta, ‘Mina thoontang suh Rangte ih nyootsoot ah.’ O ang abah uh seng Wah jeng ah chaat ano kap ih abah erah mih ah nga taangnah wangha. ");
INSERT INTO tvt_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Seng Wah ah warep ih japtupchoi ngeh ih liijih tah angka; o heh jiin nawa ra hala erah ih luulu bah Hewah japtup ha. ");
INSERT INTO tvt_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ngah ih amiisak baat rumhala; o mina ih hanpi ha erah mih ah ih ba lathoon roidong ah choh ah. ");
INSERT INTO tvt_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Roidong baanlo ah ngah. ");
INSERT INTO tvt_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Phisaang hah ni sente senwah loong ah ih manna phakta, erabah uh neng loong ah etek eta. ");
INSERT INTO tvt_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Enoothong rangmong nawa ra taha baanlo phakte ah tatiika. ");
INSERT INTO tvt_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Rangmong nawa ra taha ething baanlo ah ngah. Erah baanlo ah o ih phak ah, erah mih ah roitang tong ah. Heh suh baanlo kohang ah nga si, erah ngah ih mongrep nah thingtong suh kohang.>> ");
INSERT INTO tvt_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Emah li kano Jehudi loong ah neng jaachi ni tenkhat lam ih phang daanmui rumta. <<Erah mih ah ih heh si mamah mi phakthuk he?>> Neng loong ah ih cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisu ih ngaakbaat rumta, <<Ngah ih amiitiit ah baat rumhala; sen loong ah ih Mina Sah si ah laphak kanbah nyia heh sih ah lajok kanbah, sen jiinnah roidong tajeeka ang ah. ");
INSERT INTO tvt_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","O ih nga si phak ah nyia nga sih jok ah heh suh ba lathoon roidong ah je ah, eno rangthoon doh ngah ih roidong raang ih heh ngaaksaat thuk ang. ");
INSERT INTO tvt_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tiimnge liidi nga si ah amiimi phaksat theng; nga sih ah amiimi jokjih. ");
INSERT INTO tvt_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","O mina ih nga si phak ah nyia nga sih jok ah erah nga damdi, eno ngah heh damdi tonglang. ");
INSERT INTO tvt_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ething tongla Wah rah ih daapkaat halang, eno heh thoidi ba ngah uh thingtong elang. Erah likhiikhiik o ih nga si phak ha nga thoidoh heh uh ething tong ah. ");
INSERT INTO tvt_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Arah thoidi, rangmong nawa ra hala baanlo ah; sente senwah ih phakta baanlo ah likhiik tah angka, neng loong ah bah tek eta. O mina ih arah baanlo ah phak ah erabah roitang thingtong ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kaparnam hani Jehudi rangsoomnok ni nyootsoot adi Jisu ih erah tiit ah baat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Helilih ih khoomte loong dowa hantek ih boichaat rum ano li rumta, <<Arah nyootsoot ha abah rapne ih echaan. O ih ma jen boichaat ah?>> ");
INSERT INTO tvt_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Labaat rumka bah uh, Jisu ih jat eta erah thoidi daanmui rumla ngeh ah, erah thoidi Jisu ih li rumta, <<Arah nyootsoot rumhala ah sen raang ih lanook chaat theng tam ah? ");
INSERT INTO tvt_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Jengthaak asuh, Mina Sah ah mani angta erah di ngaakwang ah tup anbah mamah ang ah? ");
INSERT INTO tvt_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Rangte Chiiala ih roidong koha; hansi chaan aphaan ebah tiim uh tajen eke. Sen damdi roongwaan halang tiitkhaap adi Rangte ih koh arah roidong Chiiala je ah. ");
INSERT INTO tvt_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Erabah sen loong dung dowa mararah ih tahanpi kan.>> (Jaakhoh dowa ih dook Jisu ih jat eta o mina ih tahanpi ka nyia o ih heh mokwaan ah.) ");
INSERT INTO tvt_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Eno Jisu ih we boot baatta, <<Erah thoidi ngah ih baatrum taha seng Wah ih lawang thukra bah nga taangnah o uh tajen wangra.>> ");
INSERT INTO tvt_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Erah thoidi, Jisu damdi roong khoomte loong ah hantek liko ngaak rum ano lidi takah roongkhoom rumta. ");
INSERT INTO tvt_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Erah raangtaan ih heliphante asiwanyi asuh chengta, <<Sen loong ah nep—doksoon esuh enook nih lan?>> ");
INSERT INTO tvt_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Pitar ih liita, <<Teesu, seng loong ah o jinnah maakah kah ih? An jengkhaap ni ba lathoonka roidong tiit ah jeela. ");
INSERT INTO tvt_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Eno amadi seng ih hanpi ehi nyia jat ehi an luulu juuba Rangte taangnawa raaho rah Esa warah ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisu ih ngaatbaat rumta, <<Ngah ih sen asiwanyi tanih danje rum taha? Erabah uh sendung dowa wasiit ah hakhoh luuwang!>> ");
INSERT INTO tvt_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jisu ih Simon Iskariot sah, Judas tiit baatta. Tiimnge liidi Judas ah heliphante loongdung dowa heliphante taat ang abah uh, heh ih Jisu mokwaanta. ");
INSERT INTO tvt_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Erah lih adi, Jisu Galili ni tumkhoomta; Jehudi ngoong awang loong ah ih tek haat esuh jamrum kano, heh Judia ni tumkhoom suh tanookta. ");
INSERT INTO tvt_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jehudi Nyutaap hoon Kuwaang ah thok ih taha, ");
INSERT INTO tvt_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","erah raangtaan ih heh no loong ah ih Jisu suh baat rumta, <<An reeraang ah an liphante loong ah ih toomjat asuh arah dowa Judia hah nah kah uh. ");
INSERT INTO tvt_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mih ih toom khomjat hang ngeh ih li abah o uh hotsu ih tareeka. An emah ih reelu bah, mongrep nah warep ih toom khomjat ho!>> ( ");
INSERT INTO tvt_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Heh no loong ih taan uh tahanpi rumta.) ");
INSERT INTO tvt_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisu ih li rumta, <<Nga reeraang saapoot tok ah nga raang ih maang thokra. Sen suh ba tiim saapoot ang abah uh punroh ih ah. ");
INSERT INTO tvt_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mongrep dowa mina loong ah ih sen tamiksuk ran, tiimnge liidi neng reeraang pakna ethih tiit ah baatroh ih kangno, ngah ba miksuh rum halang. ");
INSERT INTO tvt_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Sen loong ah kuwaang adoh kaatba kah an, arah kuwaang adoh ngah tara rang, tiimnge liidi nga saapoot ah maang thokra” ");
INSERT INTO tvt_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Emah ih baatrum ano, Jisu Galili ni tangtongta. ");
INSERT INTO tvt_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Heh no loong ah kuwaang ni kaat lidi, Jisu uh we kaat eta; enoothong, heh saasa lah angthang eh, hotsu ih kata. ");
INSERT INTO tvt_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jehudi ngoong awang loong ah ih kuwaang adi bansokroh ih rumta. <<Heh mani ah?>> Ngoong awang loong ah ih cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Miloong dung ni heh tiit ah rapne ih huwaan rumta. Mararah ih liita, “Heh wase,” rukho loong ah ih liita, “Tah angka,” mih thong moong mokwaan ha.” ");
INSERT INTO tvt_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Enoothong ngoong awang loong raacho ih, wuusa ni o uh tajengta. ");
INSERT INTO tvt_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jisu ih Rangteenook ni phang nyootsoot wangta adoh kuwaang thako ah jenkuh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jehudi ngoong awang loong ah rapne ih paatja rum ano jeng rumta, <<Arah mih ah iskun ni leewet mabah lataat kah kaarah erah than manawa ih jat ha?>> ");
INSERT INTO tvt_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisu ih ngaakbaat rumta, <<Ngah ih tiim nyootsoot hang erah nga thung ih tanyoot kang, erah langla nga daapkaatte, Rangte taangnawa ra hala. ");
INSERT INTO tvt_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","O mina ih Rangte mongtham jun ih reesuh nookla erah mih ah ih ba jat ah ngah ih nyootsoot hang ah Rangte taangnawa tam nga thung ih nyootsoot hang. ");
INSERT INTO tvt_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","O mina heh teewah chaan nawa jengla erah mih ah ih heh teeteewah rangka suh liiha. Enoothong o ih heh daapkaatte men ah rangka suh li abah erah mih ah ba toongtang, eno heh tamoongka ang ah. ");
INSERT INTO tvt_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses ih Hootthe tanih koh tahan? Enoothong sen loong ah ih wasiittaan ih uh takap kan. Nga tek haat suh sen ih tiim esuh setlak taatchung hali.>> ");
INSERT INTO tvt_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Miloong ah ih ngaakbaat rumta, “An sak ni juubaan pan bo ah!” “O ih tek haat chungko halu?” ");
INSERT INTO tvt_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisu ih ngaakbaat rumta, <<Paatjaatheng esiit re kangno, sen loong ah paatja etan. ");
INSERT INTO tvt_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses ih sen loong asuh sen sah miwasah khoopkhan baat tahan (Moses ih tah angka sente senwah loong ah phang banlamta), eno sen loong ah ih sen sah miwasah khoopkhan banlam ah Jehudi Naangtongsa hoon han. ");
INSERT INTO tvt_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moses Hootthe ah naktoom thih ah li anno sen sah khoopkhan banlam ah Jehudi Naangtongsa adi hoon han, ngah ih Naangtongsa mih wasiit deesiit raang ih tiimnge ih khadah lan? ");
INSERT INTO tvt_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Rangkhoh ni sok an ih dande han ah toi ih an, erah nang ebah amiisak doh dande theng.>> ");
INSERT INTO tvt_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem noksong mararah ih liita, <<ngoong awang loong ih tek haat chungha ah aa mih ah tam ah? ");
INSERT INTO tvt_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Sok thaak an! Heh noksong dung ni tiitbaatla, eno heh suh o ih uh tiim uh taliika! Neng loong ah ih Kristo ngeh amiisak jattam ih rumha? ");
INSERT INTO tvt_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Enoothong Kristo raaha doh bah o ih uh manawa ra hala ngeh ih tajatka ang ah. Eno seng loongtang ih jat ehi arah mih ah manawa ra hala.>> ");
INSERT INTO tvt_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisu ih Rangteenook ni nyootsootta adoh erongrongwah ih jengta, <<Amiimi ngah manawa ra halang sen ih jat tam ih hali? Nga chaan nawa ih tara rang. O ih ngah daapkaat halang, erah juuba ami ah. Sen ih heh ah tajatkan, ");
INSERT INTO tvt_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","enoothong ngah ih bah jat ehang, tiimnge liidi ngah heh taangnawa nyia heh ih daapjah halang.>> ");
INSERT INTO tvt_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Erah lih adi Jisu joot chung rumta, enoothong o ih uh tabuh rumta, tiimnge liidi heh saapoot ah maangthok ang taha. ");
INSERT INTO tvt_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Eno midung dowa mih hantek ih Jisu ah hanpi rum ano li rumta, <<Kristo raaha doh, arah mih reela nang ih ehan paatjaajih tamre ah?>> ");
INSERT INTO tvt_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pharisi loong ah ih Jisu tiit miloong huwaan arah japchaat rumta, eno romwah phokhoh loong nyia neng ih bante loong marah marah ah Jisu jootkhak kaat thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisu ih liita, <<Sen damdoh chomroe saapoot ba boot roong tongthiin hang, eno nga daapkaatte ah jiinnah wang ang. ");
INSERT INTO tvt_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Sen ih ngah jamsok ehe, enoothong tajap tupri ang ah, tiimnge liidi ngah wanglang adoh sen tami wangran.>> ");
INSERT INTO tvt_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jehudi ngoong awang loong ah neng jaachi ni roongwaan rumta, <<Seng ih lajaptup theng heh maako maakah ah? Seng mina songtong rumla Grik samnuthung adoh kah ano, Grik mina suh nyootsoot kaat suh tam liiha? ");
INSERT INTO tvt_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Heh ih liiha seng ih jam bah jamsok eh ih enoothong tachoh jamke ang ah, eno heh wangla adoh seng tajen wangke. Erah tiimjih suh liiha?>> ");
INSERT INTO tvt_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Thoontang nang eh hoondak rangwuuja ah kumatja saakaan ah angta, eno Jisu ah toonchap ano erongrongwah ih baattaan rumta, <<O mina joongle ih tiila nga taangnah wang han, eno ");
INSERT INTO tvt_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","o ih hanpi halang erah ih jok theng. Rangteele ni liiha, ‘Roidong joisah ju ah heheh taangnawa dokjan ah.’” ");
INSERT INTO tvt_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Erah langla Jisu ih Chiiala tiit ah baatta, o mina ih hanpi ah neng loong ah ih choh ah. Erah tokdi Chiiala ah maangkoh angta, mamah liidi heh rangka suh Jisu ah maang ngaaksaat angta. ");
INSERT INTO tvt_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Erah jengta ah japchaat rum ano miloong dung dowa mararah ih li rumta, <<A mih abah amiisak Khowah ju angkah!>> ");
INSERT INTO tvt_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wahoh loong ah ih liita, <<Kristo ah heh!>> Enoothong rukho ah ih liita, <<Kristo ah Galili nawa taraara! ");
INSERT INTO tvt_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Rangteele ni liiha Kristo ah Dewid Luuwang sutoom dowa ang ah eno Dewid songtongta hadaang adoh Betlehem nah tup ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Erah raangtaan ih Jisu thoidi miloong ah neng jaachi di pheephaak rumta. ");
INSERT INTO tvt_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mararah ih jootkhak chung rumta, enoothong neng lak tapak rumta. ");
INSERT INTO tvt_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bante loong ngaakwang kohaano, Romwah phokhoh loong nyia Pharisite loong ih bancheng rumta, <<Sen loong ah ih mamah lasiitwan halan?>> ");
INSERT INTO tvt_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bante loong ah ih ngaakbaat rumta, <<A mih jengla ah likhiik o uh tathaak mi jengka!>> ");
INSERT INTO tvt_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","<<Sen nep, tam mokwaan tahan?>> Pharisite loong ah ih cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","<<Ngoong awang nyia Pharisite loong dowa wasiit taan heh hanpiite tup tam etan? ");
INSERT INTO tvt_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Erah miloong ah ih Moses hootthe ah tajat rumta, erah raangtaan ih neng loong ah Rangte tenkhat khui ni!>> ");
INSERT INTO tvt_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Erah di Pharisi loongdung dowa Nikodima ngeh ih angta, erah mih ah jaakhodi Jisu sok ih wangta. Heh ih wahoh loong asuh liita, ");
INSERT INTO tvt_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","<<Seng hootthe jun dobah seng ih maangjap chaatke doh nyia heh reeraang maangjap tupke doh tami dut haatke.>> ");
INSERT INTO tvt_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","<<Ese<< neng loong ah ih ngaak liita, <<an uh Galili nawa ba? Rangteele ah weh uno jat uh Galili nawa raaha rah khowah o uh amuh angta.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Erah lih adi mirep neng nok ni wangta, eno Jisu ah Olip Kong ni wangta. ");
INSERT INTO tvt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Erah saalih adi rangkhano di heh Rangteenook ni ngaakwangta. Mih loongtang ih heh ah kooktong rum kano, chooktong ano phang nyootsoot rumta. ");
INSERT INTO tvt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hootthe nyootsootte loong nyia Pharisi loong ih minuh nusiit mih damdi roomjup arah nopsiit wanrum haano, neng loong ngathong ni chap thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","<<Nyootte<< neng loong ah ih Jisu suh baat rumta, <<arah nuh ah mih damdi roomjup arah japjoot dowa. ");
INSERT INTO tvt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Seng Hootthe ni Moses ih baatta erah likhiik minuh ah jong ih tekpat theng. Emah ang abah, an ih mamah li uh?>> ");
INSERT INTO tvt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Neng loong ah ih erah Jisu ah mat ih joot suh li rumta, jen deejoot esuh ngeh ah. Enoothong Jisu ah ngupbon ano heh laktiik ih hani raangta. ");
INSERT INTO tvt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Erah di chap rum ano Jisu suh chengroh ih rumta, eno toonchap ano neng loong asuh baat rumta, <<Sen loong dung dowa amadi tuk ih rangdah lataat dah kan mina ah ih jaakhothoon erah nuh ah jong ih phang pat an.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Erah lih adi kotbon ano hani we raangta. ");
INSERT INTO tvt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Erah chaat rum ano, neng loong ah, wasiit wasiit eh, doksoon rumta, mihakthoon ah jaakhoh doksoonta, eno Jisu heh luulu thiinhaat rumta doh minuh ah heh reeni chaproh eta. ");
INSERT INTO tvt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisu ah toonchap ano erah nuh asuh liita, <<Maako ih rumla? An dut haatte o bah uh daktong tam ela?>> ");
INSERT INTO tvt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","<<Wasiit uh amuh, chuupha,” minuh ah ih ngaakbaatta. “Ese, emah ang abah ah,” Jisu ih ngaak liita, “Ngah ih uh tah dut haatra. Kah uh, enoothong nak kah dah uh.” ");
INSERT INTO tvt_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pharisi loong ah damdi Jisu we roongwaanta. <<Mongrep raang ih ngah ah weephaak,” Jisu ih liita. <<O mina ih nga lih phanhang heh jiinnah roidong weephaak ah je ah eno heh mabah uh laamang nah takhoomka.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pharisi loong ah ih Jisu suh li rumta, <<Amadi an ih an teeteewah tiit baat hu; an jenglu jun ih tiim uh tadong jatthuk ri.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","“Emah tah angka” Jisu ih ngaakli rumta, <<ngah ih nga teewah tiit baat ang bah uh, ngah ih tiimjih baat hang erah amiisak tiit, tiimnge liidi ngah ih jat ehang ngah manawa ra halang nyia manah wang ang. Sen loong ih tajatkan ngah manawa ra halang nyia manah wang ang. ");
INSERT INTO tvt_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Sen ih mina hansi jun ih dande han; ngah ih bah o uh tadande kang. ");
INSERT INTO tvt_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Enoothong ngah ih emah mok ih thengtang bah, ngah ih dande hang ah epun ang thengta, tiimnge liidi adi nga luulu tah angkang; nga daapkaatte seng Wah nga damdi. ");
INSERT INTO tvt_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sen hootthe ni raangha haaki wanyi ah thungsiit doh jut abah, nengnyi ih tiim li ah erah ami ang ah. ");
INSERT INTO tvt_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ngah ih nga teewah tiit ah baat hang, eno nga daapkaatte seng Wah ih uh nga tiit baat ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","<<An Wah mani ah?>> Pharisi loong ah ih Jisu suh cheng rumta. <<Sen loong ah ih seng Wah tajatkan ngah uh tajatri.>> Jisu ih ngaakbaat rumta. <<Sen loong ah ih ngah jat he bah seng Wah uh jat etheng tan.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Arah jengkhaap ah Jisu ngunthiin theng nokkhok adi jengta, erah tokdi heh ih Rangteenook ni nyootsoot rumta. Eno heh jootkhak saapoot ah maangchang ang kano, o ih uh tajokhakta. ");
INSERT INTO tvt_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisu ih neng loong asuh we liirumta, <<Ngah dokkhoom ih ang; sen ih ngah jamboi ehe, eno sen loong ah rangdah nah ti an. Ngah wanglang adoh sen tami wangkan.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Erah raangtaan ih Jehudi ngoong awang loong ah ih liita, <<Jisu ih liiha heh wangla adoh seng tami wangke. Heh teeteewah tek haat tiit tambaat ha?>> ");
INSERT INTO tvt_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisu ih ngaakbaat rumta, <<Sen loong ah arah mongrep khui nawa, eno ngah ah rangkhoh nawa raahang rah. Sen loong arah mongrep nawa, enoothong ngah arah mongrep nawa tah angkang. ");
INSERT INTO tvt_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Erah raangtaan ih baatrum taha sen loong ah sen rangdah nah matti an. Sen loong ah ih ‘Ngah liiha ah Ngah,’” ah lahanpi kanbah sen rangdah nah matti an. ");
INSERT INTO tvt_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","<<An o ah?>> Neng ih Jisu suh cheng rumta. Jisu ih ngaakbaat rumta, <<Phangbaat tang dowa ih tiim baat rumhala erah ju. ");
INSERT INTO tvt_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Sen suh ngah ih li theng rapne je ah, dut haat etheng uh eje. Enoothong ngah o ih daapkaat halang, heh juuba ami ah, eno heh jiin nawa tiim chaat hang erah juuba mongrep dowa mina loong asuh baat hang.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisu ih Hewah tiit neng damdi roongwaanta ah tajat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Erah raangtaan ih neng suh liita, “Mina Sah ah choomjoh andoh jat an, ‘Ngah liiha ah Ngah’ eno sen ih erah doh jat an nga chaan nawa ih tiim uh tare kang, seng Wah ih tiimjeng baat halang erah ba jeng lang. ");
INSERT INTO tvt_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Eno ngah o ih daapkaat halang heh ah nga damdi; nga luulu heh ih tathiinhaat rang, tiimnge liidi ngah ih saarookwet heh tenroon theng reelang.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jisu erah jengta ah japchaat rum ano miloong ah ih hanpi erumta. ");
INSERT INTO tvt_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Eno Jisu ih heh suh hanpiite loong asuh baat rumta, <<Nga ih nyoot rumhala ah kap anbah, sen loong ah amiisak nga liphante ang an; ");
INSERT INTO tvt_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","sen loong ah ih ami tiit ah ejat ete, eno amiisak rah ih sen loong ah doksiit ehan.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","<<Seng loong abah Abraham sutom,” neng loong ah ih ngaakbaat rumta, <<eno seng loong ah mabah uh o dah uh tataat angke. Eno sen loong ah doksiit ehan ngeh ih jenglu ah tiimjih suh liihu?>> ");
INSERT INTO tvt_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisu ih neng loong asuh baat rumta, <<ngah ih sen loong asuh amiisak ih baat rumhala: O mina rangdah reeraangla erah mih ah rangdah suh heh dah ang ah. ");
INSERT INTO tvt_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Dah ah changtom nah roitang raang ih tah angka, enoothong heh sah ah ba roitang raang ih ang ah. ");
INSERT INTO tvt_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hesah rah ih maama pongwan toom ang ah ngeh li abah amiimiisak sen loong ah maama pongwan ejen ang ethuk han. ");
INSERT INTO tvt_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ngah ih jat ih rumhala sen loong ah Abraham sutoom. Rah bah uh sen ih nga tek haat chung han, tiimnge liidi ngah ih nyoot rumhala ah sen ih tabaam kap kan. ");
INSERT INTO tvt_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Seng Wah ih tiim noisok halang erah baat rumhala, enoothong sen suh sen wah ih marah baat halan ah re lan.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Neng ih ngaakbaat rumta, <<Seng loong wah ah bah Abraham.>> Jisu ih ngaakli rumta, <<Sen loong ah Abraham suh asah angtan bah,” <<sen loong ah heh reeta likhiik ih reetheng; tan. ");
INSERT INTO tvt_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngah ih bah seng Rangte jiin nawa chaat hang amiisak tiit ah ba baat hang, erabah uh sen loong ah ih nga tek haat chunghan. Abraham bah amah tareeta! ");
INSERT INTO tvt_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Sen bah sen wah mamah reeraangta erah likhiik ih re lan.>> <<Rangte heteewah luulu bah seng loong Wah,” miloong ah ih ngaakli rumta, <<eno seng loong ah heh sah mi.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisu ih baat rumta, <<Rangte ah sen loong Wah angta bah ngah enook etheng tahe, tiimnge liidi ngah Rangte taangnawa ra halang. Nga chaan nawa ih ngah tara tahang, ngah bah heh ih daapkaat tahang. ");
INSERT INTO tvt_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ngah ih tiimbaat rumhala erah mamah lajat ehan? Erah langla sen ih nga tiitkhaap ah lanook chaat thoidi angla. ");
INSERT INTO tvt_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sen loong abah sen wah Hakhoh juubaan suh asah, eno sen loong ah sen wah tenthun jun di reeraang lan. Ephang dowa ih dook heh mitek haatte eno amiitiit ah mabah uh takapka, tiimnge liidi heh jiinni amiitiit ah amuh. Heh ih tiit hu baat ha langla, heh banlam mootkaat, tiimnge liidi heh ah ju ehuh eleek thoon nyia ehuh eleek thoontang waroop ah ju heh. ");
INSERT INTO tvt_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Enoothong ngah ih amiitiit ah baat rumhala, erah thoidi sen ih tahanpi ri. ");
INSERT INTO tvt_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sen loong dung dowa ih ngah rangdah mih ngeh ih o ih jen noisok an? Ngah ih amiitiit ah baat rumhala bah, mamah lahanpi ehali? ");
INSERT INTO tvt_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","O Rangte reenawa ra hala heh ih Rangte jengkhaap ah boichaat ih ah. Enoothong, sen loong ah Rangte reenawa lah ang thoidi, taboichaat kan ang ah.” ");
INSERT INTO tvt_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Neng loong ah ih Jisu suh chengta, <<Seng ih liihi an chiithih laakhah pan Samariate, epunjeng tam eli?>> ");
INSERT INTO tvt_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","<<Ngah jiinni chiithih laakhah tajeeka, Jisu ih ngaakbaat rumta, <<Ngah ih seng Wah choomjoh hang, enoothong sen ih ngah tachoom jori. ");
INSERT INTO tvt_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nga rangka ah nga raang ih tajam kang. Enoothong erah rangka jamte ah wahoh eje eno heh ih nga mendoh dande ah. ");
INSERT INTO tvt_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ngah ih ami baat rumhala; ngah ih nyootsoot hang ah o minah ih kap ah erabah mabah uh tatiika.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jehudi loong ah ih Jisu suh li rumta, <<Seng ih jat ehi an chiithih laakhah pan! Abraham tek eta, Khowah loong uh tek eta, erabah uh an ih liihu an ih nyootsoot hu boichaatte ah mabah uh tatiika. ");
INSERT INTO tvt_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Seng loong wah Abraham bah tek eta; ngah Abraham nang ih elong ngeh ih nih li hu, emah tam thun hu? Eno khowah loong uh tek eta. Anteewah suh tiimjih samthun hu?>> ");
INSERT INTO tvt_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisu ih ngaakbaat rumta, <<Ngah ih nga teewah mok choomjotang bah, erah choomchotang ah thaangmuh ang thengta. Nga choomjootte wasiit abah seng Wah—sen ih Rangte ngeh li han rah ah. ");
INSERT INTO tvt_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Sen ih mabah uh tathaak jatkan, ngah ih ba jat hang. Ngah ih tajatkang ngeh mok liitang bah sen likhiik ehuh eleek angtheng tang. Enoothong ngah ih jat ih angno, heh jengkhaap ah kap hang. ");
INSERT INTO tvt_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Sen loong wah Abraham bah nga kaat saapoot ah japtup suh eroon eta; eno heh ih japtup eta nyia eroon eta.>> ");
INSERT INTO tvt_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Neng ih Jisu suh li rumta, <<an amadi paangrook bangnga bot maang ang ko—eno Abraham japtup eto oh? ");
INSERT INTO tvt_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","“Ngah ih amiisak baat rumhala,” Jisu ih ngaakbaat rumta, “Abraham maang potsom di dook, ‘Ngah eje Angtang.” ");
INSERT INTO tvt_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Eno erah li kano heh patsuh jong toonpi rumta, enoothong Jisu Rangteenook dowa hotsoon eta. ");
INSERT INTO tvt_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisu tumkhoom ih adi, mih wasiit edook ih dongtup arah japtupta. ");
INSERT INTO tvt_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Heliphante loong ah ih cheng rumta, <<Nyootte, o rangdah thoidi arah mih ah edook eh dongtupta? Heh teewah tam henuwah rangdah thoidi dongta?>> ");
INSERT INTO tvt_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisu ih ngaakbaat rumta, <<Heh mikdook ah heteewah rangdah nyia heh nuwah rangdah thoidi tah angka. Heh mikdookla abah Rangte chaan ah heh jun ih noisok suh ba angta. ");
INSERT INTO tvt_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Rang mathan ih wu ah nga daapkaatte wah mootkaat ah sen loong ah ih moot etheng jaatjaat ang ah; rangphe thok taha noobah o uh tami mokaka. ");
INSERT INTO tvt_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ngah mongrep nah tong pootdoh, mongrep raang ih ngah weephaak.>> ");
INSERT INTO tvt_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Erah jengta lidi, Jisu ih hah dowa paak ah toon ano heh took ih phota; eno edook mih adi hut, ");
INSERT INTO tvt_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","eno Jisu ih baatta, <<Kah uh Siloom juutum adoh an the ah metkaat uh.>> (Siloom ah <<ekaatthuk<< suh liita.) Dookwah rah ih heh the ah metkaat kano heh mih ah dongsingta eno ngaakwangta. ");
INSERT INTO tvt_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hekhung hetok jaatang nyia kunma warah japtupte loong ah chengmui rumta, <<A mih ah bitthaangte ah tanih angka?>> ");
INSERT INTO tvt_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mararah ih liita, <<Erah mih ah ju,” rukho loong ah ih liita, <<Heh tah angka; heh likhiik.>> Erah thoidi heteewah ih baat rumta, <<Ngah laangbo aleh.>> ");
INSERT INTO tvt_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","<<Amadi an ih mamah mi tup hu leh?>> Miloong ah ih cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Heh ih ngaakbaat rumta, <<Mih wasiit Jisu ngeh angta, eno paak ah seemphoh ano nga mik ni hut tahang, heh ih baat tahang Siloom juutum adoh kah uno an the ah metkaat uh. Eno kah angno nga the met damdam ih dongtup tang.>> ");
INSERT INTO tvt_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","<<Heh mani ah leh?>> Miloong ah ih cheng rumta. <<Tajatkang,” edook ah ih ngaakbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Erah lih adi miloong ah ih edook angta wah rah Pharisi loong taang ni siitkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisu ih paak ah hut ano dookwah deesiitta ja Jehudi naangtongsa angta. ");
INSERT INTO tvt_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Heh mih ah mamah mi siingta erah Pharisi loong ah ih edook asuh we cheng rumta. Heh ih ngaakbaat rumta, <<Nga mik ni paak amasah hut tahang; Ngaathe ngaakhoh met kangno, amadi tup ehang.>> ");
INSERT INTO tvt_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pharisi loong marah marah ih liita, <<A reeta mih abah Rangte re nawa bah tah angka, heh ih Jehudi Naangtongsa hootthe banlam ah takapka.>> Enoothong, rukho loong ah ih liita, <<Rangdah mina ih a likhiik paatjaajih mamah mi re ah?>> Eno neng laktung ni daan jengmui rumta. ");
INSERT INTO tvt_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Erah raangtaan ih Pharisi loong ah ih erah mih asuh jaasiit we dopcheng rumta, <<an ih liihu heh ih an mik edook angtu ah singsiit taho—ese ju, enoobah an ih heh suh o ngeh ih liihu?>> Heh ih ngaakbaatta, heh ah <<khowah.>> ");
INSERT INTO tvt_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Enoothong Jehudi ngoong awang loong ah ih heh edook ang arah amadi etup we eha ngeh ih hanpi suh tanook rumta, neng ih henuwah ah poon ano ");
INSERT INTO tvt_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","amah maang chengcheng ah, <<Arah sen sah tam ah? Sen ih li han heh edook angta; enoobah, amadi heh ih mamah mi tup ha?>> ");
INSERT INTO tvt_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Heh nuwah ih ngaakbaat rumta, <<Seng ih jat ih hi arah seng sah, nyia edook eh dongtup arah ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Enoothong seng ih tajatke amadi heh ih mamah mi tup ha, nyia edook ang arah o ih deesiitta. Heheh suh cheng anba; heh mihak tanih angka, heh teewah ih miibaat laang ejan!>> ");
INSERT INTO tvt_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Erah langla, henuwah ah Jehudi ngoong awang loong raacho ih jeng rumta, tiimnge liidi jaakhoni kakham rumta o ih Kristo ngeh ih li ano hanpi ah erah mih ah Jehudi rangsoomnok nawa dokphan etheng. ");
INSERT INTO tvt_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Erah thoidi henuwah ih li rumta, <<Heh mihak tanih angka; heh suh cheng anba ngeh ah!>> ");
INSERT INTO tvt_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Erah liidi neng ih heh nuh mong nawa edook eh tupta warah we ngaakpoon rumta, eno li rumta, <<Rangte ngathong nah thoomhoon uno amiitiit ah baat uh! Seng ih jat edi arah an deesiitte wah rah rangdah mina.>> ");
INSERT INTO tvt_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","<<Ngah ih tajatkang heh ah rangdah mina elang tam tah lang koja,>> edook wah rah ih ngaakbaatta. <<Ngah ih jaatsiit baajat ang: Ngah edook angtang ah amadi dongtup ehang.>> ");
INSERT INTO tvt_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","<<Heh ih an tiimjih taho?>> neng ih cheng rumta. <<An edook ah heh ih mamah mi deesiit taho?>> ");
INSERT INTO tvt_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","<<Ngah ih jaakhoni dook jen baat ih rum taha,” heh ih ngaakli rumta, <<eno sen ih tah boichaat tan. Sen ih tiim esuh we bootchaat suh li han? Sen uh, heliphante angsuh enook nih lan?>> ");
INSERT INTO tvt_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Neng ih thaangju kaanse lam ih li rumta, <<an baalek heliphante angkoju; seng bah Moses liphante. ");
INSERT INTO tvt_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Seng ih bah Rangte ih Moses suh baatta ah ba jat ih, enoothong, Jisu ah manawa ra taha erah botseh tajatke!>> ");
INSERT INTO tvt_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Eno edook angta deeta warah ih li rumta, <<Erabah epaatja etheng laang angla nih! Nga mikdook botseh deesiit tahang ah, heh manawa ra taha ah tawe jatkan nih! ");
INSERT INTO tvt_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Seng ih jaat ehi Rangte ih rangdah mina loong jeng ah taboichaat ka; heh ih heh jeng chaatchaat ih reete nyia heh choopjootte mina jeng ah ba chaat ah. ");
INSERT INTO tvt_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hah phangsongta dowa ih edook eh dongtup arah kaasiit arah mongrep ni tathaak chaatke. ");
INSERT INTO tvt_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Erah mih ah Rangte jiin nawa lara taha bah, tiim uh tala jenre thengtaaja.>> ");
INSERT INTO tvt_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Neng ih ngaakbaatta, <<Tup taho dowa ih an rangdah mong ni hak uno—an ih seng suh nyoot kachung hu?>> Eno neng ih Jehudi rangsoomnok nawa dokphan rumta. ");
INSERT INTO tvt_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisu ih erah japchaatta adoh, dookwah rah japtup ano chengta, <<An ih Mina Sah ah hanpi tam ih hu?>> ");
INSERT INTO tvt_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Erah wah rah ih ngaakbaatta, <<Chuupha, baat weehang heh ah o angla, enooba ngah ih heh jen hanpi ang!>> ");
INSERT INTO tvt_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisu ih ngaak baatta, <<An ih heh jen japtup etu, amadi marah an damdi waan hala erah warah ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Erah warah ih liita, <<Ngah ih hanpi ehang Teesu!>> Eno Jisu ngathong ni heh lakuh ni chooktongta. ");
INSERT INTO tvt_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisu ih liita, <<Ngah arah mongrep ni dande esuh ra halang, edook ah ih tup toom ih ah nyia mikka ah edook toom ehoon ah ngeh ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jisu reeni Pharisite mararah eje ang rumta, erah japchaat rum ano Jisu suh cheng rumta, <<Seng suh uh edook miimi tamli hali?>> ");
INSERT INTO tvt_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisu ih ngaakbaat rumta, <<Sen loong ah edook lek angtan bah, sen loong tamoong thengtan; enoothong sen ih tup ehi chaang thoidi amadi uh sen emoong elan.>> ");
INSERT INTO tvt_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisu ih liita, <<Ngah ih amiisak baat rumhala; o mina saap paakaawan lam ih lanop thang eh, lamhoh lam ih duuwangla abah, ehuh nyia meh putte ang ah. ");
INSERT INTO tvt_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","O mina saap paakaawan lam ih nopla erabah Saapriimte. ");
INSERT INTO tvt_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Paakaalu sakte ih heh suh kaalu ah daap koha; saap ah ih heh men poon kano heh root ah chaat eha, eno riimkaatla. ");
INSERT INTO tvt_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Heh saap loong ah dokpoon ano, heh ngakhoh kala, eno heh saap loong ah heh root ah danjat rum ano helih helih ih karumla. ");
INSERT INTO tvt_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Saap loong ah ih wahoh lih taphan joka, erah nang ebah heh root ah lajatjoh rum kaano, erah mih reedowa moong soon erum ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisu ih a tiitthaak ah baat rumta, enoothong tim liiha ngeh ih neng loong ah ih tajat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Erah thoidi Jisu ih we liita, <<Ngah ih amiisak baatrum hala; saap raangtaan ih paakaawan ah ngah. ");
INSERT INTO tvt_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nga ngani o mathan ra taha abah loongtang ehuh nyia mih putte, enoothong saap loong ah ih neng jeng ah taboichaatta. ");
INSERT INTO tvt_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ngah juuba paakaawan ah. O mina nga jun ih nopwang ha erah ba pui ah; heh weewang weekah lengkhoom ano naam ah chophak ah. ");
INSERT INTO tvt_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ehuh abah hot hot suh, tek haat esuh nyia thet haat esuh ba wang hala. Enoothong ngah bah sen roidong toom choh an ngeh ih ra halang—sen roidong doh jirep ah chosuh ah. ");
INSERT INTO tvt_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","<<Saapriimte ese ah ngah, o ih saap loong raang ih roidong jen kotte warah ah. ");
INSERT INTO tvt_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Lakniikte mina, o Saapriimte lah angka abah nyia heh saap laje kokaano, so wangha di moongsoon ela; eno saap loong ah so ih kum kano tiisoon ela. ");
INSERT INTO tvt_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Lakniikte abah saap changte tah angka erah thoidi saap asuh lasootsaam thang ih moongsoonla. ");
INSERT INTO tvt_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Saapriimte ese ah ngah. Seng Wah ih jat ih halang ngah ih seng Wah ah jat ehang, erah likhiik nga saap loong ah ngah ih jat ehang, neng ih uh jat ih halang. Eno neng raang ih nga roidong jen kot ih ang. ");
INSERT INTO tvt_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Arah saapnok adi lajeeka ah nga saap ehoh ni uh eje. Neng loong ah uh ngah ih adoh thoksiit etheng; neng loong ah ih nga root ah jat ih ah, eno Saapriimte wasiit damdoh eroom ih hoon ah. ");
INSERT INTO tvt_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","<<Seng Wah ih ngah enook ih halang, tiimnge liidi nga roidong kot suh tacho kang, ngah ih roidong we ngaak chosuh ah. ");
INSERT INTO tvt_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nga roidong ah nga jiin nawa o ih uh tajen ngeerang. Erah Nga thunghoon ih kohang. Ngah ih jen kot ih ang, adoleh jen ngaak thaang ih ang. Seng Wah ih erah reetheng ngeh ih baat halang.>> ");
INSERT INTO tvt_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Erah jengkhaap ah thoidi Jehudi loong ah neng jaachi ni we daanmui rumta. ");
INSERT INTO tvt_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Neng loong laktung ni ehan ko ah ih liita, <<Heh damdi chiithih laakhah eje! Heh emok angla! Heh jeng ah tiim esuh boichaat han?>> ");
INSERT INTO tvt_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Enoothong wahoh loong ah ih liita, <<Hakhoh juubaan pan mina emah tami roongwaan ka! Hakhoh juubaan ih edook ah mamah ma mi kaasiit ah?>> ");
INSERT INTO tvt_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalem ni, Rangteenook Rongraak Kuwaang ah hahook di kuh rumta. ");
INSERT INTO tvt_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Rangteenook adi Solomon Bulaang ngeh ih men rumta adi Jisu lengkhoomta, ");
INSERT INTO tvt_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","adoh Jehudi loong ah kookrak ih khoonchap rum ano cheng rumta, <<seng loong ah amah nih moktong thuk he? Sen suh amiitiit ah baat he: Kristo ah an tam anglu?>> ");
INSERT INTO tvt_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisu ih ngaakbaat rumta, <<Ngah ih sen suh jen baat ih rum taha, erabah uh sen ih tahanpi ri. Seng Wah chaan nawa ih tiimjaat reelang erah ih jat ih thuk halan Ngah o ah; ");
INSERT INTO tvt_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","erabah uh sen loong ah nga saap lah ang thoidi tahanpi ri. ");
INSERT INTO tvt_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nga saap ih nga root ah chaat eha; neng loong ah ngah ih jat ehang, eno neng ih nga liphan rum halang. ");
INSERT INTO tvt_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Neng loong asuh ngah ih lathoon roidong kohang, eno neng mabah uh tatiika ang ah. Nga jiin nawa neng loong ah o ih uh tajen ngeerang. ");
INSERT INTO tvt_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Seng Wah ih tiim kohalang ah thoontang nang ih elongthoon eno seng Wah lak nawa o ih uh tajen ngeeka. ");
INSERT INTO tvt_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Sek Soowah ah esiit.>> ");
INSERT INTO tvt_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Erah jeng kano miloong ah ih pat esuh jong taatwe toon rumta. ");
INSERT INTO tvt_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisu ih li rumta, <<Seng Wah ih reethuk halang ah sen loong pandi mootse kaatse ah mokalang; erah thoidi jong ih patsuh tamli hali?>> ");
INSERT INTO tvt_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Neng loong ah ih ngaakli rumta, <<an mootse kaatse reethoi di jong ih patsuh tali ke, enoothong an ih Rangte thaangju hu, an mina tanih angko an teewah suh Rangte ngeh ih thun hu!>> ");
INSERT INTO tvt_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisu ih ngaakbaat rumta, <<Sen hootthe ni Rangte ih emah liiha, ‘sen loong ah rangte.’ ");
INSERT INTO tvt_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Seng ih jat ehi leedap ni tiimjih liiha erah saarookwet raang ih amiisak; eno Rangte ih erah mina loong asuh rangte ngeh liita, erah mina loong asuh heh tiitkhaap ah kota. ");
INSERT INTO tvt_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ngah bah, seng Wah ih danje hang no arah mongrep adi kaat thuk tahang. Eno, ngah ih Rangte Sah li kangno, Rangte thaangju hu ngeh sen ih mamah mi li he? ");
INSERT INTO tvt_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Eno bah nak hanpi he, seng Wah ih jamha jun ih lare kangbah ah. ");
INSERT INTO tvt_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngah lahanpi ri bah uh, ngah reelang loong ah baalah hanpi an, jaasiitdoh sen loong ah ih jat toom ih an suh ah, seng Wah ah nga damdi adoleh ngah seng Wah damdi ngeh ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Miloong ah ih Jisu jootkhak suh taatwe chung rumta, enoothong neng lak nawa doksoon ekata. ");
INSERT INTO tvt_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Joon ih juutem rumta Jordan ju lam ih we ngaak daansoon ano, erah ni tong kata. ");
INSERT INTO tvt_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Miloong ah heh reeni hantek thok rum taha. Neng loong ah ih liita, <<Joon ih bah paatjaajih tareeta, <<enoothong heh ih a mih tiit baatta ah amiisak ih baatta.>> ");
INSERT INTO tvt_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Eno erah ni mina hantek ih hanpi rumta. ");
INSERT INTO tvt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Lajaras ngeh ih mih wasiit angta ah sat eta. Heh Bithani ni tongte angta, Bithani ah Meeri nyia heh no Martha tongta samthung angta. ( ");
INSERT INTO tvt_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Teesu lah ni phontum ih lok ano heh khoroon ih hut haatte ah Meeri angta; eno khoisatte Lajaras ah heh no angta.) ");
INSERT INTO tvt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Heh jongsah anyi ih Jisu suh maatbaat nyuuta: <<Teesu an joonte abah sat ela.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisu ih erah chaat ano, liita, <<Lajaras khoisat ah tek esuh bah tabaam angka; erabah Rangte rangka suh ba angla, eno Rangte Sah rangka lampo ah erah ang ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Martha nyi soonah nyia nengnyi no Lajaras ah Jisu moongnook angjom rumta. ");
INSERT INTO tvt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lajaras khoisat ah chaat abah uh, heh tongta hah adi saanyi boot daktong thiinta ");
INSERT INTO tvt_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Eno Jisu ih heliphante loong asuh liita, <<Judia nah ngaakwang ih.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","<<Nyootte,>> heliphante loong ih ngaakbaat rumta, <<Erah hah adi Jehudi loong ih jong ih taatpat taho ah halowah tah angla; eno erah ni ngaakkaat chung hu oh?>> ");
INSERT INTO tvt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisu ih ngaakbaat rumta, <<Rangwuusiit di asih koonta nyi tanih angka? Erah raang ih rangwu di khoomte ah tabanbotka, tiimnge liidi heh ih mongrep dowa weephaak ah tup eha. ");
INSERT INTO tvt_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Enoothong, rangphe doh weephaak mudoh khoom abah banbot ih ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisu erah jeng ano jangbaatkaat rumta, <<Seng joonte Lajaras bah mokjup ela, eno ngah kah angno saatsiit ih kah ang.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Heliphante loong ah ih ngaakli rumta, <<Teesu, heh mokjup ela bah, ede ih ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisu ih Lajaras jup ela liita ah tek asuh liita, enoothong neng ih mokjup tiit baat ha ngeh ih mok samthun rumta. ");
INSERT INTO tvt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Erah raangtaan ih Jisu ih saasa ih dokbaat rumta, Lajaras ah tek ela, ");
INSERT INTO tvt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","enoothong ngah mudi emah angla thoidi sen loong raang ih eroon elang, erah thoidoh ba sen ih kok hanpi an. Heh jiinnah wang ih.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas (khaangpeh ngeh ih men rumta) ih Jisu liphante wahoh loong asuh liita, <<Nyootte damdoh seng loong ah wakwang ih, seng loong ah uh heh damdoh toom roongti wang ih!>> ");
INSERT INTO tvt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisu thokta adi, Lajaras ah sa baji ngani dook bengkaat arah japtup wangta. ");
INSERT INTO tvt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerusalem ah phaloong jom nang ih haniik angta, ");
INSERT INTO tvt_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Martha nyia Meeri no tek kano Jehudi nok hah loong ah nengnyi huudiip ra rumtaha. ");
INSERT INTO tvt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martha ih Jisu wang ah japchaat ano heh damdi chomui suh dokkhoom kata, enoothong Meeri ah nok ni tangtongta. ");
INSERT INTO tvt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha ih Jisu suh liita, <<Teesu, an aanah angtu bah, nga no ah tatek thengta! ");
INSERT INTO tvt_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Enoothong ngah ih jat ehang, an ih amadoh Rangte jiin nawa tiim suh uh erah kot eho.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisu ih baatta, <<An no tek nawa we ngaaksaat ih ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha we ngaakjengta, <<Ngah ih jaat ehang<< saathoon doh <<heh ngaaksaat ih ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisu ih heh suh baatta, <<Ngah tek nawa ngaaksaattte nyia roidong, o ih ngah hanpi halang, erah mih ah etek ih abah uh ething ang ah; ");
INSERT INTO tvt_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","eno o ih ngah hanpi hangno thing tongla erah mabah uh tatiika. Arah tiit ah hanpi tam ih hu?>> ");
INSERT INTO tvt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","<<En Teesu!>> Martha ih ngaakbaatta. <<Ngah ih hanpi ehala, arah mongrep adi kaatte, Rangte Sah Kristo ah anju.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maratha ih erah baat lih ni, heh nah Meeri jiinni hotsu ih ngaakwang ano poonwangta, <<Nyootte ah bah ani,” eno heh ih <<an jam halu.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Meeri ih erah chaat ano, Jisu taang ni chomui suh seek ih saatsoon kata. ");
INSERT INTO tvt_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Jisu erah hadaang adi maangthok angta, maradi Maratha chomui kata erah di thoktong roh eta.) ");
INSERT INTO tvt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Meeri ah seek ih saatsoon kano, henok ni heh huudiipte khoontongta Jehudi loong ah ih mokthun rumta mangbeng ni hu kala ngeh ah, eno helilih ih phanjoh karumta. ");
INSERT INTO tvt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meeri ah Jisu reeni thok ano, heh laan japtup roh eta, eno heh lakuh ni chooktong kata. Meeri ih liita, <<Teesu<< <<an anah angtu bah nga no ah tatek thengta!>> ");
INSERT INTO tvt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisu ih Meeri nyia heh damdi roongkaatte, miloong hu ah tup ano, heh rapne ih thungthita. ");
INSERT INTO tvt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jisu ih cheng rumta, <<Heh mani bengkaat tan?>> Miloong ah ih baat rumta, <<Teesu, Sok ra thaak ho.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisu ah ehu eta. ");
INSERT INTO tvt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Miloong ah ih li rumta, <<Taat sok thaak an, heh ih tiimthan minchanha!>> ");
INSERT INTO tvt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Enoothong Neng dung dowa mararah ih liita, <<Heh ih edook nep tanih kaasiitta, tatam angka? Lajaras ah tek nawa taba jentang ka?>> ");
INSERT INTO tvt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisu we thungthih ano mangbeng ko ih kata, mangbenglu ah jonglo ih kepta. ");
INSERT INTO tvt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisu ih baat rumta, <<Jong ah dokloong an!>> Martha, etek eta jongsah rah ih liita, <<Nam bah nam ebaat ah Teesu. Erah bengta dowa ih sa baji dook angla!>> ");
INSERT INTO tvt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Eno Jisu ih Martha suh liita, <<hanpi ih ubah Rangte chaan aphaan ah tup ih uh ngeh ih tanih baat taha?>> ");
INSERT INTO tvt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Neng loong ah ih jong ah dokloong rumta. Jisu rangko ih toonsokwan ano jengta, <<Ewah, nga rangsoom ah chaat raangtaan ih lakookmi li hala. ");
INSERT INTO tvt_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ngah ih jaat ehang an ih saarookwet ih boichaat halang, enoothong arah liihang abah, aradi lomkhoon hala miloong ah ih, an ih daapkaat tahang ngeh ih toom hanpi rumhang.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Erah jengta lih adi, Jisu ih erongwah ih riipoonta, <<Lajaras, dokkhoom ho!>> ");
INSERT INTO tvt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Eno dokkhoom taha, helak helah mang loop nyuh ih dekchoi nyia hethe hekhoh nyuh ih dek arah, dokkhoom taha. Jisu ih baat rumta, <<Nyuh ah jaahaat an,” eno <<Toomwang ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Meeri taang ni dongwangte mih hantek ih, Jisu tiimjih reeraangta ah tup rum ano heh ah hanpi ih rumta. ");
INSERT INTO tvt_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Enoothong mararah Pharisi loong jiinni ngaakwang rum ano Jisu reeraangta loong ah baatwan rumta. ");
INSERT INTO tvt_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Erah thoidi Pharisi nok hah nyia romwah phokhoh loong ah Ngoong awang loong damdi chothum rum ano roongwaan rumta, <<Seng ih tiimjih ih?>> Mih paatjaajih reeraangla loong ah sok thaak an! ");
INSERT INTO tvt_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Seng ih emah jaatjaat ih reeraang thuk ebah, warep ih hanpiite angrumla, eno Room nok hah ngoong awang loong ih li ih baat he, eno seng Rangteenook nyia seng deek sengkaan uh thet haat ete ang hali!>> ");
INSERT INTO tvt_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Neng changdi wasiit, heh men ah Kaiphas angta, erah paang adi heh Romwah Phokhothoon angta, eno heh ih li rumta, <<Sen mamah jen ngakthak lan! ");
INSERT INTO tvt_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sen ih tatam samthun kan deek akaan pan ih matnang ih noksong raangtaan ih wasiit rooptiila ah ese ang ah ngeh ah!>> ");
INSERT INTO tvt_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiphas ah hethung nawa ih tajengta, erah paang adi Romwah Phokhothoon ang kano, Jehudi noksong raang ih Jisu roopti ah ngeh ih chiilam laalam ni banjat eta, ");
INSERT INTO tvt_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","eno neng loong raangtaan luulu tah angka, Rangte suh asah mathan phaang jaangta erah loong ah phunsiit saksiit ih khoonsiit suh nep angta. ");
INSERT INTO tvt_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Erah sa dowa ih Jehudi ngoong awang loong ah ih Jisu tek haat suh chung rumta. ");
INSERT INTO tvt_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Erah thoidi Judia ni Jisu wuusa ni tanaan tupkhoomta, eno erah hah dowa doksoon ano, phisaang hah re dowa Ephraim samnuh ni heliphante loong damdi tong kata. ");
INSERT INTO tvt_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Khopi Kuwaang lang nanah ang kano, miloong ah neng hah nawa Jerusalem ni Kuwaang maangdi khojoop karumta. ");
INSERT INTO tvt_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Neng ih Jisu jamsok rumta, eno neng loong ah Rangteenook ni thutthe rum adi, neng neng chengmui rumta, <<Sen ih tiimjih thun han?>> Jisu ah kuwaang adoh tajaatjaat tam wangra?>> ");
INSERT INTO tvt_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Romwah phokhoh nyia Pharisi loong ih baat rumta, o ih Jisu japtup ah, heh ih chobaat etheng, neng ih jootkhak esuh ah. ");
INSERT INTO tvt_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Khopi Kuwaang sa arok ngani, Jisu Bithani ni kata, erah hah ah heh ih tek nawa ngaaksaat siitta Lajaras hadaang angta. ");
INSERT INTO tvt_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Neng loong ah ih Jisu raangtaan ih rangja phaksat songwaang rumta, erah di Martha ih roong sokboita; neng dung dowa Lajaras ah teebun reeni Jisu damdi roongtongta. ");
INSERT INTO tvt_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Eno Meeri ih etumjaat nard banglak nawa hoon arah thuuthom thaangchaan thaang phontum ah piiwan haano Jisu lah ni lokwan taha, eno heh khoroon ih hut haatta. Phontum ah nokmong ni tummangmang ih tumwangta. ");
INSERT INTO tvt_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Eno heliphante dung dowa wasiit, Judas Iskirot-Jisu mokwaante ah ih liita. ");
INSERT INTO tvt_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","<<Erah than thaangchaan phontum ah ngunkholok chaajom doh sang ano changthih loong asuh ngun ah mamah lapheekoh eha?>> ");
INSERT INTO tvt_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Heh erah jengta ah changthih minchan ih tajengta, heh ehuh ang ah angno jengta. Ngunkhaak ah heh ih huita, eno erah dowa heh ih kamaakta. ");
INSERT INTO tvt_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Eno Jisu ih liita, <<Meeri ah nak paklak an heh luulu thiinhaat an! Phontum ah nga mangbeng raang ih toomthiin ah. ");
INSERT INTO tvt_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Changthih abah saarookwet ih sen damdoh ang ha, enoothong ngah ah saarookwet sen damdoh tatongrang.>> ");
INSERT INTO tvt_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mih hantek ih Jisu Bithani ni ngeh japchaat rumta, erah thoidi Jisu jamboi luulu la angthang ih, Jisu ih tek nawa ngaakthingta Lajaras nep tup suh wang rumta. ");
INSERT INTO tvt_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Romwah phokhoh loong ah ih Lajaras nep tek haat suh chung rumta, ");
INSERT INTO tvt_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lajaras ngaaksaat thoidi Jehudi loong ah ih ngoong awang jeng laboichaat thang ih Jisu reeni wangleh heh ah hanpi rumta. ");
INSERT INTO tvt_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Erah saalih adi Khopi Kuwaang ni wangte miloong ah ih Jisu Jerusalem ni wang ah japchaat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Erah thoidi miloong ah paam bangmong ah pi rum ano chomui karumta, eno riirumta, <<Rangte rangphoong an! O Teesu mendi ra hala heh suh Rangte ih romse tamkoh ah! Rangte ih Ijirel Luuwang suh romseetam koh ah!>> ");
INSERT INTO tvt_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Rangteele ni raangha likhiik, Jisu ih moktoh ah japtup ano heh sakkhoh ni duutong ano kata, ");
INSERT INTO tvt_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","<<Jaion samnuthung dowa mina loong ah nakcho an! Sen Luuwang arah ra hala, moktoh khoni ra hala.>> ");
INSERT INTO tvt_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Erah tokdi heliphante loong ah ih tiim suh liiha ngeh ih tajat rumta; enoothong Jisu ah dong rangka kano ba; samthun rumta rangteele ni liiha ah heh suh liiha eno neng loong ah heh raangtaan mokah rumla ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mang beng nawa Jisu ih Lajaras tekchoi dokpoon ano ngaakthing thukta tupte miloong ah ih noongrep ni tumbaat kaat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Paatjaajih reeraang kano miloong ah chomui wang rumta. ");
INSERT INTO tvt_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pharisi loong ah nengneng laktung di roongwaan rumta, <<sok thaak an, seng ih tiim uh tami eke! Arah mongrep dowa mina loong ah ih helih tola phan rumha!>> ");
INSERT INTO tvt_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kuwaang mong adi Jerusalem ni rangsoom wangrum ta dung adi Grik nok hah mararah eje angta. ");
INSERT INTO tvt_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Neng loong ah Philip jiinni wang rumta (heh Galili nawa Bethsaida nok hah angta), neng loong ah ih heh suh li rumta, <<Chuupha, seng Jisu tup suh liihi.>> ");
INSERT INTO tvt_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip ih Andriu suh baatwan ano nengnyi wanyiinyi Jisu suh baatwan nyuuta. ");
INSERT INTO tvt_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Eno Jisu ih nengnyi suh ngaakbaat nyuuta, <<Mina Sah rangka saapoot ah amadi thok ehala. ");
INSERT INTO tvt_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ngah ih amiisak baat rumhala; raanteh ah hah nah wen ano latek thukka bah raanteh esiit laklak ang ah. Raanteh ah tek ih taano ba, hantektek ih dong tiik ah. ");
INSERT INTO tvt_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","O mina ih heh teewah roidong asuh mongmah ah erah mina ah ih mat haat ih ah; arah mongrep adoh o mina ih heh roidong ah lathunka mina rah ih mabah uh lathoonka roidong ah ban thiinha. ");
INSERT INTO tvt_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","O mina ih nga mootkaat suh enook e ah, heh nga lih jaatjaat phanjih, eno ba nga laksuh ah ngah maadoh angang heh uh erah doh roong angha. Eno nga mootkaat ah o kah ah erah seng Wah ih soomtu ih ah. ");
INSERT INTO tvt_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","<<Amadi ngah mong rapne saamlang—eno ngah ih tiimjih li ang? Ngah ih emah tamli ang, ‘Ewah, nga chamchoh saapoot ah nakthok thukwe ho? Enoothong ngah erah raangtaan ih ra tahang—chamnaang saapoot ah chosuh ah. ");
INSERT INTO tvt_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ewah, an men rangkajih ju toom ang ah!>> Eno rang ni jeng arah chaatta, <<Ngah ih heh rangka ah thoksiit halang, eno bolam uh emamah ih boot rangka thuk ang.>> ");
INSERT INTO tvt_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Erah di khoonchap rumta miloong ah ih japchaat ih rumta, eno mararah ih liita ranghuula, mararah ih liita, <<Rangsah heh damdi roongwaan la!>> ");
INSERT INTO tvt_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Enoothong Jisu ih baat rumta, <<Erah jengla ah nga raang ih tah angka, erah sen loong raang ih jengla. ");
INSERT INTO tvt_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Amadi, arah mongrep dande saapoot ah thok ehala, arah mongrep pante loong ah datsiit ih ah. ");
INSERT INTO tvt_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Eno, arah hah dowa ngah toonjoh hangdoh loongtang nga reenah thoksiit rumhang.>> ( ");
INSERT INTO tvt_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jisu erah jengta ah heh mamah ih ti ah erah tiit ah baatta.) ");
INSERT INTO tvt_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Miloong ah ih liita, <<Seng Hootthe ih liiha Kristo ah saarootwet raang ih ething tong ah. Eno, sen ih, Mina Sah ah toonjoot jaatjaat ih ah ngeh ih mamah ih miili han?>> Mina Sah rah o ah?” ");
INSERT INTO tvt_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisu ih ngaakbaat rumta, <<Weephaak ah sen loong damdoh chomroe ba boot waktong ha. Erah raangtaan ih, weephaakla tok adoh sen khoom roh ih an laamang nah phokhoom an; tiimnge liidi laamang ni khoomte ih tajatka heh maani kala ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Erah raangtaan ih, weephaak ah hanpi ih an, weephaak mina toom ang an.>> Erah baat rumta lidi, Jisu ah neng loong reenawa doksoon kah ano hutong kata. ");
INSERT INTO tvt_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Miloong ah pandi Jisu ih paatjaajih loong ah taat noisok rum abah uh, tahanpi rumta, ");
INSERT INTO tvt_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","erah raangtaan ih Isaia khowah jengta ah amiisak ih toom ang raaha ngeh ah: <<Teesu, seng ih baat hi tiitkhaap ah o ih hanpi ah? Teesu ih, hechaan hephaan ah o suh noisok ha?>> ");
INSERT INTO tvt_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Eno, neng loong ih tami hanpi rumta, Isaia khowah ih uh erah ah baatta, ");
INSERT INTO tvt_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","<<Rangte ih neng mik dookthuk ah, nengthung nengtak tajang thukka ang ah, tiimnge liidi neng mik ih naktoom tup ah, neng thung ih na toom jat ah ngeh ah, eno nga reenah uh deesiit esuh naktoom wang rumha, Rangte ih liita.>> ");
INSERT INTO tvt_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Erah Isaia jengta, Jisu rangka ah tup ano heh tiit ah baatta. ");
INSERT INTO tvt_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Erabah uh, Jehudi ngoong awang loong ih Jisu ah hanpi erumta, enoothong Pharisi loong ih Jehudi rangsoomnok nawa dokphan raacho ih wuusa ni tanaan waan rumta. ");
INSERT INTO tvt_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Eno neng loong ah ih Rangte ih gu nang ih mina ih gu ah jam rumta. ");
INSERT INTO tvt_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisu ih erongwah ih riibaat rumta, <<O mina ih ngah hanpi rum halang, erah loong ah ih nga luulu tahanpi rumrang enoothong nga daapkaatte rah uh hanpi ih rumha. ");
INSERT INTO tvt_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","O mina ih ngah tup ih halang, ngah daapkaatte ah uh etup eha. ");
INSERT INTO tvt_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ngah arah mongrep adi weephaak likhiik ih ra tahang, nga hanpiite loong ah laamang mong nah naktoom tong rum ah ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","O mina ih nga tiitkhaap ah chaat ano lakapka bah, ngah ih heh tadande kang. Ngah mongrep dande tara rang, puipang esuh ra tahang. ");
INSERT INTO tvt_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Enoothong o mina ih nga jeng lakapka nyia nga tiit ah edaan ih ah, heh dande wahoh wasiit je ah. Ngah jenglang jengkhaap ah ih rangthoon doh heh dande ah! ");
INSERT INTO tvt_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Arah amiisak tiit baat hang, tiimnge liidi nga chaan nawa ih tajeng kang, ngah daapkaatte seng Wah ih emah ih jeng theng ngeh ih baat halang ah ba jenglang. ");
INSERT INTO tvt_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ngah ih jat ehang heh jengdang ah ih lathoon roidong koh ah. Erah raangtaan ih ngah ih tiim liihang, erah seng Wah ih baat halang jeng ah baat hang.>> ");
INSERT INTO tvt_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Erah sa ah Khopui Kuwaang sa rangkhah ang ah liidoh angta. Jisu ih jat eta heh mongrep dowa Hewah reenah toon soonwang suh saapoot ah thok ehala. Jisu ih mongrep dowa heh mina loong ah saarookwet minchan rumta, eno rangkuh maang thoonthoon ih minchan rumta. ");
INSERT INTO tvt_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jisu nyia heliphante loong ih rangja phaaksat sah rumta. Erah di dook Hakhoh juubaan ih Simon Iskariot sah Judas tenthun ni Jisu jootkot suh jen nop ih thukta. ");
INSERT INTO tvt_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisu ih jat eta Hewah ih jirep chaan aphaan ah heh suh koha, eno heh ih jat eta heh Rangte reenawa ra taha eno Rangte jiinnah we ngaakwang ah ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Erah raangtaan phaksat sah rumta teebun dowa Jisu toonchap ano rangkhoni kapta samsong ah khookthiin ano, nyusah ah heh room ni toondekta. ");
INSERT INTO tvt_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Eno joong ah tek adi ke ano heliphante loong lah ah tiihatta eno heh room dowa nyusah rah ih hook hut rumta. ");
INSERT INTO tvt_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jisu ah Simon Pitar reeni kaat kano chengta, <<Teesu, nga lah uh tiihaat nih ehang?>> ");
INSERT INTO tvt_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisu ih ngaakbaatta, <<amadoh ngah ih tiim ehang tajatko, enoothong linah dongjat uh.>> ");
INSERT INTO tvt_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pitar ih liita, <<Tiimtok doh uh nga lah bah nak tiihaat hang!>> Jisu ih ngaak liita, <<Ngah ih an lah ah latiihaat raabah,” <<an nga liphante takah angko.>> ");
INSERT INTO tvt_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Pitar ih ngaakbaatta, <<Teesu, enoobah nga lah luulu nak tiihaat hang! Nga khoh nyia nga lak nep chotchaat hang!>> ");
INSERT INTO tvt_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisu ih liita, <<O mina ih heh sak saachot choi abah esa lakah chot theng, heh lah luulu ba tiihaat theng. Sen thoontang esa—wasiit ah ba.>> ( ");
INSERT INTO tvt_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisu ih heh jootkotte ah jen jat eta; erah thoidi jengta, <<Sen loongtang esa, wasiit ah ba.>>) ");
INSERT INTO tvt_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisu ih neng lah ah jen tiihaat rum ano heh samsong ah we toonsongta eno teebun adi ngaaktong wangta. Jisu ih cheng rumta, <<Ngah ih sen raangtaan ih tiimjih etang jat tam ih tan?>> ");
INSERT INTO tvt_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","<<Sen ih ngasuh nyootte nyia Teesu li hali, punjeng elan, tiimnge liidi ngah emah ju. ");
INSERT INTO tvt_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Sen Teesu nyia Nyootte ang ang bah uh ngah ih sen lah tiihaat rumhala. Erah raangtaan ih sen uh sen lah ah emamah tiihaatmui theng. ");
INSERT INTO tvt_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ngah ih sen loong asuh jengthaak nyootsoot rumhala, seng uh emamah angtheng ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sen loong asuh amiisak tiit ah baat rumhala: Heh Teesu nang ih o dah uh elong tah angka, adoleh tiitkhaap baat kaatte ah heh daapkaat nang ih elong tami angka. ");
INSERT INTO tvt_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Amadi sen ih ami tiit ah jat ehan, emamah ih banreeraang anbah, sen tiimthan tenroon ang an!>> ");
INSERT INTO tvt_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","<<Sen loongtang tiit ngah ih tabaat kang; o danje hang ah ngah ih jat ehang. Enoothong rangteele ni liiha ah thok jaatjaat eha, erah di emah liiha, o mina nga damdoh roong phaksah ha erah mih ah nga siikhaamte ih hoon ah. ");
INSERT INTO tvt_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Erah maang angkaadi sen loong asuh baat rumhala, rangthoon doh emah ang adoh sen ih hanpi ih an ‘Ngah Liiha ah Ngah’. ");
INSERT INTO tvt_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ngah ih amiisak tiit ah baat rumhala; ngah ih daapkaat lang mih ah o ih lambanchoh ah erah nga lambanchoh halang, adoleh o ih nga lam bantho halang erah nga daapkaatte wah lam bantho ha.>> ");
INSERT INTO tvt_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Erah jeng lidi Jisu rapne ih mongsaam ano wuusaani dongjengta, <<Ngah ih amiisak tiit baat rumhala; sen loong dung dowa wasiit ih ngah jokoh he.>> ");
INSERT INTO tvt_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Heliphante loong ah neng neng sokmui rum ano paatti rumta, o suh liiha ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Heliphante dung dowa Jisu mongnook warah Jisu reeni tongta. ");
INSERT INTO tvt_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Pitar ih helak ah moot ano erah wah rah suh chengta, <<Erah o asuh li hali chengthaak uh?>> ");
INSERT INTO tvt_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Eno heliphante ah Jisu reeni tiittong ano chengta, <<Teesu erah o ang weeli?>> ");
INSERT INTO tvt_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisu ih ngaakbaatta, <<Ngah ih baanlo ah khu adoh tem angno koh ang; erah mih ah ang ah.>> Eno Jisu ih baanlo chep ah luptem ano Simon Iskariot sah, Judas suh kota. ");
INSERT INTO tvt_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Baanlo thaang damdam Soitaan ah Judas sak ni noptongta. Eno Jisu ih Judas suh baatta, an tiim reetheng ah kharok ih re uh!>> ");
INSERT INTO tvt_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Teebun ni roongtongte heliphante wahoh loong ah ih o ih uh tajatta Jisu ih heh suh tiim esuh emah baatta ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Heliphante loong ih mok samthun rumta, Judas ah ngun thiinte ang kano Kuwaang raang ih phaksat riikkaat hebaat ha erah lah angka changthih noodek suh kot hebaat ha ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Erah kota baanlo ah thaangpi ano Judas ah doksoon ekata. Erah tokdi rangnak angta. ");
INSERT INTO tvt_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas ah doksoon kaat kano Jisu ih liita, <<Amadi Mina Sah rangka ah dongjat thuk ha, Rangte rangka ah heh jun ih dongjat thuk ha. ");
INSERT INTO tvt_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Eno Rangte rangka ah Hesah jun ih choh abah, Mina Sah heh ih rangka ha ah dongjat thuk ah, eno erah kharok ih choomjoh ah. ");
INSERT INTO tvt_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ngaasuh ngaasah loong, ngah sen damdoh saatang tah roongtong rang. Sen ih ngah jamboi ih he, enoothong Jehudi nok hah ngoong awang loong suh baattang ah likhiik, ‘Ngah maako wanglang erah doh sen tami wangran.’ ");
INSERT INTO tvt_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Eno ngah ih sen suh jengdang ena koh rumhala; sen loong jaachi nah minchanmui etheng. Ngah ih sen loong minchan rumhala ah likhiik sen uh minchanmui etheng. ");
INSERT INTO tvt_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sen jaachi nah minchanmui ih anbah warep ih erah doh jat ah, sen loong ah nga liphante ngeh ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","<<An manah wang uh, Teesu?>> Simon Pitar ih chengta. Jisu ih ngaakbaatta, <<Amadoh an ih nga lih tajen phanrang,>> enoothong liwang nah nga lih jen phan ehang.>> ");
INSERT INTO tvt_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","<<Teesu, amadoh tiimnge ih an lih lajen phan ah?>> Pitar ih ngaak chengta, <<Ngabah an raangtaan ih tek suh banban ih tonglang!>> ");
INSERT INTO tvt_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisu ih ngaak liita, <<Amiisak nga raang ih teksuh banban tam tonglu? Ngah ih amiisak tiit baat hala; woh maang weeka doh an jaajom leek uh tajatkang ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Heliphante loong asuh Jisu ih baat rumta, <<Nak thungthih an nyia naksootsaam an,<<Rangte nyia ngah ba hanpi he. ");
INSERT INTO tvt_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Seng Wah nok ni nokkhok hantek je ah, erah raangtaan ih ngah sen tongtheng ban khookham wanglang. Emah lah ang dobah sen suh tabaat theng rum taha. ");
INSERT INTO tvt_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Eno, sen tongtheng jen khookham tangno, sen loong ah nga reenah toonsiit wansuh we ngaakrak ehang. ");
INSERT INTO tvt_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Sen ih jat ehan ngah wanglang lam ah maako wangla ih ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas ih Jisu suh chengta, <<Teesu, an maako wanglu ah botseh lajatke ah; eno erah nah thoktheng lam ah mamah ih jat ih?>> ");
INSERT INTO tvt_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisu ih ngaakbaat rumta, <<Ngah juuba lampo, amiisak nyia roidong; seng Wah jiinnah o uh tajen wangka, nga jun ih luulu jen wang ah. ");
INSERT INTO tvt_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jisu ih li rumta, Amadi sen ih ngah jat ih hali,>> <<seng Wah uh jat ih an, eno amah dowa ih heh uh jat ih han tup uh tup ih han.>> ");
INSERT INTO tvt_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip ih Jisu suh liita, <<Teesu, seng loong asuh seng Wah ah baat kohe; erah jamhi.>> ");
INSERT INTO tvt_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisu ih ngaakbaatta, <<Philip, sen loong damdi ngah rathan roongtong halang ah; amadi uh ngah o ah maang nih jat rang?>> O mina ih ngah tup halang erah ih seng Wah uh tup eha. Erah ang ah bah, ‘Seng Wah ah baat kohe’ ngeh ih tiim esuh liihan? ");
INSERT INTO tvt_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Philip, an ih tanih hanpiiko ngah seng Wah damdi eno seng Wah ah nga damdi ngeh ah? Ngah jenglang jengkhaap ah nga jeng tah angka.>> Jisu ih heliphante loong asuh baat rumta, Nga damdi waktong hala seng Wah ah ih heh mootkaat ah kala. ");
INSERT INTO tvt_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ngah ih baat rumhala ah hanpi an, ngah seng Wah damdi, seng Wah ah nga damdi. Ngah lahanpi riibah uh, nga reelang ah hanpi an. ");
INSERT INTO tvt_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ngah ih amiisak baat rumhala: O mina ih ngah hanpi halang erah ih ngah reelang nang ih elong mootkaat jen mokah ah, tiimnge liidi, ngah seng Wah taang ni wanglang. ");
INSERT INTO tvt_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Erah raangtaan ih nga mendoh sen ih tiim suh an erah reekot ih rumha, eno Hewah rangka ah Hesah jun ih noisok ah. ");
INSERT INTO tvt_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nga mendoh sen ih tiimjih suh he nga ih reekot ih rumha. ");
INSERT INTO tvt_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","<<Sen ih nga minchan ih heebah, nga jengdang ah kap an. ");
INSERT INTO tvt_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Sen loong chosokte ngah ih seng Wah jiin nawa saarookwet waktong suh wahoh sukoh rumha. ");
INSERT INTO tvt_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Heh langla Chiiala, Rangte amiisak tiit wuubaatte. Mongrep dowa mina ih tachoka, tiimnge liidi neng ih tup uh tatupka jat uh tajatka. Enoothong sen ih bah jat ehan, heh sen damdam waktong hala. ");
INSERT INTO tvt_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","<<Ngah wang ih angdoh, sen luulu tathiinhaat rumra; ngah sen jiinnah weengaak kaat ehang. ");
INSERT INTO tvt_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Chomroe lidoh mongrep mina ih ngah takah tuprang ang ah, enoothong sen ih bah tup ih he, tiimnge liidi ngah ething tong ang; sen uh ething tong an. ");
INSERT INTO tvt_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Heh rangwu thok haadoh, sen ih erah doh jat an ngah seng Wah damdi eno sen uh nga damdi, sen damdi ang halang likhiik ah. ");
INSERT INTO tvt_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","<<O mina ih nga jengdang loong ah chaat ano kap ah heh juuba nga minchante ah. Seng Wah ih nga minchante loong ah minchan eha; ngah uh erah mina ah minchan ehang eno nga teewah tiit ah neng suh dongjat thuk ang.>> ");
INSERT INTO tvt_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (arah ah Judas Iskariot tah angka) ih liita, <<Teesu, mongrep mina suh an teewah ah lajat thukthang ih seng suh luulu jatthuk hali rah mamah mi ang ah?>> ");
INSERT INTO tvt_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisu ih ngaakbaat rumta, <<O mina ih ngah minchan hang erah ih ngah ih nyootsoot hang ah kap ih ah. Seng Wah ih uh erah mih ah minchan ih ah eno sek Soowah raahe tiino neng damdoh waktong raahe tih. ");
INSERT INTO tvt_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","O mina ih ngah taminchan rang erah mih ah ih ngah ih nyootsoot hang ah uh takapka. Eno ngah ih ngaathung ih tanyootsoot rumra, erabah nga daapkaatte seng Wah jengkhaap nyootsoot rumhala. ");
INSERT INTO tvt_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","<<Arah sen damdi tongpoot diiba baat rumhala. ");
INSERT INTO tvt_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Sen chosokte, Esa Chiiala ah seng Wah ih nga mendoh kaat thuk ha, erah ih jirep ah nyootsoot han eno ngah ih nyoot rumhala ah samthun ih thuk han. ");
INSERT INTO tvt_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","<<Nga jiin dowa semroongroong ih tongjih ah sen suh thiinhaat koh rumhala. Mongrep mina ih koha likhiik takoh rumra. Sen naksootsaam an; cho uh nakcho an. ");
INSERT INTO tvt_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ngah ih sen suh baatrum taha ah chaat etan, ‘thiinhaat ih rumhala ngeh ah, enoothong ngah sen taang nah we ngaakkaat ehang.’ Sen ih ngah minchan ehe bah ah, seng Wah reeni wanglang asuh sen roon ih an; tiimnge liidi seng Wah ah nga nang ih elong. ");
INSERT INTO tvt_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jirep ah maang angkaadi amadi banbaat rumhala, emah ang adoh, sen ih hanpi toom ih an suh ah. ");
INSERT INTO tvt_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sen damdoh ngah ehan takah jen roongwaan rang, arah mongrep pante ah thok ehala. Nga khotokdi hechaan amuh, ");
INSERT INTO tvt_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","enoothong seng Wah ah nga mongnook ngeh ih mongrep mina warep ih jat jaatjaat etheng; erah raangtaan ih heh ih tiim baat halang erah jun ih reelang. <<Raahan, arah dowa dokkhoom eh ih. ");
INSERT INTO tvt_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","<<Ngah juuba amiisak anggut, eno seng Wah ah paachangte. ");
INSERT INTO tvt_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ngaaphaak ngaataang heh tiikmuh loong ah kheehaat eha, eno hetiik pan loong ah domjaan ih ah, enoobah singmoot choi nyia domjaan choi ang kano ehan ih dong tiik ah. ");
INSERT INTO tvt_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Sen loong abah ngah ih nyootsoot rum taha jun ih sa choi jen lang etan. ");
INSERT INTO tvt_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Sen loong ah nga damdoh roomtong han, ngah uh sen damdoh roomtong hang. Bangphaak ah hetiiktiik tami tiikka, heruh dowa phaakkah ah doba mi dongtiik ah. Erah likhiik sen uh nga damdoh lah angran bah sen tiik ah tami tiik kan. ");
INSERT INTO tvt_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","<<Ngah juuba anggut ruh, sen loong ah hephaak. O mina nga damdoh angha nyia ngah hedamdoh angtang nooba, hetiik ah ehan ih dong tiik ah; ngah laje kangbah an ih tiim uh tami ih ko. ");
INSERT INTO tvt_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","O ang abah uh nga damdoh lah ang raabah, erah hephaak hook toom e ah ngeh ih dook haat ah likhiik ang ah; erah likhiik abah chatjoh ano we nah ba saanjotak ah. ");
INSERT INTO tvt_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Sen loong ah nga damdoh tonghan bah nyia ngah ih nyootsoot rumhala jengkhaap ah kap anbah, sen ih tiimsuk suh nooklan erah choh ih an. ");
INSERT INTO tvt_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Seng Wah rangka ah sen tiik senlak jun ih jat ah; emah ang anno juuba sen loong ah nga liphante ang an. ");
INSERT INTO tvt_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Seng Wah ih ngah minchan halang ah likhiik sen uh ngah ih emah minchan rumhala; erah raangtaan ih nga minchan doh tong an. ");
INSERT INTO tvt_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Sen loong ih nga jengdang ah kap an nooba, nga minchan doh jen tong an, ngah ih seng Wah jengdang ah kap angno heh minchan di tonglang ah likhiik ah. ");
INSERT INTO tvt_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","<<A baat rumhala ah langla, nga tonglang ah likhiik sen uh tenroon ih toomtong an ngeh ih baat rumhala, sen loong ah rapne ih eroon toom ih an. ");
INSERT INTO tvt_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nga jengdang ah langla arah: Ngah ih sen minchan rumhala ah likhiik sen uh emamah ih minchanmui an. ");
INSERT INTO tvt_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Elongthoon minchan ah langla maama joonte raang ih heh roidong jen koha rah. ");
INSERT INTO tvt_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Eno sen loong ah nga jengkhaap adoh songtong anno juuba nga joonte ih hoon an. ");
INSERT INTO tvt_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sen loong asuh ngah ih nga laksuh ngeh ih takah li rumra, tiimnge liidi heh laksuh ih bah heh changte ih tiim eha erah tajatka. Erah nang ebah sen suh nga joonte li rumhala, erah thoidi seng Wah jiin nawa tiimjih chaattang loong ah thoontang baat rumhala. ");
INSERT INTO tvt_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ngah sen ih danje heerah tah angkang; ngah ih senba danje rumhala. Ngah ih sen tiik senlak ehanhan toom ih jaat an ngeh ih danje rumhala, hetiik saarookwet ih tong arah likhiik ah. Erah raangtaan ih nga mendoh seng Wah jiin nawa tiimjaat suh an erah ekot ehan. ");
INSERT INTO tvt_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Erah raangtaan ih baat rumhala; sen loong ah wasiit ih wasiit minchanmui e an. ");
INSERT INTO tvt_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","<<Arah mongrep ah ih miksuk ih hanbah, sen ih samthun ih an ngah phang miksuk rum tahang ah. ");
INSERT INTO tvt_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sen arah mongrep mina angtan bah neng mina likhiik ih minchan theng tahan. Enoothong ngah ih sen loong ah arah hadaang dowa danje rum taha, neng mina tah angkan. Erah thoidi miksuh halan. ");
INSERT INTO tvt_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ngah ih baat rum taha ah samthun an; ‘dah ah mabah uh heh changte nang ih elong tah angka.’ Neng ih ngah siiwi ih rumtahang bah sen uh siiwi ehan; ngah ih nyootsoot rumtang ah kap rumta bah sen ih nyootsoot han ah uh kap etheng rumta. ");
INSERT INTO tvt_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Eno sen loong nga mina angkan no siiwi ih han ang ah. Erah damdi ngah o ih daapkaat tahang warah neng ih tajat rumka. ");
INSERT INTO tvt_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Neng reenah ngah lakaat dobah nyia laroongwaan kaat dobah neng loong ah rangdah nah tamoong theng rumta; aadowa ebah, neng rangdah ah biin anaan takah chorumka. ");
INSERT INTO tvt_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","O mina ih ngah miksuk halang seng Wah uh miksuk eha. ");
INSERT INTO tvt_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Neng loong ah rangdah tah angtheng rumta ngah ih o uh lathaak reeka ah neng dung nah lamok reetang bah ah; tiimnge liidi, neng ih nga mamah reetang loong ah tup ih rumha, eno neng ih sek Soowah wanyiinyi miksuk hali tih. ");
INSERT INTO tvt_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Enoothong, erah elang jaatjaat etheng angta, neng Hootthe ni banraang thiinta ah amiisak doh ang etheng: ‘Ngah tiim lathih kangdi chiik haat rum halang.’ ");
INSERT INTO tvt_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","<<Chosokte ah kaat eha—erah langla Chiiala, Rangte tiit ami ah wuubaat suh seng Wah reenawa raaha. Ngah ih seng Wah reenawa daapkaat hang, eno heh ih nga tiit ah baat han. ");
INSERT INTO tvt_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Eno, sen loong ah jaakhoh dowa ih nga damdi ang thoidoh sen ih uh nga tiit tumbaat an. ");
INSERT INTO tvt_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","<<Ngah ih arah jengkhaap ah baat rumhala, sen laalom ah naktoom toihaat an ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sen loong ah Jehudi rangsoomnok nawa dokphanhaat ehan, eno sen tek haat saapoot uh thok eha, neng ih mok samthun ah sen tek haat ah suh Rangte mootkaat kalang ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Sek Soowah ah lajat thoidoh miloong ah emah reeraang rum ah. ");
INSERT INTO tvt_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Amadi sen loong asuh baat rumhala langla, emah ih siiwi handoh sen loong ah ih toom samthun an. <<Jaakhodi, ngah sen damdi ang thoidi arah tiit ah tabaat rum taha. ");
INSERT INTO tvt_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ngah o ih daapkaat tahang, amadi heh taang ni ngaakwang lang, erabah uh sen ih ngasuh mani wanglu ngeh ih o ih uh tacheng ri. ");
INSERT INTO tvt_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Eno amadi sen suh emah baatrum kohaano, sen loong ah thungjoong elan. ");
INSERT INTO tvt_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Enoothong sen loong asuh amiisak tiit ah baat rumhala: Ngah wanglaan ih ang bah sen raang ih ese ang ah, tiimnge liidi ngah lamok wang kangbah sen Chosokte ah sen jiinnah taraara ang ah. Enoothong ngah dok soonwang tangno, sen Chosokte ah ekaat ih thuk hang. ");
INSERT INTO tvt_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Esa Chiiala ah ra haano, mongrep mina suh neng rangdah tiit ah jatthuk ah, kateng tiit ah jatthuk ah, erah damdoh Rangte ih dande tiit ah jatthuk ih ah. ");
INSERT INTO tvt_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ngah lahanpi thoidoh, neng ih rangdah tiit ah tadanjat rumka ang ah; ");
INSERT INTO tvt_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","neng ih kateng tiit ah tajat rumka, tiimnge liidi ngah seng Wah reeni wanglang eno ngah takah japtupri ang ah, ");
INSERT INTO tvt_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","eno neng loong ah dande tiit ah tajat rumka, tiimnge liidi arah mongrep dowa neng pante ah jen dande eta. ");
INSERT INTO tvt_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","<<Ngah ih sen suh baattheng ene tah angka, erabah uh amadoh baat rumha bah tajen naanchaat kan ang ah. ");
INSERT INTO tvt_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Enoothong, Rangte amiitiit jatthukte Chiiala raaha doh, heh ih amiisak lampo adoh siit han. Heh ih heh chaan nawa ih tajengka ang ah, enoothong heh ih tiimjih japchaat ah erah ba jeng ah nyia lakngah nawa tiit ah ba baat han. ");
INSERT INTO tvt_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Sen suh Chiiala ah ih nga jeng ah baatkaat hanno nga rangka thuk hang. ");
INSERT INTO tvt_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Seng Wah suh tiimjeela jirep ah nga raangtaan; erah thoidoi baat rumhala Chiiala ih nga jiin nawa tiim chaat ah erah ah baat han. ");
INSERT INTO tvt_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","<<Chomroe doh sen ih ngah takah boot japtupri, eno chomroe lidoh ngah we japtup ehe.>> ");
INSERT INTO tvt_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mararah heliphante loong ah nengneng chengmui rumta, <<Heh ih tiim asuh liiha, chomroe doh sen ih takah boot japtupri eno chomroe lidoh ngah we japtup ehe ngeh ah; eno heh ih emah uh eli eha, ‘tiimnge liidi ngah seng Wah jiinni wanglang.’ ");
INSERT INTO tvt_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Chomroe ah tiim asuh liiha? Tiimjih suh li koja, erah seng ih tajatke!>> ");
INSERT INTO tvt_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisu ih jat eta, heliphante loong ih heh suh cheng ah ngeh ah, erah raangtaan ih Jisu ih baat rumta, <<Ngah ih liihang, ‘Chomroe sen ih takah boot japtupri, eno chomroe lidoh pootsiit we tup ehe.’ Erah li kangno tanih kah chengmui lan? ");
INSERT INTO tvt_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ngah ih ami tiit ah baat rumhala: Seng loong ah nga raangtaan ih ehu ih an, enoothong mongrep dowa miloong ah eroon ih ah; sen loong abah thungthet ih an erabah uh erah lih adoh eroon ih an. ");
INSERT INTO tvt_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Minuh ah heh sah tup tok thok kohaano sootsaam ela, tiimnge liidi heh chamnaang tok ah thok ehala; enoothong heh sah dongtup ano heh chamchoh ah beehaat eha, tiimnge liidi heh arah mongrep adi heh sah tup kano eroon ela. ");
INSERT INTO tvt_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Erah likhiik sen loong asuh emamah ang ah: Amadi sen loong ah thungthet elan, enoothong ngah ih we japtup ih rumha, eno sen loong ah erah than ih roon an sen tenroon ah o ih uh tajen nge ran. ");
INSERT INTO tvt_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","<<Sen loong asuh ami tiit ah baat rumhala, saapoot thok haadoh sen ih tiim uh tasuh ri ang ah. Sen suh amiisak tiit baat rumhala; nga mendoh seng Wah jiin nawa tiimsuh an, erah heh ih kot ih han. ");
INSERT INTO tvt_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Amadoh nga mendoh maang suh ang an bah; sen ih suk ih an, eno erah choh anno sen ten laanchem roh ih roon an. ");
INSERT INTO tvt_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","<<Ngah ih arah jengkhaap loong ah tiitthaak toobaat damdi baat rumhala. Enoothong saapoot ah thok eha ngah ih tiitthaak lam ih takah baat rumra, enoothong seng Wah tiit ah saasa ih baat rumha. ");
INSERT INTO tvt_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Erah rangwu thok haadoh sen loong ah ih seng Wah jiin nawa nga mendoh suh an, sen mendoh nga ih suh ang ngeh ih taliikang, ");
INSERT INTO tvt_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Sengwah heteteewah ih sen loong ah minchan ih halan. Sen loong ah ih ngah nook kohe nyia Rangte reenawa ra hala ngeh ih hanpi thoidi seng Wah ih sen uh minchan ih halan. ");
INSERT INTO tvt_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ngah arah mongrep adi seng Wah reenawa ra tahang, eno arah mongrep ah thiinhaat angno seng Wah jiinni ngaakwang lang.>> ");
INSERT INTO tvt_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Eno heliphante loong ah ih Jisu suh baatta, <<Amadi bah an ih saasa ih jenglu, tiitthaak lam ih labaat ah. ");
INSERT INTO tvt_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Amadi kokjat ehi an ih jirep ah jat ehu ngeh ah; an suh mih ih miicheng jih tajeeka. Erah thoidi Rangte reenawa raahalu ngeh ih seng ih jat ehi.>> ");
INSERT INTO tvt_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisu ih ngaakcheng rumta, <<Amadi hanpi tam ih han? ");
INSERT INTO tvt_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Saapoot ah amadi jen thok ehala, sen loong ah noongrep nah saapsoon an, nga luulu thiinhaat heeno sen nok nah saapsoon an. Enoothong emah ebah nga luulu tah angkang, tiimnge liidi seng Wah nga damdi eje. ");
INSERT INTO tvt_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ngah ih arah tiit ah nga damdi anghanno semroongroong ih toomtong rum ah ngeh ih baat rumhala. Sen loong ah mongrep mih ih chamnaang ih thuk han. Enoothong sen lacho theng! Ngah ih mongrep ah jen etang!>> ");
INSERT INTO tvt_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Erah jeng ano Jisu rangko toonsokwan ano liita, <<Ewah, saapoot ah thok ehala, an Sah rangka thuk uh, heh ih an toom we choomjoot thuk ho. ");
INSERT INTO tvt_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mina thoontang khothung ni an ih heh suh chaan aphaan kotu, an ih kotu mina loong asuh lathoon theng roidong jen kot suh ah. ");
INSERT INTO tvt_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Lathoon theng roidong ah langla, amiisak Rangte ah an luulu jat halu nyia an ih daapkaat taho Kristo jat ha asuh liiha. ");
INSERT INTO tvt_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Arah hah adi an rangka ah ngah ih noisok etang; an ih mootthuk tahang mootkaat ah ejen etang. ");
INSERT INTO tvt_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ewah! Arah hah maangdong di, an damdi angtok doh nga rangka tahang ah likhiik an ngathong nah amadoh nga rangka hang. ");
INSERT INTO tvt_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","<<Arah mongrep dowa mina kotahang loong asuh an ejat ih thuk taha. Erah koh halang mina loong ah an mina angta. Neng ih an jeng ah kap eta, ");
INSERT INTO tvt_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","eno an ih koh halang jirep ah an jiin nawa ra hala ngeh ih amadi jat ih rumha. ");
INSERT INTO tvt_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Neng suh an tiitkhaap baat tahang tiit ah baat ih rumtang, eno neng ih erah tiitkhaap ah kap ih rumta; neng ih jat eha ngah amiisak an reenawa ra tahang, eno an ih daapkaat tahang ah neng ih hanpi ih rumha. ");
INSERT INTO tvt_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","<<Ngah ih neng raang ih soomhang. Arah mongrep raangtaan ih tah soomkang, enoothong an ih kotahang loong raang ih soomhang, tiimnge liidi neng loong an mina. ");
INSERT INTO tvt_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nga dam dowa loong ah an mina, an reedowa mina loong ah nga raangtaan; nga rangka ah neng jun ih noisok ha. ");
INSERT INTO tvt_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Eno, ngah amadi an taang ni wang halang; arah mongrep adi takah boottong kang, enoothong neng loong ah arah mongrep adi thiinhaat hang. Esa Rangte! An ih ngasuh kotahang men dowa chaan anphaan nawa ih puipang ih rum uh, sek esiit angli tih likhiik neng uh esiit toom angrum ah. ");
INSERT INTO tvt_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ngah neng loong damdi angtang adoh an ih kotahang men dowa chaan aphaan nawa ih puipang ih rumtang, wasiit taan uh maat haat muh, marah emat jaatjaat ete angta ba mata—erabah Rangteele ni raangha jun ih ang etheng jaatjaat angta. ");
INSERT INTO tvt_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Amadi ngah an reeni wang halang, eno ngah arah mongrep ni angang di nga tenroon nah neng ten laanchem roh toomtong rum ah ngeh liihang. ");
INSERT INTO tvt_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ngah ih an tiitkhaap ah baatrum kangno arah mongrep dowa miloong ah ih miksuk ih rumha, neng uh nga likhiikkhiik arah mongrep mih takah angrumka. ");
INSERT INTO tvt_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ngah ih neng loong ah arah mongrep dowa toonsiit ih uh ngeh taliikang, neng loong ah Soitaan lak nawa puipang esuh baat we hala. ");
INSERT INTO tvt_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nga likhiikkhiik neng uh arah mongrep mih takah angka. ");
INSERT INTO tvt_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Amiitiit jun ih neng loong ah anteewah lak nah look haat uh, tiimnge liidi an jengkhaap ah amiisak. ");
INSERT INTO tvt_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","An ih ngah mamah ih daapkaat tahang, erah likhiik ngah ih uh neng loong ah mongrep ni daapkaat rumlang. ");
INSERT INTO tvt_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Neng raang ih nga teewah an suh look haat hala, tiimnge liidi neng ih uh neng teewah ah amiisak ih an lak nah toom look haat rumho. ");
INSERT INTO tvt_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","<<Neng raang ih luulu tasoomkang, neng ih tiitkhaap baatkaat rum adoh nga hanpiite loong raang ih nep soomhang. ");
INSERT INTO tvt_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Neng loongtang esiit ih toom angrum ah. Ewah! Neng loong ah sek damdoh toom jen angha, an nga damdi adoleh ngah an damdi likhiik ah. Neng loong ah esiit toom angrum ah, arah mongrep dowa miloong ah ih ngah an ih daapkaat tahang ah toom hanpi rum ah. ");
INSERT INTO tvt_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","An ih choomjoh tahang ah likhiik ih neng uh emamah ih rangka thuk rumhang, enooba neng esiit ih angrum ah, seknyi angli tih likhiik ah: ");
INSERT INTO tvt_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ngah neng damdi eno an nga damdi, enooba neng loong ah esiit jaatjaat ih angrum ah, tiimnge liidi arah mongrep dowa miloong ah ih ngah an ih daapkaat tahang ah toomjat rum ah nyia an ih ngah minchan halang ah likhiik neng uh an ih emamah ih minchan hu. ");
INSERT INTO tvt_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","<<Ewah! Neng loong ah an ih ngasuh kohalang, eno ngah manah angang neng uh nga damdam toom ang rumha, enooba neng ih nga rangka ah chotup rum ah, marah mongrep maanghoon di nga rangka tu nyia minchan ih tahang ah. ");
INSERT INTO tvt_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ewah Katengthoon! Arah hah dowa miloong ah ih tajat ru ngah ih ba jat hala eno arah loong ah ih an ih daapkaat tahang ngeh ih jat rumha. ");
INSERT INTO tvt_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Neng suh an jen jat ih thukrum taha, eno erah jatroh ih thukrum ang, enooba an ih nga minchan halang ah neng ih uh choh toom ih rum ah, eno ngah uh neng damdoh eje toom ang ang.>> ");
INSERT INTO tvt_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisu ih rang ah jensoom ano, Kidron joisah saangko heliphante loong damdi daankata. Erah di pa esiit angta, eno Jisu nyia heliphante loong ah erah di nopwang rumta. ");
INSERT INTO tvt_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jisu jootkotte Judas ih erah pa ah mani angta erah jat eta, tiimnge liidi heliphante loong ah damdi Jisu erah di hepoot hepoot pakchomui roh ka ih rumta. ");
INSERT INTO tvt_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Erah thoidi romwah phokhothoon nyia Pharisi nok hah loong ah ih Judas damdi Room nok hah sipaahi nyia Rangteenook bante loong ah langpi papi ih wangthuk rumta, eno neng loong ah weetook nyia phiitwe ah piirum ano erah pa adi nopwang rumta. ");
INSERT INTO tvt_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisu ih heh teeteewah ah mamah theng ah, erah banjat eta, eno neng taangko ih tiitkhoom kah ano cheng rumta, <<O jam han sen ih ah?>> ");
INSERT INTO tvt_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Najaret dowa Jisu,” neng loong ah ih ngaakbaat rumta. “Erah liihan abah ngah,” Jisu ih baat rumta. Mih khumtante, Judaas, ah erah di roongchap wangta. ");
INSERT INTO tvt_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisu ih <<Erah liihan abah ngah ngeh ih liikano<< neng liko ih ngaakchap rum ano hah ni loongjup rumta. ");
INSERT INTO tvt_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jisu ih weengaak cheng rumta, “O jam han sen ih ah?” “ Najaret dowa Jisu,” neng loong ah ih liita. ");
INSERT INTO tvt_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","<<Ngah ih jen baat ih rum taha erabah ngah ngeh ah.>> Jisu ih baat rumta, <<Ngah jam hali bah wahoh loong ah ngaakkaat ih thuk an.’’ Jisu ih emah ih li rumta. ( ");
INSERT INTO tvt_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Heh ih maangdi ban baatta ah amiisak ih angsuh neng loong asuh emah li rumta, Jisu ih Hewah rang ah emah ih soomta: <<Ewah! An ih kotahang miloong ah wasiit taan uh ngah ih mat haatmuh.>>) ");
INSERT INTO tvt_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Pitar ih lang esiit huita, erah dokkhoom ano Romwah phokhothoon dah na ah dakmiiko ah dat dookta. Erah dah men ah langla Malkus ngeh angta. ");
INSERT INTO tvt_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisu ih Pitar suh liita, <<An lang ah hetoop adoh sak hui uh! Seng Wah ih kohalang chamnaang lookkep adoh tajokka nih thun hu?>> ");
INSERT INTO tvt_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Eno Room nawa sipaahi nyia neng saahaap, erah damdi Jehudi nok hah bante loong ah ih Jisu ah jorum ano kit rumta, ");
INSERT INTO tvt_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","jaakhoh thoon ah Kaiphas hopwah Anna reeni siitwan rumta, erah paang adi Kaiphas ah Romwah Phokhothoon angta. ");
INSERT INTO tvt_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jehudi ngoong awang loong asuh loongtang raang ih wasiit tek ah eseethoon ang ah ngeh ih hukbaatte ah Kaiphas angta. ");
INSERT INTO tvt_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pitar nyia heliphante wahoh wasiit Jisu lilih ih phankhoom kanyuuta. Erah heliphante ah Romwah Phokhothoon damdi menjat ang thoidi, Romwah Phokhothoon nok taakkhu ni Jisu damdi waknop wangta, ");
INSERT INTO tvt_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","eno Pitar ah paakaawan adi banchapta. Heliphante ah kaalu ko ngaak kah ano jaalasah nusiit chapta asuh baat ano Pitar ah waknopsiit wanta. ");
INSERT INTO tvt_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Enoothong jaalasah rah ih kaalu adi Pitar suh chengta, <<An uh Jisu liphante tanih angkoko?>> <<Ngah tah angkang,>> Pitar ih ngaakbaatta. ");
INSERT INTO tvt_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Song ang kano, laksuh nyia bante loong ah we ah takrum ano songlom suh weekaang ni kookchap rumta. Erah di Pitar ah wang ano weekaang ni roong lomchap wangta. ");
INSERT INTO tvt_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Romwah Phokhothoon ih Jisu suh heliphante loong tiit nyia heh ih nyootsootta ah chengta. ");
INSERT INTO tvt_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisu ih ngaakbaatta, “Saarookwet ngah nokraat ni mirep suh saasa ih jenglang; Jehudi rangsoomnok ni nyia Rangteenok ni, maradi miloong ah kalomkhoon rum taha di ah. Mabah uh ngah husah ni jengmuh ");
INSERT INTO tvt_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","An ih emah tiim esuh cheng halang? Nga jeng boichaatte loong asuh cheng uh. Ngah ih tiimjih baat rumtang neng ih chaat eta.>> ");
INSERT INTO tvt_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisu ih emah li kano, bante dowa wasiit ih hethe ni baangbuh ano liita, <<Romwah Phokhothoon suh an ih emah mamah naan liihu!>> ");
INSERT INTO tvt_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisu ih heh suh ngaak liitta, “Ngah tiim bah uh mokjeng etang bah, mirep suh adoh baat uh. Enoothong ngah tiim jengtang erah punjeng etang baleh tiim esuh buh halang?>> ");
INSERT INTO tvt_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annas ih Jisu ah kitchoi Romwah Phokhothoon Kaiphas taang ni wangthukta. ");
INSERT INTO tvt_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Erah di Pitar ah weekaang ni chaproh eta. Erah thoidi miloong ah ih cheng rumta, <<An uh erah wah liphante taba ang koko?>> Pitar ih weeliita, <<Ngah ah tah angkang.>> ");
INSERT INTO tvt_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Romwah Phokhothoon dah wasiit, Pitar ih heh na datdook ta phoh awah erah di eje angta. Erah dah rah ih liita, <<Jisu damdi pa ni taba tup taha?>> ");
INSERT INTO tvt_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Eno Pitar we leekta, Tajatkang—erah damdam ih woh ah weeta. ");
INSERT INTO tvt_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Rangkhano ih Kaiphas nok nawa Jisu ah Kobono noklong ni siitwan rumta. Neng banlam di Khopi kuwaang miiphaksat suh neng ah esa ang theng, erah thoidi Jehudi ngoong awang loong ah kobono nokmong ni tanop wang rumta. ");
INSERT INTO tvt_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Erah thoidi Pilat ah dokkhoom kah ano chengkah rumta, <<Arah mih ah tiim thoidi jowan halan?>> ");
INSERT INTO tvt_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Neng ih ngaakbaatta, <<Lamoongre dobah an suh ju tajoot kot wantheng tahe.>> ");
INSERT INTO tvt_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","<<Emah ang abah sen hootthe jun ih mat ah taat hoonkaat thaak an.>> Pilat ih baat rumta. Jehudi loong ah ih ngaakli rumta, <<Seng ih mih tami tek haatke.>> ( ");
INSERT INTO tvt_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Erah langla Jisu ih heh mamah ih tektheng ah erah tiit ban baatta ah wuusa nah amiimi dong angsuh jeng rumta.) ");
INSERT INTO tvt_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilat ih Jisu nokmong ni poonwan ano cheng wanta, <<An Jehudi Luuwang nih ah?>> ");
INSERT INTO tvt_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisu ih ngaakbaatta, <<Nga tiit ah an thung ih tamcheng halang tam aleh mih ih baat ho ih cheng halang?>> ");
INSERT INTO tvt_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat ih ngaak liita, <<Ngah suh Jehudi nok hah nih li halang? An mina loong nyia romwah phokhoh loong ih ba jokoh wanrum halang. An tiimjih ih kotu?>> ");
INSERT INTO tvt_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisu ih ngaakbaatta, <<Nga hasong ah arah mongrep hasong tah angka; arah mongrep hasong angta bah nga lih phanjootte loong ah Jehudi ngoong awang suh lajoot thuksuh mui etheng rumta. Nga hasong bah mongrep hasong tah angka.>> ");
INSERT INTO tvt_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Eno Pilat ih Jisu suh chengta, <<Enoobah, an luuwang tam ah?>> Jisu ih ngaakbaatta, <<An ih liitu ngah luuwang ngeh ah. Ngabah dongtup hangno arah mongrep adi jisiit raangtaan ih ra tahang, erah langla amiitiit ah baat suh. O mina amiisak mih ang ah erah ih nga jeng ah boichaat hang . ");
INSERT INTO tvt_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“Enoobah amiitiit ah tiimah?” Pilat ih chengta. Eno Pilat ah weengaak dokkhoom kah ano miloong asuh liikah rumta, <<Heh tiim thoilam doh thet haat theng ah ngah ebah tah jatjoh kang. ");
INSERT INTO tvt_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Enoothong sen banlam di, Khopiikuh rookwet sen raangtaan ih phaatak nawa wasiit ah daap haat koroh erum hala. Sen loong raangtaan ih Jehudi luuwang ah daap haat kot ah tamjam han?” ");
INSERT INTO tvt_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Neng loong ah ih riiraak damdi ngaakbaat rumta, “Heh tah angka! Barabbas jamhi! (Barabbas ah miputte angta.) ");
INSERT INTO tvt_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Eno Pilat ih Jisu ah siitwan ano ruh ih bot thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Arami loong ah ih bangkaang hesupan nawa ih khopok ah hoon rum ano hekhoh ni pokthuk rumta; saangham nyuh ah hesak adi dekkoh rum eta ");
INSERT INTO tvt_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","heh reeni raarum hano li rumta, “Roiloh toom angkah Jehudi luwang ah!” Eno neng ah wangrum ano paatbuh rumta. ");
INSERT INTO tvt_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat ah jaasiit we ngaak dokkhoom kah ano miloong asuh baat rumta, “sok thaak an, nga ih sen reenah dongsiit kaat hang, enoothong heh tek haatjih bah ngah ih tachoh jokang.” ");
INSERT INTO tvt_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Erah di Jisu ah dokkhoom ra taha, sukhopok ah pok saangham nyuh ah kap ano dong ra taha. Pilat ih baat rumta, sok thaak an, mih abah arah!” ");
INSERT INTO tvt_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Heh ah kaptup rum ano romwah phokhoh loong nyia Rangteenok bante loong ah ri rumta, “Heh ah tekrapbot etheng! Heh ah tekrapbot etheng!” Pilat ih li rumta, “Siitkaat anno tekrapbot kaat an. Ngah ebah heh dut haat theng tajapjoh kang.” ");
INSERT INTO tvt_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Miloong ah ih ngaak riibaat rumta, seng hotthe ni eli eha heh ah tek haat etheng ngeh ah, tiimnge liidi heh ih ngah Rangte Sah ngeh chaangta.” ");
INSERT INTO tvt_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Erah chaat ano Pilat ah ehan han ih choota. ");
INSERT INTO tvt_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilat ah nopwang ano Jisu suh cheng wangta, <<An manawa ra halu?>> Enoothong Jisu tangaak jengta. ");
INSERT INTO tvt_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilat ih liita, <<Nga damdoh tanih waan ru?>> <<An ih tanih jatko nga jiinni chaan jeela ngeh ah, daap uh jen daap haat eha bangphak nah uh jen rapbot eha.>> ");
INSERT INTO tvt_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisu ih ngaak liita, An ih ngah tiim ehang bah uh erah chaan ah Rangte ih koh halu. Erah raangtaan ih an suh nga jootkotte ah rapne ih moong reela.>> ");
INSERT INTO tvt_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jisu jeng ah chaat ano, Pilat ih daap haat taat chungta. Enoothong miloong ah weengaak ri rumta, <<An ih Jisu mok daap haat ubah, Luuwanglong joonte tah angko! O mina ih ngah Luuwang ngeh ih chaangha mih abah Luuwanglong piiara!>> ");
INSERT INTO tvt_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilat ih erah jeng ah chaat ano, mat hoonkotte “Jongtongtheng” ngeh ih menrumta adi Jisu ah doksiit kaat ano tong kata (erah suh Hebrew nok hah ih <<Gabbatha<< ngeh menta.) ");
INSERT INTO tvt_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Khopui Kuwaang phaksat khookhamja rangnithung di Pilat ih miloong asuh liita, <<Sen Luuwang ah arah!>> ");
INSERT INTO tvt_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Eno miloong ah ngaak ri rumta, <<Tek haat etheng! Tek haat etheng! Bangphak khona rapbot theng!>> Pilat ih cheng rumta, <<Sen Luuwang ah nih tek haatthuk he?>> Romwah phokhoh loong ih ngaakbaatta, <<Seng luuwang bah Luuwanglong luulu!>> ");
INSERT INTO tvt_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Eno Pilat ih Jehudi loong asuh Jisu ah bangphak khoni rapbotkaat thuk rumta. Miloong ah ih Jisu doksiit kaat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisu ih bangphak ah pi ano <<Mikhoraang hah<< adi kata. (Jehudi loong ih <<Golgotha<< ngeh menha.) ");
INSERT INTO tvt_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jisu damdi mih wanyi ah uh erah di rapbot rumta, Jisu ah ehong adi mih wanyi ah haanghop ih rapbot rumta. ");
INSERT INTO tvt_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat ih mih suh jatthuk suh raang ano bangphak adi chiita, erah di raangta, <<Najaret dowa Jisu, Jehudi Luuwang.>> ");
INSERT INTO tvt_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Erah le adi Hebrew, Latin nyia Grik jenglam ih raangta, eno samnuthung dowa ih Jisu rapbotta hah ah haloh lah angkokaano mirep ih erah raangta ah toonsokleh weh kah ih rumta. ");
INSERT INTO tvt_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Romwah phokhoh loong ah Pilat reeni wang ano liita, <<Jehudi Luuwang<< ngeh ih nak raang uh<< erah nang ih bah <<Arah mih ah ih liita, Ngah Jehudi Luuwang<< emah ih raang uh. ");
INSERT INTO tvt_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat ih ngaak liita, <<Ngah ih tiimjih raangtang, emamah toom ang ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sipaahi loong ah ih Jisu ah bangphak ni rapbot lini heh ih kapta nyuh ah khoobaji ih khoohoom rum ano phe rumta. Heh samsong ah uh wakpi ih rumta, erah samsong ah hewet muh khoolaan angta. ");
INSERT INTO tvt_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sipaahi loong ah nengneng jaachi ni baatmui rumta, <<Seng ih lakhoohoom theng; eranang ebah o ih choh thaak asuh jong tetaak ah rang nah haat eno tootoon ih.>> Arah langla Rangteele ni amah raangthiinta ah amiisak ih dong angta: <<Neng loong ah ih nga nyuh ah phe ih rumta eno nga samsong ah rang ni haat rum ano tootoon rumta.>> Sipaahi loong ah emamah ih reeraang rumta. ");
INSERT INTO tvt_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisu bangphak re adi heh nuh nyia heh no Klopas minuh Meeri chapta, Meeri Magdalen uh erah di roongchapta. ");
INSERT INTO tvt_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Heh nuh nyia heliphante hemongnook warah japtup ano Jisu ih heh nuh suh liita, <<Heh an sah.>> ");
INSERT INTO tvt_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Erah lih adi heliphante asuh liita, <<Arah an nuh.>> Erah ja dowa ih heliphante ah ih erah nuh ah heh nok ni siitkaatta. ");
INSERT INTO tvt_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisu ih jat eta jirep ah thoon eta; eno Rangteele ni raangthiinta amiisak ih angsuh heh ih liita, <<Ngah joongle ih leelang.>> ");
INSERT INTO tvt_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Erah di thaangneethoon kham keethiin choi khaplang esiit angta, mih wasiit ih kham adi nyuchiin ah tem ano, hissop bangkaang adi khakta, eno toonpi ano Jisu tui ni mooksuta. ");
INSERT INTO tvt_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisu ih erah jok ano jengta, <<Thoon eta!>> Eno heh tok ah songhaat ano thaktiita. ");
INSERT INTO tvt_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Eno Jehudi ngoong awang loong ah ih Pilat suh bangphak khoni rapbot rumta loong lah ah thabuh rum ano datthiin esuh cheng rumta. Erah saalih adi Jehudi naangtongsa, hoondak rangwuuja angta, erah thoidi neng ih thunta Jehudi naangtongsa doh neng mang ah bangphak khonah naktoom thoktong ah ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Eno sipaahi loong ah ih jaakhoh ah Jisu reeni rapbotta mih lah thabuh ano wasiit lah ah we thabuh rumta. ");
INSERT INTO tvt_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Enoothong Jisu reeni wang rum adi jen tekchoi ang kano, heh lah ah tathabuh rumta. ");
INSERT INTO tvt_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Enoothong, sipaahi wasiit ih heh saam ni Pah ih sot kano joong nyi sih loong ah dokjanta. ( ");
INSERT INTO tvt_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Erah angta rah mih ih heh mikmik ih japtup arah baat ha, erah raangtaan ih sen ih uh hanpi ih an. Erah baatte ah ih amiitiit ah jat eha, ngah ih amiitiit ah baat hang ngeh ah.) ");
INSERT INTO tvt_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Rangteele ni raangthiinta ah amiisak ih angla: Erah di amah raangha, <<heraang esiit taan uh tathaka.>> ");
INSERT INTO tvt_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Rangteele ehoh ni uh li eha <<Pah esuh arah miloong ah ih kooksok ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Erah lih adi, Aramia nok hah Josep ih Pilat suh Jisu mang ah jenpi nih ih kaat ang ngeh cheng wangta. (Josep ah husah di Jisu liphante angta, enoothong heh Jehudi ngoong awang ra choota.) Pilat ih jenpi ih kaat uh li kano Josep ih bangphak dowa heh mang ah datpi wangta. ");
INSERT INTO tvt_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Heh damdi Nikodimas roongwaangta, jaakhoh ni uh Jisu damdi heh rangphe di chomui choi angta. Nikodimas ih phontum jih miir nyia aloes ah woi ano took rookjom taan piikaatta. ");
INSERT INTO tvt_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Erah nyi ih Jisu mang ah datpi nyuh ano phontum ah ih hut nyuuta, eno nyuh ih thooploop nyu ano Jehudi banlam di ebeng ih kaat suh emah ih khookham rumta. ");
INSERT INTO tvt_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisu tek haat rumta pa adi mangbeng theng ena esiit angta erah di o mang uh beng muh angta. ");
INSERT INTO tvt_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jehudi naangtongsa ah erah saalih adi angta eno erah mangbeng ah uh haniik ni ang thoidi Jisu mang ah erah di beng nyuuta. ");
INSERT INTO tvt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Naangtongsa, Meeri Megdalen chichuuwi ih rang maang phaakwu kaadi mangbeng ah taatsok kah adi mangbeng kepta jong dokkongchoi angta. ");
INSERT INTO tvt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Erah thoidi, Pitar nyia Jisu mongnook heliphante reeni soonkah ano baatkaat nyuuta, <<Teesu bah mangbeng nawa mih ih dokpi ih katta, mani thiinkaat koja tajatke!>> ");
INSERT INTO tvt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Erah baatrum kano, heliphante hejoon wasiit siit ano Pitar nengnyi ih mangbeng ah sokkah nyuuta. ");
INSERT INTO tvt_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nengnyi echaan ih taatsoon kanyuuta, erabah uh heliphante wasiit ah Pitar ah jiitsoon ano jaakhoh thok soonta. ");
INSERT INTO tvt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mang beng adi ngupbon ano taatsok adi hemong ni nyuh waariiri jangdat arah japtupta, enoothong hemong ni heh nopwang muh. ");
INSERT INTO tvt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Heh lilih Simon Pitar ah thok haano, phangla ih nopwangta. Heh uh erah di nyuleep jangdat arah nyia ");
INSERT INTO tvt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","heh khoh dekta nyuh ah japtup wangta. Heh khodek nyuh ah hetuituidat eta nyuh ah damdi lah angthang ah. ");
INSERT INTO tvt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Eno heliphante wasiit jaakhoh thokte warah uh roong nop ih wangta eno nyuh ah japtup ano heh ih hanpi eta. ( ");
INSERT INTO tvt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Erah pootdi neng ih Rangteele ni raangthiinta ah tajat rumta, tek nawa we ngaaksaat jaatjaat ih ah liiha rah ah.) ");
INSERT INTO tvt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Eno heliphante wanyi ah nok ni ngaakwang nyuuta. ");
INSERT INTO tvt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Meeri ah mangbeng kaang ni chap ano huuta. Hu damdi, mangbeng adi ngupbon sok adi ");
INSERT INTO tvt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","rangsah wanyi Jisu mang thiinta adi hekhoh helah ih nyupu ah kap nyu ano tongnyu arah japtupta. ");
INSERT INTO tvt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nengnyi ih cheng nyuuta, <<Minuh, tiimnge hu lu? Meeri ih baat nyuuta, <<Nga Teesu ah soonpi ih rumha, mani thiinkaat rum koja tajatkang!>> ");
INSERT INTO tvt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Eno Meeri ah ngaakwang esuh lekchap adi Jisu japtupta; enoothong heh ih Jisu ngeh tajatta. ");
INSERT INTO tvt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisu ih chengta, <<Minuh, tiimnge hu lu? O jamboi hu?>> Meeri ih pa ni motte heh angka ngeh samthun ano liita; Chuupha, <<An ih ma dokpi weeju oh? Enoobah heh mang ah mani thiinhu baat ih weehang, ngah ih toonpi kaat suh ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisu ih liita, <<Meeri!>> Meeri ah Jisu taangko lekchap ano Jehudi jenglam ih liita, <<Rabboni!>> (Erah langla Jehudi jenglam ih <<Leenyootte<< suh liiha) ");
INSERT INTO tvt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisu ih liita, <<Ngah nak taajoh hang<< Ngah seng Wah jiinni maang ngaakwang kang. Ngaaphoh ngaano loong suh baatkaat uh, seng Wah nyia neng loong Wah, nga Rangte nyia neng loong Rangte jiinni ngaakwangla ngeh ah.>> ");
INSERT INTO tvt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Erah raangtaan ih Meeri ah heliphante loong reeni kah ano Teesu japtup tiit nyia neng loong suh baatkaat tiit baatta ah baatkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Heliphante loong ah Jehudi ngoong awang loong raacho ih kaalu ah tangsak rum ano Naangtongsa rangja di nokmong ni khoontong rumta. Erah di Jisu ah neng laktung ni dongchap hano jengta, <<Semroongroong ih tong an.>> ");
INSERT INTO tvt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Erah jeng ano heh lakma nyi heh saam ah noisok rumta. Eno heliphante loong ah neng Teesu ah tup rum ano rapne ih roon rumta. ");
INSERT INTO tvt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Eno Jisu ih we liita, <<Semroongroong ih tong an.>> Seng Wah ih ngah kaat thuk halang ah likhiik, sen uh emamah ih kaat thukrum hala.>> ");
INSERT INTO tvt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Erah baatrum ano neng khoni heh tak ih mot rum ano li rumta, << Esa Chiiala ah thaang an.>> ");
INSERT INTO tvt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sen ih wahoh rangdah ah biin anaan hoon anbah, neng rangdah ah biin anaan hoon ih ah; sen ih biin anaan lahoon kanbah, neng rangdah ah uh biin anaan tahoonka.>> ");
INSERT INTO tvt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Asih wanyi heliphante loong dowa, Thomas (Twin ngeh poon rumta) ah Jisu dongkhoomta adi amuh angta. ");
INSERT INTO tvt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Erah thoidi heliphante wahoh loong ah ih Thomas suh baat rumta, <<Seng ih Jisu japtup eti!>> Eno Thomas ih li rumta, <<heh lak ni jaanwot ih po botta ah latup kangbah nyia heh lakpo adoleh heh saampo adoh nga laktiik maang thaak laanglaang tahanpi kang.>> ");
INSERT INTO tvt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Saasinet lidi heliphante loong ah nokmong ni we khoontong rumta doh, Thomas uh neng damdi eje angta. Nok kaalu ah tangsak choi ang adi Jisu neng laktung ni we dongchap wang ano jengta, <<Semroongroong ih tong an.>> ");
INSERT INTO tvt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Eno Jisu ih Thomas suh liita, <<An laktiik ih tasuh uno nga lakma ah Taat sok thaak uh adoleh nga saam ma ah an lak ih taajoh thaak uh. Tenchi nak ang uh hanpi ih hang!>> ");
INSERT INTO tvt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas ngaakjengta, <<Nga Teesu nyia nga Rangte!>> ");
INSERT INTO tvt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisu ih Thomas suh liita, <<Ngah ah tup hangno tam hanpi halang? Ngah latup rangdi hanpiiha loong ah tiimthan tenroon ah!>> ");
INSERT INTO tvt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Heliphante loong miksok di Jisu mih paatjaajih rapne ih mokata, erah loong ah arah Leedap ni raangthiin muh. ");
INSERT INTO tvt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Arah sen ih hanpi toom ih an ngeh ih raangthiin ha, Jisu ah Rangte Sah Kristo eno heh hanpi jun ih sen ih roidong ah choh an. ");
INSERT INTO tvt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Erah lini, Taiberia juusitum adi heliphante loong ah damdi Jisu emah we dongkhoomta. ");
INSERT INTO tvt_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Erah di Simon Pitar, Thomas (Khaangpeh ngeh ih poon rumta ah), Nathanel (Galili kooni Kana dowa), Jebedi sah nyia Jisu liphante wanyi loongtang eroom ang rumta. ");
INSERT INTO tvt_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Eno Simon Pitar ih heh joonte loong asuh baat rumta, <<Ngah bah chaak ha kah ang.>> Eno heh joon loong ah ih li rumta, “Seng uh wakkaat ehe,” eno neng loong khoonkhu ni karumta. Erah rangpheeja pheetang ih chaak ah taat ha rum adi tiim uh takap rumta. ");
INSERT INTO tvt_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Rangsa dong damdam di, Jisu juukaang ni banchapta, eno heliphante loong ah ih Jisu ngeh ih tajat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Eno Jisu ih cheng rumta, <<Jaaro loong, tiim uh tanih kap kan?>> <<Tiim uh takapke,” Jaaro loong ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Eno Jisu ih baat rumta, khoonkhu chap thuk lan dakmiiko adoh chaak ah haat an, nyah erah doh kap ih an.>> Erah raangtaan ih neng chaak ah haat rum ano tajen ngaak hom rumta, chaak adi nyah hantek nyaanta. ");
INSERT INTO tvt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Eno heliphante Jisu moongnook warah ih Pitar suh liita, <<Teesu bo ah!>> Pitar ih Teesu ngeh ih japchaat ano heh nyuh ah toonkap ano (heh nyuh ah khookpi eta) juukhoh ni datpit kata. ");
INSERT INTO tvt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Heliphante wahoh loong ah chaak adi nyah hesiit ih hoom rum ano juukaang ko ih wang rumta. Saanghook dowa ih ju ah haloh tah angta, ngookchaajom taan haloot angta. ");
INSERT INTO tvt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Neng loong ah juukaang adi thok rum adi, we khoni nyah nyia baanlo tupwang rumta. ");
INSERT INTO tvt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Eno Jisu ih li rumta, <<Sen ih kaptan nyah dowa esiitnyi than piiwan han.>> ");
INSERT INTO tvt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Pitar ah khoonkhu ko ngaak kah ano chaak adi nyah elonglongwah juukaang ko ih toonhoom kata, erah di elonglong ah chaasiit rookbanga ejom angta; nyah hantek ang ah bah uh chaak ah tah randatta. ");
INSERT INTO tvt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisu ih poon rumta, <<Phaksah wanghan.>> Eno heliphante loong ah ih o ih uh tanaan cheng rumta, <<An o anglu ngeh ah?>> Neng loong ah ih jat ih rumta heh Teesu ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Eno Jisu ah toonchapkah ano baanlo nyia nyah ah pheekoh rumta. ");
INSERT INTO tvt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jisu tek nawa ngaaksaat lidi erah ih takjom chomui rumta. ");
INSERT INTO tvt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jen phaksah rum ano, Jisu ih Simon Pitar suh liita, <<Joon sah Simon, wahoh loong ih minchan halang nang ih an ih ehan tam minchan halang?>> <<Minchan ih hala, Teesu,>> Pitar ih ngaak liita, <<an ih jat ih hu ngah ih an minchan ih hala<< ngeh ah. Jisu ih Pitar suh baatta, <<Nga saapsah loong ah sokboi uh.>> ");
INSERT INTO tvt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisu ih Pitar suh taknyi chengta, <<Joon sah Simon, <<ngah an ih minchan nih ehalang?>> “Em Teesu,” “an ih jat ih hu ngah ih an minchan ih hala<< ngeh ah. Jisu ih baatta, <<Nga saapsah loong ah sokboi uh.>> ");
INSERT INTO tvt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisu ih takjom chengta, <<Joon sah Simon, an ih ngah minchan nih ih halang?>> Jisu ih takjom cheng kano Pitar ah thungjoong eta, <<ngah an ih minchan nih ih halang?>> ngeh ih cheng kano ah. Erah raangtaan ih Pitar ih Jisu suh liita, <<Teesu an ih jirep ah jat ih hu; an ih jat ih hu ngah ih an minchan ih hala ngeh ah!” Jisu ih Pitar suh baatta, <<Nga saap ah sokboi uh. ");
INSERT INTO tvt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ngah ih amiitiit baat hala; an jaaro tokdi mani kaat thung ah erah di katu; enoothong teekaang ang udoh, an lak jaanghaat kuno wahoh ih an thung lahaan ko adoh siitkaat ho.>> ");
INSERT INTO tvt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Arah liiha langla, Jisu ih Pitar ah mamah ti ano Rangte rangka thuk ah erah tiit ah baat ha.) Eno Jisu ih baatta, <<Nga lilih eho!>> ");
INSERT INTO tvt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pitar lengsok adi heh liko ni heh mongnook warah, japtupta—heh ih phaksat tokdi Jisu reeni tiittong ano chengta warah ah, <<Teesu an mokwaante ah o ang ah?>> ");
INSERT INTO tvt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pitar ih heh ah japtup ano Jisu suh chengta, <<Teesu, erah mih ah mamah ang ah?>> ");
INSERT INTO tvt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisu ih Pitar suh liita, <<Erah mih ah ngah maang ngaak raara ething tongthuk ang bah, an raangtaan ih tiimjih ang ah? Nga lilih ih ho!>> ");
INSERT INTO tvt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Erah raangtaan ih kristaan loong laktung ni tiit hu moong ruurangta heliphante erah tatiika tih ngeh ah. Enoothong Jisu ih liimuh; erah mih ah tatiika ngeh ah; Jisu ih amah ba liita, <<Erah mih ah ngah maang ngaak raara ething mok tongthuk ang bah, an raangtaan ih tiimjih ang ah?>> ");
INSERT INTO tvt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Erah jengkhaap jengte ah heliphante dowa wasiit angta, erah raangthiinte ah uh heh angta; eno seng ih jat ehi heh ih baat ha ah amiitiit ah baat ha. ");
INSERT INTO tvt_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Amadi uh, Jisu mokah arah jihoh tiit uh rapne ih je ah. Erah loong ah esiit esiit ih mok raangthiinta bah, ngah ih thaakthun angdi erah leedap ah mongrep mina loongtang ih tajen toonpi thengta.");
INSERT INTO tvt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nga mongnook Thiophilas: Nga leedap phangkhoh adi Jisu phang mokata dowa ih rangmong ni maang toonsiit wandi tiimjih reeraangta nyia tiimjih nyootsootta ");
INSERT INTO tvt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","erah ah raangtang. Jisu rangmong ni maang toonsiit wanka di, heh ih danjeeta heliphante loong asuh Esa Chiiala chaan tiit ah renbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Heh tiita dowa ih sa rookbaji lini ething toomjat rum hang ngeh ih hedop hedop heliphante loong suh noisokta. Heliphante loong ih uh tup ih rumta, eno Rangte hasong tiit ah roongwaan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Neng loong ah eroom ih khoontong rum adi arah jengdang ah baat rumta: “Jerusalem ah nak thiinhaat an, erah nang ebah ngah ih baat rum taha ranglakkot ah bansoktheng, seng Wah ih kot etheng ngeh ih kakhatta rah ah. ");
INSERT INTO tvt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Joon ih juutem ah ju nawa ih tem tahan, enoothong rekam lidoh sen loong ah Esa Chiiala nawa ih tem han.” ");
INSERT INTO tvt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kaamwah loong ah Jisu damdi eroom ih chomui rumta doh, neng ih heh suh cheng rumta, “Teesu, hasong ah amadoh Ijirel suh ngaakkot nih uh?” ");
INSERT INTO tvt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jisu ih baat rumta, “Saapoot nyia rangwu ah seng Wah luulu ih jat ah erah mabah ang ah sen ih jatjih tah angka, hechaan hephaan khui ni thiinha. ");
INSERT INTO tvt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Enoothong sen taangnah Esa Chiiala raaha doh, sen loong ah chaan aphaan pan ang an, eno sen loong ah Jerusalem nah, Judia nah, Samaria nah nyia hakong rookwet nah nga haaki ang an.” ");
INSERT INTO tvt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Erah baat rumta lilih, heh rang ni toonsiit wan arah phansok rumta, eno neng miksoksok di jiimu ih loop wanta. ");
INSERT INTO tvt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Toon soonwang kano neng mik ah rangko sokwan roh ih rumta, eno nyuh epu ah kap ano mih wanyi neng reeni dongchap haano ");
INSERT INTO tvt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","baat rumta, “Galiliite oh, rangko tiimjih sokwan lan? Jisu, sen re nawa rang ni toonsiit wanta, erah likhiikkhiik ih rang nawa ngaak raaha rah japtup an.” ");
INSERT INTO tvt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Erah lih adi heliphante loong ah Olip Kong dowa Jerusalem ni ngaakwang rumta, erah hah dowa meesiit chang angta. ");
INSERT INTO tvt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Erah hah adi thokrum ano neng tongta nok rangkhoh ko nokkhok adi duuwang rumta: Erah di langla, Pitar, Joon, Jeems nyia Andriu, Philip nyia Thomas, Bartholomi nyia Mathiu, Alphias sah Jeems, Deek akaan raangtaan laatte Simoon, nyia Jeems sah Judaas loong angta. ");
INSERT INTO tvt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Neng loong ah rangsoom raangtaan ih minuh loong nyia Jisu nuh Meeri erah damdi heh phoh nyia heh no loong damdi hepoot hepoot khoontong rumta. ");
INSERT INTO tvt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Saajombaji lidi chaasit rooknyi mih rangsoomte loong khoontong rum adi, Pitar toonchap ano jengta. ");
INSERT INTO tvt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Pitar ih liita, “Nga joonte loong, Esa Chiiala ih Dewid jeng thukta erah Rangteele ni raangha ah amiimi ih thok ha, Judaas ah Jisu jootkhak doh lamsiitte ang ah ngeh ih ah. ");
INSERT INTO tvt_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judaas ah sengdung dowa wasiit heh mootkaatte taat danjeeta.” ( ");
INSERT INTO tvt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judaas ih marah lalangka lampo nawa biita ngun ih reta phek adi tiita, heh wok ah raapphok ano heh leh loong ah nuudat eta. ");
INSERT INTO tvt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalem ni songtongte loong ah ih erah japchaat rum ano, neng jenglam ih erah phek asuh Akeldama ngeh ih men rumta, erah langla “Sih Phek ngeh ah”) ");
INSERT INTO tvt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Rangsoom boong leedap ni raangha, ‘Heh nok ah ehu ih toom hoon ah; erah doh o uh naktoom tong ah.’ Amah uh raang eha, ‘Heh mootkaat ah o bah uh reeraang pakna toom ih ah.’ ");
INSERT INTO tvt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Erah thoidoh, seng damdoh o bah uh weeje etheng seng Teesu Jisu Kristo ngaaksaat tiit toombaatte ah. Enoothong erah mih ah langla sengdung dowa ang theng. Seng Teesu Jisu seng damdi saarookwet roongkhoom taha di roong mootkaatte dowa mih ang theng, Joon ih juutem Ruurang tumbaatta dowa ih Jisu rang ni toonsiit wanta di o thok roong khoomta erah mih ah ang theng.” ");
INSERT INTO tvt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Erah thoidi mih wanyi danje rumta: Josep, Barsabbas ngeh ih poon rumta ah (Justas ngeh ih uh li ih rumta), nyia Mathias ah. ");
INSERT INTO tvt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Eno rangsoom koh rumta, “Teesu, an ih warep tenthun ah jat ehu, erah wanyi tung dowa o ah danje hu erah seng suh jatthuk he ");
INSERT INTO tvt_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judaas maako kaat theng angta kaat eta erah saklek ah an liphante raangtaan ih jatthuk he” ");
INSERT INTO tvt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Eno nengnyi men o danje theng ah erah tootoon rumta, eno Mathias ah danje rumta, asih wasiit kaamwah loong damdi roong angtheng ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikos rangwu sa, Jisu hanpiite mina loong ah noksiit ni lomkhoon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Dotdi rang ni pong huuk ah likhiik, neng khoontong rumta nok dowa ih chaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Eno tuihih likhiik weelu phaak arah japtup rumta ah neng sak ni ra taha. ");
INSERT INTO tvt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Neng sak ni Esa Chiiala ah ra haano, chiiala ah ih wahoh wahoh jeng miijeng thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Deekrep dowa Rangte ra choote Jehudi nok hah loong ah Jerusalem ni songtong rumta. ");
INSERT INTO tvt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Neng hoopti ah japchaat rum ano, miloong ah lomkhoon rumta. Jisu hanpiite loong ah maama jengjeng ih jeng rumta asuh miloong ah paatja ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Neng loong ah paatja rum ano li rumta, “Arah jengla mina loong ah Galili nok hah! ");
INSERT INTO tvt_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Eno, nengjeng nengkong ah seng nok hah jeng jeng arah mamah ih chaat hi? ");
INSERT INTO tvt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Seng loong ah Parthia, Media nyia Elam nawa; Mesopotamia, Judia, nyi Kappadosia nawa; Poontas nyia Esia nawa, ");
INSERT INTO tvt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrigia nyia Pamphilia nawa, Ijip nyia Sirene reenawa Libia hah ko nawa. Seng loong mararah ah Room nawa, ");
INSERT INTO tvt_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ranglajatte loong ah seng Jehudi damdi Judaisim ih roonghoon haano Judaisim angli, seng loong ah mararah langli Kritte nyia Arab nawa—rabah uh neng jeng ah seng jenglam ih Rangte mootkaat elong jen mokah arah tiit roongwaan rum arah chaat hi!” ");
INSERT INTO tvt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Neng loong ah paattek nyia tanyah damdi, neng jaachi ni chengmui rumta, “Erah tiim suh liiha?” ");
INSERT INTO tvt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Eno rukho loong ah Jisu hanpiite loong ah damdi doondaak siitkook ih rumta, Neng ih liita, “Arah miloong ah kham ih mok rumla!” ");
INSERT INTO tvt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pitar ah heliphante asih wasiit damdi roong toonchap ano miloong ah damdi erongwah phang jengmui rumta: Jehudi joon awan loong nyi Jerusalem ni songtongte loong, boichaat thaak he erah tiim asuh liiha erah toombaat rumha. ");
INSERT INTO tvt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Arah mina loong ah kham ih tamokka, sen ih mokthun ehan; amadi rangkhah phek kaattok angla. ");
INSERT INTO tvt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Arah bah khowah Joel ban jengta ah angla: ");
INSERT INTO tvt_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Rangte ih liita, rangthoon doh Ngah ih amah re ang; Ngaachi ngaala warep khoh nah ang ah. Sen sah minuh miwah loong ih nga tiitkhaap baatrum ah; sen jaaro loong ah ih motmang tup rum ah, sen teekaang loong ih mangphe mang ah. ");
INSERT INTO tvt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Minuh miwah, nga jeng chaatte loong suh, Erah tokdoh ngah ih chiiala koh rum ang, Eno neng ih nga tiitkhaap baatrum ah. ");
INSERT INTO tvt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ngah ih paatjaajih rangkhothung nah noisok ang Nyia hah khui nah uh paatjaajih ang ah. Erah doh sih, we nyia weekhot ang ah; ");
INSERT INTO tvt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","elongthoon Teesu rangka Rangwu thok ha doh, rangsa ah nakdat ih ah, nyia laphui ah sih likhiik ih saangdat ah. ");
INSERT INTO tvt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Eno, o ih Teesu men poon ah erah mina ah epui ih ah.’ ");
INSERT INTO tvt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Jerusalem dowa mina loong, arah jengkhaap ah boichaat an! Najaret dowa Jisu taang ni chaan aphaan jeela, mih paatjaajih loong ah Rangte ih Jisu jun ih noisok tahan. Sen miksok ni mamah angta, loongtang ih jat ehan. ");
INSERT INTO tvt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Heh kaankoong jun ih Rangte ih Jisu ah rangdah mina sen loong asuh bangphak khoni tekrapbot thuk tahan. ");
INSERT INTO tvt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Enoothong Rangte ih heh chaan nawa ih saatsiit ano ngaakthing ih thukta, timnge liidi etek ih heh tajenta. ");
INSERT INTO tvt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dewid ih heh suh liita, ‘Saapoot rookwet nga Teesu ah nga ngathong ni tup hang; heh reenah ngah tasootsaam kang. ");
INSERT INTO tvt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Erah raangtaan ih ngah tenroon ih tonglang, nga jengkhaap adi tenroon jeela. Ngah, tekte ang ang bah uh, nga laalom theng adoh naangtong ang, ");
INSERT INTO tvt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","timnge liidi an ih tek lampo nah ngah tathiinhaat rang; adoleh an jeng chaatchaatte loong ah mangbeng nah tah chaam thukko. ");
INSERT INTO tvt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Roidong lam ah an ih noisok ih halang, nga reenah ang uno tenroon ih tongthuk hang.’ ");
INSERT INTO tvt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nga joonte loong, sengte sengwah Dewid Luuwang khiikkhi ah sen suh baat jaatjaat ejih. Heh ti ano bengta, heh mangbeng ah amadi uh eje. ");
INSERT INTO tvt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Heh khowah angta, Rangte ih baatta ah heh ih jat eta: Rangte ih kakhamta Dewid sutom dowa wasiit heh teewah likhiik Luuwang dongthuk ah. ");
INSERT INTO tvt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Rangthoon doh Rangte tiimjih re ah erah Dewid ih bantup eta, erah thoidi Kristo ngaaksaat tiit ah baatta, ‘Heh tek lampo mongrep ni tathiin haatta, Heh sak ah mangbeng ni tachaamta.’ ");
INSERT INTO tvt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jisu ah Rangte ih tek nawa ngaaksaat ih thukta, seng loong ah ih jat ehi. ");
INSERT INTO tvt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jisu ah ngaaksaat thuk ano heh Wah Rangte ih jaawah ko tong thukla, eno Heh kakham jun ih Esa Chiiala ah choh eha. Amadi sen ih tiimjih tup han nyia tiimjih chaat han ah langla seng raangtaan ih ranglakkot. ");
INSERT INTO tvt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tiimnge liidi Dewid ah rangmong ni tawangta; erah nang ebah Dewid ih liita, ‘Teesu ih nga Teesu suh liita: Anpi anra loong ah ngah ih an lathong nah maang thiinthiin ");
INSERT INTO tvt_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nga reenah jaawah ko tong uh.’ ");
INSERT INTO tvt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Jerusalem dowa miloong ah ih jat ejih, Jisu ah sen ih bangphak ni tek haat tan ah Rangte ih Teesu nyia Kristo ang thukla!” ");
INSERT INTO tvt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Miloong ah ih jeng ah chaat rum ano, rapne sootsaam rumta Pitar nyia kaamwah loong suh li rumta, “Phoh ano loong seng ih tiimjih etheng ah?” ");
INSERT INTO tvt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pitar ih baat rumta, “Sen loong ah rangdah nawa sa ejih eno Jisu Kristo mendoh sen rangdah biin anaan suh juutem theng; eno Rangte lakkot Esa Chiiala ah choh an. ");
INSERT INTO tvt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Rangte ih kakhamta ah sen raangtaan ih nyia sen sah loong raangtaan ih, adoleh o mina heh re nawa haloot ni angla erah loong raang ih—erah langla o mina seng Teesu Rangte ih heh jiinni poon rumha erah loong raangtaan ih.” ");
INSERT INTO tvt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pitar ih neng suh jengthoon ah jirep jenglam ih jatthuk ano li rumta, “Lajak miloong ah raangtaan ih chamnaang rangwu thok hala erah dowa maama teenuh teewah puipang an!” ");
INSERT INTO tvt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pitar jengkhaap ah hanpi rum ano miloong ah juutem rumta, erah sa dowa ih hajaat jom mina ih jaatjaang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kaamwah loong taangnawa nyootsoot rumta di, rangsoom suh lomtong rum adi nyia phaksat room phaksah rum adi neng saapoot ah liin eta. ");
INSERT INTO tvt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kaamwah loong asuh mih paatjaajih loong reethuk kano, warep paatjaata. ");
INSERT INTO tvt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kristaan loong ah rangsoom rangtu eroomroom ih tongtha rum ano neng huikhaak uh eroomroom ih maak rumta. ");
INSERT INTO tvt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Neng hah ah sangleh, o tiimjih jamha erah jun ih ngun ah phe phaksah ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Rangwu rookwet Rangteenok ni eroomroom ih chomui rumta, neng nok ni phaksat ah roongngit roongkhu nyia tenroon woksoon, ih room phaksah rumta, ");
INSERT INTO tvt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","enooleh tenroon woksoon ih rangphoong rangsoom tongtha rumta. Eno rangwu rookwet khopiiroidong chote loong ah Teesu ih neng damdi weewe thok ih thukrum taha. ");
INSERT INTO tvt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Saasiit Pitar nyia Joon rangsoom saapoot chang kano rangnithung lih saasong saapootjom di rangsoomnok ni wang nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Paakaalu jaase, ih men rumta adi, heh roi roitang ih ekoong ang arah wasiit katongta. Saarookwet, erah paakaalu adi ekoong ah piikaat leh Rangteenok nah wangte loong jiin nawa ngun thaang suh katongthiin kaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Erah mih ah ih Joon nyia Pitar khoom ah japtup ano tiim ah tiim koh weehe tih ngeh ih suh nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nengnyi ih ekoong ah taangko soknyu ano, Pitar ih liita, “Sek taangko sok thaak ho!” ");
INSERT INTO tvt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Eno, ekoong ah ih tiim bah uh kot ih nyu hang ngeh ih laalom ano leksokta. ");
INSERT INTO tvt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Enoothong Pitar ih liita, “Nga jiinni ngun bah tajeeka, enoothong nga jiinni tiim jeela erah koha: Najaret dowa Jisu Kristo mendoh toonchap uh!” ");
INSERT INTO tvt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Eno Pitar ih jaawah ko lak ih joh ano toonchap thukta. Erah damdam heh lah ah rongtangtang ih nak ano; ");
INSERT INTO tvt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","toonpitta, heh lalah ni toonchap ano lengkhoomta. Erah lih adi toonpit ano, Rangte rang ah phoong ano Pitar nyia Joon damdi Rangteenok ni roongwangta. ");
INSERT INTO tvt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Miloong ah ih ekoong angta ah ih Rangte rangphoong rangsoom ih lengkhoom arah japtup rumta, ");
INSERT INTO tvt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","eno neng ih arah mih abah Paakaalu Ese ni tongte kunma ah ngeh ih jatjoh rum ano, neng uh rapne ih paatja rumta. ");
INSERT INTO tvt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kunma ah Pitar nyia Joon ih Solomon nok ngeh ih men rumta di, siit nyu arah tuprum ano miloong ah neng reeni soonwang rum taha. ");
INSERT INTO tvt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Miloong ah tup ano, Pitar ih li rumta, “Ijirel ni, songtongte joon awaan loong, arah suh tiimnge paatja lan, tiim esuh sok hali? Arah mih ah Rangte likhiik hoon eno seng chaan nawa ih khoom thukli nih mokthun han? ");
INSERT INTO tvt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Sengte sengwah Abraham, Isak, nyia Jaakob Rangte ih heh Laksuh Jisu suh rangka thuk suh chaan koha. Enoothong sen loong ah ih ngoong awang loong suh jokoh anno Pilat ngathong ni dut haattan, lang abah Pilat ih edaap etheng taat liita. ");
INSERT INTO tvt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Heh toongtang nyia ese angta, enoothong sen loong ih dut haat ih tan, eno Pilat suh mih tek haatte li thuk tan. ");
INSERT INTO tvt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Roidong lamsiitte ah sen ih tek haat tan, enoothong Rangte ih sen miksok di tek nawa ngaaksaat ih thukta—eno erah haaki kotte ah seng loong ah. ");
INSERT INTO tvt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jisu mendi chaan aphaan je tungkangdi ekoong ah jen khoom thukta. Sen ih tiim tup han nyia jat han ah langla heh mendi tuumaang thoidi deesiitta ah tup han: Jisu hanpi thoidi deela ah sen ih amadoh jensok ih an. ");
INSERT INTO tvt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Amadi ngah ih jat ehang, ngaaphoh ngaano loong, sen mihak phokhoh loong ih Jisu ah lajat thoidi siiwi tan. ");
INSERT INTO tvt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Teewadi Rangte ih khowah suh banbaat thukta Kristo ah cham ih ah ngeh ah, erah likhiik amiimi ih angla. ");
INSERT INTO tvt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Erah raangtaan ih, sekthun ih an, eno Rangte reenah thok han, sen rangdah ah biin anaan ehan. Emah re anbah, ");
INSERT INTO tvt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Teesu jiin nawa Esa chaan aphaan kaat suh saapoot thok eha, eno Jisu kaat thuk ha, Kristo ah sen raangtaan ih jen danje eta. ");
INSERT INTO tvt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jirep ah ena ih maanghoon hoon, heh rangmong nah tong ah, erah tiit teewah di Rangte ih toongtang khowah loong suh banbaat ih thukta. ");
INSERT INTO tvt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Erah thoidi Moses ih liita, ‘Ngah kaat thuk halang likhiik, sen Teesu Rangte ih khowah kaat thuk ha, eno erah mih ah sen mina dung nawa ang ah. Eno heh ih sen suh tiim baat han erah sen ih kap etheng ang ah. ");
INSERT INTO tvt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Erah khowah jeng lah boichaatte ah Rangte mina re nawa maama ih hiik hoom ano thet haat ah.’ ");
INSERT INTO tvt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Amadi mamah angla, erah loong ah, Samuel nyia heh lih ni kaatte khowah loong ih banbaat choi. ");
INSERT INTO tvt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Sen raangtaan suh Rangte ih khowah loong damdi kakhamta, eno sente senwah damdi nuumi jengdang hoonta jun ih pan halan. Rangte ih Abraham suh liita, ‘Arah hah dowa mina loong ah an sutom satoom jun ih pan ang adoleh minchan ang.’ ");
INSERT INTO tvt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Erah raangtaan ih Rangte ih Heh Laksuh ah danje ano seng reeni phangkaat thuk taha, seng loong lamthih nawa pui thuk suh ah.” ");
INSERT INTO tvt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Romwah loong nyia rangsoomnok sokboite dowa mihak phokhoh, erah damdi mararah Sadusi mina thok rum ha di Pitar nyia Joon miloong ah damdi roongwaan roh ih nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Heliphante wanyi ah ih miloong asuh Jisu tek nawa ngaaksaat tiit ah nyootsoot nyu kano neng loong ah rapne ih chiiru rumta. ");
INSERT INTO tvt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Erah thoidi Pitar nyia Joon phaatak ni joh sakwan rumta, eno rangja ang thoidi wanyi ah erah saalih adi daap haat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Enoothong Jisu ngaaksaat tiit japchaatte loong ah ih hanpi ih rumta, miwah loong ah rooproop ih haajaat bangnga ang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Erah saalih adi Jehudi nok hah dowa mihak phokhoh loong nyia hootthe nyootsootte loong ah Jerusalem ni lomkhoon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Neng loong ah Romwah phokhothoon Annas damdi nyia heh jaatang Kaaiphaas, Joon, Alekjendar loong damdi chomui rumta. ");
INSERT INTO tvt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Neng loong ah ih Heliphante anyi neng ngathong ni chap thuk rum ano cheng rumta, “Set mamah ih re lan sih? Tiim chaan kap han sih adoleh o men kap han sih?” ");
INSERT INTO tvt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pitar sak ni, Esa Chiiala pah ano ngaakbaat rumta, “Mihak phokhoh loong; ");
INSERT INTO tvt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","chiinnyah sek suh ekoong ah mamah ih deeta ngeh ih cheng hali tih bah, ");
INSERT INTO tvt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","sen ih jat ejih ang tan, seng ngathong ni chapla ekoong ah langla, sen ih tek haat anno we ngaaksaatta Najaret dowa Jisu Kristo mendi deeta. ");
INSERT INTO tvt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jisu Kristo ah langla Rangteele ni maangdi dook ban baatta, ‘Nok hoonte ih jong taaseeka ngeh ih daanta erah thoontang nang ih eseethoon ih hoonla.’ ");
INSERT INTO tvt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Khopiiroidong ah Jisu luulu jiin nawa ba choh ih; arah hah adi seng jen puipang suh o suh uh Rangte ih chaan kotmuh” ");
INSERT INTO tvt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pitar nyia Joon lacho laphaan ih ang kano Ngoong awang loong ah paatja ih rumta, neng ih jat eta wanyi ah le wette tah angka ngeh ih ah. Neng ih erah uh jat eta wanyi ah Jisu damdi ang dowa ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ekoong deeta ah nengnyi damdi tup rum ano, tiim uh tami jeng rumta. ");
INSERT INTO tvt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Erah thoidi Ngoongthum theng nokkhok dowa doksoon thuk rum ano, neng jaachi di roongwaan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Arah mih anyi mamah ih ih?” “Jerusalem dowa miloong ah ih jat eha, arah mih anyi ih mih paatjaajih noisok ha ngeh ah, eno seng ih tami daanke. ");
INSERT INTO tvt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Enoothong arah tiit ah Jisu mendoh nak toom kah tumbaat nyu asuh choophaan etheng.” ");
INSERT INTO tvt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Erah thoidi wanyi ah ngaakpoon rum ano baat rumta, mamah ang ah bah uh set ih Jisu mendoh o suh uh labaat theng adoleh lanyootsoot theng. ");
INSERT INTO tvt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Enoothong Pitar nyia Joon ih amah ih ngaakbaat rumta, “Sen teeteewah ih thaak thun thaak an Rangte mik sokdoh marah pun ah—sen jeng chaat theng tam Rangte jeng chaat theng ah. ");
INSERT INTO tvt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Seng mik ih tup hi nyia seng na ih chaat hi ah labaat bah seng bah tami tongke.” ");
INSERT INTO tvt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nengnyi jeng ah chaat rum ano, Ngoongthumte loong ah ih ehanhan ih choophaan rum ano daap haat nyuuta. Wanyi asuh tiim uh tami li rumta ekoong ah de kano miloong ah ih Rangte rangphoong rum kano ah. ");
INSERT INTO tvt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ekoong ang arah deeta mih ah paang rookbaji nang ih ehan angta. ");
INSERT INTO tvt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pitar nyia Joon daap haat damdam ih nengnyi joon loong ah taang ni ngaak wang nyuuta, eno Romwah phokhoh nyia mihak phokhoh loong ih liita jengkhaap ah baat nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Erah chaat rum ano, Kristaan loong eroom ih lomtong rum ano neng Rangte rangsoom rumta: “O Elongthoon Teesu, an juuba rangmong nyia juukhu hakong dongsiitte, juusih nyia hemong ni tongla loong Dongsiitte, Changte wah! ");
INSERT INTO tvt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Sengte sengwah an laksuh Dewid suh Esa Chiiala nawa ih jeng thuk kuno jengta, ‘Ranglajatte loong ah tiimnge ih khah rumla; miloong ah ih lalangka ah tiim kaankoong rumta? ");
INSERT INTO tvt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Arah hah dowa Luuwang loong ah ih neng teeteewah ih khookhamta, nokpan tangpante loong ah eroom ih lomkhoon rumta Teesu Kristo miksuk kaanju suh ah.’ ");
INSERT INTO tvt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Hirod nyia Poontias, Pilat loong ah arah samnuthung dowa Ranglajatte loong nyia Ijirel noksong damdi an Laksuh Jisu tiit jen roongwaan ih rumla. ");
INSERT INTO tvt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Anchaan anphaan nawa ih mamah angtheng ngeh ih thiin tu ah erah angthuk suh chothum rumla. ");
INSERT INTO tvt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Teesu, amadoh, seng choophaan hali ah sokkaat weeho, eno lacho laphaan ih baattaan suh chaan aphaan kokaat he. ");
INSERT INTO tvt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Khoisatte deesiit theng chaan aphaan raangtaan ih an lak janghaat kaat ho, toongtang Jisu mendoh paatjaajih loong jen noisok theng ah.” ");
INSERT INTO tvt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Neng rangsoom lilih, erah khoontong rumta di hah ah moh eta. Neng loong sak ni Esa moong achaang ah ra haano Rangte jengkhaap ah lacho laphaan ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jisu liphante loong ah tenthun siit ang rumta. Neng huikhaak ang ah bah uh arah nga lakbui angta ngeh ih tali rumta. ");
INSERT INTO tvt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Rangte chaan aphaan ah kap rum ano Heliphante loong ah ih Jisu ngaaksaat tiit ah lacho laphaan ih baat rumta, erah thoidi Rangte ih neng loong asuh romseetam koh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Neng dung dowa o uh bootbe thoomramte tajeeta. O jiinni phek nyia nok jeeta, neng loong ah ih erah sangleh, ");
INSERT INTO tvt_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ngun ah heliphante loong suh koh rumta; enooleh o ih tiimthan thaangta erah than ru ih pheekoh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Erah likhiik ih kotte wasiit, Josep ngeh ih angta, heh Kaipras ni tup arah Lewi nok hah angta, eno heliphante loong ah ih heh men ah Barnabas ngeh ih poon rumta (Erah men ah langla “Mih suh chaan kotte), ");
INSERT INTO tvt_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","eno heh phek ah sang ano, ngun ah heliphante danjeeta loong asuh kota. ");
INSERT INTO tvt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Enoothong Ananias ngeh ih mih wasiit angta, nengnyi heh minuh Sapphira ih nyamka jaasiit sang nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Eno nengnyi heh minuh roongwaan nyu ano ngun khooko ah tangthiin nyu ano heliphante loong asuh koh nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pitar ih Annania suh liita, “Esa Chiiala ngathong ni Soitaan ih tiim esuh tiit hu baat thuk halu ngun rukho ah tangthiin ansih no ah? ");
INSERT INTO tvt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Maangsang di, nyaamka ah an lakbui angta; esang lih di ngun ah an lakbui angta. Eno, erah likhiik an tiimnge ih reelu? An ih mina tamokwaan hu—Rangte mokwaan hu!” ");
INSERT INTO tvt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Chaat damdam ih, Annania ah loongtiita; erah Ruurang chaatte loong ah rapne ih choota. ");
INSERT INTO tvt_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jaaro loong ah wangrum ano, heh mang ah thooploop rumta, eno bengkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Koonta jom lidi, heh minuh ah tiim uh lajat thang ih nop wangta. ");
INSERT INTO tvt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pitar ih erah nuh asuh we banchengta, “Baat thaak hang, set soomiwah ih hah sang tansih thaang ah erah than ju nih angta?” “Em,” “thoontang erah thanju angta” Erah nuh rah ih ngaak baatta. ");
INSERT INTO tvt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Erah thoidi Pitar ih erah nuh asuh liita, “Set soomiwah ih Teesu Chiiala ah tiim esuh thaak taari hansih? An miwah mang bengkaatte loong ah kaalu thong ni chapla, neng ih an uh dokpi ih kaat ho!” ");
INSERT INTO tvt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lakdamdam di Sapphira ah Pitar lak khoni loongtiita. Jaaro loong ah nopwang rum adi, heh mang ah japtup rum ano heh miwah reeni bengkaat suh dokpi kaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Arah Ruurang chaatte nyia Kristaan loong ah rapne ih cho rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kaamwah loong ah mih dung ni paatjaajih loong ah rapne ih mokah rumta. Kristaan loong Solomon nokka ngeh men rumta adi khoontong rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Neng damdi wahote o uh tanaan roongtong rumta, erabah uh miloong ah ih neng tiit rapne ih seebaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Enoothong minuh miwah, ehanhan ih jaat rum ano Teesu rangsoomte ih hoon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kaamwah loong ah ih paatjaajih loong noisok rum kano, khoisatte loong ah lam ni piikaat rumta, rukho ah juptheng ni rukho ah dam ni jupthiin wan rumta, erah langla lam nah Pitar daankhoom adoh heh laaphaang ih toom wiithuk ah ngeh ih thiinwan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalem ko nawa miloong ah ih, khoisatte loong nyia chiithih laakhah ih paklakta loong ah deesiit suh siitwan rum taha. ");
INSERT INTO tvt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Enoothong Romwah phokhothoon nyia heh joon loong, neng damdi Sadusi nok hah roop rum ano kaamwah loong ah rapne ih miksuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Eno kaamwah loong ah phaatak ni josak rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Erah rangphe adi Teesu rangsah ih paakaalu ah daap kah ano kaamwah loong ah dokkhoom kaat thuk rum ano phanbaat rumta, ");
INSERT INTO tvt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Rangteenok nah kah anno miloong asuh roidong tiit ah baatkaat an” ");
INSERT INTO tvt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Heh jeng ah kap rum ano kaamwah loong ah ih rangkhano di Rangteenok ni phang nyootsoot karumta. Romwah Phokhothoon nyia heh joon loong ah ih Jehudi nok hah dowa mihak phokhoh loong ah Nokwah ngoongthum theng ni thumpoon rumta; eno kaamwah loong ah phaatak nawa poonwang thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Enoothong neng toonsiitte loong ah taatkah rum ano, kaamwah loong ah phaatak ni amuh ang rumta, erah thoidi Nokwah ngoongthum theng ni ngaak baatkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Phaataak ni thok eno, kaasak ah rapniine ih sak arah angta, bante loong ah uh paakaalu ni chap rumta; eno kaalu ah daapsok eno nokmong ni o uh tajeeta!” ");
INSERT INTO tvt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Erah ruurang ah chaat rum ano Romwah phokhoh nyia rangsoomnok dowa saahaap loong ah kaamwah loong ah tiim angla ngeh ih paatja rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Erah di mih wasiit wang ano baat rumta, “Boichaat thaak an! Phaataak ni sak tan loong ah ih bah Rangteenok ni nyootsoot rumha!” ");
INSERT INTO tvt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Erah raangtaan ih saahaap wasiit ih heh mina loong ah siit ano kaamwah loong ah ngaak toonsiit kata. Mih ih jong ih pat ra cho ih, kaamwah loong ah labuthom thang ih siitwan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kaamwah loong ah Nokwah reeni siitwan rum ano, neng ngathong ni toonchap thuk rumta, eno Romwah Phokhoh ih cheng rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Sen suh heh mendoh nakkah nyootsoot an ngeh ih baat choi,” eno we dopjengta; “sokthaaak an sen loong ah ih tiimjih hoon han! Sen ih nyootsoot han ah Jerusalem hah noongrep ni puupa thuk lan, eno Jisu tek haat ah seng mat ih joot thuk suh liihan!” ");
INSERT INTO tvt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pitar nyia heh kaamwah loong ah ih ngaakli rumta, “Seng ih Rangte jengkhaap kap theng, mina jengkhaap tah angka. ");
INSERT INTO tvt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jisu bangphak khoni tekrapbot tan lini, sengte sengwah Rangte ih tek nawa ngaakthing ih thukta. ");
INSERT INTO tvt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Rangte ih ngaak saatsiit ano Lamsiitte nyia mina Pangte toom ang ah ngeh ih jaawah ko ih tong thukla, eno Jerusalem mina loong suh neng rangdah sekthun thuksuh nyia biin anaan chosuh saapootse koh rumha. ");
INSERT INTO tvt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Esa Chiiala nyia seng loong ah arah tiit haaki kotte—Esa Chiiala ah heh jeng boichaatte loong raangtaan ih Rangte lakkot.” ");
INSERT INTO tvt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ngoongthumte loong ah erah jeng ah chaat rum ano rapne ih khadah rumta, kaamwah loong ah tek haat etheng ngeh ih li rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Enoothong neng dung ni, Pharisi nok hah Gamaliel ngeh ih wasiit angta, erah wah ah Hootthe nyootsootte, nyia warep ih phoongpha arah mih angta, eno Nokwah dung dowa heh toonchapta. Heh ih baat rumta, kaamwah loong ah pootsiit than doksiit kaat thaak an, ");
INSERT INTO tvt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","erah lih adi Nokwah suh li rumta, “Ijirel phoh ano loong, arah miloong ah damdoh sokthun samthun ih re theng. ");
INSERT INTO tvt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Taat samthun thaak an ehakdi Theudas ah ngah thoonrak lang liite dongta eno chaabaji mih heliphante uh wakdong eta. Eno heh teewah ah tek haat kano, heliphante loong ah saapsoon e rumta, heh ruurang ah uh tikmat eta. ");
INSERT INTO tvt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Erah lih adi, mih khoh rookwet tokdi, Galili nok hah Judas dongkhoom taha, heh mih hantek siitta, erah uh tek haat eta eno heliphante loong uh saapsoon e rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Erah likhiik doh, ngah ih baat rumhala, arah miloong asuh tiim uh lali theng. Neng tongtong toom ih rum ah! Tiim re rumla, tiim thun rum ha mina mongtham ang ah bah hetik matmat ih ah, ");
INSERT INTO tvt_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","enoothong Rangte mongtham ang abah sen ih tiim uh tajen ekan, senteewah Rangte damdoh rookmui anrah ba tup an!” Gamaliel ih renbaat rumta jengkhaap ah Nokwah ih kap erumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kaamwah loong ah noppoon wanrum ano, ruh ih buh rumta, arah dowa ih Jisu mendoh mabah uh nakkah baattaan an ngeh ih baat rum ano daap haat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kaamwah loong ah Ngoongthum theng nawa tenroon woksoon ih doksoon karumta, tiimnge liidi, Jisu thoilam doh neng loong ah ih cham anaang ah jen naan ih rum ah ngeh ih Rangte ih danje arah ang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Eno Rangteenok ni nyia nok rookweh ni neng loong ah ih Ruurang Ese tiit nyia Jisu Kristo tiit ah nyootsoot roh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Erah lih ang ano, heliphante loong ah jaatjaang ih wang rumta, Grik jengjengte Jehudi loong nyia hanok dowa Jehudi loong ah nengneng laktung ni changrook waangti ang rumta. Grik jengjengte Jehudi loong ih liita jootiinuh adoleh thaknuh loong ah ih saarep chotheng phaksat ah rapniine ih tachoh rumka. ");
INSERT INTO tvt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Erah thoidi asih wanyi kaamwah loong ah ih hanpiite loong ah lompoon rum ano baat rumta, “Ngun thiin raangtaan ih Rangte jengkhaap nyootsoot ah seng loong ah tami phaangdat ke. ");
INSERT INTO tvt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Phoh ano loong, erah raangtaan ih, seng loongdung dowa o sak ni Esa Chiiala adoleh mongtham ese jeela erah likhiik mih ah ngun thiinte danje theng. ");
INSERT INTO tvt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Eno juuba Rangte tiit ah rangsoom rangphoong ih jen nyootsoot ih.” ");
INSERT INTO tvt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Heliphante loong ih renbaat rumta mongtham ah kap ih rum ano, mina loong ah ih, kamkam tuumaangte nyia moongte chaangte Stephen, Philip, Prokoras, Nikanor, Timon, Parmenas, nyia Entiok nawa Nikolas maangdi Jehudi angta loong ah danje rumta. ");
INSERT INTO tvt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Arah miloong asuh heliphante loong ah ih neng khoh nah taajoh rum ano rang toom soomkoh rum ah ngeh ih neng reeni wangthuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Erah thoidi Rangte jengkhaap ah noongrep ni ruurang roh eta. Heliphante loong ah Jerusalem ni weewe jaatjaat eta, erah damdi romwah hantek ih Jisu laalom tiit ah hanpi rumta. ");
INSERT INTO tvt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephen suh Rangte ih chaan aphaan ah koh ano, miloong dung dowa mih paatjaajih loong ah noisok ih thukta. ");
INSERT INTO tvt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Enoothong Jehudi rangsoomnok nawa Dalang saachoi (ngeh ih men rumta), mararah mina loong ah Stephen damdi daanmui e rumta, erah di Kiren nyia Alekjendria nawa Jehudi nok hah nep angta. Silisia nyia Esia hah nawa Jehudi loong ah nep ih Stephen damdi jengmui rumta. ");
INSERT INTO tvt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Enoothong moong achaang ih Stephen suh erah likhiik chaan kota, heh jeng kano o uh tami daanjeng rumta. ");
INSERT INTO tvt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Erah raangtaan ih mararah mih asuh tiit hu baatthuk rumta, “Seng ih bah Moses nyia Rangte kaanju arah chaat hi!” ");
INSERT INTO tvt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Emah ih diip mokwaan rum ano, noksong nyia mihak phokhoh loong, hootthe nyootsootte loong ah khat thuk rumta. Neng loong ah ih Stephen ah jorum ano Ngoongthum theng ni siitwan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Eno mih wajombaji ih tiit hu baat thuk suh ngeh ih waksiit rumta. “Arah mih,” ah ih “saarookwet seng Rangteenok nyia Moses Hootthe tiit ah pak thetbaat ha. ");
INSERT INTO tvt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Seng ih emah jeng arah chaat hi, Najaret dowa Jisu ih Rangteenok ah thaak haat ih ah eno Moses jiin nawa neem arang loong ah elek et ah!” ");
INSERT INTO tvt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ngoongthum theng ni tongte loong ah ih Stephen taangko sok rum adi, hethe hekhoh ah rangsah the akhoh likhiik ih japtup rumta. ");
INSERT INTO tvt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Romwah phokhothoon ah ih Stephen suh chengta, “Amiisak nih angkah?” ");
INSERT INTO tvt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen ih ngaak baatta, “Ngaaphoh ngaawah loong nga jeng ah boichaat an! Sengte sengwah Abraham Haraan hah ni maang song kah kaadi, Mesopotomia hah ni ");
INSERT INTO tvt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Rangte dongkhoom kah ano baatta, ‘An hadaang nyia an jaatang ah thiinhaat uno ngah ih marah hah doh kaat baat ha erah doh kah uh.’ ");
INSERT INTO tvt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Erah raangtaan Abraham ih heh hadaang ah thiinhaat ano Haraan hah ni song kata. Heh wah tek lidi, Rangte ih sen amadi song lan hah adi kaat thuk taha. ");
INSERT INTO tvt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Rangte ih Abraham suh arah an hah ngeh ih baatkot muh, amasah chepsiit taan uh kotmuh, enoothong Rangte ih Abraham suh kot eha ngeh ih ba kakhamta adoleh ansuh ansah lakbui ang ah ngeh ih thoomhoon kakhat ah ba hoon eta, erah kakham ah Abraham heh sah maang jeeka tokdi hoonta. ");
INSERT INTO tvt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Rangte ih Abraham suh baatta: ‘An sutoom satoom loong ah minok mihah nah song rum ah, erah doh neng loong ah chaabaji paang raangtaan ih dah ih siiwi rum ah. ");
INSERT INTO tvt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Enoothong an sutoom satoom loong ih soomtu rum ah mina loong ah ngah ih dande kah rum ang, erah lidoh erah hah dowa doksoon rum ano arah hah adoh ngaak song rum haano nga somtu rum hang.’ ");
INSERT INTO tvt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Eno Abraham damdi thoomhoon kakhat thiinta ngeh ih jat suh Rangte ih heh khoopkhan banlam ah hoonthuk rumta. Erah thoidi Esak ah tup ano saasinat lidi heh khoopkhan ano men hoonta; Esak ih heh sah Jaakob khoopkhanta, eno Jaakob ih heh sah asih wanyi ah khoopkhan banlam hoonta. ");
INSERT INTO tvt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jaakob sah loong ih neng no Josep ah miksuh ih rum ano Ijip hah ni dah raangtaan ih sang rumta. Enoothong Rangte ah heh damdam eta, ");
INSERT INTO tvt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","erah thoidi Josep ah mathan laang chamta bah uh Rangte ih puipang eta. Ijip Luuwang damdi Josep chomuita di, Rangte ih Josep suh mih tenroon thuk theng nyia mongtham ese ah kota, eno erah hadaang adi Luuwang ih Josep ah kobono nyia henok hetap jaatrep sokboite ang thukta. ");
INSERT INTO tvt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Erah lidi, Ijip nyia Kanaan hah noongrep ni ram ang ano rapne ih cham rumta. Sengte sengwah loong ih phak asat ju choh jam muh, ");
INSERT INTO tvt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","eno Jaakob ih Ijip hah ni ji acham eje ngeh ih japchaat ano, sengte sengwah, heh sah loong ah phangkaat thukta. ");
INSERT INTO tvt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dopnyi kah rum adi, Josep ih hephoh loong suh heh teewah tiit ah jatthuk rumta, eno Ijip Luuwang ih uh Josep jaatang tiit ah jat eta. ");
INSERT INTO tvt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josep ih heh wah suh maatbaatta, neng jaatang rooksinet wabangnga ah loongtang Ijip hah nah kaat theng ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jaakob nyia heh sah loongtang Ijip hah ni song karum ano erah ni matti karumta. ");
INSERT INTO tvt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Neng mang ah Sekem hah ni huikaat ano, Abraham ih Haamor jaatang jiin nawa ngun ih reta di bengkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Rangte ih Abraham damdi thoomhoon kakhatta saapoot ah chang kano, Ijip hah ni seng mina hasong ah jaat eti. ");
INSERT INTO tvt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Erah lih adi, Josep men lajatte mih Ijip Luuwang we angta. ");
INSERT INTO tvt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Eno Luuwang ah sengte sengwah loong damdi rapne ih thikhah ano, neng sah khobaang loong ah tektoom ih ah ngeh ih li ano, thoikatkat ih neng nok nawa ehoh ni tum thiin thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Erah tokdi, Moses ah jaaseemoong sah ih dongtupta. Moses ah nok ni laajom sokboita, ");
INSERT INTO tvt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","eno heh nok nawa thiinhaat kaat kano, wangcha nah rah ih heh raangtaan suh hakpanta. ");
INSERT INTO tvt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses suh Ijip nok hah tiit jirep ah nyootsoot kano jatwah jeewah eh hoonta. ");
INSERT INTO tvt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses paang rookbaji ang ano, hejaat hepaat ah mamah ih siiwi rumta erah ah jat suh ngeh ih jam thoithakta. ");
INSERT INTO tvt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Heh mina wasiit Ijip mih ih siiwi ah japtup ano, Moses ih erah mih ah etek haat eta. ( ");
INSERT INTO tvt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses ih thunta, heh mina loong ah ih baata jatrum hangnih, ngah Rangte ih neng doksiit suh daapkaat halang ngeh ah, eno heh mina loong ah ih tajat rumta). ");
INSERT INTO tvt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Erah saalih adi Ijirel nok hah wanyi botmui arah japtup ano paakpang damdi taat renbaat nyuuta. ‘Boichaat thaak ansih,’ jaaroh nyi, ‘set Ijirel mina tanih ang kansih; tiimte botmui lansih?’ ");
INSERT INTO tvt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Eno o ih wasiit ah siiwiita erah mih ah ih Moses ah haangko pitthengta. ‘Sek laktung nah an ih dande theng ngeh ih o ih poon halu?’ ");
INSERT INTO tvt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Miinnyah Ijip nok hah tekbuh tang ah likhiik tekbuh ang ngeh ih nih li halang?’ ");
INSERT INTO tvt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses ih erah jeng ah japchaat ano, Ijip hah nawa Midian hah ni soonkah ano moong songtong kata. Erah ni heh sah miwasah wanyi tupta. ");
INSERT INTO tvt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Paang rookbaji lini, Moses ngathong ni Rangte kaamwah ah Sinai Kong ni phisaang hah ni weelu damdi dongjengta. ");
INSERT INTO tvt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Erah japtup ano, Moses ah rapne ih paatjaata, eno rapniine ih sok suh weeluuta adi tiitkhoom kata. Eno Teesu jengta ah japchaatta; ");
INSERT INTO tvt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ngah ante anwah Rangte, Abraham Rangte, Esak nyia Jaakob Rangte.’ Moses ih lanaan sok thang ih mochoota. ");
INSERT INTO tvt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Teesu ih Moses suh liita, ‘An lasong ah khook haat uh an chaplu ah Esa hah. ");
INSERT INTO tvt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ijip ni nga mina loong rapne ih cham arah japtup hang. Nenghu nengri chaat hang, Ngah neng doksiit puipang suh ra halang. Amadoh raaho; Ngah ih an Ijip hah nah kaat thuk ha.’ ");
INSERT INTO tvt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses ah Ijirel mina ih thaangju et arah mina angta. ‘Seng pante nyia maat hoonte angtheng ngeh ih o ih thiik halu?’ Miloong ah ih emah kali rumta. Enoothong weeluuta adi Rangte dongjengta, Moses ah noksong pante nyia doksiitte, heh damdoh rangsah roong mokah ah ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses ih, Ijip hah ni nyia Juusisaang (Juusih esiit je ah, erah amadi uh erah suh juusih essang ngeh ih menha) adi nyia phisaang hah ni mih paatjaajih loong ah noisok ano heh mina loong ah Ijip hah nawa doksiit dowa. ");
INSERT INTO tvt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses ih Ijirel noksong suh baatta, ‘Rangte ih, ngah kaat thuk halang ah likhiik khowah kaat thuk ha, eno erah mina ah sen mina dowa ang ah.’ ");
INSERT INTO tvt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses ah Ijirel mina loong damdi phisaang hah ni tum roongtong rumta; sente senwah loong nyia rangsah damdi Sinai Kong ni kah chowaanta, enooleh Rangte khothing jengkhaap ah seng suh toombaat tahe. ");
INSERT INTO tvt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Enoothong sengte sengwah loong ah ih Moses jeng ah taboichaat rumta; heh jeng lalek boichaat thang ih Ijip hah ko we ngaakwang thung ang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Erah thoidi neng ih Aroon suh li rumta, ‘Seng lamsiitte Rangte hoon kohe. Ijip hah nawa seng doksiitte, Moses bah tajatke tiim ang koja.’ ");
INSERT INTO tvt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Erah lilih, maan laaphaang tongmih hoon rum ano, roomsoom rumta, erah lih adi neng ih hoonta tongmih phoongpha mendi phaksat ah room phaksah ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Erah thoidi neng Rangte ah neng dam dowa doksoon ano rang dowa ritsih nyia rang ni tiimjih jeela erah loong ah soomtu thuk rumta, erah tiit ah khowah loong leedap ni raangthiin choi: ‘Ijirel noksong loong! Phisaang hah ni paang rookbaji angtan adoh luiamaan ah nga soomtu suh tadook tan. ");
INSERT INTO tvt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Erah tumhui tan abah, Molek Rangte raangtaan ih angta; adoleh ritsih rangte, Rephan laaphaang raangtaan ih; erah loong abah sen ih soomtu theng tongmih angta. Erah raangtaan ih sen loong ah Bebiloon jiit nah phanhaat kaat rumha.’ ");
INSERT INTO tvt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Sengte sengwah loong ih bah phisaang hah ni Rangte waktong theng Nyutaap ah neng damdam ih tumhui rumta. Erah mamah ih hoon theng ah, Rangte ih Moses suh noisokta ah likhiik ih hoon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Lini, sengte sengwah loong ih neng wah jiin nawa thaangta Nyutaap ah Josua damdi wakkah rumta di neng damdam ih tumhui rumta. Eno Rangte ih mathan deek akaan angta loong ah nengngah nengngah ih tum phanjoh haatta. Erah Nyutaap ah Dewid, Luuwang maang langlang ih erah hadaang adi thok tongta. ");
INSERT INTO tvt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Rangte ih Dewid suh ese choh kano Dewid ih Jaakob Rangte nok hoon thuk weehang ngeh ih suta. ");
INSERT INTO tvt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Enoothong erah rangsoomnok ah Solomon Luuwang ih liwang ni thoon tom hoonta. ");
INSERT INTO tvt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Enoothong Echoong thoon ni tongte Rangte ah mina ih hoon hi nok ni tatongta; khowah ih liiha likhiik ah, ");
INSERT INTO tvt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Rangmong ah nga tongtheng, nyia hah ah nga lah naktheng, Teesu ih liiha, Nga raangtaan ih sen ih tiim nok ma hoon an? Nga tongtheng nok ah mani ah? ");
INSERT INTO tvt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Arah loong ah nga lak ih tanih hoontang?’ ");
INSERT INTO tvt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Senten senmong ah jong ajaan likhiik mamah angtan!” Stephen ih arah tiit ah jangbaat roh ih kaatta. “Sen thung ah mamah sengseng angtan, Rangte tiitkhaap chaat suh sen na ah mamah sengseng ih baang tan! Seng loong ah sente senwah likhiik; sen ih uh Esa Chiiala ah saarookwet takap kan! ");
INSERT INTO tvt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sente senwah ih khowah lasiiwiite eje nih ah? Teewadi Laksuh kateng ah erak eha ngeh ih Rangte tiit baat kaatte ah uh neng ih tek haatta. Eno sen ih erah mih ah mokwaan anno tek haat han. ");
INSERT INTO tvt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Rangte hootthe ah rangsah jiin nawa choh thaangte sen loong ah —erabah uh heh jeng ah taboichaat kan!” ");
INSERT INTO tvt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ngoongthumte loong ah Stephen jeng ah chaat rum ano, neng pha ah phak ah ih khadah rumta. ");
INSERT INTO tvt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stephen ah Esa Chiiala pan angte angta, rangko toon sokwan adi Rangte chaan aphaan nyia Jisu jaawah ko ih chap arah tupwanta. ");
INSERT INTO tvt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Sok thaak an!” Stephen ih baat rumta. “Rangmong ah daapchoi tupwan lang, erah di Mina Sah Rangte damdi jaawah ko chap arah tupwan lang!” ");
INSERT INTO tvt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ngoongthumte loong ah riiraak rum ano neng na ah neng lak ih kepjoh rumta. Miloong ah Stephen taangko ih tuutmui karum ano, ");
INSERT INTO tvt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","erah samnuthung dowa dokphan haatkaat rumta, eno Jong ih patkaat rumta. Erah tupte haaki loong ah ih neng nyuh nengkhat ah jaaro wasiit Sool ngeh ih angta, reeni thiinhaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Jong ih patrum ah damdi Stephen ih Teesu men ah poon ano rangsoomta, “Teesu ngaachi ngaala ah thaang hang!” ");
INSERT INTO tvt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Stephen ah heh lakuh ni chooktong ano eroongwah ih riihuuta, “Teesu! Neng rangdah ah nak samthun weeuh!” Emah ih jeng ano thaktiita. ");
INSERT INTO tvt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Stephen tek haat thukte ah Sool angta. Erah sa adi Jerusalem hah ni kristaan loong ah rapne ih siiwi rumta. Samaria nyia Judia hah noongrep ni Kristaan loong ah tiisoon rumta, Heliphante loong ah ba soon muh. ");
INSERT INTO tvt_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Rangte jatte mina loong ah ih Stephen mang ah rongrongwah ih hu ari damdi bengkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sool ih chaas jeeje ah thet haat taat chungta; nokrookwet ni tumkhoom ano, minuh miwah Jisu suh hanpiite loong ah thoontang dok hoom kaat ano phaatak ni sakkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Noongrep ni tiisoonta hanpiite loong ah ih Rangte tiit ah tumbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Samaria hah ko samnuthung longthoon ni tongte miloong asuh Philip ih Kristo tiit ah baat kaatta. ");
INSERT INTO tvt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Philip ih baat rumta tiitkhaap ah mih lomkhoonta loong ah ih rapniine ih thaangchaat rumta, heh jeng boichaat rum adi Philip ih paatjaajih loong ah reeraang nyia noisok rumta. ");
INSERT INTO tvt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Chiithih laakhah ah mina loong sak nawa riihu leh doksoon eta, erah damdi huimu nyia ekoong loong ah de ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Erah thoidi erah hadaang adi rapne tenroon woksoon ih tong rumta. ");
INSERT INTO tvt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Erah samnuh hah adi Simoon ngeh ih mih wasiit angta, heh ih Samaria dowa mina loong asuh pootsiit maantaan kanoisok rumta. Heh ih liita ngah mina elong esiit, ");
INSERT INTO tvt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","eno erah samnuthung dowa, kurep wangrep ih, heh jeng ah naaririh ih boichaat rumta. Miloong ah ih liita, heh jiinni juuba “Rangte chaan aphaan “Eloongthoon Chaan aphaan” ah jeela. ");
INSERT INTO tvt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Miloong asuh maantaan ah rekamdook ih noisok rum kano heh jeng boichaatte totoh ang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Enoothong Philip ih Rangmong Hasong nyia Jisu Kristo ruurang ese tiit ah baat rum kano, hanpi ih rumta, eno minuh miwah loong ah juutem rumta. ");
INSERT INTO tvt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon ih nep hanpiita; eno heh uh juutemta, erah lih adi Philip damdam tong ano paatjaajih ah noisok kano Simon ah rapne ih paatjaata. ");
INSERT INTO tvt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kamwah loong ah Jerusalem ni angrum adi Samaria nok hah ih Rangte jengkhaap kap eha ngeh ih japchaat rum ano, neng reeni Pitar nyia Joon kaat thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Erah ni thoknyu ano, Kristaan loong sak nah Esa Chiiala toom pah ah ngeh ih rang ah soomkoh ih nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Esa Chiiala ah o sak ni uh maangpat angra taha; Teesu mendi juutem luulu phang kap rumta. ");
INSERT INTO tvt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pitar nyia Joon ih neng khoh ni nengnyi lak ih tajoh nyu ano rangsoom kot kano ba Esa Chiiala ah pah ra taha. ");
INSERT INTO tvt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kamwah loong ah ih Kristaan loong khoni joh ano rangsoom kot kano Chiiala pah arah Simon ih japtupta. Erah thoidi Simon ih Pitar nyia Joon suh ngun ah konyu ano ");
INSERT INTO tvt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","baat nyuuta, “Arah chaan ah ngasuh nep koh weehe tih, mikhoh nah taajoh angdoh Esa Chiiala toom pah raaha suh ah.” ");
INSERT INTO tvt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Eno Pitar ih ngaak liita, “Rangte lakkot ah ngun ih reh ang ngeh ih thun hu bah, an ngun ah hui uno soolam nah toom wang uh! ");
INSERT INTO tvt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Rangte mootkaat nah seng damdoh an tami room ru, timnge liidoh Rangte miksok di an tenthun ah kaateng tah angko. ");
INSERT INTO tvt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Erah raangtaan, an ih sekthun ih uh, an tenthun mongtham ethih thunhu, eno erah likhiik ethih thunhu ah biin anaan toom eh ho asuh Teesu rangsoom uh. ");
INSERT INTO tvt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","An thidokdok mih siikhaamte nyia rangdah khui ni ang uh rah tup hala.” ");
INSERT INTO tvt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon ih Pitar nyia Joon suh li nyuuta, set ih Teesu suh rangsoom koh weehe tih, erah li hansih ah likhiik nga taangnah nak toom thok weethuk ha.” ");
INSERT INTO tvt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nengnyi khiikkhi nyia Teesu jengkhaap ah baat nyu ano, Jerusalem ni ngaakwang nyuuta. Samaria ni hadaang hantek ni Ruurang Ese tiit ah lam jangtang ih baatwan nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Teesu rangsah ih Philip suh liita, “Jerusalem dowa ih Gaja ko kala lam adoh juumeh ko ih kaat suh khookhaam uh” (Arah lam adi mih amadi tah khoomka.) ");
INSERT INTO tvt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Erah baat kano, Philip ah khookhaam ano dokkhom kata. Eno Ethopia wangcha nuh ngun thiinte, daamhun wasiit, heh nok ni ngaakwangte chomuita. Erah warah Jerusalem ni Rangte rangsoom kah ano mokkaari ni nok ni ngaak wangte angta. Heh lamni soon adi, Isaia khowah ih raang arah leedap weta. ");
INSERT INTO tvt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Esa Chiiala ih Philip suh baatta, “Mokkaari ko kah uno heh re tiittiit ih chap kah uh.” ");
INSERT INTO tvt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Philip soon kata adi khowah Isaia leedap banweh arah japchaat kata. Eno Philip ih chengta, “An ih wehu adi tiimjih liiha jat nih hu?” ");
INSERT INTO tvt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Saahaap ah ih ngaakbaatta, “O ih uh lahuk sekbaat rangbah mamah ma jat ang?” Eno Philip ah mokkaari adi heh damdi roongtong suh duupoonta. ");
INSERT INTO tvt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Rangteele erah weta adi amah raangta: Saap ah dook esuh siitkaat ah likhiik, saapsah heh roon sui adi lahu lari thang kah ang ah likhiik, heh khaapsiit taan uh jengmuh. ");
INSERT INTO tvt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Heh kaanju ih rumta, tiim lathika di thetbaat rumta. Heh sutoom satoom loong tiit ah o ih uh tajen baatka, timnge liidi arah hah adi heh roidong ah thoon ih kata.” ");
INSERT INTO tvt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Saahaap ah ih Philip suh chengta, “Baat thaak hang, khowah ih liiha ah o suh liiha? Heh teewah tiit tam wahoh tiit baat ha?” ");
INSERT INTO tvt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Eno Philip ih phangbaatta; Rangteele erah dowa phangbaat ano, Jisu Ruurang Ese tiit ah baatta. ");
INSERT INTO tvt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Philip nyia saahaap ah lamdat ko ih daatsoon kanyu adi, joisah esiit japtup nyuuta, eno saahaap ah ih liita, “Arah di ju cheesah je ah. Ngah laang ah juutem suh tanih nook kang?” ");
INSERT INTO tvt_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philip ih liita, “An ten nawa ih jen hanpi ubah juutem ah ejen tem ih uh.” “Hanpi ih hang,” heh ih ngaak baatta; “Nga ih Jisu Kristo ah Rangte Sah ngeh ih hanpi ehang.” ");
INSERT INTO tvt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Saahaap ah ih mokkaari ah tangchap thukta, eno nengnyi Philip ju ko ih daatkhoom kanyu ano, Philip ih heh ju ah temta. ");
INSERT INTO tvt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ju nawa dokkhoom nyuuha di, Teesu Chiiala ih Philip ah soonsiitta. Saahaap ah ih Philip ah takah chotupta, eno tenroon woksoon heh lamko ih wangta. ");
INSERT INTO tvt_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Philip heh teewah Ajotaas ni ang arah japtupta; eno Ruurang Ese tiit ah hadaang rep ni lam jangtang ih Kaisiria maang thokthok ih baat wanta. ");
INSERT INTO tvt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Erah tokdi Sool ih Teesu liphante loong ah tek haat etheng ngeh ih tum choophaan rumta. Romwah phokhothoon taang ni heh wang ");
INSERT INTO tvt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ano Damaskas dowa Jehudi rangsoomnok ni tongte damdoh menjat hoonkaat suh le raangkoh hang ngeh ih suh wangta, tiimnge liidi erah nah o bah uh Teesu Lamphante mok japtup abah, minuh miwah joh ano, Jerusalem nah ngaak siitwan suh ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Eno Sool Damaskas hah reeni thokkhoom adi, rang nawa baaphuk ih weephaak ano heh teewah ah kookrak ih kaangtookta. ");
INSERT INTO tvt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sool ah hah ni loongdat adi heh suh li arah japchaatta, “Sool, Sool! An ih ngah tiim esuh siiwi halang?” ");
INSERT INTO tvt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Teesu an o ang weelu?” Sool ih ngaak chengta. “Jisu, an ih siiwi halang ah” Mih root ah ngaak jengta. ");
INSERT INTO tvt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Eno saatchap uno samnuthung adoh kah uh, an tiim reetheng ah erah nah baat ho eno an re jaatjaat etheng ang ah.” ");
INSERT INTO tvt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sool damdi roong kaatte miloong ah, khaapsiit taan uh lajeng ih tangchap rumta; mijeng abah chaat ih rumta enoothong neng mik ih tatup rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sool ah hah nawa saatchap ano heh mik taat kaasokta, eno tiim uh tatupta. Erah thoidi heh lak ni siit rum ano Damaskas ko karumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sool sa jom edook angta di, tiim uh taajok phaksata. ");
INSERT INTO tvt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskas hah ni mih wasiit Ananias ngeh ih Kristaan mina angta. Erah mih ah ih motmang ni tupta, Jisu ih poonta, “Ananias!” “Ani, Teesu” Ananias ngaak jengta. ");
INSERT INTO tvt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Teesu Jisu ih hesuh baatta, “An Lamjang lamjang ih kah uh, Judas nok ni Tarsas nawa raaha rah heh men ah Sool ngeh ih cheng kah uh. Heh ih amadi rangsoomha, ");
INSERT INTO tvt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","eno heh motmang ni mih wasiit heh men ah Ananias ah nopwang ano heh mik ah we ngaakka thuk suh heh khoh ni taajoh arah japtup ha.” ");
INSERT INTO tvt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias ih ngaakbaatta, “Teesu, arah mih ah tiit ah warep ih chobaat halang an mina loong ah Jerusalem ni mamah ih siiwi rumha erah ah. ");
INSERT INTO tvt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Eno Romwah phokhoh loong ah ih Damaskas dowa an rangphoongte loong ah jootkhak thuk suh chaan ah korum ano kaat thuk rumhala.” ");
INSERT INTO tvt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Teesu ih Ananias suh baatta, “Kah uh, erah mih ah ngah mootkaatte danje hang, Ranglajatte nyia neng luuwang, adoleh Ijirel dowa miloong asuh nga men jatthukte angthuk ang. ");
INSERT INTO tvt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Eno nga raangtaan ih heh mathan cham theng ah erah ah thoontang noisok ang.” ");
INSERT INTO tvt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Erah raangtaan ih, Sool tongta nok adi nop kah ano, Ananias ih heh khoh ni taajoh kata. “Ephoh Sool,” Ananias ih liita, “Teesu Jisu—heh teewah ih kaat thuk halang, an ani ra taho di lam ni an suh tup ih thuk taho. Ngah heh ih kaat thuk halang, an ih we tup toom ih uh nyia an sak nah Esa Chiiala toom raaha ngeh ah.” ");
INSERT INTO tvt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Erah damdam ih, heh mik nawa nyah khoopchep likhiik datti ano Sool mik ah we ngaakka. Sool saatchap ano juutemta; ");
INSERT INTO tvt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","eno phaksat ah sah ano, hetah hepah ah we ngaakrongta. Sool Damaskaas hah ni Kristaan loong damdi sa hantek tongthiinta. ");
INSERT INTO tvt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Jehudi rangsoomnok ni Sool phangla ih kah ano Jisu juuba Rangte Sah ngeh ih phangbaat kaatta. ");
INSERT INTO tvt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Heh jeng japchaatte loong ah paatti rum ano cheng rumta, “Jerusalem ni Jisu rangsoomte loong tek haatte ah tanih angka? Jisu rangsoomte loong ah Romwah phokhoh loong reenah jootkhak wan suh tanih ra hala?” ");
INSERT INTO tvt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Enoothong Sool chaan aphaan pan ih tiit baat kano, Damaskas dowa Jehudi loong tiim uh mi ngaakjeng muh, heh ih Jisu juuba Kristo ngeh ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Sa hantek lidi, Jehudi loong ah khoontong rum ano Sool khumtan suh roongwaan rumta, ");
INSERT INTO tvt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","enoothong, heh ih neng kaankoong ah japchaat eta. Rangwu rangphe samnuthung paakaalu adi tek haat esuh taat bansok rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Enoothong pheesiit Sool liphante loong ah ih hong ni paakaalu lam ih daatpi kaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sool Jerusalem ni kah ano Jisu liphante loong damdi chomui taat chungta. Enoothong neng ih Jisu liphante ngeh ih tahanpi rumta, neng loong ah echo ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Erah di Barnabas ah ra haano kaamwah loong damdi Sool ah chosiitta. Neng loong asuh lam ni Teesu damdi Sool mamah chomuita nyia roongwangta erah tiit ah jangbaat rumta. Damaskas ni Sool lacho laphaan ih Jisu tiit baatta loong ah nep deenbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Eno neng damdi Sool ah tong ano, Jerusalem hadaang noongrep ni tumkhoomta, Jisu mendi lacho laphaan eh tiitbaatta. ");
INSERT INTO tvt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sool Grik jengjengte Jehudi loong damdi nep daanmuita, eno erah loong ah ih Sool tek haat esuh chung rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kristaan loong ah ih erah japchaat rum ano, Sool ah Kaisiria ko siitkaat rumta, eno heh hadaang Tarsas ni kaat thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Eno, Judia, Galili nyia Samaria chaas loong adi semroongroong tong rumta, Esa Chiiala nawa ih mina loong ah rongtangtang angthuk rumta, eno neng loong ah Teesu ah samthun rum ah ih rangphoong rangsoom ih songtong rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pitar noongrep ni khoomta, Lidda ni tongte Rangte miloong damdi chomui suh jaasiit dongkata. ");
INSERT INTO tvt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Erah hah adi mih wasiit heh men ah Aenias, paang asat heh juptheng ni huimu ih khui arah jinni chomui kata. ");
INSERT INTO tvt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","“Aenias” Pitar ih poonta, “Jisu ih deesiit ih halu. Saat uh, an dam ah tuithiin uh” erah damdam ih Aenias ah saatta. ");
INSERT INTO tvt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lidda nyia Sharon hah ni tongte loong ah erah tuprum ano, Teesu liphante ih hoon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa hah ni Tabitha ngeh ih minuh wasiit, Jisu rangsoomte angta. (Grik jenglam ih heh men ah Dorkas angta, erah langla, “Sehui, men angta). Heh roi roitang mootse kaatse kah ano changthih noodek loong ah chosok eta. ");
INSERT INTO tvt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Erah tokdi erah nuh ah khoisat ih tiita. Heh mang ah chotchaat rum ano lamtok nokkhok ni thiinwan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Joppa hah ah Lidda dowa ih haloh tah angta, Joppa hah dowa hanpiite loong ah ih Pitar Lidda ni ngeh ih japchaat rum ano, mih wanyi wangthuk rum ano erah ruurang tiit ah baatwan thuk rumta, “Seng jiinnah kharok ih ra weeho.” ");
INSERT INTO tvt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Erah raangtaan ih Pitar ah nengnyi damdi wakkata. Pitar ah thok ano, lamtok nokkhok adi siitwan rumta, Erah di jootiinuh loong ah kookchap ano hu rumta, maangti di waatta samsong nyia nyuh akhat ah bannoi ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pitar ih erah nokkhok dowa loongtang doksoon thuk rumta, eno heh lakuh ni tong ano rangsoomta; mang ko ih lektong ano Pitar ih liita, “Tabitha, saat uh” Eno heh mik ah kaasok eta, Pitar ah japtup ano saat tongta. ");
INSERT INTO tvt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pitar ih heh lak ih joh ano toonchap thukta. Pitar ih Kristaan loong nyia jootiinuh loong ah poon ano Tabitha ah ething ngaak korumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Erah ruurang ah Joppa hah noongrep ni japchaat rumta, eno mih hantek ih Teesu tiit ah kap ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pitar ah Joppa hah ni siikhoop pheehoonte Simoon damdi sa hantek waktong thiinta. ");
INSERT INTO tvt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaisiria ni mih wasiit heh men ah Kornelias ngeh ih angta, heh Room nok hah Sipaahi “Itali Sipaahi” ngeh ih men rumta adi sipaahi Saahaap angta. ");
INSERT INTO tvt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornelias ah tongtang mina angta, erah damdi neng jaatang Rangte ra choote ang rumta. Jehudi mina changthih noodek loong ah chosok eta eno saarookwet rangsoom rangtu ih tongta. ");
INSERT INTO tvt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Jaasiit, saasong saapootjom di, Kornelias ih motmang tupta, Rangte rangsah ah ra haano liita, “Kornelias!” ");
INSERT INTO tvt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Heh ih Rangte rangsah ah cho damdi ramram ih sok ano chengta, “Erah tiimjih ah, chuupha?” Rangsah ih ngaak baatta, “Rangte ih an rangsoom nyia an lakkot suh eroon ela, erah thoidi Rangte in an rangsoom ah chaat eha. ");
INSERT INTO tvt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mih wasiit je ah heh men ah Simon Pitar ngeh ih kali rum ah erah mih ah amadoh wajombaji suh Joppa nawa poonkaat thuk uh. ");
INSERT INTO tvt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Siikhoop pheehoonte Simoon ngeh ih mih wasiit je ah erah nok adi heh wenwah, heh nok ah juusih kaang ni.” ");
INSERT INTO tvt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Erah lih adi rangsah ah maatsoon eta, eno Kornelias ih heh nok ni mootkaatte dah wanyi nyia toongtang thoon heh sipaahi ah poonta. ");
INSERT INTO tvt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Heh ih tiimjih tupta, erah loong ah baat ano Joppa ni kaat thuk jomrumta. ");
INSERT INTO tvt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Erah saalih adi, nengjom Joppa ni wangte lam ni khoom jomrum adi, Pitar ah rangnithung di rangsoom suh nokkhoh ni duuwangta. ");
INSERT INTO tvt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Heh ram ih ti ano tiim atiim phaksat thung angta; eno changsong tokdi, heh ih motmang tupta. ");
INSERT INTO tvt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Heh ih rangmong kaasak daap dat arah japtupta eno dam elongwah likhiik heh kaang rongbajiiji tamhoom choi datti ra taha. ");
INSERT INTO tvt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Erah di luiamaan, siiawi jeeje arah, pu ajuk nyia woma woh loong angta. ");
INSERT INTO tvt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pitar ih miroot esiit japchaatta, “Toonchap uh, Pitar; arah loong ah tekbuh phak uh!” ");
INSERT INTO tvt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Eno Pitar ih liita, “Teesu ngah ih taphak kang! Ngah ih esot eruh maang taat phakkang.” ");
INSERT INTO tvt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Eno miroot ah ih heh suh we ngaak liita, “Rangte ih esa ngeh ih liiha suh esot ngeh ih lali theng.” ");
INSERT INTO tvt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Emah mah ih jaajom noisok ano, lakdamdam ih rang ni ngaaktoon wanta. ");
INSERT INTO tvt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Erah motmang ah tiimjih noisok halang ngeh ih samthun adi, Kornelias ih kaat thuk jomrumta, loong ah ih Simoon nok ah jatjoh rum ano, paakaalu reeni chap kah jomrumta. ");
INSERT INTO tvt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Neng loong ah ih jaamcheng rumta, “Adi wenwah Simoon Pitar ngeh ih eje nih ang weela?” ");
INSERT INTO tvt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pitar ih motmang dowa tiimjih suh liiha ngeh ih samthun roh ih adi, Chiiala rah ih baatta, “Boichaat thaak uh! Mih wajom ih jam halu. ");
INSERT INTO tvt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Erah raangtaan ih datkhoom kah uh, neng damdoh chomui suh nak tanyah uh, neng jom ngah ih kaat thuk halang.” ");
INSERT INTO tvt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Eno Pitar ah datkhoom kah ano baat kaat rumta, “Sen ih jam han abah ngah hanih. Tiimjam ra tahan?” ");
INSERT INTO tvt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“Kornelias saahaap ih kaat thuk hali,” erah jom ah ih ngaakbaat rumta. Kornelias ah Rangte rangsoomte nyia Jehudi mina thoontang ih choomjoha nyia soongraang rumha. Rangsah ih heh nok nah an poonkaat thuk suh baatta, an ih tiimjih baat uh erah japchaat suh ah.” ");
INSERT INTO tvt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pitar ih erah jom nok ni noppoon wanrum ano niikja anah jamthiin theng ngeh ih baat rumta. Erah saalih adi neng damdi wakwangta, eno Joppa dowa Kristaan mararah uh neng damdi wakwang ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Eno Pitar ah saasiit adi thok khoomta, erah di Kornelias ih hephoh hewah nyia heh joonte sano loong ah lompoon ano, Pitar ah bansok rumta. ");
INSERT INTO tvt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pitar ah nokmong ni nopwang damdam, Kornelias ah chomuita, heh lakuh ni chooktong ano, heh ngathong ni chuubonta. ");
INSERT INTO tvt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Eno Pitar ih chapsiit ano liita, “Toonchap uh,” “Ngah bah hansi mina.” ");
INSERT INTO tvt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nokmong ni nopkhoom damdi, Pitar nyia Kornelias roongwaan nyuuta ah di, miloong ban tongta ah japtup wangta. ");
INSERT INTO tvt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pitar ih baatta, “An ih jat ehu Jehudi mih heh hootthe jun ih Ranglajatte damdi tachomui thukka. Erabah Rangte ih o uh esot ngeh ih lasamthun theng ngeh ih noisok halang. ");
INSERT INTO tvt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Erah thoidi, an ih poon hangno jengdaan laje thang ih wang halang. Enoothong, ngah ih cheng hala, tiim esuh maatpoon halang?” ");
INSERT INTO tvt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelias ih baatta, “Sa jom ngani, amah tokdi, saasong saapootjom di nga nok ni rangsoomtang. Dotdi mih wasiit nyuh phaakjaaja ih kap ano nga ngathong ni chap ano ");
INSERT INTO tvt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","baat tahang: ‘Kornelias! Rangte ih an rangsoom nyia mih moot chosok ho ah chaat eha. ");
INSERT INTO tvt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Joppa ni Simon Pitar ngeh ih je ah o subah uh poonkaat thuk uh. Erah ni siikhoop pheehoonte Simoon ngeh ih wasiit je ah eno heh nok ni heh wenwah, heh nok ah juusih kaang ni ngeh ih baat tahang.’ ");
INSERT INTO tvt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Erah thoidi an kharok ih poonkaat thuk hala, an ese ih wang halu. Rangte ngathong ni, seng loong ah ih adi bansok hi Teesu ih tiimbaat thuk ho erah boichaat suh ah.” ");
INSERT INTO tvt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pitar phang jengta: “Amadi ngah ih samthun hang amiisak Rangte ih loongtang phoosiit ih sok ha. ");
INSERT INTO tvt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","O mina ih heh rangsoomha nyia kateng ah erah mih ah kap ha, ojaat opaat ang abah uh ah. ");
INSERT INTO tvt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Sen loong ah ih jat ih han heh ih Ijirel mina loong asuh Jisu mendi Ruurang Ese baatkaat taha ah, heh Teesu khotok di Teesu. ");
INSERT INTO tvt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Joon ih juutem tiit Galili ni phangbaatta lih dowa ih Ijirel hah ni mamah angta erah sen ih jat ehan. ");
INSERT INTO tvt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Najaret dowa Jisu ah uh sen ih jat ehan, Rangte ih heh suh Esa Chiiala nyia chaan aphaan mamah ih kota loong ah uh jat ehan. Jisu noongrep ni tumkhoomta adi, Rangte ah heh damdam angta, eno mootse kaatse loong ah reeta nyia Hakhoh luuwang chaan aphaan lakkhui ni chamnaangta loong ah deesiit eta. ");
INSERT INTO tvt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ijirel nyia Jerusalem hah ni heh mamah ih reeraangta erah jatte ah seng loong ah. Erah lih adi mina loong ah ih bangphak khoni tekrapbot rumta. ");
INSERT INTO tvt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ang abah uh Rangte ih sa jom lidi tek nawa ngaaksaat ih thukta, eno mih miksok ni dong taha, ");
INSERT INTO tvt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","loongtang miksok di lah angka bah uh, Rangte ih o danjeeta erah mina, seng loong likhiik o heh damdi ngaaksaat lidi room phaksatte loong ah ih japtupti. ");
INSERT INTO tvt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Eno seng loong asuh ruurang Ese tiit ah baat etheng ngeh ih nyia rangkhothung ni ething, tekmang danjeete eje ngeh ih mina loong asuh baat an ngeh ih jengdang kohali. ");
INSERT INTO tvt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Khowah loongtang ih heh tiit ah baatta, neng ih liita o mina ih heh suh tuumaang ih tong ah neng rangdah ah heh men nyia chaan aphaan nawa ih biin anaan choh ah.” ");
INSERT INTO tvt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pitar ih tiitkhaap baatta adi, Esa Chiiala ah boichaatte loong sak ni ra taha. ");
INSERT INTO tvt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ranglajatte sak ni nep Esa Chiiala pakaat kano, Pitar damdi Joppa nawa ra taha Jehudi rangsoomte loong ah paatjaata. ");
INSERT INTO tvt_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tiimnge liidi, Ranglajatte loong ah jengkhaap ena ena jeng ano Rangte phoongpha rumta. Pitar ih liita: ");
INSERT INTO tvt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Seng ih chohi ah likhiik arah mina loong ah ih uh Esa Chiiala choh rumha. O ih bah uh neng juutem ah jen daan tam ih ah?” ");
INSERT INTO tvt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Erah lih adi Jisu mendi juutem baat rumta. Eno neng dam doh sajombaji than waktong thiin suh Pitar suh baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kamwah nyia Kristaan wahoh loong ah ih Ranglajatte loong ih nep Rangte jengkhaap ah ekap ih rumha ngeh ih Judia hah noongrep ni japchaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pitar Jerusalem ni kata doh, khoopkhan choi Jehudi loong ah ih lenmak adoleh kaanju rum ano, Pitar suh li rumta. ");
INSERT INTO tvt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“An Ranglajatte nyia neng khoopkhan muh nok ni phaksat nep room phaksatu, erah di an neng wenwah angtu!” ");
INSERT INTO tvt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Erah thoidi Pitar ih mamah angta erah jaakhoh dowa ih dook rapniine ih baattaan rumta: ");
INSERT INTO tvt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ngah ih Joppa hah ni rangsoomtang adoh, motmang ni tuptang. Rangmong nawa damnuh elongwah likhiik ih datti haano nga reeni thaam ra taha. ");
INSERT INTO tvt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Erah dam adi ramram ih jamsok angno jik ehi luiamaan, woma siiawi, pu ajuk nyia woma woh loong japtuptang. ");
INSERT INTO tvt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Eno ngasuh baat hang rah miroot japchaat tang, ‘Toonchap uh, Pitar; tekbuh phak uh!’ ");
INSERT INTO tvt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Eno ngah ih liitang’ Teesu ngah ih taphak kang! Laphaksat jih nyia esot eruh jih nga tui ni ju maang taatthaak mooksuh kang.’ ");
INSERT INTO tvt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Rang ni jeng arah miroot ah we japchaat tang, ‘Rangte ih Esa ngeh ih liiha suh esot ngeh ih nakli uh.’ ");
INSERT INTO tvt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Emamah jaajom jeng arah japchaat tang, eno thoontang rang ni ngaaktoon wanta. ");
INSERT INTO tvt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Erah pootdi ngah tongtang nok adi Kaisiria nawa nga poonte wajom thokkhoom rum taha. ");
INSERT INTO tvt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Chiiala ih ngasuh latanyah thang ih neng damdoh wakwang baat tahang. Nga damdi Joppa nawa wah arok Kaisiria ni wakwang rum taha, eno Kornelias nok ni loongtang wangti. ");
INSERT INTO tvt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kornelias ih rangsah heh nok ni chap arah japtup arah baat tahe, heh suh baatta tih, ‘Joppa ni Simoon Pitar ngeh ih mih wasiit je ah erah o subah uh poonkaat thuk uh. ");
INSERT INTO tvt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Sen jaatang puipang tiit ah erah mih ah ih baat han.’ ");
INSERT INTO tvt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Eno ngah phangjeng angdi, Esa Chiiala ah ehakdi seng sak ni ra taha ah likhiik neng sak ni uh emah para taha. ");
INSERT INTO tvt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Eno ngah ih Teesu jeng ah samthun tang: ‘Joon ih ju nawa ih juutemta, enoothong sen loong ah Esa Chiiala nawa ih juutem an.’ ");
INSERT INTO tvt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Rangte ih heh lakkot ah rangwuuthak ni tupthuk hali, Ranglajatte loong suh koha heh lakkot ah, seng suh uh phang hanpi tokdoh emah ju koh tahe; emah ang abah, Rangte jengdaante ngah o ah!” ");
INSERT INTO tvt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Erah chaat rum ano, lakah kaanju mui thang ih Rangte rangphoong rumta, neng ih liita, “Eno Rangte ih Ranglajatte loong suh nep khopiiroidong ah koh ano songtong thuk rumta!” ");
INSERT INTO tvt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stephen tek haatta tak adi siiwi rumta Kristaan loong ah marah marah ah Phonesia, Sipras nyia Entiok ni thoksoon rumta, eno Rangte tiitkhaap ah Jehudi luulu suh baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Enoothong Sipras nyia Siren nawa Entiok ni kata Kristaan loong ah ih Teesu Jisu ruurang Ese tiit ah Ranglajatte suh nep baattaan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Teesu chaan aphaan neng damdi ang kano, mina hantek ih hanpi rumta nyia thok rum taha. ");
INSERT INTO tvt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Erah ruurang ah Jerusalem ni japchaat rum ano Entiok ni Barnabaas wangthuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnabaas ah Jerusalem ni thok ano miloong ah Rangte minchan ni tong rum arah tup ano, rapne ih roonta, neng suh maama ten nawa ih jam anno laalom ih tong ah ngeh ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabaas ah wase mina angta, Esa Chiiala nyia heh tuumaang jeethoi di, mina hantek Teesu reeni thoksiit rumtaha. ");
INSERT INTO tvt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Eno Barnabaas ah Tarsas ni Sool tumjam wangta. ");
INSERT INTO tvt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Sool ah chojam ano, Entiok ni siit kaatta, nengnyi erah paang ah Entiok ni tongnyu ano Kristaan loong asuh nyootsoot nyuuta. Entiok hah dowa Jisu menjatte loong ah Kristaan ngeh ih phangmen dowa. ");
INSERT INTO tvt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Erah tokdi Jerusalem dowa khowah loong ah Entiok ni kata. ");
INSERT INTO tvt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Neng dung dowa wasiit, heh men ah Agabus ngeh ih angta ah toonchap ano Chiiala chaan nawa ih ban baatta harep haraang nah ram ang ah ngeh ih ah. (Erah Kludias Luuwanglong angta doh angta). ");
INSERT INTO tvt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Heliphante loong ah ih Judia hah dowa Kristaan loong ah chosok suh o ih mathan jen maatkaat ah erah than ih maatkaat theng ngeh ih roongwaan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Emah ih lomse rum ano, ngun ah chaas phansiitte mihak phokhoh loong asuh Sool nyia Barnabaas lakdi maatkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Erah tokdi Hirod Luuwang ih marah marah kristaan loong ah phang siiwi rumta. ");
INSERT INTO tvt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Joon phoh, Jeems ah lang ih tekdok thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Erah tekdookta asuh Jehudi loong ah roon kano, Pitar nep jootkhak thuk rumta. (Erah chamwi kuh ja angta). ");
INSERT INTO tvt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pitar joot lini phaatak ni sak ano, asih wah arok sipaahi suh ban thuk rumta. Hirod ih Khopi Romhoon lidoh Pitar suh noksong ngathong nah thaakcheng theng ngeh ih chungta. ");
INSERT INTO tvt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Erah thoidi phaatak ni sakta, enoothong Kristaan mina loong ah ih neng ten nawa ih Pitar raangtaan ih Rangte rangsoom rumta. ");
INSERT INTO tvt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Hirod ih Pitar ah nokwah reenah doksiit kaat theng ngeh ih chungta rangphe adi, Pitar ah sipaahi wanyi laktung ni jaanruh ih kit rum ano jupthuk rumta. Eno sipaahi loong ah ih phaatak kaalu adi ban rumta. ");
INSERT INTO tvt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Baphuk ih Teesu rangsah ah dongchap haano, erah nokkhok adi we ah phaakjaaja ih phaak thukta. Teesu rangsah ih heh sookkaang ni joh ano moot nyoongta, Pitar ah saatsiit ano baatta, “Kharok! Chap uh!” Erah damdam ih Pitar lak dowa jaanruh ah jaadat eta. ");
INSERT INTO tvt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Eno rangsah ih baatta, “An roomkhe nyia an lasong ah jamkap uh.” Pitar ih laan jamkap roh eta, eno rangsah ah ih baatta, “An nyuh ah wok uno nga damdam ih wakra ho.” ");
INSERT INTO tvt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pitar ah phaatak nawa, tiim uh lajat, helih helih ih dokkhoom kata, enoothong rangsah ah ih tiim esuh liita erah tajatta; Pitar ih mangphe hemang hang ngeh ih thunta. ");
INSERT INTO tvt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nengnyi ngathong ni chapta sipaahi ah jiitkhoom nyu ano heh lih dowa chapte ah taangko ih daankhoom kanyuuta, eno samnuthung ni nopwang theng jaankaalu ko ih khoomwang nyuuta. Kaalu ah hedaap daapdat ih kano dokkhoom kanyuuta. Lam adi datkhoom kanyu adi, rangsah ih Pitar luulu thiinhaatta. ");
INSERT INTO tvt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Eno Pitar ih mamah angta erah samthun ano, liita, “Ngah ih jat ehang arah amiisak ih angla! Hirod lak nawa nyia Jehudi loong ih mamah angthaak ah ngeh ih bansok rum ha raangtaan ih nga Teesu ih heh rangsah ah nga puipang suh daapkaat hala.” ");
INSERT INTO tvt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ruurang ethih jatririh di, Pitar ah Joon Maak ngeh ih men rumta nuh nok adi kata, erah di miloong ah hantek ih khoon rum ano rangsoom rumta. ");
INSERT INTO tvt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pitar ih kaasak ah rengkok kano, Rhoda ngeh ih men rumta laksuh, minusah angta ah kata. ");
INSERT INTO tvt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pitar jengla ngeh ih heh root ah jatjoh ano kaasak uh ladaap kothang ih eroon damdi ngaaksoon wangta, eno Pitar kaasak thong ni chapla ngeh ih baatwan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Emok anglu!” Miloong ah ih banli rumta. Erabah uh minusah rah ih amiisak ngeh ih hedop hedop baat rumta. Erah thoidi miloong ah ih liita, “Heh rangsah ang ah!” ");
INSERT INTO tvt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Erah pootdi uh Pitar ih kaasak ah rengkok roh eta. Lini kaasak daaprum adi Pitar ah japtup rum ano paatti rumta. ");
INSERT INTO tvt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pitar ih nak hoopti an ngeh ih heh lak ah jap eta, eno heh Teesu ih phaatak nawa mamah ih doksiitta erah ah baat rumta. “Arah tiit ah Jeems nyia kristaan wahoh loong suh nep chobaat an ngeh ih baat rumta,” erah baatthiin rum ano; ehoh ni husoonta. ");
INSERT INTO tvt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Rangkhano ang kano, sipaahi loong ah rapne ih phaangdat rumta—Pitar aju tiimjih angta ngeh ih ah? ");
INSERT INTO tvt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hirod ih taat jam thuk rum ano, mani uh tachoh jam rumta. Erah thoidi Pitar bante sipaahi loong ah tek haat ih thuk rumta. Erah lih adi, Herod Judia dowa kah ano Kaisiria ni tongkata. ");
INSERT INTO tvt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hirod ah Tairi nyia Sidoon nok hah suh rapne ih khata, erah thoidi miloong ah heh damdi chomui wang rumta. Jaakhoh thoon ah, Luuwang nok sokboite Blastus suh chomui ih weethuk he ngeh ih laatbaat rumta. Erah lih adi Luuwang reeni wangrum ano nuumi angwe ih ngeh ih li rumta, timnge liidoh nengdeek nengkaan ih phak asat ah Luuwang deek akaan nawa chophaksah rumta. ");
INSERT INTO tvt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Rangwuuse ja hechoom heraang ah dok kapleh, Hirod ah heh noksong pangmeh damdi Luuwang tongtheng adi katong kata, enooleh jengse ah ra kah ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Enooleh noksong loong ah riiraak ih rumta, “Arah mina tajengla, Rangte jengla!” ");
INSERT INTO tvt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Rangte laphoongpha koka no rangsah ih lakdamdam di khoisat satthuk ano, soot suh teksat thukta. ");
INSERT INTO tvt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Erah tokdi Rangte jengkhaap ah noongrep ni ruurangta. ");
INSERT INTO tvt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabaas nyia Sool ih Rangte mootkaat ah toom mokah roh ih nyu ano, Joon Maak ah siit nyu ano Jerusalem nawa ngaak wang ih jom rumta. ");
INSERT INTO tvt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Entiok chaas ni khowah nyia nyootsootte eje angta: Erah loong ah langla Barnabaas, Simoon (mimak ih men rumta), Lusius (Siren nawa angta), Manaen (Kobono Herod ih haakpanta), nyia Sool loong ah ang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Erah loong ah ih samurangsoom tong rumta doh, Esa Chiiala ih baat rumta, “Barnabaas nyia Sool ngah ih tiim raangtaan ih poon nyuutang, erah moot ah moot suh danje an.” ");
INSERT INTO tvt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Neng loong ah samurangsoom ah tong rum ano rang ah soom ih rumta, eno nengnyi khoh ni taajoh rum ano daapkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Esa Chiiala ih kaat thuk nyu ano, Barnabaas nyia Sool Seleukia ni kanyu ano Juuloot ni Sipras hah ni daansoon kanyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamis ni thoknyu ano, Jehudi rangsoomnok ni Rangte jengkhaap baatkaat nyuuta. Nengnyi damdi Joon Maak ah nengnyi roong chosok suh waksiit nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Paphos maang thokthok juuloot ni hah maathan angta erah di tumkhoom jomrumta, erah di Jehudi nok hah maantaan wasiit heh men ah Bar-Jesus, ngeh ih men rumta warah chomui jomrumta, erah mina rah ih ngah khowah ngeh ih kachaangta. ");
INSERT INTO tvt_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Eno erah mih ah langla juuloot dowa kobono joonte angta, kobono ah men Sergias Paulus ngeh ih angta eno erah mina ah rapne ejat mih angta. Erah warah ih Pool nyia Barnabaas ah heh reeni Rangte jengkhaap boichaat suh poon nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Enoothong maantaan Elimas (Erah men ah Grik jengkhaap lam ih menha) ah ih tanghaam ih nyuuta, timnge liidoh, kobono ih nengnyi jengkhaap ah phomok hanpi ah ngeh ih samthunta. ");
INSERT INTO tvt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Eno Sool, Pool ngeh ih uh poon kah ih rumta warah Esa Chiiala te angta; Sool ih maantaan taangko ramram ih sok ");
INSERT INTO tvt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ano liita, “An Hakhoh luuwang sah! Mootse kaatse mathan ah erah an raangtaan ih piiara tola. An tenthun mongtham ni ethih totoh thun hu, erah thoidi Teesu tiit ami ah eki eki ih deenbaat hu! ");
INSERT INTO tvt_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Amamah doh Teesu ih, edook ih hoon thuk ho eno rangwu latup thang ih pootsiit ang uh.” Lakdamdam di Elimas mik ah nakdat eta, eno heh lak nah joh ano diisiitte taat tum taajota. ");
INSERT INTO tvt_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Erah tup ano kobono ih ehanhan ih hanpiita; Teesu tiit nyootsoot nyuuta suh rapne ih paatjaata. ");
INSERT INTO tvt_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Sool nyia heh joonte loong ah Paphos nawa Pamphilia ko Perga ngeh ih samnuthung esiit angta di juulam ih daansoon wang rumta, Joon Maak ah erah hah dowa neng ah thiinhaat rum ano Jerusalem ni ngaak wangta. ");
INSERT INTO tvt_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Neng loong ah Perga nawa Pisidia hadaang Entiok ni thok rum ano, Jehudi naangtongsa ja Jehudi rangsoomnok ni tong karumta. ");
INSERT INTO tvt_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moses Hootthe nyia Khowah loong ih raangthiinta ah weh rum ano, Jehudi rangsoomnok dowa saahaap loong ah ih neng suh maatbaat rumta: “Nga phono loong, noksong paangmeh suh chaankot jengkhaap je abah jeng an.” ");
INSERT INTO tvt_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pool ah toonchap ano, heh lak ah jap damdi jengta: “Ani songtongte Ijirel nok hah nyia Ranglajatte joon awaan loong; nga jeng ah boichaat thaak an! ");
INSERT INTO tvt_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ijirel mina loong Rangte ih sengte sengwah loong ah Ijip ni nokmah wensang eh songtong kaat suh danje rumta eno erah ni songtong tokdi rapne eh jaat thuk rumta. Rangte ih Ijip hah nawa hechaan hephaan nawa ih doksiit rumta, ");
INSERT INTO tvt_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","eno paang rookbaji heh ih phisaang hah ni rapne ih naan rum ano sokboi riikoi rumta. ");
INSERT INTO tvt_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Rangte ih hah sinat ah jenthuk rum ano Kanaan hah ni hah changte eh hoonthuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Chaabaji rookbangnga paang lidi kok semsong rumta. Erah lih adi, Samuel khowah maang dongka di neng mat hoonte nyia tiit hoonte ah dong thukta. ");
INSERT INTO tvt_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Eno Luuwang suk rum kano, Rangte ih Benjamin kuh awang dowa Kis sah Sool ah neng Luuwang paang rookbaji raangtaan ih ang thukta. ");
INSERT INTO tvt_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sool ah dokphan ano, Rangte ih Dewid ah Luuwang ang thukta. Rangte ih amah liita: ‘Ngah ih ese chohang mina ah langla Jese sah Dewid, ngah ih tiim li ang erah mootkaat ah heh kah ah.’ ");
INSERT INTO tvt_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Dewid sutom Jisu ah, Rangte ih heh kakham jun ih Ijirel mina puipangte ang thukta. ");
INSERT INTO tvt_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jisu maang raara di, Joon ih Ijirel mina loong asuh baat rumta, maama rangdah ah sekthun ano juutem theng. ");
INSERT INTO tvt_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Eno Joon ih juutem rum ano miloong asuh cheng rumta, ‘Sen ih ngasuh o ngeh ih thun hali? Sen ih bansok han ah ngah tah angkang. Boichaat an! Nga lidoh Heh raaha, ngah bah heh lasong khook haattha uh tah angkang.’ ");
INSERT INTO tvt_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Abraham sutom satoom, Ijirel phoh ano loong, nyia aadi Ranglajatte o mina Rangte rangsoomte eh hoon lan loong asuh jenglang: Khopiiroidong tiit ah seng raangtaan ih kaat thuk hala! ");
INSERT INTO tvt_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem ni songte loong nyia neng mihak phokhoh loong ebah neng Pangte ah tajatka, adoleh khowah loong ih raangthiinta le ah naangtongsa rookweh weh rumha ah tajat rumka. Erabah uh khowah jengkhaap ah amiisak ih angla, neng ih Jisu ah kaanju ih rumha. ");
INSERT INTO tvt_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jisu ah tiim thoilam doh tek haat theng ah lajat rumkaano, Pilat suh tek haat etheng ngeh ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Erah lih adi jirep ah Rangteele ni ban raangthiinta likhiik Jisu ah bangphak dowa datthiin rum ano beng rumta. ");
INSERT INTO tvt_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Eno Rangte ih Jisu ah tek nawa ngaaksaat ih thukta, ");
INSERT INTO tvt_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","eno Galili nawa Jerusalem ni heh damdi roong kaatte loong ah reeni hedop hedop dongkhoomta. Amadi neng loong ah Ijirel mina raangtaan ih heh tiit baatte angla. ");
INSERT INTO tvt_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Eno aadi sen suh Ruurang Ese ah thok hui hali; sengte sengwah loong asuh Rangte ih kakhamta jun ih kot ih hali; amadi hesuh hesah loong ah raangtaan ih Jisu ah tek nawa ngaakthing ih thukta. Dewid Bong leedap enyi ni raangha, ‘An nga Sah; chiinnyah ngah an Wah eh hoon lang.’ ");
INSERT INTO tvt_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Eno Rangte ih tek nawa ngaaksaat tiit ah baatta, mangbeng nah mabah uh tachaamka; ‘Ngah ih Dewid damdi kakham tang ah, Ngah ih romseetam kot ih rumha.’ ");
INSERT INTO tvt_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Eho ni uh heh ih li eha, ‘An ih toongtang laksuh ah mabah uh beng nah tachaam thukko,’ ");
INSERT INTO tvt_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Heh roidong di Dewid ah Rangte tenthun jun ih heh moot ah mokah ano tiita, erah lih adi hete hewah damdi bengkaat ano heh sak ah chaam eta. ");
INSERT INTO tvt_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Enoothong tek nawa ngaaksaat thukta warah bah Rangte ih emah chaam thukmuh. ");
INSERT INTO tvt_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ijirel phoh ano loong, Jisu mendoh ba sen rangdah ah biin anaan choh an ngeh ih baat hi; erah raangtaan ih Moses Hootthe jun di biin anaan lachote loong asuh Jisu suh laalom ano biin anaan choh ah ngeh ih baattaan hi. ");
INSERT INTO tvt_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Erah raangtaan ih, maama teewah ih jat etheng, khowah loong ih baatta ah likhiik sen loong ah emah naktoom ang an: ");
INSERT INTO tvt_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Sok thaak an teemaang mangda loong! Paatja anno ti an! Chiinnyah ngah reelang ah erah sen ih tabaam hanpi kan, o mina ih taat deen jaangbaat han bah uh ah!” ");
INSERT INTO tvt_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pool nyia Barnabaas Jehudi rangsoomnok nawa dokkhoom kanyuuta adi, naangtongsa ja boot nyootsoot esuh we ngaakwang ih hansih ngeh ih miloong ah ih phanbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Loongkhoon theng nawa miloong ah tiisoon kano, Jehudi mih nyia Ranglajatte hantek mina Rangte rangsoomte eh hoon rumta eno Pool nyia Barnabaas lilih ih khoom rumta. Pool nyia Barnabaas ih Rangte minchan doh songtong an ngeh ih chaankot jengkhaap ah renbaat ih nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Jehudi naangtongsa saalih adi samnuh dowa miloong ah Teesu tiitkhaap tiit boichaat ra rumtaha. ");
INSERT INTO tvt_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mih khoonthokta loong ah tup rum ano Jehudi nok hah loong ah ih miksuk ih rumta, Pool jengkhaap thoidi rookmui rum ano kaanju ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Erabah uh Pool nyia Barnabaas ih ehanhan ih lacho laphaan ih baattaan nyu ano li rumta: “Rangte jengkhaap ah sen suh phangbaatjih angta. Enoothong sen ih lakap thoidi nyia khopiiroidong choh theethe tah angke li phiino, Ranglajatte jiinko kati. ");
INSERT INTO tvt_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Seng Teesu ih kotahe jengdang ah langla amah: ‘Ranglajatte loong raangtaan ih sen loong ah weephaak hoon rum taha, timnge liidi arah mongrep dowa loong ah toom puipang rum asuh ah.’” ");
INSERT INTO tvt_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ranglajatte loong ah erah japchaat rum ano, rapne ih tenroon rumta eno Teesu jengkhaap ah phoongpha ih rumta; o mina latek roidong chote ah erah loong ah Kristaan eh hoon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Erah hah adi Teesu Jengkhaap ah noongrep ni ruurangta. ");
INSERT INTO tvt_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Enoothong Jehudi loong ah ih samnuthung dowa Rangte rangsoomte mihak phokhoh nyia Ranglajatte minuh ejat eje loong ah rapne ih dantak rumta. Pool nyia Barnabaas ah miksuk siikhaam ih rum ano erah hah dowa phanjoot haat ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kaamwah wanyi ah ih neng jeng phaaki nengnyi lah dowa botla ah jaanak nyu ano Ikoniam ko ih kanyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Entiok dowa kristaan loong ah sak ni Esa Chiiala kaat kohaano tenroon ih tong rumta. ");
INSERT INTO tvt_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikoniam ni uh phoosiitsiit ih angta: Pool nyia Barnabaas Jehudi rangsoomnok ni kanyu ano rapniine baattaan nyu kano Jehudi nok hah nyia Ranglajatte loong ah rapne ih kristaan eh hoon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Enoothong Jehudi mina o ih lahanpi rumta loong ah ih Ranglajatte loong asuh roonphak rum ano hanpiite loong damdi thet chomui thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Heliphante loong ah rekamdook ih sentong thiin rumta, Teesu tiit ah lacho laphaan ih baattaan rumta, heh tiitkhaap nyia minchan ah amiisak ngeh ih paatjaajih loong ah reeraang rum ano noisok rumta. ");
INSERT INTO tvt_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Samnuthung dowa mina loong ah phaaknyi eh hoon rumta: Mararah ah Jehudi damdi, rukho ah Heliphante loong damdi. ");
INSERT INTO tvt_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Eno marah Ranglajatte nyia Jehudi loong ah, neng mihak phokhoh damdi Heliphante loong ah joonnaam eno jong ih pat theng ngeh ih roongwaan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Heliphante loong ah erah japchaat rum ano, Likonia ko Listra nyia Derbe samnuthung hah ni nyia nokphoh nokno hah ni husoon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Erah di uh Ruurang Ese tiit ah baat roh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Dongtupta dowa ih mabah uh lataat khoomka rah ekoong mina Listra hah ni mih wasiit angta. ");
INSERT INTO tvt_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Erah di tong ano Pool jengkhaap ah thaam boichaatta. Pool ih ekoong tuumaang ah tup ano nyia ede ih ah ngeh ih jat ano ramram ih sok ");
INSERT INTO tvt_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ano erongwah ih jengta, “An lah nah toonchap uh!” Ekoong ah toonpit ano leng khoomta. ");
INSERT INTO tvt_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mih khoonthok rumta loong ah Pool reeta ah tuprum ano, neng jeng Likonia jengkhaap lam ih riiraak rumta, “Rangte ah mih likhiik eh hoon ano seng reeni ra hala!” ");
INSERT INTO tvt_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Neng ih Barnabaas men ah Jeus ngeh ih men rumta, Pool men ah Hermes ngeh ih men rumta timnge liidoh heh tiitwah long angta. ");
INSERT INTO tvt_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jeus rangte romwah angta rangsoomnok ah langla, samnuh paakaalu reeni angta, eno romwah nyia miloong ah ih Pool nyia Barnabaas khojoop suh maan nyia popoong loong ah paakaalu adi piikaat rum taha. ");
INSERT INTO tvt_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pool nyia Barnabaas ih erah japchaat nyu ano miloong dung adi soonkah nyuuta eno nengnyi nyuh akhat ah khoohoom nyu ano riiraak nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Emah tiimte reeraang lan? Sek bah sen likhiikkhiik mina! Sek bah sen suh Ruurang Ese tiit baatte bo ah, hansi roidong dowa juukhu hakong adoleh erah di songtongte dongsiitte Rangte reenah toomthok rum ah ngeh ih bo tum baattaan hi tih. ");
INSERT INTO tvt_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Teewadi miloong ah maama pongwan ih songtong thukta. ");
INSERT INTO tvt_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Enoothong amadi hemoot hekaat ese lam ah noisok heeno ngah eje ngeh ih jatthuk hali; rang nawa heh ih rangphaat thukla nyia ji acham ah heh rangwu di jaase thukla; phak asat ah koh hanno tenroon ih tongthuk halan.” ");
INSERT INTO tvt_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Erah jengkhaap ah baat nyu ano Pool nyia Barnabaas ih nengnyi khojoop siik hoon ah kanak ih jen tanghaam nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Marah marah Jehudi loong ah Entiok nyia Ikoniam nawa Pisidia ni ra rum taha; neng loong ah ih miloong ah mokwaan ra rum haano neng damdi roongroop rumta, Pool ah jong ih patrum ano tek ela ngeh ih samthun rumta eno erah hah dowa dok hoom kaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Enoothong hanpiite loong ah kookchap rum kano, Pool ah samnuthung ko ngaak soonwangta. Erah saalih adi Pool nyia Barnabaas Derbe ni wang nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pool nyia Barnabaas Ruurang Ese tiit baat nyu kano Derbe dowa miloong ah heliphante nang jaat thuk nyuuta. Eno Listra dowa Ikoniam ni, erah lih adi Entiok hah Pisidia ni ngaak wang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nengnyi ih Kristaan loong asuh amiisak tiit ah kap anno kamkam ih laalom anno tong an ngeh ih chaankot jengkhaap ah baatthiin ih nyuuta. “Rangte hasong mong nah jennop suh seng ih jirep cham anaang ah jen hui etheng,” ngeh ih nyootsoot nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Chaas rookwet ni nengnyi ih mihak phokhoh long ah danje ih thiin nyuuta, eno samurangsoom ah tongleh Teesu lakni lookleh rang ah soomkoh, eno mihak phokhoh loong asuh nengnyi rapne laaloom nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia hah adi daan kah nyu ano, Pamphilia ni thok nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perga hah adi Rangte tiitkhaap ah baatnyu ano Attalia ko wang nyuuta, eno ");
INSERT INTO tvt_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","erah dowa Entiok ni ju lam ih daansoon wang nyuuta, erah hah adi nengnyi suh Rangte minchan doh jen mootkaat etheng ngeh ih rangsoom koh rumta jun ih jenthoon mokah ih nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Entiok ni thoknyu ano, Rangte ih mamah mootkaat thuk nyuuta nyia Ranglajatte loong asuh laalom lampo laangsiit kota erah tiit baat suh miloong ah khoonpoon ih nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Eno kristaan loong damdi erah ni rekamdook ih roong tongthiin nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mararah mina loong ah Judia nawa Entiok ni wang rum haano hanpiite loong asuh phang nyootsoot rumta, “Moses Hootthe jun ih khoopkhan banlam lahoon kanbah sen ih khopiiroidong ah tachoh kan.” ");
INSERT INTO tvt_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Erah jengkhaap ah thoidi Pool nyia Barnabaas ah neng damdi rapne ih daanmui nyuuta, erah raangtaan Entiok nawa wasiitnyi Pool nyia Barnabaas damdoh Jerusalem nah wakkah ano kamwah nyia mihak phokhoh loong asuh erah tiit ah chengkaat theng ngeh ih roongwaan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Erah thoidi neng loong ah chaaste ih wangthuk rumta; eno Phoenesia nyia Samaria lam ih kah rum adi, Ranglajatte loong ah Rangte mendi mamah lek rumta tiit ah banbaat rumta; erah chaat rum ano hanpiite loong ah rapne ih roon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalem ni thokrum kano, kamwah loong, chaas nawa te nyia mihak phokhoh loong ih rapniine ih bantho rumta, neng suh Rangte ih mamah ih maak rumta erah tiit ah baat ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Enoothong mararah hanpiite Pharisis nawa angta loong ah toonchap rum ano jeng rumta, “Ranglajatte loong ah ih khoopkhan banlam ah hoon jaatjaat etheng eno Moses Hootthe kap ah baat etheng.” ");
INSERT INTO tvt_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kamwah nyia mihak phokhoh loong ah erah tiit ah phanwaan suh lomtong rumta. ");
INSERT INTO tvt_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Rekam daanmui rum ah lilih Pitar ah toonchap ano jengta, “Phoh ano loong, sen ih jat ehan, ngah jaakhoh di Rangte ih Ranglajatte suh Ruurang Ese tiit baat suh danje tahang, timnge liidi neng ih erah japchaat ano toom hanpi rum ah ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Eno mirep thung atak jatte Rangte ih, seng suh kohali ah likhiik Esa Chiiala ah koh rum ano heh ih Ranglajatte loong ah uh kap etheng ngeh ih noisok ha. ");
INSERT INTO tvt_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Rangte ih seng loong asuh phoosiit siit li hali; neng loong ah ih hanpi ih kano neng rangdah uh biin anaan eha. ");
INSERT INTO tvt_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Emah ang abah, sengte sengwah ih lajen huika nyia seng ih lajen huike huijih ah neng tam ni toonhui thuk eno, Rangte ah tiim esuh thaak phate hi? ");
INSERT INTO tvt_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Emah tah angka! Teesu Jisu minchan ih seng puipang ih tahe ah likhiik neng uh hanpi ih rum kano puipang ih rumha.” ");
INSERT INTO tvt_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pool nyia Barnabaas ah Rangte ih Ranglajatte damdi mih paatjaajih mamah ih re thuk nyuuta, erah baatnyu kano mih loong ah tikpakpak ih tong rumta. ");
INSERT INTO tvt_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pool nyia Barnabaas ah thoonjeng nyu kano, Jeems we jengta: “Nga phono loong chaat thaak he! ");
INSERT INTO tvt_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Jaakhoh di Rangte ih Ranglajatte dung dowa heh mih raangtaan ih poon ano neng mamah ih riikoi sokboita erah ah Simoon ih baat ih tahan. ");
INSERT INTO tvt_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Khowah loong ih baatta jengkhaap ah pun ela, Rangteele ni liiha, ");
INSERT INTO tvt_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Teesu jengta, arah lidoh Ngah ngaak hangno, Dewid hasong ah ngaak seesiit ih raahang. Thet eta ah rongtangtang ih we seesiit angno ese we angthuk ang. ");
INSERT INTO tvt_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Eno loongtang mina nga taangnah thok ha, Ranglajatte loongtang nga noksong raangtaan ih poonhang loong ra ah. ");
INSERT INTO tvt_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Arah jengkhaap ah Teesu ih, ehakdi dook jatthukta.’ ");
INSERT INTO tvt_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Nga thung ni bah amah,” ngeh ih li ano Jeems ah jangjeng kata, “Marah Rangte reeni thok hala Ranglajatte loong ah seng ih laphaang phaktheng. ");
INSERT INTO tvt_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Erah nang ebah, khojoop phaksat nyia esot loong ah laphaksat theng ngeh ih le thong raangmaat ih; adoleh mih damdoh roomjup roomtong lah ang theng, khoisat luiamaan nyia hesipan laphak theng ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tiimnge liidi, Moses Hootthe ah Jehudi rangsoomnok ni naangtongsa rookwet jaakhoh dowa ih weh koha, enooleh noongrep ni samnuh ko ih tumbaat rumha.” ");
INSERT INTO tvt_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Eno kaamwah loong nyia chaas phokhoh loongtang roongwaan rum ano, neng dung dowa mina danje rumta eno Pool nyia Barnabaas damdi Entiok ni wakkaat thuk rumta. Hanpiite loong ih rapne ih choomjoh arah mina wanyi danje rumta, Judas Barsabbas ngeh ih men rumta nyia Silas ah; ");
INSERT INTO tvt_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","eno neng ih arah le ah raangmaat rumta: “Senphoh senno seng loong ah, kaamwah nyia mihak phokhoh loong ah ih, Entiok, Sairia nyia Silisika dowa Ranglajatte phoh ano loong suh jengkhaapse ra hi. ");
INSERT INTO tvt_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Sengdung nawa ra taha loong ah ih sen loong ah neng jengkhaap nawa ih phaangphak ra halan ngeh ih chaat ehi; neng suh, seng ih, renbaat muh. ");
INSERT INTO tvt_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Eno khoontong eno kongphaak kotte sen reenah kaat thuk suh kheemui li. Seng moongnook joonte Barnabaas nyia Pool damdoh wakra rumha, ");
INSERT INTO tvt_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","neng loong ah ih Teesu Jisu Kristo raangtaan ih ba seng roidong ah mamah ang abah uh toomang ah ngeh ih jaan jen chaang rumha. ");
INSERT INTO tvt_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Erah raangtaan ih Judas nyia Silas kaat thuk hali, seng ih tiimjih raang hi nengnyi tui ih uh erah ah baat ehan. ");
INSERT INTO tvt_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Arah banlam tiit khotok doh sen laphaangphak theng ngeh ih Esa Chiiala nyia seng loong ah ih tiit thiin hi: ");
INSERT INTO tvt_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Khojoop phaksat laphaksat theng; hesih laphak theng; khoisat luiamaan laphak theng; eno mih damdoh roomjup roomtong laje theng. Ethih ekhah lare kanbah senmoot senkaat jirep ah ese ang ah. Eno sen suh jengseera hi.” ");
INSERT INTO tvt_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kongphaak kotte ah Entiok ni wang thuk rumta, eno miloong thutpoon rum ano hanpiite loong asuh le ah chokoh ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mina loong ah ih le ah weh rum ano, chaankot jengkhaap asuh rapne ih roon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas nyia Silas, nengnyi uh khowah angta, nengnyi miloong ah damdi rekamdook ih chaankot jengkhaap jeng koh nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Erah ni cheesah tongnyu adi, miloong ah ih romseetam jengkhaap ah jeng koh rum ano o ih kaat thuk nyuuta erah loong ah reeni ngaak wang thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Enoothong Silas ah erah ni tangtong suh liita. ");
INSERT INTO tvt_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pool nyia Barnabaas Entiok ni cheesah tongthiin nyuuta, nengnyi damdi wahoh loong ah nep ih Rangte Jengkhaap nyootsoot thiin rumta. ");
INSERT INTO tvt_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Rekam tongnyu ano Pool ih Barnabaas suh liita; “Sek ih Teesu tiit nyootsootti tih hanpiite loong ah samnuh harep nah ngaak kah tiino sokkah thaak tih mamah ih tongtha rumla.” ");
INSERT INTO tvt_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Eno Barnabaas ih Joon Maak ah nengnyi damdi waksiit thung, ");
INSERT INTO tvt_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pool langkoleh heh waksiit ah tapunka ngeh ih thunta, timnge liidoh, Joon Maak ah nengnyi damdi thoon moot kaatmuh, heh Pamphilia nawa ngaak soonta. ");
INSERT INTO tvt_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nengnyi rapne daanmui nyu ano pheesoon nyuuta: Barnabaas ah Maak ah siit ano Sipras ko juulam ih daansoonta, ");
INSERT INTO tvt_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pool ih Silas ah siit ano kata, hanpiite loong ah ih nengnyi ah phoongpha rum ano Teesu lak ni look haatkoh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pool ah Siria nyia Silisia lam ih kah ano chaas rookweh ni chaan tum kota. ");
INSERT INTO tvt_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Timothi ngeh ih kristaan mina wasiit Derbe nyia Listra hadaang ni tongta, erah di Pool tumkhoom kata. Heh nuh ah langla Jehudi nok hah ang ano Kristaan eh hoon arah angta, heh wah ah ba Grik nok hah angta. ");
INSERT INTO tvt_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra nyia Ikonium dowa hanpiite loong ah ih Timothi ah rapne ih seebaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pool ih Timothi waksiit suh chung ano, heh suh khoopkhan banlam ah hoon eh thukta. Pool ih tiim esuh hoon thukta liidi, erah hah adi songtongte loong ah ih jat eta Timothi wah ah Grik nok hah ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nengnyi samnuh ni tumkhoom kanyuuta adoh, kamwah nyia mihak phokhoh loong ah ih Jerusalem ni tiit thiin rumta neem arang ah kap etheng ngeh ih hanpiite loong suh tumbaat nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Erah raangtaan ih chaas mina loong laalom ah rongtangtang ang kano rangwu rookwet miloong ah jaat eh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Esa Chiiala ih Esia hah ni rangte tiit labaat thuknyu koka no Phrigia nyia Galatia hah ni tumkhoom kanyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nengnyi Maisia jatlih rit ah thokkhoom nyu ano, Bithinia hah ni nopwang chung nyuuta, enoothong Jisu Chiiala ih tawang thuk nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Erah thoidi Maisia hah lam ih daankhoom nyu ano Troos ni wang nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Erah rangphe ja Pool ih heh mangphe di Mesidoniate wasiit heh lasih jowang arah japtupta, “Mesidonia hah nah seng chosok ra weeho!” ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pool ih heh mangphe mangta damdam eh, seng Mesidonia ni dokchap kati, tiimnge liidi, Mesidonia ni ruurang jaase tiit miloong asuh baatkaat suh poon hali ngeh ih roongwaanti. ");
INSERT INTO tvt_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troos nawa seng loong ah Samothras lam ih juukaari ni phangla ih daansoon kati, eno erah saalih adi Neopolis ni wangti. ");
INSERT INTO tvt_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Erah dowa Philippi hani saanghook lam ih wangti, erah langla Mesidonia distrik ni phangdong eta samnuthung ah ang dowa; Room hah ngeh ih uh li eta. Erah di seng rekamdook tong thiinti. ");
INSERT INTO tvt_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Naangtongsa seng loong ah juure ko samnuthung adi kati, seng ih mok thunti erah nah Jehudi loong rangsoom khoontong theng eje ang ah ngeh ah. Erah di chooktong kah eno minuh loong ah khoontong rumta damdi roongwaan kati. ");
INSERT INTO tvt_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Neng dung ni seng jeng chaat arah Thaitria hah nawa Lidia ngeh ih nusiit angta, erah nuh ah saanghaam nyuh sangte angta. Heh Rangte rangsoomte ang kano, Pool jengkhaap thaangchaat suh Teesu ih hethung hetak seklilih ang thukta. ");
INSERT INTO tvt_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Neng jaatang juutem lidi, erah nuh ah ih poon tahe, “Amiisak Teesu suh laalomte ngeh ih thun hali bah nga nok nah jamra han.” Erah nuh ah ih ekaat ih weetheng ngeh ih laat poon tahe. ");
INSERT INTO tvt_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Saasiit rangsoom thengni kati di, milaksuh jaalasah nusiit chomuiti, erah sah ah chiithih laakhah pan angta eno liwang nah tiimjih angtheng ah erah banbaatte angta. Erah likhiik mi banbaat thoidi heh changte wah asuh ngun rapne ih bi kota. ");
INSERT INTO tvt_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Eno erah jaalasah ah seng Pool loong ah lilih ih phankhoom haano erongwah ih riiraakta, “Arah wah loong ah bah thoontang nang ih Elong Rangte jeng chaatte! Neng ih sen khopi tiit ah baat halan!” ");
INSERT INTO tvt_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Erah sah ah saarookwet emamah wootjeng kano Pool ah thungthita, eno lekchap ano chiiala asuh liita, “Jisu Kristo mendoh arah sah sak dowa doksoon ho!” Lakdamdam ih chiiala ah heh sak dowa doksoonta. ");
INSERT INTO tvt_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Heh changte warah ih bolam bah ngunbi lampo takah jeeka ngeh ih samthun ano, Pool nyia Silas ah joh nyu ano nokwah dung ni thaangsang theng ko elong elang loong reeni hoom kaat nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Room nok hah saahaap loong reeni siitkaat nyu ano baat rumta, “Arah mih anyi Jehudi nok hah, eno anyi ih arah samnuthung adi hah phaangphak nyuuha. ");
INSERT INTO tvt_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Arah nyi ih seng Hootthe lah angka rah nyootsoot nyuuha; seng bah Room mina, erah raangtaan ih erah nyootsoot nyuuha Hootthe ah tami kapke.” ");
INSERT INTO tvt_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Eno mih lomkhoon rumta loong ah nep ih Pool nyia Silas ah roong buh rumta. Saahaap loong ah ih Pool nyia Silas ah nyuh akhat nep ih khoohoom rum ano bot thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Rapne ih bot lidi, Pool nyia Silas ah phaatak ni sak nyuuta, eno saahaap ah ih kit eh tangsak thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Erah baat kano, phaatak bante ah ih nokmong khok ni siitwan nyu ano, nengnyi lah ah bangtan laktung ni roopkit wan nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pheethungkham di Pool nyia Silas ah Rangte seehoon boongkaat lam ih rangsoom nyuuta, eno phaatak ni sakta wahoh loong ah ih nengnyi seehoon boongkaat ah boichaat ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Baphuk ih hah ah choophaan phaan ih moh ano phaatak nok ah thetnyoongta. Kaasak loong ah laakdat, eno phaatak dowa miloong khakta janruh loong ah jaadat eta. ");
INSERT INTO tvt_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Phaatak bante ah paatsaat ano kaasak loong ah laakdat choi tupta, heh ih thunta phaatak dowa miloong ah hotsoon ela ngeh ah; eno heh lang ah dok hoom ano heh teeteewah taat tek haatta. ");
INSERT INTO tvt_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Enoothong Pool erongwah ih tangriita, “An teewah nak tek haat uh! Seng loongtang eje!” ");
INSERT INTO tvt_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Phaatak bante ah ih weephaak took kot taat jam poonta, noppit ano, heh lakuh rungrung ih moh ano Pool nyia Silas lasih jowangta. ");
INSERT INTO tvt_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Eno wanyi ah dokkhoom thuknyu ano chengta, “Chuupha nyi, nga khopi suh tiim ih we ang?” ");
INSERT INTO tvt_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wanyi ah ih baatta, “An khopi suh Teesu Jisu suh laalom uh an jaatang loongtang epui e an.” ");
INSERT INTO tvt_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Eno wanyi ah ih neng changtom suh Teesu tiit ah nyootsoot ih nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Erah rangphe adi phaatak bante ah ih doksiit nyu ano nengnyi sok ama loong ah chotchaat eta; lakdamdam di neng jaatang changtom juutem rumta. ");
INSERT INTO tvt_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Erah lih adi Pool nyia Silas ah heh nok ni siitkaat nyu ano phaksat ah kokaang nyuuta. Neng jaatang changtom Rangte hanpi hi ngeh ih roon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Erah saalih rangkhah di Room hate ngoong awang loong ah ih phaatak bante saahaap loong reeni pulit suh baatwan thuk rumta, “Wanyi ah dokkhoom toom ih nyu ah ngeh ah.” ");
INSERT INTO tvt_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Eno phaatak bante ah ih Pool suh baatta, “Saahaap loong ah ih set Silas suh dok etheng ngeh ih maaatbaat rumhala. Set jen kaat ih ansih, ese thamtham ih kah ansih.” ");
INSERT INTO tvt_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Enoothong Pool ih saahaap asuh liita, “Seknyi Room nok hah, tiim uh laathih keetih di, nokwah dung ni buh tahe tih! Erah lih adi phaatak ni sak tahe tih. Eno amadi ah hotsu ih kaat thuk hali tih. Enoothong emah tah angka! Room hate saahaap loong ah ih nengneng wang haano toom kaat thuk he tih.” ");
INSERT INTO tvt_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Phaatak bante loong ah ih erah jengkhaap ah Room hate saahaap loong asuh baat kaat rumta; eno Pool nyia Silas ah Room nok ha ngeh ih japchaat rum ano, neng loong ah echo ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Erah thoidi neng loong ah kah ano seng mok re ah enaan ih weehe ngeh ih roongwaan karumta; eno phaatak nawa doksiit rum ano samnuthung dowa doksoon ih ansih ngeh ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pool nyia Silas ah phaatak dowa doksoon nyu ano Lidia nok ni kanyuuta. Erah ni Teesu liphante loong ah chomui kanyuuta, eno neng loong asuh chaankot jengkhaap ah jengthiin nyu ano doksoon nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pool nyia Silas Thesalonika ni Amphipolis nyia Apollonia lam ih kanyuuta, erah hah adi Jehudi rangsoomnok eje angta. ");
INSERT INTO tvt_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Saahoh di kakah ah likhiik Pool ah Jehudi rangsoomnok ni kata. Jehudi Naangtongsa rangwu di sa jom kah ano miloong ah damdi roongwaan kata, ");
INSERT INTO tvt_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","eno Rangteele tiitkhaap ah baattaan rumta, Kristo ah cham jaatjaat etheng angta eno tek nawa we ngaaksaat ih ah. Pool ih baat rumta, “Erah Jisu tiit ah baat rumhala,” eno “erah juuba Kristo ang ah.” ");
INSERT INTO tvt_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mararah loong ah ih erah tiit ah kap ih rum ano Pool nyia Silas damdi roongroop rumta; minuh ejat esam loong nyia Grik nok hah Rangte ra choote loong ah nep roongroop rumta. ");
INSERT INTO tvt_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Enoothong Jehudi loong ah ih miksuk ih rum ano pheehoon thaangsang theng dowa mih lajak loong khoonpoon rumta. Erah miloong ah ih samnuthung ah rapne ih phaanghoom rumta, eno Pool nyia Silas ah nokwah dungni siitkaat suh li rum ano Jaasoon nok ah kooknak ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pool nyia Silas laje kokaano, Jaasoon nyia Teesu liphante wahoh loong ah samnuthung dowa saahaap loong reeni dok hoom kaat rum ano riiraak rumta, “Arah miloong ah ih seng hadaang noongrep ni haphaang hoom rumha! Haphaang hoomte loong ah seng hah ni thok rumhala, ");
INSERT INTO tvt_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","eno Jaasoon ih heh nok ni jamthuk nyuula. Luuwanglong Hootthe ah arah loong ah ih thet hoom rumha, neng ih liiha bolam Luuwang wahoh eje, heh men ah angkoleh Jisu ngeh ih poon rumha.” ");
INSERT INTO tvt_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Erah jeng ah chaat rum ano, samnuthung dowa miloong ah nyia saahaap loong ah neng thung rapne phaangdat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Saahaap loong ah ih Jaasoon nyia heh joon loong ah chang rum ano daap haat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Rang ah nak kano, Teesu liphante loong ah ih Pool nyia Silas ah Beria ni kaat thuk rumta. Erah ni thoknyu ano, Jehudi rangsoomnok ni kanyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Erah hah dowa miloong ah Thesalonika mih thaknang ih roongwaan roongtiit ang rumta. Neng loong ah ih rangte tiit ah tenroon woksoon ih boichaat rumta, eno Pool nyia Silas ih baat nyuuta Rangteele ah ami aha jat suh ngeh ih saarookwet ih weh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mih hantek ih hanpi rumta, Grik nok hah minuh ejat esam loong ih nyia miwah loong ih uh hanpi ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Enoothong Thesalonika dowa Jehudi loong ah ih Pool ih Beria ni Rangte tiit baat japchaat rum ano Beria ni miloong ah roonphak ra rum haano daanmui thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Rangte ra choote loong ah ih Pool ah juukaang ko ih hotsoon kaat thuk rumta; enoothong Silas nyia Timothi ah Beria ni tangtong nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pool siitkaatte miloong ah Ethen ni maang thokthok ih siitkaat rumta eno Beria ni maang ngaakwang rumka di Pool ih Silas nyia Timothi ah kharok ih toom chokhoom nyuuha ngeh ih maatbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pool ih Silas nyia Timothi Ethen ni ban nyu adi, erah samnuthung dowa miloong ah sok ano rapne ih thungthita. ");
INSERT INTO tvt_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Erah raangtaan ih Pool ah Jehudi rangsoomnok ni Jehudi nyia Ranglajatte Rangte rangsoomte eh hoon rumta loong ah damdi roongwangta, eno erah di o mina thaangsangte daankhoomta loong ah damdi nep roong waanta. ");
INSERT INTO tvt_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikuria nok hah nyia Stoik nyootsootte nep ih Pool damdi daanmui rumta. Mararah ih cheng rumta, “Arah ih tiim uh lajat kaadi tiim jengte jengla?” Wahoh loong ah ih ngaak baatta, “Mideek mikaan Rangte tiit ta baat ha nih.” Arah jengkhaap ah Pool ih Jisu nyia ngaaksaat tiit baat kano li rumta. ");
INSERT INTO tvt_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Erah thoidi Pool ah samnuthung ni Ariopagus Ngoongthum thengni siitkaat rum ano cheng rumta, “An ih ena ena nyootsoot hu ah tiimjih suh liihu. ");
INSERT INTO tvt_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mararah ah seng ih dookdah ih chaat hi, erah ah ju tiimsuh liiha ngeh ih jat suh liihi.” ");
INSERT INTO tvt_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Ethen nok hah nyia mideek nawa thok songtongta loong ah ena ena tiitwaan chaat suh nyia jat suh karam rumta.) ");
INSERT INTO tvt_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pool samnuthung dowa Ngoongthumte ngathong ni toonchap ano jengta, “Sen Ethen nok hah loong ah thooroom mina. ");
INSERT INTO tvt_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tiimnge liidi sen hadaang ni tumkhoom lang adi sen rangsoom theng ni, thong ni raanghan ah emah raang arah japtuptang, ‘Lajatke Rangte suh.’ Heh men lajat kan ah soomtu han, ngah ih erah laangbo nyootsoot rumhala. ");
INSERT INTO tvt_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Mongrep nyia erah khui ni tongtongla hoonte Rangte ah juuba rang nyia hah raangtaan ih Teesu eno heh mabah uh mina ih hoon hi rangsoomnok nah tatongka. ");
INSERT INTO tvt_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Adoleh seng jiin nawa tiim uh tasuh ri, seng roidong, sengtak senglak jaatrep heh teeteewah ih koh hali. ");
INSERT INTO tvt_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Mina wasiit dowa warep waraang loong jaat thuk ano mongrep noongrep ni songtong thukla. Rangte heh teeteewah ih maang edook mathan saajang nyia marah hah adoh songtong theng ah erah thiin choi. ");
INSERT INTO tvt_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Erah ah tiim esuh liita, mina ih Rangte ah jam ih ah, adoleh erah jam rum adoh mok chojam ih rum ah. Ang ah bah uh Rangte ah seng loong taangnawa haloot ni bah tah angka; ");
INSERT INTO tvt_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","o ih bah uh li eta, ‘Heh damdi tongli, heh damdi khoomli, heh dam di hak li.’ Boongkaat seehoon leedap raangte sengdung dowa ih liita, ‘Seng loong ah uh hesuh hesah.’ ");
INSERT INTO tvt_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Seng Rangte suh hesuh hesah lek angleh, lamok thun theng hebanlam ih hun adoleh kom nyia jong, mina lak ih miihoon ha likhiik ang ah ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Maangdoh bah jirep ah Rangte ih heh men maang jat doh tasam sokta, enoothong amadi mirep suh sekthun etheng ngeh ih baat ha. ");
INSERT INTO tvt_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tiimnge liidi, heh ih danjeeta loong asuh arah hah ah dande thuk suh rangwu saakaan thiin eha. Tek nawa saatsiitta warah jun ih mirep suh heh ih jat ih thuk hali!” ");
INSERT INTO tvt_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pool ih tek nawa ngaaksaat tiit baat kano mararah ah doondaak siitkook ih rumta, eno mararah ih liita, “Seng suh arah jengkhaap ah we bootbaat ih weehe.” ");
INSERT INTO tvt_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Erah lomkhoon rumta dowa Pool ah doksoon ih kata. ");
INSERT INTO tvt_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Miwah mararah ih hanpi ih rum ano roongroop rumta, neng damdi Dionisius nep roong roopta, minuh nusiit Damaris nyia, mih wahoh loong ah uh eje angta. ");
INSERT INTO tvt_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Erah lih dophi, Pool Ethen nawa Korin ni wangta. ");
INSERT INTO tvt_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Erah ni Jehudiite wasiit Akuila ngeh ih chomuita, heh Poontus ni tup arah angta, nengnyi heh minuh Prisilla ah langla, Luuwanglong Kladius ih Room hah nawa Jehudi loong ah dokphan rum kano erah ngangah ih Itali nawa ra nyuutaha. Eno Pool ah erah nyi damdi, ");
INSERT INTO tvt_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ngunbi suh nok roonghoon waktong wangta, tiimnge liidi Pool uh nengnyi likhiikkhiik ih hetui hewok raang ih nok hoon nawa ngun kabiita. ");
INSERT INTO tvt_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pool Jehudi rangsoomnok ni Naangtongsa rookweh Jehudi nyia Grik damdi roongwaan leh kataat nuune rumta. ");
INSERT INTO tvt_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Mesidonia nawa Silas nyia Timothi ah thoknyu kano, Pool ih saapoot ah saarookwet Rangte tiit baat suh kota, Jehudi loong suh Jisu juuba Kristo ngeh ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Mina loong ah ih ethih ethih jeng rum ano Pool suh liirum kano, neng jeng daan lakbi ah heh nyuh dowa botla ah jaabuh ano li rumta, “Sen mat e an bah sen teeteewah suh joong an! Nga mat tah angka, Arah dophi bah ngah Ranglajatte taangko ih kah ang.” ");
INSERT INTO tvt_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Erah lih adi neng re dowa doksoon kah ano, Ranglajatte mina Rangte rangsoomte ih hoon arah, heh men Taitias Justus kapoon rumta nok ni tong kata; heh nok ah Jehudi rangsoomnok reeni angta. ");
INSERT INTO tvt_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kispus ah Jehudi rangsoomnok ni mihak phokhoh angta, heh teewah nyia heh jaatang loongtang Teesu hanpiite ang rumta; Korin ni uh Rangte jengkhaap ah chaat rum ano hanpiite rapne ih dong ano ju ah tem ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pheesiit Pool suh motmang ni heh Teesu ih baatta, “An nakcho uh, erah nang ebah larit haat thang ih baat ba jangbaat theng, ");
INSERT INTO tvt_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","timnge liidi an damdi ngah eje. O ih uh tajen thet haatru; samnuthung adi nga mih rapne ih je ah.” ");
INSERT INTO tvt_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Erah raangtaan ih Pool paangsiit paangthom tongthiin ano, mina loong asuh Rangte Jengkhaap ah nyootsoot thiin rumta. ");
INSERT INTO tvt_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Akaia hah ni Gallio ah, Room nawa kobono angta doh, Jehudi loong lomkhoon rum ano, Pool ah joh ih rumta; eno mat hoon thengni siitkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Arah mih” rah ih seng “Hootthe ni lajeeka rah Rangte rangsoom thuk suh miloong asuh laatbaat rumha!” ");
INSERT INTO tvt_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pool ah jeng ih ang ngeh taat thun adi Gallio ih Jehudi loong asuh liita, “Arah matthih changkhah tiit ang dobah, Ngah ih mat ah hoon etheng tang Jehudi noksong loong.” ");
INSERT INTO tvt_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Enoothong, sen loong ah jengkhaap thoidi nyia sen Hootthe tungdi ba daanmui lan, erah tiit abah sensen ih hoonjih. Arah likhiik ah ngah ih tapaat korumra!” ");
INSERT INTO tvt_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Eno matpaat theng nawa phanhaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Erah lih adi Jehudi rangsoomnok dowa mihak phokhoh, Sosthens ah joh rum ano mat hoon theng nokka adi nobuh rumta. Enoothong tiim ih rum abah uh Gallio ah tasoot saamta. ");
INSERT INTO tvt_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Hanpiite loong damdi Pool Korin hani rekamdook tongthiinta, eno Prisilla nyia Akuila damdi Siria ni juulam ih daan soon wangta. Seneria ni maang daansoon kaadi, heh ih thoomhoon thoidi heh khoh ah suihaat eta. ");
INSERT INTO tvt_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ephesas ni thokrum ano, Pool ih Prisilla nyi Akuila ah thiinhaat ih nyuuta. Pool Jehudi rangsoomnok ni kah ano, Jehudi loong damdi roongwaan kata. ");
INSERT INTO tvt_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Miloong ah ih rekam tongthiin taatbaat rumta, eno Pool tanookta. ");
INSERT INTO tvt_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Erah nang ebah Pool ih kaat elang ngeh ih baatthiin rum ano amah jeng thiinta, “Rangte tenthun mongtham ang abah sen jiinnah we ngaakwang ehang.” Erah baat rum ano Ephesas nawa juulam ih daansoon kata. ");
INSERT INTO tvt_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pool Kaisiria ni thok ano, Jerusalem chaas ni kata, eno jengseera ano, Entiok ni wangta. ");
INSERT INTO tvt_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Erah ni chomroe tongthiin ano, Galitia nyia Phrigia hah lam ih wang ano chaankot jengkhaap ah hanpiite loong asuh jeng koh thiinta. ");
INSERT INTO tvt_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Erah tokdi Korin Jehudi mih wasiit, heh men ah Apollos, erah warah Alejandria ni tup dowa, eno Ephesas ni ra taha. Heh tiitwah loong angta eno Rangte Jengkhaap uh jat eta. ");
INSERT INTO tvt_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Teesu lampo ni khoom suh heh renbaat choi nyia nyootsoot choi angta, erah thoidi Jisu thoilam ah naririh ih nyootsootta. Erabah uh, heh ih Joon Juutem luulu ba jatta. ");
INSERT INTO tvt_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Heh Jehudi rangsoomnok ni lacho laphaan ih phang jengkongta. Prisilla nyia Akuilla ih heh jeng ah chaat nyu ano, nengnyi damdi nok ni siitwan nyuuta, eno Rangte lampo ah rapniine ih hukbaat nyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Erah lih adi Apollos Akaia ni kaat chungta, erah raangtaan ih Ephesas dowa hanpiite loong ah ih Akaia nok hah suh rapniine ih sokboi an ngeh ih le ah raangmaat ih rumta. Apollos thokkhoom ano, Rangte minchan di kristaan loong ah raangtaan ih neng moot chosok suh rapne ese angta. ");
INSERT INTO tvt_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tiimnge liidi, Apollos ah Jehudi loong damdi rapne daanmui ano Rangteele nawa ih Jisu ah Kristo ngeh ih jatthuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apollos Korin ni angta doh, Pool Ephesas hah noongrep ni tumkhoomta. Erah ni heliphante wasiit wanyi chomui ano ");
INSERT INTO tvt_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","cheng rumta, “Kristaan eh hoontan adoh Esa Chiiala chotam etan?” Eno neng ih ngaakbaat rumta, “Esa Chiiala eje ngeh ih taan boseh tajatke.” ");
INSERT INTO tvt_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","“Ese no bah ah, tiimjaat juutem tan?” Pool ih weecheng rumta. “Neng ih ngaak baatta” Joon juutem temti. ");
INSERT INTO tvt_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pool ih baat rumta, “Joon juutem ah langla o mina rangdah sekthunta erah mina ah raangtaan eh, eno Joon ih Ijirel mina loong asuh baatta nga lih ni kaatte tiit ah hanpi an—erah langla, Jisu.” ");
INSERT INTO tvt_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Erah chaat rum ano Teesu Jisu mendi juutem rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pool ih heh lak ih taajoot rum kano neng sak ni Esa Chiiala ah ra ih taha; eno erah miloong ah jengkhaap ena ena dongjeng rum ano Rangte tiitwaan ah baat ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Neng loong ah rooproop eh asih wanyi taan miwah ang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Laajom mongdi Pool Jehudi rangsoomnok ni kah ano miloong ah damdi lacho laphaan ih roongwaan kata, eno Rangmong tiit ah baat rum ano nuune rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mararah tenthun ah jong ajaan likhiik ang ano tahanpi rumta, eno nokwah dungni Teesu tiit ah ethih ethih ih jeng rumta. Eno Pool ih hanpiite loong ah siit ano doksoon kata, erah ni saarookwet ih Tirannas tiitwaan roongwaan nok adi roongwaan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Emamah paangnyi tongtha rumta, erah thoidi Esia hah ni tongte, Jehudi nyia Ranglajatte loong ah ih Teesu tiitkhaap ah japchaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Rangte ih Pool suh mabah uh lataat jat rumka paatjaajih loong ah reeraang thukta. ");
INSERT INTO tvt_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Theehut theng nyusah ah khoisatte reeni maatkaat koleh nyia huikaat koleh, maasat uh ede eta eno chiithih laakhah uh doksoon eta. ");
INSERT INTO tvt_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mararah Jehudi loong ah ih chiithih laakhah dokphan suh tum khoomte loong ah ih uh erah likhiik Jisu mendi taatthaak dokphan ih rumta. Erah loong ah ih chiithih laakhah asuh liita, “Pool ih baatta Jisu tiit ah mendi phan hala.” ");
INSERT INTO tvt_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Jehudi nok hah Romwah phokhothoon Sewa sah loong, wasinet ah ih emah taatthaak dokphan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Enoothong chiithih laakhah ah ih neng suh liita, “Ngah ih Jisu jat ih ang, Pool uh jat ih ang; enoothong sen—o ah?” ");
INSERT INTO tvt_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Chiithih laakhah pan warah doonpit ano neng loong ah nobuh rumta. Erah nok dowa, sokkhook maalook nyia nengnyuh nengkhat chiinhoom choi tiisoon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ephisus ni tongte Jehudi nyia Ranglajatte loong ah ih erah japchaat rum ano; rapne ih cho rumta eno Jisu men ah rapne ih raksiit rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Hanpiite loong ah ih nokwah dungni neng rangdah maangdi mokre rumta loong ah dokbaat ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Maantaan loong ah ih neng leedap ah piikaat rum ano nokwah dungni mattak rumta. Leedap thaang ah thaak weh rum ano, rooproop ih haajaat rookbangnga ngunkholok angta. ");
INSERT INTO tvt_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Erah likhiik Teesu tiitkhaap ah ehanhan ih ruurangta. ");
INSERT INTO tvt_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Erah lih adi, Mesidonia nyia Akaia ni tumkhoom ano Jerusalem ni wang suh Pool ih samthunta. Pool ih liita, “Erah hah nah wang lidoh,” “Room hah nah ngah wang jaatjaat etheng.” ");
INSERT INTO tvt_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Erah thoidi heh damdi roong mootkaatte Timothi nyia Erastas ah, Mesidonia ni wangthuk nyuuta, eno Esia hah ni Pool ah rekam tongthiinta. ");
INSERT INTO tvt_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Erah tokdi Ephesas ni Jisu lamphan thoidi rookmui jengmui rapne ih angta. ");
INSERT INTO tvt_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tongmih mi hoonte, Demetrias ngeh ih angta ah ih Artemis Rangte nok laaphaang ah hoon ano, heh damdi reeraang paknaate loong asuh ngun rapne ih bi thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Erah thoidi heh pheehoon mootkaat likhiik o ih hoonta erah miloong ah khoonpoon ano baat rumta. “Jaaroh loong, sen ih jat ehan seng chang ah arah dowa ih tanih tengli. ");
INSERT INTO tvt_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Eno sen ih taatsok thaak an nyia sen na ih taat chaat thaak an Pool ih tiimjih hoon wan hala. Pool ih baat rumha lak ih hoonha ah mabah uh rangte tah angka, eno Ephesas nyia Esia hah re dowa miloong ah rapne ih roonphak rumha. ");
INSERT INTO tvt_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Seng pheehoon mootkaat ah rakmu riike nyia cho etheng ih hoonla. Erah luulu lah angthang eh, Artemis men arang ju maat ih baat ah, erah thoidi cho etheng ih hoonla—heh rang ah Esia nyia hakong rookwet ni tanih soomha!” ");
INSERT INTO tvt_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Erah jengkhaap ah chaat rum ano mih lomkhoon rumta loong ah rapne ih khah rum ano riiraak rumta, “Ephesas dowa Artemis ah rakla!” ");
INSERT INTO tvt_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Erah chikrok tiit ah samnuthung noongrep ni ruurangta. Mesidoniate wanyi Gaius nyia Aristarkos, Pool damdi roong tum khoomte anyi, miloong ah ih seehoon boongkaat nok adi hoom kaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pool heh teeteewah midung ni kaat suh taat liita, eno hanpiite loong ah ih takaat thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Erah hah dowa, marah marah ngoong awang Pool joonte loong ah ih uh, seehoon boongkaat nok adoh nak toom tupkhoom kawe ah ngeh ih jengkhaap maatbaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Erah pootdi ngoongthumte loong ah rapne ih phaangdat rumta; miloong ah jihoh jihoh riiraak rumta, mamah liidi neng dung ni mih ehanko ah ih tiim thoidi lomkhoon wang rumta erah tajat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Jehudi mihak phokhoh loong ah ih Alekjendar ah tiim jeng theng ang abah uh an jeng theng li rum ano ngakhoh ko tut haatkaat rumta. Eno Alejander ih nak hoopti an ngeh ih heh lak ah tangjap ano neng teewah pangjeng jeng suh taat chungta. ");
INSERT INTO tvt_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Eno neng ih Jehudi ngeh ih jatrum ano phoosiitsiit tiit ah koonta nyi riiraak rumta: Ephesas dowa Artemis ah rakla!” ");
INSERT INTO tvt_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Lithoon ni samnuh dowa apit ni mootte warah ih miloong ah kok manghoop rumta. “Ephisas phoh ano loong!” “Warep ih jat eha Ephesas samnuthung ah Artimis rangsoomnok nyia esa jong thiinte, eno erah jong ah rang nawa dat taha ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","O ih uh tajen daanka. Erah raangtaan eh, sen lahoopti theng, lalangka ah lareeraang theng. ");
INSERT INTO tvt_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Arah mih anyi ih seng rangsoomnok uh tathet haatka adoleh rangte tiit uh labaat nyuuka di siitkaat halan. ");
INSERT INTO tvt_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetrius nyia heh mootkaatte loong ah ih o tiit hoontheng ang abah uh, sen tiit hoonkotte elong elang eje adoleh tiit hoon theng nok uh saarookwet raangtaan ih eje; tiit ah erah doh hoon theng. ");
INSERT INTO tvt_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Adoleh, tiit ajeng ah erah nang ih elong ih hoon theng li an baleh, nok atang loongtang ngathong nah tiit ah hoon theng. ");
INSERT INTO tvt_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Chiinnyah tiit ajeng arah dongla lidoh, cho etheng eje mat ah o ih chaang theng ah. Arah mat dong hoomte ah biin anaan tahoonru; seng ih uh tiim thoilam di ang koja erah tami baatke.” ");
INSERT INTO tvt_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Erah jengkhaap jeng lidi, ngoongthumte loong ah saapsoon ih thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Hoongrok haphaang ah sem lidi, Pool ih hanpiite loong ah khoonpoon rum ano, chaankot jengkhaap ah jeng koh rum ano raajeng rumta eno Mesidonia ko ih wangta. ");
INSERT INTO tvt_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pool erah hah lam ih wang ano chaankot jengkhaap ah miloong asuh rapne ih koh thiin rumta. Erah lih adi Akaia hah ni thok ano, ");
INSERT INTO tvt_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","laajom tongthiinta. Siria nah wang ang ngeh ih taat khookhaam adi Jehudi loong ih heh tek haat suh kaankoong rumta ah Pool ih jatjoot eta; erah raangtaan ih Pool Mesidonia lam ih ngaakwang chungta. ");
INSERT INTO tvt_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Heh damdi Puros sah Sopater, Beria hah nawa roongwangta; erah damdi Thesalonika nawa, Aristarkas nyia Sekundas, Derbe nawa Gaius, Esia hah nawa langla Taichikas nyia Trophimas; eno Timothi loong ah nep wakwang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Neng loong ah sengngah sengngah ban wangrum ano Troas ni banwan tahe. ");
INSERT INTO tvt_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Toomuh Kham Kuwaang lih adi Philippi nawa juulam ih daansoon eno, sa bangnga lidi Troas ni chomui eno erah ni sa sinat tongthiinti. ");
INSERT INTO tvt_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Huuniibaat rangja di rang chosoomti adi phaksat ah room phaksah eti. Pool erah saalih adi rangkhano ih wangte ang ano, miloong ah damdi rangphe thungkham di thok roong waanta. ");
INSERT INTO tvt_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Seng khoontongti nokkhoh adi weetook loong ah phaak eta. ");
INSERT INTO tvt_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Jaaro wasiit heh men ah Eutikaas ngeh ih angta ah wokaacha ni tongta, eno Pool ih tiitwaan jangbaat adi, Eutikaas ah heh jupmot ih ngotdatta, eno mokjup ano nokkhoh thoongjom khoh nawa datti kata. Taat toonpi karum ano, tekmang angta. ");
INSERT INTO tvt_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Eno Pool ah echaan ih daatkhoom kah ano khekjoh kata. “Nak sotsaam an” Pool ih baat rumta, “amadi heh ething!” ");
INSERT INTO tvt_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Eno lamtok nokkhok adi we ngaakwang ano, baanlo ah chep hoom phak wangta. Neng damdi rekamdook eh rangsa laandongroh roongwaan rum ano Pool ah doksoon kata. ");
INSERT INTO tvt_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Jaaro ah nok ni ething ih piikaat rum ano miloong ah neng ten kokchem rumta. ");
INSERT INTO tvt_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Assos nawa Pool ban toonhui kaat suh seng juukaari ni jaakhoh ban daansoonti. Emah eh kaat theng ngeh ih Pool ih baatthiin tahe, eno heh ah saanghook lam ih wangta. ");
INSERT INTO tvt_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Assos ni chomui eno, Mitilene ne kaat suh toonhui kati. ");
INSERT INTO tvt_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Erah dowa juulam ih daansoon kah eno Kios ni saasiit adi thok kati. Erah saalih adi Samos ni thokti, erah lih adi Miletus ni thok wangti. ");
INSERT INTO tvt_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Esia hah nah rangsa photham ah ngeh ih li ano, Pool ih Ephesas ni wang chungta. Lek jen ang abah, Jerusalem nah Pentikos maangdoh thok suh ngeh ih thuuhuuta. ");
INSERT INTO tvt_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pool Miletus ni ang adi Ephesaste suh, chaas mihak phokhoh loong toom chomui rumha ngeh ih jengkhaap maatbaatta. ");
INSERT INTO tvt_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Eno heh jiinni thokrum kano li rumta, “Sen ih jat ih han sen damdi ang tahang adoh ngah tiimthan saajang mamah ih roongtong tahang, Esia hah nawa phangthok sa dowa ih ah. ");
INSERT INTO tvt_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Jehudi loong ih nga tek haat taatchung tahang adoh nga mikse ah janhaat angno Teesu laksuh angkang ngeh ih rekamdook ih seklilih ih mokah tang. ");
INSERT INTO tvt_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Sen raangtaan ih mamah doh se ah li angno tiim nyoot theng angta nokwah dungni ni nyia sen nok ni thoontang nyootsoot rum taha. ");
INSERT INTO tvt_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Jehudi nyia Ranglajatte loongtang suh phoosiitsiit ih baat rum tang sen rangdah nawa Rangte jiinko wang hanno Teesu Jisu hanpi an ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Amadi bah ngah Esa Chiiala jeng chaatchaat ih Jerusalem ko ih kalang, erah nah mamah ang koja ngah ih tajatkang. ");
INSERT INTO tvt_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ngah suh Esa Chiiala ih erah ba baat halang samnuthung rookwet ni chamnaang nyia phaatak ah nga raangtaan ih ban tong roh ela ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Enoothong ngah ih hanpi hang nga roidong ah tiimtha uh tah angka; ngah ih hanpi hang Teesu ih mootthuk halang ah ba mokah ang, erah langla Rangte minchan ruurang tiit ah tumbaat theng. ");
INSERT INTO tvt_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ngah sen loong hani tumkhoom lang, eno Rangte hasong tiit ah tumbaat hang. Amadi ngah ih jat ehang sen ih ngah mabah uh takah japtup ri ang ah ");
INSERT INTO tvt_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Erah raangtaan ih chiinnyah baat rumhala: Sen loong ah emat ih anbah nga matkapjih tah angka. ");
INSERT INTO tvt_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Tiimnge liidi Rangte tenthun tiit ah mathan angta thoontang baat ih rum taha. ");
INSERT INTO tvt_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Erah raangtaan ih Esa Chiiala ih sokboi thuk halan saapsah loong ah rapniine ih sokboi an. Hesah sih jun ih Rangte chaas ni sen loong ah saapriimte heh sah angthuk halan. ");
INSERT INTO tvt_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ngah ih jat ehang nga doksoon lidoh, so loong ah sendung nah wang haano, saap ah tachiimka ang ah. ");
INSERT INTO tvt_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Saapoot thok ha doh miwah loong ah ih mih mokwaan rum ano hanpiite loong ah pheehoom rum ah eno neng lih phanjoot thuk rum ah. ");
INSERT INTO tvt_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Erah raangtaan ih naririh ih tongtha an, paangjom adi rangwu rangphe ih nga mikse ah janhaat angno nyootsoot rumhala ah samthun roh ih an. ");
INSERT INTO tvt_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Sen loong ah Rangte lakhui ni nyia heh minchan jengkhaap ni look haat rumhala, eno juuba Rangte ih heh mina raangtaan ih thiinha minchan khui nah hak thuk suh romseetam kohan. ");
INSERT INTO tvt_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ngah ih o jiin nawa hun, kom nyia nyuh akhat tasuh rumra. ");
INSERT INTO tvt_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Sen teenuh teewah ih jat ehan nga raangtaan nyia nga joon loong raangtaan ih nga laklak ih ngun ah bi angno phaksahi. ");
INSERT INTO tvt_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Seng loong asuh jirep ah noisok rumhala motchaan kaatchaan ah kah eno changthih noodek suh mamah ih chokot theng ah, Jisu ih baat tahan jengkhaap ah samthun roh ih an, “Echoh ehi nang ih ekot ehi ah tenroon ehan.” ");
INSERT INTO tvt_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pool thoonjeng ano, neng damdi heh lakuh ni chooktong ano rangsoomta. ");
INSERT INTO tvt_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Mih thoontang hu rum ano chupphak rumta eno khekjoot damdi raajeng rumta. ");
INSERT INTO tvt_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pool ih takah chotup ri li kano miloong ah ehan thungthih rumta. Eno juukaari adi diisiitkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Neng damdi raajeng thiin eno kati. Ju adi phangla ih daan jopkaat eno, Kos ni thok tahe, erah saalih adi Rhodes ni, erah dowa ih Patara ni kati. ");
INSERT INTO tvt_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Erah ni kah eno Phoenesia ni wangte juukaari esiit japtup kati, erah di duukah eno daansoon wangti. ");
INSERT INTO tvt_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Erah di Kipras ah japtup kati, juumeh ko ih Siria ni daanjoop wanti. Tair hah adi juukaang ko wang eno, juukaari ah ih huikhaak loong ah datthiin eta. ");
INSERT INTO tvt_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Erah hah adi hanpiite loong ah damdi sa sinat tongthiinti. Chiiala chaan nawa ih Pool suh neng ih Jerusalem nah nak kaat theng ngeh ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Enoothong neng damdi jen roong tongthiin eno, seng kaat theng lamko ih dokchap kati. Samnuthung dowa miloong ah neng sanuh nyia neng sah loong ah siit ano juukaang adi roongra rum taha, erah di seng lakuh ni tong eno rangsoomti. ");
INSERT INTO tvt_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Eno seng loong ah raajeng mui eno, juukaari ni toon du ti neng ah engaak wang ih rumta. ");
INSERT INTO tvt_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Seng Tair dowa juulam ih karoh karoh eti eno Ptomais ni tong kati, erah ni hanpiite loong asuh jengse ah ra eno sasiit tong kati. ");
INSERT INTO tvt_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Erah saalih adi dokchap eno Kaiseria ni thokti. Erah ni Ewanjelist Philip nok ni jam kati, wasinat tung dowa heh Jerusalem ni tongte kristaan loong chosokte danje dowa. ");
INSERT INTO tvt_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Heh sah jaalah wabajiiji hasong maangkah ang rumta eno neng Rangte tiit baatte ang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Agubas khowah Judaia nawa thok taha doh seng erah ni sa sinat tongti. ");
INSERT INTO tvt_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Heh seng reeni wang haano, Pool romkhe ah suh eta, eno romkhe ah ih heh teewah lak alah ah kit ano jengta, “Esa Chiiala ih amah liiha: Roomkhe changte warah Jerusalem nah Jehudi loong ih emamah ih khak ano Ranglajatte loong suh korum ah.” ");
INSERT INTO tvt_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Erah chaat eno, erah hah dowa phoh ano loong nep roongjeng taha, Jerusalem nah lakaat weetheng ngeh ih taat chuut hu ti. ");
INSERT INTO tvt_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Eno Pool ih ngaakli tahe, “Sen tiimte hu lan, nga tenthun tiim esuh saap thuk lan? Ngah Jerusalem nah emah ih kitsuh luulu takhookham kang, Teesu Jisu raangtaan ih etek esuh nep khookham hang.” ");
INSERT INTO tvt_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Lakah jen nuune baattaan keeno liiti, “Teesu tenthun mongtham ju toom ang ah.” ");
INSERT INTO tvt_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Chomroe tong eno, seng huikhaak ah jamjaang eno Jerusalem ni kaat suh dok chapti. ");
INSERT INTO tvt_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kaisiria nawa heliphante mararah ah seng damdi roong ra taha eno Mnason nok ni naangjam suh siitkaat tahe—heh langla Kipras hah nawa angta maang ih dook Rangte menjatte ah. ");
INSERT INTO tvt_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalem ni thok kino, Rangte menjatte loong ih tenroon woksoon ih lam banchoh tahe. ");
INSERT INTO tvt_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Erah saalih adi Jeems damdoh chomui suh Pool seng damdi roong ra taha; eno erah ni chaas nawa mihak phokhoh loong eje ang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pool ih jengkhaapse ah ra rum ano Ranglajatte loong damdi heh teewah Rangte ih mamah ih maakta nyia mootkaat thukta tiit ah baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pool jeng ah boichaat rum ano loongtang ih Rangte rangphoong rumta. Eno li rumta, “Seng loong phoh ano Pool, an ih tup eh hu haajaat mathan Jehudi loong ah rangsoomte eh hoonla, enoothong neng loong ah Hootthe lam ah phanroh ih rumha. ");
INSERT INTO tvt_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Jehudi loong ih jen japchaat eta, an ih Ranglajatte deek akaan ni songte Jehudi loong suh Moses Hootthe ah lakah kap theng nyia nengsuh nengsah khoopkhan banlam ah lahoon theng adoleh Jehudi banlam ah lakah kap theng ngeh ih nyootsoottu rah ah. ");
INSERT INTO tvt_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Neng ih an thok ah jat jaatjaat eha. Eno, mamah etheng ah? ");
INSERT INTO tvt_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Seng ih thun hi abah an ih emah re udoh phan ah. Arah di thoomhoon choi mih wabaji je ah. ");
INSERT INTO tvt_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Chingkhothook thengnah neng damdoh roong kah uno neng lakkhoom ladi thaang ah koh eh uh; eno juuba neng khoh ah sui eh ah. Emah ang ano ba mirep ih an tiit waanla ah tiit hu ruurangla ngeh ih thun rum ah, erah nang ebah heh teewah jaatjaat eh Moses Hootthe jun ih songtongla ngeh ih thun rumho. ");
INSERT INTO tvt_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Enoothong Ranglajatte dowa o mina ih Rangte men jat ha, erah loong asuh seng roongwaanti tiit ah le jen raangmaat eti; romchoi phaksat ah laphaksat theng, khoisat luiamaan ah laphak theng, hesih laphak theng, adoleh mih damdoh roomjup roomtong laje theng adoleh sak lapiin theng ngeh ah.” ");
INSERT INTO tvt_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Erah raangtaan ih Pool ih miloong ah siit ano erah saalih adi neng damdi chingkhothook roong kata. Eno Pool Rangteenok ni wang ano leeraang ah amah raang ano rapwanta; chingkhothook ah sa mathan doh thoon ah adoleh khojoop ah wasiit wasiit suh mabah hoonkot theng ah. ");
INSERT INTO tvt_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Sa sinat thoon nanah di, Esia hah nawa Jehudi loong ih Pool Rangteenok ni japtup wang rum taha. Neng loong ah ih mih khoontongta loong ah phaangdat thuk rum ano Pool ah jokhak eh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Neng loong ah riiraak rumta, “Ijirel noksong loong!” “Roong johe! Arah mih ah langbo ah noongrep ni Ijirel mih thetbaatte, Moses Hootthe thetbaatte nyia arah Rangteenok thetbaatte ra ah. Eno Ranglajatte mih nep siitwan haano arah esa Rangteenok ah nyaansaan wang hala!” ");
INSERT INTO tvt_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Erah jeng rumta ah langla Epheses nawa Triphimus ah Pool damdi samnuh ni japtup rumta, eno neng ih thunta Rangteenok ni Pool ih nopsiit eh wan hala ngeh ah.) ");
INSERT INTO tvt_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Samnuh thungtang hoongrok haphaang chikrokta, miloong ah khoonsoon ano, Rangteenok nawa Pool ah dok hoom ih kaat rumta. Lakdamdam eh Rangteenok paakaalu ah tangsak eh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Room nok hah arami saahaap ih Jerusalem ni chikrokla ah japchaat tokdi miloong ah ih Pool tek haat taatchung rumta. ");
INSERT INTO tvt_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Erah japchaat ano arami loong nyia saahaap wahoh loong ah siit ano saahaap elong ah lakdamdam eh miloong ah taangko karumta. Arami loong ah siit ano kaat kano, miloong ah ih Pool buh rumta ah toihaat eh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Saahaap elong ah Pool taangko wang ano jowangta eno jaanruh enyi ih kit thuk rumta. Erah lih adi chengta, “Arah mih ah o angla, tiimjih thet kota?” ");
INSERT INTO tvt_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Mih lomkhoon rumta dowa wasiit maama wasiit maama eh riiraak rumta. Hoongrok haphaang ang kano saahaap elong ah ih tiimjih mamah angla erah tajat jota, erah raangtaan eh heh mina loong asuh Pool ah sipaahi tongtheng adi siitkaat thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Miloong ah Pool likapkap eh kaat rum kano sipaahi loong ah ih Pool ah toonhui eh rumta tiimnge liidi miloong ah woma si thung ang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Miloong helih helih phanri rumta, “Tek haat etheng tek haat etheng ngeh ah!” ");
INSERT INTO tvt_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Arami loong ah ih Pool ah sipaahi tongtheng ah noppi nanah di saahaap elong asuh chengta: “An suh tiim atiim tambaat weeha?” “Grik jenglam ih waanho, miijeng nih kah eh uh?” Saahaap elong ah ih chengta. ");
INSERT INTO tvt_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Miinyah marang changrook donghoom uno hajaat baji mina phisang hah ni siiara hoonkaat thukte Ijip mih ah an tanih angko?” ");
INSERT INTO tvt_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pool ih baatta, “Ngah Jehudi nok hah, Kilia dowa Tarsas samnuthung ni tup hang ah. Miloong ah damdoh roongwaan weethuk hang.” ");
INSERT INTO tvt_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Saahaap elong ah ih jeng thukta, eno Pool ah diihutok adi toonchap ano miloong asuh nak hoopti an ngeh ih heh lak japta. Miloong ah tikdat kano Pool Hebru jengdi baatta: ");
INSERT INTO tvt_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Jehudi phoh ano loong, boichaat thaak he sen ngathong ni nga puipang tiit jenglang rah ah!” ");
INSERT INTO tvt_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hebru jenglam eh waan rum kano, ehanhan eh tikdat rumta, eno Pool ah jangjeng kata. ");
INSERT INTO tvt_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ngah Jehudi nok hah, Silika hah Tarsas ni tup hang rah, enoothong Gamaliel le wette ang angno Jerusalem hah aradi hak ang rah. Ngah ih sengte sengwah Hootthe ah rapne eh nyoot angno, chiinnyah sen ang lan ah likhiik ngah uh Rangte lakni lok hang rah. ");
INSERT INTO tvt_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Teesu lamphante loong ah ngah ih lanti laan mah roh eh siiwi rumtang. Minuh miwah jokhaakleh phaatak ni sak rumtang. ");
INSERT INTO tvt_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Romwah phokhothoon nyia Ngoongthumte loong ih nep jen deenbaat ehan ngah ih ami tam aha tiit baat hang rah ah. Nengphoh nengno Damaskus ni tongte loong asuh le ah raangleh nga lak ni kakoh rum tahang , enooleh Damaskas dowa kristaan miloong ah jaanruh ih kitleh Jerusalem ni kasiiwi wan rum tahang. ");
INSERT INTO tvt_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Damaskas hah thok nanah di, rangnithung di rang nawa nga reeni weephaak ah likhiik eh phaak ra taha. ");
INSERT INTO tvt_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Hah ni loongdat angno ngasuh liihang rah miroot japchaat tang, ‘Sool, Sool! An ih tiim esuh siiwi halang?’ ");
INSERT INTO tvt_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","‘Eno chengtang, Teesu an o anglu?’ ‘Ngah Najaret hah dowa Jisu, an ih siiwi halang ah,’ ngeh ih ngaakli tahang. ");
INSERT INTO tvt_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nga dam dowa miloong ah ih weephaak ah tup eh rumta, enoothong erah waan taha root ah tachaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ngah ih chengtang, ‘Teesu, ngah ih tiimjih eh ang?’ Eno Teesu ih ngasuh baat tahang, ‘Toonchap uh Damaskas nah kah uh, an ih tiim etheng ah Rangte ih erah nah baat ho.’ ");
INSERT INTO tvt_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Weephaak nawa ih edook eh hoontang, erah thoidi nga joon loong ah ih nga lakni siit rum hangno Damaskas ko kati. ");
INSERT INTO tvt_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Erah samnuthung adi sengte sengwah Hootthe jatte Ananias ngeh ih mih wasiit angta, heh erah hah adi songtongte angta nyia Jehudi loong ih rapne eh choomjoh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Heh nga reeni chapwang haano, li tahang, nga no ‘Sool, weetup eh uh!’ Erah jeng damdam eh kaasok angno heh japtuptang. ");
INSERT INTO tvt_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ananias ih baat tahang, ‘Sengte sengwah Rangte ih heh tenthun mongtham ah jatthuk suh danje halu, adoleh heh laksuh kateng tiit ah jatthuk suh, nyia heh jeng ah boichaat suh danje halu. ");
INSERT INTO tvt_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tiimnge liidi, an ih tiim chaat hu nyia tiim tup hu erah ah mirep miraang suh toombaatte angthuk suh ngeh ih li halu. ");
INSERT INTO tvt_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ano bah, an ih tiimjih ma kaban uh? Toonchap uthong, an rangdah ah saasiit suh rang ah soom uno ju nah thong tem kah uh.’ ");
INSERT INTO tvt_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Jerusalem ni ngaakwang angno, Rangteenok ni rangsoom tang adi, ");
INSERT INTO tvt_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","motmang ni, nga Teesu tuptang, eno heheh ih baat tahang, ‘Jerusalem nawa kharok eh doksoon uh, arah dowa miloong asuh nga tiit ah laatbaat ubah uh tabaam boichaat ru ang ah.’ ");
INSERT INTO tvt_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ngah ih ngaakli tang, ‘Teesu,’ ‘Ngah Jehudi Rangsoomnok ni kah angno an liphante loong ah jokhak katang nyia buthom tang ah neng ih jat eha. ");
INSERT INTO tvt_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Eno an haaki Stephen tek haat rumta doh, ngah eje angtang, heh tek thukte nyia heh tek haatte nyuh akhat sokboite aju ngah angtang.’ ");
INSERT INTO tvt_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Eno nga Teesu ih baat tahang, ‘Kah uh’ ‘tiimnge liidi an Ranglajatte loong reenah haloot nah kaat thuk ha.’” ");
INSERT INTO tvt_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Miloong ah ih Pool jengkhaap ah maang thoon jengjeng eh boichaat rumta; eno erongwah ih riiraak rumta, “Phanhaat eh an! Tek haat eh an! Heh ething tong theethe tah angka!” ");
INSERT INTO tvt_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Miloong ah riiraak rum ano, neng nyuh ah jap eh rumta, botbung ah rangkhoh ni wenhaat eh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Room nok hah arami saahaap elong ah ih heh mina loong asuh Pool ah sipaahi loong tongtheng ni siitkaat thuk rumta, eno Pool thoidi Jehudi loong erah than tiimnge ih riiraak rumta ah jatjoot suh Pool ah botthuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Enoothong bot esuh ngeh ih taatkit rum adi, heh reeni chapta saahaap asuh Pool ih chengta, “Heh thet re mat ah maang thaak hoonka doh Room nok hah ah mi botthom nih eh ah?” ");
INSERT INTO tvt_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Erah chaat ano saahaap ah, heh nang ih elong asuh cheng wangta, “Tiimjih hoon hu? Mih abah Room nok hah joh!” ");
INSERT INTO tvt_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Eno saahaap elong ah ih Pool suh cheng kata, “Baat thaak hang, an Room nok hah nih ah?” “Ele” Pool ih ngaakbaatta. ");
INSERT INTO tvt_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Saahaap elong ah ih liita, “Ngah ebah Room nok hah eh hoon suh ngun rapne ih kotang.” Eno Pool ih liita, “Ngabah tup tahang dowa eh Room hate.” ");
INSERT INTO tvt_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Pool suh chengte loong ah erah damdam eh heh re dowa neng liko eh heng soon rumta; eno saahaap elong ah Room nok hah mokkhak hang ngeh ih rapne eh choota. ");
INSERT INTO tvt_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Saahaap elong ah ih Pool aju Jehudi loong ah ih tiim thoidi thet haat suh liiha ngeh ih jat suh taat liita; erah thoidi erah saalih adi Pool lak dowa jaanruh ah jaahaat thuk ano Romwah phokhoh nyia noksong loongtang chomui thuk suh baat rumta. Eno Pool siitkaat ano neng ngathong ni chap thukta. ");
INSERT INTO tvt_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pool ih ngoomthumte loong taangko sok ano jengta, “Phoh ano Ijirel noksong! Chiinnyah tuk eh Rangte ngathong ni ngaathung ngaatak phanjangjang eh songtong lang.” ");
INSERT INTO tvt_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Erah chaat ano Romwah phokhoh Ananias ih Pool reeni chapte loong asuh heh tui ni mangbot suh baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Eno Pool ih Romwah phokhoh asuh liita, “An lonoite—Rangte ih amiisak eh baangbuho! Erah di tong uno Hootthe ah pi uno dande hu, ang ah bah uh nga baangbot baat hu ah ih an thet haat hu!” ");
INSERT INTO tvt_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Heh re tiittiit chapte loong ah ih Pool suh li rumta, “An ih Rangte Romwah phokhothoon kaanju hu!” ");
INSERT INTO tvt_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pool ih ngaakli rumta, “Phoh ano Ijirel noksong, Ngah ih Romwah phokhothoon ngeh ih tajattang. Rangteele ni liiha, ‘Mabah uh noksong pante suh an ih ethih lali theng.” ");
INSERT INTO tvt_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Miloong dung ni mararah ah Pharisi, mararah ah Sadusi japtup rum ano, Ngoongthum theng ni Pool ih dokpoon rumta, “Ijirel phoh ano loong! Ngah Pharisi sah, Parisiite ah. Tek nawa ngaaksaat lidoh roidong na suh laalom thoidi ngah adi thaak poon rum halang!” ");
INSERT INTO tvt_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Erah lih adi, Pharisi nyia Sadusis loong ah neng jaachi ni phang rookmui rum ano, dungnyi eh hoon rumta. ( ");
INSERT INTO tvt_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadusis loong ah ih liita mina tek nawa tangaak saatka, eno chiiala nyia heh kaamwah uh tajeeka; enoothong, Pharisi loong ah eh arah ejomjom hanpiiha.) ");
INSERT INTO tvt_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Erah thoidi we we boot riiraak eh rumta, eno Pharisi nok hah mararah Hootthe nyootte loong ah toonchap rum ano thidokdok eh daan rumta: “Arah mina thih arah tatupke! Heh damdi chiiala nyia rangsah tam roongwaan kotaaja!” ");
INSERT INTO tvt_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Choophaan phaan eh daanmui rum kano saahaap elong ah Pool maalek tek haat rumja oh ngeh ih choota. Erah thoidi heh bante loong ah datkhoom kah rum ano midung nawa Pool ah sipaahi tongtheng adi siitkaat thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Erah rangphe adi Pool ngathong ni Teesu ah chap ano heh suh baatta, “Nakcho uh! Jerusalem ni an nga haaki ang uh, eno Room nah uh emamah eh ang theng.” ");
INSERT INTO tvt_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Erah saalih adi Jehudi loong ah rangkhah di neng kaankoong tiit roongwaan suh khoontong rumta. Neng loong ah ih Pool maang tek haat haat tiim uh lajok phaksat theng ngeh ih kakham rumta. ");
INSERT INTO tvt_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Erah mongtham hoonte miloong ah rookbaji nang eh ehan ang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Eno Romwah phokhothoon nyia mihak phokhoh loong asuh baatwan rumta, “Seng ih Pool maang tek haat haat tiim uh lajok phaksat theng ngeh ih kakham hi joh. ");
INSERT INTO tvt_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Erah raangtaan ih Ngoong awang sen loong ah ih Room nok hah saahaap elong asuh Pool ah sen reenah toom siitkaat rumha ngeh ih maatbaat an, seng ih heh thoilam ah rapniine eh jat suh liihi ngeh ih diipli theng. Eno adoh maang thokra doh lam nah tek haat suh ban tong ih.” ");
INSERT INTO tvt_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Enoothong erah kaankoong ah Pool diik heh nah sah rah ih japchaatta; eno sipaahi tongtheng adi wang ano Pool suh hubaat wanta. ");
INSERT INTO tvt_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Eno Pool ih saahaap wasiit ah poon ano baatta, “Arah jaaro ah saahaap elong jiinnah siitwan uh; heh ih tiim atiim baat theng eje tih.” ");
INSERT INTO tvt_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Erah saahaap ah ih, elong ah reeni siitwan ano, baat wanta, “Pool phaatak ni sak hi eno heh ih poon hangno arah jaaro ah an reeni siitwan thuk halang, heh ih an suh tiim atiim baat theng eje tih.” ");
INSERT INTO tvt_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Saahaap ah ih heh lakni heh re tiittiit eh, johoom ano chengta, “Ngah suh tiimjaat baat theng ah.” ");
INSERT INTO tvt_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Eno jaaro ah ih baatta, “Jehudi dowa ngoong awang loong ah roongwaan rumta, rangkhah noksong reenah Pool siitkaat theng ngeh ih diipli rum ano, suwang rumho noksong ih heh thoilam ah rapniine eh jat suh li rumha tih ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Eno an ih nakmok boichaat uh, mih rookbaji nang eh ehan heh bansokte hutong rum ah. Neng ih kakham rumha Pool maang tek haat haat tiim uh lajok phaksat theng ngeh ah. Neng loong ah ih amadi an jengkhaap bansok halu.” ");
INSERT INTO tvt_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Saahaap elong ah ih liita, “Ngah suh baat halang ah o suh uh nakbaat uh joh.” Eno jaaro ah kaat thukta. ");
INSERT INTO tvt_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Eno saahaap elong ah ih saahaap wanyi poon ano baat nyuuta, “Kaisiria nah kaat suh sipaahi chaanyi, moksiitte rooksinat, pah piite chaanyi ban khookhaam an, niikja saapoot akhuh doh dokchap theng. ");
INSERT INTO tvt_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pool raangtaan ih mok ah koh anno Kobono Pheliks reenah eseetham eh thoksiit an.” ");
INSERT INTO tvt_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Eno saahaap elong ah ih Kobono Pheliks suh le ah raangmaat eta: ");
INSERT INTO tvt_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Elong elang Kludias Lisias, Kobono Pheliks: Jengkhaapse ra hala, ");
INSERT INTO tvt_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Jehudi loong ah ih arah mina ah joh ano tek haat taat eh rumta. Ngah ih chaattang heh Room nok hah, erah thoidi sipaahi loong ah siit angno pang wangtang. ");
INSERT INTO tvt_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Tiimthoi tiimlam di Jehudi loong ih mat eh jota erah ah jat suh ngeh ih neng Ngoongthum theng ni taatsiit kaattang. ");
INSERT INTO tvt_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Eno Pool tek haat theng nyia phaatak nah saktheng abah ngah ih tajat jokang; neng ih mat eh joha abah neng Hootthe chengmui thoidi. ");
INSERT INTO tvt_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Eno Pool tek haat suh kaankoong rumha ngeh ih chaat angno, lakdamdam eh an reeni wang thuk suh liitang. Mat eh deejootte loong asuh tiit ah an reenah hoon theng ngeh ih baat rum hang.” ");
INSERT INTO tvt_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sipaahi loong ah dokchap eh rumta. Erah rangpheeja Pool ah Antipatris maang thokthok eh siitkaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Erah saalih adi neng lah ih kaatte arami loong ah sipaahi tongtheng ni ngaakwang rumta eno moksiitte loong ah Pool damdoh wakkaat thuk suh erah ni thiinhaat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kaisaria ni thok rum ano Kobono asuh le ah chokoh; Pool ah thiinhaat koh eh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kobono ih le ah sok ano Pool suh o haate ah ngeh ih chengta. Silisia haate ngeh ih jat ano, ");
INSERT INTO tvt_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","liita, “An mat eh jootte loong thok ha doh tiit ah ma paat ih.” Eno Pool ah sipaahi loong asuh Kobono tongta nok adi ban thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Sa bangnga lidi Romwah phokhothoon Ananias ih hadaang phokhoh nyia mat hoonte Tartullos ah siit ano Kaisiria ni kata. Neng loong ah Pheliks ngathong ni Pool matjoot tiit ah baatwan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Eno Pool ah noppoon wan ano, Tartullus ih mat tiit ah Kobono suh amah eh baatkota: “Elong elang! An ejatthoon ang thoidi rekamdook eh jaaseemoong eh pan hali, eno sengdeek sengkaan ese ang raangtaan eh jirep ah huksiit wan halu. ");
INSERT INTO tvt_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Eno arah likhiik ah saarookwet eh noongrep ni seechoh hi, lang ekah ngeh ih ju liihi. ");
INSERT INTO tvt_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ngah ih an rangsa thamhoom suh tali kang, enoothong an ih amasah tiit hoon theng ah boichaat ih weetheng ngeh ih an lasih jowe hala. ");
INSERT INTO tvt_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Arah mih ah mih rookmui thukte nyia haphaang phakte; Jehudi jaachi ni noongrep ni mui phang donghoomha erah damdi Najaret dowa lamsiitte ah arah mih ah. ");
INSERT INTO tvt_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Rangsoomnok thetbaatte ah uh arah mih ah, erah thoidi jokhak hi. ");
INSERT INTO tvt_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Arah mih asuh cheng ubah, an teeteewah ih jirep ah jatjoh uh tiim esuh mat eh joh hi rah ah.” ");
INSERT INTO tvt_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jehudi loong ah matpaat thengni khoonthok rum haano amiisak tiit baat ha ngeh ih roongjeng rumta. ");
INSERT INTO tvt_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kobono ih Pool suh jeng uh ngeh ih heh lak japta, eno Pool ih liita, “Ngah ih jat ehang an ih arah deek adi rekamdook eh mat ah hoonkaat halu, eno an ngathong ni nga teewah pangjeng jeng suh tenroon ju. ");
INSERT INTO tvt_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","An teeteewah ih ju jat eh uh, Jerusalem ni rangsoom wangtang ah asih saanyi nang eju ehan tah angka. ");
INSERT INTO tvt_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Rangsoomnok ni o damdi daanmui angrah uh Jehudi loong ih tatup rang, tam aleh Jehudi rangsoomnok ni nyia samnuthung mani bah uh haphaang hoom ang rah tuprum tahang. ");
INSERT INTO tvt_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Neng ih mat eh jorum halang ah an suh tajen noisok rumru. ");
INSERT INTO tvt_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Arah jengkhaap ah ngah ih thang ehang: Ngah ih sengte sengwah Rangte lih phanhang eno neng ih tah angka ngeh ih liiha. Moses Hootthe ni raangha nyia khowah loong ih raangta ah ngah ih jirep ah hanpi ehang. ");
INSERT INTO tvt_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ngah uh neng laalomla likhiik Rangte suh laalom lang, mithih mise tek nawa ngaaksaat eh ah liiha ah uh laalom ehang. ");
INSERT INTO tvt_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Erah raangtaan ih Rangte nyia mina ngathong ni nga thung seklilih ansuh saarookwet eh thun hang. ");
INSERT INTO tvt_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Rekam lidi Jerusalem ni ngaak hangno, nga mina loong chosok suh nyia nga Rangte suh kot suh ngun ah hui eh wan tahang. ");
INSERT INTO tvt_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Eno Rangsoomnok ni khojoop hoon ang rah neng ih tup eh rum tahang. Nga damdi mih uh tanang jeeta hah uh taphaang phaktang. ");
INSERT INTO tvt_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Enoothong Esia nawa Jehudi loong marah marah eje angta; ngah matjoot jilam ang dobah nengneng ra haano an ngathong nah baatkaat theng rum taha. ");
INSERT INTO tvt_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Adoleh, arah miloong asuh cheng uh, nok atang ngathong ni toonchap tang adoh ngah matkapjih tiim jat chojoh rum tahang— ");
INSERT INTO tvt_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","neng ngathong ni toonchap tang adoh jaasiit ba jengtang: ‘Chiinnyah uh an ih tek nawa ngaaksaat tiit ah hanpi thoidi cheng halang.’” ");
INSERT INTO tvt_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Lampo ah jat ano Pheliks ih mat ah kharok eh hoon thukta. “Lisia saahaap elong ah thok taha doh” baat rumta, “Sen mat tiit ah ngah ih hoonkoh rumha.” ");
INSERT INTO tvt_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Pool sokboite saahaap asuh elong ah ih sipaahi ih rapniine toom ban rum ah ngeh ih baat rumta, enoothong hejoon hewaan uh toom chomui rum ah tiim kot theng ang abah uh toom koh rum ah ngeh ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Saajombaji lidi Pheliks nyia heh minuh Drusilla, Jehudi nok hah kapta ah siit ano ra taha. Pool ah poon ano Jisu Kristo suh tuumaang tiit ah roongwaan rumta. ");
INSERT INTO tvt_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Enoothong Pool ih ese tiit, enaan tiit nyia Dande Rangwu tiit jangbaat kano Pheliks ah echo eh ano liita, “amadoh an jen doksoon et uh. Saapoot je adoh we poonha.” ");
INSERT INTO tvt_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Erah damdi Pool ih ngun hekoh hang ngeh ih mok laalomta; erah raangtaan eh hepoot hepoot doh poon angno roongwaan ang ngeh ih thunta. ");
INSERT INTO tvt_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Paang nyi lih ang ano, Pheliks lidi, Porkus Phestas ah Kobono angta. Jehudi loong ih ese toom choh hang thun ano Pheliks ih Pool ah phaatak ni sak thiinta. ");
INSERT INTO tvt_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Sa jom lidi, Phestas ah Kaisiria dowa Jerusalem ni kata, ");
INSERT INTO tvt_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","romwah phokhoh nyia Jehudi dowa mihak phokhoh loong ah ih Pool mat hoon tiit ah erah ni hoonkaat rum taha. Neng ih Phestas ");
INSERT INTO tvt_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","lasih joh rumta Pool Jerusalem nah siitkaat theng ngeh ah, neng loong ah ih Pool ah lam nah tek haat theng ngeh ih kaankoong rumta. ");
INSERT INTO tvt_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Phestas ih ngaakbaat rumta, “Pool bah Kaisiria ni phaatak ni tongla, ngah enah kharok eh ngaak wangte. ");
INSERT INTO tvt_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Sen mihak phokhoh loong ah Kaisiria nah nga damdoh toom wakwang rumha mat eh jootjih thetre kota bah ah.” ");
INSERT INTO tvt_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Neng damdi Phestas ah sa asat tam sa asih waktong ano Kaisiria ni kata. Erah saalih adi Phestas ah mat hoontheng nok adi tong ano Pool siitwan baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pool ah thokkoh haano, Jerusalem nawa ra taha Jehudi loong ah kookchap rum ano heh thetkhat tiit ah rapne ih daanmui rumta, erabah uh heh ah tiim thila erah tadong noisok rumta. ");
INSERT INTO tvt_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Eno Pool heteewah pangjeng jengta: “Jehudi Hootthe, Rangteenok nyia Luuwanglong ngathong ni ngah tathetre kang.” ");
INSERT INTO tvt_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Enoothong Jehudi loong ih toom se chohang li ano, Phestas ih Pool suh chengta, “Arah tiit ah Jerusalem nah nga pandoh hoonkaat suh tam nook uh?” ");
INSERT INTO tvt_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pool ih liita, “Luuwanglong mat hoon theng noklong ni chaplang, nga mat hoon jilam ang abah uh arah doh hoon theng. An teewah ih jat ih halang, ngah Jehudi loong raangtaan ih tiim uh tathet reekang. ");
INSERT INTO tvt_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nga mik laan mah roh hootthe thet hoom kohang bah adoleh thetre kolang bah, ngah ah puipang he ngeh ih tabaat rumra. Enoothong mat ih deejoh rum halang ah ami lah angka bah, o ih uh Jehudi loong lak nah nak haat he. Ngah ih Luuwanglong ngathong ni chuut hu lang.” ");
INSERT INTO tvt_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Heh suh hukbatte loong damdi roongwaan ano, Phestas ih ngaak baatta, “An ih Luuwanglong lasih johu, heh jiinnah kah uh.” ");
INSERT INTO tvt_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Rekam saapoot lidi Agrippa Luuwang nyia Bernis Kaisiria hah ni Phestas lamchoh kanyuuta. ");
INSERT INTO tvt_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Erah ni rekamdook tong kanyu ah lidi, Phestas ah Luuwang damdi Pool tiit roong waanta: “Pheliks ih phaatak ni sakthiin arah ani mih wasiit je ah; ");
INSERT INTO tvt_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","eno ngah Jerusalem ni katang adi, Jehudi romwah phokhoh nyia hadaang phokhoh loong ih dut haat etheng ngeh ih tiit thok hoon rum taha. ");
INSERT INTO tvt_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Eno ngah ih baat rumtang seng Room nok hah bah matwah ah hechang hebente damdoh heteewah maangchoh waanwaan nyia heh teewah suh heh puipang jengkhaap lajeng thuk tami dut haatke. ");
INSERT INTO tvt_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Neng loong ah ani ra haano, ngah tasentong tang; erah saalih adi tiit hoon nok ni tong angno erah mih toonsiit kaat thuk rumtang. ");
INSERT INTO tvt_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Heh jeng phaakiite loong toonchap ano, heh thetkhat tiit tiim uh tajeng rumta, ngah ih thuntang heh thetre tiit jeng eh rum ah ngeh ah. ");
INSERT INTO tvt_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Neng loong ah nengrom nengrang tiit nyia jen tekchoi Jisu tiit ba daanmui rumta; enoothong Pool ih ething ngeh ih baat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Arah tiit ah mamah lam eh huk thoithaak ang ngeh ih ngah tiim uh tami thun tang, erah raangtaan ih tiit ah Jerusalem nah hoonkaat suh maanook ju oh ngeh ih Pool suh chengtang. ");
INSERT INTO tvt_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Enoothong Pool chuut huuta; nga bante suh rapniine eh riikoi sokboi thuk heeno mat tiit ah Luuwanglong ih toom paat ah. Erah raangtaan eh Luuwanglong reeni maang wang thukthuk sipaahi loong asuh riikoi sokboi thuk rumtang.” ");
INSERT INTO tvt_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa ih Phestas suh liita, “Arah mih jeng ah nga teeteewah ih chaat suh liihang.” Eno Phestas ih baatta, “Rangkhah an ih chochaat eh uh.” ");
INSERT INTO tvt_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Erah saalih adi Agrippa nyia Bernis ih arami saahaap elongthoon nyia samnuthung dowa mihak phokhoh loong ah siitnyu ano nok atang thuttheeta nok adi wangrum taha. Phestas ih baat kano, Pool ah nopsiit wanrum taha. ");
INSERT INTO tvt_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Phestas ih liita, “Agrippa Luuwang nyia adi khoon thokte noksong paangmeh loong: Arah mih ah sok thaak an, heh tiit ah ani waate nyia Jerusalem ni songtongte, Jehudi loongtang ih ngasuh chuiwan rum taha rah ah. Eno neng loong ah riiraak rumta ething lakah boot tongthuk theng. ");
INSERT INTO tvt_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Enoothong hemik laan mah roh eh thetre arah bah ngah ih tiim uh tachoh jokang. Adoleh heh Luuwanglong ngathong ni heteteewah chuut hu phiino, ngah ih Luuwanglong reenah kaatthukte anglang. ");
INSERT INTO tvt_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Enoothong Luuwanglong suh tiim raangmaat theng ah tiim uh amuh. Erah raangtaan ih sen ngathong ni Pool thoksiit halang—Agrippa Luuwang, an ngathong ni ah—timnge liidi, heh thetre thaakcheng eno, tiim bah uh mi raangmaat eh suh ah. ");
INSERT INTO tvt_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ngah ih thunhang ah langla phaatak ni tiim thoilam di tongla erah lajat thang eh Luuwanglong reeni kaat thuk ah nga thung ni tapunka.” ");
INSERT INTO tvt_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa ih Pool suh liita, “An teeteewah tiit jen baat eh uh.” Pool heh lak ah janghaat ano heteewah tiit ah amah baatta: ");
INSERT INTO tvt_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Agrippa Luuwang! Nga teeteewah suh khangraangse liihang chiinnyah ngah an ngathong ni chap angno Jehudi loong ih mat eh deejoh halang tiit ah baat hang, ");
INSERT INTO tvt_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Jehudi rom arang nyia rookmui jengmui ah an ih rapniine ih jat hu, erah thoidi, nga jeng ah naririh eh boichaat weeuh. ");
INSERT INTO tvt_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Jehudi mina loongtang ih jat eha jaaro dowa eh ngah mamah eh songtong lang. Nga roidong tang mamah eh songlang neng ih jat eha, nga hah ni mamah songtang, erah lidi Jerusalem ni mamah eh songlang. ");
INSERT INTO tvt_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ngah ih liihang ah langla, nga tiit ah neng ih ejen baat eh ah, neng ih jirep ah ejat, jaakhoh ni ngah Pharisi rom arang ah kap angno songtong tang. ");
INSERT INTO tvt_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Eno ngah adi chaplang abah sengte sengwah suh Rangte ih kakhamta suh laalom thoidi— ");
INSERT INTO tvt_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","seng mina asih jaatnyi ih erah chosuh laalomla, erah raangtaan ih rangwu rangphe Rangte rangsoom rumha. Luuwang, erah suh laalom thoidi ba, Jehudi loong ih mat eh joh rum halang! ");
INSERT INTO tvt_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Arah di tongte sen loong ah ih tek nawa Rangte ih ngaaksaat thukta tiit hanpi ah mamah eh chaan chohan? ");
INSERT INTO tvt_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Nga teewah ih uh Najaret dowa Jisu tiit ah emah ju eh daan tang. ");
INSERT INTO tvt_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Jerusalem ni ngah emamah eh reeraang tang. Rangte mina loong ah phaatak ni jootsak suh nyia tek haat esuh Romwah phokhoh loong jiin nawa chaan aphaan ah thaang etang; eno neng loong ah tek haat etheng ngeh ih liirum abah ngah ih uh emah ju roong jengtang. ");
INSERT INTO tvt_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Neng phaangphak suh nyia Jisu laalom toihaat thuk suh li leh Jehudi rangsoomnok noongrep ni hedop hedop siiwi rumtang. Rangte miloong asuh rathan eh kakhadah tang mideek mikaan ni nep kaleh kasiiwi rumtang. ");
INSERT INTO tvt_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Romwah phokhoh jiin nawa chaan aphaan ah thaang angno Damaskas ni taat katang aju erah raangtaan ih kaat dowa. ");
INSERT INTO tvt_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Eno Luuwang, rangnithung di, seng loong ah lam ni khoom ih di, rangsa nang eju ephaak weephaak arah tuptang, rang nawa phaak ra haano nga damdi kaatte miloong ah nep eh kaangtookta. ");
INSERT INTO tvt_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Seng loong ah hah ni loongdatti, eno Hebru jenglam eh ngasuh liihang rah miroot japchaat tang, ‘Sool, Sool! An ih ngah tiim esuh siiwi halang? An teeteewah ih an tamkong ni buhu, maan ih heh changte wah chaanthah pitnak ah likhiik eh ah,’ ");
INSERT INTO tvt_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","‘Teesu an o ang weelu?’ Ngah ih emah ih cheng tang. Eno Teesu ih emah ngaakli tahang, ‘Ngah Jisu, an ih siiwi halang rah ah. ");
INSERT INTO tvt_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","An lah nah toonchap uh. Nga jeng chaatte toom ang ah ngeh ih an poon suh dong halang. Chiinnyah an ih ngah mamah eh tup halang adoleh liwang nah tiim jaat noisok ha erah tiit ah mih suh tumbaat theng. ");
INSERT INTO tvt_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","An mina Ijirel noksong nyia Ranglajatte lak nawa ngah ih pangha. An ih neng mik ah ");
INSERT INTO tvt_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","singsiit uno rangnak nawa rangwu nah doksiit theng adoleh Soitaan reenawa Rangte reenah thoksiit theng, timnge liidoh neng ngasuh tuumaang jun eh neng rangdah ah saasiit suh nyia Rangte ih jeeta mina loong damdoh choh tong suh ah.’ ");
INSERT INTO tvt_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Erah raangtaan ih, Agrippa Luuwang, rang nawa tuptang motmang ah ngah ih tadaan tang. ");
INSERT INTO tvt_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Jaakhoh thoon ah Jerusalem nyia Damaskas hah ni erah lidi Ranglajatte mina loong suh Judia hah noongrep ni Rangte tiit ah tumbaat tang, neng rangdah sekthun ano Rangte reenah thok suh ah erah damdi sekthun ih hi ngeh ih noisok suh baat rumtang. ");
INSERT INTO tvt_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Erah thoidi ba, rangsoomnok ni ang angdi Jehudi loong ah ih jorum hangno tek haat taatchung rum tahang. ");
INSERT INTO tvt_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Enoothong amadi tuk ih Rangte ih chosok roh eh halang, erah raangtaan ih mihak noodek thoontang ngathong ni adi Rangte eje ngeh ih baat suh toonchap lang. Khowah nyia Moses ih mamah re theng banbaatta ngah ih uh phoosiitsiit tiit ah baat hang: ");
INSERT INTO tvt_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Erah langla Kristo ah chamnaang jaatjaat etheng, eno Jehudi nyia Ranglajatte loong ah ih khopiiroidong chosuh heh tek nawa phang ngaaksaat ah.” ");
INSERT INTO tvt_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pool ih heteewah tiit emah taatbaat adi, Phestas ah Pool taangko sok ano erongwah ih riita, “Emok anglu hanih, Pool! Ehanmi eh nyootsoot kuh ih mokpaang lu!” ");
INSERT INTO tvt_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pool ngaak jengta, “Emok tah angkang, an ba elong! Ngah amiisak tiit ah baat hang. ");
INSERT INTO tvt_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Agrippa Luuwang! Ngah an damdoh lacho laphaan jen roongwaan ehang, timnge liidi an ih jirep ah jat eho. Ngah ih an suh kamkam ih tuumaang hala, arah miloong ah ih tiimjih hoonha erah jat eh hu ngeh ah, timnge liidi arah tiit ah hesuk henoong ni tahoonka. ");
INSERT INTO tvt_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Agrippa Luuwang, Khowah ah hanpi nih ehu? Ngah ih jat ehang an ih hanpi ehu.” ");
INSERT INTO tvt_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa ih Pool suh liita, “An ih ngah amah ih Kristaan eh hoon thuk ang nih mok samthun hu?” ");
INSERT INTO tvt_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pool ngaakjengta, “Dot doh angkoja oh adoleh rekam lidoh angkoja oh “Ngah ih Rangte rangsoom hang ah an luulu lah angthang eh o ih nga jeng boichaat ha erah loong ah nep nga likhiik eh hoon theng chiinnyah jaanruh ih khak halang thoidoh ah.” ");
INSERT INTO tvt_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Eno Luuwang, kobono, Barnis nyia wahoh loong ah toonchapta, ");
INSERT INTO tvt_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","doksoon karum ano roongwaan karumta, “Arah mih ah phaatak nah saktheng nyia heh tekjih bah tiim uh tathet reeka.” ");
INSERT INTO tvt_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Eno Agrippa ih Phestas suh liita, “Luuwanglong lasih lajota bah arah mih ah jen doksoon eh thengta.” ");
INSERT INTO tvt_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Itali ni daansoon kaat suh roongwaan kino, Pool nyia wahoh phaatak ni sakte loong ah mararah ah Room nok hah nawa arami saahaap Julius suh koh rumta, erah arami suh “Luuwanglong Regimeen ngeh ih men rumta.” ");
INSERT INTO tvt_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Adramittiam dowa juukaari adi du kati, erah langla Esia hah dowa juukaari khoon chaptheng ko kaatte angta eno erah di daansoon kati. Mesidonia mih wasiit, Aristarkas ah Thesalonika nawa angta, heh uh seng damdi angta. ");
INSERT INTO tvt_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Erah saalih adi Sidoon ni thokti. Julias ih Pool ah minchan eta, eno heh joon loong ah jiinni toom chosok rum ah ngeh ih wang thukta. ");
INSERT INTO tvt_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Pong ih rapne eh mot heeno erah dowa Kaipras juuloot hah adi daansoon kati. ");
INSERT INTO tvt_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Silisia nyia Pamphilia juusih ah daan eno Maira hah Lisia ko angta adi wang tahe. ");
INSERT INTO tvt_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Erah di Elekjendar nawa juukaari ah Itali ni wangte angta, eno saahaap ah ih erah japtup ano duutong kaat thuk tahe. ");
INSERT INTO tvt_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Seng loong reere ih daansoon eno sa hantek di Nindus samhah ah kanak eh thokti. Pong thoidi erah ko takah jen kati, erah raangtaan ih Salmone lam eh Kret juuloot hah adi daansoonti. ");
INSERT INTO tvt_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Juukaang juukaang eh daan kah eno Sep Habor ngeh ih men rumta juukaari naangchap theng adi kanak rangthuk ih thok wangti. Erah Lasisa samhah dowa eh haloh tah angta. ");
INSERT INTO tvt_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Erah di seng rekam tong eno, ju ni daan ah choophaan phaan eh angta, seng loong Khojoop Rangwu ah liin eta. Erah raangtaan ih Pool ih juukaari dowa saahaap loong asuh renbaat rumta: ");
INSERT INTO tvt_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Mina loong, arah dowa ju nah daan bah cho ejih tup hang huikhaak thiintheng ah khoodaat eh ah eno seng roidong uh thoon eh ah.” ");
INSERT INTO tvt_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Enoothong arami saahaap ah ih Pool jeng ah lalek boichaat thang ih; juukaari jopte nyia juukaari changte jeng ah boichaatta. ");
INSERT INTO tvt_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Juukaari chaptheng ah hahook di taseeta; erah raangtaan ih miloong ah ehanko ah juusih dowa Phoeniks ni daansoon chung rumta, lek jen daan rum ah baleh, hahook doh Phoeniks nah tong suh ah. Phoeniks ah langla juukaari lomchap theng Kret ni angta Juukuh Juumeh eh angta. ");
INSERT INTO tvt_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Juumeh ko nawa pong ah amasah phang pong kano, miloong ah ih thunta neng jen dokkhoom ekah ah ngeh ah, erah thoidi hetang bentheng jaankeng ah jaahoom rum ano Kret ko juukaang juukaang ih daansoon rumta. ");
INSERT INTO tvt_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Enoothong dokchap damdam eh pong ah rapne eh pongta, erah pong asuh “Juukuh saadong pong” ngeh ih li rumta, eno erah pong ah juuloot hah dowa eh datpong taha. ");
INSERT INTO tvt_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Juukaari ah pong ih tangmotta, seng ih uh takah jook motsiitti, pong nawa ih heh soonsoon lan eh thukti. ");
INSERT INTO tvt_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Juuloot adi hah ehinsah Kuada ngeh ih angta eno juulah ko kah idi, juukaari chap theng kok jeeta. Erah di, juukaari ah tangchap thuk suh rapne eh chamti. ");
INSERT INTO tvt_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Juukaari ah tanghoom rum ano ru nawa ih kook tangkit rumta. Neng loong ah phisaang ni duusoon raacho eh Libia juukaang ko pong suh hesoon soon eh hengmot kaatthuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Pong aphaat ah choophaan phaan ih pongroh eh kano, erah saalih adi huikhaak rukho ah juukaari dowa lamdat haat eh rumta, ");
INSERT INTO tvt_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","eno erah saalih adi juukaari ni maak theng jaan loong ah daat haat eh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Sa hantek rangsa nyia ritsih uh tajap tupti, pong ah thidokdok ih pongroh eta. Seng uh epui eli ngeh ih takah laalomti. ");
INSERT INTO tvt_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Miloong ah sa hantek samuh tong rumkano, Pool neng ngathong ni toonchap ano jengta, “Mina loong, nga jeng ah thaangchaat anno Kret nawa ladokchap dobah ese ang thengta; eno seng athan tachamnaang thengti nyia huikhaak uh taathet haat thengti. ");
INSERT INTO tvt_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Bolam uh sen lasih jorum hala, nakcho an! Seng khoh sengseng abah tamake juukaari ah ba ethet eh ah. ");
INSERT INTO tvt_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ngah ih soomhang Rangte Kamwah muphe ra haano, ");
INSERT INTO tvt_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","baat tahang, ‘Nakcho uh, Pool! An Luuwanglong ngathong nah chap jaatjaat etheng. Eno Rangte minchan doh an damdoh soonte loong ah uh epui eh ah.’ ");
INSERT INTO tvt_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Miwah loong, erah raangtaan ih nakcho an! Nga Rangte erah baat tahang asuh laalom lang jun ih ju ang ah. ");
INSERT INTO tvt_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Enoothong juuloot ehoko maako bah uh soonmot ekaat he.” ");
INSERT INTO tvt_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Asih saabaji sa rangphe di, Mediteeren juusih ko eh soonmot kaat tahe. Rangphe thungkham di jopte loong ah ih hah thoksoon eli samthun rumta. ");
INSERT INTO tvt_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Erah raangtaan ih ruh tuiba ni tiim ah tiim ejih jaat benrum ano juumong ni thaak daat haat rumta eno rookbaji teekho choong angta; erah lih adi weethaak rum ano teekho rookjom angta. ");
INSERT INTO tvt_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Jongkhoh nah maalek duusoon ji o ngeh eh cho rumta, erah raangtaan ih juukaari liko dowa tangtuk theng jaankeng baji ah daat hoom rum ano rangwu raangtaan ih rangsoom rumta. ");
INSERT INTO tvt_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Enoothong jopte loong ah hotsoon esuh taatchung rumta; khoonkhu saloong ah datthiin rum ano heh ngako ni tangtuk theng jaankeng ih tangbat arah likhiik diip reeraang rumta. ");
INSERT INTO tvt_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Enoothong Pool ih Arami Saahaap nyia heh sipaahi loong asuh baatta, “Juukaari khonah jopte lajeeka bah epui eh ang ngeh ih laalomjih tah angka.” ");
INSERT INTO tvt_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Erah thoidi arami loong ah ih tangtuk eta ruh loong ah jaakhan rum ano heh soonsoon eh thuk rumta. ");
INSERT INTO tvt_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Rangkhano angnanah di, Pool ih tiim ah tiim jam phaksat baat rumta: “Chiinnyah dowa ih sen loong ah asih sa baji angla, eno amadi uh tiim uh taphaksah kan. ");
INSERT INTO tvt_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Erah raangtaan ih, sen lasih jorum hala, tiim ah tiim jam phaksah an; elun esuh phak asat jam phaksat etheng. Sen khoroon tasiit taan uh tamah kan ang ah.” ");
INSERT INTO tvt_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Erah jeng lidi, Pool ih baanlo ah toonpi ano, Rangte suh lakookmi li ano, chep hoom phakta. ");
INSERT INTO tvt_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Erah dowa ih ba neng chaan kok dongta, eno loongtang ih jam phaksah rumta. ");
INSERT INTO tvt_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Seng loong ah roop roop ih 276 mina tongti. ");
INSERT INTO tvt_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Neng loong ah ih phoot phaksah rum ano, huichaang suh juukaari dowa wong ah ju ni lamset haat rumta. ");
INSERT INTO tvt_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Rang ah wu ano, jopte loong ah ih hah ah maako ah tasamjat rumta, enoothong juusih kaang ah japtup rumta, neng ih thunta ese ang abah; juukaari ah phisaang khonah tangchap theng. ");
INSERT INTO tvt_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Erah thoidi tangtuk theng jaankeng loong ah thakhan rum ano juusih ko lupdat kaat thuk rumta, erah damdam ih tangkit eh rumta ruh loong ah jaahaat. Eno pong asuh hengmot kaat thuk suh hengah ko lengmot etheng nyuh ah tangtin eh rumta, eno hekaang ko eh kati. ");
INSERT INTO tvt_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Enoothong juukaari ah ih phisaang ah choksuh ano saanghook ni du soonta; hengah ko thut ano takah mi moseeta, helih ko ah juutak ih jopmotta. ");
INSERT INTO tvt_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Arami loong ah ih phaatak ni sakta miloong ah, juukaang ko daanjaap rum ano phomoong soon rum ah ngeh ih tek haat esuh chung rumta. ");
INSERT INTO tvt_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Enoothong arami saahaap ah ih Pool puipang suh li ano, tatek haat thuk rumta. Erah nang ebah, o o ah juujap miiha juukaang ko datpit rum ano daanjap baat rumta; ");
INSERT INTO tvt_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","wahoh loong asuh neng lilih ih, banglo nyia juukaari jopdaatta chep loong adoh joh ano daanjaap baat rumta. Eno seng loong ah juukaang ko emah daansoon eno kok puiti. ");
INSERT INTO tvt_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ju saangko ese tham ih jen daan eno, juuloot hah men ah Malta ngeh ih japchaat kati. ");
INSERT INTO tvt_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Erah hah dowa miloong ah seng damdi rapne ese angrum taha. Rangphaat kano songtitih angta, erah thoidi juukaang ni we ah takrum ano bansok tahe. ");
INSERT INTO tvt_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pool ih chanthah kaang loong ah chatjoh takta eno we ih satraat kano puusah esiit doksuuk haano heh lakni dekta. ");
INSERT INTO tvt_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Erah hah dowa miloong ah ih Pool lakni pu ih dekta ah japtup rum ano baatmui rumta, “Arah mih abah mih tek haatte jaatjaat angta ju nawa taatpui abah uh, heh khangraang thih—talunka ang ah.” ");
INSERT INTO tvt_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Enoothong Pool ih puusah ah we ni betsak haatta heh tiim uh tah angta. ");
INSERT INTO tvt_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Miloong ah ih pheng tam taphengka adoleh dot ma eh loongti jaao ngeh ih bansok rumta. Eno rekam bansok rum adi tiim uh lah angkoka no, miloong ah ih samthun rumta, “Arah mih abah Rangte bo ah!” ");
INSERT INTO tvt_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Erah juuloot hah dowa saahaap elongthoon wasiit Publias ngeh ih angta, erah hah dowa eh Publias phek ah haloot ni tah angta. Eno Publias ih seng loong ah ese tham ih bantho heeno heh nok ni sa jom heh wenwah eh tongthuk tahe. ");
INSERT INTO tvt_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publias wah ah mongrun nyia sokngoi ih sat ano heh juptheng ni juproh eta. Erah thoidi Pool nopma ni nopwang ano, heh lak ih taajoh ano, deesoom wangta. ");
INSERT INTO tvt_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Deesoom kano, erah juuloot hah dowa wahoh khoisatte loong ah uh wang eh rum taha eno Pool ih de soomkot eh rumta. ");
INSERT INTO tvt_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Seng loong asuh jirep ah kokang tahe, erah hah dowa daansoon kati adoh, lam nah phaksat suh rookphong ah koh ih tahe. ");
INSERT INTO tvt_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","La jom lidi Elekjendar nawa juukaari “Khaangpeh Rangte” ngeh ih men rumta juukaari adi daansoon kati, erah juukaari ah hahook hooktang erah juuloot hah adi chap roh eta. ");
INSERT INTO