﻿USE sofia;
DROP TABLE IF EXISTS sofia.tvn_vpl;
CREATE TABLE tvn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tvn_vpl WRITE;
INSERT INTO tvn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","အာဗြဟံန ဒါဝိဒ်လေဟှနေဘီးဟှာ မွီးဖွားဆင်းသတ်လာဟှူ ယေရှုခရစ်တော်ရဲ့ ဆွေဇင်မျိုးဆစ်စာရင်းမာ အယ်မျိုးဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","အာဗြဟံဟှာ ဣဇာက်ရဲ့ဖ ဖြစ်ဟှယ်။ ဣဇာက်ဟှာ ယာကုပ်ရဲ့ဖ၊ ယာကုပ်ဟှာ ယုဒန သူ့ညီကိုလေရဲ့ဖ၊ ");
INSERT INTO tvn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ယုဒဟှာ တာမာနရဟှူ သားလေဖြစ်ဟှူ ဖာရက်န ဇာရရဲ့ဖ၊ ဖာရက်ဟှာ ဟေဇရုံရဲ့ဖ၊ ဟေဇရုံဟှာ အာရံရဲ့ဖ၊ ");
INSERT INTO tvn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","အာရံဟှာ အမိနဒပ်ရဲ့ဖ၊ အမိနဒပ်ဟှာ နာရှုန်ရဲ့ဖ၊ နာရှုန်ဟှာ စာလမုန်ရဲ့ဖ၊ ");
INSERT INTO tvn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","စာလမုန်ဟှာ ရာခပ်နရဟှူ ဗောဇရဲ့ဖ၊ ဗောဇဟှာ ရုသနရဟှူ သြဗက်ရဲ့ဖ၊ ဩဗက်ဟှာ ယေရှဲရဲ့ဖ၊ ");
INSERT INTO tvn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ယေရှဲဟှာ ဒါဝိဒ်မန်းဂီးရဲ့ဖ။ ဒါဝိဒ်မန်းဂီးဟှာ ဥရိယရဲ့မယားဖြစ်ဖူးဟှူ မီးမနရဟှူသား ရှောလမုန်ရဲ့ဖ ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ရှောလမုန်ဟှာ ရောဗောင်ရဲ့ဖ၊ ရောဗောင်ဟှာ အဘိယရဲ့ဖ၊ အဘိယဟှာ အာသရဲ့ဖ၊ ");
INSERT INTO tvn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","အာသဟှာ ယောရှဖက်ရဲ့ဖ၊ ယောရှဖက်ဟှာ ယဟောရံရဲ့ဖ၊ ယဟောရံဟှာ ဩဇိရဲ့ဖ၊ ");
INSERT INTO tvn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ဩဇိဟှာ ယောသံရဲ့ဖ၊ ယောသံဟှာ အာခတ်ရဲ့ဖ၊ အာခတ်ဟှာ ဟေဇကိရဲ့ဖ၊ ");
INSERT INTO tvn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ဟေဇကိဟှာ မနာရှေရဲ့ဖ၊ မနာရှေဟှာ အာမုန်ရဲ့ဖ၊ အာမုန်ဟှာ ယောရှိရဲ့ဖ၊ ");
INSERT INTO tvn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ဗာဗုလုန်ဗြို့ဟှို ဣသရေလလူမျိုးလေ ဖမ်းဆောန်ခံရဟှူ ခီမာ ယောရှိရဲ့သားလေဟှ ယေခေါနိန ညီကိုလေဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ဗာဗုလုန်ဗြို့ဟှို ဣသရေလလူမျိုးလေ ဖမ်းဆောန်ခံရဘီးန၊ ယေခေါနိဟှာ ရှာလသေလရဲ့ဖ ဖြစ်ဟှယ်။ ရှာလသေလဟှာ ဇေရုဗဗေလရဲ့ဖ၊ ");
INSERT INTO tvn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ဇေရုဗဗေလဟှာ အာဗျုန်ရဲ့ဖ၊ အာဗျုန်ဟှာ ဧလျာကိမ်ရဲ့ဖ၊ ဧလျာကိမ်ဟှာ အာဇော်ရဲ့ဖ၊ ");
INSERT INTO tvn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","အာဇော်ဟှာ ဇာဒုတ်ရဲ့ဖ၊ ဇာဒုတ်ဟှာ အာခိမ်ရဲ့ဖ၊ အာခိမ်ဟှာ ဧလုဒ်ရဲ့ဖ၊ ");
INSERT INTO tvn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ဧလုဒ်ဟှာ ဧလာဇာရဲ့ဖ၊ ဧလာဇာဟှာ မဿန်ရဲ့ဖ၊ မဿန်ဟှာ ယာကုပ်ရဲ့ဖ၊ ");
INSERT INTO tvn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ယာကုပ်ရဲ့သားဟှာ မာရိရဲ့လန် ယောသပ် ဖြစ်လေဟှယ်။ အယ်မူမာရိဟှာ ခရစ်တော် ဆိုဘီး နာမယ်ရှိဟှူ ယေရှုရဲ့မိ ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","အယ်မျိုး မျိုးဆစ်ပေါန်းဟှာ အာဗြဟံဟှနေဘီး ဒါဝိဒ်ထိ ဆယ့်လေးဆစ်၊ ဒါဝိဒ်ဟှနေဘီး ဗာဗုလုန်ဗြို့ဟှို နယ်နှင်ဒန် ခံရခန်ခီထိ ဆယ့်လေးဆစ်၊ ဗာဗုလုန်ဗြို့ဟှို နယ်နှင်ဒန် ခံရဘီးန ခရစ်တော် မွီးလာဟှူ ခီထိ ဆယ့်လေးဆစ် ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ယေရှုခရစ်တော် မွီးဖွားလာဟှူ ကြောန်းရာဟှ အယ်မျိုးဖြစ်ဟှယ်။ မိခင်မာရိဟှာ ယောသပ်န မင်္ဂလာဆောန်ဟှို့တွပ် စေ့စပ်ဘီး တူးဒူနေခန်မာ သန့်ရှင်းဟှူဝိညာဉ်တော်အားဖြင့် ဗိုက်ပိုက်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","သူ့လန် ယောသပ်ဟှာ ဖြောန့်မတ်ဟှူသူ ဖြစ်ဟှူကြောန့် မာရိဟှို လူဘောင်လယ်မာ ယှစ်ရဘဲနေအောန် တိတိဟှား ကွာရှင်းမယ် ဆိုဘီး ကြံစည်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","အယ်မျိုး ကြံစည်နေခီမာ အိမတ်ထဲမာ ယောသပ်ဟှို ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်ဟှ “ဒါဝိဒ်အမျိုး ယောသပ်၊ နန့်မယား မာရိရဲ့ ဗိုက်တွပ် စိုးရိမ်န။ အယ်ဗိုက်ဟှာ ဘုရားသခင်ရဲ့ သန့်ရှင်းဟှူဝိညာဉ်တော်ရဲ့ တဂိုးအားဖြင့် ရလာဟှူဗိုက်ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","သူဟှာ သားယော့‑က်ကျားဟှို မွီးလေ့မယ်။ အယ်မူသားဟှာ သူ့ရဲ့လူလေဟှို ပြစ်ဟှနေဘီး ကယ်တန်ပေးမယ့်သူ ဖြစ်ဟှယ်။ အယ်ကြောန့် ယေရှု ဆိုဘီး နာမယ်ပေးရမယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","အယ်ကြောန်းရာဟှ ရှေးပရောဖက်လေအားဖြင့် ပြောဟှားဟှူ ဘုရားသခင်ရဲ့ ဗျာဒိတ်တော် ပ္လဲ့ဇောင်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ဗျာဒိတ်ပြုဟှားဇာဟှ “ကေ့ရှုဂေ့။ ပျိုမဟှာ ဗိုက်ပိုက်ဘီး သားဟှို မွီးဖွားလေ့မယ်။ အယ်သားဟှို ဧမာနွေလ ဆိုဘီး နာမယ်ပေးရမယ်” (ဧမာနွေလရဲ့ နတ်ဓိပါယ်ဟှာ “နို့လေနတူးဒူရှိဟှူ ဘုရားသခင်” ဆိုဘီး ဓိပါယ်ရလေဟှယ်)။ ");
INSERT INTO tvn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ယောသပ်ဟှာ အိယာဟှ နိုးလာဘီးန ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်ပြောဟှားတိုင်း မာရိဟှို သူ့မီးမဖြစ် လတ်ထတ် ပေါန်းသင်းလိုက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","အယ်ကြောန့် အယ်သားဟှို မွီးဖွားခီရော့‑က်ခန်ထိ တူးဒူအိဘဲန နေလေဟှယ်။ အယ်သားဟှိုလည်း ယေရှု ဆိုဘီး နာမယ်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ယုဒပြည်ဗက်လင်ဗြို့ ဟေရုဒ်မန်းဂီး လတ်ထတ်မာ ယေရှုဟှို မွီးဖွားတော်မူဟှယ်။ မာဂုပညာရှိလေဟှာ ရှေ့တိုင်းပြည်ဟှနေ ယေရုရှလင်ဗြို့ဟှို ရော့‑က်လာဘီးဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ခုမွီးဖွားလာဟှူ ယုဒမန်းဂီးဟှာ ဖယ်မာရှိနူး။ ရှေ့တိုင်းပြည်ဟှနေဘီး သူ့ရဲ့ ကြယ်ဟှို နို့လေ ဗြင်ရဂေ့ဟှူကြောန့် ရှိခိုးပူဇော်ဟှို့တွပ် ရော့‑က်လာဂေ့ဟှယ်” ဆိုဘီး မေးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","အယ်မူစကားဟှို ကြားလိုက်ဟှူ ခီမာ ဟေရုဒ်မန်းဂီးန ယေရုရှလင်ဗြို့ဟှ လူလေ ဂူလောင်းဟှာ ပူပန်သောက ရော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ယဇ်ပုရောဟိတ်ဂီးလေ၊ ဘာသာရေး ခေါန်းဆောန်လေန ကျမ်းပြုဆရာရှိမျှဟှို စုဝေးခေါ်ဘီးဟှာ “ခရစ်တော်ဟှာ ဖယ်ရပ်မာ မွီးဖွားလာမယ်နူး” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ကျမ်းပြုဆရာလေဟှလည်း “ယုဒပြည်ဗက်လင်ဗြို့မာ မွီးဖွားပါလေ့မယ်။ ပရောဖက်တပါး ရေးဟှားဇာဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘ယုဒပြည် ဗက်လင်ဗြို့၊ စိုးရဟှူ ယုဒဗြို့လေထဲမာ နန်ဟှာ ဗြို့ငယ်မှုဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါ့ရဲ့ဣသရေလလူမျိုးဟှို အောက်စိုးဟှို့သခင်ဟှာ နန်းနို့ထဲမာ ပေါ်ထွပ်လေ့မယ်’ ” ဆိုဘီး ပ္လန်ဖြေဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","အယ်ဘီးန ဟေရုဒ်မန်းဂီးဟှာ မာဂုပညာရှိလေဟှို တိတိဟှားခေါ်ဘီးဟှာ ကြယ်ပေါ်ထွပ်ဟှူ ခီကာလဟှို သေးသေချားချာဟှား သိဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","“နန်းနို့လေသွားဘီးဟှာ အယ်သားဂန်းဟှို သေးသေချားချာရှာဂေ့။ တွိဟှယ် ဆိုဟှာ ငါလည်း ရှိခိုးပူဇော်ရှင်ကြောန့် ပ္လန်လာဘီး ပြောဂေ့ပါ” ဆိုဘီး ဗက်လင်ဗြို့ဟှို လွှတ်လိုက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","မာဂုပညာရှိလေလည်း မန်းဂီးရဲ့ စကားဟှို နားထောန်ဘီးဟှာ ထွပ်လာဂေ့ဘီးန ရှေ့ပြည်မာ ဗြင်ဟှားဟှူကြယ်ဟှာ သူးနို့ရှေ့မာသွားဘီးဟှာ သားဂန်းဟှားရှိဟှူ နေရာထတ်ဟှို ရော့‑က်ဟှားခီမာ ရွေ့ဘဲန ရပ်ဘီးနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","အယ်ကြယ်ဟှို ပ္လန်ဘီးဗြင်ရခီမာ မာဂုပညာရှိလေဟှာ ရရာတိုင်းဝန်းသာဂေ့ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","သူးနို့ဟှာ အီထဲဟှို ဝမ်ဟှားဇာ မိခင်မာရိနတူးဒူ သားဂန်းဟှားဟှို ဗြင်ဟှားခီမာ ပျပ်ဝပ်ကိုးကွယ်လေဟှယ်။ သူးနို့ဟှာ ယူဆောန်လာဟှူ ဘဏ္ဍာသစ်တာလေဟှို ဖွမ့်ဘီး လောဗန်၊ မုရန်န ရွှေလေဟှို ပူဇော်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","အယ်ဘီးန ဟေရုဒ်မန်းဂီးနားဟှို ပ္လန်ဂေ့န ဆိုဘီး ဘုရားသခင်ဟှာ အိမတ်အားဖြင့် ဒိပေးဟှူကြောန့် သူးနို့ပြည်ဟှို တခြားလမ်းဟှနေဘီး ပ္လန်ဟှားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","မာဂုပညာရှိလေ ပ္လန်ဘီးန ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်တပါးဟှို အိမတ်ထဲမာ ဗြင်တွိရဘီး ကောန်းဂန်တမန်ဟှ ယောသပ်ဟှို “နန်ထဝေါ့။ မိခင်န သားဂန်းဟှားဟှို ခေါ်ဘီးဟှာ အဲဂုတ္တုပြည်ဟှို ထွပ်ပ္လေးဘီး နော့‑က်ထပ် ငါပြောခန်ခီထိ အယ်မူပြည်မာဘဲ့ နေနေဂေ့။ ဟေရုဒ်မန်းဂီးဟှာ သားဂန်းဟှားဟှို သတ်ဟှို့ရှာလေ့မယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","အယ်ဘီးန ယောသပ်ဟှာ အိယာဟှထဘီး မိခင်န သားဂန်းဟှားဟှို ညဉ့်ရှင်းခေါ်ဘီး၊ အဲဂုတ္တုပြည်ဟှို ထွပ်ဟှားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ဟေရုဒ်မန်းဂီး သေဟှားခီထိ အယ်မူပြည်မာဘဲ့ နေနေလေဟှယ်။ အယ်ကြောန်းရာဟှာ “ငါ့သားဟှို အဲဂုတ္တုပြည်ဟှနေ ငါခေါ်ထုလာဘီ” ဆိုဘီးဟှာ ပရောဖက်လေအားဖြင့် ပြောဟှားဟှူ ဘုရားသခင်ရဲ့ ဗျာဒိတ်တော် ပ္လဲ့ဇောင်ဟှို့တွပ် ဖြစ်လာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","အယ်ခီမာ ဟေရုဒ်မန်းဂီးဟှာ မာဂုပညာရှိလေဟှို သူမှာလိုက်ဟှူတိုင်း ပ္လန်လာဘီးပြောဘဲန လှည့်ဇားဘီး သွားလိုက်ဇာဟှို သိရဟှူ ခီမာ ရရာတိုင်း ဒေါသထွပ်လေဟှယ်။ အယ်ဘီးန သူ့လူလေဟှို ခေါ်ဘီးဟှာ မာဂုပညာရှိလေဟှို သေးသေချားချာ မေးဟှားဟှူတိုင်း ကြယ်ပေါ်ထွပ်ခီဟှို ခန့်မှန်းဘီးဟှာ ဗက်လင်ဗြို့န ကျေးဝါလေမာရှိဟှူ နှေ့နှစ်အော့‑က် ယော့‑က်ကျား သားဂန်းဟှားလေဟှို သတ်ဟှို့ခိုင်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ပရောဖက်ယေရမိ ဟောဟှားဇာလေ ပ္လဲ့ဇောင်လာဇာဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ရာမဗြို့မာ ရာရာတိုင်း ခါးသီးဟှူ ငိုသံလေဟှိုကြားဘီး ရာခေလဟှာ သူ့သားလေ သေဟှားကြောန့်၊ စိပြေဟှို့တွပ် အားပေးစကားပြောဟှူဇာဟှို ငြင်းဆိုလေဟှယ်” ဆိုဘီး ပြောဟှားစကားဟှာ အယ်ခီမာ တကယ်ဘဲ့ ဖြစ်လာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ဟေရုဒ်မန်းဂီး သေဘီးန ယောသပ်ဟှာ အဲဂုတ္တုပြည်မာ အိမတ်ဟှို ထပ်ဘီးမတ်လေဟှယ်။ ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်ဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“နန်ထဘီး မိခင်န သားဂန်းဟှားဟှို ခေါ်ဘီးဟှာ ဣသရေလပြည်ဟှို သွားဂေ့။ သားဂန်းဟှားဟှို သတ်ဟှို့ရှာနေသူလေ သေကူဘီ” ဆိုဘီးဟှာ ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","အယ်ခီမာ ယောသပ်ဟှာ ထဘီး မိခင်န သားဂန်းဟှားဟှို ခေါ်ဘီး ဣသရေလပြည်ဟှို ပ္လန်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","အယ်ဘေမဲ့ ဟေရုဒ်မန်းဂီး နေရာမာ သူ့သားအာခေလဟှ ယုဒပြည်မာ မန်းဂီး ဖြစ်နေကြောန်းဟှို ကြားရဟှူ ခီမာ သူဟှာ အယ်နေရာဟှို သွားဟှို့ ကြော့‑က်နေဟှယ်။ သူဟှာ အီမတ်ထဲမာ အယ်နေရာဟှို သွားဘဲဟှို့တွပ် ကောန်းဂန်တမန်ရဲ့ ဒိပေးဇာဟှို ခံရကြောန့် သူဟှာ ဂါလိလဲပြည်ဟှို သွားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","နာဇရက်ဗြို့ ဆိုဘီး နာမယ်ခေါ်ဟှူ ဗြို့မာ ကိုယ်တော်ဟှာ မြဲဒမ်း နေထိုင်လေဟှယ်။ အယ်ကြောန့် “ခရစ်တော်ဟှို နာဇရက်ဗြို့သား ဆိုဘီး ခေါ်ဂေ့လေ့မယ်” ဆိုဘီးဟှာ ပရောဖက်လေ ရေးဟှားတိုင်း ပ္လဲ့ဇောင်လာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","အယ်ကာလမာ ဗတ္တိဇံယောဟန်ဟှာ ပေါ်လာဘီး ယုဒပြည် ကန္တာရမာ စဘီး ဟောပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“နောန်ဒရဂေ့ပါ။ ကောန်းဂန်နိုင်ငံတော်ဟှာ တည်ခါနီးနေဘီ!” ဆိုဘီး ကြေညာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ပရောဖက်ဟေရှာယ ဟောပြောဟှားဇာဟှ “ ‘ဘုရားသခင်ရဲ့ လမ်းဟှို ပြင်ဆင်ဟှားဂေ့! လမ်းခရီးတော်ဟှို ဖ္လောန့်တန်းအောန် လောက်ဂေ့ပါ’ တောကန္တာရထဲမာ လူတယော့‑က် ကြွေးကြော်နေဟှယ်” ဆိုဇာဟှာ အယ်မူယောဟန်ဟှို ပြောနေဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ယောဟန်ဟှာ ကုလားအုတ်ရဲ့ မွီးန လောက်ဟှားဟှူဝတ်န သားရေခါးဗတ်ဟှို ခါးမာပတ်ဟှားဘီး ကျိုင်းကောန်န တောပျားရယ်ဟှို စားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","အယ်ခီမာ ယေရုရှလင်ဗြို့၊ ယုဒပြည် တပြည်လောင်းန ယော်ဒန်မ္လစ်နားဟှ လူလေဟှာ ယောဟန်နားဟှို ရော့‑က်လာဂေ့ဘီး ");
INSERT INTO tvn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","သူးနို့ရဲ့ ပြစ်လေဟှို ဝန်ခံဂေ့ဟှိကြောန့် ယော်ဒန်မ္လစ်မာ ယောဟန်အားဖြင့် ဗတ္တိဇံခံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ဖာရိရှဲန ဇဒ္ဒုကဲလေလည်း ဗတ္တိဇံခံယူဟှို့ လာဂေ့ဇာဟှို ဗြင်ရခီမာ ယောဟန်ဟှ “ဝှေ့ မွီဗွေးမျိုးလေ၊ က္လရော့‑က်လာမယ့် ဘေးဒန်ဟှ လွတ်ဟှို့တွပ် နန်းနို့လေဟှို ဖယ်သူဟှ ဒိပေးလိုက်နူး။ ");
INSERT INTO tvn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","နောန်ဒန ထိုက်တန်ဟှူ ကျင့်ဟှို ကျင့်ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","အာဗြဟံဟှ နို့လေရဲ့ဖ ဖြစ်ဟှယ် ဆိုဘီး ပြောရောင်န နန်းနို့လေ ပြစ်ဒန်ဟှ လွှတ်လေ့မယ် ဆိုဘီး ထန်ဂေ့န။ နန်းနို့ဟှို ငါပြောမယ်။ ဘုရားသခင်ဟှာ အယ်က္လော့‑က်ခဲလေဟှနေဘီး အာဗြဟံရဲ့ မ္လေးမ္လစ်လေဟှို ဖန်ဆင်းနိုင်ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","သစ်ပန်လေရဲ့ ပြစ်လေနားမာ ကတ်ပထားဟှားကြောန့် သီးကောန်းဟှို သီးဘဲဟှူ သစ်ပန်တိုင်းဟှို ခွတ်ပစ်ဘီးဟှာ မီးထဲဟှို ပစ်ခ္လလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","နန်းနို့လေ နောန်ဒရဟှူကြောန့် ငါဟှာ ရေန ဗတ္တိဇံပေးဟှယ်။ ငါ့နော့‑က်ဟှ ကြွလာဟှူသူဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န မီးန နန်းနို့လေဟှို ဗတ္တိဇံပေးလေ့မယ်။ အယ်သူဟှာ ငါ့ထတ် ပိုဘီး ကီးမြတ်လေဟှယ်။ ငါဟှာ သူ့ရဲ့ ခေနပ်ကြိုးဟှို ခလွတ်ပေးဟှို့ဟှိုမှထိုက်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","လတ်ထဲမာ ဗားပ္လာဟှို့တွပ် ဂေါဟှိုကိုင်ဘီး သူ့ဗားလန်းပ္လန်ဟှို ရှင်းလေ့မယ်။ ဂျောင်န ဗားလေဟှိုလည်း ဗားဂတ်ထဲဟှို ထဲ့ဘီးဟှာ ဗားဖျင်းလေဟှို သေနိုင်ဘဲဟှူမီးန ရှို့လေ့မယ်” ဆိုဘီး ယောဟန်ဟှ ဟောပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","အယ်ခီမာ ယေရှုဟှ ယောဟန်နားဟှို ဗတ္တိဇံခံယူဟှို့တွပ် ဂါလိလဲပြည်ဟှနေဘီး ယော်ဒန်မ္လစ်ဟှို ကြွလာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","အယ်ဘေမဲ့ ယောဟန်ဟှ “ကျွန်တော်ဟှာ ကိုယ်တော်နားမာ ဗတ္တိဇံခံယူရဟှို့ဇာဟှို ကိုယ်တော်ဟှာ ကျွန်တော်နားဟှို ကြွလာတော်မူဟှယ်လော” ဆိုဘီးဟှာ ဆီးတားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ယေရှုဟှ “တရားလေ ဂူလောင်းဟှို ကူအောန် ကျင့်သင့်ဟှူကြောန့် ခု ခွမ့်ပေးပါ” ဆိုဘီး ပ္လန်ပြောတော်မူဟှယ်။ အယ်ကြောန့် ယောဟန်ဟှာ ဘောတူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ယေရှုဟှာ ဗတ္တိဇံခံယူဘီး ရေထဲဟှ ထလိုက်ဟှူန ကောန်းဂန်ဘောင် ပွမ့်ဟှားဘီး ဘုရားသခင်ရဲ့ ဝိညာဉ်တော်ဟှာ ချိုးငှတ်မျိုး ဆင်းလာဘီး ကိုယ်တော်ထတ်မာ နားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","အယ်ဘီးန “အယ်သူဟှာ ငါနှစ်သက်မြတ်နိုးဟှူ ငါ့ရဲ့ ရှစ်သား ဖြစ်ဟှယ်” ဆိုဘီး ကောန်းဂန်ဘောင်ဟှနေ သံတော်ဟှို ကြားရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","အယ်ဘီးန မာရ်နတ်ရဲ့ စောင်ဇမ်းသွီးဆောန်ရှင်းဟှို ခံဟှို့တွပ် ဝိညာဉ်တော်ဟှာ ယေရှုဟှို တောကန္တာရထဲဟှို ပို့ဆောန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ယေရှုဟှာ နေ့ရောညဉ့်ပါ ရစ်လေးဆယ် လောင်းလောင်း စာရှောန်ဘီးန ရရာတိုင်း ဗိုက်ဆာတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","အယ်ခီမာ မာရ်နတ်ဟှ ယေရှုနားဟှို ချဉ်းကပ်လာဘီး “သင်ဟှာ ဘုရားသခင်ရဲ့ သားဖြစ်ဟှယ် ဆိုဟှာ အယ်က္လော့‑က်ခဲလေဟှို မုဖြစ်လာအောန် မိန့်ပေးကေ့” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","အယ်ဘေမဲ့ ယေရှုဟှ “‘လူဟှာ စားဇာတခုဒဲန သတ်ရှင်ရဟှို့ မှုဟှ။ ဘုရားသခင်ရဲ့ စကားတော်အားဖြင့်ဘဲ့ သတ်ရှင်ရမယ်’ ဆိုဇာ ကျမ်းစာဟှ ပြောဟှားဟှယ်” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","အယ်ဘီးန မာရ်နတ်ဟှာ ယေရှုဟှို သန့်ရှင်းဟှူ ယေရုရှလင်ဗြို့ဟှို ခေါ်ဆောန်ဘီးဟှာ ကိုယ်တော့်ဟှို ဗိမာန်တော်ရဲ့ ထိဖျားမာ တန်ဟှားလိုက်ဘီး ");
INSERT INTO tvn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“ဘုရားသခင်ဟှ ကိုယ်တော့်ဟှို စောန့်ရှော့‑က်ဟှို့တွပ် ကောန်းဂန်တမန်လေဟှို “ ‘မိန့်မှာဟှားကြောန့် သူးနို့လေဟှာ ကိုယ်တော်ရဲ့ ခေဟှို က္လော့‑က်န ထိခိုက်ဘဲနနေအောန် ကိုယ်တော့်ဟှို လတ်န ခီမဟှားလေ့မယ် ဆိုဘီး ကျမ်းစာဟှ ပြောဟှားဟှယ်။ အယ်ကြောန့် ကိုယ်တော်ဟှာ ဘုရားသခင်ရဲ့ သားမှန်ဟှယ် ဆိုဟှာ အော့‑က်ဟှို ခူခ္လလိုက်’ ” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ယေရှုဟှ “နန့်ရဲ့သခင်၊ ဘုရားသခင်ဟှို စောင်ဇမ်းန ဆိုဇာ ကျမ်းစာဟှ ပြောဟှားဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","နော့‑က်တခါ မာရ်နတ်ဟှာ ကိုယ်တော့်ဟှို ရရာတိုင်း ဗြစ်ဟှူ တောန်ထတ်ဟှို ခေါ်ဆောန်ဟှားဘီး အယ်လောကမာရှိဟှူ တိုင်းနိုင်ငံလေရှိဟှူမျှန အယ်တိုင်းနိုင်ငံလေမာရှိဟှူ ဖောင်းစည်းဇိမ်လေဟှို ပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","မာရ်နတ်ဟှ “ကိုယ်တော်ဟှာ ငါ့ဟှို ပျတ်ဝပ်ဘီး ကိုးကွယ်မယ် ဆိုဟှာ အယ်မူဇာလေ ဂူလောင်းဟှို ငါပေးမယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ယေရှုဟှလည်း “ဝှေ့ စာတန် ငါ့နားဟှထွပ်ဟှား! ‘နန့်ရဲ့ဘုရားသခင် တပါးဒဲဟှိုဘဲ့ ကိုးကွယ်ရမယ်! အယ်မူ ဘုရားသခင် တပါးဒဲဟှိုဘဲ့ စေခံရမယ်’ ဆိုဇာ ကျမ်းစာဟှ ပြောဟှားဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","အယ်ဘီးန မာရ်နတ်ဟှာ ယေရှုနားဟှနေဘီး ထွပ်ဟှားလေဟှယ်။ အယ်ခီမာ ကောန်းဂန်တမန်လေဟှာ ရော့‑က်လာဘီးဟှာ ကိုယ်တော့်ဟှို လောက်ကျွေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ယောဟန် ထောန်ခ္လခံနေရဟှယ် ဆိုဇာဟှို ကြားရဟှူကြောန့် ယေရှုဟှာ ဂါလိလဲပြည်ဟှို ထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ကိုယ်တော်ဟှာ နာဇရက်ဗြို့မာ နေဘဲန ဇာဗုလုန်နယ် နဿလိနယ်စပ်ကြားဟှ ဂါလိလဲအိုင်နားမာရှိဟှူ ကပေရနောင်ဗြို့ဟှို သွားဘီးနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","အယ်ကြောန်းရာဟှာ ပရောဖက် ဟေရှာယဟှို ဘုရားသခင်ပေးဟှားဟှူ ဗျာဒိတ်တော် ပ္လဲ့ဇောင်ဟှို့တွပ် ဖြစ်လေဟှယ်။ ပရောဖက် ဟေရှာယဟှ ");
INSERT INTO tvn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“အို၊ ဇာဗုလုန်နယ်န နဿလိနယ်၊ ယော်ဒန်မ္လစ်ဟှိုဖတ်ကမ်း၊ အိုင်လမ်းတရှော့‑က်န၊ လူမျိုးခြားလေနေထိုင်ဟှူ ဂါလိလဲပြည်! ");
INSERT INTO tvn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","မှောန်ထဲမာ နေထိုင်ဟှူ သူလေဟှာ တော့‑က်ပဟှူ လန်းရောန်ဟှို ဗြင်ရလေ့မယ်။ သေမန်းရဲ့ ရိအော့‑က်မာ နေဂေ့ဟှူ လူလေထတ်ဟှို တော့‑က်ပဟှူ လန်းရောန် ရော့‑က်လာလေ့မယ်” ဆိုဘီး ဟောပြောဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","အယ်ခီဟှနေစဘီး ယေရှုဟှာ “နောန်ဒရဂေ့။ ကောန်းဂန်နိုင်ငံတော်ဟှာ တည်ခါနီးနေဘီ!” ဆိုဘီးဟှာ ကြေညာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ယေရှုဟှာ ဂါလိလဲအိုင်နား ဖြတ်ဘီး သွားဟှူ ခီမာ ညီကိုနှေ့ယော့‑က်ဖြစ်ဟှူ၊ ပေတရု ဆိုဘီး နာမယ်ခေါ်ဟှူ ရှိမုန်န သူ့ညီအန္ဒြေလေဟှာ ပိုက်ကွန်ပစ်နေဇာဟှို ဗြင်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ယေရှုဟှ အယ်သူလေဟှို “ငါ့နော့‑က်လိုက်ဂေ့။ နန်းနို့လေဟှို လူလေဟှိုဖမ်းဟှူ ငါးဖမ်းမားဖြစ်စေမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","သူးနို့လေလည်း တခါဒဲဘဲ့ ပိုက်ကွန်လေဟှို ထားရစ်ဘီးန နော့‑က်တော်ဟှို လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ကိုယ်တော်ဟှာ ဆစ်ဘီးသွားခီမာ တခြားညီကို နှေ့ယော့‑က်ဖြစ်ဟှူ ဇေဗေဒဲရဲ့သား ယာကုပ်န သူ့ညီယောဟန်ဟှို သူ့ဖနတူးဒူ လှေထတ်မာ ပိုက်ကွန်လေ ဖာနေဇာဟှို ဗြင်တော်မူလေဟှယ်။ ကိုယ်တော်ဟှ အယ်သူလေဟှို ခေါ်ဟှူ ခီမာ ");
INSERT INTO tvn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","သူးနို့လေလည်း လှေန သူးနို့ဖဟှို ထားရစ်ဘီးဟှာ ယေရှုနော့‑က်ဟှို တခါဒဲ လိုက်ဟှားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ယေရှုဟှာ ဂါလိလဲပြည် တပြည်လောင်းဟှို လှည့်လည် သွားလာဘီးဟှာ နိုင်ငံတော်ကြောန်း ဒန်းကောန်းဟှို ဝါလယ်ဇရပ်လေမာ သွန်သန် ဟောပြောဘီး နေကောန်းဘဲဟှူ သူလေဟှို ကျန်းမာစေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ယေရှုရဲ့ ဒန်းဟှာ ရှုရိပြည် တပြည်လောင်းဟှို ပ္လံ့နှံ့ဟှားကြောန့် နတ်ဆိုးပူးခံရဟှူ လူလေ၊ ဝပ်ရူးစွဲဟှူ လူလေ၊ ခေလတ်သေနေဟှူ လူလေန ရောဂါဘောင်းဇောင်စွဲဟှူလူလေ ဂူလောင်းဟှို ယေရှုနားဟှို ခေါ်လာဂေ့လေဟှယ်။ ခေါ်လာဂေ့ဟှူ လူနာလေ ဂူလောင်းလည်း ရောဂါပျော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ဂါလိလဲပြည်၊ ဒေကာပေါလိပြည်၊ ယေရုရှလင်ဗြို့၊ ယုဒပြည်န ယော်ဒန်မ္လစ်ရဲ့ ဟှိုဖတ်ကမ်းဟှ လာဟှူ သူလေလည်း ကိုယ်တော်နော့‑က်ဟှို လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ယေရှုဟှာ လူအောက်ဂီးဟှို ဗြင်ဟှူ ခီမာ တောန်ထတ်ဟှို တတ်ဘီး ထိုင်နေလေဟှယ်။ တဗဲ့တော်လေလည်း ကိုယ်တော်နားဟှို လာဂေ့ကြောန့် ");
INSERT INTO tvn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ကိုယ်တော်ဟှာ တဗဲ့တော်လေဟှို စဘီးဟှာ သွန်သန်ဇာဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“စိနှလောင်းနှိခ္လဟှူသူလေဟှာ မင်္ဂလာရှိဟှယ်။ ကောန်းဂန်နိုင်ငံတော်ဟှာ အယ်သူလေရဲ့ နိုင်ငံဖြစ်ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ဝန်းနဲပူဆွေးဘီး သောကရော့‑က်နေဟှူသူလေဟှာ မင်္ဂလာရှိလေဟှယ်။ ဘုရားသခင်ဟှာ အယ်သူလေဟှို အားပေးနှစ်သိမ့်မှုလေ ပေးလေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","စိနူးညံ့သိမ်မွေ့ဟှူသူလေဟှာ မင်္ဂလာရှိဟှယ်။ အယ်သူလေဟှာ ဘုရားသခင် ဂဒိထားတော်မူဟှူ လောကရဲ့ မွီဟှို လတ်ခံရလေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ဖြောန့်မတ်ရှင်းဟှို ငတ်ပြတ်နေဟှူ သူလေဟှာ မင်္ဂလာရှိဟှယ်။ ဖြားဖြစ်ကြောန်းနူးဆိုဟှာ သူးနို့လေဟှာ ဗိုက်ပ္လဲ့ရဂေ့လေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","သနားကြင်နာတတ်ဟှူ သူလေဟှာ မင်္ဂလာရှိဟှယ်။ ဘုရားသခင်ဟှာ အယ်သူလေဟှို သနားကြင်နာတော်မူလေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","စိနှလောင်းဖ္လူစင်ဂေ့ဟှူ သူလေဟှာ မင်္ဂလာရှိဂေ့ဟှယ်။ အယ်သူလေဟှာ ဘုရားသခင်ဟှို ဗြင်ရဂေ့လေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ယော့‑က်နယော့‑က်ဟှို သင့်မြတ်အောန် လောက်ပေးဟှူသူလေဟှာ မင်္ဂလာရှိဟှယ်။ အယ်သူလေဟှာ ဘုရားသခင်ရဲ့ သားမီးလေ ဆိုဘီး ခေါ်ခံရလေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ဘုရားသခင်ရဲ့ လိုတော်တိုင်း လောက်ဆောန်ဟှူကြောန့် နှိစစ်ညှဉ်းဆဲခံရသူလေဟှာ မင်္ဂလာရှိဟှယ်။ ကောန်းဂန်နိုင်ငံတော်ဟှာ အယ်သူလေရဲ့ နိုင်ငံဖြစ်ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“ငါ့ကြောန့် ညှဉ်းဆဲကဲ့ရဲ့ခံရဘီး မှန်ဘဲန စွပ်စွဲခံရခီမာ နန်းနို့ဟှာ မင်္ဂလာရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ဝန်းသာအားရဖြစ်ဂေ့ပါ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကောန်းဂန်ဘောင်မာ နန်းနို့တွပ် ရရာတိုင်း ကီးဟှူဆုလာဘ် ရှိဟှယ်။ နန်းနို့ရှေ့ဟှ ပရောဖက်လေလည်း အယ်မျိုးဘဲ့ ညှဉ်းဆဲခံရဂေ့ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“နန်းနို့လေဟှာ အယ်လောကရဲ့ ဆားဖြစ်ဟှယ်။ ဆားဟှာ ငန်ဟှူရသာ ပျော့‑က်ဟှားမယ် ဆိုဟှာ ငန်ဟှူရသာဟှို ဖယ်မျိုးလည်း ပ္လန်ရနိုင်ဟှို့ မှုဟှ။ တန်ဖိုးမှေ့ဘဲဟှူ ဆားဖြစ်ဟှားကြောန့် ပ္လန်ဟှိုပစ်ထုလိုက်ဘီး လူလေဟှာ ကျော်နန်းဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“နန်းနို့လေဟှာ အယ်လောကရဲ့ လန်းရောန်ဖြစ်ဟှယ်။ တောန်ထိထတ်မာ တည်ဟှူဗြို့ဟှို ကွယ်နိုင်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ဆီမီးအီဟှို ထွန်းဘီးဟှာ တောန်းအော့‑က်မာ ထားဟှားလေ့ မှေ့ဟှ။ အီသူအီသားလေ လန်းရောန်ရအောန် ဆိုဘီး ဆီမီးခေါင်ထတ်မာဘဲ့ တန်ဟှားတတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","အယ်မျိုးဘဲ့ လူလေဟှာ နန်းနို့လေရဲ့ ကောန်းဟှူ ကျင့်ဟှို ဗြင်ဘီးဟှာ ကောန်းဂန်ဘောင်မာရှိဟှူ နန်းနို့ဖရဲ့ ဂေါင်တော်ဟှို ချီးမွမ်းစေဟှို့တွပ် နန်းနို့လေရဲ့ သတ်တာလန်းရောန်ဟှို လန်းစေဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“မောရှေရဲ့ ပညတ်တရားန ပရောဖက်လေရဲ့ သွန်သန်ဟှားဇာလေဟှို ဖျစ်ပယ်ဟှို့တွပ် ငါလာဟှယ် ဆိုဘီး ထန်ဂေ့န။ ဖျစ်ပယ်ဟှို့တွပ် ငါလာဇာ မှုဟှ။ ပ္လဲ့ဇောင်ဟှို့တွပ် ငါလာဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","နန်းနို့ဟှို ငါ မှန်ပြောမယ်၊ ကောန်းဂန်ဘောင်န မ္လေဂီး ပျော့‑က်ကွယ်ခန်ထိ ပညတ်တရားထဲမာ ငယ်ဆောင်းဖြစ်ဟှူ စာလောင်း တလောင်းလည်း ပ္လဲ့ဇောင်ခန်ထိ ပျစ်စီးစေဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","အယ်ကြောန့် ငယ်ဆောင်းဖြစ်ဟှူ ပညတ်တခုဟှို ကိုယ်ကိုယ်တိုင်လည်း ကျူးလွန်ဘီးဟှာ သူများလေဟှိုလည်း အယ်မျိုးသွန်သန်ပေးဟှယ်။ အယ်သူဟှာ ကောန်းဂန်နိုင်ငံတော်မာ အငယ်ဆောင်းသူ ဖြစ်ရလေ့မယ်။ ကိုယ်ကိုယ်တိုင်လည်း လိုက်နာဘီးဟှာ သူများလေဟှိုလည်း သွန်သန်ပေးလေဟှယ်။ အယ်သူဟှာ ကောန်းဂန်နိုင်ငံမာ ကီးမြတ်ဟှူ သူဖြစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ဘုရားသခင်ရဲ့ လိုတော်တိုင်း သတ်ရှင်ခီမာ နန်းနို့လေရဲ့ ကျင့်ဟှာ ဖာရိရှဲန ကျမ်းပြုဆရာလေ ကျင့်ဟှူကျင့်ထတ် ပိုသာဘဲဟှ ဆိုဟှာ ကောန်းဂန်နိုင်ငံတော်ဟှို ဝမ်ရဟှို့ မှုဟှ ဆိုဘီး ငါမှန်တိုင်းပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ ‘လူ့ရဲ့သတ်ဟှို သတ်န။ သတ်ဟှူသူဟှာ တရားရောင်းမာ ပြစ်စီရင်ခံရမယ် ဆိုဘီး ရှေးဟှ ပြောဟှားဇာဟှို နန်းနို့ကြားသိပီးဘီ။’ ");
INSERT INTO tvn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ငါပညတ်ဇာဟှ နန်ဟှာ ကိုယ့်ညီကိုဟှို ဒေါသထွပ်ဟှယ် ဆိုဟှာ တရားလွတ်တော်ရှေ့ဟှို ရော့‑က်ရမယ်! ညီကိုရှင်းရှင်းဟှို ကီဆဲဟှူသူဟှာ ရောင်းမာ ပြစ်ပေးခံရမယ်။ ညီကိုရှင်းရှင်းဟှို လူမိုက် ဆိုဘီး ပြောဟှူသူလည်း ငရဲမှာ မီးရှို့ဇာခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","အယ်ကြောန့် နန်းနို့လေဟှာ ယဇ်ပလ္လင်မာ ပူဇော်ဆစ်သဟှို့ ပြင်ဆင်ဟှူ ခီမာ ညီကိုဟှို ပြစ်မှားဟှားဇာလေ ဒိရလာဟှယ် ဆိုဟှာ ");
INSERT INTO tvn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","နန့်ရဲ့ ပူဇော်သကာဟှို ယဇ်ပလ္လင်ရှေ့မာ ထားရစ်ဘီး ညီကိုဟှို သွားဘီး တောန်းဗန်လိုက်ပါ။ အယ်ဘီးမှ ပ္လန်လာဘီး ဘုရားသခင်ဟှို ပူဇော်သကာဟှို ပူဇော်ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“နန့်ဟှို တရားစွဲဟှူ လူနတူးဒူ ခရီးသွားနေခီမာ သူ့ဟှို ဗြန်းဗြန် တောန်းဗန်လိုက်ပါ။ နော့‑က်မှုဘဲနေဟှာ သူဟှ နန့်ဟှို တရားသူဂီးလတ်ထဲအပ်ဘီး တရားသူဂီးဟှ ရဲလတ်ဟှို အပ်လိုက်ဟှူကြောန့် နန်ဟှာ ထောန်ထဲမာ ထဲ့ဟှားဇာဟှို ခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","နန်းနို့ဟှို ငါ မှန်ပြောမယ်၊ ကပ်ကွီးကျေအောန် မဆပ်မရှင်း နန်ဟှာ ထောန်ထဲမာ နေရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ ‘အီထောန်ရေးဖော့‑က်ပ္လန်ဇာဟှို ကျူးလွန်န ဆိုဘီး ပြောဟှားဇာဟှို နန်းနို့ကြားသိပီးဘီ။’ ");
INSERT INTO tvn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ငါပညတ်ဇာဟှ ကိလေသစိန သူများရဲ့မယားဟှို ကေ့မိဟှူသူဟှာ စိနှလောင်းထဲဟှ အယ်မီးမန ပြစ်မှားလေဘီ။ ");
INSERT INTO tvn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","အယ်ကြောန့် ညာမျစ်စိန မှားယွင်းမိဟှယ် ဆိုဟှာ ညာမျစ်စိဟှို ထုပစ်လိုက်! တကိုယ်လောင်း ငရဲထဲဟှို ပစ်ခ္လခံရထတ် မျစ်စိတဖတ်မှေ့ဘဲန သတ်ရှင်ရဇာဟှာ ပိုကောန်းဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","အယ်မျိုးဘဲ့ နန့်ညာလတ်ဟှ နန့်ဟှို မှားယွင်းစေဟှယ် ဆိုဟှာ ညာလတ်ဟှို ဖြတ်ပစ်လိုက်! တကိုယ်လောင်း ငရဲထဲဟှို ပစ်ခ္လခံရထတ် လတ်တဖတ်မှေ့ဘဲန သတ်ရှင်ရဇာဟှ ပိုကောန်းဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ ‘ကိုယ့်မယားဟှို ကွာရှင်းရှင်ဟှယ် ဆိုဟှာ ကွာရှင်းစာချောက်ဟှို ပေးရမယ် ဆိုဘီး ပညတ်ဟှားလေဟှယ်။’ ");
INSERT INTO tvn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ငါပညတ်ဇာဟှ ဆိုးသွန်းဘီး ဖော့‑က်ပ္လန်ဇာမှေ့ဘဲန တခြားကြောန်းလေကြောန့် ကိုယ့်မယားဟှို ကွာရှင်းရှင်သူဟှာ အီထောန်ရေးဖော့‑က်ပ္လန်ရှင်းဟှို ကျူးလွန်သူ ဖြစ်ဟှယ်။ ကွာရှင်းဟှူမီးမန ပေါန်းသင်းဟှူသူဟှလည်း အီထောန်ရေးဖော့‑က်ပ္လန်ရှင်းဟှို ကျူးလွန်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ ‘မှုဘဲန ကီဆိုဂေ့န။ ကီဆိုလိုက်ဟှူတိုင်း ဘုရားသခင်ရှေ့မာ တည်ရမယ် ဆိုဘီး ရှေးဟှပညတ်ဟှားဇာဟှို နန်းနို့ကြားသိပီးဘီ။’ ");
INSERT INTO tvn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ငါပညတ်ဇာဟှ လောင်းဝ ကီဆိုဂေ့န။ ကောန်းဂန်ဘောင်ဟှို တိုင်တယ်ဘီးဟှာ ကီဆိုဂေ့န။ ကောန်းဂန်ဘောင်ဟှာ ဘုရားသခင်ရဲ့ ပလ္လင်တော်ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","မ္လေဂီးဟှို တိုင်တယ်ဘီး ကီဆိုဂေ့န။ မ္လေဂီးဟှာ ဘုရားသခင်ရဲ့ ခေတော်တန်ရာခေါင် ဖြစ်ဟှယ်။ ယေရုရှလင်ဗြို့ဟှို တိုင်တယ်ဘီး ကီဆိုဂေ့န။ မဟာမန်းဂီးရဲ့ ဗြို့တော်ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","နန်းနို့ရဲ့ ဆားဗန်တဗန်ဟှိုမှ ဖ္လူအောန်၊ မဲအောန် လောက်နိုင်ဘဲန ကိုယ့်ရဲ့ခေါန်းဟှို တိုင်တယ်ဘီးဟှာ ကီဆိုဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","နန်းနို့စကားဟှာ ‘မှန်ဇာဟှို’ မှန်ဖြစ်စေဘီး ‘မှုဘဲဇာဟှို’ မှုဟှ ဆိုဘီး ဖြစ်စေဂေ့ပါ။ အယ်ထတ်ပိုဟှူစကားဟှာ မုသာနဘဲ့ စပ်ဆိုင်ဇာဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“‘မျစ်စိတလောင်းတွပ် မျစ်စိတလောင်း၊ သွားတရှောန်းတွပ် သွားတရှောန်း’ ဆိုဘီး ပညတ်ဟှားဇာဟှို နန်းနို့ကြားဟှားပီးဘီ။ ");
INSERT INTO tvn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ငါပညတ်ဇာဟှ နှော့‑က်ယှစ်ဟှူ သူလေဟှို ရန်တုံ့ပ္လန်ဂေ့န ဆိုဘီး ငါပြောဟှယ်။ နန့်ပါးတဖတ်ဟှို ရိုက်ဟှယ် ဆိုဟှာ ကျန်ဟှူ ပါးတဖတ်ဟှိုလည်း ရိုက်ဟှို့ လှည့်ပေးလိုက်ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","နန့်အန်းဂီဟှို လိုရှင်ဟှူကြောန့် စီရင်ဟှူသူလေဟှို နန့်ဝတ်လောင်ဟှိုလည်း ပေးလိုက်ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ယော့‑က်ယော့‑က်ဟှ နန်းနို့ဟှို နိုင်ကျင့်ဘီး တမိုင် သွားခိုင်းမယ် ဆိုဟှာ အယ်သူနတူးဒူ နှေ့မိုင် သွားလိုက်ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","နန့်နားမာ တောန်းဟှူလူဟှို ပေးလိုက်ပါ။ ချေးငှားဟှူသူလေဟှိုလည်း ငြင်းဘဲန ချေးငှားလိုက်ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ ‘နန့်ရဲ့ အီဇနီးရှင်းဟှို ရှစ်ပါ။ ရန်သူဟှိုမူးပါ ဆိုဘီး ရှေးဟှပညတ်ဟှားဇာဟှို နန်းနို့ကြားသိပီးဘီ။’ ");
INSERT INTO tvn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ငါပညတ်ဇာဟှ ရန်သူလေဟှို ရှစ်ဂေ့။ ညှဉ်းဆဲဟှူသူလေဟှို ဆုတောန်းဂေ့။ နန်းနို့လေဟှို မူးဟှူသူလေဟှိုလည်း ကူညီဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","အယ်ဆိုဟှာ နန်းနို့လေဟှာ ကောန်းဂန်ဘောင်မာ ရှိတော်မူဟှူ ဘုရားသခင်ရဲ့ သားမီးလေဖြစ်လာလေ့မယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကောန်းဂန်ဘောင်မာ ရှိတော်မူဟှူ နန်းနို့ဖဟှာ ဖြောန့်မတ်ဟှူသူလေ၊ ဖြောန့်မတ်ဘဲဟှူသူလေထတ်မာ သူ့ရဲ့နေရောန်ဟှို ထွန်းလန်းစေဘီး သူတော်ကောန်းလေ၊ သူယောက်မာလေထတ်မာလည်း မိုးဝါစေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","နန်းနို့ဟှို ရှစ်ဟှူသူလေဟှိုဘဲ့ ပ္လန်ဘီးရှစ်ဟှယ် ဆိုဟှာ ဖြားကျိုးထူးမယ်နူး။ ခွန်ကော့‑က်မားလေလည်းဘဲ့ အယ်မျိုး လောက်တတ်ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","နန်းနို့ရဲ့ ညီကိုလေဟှိုဘဲ့ မြစ်တာထားဘီး စကားပြောဟှယ် ဆိုဟှာ ဘုရားသိဘဲဟှူ လူလေန ဖြားဇာလေ ကွာခြားနူး။ ဘုရားသိဘဲဟှူ လူလေလည်းဘဲ့ အယ်မျိုး လောက်ဂေ့ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","အယ်ကြောန့် ကောန်းဂန်ဘောင်ဟှ နန်းနို့ ဖဟှာ စောင်လင်ဟှူ မျိုးဘဲ့ နန်းနို့လည်း စောင်လင်အောန် နေဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“နန်းနို့လေဟှာ ကောန်းဇာလေလောက်ဟှူ ခီမာ လူလေဗြင်အောန် လောက်မိဘဲနေဟှို့ ဒိထားဂေ့ပါ။ နန်းနို့ဟှာ လူလေဗြင်အောန် လောက်မယ် ဆိုဟှာ ကောန်းဂန်ဘောင်မာ ရှိတော်မူဟှူ နန်းနို့ဖနားဟှ ကျိုးဟှို ခံစားရဂေ့ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“အယ်ကြောန့် နန်းနို့ လှူဒါနပေးဟှူ ခီမာ သူတော်ကောန်း ယောန်ဆောန်ဟှူ သူလေ လောက်ဂေ့ဟှူမျိုး လူလေထန်ကီးဇာခံရဟှို့ ဝါလယ်ဇရပ်လေန လမ်းဆောင်လမ်းခွလေမာ တံပိုးမှုဘီး ကြေညာဂေ့န။ သူးနို့လေဟှာ လူလေရဲ့ထန်ကီးဘီး ချီးမွမ်းခံရအောန်ဘဲ့ လောက်ဂေ့လေဟှယ်။ ငါမှန်တိုင်းပြောမယ် အယ်သူလေဟှာ ခုဘဝကျိုးဟှိုဘဲ့ ရဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","နန်းနို့လေဟှာ လှူဒါနပေးဟှူ ခီမာ ဘယ်ဖတ်လတ်န ပေးဟှူဇာဟှို ညာဖတ်လတ်ဟှို သိစေန။ ");
INSERT INTO tvn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ထန်ရှားဘဲဇာဟှို ဗြင်တော်မူဟှူ နန်းနို့ဖဟှာ ကျိုးဟှို ထန်ရှားအောန် ပေးတော်မူလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“နန်းနို့လေဟှာ ဆုတောန်းဟှူ ခီမာ သူတော်ကောန်း ယောန်ဆောန်သူလေမျိုး လောက်ဂေ့န! အယ်သူလေဟှာ လူလေဗြင်အောန် ဆိုဘီး ဝါလယ်ဇရပ်လေ၊ လမ်းဆောင်လမ်းခွလေမာ ရပ်ဘီးဟှာ ဆုတောန်းဂေ့လေဟှယ်။ ငါမှန်တိုင်းပြောမယ် အယ်သူလေဟှာ လူလေရဲ့ ထန်ကီးဇာလေန ချီးမွမ်းဇာလေဟှို ခံရဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","နန်းနို့လေ ဆုတောန်းဟှူ ခီမာ တိဆိဟှူ အီခန်းထဲဟှိုဝမ်ဘီး ခွဗော့‑က်ဟှို လောင်အောန်ပိဘီးဟှာ ထန်ရှားဘဲဟှူရပ်မာ ရှိတော်မူဟှူ နန်းနို့ဖနားမာ ဆုတောန်းဂေ့ပါ။ ထန်ရှားဘဲဇာဟှို ဗြင်တော်မူဟှူ နန်းနို့ဖဟှာ ကျိုးဟှို ထန်းထန်ရှားရှား ပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“နန်းနို့လေဟှာ ဆုတောန်းဟှူ ခီမာ ဘုရားသိဘဲဟှူလူလေမျိုး ဓိပါယ်မှေ့ဘဲဟှူ စကားလေန ထပ်ခါထပ်ခါ တောန်းဂေ့န။ အယ်သူလေဟှာ ရရာတိုင်းရှယ်ဟှူ စကားန ခီကြာဂီး ဆုတောန်းဟှယ် ဆိုဟှာ သူးနို့လိုရှင်ဇာဟှို ရလေ့မယ် ဆိုဘီး ထန်မှတ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","သူးနို့လေမျိုး လောက်ဂေ့န။ နန်းနို့လိုအပ်ဟှူ ဇာလေဟှို နန်းနို့တောန်းခန်ဂဒဲဟှ နန်းနို့ရဲ့ဖ သိတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","အယ်ကြော့န် နန်းနို့လေ ဆုတောန်းဟှူ ခီမာ၊ “‘ကောန်းဂန်ဘောင်မာ ရှိတော်မူဟှူဖ၊ ကိုယ်တော်ရဲ့ နာမတော်ဟှို ရိုသေလေးမြတ်ရှင်း ရှိပါစေ။ ");
INSERT INTO tvn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","နိုင်ငံတော် တည်ထောန်ပါစေ။ လိုတော်ဟှာ ကောန်းဂန်နိုင်ငံမာ ပ္လဲ့ဇောင်ဟှူမျိုးဘဲ့ မ္လေဂီးထတ်မာလည်း ပ္လဲ့ဇောင်ပါစေ။ ");
INSERT INTO tvn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ကျွန်တော့်ဟှားလေ လိုအပ်ဟှူစားဇာဟှို အယ်နေ့တွပ် ပေးသနားတော်မူပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ကျွန်တော့်ဟှားလေဟှို ပြစ်မှားဟှူ သူလေရဲ့ ပြစ်လေဟှို ကျွန်တော်ဟှားလေ ခွမ့်လွှတ်ပေးဟှူမျိုးဘဲ့ ကျွန်တော်ဟှားလေရဲ့ ပြစ်လေဟှို ခွမ့်လွှတ်ပေးပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ပြစ်သွီးဆောန်ဟှူနော့‑က်ဟှို လိုက်ပါသွားစေဘဲန၊ ကောန်းဘဲဟှူဇာလေဟှလည်း ကယ်နှုပေးပါ’ ဆိုဘီး ဆုတောန်းဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“နန်းနို့လေဟှာ သူများလေရဲ့ ပြစ်မှားဇာဟှို ခွမ့်လွှတ်ပေးဟှယ် ဆိုဟှာ ကောန်းဂန်ဘောင်မာ ရှိဟှူ နန်းနို့ဖလည်း နန်းနို့လေရဲ့ ပြစ်လေဟှို ခွမ့်လွှတ်ပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","အယ်ဘေမဲ့ နန်းနို့လေဟှာ သူများလေ ပြစ်မှားဟှူဇာဟှို ခွမ့်လွှတ်ပေးဟှ ဆိုဟှာ နန်းနို့ဖလည်း နန်းနို့လေရဲ့ပြစ်ဟှို ခွမ့်လွှတ်ပေးလေ့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“နန်းနို့လေဟှာ စာရှောန်ခီမာ သူတော်ကောန်းယောန်ဆောန်ဟှူ သူလေမျိုး သူများလေရဲ့ရှေ့မာ မျစ်နှာညှိုးငယ်ဘီး နေဂေ့န။ အယ်သူလေဟှာ သူးနို့စာရှောန်ဇာဟှို သူများလေသိအောန် ရရာတိုင်း ဗိုက်ဆာဘီး အားနဲနေဟှူပေါင်ဇံမျိုးန သူများလေရှေ့မာ ပြသတတ်ဟှယ်။ ငါမှန်တိုင်းပြောမယ် အယ်သူလေဟှာ လူလေရဲ့ ထန်ကီးဇာလေ၊ ချီးမွမ်းဇာလေဟှို ခံရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","နန်းနို့လေဟှာ စာရှောန်ဟှူ ခီမာ စာရှောန်ဟှူကြောန်းဟှို သူများလေဟှို သိစေန။ ထန်ရှားဘဲရပ်မာရှိဟှူ နန်းနို့ဖရှေ့မာ ထန်ရှားစေဟှို့တွပ် မျစ်နှာဟှိုသစ်၊ ခေါန်းဟှို ဆီန လူးဘီးဟှာ လန်းလန်းဆန်းဆန်းဟှား နေဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ထန်ရှားဘဲဇာဟှို ဗြင်တော်မူဟှူ နန်းနို့ဖဟှာ ကျိုးဟှို ထန်းထန်ရှားရှား ပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“သံခ္လေး၊ ခြလေ၊ ခိုးလေ၊ မ္လလေ ဖော့‑က်ထွမ်းဘီး ခိုးယူနိုင်ဟှူ လောကီဘဏ္ဍာဟှို စုဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","အယ်ဘေမဲ့ သံခ္လေး၊ ပိုးလေ၊ ခိုးလေ၊ မ္လလေလည်း ခိုးယူနိုင်ဘဲဟှူ ကောန်းဂန်ဘဏ္ဍာဟှို စုဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်းနို့လေဟှာ ဘဏ္ဍာရှိဟှူ နေရာဟှိုဘဲ့ နန်းနို့စိနှလောင်းဟှာ ရော့‑က်တတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“မျစ်စိဟှာ ကိုယ်ခန္ဓာတွပ် ဆီမီးအီန တူဟှယ်။ မျစ်စိကောန်းဟှယ် ဆိုဟှာ နန်းနို့ရဲ့ ကိုယ်ခန္ဓာ တခုလောင်း လန်းလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","အယ်ဘေမဲ့ မျစ်စိကောန်းဂေ့ဟှ ဆိုဟှာ ကိုယ်ခန္ဓာ တခုလောင်း မှောန်လေ့မယ်။ နန်းနို့လေရဲ့ လန်းရောန်ဟှာ မှောန်မိုက်ဖြစ်နေဟှယ် ဆိုဟှာ အယ်မှောန်မိုက်ဟှာ ရရာတိုင်း မိုက်လေဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ဖယ်သူဟှလည်း သခင်နှေ့ယော့‑က်ရဲ့ စေဟှို ခံနိုင်ဟှ။ သခင်တယော့‑က်ဟှို မူးဘီး တယော့‑က်ဟှို ရှစ်လေ့မယ်။ သခင်တယော့‑က်ဟှို သစ်စာစောန့်ဘီးဟှာ တယော့‑က်ဟှို ထီမဲ့မြင်လောက်လေ့မယ်။ နန်းနို့လေဟှာ ဘုရားသခင်န လောကစည်းဇိမ်လေဟှို တပြိုင်ဒဲ စေခံနိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“အယ်ကြောန့် နန်းနို့ဟှို ငါပြောမယ်။ ဖယ်မျိုးစားရဟှို့၊ ဖယ်မျိုးသော့‑က်ရဟှို့ ဆိုဘီး သတ်တွပ် စိုးရိမ်ဂေ့န။ ဖယ်မျိုးဝတ်ရဟှို့ ဆိုဘီးလည်း ကိုယ်ခန္ဓာတွပ် စိုးရိမ်ဂေ့န။ စာထတ် သတ်ဟှ ပိုမြတ်ဟှယ် မှုဟှလော။ ဝတ်ထတ်လည်း ကိုယ်ခန္ဓာဟှာ ပိုဘီး မြတ်ဟှယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ကောန်းဂန်မာရှိဟှူ ငှတ်လေဟှို ကေ့ဘီးဟှာ ဆင်ခြင်ကေ့ဂေ့ပါ။ သူးနို့လေဟှာ မျိုးစေ့လည်း ကြဲဟှ။ သီးနှံလည်း ရိဟှ။ သိုဘီးလည်း ထားဟှ။ အယ်ဘေမဲ့ ကောန်းဂန်ဘောင်ဟှ နန်းနို့လေရဲ့ ဖဟှာ သူးနို့လေဟှို ကျွေးမွေးလေဟှယ်! အယ်ငှတ်လေထတ် နန်းနို့လေဟှာ ပိုဘီး မြတ်ဟှယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","နန်းနို့လေထဲမာ ဖယ်သူဟှ စိုးရိမ်နေဇာအားဖြင့် သတ်နဲနဲပိုရှယ်လာနိုင်မယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“နန်းနို့လေ ဖြားဖြစ်ကြောန့် ဝတ်တွပ် စိုးရိမ်နေဂေ့နူး။ တောပန်းလေဟှာ ဖယ်မျိုးရှင်ဘီး ဖယ်မျိုး ကီးလာဇာဟှို ကေ့ဘီးဟှာ ဆင်ခြင်ဂေ့ပါ။ အယ်တောပန်းလေဟှာ လောက်လည်းလောက်ဟှ။ ခယ်ဖြစ်အောန်လည်း တတ်နိုင်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","အယ်ဘေမဲ့ ရှောလမုန်မန်းဂီးရဲ့ ဖောင်းစည်းဇိမ်လေ ဂူလောင်းဟှို ဆင်ဟှယ်ဟှိုမှ အယ်တောပန်းလေထဲဟှ တဗန်မျိုး လှပတင့်တယ်ဟှ ဆိုဘီး နန်းနို့လေဟှို ငါပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ယောင်ကြည်ရှင်း အားနဲဟှူလူလေ! အယ်နေ့သတ်ရှင်ဘီး နတ်ကီးတိုင်ဟှာ မီးဖိုထဲဟှို ရော့‑က်ရဟှူ တောဗြစ်ပန်လေဟှို ဘုရားသခင်ဟှာ အယ်မျိုးဆင်ပေးဟှယ် ဆိုဟှာ နန်းနို့လေဟှို အယ်ထတ်မက ဆင်ပေးမယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“အယ်ကြောန့် ဖယ်မျိုးစားရဟှို့နူး၊ ဖယ်မျိုးသော့‑က်ရဟှို့နူး၊ ဖယ်မျိုးဝတ်ရဟှို့နူး ဆိုဘီး စိုးရိမ်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(ဘုရားသိဘဲဟှူလူလေဟှဘဲ့ အယ်မူဇာလေဟှို စိုးရိမ်တတ်ဂေ့ဟှယ်။) အယ်မူဇာလေဟှို နန်းနို့လေ လိုအပ်ဟှယ် ဆိုဇာဟှို ကောန်းဂန်ဘောင်ဟှ နန်းနို့ဖ သိတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ဘုရားသခင်ရဲ့ နိုင်ငံတော်န ဖြောန့်မတ်ရှင်းဟှို ဦးဆောင်း ရှာဂေ့ပါ။ နော့‑က်မှ နန်းနို့လိုအပ်ဟှူဇာလေဟှို ထပ်ဘီးပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","အယ်ကြောန့် နတ်ကီးတိုင်တွပ် စိုးရိမ်ဂေ့န။ နတ်ကီးတိုင်ဟှဘဲ့ သူ့တွပ်စိုးရိမ်လေ့မယ်။ အယ်မူနေ့မာ တွိကြောင်ရင်ဆိုင်ရဟှူ ဇာလေဟှာ အယ်နေ့တွပ် လောင်လော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“နန်းနို့လေဟှာ ကိုယ်ကိုယ်တိုင် စစ်ကြောစီရင်ရှင်းဟှနေ လွတ်ရှင်ဟှယ် ဆိုဟှာ သူများလေဟှိုလည်း စစ်ကြောစီရင်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်းနို့လေဟှာ သူများလေဟှို စစ်ကြောစီရင်ဟှူတိုင်းဘဲ့ နန်းနို့လည်းဘဲ့ ဘုရားသခင်ဟှ စစ်ကြောစီရင်လေ့မယ်။ နန်းနို့ဟှာ သူများလေဟှို ပေးဟှူ ပမာဏတိုင်း ဘုရားသခင်ဟှ နန်းနို့ဟှို ပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","နန်ဟှာ ကိုယ့်မျစ်စိထဲဟှ သစ်တောင်းဟှို ဗြင်ဘဲန နန့်ညီကိုရဲ့ မျစ်စိထဲဟှ သစ်မုဟှို ဖြားဖြစ်ကြောန့် ဗြင်ရနူး။ ");
INSERT INTO tvn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","နန့်မျစ်စိထဲဟှ သစ်တောင်းဟှို ဗြင်ဘဲန နန့်ညီကိုဟှို ‘နန့်မျစ်စိထဲဟှ သစ်မုဟှားဟှို ထုပစ်ပေးပါရစေ’ ဆိုဘီး ဖြားဖြစ်ကြောန့် ပြောရနူး။ ");
INSERT INTO tvn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","သူတော်ကောန်းယောန်ဆောန်ဟှူသူ! နန့်မျစ်စိထဲဟှ သစ်တောင်းဟှို ရင်ဦးဆောင်းထုပစ်လိုက်ပါ။ အယ်ဆိုဟှာ ညီကိုမျစ်စိထဲဟှ သစ်မုဟှို ထုပစ်ပေးဟှို့တွပ် ရှင်းရှင်းလန်းလန်းဟှား ဗြင်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“သန့်ရှင်းဟှူဇာလေဟှို ခွီးလေဟှို ပေးဂေ့န။ အယ်မျိုးလောက်ဆိုဟှာ နန်းနို့ဟှို ကိုက်ဂေ့လေ့မယ်။ ပုလဲလေဟှိုလည်း ဝပ်လေရှေ့မာ ထားဂေ့န။ အယ်မျိုးလောက်မယ် ဆိုဟှာ နန်းနို့လေဟှို ကျော်ဘီးနန်းဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“တောန်းဂေ့။ တောန်းမယ် ဆိုဟှာ ရဂေ့လေ့မယ်။ ရှာဂေ့။ ရှာမယ် ဆိုဟှာ တွိဂေ့လေ့မယ်။ ခွဗော့‑က်ဟှို ခေါ့‑က်ဂေ့။ ခေါ့‑က်မယ် ဆိုဟှာ ဖွမ့်ပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","တောန်းဟှူသူဟှာ ရလေဟှယ်။ ရှာဟှူသူဟှာ တွိလေဟှယ်။ ခွဗော့‑က်ဟှို ခေါ့‑က်ဟှူသူဟှာ ခွဗော့‑က်ဟှို ဖွမ့်ပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","နန်းနို့ရဲ့ သားမီးလေဟှ မုဟှို တောန်းဟှူ ခီမာ က္လော့‑က်ခဲဟှို ပေးမယ့်ဖလေ ရှိဂေ့ဘဲ့လော။ ");
INSERT INTO tvn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ငါးဟှို တောန်းဟှူ ခီမာ ဗွီဟှို ပေးမယ့်ဖလေ ရှိဂေ့ဘဲ့လော။ ");
INSERT INTO tvn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","နန်းနို့လေဟှာ ဆိုးဖြစ်ရဲ့န နန်းနို့ရဲ့ သားမီးလေဟှို ကောန်းဟှူဇာလေဟှိုဘဲ့ ပေးတတ်ဟှယ် ဆိုဟှာ ကောန်းဂန်ဘောင်မာ ရှိတော်မူဟှူ နန်းနို့ရဲ့ ဖလည်း ဆုတောန်းဟှူ သူလေဟှို အယ်ထတ်မက ကောန်းဟှူဇာလေဟှိုဘဲ့ ပိုဘီး ပေးလေ့မယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“နန်းနို့လေဟှို သူများလေဟှ ပြုမူဆစ်ဆံစေရှင်မျိုး သူများလေဟှိုလည်း ပြုမူဆစ်ဆံဂေ့ပါ။ အယ်ပညတ်ဟှ မောရှေရဲ့ ပညတ်တရားကျမ်းန ပရောဖက်ကျမ်းလေရဲ့ ချောက်ခြာ ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“ခွဗော့‑က်ကျဉ်းထဲဟှို ဝမ်ဂေ့ပါ။ ပျစ်စီးရှင်းထဲဟှို ရော့‑က်ဟှူလမ်းန ခွဗော့‑က်ဟှာ ရရာတိုင်း က္လယ်ကြောန့် ဘောင်ဂီးဝမ်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","သတ်ရှင်ရှင်းဟှို ရော့‑က်ဟှူလမ်းန ခွဗော့‑က်ဟှာ ရရာတိုင်း ကျဉ်းဘီး ကြမ်းဟှူကြောန့် တွိဟှူသူလေန ဝမ်ဟှူသူလေဟှာ နဲဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ကော့‑က်ကျစ်ယောက်မာဘီး ကြမ်းထန်းဟှူ ဝံပုလွေလေမျိုး သိုးရေဟှို ခြောင်ဘီးဟှာ နန်းနို့လေနားဟှို လာမယ့် ပရောဖက်တုယောန်လေဟှို ဒိထားဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","သူးနို့လေရဲ့ကျင့်ဟှို ကေ့လိုက်န သူးနို့လေရဲ့ စိသဘောဟှို သိရလေ့မယ်။ ဆူးဗန်ဘောန်းဇောင်မာ စဗျစ်သီးန သန်းဖောသဖန်းသီးဟှို ဆွတ်ယူရနိုင်ဘဲ့လော။ ");
INSERT INTO tvn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","အယ်မျိုးဘဲ့ ကောန်းဟှူသစ်ပန်မာ ကောန်းဟှူသီးဟှို သီးဘီးဟှာ ကောန်းဘဲဟှူပန်မာ ကောန်းဘဲဟှူသီးလေဟှိုဘဲ့ သီးတတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ကောန်းဟှူ သစ်ပန်တဗန်မာ ကောန်းဘဲဟှူသီး၊ ကောန်းဘဲဟှူ သစ်ပန်တဗန်မာ ကောန်းဟှူသီးဟှို သီးနိုင်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ကောန်းဟှူသီး သီးဘဲဟှူ သစ်ပန်လေဟှို ခွတ်လှဲဘီးဟှာ မီးထဲဟှို ပစ်ခ္လတတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","အယ်ကြောန့် အယ်ပရောဖက်တုယောန်လေရဲ့ ကျင့်ဟှို ကေ့လိုက်န သူးနို့လေရဲ့ စိသဘောဟှို သိရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ငါ့ဟှို ‘သခင်၊ သခင်’ ဆိုဘီး ခေါ်ဟှူသူတိုင်း ကောန်းဂန်နိုင်ငံတော်ဟှို ဝမ်ရဟှို့ မှုဟှ။ ကောန်းဂန်ဘောင်မာ ရှိဟှူ ငါ့ဖရဲ့လိုဟှို ဆောန်ဟှူသူဘဲ့ ဝမ်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","တရားစီရင်ဟှူနေ့ ရော့‑က်ဟှူ ခီမာ ‘သခင်၊ သခင်! ကျွန်တော်ဟှားလေဟှာ ကိုယ်တော်ရဲ့ နာမန ပရောဖက်ပြု ဟောပြောဟှယ်။ ကိုယ်တော်ရဲ့ နာမတော်န နတ်ဆိုးလေဟှို နှန်ထုဟှယ်။ ကိုယ်တော်ရဲ့ ခွမ့်အာဏာန အံ့သြဘွယ်တဂိုး နိမိတ်လတ်ခဏာလေဟှို ဘောင်ဂီးပြရဟှယ် မှုဟှလော’ ဆိုဘီးဟှာ လူလေဘောင်ဂီးဟှ လျှော့‑က်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","အယ်ခီမာ ‘နန်းနို့လေဟှို ငါလောင်းဝသိဟှ။ အဓမ္မကောန်လေ၊ ငါ့နားဟှဖယ်ဂေ့!’ ဆိုဘီး သူးနို့လေဟှို ငါပြောမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“အယ်ကြောန့် ငါဟောပြောဟှူ တရားစကားဟှို ကြားဘီး နားထောန်ဟှူသူဟှာ က္လော့‑က်ထတ်မာ အီဆော့‑က်ဟှူ ပညာရှိန တူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","မိုးဝါဟှူကြောန့် ရေစီးလာဟှူန လေလာဘီးဟှာ အယ်အီဟှို ပြင်းပြင်းထန်ထန် တိုက်ဟှူ ခီမာ က္လော့‑က်ထတ်မာ အုပြစ်ခ္လဟှားဟှူကြောန့် ပြိုလဲဘဲန နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“အယ်ဘေမဲ့ ငါစကားဟှို ကြားဘီးဟှာ နားထောန်ဘဲဟှူသူဟှာ သဲထတ်မာ အီဆော့‑က်ဟှူ လူမိုက်န တူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","မိုးဝါဟှူကြောန့် ရေစီးလာဟှူန လေလာဘီးဟှာ အယ်အီဟှို ပြင်းပြင်းထန်ထန် တိုက်ဟှူ ခီမာ ပြိုက္လ ပျစ်စီးဟှားလေဟှယ်!” ဆိုဘီး ဟောပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ယေရှုဟှာ အယ်မျိုးဟောပြောဘီးဟှူ ခီမာ လူလေဟှ ကိုယ်တော်ရဲ့ သွန်သန်ဟှူဇာလေဟှို ရရာတိုင်း အံ့ဩဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကျမ်းတတ်ဆရာလေမျိုးမှုဘဲန ခွမ့်အာဏာရှိဟှူသူမျိုး သွန်သန်ဟှူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ယေရှုဟှာ တောန်ထတ်ဟှနေဘီး ဆင်းလာဟှူ ခီမာ လူအောက်ဂီးဟှာ ကိုယ်တော်နော့‑က်ဟှို လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","အယ်ခီမာ နူနာသယ် တယော့‑က်ဟှာ လာဘီးဟှာ ကိုယ်တော်ရှေ့မာ ပျပ်ဝပ်ဘီး “သခင်၊ လိုတော်ရှိမယ် ဆိုဟှာ ကျွန်တော့်ဟှို အယ်ရောဂါဟှနေ သန့်ရှင်းပေးပါ” ဆိုဘီး တောန်းလျှော့‑က်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ယေရှုဟှလည်း လတ်တော်ဟှို ဆန့်ဘီးဟှာ “ငါလိုရှိဟှယ်။ သန့်ရှင်းစေ!” ဆိုဘီး မိန့်တော်မူဟှယ်။ ရှစ်ရှင်းဘဲ့ နူနာရောဂါဟှာ ပျော့‑က်ဟှားဘီး သူဟှာ သန့်ရှင်းဟှားလေဟှယ် ");
INSERT INTO tvn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ယေရှုဟှ “အယ်ကြောန်းဟှို ဖယ်သူဟှိုလည်း ပြောန။ ဒိထားပါ! ယဇ်ပုရောဟိတ်နားဟှို သွားဘီး ကိုယ်ဟှိုပြလိုက်ပါ။ လူလေရှေ့မာ သတ်သေဖြစ်ဟှို့တွပ် မောရှေပညတ်ဟှားဟှူတိုင်း ပူဇော်သကာဟှို ဆစ်သပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ယေရှုဟှာ ကပေရနောင်ဗြို့ဟှို ဝမ်လာဟှူ ခီမာ ရောမတပ်မှူးတယော့‑က်ဟှ ကိုယ်တော်နားဟှို လာဘီး တောန်းဗန်ဇာဟှ ");
INSERT INTO tvn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“သခင်၊ ကျွန်တော်ရဲ့ စေခံတယော့‑က်ဟှာ လတ်ခေသေဟှူရောဂါန ရရာတိုင်း နာကျင်ဘီးဟှာ အီမာ ထနိုင်ဘဲ ဖြစ်နေပါဟှယ်။ ကယ်မတော်မူပါ” ဆိုဘီး ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ယေရှုဟှ “ငါလာဘီးဟှာ ရောဂါဟှို ပျော့‑က်ကင်းစေမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","တပ်မှူးဟှ “သခင်၊ ကျွန်တော်ရဲ့ အီးခေါန်မိုးအော့‑က်ဟှို ကိုယ်တော်ဝမ်ရှင်း ကျေးဇူးဟှို ကျွန်တော်ခံထိုက်ဟှ။ မိန့်ပေးလိုက်န ကျွန်တော်ရဲ့ စေခံဟှာ ကျန်းမာရပါလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ဥပမာ ကျွန်တော် ကိုယ်တိုင်လည်း အာဏာပိုင် လတ်အော့‑က်မာ ရာရှိတယော့‑က်ဖြစ်ဘီး ကျွန်တော်ရဲ့ လတ်အော့‑က်မာရှိဟှူ စစ်သားလေဟှို အောက်ချောက်ရပါဟှယ်။ တယော့‑က်ဟှို ‘သွား!’ ဆိုဟှာ သွားပါဟှယ်။ တယော့‑က်ဟှို ‘လာ!’ ဆိုဟှာ လာပါဟှယ်။ အယ်ဘီးဟှာ ကျွန်တော်ဟှာ ကျွန်တော့်ရဲ့ ကျွန်ဟှို မိန့်ပေးလိုက်ဟှယ် ‘အယ်မူဇာဟှို လောက်လိုက်!’ ဆိုဟှာ လောက်လေဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","အယ်စကားဟှို ယေရှုကြားဟှူ ခီမာ အံ့ဩဟှားဘီး “ငါ မှန်ပြောမယ်၊ အယ်မျှလော့‑က်ကီးဟှူ ယောင်ကြည်ရှင်းမျိုး ဣသရေလ လူမျိုးထဲမှာဟှို ငါတွိဖူးဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ငါပြောမယ်။ လူလေဘောင်ဂီးဟှာ ရှေ့ရပ်၊ နော့‑က်ရပ်ဟှလာဘီး ကောန်းဂန်နိုင်ငံတော်မာ အာဗြဟံ၊ ဣဇာက်၊ ယာကုပ်လေနတူးဒူ စားသော့‑က်ဗွဲမာ လာဘီးထိုင်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","အယ်ဘေမဲ့ နိုင်ငံတော်သားလေလည်း ငိုကြွေးဘီး အံသွားခဲက္လိဟှူ နေရာ ပ္လန်ရပ် မှောန်မိုက်ထဲမာ နေရလေ့မယ်” ဆိုဘီး တဗဲ့တော်လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","အယ်ဘီးမှ ယေရှုဟှ “နန်သွားဝေါ့။ နန်ယောင်ကြည်တိုင်း ဖြစ်လေ့မယ်” ဆိုဘီး ပြောလိုက်ခီမာဘဲ့ တပ်မှူးရဲ့စေခံလည်း ရောဂါပျော့‑က်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ယေရှုဟှာ ပေတရုရဲ့အီဟှို ရော့‑က်ဟှားဟှူ ခီမာ ပေတရုရဲ့ ယောက္ခမဟှာ ဖျားနာဘီး အိယာထဲမာလဲနေဇာဟှို ဗြင်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ယေရှုဟှလည်း အယ်မီးမရဲ့ လတ်ဟှို တို့ထိလိုက်ဟှူ ခီမာ ဖျားနာပျော့‑က်ဟှားကြောန့် ထထိုင်ဘီးဟှာ ဧည့်ဝတ်ပြုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","နေဒန်ဇာဟှို ရော့‑က်ဟှူ ခီမာ နတ်ဆိုး ဝမ်ပူးခံရဟှူ လူလေဟှို ယေရှုနားဟှို ခေါ်လာဂေ့လေဟှယ်။ ယေရှုဟှ စကားတခွန်းဒဲန မိန့်ပေးဘီးဟှာ နတ်ဆိုးလေဟှို နှန်ထုလိုက်ဟှူ ခီမာ လူနာလေလည်း ကျန်းမာသွားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","အယ်မူကြောန်းရာဟှ “အယ်သူဟှာ နို့လေရဲ့ ရောဂါန ဝေဒနာလေဟှို ယူဆောန်ဟှားလေဟှယ်” ဆိုဘီး ပရောဖက် ဟေရှာယ ပြောဟှားတိုင်းဘဲ့ ပ္လဲ့ဇောင်လာဟှို့တွပ် ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ယေရှုဟှာ သူ့နားပတ်လည်မာ လူအောက်ဂီး ဝိုင်းနေဂေ့ဇာဟှို ဗြင်ရဟှူ ခီမာ အိုင်ဟှို့ဖတ်ကမ်းဟှို ကူးဟှို့တွပ် တဗဲ့တော်လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","အယ်ခီမာ ကျမ်းပြုဆရာတယော့‑က် လာဘီးဟှာ “ဆရာ၊ ကိုယ်တော်သွားမယ့် နေရာလေဟှို ကျွန်တော်လည်း လိုက်ရှင်ပါဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ယေရှုဟှလည်း “မ္လေခွီးမာ တွမ်းရှိဟှယ်။ ကောန်းဂန်ဟှ ငှတ်မာလည်း သိုက်ရှိဟှယ်။ လူ့ရဲ့သားမာဟှ ခေါန်းခ္လဟှို့တွပ် နေရာ မှေ့ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","တခြားတဗဲ့တော် တယော့‑က်ဟှလည်း “သခင်၊ ကျွန်တော့်ဖဟှို ရင်ဦးဆောင်း သွားဘီးသင်္ဂြိုဟ်ဟှို့တွပ် ခွမ့်ပေးပါ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ယေရှုဟှလည်း “ငါ့နော့‑က်ဟှိုလိုက်ပါ။ လူသေလေဟှို လူသေလေဘဲ့ သင်္ဂြိုဟ်ပါစေ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ယေရှုဟှာ လှေထဲဟှို ဝမ်တော်မူဘီး တဗဲ့တော်လေလည်း ကိုယ်တော်နတူးဒူ လိုက်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ရောက်တရစ် အိုင်ထဲမာ ကြမ်းတမ်းဟှူ လေမှောန်ဒိုင်းတိုက်လာဘီး လှေဟှာ နစ်မ္လောက်ခါနီး ဖြစ်ဟှားလေဟှယ်။ အယ်ခီမာ ကိုယ်တော်ဟှ လှေထဲမာ အိနေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","တဗဲ့တော်လေလည်း ကိုယ်တော့်ဟှို နှိုးဘီးဟှာ “သခင်၊ ကယ်တန်တော်မူပါ! ကျွန်တော့်ဟှားလေ သေဟှို့ဖြစ်နေဂေ့ဘီ!” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ကိုယ်တော်ဟှလည်း “ယောင်ကြည်ရှင်း အားနဲဟှူလူလေ! ဖြားဖြစ်ကြောန့် ကြော့‑က်နေဂေ့နူး” ဆိုဘီး ထလာဘီးန လေနလှိုင်းဟှို ဆောင်းမဟှူ ခီမာ လေနလှိုင်းလည်း ငြီဟှားဘီး သာယာဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","တဗဲ့တော်လေလည်း ရရာတိုင်း အံ့ဩဘီး “အယ်လူဟှ ဖယ်သူနူး။ လေနလှိုင်းလေတောန်မှ သူ့ဟှို နားထောန်ဂေ့ဟှယ်!” ဆိုဘီး ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","အိုင်ဟှို့ဖတ်ကမ်း ဂါဒရပြည်ဟှို ရော့‑က်ဟှူ ခီမာ နတ်ဆိုးဝမ်ပူးနေဟှူ လူနှေ့ယော့‑က်ဟှာ သန်းခ္လိုင်းထဲဟှနေ ထွပ်လာဘီး ကိုယ်တော်န ဆောင်တွိလေဟှယ်။ အယ်သူလေဟှာ ရာရာတိုင်း ခွန်အားကီးဘီး ဆိုးသွန်းဂေ့ကြောန့် ဖယ်သူလေလည်း အယ်လမ်းဟှနေဘီး သွားဟှိရဲဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","အယ်သူလေဟှလည်း “ဘုရားသခင်ရဲ့ သားတော်၊ ကျွန်တော်ဟှားလေဟှို ဖြားလောက်ရှင်ကြောန့်နူး။ ခီရော့‑က်ခန်မာ ညှဉ်းဆဲဟှို့တွပ် ကြွလာဟှူဇာလော” ဆိုဘီးဟှာ သံက္လယ်ဂီးန လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","အယ်သူလေရဲ့ လော့က်ဂီးဝီးဘဲဟှူ နေရာမာလည်း ဝပ်အောက်ဂီးဟှာ စာစားနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","နတ်ဆိုးလေဟှလည်း “ကျွန်တော်ဟှားလေဟှို နှန်ထုမယ် ဆိုဟှာ အယ်ဝပ်လေထဲဟှို ဝမ်ခွမ့်ပေးတော်မူပါ” ဆိုဘီး ယေရှုဟှို တောန်းဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ကိုယ်တော်ဟှလည်း “သွားဂေ့” ဆိုဘီး မိန့်တော်မူဟှယ်။ နတ်ဆိုးလေလည်း ထွပ်ဟှားဘီးဟှာ ဝပ်လေထဲဟှို ဝမ်ဟှားဟှယ်။ ဝပ်အောက်ဂီးဟှာ အိုင်ကမ်းနားဟှို ပ္လေးဆင်းဟှားဘီး ရေမ္လောက်သေဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ဝပ်ထီးမားလေလည်း ဗြို့ထဲဟှို ဝမ်ပ္လေးဘီးဟှာ နတ်ဆိုးဝမ်ပူးနေဟှူ လူနှေ့ယော့‑က်ကြောန်းန သူးနို့လေဗြင်တွိရဟှူ ကြောန်းရာလေ ဂူလောင်းဟှို ပြောပြဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","အယ်ဘီးန တဗြို့လောင်းမာရှိဟှူ လူလေလည်း ယေရှုဟှို တွိရှင်ကြောန့် ဗြို့ပ္လန်ဟှို ထွပ်လာဂေ့ဟှယ်။ ကိုယ်တော့်ဟှို တွိဟှူ ခီမာ သူးနို့လေရဲ့ ဒေသဟှနေဘီး ထွပ်ဟှားဟှို့တွပ် တောန်းဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ယေရှုဟှာ လှေနပ္လန်ကူးဘီးဟှာ သူ့ရဲ့ နေရပ်ဗြို့ဟှို ကြွတော်မူလေဟှယ်၊ ");
INSERT INTO tvn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","အယ်နေရာမာ လေဖြတ်နေဟှူ လူတယော့‑က်ဟှို ထမ်းစင်ထတ်မာ တန်ဘီးဟှာ ကိုယ်တော်နားဟှို ထမ်းလာဂေ့လေဟှယ်။ ယေရှုဟှာ အယ်သူလေရဲ့ ယောင်ကြည်ရှင်းဟှို ဗြင်ရဟှူ ခီမာ လေဖြတ်နေဟှူသူဟှို “ငါ့သား၊ စိုးရိမ်န! နန့်ရဲ့ ပြစ်ဟှို ငါလွတ်စေဘီ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ကျမ်းပြုဆရာတချို့ဟှ “အယ်သူဟှာ ဘုရားသခင်ဟှို ပြစ်မှားစော်ကားဘီး ပြောနေဟှယ်!” ဆိုဘီးဟှာ သူးနို့ရှင်းရှင်း ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ယေရှုဟှာ အယ်သူလေရဲ့ စိဟှို သိနေကြောန့် “နန်းနို့လေ ဖြားဖြစ်ကြောန့် ကောန်းဘဲဟှူဇာလေဟှို စဉ်းစားနေဂေ့နူး။ ");
INSERT INTO tvn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘နန့်ရဲ့ ပြစ်ဟှို လွတ်စေဘီ’ အယ်မျိုးမှုဘဲနေဟှာ ‘နန်ထဘီးဟှာ လမ်းသွားဝေါ့’ ဆိုဘီး ပြောဟှို့ပိုလွယ်ကြောန့်လော။ ");
INSERT INTO tvn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","လူ့ရဲ့သားဟှာ အယ်လောကမာ ပြစ်ဖြေလွှတ်ဟှို့ ခွမ့်အာဏာရှိဟှယ် ဆိုဇာဟှို နန်းနို့လေသိရအောန်” လေဖြတ်နေသူဟှို “ထဒန်၊ ထမ်းစင်ဟှို ကော့‑က်ဘီး နန့်အီဟှို သွားဝေါ့!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","အယ်သူဟှာ ထဘီး သူ့အီဟှို သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","အယ်မူဇာလေဟှို ကေ့နေဂေ့ဟှူ လူအောက်ဂီးဟှာ ရရာတိုင်း ကြော့‑က်ရွံ့ဘီးဟှာ လူလေဟှို အယ်မျိုးခွမ့်အာဏာဟှို ပေးတော်မူဟှူ ဘုရားသခင်ရဲ့ ဂေါင်တော်ဟှို ချီးမွမ်းဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ယေရှုဟှာ အယ်နေရာဟှနေဘီး ထွပ်ကြွလာဟှူ ခီမာ မဿဲ ဆိုဘီး နာမယ်ခေါ်ဟှူ လူတယော့‑က်ဟှို ခွန်ရောင်းမာ ထိုင်နေဇာဟှို ဗြင်တော်မူလေဟှယ်။ ကိုယ်တော်ဟှ “ငါ့နော့‑က်ဟှိုလိုက်ပါ” ဆိုဘီး မိန့်တော်မူဟှယ်။ မဿဲဟှာ ထဘီး နော့‑က်ဟှိုလိုက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ယေရှုဟှာ မဿဲရဲ့အီမာ ညဉ့်ခန်းဇာစားနေခီမာ ခွန်ကော့‑က်မားလေန ပြစ်သားလေဟှာ ကိုယ်တော်နားဟှို လာဘီး တဗဲ့တော်လေနတူးဒူ မှန်းဗွဲမာ ဝမ်ထိုင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","အယ်ဇာဟှို ဖာရိရှဲလေ တချို့ဟှ ဗြင်ဟှားဘီး တဗဲ့တော်လေဟှို “ဖြားဖြစ်ကြောန့် နန်းနို့ဆရာဟှာ ခွန်ကော့‑က်မားလေ၊ ပြစ်သားလေနတူးဒူ စားနေနူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ယေရှုကြားဟှူ ခီမာ “ကျန်းမာဟှူသူလေဟှာ ဆေးဆရာဟှို လိုဂေ့ဟှ။ ဖျားနာဟှူသူလေဟှဘဲ့ လိုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","‘ငါဟှာ ယဇ်ပူဇော်ဇာထတ် သနားကြင်နာရှင်းဟှို ပိုဘီး နှစ်သက်ဟှယ်’ ဆိုဘီး ပြောဟှားဟှူကျမ်းစကားဟှို နားလည်ဟှို့ သွားဘီးသန်ယူဂေ့ပါ။ ဖြောန့်မတ်ဟှူသူလေဟှို ကယ်ဟှို့တွပ် ငါလာဇာ မှုဟှ။ ဆိုးဟှူလူလေဟှို ကယ်ဟှို့တွပ် ငါလာဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","အယ်ခီမာ ယောဟန်ရဲ့ တဗဲ့လေဟှာ ယေရှုနားဟှို ရော့‑က်လာဘီးဟှာ “ကျွန်တော်ဟှားလေန ဖာရိရှဲလေဟှာ မကြာမကြာ စာရှောန်ဂေ့ဟှယ်။ ကိုယ်တော်ရဲ့တဗဲ့လေဟှာ ဖြားဖြစ်ကြောန့် စာရှောန်ဂေ့ဟှနူး” ဆိုဘီး မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ယေရှုဟှ “အီတတ်ဗွဲမာ ဒို့သားနတူးဒူ ရှိနေဟှူ ပေါန်းသင်းလေဟှာ ဒို့သားနတူးဒူ ရှိနေခီမာ ဝန်းနဲပူဆွေးဂေ့ဘဲ့လော။ မင်္ဂလာဆောန်ဒို့သားန သူ့ပေါန်းသင်းလေဟှာ ခွဲခွာရဟှို့ခီ ရော့‑က်လာလေ့မယ် အယ်ဆိုဟှာ သူးနို့လေဟှာ စာရှောန်ဂေ့လေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“ဖယ်သူလည်း အန်းဂီဟောန်းဟှို ပိစသစ်န ဖာလေ့ မှေ့ဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဖာဟှားဟှူ ပိစသစ်ဟှ အန်းဂီဟောန်းဟှို စုဖ္လဲဘီးဟှာ ပိုဆိုးဟှားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","အယ်မျိုးဘဲ့ ဝိုင်သစ်ဟှို သားရေဖူးဟောန်းထဲမာ ထဲ့လေ့ မှေ့ဟှ။ ထဲ့မယ် ဆိုဟှာ ဝိုင်သစ်ဟှ သားရေဖူးဟောန်းဟှို ပေါ့‑က်ပ္လဲစေဘီး ဝိုင်န သားရေဖူး နှေ့ခုလောင်းဟှာ ပျစ်စီးဟှားလေ့မယ်။ အယ်ဘီးဟှာ သရေဖူးလည်း ပျစ်စီးဟှားလေ့မယ်။ အယ်မျိုး ဖြစ်ဘဲနေအောန် ဝိုင်သစ်ဟှို သားရေဖူးသစ်ထဲဟှို ထည့်ရဟှယ်။ အယ်ဆိုဟှာ နှေ့ခုလောင်းဟှာ ကြာဂီးခံလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ယေရှုဟှာ အယ်မျိုး ပြောနေခီမာ ယုဒလူမျိုး ရာရှိတယော့‑က်ဟှ ရော့‑က်လာဘီးဟှာ ကိုယ်တော်ရှေ့မာ ပျပ်ဝပ်လေဟှယ်။ အယ်သူဟှလည်း “ကျွန်တော့်သမီးဟှာ သေဟှားဘီ။ အယ်ဘေမဲ့ ကိုယ်တော်ကြွဘီး သူ့ထတ်မာ လတ်တန်မယ် ဆိုဟှာ သတ်ရှင်ပါလေ့မယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","အယ်ကြောန့် ယေရှုဟှာ ထဘီးဟှာ တဗဲ့တော်လေနတူးဒူ အယ်သူနော့‑က်ဟှို လိုက်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ဆယ့်နှေ့နှစ် လောင်းလောင်း သွီးသွန်နာစွဲနေဟှူ မီးမတယော့‑က်ဟှာ ယေရှုနော့‑က်ဟှို လိုက်ဘီး ဝတ်လောင်တော် ပန်းဗွားဟှို တို့ထိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","အယ်မီးမဟှာ “ငါဟှာ သူ့ရဲ့ ဝတ်လောင်တော်ဟှို တို့ထိမယ် ဆိုဟှာ ငါကျန်းမာရလေ့မယ်” ဆိုဘီးဟှာ ကိုယ့်ကိုယ်ကိုယ် ပြောနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ယေရှုဟှ လှည့်ကေ့ခီမာ အယ်မီးမဟှို ဗြင်ဟှားဘီး “ငါ့သမီး၊ စိုးရိမ်န! နန့်ရဲ့ ယောင်ကြည်ရှင်းဟှာ နန့်ဟှို ကျန်းမာစေဘီ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်ခီမာဘဲ့ အယ်မီးမဟှာ ရောဂါပျော့‑က်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","အယ်ဘီးန ယေရှုဟှာ ရာရှိရဲ့အီဟှို ရော့‑က်ဟှားလေဟှယ်။ ကိုယ်တော်ဟှာ တီးမှုမားလေန မသာအီဟှို လာဟှူသူလေ အောက်အောက်သဲသဲ ဖြစ်နေဂေ့ဇာဟှို ဗြင်တော်မူဟှူ ခီမာ ");
INSERT INTO tvn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ကိုယ်တော်ဟှ “ဖယ်ဂေ့၊ မီးမငယ် သေနေဇာ မှုဟှ! အိမွိနေဇာဖြစ်ဟှယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ လူလေ ဂူလောင်းဟှာ ကိုယ်တော့်ဟှို သရော်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","လူအောက်ဂီးဟှာ ပ္လန်ဟှိုထွပ်ဟှားဘီးန ယေရှုဟှာ မီးမငယ်ရဲ့ အိခန်းထဲဟှို ဝမ်ဘီး မီးမငယ်ရဲ့လတ်ဟှို ဆွဲထူလိုက်ဟှူ ခီမာ မီးမငယ်ဟှာ ထလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","အယ်မူဒန်းဟှာ အယ်ဒေသ တခုလောင်းဟှို ပ္လံ့နှံ့ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","အယ်ရပ်ဟှနေဘီး ယေရှုကြွဟှားဟှူ ခီမာ မျစ်စိဗြင်ဘဲဟှူ လူနှေ့ယော့‑က်ဟှ ကိုယ်တော်နော့‑က်ဟှို လိုက်ဘီးဟှာ “ဒါဝိဒ်ရဲ့ သားတော်! ကျွန်တော်ဟှားလေဟှို သနားတော်မူပါ” ဆိုဘီး အော်ဟစ်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","အီတအီဟှို ဝမ်ခီမာ မျစ်စိကန်းနေသူလေဟှာ ယေရှုနားဟှို လာဂေ့လေဟှယ်။ ကိုယ်တော်ဟှလည်း “နန်းနို့မျစ်စိဟှို ငါဗြင်စေနိုင်ဟှယ် ဆိုဇာဟှို ယောင်ဘဲ့လော” ဆိုဘီး မေးလိုက်ဇာ “ယောင်ကြည်ပါဟှယ် သခင်!” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ယေရှုဟှာ သူးနို့လေရဲ့ မျစ်စိဟှို တို့ဘီးဟှာ “နန်းနို့ယောင်ကြည်ဟှူတိုင်း နန်းနို့မာဖြစ်စေ!” ဆိုဘီး မိန့်တော်မူဘီးန၊ ");
INSERT INTO tvn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","အယ်သူလေဟှာ မျစ်စိပွမ့်လန်းလာဘီးဟှာ ဗြင်ရဂေ့လေဟှယ်။ ယေရှုဟှ “အယ်ကြောန်းရာလေဟှို ဖယ်သူဟှိုလည်း သိစေန!” ဆိုဘီး ကျပ်ကျပ်တဲတဲဟှား ဒိပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","အယ်ဘေမဲ့ သူးနို့လေ ထွပ်ဟှားဘီးဟှာ ယေရှုရဲ့ဒန်းဟှာ တပြည်လောင်းဟှို ပ္လံ့နှံ့ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","အယ်သူလေထွပ်ဟှားဘီးန နတ်ဆိုးဝမ်ဘီး စကားအနေဟှူ လူတယော့‑က်ဟှို ယေရှုနားဟှို ခေါ်လာဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","နတ်ဆိုးဟှို နှန်ထုလိုက်ဟှူ ခီမာ စကားအ,နေဟှူ သူဟှာ စကားပြောလေဟှယ်။ လူလေ ဂူလောင်းဟှာ အံ့ဩဟှားဂေ့ဟှယ်။ “အယ်မျိုးမှုရာလေဟှို ဣသရေလ လူမျိုးထဲမာ ခါလည်းဗြင်ဖူးဟှ!” ဆိုဘီး ပြောဆိုဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ဖာရိရှဲလေဟှလည်း “အယ်သူဟှာ နတ်ဆိုးခေါန်းဆောန် ဗေလဇေဗုလဟှို အားကိုးဘီး နတ်ဆိုးလေဟှို နှန်ထုဇာဖြစ်ဟှယ်” ဆိုဘီး ပြောဆိုဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ယေရှုဟှာ ဝါလယ်ဇရပ်လေမာ ဆောင်းမဩဝါဒပေးဘီး နိုင်ငံတော်ကြောန်း ဒန်းကောန်းဟှို ကြေညာတော်မူလေဟှယ်။ လူလေခံစားနေရဟှူ ရောဂါလေဟှိုလည်း ကျန်းမာစေဘီးဟှာ ဗြို့ဝါလေဟှို လှည့်လည်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ကိုယ်တော်ဟှာ လူအောက်ဂီးဟှို ဗြင်လိုက်န သနားဟှူစိ ဖြစ်လေဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့ဟှာ သိုးထီးမားမှေ့ဘဲဟှူ သိုးလေမျိုး ပူပန်သောကရော့‑က်ဘီး အားကိုးရာမှေ့ဘဲ ဖြစ်နေဂေ့ကြောန့်ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","အယ်ကြောန့် ကိုယ်တော်ဟှာ “ရိသီးဇာလေ ဘောင်ဂီးရှိဘေမဲ့ ရိသီးမားလေဟှာ နဲဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","အယ်ကြောန့် ရိသီးမားလေဟှို စေလွှတ်ပေးဟှို့တွပ် ဗားဇရှင်ဟှို ဆုတောန်းဂေ့” ဆိုဘီး တဗဲ့တော်လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ယေရှုဟှာ တဗဲ့တော် ဆယ့်နှေ့ပါးဟှို ခေါ်ဘီးဟှာ ညစ်ညူးဟှူနတ်လေဟှို နှန်ထုဟှို့တွပ်န ရောဂါဘောင်းဇောင်ဟှို ပျော့‑က်ကင်းစေဟှို့တွပ် ခွမ့်တဂိုးအာဏာဟှို ပေးအပ်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","တမန်တော်ဆယ့်နှေ့ပါးရဲ့ နာမယ်လေဟှာ ပေတရု ဆိုဘီးခေါ်ဟှူ ရှိမုန်န သူ့ညီ အန္ဒြေ၊ ဇေဗေဒဲရဲ့သား ယာကုပ်န သူ့ညီကို ယောဟန်၊ ");
INSERT INTO tvn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ဖိလိပ္ပုန ဗာသောလမဲ၊ သောမန အခွန်ကော့‑က်မား မဿဲ၊ အာလဖဲရဲ့သား ယာကုပ်န သဒ္ဒဲ၊ ");
INSERT INTO tvn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","မျိုးရှစ်စိအားထတ်သန်ဟှူ ရှိမုန်န ယေရှုဟှို သစ်စာဖော့‑က်ဟှူ ယုဒရှကာရုတ် ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ဆယ့်နှေ့ပါးဟှို ယေရှုဟှာ စေလွှတ်လိုက်ဘီး မိန့်မှာလိုက်ဇာဟှ “လူမျိုးခြားဒေသန ရှမာရိဗြို့လေဟှို သွားဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ဣသရေလလူမျိုးရဲ့ ပျော့‑က်နေဟှူ သိုးလေနားဟှိုဘဲ့ ရင်ဦးဆောင်းသွားဂေ့ပါ။” ");
INSERT INTO tvn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“သွားဘီးဟှာ ‘ကောန်းဂန်နိုင်ငံတော် တည်ထောန်ဟှို့နီးဘီ!’ ဆိုဘီး ဟောပြောဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","လူနာလေဟှို ကျန်းမာစေပါ။ လူသေလေဟှို ပ္လန်ရှင်စေဂေ့ပါ။ နူနာသယ်လေဟှို သန့်ရှင်းစေဂေ့ပါ။ နတ်ဆိုးလေဟှိုလည်း နှန်ထုဂေ့ပါ။ နန်းနို့လေဟှာ ဖိုးခပေးရဘဲန လတ်ခံရရှိဟှူမျိုး ဖိုးခယူဘဲန ပေးကမ်းဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","နန်းနို့ရဲ့ ခါးဗတ်ထဲမာ ရွှေ၊ ငွေ၊ ကြေးဒန်းဂါးလေဟှို ထည့်သွားဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ခရီးတွပ် လွယ်အိ၊ အန်းဂီပို၊ ခေနပ်န တောန်အူးဟှိုလည်း ယူဆောန်ဂေ့န။ လောက်လောက်ဟှူ သူဟှာ ကျွေးမွေးဇာဟှို ရထိုက်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“ဗြို့တဗြို့၊ ဝါတဝါဟှို ဝမ်ဟှူ ခီမာ နန်းနို့ဟှို ကြိုဆိုဟှူ သူဟှို ရှာဘီး အယ်နေရာဟှ နန်းနို့လေ ထွပ်ဟှားခန်ခီထိ သူးနို့နတူးဒူနေဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","နန်းနို့လေ အီထဲဟှို ဝမ်ဟှားခီမာ ‘နန်းနို့နတူးဒူ ငြီသတ်မှုရှိပါစေ’ ဆိုဘီး နှောက်ဆစ်ဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","အယ်အီမာရှိဟှူ လူလေဟှာ နန်းနို့ဟှို လတ်ခံကြိုဆိုဟှယ် ဆိုဟှာ နန်းနို့လေ နှော့‑က်ဆစ်ဟှူ ငြီသတ်မှုဟှာ ကျန်ရစ်ပါစေ။ အယ်ဘေမဲ့ နန်းနို့ဟှို လတ်ခံဂေ့ဘဲနေဟှယ် ဆိုဟှာ နန်းနို့နားဟှို ပ္လန်လာစေ။ ");
INSERT INTO tvn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","တယော့‑က်ယော့‑က်ဟှ နန်းနို့လေဟှို လတ်ခံဟှ ဆိုဟှာ နန်းနို့စကားဟှို နားထောန်ဂေ့ဘဲနေဟှယ် ဆိုဟှာ အယ်အီဟှ ထွပ်ဟှားဟှူ ခီမာ နန်းနို့ခေဖွားဟှ မ္လေမုဟှို ခါခ္လလိုက်ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ငါ မှန်ပြောမယ်၊ တရားစီရင်ဟှူ နေ့မာ ဘုရားသခင်ဟှာ အယ်ဗြို့ထတ် သောဒုံဗြို့န ဂေါမောရဗြို့ဟှို ပိုဘီး ကရုဏာတော်ဟှို ပြသလေ့မယ်!” ");
INSERT INTO tvn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“နားထောန်ဂေ့! ဝံပုလွေအောက်ထဲဟှို သိုးလေဟှို လွှတ်ဟှူမျိုး နန်းနို့လေဟှို ငါစေလွှတ်မယ်။ အယ်ကြောန့် ဗွီမျိုးလီမာဘီး ချိုးငှတ်မျိုး ဖ္လူစင်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","လူလေဟှို ဒိထားဘီးနေဂေ့ပါ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်းနို့လေဟှို ဖမ်းဆီးဘီးဟှာ တရားရောင်းဟှို အပ်လေ့မယ်။ ဝါလယ်ဇရပ်လေမာ ရိုက်ခံရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","အယ်သူလေန လူမျိုးခြားလေရှေ့မာ သတ်သေဖြစ်ဟှို့တွပ် ဗြို့ဝန်မန်းလေန မန်းဂီးလေ ရှေ့ဟှို ငါ့ကြောန့် နန်းနို့ဟှို စစ်ဆေးဟှို့ ခေါ်ဆောန်ဟှားဇာ ခံရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","နန်းနို့ဟှို စစ်ဆေးဟှို့ ခေါ်ဟှားခီမာ ဖယ်မျိုးပြောရဟှို့ ဆိုဘီး စိုးရိမ်ဂေ့န။ အယ်ခီမာ နန်းနို့ပြောရဟှို့စကားဟှို ရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်းနို့လေဟှာ ကိုယ့်ကိုယ်ကိုယ် ပြောနေဇာ မှုဟှ။ နန်းနို့ဖ ဘုရားသခင်ရဲ့ ဝိညာဉ်တော်ဟှာ နန်းနို့အားဖြင့် ပြောတော်မူလေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“လူလေဟှာ သူးနို့ရဲ့ ညီကိုရှင်းရှင်း သေစေဟှို့တွပ် အပ်ဂေ့လေ့မယ်။ ဖလေဟှလည်း သားလေဟှို အပ်လေ့မယ်။ သားမီးလေလည်း သူးနို့ရဲ့ မိဖလေဟှို ရန်ပြုဘီးဟှာ သတ်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","လူလေဟှလည်း ငါ့နာမကြောန့် နန်းနို့လေဟှို မူးတီးဂေ့လေ့မယ်။ အယ်ဘေမဲ့ ငါ့နာမဟှို ဆောင်းထိ ဆွဲကိုင်ဟှူသူဟှာ ကယ်တန်ရှင်းဟှို ခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ဗြို့တဗြို့မာ နန်းနို့ဟှာ ညှဉ်းဆဲခံရဟှူ ခီမာ တခြားဗြို့ဟှို ထွပ်ပ္လေးဂေ့ပါ။ ငါ မှန်ပြောမယ်၊ ဣသရေလ ဗြို့လေ ဂူလောင်းဟှို သွားလာဟှို့ ပီးခန်မာ လူ့ရဲ့သားဟှာ ကြွလာလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“တဗဲ့လည်း ဆရာထတ် သာဟှ။ ကျွန်လည်း သခင်ထတ်သာဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","တဗဲ့လည်း ဆရာဟှူမျိုး၊ ကျွန်လည်း သခင်ဟှူမျိုး ဖြစ်ဟှယ် ဆိုဟှာ ရလော့‑က်ဘီ။ အီးထောန်ဦးစီးဟှို ဗေလဇေဗုလ ဆိုဘီး ခေါ်ခံရဟှယ် ဆိုဟှာ အီသူအီသားလေဟှို ပိုဘီး ခေါ်ဂေ့လေ့မယ်!” ");
INSERT INTO tvn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“အယ်ကြောန့် သူးနို့လေဟှို ကြော့‑က်ဂေ့န။ ဖောင်းဟှားဟှူ ဇာလေ ဂူလောင်း ပေါ်လာလေ့မယ်။ ဝှပ်ဟှားဇာလေ ဂူလောင်းဟှာလည်း ထန်ရှားလာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","မှောန်ထဲမာ နန်းနို့ဟှို ငါပြောဟှူ စကားလေဟှို လန်းရောန်ထဲမာ နန်းနို့လေ ကြေညာဂေ့ပါ။ နန်းနို့ရဲ့ နားနားမာ တိုးတိုးဟှားကြားဟှူ စကားလေဟှို အီးခေါန်မိုးထတ်မာ အော်ဘီးကြေညာဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ကိုယ်ခန္ဓာဟှိုဘဲ့ သတ်နိုင်ဘီးဟှာ သတ်ဝိညာဉ်ဟှို သတ်နိုင်ဂေ့ဘဲသူလေဟှို ကြော့‑က်ဂေ့န။ ကိုယ်ခန္ဓာန သတ်ဝိညာဉ်ဟှို ငရဲမာ ဖျစ်ဆီးနိုင်သူဟှိုဘဲ့ ကြော့‑က်ဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","အီးဇာဟှား နှေ့ကောန်ဟှို ပဲနီတပ္လားန ရောန်းဟှယ်မှုဟှလော။ နန်းနို့ဖရဲ့ ခွမ့်မှေ့ဘဲနေဟှာ အယ်မူအီးဇာဟှားလေ တကောန်လည်းဘဲ့ မ္လေထတ်ဟှို က္လဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","နန်းနို့ခေါင်းထတ်ဟှ ဆားဗန်လေ ဂူလောင်းဟှိုလည်း ရေတွပ်ဘီးသား ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","အယ်ကြောန့် ကြော့‑က်ဂေ့န! နန်းနို့လေဟှာ အီးဇာဟှားလေထတ် ရရာတိုင်း ဖိုးကီးဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ဖယ်သူဘဲ့ဖြစ်ဖြစ် လူလေရှေ့မာ ငါ့ဟှို ကယ်တန်ရှင် သခင်နေန ဝန်ခံလေဟှယ်။ ကောန်းဂန်ဘောင်မာ ရှိတော်မူဟှူ ငါ့ဖရှေ့မာ အယ်သူဟှို ငါဝန်ခံမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","အယ်ဘေမဲ့ လူလေရှေ့မာ ငါ့ဟှို ငြင်းပယ်ဟှယ် ဆိုဟှာ ကောန်းဂန်ဘောင်မာရှိဟှူ ငါ့ဖရှေ့မာ အယ်သူဟှို ငါငြင်းပယ်မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“အယ်လောကဟှို ငြီသတ်ရှင်းပေးဟှို့တွပ် ငါလာဟှယ် ဆိုဘီး ထန်ဂေ့န။ ငြီသတ်ရှင်းပေးဟှို့ လာဟှူဇာ မှုဟှ။ အယ်ဘေမဲ့ ရှင်းရှင်းကွဲပြားဟှို့တွပ် ငါလာဟှူဇာ ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ဖနသား၊ မိနမီး၊ ယောက္ခမန ချွေးမလေ ရှင်းရှင်း စိဝန်းကွဲစေဟှို့တွပ် ငါလာဇာဖြစ်ဟှူကြောန့် ");
INSERT INTO tvn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","နန်းနို့ရဲ့ အီသူအီသားလေလည်း နန်းနို့ရဲ့ ရန်သူလေ ဖြစ်လာလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ယော့‑က်ယော့‑က်ဟှာ ငါ့ထတ် သူးနို့ရဲ့ မိဖဟှို ပိုဘီး ရှစ်လေဟှယ်။ အယ်သူဟှာ ငါ့နထိုက်တန်ဟှ။ ယော့‑က်ယော့‑က်ဟှာ ငါ့ဟှို ရှစ်ဟှူထတ် သားမီးလေဟှို ပိုဘီး ရှစ်လေဟှယ်။ အယ်သူဟှာလည်း ငါနထိုက်တန်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","သူးနို့ရဲ့ လတ်ဝါးကပ်တိုင်ဟှို ထမ်းဘီး ငါ့နော့‑က်ဟှို လိုက်ဂေ့ဘဲနေသူဟှာ ငါ့တဗဲ့လေဖြစ်ဟှို့ ထိုက်တန်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","သူးနို့ရဲ့သတ်ဟှို တွိဟှူသူဟှာ သတ်ရှောင်းလေ့မယ်။ အယ်ဘေမဲ့ ငါ့ကြောန့် သူးနို့ရဲ့ သတ်ရှောင်းဟှူသူဟှာ သတ်ဟှို တွိရလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“နန်းနို့ဟှို လတ်ခံဟှူ သူလေဟှာ ငါ့ဟှို လတ်ခံဇာဖြစ်လေဟှယ်။ ငါ့ဟှို လတ်ခံဟှူ သူလေဟှာလည်း ငါ့ဟှို စေလွှတ်ဟှူသူဟှို လတ်ခံဇာဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ဘုရားသခင်ရဲ့ နာမတော်ဟှို ထော့‑က်ဘီး ဘုရားသခင်ရဲ့ ပရောဖက်ဟှို လတ်ခံဟှူသူလေဟှာ အယ်ပရောဖက်ရဲ့ ကျိုးဟှို ခံစားရလေ့မယ်။ ဖြောန့်မတ်ဟှူသူဟှို ထော့‑က်ဘီး ဖြောန့်မတ်ဟှူသူဟှို လတ်ခံဟှူသူဟှလည်း ဖြောန့်မတ်ဟှူသူရဲ့ ကျိုးဟှို ခံစားရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ငါ မှန်ပြောမယ်၊ ငါ့နာမဟှို ထော့‑က်ဘီး ငါ့တဗဲ့လေထဲဟှ အားနဲဟှူသူတယာ့‑က်ယော့‑က်ဟှို ရေတခွပ်တိုက်ဟှယ် ဆိုဟှာ အယ်သူဟှာ ကျိုးဟှို ခံစားရလေ့မယ်” ဆိုဘီး မိန့်မှာဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ယေရှုဟှာ တဗဲ့တော်ဆယ့်နှေ့ပါးဟှို အယ်မူဇာလေ ဂူလောင်း မိန့်မှာဘီးဟှာ ဂါလိလဲပြည်ရဲ့ ဗြို့လေမာ ဆောင်းမဩဝါဒပေးဘီး ဒန်းကောန်းဟှို ကြေညာဟှို့တွပ် အယ်ရပ်ဟှနေဘီး ထွပ်ကြွဟှားတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ခရစ်တော် ပြုလောက်နေဟှူ ကြောန်းရာလေဟှို ထောန်ထဲမာ ယောဟန်ကြားရဟှူ ခီမာ သူ့တဗဲ့တချို့ဟှို ကိုယ်တော်နားဟှို လွှတ်ဘီး ");
INSERT INTO tvn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“ကိုယ်တော်ဟှာ ကြွလာတော်မူဟှူ ခရစ်တော်ဘဲ့လော။ နော့‑က်မှုဘဲနေဟှာ တခြားတယော့‑က်ဟှို စောန့်မျှော်ရဟှို့သေးလော” ဆိုဘီး မေးလျှော့‑က်စေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ယေရှုဟှလည်း “နန်းနို့ကြားသိဟှူ ဇာလေ၊ ဗြင်တွိဟှူ ဇာလေဟှို သွားဘီးဟှာ ယောဟန်ဟှို ပြောပြဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","မျစ်စိကန်းနေဟှူ သူလေဟှာ မျစ်စိဗြင်ရဟှယ်။ ခေလတ်သေနေဟှူ သူလေလည်း လမ်းသွားရဟှယ်။ နူနာရောဂါသယ်လေဟှာ သန့်ရှင်းမှုဟှို ရဟှယ်။ နားကြားဘဲနေဟှူသူလေ နားကြားရဟှယ်။ သေဟှူသူလေဟှာ ပ္လန်ရှင်ဇာဟှိုခံရဟှယ်။ ဆင်းရဲသားလေလည်း ဝန်းသာဇာဒန်းကောန်းဟှို ကြားရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ငါ့ဟှို ငြင်းပယ်ဘဲဟှူ လူလေဟှာ မင်္ဂလာရှိဟှယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ယောဟန်ရဲ့ တဗဲ့လေ ပ္လန်ဟှားခီမာ ယေရှုဟှာ ယောဟန်ဟှို ကြောန်းပြုဘီးဟှာ ဒေသနာ နားထောန်ဟှို့ လာဟှူသူလေဟှို “နန်းနို့လေဟှာ ဖယ်ဇာဟှို ကေ့ဟှို့ တောထဲဟှိုသွားဂေ့နူး။ လေတိုက်ဘီး လှောက်ရှားတတ်ဟှူ ကျူဗန်ဟှို ကေ့ရှင်ကြောန့် သွားဂေ့လော။ ");
INSERT INTO tvn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","အယ်မျိုးမှုဟှ ဆိုဟှာ ဝတ်ကောန်းစားလှဝတ်ဟှားဟှူသူဟှို ကေ့ရှင်ကြောန့် သွားဂေ့လော။ အယ်မျိုးဝတ်ဟှားဟှူ သူလေဟှာ မန်းဂီးရဲ့ နန်းတော်လေမာဘဲ့ ရှိဂေ့ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ပရောဖက်ဟှို ကေ့ရှင်ကြောန့် သွားဇာလော။ မှန်ဟှယ်။ ပရောဖက်ထတ် ကီးမြတ်ဟှူ သူလည်းဖြစ်ဟှယ် ဆိုဘီး နန်းနို့လေဟှို ငါပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ကျမ်းစာမာ ‘နန်သွားမယ့် လမ်းဟှို ပြင်ဟှို့တွပ် ဘုရားသခင်ဟှ ငါ့ရဲ့တမန်ဟှို နန့်ရှေ့မာ စေလွှတ်မယ်’ ဆိုဘီး ယောဟန်ကြောန်းဟှို ရေးဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ငါ မှန်ပြောရမယ် ဆိုဟှာ မီးမမွီးဟှူ သူလေထဲမာ ဗတ္တိဇံယောဟန်ထတ် ကီးမြတ်ဟှူသူ တယော့‑က်လည်း ပေါ်ထွပ်သေးဟှ။ အယ်ဘေမဲ့ ကောန်းဂန်နိုင်ငံတော်မာ ငယ်ဆောင်းဖြစ်ဟှူသူဟှာ ယောဟန်ထတ် ပိုဘီး ကီးမြတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ဗတ္တိဇံယောဟန် လတ်ထတ်ဟှနေဘီး ခုခီထိ ကောန်းဂန်နိုင်ငံတော်ဟှာ အဓမ္မလူလေရဲ့ ကြမ်းဖတ်မှုလေဟှို ခံရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ယောဟန်ပေါ်ထွပ်ခန်ဂဒဲဟှ မောရှေရဲ့ ပညတ္တိကျမ်းန ပရောဖက်လေ ဂူလောင်းဟှာ ကောန်းဂန်နိုင်ငံတော်ကြောန်းဟှို ပြောဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","နန်းနို့လေဟှာ လတ်ခံဟှို့ ဆန္ဒာရှိမယ် ဆိုဟှာ အယ်သူဟှာ ဧလိယဘဲ့ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","နန်းနို့မာ နားရှိဟှယ် ဆိုဟှာ ကြားဂေ့!” ");
INSERT INTO tvn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“အယ်ခေတ် လူလေဟှို ငါဖယ်မျိုး နှိုင်းပြရဟှို့နူး။ ဇာတ်ပွဲကနေဟှူ လူငယ်လေဟှာ သူးနို့ငယ်ဂျင်းလေဟှို အော်ဘီးဟှာ ");
INSERT INTO tvn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘နို့လေဟှာ သားသာယားယာ တီးမှုဂေ့ဟှူလည်းဘဲ့ နန်းနို့လေ ကဂေ့ဟှ! ဝန်းနဲပူဆွေးဟှူချင်းဟှို ဆိုဟှူလည်းဘဲ့ ငိုဂေ့ဟှ!’ ဆိုဘီး ပြောဟှူလူငယ်လေန အယ်လူမျိုးလေဟှာ တူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ယောဟန်ဟှ စားသော့‑က်ဘဲန လာဟှယ် ဆိုဟှာ သူးနို့လေဟှာ ‘အယ်သူဟှာ နတ်ဆိုးဝမ်နေဟှူ သူဖြစ်ဟှယ်!’ ဆိုဘီး ပြောဆိုဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","လူ့ရဲ့သားဟှာ စားသော့‑က်ဘီးလာဟှယ် ဆိုဟှာ ‘ကေ့ကေ့ အယ်လူဟှာ စားမတ်ဘီး ဝိုင်သော့‑က်သူ၊ ခွန်ကော့‑က်မားလေန ပြစ်သားလေရဲ့ မိဆွေဖြစ်ဟှယ်!’ ဆိုဘီး ပြောဂေ့ဗ္လန်ဟှယ်။ အယ်ဘေမဲ့ ဘုရားသခင်ရဲ့ ဉာဏ်ပညာတော်ဟှာ မှန်ကန်ကြောန်းဟှို အယ်မူကြောန်းရာအားဖြင့် သတ်သေပြဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","အယ်ဘီးန ယေရှုဟှာ နိမိတ်လတ်ခဏာလေဟှို ပြဘီးလည်းဘဲ့ နောန်ဒရဂေ့ဘဲဟှူ ဗြို့လေဟှို ပြစ်တန်ဘီး ဆောင်းမတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“အို၊ ခေါရဇိန်ဗြို့၊ နန်ဟှာ အမင်္ဂလာရှိလေဟှယ်! အို၊ ဗက်ဇဲဒဗြို့၊ နန်ဟှာ အမင်္ဂလာရှိလေဟှယ်! နန်းနို့လေမှာ ငါပြဟှူတဂိုးလေဟှို တုရုဗြို့န ဇိဒုန်ဗြို့လေမှာ ပြလိုက်မယ် ဆိုဟှာ အယ်ဗြို့လေဟှာ ရှေးမဆွဂဒဲဟှ လျှော်တေဝတ်ဟှို ဝတ်ဘီး၊ ပ္လာနလူးဘီး နောန်ဒရဟှားဂေ့ဘီ! ");
INSERT INTO tvn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ငါပြောမယ်။ တရားစီရင်ဟှူနေ့မာ ဘုရားသခင်ဟှာ နန်းနို့လေထတ် တုရုဗြို့န ဇိဒုန်ဗြို့ဟှို ပိုဘီး ကရုဏာတော် ပြလေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ကပေရနောင်ဗြို့! နန်ဟှာ ကောန်းဂန်ဘောင်ထိအောန် မ္လော့‑က်စားခံရလေ့မယ် ဆိုဘီး ထန်နေလော။ မရဏာနိုင်ငံဟှို ပစ်ခ္လခံရလေ့မယ်! နန်းနို့နားမာ ပြလိုက်ဟှူ တဂိုးလေဟှို သောဒုံဗြို့မာလည်း ပြဖူးမယ် ဆိုဟှာ အယ်ဗြို့ဟှာ ခုခီထိ ပျစ်စီးဘဲရှိနေလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ငါပြောမယ်။ တရားစီရင်ဟှူနေ့မာ ဘုရားသခင်ဟှာ နန့်ထတ် သောဒုံဗြို့ဟှို ပိုဘီး ကရုဏာတော် ပြလေ့မယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","အယ်ခီမာ ယေရှုဟှ “ဖ၊ ကောန်းဂန်ဘောင်န မ္လေဂီးရဲ့သခင်! ကိုယ်တော်ဟှာ ပညာရှိလေဟှို သိစေဘဲ ဖောင်းကွယ်ဟှားဘီး ပညာမှေ့ဘဲဟှူ သူလေဟှိုဘဲ့ ဖွမ့်ပြပေးဟှိကြောန့် ကျွန်တော်ဟှို ချီးမွမ်းပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","မှန်ပါဟှယ် ဖ၊ အယ်မူဇာဟှာ ကိုယ်တော် လိုတော်ရှိဟှူဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ငါ့ဖဟှာ ရှိမျှဂူလောင်းဟှို ငါ့ဟှို ပေးဟှားပီးဘီ။ ဖဟှလွဲဘီး ဖယ်သူလည်း သားတော်ဟှို သိဂေ့ဟှ။ ဖဟှိုလည်း သားတော်န သားတော်ဟှ ဖွမ့်ပြလိုဟှူ သူဟှလွဲဘီး ဖယ်သူလည်း သိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ဝန်လေးဘီး ပန်ဘန်းနေဟှူ သူလေ ဂူလောင်း ငါ့နားဟှို လာဂေ့ပါ။ ငါနန်းနို့ဟှို နားပေးမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ငါ့ထမ်းဘိုးဟှို ယူဘီးထမ်းဂေ့ပါ။ ငါ့နားမာ သန်ယူဂေ့ပါ။ ငါဟှာ နူးညံ့သိမ်မွေ့ဘီး နှိခ္လဟှူ စိသဘောရှိကြောန့် နန်းနို့ဟှာ သတ်သာမှုဟှို တွိဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါ့ထမ်းဘိုးဟှာ ထမ်းရလွယ်ဘီး ဝန်လည်းပေါ့ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ဒန်းနေ့မာ ယေရှုဟှာ ဂျောင်စဗားလယ်ဂွမ့်လေဟှို ဖြတ်ရှော့‑က်ဟှားဟှယ်။ ကိုယ်တော်ရဲ့ တဗဲ့တော်လေဟှာ ရရာတိုင်း ဗိုက်ဆာဂေ့ဟှိကြောန့် ဂျောင်စဗားနှံလေဟှို ဆွတ်ဘီးစားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","အယ်မူဇာဟှို ဖာရိရှဲလေဗြင်ဟှူ ခီမာ “ကေ့ဂေ့၊ ကိုယ်တော်ရဲ့ တဗဲ့တော်လေဟှာ ဒန်းနေ့မာ လောက်အပ်ဘဲဟှူဇာလေဟှို လောက်နေဂေ့ဘီ!” ဆိုဘီး ယေရှုဟှို ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ယေရှုဟှ “ဒါဝိဒ်ဟှာ သူ့ပေါန်းဖော်လေနတူးဒူ ဗိုက်ဆာလာဟှူ ခီမာ ဖယ်မျိုး လောက်ဟှားဟှယ် ဆိုဇာဟှို နန်းနို့ လောင်းဝ ဖတ်ဖူးဂေ့ဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","သူ့န သူ့ပေါန်းဖော်လေဟှာ ဘုရားသခင်ရဲ့ ဗိမာန်တော်ဟှို ဝမ်ဘီး သူလည်းစားမအပ်၊ သူ့ပေါန်းဖော်လေလည်း စားအပ်ဘဲဟှူ၊ ဘုရားသခင်ဟှို ဆစ်ကပ်ဟှားဟှူ မုဟှို ပညတ်တရားဟှို ဆန့်ကျင်ဘီး စားဂေ့လေဟှယ်။ အယ်မုဟှာ ယဇ်ပုရောဟိတ်လေဘဲ့ စားအပ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ယဇ်ပုရောဟိတ်လေလည်း ဒန်းနေ့မာ ဗိမာန်တော်မာ ဒန်းနေ့နဆိုင်ဟှူ ပညတ်ဟှို ခ္လိုးဖော့‑က်ဟှူလည်းဘဲ့ ပြစ်ဖြစ်ဘဲနေဇာဟှို မောရှေရဲ့ ပညတ္တိကျမ်းစာမာ ဖတ်ဖူးဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ငါပြောမယ်၊ အယ်ရပ်မာ ဗိမာန်တော်ထတ် ပိုဘီး ကီးမြတ်ဟှူဇာ ရှိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘ယဇ်ပူဇော်ဇာထတ် သနားကြင်နာမှုဟှို ငါ ပိုဘီး နှစ်သက်ဟှယ်။’ အယ်ကျမ်းစာဟှို နန်းနို့နားလည်ဟှယ် ဆိုဟှာ ပြစ်မှေ့ဘဲဟှူ သူလေဟှို ပြစ်တန်စီရင်လေ့ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လူ့ရဲ့သားဟှာ ဒန်းနေ့ရဲ့ သခင်ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ယေရှုဟှာ အယ်ရပ်ဟှ ကြွဟှားဘီးဟှာ ဝါလယ်ဇရပ်ထဲဟှို ဝမ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","အယ်နေရာမာ လတ်တဖတ်သေနေဟှူ လူတယော့‑က်ရှိနေလေဟှယ်။ တချို့လူလေဟှာ ယေရှုဟှို ပြစ်တန်စွပ်စွဲရှင်ဟှိကြောန့် “ဒန်းနေ့မာ ရောဂါဟှို ကုသပေးဇာဟှာ ပညတ်တော်ဟှို ဆန့်ကျင်ဇာမှုဟှလော” ဆိုဘီး မေးလျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ယေရှုဟှ “တကယ်ဟှိ နန်းနို့မာ သိုးတကောန်ဘဲ့ရှိဟှယ်။ အယ်သိုးဟှာ ဒန်းနေ့မာ တွမ်းထဲဟှို က္လဟှားဟှယ် ဆိုဟှာ နန်းနို့ဟှာ ဆွဲဒန်ဘဲန နေဟှို့လော။ ");
INSERT INTO tvn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","လူဟှာ သိုးထတ် ပိုဘီး မြတ်လေဟှယ်! အယ်ကြောန့် နို့လေရဲ့ ပညတ်တော်ဟှာ ဒန်းနေ့မာ ကယ်တန်ပေးဟှို့ ခွမ့်ပြုဟှားဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","အယ်ဘီးန လတ်သေနေဟှူသူဟှို “နန့်ရဲ့ လတ်ဟှို ဆန့်လိုက်” ဆိုဘီး ပြောလေဟှယ်။ အယ်သူဟှာ သူ့လတ်ဟှို ဆန့်လိုက်ဘီးန ကျန်ဟှူလတ်တဖတ်မျိုး ကောန်းတိုင်း ပ္လန်ဖြစ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","အယ်ဘီးန ဖာရိရှဲလေဟှာ ထွပ်ဟှားဘီး ယေရှုဟှို သတ်ဟှို့တွပ် ကြံစည်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","အယ်မျိုး ကြံစည်ဟှားဇာဟှို ယေရှုသိတော်မူဟှူ ခီမာ တခြားနေရာဟှို ထွပ်ကြွဟှားလေဟှယ်။ လူအောက်ဂီးလည်းဘဲ့ နော့‑က်တော်ဟှို လိုက်ဟှားဂေ့ဟှယ်။ ကိုယ်တော်ဟှာ သူးနို့လေရဲ့ ရောဂါလေ ဂူလောင်းဟှို ပျော့‑က်ကင်းစေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","သူ့ကြောန်းရာလေဟှို ဖယ်သူ့ဟှိုလည်း ပြောဂေ့ဘဲဟှို့တွပ် မိန့်ပေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","အယ်မျိုး မိန့်ပေးဟှားဇာဟှာ ပရောဖက် ဟေရှာယအားဖြင့် ဘုရားသခင် ပေးဟှားဟှူ ဗျာဒိတ်တော် ပ္လဲ့ဇောင်ဟှို့တွပ် ဖြစ်လေဟှယ်။ ဗျာဒိတ်တော်ဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ငါမြတ်နိုးဘီး ရှစ်ရဟှူ၊ ငါဝီးကော့‑က်ဟှားဟှူ ငါ့ရဲ့ စေခံဟှို ကေ့ရှုဂေ့ပါ။ ငါ့ဝိညာဉ်တော်ဟှို အယ်သူထတ်ဟှို ငါစေလွှတ်မယ်။ အယ်သူဟှာ လူမျိုးဘောန်းဇောင်ဟှို တရားပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ငြင်းခူဇာလေ၊ အော်ဟစ်ဇာလေဟှို လောက်ဟှ။ လမ်းမာလည်း သူ့ရဲ့အသံဟှို ဖယ်သူဟှိုလည်း ကြားစေဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","သူဟှာ ကွေ့ကော့‑က်ဟှူ ကျူဗန်ဟှို ခ္လိုးဘဲန၊ မီးခိုးများဟှူ မီးဇာဟှိုလည်း သတ်ဘဲန၊ တရားမျှတမှုဟှို အောန်မြင်ဟှို့တွပ် ပို့ဆောန်လေ့မယ်၊ ");
INSERT INTO tvn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","သူ့ရဲ့ နာမဟှိုလည်း လူမျိုးဘောန်းဇောင် မျှော်လင့်လေ့မယ်” ဆိုဘီး ဟောဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","အယ်ခီမာ နတ်ဆိုးဝမ်ပူးနေဟှူ မျစ်စိကန်းဘီး စကားအနေဟှူ လူတယော့‑က်ဟှို ယေရှုနားဟှို ခေါ်ဆောန်လာဂေ့လေဟှယ်။ ယေရှုဟှာ နတ်ဆိုးဟှို နှန်ထုလိုက်ဟှူကြောန့် အယ်သူဟှာ မျစ်စိဗြင်လာဘီး စကားပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","လူအောက်ဂီးဟှာ ရရာတိုင်း အံ့ဩဟှားဘီးဟှာ “အယ်သူဟှာ ဒါဝိဒ်ရဲ့သားတော် ဖြစ်လေ့မယ်လော” ဆိုဘီး မေးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","အယ်မူဇာလေဟှို ဖာရိရှဲလေကြားဟှူ ခီမာ “အယ်သူဟှာ နတ်ဆိုးခေါန်းဆောန် ဗေလဇေဗုလဟှို အားကိုးဘီးဟှာ နတ်ဆိုးလေဟှို နှန်ထုဟှယ်” ဆိုဘီး ပြောဆိုဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ယေရှုဟှာ အယ်သူလေရဲ့ စိနေသဘောထားဟှို သိနေဟှိကြောန့် “နိုင်ငံတနိုင်ငံဟှာ ရှင်းရှင်း တိုက်ခိုက်ဘီး ကွဲပြားနေမယ် ဆိုဟှာ အယ်နိုင်ငံဟှာ ကြာခန် ပျစ်စီးလေ့မယ်။ အယ်မျိုးဘဲ့ လူလေစိဝန်းကွဲပြားဘီး ရှင်းရှင်း တိုက်ခိုက်နေမယ် ဆိုဟှာ အယ်ဗြို့၊ အယ်အီထောန်ဟှာ ပျစ်စီးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","စာတန်ရဲ့ အောက်စိုးမှုဟှို ဝန်ခံဟှူသူလေဟှာ ရှင်းရှင်း တိုက်ခိုက်ဘီး ကွဲပြားနေမယ် ဆိုဟှာ သူးနို့နိုင်ငံဟှာ ဖယ်မျိုးလည်း တည်မြဲနိုင်ဟှို့မှုဟှ! ");
INSERT INTO tvn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ငါဟှာ နတ်ဆိုးခေါန်းဆောန် ဗေလဇေဗုလဟှို အားကိုးဘီးဟှာ နတ်ဆိုးလေဟှို နှန်ထုဟှယ် ဆိုဟှာ နန်းနို့တဗဲ့လေဟှာ ဖယ်သူ့ဟှို အားကိုးဘီးဟှာ နှန်ထုဂေ့နူး။ နန်းနို့လေ မှားယွင်းနေဟှယ် ဆိုဇာဟှို နန်းနို့တဗဲ့လေ ပြုမူဟှ သတ်သေပြနေဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ငါဟှာ ဘုရားသခင်ရဲ့ ဝိညာဉ်တော်ဟှို အားကိုးဘီးဟှာ နတ်ဆိုးလေဟှို နှန်ထုဟှယ် ဆိုဟှာ နန်းနို့လေတွပ် ဘုရားသခင်ရဲ့ နိုင်ငံတော် တည်ဟှို့ခီ ရော့‑က်လေဘီ။” ");
INSERT INTO tvn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“ဖယ်သူလည်း ခွန်အားကီးဟှူလူဟှို ရင်ဦးဆောင်း ကြိုးန တောက်ဘဲန သူ့အီထဲဟှို ဝမ်ဘီးဟှာ သူ့ပစ်စီးလေဟှို လုယူနိုင်ဟှို့မှုဟှ။ သူ့ဟှို ရင်ဦးဆောင်း တောက်ဘီးမှ သူ့အီမာရှိဟှူ ပစ်စီးလေဟှို လုယူနိုင်လေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ငါ့ဖတ်မာ နေဘဲဟှူသူဟှာ ငါ့ရန်ဖတ်ဖြစ်ဟှယ်။ ငါ့နတူးဒူ စုသီးဘဲဟှူသူဟှာ ကြဲဖြန့်နေဟှူသူ ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","အယ်ကြောန့် ငါပြောမယ်။ ပြစ်မှားပြောဆိုဟှူပြစ်န ကဲ့ရဲ့ဟှူ ပြစ်ဘောန်းဇောင်တွပ် လူလေဟှာ ခွမ့်လွှတ်ခံရနိုင်ဘေမဲ့ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို ပြစ်မှားဘီး ပြောဆိုဟှူ သူဟှာ ခွမ့်လွှတ်ခံရဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","လူ့ရဲ့သားဟှို နှောက်နပြစ်မှားဘီး ပြောဆိုဟှူသူရဲ့ ပြစ်ဟှိုလည်း လွတ်နိုင်ဟှယ်။ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို ပြစ်မှားဘီး ပြောဆိုဟှူ သူဟှာ ခုဘဝ နော့‑က်ဘဝ လွတ်နိုင်ဟှ။” ");
INSERT INTO tvn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“သီးကောန်းဟှို လိုရှင်ဟှယ် ဆိုဟှာ သစ်ပန်ကောန်းဟှို စိုက်ရဟှယ်။ သစ်ပန်ကောန်းဟှာ သီးကောန်းဟှိုဘဲ့ သီးလေ့မယ်။ သီးဟှို ကေ့လိုက်ဟှူန သစ်ပန်ရဲ့ သဘောဟှို သိရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ဝှေ့ မွီဗွေးလေ နန်းနို့လေဟှာ ယောက်ညံ့ဟှူသူလေ ဖြစ်ဟှူကြောန့် ကောန်းမြတ်ဟှူ စကားလေဟှို ဖယ်မျိုး ပြောနိုင်ဂေ့မယ်နူး။ စိနှလောင်းထဲမာ ရှိဟှူတိုင်းဘဲ့ နှောက်ဟှ ပြောတတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ကောန်းမြတ်ဟှူသူလေဟှာ ကောန်းမြတ်ဟှူ စိနှလောင်းဘဏ္ဍာတိုက်ထဲဟှ ကောန်းမြတ်ဟှူဇာလေဟှို ထုဖော်တတ်ဘီး ယောက်ညံ့ဟှူသူလေဟှာ ယောက်ညံ့ဟှူ စိနှလောင်းဘဏ္ဍာတိုက်ထဲဟှနေဘီး ယောက်ညံ့ဟှူဇာလေဟှိုဘဲ့ ထုဖော်တတ်လေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“နန်းနို့လေဟှို ငါပြောမယ်၊ တရားစီရင်ဟှူနေ့မာ လူတိုင်း ကျိုးမှေ့ဘဲဟှူ စကားလေတွပ် စစ်ကြောစီရင်ခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","နန်းနို့ရဲ့ စကားအားဖြင့် ပြစ်လွတ်ခံရဘီး နန်းနို့ရဲ့ စကားအားဖြင့်ဘဲ့ ပြစ်စီရင်ဇာဟှို ခံရလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","အယ်ခီမာ ကျမ်းပြုဆရာတချို့န ဖာရိရှဲလေဟှ “ဆရာ၊ ကျွန်တော်ဟှားလေ ကိုယ်တော်ပြဟှူ နိမိတ်လတ်ခဏာတခုခုဟှို ဗြင်ရှင်ပါဟှယ်” ဆိုဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ယေရှုဟှ “ဆိုးညစ်ဘီး ဉာဏ်များဟှူ အယ်နေ့ခေတ်ရဲ့ အဓမ္မလူလေ! နန်းနို့လေ တောန်းနေဟှူ နိမိတ်လတ်ခဏာဟှာ ပရောဖက်ယောနရဲ့ နိမိတ်လတ်ခဏာဟှလွဲဘီး ဖယ်မျိုး နိမိတ်လတ်ခဏာလည်း ဗြင်တွိရဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ယောနဟှာ ငါးဂီးဗိုက်ထဲမာ သောင်းရစ် လောင်းလောင်း နေရဟှူမျိုး လူ့ရဲ့သားဟှာ မ္လေဂီးထဲမာ သောင်းရစ်နေရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","တရားစီရင်ဟှူနေ့မာ နိနဝေဗြို့သားလေဟှာ အယ်လူမျိုးလေဟှို ထဘီးဟှာ ပြစ်တန်ဂေ့လေ့မယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့လေဟှာ ယောနဟောပြောဟှူ စကားကြောန့် နောန်ဒရဂေ့ဟှယ်။ အယ်နေရာမာ ယောနထတ် ပိုဘီး ကီးမြတ်ဟှူသူ ရှိနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","တရားစီရင်ဟှူနေ့မာ ရှေဘပြည်ရဲ့ မိဖုရားဟှာ အယ်လူမျိုးလေဟှို ထဘီးဟှာ ပြစ်တန်လေ့မယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်မိဖုရားဟှ ရှောလမုန် မန်းဂီးရဲ့ ပညာစကားဟှို နားထောန်ရှင်ကြောန့် ရေခြားမ္လေခြားဟှနေဘီး လာလေဟှယ်။ အယ်နေရာမာ ရှောလမုန် မန်းဂီးထတ် ကီးမြတ်ဟှူသူရှိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ညစ်ညူးဟှူနတ်လေဟှာ လူရဲ့ကိုယ်ထဲဟှ ထွပ်ဟှားဘီးခီမာ ခြော့‑က်သွိဟှူနေရာလေမာ သူးနို့နေဟှို့နေရာလေဟှို လိုက်ရှာတတ်လေဟှယ်။ ရှာတွိနိုင်ဟှ ဆိုဟှာ ");
INSERT INTO tvn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘ငါ့အီဟှို ပ္လန်သွားအူးမယ်။’ အယ်ကြောန့် ပ္လန်ရော့‑က်ဟှားဘီးန အယ်အီဟှာ သပ်သပ်ရပ်ရပ် ရှင်းလန်းဟှားဇာဟှို တွိရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","အယ်ဘီးန သူ့ထတ် ပိုဘီး ညစ်ညူးဟှူ နတ်ဆိုးခွန်နှေ့ကောန်ဟှို ခေါ်လာဘီးဟှာ အယ်လူထဲဟှို ဝမ်လေဟှယ်။ အယ်သူရဲ့ နော့‑က်ဖြစ်ဟှူဇာဟှာ ရှေ့ဖြစ်ဟှူဇာထတ် ပိုဘီး ဆိုးဝါးလေဟှယ်။ ဆိုးညစ်ဟှူ အယ်လူမျိုးလေဟှာ အယ်မျိုးခံစားရလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ယေရှုဟှာ ပရိသတ်လေဟှို ပြောနေဒူး မိန ညီလေဟှာ ရော့‑က်လာဟှယ်။ ကိုယ်တော့်ဟှို တွိရှင်ဟှူကြောန့် သူးနို့ဟှာ ပ္လန်မာ စောန့်နေဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","အယ်ကြောန့် လူတယော့‑က်ဟှ “ကိုယ်တော်ရဲ့ မိန ညီလေဟှာ ကိုယ်တော့်ဟှို တွိရှင်ဟှူကြောန့် ပ္လန်မာ စော့န်နေဂေ့ဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ယေရှုဟှလည်း “ငါ့မိ၊ ငါ့ညီလေဟှ ဖယ်သူနူး” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","အယ်ဘီးန တဗဲ့တော်လေဟှို ညွှန်ပြဘီးဟှာ “ကေ့ဂေ့! ငါ့မိ၊ ငါ့ညီလေဟှာ အယ်သူလေဘဲ့ ဖြစ်လေဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ကောန်းဂန်ဘောင်မာ ရှိတော်မူဟှူ ငါ့ဖရဲ့ လိုတော်ဟှို ဆောန်ရွက်ဟှူ သူမှန်ဟှူမျှဟှာ ငါ့ညီ၊ ငါ့ညီမန ငါ့မိလေဘဲ့ ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","အယ်နေ့မာ ယေရှုဟှာ အီဟှနေ ထွပ်ကြွဟှားဘီး အိုင်ကမ်းနားမာ ထိုင်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ကိုယ်တော်နားမာ စုဝီးနေဟှူ လူအောက်ဂီးဟှာ ရရာတိုင်း များဂေ့ကြောန့် လှေထတ်ဟှို တတ်ဘီး ထိုင်နေလေဟှယ်။ အယ်ခီမာ လူအောက်ဂီးဟှာ ကမ်းနားမာ ရပ်နေဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ကိုယ်တော်ဟှာ အယ်သူလေဟှို ပေါင်ဥပမာလေဘောင်းဂီးန သွန်သန်လေဟှယ်။ “မျိုးစေ့ကြဲမားတယော့‑က်ဟှာ မျိုးစေ့ကြဲဟှို့တွပ် ထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","သူဟှာ မျိုးစေ့ဟှို ကြဲဟှူ ခီမာ တချို့စေ့လေဟှာ လမ်းထတ်မာ က္လဟှိကြောန့် ငှတ်လေလာဘီးဟှာ ကော့‑က်စားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","တချို့မျိုးစေ့လေဟှာ မ္လေနဲဘီး က္လော့‑က်များဟှူ နေရာလေမာ က္လဟှယ်။ မ္လေနဲကြောန့် စေ့လေဟှာ ဗြန်းဗြန်ပန်ပေါ့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","အယ်ဘေမဲ့ နေထွပ်လာဟှူ ခီမာ ပြစ်စွဲဘဲကြောန့် ပူဒန်ဟှို ခံနိုင်ဘဲ ခြော့‑က်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","တချို့မျိုးစေ့လေဟှာ ဆူးဒေါထဲဟှို က္လဟှိကြောန့် ဆူးချောင်လေကြားမာ ကီးထွားနိုင်ဘဲ သေဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","တချို့စေ့လေဟှာ ကောန်းဟှူမ္လေမာ က္လဟှူကြောန့် ပန်လေပေါ့‑က်လာဘီး တချို့ဟှ ဆသောင်းဆယ်၊ တချို့ဟှ ဆခြော့‑က်ဆယ်၊ တချို့ဟှ ဆတရာ ပွားများလာဘီးဟှာ သီးသီးဂေ့လေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ယေရှုဟှ “နန်းနို့မာ နားရှိဟှယ် ဆိုဟှာ ကြားဂေ့!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","တဗဲ့တော်လေဟှာ ကိုယ်တော်နားဟှို လာဂေ့ဘီးဟှာ “ကိုယ်တော်ဟှာ ဖြားဖြစ်ကြောန့် အယ်သူလေဟှို ပေါင်ဥပမာလေန ဟောပြောဟှယ်နူး” ဆိုဘီး မေးလျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ကိုယ်တော်ဟှ “နန်းနို့လေဟှာ ကောန်းဂန်နိုင်ငံတော်ရဲ့ နတ်နဲဟှူ ကြောန်းရာလေဟှို သိခွမ့်ရှိဂေ့ဟှယ်။ အယ်ဘေမဲ့ တခြားသူလေဟှာ သိခွမ့် မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ရှိဟှူလူဟှို ထပ်ပေးဘီး သူ့ဟှို ကြွယ်ဝစေလေ့မယ်။ မှေ့ဘဲဟှူ လူနားဟှ ရှိဟှူမျှဟှို နှုလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","အယ်ကြောန့် သူးနို့လေဟှာ ကေ့နေဘေမဲ့လည်း ဗြင်ဂေ့ဟှ။ နားထောန်နေဘေမဲ့လည်း ကြားဂေ့ဟှ။ နတ်ဓိပါယ်ဟှိုလည်း နားလည်ဘဲကြောန့် ပေါင်ဥပမာဟှို သောင်းပြုဘီး ငါဟောပြောရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ပရောဖက် ဟေရှာယ ဟောပြောဖူးဟှူ အနာဂတ္တိကျမ်းစကားဟှာ အယ်သူလေမာ ပ္လဲ့ဇောင်ရှင်းဟှို ရော့‑က်လေဟှယ်။ ဟောပြောဟှားဇာဟှ၊ “‘အယ်လူလေဟှာ ကြားနေဘေမဲ့လည်း နတ်ဓိပါယ်ဟှို နားလည်ဘဲန ကြားဂေ့လေ့မယ်။ ဗြင်နေဘေမဲ့လည်း အာရောင်ရော့‑က်ဘဲန ဗြင်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်လူလေရဲ့ စိနှလောင်းဟှာ ထူထိုင်းနေဘီး နားဟှလည်း ကြားဂေ့ဟှ။ အယ်ဘီးဟှာ မျစ်စိလည်း ပိနေဂေ့ဟှယ်။ အယ်သူလေရဲ့ မျစ်စိဟှာ ဗြင်ဘီး အယ်သူလေရဲ့ နားဟှလည်း ကြားဘီး အယ်သူလေရဲ့ စိနှလောင်းဟှာ နားလည်ဘီး အယ်သူလေဟှာ ငါ့နားဟှို ပ္လန်လာမယ် ဆိုဟှာ ငါဟှာ အယ်သူလေဟှို ကျန်းမာစေမယ်’ ” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“နန်းနို့လေရဲ့ မျစ်စိဗြင်ဘီး နန်းနို့လေရဲ့ နားကြားဟှိကြောန့် မင်္ဂလာရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ငါ မှန်ပြောမယ်၊ နန်းနို့ဗြင်ရဟှူဇာလေဟှို ပရောဖက်လေန ဖြောန့်မတ်ဟှူသူလေဟှာ ဗြင်တွိရှင်လည်းဘဲ့ ဗြင်တွိရဂေ့ဟှ။ နန်းနို့ကြားရဟှူဇာလေလည်း ကြားရဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“အယ်ကြောန့် မျိုးစေ့ကြဲမားရဲ့ ပေါင်ဥပမာရဲ့ နတ်ဓိပါယ်ဟှို နားထောန်ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","လမ်းမာက္လဟှူ မျိုးစေ့ကြောန်းဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်တရားစကားဟှို ကြားရဘေမဲ့လည်း နားလည်ဘဲဟှူ လူလေနတူဟှယ်။ နှလောင်းထဲဟှမျိုးစေ့ဟှို နတ်ဆိုးဟှာ လာဘီး နှုယူဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","က္လော့‑က်ပေါဟှူမ္လေထတ်မာ က္လဟှူမျိုးစေ့ ဆိုဇာဟှာ တရားစကားဟှို ကြားဟှူနကြားရှင်း ဝန်းသာအားရခံယူဟှူလူဟှို ဆိုလိုဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","အယ်ဘေမဲ့ စိနှလောင်းထဲမာ ပြစ်စွဲဘဲဟှူကြောန့် တရားစကားအားဖြင့် ညှဉ်းဆဲမှုလေဟှို ခံလာရဟှူ ခီမာ ရှစ်ရှင်းဖော့‑က်ပ္လန်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ဆူးချောင်မာ က္လဟှူမျိုးစေ့ဟှာ တရားစကားဟှို ကြားရဘေမဲ့ ဘဝရဲ့ စိုးရိမ်ပူပန်မှုလေန စည်းဇိမ်အောက်စာလေရဲ့ လှည့်ဇားမှုလေအားဖြင့် တရားစကားဟှို တားဆီးလိုက်ဟှူကြောန့် သီးသီးဘဲဟှူသူလေဟှို ဆိုလိုဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ကောန်းဟှူမ္လေမာ က္လဟှူမျိုးစေ့ကြောန်းရာဟှ တရားစကားဟှို ကြားရခီမာ ဝန်းသာအားရခံယူဘီး ဆင်ခြင်နှလောင်းသွမ်းဟှိကြောန့် တချို့ဟှ ဆသောင်းဆယ်၊ တချို့ဟှ ဆခြော့‑က်ဆယ်၊ တချို့ဟှ ဆတရာ သီးသီးဟှူ သူလေဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ယေရှုဟှာ တခြားပေါင်ဥပမာန မိန့်တော်မူဟှူဇာဟှာ “ကောန်းဂန်နိုင်ငံတော်ဟှာ ကောန်းဟှူမျိုးစေ့ဟှို လယ်ထဲမာ ကြဲမားနတူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","လယ်သမားလေ အိမွိနေခီမာ ရန်သူလာဘီးဟှာ ဂျောင်မျိုးစေ့လေကြားထဲမာ ဗြစ်စေ့လေဟှို ကြဲလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","အပန်လေပေါ့‑က်လာဘီး သီးနှံထွပ်လာခီမာ တောဗြစ်ပန်လေလည်း ထန်ရှားလာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","လယ်ဇရှင်ရဲ့ စေခံလေဟှ လယ်ဇရှင်နားဟှို လာဘီး ‘သခင်၊ ကျွန်တော်ဟှားလေဟှာ ကောန်းဟှူမျိုးစေ့ဟှို လယ်ထဲမာ ကြဲပါဟှယ်။ တောဗြစ်ပန်လေဟှ ဖယ်နေရာဟှ ရော့‑က်လာပါနူး’ ဆိုဘီး မေးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","လယ်ဇရှင်ဟှ ‘အယ်မျိုးဖြစ်ဇာဟှာ ရန်သူလောက်ဇာဖြစ်ဟှယ်’ ဆိုဘီး ပ္လန်ပြောလိုက်ဟှယ်။ စေခံလေဟှ ‘ကျွန်တော်ဟှားလေ သွားနှုပစ်ရဟှို့လော’ ဆိုဘီး မေးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","လယ်ဇရှင်ဟှ ‘နှုပစ်နအူး။ တောဗြစ်ပန်လေဟှို နှုဟှယ် ဆိုဟှာ ဗားဗန်လေလည်း ရောဘီးဟှာ နှုမိလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ဗားရိခီထိ တူးဒူကီးနေပါစေ။ ဗားရိကာလမာ ရင်ဦးဆောင်း တောဗြစ်ပန်လေဟှို ဝွီးနှုဘီးဟှာ မီးရှို့ဟှို့တွပ် ကြိုးနခယ်ဂေ့။ ဗားလေဟှို စုသီးဘီးဟှာ ဗားဂတ်ထဲဟှို ထဲ့ဂေ့’ ဆိုဘီး ဗားရိမားလေဟှို ငါပြောမယ် ဆိုဘီး လယ်ဇရှင်ဟှ ပြောလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ယေရှုဟှာ တခြားပေါင်ဥပမာအားဖြင့် “ကောန်းဂန်နိုင်ငံတော်ဟှာ လယ်ထဲမာစိုက်ဟှူ မုညင်းစေ့နတူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","မုညင်းစေ့ဟှာ စေ့လေ ဂူလောင်းထဲမာ ငယ်ဆောင်းဖြစ် ဘေမဲ့လည်း ကီးတတ်လာဟှူ ခီမာ ဗြစ်ပန်လေ ဂူလောင်းထဲမာ ကီးဆောင်း ဖြစ်ဟှယ်။ အယ်ကြောန့် ကောန်းဂန်ငှတ်လေဟှာ သစ်ကိုင်း သစ်ခပ်လေမာ သိုက်လောက်ဘီး ခိုနားနိုင်ဟှူ သစ်ပန်တဗန် ဖြစ်လာလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ယေရှုဟှာ တခြား ပေါင်ဥပမာအားဖြင့် “ကောန်းဂန်နိုင်ငံတော်ဟှာ တဆေးန တူဟှယ်။ မီးမ တယော့‑က်ဟှာ တဆေးဟှို ယူဘီး မုညစ် သောင်းတောန်းထဲဟှို ထဲ့လိုက်ဘီးဟှာ မုညစ် ဂူလောင်းဟှို ဖောန်းကြွစေတတ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ယေရှုဟှာ လူအောက်ဂီးဟှို အယ်မူကြောန်းရာလေဟှို ပေါင်ဥပမာလေအားဖြင့် ဟောပြောတော်မူဘီး ပေါင်ဥပမာပါဘဲန ဖြားကြောန်းရာလေဟှိုမှ ဟောပြောတော် မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ကိုယ်တော်ဟှာ အယ်မျိုး ဟောပြောဟှားဇာဟှ “ငါဟှာ ပေါင်ဥပမာလေဟှို သောင်းပြုဘီး သူးနို့ဟှို ငါပြောမယ်။ ကမ္ဘာဦးဟှနေဘီး ကွယ်ဝှပ်ဟှားဟှူဇာလေဟှို ဖော်ပြပေးမယ်” ဆိုဘီး ပရောဖက်ပြောဟှားဇာ ပ္လဲ့ဇောင်ဟှို့တွပ် ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","အယ်ဘီးန ယေရှုဟှာ တရားတော်ဟှို ဆောင်းသတ်ဘီးဟှာ အီထဲဟှို ဝမ်လေဟှယ်။ တဗဲ့တော်လေလည်း ကိုယ်တော်နားဟှို လာဂေ့ဘီးဟှာ “လယ်ထဲမာကြဲဟှူ ဗြစ်စေ့ရဲ့ ပေါင်ဥပမာဟှို ကျွန်တော်ဟှားလေဟှို ပြောပြပေးပါ” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ယေရှုဟှ “ကောန်းဟှူ မျိုးစေ့ဟှို ကြဲမားဟှာ လူ့ရဲ့သား ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","လယ်ဟှာ အယ်လောကဖြစ်ဟှယ်။ ကောန်းဟှူ မျိုးစေ့ဟှ နိုင်ငံတော်သား ဖြစ်ဟှယ်။ ဗြစ်စေ့ဟှာ နတ်ဆိုးရဲ့ သားလေဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ဗြစ်စေ့ဟှို ကြဲဟှူ ရန်သူဟှာ မာရ်နတ် ဖြစ်ဟှယ်။ ဗားရိဟှူ ကာလဟှာ အယ်ကမ္ဘာကူဆောင်းဟှူ ခီမာ ဖြစ်ဘီး ဗားရိမားလေဟှာ ကောန်းဂန်တမန်လေ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","တောဗြစ်ပန်လေဟှို စုသီးဘီးဟှာ မီးရှို့ဟှူမျိုး ကမ္ဘာကူဆောင်းဟှူ ခီမာ ဖြစ်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","လူ့ရဲ့သားဟှာ သူ့ရဲ့ ကောန်းဂန်တမန်လေဟှို စေလွှတ်ဘီးဟှာ လူလေဟှို လမ်းလွဲဘီး မှားယွင်းအောန်လောက်ဟှူ သူလေန တရားဘဲဟှူ သူလေ ဂူလောင်းဟှို နိုင်ငံတော်ထဲဟှ ဝီးထုဘီးဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","တော့‑က်လောန်နေဟှူ မီးဖိုထဲဟှို ပစ်ခ္လစေတော်မူမယ်။ အယ်သူလေလည်း အံသွားခဲက္လိဘီး ငိုကြွေးရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","အယ်ဘီးန ဖြောန့်မတ်ဟှူ လူလေဟှာ သူးနို့ရဲ့ ဖနိုင်ငံတော်မာ နေတော့‑က်ပမျိုး တော့‑က်ပလေ့မယ်။ နန်းနို့မာ နားရှိဟှယ် ဆိုဟှာ ကြားဂေ့! ");
INSERT INTO tvn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ကောန်းဂန်နိုင်ငံတော်ဟှာ လယ်ထဲမာဝှပ်ဟှားဟှူ ဘဏ္ဍာနတူလေဟှယ်။ လူတယော‑က်ဟှာ ဘဏ္ဍာဟှို တွိဟှူ ခီမာ ပ္လန်ဖောင်းအောက်ဘီး ဝန်းသာအားရန ပ္လန်ဟှားဘီး သူမာရှိဟှူ ပစ်စီးလေ ဂူလောင်းဟှို ရောန်းဘီးဟှာ အယ်လယ်ဟှို ဝယ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“အယ်ဘီးဟှာ ကောန်းဂန်နိုင်ငံတော်ဟှာ ကောန်းဟှူ ပုလဲဟှို ရှာနေဟှူ ကူသယ်န တူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","အယ်မူကူသယ်ဟှာ ကောန်းဟှူ ပုလဲဟှို တွိရဟှူ ခီမာ သူ့မာရှိဇာ ဂူလောင်းဟှို ရောန်းဘီးဟှာ အယ်ပုလဲဟှို ဝယ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“အယ်ဘီးဟှာ ကောန်းဂန်နိုင်ငံတော်ဟှာ ပန်လယ်ထဲဟှ ငါးလေဟှို ဖမ်းဟှူပိုက်ကွန်နတူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ပိုက်ကွန်ထဲမာ ငါးလေပ္လဲ့ဟှားခီမာ ငါးဖမ်းမားလေဟှ ကူးထပ်ဟှို ဆွဲဒန်ဘီး ကောန်းဟှူငါးလေဟှို တောန်းထဲမာ ဝီးထဲ့ဘီးဟှာ ကောန်းဘဲဟှူငါးလေဟှို ပ္လန်ဟှို ပစ်ထုလိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","အယ်မူတိုင်းဘဲ့ ကပ်ကမ္ဘာကူဆောင်းဟှူ ခီမာ ကောန်းဂန်တမန်လေ ဆင်းလာဘီး ဖြောန့်မတ်ဟှူသူလေထဲဟှ ဆိုးယောက်ဟှူသူလေဟှို ခွဲထုဘီးဟှာ ");
INSERT INTO tvn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","တော့‑က်လောန်နေဟှူ မီးဖိုထဲဟှို ပစ်ခ္လလေ့မယ်။ အယ်သူလေဟှာ အံသွားခဲက္လိဘီး ငိုကြွေးရဂေ့လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ယေရှုဟှ “အယ်ကြောန်းရာလေ ဂူလောင်းဟှို နန်းနို့လေ နားလည်ဂေ့ဘဲ့လော” ဆိုဘီး မေးတော်မူလိုက်ဟှယ်။ တဗဲ့တော်လေဟှ “နားလည်ပါဘီ သခင်” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ကိုယ်တော်ဟှ “အယ်မူဇာဟှာ ကောန်းဂန်နိုင်ငံတော်ရဲ့ ကြောန်းရာဟှို သန်ယူဘီး တဗဲ့ဖြစ်လာဟှူ ကျမ်းပြုဆရာဟှာ ကိုယ့်ရဲ့ ဘဏ္ဍာတိုက်ထဲဟှ ပစ်စီးသစ်န ပစ်စီးဟောန်းလေဟှို ထုယူတတ်ဟှူ အီရှင်နတူလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","အယ်ပေါင်ဥပမာလေဟှို ယေရှု မိန့်တော်မူဘီးန ကိုယ်တော်ဟှာ အယ်ရပ်ဟှနေ ထွပ်ဟှားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","နေထိုင်ဟှူ ဗြို့ဟှို ပ္လန်ကြွဟှားတော်မူဟှယ်။ ကိုယ်တော်ဟှာ ဝါလယ်ဇရပ်မာ သွန်သန်လေဟှယ်။ အယ်မူဇာဟှို ကြားရဟှူ လူလေလည်း အံ့ဩဂေ့ဟှယ်။ “အယ်သူဟှာ အယ်ပညာဟှို ဖယ်ဟှရလာနူး။ အယ်နိမိတ်လတ်ခဏာလေလည်း ဖယ်ဟှရလာနူး။ ");
INSERT INTO tvn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","သူဟှာ လတ်သမားရဲ့သား မှုဟှလော။ သူ့မိဟှာ မာရိ မှုဟှလော။ သူ့ညီလေဟှာ ယာကုပ်၊ ယောသပ်၊ ရှိမုန်၊ ယုဒ မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","သူ့ရဲ့ညီမလေလည်း နို့လေနားမာ နေဂေ့ဟှယ် မှုဟှလော။ အယ်ဆိုဟှာ အယ်သူဟှာ အယ်နိမိတ်လတ်ခဏာလေဟှို ဖယ်ဟှရလာနူး” ဆိုဘီး သူးနို့ဟှ မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","အယ်ကြောန့် သူးနို့ဟှာ ကိုယ်တော့်ဟှို ငြင်းပယ်ဂေ့လေဟှယ်။ ယေရှုဟှ “ပရောဖက်ဟှာ ကိုယ့်ဗြို့ ကိုယ့်အီဟှနေလွဲဘီး နေရာတိုင်းမာ လေးစားခံရဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","အယ်သူလေဟှာ ယောင်ကြည်ဘဲကြောန့် ကိုယ်တော်ဟှာ အယ်နေရာမာ အံ့ဘွယ်တဂိုးလေဟှို ဘောင်ဂီးပြတော်မူဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","အယ်ခီမာ ဂါလိလဲပြည်ဟှို အောက်ချောက်ဟှူ ဟေရုဒ်ဟှာ ယေရှုရဲ့ ဒန်းဟှို ကြားရဟှူ ခီမာ၊ ");
INSERT INTO tvn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“အယ်သူဟှာ ဗတ္တိဇံယောဟန်ဘဲ့ ဖြစ်ဟှယ်။ သူဟှာ သေရာဟှနေ ပ္လန်ရှင်လာဘီ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နိမိတ်လတ်ခဏာလေ ပြဟှို့တွပ် အယ်တဂိုးဟှာ သူ့မာရှိနေဟှယ်” ဆိုဘီး သူ့ရဲ့ စေခံလေဟှို ပြောဆိုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ဟေရုဒ်ဟှာ သူ့ညီ ဖိလိပ္ပုရဲ့ မယား ဟေရောဒိကြောန့် ယောဟန်ဟှို ဖမ်းဘီးဟှာ ထောန်ထဲမာ ချောက်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ယောဟန်ဟှ “မန်းဂီးဟှာ ကိုယ့်ညီရဲ့ မယားဟှို သီးယူဇာဟှာ ပညတ်တော်နညီဟှ!” ဆိုဘီးဟှာ ဟေရုဒ်ဟှို ပြောဟှားဖူးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ဟေရုဒ်ဟှာ ယောဟန်ဟှို သတ်ရှင်ဘေမဲ့ ယုဒလူလေဟှို ကြော့‑က်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ယုဒလူလေဟှာ ယောဟန်ဟှို ပရောဖက်တပါး ဖြစ်ဟှယ် ဆိုဘီး မှတ်ယူဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ဟေရုဒ်ရဲ့ မွီးနေ့မာ ဟေရောဒိရဲ့ မီးဟှာ ဧည့်သယ်လေရှေ့မာ ကပြလေဟှယ်။ ဟေရုဒ်ဟှာ ရရာတိုင်း ကျေနပ်ဟှားဘီး ");
INSERT INTO tvn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","“နန်တောန်းဟှူမျှ ငါပေးမယ်!” ဆိုဘီး သစ်စာန ဂဒိပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","အယ်မီးမငယ်ဟှလည်း သူ့မိ တောန်းခိုင်းဟှူတိုင်း “ဗတ္တိဇံယောဟန်ရဲ့ ခေါန်းဟှို လန်းဗန်းထဲမာ ထဲ့ပေးတော်မူပါ!” ဆိုဘီး တောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","မန်းဂီးဟှာ စိကောန်းဘဲ ဖြစ်ဟှားဘေမဲ့လည်း ဧည့်သယ်လေရှေ့မာ ပေးမယ် ဆိုဘီး ကီဆိုဟှူတိုင်း ပေးဟှို့တွပ် မိန့်ခ္လလိုက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","အယ်ကြောန့် စောန့်တယော့‑က်ဟှို စေလွှတ်ဘီးဟှာ ယောဟန်ရဲ့ ခေါန်းဟှို ထောန်ထဲမာ ဖြတ်စေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ခေါန်းဟှို လန်းဗန်းထတ်မာ တန်ဘီးဟှာ ယူဆောန်လာဘီး မီးမငယ်ဟှို ပေးလိုက်ဟှယ်။ အယ်မီးမငယ်လည်း သူ့မိနားဟှို ယူဆောန်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ယောဟန်ရဲ့ တဗဲ့လေဟှာ လောန်းဟှို ယူဘီး သင်္ဂြိုဟ်လေဟှယ်။ အယ်ဘီးမှ ယေရှုနားဟှို သွားဘီး ပြောပြဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","အယ်ဒန်းဟှို ယေရှုကြားရဟှူ ခီမာ လူသူကင်းရှင်းဟှူ နေရာဟှို လှေစီးဘီး ကြွဟှားလေဟှယ်။ ဗြို့ဝါလေဟှ လူလေလည်း အယ်ကြောန်းဟှို ကြားရဂေ့ကြောန့် နော့‑က်တော်ဟှို ကူးကြောန်းလိုက်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ယေရှုဟှာ လှေဟှနေ ဆင်းလိုက်ဘီး လူအောက်ဂီးဟှို ဗြင်ရခီမာ သူးနို့ဟှို သနားဟှူစိ ရှိတော်မူဘီး ဖျားနာနေဟှူလူလေ ဂူလောင်းဟှို ကျန်းမာစေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","နေဒန်ဇာ ရော့‑က်လာဟှူ ခီမာ တဗဲ့တော်လေဟှာ ကိုယ်တော်နားဟှို လာဘီး “အယ်နေရာဟှာ လူသူကင်းဝီးဟှူ နေရာဖြစ်ဘီး ခီလည်း နော့‑က်က္လဟှားဘီ။ လူလေဟှို စေလွှတ်ဘီးဟှာ ဝါလေမာ စားဇာဝယ်ခိုင်းဟှို့တွပ် သွားခွမ့်ပေးပါ” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ယေရှုဟှ “သူးနို့လေ သွားဇာလိုဟှ။ အယ်သူလေစားဟှို့ စားဇာဟှို နန်းနို့လေ ကိုယ်တိုင် ပေးဂေ့ပါ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","တဗဲ့တော်လေဟှ “မုငါးလောင်းန ငါးနှေ့ကောန်ဘဲ့ ကျွန်တော်ဟှားလေမာ ရှိပါဟှယ်” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ယေရှုဟှ “အယ်မုန ငါးဟှို ယူလာပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ကိုယ်တော်ဟှ လူလေဟှို ဗြစ်ပ္လန်ထတ်မာ ထိုင်ဟှို့ မိန့်တော်မူဘီးန မုငါးလောင်းန ငါးနှေ့ကောန်ဟှို ယူဘီး ကောန်းဂန်ထတ်ဟှို မျှော်ကေ့ဘီးဟှာ ဘုရားသခင်ဟှို ကျေးဇူးတော် ချီးမွမ်းလေဟှယ်။ အယ်ဘီးမှ မုန ငါးဟှို ဖဲ့ဘီး တဗဲ့တော်လေဟှို ပေးလေဟှယ်။ တဗဲ့တော်လေဟှလည်း လူလေဟှို ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","လူလေဂူလောင်းဟှာ စားဘီး ဗိုက်ပ္လဲ့ဟှားဟှယ်။ အယ်ဘီးန တဗဲ့တော်လေဟှာ စားဘီး ကျန်ဇာလေဟှို စုသီးလိုက်ဇာ ဆယ့်နှေ့တောန်းပ္လဲ့ ရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","မီးမန သားဂန်းဟှားလေပါဘဲန စားဂေ့ဟှူ ယော့‑က်ကျား ရေတွပ်ဟှာ ၅,၀၀၀ လော့‑က် ရှိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","အယ်ဘီးန ယေရှုဟှာ လူလေဟှို ပ္လန်လွှတ်လိုက်ခီမာ တဗဲ့တော်လေဟှိုလည်း လှေထတ်ဟှို တတ်စေဘီး ဟှိုဖတ်ကမ်းဟှို ရင်ဦးဆောင်း ကူးစေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ယေရှုဟှာ လူလေ ပ္လန်ဟှားဂေ့ဘီးန ဆုတောန်းဟှို့တွပ် တောန်ထတ်ဟှို ယော့‑က်ဒဲ တတ်ဟှားတော်မူဟှယ်။ နေဒန်ဇာ ရော့‑က်လာဟှူ ခီမာ အယ်နေရာမာ ယေရှုတပါးဒဲ ရှိတော်မူဘီး ");
INSERT INTO tvn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","တဗဲ့တော်လေရဲ့ လှေဟှလည်း ကမ်းန ရရာတိုင်း ကွာဟှားဘီး လေဆန်ဘီး လာနေကြောန့် လှိုင်းလေရဲ့ ရိုက်ခတ်ဇာဟှို ခံရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","မိုးသာထပိုင်းမာ ယေရှုဟှာ ရေထတ်မာ လမ်းရှော့‑က်ဘီး တဗဲ့တော်လေနားဟှို ကြွလာတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","တဗဲ့တော်လေဟှာ ရေထတ်မာ လမ်းရှော့‑က်နေဟှူ ကိုယ်တော့်ဟှို ဗြင်ဟှူ ခီမာ ရရာတိုင်း ကြော့‑က်လန့်ဟှားဂေ့ဘီး “ဖုကသေ!” ဆိုဘီး အော်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ယေရှုဟှ “စိုးရိမ်ဂေ့န! ငါဘဲ့ဖြစ်ဟှယ်။ ကြော့‑က်ဂေ့န!” ဆိုဘီး သူးနို့ဟှို ရှစ်ရှင်းဘဲ့ မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ပေတရုဟှ “သခင်၊ ကိုယ်တော်မှန်ဟှယ် ဆိုဟှာ ကျွန်တော်လည်း ရေထတ်မာ လမ်းရှော့‑က်ဘီး ကိုယ်တော်နားဟှို လာဟှို့ မိန့်တော်မူပါ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ယေရှုဟှ “လာပါ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်ကြောန့် ပေတရုဟှာ လှေထတ်ဟှဆင်းဘီး ရေထပ်မာ လမ်းရှော့‑က်ဟှားဘီး ယေရှုနားဟှို သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","အယ်ဘေမဲ့ ကြမ်းထန်းဟှူလေဟှို ဗြင်ဟှူ ခီမာ ကြော့‑က်လန့်ဟှားဘီး ရေထဲဟှို နစ်မ္လုစပြုဟှားဟှယ်။ “သခင်၊ ကျွန်တော်ဟှို ကယ်တော်မူပါ!” ဆိုဘီး အော်ဟစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ယေရှုဟှ ရှစ်ရှင်းဘဲ လတ်တော်ဟှို ဆန့်ဘီးဟှာ ပေတရုဟှို ဆွဲကိုင်ဘီး “ယောင်ကြည်ရှင်း အားနဲဟှူလူ! ဖြားဖြစ်ကြောန့် ယောင်မှားဟှူ စိဖြစ်ရနူး” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","သူးနို့နှေ့ယော့‑က်ဟှာ လှေထတ်ဟှို ရော့‑က်ဟှားဘီးန လေဟှာ ငြီဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","လှေထဲမာ ရှိဟှူ တဗဲ့တော်လေဟှလည်း ယေရှုဟှို ရှိခိုးလေဟှယ်။ “ကိုယ်တော်ဟှာ တကယ်ဘဲ့ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်ဟှယ်!” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","သူးနို့ဟှာ အိုင်ဟှို ကူးဟှားဂေ့ဘီး ဂင်နေသရက်ဗြို့ဟှို ရော့‑က်လာဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","အယ်နေရာဟှ လူလေဟှာ ယေရှုဟှို မှတ်မိဂေ့ဟှယ်။ အယ်ကြောန့် သူးနို့ဟှာ လူလေဟှို စေလွှတ်ဘီး ပတ်ဝန်းကျင် ရပ်ရပ်မာရှိဟှူ လူနာလေရှိဟှူမျှဟှို ယေရှုနားဟှို ခေါ်လာဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","လူနာလေဟှလည်း ကိုယ်တော်ရဲ့ ဝတ်လောင်ရဲ့ ပန်းဗွားဟှိုဘဲ့ တို့ထိခွမ့်ပေးဟှို့တွပ် တောန်းဗန်ဂေ့လေဟှယ်။ အယ်ဘီးဟှာ တို့ထိဟှူလူလေ ဂူလောင်းလည်း ကျန်းမာရဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","အယ်ဘီးန ယေရုရှလင်ဗြို့ဟှ ဖာရိရှဲတချို့န ကျမ်းပြုဆရာတချို့ဟှာ ယေရှုနားဟှို လာဘီးဟှာ ");
INSERT INTO tvn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ကိုယ်တော်ရဲ့ တဗဲ့တော်လေဟှာ ရှေးလူဂီးလေရဲ့ ထောင်းဒန်းစဉ်လာလေဟှို ဖြားဖြစ်ကြောန့် ခ္လိုးဖော့‑က်ဂေ့ပါနူး။ သူးနို့ဟှာ လက်ဆေးဘဲန စာစားလေဟှယ်!” ဆိုဘီး ကိုယ်တော့်ဟှို မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ကိုယ်တော်ဟှ “ဖြားဖြစ်ကြောန့် ဘုရားသခင်ရဲ့ ပညတ်တော်ဟှို ခ္လိုးဖော့‑က်ဘီးဟှာ နန်းနို့လေရဲ့ ထောင်းဒန်းစဉ်လာလေဟှို လိုက်နာကျင့်သောင်းဂေ့နူး။ ");
INSERT INTO tvn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဘုရားသခင်ရဲ့ ပညတ်တော်ဟှ ‘မိဖဟှို ရိုသေပါ။ မိဖဟှို ကီဆဲဟှူ သူဟှာ သေဒန်က္လခံစေ’ ဆိုဘီး မိန့်တော်မူဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","အယ်ဘေမဲ့ နန်းနို့လေ သွန်သန်ဇာဟှ တဇောင်တယော့‑က်ဟှာ ကိုယ့်ဖ အယ်မျိုးမှုဘဲနေဟှာ ကိုယ့်မိဟှို ပေးကမ်းထော့‑က်ပံ့ဟှို့တွပ် ပစ်စီး အောက်စာလေရှိဟှူ လည်းဘဲ့ အယ်ပစ်စီး အောက်စာလေဟှာ ‘ဘုရားသခင်တွပ် လှူဝတ္ထုဖြစ်ဟှယ် ဆိုဘီး ပြောလေဟှယ်။’ ");
INSERT INTO tvn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","အယ်သူဟှာ ကိုယ့်ဖဟှို ဂေါင်ပြုဟှို့လိုအပ်ဟှ ဆိုဘီး သွန်သန်ပေးလေဟှယ်။ အယ်မျိုးဘဲ့ နန်းနို့လေဟှာ နန်းနို့ရဲ့ ထောင်းဒန်းစဉ်လာလေတွပ် ဘုရားသခင်ရဲ့ ပညတ်တော်ဟှို ပယ်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","သူတော်ကောန်း ယောန်ဆောန်ဟှူသူလေ! နန်းနိုလေ ကြောန်းဟှို ဘုရားသခင်ဟှာ ဟေရှာယအားဖြင့် ပရောဖက်ပြုဟှားဇာဟှ ");
INSERT INTO tvn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘အယ်လူလေဟှာ သူးနို့ရဲ့ နှောက်န ငါ့ဟှို ရိုသေလေဟှယ်။ သူးနို့ရဲ့ စိနှလောင်းဟှာ ငါ့န ဝီးလှဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","သူးနို့ဟှာ ငါ့ဟှို အလဂါး သတ်သတ် ကိုးကွယ်ဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လူလေရဲ့ ပညတ်လေဟှို ဩဝါဒလေဖြစ် သွန်သန်ပေးကြောန့်ဖြစ်ဟှယ်!’” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","အယ်ဘီးမှ ယေရှုဟှာ လူအောက်ဂီးဟှို သူ့နားဟှို ခေါ်ဘီးဟှာ “နားထောန်ဘီး နားလည်ဂေ့ပါ! ");
INSERT INTO tvn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","လူဟှို ညစ်ညူးစေဟှူဇာလေဟှာ လူ့ရဲ့ဇပ်ပေါ့‑က်ထဲဟှို ဝမ်ဟှူဇာလေ မှုဟှ။ လူ့ရဲ့ဇပ်ပေါ့‑က်ထဲဟှ ထွပ်လာဟှူဇာလေဟှဘဲ့ လူဟှို ညစ်ညူးစေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","တဗဲ့တော်လေဟှာ ကိုယ်တော်နားဟှို လာဘီးဟှ “ဖာရိရှဲလေဟှာ မိန့်တော်မူဟှူ စကားဟှို ကြားဘီး မျစ်ဖြစ်ဟှားဂေ့ဇာဟှို ကိုယ်တော်သိဘဲ့လော” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ကိုယ်တော်ဟှလည်း “ကောန်းဂန်ဘောင်ဟှ ငါရဲ့ဖ စိုက်ပျိုးဘဲဟှူပန်လေ ဂူလောင်းဟှို ပြစ်ဟှနေ နှုပစ်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","သူးနို့လေဟှို စိုးရိမ်ဂေ့န! သူးနို့လေဟှာ လူကန်းဟှို လမ်းပြဟှူ လူကန်းလေဘဲ့ဖြစ်ဟှယ်။ လူကန်းဟှ လူကန်းဟှို လမ်းပြမယ် ဆိုဟှာ နှေ့ယော့‑က်လောင်း တွမ်းထဲဟှို က္လလေ့မယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ပေတရုဟှ “အယ်ပေါင်ဥပမာဟှို ကျွန်တော်ဟှားလေဟှို ရှင်းပြတော်မူပါ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ယေရှုဟှ “နန်းနို့လေဟှာ ခုခီထိ ဉာဏ်ပညာမဲ့နေသေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","လူ့ရဲ့ဇပ်ပေါ့‑က်ထဲဟှို ဝမ်ဟှူဇာလေဟှာ စာအီထဲဟှို ရော့‑က်ဟှားဘီးဟှာ နော့‑က်ဖေးအီထဲဟှို စွန့်ပစ်လိုက်ဟှယ် ဆိုဇာဟှို နန်းနို့လေ နားလည်သေးဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ဇပ်ပေါ့‑က်ထဲဟှ ထွပ်လာဟှူဇာလေဟှာ နှလောင်းထဲဟှ ထွပ်လာဘီး လူဟှို ညစ်ညူးစေတတ်ဟှူဇာလေ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ကောန်းဘဲဟှူကြံစည်ရှင်း၊ လူ့သတ်ရှင်း၊ အီထောန်ရေးဖော့‑က်ပ္လန်ရှင်း၊ ကာမဂုဏ်လိုက်စားရှင်း၊ ခိုးယူရှင်း၊ မှန်ဘဲဟှူသတ်သေခံရှင်း၊ သူများဟှိုစော်ကားရှင်းလေဟှာ နှလောင်းထဲဟှ ထွပ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","အယ်မူဇာလေဟှာ လူဟှို ညစ်ညူးစေဇာလေ ဖြစ်ဟှယ်။ အယ်ဘေမဲ့ လတ်ဆေးဘဲန စာစားဇာဟှာ လူဟှို ညစ်ညူးစေဇာ မှုဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ယေရှုဟှာ အယ်မူရပ်ဟှနေ ထွပ်ခွာတော်မူဘီးဟှာ တုရုဗြို့န ဇိဒုန်ဗြို့ရဲ့ ကျေးဝါလေဟှို ကြွဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","အယ်ဒေသမာနေဟှူ ခါနာန်လူမျိုးဖြစ်ဟှူ မီးမတယော့‑က်ဟှာ ကိုယ်တော်နားဟှို လာဘီး “သခင်၊ ဒါဝိဒ်ရဲ့သားတော်! ကျွန်မဟှို သနားတော်မူပါ! ကျွန်မသမီးဟှာ နတ်ဆိုးဝမ်ဘီး ရရာတိုင်း နှိစစ်ခံနေရပါဟှယ်” ဆိုဘီး အော်ဟစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","အယ်ဘေမဲ့ ကိုယ်တော်ဟှာ စကားတခွန်းလည်း ပ္လန်ပြောဟှ။ တဗဲ့တော်လေဟှာ ကိုယ်တော်နားဟှို လာဘီးဟှာ “အယ်မီးမဟှို ဝီးဂီးဟှို သွားစေတော်မူပါ! သူဟှာ အော်ဟစ်ဆူညံဘီး နော့‑က်ဟှနေ လိုက်နေပါဟှယ်!” ဆိုဘီး တောန်းလျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ကိုယ်တော်ဟှ “ငါဟှာ ဣသရေလလူမျိုးလေရဲ့ ပျော့‑က်နေဟှူ သိုးလေနားဟှိုဘဲ့ စေလွတ်ရှင်းခံရဟှယ်” ဆိုဘီး ပ္လန်ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","အယ်မီးမဟှာ လာဘီး ကိုယ်တော်ရှေ့မာ ပျပ်ဝပ်ဘီး “သခင်၊ ကျွန်မဟှို ကယ်မတော်မူပါ!” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ယေရှုဟှ “သားမီးလေရဲ့ စားဇာဟှို ယူဘီးဟှာ ခွီးဟှို ကျွေးအပ်ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","အယ်မီးမဟှလည်း “မှန်ပါဟှယ်သခင်၊ ခွီးလေဟှာ သူးနို့သခင်ရဲ့ စားဗွဲဟှ က္လလာဟှူ စားကြွင်းစားကျန်လေဟှို စားရဂေ့ပါဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","အယ်ကြောန့် ယေရှုဟှ “နန်ဟှာ ယောင်ကြည်မှုကီးမားဟှူ မီးမဖြစ်ဟှယ်! နန့်အလိုရှိဟှူတိုင်း နန့်မာဖြစ်စေ” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ အယ်ခီမာဘဲ့ အယ်မီးမရဲ့ သမီးဟှာ ကျန်းမာဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ယေရှုဟှာ အယ်ရပ်ဟှနေ ထွပ်ဟှားဘီးဟှာ ဂါလိလဲအိုင်နားဟှို ကြွဟှားဘီးန တောန်ထတ်ဟှိုတတ်ဘီး ထိုင်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","လူအောက်ဂီးဟှာ ကိုယ်တော်နားဟှို လာဘီး ခေသန်ဘဲသူလေ၊ မျစ်စိဗြင်ဘဲသူလေ၊ ကိုယ်အင်္ဂါချို့တဲ့သူလေ၊ စကားအဟှူ သူလေန တခြားရောဂါသယ်လေ ရှိဟှူမျှဟှို ခေါ်ဆောန်လာဘီးဟှာ ယေရှုရဲ့ ခေတော်ရင်းမာ ခ္လဟှားဂေ့ဟှယ်။ ကိုယ်တော်ဟှာ သူးနို့ဟှို ကျန်းမာစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","စကားအဟှူ သူလေဟှာ စကားပြောလာဟှယ်။ ခေသန်ဘဲဟှူ သူလေဟှာ လမ်းရှော့‑က်လာဟှယ်။ မျစ်စိကန်းဟှူ သူလေဟှာ ဗြင်လာဂေ့ဇာဟှို ကေ့နေဟှူ လူအောက်ဂီးဟှာ ရရာတိုင်း အံ့ဩဟှားဂေ့ဘီး ဣသရေလ လူမျိုးလေရဲ့ ဘုရားသခင်ဟှို ချီးမွမ်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ယေရှုဟှာ တဗဲ့တော်လေဟှို သူ့နားဟှို ခေါ်ဘီးဟှာ “အယ်လူလေဟှို ငါသနားဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့ဟှာ သောင်းရစ်လောင်းလောင်း ငါနတူးဒူ နေဂေ့ဘီး သူးနို့မာလည်း စားဟှို့မှေ့ဘီ။ သူးနို့ဟှို ဖြားဇာလည်းကျွေးဘဲန ပ္လန်ဟှားဇာဟှို ငါလိုရှင်ဟှ။ အယ်မျိုးပ္လန်စေမယ် ဆိုဟှာ လမ်းမာအားပြတ်ဂေ့မယ်” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","တဗဲ့တော်လေဟှ “အယ်လူအောက်ဂီးဟှို ဝအောန်ကျွေးဟှို့တွပ် ကျွန်တော်ဟှားလေဟှာ အယ်တောထဲမာ ဖယ်မျိုးရနိုင်ဟှို့နူး” ဆိုဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ယေရှုဟှ “နန်းနို့လေမာ မုဖယ်လော့‑က်ရှိနူး” ဆိုဘီး မေးလိုက်ခီမာ သူးနို့ဟှ “မုခွန်နှေ့လောင်းန ငါးနဲနဲဟှားရှိပါဟှယ်” ဆိုဘီး ပ္လန်လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","အယ်ကြောန့် ယေရှုဟှ လူအောက်ဂီးဟှို မ္လေဂီးထတ်မာထိုင်နေဟှို့ မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","မုခွန်နှေ့လောင်းန ငါးဟှိုယူဘီးဟှာ ဘုရားသခင်ဟှို ကျေးဇူးချီးမွမ်းဘီးန မုနငါးဟှို ဖဲ့ဘီးဟှာ တဗဲ့တော်လေဟှို ပေးဟှယ်။ တဗဲ့တော်လေဟှလည်း လူလေဟှို ပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","သူးနို့လေ ဂူလောင်းဟှာ စားဘီးဟှာ ဗိုက်ပ္လဲ့ဟှားဂေ့ဟှယ်။ အယ်ဘီးန တဗဲ့တော်လေဟှာ ကြွင်းကျန်လေဟှို ကော့‑က်သီးလိုက်ဟှူဇာ ခွန်နှေ့တောန်းပ္လဲ့ ရဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","စားဟှူသူလေဟှာ မီးမန သားဂန်းဟှားလေပါဘဲန ယော့‑က်ကျားလေဘဲ့ ၄,၀၀၀ ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","အယ်ဘီးန ယေရှုဟှာ လူလေဟှို ပ္လန်လွှတ်ဘီးန လှေစီးဘီး မာဂဒလဝါဟှို ကြွဟှားတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ဖာရိရှဲတချို့န ဇဒ္ဒုကဲတချို့ဟှာ ယေရှုဟှို စမ်းသပ်ရှင်ဂေ့ဟှူကြောန့် နားဟှို လာဂေ့ဘီးဟှာ “ကောန်းဂန်ဘောင်ဟှ နိမိတ်လတ်ခဏာဟှို ပြပေးတော်မူပါ” ဆိုဘီး တောန်းဆိုဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","အယ်ဘေမဲ့ ယေရှုဟှ “နန်းနို့လေဟှာ နေဝမ်ဟှူ ခီမာ ‘ကောန်းဂန်ဟှာ နီနေဟှယ် ဆိုဟှာ ရာသီဥတု သာယာလေ့မယ်’ ဆိုဘီး ပြောတတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","အယ်ဘီးဟှာ မိုးလန်းစောစောဂီးမာလည်း ‘ကောန်းဂန်ဟှာ နီဘီး မှောန်နေကြောန့် အယ်နေ့ မုန်တိုင်းတိုက်လေ့မယ်’ ဆိုဘီး ပြောတတ်ဂေ့လေဟှယ်။ နန်းနို့လေဟှာ ကောန်းဂန် ခြေနေကေ့ဘီးဟှာ ရာသီဥတုဟှို ခန့်မှန်းနိုင်ဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ဟှာ အယ်ကပ်ကာလရဲ့ နိမိတ်လတ်ခဏာလေဟှို ပိုင်းခြားနိုင်ဂေ့ဟှ! ");
INSERT INTO tvn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ဆိုးညစ်ဘီး ဖောက်ပ္လန်ဟှူအမျိုးဟှာ နိမိတ်လတ်ခဏာ တောန်းဟှူလည်းဘဲ့၊ ယောနရဲ့ နိမိတ်လတ်ခဏာဟှလွဲဘီး ဖယ်မျိုးနိမိတ်လတ်ခဏာလေဟှိုမှ ပြဟှို့မှုဟှ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်ဘီးန ကိုယ်တော်ဟှာ အယ်သူလေနားဟှနေ ထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","တဗဲ့တော်လေဟှာ အိုင်ရဲ့ဟှို့ဖတ်ကမ်းဟှို ကူးဟှားခီမာ စားဇာလေဟှို ယူလာဟှို့တွပ် မေ့ဟှားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ယေရှုဟှ “နန်းနို့လေဟှာ ဖာရိရှဲန ဇဒ္ဒုကဲလေရဲ့ တဆေးဟှို ဒိထားဘီး ရှောန်ဂေ့ပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","တဗဲ့တော်လေဟှာ “နို့လေဟှာ စားဇာသယ်လာဘဲဟှိကြောန့် အယ်မျိုး မိန့်တော်မူဇာဖြစ်ဟှယ်” ဆိုဘီး သူးနို့ရှင်းရှင်း ပြောဆိုဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","အယ်မျိုး ပြောနေဂေ့ဟှူဇာဟှို ယေရှုသိတော်မူဟှူ ခီမာ “ယောင်ကြည်ရှင်း အားနဲဟှူလူလေ! နန်းနို့လေဟှာ စားဇာပါလာဘဲဟှူ ကြောန်းဟှို ဖြားဖြစ်ကြောန့် ဆွေးနွေး ပြောဆိုနေဂေ့နူး။ ");
INSERT INTO tvn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","နန်းနို့လေဟှာ ခုခီထိ နားလည်သေးဟှလော။ မုငါးလောင်းဟှို လူ ၅,၀၀၀ စားဘီး၊ ဖယ်လော့‑က်တောန်း ကော့‑က်သီးရဂေ့ဟှူဇာန၊ ");
INSERT INTO tvn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","မုခွန်နစ်လောင်းဟှို လူ ၄,၀၀၀ စားဘီး၊ ဖယ်လော့‑က်တောန်း ကော့‑က်သီးရဟှူဇာဟှို မှတ်မိဂေ့ဟှမ်းလော။ ");
INSERT INTO tvn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","မုကြောန်းဟှို နန်းနို့လေဟှို ပြောနေဇာ မှုဟှ ဆိုဇာဟှို ဖြားဖြစ်ကြောန့် နန်းနို့နားလည်ဂေ့ဘဲနေနူး၊ ဖာရိရှဲန ဇဒ္ဒုကဲလေရဲ့ တဆေးဟှို ဒိနရှောန်ဂေ့!” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","အယ်ဘီးန တဗဲ့တော်လေဟှာ မုမာသောင်းပြုဟှူ တဆေးဟှို ရှောန်ရဟှို့မှုဘဲန ဖာရိရှဲန ဇဒ္ဒုကဲလေရဲ့ ဩဝါဒဟှို ဒိထားဟှို့ မိန့်တော်မူကြောန်း နားလည်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ယေရှုဟှာ ကဲသရိဖိလိပ္ပိနယ်ဟှို ကြွဟှားဘီး အယ်နေရာမာ တဗဲ့တော်လေဟှို “လူလေဟှာ လူ့ရဲ့သားဟှို ဖယ်သူဖြစ်ဟှယ် ဆိုဘီး ပြောဆိုဂေ့နူး” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“တချို့လူလေဟှ ကိုယ်တော်ဟှာ ဗတ္တိဇံယောဟန်ဖြစ်ဟှယ်။ တချို့ဟှ ဧလိယဖြစ်ဟှယ်။ တချို့လေဟှ ယေရမိ မှုဘဲနေဟှာ ပရောဖက်ဖြစ်ဟှယ် ဆိုဘီး ပြောဂေ့ပါဟှယ်” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ကိုယ်တော်ဟှ “နန်းနို့လေဟှမား ငါ့ဟှို ဖယ်သူဖြစ်ဟှယ် ဆိုဘီး ပြောဂေ့နူး” ဆိုဘီး မေးတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ရှိမုန်ပေတရုဟှ “ကိုယ်တော်ဟှာ သတ်ရှင်တော်မူဟှူ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်ဟှူ ခရစ်တော်ဖြစ်ပါဟှယ်” ဆိုဘီး လျှော့‑က်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ယေရှုဟှ “ယောနရဲ့သားရှိမုန်! နန်ဟှာ မင်္ဂလာရှိလေဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်မူဇာဟှို ဇာတိသွီးသားဟှ နန့်ဟှို ဖွမ့်ပြလိုက်ဇာ မှုဟှ။ ကောန်းဂန်ဘောင်မာ ရှိတော်မူဟှူ ငါ့ဖဟှာ ဖွမ့်ပြတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","အယ်ကြောန့် ငါပြောမယ်၊ နန်ဟှာ ပေတရု ဖြစ်ဟှယ်။ အယ်က္လော့‑က်ထတ်မာ ငါ့သင်းတော်ဟှို ငါတည်ဆော့‑က်မယ်။ မရဏာနိုင်ငံရဲ့ ခွဗော့‑က်ဝဟှာ အယ်သင်းတော်ဟှို နိုင်စေရဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ငါဟှာ နန့်ဟှို ကောန်းဂန်နိုင်ငံရဲ့ သော့လေဟှို ပေးအပ်မယ်။ နန်ဟှာ မ္လေဂီးမာ ချည်နှောန်ဟှူမျှဟှို ကောန်းဂန်မာ ချည်နှောန်ခံရလေ့မယ်။ မ္လေဂီးမာ ဖြေလွှတ်ဟှူမျှဟှို ကောန်းဂန်မာ ဖြေလွှတ်ခံရလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","အယ်ဘီးန ယေရှုဟှ မိမိဟှာ ခရစ်တော် ဖြစ်ဟှယ် ဆိုဇာဟှို ဖယ်သူလေဟှိုလည်း ပြောဘဲဟှို့တွပ် တဗဲ့တော်လေဟှို မိန့်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ယေရှုဟှ “ငါဟှာ ယေရုရှလင်ဗြို့ဟှို သွားရမယ်။ အယ်ဘီးဟှာ ဘာသာရေး ခေါန်းဆောန်လေ၊ ယဇ်ပုရောဟိတ်ဂီးလေန ကျမ်းပြုဆရာလေရဲ့ လတ်မာ ဝေဒနာဘောင်ဂီး ခံရလေ့မယ်။ ငါဟှာ သေသတ်ခံရလေ့မယ်။ အယ်ဘေမဲ့ သောင်းရစ်မြော့‑က်ဟှူ နေ့မာ ထမြော့‑က်လေ့မယ်” ဆိုဘီး အယ်ခီဟှနေစဘီး တဗဲ့တော်လေဟှို ဖော်ပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ပေတရုဟှ ကိုယ်တော့်ဟှို ဘေးနားဟှို ခေါ်ဘီးဟှာ “သခင်၊ အယ်မျိုးမှုရာလေဟှို ကိုယ်တော်နလွဲပါစေ! ကိုယ်တော့်ဟှို အယ်မျိုးမှုရာလေ လောင်းဝဖြစ်ပါစေန!” ဆိုဘီး ပြစ်တန်ဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ယေရှုဟှ လှည့်ကေ့ဘီး ပေတရုဟှို “စာတန်၊ ငါ့နော့‑က်ဟှိုဆို့! နန်ဟှာ ငါ့တွပ် ထိမိဘီးလဲဇာ ဖြစ်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်ဟှာ ဘုရားသခင်နဆိုင်ဟှူဇာလေဟှို စိစွဲလမ်းဘဲန မ္လေဂီးနဆိုင်ဟှူဇာလေဟှိုဘဲ့ စိစွဲလမ်းဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","အယ်ဘီးန ယေရှုဟှ တဗဲ့တော်လေဟှို “ဖယ်သူဘဲ့ဖြစ်ဖြစ် ငါ့နော့‑က်ဟှို လိုက်ရှင်ဟှယ် ဆိုဟှာ ကိုယ့်ကိုယ်ကိုယ် ငြင်းပယ်ရမယ်။ ကိုယ့်ရဲ့ လတ်ဝါးကပ်တိုင်ဟှို ထမ်းဘီးဟှာ ငါ့နော့‑က်ဟှို လိုက်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ဖယ်သူဘဲ့ဖြစ်ဖြစ် သူ့ရဲ့သတ်ဟှို ကယ်တန်ရှင်ဟှယ် ဆိုဟှာ သတ်ရှောင်းရလေ့မယ်။ အယ်ဘေမဲ့ ဖယ်သူဘဲ့ဖြစ်ဖြစ် ငါ့တွပ်န သတ်ရှောင်းဟှယ် ဆိုဟှာ သတ်ဟှို ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","လူဟှာ လောက တခုလောင်းဟှို ရရှိဟှူလည်းဘဲ့ သူးနို့ရဲ့ သတ်ဝိညာဉ် ဆောင်းရှောင်းဟှားမယ် ဆိုဟှာ ဖြားကျိုးရှိမယ်နူး။ သူးနို့ဟှာ ဖြားဇာလေဟှို ပေးဘီး သူးနို့ရဲ့ သတ်ဟှို ပ္လန်ဝီးနိုင်မယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လူ့ရဲ့သားဟှာ သူ့ရဲ့ ကောန်းဂန်တမန်လေနတူးဒူ သူ့ဖရဲ့ ဖောင်းသရေတော်ဟှို ဆောန်ဘီးဟှာ ကြွလာတော်မူလေ့မယ်။ အယ်ဘီးဟှာ လူယော့‑က်စီတိုင်းဟှာ သူးနို့ရဲ့ လောက်ဆောင်ဟှားတိုင်း ကျိုးပြစ်ဟှို ပေးတော်မူလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","နန်းနို့လေဟှို ငါ မှန်ပြောမယ်၊ အယ်နေရာမာ ရပ်နေဟှူ လူလေထဲမာ လူသားဟှာ သူ့ရဲ့နိုင်ငံတော်န ကြွလာတော်မူဇာဟှို ဗြင်ရဘဲန သေရဟှို့ မှုဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ခြော့‑က်ရစ်ကြာဘီးန ယေရှုဟှာ ပေတရု၊ ယာကုပ်၊ ယာကုပ်ရဲ့ညီ ယောဟန်လေဟှို ခေါ်ဘီးဟှာ တောန်ထတ်ဟှို ကြွဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","သူးနို့လေရှေ့မာ ကိုယ်တော်ရဲ့ ပေါင်သဏ္ဌာန်တော်ဟှာ ပ္လောန်းလဲဟှားဘီး မျစ်နှာတော်ဟှာ နေရောန်မျိုးဘဲ့ တော့‑က်ပနေလေဟှယ်။ ဝတ်တော်ဟှလည်း လန်းရောန်မျိုး ဖ္လူဆွတ်ဆွတ် ဖြစ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","အယ်ဘီးန မောရှေန ဧလိယဟှာ ပေါ်လာဘီး ယေရှုန စကားပြောနေဇာဟှို ဗြင်ရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","အယ်ကြောန့် ပေတရုဟှ ယေရှုဟှို “သခင်၊ အယ်နေရာဟှာ ကျွန်တော်ဟှားလေတွပ် ရရာတိုင်းဘဲ့ ကောန်းပါဟှယ်! ကိုယ်တော် လိုတော်ရှိဟှယ် ဆိုဟှာ ကိုယ်တော်တွပ် တဲတဆောန်၊ မောရှေတွပ် တဆောန်န ဧလိယတွပ် တဆောန်၊ တဲသောင်းဆောန်ဟှို ကျွန်တော်ဆော့‑က်ပါမယ်” ဆိုဘီးဟှာ လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ပေတရု လျှော့‑က်နေဟှူ ခီမာဘဲ့ တော့‑က်ပဟှူ မိုးတီတခုဟှာ သူးနို့လေထတ်ဟှို လွှမ်းမိုးလာဘီး “အယ်သူဟှာ ငါနှစ်သက်မြတ်နိုးဟှူ ငါရဲ့ ရှစ်ဟှူသား ဖြစ်ဟှယ်။ သူ့ရဲ့စကားဟှို နားထောန်ဂေ့ပါ!” ဆိုဘီး မိုးတီထဲဟှ သံတော်ဟှို ကြားရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","အယ်သံတော်ဟှို တဗဲ့တော်လေ ကြားရဟှူ ခီမာ ရရာတိုင်း ကြော့‑က်လန့်ဂေ့ဘီး သူးနို့ဟှာ မ္လေဂီးမာ ဝပ်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ယေရှုဟှာ သူးနို့လေနားဟှို ကြွလာဘီး သူးနို့လေဟှို တို့လိုက်ဘီးဟှာ “ထဂေ့၊ ကြော့‑က်ဂေ့န!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","သူးနို့လေလည်း မှော်ကေ့လိုက်ဟှူ ခီမာ ယေရှုဟှလွဲဘီး ဖယ်သူ့ဟှိုလည်းဘဲ့ တွိဂေ့ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","အယ်ဘီးန တောန်ထတ်ဟှနေ ဆင်းလာဟှူ ခီမာ ယေရှုဟှ “နန်းနို့လေ ဗြင်လိုက်ဟှူ ရူပါရောင်လေဟှို လူ့ရဲ့သားဟှာ သေရာဟှနေဘီး ထမြော့‑က်ခန်ခီထိ ဖယ်သူ့ဟှိုလည်း ပြောပြဂေ့န” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","တဗဲ့တော်လေဟှ “ဧလိယဟှာ ရင်ကြွလာရမယ် ဆိုဘီး ကျမ်းပြုဆရာလေဟှ ဖြားဖြစ်ကြောန့် ပြောဟှားဂေ့နူး” ဆိုဘီး ယေရှုဟှို မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ယေရှုဟှ “ဧလိယဟှာ ရင်ဦးဆောင်း ကြွလာဘီး ရှိမျှဂူလောင်းဟှို ပ္လန်ဘီးတည်ဆော့‑က်ရမယ် ဆိုဇာ မှန်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","နန်းနို့လေဟှို ငါပြောမယ်။ ဧလိယဟှာ ကြွလာပီးဘီ။ လူလေဟှာ သူ့ဟှိုသိဂေ့ဟှ။ အယ်ဘေမဲ့ လောက်ရှင်ဟှူတိုင်း လောက်ဂေ့လေဘီ။ အယ်မျိုးဘဲ့ လူ့ရဲ့သားဟှာလည်း အယ်သူလေ လတ်ထဲမာ နှိစစ်ညှဉ်းဆဲခံရလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","အယ်ဘီးန တဗဲ့တော်လေဟှလည်း ဗတ္တိဇံယောဟန် ကြောန်းဟှို မိန့်တော်မူနေဟှယ် ဆိုဇာဟှို နားလည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ကိုယ်တော်န တဗဲ့တော်လေဟှာ လူအောက်ဂီးနားဟှို ရော့‑က်လာခီမာ လူတယော့‑က်ဟှ ယေရှုရှေ့မာ ဒူးထော့‑က်ဘီး ");
INSERT INTO tvn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“သခင်၊ ကျွန်တော်ရဲ့ သားဟှို သနားတော်မူပါ! သူဟှာ ဝပ်ရူးပ္လန်ရောဂါစွဲဘီး မီးထဲရေထဲဟှို ခါဘီးခါ လဲက္လတတ်ပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ကိုယ်တော်ရဲ့ တဗဲ့တော်လေနားဟှို ခေါ်လာဘေမဲ့ သူးနို့လေဟှာ သူဟှို ကျန်းမာပေးနိုင်ဂေ့ဟှ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ယေရှုဟှ “ယောင်ကြည်ရှင်းမှေ့ဘဲန ဖော့‑က်ပ္လန်တတ်ဟှူ လူလေ! ငါဟှာ နန်းနို့လေနတူးဒူ ဖယ်မျှကြာအောန် နေရဟှို့နူး၊ နန်းနို့လေဟှို ဖယ်မျှကြာအောန် သီးခံရအူးမယ်နူး၊ ကောန်သားဟှို ငါ့နားဟှိုခေါ်လာဂေ့!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ယေရှုဟှ နတ်ဆိုးဟှို ထွပ်ဟှားဟှို့ မိန့်ပေးလိုက်ဟှူ ခီမာ နတ်ဆိုးဟှာ အယ်မူကောန်သားထဲဟှနေ ထွပ်ဟှားလေဟှယ်။ အယ်ခီမာဘဲ့ အယ်ကောန်သားလည်း ကျန်းမာဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","အယ်ဘီးန တဗဲ့တော်လေဟှာ ယေရှုနားဟှို သီးသန့်လာဂေ့ဘီး “ကျွန်တော်ဟှားလေဟှာ အယ်နတ်ဟှို ဖြားဖြစ်ကြောန့် နှန်ထုနိုင်ဘဲနေပါနူး” ဆိုဘီး မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ကိုယ်တော်ဟှ “နန်းနို့လေဟှာ ယောင်ကြည်ရှင်း မှေ့ဘဲကြောန့်ဖြစ်ဟှယ်။ ငါ မှန်ပြောမယ်။ နန်းနို့လေဟှာ မုညင်းစေ့မျှလော့‑က်ဘဲ့ ယောင်ကြည်ရှင်းရှိမယ် ဆိုဟှာ ‘အယ်တောန်ဟှို အယ်နေရာဟှရွေ့!’ ဆိုဘီး ပြောလိုက်ဟှူန အယ်တောင်ဟှာ ရွေ့ဟှားလေ့မယ်။ နန်းနို့တွပ် ဖြစ်နိုင်ဘဲဇာလေ မှေ့ဟှ!” ");
INSERT INTO tvn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","သူးနို့ဟှာ ဂါလိလဲပြည်မာ ရှိနေခီမာ ယေရှုဟှ “လူ့ရဲ့သားဟှို လူလေရဲ့ လတ်ထဲဟှို အပ်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","သူးနို့လေဟှာ လူ့ရဲ့သားဟှို သတ်ဂေ့လေ့မယ်။ သောင်းရစ်မြော့‑က်ဟှူ နေ့မာ သူဟှာ ထမြော့‑က်လေ့မယ်” ဆိုဘီး တဗဲ့တော်လေဟှို မိန့်တော်မူလေဟှယ်။ တဗဲ့တော်လေဟှလည်း ရရာတိုင်း ဝန်းနဲဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ကပေရနောင်ဗြို့ဟှို သူးနို့ရော့‑က်လာဟှူ ခီမာ ဗိမာန်တော် ခွန်ကော့‑က်မားလေဟှာ ပေတရုနားဟှို လာဘီး “နန့်ရဲ့ ဆရာဟှာ ဗိမာန်တော်ခွန်ဟှို ပေးဘဲ့လော” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ပေတရုဟှ “ပေးပါဟှယ်” ဆိုဘီး ဖြေလေဟှယ်။ ပေတရုဟှ အီထဲဟှို ဝမ်လာခီမာ ယေရှုဟှ “ရှိမုန်၊ နန်ဖယ်မျိုးထန်နူး။ လောကမာရှိဟှူ မန်းဂီးလေဟှာ ဖယ်သူ့နားဟှနေ ခွန်ကော့‑က်ဂေ့နူး။ သူးနို့သားလေ နားဟှလော။ ခြားသူလေ နားဟှလော” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ပေတရုဟှ “ခြားသူလေဘဲ့ ပေးရပါဟှယ်” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ယေရှုဟှ “အယ်ဆိုဟှာ သားလေဟှာ ကန်းလွတ်ခွမ့်ရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","အယ်ဘေမဲ့ အယ်သူလေဟှို မှားယွင်းစေရှင်ဟှ။ အယ်ကြောန့် အိုင်ထဲဟှို သွားဘီးဟှာ ငါးဟှိုမျှားလော။ ရင်ဦးဆောင်းရလာဟှူ ငါးဟှို ယူဘီးဟှာ ဇပ်ပေါ့‑က်ဟှို ဖွမ့်လိုက်ပါ။ ငွေဒင်္ဂါးတပ္လားဟှို တွိရလေ့မယ်။ အယ်ဒင်္ဂါးဟှို ယူဘီးဟှာ နန့်နငါ့တွပ် ဗိမာန်တော်ခွန်ဟှို ပေးလိုက်ပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","အယ်ခီမာ တဗဲ့တော်လေဟှ ယေရှုနားဟှို လာဂေ့ဘီးဟှာ “ကောန်းဂန်နိုင်ငံတော်မာ ဖယ်မျိုးသူဟှ ကီးမြတ်ဆောင်းနူး” ဆိုဘီး မေးလျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ယေရှုဟှ သားဂန်းတယော့‑က်ဟှို သူ့နားဟှိုခေါ်ဘီးဟှာ တဗဲ့တော်လေရှေ့မာ ရပ်ခိုင်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","အယ်ဘီးန ကိုယ်တော်ဟှ “ငါ မှန်ပြောမယ်၊ နန်းနို့လေ ပ္လောန်းလဲဘီးဟှာ အယ်သားဂန်းဟှားမျိုး ဖြစ်ဘဲဟှ ဆိုဟှာ ကောန်းဂန်နိုင်ငံတော်ဟှို ရော့‑က်ရဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","အယ်ကြောန့် အယ်သားဂန်းမျိုး စိနှိခ္လဟှူသူဟှာ ကောန်းဂန်နိုင်ငံတော်မာ ကီးမြတ်ဆောင်း ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ငါ့နာမဟှို ထော့‑က်ဘီးဟှာ အယ်မျိုး သားဂန်းဟှား ယော့‑က်ယော့‑က်ဟှို လတ်ခံသူဟှာ ငါ့ဟှို လတ်ခံဇာဘဲ့ ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“ငါ့ဟှို ယောင်ကြည်ဟှူ အယ်မူသားဂန်း ယော့‑က်ယော့‑က်ဟှို မှားယွင်းစေသူဟှာ လည်ဘန်းမာ က္လော့‑က်က္လိဆောင်နခယ်ဘီး ပန်လယ်ထဲဟှို ပစ်ခ္လခံရဟှူဇာဟှ ပိုဘီး ကောန်းလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","မှားယွင်းတတ်ဟှူကြောန်းလေ ရှိဟှိကြောန့် လောကီသားလေဟှာ အမင်္ဂလာရှိဟှယ်! မှားယွင်းတတ်ဟှူကြောန်းလေ ရှိရမယ်။ အယ်ဘေမဲ့လည်း မှားယွင်းတတ်ဟှူ ကြောန်းရာလေဟှို ဖြစ်စေဟှူသူဟှာ အမင်္ဂလာရှိဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“နန့်ရဲ့ခေ၊ နန့်ရဲ့လတ်ဟှာ နန့်ဟှို မှားယွင်းစေဟှယ် ဆိုဟှာ အယ်ခေ၊ အယ်လတ်ဟှို ခွတ်ဖြတ်ပစ်ပါ! ထာဝရငရဲမီးထဲဟှို ခေလတ်ဇောင်န ပစ်ခ္လခံရထတ် ခေလတ်မှေ့ဘဲန သတ်ရှင်ဇာဟှို ဝမ်စားရဟှူဇာဟှ ပိုကောန်းဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","နန့်ရဲ့ မျစ်စိဟှလည်း နန်းနို့ဟှို မှားယွင်းစေဟှယ် ဆိုဟှာ မျစ်စိဟှို ဖော့‑က်ပစ်ပါ! မျစ်စိနှေ့ဖတ်ဇောင်န ငရဲထဲဟှို ပစ်ခ္လခံရဟှူထတ် မျစ်စိတဖတ်န သတ်ရှင်ဇာဟှို ဝမ်စားရဟှူဇာဟှ ပိုကောန်းဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“နန်းနို့လေဟှာ ဖယ်မူသားဂန်းဟှိုမှလည်း ထီမဲ့မြင်လော့‑က်မိဘဲ့နေအောန် ဒိထားဂေ့ပါ၊ နန်းနို့လေဟှို ငါပြောဟှယ်။ အယ်သားဂန်းလေရဲ့ ကောန်းဂန်တမန်လေဟှာ ကောန်းဂန်ဘောင်မာ ရှိတော်မူဟှူ ငါ့ဖရဲ့ မျစ်နှာတော်ဟှို မြဲဒမ်း ဖူးဗြင်ရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“နန်းနို့လေဟှာ ဖယ်မျိုးထန်မှတ်ဂေ့နူး။ လူတယော့‑က်မာ သိုးကောန် ၁၀၀ ရှိဘီး သိုးတကောန်ဟှာ ပျော့‑က်ဟှားမယ် ဆိုဟှာ ကျန်နေဟှူ ၉၉ ကောန်ဟှို တောန်ထတ်မာ ထားရစ်ဘီးဟှာ ပျော့‑က်နေဟှူ သိုးတကောန်ဟှို လိုက်ရှာတတ်ဟှယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ရှာဟှိတွိဟှူ ခီမာ လမ်းလွဲဘီး ပျော့‑က်ဘဲနေဟှူ ကိုးဆယ်ကိုးကောန်ထတ် ပ္လန်တွိဟှူ သိုးတကောန်တွပ် ပိုဘီး ဟှာ ဝန်းသာဟှယ် ဆိုဘီး ငါ မှန်တိုင်းပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","အယ်မျိုးဘဲ့ ကောန်းဂန်ဘောင်မာ ရှိတော်မူဟှူ နန်းနို့ ဖလည်း အယ်မူသားဂန်း တယော့‑က်ဟှိုမှ ပျစ်စီးစေဟှို့တွပ် လိုတော်မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“အယ်ကြောန့် ညီကို မောန်နှမဟှာ နန့်ဟှို ပြစ်မှားဟှယ် ဆိုဟှာ သူ့ပြစ်ဟှို ဖော်ပြပေးဟှို့တွပ် သူ့နားဟှို သွားပါ။ အယ်ဘေမဲ့ နှေ့ယော့‑က်ဒဲတွိဘီး သူ့ပြစ်ဟှို ဖော်ပြပါ။ နန့်စကားဟှို သူနားထောန်ဟှယ် ဆိုဟှာ နန်းနို့ဟှာ သူ့ဟှို ပ္လန်ရလေဘီ။ ");
INSERT INTO tvn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","အယ်ဘေမဲ့ နန့်ရဲ့ စကားဟှို နားထောန်ဟှ ဆိုဟှာ သူ့စကားဟှို တည်ဖြစ်စေဟှို့တွပ် ကျမ်းစာမာ ပြောဟှားဟှူတိုင်း သိသတ်သေ နှေ့ယော့‑က်၊ သောင်းယော့‑က်ဟှို ခေါ်ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","အယ်သူဟှာ နားထောန်ဟှို့ ငြင်းဆန်နေဟှယ် ဆိုဟှာ သင်းတော်ဟှို တန်ပြပါ။ သင်းတော်ရဲ့ စကားဟှိုလည်း သူနားထောန်ဟှ ဆိုဟှာ တခြားဘာသာဟှ လူတယော့‑က်မျိုးဘဲ့ဖြစ်ဖြစ် အယ်မျိုးမှုဘဲနေဟှာ ခွန်ကော့‑က်မား တယော့‑က်မျိုးဘဲ့ အယ်သူဟှို သတ်မှတ်ဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“ငါ မှန်ပြောမယ်၊ နန်းနို့လေဟှာ မ္လေဂီးထတ်မာ ချည်နှောင်ဟှူမျှဟှာ ကောန်းဂန်ဘောင်မာ ချည်နှောင်လေ့မယ်။ မ္လေဂီးထတ်မာ ဖြေလွှတ်ဟှူမျှဟှာ ကောန်းဂန်ဘောင်မာ ဖြေလွှတ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“နော့‑က်ထပ် ငါ မှန်ပြောမယ်။ မ္လေဂီးထတ်မာ လူနှေ့ယာ့‑က် ဘောတူဘီး ဆုတောန်းဟှယ် ဆိုဟှာ နန်းနို့တောန်းဟှူမျှဟှို ကောန်းဂန်ဘောင်ဟှ ငါ့ဖဟှာ ပေးတော်မူလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လူနှေ့ယော့‑က်၊ သောင်းယော့‑က်ဟှာ ငါ့ရဲ့ နာမဟှို အားကိုးဘီး စုဝေးနေဟှူ နေရာလေမာ ငါဟှာ သူးနို့နတူးဒူး ရှိနေမယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","အယ်မူခီမာ ပေတရုဟှ ယေရှုနားဟှို လာဘီး “သခင်၊ ညီကို မောန်နှမဟှ ကျွန်တော်ဟှို ပြစ်မှားဟှယ် ဆိုဟှာ သူ့ဟှို ဖယ်မျှခါလော့‑က် ခွမ့်လွှတ်ရမယ်နူး၊ ခွန်နစ်ခါလော့‑က်ထိ ခွမ့်လွှတ်ရဟှို့လော” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ယေရှုဟှ “ခွန်နစ်ခါတိုင်အောန် ခွမ့်လွှတ်ရမယ် ဆိုဘီး ငါပြောဟှ။ ခါခွန်နစ်ဆယ် ခွန်နစ်လီတိုင်အောန် (ခွန်နစ်ဆယ်ခွန်နစ်ခါ) ခွမ့်လွှတ်ရမယ် ဆိုဘီး ငါပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","အယ်ကြောန့် ကောန်းဂန်နိုင်ငံတော်ဟှာ သူ့ကျွန်လေရဲ့ စာရင်းဟှို စစ်ဆေးဟှူ မန်းဂီးတပါးန တူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","စာရင်းယူဟှူ ခီမာ ကပ်သန်းပေါန်းများစွာ ကပ်ကွီးတန်နေဟှူ လူတယော့‑က်ဟှို ခေါ်စေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","အယ်သူဟှာ ကပ်ကွီးဆပ်နိုင်ဘဲဟှူကြောန့် သူ့သခင်ဟှ အယ်သူနတူးဒူ သားမယား၊ အောက်စာ ပစ်စီးလေ ရှိဟှူမျှဟှို ရောန်းဘီးဟှာ ကပ်ကွီးဆပ်စေဟှို့တွပ် မိန့်ခ္လမှတ်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","အယ်ကျွန်ဟှလည်း မန်းဂီးရှေ့မာ ပျပ်ဝပ်ဘီး ‘ကျွန်တော်ဟှို သီးခံတော်မူပါ။ ကပ်ကွီးရှိဟှူမျှဟှို ဆပ်ပါမယ်!’ ဆိုဘီး တောန်းဗန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","အယ်စေခံရဲ့ သခင်ဟှလည်း သူ့ဟှို သနားဟှိကြောန့် ကပ်ကွီးရှိဟှူမျှဟှို လွှတ်ပေးဘီး သွားခွမ့်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“အယ်ဘေမဲ့ အယ်ကျွန်ထွပ်ဟှားခီမာ မိမိဒေနာရိတရာ ကပ်ကွီးတန်နေဟှူ ကျွန်တယော့‑က်ဟှို တွိလေဟှယ်။ သူဟှာ အယ်ကျွန်ရဲ့ လည်ဗန်းဟှို ညှစ်ဘီး ငါ့ကပ်ကွီးဟှို ဆပ်ပေးပါ!” ဆိုဘီး တောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“အယ်ကျွန်ရှင်းရှင်းဟှလည်း ဒူးထော့‑က်ဘီးဟှာ ‘ကျွန်တော်ဟှို သီးခံပေးပါ။ ကပ်ကွီးလေ ဂူလောင်းဟှို ဆပ်ပေးပါမယ်!’ ဆိုဘီး တောန်းဗန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","အယ်ဘေမဲ့ သူဟှာ လတ်ခံဘဲန ကပ်ကွီးလေ ဆပ်ခန်ခီထိ ထောန်ထဲမာ ချောက်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","အယ်မူကြောန်းရာဟှို တခြားကျွန်လေ ဗြင်သိရဟှူ ခီမာ ရရာတိုင်း စိဆိုးဂေ့ဘီး သူးနို့သခင်နားဟှို သွားဘီးဟှာ ဖြစ်ပျစ်ဟှူ ကြောန်းရာလေဟှို လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","အယ်ကြောန့် သခင်ဟှ အယ်ကျွန်ဟှို ခေါ်ဘီးဟှာ ‘ဆိုးညစ်ဟှူကျွန်! နန်ဟှာ ငါ့ဟှို တောန်းဗန်ဟှိကြောန့် ကပ်ကွီးလေ ဂူလောင်းဟှို ခွမ့်လွှတ်ပေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ငါဟှာ နန့်ဟှို သနားဟှူမျိုးဘဲ့ နန်ဟှာလည်း ကျွန်ရှင်းရှင်းဟှို သနားသင့်ဟှယ်’ ");
INSERT INTO tvn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","အယ်ဘီးန သူ့သခင်ဟှ အယ်ကျွန်ဟှို စိဆိုးဘီးဟှာ ကပ်ကွီးလေ ဂူလောင်းဟှို ဆပ်ပေးခန်ခီထိ ထောန်ထဲမာ ချောက်ဟှားစေ” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","အယ်ဘီးန ယေရှုဟှ “နန်းနို့လေလည်း နန်းနို့ရဲ့ ညီကို မောန်နှမလေဟှို စိနှလောင်းထဲဟှနေ ခွမ့်လွှတ်ဘဲဟှ ဆိုဟှာ ကောန်းဂန်ဘောင်ဟှ ငါ့ဖလည်း နန်းနို့လေဟှို ခွမ့်လွှတ်ပေးဟှို့ မှုဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","အယ်မူတရားစကားလေဟှို ယေရှုဟောပြောဘီးဟှူ ခီမာ ဂါလိလဲပြည်ဟှနေ ထွပ်ဟှားဘီး ယော်ဒန်မ္လစ်ရဲ့ ဟှိုဖတ်ကမ်းမာရှိဟှူ ယုဒပြည်ဟှို ကြွတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","လူအောက်ဂီးဟှာ ကိုယ်တော့်နော့‑က်တော်ဟှို လိုက်ဂေ့ဟှူကြောန့် အယ်နေရာမာ ကိုယ်တော်ဟှာ သူးနို့ဟှို ကျန်းမာစေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ဖာရိရှဲတချို့ဟှာ ကိုယ်တော်နားဟှို လာဘီး “လူတယော့‑က်ဟှာ ဖြားမျိုးကြောန်းပြချစ်နဘဲ့ဖြစ်ဖြစ် သူ့မယားဟှို ကွာရှင်းဟှို့တွပ် ပညတ်တော်နညီဘဲ့လော” ဆိုဘီး စမ်းသပ်ရှင်ဟှူကြောန့်ဟှို့ မေးလျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ယေရှုဟှ “ဖန်ဆင်းရှင်ဟှာ စစဒူးဟှ ယော့‑က်ကျားန မီးမနှေ့ယော့‑က်ဒဲဟှိုဘဲ့ ဖန်ဆင်းတော်မူဟှယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ဘုရားသခင်ဟှ ‘အယ်မူကြောန်းရာကြောန့် ယော့‑က်ကျားဟှာ ကိုယ့်မိဖဟှို စွန့်ဘီး၊ ကိုယ့်မယားန ပေါန်းသင်းဘီး သူးနို့နှေ့ယော့‑က်ဟှာ တသားတကိုယ်ဒဲ ဖြစ်ရဂေ့လေ့မယ်။’ ");
INSERT INTO tvn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","အယ်ကြောန့် သူးနို့ဟှာ နှေ့ယော့‑က်မှုဘဲ တယော့‑က်ဒဲဘဲ့ ဖြစ်ဂေ့ဟှယ်။ ဘုရားသခင်ဟှ တူးဒူစောင်ဖတ်ပေးဟှားဇာဟှို လူခွဲခွာစေန” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ဖာရိရှဲလေဟှလည်း “အယ်မျိုးဆိုဟှာ ကွာရှင်းစာချောက်ဟှို ပေးဘီး မယားဟှိုကွာဟှို့တွပ် ဖြားဖြစ်ကြောန့် မောရှေဟှ ပညတ်ဟှားနူး” ဆိုဘီး မေးလျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ကိုယ်တော်ဟှ “နန်းနို့လေရဲ့ စိနှလောင်းဟှာ ခိုင်မာဂေ့ဟှိကြောန့် မောရှေဟှာ နန်းနို့ရဲ့ မယားလေန ကွာရှင်းဟှို့ ခွမ့်ပြုဟှားဟှယ်။ အယ်ဘေမဲ့ စဒူးဟှ အယ်မျိုးခွမ့်ပြုချစ်မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","နန်းနို့ဟှို ငါပြောမယ်။ တရားဘဲဟှူ မေထုန်ပြုဇာဟှလွဲဘီး ကိုယ့်မယားဟှို ကွာရှင်းဘီးဟှာ တခြားမီးမတယော့‑က်န အီထောန်ပြုဟှူသူဟှာ အီထောန်ရေးဖော့‑က်ပ္လန်ရှင်းဟှို ကျူးလွန်သူ ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","တဗဲ့တော်လေဟှလည်း “လန်နမယား ပေါန်းသင်းမှုဟှာ အယ်မျိုးဖြစ်ဟှယ် ဆိုဟှာ အီထောန်နေဘဲဇာဟှာ ပိုဘီး ကောန်းမယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ကိုယ်တော်ဟှလည်း “အယ်စကားဟှို လူတိုင်းခံယူနိုင်ဟှ။ ဘုရားသခင် ခွမ့်ပြုဟှူသူလေဘဲ့ ခံယူနိုင်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","တချို့လူလေဟှာ အီထောန်ပြုနိုင်စွမ်းမှေ့ဘဲန မွီးလာဟှူ လူလေရှိဂေ့ဟှယ်။ လူလေကြောန့် အီထောန်ပြုနိုင်စွမ်းဟှို စွန့်လွှတ်လိုက်ရဟှူ လူလေလည်း ရှိဂေ့ဟှယ်။ ကောန်းဂန်နိုင်ငံတော်တွပ် အီထောန်ပြုနိုင်စွမ်းဟှို စွန့်လွှတ်လိုက်ရဟှူ လူလေရှိဂေ့ဟှယ်။ အယ်စကားဟှို ခံယူနိုင်ဟှူ သူလေဘဲ့ ခံယူပါစေ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","လူတချို့ဟှာ သားဂန်းလေဟှို လတ်တန်ဘီးဆုတောန်းခံဟှို့တွပ် ယေရှုနားဟှို ခေါ်ဆောန်လာဂေ့ကြောန့် တဗဲ့တော်လေဟှ ပြစ်တန်ဘီး ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ယေရှုဟှလည်း “သားဂန်းလေ ငါ့နားဟှို လာပါစေ။ ဆီးတားဂေ့န။ ကောန်းဂန်နိုင်ငံတော်ဟှာ အယ်မျိုးသူလေရဲ့ နိုင်ငံဖြစ်လေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ကိုယ်တော်ဟှာ သားဂန်းလေထတ်ဟှို လတ်တန်ဘီးဟှာ အယ်နေရာဟှနေဘီး ကြွတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","လူတယော့‑က်ဟှ ယေရှုနားဟှို လာဘီးဟှာ “ဆရာ၊ ထာဝရသတ်ဟှို ရဟှို့တွပ် ကျွန်တော်ဟှ ကောန်းဟှူဇာလေဟှို ဖယ်မျိုးလောက်ရဟှို့နူး” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ယေရှုဟှလည်း “ကောန်းဟှူကျင့်န ပတ်သတ်ဘီးဟှာ ငါ့ဟှို ဖြားဖြစ်ကြောန့်မေးနူး၊ ဘုရားသခင်တပါးဒဲဘဲ့ ကောင်းမြတ်တော်မူလေဟှယ်။ ထာဝရသတ်ဟှို လိုရှင်ဟှယ် ဆိုဟှာ ပညတ်တော်လေဟှို စောန့်ထီးပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","အယ်သူဟှလည်း “ဖယ်ပညတ်လေဟှို စောန့်ထီးရဟှို့နူး” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ယေရှုဟှ “လူဟှိုသတ်န၊ အီထောန်ရေးဖော့‑က်ပ္လန်န၊ ခိုးန၊ မှန်ဘဲဟှူသတ်သေဟှိုခံန၊ ");
INSERT INTO tvn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","မိနဖဟှို ရိုသေပါ။ နန့်ရဲ့ အီဇနီးရှင်းဟှို နန့်ကိုယ်နန် ရှစ်မျိုး ရှစ်ပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","အယ်လူငယ်ဟှလည်း “ကျွန်တော်ဟှာ အယ်ပညတ်လေ ဂူလောင်းဟှို စောန့်ထီးဟှားဟှယ်။ ဖြားဇာလောက်ဟှို့လိုပါသေးနူး” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ယေရှုဟှလည်း “နန်ဟှာ စောင်လင်ရှင်ဟှယ် ဆိုဟှာ သွားဘီးဟှာ နန့်မာရှိဟှူ ပစ်စီးအောက်စာလေ ဂူလောင်းဟှို ရောန်းဘီးဟှာ ဆင်းရဲသားလေဟှို ပေးပါ။ အယ်မျိုးဆိုဟှာ နန်ဟှာ ကောန်းဂန်ဘောင်မာရှိဟှူ ဘဏ္ဍာဟှို ရလေ့မယ်။ အယ်ဘီးမှ ငါ့နော့‑က်ဟှို လိုက်ပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","အယ်လူငယ်ဟှာ ပစ်စီးအောက်စာလေ ကြွယ်ဝဟှူ သူဖြစ်ကြောန့် အယ်စကားဟှို ကြားဟှူ ခီမာ ဝန်းနဲဟှားဘီး ထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","အယ်န ယေရှုဟှ တဗဲ့တော်လေဟှို “ငါ မှန်ပြောမယ်၊ ပစ်စီးအောက်စာ ကြွယ်ဝဟှူ သူလေဟှာ ဘုရားသခင်ရဲ့ ကောန်းဂန်နိုင်ငံတော်ဟှို ဝမ်နိုင်ဟှို့ ရရတိုင်း ခတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ငါထပ်ပြောအူးမယ်။ ပစ်စီးအောက်စာ ကြွယ်ဝဟှူ သူလေဟှာ ဘုရားသခင်ရဲ့ ကောန်းဂန်နိုင်ငံတော်ဟှို ဝမ်နိုင်ဟှို့ထတ် ကုလားအုတ်ဟှာ အပ်ခေါန်းပေါ့‑က်ဟှို လျှိုဟှို့ ပိုဘီး လွယ်ကူဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","တဗဲ့တော်လေဟှာ အယ်စကားဟှို ကြားဟှူ ခီမာ သူးနို့ဟှာ ရရာတိုင်း အံ့ဩဟှားဘီး “အယ်ဆိုဟှာ ဖယ်သူလေဟှာ ကယ်တန်ဇာဟှို ခံရနိုင်မယ်နူး” ဆိုဘီး မေးလျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ယေရှုဟှ သူးနို့လေဟှို ကေ့ဘီးဟှာ “အယ်မှုဟှို လူတတ်နိုင်ဟှ။ အယ်ဘေမဲ့ ဘုရားသခင်ဟှာ ဂူလောင်းဟှို တတ်နိုင်တော်မူလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","အယ်ခီမာ ပေတရုဟှ “ကျွန်တော့်ဟှားလေမာ ရှိဟှူမျှဟှို စွန့်ဘီးဟှာ ကိုယ်တော်နော့‑က်ဟှို လိုက်ဂေ့ဟှယ်။ အယ်ဆိုဟှာ ကျွန်တော့်ဟှားလေဟှာ ဖြားဇာလေဟှို ရမယ်နူး” ဆိုဘီးဟှာ မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ယေရှုဟှ “ငါ မှန်ပြောမယ်၊ ကမ္ဘာသစ်မာ လူ့ရဲ့သားဟှာ ဖောင်းသရေတော်န ပ္လဲ့ဇောင်ဟှူ ပလ္လင်ထတ်မာ ထိုင်တော်မူဟှူ ခီမာ ငါ့နော့‑က်ဟှို လိုက်ဂေ့ဟှူ နန်းနို့လေဟှာ ပလ္လင်ဆယ့်နှေ့ခု ထတ်မာ ထိုင်ဘီး ဣသရေလလူမျိုး ဆယ့်နှေ့မျိုးဟှို အောက်စိုးရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ငါ့နာမကြောန့် အီ၊ လယ်၊ ညီကို၊ ညီမ၊ မိဖ၊ သားမယားဟှို စွန့်ဟှူလူတိုင်းဟှာ ဆတရာကျိုးဟှိုရဘီး ထာဝရသတ်ဟှိုလည်း ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","အယ်ဘေမဲ့ ဦးဆောင်းဖြစ်ဟှူ လူလေဘောင်ဂီးဟှာ နော့‑က်ဆောင်းဖြစ်ဂေ့ဘီး နော့‑က်ဆောင်းဖြစ်ဟှူ လူလေဘောင်ဂီးဟှာ ဦးဆောင်းဖြစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“ကောန်းဂန်နိုင်ငံတော်ဟှာ သူ့ရဲ့စဗျစ်ခြံတွပ် လောက်သမားလေဟှို ငှားဟှို့ မိုးလန်းစောစော ထွပ်ဟှားဟှူ ခြံဇရှင်နတူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","သူဟှ တနေ့ဟှို ငွေဒန်းဂါးတပ္လားန ငှားဟှို့ ဘောတူဘီးဟှာ သူးနို့ဟှို စဗျစ်ခြံထဲဟှို စေလွှတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","သူဟှာ မိုးလန်း ကိုးနာရီ လော့‑က်မာ ဆေးဟှို ပ္လန်ထွပ်လာဇာ လောက်လောက်ဘဲန အယ်နေရာမာ ရပ်နေဟှူ တခြားသူလေဟှို တွိရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","အယ်ကြောန့် သူးနို့လေဟှို ‘နန်းနို့လေလည်း သွားဘီး စဗျစ်ခြံထဲမာ လောက်လောက်ဂေ့ပါ။ ထိုက်သင့်ဟှူ လောက်အားခဟှို ငါပေးမယ်’ ဆိုဘီး သူးနို့လေဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","အယ်ကြောန့် သူးနို့လေဟှာ သွားဂေ့ဟှယ်။ အယ်ဘီးဟှာ ဆယ်နှေ့နာရီန သောင်းနာရီမာ တခါ ပ္လန်ဟှို ထွပ်ဘီး လောက်သမားလေဟှို ငှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","နေဒန်ဇာ ငါးနာရီလော့‑က်မာ သူဟှာ ထွပ်ဟှားဟှူ ခီမာ တခြားလူလေဟှာ အယ်နေရာမာဘဲ့ ရပ်နေဂေ့ဇာဟှို တွိလေဟှယ်။ ‘နန်းနို့လေ ဖြားဖြစ်ကြောန့် တနေ့လောင်း လောက်လောက်ဘဲန ရပ်နေဂေ့နူး’ ဆိုဘီး သူးနို့လေဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","အယ်သူလေဟှလည်း ‘ကျွန်တော်ဟှားလေဟှို ဖယ်သူလည်း ငှားဂေ့ဟှ’ ဆိုဘီး ပြောလေဟှယ်။ ခြံဇရှင်ဟှ ‘နန်းနို့လည်း သွားဘီး ငါ့စဗျစ်ခြံမာ လောက်လောက်ဂေ့ပါ’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ညဉ့်ခန်းဖတ်ရော့‑က်ဟှူ ခီမာ စဗျစ်ခြံဇရှင်ဟှ ‘လောက်သမားလေဟှို ခေါ်ဘီး နော့‑က်ဆောင်းငှားဟှူ သူလေဟှစဘီး ဦးဆောင်းငှားဟှူ သူလေထိ လောက်အားခရှင်းပေးလိုက်’ ဆိုဘီး သူ့ရဲ့ဘဏ္ဍာစိုးဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","အယ်ကြောန့် ဘဏ္ဍာစိုးဟှာ နေဒန်ဇာငါးနာရီမာ ငှားဟှားဟှူ လူလေဟှို ငွေဒန်းဂါးတပ္လားစီ ရှင်းပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ဦးဆောင်းငှားဟှားဟှူ သူလေဟှာ တခြားလူလေထတ် ပိုဘီး ရလေ့မယ် ထန်မှတ်ဘီး ရော့‑က်လာဟှယ်။ အယ်ဘေမဲ့ သူးနို့လည်း ငွေဒန်းဂါးတပ္လားစီဘဲ့ ရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","သူးနို့လေဟှာ ငွေဒန်းဂါးတပ္လားစီဘဲ့ ရဂေ့ကြောန့် ခြံဇရှင်ဟှို ပြစ်တန်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘နော့‑က်ဆောင်းငှားဟှားဟှူ အယ်သူလေဟှာ တနာရီဘဲ့ လောက်လောက်ရဟှယ်။ ကျွန်တော့်ဟှားလေဟှာ နေပူဗ္လန်ထဲမာ တနေ့လောင်း ပန်ပန်ဘန်းဘန်းန လောက်ဆောန်ရဟှူလည်းဘဲ့ သင်ဟှာ ကျွန်တော်ဟှားလေဟှို အယ်သူလေနဒန်းတူဘဲ့ လောက်အားခဟှို ပေးဟှယ်!’ ဆိုဘီး ပြောဆိုဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ခြံဇရှင်ဟှ သူးနို့ထဲဟှ တယော့‑က်ဟှို ‘မိဆွေ၊ ငါဟှာ နန့်ဟှို တရားဘဲလောက်ဇာ မှုဟှ။ နန်ဟှာ ငွေဒန်းဂါးတပ္လားန လောက်လောက်ဟှို့တွပ် ဘောတူဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","နန့်ရဲ့ လောက်အားခဟှို ယူဘီးသွားဝေါ့။ နော့‑က်ဆောင်းငှားဟှူ လူလေဟှိုလည်း နန်းနို့လေဟှို ပေးဟှူမျိုးဘဲ့ ငါပေးမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ငါ့ကပ်လေဟှို ငါလောက်ရှင်မျိုး လောက်ခွမ့် မှေ့ဟှလော ငါဟှာ ဘောကောန်းဟှူကြောန့် နန်ဟှ နာလိုဘဲဖြစ်ရလော’ ဆိုဘီး ပြောလေဟှယ်” ဆိုဘီးဟှာ မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","အယ်ကြောန့် ယေရှုဟှ “အယ်မျိုးဘဲ့ နော့‑က်ဆောင်းဖြစ်ဟှူ လူလေဟှာ ဦးဆောင်းဖြစ်ဟှားဘီး ဦးဆောင်းဖြစ်ဟှူ လူလေဟှာ နော့‑က်ဆောင်းဖြစ်လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ယေရှုဟှာ ယေရုရှလင်ဗြို့ဟှို တတ်နေဒူးမာ တဗဲ့တော်ဆယ့်နှေ့ပါးဟှို သီးသန့်ခေါ်ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“နားထောန်ဂေ့။ နို့လေဟှာ ယေရုရှလင်ဗြို့ဟှို တတ်ဂေ့မယ်။ အယ်ဗြို့မာ လူ့ရဲ့သားဟှာ ယဇ်ပုရောဟိတ်ဂီးလေန ကျမ်းပြုဆရာလေရဲ့ လတ်ထဲဟှို အပ်ခံရလေ့မယ်။ သူးနို့လေဟှာ လူရဲသားဟှို သေဒန်စီရင်ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","လူမျိုးခြားလေရဲ့ လတ်ထဲဟှို အပ်ဂေ့လေ့မယ်။ သူးနို့ဟှာ လူ့ရဲ့သားဟှို လှောန်ပြောန်ဘီး၊ ကီဒန်ပေးဘီး လတ်ဝါးကပ်တိုင်မာ တန်ဘီး သတ်ဂေ့လေ့မယ်။ အယ်ဘေမဲ့ သောင်းရစ်မြော့‑က်ဟှူနေ့မာ လူ့ရဲ့သားဟှာ ထမြော့‑က်လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","အယ်ဘီးန ဇေဗေဒဲရဲ့ မီးမဟှာ သူ့သားနှေ့ယော့‑က်နတူးဒူ တခုခုဟှို တောန်းဟှို့တွပ် ယေရှုနားဟှို လာဘီး ပျပ်ဝပ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ယေရှုဟှ “ဖြားဇာလိုရှင်နူး” ဆိုဘီး မေးလေဟှယ်။ အယ်မီးမဟှ “ကိုယ်တော်ရဲ့ နိုင်ငံတော်မာ ကျွန်မရဲ့ သားနှေ့ယော့‑က်ဟှို ကိုယ်တော်ရဲ့ ညာဖတ်မာတယော့‑က် ကိုယ်တော်ရဲ့ ဘယ်ဖတ်မာတယော့‑က် ထိုင်စေတော်မူပါ” ဆိုဘီး တောန်းလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ယေရှုဟှ “နန်းနို့လေဟှာ ဖြားဇာလေ တောန်းလျှော့‑က်နေဟှယ် ဆိုဇာဟှို နန်းနို့သိဂေ့ဟှ။ ငါသော့‑က်ရဟှို့ ဒေါက်ခဝေဒနာခွပ်ဟှို့ နန်းနို့သော့‑က်နိုင်ဘဲ့လော” ဆိုဘီး မေးတော်မူလေဟှယ်။ သူးနို့ဟှလည်း “ကျွန်တော်ဟှားလေ သော့‑က်နိုင်ပါဟှယ်” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ကိုယ်တော်ဟှ “ငါ့ရဲ့ခွပ်ဟှို နန်းနို့လေဟှာ သော့‑က်ရလေ့မယ်။ အယ်ဘေမဲ့ ငါ့ရဲ့ ညာဖတ်န ဘယ်ဖတ်မှာ ထိုင်ရဟှို့ခွမ့်ဟှို ငါပေးပိုင်ဟှ။ အယ်နေရာဟှာ ငါ့ရဲ့ဖ ပြင်ဆင်ဟှားဟှူ သူလေတွပ်ဘဲ့ ဖြစ်လေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","အယ်ကြောန်းရာဟှို တဗဲ့တော် ဆယ်ယော့‑က်ဟှာ ကြားသိဟှူ ခီမာ အယ်ညီကို နှေ့ယော့‑က်ဟှို စိဆိုးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ယေရှုဟှာ တဗဲ့တော်လေဟှို သူ့နားဟှို ခေါ်တော်မူဘီး “နန်းနို့လေ သိဂေ့ဟှူတိုင်းဘဲ့ လူမျိုးခြားလေမာ အောက်ချောက်ဟှူ သူလေဟှာ ပြည်သူလေထတ်မာ စိုးတရပြုဘီး ခေါန်းဆောန်လေလည်း အာဏာထားတတ်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","နန်းနို့လေထဲမာ အယ်မျိုး ဖြစ်သင့်ဟှ။ နန်းနို့ထဲဟှ တယော့‑က်ဟှာ အကြီးကဲဖြစ်ရှင်ဟှယ် ဆိုဟှာ အယ်လူဟှာ နန်းနို့လေရဲ့ စေခံဖြစ်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","အယ်ဘီးဟှာ နန်းနို့လေထဲဟှ တယော့‑က်ဟှာ ကီးမြတ်ဆောင်းဖြစ်ရှင်ဟှယ် ဆိုဟှာ အယ်လူဟှာ နန်းနို့လေရဲ့ ကျွန်ဖြစ်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","အယ်မျိုးဘဲ့ လူ့ရဲ့သားဟှာ သူတပါးဟှို စေစားဟှို့လာဇာ မှုဟှ။ သူတပါးရဲ့ စေခံဟှို့န သူ့သတ်ဟှို စွန့်ဘီး လူလေဘောင်ဂီးဟှို ဝီးနှုဟှို့တွပ် ကြွလာဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ယေရှုန တဗဲ့တော်လေဟှာ ယေရိခေါဗြို့ဟှနေ ထွပ်လာဟှူ ခီမာ လူအောက်ဂီးဟှာ နော့‑က်တော်ဟှို လိုက်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","လမ်းဘေးမာထိုင်နေဟှူ လူကန်းနှေ့ယော့‑က်ဟှာ ယေရှုဖြတ်ဟှားဟှယ် ဆိုဇာဟှို ကြားသိဟှိကြောန့် “သခင်၊ ဒါဝိဒ်ရဲ့ သားတော်! ကျွန်တော်ဟှားလေဟှို သနားတော်မူပါ!” ဆိုဘီး အော်ဟစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","လူအောက်ဂီးဟှ သူးနို့ဟှို တိတိဆိဆိဟှား နေဟှို့တွပ် ပြစ်တန်ဘီး ပြောဂေ့ဟှယ်။ အယ်ဘေမဲ့ သူးနို့ဟှ “သခင်၊ ဒါဝိဒ်ရဲ့ သားတော်! ကျွန်တော်ဟှားလေဟှို သနားတော်မူပါ!” ဆိုဘီး ပိုဘီး ဟှာ အော်ဟစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ယေရှုဟှာ ရပ်တော်မူလိုက်ဘီး သူးနို့ဟှို ခေါ်လိုက်ဟှယ်။ “နန်းနို့တွပ် ဖြားဇာလောက်ပေးစေရှင်ဟှယ်နူး” ဆိုဘီး ကိုယ်တော်ဟှ မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","သူးနို့ဟှ “သခင်၊ ကျွန်တော်ဟှားလေရဲ့ မျစ်စိဟှို ဗြင်စေတော်မူပါ!” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ယေရှုဟှာ သူးနို့ဟှို သနားတော်မူဟှူကြောန့် သူးနို့လေရဲ့ မျစ်စိဟှို လတ်န တို့တော်မူလေဟှယ်။ ရှစ်ရှင်းဘဲ့ သူးနို့ဟှာ မျစ်စိဗြင်ဟှားဘီး နော့‑က်တော်ဟှို လိုက်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ယေရှုန တဗဲ့တော်လေဟှာ ယေရုရှလင်ဗြို့နားဟှို ရော့‑က်လာဘီးဟှာ သံလွင်တောန်ခေရင်းမာရှိဟှူ ဗက်ဖာဂေဝါဟှို ရော့‑က်ဂေ့လေဟှယ်။ ယေရှုဟှာ တဗဲ့တော်နှေ့ယော့‑က်ဟှို စေလွှတ်ဘီး ");
INSERT INTO tvn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“နန်းနို့ရှေ့မာရှိဟှူ ဝါဟှိုသွားဂေ့။ အယ်ဘီးဟှာ ခယ်ဟှားဟှူ မြည်းမနတူးဒူး သူ့ဘေးမာရှိဟှူ မြည်းသားဂန်းဟှားဟှို နန်းနို့ရှစ်ရှင်းတွိလေ့မယ်။ ကြိုးဟှိုဖြေဘီး ငါ့နားဟှို ယူလာဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","အယ်ဘီးဟှာ ယော့‑က်ယော့‑က်ဟှ နန်းနို့လေဟှို တခုခု မေးမယ် ဆိုဟှာ ‘သခင်ဘုရား လိုရှိဟှယ်’ ဆိုဘီး ပ္လန်ပြောဂေ့ပါ။ အယ်ဆိုဟှာ မြည်းဟှို ရှစ်ရှင်းပေးလိုက်လေ့မယ်” ဆိုဘီး မှာလိုက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ပရောဖက် ဟောပြောဟှားဟှူ ကြောန်းရာလေဟှာ ပ္လဲ့ဇောင်လာဇာဟှ ");
INSERT INTO tvn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ဇိအုန်ဗြို့ဟှို ပြောပါ။ ကေ့ရှုပါ။ နန့်ရဲ့ မန်းဂီးဟှာ နန့်နားဟှို ကြွလာတော်မူဘီ! သူဟှာ နူးညံ့ဟှယ်။ အယ်ဘီးဟှာ မြည်းဟှို စီးတော်မူလေဟှယ်။ အယ်ဘီးဟှာ မြည်းသားဂန်းဟှို စီးတော်မူလေဟှယ်” ဆိုဘီး ဖြစ်လာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","အယ်ကြောန့် တဗဲ့တော်လေဟှ ထွပ်ဟှားဘီးဟှာ ယေရှုမိန့်မှာဟှူတိုင်း လောက်ဆောန်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","သူးနို့လေဟှာ မြည်းမန မြည်းသားဂန်းဟှို ယူလာဘီးဟှာ ယေရှုထိုင်တော်မူဟှို့တွပ် သူးနို့လေရဲ့ ဝတ်လေဟှို တန်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ကီးမားဟှူ လူအောက်ဂီးဟှာ သူးနို့ဝတ်လေဟှို လမ်းမာ ခန်းဟှားဂေ့လေဟှယ်။ တချို့ဟှ သစ်ပန်ဟှ သစ်ခတ်လေဟှို ခွတ်ဘီးဟှာ လမ်းမာ ခန်းဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ယေရှုရဲ့ ရှေ့န နော့‑က်မာ လိုက်လာဂေ့ဟှူ လူအောက်ဂီးဟှ “ဒါဝိဒ်ရဲ့ သားတော် ဟောရှဏ္ဏဖြစ်ပါစေ! ဘုရားသခင်ရဲ့ နာမန ကြွလာဟှူ သခင်ဟှာ မင်္ဂလာရှိပါစေ! ဗြင့်ဆောင်းဟှူ နေရာမာ ဟောရှဏ္ဏဖြစ်စေပါ!” ဆိုဘီး ကြွေးကြော်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ယေရှုဟှာ ယေရုရှလင်ဗြို့ထဲဟှို ဝမ်လာဟှူ ခီမာ တဗြို့လောင်းဟှာ အောက်အောက်သဲသဲ ဖြစ်ဟှားဂေ့ဟှယ်။ လူလေဟှ “အယ်သူဟှ ဖယ်သူနူး” ဆိုဘီး မေးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","လူအောက်ဂီးဟှ “အယ်သူဟှာ ဂါလိလဲပြည် နာဇရက်ဗြို့ဟှ ပရောဖက် ယေရှုဖြစ်ဟှယ်” ဆိုဘီး ဖြေဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ယေရှုဟှာ ဗိမာန်တော်ဟှိုဝမ်ဘီး အယ်နေရာမာ ရောန်းဝယ်နေဟှူ လူလေဟှို နှန်ထုတော်မူလေဟှယ်။ ကိုယ်တော်ဟှာ ကပ်လဲမားလေရဲ့ ဗွဲလေန ချိုးငှတ်ရောန်းမားလေရဲ့ ထိုင်ခေါင်လေဟှိုလည်း မှော့‑က်ပစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","အယ်ဘီးဟှာ ကိုယ်တော်ဟှ “‘ငါ့အီတော်ဟှို ဆုတောန်းဟှူ အီတော် ဆိုဘီး ခေါ်ဝေါ်ဂေ့လေ့မယ်’ ဆိုဘီးဟှာ ကျမ်းစာမာ ရေးဟှားဟှယ်။ အယ်ဘေမဲ့ နန်းနို့လေဟှာ အီတော်ဟှို မ္လလေတွပ် ခိုအောန်းဟှူ နေရာ ဖြစ်စေဂေ့ဘီ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ဗိမာန်တော်ထဲမာ မျစ်ကန်းလေန ခေသန်ဘဲဟှူ သူလေဟှာ ကိုယ်တော်နားဟှို လာဂေ့ဟှူကြောန့် ကိုယ်တော်ဟှလည်း သူးနို့ဟှို ကျန်းမာစေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ယဇ်ပုရောဟိတ်ဂီးလေန ကျမ်းပြုဆရာလေဟှာ ကိုယ်တော်ပြုဟှူ အံ့ဩဘွယ်မှုရာလေဟှို ဗြင်ဟှားဘီး သားဂန်းဟှားလေဟှလည်း “ဒါဝိဒ်ရဲ့သားတော် ဟောရှဏ္ဏဖြစ်ပါစေ!” ဆိုဘီး ဗိမာန်တော်ထဲမာ ကြွေးကြော်ဂေ့ဟှူ ခီမာ သူးနို့ဟှာ စိဆိုးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","အယ်ကြောန့် သူးနို့ဟှ “အယ်သားဂန်းဟှားလေ ကြွေးကြော်နေဂေ့ဇာဟှို ကြားဘဲ့လော” ဆိုဘီး ကိုယ်တော့်ဟှို မေးလျှော့‑က်ဂေ့လေဟှယ်။ ယေရှုဟှ “ငါကြားဟှယ်။ ‘သားဂန်းဟှားလေန နို့စို့ဟှားလေရဲ့ နှောက်ထဲဟှ ချီးမွမ်းဇာဟှို ပြင်ဆင်တော်မူဘီ’ ဆိုဘီး ရေးဟှားဟှူ ကျမ်းစာဟှို နန်းနို့ဖတ်ဖူးဂေ့ဟှလော” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","အယ်ဘီးန ယေရှုဟှာ သူးနို့ဟှို ထားရစ်ဘီး ဗြို့ထဲဟှထွပ်ဟှားဟှယ်။ ဗေသနိဝါဟှို ကြွားဟှားဘီး အယ်နေရာမာ တညဉ့်တဲခိုတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ယေရှုဟှာ မိုးလန်းစောစောဂီး ဗြို့ဟှို ပ္လန်ကြွလာဟှူ ခီမာ ဗိုက်ဆာတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ကိုယ်တော်ဟှာ လမ်းဘေးမာ သဖန်းဗန်တဗန်ဟှို ဗြင်ဘီး အယ်ပန်နားဟှို ကြွတော်မူလေဟှယ်။ အယ်ဘေမဲ့ ပန်ထတ်မာ ဝပ်လေဟှိုဘဲ့ တွိဟှူကြောန့် ကိုယ်တော်ဟှ “နန်ဟှာ ခုခီဟှနေစဘီး ကာလစဉ်ဆစ် လောင်းဝ သီးသီးစေန!” ဆိုဘီး အယ်ပန်ဟှို မိန့်တော်မူလေဟှယ်။ အယ်မူခီမာ သဖန်းဗန်ဟှာ တခါဒဲ သွိခြော့‑က်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","တဗဲ့တော်လေဟှာ အယ်မူဇာဟှို ဗြင်ဘီးဟှာ အံ့ဩဂေ့လေဟှယ်။ သူးနို့ဟှ “သဖန်းဗန်ဟှာ ဖယ်မျိုးဖြစ်ဟှူကြောန့် တခါဒဲ သွိခြော့‑က်ဟှားရနူး” ဆိုဘီး သူးနို့ရှင်းရှင်း မေးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ယေရှုဟှ “ငါ မှန်ပြောမယ်၊ နန်းနို့လေဟှာ သံသယမှေ့ဘဲန ယောင်ကြည်မယ် ဆိုဟှာ သဖန်းဗန်ဟှို ငါပြုဟှူမျိုး နန်းနို့ပြုနိုင်ဘီး အယ်ထတ်မက အယ်တောန်ဟှို ‘အယ်နေရာဟှနေရွေ့ဘီး ပန်လယ်ထဲဟှို က္လစေ’ ဆိုဘီး ပြောမယ် ဆိုဟှာ ပြောဟှူတိုင်း ဖြစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","နန်းနို့လေ ယောင်ကြည်မယ် ဆိုဟှာ တောန်းလျှော့‑က်ဟှူမျှဟှို ရဂေ့လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ယေရှုဟှာ ဗိမာန်တော်ဟှို ပ္လန်ကြွလာဘီး သွန်သန်နေခီမာ ယဇ်ပုရောဟိတ်ဂီးလေန ဘာသာရေးခေါန်းဆောန်လေဟှ ကိုယ်တော်နားဟှို လာဂေ့ဘီး “ကိုယ်တော်ဟှာ အယ်မူဇာလေဟှို ဖယ်သူ့ရဲ့ ခွမ့်အာဏာန ပြုလောက်ပါနူး၊ အယ်ခွမ့်အာဏာဟှို ဖယ်သူပေးအပ်နူး” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ယေရှုဟှ “နန်းနို့လေဟှို မေးခွန်းတခု ငါမေးအူးမယ်။ အယ်မေးခွန်းဟှို နန်းနို့ဖြေမယ် ဆိုဟှာ အယ်မူဇာလေဟှို ဖယ်သူ့ခွမ့်အာဏာန ငါလောက်ဟှယ် ဆိုဇာဟှို ငါပြောမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ယောဟန်ရဲ့ ဗတ္တိဇံဟှ ဖယ်နေရာဟှနေ ဖြစ်လာဟှယ်နူး ကောန်းဂန်ဟှနေ ဖြစ်လာဇာလော အယ်မျိုးမှုဘဲနေဟှာ လူလေဟှနေ ဖြစ်လာဇာလော” ဆိုဘီး မေးတော်မူလေဟှယ်။ သူးနို့လေဟှာ “နို့လေဖြားမျိုးပြောရမယ်နူး။ ‘ဘုရားသခင်ဟှနေ ဖြစ်လာဟှယ်’ ဆိုဘီး နို့လေဖြေလိုက်မယ် ဆိုဟှာ နန်းနို့ဟှာ ဖြားဖြစ်ကြောန့် ‘ယောဟန်ဟှို ယောင်ကြည်ဂေ့ဘဲနေရနူး’ ဆိုဘီး သူဟှ နို့လေဟှို မေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","အယ်ဘေမဲ့ ‘လူလေဟှနေ ဖြစ်လာဟှယ်’ ဆိုဘီး နို့လေဖြေလိုက်မယ် ဆိုဟှာလူလေ ဂူလောင်းဟှာ ယောဟန်ဟှို ပရောဖက်တပါး ဖြစ်ဟှယ် ဆိုဘီး ယောင်ကြည်ဂေ့ဟှိကြောန့် လူလေဟှိုလည်း ကြော့‑က်ရဟှယ်” ဆိုဘီး သူးနို့ရှင်းရှင်း ဆွေးနွေးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","အယ်ကြောန့် သူးနို့ဟှ ယေရှုဟှို “ကျွန်တော်ဟှားလေ သိဂေ့ဟှ” ဆိုဘီး ပ္လန်လျှော့‑က်ဂေ့လေဟှယ်။ အယ်န ယေရှုဟှ “ငါပြုဟှူအယ်မူဇာလေဟှို ဖယ်သူ့ခွမ့်အာဏာန ပြုဟှယ်ဆိုဇာဟှိုလည်း ငါပြောဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“နန်းနို့လေ ဖယ်မျိုးထန်မှတ်ဂေ့နူး။ လူတယော့‑က်မာ သားနှေ့ယော့‑က်ရှိလေဟှယ်။ သူဟှာ သားဂီးနားဟှို သွားဘီးဟှာ ‘ငါ့သား၊ အယ်နေ့ စဗျစ်ခြံဟှို သွားဘီးဟှာ လောက်လောက်ပါ’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","သားဂီးဟှ ‘ကျွန်တော်သွားနိုဟှ’ ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ အယ်ဘေမဲ့ သူ့ရဲ့စိဟှာ ပ္လောန်းလဲဘီးဟှာ ခြံထဲဟှို သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","အယ်န ဖဟှ သားငယ်နားဟှို သွားဘီး အယ်မျိုးဘဲ့ ပြောလေဟှယ်။ အယ်သားဟှ ‘သွားပါမယ်၊ သခင်’ ဆိုဘီး ပြောဘေမဲ့လည်း သွားဘဲန နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","အယ်သား နှေ့ယော့‑က်မာ ဖယ်သူဟှ သူ့ဖရဲ့ လိုဟှို လောက်ဆောန်ဟှယ်နူး” ဆိုဘီး မေးတော်မူလေဟှယ်။ သူးနို့လေဟှ “သားဂီး” ဆိုဘီး ဖြေဂေ့လေဟှယ်။ အယ်ကြောန့် ယေရှုဟှ “ငါ မှန်ပြောမယ်၊ အခွန်ကော့‑က်မားလေန ကောန်းဘဲဟှူ မီးမလေဟှာ နန်းနို့ထတ်ဦးဘီး ကောန်းဂန်နိုင်ငံတော်ဟှို ဝမ်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဗတ္တိဇံ ယောဟန်ဟှာ ဖြောန့်မတ်ဟှူ လမ်းအားဖြင့် နန်းနို့လေနားဟှို လာဘီး မှန်ဟှူလမ်းဟှို ပြဟှူလည်းဘဲ့ နန်းနို့လေဟှာ သူ့ဟှို ယောင်ကြည်ဂေ့ဟှ။ အယ်ဘေမဲ့ ခွန်ကော့‑က်မားလေန ကောန်းဘဲဟှူ မီးမလေဟှာ ယောင်ကြည်ဂေ့လေဟှယ်။ အယ်မူဇာလေဟှို ဗြင်ရဟှူ ခီမာလည်းဘဲ့ နန်းနို့လေဟှာ ယောင်ကြည်ဟှို့တွပ် စိပ္လောန်းလဲဂေ့ဟှ။” ");
INSERT INTO tvn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ယေရှုဟှ “တခြားပေါင်ဥပမာတခုဟှို နားထောင်ဂေ့။ စဗျစ်ခြံဟှို စိုက်ပျိုးဟှူ မ္လေဇရှင်တယော့‑က် ရှိလေဟှယ်။ သူဟှာ ခြံစည်းရိုးဟှို ကာဘီး စဗျစ်သီးနယ်ဟှို့တွပ် တွမ်းဟှို တူးလေဟှယ်။ အယ်ဘီးဟှာ မျှော်စင်တခုဟှိုလည်း ဆော့‑က်လေဟှယ်။ အယ်ဘီးမှ သူဟှာ စဗျစ်ခြံဟှို ခြံလောက်မားလေဟှို ငှားဘီးဟှာ ခရီးထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","စဗျစ်သီးပေါ်ခီ ရော့‑က်ဟှူ ခီမာ စဗျစ်သီးယူဟှို့တွပ် သူ့စေခံလေဟှို ခြံလောက်မားလေနားဟှို စေလွှတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ခြံလောက်မားလေဟှာ အယ်သူရဲ့ စေခံလေဟှို ဖမ်းဘီးဟှာ တယော့‑က်ဟှို ရိုက်၊ တယော့‑က်ဟှို သတ်ဘီး တယော့‑က်ဟှို က္လော့‑က်ခဲန ပစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","နော့‑က်ထပ်ခါ ခြံဇရှင်ဟှ ရင်ဟှထပ်များဟှူ စေခံလေဟှို လွှတ်လိုက်ဟှယ်။ ခြံလောက်မားလေဟှာ အယ်မူတိုင်းဘဲ့ လောက်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ခြံဇရှင်ဟှ ‘အယ်သူလေဟှာ ငါ့သားဟှို လေးစားဂေ့လေ့မယ်’ ဆိုဘီး နော့‑က်ဆောင်းမာ သူ့သားဟှို စေလွှတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","အယ်ဘေမဲ့ ခြံလောက်မားလေဟှာ ဇရှင်ရဲ့သားဟှို ဗြင်ဟှူ ခီမာ ‘အယ်သူဟှာ ဇရှင်ရဲ့သားဖြစ်ဟှယ်။ လာဂေ့။ သူ့ဟှိုသတ်ဘီး သူ့ရဲ့အောက်စာဟှို ယူဂေ့ဇို့!’ ဆိုဘီး သူးနို့ရှင်းရှင်းပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","အယ်ကြောန့် သူးနို့ဟှာ စဗျစ်ခြံဇရှင်ရဲ့ သားဟှို ဖမ်းဘီး ခြံပ္လန်ဟှို ဆွဲထုဘီးဟှာ သတ်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“အယ်မျိုးဆိုဟှာ စဗျစ်ခြံဇရှင် ရော့‑က်လာဟှူ ခီမာ ခြံလောက်မားလေဟှို ဖယ်မျိုးလောက်လေ့မယ်နူး” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","သူးနို့ဟှ “စဗျစ်ခြံဇရှင်ဟှာ အယ်လူဆိုးလေဟှို သေသတ်ပါလေ့မယ်။ အယ်ဘီးဟှာ ခြံဟှိုလည်း စဗျစ်သီး သီးဟှူ ခီမာ ခြံဇရှင်ဟှို ပေးဟှူ ခြံလောက်မားလေဟှိုဘဲ့ ငှားပါလေ့မယ်” ဆိုဘီး ဖြေဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ယေရှုဟှ “ကျမ်းစာဟှို နန်းနို့လေ ဖတ်ဖူးဟှလော၊ “‘တိုက်ဆော့‑က်မားလေ ဖယ်ဟှားဟှူ က္လော့‑က်ဟှာ တိုက်ရဲ့ ထိဖျားဟှို ရော့‑က်လေဟှယ်။ အယ်မှုဟှာ ဘုရားသခင်အားဖြင့် ဖြစ်လာဘီး၊ နို့လေရဲ့ မျစ်စိရှေ့မာလည်း အံ့ဩဘွယ်ရာ ဖြစ်ဟှယ်!’ ");
INSERT INTO tvn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“အယ်ကြောန့် နန်းနို့လေဟှို ငါပြောမယ်။ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို နန်းနို့လေဟှနေဘီး ရောက်သီးဘီးဟှာ နိုင်ငံတော်ရဲ့ သီးဟှို သီးမယ့်လူမျိုးလေဟှို ပေးလေ့မယ်။” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ယေရှုရဲ့ ပေါင်ဥပမာစကားဟှို ယဇ်ပုရောဟိတ်ဂီးလေန ဖာရိရှဲလေ ကြားဟှူ ခီမာ သူးနို့လေကြောန်းဟှို မိန့်တော်မူဟှယ် ဆိုဇာဟှို သိဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ယေရှုဟှို ဖမ်းဟှို့ ကြိုးစားဂေ့လေဟှယ်။ အယ်ဘေမဲ့ လူအောက်ဂီးဟှ ကိုယ်တော့်ဟှို ပရောဖက်ဖြစ်ဟှယ် ဆိုဘီး ထန်မှတ်ဂေ့ကြောန့် သူးနို့ဟှာ လူလေဟှို ကြော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","နော့‑က်ထပ် ယေရှုဟှ ပေါင်ဥပမာဟှို သောင်းပြုဘီးဟှာ လူလေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ကောန်းဂန်နိုင်ငံတော်ဟှာ သူ့ရဲ့သားတွပ် မင်္ဂလာပွဲဟှို ပြင်ဆင်ဟှားဟှူ မန်းဂီးန တူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","သူဟှာ ဖိခေါ်ဟှားဟှူ လူလေဟှို ခေါ်ဟှို့တွပ် သူ့ရဲ့ စေခံလေဟှို စေလွှတ်လေဟှယ်။ အယ်ဘေမဲ့ သူးနို့လေဟှာ လာဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","အယ်ကြောန့် သူဟှ ‘ငါ့ရဲ့စားဗွဲလည်း ဆင်သင့်ဖြစ်ဘီ။ နွားန ဆူဖြိုးဟှူ လိဆန်လေဟှိုလည်း သတ်ပီးဘီ။ ဂူလောင်း ဆင်သင့်ဖြစ်နေဘီ။ မင်္ဂလာဆောန်ပွဲဟှို ကြွဂေ့ပါ!’ ဆိုဘီး တခြားစေခံလေဟှို စေလွှတ်ဘီးဟှာ ပြောစေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","အယ်ဘေမဲ့ ဖိခေါ်ဟှားသူလေဟှာ ဂရုစိုက်ဘဲန တယော့‑က်ဟှ လယ်ထဲဟှို သွားလိုက်ဘီး တခြားတယော့‑က်ဟှ သူ့ရဲ့ ကူသယ်လောက်ငန်းဟှို သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","တခြားသူလေဟှလည်း စေခံလေဟှို ဖမ်းဘီး ရိုက်ဘီး သတ်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","အယ်ကြောန့် မန်းဂီးဟှာ ရရာတိုင်း ဒေါသဖြစ်ဘီး သူ့ရဲ့ စစ်သားလေဟှို လွှတ်ဘီးဟှာ အယ်လူသတ်မားလေဟှို သတ်စေဘီး သူးနို့ဗြို့ဟှိုလည်း မီးရှို့စေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","အယ်ဘီးန သူဟှာ စေခံလေဟှို ခေါ်ဘီး ‘မင်္ဂလာဆောန်ပွဲ ဆင်သင့်ဖြစ်နေဘီ။ အယ်ဘေမဲ့လည်း ဖိခေါ်ဟှားသူလေဟှာ အယ်ပွဲန ထိုက်တန်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","လမ်းမဂီးလေဟှို သွားဘီးဟှာ နန်းနို့တွိမျှဟှူ လူလေဟှို ခေါ်ဖိဂေ့’ ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","အယ်ကြောန့် စေခံလေဟှာ လမ်းမလေဟှို သွားဘီးဟှာ တွိမျှဟှူလူဆိုး၊ လူကောန်းလေဟှို ဖိခေါ်လေဟှယ်။ မင်္ဂလာခန်းမလည်း လူလေန ပ္လဲ့ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“မန်းဂီးဟှာ ဧည့်သယ်လေဟှို ကေ့ရှုဟှို့တွပ် ကြွလာခီမာ မင်္ဂလာဆောန်ပွဲရဲ့ ဝတ်ဟှို ဝတ်ဘဲဟှူ လူတယော့‑က်ဟှို ဗြင်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","မန်းဂီးဟှ ‘မိဆွေ၊ မင်္ဂလာဆောန်ဗွဲရဲ့ ဝတ်ဟှို ဝတ်ဘဲန ဖြားဖြစ်ကြောန့် ဝမ်လာနူး’ ဆိုဘီး မေးလေဟှယ်။ အယ်ဘေမဲ့ အယ်သူဟှာ ဖြားလည်းပ္လန်ဖြေဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","အယ်ခီမာ မန်းဂီးဟှ စေခံလေဟှို ‘အယ်သူရဲ့ ခေနလတ်ဟှို တောက်ဘီးဟှာ ပ္လန်ရပ် မှောန်မိုက်ထဲဟှို ပို့လိုက်ဂေ့။ အယ်မူနေရာမာ သူဟှာ ငိုကြွေးဘီး အံသွားခဲက္လိနေရလေ့မယ်’ ဆိုဘီး ပြောလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","အယ်ဘီးန ယေရှုဟှ “ဖိခေါ်ခံရဟှူ သူလေ ဘောင်းဂီးရှိဘေမဲ့လည်း ဝီးကော့‑က်ခံရဟှူ သူလေဟှာ နဲလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","အယ်ဘီးန ဖာရိရှဲလေဟှာ ထွပ်ဟှားဘီး ကိုယ်တော်ရဲ့စကားဟှို ဖယ်မျိုး ထောန်ချော့‑က်ဆင်ဘီး မေးမြန်းရမယ် ဆိုဇာဟှို ကြံစည်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","သူးနို့လေဟှာ သူးနို့ရဲ့ တဗဲ့လေဟှို ဟေရုဒ်ရဲ့ လူလေနတူးဒူး ကိုယ်တော်နားဟှို စေလွှတ်လိုက်ဟှယ်။ သူးနို့ဟှ “ဆရာ၊ ကိုယ်တော်ဟှာ သမ္မာတရားဟှို ပြောဟှယ် ဆိုဇာဟှို ကျွန်တော့်ဟှားလေ သိပါဟှယ်။ ဖယ်သူ့ဟှိုမှလည်း ကြော့‑က်ဘဲန၊ လူလေရဲ့ မျစ်နှာဟှိုလည်း ထော့‑က်ဘဲန ဘုရားသခင်ရဲ့ တရားလမ်းဟှို သွန်သန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","အယ်ကြောန့် ကိုယ်တော်ဟှ ဖယ်မျိုး ထန်မှတ်ပါနူး။ ကျွန်တော်ဟှားလေဟှို မိန့်တော်မူပါ။ ကဲသာမန်းဂီးဟှို ခွန်ဆစ်သဇာဟှာ ပညတ်တော်န ညီဘဲ့လော။ အယ်မျိုးမှုဘဲဟှ ညီဟှလော” ဆိုဘီး မေးလျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","အယ်ဘေမဲ့လည်း ယေရှုဟှာ အယ်သူလေရဲ့ ဆိုးညစ်ဟှူ ကြံစည်ဟှို သိဟှိကြောန့် “သူတော်ကောန်း ယောန်ဆောန်ဟှူသူလေ! ဖြားဖြစ်ကြောန့် ငါ့ဟှို ထောန်ချော့‑က်ဆင်ဟှို့ ကြိုးစားနေဂေ့ဟှယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ခွန်ဆစ်သဟှို့တွပ် ဒန်းဂါးတပ္လားဟှို ပြကေ့ကေ့!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ သူးနို့လေဟှာ ဒေနာရိတပ္လားဟှို ယူလာဘီး ကိုယ်တော့်ဟှို ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ကိုယ်တော်ဟှ “အယ်မူဇာဟှ ဖယ်သူ့ရောက်ပေါင်န ဖယ်သူ့ကြောန်းရာနူး” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","သူးနို့ဟှ “ကဲသာမန်းဂီးရဲ့ပေါင်န ကဲသာမန်းဂီးရဲ့ ကြောန်းရာဖြစ်ပါဟှယ်” ဆိုဘီး ပ္လန်လျှော့‑က်ဂေ့လေဟှယ်။ အယ်ကြောန့် ယေရှုဟှ “အယ်ဆိုဟှာ ကဲသာမန်းဂီးရဲ့ အောက်စာဟှို ကဲသာမန်းဂီးဟှို ပေးဂေ့။ ဘုရားသခင်ရဲ့ အောက်စာဟှို ဘုရားသခင်ဟှို ပေးဂေ့” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","သူးနို့ဟှာ အယ်မျိုးကြားဟှူ ခီမာ သူးနို့ဟှာ ရရာတိုင်း အံ့ဩဂေ့ဘီးဟှာ ကိုယ်တော်နားဟှ ထွပ်ဟှားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","အယ်နေ့မာဘဲ့ ရှင်ပ္လန်ထမြော့‑က်ဟှူဇာ မှေ့ဟှ ဆိုဘီးဟှာ လတ်ခံဟှားဟှူ ဇဒ္ဒုကဲတချို့ဟှာ ကိုယ်တော်နားဟှို လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","အယ်သူလေဟှ “ဆရာ၊ လူတယော့‑က်ဟှာ သားမီးမှေ့ဘဲန သေဟှားမယ် ဆိုဟှာ နောန်ရဲ့မယားဟှို သူ့ညီဟှ ပေါန်းသင်းရမယ်။ ရလာဟှူ သားမီးလေအားဖြင့် သူ့နောန်ရဲ့ မျိုးနွယ်ဟှို ဆစ်ခံပေးရမယ် ဆိုဘီး မောရှေဟှ မိန့်မှာဟှားပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ကျွန်တော်ဟှားလေမာ ညီကို ခွန်နှေ့ယော့‑က်ရှိပါဟှယ်။ နောန်ဂီးဆောင်းဟှ အီထောန်က္လဘီးဟှာ သားမီးလေမှေ့ဘဲန သေဆောင်းဟှားဟှယ်။ အယ်ကြောန့် သူ့ရဲ့ မယားဟှို သူ့ညီဟှ ပေါန်းသင်းရပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ဒုတိယညီ၊ တတိယညီဟှနေ ခွန်နှေ့ယော့‑က်ထိ အယ်မျိုးဘဲ့ဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","နော့‑က်ဆောင်းမာ အယ်မီးမလည်း သေဆောင်းဟှားပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","အယ်ဆိုဟှာ ရှင်ပ္လန်ထမြော့‑က်ဟှူနေ့မာ အယ်မီးမဟှာ ညီကို ခွန်နှေ့ယော့‑က်ထဲမာ ဖယ်သူရဲ့ မယားဖြစ်မယ်နူး။ သူးနို့လေ ဂူလောင်းဟှာ အယ်မီးမန ပေါန်းသင်းဟှားဂေ့ဟှယ်” ဆိုဘီး မေးလျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ယေရှုဟှ “ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်းနို့လေဟှာ ကျမ်းစာဟှို နားလည်းဂေ့ဟှ။ ဘုရားသခင်ရဲ့ တဂိုးတော်ဟှိုလည်း သိဂေ့ဟှ။ အယ်ကြောန့် နန်းနို့ဟှာ ရရာတိုင်း လွဲမှားဂေ့လေဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ရှင်ပ္လန်ထမြော့‑က်ဟှူ ကာလမာ လူလေဟှာ ကောန်းဂန်တမန်လေမျိုးဘဲ့ ဖြစ်ဟှားဘီး အီထောန်ပြုဇာလေမှေ့ဘီ။ ");
INSERT INTO tvn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","သေဟှားလူလေရဲ့ ရှင်ပ္လန်ထမြော့‑က်ဟှူ ကြောန်းရာန ပတ်သတ်ဘီး ဘုရားသခင် ပြောဟှားဇာဟှို နန်းနို့ဖတ်ဖူးဟှလော။ ဘုရားသခင်ဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘ငါဟှာ အာဗြဟံရဲ့ ဘုရားသခင်၊ ဣဇာက်ရဲ့ ဘုရားသခင်၊ ယာကုပ်ရဲ့ ဘုရားသခင် ဖြစ်လေဟှယ်’ ဆိုဘီး ဘုရားသခင်ဟှ မိန့်တော်မူဟှားဟှယ်။ ကိုယ်တော်ဟှာ သေဟှူလူလေရဲ့ ဘုရား မှုဟှ။ သတ်ရှင်နေဟှူ လူလေရဲ့ ဘုရားဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","အယ်မျိုး သွန်သန်ရှင်းဟှို လူအောက်ဂီးဟှာ ကြားဟှူ ခီမာ အံ့ဩဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ယေရှုဟှ ဇဒ္ဒုကဲလေဟှို ဇာတ်ပေါ့‑က်ပိဟှားအောန် ဖြေလိုက်ဟှယ် ဆိုဇာဟှို ဖာရိရှဲလေကြားဟှူ ခီမာ သူးနို့ဟှာ စုဝေးလာဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","သူးနို့လေထဲဟှ ကျမ်းတတ်ဆရာ တယော့‑က်ဟှ ကိုယ်တော့်ဟှို မေးခွန်းတခုန ထောန်ချော့‑က်ဆင်ဟှို့တွပ် ကြိုးစားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ဆရာ၊ ပညတ္တိကျမ်းမာ ဖယ်ပညတ်ဟှာ ကီးမြတ်ဆောင်းဖြစ်ပါနူး” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ယေရှုဟှ “‘နန့်ရဲ့သခင်၊ ဘုရားသခင်ဟှို စိနှလောင်းကြွင်းမဲ့ ဉာဏ်ရှိဟှူမျှန ရှစ်ပါ။’ ");
INSERT INTO tvn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","အယ်ပညတ်ဟှာ ရေးကီးဆောင်းန ကီးမြတ်ဆောင်း ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ဒုတိယရေးကီးဆောင်း ပညတ်တော်ဟှ ‘နန့်ကိုယ်နန် ရှစ်မျိုးဘဲ့ နန့်ရဲ့ အီဇနီးရှင်းဟှို ရှစ်ပါ။’ ");
INSERT INTO tvn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","အယ်မူပညတ်နှေ့ပါးဟှာ မောရှေရဲ့ ပညတ်ကျမ်း တဇောင်လောင်းန ပရောဖက်ကျမ်းလေရဲ့ ချောက်ဘဲ့ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ဖာရိရှဲလေ စုဝေးဘီးနေဟှူ ခီမာ ယေရှုဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“နန်းနို့လေဟှာ မေရှိယဟှို ဖယ်မျိုးထန်မှတ်ဂေ့နူး။ ဖယ်သူရဲ့ သားဖြစ်ဟှယ်နူး” ဆိုဘီး သူးနို့ဟှို မေးတော်မူလေဟှယ်။ အယ်သူလေဟှ “ဒါဝိဒ်ရဲ့ သားတော်ဖြစ်ပါဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ယေရှုဟှ “အယ်ဆိုဟှာ ဒါဝိဒ်ဟှ သူ့ဟှို ဝိညာဉ်တော်အားဖြင့် ‘သခင်’ ဆိုဘီး ဖြားဖြစ်ကြောန့်ခေါ်ပါနူး။ ဒါဝိဒ်ဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ဘုရားသခင်ဟှ ငါ့ရဲ့ သခင်ဟှို ‘နန့်ရဲ့ ရန်သူလေဟှို နန့်ရဲ့ ခေဖွားအော့‑က်မာ ထားခန်ခီထိ ငါ့ရဲ့ ညာဖတ်မာ ထိုင်နေပါ’ ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","အယ်ဆိုဟှာ ဒါဝိဒ်ဟှာ မေရှိယဟှို ‘သခင်’ ဆိုဘီး ခေါ်ဟှယ် ဆိုဟှာ မေရှိယဟှာ ဖယ်မျိုးဖြစ်ဘီး ဒါဝိဒ်ရဲ့ မ္လေးမ္လစ်ဖြစ်နိုင်မယ်နူး” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ဖယ်သူလည်းဘဲ့ ကိုယ်တော့်ဟှို ဖြေပ္လန်ပေးဟှို့ တတ်နိုင်ဂေ့ဟှ။ အယ်နေ့ဟှနေစဘီး ဖယ်သူလည်းဘဲ့ ကိုယ်တော့်ဟှို မေးခွန်းမေးရဲဂေ့ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","အယ်ဘီးန ယေရှုဟှာ လူအောက်ဂီးန တဗဲ့တော်လေဟှို မိန့်တော်မူဇာဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ကျမ်းပြုဆရာန ဖာရိရှဲလေဟှာ မောရှေရဲ့ ထိုင်ခေါင်မာထိုင်ဘီး ပညတ်ကျမ်းဟှို အနတ်ဖွမ့်ဟှို့ ခွမ့်အာဏာရရှိဟှူ သူလေဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","အယ်ကြောန့် သူးနို့လေရဲ့ သွန်သန်ဟှူ ရာလေဟှို လိုက်နာဘီး ကျင့်သောင်းဂေ့။ အယ်ဘေမဲ့လည်း သူးနို့လေ ကျင့်ဟှူတိုင်း လိုက်ကျင့်ဂေ့န။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့လေဟှာ သူများဟှို သွန်သန်ဘီး သူးနို့ကိုယ်တိုင်ကျင့်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","သူးနို့လေဟှာ လေးလံဘီး ထမ်းရခတ်ဟှူ ဝန်ထောက်လေဟှို လူလေရဲ့ ခေါန်းထတ်ဟှို တန်တတ်လေဟှယ်။ အယ်ဘေမဲ့ သူးနို့ကိုယ်တိုင်ဟှ အယ်ဝန်ထောက်လေဟှို လတ်ဖျားန ထိရှင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","သူးနို့လောက်ဟှူဇာလေဟှို လူလေဗြင်ဟှို့ဘဲ့ လောက်တတ်ဂေ့လေဟှယ်။ သူးနို့လေရဲ့ နဖူးလေန လတ်မောန်းလေထတ်မာ ကျမ်းစာလတ်ဖွဲ့လေဟှို ကီးကီးမားမား လောက်ဘီးဟှာ ဝတ်တတ်ဂေ့လေဟှယ်! သူးနို့လေရဲ့ ဝတ်လောင်မာ ပန်းဗွား ဟှိုလည်း ကီးကီးမားမား ချောက်ဘီးဟှာ တတ်ဂေ့လေဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","စားသော့‑က်ဗွဲလေမာလည်း ကောန်းဆောင်းနေရာလေန ဝါလယ်ဇရပ်လေမာလည်း မြင့်မြတ်ဟှူ နေရာလေဟှိုဘဲ့ နှစ်သက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ရိုးရိုသေးသေန နှောက်ဆစ်ဇာဟှို လတ်ခံရှင်ဘီး ‘ဆရာ’ ဆိုဘီး ခေါ်ခံရဇာဟှို နှစ်သက်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","နန်းနို့လေဟှာ ‘ဆရာ’ ဆိုဘီး ခေါ်ခံဂေ့န။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်းနို့လေ ဂူလောင်းဟှာ ညီကိုလေ ဖြစ်ဘီး နန်းနို့လေမာ ဆရာတပါးဒဲဘဲ့ ရှိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","မ္လေဂီးထတ်မာ ဖယ်သူ့ဟှိုမှလည်း ‘ဖ’ ဆိုဘီး ခေါ်ဂေ့န။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကောန်းဂန်ဘောင်မာ နန်းနို့လေရဲ့ ‘ဖ’ တပါးဒဲဘဲ့ ရှိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","နန်းနို့လေဟှာ ခေါန်းဆောန်ဆိုဘီး ခေါ်ခံဂေ့န။ နန်းနို့လေရဲ့ ခေါန်းဆောန်ဟှာ ခရစ်တော် တပါးဒဲဘဲ့ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","နန်းနို့လေထဲမာ ကီးဆောင်းဖြစ်ဟှူ သူဟှာ နန်းနို့ရဲ့ စေခံဖြစ်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ကိုယ့်ကိုယ်ကိုယ် ချီးမြှော့‑က်ဟှူသူဟှာ နှိခ္လခံရလေ့မယ်။ ကိုယ့်ကိုယ်ကိုယ် နှိခ္လဟှူသူဟှာ ချီးမြော့‑က်ခံရလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","သူတော်ကောန်း ယောန်ဆောန်ဟှူ ကျမ်းပြုဆရာလေန ဖာရိရှဲလေ နန်းနို့လေဟှာ အမင်္ဂလာရှိလေဟှယ်! ကောန်းဂန်နိုင်ငံတော်ရဲ့ ခွဗော့‑က်ဟှို လူလေရှေ့မာ ပိဟှားဘီး နန်းနို့ကိုယ်တိုင်လည်း ဝမ်ဟှ။ ဝမ်ဟှို့ ကြိုးစားနေဟှူ သူလေဟှိုလည်း ဝမ်ဟှို့ ခွမ့်ပေးဟှ! ");
INSERT INTO tvn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","သူတော်ကောန်း ယောန်ဆောန်ဟှူ ကျမ်းပြုဆရာလေန ဖာရိရှဲလေ နန်းနို့လေဟှာ အမင်္ဂလာရှိလေဟှယ်! လူတယော့‑က်ဟှို ဘာသာသွမ်းဟှို့တွပ် ကူးကြောန်း၊ ရေကြောန်း လှည့်လည်တတ်လေဟှယ်! ဘာသာဝမ်ဘီးဟှူ သူလေဟှိုလည်း နန်းနို့လေထတ် နှေ့ဆဟှူ ငရဲသား ဖြစ်စေလေဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“လမ်းပြဟှူလူကန်းလေ၊ နန်းနို့လေဟှာ အမင်္ဂလာရှိလေဟှယ်! ‘ယော့‑က်ယော့‑က်ဟှ ဗိမာန်တော်ဟှို တိုင်တယ်ဘီး ကီဟှယ် ဆိုဟှာ အယ်ကီဆိုမှုဟှာ တည်ဟှ။ ဗိမာန်တော်ရဲ့ ရွှေဟှို တိုင်တယ်ဘီးကီမှဘဲ့ တည်ဟှယ်’ ဆိုဘီး နန်းနို့ပြောတတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","လူမိုက်လူကန်းလေ! ဖယ်ရာဟှ ပိုဘီး ရေးကီးဟှယ်နူး ရွှေဟှ ရေးကီးဟှယ်လော၊ ရွှေဟှို သန့်ရှင်းစေဟှူ ဗိမာန်တော်ဟှ ရေးကီးဟှယ်လော။ ");
INSERT INTO tvn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","အယ်ဘီးဟှာ ‘ယဇ်ပလ္လင်ဟှိုတိုင်တယ်ဘီး ကီဟှယ် ဆိုဟှာ အယ်ကီဆိုမှုဟှ တည်ဟှ။ ယဇ်ပလ္လင်ထတ်မာရှိဟှူ ပူဇော်သကာဟှို တိုင်တယ်ဘီး ကီမှဘဲ့ တည်ဟှယ်’ ဆိုဘီး နန်းနို့ပြောတတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","လူမိုက်လူကန်းလေ! ဖယ်ရာဟှ ပိုဘီး ရေးကီးဟှယ်နူး၊ အယ်ပူဇော်သကာဟှဘဲ့ ရေးကီးဟှယ်လော၊ အယ်မျိုးမှုဘဲနေဟှာ အယ်ပူဇော်သကာဟှို သန့်ရှင်းစေဟှူ ယဇ်ပလ္လင်ဟှဘဲ့ ရေးကီးဟှယ်လော။ ");
INSERT INTO tvn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","အယ်ကြောန့် ယဇ်ပလ္လင်ဟှို တိုင်တယ်ဘီး ကီဟှယ် ဆိုဟှာ ယဇ်ပလ္လင်န ယဇ်ပလ္လင်ထတ်မာ ရှိဟှူဇာလေ ဂူလောင်းဟှို တိုင်တယ်ဘီး ကီဆိုဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ဗိမာန်တော်ဟှို တိုင်တယ်ဘီး ကီဟှယ် ဆိုဟှာ ဗိမာန်တော်န ဗိမာန်တော်မာ ကိန်းဝပ်ဟှူဘုရားသခင်ဟှို တိုင်တယ်ဘီး ကီဆိုဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","အယ်ဘီးဟှာ ကောန်းဂန်ဘောင်ဟှို တိုင်တယ်ဘီး ကီဟှယ် ဆိုဟှာ ဘုရားသခင်ရဲ့ ပလ္လင်တော်န အယ်ပလ္လင်ထတ်မာ ထိုင်တော်မူဟှူသခင်ဟှို တိုင်တယ်ဘီး ကီဇာဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“သူတော်ကောန်းယောန်ဆောန်ဟှူ ကျမ်းပြုဆရာလေန ဖာရိရှဲလေ၊ နန်းနို့လေဟှာ အမင်္ဂလာရှိလေဟှယ်! နန်းနို့လေဟှာ ပန်ဇီး၊ စမွှတ်န ဇီယာလေဟှို ဆယ်ဖို့တဖို့ ပေးဂေ့ဟှယ်။ အယ်ဘေမဲ့ ပညတ်တရားထဲမာ ပိုဘီး ရေးကီးဟှူ တရားမျှတမှု၊ သနားကြင်နာမှုန သစ်စာရှိမှုဟှို လတ်လျူရှုဟှားဂေ့ဟှယ်။ အယ်မူဇာလေဟှို လောက်ရမယ်ဖြစ်ဘီး စဒူးဟှပြောဟှားဇာလေဟှိုလည်း ထားရစ်န။ ");
INSERT INTO tvn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","လမ်းပြဟှူလူကန်းလေ! နန်းနို့လေဟှာ ခြင်ကောန်ဟှို စစ်ထုဘီး သော့‑က်ဂေ့ဟှယ်။ အယ်ဘေမဲ့ ကုလားအုတ်ဟှို ကောန်လိုက်မျိုဂေ့လေဟှယ်!” ");
INSERT INTO tvn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“သူတော်ကောန်း ယောန်ဆောန်ဟှူ ကျမ်းပြုဆရာလေန ဖာရိရှဲလေ၊ နန်းနို့ဟှာ အမင်္ဂလာရှိလေဟှယ်! နန်းနို့လေဟှာ ခွပ်နစံရဲ့ပ္လန်ဟှိုဘဲ့ စင်ကြယ်စေဘီး နန်းနို့ရဲ့ စိထဲမာ လောဘလွန်ကျူးရှင်းန ကြမ်းဖတ်မှုလေ ပ္လဲ့နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","မျစ်စိဗြင်ဘဲဟှူ ဖာရိရှဲလေ! ခွပ်ရဲ့ထဲဟှိုဘဲ့ ရင်စင်ကြယ်စေပါ! အယ်မျိုးဆိုဟှာ ပ္လန်ဟှလည်း စင်ကြယ်ဟှားလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“သူတော်ကောန်းယောန်ဆောန်ဟှူ ကျမ်းပြုဆရာလေန ဖာရိရှဲလေ၊ နန်းနို့ဟှာ အမင်္ဂလာရှိလေဟှယ်! နန်းနို့လေဟှာ ထူးဖ္လူသုဟှားဟှူ သန်းခ္လိုင်းဂူနတူဂေ့ဟှယ်။ အယ်အုဂူလေဟှာ အပ္လန်မာ လှပတင့်တယ် ဘေမဲ့လည်း ထဲမာ ပေါက်ပွနေဟှူ လူသေလေရဲ့ ရိုးစုလေန ပ္လဲ့နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","အယ်မျိုးဘဲ့ နန်းနို့လေဟှာ အပ္လန်အားဖြင့် လူလေရှေ့မာ ဖြောန့်မတ်ဟှယ် ဆိုဘီး ထန်ရဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ထဲမာ ဟန်ဆောန်ဟှူ ဇာလေ၊ ဆိုးညစ်ဟှူ ဇာလေန ပ္လဲ့နေလေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“သူတော်ကောန်းယောန်ဆောန်ဟှူ ကျမ်းပြုဆရာလေန ဖာရိရှဲလေ၊ နန်းနို့ဟှာ အမင်္ဂလာရှိလေဟှယ်! နန်းနို့လေဟှာ ပရောဖက်လေရဲ့ သန်းခ္လိုင်းအုဂူလေဟှို တည်ဆော့‑က်ဘီး ဖြောန့်မတ်ဟှူသူလေရဲ့ သန်းခ္လိုင်းအုဂူလေဟှို တန်ဆာဆင်ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‘နို့လေဟှာ နို့လေရဲ့ ဘိုးဘေးလေရဲ့ လတ်ထတ်မာ ရှိမယ် ဆိုဟှာ ပရောဖက်လေဟှို သတ်ဖြတ်ဟှို့တွပ် ပါဝမ်သူလေဖြစ်ဟှို့ မှုဟှ’ ဆိုဘီး ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","အယ်ကြောန့် နန်းနို့လေဟှာ ပရောဖက်လေဟှို သတ်ဟှူ မ္လေးမ္လစ်လေ ဖြစ်ကြောန်းဟှို နန်းနို့ကိုယ်တိုင် သတ်သေခံဂေ့ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","အယ်ဘီးဟှာ နန်းနို့ရဲ့ ဘိုးဘေးလေ စပြုဟှားဇာဟှို ပီးဆောင်းအောန် ဆစ်ဘီး လောက်ဆောန်ဂေ့ပါ! ");
INSERT INTO tvn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","မွီဗွေးအမျိုးလေ! နန်းနို့လေဟှာ ငရဲမာ ပြစ်စီရင်ခံရရှင်းဟှနေဘီး ဖယ်မျိုး လွတ်လေ့မယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","အယ်ကြောန့် နန်းနို့ဟှို ငါပြောမယ်။ နန်းနို့နားဟှို ပရောဖက်လေ၊ ပညာရှိလေ၊ ကျမ်းပြုဆရာလေဟှို ငါစေလွှတ်မယ်။ တချို့လေဟှို သတ်လေ့မယ်။ တချို့လေဟှို လတ်ဝါးကပ်တိုင်မာ တန်သတ်ဂေ့လေ့မယ်။ တချို့လေဟှိုလည်း ဝါလယ်ဇရပ်လေမာ ရိုက်ဘီး တချို့လေဟှို တဗြို့ဘီးတဗြို့ လိုက်ဖမ်းဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","အယ်ကြောန့် ဖြောန့်မတ်ဟှူ အာဗေလဟှနေစဘီး ဗိမာန်တော်န ယဇ်ပလ္လင်ကြားမာ နန်းနို့သတ်ဟှားဟှူ ဗာရခိသား ဇာခရိထိအောန် မ္လေဂီးထတ်မာ သွန်းလောန်းဟှူ သူတော်ကောန်းလေရဲ့ သွီးဟှာ နန်းနို့လေထတ်ဟှို သတ်ရော့‑က်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ငါ မှန်ပြောမယ်၊ အယ်မူ သတ်ဖြတ်မှုလေတွပ် ပြစ်ဒန်ဟှာ အယ်နေ့ခေတ် လူလေထတ်ဟှို က္လရော့‑က်လေ့မယ်!” ");
INSERT INTO tvn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“အို၊ ယေရုရှလင်ဗြို့၊ ယေရုရှလင်ဗြို့! နန်ဟှာ ပရောဖက်လေဟှို သတ်ဘီး ဘုရားသခင်စေလွှတ်ဟှူ တမန်လေဟှိုလည်း က္လော့‑က်ခဲန ပစ်လေဟှယ်! ကြစ်မဂီးဟှာ ကြစ်သားဂန်းဟှားလေဟှို သူ့ရဲ့ တွန်အော့‑က်မာ စုဘီးထားဟှူမျိုး ငါဟှာ နန့်ဟှို စုဘီးထားဟှို့တွပ် ခါဘီးခါ လိုရှင်ဟှားဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","အယ်ကြောန့် နန့်ရဲ့ ဗိမာန်တော်ဟှို ဘုရားသခင်ဟှာ စွန့်ပစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","နန့်ဟှို ငါပြောမယ်။ ‘ဘုရားသခင်ရဲ့ နာမတော်န ကြွလာဟှူသခင်ဟှာ မင်္ဂလာရှိပါစေ’ ဆိုဘီး နန်ပြောခန်ထိ ခုခီဟှနေစဘီး နန်ဟှာ ငါ့ဟှို လောင်းဝဗြင်ရလေ့မယ် မှုဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ယေရှုဟှာ ဗိမာန်တော်ဟှနေ ထွပ်လာဟှူ ခီမာ တဗဲ့တော်လေဟှ ဗိမာန်တော်ရဲ့ ဆော့‑က်ဦးလေဟှို ပြဟှို့တွပ် ကိုယ်တော်နားဟှို လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ကိုယ်တော်ဟှ “အယ်ဆော့‑က်ဦးလေဟှို နန်းနို့လေ ဗြင်ဂေ့ဟှယ် မှုဟှလော။ ငါ မှန်ပြောမယ်။ အယ်နေရာမာ ဖြိုခ္လဇာခံရဘဲန တခြားက္လော့‑က်ထတ်မာ ကျန်ရစ်ဟှူ က္လော့‑က်တလောင်းလည်းမှေ့အောန် က္လော့‑က်လေ ဂူလောင်းဟှို ဖြိုခ္လလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ယေရှုဟှာ သံလွင်တောန်ထတ်မာ ထိုင်နေဟှူခီ တဗဲ့တော်လေဟှာ တခြားလူလေပါဘဲန ကိုယ်တော်နားဟှို လာဂေ့ဟှယ်။ သူးနို့ဟှ “အယ်မူဇာလေဟှာ ဖယ်ခီမာ ဖြစ်မယ်နူး၊ ကိုယ်တော်ကြွလာဟှူခီန ကမ္ဘာကူဆောင်းဟှူ ခီမာ ဖြားနိမိတ်လေ ဖြစ်ပေါ်လာမယ်နူး၊ ကျွန်တော်ဟှားလေဟှို မိန့်တော်မူပါ” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ယေရှုဟှ “နန်းနို့လေဟှို ဖယ်သူလည်း လှည့်ဇားဘဲနေအောန် ဒိထားဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","လူလေဘောင်ဂီးဟှ ‘ငါဟှာ ခရစ်တော်ဖြစ်ဟှယ်!’ ဆိုဘီး ငါ့နာမဟှို သောင်းဘီးဟှာ လူလေဟှို လှည့်ဇားဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","နန်းနို့လေဟှာ စစ်ပွဲလေန စစ်တိုက်ဟှူဒန်းလေဟှို ကြားရဂေ့လေ့မယ်။ အယ်ဘေမဲ့ ကြော့‑က်လန့်ဂေ့န။ အယ်မူဇာလေဟှာ ဖြစ်လာရမယ်။ အယ်ဘေမဲ့ ဆောင်းဟှို ရော့‑က်သေးဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","လူမျိုးတမျိုးန တမျိုး၊ တနိုင်ငံန တနိုင်ငံ စစ်ဖြစ်ဂေ့လေ့မယ်။ နေရာနှံ့မာ စာရေဇာ ခေါန်းပါးဘီးဟှာ မ္လေငလျင်လှောက် လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","အယ်မူဇာလေ အားလာင်းဟှာ သားမွီးမျိုး ခံစားရဟှူ နာကျင်မှုရဲ့ စဘဲ့ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“အယ်ဘီးဟှာ နန်းနို့လေဟှာ ညှဉ်းဆဲခံရဟှို့ အပ်ခံရဂေ့ဘီး သေသတ်ရှင်းဟှို ခံရဂေ့လေ့မယ်။ နန်းနို့လေဟှာ ငါ့နာမကြောန့် လူမျိုးလေ ဂူလောင်းရဲ့ မူးတီးဂေ့ဇာဟှို ခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","အယ်ခီမာ လူဘောင်ဂီးဟှာ သူးနို့ရဲ့ ယောင်ကြည်မှုဟှို စွန့်ပစ်လေ့မယ်။ သူးနို့ဟှာ ယော့‑က်နယော့‑က် မူးတီးဂေ့ဘီး သစ်စာဖော့‑က်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ပရောဖက် တုယောန်လေ ဘောင်ဂီး ပေါ်လာဂေ့လေ့မယ်။ အယ်ဘီးဟှာ လူလေဘောင်ဂီးဟှို လှည့်ဇားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ဆိုးညစ်မှုလေ များပြားလာဟှိကြောန့် လူလေရဲ့ ရှစ်မြစ်တာဟှာ ခေါန်းဘားဟှားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","အယ်ဘေမဲ့ ဆောင်းထိ တည်ကြည်ဟှူသူဟှာ ကယ်တန်ရှင်းဟှို ခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","နိုင်ငံတော်ကြောန်း အယ်ဒန်းကောန်းဟှာ လူမျိုးတိုင်းဟှို သတ်သေဖြစ်ဟှို့တွပ် ကမ္ဘာတခုလောင်းမာ ဟောပြောဂေ့လေ့မယ်။ အယ်ဘီးမှ ဆောင်းဟှာ ရော့‑က်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“အယ်ကြောန့် နန်းနို့လေဟှာ ပရောဖက်ဒံယေလ ပြောဟှားတိုင်းဘဲ့ ‘ဖျစ်ဆီးတတ်ဘီး ရွံဇာကောန်းဟှူဇာ’ ဟှို ဗြင်ရလေ့မယ်။ အယ်မူဇာဟှာ သန့်ရှင်းဟှူနေရာမာ ရပ်နေလေ့မယ်” (စာဖတ်သူဟှာ အယ်မူဓိပါယ်ဟှို နားလည်ပါစေ!) ");
INSERT INTO tvn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","အယ်ဆိုဟှာ ယုဒပြည်မာရှိဟှူ လူလေဟှာ တောန်ထတ်ဟှို ပ္လေးရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","အီးခေါန်မိုးထတ်မာ ရှိနေဟှူသူဟှ အီထဲဟှ ပစ်စီးလေဟှို ယူဟှို့တွပ် အော့‑က်ဟှို ဆင်းစေန။ ");
INSERT INTO tvn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","လယ်ထဲမာရှိဟှူသူဟှာ သူ့ရဲ့ဝတ်လောင်ဟှို ယူဟှို့တွပ် အီဟှို ပ္လန်စေန။ ");
INSERT INTO tvn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","အယ်မူနေ့ရစ်လေဟှာ ဗိုက်ရှင်မလေန သားရှင်မိလေဟှာ ရရာတိုင်း ကြော့‑က်လန့်ဂေ့လေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","နန်းနို့လေ ထွပ်ပ္လေးရဟှို့ခီဟှာ ဆောန်းကာလန ဒန်းနေ့မာ ဖြစ်ဘဲဟှို့တွပ် ဆုတောန်းဂေ့ပါ! ");
INSERT INTO tvn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကမ္ဘာဦးဟှနေဘီး ခုခီထိ ဖြစ်ဖူးဘဲဟှူ ဆင်းရဲဒေါက်ခလေဟှာ အယ်ကာလမာ က္လရော့‑က်လာလေ့မယ်။ အယ်မျိုးလည်း နော့‑က်တခါဖြစ်လေ့ဟှို့မှုဘီ။ ");
INSERT INTO tvn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ဘုရားသခင်ဟှာ အယ်နေ့ရစ်လေဟှို တိုစေဘဲဟှ ဆိုဟှာ တယော့‑က်လည်းဘဲ့ သတ်ဘေးဟှလွတ်ဟှို့ မှုဟှ။ အယ်ဘေမဲ့ ဘုရားသခင် ဝီးကော့‑က်ဟှားဟှူ လူလေတွပ် အယ်နေ့ရစ်လေဟှို တိုစေတော်မူလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“အယ်ဘီးဟှာ ယော့‑က်ယော့‑က်ဟှ နန်းနို့ဟှို အယ်မျိုးပြောမယ် ဆိုဟှာ ‘ကေ့ကေ့ပါ။ အယ်နေရာမာ ခရစ်တော်ရှိဟှယ်!’ အယ်မျိုးမှုဘဲနေဟှာ ‘ဟှိုနေရာမာ ခရစ်တော်ရှိဟှယ်!’ ဆိုဟှာ ယောင်ကြည်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ဖြားဖြစ်နူးဆိုဟှာ မေရှိယ တုယောန်လေန ပရောဖက် တုယောန်လေဟှာ ပေါ်လာဘီး သူးနို့ဟှာ ဖြစ်နိုင်မယ် ဆိုဟှာ ဘုရားသခင် ဝီးကော့‑က်ဟှားဟှူ လူလေဟှိုလည်း လှည့်ဇားဟှို့တွပ် ကီးမားဟှူ နိမိတ်လတ်ခဏာလေန အံ့ဩဘွယ်လေဟှို ပြဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","နားထောန်ဂေ့! အယ်မူဇာလေဖြစ်ခန် နန်းနို့လေဟှို ငါပြောဟှားဘီ။” ");
INSERT INTO tvn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“အယ်ကြောန့် လူလေဟှ ‘ကေ့ကေ့ပါ။ မေရှိယဟှာ တောထဲမာရှိဟှယ်!’ ဆိုဘီး ပြောမယ် ဆိုဟှာ အယ်နေရာဟှို သွားဂေ့န။ ‘အီခန်းထဲမာရှိဟှယ်!’ ဆိုဘီး ပြောမယ် ဆိုဟှာလည်း ယောင်ကြည်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လျှပ်စီးဟှာ ရှေ့ဟှနေဘီး နော့‑က်ထိလာလန်းမျိုးဘဲ့ လူ့ရဲ့သားဟှာ ကြွလာလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“သေကောန်ရှိဟှူ နေရာတိုင်းမာ လင်းတလေ စုဝေးနေဂေ့လေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“အယ်နေ့ရစ်လေရဲ့ ဆင်းရဲဒေါက်ခလေ က္လရော့‑က်လာဘီးန ရှစ်ရှင်းဘဲ့ နေဟှာ မှောန်မိုက်လေ့မယ်။ လဟှလည်း လန်းရောန်ပေးဟှို့ မှုဟှ။ ကြယ်လေလည်း ကောန်းဂန်ဟှ ကွီက္လလေ့မယ်။ ကောန်းဂန်တဂိုးလေဟှာ လှောက်ခါဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","အယ်ဘီးန လူ့သားရဲ့ နိမိတ်လတ်ခဏာဟှာ ကောန်းဂန်မာ ပေါ်ထွပ်လာလေ့မယ်။ လူ့ရဲ့သားဟှာ မိုးတီဟှို စီးဘီး ကီးမားဟှူ ဖောင်းတဂိုးန ကြွလာဟှူဇာဟှို ကမ္ဘာမ္လေမာရှိဟှူ လူမျိုးလေ ဂူလောင်းဟှာ ဗြင်ဂေ့ဟှူ ခီမာ ငိုကြွေးဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","အယ်ဘီးဟှာ လူ့ရဲ့သားဟှာ သံက္လယ်ဟှူ တံပိုးသံနတူးဒူ သူ့ရဲ့ ကောန်းဂန်တမန်လေဟှို ရပ်လေးမျစ်နှာဟှို စေလွှတ်လေ့မယ်။ အယ်ဘီးဟှာ သူးနို့ဟှာ ကိုယ်တော် ဝီးကော့‑က်ဟှားဟှူ သူလေဟှို မ္လေဂီး တဖတ်စွန်းဟှနေဘီး မ္လေဂီး တဖတ်စွန်းထိအောန် စုသီးတော်မူလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“သဖန်းဗန်ဟှနေ အယ်သင်ဂန်းဇာယူဂေ့။ သဖန်းဗန်လေမာ ခတ်လတ်လေဟှာ စီးစိုဘီး ဝပ်နုလေ ထွပ်လာခီဟှာ နွီကာလနီးလာဘီ ဆိုဇာဟှို နန်းနို့သိဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","အယ်မျိုးဘဲ့ နန်းနို့လေဟှာ အယ်မူဇာလေ ဂူလောင်းဟှို ဗြင်ရခီမာ လူ့ရဲ့သားဟှာ ခွဗော့‑က်ဝနားဟှို ရော့‑က်နေဘီဆိုဇာဟှို သိမှတ်ဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ငါ မှန်ပြောမယ်၊ ခု သတ်ရှင်နေဟှူ လူလေ ဂူလောင်း သေခန်မာ အယ်မူဇာလေ ဂူလောင်းဟှာ ဖြစ်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ကောန်းဂန်န မ္လေဂီးဟှာ ကွယ်ပျော့‑က်ဟှားလေ့မယ်။ အယ်ဘေမဲ့ ငါ့စကားဟှာ လောင်းဝ ကွယ်ပျော့‑က်ဟှားလေ့မယ် မှုဟှ။” ");
INSERT INTO tvn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“အယ်ဘေမဲ့လည်း အယ်နေ့ရစ်၊ အယ်ခီနာရီန ပတ်သတ်ဘီး ဖယ်သူလည်း သိဟှ။ ကောန်းဂန်တမန်လေ သိဟှ။ သားတော်လည်း သိဟှ။ ဖတပါးဒဲဘဲ့ သိတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","လူ့ရဲ့သား ကြွလာဟှူ ခီဟှာ နောဧရဲ့ နေ့ရစ်လေမျိုးဘဲ့ ဖြစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ရေကီးရှင်း ဖြစ်ခန် နေ့ရစ်လေမာ နောဧဟှာ သန်းဖောထဲဟှို ဝမ်ဟှူ နေ့ထိ လူလေဟှာ စားသော့‑က်ရင်း၊ မင်္ဂလာဆောန်နေဂေ့ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ရေကီးလာဘီး သူးနို့လေ ဂူလောင်းဟှို သေကြေ ပျစ်စီးဟှားထိတိုင် သူးနို့ဟှာ ဒိလတ်လွတ် နေဂေ့လေဟှယ်။ လူ့ရဲ့သား ကြွလာဟှူ ခီမာလည်း အယ်မျိုးဘဲ့ဖြစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","အယ်ခီမာ လဲဗ္လန်ထဲမာ လောက်လောက်နေဟှူ လူနှေ့ယော့‑က်ထဲဟှ တယော့‑က်ဟှို သီးယူဘီးဟှာ တယော့‑က်ဟှ ကျန်ရစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","က္လိဆောင်က္လိနေဟှူ မီးမ နှေ့ယော့‑က်ထဲဟှ တယော့‑က်ဟှို သီးယူဘီး တယော့‑က်ဟှ ကျန်ရစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","အယ်ကြောန့် ဒိနစောန့်နေဂေ့ပါ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်းနို့လေရဲ့ သခင်ဟှာ ဖယ်နေ့ရစ်မာ ရော့‑က်လာမယ် ဆိုဇာဟှို နန်းနို့ သိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","အီဇရှင်ဟှာ ခိုးလာဟှို့ခီဟှို သိနေဟှယ် ဆိုဟှာ အိဘဲန စောန့်နေဘီး သူ့ရဲ့ အီဟှို ဖော့‑က်ထွမ်းဟှို့တွပ် ခွမ့်ပြုဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","အယ်ကြောန့် နန်းနို့လေလည်း ဆင်သင့်ဖြစ်နေဂေ့။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်းနို့လေ ထန်မှတ်ဘဲဟှူ ခီနာရီမာ လူ့ရဲ့သားဟှာ ကြွလာလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“အယ်ဆိုဟှာ သစ်စာန ပညာရှိဟှူ စေခံဟှ ဖယ်သူနူး။ တခြားစေခံလေဟှို အောက်ချောက်ဟှို့တွပ်န ခီတန်ဟှာ စားဇာလေ ထုပေးဟှို့ သူ့သခင် ခန့်ဟှားဟှူ သူဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","သူ့သခင်ပ္လန်လာဟှူ ခီမာ အယ်မူတိုင်းဘဲ့ လောက်ဆောန်နေဇာဟှို သခင်တွိမယ် ဆိုဟှာ အယ်စေခံဟှာ မင်္ဂလာရှိဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ငါ မှန်ပြောမယ်၊ သခင်ဟှာ သူ့ရဲ့ ပစ်စီးအောက်စာလေ ဂူလောင်းဟှို စီမံအောက်ချောက်ဟှို့တွပ် အယ်စေခံဟှို ခန့်ဟှားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","အယ်ဘေမဲ့ ဆိုးဟှူစေခံဟှ သူ့ရဲ့စိထဲမာ ‘ငါ့သခင်ဟှာ တော်တော်န လာဟှို့ မှုဟှ’ ဆိုဘီး ပြောဘီးန၊ ");
INSERT INTO tvn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","တခြားကျွန်လေဟှို ရိုက်ဘီးဟှာ ရစ်သမားလေန သော့‑က်စားနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","အယ်ကျွန်ရဲ့ သခင်ဟှာ သူမျှော်လင့်ဘဲဟှူ နေ့ရစ်၊ ကြားသိဘဲဟှူ ခီနာရီမာ ရော့‑က်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","အယ်စေခံဟှို ကီးမားဟှူ ပြစ်ဒန်ပေးဘီးဟှာ သူတော်ကောန်း ယောန်ဆောန်ဟှူ သူလေနတူးဒူ နေရလေ့မယ်။ အယ်နေရာမာ သူဟှာ ငိုကြွေးဘီး၊ အံသွားခဲက္လိဘီးဟှာ နေရလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“အယ်မူခီမာ ကောန်းဂန်နိုင်ငံတော်ဟှာ ဒို့သားဟှို ကြိုဟှို့တွပ် သူးနို့ရဲ့ မီးခွပ်လေယူဘီး ထွပ်ဟှားဟှူ ဒို့သမီးဆယ်ယော့‑က်န တူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","သူးနို့ထဲဟှ ငါးယော့‑က်ဟှာ မိုက်မဲဟှူသူလေဖြစ်ဘီး ငါးယော့‑က်ဟှာ ပညာရှိလေဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","မိုက်မဲဟှူသူလေဟှာ မီးခွပ်လေဟှိုဘဲ့ယူဘီး ဆီဟှို ယူဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ပညာရှိဟှူသူလေဟှာ မီးခွပ်လေနတူးဒူ ဆီဟှိုလည်း ယူဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ဒို့သားဟှာ လာသေးဘဲနနေဟှူကြောန့် သူးနို့လေဂူလောင်းဟှာ အိငိုက်လာဘီး အိမွိဟှားလေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ညဉ့်နတ်သန်းဂေါန်မာ ‘ဒို့သားရော့‑က်လာဘီ! ကြိုဟှို့ထွပ်လာဂေ့ပါ!’ ဆိုဘီး အော်သံထွပ်ပေါ်လာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","အယ်ခီမာ ဒို့သမီးလေဟှာ ထဘီးဟှာ သူးနို့လေရဲ့ မီးခွပ်လေဟှို ပြင်ဆင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","မိုက်မဲဟှူသူလေဟှ ‘နို့လေရဲ့မီးခွပ် မီးသေဟှမယ်။ အယ်ကြောန့် နန်းနို့ရဲ့ ဆီဟှို နဲနဲပေးပါ’ ဆိုဘီး ပညာရှိဟှူ သူလေဟှို တောန်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ပညာရှိဟှူ သူလေဟှ ‘အယ်မျိုးလောက်မယ် ဆိုဟှာ နန်းနို့န နို့လေတွပ် ဆီလော့‑က်ဟှို့ မှုဟှ။ အယ်ကြောန့် ဆီရောန်းမားနားဟှို သွားဘီး ဝယ်ဂေ့ပါ’ ဆိုဘီး ပ္လန်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","မိုက်မဲဟှူသူလေဟှာ ဆီဝယ်သွားနေဒူးမာ ဒို့သားဟှာ ရော့‑က်လာဟှယ်။ ဆင်သင့်ရှိနေဟှူ ဒို့သမီးလေဟှာ ဒို့သားနတူးဒူ အီတတ်ဗွဲဟှို ဝမ်ဘီးဟှာ ခွဗော့‑က်ဟှို ပိဟှားလိုက်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“မိုက်မဲဟှူ ဒို့သမီးလေလည်း ရော့‑က်လာဘီးဟှာ ‘သခင်၊ သခင်! ကျွန်မဟှားလေဟှို ခွဗော့‑က်ဖွမ့်ပေးပါ!’ ဆိုဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","အယ်ဘေမဲ့ ဒို့သားဟှ ‘နန်းနို့လေဟှို ငါမှန်ပြောမယ်၊ နန်းနို့လေဟှို ငါသိဟှ!’ ဆိုဘီး ပ္လန်ပြောဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“အယ်ကြောန့် နန်းနို့လေလည်း အယ်နေ့အယ်ခီဟှို သိဘဲဟှူကြောန့် ဒိနစောန့်နေဂေ့ပါ။” ");
INSERT INTO tvn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ကောန်းဂန်နိုင်ငံတော်ဟှာ ခရီးထွပ်ဟှို့ လူတယော့‑က်ဟှ သူ့စေခံလေဟှို ခေါ်ဘီးဟှာ သူ့ရဲ့ ပစ်စီးအောက်စာလေဟှို အပ်ပေးရစ်ဟှူ သူနတူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","အယ်သူဟှာ တယော့‑က်ဟှို ရွှေဒန်းဂါး ၅,၀၀၀၊ တယော့‑က်ဟှို ရွှေဒန်းဂါး ၂,၀၀၀၊ တယော့‑က်ဟှို ရွှေဒန်းဂါး ၁,၀၀၀ ဟှို ရည်ချင်းရှိဟှူတိုင်း အပ်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ရွှေဒန်းဂါး ၅,၀၀၀ ဟှို ရဟှူသူဟှ ပ္လန်ဘီးရင်းနှီးလောက်ဟှူကြောန့် နော့‑က်ထပ် ရွှေဒန်းဂါး ၅,၀၀၀ ဟှို မ္လတ်ရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","အယ်မျိုးဘဲ့ ရွှေဒန်းဂါး ၂,၀၀၀ ဟှို ရဟှူသူဟှလည်း ပ္လန်ရင်းနှီးလောက်ဟှူကြောန့် ရွှေဒန်းဂါး ၂,၀၀၀ ဟှို မ္လတ်ပ္လန်ရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","အယ်ဘေမဲ့ ရွှေဒန်းဂါး ၁,၀၀၀ ဟှို ရဟှူသူဟှ သူ့သခင်ရဲ့ ကပ်လေဟှို တွမ်းတူးဘီးဟှာ မ္လေထဲမာ မ္လောက်ဟှားလေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“နှစ်ကာလကြာဘီးန အယ်စေခံလေရဲ့ သခင်ဟှာ ပ္လန်လာဘီး သူးနို့လေန စာရင်းရှင်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ရွှေဒန်းဂါး ၅,၀၀၀ ဟှို ရဟှူသူဟှ မ္လတ်ရဟှူ ရွှေဒန်းဂါး ၅,၀၀၀ ဟှိုလည်း ယူလာဟှယ်။ သူဟှ ‘သခင်၊ ကိုယ်တော်ဟှာ ကျွန်တော်ဟှို ရွှေဒန်းဂါး ၅,၀၀၀ ဟှို အပ်ပေးဟှားပါဟှယ်။ ကေ့ကေ့ပါ! နော့‑က်ထပ် ရွှေဒန်းဂါး ၅,၀၀၀ ဟှိုလည်း မ္လတ်ရပါဟှယ်’ ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","သူ့ရဲ့ သခင်ဟှ ‘ကောန်းလေဟှယ်။ နန်ဟှာ သစ်စာရှိဟှူ စေခံကောန်း! နန်ဟှာ သေးငယ်ဟှူ မှုမာ သစ်စာရှိလေဟှယ်။ အယ်ကြောန့် ကီးမားဟှူ မှုလေဟှိုလည်း နန့်ဟှို ငါအပ်ပေးအူးမယ်။ နန့်ရဲ့ သခင်နတူးဒူ စည်းဇိမ်ဟှို ဝမ်ဇားပါ!’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ရွှေဒန်းဂါး ၂,၀၀၀ ဟှို ရဟှူ သူဟှလည်း လာဘီးဟှာ ‘သခင်၊ ကိုယ်တော်ဟှာ ရွှေဒန်းဂါး ၂,၀၀၀ ဟှို ကျွန်တော်ဟှို အပ်ပေးဟှားပါဟှယ်။ ကေ့ကေ့ပါ! နော့‑က်ထပ် ရွှေဒန်းဂါး ၂,၀၀၀ ဟှိုလည်း မ္လတ်ရပါဟှယ်’ ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","သခင်ဟှ ‘ကောန်းလေဟှယ်။ သစ်စာရှိဟှူ စေခံကောန်း! နန်ဟှာ သေးငယ်ဟှူမှုမာ သစ်စာရှိလေဟှယ်။ အယ်ကြောန့် ကီးမားဟှူ မှုလေဟှိုလည်း နန့်ဟှို ငါအပ်ပေးအူးမယ်။ နန့်ရဲ့ သခင်နတူးဒူ စည်းဇိမ်ဟှို ဝမ်ဇားပါ!’ ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","အယ်ဘီးန ရွှေဒန်းဂါး ၁,၀၀၀ ဟှို ရဟှူသူဟှလည်း လာဘီးဟှာ ‘သခင်၊ သခင်ဟှာ ခက်ထန်ဟှူ သူဖြစ်ဘီး ကိုယ်စိုက်ဘဲဟှူ နေရာမာ ရိသီးဘီး ကိုယ်ကြဲဘဲဟှူ နေရာမာ စုသီးတတ်ဟှူဇာဟှို ကျွန်တော်သိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ကျွန်တော်ဟှာ ကြော့‑က်ဟှူကြောန့် သွားဘီး သခင့်ရဲ့ ကပ်ဟှို မ္လေထဲမာ မ္လောက်ဟှားပါဟှယ်။ ကေ့ကေ့ပါ! ခု သခင်ရဲ့ အောက်စာရှိပါဟှယ်’ ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","သခင်ဟှ ‘ပျင်းရိဆိုးယောက်ဟှူ စေခံ! ငါဟှာ စိုက်ဘဲဟှူ နေရာမာ ရိသီးတတ်ဘီး ကြဲဘဲဟှူ နေရာမာ စုသီးတတ်ဟှယ် ဆိုဇာဟှို နန်သိဟှယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","အယ်ဆိုဟှာ နန်ဟှာ ငါ့ကပ်ဟှို ပွဲဇားလတ်မာ အပ်ဟှားသင့်ဟှယ်။ အယ်မျိုးမှဘဲ့ ငါပ္လန်လာဟှူ ခီမာ ငါ့ကပ်ဟှို တိုးန ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","အယ်ကြောန့် သူ့နားဟှ ရွှေဒန်းဂါး ၁,၀၀၀ ဟှို ယူဘီးဟှာ ရွှေဒန်းဂါး ၁၀,၀၀၀ ရှိဟှူလူဟှို ပေးဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ရှိဟှူလူဟှို ထပ်ပေးဘီး သူ့ဟှို ကြွယ်ဝစေလေ့မယ်။ မှေ့ဘဲဟှူ လူနားဟှ ရှိဟှူမျှဟှို နှုလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","သောင်းက္လဘဲဟှူ အယ်စေခံဟှို ပ္လန်ရပ် မှောန်မိုက်ထဲဟှို ပစ်ခ္လဂေ့။ အယ်နေရာမာ သူဟှာ အံသွားခဲက္လိဘီး ငိုကြွေးနေရလေ့မယ်’ ဆိုဘီး ပြောလေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“လူ့ရဲ့သားဟှာ ကောန်းဂန်တမန်လေနတူးဒူ မန်းဂီးဖြစ်န ကြွလာခီမာ သူဟှာ ဖောင်းသရေတော်ရှိဟှူ ပလ္လင်တော်ထတ်မာ ထိုင်တော်မူဘီး ");
INSERT INTO tvn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","လူမျိုးလေ ဂူလောင်းဟှို ရှေ့တော်မာ စုဝီးစေလေ့မယ်။ အယ်ဘီးမှ သိုးထီးမားဟှ သိုးနဘဲ့ဟှို ခွဲဟှားမျိုးဘဲ့ လူ့ရဲ့သားဟှလည်း လူလေဟှို နှေ့စုခွဲလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","သိုးလေဟှို ညာဖတ်မာ ထားဘီး ဘဲ့လေဟှို ဘယ်ဖတ်မာ ထားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","အယ်ဘီးန မန်းဂီးဟှ ညာဖတ်ဟှ လူလေဟှို ‘ငါ့ဖအားဖြင့် ကောန်းဂျီးခံရဟှူ သူလေ! ကမ္ဘာတည်ဂဒဲဟှ နန်းနို့လေတွပ် ပြင်ဆင်ဟှားဟှူ နိုင်ငံတော်ဟှို လာဘီး မွီယူဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါဟှာ ဗိုက်ဆာဟှူ ခီမာ နန်းနို့လေဟှာ ငါ့ဟှို စားဇာပေးဂေ့လေဟှယ်။ ငါရေငတ်ဟှူ ခီမာ နန်းနို့လေဟှာ သော့‑က်ဇာပေးလေဟှယ်။ ငါဟှာ ဧည့်သယ်ဖြစ်ဟှူ ခီမာ နန်းနို့လေဟှာ ငါ့ဟှို နန်းနို့ရဲ့ အီလေမာ လတ်ခံဂေ့ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ငါဟှာ ခ္လေးပ္လန်းဗ္လန်းဖြစ်နေဟှူ ခီမာ နန်းနို့လေဟှာ ဝတ်ဇာဟှို ပေးလေဟှယ်။ ငါဟှာ ဖျားနေဟှူ ခီမာ နန်းနို့လေဟှာ ပြုစုဂေ့ဟှယ်။ ငါဟှာ ထောန်က္လနေဟှူ ခီမာ နန်းနို့လေဟှာ ငါ့နားဟှို လာဂေ့ဟှယ်’ ဆိုဘီး မိန့်တော်မူလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ဖြောန့်မတ်ဟှူသူလေဟှ ‘သခင်၊ ကျွန်တော်ဟှားလေဟှ ဖယ်ခီဒူးဟှ ကိုယ်တော် ဗိုက်ဆာနေဇာဟှို ဗြင်ဘီး ကျွေးမွေးပါဟှယ်နူး၊ ရေငတ်နေဇာဟှို ဗြင်ဘီး သော့‑က်ဟှူဇာဟှို ပေးဟှားပါဟှယ်နူး၊ ");
INSERT INTO tvn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ကိုယ်တော်ဟှာ ဧည့်သယ်ဖြစ်တော်မူဟှယ် ဆိုဇာဟှို ကျွန်တော်ဟှားလေဗြင်ဘီး ကျွန်တော်ဟှားလေရဲ့ အီမာ ဖယ်ခီဒူးဟှ လတ်ခံဟှားဟှယ်နူး။ ကိုယ်တော်ဟှာ ခ္လေးပ္လန်းဗ္လန်းန နေတော်မူဟှယ် ဆိုဇာဟှို ကျွန်တော်ဟှားလေဗြင်ဘီး ဖယ်ခီဒူးဟှ ဝတ်ဟှူဇာလေ ပေးဟှားဟှယ်နူး၊ ");
INSERT INTO tvn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ကိုယ်တော် ဖျားနာတော်မူဇာလေ၊ ထောန်က္လနေဇာလေဟှို ကျွန်တော်ဟှားလေဗြင်ဘီး ဖယ်ခီဒူးဟှ ကိုယ်တော်နားဟှို ရော့‑က်လာပါဟှယ်နူး’ ဆိုဘီး ပ္လန်လျှော့‑က်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","မန်းဂီးဟှ ‘ငါ မှန်ပြောမယ်၊ အယ်မူ ငါ့ညီကို မောန်နှမလေထဲဟှ ငယ်ဆောင်းသူ တယော့‑က်ဟှို နန်းနို့ပြုစုဇာလေဟှာ ငါ့ဟှို ပြုစုဟှူဇာဘဲ့!’ ဆိုဘီး ပ္လန်မိန့်တော်မူလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“အယ်ဘီးမှ ဘယ်ဖတ်ဟှ သူလေဟှို မန်းဂီးဟှ ‘ကီဆဲခံရဟှူသူလေ၊ ငါ့နားဟှ ထွပ်ဟှားဂေ့! မာရ်နတ်န သူ့ရဲ့ တမန်လေတွပ် ပြင်ဆင်ဟှားဟှူ ထာဝရ ငရဲမီးအိုင်ထဲဟှို သွားဂေ့! ");
INSERT INTO tvn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါဟှာ ဗိုက်ဆာဟှူ ခီမာ နန်းနို့လေ ငါ့ဟှို ကျွေးဂေ့ဟှ။ ငါဟှာ ရေငတ်ဟှူ ခီမာ နန်းနို့လေ ငါ့ဟှို သော့‑က်ဟှူ ဇာပေးဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ငါဟှာ ဧည့်သယ်ဖြစ်နေဟှူ ခီမာ နန်းနို့လေရဲ့ အီလေမာ ငါ့ဟှို လတ်ခံဂေ့ဟှ။ ငါဟှာ ခ္လေးပ္လန်းဗ္လန်းဖြစ်နေဟှူ ခီမာ နန်းနို့လေဟှာ ငါ့ဟှို ဝတ်စားပေးဂေ့ဟှ။ ငါဟှာ ဖျားနာနေဘီး ထောန်က္လနေဘေမဲ့လည်း နန်းနို့လေဟှာ ငါ့နားဟှို လာဂေ့ဟှ’ ဆိုဘီး မိန့်တော်မူလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","အယ်သူလေဟှ ‘သခင်၊ ကျွန်တော့်ဟှားလေဟှ ဖယ်ခီဒူးဟှ ကိုယ်တော် ဗိုက်ဆာတော်မူဇာလေ၊ ရေငတ်တော်မူဇာလေ၊ ဧည့်သယ်ဖြစ်တော်မူဇာလေ၊ ခ္လေးပ္လန်းဗ္လန်းနေတော်မူဇာလေ၊ ဖျားနာတော်မူဇာလေ၊ ထောန်က္လနေဇာလေဟှို ဗြင်ဘီး လောက်ကျွေးပြုစုဘဲန နေပါဟှယ်နူး’ ဆိုဘီး ပ္လန်လျှော့‑က်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","မန်းဂီးဟှ ‘ငါ မှန်ပြောမယ်။ နန်းနို့လေဟှာ အယ်သူလေထဲမာ အငယ်ဆောင်းသူ တယော့‑က်ဟှို ပြုစုဘဲနနေဇာဟှာ ငါ့ဟှို ပြုစုဘဲနနေဇာ ဖြစ်ဟှယ်’ ဆိုဘီး မိန့်တော်မူလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","အယ်ကြောန့် သူးနို့လေဟှာ ထာဝရ ပြစ်ဒန်ခံရာဟှို သွားဂေ့လေ့မယ်။ အယ်ဘေမဲ့ ဖြောန့်မတ်ဟှူ သူလေဟှာ ထာဝရ သတ်ရှင်ရာဟှို သွားဂေ့လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","အယ်မူဇာလေဂူလောင်းဟှို သွန်သန်တော်မူဘီးန ယေရှုဟှ တဗဲ့တော်လေဟှို၊ ");
INSERT INTO tvn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ပသခါပွဲတော်ကျင်းပဟှို့ နှေ့ရစ်ဘဲ့လိုဘီ ဆိုဇာဟှို နန်းနို့ သိဂေ့လေဟှယ်။ အယ်ခီမာ လူ့ရဲ့သားဟှို လတ်ဝါးကပ်တိုင်မာ ရိုက်သတ်ဟှို့တွပ် အပ်ဂေ့လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","အယ်ခီမာ ယဇ်ပုရောဟိတ်ဂီးလေန ဘာသာရေးခေါန်းဆောန်လေဟှာ ကယာဖဆိုဘီး နာမယ်ရှိဟှူ ယဇ်ပုရောဟိတ်မန်းရဲ့ အီဝမ်းထဲမာ စုဝီးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","အယ်ဘီးဟှာ သူးနို့လေဟှ ယေရှုဟှို တိတိဆိဆိဟှား ဖမ်းဘီး သတ်ဟှို့တွပ် တိုင်ဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","သူးနို့လေဟှ “အယ်ဘေမဲ့ ပွဲတော်ရစ်မာ ဖမ်းနအူး။ လူလေထဲမာ ရုန်းရင်းဆန်ခတ် ဖြစ်ဂေ့လေ့မယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ယေရှုဟှာ ဗေသနိဝါ နူနာသယ်ရှိမုန်ရဲ့ အီမာ ရှိနေဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","စားဇာသောင်းဆောန်နေဒူးမာ ဖိုးကီးဟှူ ဆီမွှီးန ပ္လဲ့နေဟှူ က္လော့‑က်ဖ္လူဖူးဟှို ယူလာဟှူ မီးမတယော့‑က်ဟှာ ကိုယ်တော်နားဟှို ရော့‑က်လာဘီး သူဟှာ ကိုယ်တော်ရဲ့ ခေါန်းထတ်ဟှို လောန်းခ္လလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","အယ်မူဇာဟှို တဗဲ့တော်လေဗြင်ဟှားဘီး စိဆိုးဂေ့လေဟှယ်။ “ဖြားဖြစ်ကြောန့် အယ်မျိုးဖ္လူးပစ်ရနူး။ ");
INSERT INTO tvn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","အယ်ဆီမွှီးဟှို ဆေးဂီးဂီးန ရောန်းဘီးဟှာ ဆင်းရဲသားလေဟှို ပေးကမ်းနိုင်ဟှယ်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ယေရှုဟှာ သူးနို့ပြောနေဇာဟှို သိဟှူ ခီမာ သူးနို့လေဟှို “ဖြားဖြစ်ကြောန့် အယ်မီးမဟှို နှော့‑က်ယှစ်ဂေ့နူး။ သူဟှာ ငါ့တွပ်ကောန်းဟှူမှုဟှို ပြုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ဆင်းရဲသားလေဟှာ နန်းနို့လေနတူးဒူ မြဲဒမ်း ရှိနေလေ့မယ်။ အယ်ဘေမဲ့ ငါဟှ နန်းနို့နတူးဒူ မြဲဒမ်း ရှိနေဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","အယ်မီးမဟှာ ငါ့ကိုယ်ထတ်ဟှို ဆီမွှီးလောန်းဇာဟှာ ငါ့ဟှို သင်္ဂြိုဟ်ဟှို့တွပ် ပြင်ဆင်ဟှူဇာဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ငါ မှန်ပြောမယ်၊ ဒန်းကောန်းဟှို ကမ္ဘာရပ်ရပ်မာ ဟောပြောဟှူ ခီတိုင်း အယ်မီးမဟှို အော့‑က်မေ့စေဟှို့တွပ် သူပြုဟှားဟှူ အယ်မျိုးမှုရာဟှို ပြောဂေ့လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","အယ်ဘီးန တဗဲ့တော် ဆယ်နှေ့ပါးထဲဟှ တပါးဖြစ်ဟှူ ယုဒရှကာရုတ်ဟှာ ယဇ်ပုရောဟိတ်ဂီးလေနားဟှို သွားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ယေရှုဟှို နန်းနို့လေရဲ့ လတ်ထဲဟှို အပ်ပေးမယ် ဆိုဟှာ ကျွန်တော်ဟှို ကပ်ဖယ်လော့‑က် ပေးဟှို့နူး” ဆိုဘီး မေးလေဟှယ်။ အယ်ကြောန့် အယ်သူလေဟှ ငွေဒန်းဂါး သောင်းဆယ်ဟှို ရေတွပ်ဘီးဟှာ သူ့ဟှို ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","အယ်ခီဟှနေဘီး ယုဒဟှာ ယေရှုဟှို သစ်စာဖော့‑က်ဟှို့တွပ် ခွမ့်ရေးကောန်းဟှို ရှာကြံလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","တဆေးပါဘဲဟှူ မုပွဲတော်ရဲ့ ဦးဆောင်းနေ့မာ တဗဲ့တော်လေဟှာ ယေရှုနားဟှို လာဘီး “ပသခါ စားဗွဲဟှို ကိုယ်တော် သောင်းဆောန်ဟှို့တွပ် ကျွန်တော်ဟှားလေ ဖယ်နေရာမာ ပြင်ရမယ်နူး” ဆိုဘီး မေးလျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ကိုယ်တော်ဟှ “ဗြို့ထဲဟှ လူတယော့‑က်နားဟှို သွားဘီးပြောဂေ့။ ဆရာမှာလိုက်ဟှယ်။ ‘ငါ့ခီနီးဘီ။ ငါ့တဗဲ့လေနတူးဒူ ပသခါပွဲဟှို နန့်အီမာ ကျင်းပမယ်’ ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","တဗဲ့တော်လေဟှ ယေရှုပြောလိုက်ဟှူတိုင်း လောက်ဘီးဟှာ ပသခါစားဗွဲဟှို ပြင်ဆင်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ညဉ့်ခန်းဖတ် ရော့‑က်ဟှူ ခီမာ ယေရှုဟှာ တဗဲ့တော် ဆယ့်နှေ့ပါးလေနတူးဒူ ညဉ့်ဇာစားဟှို့ ဗွဲမာ ထိုင်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","သူးနို့စားနေဒူးမာဘဲ့ ယေရှုဟှ “ငါ မှန်ပြောမယ်၊ နန်းနို့ထဲမာ တယော့‑က်ဟှာ ငါ့ဟှို သစ်စာဖော့‑က်လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","တဗဲ့တော်လေဟှာ ရရာတိုင်း စိကောန်းဘဲဖြစ်ဂေ့ဘီး “သခင်၊ အယ်သူဟှ ဖယ်သူနူး။ ကျွန်တော်လော” ဆိုဘီး ယော့‑က်ဘီးယော့‑က် မေးလျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ယေရှုဟှ “ငါ့နတူးဒူ စံထဲမာ နှိုက်ဟှူ သူဟှာ ငါ့ဟှို သစ်စာဖော့‑က်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ကျမ်းစာဟှ ပြောဟှားတိုင်း လူ့ရဲ့သားဟှာ သေခံရလေ့မယ်။ အယ်ဘေမဲ့ လူ့ရဲ့သားဟှို သစ်စာဖော့‑က်ဟှူ သူဟှာ အမင်္ဂလာရှိဟှယ်! အယ်သူဟှာ လောင်းဝ မွီးလာဘဲနနေဟှာ သူ့တွပ် ပိုကောန်းလေ့မယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ကိုယ်တော့်ဟှို သစ်စာဖော့‑က်မယ့် ယုဒဟှ “ဆရာ၊ ကျွန်တော်လော” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ယေရှုဟှ “နန်မေးဟှူတိုင်းဘဲ့ မှန်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","သူးနို့ဟှာ စားနေဒူးမာ ယေရှုဟှ မုဟှိုယူဘီး ကျေးဇူးတော်ဟှို ချီးမွမ်းဘီးမှ မုဟှိုဖဲ့ဘီးဟှာ “အယ်မုဟှ ငါ့ရဲ့ ကိုယ်ခန္ဓာဖြစ်ဟှယ်။ ယူဘီးစားဂေ့ပါ” ဆိုဘီး မိန့်တော်မူဘီးဟှာ တဗဲ့တော်လေဟှို ပေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ခွပ်ဟှိုလည်း ယူဘီးဟှာ ကျေးဇူးတော် ချီးမွမ်းဘီးမှ တဗဲ့တော်လေဟှို ပေးလေဟှယ်။ ကိုယ်တော်ဟှ “နန်းနို့အားလောင်း သော့‑က်ဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","အယ်ခွပ်ဟှာ ဘုရားသခင်ရဲ့ ပဋိညာဉ်တော်ဟှို ဇိခတ်ဟှားဟှူ လူလေရဲ့ပြစ်ဟှို ဖြေလွှတ်ပေးဟှို့တွပ် သွန်းလောန်းဟှူ ငါ့ရဲ့သွီး ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","နန်းနို့လေဟှို ငါပြောမယ်။ ခုခီဟှနေ စဘီး ငါ့ဖရဲ့ နိုင်ငံတော်မာ နန်းနို့လေနတူးဒူ စဗျစ်ဝိုင်သစ်ဟှို သော့‑က်ရဟှူ နေ့ရော့‑က်ခန်ခီထိ အယ်စဗျစ်ဝိုင်ဟှို နော့‑က်ထပ် လောင်းဝ ငါသော့‑က်ဟှို့ မှုဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","အယ်ဘီးန သူးနို့လေဟှာ ဓမ္မချင်းဟှို ဆိုဘီး သံလွင်တောန်ဟှို ထွပ်ဟှားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","အယ်ဘီးန ယေရှုဟှ “‘သိုးထီးမားဟှို ငါရိုက်သတ်ဟှူကြောန့် သိုးလေဟှာ ဖ္လဲဖ္လဲစင်ဖြစ်ဂေ့လေ့မယ်’ ဆိုဘီး ကျမ်းစာပြောဟှူဇာဟှ အယ်ညဉ့်မှာဘဲ့ နန်းနို့လေဟှာ ငါ့ဟှို ထားရစ်ဘီး ထွပ်ပ္လေးဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","အယ်ဘေမဲ့ ငါဟှာ ထမြော့‑က်ဘီးန နန်းနို့ထတ် စောဘီး ဂါလိလဲပြည်ဟှို သွားမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ပေတရုဟှ “တခြားသူလေဟှာ ကိုယ်တော့်ဟှို ထားရစ်လည်းဘဲ့ ကျွန်တော်ဟှာ လောင်းဝ ထားရစ်ဟှို့ မှုဟှ!” ဆိုဘီး ယေရှုဟှို လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ယေရှုဟှ “နန့်ဟှို ငါ မှန်ပြောမယ်၊ အယ်ညဉ့်မာဘဲ့ ကြစ်တွန်ခန်မာ နန်ဟှာ ငါ့ဟှို သောင်းခါ ငြင်းပယ်လေ့မယ်” ဆိုဘီး ပေတရုဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ပေတရုဟှ “ကိုယ်တော်နတူးဒူ သေရမယ် ဆိုဟှာလည်း ကျွန်တော်ဟှာ ကိုယ်တော့်ဟှို ငြင်းပယ်ဟှ!” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ တခြား တဗဲ့တော်လေလည်း အယ်မျိုးဘဲ့ လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","အယ်ဘီးန ယေရှုဟှာ တဗဲ့တော်လေနတူးဒူ ဂေသရှေမန် ဆိုဘီး ခေါ်ဟှူ နေရာဟှို ရော့‑က်တော်မူဘီး ကိုယ်တော်ဟှ “ငါ ဟှိုနားမာ ဆုတောန်းနေဒူးမာ အယ်နေရာမာ ထိုင်နေဂေ့ပါ” ဆိုဘီး တဗဲ့တော်လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ကိုယ်တော်ဟှာ ပေတရုနတူးဒူ ဇေဗေဒဲရဲ့ သားနှေ့ယော့‑က်ဟှို ခေါ်ဟှားတော်မူလေဟှယ်။ ကိုယ်တော်ဟှာ ဝန်းနဲပူဆွေးဘီး စိဒေါ့‑က်ခရော့‑က်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","အယ်ကြောန့် ယေရှုဟှ “ငါ့ရဲ့ စိနှလောင်းဟှာ သေခါနီးနီးဘဲ့ ရရာတိုင်း ဝန်းနဲဟှယ်။ အယ်နေရာမာ ငါ့နတူးဒူ စောန့်ဘီးနေဂေ့ပါ” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ကိုယ်တော်ဟှာ ရှေ့ဟှို နဲနဲတိုးဟှားဘီးဟှာ မ္လေထတ်မာ ပျပ်ဝပ်ဘီး “ကျွန်တော်ရဲ့ဖ၊ ဖြစ်နိုင်မယ် ဆိုဟှာ အယ်မူဝေဒနာခွပ်ဟှို ကျွန်တော်ဟှနေဘီး ယူဟှားပေးပါ! အယ်ဘေမဲ့ ကျွန်တော်လိုရှင်တိုင်း ဖြစ်စေဘဲန ဖလိုရှင်တိုင်းဘဲ့ ဖြစ်စေပါ” ဆိုဘီး ဆုတောန်းတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","အယ်ဘီးန ကိုယ်တော်ဟှာ တဗဲ့တော် သောင်းယော့‑က်နားဟှို ပ္လန်လာဟှူ ခီမာ သူးနို့ဟှာ အိမွိနေဂေ့ဇာဟှို တွိရဟှိကြောန့် ကိုယ်တော်ဟှ ပေတရုဟှို “နန်းနို့လေဟှာ တနာရီလော့‑က်ဘဲ့ ငါ့နတူးဒူ စောန့်နိုင်ဂေ့ဟှလော၊ ");
INSERT INTO tvn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","နန်းနို့လေဟှာ စောင်ဇမ်းနှော့‑က်ယှစ်မှုထဲဟှို က္လဘဲဟှို့တွပ် ဆုတောန်းဘီး စောန့်နေဂေ့ပါ။ စိဝိညာဉ်ဟှာ အားကီးဘေမဲ့လည်း ကိုယ်ခန္ဓာဟှာ အားနဲလေဟှယ်” ဆိုဘီး ပေတရုဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ယေရှုဟှာ နော့‑က်တခါ သွားဘီး “ကျွန်တော်ရဲ့ဖ၊ အယ်ဝေဒနာခွပ်ဟှို ကျွန်တော်သော့‑က်ဘဲန လွန်သွားဟှို့ ရနိုင်ဟှ ဆိုဟှာ ကိုယ်တော်ရဲ့ လိုရှိဟှူတိုင်းဘဲ့ ဖြစ်ပါစေ” ဆိုဘီး ဆုတောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ကိုယ်တော်ဟှာ ပ္လန်လာဟှူ ခီမာ တဗဲ့တော်လေဟှာ မျစ်စိလေးလံလာဟှူကြောန့် နော့‑က်တခါ အိမွိနေဂေ့ဇာဟှို တွိရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","အယ်ကြောန့် ယေရှုဟှာ သူးနို့လေဟှို ထားရစ်ဘီး နော့‑က်တခါ ထွပ်ဟှားဘီး ရင်းရင်ဒူးဟှမျိုးဘဲ့ သောင်းခါမြော့‑က် ဆုတောန်းတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","အယ်ဘီးမှ တဗဲ့တော်လေနားဟှို ပ္လန်လာဘီး “နန်းနို့လေဟှာ အိမွိဘီးဟှာ နားယူနေဂေ့လော။ ကေ့ဂေ့! လူ့ရဲ့သားဟှို ပြစ်သားလေရဲ့ လတ်ထဲဟှို အပ်ခံရဟှို့ ခီဟှာ ရော့‑က်လာဘီ။ ");
INSERT INTO tvn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ထဂေ့၊ နို့လေသွားဂေ့ဇို့။ ကေ့ကေ့၊ ငါ့ဟှို သစ်စာဖော့‑က်ဟှို့သူ ရော့‑က်လာဘီ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ယေရှုဟှာ မိန့်တော်မူနေဒူးမာဘဲ့ တဗဲ့တော် ဆယ်နှေ့ပါးထဲဟှ တပါးဖြစ်ဟှူ ယုဒရှကာရုတ်ဟှာ ရော့‑က်လာဘီးဟှာ သူ့နတူးဒူ ယဇ်ပုရောဟိတ်ဂီးလေန ဘာသာရေး ခေါန်းဆောန်လေဟှနေ စေလွှတ်လိုက်ဟှူ လူအောက်ဂီးဟှာ ဒေါက်လေ၊ ထားလေပါလာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ကိုယ်တော့်ဟှို သစ်စာဖော့‑က်ဟှူသူဟှ “ငါနမ်းဟှူသူဟှာ ယေရှုဘဲ့ဖြစ်ဟှယ်။ သူ့ဟှို ဖမ်းဂေ့ပါ!” ဆိုဘီး မှတ်ပေးဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ယုဒဟှာ ရှစ်ရှင်းဘဲ့ ယေရှုနားဟှို တိုးဝမ်လာဘီး “မင်္ဂလာပါ၊ ဆရာ” ဆိုဘီး ကိုယ်တော့်ဟှို နမ်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ယေရှုဟှ “မိဆွေ၊ နန်လောက်ရဟှို့ ကိစဟှို ဗြန်းဗြန်ဟှား လောက်ပါ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်ခီမာ အယ်သူလေဟှ လာဘီး ကိုယ်တော့်ဟှို ဖမ်းချောက်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ယေရှုန ပါလာဟှူ လူတယော့‑က်ဟှာ ထားဟှို ဆွဲထုဘီး ယဇ်ပုရောဟိတ်မန်းရဲ့ ကျွန်တယော့‑က်ဟှို ခွတ်လိုက်ဟှူ ခီမာ နားဝပ်ပြတ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ယေရှုဟှ “နန့်ထားဟှို ထားအီထဲမာ ပ္လန်သီးလိုက်ပါ! ထားဟှို ကိုင်ဟှူ သူလေဟှာ ထားနဘဲ့ သေဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ခု ငါ့ရဲ့ ဖနားမာ တောန်းလျှော့‑က်မယ် ဆိုဟှာ ကောန်းဂန်တမန် ဆယ့်နှေ့တပ်မကဘဲ ငါ့နားဟှို လွှတ်ပေးမယ် ဆိုဇာ နန်းနို့လေ သိဂေ့ဟှလေ။ ");
INSERT INTO tvn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","အယ်မျိုးဆိုဟှာ အယ်မူဇာလေ ဖြစ်ရမယ် ဆိုဘီး ပြောဟှားဟှူကျမ်းစာဟှာ ဖယ်မျိုး ပ္လဲ့ဇောင်လာအူးမယ်နူး” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","အယ်ခီမာဘဲ့ ယေရှုဟှ “ဖြားဖြစ်ကြောန့် နန်းနို့လေဟှာ မ္လဟှို ဖမ်းဟှို့မျိုး ငါ့ဟှို ဖမ်းဟှို့တွပ် ဒေါက်လေ၊ ထားလေန လာဂေ့နူး။ ငါဟှာ ဗိမာန်တော်မာ ထိုင်ဘီး နေ့တိုင်း သွန်သန်နေဒူးဟှ နန်းနို့လေဟှာ ငါ့ဟှို ဖမ်းဂေ့ဟှားမား။ ");
INSERT INTO tvn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","အယ်ဘေမဲ့ အယ်မှုကြောန်းရာလေဟှာ ကျမ်းစာမာ ပရောဖက်လေ ဟောပြောဟှားဟှူတိုင်း ပ္လဲ့ဇောင်ဟှို့တွပ် ဖြစ်လာလေဟှယ်” ဆိုဘီး လူအောက်ဂီးဟှို မိန့်တော်မူလေဟှယ်။ အယ်ခီမာ တဗဲ့တော်လေဟှာ ကိုယ်တော့်ဟှို ထားရစ်ဘီး ထွပ်ပ္လေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ယေရှုဟှို လာဖမ်းဟှူ သူလေဟှ ကျမ်းပြုဆရာလေန ဘာသာရေးကြီးကဲလေ စုဝေးဟှူနေရာ ယဇ်ပုရောဟိတ်မန်း ကယာဖအီဟှို ခေါ်ဆောန်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ပေတရုဟှာ ခပ်ဝီးဝီးဟှနေဘီး ယဇ်ပုရောဟိတ်မန်းရဲ့ အီနားထိ ကိုယ်တော်နော့‑က်ဟှို လိုက်လေဟှယ်။ သူဟှာ အီဝမ်းထဲဟှို ဝမ်ဟှားဘီးဟှာ ဖယ်မျိုး ဖြစ်လာအူးမယ် ဆိုဇာဟှို ဗြင်ရဟှို့တွပ် စောန့်လေနတူးဒူ ထိုင်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ယဇ်ပုရောဟိတ်ဂီးလေန ယုဒတရားလွှတ်တော် တခုလောင်းဟှာ ယေရှုဟှို သေဒန်ပေးဟှို့တွပ် မှန်ဘဲဟှူ သတ်သေထော့‑က်ထားဟှို တွိအောန် ရှာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","သူးနို့ဟှာ မှန်ဘဲဟှူ သတ်သေခံလေ ဘောင်ဂီး လာဂေ့ဘေမဲ့လည်း ဖြားထော့‑က်ထားလည်း တွိဂေ့ဟှ။ နော့‑က်ဆောင်းမာ လူနှေ့ယော့‑က်ဟှာ ရှေ့ဟှို ထွပ်လာဘီး ");
INSERT INTO tvn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“အယ်သူဟှ ‘ငါဟှာ ဘုရားသခင်ရဲ့ ဗိမာန်တော်ဟှို ဖြိုဖျစ်ဘီးဟှာ သောင်းရစ်ထဲန ပ္လန်ဆော့‑က်နိုင်ဟှယ်’ ဆိုဘီး ပြောပါဟှယ်” ဆိုဘီး ထွပ်ဆိုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ယဇ်ပုရောဟိတ်မန်းဟှာ ထရပ်လိုက်ဘီး “အယ်မျိုး စွပ်စွဲနေဇာဟှို ပြောဟှို့တွပ် နန့်မာ ဖြေမှေ့ဟှလော” ဆိုဘီး ယေရှုဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","အယ်ဘေမဲ့ ယေရှုဟှာ တိဆိဘီး နေတော်မူဟှယ်။ ယဇ်ပုရောဟိတ်မန်းဟှလည်း “နန်ဟှာ ဘုရားသခင်ရဲ့ သားတော် မေရှိယဖြစ်ဟှယ် ဆိုဟှာ ငါ့ဟှို ပြောပါ။ သတ်ရှင်ဟှူ ဘုရားသခင်ဟှို တိုင်တယ်ဘီး နန့်ဟှို ငါမေးဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ယေရှုဟှ “မန်းဂီးပြောဟှူတိုင်း မှန်ပါဟှယ်။ အယ်ဘေမဲ့ နန်းနို့လေ ဂူလောင်းဟှို ငါပြောမယ်။ အယ်ခီဟှနေစဘီး လူ့ရဲ့သားဟှာ အနန္တတဂိုးရှင်ရဲ့ ညာဖတ်မာ ထိုင်ဘီး ကောန်းဂန်ဟှ မိုးတီဟှို စီးဘီးဟှာ ကြွလာဇာဟှို နန်းနို့လေ ဗြင်ဂေ့ရလေ့မယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","အယ်ကြောန့် ယဇ်ပုရောဟိတ်မန်းဂီးဟှာ သူ့ရဲ့ အန်းဂီဟှို ဆုဖ္လဲဘီးဟှာ “အယ်သူဟှာ ဘုရားသခင်ဟှို ပြစ်မှားစော်ကားဘီး ပြောဆိုလေဘီ! နော့‑က်ထပ် ဖြားသတ်သေလေ လိုသေးနူး။ ဘုရားသခင်ဟှို ပြစ်မှားဇာဟှို ခု နန်းနို့လေ ကြားရဂေ့ဘီ! ");
INSERT INTO tvn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","နန်းနို့လေ ဖယ်မျိုး ထန်ဂေ့နူး။” အယ်သူလေဟှ “သူဟှာ သေဒန်နဘဲ့ ထိုက်တန်ပါဟှယ်” ဆိုဘီး ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","အယ်ဘီးန အယ်သူလေဟှာ ကိုယ်တော်ရဲ့ မျစ်နှာတော်ဟှို ထွီးရယ်န ထွီးဂေ့ဘီး လတ်သီးန ထိုးဂေ့ဟှယ်။ အယ်ဘီးဟှာ ကိုယ်တော့်ပါးဟှို ရိုက်ဟှူလူလေဟှ ");
INSERT INTO tvn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“မေရှိယ! ကိုယ်တော့်ဟှို ဖယ်သူရိုက်ဟှယ် ဆိုဇာဟှို ပရောဖက်ပြုကေ့ကေ့!” ဆိုဘီး ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ပေတရုဟှာ အီပ္လန်ခြံဝန်းထဲမာ ထိုင်နေဟှူ ခီမာ စေခံမီးမ တယော့‑က်ဟှာ သူ့နားဟှို လာဘီး “နန်လည်း ဂါလိလဲနယ်သား ယေရှုနတူးဒူ ရှိဟှားဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","အယ်ဘေမဲ့ ပေတရုဟှ “နန်ပြောနေဟှူဇာဟှို ငါသိဟှ” ဆိုဘီး လူလေ ဂူလောင်းရှေ့မာ ကိုယ်တော့်ဟှို ငြင်းပယ်ဘီး ");
INSERT INTO tvn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","အီခြံဝန်းရဲ့ ခွဗော့‑က်ဟှို ထွပ်ဟှားလေဟှယ်။ တခြားစေခံမီးမ တယောက်ဟှ သူ့ဟှို ဗြင်ဟှားဘီး အယ်နေရာမာ ရှိနေဟှူလူလေဟှို “အယ်လူဟှာ နာဇရက်ဗြို့ဟှ ယေရှုနတူးဒူ ရှိဟှားဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ပေတရုဟှ “အယ်လူဟှို ငါသိဟှ!” ဆိုဘီး နော့‑က်ထပ်ခါ သစ်စာဆိုဘီး ငြင်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","နဲနဲကြာဘီးန အယ်နေရာမာ ရပ်နေဟှူ လူလေဟှာ ပေတရုနားဟှို လာဂေ့လေဟှယ်။ သူးနို့ဟှ “တကယ်ဘဲ့ နန်ဟှာ အယ်လူလေထဲဟှ တယော့‑က်ဖြစ်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန့်ရဲ့ ပြောပေါင်ဆိုပေါင်ဟှာ ရရာတိုင်း သိသာဟှယ်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ပေတရုဟှ “အယ်သူဟှို ငါတကယ်ဟှို သိဟှ!” ဆိုဘီး ဘုရားသခင်ဟှို တိုင်တယ်ဘီး ကီဆိုလေဟှယ်။ အယ်ခီမာဘဲ့ ကြစ်တွန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","အယ်ဘီးမှ “ကြစ်တွန်ခန် နန်ဟှာ ငါ့ဟှို သောင်းခါ ငြင်းပယ်လေ့မယ်” ဆိုဘီး ယေရှု မိန့်တော်မူဟှားဟှူ စကားဟှို ပေတရုဟှာ ဒိရလာဟှယ်။ အယ်ကြောန့် သူဟှာ ပ္လန်ဟှိုထွပ်ဟှားဘီး ရရာတိုင်း ငိုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","မိုးလန်းစောစောဂီးမာ ယဇ်ပုရောဟိတ်ဂီးလေန သတ်ကီးဝါဂီးလေဟှာ ယေရှုဟှို သေဒန်ခ္လဟှို့တွပ် တိုင်ဗန်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","အယ်ဘီးန ကိုယ်တော့်ဟှို တောက်နှောန်ဘီး ဗြို့ဝန်မန်း ပိလတ်နားဟှို ခေါ်ဆောန်ဟှားဘီး အပ်လိုက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","သစ်စာဖော့‑က် ယုဒဟှာ ယေရှသေဒန်ပေးခံရဟှယ် ဆိုဇာဟှို သိရဟှူ ခီမာ သူဟှာ နောန်ဒရဟှားဘီး ငွေဒန်းဂါးသောင်းဆယ်ဟှို ယဇ်ပုရောဟိတ်ဂီးလေန သတ်ကီးဝါဂီးလေဟှို ပ္လန်ပေးလိုက်ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ကျွန်တော်ဟှာ ပြစ်မှေ့ဘဲဟှူ သူ့ရဲ့သွီးဟှို အပ်ဘီး ပြစ်လောက်မိဟှားဘီ!” ပြောလေဟှယ်။ အယ်ဘေမဲ့ သူးနို့လေဟှ “နို့လေန ဖြားဇာဆိုင်နူး။ နန့်ကိစဘဲ့ ဖြစ်ဟှယ်!” ဆိုဘီး ပ္လန်ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ယုဒဟှာ ငွေဒန်းဂါးသောင်းဆယ်ဟှို ဗိမာန်တော်ထဲမာ ပစ်ခ္လဘီး ထွပ်ဟှားလေဟှယ်။ အယ်ဘီးန တခြားဟှို သွားဘီးဟှာ သူ့ကိုယ်သူ ကြိုးဆွဲခ္လဘီး သေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ယဇ်ပုရောဟိတ်ဂီးလေဟှာ ဒန်းဂါးလေဟှို ကော့‑က်ယူဘီးဟှာ “ပညတ်တရားအရ အယ်ဒန်းဂါးလေဟှာ သွီးပေနေဟှူ ကပ်လေဖြစ်ဟှူကြောန့် ဘဏ္ဍာတိုက်ထဲဟှို သွမ်းအပ်ဟှ” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","အယ်ကြောန့် သူးနို့လေဟှာ ဆွေးနွေး တိုင်ဗန်ဂေ့ဘီး သူစိမ်း ဧည့်သည်လေတွပ် သန်းခ္လိုင်းဖြစ် သောင်းပြုဟှို့ အိုးလောက်မားရဲ့ မ္လေဂွပ်ဟှို အယ်ကပ်န ဝယ်ယူဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","အယ်ကြောန့် အယ်လယ်ဂွပ်ဟှို အယ်နေ့ထိ “သွီးမ္လေ” ဆိုဘီး ခေါ်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ပရောဖက်ယေရမိဟှ “သူးနို့လေဟှာ အယ်သူတွပ် ပေးဟှို့ ဣသရေလ လူလေ ဘောတူဟှားဟှူ ငွေဒန်းဂါး သောင်းဆယ်ဟှို ယူဘီးဟှာ ");
INSERT INTO tvn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ဘုရားသခင်ဟှာ ငါ့ဟှို မှာဟှားဟှူတိုင်း အိုးလောက်မားရဲ့ မ္လေဂွပ်ဟှို ဝယ်ဂေ့ဟှယ်” ဆိုဘီး ဟောဟှားဇာဟှာ ခုခီမာ ပ္လဲ့ဇောင်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ယေရှုဟှာ ဗြို့ဝန်မန်းရဲ့ ရှေ့မာ ရပ်တော်မူနေဒူးမာ ဗြို့ဝန်မန်းဟှ “နန်ဟှာ ယုဒလူမျိုးလေရဲ့ မန်းဂီးလော” ဆိုဘီး မေးလေဟှယ်။ ယေရှုဟှ “သင်ပြောဟှူတိုင်းဘဲ့” ဆိုဘီး ပ္လန်မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","အယ်ဘေမဲ့ ယဇ်ပုရောဟိတ်ဂီးလေန သတ်ကီးဝါဂီးလေရဲ့ စွပ်စွဲဂေ့ဟှူဇာဟှို ကိုယ်တော်ဟှာ ဖြေတော်မူဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","အယ်ကြောန့် ပိလတ်ဟှ “သူးနို့ရဲ့ သတ်သေခံဇာလေဟှို နန်ကြားဟှလော” ဆိုဘီး ကိုယ်တော့်ဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","အယ်ဘေမဲ့ ယေရှုဟှာ ခွန်းလည်း ပ္လန်ပြောဘဲကြောန့် ဗြို့ဝန်မန်းဟှာ ရရာတိုင်း အံ့ဩလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ဗြို့ဝန်မန်းဟှာ ပသခါပွဲတိုင်းမာ လူလေတောန်းဆိုဟှူ ထောန်သား တယော့‑က်ဟှို လွှတ်ပေးဟှူ ထောင်းဇံရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","အယ်ခီမာ ယေရှုဗာရဗ္ဗ ဆိုဘီး နာမယ်ရှိဘီး ထန်ပေါ်ဟှူ ထောန်သား တယော့‑က်ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","အယ်ကြောန့် လူအောက်ဂီးဟှာ စုလာဟှူ ခီမာ ပိလတ်ဟှ သူးနို့ဟှို “နန်းနို့လေ ဖယ်သူ့ဟှို လွှတ်ပေးစေရှင်ဟှယ်နူး။ ယေရှုဗာရဗ္ဗလော။ ခရစ်တော် ဆိုဘီး ခေါ်ဟှူ ယေရှုလော” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","သူးနို့လေဟှာ နာလိုဘဲစိရှိဟှူကြောန့် ယေရှုဟှို အပ်ဂေ့ဟှယ် ဆိုဇာဟှို ပိလတ်ဟှ ကောန်းကောန်းသိနေဟှူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ပိလတ်ဟှ တရားပလ္လင်ထတ်မာ ထိုင်နေဒူးမာ သူ့ရဲ့ မယားဟှ လူတယော့‑က်ဟှို လွှတ်ဘီးဟှာ “အယ်မူဖြောန့်မတ်ဟှူ သူဟှို ဖြားလည်းလောက်ပါန။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နတ်ကီးညဉ့်ခန်းဒူးဟှ အိမတ်ထဲမာ အယ်သူကြောန့် ရရာတိုင်း စိဒေါက်ခဖြစ်ဟှယ်” ဆိုဘီး မှာလိုက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","အယ်ဘေမဲ့ ဗာရဗ္ဗဟှို လွှတ်ပေးဟှို့န ယေရှုဟှို သတ်ဟှို့တွပ် တောန်းဆိုဟှို့ ယဇ်ပုရောဟိတ်ဂီးလေန သတ်ကီးဝါဂီးလေဟှာ လူအောက်ဂီးဟှို စည်းရောင်းဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ဗြို့ဝန်မန်းဟှ “အယ်လူလေ နှေ့ယော့‑က်မာ ဖယ်တယော့‑က်ဟှို လွှတ်ပေးစေရှင်ဟှယ်နူး” ဆိုဘီး လူအောက်ဂီးဟှို မေးလေဟှယ်။ သူးနို့လေဟှ “ဗာရဗ္ဗ!” ဆိုဘီး ဖြေဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ပိလတ်ဟှ “အယ်ဆိုဟှာ ခရစ်တော် ဆိုဘီး ခေါ်ဟှူ ယေရှုဟှို ဖြားလောက်ရမယ်နူး” ဆိုဘီး သူးနို့ဟှို မေးလေဟှယ်။ သူးနို့လေအားလောင်းဟှ “သူ့ဟှို ကားစင်တန်ပါ!” ဆိုဘီး ဖြေဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","အယ်ဘေမဲ့ ပိလတ်ဟှ “အယ်သူဟှာ ဖယ်မျိုးပြစ်မှုဟှို လွန်ကြူးမိဟှယ်နူး” ဆိုဘီး မေးလေဟှယ်။ သူးနို့လေဟှ “သူ့ဟှို ကားစင်တန်ပါ!” ဆိုဘီး သံက္လယ်ဂီးန အော်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ပိလတ်ဟှာ ရုန်းရင်းဆန်ခတ် ဖြစ်လာမယ် ဆိုဇာဟှို ဗြင်ဟှူ ခီမာ သူဟှာ ရေဟှို ယူဘီးဟှာ “အယ်မူ ပြစ်မှေ့ဘဲဟှူသူရဲ့ သွီးဟှာ ငါ့နဆိုင်ဟှ! နန်းနို့ရဲ့ တာဝန်ဘဲ့ဖြစ်ဟှယ်!” ဆိုဘီး လူအောက်ဂီးရဲ့ ရှေ့မာ သူ့ရဲ့ လတ်ဟှို ဆေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","လူအောက်ဂီး တခုလောင်းဟှ “သူ့ရဲ့သွီးဟှာ ကျွန်တော်ဟှားလေန ကျွန်တော်ဟှားလေရဲ့ သားမီးလေထတ်မာ သတ်ရော့‑က်ပါစေ!” ဆိုဘီး ပ္လန်ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","အယ်ဘီးန ပိလတ်ဟှ ဗာရဗ္ဗဟှို လွှတ်ပေးလိုက်ဘီးဟှာ ယေရှုဟှို ကီဒန်ပေးဘီးန ကားစင်တန်ဟှို့တွပ် အပ်လိုက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","အယ်ဘီးန ပိလတ်ရဲ့ စစ်သားလေဟှာ ယေရှုဟှို ဗြို့ဝန်မန်းရဲ့ အီတော်ဟှို ခေါ်ဟှားဘီး စစ်တပ်တတပ်လောင်းဟှို ကိုယ်တော်နားမာ စုဝီးစေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","အယ်ဘီးမှ စစ်သားလေဟှာ ကိုယ်တော်ရဲ့ ဝတ်တော်ဟှို ခလွတ်ဘီး ကမ္ဗလာနီဝတ်လောင်ဟှို ချောင်ပေးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","အယ်ဘီးန ဆူးခတ်န လောက်ဟှားဟှူ သရဖူဟှို ခေါန်းတော်မာ ဆောန်းပေးဂေ့ဘီး၊ ကျူဒေါက်တရှောန်းဟှိုလည်း ညာဖတ်လတ်တော်မာ ကိုင်စေလေဟှယ်။ အယ်ဘီးန ကိုယ်တော်ရှေ့မာ ဒူးထော့‑က်ဘီးဟှာ “ယုဒမန်းဂီး သတ်တော်ရှယ်ပါစေ!” ဆိုဘီး သရော်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","သူးနို့ဟှာ ကိုယ်တော့်ဟှို ထွီးရယ်န ထွီးဂေ့ဘီး ကျူဒေါက်ဟှို ယူဘီးဟှာ ခေါန်းဟှို ခါဘီးခါ ရိုက်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","သူးနို့ဟှာ ကိုယ်တော့်ဟှို သရော်ဂေ့ဘီးန ကမ္ဗလာနီဝတ်လောင်ဟှို ခလွတ်ဘီးဟှာ ကိုယ်တော်ရဲ့ အန်းဂီးဟှို ပ္လန်ဝတ်စေဟှယ်။ အယ်ဘီးန လတ်ဝါးကပ်တိုင်မာ တန်ဘီးသတ်ဟှို့တွပ် ခေါ်ဆောန်ဟှားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","သူးနို့လေ ထွပ်လာဟှူ ခီမာ ရှိမုန် ဆိုဘီး နာမယ်ရှိဟှူ ကုရေနေဗြို့ဟှ လူတယော့‑က်ဟှို လမ်းမာ တွိဟှားဘီး စစ်သားလေဟှာ အယ်သူဟှို ယေရှုရဲ့ လတ်ဝါးကပ်တိုင်ဟှို အဓမ္မထမ်းခိုင်းဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","“ဦးခေါန်းခွံနေရာ” ဆိုဘီး ဓိပါယ်ရှိဟှူ၊ ဂေါလဂေါသနာမယ်ရှိဟှူ နေရာဟှို ရော့‑က်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","အယ်နေရာမာ သူးနို့လေဟှာ ယေရှုဟှို ဆေးခါးန ရောစပ်ဟှားဟှူ ဝိုင်ဟှို ပေးသော့‑က်ဂေ့ဟှယ်။ အယ်ဘေမဲ့ ယေရှုဟှ ဗြဲကေ့ဘီးန သော့‑က်ဟှို့ ငြင်းတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ကိုယ်တော့်ဟှို ကားစင်တန်ဂေ့ဘီးန ကိုယ်တော်ရဲ့ ဝတ်တော်ဟှို မဲနှိုက်ဘီး ခွဲဝီဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","အယ်မျိုးလောက်ဘီးန အယ်နေရာမာ ကိုယ်တော့်ဟှို ထိုင်ဘီး စောန့်ကေ့နေဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ကိုယ်တော်ရဲ့ ခေါန်းတော်ထတ်မာ “ယုဒမန်းဂီး ယေရှုဖြစ်ဟှယ်” ဆိုဘီး ကိုယ်တော့်ဟှို စွပ်စွဲဟှားဟှူ စာပ္လားဟှိုလည်း ကပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","အယ်ဘီးန ယေရှုနတူးဒူ မ္လနှေ့ယော့‑က်ဟှိုလည်း ကိုယ်တော်ရဲ့ ညာဖတ်မာ တယော့‑က်၊ ဘယ်ဖတ်မာ တယော့‑က် ထားဘီးဟှာ ကားစင်တန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ဖြတ်သန်းသွားလာနေဟှူ သူလေဟှာ သူးနို့ရဲ့ ခေါန်းလေဟှို ခါဘီးဟှာ ယေရှုဟှို ကဲ့ရဲ့ဂေ့ဇာဟှ ");
INSERT INTO tvn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ဗိမာန်တော်ဟှို ဖြိုဖျစ်ဘီး သောင်းရစ်ဒဲန ပ္လန်တည်ဆော့‑က်ဟှို့သူ! နန့်ကိုယ်နန် ကယ်တန်ပါ! နန်ဟှာ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်ဟှယ် ဆိုဟှာ လတ်ဝါးကပ်တိုင်ဟှနေ ဆင်းလာပါ!” ");
INSERT INTO tvn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","အယ်နည်းတူ ယဇ်ပုရောဟိတ်ဂီးလေ၊ ကျမ်းပြုဆရာလေန သတ်ကီးဝါဂီးလေဟှလည်း ကိုယ်တော့်ဟှို ");
INSERT INTO tvn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“အယ်သူဟှာ တခြားလူလေဟှို ကယ်တန်ဘီးဟှာ သူ့ကိုယ်သူ ကယ်တန်နိုင်ဟှမား! သူဟှာ ဣသရေလမန်းဂီး မှုဟှလော။ သူဟှာ လတ်ဝါးကပ်တိုင်ဟှနေ ဆင်းလာမယ် ဆိုဟှာ နို့လေ ယောင်ကြည်ဂေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","သူဟှာ ဘုရားသခင်ဟှို အားကိုးဟှယ်။ ‘ငါဟှာ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်ဟှယ်’ ဆိုဘီး ပြောဟှယ်။ အယ်ကြောန့် သူ့ဟှို ဘုရားသခင် လိုတော်ရှိမယ် ဆိုဟှာ ခုဘဲ့ ကယ်တန်ပါစေ!” ဆိုဘီး သရော်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ကိုယ်တော်နတူးဒူ ကားစင်တန်ဟှားဟှူ မ္လနှေ့ယော့‑က်ဟှလည်း အယ်နည်းတူ ကဲ့ရဲ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","မွန်းဒဲ့ခီဟှနေ နေဒန်သောင်းနာရီထိအောန် တပြည်လောင်းဟှာ မှောန်မိုက်က္လလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","နေဒန်သောင်းနာရီမာ ယေရှုဟှ “ဧလိ၊ ဧလိ၊ လာမာရှာဗခသာနိ” ဆိုဘီး သံက္လယ်ဂီးန အော်ဟစ်တော်မူလေဟှယ်။ အယ်မူဓိပါယ်ဟှ “ကျွန်တော့်ဘုရားသခင်၊ ကျွန်တော့်ဘုရားသခင်၊ ဖြားဖြစ်ကြောန့် ကျွန်တော့်ဟှို စွန့်ပစ်တော်မူဟှယ်နူး” ဆိုဘီး ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","အယ်နေရာမာ ရပ်နေဟှူ လူလေတချို့ဟှာ အယ်မူဇာဟှို ကြားရခီမာ “သူဟှာ ဧလိယဟှို ခေါ်နေဟှယ်!” ဆိုဘီး ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","သူးနို့လေထဲဟှ တယော့‑က်ဟှာ တခါဒဲ ပ္လေးဟှားဘီး ရေမ္လောက်ဟှို ယူဘီး ရှင်နေဟှူ ဝိုင်ရှင်ထဲဟှို နှစ်ထဲ့လေဟှယ်။ အယ်ဘီးန ကျူဒေါက်ဖျားမာ တပ်ဘီး ကိုယ်တော့်ဟှို သော့‑က်ဟှို့ ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","အယ်ဘေမဲ့ တခြားလူလေဟှ “နေအူး၊ ဧလိယဟှာ သူ့ဟှို ကယ်ဟှို့တွပ် လာမယ် ဆိုဇာဟှို ကေ့ဂေ့ဇို့!” ဆိုဘီး ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ယေရှုဟှာ နော့‑က်ထပ် သံက္လယ်ဂီးန အော်ဘီးဟှာ သတ်တော်ဟှို စွန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","အယ်မူခီမာဘဲ့ ဗိမာန်တော်ရဲ့ လိုက်ကာဟှာ ထတ်ဟှနေ အော့‑က်ဟှို နှေ့ခြမ်းကွဲဟှားလေဟှယ်။ မ္လေဂီးဟှာ လှောက်ဘီး က္လော့‑က်လေဟှာ အတ်ကွဲဟှားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","သန်းခ္လိုင်းဂူလေလည်း ပွမ့်ထွပ်ဟှားလေဟှယ်။ ဘုရားသခင်ရဲ့ သန့်ရှင်းသူလေရဲ့ ကိုယ်ခန္ဓာလေဟှာ ထမြော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ယေရှု ရှင်ပ္လန်ထမြော့‑က်တော်မူဘီးန သူးနို့လေဟှာ သန်းခ္လိုင်းဂူထဲဟှ ထွပ်လာဘီးဟှာ သန့်ရှင်းဟှူ ဗြို့တော်ထဲဟှို ဝမ်ဟှားဘီး လူလေဟှို ကိုယ်ထန်ရှားပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","တပ်မှူးနတူးဒူ ယေရှုဟှို စောန့်ကေ့နေဂေ့ဟှူ စစ်သားလေဟှာ မ္လေဂီးလှောက်ဟှူ ဇာလေန ဖြစ်ပျစ်ဟှားဟှူ ဇာလေ ဂူလောင်းဟှို တွိဗြင်ရဟှူ ခီမာ သူးနို့ဟှာ ရရာတိုင်း ကြော့‑က်လန့်ဟှားဂေ့ဘီး “အယ်သူဟှာ တကယ်ဘဲ့ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်ဟှယ်!” ဆိုဘီး ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ဂါလိလဲပြည်ဟှနေ ယေရှုနော့‑က်လိုက်ဘီးဟှာ လောက်ကျွေးနေဟှူ မီးမလေဟှာ အယ်နေရာမာရှိနေဘီး ဝီးဟှနေ ကေ့နေဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","သူးနို့လေထဲမာ မာဂဒလဗြို့သူ မာရိ၊ ယာကုပ်န ယောသပ်လေရဲ့ မိဖြစ်ဟှူမာရိန ဇေဗေဒဲရဲ့မီးမ ပါလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","နေဒန်ဇာဟှို ရော့‑က်ဟှူ ခီမာ အရိမဿဲဗြို့ဟှနေ ယောသပ် ဆိုဘီး နာမယ်ရှိဟှူ ဌေးတယော့‑က် ရော့‑က်လာဘီး သူဟှာ ယေရှုရဲ့ တဗဲ့တော်လည်း ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","အယ်သူဟှ ပိလတ်နားဟှို ဝမ်ဟှားဘီး ယေရှုရဲ့ လောန်းတော်ဟှို တောန်းဟှူကြောန့် ပိလတ်ဟှာ ပေးလိုက်ဟှို့ မိန့်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","အယ်ကြောန့် ယောသပ်ဟှာ လောန်းဟှို ယူဘီး ဖ္လူစင်ဟှူ ပိဖ္လူန လိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","က္လော့‑က်တောင်းမာ ထွမ်းဟှားဟှူ သူ့ရဲ့ကိုယ်ပိုင် သန်းခ္လိုင်းဂူသစ်ထဲမာ သင်္ဂြိုဟ်လေဟှယ်။ အယ်ဘီးမှ သူဟှာ ကီးမားဟှူ က္လော့‑က်တောင်းဟှို သန်းခ္လိုင်းဂူဝမ်ဝရဲ့ ရှေ့မာ ပိဟှားဘီးန ပ္လန်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","မာဂဒလဗြို့သူ မာရိန တခြားမာရိလေဟှာ သန်းခ္လိုင်းရှေ့မာ ထိုင်နေဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ဒန်းနေ့တွပ် ပြင်ဆင်ရာနေ့ဘီးန ယဇ်ပုရောဟိတ်ဂီးလေန ဖာရိရှဲလေဟှာ ပိလတ်နားဟှို သွားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“သခင်၊ အယ်မူလူလီဟှာ သတ်ရှင်နေဒူးဟှ ‘သောင်းရစ်ကြာဘီးန ငါဟှာ ပ္လန်ထမြော့‑က်လေ့မယ်’ ဆိုဘီး ပြောဟှားဇာဟှို ကျွန်တော့်ဟှားလေ မှတ်မိပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","အယ်ကြောန့် သောင်းရစ်မြော့‑က်ဟှူ နေ့တိုင်အောန် သန်းခ္လိုင်းဂူဟှို ဒိနစောန့်ကေ့ဟှို့တွပ် မိန့်ပေးတော်မူပါ။ အယ်မျိုးလောက်ဘဲဟှ ဆိုဟှာ သူ့တဗဲ့လေဟှာ လောန်းဟှို လာခိုးဟှားဘီး သူဟှာ သေရာဟှနေ ထမြော့‑က်ဟှားဘီ ဆိုဘီး လူလေဟှို ပြောဂေ့ပါလေ့မယ်။ အယ်ဆိုဟှာ နော့‑က်ဆောင်း လီညာဟှူဇာဟှာ ရင်ဟှ လီညာဟှူဇာထတ် ပိုဘီး ဆိုးဝါးပါလေ့မယ်” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ပိလတ်ဟှ “စောန့်တပ် တတပ်ဟှို ခေါ်ဟှားဂေ့။ သန်းခ္လိုင်းဂူဟှို တတ်နိုင်ဟှူမျှ လောင်ခြောင်အောန် စောန့်ကေ့ခိုင်းဂေ့” ဆိုဘီး မိန့်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","အယ်ကြောန့် သူးနို့လေဟှာ သန်းခ္လိုင်းဟှို သွားဘီးဟှာ က္လော့‑က်တောင်းဟှို ဇိခပ်ဘီး စောန့်လေဟှို နေရာခ္လဟှားလိုက်ဘီး စောန့်ကေ့စေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ဒန်းနေ့လွန်ဘီးန နန်းနွေနေ့ မိုးလန်းခါနီးမာ မာဂဒလဗြို့သူ မာရိန တခြားမာရိလေဟှာ သန်းခ္လိုင်းဟှို သွားဘီး ကေ့ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်တပါးဟှာ ကောန်းဂန်ဘောင်ဟှနေ ဆင်းလာဟှူကြောန့် ရောက်တရစ် ရရာတိုင်း ကြမ်းဟှူ မ္လေဂီးလှောက်လာဟှယ်။ အယ်ဘီးန က္လော့‑က်တောင်းဟှို လှိဖယ်လိုက်ဘီး အယ်က္လော့‑က်တောင်းထတ်မာ ထိုင်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","သူ့ရဲ့ ရောန်ဆင်းဟှာ လျှပ်စစ်လတ်ဟှူမျိုးဖြစ်ဘီး သူ့ရဲ့ ဝတ်ဟှလည်း နှမ်းပွမ့်မျိုးဘဲ့ ဖ္လူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","စောန့်လေဟှာ ကောန်းဂန်တမန်ဟှို ရရာတိုင်း ကြော့‑က်လန့်ဂေ့ဘီး လူသေလေမျိုးဘဲ့ ဖြစ်ဟှားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ကောန်းဂန်တမန်ဟှ အယ်မီးမလေဟှို “ကြော့‑က်ဂေ့န။ နန်းနို့လေဟှာ လတ်ဝါးကပ်တိုင်မာ သတ်ခံရဟှူ ယေရှုဟှို ရှာနေဂေ့ဟှယ် ဆိုဇာဟှို ငါသိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ကိုယ်တော်ဟှာ အယ်နေရာမာမှေ့ဘီ။ မိန့်တော်မူဟှားဟှူတိုင်းဘဲ့ ထမြော့‑က်တော်မူဟှားဘီ။ ကိုယ်တော်လျောင်းတော်မူဟှားဟှူ နေရာဟှို လာဘီးကေ့ဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","တဗဲ့တော်လေနားဟှို ဗြန်းဗြန်သွားဘီး ‘ကိုယ်တော်ဟှာ သေရာဟှနေ ထမြော့‑က်တော်မူဟှားဘီ။ နန်းနို့လေထတ်စောဘီး ဂါလိလဲပြည်ဟှို ကြွတော်မူလေ့မယ်။ အယ်နေရာမာ နန်းနို့လေဟှာ ကိုယ်တော့်ဟှို တွိရဂေ့လေ့မယ်!’ ဆိုဘီး ပြောဂေ့ပါ။ ငါပြောလိုက်ဇာလေဟှို မေ့ဂေ့န။” ");
INSERT INTO tvn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","အယ်ကြောန့် အယ်မီးမလေဟှာ ကြော့‑က်လန့်ဘေမဲ့လည်း အားရဝန်းသာန သန်းခ္လိုင်းဟှနေ ဗြန်းဗြန်ထွပ်ဟှားဘီး တဗဲ့တော်လေဟှို ပြောပြဟှို့တွပ် ပ္လေးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ရောက်တရစ် ယေရှုဟှ သူးနို့နားဟှို ရော့‑က်လာဘီးဟှာ “နန်းနို့နတူးဒူ ငြီသတ်ရှင်းရှိပါစေ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ သူးနို့ဟှာ ကိုယ်တော်နားဟှို ချဉ်းကပ်ဘီးဟှာ ခေတော်ဟှို ဖတ်ဘီး ရှိခိုးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ယေရှုဟှ “ကြော့‑က်ဂေ့န။ သွားဘီးဟှာ ငါ့ရဲ့ ညီကိုလေဟှို ဂါလိလဲပြည်ဟှို သွားဟှို့တွပ် ပြောဂေ့။ သူးနို့လေဟှာ အယ်နေရာမာ ငါ့ဟှို ဗြင်ရဂေ့လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","အယ်မီးမလေဟှာ လမ်းမာ သွားနေဒူးမာ သန်းခ္လိုင်းဂူစောန့်နေဟှူ တပ်သားတချို့ဟှာ ဗြို့ထဲဟှို ဝမ်ဘီး ယဇ်ပုရောဟိတ်ဂီးလေဟှို ဖြစ်ပျစ်ဇာလေ ဂူလောင်းဟှို ပြောပြဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ယဇ်ပုရောဟိတ်ဂီးလေဟှာ သတ်ကီးဝါဂီးလေန တွိဆောင်ဂေ့ဘီး ဆွေးနွေးဘီးန သူးနို့ဟှာ စစ်သားလေဟှို ကပ်လေဘောင်ဂီးပေးဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“နို့လေအိမွီနေဒူးမာ သူ့ရဲ့ တဗဲ့လေဟှာ ညဉ့်ခန်းဖတ်မာ လာဘီး လောန်းဟှို ခိုးဆောန်ဟှားဟှယ် ဆိုဘီး ပြောဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ဗြို့ဝန်မန်းဟှာ အယ်မူဒန်းဟှို သိဟှားမယ် ဆိုဟှာ နို့လေဟှာ သူ့ဟှို စည်းရောင်းဘီး နန်းနို့မာ စိုးရိမ်ဇာမှေ့ဟှို့တွပ် လောက်ပေးမယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","စောန့်လေဟှာ ကပ်ဟှို ယူဘီးဟှာ သူးနို့ဟှို ညွန်ကြားဟှားဟှူတိုင်း လောက်ဂေ့လေဟှယ်။ အယ်ကြောန့် အယ်ဒန်းဟှာ ယုဒလူမျိုးလေထဲမာ အယ်နေ့ထိ ပ္လံ့နှံ့နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","တဗဲ့တော်ဆယ့်တယော့‑က်ဟှာ ဂါလိလဲပြည်ဟှို သွားဘီး ယေရှုမှာဟှားတိုင်း တောန်ထတ်ဟှို သွားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","သူးနို့လေဟှာ ကိုယ်တော့်ဟှို တွိဗြင်ရဟှူ ခီမာ ရှိခိုးဂေ့လေဟှယ်။ အယ်ဘေမဲ့ သူးနို့ထဲဟှ တချို့ဟှာ သံသယဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ယေရှုဟှာ တဗဲ့တော်လေနားဟှို ကြွလာဘီးဟှာ “ကောန်းဂန်န မ္လေဂီးထတ်မာ ရှိမျှဟှူ ခွမ့်အာဏာလေဟှို ငါ့ဟှို ပေးအပ်တော်မူဘီ။ ");
INSERT INTO tvn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","အယ်ကြောန့် နန်းနို့လေဟှာ သွားဘီး လူဘောန်းဇောင်ဟှို ငါ့တဗဲ့ဖြစ်စေဘီးဟှာ ဖ၊ သားတော်၊ သန့်ရှင်းဟှူဝိညာဉ်တော်ရဲ့ နာမတော်ထဲမာ ဗတ္တိဇံပေးဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","နန်းနို့လေဟှို ငါပညတ်ဟှားဇာလေ ဂူလောင်းဟှို နာခံဟှို့တွပ် သွန်သန်ဂေ့ပါ။ ငါဟှာလည်း ကမ္ဘာကူဆောင်းဟှူ ခီထိ နန်းနို့လေနတူးဒူ မြဲဒမ်းရှိနေမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။");
INSERT INTO tvn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ဘုရားသခင်ရဲ့ သားတော် ယေရှုခရစ်တော်ကြောန်း ဒန်းကောန်းဟှာ အယ်မျိုးဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ပရောဖက်ဟေရှာယ ရေးဟှားဟှူဇာဟှ၊ “ဘုရားသခင်ဟှ ပြောဟှားဟှယ်၊ ‘ငါဟှာ နန့်ရဲ့လမ်းဟှို ပြင်ဆင်ဟှို့တွပ် ငါ့ရဲ့တမန်ဟှို နန့်ရှေ့မာ စေလွှတ်မယ်။’ ");
INSERT INTO tvn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","တောကန္တာရထဲမာ ယော့‑က်ယော့‑က်ဟှ အော်ပြောနေဇာဟှ ‘ဘုရားသခင်ရဲ့ လမ်းဟှို ပြင်ဆင်ဟှားဂေ့! အယ်သခင်တွပ် ဖြောန့်တန်းဟှူလမ်းဟှို လောက်ဟှားဂေ့!’ ” ");
INSERT INTO tvn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ယောဟန်ဟှာ ပေါ်လာဘီး၊ တောကန္တာရမာ ဟောပြောဘီးန ဗတ္တိဇံပေးနေဟှယ်။ “နောန်ဒရဘီး ဗတ္တိဇံခံဂေ့။ အယ်ဆိုဟှာ ဘုရားသခင်ဟှ နန်းနို့ရဲ့ ပြစ်လေဟှို ခွမ့်လွှတ်လေ့မယ်” ဆိုဘီး ကြေညာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ယုဒပြည်ဟှ လူလေန ယေရုရှလင်ဗြို့ရဲ့လူလေ ဂူလောင်းဟှာ ယောဟန်နားဟှို ရော့‑က်လာဂေ့ဘီး သူးနို့ရဲ့ ပြစ်လေဟှို ဝန်ခံဂေ့ဟှူကြောန့် ယော်ဒန်မ္လစ်မာ ယောဟန်အားဖြင့် ဗတ္တိဇံခံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ယောဟန်ဟှာ ကုလားအုတ်ရဲ့ မွီးန လောက်ဟှားဟှူဝတ်န သားရေခါးဗတ်ဟှို ခါးမာပတ်ဟှားဘီး ကျိုင်းကောန်န တောပျားရယ်ဟှို စားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","သူဟှာ လူလေဟှို ကြေညာဇာဟှ “ငါ့ထတ် ပိုဘီး ကီးမြတ်ဟှူလူဟှာ ငါ့နော့‑က်ဟှ ကြွလာလေ့မယ်။ ငါဟှာ ငေါက်ဘီးဟှာ သူ့ရဲ့ ခေနပ်ကြိုးဟှို ဖြေဟှို့ဟှိုမှ ထိုက်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ငါဟှ နန်းနို့လေဟှို ရေန ဗတ္တိဇံပေးဟှယ်။ အယ်ဘေမဲ့ သူဟှ နန်းနို့ဟှို သန့်ရှင်းဟှူဝိညာဉ်တော်န ဗတ္တိဇံပေးလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","အယ်ခီမာ ယေရှုဟှ ဂါလိလဲပြည် နာဇရက်ဗြို့ဟှ လာဘီးဟှာ ယော်ဒန်မ္လစ်မာ ယောဟန်အားဖြင့် ဗတ္တိဇံခံလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ယေရှုဟှာ ရေထဲဟှထလိုက်ဟှူန ကောန်းဂန်ဘောင် ပွမ့်ဟှားဘီး ဝိညာဉ်တော်ဟှ ချိုးငှတ်မျိုး ကိုယ်တော်ထတ်ဟှို ဆင်းလာနေဇာဟှို ဗြင်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","“နန်ဟှာ ငါနှစ်သက်မြတ်နိုးဟှူ ငါ့ရဲ့ ရှစ်ရဟှူသား ဖြစ်ဟှယ်” ဆိုဘီး ကောန်းဂန်ဟှနေ သံတော်ထွပ်ပေါ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ဝိညာဉ်တော်ဟှ ကိုယ်တော့်ဟှို တောကန္တာရထဲဟှို ရှစ်ရှင်းပို့ဆောန်ဘီး ");
INSERT INTO tvn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ကိုယ်တော်ဟှာ တောကန္တာရထဲမာ ရစ်လေးဆယ် လောင်းလောင်း နေဘီး စာတန်ရဲ့ စောင်ဇမ်းသွီးဆောန်ရှင်းဟှို ခံတော်မူဟှယ်။ ကိုယ်တော်ဟှာ သားရဲလေနတူးဒူ ရှိတော်မူဘီး ကောန်းဂန်တမန်လေဟှာ ကိုယ်တော့်ဟှို လောက်ကျွေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ယောဟန် ထောန်ခ္လခံရဘီးန ယေရှုဟှာ ဂါလိလဲပြည်ဟှို သွားဘီး ဘုရားသခင်ရဲ့ ဒန်းကောန်းဟှို ကြေညာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“ခီပ္လဲ့ဇောင်ဟှားဘီ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှာ တည်ခါနီးနေဘီ! နောန်ဒရဘီးဟှာ ဒန်းကောန်းဟှို ယောင်ကြည်ဂေ့ပါ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ယေရှုဟှ ဂါလိလဲအိုင်ဘေးမာ ရှော့‑က်သွားနေဒူးမာ ငါးဖမ်းမားလေဖြစ်ဟှူ ရှိမုန်န သူ့ညီ အန္ဒြေလေဟှာ အိုင်ထဲမာ ပိုက်ကွန်ပစ်နေဇာဟှို ဗြင်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ယေရှုဟှ “ငါ့နော့‑က်လိုက်ဂေ့။ နန်းနို့လေဟှို လူလေဟှိုဖမ်းဟှူ ငါးဖမ်းမားဖြစ်စေမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","သူးနို့လေဟှ ရှစ်ရှင်းဘဲ ပိုက်လေဟှို ထားရစ်ဘီးန နော့‑က်ဟှို လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ကိုယ်တော်ဟှာ နဲနဲဆစ်ဘီးသွားဟှူ ခီမာ ဇေဗေဒဲရဲ့သား ယာကုပ်န သူ့ညီယောဟန်ဟှို ဗြင်ဟှားဟှယ်။ သူးနို့ဟှာ လှေထဲမာ ပိုက်ကွန်လေ ဖာနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ယေရှုဟှ သူးနို့လေဟှို ရှစ်ရှင်းခေါ်လိုက်ဟှယ်။ သူးနို့လေဟှာ သူးနို့ဖ ဇေဗေဒဲဟှို လူငှားလေနတူးဒူ လှေထတ်မာ ထားရစ်ဘီးဟှာ ယေရှုနော့‑က်ဟှို လိုက်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ယေရှုန တဗဲ့တော်လေဟှာ ကပေရနောင်ဗြို့ဟှို ဝမ်ဂေ့ဘီး ဒန်းနေ့မာ ယေရှုဟှာ ဝါလယ်ဇရပ်ထဲဟှို ဝမ်ဟှားဘီးဟှာ စဘီးသွန်သန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","လူလေဟှာ ကိုယ်တော်ရဲ့ သွန်သန်ဇာဟှို အံ့ဩဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကိုယ်တော်ဟှာ သူးနို့ဟှို ကျမ်းတတ်ဆရာလေမျိုး မှုဘဲ့န ခွမ့်အာဏာရှိဟှူသူမျိုး သွန်သန်ဟှူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","အယ်ခီမာဘဲ့ ညစ်ညူးဟှူနတ် ဝမ်ပူးနေဟှူ လူတယော့‑က်ဟှာ ဝါလယ်ဇရပ်ထဲဟှို ဝမ်လာဘီးဟှာ အော်နေဇာဟှ ");
INSERT INTO tvn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“နာဇရက်ဗြို့သား ယေရှု၊ ကိုယ်တော်ဟှ ကျွန်တော့်လေန ဖြားဆိုင်ဟှယ်နူး။ ကျွန်တော့်လေဟှို ဖျစ်ဆီးဟှို့တွပ် ရော့‑က်လာဇာလော။ ကိုယ်တော်ဟှာ ဖယ်သူဖြစ်ဟှယ် ဆိုဇာ ကျွန်တော်သိဟှယ်။ ကိုယ်တော်ဟှာ ဘုရားသခင်ရဲ့ သန့်ရှင်းဟှူသူ ဖြစ်ဟှယ်!” ");
INSERT INTO tvn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ယေရှုဟှာ အယ်နတ်ဟှို “တိတိဟှားနေဘီး အယ်လူထဲဟှ ထွပ်ဟှားဂေ့!” ဆိုဘီး ဆောင်းမလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ညစ်ညူးဟှူနတ်ဟှ အယ်လူဟှို ရရာတိုင်း တတ်စေဘီး သံက္လယ်ဂီး အော်ဘီးဟှာ ထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","လူလေ ဂူလောင်းဟှ အံ့ဩဟှားဂေ့ဘီး “အယ်ဇာဟှ ဖယ်မျိုးနူး။ အယ်ဇာဟှ သွန်သန်မှု သစ်တမျိုးလော။ အယ်လူဟှာ ညစ်ညူးဟှူနတ်လေဟှို ခွမ့်အာဏာန မိန့်ပေးလိုက်ဇာ သူးနို့ဟှာ နာခံဂေ့ဟှယ်!” ဆိုဘီး ရှင်းရှင်း မေးနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","အယ်ကြောန့် ယေရှုရဲ့ ဒန်းဟှာ ဂါလိလဲပြည် တခုလောင်းဟှို ရှစ်ရှင်း ပ္လန့်နှံ့ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ယေရှုန တဗဲ့တော်လေဟှာ ဝါလယ်ဇရပ်ဟှနေ ထွပ်ဟှားဘီး ရှစ်ရှင်းဘဲ့၊ ယာကုပ်၊ ယောဟန်နတူးဒူး ရှိမုန်န အန္ဒြေရဲ့အီဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ရှိမုန်ရဲ့ ယောက္ခမဟှာ ဖျားနာဘီး အိယာထတ်မာ လှဲနေကြောန်းဟှို ယေရှုဟှို ရှစ်ရှင်း တောန်းလျှော့က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","အယ်ကြောန့် ကိုယ်တော်ဟှာ အယ်မီးမနားဟှို သွားဘီးဟှာ သူ့ရဲ့လတ်ဟှို ကိုင်ဘီး ဆွဲဒန်လိုက်ဟှယ်။ သူဟှာ ဖျားနာပျော့‑က်ဟှားကြောန့် သူးနို့ဟှို ဧည့်ဝတ်ပြုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","နေဝမ်ဟှားဘီး ညဉ့်ခန်းဇာရော့‑က်ဟှားခီမာ လူလေဟှာ ဖျားနာသူလေန နတ်ဆိုးဝမ်ပူးသူလေ ဂူလောင်းဟှို ယေရှုနားဟှို ခေါ်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","တဗြို့လောင်းဟှာ ခွဗော့‑က်ဝမာ စုဝီးလာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ယေရှုဟှာ ရောဂါဘောန်းဇောင်ရှိဟှူ လူလေဘောင်ဂီးဟှို ကျန်းမာစေဘီး နတ်ဆိုးဘောင်ဂီးဟှို နှန်ထုဟှယ်။ နတ်ဆိုးလေဟှ ကိုယ်တော့်ဟှို သိဂေ့ဟှူကြောန့် သူးနို့ဟှို စကားပြောခွမ့်ပေးဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","မိုးလန်းခန် စောစောဂီးမာ ယေရှုဟှ အိယာဟှထဘီးဟှာ အီဟှထွပ်ဟှားဟှယ်။ ကိုယ်တော်ဟှာ ဗြို့ထဲဟှနေ လူမှေ့သူမှေ့ဘဲဟှူ နေရာဟှို ထွပ်ဟှားဘီးဟှာ ဆုတောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ရှိမုန်န သူ့ရဲ့ ပေါန်းဖော်လေဟှာ ကိုယ်တော့်ဟှို လိုက်ရှာဂေ့ဘီး ");
INSERT INTO tvn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ကိုယ်တော့်ဟှို တွိဂေ့ဟှူ ခီမာ “လူတိုင်းဟှာ ကိုယ်တော့်ဟှို လိုက်ရှာနေဂေ့ဟှယ်” ဆိုဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ယေရှုဟှ “နို့လေဟှာ နီးနားမာရှိဟှူ တခြား ဗြို့ဝါလေဟှို သွားရမယ်။ ငါဟှ သူးနို့ဟှိုလည်း ဟောပြောရအူးမယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါဟှာ အယ်တွပ်ဘဲ့ကြွလာဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","အယ်ကြောန့် ကိုယ်တော်ဟှာ ဂါလိလဲပြည် တပြည်လောင်းဟှို ကြွတော်မူဘီး ဝါလယ်ဇရပ်လေမာ ဟောပြောဘီးဟှာ နတ်ဆိုးလေဟှို နှန်ထုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","နူနာသယ် တယော့‑က်ဟှာ ယေရှုနားဟှို ရော့‑က်လာဟှူ ခီမာ ဒူးထော့‑က်ဘီးဟှာ “ကိုယ်တော်လိုရှိဟှယ် ဆိုဟှာ ကျွန်တော့်ဟှို သန့်ရှင်းပေးပါ” ဆိုဘီး တောန်းဗန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ယေရှုဟှာ သနား တော်မူဟှားဘီး လတ်တော်ဟှို ဆန့်ဘီးဟှာ အယ်လူဟှို ထိလိုက်ဟှယ်။ “ငါလိုရှိဟှယ်။ သန့်ရှင်းစေ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ရှစ်ရှင်းဘဲ့ နူနာရောဂါဟှာ ပျော့‑က်ဟှားဘီး သူဟှာ သန့်ရှင်းဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ယေရှုဟှာ သူ့ဟှို ရှစ်ရှင်းလွှတ်လိုက်ဘီး ");
INSERT INTO tvn_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“နန်ဟှာ အယ်မူဇာဟှို ဖယ်သူ့ဟှိုလည်း ပြောန။ အယ်ဘေမဲ့ ယဇ်ပုရောဟိတ်နားဟှို သွားဘီး ကိုယ်ဟှိုပြလိုက်ပါ။ စင်ကြယ်ကြောန်းဟှု လူလေရှေ့မာ သတ်သေဖြစ်ဟှို့တွပ် မောရှေ ပညတ်ဟှားဟှူတိုင်း ပူဇော်သကာဟှို ဆစ်သပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","အယ်ဘေမဲ့ အယ်လူဟှ ထွပ်ဟှားဘီး အယ်ဒန်းဟှို အားရပါးရ ဟောပြောဘီး ပ္လံ့နှံ့စေလေဟှယ်။ အယ်ကြောန့် ယေရှုဟှ ဗြို့ထဲဟှို ထန်းထန်ရှားရှားဟှား ဝမ်နိုင်ဘဲန လူမှေ့သူမှေ့ဘဲဟှူ ဗြို့ပ္လန်နေရာမာဘဲ့ နေရဟှယ်။ အယ်ဘေမဲ့ နေရာတိုင်းဟှနေ လူလေဟှ ကိုယ်တော်နားဟှို ရော့‑က်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ရစ်နဲနဲကြာဘီးန ယေရှုဟှာ ကပေရနောင်ဗြို့ဟှို ပ္လန်ဝမ်ဟှားဘီး၊ ကိုယ်တော်ဟှာ အီမာရှိနေဟှယ် ဆိုဘီး ဒန်းဟှို လူလေကြားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","လူလေဘောင်ဂီးဟှာ ရော့‑က်လာဂေ့ဟှူကြောန့် ခွဗော့‑က်ဝပ္လန်မာလည်း နေရာလွတ် မှေ့ဟှမ်း။ ယေရှုဟှာ သူးနို့ဟှို တရားစကားဟှို ဟောပြောနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","အယ်ခီမာ လူလေးယော့‑က်ဟှ ရော့‑က်လာဘီး လေဖြတ်နေဟှူ လူတယော့‑က်ဟှို ယေရှုနားဟှို သယ်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","အယ်ဘေမဲ့လည်း လူအောက်ဂီးကြောန့် သူးနို့ဟှာ အယ်လူဟှို ကိုယ်တော်နားဟှို သယ်ဟှို့တတ်နိုင်ဟှမ်း။ အယ်ကြောန့် သူးနို့ဟှာ ယေရှုရှိဟှူ နေရာထတ်ဟှ ခေါန်မိုးဟှို ပေါ့‑က်ဖော့‑က်လိုက်ဟှယ်။ သူးနို့ဟှာ လေဖြတ်နေဟှူလူဟှို ထမ်းစင်န လျှောခ္လဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ယေရှုဟှာ သူးနို့လေရဲ့ ယောင်ကြည်ရှင်းဟှို ဗြင်ဟှားဟှူ ခီမာ လေဖြတ်နေဟှူလူဟှို “ငါ့သား၊ နန့်ရဲ့ ပြစ်လေဟှာ ခွမ့်လွတ်ဇာခံရဘီ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","အယ်နေရာမာ ထိုင်နေဟှူ ကျမ်းတတ်ဆရာ တချို့ဟှ သူးနို့ရဲ့ စိထဲမာ စဉ်းစားနေဇာဟှ ");
INSERT INTO tvn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“အယ်လူဟှာ ဖြားဖြစ်ကြောန့် အယ်မျိုးပြောနူး! သူဟှာ ပြစ်မှားနေဇာ ဖြစ်ဟှယ်! ဘုရားသခင် တပါးဒဲဘဲ့ ပြစ်လေဟှို လွတ်ပိုင်နိုင်ဟှယ်!” ");
INSERT INTO tvn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","သူးနို့ရဲ့ စိထဲမာ အယ်မျိုး စဉ်းစားနေဇာဟှို ယေရှုဟှာ ရှစ်ရှင်း သိဟှူကြောန့် “နန်းနို့လေဟှ ဖြားဖြစ်ကြောန့် အယ်ဇာလေဟှို စဉ်းစားနေဂေ့နူး။ ");
INSERT INTO tvn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","လေဖြတ်နေဟှူ လူဟှို ‘နန့်ရဲ့ ပြစ်ဟှို လွတ်ဟှားဘီ’ အယ်မျိုးမှုဘဲ့နေဟှာ ‘နန်ထလိုက်၊ နန့်ထမ်းစင်ဟှို ထမ်းဘီးသွားလိုက်’ ဆိုဘီး ဖယ်စကားဟှ ပိုဘီး ပြောဟှို့လွယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","အယ်ကြောန့် လူ့ရဲ့သားဟှာ မ္လေဂီးထတ်မာ ပြစ်လေလွှတ်ဟှို့ ခွမ့်အာဏာရှိဟှယ် ဆိုဇာ နန်းနို့လေဟှို ငါသတ်သေထူပြမယ်။” အယ်ကြောန့် ကိုယ်တော်ဟှ လတ်ခေသေနေဟှူ လူဟှို ");
INSERT INTO tvn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“နန့်ဟှို ငါပြောမယ်။ ထဒန်။ နန့်ရဲ့ ထမ်းစင်ဟှို ကော့‑က်ဘီးဟှာ အီဟှို ပ္လန်ဟှားလိုက်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","လူလေ ဂူလောင်းဟှာ စောန့်ကေ့နေဒူးမာ အယ်လူဟှာ ထဘီး၊ သူ့ရဲ့ ထမ်းစင်ဟှို ယူဘီးဟှာ ထွပ်ဟှားလေဟှယ်။ သူးနို့လေ ဂူလောင်းဟှာ ရရာတိုင်း အံ့ဩဟှားဘီးဟှာ ဘုရားသခင်ဟှို ချီးမွမ်းဂေ့ဘီး “နို့လေဟှာ အယ်မျိုးဇာဟှို လောင်းဝဗြင်ဖူးဟှ!” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ယေရှုဟှာ နော့‑က်တခါ ဂါလိလဲအိုင်နားဟှို ပ္လန်ဟှားလေဟှယ်။ လူအောက်ဂီးဟှ ကိုယ်တော်နားဟှို လာဂေ့ဟှူကြောန့် ကိုယ်တော်ဟှာ သူးနို့ဟှို စဘီးဟှာ သွန်သန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ကိုယ်တော်ဟှာ ဆစ်ဘီး ရှော့‑က်သွားဟှူ ခီမာ အာလဖဲရဲ့သား၊ ခွန်ခံလေဝိဟှာ သူ့ရဲ့ ရောင်းမာ ထိုင်နေဇာဟှို ဗြင်ဟှားလေဟှယ်။ ယေရှုဟှ “ငါ့နော့‑က်ဟှို လိုက်ပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ လေဝိဟှာ ထဘီး ကိုယ်တော်နော့‑က်ဟှို လိုက်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","အယ်ဘီးန ယေရှုဟှာ လေဝိရဲ့အီမာ ညဉ့်ခန်းဇာ စားနေဂေ့ဟှယ်။ ခွန်ကော့‑က်မားလေန ပြစ်သားလေ ဘောင်ဂီးဟှာ ယေရှုနော့‑က်ဟှို လိုက်လာဂေ့ဘီး သူးနို့ထဲဟှ တချို့ဟှာ ကိုယ်တော်န တဗဲ့တော်လေနတူးဒူ စားသော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ယေရှုဟှာ ခွန်ကော့‑က်မားလေ၊ ပြစ်သားလေနတူးဒူ စားသော့‑က်နေဇာဟှို ဖာရိရှဲလေ၊ ကျမ်းတတ်ဆရာလေဟှာ ဗြင်ဟှားဘီး “ဖြားဖြစ်ကြောန့် သူဟှ အယ်လူလေန စားသော့‑က်နေရနူး” ဆိုဘီး တဗဲ့တော်လေဟှို မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ယေရှုဟှ ကြားဟှားဘီး သူးနို့ဟှို “ကျန်းမာဟှူ လူလေဟှ ဆရာဝန်ဟှို လိုဂေ့ဟှ၊ ဖျားနေဟှူ လူလေဘဲ့ လိုရှင်ဟှယ်။ ငါဟှာ ဖြောန့်မတ်ဟှူ လူလေဟှို ခေါ်ဟှို့လာဇာမှုဟှ။ ပြစ်သားလေဟှို ခေါ်ဟှို့လာဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","တနေ့မာ ဗတ္တိဇံယောဟန်ရဲ့ တဗဲ့တော်လေန ဖာရိရှဲလေဟှ စာရှောန်နေဂေ့ဟှယ်။ လူတချို့ဟှ ယေရှုနားဟှို လာဘီး “ယောဟန်ရဲ့ တဗဲ့လေန ဖာရိရှဲရဲ့ တဗဲ့လေဟှာ စာရှောန်ဂေ့ဘီး ကိုယ်တော်ရဲ့ တဗဲ့လေဟှ ဖြားဖြစ်ကြောန့် စာရှောန်ဘဲန နေဂေ့နူး” ဆိုဘီး မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ယေရှုဟှ “အီတတ်ဗွဲမာ ဒို့သားနတူးဒူ ရှိနေဟှူ ဧည့်သည်လေဟှာ ဒို့သားနတူးဒူ ရှိနေဒူးမာ စာရှောန်မယ် ဆိုဘီး မျှော်လင့်နိုင်ဘဲ့လော။ သူးနို့ဟှာ ဒို့သားနတူးဒူ ရှိနေဒူးမာ စာရှောန်နိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","အယ်ဘေမဲ့ ဒို့သားဟှို သူးနို့နားဟှနေ ယူဆောန်ဟှားဟှူ ခီရော့‑က်လာလေ့မယ်။ အယ်နေ့မာ သူးနို့ဟှ စာရှောန်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“ဖယ်သူလည်း အန်းဂီဟောန်းဟှို ပိစသစ်နဖာလေ့ မှေ့ဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဖာဟှားဟှူ ပိစသစ်ဟှ အန်းဂီဟောန်းဟှို စုဖ္လဲဘီးဟှာ ပိုဆိုးဟှားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","အယ်မျိုးဘဲ့ ဝိုင်သစ်ဟှို သားရေဖူး ဟောန်းထဲမာထဲ့လေ့ မှေ့ဟှ။ ထဲ့မယ် ဆိုဟှာ ဝိုင်သစ်ဟှ သားရေဖူးဟောန်းဟှို ပေါ့‑က်ပ္လဲစေဘီး ဝိုင်န သားရေဖူး နှေ့ခုလောင်းဟှာ ပျစ်စီးဟှားလေ့မယ်။ အယ်မျိုးလောက်မယ့်စား ဝိုင်သစ်ဟှို သားရေဖူးသစ်ထဲမာ ထဲ့ရမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ဒန်းနေ့မာ ယေရှုဟှာ ဂျောင်စဗားလယ်ဂွမ့်လေဟှို ဖြတ်ရှော့‑က်နေလေဟှယ်။ ကိုယ်တော်ရဲ့ တဗဲ့တော်လေနတူးဒူ သွားနေဟှူ ခီမာ သူးနို့ဟှာ စဘီးဟှာ ဂျောင်စဗားနှံလေဟှို ဆွတ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ဖာရိရှဲလေဟှ “ဒန်းနေ့မာ လောက်အပ်ဘဲဟှူ ဇာဟှို ကိုယ်တော်ရဲ့ တဗဲ့တော်လေဟှ ဖြားဖြစ်ကြောန့် လောက်ဂေ့နူး” ဆိုဘီး ယေရှုဟှို မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ယေရှုဟှ “ဒါဝိဒ်ဟှ စားဟှို့ တခုခု လိုအပ်လာဟှူ ခီမာ သူဟှာ ဖယ်မျိုးလောက်ဟှားဇာဟှို နန်းနို့ လောင်းဝ ဖတ်ဖူးဂေ့ဟှလော။ သူ့န သူ့ရဲ့ လူလေဟှာ ဗိုက်ဆာလာဟှူကြောန့် ");
INSERT INTO tvn_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","သူဟှာ ဘုရားသခင်ရဲ့ အီတော်ထဲဟှို ဝမ်ဟှားဘီး ဘုရားသခင်ဟှို ဆစ်ကပ်ဟှားဟှူ မုဟှို စားဂေ့ဟှယ်။ အယ်ဇာဟှာ ယဇ်ပုရောဟိတ်မန်း အဗျာသာလတ်ထတ်မာ ဖြစ်ပျစ်ဟှားဟှယ်။ နို့လေရဲ့ ပညတ်တရား တိုင်းဆိုဟှာ အယ်မုဟှို ယဇ်ပုရောဟိတ်လေဘဲ့ စားခွမ့်ရှိဟှယ်။ အယ်ဘေမဲ့ ဒါဝိဒ်ဟှာ အယ်မုဟှို စားဘီးဟှာ သူ့ရဲ့ လူလေဟှိုလည်း ပေးလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","အယ်ဘီးန ယေရှုဟှာ “ဒန်းနေ့ဟှာ လူလေတွပ်ဘဲ့ ဖြစ်ဟှယ်။ လူဟှာ ဒန်းနေ့တွပ်ဖြစ်ဇာ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","အယ်ကြောန့် လူ့ရဲ့သားဟှာ ဒန်းနေ့ရဲ့ သခင်ဖြစ်ဟှယ်” ဆိုဘီး သူးနို့လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ယေရှုဟှာ ဝါလယ်ဇရပ်ထဲဟှို ပ္လန်ဝမ်ဟှားဘီးဟှာ အယ်နေရာမာ လတ်တဖတ်သေနေဟှူ လူတယော့‑က်ရှိနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","လူလေဟှာ ယေရှုဟှို စွတ်စွဲဟှို့တွပ် အယ်လူဟှို ဒန်းနေ့မာ နာပျော့‑က်စေမယ်၊ ပျော့‑က်စေဟှ ဆိုဇာဟှို နီးကပ် စောန့်ကေ့နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ယေရှုဟှာ အယ်လူဟှို “လူလေ ဂူလောင်းရှေ့မာ ထဒန်လိုက်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","အယ်ဘီးန ယေရှုဟှာ “နို့လေရဲ့ ပညတ်တော်ဟှ ဒန်းနေ့မာ ကောန်းဇာလောက်ဟှို့လော။ ဆိုးဇာလောက်အပ်ဘဲ့လော။ လူသတ်ဟှို ကယ်အပ်ဘဲ့လော။ သတ်အပ်ဘဲ့လော” ဆိုဘီး သူးနို့ဟှို မေးတော်မူလေဟှယ်။ အယ်ဘေမဲ့ သူးနို့ဟှာ တိတိဟှားဘဲ့ နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ယေရှုဟှာ ဒေါသထွပ်ဘီးဟှာ သူးနို့လေဟှို လှည့်ပတ်ကေ့ဘီး သူးနို့ရဲ့ စိနှလောင်းမာကြောဟှူကြောန့် ရရာတိုင်း ဝမ်းနဲဘီး လတ်သေနေလူဟှို “နန့်လတ်ဟှို ဆန့်လိုက်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ သူဟှလည်း လတ်ဟှို ဆန့်လိုက်ဟှူ ခီမာ သူ့လတ်ဟှာ ကောန်းတိုင်း ပ္လန်ဖြစ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ဖာရိရှဲလေဟှာ ဝါလယ်ဇရပ်ဟှ ထွပ်ဟှားဂေ့ဘီး ယေရှုဟှိုသတ်ဟှို့ နည်းလမ်းလေဟှို ဟေရုဒ်ဖွဲ့ဝမ်လေန ရှစ်ရှင်းဘဲ့ တိုင်ဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ယေရှုဟှာ တဗဲ့တော်လေနတူးဒူ ဂါလိလဲအိုင် ယုဒပြည်ဟှို သွားလေဟှယ်။ အယ်ဘီးန လူအောက်ဂီးဟှာ ကိုယ်တော်နော့‑က်ဟှို လိုက်ဂေ့ဟှယ်။ သူးနို့လေဟှ ဂါလိလဲပြည်၊ ယုဒပြည်၊ ");
INSERT INTO tvn_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ယေရုရှလင်ဗြို့၊ က္ကဒုမဲပြည်၊ ယော်ဒန်မ္လစ်ရဲ့ ဟိုဖတ်ကမ်း၊ တုရုနဇိဒုန်ဗြို့ နီးနားရပ်ဝါလေဟှ လူလေဟှာ ယေရှုလောက်ဟှားဟှူ မှုရာလေဟှို ကြားဟှူ ခီမာ သူးနို့ဟှာ ကိုယ်တော်နားဟှို လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","လူအောက်ဟှာ ရရာတိုင်းကီးဟှူကြောန့် ယေရှုဟှ သူ့ဟှိုလူလေ တိုက်မိဘဲနေအောန် လှေတစီးဟှို သူ့တွပ်ဆင်သင့်လောက်ဟှားဟှို့ တဗဲ့တော်လေဟှို မိန့်မှာဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ကိုယ်တော်ဟှာ လူနာဘောင်ဂီးဟှို ကျန်းမာစေပီးဘီ ဖြစ်ဟှူကြောန့်၊ ရောဂါရှိနေဟှူ လူလေဟှ ကိုယ်တော့်ဟှို ထိရဟှို့တွပ် တိုးဝမ်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ညစ်ညူးဟှူ နတ်လေဟှ ကိုယ်တော့်ဟှို ဗြင်ဟှူ ခီမာ ကိုယ်တော့်ရှေ့မာ ပျပ်ဝပ်ဘီးဟှာ “ကိုယ်တော်ဟှာ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်ဟှယ်!” ဆိုဘီး အော်ဟစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ယေရှုဟှ သူဖယ်သူ ဖြစ်ဟှယ် ဆိုဇာ ပြောဘဲနေဟှို့တွပ် ညစ်ညူးဟှူ နတ်လေဟှို မိန့်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","အယ်ဘီးန ယေရှုဟှာ တောန်ထတ်ဟှို ကြွဟှားဘီး လိုရှင်ဟှူ လူလေဟှို ခေါ်လိုက်လေဟှယ်။ သူးနို့ဟှာ ကိုယ်တော်နားဟှို လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ကိုယ်တော်ဟှ ဆယ့်နှေ့ပါးဟှို ဝီးလိုက်ဘီး တမန်တော်လေ ဆိုဘီး ခေါ်လေဟှယ်။ ကိုယ်တော်ဟှ “နန်းနို့လေဟှို ငါ့နတူးဒူရှိဟှို့တွပ် ဝီးကော့‑က်ဟှားဟှယ်။ နန်းနို့လေဟှို ကြေညာဟှို့တွပ်လည်း ငါလွှတ်မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","နတ်ဆိုးလေဟှို နှန်ထုနိုင်ဟှူ ခွမ့်အာဏာဟှိုလည်း ငါပေးမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ကိုယ်တော် ဝီးကော့‑က်ဟှားဟှူ ဆယ့်နှေ့ပါးဟှ ပေတရု ဆိုဘီး ယေရှုဟှ နာမယ်ပေးဟှားဟှူ ရှိမုန်၊ ");
INSERT INTO tvn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ဇေဗေဒဲရဲ့ သားနှေ့ယော့က်ဖြစ်ဟှူ ယာကုပ်န သူ့ညီယောဟန် (မိုးကြိုးရဲ့ သားလေ ဆိုဘီး ဓိပါယ်ရှိဟှူ ဗောနေရဂတ် ဆိုဘီး ယေရှုဟှ နာမယ်ပေးဟှားဟှယ်)၊ ");
INSERT INTO tvn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","အန္ဒြေ၊ ဖိလိပ္ပု၊ ဗာသောလမဲ၊ မဿဲ၊ သောမ၊ အာလဖဲရဲ့သား ယာကုပ်၊ သဒ္ဒဲ၊ မျိုးရှစ်စိ အားထတ်သန်ဟှူ ရှိမုန်န၊ ");
INSERT INTO tvn_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ယေရှုဟှို သစ်စာဖော့‑က်ဟှူ ယုဒရှကာရုတ် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","အယ်ဘီးန ယေရှုဟှ အီဟှို ပ္လန်ဟှားဟှယ်။ လူအောက်ဂီးဟှာ ပ္လန်ဘီးဟှာ စုလာဂေ့ဟှူကြောန့် ယေရှုန တဗဲ့တော်လေဟှ စာစားဟှို့ခီ မှေ့ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","လူလေဟှ “ကိုယ်တော်ဟှာ စိဖော့‑က်ပ္လန်ဟှားဘီ” ဆိုဘီး ပြောနေဂေ့ဟှူကြောန့် ကိုယ်တော်ရဲ့ မိသားစုဟှာ အယ်ကြောန်းဟှို ကြားဟှူ ခီမာ သူးနို့ဟှာ ကိုယ်တော့်ဟှို ထီးသီးဟှို့တွပ် လိုက်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ယေရုရှလင်ဗြို့ဟှနေ ရော့‑က်လာဟှူ ကျမ်းတတ်ဆရာလေ တချို့ဟှ “ကိုယ်တော်ဟှာ ဗေလဇေဗုလနတ် ပူးနေဟှယ်! နတ်ဆိုးမန်းဟှ ပေးဟှားဟှူ တဂိုးအားဖြင့် နတ်ဆိုးလေဟှို နှန်ထုဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","အယ်ကြောန့် ယေရှုဟှာ သူးနို့လေဟှို ခေါ်ဘီးဟှာ ဥပမာဆောန်ဘီး ပြောလိုက်ဇာဟှ “စာတန်ဟှ စာတန်ဟှို ဖယ်မျိုး နှန်ထုနိုင်ဟှို့နူး။ ");
INSERT INTO tvn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","နိုင်ငံတနိုင်ငံဟှာ အောက်စု တစုနတစု တိုက်ခိုက်ဘီး ကွဲပြားနေမယ် ဆိုဟှာ အယ်နိုင်ငံဟှာ ဖယ်မျိုးလည်း ရပ်တည်နိုင်ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","အီသူအီသားလေဟှာလည်း အောက်စု တစုနတစု တိုက်ခိုက်ဘီး ကွဲပြားနေမယ် ဆိုဟှာ အယ်မိသားစုဟှာ ဖယ်မျိုးလည်း ရပ်တည်နိုင်ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","အယ်မျိုးဘဲ့ စာတန်ရဲ့ နိုင်ငံဟှာ အောက်စုလေ ကွဲပြားနေမယ် ဆိုဟှာ အယ်နိုင်ငံဟှာ ရပ်တည်နိုင်ဘဲန ပျစ်စီးဟှားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“ခွန်အားကီးဟှူ လူဟှို ရင်ဦးဆောင်း တောက်ဘဲန ဖယ်သူလည်း ခွန်အားကီးဟှူ လူရဲ့ အီဟှို ဝမ်ဘီးဟှာ သူ့အောက်စာလေဟှို လုယူနိုင်ဟှို့ မှုဟှ။ သူ့ဟှို တောက်ဘီးမှဘဲ့ သူ့ရဲ့ အီဟှို လုယူနိုင်မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ လူလေဟှာ သူးနို့ရဲ့ ပြစ်ရှိမျှန ဘုရားသခင်ဟှို စော်ကားပြောဆိုဇာလေ အားလောင်းတွပ် ခွမ့်လွှတ်ခံရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","အယ်ဘေမဲ့ ဖယ်သူဘဲ့ဖြစ်ဖြစ် သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို ပြစ်မှားဘီး ပြောဆိုမယ် ဆိုဟှာ လောင်းဝ ပြစ်လွှတ်လေ့မယ် မှုဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူဟှာ ထာဝရပြစ်ဟှို ကျူးလွန်ဟှူကြောန့် ဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ယေရှု အယ်မျိုး ပြောလိုက်ဇာဟှာ လူတချို့ဟှ “ကိုယ်တော်ထဲမာ ညစ်ညူးဟှူ နတ်ရှိနေဟှယ်” ဆိုဘီး ပြောနေဂေ့ဟှူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ယေရှုရဲ့ မိန ညီလေဟှာ ရော့‑က်လာဂေ့ဟှယ်။ သူးနို့ဟှာ အီပ္လန်မာ ရပ်နေဘီးဟှာ ကိုယ်တော့်ဟှို ခေါ်ဟှို့တွပ် ယော့‑က်ယော့‑က်ဟှို စေလွှတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","လူအောက်ဂီးဟှ ယေရှုရဲ့ ဘေးပတ်ပတ်လည်မာ ထိုင်နေဂေ့ဟှယ်။ သူးနို့ဟှ “ကိုယ်တော်ရဲ့ မိ၊ ညီလေန ညီမလေဟှ ပ္လန်မာရှိဟှယ်။ သူးနို့ဟှာ ကိုယ်တော့်ဟှို တွိရှင်နေဂေ့ဟှယ်” ဆိုဘီး ကိုယ်တော့်ဟှို လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ယေရှုဟှ “ငါ့မိဟှ ဖယ်သူနူး။ ငါ့ညီကိုလေဟှ ဖယ်သူနူး” ဆိုဘီး ပ္လန်ဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ကိုယ်တော်ဟှာ သူ့ပတ်ပတ်လည်မာ ထိုင်နေဟှူ လူလေဟှို ကေ့ဘီးဟှာ “အယ်လူလေဟှာ ငါ့မိ၊ ငါ့ညီ၊ ငါ့ညီမ ဖြစ်ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ဘုရားသခင်ရဲ့ လိုတော်ဟှို ဆောန်ဟှူလူဟှာ ငါ့ညီ၊ ငါ့ညီမန ငါ့မိဘဲ့ ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","နော့‑က်တခါ ယေရှုဟှ ဂါလိလဲအိုင်ဘေးမာ စဘီးဟှာ သွန်သန်လေဟှယ်။ ရရာတိုင်းများဟှူ လူအောက်ဂီးဟှာ ကိုယ်တော်နားမာ စုလာဂေ့ဟှူကြောန့် ကိုယ်တော်ဟှာ အိုင်ထဲမာရှိဟှူ လှေတစင်းထတ်မာ တတ်ထိုင်လိုက်ဟှယ်။ လှေဟှာ ရေပ္လန်မာ ရှိနေဟှူကြောန့် လူအောက်ဂီးဟှ ကမ်းခြေရေစပ်မာ ရှိနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ကိုယ်တော်ဟှ ပေါင်ဥပမာဆောန်ဘီးဟှာ ကြောန်းရာလေဘောင်ဂီးဟှို သွန်သန်ဘီး ပြောနေဇာဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“နားထောန်ဂေ့! မျိုးစေ့ကြဲမား တယော့‑က်ဟှာ မျိုးစေ့ကြဲဟှို့ ထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","မျိုးစေ့ကြဲလိုက်ဟှူ ခီမာ တချို့ စေ့လေဟှ လမ်းမာက္လဘီး ငှတ်လေဟှာ လာကော့‑က်စားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","တချို့ စေ့လေဟှ မ္လေဆီလွှာနဲဘီး က္လော့‑က်ခဲများဟှူ နေရာမာက္လလေဟှယ်။ မျိုးစေ့လေဟှာ မ္လေသားနဲဟှူကြောန့် ဗြန်းဗြန်ဟှား ပန်ပေါ့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","အယ်ဘေမဲ့ နေပူဟှူ ခီမာ ပြစ်စွဲဘဲကြောန့် ညှိုးဘီးဟှာ ခြော့‑က်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","တချို့ မျိုးစေ့လေဟှ ဆူးချောင်ထဲမာ က္လဟှားဘီး ဆူးဗန်လေဟှ ကီးလာဘီးဟှာ ပန်လေဟှို အောက်လိုက်ဟှူကြောန့် သီးလေဟှ သီးနိုင်ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","တချို့ စေ့လေဟှ ကောန်းဟှူမ္လေမာ က္လဟှူကြောန့် ပန်လေပေါ့‑က်လာဘီး ကီးလာဘီးဟှာ သီးနှံလေဟှာ တချို့ဟှ ဆသောင်းဆယ်၊ တချို့ဟှ ဆခြော့‑က်ဆယ်၊ တချို့ဟှ ဆတရာသီးလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","အယ်ဘီးန ယေရှုဟှ “နန်းနို့မာ နားရှိဟှယ် ဆိုဟှာ ကြားဂေ့!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ယေရှုတယော့‑က်ဒဲဘဲ့ ရှိဟှူ ခီမာ တဗဲ့တော် ဆယ့်နှေ့ပါးနတူးဒူ လိုက်လာဟှူလူလေဟှ ပေါင်ဥပမာရဲ့ ဓိပါယ်ဟှို မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ယေရှုဟှ “နန်းနို့လေဟှ ဘုရားသခင်ရဲ့ နိုင်ငံတော်နဆိုင်ဟှူ နတ်နဲဟှူ ကြောန်းရာလေဟှို သိခွမ့်ရှိဟှယ်။ အယ်ဘေမဲ့ ပ္လန်လူလေတွပ် ကြောန်းရာလေဟှို ပေါင်ဥပမာလေနဘဲ့ ဖော်ပြဂေ့ဟှယ်” ");
INSERT INTO tvn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ “‘သူးနို့လေဟှ ဗြင်းဗြင်ဟှီးန ဗြင်ဟှ။ သူးနို့လေဟှာ နားလည်းလည်ဟှီးန နားလည်ဂေ့ဟှ။ သူးနို့ဟှာ တကယ်ဗြင်ဘီးဟှာ နားလည်ဟှားမယ် ဆိုဟှာ သူးနို့ဟှာ ဘုရားသခင်ဖတ်ဟှို လှည့်ဟှားဟှူကြောန့် ကိုယ်တော်ဟှ သူးနို့ဟှို ခွမ့်လွတ်လေ့မယ်’ ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ယေရှုဟှ “နန်းနို့ဟှ အယ်ပေါင်ဥပမာဟှို နားလည်ဟှလော။ အယ်ဆိုဟှာ တခြားပေါင်ဥပမာလေဟှို ဖယ်မျိုး နားလည်နိုင်ဟှို့နူး။ ");
INSERT INTO tvn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","မျိုးစေ့ကြဲမားဟှ ဘုရားသခင်ရဲ့ စကားတော်ဟှို ကြဲလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","လူတချို့ဟှာ လမ်းထတ်မာက္လဟှူ မျိုးစေ့နတူဘီး သူးနို့ဟှာ တရားစကားဟှို ကြားဟှူ ခီမာ စာတန်ဟှ လာဘီးဟှာ အယ်မူတရားစကားဟှို နှုယူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","တချို့ လူလေဟှ က္လော့‑က်ခဲပေါဟှူ မ္လေမာက္လဟှူ မျိုးစေ့နတူဟှယ်။ သူးနို့လေဟှ တရားစကားဟှို ကြားဟှူ ခီမာ သူးနို့ဟှာ ဝန်းသာအားရ လတ်ခံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","အယ်ဘေမဲ့ တရားစကားဟှာ သူးနို့ထဲမာ ပြစ်စွဲဘဲန ရှစ်ဟှားဘဲ ခံလေဟှယ်။ အယ်မူတရားစကားကြောန့် ဒေါက်ခန နှိစစ်ညှဉ်းဆဲဇာလေ တွိရဟှူ ခီမာ သူးနို့လေဟှ ရှစ်ရှင်းဘဲ့ ဖော့‑က်ပ္လန်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","တခြားလူလေဟှ ဆူးချောင်မာက္လဟှူ မျိုးစေ့နတူဟှယ်။ သူးနို့လေဟှ တရားစကားဟှို ကြားရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","အယ်ဘေမဲ့ ဘဝရဲ့ စိုးရိမ်ရှင်းလေ၊ စည်းဇိမ်အောက်စာရဲ့ လှည့်ဇားရှင်းလေန တခြားတပ်မတ်ရှင်းလေ ဝမ်လာဘီး အယ်မူတရားစကားဟှို လွှမ်းမိုးလိုက်ဟှူကြောန့် တရားစကားဟှာ ဖယ်မျိုးလည်း သီးဟှို သီးနိုင်ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","တချို့ လူလေဟှ ကောန်းဟှူမ္လေမာက္လဟှူ မျိုးစေ့နတူဟှယ်။ သူးနို့ဟှ တရားစကားဟှို ကြားဘီး လတ်ခံဟှူကြောန့် တချို့ဟှ ဆသောင်းဆယ်၊ တချို့ဟှ ဆခြော့‑က်ဆယ်၊ တချို့ဟှ ဆတရာ သီးသီးလာဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ယေရှုဟှ “ဖယ်လူဟှ ဆီမီးအီဟှို ယူလာဘီးဟှာ တောန်းအော့‑က်မာ ထားဟှားမယ်နူး။ ကဒန်အော့‑က်မာ ထားဟှားမယ်နူး။ အယ်မျိုးထားမယ့်စား အယ်ဇာဟှို ဆီမီးခေါင်ထတ်မာ ထားဟှားရမယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ဝှပ်ဟှားဟှူဇာလေ ဂူလောင်း ပေါ်လာလေ့မယ်။ ဖောင်းဟှားဟှူဇာလေ ဂူလောင်းဟှာလည်း ပွမ့်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","နန်းနို့မာ နားရှိဟှယ် ဆိုဟှာ ကြားဂေ့!” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","အယ်ခီမာ ယေရှုဟှာ “နန်းနို့ ကြားရဇာလေဟှို ဂရုစိုက်ဘီးဟှာ နားထောန်ဂေ့! နန်းနို့ဟှာ သူများလေဟှို ပေးဟှူ ပမာဏတိုင်း ဘုရားသခင်ဟှ နန်းနို့ဟှို ပေးလေ့မယ်။ ပိုဘီး ဟှာ ပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ရှိဟှူလူဟှို ထပ်ပေးဘီး သူ့ဟှို ကြွယ်ဝစေလေ့မယ်။ မှေ့ဘဲဟှူ လူနားဟှ ရှိဟှူမျှဟှို နှုလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ယေရှုဟှ ဆစ်ဘီးဟှာပြောဇာဟှ “ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှာ သူ့ရဲ့လယ်ထဲမာ မျိုးစေ့ကြဲဟှူ လူတယော့‑က်နတူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","သူဟှ ညခီမာ အိလိုက်၊ နေ့ခီမာ နိုးနေဒူးမာ၊ မျိုးစေ့လေ ဂူလောင်းဟှာ ပန်ပေါ့‑က်လာဘီး ကီးလာဟှယ်။ အယ်ဘေမဲ့ အယ်ဇာ ဖယ်မျိုးဖြစ်လာဟှယ် ဆိုဇာဟှို အယ်လူဟှာ သိဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","မ္လေဂီးဟှ သူ့လိုလို ပန်လေဟှို ကီးစေဘီး သီးသီးလာဇာဟှ ဦးဆောင်းမာ ညွှန့်ထွပ်လာဟှယ်။ အယ်ဘီးန ဗားနှံ နော့‑က်ဆောင်းမာ နှံထဲမာ အောန်ဟှူဆန်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ဗားနှံလေ မှည့်ဟှူ ခီမာ ဗားရိခီ ရော့‑က်လာဟှူကြောန့် အယ်လူဟှ ဗားဟှို စဘီးဟှာ ဇင်နရိဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ယေရှုဟှ “ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှာ ဖြားဇာနတူဟှယ် ဆိုဘီး နို့လေဟှ ပြောရမယ်နူး။ ဖယ်မျိုးပေါင်ဥပမာဟှို သောင်းပြုဘီး အယ်ဇာဟှို နို့လေဟှ ရှင်းပြရဟှို့နူး။ ");
INSERT INTO tvn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","အယ်ဇာဟှ မုညင်းစေ့နတူဟှယ်။ လူတယော့‑က်ဟှာ ကမ္ဘာမာ ငယ်ဆောင်းစေ့ဟှို ယူဘီးဟှာ မ္လေဂီးမာ စိုက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","အယ်ဘေမဲ့ အယ်ပန်ဟှာ ကီးလာဟှူ ခီမာ သီးနှံပန်လေ ဂူလောင်းထဲမာ ကီးဆောင်းဖြစ်လာဟှယ်။ ကိုင်းခတ်ကီးလေလည်း ထွပ်လာဘီး ကောန်းဂန်ဟှ ငှတ်လေဟှာ လာဘီး အယ်ပန်ရဲ့ရိမာ သူးနို့ရဲ့သိုက်ဟှို လောက်ဂေ့ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ယေရှုဟှာ အယ်မျိုး တခြား ပေါင်ဥပမာ ဘောင်ဂီးဟှို သောင်းပြုဘီး သူးနို့ဟှို တရားစကားဟှို ဟောလေဟှယ်။ အယ်လူလေ နားလည်နိုင်အောန် ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ကိုယ်တော်ဟှာ ပေါင်ဥပမာလေ သောင်းဘဲန သူးနို့ဟှို ဟောတော်မူဟှ။ အယ်ဘေမဲ့ ကိုယ်တော်ဟှာ တဗဲ့တော်လေနတူးဒူ သီးသန့်ရှိနေဟှူ ခီမာ ကိုယ်တော်ဟှာ ဂူလောင်းဟှို သူးနို့ဟှို ရှင်းပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","အယ်နေ့ နေဒန်ဇာမာ ယေရှုဟှ “အိုင်ရဲ့ ဟှို့ဖတ်ကမ်းဟှို ကူးဂေ့ဇို့” ဆိုဘီး တဗဲ့တော်လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","အယ်ကြောန့် သူးနို့ဟှာ လူအောက်ဂီးဟှို ထားရစ်ဘီးဟှာ တဗဲ့တော်လေဟှာ လှေထတ်မာထိုင်နေဟှူ ယေရှုဟှို သူးနို့နတူးဒူ ခေါ်ဟှားဂေ့ဟှယ်။ အယ်နေရာမာ တခြားလှေလေလည်း ကိုယ်တော်နတူးဒူ လိုက်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ရောက်တရစ် ပြင်းထန်ဟှူ လေမှောန်တိုင်းက္လလာဘီး လှိုင်းလေဟှာ လှေဟှို စဘီးဟှာ ရိုက်လေဟှယ်။ အယ်ကြောန့် လှေဟှာ ရေနပ္လဲ့ခါနီးနီး ဖြစ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ယေရှုဟှ လှေရဲ့ပဲ့မာ ခေါန်းအောင်း အောင်းဘီး အိနေဟှယ်။ တဗဲ့တော်လေဟှ ကိုယ်တော့်ဟှို နှိုးဂေ့ဘီး “ဆရာ၊ ကျွန်တော့်ဟှားလေ သေဟှို့ဖြစ်နေဂေ့ဇာဟှို ကိုယ်တော် ဂရုစိုက်ဘဲနနေဟှို့လော” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ယေရှုဟှ ထလာဘီးန လေနလှိုင်းဟှို မိန့်မှာဟှူ ခီမာ လေနလှိုင်းလည်း ငြီဟှားဘီး သာယာဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","အယ်ဘီးန ယေရှုဟှ တဗဲ့တော်လေဟှို “ဖြားဖြစ်ကြောန့် နန်းနို့လေ ကြော့‑က်နေဂေ့နူး။ ခုထတ်ထိ နန်းနို့လေဟှ ယောင်ကြည်ရှင်း မှေ့သေးဟှလော” ဆိုဘီး မေးမြန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","အယ်ဘေမဲ့ သူးနို့လေဟှ ရရာတိုင်း ကြော့‑က်နေဂေ့ဘီး “အယ်လူဟှ ဖယ်သူနူး။ လေနလှိုင်းလေတောန်မှ သူ့ဟှို နားထောန်ဂေ့ဟှယ်!” ဆိုဘီး သူးနို့ရှင်းရှင်း စဘီးဟှာ ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ယေရှုန တဗဲ့တော်လေဟှာ ဂါလိလဲအိုင်ရဲ့ ဟှို့ဖတ်ကမ်းမာရှိဟှူ ဂါဒရဒေသဟှို ရော့‑က်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ယေရှုဟှ လှေထဲဟှ ထွပ်လာဟှူ ခီမာ လူတယော့‑က်ဟှာ သန်းခ္လိုင်းထဲဟှနေ ထွပ်လာဘီး ကိုယ်တော့်ဟှို တွိဆောင်လေဟှယ်။ အယ်လူဟှာ ညစ်ညူးဟှူနတ် ဝမ်ပူးနေဘီး ");
INSERT INTO tvn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","သန်းခ္လိုင်းဂူလေ ကြားမာနေဟှယ်။ ဖယ်သူလဲ သူ့ဟှို တောက်နိုင်ဂေ့ဟှ။ သံကြိုးနဟှိုမှ ခယ်ဟှားနိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","သူ့ရဲ့ ခေလေနလတ်လေဟှို ခါဘီးခါ ခယ်ဖူးဂေ့ဟှယ်။ အယ်ဘေမဲ့ သူဟှာ ခီတိုင်း သံကြိုးလေဟှို ဆွဲဖြတ်ဘီး ခေရှင်းလေဟှိုလည်း ဆွဲဖ္လဲလေဟှယ်။ သူဟှာ ရရာတိုင်း ခွန်အားကီးဟှူကြောန့် ဖယ်သူလည်း ထီးချောက်နိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","နေ့ရောညဉ့်ရော သူဟှာ သန်းခ္လိုင်းဂူကြားလေန တောန်ဂူးထပ်လေမာ ရှော့‑က်သွားနေဘီး၊ အော်ဘီးဟှာ သူ့ကိုယ်သူ ထတ်ဟှူက္လော့‑က်တောင်းလေန လှီးဖြတ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","သူဟှာ ယေရှုဟှို ဝီးဟှနေ ဗြင်ဟှူ ခီမာ ပ္လေးလာဘီးဟှာ ကိုယ်တော်ရဲ့ ခေတော်ရင်းမာ ပ္လားပ္လားပျပ်ဝပ်ဘီး ");
INSERT INTO tvn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“ဗြစ်ဆောင်းဖြစ်ဟှူ ဘုရားသခင်ရဲ့ သားတော်ယေရှု! ကိုယ်တော်ဟှာ ကျွန်တော့်န ဖြားဆိုင်ကြောန့်နူး။ ကျွန်တော့်ဟှို ညှဉ်းဆဲပါန ဘုရားသခင်ဟှို အားကိုးဘီးဟှာ ကိုယ်တော့်ဟှို ကျွန်တော်တောန်းဗန်ဟှယ်!” ဆိုဘီး သံက္လယ်ဂီးန လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","သူအယ်မျိုးပြောဇာဟှာ ယေရှုဟှ “ညစ်ညူးဟှူနတ်၊ အယ်လူထဲဟှနေ ထွပ်ဟှား!” ဆိုဘီး ပြောဟှားဟှူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ယေရှုဟှ “နန်းနို့နာမယ် ဖြားမျိုးခေါ်နူး” ဆိုဘီး မေးလိုက်ဟှယ်။ အယ်လူဟှ “ကျွန်တော့်လေဟှ ဘောင်ဂီးဖြစ်ဟှူကြောန့် ‘လေဂေါင်၊’ ‘လူအောက်ဂီး’ ဆိုဘီး ခေါ်ဂေ့ဟှယ်!” ဆိုဘီး ယေရှုဟှို ပ္လန်ပြောလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ညစ်ညူးဟှူနတ် ပူးနေဟှူသူဟှာ နတ်ဆိုးလေဟှို အယ်နယ်ဟှနေဘီးဟှာ နှန်ထုဘဲနေဟှို့တွပ် ယေရှုဟှို တောန်းဗန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","အယ်ခီမာ တောန်ဂူးထတ်မာ ဝပ်အောက်ဂီးဟှာ စာစားနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","နတ်ဆိုးလေဟှလည်း “ကျွန်တော့်လေဟှို အယ်ဝပ်လေထဲဟှို စေလွှတ်ပေးပါ။ သူးနို့ထဲဟှို ဝမ်ခွမ့်ပေးပါ” ဆိုဘီး ယေရှုဟှို တောန်းဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ယေရှုဟှ ခွမ့်ပေးလိုက်ဟှူကြောန့် ညစ်ညူးဟှူ နတ်လေဟှ ထွပ်ဟှားဘီး ဝပ်လေထဲဟှို ဝမ်ဂေ့လေဟှယ်။ ၂,၀၀၀ လော့‑က်ရှိဟှူ ဝပ်အောက်ဂီးဟှာ အိုင်ကမ်းနားဟှို ပ္လေးဆင်းဟှားဘီး ရေမ္လောက်ဘီးဟှာ သေဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ဝပ်ထီးမားလေဟှ ထွပ်ပ္လေးဟှားဘီး ဗြို့န တောဝါလေနှံ့ အယ်ဒန်းဟှို လိုက်ပြောဂေ့ဟှယ်။ လူလေဟှာ ဖြားဇာလေ ဖြစ်ဟှားဟှယ် ဆိုဇာဟှို ကေ့ဟှို့ ထွပ်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","သူးနို့လေဟှ ယေရှုနားဟှို ရော့‑က်လာဟှူ ခီမာ သူးနို့လေဟှာ လေဂေါင်နတ်ဆိုးလေ ပူးခံရဟှူလူဟှို တွိဟှားလေဟှယ်။ အယ်လူဟှာ ဝတ်ဟှို ဝတ်ဟှားဘီး ပေါင်မှန်စိန အယ်နေရာမာ ထိုင်နေဟှူကြောန့် သူးနို့လေ ဂူလောင်းဟှာ ကြော့‑က်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","အယ်ဇာဟှို ဗြင်ဟှားဘီးဟှူ လူလေဟှ နတ်ဆိုးပူးနေဟှူ လူမာ ဖြားမျိုးဖြစ်ဟှားဇာန ဝပ်လေရဲ့ ကြောန်းဟှို အယ်လူလေဟှို ပြောပြဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","အယ်ကြောန့် သူးနို့ဟှာ သူးနို့ရဲ့ နယ်ဟှနေ ထွပ်ဟှားဟှို့တွပ် ယေရှုဟှို တောန်းဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ယေရှုဟှာ လှေထတ်ဟှို တတ်နေဒူးမာ နတ်ဆိုးပူးဖူးဟှူ လူဟှ “ကျွန်တော့်ဟှို ကိုယ်တော်နတူးဒူ သွားခွမ့်ပေးပါ!” ဆိုဘီး ကိုယ်တော့်ဟှို တောန်းဗန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","အယ်ဘေမဲ့ ယေရှုဟှ သူ့ဟှို လိုက်ခွမ့်ပေးဟှ။ အယ်မျိုးလိုက်ခွမ့်ပေးမယ့်စား ကိုယ်တော်ဟှ “နန့်ရဲ့ မိသားစုနားဟှို ပ္လန်သွားဘီး ဘုရားသခင်ဟှာ နန့်တွပ် ဖယ်မျှလော့‑က် လောက်ဆောန်ပေးဟှားဇာန နန့်ဟှို ဖယ်မျှသနားတော်မူကြောန်းဟှို သူးနို့လေဟှို ပြောပြပါ” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","အယ်ကြောန့် အယ်လူဟှ ထွပ်ဟှားဘီး ယေရှုဟှ သူ့တွပ် ဖြားဇာလေ လောက်ပေးဟှားဟှယ် ဆိုဇာဟှို ဒေကာပေါလိနယ်မာ စဘီးဟောပြောလေဟှယ်။ အယ်ကြောန်းဟှို ကြားရဟှူလူလေ ဂူလောင်းဟှာ အံ့ဩဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ယေရှုဟှ အိုင်ရဲ့ ဟှို့ဖတ်ကမ်းဟှို လှေန ပ္လန်ကူးဟှားလေဟှယ်။ အိုင်ဘေးနားမာ လူအောက်ဂီးဟှာ ကိုယ်တော်ပတ်လည်မာ စုလာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ယာဣရု နာမယ်ရှိဟှူ ဝါလယ်ဇရပ်မှူး တယော့‑က်ဟှ ရော့‑က်လာဘီးဟှာ ယေရှုဟှို ဗြင်ဟှူ ခီမာ သူဟှာ ကိုယ်တော့်ခေရင်းမာ ဒူးထော့‑က်ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“ကျွန်တော့်သမီးငယ်ဟှ သေခါနီး ဖြစ်နေဟှယ်။ ကြွလာဘီးဟှာ သူ့ထတ်မာ ကိုယ်တော်ရဲ့ လတ်ဟှို တန်တော်မှုပါ၊ အယ်ဆိုဟှာ သူဟှာ ကျန်းမာဘီး သတ်ရှင်လေ့မယ်!” ဆိုဘီး နူးညွတ် တောန်းဗန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","အယ်ဆိုန ယေရှုဟှ သူ့နတူးဒူ လိုက်ဟှားဟှယ်။ လူလေဘောင်ဂီးဟှ ယေရှုနတူးဒူ လိုက်လာဟှူကြောန့် သူးနို့ဟှာ ဘေးပတ်ပတ်လည်ဟှနေ ကိုယ်တော့်ဟှို တိုးဝှေ့နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","အယ်နေရာမာ ဆယ့်နှေ့နှစ် လောင်းလောင်း သွီးသွန်ရောဂါဟှို ပြင်းပြင်းထန်ထန် ခံစားနေရဟှူ မီးမတယော့‑က်ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","သူဟှာ ဆရာဝန်လေ ဘောင်ဂီးနလည်း ကုသဟှားပီးဘီ။ သူ့ရဲ့ကပ်လေ ဂူလောင်းလည်း ကူဟှားဘေမဲ့ သတ်သာလာဟှို့ နေနေသာသာ ရောဂါဟှ ပိုဘီး ဆိုးလာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","အယ်မီးမဟှာ ယေရှုကြောန်းဟှို ကြားဟှားလေဟှယ်။ အယ်ကြောန့် ဝတ်ဟှို တို့ဟှို့တွပ် ကိုယ်တော်နော့‑က်ဟှ လူအောက်ဂီးထဲဟှို ရော့‑က်လာဘီး ");
INSERT INTO tvn_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“ငါဟှာ ကိုယ်တော့်ဝတ်ဟှို တို့လိုက်မယ် ဆိုဟှာ ငါ့ဟှာ ကျန်းမာဟှားလေ့မယ်။” ဆိုဘီး သူ့ကိုယ်သူ ပြောနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","သူဟှာ ကိုယ်တော်ရဲ့ ဝတ်လောင်ဟှို တို့လေဟှယ်။ တို့လိုက်ဟှူန သူ့ရဲ့ သွီးသွန်နေဇာလေဟှာ ရှစ်ရှင်းဘဲ့ ရပ်ဟှားဘီး၊ သူဟှာ ရောဂါပျော့‑က်ဟှားဘီ ဆိုဇာဟှို သူ့ကိုယ်ထဲမာ ခံစားရနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ရှစ်ရှင်းဘဲ့ ယေရှုဟှာ သူ့ကိုယ်ဟှ တဂိုးထွပ်ဟှားဇာဟှို သိဟှားကြောန့် လူအောက်ဂီးဖတ်ဟှို လှည့်ဘီးဟှာ “ငါ့ဝတ်ဟှို ဖယ်သူတို့နူး” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","တဗဲ့တော်လေဟှ “လူလေဟှ ကိုယ်တော့်ဟှို တိုးဝှေ့နေဇာဟှို ဗြင်းဗြင်ဟှိန၊ ‘ငါ့ဟှို ဖယ်သူတို့ဟှယ်နူး’ ဆိုဘီး ခုထိ ကိုယ်တော်ဟှာ မေးနိုင်သေးဟှယ်” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","အယ်ဘေမဲ့ ယေရှုဟှာ အယ်ဇာဟှို ဖယ်သူလောက်ဟှယ် ဆိုဇာဟှို ဗြင်ဟှို့တွပ် ပတ်ပတ်လည်ဟှို ကေ့နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","အယ်မီးမဟှ သူ့မာ ဖြားမျိုးဖြစ်ဟှားဇာဟှို သိနားလည်ဟှားဟှယ်။ အယ်ကြောန့် သူဟှာ ကြော့‑က်ကြော့‑က်လန့်လန့်န ကိုယ်တော့်ခေရင်းမာ ဒူးထော့‑က်ဘီးဟှာ မှန်တိုင်းပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ယေရှုဟှ “ငါ့သမီး၊ နန့်ရဲ့ ယောင်ကြည်ရှင်းဟှာ နန့်ဟှို ကျန်းမာစေဘီ။ ငြီသတ်ဘီးသွားပါ၊ နန့်ရဲ့ ဝေဒနာဟှနေ လွှတ်မြော့‑က်စေ” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","အယ်မျိုးပြောနေဒူးမာ ဝါလယ်ဇရပ်မှူးရဲ့ အီဟှ တမန်တချို့ဟှာ ရော့‑က်လာဘီး “ကိုယ်တော်ရဲ့ သမီးဟှာ သေဟှားဘီ။ ဖြားဖြစ်ကြောန့် ဆရာဟှို နှော့‑က်ယှစ်နေသေးနူး” ဆိုဘီး သူးနို့ဟှ ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ယေရှုဟှ သူးနို့ဖြားဇာဘဲ့ပြောပြော ဂရုစိုက်ဟှ။ အယ်ဘေမဲ့ “ကြော့‑က်န။ ယောင်ကြည်ပါ” ဆိုဘီး ဝါလယ်ဇရပ်မှူးဟှို ပြောလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","အယ်ဘီးန ပေတရု၊ ယာကုပ်န သူ့ညီ ယောဟန်ဟှိုဘဲ့ ခေါ်ဘီးဟှာ တခြားဖယ်သူ့ဟှို့လည်း လိုက်ခိုင်းဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","သူးနို့ဟှာ ဝါလယ်ဇရပ်မှူးရဲ့ အီဟှို ရော့‑က်ဟှူ ခီမာ ယေရှုဟှာ အောက်အောက်သဲသဲ ဖြစ်နေဇာလေဟှို ဗြင်ဟှားဘီး သူးနို့လေ ဂူလောင်းဟှာ သံက္လယ်ဟှီး အော်ဘီး ငိုနေဇာလေဟှို ကြားရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ကိုယ်တော်ဟှာ အီထဲဟှို ဝမ်ဟှားဘီး “ဖြားဖြစ်ကြောန့် နန်းနို့လေဟှ အယ်မျိုး အောက်အောက်သဲသဲ လောက်နေဂေ့နူး။ ဖြားဖြစ်ကြောန့်နန်းနို့လေဟှာ ငိုနေရဟှယ်နူး။ အယ်မီးမဂန်းဟှား သေနေဇာ မှုဟှ။ သူမဟှာ အိမွိနေဇာဖြစ်ဟှယ်!” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","အယ်လူလေဟှ ကိုယ်တော့်ဟှို ရယ်ဇားဂေ့ဟှယ်။ အယ်ကြောန့် ကိုယ်တော်ဟှာ သူးနို့လေ ဂူလောင်းဟှို ပ္လန်ဟှို ထွပ်ခိုင်းဘီးဟှာ မီးမဂန်းဟှားရဲ့ မိဖလေန ကိုယ်တော်နတူးဒူ ပါလာဟှူ တဗဲ့တော် သောင်းပါးဟှို ခေါ်ဘီး မီးမဂန်းဟှား ထားဟှားဟှူ နေရာဟှို သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ကိုယ်တော်ဟှာ သူ့ရဲ့လတ်ဟှို ကိုင်ဘီးဟှာ “တလိသ ကုမိ” ဆိုဘီး သူ့ဟှို ပြောလေဟှယ် “မီးမငယ်၊ နန့်ဟှို ငါပြောမယ်၊ ထလိုက်!” ဆိုဘီး ဓိပါယ်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ရှစ်ရှင်းဘဲ့ သူဟှ ထဘီးဟှာ စဘီး ပတ်ပတ်လည် လမ်းရှော့‑က်လေဟှယ်။ (သူဟှ သတ် ဆယ့်နှေ့နှစ်ရှိဟှယ်။) အယ်မျိုး ဖြစ်ပျစ်ဟှားဟှူ ခီမာ သူးနို့လေ ဂူလောင်းဟှာ ရရာတိုင်း အံ့ဩဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","အယ်ဘေမဲ့ ယေရှုဟှာ ဖယ်သူ့ဟှိုလည်း ပြောဘဲဟှို့တွပ် သူးနို့ဟှို တင်းတင်းကျပ်ကျပ်ဟှား မိန့်ပေးလိုက်ဟှယ်။ အယ်ဘီးဟှာ “သူ့ဟှို စားဟှို့တွပ် တခုခုပေးလိုက်ပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ယေရှုဟှ အယ်နေရာဟှနေ ထွပ်ဟှားဘီးန သူ့ဗြို့ဟှို ပ္လန်ဟှားလေဟှယ်။ ကိုယ်တော်ရဲ့ တဗဲ့တော်လေလည်း လိုက်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ဒန်းနေ့မာ ကိုယ်တော်ဟှာ ဝါလယ်ဇရပ်မာ စဘီးဟှာ သွန်သန်လေဟှယ်။ အယ်နေရာမာ လူလေဘောင်ဂီး ရှိနေဘီး ကိုယ်တော် သွန်သန်ဇာလေဟှို လူလေဟှကြားရခီမာ ရရာတိုင်း အံဩဂေ့ဟှယ်။ “အယ်ဇာလေ ဂူလောင်းဟှို သူဟှာ ဖယ်နေရာဟှ ရဟှားနူး” ဆိုဘီး သူးနို့ဟှာ မေးလေဟှယ်။ “သူ့ဟှို ပေးဟှားဟှူပညာဟှ ဖယ်မျိုးပညာနူး။ သူဟှာ အယ်နိမိတ်လတ်ခဏာလေဟှို ဖယ်မျိုးလောက်နူး။ ");
INSERT INTO tvn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","သူဟှာ လတ်သမား မှုဟှလော။ မာရိရဲ့သား၊ ယာကုပ်၊ ယောသေ၊ ယုဒန ရှိမုန်လေရဲ့နောန် မှုဟှလော။ သူ့ညီမလေဟှ အယ်နားမာဘဲ့ နေဂေ့ဟှယ် မှုဟှလော။” အယ်ကြောန့် သူးနို့လေဟှာ ကိုယ်တော့်ဟှို ငြင်းပယ်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ယေရှုဟှလည်း သူးနို့ဟှို “ပရောဖက်လေဟှာ သူးနို့ရဲ့ ဗြို့၊ သူးနို့ရဲ့ ရွှေမျိုးလေန သူးနို့ရဲ့ အီသူအီသားလေဟှ လွဲဘီး နေရာတိုင်းမာ လေးစားခံရဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ကိုယ်တော်ဟှာ အယ်ဗြို့မာ ကျန်းမာဘဲ့ဟှူ လူတချို့ထတ်မာ ကိုယ်တော်ရဲ့ လတ်လေဟှို တန်ဘီးဟှာ သူးနို့ဟှို ကျန်းမာစေဇာဟှလွဲဘီး ဖြာနိမိတ်လတ်ခဏာလေလည်း လောက်နိုင်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ကိုယ်တော်ဟှာ ရရာတိုင်း အံ့ဩဟှားဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်လူလေဟှာ ယောင်ကြည်ဘဲကြောန့် ဖြစ်ဟှယ်။ အယ်ဘီးန ယေရှုဟှာ အယ်နေရာဟှ ဝါလေဟှို လှည့်လည်သွားဘီးဟှာ လူလေဟှို သွန်သန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ကိုယ်တော်ဟှာ တဗဲ့တော် ဆယ့်နှေ့ပါးဟှို တူးဒူခေါ်ဘီးဟှာ နှေ့ယော့‑က်စီ တွဲခိုင်းဘီး သူးနို့ဟှို စေလွှတ်လေဟှယ်။ ကိုယ်တော်ဟှာ သူးနို့ဟှို ညစ်ညူးဟှူနတ်လေဟှို နိုင်ရဟှူ ခွမ့်အာဏာဟှိုလည်း ပေးဘီး ");
INSERT INTO tvn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“ခရီးတွပ် နန်းနို့နတူးဒူ တောန်အူးတခုဟှလွဲဘီး တခြားဇာလေ ယူဂေ့န။ စားဇာ၊ လွယ်အိ၊ နန်းနို့ရဲ့ ခါးဗတ်လေထဲမာ ကပ်လေဟှို ထဲ့ဆောန်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ခေနပ်လေဟှို စီးဂေ့ပါ၊ အယ်ဘီးဟှာ အန်းဂီပိုတထည်ဟှိုလည်း ယူဆောန်ဂေ့န။” ");
INSERT INTO tvn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ကိုယ်တော်ဟှ “ဖယ်နေရာမဆို နန်းနို့လေဟှို လတ်ခံဟှူအီမာ နန်းနို့လေဟှာ အယ်နေရာဟှ ထွပ်ခန်ထိ အယ်အီမာဘဲ့ တည်းနေဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","နန်းနို့လေဟှာ ဗြို့တဗြို့ဟှို ရော့‑က်လာဘီး အယ်ဗြို့ဟှ လူလေဟှာ နန်းနို့လေဟှို လတ်ခံဟှ အယ်မျိုးမှုဘဲနေဟှာ နန်းနို့လေဟှို နားထောန်ဂေ့ဟှဆိုဟှာ၊ နန်းနို့ခေဖွားဟှ မ္လေမုဟှို ခါခ္လဘီးဟှာ ထွပ်ဟှားဂေ့။ အယ်ဇာဟှာ သူးနို့တွပ် သတ်သေတခု ဖြစ်ဟှယ်!” ဆိုဘီး သူးနို့ဟှို မိန့်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","အယ်ကြောန့် သူးနို့ဟှာ ထွပ်ဟှားဘီး လူလေ နောန်ဒရဟှို့ကြောန်းဟှို ဟောပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","သူးနို့ဟှာ နတ်ဆိုးလေဘောင်ဂီးဟှို နှန်ထုဂေ့ဟှယ်။ အယ်ဘီးဟှာ ကျန်းမာဘဲဟှူ လူလေဘောင်ဂီးဟှို ဆီန လူးဘီးဟှာ သူးနို့ဟှို ကျန်းမာစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","အယ်ခီမာ အယ်ကြောန်း ဂူလောင်းဟှို ဟေရုဒ်မန်းဂီးဟှာ ကြားဟှားဘီ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ယေရှုရဲ့ နာမယ်ဟှ နေရာတိုင်းဟှို ပ္လံ့နှံ့ဟှားလေဟှယ်။ လူတချို့ ပြောနေဇာဟှ “ဗတ္တိဇံယောဟန်ဟှာ သေရာဟှနေ ထမြော့‑က်ဟှားဘီ! အယ်ကြောန့် သူဟှာ နိမိတ်လတ်ခဏာလေ ပြဟှိုတွပ် အယ်မျိုးတဂိုး ရှိနေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","အယ်ဘေမဲ့လည်း တခြားလူလေ ပြောဇာဟှ “သူဟှာ ဧလိယဖြစ်ဟှယ်။” တခြားလူလေ ပြောဇာဟှ “သူဟှာ ရှေးဟှ ပရောဖက်လေ တပါးပါးမျိုးဘဲ့ ပရောဖက်တပါးဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ဟေရုဒ်ဟှ ကြားရဟှူ ခီမာ သူဟှ “အယ်လူဟှာ ဗတ္တိဇံယောဟန် ဖြစ်ဟှယ်! ငါဟှာ အယ်လူရဲ့ ခေါန်းဟှို ဖြတ်လိုက်ပီးဘီဘဲ့။ အယ်ဘေမဲ့ အယ်လူဟှာ သေရာဟှနေ ထမြော့‑က်ဟှားဘီ!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ဟေရုဒ် ကိုယ်တိုင်ဘဲ့ ယောဟန်ဟှို ဖမ်းဆီးဟှို့ မိန့်ထုဟှားကြောန့် သူ့ဟှို တောက်နှောင်ဘီး ထောန်ထဲမာ ထားဟှားလေဟှယ်။ ဟေရုဒ်ဟှာ အယ်မျိုးလောက်ဇာဟှ သူ့ညီ ဖိလိပ္ပုရဲ့ မယား၊ ဟေရောဒိဟှို ယူဟှားဟှူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဗတ္တိဇံယောဟန်ဟှ ဟေရုဒ်ဟှို “နန်ဟှာ နန့်ညီရဲ့ မယားဟှို ယူဇာဟှာ ပညတ်တော်န ညီဟှ!” ဆိုဘီး ပြောဟှားကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","အယ်ကြောန့် ဟေရောဒိဟှာ ယောဟန်ဟှို ရန်ငြိုးထားဘီးဟှာ သတ်ဟှို့တွပ် လိုရှင်ဟှယ်။ အယ်ဘေမဲ့ ဟေရုဒ်ကြောန့် သူဟှာ ခွမ့်ရဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ဟေရုဒ်ဟှာ ယောဟန်ဟှို ကြော့‑က်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ယောဟန်ဟှာ ဖြောန့်မတ်ဘီး သန့်ရှင်းဟှူလူ ဖြစ်ဟှယ် ဆိုဇာဟှို သူသိဟှားဟှယ်။ အယ်ကြောန့် သူဟှာ သူ့ဟှို လောင်းလောင်ခြောင်းခြောင်ဟှား ထားဟှားလေဟှယ်။ သူဟောပြောဇာလေဟှို ကြားရဟှူ ခီတိုင်း ရရာတိုင်း စိနှောင့်ယှစ် ဖြစ်ဘေမဲ့လည်း သူဟှာ သူ့ရဲ့ ဟောပြောဇာဟှို နှစ်သက်ဘီး နားထောန်တတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","နော့‑က်ဆောင်းမာ ဟေရောဒိဟှာ ခွမ့်ရေး ရဟှားဟှယ်။ အယ်ခွမ့်ရေးဟှာ ဟေရုဒ် မွေးနေ့မာ ဖြစ်ဟှယ်။ အယ်နေ့မာ ဟေရုဒ်ဟှ ထိတန်းစိုးရ ရာရှိဂီးလေ၊ တပ်မတော် ရာရှိဂီးလေ၊ ဂါလိလဲနယ်ရဲ့ ခေါန်းဆောန်ဂီးလေ အားလောင်းတွပ် စားသော့‑က်ဗွဲဂီး ကျင်းပပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ဟေရောဒိရဲ့ မီးဟှားဟှ လာဘီးဟှာ ကပြလေဟှယ်။ အယ်ခီမာ ဟေရုဒ်န သူ့ရဲ့ ဧည့်သည်လေဟှာ ကျေနပ်ဟှားလေဟှယ်။ အယ်ကြောန့် မန်းဂီးဟှ မီးမငယ်ဟှို “နန်ဖြားဇာလိုရှင်နူး။ နန်လိုရှင်ဇာလေဟှို ငါပေးမယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“ငါ့နိုင်ငံတဝပ်ဟှို နန်တောန်းမယ် ဆိုဟှာ ငါတကယ်ပေးမယ်!” ဆိုဘီးဟှာ ဒိပေးဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","အယ်ကြောန့် မီးမငယ်ဟှားဟှ ထွပ်ဟှားဘီးဟှာ သူ့ရဲ့ မိဟှို မေးလိုက်ဇာဟှ “ကျွန်မဟှ ဖြားဇာတောန်းရဟှို့နူး!” သူ့ရဲ့ မိဟှ “ဗတ္တိဇံယောဟန်ရဲ့ ခေါန်းဟှို တောန်းပါ” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","မီးမငယ်ဟှ ရှစ်ရှင်းဘဲ့ ဟေရုဒ် မန်းဂီးနားဟှို ဗြန်းဗြန်ဟှား ပ္လန်ဟှားဘီးဟှာ “ဗတ္တိဇံယောဟန်ရဲ့ ခေါန်းဟှို လန်းဗန်းထတ်မာ တန်ဘီးဟှာ ခုပေးပါ” ဆိုဘီး တောန်းဆိုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","အယ်မျိုး တောန်းဆိုဟှူကြောန့် မန်းဂီးဟှာ ရရာတိုင်း ဝန်းနဲဟှားဟှယ်။ အယ်ဘေမဲ့ ဧည့်သည်လေရှေ့မာ သူ့ကိုယ်သူ ကီဆိုဟှားဟှူကြောန့် သူဟှာ ငြင်းနိုင်ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","အယ်ကြောန့် မန်းဂီးဟှ ယောဟန်ရဲ့ ခေါန်းဟှို ယူလာဟှို့တွပ် မိန့်ပေးဘီးဟှာ စောန့်တယော့‑က်ဟှို ရှင်းရှင်း လွှတ်လေဟှယ်။ အယ်လူဟှ ထောန်ထဲဟှို သွားဘီးဟှာ ယောဟန်ရဲ့ ခေါန်းဟှို ဖြတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","အယ်ခေါန်းဟှို လန်းဗန်းထတ်မာ တန်ဘီးဟှာ ယူဆောန်လာဘီး မီးမငယ်ဟှားဟှို ပေးလေဟှယ်။ သူဟှလည်း သူ့ရဲ့ မိဟှို ပ္လန်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ယောဟန်ရဲ့ တဗဲ့တော်လေဟှ အယ်ဒန်းဟှို ကြားဟှူ ခီမာ လာဘီး ယောဟန်ရဲ့ လောန်းဟှို ယူဘီးဟှာ ဂူထဲမာ ထားလိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","တမန်တော်လေဟှာ ယေရှုနားမာ စုဂေ့ဘီးဟှာ သူးနို့ လောက်ဆောန်ဘီး သွန်သန်ဟှားဟှူဇာ ဂူလောင်းဟှို ကိုယ်တော့်ဟှို လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","အယ်နေရာဟှို လူလေဘောင်ဂီးဟှ သွားလိုက်လာလိုက် လောက်နေဟှူကြောန့် ယေရှုန တဗဲ့တော်လေဟှာ စားဟှို့ ခီဟှိုမှ မှေ့ဟှမ်း။ အယ်ကြောန့် သူဟှ “ငါ့နတူးဒူ တိဆိဟှူ နေရာဟှို သွားဘီးဟှာ ရှစ်ဟှားနားယူ ဂေ့ဇို့” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","အယ်ကြောန့် ယေရှုန တဗဲ့တော်လေဟှ တိဆိဟှူ နေရာတခုနားဟှို လှေန ထွပ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","သွားလိုက်ဇာဟှို လူလေဟှဗြင်ဟှူ ခီမာ ကိုယ်တော်န တဗဲ့တော်လေဘဲ့ ဆိုဘီး သိဟှားဟှူကြောန့် ဗြို့လေဝါလေဟှ လူလေဟှာ ယေရှုသွားလိုက်ဟှူ နေရာဟှို ဗြန်းဗြန်ဟှား ကူးကြောန်းရှော့‑က်ဘီးဟှာ ယေရှုန တဗဲ့တော်လေ ရော့‑က်ခန် အယ်နေရာဟှို ရင်ရော့‑က်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ယေရှုဟှ လှေဟှနေ ထွပ်ဟှူ ခီမာ ကိုယ်တော်ဟှာ လူအောက်ဂီးဟှို ဗြင်ဟှားဘီး ကိုယ်တော်ဟှာ သူးနို့တွပ် သနားဟှူစိ ဖြစ်ဟှားလေဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့ဟှာ သိုးထီးမားမှေ့ဘဲဟှူ သိုးလေမျိုး ဖြစ်နေဟှယ်။ အယ်ကြောန့် ကိုယ်တော်ဟှာ သူးနို့ဟှို ကြောန်းရာလေ ဘောင်ဂီးဟှို စဘီးဟှာ သွန်သန်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ညဉ့်မိုက်ခါနီး ရော့‑က်လာဟှူ ခီမာ တဗဲ့တော်လေဟှ ယေရှုနားဟှို လာဘီးဟှာ “အယ်နေရာဟှာ တောဖြစ်နေဟှူကြောန့် လူလေလည်း နေဘဲဟှူ နေရာဖြစ်ဟှယ်။ နော့‑က်က္လဟှားဘီ။ ");
INSERT INTO tvn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","စားဇာသွားဝယ်ဘီး စားနိုင်ဟှို့တွပ် လူလေဟှို နီးနားမာရှိဟှူ တောဝါလေဟှို လွှတ်လိုက်ပါ” ဆိုဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ယေရှုဟှ “နန်းနို့လေဘဲ့ သူးနို့ဟှို စားဇာတခုခု ကျွေးလိုက်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်ခီမာ တဗဲ့တော်လေဟှ “ကျွန်တော့်လေဟှ ငွေဒန်းဂါး ၂၀၀ ဖိုးန စားဇာဝယ်ဘီး အယ်လူလေဟှို ကျွေးရဟှို့လော” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ယေရှုဟှ “နန်းနို့လေမာ မုဖယ်မျှလော့‑က်ရှိနူး။ သွားဘီးဟှာ ကေ့ကေ့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ သူးနို့လေဟှ ကေ့ဟှူ ခီမာ “မုငါးလောင်းန ငါးနှေ့ကောန်ရှိဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","အယ်ဘီးန ယေရှုဟှ လူလေ ဂူလောင်းဟှို အောက်စုခွဲဘီးဟှာ ဗြစ်ပန်လေထတ်မာ ထိုင်ခိုင်းလိုက် ဆိုဘီး တဗဲ့တော်လေဟှို လောက်ဟှို့တွပ် ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","အယ်ကြောန့် လူလေဟှာ တရာတဖွဲ့န ငါးဆယ်တဖွဲ့ တန်းလိုက်ထိုင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","အယ်ဘီးန ယေရှုဟှ မုငါးလောင်းန ငါးနှေ့ကောန်ဟှို ယူဘီးဟှာ ကောန်းဂန်ဟှို မျှော်ကေ့ဘီး ဘုရားသခင်ဟှို ကျေးဇူးတော် ချီးမွမ်းလိုက်ဟှယ်။ ကိုယ်တော်ဟှာ မုလေဟှို ဖဲ့ဘီးဟှာ လူလေဟှို ဝီပေးဟှို့တွပ် တဗဲ့တော်လေဟှို မုလေ ပေးလိုက်ဟှယ်။ ကိုယ်တော်ဟှာ ငါးနှေ့ကောန်ဟှိုလည်း သူးနို့လေ ဂူလောင်း ကြားထဲမာ ခွဲဝီပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","လူတိုင်းဟှာ စားဘီး ဗိုက်ပ္လဲ့ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","အယ်ဘီးန တဗဲ့တော်လေဟှ စားဘီး ကျန်နေဟှူ မုနငါးလေရဲ့ က္လိုးပဲ့လေဟှို လိုက်ကော့‑က်ဟှူ ခီမာ ဆယ့်နှေ့တောန်းပ္လဲ့ ရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","မုစားဟှူ ယော့‑က်ကျား ရေတွပ်ဟှာ ၅,၀၀၀ ရှိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ယေရှုဟှာ လူအောက်ဂီးဟှို ပ္လန်လွှတ်နေဒူးမာ ရှစ်ရှင်းဘဲ့ တဗဲ့တော်လေဟှို လှေထတ်ဟှို တတ်ခိုင်းဘီး အိုင်ရဲ့ ဟှို့ဖတ်ကမ်းဟှ ဗက်ဇဲဒဗြို့ဟှို ရင်ဦးဆောင်း သွားခိုင်းလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ယေရှုဟှ လူလေဟှို နှောက်ဆစ်ဘီးန ဆုတောန်းဟှို့တွပ် တောန်ထတ်ဟှို တတ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ညဉ့်မိုက်လာဟှူ ခီမာ တဗဲ့တော်လေရဲ့ လှေဟှ ရေအိုင်ရဲ့ လယ်မာရော့‑က်နေဘီး ယေရှုဟှ တယော့‑က်ဒဲ ကူးထတ်မာ ရှိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","လေဆန်ဟှို လှေလှော်နေဟှူကြောန့် ရရာတိုင်း ပန်းနေဟှူ တဗဲ့တော်လေဟှို ကိုယ်တော်ဟှ ဗြင်ဟှားလေဟှယ်။ အယ်ကြောန့် မိုးလန်းသောင်းနာရီန ခြော့‑က်နာရီ ကြားမာ ကိုယ်တော်ဟှာ ရေထတ်မာ လမ်းရှော့‑က်ဘီးဟှာ သူးနို့နားဟှို ရော့‑က်လာလေဟှယ်။ ကိုယ်တော်ဟှာ သူးနို့ဟှို ကျော်ဖြတ်ဟှို့ လောက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","အယ်ဘေမဲ့ တဗဲ့တော်လေဟှ ရေထတ်မာ ကိုယ်တော်ဟှာ လမ်းရှော့‑က်နေဇာဟှို ဗြင်ဟှားဟှူ ခီမာ “ဖုကသေ ဖြစ်ဟှယ်!” ဆိုဇာဟှို ထန်ဘီးဟှာ အော်ဟစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","သူးနို့လေ ဂူလောင်းဟှ ယေရှုဟှို ဗြင်ဟှူ ခီမာ ထိလန့်နေဂေ့ဟှယ်။ ယေရှုဟှ ရှစ်ရှင်းဘဲ့ “သတ်တိရှိဂေ့!” ဆိုဘီး ပြောလေဟှယ်။ “ငါဘဲ့ဖြစ်ဟှယ်။ ကြော့‑က်ဂေ့န!” ");
INSERT INTO tvn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","အယ်ဘီးန သူးနို့ရှိနေဟှူ လှေထတ်ဟှို တတ်ဟှားဟှူ ခီမာ လေဟှာ ငြီဟှားလေဟှယ်။ တဗဲ့တော်လေဟှ ရရာတိုင်း အံ့ဩဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့ဟှာ လူ ၅,၀၀၀ ဟှို မုကျွေးဟှူ ဓိပါယ်ဟှို နားလည်ဂေ့ဘဲန သူးနို့ရဲ့ စိနှလောင်းဟှာ မာကျောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","သူးနို့ဟှာ အိုင်ဟှို ကူးဟှားဂေ့ဘီး ဂင်နေသရက်ဗြို့ဟှို ရော့‑က်လာဂေ့ လေဟှယ်။ အယ်နေရာမာ လှေဟှို ခယ်လိုက် လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","သူးနို့လေဟှာ လှေထတ်ဟှနေ ဆင်းလိုက်ဟှူ ခီမာ ရှစ်ရှင်းဘဲ့ လူလေဟှ ယေရှုဟှို မှတ်မိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","အယ်ကြောန့် သူးနို့လေဟှာ ဒေသတခုလောင်းဟှို ပ္လံ့နှံ့အောန် ပ္လေးဟှားဂေ့ဘီးဟှာ ကိုယ်တော်ရှိဟှယ် ဆိုဘီး ကြားဟှားဟှူ နေရာဟှို လူနာလေဟှို ထမ်းစင်လေန ကိုယ်တော်နားဟှို ခေါ်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ယေရှုသွားဟှူ ဝါလေ၊ ဗြို့လေ၊ နေရာတိုင်းဟှ လူလေဟှ လူနာလေဟှို ဆေးလေမာ ခ္လဟှားဂေ့ဘီး ကိုယ်တော်ရဲ့ ဝတ်လောင် ပန်းဗွားဟှိုဘဲ့ ထိခွမ့်ပေးဟှို့တွပ် လူလေဟှ တောန်းဗန်ဂေ့ဟှယ်။ အယ်ဘီးန ဝတ်လောင်ဟှို တို့ထိဟှူ လူလေဂူလောင်းဟှာ ကျန်းမာဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","တချို့ ဖာရိရှဲလေန ယေရုရှလင်ဗြို့ဟှနေ လာဂေ့ဟှူ ကျမ်းတတ်ဆရာလေဟှာ ယေရှုပတ်ပတ်လည်မာ စုနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ကိုယ်တော်ရဲ့ တဗဲ့တော်လေ တချို့ဟှ စင်ကြယ်ဘဲဟှူ လတ်လေန စာစားနေဇာဟှို သူးနို့လေဟှ ဒိထားမိဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကျန်နေဟှူ ယုဒလူမျိုးလေန ဖာရိရှဲလေဟှာလည်း သူးနို့ရဲ့ ရှေးလူဂီးလေဟှနေ လတ်ခံဟှားဟှူ သွန်သန်မှု နော့‑က်ဟှို လိုက်ဘီး သူးနို့လေဟှ မှန်ဟှူ နည်းလမ်းအားဖြင့် သူးနို့ရဲ့ လတ်လေဟှို ဆေးဘဲန စာစားဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ဆေးဟှနေ ရလာဟှူ ဖယ်ဇာဘဲ့ဖြစ်ဖြစ် ရေန ရင်ဆေးဘဲ့န စားဂေ့ဟှ။ အယ်ဘီးဟှာ သူးနို့လေ လတ်ခံဟှားဟှူ တခြားထောင်းဒန်းလေ နော့‑က်ဟှို လိုက်ဟှယ်။ ဥပမာ အိုးလေ၊ ခွပ်လေ၊ ကြေးဖလားခွပ်လေန ကဒန်လေဟှို မှန်ဟှူနည်းလမ်းအားဖြင့် ဆေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","အယ်ကြောန့် ဖာရိရှဲလေန ကျမ်းတတ်ဆရာလေဟှ “ဖြားဖြစ်ကြောန့် အယ်မျိုးသတ်ရှင်နူး။ ကိုယ်တော်ရဲ့ တဗဲ့တော်လေဟှ ရှေးလူဂီးလေရဲ့ လတ်ဆစ်ကမ်းဟှားဟှူ သွန်သန်မှု နော့‑က်ဟှို လိုက်ဂေ့ဟှ။ အယ်မျိုးလိုက်ဟှို့စား စင်ကြယ်ဘဲဟှူ လတ်န စားဂေ့နူး” ဆိုဘီး ယေရှုဟှို မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ယေရှုဟှ “ဟေရှာယဟှ နန်းနို့လေ ကြောန်းဟှို ပရောဖက်ပြုဟှားဇာဟှာ ရရာတိုင်း မှန်ဟှယ်! နန်းနို့လေဟှာ ကြောန်သူတော်လေ ဖြစ်ဟှူကြောန့် သူဟှ အယ်မျိူးရေးဟှားဟှယ်။” “‘ဘုရားသခင် မိန့်တော်မူဇာဟှ အယ်လူလေဟှာ ငါ့ဟှို နှောက်န ရိုသေဟှယ်။ အယ်ဘေမဲ့ သူးနို့ရဲ့ စိနှလောင်းဟှ ငါ့န တကယ်ဘဲ့ ရရာတိုင်း ဝီးနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ငါ့ဟှို အလဂါး ကိုးကွယ်နေဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့ဟှာ ဘုရားသခင်ရဲ့ပညတ်တရားလေ ဖြစ်ဟှယ် ဆိုဘေမဲ့ လူရဲ့ စည်းမျဉ်းလေဟှို သန်ပေးလေဟှယ်!’ ” ");
INSERT INTO tvn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“နန်းနို့လေဟှ ဘုရားသခင်ရဲ့ ပညတ်တော်ဟှို ဖယ်ဟှားဘီးဟှာ လူလေရဲ့ သွန်သန်မှုလေဟှို လိုက်နာဂေ့ဟှယ်” ဆိုဘီး သူးနို့ဟှို ပ္လန်ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","အယ်ဘီးဟှာ ယေရှုဟှ ဆစ်ဘီး “နန်းနို့လေရဲ့ ကိုယ်ပိုင်သွန်သန်မှုဟှို ကျင့်သောင်းနိုင်ဟှို့တွပ် နန်းနို့လေဟှာ ဘုရားသခင်ရဲ့ ပညတ်တော်ဟှို ပယ်ဟှူဇာဟှ ကျွမ်းကျင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ မောရှေပညတ်ဟှားဇာဟှ ‘နန်းနို့မိဖဟှို ရိုသေဂေ့။ အယ်ဘီးဟှာ ဖယ်သူဘဲ့ဖြစ်ဖြစ် ကိုယ့်မိဖဟှို ကီဆဲမယ် ဆိုဟှာ သေဒန်ခံရမယ်။’ ");
INSERT INTO tvn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","အယ်ဘေမဲ့ နန်းနို့ဟှ အယ်မျိုးသွန်သန်ဘီး လူလေမာ သူးနို့ရဲ့ မိဖဟှို ကူညီဟှို့ တခုခုရှိဟှယ် ဆိုဟှာ ‘အယ်ဇာဟှာ ကော်ဘန်ဖြစ်ဟှယ်’ ဆိုဘီး ပြောဟှယ် (အယ်ဓိပါယ်ဟှ ဘုရားသခင်ဟှို လှူဘီးဟှူ အောက်စာဖြစ်ဟှယ်)၊ ");
INSERT INTO tvn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","အယ်မျိုးဆိုဟှာ နန်းနို့ဟှ အယ်အောက်စာလေဟှို သောင်းပြုဘီးဟှာ သူ့ရဲ့ မိဖဟှို ကူညီဟှို့တွပ် ခွမ့်ပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","အယ်မျိုးဘဲ့ နန်းနို့လေဟှ တခြားလူလေဟှို လတ်ဆစ်ကမ်းလိုက်ဟှူ သွန်သန်မှုဟှာ ဘုရားသခင်ရဲ့ စကားတော်ဟှို ဖျစ်ပစ်ဂေ့ဟှယ်။ အယ်ဆိုဟှာ အယ်မျိုးဇာလေ ဘောင်ဂီးဟှို နန်းနို့လေ လောက်ဂေ့ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","အယ်ဘီးန ယေရှုဟှ လူအောက်ဂီးဟှို သူ့နားဟှို ပ္လန်ခေါ်ဘီးဟှာ “နန်းနို့အားလောင်း ငါ့စကားဟှို နားထောန်ဘီးဟှာ နားလည်ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ပ္လန်ဟှနေ လူထဲဟှိုဝမ်ဘီး လူဟှို ညစ်ညူးစေနိုင်ဟှူဇာ ခုလည်း မှေ့ဟှ။ လူထဲဟှနေ ထွပ်လာဟှူဇာလေဟှဘဲ့ လူဟှို ညစ်ညူးနိုင်ဟှယ်။ ” ");
INSERT INTO tvn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ကိုယ်တော်ဟှာ လူအောက်ဂီးနားဟှ ထွပ်ဟှားဘီးဟှာ အီထဲဟှို ဝမ်ဟှားဟှူ ခီမာ တဗဲ့တော်လေဟှ အယ်ပေါင်ဥပမာကြောန်းဟှို ကိုယ်တော့်ဟှို မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ယေရှုဟှ “နန်းနို့လေဟှ အယ်မျှလော့‑က် သိဉာဏ်နဲရလော” ဆိုဘီး သူးနို့ဟှို ပြောလေဟှယ်။ “နန်းနို့ နားလည်ဂေ့ ဟှလော။ ပ္လန်ဟှနေ လူထဲဟှို ဝမ်လာဟှူ ဇာဟှ လူဟှို လောင်းဝ ညစ်ညူးစေနိုင်ဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်ဇာလေဟှ စိနှလောင်းထဲဟှို ဝမ်ဇာမှုဟှ။ စာအီထဲဟှို ဝမ်ဟှားဘီးန နော့‑က်ဖေးအီထဲဟှို ဆင်းဟှားလေဟှယ်။” (အယ်မျိုး မိန့်တော်မူဇာဟှ စာဂူလောင်းဟှာ သန့်ရှင်းဟှယ် ဆိုဘီး ယေရှု ကြေညာလိုက်ဟှယ်။) ");
INSERT INTO tvn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ကိုယ်တော်ဟှ ဆစ်ဘီးဟှာ “လူရဲ့ထဲဟှ ထွပ်လာဇာလေဘဲ့ လူဟှို ညစ်ညူးစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လူရဲ့ စိနှလောင်းထဲဟှနေ မှားယွင်းဟှူ ကြံစည်လေဟှ ထွပ်လာဘီး တရားဘဲဟှူ မေထုန်ပြုရှင်း၊ ခိုးရှင်း၊ လူသတ်ရှင်း၊ ");
INSERT INTO tvn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","အီထောန်ရေးဖော့‑က်ပ္လန်ရှင်း၊ လောဖကီးရှင်း၊ ကောန်းဘဲဟှူဇာ ဘောန်းဇောင်လောက်ရှင်း၊ လှည့်ဇားရှင်း၊ ပျော်ပါးလိုက်စားရှင်း၊ နာလိုရှင်း၊ ကဲ့ရဲ့ပြစ်တန်ရှင်း၊ မာနကီးရှင်း၊ လျှပ်ပေါ်ရှင်း၊ ");
INSERT INTO tvn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","အယ်ကောန်းဘဲဟှူ ဇာလေ ဂူလောင်းဟှာ လူရဲ့ ထဲဟှနေ ထွပ်လာဘီးဟှာ လူဟှို ညစ်ညူးစေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","အယ်ဘီးန ယေရှုဟှ အယ်နေရာဟှနေ ထွပ်ဟှားဘီးဟှာ တုရုဗြို့တော်န နီးဟှူ ဒေသဟှို သွားလိုက်ဟှယ်။ ကိုယ်တော်ဟှာ အီတအီထဲဟှို ဝမ်ဟှားဘီး အယ်နေရာမာ ကိုယ်တော် ရှိနေဟှယ် ဆိုဇာဟှို ဖယ်သူ့ဟှိုလဲ သိစေရှင်ဟှ။ အယ်ဘေမဲ့ ကိုယ်တော်ဟှာ ပူးဘီးနေနိုင်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ညစ်ညူးဟှူ နတ် ဝမ်ပူးနေဟှူ သမီးငယ်ရဲ့ မိဟှ ယေရှုကြောန်းဟှို ကြားဟှူ ခီမာ ကိုယ်တော်နားဟှို ရှစ်ရှင်း ရော့‑က်လာဘီးဟှာ ခေရင်းမာ ဒူးထော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","အယ်မီးမဂီးဟှာ ရှုရိဖိနိတ်နယ်သူ လူမျိုးခြားဖြစ်ဟှယ်။ သူ့ရဲ့ သမီးထဲဟှ နတ်ဆိုးဟှို နှန်ထုဟှို့တွပ် ယေရှုဟှို တောန်းလျှော့‑က်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","အယ်ဘေမဲ့ ယေရှုဟှ “သားမီးလေဟှို ရင်ဦးဆောင်းကျွေးခွမ့်ပေးပါ။ သားမီးလေရဲ့ စားဇာဟှို ယူဘီးဟှာ ခွီးလေဟှို ပစ်ပေးဇာဟှာ မှန်ဟှ” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","အယ်မီးမဂီးဟှ “သခင်၊ ဗွဲအော့‑က်ဟှ ခွီးလေဟှိုမှ သားမီးလေရဲ့ စားကြွင်းစားကျန်လေဟှို စားရဂေ့ဟှယ်!” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","အယ်ကြောန့် ယေရှုဟှ “အယ်မျိုး ပ္လန်လျှော့‑က်ဟှူကြောန့် အီဟှို ပ္လန်ဟှားလိုက်။ နတ်ဆိုးဟှာ နန့်သမီးထဲဟှနေ ထွပ်ဟှားဘီ ဆိုဇာဟှို နန်တွိရလေ့မယ်!” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","အယ်မီးမဂီးဟှ အီဟှို ပ္လန်ရော့‑က်ဟှားဟှူ ခီမာ သူ့ရဲ့ သမီးဟှာ အိယာထဲမာ လဲလျောင်းနေဇာဟှို တွိရဇာဟှ သူ့နားဟှ နတ်ဆိုး ထွပ်ဟှားပီးဘီ ဆိုဇာဟှို သိရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","အယ်ဘီးန ယေရှုဟှာ တုရုဗြို့တော်ရဲ့ နီးနားဝန်းကျင်ဟှ ထွပ်ဟှားဘီး ဇိဒုန်ဗြို့တော်ဟှို ဖြတ်ဘီး ဒေကာပေါလိနယ် ဟှတဆင့် ဂါလိလဲအိုင်ဟှို ဆစ်သွားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","လူတချို့ဟှ ဆွံ့အနားပန်းနေဟှူ လူတယော့‑က်ဟှို ကိုယ်တော်နားဟှို ခေါ်လာဟှယ်။ အယ်ဘီးဟှာ သူးနို့ဟှ သူ့ထတ်မာ လတ်တန်ပေးဟှို့တွပ် ယေရှုဟှို တောန်းဗန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","အယ်ကြောန့် ယေရှုဟှ သူ့တယော့‑က်ထဲဟှိုဘဲ့ လူအောက်ဂီးထဲဟှနေ ခေါ်ဟှားဘီးဟှာ အယ်လူရဲ့ နားလေထဲဟှို လတ်ညှိုးဟှို ထိုးသွမ်းလိုက်ဘီး၊ ထွီးရယ်န ထွီးဘီး အယ်လူရဲ့ လျှာဟှို တို့လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","အယ်ဘီးန ယေရှုဟှာ ကောန်းဂန်ဟှို မျှော်ကေ့ဘီး သတ်ပြင်းခ္လဘီးဟှာ “ဧဖသ” ဆိုဘီး အယ်လူဟှို မိန့်တော်မူလေဟှယ်။ အယ်ဓိပါယ်ဟှ “ပွမ့်စေ!” ဆိုဘီး ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ရှစ်ရှင်းဘဲ့ အယ်လူရဲ့ နားဟှ ပွပ်လာဘီးဟှာ ခယ်ဟှားဇာခံရဟှူ သူ့လျှာလေဟှ လွတ်ဟှားဘီး ပီးပီသသဟှား စကားပြောနိုင်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ယေရှုဟှ အယ်မျိုး ဖြစ်ပျစ်ကြောန်းဟှို ဖယ်သူ့ဟှိုလည်း ပြောဘဲဟှို့တွပ် လူလေဟှို တားလိုက်ဟှယ်။ အယ်ဘေမဲ့ ယေရှုဟှ တားလေလေ သူးနို့လေဟှ အယ်ကြောန်းဟှို ပိုဘီး ဟှာ ဟောပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","အယ်မျိုး ဖြစ်ပျစ်ကြောန်းဟှို ကြားရဟှူလူလေဟှ ရရာတိုင်း အံ့ဩဂေ့ဟှယ်။ “ကိုယ်တော်ဟှာ ရှိမျှဂူလောင်းဟှို လျောက်ပတ်အောန် လောက်ဟှယ်! နားပန်းဟှူ လူလေဟှို နားကြားစေဟှယ်။ ဆွံ့အနေဟှူ လူလေဟှိုလည်း စကားပြောစေဟှယ်!” ဆိုဘီး တအံ့တဩ ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ကြာခန်မာဘဲ့ နော့‑က်ထပ် ရရာတိုင်းများဟှူ လူအောက်ဂီးဟှာ စုလာဂေ့ဟှယ်။ သူးနို့လေမာ စားဟှို့ ဖြားလည်းမှေ့ဘဲဟှူကြောန့်၊ ယေရှုဟှ တဗဲ့တော်လေဟှို သူ့နားဟှိုခေါ်ဘီး ပြောလိုက်ဇာဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“အယ်လူလေဟှို ငါသနားဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့ဟှာ ငါ့နတူးဒူ သောင်းရစ်လောင်းလောင်း ရှိနေဂေ့ဘီး ခုစားဟှို့ ဖြားလည်းမှေ့ဘီ။ ");
INSERT INTO tvn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","သူးနို့ထဲဟှ တချို့ဟှာ ဝီးဟှနေလာရဟှူကြောန့် သူးနို့ဟှို ငါဟှ ကျွေးဘဲ့န အီပ္လန်ခိုင်းမယ် ဆိုဟှာ သူးနို့လေဟှ လမ်းမာ အားပြတ်ဂူလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","တဗဲ့တော်လေဟှ “လူမှေ့ဘဲဟှူ နေရာမာ ဖယ်သူဟှ အယ်လူလေ ဂူလောင်းဟှို လော့‑က်အောန်ကျွေးဟှို့ မုဟှို ဖယ်ဟှ ရနိုင်ဟှို့နူး” ဆိုဘီး ယေရှုဟှို ပ္လန်လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ယေရှုဟှ “နန်းနို့မာ မုဖယ်မျှလော့‑က်ရှိနူး” ဆိုဘီး မေးလေဟှယ်။ တဗဲ့တော်လေဟှ “မုခွန်နစ်လောင်းရှိဟှယ်” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ကိုယ်တော်ဟှာ လူအောက်ဂီးဟှို မ္လေမာ ထိုင်ခိုင်းလိုက်ဟှယ်။ အယ်ဘီးန မုခွန်နစ်လောင်းဟှို ယူဘီးဟှာ ဘုရားသခင်ဟှို ကျေးဇူးတော် ချီးမွမ်းလိုက်ဘီး၊ မုလေဟှို ဖဲ့လေဟှယ်။ အယ်ဘီးမှ လူအောက်ဂီးဟှို ဝီပေးဟှို့တွပ် တဗဲ့တော်လေဟှို ပေးလိုက်ဘီး၊ တဗဲ့တော်လေဟှ လူအောက်ဂီးဟှို ဝီပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","သူးနို့မာလည်း ငါးဂန်းဟှားလေ နဲနဲရှိလေဟှယ်။ ယေရှုဟှ အယ်ဇာလေတွပ် ကျေးဇူးတော် ချီးမွမ်းဘီးန ငါးလေဟှိုလည်း ဝီပေးဟှို့တွပ် တဗဲ့တော်လေဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","လူတိုင်းဟှာ ဗိုက်ပ္လဲ့အောန်စားရဂေ့ဇာဟှ။ အယ်ဘီးန တဗဲ့တော်လေဟှာ စားဘီးကျန်နေဟှူ က္လိုးပဲ့လေဟှို ပ္လန်ကော့‑က်သီးဟှူ ခီမာ ခွန်နစ်တောန်းပ္လဲ့ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","လူ ၄,၀၀၀ လော့‑က် ရှိဟှယ်။ ယေရှုဟှ လူလေဟှို ပ္လန်လွှတ်လိုက်ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ရှစ်ရှင်းဘဲ့ တဗဲ့တော်လေနတူးဒူ လှေထတ်ဟှို တတ်ဟှားဘီး ဒါလမနုသဒေသဟှို ကြွဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","တချို့ ဖာရိရှဲလေဟှာ ယေရှုနားဟှို ရော့‑က်လာဘီး ကိုယ်တော်န စဘီးဟှာ ဂြင်းခူဂေ့ဟှယ်။ သူးနို့ဟှ ကိုယ်တော့်ဟှို စမ်းသပ်ရှင်ဂေ့ဟှူကြောန့် ကောန်းဂန်ဘောင်ဟှ နိမိတ်လတ်ခဏာတခုဟှို လောက်ပြဟှို့ ကိုယ်တော့်ဟှို တောန်းဆိုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","အယ်ဘေမဲ့ ယေရှုဟှ သူ့ရဲ့စိထဲမာ သတ်ပြင်းခ္လဘီးဟှာ “အယ်ခေတ်လူလေဟှ ဖြားဖြစ်ကြောန့် နိမိတ်လတ်ခဏာဟှို တောန်းဂေ့နူး။ နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်! အယ်လူလေဟှို ဖြားသတ်သေလည်း ပေးလေ့မယ် မှုဟှ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ကိုယ်တော်ဟှာ သူးနို့ဟှို ထားရစ်ဘီး လှေထတ်ဟှို ပ္လန်တတ်ဘီးဟှာ အိုင်ရဲ့ဟှို့ဖတ်ကမ်းဟှို စဘီးဟှာ ကူးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","တဗဲ့တော်လေဟှာ မုယူလာဟှို့ မေ့ဟှားဟှူကြောန့် လှေထတ်မာ သူးနို့တွပ် မုတလောင်းဘဲ့ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ယေရှုဟှ “ဖာရိရှဲလေရဲ့ တဆေးန ဟေရုဒ်ရဲ့ တဆေးဟှို ဒိထားဂေ့” ဆိုဘီး သူးနို့ဟှို ဒိပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","တဗဲ့တော်လေဟှ သူးနို့ရှင်းရှင်းထဲမာ စဘီးဟှာ ဆွေးနွေးနေဇာဟှ “ကိုယ်တော်ဟှာ အယ်မျိုးပြောဇာဟှ နို့လေမာ ဖြားမုလည်း ပါလာဘဲ့ကြောန့်ဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","သူးနို့လေပြောနေဇာဟှို ယေရှုဟှာ သိနေလေဟှယ်။ အယ်ကြောန့် ကိုယ်တော်ဟှ “ဖြားမုလည်း မှေ့ဘဲဟှူကြောန်းဟှို နန်းနို့လေ ဖြားဖြစ်ကြောန့် ဆွေးနွေးနေဂေ့နူး။ နန်းနို့လေဟှာ ခုထိ နားလည်ဂေ့သေးဟှလော။ နန်းနို့ သိဂေ့သေးဟှလော။ နန်းနို့ရဲ့ စိနှလောင်းလေဟှ မာကျောနေဟှယ်လော။ ");
INSERT INTO tvn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","နန်းနို့မာမျစ်စိရှိဟှယ် နန်းနို့ ဗြင်ဂေ့ဟှလော။ နန်းနို့မာနားရှိဟှယ် ဆိုဟှာ နန်းနို့ ကြားဂေ့ဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ငါဟှ လူ ၅,၀၀၀ ဟှို ကျွေးဟှို့တွပ် မုငါးလောင်းဟှို ငါခ္လိုးဖဲ့ဟှူခီဟှို နန်းနို့ ဒိရဂေ့ဟှလော။ စားဘီးကျန်နေဟှူ က္လိုးပဲ့လေဟှို ပ္လန်ကော့‑က်ဇာဟှ ဖယ်မျှရနူး” ဆိုဘီးဟှာ မေးလေဟှယ်။ တဗဲ့တော်လေဟှ “ဆယ့်နှေ့တောန်းရပါဟှယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ယေရှုဟှ “အယ်ဘီးဟှာ ငါဟှာ လူ ၄,၀၀၀ တွပ် မုခွန်နစ်လောင်းဟှို ဖဲ့ဟှူ ခီမာ စားဘီးကျန်နေဟှူ က္လိုးပဲ့လေဟှို ဖယ်မျှတောန်းပ္လဲ့ နန်းနို့လေ ပ္လန်ကော့‑က်ရဂေ့နူး” ဆိုဘီး မေးလေဟှယ်။ တဗဲ့တော်လေဟှ “ခွန်နစ်တောန်းရပါဟှယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ကိုယ်တော်ဟှ “အယ်ဆိုဟှာ နန်းနို့ နားလည်ဂေ့သေးဟှလော” ဆိုဘီး သူးနို့ဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","သူးနို့လေဟှာ ဗက်ဇဲဒဝါဟှို ရော့‑က်လာဂေ့ဟှယ်။ အယ်နေရာမာ လူတချို့ဟှ မျစ်ကန်းတယော့‑က်ဟှို ယေရှုနားဟှို ခေါ်လာဘီးဟှာ အယ်လူဟှို တို့ထိဟှို့တွပ် တောန်းဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ယေရှုဟှ မျစ်ကန်းဟှို လတ်ဆွဲဘီးဟှာ ဝါပ္လန်ဟှို ခေါ်ဟှားလိုက်ဟှယ်။ အယ်လူရဲ့ မျစ်စိဟှို ထွီးရယ်နထွီးဘီးန ယေရှုဟှာ သူ့ထတ်မာ လတ်လေဟှို တန်လိုက်ဘီးဟှာ “နန် တခုခုဟှို ဗြင်ရဘဲ့လော” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","အယ်လူဟှ မော့ကေ့လိုက်ဘီး “ကျွန်တော်ဟှာ လူလေဟှို ဗြင်ရဟှယ်။ အယ်ဘေမဲ့ သူးနို့လေဟှ သစ်ပန်လေမျိုး လမ်းရှော့‑က်နေဂေ့ဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ယေရှုဟှာ အယ်လူရဲ့ မျစ်စိထတ်မာ လတ်လေဟှို ပ္လန်ဘီး တန်လိုက်ဟှယ်။ အယ်ခီမာ အယ်လူဟှာ အားစိုက်ဘီး ကေ့လိုက်ဇာ သူ့ရဲ့ မျစ်စိလန်းရောန် ပ္လန်ရဟှားဘီး သူဟှာ ဂူလောင်းဟှို ရှင်းရှင်းလန်းလန်းဟှား ဗြင်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ယေရှုဟှ သူ့ဟှို “ဝါထဲဟှို ပ္လန်ဝမ်န” ဆိုဘီးဟှာ မိန့်ပေးဘီး အီဟှို ပ္လန်ခိုင်းလိုက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","အယ်ဘီးန ယေရှုန တဗဲ့တော်လေဟှ ကဲသရိဖိလိပ္ပုနားဟှ ကျေးဝါလေဟှို သွားဂေ့ဟှယ်။ လမ်းခရီးမာ ကိုယ်တော်ဟှ “လူလေဟှ ငါ့ဟှို ဖယ်သူဖြစ်ဟှယ် ဆိုဘီး ပြောနေဂေ့နူး” ဆိုဘီးဟှာ သူးနို့ဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“တချို့ဟှ ဗတ္တိဇံယောဟန် ဖြစ်ဟှယ်။ တချို့ဟှ ဧလိယ ဖြစ်ဟှယ်။ တချို့ဟှ ပရောဖက်တပါး ဖြစ်ဟှယ်။ ဆိုဘီး ပြောနေဂေ့ဟှယ်” ဆိုဘီး သူးနို့ဟှ ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“နန်းနို့လေဟှမား ငါ့ဟှို ဖယ်သူဖြစ်ဟှယ် ဆိုဘီး ထန်ဂေ့နူး” ဆိုဘီး ကိုယ်တော်ဟှ သူးနို့လေဟှို မေးလိုက်ဟှယ်။ ပေတရုဟှ “ကိုယ်တော်ဟှာ ခရစ်တော် ဖြစ်ဟှယ်” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ယေရှုဟှ “ငါ့ကြောန်းဟှို ဖယ်သူ့ဟှိုလည်း ပြောဂေ့န” ဆိုဘီး သူးနို့လေဟှို မိန့်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","အယ်ဘီးန ယေရှုဟှ “လူ့ရဲ့သားဟှာ ဝေဒနာဘောင်ဂီး ခံရဘီး သတ်ကီးဝါဂီးလေ၊ ယဇ်ပုရောဟိတ်ဂီးလေ၊ ကျမ်းတတ်ဆရာလေအားဖြင့် ငြင်းပယ်ခံရမယ်။ သူဟှာ သတ်ခံရမယ်၊ အယ်ဘေမဲ့ သောင်းရစ်ကြာဘီးန သူဟှာ ပ္လန်ထမြော့‑က်လေ့မယ်” ဆိုဘီး တဗဲ့တော်လေဟှို စဘီး သွန်သန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ကိုယ်တော်ဟှာ အယ်ကြောန်းဟှို ပွမ့်ပွမ့်လန်းလန်းဟှား ပြောလိုက်ဟှယ်။ အယ်ကြောန့် ပေတရုဟှ ကိုယ်တော့်ဟှို ဘေးနားဟှို ခေါ်ဘီးဟှာ စဘီး ပြစ်တန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","အယ်ဘေမဲ့ ယေရှုဟှ ပ္လန်လှည့်ဘီး တဗဲ့တော်လေဟှို ကေ့ဘီးဟှာ ပေတရုဟှို ဆောင်းမလေဟှယ်။ “စာတန်၊ ငါ့နားဟှနေ ထွပ်ဟှား။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်ဟှာ ဘုရားသခင်န ဆိုင်ဟှူဇာလေဟှို စိစွဲလန်းဘဲန လူလေန ဆိုင်ဟှူ ဇာလေဟှိုဘဲ စွဲလန်းဟှယ်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","အယ်ဘီးန ယေရှုဟှာ လူအောက်ဂီးန တဗဲ့တော်လေဟှို သူ့နားဟှို ခေါ်လေဟှယ်။ ကိုယ်တော်ဟှ “ဖယ်လူဘဲ့ဖြစ်ဖြစ် ငါ့နော့‑က်ဟှို လိုက်ရှင်ဟှယ် ဆိုဟှာ ကိုယ့်ကိုယ်ကိုယ် ငြင်းပယ်ရမယ် အယ်ဘီးဟှာ ကိုယ့်ရဲ့ လတ်ဝါးကပ်တိုင်ဟှို ထမ်းဘီး ငါ့နော့‑က်ဟှို လိုက်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကိုယ့်သတ်ဟှို ကယ်ရှင်ဟှူ လူဟှာ သတ်ဆောင်းရှောင်းလေ့မယ်။ အယ်ဘေမဲ့ ငါ့တွပ်န ဒန်းကောန်းတွပ် သတ်ဆောင်းရှောင်းရဟှူ လူဟှာ ကိုယ့်သတ်ဟှို ကယ်ဆယ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","လူတယော့‑က်ဟှာ လောက တခုလောင်းဟှို ရဘေမဲ့ သူ့ရဲ့ သတ်ဝိညာဉ် ဆောင်းရှောင်းဟှားမယ် ဆိုဟှာ ဖြားကျိုးရှိမယ်နူး။ ဖြားကျိုးလည်း မှေ့ဟှ! ");
INSERT INTO tvn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","လူတယော့‑က်ဟှာ သူ့ရဲ့ သတ်ဝိညာဉ်ဟှို ပ္လန်ဝီးဟှို့တွပ် ဖြားဇာပေးနိုင်ဟှို့နူး။ ");
INSERT INTO tvn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ဖော့‑က်ပ္လန်ဘီး ပြစ်န ပ္လဲ့နေဟှူ အယ်မျိုးဆစ်မာ ဖယ်သူမဆို ငါ့န ငါ့စကားလေဟှို ယှစ်ကြော့‑က်မယ် ဆိုဟှာ၊ လူ့ရဲ့သားဟှာ သူ့ဖရဲ့ ဖောင်းတာ်ဟှို ဆောန်ဘီး သန့်ရှင်းဟှူ ကောန်းဂန်တမန်လေနတူးဒူ လာဟှူ ခီမာ အယ်လူဟှာ ယှစ်ကြော့‑က်ခံရလေ့မယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","အယ်ဘီးဟှာ ကိုယ်တော်ဟှ “ငါ မှန်တိုင်းပြောမယ်၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှ တဂိုးန တည်ဟှယ် ဆိုဇာဟှို ဗြင်ရဘဲ့န အယ်နေရာမာ ရှိနေဟှူ လူတချို့ဟှာ သေရဟှို့ မှုဟှ” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ခြော့‑က်ရစ်ကြာဘီးန ယေရှုဟှာ ပေတရု၊ ယာကုပ်၊ ယောဟန်လေဟှို သူ့နတူးဒူ ခေါ်ဟှားဘီး ဗြင့်ဟှူတောန်ထတ်ဟှို တတ်ဟှားဟှယ်။ အယ်နေရာမာ သူးနို့လေဘဲ့ ရှိလေဟှယ်။ အယ်ခီမာ သူးနို့ရှေ့မာ ယေရှုဟှာ သဏ္ဌာန်ပ္လောန်းလဲဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","အယ်ဘီးဟှာ ကိုယ်တော်ရဲ့ ဝတ်ဟှ ဖ္လူဆွတ်ဆွတ် ဖြစ်လာဟှယ် ကမ္ဘာမာ ဖယ်လူလည်း လျှော်ဟှို့ တတ်နိုင်ဘဲအောန် ရရာတိုင်း ဖ္လူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","အယ်ဘီးဟှာ တဗဲ့တော်သောင်းပါးရှေ့မာ ဧလိယန မောရှေဟှ ပေါ်လာဘီး ယေရှုန စကားပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ပေတရုဟှ “ဆရာ၊ အယ်နေရာမာ ကျွန်တော့်ဟှားလေ ရှိနေဇာ ရရာတိုင်း ကောန်းဟှယ်! ကိုယ်တော်တွပ် တဆောန်၊ မောရှေတွပ် တဆောန်၊ ဧလိယတွပ် တဆောန်၊ တဲသောင်းဆောန်ဟှို ကျွန်တော့်ဟှားလေ ဆော့‑က်ပေးမယ်” ဆိုဘီး ယေရှုဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","သူးနို့ဟှာ ရရာတိုင်း ကြော့‑က်လန့်နေဂေ့ဘီး၊ သူဟှာ ဖယ်မျိုးပြောရဟှို့ ဆိုဇာ သိဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","အယ်ဘီးန မိုးတီတခုဟှ ပေါ်လာဘီးဟှာ သူးနို့လေဟှို အောက်ခ္လလိုက်ဟှယ် “အယ်သူဟှ ငါ့ရဲ့ ရှစ်သား ဖြစ်ဟှယ်။ သူ့စကားဟှို နားထောန်ဂေ့!” ဆိုဘီး မိုးတီထဲဟှနေ သံတော်ဟှ ထွပ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ရှစ်ရှင်းဘဲ့ သူးနို့လေဟှာ ပတ်စိမွီဘီး ကေ့လိုက်ဟှယ် အယ်ဘေမဲ့ ယေရှုတပါးဘဲ့ သူးနို့နတူးဒူ ရှိနေဘီး တခြားဖယ်သူလည်း တွိရဂေ့ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","သူးနို့လေဟှ တောန်ထတ်ဟှနေ ဆင်းလာဂေ့ဟှူ ခီမာ ယေရှုဟှ “လူ့ရဲ့သားဟှ သေရာဟှနေ ထမြော့‑က်ခန်ထိ နန်းနို့ဗြင်ဟှားဇာဟှို ဖယ်သူ့ဟှိုလည်း ပြောဂေ့န” ဆိုဘီး သူးနို့ဟှို မိန့်မှာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","သူးနို့လေဟှ ကိုယ်တော်ရဲ့ မိန့်ဟှို နာခံဂေ့ဟှယ် အယ်ဘေမဲ့လည်း “ ‘သေရာဟှနေ ထမြော့‑က်ဟှယ်’ ဆိုဇာဟှ ဖြားဓိပါယ်မျိုးနူး” ဆိုဘီး အယ်ကြောန်းဟှို သူးနို့ရှင်းရှင်းထဲမာ စဘီး ဆွေးနွေးနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","အယ်ဘီးဟှာ သူးနို့ဟှ ယေရှုဟှို “ဧလိယဟှာ ရင်ဦးဆောင်း လာမယ် ဆိုဘီး ကျမ်းတတ်ဆရာလေဟှ ဖြားဖြစ်ကြောန့် ပြောဂေ့နူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ယေရှုဟှ “ဧလိယဟှာ ရင်ဦးဆောင်း လာဘီး ဂူလောင်းဟှို သစ်ပ္လန်လောက်မယ် ဆိုဇာဟှာ မှန်ဟှယ်။ အယ်ဘေမဲ့ လူ့ရဲ့သားဟှ ဝေဒနာဘောင်ဂီး ခံဘီးဟှာ ငြင်းပယ်ခံရမယ် ဆိုဘီး ကျမ်းစာမာ ဖြားဖြစ်ကြောန့် ရေးဟှားနူး။ ");
INSERT INTO tvn_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","အယ်ဘေမဲ့လည်း နန်းနို့ဟှို ငါပြောမယ်။ ဧလိယဟှာ ရော့‑က်လာပီးဘီ။ သူ့ကြောန်းဟှို ကျမ်းစာမာ ရေးဟှားတိုင်း လူလေဟှ သူးနို့လောက်ရှင်ဟှူတိုင်း သူ့ဟှို လောက်ဂေ့ဟှယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","သူးနို့ဟှာ တခြားတဗဲ့တော်လေနားဟှို ရော့‑က်လာဟှူ ခီမာ ရရာတိုင်း ကီးမားဟှူ လူအောက်ဂီးဟှာ သူးနို့လေဟှို ဝိုင်းရံဟှားဘီး ကျမ်းတတ်ဆရာ တချို့ဟှာ သူးနို့န ဂြင်းခူနေဇာဟှို ဗြင်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ရှစ်ရှင်းဘဲ့ လူလေဟှ ယေရှုဟှို ဗြင်ဟှူ ခီမာ သူးနို့ဟှာ ရရာတိုင်း အံ့ဩဂေ့ဘီးဟှာ ကိုယ်တော်နားဟှို ပ္လေးလာဘီး နှောက်ဆစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ယေရှုဟှ တဗဲ့တော်လေဟှို “နန်းနို့လေဟှာ သူးနို့လေန ဖြားကြောန်းရာဟှို ဂြင်းခူနေဂေ့နူး” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","လူအောက်ဂီးထဲဟှနေ တယော့‑က်ဟှ “ဆရာ၊ ညစ်ညူးဟှူနတ် ဝမ်ပူးနေဟှူကြောန့် စကားပြောနိုင်ဘဲဟှူ ကျွန်တော့်သားဟှို ဆရာ့နားဟှို ခေါ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","နတ်ဆိုးဟှာ သူ့ဟှို ဖမ်းစားဟှူခီတိုင်း သူ့ဟှို မ္လေဂီးမာ လဲခ္လတတ်ဘီး၊ ဇပ်ပေါ့‑က်ဟှ ဖြုပ်ထွပ်ဘီး၊ အံသွားလေ က္လိတတ်ဟှယ်။ အယ်ဘီးန တော့‑က်မာ လာဟှယ်။ ကျွန်တော်ဟှာ ကိုယ်တော်ရဲ့ တဗဲ့တော်လေဟှို အယ်နတ်ဆိုးဟှို နှန်ထုဟှို့ ပြောဟှယ် အယ်ဘေမဲ့ သူးနို့လေဟှ တတ်နိုင်ဂေ့ဟှ” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ယေရှုဟှ “နန်းနို့ဟှာ လောင်းဝ ယောင်ကြည်ဘဲဟှူ လူလေ ဖြစ်ဟှယ်! ငါဟှာ ဖယ်လော့‑က်ကြာအောန် နန်းနို့နတူးဒူ နေရဟှို့နူး။ ဖယ်မျှလော့‑က်ကြာအောန် နန်းနို့ဟှို သီးခံရဟှို့နူး။ ကောန်းသားဟှားဟှို ငါ့နားဟှို ခေါ်လာဂေ့!” ဆိုဘီး သူးနို့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","အယ်ကြောန့် သူးနို့လေဟှ သူ့ဟှို ယေရှုနားဟှို ခေါ်ဟှားဂေ့ဟှယ်။ နတ်ဆိုးဟှာ ယေရှုဟှို ဗြင်ဟှူ ခီမာ ရှစ်ရှင်းဘဲ့ ကောန်းသားဟှားဟှို လဲခ္လဘီး တူတတ်စေဟှယ်။ အယ်ကြောန့် သူဟှာ မ္လေမာ လဲခ္လဘီး လူးလိနေဘီးဟှာ ဇပ်ပေါ့‑က်ဟှ ဖြုပ်လေ ထွပ်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ယေရှုဟှ “အယ်မျိုးဖြစ်နေဇာ ကြာဘီလော” ဆိုဘီး ကောန်သားရဲ့ ဖဟှို မေးလေဟှယ်။ သူဟှ “သားဂန်းဟှား ဂဒဲဟှ ဖြစ်နေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“သူ့ဟှို မီးထဲမာရော၊ ရေထဲမာရော လဲက္လစေဘီးဟှာ သတ်ဟှို့ ခါဘီးခါ ကြိုးစားဟှယ်။ အယ်ဘေမဲ့ ကိုယ်တော်ဟှာ တခုခု တတ်နိုင်မယ် ဆိုဟှာ ကျွန်တော့်ဟှို သနားဘီးဟှာ ကူညီပေးပါ!” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ယေရှုဟှ “နန်ကိုယ်တိုင်လည်း တတ်နိုင်ဟှယ် မှုဟှလော။ ယောင်ကြည်ရှင်းရှိဟှူ လူတယော့‑က်တွပ် ဂူလောင်း ဖြစ်နိုင်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ရှစ်ရှင်းဘဲ့ ကောန်သားဟှားရဲ့ ဖဟှ “ကျွန်တော် တကယ် ယောင်ကြည်ပါဟှယ်။ ကျွန်တော်ဟှာ ယောင်ကြည်ဘဲကြောန့် ကျွန်တော့်ဟှို မစပေးပါ!” ဆိုဘီး အော်ဘီးပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","လူအောက်ဂီးဟှာ သူးနို့ရှိဟှူ နေရာဟှို ပ္လေးလာဂေ့ဇာဟှို ယေရှု ဗြင်ဟှားဟှယ်။ အယ်ကြောန့် ကိုယ်တော်ဟှ ညစ်ညူးဟှူ နတ်ဟှို မိန့်ပေးလိုက်ဟှယ်။ “ဆွံ့အဘီး နားပန်းဟှူ နတ် ကောန်သားထဲဟှနေ ထွပ်ဟှားဘီး နော့‑က်ထပ် သူ့ထဲဟှို လောင်းဝ ဝမ်န ငါမိန့်ပေးဟှယ်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","နတ်ဆိုးဟှ အော်ဘီးဟှာ ကောန်သားဟှို ရရာတိုင်း တူတတ်ခိုင်းဘီးန ထွပ်ဟှားလေဟှယ်။ ကောန်သားဟှ သေကောန်မျိုး ဖြစ်ဟှားကြောန့် “သူသေဟှားဘီ!” ဆိုဘီး လူတိုင်းပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","အယ်ဘေမဲ့ ယေရှုဟှ ကောန်သားရဲ့ လတ်ဟှို ကိုင်ဘီး ထဒန်ဟှို့ ဆွဲဒန်လိုက်ဟှူ ခီမာ သူဟှာ ထလာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ယေရှုဟှ အီထဲဟှို ဝမ်ဟှားဘီးန တဗဲ့တော်လေဟှ “ကျွန်တော့်ဟှားလေဟှ ဖြားဖြစ်ကြောန့် အယ်နတ်ဆိုးဟှို နှန်ထုနိုင်ဟှနူး” ဆိုဘီး ကိုယ်တော့်ဟှို တိတိဟှား မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ယေရှုဟှ “အယ်နတ်မျိုးဟှို ဆုတောန်းဇာအားဖြင့်ဘဲ့ နှန်ထုနိုင်ဟှယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ယေရှုန တဗဲ့တော်လေဟှ အယ်နေရာဟှနေ ထွပ်ဟှားဘီး ဂါလိလဲနယ်ဟှို ဖြတ်ဘီး ဆစ်သွားလေဟှယ်။ သူးနို့လေ အယ်နေရာမာ ရှိနေဟှယ် ဆိုဇာဟှို ယေရှုဟှ ဖယ်သူ့ဟှိုလည်း သိခိုင်းရှင်ဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကိုယ်တော်ဟှာ သူ့ရဲ့ တဗဲ့တော်လေဟှို “လူ့ရဲ့သားဟှာ သူ့ဟှို သတ်မယ့်လူလေရဲ့ လတ်ထဲဟှို အပ်ခံရလေ့မယ်။ အယ်ဘေမဲ့လည်း သောင်းရစ်ကြာဘီးန သူဟှာ ထမြော့‑က်လေ့မယ်” ဆိုဘီး သွန်သန်နေကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","အယ်ဘေမဲ့ ကိုယ်တော်ပြောနေဇာဟှာ ဖြားဓိပါယ်ရှိဟှယ် ဆိုဇာဟှို သူးနို့လေ နားလည်ဂေ့ဟှ။ အယ်ဘီးဟှာ ကိုယ်တော့်ဟှို မေးဟှို့လည်း သူးနို့ဟှာ ကြော့‑က်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","သူးနို့လေဟှာ ကပေရနောင်ဗြို့ဟှို ရော့‑က်ဟှားဂေ့ဘီး အီထဲဟှို ဝမ်ဟှားဘီးန ယေရှုဟှ “နန်းနို့ဟှ လမ်းမာ ဖြားကြောန်းဟှို ဂြင်းခူနေဂေ့နူး” ဆိုဘီး တဗဲ့တော်လေဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","အယ်ဘေမဲ့ သူးနို့လေဟှာ ကိုယ်တော့်ဟှို ဖြေဂေ့ဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လမ်းမာ ဖယ်သူဟှ ကီးမြတ်ဆောင်းဖြစ်ဟှယ် ဆိုဘီး သူးနို့ရှင်းရှင်းထဲမာ ဂြင်းခူနေကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ယေရှုဟှာ ထိုင်ခ္လဘီးန တဗဲ့တော် ဆယ့်နှေ့ပါးဟှို ခေါ်လိုက်ဘီး “ဖယ်လူဘဲ့ဖြစ်ဖြစ် ဦးဆောင်းဖြစ်ရှင်ဟှယ် ဆိုဟှာ အယ်လူဟှာ ဂူလောင်းရဲ့ နော့‑က်ဆောင်းဖြစ်ရမယ်။ ဂူလောင်းရဲ့ စေခံလည်း ဖြစ်ရမယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","အယ်ဘီးန ကိုယ်တော်ဟှ သားဂန်းတယော့‑က်ဟှို ခေါ်ဘီးဟှာ သူးနို့ ရှေ့မာ ရပ်ခိုင်းလေဟှယ်။ ကိုယ်တော်ဟှာ သူ့ဟှို ပိုက်ဘီးဟှာ သူးနို့ဟှို ပြောလိုက်ဇာဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ဖယ်လူဘဲ့ဖြစ်ဖြစ် အယ်သားဂန်းလေထဲဟှ တယော့‑က်ဟှို ငါ့နာမဟှို ထော့‑က်ဘီးဟှာ လတ်ခံဟှယ် ဆိုဟှာ ငါ့ဟှို လတ်ခံဟှယ်။ ဖယ်သူဘဲ့ဖြစ်ဖြစ် ငါ့ဟှို လတ်ခံဟှယ် ဆိုဟှာ ငါ့ဟှိုဘဲ့ လတ်ခံဇာ မှုဟှ ငါ့ဟှို စေလွှတ်လိုက်ဟှူ သူဟှိုလည်း လတ်ခံဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ယောဟန်ဟှ “ဆရာ၊ ကိုယ်တော်ရဲ့ နာမန နတ်ဆိုးလေဟှို နှန်ထုနေဟှူ လူတယော့‑က်ဟှို ကျွန်တော်လေ တွိဗြင်လာဟှယ်။ သူဟှာ ကျွန်တော့်ဟှားလေရဲ့ အောက်စုထဲဟှ မှုဘဲဟှူကြောန့် သူ့ဟှို လောက်ဘဲဟှို့တွပ် ပြောရစ်ဟှယ်” ဆိုဘီး ကိုယ်တော့်ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ယေရှုဟှ “သူ့ဟှို တားဂေ့န။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါ့နာမန နိမိတ်လတ်ခဏာပြဘီးဟှာ ကြာခန်မာ ငါ့ကြောန်းဟှို ကဲ့ရဲ့နိုင်ဟှူလူ ယော့‑က်လည်း မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဖယ်လူဘဲ့ဖြစ်ဖြစ် နို့လေဟှို ဆန်ကျင်ဟှဆိုဟှာ နို့လေဖတ်ဟှဘဲ့ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ငါ မှန်တိုင်းပြောမယ်၊ နန်းနို့ဟှာ ခရစ်တော်ရဲ့ တဗဲ့တော်လေဖြစ်ဟှူကြောန့် ငါ့နာမဟှို ထော့‑က်ဘီး နန်းနို့လေဟှို ရေတခွပ် ပေးသော့‑က်ဟှူ လူတိုင်းဟှာ တကယ်ဘဲ့ ကျိုးဟှို လတ်ခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“ဖယ်လူဘဲ့ဖြစ်ဖြစ် ငါ့ဟှို ယောင်ကြည်ဟှူ အယ်သားဂန်းလေထဲဟှ တယော့‑က်ဟှို မှားယွင်းစေမယ် ဆိုဟှာ သူ့ရဲ့ လည်ဘန်းမာ ကီးမားဟှူ က္လော့‑က်က္လိဆောင်ဟှို ခယ်ဘီး ပန်လယ်ထဲဟှို ပစ်ခ္လခံရဇာဟှ အယ်လူတွပ် ပိုကောန်းဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","နန့်လတ်ဟှ နန့်ဟှို မှားယွင်းစေဟှယ် ဆိုဟှာ အယ်လတ်ဟှို ဖြတ်ပစ်လိုက်! လတ်နှေ့ဖတ်န မီးသေဘဲဟှူ ငရဲထဲဟှို သွားရဇာထတ် လတ်တဖတ်မှေ့ဘဲန သတ်ရှင်ဇာဟှို ဝမ်ရဇာဟှာ ပိုကောန်းဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","နန့်ခေဟှ နန့်ဟှို မှားယွင်းစေဟှယ် ဆိုဟှာ အယ်ခေဟှို ဖြတ်ပစ်လိုက်! ငရဲထဲဟှို ခေနှေ့ဖတ်န ပစ်ခ္လခံရဇာထတ် ခေတဖတ်မှေ့ဘဲန သတ်ရှင်ဇာဟှို ဝမ်ရဇာဟှာ ပိုကောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","နန့်မျစ်စိဟှ နန့်ဟှို မှားယွင်းစေဟှယ် ဆိုဟှာ အယ်မျစ်စိဟှို ထုပစ်လိုက်! မျစ်စိနှေ့ဖတ်န ငရဲထဲဟှို ပစ်ခ္လခံရထတ် မျစ်စိတဖတ်န ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို ဝမ်ရဇာဟှ ပိုကောန်းဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘အယ်နေရာမာ သူးနို့ဟှို စားဟှူပိုးကောန်လေဟှ လောင်းဝသေဟှ။ အယ်ဘီးဟှာ သူးနို့ဟှို လောန်နေဟှူမီးဟှလည်း လောင်းဝသေဟှ။’ ” ");
INSERT INTO tvn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ယဇ်ကောန်ဟှာ ဆားအားဖြင့် စင်ကြယ်ဟှားမျိုးဘဲ့ လူတိုင်းဟှာ မီးအားဖြင့် စင်ကြယ်ဟှားလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ဆားဟှ သောင်းဝမ်ဟှယ်။ အယ်ဘေမဲ့ သူ့ရဲ့ ငန်ဟှူရသာ ပျော့‑က်ဟှားမယ် ဆိုဟှာ ငန်ဟှူရသာဟှို ဖယ်မျိုး ပ္လန်ရနိုင်ဟှို့နူး။ “နန်းနို့ ကိုယ်တိုင်မာလည်း ဆားရဲ့ ဂေါင်သတ်တိမျိုးရှိဂေ့။ အယ်ဘီးဟှာ ရှင်းရှင်း သင့်မြတ်အောန်နေဂေ့” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","အယ်ဘီးန ယေရှုဟှ အယ်နေရာဟှ ထွပ်ဟှားဘီး၊ ယုဒနယ်ဟှို သွားလေဟှယ်။ အယ်ဘီးဟှာ ယော်ဒန်မ္လစ်ဟှို ကူးဟှားလေဟှယ်။ လူအောက်ဂီးဟှ ကိုယ်တော်နားဟှို ပ္လန်ဘီး စုလာဂေ့ဟှယ်။ ကိုယ်တော်ဟှာ လောက်နေကျတိုင်း သူးနို့ဟှို သွန်သန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ဖာရိရှဲလေ တချို့ဟှာ ကိုယ်တော်နားဟှို လာဘီးဟှာ ထောန်ချော့‑က်ဆင်ဟှို့ ကြိုးစာဟှယ်။ သူးနို့ဟှ “ကျွန်တော့်လေဟှို ပြောပြပါ။ ကျွန်တော့်လေရဲ့ ပညတ်တရားဟှ လူတယော့‑က်ဟှို သူ့မယားန ကွာရှင်းဟှို့ ခွမ့်ပြုဘဲ့လော” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ယေရှုဟှ “မောရှေဟှာ နန်းနို့ဟှို ဖြားမျိုး ပညတ်ပေးဟှားနူး” ဆိုဘီး မေးခွန်းန ပ္လန်မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","သူးနို့ရဲ့ ဖြေဟှ “လူတယော့‑က်ဟှာ သူ့မယားဟှို ကွာရှင်းစာချောက်ဟှို ပေးဘီး ကွာရှင်းဟှို့တွပ် မောရှေဟှ ခွမ့်ပြုဟှားဟှယ်” ဆိုဘီး ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ယေရှုဟှ “မောရှေဟှာ အယ်မျိုးပညတ်ချစ်ဟှို နန်းနို့လေတွပ် ရေးဟှားဟှယ် ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်းနို့ရဲ့ စိနှလောင်းမာကျောဟှူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","အယ်ဘေမဲ့ ကျမ်းစာမာ ပြောဟှားတိုင်းဘဲ့ ဖန်ဆင်းစဒူးဟှ ‘ဘုရားသခင်ဟှာ ယော့‑က်ကျားန မီးမဟှို ဖန်ဆင်းဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","အယ်ကြောန်းကြောန့် ယော့‑က်ကျားဟှ သူ့မိဖဟှို စွန့်ဘီး သူ့မီးမန ပေါန်းသင်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","အယ်ဘီးဟှာ အယ်နှေ့ယော့‑က်ဟှာ တသားတကိုယ်ဒဲ ဖြစ်လာလေ့မယ်။’ အယ်ကြောန့် သူးနို့ဟှာ နှေ့ယော့‑က်မှုဟှ။ အယ်ဘေမဲ့ တယော့‑က်ဒဲဘဲ့ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","အယ်ကြောန့် ဘုရားသခင် ပေါန်းစပ်ပေးဟှားဇာဟှို လူခွဲခွာစေန” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","သူးနို့လေဟှာ အီဟှို ပ္လန်ရော့‑က်ဟှူ ခီမာ တဗဲ့တော်လေဟှာ အယ်ကြောန်းဟှို ယေရှုဟှို မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ကိုယ်တော်ဟှ “ကိုယ့်မယားဟှို ကွာရှင်းဘီး တခြားမီးမဟှို ကိုယ့်မယားဟှို ပြစ်မှားဘီး အီထောန်ရေးဖော့‑က်ပ္လန်ရှင်းဟှို ကျူးလွန်သူ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","အယ်မျိုးဘဲ့ ကိုယ့်လန်ဟှို ကွာရှင်းဘီး တခြားယော့‑က်ကျားဟှို ပေါန်းသင်းဟှူ မီးမဟှာ ကိုယ့်လန်ဟှို ပြစ်မှားဘီး အီထောန်ရေးဖော့‑က်ပ္လန်ရှင်းဟှို ကျူးလွန်သူ ဖြစ်ဟှယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","လူလေတချို့ဟှာ သားဂန်းလေရဲ့ထတ်မာ ကိုယ်တော်ရဲ့ လတ်လေဟှို တန်ခိုင်းဟှို့တွပ် ယေရှုနားဟှို ခေါ်လာဂေ့ဟှယ်။ အယ်ဘေမဲ့ တဗဲ့တော်လေဟှ အယ်လူလေဟှို ပြစ်တန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ယေရှုဟှ အယ်ဇာဟှို ဗြင်ဟှားခီမာ ကိုယ်တော်ဟှာ စိဆိုးဟှားဘီး “သားဂန်းလေဟှို ငါ့နားဟှို လာဂေ့ပါစေ၊ သူးနို့ဟှို တားဂေ့န။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်မျိုးလူလေဘဲ့ ဘုရားသခင် နိုင်ငံတော်မာ နေရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ငါ မှန်တိုင်းပြောမယ်၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို သားဂန်းတယော့‑က်မျိုး လတ်ခံဘဲဟှူလူဟှ နိုင်ငံတော်ဟှို လောင်းဝ ဝမ်ရလေ့ဟှို့ မှုဟှ” ဆိုဘီး တဗဲ့တော်လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","အယ်ဘီးန ကိုယ်တော်ဟှာ သားဂန်းလေဟှို ခီလိုက်ဘီး သူးနို့ထတ်မာ သူ့ရဲ့ လတ်လေဟှို တန်ဟှယ်။ အယ်ဘီးဟှာ သူးနို့ဟှို ကောန်းဂျီးပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ယေရှုဟှ ခရီးစပြုနေဟှူ ခီမာ လူတယော့‑က်ဟှ ပ္လေးလာဘီး၊ ကိုယ်တော်ရှေ့မာ ဒူးထော့‑က်ဘီး “ကောန်းမြတ်ဟှူဆရာ၊ ထာဝရသတ်ဟှို လတ်ခံရဟှို့တွပ် ကျွန်တော့်ဟှ ဖြားဇာလောက်ရဟှို့နူး” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ယေရှုဟှ “နန်ဟှာ ဖြားဖြစ်ကြောန့် ငါ့ဟှို ကောန်းမြတ်ဟှယ် ဆိုဘီး ခေါ်နေရနူး။ ဘုရားသခင် တပါးဟှလွဲဘီး ဖယ်သူလည်း ကောန်းမြတ်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","‘လူ့သတ်ဟှိုသတ်န၊ အီထောန်ရေးဖော့‑က်ပ္လန်န၊ ခိုးန၊ ဖယ်သူ့ဟှိုဘဲ့ဖြစ်ဖြစ် မှားမှားဟှီးန စွပ်စွဲန၊ လီညာန၊ နန့်ရဲ့မိဖဟှို ရိုသေဂေ့’ ဆိုဘီး ပညတ်ဟှားဇာလေဟှို နန်သိဟှယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","အယ်လူဟှ “ဆရာ၊ အယ်ပညတ်ချစ်လေ ဂူလောင်းဟှို ကျွန်တော် ငဲငယ်ဂဒဲဟှ ကျွန်တော်ဟှာ စောန့်ထီးလာဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ယေရှုဟှ အယ်လူဟှို ရှစ်ဟှူစိန စေ့စေ့ကေ့ဘီး “နန့်မာ တခုဘဲ့ လိုနေဟှယ်။ သွားဘီး နန့်မာရှိဇာလေ ဂူလောင်းဟှို ရောန်းလိုက်ဘီးဟှာ ဆင်းရဲသားလေဟှို ပေးလိုက်။ အယ်ဆိုဟှာ နန့်ဟှာ ကောန်းဂန်ဘောင်မာ ဘဏ္ဍာရလေ့မယ်။ အယ်ဘီးမှ လာဘီးဟှာ ငါ့နော့‑က်ဟှို လိုက်ပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","အယ်လူဟှာ အယ်စကားဟှို ကြားရဟှူ ခီမာ။ သူ့ရဲ့ မျစ်နှာဟှာ ညှိုးငယ်ဟှားဟှယ်။ အယ်ဘီးန သူဟှာ ဝန်းနဲပန်းနဲန ထွပ်ဟှားလေဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူဟှာ ရရာတိုင်း ကပ်ပေါဟှူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ယေရှုဟှာ တဗဲ့တော်လေဟှို လှည့်ပတ်ကေ့ဘီးန “ကပ်ပေါဟှူ လူလေတွပ် ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို ဝမ်ရဟှို့ ရရာတိုင်း ခတ်လေ့မယ်!” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","တဗဲ့တော်လေဟှ အယ်စကားလေဟှို အံ့ဩဂေ့ဟှယ်။ အယ်ဘေမဲ့ ယေရှုဟှ ဆစ်ဘီး ပြောလိုက်ဇာဟှ “ငါ့သားမီးလေ၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို ဝမ်ဟှို့တွပ် ရရာတိုင်း ခတ်လေဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ကပ်ပေါဟှူ လူတယော့‑က်ဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို ဝမ်ဟှို့ထတ် ကုလားအုတ် တကောန်ဟှာ အပ်ပေါ့‑က်ထဲဟှို ဝမ်ဟှို့ ပိုဘီး လွယ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","တဗဲ့တော်လေဟှာ ပိုဘီး အံ့ဩဟှားဘီး “အယ်မျိုးဆို ဖယ်သူဟှ ကယ်တန်ရှင်း ခံရနိုင်ဟှို့နူး” ဆိုဘီး ရှင်းရှင်း မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ယေရှုဟှာ သူးနို့လေဟှို စေ့စေ့ကေ့ဘီးဟှာ “အယ်မှုဟှာ လူလေတွပ် ဖြစ်နိုင်ဟှ။ အယ်ဘေမဲ့ ဘုရားသခင်တွပ် ဂူလောင်း ဖြစ်နိုင်ဟှယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ပေတရုဟှ “ကျွန်တော့်လေဟှာ ကိုယ်တော်နော့က်ဟှို လိုက်ဟှို့ ဂူလောင်းဟှို ထားရစ်ဂေ့ဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ယေရှုဟှ “ငါ မှန်းမှန်ကန်းကန် ပြောမယ်။ ငါ့တွပ်န ဧဝံဂေလိတွပ် အီ၊ ညီကိုလေ၊ မောန်နှမလေ၊ မိဖ၊ သားမီးလေ၊ လယ်မ္လေလေဟှို စွန့်ဟှူ လူဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ခုဘဝမာ ဆတရာထတ်ပိုဟှူ အီလေ၊ ညီကိုလေ၊ ညီမလေ၊ မိဖလေ၊ သားမီးလေ၊ လယ်မ္လေလေနတူးဒူ ညှဉ်းဆဲဇာဟှို လတ်ခံရရှိလေ့မယ်။ အယ်ဘီးဟှာ နော့‑က်ဘဝမာလည်း ထာဝရသတ်ဟှို လတ်ခံရရှိလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","အယ်ဘေမဲ့ ရင်ဦးဆောင်း က္လဟှူ သူဘောင်ဂီးဟှ နော့‑က်ဆောင်းက္လလေ့မယ်၊ နော့‑က်ဆောင်း က္လဟှူ သူဘောင်ဂီးဟှ ရင်ဦးဆောင်း က္လလေ့မယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ယေရှုန တဗဲ့တော်လေဟှာ ယေရုရှလင်ဗြို့ဟှို သွားနေဂေ့ဟှယ်။ လမ်းမာယေရှုဟှာ သူးနို့ရှေ့ဟှနေ သွားဟှူကြောန့် တဗဲ့တော်လေဟှာ အံ့ဩနေဂေ့ဟှယ်။ နော့‑က်ဟှ လိုက်လာဟှူ လူလေဟှာလည်း ကြော့‑က်နေဂေ့ဟှယ်။ ယေရှုဟှာ တဗဲ့တော် ဆယ့်နှေ့ယော့‑က်ဟှို သူ့ဘေးနားဟှို တခါ ထပ်ခေါ်ဘီးဟှာ သူ့မာ တွိကြောင်လာရဟှို့ ဇာလေဟှို ပြောပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ကိုယ်တော်ဟှ “နားထောန်ဂေ့။ နို့လေဟှာ ခု ယေရုရှလင်ဗြို့ဟှို သွားနေဂေ့ဘီး အယ်နေရာမာ လူ့ရဲ့သားဟှာ ယဇ်ပုရောဟိတ်ဂီးလေန ကျမ်းတတ်ဆရာလေနားဟှို အပ်ဇာဟှို ခံရလေ့မယ်။ သူးနို့ဟှာ သူ့ဟှို သေဒန်စီရင်ဘီးန လူမျိုးခြားလေနားဟှို အပ်ဂေ့လေ့မယ်၊ ");
INSERT INTO tvn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","လူမျိုးခြားလေဟှာ သူ့ဟှို ပြစ်ရယ်ပြုဘီး သူ့ဟှို ထွီးရယ်န ထွီးဘီး၊ သူ့ဟှို ကီဒန်ပေးဘီး သေသတ်ဂေ့လေ့မယ်။ သောင်းရစ်ကြာဘီးန လူ့ရဲ့သားဟှာ သေရာဟှနေ ထမြော့‑က်လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","အယ်ဘီးန ဇေဗေဒဲရဲ့ သားလေဖြစ်ဟှူ ယာကုပ်န ယောဟန်လေဟှာ ယေရှုနားဟှို လာဟှယ်။ သူးနို့ဟှ “ဆရာ၊ ကျွန်တော့်ဟှားလေတွပ် လောက်ပေးစေရှင်ဇာ တခုရှိပါဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ယေရှုဟှ “နန်းနို့တွပ် ဖြားဇာဟှို ငါလောက်ပေးရဟှို့နူး” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","သူးနို့ဟှ “ကျွန်တော့်ဟှားလေဟှို ကိုယ်တော်ရဲ့ ဖောင်းသရေတော်ထဲမာ ညာဖတ်မာ တယော့‑က်န ဘယ်ဖတ်မာ တယော့‑က် ထိုင်ခွမ့်ပေးပါ” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ယေရှုဟှ “နန်းနို့ဟှ ဖြားဇာလေ တောန်းနေဟှယ် ဆိုဇာဟှို နန်းနို့လေ သိဂေ့ဟှ။ ငါသော့‑က်ရမယ့် ဝေဒနာခွပ်ဟှို နန်းနို့ သော့‑က်နိုင်ဘဲ့လော။ ငါခံရမယ့် ဗတ္တိဇံဟှို နန်းနို့ ခံနိုင်ဘဲ့လော” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","သူးနို့ဟှ “ကျွန်တော့်လေဟှာ တတ်စွမ်းနိုင်ဟှယ်” ဆိုဘီး ပ္လန်ဖြေဂေ့ဟှယ်။ ယေရှုဟှ “နန်းနို့ဟှာ ငါသော့‑က်ရမယ့် ခွပ်ဟှို သော့‑က်ရလေ့မယ်။ အယ်ဘီးဟှာ ငါခံရမယ့် ဗတ္တိဇံဟှိုလည်း ခံရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","အယ်ဘေမဲ့ ဖယ်လူဟှာ ငါ့ရဲ့ ညာဖတ်န ဘယ်ဖတ်မာ ထိုင်ရလေ့မယ် ဆိုဇာဟှို ဝီးကော့‑က်ဟှို့ခွမ့် ငါ့မာ မှေ့ဟှ။ ဘုရားသခင် ပြင်ဆင်ဟှားဟှူ လူလေတွပ် အယ်နေရာလေဟှို ကိုယ်တော်ဟှာ ပေးလေ့မယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","အယ်ကြောန်းဟှို တဗဲ့တော်ဆယ်ပါး ကြားဂေ့ဟှူ ခီမာ သူးနို့ဟှာ ယာကုပ်န ယောဟန်ဟှို စိဆိုးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","အယ်ကြောန့် ယေရှုဟှာ သူးနို့လေ ဂူလောင်းဟှို တူးဒူခေါ်ဘီးဟှာ “နန်းနို့လေ သိဟှားမျိုးဘဲ့ မန်းစိုးရာဇာလေဟှာ လူမျိုးခြားလေထတ်မာ အောက်ချောက်ဂေ့ဟှယ်။ ကဲမှူးလေဟှလည်း ခွမ့်အာဏာ ထားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","နန်းနို့လေထဲမာ အယ်မျိုးဖြစ်ဂေ့န။ အယ်မျိုးဖြစ်မယ့်စား ကီးဆောင်းဖြစ်ရှင်ဟှူ ဖယ်လူဘဲ့ဖြစ်ဖြစ် နန်းနို့ထဲမာ စေခံဖြစ်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","အယ်ဘီးဟှာ ကီးဆောင်း ဖြစ်ရှင်ဟှူ ဖယ်လူဘဲ့ဖြစ်ဖြစ် ဂူလောင်းရဲ့ ကျွန်ဖြစ်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လူ့ရဲ့သားဟှာလည်း ခိုင်းစားဟှို့လာဇာ မှုဟှ။ သူဟှာ စေခံဟှို့န သူ့သတ်ဟှို စွန့်ဘီး လူလေဟှို ဝီးနုတွပ် လာဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","သူးနို့ဟှာ ယေရိခေါဗြို့ဟှို ရော့‑က်လာဂေ့ဟှယ်။ အယ်ဘီးဟှာ ယေရှုဟှာ တဗဲ့တော်လေန ကီးမားဟှူ လူအောက်ဂီးနတူးဒူ ထွပ်ဟှားဟှူ ခီမာ တိမဲရဲ့သား ဗာတိမဲ နာမယ်ရှိဟှူ မျစ်ကန်းဒေါန်းဇား တယော့‑က်ဟှာ လမ်းဘေးမာ ထိုင်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","သူဟှာ နာဇရက်ဗြို့သား ယေရှု ဖြစ်ဟှယ် ဆိုဇာဟှို ကြားရဟှူ ခီမာ သူဟှ “ဒါဝိဒ်ရဲ့ သားတော်! ယေရှု! ကျွန်တော့်ဟှို သနားပါ!” ဆိုဘီး စဘီး အော်ဟစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","လူလေဘောင်ဂီးဟှ သူ့ဟှို ပြစ်တန်ဂေ့ဘီး တိတိဟှားနေဟှို့ ပြောဂေ့ဟှယ်။ အယ်ဘေမဲ့ သူဟှ “ဒါဝိဒ်ရဲ့ သားတော်၊ ကျွန်တော့်ဟှို သနားပါ!” ဆိုဘီး ရင်ဟှထတ် က္လယ်ဟှီး အော်ဟစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ယေရှုဟှာ ရပ်လိုက်ဘီးန “သူ့ဟှို ခေါ်ဂေ့” ဆိုဘီး ပြောလေဟှယ်။ အယ်ကြောန့် သူးနို့ဟှာ မျစ်ကန်းဟှို ခေါ်ဂေ့ဟှယ်။ သူးနို့ဟှ “အားငယ်န။ ထဒန်။ နန့်ဟှို ကိုယ်တော် ခေါ်နေဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","အယ်လူဟှာ သူ့ရဲ့ ဝတ်လောင်ဟှို ဘေးဟှို ပစ်ခ္လလိုက်ဘီး၊ ထခူဘီးဟှာ ယေရှုနားဟှို လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ယေရှုဟှ “နန့်တွပ် ဖြားဇာ လောက်ပေးစေရှင် ဟှယ်နူး” ဆိုဘီး သူ့ဟှို မေးလေဟှယ်။ မျစ်စိကန်းဟှူ လူဟှ “ဆရာ၊ ကျွန်တော် ဗြင်ရှင်ဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ယေရှုဟှ “သွားလိုက်၊ နန့်ရဲ့ ယောင်ကြည်ရှင်းဟှာ နန့်ဟှို ကျန်းမာစေဘီ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ရှစ်ရှင်းဘဲ အယ်လူဟှာ မျစ်စိဗြင်ဟှားဘီး လမ်းတရှော့‑က်လောင်း ယေရှု နော့‑က်ဟှို လိုက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","သူးနို့လေဟှာ ယေရုရှလင်ဗြို့န နီးကပ်လာဘီး သံလွင်တောန်မာရှိဟှူ ဗက်ဖာဂေဝါန ဗေသနိဝါဟှို ရော့‑က်လာဂေ့ဟှူ ခီမာ ယေရှုဟှာ တဗဲ့တော် နှေ့ယော့‑က်ဟှို စေလွတ်ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","သူးနို့ဟှို ပြောနေဇာဟှ “နန်းနို့ရှေ့မာရှိဟှူ ဝါဟှိုသွားဂေ့။ နန်းနို့ဟှာ အယ်နေရာဟှို ရော့‑က်ရော့‑က်ရှင်း ဖယ်သူလည်း စီးဖူးသေးဘဲဟှူ မြည်းသားဂန်း တကောန်ဟှို ခယ်ဟှားဇာဟှို နန်းနို့ တွိလေ့မယ်။ အယ်မြည်းဟှို ကြိုးဖြေဘီးဟှာ ယူလာဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","နန်းနို့ဟှို ယော့‑က်ယော့‑က်ဟှ ‘ဖြားဖြစ်ကြောန့် အယ်မျိုး လောက်ရဟှယ်နူး’ ဆိုဘီး မေးမယ် ဆိုဟှာ ‘သခင် လိုရှိဟှယ်။ အယ်နေရာဟှို ရှစ်ရှင်း ပ္လန်ပို့ပေးလေ့မယ်’ ဆိုဘီး ပြောဂေ့” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","အယ်ကြောန့် သူးနို့ဟှာ ထွပ်ဟှားဘီး လမ်းဘေးဟှ အီခွဗော့‑က်မာ ခယ်ဟှားဟှူ မြည်းသားဂန်း တကောန်ဟှို တွိဂေ့ဟှယ်။ သူးနို့ဟှာ မြည်းဟှို ကြိုးဖြေနေဟှူ ခီမာ ");
INSERT INTO tvn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","လမ်းမာရပ်နေဟှူ လူတချို့ဟှ “နန်းနို့ဟှ ဖြားဖြစ်ကြောန့် အယ်မြည်းဟှို ကြိုးဖြေနေဂေ့နူး” ဆိုဘီး သူးနို့ဟှို မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","သူးနို့ဟှ ယေရှုပြောလိုက်တိုင်း ပ္လန်ဖြေဂေ့ဟှယ်။ အယ်ဆိုန အယ်လူလေဟှာ သူးနို့ဟှို သွားခွမ့်ပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","သူးနို့ဟှာ မြည်းသားဂန်းဟှားဟှို ယေရှုနားဟှို ခေါ်ဆောန်လာဘီး မြည်းထတ်မာ သူးနို့ဝတ်လောင်ဟှို တန်လိုက်ဂေ့ဟှယ်။ အယ်ဘီးဟှာ ယေရှုဟှာ မြည်းဟှို စီးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","လူလေ ဘောင်းဂီးဟှလည်း သူးနို့ ဝတ်လောင်လေဟှို လမ်းမာ ခမ်းဂေ့ဟှယ်။ တချို့လူလေဟှာ ကွမ်းပ္လန်ထဲဟှနေ သစ်ခတ်လေဟှို ခွတ်ဘီး လမ်းမာခမ်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ရှေ့မာရှိဟှူ လူလေန နော့‑က်ဟှ လိုက်လာဟှူ လူလေဟှာ “ဟောရှဏ္ဏ! ဘုရားသခင်ရဲ့ နာမန ကြွလာဟှူ သခင်ဟှာ မင်္ဂလာရှိပါစေ! ");
INSERT INTO tvn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ကြွလာနေဟှူ နို့လေဖ ဒါဝိဒ်ရဲ့ နိုင်ငံတော်ဟှာ မင်္ဂလာရှိပါစေ! ဗြင့်ဆောင်းမာ ဟောရှဏ္ဏ ဖြစ်ပါစေ! ဆိုဘီး ချီးမွမ်းဂေ့ဟှယ်!” ");
INSERT INTO tvn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ယေရှုဟှာ ယေရုရှလင်ဗြို့ထဲဟှို ဝမ်ဘီး ဗိမာန်တော်ထဲဟှို ကြွဟှားဟှယ်။ အယ်ဘီးဟှာ ရာရာဟှို ကေ့တော်မူဟှယ်။ အယ်ဘေမဲ့ နေဝမ်ဟှားဘီ ဖြစ်ဟှူကြောန့် တဗဲ့တော် ဆယ့်နှေ့ပါးနတူးဒူ ဗေသနိဝါဟှို သွားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","နော့‑က်တနေ့မာ သူးနို့ဟှာ ဗေသနိဝါဟှနေ ပ္လန်လာဂေ့ဟှူ ခီမ ယေရှုဟှ ဗိုက်ဆာနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ကိုယ်တော်ဟှာ ဝပ်လေန ဖောင်းနေဟှူ သဖန်းဗန်ဟှို ဝီးဟှနေ ဗြင်လေဟှယ်။ အယ်ကြောန့် သီးတွိနိုင်ဟှယ် ဆိုဘီး ပန်နားဟှို သွားလိုက်ဟှယ်။ အယ်ဘေမဲ့ ပန်နားဟှို ရော့‑က်ဟှားဟှူ ခီမာ သဖန်းသီးဆွပ်ဟှို့ခီ ရော့‑က်သေးဘဲဟှူကြောန့် ဝပ်လေဘဲ့ တွိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","အယ်ဆိုန ယေရှုဟှ “နန့်ရဲ့ သီးဟှို ကာလစဉ်ဆစ် ဖယ်သူလဲ စားရစေန!” ဆိုဘီး သဖန်းဗန်ဟှို မိန့်တော်မူလေဟှယ်။ တဗဲ့တော်လေလည်း ကြားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","သူးနို့ဟှာ ယေရုရှလင်ဗြို့ဟှို ရော့‑က်ဟှားဟှူ ခီမာ ယေရှုဟှာ ဗိမာန်တော်ဟှို သွားဘီးဟှာ ရောန်းဝယ်နေဟှူ လူလေဟှို စဘီးဟှာ နှန်ထုလေဟှယ်။ ကိုယ်တော်ဟှာ ကပ်လဲမားလေရဲ့ ဗွဲလေန ချိုးငှတ်ရောန်းနေဟှူ ထိုင်ခေါင်လေဟှိုလည်း မှော့‑က်ပစ်လိုက်ဘီး ");
INSERT INTO tvn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","သူဟှာ ဗိမာန်တော်ဝမ်းဟှို ဖြတ်ကူးဘီး ကူပစ်စီးလေ ရောန်းဝယ်ဟှို့တွပ် ဖယ်သူ့ဟှိုလည်း ခွမ့်ပေးဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","အယ်ဘီးန ကိုယ်တော်ဟှာ လူလေဟှို သွန်သန်ဇာဟှ “‘ငါ့ရဲ့ အီတော်ဟှို လူမျိုးအားလောင်းတွပ် ဆုတောန်းအီ ဆိုဘီး ခေါ်ခံရလေ့မယ်’ ဆိုဘီး ကျမ်းစာမာ ရေးဟှားဟှယ်မှုလော။ အယ်ဘေမဲ့ နန်းနို့ဟှာ အယ်အီတော်ဟှို မ္လလေတွပ် နေရာဖြစ်ခိုင်းဂေ့ဟှယ်!” ");
INSERT INTO tvn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ယဇ်ပုရောဟိတ်ဂီးလေန ကျမ်းတတ်ဆရာလေဟှာ အယ်ဇာဟှို ကြားဟှားဂေ့ဟှယ်။ အယ်ကြောန့် ယေရှုဟှို သတ်ဟှို့တွပ် စဘီးဟှာ နည်းလမ်းရှာဂေ့ဟှယ်။ လူအောက်ဂီး တခုလောင်းဟှာ ကိုယ်တော်ရဲ့ သွန်သန်ဇာဟှို အံ့ဩဟှားဟှူကြောန့် သူးနို့ဟှာ ကိုယ်တော့်ဟှို ကြော့‑က်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ညဉ့်မိုက်လာဟှူ ခီမာ ယေရှုန တဗဲ့တော်လေဟှာ ဗြို့ပ္လန်ဟှို ထွပ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","သူးနို့ဟှာ နော့‑က်တနေ့ မိုးလန်းစောစောဂီး လမ်းရှော့‑က်ဟှားဂေ့ဟှူ ခီမာ ပြစ်ဟှနေဘီး ခြော့‑က်နေဟှူ သဖန်းဗန်ဟှို သူးနို့ဟှာ ဗြင်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ပေတရုဟှ ဒိရဟှားဘီး ယေရှုဟှို “ဆရာ၊ ကေ့လိုက်ဂေ့! ကိုယ်တော် ကီဆဲလိုက်ဟှူ သဖန်းဗန်ဟှာ ခြော့‑က်ဟှားဘီ!” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ယေရှုဟှ “ဘုရားသခင်ဟှို ယောင်ကြည်ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ငါ မှန်းမှန်ကန်းကန် ပြောမယ်။ ဖယ်လူဘဲ့ဖြစ်ဖြစ် အယ်တောန်ဟှို ‘အယ်နေရာဟှနေ ရွေ့ဘီး ပန်လယ်ထဲဟှို က္လလော’ ဆိုဘီး သူ့ရဲ့ စိနှလောင်းထဲမာ သံသယမှေ့ဘဲ့ ယောင်ကြည်ဘီး ပြောမယ် ဆိုဟှာ အယ်တိုင်းဘဲ့ ဖြစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","အယ်ကြောန့် နန်းနို့ဟှို ငါပြောမယ်။ နန်းနို့ဟှာ တခုခုတွက် ဆုတောန်းဘီး တောန်းရှော့‑က်ဟှူ ခီမာ အယ်ဇာဟှို ရပီးဘီး ဆိုဘီး နန်းနို့ ယောင်ကြည်ဂေ့။ အယ်ဆိုဟှာ နန်းနို့ ဖြားဇာဘဲ့ တောန်းတောန်း ရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","နန်းနို့လေဟှာ ရပ်ဘီး ဆုတောန်းဟှူ ခီမာ နန်းနို့မာ ယော့‑က်ယော့‑က်ဟှို ပြစ်မှားဇာ တခုခုရှိမယ် ဆိုဟှာ အယ်လူဟှို ခွမ့်လွှတ်ဂေ့။ အယ်ဆိုဟှာ ကောန်းဂန်ဘောင်ဟှ နန်းနို့ဖလည်း နန်းနို့လေရဲ့ ပြစ်ဟှို လွှတ်ပေးလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","သူးနို့ဟှာ ယေရုရှလင်ဗြို့ဟှို နော့‑က်တခါ ရော့‑က်ဟှားဂေ့ဟှယ်။ ယေရှုဟှာ ဗိမာန်တော်ထဲမာ လမ်းရှော့‑က်နေဟှူ ခီမာ ယဇ်ပုရောဟိတ်ဂီးလေ၊ ကျမ်းတတ်ဆရာလေန သတ်ကီးဝါးဂီးလေဟှာ ကိုယ်တော်နားဟှို လာဂေ့ဘီး ");
INSERT INTO tvn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ကိုယ်တော့်ဟှို “အယ်မှုဇာလေဟှို ဖြားခွမ့်အာဏာန လောက်နေနူး။ အယ်ခွမ့်အာဏာဟှို ဖယ်သူဟှပေးနူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ယေရှုဟှ “နန်နို့ဟှို ငါ မေးခွန်းတခု မေးမယ်။ နန်းနို့ဟှာ ငါ့ဟှို ဖြေပေးမယ် ဆိုဟှာ အယ်မှုဇာလေဟှို လောက်ဟှို့ ငါ့မာ ဖြားခွမ့်အာဏာ ရှိဟှယ် ဆိုဇာဟှို ငါပြောမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ဗတ္တိဇံပေးဟှို့တွပ် ယောဟန်ရဲ့ ခွမ့်အာဏာဟှာ ကောန်းဂန်ဟှနေ ဖြစ်ဇာလော။ လူဟှနေဖြစ်ဇာလော။ ငါ့ဟှိုဖြေဂေ့!” ဆိုဘီး ပ္လန်မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","သူးနို့ရှင်းရှင်း စဘီး ဆွေးနွေးဂေ့ဇာဟှ “နို့လေဟှ ဖြားမျိုးပြောရဟှို့နူး။ ‘ကောန်းဂန်ဟှနေ ဖြစ်ဟှယ်’ ဆိုဘီး နို့လေဖြေမယ် ဆိုဟှာ ‘အယ်ဆိုဟှာ ဖြားဖြစ်ကြောန့် နန်းနို့ဟှ ယောဟန်ဟှို ယောင်ကြည်ဂေ့ဟှနူး’ ဆိုဘီး သူဟှာ ပြောလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‘လူဟှနေဖြစ်ဟှယ် …’ ဆိုဘီး နို့လေ ဖြေမယ် ဆိုဟှာ” သူးနို့လေဟှာ လူလေဟှို ကြော့‑က်ဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ယောဟန်ဟှို ပရောဖက်မှန် ဖြစ်ဟှယ် ဆိုဘီး လူတိုင်းဟှ မှတ်ယူဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","အယ်ကြောန့် သူးနို့ဟှာ “ကျွန်တော့်ဟှားလေ သိဟှ” ဆိုဘီး ယေရှုဟှို ဖြေလိုက်ဂေ့ဟှယ်။ ယေရှုဟှ “အယ်ဆိုဟှာ အယ်မှုဇာလေဟှို ဖြားခွမ့်အာဏာန ငါလောက်ဟှယ် ဆိုဇာဟှိုလည်း ငါပြောဟှ” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","အယ်ဘီးန ယေရှုဟှာ သူးနို့ဟှို ပေါင်ဥပမာန စဘီးပြောလိုက်ဇာဟှ “လူတယော့‑က်ဟှာ စဗျစ်ခြံဟှို တည်ဘီး၊ ခြံစည်းရိုး ပတ်ပတ်လည်ရံဘီး စဗျစ်သီးနယ်ဟှို့တွပ် တွမ်းဟှိုလည်း တူးလေဟှယ်။ အယ်ဘီးဟှာ မျှော်စင်ဟှို ဆော့‑က်ဟှယ်။ အယ်ဘီးန သူဟှာ စပျစ်ခြံလောက်မားလေ တချို့ဟှို ငှါးရစ်ဘီးဟှာ ခရီးထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","စဗျစ်သီးဆွတ်ဟှူခီ ရော့‑က်လာဟှူ ခီမာ စဗျစ်ခြံဟှ သီးတချို့ဟှို ယူဟှို့တွပ် ကျွန်တယော့‑က်ဟှို ခြံလောက်မားလေနားဟှို လွှတ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ခြံလောက်မားလေဟှာ အယ်ကျွန်ဟှို ဖမ်းဘီး ရိုက်လေဟှယ်။ အယ်ဘီးဟှာ လတ်ခဲခဲ ပ္လန်လွှတ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","အယ်ဆိုန ဇရှင်ဟှာ နော့‑က်ထပ် ကျွန်တယော့‑က်ဟှို လွှတ်လေဟှယ်။ ခြံလောက်မားလေဟှာ အယ်ကျွန်ဟှို ခေါန်းရိုက်ခွဲဘီး ရှစ်ကွဲအောန် လောက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ဇရှင်ဟှာ နော့‑က်ထပ် ကျွန်တယော့‑က်ဟှို လွှတ်လေဟှယ်။ အယ်ဆိုန အယ်တယော့‑က်ဟှိုလည်း သူးနို့ဟှ သတ်ဂေ့ဟှယ်။ အယ်ဘီးဟှာ တခြားကျွန်လေ ဘောင်းဂီးဟှိုလည်း တချို့ဟှို ရိုက်ဂေ့ဘီး တချို့ဟှို သတ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","အယ်လူရဲ့ ရှစ်ဆောင်းသား တယော့‑က်ဒဲဘဲ့ စေလွှတ်ဟှို့ ကျန်လေဟှယ်။ သူဟှ ‘သူးနို့လေဟှာ ငါ့ရဲ့ သားဟှို လေးစားဂေ့လေ့မယ်’ ဆိုဘီး ပြောဘီးန နော့‑က်ဆောင်းမာ သူ့ရဲ့ သားဟှို ခြံလောက်မားလေနားဟှို စေလွှတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","အယ်ဘေမဲ့ အယ်ခြံလောက်မားလေဟှ ‘အယ်လူဟှာ ဇရှင်ရဲ့ မွီစားမွီခံ ဖြစ်ဟှယ်။ လာဂေ့။ သူ့ဟှို သတ်ဂေ့ဇို့။ အယ်ဆိုဟှာ သူ့ရဲ့မွီအောက်စာဟှာ နို့လေရဲ့ အောက်စာ ဖြစ်ဟှားလေ့မယ်!’ ဆိုဘီး ရှင်းရှင်း ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","အယ်ကြောန့် သူးနို့ဟှာ သူ့ဟှို ဖမ်းဘီးဟှာ သတ်လိုက်လေဟှယ်။ အယ်ဘီးန စဗျစ်ခြံပ္လန်ဟှို ပစ်ဟှားလိုက်ဂေ့ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“အယ်ဆိုဟှာ စပျစ်ခြံဇရှင်ဟှ ဖြားမျိုး လောက်လေ့မယ်နူး။ သူဟှာ လာဘီး အယ်ခြံလောက်မားလေဟှို သတ်ပစ်လိုက်ဘီးဟှာ စဗျစ်ခြံဟှို တခြားလူလေဟှို ပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","အယ်ကျမ်းစာဟှို နန်းနို့ဟှာ သေးသေချားချာဟှား ဖတ်ဂေ့ဟှလော။” “‘သောင်းဝမ်ဟှ ဆိုဘီးဟှာ တိုက်ဆောက်မားလေ ဖယ်ဟှားဟှူက္လော့‑က်ဟှာ ရေးကီးဆောင်းဟှူ ဒေါန့်ချောက်က္လော့‑က် ဖြစ်လာရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","အယ်ဇာဟှာ ဘုရားသခင်အားဖြင့် ဖြစ်လာဟှယ်။ နို့လေရှေ့မာ အံ့ဩဘွယ်ဖြစ်ဟှယ်!’ ” ");
INSERT INTO tvn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","အယ်န သူးနို့လေဟှာ ယေရှုဟှို ဖမ်းဟှို့ ကြိုးစားဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကိုယ်တော်ဟှာ သူးနို့ဟှို စောန်းဘီးဟှာ အယ်ဥပမာဟှို ပြောလိုက်ဟှယ် ဆိုဇာဟှို သူးနို့ဟှာ သိဂေ့ဟှယ်။ အယ်ဘေမဲ့ သူးနို့ဟှာ လူအောက်ဂီးဟှို ကြော့‑က်ဂေ့ဟှယ်။ အယ်ကြောန့် ကိုယ်တော့်ဟှို ထားရစ်ဘီး ထွပ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","အယ်ဘီးန သူးနို့ဟှာ ကိုယ်တော်ရဲ့ စကားထဲမာ ကိုယ်တော့်ဟှို ဖမ်းဟှို့တွပ် ဖာရိရှဲတချို့န ဟေရုဒ်ရဲ့လူလေတချို့ဟှို ယေရှုနားဟှို လွှတ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","အယ်လူလေဟှာ ယေရှုနားဟှို လာဘီး “ဆရာ၊ ကိုယ်တော်ဟှာ လူလေဖြားမျိုးဘဲ့ထန်ထန် စိုးရိမ်မှုမှေ့ဘဲန မှန်တိုင်းဘဲ့ ပြောဟှယ် ဆိုဇာဟှို ကျွန်တော့်ဟှားလေ သိဂေ့ဟှယ်။ ကိုယ်တော်ဟှာ ဖယ်လူရဲ့ မျစ်နှာဟှိုလည်း ကေ့ဘဲ့န လူလေတွပ် ဘုရားသခင်ရဲ့ လိုတော်ဟှို မှန်တိုင်း သွန်သန်လေဟှယ်။ ကဲသာမန်းဂီးဟှို ခွန်ပေးဇာဟှာ ကျွန်တော့်ဟှားလေရဲ့ ပညတ်တရားဟှို ဆန့်ကျင်နေဇာလော။ ကျွန်တော့်ဟှားလေဟှာ ခွန်ပေးသင့်လော။ ပေးသင့်ဟှလော” ဆိုဘီး မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","အယ်ဘေမဲ့ ယေရှုဟှာ အယ်လူလေရဲ့ ဟန်ဆောန်ဇာဟှို သိဟှူကြောန့် “နန်းနို့ဟှ ငါဟှို ဖြားဖြစ်ကြောန့် ထောန်ချော့‑က်ဆင်ဟှို့ ကြိုးစားဂေ့နူး” ဆိုဘီး မေးလေဟှယ်။ “ဒေနာရိတပ္လားဟှို ယူလာဂေ့၊ ငါကေ့ကေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","သူးနို့ဟှာ ဒန်းဂါးဟှို ယူလာဂေ့ဟှယ်။ အယ်ဆိုန ကိုယ်တော်ဟှ “အယ်ဇာဟှ ဖယ်လူရဲ့ရောက်ပေါင်နူး။ အယ်ဘီးဟှာ ဖယ်လူရဲ့လိစာနူး” ဆိုဘီး မေးလေဟှယ်။ သူးနို့ဟှ “ကဲသာရဲ့ ရောက်ပေါင်န လိစာ ဖြစ်ဟှယ်” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","အယ်ကြောန့် ယေရှုဟှာ “ကဲသာန ဆိုင်ဇာဟှို ကဲသာဟှို ပေးဂေ့။ ဘုရားသခင်န ဆိုင်ဇာဟှို ဘုရားသခင်ဟှို ပေးဂေ့” ဆိုဘီး သူးနို့လေဟှို မိန့်တော်မူလေဟှယ်။ အယ်ဆိုန သူးနို့လေဟှာ ယေရှုဟှို အံ့ဩဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","အယ်ဘီးန သေရာဟှနေ ထမြော့‑က်ဇာ မှေ့ဟှ ဆိုဘီး ပြောဟှူ ဇဒ္ဒုကဲတချို့ဟှာ ယေရှုနားဟှို လာဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ဆရာ၊ ‘လူတယော့‑က်ဟှာ သားမီးလေမှေ့ဘဲန သေဟှားဘီး မယားဟှို ထားရစ်မယ် ဆိုဟှာ၊ အယ်လူရဲ့ညီဟှာ အယ်မောက်ဆိုးမဟှို ယူရမယ် အယ်ဘီးဟှာ သူးနို့မာ ရလာဟှူ သားမီးလေဟှို သူ့နောန်ရဲ့သားမီးလေ ဆိုဘီး မှတ်ယူရမယ်’ ဆိုဘီး အယ်ပညတ်တရားဟှို ကျွန်တော့်လေတွပ် မောရှေဟှ ရေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ညီကိုခွန်နစ်ယော့‑က်ရှိဘီး၊ နောန်ဂီးဟှာ မီးမယူဘီးဟှာ သားမီးလေမှေ့ဘဲန သေဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","အယ်ဆိုန ဒုတိယညီဟှာ အယ်မီးမဟှို ယူလိုက်ဟှယ်။ သူလည်းဘဲ့ သားမီးလေမှေ့ဘဲန သေဟှားဟှယ်။ တတိယညီဟှာလည်း အယ်မျိုးဘဲ့ဖြစ်ဘီး ");
INSERT INTO tvn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ညီကို ခွန်နစ်ယော့‑က်လောင်းဟှာ အယ်မီးမဟှို ယူဘီး သားမီးလေမှေ့ဘဲန သေဟှားဂေ့ဟှယ်။ နော့‑က်ဆောင်းမာ အယ်မီးမဟှလည်း သေဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ရှင်ပ္လန်ထမြော့‑က်နေ့မာ ဂူလောင်းဟှာ ထမြော့‑က်ဟှူ ခီမာ အယ်မီးမဟှာ ဖယ်လူရဲ့ မယားဖြစ်မယ်နူး။ သူးနို့ ခွန်နစ်ယော့‑က်လောင်းဟှာ အယ်မီးမဟှို ယူဟှားဂေ့ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ယေရှုဟှ “နန်းနို့ဟှာ ကျမ်းစာဟှိုလည်း သိဂေ့ဟှ။ ဘုရားသခင်ရဲ့ တဂိုးတော်ဟှိုလည်း သိဂေ့ဘဲဟှူကြောန့် အယ်မျိုးယူလွဲနေဂေ့ဟှယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လူလေဟှာ သေရာဟှနေ ထမြော့‑က်ဟှူ ခီမာ သူးနို့ဟှာ အီထောန်ပြုဇာမှေ့ဘဲန ကောန်းဂန်ဘောင်မာ ကောန်းဂန်တမန်လေမျိုး ဖြစ်ဟှားလေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","သေဟှားဟှူလူလေ ထမြော့‑က်ရှင်းန ပတ်သတ်ဘီး မောရှေရဲ့ကျမ်းမာ မီးလောန်နေဟှူ ချောင်နဆိုင်ဟှူ ကျမ်းပိုဒ်ဟှို ဖတ်ဖူးဂေ့ဟှလော့။ အယ်ကျမ်းမာ ရေးဟှားဇာဟှ ဘုရားသခင်ဟှာ ‘ငါဟှာ အာဗြဟံရဲ့ ဘုရားသခင်၊ ဣဇာက်ရဲ့ ဘုရားသခင်၊ ယာကုပ်ရဲ့ ဘုရားသခင် ဖြစ်ဟှယ်’ ဆိုဘီး မောရှေဟှို ပြောဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","အယ်သခင်ဟှာ သေဟှားဟှူ လူလေရဲ့ ဘုရားသခင် မှုဟှ။ သတ်ရှင်နေဟှူ လူလေရဲ့ ဘုရားသခင်ဖြစ်ဟှယ်။ နန်းနို့ဟှာ ရရာတိုင်း ယူလွဲနေဂေ့ဟှယ်!” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","အယ်နေရာမာ ဆွေးနွေးဟှားဇာလေဟှို ကြားဟှားဟှူ ကျမ်းတတ်ဆရာ တယော့‑က် ရှိနေဟှယ်။ ယေရှုဟှာ ဇဒ္ဒုကဲလေဟှို ကောန်းဟှူ ဖြေဟှို ပေးလိုက်ပီးဘီ ဆိုဇာဟှို သူဗြင်ဟှာဘီး ကိုယ်တော့်ဟှို “ပညတ်လေ ဂူလောင်းထဲမာ ဖယ်ပညတ်ဟှာ ရေးကီးဆောင်းဖြစ်နူး” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ယေရှုဟှ “ရေးကီးဆောင်း ပညတ်ဟှာ ‘ဣသရေလ လူမျိုးလေ၊ နားထောန်ဂေ့! နို့လေရဲ့ သခင် ဘုရားသခင်ဟှာ တဆူဒဲရှိဟှူ ဘုရားသခင် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","နန့်ရဲ့ သခင်၊ ဘုရားသခင်ဟှို စိနှလောင်းစွမ်းရှိမျှ၊ စိဝိညာဉ်စွမ်းရှိမျှ၊ ဉာဏ်စွမ်းရှိမျှ၊ ကိုယ်စွမ်းရှိမျှ ရှစ်ပါ။’ ");
INSERT INTO tvn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","‘နန့်ရဲ့ အီဇနီးရှင်းဟှို နန့်ကိုယ်နန် ရှစ်မျိုး ရှစ်ပါ’ ဆိုဇာဟှာ ဒုတိယ ရေးကီးဆောင်း ပညတ်ဖြစ်ဟှယ်။ အယ်ပညတ် နှေ့ခုထတ် ပိုဘီး ရေးကီးဟှူ ပညတ် မှေ့ဟှ” ဆိုဘီး ယေရှုဟှ ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ကျမ်းတတ်ဆရာဟှ ယေရှုဟှို “မှန်ပါဟှယ် ဆရာ! ဘုရားသခင်ဟှာ တဆူဒဲဘဲ့ရှိဘီး ဘုရားသခင်မှတပါး တခြားဘုရား မှေ့ဟှ ဆိုဘီး ဆရာပြောဇာဟှာ မှန်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ဘုရားသခင်ဟှို စိနှလောင်းစွမ်းရှိဟှူမျှ၊ ဉာဏ်စွမ်းရှိမျှ၊ ကိုယ်စွမ်းရှိမျှန ရှစ်ပါ။ အယ်ဘီးဟှာ နန့်ရဲ့ အီဇနီးရှင်းဟှို နန့်ကိုယ်နန် ရှစ်မျိုးဘဲ့ ရှစ်ပါ ဆိုဇာဟှာ ဘုရားသခင်ဟှို ပူဇော်ဟှူ မီးရှို့ယဇ်န တခြားယဇ် ဂူလောင်းထတ် ပိုဘီး ရေးကီးဟှယ်” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","အယ်လူရဲ့ဖြေဟှာ ရရာတိုင်း ပညာရှိဟှယ် ဆိုဇာဟှို ယေရှု ဗြင်ဟှားဟှူ ခီမာ ကိုယ်တော်ဟှ “နန်ဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်န ဝီးဟှ” ဆိုဘီး သူးဟှို မိန့်တော်မူလေဟှယ်။ အယ်ဘီးန ဖယ်သူဟှလည်း ယေရှုဟှို ထပ်ဘီး မေးခွန်းလေဟှို မေးရဲဂေ့ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ယေရှုဟှ ဗိမာန်တော်မာ သွန်သန်နေဟှူ ခီမာ ကိုယ်တော်ဟှ “ခရစ်တော်ဟှာ ဒါဝိဒ်ရဲ့သားမ္လေး ဖြစ်ဟှယ် ဆိုဘီး ကျမ်းတတ်ဆရာလေဟှ ဖယ်မျိုးပြောနိုင်ဂေ့နူး။ ");
INSERT INTO tvn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ဒါဝိဒ်ကိုယ်တိုင် သန့်ရှင်းဟှူဝိညာဉ်တော်အားဖြင့် ပြောဟှားဇာဟှ၊ “‘ဘုရားသခင်ဟှ ငါ့သခင်ဟှို ပြောဟှယ်။ နန့်ရဲ့ ရန်သူလေဟှို နန့်ရဲ့ ခေဖွားအော့‑က်မာ ခ္လဟှားခန်ထိ ငါ့ရဲ့ ညာဖတ်မာ ထိုင်နေပါ။’ ” ");
INSERT INTO tvn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“ဒါဝိဒ်ကိုယ်တိုင်ဟှ ကိုယ်တော့်ဟှို ‘သခင်’ ဆိုဘီး ခေါ်ဟှယ်။ ဖယ်မျိုး ဖြစ်ဟှူကြောန့် မေရှိယဟှာ ဒါဝိဒ်ရဲ့ သားမ္လေး ဖြစ်နိုင်ဟှို့နူး” ဆိုဘီး ကြေညာလေဟှယ်။ လူအောက်ဂီးဟှာ ယေရှုရဲ့ စကားဟှို ဝန်းသာအားရ နားထောန်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","အယ်မျိုး သွန်သန်နေဟှူ ခီမာ ယေရှုဟှ “ကျမ်းတတ်ဆရာလေဟှို ဒိထားဂေ့။ သူးနို့ဟှာ ဝတ်လောင်ရှယ်လေဟှို ဝတ်ဘီးဟှာ ရှော့‑က်သွားရဇာ ကြိုက်ဂေ့ဘီး ဆေးလေမာ ရိုသေပေးဇာဟှို ခံရှင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ဝါလယ်ဇရပ်လေမာ သီးသပ်ထားဟှားဟှူ ထိုင်ခေါင်လေ၊ စားသော့‑က်ဗွဲလေမာလည်း ကောန်းဆောင်း နေရာလေဟှို ဝီးကော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","မောက်ဆိုးမလေရဲ့ အီလေဟှို တရားဘဲဟှူနည်းန သီးယူဟှယ်။ အယ်ဘီးဟှာ လူကြားကောန်းအောန် ရှယ်ဟှီး ဆုတောန်းဂေ့ဟှယ်။ သူးနို့ရဲ့ ပြစ်ဒန်ဟှာ ပိုဘီး ဆိုးလေ့မယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ယေရှုဟှာ ဗိမာန်တော် လှူခံဗောင်းရှေ့မာ ထိုင်နေဟှူ ခီမာ လှူခံဗောင်းထဲဟှို လူလေဟှာ ကပ်ထဲ့နေဇာဟှို ကေ့ရှုနေဟှယ်။ ကပ်ပေါဟှူ လူလေဘောင်ဂီးဟှာ ကပ်ဘောင်ဂီး ထဲ့ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","အယ်ဘေမဲ့ ဆင်းရဲဟှူ မောက်ဆိုးမတယော့‑က်ဟှာ လာဘီးဟှာ တပဲလော့‑က်ဘဲ့တန်ဘီး ရရာတိုင်း နဲဟှူ ကြေးပ္လား နှေ့ပ္လားဟှို ထဲ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ယေရှုဟှာ တဗဲ့တော်လေဟှို ခေါ်ဘီးဟှာ “နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ အယ်ဆင်းရဲဟှူ မောက်ဆိုးမဟှာ လှူခံဗောင်းထဲဟှို ထဲ့ဝမ်ဂေ့ဟှူလူလေ ဂူလောင်းထတ် ပိုဘီး ဟှာ ထဲ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်လူလေ ဂူလောင်းဟှာ သူးနို့ရဲ့ ကြွယ်ဝဇာလေထဲဟှ နုဘီး ထဲ့ဂေ့ဟှယ်။ အယ်မီးမဟှာ ရရာတိုင်း ဆင်းရဲဘေမဲ့လည်း သူဟှာ သတ်မွီးဟှို့ အောက်စာ ဂူလောင်းဟှို ထဲ့လေဟှယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ယေရှုဟှာ ဗိမာန်တော်ဟှနေ ထွပ်ဟှားနေဒူးမာ၊ တဗဲ့တော်လေထဲဟှ တယော့‑က်ဟှ “ဆရာ၊ ကေ့ကေ့! ရရာတိုင်းအံ့ဩဘွယ်ကောန်းဟှူ က္လော့‑က်တောင်းလေန ဆော့‑က်ဦးလေ!” ဆိုဘီး ကိုယ်တော့်ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ယေရှုဟှ “အယ်ဆော့‑က်ဦးဂီးလေဟှို နန်းနို့ ဗြင်ဘဲ့လော။ က္လော့‑က်တောင်းလေ တလောင်းလည်း အယ်ဆော့‑က်ဦးရဲ့ ရင်နေရာမာ ကျန်ဂေ့ဟှို့ မှုဟှ။ က္လော့‑က်တောင်းလေ အားလောင်း ပြိုက္လလေ့မယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ယေရှုဟှာ သံလွင်တောန်ထတ်မာ ဗိမာန်တော်ဖတ်ဟှို မျစ်နှာမူဘီး ထိုင်နေဟှူ ခီမာ ပေတရု၊ ယာကုပ်၊ ယောဟန်န အန္ဒြေလေဟှာ ကိုယ်တော်နားဟှို တိတိဟှား လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","သူးနို့လေဟှ “အယ်ဇာလေဟှ ဖယ်ခီမာ ဖြစ်လာလေ့မယ် ဆိုဇာဟှို ကျွန်တော့်ဟှားလေဟှို ပြောပြပါ၊ အယ်ဘီးဟှာ အယ်ဇာလေ အားလောင်း ပ္လဲ့ဇောင်ဟှို့ ဖြားနိမိတ် ဖြစ်လာလေ့မယ် ဆိုဇာဟှို ကျွန်တော့်ဟှားလေဟှို ပြောပြပါ” ဆိုဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ယေရှုဟှ “နန်းနို့ဟှို ဖယ်သူလည်း လှည့်ဇားနိုင်အောန် ဒိထားဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","လူလေဘောင်ဂီးဟှာ ငါ့နာမန ရော့‑က်လာဘီး ပြောဇာဟှ ‘ငါ့ဟှာ အယ်လူဘဲ့ ဖြစ်ဟှယ်!’ ဆိုဘီး လူလေဘောင်ဂီးဟှို လှည့်ဇားဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","နန်းနို့လေဟှာ စစ်ပွဲလေန စစ်ပွဲဒန်းလေဟှို ကြားရဟှူ ခီမာ ထိလန့်ဟှားဂေ့န။ အယ်ဇာလေဟှ ဖြစ်ရမယ်။ အယ်ဘေမဲ့ ဆောင်းဟှာရော့‑က်သေးဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","လူမျိုးလေဟှာ သူးနို့ရှင်းရှင်း တိုက်ခိုက်လေ့မယ်။ နိုင်ငံလေဟှာ သူးနို့ရှင်းရှင်း တိုက်ခိုက်လေ့မယ်။ နေရာတိုင်းမာလည်း မ္လေငလျင်လေ လှော့‑က်လေ့မယ်။ အယ်ဘီးဟှာ စားဇာ ရှားပါးလေ့မယ်။ အယ်ဇာလေဟှာ သားမွီးဟှူ ဝေဒနာရဲ့ စဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“နန်းနို့ ကိုယ်တိုင်ဟှာ ဒိရှိရမယ်။ နန်းနို့ဟှာ ဖမ်းခံရဂေ့ဘီး တရားရောင်းဟှို ခေါ်ဟှား ခံရဂေ့လေ့မယ်။ ဝါလယ်ဇရပ်လေမာလည်း နန်းနို့ဟှာ ရိုက်ခံရလေ့မယ်။ နန်းနို့ဟှာ ဗြို့ဝန်မန်းလေန မန်းဂီးလေ ရှေ့မာ မတ်တတ်ရပ်ဘီးဟှာ သူးနို့ဟှို ငါ့တွပ် သတ်သေဖြစ်စေလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","အယ်ဘေမဲ့ ဆောင်းရော့‑က်ခန်မာ ဒန်းကောန်းဟှို လူမျိုးဂူလောင်းဟှို ဟောပြောရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","နန်းနို့ဟှို ဖမ်းဘီး တရားရောင်းဟှို ခေါ်ဟှားဂေ့ဟှူ ခီမာ ဖြားမျိုးပြောရမယ် ဆိုဇာဟှို ကြိုတန်ဘီး စိုးရိမ်ဂေ့န။ ခီရော့‑က်လာဟှူ ခီမာ နန်းနို့ဟှို ဖော်ပြဟှူ စကားလေဟှို ပြောဂေ့။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်စကားဟှို နန်းနို့ပြောနေဇာ မှုဟှ သန့်ရှင်းဟှူဝိညာဉ်တော် ပြောနေဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","လူလေဟှာ သူးနို့ရဲ့ ညီကိုရင်းဟှို သေစေဟှို့တွပ် အပ်ဂေ့လေ့မယ်။ အယ်ဘီးဟှာ ဖလေဟှ သူးနို့ရဲ့ သားမီးလေဟှို သေစေဟှို့တွပ် လောက်လေ့မယ်။ သားမီးလေဟှလည်း သူးနို့ရဲ့ မိဖလေဟှို ရန်ပြုဘီးဟှာ သေစေဟှို့တွပ် လောက်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ငါ့နာမကြောန့် လူတိုင်းဟှ နန်းနို့လေဟှို မူးတီးလေ့မယ်။ အယ်ဘေမဲ့ ဆောင်းထိ တည်ကြည်ဟှူလူဟှာ ကယ်တန်ရှင်းဟှို ခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“‘ရွံဇာကောန်းဟှူဇာ’ ဟှာ မှေ့အပ်ဘဲ့ဟှူ နေရာမာ ရှိနေဇာဟှို နန်းနို့လေဟှာ ဗြင်ရဂေ့လေ့မယ်။” စာဖတ်လူဟှာ အယ်ဓိပါယ်ဟှို နားလည်ပါစေ! “အယ်ဆိုဟှာ ယုဒနယ်မာရှိဟှူ လူလေဟှာ တောန်ထတ်ဟှို ပ္လေးဂေ့စေ။ ");
INSERT INTO tvn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","အီးခေါန်မိုးထတ်မာ ရှိဟှူလူဟှာ အော့‑က်ဟှို ဆင်းဘီး အီထဲဟှို ဝမ်ဘီးဟှာ ဖြားဇာလည်း ယူစေန။ ");
INSERT INTO tvn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","လယ်ထဲမာ ရှိဟှူ လူဟှာ သူ့ရဲ့ ဝတ်လောင်ဟှို ယူဟှို့တွပ် အီဟှို ပ္လန်စေန။ ");
INSERT INTO tvn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","အယ်နေ့ရစ်ဟှာ ဝန်းရှင်မလေန သားရှင်မိလေ ရရာတိုင်း ခတ်ခဲလေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","အယ်ဇာလေဟှာ ဆောန်းကာလမာ ဖြစ်ဘဲဟှို့တွပ် ဆုတောန်းဂေ့! ");
INSERT INTO tvn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဘုရားသခင် ဖန်ဆင်းဟှူ ကမ္ဘာဦးစဟှနေ ခုခီထိ အယ်နေ့ရစ်လေရဲ့ ရရာတိုင်း ဆိုးဝါးဟှူ ဆင်းရဲဒေါက်ခမျိုး ဖြစ်ဖူးဟှ။ နော့‑က်ထပ်လည်း အယ်မျိုး ဖြစ်လေ့ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ဘုရားသခင်ဟှာ အယ်နေ့ရစ်လေဟှို ရှယ်စေမယ် ဆိုဟှာ ဖယ်လူလည်း သတ်ရှင်ဘီး လွတ်လေ့ဟှို့ မှုဟှ။ အယ်ဘေမဲ့ ကိုယ်တော် ဝီးကော့‑က်ဟှားဟှူ လူလေတွပ် အယ်နေ့ရစ်လေဟှို တိုစေလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“အယ်ကာလမာ ယော့‑က်ယော့‑က်ဟှ ‘ကေ့ကေ့။ အယ်နားမာ ခရစ်တော် ရှိဟှယ်! ဟှိုနားမာ ခရစ်တော် ရှိဟှယ်!’ ဆိုဘီး နန်းနို့ဟှို ပြောမယ် ဆိုဟှာ အယ်လူဟှို ယောင်ကြည်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ခရစ်တော် တုယောန်လေန ပရောဖက် တုယောန်လေဟှာ ပေါ်လာလေ့မယ်။ ဖြစ်နိုင်မယ် ဆိုဟှာ သူးနို့လေဟှာ ဘုရားသခင် ဝီးကော့‑က်ဟှားဟှူ လူလေဟှိုလည်း လှည့်ဇားနိုင်ဟှို့တွပ် အံ့ဩဘွယ်လေန နိမိတ်လတ်ခဏာလေဟှို ပြဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","အယ်ကြောန့် နန်းနို့ဟှာ ဒိနနေဂေ့! ငါဟှာ အယ်ဇာလေ ဂူလောင်းဟှို နန်းနို့ဟှို ကြိုတန်ဘီး ပြောပြဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ဒေါက်ခဆင်းရဲလေ က္လရော့‑က်လာဟှူ နေ့ရစ်လေမာ နေဟှာ မိုက်ဟှားလေ့မယ်။ လဟှာလည်း လန်းဟှို့မှုဘီ။ ");
INSERT INTO tvn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ကြယ်လေဟှာ ကောန်းဂန်ဟှနေ ကွီက္လလေ့မယ်။ အယ်ဘီးဟှာ အာကာသ တဂိုးလေဟှာ လှောက်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","အယ်ခီမာ မိုးတီထဲမာ ကီးမားဟှူ တဂိုးတော်န ဖောင်းသရေတော်လေနတူးဒူ လူ့ရဲ့သား ကြွလာဇာဟှို လူလေဟှာ ဗြင်ရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","အယ်ဘီးန လူ့ရဲ့သားဟှာ ကောန်းဂန်တမန်လေဟှို ရပ်လေးမျစ်နှာဟှို စေလွှတ်ဘီး မ္လေဂီးစွန်းဟှနေ တခြားတဖတ်စွန်းထိ ဘုရားသခင်ရဲ့ ဝီးကော့‑က်ဟှားဟှူ လူလေဟှို စုသီးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“သဖန်းဗန်ဟှနေ သင်ဂန်းဇာ တခုဟှို သန်ယူဂေ့။ အယ်ပန်ရဲ့ ခတ်လေဟှာ နုလာဘီး ဝပ်လေထွပ်လာဟှူ ခီမာ နွီကာလ နီးလာဘီ ဆိုဇာဟှို နန်းနို့ဟှာ သိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","အယ်မျိုးဘဲ့ အယ်မူဇာလေ ဖြစ်လာဇာဟှို နန်းနို့ဟှာ ဗြင်ရဟှူ ခီမာ လူ့ရဲ့သားဟှ ခွဗော့‑က်ဝနီးဟှို ရော့‑က်နေဘီ ဆိုဇာဟှို သိမှတ်ဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ငါ မှန်တိုင်းပြောမယ်၊ အယ်မူဇာလေ ဂူလောင်း ဖြစ်သေးခန် ခု သတ်ရှင်နေဟှူ လူလေဟှာ လောင်းဝ သေရလေ့ဟှို့ မှုသေးဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ကောန်းဂန်န မ္လေဂီးဟှာ ပျစ်စီးဟှားလေ့မယ်။ အယ်ဘေမဲ့ ငါ့ရဲ့ စကားလေဟှာ လောင်းဝ ပျစ်စီးဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“အယ်ဘေမဲ့လည်း အယ်နေ့ရစ် နာရီ ရော့‑က်လာဟှူ ခီဟှို ဖယ်လူလည်း သိဂေ့ဟှ ကောန်းဂန်ဘောင်ဟှ ကောန်းဂန်တမန်လေလည်း သိဟှ။ သားတော်လည်း သိဟှ။ ဖတပါးဒဲဘဲ့ သိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ဒိပြုဘီး ္နိုးနိုးကြားကြား နေဂေ့။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်ခီဟှာ ဖယ်ခီမှ ရော့‑က်လာမယ် ဆိုဇာဟှို နန်းနို့လေ သိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","အယ်ဇာဟှာ ဝီးဟှို ထွပ်ဟှားဟှူ လူတယော့‑က်န တူဟှယ်။ သူဟှာ သူ့အီဟှို ထားရစ်ဘီး သူ့ရဲ့ စေခံလေဟှို ခွမ့်အာဏာန လောက်ကိုယ်စီ လောက်ဆောန်ဟှို့ မိန့်ပေးဟှားရစ်ဟှယ်။ အယ်ဘီးဟှာ ခွဗော့‑က်စောန့်မားဟှို ဒိနစောန့်ဟှို့ ပြောဟှားရစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","အယ်ဆိုဟှာ ဒိနစောန့်ဂေ့။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အီဇရှင်ဟှာ ဖယ်ခီပ္လန်လာမယ် ဆိုဇာဟှို နန်းနို့လေ သိဂေ့ဟှ။ နေဒန်ဇာခီ၊ ညဉ့်နတ်ခီ၊ မိုးသာထခီ၊ မိုးလန်းစောစောဂီး ခီလေမာ ဖြစ်ရှင်ဖြစ်မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","သူဟှာ ရောက်တရစ် ရော့‑က်လာမယ် ဆိုဟှာ နန်းနို့လေ အိမွီနေဇာဟှို တွိစေန။ ");
INSERT INTO tvn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","အယ်ဘီးဟှာ နန်းနို့ဟှို ပြောဟှားတိုင်း လူတိုင်းဟှိုလည်း ငါပြောဟှယ်။ ဒိနစောန့်နေဂေ့!” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ပသခါပွဲန တဆေးမှေ့ဘဲဟှူ မုပွဲတော်ဖြစ်ခန် နှေ့ရစ်လိုမာ၊ ယဇ်ပုရောဟိတ်ဂီးလေန ကျမ်းတတ်ဆရာလေဟှာ ယေရှုဟှို တိတိဟှားဖမ်းဘီး သတ်ဟှို့တွပ် နည်းလမ်းရှာကြံနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","သူးနို့ဟှာ “နို့လေဟှာ ပွဲတော်ရစ်ထဲမာ အယ်ဇာဟှို လောက်ဂေ့န၊ လူလေဟှာ ရောင်းရင်းဆန်ခတ် ဖြစ်ဟှားနိုင်ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ယေရှုဟှာ ဗေသနိဝါမာ နူနာရောဂါဖြစ်ဖူးဟှူ ရှိမုန်ရဲ့အီမာရှိဟှယ်။ ယေရှုဟှာ စားသော့‑က်နေဒူးမာ မီးမတယော့‑က်ဟှာ ရရာတိုင်း ဖိုးကီးဘီး နာဒုဆီမွှီးစစ်စစ်န ပ္လဲ့နေဟှူ က္လော့‑က်ဖ္လူဖူးဟှို ယူဘီး ရော့‑က်လာဟှယ်။ အယ်ဘီးဟှာ အယ်ဖူးဟှို ရိုက်ခွဲလိုက်ဘီးဟှာ ယေရှုရဲ့ ခေါန်းထတ်ဟှို လောန်းခ္လလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","အယ်နေရာမာရှိဟှူ လူတချို့ဟှာ စိဆိုးလာဘီးဟှာ “ဖြားဖြစ်ကြောန့် အယ်ဆီမွှီးဟှို ကျိုးမှေ့ဘဲန လောက်နေရနူး။ ");
INSERT INTO tvn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","အယ်ဆီမွှီးဟှို ငွေဒန်းဂါး ၃၀၀ ကျော်န ရောန်းဘီးဟှာ အယ်ကပ်လေဟှို ဆင်းရဲသားလေဟှို ပေးရမယ်!” ဆိုဘီး ယော့‑က်နယော့‑က်ပြောနေဂေ့ဟှယ်။ အယ်ဘီးဟှာ သူးနို့ဟှာ အယ်မီးမဟှို ရရာတိုင်း ပြစ်တန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","အယ်ဘေမဲ့ ယေရှုဟှ “အယ်မီးမဟှို ထားလိုက်ဝေါ့! ဖြားဖြစ်ကြောန့် သူ့ဟှို နှောက်ရှစ်နေဂေ့နူး။ သူဟှ ငါ့တွပ် ကောန်းဟှူဇာဟှို လောက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ဆင်းရဲသားလေဟှာ နန်းနို့န မြဲဒမ်း ရှိဂေ့ဟှယ်။ အယ်ဘီးဟှာ နန်းနို့ လိုရှင်ဟှူခီတိုင်း သူးနို့ဟှို ကူညီနိုင်ဟှယ်။ အယ်ဘေမဲ့ ငါဟှ နန်းနို့န မြဲဒမ်းရှိနေဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","အယ်မီးမဟှာ သူတတ်နိုင်မျှလောက်ဟှယ်။ သင်္ဂြိုဟ်ဟှို့တွပ် ကြိုတန်ဘီးဟှာ ငါ့ရဲ့ကိုယ်ထတ်ဟှို ဆီမွှီးလောန်းခ္လလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ကမ္ဘာနှံ့ ဧဝံဂေလိဟောပြောဟှူ နေရာတိုင်းမာအယ်မီးမ လောက်ရစ်ဇာလေဟှိုလည်း သူရဲ့ မှတ်တရဖြစ် ပြောကြားဂေ့လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","အယ်ဘီးန တဗဲ့တော်ဆယ့်နှေ့ပါးထဲဟှ တပါးဖြစ်ဟှူ ယုဒရှကာရုတ်ဟှာ ယဇ်ပုရောဟိတ်ဂီးလေနားဟှို ယေရှုဟှို အပ်ဟှို့တွပ် သူးနို့နားဟှို သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","သူလာပြောဇာဟှို သူးနို့လေဟှာ ကြားရခီမာ ဝန်းသာဟှားဟှယ်။ အယ်ဘီးဟှာ သူ့ဟှို ကပ်ပေးဟှို့တွပ် ဒိပေးဂေ့ဟှယ်။ အယ်ကြောန့် ယုဒဟှာ ယေရှုဟှို အပ်ဟှို့တွပ် ခွမ့်ကောန်းဟှို စဘီး ရှာနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","တဆေးမှေ့ဘဲဟှူ မုပွဲတော်ရဲ့ ပထမနေ့၊ ပသခါ သိုးသားဂန်းဟှားလေဟှို သတ်ရဟှူ နေ့မာ ယေရှုရဲ့ တဗဲ့တော်လေဟှာ “ကိုယ်တော်တွပ် ပသခါ ညဉ့်ဇာစားဟှို့ ကျွန်တော့်ဟှားလေဟှို ဖယ်နားမာသွားဘီး ပြင်ဆင်စေရှင်ဟှယ်နူး” ဆိုဘီး ကိုယ်တော့်ဟှို မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","အယ်ကြောန့် ယေရှုဟှ တဗဲ့တော်နှေ့ပါးဟှို စေလွှတ်လေဟှယ်။ သူးနို့ဟှို ပြောလိုက်ဇာဟှ “ဗြို့ထဲဟှို သွားဂေ့။ ရေအိုးထမ်းလာဟှူ လူတယော့‑က်ဟှ နန်းနို့ဟှို တွိဂေ့လေ့မယ်။ သူ့နော့‑က်ဟှို လိုက်ဟှားဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","သူဝမ်ဟှားဟှူ အီရဲ့ အီဇရှင်ဟှို ပြောပါ ‘ဆရာဟှ ငါ့တဗဲ့တော်လေနတူးဒူး ပသခါ ညဉ့်ဇာစားဟှို့တွပ် ခန်းဟှာ ဖယ်မာနူး’ ဆိုဘီး ဆရာဟှ မေးခိုင်းလိုက်ဟှယ် ဆိုဘီး ပြောပါ။ ");
INSERT INTO tvn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","အယ်ဆိုဟှာ သူဟှာ သင့်ပြင်ဆင်ဟှားဘီး ကီးမားဟှူ ထပ်ခန်းမဟှို နန်းနို့ဟှို ပြလေ့မယ်။ အယ်ခန်းမာ နို့လေတွပ် ညဉ့်ဇာစားဟှို့ ပြင်ဂေ့ပါ။” ");
INSERT INTO tvn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","အယ်တဗဲ့တော်လေဟှာ ထွပ်ဟှားဘီး ဗြို့ထဲဟှို ဝမ်ဟှားဂေ့ဟှူ ခီမာ သူးနို့ဟှို ယေရှုပြောလိုက်တိုင်းဘဲ့ ဂူလောင်းဟှို တွိရလေဟှယ်။ အယ်ကြောန့် သူးနို့ဟှာ ပသခါ ညဉ့်ဇာစားဟှို့ ပြင်ဆင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ညဉ့်ခန်းဇာ ရော့‑က်လာဟှူ ခီမာ ယေရှုဟှာ တဗဲ့တော်ဆယ့်နှေ့ပါးနတူးဒူ ကြွလာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","သူးနို့ဟှာ ဗွဲမာထိုင်ဘီး စားနေဂေ့ဒူးမာ ယေရှုဟှ “နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ နန်းနို့ထဲဟှ တယော့‑က်ဟှာ ငါ့ဟှို သစ်စာဖော့‑က်လေ့မယ်။ အယ်လူဟှာ ငါ့နတူးဒူ စားသော့‑က်နေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","တဗဲ့တော်လေဟှာ စိကောန်းဘဲ ဖြစ်ဟှားဂေ့ဘီး “ကျွန်တော်လော” ဆိုဘီး ယော့‑က်ဘီးယော့‑က် ကိုယ်တော့်ဟှို စဘီးမေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ယေရှုဟှ “တဆယ့်နှေ့ပါးထဲဟှ တပါးဖြစ်ဘီး ငါ့နတူးဒူး စံထဲမာ မုနှိုက်ဟှူလူ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","လူ့ရဲ့သားဟှာ ကျမ်းစာမာ ရေးဟှားတိုင်း သေခံရလေ့မယ်။ အယ်ဘေမဲ့ လူ့ရဲ့သားဟှို သစ်စာဖော့‑က်ဟှူ အယ်လူတွပ် အမင်္ဂလာဖြစ်ဟှယ်! အယ်လူဟှာ မွီးဖွားလာဘဲနေဇာဟှ သူ့တွပ် ပိုဘီး ကောန်းသေးဟှယ်!” ဆိုဘီး ပ္လန်ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","သူးနို့လေဟှာ စားနေဒူးမာ ယေရှုဟှာ မုဟှိုယူဘီး၊ ကျေးဇူးတော်ဟှို ချီးမွမ်းဘီးမှ မုဟှိုဖဲ့ဘီးဟှာ တဗဲ့တော်လေဟှို ပေးလေဟှယ်။ ကိုယ်တော်ဟှ “ယူဂေ့။ အယ်မုဟှာ ငါ့ရဲ့ကိုယ်ခန္ဓာ ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ခွပ်ဟှိုလည်း ယူဘီးဟှာ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟှို ချီးမွမ်းလေဟှယ်။ အယ်ဘီးန သူးနို့လေဟှို ပေးလိုက်ဟှယ်။ သူးနို့လေ ဂူလောင်းဟှာ အယ်ခွပ်ဟှို သော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ယေရှုဟှ “အယ်ဇာဟှာ လူလေတွပ် လောန်းပေးဟှူ ဘုရားသခင်ရဲ့ ပဋိညာဉ်နဇိခတ်ဟှားဟှူ ငါ့ရဲ့သွီးဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","နန်းနို့ဟှို ငါ မှန်ပြောမယ်၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်မာ စဗျစ်ဝိုင်သစ်ဟှို သော့‑က်ရဟှူ နေ့ရော့‑က်ခန်ထိ ငါဟှာ အယ်စဗျစ်ဝိုင်ဟှို နော့‑က်တခါ လောင်းဝ သော့‑က်ဟှို့မှုဘီ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","အယ်ဘီးန သူးနို့လေဟှာ ချီးမွမ်းချင်းဟှို ဆိုဘီး သံလွင်တောန်ဟှို ထွပ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ယေရှုဟှ “ငါ့ဟှို ထားရစ်ဘီး နန်းနို့ဂူလောင်းဟှာ ထွပ်ပ္လေးလေ့မယ်၊ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကျမ်းစာထဲမာ ပြောဟှားဇာဟှ ‘ဘုရားသခင်ဟှာ သိုးထီးမားဟှို ရိုက်သတ်လေ့မယ်၊ အယ်ဆိုဟှာ သိုးလေဂူလောင်းဟှာ ဆွတ်ဆွတ်ဖ္လူဟှားဂေ့လေ့မယ်။’ ");
INSERT INTO tvn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","အယ်ဘေမဲ့ ငါဟှာ ထမြော့‑က်ဟှားဘီးန၊ ငါဟှာ ဂါလိလဲနယ်ဟှို နန်းနို့ထတ်ရင်သွားလေ့မယ်” ဆိုဘီး သူးနို့လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ပေတရုဟှ “တခြားလူလေ ဂူလောင်းဟှာ ထားရစ်ဂေ့ဘေမဲ့၊ ကျွန်တော့်ဟှ ကိုယ်တော့်ဟှို လောင်းဝထားရစ်ဟှို့ မှုဟှ!” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ယေရှုဟှ “နန့်ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ခုညဉ့်မာဘဲ့ ကြစ်နှေ့ခါ တွန်ခန်မာ နန်ဟှာ ငါ့ဟှို သိဟှဆိုဘီး သောင်းခါ ပြောလေ့မယ်” ဆိုဘီး ပေတရုဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","အယ်ဘေမဲ့ ပေတရုဟှ “ကျွန်တော့်ဟှာ ကိုယ်တော်နတူးဒူ သေရမယ် ဆိုဟှာလည်း၊ အယ်မျိုးလောင်းဝ ငြင်းပယ်ဟှို့ မှုဟှ!” ဆိုဘီး လေးလေးနတ်နတ်ဟှား ပ္လန်လျှော့‑က်လေဟှယ်။ အယ်ဘီးဟှာ တခြားတဗဲ့တော်လေ အားလောင်းဟှလည်း အယ်မျိုးဘဲ့ လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","သူးနို့လေဟှာ ဂေသရှေမန် ဆိုဘီး နာမယ်ခေါ်ဟှူ နေရာဟှို သွားဂေ့ဟှယ်။ အယ်ဘီးန ယေရှုဟှာ “ငါဆုတောန်းနေဒူးမာ အယ်နေရာမာ ထိုင်နေဂေ့ပါ” ဆိုဘီး တဗဲ့တော်လေဟှို ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ကိုယ်တော်ဟှာ ပေတရု၊ ယာကုပ်န ယောဟန်ဟှို သူ့နတူးဒူ ခေါ်ဆောန်ဟှားလေဟှယ်။ ဆိုးဝါးဟှူ ပူပန်သောကဟှာ ကိုယ်တော့်ဟှို စိုးမိုးလာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","အယ်ဘီးဟှာ ကိုယ်တော်ဟှ “ငါ့စိဟှာ သေလော့‑က်အောန် ဝန်းနဲနေလေဟှယ်။ အယ်နေရာမာ နေရစ်ဘီး ဒိနစောန့်နေဂေ့” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ကိုယ်တော်ဟှ ရှေ့ဟှို နဲနဲတိုးဟှားဘီးဟှာ သူ့ကိုယ်သူ မ္လေဂီးမာ လှဲခ္လလိုက်ဘီး ဖြစ်နိုင်မယ် ဆိုဟှာ အယ်ခီနာရီဟှို သူ့ဟှနေ လွန်ဟှားစေပါ ဆိုဘီး ဆုတောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“အဗ္ဗ၊ ဖ! ကိုယ်တော်တွပ် ရှိမျှဂူလောင်းဟှာ ဖြစ်နိုင်ဟှယ်။ အယ်ဝေဒနာခွပ်ဟှို ကျွန်တော့်နားဟှနေ ဖယ်ပေးပါ။ အယ်ဘေမဲ့ ကျွန်တော့်ရဲ့ လိုဖြစ်စေန။ ကိုယ်တော်ရဲ့လိုဘဲ့ ဖြစ်စေပါ။” ");
INSERT INTO tvn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","အယ်ဘီးန ကိုယ်တော်ဟှာ ပ္လန်လာဟှူ ခီမာ တဗဲ့တော်သောင်းပါးဟှာ အိမွီနေဂေ့ဇာဟှို တွိဟှားဟှယ်။ ကိုယ်တော်ဟှ “ရှိမုန်၊ နန်ဟှ အိမွီနေလော။ တနာရီလော့‑က် စောန့်နေနိုင်ဟှလော” ဆိုဘီး ပေတရုဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ကိုယ်တော်ဟှ “နန်းနို့ဟှာ စောင်ဇမ်းသွီးဆောန်မှုထဲဟှို က္လဘဲနေဟှို့တွပ် ဆုတောန်းဘီး စောန့်နေဂေ့။ ဝိညာဉ်ဟှဆန္ဒရှိဘေမဲ့ ဇာတိဟှအားနည်းဟှယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ကိုယ်တော်ဟှာ နော့‑က်တခါ ထွပ်ဟှားဘီး၊ ရင်တိုင်းဘဲ ဆုတောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ကိုယ်တော်ဟှာ ပ္လန်လာဟှူ ခီမာ သူးနို့မျစ်စိလေဟှ လေးလံနေဟှူကြောန့် အိမွီနေဇာဟှို တခါတွိဟှားဟှယ်။ သူးနို့ဟှာ ကိုယ်တော့်ဟှို ဖြားဇာပြောရဟှို့ သိဂေ့ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ကိုယ်တော်ဟှာ သောင်းခါမြော့‑က် ပ္လန်လာဟှူ ခီမာ ကိုယ်တော်ဟှ “နန်းနို့ဟှာ ခုထိ အိမွီးဘီး နားယူနေသေးလော။ တော်ဘီ! ခီနာရီဟှာ ရော့‑က်လာဘီ! ကေ့ဂေ့! လူ့ရဲ့သားဟှာ ပြစ်သားလေရဲ့ လတ်ထဲဟှို အယ်နှံခံရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ထဂေ့။ နို့လေ သွားဂေ့ဇို့။ ငါ့ဟှို အပ်ဟှို့လူဟှာ ရော့‑က်လာဘီး!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","တဗဲ့တော် ဆယ့်နှေ့ပါးထဲဟှ တပါးဖြစ်ဟှူ ယုဒဟှာ ရော့‑က်လာဟှူ ခီမာ ယေရှုဟှာ စကားပြောနေဒူး ဖြစ်ဟှယ်။ သူ့နတူးဒူ ဒေါက်လေ၊ ထားလေကိုင်လာဟှူ လူအောက်ဂီး ပါလာဘီး အယ်လူလေဟှို ယဇ်ပုရောဟိတ်ဂီးလေ၊ ကျမ်းတတ်ဆရာလေန သတ်ကီးဝါဂီးလေဟှ စေလွှတ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ကိုယ်တော့်ဟှို အပ်ဟှူ လူဟှ “ငါနမ်းဟှူ လူဟှာ နန်းနို့ လိုရှင်နေဟှူလူ ဖြစ်ဟှယ်။ သူ့ဟှို ဖမ်းဘီး စောန့်လေန ခေါ်ဟှားဂေ့” ဆိုဘီး လူအောက်ဂီးဟှို ချစ်ပြဘီး မှတ်သား ပေးဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ယေရှုနားဟှို ရှစ်ရှင်း သွားဘီး၊ ယုဒဟှ “ဆရာ!” ဆိုဘီး ခေါ်လိုက်ဘီး ကိုယ်တော့်ဟှို နမ်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","အယ်ကြောန့် သူးနို့ဟှ ယေရှုဟှို ဖမ်းဘီး ချောက်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","အယ်ဘေမဲ့ နားမာရပ်နေဟှူ လူလေထဲဟှ တယော့‑က်ဟှာ ထားဟှို ဆွဲထုဘီး ယဇ်ပုရောဟိတ်မန်းရဲ့ ကျွန်တယော့‑က်ဟှို ခွတ်လိုက်ဟှူ ခီမာ အယ်လူရဲ့ နားဝှပ် ပြတ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","အယ်ဆိုန ယေရှုဟှာ “ငါဟှာ မ္လတယော့‑က် ဖြစ်ဟှူကြောန့် နန်းနို့ဟှာ ငါ့ဟှို့ ဖမ်းဟှို့တွပ် ဒေါက်လေ၊ ထားလေန ရော့‑က်လာဂေ့ ဇာလော။ ");
INSERT INTO tvn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ငါဟှာ နေ့တိုင်း နန်းနို့နတူဒူး ဗိမာန်တော်ထဲမာ သွန်သန်နေဟှယ်။ နန်းနို့ဟှာ ငါ့ဟှို ဖမ်းဂေ့ဟှမား။ အယ်ဘေမဲ့ ကျမ်းစာတိုင်းဘဲ့ ပ္လဲ့ဇောင်လာရမယ်” ဆိုဘီး သူးနို့လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","အယ်ဆိုန တဗဲ့တော်လေဟှာ ကိုယ်တော့်ဟှို ထားရစ်ဘီး ထွပ်ပ္လေးဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ပိချောဝတ် တထည်ဘဲ့ ခြောင်ဟှားဟှူ လူငယ် တယော့‑က်ဟှာ ယေရှုနော့‑က်ဟှို လိုက်လာဟှယ်။ သူးနို့ဟှာ သူ့ဟှို ဖမ်းဟှို့ ကြိုးစားဂေ့ဟှူ ခီမာ ");
INSERT INTO tvn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","သူဟှာ ပိချောဝတ်ဟှို ထားရစ်ဘီးဟှာ ခ္လေးပ္လန်းဗ္လန်းန ထွပ်ပ္လေးဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","အယ်ဘီးန ယေရှုဟှို ယဇ်ပုရောဟိတ်ဂီးလေ၊ သတ်ကီးဝါဂီးလေန ကျမ်းတတ်ဆရာလေ စုဝီးနေဟှူ ယဇ်ပုရောဟိတ်မန်းရဲ့ အီဟှို ခေါ်ဆောန်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ပေတရုဟှ ခပ်ဝီးဝီးဟှနေ လိုက်လာဘီး ယဇ်ပုရောဟိတ်မန်းရဲ့ အီဝမ်းထဲဟှို ဝမ်ဟှားလေဟှယ်။ အယ်နေရာမာ သူဟှာ စောန့်လေနတူးဒူ ထိုင်ဘီး မီးကန်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ယဇ်ပုရောဟိတ်ဂီးလေန တရားလွှတ်တော် တခုလောင်းဟှာ ယေရှုဟှို သေဒန်ပေးနိုင်ဟှို့တွပ် ကိုယ်တော့်ဟှို ဆန့်ကျင်ထွပ်ဆိုမယ့် သတ်သေတချို့ဟှို ရှာဟှို့ ကြိုးစားဂေ့ဟှယ်။ အယ်ဘေမဲ့ သူးနို့ဟှာ ဖြားဇာလည်း ရှာတွိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","သတ်သေလေ ဘောင်းဂီးဟှာ ယေရှုဟှို ဆန့်ကျင်ဟှို့ လီညာဘီး ထွပ်ဆိုဂေ့ဟှယ်။ အယ်ဘေမဲ့ သူးနို့ထွပ်ဆိုဇာလေဟှ တူညီဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","အယ်ဆိုန လူတချို့ဟှာ ထရပ်ဘီးဟှာ ယေရှုဟှို ဆန့်ကျင်ဟှို့ အယ်မျိုးလီညာဘီး ထွပ်ဆိုလိုက်ဇာဟှ ");
INSERT INTO tvn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“‘လူလောက်ဟှားဟှူ အယ်ဗိမာန်တော်ဟှို ငါဖြိုဖျစ်မယ်။ အယ်ဘီးဟှာ သောင်းရစ်ကြာဘီးန လူလောက်ဘဲဟှူ ဗိမာန်တော်ဟှို ငါပ္လန်ဆော့‑က်မယ်’ ဆိုဘီး သူပြောဇာဟှို ကျွန်တော့်လေ ကြားဟှားဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","အယ်ဘေမဲ့လည်း သူးနို့ရဲ့ သတ်သေထွပ်ဆိုချစ်ဟှာ တူညီဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ယဇ်ပုရောဟိတ်မန်းဟှာ သူးနို့လေ ဂူလောင်းရဲ့ ရှေ့မာ ရပ်ဘီးဟှာ ယေရှုဟှို “အယ်လူလေဟှာ နန့်ဟှို စွပ်စွဲပြောဆိုနေဇာ နန်ဟှာ ဖြားလည်းဖြေဘဲန နေဟှို့လော” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","အယ်ဘေမဲ့ ယေရှုဟှာ ဇပ်ပေါ့‑က်ဟှို ပိဟှားဘီး စကားခွန်းလည်း ပြောဟှ။ တခါပ္လန်ဘီး ယဇ်ပုရောဟိတ်မန်းဟှ “နန်ဟှာ မင်္ဂလာရှိဟှူ ဘုရားသခင်ရဲ့ သားတော် ခရစ်တော်လော” ဆိုဘီး ကိုယ်တော့်ဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ယေရှုဟှ “ငါဘဲ့ဖြစ်ဟှယ်။ လူ့ရဲ့သားဟှာ တဂိုးတော်ရဲ့ ညာဖတ်မာ ထိုင်နေဘီး ကောန်းဂန်မိုးတီဟှို စီးဘီးလာနေဇာဟှို နန်းနို့ ဗြင်ရလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ယဇ်ပုရောဟိတ်မန်းဟှာ မိမိဝတ်ယောင်ဟှို ဆုဖ္လဲဘီးဟှာ “နို့လေဟှာ နော့‑က်ထပ် ဖြားသတ်သေလေ လိုသေးဟှယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ဘုရားသခင်ဟှို ပြစ်မှားဘီး ပြောနေဟှူ စကားဟှို နန်းနို့ ကြားရဂေ့ဘီ။ နန်းနို့ရဲ့ စီရင်ချစ်ဟှ ဖယ်မျိုးနူး” ဆိုဘီး မေးလိုက်ဟှယ်။ သူးနို့လေ ဂူလောင်းဟှာ ကိုယ်တော့်ဟှို သေဒန်ခံထိုက်ဟှယ် ဆိုဘီး စီရင်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","သူးနို့ထဲဟှတချို့ဟှာ ယေရှုဟှို စဘီးဟှာ ထွီးရယ်န ထွီးဂေ့ဟှယ်။ အယ်ဘီးဟှာ ကိုယ်တော့်ဟှို မျစ်နှာဟှိုဖောင်းဘီး လတ်သီးန ထိုးဂေ့ဟှယ်။ “ဖယ်လူဟှ ရိုက်လိုက်ဟှယ် ဆိုဇာဟှို ပရောဖက်ပြုပါ!” ဆိုဘီး သူးနို့ဟှ ပြောဂေ့ဟှယ်။ အယ်ဘီးဟှာ စောန့်လေဟှာ ကိုယ်တော့်ဟှို ခေါ်ဆောန်းဟှားဘီး ကိုယ်တော့်ဟှို ပါးရိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ပေတရုဟှာ အယ်အီဝမ်းထဲမာ ရှိနေဒူးမာ ယဇ်ပုရောဟိတ်မန်းရဲ့ စေခံဝယ်သားလေထဲဟှ တယော့‑က်ဟှာ ရော့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","အယ်ဝယ်သားဟှာ ပေတရု မီးကန်နေဇာဟှို ဗြင်ဟှူ ခီမာ သူဟှာ သူ့ဟှို စေ့စေ့ကေ့ဘီး “နန်ဟှာလည်း နာဇရက်ဗြို့သား ယေရှုနတူးဒူး ရှိနေဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","အယ်ဘေမဲ့ ပေတရုဟှာ “နန်ပြောနေဇာလေဟှို ငါသိဟှ။ ငါနားလည်ဟှ” ဆိုဘီး ငြင်ဘီးဟှာ ပ္လန်ဖြေလိုက်ဟှယ်။ အယ်ဘီးန ခြံဝဟှို ထွပ်ဟှားလေဟှယ်။ အယ်ခီမာဘဲ့ ကြစ်တွန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","စေခံဝယ်သားဟှာ ပေတရုဟှို အယ်နေရာမာ တွိဟှူ ခီမာ နားမာရပ်နေဟှူ လူလေဟှို “အယ်လူဟှာ သူးနို့လေထဲဟှ တယော့‑က်ဖြစ်ဟှယ်!” ဆိုဘီး ထပ်ပြောပ္လန်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","အယ်ဘေမဲ့ ပေတရုဟှာ နော့‑က်တခါ ငြင်းပ္လန်ဟှယ်။ နဲနဲကြာဘီးန နားမာရပ်နေဟှူ လူလေဟှ “နန်ဟှာ မှန်ဘဲ့ သူးနို့ထဲဟှ တယော့‑က်ဖြစ်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်ဟှလည်း ဂါလိလဲပြည်သား တယော့‑က်ဖြစ်ဟှယ်” ဆိုဘီး သူးနို့ဟှ ပေတရုဟှို စွပ်စွဲဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","အယ်ဆိုန ပေတရုဟှ “ငါဟှာ မှန်တိုင်း ပြောနေဟှယ် ဆိုဇာဟှို ငါကီရဲဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ရှစ်ရှင်းဘဲ့ ဒုတိယခါ ကြစ်တွန်လေဟှယ်။ အယ်ဆိုန “နန်ဟှာ ငါ့ဟှို သိဟှ ဆိုဘီး သောင်းခါ ငြင်းလေ့မယ်” ဆိုဘီး ယေရှုပြောဟှားဟှူ စကားဟှို ပေတရုဟှာ ဒိရဟှားဟှယ်။ အယ်ဆိုန သူဟှာ ရရာတိုင်း ငိုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","မိုးလန်းစောစောမာ ယဇ်ပုရောဟိတ်ဂီးလေဟှာ ကျမ်းတတ်ဆရာလေ၊ သတ်ကီးဝါဂီးလေန တရားလွှတ်တော်တခုလောင်းန ဗြန်းဗြန်ဟှား တွိဂေ့ဘီးဟှာ ဆောင်းဖြတ်ဂေ့ဟှယ်။ သူးနို့ဟှာ ယေရှုဟှို တောက်ဂေ့ဘီး ခေါ်ဆောန်ဟှားဟှယ်။ အယ်ဘီးဟှာ ပိလတ်မန်းဟှို အပ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ပိလတ်မန်းဟှ “နန်ဟှာ ယုဒလူမျိုးလေရဲ့ မန်းဂီးလော” ဆိုဘီး ယေရှုဟှို မေးလေဟှယ်။ ယေရှုဟှ “မန်းဂီးပြောတိုင်းဘဲ့” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ယဇ်ပုရောဟိတ်ဂီးလေဟှာ ယေရှုဟှို မျိုးမျိုးဘဲ့ စွပ်စွဲဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","အယ်ကြောန့် ပိလတ်မန်းဟှာ ယေရှုဟှို “နန်ဟှာ ဖြားလည်းဖြေဘိလော။ သူးနို့လေ ဂူလောင်းရဲ့ စွပ်စွဲချစ်လေဟှို နားထောန်ကေ့!” ဆိုဘီး ထပ်ဘီးမေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","အယ်ဘေမဲ့ ယေရှုဟှာ ခွန်းလည်း ပ္လန်ပြောဘဲန အယ်တိုင်းဘဲ့ နေလေဟှယ်။ အယ်ဆိုန ပိလတ်မန်းဟှာ အံ့ဩဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ပသခါပွဲတိုင်းမာ ပိလတ်မန်းဟှာ ပြည်သူလေ တောန်းဟှူ ထောန်သားတယော့‑က်ဟှို လွှတ်ပေးဟှူ ထောင်းဇံရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","အယ်ခီမာ ဆူပူအုံကြွမှုမာ လူသတ်မှု ကျူးလွန်ဟှူ ပေါင်ကန်သူလေနတူးဒူ ဗာရဗ္ဗ နာမယ်ရှိဟှူ လူတယော့‑က်ဟှာ ထောန်က္လနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","လူအောက်ဂီးဟှာ ပိလတ်မန်းနားဟှို စုဝီးလာဘီး လောက်လေ့ရှိဟှူတိုင်း သူးနို့ဟှို လောက်ဆောန်ပေးဟှို့ ပိလတ်မန်းဟှို တောန်းဆိုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ပိလတ်မန်းဟှ “နန်းနို့ဟှာ ယုဒလူမျိုးရဲ့ မန်းဂီးဟှို လွှတ်ပေးစေရှင်ဟှယ်လော” ဆိုဘီး သူးနို့ဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ယဇ်ပုရောဟိတ်ဂီးလေဟှာ ယေရှုဟှို နာလိုဘဲဟှူကြောန့် အပ်ဟှယ်ဆိုဇာ ပိလတ်မန်းဟှာ သိဟှူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","အယ်ဘေမဲ့ ယဇ်ပုရောဟိတ်ဂီးလေဟှာ ဗာရဗ္ဗဟှိုဘဲ့ လွှတ်ပေးဟှို့တွပ် ပိလတ်မန်းနားမာ တောန်းဆိုဟှို့ လူအောက်ဂီးဟှို နှို့ဆော်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ပိလတ်မန်းဟှ “ယုဒလူမျိုးရဲ့ မန်းဂီး ဆိုဘီး နန်းနို့ခေါ်ဟှူ လူဟှို ငါဖယ်မျိုးလောက်ရဟှို့နူး” ဆိုဘီး လူအောက်ဂီးဟှို ထပ်မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","အယ်လူလေဟှ “သူ့ဟှို ကားစင်တန်ပါ!” ဆိုဘီး အော်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ပိလတ်မန်းဟှာ “ဖြားဖြစ်ကြောန့်နူး။ အယ်လူဟှ ဖြားပြစ်မှုဟှို ကျူးလွန်ဟှားနူး” ဆိုဘီး မေးလေဟှယ်။ လူလေ ဂူလောင်းဟှာ “သူ့ဟှို ကားစင်တန်ပါ!” ဆိုဘီး ပိုဘီး ဟှာ က္လယ်ဟှီးအော်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ပိလတ်ဟှာ လူအောက်ဂီးဟှို ကျေနပ်စေရှင်ဟှယ်။ အယ်ကြောန့် သူးနို့တွပ် ဗာရဗ္ဗဟှို လွှတ်ပေးလိုက်ဟှယ်။ အယ်ဘီးန သူဟှာ ယေရှုဟှို ကျာပွတ်န ရိုက်စေဘီးဟှာ ကားစင်တန်ဟှို့တွပ် အပ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","စစ်သားလေဟှာ ယေရှုဟှို ဗြို့ဝန်မန်းရဲ့ အီခြံဝမ်းထဲဟှို ခေါ်ဆောန်ဟှားဘီး တပ်ဖွဲ့တဖွဲ့လောင်းဟှို စုခိုင်းလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","သူးနို့ဟှာ ယေရှုဟှို ခရမ်းရောန် ဝတ်လောင်ဟှို ဝတ်ပေးလိုက်ဟှယ်။ အယ်ဘီးန ဆူးခတ်လေဟှို သရဖူဖြစ် ရစ်လောက်ဘီး ကိုယ်တော့်ဟှို ဆောန်းပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","အယ်ဘီးန ကိုယ်တော့်ဟှို “ယုဒလူမျိုးရဲ့ မန်းဂီး သတ်တော်ရှယ်ပါစေ!” ဆိုဘီး စဘီး နှောက်ဆစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","သူးနို့ဟှာ ကိုယ်တော်ရဲ့ ခေါန်းဟှို ကျူဒေါက်န ရိုက်ဂေ့ဟှယ်။ ကိုယ်တော့်ဟှိုလည်း ထွီးရယ်န ထွီးဂေ့ဟှယ်။ သူးနို့ရဲ့ ဒူးဟှို ထော့‑က်ဘီးဟှာ ကိုယ်တော့်ဟှို ရှိခိုးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","သူးနို့ဟှာ ကိုယ်တော့်ဟှို ရယ်ဇားဂေ့ဘီးဟှာ သူးနို့ဟှ ခရမ်းရောန် ဝတ်လောင်ဟှို ခလွတ်ဘီးဟှာ ကိုယ်တော်ရဲ့ ဝတ်ဟှို ပ္လန်ဝတ်ပေးဂေ့ဟှယ်။ အယ်ဘီးန သူးနို့ဟှာ လတ်ဝါးကပ်တိုင်ထတ်မာ သတ်ဟှို့တွပ် ကိုယ်တော့်ဟှို ခေါ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","သူးနို့ဟှာ တောဝါဟှနေ ဗြို့ဟှိုတတ်လာဟှူ ရှိမုန်နာမယ်ရှိဟှူ လူတယော့‑က်ဟှို လမ်းမာ တွိလေဟှယ်။ အယ်ဆိုန စစ်သားလေဟှာ ယေရှုရဲ့ လတ်ဝါးကပ်တိုင်ဟှို သူ့ဟှို တန်ဘီးထမ်းခိုင်းလေဟှယ်။ (ရှိမုန်ဟှာ ကုရေနေဗြို့သားဖြစ်ဘီး အာလေဇန္ဒြန ရုဖရဲ့ ဖလည်း ဖြစ်ဟှယ်။) ");
INSERT INTO tvn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","သူးနို့ဟှာ ယေရှုဟှို ဂေါလဂေါသ ဆိုဘီး ခေါ်ဟှူ နေရာဟှို ခေါ်ဆောန်ဟှားဂေ့ဟှယ်။ ဂေါလဂေါသရဲ့ ဓိပါယ်ဟှ “ဦးခေါန်းခွံနေရာ” ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","အယ်နေရာမာ သူးနို့ဟှ ကိုယ်တော့်ဟှို မုရန် ဆိုဘီး ခေါ်ဟှူ ဆေးန ရောဟှားဟှူ ဝိုင်ဟှို တိုက်ဟှို့ ကြိုးစားဂေ့ဟှယ်။ အယ်ဘေမဲ့ ယေရှုဟှ သော့‑က်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","အယ်ဘီးန သူးနို့ဟှာ ကိုယ်တော့်ဟှို ကားစင်တန်ဘီး သတ်ဂေ့ဘီးဟှာ ဝတ်ရဲ့ ဖြားပိုင်းဟှို ဖယ်လူဟှရဟှယ် ဆိုဇာဟှို ဗြင်ဟှို့တွပ် မဲနှိုက်ဘီး သူးနို့ရှင်းရှင်းထဲမာ ကိုယ်တော်ရဲ့ ဝတ်ဟှို ခွဲဝီဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","သူးနို့ဟှာ ကိုယ်တော့်ဟှို ကားစင်တန်ဘီး သတ်ဟှူ ခီဟှာ မိုးလန်း ကိုးနာရီ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ကိုယ်တော့်ဟှို ဆန့်ကျင်ဘီး စွတ်စွဲချစ်ဟှို ရေးဟှားဟှူစာမာ “ယုဒမန်းဂီး” ဆိုဘီး ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","သူးနို့ဟှာ ယေရှုနတူးဒူ မ္လနှေ့ယော့‑က်ဟှိုလည်း ဘယ်ဖတ်မာ တယော့‑က် ညာဖတ်မာ တယော့‑က် ထားဘီးဟှာ ကားစင်တန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ဖြတ်သွားဖြတ်လာလောက်နေဟှူ လူလေဟှာ ခေါန်းခါဘီးဟှာ ယေရှုဟှို ကဲ့ရဲ့လိုက်ဇာဟှ “ဟင်! ဗိမာန်တော်ဟှိုဖြိုခ္လဘီး သောင်းရစ်ထဲမာ ပ္လန်ဆော့‑က်ဟှို့လူ! ");
INSERT INTO tvn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ခု လတ်ဝါးကပ်တိုင်ဟှနေ ဆင်းလာဘီးဟှာ နန့်ကိုယ်နန် ကယ်တန်ပါ!” ");
INSERT INTO tvn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","အယ်မျိုးဘဲ့ ယဇ်ပုရောဟိတ်ဂီးလေန ကျမ်းတတ်ဆရာလေဟှာ ယေရှုဟှို ရယ်ဇားဂေ့ဘီး၊ ယော့‑က်နယော့‑က်ပြောနေဇာဟှ “အယ်လူဟှာ တခြားလူလေဟှို ကယ်ဟှယ်။ အယ်ဘေမဲ့ သူ့ကိုယ်သူလော ကယ်နိုင်ဟှမား! ");
INSERT INTO tvn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ဣသရေလမန်းဂီး၊ ကယ်တန်ရှင် ခရစ်တော်ဟှာ ခုဘဲ့ လတ်ဝါးကပ်တိုင်ဟှနေ ဆင်းလာဇာဟှို နို့လေဗြင်ရမယ် ဆိုဟှာ နို့လေဟှ ယောင်ကြည်မယ်!” အယ်ဘီးဟှာ ယေရှုနတူးဒူ ကားစင်တန်ဘီး သတ်ခံရဟှူ လူနှေ့ယော့‑က်ဟှလည်း ယေရှုဟှို ရယ်ဇားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","မွန်းဒဲ့ခီမာ တနိုင်ငံလောင်းဟှာ မှောန်က္လဟှားဘီး၊ အယ်ဇာဟှာ သောင်းနာရီကြာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","နေဒန်သောင်းနာရီမာ ယေရှုဟှာ “ဧလိ၊ ဧလိ၊ လာမ ရှာဗခသနိ” ဆိုဘီး သံက္လယ်ဂီးန အော်လိုက်ဟှယ်။ အယ်ဓိပါယ်ဟှ “ကျွန်တော့် ဘုရားသခင်၊ ကျွန်တော့် ဘုရားသခင် ဖြားဖြစ်ကြောန့် ကျွန်တော့်ဟှို စွန့်ပစ်နူး” ဆိုဘီး ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","နားမာရပ်နေဟှူ လူတချို့ဟှာ အယ်စကားဟှို ကြားဟှူ ခီမာ သူးနို့ဟှ “နားထောန်ကေ့။ သူဟှာ ဧလိယဟှို ခေါ်နေဟှယ်!” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","သူးနို့ထဲဟှ တယော့‑က်ဟှာ ဝိုင်ရှင်ထဲမာ နှစ်ဟှားဟှူ ရေမ္လောက်န ပ္လေးလာဟှယ်။ အယ်ဘီးဟှာ အယ်ဇာဟှို ကျူဒေါက်ဖျားမာ တတ်လေဟှယ်။ အယ်ဘီးန သူဟှာ ယေရှုရဲ့ ဇတ်ပေါ့‑က်မာ ထားပေးလိုက်ဘီးဟှာ “စောန့်ပါအူး! ဧလိယဟှာ သူ့ဟှို လတ်ဝါးကပ်တိုင်ဟှနေ အော့‑က်ဟှို ယူခ္လဟှို့တွပ် လာနေဟှယ် ဆိုဇာဟှို နို့လေကေ့ကေ့ဇို့!” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","သံက္လယ်ဂီး အော်ဘီးန ယေရှုဟှာ သတ်ချောက်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ဗိမာန်တော်ရဲ့လိုက်ကာဟှာ ထတ်ဟှနေအော့‑က်ထိ နှေ့ခြမ်းကွဲဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","လတ်ဝါးကပ်တိုင်ရှေ့မာ ရပ်နေဟှူ တပ်မှူးဟှာ ယေရှု ဖယ်မျိုးသေဟှားဟှယ်ဆိုဇာဟှို ဗြင်ဟှားဟှယ် “အယ်လူဟှာ မှန်ဘဲ့ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်ဟှယ်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","အယ်နေရာမာ ရှိနေဟှူ မီးမတချို့ဟှာ ဝီးဟှနေဘီး ကေ့နေဂေ့ဟှယ်။ အယ်မီးမလေထဲမာ မာဂဒလဗြို့သူ မာရိ၊ ယာကုပ်ငယ်န ယောသေလေရဲ့မိဖြစ်ဟှူ မာရိန ရှာလုံလေ ရှိနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ယေရှုဟှာ ဂါလိလဲနယ်မာ ရှိနေဒူးဟှ၊ သူးနို့ဟှာ ကိုယ်တော့်နော့‑က်ဟှို လိုက်ဘီး လောက်ကျွေး ပြုစုဂေ့ဟှယ်။ အယ်နေရာမာ ကိုယ်တော်နတူးဒူ ယေရုရှလင်ဗြို့ဟှို လိုက်လာဟှူ တခြားမီးမလေလည်း ဘောင်ဂီးရှိနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","အယ်နေ့ဟှာ ဖိနေ့ဖြစ်ဟှယ် (အယ်နေ့ဟှာ ဒန်းနေ့တိုင်ခန်နေ့ဖြစ်ဟှယ်)။ အယ်ကြောန့် နေဒန်ဇာရော့‑က်လာဟှူ ခီမာ ");
INSERT INTO tvn_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","တရားလွတ်တော်ရဲ့ လေးစားခံရဟှူ ဖွဲ့ဝမ်တယော့‑က်ဖြစ်ဘီး ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို စောန့်မျှော်နေဟှူ အရိမဿဲဗြို့သား ယောသပ်ဟှာ ယေရှုရဲ့လောန်းဟှို တောန်းဟှို့တွပ် ပိလတ်နားဟှို ရဲရဲတန်းတန်းဟှားဘဲ့ ဝမ်းဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ပိလတ်ဟှာ ယေရှုသေဟှားဘီး ဆိုဇာဟှို ကြားဟှူ ခီမာ အံ့ဩဟှားလေဟှယ်။ သူဟှာ တပ်မှူးဟှို ခေါ်လိုက်ဘီး ယေရှုသေဟှားဇာ ဖယ်မျှကြာဟှားဘီ ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","သေဟှားဘီ ဆိုဘီး တပ်မှူးရဲ့စီရင်ခံဇာဟှို ကြားရဟှူ ခီမာ ပိလတ်ဟှာ ယောသပ်ဟှို လောန်းဟှိုပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","အယ်ကြောန့် ယောသပ်ဟှာ ပိဖ္လူဟှို ဝယ်ဘီး၊ လောန်းဟှို ယူခ္လဘီး ပိဖ္လူန ပတ်လေဟှယ်။ အယ်ဘီးဟှာ က္လော့‑က်ဆောန်ဟှို ထွမ်းဟှားဟှူ သန်းခ္လိုင်းဂူထဲမာ လောန်းဟှို ထားဟှားလေဟှယ်။ အယ်ဘီးန သူဟှာ သန်းခ္လိုင်းဂူဝဟှို က္လော့‑က်တောင်းဂီးန ပိဟှားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","မာဂဒလဗြို့သူ မာရိန ယောသေရဲ့မိ မာရိဟှာ စောန့်ကေ့နေဂေ့ဘီး ယေရှုရဲ့လောန်းထားဟှားဟှူ နေရာဟှို တွိဗြင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ဒန်းနေ့လွန်ဘီးန မာဂဒလဗြို့သူ မာရိ၊ ယာကုပ်ရဲ့မိ မာရိန ရှာလုံဟှာ ယေရှုရဲ့လောန်းဟှို လူးပေးဟှို့တွပ် နံ့သာလေဟှို ဝယ်ယူဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","နန်းနွေနေ့ မိုးလန်းစောစော နေထွပ်ခီမာ သူးနို့ဟှာ သန်းခ္လိုင်းဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","သူးနို့ဟှ “သန်းခ္လိုင်းရဲ့ ဂူဝဟှနေ က္လော့‑က်တောင်းဟှို ဖယ်သူဟှ တွန်းဖယ်ပေးဟှို့နူး” ဆိုဘီး ယော့‑က်နယော့‑က် မေးနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","အယ်ဘေမဲ့ သူးနို့ဟှာ ကေ့လိုက်ဟှူ ခီမာ ရရာတိုင်း ကီးဟှူ အယ်က္လော့‑က်တောင်းဟှို တွန်းဖယ်ဟှားဘီးသား ဖြစ်နေဇာဟှို သူးနို့ဟှာ တွိဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","အယ်ကြောန့် သူးနို့ဟှာ သန်းခ္လိုင်းထဲဟှို ဝမ်ဟှားဘီး အယ်နေရာမာ ဝတ်လောင်ဖ္လူ ဝတ်ဟှားဟှူ လူငယ်တယော့‑က်ဟှာ ညာဖတ်မာ ထိုင်နေဇာဟှို ဗြင်ဟှားလေဟှယ်။ အယ်န သူးနို့ဟှာ ထိလန့်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","အယ်လူဟှ “လန့်ဂေ့န။ နန်းနို့ဟှာ ကားစင်တန်ခံရဟှူ နာဇရက်ဗြို့သားယေရှုဟှို ရှာနေဟှယ် ဆိုဇာဟှို ငါသိဟှယ်။ ကိုယ်တော်ဟှ အယ်နေရာမာ မှေ့ဟှမ်း ကိုယ်တော်ဟှ ထမြော့‑က်ဟှားဘီ! ကေ့ကေ့၊ အယ်နေရာဟှာ ကိုယ်တော့်ဟှို ထားဟှူနေရာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","နန်းနို့ဟှာ ပေတရုန တခြားတဗဲ့တော်လေနားဟှို သွားဘီးဟှာ ‘ကိုယ်တော်ဟှာ ဂါလိလဲပြည်ဟှို ရင်ဦးဆောင်း သွားမယ်။ နန်းနို့ဟှို ကိုယ်တော် ပြောဟှားဟှူ တိုင်းဘဲ့ အယ်နေရာမာ နန်းနို့ဟှာ ကိုယ်တော့်ဟှို တွိရလေ့မယ် ဆိုဘီး ပြောဂေ့ပါ။’ ” ");
INSERT INTO tvn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","အယ်ကြောန့် မီးမဂီးလေဟှာ စိုးရိမ်ထိလန့်ဘီး သန်းခ္လိုင်းဟှနေ ထွပ်လာဘီး ပ္လေးဟှားဂေ့ဟှယ်။ သူးနို့ဟှာ ကြော့‑က်နေဂေ့ကြောန့် ဖယ်သူဟှိုလည်း ဖြားလည်းပြောဂေ့ဟှ။ ဒန်းကောန်း နည်းဟောန်းဆောင်းသတ်တမျိုး  ");
INSERT INTO tvn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ယေရှုဟှာ နန်းနွေနေ့ မိုးလန်းစောစောမာ သေရာဟှနေ ထမြော့‑က်ဘီးန၊ ကိုယ်တော်ဟှာ နတ်ဆိုးခွန်နစ်ကောန် ထွပ်ဟှားဟှူ မာဂဒလဗြို့သူ မာရိဟှို ရင်ဦးဆောင်း ကိုယ်ထန်ရှားပြဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","သူဟှာ ကိုယ်တော်ရဲ့ ပေါန်းဖော်လေနားဟှို သွားဘီး ပြောလေဟှယ်။ သူးနို့ဟှာ မြည်တမ်း ငိုကြွေနေဘီး ");
INSERT INTO tvn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","အယ်ဘီးဟှာ ယေရှုဟှာ သတ်ရှင်နေဟှယ် ဆိုဇာန သူဟှာ ကိုယ်တော့်ဟှို တွိလိုက်ဟှယ် ဆိုဘီး သူ့ရဲ့ ပြောဟှူစကားဟှို သူးနို့ကြားလိုက်ဟှူ ခီမာ သူးနို့ဟှာ သူ့ဟှို ယောင်ကြည်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","အယ်ဘီးန သူးနို့ထဲဟှ နှေ့ယော့‑က်ဟှာ တောဝါဟှို လမ်းရှော့‑က်သွားနေဒူးမာ ယေရှုဟှာ ခြားနားဟှူ ပေါင်စံန သူးနို့ဟှို ကိုယ်ထန်ရှားပြဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","သူးနို့ဟှာ တခြားလူလေနားဟှို ပ္လန်ဟှားဘီးဟှာ ပြောပြလေဟှယ်။ အယ်ဘေမဲ့ အယ်ဒန်းဟှို သူးနို့ဟှာ ယောင်ကြည်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","အယ်ဘီးန တဗဲ့တော်ဆယ့်တပါး စားသော့‑က်နေဟှူ ခီမာ ယေရှုဟှာ သူးနို့ဟှို ကိုယ်ထန်ရှားပြလေဟှယ်။ သူးနို့ဟှာ ယောင်ကြည်ဘဲန စိနှလောင်းမာကျောနေဘီး ကိုယ်တော် ထမြော့‑က်ဘီးန ကိုယ်တော့်ဟှို တွိရဟှူ လူလေရဲ့စကားဟှို ယောင်ကြည်ဘဲဟှူကြောန့် ယေရှုဟှာ သူးနို့ဟှို ဆောင်းမလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ကိုယ်တော်ဟှ သူးနို့ဟှို “တကမ္ဘာလောင်းဟှို ပ္လံ့နှံ့အောန်သွားဘီး လူတိုင်းဟှို ဒန်းကောန်း ဟောပြောဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ယောင်ကြည်ဘီး ဗတ္တိဇံခံဟှူလူ မှန်မျှဟှာ ကယ်တန်ခံရလေ့မယ်၊ ယောင်ကြည်ဘဲဟှူ လူမှန်မျှဟှာ ပြစ်စီရင်ခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ယောင်ကြည်သူလေဟှာ နိမိတ်လတ်ခဏာလေ ပြဟှို့တွပ် တဂိုးဟှို ပေးအပ်ခံရလေ့မယ်၊ သူးနို့ဟှာ ငါ့နာမဟှို အားကိုးဘီး နတ်ဆိုးလေဟှို နှန်ထုဂေ့လေ့မယ်၊ သူးနို့ဟှာ ထူးဆန်းဟှူ ဘာသာစကားလေဟှို ပြောဂေ့လေ့မယ်၊ ");
INSERT INTO tvn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","သူးနို့ဟှာ ဗွီလေဟှို ကိုင်ဂေ့လေ့မယ်။ သေစေတတ်ဟှူ ဖြားမျိုးဆိလေဘဲ့ဖြစ်ဖြစ် သော့‑က်မယ် ဆိုဟှာ ဥပါဒ်ဖြစ်ဟှ။ ကျန်းမာဘဲဟှူ လူနာလေထတ်မာ လတ်တန်ဟှူ ခီမာ လူနာလေဟှာ ကျန်းမာဟှားလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","သခင်ယေရှုဟှာ သူးနို့န စကားပြောဘီးန ကောန်းဂန်ဘောင်ဟှို ယူဆောန်ခံရဘီးဟှာ ဘုရားသခင်ရဲ့ ညာဖတ်မာ ထိုင်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","တဗဲ့တော်လေဟှာ နေရာရှိမျှဟှို သွားဘီးဟှာ ဟောပြောဂေ့ဟှယ်။ အယ်ဘီးဟှာ သခင်ဘုရားဟှာ သူးနို့လေနတူးဒူ လောက်ဆောန်နေဘီး အယ်မျိုးလောက်ဆောန်ဟှူ နိမိတ်လတ်ခဏာလေအားဖြင့် သူးနို့ရဲ့ တရားဟောချစ်ဟှာ မှန်ဟှယ် ဆိုဇာဟှို သတ်သေပြလေဟှယ်။ တခြားကျမ်းဟောန်းဆောင်းသတ်  ");
INSERT INTO tvn_vpl VALUES ("MK16_21","071_16_21","MRK","16","21","21","မီးမဂီးလေဟှာ ပေတရုန သူ့ငယ်ဂျင်းလေနားဟှို သွားဂေ့ဘီး၊ သူးနို့ကြားရဟှူ ဒန်းလေဟှို ပ္လန်ဘီးပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("MK16_22","071_16_22","MRK","16","22","22","အယ်ဘီးန ယေရှုကိုယ်တိုင်ဟှာ သူ့တဗဲ့တော်လေဟှို ထာဝရကယ်တန်ဇာ ဒန်းစကားဟှို ပြောဟှို့တွပ် ရှေ့ဟှနေ နော့‑က်ဟှို လွှတ်လိုက်ဟှယ်။");
INSERT INTO tvn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ရှစ်ရဟှူ သော်ဖိလု၊ ကျွန်တော့်ဟှားလေထဲမာ ဖြစ်ပျစ်နေဟှူ ကြောန်းရာလေဟှို ကောန်းဆောင်း ရေးသားဟှားဟှူ လူလေဘောင်ဂီး ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","သူးနို့လေဟှာ အယ်ဖြစ်ပျစ်ဇာလေဟှို စစဒူးဟှ ဗြင်ဟှူလူလေန ဒန်းကောန်းဟှို ဟောပြောဟှူ မှုဆောန်လေ ပ္လန်ပြောပြဇာလေဟှို ကျမ်းပြု ပေါက်ကိုလေဟှ ရေးသားဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","သော်ဖိလု၊ ကျွန်တော်ဟှာ အယ်ကြောန်းရာလေဟှို ဖြစ်ပျစ်ခီဟှနေ စဘီး သေးသေချားချာ လေ့လာဟှားဟှူ လူဖြစ်ကြောန့် သင်ဖတ်ရှုနိုင်ဟှို့တွပ် စီစဉ်က္လက္လန ကျမ်းစာဟှို ရေးသားမယ် ဆိုဟှာ ကောန်းဆောင်း ဖြစ်မယ် ဆိုဘီး ယူဆဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","အယ်ကြောန့် သင်ကြားသိဟှားဟှူ ကြောန်းရာလေဟှို သေးသေချားချာန သင့်ဟှို သိစေရှင်ကြောန့် အယ်ကျမ်းစာဟှို ရေးသားဟှားဇာ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ယုဒပြည်ဟှို အောက်ချောက်ရဟှူ ဟေရုဒ်မန်းဂီး လတ်ထတ် အဘိယသင်းဝမ် ဖြစ်ဘီး ဇာခရိ နာမယ်ရှိဟှူ ယဇ်ပုရောဟိတ် တယော့‑က်ရှိဟှယ်။ သူ့မီးမ နာမယ်ဟှာ ဧလိရှဗက် ဖြစ်ဘီး သူဟှာ အာရုန်ရဲ့ မျိုးနွယ်လည်း ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","သူးနို့ နှေ့ယော့‑က်ဟှာ ဘုရားသခင်ရဲ့ ရှေ့တော်မာ ဖြောန့်မတ်သူလေဖြစ်ဘီး ကိုယ်တော်ရဲ့ ပညတ်တော်လေန မိန့်တော်လေ ဂူလောင်းဟှို ကျင့်ဆောန်ဟှူကြောန့် ပြစ်တန်ဇာမှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ဧလိရှဗက်ဟှာ မ္လုံနေဟှူကြောန့် သူးနို့မာ သားမီးမှေ့ဟှ။ ဇာခရိန သူ့မီးမ နှေ့ယော့‑က်လောင်းဟှာ ရရာတိုင်း အိုနေဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","တရစ်မာ ဇာခရိဟှာ သူ့မှုဆောန်ရဟှို့ လှည့်ရော့‑က်ကြောန့် ဘုရားသခင်ရှေ့မာ ယဇ်ပုရောဟိတ်လောက်ဟှို လောက်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ယဇ်ပုရောဟိတ်လေရဲ့ ထောင်းဇံတိုင်း သူဟှာ ယဇ်ပလ္လင်ထတ်မာ နံ့သာပေါန်းဟှို မီးရှို့ဟှို့ ဝီးကော့‑က်ခံရဟှယ်။ အယ်ကြောန့် သူဟှာ သခင်ဘုရားရဲ့ ဗိမာန်တော်ထဲဟှို ဝမ်ဟှားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","နံ့သာပေါန်းဟှို မီးရှို့နေခီမာ ပ္လန်မာနေဟှူ လူလေ ဂူလောင်းဟှာ ဆုတောန်းဘီး နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","အယ်ခီမာ သခင်ဘုရားရဲ့ ကောန်းဂန်တမန်ဟှာ သူ့ရှေ့မာ ပေါ်လာဘီး နံ့သာပေါန်းဟှို မီးရှို့ဟှူ ယဇ်ပလ္လင်ရဲ့ ညာဖတ်မာ ရပ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ဇာခရိဟှာ ဗြင်လိုက်ခီမာ ကြော့‑က်ရွံ့ ထိလန့်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","အယ်ဘေမဲ့ ကောန်းဂန်တမန်ဟှ “ဇာခရိ၊ ကြော့‑က်န! ဘုရားသခင်ဟှာ နန့်ရဲ့ ဆုတောန်းသံဟှို ကြားဘီး နန့်ရဲ့ မီးမ ဧလိရှဗက်ဟှာ သားမွီးရလေ့မယ်။ အယ်သားဟှို ယောဟန်နာမယ်န မှတ်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","အယ်သားဟှို မွီးခီမာ နန်ဟှာ ရရာတိုင်း ဝန်းသာဘီး လူလေဟှာလည်း ဝန်းသာလေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ယောဟန်ဟှာ ဘုရားသခင်ရှေ့တော်မာ ရရာတိုင်း ကီးမြတ်ဟှူ လူဖြစ်လေ့မယ်။ သူဟှာ ဝိုင်န ယစ်သေဇာဟှို လောင်းဝသော့‑က်ဟှ။ မွီးဂဒဲဟှ သူဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န ပ္လဲ့ဝနေဘီး ");
INSERT INTO tvn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","သူဟှာ ဣသရေလလူမျိုး များစုဟှို သူးနို့ရဲ့ သခင်ဖြစ်ဟှူ ဘုရားသခင်နားဟှို ပ္လန်ခေါ်ဆောန်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","သူဟှာ ပရောဖက်ဧလိယမျိုး ခွန်အားန တဂိုးကီးဘီး သခင်ဘုရားရှေ့တော်ဟှို သွားလေ့မယ်။ သူဟှာ ဖခင်လေရဲ့ စိနှလောင်းဟှို သားမီးလေဖတ်ဟှို ပ္လန်လှည့်စေဘီး သူဟှာ နားထောန်ဘဲဟှူ လူလေဟှာ ဖြောန့်မတ်ဟှူလမ်းဟှို ပ္လောန်းလဲစေဘီး သခင်ဘုရားတွပ် ဆင်သင့်ဖြစ်နေဟှို့ ကိုယ်တော့် လူမျိုးဟှို ပြင်ဆင်ဟှားဟှယ်” ဆိုဘီး ဇာခရိဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ဇာခရိဟှ “အယ်မျိုးဖြစ်မယ် ဆိုဇာဟှို ကျွန်တော် ဖြားမျိုးသိရနူး။ ကျွန်တော်ဟှာ ဖိုးသန်ဂီးဖြစ်နေဘီ။ ကျွန်တော့် မီးမဟှလည်း ဖွားသန်မဖြစ်နေဘီ” ဆိုဘီး ကောန်းဂန်တမန်ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ကောန်းဂန်တမန်ဟှ “ငါဟှာ ဂါဗြေလဖြစ်ဟှယ်။ ငါဟှာ ဘုရားသခင်ရဲ့ ရှေ့တော်မာ ရပ်နေသူဖြစ်ဘီး နန့်ဟှို အယ်ဒန်းကောန်း ပြောဟှို့တွပ် ငါ့ဟှို စေလွှတ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","နန်ဟှာ ငါ့ပြောဟှူ အယ်ဒန်းကောန်းဟှို ယောင်ကြည်ဘဲ ဖြစ်နေဘေမဲ့လည်း သတ်မှတ်ဟှားဟှူ ခီရော့‑က်ဟှာ ပ္လဲ့ဇောင်လာလေ့မယ်။ နန်ဟှာ ငါပြောဟှူ ဒန်းကောန်းဟှို ယောင်ကြည်ဘဲဟှူကြောန့် ငါ့ဂဒိတော်လေဟှာ နန့်မာ ပ္လဲ့ဇောင်ခန်နေ့ထိ စကားပြောနိုင်ဘဲ အ,ဘီး နေရလေ့မယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","လူလေဟှာ ဇာခရိဟှို စောန့်မျှော်နေဘီး ဗိမာန်တော်ထဲမာ ကြာဂီးနေဇာဟှို အံ့ဩနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ဇာခရိဟှာ ထွပ်လာဟှူ ခီမာ စကားပြောနိုင်ဘဲဟှူကြောန့် ဗိမာန်တော်ထဲမာ ရူပါရောင် ဗြင်ရကြောန်းဟှို သူးနို့ သိဂေ့ဟှယ်။ စကားတလောင်းလည်း ပြောနိုင်ဘဲကြောန့် သူဟှာ သူးနို့လေဟှို လတ်ရိလတ်ခေနဘဲ့ ချစ်ပြလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ဗိမာန်တော်ထဲမာ ယဇ်ပုရောဟိတ်မှုဟှို ဆောန်ရွက်ရဟှို့ ခီပီးဆောင်းဟှားကြောန့် ဇာခရိဟှာ အီဟှို ပ္လန်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","အယ်ဘီးန သူ့မီးမ ဧလိရှဗက်ဟှာ ဗိုက်ပိုက်နေဟှူကြောန့် ငါးလလောင်းလောင်း အီပ္လန်ဟှို ထွပ်ဘဲနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","အယ်မီးမဟှ “ခု သခင်ဘုရားဟှာ ငါ့ဟှို မဇတော်မူလိုက်ဘီ။ ကိုယ်တော်ဟှာ ငါ့ဟှို လူလေကဲ့ရဲ့ ဝေဖန်နေဇာလေဟှို ပယ်ရှင်းပေးတော်မူလိုက်ဘီ!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ဧလိရှဗက်ရဲ့ ဗိုက်ဟှာ ခြော့‑က်လဟှို ရော့‑က်လာဟှူ ခီမာ ဘုရားသခင်ဟှ ကောန်းဂန်တမန် ဂါဗြေလဟှို ဂါလိလဲပြည် နာဇရက် နာမယ်ရှိဟှူ ဗြို့ဟှို လွတ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ဒါဝိဒ်မန်းဂီးရဲ့ သားမ္လေးဖြစ်ဘီး ယောသပ် နာမယ်ရှိဟှူ လူတယော့‑က်န လတ်ထပ်ဟှို့ စေ့စပ်ဟှားဟှူ မီးမပျိုတွပ် သူ့မာ ဒန်းစကား ရှိဟှယ်။ အယ်မီးမပျိုရဲ့ နာမယ်ဟှာ မာရိ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ကောန်းဂန်တမန်ဟှာ ရော့‑က်လာဘီး “နန့်နတူးဒူ ငြီသတ်မှုရှိပါစေ! နန့်နတူးဒူ သခင်ဘုရား ရှိဘီး နန်ဟှာ ရရာတိုင်း မင်္ဂလာရှိဟှယ်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ကောန်းဂန်တမန်ရဲ့ စကားကြောန့် မာရိဟှာ စိနှလောင်းငြီသတ်ဘဲ ဖြစ်ဟှားဘီး သူ့စကားလေဟှာလည်း အံ့ဩဘွယ် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ကောန်းဂန်တမန်ဟှ “မာရိ၊ ကြော့‑က်န။ နန်ဟှာ ဘုရားသခင်ရှေ့မာ မျစ်နှာသာရဟှားဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","နန်ဟှာ ဝန်းရှင်မဖြစ်လာဘီး သားဟှို မွီးရလေ့မယ်။ အယ်သားဟှို ယေရှု ဆိုဘီး နာမယ်ပေးရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","သူဟှာ ကီးမြတ်ဟှူ သူဖြစ်ဘီး ဗြစ်ဆောင်းဟှူ ဘုရားသခင်ရဲ့ သား ဆိုဘီး ခေါ်ဇာဟှို ခံရလေ့မယ်။ သူ့ဘိုးဘေ ဒါဝိဒ်ရဲ့ ရာဇပလ္လင်ဟှို ထာဝရသခင် ဘုရားသခင်ဟှာ သူ့ဟှို ပေးအပ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","သူဟှာလည်း ယာကုပ်ရဲ့ မျိုးနွယ်ဟှို မြဲဒမ်း အောက်ချောက်လေ့မယ်။ သူ့နိုင်ငံတော်ဟှာ လောင်းဝ ဆောင်းမှေ့ဟှ!” ဆိုဘီး အယ်မီးမဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","မာရိဟှ ကောန်းဂန်တမန်ဟှို “ကျွန်မဟှာ မီးမပျို ဖြစ်ဟှယ်။ အယ်မျိုးဆိုဟှာ ဖယ်မျိုးလောက်ဘီး သားမွီးနိုင်ဟှို့နူး။” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ကောန်းဂန်တမန်ဟှာ “သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှာ နန့်ထတ်မာ သတ်ရော့‑က်ဘီး ဗြစ်ဆောင်းဖြစ်ဟှူ ဘုရားသခင်ရဲ့ တဂိုးတော်ဟှာလည်း နန့်ထတ်မာ လွှမ်းမိုးနေလေ့မယ်။ အယ်ကြောန်းကြောန့် သန့်ရှင်းဟှူ သားတော်ဟှာ ဘုရားသခင်ရဲ့ သားဆိုဘီး ခေါ်ဇာဟှို ခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","နန့်ရဲ့ ဆွေမျိုး ဧလိရှဗက်ဟှို ဒိရဂေ့။ မြုံမ ဆိုဘီး ခေါ်ခံနေရဟှူ သူဟှာ ဖွားသန်မ ဖြစ်နေဘေမဲ့ ခု ဝန်းရှင်မ ဖြစ်နေဇာ ခြော့‑က်လရှိနေဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","အယ်ကြောန့် ဘုရားသခင်မာ လောက်နိုင်ဘဲဇာ ဖြားလည်းမှေ့ဟှ” ဆိုဘီး မိန့်တော်မူလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","မာရိဟှ “ကျွန်မဟှာ သခင်ဘုရားရဲ့ စေခံဖြစ်ဟှယ်။ ကိုယ်တော်ပြောဟှားတိုင်း ကျွန်မမာ ပ္လဲ့ဇောင်ပါစေ” ဆိုဘီး ပြောဟှယ်။ အယ်ဘီးန ကောန်းဂန်တမန်ဟှာ မာရိနားဟှ ထွပ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","အယ်မျိုးဖြစ်ဘီး ကြာခန်မာဘဲ့ မာရိဟှာ သင့်ပြင်ဘီးန တောန်ထတ်ဒေသမာရှိဟှူ ယုဒပြည် ဗြို့တဗြို့ဟှို ဗြန်းဗြန်သွားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ဇာခရိရဲ့ အီဟှို ဝမ်ဘီး ဧလိရှဗက်ဟှို နှောက်ဆစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","မာရိရဲ့ နှောက်ဆစ်စကားဟှို ဧလိရှဗက်ကြားဟှူ ခီမာ ဗိုက်ထဲဟှ သားဂန်ဟှားဟှာ ထခူလေဟှယ်။ ဧလိရှဗက်ဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န ပ္လဲ့နေဘီး ");
INSERT INTO tvn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","သံက္လယ်ဂီးန “နန်ဟှာ မီးမလေ ဂူလောင်းထတ် မင်္ဂလာရှိဆောင်း ဖြစ်ဘီး နန်မွီးမယ့် သားဟှာလည်း မင်္ဂလာရှိဆောင်း ဖြစ်ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ငါ့သခင်ရဲ့ မိခင်ဟှာ ငါ့နားဟှို အီးခ္လယ်လာကြောန့် အယ်မျိုးကီးမားဟှူဇာလေ ဖြစ်နေဇာလော။ ");
INSERT INTO tvn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","နန့်ရဲ့ နှောက်ဆစ်စကားဟှို ကြားလိုက်ဟှူန ရှင်းရှင်းဘဲ့ ငါ့ဗိုက်ထဲဟှ သားဂန်းဟှားဟှာ ဝန်းသာအားရ ထခူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","သခင်ဘုရားရဲ့ ဒန်းစကားဟှာ နန့်မာ ပ္လဲ့ဇောင်လေ့မယ် ဆိုဇာဟှို ယောင်ကြည်ဟှူ မီးမဟှာ မင်္ဂလာရှိဟှယ်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","မာရိဟှ၊ “ငါ့ရဲ့ စိနှလောင်းဟှာ သခင်ဘုရားဟှို ချီးမွမ်းဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ငါ့ရဲ့ ကယ်တန်ရှင် ဘုရားသခင်ကြောန့် ငါ့ရဲ့ ဝိညာဉ်ဟှာ ဝန်းသာအားရဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ကိုယ်တော်ဟှာ သူ့စေခံရဲ့ နှိခ္လနေဇာဟှို အော့‑က်မေ့တော်မူဘီ! ခုဟှစဘီး လူလေ ဂူလောင်းဟှာ ငါ့ဟှို မင်္ဂလာရှိသူ ဆိုဘီး ခေါ်ဂေ့လေ့မယ်၊ ");
INSERT INTO tvn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ တဂိုးန ပ္လဲ့ဇောင်တော်မူဟှူ ဘုရားသခင်ဟှ ရရာတိုင်း ကီးမားဇာလေဟှို ငါ့တွပ် ပြုတော်မူကြောန့် ဖြစ်ဟှယ်။ ဘုရားသခင်ရဲ့ နာမတော်ဟှာ သန့်ရှင်းတော်မူဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","မျိုးဆစ် ဆစ်ဘီးဆစ် ကိုယ်တော့်ဟှို ကိုးကွယ်သူလေဟှို ကိုယ်တော်ဟှာ ကရုဏာဟှို ပြတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ကိုယ်တော့် လတ်ရောင်းတော်ဟှို ဆန့်တန်းဘီး သူးနို့စိနှလောင်းထဲဟှ ကြံစည်လေန မာနထောန်လွှားနေဟှူ လူလေဟှို ဖ္လဲဖ္လဲစင်စေမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","မန်းဂီးလေဟှို သူးနို့ရာဇပလ္လင်ထတ်ဟှ ခ္လဘီးန နှိခ္လဟှူ လူလေဟှို မ္လော့‑က်စားတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ငတ်နေဟှူ လူလေဟှို ကောန်းဟှူ ဇာလေန ကျွေးဘီးန ကြွယ်ဝဟှူ လူလေဟှို လတ်ခဲခဲ လွှတ်လိုက်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ကိုယ်တော်ဟှာ နို့လေရဲ့ ဘိုးဘေးလေဟှို ပေးဟှားဟှူ ဂဒိတော်တိုင်း ကိုယ်တော်ရဲ့ စေခံဖြစ်ဟှူ ဣသရေလလူမျိုးဟှို ကရုဏာပြဟှို့ ကြွလာတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ကိုယ်တော်ဟှာ အာဗြဟံန သူ့မျိုးနွယ် ဂူလောင်းဟှို ကရုဏာ ကျေးဇူးတော်ဟှို မြဲဒမ်းပြဟှို့ အော့‑က်မေ့တော်မူဘီး!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","မာရိဟှာ ဧလိရှဗက်နတူးဒူ သောင်းလနီးပါး နေဘီးမှ မိမိအီဟှို ပ္လန်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ဧလိရှဗက်ဟှာ ဖွားခီရော့‑က်လာဘီး သားဂန်းဟှို မွီးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","အီဇနီးရှင်းလေန ဆွေမျိုးလေဟှ သခင်ဘုရားဟှာ အံ့ဩဘွယ် ကောန်းအောန် ကရုဏာ ပြတော်မူကြောန်းဟှို ကြားဘီးန သူးနို့ ဂူလောင်းဟှာ သူ့နတူးဒူ ဝန်းသာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ရှစ်ရစ်ပ္လဲ့ဟှူ ခီမာ သူးနို့ဟှာ သားဂန်းရဲ့ ရေဖျားလှီးဟှို့ လာဂေ့ဘီးန သူးနို့ဟှာ သူ့ဖရဲ့ နာမယ်တိုင်း ဇာခရိ ဆိုဘီး နာမယ်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","အယ်ဘေမဲ့ သူ့မိဟှ “အယ်နာမယ် ပေးန! သူ့နာမယ်ဟှို ယောဟန် ဆိုဘီး ပေးရမယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","သူးနို့ဟှ “ယောဟန်နာမယ်န နန်းနို့ဆွေမျိုးထဲမာ မှေ့ဟှ!” ဆိုဘီး သူ့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","အယ်ဘီးန သူးနို့ဟှာ သူ့ဖဟှို လတ်ရိလတ်ခေပြဘီး သားဂန်းနာမယ်ဟှို ဖယ်မျိုးပေးရဟှို့ ဆိုဘီး မေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ဇာခရိဟှာ သန်းဖူးကီးဟှို တောန်းဘီးန “သားဂန်းဟှား နာမယ်ဟှာ ယောဟန် ဖြစ်ဟှယ်” ဆိုဘီး ရေးပေးလိုက်ဟှယ်။ သူးနို့ ဂူလောင်းဟှာ အံ့ဩဟှားဂေ့ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","အယ်ခီမာဘဲ့ ဇာခရိဟှာ ပ္လန်ဘီး စကားပြောနိုင်ဟှားဘီးန သူဟှာ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟှို စဘီးချီးမွမ်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","အီဇနီးရှင်းလေ ဂူလောင်းဟှာ ကြော့‑က်ရွံ့မှုလေန ပ္လဲ့နေဘီး အယ်ဖြစ်ပျစ်ဇာန ဆိုင်ဟှူဒန်းလေဟှို ယုဒပြည် တောန်ကြားနေရာ နှံ့ပ္လားမာ လူလေဟှာ ပြောနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","အယ်ဒန်းဟှို ကြားရဟှူ လူလေဂူလောင်းဟှာ စိထဲမာ စဉ်းစားဘီးဟှာ မေးနေဇာဟှ “အယ်သားဂန်းဟှ ဖယ်မျိုးသားဂန်းနူး။” သခင်ဘုရားရဲ့ တဂိုးတော်ဟှာ အယ်သားဂန်ထတ်မာ ရှိနေကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ယောဟန်ရဲ့ဖ ဇာခရိဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န ပ္လဲ့ဝဘီး ပရောဖက်ပြုဟှူဇာဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ဣသရေလလူမျိုးရဲ့ ဘုရားသခင်၊ သခင်ဘုရားဟှို နို့လေချီးမွမ်းဂေ့ဇို့! ကိုယ်တော်ဟှာ ကိုယ်တော်ရဲ့ လူမျိုးနားဟှို ကြွလာဘီး သူးနို့ဟှို လွတ်မြော့‑က်စေတော်မူဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ကိုယ်တော်ရဲ့ စေခံဒါဝိဒ်ရဲ့ မ္လေးမ္လစ် တယော့‑က်ဟှို၊ ကိုယ်တော်ဟှာ တဂိုးကီးမားဟှူ ကယ်တန်ရှင်ဟှို နို့လေတွပ် ပေါ်ပေါ့‑က်စေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ကိုယ်တော်ဟှာ ကိုယ်တော်ရဲ့ ရှေးသန့်ရှင်းဟှူ ပရောဖက်လေ ဟှနေတဆင့် ဂဒိပေးဟှားဇာဟှ ");
INSERT INTO tvn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ကိုယ်တော်ဟှာ နို့လေရဲ့ ရန်သူလတ်ဟှရော၊ နို့လေဟှို မူးဟှူသူ ဂူလောင်းရဲ့ တဂိုးဟှရော နို့လေဟှို ကယ်တန်တော်မူလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ကိုယ်တော်ဟှာ နို့လေရဲ့ ဘိုးဘေးလေဟှို ကရုဏာတော် ပြဘီးဟှာ ကိုယ်တော်ရဲ့ သန့်ရှင်းဟှူ ပဋိညာဉ်တော်ဟှို အော့‑က်မေ့ပါ ဆိုဘီး ပြောဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","နို့လေရဲ့ ဘိုးဘေး အာဗြဟံဟှို လေးနတ်ဟှူ ဂဒိသစ်စာ ပြုဟှားဇာဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ကိုယ်တော်ဟှာ နို့လေရဲ့ ရန်သူလေ လတ်ထဲဟှနေ နို့လေဟှို ကယ်တန်ဟှို့န ကြော့‑က်လန့်မှုမှေ့ဘဲ့ ကိုယ်တော့်ဟှို စေခံဟှို့ နို့လေဟှို ခွမ့်ပြုမယ် ဆိုဘီး ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","အယ်ကြောန့် နို့လေဟှာ ကိုယ်တော့်ရှေ့တော်မာ သန့်ရှင်းရှင်းန ဖြောန့်မတ်ရှင်းဟှို တသတ်လောင်းရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“သားဂန်းဟှား၊ နန့်ဟှိုလည်း ဗြစ်ဆောင်းဖြစ်ဟှူ ပရောဖက်ဆိုဘီး ခေါ်ဇာဟှို ခံရလေ့မယ်။ နန်ဟှာ သခင်ဘုရားရဲ့ လမ်းဟှို ပြင်ဆင်ဟှို့ ရှေ့တော်ပ္လေး သွားရလေ့ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ကိုယ်တော်ရဲ့ လူလေဟှို သူးနို့ရဲ့ ပြစ်လေ ဖြေလွှတ်ပေးဇာခံရကြောန့် ကယ်တန်ခံရလေ့မယ် ဆိုဘီး ပြောလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","နို့လေရဲ့ ဘုရားသခင်ဟှာ သနားကြင်နာမှုန ကရုဏာတော် ဖြစ်ဟှူကြောန့် ကိုယ်တော်ဟှာ ကယ်တန်မှုရဲ့ မိုးလန်းဇခီဟှို နို့လေထတ်မာ သတ်ရော့‑က်စေဘီး ");
INSERT INTO tvn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","မှောန်မိုက်န သေမန်းရဲ့ ရိထဲမာ ရှိနေဟှူ လူလေ ဂူလောင်းထတ်မာ ကောန်းဂန်ဟှနေ လန်းရောန်ထွန်းလန်းဟှို့န၊ ငြီသတ်ရှင်းလမ်းထဲမာ နို့လေရဲ့ ခေလှမ်းလေဟှို ပြဟှို့ဖြစ်ဟှယ်” ဆိုဘီး ဘုရားသခင်ရဲ့ စကားတော်ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","အယ်သားဂန်းဟှာ ကီးဒတ်လာဘီး ခန္ဓာန ဝိညာဉ်လည်း အားကီးလာဟှယ်။ သူဟှာ ဣသရေလ လူမျိုးလေရဲ့ ရှေ့မာ ထန်းထန်ရှားရှား ပေါ်လာခန်ဒူးဟှ ဆိုဟှာ တောကန္တရထဲမာ နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","အယ်ခီမာ ကဲသာမန်းဂီး ဩဂုတ္တုဟှာ ရောမအင်ပါယာ တခုလောင်းဟှို သန်းဂေါန်စာရင်း ကော့‑က်စေဟှို့ မိန့်ပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ကုရေနိဟှာ ရှုရိပြည်မာ ဗြို့ဝန်ဖြစ်ခီမာ အယ်သန်းဂေါန်စာရင်း ကော့‑က်ဇာဟှာ ဦးဆောင်း ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","အယ်ဘီးန လူတိုင်းဟှာ ကိုယ်တိုင် သန်းဂေါန်စာရင်းဝမ်ဟှို့ သူးနို့ရဲ့ ဇာတိဗြို့ဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ယောသပ်ဟှာ ဂါလိလဲပြည် နာဇရက်ဗြို့ဟှနေ ဒါဝိဒ်မန်းရဲ့ ရှစ်မ္လောက်နေရာဖြစ်ဟှူ ယုဒပြည် ဗက်လင်ဗြို့ဟှို သွားဟှယ်။ ယောသပ်ဟှာ ဒါဝိဒ်ရဲ့ မ္လေးမ္လစ်ဖြစ်ကြောန့် အယ်နေရာဟှို သွားရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","သူဟှာ လတ်ထပ်ဟှို့ စေ့စပ်ဟှားဟှူ မာရိနတူးဒူ သန်းဂေါန်စာရင်းဝမ်ဟှို့ သွားဟှူ ခီမာ မာရိဟှာ ဝန်းရှင်မ ဖြစ်နေဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","သူးနို့ဟှာ ဗက်လင်ဗြို့မာ ရှိနေဒူးမာ သားမွီးခီ ရော့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","သူဟှာ သားဦးဟှို မွီးဘီး ဝတ်န ပတ်ဘီးဟှာ တည်းခိုဟှူ နေရာမာ သူးနို့တွပ် ခန်းမှေ့ဘဲကြောန့် သားဂန်းဟှားဟှို နွားစားခွပ်ထဲမာ အိခိုင်းဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","အယ်ရပ်ဟှ သိုးထီးမားတချို့ဟှာ တညဉ့်လောင်း ကွမ်းပ္လန်မာနေဘီး၊ သူးနို့ရဲ့ သိုးလေဟှို ကေ့ရှုဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","သခင်ဘုရားရဲ့ ကောန်းဂန်တမန်ဟှာ သူးနို့နားမာ ပေါ်လာဘီး ဘုရားသခင်ရဲ့ ဖောင်းသရေတော်ဟှာ သူးနို့ထတ်မာ လန်းထီလာဟှယ်။ သူးနို့ဟှာ ရရာတိုင်း ကြော့‑က်လန့်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","အယ်ဘေမဲ့ ကောန်းဂန်တမန်ဟှာ သူးနို့ဟှို ပြောလိုက်ဇာဟှ၊ “ကြော့‑က်ဂေ့န! ငါဟှာ လူမျိုးအားလောင်းတွပ် ရရာတိုင်း ဝန်းသာဇာ ဒန်းကောန်းဟှို သယ်ဆောန်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","အယ်နေ့မာ ဒါဝိဒ်ဗြို့နှိုက် သခင်ခရစ်တော် ဆိုဘီး နန်းနို့ရဲ့ ကယ်တန်ရှင်ဟှို မွီးလေဘီ! ");
INSERT INTO tvn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","နန်းနို့ဟှာ ဖယ်မျိုးသတ်သေန သိရဟှို့ ဆိုဟှာ သားဂန်းဟှားဟှို ဝတ်စန ပတ်ဘီး နွားစားခွပ်ထဲမာ အိခိုင်းဟှားဇာဟှို တွိလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ရောက်တရစ် ကောန်းဂန်ဘောင်ရဲ့ ကောန်းဂန်တမန်နတူးဒူ ကောန်းဂန်ဗိုလ်ခေ ဘောင်ဂီးဟှာ ရှစ်ရှင်းထန်ရှားဘီး ဘုရားသခင်ဟှို ");
INSERT INTO tvn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ဗြင့်ဆောင်းကောန်းဂန်မာ ဘုရားသခင်ဟှာ ဖောင်းသရေတော်ရှိဘီး၊ မ္လေဂီးမာ ကိုယ်တော်မြတ်နိုးဟှူ လူလေဟှာ ငြီသတ်မှုရှိပါစေ!” ဆိုဘီး ချီးမွမ်းချင်းဟှို ဆိုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ကောန်းဂန်တမန်လေဟှာ သူးနို့နားဟှနေ ကောန်းဂန်ဘောင်ဟှို ပ္လန်ဟှားခီမာ သိုးထီးမားလေဟှာ ယော့‑က်နယော့‑က် “ဗက်လင်ဗြို့ဟှို သွားဘီး ဘုရားသခင်ဟှာ နို့လေဟှို ပြောပြဟှူ ကြောန်းရာလေဟှို ကေ့ကေ့ရအောန်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","အယ်ကြောန့် သူးနို့ဟှာ ဗြန်းဗြန်ဟှားသွားဘီးန မာရိန ယောသပ်ဟှိုရော၊ နွားစားခွပ်ထဲမာ အိနေဟှူ သားဂန်းဟှားဟှိုရော တွိရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","သိုးထီးမားလေဟှာ သားဂန်းဟှားဟှို တွိဟှူ ခီမာ သူးနို့ဟှို ကောန်းဂန်တမန်ဟှ သားဂန်းဟှားကြောန်းဟှို ဖယ်မျိုးပြောဟှားဟှယ် ဆိုဇာဟှို သူးနို့ဟှို ပြောပြဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","သိုးထီးမားလေပြောဟှူ စကားဟှို ကြားဟှူလူလေ ဂူလောင်းဟှာ အံ့ဩဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","မာရိဟှာ ကြောန်းရာလေ ဂူလောင်းဟှို အော့‑က်မေ့လာဘီး အယ်စကားလေဟှို လေးလေးနတ်နတ် စိထဲမာ ဆင်ခြင်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","သိုးထီးမားလေဟှာ သူးနို့ဟှို ကောန်းဂန်တမန် ပြောဟှားတိုင်း သူးနို့ဗြင်ရ ကြားရဇာလေ ဂူလောင်းတွပ် ဘုရားသခင်ဟှို ချီးမွမ်းချင်းဆိုဘီး ပ္လန်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","တဘတ်ကြားဘီးန သားဂန်းဟှားတွပ် ရေဖျားလှီးပေးရဟှို့ ခီရော့‑က်လာဘီး ဗိုက်မှေ့ခန်ဟှ ကောန်းဂန်တမန် ပေးဟှားဟှူတိုင်း သူ့ဟှို ယေရှုနာမယ်ဖြစ် မှည့်ခေါ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","မောရှေရဲ့ ပညတ်တရားတိုင်း ယောသပ်န မာရိတွပ် စင်ကြယ်မှု ခမ်းနားလောက်ဟှို့ ခီရော့‑က်လာဟှယ်။ အယ်ကြောန့် သူးနို့ဟှာ သားဂန်းဟှားဟှို ဘုရားသခင်နားမာ ဆစ်ကပ်ဟှို့ ယေရုရှလင်ဗြို့ဟှို ခေါ်ဟှားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ဘုရားသခင်ရဲ့ ပညတ်တရားထဲမာ “သားဦးတိုင်းဟှာ ဘုရားသခင်ဟှို့ သန့်ရှင်းရမယ်” ဆိုဘီး ရေးဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ခိုငှတ်ဟှားနှေ့ကောန် အယ်မျိုးမှုဘဲနေဟှာ ချိုးငှတ်ဟှားနှေ့ကောန်ဟှို ပူဇော်ရမယ် ဆိုဘီး ဘုရားသခင်ရဲ့ ပညတ်တရားတိုင်း ပူဇော်ဟှို့ သူးနို့လည်း သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","အယ်ခီမာ ယေရုရှလင်ဗြို့မာနေဟှူ ရှုမောင်နာမယ်ရှိဟှူ လူတယော့‑က်ရှိဟှယ်။ သူဟှာ ဖြောန့်မတ်ဟှူလူ၊ ဘုရားသခင်ဟှို ကြော့‑က်ဟှူလူန ဣသရေလလူမျိုးဟှို ကူညီဟှို့တွပ် စောန့်နေဟှူ လူဖြစ်ဟှယ်။ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှာ သူ့နတူးဒူရှိဘီး ");
INSERT INTO tvn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","သူဟှာ ဘုရားသခင်ရဲ့ ဂဒိပေးဟှားဟှူ မေရှိယဟှို သူဗြင်လိုက်ရဘဲန သေရလေ့ဟှို့ မှုဟှ ဆိုဘီး သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှာ သူ့ဟှို ဖွမ့်ပြဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ဘုရားသခင်ရဲ့ ဝိညာဉ်တော်အားဖြင့် ရှုမောင်ဟှာ ဗိမာန်တော်ထဲဟှို ဝမ်ဟှားဟှယ်။ မိဖလေဟှာ ပညတ်တရားတိုင်း သူ့တွပ်လောက်ဟှို့ သားဂန်းဟှား ယေရှုဟှို ဗိမာန်တော်ထဲဟှို ခေါ်ဟှားခီမာ ");
INSERT INTO tvn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ရှုမောင်ဟှာ သားဂန်းဟှားဟှို သူ့ရဲ့ လတ်ထဲမာယူဘီး၊ ဘုရားသခင်ဟှို ချီးမွမ်းဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ဘုရားသခင်၊ ကိုယ်တော်ရဲ့ စကားတော်ဟှာ ပ္လဲ့ဇောင်ဟှားဘီ။ ခု ကိုယ်တော်ဟှာ ကိုယ်တော်ရဲ့ ကျွန်ဟှို ငြီသတ်မှုထဲ သွားခွမ့်ပေးလေဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ကိုယ်တော်ရဲ့ ကယ်တန်ရှင်းဟှို ကျွန်တော်ရဲ့ မျစ်စိန ဗြင်ရပီးဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ကိုယ်တော်ဟှာ အယ်ကယ်တန်ရှင်းဟှို လူမျိုးဂူလောင်းရဲ့ ရှေ့မာ ပြင်ဆင်ဟှားပီးဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ကိုယ်တော်ရဲ့ လိုတော်ဟှာ လူမျိုးခြားလေဟှို လန်းဖွမ့်ပြဘီး ကိုယ်တော်ရဲ့ လူမျိုးဖြစ်ဟှူ ဣသရေလနားဟှို ဖောင်းသရေတော်ဟှို ယူလာဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","သားဂန်းဟှားရဲ့ မိန ဖဟှာ သားဂန်းကြောန်းလေဟှို ရှုမောင် ပြောလိုက်ဟှူ ခီမာ အံ့ဩဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ရှုမောင်ဟှာ သူးနို့ဟှို ကောန်းဂျီးပေးဘီးန သူ့ရဲ့မိ မာရိဟှို “အယ်သားဂန်းဟှားဟှာ ဣသရေလလူမျိုး ဘောင်ဂီးဟှို လဲက္လဟှို့န ထမြော့‑က်ဟှို့တွပ် ဘုရားသခင် ဝီးကော့‑က်ဟှားဇာ ဖြစ်ဟှယ်။ သူဟှာ ဘုရားသခင်နားဟှ နိမိတ်လတ်ခဏာ တခုဖြစ်ဘီး လူဘောင်ဂီးဟှာ ဆန့်ကျင်ပြောလေ့မယ် ");
INSERT INTO tvn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","အယ်ကြောန့် သူးနို့ရဲ့ လျှို့ဝှပ်ဟှားဟှူ ကြံစည်လေဟှို ဖွမ့်ပြလေ့မယ်။ ဝန်းနဲမှုဟှာ ထတ်ဟှူ သန်လျက်မျိုးဘဲ့ နန့်ရဲ့ စိနှလောင်းဟှို ထိုးဖော့‑က်လေ့မယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","အယ်နေရာမာ အာရှာမျိုးဖြစ်ဟှူ ဖနွေလရဲ့မီး၊ အန္နနာမယ်ရှိဘီး သတ်ကီးဟှူ ပရောဖက်မ တယော့‑က် ရှိဟှယ်။ သူဟှာ ပျိုရွယ်ဟှူ ခီဟှစဘီး လန်နတူးဒူ ခွန်နစ်နှစ်ဘဲ့ ပေါန်းသန်းရဘီး ");
INSERT INTO tvn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ခု သတ် ၈၄ နှစ်ရွယ် မောက်ဆိုးမ ဖြစ်ဟှားဘီ။ သူဟှာ ဗိမာန်တော်ဟှနေ လောင်းဝ ခွာဘဲန သူဟှာ ဆုတောန်းရှင်းန စာရှောန်ရှင်းအားဖြင့် နေ့ညဉ့်မပြတ် ဘုရားသခင်ဟှို ကိုးကွယ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","အယ်ခီနာရီမာဘဲ့ သူဟှာ ရော့‑က်လာဘီးန ဘုရားသခင်ဟှို ချီးမွမ်းဘီးဟှာ ယေရုရှလင်ဗြို့ လွတ်မြော့‑က်ဟှို့တွပ် ဘုရားသခင်ဟှို စောန့်နေဟှူ လူလေဂူလောင်းဟှို သားဂန်းဟှားကြောန်း ပြောလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ယောသပ်န မာရိဟှာ ဘုရားသခင်ရဲ့ ပညတ်တရားတိုင်း ဂူလောင်း လောက်ပီးဟှားဟှူ ခီမာ သူးနို့ဟှာ သူးနို့ရဲ့ မွီးရပ်မ္လေဖြစ်ဟှူ ဂါလိလဲပြည် နာဇရက်ဗြို့ဟှို ပ္လန်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","အယ်သားဂန်းဟှားဟှာ ကီးဒတ်လာဘီး သန်မာလာဟှယ်။ သူဟှာ ဉာဏ်ပညာပ္လဲ့လာဘီးန ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟှာ သူ့ထတ်မာ ရှိနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ယေရှုရဲ့ မိဖလေဟှာ နှစ်စဉ်နှစ်တိုင်း ပသခါပွဲတော်တွပ် ယေရုရှလင်ဗြို့ဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ယေရှုဟှာ သတ်ဆယ့်နှေ့နှစ် ရော့‑က်လာဟှူ ခီမာ သူးနို့ဟှာ ရင်းရင်ဒူးဟှ သွားနေမျိုးဘဲ့ ပွဲတော်ဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ပွဲတော်ပီးဟှားဟှူ ခီမာ သူးနို့ဟှာ အီဟှို ပ္လန်ဂေ့ဟှယ်။ အယ်ဘေမဲ့ ကောန်သားယေရှုဟှာ ယေရုရှလင်ဗြို့မာ နေရစ်ဟှယ်။ အယ်မျိုး နေရစ်ဇာဟှို သူ့မိဖလေ သိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","သူဟှာ အောက်စုနတူးဒူ ရှိဟှယ် ဆိုဘီး သူးနို့ထန်ကြောန့် သူးနို့ဟှာ တနေ့လောင်း ခရီးသွားဘီးန သူးနို့ရဲ့ ဆွေမျိုးလေန ငယ်ဂျင်းလေကြားထဲမာ သူ့ဟှို လိုက်ရှာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","သူးနို့ဟှာ သူ့ဟှို ရှာတွိဂေ့ဟှ။ အယ်ကြောန့် သူးနို့ဟှာ သူ့ဟှို ရှာဟှို့တွပ် ယေရုရှလင်ဗြို့ဟှို ပ္လန်သွားလိုက်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","တတိယနေ့မာ သူးနို့ဟှာ သူ့ဟှို ဗိမာန်တော်ထဲမာ တွိဟှားဘီး၊ ယုဒဆရာလေနတူးဒူ ထိုင်ဘီး၊ သူးနို့ပြောဇာဟှို နားထောန်ဘီး မေးခွန်းလေ မေးနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","သူ့စကားဟှို ကြားဟှူ လူလေဂူလောင်းဟှာ သူ့ရဲ့ထတ်မြတ်ဟှူ ဖြေဟှို အံ့ဩဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","သူ့ရဲ့ မိဖလေဟှာ သူ့ဟှို တွိလိုက်ဟှူ ခီမာ အံ့ဩဟှားဘီး သူ့မိဟှာ “ဖစု၊ နန်ဟှ ဖြားဖြစ်ကြောန့် နို့လေဟှို အယ်မျိုးလောက်ရနူး။ နန့်ဖန ငါဟှာ ရရာတိုင်း စိပူဘီး နန့်ဟှို လိုက်ရှာနေဟှယ်” ဆိုဘီး သူ့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ကောန်သားဟှားဟှ “ဖြားဖြစ်ကြောန့် နို့မိဟှ နို့ဟှို လိုက်ရှာနေရနူး။ နို့ဟှ နို့ဖရဲ့ အီမာရှိနေဇာဟှို နို့မိ သိဟှလော။” ဆိုဘီး သူးနို့ဟှို ပ္လန်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","အယ်ဘေမဲ့ သူးနို့ဟှာ ကောန်သားဟှားရဲ့ စကားဟှို နားလည်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","အယ်ကြောန့် ယေရှုဟှာ သူးနို့နတူးဒူ နာဇရက်ဗြို့ဟှို ပ္လန်လိုက်ဟှားဘီး အယ်နေရာမာ သူဟှာ သူးနို့စကားဟှို နားထောန်ဘီးနေဟှယ်။ ကောန်သားဟှားရဲ့ မိခင်ဟှာ အယ်ဖြစ်ပျစ်ဇာလေ ဂူလောင်းဟှို စိနှလောင်းထဲမာ သီးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ယေရှုဟှာ ကာယညာဏ ကီးဒတ်လာဘီး ဘုရားသခင်ရှေ့န လူလေရှေ့မာ မျစ်နှာသာရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ကဲသာမန်းဂီး တိဗေရိ အောက်စိုးဇာဟှာ ဆယ့်ငါးနှစ်မြော့‑က်ဟှူ ခီမာ ယုဒပြည်ဟှို အောက်ချောက်ဟှူ လူဟှာ ပုန္တိပိလတ်၊ ဂါလိလဲပြည်ဟှို အောက်ချောက်ဟှူ လူဟှာ ဟေရုဒ်၊ ဣတုရဲပြည်န တရာခေါနိပြည်လေဟှို အောက်ချောက်ဟှူ လူဟှာ ဟေရုဒ်ရဲ့နောန် ဖိလိပ္ပု၊ အဘိလင်ပြည်ဟှို အောက်ချောက်ဟှူ လူဟှာ လုသာနိန၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","အန္န၊ ကယာဖ လေဟှာ ယဇ်ပုရောဟိတ်ဂီးလေ ဖြစ်ဟှယ်။ အယ်ခီမာ တောကန္တာရထဲမာရှိဟှူ ဇာခရိရဲ့သား ယောဟန်နားဟှို ဘုရားသခင်ရဲ့ စကားတော် ရော့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","အယ်ကြောန့် ယောဟန်ဟှာ ယော်ဒန်မ္လစ်ရဲ့ ပတ်ဝန်းကျင် တခုလောင်းသွားဘီး “နောန်ဒရဘီး ဗတ္တိဇံခံဂေ့။ ဘုရားသခင်ဟှာ နန်းနို့ရဲ့ ပြစ်လေဟှို ခွမ့်လွှတ်လေ့မယ်” ဆိုဘီး ကြေညာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ပရောဖက်ဟေရှာယရဲ့ ကျမ်းထဲမာ၊ “လူတယော့‑က်ဟှာ တောကန္တရထဲမာ အော်ဘီးပြောနေဇာဟှ ‘ဘုရားသခင်ရဲ့ လမ်းဟှို ပြင်ဆင်ဟှားဂေ့! ကိုယ်တော်ကြွဟှို့တွပ် လမ်းဟှို ဖ္လောန့်အောန်လောက်ဂေ့! ");
INSERT INTO tvn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ချိုင့်ဝှမ်းလေ ဂူလောင်းဟှို ဖ္လဲ့ဘီး၊ တောန်ဂီးတောန်ငယ် ဂူလောင်းဟှို ဖြိုခ္လရမယ်။ လမ်းကော့‑က်လေဟှို ဖ္လောန့်အောန်လောက်ဘီးန၊ လမ်းကြမ်းလေဟှို ချောအောန်လောက်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","လူ့သားမျိုးနွယ်စု တခုလောင်းဟှာ ဘုရားသခင်ရဲ့ ကယ်တန်တော်မူရှင်းဟှို ဗြင်ရလေ့မယ်!’ ” ဆိုဘီး ရေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ယောဟန်ဟှာ သူ့နားဟှို ဗတ္တိဇံခံဟှို့ ရော့‑က်လာဟှူ လူအောက်ဂီးဟှို “ဝှေ့ မွီဗွေးမျိုးလေ! က္လရော့‑က်လာမယ့် ဘေးဒန်ဟှ လွတ်ဟှို့တွပ် နန်းနို့လေဟှို ဖယ်သူဟှ ဒိပေးလိုက်နူး။ ");
INSERT INTO tvn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","နောန်ဒန ထိုက်တန်ဟှူ ကျင့်ဟှို ကျင့်ဂေ့။ အာဗြဟံဟှ နို့လေရဲ့ ဖဖြစ်ဟှယ် ဆိုဘီး ပြောရောင်န နန်းနို့လေ ပြစ်ဒန်ဟှ လွှတ်လေ့မယ် ဆိုဘီး ထန်ဂေ့န။ နန်းနို့ဟှို ငါပြောမယ် ဘုရားသခင်ဟှာ အယ်က္လော့‑က်ခဲလေဟှနေဘီး အာဗြဟံရဲ့ မ္လေးမ္လစ်လေဟှို ဖန်ဆင်းနိုင်ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","သစ်ပန်လေရဲ့ ပြစ်လေနားမာ ကတ်ပထားဟှားကြောန့် သီးကောန်းဟှို သီးဘဲဟှူ သစ်ပန်တိုင်းဟှို ခွတ်ပစ်ဘီးဟှာ မီးထဲဟှို ပစ်ခ္လလေ့မယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","လူလေဟှာ “အယ်ဆိုဟှာ နို့လေဟှ ဖြားဇာလေ လောက်ရနူး။” ဆိုဘီး သူ့ဟှို မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","သူဟှ “ဖယ်လူဘဲ့ဖြစ်ဖြစ် အန်းဂီနှေ့ထည်ရှိဟှယ် ဆိုဟှာ အန်းဂီမှေ့ဘဲဟှူ လူဟှို တထည်ပေးရမယ်။ ဖယ်လူဘဲ့ဖြစ်ဖြစ် စားဇာရှိဟှယ် ဆိုဟှာ အယ်စားဇာဟှို ဝီပေးရမယ်” ဆိုဘီး ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ခွန်ကော့‑က်မားလေ တချို့ဟှာ ဗတ္တိဇံခံဟှို့ လာဘီးန သူးနို့ဟှာ “ဆရာ၊ ကျွန်တော့်ဟှားလေဟှ ဖြားဇာလောက်ရမယ်နူး။” ဆိုဘီး သူ့ဟှို မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","သူဟှ “ဥပဒေဟှ သတ်မှတ်ဟှားဇာထတ် ပိုဘီး ခွန်ဟှို ကော့‑က်ဂေ့န” ဆိုဘီး သူးနို့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","စစ်သားတချို့ဟှလည်း “ကျွန်တော့်ဟှားလေတွပ် ဟှမား။ ကျွန်တော်ဟှားလေဟှ ဖြားဇာလောက်ရနူး။” ဆိုဘီး သူ့ဟှို မေးဂေ့ဟှယ်။ “ဖယ်လူဟှိုလည်း မှုဘဲန စွပ်စွဲဂေ့န၊ ဖယ်လူနားဟှဘဲ့ဖြစ်ဖြစ် နိုင်ကျင့်ဘီး ကပ်ဟှို ယူဂေ့န။ နန်းနို့ရဲ့ လစာနဘဲ့ ရောန့်ရဲဂေ့” ဆိုဘီး သူးနို့ဟှို ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","လူလေရဲ့ မျှော်လင့်ချစ်လေ ဗြင့်လာဘီး ယောဟန်ဟှာ မေရှိယ ဖြစ်နိုင်ဟှယ် ဆိုဘီး သူးနို့ နှလောင်းထဲမာ အံ့ဩလာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","အယ်ကြောန့် ယောဟန်ဟှာ “ငါဟှာ နန်းနို့ဟှို ရေန ဗတ္တိဇံပေးဟှယ်။ အယ်ဘေမဲ့ ငါ့ထတ် ရရာတိုင်း ကီးမြတ်ဟှူလူဟှာ လာနေဘီ။ ငါဟှာ အယ်လူရဲ့ ခေနပ်ကြိုးဟှို ဖြေဟှို့ဟှိုမှ ထိုက်ဟှ။ အယ်သူဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န၊ မီးန နန်းနို့ဟှို ဗတ္တိဇံပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","လတ်ထဲမာ ဂေါဟှို ကိုင်ဟှားဘီး သူ့ဗားလန်းပ္လန်ဟှို ရှင်းလန်းစေဘီး ဗားလေဟှို ဗားဂတ်ထဲဟှို ထဲ့ဘီးဟှာ ဗားဖျင်းလေဟှို သေနိုင်ဘဲဟှူမီးန ရှို့လေ့မယ်” ဆိုဘီး သူးနို့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ယောဟန်ဟှာ နည်းလမ်းဘောန်းဇောင်န လူလေဟှို ဒန်းကောန်းဟောဘီး သူးနို့ရဲ့ နည်းလမ်းလေ ပ္လောန်းဟှားဟှို့ သူးနို့ဟှို တိုက်တွန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ဟေရုဒ်ဟှာ သူ့နောန်ရဲ့ မီးမ ဟေရောဒိန ပတ်သတ်ဇာဟှိုရော၊ သူကိုယ်တိုင် ကျူးလွန်ဟှားဟှူ ကောန်းဘဲဟှူမှုလေ ဇာဟှိုရော ယောဟန်ဟှ သူ့ဟှို ဆောင်းမဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","အယ်မျိုး ဆောင်းမလိုက်ကြောန့် ဟေရုဒ်ဟှာ ယောဟန်ဟှို ထောန်ထဲမာ လှောန်ဟှားလိုက်ဟှယ်။ အယ်မျိုး လောက်ရှင်းအားဖြင့် ပိုဘီး ဆိုးဝါးဟှူ ပြစ်ဟှို ထပ်လောက်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","လူလေ ဂူလောင်းဟှာ ဗတ္တိဇံခံဂေ့ဘီးန ယေရှုလည်း ဗတ္တိဇံခံတော်မူဟှယ်။ ကိုယ်တော်ဟှာ ဆုတောန်းနေဟှူ ခီမာ ကောန်းဂန်ဘောင် ပွမ့်ဟှားဘီး ");
INSERT INTO tvn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှာ ချိုးငှတ်မျိုး ခန္ဓာန ကိုယ်တော်ထတ်ဟှို ဆင်းလာဟှယ်။ အယ်ဘီးန ကောန်းဂန်ဘောင်ဟှနေ “အယ်သူဟှာ ငါနှစ်သက်မြတ်နိုးဟှူ ငါ့ရဲ့ ရှစ်ဟှူသား ဖြစ်ဟှယ်” ဆိုဘီး သံတော်ထွပ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ယေရှုဟှာ မှုတော်မြတ်ဟှို စဘီး လောက်ဟှူ ခီမာ ကိုယ်တော်ဟှာ သတ်တော်သောင်းဆယ်လော့‑က်ဘဲ့ ရှိဟှယ်။ အယ်ကြောန့် လူလေထန်ဇာဟှ ကိုယ်တော်ဟှာ ယောသပ်ရဲ့သား၊ ယောသပ်ဟှာ ဧလိရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ဧလိဟှာ မဿတ်ရဲ့သား၊ မဿတ်ဟှာ လေဝိရဲ့သား၊ လေဝိဟှာ မေလခိရဲ့သား၊ မေလခိဟှာ ယန္နရဲ့သား၊ ယန္နဟှာ ယောသပ်ရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ယောသပ်ဟှာ မတ္တသိရဲ့သား၊ မတ္တသိဟှာ အာမုတ်ရဲ့သား၊ အာမုတ်ဟှာ နာဟုံရဲ့သား၊ နာဟုံဟှာ ဧသလိရဲ့သား၊ ဧသလိဟှာ နဂ္ဂဲရဲ့သား၊ နဂ္ဂဲဟှာ မာအတ်ရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","မာအတ်ဟှာ မတ္တသိရဲ့သား၊ မတ္တသိဟှာ ရှေမိရဲ့သား၊ ရှေမိဟှာ ယောသပ်ရဲ့သား၊ ယောသပ်ဟှာ ယုဒရဲ့သား၊ ယုဒဟှာ ယောဟန္နရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ယောဟန္နဟှာ ရေသရဲ့သား၊ ရေသဟှာ ဇေရုဗဗေလရဲ့သား၊ ဇေရုဗဗေလဟှာ ရှာလသေလရဲ့သား၊ ရှာလသေလဟှာ နေရိရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","နေရိဟှာ မေလခိရဲ့သား၊ မေလခိဟှာ အဒ္ဒိရဲ့သား၊ အဒ္ဒိဟှာ ကောသံရဲ့သား၊ ကောသံဟှာ ဧလမောဒံရဲ့သား၊ ဧလမောဒံဟှာ ဧရရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ဧရဟှာ ယောရှုရဲ့သား၊ ယောရှုဟှာ ဧလျေဇာရဲ့သား၊ ဧလျေဇာဟှာ ယောရိမ်ရဲ့သား၊ ယောရိမ်ဟှာ မဿတ်ရဲ့သား၊ မဿတ်ဟှာ လေဝိရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","လေဝိဟှာ ရှိမောင်ရဲ့သား၊ ရှိမောင်ဟှာ ယုဒရဲ့သား၊ ယုဒဟှာ ယောသပ်ရဲ့သား၊ ယောသပ်ဟှာ ယောနန်ရဲ့သား၊ ယောနန်ဟှာ ဧလျာကိမ်ရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ဧလျာကိမ်ဟှာ မေလေရဲ့သား၊ မေလေဟှာ မဲနန်ရဲ့သား၊ မဲနန်ဟှာ မတ္တသရဲ့သား၊ မတ္တသဟှာ နာသန်ရဲ့သား၊ နာသန်ဟှာ ဒါဝိဒ်ရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ဒါဝိဒ်ဟှာ ယေရှဲရဲ့သား၊ ယေရှဲဟှာ ဩဗက်ရဲ့သား၊ ဩဗက်ဟှာ ဗောဇရဲ့သား၊ ဗောဇဟှာ စာလမုန်ရဲ့သား၊ စာလမုန်ဟှာ နာရှုန်ရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","နာရှုန်ဟှာ အမိနဒပ်ရဲ့သား၊ အမိနဒပ်ဟှာ အဒ်မိန်ရဲ့သား၊ အဒ်မိန်ဟှာ အာရံနိရဲ့သား၊ အာရံနိဟှာ ဟေဇရုံရဲ့သား၊ ဟေဇရုံဟှာ ဖာရက်ရဲ့သား၊ ဖာရက်ဟှာ ယုဒရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ယုဒဟှာ ယာကုပ်ရဲ့သား၊ ယာကုပ်ဟှာ ဣဇာက်ရဲ့သား၊ ဣဇာက်ဟှာ အာဗြဟံရဲ့သား၊ အာဗြဟံဟှာ တေရရဲ့သား၊ တေရဟှာ နာခေါ်ရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","နာခေါ်ဟှာ စေရောက်ရဲ့သား၊ စေရောက်ဟှာ ရာဂေါရဲ့သား၊ ရာဂေါဟှာ ဖာလက်ရဲ့သား၊ ဖာလက်ဟှာ ဟေဗာရဲ့သား၊ ဟေဗာဟှာ ရှာလရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ရှာလဟှာ ကာဣနန်ရဲ့သား၊ ကာဣနန်ဟှာ အာဖာဇဒ်ရဲ့သား၊ အာဖာဇဒ်ဟှာ ရှေမရဲ့သား၊ ရှေမဟှာ နောဧရဲ့သား၊ နောဧဟှာ လာမက်ရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","လာမက်ဟှာ မသုရှလရဲ့သား၊ မသုရှလဟှာ ဧနောက်ရဲ့သား၊ ဧနောက်ဟှာ ယာရက်ရဲ့သား၊ ယာရက်ဟှာ မဟာလေလရဲ့သား၊ မဟာလေလဟှာ ကာဣနန်ရဲ့သား၊ ");
INSERT INTO tvn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ကာဣနန်ဟှာ ဧနုတ်ရဲ့သား၊ ဧနုတ်ဟှာ ရှေသရဲ့သား၊ ရှေသဟှာ အာဒံရဲ့သား၊ အာဒံဟှာ ဘုရားသခင်ရဲ့ သားဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ယေရှုဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န ပ္လဲ့ဝဘီး ယော်ဒန်မ္လစ်နားဟှနေ ပ္လန်လာဘီးန ကိုယ်တော်ဟှာ ဝိညာဉ်တော်အားဖြင့် တောကန္တရထဲဟှို ပို့ဆောန်ရှင်းဟှို ခံတော်မူဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","အယ်နေရာမာ ကိုယ်တော်ဟှာ ရစ်လေးဆယ် လောင်းလောင်း နေဘီး မာရ်နတ်ရဲ့ သွီးဆောန်ရှင်းဟှို ခံရဟှယ်။ အယ်နေ့ရစ်လေမာ ကိုယ်တော်ဟှာ ဖြားလည်းစားဘဲကြောန့် အယ်နေ့ရစ်လေ ပီးဆောင်းဟှားဟှူ ခီမာ ကိုယ်တော်ဟှာ ရရာတိုင်း ဗိုက်ဆာတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","မာရ်နတ်ဟှ “သင်ဟှာ ဘုရားသခင်ရဲ့ သားဖြစ်ဟှယ် ဆိုဟှာ အယ်က္လော့‑က်ခဲဟှို မုဖြစ်လာအောန် မိန့်ပေးကေ့” ဆိုဘီး ကိုယ်တော့်ဟှို ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","အယ်ဘေမဲ့ ယေရှုဟှ “‘လူဟှာ စားဇာတခုဒဲန သတ်ရှင်ရဟှို့ မှုဟှ’ ဆိုဇာ ကျမ်းစာဟှ ပြောဟှားဟှယ်” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","အယ်ဘီးန မာရ်နတ်ဟှာ ကိုယ်တော့်ဟှို ရရာတိုင်း ဗြစ်ဟှူ တောန်ထတ်ဟှို ခေါ်ဆောန်ဟှားဘီး အယ်လောကရဲ့ နိုင်ငံလေဟှို တခဏရှင်းမာ ကိုယ်တော့်ဟှို ပြလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","မာရ်နတ်ဟှ “ငါဟှာ ကိုယ်တော့်ဟှို အယ်ခွမ့်အာဏာ ဂူလောင်းန အယ်ဖောင်းစည်းဇိမ် ဂူလောင်းပေးမယ်။ အယ်ဇာလေ ဂူလောင်းဟှာ ငါ့ဟှို အပ်ဟှားပီးဘီ။ ငါဟှာ အယ်ဇာလေဟှို ငါဝီးကော့‑က်ဟှားဟှူ ဖယ်လူဘဲ့ဖြစ်ဖြစ် ငါပေးနိုင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ကိုယ်တော်ဟှာ ငါ့ဟှို ကိုးကွယ်မယ် ဆိုဟှာ အယ်မူဇာလေ ဂူလောင်းဟှာ ကိုယ်တော်ရဲ့ အောက်စာလေ ဖြစ်ဟှားလေ့မယ်” ဆိုဘီး ကိုယ်တော့်ဟှို ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ယေရှုဟှ “ကျမ်းစာမာ ‘နန့်ရဲ့ ဘုရားသခင် တပါးဒဲဟှိုဘဲ့ ကိုးကွယ်ရမယ်။ အယ်သခင် တပါးဒဲဟှိုဘဲ့ စေခံရမယ်!’ ဆိုဇာ ပြောဟှားဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","အယ်ဘီးန မာရ်နတ်ဟှာ ကိုယ်တော့်ဟှို ယေရုရှလင်ဗြို့ဟှို ခေါ်ဟှားဘီး ဗိမာန်တော်ရဲ့ ထိဖျားမာ တန်ဟှားဘီးဟှာ “ကိုယ်တော်ဟှာ ဘုရားသခင်ရဲ့ သားဖြစ်ဟှယ် ဆိုဟှာ အယ်နေရာဟှနေ အော့‑က်ဟှို ခူခ္လလိုက်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ‘ဘုရားသခင်ဟှာ ကိုယ်တော့်ဟှို စောန့်ရှော့‑က်ဟှို့တွပ် ကောန်းဂန်တမန်လေဟှို မိန့်ပေးဟှားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ကိုယ်တော်ရဲ့ ခေဟှို က္လော့‑က်န ထိခိုက်ဘဲနေအောန် သူးနို့ဟှာ ကိုယ်တော့်ဟှို လတ်န ခီမဟှားလေ့မယ်’ ဆိုဇာ ကျမ်းစာမာ ပြောဟှားဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","အယ်ဘေမဲ့ ယေရှုဟှ “‘နန့်ရဲ့သခင်၊ ဘုရားသခင်ဟှို စောင်ဇမ်းန’ ဆိုဇာ ကျမ်းစာဟှ ပြောဟှားဟှယ်” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","မာရ်နတ်ဟှာ သွီးဆောန်ရှင်း ဘောန်းဇောင် လောက်ဘီးန ယေရှုနားဟှ ထွပ်ဟှားဘီး ခွမ့်ကောန်းဟှို စောန့်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","အယ်ဘီးန ယေရှုဟှာ ဂါလိလဲပြည်ဟှို ပ္လန်ဟှားဘီး ဘုရားသခင်ရဲ့ ဝိညာဉ်တော်တဂိုးဟှာ ကိုယ်တော်နတူးဒူ ရှိတော်မူဟှယ်။ ကိုယ်တော့်ဒန်းဟှာ အယ်ဒေသ တခုလောင်း ပ္လန့်နှံ့ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ကိုယ်တော်ဟှာ ဝါလယ်ဇရပ်လေမာ သွန်သန်ဘီး ကိုယ်တော့်ဟှို လူတိုင်းချီးမွမ်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","အယ်ဘီးန ယေရှုဟှာ နာဇရက်ဗြို့ဟှို ကြွဟှားတော်မူဟှယ်။ အယ်ဗြို့ဟှာ ကိုယ်တော် ကီးဒတ်လာဟှူ ဗြို့ဖြစ်ဘီး ဒန်းနေ့မာ ကိုယ်တော်ဟှာ ခါတိုင်းသွားနေမျိုးဘဲ့ ဝါလယ်ဇရပ်ဟှို ကြွဟှားတော်မူဟှယ်။ ကိုယ်တော်ဟှာ ကျမ်းစာဖတ်ဟှို့ မတ်တတ်ထလိုက်ဘီးန ");
INSERT INTO tvn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ကိုယ်တော်ဟှာ ပရောဖက် ဟေရှာယရဲ့ ကျမ်းဟှို လှမ်းယူလိုက်ဘီး ကျမ်းစာဟှို ဖွမ့်လိုက်န အယ်ကျမ်းမာ ");
INSERT INTO tvn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“သခင်ဘုရားရဲ့ ဝိညာဉ်တော်ဟှာ ငါ့ထတ်မာ ရှိတော်မူဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကိုယ်တော်ဟှာ ဆင်းရဲသားလေနားဟှို ဒန်းကောန်းသယ်ဆောန်ဟှို့ ငါ့ဟှို ဝီးကော့‑က်တော်မူဟှယ်။ ကိုယ်တော်ဟှာ ခယ်ဟှားဇာခံရဟှူ လူလေနားဟှို လွှတ်မြော့‑က်စေဟှို့န မျစ်စိကန်းဟှူ လူလေဟှို လန်းပ္လန်ရစေဟှို့၊ ညှဉ်းဆဲခံရဟှူ လူလေ လွှတ်မြော့‑က်စေဟှို့ကြောန်း ကြေညာဘီးန ");
INSERT INTO tvn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","သခင်ဘုရားဟှာ ကိုယ်တော်ရဲ့ လူလေဟှို ကယ်တန်ဟှို့ ခီဟှာ ရော့‑က်လာဘီ ဖြစ်ကြောန်းဟှို ကြေညာဟှို့ ငါ့ဟှို စေလွတ်ဟှယ်” ဆိုဘီး ရေးဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ယေရှုဟှာ ကျမ်းစာဟှို လိဘီး ဇရပ်စောန့်ဟှို ပ္လန်ပေးဘီးန ထိုင်လိုက်ဟှယ်။ ဝါလယ်ဇရပ်ထဲဟှ လူလေ ဂူလောင်းရဲ့ မျစ်လောင်းလေဟှာ ကိုယ်တော့်ဟှိုဘဲ့ စေ့စေ့ကေ့နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","အယ်ကြောန့် ယေရှုဟှာ သူးနို့ဟှို့ “နန်းနို့ ကြားဟှားမျိုးဘဲ့ အယ်ကျမ်းပိုဒ်ဟှာ အယ်နေ့ဘဲ့ မှန်ဖြစ်လာဘီ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","လူလေ ဂူလောင်းဟှာ ကိုယ်တော့်ဟှို ရရာတိုင်း ထော့‑က်ခံဂေ့ဘီး ကိုယ်တော်ရဲ့ ဆွဲဆောန်အားကောန်းဟှူ စကားလေကြောန့် အံဩဂေ့ဟှယ်။ သူးနို့ဟှ “သူဟှာ ယောသပ်ရဲ့ သား မှုဟှလော” ဆိုဘီး ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ကိုယ်တော်ဟှာ “နန်းနို့ဟှာ ငါ့ဟှို အယ်မျိုးဆိုရိုးစကားန ကိုးကားလေ့မယ် ‘ဆရာဝန်၊ ကိုယ့်ကိုယ်ကိုယ် နာပျော့‑က်အောန်ကု’ ဆိုဘီး ပြောမယ် ဆိုဇာဟှို ငါတိက္လ သိဟှယ်။ ကပေရနောင်ဗြို့မာ လောက်ဟှားဇာဟှို နန်းနို့ ကြားဟှားပီးဘီ အယ်မျိုးဇာလေဟှို ငါ့ရဲ့ မွီးရပ်ဗြို့မာလည်း နန်းနို့ဟှာ ငါ့ဟှို လောက်ပြဟှို့ ပြောလေ့အူးမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ပရောဖက်လေဟှာ သူးနို့ရဲ့ ဗြို့မာ ကြိုဆိုရှင်းဟှို လောင်းဝ ခံရဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ငါ မှန်တိုင်းပြောမယ်၊ နားထောန်ဂေ့။ ဧလိယ လတ်ထတ်ဟှ ဣသရေလနိုင်ငံမာ သောင်းနှစ်ခွဲ ကောန်းဂန်ပိဟှားဘီး တနိုင်ငံလောင်း စာရေဇာ ခေါန်းပါးနေခီမာ ဣသရေလနိုင်ငံမာ မောက်ဆိုးမလေ ဘောင်ဂီးရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ဧလိယဟှာ ဣသရေလနိုင်ငံထဲဟှ ဖယ်မောက်ဆိုးမ တယော့‑က်နားဟှိုလည်း စေလွတ်ရှင်းခံရဘဲ ဇိဒုန်ပြည် ဇရတ္တဗြို့မာနေဟှူ မောက်ဆိုးမ တယော့‑က်နားဟှိုဘဲ့ စေလွတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ပရောဖက် ဧလိရှဲ လတ်ထတ်ဟှ ဣသရေလနိုင်ငံမာနေဟှူ နူနာရောဂါသယ်လေ ဘောင်ဂီးရှိဘေမဲ့ သူးနို့လေထဲဟှ တယော့‑က်လည်း သန့်ရှင်းခွမ့် ရဂေ့ဟှ။ အယ်ဘေမဲ့ ရှုရိလူမျိုး နေမန်တယော့‑က်ဘဲ့ သန့်ရှင်းခွမ့် ရဟှားဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ဝါလယ်ဇရပ်မာရှိဟှူ လူလေဟှာ အယ်စကားဟှို ကြားရဟှူ ခီမာ သူးနို့ဟှာ ဒေါသထွပ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","သူးနို့ဟှာ မတ်တတ်ထလိုက်ဘီး ယေရှုဟှို ဗြို့ပ္လန်ထိ ဒရွတ်တိုက်ဆွဲဟှားဘီးန သူးနို့ ဗြို့တည်ဟှားဟှူ တောန်ထိဟှို ခေါ်ဆောန်ဟှားဟှယ်။ သူးနို့ဟှာ ကိုယ်တော့်ဟှို က္လော့‑က်ဆောန်ထတ်ဟှနေ တွန်းခ္လဟှို့ ခေါ်ဆောန်ဟှားဘေမဲ့၊ ");
INSERT INTO tvn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ကိုယ်တော်ဟှာ လူအောင်ဂီးလယ်ဟှနေ ရှော့‑က်ဟှားဘီး ကြွဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","အယ်ဘီးန ယေရှုဟှာ ဂါလိလဲပြည်ဟှ ဗြို့တဗြို့ဖြစ်ဟှူ ကပေရနောင်ဗြို့ဟှို ဆင်းဟှားဘီး ဒန်းနေ့မာ ကိုယ်တော်ဟှာ လူလေဟှို သွန်သန်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","သူးနို့ ဂူလောင်းဟှာ ကိုယ်တော်ရဲ့ သွန်သန်ဟှူ နည်းလမ်းဟှို အံ့ဩဟှားဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကိုယ်တော်ဟှာ ခွမ့်အာဏာန ပြောတော်မူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ဝါလယ်ဇရပ်မာ ညစ်ညူးဟှူနတ် ဝမ်ပူးနေဟှူလူ တယော့‑က်ရှိဘီး သူဟှာ သံက္လယ်ဟှီးန ");
INSERT INTO tvn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“မိ–ဝေး! နာဇရက်ဗြို့သားယေရှု၊ ကိုယ်တော်ဟှာ ကျွန်တော့်လေန ဖယ်မျိုးဆိုင်နူး။ ကိုယ်တော်ဟှာ ကျွန်တော့်လေဟှို ဖျစ်ဆီးဟှို့တွပ် အယ်နေရာဟှို ရော့‑က်လာဇာလော။ ကိုယ်တော်ဟှာ ဖယ်သူဖြစ်ဟှယ် ဆိုဇာဟှို ကျွန်တော်သိဟှယ်။ ကိုယ်တော်ဟှာ ဘုရားသခင်ရဲ့ သန့်ရှင်းဟှူ စေတမန်ဖြစ်ဟှယ်!” ဆိုဘီး အော်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ယေရှုဟှာ အယ်နတ်ဟှို “တိတိနေဘီး အယ်လူထဲဟှထွပ်!” ဆိုဘီး မိန့်ပေးလေဟှယ်။ နတ်ဆိုးဟှာ အယ်လူဟှို သူးနို့ရှေ့မာ ပစ်လှဲခ္လဘီးန သူ့ဟှို ထိခိုက်ရှင်း မှေ့ဘဲန သူ့ထဲဟှ ထွပ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","လူလေ ဂူလောင်းဟှ အံ့ဩဟှားဂေ့ဘီး ယော့‑က်နယော့‑က် “အယ်စကားလေဟှ ဖြားမျိုးစကားလေနူး။ အယ်လူဟှာ ညစ်ညူးဟှူ နတ်လေဟှို ခွမ့်အာဏာတဂိုးန မိန့်ပေးလိုက်ဟှူန သူးနို့ဟှာ ထွပ်ဟှားဟှယ်!” ဆိုဘီး ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ယေရှုရဲ့ ဒန်းဟှာ အယ်ဒေသ တခုလောင်းဟှို ပ္လန့်နှံ့ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ယေရှုဟှာ ဝါလယ်ဇရပ်ဟှနေ ထွပ်ဟှားဘီးန ရှိမုန်ရဲ့ အီဟှို ကြွဟှားလိုက်ဟှယ်။ ရှိမုန်ရဲ့ ယောက္ခမဟှာ ဖျားနာဘီး ရရာတိုင်း နေကောန်းဘဲ ဖြစ်နေကြောန်း သူးနို့ဟှာ ယေရှုဟှို တောန်းလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ကိုယ်တော်ဟှာ အယ်မီးမရဲ့ ဘေးနားမာ သွားရပ်ဘီး ဖျားပျော့‑က်စေ ဆိုဘီး မိန့်ပေးလိုက်ဟှယ်။ အယ်မီးမဟှာ ဖျားနာပျော့‑က်ဟှားကြောန့် ရှစ်ရှင်းထဘီး ကိုယ်တော်န တဗဲ့တော်လေဟှို ဧည့်ဝတ်ပြုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","နေဝမ်ဟှားဘီးန ရောဂါဘောန်းဇောင်န နေကောန်းဘဲဖြစ်နေဟှူ လူလေရဲ့ ငယ်ဂျင်းလေဟှာ သူးနို့ဟှို ယေရှုနားဟှို ခေါ်လာဂေ့ဟှယ်။ ကိုယ်တော်ဟှာ သူးနို့ ဂူလောင်းထတ်မာ လတ်ဟှို တန်ဘီးန သူးနို့ ဂူလောင်းဟှို နာပျော့‑က်စေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","နတ်ဆိုးလေဟှာလည်း လူလေထဲဟှနေ “ကိုယ်တော်ဟှာ ဘုရားသခင်ရဲ့ သားတော် ဖြစ်ဟှယ်!” ဆိုဘီး အော်ဟစ်ဘီး ထွပ်ဟှားဂေ့ဟှယ်။ ယေရှုဟှာ မေရှိယဖြစ်ဟှယ် ဆိုဇာဟှို နတ်ဆိုးလေဟှ သိဟှယ်။ အယ်ကြောန့် သူးနို့ဟှို စကားခွန်းလည်းပြောန ဆိုဘီး မိန့်ပေးတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","မိုးလန်းဟှူ ခီမာ ယေရှုဟှာ ဗြို့ဟှနေ ထွပ်ဟှားဘီးန တိဆိဟှူ နေရာဟှို ကြွဟှားလေဟှယ်။ လူလေဟှာ ကိုယ်တော့်ဟှို လိုက်ရှာဂေ့ဘီး သူးနို့ဟှာ ကိုယ်တော့်ဟှို တွိဟှူ ခီမာ ကိုယ်တော့်ဟှို ထွပ်ဟှားဘဲနေအောန် ဆီးတားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","အယ်ဘေမဲ့ ကိုယ်တော်ဟှာ “ငါဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ကြောန်း ဒန်းကောန်းဟှို တခြား ဗြို့ဝါလေမာလည်း ကြေညာရအူးမယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်မျိုးကြေညာဟှို့ ဘုရားသခင်ဟှ ငါ့ဟှို စေလွတ်ရှင်း ဖြစ်ဟှယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","အယ်ကြောန့် ကိုယ်တော်ဟှာ ယုဒပြည် တပြည်လောင်းမာရှိဟှူ ဝါလယ်ဇရပ်လေမာ ကြေညာတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","တနေ့မာ ယေရှုဟှာ ဂင်္နေသရက်အိုင်ရဲ့ ကမ်းနားမာ ရပ်နေဟှူ ခီမာ လူလေဟှာ ဘုရားသခင်ရဲ့ စကားတော်ဟှို နားထောန်ဟှို့ ကိုယ်တော်နားဟှို တိုးဝမ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ကိုယ်တော်ဟှာ ကမ်းနားမာ ကပ်ဟှားဟှူ လှေနှေ့စင်းဟှို ဗြင်တော်မူဟှယ်။ ငါးဖမ်းမားလေဟှာ လှေလေထတ်ဟှနေ ဆင်းဘီးန ငါးဖမ်းပိုက်လေဟှို ဆေးနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ယေရှုဟှာ အယ်လှေနှေ့စီးထဲဟှ ရှိမုန်ရဲ့ လှေထတ်ဟှို တတ်တော်မူဘီးန လှေဟှို ကမ်းဟှနေ နဲနဲခွာဟှို့ သူ့ဟှို ခွမ့်တောန်းလေဟှယ်။ ယေရှုဟှာ လှေထတ်မာ ထိုင်ဘီးန လူအောက်ဂီးဟှို သွန်သန်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ကိုယ်တော်ဟှာ သွန်သန်ရှင်းလေ ပီးဟှားဟှူ ခီမာ ရှိမုန်ဟှို “ရေနတ်ထဲဟှို ထွပ်ဟှားဘီး ငါးလေဟှို ဖမ်းဟှို့တွပ် နန့်န နန့်ပေါန်းဖော်လေရဲ့ ငါးဖမ်းပိုက်လေဟှို ခ္လဂေ့” မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ရှိမုန်ဟှ “ကျွန်တော့်ဟှားလေဟှာ တညဉ့်လောင်း ကြိုးစားဘီး ဖမ်းလည်း ဂေါန်လည်းရဂေ့ဟှ။ အယ်ဘေမဲ့ ကိုယ်တော်ရဲ့ မိန့်တော်တိုင်း ငါးဖမ်းပိုက်လေဟှို ခ္လလိုက်မယ်” ဆိုဘီး ပ္လန်ပြောတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","သူးနို့ဟှာ ငါးဖမ်းပိုက်လေဟှို ခ္လလိုက်ဘီးန ငါးလေဘောင်ဂီး ဖမ်းမိကြောန့် ငါးဖမ်းပိုက်လေ စုပ္လဲခါနီး ဖြစ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","အယ်ကြောန့် သူးနို့ဟှာ လာဘီး ကူညီပေးဟှို့ တခြားလှေထဲမာရှိနေဟှူ သူးနို့ရဲ့ ပေါန်းဖော်လေဟှို လတ်ပြဘီး ခေါ်လိုက်ဟှယ်။ သူးနို့ဟှာ လာဘီးန လှေနှေ့စင်းလောင်းဟှို ငါးလေပ္လဲ့ ဖ္လဲ့လိုက်ကြောန့် လှေလေဟှာ မ္လုပ်ခါနီး ဖြစ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","အယ်မျိုးဖြစ်ဇာလေဟှို ရှိမုန်ပေတရု ဗြင်လိုက်ဟှူ ခီမာ ယေရှုရှေ့မာ ဒူးထော့‑က်ဘီး “သခင်၊ ကျွန်တော့်နားဟှနေ ကြွဟှားတော်မူပါ! ကျွန်တော်ဟှာ ပြစ်သား ဖြစ်ဟှယ်!” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","သူ့နတူးဒူရှိဟှူ လူလေ ဂူလောင်းဟှာ ဖမ်းမိဟှူ ငါးလေဟှာ ဘောင်ဂီး ဖြစ်နေကြောန့် အံ့ဩဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ရှိမုန်ရဲ့ လောက်ဖော်ဆောန်ဖတ်လေဖြစ်ဘီး ဇေဗေဒဲရဲ့ သားလေဖြစ်ဟှူ ယာကုပ်န ယောဟန်လေဟှာလည်း အယ်မျိုးဘဲ့ အံ့ဩဟှားဂေ့ဟှယ်။ ယေရှုဟှာ ရှိမုန်ဟှို “ကြော့‑က်ဂေ့န။ ခုဟှစဘီး နန်ဟှာ လူလေဟှို ဖမ်းရလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","သူးနို့ဟှာ လှေလေဟှို ကမ်းနားမာ ကပ်လိုက်ဘီး ငါးလေ ဂူလောင်း ထားရစ်ဘီးန နော့‑က်တော်ဟှို လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","တနေ့မာ ယေရှုဟှာ ဗြို့တဗြို့မာ ရှိနေဒူးမာ နူနာသယ် တယော့‑က်ဟှာ ယေရှုဟှို ဗြင်ဟှားဟှူ ခီမာ ပျပ်ဝပ်ဘီး ကိုယ်တော့်ဟှို “သခင်၊ လိုတော်ရှိဟှယ် ဆိုဟှာ ကျွန်တော့်ဟှို သန့်ရှင်းအောန် လောက်နိုင်ဟှယ်!” ဆိုဘီး တောန်းဗန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ယေရှုဟှာ လတ်တော်ဟှို ဆန့်ဘီးဟှာ သူ့ဟှို တို့ထိတော်မူဟှယ်။ “ငါလိုရှိဟှယ်။ သန့်ရှင်းစေ!” ဆိုဘီး ကိုယ်တော်ဟှ မိန့်တော်မူဟှယ်။ ရှစ်ရှင်းဘဲ့ နူနာရောဂါဟှာ ပျော့‑က်ဟှားလေဟှယ် ");
INSERT INTO tvn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ယေရှုဟှာ သူ့ဟှို “ဖယ်သူဟှိုလည်း ပြောန။ အယ်ဘေမဲ့ ယဇ်ပုရောဟိတ်နားဟှို သွားဘီး ကိုယ်ဟှို ပြလိုက်ပါ။ စင်ကြယ်ဟှားဘီး ဆိုဇာဟှို လူလေရှေ့မာ သတ်သေဖြစ်ဟှို့တွပ် မောရှေပညတ်ဟှားဟှူတိုင်း ပူဇော်သကာဟှို ဆစ်သပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","အယ်ဘေမဲ့ ယေရှုရဲ့ ဒန်းဟှာ ရရာတိုင်း ပ္လံ့နှံ့ဟှားဘီး လူအောက်ဂီးဟှာ ကိုယ်တော်ရဲ့ တရားတော်လေ ကြားရဟှို့န သူးနို့ရဲ့ ရောဂါလေ ပျော့‑က်ဟှို့တွပ် လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","အယ်ဘေမဲ့ ကိုယ်တော်ဟှာ တိဆိဟှူ နေရာမာ ဆုတောန်းဟှို့ ထွပ်ကြွဟှားတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","တနေ့မာ ယေရှုဟှာ သွန်သန်တော်မူနေဒူးမာ ယေရုရှလင်ဗြို့၊ ယုဒပြည်န ဂါလိလဲပြည် ဗြို့ဝါလေဟှနေ လာဟှူဖာရိရှဲ တချို့န ကျမ်းတတ်ဆရာလေဟှာ ထိုင်နေဂေ့ဟှယ်။ ရောဂါ ပျော‑က်စေဟှို့ ဘုရားသခင်ရဲ့ တဂိုးတော်ဟှာ ယေရှုမာ ရှိတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","လူတချို့ဟှာ လေဖြတ်နေဟှူ လူတယော့‑က်ဟှို ထမ်းစင်န သယ်လာဘီး အီထဲဟှို သယ်ဆောင်ဟှားဘီး ယေရှုရဲ့ ရှေ့တော်မာ ခ္လဟှားဟှို့ ကြိုးစားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ကြိုးစားဘေမဲ့လည်း လူလေဘောင်ဂီး ရှိနေကြောန့် သူးနို့ဟှာ လူနာဟှို သယ်သွမ်းဟှားဟှို့ လမ်းရှာတွိဘဲ ဖြစ်နေဟှယ်။ အယ်ကြောန့် သူးနို့ဟှာ အီးခေါန်မိုးထတ်ဟှို တတ်ဘီးဟှာ အီးခေါန်မိုးဟှို ဖော့‑က်ဘီးမှ လူနာဟှို ထမ်းစင်န လူအောက်ဂီးရဲ့လယ် ယေရှုရဲ့ ရှေ့တော်ဟှို လျှောခ္လဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ယေရှုဟှာ သူးနို့မာ ရရာတိုင်း ယောင်ကြည်ရှင်း ရှိဟှယ် ဆိုဇာဟှို ဗြင်တော်မူဟှားဘီး လူနာဟှို “မိဆွေ၊ နန်ဟှာ ပြစ်လေလွတ်ရှင်းခံရဘီ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ကျမ်းတတ်ဆရာလေန ဖာရိရှဲလေဟှာ “ဘုရားဟှို စော်ဂါးဘီး ပြောနေဟှူ လူဟှ ဖယ်သူနူး! ဘုရားသခင် တပါးဒဲဘဲ့ ပြစ်လေဟှို ဖြေလွတ်ပေးနိုင်ဟှယ်!” ဆိုဘီး သူးနို့ရှင်းရှင်း ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ယေရှုဟှာ သူးနို့ရဲ့ စိဟှို သိကြောန့် သူးနို့ဟှို “နန်းနို့ဟှာ ဖြားဖြစ်ကြောန့် အယ်ဇာလေဟှို နန်းနို့ရဲ့ နှလောင်းထဲမာ စဉ်းစားနေဂေ့နူး။ ");
INSERT INTO tvn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘နန်ဟှာ ပြစ်လွတ်ရှင်းခံရဘီ’ ဆိုဘီး ပြောဇာဟှ လွယ်လော။ ‘နန် ထဘီး လမ်းရှော့‑က်’ ဆိုဘီး ပြောဇာဟှ လွယ်လော။ ");
INSERT INTO tvn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","လူ့ရဲ့သားဟှာ လောကမာ ပြစ်လွှတ်ပိုင်ဟှူ ခွမ့်အာဏာ ရှိဟှယ် ဆိုဇာ နန်းနို့ဟှို သတ်သေပြမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်ကြောန့် ကိုယ်တော်ဟှာ လေဖြတ်နေဟှူ လူဟှို “ထဒန်၊ ထမ်းစင်ဟှို သီးဘီးဟှာ အီပ္လန်ဝေါ့!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ရှစ်ရှင်းဘဲ့ အယ်လူဟှာ သူးနို့ ဂူလောင်းရှေ့မာ ထရပ်ဘီး။ သူအိဟှားဟှူ အိယာဟှို သီးဘီး၊ ဘုရားသခင်ဟှို ချီးမွမ်းဘီး အီဟှို ပ္လန်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","သူးနို့ ဂူလောင်းဟှာ ရရာတိုင်း အံ့ဩဟှားဂေ့ဟှယ်! သူးနို့ဟှာ ကြော့‑က်လန့်လာဘီး ဘုရားသခင်ဟှို “အယ်နေ့မာ ရရာတိုင်း အံ့ဩဇာလေဟှို နို့လေဗြင်ရဂေ့ဘီ” ဆိုဘီး ချီးမွမ်းဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","အယ်ဇာလေ ပီးဟှားဘီးန ယေရှုဟှာ ထွပ်ကြွဟှားတော်မူဘီး လေဝိနာမယ်ရှိဟှူ ခွန်ကော့‑က်မားဟှာ သူ့ခွန်ရောင်းမာ ထိုင်နေဇာဟှို ဗြင်တော်မူလေဟှယ်။ ယေရှုဟှာ သူ့ဟှို “ငါ့နော့‑က်ဟှို လိုက်ပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","လေဝိဟှာ ဂူလောင်းဟှို ထားရစ်ဘီး နော့‑က်တော်ဟှို လိုက်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","အယ်ဘီးန လေဝိဟှာ သူ့ရဲ့ အီမာ ယေရှုတွပ် ဧည့်ခံဗွဲဂီး ကျင်းပလေဟှယ်။ အယ်ပွဲဟှို လာဟှူ ဧည့်သည်လေထဲမာ ခွန်ကော့‑က်မားလေန တခြားလူလေ ပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ကျမ်းတတ်ဆရာလေ တချို့န သူးနို့ရဲ့ အောက်စုဝမ်ဖြစ်ဟှူ ဖာရိရှဲလေ တချို့ဟှာ ယေရှုရဲ့ တဗဲ့တော်လေဟှို ပြစ်တန်ဂေ့ဟှယ်။ “ဖြားဖြစ်ကြောန့် နန်းနို့ဟှာ ခွန်ကော့‑က်မားလေ၊ ပြစ်သားလေနတူးဒူ စားသော့‑က်ရဂေ့နူး” ဆိုဘီး သူးနို့ဟှို မေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ယေရှုဟှာ သူးနို့ဟှို “နေကောန်းနေဟှူ လူလေဟှ ဆရာဝန်ဟှို လိုအပ်ဟှ။ အယ်ဘေမဲ့ နေကောန်းဘဲလူဟှ ဆရာဝန်ဟှို လိုအပ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ငါဟှာ ဖြောန့်မတ်ဟှူ လူလေ နောန်ဒရဟှို့တွပ် ခေါ်ဟှို့လာဇာ မှုဟှ။ ပြစ်ရှိဟှူ လူလေဟှို နောန်ဒရစေဟှို့တွပ် ခေါ်ဟှို့လာဇာ ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","လူတချို့ဟှ ယေရှုဟှို “ယောဟန်ရဲ့ တဗဲ့လေန ဖာရိရှဲလေရဲ့ တဗဲ့လေဟှာ စာရှောန်ရှင်းန ဆုတောန်းရှင်းလေဟှို ခါဘီးခါ လောက်ဘေမဲ့ ကိုယ်တော်ရဲ့ တဗဲ့လေဟှာ စားသော့‑က်ဘီး နေဂေ့ဟှယ်” ဆိုဘီး မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ယေရှုဟှ “အီတတ်ဗွဲမာ ဒို့သားနတူးဒူ ရှိနေဟှူ ပေါန်းသင်းလေဟှာ ဒို့သားနတူးဒူ ရှိနေခီမာ စာရှောန်ခိုင်းနိုင်လော။ ");
INSERT INTO tvn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","အယ်ဘေမဲ့ ဒို့သားဟှို သူးနို့နားဟှနေ ဆောန်ယူဟှားဟှို့နေ့ ရော့‑က်လာဟှူ ခီမာ သူးနို့ဟှာ စာရှောန်လေ့မယ်” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ယေရှုဟှာ သူးနို့ဟှို ပေါင်ဥပမာန “ဖယ်သူလည်း အန်းဂီးစသစ်ဟှို ဆုဖ္လဲဘီး အန်းဂီဟောန်းမာ ဖာလေ့မှေ့ဟှ။ အယ်မျိုးဖာမယ် ဆိုဟှာ အန်းဂီသစ်ဟှာ ပျစ်စီးဟှားဘီး အန်းဂီဇသစ်န အန်းဂီဟောန်းဟှာ လိုက်ဖက် မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","အယ်မျိုးဘဲ့ ဝိုင်သစ်ဟှို သားရေဖူးဟောန်းထဲမာ ထဲ့လေ့ မှေ့ဟှ။ ထဲ့မယ် ဆိုဟှာ ဝိုင်သစ်ဟှ သားရေဖူးဟောန်းဟှို ပေါ့‑က်ပ္လဲစေဘီး ဝိုင်န သားရေဖူး နှေ့ခုလောင်းဟှာ ပျစ်စီးဟှားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ဝိုင်သစ်ဟှို သားရေဖူးသစ်မာဘဲ့ ထဲ့ရဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ဝိုင်ဟောန်းဟှို သော့‑က်ဟှားဘီးဟှူ လူဟှာ ဝိုင်သစ်ဟှို သော့‑က်ရှင်ဂေ့ဟန်း! ‘ဝိုင်ဟောန်းဟှ ပိုကောန်းဟှယ်’ ဆိုဘီး နန်နို့ ပြောလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ဒန်းနေ့မာ ယေရှုဟှာ ဂျောင်စဗားလယ်ဂွမ့်လေဟှို ဖြတ်ကြွဟှားတော်မူဟှယ်။ ကိုယ်တော်ရဲ့ တဗဲ့တော်လေဟှာ ဂျောင်စဗားနှံလေဟှို ဆွတ်ဘီး၊ လတ်နပွတ်ဘီး စားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ဖာရိရှဲတချို့ဟှ “ဒန်းနေ့မာ နန်းနို့ဟှို လောက်န ဆိုဘီး နို့လေရဲ့ ပညတ်တရားမာ ပြောဟှားဇာဟှို ဖြားဖြစ်ကြောန့် နန်းနို့ လောက်ဂေ့ရနူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ယေရှုဟှာ သူးနို့ဟှို “ဒါဝိဒ်ဟှာ သူ့ရဲ့ ပေါန်းဖော်လေ ဗိုက်ဆာလာခီမာ ဖယ်မျိုးလောက်ဟှားဟှယ် ဆိုဇာဟှို နန်းနို့ ဖတ်ဖူးဂေ့ဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","သူဟှာ ဘုရားသခင်ရဲ့ အီတော်ဟှို ဝမ်ဘီး ဘုရားသခင်ဟှို ပူဇော်ဟှားဟှူ မုဟှို ယူဘီးစားဟှယ်။ အယ်ဘီးဟှာ သူ့ရဲ့ ပေါန်းဖော်လေဟှို ကျွေးဟှယ်။ ယဇ်ပုရောဟိတ်လေမှတပါး ဖယ်သူလည်း စားခွမ့်မှေ့ဟှူ အယ်မုဟှို ယူစားဟှယ် ဆိုဇာဟှာ နို့လေရဲ့ ပညတ်တရားဟှို ဆန့်ကျင်ဘဲ့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ယေရှုဟှ “လူ့ရဲ့သားဟှာ ဒန်းနေ့ရဲ့ သခင် ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","တခြားဒန်းနေ့မာ ယေရှုဟှာ ဝါလယ်ဇရပ်ဟှို ဝမ်ဘီး သွန်သန်တော်မူဟှယ်။ အယ်နေရာမာ ညာလတ်တဖတ် သေနေဟှူ လူတယော့‑က် ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ကျမ်းတတ်ဆရာ တချို့န ဖာရိရှဲ တချို့ဟှာ ယေရှုဟှို ပြစ်တန်ရှင်ကြောန့် ဒန်းနေ့မာ ကိုယ်တော်ဟှာ အယ်လူဟှို နာပျော့‑က်စေဟှို့လော၊ ပျော့‑က်စေဟှလော ဆိုဇာဟှို သူးနို့ဟှာ သေးသေချားချာ စောန့်ကေ့နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","အယ်ဘေမဲ့ ယေရှုဟှာ သူးနို့ရဲ့ ကြံစည်ဟှို သိကြောန့် အယ်လူဟှို “ထဒန်ဘီး ရှေ့ဟှို ထွပ်လာဟှား” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်လူဟှာ ထဒန်ဘီး မတ်တတ်ရပ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","အယ်ဘီးန ယေရှုဟှာ သူးနို့ဟှို “နန်းနို့ဟှို ငါမေးမယ်၊ နို့လေရဲ့ ပညတ်တရားဟှာ ဒန်းနေ့မာ ဖြားဇာလေ လောက်ဟှို့ ခွမ့်ပြုဟှားနူး။ ကောန်းဇာလောက်ရလော။ ဆိုးဇာလောက်ရလော။ လူတယော့‑က်ရဲ့ သတ်ဟှို ကယ်အပ်လော။ သတ်အပ်လော” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ကိုယ်တော်ဟှာ သူးနို့လေ ဂူလောင်း ပတ်လည်ဟှို ကေ့ရှုဘီးန ကိုယ်တော်ဟှာ အယ်လူဟှို “နန့်ရဲ့ လတ်ဟှို ဆန့်လိုက်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်လူဟှာ လတ်ဟှို ဆန့်လိုက်ဟှူ ခီမာ သူ့လတ်ဟှာ ကောန်းတိုင်း ပ္လန်ဖြစ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ဖာရိရှဲလေဟှာ ဒေါသထွပ်ဟှားဘီး ယေရှုဟှို ဖယ်မျိုးလောက်ရဟှို့ ဆိုဘီးဟှာ သူးနို့ရှင်းရှင်း တိုင်ဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","အယ်နေ့ရစ်မာ ယေရှုဟှာ ဆုတောန်းဟှို့ တောန်ထတ်ဟှို တတ်ကြွဟှားဘီး တညဉ့်လောင်း ဘုရားသခင်ဟှို ဆုတောန်းဘီး နေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","မိုးလန်းလာဟှူုခီမာ တဗဲ့တော်လေဟှို ကိုယ်တော်နားဟှို ခေါ်ဘီး သူးနို့ထဲဟှ ဆယ့်နှေ့ပါးဟှို ဝီးကော့‑က်ဘီး တမန်တော် ဆိုဘီး နာမယ် ပေးတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ကိုယ်တော်ဟှ ပေတရု ဆိုဘီး နာမယ် ပေးဟှားဟှူ ရှိမုန်န သူ့ညီအန္ဒြေ၊ ယာကုပ်န ယောဟန်၊ ဖိလိပ္ပုန ဗာသောလမဲ၊ ");
INSERT INTO tvn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","မဿဲန သောမ၊ အာလဖဲရဲ့သား ယာကုပ်န မျိုးရှစ်ပေါက်ကို ရှိမုန်၊ ");
INSERT INTO tvn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ယာကုပ်ရဲ့သား ယုဒန ကိုယ်တော့်ဟှို သစ်စာဖော့‑က်ဟှူ ယုဒရှကာရုတ် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ယေရှုဟှာ တမန်တော်လေနတူးဒူ တောန်ထတ်ဟှနေ ဆင်းလာဘီး တဗဲ့တော်လေဘောင်ဂီးန မ္လေညီးညီနေရာမာ ရပ်လိုက်ဟှယ်။ အယ်နေရာမာရှိနေဟှူ လူအောက်ဂီးဟှာ ယုဒပြည်န ယေရုရှလင်ဗြို့ဟှနေ လာဟှူ လူလေန ပန်လယ်ကမ်းနား တုရုဗြို့န ဇိဒုန်ဗြို့ဟှနေ လာဟှူ လူလေဖြစ်ဘီး ");
INSERT INTO tvn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","သူးနို့ဟှာ ကိုယ်တော်ရဲ့ တရားဟှို ကြားနာရဟှို့န သူးနို့ရဲ့ နာပျော့‑က်ဟှို့ လာဂေ့ဟှယ်။ ညစ်ညူးဟှူနတ်ဟှ ဒေါက်ခပေးရှင်းဟှို ခံနေရဟှူ လူလေလည်း နာပျော့‑က်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ကိုယ်တော်နားဟှနေ တဂိုးတော်ထွပ်ဘီးဟှာ သူးနို့လေ ဂူလောင်းဟှို နာပျော့‑က်စေကြောန့် လူလေ ဂူလောင်းဟှာ ကိုယ်တော့်ဟှို ထိဟှို့ ကြိုးစားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ယေရှုဟှာ တဗဲ့တော်လေဟှို ကေ့ဘီး “ဆင်းရဲသားလေ၊ နန်းနို့ဟှာ မင်္ဂလာရှိဟှယ်။ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှာ နန်းနို့ရဲ့ နိုင်ငံဖြစ်ဟှယ်!” ");
INSERT INTO tvn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“ခု ငတ်ပြတ်နေဟှူ နန်းနို့ဟှာ မင်္ဂလာရှိဟှယ်။ ဖြားဖြစ်ကြောန်းနူးဆိုဟှာ နန်းနို့ဟှာ ဗိုက်ပ္လဲ့ရဂေ့လေ့မယ်!” “ခု ငိုနေဟှူ နန်းနို့ဟှာ မင်္ဂလာရှိဘီး၊ နန်းနို့ဟှာ ရယ်ရလေ့မယ်!” ");
INSERT INTO tvn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“လူ့ရဲ့သားကြောန့် နန်းနို့ဟှို လူလေမူးဟှူဇာဘဲ့ဖြစ်ဖြစ်၊ ငြင်းပယ်ဟှူ ဇာဘဲ့ဖြစ်ဖြစ်၊ နန်းနို့နာမယ် ပျစ်အောန်လောက်ဟှူ ဇာဘဲ့ဖြစ်ဖြစ် နန်းနို့ဟှာ မင်္ဂလာရှိဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","အယ်မျိုးဖြစ်ဟှူ ခီမာ ဝန်းသာဘီးဟှာ ကခူဂေ့။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကောန်းဂန်ဘောင်မာ နန်းနို့တွပ် ရရာတိုင်း ကီးဟှူ ဆုလာဘ် ရှိဟှယ်။ သူးနို့ရဲ့ ဘိုးဘေးလေဟှာ ပရောဖက်လေဟှို အယ်မျိုးဘဲ့ ညှဉ်းဆဲဟှားဂေ့ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“အယ်ဘေမဲ့ ကပ်ရှိဟှူ နန်းနို့ဟှာ အမင်္ဂလာရှိဘီး၊ နန်းနို့ဟှာ ခုခီမာ သတ်သာဟှူ ဘဝဟှို ရဂေ့ဟှယ်!” ");
INSERT INTO tvn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“ခု ဗိုက်ပ္လဲ့အောန်စားရဟှူ နန်းနို့ဟှာ အမင်္ဂလာရှိဘီး၊ နန်းနို့ဟှာ ဗိုက်ဆာရလေ့မယ်!” “ခု ရယ်နေဟှူ နန်းနို့ဟှာ အမင်္ဂလာရှိဘီး၊ နန်းနို့ဟှာ ရရာတိုင်း ငြီးတွားဘီး ငိုရလေ့မယ်!” ");
INSERT INTO tvn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“လူလေ ဂူလောင်းဟှာ နန်းနို့ဟှို ချီးမွမ်းစကားပြောမယ် ဆိုဟှာ နန်းနို့ဟှာ အမင်္ဂလာရှိဘီး သူးနို့ရဲ့ ဘိုးဘေးလေဟှာလည်း ပရောဖက်တုယောန်လေဟှို အယ်မျိုးဘဲ့ ချီးမွမ်းဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“အယ်ဘေမဲ့ ငါ့စကားဟှို ကြားရဟှူ နန်းနို့ဟှို ငါပြောမယ်။ နန်းနို့ရဲ့ ရန်သူလေဟှို ရှစ်ဂေ့။ နန်းနို့ဟှို မူးဟှူလူလေဟှို ကျေးဇူးပြုဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","နန်းနို့ဟှို ကီဆဲဟှူ လူလေဟှို ကောန်းဂျီးပေးဂေ့။ နန်းနို့ဟှို နှော့‑က်ယှစ်ဟှူ လူလေတွပ် ဆုတောန်းဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ယော့‑က်ယော့‑က်ဟှ နန့်ပါးတဖတ်ဟှို ရိုက်ဟှယ် ဆိုဟှာ ကျန်ဟှူ ပါးတဖတ်ဟှိုလည်း ရိုက်ဟှို့ လှည့်ပေးလိုက်ပါ။ နန့်ဝတ်လောင်ဟှို လိုရှင်ဟှူ သူလေဟှို နန့်အန်းဂီဟှိုလည်း ပေးလိုက်ပါ။ ");
INSERT INTO tvn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","နန့်နားမာ တောန်းဟှူလူဟှို ပေးလိုက်ပါ။ နန့်အောက်စာဟှို သီးယူဟှူ လူနားမာ ပ္လန်ဘီး တောန်းန။ ");
INSERT INTO tvn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","နန်းနို့လေဟှို သူများလေဟှ ပြုမူဆစ်ဆံစေရှင်မျိုး သူများလေဟှိုလည်း ပြုမူဆစ်ဆံဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“နန်းနို့ဟှို ရှစ်ဟှူ သူလေဟှိုဘဲ့ ပ္လန်ရှစ်မယ် ဆိုဟှာ ဖယ်မျိုးလောက်ဘီး ကောန်းဂျီးမင်္ဂလာဟှို နန်းနို့ ခံစားရဟှို့နူး။ ပြစ်သားလေလည်းဘဲ့ သူးနို့ဟှို ရှစ်ဟှူ သူလေဟှိုဘဲ့ ပ္လန်ရှစ်ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","နန်းနို့ဟှို ကောန်းဇာလောက်ဟှူ လူလေဟှိုဘဲ့ ကျေးဇူးပြုမယ် ဆိုဟှာ ဖယ်မျိုးလောက်ဘီး ကောန်းဂျီးမင်္ဂလာဟှို နန်းနို့ ခံစားရဟှို့နူး။ ပြစ်သားလေလည်း အယ်မျိုးဘဲ့ လောက်ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","နန်းနို့ဟှို ပ္လန်ဘီး ဆပ်ပေးလေ့မယ် ဆိုဘီး မျှော်လင့်နေဟှူ လူလေဟှိုဘဲ့ နန်းနို့ ချေးငှါးမယ် ဆိုဟှာ ဖယ်မျိုးလောက်ဘီး ကောန်းဂျီးမင်္ဂလာဟှို နန်းနို့ ခံစားရဟှို့နူး။ ပြစ်သားလေလည်းဘဲ့ ပ္လန်ဘီး ဆပ်ပေးလေ့မယ် ဆိုဇာဟှို ယောင်ကြည်ဘီး ရှင်းရှင်း ချေးငှားဂေ့ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","နန်းနို့ရဲ့ ရန်သူဟှို ရှစ်ဘီး သူးနို့ဟှို ကောန်းဇာလောက်ဂေ့။ တခုခု ပ္လန်ရမယ် ဆိုဘီး မြော်လင့်ဘဲန ချေးငှါးဂေ့။ အယ်မျိုးလောက်မှ နန်းနို့ရဲ့ ကျိုးဟှာ ကီးမားဘီး နန်းနို့ဟှာ ဗြစ်ဆောင်းဖြစ်ဟှူ ဘုရားသခင်ရဲ့ သားမီးလေ ဖြစ်လေ့မယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကိုယ်တော်ဟှာ ကျေးဇူးကန်းဟှူ သူလေန ဆိုးဟှူ သူလေဟှိုလည်း ကျေးဇူးပြုကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","နန်းနို့ ဖဟှာ ကရုဏာရှိမျိုးဘဲ့ နန်းနို့လည်း ကရုဏာရှိဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“သူတပါးဟှို စစ်ကြောစီရင်ဂေ့န။ အယ်မျိုးဆိုဟှာ ဘုရားသခင်ဟှလည်း နန်းနို့ဟှို စစ်ကြောစီရင်လေ့ မှုဟှ။ သူတပါးဟှို ရှုတ်ခ္လဂေ့န။ အယ်မျိုးဆိုဟှာ ဘုရားသခင်ဟှလည်း နန်းနို့ဟှို ရှောက်ခ္လဟှို့ မှုဟှ။ သူတပါးဟှို ပြစ်လွှတ်ဂေ့။ အယ်မျိုးဆိုဟှာ ဘုရားသခင်ဟှလည်း နန်းနို့ဟှို ပြစ်လွှတ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","သူတပါးဟှို ပေးဂေ့။ အယ်မျိုးဆိုဟှာ ဘုရားသခင်ဟှလည်း နန်းနို့ဟှို ပေးလေ့မယ်။ နန်းနို့ဟှာ ပ္လဲ့လျှံလတ်ခံရလေ့မယ်။ နန်းနို့ဟှာ သူတပါးဟှို ပေးဟှူ ပမာဏတိုင်း ဘုရားသခင်ဟှ နန်းနို့ဟှို ပေးလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","အယ်ဘီးန ယေရှုဟှာ သူးနို့ဟှို ပေါင်ဥပမာန “မျစ်ကန်းတယော့‑က်ဟှ တခြားမျစ်ကန်းတယော့‑က်ဟှို လမ်းပြနိုင်ဟှ။ လမ်းပြမယ် ဆိုဟှာ နှေ့ယော့‑က်လောင်း တွမ်းထဲဟှို က္လလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","တဗဲ့လည်း ဆရာထတ် သာဟှ။ အယ်ဘေမဲ့ သူးနို့ရဲ့ ပညာသန်ယူဇာ ပီးဆောင်းဟှားဟှူ ခီမာ တဗဲ့ဂူလောင်းဟှာ သူးနို့ရဲ့ ဆရာမျိုးဘဲ့ ဖြစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“နန်ဟှာ ကိုယ့်မျစ်စိထဲဟှ သစ်တောင်းဟှို ဗြင်ဘဲန နန့်ညီကိုရဲ့ မျစ်စိထဲဟှ သစ်မုဟှို ဖြားဖြစ်ကြောန့် ဗြင်ရနူး။ ");
INSERT INTO tvn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","နန့်မျစ်စိထဲဟှ သစ်တောင်းဟှို ဗြင်ဘဲန နန့်ညီကိုဟှို ‘ညီကို၊ နန့်မျစ်စိထဲဟှ သစ်မုဟှားဟှို ထုပစ်ပေးပါရစေ’ ဆိုဘီး ဖြားဖြစ်ကြောန့် ပြောရနူး။ သူတော်ကောန်း ယောန်ဆောန်ဟှူသူ! နန့်မျစ်စိထဲဟှ သစ်တောင်းဟှို ရင်ဦးဆောင်း ထုပစ်လိုက်ပါ။ အယ်ဆိုဟှာ ညီကိုမျစ်စိထဲဟှ သစ်မုဟှို ထုပစ်ပေးဟှို့တွပ် ရှင်းရှင်းလန်းလန်းဟှား ဗြင်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“သစ်ပန်ကောန်းဟှာ သီးညံ့ဟှို သီးဂေ့ဟှ။ အယ်မျိုးဘဲ့ သစ်ပန်ညံ့ဟှာလည်း သီးကောန်းဟှို သီးဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","သစ်ပန်တိုင်းဟှာ သီးဟှို ကေ့လိုက်ဟှူန သစ်ပန်ရဲ့ ကြောန်းဟှို သိရလေဟှယ်။ နန်းနို့ဟှာ ဆူးဗန်ဟှနေ သန်းဖောသဖန်းသီးဟှို ဆွတ်ဟှို့ ရဂေ့ဟှမျိုးဘဲ့ ဆူးချောင်ဟှနေ စဗျစ်သီးဟှို ဆွတ်ဟှို့ ရဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","လူကောန်းဟှာ သူ့ရဲ့ စိနှလောင်း ဘဏ္ဍာတိုက်ထဲဟှ ကောန်းဟှူဇာလေဟှို ထောက်ဖော်တတ်ဘီး လူဆိုးဟှာ ဆိုးဟှူ ဇာလေဟှို ထောက်ဖော်တတ်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နှောက်ဟှာ စိနှလောင်းပ္လဲ့ ရှိဒဲ့တိုင်း ပြောတတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ငါဖြားဘဲ့ပြောပြော လောက်ဂေ့ဘဲ့န နန်းနို့ဟှ ငါ့ဟှို ‘သခင်၊ သခင်’ ဆိုဘီး ဖြားဖြစ်ကြောန့် ခေါ်နေရနူး။ ");
INSERT INTO tvn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ငါ့နားဟှိုလာဘီး ငါ့စကားဟှို ကြားဒဲ့တိုင်း နားထောန်ဟှူ သူဟှာ ဖယ်သူန တူဟှယ် ဆိုဇာ နန်းနို့ဟှို ငါပြမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","အယ်လူဟှာ မ္လေဂီးဟှို နတ်နတ်တူးဘီး က္လော့‑က်ထတ်မာ အုပြစ်ခ္လဘီးမှ အီဆော့‑က်မားန တူဟှယ်။ ရေကီးတတ်လာဘီးန အယ်အီဟှို တိုက်ခတ်ဟှူ ခီမာ က္လော့‑က်ထတ်မာ ဆော့‑က်ဟှားဟှူကြောန့် တူခါနိုင်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","အယ်ဘေမဲ့ ငါ့စကားဟှို ကြားဘီးဟှာ နားထောန်ဘဲဟှူသူဟှာ အုပြစ်ခ္လဘဲန မ္လေဂီးထတ်မာ အီဆော့‑က်မားနတူဘီး ရေကီးတတ်လာန အယ်အီဟှို တိုက်ခတ်လိုက်ဟှူ ခီမာ အီဟှာ ရှစ်ရှင်းပြိုက္လဟှားဘီး ဂူလောင်းဟှာ ပျစ်စီးဟှားဟှယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ယေရှုဟှာ လူလေဟှို ဂူလောင်း မိန့်တော်မူဘီးန ကိုယ်တော်ဟှာ ကပေရနောင်ဗြို့ဟှို ကြွဟှားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","အယ်ဗြို့မာ တပ်မှူးတယော့‑က်ရဲ့ ရရာတိုင်း ရှစ်ဟှူ ကျွန်တယော့‑က်ဟှာ ဖျားဘီး သေခါနီး ဖြစ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","တပ်မှူးဟှာ ယေရှုရဲ့ ဒန်းဟှို ကြားလိုက်ဟှူ ခီမာ သူဟှာ ယုဒလူမျိုး ကြီးကဲတချို့ဟှို ကိုယ်တော်နားဟှို စေလွှတ်ဘီး သူ့ရဲ့ ကျွန်ဟှို ကယ်တန်ပေးဟှို့ တောန်းလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","သူးနို့လေဟှာ ယေရှုနားဟှို ရော့‑က်ဟှူ ခီမာ မြစ်တာရပ်ခံဘီး “အယ်တပ်မှူးဟှာ ကိုယ်တော်ရဲ့ ကျေးဇူးပြုရှင်းဟှို ခံထိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","သူဟှာ ကျွန်တော့်ဟှားလေရဲ့ လူမျိုးလေဟှို ရှစ်ကြောန့် ကျွန်တော့်ဟှားလေတွပ် ဝါလယ်ဇရပ်တဆောန်ဟှို သူကိုယ်တိုင် ဆော့‑က်ပေးဟှားဟှယ်” ဆိုဘီး ကိုယ်တော့်ဟှို လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","အယ်ကြောန့် ယေရှုဟှာ သူးနို့လေနတူးဒူ လိုက်ဟှားဟှယ်။ ကိုယ်တော်ဟှာ တပ်မှူးရဲ့ အီနားဟှို ရော့‑က်ခါနီးမာ တပ်မှူးစေလွတ်လိုက်ဟှူ မိဆွေလေဟှာ ကိုယ်တော့်ဟှို “သခင်၊ ကိုယ့်ကိုယ်ကိုယ် ပန်ဗန်းခံတော်မူပါန။ ကျွန်တော်ရဲ့ အီးခေါန်မိုးအော့‑က်ဟှို ကိုယ်တော်ဟှာ ဝမ်တော်မူရှင်း ကျေးဇူးဟှို ကျွန်တော်ခံထိုက်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","အယ်မျိုးဘဲ့ ကျွန်တော် ကိုယ်တိုင်လည်း ကိုယ်တော်နားဟှို ရော့‑က်ထိုက်ဟှူလူ မှုဟှ။ မိန့်ပေးလိုက်န ကျွန်တော်ရဲ့ စေခံဟှာ ကျန်းမာရပါလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ဥပမာ ကျွန်တော် ကိုယ်တိုင်လည်း အာဏာပိုင်လတ်အော့‑က်မာ ရာရှိတယော့‑က် ဖြစ်ဘီး ကျွန်တော်ရဲ့ လတ်အော့‑က်မာရှိဟှူ စစ်သားလေဟှို အောက်ချောက်ရပါဟှယ်။ တယော့‑က်ဟှို ‘သွား!’ ဆိုဟှာ သွားပါဟှယ်။ တယော့‑က်ဟှို ‘လာ!’ ဆိုဟှာ လာပါဟှယ်။ အယ်ဘီးဟှာ ကျွန်တော်ဟှာ ကျွန်တော့်ရဲ့ ကျွန်ဟှို မိန့်ပေးလိုက်ဟှယ် ‘အယ်မူဇာဟှို လောက်လိုက်!’ ဆိုဟှာ လောက်လေဟှယ်” ဆိုဘီး လျှော့‑က်စေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","အယ်စကားဟှို ယေရှုကြားဟှူ ခီမာ အံ့ဩဟှားဘီး ကိုယ်တော်ဟှာ ပတ်လည်ဟှို ကေ့ဘီးန နော့‑က်တော်ဟှို လိုက်နေဟှူ လူအောက်ဂီးဟှို “နန်းနို့ဟှို ငါပြောမယ်။ အယ်မျှလော့‑က်ကီးဟှူ ယောင်ကြည်ရှင်းမျိုး ဣသရေလလူမျိုးထဲမာဟှို ငါလောင်းဝ တွိဖူးဟှ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","တပ်မှူးစေလွှတ်လိုက်ဟှူ လူလေဟှာ အီဟှို ပ္လန်ရော့‑က်န တပ်မှူးရဲ့ ကျွန်ဟှာ ကျန်းမာဟှားဘီ ဆိုဇာဟှို တွိလိုက်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","နော့‑က်တနေ့မာယေရှုဟှာ နာဣန နာမယ်ရှိဟှူဗြို့ဟှို တဗဲ့တော်လေန လူအောက်ဂီးနတူးဒူ ကြွဟှားတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ကိုယ်တော်ဟှာ ဗြို့ခွဗေါ့‑က်နား ရော့‑က်ဟှူ ခီမာ မောက်ဆိုးမရဲ့ တယော့‑က်ဒဲရှိဟှူ သားရဲ့ လောန်းဟှို သင်္ဂြိုဟ်ဟှို့ ဗြို့ပ္လန်ဟှို ထွပ်လာဂေ့ဟှယ်။ အယ်မောက်ဆိုးမနတူးဒူ ဗြို့သူဗြို့သားလေ ဘောင်ဂီးဟှာ မသာပို့ လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","သခင်ဘုရားဟှာ အယ်မောက်ဆိုးမဟှို ဗြင်တော်မူဟှူ ခီမာ ကိုယ်တော်ရဲ့ စိနှလောင်းမာ အယ်မီးမဟှို သနားစိ ဖြစ်လာတော်မူဘီးန အယ်မီးမဟှို “ငိုန” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","အယ်ဘီးန ကိုယ်တော်ဟှာ တလားဟှို လတ်န သွားဘီး ထိလိုက်ဟှူကြောန့် တလားထမ်းလာဟှူ လူလေဟှာ ရပ်ဟှားဂေ့ဟှယ်။ ယေရှုဟှ “ကောန်သားဟှား! နန့်ဟှို ငါပြောမယ်၊ ထပါ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","သေကောန်ဟှာ ထထိုင်ဘီးန စကားပြောနေဟှယ်။ ယေရှုဟှ ကောန်သားဟှားဟှို သူ့မိဟှို ပ္လန်ပေးတော်မူလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","လူလေ ဂူလောင်းဟှာ ကြော့‑က်ရွံ့ရှင်းပ္လဲ့န ဘုရားသခင်ဟှို ချီးမွမ်းဂေ့ဟှယ်။ “နို့လေထဲမာ ပရောဖက်ဂီး ပေါ်လာဘီ! ဘုရားသခင်ဟှာ သူ့ရဲ့ လူမျိုးဟှို ကယ်တန်ဟှို့ ရော့‑က်လာဘီ!” ဆိုဘီး သူးနို့ဟှ ချီးမွမ်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ယေရှုရဲ့ ဒန်းဟှာ ယုဒပြည်ဟှ စဘီး ပတ်ဝန်းကျင် တခုလောင်းဟှို ပ္လံ့နှံ့ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ယောဟန်ရဲ့ တဗဲ့လေဟှာ အယ်ကြောန်းရာ ဂူလောင်းဟှို သူးနို့ဆရာဟှို ပြောပြဟှူ ခီမာ သူဟှာ တဗဲ့လေထဲဟှ နှေ့ယော့‑က်ဟှို ခေါ်လိုက်ဘီးန ");
INSERT INTO tvn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","သခင်ဘုရားနားဟှို စေလွတ်ဘီး “ကိုယ်တော်ဟှာ ကြွလာတော်မူမယ် ဆိုဘီး ပြောနေသူလော။ နော့‑က်ထပ် တယော့‑က်ဟှို မျှော်နေရအူးလော” ဆိုဘီး မေးလျှော့‑က်ခိုင်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","သူးနို့ဟှာ ယေရှုနားဟှို ရော့‑က်လာဟှူ ခီမာ “ဗတ္တိဇံယောဟန်ဟှ ကျွန်တော့်ဟှားလေဟှို မေးလျှော့‑က်ခိုင်းလိုက်ဟှယ်။ ကိုယ်တော်ဟှာ ရော့‑က်လာမယ် ဆိုဘီး ပြောနေဟှူ သခင်လော။ နော့‑က်ထပ် တယော့‑က်ဟှို မျှော်နေရအူးလော” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","အယ်ခီမာ ယေရှုဟှာ လူလေဘောင်ဂီးဟှို သူးနို့ရဲ့ ဖျားနာရှင်းလေ၊ ရောဂါလေ၊ နတ်ဆိုးဘေးဟှနေ လွှတ်မြော့‑က်စေဟှယ်။ မျစ်စိကန်းဟှူ လူလေဟှို မျစ်စိပ္လန်ဗြင်စေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ကိုယ်တော်ဟှာ ယောဟန် စေလွတ်လိုက်ဟှူ လူလေဟှို “နန်းနို့လေကြားရ၊ ဗြင်ရဇာလေဟှို ပ္လန်ဟှားဘီး ယောဟန်ဟှို ပြောပြဂေ့။ မျစ်စိကန်းနေဟှူလူလေ ဗြင်ဟှားဘီ။ လမ်းရှော့‑က်နိုင်ဘဲဟှူ လူလေ လမ်းပ္လန်ရှော့‑က်ဟှားဘီ။ နူနာသည်လေဟှာ သန့်ရှင်းဟှားဘီ။ နားပန်းနေဟှူ လူလေဟှာ နားကြားဟှားဘီ။ သေနေဟှူ လူလေဟှာ ပ္လန်ရှင်ဟှားဘီ။ ဆင်းရဲသားလေဟှာ အယ်ဒန်းကောန်းဟှို ကြားရဟှားဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ငါ့ဟှို ငြင်းပယ်ဘဲဟှူ လူလေဟှာ မင်္ဂလာရှိဟှယ်!” ဆိုဘီး ပ္လန်ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ယောဟန် စေလွှတ်လိုက်ဟှူ လူလေ ပ္လန်ဟှားဘီးန ယေရှုဟှာ ယောဟန်ကြောန်းဟှို “ယောဟန်ဟှို တွိဟှို့ ဆိုဘီး တောကန္တာရထဲဟှို သွားဟှူ ခီမာ ဖြားဇာလေ တွိမယ် ဆိုဘီး မျှော်လင့်နူး။ လေတိုက်ဟှိ လှောက်နေဟှူ ကျူဗန်လေဟှို ကေ့ဟှို့ သွားဟှူဇာလော။ ");
INSERT INTO tvn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ဖြားဇာလေဟှို တွိရှင်ကြောန့် သွားနူး။ ဝတ်ကောန်းကောန်းဝတ်ဟှူ လူဟှို ကေ့ဟှို့ သွားဟှူဇာလော။ အယ်မျိုး အံ့ဩဘွယ်ဝတ်ဟှားဘီး စည်းဇိမ်ခံနေဟှူ လူလေဟှာ နန်းတော်မာဘဲ့ ရှိဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ဖြားဇာလေ ကေ့ရှင်ကြောန့် သွားနူး။ ငါဟှို ပြောကေ့။ ပရောဖက်ဟှို ကေ့ရှင်ကြောန့် သွားဇာလော။ မှန်ပါဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ဟှာ ပရောဖက်ထတ် ရရာတိုင်း ကီးဟှူလူဟှို ဗြင်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ယောဟန်ဟှို ကျမ်းစာမာ ‘ဘုရားသခင်ဟှ ပြောဟှယ်။ ငါဟှာ သင်သွားမယ့်လမ်းဟှို ဆင်သင့်ဖြစ်စေဟှို့ ငါ့ရဲ့ တမန်ဟှို နန့်ရှေ့မာ စေလွှတ်မယ်’ ဆိုဘီး ပြောဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","နန်းနို့ဟှို ငါပြောမယ်။ လောကမာ သတ်ရှင်ဟှားဟှူ လူလေထဲမာ ယောဟန်ထတ် ကီးမြတ်ဟှူ လူမှေ့ဟှ။ အယ်ဘေမဲ့ ဘုရားသခင်ရဲ့ နိုင်ငံတော်မာ ငယ်ဆောင်းဟှူလူဟှာ ယောဟန်ထတ် ပိုဘီး ကီးမြတ်ဟှယ်” ဆိုဘီး ယေရှုဟှ ထပ်ဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","လူလေ ဂူလောင်းဟှာ ကိုယ်တော်ရဲ့စကားဟှို ကြားဟှူ ခီမာ သူးနို့န ထူးသဖြင့် ခွန်ကော့‑က်မားလေဟှာ ဘုရားသခင်ရဲ့ ဖြောန့်မတ်ရှင်းဟှို ဝန်ခံဂေ့ဘီး ယောဟန်ပေးဟှူ ဗတ္တိဇံခံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","အယ်ဘေမဲ့ ဖာရိရှဲလေန ကျမ်းတတ်ဆရာလေဟှာ သူးနို့ကိုယ်တိုင်တွပ် ဘုရားသခင်ရဲ့ ကြံစည်တော်ဟှို ငြင်းပယ်ဂေ့ဘီး ယောဟန်ရဲ့ ဗတ္တိဇံဟှို ခံဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ယေရှုဟှ ဆစ်ဘီး “ခုခေတ်မာ ရှိနေဟှူ လူလေဟှို ဖြားဇာန နှိုင်းပြရမယ်နူး။ သူးနို့ဟှာ ဖြားဇာလေန တူဟှယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","သူးနို့ဟှာ ဆေးထဲမာ ထိုင်နေဟှူ သားဂန်းလေန တူဟှယ်။ သားဂန်းတအောက်ဟှာ တခြား သားဂန်းတအောက်ဟှို ‘နို့လေဟှာ အီတတ်ဗွဲတီးလောင်းဟှို နန်းနို့တွပ် တီးမှုပေးဘေမဲ့ နန်းနို့ဟှာ ကဂေ့ဟှ! နို့လေဟှာ မသာအီမာဆိုဟှူ မသာချင်းဟှို ဆိုဘေမဲ့ နန်းနို့ဟှာ ငိုဂေ့ဟှ!’ ဆိုဘီး အော်ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ဗတ္တိဇံယောဟန်ဟှာ စာရှောန်ဘီး ဝိုင်ဟှို သော့‑က်ဘဲန ရော့‑က်လာဟှူကြောန့် နန်းနို့ဟှ ‘သူ့ထဲမာ နတ်ဆိုးပူးနေဟှယ်!’ ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","လူ့ရဲ့သားဟှာ စားသော့‑က်ဘီး ရော့‑က်လာဟှူ ခီမာ နန်းနို့ဟှ ‘အယ်လူဟှို ကေ့ပါ! အယ်လူဟှာ စားမတ်ဘီး ဝိုင်သော့‑က်သူ၊ ခွန်ကော့‑က်မားလေန ပြစ်သားလေရဲ့ မိဆွေဖြစ်ဟှယ်!’ ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","အယ်ဘေမဲ့လည်း ဘုရားသခင်ရဲ့ ပညာတရားဟှို လတ်ခံဟှူ လူလေဟှ အယ်ပညာတရားဟှာ မှန်ဟှယ် ဆိုဇာဟှို သတ်သေပြဂေ့ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ဖာရိရှဲတယော့‑က်ဟှာ သူ့နတူးဒူ ညဉ့်ဇာစားဟှို့ ယေရှုဟှို တောန်းလျှော့‑က်တော်မူကြောန့် ယေရှုဟှာ ဖာရိရှဲရဲ့ အီဟှို ဝမ်ဘီးန စားဗွဲမာ ထိုင်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","အယ်ဗြို့မာ ရရာတိုင်း ပြစ်ကီးဟှူ မီးမတယော့‑က် ရှိဟှယ်။ ဖာရိရှဲရဲ့ အီမာ ယေရှုဟှာ ညဉ့်ဇာစားနေဟှယ် ဆိုဇာဟှို အယ်မီးမဟှာ ကြားလိုက်ဟှူကြောန့် ဆီမွှီး က္လော့‑က်ဖ္လူဖူးဟှို ယူဟှားဘီးန ");
INSERT INTO tvn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ယေရှုရဲ့ ခေတော်ရင်းမာ ရပ်ဘီး ငိုနေဟှူကြောန့် အယ်မီးမရဲ့ မျစ်ရယ်ဟှာ ကိုယ်တော်ရဲ့ ခေတော်ထတ်ဟှို က္လနေဟှယ်။ အယ်ဘီးန အယ်မီးမဟှာ သူ့ရဲ့ဆားဗန်န ကိုယ်တော်ရဲ့ ခေတော်ဟှို ခြော့‑က်အောန်သုဘီး ကိုယ်တော်ရဲ့ ခေတော်ဟှို နမ်းဘီး ဆီမွှီးန လူးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","အယ်မူဇာဟှို ဗြင်နေဟှူ ဖာရိရှဲဟှာ “အယ်လူဟှာ ပရောဖက် မှန်ဟှယ် ဆိုဟှာ သူ့ရဲ့ခေဟှို ကိုင်နေဟှူ အယ်မီးမဟှာ ဖယ်မျိုး မီးမဖြစ်ဟှယ် ဆိုဇာဟှို သိလေ့မယ်။ အယ်မီးမဟှာ ဖယ်မျိုး ပြစ်သား ဖြစ်ဟှယ် ဆိုဇာဟှို သိလေ့မယ်!” ဆိုဘီး သူ့ကိုယ်သူ ပြောနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ယေရှုဟှ “ရှိမုန်၊ နန့်ဟှို ငါပြောဇာရှိဟှယ်” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ရှိမုန်ဟှ “ပြောပါ၊ ဆရာ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ယေရှုဟှ “ကပ်ကွီးချေးမား တယော့‑က်မာ ကပ်ကွီးတန်နေဟှူ လူနှေ့ယော့‑က် ရှိဟှယ်။ တယော့‑က်မာ ငွေဒန်းဂါးပ္လားငါးရာ ကပ်ကွီးတန်နေဘီး တခြားတယော့‑က်မာ ငွေဒန်းဂါးပ္လားငါးဆယ် ကပ်ကွီးတန်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","သူးနို့ နှေ့ယော့‑က်လောင်းဟှာ ကပ်ကွီးဟှို ပ္လန်ဆပ်နိုင်ဘဲကြောန့် ကပ်ကွီးချေးမားဟှာ သူးနို့ရဲ့ ကပ်ကွီးဂူလောင်းဟှို ကင်းလွှတ်ခွမ့် ပေးလိုက်ဟှယ်။ အယ်ဆိုဟှာ သူးနို့နှေ့ယော့‑က်ထဲဟှ ဖယ်သူဟှာ ကပ်ကွီံးချေးမားဟှို ပိုဘီး ရှစ်လေ့မယ်နူး။” ");
INSERT INTO tvn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ရှိမုန်ဟှ “ကပ်ကွီးဘောင်ဂီး ကင်းလွှတ်ခွမ့် ပေးခံရဟှူလူဟှာ ပိုဘီး ရှစ်လေ့မယ် ထန်ဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ယေရှုဟှ “နန်ထန်ဇာ မှန်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","အယ်ဘီးန ကိုယ်တော်ဟှာ အယ်မီးမဖတ်ဟှို လှည့်ဘီး ရှိမုန်ဟှို “အယ်မီးမဟှို နန်ဗြင်ဘဲ့လော။ နန့်အီဟှို ငါလာဟှူ ခီမာ နန်ဟှာ ငါ့တွပ် ခေဆေးရေဟှို ပေးဟှ။ အယ်ဘေမဲ့ အယ်မီးမဟှာ ငါ့ခေဟှို သူ့မျစ်ရယ်န ဆေးပေးဘီး ငါ့ခေဟှို ခြော့‑က်အောန် သူ့ဆားဗန်န သုပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","နန်ဟှာ ငါ့ဟှို နမ်းဟှ။ အယ်ဘေမဲ့ အယ်မီးမဟှာ ငါ့ခေဟှို နားဒမ်း နမ်းနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","နန်ဟှာ ငါ့ခေါန်းဟှို ဆီန လူးပေးဟှ။ အယ်ဘေမဲ့ အယ်မီးမဟှာ ငါ့ခေဟှို ဆီမွှီးန လူးပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","နန့်ဟှို ငါပြောမယ်၊ သူဟှာ ပြစ်ဘောင်ဂီး ခွမ့်လွှတ်ရှင်းခံရကြောန်းဟှို သူ့ရဲ့ ကီးမားဟှူ မြစ်တာန သတ်သေပြနေဟှယ်။ အယ်ဘေမဲ့ ပြစ်နဲနဲဘဲ့ လွှတ်ရှင်းခံရဟှူ လူဟှာ နဲနဲဘဲ့ ရှစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","အယ်ဘီးန ယေရှုဟှာ အယ်မီးမဟှို “နန့်ရဲ့ ပြစ်လေ ခွမ့်လွှတ်ရှင်းခံရဘီ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","စားဗွဲမာ ထိုင်နေဟှူ တခြားလူလေဟှ “ပြစ်လေဟှို ခွမ့်လွှတ်ပေးနေဟှူ အယ်လူဟှ ဖယ်သူနူး။” ဆိုဘီး သူးနို့ ရှင်းရှင်းပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","အယ်ဘေမဲ့ ယေရှုဟှာ အယ်မီးမဟှို “နန့်ရဲ့ ယောင်ကြည်ရှင်းဟှာ နန့်ဟှို ကယ်တန်လိုက်ဘီ။ ငြီသတ်ရှင်းန သွားပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ခီနဲနဲ ကြာဘီးန ယေရှုဟှာ ဗြို့ဝါလေဟှို ဖြတ်ကြွဟှားဘီး ဘုရားသခင်ရဲ့ နိုင်ငံတော်ကြောန်း ဒန်းကောန်းဟှို ဟောတော်မူဟှယ်။ တဗဲ့တော် ဆယ့်နှေ့ယော့‑က်ဟှာ ကိုယ်တော်နတူးဒူ လိုက်ဟှားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ရောဂါဘေး၊ နတ်ဆိုးဘေးလေဟှ လွှတ်ဟှားဟှူ မီးမတချို့န နတ်ဆိုးခွန်နစ်ကောန်ရဲ့ နှိစစ်ရှင်းဟှနေ လွှတ်ဟှားဟှူ မာရိန (မာဂဒလဝါသူ ဆိုဘီး လည်းခေါ်ဟှယ်)၊ ");
INSERT INTO tvn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ဟေရုဒ်မန်းဂီးရဲ့ မျစ်နှာလွှဲဖြစ်ဟှူ ခုဇရဲ့ မယား ယောဟန္န၊ ရှုရှန္န၊ ယေရှုန တဗဲ့တော်လေဟှို လောက်ကျွေးနေဟှူ မီးမတချို့လည်း လိုက်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ဗြို့ဗြို့နယ်နယ်ဟှ လာဂေ့ဟှူ လူလေဟှာ ယေရှုနားမာ စုရောင်းဘီးနေဟှူ ခီမာ ကိုယ်တော်ဟှာ အယ်ပေါင်ဥပမာအားဖြင့် ");
INSERT INTO tvn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“မျိုးစေ့ကြဲဟှို့ ထွပ်ဟှားဟှူ မျိုးစေ့ကြဲမား တယော့‑က်ရှိဟှယ်။ သူဟှာ မျိုးစေ့ဟှို ကြဲလိုက်ဟှူ ခီမာ တချို့စေ့လေဟှာ လမ်းမာက္လဟှူကြောန့် အယ်မျိုးစေ့ဟှာ နန်းချေရှင်းခံရဘီးန ကောန်းဂန်ငှတ်လေဟှ ကော့‑က်စားဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","တချို့စေ့လေဟှာ က္လော့‑က်ပေါဟှူ မ္လေမာက္လဘီးန ပန်ပေါ့‑က်လာဟှူ ခီမာ စိုဓါတ်မှေ့ဘဲဟှူ မ္လေဖြစ်ဟှူကြောန့် ခြော့‑က်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","တချို့စေ့လေဟှာ ဆူးချောင်ကြားမာ က္လဟှူကြောန့် ဆူးဗန်လေနတူးဒူး ကီးလာဘီးဟှာ ပန်လေဟှို အောက်မိုးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","တချို့စေ့လေဟှာ ကောန်းဟှူမ္လေမာ က္လဟှူကြောန့် ပန်လေဟှာ ကီးလာဘီး ဆတရာ သီးသီးဟှားဂေ့ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်ဘီးန ယေရှုဟှာ နိဂေါင်းချောက်ဘီး “နန်းနို့မာ နားရှိဟှယ် ဆိုဟှာ ကြားဂေ့!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","တဗဲ့တော်လေဟှာ အယ်ပေါင်ဥပမာရဲ့ ဓိပါယ်ဟှို ယေရှုဟှို မေးလျှော့‑က်ဂေ့ဟှူကြောန့်၊ ");
INSERT INTO tvn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ကိုယ်တော်ဟှ ပေါင်ဥပမာန “ဘုရားသခင်နိုင်ငံတော်ရဲ့ နတ်နဲဟှူ ကြောန်းရာလေဟှို နန်းနို့ဟှာ သိရပီးဘီ။ တခြားလူလေဟှာ ကေ့နေဘေမဲ့ ဗြင်ဂေ့ မှုဟှ။ ကြားနေဘေမဲ့ နားလည်ဂေ့ မှုဟှ။ အယ်ကြောန့် ပြောရရှင်း ဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“အယ်ပေါင်ဥပမာရဲ့ ဓိပါယ်ဟှ မျိုးစေ့ဟှာ ဘုရားသခင်ရဲ့ တရားစကား ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","လမ်းမာက္လဟှူ မျိုးစေ့ဟှာ တရားစကားဟှို ကြားရဟှူ လူလေဖြစ်ဟှယ်။ အယ်ဘေမဲ့ သူးနို့ဟှာ ယောင်ကြည်ဘီး ကယ်တန်ရှင်းဟှို ရော့‑က်စေဘဲ့ဟှို့တွပ် မာရ်နတ်ဟှာလာဘီး တရားစကားဟှို သူးနို့ရဲ့ နှလောင်းထဲဟှနေ နှုယူဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","က္လော့‑က်ပေါဟှူ မ္လေမာ က္လဟှူမျိုးစေ့ဟှာ တရားစကားဟှို ကြားရဟှူ ခီမာ ဝန်းသာအားရန လတ်ခံဂေ့ဟှူ လူလေဖြစ်ဟှယ်။ အယ်ဘေမဲ့ သူးနို့ထဲမာ တရားစကားဟှာ ပြစ်စွဲဘဲကြောန့် ရှစ်ဟှားဘဲ့ ယောင်ကြည်ဘီး စောင်ဇမ်းရှင်းလေန တွိကြောင်ဟှူ ခီမာ ဖော့‑က်ပ္လန်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ဆူးချောင်မာက္လဟှူ မျိုးစေ့ဟှာ တရားစကားဟှို ကြားရဘီးန ဘဝရဲ့ စိုးရိမ်ရှင်းလေ၊ စည်းဇိမ်ကြွယ်ဝရှင်းလေ၊ လောက သာယာမှုလေရဲ့ လွှမ်းမိုးရှင်းဟှို ခံရဟှူကြောန့် သီးသီးနိုင်ဂေ့ဘဲဟှူ သူလေ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ကောန်းဟှူမ္လေမာ က္လဟှူ မျိုးစေ့ဟှာ တရားစကားဟှို ကြားရဘီးန ဖြောန့်မတ်စင်ကြယ်ဟှူ စိနှလောင်းန ခံယူကြောန့် ခိုင်မြဲဟှူ သီးဟှို သီးဂေ့ဟှူ လူလေဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ဖယ်သူလည်း ဆီမီးအီဟှို ထွန်းဘီးဟှာ တောန်းအော့‑က်မာ ထားဂေ့ဟှ။ ကဒန်အော့‑က်မာလည်း ထားဟှားဂေ့ဟှ။ အယ်မျိုးထားမယ့်စား ဆီမီးအီဟှို ဆီမီးခေါင်ထတ်မာဘဲ့ တန်ဟှားဟှယ်။ အယ်မျိုးထားမှဘဲ့ လူလေဟှာ အီထဲဟှို ဝမ်လာခီမာ လန်းရောန်ဟှို ဗြင်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“ဝှပ်ဟှားဇာလေ ဂူလောင်း ပေါ်လာလေ့မယ်။ ဖောင်းဟှားဇာလေ ဂူလောင်းဟှာလည်း ပွမ့်ဟှားလေ့ဘီးန လန်းရောန်နားဟှို ယူလာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“အယ်ကြောန့် နန်နို့ဟှာ ဖယ်မျိုးနားထောန်ရမယ် ဆိုဇာဟှို ဒိပြုဂေ့။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ရှိဟှူဟှို ထပ်ပေးလေ့မယ်။ အယ်ဘေမဲ့ လောင်းဝမှေ့ဘဲဟှူ လူလေနားဟှ သူးနို့မာ နဲနဲရှိဟှယ် ဆိုဘီး ထန်နေဇာလေဟှို သီးယူလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ယေရှုရဲ့ မိန ညီလေဟှာ ကိုယ်တော်နားဟှို လာဘေမဲ့ လူအောက်ဂီးကြောန့် ကိုယ်တော်နားဟှို ရော့‑က်နိုင်ဘဲ့ ဖြစ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","တယော့‑က်ဟှ ယေရှုဟှို “ကိုယ်တော်ရဲ့ မိန ညီလေဟှာ ကိုယ်တော့်ဟှို တွိရှင်ကြောန့် ပ္လန်မာ ရပ်စောန့်နေဟှယ်” ဆိုဘီး လာလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ယေရှုဟှာ “ဘုရားသခင်ရဲ့ စကားတော်ဟှို ကြားဘီးဟှာ နားထောန်ဟှူ လူလေဟှာ ငါ့မိ၊ ငါ့ညီလေဖြစ်ဟှယ်” ဆိုဘီး သူးနို့လေ ဂူလောင်းဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","တနေ့မာ ယေရှုဟှာ တဗဲ့တော်လေနတူးဒူ လှေထဲဟှို ဝမ်ဟှားဘီးန သူးနို့ဟှို “အိုင်တဖတ်ဟှို ကူးဂေ့ဇို့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်ကြောန့် သူးနို့ဟှာ စဘီးကူးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","သူးနို့ဟှာ ဝပ်လွှမ့်နေဟှူ ခီမာ ယေရှုဟှာ အိမွိနေတော်မူဟှယ်။ ရောက်တရစ် အိုင်ထဲမာ လေမူဒိုင်းက္လဘီး လှေဟှာ ရေနပ္လဲ့ခါနီးနီး ဖြစ်ဟှားဟှူကြောန့် သူးနို့လေ ဂူလောင်းဟှာ ရရာတိုင်း ကြော့‑က်လန့်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","တဗဲ့တော်လေဟှာ ယေရှုနားဟှို သွားဘီးန ကိုယ်တော့်ဟှို နှိုးဘီး “သခင်၊ သခင်! ကျွန်တော့်ဟှားလေ သေဟှို့ဖြစ်နေဂေ့ဘီ!” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ယေရှုဟှာ အိယာဟှ ထလာဘီးန လေနလှိုင်းဟှို မိန့်ပေးလိုက်ဟှူန လေနလှိုင်းလည်း လောက်ဝ ငြီသတ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","အယ်ဘီးမှ ကိုယ်တော်ဟှာ တဗဲ့တော်လေဟှို “နန်းနို့ရဲ့ ယောင်ကြည်ရှင်း ဖယ်မာနူး” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ သူးနို့ဟှာ ကြော့‑က်ရွံ့အံ့ဩဘီး “အယ်လူဟှ ဖယ်သူနူး။ သူဟှာ လေနလှိုင်းလေဟှို မိန့်ပေးလိုက်န သူးနို့လေဟှာ နားထောန်ဂေ့ဟှယ်!” ဆိုဘီး သူးနို့ရှင်းရှင်း ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ယေရှုန တဗဲ့တော်လေဟှာ ဂါရစပြည်ဟှို ဝပ်လွှမ့်ဟှားဘီး ဂီရသဒေသဟှာ ဂါလိလဲပြည် အိုင်တဖတ်မာ ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ယေရှုဟှာ ကမ်းထတ်ဟှို ခေခ္လလိုက်ဟှူန နတ်ဆိုးလေပူးနေဟှူ ဂါရစဗြို့သား တယော့‑က်ဟှာ ကိုယ်တော့်ဟှို လာတွိလေဟှယ်။ အယ်လူဟှာ ခီကြာဂီး ဝတ်လည်းဝတ်ဘဲန၊ အီမာလည်းနေဘဲန သန်းခ္လိုင်းထဲမာဘဲ့ နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","သူဟှာ ယေရှုဟှို ဗြင်ခီမာ ကိုယ်တော်ရဲ့ ခေတော်ရင်းမာ ပ္လားပ္လားဝပ်ဘီး “ဗြင့်ဆောင်းဟှူ ဘုရားသခင်ရဲ့ သားတော် ယေရှု! ကိုယ်တော်ဟှာ ကျွန်တော်န ဖြားဆိုင်ဟှယ်နူး။ ကျွန်တော် တောန်းဗန်ပါဟှယ်။ ကျွန်တော့်ဟှို နှိစစ်ပါန!” ဆိုဘီး သံက္လယ်ဂီးန လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","အယ်မျိုး တောန်းဗန်နေဇာဟှ ယေရှုဟှာ ညစ်ညူးဟှူ နတ်လေဟှို အယ်လူထဲဟှ ထွပ်ဟှားဟှို့ မိန့်ပေးတော်မူလိုက်ကြောန့် ဖြစ်ဟှယ်။ အယ်လူဟှာ နတ်ဆိုးရဲ့ ခါဘီးခါ နှိစစ်ဇာဟှို ခံရဘီး သူ့ရဲ့ ခေလတ်လေဟှို သံကြိုးလေန ခယ်ဟှားဘီး လှောန်ဟှားဘေမဲ့လည်း သူဟှာ သံကြိုးလေဟှို ဆွဲဖြတ်ဘီးဟှာ တောကန္တာရထဲဟှို ထွပ်ပ္လေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ယေရှုဟှာ “နန့်နာမယ် ဖြားမျိုးခေါ်နူး” ဆိုဘီး သူဟှို မေးတော်မူဟှယ်။ သူ့ထဲမာ နတ်ဆိုးလေ ဘောင်ဂီးရှိနေဟှူကြောန့် သူဟှ “ကျွန်တော့်နာမယ်ဟှာ ‘လေဂေါင် ဖြစ်ဟှယ်’ ” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","နတ်ဆိုးလေဟှာ သူးနို့ဟှို နတ်ဆောင်းတွမ်းထဲဟှို နှန်ခ္လဘဲဟှို့တွပ် ယေရှုဟှို တောန်းဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","နီးနားဟှ တောန်ဂူးထတ်မာ ဝပ်အောက်ဂီးဟှာ စာစားနေဂေ့ဟှယ်။ နတ်ဆိုးလေဟှာ သူးနို့ဟှို အယ်ဝပ်လေထဲဟှို ဝမ်ခွမ့်ပေးတော်မူဟှို့ တောန်းဗန်ဂေ့ဟှူကြောန့် ယေရှုဟှာ ခွမ့်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","နတ်ဆိုးလေဟှာ အယ်လူထဲဟှ ထွပ်ဟှားဘီးန ဝပ်လေထဲဟှို ဝမ်ဟှားဟှယ်။ ဝပ်အောက်ဂီးဟှာ အိုင်ကမ်းနားဟှို ပ္လေးဆင်းဟှားဘီး ရေမ္လောက်သေဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ဝပ်ထီးမားလေဟှာ အယ်မျိုး ဖြစ်ဟှားဇာလေဟှို ဗြင်ဟှားကြောန့် သူးနို့ဟှာ ထွပ်ပ္လေးဂေ့ဘီးန ဗြို့န တောဝါလေမာ အယ်ဒန်းဟှို လိုက်ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","လူလေဟှာ အယ်မျိုးဖြစ်ဟှားဇာလေဟှို ကေ့စားဟှို့ ထွပ်လာဂေ့ဟှူ ခီမာ နတ်ဆိုးလေ ထွပ်ဟှားဘီးဟှူ လူဟှာ ဝတ်ဟှို ဝတ်ဟှားဘီး ပေါင်မှန်စိန ယေရှုရဲ့ ခေတော်ရင်းမာ ထိုင်နေဇာဟှို တွိလိုက်ကြောန့် သူးနို့လေ ဂူလောင်းဟှာ ကြော့‑က်လန့်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","အယ်လူဟှာ ဖယ်မျိုးလောက်ဘီး နတ်ဆိုးလေရဲ့ နှိစစ်ရှင်းဟှနေ လွှတ်မြော့‑က်ဟှားဟှယ် ဆိုဇာဟှို ကိုယ်တိုင်ဗြင်ဘီးဟှူ လူလေဟှ ခုမှရော့‑က်လာဟှူ လူလေဟှို ပြောပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","အယ်ဘီးန ဂါရစဒေသဟှ လူလေ ဂူလောင်းဟှာ ရရာတိုင်း ကြော့‑က်လန့်နေဟှူကြောန့် အယ်ဒေသဟှ ထွပ်ဟှားတော်မူဟှို့ ယေရှုဟှို တောန်းလျှော့‑က်ဂေ့ဟှယ်။ အယ်ကြောန့် ယေရှုဟှာ လှေထဲဟှို ဝမ်ဟှားတော်မူဘီးန ပ္လန်ဟှားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","နတ်ဆိုးလေ ထွပ်ဟှားဟှူ လူဟှာ ယေရှုဟှို “ကိုယ်တော်နတူးဒူ လိုက်ခွမ့်ပေးတော်မူပါ” ဆိုဘီး တောန်းဗန်လေဟှယ်။ အယ်ဘေမဲ့ ယေရှုဟှာ သူ့ဟှို ");
INSERT INTO tvn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“အီဟှို ပ္လန်ဟှားဘီး ဘုရားသခင်ဟှာ နန့်ဟှို ဖယ်မျိုး ကျေးဇူးပြုတော်မူဟှယ် ဆိုဇာဟှို သွားဘီး ကြေညာပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်လူဟှာ တဗြို့လောင်းဟှို သွားဘီး ယေရှုဟှာ သူ့ဟှို ဖယ်မျိုး ကျေးဇူးပြုလိုက်ဟှယ် ဆိုဇာဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ယေရှုဟှာ အိုင်တဖတ်ဟှို ပ္လန်ဟှားဟှူ ခီမာ လူလေဟှာ ကိုယ်တော့်ဟှို ကြိုဆိုဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့ဟှာ ကိုယ်တော့်ဟှို စောန့်နေဂေ့ကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","အယ်ခီမာ ယာဣရု နာမယ်ရှိဟှူ လူတယော့‑က် ရော့‑က်လာဟှယ်။ သူဟှာ ဝါလယ်ဇရပ်မှူး ဖြစ်ဟှယ်။ သူဟှာ ယေရှုရဲ့ ခေတော်ရင်းမာ ပ္လားပ္လားဝပ်ဘီး သူ့အီဟှို ကြွပေးတော်မူဟှို့တွပ် ကိုယ်တော့်ဟှို တောန်းဗန်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူ့ရဲ့ တယော့‑က်ဒဲရှိဟှူ ဆယ့်နှေ့နှစ်ရွယ် သမီးဟှာ သေခါနီးဖြစ်နေကြောန့် ဖြစ်ဟှယ်။ ယေရှုဟှာ သူနတူးဒူ လိုက်ဟှားဟှူ ခီမာ လူလေဟှာ ကိုယ်တော့်ဟှို တိုးဝှေ့နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","သူးနို့လေထဲမာလည်း ဆယ့်နှေ့နှစ် လောင်းလောင်း သွီးသွန်နာဖြစ်နေဟှူကြောန့် သူ့ကပ်လေ ဂူလောင်း ကူဒဲ့ထိ ဆရာဝန်လေန ကုဟှယ်။ အယ်ဘေမဲ့လည်း သူ့ရောဂါဟှို ပျော့‑က်အောန် ကုနိုင်ဂေ့ဘဲဟှူ မီးမတယော့‑က်ရှိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","အယ်မီးမဟှာ ယေရှုနော့‑က်ဟှ ကပ်လိုက်ဟှားဘီးန ကိုယ်တော်ရဲ့ ဝတ်လောင်တော်ဟှ ပန်းဗွားဟှို တို့ထိလိုက်ဟှူန အယ်မီးမရဲ့ သွီးသွန်ဇာဟှ ရှင်းရှင်း တိဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ယေရှုဟှ “ငါ့ဟှို ဖယ်သူ တို့ထိလိုက်နူး” ဆိုဘီး မေးလိုက်ဟှယ်။ လူတိုင်းဟှ ဂြင်းဂေ့ဘီး ပေတရုဟှ “သခင်၊ လူလေဟှာ ကျွန်တော့်ဟှားလေရဲ့ ပတ်လည်မာရှိနေဘီး ကိုယ်တော့်ဟှို တိုးဝှေ့နေဂေ့ဟှယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","အယ်ဘေမဲ့ ယေရှုဟှ “ငါ့ဟှို ယော့‑က်ယော့‑က်ဟှ တို့ထိလိုက်ဟှယ်။ ငါ့ထဲဟှ တဂိုးထွပ်ဟှားဇာဟှို ငါသိဟှယ်” ဆိုဘီး ပ္လန်မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","အယ်မီးမဟှာ သူတို့ထိလိုက်ဇာဟှို သိဟှားဘီ ဆိုဘီး ကြော့‑က်ရွံ့တောင်လှောက်နေကြောန့် ရှေ့ဟှို ထွပ်လာဘီး ယေရှုရဲ့ ခေတော်ရင်းမာ ပျပ်ဝပ်လိုက်ဟှယ်။ လူလေ ဂူလောင်းရဲ့ရှေ့မာ ကိုယ်တော့်ဟှို ဖြားကြောန့် တို့ထိရကြောန်းန ဖယ်မျိုး ရှင်းရှင်း နာပျော့‑က်ဟှားကြောန်းဟှို ပြောပြလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ယေရှုဟှာ အယ်မီးမဟှို “ငါ့သမီး၊ နန့်ရဲ့ ယောင်ကြည်ရှင်းဟှာ နန့်ဟှို ကျန်းမာစေဘီ။ ငြီသတ်ရှင်းန သွားပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ယေရှုဟှာ အယ်မျိုး ပြောနေဟှူ ခီမာဘဲ့ ဝါလယ်ဇရပ်မှူးရဲ့ အီဟှနေ လူတယော့‑က် ရော့‑က်လာဟှယ်။ ယာဣရုဟှို “ကိုယ်တော်ရဲ့ သမီးဟှာ သေဟှားဘီ။ ဆရာဟှို နှောက်ယှစ်ပေးန” ဆိုဘီး သူဟှ ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","အယ်ဘေမဲ့ ယေရှုဟှာ အယ်မျိုးပြောနေဇာဟှို ကြားဘီးန ယာဣရုဟှို “စိုးရိမ်န။ ယောင်ကြည်ရှင်းဘဲ့ရှိပါ။ ဝယ်ဟှားဂန်းဟှာ ကျန်းမာဟှားလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ယာဣရုရဲ့ အီဟှို ရော့‑က်ဟှားဟှူ ခီမာ ကိုယ်တော်ဟှာ ပေတရု၊ ယောဟန်၊ ယာကုပ်န ဝယ်ဟှားဂန်းရဲ့ မိဖလေဟှလွဲဘီး တခြားဖယ်သူ့ဟှိုမှ ကိုယ်တော်နတူးဒူ အီထဲဟှို ဝမ်ခွမ့်ပေးဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","လူတိုင်းဟှာ ဝယ်ဟှားဂန်းတွပ် ငိုကြွေးဘီးဝန်းနဲ နေဂေ့ဟှယ်။ ယေရှုဟှ “ငိုန၊ ဝယ်ဟှားဂန်းဟှာ သေနေဇာ မှုဟှ။ အိမွိနေဟှယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","သူးနို့ ဂူလောင်းဟှာ ကိုယ်တော့်ဟှို ရယ်ဇားဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဝယ်ဟှားဂန်းဟှာ သေနေဘီ ဆိုဇာဟှို သူးနို့ သိနေကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","အယ်ဘေမဲ့ ယေရှုဟှာ ဝယ်ဟှားဂန်းရဲ့ လတ်ဟှို ကိုင်လိုက်ဘီး “ဝယ်ဟှားဂန်း၊ ထဝေါ့!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ဝယ်ဟှားဂန်းဟှာ သတ်ဝိညာဉ် ပ္လန်ဝမ်လာဘီး ရှစ်ရှင်းထလေဟှယ်။ ယေရှုဟှာ ဝယ်ဟှားဂန်းဟှို စားဇာကျွေးဟှို့ သူးနို့ဟှို မိန့်တော်မူလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ဝယ်ဟှားဂန်းရဲ့ မိဖလေဟှာ ရရာတိုင်း အံ့ဩဟှားဟှယ်။ အယ်ဘေမဲ့ ယေရှုဟှ အယ်မျိုးဖြစ်ဇာလေဟှို ဖယ်သူ့ဟှိုလည်း ပြောဘဲဟှို့တွပ် သူးနို့ဟှို ပညတ်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ယေရှုဟှာ တဗဲ့တော် ဆယ့်နှေ့ပါးဟှို ခေါ်ဘီး နတ်ဆိုးလေဟှို နှန်ထုဟှို့န ရောဂါလေ ပျော့‑က်စေဟှို့ သူးနို့ဟှို တဂိုးန ခွမ့်အာဏာဟှို ပေးတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","အယ်ဘီးန ကိုယ်တော်ဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ကြောန်း ဟောပြောဟှို့န လူနာလေ ကျန်းမာစေဟှို့ သူးနို့ဟှို စေလွတ်တော်မူဘီးန၊ ");
INSERT INTO tvn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","သူးနို့ဟှို “ခရီးသွားဟှို့တွပ် နန်းနို့နတူးဒူ ဖြားဇာလည်း ယူဟှားဂေ့န။ တောန်အူး၊ လွယ်အိ၊ စားဇာ၊ ကပ်လေန အန်းဂီပိုလည်း ယူဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ဖယ်အီဘဲ့ဖြစ်ဖြစ် နန်းနို့ဟှို ဝမ်ခွမ့်ပြုဟှယ် ဆိုဟှာ အယ်ဗြို့ဟှ ထွပ်ခန်ထိ အယ်အီမာနေဘီး ");
INSERT INTO tvn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","လူလေဟှ နန်းနို့ဟှို လတ်ခံဟှ ဆိုဟှာ အယ်ဗြို့ဟှ ထွပ်ဟှားဘီး သူးနို့ဟှာ လတ်ခံဂေ့ဟှ ဆိုဇာဟှို သတ်သေဖြစ်န နန်းနို့ခေဖွားဟှ မ္လေမုဟှို ခါခ္လလိုက်ဂေ့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","တဗဲ့တော်လေဟှာ ထွပ်ဟှားဘီး ဝါလေဂူလောင်းဟှို သွားဘီးန ရော့‑က်ဟှူ နေရာတိုင်းမာ ဒန်းကောန်းဟောပြောဂေ့ဘီး ရောဂါလေဟှို ပျော့‑က်စေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ဂါလိလဲပြည်ဟှို အောက်ချောက်ဟှူ ဟေရုဒ်ဟှာ ကိုယ်တော် ပြုတော်မူဟှူ ဇာလေ ဂူလောင်းဟှို ကြားဟှူ ခီမာ ရရာတိုင်း စိရှောက်ဟှားဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လူတချို့ဟှ ဗတ္တိဇံ ယောဟန်ဟှာ သေဘီးမှ ပ္လန်ရှင်လာဟှယ် ဆိုဘီး ပြောနေကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","တခြားလူလေဟှ ဧလိယ ပ္လန်ပေါ်လာဟှယ် ဆိုဇာဟှို ပြောဂေ့ဘီး တခြားလူလေဟှလည်း ရှေးပရောဖက်လေထဲဟှ တယော့‑က် သေဘီးမှ ပ္လန်ရှင်လာဟှယ် ဆိုဘီး ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ဟေရုဒ်ဟှ “ငါဟှာ ယောဟန်ရဲ့ ခေါန်းဟှို ဖြတ်လိုက်ပီးဘီ။ အယ်ဆိုဟှာ ငါဒန်းကြားနေရဟှူ အယ်လူဟှာ ဖယ်သူနူး” ဆိုဘီး ပြောလေဟှယ်။ အယ်ဘီးန သူဟှာ ယေရှုဟှို တွိရဟှို့ ရှာကြံလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","တမန်တော်လေဟှာ ပ္လန်ရော့‑က်လာဘီးန ယေရှုဟှို သူးနို့ရဲ့ လောက်ဆောန်ချစ်လေ ဂူလောင်းဟှို လျှော့‑က်ဂေ့ဟှယ်။ ကိုယ်တော်ဟှာ သူးနို့နတူးဒူ ဗက်ဇဲဒ ဆိုဘီး နာမယ်ရှိဟှူ ဗြို့ဟှို ကြွဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","လူအောက်ဂီးဟှာ အယ်မျိုးကြွဟှားဟှယ် ဆိုဇာဟှို ကြားရဟှူ ခီမာ ကိုယ်တော်နော့‑က်ဟှို လိုက်ဂေ့ဟှယ်။ ကိုယ်တော်ဟှာ သူးနို့ဟှို ကြိုဆိုဘီး ဘုရားသခင်ရဲ့ နိုင်ငံတော်ကြောန်းဟှို ဟောပြောဘီးဟှာ ရောဂါရှိဟှူ သူလေဟှို နာပျော့‑က်စေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ညဉ့်မိုက်ခါနီးခီမာ တဗဲ့တော် ဆယ့်နှေ့ပါးဟှာ ကိုယ်တော့်နားဟှို လာဘီးန “လူလေဟှို နီးနားမာရှိနေဟှူ ဝါလေဟှို သွားစေဘီး အိဟှို့နေရာလေန စားဇာလေရှာဟှို ရှာစေတော်မူပါ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်နေရာဟှာ လူသူမှေ့ဘဲဟှူ နေရာဖြစ်ဟှူကြောန့် ဖြစ်ဟှယ်” ဆိုဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","အယ်ဘေမဲ့ ကိုယ်တော်ဟှာ သူးနို့ဟှို “နန်းနို့ကိုယ်တိုင် သူးနို့စားဟှို့ စားဇာတခုခုပေးဂေ့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ သူးနို့ဟှ “ကျွန်တော့်ဟှားလေ ဂူလောင်းမာ မုငါးလောင်းန ငါးနှေ့ကောန်ဘဲ့ ရှိဟှယ်။ ကိုယ်တော်ဟှ အယ်လူအောက်ဂီးတွပ် စားဇာဝယ်ဟှို့ ကျွန်တော့်ဟှားလေဟှို သွားစေရှင်လော” ဆိုဘီး ပ္လန်လျှော့က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(အယ်လူအောက်ဂီးထဲမာ ယော့‑က်ကျား ၅,၀၀၀ လော့‑က် ရှိဟှယ်။) ယေရှုဟှာ တဗဲ့တော်လေဟှို “လူလေဟှို ငါးဆယ်စီစုဘီး ထိုင်ခိုင်းလိုက်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","တဗဲ့တော်လေဟှာ မိန့်တော်မူလိုက်ဟှူတိုင်း လောက်ဘီးန၊ ");
INSERT INTO tvn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ယေရှုဟှာ မုငါးလောင်းန ငါးနှေ့ကောန်ဟှို ယူလေဟှယ်။ အယ်ဘီးန ကောန်းဂန်ဟှို မော့ကေ့ဘီး၊ မုန ငါးတွပ် ဘုရားသခင်ဟှို ချီးမွမ်းဘီး၊ မုဟှို ဖဲ့ဘီးန လူလေဟှို ဝီပေးဟှို့ တဗဲ့တော်လေဟှို ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","သူးနို့ ဂူလောင်းဟှာ ဗိုက်ပ္လဲ့အောန် စားဂေ့ဘီးန တဗဲ့တော်လေဟှာ ကြွင်းကျန်လေဟှို လိုက်ကော့‑က်ဂေ့ဇာ ခြင်းဒေါန်းန ဆယ့်နှေ့တောန်းပ္လဲ့ ရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","တနေ့မာ ယေရှုတပါးဒဲ ဆုတောန်းနေဟှူ ခီမာ တဗဲ့တော်လေဟှာ ကိုယ်တော်နားဟှို လာဂေ့ဟှယ်။ ကိုယ်တော်ဟှ “လူအောက်ဂီးဟှ ငါဟှို ဖယ်သူ ဆိုဘီး ပြောနေဂေ့နူး” ဆိုဘီး သူးနို့ဟှို မေးတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","သူးနို့ဟှ “တချို့ဟှ ကိုယ်တော်ဟှာ ဗတ္တိဇံယောဟန် ဖြစ်ဟှယ်။ တခြားလူလေဟှ ကိုယ်တော်ဟှာ ဧလိယဖြစ်ဟှယ်။ တခြားလူလေဟှ သေဘီးမှ ပ္လန်ရှင်လာဟှူ ရှေးပရောဖက် တပါးပါး ဖြစ်ဟှယ် ဆိုဘီး ပြောဂေ့ဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ကိုယ်တော်ဟှ “နန်းနို့လေဟှမား ငါ့ဟှို ဖယ်သူဖြစ်ဟှယ် ဆိုဘီး ပြောဂေ့နူး” ဆိုဘီး သူးနို့ဟှို မေးတော်မူလေဟှယ်။ ပေတရုဟှ “ကိုယ်တော်ဟှာ ဘုရားသခင်ရဲ့ မေရှိယ ဖြစ်ဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","အယ်ဘီးန ယေရှုဟှာ အယ်ကြောန်းဟှို ဖယ်သူ့ဟှိုလည်း ပြောဘဲဟှို့တွပ် သူးနို့ဟှို မိန့်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ကိုယ်တော်ဟှလည်း “လူ့ရဲ့သားဟှာ ရရာတိုင်း နာကျင်ရှင်း ဝေဒနာဟှို ခံရဘီး ကြီးကဲလေ၊ ယဇ်ပုရောဟိတ်ဂီးလေန ကျမ်းတတ်ဆရာလေရဲ့ ငြင်းပယ်ရှင်းဟှို ခံရလေ့မယ်။ လူ့ရဲ့သားဟှာ သေသတ်ရှင်းဟှို ခံရမယ်။ အယ်ဘေမဲ့ သောင်းရစ် ပ္လဲ့ဟှူ နေ့မာ လူ့ရဲ့သားဟှာ ပ္လန်ရှင်လေ့မယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","အယ်ဘီဟှာ ကိုယ်တော်ဟှာ သူးနို့ ဂူလောင်းဟှို “နန်းနို့ဟှ ငါ့တဗဲ့ ဖြစ်ရှင်ဟှယ် ဆိုဟှာ ကိုယ့်ကိုယ်ကိုယ် ငြင်းပယ်ဘီး နေ့တိုင်း နန်းနို့ရဲ့ လတ်ဝါးကပ်တိုင်ဟှို ထမ်းဘီးဟှာ ငါ့နော့‑က်ဟှို လိုက်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ဖြားဖြစ်ကြောန့်နူဆိုဟှာ နန်းနို့ရဲ့ သတ်ဟှို ကယ်တန်ရှင်ဟှယ် ဆိုဟှာ နန်းနို့ဟှာ သတ်ရှောင်းလေ့မယ်။ အယ်ဘေမဲ့ ငါ့ကြောန့် နန်းနို့ရဲ့ သတ်ရှောင်းမယ် ဆိုဟှာ နန်းနို့ဟှာ နန်းနို့သတ်ဟှို ကယ်တန်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","နန်းနို့ဟှာ လောက တခုလောင်းဟှို ပိုင်ဆိုင်ခွမ့် ရဘေမဲ့လည်း နန်းနို့ရဲ့ သတ်ရှောင်းမယ် ဆိုဟှာ ဖြားကျိုးရှိမယ်နူး။ ဖြားကျိုးလည်းမှေ့ဟှ! ");
INSERT INTO tvn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","နန်းနို့ဟှာ ငါ့န ငါ့ရဲ့ စကားလေတွပ် ယှစ်နေမယ် ဆိုဟှာ လူ့ရဲ့သားဟှာ သူ့ရဲ့ ဖောင်းသရေတော်၊ ဖရဲ့ ဖောင်းသရေတော်၊ သန့်ရှင်းဟှူ ကောန်းဂန်တမန်လေရဲ့ ဖောင်းသရေတော်န ကြွလာဟှူ ခီမာ အယ်လူတွပ် ယှစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ အယ်နေရာမာ ရှိနေဟှူ လူတချို့ဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို ဗြင်ရဘဲ့န သေရလေ့ဟှို့ မှုဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ယေရှုဟှာ အယ်မျိုးမိန့်တော်မူဘီး တဘတ်လော့‑က် ကြာဟှူ ခီမာ ပေတရု၊ ယာကုပ်န ယောဟန်လေဟှို ခေါ်ဘီးန ဆုတောန်းဟှို့ တောန်ထတ်ဟှို တတ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ကိုယ်တော်ဟှာ ဆုတောန်းနေဟှူ ခီမာ ကိုယ်တော်ရဲ့ မျစ်နှာဟှာ ဆင်းသဏ္ဌာန် ပ္လောန်းလဲဟှားဘီး ဝတ်တော်ဟှာလည်း ဖ္လူဆွတ်ဆွတ် ဖြစ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","လူနှေ့ယော့‑က်ဟှာ ရောက်တရစ် ပေါ်လာဘီး ကိုယ်တော်န စကားပြောနေဂေ့ဟှယ်။ သူးနို့ဟှာ မောရှေန ဧလိယဖြစ်ဘီး ");
INSERT INTO tvn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","သူးနို့ဟှာ ကောန်းဂန်ဖောင်းသရေတော်န ပေါ်လာဘီး ဘုရားသခင်ရဲ့ ရည်ရွယ်ချစ် ပ္လဲ့ဇောင်ဟှို့တွပ် ကြာခန်မာ ယေရုရှလင်ဗြို့မာ ကိုယ်တော် သေခံရဟှို့ကြောန်းဟှို ယေရှုန ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ပေတရုန သူ့ရဲ့ လောက်ဖော်ဆောန်ဖတ်လေဟှာ အိမွိနေဂေ့ဟှယ်။ အယ်ဘေမဲ့ သူးနို့ဟှာ နိုးလာဘီးဟှာ ယေရှုရဲ့ ဖောင်းသရေတော်န ကိုယ်တော်နတူးဒူ ရပ်နေဟှူ လူနှေ့ယော့‑က်ဟှို ဗြင်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","အယ်လူနှေ့ယော့‑က်ဟှာ ယေရှုနားဟှ ထွပ်ဟှားဟှူ ခီမာ ပေတရုဟှာ ကိုယ်တော့်ဟှို “သခင်၊ အယ်နေရာဟှာ နေရှင်ဘွယ်ကောန်းဟှယ်! ကျွန်တော့်ဟှားလေဟှာ ကိုယ်တော်တွပ် တဲတဆောန်၊ မောရှေတွပ် တဲတဆောန်န ဧလိယတွပ် တဲတဆောန်၊ တဲသောင်းဆောန်ဟှို ကျွန်တော်ဟှားလေ ဆော့‑က်ပေးမယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ (သူပြောနေဇာဟှို သူတကယ် သိဂေ့ဟှ။) ");
INSERT INTO tvn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","သူဟှာ အယ်မျိုး လျှော့‑က်နေဟှူ ခီမာဘဲ့ မိုးတီတခု ပေါ်လာဘီးဟှာ သူးနို့ဟှို ဖောင်းဟှားလိုက်ဟှူကြောန့် ကြော့‑က်လန့်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","မိုးတီထဲဟှနေ “အယ်သူဟှာ ငါဝီးကော့‑က်ဟှားဟှူ ငါ့ရဲ့ ရှစ်ဟှူသား ဖြစ်ဟှယ်။ သူ့စကားဟှို နားထောန်ဂေ့!” ဆိုဘီး သံတော် ထွပ်ပေါ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","သံတော် ထွပ်ပေါ်လာဘီးန ယေရှုတပါးဒဲဟှိုဘဲ့ ဗြင်ရလေဟှယ်။ အယ်ခီမာ တဗဲ့တော်လေဟှာ ဗြင်ရဟှူဇာလေ ဂူလောင်းဟှို ဖယ်သူ့ဟှိုလည်း ပြောဘဲန တိတိဟှားနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","နတ်ကီးဖတ်မာ ယေရှုန တဗဲ့တော် သောင်းပါးဟှာ တောန်ထတ်ဟှနေ ဆင်းလာဂေ့ဟှူ ခီမာ လူအောက်ဂီးဟှာ ယေရှုဟှို ကြိုဆိုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","လူအောက်ဂီးထဲဟှနေ လူတယော့‑က်ဟှ “ဆရာ! ကျွန်တော့်ရဲ့ သားဟှို ကေ့ရှုပေးဟှို့ ကျွန်တော်တောန်းဗန်ပါဟှယ်။ သူဟှာ ကျွန်တော့်ရဲ့ တယော့‑က်ဒဲဟှူ သားဖြစ်ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","နတ်ဖမ်စားဟှားဟှူကြောန့် သူဟှာ ရောက်တရစ် ထအော်ဘီးဟှာ ဇတ်ပေါ့‑က်ဟှ ဖြုတ်လေထွပ်ဘီး တော့‑က်မာလာလေဟှယ်။ နတ်ဟှာ သူ့ဟှို နာကျင်အောန်လောက်ဘီးမှ ခတ်ခတ်ခဲခဲ ထွပ်ဟှားဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ကျွန်တော်ဟှာ ဆရာရဲ့ တဗဲ့လေဟှို အယ်နတ်ဟှို နှန်ထုခိုင်းဘေမဲ့ သူးနို့ဟှာ တတ်နိုင်ဂေ့ဟှ” ဆိုဘီး အော်ဟစ်ဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ယေရှုဟှ “ယောင်ကြည်ရှင်းလည်းမှေ့။ ဖော့‑က်ပ္လန်ဟှူ လူလေ! ငါဟှာ နန်းနို့နတူးဒူ ဖယ်လော့‑က်ကြာအောန် နေနေရနူး။ ငါဟှာ နန်းနို့ဟှို ဖယ်လော့‑က်ကြာကြာ သီးခံရဟှို့နူး။” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်ဘီးန ကိုယ်တော်ဟှာ အယ်လူဟှို “နန့်ရဲ့ သားဟှို ခေါ်လာပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ကောန်သားဟှားဟှာ လာနေဒူးမာဘဲ့ နတ်ဆိုးဟှာ သူ့ဟှို မ္လေထတ်မာလှဲခ္လဘီး တော့‑က်မာအောန် လောက်ဟှယ်။ ယေရှုဟှာ ညစ်ညူးဟှူနတ်ဟှို မိန့်ပေးလိုက်ဘီး ကောန်းသားဟှားဟှို ကျန်းမာစေဘီးန သူ့ရဲ့ဖဟှို ပ္လန်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","လူလေ ဂူလောင်းဟှာ ဘုရားသခင်ရဲ့ မဟာတဂိုးတော်ဟှို အံ့ဩဟှားဂေ့ဟှယ်။ လူလေဟှာ ယေရှု ပြုလောက်ဇာလေ ဂူလောင်းဟှို အံ့ဩနေခီမာဘဲ့ ကိုယ်တော်ဟှာ တဗဲ့တော်လေဟှို ");
INSERT INTO tvn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“နန်းနို့ဟှို ငါမိန့်မှာဟှားဇာလေဟှို မေ့ဂေ့န! လူ့ရဲ့သားဟှာ လူလေရဲ့ လတ်ထဲဟှို အပ်ရှင်းဟှို ခံရလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","အယ်ဘေမဲ့ အယ်စကားဟှို တဗဲ့တော်လေ နားလည်နိုင်ဘဲအောန် ဓိပါယ်ဟှို ဖောင်းဟှားကြောန့် သူးနို့ဟှာ နားလည်ဂေ့ဟှ။ အယ်ဓိပါယ်န ပတ်သတ်ဘီး ကိုယ်တော့်ဟှို တောန်းလျှော့‑က်ဟှို့လည်း သူးနို့ ကြော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","တဗဲ့တော်လေ ကြားထဲမာ ဖယ်သူဟှာ ကီးမြတ်ဆောင်း ဖြစ်ဟှယ် ဆိုဘီး ဂြင်းခူရှင်းလေ ဖြစ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ယေရှုဟှာ သူးနို့ ဖြားဇာလေ ဂြင်းခူနေဟှယ် ဆိုဇာဟှို စိထဲမာ သိဟှူကြောန့် သားဂန်းဟှား တယော့‑က်ဟှို ခေါ်ဘီးဟှာ ကိုယ်တော်ရဲ့ ဘေးနားမာ ရပ်စေဘီးန၊ ");
INSERT INTO tvn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","သူးနို့လေဟှို “အယ်မူသားဂန်းဟှားဟှို ငါ့နာမနှိုက် လတ်ခံဟှူသူဟှာ ငါ့ဟှို လတ်ခံဟှယ်။ ငါ့ဟှို လတ်ခံဟှူသူဟှာ ငါ့ဟှို စေလွှတ်လိုက်ဟှူ သူဟှိုလည်း လတ်ခံရှင်းဖြစ်ဟှယ်။ အယ်ကြောန့် နန်းနို့ထဲမာ ငယ်ဆောင်းဟှူလူဟှာ ကီးမြတ်ဆောင်း ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ယောဟန်ဟှ “သခင်၊ ကိုယ်တော်ရဲ့ နာမန နတ်ဆိုးလေဟှို နှန်ထုနေဟှူ လူတယော့‑က်ဟှို ကျွန်တော့်ဟှားလေ တွိဟှားဟှယ်။ အယ်လူဟှာ ကျွန်တော့်ဟှားလေ အောက်စုထဲဟှမှုဘဲကြောန့် ကိုယ်တော်ရဲ့ နာမဟှို သောင်းန ဆိုဘီး တားမြစ်ဟှားဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ယေရှုဟှာ “အယ်လူဟှို တားမြစ်ဂေ့န။ ဖြားဖြစ်ကြောန်ဆိုဟှာ နန်းနို့ဟှို ဆန့်ကျင်ဘဲဟှူ လူဟှာ နန်းနို့ဖတ်မာရှိဟှယ်” ဆိုဘီး ယောဟန်န တခြားတဗဲ့တော်လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ယေရှုဟှာ ကောန်းဂန်ဘောင်ဟှို တတ်ကြွဟှို့ နီးလာဟှူ ခီမာ ယေရုရှလင်ဗြို့ဟှို ကြွဟှားတော်မူဟှို့ စိဆောင်းဖြတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ကိုယ်တော်ဟှာ စေတမန်လေဟှို ရှေ့ဟှနေ စေလွှတ်ဘီး သူးနို့ဟှာ ကိုယ်တော်တွပ် ပြင်ဆင်ဟှို့ ရှမာရိဝါထဲဟှို ဝမ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","အယ်ဘေမဲ့ ကိုယ်တော်ဟှာ ယေရုရှလင်ဗြို့ဟှို ခရီးပြုနေဟှယ် ဖြစ်ဟှူကြောန့် အယ်နေရာမာရှိနေဟှူ လူလေဟှာ ကိုယ်တော့်ဟှို လတ်ခံဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","အယ်မူဇာဟှို တဗဲ့တော်လေဖြစ်ဟှူ ယာကုပ်န ယောဟန်လေ ဗြင်ဟှားဟှူ ခီမာ သူးနို့ဟှ “သခင်ဘုရား၊ ကျွန်တော့်ဟှားလေဟှာ ဧလိယလောက်ဟှူမျိုး ကောန်းဂန်ဟှနေ မီးက္လစေလိုက်ဘီး သူးနို့ဟှို လောန်ဟှားဟှို့ ကိုယ်တော် လိုရှင်လော။” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","အယ်ဘေမဲ့ ယေရှုဟှာ လှည့်ကေ့ဘီးန သူးနို့ဟှို ဆောင်းမလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","အယ်ဘီးန ယေရှုဟှာ တဗဲ့တော်လေန တခြားဝါဟှို ဆစ်ဘီး ကြွဟှားတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","သူးနို့ဟှာ ခရီးဆစ်သွားနေကြောန့် လူတယော့‑က်ဟှာ ယေရှုဟှို “ကိုယ်တော် ဖယ်နေရာသွားသွား ကျွန်တော် လိုက်ပါမယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ယေရှုဟှလည်း “မ္လေခွီးမာ တွမ်းရှိဟှယ်။ ကောန်းဂန်ဟှ ငှတ်မာလည်း သိုက်ရှိဟှယ်။ အယ်ဘေမဲ့ လူ့ရဲ့သားမာဟှ ခေါန်းခ္လဟှို့တွပ် နေရာမှေ့ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ကိုယ်တော်ဟှာ “ငါ့နော့‑က်ဟှို လိုက်ပါ” ဆိုဘီး တခြား တယော့‑က်ဟှို မိန့်တော်မူလေဟှယ်။ အယ်ဘေမဲ့ အယ်လူဟှ “သခင်၊ ကျွန်တော့်ဖဟှို ရင်ဦးဆောင်း သွားဘီး သင်္ဂြိုဟ်ဟှို့တွပ် ခွမ့်ပေးပါ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ယေရှုဟှ “လူသေလေဟှို လူသေလေဘဲ့ သင်္ဂြိုဟ်ပါစေ။ နန်ဟှာ သွားဘီး ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို ဟောပြောပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","နော့‑က်တယော့‑က်ဟှလည်း “သခင်၊ ကျွန်တော်ဟှာ ကိုယ်တော့် နော့‑က်တော်ဟှို လိုက်ရှင်ဟှယ်။ အယ်ဘေမဲ့ ကျွန်တော့်မိသားစုဟှို ရင်ဦးဆောင်း နှောက်ဆစ်ခွမ့်ပြုပါ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ယေရှုဟှာ သူ့ဟှို “ထွန်ဂိုင်းဟှို ကိုင်ဘီး နော့‑က်ဟှို ပ္လန်လှည့်ကေ့ဟှူ လူဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်တွပ် သောင်းဇာဟှိရဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","အယ်မျိုးမိန့်တော်မူဘီးန သခင်ဘုရားဟှာ နော့‑က်ထပ် လူ ၇၂ ပါးဟှို ဝီးကော့‑က်တော်မူဘီး၊ နှေ့ယော့‑က်စီတွဲဘီး ကိုယ်တော်ကိုယ်တိုင် သွားဟှို့ ဗြို့ဝါလေဟှို ရင်ဦးဆောင်း စေလွှတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ကိုယ်တော်ဟှာ သူးနို့ဟှို “ရိသီးဇာလေ ဘောင်ဂီးရှိဘေမဲ့ ရိသီးမားလေဟှာ နဲနဲဘဲ့ရှိဟှယ်။ ရိသီးမားလေ စေလွှတ်ပေးဟှို့တွပ် ဗားဇရှင်ဟှို ဆုတောန်းဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","သွားဂေ့! ဝံပုလွေအောက်ထဲဟှို သိုးသားဂန်းလေဟှို စေလွှတ်ဟှူမျိုး နန်းနို့ဟှို ငါစေလွှတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ကပ်အိ၊ လွယ်အိ၊ ခေနပ်လေဟှို ယူဂေ့န။ လမ်းမာရပ်ဘီး ဖယ်သူဟှိုလည်း နှောက်ဆစ်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","နန်းနို့ဟှာ အီတအီဟှို ဝမ်ဟှားဟှူခီတိုင်း ရင်ဦးဆောင်း ‘အယ်အီမာ ငြီသတ်ရှင်းရှိပါစေ’ ဆိုဘီး နှောက်ဆစ်ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","အယ်အီမာ ငြီသတ်ရှင်းဟှို ရှစ်မြတ်နိုးသူရှိမယ် ဆိုဟှာ နန်းနို့ နှောက်ဆစ်ဟှူ ငြီသတ်ရှင်းဟှာ အယ်လူထတ်မာ ကျန်ရစ်လေ့မယ်။ ငြီသတ်ရှင်းဟှို ရှစ်မြတ်နိုးသူ မှေ့ဟှ ဆိုဟှာ နန်းနို့ နှောက်ဆစ်ဟှူ ငြီသတ်ရှင်းဟှာ နန်းနို့နားဟှို ပ္လန်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","နန်းနို့ဟှာ အယ်အီမာနေဘီး သူးနို့ ကျွေးဇာလေဟှို စားသောက်ဂေ့။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လောက်လောက်ဟှူ သူဟှာ လောက်ခဟှို ရထိုက်ဟှယ်။ တအီဟှနေ တအီဟှို ပ္လောန်းဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","နန်းနို့ဟှို လတ်ခံဟှူ ဗြို့ဟှိုဝမ်ဘီး ကျွေးဇာလေဟှို စားဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","အယ်ဗြို့မာရှိဟှူ လူနာလေဟှို နာပျော့‑က်စေဘီး ‘ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှာ တည်ခါနီးနေဘီ’ ဆိုဘီး အယ်လူလေဟှို ပြောဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","အယ်ဘေမဲ့ နန်းနို့ဟှို လတ်ခံဘဲဟှူ ဗြို့ဖြစ်မယ် ဆိုဟှာ လမ်းထတ်ဟှနေ ");
INSERT INTO tvn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘နန်းနို့ဟှို ဒိပေးဟှူနေန နို့လေရဲ့ ခေဖွားမာ ကပ်နေဟှူ နန်းနို့ဗြို့ဟှ မ္လေမုလေဟှို နို့လေ ခါခ္လလိုက်ဟှယ်။ အယ်ဘေမဲ့ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှာ တည်ခါနီးနေဘီ ဆိုဇာဟှို အော့‑က်မေ့ဂေ့!’ ဆိုဘီး ပြောဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","တရားစီရင်ဟှူနေ့မာ ဘုရားသခင်ဟှာ အယ်ဗြို့ထတ် သောဒုံဗြို့ဟှိုဘဲ့ ပိုဘီး ကရုဏာတော် ပြလေ့မယ် ဆိုဇာဟှို ငါ ပြောဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“ခေါရဇိန်ဗြို့၊ နန်ဟှာ အမင်္ဂလာရှိဟှယ်! ဗက်ဇဲဒဗြို့၊ နန်ဟှာ အမင်္ဂလာရှိဟှယ်! နန်းနို့ဟှို ပြဟှားဟှူ နိမိတ်လတ်ခဏာလေဟှို တုရုဗြို့န ဇိဒုန်ဗြို့မာ ပြဟှားမယ် ဆိုဟှာ အယ်ဗြို့လေဟှ လူလေဟှာ လျှော်တေဟှို ဝတ်ဘီး ပ္လာထဲမာ ထိုင်ဘီး နောန်ဒရဂေ့လေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","တရားစီရင်ဟှူနေ့မာ ဘုရားသခင်ဟှာ နန်းနို့ထတ် တုရုဗြို့န ဇိဒုန်ဗြို့လေဟှိုဘဲ့ ပိုဘီး ကရုဏာပြလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ကပေရနောင်ဗြို့၊ နန်ဟှာ အမင်္ဂလာရှိဟှယ်! နန့်ဟှာ ကောန်းဂန်ထိ ချီးမြှော‑က်ရှင်းဟှို ခံရဘေမဲ့လည်း မရဏာနိုင်ငံဟှိုဘဲ့ ခ္လရှင်းဟှို ခံရလေ့မယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ယေရှုဟှာ တဗဲ့တော်လေဟှို “ဖယ်သူဘဲ့ဖြစ်ဖြစ် နန်းနို့စကားဟှို နားထောန်ဟှူသူဟှာ ငါ့စကားဟှို နားထောန်ဟှူသူ ဖြစ်ဟှယ်။ ဖယ်သူဘဲ့ဖြစ်ဖြစ် နန်းနို့ဟှို ငြင်းပယ်ဟှူ သူဟှာ ငါ့ဟှို ငြင်းပယ်ဟှူသူ ဖြစ်ဟှယ်။ ဖယ်သူဘဲ့ဖြစ်ဖြစ် ငါ့ဟှို ငြင်းပယ်ဟှူ လူဟှာ ငါ့ဟှို စေလွှတ်လိုက်ဟှူ လူဟှိုလည်း ငြင်းပယ်ဟှူလူ ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","တဗဲ့တော် ၇၂ ပါးဟှာ ရရာတိုင်း ဝန်းသာဘီး ပ္လန်ရော့‑က်လာဂေ့ဘီး “သခင်၊ ကျွန်တော့်ဟှားလေဟှာ ကိုယ်တော်ရဲ့ နာမန နတ်ဆိုးလေဟှို နှန်ထုလိုက်ဟှူ ခီမာ သူးနို့လေဟှာ နားထောန်ဘီးဟှာ ထွပ်ဟှားဂေ့ဟှယ်!” ဆိုဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ယေရှုဟှာ “စာတန်ဟှာ ကောန်းဂန်ဟှနေ လျှပ်စစ်ဖြန့်မျိုး က္လလာဇာဟှို ငါဗြင်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","နားထောန်ဂေ့! နန်းနို့ဟှာ ဗွီလေန ကန်းမီးဂေါ့‑က်လေ ထတ်မာ လမ်းရှော့‑က်နိုင်ဘီး ရန်သူရဲ့တဂိုး အာဏာလေ ဂူလောင်းဟှို နိုင်ရဟှူ ခွမ့်အာဏာလေဟှို ငါပေးဟှားပီးဘီ ဖြစ်ဟှူကြောန့် ဖယ်ဘေးလည်း နန်းနို့ဟှို ညှဉ်းဆဲလေ့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","အယ်ဘေမဲ့ နန်းနို့ဟှာ နတ်ဆိုးလေဟှို နှန်ထုနိုင်ဟှူကြောန့် ဝန်းသာဂေ့န။ နန်းနို့ရဲ့ နာမယ်ဟှာ ကောန်းဂန်စာရင်းမာ ရေးဟှားပီးဘီ ဖြစ်ဟှူကြောန့် ဝန်းသာဂေ့” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","အယ်ခီမာ ယေရှုဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်အားဖြင့် ရရာတိုင်း ဝန်းသာနေဘီး “ကောန်းဂန်ဘောင်န မ္လေဂီးရဲ့သခင် ဖြစ်တော်မူဟှူဖ! ကိုယ်တော်ဟှာ ပညာရှိလေန ဉာဏ်ကောန်းဟှူ သူလေတွပ် ဝှပ်ဟှားဟှူ ဇာလေဟှို ပညာတတ်ဘဲဟှူ သူလေဟှိုဘဲ့ ဖွမ့်ပြပေးဟှူကြောန့် ကိုယ်တော့်ဟှို ကျေးဇူးတန်ဟှယ်။ မှန်ပါဟှယ် ဖ၊ အယ်မူဇာဟှာ ရှေ့တော်မာ နှစ်သက်ဖွယ် ဖြစ်ပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“နို့ဖဟှာ ရှိမျှဂူလောင်း ငါ့ဟှို ပေးဟှားပီးဘီ။ အယ်သားဟှာ ဖယ်သူဖြစ်ဟှယ် ဆိုဇာဟှို ဖဟှလွဲဘီး ဖယ်သူလည်း သိဂေ့ဟှ။ ဖဟှာ ဖယ်သူ ဖြစ်ဟှယ် ဆိုဇာဟှိုလည်း အယ်သားန အယ်သားတော်ဟှ ဖွမ့်ပြဟှို့တွပ် ဝီးကော့‑က်ဟှားဟှူ သူလေမှတပါး ဖယ်သူလည်း သိဂေ့ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","အယ်ဘီးန ယေရှုဟှာ တဗဲ့တော်လေဖတ်ဟှို လှည့်ဘီးန သူးနို့ဟှို “နန်းနို့ ခုဗြင်နေရဟှူ ဇာလေဟှို ဗြင်ရဟှူကြောန့် နန်းနို့မျစ်စိဟှာ မင်္ဂလာရှိဂေ့ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","နန်းနို့ဟှို ငါပြောမယ်။ နန်းနို့ ဗြင်ရဟှူ ဇာလေဟှို ပရောဖက်လေန မန်းဂီးလေဟှာ ဗြင်ရှင်ဘေမဲ့လည်း သူးနို့ဟှာ ဗြင်ရဂေ့ဟှ။ နန်းနို့ ကြားရဟှူ ဇာလေဟှိုလည်း သူးနို့ ကြားရဂေ့ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ကျမ်းတတ်ဆရာ တယော့‑က်ဟှာ ထလာဘီးဟှာ ယေရှုဟှို “ဆရာ၊ ထာဝရသတ် ရရှိဟှို့တွပ် ဖြားလောက်ရမယ်နူး။” ဆိုဘီး ပညာစမ်းရှင်ဟှူကြောန့် မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ယေရှုဟှာ “ပညတ်တော်မာ ဖြားဇာလေ ပြောဟှားနူး။ နန်းနို့ ဖယ်မျိုးဖတ်ဟှားနူး။” ဆိုဘီး သူ့ဟှို မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","အယ်လူဟှ “‘နန့်ရဲ့သခင်၊ ဘုရားသခင်ဟှို စိနှလောင်းကြွင်းမဲ့၊ ဉာဏ်စွမ်းကြွင်းမဲ့၊ ကိုယ်စွမ်းရှိမျှန ရှစ်ပါ။ အယ်ဘီးဟှာ နန့်ရဲ့ အီဇနီးရှင်းဟှို နန့်ကိုယ်နန် ရှစ်မျိုးဘဲ့ရှစ်ပါ’ ” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ယေရှုဟှ “နန်ဖြေဇာဟှာ မှန်ဟှယ်။ အယ်မျိုးလောက်မယ် ဆိုဟှာ နန်ဟှာ သတ်ရှင်ရလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","အယ်ဘေမဲ့ အယ်ကျမ်းတတ်ဆရာဟှာ ဖြောန့်မတ်ကြောန်းပြရှင်ဟှူကြောန့် ယေရှုဟှို “ကျွန်တော့်ရဲ့ အီဇနီးရှင်းဟှ ဖယ်သူနူး။” ဆိုဘီး သူဟှ မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ယေရှုဟှ “လူတယော့‑က်ဟှာ ယေရုရှလင်ဗြို့ဟှနေ ယေရိခေါဗြို့ဟှို ဆင်းလာဟှူ ခီမာ မ္လတိုက်ခံရလေဟှယ်။ မ္လလေဟှာ သူ့ရဲ့ အန်းဂီးလေဟှို ခလွတ်ဘီး၊ ရိုက်သတ်ဘီးဟှာ သေခါနီးနီး ဖြစ်နေဟှူ ခီမာ ပစ်ဟှားဘီး ထွပ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","အယ်မျိုးဖြစ်ဘီးန ယဇ်ပုရောဟိတ် တပါးဟှာ အယ်လမ်းတိုင်း ရော့‑က်လာဟှူ ခီမာ အယ်လူဟှို ဗြင်ဘေမဲ့လည်း ရှောန်ဘီးဟှာ သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","အယ်မျိုးဘဲ့ လေဝိတယော့‑က်လည်း ရော့‑က်လာဘီး အယ်လူဟှို ကေ့ဘီးန ရှောန်ဘီးဟှာ သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","အယ်ဘေမဲ့ ရှမာရိလူမျိုး တယော့‑က်ဟှာ ခရီးသွားရင်းန အယ်လူရှိဟှူ နေရာဟှို ရော့‑က်လာဟှယ်။ သူဟှာ အယ်လူဟှို ဗြင်လိုက်ဟှူ ခီမာ သနားစိလေ ဖြစ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","သူဟှာ အယ်လူနားဟှို သွားဘီး အယ်လူရဲ့ ဒန်ရာလေထတ်ဟှို ဆီနဝိုင်ဟှို လောန်းထဲဘီးဟှာ ဝတ်န စဲပေးလေဟှယ်။ အယ်ဘီးန သူ့ရဲ့ မြည်းထတ်ဟှို တန်ဘီးန လူနာဟှို ပြုစုပေးဟှို့တွပ် တည်းခိုခန်းဟှို ခေါ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","နတ်ကီးတိုင်မာ သူဟှာ ဇရှင်ဟှို ငွေဒန်းဂါးနှေ့ပ္လား ပေးဘီး ‘အယ်လူဟှို ကေ့ရှုပြုစုပေးပါ။ နော့‑က်ထပ် ကူက္လဇာလေဟှို ငါပ္လန်လာဟှူ ခီမာ ပေးမယ်’ ” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ယေရှုဟှာ “အယ်လူလေ သောင်းယော့‑က်ထဲမာ ဖယ်သူဟှာ မ္လတိုက်ခံရသူန အီဇနီးရှင်းဖြစ်ဟှယ် ဆိုဘီး နန်ထန်နူး။” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ကျမ်းတတ်ဆရာဟှ “လူနာဟှို သနားဟှူလူ ဖြစ်ဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ယေရှုဟှ “အယ်ဆိုဟှာ နန်သွားဘီး အယ်မျိုးလောက်ပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ယေရှုန တဗဲ့တော်လေဟှာ ခရီးသွားနေဒူးမာ ဝါတဝါဟှို ဝမ်ဂေ့လေဟှယ်။ အယ်ဝါမာ မာသနာမယ်ရှိဟှူ မီးမဟှာ သူ့အီမာ ကိုယ်တော့်ဟှို ဧည့်ခံလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","မာသမာလည်း မာရိနာမယ်ရှိဟှူ ညီမတယော့‑က်ရှိဟှယ်။ အယ်ညီမဟှာ သခင်ဘုရားရဲ့ ခေတော်ရင်းမာ ထိုင်ဘီးန ကိုယ်တော်ရဲ့ စကားတော်ဟှို နားထောန်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","မာသဟှာ ဧည့်ဝတ်ပြုရှင်းမှုလေကြောန့် စိပူပန်ဘီး ကိုယ်တော့်ဟှို “သခင်၊ ကျွန်မဟှာ ဧည့်ဝတ်ပြုရှင်းလောက်ဟှို လောက်နေရဟှူ ခီမာ ကျွန်မညီမဟှ ကိုယ်တော်ရဲ့ ခေတော်ရင်းမာ လာထိုင်နေဇာဟှာ မျှတမှုရှိဘဲ့လော။ ကျွန်မဟှို ကူညီပေးဟှို့ သူဟှို ပြောပေးအူး!” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","သခင်ဘုရားဟှ “မာသ၊ မာသ! နန်ဟှာ အယ်မူကိစလေတွပ်ဘဲ့ စိုးရိမ်ပူပန်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","အယ်ဘေမဲ့ နန့်မာ လိုအပ်နေဟှူဇာ တခုဘဲ့ရှိဟှယ်။ မာရိဟှာ ပိုကောန်းဟှူဇာဟှို ဝီးကော့‑က်ဟှားပီးဘီ။ အယ်မူဇာဟှို သူ့နားဟှနေ ဖယ်သူလည်း ယူရဟှို့ မှုဟှ” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","တနေ့ ယေရှုဟှာ တနေရာမာ ဆုတောန်းနေဟှယ်။ ကိုယ်တော်ဟှာ ဆုတောန်းပီးဟှားဟှူ ခီမာ တဗဲ့တော်လေထဲဟှ တယော့‑က်ဟှ “သခင်၊ ယောဟန်ဟှာ သူ့တဗဲ့လေဟှို ဆုတောန်းနည်းသန်ပေးမျိုး ကျွန်တော့်ဟှားလေဟှိုလည်း သန်ပေးတော်မူပါ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ယေရှုဟှ “နန်းနို့လေ ဆုတောန်းဟှူ ခီမာ “ ‘ကောန်းဂန်ဘောင်မာ ရှိတော်မူဟှူဖ၊ ကိုယ်တော်ရဲ့ နာမတော်ဟှို ရိုသေလေးမြတ်ရှင်း ရှိပါစေ။ နိုင်ငံတော် တည်ထောန်ပါစေ။ ");
INSERT INTO tvn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ကျွန်တော့်ဟှားလေတွပ် လိုအပ်ဟှူ စားဇာဟှို နေ့စဉ်နေ့တိုင်း ပေးသနားတော်မူပါ။ ");
INSERT INTO tvn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ကျွန်တော့်ဟှားလေဟှို ပြစ်မှားဟှူ သူလေရဲ့ ပြစ်လေဟှို ကျွန်တော်ဟှားလေ ခွမ့်လွှတ်ပေးဟှူမျိုးဘဲ့ ကျွန်တော့်ဟှားလေရဲ့ ပြစ်လေဟှိုလည်း ခွမ့်လွှတ်ပေးပါ။ ပြစ်သွီးဆောန်ဟှူ နော့‑က်ဟှို လိုက်ပါသွားစေဘဲန၊ ကောန်းဘဲဟှူ ဇာလေဟှလည်း ကယ်နှုပေးပါ’ ” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","အယ်ဘီးန ယေရှုဟှာ “နန်းနို့ထဲဟှ ယော့‑က်ယော့‑က်ဟှာ ညဉ့်နတ်ဟှူ ခီမာ အယ်မိဆွေရဲ့ အီဟှိုသွားဘီး ‘မိဆွေ၊ ကျွန်တော့်ဟှို မုသောင်းလောင်းချေးပါ။ ");
INSERT INTO tvn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ကျွန်တော့်မိဆွေ တယော့‑က်ဟှာ ခရီးဟှနေပ္လန်လာဘီး ကျွန်တော့်အီဟှို ရော့‑က်လာဟှယ်။ သူ့ဟှို ကျွေးဟှို့ ဖြားလည်းမှေ့ဘဲဖြစ်နေဟှယ်!’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","နန့်မိဆွေဟှာ အီထဲဟှနေ ‘ငါ့ဟှို နှော့‑က်ယှစ်န! ခွဗော့‑က်လည်းပိဟှားပီးဘီ။ ငါ့သားမီးလေန ငါလည်း အိယာဝမ်နေဘီ။ ငါထဘီး နန့်ဟှို ဖြားဇာလည်း ပေးနိုင်ဟှ’ ဆိုဘီး ပ္လန်ပြောလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","နန်းနို့ဟှို ငါပြောမယ်၊ အယ်လူဟှာ သူ့မိဆွေ ဖြစ်ဟှယ် ဆိုဇာဟှို ထော့‑က်ဘီး ဖြားဇာဟှိုမျှ ထဘီး ပေးဘဲနေဘေမဲ့လည်း အားလျော့ဘဲန တောန်းနေဟှူကြောန့် ထဘီး လိုရှင်ဇာလေ ဂူလောင်းဟှို ပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","အယ်ကြောန့် နန်းနို့ဟှို ငါပြောမယ်။ တောန်းဂေ့။ တောန်းမယ် ဆိုဟှာ ရဂေ့လေ့မယ်။ ရှာဂေ့။ ရှာမယ် ဆိုဟှာ တွိဂေ့လေ့မယ်။ ခွဗော့‑က်ဟှို ခေါ့‑က်ဂေ့။ ခေါ့‑က်မယ် ဆိုဟှာ ဖွမ့်ပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","တောန်းဟှူသူဟှာ ရလေဟှယ်။ ရှာဟှူသူဟှာ တွိလေဟှယ်။ ခွဗော့‑က်ဟှို ခေါ့‑က်ဟှူသူဟှာ ခွဗော့‑က်ဟှို ဖွမ့်ပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","နန်းနို့မာ ဖယ်မျိုးဖဟှာ သားမီးလေဟှ ငါးဟှို တောန်းဟှူ ခီမာ ငါးဟှို ပေးဘဲန ဗွီဟှို ပေးဟှို့လော။ ");
INSERT INTO tvn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ကြစ်ဥဟှို တောန်းဟှူ ခီမာ ကန်းမီးဂေါ့‑က်ဟှို ပေးဟှို့လော။ ");
INSERT INTO tvn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","နန်းနို့ဟှာ ကောန်းဘဲဟှူသူလေ ဖြစ်ဘေမဲ့လည်း နန်းနို့ရဲ့ သားမီးလေဟှို ကောန်းဟှူဇာလေဟှိုဘဲ့ ပေးဟှယ် ဆိုဟှာ ကောန်းဂန်ဘောင်မာ ရှိတော်မူဟှူ နန်းနို့ဖဟှာ တောင်းဟှူလူလေဟှို သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို ပိုဘီး ပေးတော်မူလေ့မယ်!” ဆိုဘီး တဗဲ့တော်လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ယေရှုဟှာ အ,နေဟှူ နတ်ဆိုးဟှို နှန်ထုလေဟှယ်။ နတ်ဆိုးထွပ်ဟှားဘီးန အ,နေဟှူသူဟှာ စကားပြောလာဟှူကြောန့် လူအောက်ဂီးဟှာ ရရာတိုင်း အံ့သြဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","အယ်ဘေမဲ့ လူတချို့ဟှ “ကိုယ်တော်ဟှာ နတ်ဆိုးမန်း ဗေလဇေဗုလဟှ ပေးဟှားဟှူတဂိုးန နတ်ဆိုးလေဟှို နန်ထုဂေ့ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","တချို့ဟှ ယေရှုဟှို စမ်းသပ်ရှင်ဂေ့ဟှူကြောန့် ကောန်းဂန်ဘောင်ဟှ နိမိတ်လတ်ခဏာတခုဟှို ပြကေ့ ဆိုဘီး တောန်းဆိုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","အယ်ဘေမဲ့ ယေရှုဟှာ သူးနို့လေရဲ့ ကြံစည်ဟှို သိနေဟှူကြောန့် “နိုင်ငံတနိုင်ငံမာ လူလေကွဲပြားဘီး ရှင်းရှင်းတိုက်ခိုက်နေမယ် ဆိုဟှာ အယ်နိုင်ငံဟှာ ကြာခန်မာ ပျစ်စီးဟှားလေ့မယ်။ အီထောန်တခုမာ အီသူအီသားလေ ကွဲပြားဘီး ရှင်းရှင်းတိုက်ခိုက်နေမယ် ဆိုဟှာ အယ်အီထောန်ဟှာ ပျစ်စီးဟှားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","အယ်ကြောန့် စာတန်ရဲ့ နိုင်ငံဟှာ ကွဲပြားမယ် ဆိုဟှာ ဖယ်မျိုး ရပ်တည်နိုင်မယ်နူး။ ငါဟှာ ဗေလဇေဗုလ ပေးဟှားဟှူတဂိုးန နတ်ဆိုးလေဟှို နှန်ထုဟှယ် ဆိုဘီး နန်းနို့ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ငါဟှာ ဗေလဇေဗုလ ပေးဟှားဟှူတဂိုးန နတ်ဆိုးလေဟှို နှန်ထုဟှယ် ဆိုဟှာ နန်းနို့ရဲ့ တဗဲ့လေဟှာ ဖယ်သူပေးဟှားဟှူ တဂိုးန နှန်ထုဂေ့နူး။ နန်းနို့ရဲ့ တဗဲ့လေဟှာ နန်းနို့ရဲ့ တရားသူဂီးလေ ဖြစ်ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ငါဟှာ ဘုရားသခင်ရဲ့ တဂိုးတော်အားဖြင့် နတ်ဆိုးလေဟှို နှန်ထုဟှယ်။ အယ်ကြောန့် ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှာ နန်းနို့ထဲမာ တည်ထောန်နေဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“ခွန်အားကီးဟှူလူဟှ လတ်နတ်စောင်န သူ့အီဝမ်းဟှို စောန့်နေဟှူ ခီမာ သူ့အောက်စာလေဟှာ လောင်ခြောင်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","အယ်ဘေမဲ့ အယ်သူထတ် ခွန်အားကီးဟှူလူဟှ ရော့‑က်လာဘီး သူ့ဟှို တိုက်ခိုက်အောန်မြင်ဟှားဟှူ ခီမာ သူအားကိုးဟှူ လတ်နတ်စောင်လေဟှို သီးယူဘီး ရရှိဟှားဟှူ ပစ်စီးလေဟှို ခွဲတမ်းခ္လလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“ငါ့ဖတ်မာ နေဘဲဟှူသူဟှာ ငါ့ရန်ဖတ်ဖြစ်ဟှယ်။ ငါ့နတူးဒူ စုသီးဘဲဟှူသူဟှာ ကြဲဖြန့်နေဟှူသူ ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ညစ်ညူးဟှူ နတ်ဟှာ လူထဲဟှ ထွပ်ဟှားဘီး ခြော့‑က်ကပ်ဟှူ နေရာမာ ခိုနားရာဟှို ရှာလေဟှယ်။ တွိဟှ ဆိုဟှာ ‘ငါဟှာ နေရာဟောန်းဟှိုဘဲ့ ပ္လန်မယ်’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","နေရာဟောန်းဟှို ပ္လန်ရော့‑က်ဟှူ ခီမာ သန့်ရှင်းအောန် ခါဟှားဇာဟှို တွိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","သူ့ထတ်ပိုဆိုးဟှူ ညစ်ညူးဟှူနတ် ခွန်နစ်ကောန်ဟှို ခေါ်လာဘီးဟှာ အယ်နေရာဟောန်းမာဘဲ့ နေလေဟှယ်။ အယ်ကြောန့် အယ်လူရဲ့ နော့‑က်ဖြစ်ဟှူ ဇာဟှာ ရှေ့ဖြစ်ဟှူ ဇာထတ် ပိုဘီး ဆိုးဝါးလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ယေရှုဟှာ အယ်မျိုးပြောလိုက်ဟှူ ခီမာ လူအောက်ဂီးထဲဟှ မီးမတယော့‑က်ဟှာ ကိုယ်တော့်ဟှို “ကိုယ်တော့်ဟှို မွီးဘီး နို့တိုက်ဟှူ မီးမဟှာ မင်္ဂလာရှိဟှယ်!” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","အယ်ဘေမဲ့ ယေရှုဟှ “ဘုရားသခင်ရဲ့ စကားတော်ဟှို ကြားဘီး နားထောန်ဟှူလူဟှာ မင်္ဂလာရှိဟှယ်!” ဆိုဘီး ပ္လန်မိန့်တော်မူလိုက်ဇာဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","လူအောက်ဂီးဟှာ ယေရှုနားမာ ဝိုင်းအောင်နေဟှူကြောန့် ကိုယ်တော် မိန့်တော်မူလိုက်ဇာဟှ “ခုခေတ် လူလေဟှာ ရရာတိုင်း ဆိုးညစ်ဂေ့ဟှယ်! သူးနို့ဟှာ နိမိတ်လတ်ခဏာဟှို တောန်းဘေမဲ့ ယောနရဲ့ နိမိတ်လတ်ခဏာမှတပါး ဖယ်နိမိတ်လတ်ခဏာလည်း သူးနို့ဟှို ပြလေ့မယ် မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","နိနဝေဗြို့သားလေတွပ် ယောနဟှာ နိမိတ်လတ်ခဏာဖြစ်ဟှူ မျိုးဘဲ့ အယ်ခေတ် လူလေတွပ် လူ့ရဲ့သားဟှာလည်း နိမိတ်လတ်ခဏာ ဖြစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ရှေဘပြည်ဟှ မိဖုရားဟှာ ရှောလမုန် မန်းဂီးရဲ့ စကားဟှို နားထောန်ဟှို့ ဆိုဘီး ဟှိုးဝီးဂီးမာရှိနေဟှူ တိုင်းပြည်ဟှနေ လာဟှယ်။ အယ်နေရာမာ ရှောလမုန်ထတ် ကီးမြတ်ဟှူလူ ရော့‑က်ရှိနေဘီ။ တရားစီရင်တော်မူဟှူ နေ့မာ ရှေဘပြည်ဟှ မိဖုရားဟှာ ထရပ်ဘီး အယ်မူလူလေဟှို ပြစ်တန်စွပ်စွဲလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","တရားစီရင်ဟှူ နေ့မာ နိနဝေဗြို့သားလေဟှာ ထရပ်ဘီး နန်းနို့ဟှို စွပ်စွဲလေ့မယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ယောနဟောပြောဟှူ တရားဟှို ကြားရဟှူ ခီမာ သူးနို့ဟှာ နောန်ဒရဟှားကြောန့် ဖြစ်ဟှယ်။ အယ်နေရာမာ ယောနထတ် ရရာတိုင်း ကီးမြတ်ဟှူသူ ရှိဟှယ် ဆိုဇာ နန်းနို့ဟှို ငါပြောဟှယ်!” ");
INSERT INTO tvn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“ဖယ်လူလည်း ဆီမီးအီဟှို ဖောင်းကွယ်ဘီး ထွန်းဂေ့ဟှ။ ဆီမီးအီဟှို တောန်းအော့‑က်မာ ထားဘီး လည်း ထွန်းဂေ့ဟှ။ အီထဲဟှို ဝမ်လာဟှူ လူလေဟှာ လန်းရောန်ရဟှို့တွပ် ဆီမီးခေါင်ထတ်မာ တန်ဘီး ထွန်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","မျစ်စိဟှာ ကိုယ်ခန္ဓာတွပ် ဆီမီးအီန တူဟှယ်။ မျစ်စိကောန်းဟှယ် ဆိုဟှာ နန်းနို့ရဲ့ ကိုယ်ခန္ဓာ တခုလောင်း လန်းဟှားဘီး မျစ်စိကောန်းဂေ့ဟှ ဆိုဟှာ နန်းနို့ရဲ့ ကိုယ်ခန္ဓာ တခုလောင်း မိုက်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","အယ်ကြောန့် နန်းနို့ရဲ့ လန်းရောန်ဟှို မိုက်ဖြစ်ဘဲအောန် ဒိပြုဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","နန့်ရဲ့ ကိုယ်ခန္ဓာ တခုလောင်းဟှာ လောင်းဝ မှောန်ဘဲန လန်းနေမယ် ဆိုဟှာ ဆီမီးအီရဲ့ တော့‑က်ပဟှူ လန်းဟှာ နန့်ထတ်မာ ထွန်းလန်းမျိုး နန့်ရဲ့ ကိုယ်ခန္ဓာ တခုလောင်းလည်း လန်းရောန်န တော့‑က်ပနေလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ယေရှုဟှာ အယ်မျိုးမိန့်တော်မူဘီးန ဖာရိရှဲတယော့‑က်ဟှာ ကိုယ်တော့်ဟှို သူ့နတူးဒူ စားသော့‑က်ဟှို့ တောန်းလျှော့‑က်ဟှူကြောန့် သူ့ရဲ့ အီထဲဟှို ဝမ်ဘီးန ဗွဲမာ ထိုင်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ယေရှုဟှာ လတ်ဆေးဘဲ့န စာစားနေဇာဟှို ဖာရိရှဲ ဗြင်ဟှားဟှူ ခီမာ အံ့ဩဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","သခင်ဘုရားဟှ သူ့ဟှို “နန်းနို့ ဖာရိရှဲလေဟှာ စံဟန်းဇားလေရဲ့ ပ္လန်ဖတ်ဟှို စင်ကြယ်အောန် ဆေးဂေ့ဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ရဲ့ စိထဲမာ ကြမ်းဖတ်ရှင်း၊ ဆိုးညစ်ရှင်းလေန ပ္လဲ့နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","လူမိုက်လေ! ပ္လန်ဖတ်ဟှို ဖန်ဆင်းဟှူ ဘုရားဟှာ တွမ်းဖတ်ဟှိုလည်း ဖန်ဆင်းဟှယ် ဆိုဇာဟှို သိဂေ့ဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","အယ်ဘေမဲ့ နန်းနို့ရဲ့ ခွပ်လေ၊ စံလေထဲမာ ရှိဟှူဇာလေဟှို ဆင်းရဲသားလေဟှို ပေးကမ်းဂေ့ပါ။ အယ်မျိုးလောက်မယ် ဆိုဟှာ ဂူလောင်းဟှာ နန်းနို့တွပ် စင်ကြယ်ဟှားလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ဖာရိရှဲလေ၊ နန်းနို့ဟှာ အမင်္ဂလာရှိဟှယ်! နန်းနို့ဟှာ ပန်ဇီး၊ စမူစဗားန တခြားဆေးဖပ်ဝမ်ဟှူ ဝပ်ဘောန်းဇောင်ဟှို ဆယ်ဖို့တဖို့ ပေးလှူဂေ့ဟှယ်။ အယ်ဘေမဲ့ တရားမျှတမှုန ဘုရားသခင်ရဲ့ ရှစ်မြစ်တာလေဟှို လျစ်လူရှုဟှားဂေ့ဟှယ်။ နန်းနို့ဟှာ ဆယ်ဖို့တဖို့ဟှို ပေးလှူဟှူ ခီမာ တရားမျှတမှုန ဘုရားသခင်ရဲ့ ရှစ်မြစ်တာဟှို ချန်ဟှားဂေ့ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ဖာရိရှဲလေ၊ နန်းနို့ဟှာ အမင်္ဂလာ ရှိဂေ့ဟှယ်! နန်းနို့ဟှာ ဝါလယ်ဇရပ်မာ ဆိုလည်း မြင့်မြတ်ဟှူ နေရာလေဟှိုရော၊ ဆေးမာ ဆိုလည်း လူလေရဲ့ ရိုးရိုသေးသေ နှော့‑က်ဆစ်ရှင်းလေဟှိုရော နှစ်သက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","နန်းနို့လေဟှာ အမင်္ဂလာရှိဂေ့ဟှယ်! နန်းနို့ဟှာ မှတ်သားမှေ့ဘဲဟှူ သန်းခ္လိုင်းဒွမ်းန တူဂေ့ဟှယ်။ အယ်တွမ်းလေထတ်မာ သွားနေဟှူ လူလေဟှ သန်းခ္လိုင်းဒွမ်းဖြစ်မှန်း သိဂေ့ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ကျမ်းတတ်ဆရာ တယော့‑က်ဟှာ ကိုယ်တော့်ဟှို “ဆရာ၊ အယ်မျိုးပြောဇာဟှာ ကျွန်တော့်ဟှားလေဟှိုလည်း စော်ဂါးရာရော့‑က်ပါဟှယ်!” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ယေရှုဟှ “ကျမ်းတတ်ဆရာလေ၊ နန်းနို့ လည်းဘဲ့ အမင်္ဂလာ ရှိဂေ့ဟှယ်! နန်းနို့ဟှာ ထမ်းဟှို့ခတ်ဟှူ ဝန်ထောက်လေဟှို လူလေဟှို ထမ်းခိုင်းဂေ့ဟှယ်။ နန်းနို့ကိုယ်တိုင်ဟှ အယ်မူဝန်ထောက်လေဟှို လတ်ဖျားန ထိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","နန်းနို့ဟှာ အမင်္ဂလာ ရှိဟှယ်! နန်းနို့ရဲ့ ဘိုးဘေးလေ သတ်ဟှားဟှူ ပရောဖက်လေတွပ် နန်းနို့ဟှ သန်းခ္လိုင်းလေဟှို ဆော့‑က်ပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","အယ်ကြောန့် နန်းနို့ရဲ့ ဘိုးဘေးလေ ကျူးလွန်ဟှားဟှူ မှုလေတွပ် နန်းနို့ဟှာ သတ်သေလေ ဖြစ်ဂေ့ဟှယ်။ သူးနို့လေဟှာ ပရောဖက်လေဟှို သတ်ဘီး နန်းနို့ဟှ သန်းခ္လိုင်းလေဟှို ဆော့‑က်ပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","အယ်ကြောန့် ဘုရားသခင်ရဲ့ ရွှေဉာဏ်တော်န ‘အယ်လူလေထဲဟှို ပရောဖက်လေ၊ စေတမန်လေဟှို ငါစေလွှတ်မယ်။ သူးနို့လေဟှာ အယ်ပရောဖက်လေ၊ စေတမန်လေထဲဟှ တချို့ဟှို ညှဉ်းဆဲဘီး တချို့ဟှို သတ်ဂေ့လေ့မယ်’ ဆိုဘီး မိန့်တော်မူဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","အယ်ကြောန့် ကမ္ဘာတည်ခီဟှနေစဘီး သတ်ခံရဟှူ ပရောဖက်လေရဲ့ သွီးကြောန့် အယ်ခေတ်လူလေဟှာ ပြစ်ဒန်စီရင်ရှင်းဟှို ခံရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","အာဗေလရဲ့ သွီးဟှနေ ယဇ်ပလ္လင်န ဗိမာန်တော်ကြားမာ သတ်ခံရဂေ့ဟှူ ဇာခရိရဲ့ သွီးထိ ဖြစ်ဟှယ်။ အယ်မူဇာလေ ဂူလောင်းတွပ် အယ်ခေတ်လူလေဟှာ ပြစ်ဒန်စီရင်ရှင်းဟှို ခံရလေ့မယ် ဆိုဇာဟှို ငါမှန်တိုင်း ပြောဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ကျမ်းတတ်ဆရာလေ၊ နန်းနို့ဟှာ အမင်္ဂလာရှိဂေ့ဟှယ်! နန်းနို့ဟှာ သိပညာဗိမာန် ခွဗေါ့‑က်သော့ဟှို သီးဟှားဘီး နန်းနို့ကိုယ်တိုင်လည်း ဝမ်ဂေ့ဟှ။ ဝမ်ဟှို့သူလေဟှိုလည်း တားဆီးဂေ့ဟှယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","အယ်နေရာဟှနေ ယေရှုထွပ်ဟှားဟှူ ခီမာ ကျမ်းတတ်ဆရာန ဖာရိရှဲလေဟှာ ကိုယ်တော့်ဟှို စဘီးဟှာ ပြင်းပြင်းထန်ထန် ဝေဖန်ဂေ့ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","စကားတော်ထဲမာ မှားရှာဟှို့တွပ် မေးခွန်းလေ ဘောင်ဂီးမေးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ထောန်ဗောန်းဘောင်ဂီးရှိဟှူ လူလေဟှာ စုဝီးလာဟှူ ခီမာ သူးနို့ရှင်းရှင်း နန်းမိဂေ့ဟှူကြောန့် ယေရှုဟှာ တဗဲ့တော်လေဟှို “ဖာရိရှဲလေရဲ့ ဟန်ဆောန်မှုနတူဟှူ တဆေးဟှို ဒိပြုဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ဖောင်းဟှားဟှူ ဇာလေ ဂူလောင်းဟှာ ပွမ့်လာရလေ့မယ်။ ဝှပ်ဟှားဟှူ ဇာလေ ဂူလောင်းဟှာလည်း ပေါ်လာရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","အယ်ကြောန့် မှောန်ထဲမာ နန်းနို့ပြောဟှူ စကားလေဟှို လန်းရောန်ထဲမာ ကြားသိလေ့မယ်။ အီခန်းထဲမာ နန်းနို့ တိုးတိုးပြောနေဟှူ စကားလေဟှို အီးခေါန်မိုးထတ်ဟှနေဘီး ကြေညာဂေ့လေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“ငါ့မိဆွေလေ၊ နန်းနို့ဟှို ငါပြောမယ်။ ကိုယ်ခန္ဓာဟှိုဘဲ့ သတ်နိုင်ဘီးဟှာ နော့‑က်ထပ် ဖြားလည်းလောက်နိုင်ဘဲဟှူ သူလေဟှို ကြော့‑က်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","နန်းနို့ကြော့‑က်ရဟှို့ သူဟှို ငါပြမယ်။ ကိုယ်ခန္ဓာဟှို သတ်ဘီးန နန်းနို့ဟှို ငရဲထဲခ္လနိုင်ဟှူ ခွမ့်အာဏာရှိဟှူ ဘုရားသခင်ဟှို ကြော့‑က်ဂေ့။ နန်းနို့ဟှို ငါထပ်ပြောမယ်။ ဘုရားသခင်ဟှို ကြော့‑က်ဂေ့! ");
INSERT INTO tvn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“အီးဇာဟှား ငါးကောန်ဟှို ကပ်နှေ့ပ္လားန ရောန်းဂေ့ဟှယ် မှုဟှလော။ အယ်ဘေမဲ့ ဘုရားသခင်ဟှာ အယ်မူအီးဇာဟှားလေ တကောန်ဟှိုမျှ မေ့တော်မူဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","နန်းနို့ ခေါန်းဟှ ဆားဗန်လေ ဂူလောင်းဟှို ရေတွပ်ဟှားဟှယ်။ အယ်ကြောန့် ကြော့‑က်ဂေ့န။ နန်းနို့ဟှာ အီးဇာဟှားလေထတ် ရရာတိုင်း ဖိုးကီးဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“နန်းနို့ဟှို ငါပြောမယ်။ ဖယ်သူဘဲ့ဖြစ်ဖြစ် လူလေရှေ့မာ ငါ့ဟှို ဝန်ခံမယ် ဆိုဟှာ လူ့ရဲ့သားဟှလည်း ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်လေရှေ့မာ အယ်သူဟှို ဝန်ခံလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","အယ်ဘေမဲ့ လူလေရှေ့မာ ငါ့ဟှို ငြင်းပယ်မယ် ဆိုဟှာ လူ့ရဲ့သားဟှလည်း ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်လေရှေ့မာ ငြင်းပယ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“လူ့ရဲ့သားဟှို နှောက်န စော်ဂါးဟှူ သူဟှာ ပြစ်လွှတ်ရှင်းခွမ့် ရနိုင်ဘေမဲ့လည်း သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို ပြစ်မှားဘီး ပြောဆိုဟှူ သူဟှာ ပြစ်လွှတ်ရှင်းခွမ့် ရလေ့မယ် မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“လူလေဟှ နန်းနို့ဟှို ဝါလယ်ဇရပ်လေ၊ လူဂီးမန်းလေ၊ အာဏာပိုင်လေရဲ့ ရှေ့ဟှို ခေါ်ဆောန်လာဟှူ ခီမာ ဖယ်မျိုး ပ္လန်ပြောရမယ် ဆိုဇာဟှို စိုးရိမ်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်းနို့ ဖယ်မျိုး ပြောရမယ် ဆိုဇာဟှို သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှ အယ်ခီမာ သန်ပေးလေ့မယ်” ဆိုဘီး ရင်ဦးဆောင်း မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","လူအောက်ဂီးထဲဟှ လူတယော‑က်ဟှာ ယေရှုဟှို “ဆရာ၊ ကျွန်တော့်ဟှို မွီခွဲပေးဟှို့ ကျွန်တော့်နောန်ဟှို ပြောပေးပါ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ယေရှုဟှ “မိဆွေ၊ ဖယ်သူဟှ ငါ့ဟှို နန်းနို့ရဲ့ တရားသူဂီးဖြစ်နရော၊ မွီခွဲဝီသူဖြစ်နရော ခန့်ဟှားဂေ့ဟှယ်နူး။” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","အယ်ဘီးန ကိုယ်တော်ဟှာ သူးနို့လေ ဂူလောင်းဟှို “လောဘလွန်ကျူးရှင်း ဘောန်းဇောင်ဟှို ဒိထားဂေ့။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လူ့ရဲ့ သတ်ဟှာ အောက်စာပစ်စီး ပေါရှင်းနှိုက် တည်ဂေ့ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","အယ်ဘီးန ယေရှုဟှာ ပေါင်ဥပမာန “တခါဒူးဟှ ဌေးတယော့‑က်ဟှာ သူ့လယ်ယာဟှနေ သီးနှံလေ ဘောင်ဂီးထွပ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","‘ငါ့ရဲ့ သီးနှံလေ ဂူလောင်းဟှို သိုလှောန်ဟှားဟှို့တွပ် နေရာ မှေ့ဟှ။ ငါဖယ်မျိုးလောက်ရမယ်နူး။’ ဆိုဘီး တယော့‑က်ဒဲ စဉ်းစားနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","အယ်ဘီးန သူဟှ ‘ငါ အယ်မျိုးလောက်မယ်။ အယ်ဂိုဒေါန်ဟောန်းဟှို ဖျစ်ဘီး အယ်ထတ် ပိုကီးဟှူ ဂိုဒေါန်ဟှို ဆော့‑က်ဘီးဟှာ ဂျောင်ဆန်လေန တခြားအောက်စာပစ်စီး ဂူလောင်းဟှို သိုလှောင်ဟှားမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","အယ်ဘီးဟှာ ငါ့ဝိညာဉ်ဟှိုလည်း ဝှေ့ဝိညာဉ်၊ နှစ်လေဘောင်ဂီးတွပ် လိုအပ်ဟှူ အောက်စာလေ ဂူလောင်းဟှို သိုလှောန်ဟှားပီးဘီ။ စားလိုက်၊ သော့‑က်လိုက်န ပျော်ပါးဘီးနေပါ! ဆိုဘီး ငါ့ကိုယ့်ငါ ပြောမယ်။’ ");
INSERT INTO tvn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","အယ်ဘေမဲ့ ဘုရားသခင်ဟှာ ‘လူမိုက်! အယ်ညဉ့်မာ နန့်ဝိညာဉ် ချောက်ငြီးရလေ့မယ်။ အယ်ဆိုဟှာ နန်သိုလှောင်ဟှားဇာလေဟှို ဖယ်သူလေ ရလေ့မယ်နူး။’ ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","အယ်ဘီးန ယေရှုဟှာ “ကိုယ့်တွပ်အောက်စာလေ ဘောင်ဂီးဟှို စုဆောန်းဟှားဘေမဲ့လည်း အယ်ဌေးဟှာ ဘုရားသခင်ရဲ့ ရှေ့မာ ဆင်းရဲနေဟှူသူ ဖြစ်ဟှယ်” ဆိုဘီး နိဂေါန်းချောက် မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","အယ်ဘီးန ယေရှုဟှာ တဗဲ့တော်လေဟှို “အယ်ကြောန့် နန်းနို့ဟှို ငါပြောမယ်၊ ဖယ်မျိုးစားရဟှို့၊ ဖယ်မျိုးသော့‑က်ရဟှို့ ဆိုဘီး သတ်တွပ် စိုးရိမ်ဂေ့န။ ဖယ်မျိုးဝတ်ရဟှို့ ဆိုဘီးလည်း ကိုယ်ခန္ဓာတွပ် စိုးရိမ်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","စာထတ် သတ်ဟှ ပိုဘီး ရေးကီးဟှယ်။ ဝတ်ထတ်လည်း ကိုယ်ခန္ဓာဟှာ ပိုဘီး ရေးကီးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","က္လီးကန်းလေဟှို ကေ့ကေ့။ သူးနို့လေဟှာ မျိုးစေ့လည်းကြဲဟှ။ သီးနှံလည်းရိဟှ။ သူးနို့မာ ကူလှောန်ခန်းလေ၊ ဗားဂတ်လေလည်း မှေ့ဟှ။ အယ်ဘေမဲ့ ဘုရားသခင်ဟှ သူးနို့ဟှို ကျွေးမွေးတော်မူဟှယ်! နန်းနို့ဟှာ အယ်ငှတ်လေထတ် ရရာတိုင်း ဖိုးကီးဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","နန်းနို့လေထဲမာ ဖယ်သူဟှ စိုးရိမ်ရှင်းအားဖြင့် သတ် ပိုဘီး ရှယ်လာ နိုင်ဘဲ့လော။ ");
INSERT INTO tvn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","အယ်မျှလော့‑က် သေးငယ်ဟှူ မှုဟှို လောက်နိုင်ဟှ ဆိုဟှာ ဖြားဖြစ်ကြောန့် တခြားမှုလေတွပ် စိုးရိမ်နေဂေ့နူး။ ");
INSERT INTO tvn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","တောပန်းလေဟှို ကေ့ကေ့။ အယ်ပန်းလေဟှာ ဗိုင်းငင်ဟှ။ ယက်ကန်းလည်းရစ်ဟှ။ အယ်ဘေမဲ့ ရှောလမုန်မန်းဂီးရဲ့ ဖောင်းစည်းဇိမ်လေ ဂူလောင်းဟှို ဆင်ဟှယ်ဟှိုမှ အယ်တောပန်းလေထဲဟှ တဗန်မျိုး လှပတင့်တယ်ဟှ ဆိုဘီး နန်းနို့လေဟှို ငါပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ယောင်ကြည်ရှင်း အားနဲဟှူလူလေ! အယ်နေ့ ကွမ်းပ္လန်ထဲမာရှိဘီး နတ်ကီးတိုင်ဟှာ မီးဖိုထဲဟှို ရော့‑က်ရဟှူ တောဗြစ်ပန်ဟှို ဘုရားသခင်ဟှ အယ်မျိုး ဝတ်ဆင်ပေးဟှယ် ဆိုဟှာ နန်းနို့ဟှို အယ်ထတ်မက ဝတ်ဆင်ပေးမယ် မှုဟှလော။” ");
INSERT INTO tvn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“အယ်ကြောန့် ဖယ်မျိုး စားရဟှို့နူး။ ဖယ်မျိုး သော့‑က်ရဟှို့နူး ဆိုဘီး စိုးရိမ်ရှင်းရှိဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(အယ်လောကရှိ ဘုရားသိဘဲဟှူ လူလေဟှဘဲ့ အယ်မူဇာလေဟှို ရှာဖွေဂေ့ဟှယ်။) အယ်မူဇာလေဟှို နန်းနို့လေ လိုအပ်ဟှယ် ဆိုဇာဟှို နန်းနို့ဖ သိတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","နန်းနို့ဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို ရှာဂေ့။ အယ်ဆိုဟှာ ကိုယ်တော်ဟှာ အယ်မူဇာလေဟှို ပေးတော်မူလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“သိုးစုငယ်၊ ကြော့‑က်ဂေ့န။ နန်းနို့ရဲ့ ဖဟှာ နန်းနို့တွပ် နိုင်ငံတော်ဟှို ပေးဟှို့ လိုရှိတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","နန်းနို့ရဲ့ အောက်စာလေဟှို ရောန်းဘီး ဆင်းရဲသားလေဟှို ပေးကမ်းစွန့်ကြဲဂေ့။ ဆွီးဟောန်းနိုင်ဘဲဟှူ ကပ်အိလေဟှို လောက်ဂေ့ဘီး သူခိုးဖော့‑က်နိုင်ဘဲဟှူ၊ ပိုးလေကိုက်စားနိုင်ဘဲဟှူ၊ ကောန်းဂန်ဘောင်မာ ကူခန်းနိုင်ဘဲဟှူ ဘဏ္ဍာဟှို စုဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်းနို့လေဟှာ ဘဏ္ဍာရှိဟှူ နေရာဟှိုဘဲ့ နန်းနို့စိနှလောင်းလေ ရော့‑က်တတ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“နန်းနို့ဟှာ ဆင်သင့်ဖြစ်နေဂေ့ဟှို့တွပ် ခါးဟှို စဲဘီး မီးအီလေဟှို ထွန်းညှိဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","အီတတ်ဗွဲဟှ ပ္လန်လာဟှူ သူးနို့ရဲ့ သခင်ဟှို စောန့်နေဟှူ စေခံလေမျိုး ဖြစ်ဂေ့။ သူဟှာ ခွဗော့‑က်ဟှို ခေါ့‑က်ဟှူ ခီမာ သူးနို့ဟှာ ရှစ်ရှင်း ဖွမ့်ပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","သခင်ပ္လန်ရော့‑က်လာဟှူ ခီမာ ဆင်သင့်စောန့်နေဟှယ် ဆိုဇာဟှို သခင်တွိရဟှူ စေခံလေဟှာ မင်္ဂလာရှိဟှယ်! နန်းနို့ဟှို ငါမှန်တိုင်း ပြောမယ်။ သခင်ဟှာ စေခံလေဟှို ဧည့်သည်လေမျိုး ဗွဲမာ ထိုင်ခိုင်းဘီး သူကိုယ်တိုင် ခါးဟှို စဲဘီးဟှာ လောက်ကျွေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","သခင်ဟှ ညဉ့်နတ်ခီမာဘဲ့ဖြစ်ဖြစ်၊ မိုးလန်းခီမာဘဲ့ဖြစ်ဖြစ် လာမယ် ဆိုဘီး စောန့်နေဟှူ စေခံလေဟှာ မင်္ဂလာရှိဂေ့ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","အီဇရှင်ဟှာ သူခိုးလာနိုင်ဟှူခီဟှို သိနေမယ် ဆိုဟှာ သူ့အီဟှို သူခိုးဖော့‑က်ခံရလေ့မယ် မှုဟှ ဆိုဇာဟှို နားလည်ဟှားဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","လူ့ရဲ့သားဟှာ နန်းနို့ မျှော်လင့်ဘဲဟှူ ခီမာ ရော့‑က်လာမယ် ဖြစ်ဘီး နန်းနို့လည်း ဆင်သင့် ရှိနေဂေ့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ပေတရုဟှ “သခင်၊ အယ်ပေါင်ဥပမာဟှာ ကျွန်တော့်ဟှားလေတွပ် ပြောနေဇာလော။ လူလေ ဂူလောင်းတွပ် ပြောနေဇာလော။” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","သခင်ဘုရားဟှ “သစ်စာရှိဘီး ပညာရှိဟှူ စေခံဟှ ဖယ်သူနူး။ အီဇရှင်ဟှာ စေခံလေဟှို အောက်ချောက်ဟှို့န သတ်မှတ်ဟှားဟှူ ခီမာ စားဇာလေဟှို ထုပေးဟှို့ စေခံအောက် တယော့‑က်ဟှို ခန့်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","အီဇရှင် ပ္လန်လာဟှူ ခီမာ သစ်စာရှိရှိ လောက်ဆောန်နေဇာဟှို တွိရမယ် ဆိုဟှာ အယ်စေခံဟှာ မင်္ဂလာရှိဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ အီဇရှင်ဟှာ သူ့အောက်စာပစ်စီး ဂူလောင်းဟှို စီမံအောက်ချောက်ဟှို့ အယ်စေခံဟှို အပ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","အယ်ဘေမဲ့ အယ်စေခံဟှာ ငါ့သခင် ပ္လန်လာဟှို့ ကြာအူးမယ် ဆိုဘီး စိထဲမာ အော့‑က်မေ့ဘီး စေခံယော့‑က်ကျားလေ၊ စေခံမီးမလေဟှို ရိုက်ဘီး သော့‑က်စား ယစ်မောနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","အယ်စေခံရဲ့ သခင်ဟှာ သူမျှော်လင့်ဘဲဟှူနေ့ သိနိုင်ဘဲဟှူ ခီမာ ပ္လန်ရော့‑က်လာမယ် ဆိုဟှာ အယ်စေခံဟှို ပြင်းပြင်းထန်ထန် ပြစ်ဒန်ပေးဘီး ယောင်ကြည်ဘဲဟှူ သူလေနတူးဒူ နေရာခ္လဟှားရှင်းဟှို ခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“သခင်ရဲ့ လိုဆန္ဒဟှို သိသိဂီးန ပြင်ဆင်ဟှားရှင်းလည်း မှေ့ဘဲဟှူ၊ သခင့်ရဲ့ လိုဆန္ဒဟှို လိုက်လျောရှင်းလည်း မှေ့ဘဲဟှူ စေခံဟှာ ကီဒန်ဘောင်ဂီး ရိုက်ခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","အယ်ဘေမဲ့ သခင့်ရဲ့ လိုဆန္ဒဟှို သိဘဲန ကီဒန်နဘဲ့ ထိုက်တန်ဟှူ မှုဟှို လောက်မိဟှူ သူဟှာ ကီဒန်နဲနဲဘဲ့ ရိုက်ခံရမယ်။ ဘောင်ဂီးရဟှားဟှူ သူလေနားဟှနေ ဘောင်ဂီးတောန်းလေ့မယ်။ ဘောင်ဂီးအပ်ဟှားဟှူ သူလေနားဟှနေ ဘောင်းဂီး တောန်းဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ငါဟှ အယ်လောကဟှို မီးလောန်စေဟှို့တွပ် လာဟှယ်။ ခုဘဲ့ မီးလောန်စေရှင်ဘီ! ");
INSERT INTO tvn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ငါခံယူရဟှို့ ဗတ္တိဇံတခု ရှိသေးဟှယ်။ အယ်မူဇာဟှို လောက်ဆောန်ဟှို့ ပီးခန်ထိ ငါ့ဟှာ စိဒေါက်ခရော့‑က်နေဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","အယ်လောကဟှို ငြီသတ်ရှင်းပေးဟှို့ ငါလာဟှယ် ဆိုဘီး ထန်ဂေ့ဟှယ်လော။ ငြီသတ်ရှင်းပေးဟှို့ လာဟှူဇာ မှုဟှ။ ရှင်းရှင်း စိဝန်းကွဲစေဟှို့ဘဲ့ ငါလာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ခုဟှနေဘီးဟှာ လူငါးယော့‑က်ရှိဟှူ အီထောန်မာ နှေ့ယော့‑က်ဟှ တဖတ်၊ သောင်းယော့‑က်ဟှ တဖတ် ဆန့်ကျင်ဘီး ကွဲပြားဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ဖနသား၊ မိနမီး၊ ယောက္ခမန ချွေးမလေ ရှင်းရှင်း စိဝန်းကွဲလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ယေရှုဟှာ လူလေဟှို “နော့‑က်ဖတ်မာ မိုးတီလေ တတ်လာဇာဟှို ဗြင်ဟှူ ခီမာ မိုးဝါလေ့မယ် ဆိုဘီး နန်းနို့ရှစ်ရှင်း ပြောဂေ့ဟှယ်။ နန်းနို့ပြောမျိုးဘဲ့ ဖြစ်တတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","အယ်ဘီးန တောင်လေတိုက်လာနေဇာဟှို မြင်ဟှူ ခီမာ နေပူလေ့မယ် ဆိုဘီး ပြောဂေ့ဟှယ်။ နန်းနို့ပြောမျိုးဘဲ့ ဖြစ်တတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","သူတော်ကောန်း ယောန်ဆောန်ဟှူသူလေ! နန်းနို့ဟှာ မ္လေဂီးန ကောန်းဂန်ရဲ့ ခြေနေဟှို ကေ့ဘီးဟှာ ရာသီဥတုရဲ့ ခြေနေဟှို ပိုင်းခြားဘီး သိနိုင်ဂေ့ဟှယ်။ ခုကာလ ခြေနေဟှို ဖြားဖြစ်ကြောန့် ခန့်မှန်းဘီး သိနိုင်ဂေ့ဟှနူး။ ");
INSERT INTO tvn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“မှန်ကန်ဟှူလောက်ဟှို လောက်ဟှို့တွပ် ဖြားဖြစ်ကြောန့် နန်းနို့ကိုယ်တိုင် ဆောင်းဖြတ်ဂေ့ဟှနူး။ ");
INSERT INTO tvn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","နန့်ဟှို တရားစွဲဟှူ လူနတူးဒူ တရားသူဂီးနားဟှို သွားရမယ် ဆိုဟှာ လမ်းမာ ကြေအေးအောန်လောက်ဂေ့။ အယ်မျိုးလောက်ဘဲဟှ ဆိုဟှာ သူဟှာ နန့်ဟှို တရားသူဂီးရှေ့ဟှို ဆွဲခေါ်ဟှားလေ့မယ်။ တရားသူဂီးဟှ နန့်ဟှို ရဲလတ်ထဲမာ အပ်လိုက်လေ့မယ်။ ရဲလေဟှလည်း နန်ဟှို ထောန်ထဲမာ ထဲဟှားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ကပ်ကွီးလေ ဂူလောင်းဟှို ကျေအောန် ဆပ်ခန်ထိ နန်ဟှာ ထောန်ထဲမာ နေရလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","အယ်ခီမာ လူတချို့ဟှာ ယေရှုနားဟှို လာဘီး ပိလတ်ဟှ သတ်ဖြတ်လိုက်ဟှူ ဂါလိလဲလူလေကြောန်းဟှို လျှော့‑က်ဂေ့ဟှယ်။ အယ်လူလေဟှာ ယဇ်ပူဇော်နေဒူးမာ သတ်ခံရဟှူ သူလေ ဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ယေရှုဟှာ သူးနို့ဟှို “အယ်ဂါလိလဲ လူလေဟှာ အယ်မျိုးသတ်ခံရဟှူကြောန့် တခြားဂါလိလဲ လူလေထတ် ပိုဆိုးဟှူ ပြစ်သားလေ ဖြစ်ဟှယ် ဆိုဘီး နန်းနို့ ထန်နေဂေ့ဟှယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","နန်းနို့ဟှို ငါပြောမယ်၊ သူးနို့လေဟှာ ပိုဆိုးဟှူ ပြစ်သားလေ မှုဟှ! အယ်ဘေမဲ့ နန်းနို့ဟှာ နောန်ဒရဂေ့ဟှ ဆိုဟှာ အယ်လူလေမျိုးဘဲ့ သေကျေပျစ်စီးဂေ့ လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ရှိလောင်မျှော်စင် ပြိုက္လဟှူ ခီမာ ပိဘီးသေဟှားဟှူ လူဆယ့်ရှစ်ယော့‑က်ဟှို ဖြားမျိုးပြောမယ်နူး။ သူးနို့ဟှာ ယေရုရှလင်ဗြို့မာ နေထိုင်ဟှူ တခြားသူလေ ဂူလောင်းထတ် ပိုဆိုးဟှူ ပြစ်သားလေ ဖြစ်ဟှယ် ဆိုဘီး နန်းနို့ ထန်နေဂေ့လော။ ");
INSERT INTO tvn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","နန်းနို့ဟှို ငါပြောမယ်။ သူးနို့လေဟှာ ပိုဆိုးဟှူ ပြစ်သားလေ မှုဟှ။ အယ်ဘေမဲ့ နန်းနို့ဟှာ နောန်ဒရဂေ့ဟှ ဆိုဟှာ အယ်လူလေမျိုးဘဲ သေကျေပျစ်စီးဂေ့ လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","အယ်ဘီးန ယေရှုဟှာ အယ်ပေါင်ဥပမာန “လူတယော့‑က်ရဲ့ စဗျစ်ခြံထဲမာ စိုက်ပျိုးဟှားဟှူ သဖန်းဗန်တဗန် ရှိဟှယ်။ ဇရှင်ဟှာ အယ်ပန်မာ သီးဟှို လာရှာဟှူ ခီမာ တွိရဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","အယ်ကြောန့် သူဟှာ ခြံစောန့်မားဟှို ‘ငါဟှာ အယ်သဖန်းဗန်မာ သဖန်းသီးလာရှာနေဇာ သောင်းနှစ်ရှိဟှားဘီ။ အယ်ဘေမဲ့ လောင်းလည်း တွိရဟှ။ အယ်မူပန်ဟှို ခွတ်ပစ်လိုက်! ဖြားဖြစ်ကြောန့် မ္လေဂီးဟှို ကျိုးမှေ့ဘဲအောန် လောက်နေဂေ့ဟှို့နူး။’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","အယ်ဘေမဲ့ ခြံစောန့်မားဟှ ‘ဆရာ၊ အယ်ပန်ဟှို တနှစ်လော့‑က် ထားပေးပါအူး။ ပန်ရင်းပတ်ပတ်လည်ဟှို တူးဆွဘီးဟှာ မ္လေဩဇာ ထဲ့ကေ့ကေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","အယ်ဆိုဟှာ နော့‑က်နှစ်မာ ပိုကောန်းဟှူ သီးဟှို သီးရှင်သီးလေ့မယ်၊ အယ်ဘေမဲ့ သီးသီးဟှ ဆိုဟှာ ခွတ်ပစ်ပါ ဆိုဘီး ပြောလေဟှယ်’” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ဒန်းနေ့ တနေ့မာ ယေရှုဟှာ ဝါလယ်ဇရပ်တခုမာ သွန်သန်နေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","အယ်နေရာမာ ဆယ့်ရှစ်နှစ်လောင်းလောင်း နတ်ဆိုးဝမ်ပူးရှင်းဟှို ခံနေရဟှူကြောန့် ခါးကူးဟှားဘီး လောင်းဝ ခါးဆန့်နိုင်ဘဲဟှူ မီးမတယော့‑က်ရှိနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ယေရှုဟှာ သူ့ဟှို ဗြင်ဟှူ ခီမာ ရှေ့တော်ဟှို ခေါ်ဘီး “ဝှေ့ မီးမ၊ နန့်ရောဂါ ပျော့‑က်ဟှားဘီ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","အယ်ဘီးန ကိုယ်တော်ဟှာ သူ့ထတ်မာ လတ်ဟှို တန်လိုက်ဟှူ ခီမာ ရှစ်ရှင်းဘဲ့ သူ့ရဲ့ခါးဟှာ ဆန့်ဟှားဘီး ဘုရားသခင်ဟှို ချီးမွမ်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ဒန်းနေ့မာ ယေရှုဟှာ ရောဂါပျော့‑က် စေတော်မူဟှူကြောန့် ဝါလယ်ဇရပ်မှူးဟှာ စိဆိုးဘီး လူလေဟှို “လောက်လောက်နိုင်ဟှူရစ် ခြော့‑က်ရစ်ရှိဟှယ်။ အယ်ရစ်လေမာ ရောဂါလာကုဂေ့။ ဒန်းနေ့မာ ရောဂါလာကုဂေ့န!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","သခင်ဘုရားဟှာ သူ့ဟှို “သူတော်ကောန်း ယောန်ဆောန်ဟှူသူလေ! နန်းနို့ ဂူလောင်းဟှာ ဒန်းနေ့မာ နန်းနို့ရဲ့ မြည်းလေ၊ နွားလေဟှို တင်းကုပ်ဟှနေ ကြိုးဖြေပေးဘီး ရေတိုက်ဟှို့ ခေါ်ဆောန်ဂေ့ဟှယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","အယ်မျိုးဆိုဟှာ ဆယ့်ရှစ်နှစ် လောင်းလောင်း စာတန်ရဲ့ တောက်နှောန်ရှင်းဟှို ခံနေရဟှူ အာဗြဟံရဲ့ သမီးဟှို ဒန်းနေ့မာ ဖြေလွှတ်သင့်ဟှယ် မှုဟှလော။” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","အယ်မျိုး မိန်တော်မူလိုက်ဟှူ ခီမာ ကိုယ်တော့်ဟှို ဆန့်ကျင်ဖတ်လောက်နေဟှူ သူလေဟှာ ယှစ်ရဟှားဂေ့ဘီး လူလေ ဂူလောင်းဟှာ ကိုယ်တော် လောက်ဟှူ အံ့ဩဘွယ်လေကြောန့် ဝန်းသာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ယေရှုဟှ “ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှာ ဖြားဇာန တူဟှယ်နူး။ ဖြားဇာန နှိုင်းယှဉ်ရနူး။ ");
INSERT INTO tvn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","နိုင်ငံတော်ဟှာ အယ်ပေါင်ဥပမာန တူဟှယ်။ လူတယော့‑က်ဟှာ မုညင်းတစေ့ဟှို သူ့ခြံထဲမာ စိုက်လိုက်ဟှယ်။ အယ်စေ့ဟှ ကီးလာဘီး သစ်ပန်ကီးဖြစ်လာဟှူ ခီမာ အယ်ပန်ရဲ့ ကိုင်းခတ်လေမာ ကောန်းဂန်ငှတ်လေဟှာ သူးနို့ရဲ့ သိုက်ဟှို ဆော့‑က်လောက်ဘီး နေဂေ့ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ယေရှုဟှာ “ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို ဖြားဇာန နှိုင်းယှဉ်ရဟှို့နူး။ ");
INSERT INTO tvn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","နိုင်ငံတော်ဟှာ အယ်ပေါင်ဥပမာန တူဟှယ်။ မီးမတယော့‑က်ဟှာ တဆေးဟှို ယူဘီး မုညစ်သောင်းတောန်းန ရောနှောလိုက်ဟှူ ခီမာ မုညစ် အား‌လောင်းဂူဟှို ဖောန်းကြွစေနိုင်ဟှူ တဆေးန တူဟှယ်” ဆိုဘီး ထပ်ဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","အယ်ဘီးန ယေရှုဟှာ ဗြို့လေ၊ ဝါလေမာ သွန်သန်ဘီး ယေရုရှလင်ဗြို့ဟှို သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","လူတယော့‑က်ဟှာ ကိုယ်တော့်ဟှို “သခင်၊ ကယ်တန်ရှင်းခံရဟှူ သူလေ နဲနဲဘဲ့ ရှိဟှယ်လော။” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ယေရှုဟှ “ခွဗော့‑က်ကျဉ်းထဲဟှို ဝမ်ဟှို့ ကြိုးစားအားထုဂေ့။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လူလေဘောင်ဂီးဟှာ အယ်ခွဗော့‑က်ထဲဟှို ဝမ်ဟှို့ ကြိုးစားဘေမဲ့ ဝမ်နိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","အီဇရှင်ဟှာ ထဘီး ခွဗော့‑က်ဟှို ပိလိုက်ဟှူကြောန့် နန်းနို့လေဟှာ ပ္လန်မာရပ်ဘီး ခွဗော့‑က်ဟှို ခေါ့‑က်ဘီး ‘ဆရာ၊ ကျွန်တော့်ဟှားလေဟှို ခွဗော့‑က်ဖွမ့်ပေးပါ!’ ဆိုဘီး တောန်းဗန်ဂေ့လေ့မယ်။ ဇရှင်ဟှ ‘နန်းနို့လေ ဖယ်ဟှလာဟှယ် ဆိုဇာဟှို ငါသိဟှ!’ ဆိုဘီး ပ္လန်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","အယ်ဆိုဟှာ နန်းနို့လေဟှ ‘ကျွန်တော့်ဟှားလေဟှာ ကိုယ်တော်နတူးဒူ စားဂေ့ဟှယ်။ သော့‑က်ဂေ့ဟှယ်။ ကျွန်တော့်ဟှားလေရဲ့ ဗြို့ဝါမာလည်း ကိုယ်တော်ဟှာ သွန်သန်ပေးဟှယ်!’ ဆိုဘီး ဖြေလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","အယ်ဘေမဲ့ ကိုယ်တော်ဟှ ‘နန်းနို့ ဖယ်ဟှလာဟှယ် ဆိုဇာဟှို ငါသိဟှ။ တရားဘဲဟှူ မှုဟှို လောက်ဟှူ သူလေ၊ ငါ့နားဟှ ဖယ်ဂေ့!’ ဆိုဘီး ပြောလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","နန်းနို့ဟှာ ဘုရားသခင် နိုင်ငံတော်ထဲမာ အာဗြဟံ၊ ဣဇာက်၊ ယာကုပ်န ပရောဖက်လေ ဂူလောင်းဟှို ဗြင်ရဘေမဲ့ နန်းနို့လေဟှာ နိုင်ငံတော်ပ္လန်ဟှို နှန်ထုခံရဟှူ ခီမာ ရရာတိုင်း ငိုကြွေးဘီး အံသွားခဲက္လိရဂေ့ လေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ရှေ့ဖတ်၊ နော့‑က်ဖတ်၊ တောန်ဖတ်၊ မြော့‑က်ဖတ်ဟှ လာဂေ့ဟှူ လူလေဟှာ ဘုရားသခင် နိုင်ငံတော်ရဲ့ စားသော့‑က်ဗွဲမာ လာဘီး ထိုင်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ခု နော့‑က်ဆောင်းဟှို ရော့‑က်နေဟှူ သူလေဟှာ ရှေ့ဆောင်းဟှို ရော့‑က်ဂေ့လေ့မယ်။ ခု ရှေ့ဆောင်းဟှို ရော့‑က်နေဟှူ သူလေဟှာ နော့‑က်ဆောင်းဟှို ရော့‑က်ဂေ့လေ့မယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","အယ်ခီမာ ဖာရိရှဲတချို့ဟှာ ယေရှုနားဟှို လာဘီး “ဟေရုဒ်ဟှ ကိုယ်တော့်ဟှို သတ်ရှင်နေဟှူကြောန့် အယ်နေရာဟှ ထွပ်ဟှားဘီး တခြားနေရာဟှို သွားပါ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ယေရှုဟှာ “အယ်မ္လေခွီးဟှို သွားပြောဂေ့ပါ။ ‘ငါဟှာ အယ်နေ့န နတ်ကီးတိုင်မာလည်း နတ်ဆိုးလေဟှို နှန်ထုဘီးဟှာ ရောဂါလေဟှိုလည်း ပျော့‑က်စေအူးမယ်။ သောင်းရစ်မြော့‑က်ဟှူနေ့မာ ငါ့ရဲ့ လောက်ဟှို ပီးဆောင်းစေမယ်။’ ");
INSERT INTO tvn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","အယ်ဘေမဲ့ ငါဟှာ အယ်နေ့၊ နတ်ကီးတိုင်၊ နတ်ကီးဖတ်လည်း ခရီးသွားရအူးမယ်။ ပရောဖက်ဟှာ ယေရုရှလင်ဗြို့ဟှလွဲဘီး တခြားနေရာမာ သတ်ခံရဟှို့ မှေ့ဟှ။” ");
INSERT INTO tvn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“ယေရုရှလင်ဗြို့၊ ယေရုရှလင်ဗြို့၊ ပရောဖက်လေဟှို သတ်ဟှူဗြို့၊ ဘုရားသခင် စေလွှတ်လိုက်ဟှူ တမန်လေဟှို က္လော့‑က်ခဲန ပစ်ဟှူဗြို့! ကြစ်မဟှာ ကြစ်သားဟှားလေဟှို သူ့ရဲ့ တောန်အော့‑က်မာ စုသီးဟှားမျိုး ငါဟှာ နန့်ရဲ့လူမျိုး ဂူလောင်းဟှိုလည်း စုသီးဟှို့ ခါဘီးခါ လိုရှင်လေဟှယ်။ အယ်ဘေမဲ့လည်း နန်ဟှာ ငါ့ဟှို ခွမ့်ပြုဟှ! ");
INSERT INTO tvn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","အယ်ကြောန့် နန့်ရဲ့ အီဟှို ဘုရားသခင် စွန့်ပစ်လေ့မယ်။ ငါပြောမယ်။ ‘ဘုရားသခင် နာမန ကြွလာဟှူ သခင်ဟှာ မင်္ဂလာရှိဟှယ်’ ဆိုဘီး နန်ပြောဟှူခီ ရော့‑က်ခန်မာ ငါ့ဟှို နန်ဗြင်ရလေ့မယ် မှုဟှ” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ဒန်းနေ့မာ ယေရှုဟှာ စားဇာစားဟှို့ ဖာရိရှဲခေါန်းဆောန်တယော့‑က်ရဲ့ အီထဲဟှို ဝမ်ဟှားဟှူ ခီမာ သူးနို့လေဟှာ ကိုယ်တော့်ဟှို စောန့်ကေ့နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ရေဖျဉ်းစွဲမား တယော့‑က်ဟှာ ယေရှုနားဟှို ရော့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ယေရှုဟှ “ဒန်းနေ့မာ ရောဂါ ပျော့‑က်စေဟှို့တွပ် ပညတ်တော်ဟှ ခွမ့်ပြုဟှားဘဲ့လော။” ဆိုဘီး ဖာရိရှဲလေန ကျမ်းတတ်ဆရာလေဟှို မေးတော်မူလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","အယ်ဘေမဲ့ သူးနို့လေဟှာ တိဆိနေဂေ့ဟှယ်။ ယေရှုဟှာ အယ်လူနာဟှို ခေါ်ဘီး၊ ရောဂါပျော့‑က်စေဘီး သူ့ဟှို လွှတ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ကိုယ်တော်ဟှ “နန်းနို့ရဲ့ သားဂန်းဟှားဘဲ့ဖြစ်ဖြစ်၊ နွားတကောန်ဘဲ့ဖြစ်ဖြစ် ဒန်းနေ့မာ ရေဒွမ်းထဲဟှို က္လဟှားမယ် ဆိုဟှာ နန်းနို့ဟှာ ရှစ်ရှင်း ဆွဲဒန်လေ့မယ် မှုဟှလော။” ဆိုဘီး သူးနို့ဟှို မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","အယ်ဘေမဲ့ သူးနို့လေဟှာ ဖြားလည်း ဖြေနိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ဧည့်သည်လေဟှာ ကောန်းဆောင်းနေရာဟှို ဝီးကော့‑က်နေဇာဟှို ယေရှုဗြင်ဟှူ ခီမာ သူးနို့လေဟှို အယ်ပေါင်ဥပမာန ");
INSERT INTO tvn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“နန်းနို့ဟှို ယော့‑က်ယော့‑က်ဟှ အီတတ်ဗွဲဟှို ဖိဟှားဟှူ ခီမာ ကောန်းဆောင်းနေရာမာ ထိုင်ဂေ့န။ နန်းနို့ထတ် ရေးကီးဟှူ ယော့‑က်ယော့‑က်ဟှိုလည်း ဖိခေါ်ဟှားမယ် ဆိုဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ခေါ်ဖိသူဟှာ နန့်ဟှို ‘အယ်လူတွပ် နေရာဖယ်ပေးဂေ့’ ဆိုဘီး ပြောလေ့မယ်။ အယ်ဆိုဟှာ နန်ဟှာ ယှစ်ရဘီး နိဆောင်းနေရာမာ ထိုင်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","အယ်ကြောန့် နန့်ဟှို ဖိခေါ်ဟှူ ခီမာ နိဆောင်းနေရာမာ သွားဘီးထိုင်ဂေ့။ အယ်မျိုးဆိုဟှာ ဖိခေါ်သူဟှ နန့်နားဟှို လာဘီးဟှာ ‘မိဆွေ ပိုကောန်းဟှူ နေရာမာ ထိုင်ပါ’ ဆိုဘီး နန့်ဟှို ပြောလေ့မယ်။ အယ်ဆိုဟှာ နန်ဟှာ ဧည့်သည်လေရဲ့ ရှေ့မာ ဂေါင်သရေ ရှိလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“အယ်ကြောန့် ကိုယ့်ကိုယ်ကိုယ် ချီးမြှော့‑က်ဟှူသူဟှာ နှိခ္လခံရဘီး ကိုယ့်ကိုယ်ကိုယ် နှိခ္လဟှူသူဟှာ ချီးမြှော့‑က်ခံရလေ့မယ်” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","အယ်ဘီးန ယေရှုဟှာ ဖိခေါ်သူဟှို “နန်ဟှာ မွန်းဒဲ့ဇာ၊ ညဉ့်ဇာဟှို ကျွေးမွေးဟှူ ခီမာ မိဆွေလေ၊ ညီကိုလေ၊ ဆွေမျိုးလေ၊ အီဇနီးရှင်း ဌေးလေဟှို ဖိခေါ်န။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့လေဟှာ နန့်ဟှို ပ္လန်ဖိဘီးဟှာ ကျေးဇူးဆပ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","အယ်ကြောန့် စားသော့‑က်ဗွဲ ကျင်းပဟှူ ခီမာ ဆင်းရဲသား၊ အင်္ဂါချို့တဲ့သူ၊ ခေသန်ဘဲဟှူသူ၊ မျစ်စိကန်းသူလေဟှိုဘဲ့ ဖိခေါ်ပါ။ ");
INSERT INTO tvn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","အယ်မျိုးဆိုဟှာ နန်ဟှာ မင်္ဂလာရှိလေ့မယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့လေဟှ နန့်ဟှို ပ္လန်ဘီး ကျေးဇူးဆပ်နိုင်ဂေ့ဟှို့ မှုဟှ။ အယ်ဘေမဲ့လည်း ဖြောန့်မတ်သူလေ ရှင်ပ္လန်ထမြော့‑က်ဟှူ ခီမာ ဘုရားသခင်ဟှ နန့်ဟှို ပ္လန်ဆပ်ပေးလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","စားဗွဲမာ ထိုင်နေဟှူ ဧည့်သည်လေထဲဟှ တယော့‑က်ဟှာ အယ်စကားဟှို ကြားဟှူ ခီမာ ယေရှုဟှို “ဘုရားသခင်နိုင်ငံတော်ရဲ့ စားသော့‑က်ဗွဲမာ ထိုင်ရဟှူ သူလေဟှာ ရရာတိုင်း ပျော်လေ့မယ်!” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ယေရှုဟှာ “လူတယော့‑က်ဟှာ စားသော့‑က်ဗွဲဂီးဟှို ပြင်ဆင်ဟှားဘီး လူဘောင်ဂီးဟှို ဖိဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","စားသော့‑က်ဗွဲခီ ရော့‑က်ဟှူ ခီမာ ဖိဟှားဟှူ လူလေနားဟှို သူ့ရဲ့ကျွန်ဟှို စေလွှတ်ဘီးဟှာ ‘ဂူလောင်း ဆင်သင့်ဖြစ်နေဘီ။ ကြွဂေ့ပါ!’ ဆိုဘီး ပြောစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","အယ်ဘေမဲ့ သူးနို့လေ ဂူလောင်းဟှာ ယော့‑က်ဘီးယော့‑က် ဆင်ခေလတ်ခေလေ ပေးဂေ့ဟှယ်။ ပထမတယော့‑က်ဟှ ‘ငါ့ဟှာ လဲဗ္လန်တဂွပ် ဝယ်ဟှားဇာဟှို သွားဘီး ကေ့ကေ့ရအူးမယ်။ ငါ့ဟှို ခွမ့်လွှတ်ဟှို့ တောန်းလျှော့‑က်ပါဟှယ်’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","နော့‑က်ထပ် တယော့‑က်ဟှ ‘ငါဝယ်ဟှားဟှူ နွားငါးရှဉ်းဟှို မောန်းစမ်းဟှို့ သွားရအူးမယ်။ ငါ့ဟှို ခွမ့်လွှတ်ဟှို့ တောန်းလျှော့‑က်ပါဟှယ်’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","နော့‑က်ထပ် တယော့‑က်ဟှ ‘ငါလည်း ခုဘဲ့သေး အီထောန်က္လကြောန့် လာနိုင်ဟှို့ မှုဟှ’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","စေခံဟှာ သူ့သခင်နားဟှို ပ္လန်ဟှားဘီးဟှာ အယ်ကြောန်းရာ ဂူလောင်းဟှို ပ္လန်ပြောပြဟှယ်။ သခင်ဟှာ ရရာတိုင်း ဒေါသထွပ်ဟှားဘီး ‘ဗြို့ထဲမာရှိဟှူ လမ်းမလမ်းကြားလေဟှို ဗြန်းဗြန်သွား။ အယ်ဘီးဟှာ ဆင်းရဲသား၊ အင်္ဂါချို့တဲ့သူ၊ ခေသန်ဘဲဟှူသူ၊ မျစ်စိကန်းသူလေဟှို ခေါ်ပါ’ ဆိုဘီး သူ့ရဲ့စေခံဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","စေခံဟှာ ပ္လန်ရော့‑က်လာဘီး ‘သခင်၊ သခင်ခိုင်းဒဲ့တိုင်း လောက်ပီးဘီ။ အယ်ဘေမဲ့ နေရာလပ်လေ ရှိနေသေးဟှယ်’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","အယ်ကြောန့် သခင်ဟှ ‘ဗြို့ပ္လန်၊ လမ်းမ၊ ခြံစည်းရိုးနားဟှို သွားပါ။ အယ်ဘီးဟှာ ငါ့အီဟှို ပ္လဲ့အောန် လူလေဟှို ခေါ်လာပါ’ ဆိုဘီး စေခံဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","နန်းနို့ဟှို ငါပြောမယ်။ ရင်းရင်ဒူးဟှ ဖိခေါ်ဟှားဟှူ လူလေ တယော့‑က်လည်း ငါ့ရဲ့ စားသော့‑က်ဗွဲဟှို မြည်းစမ်းရလေ့ဟှို့ မှုဟှ!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","လူအောက်ဂီးဟှာ ယေရှုနတူးဒူ သွားနေဟှူ ခီမာ ကိုယ်တော်ဟှာ လှည့်ကေ့ဘီး ");
INSERT INTO tvn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ယော့‑က်ယော့‑က်ဟှာ ငါ့နားဟှို လာဘေမဲ့လည်း ငါ့ဟှို ရှစ်ဇာထတ် မိဖ၊ သားမယား၊ နောန်၊ ညီမန သူးနို့ရဲ့ သတ်ဟှို ပိုဘီး ရှစ်မယ် ဆိုဟှာ ငါ့တဗဲ့ ဖြစ်နိုင်ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","သူးနို့ရဲ့ လတ်ဝါးကပ်တိုင်ဟှို ထမ်းဘီး ငါ့နော့‑က်ဟှို လိုက်ဂေ့ဟှ ဆိုဟှာ ငါ့တဗဲ့လေ ဖြစ်နိုင်ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","နန်းနို့ထဲဟှ တယော့‑က်ဟှာ မျှော်စင်တခုဟှို ဆော့‑က်မယ် ဆိုဘီး ကြံရှိဟှူသူဟှ ကပ်လော့‑က်ငှအောန် ရှိလော၊ မှေ့ဟှလော ဆိုဘီး ရင်ဦးဆောင်း ထိုင်ဘီး ကူက္လဇာလေဟှို တွပ်ကေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","အယ်မျိုးတွပ်ဘဲန ဆိုဟှာ မျှော်စင်ဟှို အုပြစ်ခ္လဘီး ပီးအောန် ဆော့‑က်နိုင်ဘဲကြောန့် ဗြင်ဟှူသူလေ ဂူလောင်းဟှာ ရယ်ဇားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘အယ်လူဟှာ တည်ဆော့‑က်ဟှို့ စပြုနိုင်ဘေမဲ့ ဆောင်းသတ်နိုင်ဘဲဟှူသူ!’ ဆိုဘီး သူးနို့ဟှာ ပြောဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","စစ်သား ၁၀,၀၀၀ ရှိဟှူ မန်းဂီးတပါးဟှာ စစ်သား ၂၀,၀၀၀ န ချီတတ်လာဟှူ တခြားမန်းဂီးဟှို ထွပ်ဘီး ရင်ဆိုင်မယ် ဆိုဟှာ အယ်စစ်သားအင်အားန ခုခံနိုင်မယ် ခုခံနိုင်ဟှ ဆိုဘီး ရင်ဦးဆောင်း ထိုင်ဘီးဟှာ တွပ်ကေ့ဘီး ဆောင်းဖြတ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ခုခံဟှို့ အင်အား မှေ့ဟှ ဆိုဟှာ တခြားမန်းဂီးဟှာ ဝီးဂီးမာ ရှိနေဂဒဲ့ဟှ တမန်လေဟှို လွှတ်ဘီးဟှာ စစ်ပြေငြိမ်းရေး စကားဟှို တောန်းလျှော့‑က်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","အယ်မျိုးဘဲ့ နန်းနို့မာ ရှိမျှဟှို စွန့်ဘဲဟှ ဆိုဟှာ ငါ့တဗဲ့ ဖြစ်နိုင်ဟှို့ မှုဟှ။” ");
INSERT INTO tvn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ဆားဟှာ ကောန်းဟှယ်။ အယ်ဘေမဲ့ ငန်ဓါတ်မှေ့ဟှ ဆိုဟှာ ငန်ဟှူ ရသာဟှို ပ္လန်ရဟှို့ နည်းလမ်းမှေ့ဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","မ္လေဆီလွှာတွပ်လည်း ကောန်းဟှ။ မ္လေဩဇာတွပ်လည်း ကောန်းဘဲဟှူကြောန့် ဝီးဝီးဟှို ပစ်လွှပ်လိုက်ဂေ့ဟှယ်။ “အယ်ကြောန့် နန်ဟှာ နားရှိဟှယ် ဆိုဟှာ ကြားဂေ့!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","တနေ့မာ ခွန်ကော့‑က်မားလေန ပြစ်သားလေဟှာ တရားစကားဟှို နားထောန်ဟှို့တွပ် ယေရှုနားဟှို ရော့‑က်လာဟှူ ခီမာ ");
INSERT INTO tvn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ဖာရိရှဲလေန ကျမ်းတတ်ဆရာလေဟှ “အယ်လူဟှာ ပြစ်သားလေဟှို လတ်ခံဘီးဟှာ သူးနို့နတူးဒူလည်း စားသော့‑က်ဂေ့ဟှယ်!” ဆိုဘီး ပြစ်တန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","အယ်ကြောန့် ယေရှုဟှ အယ်ပေါင်ဥပမာန ");
INSERT INTO tvn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“နန်းနို့ထဲဟှ တယော့‑က်မာ သိုးကောန်တရာရှိဘီး တကောန်ပျော့‑က်ဟှားမယ် ဆိုဟှာ ဖယ်မျိုးလောက်ဂေ့မယ်နူး။ သိုးကိုးဆယ်ကိုးကောန်ဟှို စားကျစ်မာ ထားရစ်ဘီးဟှာ ပျော့‑က်နေဟှူ သိုးတကောန်ဟှို တွိအောန်လိုက်ရှာဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","အယ်သိုးဟှို ပ္လန်တွိဟှူ ခီမာ ရရာတိုင်း ဝန်းသာဘီးဟှာ ခေါင်းထတ်မာ ");
INSERT INTO tvn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ထမ်းဘီး အီဟှို ပ္လန်ဟှားဟှယ်။ အယ်ဘီးန အီဇနီးရှင်းလေန မိဆွေလေဟှို ခေါ်ဘီးဟှာ ‘ပျော့‑က်နေဟှူ သိုးဟှို ငါပ္လန်တွိဟှားဘီ။ နို့လေ ပွဲလောက်ဂေ့ဇို့!’ ဆိုဘီး ပြောလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","အယ်မျိုးဘဲ့ နောန်ဒရဘဲဟှူ ဖြောန့်မတ်သူ ကိုးဆယ်ကိုးယော့‑က်ထတ် နောန်ဒရဟှူ ပြစ်သားတယော့‑က်တွပ် ကောန်းဂန်ဘောင်မာ ပိုဘီး ဝန်းသာလေ့မယ် ဆိုဘီး နန်းနို့ဟှို ငါပြောဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“အယ်မျိုးဘဲ့ မီးမတယော့‑က်မာ ငွေဒန်းဂါး ဆယ်ပ္လားရှိဘီး ငွေဒန်းဂါး တပ္လားပျော့‑က်ဟှားမယ် ဆိုဟှာ အယ်မီးမ ဖြားဇာလောက်မယ်နူး။ သူဟှာ မီးအီထွန်းဘီး၊ ရှင်းလန်းဘီးဟှာ တွိအောန် သေးသေချားချာ ရှာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","အယ်ငွေဒန်းဂါးဟှို တွိဟှူ ခီမာ သူဟှာ အီဇနီးရှင်းလေန မိဆွေလေဟှို ခေါ်ဘီး ‘ပျော့‑က်ဟှားဟှူ ဒန်းဂါးဟှို ငါပ္လန်တွိဘီ။ နို့လေ ပွဲလောက်ဂေ့ဇို့!’ ဆိုဘီး ပြောလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","အယ်မျိုးဘဲ့ ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်လေဟှာလည်း နောန်ဒရဟှူ ပြစ်သားတယော့‑က်တွပ် ရရာတိုင်း ဝန်းသာလေ့မယ် ဆိုဇာဟှို နန်းနို့ဟှို ငါပြောဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ယေရှုဟှာ ဆစ်ဘီး “လူတယော့‑က်မာ သားနှေ့ယော့‑က် ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","သားငယ်ဟှ ဖဟှို ‘ဖ၊ နို့ရဲ့ မွီလေဟှို ပေးပါ’ ဆိုဘီး တောန်းလေဟှယ်။ အယ်ကြောန့် ဖဟှ သူ့ရဲ့ မွီအောက်စာလေဟှို သားနှေ့ယော့‑က်ဟှို ခွဲဝီပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ရစ်နဲနဲကြာဘီးန သားငယ်ဟှာ သူ့ရဲ့ မွီအောက်စာလေဟှို ရောန်းခ္လဘီး ကပ်ထုန အီထတ်ဟှနေ ဆင်းဟှားဟှယ်။ သူဟှာ ဟှိုးဝီးဂီးမာရှိနေဟှူ တိုင်းပြည်ဟှို သွားဘီး အယ်နေရာမာ ဗရမ်းဗဒါသတ်ရှင်ဘီးဟှာ သူ့ကပ်လေဟှို ဖြုန်းစားပစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","သူ့ရဲ့ ကပ်လေ ဂူလောင်းဟှို သောင်းဖြုန်းပစ်ဘီးဟှူ ခီမာ အယ်တိုင်းပြည် နှံ့ပ္လားမာ ဆိုးဝါးဟှူ ငတ်မွတ်ရှင်းဘေး က္လရော့‑က်လာဟှူကြောန့် သူဟှာ ငတ်ပြတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","အယ်ကြောန့် အယ်တိုင်းပြည်ရဲ့ ပြည်သားလေထဲဟှ တယော့‑က်နားဟှို လောက်လောက်ဟှို့ သွားလေဟှယ်။ အယ်ပြည်သားဟှ သူ့ရဲ့လဲဗ္လန်ထဲဟှို စေလွှတ်လိုက်ဘီး ဝပ်လေဟှို ထီးခိုင်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","သူဟှာ ဝပ်လေစားနေဟှူ ပဲတောန့်လေဟှို စားရှင်ဟှူစိ ဖြစ်လာလေဟှယ်။ အယ်ဘေမဲ့ ဖယ်သူလည်း သူ့ဟှို စားဇာကျွေးဟှို့သူ မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","နော့‑က်ဆောင်းမာ သူဟှာ သိတရား ဝမ်လာဘီး ‘ငါ့ဖရဲ့ လောက်သမားလေ ဂူလောင်းဟှာ ဗိုက်ဝအောန် စားနေရဂေ့ဟှယ်။ ငါဟှ အယ်မာ ငတ်ပြတ်နေဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ငါ့ဖနားဟှို သွားဘီး “ဖ၊ နို့ဟှာ ကောန်းဂန်ဟှိုရော၊ နို့ဖဟှိုရော ပြစ်မှားမိဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","နို့ဟှို သား ဆိုဘီး ခေါ်ဟှို့ထိုက်ဟှ။ နို့ဖရဲ့ လောက်သမား တယော့‑က်မျိုးဘဲ့ ပြုမှုပါ” ဆိုဘီး ပြောမယ်’ ဆိုဘီး ကြံစည်ရှိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","အယ်ကြောန့် သူဟှာ ထဘီး ဖနားဟှို ပ္လန်ဟှားဟှယ်။ “သူဟှာ ဟှိုးဝီးမာရှိနေဒူးမာ သူ့ရဲ့ဖဟှ သားဟှို ဗြင်လိုက်ဟှူ ခီမာ သနားစိ ဖြစ်လာဟှူကြောန့် ပ္လေးလာဘီး၊ သူ့ဟှို ပိုက်ဘီး နမ်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","သားဟှာ ‘ဖ၊ နို့ဟှာ ကောန်းဂန်ဟှိုရော၊ နို့ဖဟှိုရော ပြစ်မှားမိဘီ။ နို့ဟှို သား ဆိုဘီး ခေါ်ဟှို့ထိုက်ဟှ’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","အယ်ဘေမဲ့ ဖဟှ စေခံလေဟှို ခေါ်လိုက်ဘီး ‘ဗြန်းဗြန်လောက်! ကောန်းဆောင်း ဝတ်လောင်ရှယ်ဟှို ယူလာဘီးဟှာ သူ့ဟှို ဝတ်ပေးဂေ့။ သူ့လတ်မာ လတ်စွပ်ဟှို စွပ်ပေးဘီး သူ့ရဲ့ခေမာ ခေနပ်ဟှို စီးပေးဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","အယ်ဘီးဟှာ ကောန်းဆောင်း နွားသားဂန်းဟှို သွားဘီးဟှာ သတ်ဂေ့။ နို့လေ စားသော့‑က်ဗွဲဂီးဟှို လောက်ဂေ့ဇို့! ");
INSERT INTO tvn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါ့သားဟှာ ရင်းရင်ဒူးဟှ သေဟှားဘေမဲ့ ခုပ္လန်ရှင်ဟှားဘီ။ ရင်းရင်ဒူးဟှ ပျော့‑က်ဟှားဘေမဲ့ ခုပ္လန်တွိဟှားဘီ’ ဆိုဘီး ပြောလေဟှယ်။ အယ်ဘီးန စားသော့‑က်ဗွဲဂီးဟှို စပြုဂေ့လေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“အယ်ခီမာဘဲ့ သားဂီးဟှာ လဲဗ္လန်ဟှနေ အီဟှို ပ္လန်လာလေဟှယ်။ အီနားဟှို ရော့‑က်လာဟှူ ခီမာ တီးမှုသံလေ၊ ကခူသံလေဟှို ကြားရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","အယ်ကြောန့် စေခံတယော့‑က်ဟှို ခေါ်ဘီး ‘ဖြားဇာလေ ဖြစ်နေဂေ့နူး။’ ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","စေခံဟှ ‘သင့်ရဲ့ညီဟှာ ဘေးတွိဘဲ့န ပ္လန်ရော့‑က်လာဟှူကြောန့် သင့်ရဲ့ဖဟှ ကောန်းဆောင်း နွားသားဂန်းဟှို သတ်ဘီးဟှာ စားသော့‑က်ဗွဲဂီး လောက်ပေးနေဟှယ်’ ဆိုဘီး ပ္လန်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","သားဂီးဟှာ ရရာတိုင်း မျစ်ဘီးဟှာ အီထဲဟှို ဝမ်ဘဲန နေလေဟှယ်။ အယ်ကြောန့် သူ့ဖဟှာ ပ္လန်ဟှို ထွပ်လာဘီးဟှာ သူ့ဟှို ဖျောန်းဖျလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","အယ်ဘေမဲ့ သူဟှာ ဖဟှို ‘နို့ဟှာ နှစ်လေဘောင်ဂီး ကျွန်တယော့‑က်မျိုး နို့ဖတွပ် လောက်လောက်ပေးဟှယ်။ နို့ဖရဲ့ မိန့်ဟှိုလည်း မြဲဒမ်း နားထောန်ဟှယ်။ အယ်ဘေမဲ့ နို့ဖဟှာ နို့ဟှို ဖြားဇာပေးဖူးနူး။ နို့ငယ်ဂျင်းလေနတူးဒူ စားသော့‑က်ဗွဲလောက်ဟှို့တွပ် ဘဲ့တကောန်ဟှိုမျှ ပေးဖူးဟှ! ");
INSERT INTO tvn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","အယ်ဘေမဲ့ နို့ဖရဲ့ အောက်စာ ပစ်စီးလေဟှို မီးမပျစ်လေန ပျော်ပါးဖ္လူးစားပစ်ဘီး ပ္လန်လာဟှူ အယ်သားတွပ် ဆိုဘီး ကောန်းဆောင်း နွားသားဂန်းဟှို သတ်ဘီးကျွေးဟှယ်!’ ဆိုဘီး ပ္လန်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ဖဟှ ‘ငါ့သား၊ သားဟှ ဖနတူးဒူ မြဲဒမ်းနေဟှယ်။ ဖရဲ့ အောက်စာပစ်စီး ဂူလောင်းဟှာလည်း သားရဲ့ အောက်စာပစ်စီးလေ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","အယ်ဘေမဲ့ သားရဲ့ ညီဟှာ ရင်းရင်ဒူးဟှ သေဟှားဘေမဲ့ ခုပ္လန်သတ်ရှင်ဟှားဘီ။ ရင်းရင်ဒူးဟှ ပျော့‑က်ဟှားဘေမဲ့ ခုပ္လန်တွိဟှားဘီ။ အယ်ကြောန့် နို့လေဟှာ ဝန်းသာဘီး ပွဲလောက်နေဟှယ်’ ဆိုဘီး ပ္လန်ပြောလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ယေရှုဟှာ တဗဲ့တော်လေဟှို “ဌေးတယော့‑က်မာ ဘဏ္ဍာစိုး တယော့‑က် ရှိဟှယ်။ အယ်ဘဏ္ဍာစိုးဟှာ ဌေးရဲ့ အောက်စာ ပစ်စီးလေဟှို ဖ္လူးစားပစ်နေဟှယ် ဆိုဘီး ဌေးဟှို လာပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","အယ်ကြောန့် ဌေးဟှ ဘဏ္ဍာစိုးဟှို ခေါ်ဘီး ‘နန့်ကြောန်းလေ ငါကြားရဇာလေဟှ ဖြားလေနူး။ နန့်ဟှို ငါ့ရဲ့ ဘဏ္ဍာစိုးဖြစ်န ဆစ်ဘီး ထားနိုင်ဟှို့မှုဘီ။ အယ်ကြောန့် နန့်ရဲ့ လောက်ငန်းနဆိုင်ဟှူု စာရင်းလေဟှို တန်ပြပါ’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ဘဏ္ဍာစိုးဟှ ‘ငါ့သခင်ဟှ ငါ့ဟှို လောက်ဖ္လုလိုက်ဘီ။ ငါ ဖယ်မျိုးလောက်ရမယ်နူး။ ငါ့မာ မ္လေတူးဟှို့ ခွန်အားလည်း မှေ့ဟှ။ တောန်းစားဟှို့လည်း ငါယှစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ဘဏ္ဍာစိုး ရာထူးဟှနေ ငါပ္လုဟှားဟှူ ခီမာ လူလေဟှာ သူးနို့ရဲ့ အီလေမာ ငါ့ဟှို လတ်ခံအောန် ဖြားမျိုးလောက်ရမယ် ဆိုဇာဟှို ငါသိဘီ!’ ဆိုဘီး ကိုယ့်ကိုယ်ကိုယ် ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","အယ်ကြောန့် သူ့သခင်ဟှို ကပ်ကွီးပေးဇာရှိဟှူ လူလေ ဂူလောင်းဟှို ခေါ်လိုက်ဟှယ်။ ပထမလူဟှို ‘ငါ့သခင်ဟှို ဆပ်ရဟှို့ ကပ်ကွီး ဖယ်မျှရှိနူး’ ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","အယ်လူဟှ ‘ဆီဂါလံ ၈၀၀ ပေးဇာ ရှိပါဟှယ်’ ဆိုဘီး ပ္လန်ဖြေဟှယ်။ ဘဏ္ဍာစိုးဟှ သူ့ဟှို ‘နန့်ရဲ့ ကပ်ကွီးစာရင်းဟှို ယူဘီး ဂါလံ ၄၀၀ ဆိုဘီး ဗြန်းဗြန်ဟှားရေးပါ’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","အယ်ဘီးန နော့‑က်ထပ် တယော့‑က်ဟှို ‘နန့်မာလည်း ကပ်ကွီး ဖယ်မျှရှိဟှယ်နူး’ ဆိုဘီး မေးလေဟှယ်။ သူဟှ ‘ဂျောင်အိ ၁,၀၀၀ ပေးဇာရှိပါဟှယ်’ ဆိုဘီး ပ္လန်ဖြေဟှယ်။ ဘဏ္ဍာစိုးဟှ ‘နန့်ရဲ့ ကပ်ကွီး စားရင်းဟှို ယူဘီး အိ ၈၀၀ ဆိုဘီး ရေးပါ’ ဆိုဘီး သူ့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","သခင်ဟှ အယ်မျိုးရိုးသားဘဲဟှူ ဘဏ္ဍာစိုးရဲ့ ပါးနပ်ဟှူ လောက်ဆောန်မှုတွပ် သူ့ဟှို ချီးကျူးလေဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လောကသားလေဟှာ သူးနို့ရဲ့ လောကီကိစလေ လောက်ဟှူ ခီမာ လန်းသားလေထတ် ပိုဘီး ပါးနပ်ဂေ့ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ယေရှုဟှ “နန်းနို့ဟှို ငါပြောမယ်။ လောက စည်းဇိမ်အားဖြင့် မိဆွေလေ ရအောန်လောက်ဂေ့။ အယ်မျိုးဆိုဟှာ အယ်စည်းဇိမ်လေ ကူဟှားဟှူ ခီမာ သူးနို့ဟှာ နန်းနို့ဟှို ထာဝရအီတော်မာ ကြိုဆိုလတ်ခံလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","သေးငယ်ဟှူ မှုမာ သစ်စာရှိဟှူသူဟှာ ကီးမားဟှူ မှုမာလည်း သစ်စာရှိလေ့မယ်။ သေးငယ်ဟှူ မှုမာ သစ်စာမှေ့ဘဲဟှူ သူဟှာ ကီးမားဟှူ မှုမာလည်း သစ်စာရှိလေ့မယ် မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","အယ်ကြောန့် နန်းနို့ဟှာ လောကစည်းဇိမ်ဟှို သောင်းပြုဟှူ ခီမာ သစ်စာမှေ့ဘဲဟှူသူ ဖြစ်မယ် ဆိုဟှာ စစ်မှန်ဟှူ စည်းဇိမ်ဟှို ဖယ်သူဟှ နန်းနို့ဟှို အပ်မယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","အယ်ဘီးဟှာ တခြားလူရဲ့ အောက်စာပစ်စီးဟှို သောင်းပြုဟှူ ခီမာ သစ်စာမှေ့ဟှ ဆိုဟှာ နန်းနို့ပိုင်ဆိုင်ဟှို့ အောက်စာပစ်စီးဟှို ဖယ်သူဟှာ ပေးဂေ့မယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ဖယ်ကျွန်ဘဲ့ဖြစ်ဖြစ် သခင်နှေ့ယော့‑က်ရဲ့ စေဟှို ခံနိုင်ဟှ။ သခင်တယော့‑က်ဟှို မူးဘီး သခင်တယော့‑က်ဟှို ရှစ်လေ့မယ်။ တယော့‑က်ဟှို သစ်စာစောန့်ဘီး တယော့‑က်ဟှို ထီလေးဇားလောက်လေ့မယ်။ နန်းနို့လေဟှာ ဘုရားသခင်န လောကစည်းဇိမ်လေဟှို တပြိုင်ဒဲ စေခံနိုင်ဂေ့ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","အယ်စကားလေဟှို ဖာရိရှဲလေ ကြားရဟှူ ခီမာ ယေရှုဟှို လှောန်ပြောန်ဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့လေဟှာ ကပ်မတ်မားလေ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ယေရှုဟှာ သူးနို့ဟှို “နန်းနို့ဟှာ လူလေရဲ့ ရှေ့မာ ဖြောန့်မတ်ဟန်ဆောန်ဟှယ်။ အယ်ဘေမဲ့ ဘုရားသခင်ဟှာ နန်းနို့ရဲ့ စိနှလောင်းဟှို သိနေဟှယ်။ လူလေ ရရာတိုင်း တန်ဖိုးထားဟှူဇာဟှာ ဘုရားသခင်ရဲ့ ရှေ့မာ ရွံဇာကောန်းဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“မောရှေရဲ့ ပညတ်ကျမ်းန ပရောဖက်ကျမ်းလေဟှာ ဗတ္တိဇံယောဟန် လတ်ထတ်ထိ သတ်ရော့‑က်မှု ရှိဟှယ်။ အယ်ခီဂဒဲဟှနေ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ကြောန်း ဒန်းကောန်းဟှို ဟောပြောဂေ့ဟှယ်။ လူတိုင်းဟှာ အယ်နိုင်ငံတော်ထဲဟှို လုယက် တိုးဝမ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","အယ်ဘေမဲ့ ပညတ်တရားထဲမာ ငယ်ဆောင်းဖြစ်ဟှူ စာလောင်း တလောင်းပျစ်စီးဟှို့ထတ် ကောန်းဂန်ဘောင်န မ္လေဂီး ပျစ်စီးဟှို့ လွယ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ကိုယ့်မယားဟှို ကွာရှင်းဘီးဟှာ တခြားမီးမန အီထောန်ပြုဟှူသူဟှာ အီထောန်ရေးဖော့‑က်ပ္လန်ရှင်းဟှို ကျူးလွန်သူ ဖြစ်ဟှယ်။ ကွာရှင်းဟှားဟှူ မီးမတယော့‑က်န အီထောန်ပြုဟှူ ယော့‑က်ကျားဟှာလည်း အီထောန်ရေးဖော့‑က်ပ္လန်ရှင်းဟှို ကျူးလွန်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“တခါဒူးဟှ ဌေးတယော့‑က်ဟှာ ရရာတိုင်း ဖိုးကီးဟှူ ခရမ်းရောန်ဝတ်ရောင်န ပိချောဟှို ဝတ်ဆင်ဘီး နေ့တိုင်း စည်းဇိမ်ခံစားဘီး နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ဌေးရဲ့ အီခွဗော့‑က်နားမာ လာဇရု နာမယ်ရှိဟှူ ဆင်းရဲသား တယော့‑က်ရှိဘီး သူ့တကောန်လောင်းမာ အိုင်းနာလေ ပေါ့‑က်နေဘီး၊” ");
INSERT INTO tvn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","“သူဟှာ ဌေးရဲ့ စားဗွဲဟှ က္လဟှူ စားကြွင်းစားကျန်လေဟှို စားရဟှို့တွပ် မျှော်နေဟှယ်။ ခွီးလေဟှလည်း သူ့ရဲ့ အိုင်းနာလေဟှို လာဘီး ယစ်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ဆင်းရဲသားဟှာ သေဟှားဟှူ ခီမာ ကောန်းဂန်တမန်လေဟှ သူ့ဟှို အာဗြဟံရဲ့ ဘေးမာ ထိုင်စေဟှို့ သယ်ဆောန်ဟှားလေဟှယ်။ ဌေးလည်း သေဟှားဘီးဟှာ သင်္ဂြိုဟ်ရှင်းဟှို ခံရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","သူဟှာ မရဏာနိုင်ငံမာ ဝေဒနာဟှို ဆိုးဆိုးဝါးဝါး ခံနေရဘီး မော့ကေ့လိုက်ဇာ အာဗြဟံန အာဗြဟံရဲ့ ဘေးမာ လာဇရုဟှိုလည်း ဗြင်လိုက်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","အယ်ကြောန့် သူဟှ ‘ဖအာဗြဟံ! ကျွန်တော့်ဟှို သနားပါ။ ကျွန်တော်ဟှာ အယ်မီးဘောင်ထဲမာ ဝေဒနာဟှို ဆိုးဆိုးဝါးဝါး ခံနေရကြောန့် လာဇရုရဲ့ လတ်ဖျားဟှို ရေဆွတ်ဘီး ကျွန်တော့်လျှာဟှို အေးစေဟှို့ သူ့ဟှို စေလွှတ်ပေးပါ!’ ဆိုဘီး အော်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","အယ်ဘေမဲ့ အာဗြဟံဟှ ‘ငါ့သား၊ နန်ဟှာ သတ်ရှင်ခီဒူးဟှ ကောန်းဟှူဇာလေဟှို လတ်ခံရရှိဘီး လာဇရုဟှာ ကောန်းဘဲဟှူဇာလေဟှို လတ်ခံရရှိဟှားဟှယ် ဆိုဇာဟှို အော့‑က်မေ့ပါ။ အယ်ဘေမဲ့ ခု သူဟှာ အယ်နေရာမာ သတ်သာရှင်းရှိဘီး နန်ဟှ ဝေဒနာဟှို ဆိုးဆိုးဝါးဝါး ခံစားနေရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","အယ်ဘီးဟှာ နန်းနို့န နို့လေကြားမာ ရရာတိုင်း နတ်ဟှူချော့‑က်ဂီး တခုရှိဟှယ်။ အယ်ကြောန့် နန်းနို့ဟှလည်း နို့လေနားဟှို ကူးနိုင်ဂေ့ဟှ။ နို့လေဟှလည်း နန်းနို့နားဟှို ကူးနိုင်ဂေ့ဟှ’ ဆိုဘီး ပ္လန်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ဌေးဟှ ‘ဖ၊ အယ်ဆိုဟှာ လာဇရုဟှို ကျွန်တော့်ဖရဲ့ အီဟှို စေလွှတ်ပေးဟှို့တွပ် ကျွန်တော် တောန်းလျှော့‑က်ပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ကျွန်တော့်မာ ညီငါးယော့‑က်ရှိပါဟှယ်။ သူးနို့လေဟှို ဝေဒနာခံစားရဟှူ အယ်နေရာဟှို ရော့‑က်ဘဲအောန် သူးနို့ဟှို ဒိပေးဟှို့ လာဇရုဟှို သွားစေပါ’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","အာဗြဟံဟှ ‘နန့်ရဲ့ ညီလေဟှို ဒိပေးဟှို့ မောရှေန ပရောဖက်လေ ရှိဟှယ်။ သူးနို့စကားလေဟှို နားထောန်ရမယ်’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ဌေးဟှ ‘ဖအာဗြဟံ၊ အယ်မျိုး မှုဟှ! သေရာဟှ ပ္လန်ရှင်လာဟှူ ယော့‑က်ယော့‑က်ဟှို သူးနို့နားဟှို သွားစေမယ် ဆိုဟှာ သူးနို့ဟှာ နောန်ဒရလေ့မယ်’ ဆိုဘီး ပ္လန်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","အယ်ဘေမဲ့ အာဗြဟံဟှ ‘သူးနို့လေဟှာ မောရှေန ပရောဖက်လေရဲ့ စကားဟှို နားထောန်ဂေ့ဟှ ဆိုဟှာ သေရာဟှနေ ပ္လန်ရှင်လာဟှူ ယော့‑က်ယော့‑က်ဟှိုလည်း လတ်ခံယောင်ကြည်ဂေ့ဟှို့ မှုဟှ’ ဆိုဘီး ပြောလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ယေရှုဟှာ တဗဲ့တော်လေဟှို “လူလေဟှို ပြစ်ထဲက္လအောန် လောက်ဟှို့ မှားယွင်းဇာလေ ရှိရမယ်။ အယ်ဘေမဲ့ ပြစ်ထဲက္လအောန် မှားယွင်းဇာလေ လောက်ဟှူ သူဟှာ အမင်္ဂလာရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","အယ်လူဟှာ အယ်မျိုး သားဂန်းတယော့‑က်ဟှို မှားယွင်းစေရှင်းထတ် ကိုယ့်လည်ဗန်းမာ ကီးမားဟှူ က္လိဆောင်ဟှို ဆွဲဘီးဟှာ ပန်လယ်ထဲမာ ပစ်ခ္လခံရရှင်းဟှာ ပိုဘီး ကောန်းအူးမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","အယ်ကြောန့် ဖြားဘဲ့လောက်လောက် ဒိထားဂေ့! “နန့်ရဲ့ ညီကိုဟှ နန့်ဟှို ပြစ်မှားမယ် ဆိုဟှာ သူ့ဟှို ဆောင်းမပါ။ သူဟှာ နောန်ဒရမယ် ဆိုဟှာ ခွမ့်လွှတ်လိုက်ပါ။ ");
INSERT INTO tvn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","သူ့ဟှ နန့်ဟှို တရစ်မာ ခွန်နစ်ခါ ပြစ်မှားဘီးဟှာ ခွန်နစ်ခါလောင်းလောင်း နန့်နားဟှို လာဘီးဟှာ ‘ငါနောန်ဒရဘီ’ ဆိုဘီး လာပြောမယ် ဆိုဟှာ သူ့ဟှို ခွမ့်လွှတ်ရမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","တမန်တော်လေဟှ သခင်ဘုရားဟှို “ကျွန်တော့်ဟှားလေရဲ့ ယောင်ကြည်ရှင်းဟှို တိုးလာအောန် လောက်ပေးတော်မူပါ!” ဆိုဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","သခင်ဘုရားဟှ “နန်းနို့မာ မုညင်းစေ့လော့‑က် ယောင်ကြည်ရှင်း ရှိမယ် ဆိုဟှာ အယ်ပိုးစားဗန်ဟှို ‘ပြစ်ဟှနေ က္လော့ဘီးဟှာ ပန်လယ်ထဲမာ စိုက်နေစေ!’ ဆိုဘီး နန်းနို့ဟှ ပြောမယ် ဆိုဟှာ နန်းနို့ပြောဟှူတိုင်း အယ်ပန်ဟှ နားထောန်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“နန်းနို့ထဲဟှ တယော့‑က်မာ လယ်ထွန်ဟှို့၊ သိုးထီးဟှို့ ခိုင်းဟှားဟှူ စေခံတယော့‑က် ရှိဟှယ်။ သူဟှာ လဲဗ္လန်ဟှ ပ္လန်လာဟှူ ခီမာ ဗြန်းဗြန်လာဘီး စားသော့‑က်ဂေ့ ဆိုဘီးဟှာ နန်းနို့ထဲမာ ဖယ်သူပြောမယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","လောင်းဝပြောဟှို့ မှုဟှ! အယ်မျိုးပြောဟှို့စား ‘ငါ့တွပ်စားဇာပြင်ပါ။ ငါစားသော့‑က်နေဒူးမာ ခါးစဲဘီး ငါ့ဟှို စေခံပါ။ ငါစားဘီးမှ နန်စားရမယ်’ ဆိုဘီး ပြောလေ့မယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","စေခံဟှာ ခိုင်းဟှားဟှူတိုင်း လောက်ပေးဟှူကြောန့် သူ့ဟှို ကျေးဇူးတန်ရဟှို့လော။ ");
INSERT INTO tvn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","အယ်မျိုးဘဲ့ နန်းနို့ဟှို ခိုင်းဟှားဟှူ လောက်လေ ဂူလောင်း လောက်ဘီးဟှားဟှူု ခီမာ ‘နို့လေဟှာ သာမန်စေခံလေ ဖြစ်ဘီး နို့လေရဲ့ တာဝန်ဟှို လောက်ဆောန်ဇာဘဲ့ ဖြစ်ဟှယ်’ ဆိုဘီး ပြောဂေ့ပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ယေရှုဟှာ ယေရုရှလင်ဗြို့ဟှို ကြွဟှားဟှူ ခီမာ ရှမာရိပြည်န ဂါလိလဲပြည် နယ်စပ်ဟှနေဘီး ကြွတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ကိုယ်တော်ဟှာ ဝါတဝါထဲဟှို ဝမ်တော်မူဟှူ ခီမာ နူနာ ဆယ်ယော့‑က်ဟှာ ကိုယ်တော့်ဟှို လာတွိဂေ့ဟှယ်။ သူးနို့လေဟှာ ဝီးဝီးမာ ရပ်နေဘီး ");
INSERT INTO tvn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“သခင်ယေရှု! ကျွန်တော့်ဟှားလေဟှို သနားတော်မူပါ!” ဆိုဘီး အော်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ယေရှုဟှာ သူးနို့ဟှို ဗြင်တော်မူဟှူ ခီမာ “နန်းနို့ဟှာ ယဇ်ပုရောဟိတ်လေနားဟှို သွားဘီး မိမိကိုယ်ဟှို ပြဂေ့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ သူးနို့ဟှာ သွားနေဒူးမာဘဲ့ သန့်ရှင်းဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","သူးနို့ထဲဟှ တယော့‑က်ဟှာ ရောဂါပျော့‑က်ဟှားဘီ ဆိုဇာဟှို ဗြင်ဟှူ ခီမာ ဘုရားသခင်ဟှို သံက္လယ်ဂီးန ချီးမွမ်းဘီး ပ္လန်လာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ယေရှုရဲ့ ခေတော်ရင်းမာ ပျပ်ဝပ်ဘီးဟှာ ကိုယ်တော့်ဟှို ကျေးဇူးတန်လေဟှယ်။ အယ်လူဟှာ ရှမာရိလူ တယော့‑က်ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ယေရှုဟှ “လူဆယ်ယော့‑က်လောင်း သန့်ရှင်းဟှားဟှယ် မှုဟှလော။ ကျန်ဟှူ ကိုးယော့‑က်ဟှ ဖယ်မာနူး။ ");
INSERT INTO tvn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ဖြားဖြစ်ကြောန့် အယ်လူမျိုးခြား တယော့‑က်ဘဲ့ ပ္လန်လာဘီး ဘုရားသခင်ဟှို ချီးမွမ်းရနူး။” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","အယ်ဘီးန ယေရှုဟှ သူ့ဟှို “ထဘီးသွားဝေါ့၊ နန့်ရဲ့ ယောင်ကြည်ရှင်းဟှ နန့်ဟှို ကျန်းမာစေဘီ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ဖာရိရှဲတချို့ဟှ ယေရှုဟှို ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှာ ဖယ်ခီမာ တည်ထောန်မယ်နူး။ ဆိုဘီး မေးဂေ့ဟှယ်။ ကိုယ်တော်ဟှ “ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှာ ဗြင်ရဟှူ နိုင်ငံမျိုး တည်ထောန်ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","‘ကေ့ကေ့။ နိုင်ငံတော်ဟှ အယ်မာရှိဟှယ်! ဟောက်မာရှိဟှယ်!’ ဆိုဘီး ဖယ်သူလည်း ပြောနိုင်လေ့မယ် မှုဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နိုင်ငံတော်ဟှ နန်းနို့ထဲမာ ရှိနေကြောန့် ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","အယ်ဘီးန ကိုယ်တော်ဟှာ တဗဲ့တော်လေဟှို “နန်းနို့ ဗြင်ရှင်နေဟှူ လူ့သားရဲ့ နေ့ရစ်တရစ် ရော့‑က်လာလေ့မယ်။ အယ်ဘေမဲ့ နန်းနို့ ဗြင်ရလေ့မယ် မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","လူလေဟှ ‘ကေ့ကေ့၊ လူ့ရဲ့သားဟှာ ဟောက်မာရှိဟှယ်! အယ်မာရှိဟှယ်!’ ဆိုဘီး နန်းနို့ဟှို ပြောလေ့မယ်။ အယ်ဘေမဲ့ လိုက်ရှာဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လျှပ်စစ်ဟှာ ဖျတ်ဟှူ ခီမာ ကောန်းဂန်တဖတ်ဟှနေ တခြားတဖတ်ထိ လန်းဟှားမျိုးဘဲ့ လူ့ရဲ့သားဟှာ ပ္လန်လာဟှူ နေ့ရစ်မာလည်း အယ်မျိုးဘဲ့ ဖြစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","အယ်ဘေမဲ့ သူဟှာ ရင်ဦးဆောင်း နာကျင်ရှင်းလေ ဘောင်ဂီး ခံရဘီး ခုခေတ် လူလေရဲ့ ငြင်းပယ်ရှင်းလေဟှို ခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","နောဧရဲ့ နေ့ရစ်လေမာ ဖြစ်ဟှားမျိုးဘဲ့ လူ့ရဲ့သား ပ္လန်လာဟှူ နေ့ရစ်လေမာလည်း ဖြစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","နောဧဟှာ သန်းဖောထဲဟှို ဝမ်ဟှူ နေ့ရစ်တိုင်အောန် လူလေဟှာ စားလိုက်၊ သော့‑က်လိုက်၊ လတ်ထပ်လိုက် လောက်နေဂေ့ဟှယ်။ အယ်ဘီးန ရေကီးလာဘီး သူးနို့လေ ဂူလောင်းဟှို ဖျစ်ဆီးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","အယ်မျိုးဘဲ့ လောတရဲ့ နေ့ရစ်လေမာလည်း လူတိုင်းဟှာ စားလိုက်၊ သော့‑က်လိုက်၊ ရောန်းလိုက်၊ ဝယ်လိုက်၊ စိုက်ပျိုးလိုက်၊ တည်ဆော့‑က်လိုက်န လောက်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","သောဒုံဗြို့ဟှနေ လောတ ထွပ်ဟှူနေ့မာ ကောန်းဂန်ဟှနေ ကန့်န မီးဝါခ္လလိုက်ဘီး သူးနို့လေ ဂူလောင်းဟှို ဖျစ်စီးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","လူ့ရဲ့သား ပေါ်ထွပ်ဟှူ နေ့ရစ်မာလည်း အယ်မျိုးဘဲ့ ဖြစ်လေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“အယ်မျိုးနေ့မာ အီးခေါန်မိုးထတ်မာရှိဟှူ လူဟှို အီထဲမာရှိဟှူ ပစ်စီးလေဟှို ယူဟှို့တွပ် အော့‑က်ဟှို ဆင်းစေန။ အယ်မျိုးဘဲ လဲဗ္လန်ထဲမာရှိနေဟှူ လူလည်း အီဟှို ပ္လန်စေန။ ");
INSERT INTO tvn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","လောတရဲ့ မယားဟှို အော့‑က်မေ့ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ကိုယ့်သတ်ဟှို ကယ်ရှင်ဟှူ လူဟှာ သတ်ရှောင်းလေ့မယ်။ ကိုယ့်သတ်ဟှို ရှောင်းစေဟှူ သူဟှာ သတ်ဟှို ကယ်တန်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","နန်းနို့ဟှို ငါပြောမယ်၊ အယ်ညဉ့်မာဘဲ့ အိယာတခုဒဲမာ တူးဒူအိနေဟှူ လူနှေ့ယော့‑က်ထဲဟှ တယော့‑က်ဟှို သီးယူဟှားဘီးဟှာ တယော့‑က်ဟှ ကျန်ရစ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","တူးဒူက္လိဆောင်က္လိနေဟှူ မီးမနှေ့ယော့‑က်ထဲဟှ တယော့‑က်ဟှို သီးယူဟှားဘီးဟှာ တယော့‑က်ဟှ ကျန်ရစ်လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","တဗဲ့တော်လေဟှာ ကိုယ်တော့်ဟှို “သခင်၊ အယ်မူဇာလေဟှ ဖယ်နားမာ ဖြစ်ဟှို့နူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ယေရှုဟှ “သေကောန်ရှိဟှူ နေရာမာ လင်းတငှတ်လေ စုနေဂေ့လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","အယ်ဘီးန ယေရှုဟှာ တဗဲ့တော်လေဟှို လောင်းဝ လတ်လျှော့ဘဲန မြဲဒမ်း ဆုတောန်းရမယ် ဆိုဘီး သူးနို့ဟှို သွန်သန်ဟှို့တွပ် ပေါင်ဥပမာန မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“ဗြို့တဗြို့မာ ဘုရားသခင်ဟှိုလည်း ကြော့‑က်ဘဲဟှူ၊ လူလေဟှိုလည်း ရိုသေဘဲဟှူ တရားသူဂီး တယော့‑က်ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","အယ်ဗြို့မာရှိဟှူ မောက်ဆိုးမ တယော့‑က်ဟှာ သူ့နားဟှို တခီလောင်းလာဘီး ‘ကျွန်မဟှို တရားစွဲဟှူသူဟှို မျှမျှတတ စီရင်ပေးပါ’ ဆိုဘီး တောန်းဗန်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ခီကြာဂီး တရားသူဂီးဟှာ အယ်မောက်ဆိုးမရဲ့ လျှော့‑က်ဟှားချစ်ဟှို ငြင်းဆန်လေဟှယ်။ အယ်ဘေမဲ့ နော့‑က်ဆောင်းမာ သူဟှာ ‘ငါဟှာ ဘုရားသခင်ဟှိုလည်း ကြော့‑က်ဟှ။ လူလေဟှိုလည်း ရိုသေဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","အယ်ဘေမဲ့လည်း အယ်မောက်ဆိုးမဟှာ ငါဟှို နှော့‑က်ယှစ်ပေးနေဟှူကြောန့် သူ့မှုဟှို တရားနည်းလမ်းတိုင်း စီရင်မယ်။ အယ်မျိုးလောက်ဟှ ဆိုဟှာ သူဟှာ တခီလောင်းလာဘီး နော့က်ဆောင်းမာ ငါဟှို ပန်ဗန်းစေလေ့မယ်!’ ဆိုဘီး ကိုယ့်ကိုယ်ကိုယ် ပြောလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","သခင်ဘုရားဟှာ ဆစ်ဘီး “တရားဘဲဟှူ တရားသူဂီး ပြောလိုက်ဇာဟှို နားထောန်ကေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ဘုရားသခင်လည်း သူ့နားဟှို နေ့ရောညဉ့်ပါ ကူညီဟှို့တွပ် အော်ဟစ်နေဟှူ၊ သူဝီးကော့‑က်ဟှားဟှူ လူလေတွပ် စီရင်ဘဲန နေဟှို့လော။ ကိုယ်တော်ဟှာ အယ်လူလေဟှို ကူညီဟှို့တွပ် ခီဆွဲနေဟှို့လော။ ");
INSERT INTO tvn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","နန်းနို့ဟှို ငါပြောမယ်။ ကိုယ်တော်ဟှာ သူးနို့လေတွပ် ဗြန်းဗြန်ဟှား တရားစီရင်လေ့မယ်။ အယ်ဘေမဲ့ လူ့ရဲ့သား ရော့‑က်လာဟှူ ခီမာ ယောင်ကြည်ရှင်းဟှို မ္လေဂီးထတ်မာ တွိရအူးမယ် ဘဲ့လော။” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ကိုယ့်ဖြောန့်မတ်ရှင်းဟှို အားကိုးဘီး တပါးသူဟှို ထန်သေးတတ်ဟှူ သူလေတွပ် ယေရှုဟှာ အယ်ပေါင်ဥပမာန မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“တခါဒူးဟှ လူနှေ့ယော့‑က်ဟှာ ဆုတောန်းဟှို့ ဆိုဘီး ဗိမာန်တော်ဟှို သွားဂေ့ဟှယ်။ တယော့‑က်ဟှ ဖာရိရှဲ ဖြစ်ဘီး နော့‑က်တယော့‑က်ဟှ ခွန်ကော့‑က်မား ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ဖာရိရှဲဟှာ မတ်တတ်ရပ်ဘီး ‘ဘုရားသခင်၊ ကျွန်တော်ဟှာ တခြားသူလေမျိုး လောဘကီးဟှူသူ၊ ဖြောန့်မတ်ဘဲဟှူသူ၊ အီထောန်ရေးဖော့‑က်ပ္လန်ဟှူသူ မုဘဲဟှူကြောန့် ကျေးဇူးတန်ဟှယ်။ ကျွန်တော်ဟှာ အယ်ခွန်ကော့‑က်မားမျိုးလည်း မုဘဲဟှူကြောန့် ကိုယ်တော့်ဟှို ကျေးဇူးတန်ဟှယ်’ ဆိုဘီး ဆုတောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","‘ကျွန်တော်ဟှာ တဘတ်မာ နှေ့ရစ်စာရှောန်ဘီး ကျွန်တော့်ဝမ်ငွေ ဂူလောင်းရဲ့ ဆယ်ဖို့တဖို့ဟှိုလည်း ပေးဟှယ်’ ဆိုဘီး ဆုတောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","အယ်ဘေမဲ့ ခွန်ကော့‑က်မားဟှာ ဝီးမာဘဲ့ရပ်နေဘီး ကောန်းဂန်ဟှိုလည်း မော်ကေ့ရဲဘဲန ‘ဘုရားသခင်၊ ပြစ်သား ကျွန်တော့်ဟှို သနားတော်မူပါ!’ ဆိုဘီး ရင်ဖတ်ဟှို ထုဘီးဟှာ ဆုတောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","နန်းနို့ဟှို ငါပြောမယ်၊ အယ်ခွန်ကော့‑က်မားဟှာ ဘုရားသခင်ရှေ့မာ သူတော်ကောန်းဖြစ်န အီဟှို ပ္လန်ဟှားရဟှယ်။ ဖာရိရှဲဟှ အယ်မျိုးမှုဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူ့ကိုယ်သူ ချီးမြှော့‑က်ဟှူသူဟှာ နှိခ္လခံရဘီး သူ့ကိုယ်သူ နှိခ္လဟှူသူဟှာ ချီးမြှော့‑က်ရှင်းခံရလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","လူတချို့ဟှာ သူးနို့သားဂန်းလေထတ်မာ လတ်တန်ပေးဟှို့တွပ် ယေရှုနားဟှို ခေါ်ဆောန်လာဟှယ်။ တဗဲ့တော်လေဟှ အယ်မူဇာဟှို ဗြင်ဟှူ ခီမာ သူးနို့ဟှို ပြစ်တန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","အယ်ဘေမဲ့ ယေရှုဟှာ သားဂန်းလေဟှို သူ့နားဟှို ခေါ်လိုက်ဘီး “သားဂန်းလေဟှာ ငါနားဟှို လာပါလေစေ။ သူးနို့ဟှို တားဂေ့န။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှာ အယ်သူလေရဲ့ နိုင်ငံဖြစ်ဟှူုကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို သားဂန်းတယော့‑က်မျိုး လတ်ခံဘဲဟှူ သူဟှာ နိုင်ငံတော်ဟှို ဝမ်ရလေ့ဟှို့ မုဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ယုဒခေါန်းဆောန်တယော့‑က်ဟှ ယေရှုဟှို “ကောန်းမြတ်ဟှူဆရာ၊ ထာဝရသတ်ဟှို လတ်ခံရရှိဟှို့တွပ် ဖြားမျိုးလောက်ရဟှို့နူး။” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ယေရှုဟှ “ငါ့ဟှို ကောန်းမြတ်ဟှူသူ ဆိုဘီး ဖြားဖြစ်ကြောန့် ခေါ်ရနူး။ ဘုရားသခင်မှတပါး ကောန်းမြတ်ဟှူသူ ဖယ်သူလည်း မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","‘အီထောန်ရေးဖော့‑က်ပ္လန်န၊ လူသတ်န၊ ခိုးန၊ လီညာဘီး သတ်သေခံန၊ မိဖဟှို ရိုသေရမယ်’ ဆိုဘီး ပညတ်တော်လေဟှို နန်သိဟှယ် မှုဟှလော။” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","အယ်သူဟှ “ကျွန်တော်ဟှာ ငဲငယ်ဂဒဲဟှ အယ်ပညတ်လေ ဂူလောင်းဟှို လိုက်ရှော့‑က်ပီးဘီ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","အယ်စကားဟှို ကြားရခီမာ ယေရှုဟှ “နန်လောက်ရဟှို့ တခုကျန်သေးဟှယ်။ နန့်မာရှိဇာလေ ဂူလောင်းဟှို ရောန်းဘီး ရလာဟှူ ကပ်ဟှို ဆင်းရဲသားလေဟှို ပေးပါ။ အယ်ဆိုဟှာ နန်ဟှာ ကောန်းဂန်ဘောင်မာ ဘဏ္ဍာဟှို ရလေ့မယ်။ အယ်ဘီးမှ ပ္လန်လာဘီးဟှာ ငါ့နော့‑က်ဟှို လိုက်ရမယ်” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","အယ်သူဟှာ ကိုယ်တော်ရဲ့ စကားတော်ဟှို ကြားရဟှူ ခီမာ ရရာတိုင်း ဝန်းနဲဟှားဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူ့မာအောက်စာလေ ဘောင်ဂီးရှိဟှူကြောန့် ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ယေရှုဟှာ အယ်သူ ရရာတိုင်း ဝန်းနဲဟှားဟှူဇာဟှို ဗြင်တော်မူဟှူ ခီမာ “ဌေးသားလေဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို ဝမ်ဟှို့ ရရာတိုင်း ခတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ဌေးသားဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ထဲဟှို ဝမ်ဟှို့ထတ် ကုလားအုတ်ဟှာ အပ်ပေါ့‑က်ထဲဟှို ဝမ်ဟှို့ ပိုဘီး လွယ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","အယ်စကားဟှို ကြားရဟှူ သူလေဟှာ ကိုယ်တော့်ဟှို “အယ်မျိုးဆိုဟှာ ဖယ်သူလေ ကယ်တန်ရှင်း ခံရနိုင်ဟှို့နူး။” ဆိုဘီး မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ယေရှုဟှ “လူလေတွပ် ဖြစ်နိုင်ဘဲဟှူ ဇာလေဟှာ ဘုရားသခင်တွပ် ဖြစ်နိုင်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","အယ်ဘီးန ပေတရုဟှ “ကျွန်တော့်ဟှားလေဟှာ ရှိမျှဂူလောင်းဟှို ထားဟှားရစ်ဘီး ကိုယ်တော် နော့‑က်ဟှို လိုက်ဂေ့ဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ယေရှုဟှာ သူးနို့ဟှို “နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်တွပ် အီ၊ မယား၊ ညီကိုလေ၊ မိဖလေ၊ သားမီးလေဟှို စွန့်ဟှူ သူဟှာ ");
INSERT INTO tvn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ခုဘဝမာ ကျိုးဘောင်ဂီး ရရှိဘီးဟှာ နောန်ဘဝမာလည်း ထာဝရသတ်ဟှို ရလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ယေရှုဟှ တဗဲ့တော် ဆယ့်နှေ့ပါးဟှို နီးနားဟှို ခေါ်ဘီးဟှာ “နားထောန်ဂေ့! နို့လေဟှာ ယေရုရှလင်ဗြို့ဟှို သွားနေဂေ့ဟှယ်။ အယ်နေရာမာ လူ့ရဲ့သားန သက်ဆိုင်ဟှူ ပရောဖက်လေ ရေးဟှားဇာလေ ဂူလောင်းဟှာ ပ္လဲ့ဇောင်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","လူ့ရဲ့သားဟှို လှောန်ပြောန်၊ သရော်ဘီး ထွီးရယ်န ထွီးမယ့် လူမျိုးခြားလေ လတ်ထဲဟှို အပ်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","သူးနို့လေဟှာ ကီဒန်ပေးဘီး သတ်ဂေ့လေ့မယ်။ အယ်ဘေမဲ့လည်း လူ့ရဲ့သားဟှာ သောင်းရစ်မြော့‑က်ဟှူ နေ့မာ ထမြော့‑က်လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","အယ်ဘေမဲ့လည်း တဗဲ့တော်လေဟှာ အယ်မူဇာလေဟှို တခုလည်း ဘောပေါ့‑က်ဂေ့ဟှ။ အယ်မူဇာရဲ့ ဓိပါယ်ဟှို ဖောင်းကွယ်ဟှားဟှူကြောန့် ယေရှု မိန့်တော်မူနေဟှူ ဇာလေဟှို နားလည်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ယေရှုဟှာ ယေရိခေါဗြို့နားဟှို ရော့‑က်လာတော်မူဟှူ ခီမာ မျစ်ကန်းတယော့‑က်ဟှာ လမ်းဘေးမာ ထိုင်ဘီး တောန်းစားနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","သူဟှာ လူအောက်ဂီး ဖြတ်ဟှားဇာဟှို ကြားလိုက်ဟှူ ခီမာ “ဖြားဇာလေဖြစ်နေနူး” ဆိုဘီး မေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","သူးနို့ဟှ “နာဇရက်ဗြို့သားယေရှု ဖြတ်ဟှားတော်မူဟှယ်” ဆိုဘီး သူ့ဟှို ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","အယ်သူဟှ “ဒါဝိဒ်ရဲ့သားတော်! ယေရှု! ကျွန်တော့်ဟှို သနားတော်မူပါ!” ဆိုဘီး အော်ဟစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ရှေ့မာရှိနေဟှူ လူလေဟှ သူ့ဟှို ပြစ်တန်ဂေ့ဘီး တိတိဟှားနေဟှို့ ပြောဂေ့ဟှယ်။ အယ်ဘေမဲ့လည်း သူဟှ “ဒါဝိဒ်ရဲ့သား! ကျွန်တော့်ဟှို သနားတော်မူပါ!” ဆိုဘီး ပိုဘီး အော်ဟစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","အယ်ကြောန့် ယေရှုဟှာ ရပ်နားဘီး မျစ်ကန်းဟှို သူ့နားဟှို ခေါ်လာဟှို့ မိန့်ပေးတော်မူလေဟှယ်။ အယ်သူဟှာ နီးနားဟှို ရော့‑က်လာဟှူ ခီမာ ယေရှုဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“နန့်တွပ် ငါ့ဟှို ဖြားဇာလောက်စေရှင်ဟှယ်နူး။” ဆိုဘီး သူ့ဟှို မေးတော်မူလေဟှယ်။ သူဟှ “သခင်၊ ကျွန်တော်ဟှို မျစ်စိဗြင်စေတော်မူပါ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ယေရှုဟှ “မျစ်စိဗြင်စေ! နန့်ရဲ့ ယောင်ကြည်ရှင်းဟှ နန့်ဟှို ကယ်တန်ဘီ” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ရှစ်ရှင်းဘဲ့ သူဟှာ ဗြင်ဟှားလေဟှယ်။ အယ်ဘီးန ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟှို ချီးမွမ်းဘီးဟှာ ယေရှု နော့‑က်ဟှို လိုက်လေဟှယ်။ အယ်မူဇာဟှို ဗြင်လိုက်ဟှူ လူအောက်ဂီးဟှာ ဘုရားသခင်ဟှို ချီးမွမ်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ယေရှုဟှာ ယေရိခေါဗြို့ထဲဟှို ဝမ်ဟှားဘီးဟှာ အယ်ဗြို့ဟှို ဖြတ်ဟှားတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","အယ်နေရာမာ ဇက္ခဲနာမယ်ရှိဟှူ လူတယော့‑က်ရှိဟှယ်။ သူဟှာ ခွန်ခေါန်းဖြစ်ဘီး ဌေးသားလည်း ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","သူဟှာ ယေရှုဟှို ဖယ်သူဖြစ်ဟှယ် ဆိုဇာဟှို ဗြင်ရှင်ဘေမဲ့လည်း ရပ်ပုဟှူသူ တယော့‑က်ဖြစ်ဟှူကြောန့် လူအောက်ဂီးဟှို ကျော်ဘီး ယေရှုဟှို ဗြင်နိုင်ဘဲဖြစ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","အယ်ကြောန့် သူဟှာ လူအောက်ဂီးရှေ့ဟှနေ ပ္လေးဟှားဘီး ယေရှုဟှို ဗြင်ဟှို့တွပ် သဖန်းဗန်ထတ်ဟှို တတ်လေဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကိုယ်တော်ဟှ အယ်လမ်းတိုင်း လာနေဟှူကြောန့် ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ယေရှုဟှာ အယ်နေရာဟှို ရော့‑က်လာဟှူ ခီမာ မော်ကေ့လိုက်ဘီးန “ဇက္ခဲ၊ ဗြန်းဗြန်ဆင်းလာ။ အယ်နေ့ နန့်အီမာ ငါတည်းမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ဇက္ခဲဟှာ ဗြန်းဗြန်ဆင်းလာဘီး ကိုယ်တော့်ဟှို ရရာတိုင်း ဝန်းသာဟှူစိန ကြိုဆိုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","အယ်မူဇာဟှို ဗြင်လိုက်ဟှူ လူလေ ဂူလောင်းဟှ “အယ်လူဟှာ ပြစ်သားတယော့‑က်ရဲ့ အီမာတည်းဟှို့ လိုက်ဟှားဘီ!” ဆိုဘီး ကဲ့ရဲ့ပြစ်တန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ဇက္ခဲဟှာ ထရပ်ဘီးဟှာ “သခင်! ကျွန်တော်ရဲ့ အောက်စာပစ်စီး တဝပ်ဟှို ဆင်းရဲသားလေဟှို ပေးပါမယ်။ အယ်ဘီးဟှာ ကျွန်တော်ဟှာ တယော့‑က်ယော‑က်နားဟှ တရားဘဲန ယူဟှားဇာလေ ရှိမယ် ဆိုဟှာ ကျွန်တော်ဟှာ လေးဆ ပ္လန်ပေးပါမယ်” ဆိုဘီး သခင်ဘုရားဟှို လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ယေရှုဟှ “အယ်နေ့ဘဲ့ ကယ်တန်ရှင်းဟှာ အယ်အီထတ်ဟှို ရော့‑က်လေဘီ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်သူဟှာလည်း အာဗြဟံရဲ့ မ္လေးမ္လစ် တယော့‑က် ဖြစ်ဟှူကြောန့် ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","လူသားဟှာ ပျော့‑က်နေဟှူ သူလေဟှို ရှာဟှို့န ကယ်တန်ဟှို့တွပ် ကြွလာဟှယ်” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ယေရှုဟှ အယ်ကြောန်းရာလေဟှို နားထောန်နေဟှူ သူလေဟှို ပေါင်ဥပမာ တခုန ထပ်ဘီး မိန့်တော်မူလေဟှယ်။ ကိုယ်တော်ဟှာ ယေရုရှလင်ဗြို့နားမာ ရှိနေဟှူကြောန့် ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှာ ရှစ်ရှင်းပေါ်လာမယ် ဆိုဘီး သူးနို့လေဟှ ထန်နေဂေ့ဟှူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","အယ်ကြောန့် ကိုယ်တော်ဟှ “မြင့်မြတ်ဟှူသူ တယော့က်ဟှာ မန်းဂီးဖြစ် ခံယူဘီးမှ ပ္လန်လာမယ် ဆိုဘီး ဝီးဂီးမာရှိဟှူ နိုင်ငံဟှို သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ခရီးသွားခန်မာ သူဟှာ စေခံဆယ်ယော့‑က်ဟှို ခေါ်ဘီးန ရွှေဒန်းဂါး တပ္လားစီ ပေးဘီးဟှာ ‘ငါခရီးထွပ်နေဒူးမာ အယ်ဒန်းဂါးလေန စီးပွားရှာဂေ့’ ဆိုဘီး သူးနို့ဟှို မှာဟှားရစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","အယ်ဘေမဲ့ သူ့ရဲ့ တိုင်းသူပြည်သားလေဟှာ သူ့ဟှို မူးဂေ့ဟှယ်။ အယ်ကြောန့် သူ့နော့‑က်ဟှနေ တမန်လေဟှို စေလွှတ်ဘီး ‘နို့လေဟှာ အယ်သူဟှို နို့လေရဲ့ မန်းဂီးဖြစ် လိုရှင်ဂေ့ဟှ’ ” ဆိုဘီး လျှော့‑က်ခိုင်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“အယ်လူဟှာ နိုင်ငံအောက်ချောက်ခွမ့်ဟှို ခံယူဘီး ပ္လန်လာဟှယ်။ ရှစ်ရှင်းဘဲ့ သူဟှာ ရွှေဒန်းဂါးလေပေးဟှားဟှူ စေခံလေဟှို ဖယ်မျှလော့‑က် မ္လတ်ရဟှားဟှယ် ဆိုဇာဟှို သိရှင်ဟှူကြောန့် သူးနို့ဟှို ခေါ်ခိုင်းလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ပထမ စေခံဟှာ ရော့‑က်လာဘီး ‘သခင်၊ သခင်ပေးဟှားဟှူ ရွှေဒန်းဂါးတပ္လားအားဖြင့် မ္လတ်ဆယ်ပ္လားရဟှယ်’ ဆိုဘီး လျှော့က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","သခင်ဟှ ‘ကောန်းလေဟှယ်။ နန်ဟှာ စေခံကောန်း တယော့‑က် ဖြစ်လေဟှယ်! နန်ဟှာ ငယ်ဟှူမှုမာ သစ်စာရှိဟှူကြောန့် ဗြို့ဂီးဆယ်ဗြို့ဟှို အောက်စိုးပါ’ ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ဒုတိယ စေခံဟှာ ရော့‑က်လာဘီး ‘သခင်၊ သခင်ပေးဟှားဟှူ ရွှေဒန်းဂါးတပ္လားအားဖြင့် မ္လတ်ငါးပ္လားရဟှယ်’ ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","အယ်လူဟှို ‘နန်ဟှာ ဗြို့ဂီးငါးဗြို့ဟှို အောက်ချောက်ပါ’ ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","နော့‑က်ထပ်စေခံ ရော့‑က်လာဘီး ‘သခင်၊ အယ်မာ သခင်ရဲ့ ရွှေဒန်းဂါးတပ္လား ရှိဟှယ်။ ကျွန်တော်ဟှာ အယ်ဒန်းဂါးဟှို လတ်ကိုင်ပဝါန ထောက်ဘီးဟှာ သီးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","သခင်ဟှာ စိဆတ်ဟှူသူ ဖြစ်ဟှူကြောန့် သခင်ဟှို ကျွန်တော်ကြော့‑က်ဟှယ်။ သခင်ဟှာ ဖြားလည်းသွမ်းဟှားဘဲဇာဟှို ထောက်ယူဘီး ဖြားလည်းစိုက်ဘဲဇာဟှို ရိသီးဟှယ်’ ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","သခင်ဟှ ‘ဆိုးညစ်ဟှူစေခံ! နန့်စကားတိုင်း နန့်ဟှို ငါစီရင်မယ်! ငါဟှာ စိဆတ်ဟှူသူ၊ ငါဟှာ ဖြားလည်းသွမ်းဘဲဇာဟှို ထောက်ယူဘီးဟှာ ဖြားလည်းစိုက်ဘဲဇာဟှို ရိသီးဟှယ် ဆိုဇာဟှိုလည်း နန်သိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","အယ်မျိုးဆိုဟှာ ဖြားဖြစ်ကြောန့် ငါ့ကပ်လေဟှို ဘဏ်မာအပ်ဘဲနနေနူး။ အပ်ဟှားမယ် ဆိုဟှာ ငါပ္လန်ရော့‑က်ဟှူ ခီမာ တိုးလေနတူးဒူ ငါ့ကပ်လေဟှို ပ္လန်ရမယ်’ ဆိုဘီး သူ့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","အယ်ဘီးန နီးနားမာ ရပ်နေဟှူ သူလေဟှို ‘သူ့ရဲ့ ရွှေဒန်းဂါး တပ္လားယူဘီး ရွှေဒန်းဂါး ဆယ်ပ္လားရှိဟှူ စေခံဟှို ပေးလိုက်’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","အယ်ဘေမဲ့ သူးနို့လေဟှ ‘သခင်၊ အယ်သူမာ ရွှေဒန်းဂါး ဆယ်ပ္လား ရှိနေဘီးသား ဖြစ်ဟှယ်!’ ဆိုဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘နန်းနို့ဟှို ငါပြောမယ်။ ရှိဟှူလူဟှို ထပ်ပေးဘီး သူ့ဟှို ကြွယ်ဝစေလေ့မယ်။ မှေ့ဘဲဟှူ လူလေနားဟှ ရှိဟှူမျှဟှို နှုလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ငါ့ဟှို သူးနို့လေရဲ့ မန်းဂီးဖြစ်န လိုရှင်ဘဲဟှူ ငါ့ရဲ့ ရန်သူလေဟှို အယ်နေရာဟှို ခေါ်လာဂေ့။ ငါ့ရှေ့တော်မာ သတ်ဂေ့!’ ဆိုဘီး စီရင်တော်မူလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ယေရှုဟှာ အယ်မျိုးမိန့်တော်မူဘီးန သူးနို့လေရဲ့ ရှေ့ဟှနေဘီး ယေရုရှလင်ဗြို့ဟှို ကြွဟှားတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","သံလွင်တောန်နားမာရှိဟှူ ဗက်ဖာဂေဝါန ဗေသနိဝါနားဟှို ရော့‑က်လာဟှူ ခီမာ တဗဲ့တော် နှေ့ပါးဟှို ရှေ့ဟှနေစေလွှတ်ဘီး ");
INSERT INTO tvn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“နန်းနို့ရှေ့မာရှိဟှူ ဝါဟှို သွားဂေ့။ ဝါထဲဟှို ရော့‑က်ဟှူ ခီမာ ဖယ်သူလည်း စီးဖူးသေးဘဲဟှူ မြည်းသားဂန်းဟှားဟှို ခယ်ဟှားဇာဟှို နန်းနို့ဟှာ တွိလေ့မယ်။ အယ်မြည်းသားဂန်းဟှားဟှို ကြိုးဖြေဘီး ငါ့နားဟှို ခေါ်လာဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ယော့‑က်ယော့‑က်ဟှ ဖြားဖြစ်ကြောန့် မြည်းကြိုးဟှို ဖြေဂေ့နေနူး။ ဆိုဘီး နန်းနို့ဟှို မေးမယ် ဆိုဟှာ အယ်မြည်းဟှို သခင်လိုရှိဟှယ် ဆိုဘီး သူးနို့ဟှို ပြောဂေ့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","စေလွှတ်လိုက်ဟှူ သူလေဟှာ ထွပ်ဟှားဘီးန ယေရှုမိန့်တော်မူမျိုးဘဲ့ ဂူလောင်းဟှို တွိရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","သူးနို့လေဟှာ မြည်းဟှို ကြိုးဖြေပေးနေဟှူ ခီမာ မြည်းဇရှင်ဟှ “ဖြားဖြစ်ကြောန့် မြည်းဟှို ကြိုးဖြေပေးနေရနူး။” ဆိုဘီး သူးနို့ဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","သူးနို့ဟှ “အယ်မြည်းဟှို သခင် လိုရှိဟှယ်” ဆိုဘီး ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","အယ်ဘီးန သူးနို့ဟှ မြည်းသားဂန်းဟှားဟှို ယေရှုနားဟှို ယူဆောန်ဟှားလေဟှယ်။ အယ်မြည်းထတ်မာ သူးနို့ရဲ့ ဝတ်ရောင်လေဟှို ခန်းဘီးန ယေရှုဟှို စီးစေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ကိုယ်တော်ဟှာ စီးဘီးလာဟှူ ခီမာ လူလေဟှ သူးနို့ရဲ့ ဝတ်ရောင်လေဟှို လမ်းထတ်မာ ခန်းပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ကိုယ်တော်ဟှာ ယေရုရှလင်ဗြို့နီး သံလွင်တောန် ဆင်းလမ်းဟှို ရော့‑က်လာဟှူ ခီမာ တဗဲ့တော် အောက်ဂီးဟှာ သူးနို့ဗြင်ရဟှူ နိမိတ်လတ်ခဏာ ဂူလောင်းတွပ် ဝန်းသာဟှူစိန ဘုရားသခင်ရဲ့ ဂေါင်တော်ဟှို၊ ");
INSERT INTO tvn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ဘုရားသခင်ရဲ့ နာမန ကြွလာဟှူ မန်းဂီးဟှာ မင်္ဂလာရှိပါစေ! ကောန်းဂန်ဘောင်မာ ငြီသတ်ရှင်းရှိပါစေ။ ဗြင့်ဆောင်းဟှူ နေရာမာ ဖောင်းကီးတော်မူပါစေ!” ဆိုဘီး သံက္လယ်ဂီးန ချီးမွမ်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","အယ်ခီမာ လူအောက်ဂီးထဲဟှ ဖာရိရှဲတချို့ဟှ “ဆရာ၊ ကိုယ်တော်ရဲ့ တဗဲ့တော်လေဟှို တိတိဟှားနေဟှို့ ဆောင်းမပေးတော်မူပါ!” ဆိုဘီး ယေရှုဟှို လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ယေရှုဟှ “နန်းနို့ဟှို ငါပြောမယ်၊ သူးနို့ဟှို တိတိဟှားနေစေမယ် ဆိုဟှာ က္လော့ခဲလေဟှ အော်ဟစ်ဂေ့လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ကိုယ်တော်ဟှာ ယေရုရှလင်ဗြို့နားဟှို ရော့‑က်လာဘီး အယ်ဗြို့ဟှို ဗြင်တော်မူဟှူ ခီမာ ငိုတော်မူဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“နန်ဟှာ ငြီသတ်ရှင်းတွပ် လိုအပ်ဟှူဇာလေဟှို အယ်နေ့မာဘဲ့ သိရမယ် ဆိုဟှာ မင်္ဂလာရှိဟှယ်! အယ်ဘေမဲ့ အယ်မူဇာလေဟှာ ခုနန့်ရဲ့ မျစ်စိရှေ့မာ ဖောင်းကွယ်ဟှားရှင်းခံရဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","နန့်ရဲ့ ရန်သူလေဟှာ ဖတ်ဖတ်ဟှနေဘီး တားဆီးလေန ဝန်းရံဘီး ပိဟှားမယ့်နေ့ ရော့‑က်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","သူးနို့လေဟှ နန့်ဟှိုရော၊ နန့်ရဲ့ ဗြို့ရိုးထဲဟှ သူလေဟှိုရော တယော့‑က်လည်း ကျန်ဘဲအောန် ဖျစ်ဆီးဂေ့လေ့မယ်။ အယ်နေရာမာ က္လော့တောင်း တလောင်းလည်း ကျန်ရစ်ဟှို့မုဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန့်ဟှို ကယ်တန်ဟှို့ ဘုရားသခင် ရော့‑က်လာမယ့် ခီဟှို သိဘဲကြောန့် ဖြစ်ဟှယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ယေရှုဟှာ ဗိမာန်တော်ထဲဟှို ဝမ်တော်မူဘီးန ရောန်းဝယ်နေဟှူ လူလေဟှို နှန်ထုတော်မူဘီး ");
INSERT INTO tvn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","သူးနို့လေဟှို “ကျမ်းစာထဲမာ ဘုရားသခင်ဟှ ‘ငါ့ဗိမာန်တော်ဟှာ ဆုတောန်းဟှူ အီတော် ဖြစ်ရလေ့မယ်’ ဆိုဘီး မိန့်တော်မူဟှားဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ဟှ အယ်အီတော်ဟှို သူခိုးလေတွပ် ပူးအောန်းဟှူနေရာ ဖြစ်စေဂေ့ဘီ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ယေရှုဟှာ နေ့တိုင်း ဗိမာန်တော်မာ သွန်သန်ပေးတော်မူဟှယ်။ ယဇ်ပုရောဟိတ်ဂီးလေ၊ ကျမ်းတတ်ဆရာလေန လူထုခေါန်းဆောန်လေဟှာ ကိုယ်တော့်ဟှို သတ်ဟှို့တွပ် ရှာကြံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","အယ်ဘေမဲ့ လူလေ ဂူလောင်းဟှာ ကိုယ်တော်ရဲ့ စကားတော်ဟှို အာရုံစိုက်ဘီး နားထောန်နေဂေ့ဟှူကြောန့် ကိုယ်တော့်ဟှို သတ်ဟှို့တွပ် နည်းလမ်းရှာဟှို့ တွိဘဲဖြစ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","တနေ့မာ ယေရှုဟှာ ဗိမာန်တော်ထဲမာ လူလေဟှို သွန်သန်တော်မူဘီးဟှာ ဒန်းကောန်းဟှို ဟောတော်မူနေဟှူ ခီမာ ယဇ်ပုရောဟိတ်ဂီးလေန ကျမ်းတတ်ဆရာလေဟှာ သတ်ကီးဝါဂီးလေနတူးဒူ ရော့‑က်လာဘီး ");
INSERT INTO tvn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ကိုယ်တော့်ဟှို “အယ်မူဇာလေဟှို ဖြားခွမ့်အာဏာန လောက်နေနူး။ အယ်ခွမ့်အာဏာဟှို ဖယ်သူဟှ ပေးဟှားနူး။” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ယေရှုဟှာ “အယ်ဆိုဟှာ ငါလည်း နန်းနို့ဟှို မေးခွန်းတခု မေးအူးမယ်။ ငါ့ဟှို ဖြေပေးဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ယောဟန်ရဲ့ ဗတ္တိဇံဟှာ ကောန်းဂန်ဟှနေ လာဇာလော။ လူလေဟှနေ လာဇာလော။” ဆိုဘီး သူးနို့ဟှို မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","သူးနို့ဟှာ “နို့လေဖြားမျိုး ဖြေရမယ်နူး။ ‘ကောန်းဂန်ဟှနေ လာဟှယ် ဆိုဘီး ဖြေလိုက်မယ် ဆိုဟှာ ယောဟန်ဟှို နန်းနို့လေ ဖြားဖြစ်ကြောန့် ယောင်ကြည်ဂေ့ဟှနူး။ ဆိုဘီး ပ္လန်မေးလေ့အူးမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","လူလေဟှနေ လာဟှယ် ဆိုဘီး နို့လေဟှ ဖြေလိုက်မယ် ဆိုဟှာလည်း ယောဟန်ဟှို ပရောဖက်တပါး ဖြစ်ဟှယ် ဆိုဇာဟှို လူလေဟှ ယောင်ကြည်ဂေ့ဟှူကြောန့် နို့လေဟှို က္လော့ခဲန ပစ်လေ့မယ်’ ” ဆိုဘီး ရှင်းရှင်းဆွေးနွေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","အယ်ကြောန့် သူးနို့လေဟှာ “အယ်ခွမ့်အာဏာဟှာ ဖယ်ဟှနေလာဟှယ် ဆိုဇာဟှို ကျွန်တော့်ဟှားလေ သိဂေ့ဟှ” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ယေရှုဟှာ “အယ်မူဇာလေဟှို ဖြားခွမ့်အာဏာန ငါလောက်ဟှယ် ဆိုဇာဟှိုလည်း နန်းနို့ဟှို ငါပြောဟှ” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","အယ်ဘီးန ယေရှုဟှာ အယ်ပေါင်ဥပမာန လူလေဟှို “လူတယော့‑က်ဟှာ စဗျစ်ခြံဟှို စိုက်ဘီး ခြံစောန့်မားလေဟှို ငှားရစ်ဘီးန ခီကြာဂီး ခရီးထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","စဗျစ်သီး ဆွတ်ခီရော့‑က်ဟှူ ခီမာ စဗျစ်ခြံထွပ် သီးတချို့ဟှို ယူဟှို့တွပ် ခြံစောန့်မားလေနားဟှို ကျွန်တယော့‑က်ဟှို စေလွှတ်လေဟှယ်။ အယ်ဘေမဲ့ ခြံစောန့်မားလေဟှ အယ်ကျွန်ဟှို ရိုက်နှက်ဘီး လတ်ခဲခဲန ပ္လန်လွှတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","အယ်ကြောန့် ဇရှင်ဟှ ကျွန်တယော့‑က်ဟှို ထပ်လွှတ်လေဟှယ်။ အယ်ဘေမဲ့ ခြံစောန့်မားလေဟှ အယ်ကျွန်ဟှိုလည်း ရိုက်နှက်ဘီး၊ ရှက်ခွဲဘီး လတ်ခဲခဲန ပ္လန်လွှတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","အယ်ဘီးန ဇရှင်ဟှ တတိယကျွန်ဟှို ထပ်ဘီး စေလွှတ်လေဟှယ်။ ခြံစောန့်မားလေဟှ အယ်ကျွန်ဟှိုလည်း ဒန်ရာရစေဘီးဟှာ ပ္လန်ဟှို နှန်ထုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","စဗျစ်ခြံ ဇရှင်ဟှ ‘ငါဖယ်မျိုးလောက်ရမယ်နူး။ ငါ့ရဲ့ ရှစ်ဟှူသားဟှို စေလွှတ်မယ် ဆိုဟှာ ခြံစောန့်မားလေဟှာ သူ့ဟှို ရိုသေကောန်း ရိုသေဂေ့လေ့မယ်!’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","အယ်ဘေမဲ့ ခြံစောန့်မားလေဟှ သူ့ရဲ့သားဟှို ဗြင်ဟှူ ခီမာ ‘အယ်သူဟှာ ဇရှင်ရဲ့ သားဖြစ်ဟှယ်။ သူ့ဟှို သတ်ဂေ့ဇို့။ အယ်ဆိုဟှာ သူ့ဖရဲ့ အောက်စာဟှာ နို့လေရဲ့အောက်စာ ဖြစ်ဟှားလေ့မယ်!’ ဆိုဘီး သူးနို့လေ ယော့‑က်နယော့‑က် ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","အယ်ကြောန့် သူးနို့လေဟှာ ဇရှင်ရဲ့ သားဟှို စဗျစ်ခြံပ္လန်ဟှို ထုဘီးဟှာ သတ်ဂေ့လေဟှယ်။” “အယ်မျိုးဆိုဟှာ စဗျစ်ခြံဇရှင်ဟှ ခြံစောန့်မားလေဟှို ဖြားဇာလောက်မယ်နူး။” ဆိုဘီး ယေရှုဟှ မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“ဇရှင်ဟှာ လာဘီး အယ်လူလေဟှို သတ်ဘီးဟှာ စဗျစ်ခြံဟှို တခြားခြံစောန့်မားလေဟှို အပ်ပေးလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ လူလေဟှ အယ်မျိုး ကြားရဟှူ ခီမာ “အယ်မျိုး ဖြစ်ပါစေန!” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ယေရှုဟှာ သူးနို့ဟှို ကေ့ဘီး “ ‘အီဆော့‑က်မားလေဟှ သောင်းဇားရဘဲဟှူကြောန့် ဖယ်ဟှားဟှူ က္လော့‑က်ဟှာ ဂူလောင်းထဲမာ ရေးကီးဆောန်း ဖြစ်လာရဂေ့ဟှယ်’ ဆိုဘီး ရေးဟှားဇာဟှာ ဖြားဓိပါယ်နူး။” ");
INSERT INTO tvn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“အယ်က္လော့‑က်ထတ်ဟှို က္လဟှူလူတိုင်းဟှာ ပိုင်းပိုင်းက္လိုးလေ့မယ်။ အယ်ဘီးဟှာ အယ်က္လော့‑က်ဟှာ ယော့‑က်ယော့‑က်ထတ်ဟှို က္လမယ် ဆိုဟှာ အယ်သူဟှာ ညစ်ညစ်ကြေဟှားလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ကျမ်းတတ်ဆရာလေန ယဇ်ပုရောဟိတ်ဂီးလေဟှာ အယ်ပေါင်ဥပမာဟှ သူးနို့ဟှို စောန်းခိဘီး ပြောနေဟှယ် ဆိုဇာဟှို သိဂေ့ဟှူကြောန့် ရှစ်ရှင်းဘဲ့ ယေရှုဟှို ဖမ်းဟှို့တွပ် ရှာကြံဂေ့ဟှယ်။ အယ်ဘေမဲ့ လူလေဟှို ကြော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","အယ်ကြောန့် သူးနို့လေဟှ ခွမ့်ကောန်းဟှို ရှာနေဂေ့ဟှယ်။ သူးနို့လေဟှာ လူတချို့ဟှို ရိုးသားဟန်ဆောန်ဟှို့တွပ် လာဘ်ထိုးဟှားဟှယ်။ အယ်ဘီးဟှာ သူးနို့လေဟှ ကိုယ်တော်ရဲ့ စကားထဲမာ မှားရှာဟှို့တွပ် အယ်လူလေဟှို စေလွှတ်လေဟှယ်။ အယ်ဆိုဟှာ သူးနို့လေဟှာ ကိုယ်တော့်ဟှို ခွမ့်အာဏာန တဂိုးရှိဟှူ ရောမ ဗြို့ဝန်းမန်း နားဟှို အပ်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","အယ်သူလျှိုလေဟှ “ဆရာ၊ ဆရာဟောနေဇာလေရော၊ သန်ကြားနေဇာလေရော မှန်ဟှယ် ဆိုဇာဟှို ကျွန်တော့်ဟှားလေ သိဟှယ်။ ဆရာဟှာ မျစ်နှာလိုက်ဘဲန လူလေတွပ် ဘုရားသခင်ရဲ့ လိုတော်န ဆိုင်ဟှူ သမ္မာတရားဟှို သန်ကြားပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ကဲသာ မန်းဂီးဟှို ခွန်ဆောန်ရှင်းဟှာ ပညတ်တော်န ညီဟှယ်လော။ ညီဟှလော။” ဆိုဘီး ယေရှုဟှို မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","အယ်ဘေမဲ့ ယေရှုဟှာ သူးနို့ရဲ့ ပရိယာယ်ဟှို သိတော်မူဟှူကြောန့် ");
INSERT INTO tvn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ငါ့ဟှို ငွေဒန်းဂါးတပ္လား ပြဂေ့။ အယ်ဒန်းဂါးမာ ဖယ်သူ့ရောက်ပေါင်န နာမယ်ရှိဟှယ်နူး။” ဆိုဘီး မေးတော်မူလေဟှယ်။ သူးနို့လေဟှ “ကဲသာမန်းဂီး ပေါင်န ကဲသာမန်းဂီး နာမယ်ရှိဟှယ်” ဆိုဘီး ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","အယ်ကြောန့် ယေရှုဟှ “အယ်မျိုးဆိုဟှာ ကဲသာမန်းဂီး ပိုင်ဟှူဇာဟှို ကဲသာမန်းဂီးဟှို ပေးဂေ့။ ဘုရားသခင် ပိုင်ဟှူဇာဟှို ဘုရားသခင်ဟှို ပေးဂေ့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","သူးနို့လေဟှာ လူလေရှေ့မာ ကိုယ်တော်ရဲ့ စကားလေထဲမာ မှားရှာတွိနိုင်ဘဲ ဖြစ်နေဂေ့ဟှယ်။ အယ်ဘီးဟှာ ကိုယ်တော်ရဲ့ ပ္လန်မိန့်တော်မူဟှူ စကားဟှို အံ့ဩဟှားဂေ့ဘီး တိဆိဟှားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","အယ်ဘီးန ရှင်ပ္လန်ထမြော့‑က်ရှင်းမှေ့ဟှ ဆိုဘီး ပြောဂေ့ဟှူ ဇဒ္ဒုကဲတချို့ဟှာ ယေရှုနားဟှို လာဘီးဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ဆရာ၊ မောရှေဟှ ‘လူတယော့‑က်ဟှာ သားမီးလေမှေ့ဘဲ့န သေဟှားမယ် ဆိုဟှာ ကျန်ရစ်ဟှူ မယားဟှို သူ့ရဲ့ညီဟှ ပ္လန်ဘီး လတ်ထပ်ရဟှယ်။ အယ်ဘီးဟှာ သူးနို့မာရလာဟှူ သားမီးလေဟှို သေဟှားဟှူသူရဲ့ သားမီးလေဖြစ် သတ်မှတ်ရမယ်’ ဆိုဘီး ကျွန်တော့်ဟှားလေတွပ် အယ်ပညတ်တရားဟှို ရေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","တခါဒူးဟှ ညီကို ခွန်နစ်ယော့‑က် ရှိဟှယ်။ နောန်ဂီးဆောင်းဟှာ အီထောန်ပြုဘီး သားမီးလေ မှေ့ဘဲန သေဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","အယ်ဘီးန အယ်မီးမဟှို ဒုတိယညီဟှ ယူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","အယ်ဘီးန တတိယညီဟှ ယူလေဟှယ်။ အယ်မျိုးနဘဲ့ ညီကို ခွန်နစ်ယော့‑က်လောင်းဟှာ သားမီးလေ မှေ့ဘဲန သေဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","နော့‑က်ဆောင်းမာ အယ်မီးမလည်း သေဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","အယ်မျိုးဆိုဟှာ ရှင်ပ္လန်ထမြော့‑က်ဟှူ နေ့မာ အယ်မီးမဟှာ ဖယ်သူ့ရဲ့ မယား ဖြစ်လေ့မယ်နူး။ ညီကို ခွန်နစ်ယော့‑က်လောင်းဟှ အယ်မီးမဟှို ယူဟှားပီးဘီ ဆိုဘီး သူးနို့ဟှ လျှော့‑က်လေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ယေရှုဟှာ “အယ်ဘဝမာ ယော့‑က်ကျားလေန မီးမလေဟှာ အီထောန်ပြုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","အယ်ဘေမဲ့ သေရာဟှနေ ပ္လန်ရှင်ဟှို့ ထိုက်တန်ဟှူ ယော့‑က်ကျားလေန မီးမလေဟှာ နောန်ဘဝမာ အီထောန်ပြုရှင်းလေ မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","သူးနို့လေဟှာ ကောန်းဂန်တမန်လေမျိုး ဖြစ်ဟှားဘီး သေဂေ့ဟှမ်း။ သူးနို့လေဟှာ သေရာဟှနေ ပ္လန်ရှင်လာဟှူကြောန့် ဘုရားသခင်ရဲ့ သားမီးလေ ဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","အယ်ဘီးဟှာ သေရာဟှနေ ပ္လန်ရှင်ဟှယ် ဆိုဇာဟှို မောရှေဟှ ရှင်းရှင်းလန်းလန်း သတ်သေပြဟှားဟှယ်။ မောရှေဟှာ မီးလောန်နေဟှူချောင်ကြောန်းန ပတ်သတ်ဘီး ဘုရားသခင်ဟှို ‘အာဗြဟံရဲ့ ဘုရားသခင်၊ ဣဇာက်ရဲ့ ဘုရားသခင်၊ ယာကုပ်ရဲ့ ဘုရားသခင်’ ဆိုဘီး ဖော်ပြဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ဘုရားသခင်ဟှာ သေဟှားဟှူ သူလေရဲ့ ဘုရား မှုဟှ။ သတ်ရှင်ဟှူ သူလေရဲ့ ဘုရား ဖြစ်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လူလေ ဂူလောင်းဟှာ ကိုယ်တော့်အားဖြင့် သတ်ရှင်ဂေ့ဟှယ်” ဆိုဘီး သူးနို့လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ကျမ်းတတ်ဆရာ တချို့ဟှ “ဆရာ၊ ကောန်းဟှူဖြေ ဖြစ်ဟှယ်!” ဆိုဘီး လျှော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","အယ်ကြောန့် သူးနို့လေဟှာ ကိုယ်တော့်ဟှို နော့‑က်ထပ် မေးခွန်းလေ မေးရဲဂေ့ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ယေရှုဟှာ “မေရှိယဟှာ ဒါဝိဒ်ရဲ့ မ္လေးမ္လစ်ဖြစ်ဟှယ် ဆိုဇာဟှို ဖယ်မျိုးပြောနိုင်ဂေ့နူး။ ဆိုဘီး သူးနို့လေဟှို မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ဒါဝိဒ်ကိုယ်တိုင်ဟှ ဆာလံကျမ်းမာ” “‘သခင်ဘုရားဟှ ငါ့သခင်ဟှို၊ ");
INSERT INTO tvn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","နန့်ရဲ့ ရန်သူလေဟှို နန့်ရဲ့ ခေတန်ခေါင်ဖြစ် ငါခ္လဟှားခီထိ ငါ့ရဲ့ ညာဖတ်မာ ထိုင်နေပါ ဆိုဘီး ပြောဟှယ်’ ဆိုဘီး ရေးဟှားဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“ဒါဝိဒ်ဟှ ကိုယ်တော့်ဟှို ‘သခင်’ ဆိုဘီး ခေါ်လေဟှယ်။ အယ်ဆိုဟှာ ဖယ်မျိုးဖြစ်ဘီးဟှာ မေရှိယဟှာ ဒါဝိဒ်ရဲ့ မ္လေးမ္လစ် ဖြစ်ဟှားရနူး။” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","လူလေ ဂူလောင်းဟှာ နားထောန်နေဟှူ ခီမာ ယေရှုဟှ တဗဲ့တော်လေဟှို ");
INSERT INTO tvn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ကျမ်းတတ်ဆရာလေဟှို ဒိထားဂေ့။ သူးနို့လေဟှာ ဝတ်လောင်ရှယ်လေန ရှော့‑က်သွားဘီး ဆေးလေထဲမာ နှောက်ဆစ်ခံရဇာဟှို နှစ်သက်ဂေ့ဟှယ်။ သူးနို့လေဟှာ ဝါလယ်ဇရပ်လေမာ သီးသန့်ခေါင်လေန စားသော့‑က်ဗွဲလေမာ ကောန်းဆောင်းနေရာဟှို ဝီးကော့‑က်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","သူးနို့လေဟှာ မောက်ဆိုးမလေရဲ့ အီလေဟှို အဓမ္မသီးယူဟှယ်။ အယ်ဘီးဟှာ လူလေထန်ကီးအောန် ခီကြာဂီး ဆုတောန်းဂေ့ဟှယ်! သူးနို့လေဟှာ ရရာတိုင်း ဆိုးဟှူ ပြစ်ဒန်ဟှို ခံရလေ့မယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ယေရှုဟှာ ပတ်ပတ်လည်ဟှို ကေ့လိုက်ဟှူ ခီမာ ဌေးသားလေဟှာ ဗိမာန်တော်ထဲဟှ လှူခံဗောင်းထဲဟှို သူးနို့ရဲ့ လှူငွေလေ ထဲ့နေဂေ့ဇာဟှို ဗြင်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","အယ်ဘီးဟှာ ကိုယ်တော်ဟှာ ရရာတိုင်း ဆင်းရဲဟှူ မောက်ဆိုးမဟှ ကြေးဒန်းဂါး နှေ့ပ္လား ထဲ့နေဇာဟှိုလည်း ဗြင်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ကိုယ်တော်ဟှ “အယ်ဆင်းရဲဟှူ မောက်ဆိုးမဟှာ တခြားလူလေ ဂူလောင်းထတ် ဘောင်ဂီးလှူဟှယ် ဆိုဇာဟှို နန်းနို့ဟှို ငါမှန်တိုင်း ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ တခြားလူလေ ဂူလောင်းဟှာ သူးနို့အောက်စာရဲ့ ပိုနေဟှူဇာလေဟှို လှူဂေ့လေဟှယ်။ အယ်ဘေမဲ့ အယ်မောက်ဆိုးမဟှာ သူ့မာရှိမျှ ဂူလောင်းဟှို ပေးလေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ဗိမာန်တော်ဟှို လှပဟှူ က္လော့‑က်တောင်းလေနရော၊ ဘုရားသခင်ဟှို ဆစ်ကပ်ဟှားဟှူ လှူပစ်စီးလေနရော လှဆင်ဟှားဟှယ် ဆိုဘီး တဗဲ့တော်တချို့ဟှာ ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ယေရှုဟှ “နန်းနို့ ဗြင်ဟှားဇာလေ ဂူလောင်းဟှာ က္လော့‑က်တတောင်းလည်း ကျန်ရစ်ဘဲအောန် ဖျစ်ဆီးရှင်းခံရဟှို့ ခီရော့‑က်လာလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","သူးနို့လေဟှ “ဆရာ၊ အယ်မူဇာလေဟှ ဖယ်ခီမာ ဖြစ်လာမယ်နူး။ အယ်မူဇာလေ ဖြစ်ခါနီးဟှူ ခီမာ ဖယ်မျိုးနိမိတ်လေ ပေါ်လာဟှို့နူး။” ဆိုဘီး မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ယေရှုဟှ “နန်းနို့လေ လှည့်ဇားခံရဘဲအောန် ဒိထားဂေ့။ လူလေဘောင်ဂီးဟှာ ငါ့နာမန ရော့‑က်လာဘီးဟှာ ‘ငါဟှာ အယ်လူဘဲ့ ဖြစ်ဟှယ်! ခီရော့‑က်လာဘီ!’ ဆိုဘီး ပြောလေ့မယ်။ အယ်ဘေမဲ့ သူးနို့ နော့‑က်ဟှို လိုက်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","နန်းနို့လေဟှာ စစ်ပွဲလေန ပူကန်ရှင်းကြောန်းလေဟှို ကြားရဟှူ ခီမာ ကြော့‑က်ဂေ့န။ အယ်မူဇာလေဟှ ရင်ဦးဆောင်း ဖြစ်ရမယ်။ အယ်ဘေမဲ့လည်း ဆောင်းသတ်ခီဟှာ ရော့‑က်လာသေးဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ကိုယ်တော်ဟှ “လူမျိုးလေဟှာ တမျိုးန တမျိုး၊ နိုင်ငံလေဟှာ တနိုင်ငံန တနိုင်ငံ တိုက်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","နေရာတိုင်းမာ ကြော့‑က်ဘွယ်လန့်ဘွယ် မ္လေဂီးလှောက်ရှင်းလေ၊ စာရေဇာ ရှားပါးရှင်းလေ၊ ကပ်ရောဂါလေ ဖြစ်ဂေ့လေ့မယ်။ ကောန်းဂန်ထတ်ဟှနေ ထူးဆန်းဘီး ကြော့‑က်ဇာကောန်းဟှူ နိမိတ်လေ ပေါ်လာဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","အယ်ဘေမဲ့လည်း အယ်မူဇာလေ ဖြစ်လာခန်မာ နန်းနို့လေဟှို ဖမ်းဆီးဘီး ညှည်းဆဲဂေ့လေ့မယ်။ နန်းနို့လေဟှို ဝါလယ်ဇရပ်လေမာရော၊ ထောန်ထဲမာရော လှောန်ဟှားဂေ့လေ့မယ်။ ငါ့နာမကြောန့် နန်းနို့လေဟှို ဗြို့ဝန်မန်းလေန မန်းဂီးလေ ရှေ့မှော့‑က်ဟှို ခေါ်ဆောန်ဟှားဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","အယ်နည်းလမ်းအားဖြင့် နန်းနို့ဟှာ ဒန်းကောန်းဟှို သတ်သေခံဟှို့တွပ် ခွမ့်ရေး ဖြစ်လာဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","အယ်ကြောန့် ဖယ်မျိုးချေပရမယ် ဆိုဇာဟှို ကြိုတန်ဘီး စိုးရိမ်ဘဲဟှို့တွပ် နန်းနို့ရဲ့ စိနှလောင်းဟှို ဆောင်းဖြတ်ဟှားဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်းနို့ရန်သူလေဟှာ ပ္လန်ဘီး ခုခံဟန့်တားနိုင်ဘဲနေအောန် နန်းနို့ဟှို နှောက်စွမ်းန ဉာဏ်ပညာဟှို ငါပေးမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","နန်းနို့ရဲ့ မိဖလေရော၊ ညီကိုလေရော၊ ဆွေမျိုးလေရော၊ ငယ်ဂျင်းလေဟှာ နန်းနို့ဟှို အပ်ဂေ့လေ့မယ်။ နန်းနို့ထဲဟှ တချို့ဟှာ သေသတ်ရှင်းဟှို ခံရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","လူတိုင်းဟှာ ငါ့နာမကြောန့် နန်းနို့ဟှို မူးတီးဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","အယ်ဘေမဲ့ နန်းနို့ခေါန်းဟှ ဆားဗန်တဗန်မျှ ဆောင်းရှောင်းစေဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","နန်းနို့ဟှာ တည်ကြည်ရှင်းအားဖြင့် ကယ်တန်ရှင်းဟှို ခံရဂေ့လေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ယေရုရှလင်ဗြို့ဟှို စစ်တပ်လေ ဝိုင်းဟှားဇာဟှို နန်းနို့ ဗြင်ရဟှူ ခီမာ အယ်ဗြို့ဟှာ ကြာခန်မာ ဖျစ်ဆီးရှင်းခံရမယ် ဆိုဇာဟှို နန်းနို့လေ သိဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","အယ်ဆိုဟှာ ယုဒနယ်မာရှိဟှူ သူလေဟှာ တောန်ထတ်ဟှို တတ်ပ္လေးဂေ့စေ။ ဗြို့ထဲမာရှိဟှူ လူလေဟှာ ဗြို့ပ္လန်ဟှို ထွပ်ဂေ့စေ။ အယ်ဘီးဟှာ ကျေးဝါမာရှိဟှူ သူလေဟှိုလည်း ဗြို့ထဲဟှို ဝမ်ဂေ့စေန။ ");
INSERT INTO tvn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်နေ့ရစ်လေဟှာ ကျမ်းစာဟှ ပြောဟှားတိုင်း ပ္လဲ့ဇောင်ဟှို့တွပ် ‘ပြစ်ဒန်ပေးဟှို့ နေ့ရစ်လေ’ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","အယ်နေ့ရစ်လေမာ ဝန်းရှင်မလေန သားရှင်မိလေတွပ် ရရာတိုင်း ဆိုးဝါးဂေ့လေ့မယ်! ဒေါက်ခဆင်းရဲဟှာ အယ်ပြည်ထတ်ဟှို ရော့‑က်လာလေ့မယ်။ အယ်ဘီးဟှာ ဘုရားသခင်ရဲ့ မျစ်တော်ဟှာ အယ်သူလေ ထတ်မာလည်း က္လရော့‑က်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","တချို့လေဟှာ ထားန သတ်ခံရဂေ့လေမယ်။ ကျန်ဟှူ သူလေဟှာ ထောန်သားလေဖြစ်န နိုင်ငံသီးသီးဟှို ဖမ်းဆီးဟှားရှင်း ခံရဂေ့လေ့မယ်။ လူမျိုးခြားလေဟှာ သူးနို့ရဲ့ ခီကူခန်ထိ ယေရုရှလင်ဗြို့ဟှို နန်းချေဂေ့လေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“နေ၊ လ၊ ကြယ်လေမာ ထူးဆန်းဟှူ နိမိတ်လေ ဖြစ်လေ့မယ်။ မ္လေဂီးထတ်ဟှ လူမျိုးလေ ဂူလောင်းဟှာ ပန်လယ်လှိုင်းတံပိုးသံကြောန့် စိပျစ်ဟှားဘီး ကြော့‑က်လန့်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ကောန်းဂန်ဟှ တဂိုးလေဟှာ လှောက်ခါဂေ့ဘီး လူလေဟှာ ကမ္ဘာထတ်ဟှို သတ်ရော့‑က်လာဟှို့ ဇာလေတွပ် ကြိုတွီးဘီး ကြော့‑က်လန့်လာဟှူကြောန့် မူးလှဲဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","အယ်ခီမာ လူ့ရဲ့သားဟှာ ကီးမားဟှူ ဖောင်းတဂိုးန မိုးတီဟှို စီးဘီး ကြွလာနေဇာဟှို သူးနို့လေ ဗြင်ရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","အယ်မူဇာလေ စဘီး ဖြစ်လာဟှူ ခီမာ နန်းနို့ဟှို ဝီးကော့‑က်ဟှို့ ခီဟှာ နီးလာဘီဖြစ်ဟှူကြောန့် မတ်တပ်ထဘီး နန်းနို့ရဲ့ ခေါန်းလေဟှို မော့ဟှားဂေ့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","အယ်ဘီးန ယေရှုဟှာ သူးနို့ဟှို အယ်ပေါင်ဥပမာန “သဖန်းဗန်န တခြားသစ်ပန်လေဟှို ကေ့ကေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","နန်းနို့လေဟှာ အယ်ပန်လေမာ ဝပ်နုလေ ထွပ်လာဇာဟှို ဗြင်ဟှူ ခီမာ နွေရာသီ ရော့‑က်ခါနီးဘီ ဆိုဇာဟှို နန်းနို့လေ သိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","အယ်မျိုးဘဲ့ အယ်မူဇာလေ ဖြစ်လာဇာဟှို နန်းနို့လေ ဗြင်ဟှူ ခီမာ ဘုရားသခင်ရဲ့ နိုင်ငံတော် တည်ခါနီးဘီ ဆိုဇာဟှို နန်းနို့လေ သိဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“ငါ မှန်တိုင်းပြောမယ်၊ အယ်မူဇာလေ ဂူလောင်း ဖြစ်လာခန်မာ အယ်မျိုးဆစ်ဟှာ လောင်းဝ ပျော့‑က်ကွယ်ဟှားဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ကောန်းဂန်န မ္လေဂီးဟှာ ပျော့‑က်ကွယ်ဟှားလေ့မယ်။ အယ်ဘေမဲ့ ငါ့စကားလေဟှာ လောင်းဝ ပျော့‑က်ကွယ်လေ့မယ် မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“ဒိနနေဂေ့။ ပျော်လွန်ကြူးရှင်းလေ၊ သော့‑က်စားယစ်မောရှင်းလေ၊ လောကီမှုရေး စိုးရိမ်ရှင်းလေကြောန့် နန်းနို့ရဲ့ စိနှလောင်းလေဟှာ လေးလံထိုင်းမှိုင်းနေဒူးမာ အယ်နေ့ရစ်ဟှာ ထောန်ချော့‑က်မျိုးဘဲ နန်းနို့ထတ်ဟှို ရောက်တရစ် ရော့‑က်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်နေ့ရစ်ဟှာ မ္လေဂီး တဗ္လန်လောင်းမာရှိဟှူ လူလေ ဂူလောင်းထတ်ဟှို က္လရော့‑က်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","အယ်ကြောန့် နန်းနို့ဟှာ ဖြစ်လာဟှို့ဇာလေ ဂူလောင်းဟှနေ လွတ်မြော့‑က်ဘီး လူ့သားရဲ့ ရှေ့တော်မာ မတ်တတ်ရပ်နိုင်ဟှို့တွပ် ခီတိုင်း ဒိနနေဘီး ဆုတောန်းဂေ့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ယေရှုဟှာ နေ့ခီလေမာ ဗိမာန်တော်မာ သွန်သန်တော်မူဘီး ညဉ့်ခီလေမာ ပ္လန်ဟှို ထွပ်ဟှားဘီး သံလွင်တောန်ထတ်မာ ညဉ့်ဟှို ကူစေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","လူလေ ဂူလောင်းဟှာ ဗိမာန်တော်မာ တရားနားထောန်ဟှို့ မိုးလန်းစောစောဂီး ကိုယ်တော်နားဟှို လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ပသခါပွဲ ဆိုဘီး ခေါ်ဟှူ တဆေးမှေ့ဘဲဟှူ မုပွဲတော် ခီနီးလာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ယဇ်ပုရောဟိတ်ဂီးလေန ကျမ်းတတ်ဆရာလေဟှာ လူလေဟှို ကြော့‑က်လန့်ဂေ့ဟှူကြောန့် ယေရှုဟှို တိတိဟှားသတ်ဟှို့တွပ် နည်းလမ်းရှာကြံဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","အယ်ဘီးန စာတန်ဟှာ တဗဲ့တော် ဆယ့်နှေ့ပါးထဲဟှ တပါးဖြစ်ဟှူ ဣရှကာရုတ် ဆိုဘီး ခေါ်ဟှူ ယုဒထဲဟှို ဝမ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","အယ်ကြောန့် ယုဒဟှာ ယဇ်ပုရောဟိတ်ဂီးလေန ဗိမာန်တော်စောန့် ကြီးကဲလေနားဟှို သွားဘီး ယေရှုဟှို သူးနို့လတ်ထဲဟှို ဖယ်မျိုး အပ်ရမယ် ဆိုဇာဟှို သူးနို့လေန တိုင်ဗန်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","သူးနို့လေဟှာ ဝန်းသာဘီးဟှာ သူ့ဟှို ကပ်ပေးဟှို့ ဘောတူဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ယုဒဟှာလည်း ဘောတူဘီး လူလေဟှို သိစေဘဲန ယေရှုဟှို သူးနို့လတ်ဟှို အပ်ဟှို့တွပ် ခွမ့်ကောန်းဟှို ရှာကြံလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","တဆေးမှေ့ဘဲဟှူ မုပွဲတော် ခီမာ ပသခါသိုးသားဂန်းလေဟှို သတ်ရဟှူနေ့ ရော့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ယေရှုဟှာ ပေတရုန ယောဟန်ဟှို “ပသခါပွဲတော်ဟှို နို့လေစားဟှို့ သွားဘီး ပြင်ဆင်ဂေ့ပါ” ဆိုဘီး မိန့်တော်မူဘီး သူးနို့ဟှို စေလွှတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","သူးနို့ဟှလည်း “ကိုယ်တော်ဟှ ကျွန်တော့်ဟှားလေဟှို ဖယ်နေရာမာ ပြင်ဆင်စေရှင်ဟှယ်နူး။” ဆိုဘီး မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ကိုယ်တော်ဟှ “နန်းနို့ဟှာ ဗြို့ထဲဟှို ဝမ်ဟှားဟှူ ခီမာ ရေအိုးထမ်းလာဟှူ လူတယော့‑က်ဟှာ နန်းနို့ဟှို လာတွိလေ့မယ်။ အယ်လူ ဝမ်ဟှားဟှူ အီထဲဟှို ဝမ်လိုက်ဟှားဘီးဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","အီဇရှင်ဟှို ‘ဆရာဟှ ငါ့တဗဲ့လေနတူးဒူ ပသခါညဉ့်ဇာစားဟှို့ ခန်းဟှ ဖယ်မာနူး။ ဆိုဘီး မေးခိုင်းလိုက်ဟှယ်’ ဆိုဘီး ပြောဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","အယ်လူဟှ ပြင်ဆင်ဟှားဟှူ ထတ်ခန်းမဟှို နန်းနို့ဟှို ပြလေ့မယ်။ အယ်ခန်းမာ နန်းနို့ ပြင်ဆင်ဂေ့ပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","သူးနို့ဟှာ ထွပ်ဟှားဘီးန ယေရှုဟှ သူးနို့ဟှို မိန့်တော်မူဟှားတိုင်းဘဲ့ ဂူလောင်းဟှို တွိရဟှူကြောန့် ပသခါညဉ့်ဇာဟှို ပြင်ဆင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ခီရော့‑က်လာဟှူ ခီမာ ယေရှုဟှာ တမန်တော်လေနတူးဒူ စားဗွဲမာ ထိုင်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ကိုယ်တော်ဟှာ “ငါဟှာ ဒေါက်ခဝေဒနာခံရခန်မာ အယ်ပသခါ ညဉ့်ဇာဟှို နန်းနို့နတူးဒူ ရရာတိုင်း စားရှင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","နန်းနို့ဟှို ငါပြောမယ်၊ ပသခါပွဲတော်ဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်မာ ပ္လဲ့ဇောင်သေးခန်ထိ အယ်ပွဲတော်ဟှို နော့‑က်ထပ်ခါ ငါစားဟှို့မုဟှ” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","အယ်ဘီးန ယေရှုဟှာ ခွပ်ဟှို ယူဘီး ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟှို ချီးမွမ်းဘီးန “အယ်ခွပ်ဟှို ယူဘီး၊ ရှင်းရှင်းဝီမျှဘီး သော့‑က်ဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","နန်းနို့ဟှို ငါပြောမယ်။ ခုဟှစဘီး ဘုရားသခင်ရဲ့ နိုင်ငံတော် တည်ထောန်ခန်ထိ အယ်စဗျစ်ဝိုင်ဟှို ငါလောင်းဝ သော့‑က်လေ့မယ် မုဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","အယ်ဘီးန ကိုယ်တော်ဟှာ မုဟှိုယူဘီး ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟှို ချီးမွမ်းဘီးန မုဟှို ဖဲ့ဘီးဟှာ သူးနို့လေဟှို ပေးဘီး “အယ်မုဟှာ နန်းနို့တွပ် စွန့်ဟှူ ငါ့ရဲ့ ကိုယ်ခန္ဓာ ဖြစ်ဟှယ်။ ငါ့ဟှို အော့‑က်မေ့ဟှို့ အယ်မျိုးလောက်ဂေ့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","အယ်မျိုးဘဲ့ ညဉ့်ဇာစားဘီးန ကိုယ်တော်ဟှာ ခွပ်ဟှိုလည်း ယူဘီးဟှာ “အယ်ခွပ်ဟှာ နန်းနို့တွပ် သွန်းလောန်းဟှူ ငါ့ရဲ့ သွီးန ဇိခတ်ဟှားဟှူ ဘုရားသခင်ရဲ့ ပဋိညာဉ်တရားသစ် ဖြစ်ဟှယ်” ");
INSERT INTO tvn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“အယ်ဘေမဲ့ ငါ့ဟှို အပ်မယ့်လူရဲ့ လတ်ဟှာ ငါ့နတူးဒူ စားဗွဲထတ်မာ ရှိနေဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","လူ့ရဲ့သားဟှာ ဘုရားသခင် ခ္လမှတ်ဟှားတိုင်းဘဲ့ သေခံဟှို့ မှန်ဘဲ့သွားရမယ်။ အယ်ဘေမဲ့ လူ့ရဲ့သားဟှို အပ်ဟှူလူဟှာ အမင်္ဂလာရှိဟှယ်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","အယ်ဘီးန တဗဲ့တော်လေဟှာ နို့လေထဲဟှ ဖယ်သူဟှာ အယ်မျိုးလောက်ဟှို့နူး။ ဆိုဘီး သူးနို့ရှင်းရှင်း မေးဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","သူးနို့လေထဲဟှ ဖယ်သူ့ဟှို ကီးမြတ်ဆောင်း ဖြစ်ဟှယ် ဆိုဘီး မှတ်ယူရမယ် ဆိုဇာဟှို သူးနို့ရှင်းရှင်း ဂြင်းခူဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ယေရှုဟှ သူးနို့လေဟှို “လူမျိုးခြားလေရဲ့ မန်းဂီးလေဟှာ ပြည်သူလေထတ်မာ စိုးတရ လောက်တတ်ဂေ့ဟှယ်။ လူလေထတ်မာ အာဏာရှိဟှူ သူလေဟှိုလည်း သူများကျိုးဆောန်ဝှပ်သူ ဆိုဘီး ခေါ်ခံရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","အယ်ဘေမဲ့ နန်းနို့လေဟှ အယ်မျိုးလောက်ဂေ့န။ နန်းနို့ထဲမာ ကီးမြတ်ဆောင်းဖြစ်ဟှူ သူဟှာ ငယ်ဆောင်းဟှူ သူမျိုး ဖြစ်ရမယ်။ ဦးဆောန်ဟှူ သူဟှာ စေခံမျိုး ဖြစ်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","စားဗွဲမာ ထိုင်နေဟှူသူန စေခံဟှူ သူလေထဲမာ ဖယ်သူဟှ ပိုဘီး ကီးမြတ်နူး။ စားဗွဲမာ ထိုင်နေဟှူသူ မှုဟှလော။ အယ်ဘေမဲ့ ငါဟှာ နန်းနို့ထဲမာ စေခံဟှူသူမျိုး ဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“စောင်ဇမ်း နှောန့်ယှစ်ရှင်းလေဟှို ငါခံနေရဒူးမာ နန်းနို့ဟှာ ငါ့နတူးဒူ ရပ်တည်ပေးဟှူ လူလေ ဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","အယ်ဘီးဟှာ ငါ့ဖဟှ ငါ့ဟှို နိုင်ငံတော်ဟှို ပေးအပ်ဟှူမျိုးဘဲ့ ငါဟှလည်း နိုင်ငံတော်ဟှို နန်းနို့ဟှို ပေးအပ်မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","နန်းနို့ဟှာ ငါ့ရဲ့ နိုင်ငံတော်မာ ငါ့ရဲ့ စားဗွဲမာ ထိုင်ဘီး စားသော့‑က် ရဂေ့လေ့မယ်။ အယ်ဘီးဟှာ ပလ္လင်ထတ်မာ ထိုင်ဘီး ဣသရေလမျိုးနွယ် ဆယ့်နှေ့နွယ်ဟှို တရားစီရင် ရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ရှိမုန်၊ ရှိမုန်! နားထောန်ပါ! ဂျောင်ဆန်ဟှို ဇဂါခ္လဟှူမျိုးဘဲ့ စာတန်ဟှ နန်းနို့ဂူလောင်းဟှို ဇဂါခ္လဟှို့တွပ် ခွမ့်တောန်းလေဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","အယ်ဘေမဲ့ နန့်ရဲ့ ယောင်ကြည်ရှင်း ဆောင်းရှောင်းဘဲဟှို့တွပ် ငါဆုတောန်းနေဟှယ်။ နန်ဟှာ ငါဖတ်ဟှို ပ္လန်လှည့်လာဟှူ ခီမာ နန့်ရဲ့ ညီကိုလေဟှို ခိုင်ခံ့စေပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ပေတရုဟှ “သခင်၊ ကျွန်တော်ဟှာ ကိုယ်တော်နတူးဒူ ထောန်ဘဲ့က္လက္လ၊ သေဘဲ့သေသေ ဆင်သင့်ရှိဟှယ်!” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ယေရှုဟှ “ပေတရု၊ နန့်ဟှို ငါပြောမယ်။ အယ်ညဉ့် ကြစ်တွန်ခန်မာ နန်ဟှာ ငါဟှို သိဟှ ဆိုဘီး သောင်းခါ ငြင်းလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","အယ်ဘီးန ယေရှုဟှာ “နန်းနို့ဟှို ကပ်အိ၊ လွယ်အိန ခေနပ်မှေ့ဘဲ စေလွှတ်ဟှူ ခီမာ နန်းနို့လေမာ လိုအပ်ဇာလေ ရှိသေးလော။” ဆိုဘီး တဗဲ့တော်လေဟှို မေးလေဟှယ်။ သူးနို့ဟှာ “မှေ့ဟှ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ယေရှုဟှ “အယ်ဘေမဲ့ ခု ကပ်အိရှိဟှူ သူဟှာ ယူဟှားစေ။ လွယ်အိရှိဟှူ သူဟှာလည်း ယူဟှားစေ။ ထားမှေ့ဘဲဟှူ သူဟှာ မိမိဝတ်လောင်ဟှို ရောန်းဘီးဟှာ ထားဟှို ဝယ်စေ။ ");
INSERT INTO tvn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","နန်းနို့ဟှို ငါပြောမယ်၊ ‘သူဟှာ တရားမှေ့ဘဲဟှူ သူလေရဲ့ စာရင်းထဲမာ ထဲ့သွမ်းရှင်းခံရမယ်’ ဆိုဘီး ကျမ်းစာမာ ရေးဟှားဟှူဇာဟှာ ငါ့မာ ပ္လဲ့ဇောင်ရမယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါ့ကြောန်းဟှို ရေးဟှားဇာဟှာ ပ္လဲ့ဇောင်ရှင်းဟှို ရော့‑က်နေဘီ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","တဗဲ့တော်လေဟှ “သခင်! ကေ့တော်မူပါ! အယ်မာ ထားနှေ့ရှောန်း ရှိဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ကိုယ်တော်ဟှ “အယ်ဆိုဟှာ ရလော့‑က်ဘီ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ယေရှုဟှာ ဗြို့ထဲဟှနေ ထွပ်ဟှားဘီး ခါတိုင်းမျိုးဘဲ့ သံလွင်တောန်ထတ်ဟှို ကြွတော်မူဟှယ်။ တဗဲ့တော်လေလည်း ကိုယ်တော်နတူးဒူ လိုက်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","အယ်နေရာဟှို ရော့‑က်ဟှူ ခီမာ ကိုယ်တော်ဟှ “နန်းနို့လေဟှာ သွီးဆောန်ရှင်းထဲဟှို က္လဘဲဟှို့တွပ် ဆုတောန်းဂေ့” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","အယ်ဘီးန ကိုယ်တော်ဟှာ သူးနို့လေန က္လော့‑က်ခဲတပစ်ဇာလောက် ဝီးဟှို သွားဘီးဟှာ ဒူးထော့‑က်ဘီးန ဆုတောန်းဟှူဇာဟှ ");
INSERT INTO tvn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ကိုယ်တော်ဟှ “ဖ၊ ဖြစ်နိုင်မယ် ဆိုဟှာ အယ်မူဝေဒနာခွပ်ဟှို ကျွန်တော့်ဟှနေဘီး ယူဟှားပေးပါ။ အယ်ဘေမဲ့ ကျွန်တော့် လိုရှင်တိုင်းဖြစ်စေဘဲန ဖလိုရှင်းတိုင်းဘဲ့ ဖြစ်စေပါ” ဆိုဘီး ဆုတောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","အယ်ခီမာ ကောန်းဂန်ဘောင်ဟှ ကောန်းဂန်တမန်တပါးဟှာ ကိုယ်တော်နားမာ ပေါ်လာဘီး ကိုယ်တော့်ဟှို အားပေးတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ကိုယ်တော်ဟှာ ပြင်းထန်ဟှူ ဝေဒနာဟှို ခံစားဘီး ပိုဘီး ပြင်းပြင်းထန်ထန် ဆုတောန်းဟှူကြောန့် ကိုယ်တော်ရဲ့ ချွေးဟှာ သွီးစစ်လေမျိုး မ္လေဂီးထတ်ဟှို က္လလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ကိုယ်တော်ဟှာ ဆုတောန်းရာဟှနေ ထတော်မူဘီး တဗဲ့တော်လေနားဟှို ပ္လန်လာဟှူ ခီမာ သူးနို့လေဟှာ ဝန်းနဲဘီး အိမွိနေဇာဟှို တွိဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ကိုယ်တော်ဟှာ “နန်းနို့လေ ဖြားဖြစ်ကြောန့် အိမွိနေဂေ့နူး။ သွီးဆောန်ရှင်းထဲဟှို က္လဘဲဟှို့တွပ် ထဒန်ဘီး ဆုတောန်းဂေ့” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","အယ်မျိုးမိန့်တော်မူနေဒူးမာဘဲ့ တဗဲ့တော် ဆယ့်နှေ့ပါးထဲဟှ တပါးဖြစ်ဟှူ ယုဒဟှာ လူအောက်ဂီးဟှို ဦးဆောန်ဘီး ရော့‑က်လာဟှယ်။ သူဟှာ ယေရှုဟှို နမ်းဟှို့တွပ် တိုးဝမ်လာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","အယ်ဘေမဲ့ ယေရှုဟှ “ယုဒ၊ လူ့ရဲ့သားဟှို နမ်းရှင်းအားဖြင့် အပ်ဟှို့လော။” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ယေရှုနတူးဒူ ရှိနေဂေ့ဟှူ တဗဲ့တော်လေဟှာ ဖြစ်လာမယ့်ဇာဟှို သိလိုက်ဟှူ ခီမာ သူးနို့ဟှ “သခင်၊ ကျွန်တော့်ဟှားလေ ထားန ခွတ်ရဟှို့လော။” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","သူးနို့ထဲဟှ တယော့‑က်ဟှာ ယဇ်ပုရောဟိတ်မန်းရဲ့ ကျွန်တယော့‑က်ဟှို ခွတ်လိုက်ဇာ အယ်လူရဲ့ ညာဖတ်နားဝှပ်ဟှာ ပြတ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","အယ်ဘေမဲ့ ယေရှုဟှာ “တော်ဘီ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ကိုယ်တော်ဟှာ အယ်လူရဲ့ နားဝှပ်ဟှို လတ်တော်န ထိလိုက်ဘီး ပ္လန်ကောန်းစေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","အယ်ဘီးန ယေရှုဟှာ မိမိဟှို ဖမ်းဟှို့ရော့‑က်လာဟှူ ယဇ်ပုရောဟိတ်ဂီးလေ၊ ဗိမာန်တော်စောန့် တပ်မှူးလေန သတ်ကီးဝါဂီးလေဟှို “နန်းနို့ဟှာ မ္လဟှို ဖမ်းဟှူမျိုး ထားလေ၊ ဒေါက်လေဟှို ကိုင်ဆောန်ဘီး လာဂေ့ရလော။ ");
INSERT INTO tvn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ငါဟှာ နေ့တိုင်း နန်းနို့နတူးဒူ ဗိမာန်တော်မာ ရှိနေဒူးမာ နန်းနို့ဟှာ ငါ့ဟှို ဖမ်းဂေ့ဟှ။ အယ်ဘေမဲ့ အယ်မျိုး လောက်ဆောန်ဟှို့တွပ် နန်းနို့ရဲ့ခီ ဖြစ်ဟှယ်။ မှောန်မိုက်တဂိုးလည်း ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","သူးနိုးလေဟှ ယေရှုဟှို ဖမ်းဘီးဟှာ ယဇ်ပုရောဟိတ်မန်းရဲ့ အီဟှို ခေါ်ဟှားဂေ့ဟှယ်။ ပေတရုဟှာလည်း ခပ်ဝီးဝီးဟှနေ လိုက်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","အီဝမ်းရဲ့ လယ်မာ မီးဗောင်ဟှို ဝိုင်းဘီးထိုင်နေဟှူ လူလေကြားထဲမာ ပေတရုဟှာ ဝမ်ထိုင်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","အယ်မျိုး ပေတရုဟှာ မီးဗောင်းနားမာ ထိုင်နေဇာဟှို စေခံမီးမ တယော့‑က်ဟှ ဗြင်ဟှားဟှူုကြောန့် သူ့ဟှို စေ့စေ့ကေ့ဘီး “အယ်လူဟှာလည်း ယေရှုရဲ့ ပေါန်းဖော် ဖြစ်ဟှယ်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","အယ်ဘေမဲ့ ပေတရုဟှ “ဝှေ့မီးမ၊ အယ်သူဟှို ငါ သိဟှ!” ဆိုဘီး ဂြင်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ရှစ်ဟှားကြာဘီးန လူတယော့‑က်ဟှာ ပေတရုဟှို ဗြင်ဟှားဟှူ ခီမာ “နန်လည်း သူးနို့လေထဲဟှ တယော့‑က်ဘဲ့ ဖြစ်ဟှယ်!” ဆိုဘီး ပြောလေဟှယ်။ အယ်ဘေမဲ့ ပေတရုဟှာ “ဝှေ့လူ၊ ငါဟှာ သူးနို့ထဲဟှ မှုဟှ!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","တနာရီလော့‑က် ကြာဘီးန တခြားတယော့‑က်ဟှ “မှန်တိုင်း ပြောရမယ် ဆိုဟှာ အယ်သူဟှာ ဂါလိလဲလူ ဖြစ်ဟှူကြောန့် ယေရှုန ပေါန်းဖော်ဟှူသူ ဖြစ်ဟှယ်!” ဆိုဘီး ခိုင်ခိုင်မာမာ ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","အယ်ဘေမဲ့ ပေတရုဟှ “ဝှေ့လူ၊ နန်ပြောနေဇာလေဟှို ငါ သိဟှ!” ဆိုဘီး ပ္လန်ပြောလေဟှယ်။ သူအယ်မျိုး ပြောနေဒူးမာဘဲ့ ကြစ်တွန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","အယ်ခီမာ သခင်ဘုရားဟှာ လှည့်ဘီး ပေတရုဟှို စူးစိုက်ဘီး ကေ့တော်မူဟှယ်။ ပေတရုဟှလည်း “အယ်ညဉ့် ကြစ်တွန်ခန်မာ နန်ဟှာ သောင်းခါတိတိ ငြင်းပယ်လေ့မယ်” ဆိုဘီး မိန့်တော်မူဟှားဟှူ သခင်ဘုရားရဲ့ စကားတော်ဟှို ပ္လန်အော့‑က်မေ့လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","အယ်ကြောန့် ပေတရုဟှာ ပ္လန်ဟှို ထွပ်ဟှားဘီး ရရာတိုင်း ငိုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ယေရှုဟှို စောန့်ကြပ်နေဟှူ လူလေဟှ ကိုယ်တော့်ဟှို လှောန်ပြောန်ဘီး ရိုက်နှက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","သူးနို့လေဟှ ကိုယ်တော်ရဲ့ မျစ်နှာဟှို ဖောင်းဘီးဟှာ “ကိုယ်တော့်ဟှို ဖယ်သူလေ ရိုက်ဂေ့နူး။ ပရောဖက်ပြုဂေ့!” ဆိုဘီး ကိုယ်တော့်ဟှို မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","အယ်ဘီးဟှာ သူးနို့လေဟှ တခြားကဲ့ရဲ့ဇာလေ ဘောင်ဂီးန ကိုယ်တော့်ဟှို ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","မိုးလန်းဟှားဟှူ ခီမာ သတ်ကီးဝါဂီးလေ၊ ယဇ်ပုရောဟိတ်ဂီးလေန ကျမ်းတတ်ဆရာလေဟှာ စုဝီးဂေ့ဘီး ယေရှုဟှို တရားလွှတ်တော်ရှေ့ဟှို ခေါ်ဆောန်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","သူးနို့လေဟှ “နန်ဟှာ မေရှိယဘဲ့လော။ နို့လေဟှို ပြောပါ” ဆိုဘီး မေးဂေ့ဟှယ်။ ကိုယ်တော်ဟှ “နန်းနို့ဟှို ငါပြောမယ် ဆိုဟှာလည်း နန်းနို့ ယောင်ကြည်ဂေ့ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","နန်းနို့ဟှို ငါ မေးမေးမယ် ဆိုဟှာလည်း နန်းနို့ ဖြေဂေ့ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","အယ်ဘေမဲ့ ခုဟှနေဘီး လူ့ရဲ့သားဟှာ အနန္တတဂိုးရှင် ဘုရားသခင်ရဲ့ ညာဖတ်မာ ထိုင်တော်မူလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","သူးနို့လေ ဂူလောင်းဟှာ “အယ်မျိုးဆိုဟှာ နန်ဟှ ဘုရားသခင်ရဲ့သား ဖြစ်ဟှယ်လော။” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ကိုယ်တော်ဟှာ “နန်းနို့ မေးဟှူတိုင်းဘဲ့ ငါဖြစ်ဟှယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","အယ်ဘီးန သူးနို့လေဟှာ “နို့လေကိုယ်တိုင် သူ့ရဲ့နှော့‑က်ဟှနေ အယ်စကားလေဟှို ကြားရဘီ ဖြစ်ဟှူကြောန့် နော့‑က်ထပ် ဖြားသတ်သေလေ လိုသေးဟှယ်နူး!” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","တရားလွှတ်တော် တဖွဲ့လောင်းဟှာ ထဘီးန ယေရှုဟှို ပိလတ်မန်းရှေ့ဟှို ခေါ်ဆောန်ဟှားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","အယ်နေရာမာ သူးနို့လေဟှာ ကိုယ်တော့်ဟှို “ကဲသာမန်းဂီးဟှို ခွန်ဆောန်ဇာလိုဟှ ဆိုဘီး သူးနို့ဟှို ပြောဘီး သူ့ကိုယ်သူလည်း မေရှိယဖြစ်ဟှူ မန်းဂီး ဖြစ်ဟှယ် ဆိုဘီး လူလေဟှို လမ်းမှားအောန် လောက်နေကြောန့် ကျွန်တော့်ဟှားလေဟှာ အယ်လူဟှို ဖမ်းလာဟှယ်” ဆိုဘီး စွပ်စွဲဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ပိလတ်ဟှာ “နန်ဟှာ ယုဒမန်းဂီးလော။” ဆိုဘီး ကိုယ်တော့်ဟှို မေးလေဟှယ်။ ယေရှုဟှ “မန်းဂီးမေးဟှူတိုင်းဘဲ့ ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","အယ်ဘီးန ပိလတ်မန်းဟှာ ယဇ်ပုရောဟိတ်ဂီးလေန လူအောက်ဂီးဟှို “ငါဟှာ အယ်လူမာ ပြစ်တခုလည်း ငါတွိဟှ” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","အယ်ဘေမဲ့ သူးနို့လေဟှာ “သူဟှာ ဂါလိလဲနယ်ဟှနေ အယ်နေရာထိတိုင်အောန် ယုဒနယ် တနယ်လောင်းမာ သွန်သန်ဘီး လူလေဟှို နှိုးဆော်နေဟှူသူ ဖြစ်ဟှယ်” ဆိုဘီး ပြင်းပြင်းထန်ထန်ဟှား ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ပိလတ်ဟှာ အယ်စကားလေဟှို ကြားဟှူ ခီမာ “အယ်လူဟှာ ဂါလိလဲနယ်သားလော။” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ဟေရုဒ် အောက်စိုးဟှူ နယ်ဟှ ဖြစ်ဟှယ် ဆိုဇာဟှို သိဟှားဟှူ ခီမာ ကိုယ်တော့်ဟှို ဟေရုဒ်နားဟှို ပို့စေလိုက်ဟှယ်။ အယ်ခီမာ ဟေရုဒ်ဟှာလည်း ယေရုရှလင်ဗြို့မာ ရှိနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ဟေရုဒ်ဟှာ ယေရှုဟှို ဗြင်ဟှူ ခီမာ ရရာတိုင်း ဝန်းသာဟှားဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကိုယ်တော့်ကြောန်းဟှို ကြားဟှားဘီး ကိုယ်တော့်ဟှို တွိရှင်နေဇာဟှာ ကြာဘီ။ ယေရှုလောက်ပြမယ့် နိမိတ်လတ်ခဏာ တချို့ဟှို တွိရဟှို့ မျှော်လင့်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","အယ်ကြောန့် ဟေရုဒ်ဟှ ယေရှုဟှို မေးခွန်းလေ ဘောင်ဂီးမေးလေဟှယ်။ အယ်ဘေမဲ့ ကိုယ်တော်ဟှာ ဖြေဘဲ့န နေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ယဇ်ပုရောဟိတ်ဂီးလေန ကျမ်းတတ်ဆရာလေဟှာ ရှေ့ဟှို တိုးလာဘီး ယေရှုဟှို ပြင်းပြင်းထန်ထန်ဟှား စွပ်စွဲဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ဟေရုဒ်န သူ့ရဲ့စစ်သားလေဟှာ ယေရှုဟှို ထီလေးဇာလောက်ဘီး လှောန်ပြောန်ဂေ့ဟှယ်။ အယ်ဘီးန သူးနို့လေဟှာ ကောန်းဇားဝတ်လောင်ဟှို ဝတ်ပေးဘီးဟှာ ကိုယ်တော့်ဟှို ပိလတ်မန်းနားဟှို ပ္လန်ပို့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ရင်းရင်ဒူးဟှ ရန်သူဖြစ်ဂေ့ဟှူ ဟေရုဒ်န ပိလတ်မန်းဟှာ အယ်နေ့မာ မိဆွေလေ ဖြစ်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ပိလတ်မန်းဟှာ ယဇ်ပုရောဟိတ်ဂီးလေ၊ ခေါန်းဆောန်လေန လူလေဟှို ခေါ်လိုက်ဘီး ");
INSERT INTO tvn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“နန်းနို့လေဟှာ လူလေဟှို လမ်းမှားအောန် နှိုးဆော်ဟှူသူ ဖြစ်ဟှယ် ဆိုဘီး အယ်လူဟှို ငါနားဟှို ခေါ်လာဂေ့ဟှယ်။ ခု နန်းနို့လေရဲ့ ရှေ့မာ ငါစစ်ဆေးဘေမဲ့ အယ်လူမာ နန်းနို့လေ စွပ်စွဲဟှားဟှူ ပြစ်တခုလည်း တွိဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ဟေရုဒ်လည်းဘဲ့ ပြစ်ရှာတွိဘဲဟှူကြောန့် သူ့ဟှို နို့လေနားဟှို ပ္လန်ပို့လိုက်ဟှယ်။ အယ်လူဟှာ သေဒန်န ထိုက်တန်ဟှူ ပြစ်တခုလည်း ကျူးလွန်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","အယ်ကြောန့် အယ်လူဟှို ကီဒန်ပေးဘီးဟှာ လွှတ်လိုက်မယ်” ဆိုဘီး သူးနို့လေဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","အယ်ဘေမဲ့ လူအောက်ဂီး တခုလောင်းဟှ “အယ်သူဟှို သတ်ပါ! ကျွန်တော့်ဟှားလေတွပ် ဗာရဗ္ဗဟှို လွှတ်ပေးပါ!” ဆိုဘီး အော်ဟစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(ဗာရဗ္ဗဟှာ ဗြို့ထဲမာ ဆူပူမှုန လူသတ်မှုလေတွပ် ထောန်က္လနေလေဟှယ်။) ");
INSERT INTO tvn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ပိလတ်မန်းဟှာ ယေရှုဟှို လွှတ်ပေးရှင်ဟှူကြောန့် လူအောက်ဂီးဟှို နော့‑က်တခါ ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","အယ်ဘေမဲ့ လူလေဟှ “သူ့ဟှို ကားစင်တန်ပါ! ကားစင်တန်ပါ!” ဆိုဘီး အော်ဟစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ပိလတ်မန်းဟှ “အယ်သူဟှာ ဖြားပြစ်ဟှို လောက်ဟှားနူး။ အယ်သူဟှာ သေဒန်န ထိုက်တန်ဟှူ ပြစ်လောက်ဟှားဟှယ် ဆိုဇာဟှို ငါ တွိဟှ! အယ်ကြောန့် အယ်သူဟှို ကီဒန်ပေးဘီးဟှာ လွှတ်လိုက်မယ်” ဆိုဘီး သူးနို့ဟှို တတိယခါ ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","အယ်ဘေမဲ့ လူလေဟှာ ယေရှုဟှို ကားစင်တန်ရမယ် ဆိုဘီး သံက္လယ်ဂီးအော်ဘီး တောန်းဆိုဂေ့ဟှယ်။ နော့‑က်ဆောင်းမာ သူးနို့လေရဲ့ တောန်းဆိုရှင်းဟှာ အောန်မြင်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","အယ်ကြောန့် သူးနို့လေ တောန်းဆိုဟှားဟှူတိုင်း ပိလတ်ဟှာ ယေရှုဟှို သေဒန်ပေးဟှို့ ဆောင်းဖြတ်ပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ဆူပူမှုန လူသတ်မှုလေတွပ် ထောန်က္လနေဟှူ သူဟှို သူးနို့လေ တောန်းဆိုဟှားဟှူတိုင်း လွှတ်ပေးလိုက်ဘီး ယေရှုဟှို သူးနို့ ဆန္ဒတိုင်း လောက်စေဟှို့တွပ် အပ်ပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","စစ်သားလေဟှာ ယေရှုဟှို ခေါ်ဆောန်ဟှားဟှူ ခီမာ တောဝါဟှနေ လာနေဟှူ ကုရေနေဗြို့သား ရှိမုန်ဟှို ဖမ်းဘီး သူ့ထတ်မာ လတ်ဝါးကပ်တိုင်ဟှို တန်ပေးလေဟှယ်။ အယ်ဘီးဟှာ လတ်ဝါးကပ်တိုင်ဟှို ထမ်းခိုင်းဘီး ယေရှုနော့‑က်ဟှနေ လိုက်စေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ကိုယ်တော်နော့‑က်ဟှနေ လိုက်နေဟှူ လူအောက်ဂီးထဲဟှ မီးမတချို့ဟှာ ငိုကြွေးဘီး မြည်တမ်းနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ယေရှုဟှာ အယ်မီးမလေဟှို လှည့်ကေ့ဘီးဟှာ “ယေရုရှလင်ဗြို့သူလေ! ငါ့တွပ်ငိုဂေ့န။ နန်းနို့န နန်းနို့ရဲ့ သားမီးလေတွပ်ဘဲ့ ငိုဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ‘မြုံနေဟှူ မီးမလေ၊ သားမွီးဖူးဘဲဟှူ မီးမလေ၊ နို့တိုက်ဖူးဘဲဟှူ မီးမလေဟှာ မင်္ဂလာရှိလေဟှယ်!’ ဆိုဘီး လူလေဟှ ပြောဟှို့ နေ့ရစ်လေဟှာ ရော့‑က်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","အယ်ခီမာ လူလေဟှာ တောန်လေဟှို ‘နို့လေထတ်ဟှို က္လဂေ့ပါ!’ တောန်ဂူးလေဟှို ‘နို့လေဟှို ဖောင်းအောက်ဂေ့ပါ!’ ဆိုဘီး ပြောဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ စီးစိုနေဟှူပန်ဟှို အယ်မျိုးလောက်ဟှယ် ဆိုဟှာ ခြော့‑က်နေဟှူပန် ဆိုဟှာ ဖြားမျိုးဖြစ်လေ့မယ်နူး။” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ရာဇဝတ်သား နှေ့ယော့‑က်ဟှိုလည်း ယေရှုနတူးဒူ သတ်ဟှို့တွပ် ခေါ်ဆောန်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","“ဦးခေါန်းခွံနေရာ” ဟှို ရော့‑က်ဟှူ ခီမာ သူးနို့ဟှာ ယေရှုဟှို ကားစင်တန်လေဟှယ်။ အယ်ဘီးဟှာ ရာဇဝတ်သား နှေ့ယော့‑က်ဟှိုလည်း ကိုယ်တော်ရဲ့ ညာဖတ်မာ တယော့‑က်၊ ဘယ်ဖတ်မာ တယော့‑က် ထားဘီးဟှာ ကားစင်တန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ယေရှုဟှ “ဖ! သူးနို့လေဟှာ သူးနို့ ဖြားလောက်ဟှယ် ဆိုဇာဟှို သိဂေ့ဘဲဟှူကြောန့် သူးနို့လေဟှို ခွမ့်လွှတ်တော်မူပါ” ဆိုဘီး ပြောလေဟှယ်။ သူးနို့လေဟှာ ကိုယ်တော်ရဲ့ ဝတ်စားလေဟှို မဲနှိုက်ဘီး ခွဲဝီယူဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","လူလေဟှာ ရပ်ဘီး ကေ့နေဂေ့ဟှယ်။ ယုဒခေါန်းဆောန်လေဟှ ကိုယ်တော့်ဟှို “အယ်လူဟှာ ဘုရားသခင် ဝီးကော့‑က်ဟှားဟှူ မေရှိယဖြစ်ဟှယ် ဆိုဟှာ တခြားလူလေဟှို ကယ်တန်မျိုး သူ့ကိုယ်သူ ကယ်တန်ပါစေ!” ဆိုဘီး လှောန်ပြောန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","စစ်သားလေဟှလည်း ကိုယ်တော်နားဟှို တိုးဝမ်လာဘီး ဝိုင်ရှင်ဟှို တိုက်ဘီး ");
INSERT INTO tvn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“နန်ဟှာ ယုဒမန်းဂီးဖြစ်ဟှယ် ဆိုဟှာ နန့်ကိုယ်နန် ကယ်တန်ပါ!” ဆိုဘီး လှောန်ပြောန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ကိုယ်တော်ရဲ့ ထတ်ဖတ်မာလည်း “အယ်သူဟှာ ယုဒမန်းဂီး ဖြစ်ဟှယ်” ဆိုဘီး ရေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","လတ်ဝါးကပ်တိုင်မာ ခိဆွဲဟှားဟှူ ရာဇဝတ်သား နှေ့ယော့‑က်ထဲဟှ တယော့‑က်ဟှာ “နန်ဟှာ မေရှိယ မှုဟှလော။ နန့်ကိုယ်နန် ကယ်တန်ဘီး နို့လေဟှိုလည်း ကယ်တန်ပါ!” ဆိုဘီး ကိုယ်တော့်ဟှို ကဲ့ရဲ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","အယ်ဘေမဲ့ တခြား ရာဇဝတ်သားဟှ အယ်သူဟှို ပြစ်တန်ဘီး “နန်ဟှာ အယ်သူမျိုးဘဲ့ ဒန်စီရင်ရှင်းဟှို ခံနေရတောန်မှ ဘုရားသခင်ဟှို ကြော့‑က်ဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","နို့လေဟှ နို့လေလောက်ဟှားဟှူ ပြစ်လေန ထိုက်တန်ဟှူ ဒန်ဟှို ခံရဇာဟှာ တရားပါဟှယ်။ အယ်ဘေမဲ့ အယ်သူဟှာ ဖြားပြစ်ဟှိုမျှ လောက်ဟှားဇာ မှုဟှ” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","အယ်ဘီးန သူဟှ “ယေရှု၊ ကိုယ်တော်ရဲ့ နိုင်ငံတော်ဟှို ကြွလာဟှူ ခီမာ ကျွန်တော့်ဟှို အော့‑က်မေ့တော်မူပါ!” ဆိုဘီး ယေရှုဟှို လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ယေရှုဟှာ “နန့်ဟှို ငါ မှန်တိုင်းပြောမယ်၊ အယ်နေ့ဘဲ့ နန်ဟှာ ငါ့နတူးဒူ ပရဒိသုဘောင်မာ ရှိမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","အယ်ခီဟှာ မွန်းဒဲ့ခီလော့‑က်ဖြစ်ဟှယ်။ နေဒန်ဇာ သောင်းနာရီထိ ဒေသတခုလောင်း မှောန်မိုက် ဖြစ်ဟှားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","နေရောန်ဟှာ ကွယ်ပျော့‑က်ဟှားလေဟှယ်။ အယ်ဘီးဟှာ ဗိမာန်တော်ထဲမာ ခိဆွဲဟှားဟှူ လိုက်ကာဟှာ နှေ့ခြမ်းကွဲဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ယေရှုဟှာ “ဖ! ကျွန်တော့်ရဲ့ ဝိညာဉ်ဟှို ဖရဲ့လတ်ထဲမာ အပ်ပါဟှယ်!” ဆိုဘီး သံက္လယ်ဂီးန အော်တော်မူဘီးန သတ်ချောက်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","အယ်မျိုးဖြစ်ဇာဟှို ဗြင်လိုက်ဟှူ တပ်မှူးဟှ ဘုရားသခင်ဟှို ချီးမွမ်းလိုက်ဘီး “အယ်သူဟှာ မှန်ဘဲ့ ဖြောန့်မတ်ဟှူသူ ဖြစ်လေဟှယ်!” ဆိုဘီး ပြောနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","အယ်မူဇာဟှို ကေ့ဇားဟှို့ စုလာဂေ့ဟှူ လူလေဟှာ အယ်မျိုးဖြစ်ဇာဟှို ဗြင်လိုက်ဟှူ ခီမာ ရင်ဖတ်ဟှို ထုအိုက်ဘီး ပ္လန်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ဂါလိလဲနယ်ဟှနေ ကိုယ်တော်နော့‑က်ဟှို လိုက်လာဟှူ မီးမလေရော၊ ယေရှုန ရရာတိုင်း ရင်းနှီးဟှူ လူလေရော ဝီးဟှနေ ရပ်ကေ့ဇားနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","အယ်ခီမာ ဖြောန့်မတ်ဘီး သူတော်ကောန်း ဖြစ်ဟှူ ယောသပ် နာမယ်ရှိဟှူ လွှတ်တော်ဖွဲ့ဝမ် တယော့‑က် ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","သူဟှာ တရားလွှတ်တော်ရဲ့ ဆောင်းဖြတ်ချစ်န လောက်ဆောင်ချစ်ဟှို ဘောတူဟှ။ ယောသပ်ဟှာ ယုဒပြည်၊ အရိမသဲဗြို့သား ဖြစ်ဘီး ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို စောန့်မျှော်နေဟှူ သူလည်း ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","သူဟှာ ပိလတ်ရှေ့ဟှို သွားဘီးန ယေရှုရဲ့ လောန်းတော်ဟှို တောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","အယ်ဘီးန လောန်းတော်ဟှို လတ်ဝါးကပ်တိုင်ဟှနေ ခ္လဘီး ပိဖ္လူန ပတ်လေဟှယ်။ က္လော့‑က်ဆောန်ဟှို ထွမ်းဟှားဘီး တခါလည်း သောင်းသေးဘဲဟှူ သန်းခ္လိုင်းဂူထဲမာ ထားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","အယ်နေ့ဟှာ ဖိနေ့ ဖြစ်ဘီး ဒန်းနေ့လည်း ရော့‑က်ခါနီးလေဘီ။ ");
INSERT INTO tvn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ဂါလိလဲနယ်ဟှနေ ယေရှုနော့‑က်ဟှို လိုက်လာဟှူ မီးမလေဟှာ ယောသပ်နတူးဒူ သွားဘီး သန်းခ္လန်းဂူဟှိုရော၊ ယေရှုရဲ့ လောန်းတော်ဟှိုရော ဖယ်မျိုးထားဟှားဟှယ် ဆိုဇာဟှို ဗြင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","အယ်ဘီးန သူးနို့လေဟှာ အီဟှို ပ္လန်ဟှားဘီး လောန်းတော်တွပ် ဆီမွှီးန နံ့သာပေါန်းလေဟှို ပြင်ဆင်ဂေ့ဟှယ်။ ဒန်းနေ့မာ သူးနို့လေဟှာ ပညတ်တော်တိုင်း နားယူဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","နန်းနွေနေ့ မိုးလန်းစောဂီးမာ အယ်မီးမလေဟှာ သူးနို့ကိုယ်တိုင် ပြင်ဆင်ဟှားဟှူ နံ့သာပေါန်းလေဟှို ယူဆောန်ဘီး သန်းခ္လိုင်းဂူဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","သူးနို့လေဟှာ သန်းခ္လိုင်းဂူဝဟှ က္လော့‑က်တောင်းဟှို လှိမ့်ဖယ်ဟှားဇာဟှို တွိဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","အယ်ကြောန့် သူးနို့လေဟှာ သန်းခ္လိုင်းထဲဟှို ဝမ်ဟှားဂေ့ဟှယ်။ အယ်ဘေမဲ့ သခင်ယေရှုရဲ့ လောန်းတော်ဟှို တွိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","အယ်ကြောန့် သူးနို့လေဟှာ အယ်ကြောန်းရာဟှို စဉ်းစားနိုင်ဘဲဖြစ်နေဒူးမာ တော့‑က်ပဟှူ ဝတ်ဟှို ဝတ်စားဟှားဟှူ လူနှေ့ယော့‑က်ဟှာ ရောက်တရစ် သူးနို့နားမာ ပေါ်လာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","အယ်မီးမလေဟှ ကြော့‑က်လန့်ဘီး မ္လေဂီးမာ ပျပ်ဝပ်နေဂေ့ဟှယ်။ အယ်သူနှေ့ယော့‑က်ဟှာ “နန်းနို့လေဟှ သေဟှူသူလေထဲမာ သတ်ရှင်ဟှူသူဟှို ဖြားဖြစ်ကြောန့် လာရှာနေဂေ့နူး။ ");
INSERT INTO tvn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ကိုယ်တော်ဟှာ အယ်နေရာမာ မှေ့ဟှ။ ရှင်ပ္လန်ထမြော့‑က်ဟှားဘီ။ ကိုယ်တော်ဟှာ ဂါလိလဲနယ်မာ ရှိနေဒူးဟှ နန်းနို့ဟှို ဖယ်မျိုးမိန့်တော်မူဟှားဟှယ် ဆိုဇာဟှို အော့‑က်မေ့ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","သူးနို့ဟှို ‘လူ့ရဲ့သားဟှာ ပြစ်သားလေ လတ်ထဲဟှို အပ်ရှင်းဟှို ခံရလေ့မယ်။ ကားစင်တန် ခံရလေ့မယ်။ အယ်ဘီးန သောင်းရစ်မြော့‑က်ဟှူ နေ့မာ ထမြော့‑က်လေ့မယ်’ ဆိုဘီး မိန့်တော်မူဟှားဟှယ် မှုဟှလော။” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","အယ်ခီမာ မီးမလေဟှာ ကိုယ်တော်ရဲ့ စကားလေဟှို ပ္လန်အော့‑က်မေ့လာဘီး ");
INSERT INTO tvn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","သန်းခ္လိုင်းဟှနေ ပ္လန်ဟှားဘီး တဗဲ့တော် ဆယ့်တပါးန ကျန်လူလေ ဂူလောင်းဟှို အယ်မူကြောန်းရာလေ ဂူလောင်းဟှို ပြောပြဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","တမန်တော်လေဟှို အယ်မူကြောန်းရာလေဟှို ပြောပြသူလေဟှာ မာဂဒလဝါသူ မာရိ၊ ယောဟန္န၊ ယာကုပ်ရဲ့ မိခင်ဖြစ်ဟှူ မာရိန သူးနို့လေနတူးဒူ ရှိနေဟှူ တခြားမီးမလေ ဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","အယ်ဘေမဲ့ အယ်မီးမလေ ပြောဟှူ စကားလေဟှာ ဓိပါယ်မှေ့ဘဲဟှူကြောန့် တမန်တော်လေဟှ ယောင်ကြည်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","အယ်ဘေမဲ့ ပေတရုဟှာ ထဘီး သန်းခ္လိုင်းဂူဟှို ပ္လေးဟှားလေဟှယ်။ ရော့‑က်ဟှားဟှူ ခီမာ ငေါက်ကေ့လိုက်ဟှူဇာ ပိဖ္လူစဟှိုဘဲ့ တွိရဟှူကြောန့် အယ်ဖြစ်ပျစ်ဟှို အံ့ဩဟှားဘီး အီဟှို ပ္လန်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","အယ်နေ့မာဘဲ့ ယေရှုရဲ့ နော့‑က်တော်လိုက် နှေ့ယော့‑က်ဟှာ ယေရုရှလင်ဗြို့န ခွန်နစ်မိုင်လောက်ဝီးဟှူ ဧမောက် ဆိုဘီး နာမယ်ရှိဟှူ ဝါဟှို သွားနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","သူးနို့ဟှာ ဖြစ်ပျစ်ဟှားဘီးဟှူ ကြောန်းရာလေ ဂူလောင်းဟှို ယော့‑က်နယော့‑က် ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","အယ်မျိုးပြောဆို ဆွေးနွေးနေဒူးမာ ယေရှုကိုယ်တိုင် ရော့‑က်လာဘီး သူးနို့နတူးဒူ ကြွတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","သူးနို့ဟှာ ကိုယ်တော့်ဟှို ဗြင်ဘေမဲ့လည်း ကိုယ်တော့်ဟှို မှတ်မိဘဲ ဖြစ်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ယေရှုဟှ “နန်းနို့လေ လမ်းရှော့‑က်ရင်းန ယော့‑က်နယော့‑က် ဖြားဇာလေ ပြောနေဂေ့နူး။” ဆိုဘီး သူးနို့ဟှို မေးတော်မူလေဟှယ်။ သူးနို့ဟှာ ဝမ်းနဲဟှူမျစ်နှာန ရပ်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","သူးနို့ထဲဟှ ကလောဖ နာမယ်ရှိဟှူသူဟှ “နန်ဟှာ ယေရုရှလင်ဗြို့မာ ဧည့်သည်ဖြစ်န နေထိုင်နေဘေမဲ့ အယ်နေ့ရစ်လေမာ အယ်ဗြို့နှိုက် ဖြစ်ပျစ်ဟှားဟှူ ကြောန်းရာလေဟှို နန့်ယော့‑က်ဒဲဘဲ့ သိသေးဟှလော။” ဆိုဘီး ကိုယ်တော့်ဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ကိုယ်တော်ဟှ “ဖြားကြောန်းရာလေနူး။” ဆိုဘီး မေးတော်မူလေဟှယ်။ အယ်လူနှေ့ယော့‑က်ဟှ “နာဇရက်ဗြို့သားယေရှု ကြောန်းဘဲ့ဖြစ်ဟှယ်။ အယ်သူဟှာ ဘုရားသခင်န လူလေရဲ့ရှေ့မာ လတ်သတ်တိ၊ နှော့‑က်သတ်တိန ပ္လဲ့ဇောင်ဟှူ ပရောဖက် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","နို့လေရဲ့ ယဇ်ပုရောဟိတ်ဂီးလေန ဘာသာရေးခေါန်းဆောန်လေဟှ သူ့ဟှို သေဒန်စီရင်ရှင်း ခံဟှို့ ဆိုဘီး အပ်ပေးဂေ့ဟှယ်။ အယ်ကြောန့် သူ့ဟှို ကားစင်တန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","သူဟှာ ဣသရေလလူမျိုးဟှို လွတ်မြော့‑က်စေဟှို့တွပ် လာမယ် ဆိုဘီး နို့လေ မျှော်လင့်ဟှားဂေ့ဟှယ်! အယ်မူဇာလေ ဖြစ်ပျစ်ဟှားဇာဟှ သောင်းရစ်ရှိဟှားဘီး။ ");
INSERT INTO tvn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","နို့လေရဲ့ အောက်စုထဲဟှ မီးမတချို့ဟှာ နို့လေဟှို အံ့ဩဟှားစေဂေ့ဟှယ်။ သူးနို့လေဟှာ မိုးလန်းစောစောဂီးမာ သန်းခ္လိုင်းဂူဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","အယ်ဘေမဲ့ ကိုယ်တော်ရဲ့ လောန်းဟှို တွိဂေ့ဟှ။ သူးနို့လေဟှ ကိုယ်တော်ဟှာ သတ်ရှင်နေဟှယ် ဆိုဘီး ပြောပြဟှူ ကောန်းဂန်တမန်လေဟှို ရူပါရောင်မာ ဗြင်ရဟှယ် ဆိုဇာဟှို ပ္လန်လာဘီး ပြောဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","နို့လေရဲ့ အောက်စုထဲဟှ လူတချို့ဟှာ သန်းခ္လိုင်းဂူဟှို သွားဟှူ ခီမာလည်း မီးမလေ ပ္လန်ပြောပြမျိုးဘဲ့ တိတိက္လက္လ တွိရဂေ့ဘေမဲ့ ကိုယ်တော့်ဟှို တွိဂေ့ဟှ” ဆိုဘီး ပ္လန်ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","အယ်ဘီးန ယေရှုဟှ “ပရောဖက်လေ ဟောဟှားဇာ ဂူလောင်းဟှို နှလောင်းထဲမာ ယောင်ကြည်ဟှို့ ရရာတိုင်း နှေးကွေးဟှူ လူမိုက်လေ! ");
INSERT INTO tvn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","မေရှိယဟှာ အယ်မျိုးဒေါက်ခခံဘီးန သူ့ရဲ့ဖောင်းသရေထဲဟှို့ ဝမ်စားရမယ် မှုဟှလော။” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","အယ်ဘီးဟှာ ယေရှုဟှ မောရှေရဲ့ ကျမ်းလေန ပရောဖက်လေရဲ့ ကျမ်းဂူလောင်းမာ ကိုယ်တော်န ပတ်သတ်ဘီး ရေးဟှားဇာလေဟှို သူးနို့လေဟှို ရှင်းပြတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","သူးနို့ သွားနေဟှူ ဝါနားဟှို ရော့‑က်ခါနီးမာ ယေရှုဟှာ ရှေ့ဟှို ဆစ်ဘီးသွားဟှူမျိုး လောက်တော်မူဟှူကြောန့်၊ ");
INSERT INTO tvn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","သူးနို့လေဟှ ကိုယ်တော့်ဟှို ပ္လန်ဆွဲဟှားဘီး “နေဒန်ဟှားဟှူကြောန့် ညဉ့်ခန်းဇာရော့‑က်နေဘီ။ အယ်ကြောန့် နို့လေနတူးဒူ တည်းခိုပါ” ဆိုဘီး ပြောဂေ့ဟှယ်။ အယ်ကြောန့် ကိုယ်တော်ဟှာ သူးနို့နတူးဒူ တည်းခိုဟှို့ လိုက်ဟှားတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ကိုယ်တော်ဟှာ သူးနို့နတူးဒူ ထိုင်တော်မူဟှူ ခီမာ မုဟှို ယူဘီး ကျေးဇူးတော်ဟှို ချီးမွမ်းတော်မူဟှယ်။ အယ်ဘီးန မုဟှို ဖဲ့ဘီး သူးနို့လေဟှို ပေးတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","အယ်ခီမာ သူးနို့လေရဲ့ မျစ်စိဟှာ ပွမ့်ဟှားဘီး ကိုယ်တော့်ဟှို ပ္လန်မှတ်မိဟှားဂေ့ဟှယ်။ အယ်ဘေမဲ့ ကိုယ်တော်ဟှာ သူးနို့လေရဲ့ မျစ်စိရှေ့မာဘဲ့ ပျော့‑က်ကွယ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","သူးနို့ဟှာ “လမ်းတရှော့‑က်လောင်းမာ ကိုယ်တော်ဟှာ နို့လေဟှို စကားပြောနေဟှူ ခီမာရော၊ ကျမ်းစာလေဟှို ရှင်းပြနေဟှူ ခီမာရော နို့လေရဲ့ စိနှလောင်းထဲမာ မီးလောန်နေမျိုးဘဲ့ ဖြစ်နေဂေ့ဟှယ် မှုဟှလော။” ဆိုဘီး ယော့‑က်နယော့‑က် မေးနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","သူးနို့ဟှာ ရှစ်ရှင်းထဘီး ယေရုရှလင်ဗြို့ဟှို ပ္လန်ဟှားဂေ့ဟှယ်။ အယ်နေရာမာ တဗဲ့တော် ဆယ့်တပါးဟှာ သူးနို့ရဲ့ ပေါန်းဖော်လေနတူးဒူ စုဝီးနေဇာဟှို တွိရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","အယ်သူလေဟှ “သခင်ဘုရားဟှာ တကယ်ဘဲ့ ထမြော့‑က်ဟှားဘီ! ကိုယ်တော်ဟှာ ရှိမုန်ဟှို ကိုယ်ထန်ရှားပြတော်မူဟှယ်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","အယ်ဘီးန အယ်လူနှေ့ယော့‑က်ဟှ လမ်းမာ ဖြစ်ပျစ်ဟှားဇာလေဟှိုရော၊ မုဟှို ဖဲ့လိုက်ဟှူ ခီမာ သခင်ဘုရား ဖြစ်ဟှယ် ဆိုဘီး သိလိုက်ရဟှယ် ဆိုဇာဟှိုရော ပြောပြဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","သူးနို့နှေ့ယော့‑က်ဟှာ အယ်မျိုးပြောနေဒူးမာ သခင်ဘုရားကိုယ်တိုင် သူးနို့လေထဲမာ ရောက်တရစ် ပေါ်လာဘီး “နန်းနို့နတူးဒူ ငြီသတ်ရှင်း ရှိပါစေ” ဆိုဘီး သူးနို့လေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","သူးနို့လေဟှာ ကသေဟှို ဗြင်ဟှယ် ဆိုဘီး ထန်ဘီးဟှာ ကြော့‑က်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","အယ်ဘေမဲ့ ကိုယ်တော်ဟှ “ဖြားဖြစ်ကြောန့် ကြော့‑က်နေဂေ့ဟှယ်နူး။ ဖြားဖြစ်ကြောန့် နန်းနို့စိထဲမာ သံသယဖြစ်နေဂေ့ဟှယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ငါ့လတ်လေ၊ ငါ့ခေလေဟှို ကေ့ဂေ့ပါ။ ငါကိုယ်တိုင် ဖြစ်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကသေမာ သားလေ၊ ရိုးလေ မှေ့ဟှ။ နန်းနို့ ဗြင်ဟှူတိုင်းဘဲ့ ငါ့မာ သားလေ၊ ရိုးလေရှိဟှယ် ဆိုဇာဟှို ငါ့ဟှို စမ်းကေ့လိုက် နန်းနို့သိလေ့မယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ကိုယ်တော်ဟှာ အယ်မျိုးပြောဘီး သူ့ရဲ့လတ်လေန ခေလေဟှို သူးနို့ဟှို ပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","သူးနို့ဟှာ ရရာတိုင်း အံ့ဩဟှားဘီး ဝန်းသာနေဟှူကြောန့် ယောင်ကြည်နိုင်ဘဲ ဖြစ်နေဟှူ ခီမာ ကိုယ်တော်ဟှ “နန်းနို့မာ စားဟှို့ တခုခုရှိလော။” ဆိုဘီး သူးနို့ဟှို မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","သူးနို့ဟှာ ကိုယ်တော့်ဟှို ငါးဂန်တပိုင်း ပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","အယ်ငါးဂန်ဟှို ကိုယ်တော်ဟှာ သူးနို့ရှေ့မာဘဲ့ ယူဘီးဟှာ စားတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","အယ်ဘီးန ကိုယ်တော်ဟှ “နန်းနို့နတူးဒူ ရှိနေဒူးဟှ ငါပြောဟှားမျိုးဘဲ့ မောရှေရဲ့ ပညတ်တရားကျမ်း၊ ပရောဖက်ကျမ်းလေန ဆာလံကျမ်းမာ ငါ့ကြောန်းဟှို ရေးဟှားဇာလေဟှာ ပ္လဲ့ဇောင်ဟှားဘီ” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","အယ်ဘီးန ကိုယ်တော်ဟှာ ကျမ်းစာလေဟှို နားလည်ဟှို့တွပ် သူးနို့ရဲ့ သိဉာဏ်ဟှို ဖွမ့်ပေးဘီးဟှာ ");
INSERT INTO tvn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","“ကျမ်းစာလေမာ ရေးဟှားဇာဟှ မေရှိယဟှာ ဝေဒနာခံတော်မူဘီး သောင်းရစ်မြော့‑က်ဟှူနေ့မာ သေရာဟှနေ ထမြော့‑က်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","အယ်ဘီးဟှာ သူ့နာမအားဖြင့် ပြစ်လွှတ်ရှင်းနဆိုင်ဟှူ နောန်ဒတရားဟှို ယေရုရှလင်ဗြို့ဟှစဘီး လူမျိုးဂူလောင်းဟှို ဟောပြောရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","နန်းနို့ဟှာ အယ်ကြောန်းရာလေရဲ့ မျစ်ဗြင်သတ်သေလေ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","အယ်ဘီးဟှာ ငါဟှာ ငါ့ဖရဲ့ ဂဒိဟှို နန်းနို့နားဟှို ငါကိုယ်တိုင် စေလွှတ်မယ်။ အယ်ဘေမဲ့ ထတ်ကောန်းဂန်ဟှနေ တဂိုးဟှာ နန်းနို့ထတ်ဟှို ဆင်းလာခန်ထိ ယေရုရှလင်ဗြို့မာဘဲ့ စောန့်နေရမယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","အယ်ဘီးန ကိုယ်တော်ဟှာ သူးနို့ဟှို ဗေသနိဝါဟှို ခေါ်ဆောန်ဟှားဘီး ကိုယ်တော်ဟှာ လတ်တော်ဟှို မြှော့‑က်ဘီး သူးနို့ဟှို ကောန်းဂျီးပေးတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","အယ်မျိုး သူးနို့ဟှို ကောန်းဂျီးပေးနေဒူးမာ ကိုယ်တော်ဟှာ သူးနို့နားဟှနေ ထွပ်ခွာဟှားဘီး ကောန်းဂန်ဘောင်ဟှို ယူဆောန်ခံရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","သူးနို့ဟှာ ကိုယ်တော့်ဟှို ကိုးကွယ်ဘီးန ရရာတိုင်း ဝန်းသာဘီးဟှာ ယေရုရှလင်ဗြို့ဟှို ပ္လန်ဟှားဂေ့ဘီးဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ဗိမာန်တော်မာ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟှို မြဲဒမ်း ချီးမွမ်းနေဂေ့ဟှယ်။");
INSERT INTO tvn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","စစဒူးဟှ စကားတော်ဟှာ ရှိဘီးသားဖြစ်ဟှယ်။ အယ်စကားတော်ဟှာ ဘုရားသခင်နတူးဒူ ရှိနေဟှယ်။ အယ်စကားတော်ဟှာလည်း ဘုရားသခင်ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","အယ်စကားတော်ဟှာ စစဒူးဟှ ဘုရားသခင်နတူးဒူ ရှိနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ဘုရားသခင်ဟှာ စကားတော်နဘဲ့ ရှိမျှဂူလောင်းဟှို ဖန်ဆင်းဟှားဟှယ်။ ဖန်ဆင်းဘဲ့န ဖြစ်နေဇာလေ တခုလည်း မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","စကားတော်ဟှာ သတ်ရဲ့ ရင်းမြစ်ဖြစ်ဟှယ်။ အယ်ဘီးဟှာ အယ်သတ်ဟှာ လူလေနားဟှို လန်းရောန်ဟှို သယ်ဆောန်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","အယ်လန်းရောန်ဟှာ မှောန်ထဲမာ လန်းထီနေဟှယ်။ အယ်ဘီးဟှာ အယ်မှောန်ဟှာ အယ်လန်းရောန်ဟှို ဖောင်းနိုင်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ဘုရားသခင်ဟှာ ယောဟန် နာမယ်ရှိဟှူ လူတယော့‑က်ဟှို မိမိရဲ့ စေတမန်ဖြစ်န စေလွှတ်လိုက်ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","လူလေဂူလောင်းဟှာ တရားစကားဟှို ကြားဘီးန ယောင်ကြည်ဟှို့တွပ် အယ်လူဟှာ လန်းရောန်ကြောန်းဟှို သတ်သေခံဟှို့ လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","သူကိုယ်တိုင်ဟှာ လန်းရောန် မှုဟှ။ လန်းရောန်ကြောန်းဟှို သတ်သေခံဟှို့တွပ် လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","အယ်စစ်မှန်ဟှူ လန်းရောန်ဟှာ လောကဟှို ကြွလာဘီးန လူလေ ဂူလောင်းထတ်မာ လန်းထီဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","စကားတော်ဟှာ လောကထဲမာ ရှိဟှယ်။ ဘုရားသခင်ဟှာ ကိုယ်တော်အားဖြင့် လောကဟှို ဖန်ဆင်းဟှားဟှယ်။ အယ်ဘေမဲ့ အယ်လောကဟှ ကိုယ်တော့်ဟှို သိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ကိုယ်တော်ဟှာ သူ့ဒေသဟှို ပ္လန်လာဟှယ်။ အယ်ဘေမဲ့ ကိုယ်တော်ရဲ့ လူမျိုးလေဟှ ကိုယ်တော့်ဟှို လတ်ခံဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","အယ်ဘေမဲ့ တချို့ဟှ ကိုယ်တော့်ဟှို လတ်ခံဘီး ကိုယ်တော်ရဲ့ နာမဟှို ယောင်ကြည်ဟှယ်။ အယ်ကြောန့် ကိုယ်တော်ဟှ သူးနို့ဟှို ဘုရားသခင်ရဲ့ သားမီးလေဖြစ်ခွမ့်ပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","သူးနို့ဟှာ သွီးသားရှင်းပေါန်းဘီး ပေါ့‑က်လာဟှူ သားမီးလေ မှုဟှ။ လူသားဖဟှနေ ပေါ့‑က်လာဟှူ သားမီးလေ မှုဟှ။ ဘုရားသခင်ဟှနေ ပေါ့‑က်လာဟှူ သားမီးလေဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","စကားတော်ဟှာ လူသားဖြစ်လာဘီး ကျေးဇူးတော်န သမ္မာတရားန ပ္လဲ့ဇောင်ဘီးဟှာ နို့လေထဲမာ စံမြန်းနေဟှယ်။ နို့လေဟှာ ကိုယ်တော်ရဲ့ ဖောင်းသရေတော်ဟှို ဗြင်ရဘီ။ အယ်ဖောင်းသရေတော်ဟှာ ဖရဲ့ တယော့‑က်ဒဲရှိဟှူ သားဖြစ် လတ်ခံရရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ယောဟန်ဟှာ ကိုယ်တော်ရဲ့ ကြောန်းဟှို “ ‘ငါ့နော့‑က်ဟှနေ ကြွလာဟှူသူဟှာ ငါမွီးခန်ဂဒဲဟှ ရှိနေကြောန့် ငါ့ထတ်ကီးမြတ်ဟှယ်’ ဆိုဇာဟှို ငါပြောဟှားဟှူသူဟှာ အယ်လူဘဲ့ ဖြစ်ဟှယ်” ဆိုဘီး အော်ပြောဘီး သတ်သေခံလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ကိုယ်တော်ရဲ့ ကျေးဇူးတော် ပ္လဲ့ဇောင်မှုဟှနေ နို့လေဂူလောင်းဟှာ ကောန်းဂျီးလေ ခုဘီးခု လတ်ခံရရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ဘုရားသခင်ဟှာ မောရှေအားဖြင့် ပညတ်တရားဟှို ပေးဟှယ်။ ကျေးဇူးတရားန သမ္မာတရားဟှို ယေရှုခရစ်တော်အားဖြင့် ဖြစ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ဘုရားသခင်ဟှို ဖယ်လူလည်းဗြင်ဖူးဟှ။ ဖရဲ့ ရင်ခွမ်မာရှိဟှူ၊ ဘုရားသခင်ဖြစ်ဟှူ၊ တယော့‑က်ဒဲဟှူသားဟှာ ဘုရားသခင်ဟှို ထန်ရှားစေဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ခု ယေရုရှလင်ဗြို့ဟှ ယုဒလူ အာဏာပိုင်လေဟှာ ယဇ်ပုရောဟိတ်လေန လေဝိတချို့ဟှို ယောဟန်နားဟှို စေလွှတ်ဘီး “နန်ဟှာ ဖယ်သူနူး” ဆိုဘီး မေးမြန်းလေဟှယ်။ ယောဟန်ရဲ့ သတ်သေခံချစ်ဟှာ အယ်မျိုးဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ယောဟန်ဟှ လှည့်ဝှက်ဇာမှေ့ဘဲန ဝန်ခံဘီး “ငါဟှာ မေရှိယ မှုဟှ” ဆိုဘီး ပွမ့်ပွမ့်လန်းလန်းဟှားန ရှင်းရှင်းလန်းလန်းဟှားဘဲ့ ပ္လန်ဖြေလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“အယ်ဆိုဟှာ နန်ဟှ ဖယ်သူနူး။ နန်ဟှာ ဧလိယလော” ဆိုဘီး သူးနို့ဟှ မေးလိုက်ဟှယ်။ “ငါဟှာ ဧလိယ မှုဟှ” ဆိုဘီး ယောဟန်ဟှ ပ္လန်ဖြေဟှယ်။ “နန်ဟှာ ပရောဖက်လော” ဆိုဘီး သူးနို့ဟှ ပ္လန်မေးဟှယ်။ “ငါဟှာ ပရောဖက်လည်း မှုဟှ” ဆိုဘီး ပ္လန်ဖြေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“အယ်ဆိုဟှာ နန်ဟှာ ဖယ်သူနူး။ နို့လေဟှို စေလွှတ်လိုက်ဟှူ လူလေဟှို ပ္လန်ဘီးပြောပြရမယ်။ နန့်ကြောန်းဟှို ဖြားမျိုးပြောမယ်နူး” ဆိုဘီး သူးနို့ဟှ မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ယောဟန်ဟှာ ပရောဖက်ဟေရှာယဟှို ကိုးကားဘီး “ငါဟှာ ‘ဘုရားသခင်ရဲ့ လမ်းဟှို ပြင်ဆင်ဟှားဂေ့! ဆိုဘီး တောကန္တာရထဲမာ အော်ဟစ်နေဟှူ သံဖြစ်ဟှယ်’ ” ဆိုဘီး ပ္လန်ဖြေလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ဖာရိရှဲလေ စေလွှတ်လိုက်ဟှူ စေတမန်လေဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ဖာရိရှဲလေ စေလွတ်လိုက်ဟှူ စေတမန်လေဟှ “နန်ဟှာ မေရှိယလည်း မှုဟှ။ ဧလိယလည်း မှုဟှ။ ပရောဖက်လည်း မှုဟှ ဆိုဟှာ ဖြားဖြစ်ကြောန့် ဗတ္တိဇံပေးနေနူး” ဆိုဘီး ယောဟန်ဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ယောဟန်ဟှာ “ငါဟှာ ရေန ဗတ္တိဇံပေးဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ထဲမာ နန်းနို့သိဘဲဟှူ လူတယော့‑က်ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","သူဟှာ ငါ့နော့‑က်ဟှ ကြွလာနေဘီ။ အယ်ဘေမဲ့ ငါဟှာ သူ့ရဲ့ ခေနပ်ကြိုးဟှို ဖြေဟှို့ဟှိုမှ ထိုက်ဟှ” ဆိုဘီး ပ္လန်ဖြေလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","အယ်မူဇာ ဂူလောင်းဟှာ ယောဟန် ဗတ္တိဇံပေးဟှူ ယော်ဒန်မ္လစ်ရဲ့ ရှေ့ဖတ်ကမ်းဟှ ဗေသနိဝါမာ ဖြစ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","နတ်ကီးဖတ်မာ ယောဟန်ဟှာ သူ့နားဟှို ယေရှုလာနေဇာဟှို ဗြင်လိုက်ဟှူ ခီမာ “လောကသားလေရဲ့ ပြစ်ဟှို ယူဆောန်ဟှားဟှူ ဘုရားသခင်ရဲ့ သိုးသားဂန်းဟှားဟှို ကေ့ကေ့! ");
INSERT INTO tvn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‘နော့‑က်ဟှနေ ကြွလာဟှူသူဟှာ ငါမွီးခန်ဂဒဲဟှ ရှိနေကြောန့် ငါ့ထတ်ကီးမြတ်ဟှယ်’ ဆိုဘီး ငါပြောနေဇာဟှာ အယ်လူကြောန်းဘဲ့ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ငါကိုယ်တိုင်လည်း အယ်လူဟှို သိဟှ။ အယ်ဘေမဲ့ ဣသရေလလူမျိုးလေဟှို သိစေဟှို့တွပ် ရေန ဗတ္တိဇံပေးဟှို့ ငါလာဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","အယ်န ယောဟန် သတ်သေခံဇာဟှ “ဝိညာဉ်တော်ဟှာ ကောန်းဂန်ဘောင်ဟှနေ ချိုးငှတ်မျိုး ဆင်းလာဘီး အယ်လူထတ်မာ နားနေဇာဟှို ငါဗြင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","အယ်လူဟှာ ဖယ်လူဖြစ်ဟှယ် ဆိုဇာဟှို ငါသိဟှ။ အယ်ဘေမဲ့ ငါ့ဟှို ရေန ဗတ္တိဇံပေးဟှို့ စေလွှတ်ဟှူ ဘုရားသခင်ဟှ ‘သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှာ ဆင်းလာဘီး ယော့‑က်ယော့‑က်ထတ်မာ နားနေဇာဟှို ဗြင်ရလေ့မယ်။ အယ်လူဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န ဗတ္တိဇံပေးမယ့်လူ ဖြစ်ဟှယ်’ ဆိုဘီး ငါ့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","အယ်ဇာဟှို ငါဗြင်ရဘီ။ အယ်ကြောန့် နန်းနို့ဟှို ငါပြောမယ် အယ်လူဟှာ ဘုရားသခင်ရဲ့သား ဖြစ်ဟှယ်” ဆိုဘီး ယောဟန် သတ်သေခံလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","နတ်ကီးတိုင်မာ ယောဟန်ဟှာ တဗဲ့တော်နှေ့ပါးနတူးဒူ အယ်နေရာမာ ပ္လန်ဘီးရပ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ယောဟန်ဟှာ ယေရှု ကြွလာနေဇာဟှို ဗြင်လိုက်ဟှယ်။ “ကေ့ကေ့! ဟောက်မာ ဘုရားသခင်ရဲ့ သိုးသားဂန်းဟှား ဖြစ်ဟှယ်!” ဆိုဘီး သူဟှ ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","တဗဲ့တော်နှေ့ပါးဟှာ အယ်မျိုးပြောဇာဟှို ကြားလိုက်ဘီးန ယေရှုနတူးဒူ လိုက်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ယေရှုဟှ လှည့်ကေ့လိုက်ဘီး သူးနို့လေ လိုက်လာဇာဟှို ဗြင်လေဟှယ်။ အယ်န “ဖြားဇာရှာနေနူး” ဆိုဘီး သူးနို့ဟှို မေးလေဟှယ်။ သူးနို့ဟှ “ရဗ္ဗိ၊ ကိုယ်တော်ဟှ ဖယ်မာနေဟှယ်နူး” ဆိုဘီး မေးလေဟှယ်။ (ရဗ္ဗိရဲ့ ဓိပါယ်ဟှာ “ဆရာ” ဖြစ်ဟှယ်။) ");
INSERT INTO tvn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“လိုက်ဘီးကေ့ဂေ့” ဆိုဘီး ကိုယ်တော်ဟှ ဖြေဟှယ်။ (အယ်ခီဟှာ နေဒန်ဇာလေးနာရီလော့‑က်ရှိဘီ။) အယ်ကြောန့် သူးနို့လေဟှာ ကိုယ်တော်နတူးဒူ လိုက်ဟှားဘီး ကိုယ်တော်နေဟှူ နေရာဟှို တွိဟှားလေဟှယ်။ အယ်ဘီးန အယ်နေ့ဟှို ကိုယ်တော်နတူးဒူ နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ယောဟန်ရဲ့ စကားဟှို ကြားဘီး ယေရှုနော့‑က်လိုက် ဖြစ်လာဟှူ နှေ့ယော့‑က်ထဲဟှ တယော့‑က်ဟှာ ရှိမုန်ပေတရုရဲ့ညီ အန္ဒြေဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ရှစ်ရှင်းဘဲ့ အန္ဒြေဟှာ သူ့နောန်ရှိမုန်ဟှို တွိဟှားခီမာ “နို့လေ မေရှိယဟှို တွိဟှားဘီ” ဆိုဘီး ပြောပြဟှယ်။ မေရှိယရဲ့ ဓိပါယ်ဟှာ “ခရစ်တော်” ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","အယ်ဘီးန သူဟှ ရှိမုန်ဟှို ယေရှုနားဟှို ခေါ်ဆောန်ဟှားဟှယ်။ ယေရှုဟှာ အယ်လူဟှို ကေ့ဘီးန “နန်ဟှာ ယောဟန်ရဲ့သား ရှိမုန်ဖြစ်ဟှယ်။ အယ်ဘေမဲ့ နန့်ဟှို ကေဖ ဆိုဘီး ခေါ်ရမယ်” ဆိုဘီး ပြောလိုက်ဟှယ်။ ကေဖဟှာ ပေတရုနာမယ်န ထပ်တူဖြစ်ဘီး က္လော့‑က် ဆိုဘီး ဓိပါယ်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","နတ်ကီးတိုင်မာ ယေရှုဟှာ ဂါလိလဲနယ်ဟှို သွားဟှို့ ဆောင်းဖြတ်ဟှယ်။ ကိုယ်တော်ဟှာ ဖိလိပ္ပုဟှို တွိဟှူ ခီမာ “ငါ့နတူးဒူလိုက်ပါ!” ဆိုဘီး သူ့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ဖိလိပ္ပုဟှာ အန္ဒြေန ပေတရု နေထိုင်ဟှူ ဗက်ဇဲဒဗြို့ဟှဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ဖိလိပ္ပုဟှာ နာသနေလဟှို တွိဟှူ ခီမာ “နို့လေဟှာ မောရှေရဲ့ ပညတ်ကျမ်းန ပရောဖက်လေရဲ့ ကျမ်းမာ ရေးဟှားဟှူလူဟှို တွိဟှားဘီ။ အယ်လူဟှာ နာဇရက်ဗြို့ဟှ ယောသပ်ရဲ့သား ယေရှုဖြစ်ဟှယ်” ဆိုဘီး ပြောပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“နာဇရက်ဗြို့ဟှနေ ကောန်းဟှူဇာ ထွပ်နိုင်ဘဲ့လော” ဆိုဘီး နာသနေလဟှ မေးဟှယ်။ “လာဘီးကေ့ကေ့” ဆိုဘီး ဖိလိပ္ပုဟှ ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ယေရှုဟှာ သူ့နားဟှို လာနေဟှူ နာသနေလဟှို ဗြင်ဟှူ ခီမာ ကိုယ်တော်ဟှ “ကေ့ကေ့! လှည့်ဇားမှု လောင်းဝ မှေ့ဘဲဟှူ၊ စစ်မှန်ဟှူ ဣသရေလလူ ဖြစ်ဟှယ်!” ဆိုဘီး သူ့ဟှို ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","နာသနေလဟှ “ကိုယ်တော်ဟှ ကျွန်တော်ဟှို ဖယ်မျိုးလောက်ဘီး သိနေရနူး” ဆိုဘီး ကိုယ်တော့်ဟှို မေးဟှယ်။ ယေရှုဟှ “ဖိလိပ္ပုဟှ နန့်ဟှို ခေါ်လာခန်မာ နန်ဟှာ သဖန်းဗန်အော့‑က်မာ ရှိနေဂဒဲဟှ နန့်ဟှို ငါဗြင်ဟှယ်” ဆိုဘီး ပ္လန်ဖြေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“ဆရာ၊ ကိုယ်တော်ဟှာ ဘုရားသခင်ရဲ့ သားဖြစ်ဟှယ်! ဣသရေလလူမျိုးရဲ့ မန်းဂီးလည်းဖြစ်ဟှယ်!” ဆိုဘီး နာသနေလဟှ ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ယေရှုဟှ “သဖန်းဗန်အော့‑က်မာ နန့်ဟှို ငါဗြင်ဟှယ် ဆိုဘီး ပြောလိုက်ဇာဟှို နန်ယောင်ကြည်ဘဲ့လော။ အယ်ထတ် ရရာတိုင်းကီးဟှူ ဇာလေဟှို နန်ဗြင်ရလေ့မယ်” ဆိုဘီး ပြောလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ကိုယ်တော်ဟှ “နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ကောန်းဂန်ပွမ့်ဘီးဟှာ လူ့ရဲ့သား ထတ်မာ ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်လေဟှာ ဆင်းလိုက်တတ်လိုက် လောက်နေဇာဟှို နန်းနို့ ဗြင်ရလေ့မယ်” ဆိုဘီး သူးနို့လေဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","သောင်းရစ်မြော့‑က်နေ့မာ ဂါလိလဲနယ် ကာနဗြို့မာ အီတတ်ဗွဲလောက်လေဟှယ်။ အယ်ပွဲမာ ယေရှုရဲ့ မိလည်း ရှိနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","အယ်ဘီးဟှာ ယေရှုန တဗဲ့တော်လေဟှိုလည်း အီတတ်ဗွဲဟှို ဖိဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ဝိုင်ကူဟှားခီမာ ယေရှုရဲ့မိဟှ “သူးနို့မာ ဝိုင်ကူဟှားဘီ” ဆိုဘီး ကိုယ်တော့်ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ယေရှုဟှ “ဝှေ့မီးမ၊ နို့ဟှို ဖြားလောက်ရမယ် ဆိုဘီး ပြောန။ နို့ခီဟှာ ခုထိ ရော့‑က်သေးဟှ” ဆိုဘီး ပ္လန်ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","အယ်ဘီးန ယေရှုရဲ့ မိဟှ “နန်းနို့ဟှို သူစေခိုင်းဟှူတိုင်း လောက်ဂေ့” ဆိုဘီး စေခံလေဟှို ပြောလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ယုဒလူလေမာ ဘာသာဓလေ့တိုင်း ဆေးကြောဇာနဆိုင်ဟှူ စည်းမျဉ်းလေရှိဟှယ်။ အယ်စည်းမျဉ်းလေကြောန့် အယ်နေရာမာ က္လော့‑က်ရေအိုး ခြော့‑က်လောင်းရှိဘီး ရေအိုးဂီးတလောင်းစီဟှာ ဂါလံနှေ့ဆယ်န သောင်းဆယ်ကြား ဝမ်ဆံ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ယေရှုဟှ “အယ်ရေအိုးလေဟှို ရေဖ္လဲ့ဂေ့” ဆိုဘီး စေခံလေဟှို ပြောလိုက်ဟှယ်။ သူးနို့ဟှာ ပ္လဲ့အောန် ဖ္လဲ့ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","အယ်ဘီးန ကိုယ်တော်ဟှ “ခု အယ်အိုးထဲဟှရေဟှို ခပ်ဘီးဟှာ ပွဲအောက်နားဟှို ယူဟှားဂေ့” ဆိုဘီး သူးနို့ဟှို ပြောလိုက်ဟှယ်။ သူးနို့ဟှာ ရေဟှို ယူဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ခု အယ်ရေဟှာ ဝိုင်ဖြစ် ပ္လောန်းလဲဟှားဘီး ပွဲအောက်ဟှ ဗြည်းလေဟှယ်။ အယ်ဝိုင်ဟှာ ဖယ်နေရာဟှ ရလာဟှယ် ဆိုဇာဟှို သူသိဟှ။ အယ်ဘေမဲ့ ရေခပ်လာဟှူ စေခံလေဟှာ ကောန်းကောန်းဟှားသိနေဟှယ်။ အယ်ကြောန့် သူဟှာ ဒို့သားဟှို ခေါ်လိုက်ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“လူတိုင်းဟှာ ကောန်းဆောင်း ဝိုင်နဘဲ့ ဦးဆောင်းဧည့်ခံဟှယ်။ ဧည့်သည်လေ ဘောင်ဂီးသော့‑က်ဘီးမှ ညံ့ဟှူဝိုင်န ဧည့်ခံဟှယ်။ အယ်ဘေမဲ့ နန်ဟှ ကောန်းဆောင်း ဝိုင်ဟှို ခုထိသီးဟှားလေဟှယ်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ယေရှုဟှာ ဦးဆောင်း နိမိတ်လတ်ခဏာဟှို ဂါလိလဲနယ် ကာနဗြို့မာ လောက်ဘီးဟှာ မိမိရဲ့ ဖောင်းသရေတော်ဟှို ဖွမ့်ပြလေဟှယ်။ အယ်ဘီးန တဗဲ့တော်လေဟှာ ကိုယ်တော့်ဟှို ယောင်ကြည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","အယ်မျိုး နိမိတ်လတ်ခဏာ ပြဘီးန ယေရှုဟှာ သူ့ရဲ့မိ၊ ညီငယ်လေ၊ တဗဲ့တော်လေနတူးဒူ ကပေရနောင်ဗြို့ဟှို သွားဘီး အယ်ဗြို့မာ ရစ်နဲနဲဟှား နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ယုဒလူလေရဲ့ ပသခါပွဲ နီးလာဟှူကြောန့် ယေရှုဟှာ ယေရုရှလင်ဗြို့ဟှို သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ကိုယ်တော်ဟှာ ဗိမာန်တော်ထဲမာ သိုးလေ၊ နွားသားဂန်းလေ၊ ချိုးငှတ်လေဟှို ရောန်းဝယ်နေဟှူ လူလေန ကပ်လဲပေးမားလေဟှာ သူးနို့ရဲ့ စားဗွဲလေမာ ထိုင်နေဇာဟှို တွိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","အယ်ကြောန့် ကိုယ်တော်ဟှာ ကြိုးလေန ကြာပွတ်ဟှို လောက်ဘီးန သိုးလေ၊ နွားလေ ဂူလောင်းဟှို ဗိမာန်တော်ထဲဟှ နန်ထုဘီးဟှား ကပ်လဲမားလေရဲ့ ဗွဲလေဟှိုလည်း မှော့‑က်လှဲဘီးန သူးနို့ရဲ့ ဒန်းဂါးလေဟှို ဖ္လဲဖ္လဲစင်အောန် လောက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","အယ်ဘီးန ကိုယ်တော်ဟှာ ချိုးငှတ်ရောန်းဟှူ လူလေဟှို “အယ်ပစ္စည်းလေဟှို ယူဟှားဂေ့! ငါ့ဖရဲ့ အီတော်ဟှို ဆေးဖြစ်ဟှားအောန် လောက်ဂေ့န!” ဆိုဘီး မိန့်ပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ကိုယ်တော်ရဲ့ တဗဲ့တော်လေဟှာ “အိုဘုရားသခင်၊ ကိုယ်တော်ရဲ့ အီတော်ဟှို ရှစ်ခင်တွယ်တာမှုဟှာ ကျွန်တော်ထဲမာ မီးမျိုး လောန်ကျွမ်းနေဟှယ်” ဆိုဘီး ကျမ်းစာဟှ ပြောဟှားဇာလေဟှို အော့‑က်မေ့လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ယုဒအာဏာပိုင်လေဟှာ ကိုယ်တော်နားဟှို ပ္လန်လာဘီး “နန်ဟှာ အယ်မူဇာဟှို လောက်ပိုင်ခွမ့် ရှိဟှယ် ဆိုဇာဟှို နို့လေဟှို ဖြားမျိုး နိမိတ်လတ်ခဏာ လောက်ပြနိုင်မယ်နူး” ဆိုဘီး မေးခွန်းတခုဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ယေရှုဟှ “အယ်ဗိမာန်တော်ဟှို ဖြိုဖျစ်ဂေ့။ သောင်းရစ်ထဲန ငါပ္လန်ဆော့‑က်ပြမယ်” ဆိုဘီး ဖြေလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ယုဒလူလေဟှ “အယ်ဗိမာန်တော်ဟှို ဆော့‑က်ဟှို့တွပ် လေးဆယ့်ခြော့‑က်နှစ် ကြာဟှယ်! နန်ဟှ သောင်းရစ်ထဲန ပ္လန်ဆော့‑က်ဟှို့လော” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","အယ်ဘေမဲ့ ယေရှုပြောနေဟှူ ဗိမာန်တော်ဟှာ သူ့ရဲ့ ကိုယ်ခန္ဓာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","အယ်ကြောန့် ယေရှုဟှာ သေရာဟှနေ ပ္လန်ရှင်လာဟှူ ခီမာ ကိုယ်တော်ရဲ့ တဗဲ့တော်လေဟှာ ကိုယ်တော်ပြောဟှားဟှူ စကားလေဟှို အော့‑က်မေ့လာလေဟှယ်။ အယ်ဘီးန သူးနို့လေဟှာ ကျမ်းစာတော်န ကိုယ်တော်ပြောဟှားဟှူ စကားလေဟှို ယောင်ကြည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ယေရှုဟှာ ယေရုရှလင်ဗြို့ဟှ ပသခါပွဲမာရှိနေဒူးမာ ကိုယ်တော်လောက်ဟှူ နိမိတ်လတ်ခဏာလေဟှို တွိရဟှူကြောန့် လူလေဘောင်ဂီးဟှာ ကိုယ်တော့်နာမဟှို ယောင်ကြည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","အယ်ဘေမဲ့ ယေရှုဟှာ လူလေ ဂူလောင်းရဲ့ ကြောန်းဟှို သိနေဟှူကြောန့် သူးနို့လေဟှို ယောင်ကြည်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ကိုယ်တော်ဟှာ လူလေရဲ့ စိနှလောင်းဟှို သိနေဟှယ်။ အယ်ကြောန့် ကိုယ်တော့်ဟှို ယော့‑က်ယော့‑က်ဟှ သူးနို့ကြောန်းဟှို သတ်သေခံဟှို့ လိုအပ်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ဖာရိရှဲဖွဲ့ဝမ် နိကောဒင်နာမယ်ရှိဟှူ ယုဒလူခေါန်းဆောန် တယော့‑က်ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","တညဉ့်မာ သူဟှာ ယေရှုနားဟှို လာဘီးဟှာ ကိုယ်တော့်ဟှို “ရဗ္ဗိ၊ ကိုယ်တော်ဟှာ ဘုရားသခင်စေလွှတ်လိုက်ဟှူ ဆရာတယော့‑က် ဖြစ်ဟှယ် ဆိုဇာဟှို ကျွန်တော့်ဟှားလေ သိဟှယ်။ ဘုရားသခင်ဟှာ ဆရာနတူးဒူရှိဟှ ဆိုဟှာ ဖယ်လူလည်း အယ်နိမိတ်လတ်ခဏာလေဟှို လောက်နိုင်ဟှို့ မှုဟှ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ယေရှုဟှ “နန့်ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ဒုတိယခါ ပ္လန်မွီးဟှ ဆိုဟှာ ဖယ်လူလည်း ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို ဗြင်နိုင်ဟှို့ မှုဟှ” ဆိုဘီး ဖြေလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“သတ်ကီးဟှူလူဟှ ဖယ်မျိုးဒုတိယခါ ပ္လန်မွီးနိုင်ဟှို့နူး။ အယ်လူဟှာ ဒုတိယခါ မွီးဟှို့တွပ် သူ့မိရဲ့ ဗိုက်ထဲဟှို လောင်းဝ ဝမ်နိုင်ဟှ!” ဆိုဘီး နိကောဒင်ဟှ မေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ယေရှုဟှ “နန့်ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ရေန ဝိညာဉ်တော်အားဖြင့် မွီးဟှ ဆိုဟှာ ဖယ်လူလည်း ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို ဝမ်နိုင်ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ဇာတိသွီးသားဟှာ ဇာတိသွီးသားဟှို မွီးပေးဟှယ်။ အယ်ဘေမဲ့ ဝိညာဉ်တော်ဟှာ ဝိညာဉ်ဟှို မွီးပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ဒုတိယခါ ပ္လန်မွီးရမယ် ဆိုဘီး ငါပြောဟှူကြောန့် အံ့ဩဟှားန။ ");
INSERT INTO tvn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","လေဟှာ သူလိုရှိဟှူ နေရာဟှို တိုက်လေဟှယ်။ နန်ဟှာ လေတိုက်သံဟှို ကြားရဟှယ်။ အယ်ဘေမဲ့ အယ်လေဟှာ ဖယ်နေရာဟှ လာဘီး ဖယ်နေရာဟှို သွားနေဟှယ် ဆိုဇာဟှို နန်သိဟှို့ မှုဟှ။ ဝိညာဉ်တော်အားဖြင့် မွီးဟှူလူတိုင်းဟှာလည်း အယ်မျိုးဘဲ့ဖြစ်ဟှယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“အယ်ဇာဟှာ ဖယ်မျိုးဖြစ်နိုင်ဟှို့နူး” ဆိုဘီး နိကောဒင်ဟှ မေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ယေရှုဟှ “နန်ဟှာ ဣသရေလလူမျိုးထဲမာ ဆရာဂီးတယော့‑က်ဖြစ်ဘီး အယ်မူဇာဟှို နန်သိဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","နန့်ဟှို ငါ မှန်တိုင်းပြောမယ်၊ နို့လေဟှာ သိဟှူဇာဟှို ပြောဘီး နို့လေဟှာ ဗြင်ဟှူဇာဟှို သတ်သေခံဟှယ်။ အယ်ဘေမဲ့လည်း နန်းနို့ဟှာ နို့လေရဲ့ သတ်သေခံဇာဟှို လတ်ခံရှင်ဟှူ စိမှေ့ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","အယ်လောကနဆိုင်ဟှူ ဇာလေဟှို ငါပြောဟှူ ခီမာ နန်းနို့လေ ယောင်ကြည်ဂေ့ဟှ။ အယ်ဆိုဟှာ ကောန်းဂန်ဘောင်နဆိုင်ဟှူ ဇာလေဟှို ငါပြောဟှူ ခီမာ နန်းနို့လေ ဖယ်မျိုး ယောင်ကြည်မယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ကောန်းဂန်ဘောင်ဟှနေ ဆင်းလာဟှူ လူ့ရဲ့သားမှတပါး ဖယ်လူလည်း ကောန်းဂန်ဘောင်ဟှို တတ်ဟှားဟှူ လူမှေ့ဟှ” ဆိုဘီး ဖြေလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","မောရှေဟှာ ကန္တာရထဲမာ ကြေးဝါဗွီဟှို တိုင်ထတ်မာ ခိဟှားမျိုးဘဲ့ လူ့ရဲ့သားဟှိုလည်း ခိဟှားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","အယ်ကြောန့် ကိုယ်တော့်ဟှို ယောင်ကြည်ဟှူ လူတိုင်းဟှာ ထာဝရသတ်ဟှို ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ဘုရားသခင်ဟှာ လောကသားလေဟှို ရရာတိုင်း ရှစ်ဟှူကြောန့် သူ့ရဲ့ တပါးဒဲရှိဟှူ သားတော်ဟှို ပေးလေဟှယ်။ အယ်ကြောန့် သားတော်ဟှို ယောင်ကြည်ဟှူ လူတိုင်းဟှာ ပျစ်စီးဘဲ့န ထာဝရသတ်ဟှို ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ဘုရားသခင်ဟှ သူ့ရဲ့သားတော်ဟှို အယ်လောကသားလေဟှို တရားစီရင်ဟှို့တွပ် စေလွှတ်လိုက်ဇာ မှုဟှ။ အယ်လောကဟှို ကယ်တန်ဟှို့တွပ် စေလွှတ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","သားတော်ဟှို ယောင်ကြည်ဟှူ လူလေဟှာ စီရင်ခံရဟှ။ အယ်ဘေမဲ့ ယောင်ကြည်ဘဲဟှူ လူလေဟှာ ဘုရားသခင်ရဲ့ တပါးဒဲရှိဟှူ သားတော်ရဲ့ နာမဟှို ယောင်ကြည်ဘဲကြောန့် စီရင်ခံရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","စီရင်ရှင်းရဲ့ ဘောတရားဟှ အယ်မျိုးဖြစ်ဟှယ်။ လန်းရောန်ဟှာ လောကထဲဟှို ရော့‑က်လာဟှယ်။ အယ်ဘေမဲ့ လူလေဟှာ သူးနို့ရဲ့ ကျင့်လေ ဆိုးညစ်ဟှူကြောန့် လန်းရောန်ထတ် မှောန်မိုက်ဟှို ရှစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ဆိုးညစ်ဟှူ လူတိုင်းဟှာ လန်းရောန်ဟှို မူးဘီး လန်းရောန်နားဟှို လာဂေ့ဟှ။ သူးနို့ရဲ့ ဆိုးညစ်ဟှူ ကျင့်လေဟှို ထန်ရှားရှင်ဂေ့ဘဲဟှူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","အယ်ဘေမဲ့ သမ္မာတရားအားဖြင့် သတ်ရှင်ဟှူ လူလေဟှာ လန်းရောန်နားဟှို လာဂေ့ဟှယ်။ အယ်ကြောန့် သူးနို့ လောက်ဆောန်ဟှူ ဇာလေဟှာ ဘုရားသခင်ရဲ့ ရှေ့တော်မာ ထန်းထန်ရှားရှားဟှား ဗြင်ရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","အယ်ဘီးန ယေရှုဟှာ တဗဲ့တော်လေနတူးဒူ ယုဒနယ်ဟှို သွားဂေ့ဘီး အယ်နေရာမာ သူးနို့လေနတူးဒူနေဘီး ဗတ္တိဇံပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ယောဟန်ဟှာလည်း ရှာလိမ်ဗြို့နားဟှ အဲနုန်ရပ်မာ ဗတ္တိဇံပေးနေဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်နေရာမာ ရေလေဘောင်ဂီးရှိဟှယ်။ လူလေဟှာ သူ့နားဟှို လာဂေ့ဘီး ဗတ္တိဇံခံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","အယ်မူဇာဟှာ ယောဟန် ထောန်က္လခန်မာ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ယောဟန်ရဲ့ တဗဲ့တော်တချို့ဟှာ ဘာသာဓလေ့နဆိုင်ဟှူ ဆေးကြောဇာန ပတ်သက်ဘီး ယုဒလူတယော့‑က်န စဘီးဟှာ ဂြင်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","အယ်ကြောန့် သူးနို့ဟှာ ယောဟန်နားဟှို သွားဘီး “ဆရာ၊ ယော်ဒန်မ္လစ် ရှေ့ဖတ်ကမ်းမာ ဆရာနတူးဒူ နေဖူးဟှူ၊ သူ့ကြောန်းဟှို သတ်သေခံဖူးဟှူလူဟှို မှတ်မိသေးဘဲ့လော။ ခု သူဟှာ ဗတ္တိဇံပေးနေဟှယ်။ လူတိုင်းဟှလည်း သူ့နားဟှို သွားနေဂေ့ဟှယ်!” ဆိုဘီး ပြောပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ယောဟန်ဟှ “ကောန်းဂန်ဟှနေ ပေးဟှ ဆိုဟှာ ဖယ်လူလည်းရနိုင်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘ငါဟှာ မေရှိယ မှုဟှ။ အယ်ဘေမဲ့ ငါ့ဟှို သူ့ရှေ့ဟှနေ စေလွှတ်လိုက်ဟှယ်’ ဆိုဘီး ငါပြောဟှားဇာလေဟှာ နန်းနို့ကိုယ်တိုင် ငါ့ရဲ့ သတ်သေခံလေ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ဒို့သမီးဟှို ပိုင်ဆိုင်ဟှူလူဟှာ ဒို့သားဖြစ်ဟှယ်။ အယ်ဘေမဲ့ ဒို့သားရဲ့သံဟှို ရပ်ဘီး နားထောန်နေဟှူ ဒို့သားရဲ့ မိဆွေဟှာ ဒို့သားရဲ့သံဟှို ကြားရဟှူ ခီမာ ဝန်းသာလေဟှယ်။ အယ်မျိုးဘဲ့ ငါဟှာလည်း အယ်ဝန်းသာဇာလေန ပ္လဲ့ဝနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","အယ်သခင်ဟှာ တိုးပွားရမယ်။ ငါဟှာ ဆုတ်ယုတ်ရမယ်” ဆိုဘီး ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ထတ်ဟှနေ ကြွလာဟှူ သူဟှာ ဂူလောင်းထတ် ကီးမြတ်ဟှယ်။ မ္လေဂီးဟှနေ ဖြစ်ဟှူလူဟှာ မ္လေဂီးန ဆိုင်ဘီး မ္လေဂီးရာဟှို ပြောဟှယ်။ အယ်ဘေမဲ့ ကောန်းဂန်ဘောင်ဟှနေ ကြွလာဟှူ သခင်ဟှာ ဂူလောင်းထတ် ကီးမြတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ကိုယ်တော်ဟှာ ဗြင်ဟှား၊ ကြားဟှားဇာလေဟှို ပြောဟှယ်။ အယ်ဘေမဲ့လည်း ကိုယ်တော်ရဲ့ စကားတော်ဟှို ဖယ်သူလည်း ထော့‑က်ခံဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","အယ်ဘေမဲ့ ကိုယ်တော်ရဲ့ စကားတော်လေဟှို လတ်ခံဟှူလူတိုင်းဟှ ဘုရားသခင်ဟှာ သမ္မာတရားဖြစ်ဟှယ် ဆိုဇာဟှို သိမှတ်ပြုလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ဘုရားသခင် စေလွှတ်လိုက်ဟှူလူဟှာ ဘုရားသခင်ရဲ့ စကားတော်လေဟှို ပြောဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဘုရားသခင်ဟှာ သူ့ရဲ့ ဝိညာဉ်တော်ဟှို ပ္လဲ့ဝပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ဖဟှာ သားတော်ဟှို ရှစ်တော်မူဘီး တဂိုးအာဏာ ဂူလောင်းဟှို သားတော်ရဲ့ လတ်ထဲမာ အပ်ပေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","သားတော်ဟှို ယောင်ကြည်ဟှူ လူဟှာ ထာဝရသတ်ဟှို ရဘီး သားတော်ဟှို နားထောန်ဘဲဟှူ လူဟှာ သတ်ဟှို ရဘဲန ဘုရားသခင်ရဲ့ မျစ်ဒေါသအော့‑က်မာ နေရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ယေရှုဟှာ ယောဟန်ထတ် တဗဲ့တော်လေဘောင်ဂီး ဖြစ်စေဘီး ဗတ္တိဇံပေးနေဟှယ် ဆိုဇာဟှို ဖာရိရှဲလေဟှ ကြားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","တဂယ်ဒန်းဆိုဟှာ ယေရှုကိုယ်တိုင်ဟှ ဖယ်လူဟှိုလည်း ဗတ္တိဇံပေးဟှ။ တဗဲ့တော်လေဟှဘဲ့ ဗတ္တိဇံပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","အယ်ကြောန့် ယေရှုဟှာ ယုဒနယ်ဟှနေ ထွပ်ဟှားဘီး ဂါလိလဲနယ်ဟှို ပ္လန်ဟှားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ကိုယ်တော်ဟှ ရှမာရိနယ်ဟှို ဖြတ်ဘီးဟှာ သွားရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ယာကုပ်ဟှ သူ့သားယောသပ်ဟှို ပေးဟှားဟှူ မ္လေပ္လန်နား ရှမာရိနယ်ထဲဟှ ရှုခါနာမယ်ရှိဟှူဗြို့ဟှို ရော့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ယာကုပ်ရဲ့ ရေဒွမ်းဟှာ အယ်နေရာမာရှိဟှယ်။ ယေရှုဟှာ ခရီးပန်းကြောန့် ရေဒွမ်းနားမာ ထိုင်နေဟှယ်။ အယ်ခီဟှာ မွန်းဒဲ့ခီလည်းဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ရှမာရိမီးမတယော့‑က်ဟှာ ရေခပ်ဟှို့တွပ် ရော့‑က်လာဟှူ ခီမာ ယေရှုဟှ “ငါသော့‑က်ဟှို့ ရေပေးပါ” ဆိုဘီး အယ်မီးမဟှို ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(ကိုယ်တော်ရဲ့ တဗဲ့တော်လေဟှာ စားဇာဝယ်စားဟှို့ ဗြို့ထဲဟှို သွားဂေ့ဟှားဟှယ်။) ");
INSERT INTO tvn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","အယ်မီးမဟှာ “သင်ဟှ ယုဒမျိုးသားတယော့‑က် ဖြစ်ဟှယ်။ ကျွန်မဟှ ရှမာရိမျိုးသမီးတယော‑က် ဖြစ်ဟှယ်။ ဖယ်မျိုးဖြစ်ကြောန့် ရေတောန်းသော့‑က်ရနူး” ဆိုဘီး မေးလေဟှယ်။ (ယုဒလူလေဟှာ ရှမာရိလူလေ သောင်းပြုဟှူ စန်ဟန်းဇားလေဟှို သောင်းပြုလေ့ မှေ့ဟှ။) ");
INSERT INTO tvn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ယေရှုဟှ “ဘုရားသခင်ရဲ့ လတ်ဆောန်န ငါသော့‑က်ဟှို့တွပ် ရေပေးပါ ဆိုဘီး တောန်းဆိုနေဟှူလူဟှာ ဖယ်သူဖြစ်ဟှယ် ဆိုဇာဟှို သိမယ် ဆိုဟှာ နန်ဟှာ အယ်လူနားမာ တောန်းလေ့မယ်။ အယ်လူဟှလည်း နန့်ဟှို သတ်ရေဟှို ပေးလေ့မယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","အယ်မီးမဟှ “ဆရာ၊ ဆရာမာ ရေခပ်ဟှို့ အန်းဗေါင်းလည်း မှေ့ဟှ။ ရေဒွမ်းဟှလည်း ရရတိုင်း နတ်ဟှယ်။ ဖယ်နေရာဟှနေ သတ်ရေဟှို ရဟှို့နူး။ ");
INSERT INTO tvn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","အယ်ရေဒွမ်းဟှာ ကျွန်မဟှားလေရဲ့ ဘိုးဘေးယာကုပ်ဟှ ကျွန်မဟှားလေဟှို ပေးဟှားဘီး သူကိုယ်တိုင်န သူ့ရဲ့သားမီးလေ၊ သိုးလေ၊ နွားလေ ဂူလောင်းဟှာ အယ်ရေဒွမ်းဟှ ရေဟှို သော့‑က်ဟှယ်။ ကိုယ်တော်ဟှ ကျွန်မဟှားလေရဲ့ ဘိုးဘေး ယာကုပ်ထတ် ကီးမြတ်ကြောန့်လော” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ယေရှုဟှ “အယ်ရေဟှို သော့‑က်ဟှူလူလေဟှာ ပ္လန်ဘီး ရေငတ်လေ့အူးမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","အယ်ဘေမဲ့ ငါပေးမယ့်ရေဟှို သော့‑က်ဟှူလူလေဟှာ ပ္လန်ဘီး ရေငတ်လေ့မယ် မှုဟှ။ ငါပေးမယ့်ရေဟှာ သူးနို့ထဲမာ သတ်စမ်းရေဗော့‑က် ဖြစ်ဟှားဘီး သူးနို့ဟှို ထာဝရသတ်ဟှို ပေးလေ့မယ်” ဆိုဘီး ပ္လန်ဖြေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","အယ်မီးမဟှ “ဆရာ၊ အယ်ရေဟှို ကျွန်မဟှို ပေးပါ! အယ်ဆိုဟှာ ကျွန်မဟှာ ပ္လန်ဘီး ရေငတ်ဟှို့မှုဘီ အယ်နေရာဟှို လာဘီး ရေခပ်ဇာလည်း လိုဟှမ်း” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ယေရှုဟှ “သွားဘီး နန့်လန်ဟှို ခေါ်ဘီးဟှာ ပ္လန်လာပါ” ဆိုဘီး အယ်မီးမဟှို ပ္လန်ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“ကျွန်မမာ လန်မှေ့ဟှ” ဆိုဘီး အယ်မီးမဟှ ဖြေဟှယ်။ ယေရှုဟှ “နန့်မာ လန်မှေ့ဟှ ဆိုဘီး ပြောဇာဟှာ မှန်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","နန့်မာ လန်ငါးယော့‑က်ရှိဖူးဟှယ်။ ခု နန့်နတူးဒူနေဟှူ လန်ဟှာလည်း နန့်လန်စစ်စစ် မှုဟှ။ နန်ဟှာ ငါ့ဟှို မှန်ဟှူ စကားဟှို ပြောဟှယ်” ဆိုဘီး ပ္လန်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“ဆရာ၊ ဆရာဟှာ ပရောဖက်ဖြစ်ဟှယ် ဆိုဇာဟှို ကျွန်မသိဟှားဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ကျွန်မဟှားလေရဲ့ ဘိုးဘေလေဟှာ အယ်တောန်ထတ်မာ ဘုရားသခင်ဟှို ကိုးကွယ်ဂေ့ဟှယ်။ အယ်ဘေမဲ့ ဆရာရဲ့ ယုဒလူလေဟှာ ယေရုရှလင်ဗြို့မာဘဲ့ ဘုရားသခင်ဟှို ကိုးကွယ်ရမယ် ဆိုဘီး ပြောဂေ့ဟှယ်” ဆိုဘီး အယ်မီးမဟှ ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ယေရှုဟှ “ဝှေ့မီးမ၊ ငါ့ဟှို ယောင်ကြည်ပါ။ အယ်တောန်ထတ်ဟှိုရော၊ ယေရုရှလင်ဗြို့ဟှိုရော လာဘဲန ဖဟှို ကိုးကွယ်ရဟှို့ခီ ရော့‑က်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ကယ်တန်ရှင်းဟှာ ယုဒလူလေဟှနေတဆင့် ရော့‑က်လာဟှူကြောန့် နို့ယုဒလူလေဟှာ နို့လေကိုးကွယ်ဟှူဇာဟှို သိဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ရှမာရိလူလေဟှာ နန်းနို့ကိုးကွယ်ဇာဟှို မှန်သိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","စစ်မှန်ဟှူ ကိုးကွယ်သူလေဟှာ ဝိညာဉ်နရော၊ သစ်စာနရော ဖဟှို ကိုးကွယ်ရမယ့်ခီဟှာ ရော့‑က်လာလေ့မယ်။ အယ်ဘေမဲ့ ခုဘဲ့ရော့‑က်နေဘီ။ အယ်မျိုး ကိုးကွယ်သူလေဟှို ဖဟှ လိုရှင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ဘုရားသခင်ဟှာ ဝိညာဉ်ဖြစ်ဟှူကြောန့် ကိုယ်တော့်ဟှို ကိုးကွယ်သူလေဟှာ ဝိညာဉ်နရော၊ သမ္မာတရားနရော ကိုးကွယ်ရမယ်” ဆိုဘီး အယ်မီးမဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","အယ်မီးမဟှ “ခရစ်တော် ဆိုဘီး ခေါ်ဟှူ မေရှိယကြွလာမယ် ဆိုဇာဟှို ကျွန်မသိဟှယ်။ ကြွလာဟှူ ခီမာ ကျွန်မဟှားလေဟှို ဂူလောင်း ပြောပြလေ့မယ်” ဆိုဘီး ကိုယ်တော့်ဟှို လျှော့‑က်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ယေရှုဟှ “နန့်နတူးဒူ စကားပြောနေဟှူ ငါဟှာ မေရှိယဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","အယ်ခီမာဘဲ့ ယေရှုရဲ့ တဗဲ့တော်လေဟှာ ပ္လန်ရော့‑က်လာဟှယ်။ ကိုယ်တော်ဟှာ မီးမတယော့‑က်န စကားပြောနေဇာဟှို သူးနို့လေဟှာ တွိလိုက်ကြောန့် ရရာတိုင်း အံ့ဩဟှားဂေ့ဟှယ်။ အယ်ဘေမဲ့ “ဖြားဇာလိုရှင်ဟှိနူး” ဆိုဘီး အယ်မီးမဟှို ဖယ်လူလည်းမေးဂေ့ဟှ။ “ဖြားဖြစ်ကြောန့် အယ်မီးမန စကားပြောနေရနူး” ဆိုဘီးလည်း ကိုယ်တော့်ဟှို ဖယ်လူလည်းမေးဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","အယ်ဘီးန မီးမဟှာ ရေအိုးဟှို ထားရစ်ဘီး ဗြို့ထဲဟှို ပ္လန်ဟှားဘီးဟှာ ");
INSERT INTO tvn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ကျွန်မလောက်ဟှားဟှူဇာလေ ဂူလောင်းဟှို ပြောပြသူဟှို လာဘီးကေ့ကေ့။ အယ်သူဟှာ မေရှိယဘဲ့လော” ဆိုဘီး လူလေဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","အယ်ကြောန့် သူးနို့လေဟှာ ဗြို့ထဲဟှထွပ်ဟှားဘီး ယေရှုနားဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","အယ်ခီမာဘဲ့ တဗဲ့တော်လေဟှာ ယေရှုဟှို “ဆရာ၊ တခုခုစားပါအူး!” ဆိုဘီး တောန်းလျှော့‑က်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","အယ်ဘေမဲ့ ယေရှုဟှ “နန်းနို့သိဘဲဟှူ စားဇာဟှာ ငါ့မာရှိဟှယ်” ဆိုဘီး ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","အယ်ကြောန့် တဗဲ့တော်လေဟှ “ကိုယ်တော့်ဟှို ယော့‑က်ယော့‑က်ဟှ စားဇာလေဟှို လာပို့ဟှားလော” ဆိုဘီး သူးနို့ရှင်းရှင်း စဘီးမေးနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ယေရှုဟှ “ငါ့ဟှို စေလွှတ်ဟှူသူရဲ့ လိုတော်ဟှို လိုက်နာဘီး သူလောက်ခိုင်းဟှားဟှူ လောက်ဟှို ပီးအောန်လောက်ဇာဟှာ ငါ့စားဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","နန်းနို့ဟှ ‘လေးလကြာဘီးန ရိသီးခီရော့‑က်လေ့မယ်’ ဆိုဘီး ပြောဂေ့ဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ လဲဗ္လန်လေဟှို ကေ့လိုက်။ ခု ရိသီးဟှို့ သီးနှံလေဟှာ မှည့်နေဘီ! ");
INSERT INTO tvn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ရိသီးမားဟှာ ခဟှို ယူဘီး ထာဝရသတ်တွပ် သီးနှံလေဟှို စုသီးဟှယ်။ အယ်ကြောန့် စိုက်မားန ရိသီးမားလေဟှာ တူးဒူဝန်းသာဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","အယ်ကြောန့် ‘တယော့‑က်ဟှ စိုက်ဟှယ်။ တယော့‑က်ဟှ ရိသီးဟှယ်’ ဆိုဘီး ပြောဟှားဇာဟှာ မှန်ဖြစ်ဟှားဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","နန်းနို့စိုက်ဘဲဟှူ လဲဗ္လန်မာ သီးနှံလေဟှို ရိသီးဟှို့ နန်းနို့ဟှို ငါစေလွှတ်လိုက်ဟှယ်။ တခြားလူလေဟှ လောက်ရဘီး နန်းနို့ဟှ ကျိုးခံစားရဟှယ်” ဆိုဘီး သူးနို့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","အယ်မီးမဟှ “အယ်လူဟှာ ကျွန်မလောက်ဟှားဇာလေ ဂူလောင်းဟှို ပြောပြဟှယ်” ဆိုဘီး သတ်သေခံဟှူကြောန့် အယ်ဗြို့မာရှိဟှူ ရှမာရိလူလေ ဘောင်ဂီးဟှာ ယေရှုဟှို ယောင်ကြည်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","အယ်ကြောန့် ရှမာရိလူလေဟှာ ကိုယ်တော်နားဟှို လာဟှူ ခီမာ သူးနို့ဟှာ ကိုယ်တော့်ဟှို သူးနို့နတူးဒူနေဟှို့ တောန်းလျှော့‑က်ဂေ့ဟှယ်။ အယ်န ကိုယ်တော်ဟှာ အယ်နေရာမာ နှေ့ရစ်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","လူလေဘောင်ဂီးဟှာ ကိုယ်တော်ရဲ့ တရားစကားကြောန့် ယောင်ကြည်လာဂေ့ဘီး ");
INSERT INTO tvn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","သူးနို့ဟှ “ခု နို့လေ ယောင်ကြည်ဟှားဇာဟှာ နန်ပြောကြောန့် မှုဟှ။ အယ်ဘေမဲ့ နို့လေကိုယ်တိုင် ကိုယ်တော်ရဲ့ တရားစကားဟှို ကြားဟှိကြောန့် အယ်သူဟှာ လောကရဲ့ စစ်မှန်ဟှူ ကယ်တန်ရှင် ဖြစ်ဟှယ် ဆိုဇာဟှို နို့လေသိဟှားဘီ” ဆိုဘီး အယ်မီးမဟှို ပြောပြဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","နှေ့ရစ်နေဘီးန ယေရှုဟှာ အယ်နေရာဟှနေ ထွပ်ဟှားဘီး ဂါလိလဲနယ်ဟှို ကြွတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ယေရှုကိုယ်တိုင်ဟှ “ပရောဖက်လေဟှာ သူးနို့ရဲ့ ဗြို့မာ လေးစားခံရဂေ့ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ကိုယ်တော်ဟှာ ဂါလိလဲနယ်ဟှို ရော့‑က်လာခီမာ လူလေဟှာ ကိုယ်တော့်ဟှို ကြိုဆိုဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ယေရုရှလင်ဗြို့ဟှ ပသခါပွဲဟှို သူးနို့ရော့‑က်ဟှားဂေ့ဘီး အယ်ပွဲတော်မာ ကိုယ်တော် လောက်ဟှူဇာလေ ဂူလောင်းဟှို ဗြင်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","အယ်ဘီးန ယေရှုဟှာ ရေဟှနေ ဝိုင်ဖြစ် ပ္လောန်းလဲဟှားဟှူ ဂါလိလဲနယ် ကာနဗြို့ဟှို ပ္လန်ဟှားဟှယ်။ ကပေရနောင်ဗြို့ဟှ ရာရှိတယော့‑က်ရဲ့ သားဟှာ နေကောန်းဘဲဖြစ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ယုဒနယ်ဟှနေ ဂါလိလဲနယ်ဟှို ယေရှုရော့‑က်လာဟှယ် ဆိုဇာဟှို အယ်ရာရှိဟှာ ကြားဟှားခီမာ ကိုယ်တော်နားဟှို သွားဘီး သေခါနီးဖြစ်နေဟှူ သူ့သားရဲ့ နာဟှို ပျော့‑က်စေဟှို့တွပ် တောန်းလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ယေရှုဟှ “နန်းနို့ဟှာ အံ့ဩဘွယ်ရာလေန နိမိတ်လတ်ခဏာလေဟှို ဗြင်ရဘဲ ဆိုဟှာ ယောင်ကြည်ဂေ့ဟှို့ မှုဟှ” ဆိုဘီး သူ့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ရာရှိဟှ “ဆရာ၊ ကျွန်တော့်သား သေခန် ကျွန်တော်နတူးဒူ လိုက်ပါ” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ယေရှုဟှ “သွားလိုက်ပါ။ နန့်ရဲ့သား သတ်ရှင်ဟှားလေ့မယ်” ဆိုဘီး သူ့ဟှို ပြောလေဟှယ်။ အယ်လူဟှာ ယေရှုရဲ့ စကားတော်ဟှို ယောင်ကြည်ဘီး သွားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","အီပ္လန်လမ်းမာ သူ့ရဲ့ စေခံလေဟှ သူ့ဟှို တွိဟှူခီမာ “သခင်ရဲ့သားဟှာ သတ်ရှင်ဟှားဘီ!” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","သူဟှာ သူ့ရဲ့သား နာပျော့‑က်ဟှားခီဟှို စေခံလေဟှို မေးဟှူခီမာ သူးနို့လေဟှ “နတ်ကီးမွန်းဒဲ့ တနာရီမာ နာပျော့‑က်ဟှားဟှယ်” ဆိုဘီး ဖြေဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","အယ်ခီဟှာ “နန့်ရဲ့သား သတ်ရှင်ဟှားဘီ” ဆိုဘီး ယေရှုပြောလိုက်ဟှူ ခီဖြစ်ဟှယ် ဆိုဇာဟှို ဖဟှာ ဒိရဟှားလေဟှယ်။ အယ်ကြောန့် သူ့န သူ့ရဲ့အီသား ဂူလောင်းဟှာ ယောင်ကြည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","အယ်မူဇာဟှာ ယုဒနယ်ဟှနေ ဂါလိလဲနယ်ဟှို ရော့‑က်လာဘီးန ယေရှုလောက်ဟှူ ဒုတိယ နိမိတ်လတ်ခဏာ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","အယ်ဘီးန ယုဒလူလေရဲ့ ဘာသာရေးပွဲတော် ရှိဟှူကြောန့် ယေရှုဟှာ ယေရုရှလင်ဗြို့ဟှို သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ယေရုရှလင်ဗြို့ သိုးခွဗော့‑က်နားမာ မုခ်ဦးဆောန် ငါးဆောန်ရှိဟှူ ရေကန်တကန်ရှိဟှယ်။ ဟေဗြဲစကားန ဗေသေဇာသ ဆိုဘီး ခေါ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","အယ်မုခ်ဦးဆောန်လေထဲမာ မျစ်စိကန်းဟှူလူ၊ ခေသန်ဘဲဟှူလူန လေဖြတ်ဟှူလူလေ ဘောင်ဂီးဟှာ လှဲလျောင်းနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","အယ်နေရာမာ သောင်းဆယ်ရှစ်နှစ် လောင်းလောင်း နာဇားနေဟှူ လူတယော့‑က် ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","လှဲလျောင်းနေဟှူ အယ်လူဟှို ယေရှုဟှ ဗြင်လိုက်ဘီး ခီကြာဂီး နာဇားနေရဟှယ် ဆိုဇာဟှို သိဟှူကြောန့် ကိုယ်တော်ဟှ “နန့်အနာပျော့‑က်ရှင်လော” ဆိုဘီး သူ့ဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","နာဇားနေဟှူလူဟှ “ဆရာ၊ ရေဟှို လာမွှီဟှူ ခီမာ ကျွန်တော့်ဟှို ရေကန်ထဲဟှို ခ္လပေးဟှို့လူ မှေ့ဟှ။ ကျွန်တော်ဟှာ ရေကန်ထဲဟှို ဆင်းဟှို့လောက်နေဒူးမာ တခြားတယော့‑က်ဟှ ဦးဆောင်းဆင်းဟှားလေဟှယ်” ဆိုဘီး ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ယေရှုဟှ “ထဒန်၊ နန့်ထမ်းစင်ဟှို ကော့‑က်ဘီးဟှာ လမ်းရှော့‑က်ဟှားလိုက်” ဆိုဘီး သူ့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","အယ်လူဟှာ ရှင်းရှင်းဘဲ့ နာပျော့‑က်ဟှားဘီး သူ့အိယာဟှို ကော့‑က်ဘီး လမ်းရှော့‑က်ဟှားဟှယ်။ အယ်မျိုးဖြစ်ဟှားဟှူ နေ့ဟှာ ဒန်းနေ့ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","အယ်ကြောန့် ယုဒအာဏာပိုင်လေဟှာ “အယ်နေ့ဟှာ ဒန်းနေ့ဖြစ်ဟှယ်။ နန်ဟှာ နန့်ရဲ့အိယာဟှို ကော့‑က်နေဇာဟှာ နို့လေရဲ့ ပညတ်တော်ဟှို ဆန့်ကျင်နေဇာဘဲ့” ဆိုဘီး နာပျော့‑က်ဟှားဟှူ လူဟှို ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","သူဟှ “ကျွန်တော့်ဟှို ကျန်းမာစေဟှူလူဟှ အိယာကော့‑က်ဘီးဟှာ လမ်းရှော့‑က်ဟှားလိုက် ဆိုဘီး ကျွန်တော့်ဟှို ပြောဟှယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","သူးနို့ဟှ “နန့်ဟှို အယ်မျိုးလောက်ဟှို့ ပြောဟှူလူဟှ ဖယ်သူနူး” ဆိုဘီး သူ့ဟှို မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","အယ်ဘေမဲ့ နာပျော့‑က်ဟှားဟှူလူဟှ အယ်မျိုး လောက်ခိုင်းဟှူလူဟှာ ယေရှုဖြစ်ဟှယ် ဆိုဇာဟှို သိဂေ့ဟှ။ အယ်နေရာမာ လူအောက်ဂီးရှိနေဟှူကြောန့် ယေရှုဟှလည်း တိတိဟှား ထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","အယ်ဘီးန ယေရှုဟှာ သူ့ဟှို ဗိမာန်တော်ထဲမာ တွိဟှူ ခီမာ “နားထောန်၊ နန်ဟှာ ခု နာပျော့‑က်ဟှားဘီ အယ်ကြောန့် ပြစ်လောက်ဇာလေဟှို ရပ်လိုက် အယ်မျိုးမှုဘဲနေဟှာ အယ်ထတ်ဆိုးဇာလေဟှာ နန့်မာ ဖြစ်လေ့မယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","အယ်ဘီးန အယ်လူဟှာ ထွပ်ဟှားဘီး သူ့ဟှို နာပျော့‑က်စေဟှူလူဟှာ ယေရှုဖြစ်ဟှယ် ဆိုဘီး ယုဒအာဏာပိုင်လေဟှို ပြောပြလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","အယ်ကြောန့် ဒန်းနေ့မာ အယ်မျိုး နာပျော့‑က်အောန် လောက်ပေးကြောန့် ယုဒခေါန်းဆောန်လေဟှာ ယေရှုဟှို စဘီးဟှာ ညှဉ်းဆဲဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ယေရှုဟှာ “ငါ့ဖဟှာ မြဲဒမ်း လောက်လောက်ဟှူကြောန့် ငါလည်း လောက်လောက်ဟှယ်” ဆိုဘီး သူးနို့ဟှို ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","အယ်မျိုးပြောလိုက်ကြောန့် ယုဒအာဏာပိုင်လေ ဂူလောင်းဟှာ ကိုယ်တော့်ဟှို သတ်ဟှို့ ပိုဘီး ကြိုးစားဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ယေရှုဟှာ ဒန်းနေ့ဟှို ခ္လိုးဖော့‑က်ဟှယ်။ ဘုရားသခင်ဟှို မိမိရဲ့ဖ ဆိုဘီး ခေါ်ဟှယ်။ သူ့ကိုယ်သူ ဘုရားသခင်န တတန်းဒဲထားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","အယ်ကြောန့် ယေရှုဟှ “နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ သားတော်ဟှာ သူ့လိုလို ဖြားလည်းလောက်နိုင်ဟှ။ ဖလောက်ဟှူ ဇာလေဟှို ဗြင်ဟှူအတိုင်းဘဲ့ လောက်ဇာဖြစ်ဟှယ်။ ဖလောက်ဟှူမျိုး သားတော်ဟှလည်း လောက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ဖဟှ သားတော်ဟှို ရှစ်ဟှူကြောန့် ဖကိုယ်တိုင် လောက်နေဇာလေ ဂူလောင်းဟှို သားတော်ဟှို ပြဟှယ်။ အယ်မူဇာထတ် ရရာတိုင်း ကီးဟှူဇာလေဟှို လောက်ဟှို့ ဖဟှ သားတော်ဟှို ပြအူးမယ်။ အယ်ဆိုဟှာ နန်းနို့ဂူလောင်းဟှာ အံ့ဩဟှားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ဖဟှာ လူသေလေဟှို ထမြော့‑က်စေဘီး ပ္လန်ရှင်စေမျိုးဘဲ့ သားတော်ဟှာလည်း မိမိလိုရှင်ဟှူ လူလေဟှို ပ္လန်ရှင်စေမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ဖဟှာ ဖယ်လူဟှိုလည်း တရားစီရင်ဟှ။ ဖဟှာ သားတော်ဟှို တရားစီရင်ခွမ့် ဂူလောင်းဟှို ပေးအပ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","အယ်ကြောန့် လူလေ ဂူလောင်းဟှာ ဖဟှို ရိုသေမျိုးဘဲ့ သားတော်ဟှိုလည်း ရိုသေရမယ်။ သားတော်ဟှို ရိုသေဟှ ဆိုဟှာ သားတော်ဟှို စေလွှတ်ဟှူ ဖဟှိုလည်း ရိုသေဟှ။” ");
INSERT INTO tvn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ငါ့စကားတော်လေဟှို ကြားဘီး ငါ့ဟှို စေလွှတ်ဟှူ ဖဟှို ယောင်ကြည်ဟှူလူဟှာ ထာဝရသတ်ရမယ်။ သူးနို့ဟှာ တရားစီရင်ခံရဘဲန သေရာဟှနေ သတ်ရှင်ရာဟှို ကူးဟှားဘီဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ လူသေလေဟှာ ဘုရားသခင်သားတော်ရဲ့ သံဟှို ကြားရဟှို့ခီဟှာ ရော့‑က်နေဘီ။ အယ်ခီဟှာ ရော့‑က်နေဘီ သားတော်ရဲ့ သံဟှို ကြားရဟှူ လူလေဟှာ သတ်ရှင်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ဖကိုယ်တိုင်ဟှာ သတ်ရဲ့ ရင်းမြစ်ဖြစ်ဟှူမျိုးဘဲ့ သားတော်ဟှိုလည်း သတ်ရဲ့ ရင်းမြစ်ဖြစ်စေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","သားတော်ဟှာ လူ့ရဲ့သားဖြစ်ဟှူကြောန့် တရားစီရင်ခွမ့်ဟှို အပ်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","အယ်မူဇာဟှို အံ့ဩဂေ့န။ သန်းခ္လိုင်းထဲဟှ လူသေလေ ဂူလောင်းဟှာ သားတော်ရဲ့ သံဟှို ကြားရဟှို့ ခီရော့‑က်လာနေဘီ ");
INSERT INTO tvn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","အယ်ဘီးဟှာ သူးနို့ရဲ့ သန်းခ္လိုင်းထဲဟှ ထွပ်ရမယ်။ ကောန်းဇာလောက်ဟှူ လူလေဟှာ ထမြော့‑က်ဘီး သတ်ရှင်လေ့မယ်။ ကောန်းဘဲဇာလောက်ဟှူ လူလေဟှာ ထမြော့‑က်ဘီး ပြစ်စီရင်ခံရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ငါဟှာ ငါ့ရဲ့ ခွမ့်အာဏာန ဖြားလည်းလောက်နိုင်ဟှ။ ငါဟှာ ဘုရားသခင် ပြောဟှားတိုင်းဘဲ့ တရားစီရင်ဟှယ်။ အယ်ကြောန့် ငါ့ရဲ့ တရားစီရင်ဇာဟှာ မှန်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါရဲ့ လိုတိုင်းလောက်ဟှ။ ငါ့ဟှို စေလွှတ်ဟှူ ဖရဲ့ လိုတိုင်းဘဲ့ လောက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“ငါဟှာ ငါ့ရဲ့ကြောန်းဟှို သတ်သေခံမယ် ဆိုဟှာ ငါ့ရဲ့ သတ်သေခံချစ်ဟှာ မှန်ဖြစ်ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","အယ်ဘေမဲ့ ငါ့ကြောန်းဟှို သတ်သေခံပေးမယ့် လူတယော့‑က် ရှိဟှယ်။ အယ်လူပြောဟှူ ငါ့ကြောန်းဟှာ မှန်ဖြစ်ဟှယ် ဆိုဇာဟှို ငါသိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","နန်းနို့ဟှာ ယောဟန်နားဟှို တမန်လေဟှို စေလွှတ်ဟှယ်။ သူဟှာ သမ္မာတရားဟှို သတ်သေခံဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","လူရဲ့သတ်သေခံချစ်ဟှို ငါခံယူဇာ မှုဟှ။ နန်းနို့ကယ်တန်ခံရဟှို့တွပ် အယ်မျိုး ငါပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ယောဟန်ဟှာ တော့‑က်လောန်ဘီး လန်းနေဟှူ မီးအီနတူဟှယ်။ နန်းနို့ဟှာ သူ့ရဲ့ လန်းရောန်ထဲမာ ရှစ်ဟှားဘဲ့ ပျော်ဟှို့ ဆန္ဒရှိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","အယ်ဘေမဲ့ ယောဟန်ရဲ့ သတ်သေထတ် ကီးမြတ်ဟှူ သတ်သေဟှာ ငါ့မာရှိဟှယ်။ ငါ့ဖဟှ ငါ့ဟှို ပေးအပ်ဟှူ ဇာလေဟှို ခု ငါပြီးမြော့‑က်အောန် လောက်ဆောန်နေဇာဟှာ ငါ့ဟှို ငါ့ဖဟှ စေလွှတ်ဟှယ် ဆိုဇာဟှို သတ်သေခံနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ငါ့ဟှို စေလွှတ်ဟှူ ဖဟှလည်းဘဲ့ ငါ့ကြောန်းဟှို သတ်သေခံဟှယ်။ နန်းနို့ဟှာ ဖရဲ့ သံတော်ဟှို ကြားဖူးဂေ့ဟှ။ မျစ်နှာတော်ဟှိုလည်း ဗြင်ဖူးဂေ့ဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","အယ်ဘီးဟှာ ဖစေလွှတ်ဟှူလူဟှို ယောင်ကြည်ဘဲကြောန့် စကားတော်ဟှာ နန်းနို့ရဲ့ စိနှလောင်းထဲမာ မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","နန်းနို့ဟှာ ထာဝရသတ်ဟှို တွိလေ့မယ် ထန်ဘီး ကျမ်းစာလေဟှို လေ့လာဂေ့ဟှယ်။ အယ်ကျမ်းစာလေဟှ ငါ့ကြောန်းဟှို သတ်သေခံဟှားဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","အယ်ဘေမဲ့ နန်းနို့ဟှာ သတ်ရဟှို့တွပ် ငါ့နားဟှို လာရှင်ဟှူ ဆန္ဒ မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ငါဟှာ လူလေရဲ့ ချီးမွမ်းဇာဟှို ရှာဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","အယ်ဘေမဲ့ နန်းနို့ဟှာ ဖြားမျိုးလူဇားလေ ဖြစ်ဟှယ် ဆိုဇာဟှို ငါသိဟှယ်။ နန်းနို့မာ ဘုရားသခင်ဟှို ရှစ်ဟှူ နှလောင်းသားမှေ့ဟှ ဆိုဇာဟှိုလည်း ငါသိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ငါဟှာ ငါ့ဖရဲ့ ခွမ့်အာဏာန ရော့‑က်လာဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ဟှ ငါ့ဟှို လတ်ခံဂေ့ဟှ။ အယ်ဘေမဲ့လည်း တခြားလူတယော့‑က်ဟှာ သူ့ကိုယ်ပိုင်ခွမ့်အာဏာန ရော့‑က်လာမယ် ဆိုဟှာ နန်းနို့လတ်ခံလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","နန်းနို့ဟှာ ယော့‑က်နယော့‑က် ချီးမွမ်းခံရဇာဟှို့ဘဲ့ ကြိုက်ဂေ့ဟှယ်။ အယ်ဘေမဲ့ တပါးဒဲရှိဟှူ ဘုရားသခင်နားဟှ ချီးမွမ်းခံရဟှို့ ကြိုးစားဂေ့ဘဲဟှူ နန်းနို့လေဟှာ ငါ့ဟှို ဖယ်မျိုး ယောင်ကြည်နိုင်ဂေ့မယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","အယ်ဘီးဟှာ ငါဟှ နန်းနို့ဟှို ငါ့ဖရှေ့မာ စွပ်စွဲလေ့မယ် ဆိုဇာဟှို ထန်ဂေ့န။ နန်းနို့ဟှို စွပ်စွဲမယ့်လူဟှ နန်းနို့ မျှော်လင့်အားကိုးဟှူ မောရှေဘဲ့ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","မောရှေဟှာ ငါ့ကြောန်းဟှို ရေးဟှားဟှူကြောန့် နန်းနို့ဟှာ မောရှေဟှို ယောင်ကြည်ဟှယ် ဆိုဟှာ ငါ့ဟှိုလည်း ယောင်ကြည်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","အယ်ဘေမဲ့ မောရှေရေးဟှားဟှူ ကျမ်းစာလေဟှိုမှ ယောင်ကြည်ဟှ ဆိုဟှာ ငါ့စကားတော်လေဟှိုလည်း ဖယ်မျိုး ယောင်ကြည်နိုင်ဟှို့နူး။” ");
INSERT INTO tvn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","အယ်ဘီးန ယေရှုဟှာ ဂါလိလဲအိုင်ဟှို ကူးတော်မူဟှယ်။ တိဗေရိအိုင် ဆိုဘီးလည်း ခေါ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","လူနာလေဟှို နာပျော့‑က်စေတော်မူဟှူ နိမိတ်လတ်ခဏာလေဟှို ဗြင်ဟှားဘီးကြောန့် လူအောက်ဂီးဟှာ နော့‑က်ဟှို လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ယေရှုဟှာ တောန်ထတ်ဟှို တတ်ဟှားဘီး တဗဲ့တော်လေနတူးဒူ ထိုင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ခုခီဟှာ ယုဒလူလေရဲ့ ပသခါပွဲတော် နီးကပ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ယေရှုဟှာ ပတ်စစ်မွှိကေ့လိုက်ဟှူ ခီမာ သူ့နားဟှို လူအောက်ဂီးလာနေဇာဟှို ဗြင်ဟှားဟှယ်။ အယ်ကြောန့် ဖိလိပ္ပုဟှို “အယ်လူလေဟှို ကျွေးဟှို့စားဇာ ဖယ်နေရာမာ ဝယ်ရမယ်နူး” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ကိုယ်တော်ဟှာ ဖိလိပ္ပုဟှို စမ်းသပ်ဟှို့တွပ် မေးလိုက်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကိုယ်တော်ဟှ ဖြားဇာလောက်ရမယ် ဆိုဇာဟှို သိတော်မူဟှားပီးဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ဖိလိပ္ပုဟှ “သူးနို့ဟှာ စားဇာဒစ်သားစီ စားရဟှို့တွပ် ငွေဒန်းဂါးလေ ၂၀၀ ထတ် ပိုမှဘဲ့ လော့‑က်အောန်ဝယ်နိုင်မယ်” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","တဗဲ့တော်လေထဲဟှ တယော့‑က်ဖြစ်ဟှူ ရှိမုန်ပေတရုရဲ့ညီ အန္ဒြေဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“အယ်နေရာမာ မုယောမုငါးလောင်းန ငါးနှေ့ကောန်ရှိဟှူ ကောန်သားတယော့‑က်ရှိဟှယ်။ အယ်ဘေမဲ့ အယ်မုန ငါးလေဟှာ အယ်လူလေဘောင်ဂီးတွပ် လောင်းဝလော့‑က်ဟှို့ မှုဟှ” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ယေရှုဟှ “လူလေဟှို ထိုင်ခိုင်းလိုက်” ဆိုဘီး မိန့်တော်မူဟှယ်။ အယ်နေရာမာ ဗြစ်ပ္လန်လေ ရှိဟှယ်။ အယ်ကြောန့် ၅,၀၀၀ လော့‑က်ရှိဟှူ ယော့‑က်ကျားလေဟှာ ထိုင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ယေရှုဟှာ မုဟှိုယူဘီးဟှာ ဘုရားသခင်ဟှို ကျေးဇူးတော် ချီးမွမ်းဘီးန ထိုင်နေဟှူ လူလေဟှို ဝီပေးလိုက်ဟှယ်။ အယ်မျိုးဘဲ့ ငါးဟှိုလည်း သူးနို့စားရှင်မျိုးစားဂေ့ဟှို့တွပ် ဝီပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","သူးနို့လေ ဂူလောင်းဟှာ ဗိုက်ဝဟှားဟှူ ခီမာ ကိုယ်တော်ဟှ တဗဲ့တော်လေဟှို “တခုလည်း ပစ်စလတ်ခတ် ဖြစ်ဘဲနေအောန် ကျန်နေဟှူ ပိုင်းစလေဟှို စုသီးဂေ့” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","အယ်ကြောန့် တဗဲ့တော်လေဟှာ စုသီးလိုက်ဟှူ ခီမာ လူလေစားဟှားဟှူ မုယောမုငါးလောင်းန ငါးနှေ့ကောန်ဟှနေ ကျန်နေဟှူ ပိုင်းစလေဟှာ ဆယ့်နှေ့တောန်းပ္လဲ့ ရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","အယ်နေရာမာရှိဟှူ လူလေဟှာ ယေရှုလောက်ဟှူ အယ်နိမိတ်လတ်ခဏာဟှို ဗြင်ဘီး “အယ်လူဟှာ လောကဟှို ရော့‑က်လာမယ့် ပရောဖက် စစ်မှန်ဖြစ်ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","သူးနို့ဟှာ မိမိဟှို တင်းကြပ်ခေါ်ဆောန်ဟှားဘီးဟှာ မန်းဂီးလောက်ခိုင်းဟှို့ ကြံနေဂေ့ဟှယ် ဆိုဇာဟှို ယေရှုသိတော်မူကြောန့် နော့‑က်တခါ တောန်ထတ်ဟှို တယော့‑က်ဒဲ ထွပ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","နေဒန်ဇာရော့‑က်လာခီမာ ယေရှုရဲ့ တဗဲ့တော်လေဟှာ ဂါလိလဲအိုင်ထဲဟှို ဆင်းဟှားဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","လှေထတ်ဟှို တတ်ဘီး၊ အိုင်ဟှို ဖြတ်ဘီး ကပေရနောင်ဗြို့ဟှို ပ္လန်ဟှားဂေ့ဟှယ်။ ညဉ့်ခန်းဇာရော့‑က်လာလည်း ယေရှုဟှာ သူးနို့နားဟှို ရော့‑က်လာသေးဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","အယ်ခီမာ လေပြင်းတိုက်လာဘီး လှိုင်းကီးလာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","အယ်ဘီးန တဗဲ့တော်လေဟှာ သောင်းလေးမိုင်လော့‑က် လှော်ခတ်ဘီးခီမာ ယေရှုဟှာ ရေထတ်မာ လမ်းရှော့‑က်ဘီးဟှာ လှေနားဟှို လာနေဇာဟှို ဗြင်ဟှားဘီး ကြော့‑က်လန့်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ယေရှုဟှ “ကြော့‑က်ဂေ့န။ ငါဘဲ့ဖြစ်ဟှယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","အယ်ဘီးန သူးနို့ဟှာ ဝန်းသာအားရန ကိုယ်တော့်ဟှို လှေထတ်ဟှို ဆွဲဒန်ဘီးန လှေဟှာ သူးနို့သွားမယ့် ကမ်းခြေဟှို ရှင်းရှင်းဘဲ့ ရော့‑က်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","နတ်ကီးတိုင်ရော့‑က်မှ အိုင်တဖတ်မာနေဟှားဟှူ လူအောက်ဂီးဟှာ အယ်နေရာမာ လှေတစင်းဘဲ့ရှိနေဇာဟှို ဒိထားမိဂေ့ဟှယ်။ အယ်လှေထဲမာ ယေရှုဟှာ တဗဲ့တော်လေနတူးဒူ လိုက်ဟှားဘဲ့န တဗဲ့တော်လေဘဲ့ ထွပ်ဟှားဇာဟှို သူးနို့ဟှာ သိဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","တိဗေရိဗြို့ဟှ တခြားလှေလေဟှာ သခင်ဘုရား ကျေးဇူးတော် ချီးမွမ်းဘီးန လူအောက်ဂီး မုစားဟှားဟှူ ကမ်းခြေနီးဟှို ရော့‑က်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","လူအောက်ဂီးဟှာ အယ်နေရာမာ ယေရှုန တဗဲ့တော်လေရှိဟှ ဆိုဇာဟှို သိဟှားဟှူ ခီမာ အယ်လှေလေထဲဟှို ဝမ်ဘီးန ကိုယ်တော့်ဟှို ရှာဟှို့တွပ် ကပေရနောင်ဗြို့ဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","အိုင်တဖတ်ကမ်းမာ ကိုယ်တော့်ဟှို လူလေတွိဟှူ ခီမာ သူးနို့ဟှ “ဆရာ၊ အယ်နေရာဟှို ဖယ်ခီဒူးဟှ ရော့‑က်လာနူး” ဆိုဘီး ကိုယ်တော့်ဟှို မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ယေရှုဟှ “နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ နန်းနို့ ငါ့ဟှို လိုက်ရှာနေဇာဟှာ ငါ့ရဲ့ နိမိတ်လတ်ခဏာလေဟှို နားလည်ဟှူကြောန့် မှုဟှ။ နန်းနို့ဟှာ မုဟှို စားရှင်မျိုးစားရကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ပုပ်ပျစ်တတ်ဟှူ စာတွပ် လောက်ဘဲန ထာဝရသတ်တွပ် တည်မြဲဟှူ စာဟှို လောက်ဂေ့။ အယ်မူဇာဟှာ လူ့ရဲ့သားဟှ နန်းနို့ဟှို ပေးမယ့် စာဖြစ်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဖဘုရားသခင်ဟှာ လူ့ရဲ့သားဟှို ဇိခတ်ဟှားတော်မူဟှယ်” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","အယ်ကြောန့် သူးနို့ဟှ “ကျွန်တော့်ဟှားလေဟှာ ဘုရားသခင် လိုရှင်ဟှူ လောက်ဟှို လောက်ဟှို့တွပ် ကျွန်တော့်ဟှားလေဟှ ဖြားဇာ လောက်ရဟှို့နူး” ဆိုဘီး ကိုယ်တော့်ဟှို မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ယေရှုဟှ “ဘုရားသခင် လောက်စေရှင်ဟှူဇာဟှ ဘုရားသခင် စေလွတ်လိုက်ဟှူ သူဟှို ယောင်ကြည်ဟှို့ဘဲ့ ဖြစ်ဟှယ်” ဆိုဘီး ဖြေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","သူးနို့ဟှ “အယ်ဆိုဟှာ ကျွန်တော့်ဟှားလေ ဗြင်ဘီး ကိုယ်တော့်ဟှို ယောင်ကြည်ဟှို့တွပ် ဖယ်မျိုး နိမိတ်လတ်ခဏာဟှို ကိုယ်တော်ဟှ လောက်ပြမယ်နူး။ ကိုယ်တော်ဟှ ဖယ်မျိုး လောက်ပေးမယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‘ကိုယ်တော်ဟှာ ကောန်းဂန်ဟှ မုဟှို သူးနို့စားဟှို့ ပေးတော်မူဟှယ်’ ဆိုဘီး ကျမ်းစာမာ ရေးဟှားမျိုးဘဲ့ ကျွန်တော့်ဟှားလေရဲ့ ဘိုးဘေးလေဟှ ကန္တာရမာ မန္နမုဟှို စားဂေ့ဟှယ်” ဆိုဘီး ပ္လန်ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ယေရှုဟှ “နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ကောန်းဂန်ဟှ မုဟှို နန်းနို့ဟှို ပေးဟှူ သူဟှာ မောရှေ မုဟှ။ ငါ့ဖဟှ ကောန်းဂန်ဟှနေ စစ်မှန်ဟှူ မုဟှို နန်းနို့ဟှို ပေးတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ဘုရားသခင်ပေးဟှူ မုဟှာ ကောန်းဂန်ဟှနေ ဆင်းလာဘီး လောကသားလေဟှို သတ်ပေးဟှူ သူဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","သူးနို့ဟှ “သခင်၊ အယ်မုဟှို ကျွန်တော့်ဟှားလေဟှို မြဲဒမ်း ပေးပါ” ဆိုဘီး တောန်းလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ယေရှုဟှ “ငါဟှာ သတ်မု ဖြစ်ဟှယ်။ ငါ့နားဟှို လာဟှူလူလေဟှာ လောင်းဝ ငတ်မွတ်လေ့မယ် မှုဟှ။ ငါ့ဟှို ယောင်ကြည်ဟှူ လူလေဟှာလည်း လောင်းဝ ရေငတ်လေ့မယ် မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ခု နန်းနို့ဟှာ ငါ့ဟှို ဗြင်နေဘေမဲ့ ယောင်ကြည်လေ့ဟှို့ မှုဟှ ဆိုဇာဟှို နန်းနို့ဟှို ငါပြောဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ငါ့ဖဟှ ငါ့ဟှို ပေးဟှားဟှူ လူတိုင်းဟှာ ငါ့နားဟှို လာလေ့မယ်။ ငါ့နားလာဟှူလူဟှို ငါဟှာ လောင်းဝ ပစ်ပယ်ဟှို့ မှုဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါဟှာ ငါလိုရှင်ဟှူတိုင်း လောက်ဟှို့မှုဘဲ ငါ့ဟှို စေလွတ်ဟှူ သူရဲ့ လိုရှင်ဟှူတိုင်း လောက်ဟှို့တွပ် ကောန်းဂန်ဟှနေ ဆင်းလာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ငါ့ဟှို စေလွတ်ဟှူ သူရဲ့ လိုတော်ဟှာ ငါ့ဟှို ပေးအပ်ဟှားဟှူ လူလေ ဂူလောင်း ဆောင်းရှောင်းစေဘဲန နော့‑က်ဆောင်းနေ့မာ သူးနို့လေ ဂူလောင်းဟှာ ရှင်ပ္လန်ထမြော့‑က်စေဟှို့တွပ် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ငါ့ဖလိုရှင်ဇာဟှ သားတော်ဟှို ဗြင်ဘီး ယောင်ကြည်လာဟှူ လူလေဂူလောင်းဟှာ ထာဝရသတ်ရဟှို့ဖြစ်ဟှယ်။ ငါဟှလည်း နော့‑က်ဆောင်းနေ့မာ သူးနို့ဟှို ရှင်ပ္လန်ထမြော့‑က်စေမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ကိုယ်တော်ဟှ “ငါဟှာ ကောန်းဂန်ဟှနေ ဆင်းလာဟှူ မုဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလိုက်ဟှူကြောန့် ယုဒလူလေဟှာ ကိုယ်တော်ကြောန်းဟှို စဘီးဟှာ ဝေဖန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","အယ်ကြောန့် သူးနို့ဟှ “အယ်လူဟှာ ယောသပ်ရဲ့သား ယေရှု မှုဟှလော။ နို့လေဟှာ သူ့ရဲ့ မိဖဟှို သိဟှယ်။ အယ်ဆိုဟှာ သူဟှာ ကောန်းဂန်ဟှနေ ဆင်းလာဟှယ် ဆိုဘီး ဖယ်မျိုးဖြစ်ကြောန့် ပြောနေရနူး” ဆိုဘီး ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ယေရှုဟှ “နန်းနို့ရှင်းရှင်းထဲမာ ဝေဖန်နေဇာဟှို ရပ်ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ငါ့ဟှို စေလွတ်ဟှူ ဖဟှ သူးနို့ဟှို ဆွဲခေါ်ဟှ ဆိုဟှာ လူလေဟှာ ငါ့နားဟှို လာနိုင်ဂေ့ဟှ။ ငါ့နားဟှို လာဟှူလူလေဟှို နော့‑က်ဆောင်းနေ့မာ ငါဟှာ ရှင်ပ္လန်ထမြော့‑က်စေမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ပရောဖက်ကျမ်းလေမာ ‘လူတိုင်းဟှာ ဘုရားသခင်အားဖြင့် သွန်သန်ပေးဇာဟှို ခံရလေ့မယ်’ ဆိုဘီး ရေးဟှားဟှယ်။ ဖနားဟှ ကြားရဘီး သန်ယူဟှူ ဖယ်သူမဆို ငါ့နားဟှို လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","အယ်မျိုးဆိုဟှာ ယော့‑က်ယော့‑က်ဟှ ဖဟှို ဗြင်ဖူးဟှယ် ဆိုဘီး ပြောရှင်ဇာ မှုဟှ။ ဘုရားသခင်နားဟှနေ ရော့‑က်လာဟှူသူ တယော့‑က်ဘဲ့ ဖဟှို ဗြင်ဖူးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ငါ့ဟှို ယောင်ကြည်ဟှူ လူဟှာ ထာဝရသတ်ဟှို ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ငါဟှာ သတ်မု ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","နန်းနို့ရဲ့ ဘိုးဘေလေဟှာ ကန္တာရထဲမာ မန္နမုဟှို စားရဘေမဲ့လည်း သေဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","အယ်ဘေမဲ့ အယ်မုဟှာ ကောန်းဂန်ဟှနေ ဆင်းလာဟှူကြောန့် စားဟှူလူတိုင်းဟှာ သေရလေ့ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ငါဟှာ ကောန်းဂန်ဟှနေ ဆင်းလာဟှူ သတ်မု ဖြစ်ဟှယ်။ နန်းနို့ဟှာ အယ်မုဟှို စားမယ် ဆိုဟှာ ထာဝရသတ်ရှင် လေ့မယ်။ လောကသားလေ သတ်ရှင်နိုင်ဟှို့တွပ် ငါပေးဟှူ မုဟှာ ငါ့ရဲ့သား ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","အယ်န ယုဒလူလေဟှ “အယ်လူဟှ သူ့ရဲ့သားဟှို နို့လေစားဟှို့ ဖယ်မျိုးပေးနိုင်မယ်နူး” ဆိုဘီး သူးနို့ရှင်းရှင်းဟှာ စဘီး ဂြင်းဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ယေရှုဟှ “နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ နန်းနို့ဟှာ လူ့သားရဲ့ သားဟှို စားဟှ။ သူ့ရဲ့သွီးဟှို သော့‑က်ဟှ ဆိုဟှာ နန်းနို့ရဲ့ထဲမာ သတ်မှေ့ဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ငါ့သားဟှို စားဘီး ငါ့သွီးဟှို သော့‑က်ဟှူသူလေဟှာ ထာဝရသတ်ဟှို ရဟှယ်။ ငါဟှာ သူးနို့ဟှို နော့‑က်ဆောင်းနေ့မာ ရှင်ပ္လန်ထမြော့‑က်စေမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါ့သားဟှာ စစ်မှန်ဟှူ စားဇာဖြစ်ဘီး ငါ့ရဲ့ သွီးဟှာ စစ်မှန်ဟှူ သော့‑က်ဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ငါ့ရဲ့ သားဟှို စားဘီး ငါ့သွီးဟှို သော့‑က်ဟှူ လူလေဟှာ ငါ့ရဲ့ ထဲမာ သတ်ရှင်နေဟှယ်။ ငါဟှာလည်း သူးနို့ရဲ့ ထဲမာ သတ်ရှင်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","သတ်ရှင်ဟှူ ဖဟှ ငါ့ဟှို စေလွှတ်တော်မူဘီး ငါဟှာလည်း ဖအားဖြင့် သတ်ရှင်ဟှယ်။ အယ်မျိုးဘဲ့ ငါ့ဟှို စားဟှူ လူတိုင်းဟှာလည်း ငါ့အားဖြင့် သတ်ရှင်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","အယ်မျိုးဆိုဟှာ အယ်မုဟှ ကောန်းဂန်ဟှနေ ဆင်းလာဟှူ မုဖြစ်ဟှယ်။ နန်းနို့ ဘိုးဘေးလေဟှာ မန္နမုဟှို စားဘီး သေဟှားဂေ့ဟှယ်။ အယ်ဘေမဲ့ အယ်မုဟှို စားဟှူ လူတိုင်းဟှာ ထာဝရ သတ်ရှင်လေ့မယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ယေရှုဟှာ ကပေရနောင်ဗြို့ဟှ ဝါလယ်ဇရပ်မာ သွန်သန်ပေးဒူးဟှ အယ်မူဇာလေဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ကိုယ်တော်ရဲ့ တဗဲ့တော်လေ ဘောင်ဂီးဟှာ အယ်မူဇာဟှို ကြားဘီးန “အယ်မျိုး သွန်သန်ဇာဟှာ ရရာတိုင်း ခတ်ဟှယ်။ အယ်မူဇာဟှို ဖယ်လူဟှ နားထောန်နိုင်ဟှို့နူး” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","တဗဲ့တော်လေဟှာ အယ်ကြောန်းရာဟှို ဝေဖန်နေဂေ့ဟှယ် ဆိုဇာဟှို ယေရှုဟှ လိုလိုသိနေဟှယ်။ အယ်ကြောန့် ကိုယ်တော်ဟှ “အယ်စကားကြောန့် နန်းနို့ စိပျစ်ဟှားဘီလော။ ");
INSERT INTO tvn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","အယ်ဆိုဟှာ လူ့ရဲ့သားဟှ ရင်းရင်ဒူးဟှ နေရာဟှို ပ္လန်တတ်ကြွဇာဟှို နန်းနို့လေ ဗြင်ရမယ် ဆိုဟှာ ဖယ်မျိုးထန်ဂေ့မယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ဘုရားသခင်ရဲ့ ဝိညာဉ်ဟှ သတ်ဟှို ပေးဟှယ်။ လူ့ရဲ့ တဂိုးဟှာ လောင်းဝ သောင်းဇားဟှို့ ရဟှ။ နန်းနို့ဟှို ငါပြောဟှူ စကားလေဟှာ သတ်ပေးဟှူ ဘုရားသခင်ရဲ့ ဝိညာဉ်တော်န ဆိုင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","နန်းနို့ထဲဟှ တချို့ဟှာ ခုထိ ယောင်ကြည်ဂေ့ဟှ” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူဟှယ်။ ဖယ်လူလေဟှ ယောင်ကြည်ဂေ့ဟှ။ ဖယ်လူဟှ မိမိဟှို သစ်စာဖော့‑က်မယ် ဆိုဇာဟှို ယေရှုဟှာ စစဒူးဟှ သိနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","အယ်ဘီးန ကိုယ်တော်ဟှ “အယ်ကြောန်းကြောန့် ဖဟှ ခွမ့်ပေးဟှ ဆိုဟှာ ဖယ်လူလည်း ငါ့နားဟှို လာဂေ့ဟှို့ မှုဟှ ဆိုဘီး နန်းနို့ဟှို ငါပြောဟှားဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","အယ်ခီဟှစဘီး ယေရှုရဲ့ တဗဲ့တော်လေဘောင်ဂီးဟှာ လှည့်ပ္လန်ဟှားဘီး နော့‑က်ထပ် ကိုယ်တော်နတူးဒူ လိုက်ဂေ့ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","အယ်ကြောန့် ယေရှုဟှ တဗဲ့တော်ဆယ့်နှေ့ပါးဟှို “နန်းနို့လည်း ထွပ်ဟှားရှင်ဂေ့လော” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ရှိမုန်ပေတရုဟှာ ကိုယ်တော့်ဟှို “သခင်၊ ကျွန်တော့်ဟှားလေဟှ ဖယ်လူနားဟှို သွားရဂေ့ဟှို့နူး။ ထာဝရသတ်နဆိုင်ဟှူ စကားတော်လေဟှ ကိုယ်တော်မာဘဲ့ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","အယ်ဘီးဟှာ ကိုယ်တော်ဟှာ ဘုရားသခင်နားဟှနေ ကြွလာဟှူ သန့်ရှင်းသူဖြစ်ဟှယ် ဆိုဇာဟှို ခု ကျွန်တော့်ဟှားလေ ယောင်ကြည်ဘီး သိဂေ့ဟှယ်” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ယေရှုဟှ “နန်းနို့ဆယ့်နှေ့ပါးဟှို ငါဝီးကော့‑က်ဟှားဟှယ် မှုဟှလော။ အယ်ဘေမဲ့ နန်းနို့ထဲဟှ တယော့‑က်ဟှာ နတ်ဆိုးဖြစ်ဟှယ်!” ဆိုဘီး ပ္လန်မိန့်တော်မူလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ကိုယ်တော်ဟှ ရှိမုန်ရှကာရုတ်ရဲ့သား ယုဒကြောန်းဟှို ပြောနေဇာဖြစ်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ယုဒဟှာ တဗဲ့တော်ဆယ့်နှေ့ပါးထဲဟှ တပါးဖြစ်ဘေမဲ့လည်း ကိုယ်တော့်ဟှို သစ်စာဖော့‑က်မယ့်လူဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","အယ်ဘီးန ယေရှုဟှာ ဂါလိလဲနယ်ဟှို လှည့်လည်တော်မူလေဟှယ်။ အယ်နေရာမာရှိဟှူ ယုဒအာဏာပိုင်လေဟှာ ကိုယ်တော့်ဟှို သတ်ဟှို့ရှာနေဂေ့ဟှူကြောန့် ယုဒနယ်ဟှို သွားရှင်ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ယုဒလူလေရဲ့ သစ်ခတ်တဲပွဲ နီးလာဟှူ ခီမာ၊ ");
INSERT INTO tvn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ယေရှုရဲ့ ညီလေဟှာ ကိုယ်တော့်ဟှို “နို့နောန် လောက်နေဇာလေဟှို နို့နောန်ရဲ့ တဗဲ့တော်လေ ဗြင်ရဟှို့တွပ် အယ်နေရာဟှ ထွပ်ဟှားဘီးဟှာ ယုဒနယ်ဟှို သွားပါ။ ");
INSERT INTO tvn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ပေါ်ရှင်ဟှူလူလေဟှာ သူးနို့ဖြားဇာဘဲ့လောက်လောက် လှည့်ဝှက်ဘီးလောက်ဂေ့ဟှ။ နို့နောန်ဟှာ အယ်မူဇာလေဟှို လောက်မယ် ဆိုဟှာ နို့နောန်ကြောန်းဟှို တလောကလောင်း သိစေပါ!” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ကိုယ်တော်ရဲ့ ညီလေဟှိုမှ ကိုယ်တော့်ဟှို ယောင်ကြည်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ယေရှုဟှာ သူးနို့ဟှို “ငါ့ခီရော့‑က်သေးဟှ။ နန်းနို့တွပ် ခီတိုင်းဟှာ ဆင်သင့်ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","လောကသားလေဟှာ နန်းနို့ဟှို မူးဂေ့ဟှ။ အယ်ဘေမဲ့ ငါ့ဟှို မူးဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့ရဲ့ ကျင့်လေဟှ ဆိုးညစ်ဟှယ် ဆိုဘီး ငါဟှ သတ်သေခံဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","နန်းနို့ အယ်ပွဲတော်ဟှို သွားဂေ့။ ငါ့ခီပ္လဲ့ဇောင်သေးဘဲဟှူကြောန့် အယ်ပွဲတော်ဟှို ငါသွားဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","အယ်မျိုးပြောဘီးန ကိုယ်တော်ဟှာ ဂါလိလဲနယ်မာဘဲ့ ဆစ်ဘီးနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ကိုယ်တော်ရဲ့ ညီလေဟှာ ပွဲတော်ဟှို သွားလိုက်ဘီးန ယေရှုဟှလည်း တိတိဟှား လိုက်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ယုဒအာဏာပိုင်လေဟှာ အယ်ပွဲတော်မာ ကိုယ်တော့်ဟှို ရှာဂေ့ဟှယ်။ သူးနို့ဟှ “အယ်လူဟှာ ဖယ်မာနူး” ဆိုဘီး မေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","လူအောက်ဂီးထဲမာ ကိုယ်တော်ကြောန်းဟှို တီးတိုးပြောနေဂေ့ဟှယ်။ လူတချို့ဟှ “အယ်လူဟှာ လူကောန်း ဖြစ်ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ လူတချို့ဟှ “မှုဟှ။ အယ်လူဟှာ လူလေဟှို လှည့်ဇားနေဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","အယ်ဘေမဲ့ သူးနို့ဟှာ ယုဒ အာဏာပိုင်လေဟှို ကြော့‑က်ဂေ့ဟှူကြောန့် ဖယ်လူလည်း ကိုယ်တော်ကြောန်းဟှို ပွမ့်ပွမ့်လန်းလန်းဟှား ပြောဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ပွဲတော်ကာလခီဟှာ တဝပ်ကျော်လာဟှူ ခီမာ ယေရှုဟှာ ဗိမာန်တော်ဟှို သွားဘီးဟှာ စဘီးသွန်သန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ယုဒအာဏာပိုင်လေဟှာ ရရာတိုင်း အံ့ဩဟှားဘီး “အယ်လူဟှာ ပညာသန်ဖူးဘဲ့န အယ်ပညာလေ ဘောင်ဂီးဟှို ဖယ်မျိုးသိနေရနူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ယေရှုဟှ “ငါ့သွန်သန်ချစ်ဟှာ ငါ့ရဲ့ကိုယ်ပိုင် သွန်သန်ချစ် မှုဟှ။ အယ်ဘေမဲ့ ငါ့ဟှိုစေလွတ်ဟှူ ဘုရားသခင်ရဲ့ သွန်သန်ချစ်ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ဖယ်လူဘဲ့ဖြစ်ဖြစ် ဘုရားသခင်ရဲ့ လိုတော်ဟှို လောက်ရှင်ဟှူ ဆန္ဒရှိမယ် ဆိုဟှာ ငါ့သွန်သန်ချစ်ဟှ ဘုရားသခင်နားဟှလာဇာလော၊ အယ်မျိုးမှုဘဲနေဟှာ ငါ့ရဲ့ကိုယ်ပိုင်ခွမ့်အာဏာန ပြောနေဇာလော ဆိုဇာဟှို သိလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","သူးနို့ရဲ့ ကိုယ်ပိုင် ခွမ့်အာဏာန ပြောဟှူလူလေဟှာ သူးနို့တွပ် ဖောင်းသရေတော်ဟှို့ဘဲ့ ရှာဂေ့ဟှယ်။ အယ်ဘေမဲ့ သူ့ဟှို စေလွှတ်ဟှူသူရဲ့ ဖောင်းသရေတော်ဟှို ရှာဟှူလူဟှာ ဖြောန့်မှန်ဟှူလူဖြစ်ဘီး သူ့မာ လီညာဇာ မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","မောရှေဟှ နန်းနို့ဟှို ပညတ်တရားဟှို ပေးဟှားဟှယ် မှုဟှလော။ အယ်ဘေမဲ့ နန်းနို့ထဲမာ အယ်ပညတ်တရားဟှို နားထောန်ဟှူလူ ယော့‑က်လည်း မှေ့ဟှ။ ဖြားဖြစ်ကြောန့် ငါ့ဟှို သတ်ဟှို့ကြိုးစားနေဂေ့နူး” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","လူအောက်ဂီးဟှ “နန့်ထဲမာ နတ်ဆိုးတကောန် ရှိဟှယ်! ဖယ်လူဟှ နန့်ဟှို သတ်ဟှို့ ကြိုးစားနေဂေ့နူး” ဆိုဘီး ပ္လန်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ယေရှုဟှ “နိမိတ်လတ်ခဏာတခုဟှို ငါလောက်ဟှူ ခီမာ နန်းနို့ဂူလောင်းဟှာ အံ့ဩဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","မောရှေဟှ နန်းနို့ရဲ့ သားလေဟှို ရေဖျားလှီးဟှို့ နန်းနို့ဟှို ခိုင်းဟှားဟှူကြောန့် အယ်မူဇာဟှို မောရှေဟှ စပြုဟှားဇာ မှုဟှ။ နန်းနို့ရဲ့ ဘိုးဘေးလေဟှ စဟှားဟှယ် နန်းနို့ဟှာ ဒန်းနေ့မာလည်း သားဂန်းဟှားဟှို ရေဖျားလှီးပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","မောရှေရဲ့ ပညတ်တရားဟှို ခ္လိုးဖော့‑က်ရာရော့‑က်ဘဲအောန် သားဂန်းတယော့‑က်ဟှို ဒန်းနေ့မာ ရေဖျားလှီးပေးဟှယ် ဆိုဟှာ ငါဟှာ ဒန်းနေ့မာ လူတယော့‑က်ဟှို ကျန်းမာစေဟှူကြောန့် နန်းနို့ဟှာ ငါ့ဟှို ဖြားဖြစ်ဟှိ မျစ်ဖြစ်ရနူး။ ");
INSERT INTO tvn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ပြင်ပလတ်ခဏာအားဖြင့် စီရင်ဂေ့ဘဲန မှန်းမှန်ကန်းကန်ဟှား စီရင်ဂေ့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ယေရုရှလင်ဗြို့သားတချို့ဟှ “အယ်လူဟှို အာဏာပိုင်လေဟှ သတ်ဟှို့ ရှာနေဂေ့ဟှယ် မှုဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ကေ့ကေ့! အယ်လူဟှာ လူဘောင်လယ်မာ ဟောပြောနေဇာဟှို အာဏာပိုင်လေဟှာ တားဂေ့ဟှမား! အယ်လူဟှာ မေရှိယဖြစ်ဟှယ် ဆိုဇာဟှို သူးနို့ဟှာ မှန်တိုင်း သိဟှားဘီလော။ ");
INSERT INTO tvn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","အယ်ဘေမဲ့ မေရှိယကြွလာဟှူ ခီမာ ဖယ်နေရာဟှနေ လာဟှယ် ဆိုဇာဟှို ဖယ်သူလည်း သိဂေ့ဟှ။ အယ်လူဟှာ ဖယ်ဟှလာဟှယ် ဆိုဇာဟှို နို့လေအားလောင်း သိဂေ့ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ယေရှုဟှ ဗိမာန်တော်ထဲမာ သွန်သန်ဟှူ ခီမာ သံက္လယ်ဂီးန “နန်းနို့ဟှ ငါ့ဟှို တကယ်သိဘဲ့လော။ ငါဟှာ ဖယ်ဟှလာဟှယ် ဆိုဇာဟှို သိဘဲ့လော။ ငါဟှာ ငါ့ရဲ့ ဆန္ဒန လာဇာ မှုဟှ။ အယ်ဘေမဲ့ ငါ့ဟှို စေလွှတ်ဟှူ လူဟှာ သစ်စာန ပ္လဲ့ဇောင်လေဟှယ်။ နန်းနို့ဟှာ သူ့ဟှို သိဂေ့ဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","အယ်ဘေမဲ့ ငါဟှာ သူ့ဟှို သိဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါဟှာ သူ့နားဟှနေလာဘီး သူဟှ ငါ့ဟှို စေလွှတ်လိုက်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","အယ်ကြောန့် သူးနို့ဟှ ကိုယ်တော့်ဟှို ဖမ်းဟှို့ ကြိုးစားဘေမဲ့ ကိုယ်တော်ရဲ့ခီ ရော့‑က်သေးဘဲဟှူကြောန့် ဖယ်သူလည်း ကိုယ်တော့်ဟှို ဖမ်းဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","အယ်ဘေမဲ့ လူအောက်ထဲဟှ များစုဟှာ ကိုယ်တော့်ဟှို ယောင်ကြည်ဂေ့ဘီး “မေရှိယ ရော့‑က်လာဟှူ ခီမာ အယ်လူလောက်ဇာလေထတ် ပိုများဟှူ နိမိတ်လတ်ခဏာလေဟှို ပြုတော်မူဟှို့လော” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ယေရှုကြောန်းဟှို လူအောက်ဂီးဟှ တီးတိုးပြောနေဇာလေဟှို ဖာရိရှဲလေ ကြားဟှူကြောန့် ယဇ်ပုရောဟိတ်ဂီးလေန ဖာရိရှဲလေဟှာ ကိုယ်တော့်ဟှို ဖမ်းဟှို့တွပ် စောန့်တချို့ဟှို စေလွှတ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ယေရှုဟှ “ငါဟှာ နန်းနို့နတူးဒူ ရှစ်ဟှားနေဘီးဟှာ ငါ့ဟှို စေလွှတ်တော်မူဟှူ သူနားဟှို သွားရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","နန်းနို့ဟှာ ငါ့ဟှို ရှာဘေမဲ့ တွိဟှို့ မှုဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါရှိဟှူ နေရာဟှို နန်းနို့လာနိုင်ဂေ့ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ယုဒအာဏာပိုင်လေဟှ “နို့လေရှာတွိဘဲအောန် သူဟှ ဖယ်နေရာဟှို သွားဟှို့နူး။ နို့လူမျိုးလေနေဟှူ လူမျိုးခြားလေနေဟှူ ဗြို့ဟှို သွားဘီး လူမျိုးခြားလေဟှို သွန်သန်ဟှို့လော။ ");
INSERT INTO tvn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","နို့လေဟှာ သူ့ဟှို လိုက်ရှာဘေမဲ့ ရှာတွိဟှို့ မှုဟှ။ သူရှိဟှူ နေရာဟှို နို့လေ လာနိုင်ဟှို့ မှုဟှ ဆိုဘီး ပြောဇာဟှ ဖြားဓိပါယ်နူး” ဆိုဘီး ရှင်းရှင်း ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ပွဲတော်ရဲ့ ရေးကီးဆောင်းနေ့ဖြစ်ဟှူ နော့‑က်ဆောင်းနေ့မာ ယေရှုဟှာ ထရပ်ဘီးဟှာ “ရေငတ်ဟှူ လူဟှာ ငါ့နားဟှို လာဘီး သော့က်ဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ငါ့ဟှို ယောင်ကြည်ဟှူ လူတိုင်းဟှာ သော့‑က်ရမယ်။ ကျမ်းစာမာ ပြောဟှားမျိုးဘဲ့ ‘သတ်ဟှိုပေးဟှူ ရေခ္လောန်းဟှာ သူ့ရဲ့ နှလောင်းထဲဟှနေ စီးထွပ်လာလေ့မယ်’ ” ဆိုဘီး သံက္လယ်ဂီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ကိုယ်တော့်ဟှို ယောင်ကြည်ဟှူ လူလေဟှာ လတ်ခံရရှိမယ့် ဝိညာဉ်တော်ကြောန်းဟှို မိန့်တော်မူလေဟှယ်။ ယေရှုဟှာ ဖောင်းသရေတော် ထန်ရှားဟှို့တွပ် ထမြော့‑က်ရသေးဘဲကြောန့် ဝိညာဉ်တော်ဟှို ပေးတော်မူသေးဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","လူအောက်ထဲမာ တချို့ဟှာ ကိုယ်တော်ရဲ့ စကားလေဟှို ကြားရဘီးန “အယ်လူဟှာ ပရောဖက် စစ်မှန် ဖြစ်ဟှယ်!” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","တချို့ဟှလည်း “အယ်လူဟှာ မေရှိယ ဖြစ်ဟှယ်!” ဆိုဘီး ပြောဂေ့ဟှယ်။ အယ်ဘေမဲ့ တချို့ဟှ “မေရှိယဟှာ ဂါလိလဲနယ်ဟှနေ ပေါ်ထွပ်လာဟှို့ မှုဟှ! ");
INSERT INTO tvn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","မေရှိယဟှာ ဒါဝိဒ်မန်းဂီးရဲ့ မ္လေးမ္လစ်ဖြစ်ဘီး ဒါဝိဒ်နေဖူးဟှူ ဗက်လင်ဗြို့မာ မွီးမယ် ဆိုဘီး ကျမ်းစာဟှ ပြောဟှားဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","အယ်ကြောန့် ယေရှုကြောန့် လူအောက်ထဲမာ စိဝန်းကွဲဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","တချို့ဟှ ကိုယ်တော့်ဟှို ဖမ်းရှင်ဘေမဲ့ ဖယ်လူလည်း ကိုယ်တော့်ဟှို ဖမ်းဆီးဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","စောန့်လေ ပ္လန်ရော့‑က်လာဟှူ ခီမာ ယဇ်ပုရောဟိတ်ဂီးလေန ဖာရိရှဲလေဟှ “ဖြားဖြစ်ကြောန့် သူ့ဟှို ခေါ်လာဟှနူး” ဆိုဘီး သူးနို့ဟှို မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","စောန့်လေဟှ “အယ်လူမျိုး ဖယ်လူလည်းပြောဖူးဟှ!” ဆိုဘီး ပ္လန်ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ဖာရိရှဲလေဟှ “နန်းနို့လည်း လှည့်ဇားခံရဂေ့ ဟှားဘီလော” ဆိုဘီး သူးနို့ဟှို မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“အာဏာပိုင်လေန ဖာရိရှဲလေထဲမာလည်း သူ့ဟှို ယောင်ကြည်ဟှူလူ ယော့‑က်ယော့‑က်ရှိနေဘီလော။ ");
INSERT INTO tvn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","အယ်လူအော့‑က်ဟှာ မောရှေရဲ့ ပညတ်တရားဟှို သိဘဲကြောန့် သူးနို့ဟှာ ကီဇာမိနေဟှူ လူလေ ဖြစ်ဟှယ်!” ");
INSERT INTO tvn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ဖာရိရှဲလေထဲဟှ တယော့‑က်ဖြစ်ဘီး ရင်းရင်ဒူးဟှ ယေရှုနားဟှို လာဖူးဟှူ နိကောဒင်ဟှ ");
INSERT INTO tvn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“နို့လေရဲ့ ပညတ်တရားဟှာ လူလေနားဟှ ကြားနာရသေးဘဲ့န လူလေ လောက်ဟှားဇာလေဟှိုလည်း သိရသေးဘဲ့န စီရင်မယ်ဘဲ့လော” ဆိုဘီး တခြားလူလေဟှို မေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","သူးနို့ဟှ “အယ်မျိုးဆိုဟှာ နန်ဟှာလည်း ဂါလိလဲနယ်သားဘဲ့လော။ ကျမ်းစာဟှို လေ့လာဂေ့။ အယ်ဆိုဟှာ ဂါလိလဲနယ်ဟှနေ ဖယ်ပရောဖက်လည်း ပေါ်ထွပ်ဂေ့ဟှ ဆိုဇာဟှို နန်းနို့သိလာဂေ့မယ်” ဆိုဘီး ဖြေဂေ့ဟှယ်။  ");
INSERT INTO tvn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","အယ်ဘီးန သူးနို့လေဟှာ ကိုယ့်အီဟှိုကိုယ် ပ္လန်ဟှားဂေ့ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ယေရှုဟှာ သံလွင်တောန်ဟှို ကြွတော်မူဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","မိုးလန်းစောစောဂီးမာ ဗိမာန်တော်ဟှို ပ္လန်ကြွဟှားဟှယ်။ လူလေ ဂူလောင်းဟှာ ကိုယ်တော်နားမာ စုနေဂေ့ဟှယ်။ ကိုယ်တော်ဟှာ ထိုင်ဘီး သူးနို့ဟှို သွန်သန်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ဖာရိရှဲလေန ကျမ်းတတ်ဆရာလေဟှာ အီထောန်ရေးဖော့‑က်ပ္လန်နေဟှူ ခီမာ ဖမ်းဟှားဟှူ မီးမဟှို ခေါ်လာဘီး သူးနို့လေ ဂူလောင်းရှေ့မာ အယ်မီးမဟှို မတ်တတ်ရပ်ခိုင်းဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","သူးနို့လေဟှ ယေရှုဟှို “ဆရာ၊ အယ်မီးမဟှို အီထောန်ရေးဖော့‑က်ပ္လန်နေဒူးမာ ဖမ်းမိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ကျွန်တော့်ဟှားလေရဲ့ ပညတ်တရားမာ မောရှေဟှ အယ်မျိုးမီးမဟှို က္လော့‑က်ခဲန သေအောန်ပစ်ရမယ် ဆိုဘီး ပညတ်ဟှားဟှယ်။ အယ်ဆိုဟှာ ဆရာဟှ ဖယ်မျိုးပြောမယ်နူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","သူးနို့ဟှာ ယေရှုဟှို စွပ်စွဲရှင်ဟှူကြောန့် ထောန်ချော့‑က်ဆင်ဟှို့ အယ်မျိုးပြောဂေ့ဟှယ်။ အယ်ဘေမဲ့ ကိုယ်တော်ဟှာ ခေါန်းငေါက်ဘီး မ္လေဂီးထတ်မာ လတ်ညိုးန ရေးနေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","သူးနို့ဟှာ အယ်နေရာမာဘဲ့ မတ်တတ်ရပ်နေဘီး မေးခွန်းလေ မေးနေဟှူကြောန့် ကိုယ်တော်ဟှာ မော့ကေ့ဘီး “နန်းနို့ထဲဟှ ပြစ်မှေ့ဘဲလူဟှာ ဦးဆောင်း အယ်မီးမဟှို က္လော့‑က်ခဲနပစ်ဂေ့ပါ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","အယ်ဘီးန ကိုယ်တော်ဟှာ ခေါန်းငေါက်ဘီး မ္လေဂီးထတ်မာ ပ္လန်ဘီးရေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","သူးနို့ဟှာ အယ်မူစကားကြားရဟှူ ခီမာ သတ်ကီးဟှူ လူလေဟှစဘီး ယော့‑က်ဘီးယော့‑က် ထွပ်ဟှားဂေ့လေဟှယ်။ ယေရှုတပါးဒဲဘဲ့ အယ်နေရာမာ ရပ်နေဟှူမီးမနတူးဒူ ကျန်ရစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ယေရှုဟှာ မော့ကေ့ဘီး အယ်မီးမဟှို “သူးနို့ ဖယ်ရော့‑က်ဟှားဂေ့နူး။ နန့်ဟှို ပြစ်စီရင်ဟှို့ ယော့‑က်လည်းမှေ့ဟှမ်းလော။” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“ယော့‑က်လည်းမှေ့ဟှမ်း။ ဆရာ” ဆိုဘီး အယ်မီးမဟှ ပ္လန်ဖြေလေဟှယ်။ ယေရှုဟှ “ငါလည်း နန့်ဟှို ပြစ်စီရင်ဟှ။ သွားလိုက်။ အယ်ဘေမဲ့ ပ္လန်ဘီးပြစ်လောက်န” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ယေရှုဟှ ဖာရိရှဲလေဟှို “ငါဟှာ လောကရဲ့ လန်းရောန် ဖြစ်ဟှယ်။ ငါ့ရဲ့ နော့‑က်လိုက်လေဟှာ မှောန်ထဲမာ လောင်းဝရှော့‑က်ရဘဲ သတ်ရဲ့ လန်းရောန်ဟှို ရရှိမယ်” ဆိုဘီး ပ္လန်မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ဖာရိရှဲလေဟှ “ခု နန်ဟှာ နန့်ရဲ့ ကြောန်းဟှိုဘဲ့ သတ်သေခံနေဟှယ်။ နန့်ရဲ့ သတ်သေခံချစ်ဟှာ မှန်ဟှ” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ယေရှုဟှ “ငါ့ကြောန်းဟှို ငါ သတ်သေခံနေဘေမဲ့လည်း ငါပြောနေဇာလေဟှာ တကယ်ဘဲ့ဖြစ်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါဟှာ ဖယ်နေရာဟှနေလာဘီး ဖယ်နေရာဟှို သွားမယ် ဆိုဇာဟှို ငါသိဟှယ်။ နန်းနို့ဟှ ငါဟှာ ဖယ်နေရာဟှနေလာဘီး ဖယ်နေရာဟှို သွားမယ် ဆိုဇာဟှို သိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","နန်းနို့ဟှာ လူရဲ့ စံနှုန်းတိုင်း စီရင်ဂေ့ဟှယ်။ ငါဟှာ ဖယ်လူဟှိုလည်း စီရင်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","အယ်ဘေမဲ့ ငါစီရင်မယ် ဆိုဟှာလည်း ငါ့စီရင်ချစ်ဟှာ မှန်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါ့ယော့‑က်ဒဲစီရင်ဇာ မှုဟှ။ ငါ့ဟှို စေလွတ်ဟှူ ဖဟှာ ငါ့နတူးဒူရှိနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","နန်းနို့ပညတ်တရားထဲမာ သတ်သေနှေ့ယော့‑က် ဘောတူဟှူ ခီမာ သူးနို့ဖြားဇာဘဲ့ပြောပြော မှန်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ငါဟှာ ငါ့ကြောန်းဟှို သတ်သေခံဟှယ်။ ငါ့ဟှို စေလွတ်ဟှူ ဖဟှလည်း ငါ့ကိုယ်စား သတ်သေခံဟှယ်” ဆိုဘီး ပ္လန်ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","သူးနို့ဟှ “နန့်ဖဟှ ဖယ်မာနူး” ဆိုဘီး ကိုယ်တော့်ဟှို မေးဂေ့ဟှယ်။ ယေရှုဟှ “နန်းနို့ဟှာ ငါ့ဟှို သိဂေ့ဟှမျိုးဘဲ့ ငါ့ဖဟှိုလည်း သိဂေ့ဟှ။ နန်းနို့ဟှာ ငါ့ဟှို သိမယ် ဆိုဟှာ ငါ့ဖဟှိုလည်း သိဂေ့မယ်” ဆိုဘီး ပ္လန်ဖြေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ယေရှုဟှာ ဗိမာန်တော်ထဲမာ သွန်သန်တော်မူဒူးဟှ အယ်စကားလေ ဂူလောင်းဟှို လှူခံသစ်တာနီးမာ မိန့်တော်မူဟှယ်။ ကိုယ်တော်ရဲ့ ခီရော့‑က်သေးဘဲဟှူကြောန့် ကိုယ်တော့်ဟှို ဖယ်လူလည်း ဖမ်းဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ယေရှုဟှာ “ငါဝီးဟှို သွားရလေ့မယ်။ နန်းနို့ဟှာ ငါ့ဟှို လိုက်ရှာဂေ့ဘေမဲ့ နန်းနို့ရဲ့ ပြစ်ထဲမာ သေလေ့မယ်။ ငါသွားဟှို့နေရာဟှို နန်းနို့လာနိုင်ဂေ့ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","အယ်ကြောန့် ယုဒအာဏာပိုင်လေဟှ “သူလာမယ့် နေရာဟှို နန်းနို့လာနိုင်ဂေ့ဟှ ဆိုဘီး သူဟှ ပြောဟှယ်။ အယ်ဓိပါယ်ဟှ သူ့ကိုယ်သူ သတ်သေဟှို့လော” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ယေရှုဟှ “နန်းနို့ဟှာ အော့‑က်ဘောင်သားလေ ဖြစ်ဂေ့ဟှယ်။ ငါဟှ ထတ်ဘောင်ဟှနေ လာဟှယ်။ နန်းနို့ဟှာ အယ်လောကသားလေ ဖြစ်ဂေ့ဟှယ်။ ငါဟှာ အယ်လောကသား မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","အယ်ကြောန့် နန်းနို့ဟှာ နန်းနို့ရဲ့ ပြစ်ထဲမာ သေရလေ့မယ် ဆိုဘီး ငါပြောဟှားဟှယ်။ ‘ငါဖြစ်ဟှူတိုင်း ငါဖြစ်ဟှယ်’ ဆိုဇာဟှို နန်းနို့ ယောင်ကြည်ဟှ ဆိုဟှာ နန်းနို့ဟှာ နန်းနို့ရဲ့ ပြစ်ထဲမာ သေရလေ့မယ်” ဆိုဘီး ဖြေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","သူးနို့ဟှ “နန်ဟှ ဖယ်သူနူး” ဆိုဘီး ကိုယ်တော့်ဟှို မေးဂေ့ဟှယ်။ ယေရှုဟှ “ငါဖယ်သူဖြစ်ဟှယ် ဆိုဇာ နန်းနို့ဟှို စစဒူးဟှ ငါပြောပီးဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ငါ့မာ နန်းနို့န ပတ်သတ်ဘီး ပြောဟှို့ရော၊ စီရင်ဟှို့ရော ဘောင်ဂီးရှိဟှယ်။ အယ်ဘေမဲ့ ငါ့ဟှို စေလွှတ်ဟှူသူဟှာ သစ်စာန ပ္လဲ့ဇောင်ဘီး ငါဟှာ သူ့နားဟှနေ ကြားရဇာလေဟှိုဘဲ့ အယ်လောကဟှို ပြောဟှယ်” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ယေရှုဟှ ဖဟှို ရည်ညွန်းဘီး ပြောနေဇာဟှို သူးနို့ဟှ နားလည်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","အယ်ကြောန့် ယေရှုဟှ သူးနို့ဟှို “နန်းနို့ဟှ လူ့ရဲ့သားဟှို မ္လော့‑က်ဟှားဟှူ ခီမာ ‘ငါဖြစ်ဒဲ့တိုင်း ငါဖြစ်ဟှယ်’ ဆိုဇာဟှိုရော၊ ငါဟှာ ငါ့ကိုယ်ပိုင် ခွမ့်အာဏာန ဖြားလည်းလောက်ဟှ ဆိုဇာဟှိုရော၊ ငါ့ဟှို ဖဟှ ညွန်ကြားဟှားဇာလေဟှိုဘဲ့ ငါပြောဟှယ် ဆိုဇာဟှိုရော နန်းနို့လေ သိလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ငါ့ဟှို စေလွှတ်သူဟှာ ငါ့နတူးဒူ ရှိဘီး ငါဟှာ သူကြိုက်ဟှူ ဇာလေဟှို မြဲဒမ်း လောက်နေကြောန့် သူဟှာ ငါ့ဟှို တယော့‑က်ဒဲ ပစ်ထားတော်မူဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","အယ်မူဇာလေဟှို ကြားရဟှူ လူလေဟှာ ယေရှုဟှို ယောင်ကြည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","အယ်ကြောန့် ယေရှုဟှ သူ့ဟှို ယောင်ကြည်ဟှူ ယုဒလူလေဟှို “နန်းနို့ဟှာ ငါ့ရဲ့ တရားစကားဟှို နားထောန်မယ် ဆိုဟှာ နန်းနို့ဟှာ ငါ့ရဲ့ တဗဲ့တော်လေ မှန်ဘဲ့ဖြစ်ဘီး ");
INSERT INTO tvn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","နန်းနို့ဟှာ သမ္မာတရားဟှို သိရဘီးဟှာ အယ်သမ္မာတရားဟှ နန်းနို့ဟှို လွတ်မြော့‑က်စေလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","သူးနို့ဟှ “နို့လေဟှာ အာဗြဟံရဲ့ မ္လေးမ္လစ်လေဖြစ်ဘီး နို့လေဟှာ ဖယ်လူနားမာလည်း ကျွန်ခံဖူးဟှ။ အယ်ဆိုဟှာ ‘နန်းနို့လေ လွတ်မြော့‑က်လေ့မယ်’ ဆိုဘီး နန်ပြောနေဇာဟှ ဖြားဓိပါယ်နူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ယေရှုဟှ “နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ပြစ်လောက်ဟှူ လူတိုင်းဟှာ ပြစ်ရဲ့ကျွန် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ကျွန်ဟှာ အီမာ မြဲဒမ်းနေဇာ မှုဟှ။ အယ်ဘေမဲ့ သားဟှာ မြဲဒမ်း နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","သားတော်ဟှ နန်းနို့ဟှို လွတ်ပေးမယ် ဆိုဟှာ နန်းနို့ဟှာ မှန်ဘဲ့လွတ်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","နန်းနို့ဟှာ အာဗြဟံရဲ့ မ္လေးမ္လစ်ဖြစ်ဟှယ် ဆိုဇာဟှို ငါသိဟှယ်။ နန်းနို့ဟှာ ငါ့ရဲ့ သွန်သန်ချစ်ဟှို လတ်ခံရှင်ဘဲဟှူကြောန့် ငါ့ဟှို သတ်ဟှို့ ကြိုးစားနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ငါဟှာ ဖနားဟှ ဗြင်ဟှားဇာလေဟှိုဘဲ့ ပြောဟှယ်။ နန်းနို့ဟှာ နန်းနို့ဖ ပြောဟှားဇာလေဟှို လောက်ဂေ့ဟှယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","သူးနို့ဟှာ “နို့လေရဲ့ ဖဟှာ အာဗြဟံဖြစ်ဟှယ်” ဆိုဘီး ပ္လန်ဖြေဂေ့ဟှယ်။ ယေရှုဟှ “နန်းနို့ဟှာ အာဗြဟံရဲ့ သားမီးလေ မှန်ဘဲ့ဖြစ်မယ် ဆိုဟှာ အာဗြဟံလောက်မျိုးဘဲ့ လောက်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ဘုရားသခင်နားဟှနေ ငါကြားဟှားဟှူ သမ္မာတရားဟှို နန်းနို့ဟှို ပြောဘေမဲ့လည်း နန်းနို့ဟှ ငါ့ဟှို သတ်ဟှို့ ကြိုးစားဂေ့ဟှယ်။ အာဗြဟံဟှာ အယ်မျိုးလောက်ဟှ! ");
INSERT INTO tvn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","နန်းနို့ဟှာ နန်းနို့ဖ လောက်ဟှားမျိုး လောက်နေဂေ့ဟှယ်” ဆိုဘီး ပ္လန်မိန့်တော်မူလေဟှယ်။ သူးနို့ဟှ “ဘုရားသခင် ကိုယ်တိုင်ဟှာ နို့လေရဲ့ တပါးဒဲဟှူ ဖဖြစ်ဘီး နို့လေဟှာ မှားယွင်းမှုမှေ့ဘဲဟှူ သားမီးလေဖြစ်ဟှယ်” ဆိုဘီး ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ယေရှုဟှာ သူးနို့ဟှို “ဘုရားသခင်ဟှ နန်းနို့ဖ မှန်ဘဲ့ဖြစ်ဟှယ် ဆိုဟှာ နန်းနို့ဟှာ ငါ့ဟှို ရှစ်ဂေ့လေ့မယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါဟှာ ဘုရားသခင်နားဟှ လာဘီး ခု ငါအယ်မာရှိဟှယ်။ ငါ့ကိုယ်ပိုင် ခွမ့်အာဏာန လာဇာ မှုဟှ။ ကိုယ်တော်ဟှ ငါ့ဟှို စေလွှတ်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","နန်းနို့ဟှာ ငါပြောဇာဟှို ဖြားဖြစ်ကြောန့် နားလည်ဂေ့ဟှနူး။ နန်းနို့ဟှာ ငါ့ရဲ့ တရားဟှို နားထောန်နိုင်ဘဲကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","နန်းနို့ဟှာ နန်းနို့ဖ မာရ်နတ်ရဲ့ သားလေဖြစ်ဘီး နန်းနို့ဖရဲ့ လိုနော့‑က်ဟှို လိုက်ရှင်ဂေ့ဟှယ်။ စစဒူးဟှ သူဟှာ လူသတ်မားဖြစ်ဘီး သမ္မာတရား ဖတ်မာ မှေ့ဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူ့ထဲမာ သမ္မာတရားလည်း မှေ့ဟှ။ သူဟှာ လီညာသူဖြစ်ဘီး လီညာဇာ ဂူလောင်းရဲ့ ဖလည်းဖြစ်ဟှူကြောန့် သူ့ပင်ကိုစရိုက်တိုင်းဘဲ့ ပြောဆိုဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","အယ်ဘေမဲ့ ငါဟှာ သမ္မာတရားဟှို ပြောဟှူကြောန့် နန်းနို့ဟှာ ငါ့ဟှို ယောင်ကြည်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ငါ့မာ ပြစ်ရှိဟှယ် ဆိုဇာဟှို နန်းနို့ထဲဟှ ဖယ်လူတယော့‑က် သတ်သေပြနိုင်မယ်နူး။ ငါဟှာ သမ္မာတရားဟှို ပြောဟှယ် ဆိုဟှာ ဖြားဖြစ်ကြောန့် နန်းနို့ဟှာ ငါ့ဟှို ယောင်ကြည်ဂေ့ဟှနူး။ ");
INSERT INTO tvn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ဘုရားသခင်နားဟှ လာဟှူလူဟှာ ဘုရားသခင်ရဲ့ စကားလေဟှို နားထောန်ဟှယ်။ အယ်ဘေမဲ့လည်း နန်းနို့ဟှ ဘုရားသခင်နားဟှ လာဇာမှုဘဲဟှူကြောန့် နန်းနို့ဟှာ နားထောန်ဂေ့ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ယုဒလူလေဟှာ ယေရှုဟှို “နန်ဟှာ ရှမာရိလူ ဖြစ်ဘီးဟှာ နန့်ထဲမာ နတ်ဆိုးရှိဟှယ် ဆိုဘီး နို့လေပြောဇာဟှာ မှန်ဘဲကြောန့်လော” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ယေရှုဟှ “ငါ့မာ နတ်ဆိုး မှေ့ဟှ။ ငါဟှာ ငါ့ဖဟှို ချီးမြှော့‑က်ဘေမဲ့ နန်းနို့ဟှာ ငါ့ဟှို ချီးမြော့‑က်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ငါဟှာ ငါ့တွပ် ဖောင်းသရေတော်ဟှို ရှာဇာ မှုဟှ။ အယ်ဘေမဲ့ ငါ့ရဲ့ ဖောင်းသရေတော်ဟှို ရှာဘီး ငါ့ဖတ်မာ စီရင်တော်မူဟှူသူ ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ငါ့စကားဟှို နာခံဟှူ ဖယ်သူဘဲ့ဖြစ်ဖြစ် ကာလစဉ်ဆစ် သေဘေးန ကြောင်ရဟှို့ မှုဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ယုဒလူလေဟှ ကိုယ်တော့်ဟှို “နန့်မာ နတ်ဆိုးရှိဟှယ် ဆိုဇာဟှို ခု နို့လေ တိက္လသိဟှားဘီ! အာဗြဟံလည်း သေဟှားဘီ။ ပရောဖက်လေလည်း သေဟှားဘီ။ ခုထိ နန်ဟှာ နန့်ရဲ့ စကားဟှို နာခံဟှူ ဖယ်လူဘဲ့ဖြစ်ဖြစ် ကာလစဉ်ဆစ် သေရလေ့မယ် မှုဟှ ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","နန်ဟှာ သေဟှားဟှူ နို့လေရဲ့ဖ အာဗြဟံထတ် ကီးမြတ်လော။ သူဟှာ သေဟှားဘီ။ ပရောဖက်လေလည်း သေဟှားဂေ့ဘီ။ နန့်ကောန်နန် ဖယ်လူဖြစ်ဟှယ် ဆိုဘီး ထန်နေနူး” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ယေရှုဟှ “ငါဟှာ ငါ့ကိုယ်ငါ ချီးမြှော့‑က်မယ် ဆိုဟှာ အယ်မျိုး ချီးမြှော့‑က်ဇာဟှာ သောင်းဇားရဟှို့ မှုဟှ။ ငါ့ဟှို ချီးမြှော့‑က်ဟှူ သူဟှာ ငါ့ဖ ဖြစ်ဘီး နန်းနို့ပြောနေဟှူ နန်းနို့ရဲ့ ဘုရားသခင် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","နန်းနို့ဟှာ သူ့ဟှို လောင်းဝ သိဂေ့ဘေမဲ့ ငါဟှာ သူ့ဟှို သိဟှယ်။ သူ့ဟှို ငါသိဟှ ဆိုဘီး ပြောမယ် ဆိုဟှာ ငါဟှာလည်း နန်းနို့မျိုးဘဲ့ လီညာသူ ဖြစ်ဟှားလေ့မယ်။ အယ်ဘေမဲ့ ငါဟှာ သူ့ဟှို သိဘီး သူ့စကားဟှို နာခံဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","နန်းနို့ဖ အာဗြဟံဟှာ ငါလာမယ့် ခီကာလဟှို ဗြင်ရမယ် ဖြစ်ဟှူကြောန့် ပျော်ရွှင်နေဘီး အယ်နေ့ရစ်ဟှို ဗြင်ဟှားဟှူ ခီမာ ဝန်းသာလေဟှယ်” ဆိုဘီး ပ္လန်ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ယုဒလူလေဟှာ ကိုယ်တော့်ဟှို “နန်ဟှာ သတ်ငါးဆယ်မျှ ပ္လဲ့သေးဘဲ့န ဖယ်မျိုးလောက်ဘီး အာဗြဟံဟှို ဗြင်ဖူးဟှားဟှယ်နူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ယေရှုဟှ “နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ အာဗြဟံ မွီးခန်ဂဒဲဟှ ငါရှိဟှယ်!” ဆိုဘီး ပ္လန်ဖြေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","အယ်န သူးနို့ဟှာ ကိုယ်တော့်ဟှို ပစ်ဟှို့ က္လော့‑က်ခဲလေဟှို ကော့‑က်ဂေ့ဟှယ်။ အယ်ဘေမဲ့ ယေရှုဟှာ ဗိမာန်တော်ဟှနေ ရှောန်ထွပ်ဟှားတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ယေရှုဟှာ လမ်းရှော့‑က်သွားနေဒူးမာ မွီးဂဒဲဟှ မျစ်စိကန်းနေဟှူ လူတယော့‑က်ဟှို တွိတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ကိုယ်တော်ရဲ့ တဗဲ့တော်လေဟှ ကိုယ်တော့်ဟှို “ဆရာ၊ အယ်လူဟှာ မွီးဂဒဲဟှ မျစ်စိကန်းနေဇာဟှ ဖယ်လူရဲ့ ပြစ်ကြောန့်နူး။ သူ့ရဲ့ ပြစ်ကြောန့်လော။ သူ့မိဖရဲ့ ပြစ်ကြောန့်လော” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ယေရှုဟှ “သူ့ရဲ့ ပြစ်ကြောန့်လည်း မှုဟှ။ သူ့မိဖရဲ့ ပြစ်ကြောန့်လည်း မှုဟှ။ သူ့မာ ဘုရားသခင်ရဲ့ တဂိုးတော်ဟှာ ထန်ရှားစေဟှို့တွပ်ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","နို့လေဟှာ ငါ့ဟှို စေလွှတ်ဟှူသူရဲ့ မှုတော်ဟှို နေ့ခီမာ လောက်ဆောန်ရမယ်။ ဖယ်လူလည်း လောက်နိုင်ဘဲဟှူ ညဉ့်ခီ ရော့‑က်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ငါဟှာ လောကမာ ရှိနေဟှူ ခီမာ ငါဟှာ လောကတွပ် လန်းရောန်ဖြစ်ဟှယ်” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ယေရှုဟှာ အယ်မျိုး မိန့်တော်မူဘီးန မ္လေဂီးထတ်ဟှို ထွီးရယ်န ထွီးဘီးဟှာ အယ်ထွီးရယ်န ဗယ်ဟှို နယ်လိုက်ဟှယ်။ ကိုယ်တော်ဟှာ အယ်လူရဲ့ မျစ်စိလေဟှို ဗယ်နလူးပေးလိုက်ဘီး ");
INSERT INTO tvn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","သူ့ဟှို “ရှိလောင်ရေကန်မာ သွားဘီးဆေးလိုက်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ရှိလောင် နာမယ်ဟှာ “စေလွှတ်ဟှယ်” ဆိုဘီး ဓိပါယ်ရဟှယ်။ အယ်ကြောန့် အယ်လူဟှာ သွားဘီး သူ့မျစ်နှာဟှို ဆေးလိုက်ဟှူ ခီမာ မျစ်စိဗြင်ဟှားဘီး ပ္လန်လာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","အီဇနီးရှင်းလေန ရင်းရင်ဒူးဟှ တောန်းဇားနေဟှူ သူ့ဟှို ဗြင်ဖူးဟှူလူလေဟှ “အယ်လူဟှာ ထိုင်ဘီးတောန်းဇားနေဟှူလူ မှုဟှလော” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","တချို့ဟှ “အယ်လူဘဲ့ ဖြစ်ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ အယ်ဘေမဲ့ တချို့ဟှ “အယ်လူ မှုဟှ။ အယ်လူန တူဇာဖြစ်ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ အယ်ကြောန့် အယ်လူကိုယ်တိုင်ဟှ “အယ်လူဟှာ ငါဘဲ့ဖြစ်ဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","သူးနို့ဟှ “နန်ဟှ ဖယ်မျိုးဖြစ်ကြောန့် မျစ်စိဗြင်ဟှားနူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","သူဟှ “ယေရှု ဆိုဘီး ခေါ်ဟှူလူဟှ ဗယ်ဟှို လောက်ဘီး ကျွန်တော်ရဲ့မျစ်စိဟှို ဗယ်နလူးပေးဘီးဟှာ ရှိလောင်ရေကန်ဟှို သွားဘီးဆေးဟှို့ပြောဟှယ်။ အယ်ကြောန့် ကျွန်တော်ဟှာ သွားဘီးငါ့မျစ်နှာဟှို ဆေးလိုက်ဟှူန မျစ်စိဗြင်ဟှားလေဟှယ်” ဆိုဘီး ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","သူးနို့ဟှ “အယ်လူဟှာ ဖယ်နားမာနူး” ဆိုဘီး မေးဂေ့ဟှယ်။ သူဟှ “ကျွန်တော်သိဟှ” ဆိုဘီး ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","အယ်ဘီးန သူးနို့ဟှာ မျစ်စိကန်းဖြစ်ဖူးဟှူလူဟှို ဖာရိရှဲလေနားဟှို ခေါ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ယေရှုဟှာ ဗယ်ဟှိုနယ်ဘီး အယ်လူရဲ့ မျစ်စိဟှို ဗြင်စေတော်မူဟှူနေ့ဟှာ ဒန်းနေ့ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","အယ်ကြောန့် ဖာရိရှဲလေဟှာ အယ်လူဟှို ဖယ်မျိုး မျစ်စိဗြင်ဟှားဟှယ် ဆိုဘီး ပ္လန်မေးဂေ့ဟှယ်။ အယ်လူဟှ “သူဟှာ ကျွန်တော့်မျစ်စိဟှို ဗယ်နလူးပေးဟှယ်။ ကျွန်တော်ဟှာ မျစ်နှာဟှို ဆေးလိုက်ဟှူ ခီမာ မျစ်စိဗြင်ဟှားလေဟှယ်” ဆိုဘီး သူးနို့ဟှို ပြောပြဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ဖာရိရှဲတချို့ဟှ “အယ်လူဟှာ ဒန်းနေ့ဟှို ဖော့‑က်ဖျစ်ဟှူကြောန့် ဘုရားသခင်နားဟှ လာဟှူလူ မှုဟှ” ဆိုဘီး ပြောဂေ့ဟှယ်။ တချို့ဟှလည်း “ပြစ်သားဖြစ်ဟှူလူဟှာ ဖယ်မျိုးလောက်ဘီးဟှာ အယ်မျိုး နိမိတ် လတ်ခဏာလေဟှို ပြနိုင်ဟှို့နူး” ဆိုဘီး ပြောဂေ့ဟှယ်။ အယ်ဘီးန သူးနို့ထဲမာလည်း စိဝန်းကွဲဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","အယ်ကြောန့် ဖာရိရှဲလေဟှာ အယ်လူဟှို “နန့်ဟှို မျစ်စိဗြင်စေဟှူ လူရဲ့ကြောန်းဟှို နန်ဖယ်မျိုးပြောမယ်နူး” ဆိုဘီး နော့‑က်တခါ ပ္လန်မေးဂေ့ဟှယ်။ အယ်လူဟှ “သူဟှာ ပရောဖက်ဖြစ်ဟှယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","အယ်ဘေမဲ့လည်း ယုဒအာဏာပိုင်လေဟှ သူဟှာ ရင်းရင်ဒူးဟှ မျစ်စိကန်းဖြစ်ဘီး ခု ဗြင်နေဟှယ် ဆိုဇာဟှို ယောင်ကြည်ဘဲကြောန့် သူးနို့ဟှာ သူ့မိဖလေဟှို ခေါ်ဘီးန၊ ");
INSERT INTO tvn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","သူးနို့ဟှို “အယ်လူဟှာ နန်းနို့ရဲ့ သားဘဲ့လော။ သူဟှာ မွီးဂဒဲဟှ ကန်းနေဟှယ် ဆိုဘီး နန်းနို့ပြောဂေ့ဟှယ်။ အယ်ဆိုဟှာ ခု ဖယ်မျိုးဖြစ်ဟှူကြောန့် ဗြင်နေရနူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","သူ့မိဖလေဟှ “သူဟှာ နို့လေရဲ့ သားဖြစ်ဟှယ် ဆိုဇာဟှို နို့လေ သိဂေ့ဟှယ်။ သူဟှာ မွီးဂဒဲဟှ ကန်းနေဟှယ် ဆိုဇာဟှိုလည်း နို့လေသိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","အယ်ဘေမဲ့ ခု ဖယ်မျိုးလောက်ဘီး ဗြင်ဟှားဟှယ် ဆိုဇာဟှို နို့လေသိဂေ့ဟှ။ သူ့ဟှို ဗြင်အောန်ကုသပေးဟှူ သူဟှိုလည်း နို့လေသိဂေ့ဟှ။ သူ့ဟှိုဘဲ့ မေးကေ့။ သူဟှာ ရွယ်ရော့‑က်နေဘီ။ သူ့ကြောန်းဟှို သူကိုယ်တိုင်ဘဲ့ ဖြေနိုင်မယ်!” ဆိုဘီး ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","သူ့မိဖလေဟှာ ယုဒအာဏာပိုင်လေဟှို ကြော့‑က်ဟှူကြောန့် အယ်မျိုး ပြောလိုက်ဂေ့ဟှယ်။ ယုဒအာဏာပိုင်လေဟှာ ဖယ်လူဘဲ့ဖြစ်ဖြစ် ယေရှုဟှာ မေရှိယဖြစ်ဟှယ် ဆိုဘီး ဝန်ခံမယ် ဆိုဟှာ ဝါလယ်ဇရပ်ဟှနေ နှန်ထုဟှို့တွပ် ဘောတူဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","အယ်ကြောန့်ဘဲ့ သူ့မိဖလေဟှ “သူဟှာ ရွယ်ရော့‑က်နေဘီ။ သူ့ဟှိုဘဲ့ မေးကေ့!” ဆိုဘီး ပြောလိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","သူးနို့ဟှာ မွီးဂဒဲဟှ ကန်းနေဟှူလူဟှို ဒုတိယခါ ပ္လန်ခေါ်ဘီး “မှန်တိုင်းပြောဇာအားဖြင့် ဘုရားသခင်ဟှို ချီးမွမ်းပါ! နန့်ဟှို ကုသပေးဟှူလူဟှာ ပြစ်သားတယော့‑က် ဖြစ်ဟှယ် ဆိုဇာဟှို နို့လေသိဂေ့ဟှယ်” ဆိုဘီး သူ့ဟှို ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","အယ်လူဟှ “သူဟှာ ပြစ်သားဖြစ်ဟှယ်၊ ဖြစ်ဟှ ဆိုဇာဟှို ကျွန်တော်သိဟှ။ ကျွန်တော်သိဇာတခုဟှ ရင်းရင်ဒူးဟှ ကျွန်တော်ဟှာ မျစ်ကန်းဖြစ်ဘီး ခု ဗြင်ဟှားဘီ” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","အယ်လူလေဟှ “သူဟှ နန့်ဟှို ဖြားလေ လောက်ပေးဟှယ်နူး။ နန့်ရဲ့ မျစ်စိဟှို ဖယ်မျိုး ဗြင်စေဟှယ်နူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","သူဟှ “ခန်ဗျားလေဟှို ကျွန်တော်ပြောပီးဘီ။ ခန်ဗျားလေ နားထောန်ဂေ့ဟှ။ ဖြားဖြစ်ကြောန့် ခန်ဗျားလေဟှ ပ္လန်ဘီးကြားရှင်နေရနူး။ ခန်ဗျားလေလည်း သူ့တဗဲ့ ဖြစ်ရှင်ကြောန့်လော” ဆိုဘီး ပ္လန်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","သူးနို့ဟှ “နန်ဘဲ့အယ်လူရဲ့ တဗဲ့ဖြစ်ဟှယ်။ နို့လေဟှ မောရှေရဲ့ တဗဲ့လေ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ဘုရားသခင်ဟှာ မောရှေဟှို ပြောဟှားဇာလေဟှို နို့လေသိဂေ့ဟှယ်။ အယ်ဘေမဲ့ အယ်လူဟှာ ဖယ်ဟှနေလာဟှယ် ဆိုဇာဟှို နို့လေသိဂေ့ဟှ!” ဆိုဘီး သူ့ဟှို ပြစ်တန်ဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","အယ်လူဟှ “သူဟှာ ကျွန်တော့်မျစ်စိဟှို ဗြင်စေဟှယ်။ အယ်ဘေမဲ့ ခန်ဗျားလေဟှ အယ်လူဖယ်ဟှနေ လာဟှယ် ဆိုဇာဟှို သိဂေ့ဟှ ဆိုဇာ ရရာတိုင်း အံ့ဇာကောန်းဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ဘုရားသခင်ဟှာ ပြစ်သားလေရဲ့ စကားဟှို နားထောန်ဟှ။ ဘုရားသခင်ဟှိုကြော့‑က်ဘီး ကိုယ်တော် လိုရှင်ဇာဟှို လောက်ဟှူလူလေရဲ့ စကားဟှိုဘဲ့ နားထောန်ဟှယ် ဆိုဇာဟှို ကျွန်တော့်ဟှားလေသိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","မွီးဂဒဲဟှ ကန်းနေဟှူ လူတယော့‑က်ဟှာ မျစ်စိဗြင်ဟှားဟှယ် ဆိုဇာဟှို ရှေးခေတ်ကာလဟှ ယော့‑က်လည်း ကြားဖူးဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","အယ်လူဟှာ ဘုရားသခင်နားဟှနေ လာဟှ ဆိုဟှာ ဖြားတခုလည်း လောက်နိုင်ဟှို့ မှုဟှ” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","သူးနို့ဟှ “နန်ဟှာ မွီးဂဒဲဟှ ပြစ်န ကီးလာဟှူ လူဖြစ်ဘီးဟှာ နို့လေဟှို သွန်သန်ပေးဟှို့လော” ဆိုဘီး မေးဂေ့ဟှယ်။ အယ်ဘီးန သူ့ဟှို ဝါလယ်ဇရပ်ဟှနေ နှန်ထုလိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","အယ်မျိုး နန်ထုလိုက်ဟှယ် ဆိုဇာဟှို ယေရှုဟှာ ကြားဟှားဟှူ ခီမာ အယ်လူဟှို တွိလိုက်ဟှူန “နန်ဟှာ လူ့ရဲ့သားဟှို ယောင်ကြည်ဘဲ့လော” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","အယ်လူဟှ “ဆရာ၊ လူ့ရဲ့သားဟှ ဖယ်သူနူး။ ကျွန်တော်ဟှာ သူ့ဟှို ယောင်ကြည်နိုင်ဟှို့တွပ် ပြောပြပါလား” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ယေရှုဟှ “နန်ဟှာ သူ့ဟှို ဗြင်ဖူးပီးဘီ။ ခု နန့်န စကားပြောနေဟှူ လူဘဲ့ ဖြစ်ဟှယ်” ဆိုဘီး သူ့ဟှို မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","အယ်လူဟှ “သခင်၊ ကျွန်တော် ယောင်ကြည်ပါဟှယ်!” ဆိုဘီး လျှော့‑က်လိုက်ဘီးဟှာ ယေရှုဟှို ရှိခိုးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ယေရှုဟှ “ငါဟှာ ကန်းနေဟှူ လူလေဟှို ဗြင်စေဘီး ဗြင်နေဟှူလူလေဟှို ကန်းစေဟှို့တွပ်န တရားစီရင်ဟှို့တွပ် အယ်လောကဟှို ကြွလာဟှယ်” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ကိုယ်တော်နတူးဒူ ရှိနေဟှူ ဖာရိရှဲတချို့ဟှာ အယ်မျိုးပြောဇာဟှို ကြားရဟှူကြောန့် ကိုယ်တော့်ဟှို “ဖြားနူး။ နို့လေလည်း မျစ်ကန်းဖြစ်ဟှယ်လော။” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ယေရှုဟှ “နန်းနို့ဟှာ မျစ်ကန်းဖြစ်မယ် ဆိုဟှာ နန်းနို့မာ ပြစ် မှေ့ဟှ။ အယ်ဘေမဲ့ နန်းနို့ဟှ ဗြင်ဟှယ် ဆိုဘီး ပြောနေဟှူကြောန့် နန်းနို့မာ ပြစ်ရှိဟှယ်” ဆိုဘီး ဖြေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ယေရှုဟှ “နန်းနို့ဟှို ငါ မှန်တိုင်ပြောမယ်။ သိုးခြံထဲဟှို ခွဗော့‑က်ဟှနေ ဝမ်ဘဲန တခြားနည်းလမ်းန ကျော်ဝမ်ဟှူလူဟှာ ခိုးမ္လ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ခွဗော့‑က်ဟှနေ ဝမ်ဟှူလူဟှာ သိုးထီးမားဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","သိုးထီးမားဟှို ခွဗော့‑က်စောန့်ဟှာ ခွဗော့‑က်ဖွမ့်ပေးဟှယ်။ သိုးလေဟှလည်း သူ့ရဲ့သံဟှို နားထောန်ဂေ့ဟှယ်။ သူဟှာ သူ့ရဲ့သိုးလေဟှို နာမယ်န ထုဆောန်တတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","သူ့သိုးလေဟှို ထုဆောန်ဟှားခီမာ သိုးလေရှေ့ဟှနေ သွားဟှယ်။ သိုးလေဟှလည်း သူ့ရဲ့သံဟှို သိဟှူကြောန့် သူ့နော့‑က်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","သိုးလေဟှာ လူဇီးနော့‑က်လိုက်မယ့်စား အယ်လူရဲ့ သံဟှို သိဘဲဟှူကြောန့် အယ်လူနားဟှနေ ထွပ်ပ္လေးဂေ့လေ့မယ်” ဆိုဘီး မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ယေရှုဟှ ဖာရိရှဲလေဟှို အယ်ပေါင်ဥပမာဟှို ပြောပြဘေမဲ့လည်း အယ်ပေါင်ဥပမာရဲ့ ဓိပါယ်ဟှို နားလည်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","အယ်ကြောန့် ယေရှုဟှ “နန်းနို့ဟှို ငါ မှန်တိုင်ပြောမယ်။ ငါဟှာ သိုးလေဝမ်ဟှူ ခွဗော့‑က်ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ငါ့ရှေ့ဟှ ရော့‑က်လာဟှူ လူလေ ဂူလောင်းဟှာ ခိုးမ္လလေ ဖြစ်ဂေ့ဟှယ်။ အယ်ကြောန့် သိုးလေဟှာ သူးနို့ရဲ့ သံဟှို နားထောန်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ငါဟှာ ခွဗော့‑က်ဖြစ်ဟှယ်။ ငါ့အားဖြင့်ဝမ်ဟှူလူလေဟှာ ကယ်တန်ခံရလေ့မယ်။ သူးနို့ဟှာ ထွပ်ဝမ်ဘီး စားကျက်ဟှို တွိလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ခိုးဟှာ ခိုးဟှို့၊ သတ်ဟှို့၊ ဖျစ်ဆီးဟှို့လာဟှယ်။ ငါဟှာ နန်းနို့ဟှို သတ်ရရောင်မျှ မှုဟှ သတ်န ပ္လဲ့ဇောင်စေဟှို့တွပ် လာဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ငါဟှာ ကောန်းဟှူ သိုးထီးမား ဖြစ်ဟှယ်။ ကောန်းဟှူ သိုးထီးမားဟှာ သိုးလေတွပ် သူ့သတ်ဟှို စွန့်တတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","သိုးထီးမားလည်း မှုဘဲဟှူ၊ သိုးလေရဲ့ ဇရှင်လည်း မှုဘဲဟှူ လူငှားဟှာ ဝံပုလွေလာနေဇာဟှို ဗြင်ဟှူ ခီမာ သိုးလေဟှို ထားရစ်ဘီး ထွပ်ပ္လေးဟှားတတ်ဟှယ်။ အယ်ကြောန့် ဝံပုလွေဟှာ သိုးလေဟှို ကိုက်ဖမ်းဘီး ဖ္လဲဖ္လဲစင် ဖြစ်ဟှားစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","လူငှားဟှာ လူငှားဘဲ့ဖြစ်ဟှူကြောန့် သိုးလေဟှို ဂရုစိုက်ဘဲန ထွပ်ပ္လေးဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ငါဟှာ ကောန်းမြတ်ဟှူ သိုးထီးမားဖြစ်ဟှယ်။ ဖဟှ ငါ့ဟှို သိတော်မူဘီး ငါဟှာလည်း ဖဟှို သိမျိုးဘဲ့ ငါ့သိုးလေဟှိုလည်း ငါသိဘီး ငါ့သိုးလေဟှလည်း ငါ့ဟှိုသိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ငါဟှာ သိုးလေတွပ် ငါ့သတ်ဟှို စွန့်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","အယ်သိုးခြံထဲဟှို ဝမ်ဘဲဟှူ တခြားသိုးလေဟှိုလည်း ငါပိုင်သေးဟှယ်။ အယ်သိုးလေဟှိုလည်း ငါခေါ်သွမ်းရအူးမယ်။ သူးနို့ဟှာ ငါ့သံဟှို နားထောန်ဟှူကြောန့် သိုးစုတစုဒဲ၊ သိုးထီးမား တယော့‑က်ဒဲ ဖြစ်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ငါဟှာ သတ်ဟှို ပ္လန်ရရှိစေဟှို့ ငါ့သတ်ဟှို စွန့်ရှင်ဟှူကြောန့် ဖဟှ ငါ့ဟှို ရှစ်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ဖယ်လူလည်း ငါ့သတ်ဟှို ငါ့နားဟှနေ နုယူဟှို့ ရဂေ့ဟှ။ ငါ့ရဲ့ ဆန္ဒတိုင်းဘဲ့ ငါ့သတ်ဟှို ငါစွန့်ဟှယ်။ ငါ့မာ ငါ့သတ်ဟှို စွန့်ဟှို့တွပ် ခွမ့်ရှိဘီး ငါ့သတ်ဟှို ပ္လန်ယူဟှို့တွပ်လည်း ခွမ့်ရှိဟှယ်။ အယ်စေခိုင်းချစ်ဟှို ငါဟှာ ငါ့ဖနားဟှ ရရှိဟှယ်” ဆိုဘီး ထပ်ဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","အယ်စကားလေကြောန့် ယုဒလူလေထဲမာ ထပ်ဘီး စိဝန်းကွဲဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","သူးနို့လေဟှ “သူ့မာ နတ်ဆိုးရှိဟှယ်! သူဟှာ ရူးဖြစ်ဟှယ်! ဖြားဖြစ်ကြောန့် နန်းနို့ဟှ သူ့စကားဟှို နားထောန်နေနူး” ဆိုဘီး ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","အယ်ဘေမဲ့ တချို့ဟှ “နတ်ဆိုးရှိဟှူ လူဟှာ အယ်မျိုးပြောနိုင် မှုဟှ! နတ်ဆိုးဟှ မျစ်စိကန်းနေဟှူ လူလေဟှို ဖယ်မျိုးဗြင်အောန် လောက်ပေးနိုင်မယ်နူး” ဆိုဘီး ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ယေရုရှလင်ဗြို့မာ ဗိမာန်တော် ဆစ်ကပ် ပွဲတော် ကျင်းပနေဟှယ်။ အယ်ခီဟှ ဆောန်းကာလ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ယေရှုဟှာ ဗိမာန်တော်ထဲဟှ ရှောလမုန်ရဲ့ မုခ်ဦးဆောန်ထဲမာ လမ်းရှော့‑က်နေဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ယုဒလူလေဟှာ ကိုယ်တော်နားဟှို ဝိုင်းအောင်လာဘီးန “နန်ဟှာ ဖယ်ခီထိ နို့လေရဲ့ စိဟှို ဒွိဟဖြစ်စေဟှို့နူး။ နို့လေဟှို မှန်တိုင်း ရှင်းရှင်းလန်းလန်းဟှား ပြောပြပါ။ နန်ဟှာ မေရှိယဘဲ့လော” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ယေရှုဟှ “နန်းနို့ဟှို ငါပြောပြဟှားဘေမဲ့လည်း နန်းနို့ဟှာ ယောင်ကြည်ဂေ့ဟှ။ နို့ဖရဲ့ ခွမ့်န ငါလောက်ဟှူ မှုလေဟှာ ငါ့ကြောန်းဟှို သတ်သေခံနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","အယ်ဘေမဲ့ နန်းနို့ယောင်ကြည်ဂေ့ဟှ။ နန်းနို့ဟှာ ငါ့သိုးလေမှုဘဲကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ငါ့သိုးလေဟှာ ငါ့သံဟှို နားထောန်ဂေ့ဟှယ်။ ငါဟှလည်း သူးနို့ဟှို သိဘီး သူးနို့ဟှာ ငါ့နော့‑က်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ထာဝရသတ်ဟှိုလည်း ငါပေးဟှယ်။ အယ်သိုးလေဟှာ လောင်းဝ သေရလေ့ဟှို့ မှုဟှ။ ဖယ်လူလည်း သူးနို့ဟှို ငါ့နားဟှနေ လုယူနိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","သူးနို့ဟှို ငါ့နားမာ အပ်ပေးဟှားဟှူ နို့ဖဟှာ ရှိမျှဂူလောင်းထတ် ကီးမြတ်တော်မူဟှယ်။ ဖယ်လူလည်း သူးနို့ဟှို ဖလတ်ဟှနေ လုယူနိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ငါ့ဖန ငါဟှာ တလောင်းတဝဒဲ ဖြစ်ဟှယ်” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ယုဒလူလေဟှာ ကိုယ်တော့်ဟှို ပစ်ဟှို့တွပ် က္လော့‑က်ခဲလေဟှို ပ္လန်ဘီး ကော့‑က်ယူဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ယေရှုဟှာ “ငါဟှာ ဖနားဟှ ကောန်းမြတ်ဇာလေ ဘောင်ဂီးဟှို နန်းနို့ရှေ့မာ လောက်ပြပီးဘီ။ အယ်မူလေထဲဟှ ဖြားမှုတွပ်ကြောန့် ငါ့ဟှို က္လော့‑က်ခဲန ပစ်ရှင်ဂေ့နူး” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ယုဒလူလေဟှ “ကောန်းဟှူ ကျင့်တခုခုကြောန့် နို့လေဟှာ နန့်ဟှို က္လော့‑က်ခဲန ပစ်ရှင်ဇာ မှုဟှ။ နန်ဟှာ လူဖြစ်ဘေမဲ့လည်း နန့်ကောန်နန် ဘုရားဖြစ်ဟှယ် ဆိုဘီး ဘုရားသခင်ဟှို စော်ကားဟှယ်!” ဆိုဘီး ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ယေရှုဟှ “နန်းနို့ရဲ့ ပညတ်တရားမာ ‘နန်းနို့ဟှာ ဘုရားလေ ဖြစ်ဟှယ်’ ဆိုဘီး ရေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ကျမ်းစာမာ ဖော်ပြဟှားဟှူ ဇာဟှာ မြဲဒမ်း မှန်ဟှယ် ဆိုဇာဟှို နို့လေသိဂေ့ဟှယ်။ ဘုရားသခင်ဟှ သူ့ရဲ့ စကားတော်ဟှို ကြားရဟှူလူလေဟှို ‘ဘုရားလေ’ ဆိုဘီး ခေါ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ဖဟှာ ငါ့ဟှို ဝီးကော့‑က်ဘီး အယ်လောကထဲဟှို စေလွှတ်တော်မူဟှယ်။ ငါဟှာ ဘုရားသခင်ရဲ့ သားတော် ဖြစ်ဟှယ် ဆိုဘီး ပြောဟှူကြောန့် ငါဟှာ ဘုရားသခင်ဟှို စော်ကားဟှယ် ဆိုဘီး ဖယ်မျိုးကြောန့် နန်းနို့ပြောနိုင်ဂေ့ဟှယ်နူး။ ");
INSERT INTO tvn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ငါဟှာ ငါ့ဖရဲ့ မှုတော်လေဟှို ဆောန်ရွက်ဟှ ဆိုဟှာ ငါ့ဟှို ယောင်ကြည်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","အယ်ဘေမဲ့ ငါဟှာ အယ်မှုလေဟှို လောက်ဆောန်ဟှယ် ဆိုဟှာ ငါ့ဟှို ယောင်ကြည်ဘဲဟှိုမှ ငါ့ရဲ့ လောက်ဆောန်ချစ်လေဟှို ယောင်ကြည်ဂေ့။ အယ်မျိုးယောင်ကြည်မယ် ဆိုဟှာ ဖဟှာ ငါ့ထဲမာ ရှိတော်မူဘီး ငါဟှာလည်း ဖထဲမာ ရှိတော်မူဟှယ် ဆိုဇာဟှို နန်းနို့သိဂေ့လေ့မယ်” ဆိုဘီး ဖြေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","နော့‑က်တခါ သူးနို့ဟှာ ယေရှုဟှို ဖမ်းဟှို့ ကြိုးစားဂေ့ဟှယ်။ အယ်ဘေမဲ့ ကိုယ်တော်ဟှာ သူးနို့လတ်ဟှနေ လွတ်မြောက်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","အယ်ဘီးန ယေရှုဟှာ ယော်ဒန်မ္လစ်ဟှို ဖြတ်ဘီး ပထမဦးဆောင်း ယောဟန်ဗတ္တိဇံပေးဟှူ နေရာဟှို တခါပ္လန်ကြွဟှားဘီး အယ်နေရာမာ နေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","လူလေဘောင်ဂီးဟှာ ကိုယ်တော်နားဟှို လာဂေ့ဟှယ်။ သူးနို့ဟှ “ယောဟန်ဟှာ ဖြားနိမိတ်လတ်ခဏာလေလည်း လောက်ဟှ။ အယ်ဘေမဲ့လည်း အယ်လူကြောန်းဟှို သူပြောဇာလေ ဂူလောင်းဟှာ မှန်ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","အယ်နေရာမာရှိဟှူ လူလေဘောင်ဂီးဟှာ ယေရှုဟှို ယောင်ကြည်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ဗေသနိဝါမာနေဟှူ လာဇရုဟှာ နေကောန်းဘဲဖြစ်နေဟှယ်။ ဗေသနိဝါမာ ညီအေးမလေဖြစ်ဂေ့ဟှူ မာရိန မာသဟှာ နေထိုင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","အယ်မာရိဟှာ သခင်ဘုရားရဲ့ ခေတော်ထတ်ဟှို ဆီမွှီးလောန်းခ္လဘီး ခေတော်ဟှို ဆားဗန်န သုပေးဟှူသူဖြစ်ဟှယ်။ နေကောန်းဘဲဖြစ်နေဟှူ လာဇရုဟှာ သူ့ရဲ့မောင်ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ညီအေးမနှေ့ယော့‑က်ဟှာ ယေရှုနားဟှို “သခင်၊ ကိုယ်တော်ရှစ်ဟှူလူဟှာ နေကောန်းဘဲ ဖြစ်နေဟှယ်” ဆိုဘီး ဒန်းစကားပို့လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","အယ်ဒန်းဟှို ယေရှု ကြားလိုက်ခီမာ “အယ်နာဟှာ လာဇရုဟှို သေဟှို့မှုဘဲ ဘုရားသခင်ရဲ့ ဖောင်းသရေတော်ဟှို ထန်ရှားစေဘီး ဘုရားသခင်ရဲ့ သားတော်ဟှာလည်း ဖောင်းသရေတော် ထန်ရှားလေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ယေရှုဟှာ မာသဟှိုရော၊ သူ့မရဲ့ ညီမဟှိုရော၊ လာဇရုဟှိုရော ရှစ်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ကိုယ်တော်ဟှာ လာဇရုရဲ့ဒန်းဟှို ကြားဘေမဲ့လည်း အယ်နေရာမာ နှေ့ရစ်နေနေသေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","အယ်ဘီးန ကိုယ်တော်ဟှာ တဗဲ့တော်လေဟှို “ယုဒနယ်ဟှို ပ္လန်ဂေ့ဇို့” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","တဗဲ့တော်လေဟှ “ဆရာ၊ ယုဒလူလေဟှာ ဆရာ့ဟှို စဒူးဟှဘဲ့သေး က္လော့‑က်ခဲနပစ်ဟှို့ လောက်နေဂေ့ဟှယ်။ အယ်နေရာဟှိုဘဲ့ ပ္လန်ဘီးကြွတော်မူအူးလော” ဆိုဘီး မေးလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ယေရှုဟှ “တနေ့မာ ဆယ့်နှေ့နာရီ ရှိဟှယ် မှုဟှလော။ အယ်ကြောန့် နေ့ခီမာ သွားလာဟှူ လူလေဟှာ ခလောက်တိုက်မိဂေ့ဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့ဟှ လောကရဲ့ လန်းရောန်ဟှို ဗြင်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","အယ်ဘေမဲ့ ညဉ့်မိုက်ဇာမာ သွားလာဟှူ လူလေဟှာ ခလောက်တိုက်မိဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့မာ လန်းရောန်မှေ့ဟှ” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ယေရှုဟှာ အယ်မျိုး မိန့်တော်မူဘီးန “နို့လေရဲ့ မိဆွေ လာဇရုဟှာ အိမွိဟှားဘီ။ သူ့ဟှို နှိုးဟှို့ ငါသွားမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","တဗဲ့တော်လေဟှ “သခင်၊ သူဟှာ အိမွိနေဟှယ် ဆိုဟှာ ကျန်းမာလာလေ့မယ်” ဆိုဘီး ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ယေရှုဟှာ လာဇရုသေဟှားကြောန်းဟှို မိန့်တော်မူနေ ဘေမဲ့လည်း အိမွိနေဇာဟှိုဘဲ့ မိန့်တော်မူနေဟှယ် ဆိုဘီး သူးနို့ထန်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","အယ်ကြောန့် ယေရှုဟှာ သူးနို့ဟှို “လာဇရု သေဟှားဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","အယ်ဘေမဲ့ နန်းနို့လေ ယောင်ကြည်လာဟှို့တွပ်ကြောန့် အယ်နေရာမာ ငါမှေ့ဘဲဇာဟှာ နန်းနို့တွပ် ငါဝန်းသာဟှယ်။ သူ့နားဟှို သွားဂေ့ဇို့” ဆိုဘီး ပွမ့်ပွမ့်လန်းလန်းဟှား မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","မြွှာဘ္လူး ဆိုဘီး ခေါ်ဟှူ သောမဟှာ သူ့ရဲ့ဖော်လေဟှို “နို့လေအားလောင်း ဆရာနတူးဒူ သေခံဟှို့ လိုက်ဟှားဂေ့ဇို့!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ယေရှု ရော့‑က်လာတော်မူခီမာ လာဇရုဟှို သန်းခ္လိုင်းဂူမာ သင်္ဂြိုဟ်ဟှားဇာ လေးရစ်ရှိနေဘီ ဆိုဇာဟှို တွိဟှားတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ဗေသနိဝါဟှာ ယေရုရှလင်ဗြို့ဟှနေ နှေ့မိုင်လော့‑က်ဘဲ့ ဝီးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ယုဒလူဘောင်ဂီးဟှာ မာသန မာရိရဲ့မောင် သေဟှားဟှူကြောန့် သူးနို့ဟှို နှစ်သိမ့်ဟှို့ လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","မာသဟှာ ယေရှုကြွလာဟှယ် ဆိုဇာဟှို ကြားဟှူ ခီမာ ကိုယ်တော့်ဟှို ကြိုဆိုဟှို့ ထွပ်ဟှားလေဟှယ်။ မာရိဟှာ အီမာဘဲ့ နေရစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","မာသဟှာ ယေရှုဟှို “သခင်၊ ကိုယ်တော်ဟှာ အယ်နေရာမာရှိနေမယ် ဆိုဟှာ ကျွန်မမောင် သေဟှို့ မှုဟှ! ");
INSERT INTO tvn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","အယ်ဘေမဲ့ ခု ကိုယ်တော်ဟှာ ဘုရားသခင်နားမာ တောန်းတော်မူသမျှဟှို ဘုရားသခင် ပေးတော်မူမယ် ဆိုဇာဟှို ကျွန်မသိဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ယေရှုဟှ “နန့်မောင်ဟှာ သတ်ပ္လန်ရှင်လေ့မယ်” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","မာသဟှ “သူဟှာ နော့‑က်ဆောင်းဟှူ နေ့မာ ရှင်ပ္လန်ထမြော့‑က်လေ့မယ် ဆိုဇာဟှို ကျွန်မသိပါဟှယ်” ဆိုဘီး ပ္လန်လျှော့‑က်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ယေရှုဟှာ သူ့ဟှို “ငါဟှာ ရှင်ပ္လန်ထမြော့‑က်ရှင်း ဖြစ်ဟှယ်။ သတ်လည်း ဖြစ်ဟှယ်။ ငါ့ဟှို ယောင်ကြည်ဟှူ လူလေဟှာ သေဟှားဘေမဲ့လည်း ပ္လန်ရှင်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ငါ့ဟှို ယောင်ကြည်ဘီး သတ်ရှင်နေဟှူ လူလေဟှာ ကာလစဉ်ဆစ် သေရလေ့ဟှို့ မှုဟှ။ အယ်မူဇာဟှို နန်ယောင်ကြည်ဘဲ့လော” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","သူဟှ “ယောင်ကြည်ပါဟှယ်။ သခင်! ကိုယ်တော်ဟှာ လောကဟှို ကြွလာတော်မူဟှူ ဘုရားသခင်ရဲ့ သားတော်၊ မေရှိယ ဖြစ်ဟှယ် ဆိုဇာဟှို ကျွန်မ ယောင်ကြည်ပါဟှယ်” ဆိုဘီး ပ္လန်လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","မာသဟှာ အယ်မျိုး လျှော့‑က်လိုက်ဘီးန အီဟှို ပ္လန်ဟှားဘီး ညီမမာရိဟှို တိတိဟှားခေါ်လိုက်ဟှယ်။ “ဆရာကြွလာတော်မူဘီ နန့်ဟှို မေးနေဟှယ်” ဆိုဘီး ပြောလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","မာရိဟှာ အယ်မျိုးကြားလိုက်ခီမာ ဗြန်းဗြန်ဟှား ထွပ်ဟှားဘီးဟှာ ကိုယ်တော်နားဟှို သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","အယ်ခီမာ ယေရှုဟှာ ဝါထဲဟှို ရော့‑က်သေးဘဲ မာသ လာတွိဟှူနေရာမာဘဲ့ ရှိနေသေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","မာရိဟှို နှစ်သိမ့်ပေးဟှို့ အီမာရှိနေဟှူ ယုဒလူလေဟှာ ဗြန်းဗြန်ဟှားထွပ်ဟှားဟှူ မာရိဟှို ဗြင်လိုက်ဟှယ်။ သူးနို့ဟှ ငိုဟှို့တွပ် သန်းခ္လိုင်းဂူဟှို ထွပ်ဟှားဟှယ် ဆိုဘီး ထန်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","မာရိဟှာ ယေရှုရှိနေဟှူ နေရာဟှို ရော့‑က်ဟှားဘီး ကိုယ်တော့်ဟှို တွိဟှူန ခေတော်ရင်းမာ ဒူးထော့‑က်လေဟှယ်။ “သခင်၊ ကိုယ်တော်ဟှာ အယ်နေရာမာ ရှိနေမယ် ဆိုဟှာ ကျွန်မမောင် သေဟှို့ မှုဟှ!” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ယေရှုဟှာ မာရိငိုနေဇာဟှိုရော၊ သူ့နတူးဒူလိုက်လာဟှူ ယုဒလူလေ ငိုနေဇာဟှိုရော ဗြင်ဟှူ ခီမာ ကိုယ်တော်ဟှာ ရရာတိုင်း စိကောန်းဘဲ ဖြစ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ကိုယ်တော်ဟှ “သူ့ဟှို ဖယ်မာ သင်္ဂြိုဟ်ဟှားဂေ့နူး” ဆိုဘီး သူးနို့ဟှို မေးတော်မူလေဟှယ်။ သူးနို့ဟှ “သခင်၊ ကြွဘီးကေ့တော်မူပါ” ဆိုဘီး ပ္လန်ဖြေတော်မူဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ယေရှုဟှာ ငိုတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","အယ်ကြောန့် ယုဒလူလေဟှ “ကေ့ပါအူး၊ လာဇရုဟှို ရရာတိုင်း ရှစ်ဇမား!” ဆိုဘီး ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","အယ်ဘေမဲ့ သူးနို့ထဲဟှ တချို့ဟှ “မျစ်စိကန်းနေဟှူ လူဟှို မျစ်စိပ္လန်ဗြင်အောန် လောက်ပေးဟှယ် မှုဟှလော။ လာဇရုဟှိုလည်း သေဘဲအောန် လောက်ပေးနိုင်ဟှလော” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","နော့‑က်ထပ်တခါ ဝန်းနဲလာဘီး ယေရှုဟှာ သန်းခ္လိုင်းဂူဟှို ကြွဟှားလေဟှယ်။ အယ်သန်းခ္လိုင်းဂူဝဟှို က္လော့‑က်န ပိဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ယေရှုဟှ “က္လော့‑က်ဟှို ဖယ်ထုလိုက်!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ သေဟှားလူရဲ့မယ်ဖြစ်ဟှူ မာသဟှ “သခင်၊ ခုဆိုဟှာ နံနေလေ့မယ်။ သူ့ဟှို သင်္ဂြိုဟ်ဟှားဇာ လေးရစ်ရှိဟှားဘီ!” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ယေရှုဟှာ “နန်ယောင်ကြည်မယ် ဆိုဟှာ ဘုရားသခင်ရဲ့ ဖောင်းသရေတော်ဟှို ဗြင်ရလေ့မယ် ဆိုဇာ နန့်ဟှို ငါပြောဟှားပီးဘီ မှုဟှလော” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","သူးနို့ဟှာ က္လော့‑က်ဟှို ဖယ်ထုလိုက်ဟှယ်။ ယေရှုဟှာ မော့ကေ့ဘီး “ဖ၊ ကျွန်တော့်ရဲ့ စကားဟှို နားထောန်ဟှူကြောန့် ကျေးဇူးတန်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ဖဟှာ ကျွန်တော့်ရဲ့ စကားဟှို မြဲဒမ်း နားထောန်ဟှယ် ဆိုဇာ နို့သိဟှယ်။ အယ်ဘေမဲ့ ကျွန်တော် အယ်မျိုးပြောဇာဟှ ဖဟှာ ကျွန်တော့်ဟှို စေလွတ်တော်မူဟှယ် ဆိုဇာဟှို အယ်နေရာမာ ရှိနေဟှူ လူလေဟှို သူးနို့ရဲ့ ကျိုးဟှို ကေ့ဘီး ယောင်ကြည်လာစေဟှို့ဘဲ့ ဖြစ်ဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ကိုယ်တော်ဟှာ အယ်မျိုးပြောဘီးန သံကြမ်းကြမ်းန “လာဇရု၊ ထွပ်လာဟှား!” ဆိုဘီး ခေါ်ထုလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","သေဟှားဟှူလူဟှာ လတ်ခေလေမာ ဝတ်ကြိုးန ခယ်ဟှားဘီး မျစ်နှာမာလည်း ဝတ်န ပတ်ဟှားဘီး ထွပ်လာဟှယ်။ ယေရှုဟှ “သူ့ဟှို ကြိုးဖြေပေးဂေ့” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","မာရိနားဟှို လာဟှူယုဒလူလေ ဘောင်ဂီးဟှာ ယေရှု ပြုတော်မူဇာလေဟှို ဗြင်ဘီး ကိုယ်တော့်ဟှို ယောင်ကြည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","အယ်ဘေမဲ့ သူးနို့လေထဲဟှ တချို့ဟှာ ဖာရိရှဲလေနားဟှို ပ္လန်လာဘီးဟှာ ယေရှုပြုတော်မူဇာလေဟှို ပြောပြဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","အယ်ကြောန့် ဖာရိရှဲလေန ယဇ်ပုရောဟိတ်ဂီးလေဟှာ ယုဒတရားလွှတ်တော်မာ တွိဆောင်ဘီး “နို့လေဖြားမျိုးလောက်ရမယ်နူး။ အယ်လူဟှာ နိမိတ်လတ်ခဏာလေ ဘောင်ဂီး ပြုလောက်နေဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","အယ်လူဟှို အယ်မျိုးခွမ့်ပေးဟှားမယ် ဆိုဟှာ လူတိုင်းဟှာ သူ့ဟှို ယောင်ကြည်ဟှားလေ့မယ်။ အယ်ဆိုဟှာ ရောမအာဏာပိုင်လေဟှ နို့လေရဲ့ ဗိမာန်တော်န နို့လေရဲ့ လူမျိုးဟှို ဖျစ်ဆီးပစ်လေ့မယ်!” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","သူးနို့လေထဲဟှ အယ်နှစ်မာ ယဇ်ပုရောဟိတ်မန်း ဖြစ်လာဟှူ ကယာဖဟှ “နန်းနို့လေဟှာ ရူးလေဘဲ့! ");
INSERT INTO tvn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","လူမျိုးတမျိုးလောင်း သေကျေပျစ်စီးရဟှို့ထတ် လူတယော့‑က်ဟှ လူလေတွပ် သေရဇာဟှ ရရာတိုင်း ကောန်းဟှယ် ဆိုဇာဟှို နန်းနို့လေ နားလည်ဂေ့ဟှလော” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","အယ်မျိုးပြောနေဇာဟှာ သူ့ရဲ့ ကိုယ်ပိုင်ဉာဏ်န ပြောနေဇာ မှုဟှ။ သူဟှာ အယ်နှစ်မာ ယဇ်ပုရောဟိတ်မန်း ဖြစ်လာဟှူကြောန့် ယုဒလူလေတွပ် ယေရှု သေခံပေးတော်မူမယ် ဆိုဇာဟှို ပရောဖက်ပြုနေဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","အယ်လူမျိုးတွပ်ဘဲ့မှုဘဲန ဖ္လဲဖ္လဲစင်နေဟှူ ဘုရားသခင်ရဲ့ လူလေလည်းဘဲ့ ခန္ဓာတခုထဲမာ စုဝီးလာဟှို့တွပ် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","အယ်နေ့ဟှစဘီး ယုဒအာဏာပိုင်လေဟှာ ယေရှုဟှို သတ်ဟှို့တွပ် ကြံစည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","အယ်ကြောန့် ယေရှုဟှာ ယုဒနယ်မာ ထန်းထန်းရှားရှားဟှား သွားလာဟှမ်း။ အယ်ဘေမဲ့ တောကန္တာရနားဟှ ဧဖရိမ်နာမယ်ရှိဟှူ ဗြို့ဟှို ကြွဟှားဘီး တဗဲ့တော်လေနတူးဒူ နေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ယုဒလူလေရဲ့ ပသခါပွဲတော်ခီ နီးလာဟှူ ခီမာ တောဝါဟှ လူလေဘောင်ဂီးဟှာ ဘာသာရေးစဉ်လာတိုင်း စင်ကြယ်ဇာလောက်ဟှို့ ပွဲတော်လောက်ခန်မာ ယေရုရှလင်ဗြို့ဟှို တတ်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","သူးနို့လေဟှာ ယေရှုဟှို လိုက်ရှာနေဂေ့ဟှယ်။ သူးနို့ဟှာ ဗိမာန်တော်ထဲမာ စုရောင်းမိဟှူ ခီမာ “နန်းနို့လေ ဖယ်မျိုးထန်ဂေ့နူး။ သူဟှာ အယ်ပွဲတော်ဟှို လာဟှို့တွပ် သေချာဘဲ့လော” ဆိုဘီး သူးနို့ရှင်းရှင်း မေးနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ယဇ်ပုရောဟိတ်ဂီးလေန ဖာရိရှဲလေဟှ ဖယ်သူဘဲ့ဖြစ်ဖြစ် ယေရှုရှိဟှူနေရာဟှို သိမယ် ဆိုဟှာ သူ့ဟှို ဖမ်းဆီးဟှို့တွပ် ကြောန်းကြားရမယ် ဆိုဘီး ညွှန်ကြားဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ပသခါပွဲတော်တိုင်ခန် ခြော့‑က်ရစ်ဘဲ့လိုဟှူ ခီမာ သေဘီးန ပ္လန်ရှင်လာဟှူ လာဇရုနေထိုင်ဟှူ ဗေသနိဝါဟှို ယေရှုဟှာ ကြွတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","သူးနို့ဟှာ ကိုယ်တော်တွပ် ညဉ့်ခန်းဇာဟှို ပြင်ဆင်ဘီးန မာသဟှ လောက်ကျွေးပြုလေဟှယ်။ ယေရှုနတူးဒူ ဗွဲမာထိုင်နေဟှူ လူလေထဲမာ လာဇရုလည်း ရှိနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","အယ်ခီမာ မာရိဟှာ ရာရတိုင်း ဖိုးကီးဟှူ နာဒုဆီမွှီးစစ်စစ် ဖူးဝပ်ဟှို ယူဘီး ယေရှုရဲ့ ခေတော်ထတ်ဟှို လောန်းခ္လဘီးန သူ့ရဲ့ ဆားဗန်န သုပေးလေဟှယ်။ အယ်ဆီမွှီးရဲ့ နံ့ဟှာ တအီလောင်းဟှို မွှီးကြိုင်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ယေရှုရဲ့ တဗဲ့တော်တပါးဖြစ်ဟှူ ကိုယ်တော့်ဟှို သစ်စာဖော့‑က်မယ့်လူဖြစ်ဟှူ ယုဒရှကာရုတ်ဟှ ");
INSERT INTO tvn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ဖြားဖြစ်ကြောန့် အယ်ဆီမွှီးဟှို ငွေဒန်းဂါး ၃၀၀ န ရောန်းလိုက်ဘီးဟှား ဆင်းရဲသားလေဟှို ပေးဘဲ့နေရနူး” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","သူဟှာ အယ်မျိုးပြောနေဇာဟှ ဆင်းရဲသားလေဟှို သနားကြောန့်မှုဘဲန သူခိုးတယော့‑က် ဖြစ်ကြောန့်ဖြစ်ဟှယ်။ သူဟှာ ကပ်အိဟှို လွယ်ရသူဖြစ်ဘီး ကပ်လေဟှို နှိုက်ယူတတ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","အယ်ဘေမဲ့ ယေရှုဟှ “အယ်မီးမဟှို နှော့‑က်ယှစ်ဂေ့န! သူဟှာ ငါ့ဟှို သင်္ဂြိုဟ်မယ့်နေ့တွပ် အယ်ဆီမွှီးဟှို သီးဟှားဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ဆင်းရဲသားလေဟှာ နန်းနို့နတူးဒူ မြဲဒမ်း ရှိဂေ့ဟှယ်။ ငါဟှ နန်းနို့နတူးဒူ မြဲဒမ်း ရှိနေဟှို့ မှုဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ဗေသနိဝါမာ ယေရှုရှိတော်မူဟှယ် ဆိုဇာဟှို ကြားလိုက်ဟှူ ယုဒလူလေဘောင်ဂီးဟှာ အယ်ဝါဟှို လိုက်ဟှားဂေ့ဟှယ်။ သူးနို့ဟှာ ယေရှုဟှို တွိရှင်ရောင်မျှမက သေရာဟှနေ ပ္လန်ရှင်လာဟှူ လာဇရုဟှိုလည်း တွိရှင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","အယ်ကြောန့် ယဇ်ပုရောဟိတ်ဂီးလေဟှာ လာဇရုဟှိုလည်း သတ်ဟှို့တွပ် ကြံစည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ယုဒလူဘောင်ဂီးဟှာ လာဇရုကြောန့် သူးနို့ဟှို ငြင်းပယ်ဘီး ယေရှုဟှို ယောင်ကြည်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","နော့‑က်နေ့မာ ပသခါပွဲတော်ဟှို လာဟှူ လူအောက်ဂီးဟှာ ယေရုရှလင်ဗြို့ဟှို ယေရှုကြွလာတော်မူကြောန်းဟှို ကြားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","အယ်ကြောန့် သူးနို့ဟှာ စွန်ပလွံခတ်လေဟှို ယူဘီး ကိုယ်တော့်ဟှို ကြိုဆိုဟှို့သွားဂေ့ဘီး “ဟောရှဏ္ဏ! ဘုရားသခင်ရဲ့ နာမန ကြွလာဟှူ သခင်ဟှာ မင်္ဂလာရှိတော်မူဟှယ်! ဣသရေလမန်းဂီးဟှာ မင်္ဂလာရှိတော်မူဟှယ်!” ဆိုဘီး ကြွေးကြော်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ယေရှုဟှာ မြည်းသားဂန်းဟှို တွိဟှားဘီး စီးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","အယ်မူဇာဟှ “ဇိအုန်ဗြို့ စိုးရိမ်န! နန်းနို့ရဲ့ မန်းဂီးဟှာ မြည်းသားဂန်းဟှားဟှို စီးဘီးဟှာ ကြွလာတော်မူဘီ” ဆိုဘီး ကျမ်းစာမာ အယ်မျိုး ပြောဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","တဗဲ့တော်လေဟှာ အယ်ခီဒူးဟှ အယ်ကျမ်းစာဟှို နားလည်ဂေ့ဟှ။ အယ်ဘေမဲ့ ယေရှုဟှာ ဖောင်းသရေတော်တွပ် ပ္လန်ရှင်လာဟှူ ခီမာ အယ်ကျမ်းစာဟှ ကိုယ်တော်ကြောန်းဟှို ရေးဟှားဇာဖြစ်ဟှယ် ဆိုဇာန ကိုယ်တော့်ဟှို အယ်မျိုး လောက်ဇာဖြစ်ဟှယ် ဆိုဇာလေဟှို ပ္လန်အော့‑က်မေ့လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ယေရှုနတူးဒူရှိနေဟှူ လူလေဟှာ လာဇရုဟှို သန်းခ္လိုင်းဂူဟှနေ ခေါ်ထုလိုက်ဘီး သေရာဟှနေ ပ္လန်ရှင်စေဟှူကြောန်းဟှို သတ်သေခံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ဖြားကြောန့်ဟှိ လူအောက်ဟှာ ကိုယ်တော့်ဟှို ကြိုဆိုဂေ့ဇာဟှာ သူးနို့ဟှာ အယ်မျိုး နိမိတ်လတ်ခဏာလေဟှို ပြတော်မူကြောန်းဟှို ကြားဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","အယ်ကြောန့် ဖာရိရှဲလေဟှာ “နို့လေဟှာ လောက်ဝ အောန်မြင်နိုင်ဟှ! ကေ့ကေ့။ တလောကလောင်းဟှာ အယ်လူနော့‑က်ဟှို လိုက်ဟှားဂေ့ဘီ!” ဆိုဘီး သူးနို့ရှင်းရှင်း ပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ပွဲတော်မာ ကိုးကွယ်ဟှို့တွပ် ယေရုရှလင်ဗြို့ဟှို ရော့‑က်လာဟှူ လူလေထဲမာ လူမျိုးခြားတချို့လည်းပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","သူးနို့ဟှာ ဂါလိလဲနယ် ဗက်ဇဲဒဗြို့သားဖြစ်ဟှူ ဖိလိပ္ပုနားဟှို သွားဘီး “ဆရာ၊ ကျွန်တော့်ဟှားလေ ယေရှုဟှို ဗြင်ရှင်ဟှယ်” ဆိုဘီး တောန်းလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ဖိလိပ္ပုဟှာ အန္ဒြေနားဟှို သွားပြောပြဘီးဟှာ သူးနို့နှေ့ယော့‑က်ဟှာ ယေရှုနားဟှို သွားဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ယေရှုဟှာ သူးနို့ဟှို “လူ့ရဲ့သားဟှာ ရရာတိုင်း ကီးမားဟှူ ဖောင်းသရေတော်ဟှို လတ်ခံဟှို့ ခီဟှာ ခုဘဲ့ရော့‑က်နေဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ဂျောင်စေ့တစေ့ဟှာ မ္လေဂီးထဲဟှို က္လဘီး ပျစ်စီးဟှ ဆိုဟှာ တစေ့ဒဲဘဲ ရှိနေလေ့မယ်။ အယ်စေ့ဟှာ ပျစ်စီးဟှားမယ် ဆိုဟှာ သီးလေ ဘောင်ဂီး ဖြစ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ကိုယ့်သတ်ဟှို ရှစ်ဟှူ လူလေဟှာ သတ်ဆောင်းရှောင်း လေ့မယ်။ အယ်လောကမာ ကိုယ့်သတ်ဟှို မူးဟှူ လူလေဟှာ ကိုယ့်သတ်ဟှို ထာဝရ စောန့်ရှော့‑က်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ငါ့မှုတော်ဟှို လောက်ဆောန်ဟှူ လူတိုင်းဟှာ ငါ့နော့‑က်ဟှို လိုက်ရမယ်။ အယ်ဆိုဟှာ ငါရှိဟှူ နေရာမာ ငါ့မှုဆောန်ဟှာ ငါ့နတူးဒူရှိ လေ့မယ်။ ငါ့ဖဟှလည်း ငါ့ရဲ့ မှုဆောန်ဟှို ချီးမြှော့‑က်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“ခု ငါ့ရဲ့ စိနှလောင်း ပူလောန်နေဟှယ်။ ငါ ဖယ်မျိုး ပြောရဟှို့နူး။ ငါဟှ ‘ဖ၊ ကျွန်တော်ထတ်ဟှို က္လရော့‑က်လာမယ့် အယ်ခီနာရီဟှနေ ကယ်မပါ’ ဆိုဘီး ပြောရဟှို့လော။ အယ်ဘေမဲ့ ငါဟှာ အယ်ဒေါက်ခဝေဒနာခံဟှို့တွပ်ဘဲ့ ရော့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ဖ၊ ဖရဲ့နာမတော်ဟှာ ဖောင်းသရေတော် ထန်ရှားစေတော်မူပါ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်ဘီးန ကောန်းဂန်ထတ်ဟှနေ သံတော်ဟှ “ငါဟှာ ဖောင်းသရေတော် ထန်ရှားစေပီးဘီ။ နော့‑က်တခါလည်း ထန်ရှားစေအူးမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","အယ်နေရာမာ ရပ်နေဂေ့ဟှူ လူအောက်ဟှာ သံတော်ဟှို ကြားလိုက်ရဘီး သူးနို့ထဲဟှ တချို့ဟှ မိုးကြိုးသံဖြစ်ဟှယ် ဆိုဘီး ပြောဂေ့ဟှယ်။ တချို့ဟှ “ကောန်းဂန်တမန်ဟှာ ကိုယ်တော့်ဟှို စကားပြောဟှယ်!” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","အယ်ဘေမဲ့ ယေရှုဟှာ သူးနို့ဟှို “အယ်သံတော်ဟှာ ငါ့တွပ် မှုဟှ။ နန်းနို့တွပ် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","အယ်လောကဟှာ ခုဘဲ့ တရားစီရင်ခံရမယ်။ အယ်လောကဟှို အောက်ချောက်မားဟှာ ခုဘဲ့ နှန်ထုဇာခံရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ငါဟှာ မ္လေဂီးဟှနေ မ္လော့‑က်ဟှားဇာဟှို ခံရဟှူ ခီမာ လူတိုင်းဟှို ငါနားဟှို ဆွဲခေါ်မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","အယ်မျိုးမိန့်တော်မူဇာဟှ ကိုယ်တော်ဟှာ ဖယ်မျိုးသေနည်းန သေခံတော်မူရမယ် ဆိုဇာဟှို ဖော်ပြဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","လူအောက်ဂီးဟှ “မေရှိယဟှာ ထာဝရသတ်ရှင်လေ့မယ် ဆိုဘီး ကျွန်တော့်ဟှားလေရဲ့ ပညတ်တော်မာ ပြောဟှားဟှယ်။ အယ်ဆိုဟှာ လူ့ရဲ့သားဟှာ မ္လေဂီးဟှနေ မ္လော့‑က်ဟှားခံရမယ် ဆိုဘီး ဖြားဖြစ်ကြောန့် ပြောနိုင်နူး။ အယ်လူ့ရဲ့သားဟှ ဖယ်လူနူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ယေရှုဟှ “လန်းရောန်ဟှာ နန်းနို့ထဲမာ ရှစ်ဟှားဘဲ့ ရှိနေလေ့မယ်။ အယ်ကြောန့် နန်းနို့ဟှို မှောန်ဖောင်းခန် လန်းရောန်ရှိနေဒူးမာ သွားလာဂေ့။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ မှောန်ထဲမာ သွားလာလူဟှာ ဖယ်နေရာဟှို သွားနေဟှယ် ဆိုဇာဟှို သိဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","အယ်မူကြောန့်ဟှိ လန်းရောန်ဟှာ နန်းနို့နရှိနေဒူးမာ လန်းရောန်ဟှို ယောင်ကြည်ဂေ့။ အယ်ဆိုဟှာ နန်းနို့ဟှာ လန်းရောန်ရဲ့ သားမီးလေ ဖြစ်လေ့မယ်” ဆိုဘီး ပ္လန်ဖြေတော်မူဟှယ်။ ယေရှုဟှာ အယ်မျိုးမိန့်တော်မူဘီးန ထွပ်ကြွဟှားဘီး သူးနို့ဟှို တီးရှောန်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ကိုယ်တော်ဟှာ သူးနို့မျစ်စိရှေ့မာ အယ်နိမိတ်လတ်ခဏာလေ ဂူလောင်းဟှို ပြဘေမဲ့ သူးနို့ဟှာ ကိုယ်တော့်ဟှို ယောင်ကြည်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","အယ်ကြောန့် “အို၊ ဘုရားသခင် ကျွန်တော့်ဟှားလေဟောပြောဟှူ အယ်ဒန်းကောန်းဟှို ဖယ်သူလေ ယောင်ကြည်ကြောန့်နူး။ သခင်ဘုရားရဲ့ တဂိုးတော်ဟှာ ဖယ်လူဟှို ထန်ရှားဟှို့နူး။” ဆိုဘီး ပရောဖက်ဟေရှာယ ဟောဟှားဇာဟှာ မှန်ဘဲ့ဖြစ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","အယ်ဘီးဟှာ သူးနို့လေ ယောင်ကြည်နိုင်ဘဲကြောန့် ဟေရှာယဟှ ");
INSERT INTO tvn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ဘုရားသခင်ဟှာ သူးနို့ရဲ့ မျစ်စိဟှို ကန်းစေဟှားဘီး သူးနို့ရဲ့ စိနှလောင်းဟှို ပိစေဟှားဟှယ်။ အယ်ကြောန့် သူးနို့ရဲ့ မျစ်စိဟှာ ဗြင်ဂေ့ဟှ။ အယ်ဘီးဟှာ သူးနို့ရဲ့ စိနှလောင်းဟှို မာကျောစေဟှယ်။ အယ်ဘီးဟှာ သူးနို့ဟှာ ငါ့နားဟှို ပ္လန်လာဂေ့ဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့ဟှာ ငါ့နားဟှို ပ္လန်လာမယ် ဆိုဟှာ နာပျော့‑က်လေ့မယ်” ဆိုဘီး ဘုရားသခင်ဟှ ပြောဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ဟေရှာယဟှာ ယေရှုရဲ့ ဖောင်းသရေတော်ဟှို ဗြင်ဟှားဟှူကြောန့် အယ်မျိုးပြောဆိုဘီး ကိုယ်တော်ကြောန်းဟှို ပြောနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ဖယ်မျိုးဘဲ့ဖြစ်ဖြစ် ယုဒအာဏာပိုင်လေ ဘောင်ဂီးဟှာ ယေရှုဟှို ယောင်ကြည်လာဂေ့ဟှယ်။ အယ်ဘေမဲ့ သူးနို့ဟှာ ဖာရိရှဲလေကြောန့် ဝါလယ်ဇရပ်ဟှနေ နှန်ထုခံရမာဟှို စိုးရိမ်ဘီး ပွမ့်ပွမ့်လန်းလန်းဟှား ပြောဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","သူးနို့ဟှာ ဘုရားသခင်ရဲ့ ချီးမွမ်းဇာထတ် လူလေရဲ့ ချီးမွမ်းဇာဟှို နှစ်သက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ယေရှုဟှာ “ငါ့ဟှို ယောင်ကြည်ဟှူလူဟှာ ငါ့ဟှိုဘဲ့ ယောင်ကြည်ဇာ မှုဟှ။ ငါ့ဟှို စေလွှတ်တော်မူဟှူ သခင်ဟှိုလည်း ယောင်ကြည်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ငါ့ဟှို ဗြင်ဟှူလူဟှာ ငါ့ဟှို စေလွှတ်တော်မူဟှူ သခင်ဟှိုလည်း ဗြင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ငါဟှာ လန်းရောန်ဖြစ်န လောကထဲဟှို ကြွလာဟှယ်။ အယ်ကြောန့် ငါ့ဟှို ယောင်ကြည်ဟှူ လူတိုင်းဟှာ မှောန်ထဲမာ နေရဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","လူလေဟှာ ငါ့ရဲ့စကားဟှို ကြားဘီး နာခံဟှ ဆိုဟှာ သူးနို့ဟှို ငါစီရင်လေ့မယ် မှုဟှ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါလာဇာဟှ အယ်လောကဟှို စီရင်ဟှို့လာဇာ မှုဟှ။ အယ်လောကဟှို ကယ်တန်ဟှို့လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ငါ့စကားဟှို လတ်ခံဘဲန ငြင်းပယ်ဟှူ လူလေဟှို စီရင်မယ့်သူရှိဟှယ်။ ငါပြောဟှူ စကားလေဟှဘဲ့ နော့‑က်ဆောင်းဟှူ နေ့မာ အယ်လူလေဟှို စီရင်လေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","အယ်စကားဟှာ သမ္မာတရား ဖြစ်ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါဟှာ ကိုယ်ပိုင် ခွမ့်အာဏာန ပြောနေဇာ မှုဟှ။ အယ်ဘေမဲ့ ငါ့ဟှို စေလွှတ်တော်မူဟှူ ဖဟှာ ဖယ်မျိုးပြောရမယ် ဆိုဇာဟှို ငါ့ဟှို ညွှန်ကြားတော်မူဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","အယ်ဘီးဟှာ ဖရဲ့မိန့်တော်ဟှာ ထာဝရသတ် ဖြစ်ဟှယ် ဆိုဇာဟှို ငါသိဟှယ်။ ငါပြောနေဇာလေဟှာ ဖဟှ ငါ့ဟှို စေခိုင်းတော်မူဟှားတိုင်း ငါဟောပြောဟှယ်” ဆိုဘီး သံက္လယ်ဂီးန မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ပသခါပွဲတော် လောက်ခန် တနေ့မာ ဖြစ်ဟှယ်။ ယေရှုဟှာ အယ်လောကဟှ ထွပ်ခွါဘီး ဖနားဟှို ကြွတော်မူဟှို့ခီ ရော့‑က်လာဘီ ဆိုဇာဟှို သိတော်မူဟှယ်။ ကိုယ်တော်ဟှာ အယ်လောကမာရှိနေဟှူ မိမိလူလေဟှို ရှစ်တော်မူဘီး ဆောင်းထိ ရှစ်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ယေရှုန တဗဲ့တော်လေဟှာ ညဉ့်ဇာစားနေဂေ့ဟှယ်။ မာရ်နတ်ဟှာ ရှိမုန်ရှကာရုတ်သား ယုဒရဲ့ စိနှလောင်းထဲမာ ကိုယ်တော့်ဟှို သစ်စာဖော့‑က်ဟှို့ ကြံစည်ဟှို ထဲ့ပေးဟှားပီးဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ဖဟှ သူ့ဟှို အာဏာလေ အားလောင်း ပေးဟှားဟှယ် ဆိုဇာဟှိုရော၊ ဘုရားသခင်နားဟှနေ ကြွလာတော်မူဟှယ် ဆိုဇာရော၊ ဘုရားသခင်နားဟှို ပ္လန်ကြွတော်မူရမယ် ဆိုဇာဟှိုရော ယေရှုဟှာ သိတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","အယ်ကြောန့် ကိုယ်တော်ဟှာ စားဗွဲဟှနေ ထတော်မူဘီး ပ္လန်ဝတ်ဟှို ခလွတ်တော်မူဘီး မျစ်နှာသုပိုင်းဟှို ကိုယ်တော်ရဲ့ခါးမာ ပတ်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","အယ်ဘီးန ကိုယ်တော်ဟှာ ရေအန်ဒုန်ထဲဟှို ရေလောန်းထဲ့ဘီး စဘီးဟှာ တဗဲ့တော်လေရဲ့ ခေဟှို ဆေးပေးဘီးဟှာ ခါးမာပတ်ဟှားဟှူ မျစ်နှာသုပိုင်းန သုတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ကိုယ်တော်ဟှာ ရှိမုန်ပေတရုနားဟှို ရော့‑က်ဟှူ ခီမာ ပေတရုဟှ “သခင်၊ ကိုယ်တော်ဟှ ကျွန်တော့်ခေဟှို ဆေးပေးဟှို့လော” ဆိုဘီး ကိုယ်တော့်ဟှို လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ယေရှုဟှာ သူ့ဟှို “ငါလောက်ဇာလေဟှို ခု နန်နားလည်ဟှို့ မှုဟှ။ အယ်ဘေမဲ့ နော့‑က်ဆိုဟှာ နားလည်လာလေ့မယ်” ဆိုဘီး ဖြေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ပေတရုဟှ “ကိုယ်တော်ဟှာ ကျွန်တော့်ရဲ့ ခေဟှို လောင်းဝ ဆေးပေးတော်မူန!” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ယေရှုဟှ “နန့်ရဲ့ခေဟှို ငါဆေးပေးရဘဲဟှ ဆိုဟှာ နန်ဟှာ ငါ့တဗဲ့တော် ဖြစ်ဟှို့ မှုဟှ” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ရှိမုန်ပေတရုဟှ “သခင်၊ အယ်မျိုးဆိုဟှာ ကျွန်တော့်ရဲ့ ခေဟှိုဘဲ့ဆေးန! ကျွန်တော့်ရဲ့လတ်လေန ခေါန်းဟှိုလည်း ဆေးပေးပါ!” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ယေရှုဟှ “ရေချိုးဘီးသားလူလေဟှာ တကိုယ်လောင်း စင်ကြယ်ဟှားဘီဖြစ်ဟှူကြောန့် သူးနို့ရဲ့ ခေဟှိုဘဲ့ ဆေးဟှို့လိုဟှယ်။ နန်းနို့ဂူလောင်းဟှာ စင်ကြယ်ဟှားဘီ။ အယ်ဘေမဲ့ တယော့‑က်ဘဲ့ စင်ကြယ်ဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ယေရှုဟှာ သူ့ဟှို သစ်စာဖော့‑က်မယ့်လူဟှို သိဟှားဘီးဟှူကြောန့် “နန်းနို့လေ ဂူလောင်းထဲမာ စင်ကြယ်ဘဲဟှူ လူတယော့‑က်ရှိနေဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ယေရှုဟှာ သူးနို့ရဲ့ ခေလေဟှို ဆေးပေးဘီးန ပ္လန်ဝတ်ဟှို ပ္လန်ဝတ်လိုက်ဘီး စားဗွဲမာ ပ္လန်ထိုင်တော်မူလေဟှယ်။ ကိုယ်တော်ဟှ “နန်းနို့ဟှို ငါပြုလောက်ဇာလေဟှို နားလည်ဂေ့ဘဲ့လော” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“နန်းနို့ဟှ ငါ့ဟှို သခင်ဆိုဘီးရော၊ ဆရာဆိုဘီးရော ခေါ်ဂေ့ဟှယ်။ ငါလည်း အယ်တိုင်းဘဲ့ဖြစ်ဟှူကြောန့် နန်းနို့ခေါ်ဇာဟှာ မှန်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","နန်းနို့ရဲ့ဆရာ၊ နန်းနို့ရဲ့သခင်ဖြစ်ဟှူ ငါဟှာ နန်းနို့ရဲ့ခေလေဟှို ဆေးပေးဟှယ်။ အယ်ဆိုဟှာ နန်းနို့လည်း ရှင်းရှင်းလေရဲ့ ခေဟှို ဆေးပေးရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","နန်းနို့ဟှို ငါပြုတော်မူမျိုးဘဲ့ နန်းနို့လည်းဘဲ့ အယ်မျိုးပြုလောက်ဟှို့ စံနမူနာဟှို ငါပြဟှားပီးဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ကျွန်ဟှာ သူးနို့သခင်ထတ် ကီးမြတ်ဟှ။ စေတမန်ဟှာ သူ့ဟှို စေလွှတ်သူထတ် ကီးမြတ်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","အယ်သမ္မာတရားဟှို နန်းနို့ ခု သိဟှားဘီ။ အယ်မူတိုင်းလောက်မယ် ဆိုဟှာ နန်းနို့ဟှာ ရရာတိုင်း ပျော်ရွှင်ရလေ့မယ်! ");
INSERT INTO tvn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“ငါဟှာ နန်းနို့လေ ဂူလောင်းဟှို ပြောဇာ မှုဟှ။ ငါဝီးကော့‑က်ဟှားဟှူ လူလေဟှို ငါသိဟှယ်။ အယ်ဘေမဲ့ ကျမ်းစာဟှ ‘ငါ့ရဲ့မုဟှို စားဟှူလူဟှာ ငါ့ဟှို ပ္လန်ဘီးဆန့်ကျင်လေဘီ’ ဆိုဘီး ပြောဟှားဇာဟှာ မှန်ဘဲ့ဖြစ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","အယ်ကြောန့် အယ်မူဇာလေ ဖြစ်လာခန်မာ ‘ငါဖြစ်မျိုးဘဲ့ ငါဖြစ်ဟှယ်’ ဆိုဇာဟှို နန်းနို့ဟှာ ယောင်ကြည်လာစေဟှို့ ခုဘဲ့ နန်းနို့ဟှို ငါပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ငါစေလွှတ်ဟှူ သူဟှို လတ်ခံဟှူ သူဟှာ ငါ့ဟှို လတ်ခံဟှယ်။ ငါ့ဟှို လတ်ခံဟှူ သူဟှာ ငါ့ဟှို စေလွှတ်လိုက်ဟှူ သူဟှိုလည်း လတ်ခံဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ယေရှုဟှာ အယ်မျိုးမိန့်တော်မူဘီးန ရရာတိုင်း စိပူဘန်ဟှားဘီး “နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ နန်းနို့ထဲဟှ တယော့‑က်ဟှာ ငါ့ဟှို သစ်စာဖော့‑က်လေ့မယ်” ဆိုဘီး ပွမ့်ပွမ့်လန်းလန်းဟှား သတ်သေခံဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ကိုယ်တော်ဟှာ ဖယ်လူကြောန်းဟှို ပြောနေဟှယ် ဆိုဇာဟှို တဗဲ့တော်လေဟှာ လောင်းဝ နားလည်ဂေ့ဘဲဟှူကြောန့် ယော့‑က်နယော့‑က် ကေ့နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ယေရှုရှစ်တော်မူဟှူ တဗဲ့တော်လေထဲဟှ တယော့‑က်ဟှာ ယေရှုဘေးမာ ထိုင်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ရှိမုန်ပေတရုဟှာ သူ့ဟှို “ကိုယ်တော်ဟှာ ဖယ်သူ့ကြောန်းဟှို ပြောနေဟှယ် ဆိုဇာဟှို မေးကေ့” ဆိုဘီး မျစ်ရိပြဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","အယ်ကြောန့် အယ်တဗဲ့တော်ဟှာ ယေရှုနားဟှို တိုးကပ်ဟှားဘီး “သခင်၊ အယ်လူဟှာ ဖယ်သူနူး” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ယေရှုဟှ “အယ်မုဟှို ဟန်းဇားထဲမာ နှစ်လိုက်ဘီး ငါပေးလိုက်ဟှူ လူဘဲ့ဖြစ်ဟှယ်” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ အယ်ကြောန့် ကိုယ်တော်ဟှာ မုတဖဲ့ဟှို ဟန်းဇားထဲမာ နှစ်လိုက်ဘီး ရှိမုန်ရှကာရုတ်ရဲ့သား ယုဒဟှို ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ယုဒဟှာ အယ်မုဟှို ယူဘီးန ရှင်းရှင်းဘဲ့ စာတန်ဟှာ သူ့ထဲဟှို ဝမ်လေဟှယ်။ ယေရှုဟှာ သူ့ဟှို “နန်လောက်ဇာရှိဇာဟှို ဗြန်းဗြန်ဟှားလောက်ပါ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ဖြားဖြစ်ကြောန့် ယေရှုဟှာ ယုဒဟှို အယ်မျိုးမိန့်တော်မူဟှယ် ဆိုဇာဟှို စားဗွဲမာ ထိုင်နေဟှူ လူယော့‑က်လည်း နားလည်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ယုဒဟှာ ကပ်အိကိုင်ရဟှူ သူဖြစ်ဟှူကြောန့် ယေရှုဟှ ပွဲတော်တွပ် လိုအပ်ဇာလေဟှို ဝယ်ခိုင်းလိုက်ဟှယ်။ အယ်မျိုးမှုဘဲနေဟှာ ဆင်းရဲသားလေဟှို တခုခုသွားပေးခိုင်းလိုက်ဟှယ် ဆိုဘီး တဗဲ့တော်တချို့ဟှာ ထန်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ယုဒဟှာ မုဟှို ခံယူဘီးန ရှစ်ရှင်းထွပ်ဟှားလေဟှယ်။ အယ်ခီဟှာ ညဉ့်ခန်းဖတ်ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ယုဒထွပ်ဟှားဘီးန ယေရှုဟှ “ခု လူ့ရဲ့သားဟှာ ဖောင်းသရေတော် ထန်ရှားတော်မူဘီ။ ခု ဘုရားသခင်ဟှာ လူ့ရဲ့သားအားဖြင့် ဖောင်းသရေတော် ထန်ရှားတော်မူဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ဘုရားသခင်ဟှာ လူ့ရဲ့သားအားဖြင့် ဖောင်းသရေတော် ထန်ရှားတော်မူဟှယ် ဆိုဟှာ ဘုရားသခင် ကိုယ်တိုင်အားဖြင့် လူ့ရဲ့သားဟှို ဖောင်းသရေတော် ထန်ရှားတော်မူဘီး အယ်ဖောင်းသရေတော်ဟှို ရှစ်ရှင်း ထန်ရှားတော်မူလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ရှစ်ရဟှူ သားမီးလေ၊ ငါဟှာ နန်းနို့နတူးဒူ ရှစ်ဟှားဘဲ့ နေရလေ့မယ်။ နန်းနို့ဟှာ ငါ့ဟှို လိုက်ရှာလေ့မယ်။ အယ်ဘေမဲ့ ယုဒအာဏာပိုင်လေဟှို ပြောဟှားမျိုးဘဲ့ ‘ငါသွားမယ့်နေရာဟှို နန်းနို့လာနိုင်ဂေ့ဟှ’ ဆိုဘီး နန်းနို့ဟှို ခု ငါပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ခု နန်းနို့ဟှို ငါပေးဟှူ ပညတ်တော်သစ်ဟှ ရှင်းရှင်းရှစ်ဂေ့။ နန်းနို့ဟှို ငါရှစ်မျိုးဘဲ့ ရှင်းရှင်းရှစ်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","နန်းနို့ရှင်းရှင်း ရှစ်ဂေ့မယ် ဆိုဟှာ နန်းနို့ဟှာ ငါ့တဗဲ့တော် ဖြစ်ဂေ့ဟှယ် ဆိုဇာဟှို လူတိုင်း သိဂေ့လေ့မယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ရှိမုန်ပေတရုဟှ “သခင်၊ ကိုယ်တော်ဟှ ဖယ်နေရာဟှို သွားဟှို့နူး” ဆိုဘီး ကိုယ်တော့်ဟှို မေးလျှော့‑က်လေဟှယ်။ ယေရှုဟှ “ငါသွားဟှို့နေရာဟှို ခု နန်လိုက်နိုင်ဟှို့ မှုဟှ။ အယ်ဘေမဲ့ နော့‑က်ဆိုဟှာ လိုက်ရလေ့မယ်” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ပေတရုဟှ “သခင်၊ ဖြားဖြစ်ကြောန့် ခုဟှ ကိုယ်တော်နော့‑က်ဟှို လိုက်နိုင်ရဟှနူး။ ကိုယ်တော်တွပ်ဆို ကျွန်တော့်သတ်ဟှို စွန့်ဟှို့ ဆင်သင့်ဘဲ့!” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ယေရှုဟှ “နန်ဟှ ငါ့တွပ် နန့်ရဲ့ သတ်ဟှို စွန့်ဟှို့ ဆင်သင့်ဘဲ့လော။ နန့်ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ကြစ်တွန်ခန်မာ နန်ဟှာ ငါ့ဟှို သိဟှ ဆိုဘီး သောင်းခါ ငြင်းပယ်လေ့မယ်” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ယေရှုဟှာ သူးနို့ဟှို “နန်းနို့လေ စိပူဂေ့န။ ဘုရားသခင်ဟှို ယောင်ကြည်ဂေ့။ ငါ့ဟှိုလည်း ယောင်ကြည်ပါ။ ");
INSERT INTO tvn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ငါ့ဖရဲ့ အီတော်မာ ခန်းလေ ဘောင်ဂီးရှိဟှယ်။ နန်းနို့တွပ် နေရာဟှို ပြင်ဆင်ဟှို့တွပ် ငါသွားရမယ်။ ခန်းလေမှေ့ဟှ ဆိုဟှာ နန်းနို့ဟှို အယ်မျိုး ပြောဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","နန်းနို့တွပ် နေရာဟှို သွားပြင်ဆင်ဘီးန ငါပ္လန်လာဘီး ငါရှိဟှူနေရာမာ နန်းနို့ရှိနေဟှို့တွပ် နန်းနို့ဟှို ငါနားဟှို ခေါ်ဆောန်မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ငါသွားမယ့်နေရာဟှို ရော့‑က်နိုင်ဟှူလမ်းဟှို နန်းနို့သိဂေ့ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","သောမဟှာ ကိုယ်တော့်ဟှို “သခင်၊ ကိုယ်တော်ဟှာ ဖယ်နေရာဟှို သွားမယ် ဆိုဇာ ကျွန်တော့်ဟှားလေ သိဂေ့ဟှ။ အယ်ဆိုဟှာ ကျွန်တော့်ဟှားလေဟှ အယ်နေရာဟှို ရော့‑က်နိုင်မယ့်လမ်းဟှို ဖယ်မျိုး သိနိုင်ဟှို့နူး” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ယေရှုဟှာ သူ့ဟှို “ငါဟှာ လမ်း၊ သမ္မာတရားန သတ်ဖြစ်ဟှယ်။ ငါ့အားဖြင့် မှုဟှ ဆိုဟှာ ဖယ်လူလည်း ဖနားဟှို သွားနိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ခု နန်းနို့ဟှာ ငါ့ဟှို သိဟှားဘီ။ အယ်ဆိုဟှာ နန်းနို့လေဟှာ ငါ့ဖဟှိုလည်း သိဂေ့လေ့မယ်။ ခုဟှစဘီး နန်းနို့ဟှာ ဖဟှို သိဗြင်ဂေ့ဘီ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ဖိလိပ္ပုဟှ ကိုယ်တော့်ဟှို “သခင်၊ ဖဟှို ကျွန်တော့်ဟှားလေဟှို ပြတော်မူပါ။ အယ်မူဇာဟှို ကျွန်တော့်ဟှားလေ အားလောင်း လိုရှင်ဂေ့ဟှယ်” ဆိုဘီး လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ယေရှုဟှ “ဖိလိပ္ပု၊ ငါဟှာ နန်းနို့လေ ဂူလောင်းနတူးဒူ ခီကြာဂီး ရှိနေဟှိုမှ ငါ့ဟှို သိဂေ့သေးဟှလော။ ငါ့ဟှို ဗြင်ဟှူလူဟှာ ငါ့ဖဟှို ဗြင်ရဟှယ်။ အယ်ဆိုဟှာ ‘ဖဟှို ကျွန်တော့်ဟှားလေဟှို ပြပါ’ ဆိုဘီး ဖြားဖြစ်ကြောန့် နန်းနို့ ပြောနေရနူး။ ");
INSERT INTO tvn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ဖိလိပ္ပု၊ ငါဟှာ ဖထဲမာရှိဘီး ဖဟှလည်း ငါထဲမာရှိဟှယ် ဆိုဇာဟှို နန်ယောင်ကြည်ဟှလော။ နန်းနို့ဟှို ငါပြောနေဟှူ စကားလေဟှာ ငါထဲဟှနေ ထွပ်လာဇာ မှုဟှ။ ငါ့ထဲမာရှိနေဟှူ ဖကိုယ်တိုင်ဟှ သူ့ရဲ့ မှုဟှို ပြုတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ငါဟှာ ဖထဲမာ ရှိနေဘီး ဖဟှလည်း ငါ့ထဲမာ ရှိနေဟှယ် ဆိုဘီး ပြောနေဟှူ ခီမာ ငါ့ဟှို ယောင်ကြည်ဂေ့။ ယောင်ကြည်ဘဲဟှ ဆိုဟှာ ငါလောက်နေဇာလေဟှို ယောင်ကြည်ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ငါ့ဟှို ယောင်ကြည်ဟှူ လူဟှာ ငါလောက်ဇာလေဟှို လောက်လေ့မယ်။ အယ်ထတ်ကီးဟှူ ဇာလေဟှိုလည်း လောက်လေ့မယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါဟှာ ဖနားဟှို သွားရဟှို့တွပ် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ဖရဲ့ ဖောင်းသရေတော်ဟှာ သားတော်အားဖြင့် ထန်ရှားဟှို့တွပ် ငါ့နာမန နန်းနို့တောန်းဇာမှန်မျှ ငါလောက်မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","နန်းနို့ဟှာ ငါ့နာမန တခုခုဟှို ငါ့နားမာ တောန်းမယ် ဆိုဟှာ အယ်တိုင်း ငါပြုမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“နန်းနို့ဟှာ ငါ့ဟှို ရှစ်ဟှယ် ဆိုဟှာ ငါ့ပညတ်တော်လေဟှို လိုက်နာဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ငါဟှာ ဖဟှို တောန်းလျှော့‑က် လိုက်ဟှူကြောန့် နန်းနို့နတူးဒူ ထာဝရနေထိုင်ဟှူ ကူညီမဇသူ တပါးဟှို ပေးတော်မူလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","သူဟှာ ဘုရားသခင်နဆိုင်ဟှူ သမ္မာတရားဟှို ဖွမ့်ပြပေးဟှူ ဝိညာဉ်တော်ဖြစ်ဟှယ်။ အယ်လောကဟှာ အယ်ဝိညာဉ်တော်ဟှို ဗြင်ဂေ့ဟှ။ သိဂေ့ဘဲဟှူကြောန့် အယ်ဝိညာဉ်တော်ဟှို လတ်ခံဂေ့ဟှ။ အယ်ဘေမဲ့ နန်းနို့ဟှာ အယ်ဝိညာဉ်တော်ဟှို သိဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူဟှာ နန်းနို့နတူးဒူး နေတော်မူနေဘီး နန်းနို့ထဲမာ ရှိနေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ငါဟှာ နန်းနို့ဂူလောင်းဟှို ခိုကိုးရာမဲ့ ထားရစ်ဇာ မှုဟှ။ ငါဟှာ နန်းနို့နားဟှို ပ္လန်လာရအူးမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ရှစ်ဟှားကြာဘီးဟှာ အယ်လောကဟှာ ငါ့ဟှို နော့‑က်တခါ ဗြင်ရလေ့ဟှို့မှုဘီ။ အယ်ဘေမဲ့ နန်းနို့ဟှာ ငါ့ဟှို ဗြင်ရလေ့မယ်။ ငါသတ်ရှင်ဟှူကြောန့် နန်းနို့လည်း သတ်ရှင်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","အယ်နေ့ရစ် ရော့‑က်လာဟှူ ခီမာ ငါဟှာ ဖထဲမာ ရှိနေဟှယ် ဆိုဇာဟှိုရော၊ နန်းနို့ဟှာ ငါ့ထဲမာ ရှိနေဟှယ် ဆိုဇာဟှိုရော၊ ငါဟှာ နန်းနို့ထဲမာ ရှိနေဟှယ် ဆိုဇာဟှိုရော နန်းနို့သိရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ငါ့ပညတ်တော်လေဟှို လတ်ခံဘီး လိုက်နာဟှူလူလေဟှာ ငါ့ဟှို ရှစ်ဟှူလူလေ ဖြစ်ဟှယ်။ ငါ့ဟှို ရှစ်ဟှူလူလေဟှို ငါ့ဖဟှလည်း ရှစ်တော်မူဟှယ်။ ငါဟှလည်း သူးနို့ဟှို ရှစ်ဟှူကြောန့် ငါကိုယ်တိုင် သူးနို့ဟှို ဖွမ့်ပြမယ်” ဆိုဘီး ဖြေတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ယုဒရှကာရုတ်မှုဘဲဟှူ ယုဒဟှ “သခင်၊ ကျွန်တော့်ဟှားလေဟှို ကိုယ်တော်ကိုယ်တိုင် ထန်ရှားတော်မူဘီးဟှာ လောကသားလေဟှို ထန်ရှားပြဘဲဇာဟှ ဖယ်မျိုးနူး” ဆိုဘီး မေးလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ယေရှုဟှာ “ငါ့ဟှို ရှစ်ဟှူလူလေဟှာ ငါ့သွန်သန်ဇာလေဟှို လိုက်နာလေ့မယ်။ ငါ့ဖဟှလည်း သူးနို့ဟှို ရှစ်လေ့မယ်။ ငါ့ဖန ငါဟှာ သူးနို့နားဟှို ကြွလာဘီး သူးနို့နတူးဒူ နေတော်မူမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ငါ့ဟှို ရှစ်ဘဲဟှူ လူလေဟှာ ငါ့သွန်သန်ဇာလေဟှို လိုက်နာဂေ့ မှုဟှ။ နန်းနို့ကြားရဟှူ သွန်သန်ဇာလေဟှာ ငါ့သွန်သန်ဇာလေ မှုဟှ။ အယ်ဘေမဲ့ ငါ့ဟှို စေလွှတ်တော်မူဟှူ ဖရဲ့ သွန်သန်ဇာလေဘဲ့ ဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“နန်းနို့နတူးဒူ ရှိနေဒူးမာ အယ်မူဇာဟှို ငါပြောဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ဖဟှာ ငါ့နာမကြောန့် စေလွှတ်ပေးမယ့် ကူညီမဇသူဖြစ်ဟှူ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှာ နန်းနို့ဟှို ဂူလောင်းဟှို သွန်သန်ပေးဘီးဟှာ ငါပြောဟှားဇာလေ ဂူလောင်းဟှို မှတ်မိလာအောန် လောက်ပေးလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ငြီသတ်မှုဟှို နန်းနို့နတူးဒူ ငါထားဟှားဘီ။ ငါ့ငြီသတ်မှုဟှိုလည်း နန်းနို့ဟှို ငါပေးဟှားဟှယ်။ လောကသားလေဟှို ပေးဟှားမျိုး ငါပေးဟှားဇာ မှုဟှ။ နန်းနို့လေ စိုးရိမ်ပူဘန်ဂေ့န။ ကြော့‑က်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘ငါ သွားလိုက်ဘေမဲ့ နန်းနို့နားဟှို ပ္လန်လာအူးမယ်’ ဆိုဘီး ငါပြောဟှားဇာဟှို နန်းနို့ကြားဟှားပီးဘီ။ နန်းနို့ဟှာ ငါ့ဟှို ရှစ်ဟှယ် ဆိုဟှာ ဖနားဟှို ငါသွားဟှူကြောန့် နန်းနို့ဝန်းသာရလေ့မယ်။ ဖြားဖြစ်ကြောန်ဆိုဟှာ ဖဟှာ ငါ့ထတ် ကီးမြတ်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","အယ်မူဇာလေဖြစ်လာဟှူ ခီမာ နန်းနို့ ယောင်ကြည်ဂေ့ဟှို့တွပ် အယ်မူဇာလေအားလောင်း ဖြစ်ခန်ဂဒဲဟှ နန်းနို့ဟှို ခု ငါပြောဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ငါဟှာ နန်းနို့ဟှို ဘောင်ဂီးပြောနိုင်ဟှို့မှုဘီ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ အယ်လောကဟှို အောက်ချောက်မားဟှာ လာနေဘီ။ သူဟှာ ငါထတ်မာ ဖြားခွမ့်အာဏာလည်း မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","အယ်ဘေမဲ့ ငါဟှာ ဖဟှို ရှစ်ဟှယ် ဆိုဇာဟှို အယ်လောကဟှို သိစေဟှို့တွပ် ဖပညတ်ဟှားတိုင်း ငါလောက်ဟှယ်။” “လာဂေ့။ အယ်နေရာဟှနေ နို့လေသွားဂေ့ဇို့” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ငါဟှာ စစ်မှန်ဟှူ စဗျစ်နွယ်ဗန် ဖြစ်ဟှယ်။ ငါ့ဖဟှာ ဥယျာဉ်မှူးဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ငါ့ထဲမာ သီးသီးဘဲဟှူ ခတ်လေဟှို ဖဟှာ ခွတ်ပစ်မယ်။ သီးသီးဟှူ ခတ်လေဟှိုလည်း ပိုဘီး သီးစေဟှို့တွပ် ရှင်းလန်းလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ငါဟောပြောဟှူ တရားစကားအားဖြင့် ခု နန်းနို့ဟှာ သန့်ရှင်းဟှားဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ငါ့နှိုက် ရှိနေဂေ့။ အယ်ဆိုဟှာ ငါဟှလည်း နန်းနို့ထဲမာ ရှိနေလေ့မယ်။ ခတ်ဟှာ သူ့ကိုယ်သူ သီးသီးနိုင်ဟှ။ စဗျစ်နွယ်ဗန်မာရှိနေမယ် ဆိုဟှာ အယ်ခတ်ဟှာ သီးသီးနိုင်ဟှယ်။ အယ်မျိုးဘဲ့ နန်းနို့ဟှာ ငါနှိုက်မှေ့ဟှ ဆိုဟှာ သီးသီးနိုင်ဂေ့ဟှ။” ");
INSERT INTO tvn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ငါဟှာ စဗျစ်နွယ်ဗန်ဖြစ်ဟှယ်။ နန်းနို့ဟှာ ခတ်လေဖြစ်ဟှယ်။ ငါ့နှိုက် နန်းနို့ရှိနေဘီး နန်းနို့နှိုက် ငါရှိနေမယ် ဆိုဟှာ နန်းနို့လေဟှာ သီးလေဘောင်ဂီး သီးဂေ့လေ့မယ်။ နန်းနို့ဟှာ ငါနှိုက်မှေ့ဟှ ဆိုဟှာ နန်းနို့ ဖြားဇာလည်း လောက်နိုင်ဂေ့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ငါ့နှိုက် မှေ့ဘဲ့ဟှူ လူလေဟှာ ပ္လန်ဟှို ပစ်လိုက်ဟှူ သစ်ခတ်ခြော့‑က်မျိုးဘဲ့ ဖြစ်ဟှယ်။ အယ်ခတ်ခြော့‑က်လေဟှို စုသီးဘီးဟှာ မီးထဲဟှို ပစ်ခ္လလိုက်ဟှူကြောန့် လောန်ကျွမ်းဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","နန်းနို့ဟှာ ငါ့နှိုက်ရှိနေဘီး ငါ့စကားတော်လေဟှာလည်း နန်းနို့နှိုက်ရှိနေမယ် ဆိုဟှာ နန်းနို့ တောန်းဇာဂူလောင်းဟှို ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","နန်းနို့ဟှာ သီးလေဘောင်ဂီးဟှို သီးဟှူအားဖြင့် ငါ့ဖရဲ့ ဖောင်းသရေတော်ဟှို ထန်ရှားစေဘီး အယ်နည်းလမ်းအားဖြင့် ငါ့တဗဲ့တော်လေ ဖြစ်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ဖဟှာ ငါ့ဟှို ရှစ်မျိုးဘဲ နန်းနို့ဟှိုလည်း ငါရှစ်ဟှယ်။ အယ်ကြောန့် ငါ့ရဲ့မြစ်တာထဲမာရှိဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ငါဟှာ ဖရဲ့ ပညတ်တော်လေဟှို လိုက်နာဘီး ဖရဲ့ မြစ်တာထဲမာရှိနေမျိုးဘဲ့ နန်းနို့ဟှာလည်း ငါ့ရဲ့ ပညတ်တော်လေဟှို လိုက်နာမယ် ဆိုဟှာ ငါ့ရဲ့ မြစ်တာထဲမာ ရှိလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“နန်းနို့ထဲမာ ငါ့ရဲ့ ဝန်းသာမှုလေ ရှိနေဘီး နန်းနို့ရဲ့ ဝန်းသာမှုလေ ပ္လဲ့ဇောင်လာဟှို့တွပ် အယ်မူဇာဟှို နန်းနို့ဟှို ငါပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ငါ့ပညတ်ဟှ နန်းနို့ဟှို ငါရှစ်မျိုးဘဲ နန်းနို့ရှင်းရှင်း ရှစ်ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","မိမိရဲ့ မိဆွေလေတွပ် နန်းနို့ရဲ့ သတ်ဟှို ပေးလိုက်ဇာဟှာ ကီးမားဆောင်းဟှူ မြစ်တာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","နန်းနို့ဟှာ ငါ့ပညတ်ဟှားဇာလေဟှို လောက်မယ် ဆိုဟှာ နန်းနို့ဟှာ ငါ့ရဲ့မိဆွေလေဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ငါဟှာ နန်းနို့ဟှို စေခံ ဆိုဘီး ခေါ်ဟှို့မှုဘီ။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ စေခံဟှာ သူးနို့သခင် လောက်ဇာလေဟှို သိရဂေ့ဟှ။ ငါ့ဖနားဟှနေ ကြားဟှားဇာလေ ဂူလောင်းဟှို နန်းနို့ဟှို ငါ့ပြောပြနေဟှူကြောန့် နန်းနို့ဟှို မိဆွေလေ ဆိုဘီး ငါခေါ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","နန်းနို့ဟှာ ငါ့ဟှို ဝီးကော့‑က်ဟှားဇာ မှုဟှ။ သွားဘီးဟှာ တည်မြဲဟှူသီးလေ ဘောင်ဂီးသီးဟှို့တွပ် နန်းနို့ဟှို ဝီးကော့‑က်ဘီး ခန့်အပ်ဟှားဟှယ်။ အယ်ကြောန့် ငါ့နာမအားဖြင့် နန်းနို့တောန်းဇာလေ ဂူလောင်းဟှို ဖဟှ ပေးတော်မူလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","အယ်ကြောန့်ဘဲ့ နန်းနို့ရှင်းရှင်း ရှစ်ဂေ့ ဆိုဘီး ငါပညတ်ဟှားဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“လောကသားလေဟှာ နန်းနို့ဟှို မူးတီးဂေ့မယ် ဆိုဟှာ နန်းနို့ဟှို မူးတီးခန်မာ ငါ့ဟှို ရင်ဦးဆောင်း မူးတီးဂေ့ဟှယ် ဆိုဇာဟှို သိမှတ်ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","နန်းနို့ဟှာ အယ်လောကနဆိုင်မယ် ဆိုဟှာ လောကသားလေဟှာ သူးနို့နဆိုင်ဟှူ နန်းနို့ဟှို ရှစ်လေ့မယ်။ အယ်ဘေမဲ့ ငါဟှာ နန်းနို့ဟှို အယ်လောကထဲဟှနေ ဝီးကော့‑က်ဟှားဟှူကြောန့် နန်းနို့ဟှာ အယ်လောကနဆိုင်ဟှ။ အယ်ကြောန့် လောကသားလေဟှာ နန်းနို့ဟှို မူးတီးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘ကျွန်လေဟှာ သူးနို့သခင်ထတ် ကီးမြတ်ဟှ’ ဆိုဘီး နန်းနို့ဟှို ငါပြောဟှားဇာလေဟှို မှတ်ဟှားဂေ့။ လူလေဟှာ ငါ့ဟှို ညှဉ်းဆဲဂေ့မယ် ဆိုဟှာ နန်းနို့ဟှိုလည်း ညှဉ်းဆဲဂေ့လေ့မယ်။ သူးနို့ဟှာ ငါ့ရဲ့သွန်သန်ချစ်ဟှို လိုက်နာမယ် ဆိုဟှာ နန်းနို့သွန်သန်ချစ်ဟှိုလည်း လိုက်နာဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","အယ်ဘေမဲ့ သူးနို့ဟှာ ငါ့ဟှို စေလွှတ်ဟှူသူဟှို သိဘဲဟှူတွပ် ငါ့နာမကြောန့် နန်းနို့ဟှို ညှဉ်းဆဲဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ငါဟှာ လာဘီး သူးနို့ဟှို ပြောဟှဆိုဟှာ သူးနို့မာ ပြစ် မှေ့ဟှ။ အယ်ဘေမဲ့ ခု သူးနို့ဟှာ သူးနို့ရဲ့ ပြစ်တွပ် ကြောန်းပြဇာမှေ့ဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ဖယ်လူဘဲ့ဖြစ်ဖြစ် ငါ့ဟှို မူးတီးမယ် ဆိုဟှာ ငါ့ဖဟှိုလည်း မူးတီးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ငါဟှာ တခြားလူလေ လောက်ဖူးဘဲဟှူဇာလေဟှို သူးနို့ရှေ့မာ ပြုလောက်ဟှ ဆိုဟှာ သူးနို့မာ ပြစ်ရှိလေ့မယ် မှုဟှ။ ခုဆိုဟှာ ငါပြုလောက်ဇာလေဟှို သူးနို့ဗြင်ဟှားဘီးဟှူကြောန့် ငါ့န ငါ့ဖဟှို မူးတီးဂေ့ဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","အယ်မျိုး ဖြစ်လာရဇာဟှ သူးနို့ရဲ့ ပညတ်တော်မာ ‘သူးနို့ဟှာ ကြောန်းပြချစ်မှေ့ဘဲန ငါ့ဟှို မူးတီးဂေ့ဟှယ်’ ” ဆိုဘီး ရေးဟှားဇာဟှာ ပ္လဲ့ဇောင်စေဟှို့ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ဖနားဟှနေ ကြွလာတော်မူဘီး ဘုရားသခင်န ဆိုင်ဟှူ သမ္မာတရားဟှို ဖွမ့်ပြပေးဟှို့တွပ် ကူညီမဇသူဖြစ်ဟှူ သန့်ရှင်းဟှူဝိညာဉ်တော် ကြွလာလေ့မယ်။ ငါ့ဖနားဟှနေ နန်းနို့နားဟှို သူ့ဟှို ငါစေလွှတ်ပေးလိုက်ဘီး သူဟှာ ငါ့ကြောန်းဟှို သတ်သေခံလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","နန်းနို့လည်းဘဲ့ ရင်ဂဒဲဟှ ငါ့နတူးဒူရှိနေဟှူကြောန့် ငါ့ကြောန်းဟှို သတ်သေခံလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“နန်းနို့ရဲ့ ယောင်ကြည်ရှင်း ပျစ်ပြားဘဲဟှို့တွပ် အယ်မူကြောန်းဟှို ငါပြောဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","နန်းနို့ဟှို ဝါလယ်ဇရပ်ဟှနေ နှန်ထုဂေ့လေ့မယ်။ နန်းနို့ဟှို သတ်ဟှူလူလေဟှ ဘုရားသခင်ဟှို ဝတ်ပြုဟှယ် ဆိုဘီး ထန်မှတ်ဟှူ ခီက္လရော့‑က်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","လူလေဟှာ ငါ့ဟှိုလည်း သိဂေ့ဟှ။ ဖဟှိုလည်း သိဂေ့ဘဲဟှူကြောန့် နန်းနို့ဟှို အယ်မူဇာလေဟှို လောက်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","အယ်ခီ ရော့‑က်လာဟှူ ခီမာ နန်းနို့ဟှို ငါပြောဟှားဘီးဇာဟှို နန်းနို့ပ္လန်ဘီး အော့‑က်မေ့စေဟှို့တွပ် ခု ငါပြောနေဟှယ်။” “ငါဟှာ နန်းနို့နတူးဒူ ရှိနေဟှူကြောန့် နန်းနို့ဟှို အယ်မူဇာလေဟှို ရင်းရင်ဒူးဟှ ငါပြောဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ခု ငါ့ဟှို စေလွှတ်သူနားဟှို ငါသွားဝေါ့မယ်။ အယ်ဘေမဲ့ ဖယ်နေရာဟှို သွားဟှို့နူး ဆိုဘီး နန်းနို့ထဲဟှ ယော့‑က်လည်း ငါ့ဟှို မေးဂေ့ဟှမ်းမား။ ");
INSERT INTO tvn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ခု နန်းနို့ဟှို အယ်မျိုး ပြောလိုက်ဟှူကြောန့် နန်းနို့ရဲ့ စိနှလောင်းထဲမာ ရရာတိုင်း ဝန်းနဲနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ ငါသွားလိုက်ဇာဟှာ နန်းနို့တွပ် ပိုဘီး ကောန်းဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါသွားဟှ ဆိုဟှာ ကူညီမဇသူဟှာ နန်းနို့နားဟှို ရော့‑က်လာဟှို့ မှုဟှ။ အယ်ဘေမဲ့ ငါသွားလိုက်မယ် ဆိုဟှာ အယ်သူဟှို နန်းနို့နားဟှို ငါစေလွှတ်မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ကူညီမဇသူ ရော့‑က်လာဟှူ ခီမာ လောကသားလေဟှို ပြစ်ကြောန်းဟှိုရော၊ ဖြောန့်မတ်ကြောန်းဟှိုရော၊ တရားစီရင်ကြောန်းလေဟှိုရော ဖော်ပြပေးလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","သူးနို့ဟှာ ငါ့ဟှို ယောင်ကြည်ဂေ့ဘဲဟှူကြောန့် သူးနို့ရဲ့ ပြစ်ဟှို ဖော်ပြမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ငါဟှာ ဖနားဟှို သွားရမယ်ဖြစ်ကြောန့် နန်းနို့ဟှာ ငါ့ဟှို ဗြင်ရဟှို့မှုဘီ။ အယ်ကြောန့် နန်းနို့ဟှို ဖြောန့်မတ်ကြောန်းဟှို ဖော်ပြမယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","အယ်လောကဟှို အောက်ချောက်မားဟှာ တရားစီရင်ဇာဟှို ခံရဘီဖြစ်ဟှူုကြောန့် သူးနို့ဟှို တရားစီရင်တော်မူကြောန်းဟှို ဖော်ပြမယ်။” ");
INSERT INTO tvn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“နန်းနို့ဟှို ပြောပြဟှို့ဇာလေ ဘောင်ဂီးရှိဘေမဲ့ ခု နန်းနို့ခံယူနိုင်ဂေ့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","အယ်ကြောန့် ဘုရားသခင်ကြောန်းနဆိုင်ဟှူ သမ္မာတရားဟှို လမ်းပြပေးမယ့် ဝိညာဉ်တော် ကြွလာဟှူ ခီမာ နန်းနို့ဟှို သမ္မာတရား ဂူလောင်းဟှို ဖွမ့်ပြတော်မူလေ့မယ်။ အယ်ဝိညာဉ်တော်ဟှာ သူ့ဆန္ဒတိုင်း ပြောနေဇာမှုဘဲ သူကြားရဇာလေဟှို ပြောပြဘီးဟှာ ဖြစ်လာဟှို့ ဇာလေဟှိုလည်း ပြောပြလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","သူဟှာ ငါပြောနေဇာလေဟှိုဘဲ့ နန်းနို့ဟှို ပြောပြပေးနေဟှူကြောန့် ငါ့ဖောင်းသရေတော်ဟှို ထန်ရှားစေလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ငါ့ဖမာ ရှိဇာလေ ဂူလောင်းဟှာ ငါ့ဇာလေဖြစ်ဟှယ်။ အယ်ကြောန့် ဝိညာဉ်တော်ဟှာ ငါပြောဟှားဟှူ စကားလေဟှို နန်းနို့ဟှို ပြောပြလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ခီနဲနဲကြာဘီးဟှာ နန်းနို့ဟှာ နော့‑က်ထပ် ငါ့ဟှို တွိရလေ့ဟှို့မှုဘီ။ အယ်ဘီးန ခီနဲနဲကြာဘီးဟှာ နန်းနို့ဟှာ ငါ့ဟှို ပ္လန်တွိရလေ့မယ်။” ");
INSERT INTO tvn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","တဗဲ့တော်တချို့ဟှာ “ခီနဲနဲကြာဘီးဟှာ နို့လေဟှာ ကိုယ်တော့်ဟှို တွိရဟှို့မှုဘီ။ အယ်ဘီးန ခီနဲနဲကြာဘီးဟှာ နို့လေဟှာ ကိုယ်တော့်ဟှို ပ္လန်တွိရလေ့မယ်။ ‘ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါဟှာ ဖနားဟှို သွားရအူးမယ်’ ဆိုဘီး နို့လေဟှို မိန့်တော်မူနေဇာဟှ ဖြားဓိပါယ်နူး ဆိုဘီး သူးနို့ရှင်းရှင်း မေးနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","အယ်ဆိုဟှာ ‘ခီနဲနဲကြာဘီးဟှာ’ ဆိုဇာဟှ ဖြားဓိပါယ်နူး။ ကိုယ်တော် မိန့်တော်မူနေဇာလေဟှို နို့လေလည်း နားလည်ဂေ့ဟှ!” ");
INSERT INTO tvn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","သူးနို့လေဟှာ ကိုယ်တော့်ဟှို မေးလျှော့‑က်ရှင်ဂေ့ဟှယ် ဆိုဇာဟှို ယေရှုဟှ သိနေတော်မူဟှူကြောန့် “‘ခီနဲနဲကြာဘီးဟှာ နန်းနို့ဟှာ ငါ့ဟှို တွိဟှို့ မှုဟှ။ အယ်ဘီးန ခီနဲနဲကြာဘီးဟှာ နန်းနို့ဟှာ ငါ့ဟှို ပ္လန်တွိရလေ့မယ်’ ဆိုဘီး ငါပြောဟှားဟှယ်။ အယ်မူကြောန်းဟှို နန်းနို့ရှင်းရှင်း မေးမြန်းနေဂေ့ဟှယ်လော။ ");
INSERT INTO tvn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ နန်းနို့ဟှာ ငိုကြွေးရဂေ့လေ့မယ်။ အယ်ဘေမဲ့ အယ်လောကဟှာ ဝန်းသာဂေ့လေ့မယ်။ နန်းနို့ဟှာ ဝန်းနဲရဂေ့ဘေမဲ့ နန်းနို့ရဲ့ ဝန်းနဲမှုဟှာ ဝန်းသာမှုဟှို ပ္လောန်းလဲဟှားလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","မီးမတယော့‑က်ဟှာ သားမွီးခါနီးမာ မွီးဟှို့ခီ ရော့‑က်လာဟှူကြောန့် ဝန်းနဲမှုရှိဟှယ်။ အယ်ဘေမဲ့ သားမွီးဘီးဟှူ ခီမာ အယ်လောကမာ သားဂန်းတယော့‑က် မွီးဟှားပီးဘီတွပ် ဝန်းသာဟှားဟှူကြောန့် ဝေဒနာဟှို မေ့ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ခု နန်းနို့ဟှာ ဝန်းနဲနေဂေ့ဟှယ်။ အယ်ဘေမဲ့ ငါဟှာ နန်းနို့န ပ္လန်တွိရမယ် ဖြစ်ဟှူကြောန့် နန်းနို့ရဲ့ စိနှလောင်းဟှာ ဝန်းသာဂေ့လေ့မယ်။ အယ်ဝန်းသာမှုဟှို ဖယ်သူလည်း နန်းနို့နားဟှနေ လုယူနိုင်ဂေ့ဟှ။” ");
INSERT INTO tvn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“အယ်မူနေ့ရော့‑က်လာခီမာ နန်းနို့ဟှာ ငါ့ဟှို ဖြားဇာလည်း မေးဂေ့လေ့မယ် မှုဟှ။ နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ နန်းနို့ဟှာ ငါ့နာမအားဖြင့် တောန်းဇာဂူလောင်းဟှို ဖဟှ ပေးတော်မူလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ခုထိ ငါ့နာမအားဖြင့် နန်းနို့ဟှာ ဖြားဇာလည်း တောန်းဂေ့သေးဟှ။ နန်းနို့ရဲ့ ဝန်းသာဇာန ပ္လဲ့ဝဟှို့တွပ် တောန်းဂေ့။ တောန်းမယ် ဆိုဟှာ ရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“အယ်မူဇာလေဟှို ပေါင်ဥပမာသောင်းပြုဘီး နန်းနို့ဟှို ငါပြောဟှားဟှယ်။ အယ်ဘေမဲ့ ပေါင်ဥပမာဟှို သောင်းပြုဘဲန ဖရဲ့ ကြောန်းဟှို ပွမ့်ပွမ့်လန်းလန်းဟှား ပြောရဟှို့ ခီရော့‑က်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","အယ်မူနေ့ ရော့‑က်လာဟှူ ခီမာ နန်းနို့ဟှာ ငါ့နာမအားဖြင့် တောန်းလျှော့‑က်ရလေ့မယ်။ နန်းနို့တွပ် ဖနားဟှနေ ငါဟှ တောန်းလျှော့‑က်ပေးမယ် ဆိုဘီး ပြောနေဇာ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဖကိုယ်တိုင်ဟှ နန်းနို့ဟှို ရှစ်တော်မူဟှယ်။ ငါဟှာ ဖနားဟှနေ ကြွလာဟှယ် ဆိုဇာဟှို နန်းနို့ယောင်ကြည်ဟှူကြောန့် ဖဟှာ နန်းနို့ဟှို ရှစ်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ငါဟှာ ဖနားဟှနေ ထွပ်လာဘီး အယ်လောကထဲဟှို ကြွလာဟှယ်။ ခု ငါဟှာ အယ်လောကဟှနေ ထွပ်ဟှားဘီးဟှာ ဖနားဟှို သွားအူးမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","အယ်ဘီးန တဗဲ့တော်လေဟှာ ကိုယ်တော့်ဟှို “ခု ကိုယ်တော်ဟှာ ပေါင်ဥပမာဟှို သောင်းပြုဘဲန ပွမ့်ပွမ့်လန်းလန်းဟှား ဟောပြောတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ကိုယ်တော်ဟှာ ဂူလောင်းဟှို သိတော်မူဘီး ဖယ်လူလည်း ကိုယ်တော့်ဟှို မေးလျှော့‑က်ဟှို့လိုအပ်ဟှ ဆိုဇာဟှို ခု ကျွန်တော့်ဟှားလေ သိရဂေ့ဘီ။ အယ်ကြောန့် ကိုယ်တော်ဟှာ ဘုရားသခင်နားဟှနေ ကြွလာတော်မူဟှယ် ဆိုဇာဟှို ကျွန်တော့်ဟှားလေ ယောင်ကြည်ပါဟှယ်” ဆိုဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ယေရှုဟှာ သူးနို့ဟှို “ခု နန်းနို့ဟှ ယောင်ကြည်ဂေ့ဘဲ့လော။ ");
INSERT INTO tvn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","နန်းနို့ဟှာ ဖ္လဲဖ္လဲစင်ဖြစ်ဟှားဘီး နန်းနို့အီဟှို ပ္လန်ဟှားဂေ့ဟှူ ခီမာ ငါ့ဟှို တယော့‑က်ဒဲ ထားရစ်ဟှို့ ခီဟှာလည်း ခုဘဲ့ ရော့‑က်နေဘီ။ အယ်ဘေမဲ့ ဖဟှာ ငါ့နတူးဒူရှိနေတော်မူဟှူကြောန့် ငါဟှာ တယော့‑က်ဒဲ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","နန်းနို့ဟှာ ငါ့အားဖြင့် ငြီသတ်မှုရှိဟှို့တွပ် အယ်စကားဟှို ငါပြောပီးဘီ။ နန်းနို့ဟှာ အယ်လောကမာ ဆင်းရဲဒေါက်ခ ခံရဂေ့လေ့မယ်။ အယ်ဘေမဲ့ ကြော့‑က်ဂေ့န! ငါဟှာ လောကဟှို အောန်ဟှားပီးဘီ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ယေရှုဟှာ အယ်မျိုး မိန့်တော်မူဘီးန ကောန်းဂန်ဟှို မော့ကေ့ဘီးဟှာ “ဖ၊ ခီရော့‑က်ဟှားဘီ။ သားတော်ဟှာ ဖရဲ့ ဖောင်းသရေတော်ဟှို ထန်ရှားစေဟှို့တွပ် သားတော်ရဲ့ ဖောင်းသရေတော်ဟှို ထန်ရှားစေတော်မူပါ။ ");
INSERT INTO tvn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ဖဟှ သားတော်ဟှို လူလေ ဂူလောင်းဟှို အောက်စိုးရဟှူ ခွမ့်အာဏာဟှို ပေးတော်မူဟှယ်။ အယ်ကြောန့် သားတော်ဟှာ ဖဟှနေ ပေးဟှားဟှူ လူလေ ဂူလောင်းဟှို ထာဝရသတ် ပေးနိုင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ထာဝရသတ် ဆိုဇာဟှာ စစ်မှန်ဟှူ ဘုရားသခင် တဆူဒဲရှိဟှယ် ဆိုဇာန စေလွှတ်တော်မူဟှူ ယေရှုခရစ်တော်ဟှို သိဟှို့ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ကိုယ်တော် အပ်ပေးတော်မူဟှူ မှုတော်ဟှို ကျွန်တော်ဟှာ ဆောန်ရွက်ပီးဟှားဘီ ဖြစ်ဟှူကြောန့် ကိုယ်တော်ရဲ့ ဖောင်းသရေတော်ဟှို မ္လေဂီးထတ်မာ ထန်ရှားစေဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ဖ! အယ်လောကဟှို ဖန်ဆင်းခန်ဂဒဲဟှ ကိုယ်တော်နတူးဒူ ကျွန်တော်ခံစားရဟှူ ဖောင်းသရေတော်ဟှို ခု ကိုယ်တော့်ရှေ့တော်မာ ကျွန်တော့်ဟှို ပေးတော်မူပါ။ ");
INSERT INTO tvn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“အယ်လောကထဲဟှနေ ဝီးကော့‑က်ဘီး ကျွန်တော့်ဟှို အပ်ပေးတော်မူဟှူ လူလေဟှို ကိုယ်တော်ရဲ့ နာမဟှို ထန်ရှားစေပီးဘီ။ သူးနို့ဟှို ကိုယ်တော်ဟှ ပိုင်တော်မူဘီး ကျွန်တော့်ဟှို အပ်ပေးတော်မူဘီ။ သူးနို့ဟှာ ကိုယ်တော်ရဲ့ စကားတော်ဟှို လိုက်နာဂေ့ဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ကျွန်တော့်ဟှို ကိုယ်တော်ပေးဟှားဇာလေ ဂူလောင်းဟှာ ကိုယ်တော်နားဟှ ရရှိလာဟှယ် ဆိုဇာဟှို ခု သူးနို့သိရှိဂေ့ဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ကျွန်တော့်ဟှို ကိုယ်တော် ပေးအပ်တော်မူဟှူ စကားတော်ဟှို ကျွန်တော်ဟှာ သူးနို့ဟှို ပေးဟှူ ခီမာ သူးနို့လတ်ခံဂေ့ဟှယ်။ ကိုယ်တော်နားဟှနေ ကျွန်တော်ကြွလာဟှယ် ဆိုဇာဟှို သူးနို့ဟှာ မှန်ဘဲ့သိဂေ့ဟှယ်။ ကျွန်တော့်ဟှို ကိုယ်တော်စေလွှတ်ဟှယ် ဆိုဇာဟှိုလည်း သူးနို့ဟှာ ယောင်ကြည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“သူးနို့တွပ် ကျွန်တော် ဆုတောန်းဟှယ်။ ကျွန်တော်ဟှို ကိုယ်တော် ပေးအပ်တော်မူဟှူ လူလေဟှာ ကိုယ်တော်ပိုင်တော်မူဟှူ လူလေဖြစ်ဟှူကြောန့် အယ်လောကတွပ် မှုဘဲ သူးနို့တွပ်ဘဲ့ တောန်းလျှော့‑က်ပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ကျွန်တော့်မာရှိဟှူဇာလေ ဂူလောင်းဟှာ ကိုယ်တော်ဇာလေဖြစ်ဘီး ကိုယ်တော်မာ ရှိဟှူဇာလေ ဂူလောင်းဟှာလည်း ကျွန်တော့်ဇာလေဖြစ်ဟှူကြောန့် သူးနို့လေအားဖြင့် ကျွန်တော့်ဖောင်းသရေတော်ဟှို ထန်ရှားစေဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ကျွန်တော်ဟှာ အယ်လောကမာ ခီကြာဂီးရှိဟှို့ မှုဟှ။ အယ်ဘေမဲ့ သူးနို့ဟှာ အယ်လောကမာ ရှိဂေ့ဟှယ်။ ခု ကျွန်တော်ဟှာ ကိုယ်တော်နားဟှို လာပါဟှယ်။ သန့်ရှင်းတော်မူဟှူဖ! ကိုယ်တော်န ကျွန်တော်ဟှာ တလောင်းတဝဒဲ ဖြစ်မျိုးဘဲ့ ကျွန်တော့်ဟှို ပေးအပ်တော်မူဟှူ လူလေလည်း တလောင်းတဝဒဲ ဖြစ်ဟှို့တွပ် သူးနို့ဟှို ကိုယ်တော်ရဲ့ နာမတော်န တဂိုးတော်အားဖြင့် ကာကွယ်ပေးတော်မူပါ။ ");
INSERT INTO tvn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ကျွန်တော်ဟှာ သူးနို့နတူးဒူရှိနေဒူးမာ ကိုယ်တော်ပေးတော်မူဟှူ နာမတော်ထဲမာ သူးနို့ဟှို ပျစ်စီးမှုဟှနေ စောန့်ထီးတော်မူဘီ။ ကျွန်တော်ဟှာ သူးနို့ဟှို ကာကွယ်ပေးတော်မူဟှားဘီ။ ပျစ်စီးရဟှို့ လူတယော့‑က်ဟှလွဲဘီး သူးနို့ထဲဟှ ဖယ်လူလည်း ပျစ်စီးဂေ့ဟှ။ အယ်လူပျစ်စီးဟှားရဇာဟှာ ကျမ်းစာ ပ္လဲ့ဇောင်ဟှို့ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ခု ကိုယ်တော်နားဟှို ကျွန်တော်ဟှာ လာပါဟှယ်။ သူးနို့ဟှာ ကျွန်တော့်ရဲ့ ဝန်းသာမှုဟှို သူးနို့ရဲ့ စိနှလောင်းထဲမာ ပ္လဲ့ဝခံစားရဟှို့တွပ် အယ်လောကထဲ ရှိနေဒူးခီမာ အယ်မူဇာလေဟှို ကျွန်တော် ပြောပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ကျွန်တော်ဟှာ ကိုယ်တော်ရဲ့ တရားစကားဟှို သူးနို့ဟှို ပေးဟှားပီးဘီ။ ကျွန်တော်ဟှာ အယ်လောကနဆိုင်ဘဲမျိုး သူးနို့လည်း အယ်လောကနဆိုင်ဘဲဟှူကြောန့် လောကဟှာ သူးနို့ဟှို မူးတီးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","သူးနို့ဟှို အယ်လောကဟှနေ နုယူတော်မူဟှို့မှုဘဲန နတ်ဆိုးရဲ့လှည့်ဇားမှုဟှနေ ကွယ်ကာပေးဟှို့ ကျွန်တော်တောန်းလျှော့‑က်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ကျွန်တော်ဟှာ အယ်လောကနဆိုင်ဘဲမျိုး သူးနို့ဟှာလည်း အယ်လောကနဆိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","သမ္မာတရားအားဖြင့် သူးနို့ဟှို သန့်ရှင်းတော်မူပါ။ ကိုယ်တော်ရဲ့ စကားတော်ဟှာ သမ္မာတရားဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ကိုယ်တော်ဟှာ ကျွန်တော်ဟှို အယ်လောကထဲဟှို စေလွှတ်မျိုးဘဲ့ ကျွန်တော်ဟှာလည်း သူးနို့ဟှို အယ်လောကထဲဟှို စေလွှတ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","သူးနို့ဟှာလည်း သမ္မာတရားအားဖြင့် သန့်ရှင်းခံရဟှို့တွပ် ကျွန်တော်ဟှာ သူးနို့တွပ် ကိုယ့်ကိုယ်ကိုယ် သန့်ရှင်းစေပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ကျွန်တော်ဟှာ သူးနို့တွပ်ဘဲ့မှုဘဲန သူးနို့ဟောပြောဟှူ တရားစကားအားဖြင့် ကျွန်တော့်ဟှို ယောင်ကြည်ဟှူ လူလေတွပ်လည်း တောန်းလျှော့‑က်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","သူးနို့လေ ဂူလောင်းဟှာ တလောင်းတဝဒဲ ဖြစ်စေဟှို့ ကျွန်တော်ဆုတောန်းဟှယ်။ ဖ! ကိုယ်တော်ဟှာ ကျွန်တော့်ထဲမာရှိဘီး ကျွန်တော်ဟှာလည်း ကိုယ်တော်ထဲမာ ရှိနေမျိုးဘဲ့ သူးနို့ဟှိုလည်း ကျွန်တော့်ဟှားလေထဲမာ ရှိတော်မူစေပါ။ ကျွန်တော့်ဟှို ကိုယ်တော်စေလွှတ်တော်မူဟှယ် ဆိုဇာဟှို လောကသားလေ ယောင်ကြည်လာစေဟှို့တွပ် သူးနို့ဟှို တလောင်းတဝဒဲ ဖြစ်စေတော်မူပါ။ ");
INSERT INTO tvn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ကိုယ်တော်န ကျွန်တော်ဟှာ တလောင်းတဝဒဲ ဖြစ်မျိုးဘဲ့ သူးနို့ဟှိုလည်း တလောင်းတဝဒဲ ဖြစ်စေဟှို့တွပ် ကျွန်တော်ဟှို ကိုယ်တော်ပေးတော်မူဟှူ ဖောင်းသရေတော်ဟှို သူးနို့ဟှိုလည်း ပေးတော်မူဘီ။ ");
INSERT INTO tvn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ကျွန်တော်ဟှာ သူးနို့ထဲမာရှိဘီး ကိုယ်တော်ဟှာ ကျွန်တော်ထဲမာ ရှိပါဟှယ်။ သူးနို့ဟှို တလောင်းတဝဒဲ ပ္လဲ့ဇောင်စေဟှို့တွပ် ကိုယ်တော်ဟှာ ကျွန်တော့်ဟှို စေလွှတ်တော်မူကြောန်းန ကျွန်တော့်ဟှို ရှစ်မျိုးဘဲ့ သူးနို့ဟှိုလည်း ရှစ်တော်မူကြောန်းဟှို လောကသားလေဟှာ သိရှိစေဟှို့ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ဖ! အယ်လောကဟှို ဖန်ဆင်းခန်ဂဒဲဟှ ကိုယ်တော်ဟှာ ကျွန်တော်ဟှို ရှစ်တော်မူဘီး ပေးတော်မူဟှူ ဖောင်းသရေတော်ဟှို ကျွန်တော့်ဟှို ကိုယ်တော် ပေးအပ်တော်မူဟှူ လူလေဟှို ဗြင်တွိစေဟှို့တွပ် သူးနို့ဟှို ကျွန်တော်ရှိဟှူ နေရာမာ ကျွန်တော့်နတူးဒူ ရှိစေရှင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ဖြောန့်မတ်တော်မူဟှူဖ! အယ်လောကဟှာ ကိုယ်တော့်ဟှို သိဂေ့ဟှ။ အယ်ဘေမဲ့ ကျွန်တော်ဟှာ ကိုယ်တော့်ဟှို သိဟှယ်။ ကိုယ်တော်ဟှာ ကျွန်တော့်ဟှို စေလွှတ်တော်မူဟှယ် ဆိုဇာဟှို အယ်လူလေဟှာ သိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ကျွန်တော့်ဟှို ကိုယ်တော် ရှစ်ဟှူမြစ်တာဟှာ သူးနို့နှိုက်ရှိစေဘီး ကျွန်တော်ဟှာလည်း သူးနို့နှိုက်ရှိနေဟှူကြောန့် ကိုယ်တော့်နာမဟှို သူးနို့ဟှို ကျွန်တော်သိစေပါဘီ။ ထပ်ဘီးလည်း သိစေအူးမယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ယေရှုဟှာ အယ်မျိုးဆုတောန်းဘီးန တဗဲ့တော်လေနတူးဒူ ကြွဟှားတော်မူဘီး ကေဒြုန်ခ္လောန်းဟှို ကူးတော်မူဟှယ်။ အယ်နေရာမာ ဥယျာဉ်တခုရှိဘီး ယေရှုန တဗဲ့တော်လေဟှာ အယ်ဥယျာဉ်ထဲဟှို ဝမ်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ယေရှုဟှာ အယ်နေရာမာ တဗဲ့တော်လေန ခါဘီးခါ တွိဆောင်လေ့ရှိဟှူကြောန့် ကိုယ်တော့်ဟှို သစ်စာဖော့‑က်ဟှူ ယုဒရှကာရုတ်ဟှာ အယ်နေရာဟှို သိနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","အယ်ကြောန့် ယုဒဟှာ ရောမစစ်သားတစု၊ ယဇ်ပုရောဟိတ်ဂီးလေန ဖာရိရှဲလေ စေလွှတ်လိုက်ဟှူ ဗိမာန်တော်စောန့်လေဟှို ခေါ်ဟှားဘီး ဥယျာဉ်ဟှို သွားဂေ့ဟှယ်။ သူးနို့ဟှာ မီးအီလေ၊ မီးဒေါက်လေန လတ်နတ်လေဟှို ကိုင်ဆောန်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ယေရှုဟှာ သူနှိုက်ဖြစ်ပျစ်လာဟှို့ ဇာလေဂူလောင်းဟှို သိတော်မူဟှူကြောန့် သူးနို့နားဟှို ကြွတော်မူဘီး “နန်းနို့ ဖယ်လူဟှို ရှာဂေ့နေနူး” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","သူးနို့ဟှ “နာဇရက်ဗြို့သား ယေရှုဟှို ရှာနေဟှယ်” ဆိုဘီး ဖြေလိုက်ဟှယ်။ ကိုယ်တော်ဟှ “ငါဘဲ့ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလိုက်ဟှယ်။ ကိုယ်တော့်ဟှို သစ်စာဖော့‑က်ဟှူ ယုဒဟှာ သူးနို့နတူးဒူ ရပ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ယေရှုဟှာ သူးနို့ဟှို “ငါဘဲ့ဖြစ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလိုက်ဟှူ ခီမာ သူးနို့ဟှာ နော့‑က်ဆုဟှားဘီး မ္လေဂီးထတ်ဟှို လဲက္လဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ယေရှုဟှာ သူးနို့ဟှို “နန်းနို့ ဖယ်လူဟှို ရှာနေနူး” ဆိုဘီး နော့‑က်တခါ မေးတော်မူလေဟှယ်။ သူးနို့ဟှ “နာဇရက်ဗြို့သား ယေရှုဟှို ရှာဟှယ်” ဆိုဘီး ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ယေရှုဟှ “ငါဘဲ့ဖြစ်ဟှယ် ဆိုဘီး နန်းနို့ဟှို ငါပြောဟှားပီးဘီ။ နန်းနို့ဟှာ ငါ့ဟှို ရှာနေဟှယ် ဆိုဟှာ အယ်လူလေဟှို သွားခိုင်းလိုက်ပါ” ဆိုဘီး မိန့်တော်မူလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","အယ်မျိုး မိန့်တော်မူဇာဟှ “ဖ၊ ကိုယ်တော်ပေးအပ်ဟှားဟှူ လူလေဟှာ တယော့‑က်လည်း ပျစ်စီးဟှို့မှေ့ဟှ” ဆိုဘီး ကိုယ်တော် မိန့်တော်မူဟှားဇာလေဟှာ မှန်ဘဲ့ဖြစ်လာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","အယ်ခီမာ ရှိမုန်ပေတရုဟှာ ပါလာဟှူ ထားဟှို ဆွဲထုလိုက်ဘီး ယဇ်ပုရောဟိတ်မန်းရဲ့ ကျွန်ဟှို ခွတ်လိုက်ဟှူ ခီမာ ညာဖတ်နားဝှပ် ပြတ်ဟှားလေဟှယ်။ အယ်ကျွန်ရဲ့ နာမယ်ဟှာ မာလခု ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ယေရှုဟှာ ပေတရုဟှို “နန့်ထားဟှို ထားအီထဲမာ ပ္လန်သီးလိုက်ပါ! ငါ့ဖပေးတော်မူဟှူ ဒေါက်ခဝေဒနာခွပ်ဟှို ငါသော့‑က်ဘဲနေရဟှို့လော” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","အယ်ဘီးန ရောမစစ်သားလေ၊ သူးနို့ရဲ့ တပ်မှူးဂီးန ယုဒလူ စောန့်တပ်သားလေဟှာ ယေရှုဟှို ဖမ်းဆီးဘီး၊ တောက်နှောန်ဂေ့ဘီး ");
INSERT INTO tvn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","အန္နတ်နားဟှို ရင်ဦးဆောင်း ခေါ်ဆောန်ဟှားဟှယ်။ အန္နတ်ဟှာ အယ်နှစ်မာ ယဇ်ပုရောဟိတ်မန်းဖြစ်ဟှူ ကယာဖရဲ့ ယော့‑က်ခမဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","အယ်ကယာဖဟှာ လူလေ ဂူလောင်းတွပ် လူတယော့‑က် သေရဇာဟှ ပိုကောန်းဟှယ် ဆိုဘီး ယုဒအာဏာပိုင်လေဟှို ကြံပေးဟှူ သူဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ရှိမုန်ပေတရုန တခြားတဗဲ့တော်ဟှာ ယေရှုနော့‑က်တော်လိုက်ဟှားဟှယ်။ အယ်တဗဲ့တော်ဟှာ ယဇ်ပုရောဟိတ်မန်းရဲ့ သိဖြစ်ဟှူကြောန့် ယေရှုနတူးဒူ ယဇ်ပုရောဟိတ်မန်းရဲ့ ခြံဝမ်းထဲဟှို ဝမ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ပေတရုဟှာ ခြံခွဗော့‑က်ပ္လန်မာ နေရစ်ဟှယ်။ ယဇ်ပုရောဟိတ်မန်းရဲ့ သိဖြစ်ဟှူ တဗဲ့တော်ဟှာ ပ္လန်ထွပ်လာဘီး ခွဗော့‑က်စောန့် စေခံဝယ်သားဟှို ပြောဘီးဟှာ ပေတရုဟှို ထဲဟှို ခေါ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ခွဗော့‑က်စောန့် စေခံဝယ်သားဟှာ ပေတရုဟှို “နန်ဟှ အယ်မူလူရဲ့ တဗဲ့တော် မှုဟှလော” ဆိုဘီး မေးလိုက်ဟှယ်။ ပေတရုဟှ “မှုဟှ” ဆိုဘီး ပ္လန်ဖြေလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","အယ်ခီဟှာ ရှမ်းဟှူကြောန့် စေခံလေန စောန့်လေဟှာ မီးဘောင် ပတ်ပတ်လည်မာ ရပ်ဘီးဟှာ မီးကန်နေဂေ့ဟှယ်။ အယ်ကြောန့် ပေတရုဟှာ သူးနို့နတူးဒူ ရပ်ဘီးဟှာ မီးကန်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","အယ်ခီမာ ယဇ်ပုရောဟိတ်မန်းဟှာ ယေရှုဟှို တဗဲ့တော်လေကြောန်းန ယေရှုရဲ့ သွန်သန်ဇာကြောန်းဟှို မေးနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ယေရှုဟှ “ငါဟှာ လောကမာ ပွမ့်ပွမ့်လန်းလန်းဟှားဘဲ့ သွန်သန်ဟှယ်။ ယုဒလူလေ စုဝီးဟှူ ဝါလယ်ဇရပ်လေန ဗိမာန်တော်မာဘဲ့ ငါဟှာ သွန်သန်ဟှယ်။ ငါဟှာ တိတိဟှား ဟောပြောဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","အယ်ဆိုဟှာ ဖြားဖြစ်ကြောန့် ငါ့ဟှို မေးမြန်းနေနူး။ ငါဟောပြောဟှားဇာလေဟှို ကြားဟှားဘီးဟှူ လူလေဟှို မေးမြန်းဂေ့။ ငါဖြားဇာလေ ဟောပြောဟှားဟှယ် ဆိုဇာဟှို အယ်လူလေဟှို မေးမြန်းဂေ့။ ငါပြောဟှားဇာလေဟှို သူးနို့သိဂေ့ဟှယ်” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ယေရှုဟှာ အယ်မျိုးမိန့်တော်မူလိုက်ခီမာ စောန့်တယော့‑က်ဟှာ “ယဇ်ပုရောဟိတ်မန်းဟှို အယ်မျိုးပ္လန်ဖြေရလော!” ဆိုဘီး ကိုယ်တော့်ဟှို ပါးရိုက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ယေရှုဟှာ သူ့ဟှို “ငါပြောဟှားဇာလေ မှားဟှယ် ဆိုဟှာ မှားကြောန်းဟှို သတ်သေပြဂေ့။ ဖြေတော်မူလေဟှယ်။ အယ်ဘေမဲ့ ငါပြောဟှားဇာလေ မှန်ဟှယ် ဆိုဟှာ ဖြားဖြစ်ကြောန့် ငါ့ဟှို ရိုက်နေရနူး” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","အယ်ဘီးန အန္နတ်ဟှာ ကိုယ်တော့်ဟှို တောက်နှောန်ဘီး ယဇ်ပုရောဟိတ်မန်း ကယာဖနားဟှို ပို့စေလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ရှိမုန်ပေတရုဟှာ မတ်တတ်ရပ်ဘီးဟှာ မီးကန်နေဒူးဘဲ့ဖြစ်ဟှယ်။ အယ်ကြောန့် လူတချို့ဟှာ “နန်ဟှာလည်း အယ်လူရဲ့ တဗဲ့တော်လေထဲဟှ တယော့‑က် မှုဟှလော” ဆိုဘီး သူ့ဟှို မေးဂေ့ဟှယ်။ အယ်ဘေမဲ့ ပေတရုဟှာ “ငါမှုဟှ” ဆိုဘီး ငြင်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ယဇ်ပုရောဟိတ်မန်းရဲ့ ကျွန်တယော့‑က်ဖြစ်ဘီး ပေတရု ခွတ်လိုက်ဟှူကြောန့် နားဝှပ်ပြတ်ဟှားဟှူလူန ရွှေမျိုးတော်သူဟှ “နန်ဟှာ အယ်လူနတူးဒူ ဥယျာဉ်ထဲမာ ငါဗြင်လိုက်ဟှယ် မှုဟှလော” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ပေတရုဟှာ “မှုဟှ” ဆိုဘီး နော့‑က်တခါ ငြင်းလိုက်ဟှူ ခီမာ ရှင်းရှင်းဘဲ့ ကြစ်တွန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","မိုးလန်းစောစောန ယေရှုဟှို ကယာဖရဲ့ အီဟှနေ ဗြို့ဝန်မန်းရဲ့ နန်းတော်ဟှို ခေါ်ဆောန်ဟှားဟှယ်။ ယုဒအာဏာပိုင်လေဟှာ ပသခါပွဲတော်ဟှို စားနိုင်ဟှို့တွပ် သူးနို့ကိုယ်တိုင် ဘာသာရေးစဉ်လာတိုင်း ညစ်ညူးစေရှင်ဘဲဟှူကြောန့် နန်းတော်ထဲဟှို ဝင်လိုက်ဟှားဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","အယ်ကြောန့် ပိလတ်ဟှာ သူးနို့ရှိဟှူ ပ္လန်ဟှို ထွပ်လာဘီး “အယ်လူဟှို ဖြားမှုန စွပ်စွဲဟှားဂေ့နူး” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","သူးနို့ဟှ “အယ်လူဟှာ ရာဇဝတ်မှုဟှို ကျူးလွန်ဘဲဟှ ဆိုဟှာ အယ်လူဟှို ကျွန်တော့်ဟှားလေ ခေါ်လာဟှို့ မှုဟှ” ဆိုဘီး ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ပိလတ်ဟှာ “အယ်ဆိုဟှာ နန်းနို့ကိုယ်တိုင် အယ်လူဟှို ခေါ်ဟှားလိုက်ဘီး နန်းနို့ရဲ့ ပညတ်တရားတိုင်း စီရင်ဂေ့” ဆိုဘီး ယုဒလူလေဟှို ပြောလေဟှယ်။ သူးနို့ဟှ “ကျွန်တော့်ဟှားလေဟှာ ဖယ်လူဟှိုလည်း သတ်ပိုင်ခွမ့်မှေ့ဟှ” ဆိုဘီး ပ္လန်ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","အယ်မျိုးပြောနေဇာဟှ မိမိဟှာ ဖယ်မျိုးသေခံရမယ် ဆိုဇာဟှို ယေရှုမိန့်တော်မူဟှားတိုင်း ပ္လဲ့ဇောင်လာစေဟှို့ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ပိလတ်ဟှာ နန်းတော်ထဲဟှို ပ္လန်ဝမ်ဟှားဘီး ယေရှုဟှို ခေါ်လိုက်ဘီး “နန်ဟှာ ယုဒမန်းဂီးလော” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ယေရှုဟှ “နန်ဟှာ နန့်ဆန္ဒတိုင်း အယ်မေးခွန်းဟှို မေးဇာလော။ အယ်မျိုးမှုဘဲနေဟှာ တခြားလူလေဟှ ငါ့ကြောန်းဟှို ပြောပြဟှားကြောန့်လော” ဆိုဘီး မေးတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ပိလတ်ဟှ “နန်ဟှာ ငါ့ဟှို ယုဒလူဖြစ်ဟှယ် ဆိုဘီး ထန်နေဟှယ်လော။ နန့်ဟှို ငါ့နားဟှို လာအပ်ပေးဟှူလူလေဟှာ နန့်လူမျိုးလေန ယဇ်ပုရောဟိတ်ဂီးလေဖြစ်ဟှယ်။ နန်ဟှာ ဖြားဇာလေလောက်ဟှားနူး” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ယေရှုဟှ “ငါ့နိုင်ငံတော်ဟှာ အယ်လောကနဆိုင်ဟှ။ ငါ့နိုင်ငံတော်ဟှာ အယ်လောကနဆိုင်မယ် ဆိုဟှာ ငါ့ဟှို ယုဒအာဏာပိုင်လေ လတ်ထဲရော့‑က်ဘဲအောန် ငါ့စေခံလေဟှာ တိုက်ခိုက်ဂေ့လေ့မယ်။ ငါ့နိုင်ငံတော်ဟှာ အယ်လောကနဆိုင်ဟှ!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","အယ်ကြောန့် ပိလတ်ဟှာ “အယ်ဆိုဟှာ နန်ဟှာ မန်းဂီးလော” ဆိုဘီး ကိုယ်တော့်ဟှို မေးလေဟှယ်။ ယေရှုဟှ “သင်ပြောမျိုးဘဲ့ ငါဟှာ မန်းဂီးဖြစ်ဟှယ်။ ငါဟှာ သမ္မာတရားဟှို သတ်သေခံဟှို့တွပ် မွီးလာဘီး အယ်လောကဟှို ကြွလာဟှယ်။ သမ္မာတရားနဆိုင်ဟှူ လူလေဟှာ ငါ့စကားဟှို နားထောန်ဂေ့ဟှယ်” ဆိုဘီး ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ပိလတ်ဟှ “အယ်ဆိုဟှာ သမ္မာတရားဟှ ဖြားဇာနူး” ဆိုဘီး မေးလေဟှယ်။ အယ်ဘီးန ပိလတ်ဟှာ ပ္လန်မာရှိနေဟှူ ယုဒလူလေနားဟှို ပ္လန်ဟှားဘီးဟှာ “အယ်လူမာ ပြစ်စီရင်ဟှို့ဇာ ဖြားလည်း မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","နန်းနို့ရဲ့ ထောင်းဇံရ ပသခါပွဲမာ ထောန်သားတယော့‑က်ဟှို လွှတ်လေ့ရှိဟှယ်။ နန်းနို့တွပ် ယုဒမန်းဂီးဟှို လွှတ်ပေးစေရှင်ဟှယ်လော” ဆိုဘီး သူးနို့ဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","သူးနို့ဟှာ “သူ့ဟှို လွှတ်ပေးန! ဗာရဗ္ဗဟှိုဘဲ့ လွှတ်ပေးပါ!” ဆိုဘီး အော်ဘီး ပ္လန်ဖြေဂေ့ဟှယ်။ ဗာရဗ္ဗဟှာ ဓမ္လတယော့‑က် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","အယ်ကြောန့် ပိလတ်ဟှာ ယေရှုဟှို ခေါ်ဆောန်ဟှားစေဘီး ကီဒန်ပေးစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","စစ်သားလေဟှာ ဆူးခတ်လေန လောက်ဟှားဟှူ သရဖူဟှို ကိုယ်တော့်ခေါန်းထတ်မာ ဆောန်းပေးဘီးဟှာ ခရမ်းရောန်ဝတ်ရောင်ဟှို ဝတ်ပေးဘီး ");
INSERT INTO tvn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ကိုယ်တော်နားဟှို လာဂေ့ဘီး “ယုဒမန်းဂီး သတ်တော် ရာကျော်ရှယ်ပါစေ!” ဆိုဘီး ပြောဂေ့ဟှယ်။ အယ်ဘီးန ကိုယ်တော့်ဟှို ပါးရိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ပိလတ်ဟှာ နော့‑က်ထပ်တခါ ပ္လန်ဟှို ထွပ်လာဘီးဟှာ “အယ်လူဟှို ပြစ်စီရင်ဟှို့ဇာ ဖြားလည်းတွိဟှ။ အယ်ကြောန့် နန်းနို့ဗြင်စေဟှို့ သူ့ဟှို နန်းနို့နားဟှို ငါခေါ်လာမယ်” ဆိုဘီး လူအောက်ဂီးဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","အယ်ဘီးန ယေရှုဟှာ ဆူးသရဖူန ခရမ်းရောန်ဝတ်ရောင်ဟှို ဝတ်ဟှားဘီး ပ္လန်ဟှို ထွပ်ကြွတော်မူလေဟှယ်။ ပိလတ်ဟှာ “ကေ့ကေ့! အယ်လူဘဲ့ဖြစ်ဟှယ်!” ဆိုဘီး သူနို့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ယဇ်ပုရောဟိတ်ဂီးလေန စောန့်လေဟှာ ကိုယ်တော့်ဟှို ဗြင်လိုက်ဟှူ ခီမာ “အယ်လူဟှို ကားစင်တန်ပါ! အယ်လူဟှို ကားစင်တန်ပါ!” ဆိုဘီး သူးနို့ဟှာ အော်ဟစ်ဂေ့ဟှယ်။ ပိလတ်ဟှာ “အယ်ဆိုဟှာ နန်းနို့ဟှာ အယ်လူဟှို ခေါ်ဆောန်ဟှားဘီး ကားစင်တန်ဂေ့။ ငါဟှာ သူ့ဟှို ပြစ်စီရင်ဟှို့ဇာ ဖြားလည်းတွိဟှ” ဆိုဘီး သူးနို့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ယုဒလူခေါန်းဆောန်လေဟှာ “အယ်လူဟှာ သူ့ကိုယ်သူ ဘုရားသခင်ရဲ့ သားတော် ဆိုဘီး ကြေညာဟှူကြောန့် သေထိုက်ကြောန်း ကျွန်တော့်ဟှားလေရဲ့ ပညတ်တရားမာ ပြောဟှားဟှယ်” ဆိုဘီး ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ပိလတ်ဟှာ အယ်စကားဟှို ကြားရဟှူ ခီမာ ပိုဘီး ကြော့‑က်လန့်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","သူဟှာ နန်းတော်ထဲဟှို ပ္လန်ဝမ်ဟှားဘီးဟှာ ယေရှုဟှို “သင်ဟှာ ဖယ်နေရာဟှနေ လာဟှယ်နူး” ဆိုဘီး မေးလေဟှယ်။ အယ်ဘေမဲ့ ယေရှုဟှာ ခွန်းလည်း ပ္လန်ဖြေဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ပိလတ်ဟှာ ကိုယ်တော့်ဟှို “သင်ဟှာ ငါ့ဟှို စကားပြောနိုဘီလော။ ငါဟှာ သင့်ဟှို လွှတ်ဟှို့တွပ် ခွမ့်အာဏာလည်းရှိဘီး ကားစင်တန်ဟှို့တွပ် ခွမ့်အာဏာလည်းရှိဟှယ် ဆိုဇာဟှို သိဟှလော” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ယေရှုဟှ “သင့်ဟှို ဘုရားသခင်ဟှ ပေးအပ်ဟှားဟှူကြောန့် အယ်မျိုးခွမ့်အာဏာဟှို ရဟှားဟှယ်။ အယ်ကြောန့် ငါ့ဟှို သင့်လတ်ထဲအပ်ဟှူ လူဟှာ ပြစ်ပိုကီးဟှယ်” ဆိုဘီး ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ပိလတ်ဟှာ အယ်မျိုးကြားရဟှူ ခီမာ ယေရှုဟှို လွှတ်ပေးဟှို့တွပ် နည်းလမ်းရှာဟှို့ ကြိုးစားလေဟှယ်။ အယ်ဘေမဲ့ ယုဒလူခေါန်းဆောန်လေဟှာ “အယ်လူဟှို လွှတ်ပေးမယ် ဆိုဟှာ သင်ဟှာ ကဲသာမန်းဂီးရဲ့ မိဆွေ မှုဟှ! ဖယ်လူဘဲ့ဖြစ်ဖြစ် ကိုယ့်ကိုယ်ကိုယ် မန်းဂီးဆိုဘီး ကြေညာဟှူလူဟှာ ကဲသာမန်းဂီးဟှို ပူကန်ဇာဖြစ်ဟှယ်!” ဆိုဘီး အော်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ပိလတ်ဟှာ အယ်စကားလေဟှို ကြားဟှူ ခီမာ ယေရှုဟှို ပ္လန်ဟှို ခေါ်ထုဟှားဘီး က္လော့‑က်ပ္လားစင်္ကြံ ဆိုဘီး ခေါ်ဟှူ တရားပလ္လင်ထတ်မာ ထိုင်လေဟှယ်။ အယ်စင်္ကြံဟှို ဟေဗြဲစကားန ဂဗ္ဗသ ဆိုဘီး ခေါ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","အယ်နေ့ဟှာ ပသခါပွဲတိုင်ခန် နေဒန်ဇာဖြစ်ဟှယ်။ ပိလတ်ဟှာ “နန်းနို့မန်းဂီးဘဲ့ ဖြစ်ဟှယ်!” ဆိုဘီး ယုဒလူလေဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","သူးနို့ဟှာ “အယ်လူဟှို သတ်ပါ! အယ်လူဟှို သတ်ပါ! အယ်လူဟှို ကားစင်တန်ပါ!” ဆိုဘီး ပ္လန်အော်ဂေ့ဟှယ်။ ပိလတ်ဟှာ “နန်းနို့မန်းဂီးဟှို ကားစင်တန်ရဟှို့လော” ဆိုဘီး သူးနို့ဟှို မေးလေဟှယ်။ ယဇ်ပုရောဟိတ်ဂီးလေဟှ “ကဲသာတပါးဒဲဘဲ့ ကျွန်တော်ဟှားလေရဲ့ မန်းဂီးဖြစ်ဟှယ်!” ဆိုဘီး ပ္လန်ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","အယ်ဘီးန ပိလတ်ဟှာ ယေရှုဟှို ကားစင်တန်ဟှို့တွပ် သူးနို့လတ်ထဲဟှို အပ်ပေးလေဟှယ်။ အယ်ကြောန့် သူးနို့ဟှာ ယေရှုဟှို ခေါ်ဆောန်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ကိုယ်တော်ဟှာ “ဦးခေါန်းခွံနေရာ” ဟှို မိမိလတ်ဝါးကပ်တိုင်ဟှို ထမ်းဘီး ကြွတော်မူလေဟှယ်။ အယ်နေရာဟှို ဟေဗြဲစကားန “ဂေါလဂေါသ” ဆိုဘီး ခေါ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","သူးနို့ဟှာ အယ်နေရာမာ ကိုယ်တော့်ဟှို တခြားလူနှေ့ယော့‑က်နတူးဒူ ကားစင်တန်ဂေ့ဟှယ်။ ယေရှုဟှို လယ်မာထားဘီး အယ်လူနှေ့ယော့‑က်ဟှို ညာဖတ်မာ တယော့‑က် ဘယ်ဖတ်မာ တယော့‑က် ထားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ပိလတ်ဟှာ “ယုဒမန်းဂီး၊ နာဇရက်ဗြို့သား ယေရှု” ဆိုဘီး ကမ္ပည်းရေးထိုးဘီး လတ်ဝါးကပ်တိုင်ထတ်မာ ကပ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ယေရှုဟှို ကားစင်တန်ဟှူ နေရာဟှ ဗြို့န နီးဟှူကြောန့် ယုဒလူလေဟှာ အယ်ကမ္ပည်းစာဟှို ဖတ်ဂေ့ဟှယ်။ အယ်ကမ္ပည်းစာဟှို ဟေဗြဲစကား၊ လက်တင်စကား၊ ဟေလသစကားန ရေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ယဇ်ပုရောဟိတ်ဂီးလေဟှာ ပိလတ်ဟှို “ ‘ယုဒမန်းဂီး’ ဆိုဘီး ရေးပါန။ ‘အယ်လူဟှ ငါဟှာ ယုဒလူလေရဲ့ မန်းဂီးဖြစ်ဟှယ် ဆိုဘီး ပြောကြောန်းဟှိုဘဲ့ ရေးတော်မူပါ’” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ပိလတ်ဟှ “ငါရေးဟှားဘီးဇာဘဲ့ တည်ဖြစ်ရမယ်” ဆိုဘီး ပ္လန်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","စစ်သားလေဟှာ ယေရှုဟှို ကားစင်တန်ဂေ့ဘီးန ကိုယ်တော်ရဲ့ ဝတ်တော်ဟှို လေးပိုင်းပိုင်းဘီး တယော့‑က်တပိုင်းစီ ယူဂေ့ဟှယ်။ သူးနို့ဟှာ ထဲခံအန်းဂီဟှိုလည်း ယူဂေ့ဟှယ်။ အယ်အန်းဂီဟှာ ချောက်ကြောန်းမှေ့ဘဲ့ ရစ်လောက်ဟှားဟှူ အန်းဂီးဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","စစ်သားလေဟှာ “အယ်အန်းဂီးဟှို ဆုဖ္လဲဘဲန ဖယ်လူရမယ် ဆိုဇာဟှို မဲနှိုက်ဂေ့ဇို့” ဆိုဘီး သူးနို့ ရှင်းရှင်း ပြောဂေ့ဟှယ်။ အယ်မျိုးဖြစ်လာဇာဟှ “သူးနို့ဟှာ ငါ့အန်းဂီးဟှို ခွဲဝီယူဂေ့မယ် အယ်ဘီးဟှာ ငါ့အန်းဂီဟှို မဲနှိုက်ဘီးဟှာ ယူဂေ့ဟှယ်” ဆိုဘီး ကျမ်းစာမာ ရေးဟှားဇာလေ ပ္လဲ့ဇောင်ဟှို့တွပ် ဖြစ်လေဟှယ်။ အယ်ကြောန့် စစ်သားလေဟှာ အယ်မျိုး လောက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ယေရှုရဲ့ လတ်ဝါးကပ်တိုင်နားမာ ကိုယ်တော်ရဲ့မိ၊ ကိုယ်တော့်မိရဲ့ညီမ၊ ကလောဖရဲ့မီးမ မာရိန မာဂဒလဝါသူ မာရိ မတ်တတ်ရပ်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ယေရှုဟှာ နီးမာရပ်နေဟှူ၊ ကိုယ်တော်ရှစ်ဟှူ တဗဲ့တော်န မိဟှို ဗြင်လိုက်ဟှူကြောန့် ကိုယ်တော်ဟှ “နို့မိ၊ နို့မိသားဟှို ကေ့ပါအူး” ဆိုဘီး မိဟှို မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","အယ်ဘီးန ကိုယ်တော်ဟှာ “သူဟှာ နန့်ရဲ့ မိဖြစ်ဟှယ်” ဆိုဘီး အယ်တဗဲ့တော်ဟှို မိန့်တော်မူလေဟှယ်။ အယ်ခီဟှနေစဘီး အယ်တဗဲ့တော်ဟှာ မိဟှို သူ့ရဲ့ အီမာ ခေါ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","အယ်ဘီးန ယေရှုဟှာ မှုအားလောင်း ပီးဟှားဘီဆိုဇာဟှို သိတော်မူဘီး ကျမ်းစာပ္လဲ့ဇောင်ဟှို့တွပ် “ငါရေငတ်ဟှယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","အယ်နေရာမာ ဝိုင်ရှင်ပ္လဲ့ထဲ့ဟှားဟှူ အိုးတလောင်းရှိဟှယ်။ အယ်ကြောန့် သူးနို့ဟှာ ရေမ္လုတခုဟှို အယ်ဝိုင်ရှင်ထဲမာ နှစ်လိုက်ဘီးဟှာ ဟုဿုပ်ဗန် ခတ်ဖျားမာတပ်ဘီး ကိုယ်တော်ရဲ့ နှော့‑က်ခမ်းနားဟှို ကပ်ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ယေရှုဟှာ ဝိုင်ရှင်ဟှို သော့‑က်တော်မူဘီးန “မှုပီးဟှားဘီး!” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ အယ်ဘီးန ကိုယ်တော်ဟှာ ဦးခေါန်းတော်ဟှို အော့‑က်ဟှိုစိုက်ခ္လဘီး သတ်တော်ဟှို စွန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ယုဒအာဏာပိုင်လေဟှာ ကားစင်တန်ဟှားဟှူ လူလေရဲ့ ခေလေဟှို ရိုက်ခ္လိုးဘီးဟှာ လောန်းလေဟှို ကားတိုင်ထတ်ဟှနေ အော့‑က်ခ္လခွမ့်ပြုဟှို့ ပိလတ်ဟှို တောန်းလျှော့‑က်ဂေ့ဟှယ်။ သူးနို့ အယ်မျိုးတောန်းလျှော့‑က်ဇာဟှ အယ်နေ့ဟှာ ဖိနေ့ဖြစ်ဘီး ဒန်းနေ့မာ လောန်းလေဟှို လတ်ဝါးကပ်တိုင်ထတ်မာ မှေ့စေရှင်ဟှ။ နတ်ကီးတိုင်ဟှာလည်း ကီးမြတ်ဟှူ ဒန်းနေ့ဖြစ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","အယ်ကြောန့် စစ်သားလေဟှာ လာဘီးန ယေရှုနတူးဒူ ကားစင်တန်ခံရဟှူ ပထမလူရဲ့ ခေလေန ဒုတိယလူရဲ့ ခေလေဟှိုလည်း ရိုက်ခ္လိုးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","အယ်ဘေမဲ့ သူးနို့ဟှာ ယေရှုနားဟှို ရော့‑က်လာဟှူ ခီမာ သေနေဘီ ဆိုဇာဟှို တွိဟှားဟှူကြောန့် ကိုယ်တော်ရဲ့ခေလေဟှို ရိုက်ခ္လိုးဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","အယ်ဘေမဲ့လည်း စစ်သားတယော့‑က်ဟှာ ယေရှုရဲ့ နံဘေးတော်ဟှို လှံန ထိုးဖော့‑က်လိုက်ဟှူ ခီမာ သွီးနရေဟှာ ရှစ်ရှင်းထွပ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","အယ်မျိုးဖြစ်ဇာလေဟှို နန်းနို့လည်း ယောင်ကြည်ဟှို့တွပ် ဗြင်ဟှူလူတယော့‑က်ဟှ သတ်သေခံဟှားဟှယ်။ အယ်လူပြောဇာလေဟှာ မှန်ဖြစ်ဘီး အယ်လူဟှာ မှန်းမှန်ကန်းကန်ဟှား ပြောဟှယ် ဆိုဇာဟှို သူကိုယ်တိုင်သိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","အယ်မျိုးဖြစ်ဟှားဇာဟှ “သူ့ရဲ့ ရိုးလေဟှာ တရှောန်းလည်း ကျိုးဂေ့ဟှ” ဆိုဘီး ကျမ်းစာပ္လဲ့ဇောင်ဟှို့တွပ် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","အယ်ဘီးဟှာ တခြားကျမ်းစာမာ “လူလေဟှာ သူးနို့ ထိုးဖော့‑က်လိုက်ဟှူ လူဟှို ဗြင်ရဂေ့လေ့မယ်” ဆိုဘီး ရေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","အယ်ဘီးန အရိမဿဲဗြို့သား ယောသပ်ဟှာ ယေရှုရဲ့ လောန်းတော်ဟှို ယူဟှားခွမ့်ပြုဟှို့တွပ် ပိလတ်နားဟှို သွားဘီး တောန်းလျှော့‑က်လေဟှယ်။ ယောသပ်ဟှာ ယုဒအာဏာပိုင်လေဟှို ကြော့‑က်ဟှူကြောန့် ထန်းထန်ရှားရှားနေဘဲဟှူ ယေရှုရဲ့ တဗဲ့တော် တယော့‑က် ဖြစ်ဟှယ်။ ပိလတ်ရဲ့ခွမ့်ပြုချစ်န ယောသပ်ဟှာ လောန်းတော်ဟှို ယူဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ရင်းရင်ဒူးဟှ ယေရှုဟှို ညဉ့်ခန်းဖတ်မာ လာတွိဟှူ နိကောဒင်ဟှာ မုရန်န အကျော် ရောနှောဟှားဟှူ နံ့သာ ပိဿာနှေ့ဆယ်ကျော်ဟှို ယူဟှားဘီး ယောသပ်နတူးဒူ လိုက်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","အယ်လူနှေ့ယော့‑က်ဟှာ ယေရှုရဲ့ လောန်းဟှို ယူဘီး ယုဒလူလေရဲ့ သင်္ဂြိုဟ်ဇာနဆိုင်ဟှူ ထောင်းဒန်းစဉ်လာတိုင်း နံ့သာလေနတူးဒူ လောန်းတော်ဟှို ပိဖ္လူနပတ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ယေရှုူဟှို လတ်ဝါးကပ်တိုင်မာ တန်ဘီးသတ်ဟှူ နေရာနားမာ ဥယျာဉ်တခုရှိဟှယ်။ အယ်ဥယျာဉ်ထဲမာ ဖယ်လူဟှိုလည်း သင်္ဂြုဟ်ဖူးသေးဘဲဟှူ သန်းခ္လိုင်းဂူသစ်တခု ရှိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","အယ်နေ့ဟှာ ယုဒလူလေရဲ့ ဖိနေ့ ဖြစ်ဟှူကြောန့် နီးမာရှိဟှူ သန်းခ္လိုင်းဂူမာ ယေရှုရဲ့ လောန်းတော်ဟှို သင်္ဂြိုဟ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","နန်းနွေနေ့ မိုးလန်းခန် မှောန်နေဒူးခီမာ မာဂဒလဝါသူ မာရိဟှာ သန်းခ္လိုင်းဟှို ရော့‑က်လာဘီး က္လော့‑က်တောင်းဟှို ဂူဝဟှနေ ဖယ်ဟှားဇာဟှို တွိရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","သူဟှာ ရှိမုန်ပေတရုန ယေရှုရှစ်တော်မူဟှူ တခြားတဗဲ့တော်နားဟှို ပ္လေးဟှားဘီး “သခင်ဘုရားဟှို သန်းခ္လိုင်းဟှနေ သူးနို့ ယူဟှားဘီး ဖယ်နေရာမာ ထားဟှားဂေ့ဟှယ် ဆိုဇာဟှို နို့လေသိဂေ့ဟှ!” ဆိုဘီး သူးနို့ဟှို ပြောပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","အယ်န ပေတရုန တခြားတဗဲ့တော်ဟှာ သန်းခ္လိုင်းဟှို သွားဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","သူးနို့နှေ့ယော့‑က်ဟှာ တူးဒူပ္လေးဟှားဂေ့ဘေမဲ့ တခြားတဗဲ့တော်ဟှာ ပေတရုထတ် ဗြန်းဗြန်းပ္လေးဟှားဘီး သန်းခ္လိုင်းဟှို ရင်ဦးဆောင်း ရော့‑က်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","သူဟှာ ငေါက်ကေ့လိုက်ဟှူဇာ ပိဖ္လူလေဘဲ့ တွိလေဟှယ်။ အယ်ဘေမဲ့ သူဟှာ ထဲဟှို ဝမ်ဘဲနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","နော့‑က်ဟှလိုက်လာဟှူ ရှိမုန်ပေတရုဟှာ ရော့‑က်လာဘီး သန်းခ္လိုင်းဂူထဲဟှို ဝမ်ဟှားဟှယ်။ သူဟှာ ပိဖ္လူန ");
INSERT INTO tvn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ယေရှုရဲ့ ဦးခေါန်းတော်ဟှို ပတ်ဟှားဟှူ ပိဖ္လူဟှိုဘဲ့ တွိရဟှယ်။ ဦးခေါန်းတော်ဟှ ပိဖ္လူဟှာ တခြားပိဖ္လူလေနတူးဒူ မှေ့ဘဲ့ တခြားစီရှိနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","အယ်ဘီးန သန်းခ္လိုင်းဂူဟှို ရင်ဦးဆောင်း ရော့‑က်နေဟှူ တခြားတဗဲ့တော်လည်း ထဲဟှို ဝမ်ဟှားလေဟှယ်။ အယ်လူဟှာ ဗြင်ဟှားဘီး ယောင်ကြည်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ကိုယ်တော်ဟှာ သေဘီးန ပ္လန်ရှင်ရမယ် ဆိုဘီး ပြောဟှားဟှူ ကျမ်းစာဟှို သူးနို့လေ နားလည်ဂေ့သေးဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","အယ်ဘီးန တဗဲ့တော်နှေ့ပါးဟှာ အီဟှို ပ္လန်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","မာရိဟှာ သန်းခ္လိုင်းဂူပ္လန်မာ ငိုဘီး ရပ်နေဟှယ်။ သူဟှာ ငိုနေဒူးမာဘဲ့ သန်းခ္လိုင်းဂူထဲဟှို ငုံ့ကေ့လိုက်ဇာ ");
INSERT INTO tvn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ကောန်းဂန်တမန်နှေ့ပါးဟှာ ဝတ်ရောင်ဖ္လူဟှို ဝတ်ဟှားဘီး ယေရှုလောန်းတော်ရဲ့ ခေါန်းရင်းမာတပါး၊ ခေရင်းမာတပါး ထိုင်နေဇာဟှို ဗြင်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","သူးနို့ဟှ “မီးမဂီး၊ ဖြားဖြစ်ကြောန့် ငိုနေရနူး” ဆိုဘီး သူ့ဟှို မေးဂေ့ဟှယ်။ သူဟှ “ကျွန်မရဲ့ သခင်ဟှို သူးနို့ယူဆောန်ဟှားဘီး ဖယ်မာထားဟှားဟှယ် ဆိုဇာဟှို သိဟှ!” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","အယ်ဘီးန နော့‑က်ဟှို လှည့်ကေ့လိုက်ဇာ ယေရှုဟှာ ရပ်တော်မူနေဇာဟှို ဗြင်ဘေမဲ့ ယေရှုဖြစ်ဟှယ် ဆိုဇာဟှို သိဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ယေရှုဟှ “မီးမဂီး၊ ဖြားဖြစ်ကြောန့် ငိုနေရနူး။ နန်ဟှာ ဖယ်လူဟှို ရှာနေဟှယ်နူး။” ဆိုဘီး သူ့ဟှို မေးတော်မူလေဟှယ်။ မာရိဟှာ ကိုယ်တော့်ဟှို ဥယျဉ်မှူး ဆိုဘီး ထန်နေဟှယ်။ အယ်ကြောန့် သူဟှာ ကိုယ်တော့်ဟှို ပြောလိုက်ဇာဟှ “ဆရာ၊ သူ့ဟှို ယူဆောန်ဟှားဟှယ် ဆိုဟှာ ဖယ်နားမာထားဟှားဟှယ် ဆိုဇာဟှို ကျွန်မဟှို ပြောပြပါ။ ကျွန်မသွားဘီး ယူပါမယ်။” ");
INSERT INTO tvn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ယေရှုဟှ “မာရိ!” ဆိုဘီး သူ့ဟှို ခေါ်လေဟှယ်။ မာရိဟှာ လှည့်ဘီး ဟေဗြဲစကားန “ရဗ္ဗုနိ!” ဆိုဘီး ပ္လန်ထူးလေဟှယ်။ ရဗ္ဗုနိရဲ့ ဓိပါယ်မာ “ဆရာ” ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ယေရှုဟှာ “ငါဟှာ ဖနားဟှို တတ်ရသေးဘဲဟှူကြောန့် ငါ့ဟှို ထိနအူး။ ငါ့ညီကိုလေနားဟှို သွားဘီးဟှာ ငါ့ရဲ့ဖဖြစ်ဟှူ နန်းနို့ရဲ့ဖ၊ ငါ့ရဲ့ဘုရားသခင်ဖြစ်ဟှူ နန်းနို့ရဲ့ ဘုရားသခင်နားဟှို ငါတတ်ရအူးမယ် ဆိုဇာဟှို ပြောပါ” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","အယ်ကြောန့် မာဂဒလဝါသူ မာရိဟှာ တဗဲ့တော်လေနားဟှို သွားဘီး သခင်ဘုရားဟှို တွိဟှားကြောန်းန ကိုယ်တော် မိန့်တော်မူဟှားဟှူ ဇာလေဟှို ပြောပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","နန်းနွေနေ့ ညဉ့်ခန်းဖတ်မာ တဗဲ့တော်လေဟှာ ယုဒအာဏာပိုင်လေဟှို ကြော့‑က်ဟှူကြောန့် ခွဗော့‑က်လေပိဟှားဘီး စုဝီးနေဂေ့ဟှယ်။ အယ်ခီမာ ယေရှုဟှာ ကြွလာတော်မူဘီး သူးနို့လယ်မာ ရပ်တော်မူဘီး “နန်းနို့နတူးဒူ ငြီသတ်ရှင်း ရှိပါစေ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","အယ်မျိုး မိန့်တော်မူဘီးန ကိုယ်တော်ရဲ့ လတ်တော်န နံဘေးတော်ဟှို တဗဲ့တော်လေဟှို ပြတော်မူလေဟှယ်။ တဗဲ့တော်လေဟှာ သခင်ဘုရားဟှို တွိဗြင်ရဟှူ ခီမာ ဝန်းသာဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ယေရှုဟှာ “နန်းနို့မာ ငြီသတ်မှုရှိစေ။ ဖဟှ ငါ့ဟှို စေလွှတ်မျိုးဘဲ့ ငါလည်း နန်းနို့ဟှို စေလွှတ်မယ်” ဆိုဘီး သူးနို့ဟှို ထပ်ဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","အယ်ဘီးန ကိုယ်တော်ဟှာ တဗဲ့တော်လေထတ်ဟှို မှုတော်မူဘီး “သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို လတ်ခံဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","နန်းနို့ဟှာ လူလေရဲ့ ပြစ်လေဟှို ခွမ့်လွှတ်မယ် ဆိုဟှာ သူးနို့ဟှာ ပြစ်လေလွှတ်ဇာခံရမယ်။ နန်းနို့ဟှာ သူးနို့ရဲ့ ပြစ်လေဟှို ခွမ့်လွှတ်ဘဲဟှ ဆိုဟှာ သူးနို့ဟှာ ပြစ်လေ လွှတ်ဇာခံရမယ်မူဟှ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ယေရှုကြွလာတော်မူဟှူ ခီမာ တဗဲ့တော် ဆယ့်နှေ့ပါးထဲဟှ တယော့‑က်ဖြစ်ဟှူ မြွှာဘ္လူး ဆိုဘီး ခေါ်ဟှူ သောမဟှာ သူးနို့နတူးဒူ မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","အယ်ကြောန့် တခြားတဗဲ့တော်လေဟှာ “နို့လေဟှာ သခင်ဘုရားဟှို ဗြင်ရပီးဘီ!” ဆိုဘီး သူ့ဟှို ပြောဂေ့ဟှယ်။ သောမဟှာ “လတ်တော်မာ သံရိုက်ရာဟှို ဗြင်ရဘဲန၊ သံရိုက်ရာဟှို တို့စမ်းရဘဲန၊ နံဘေးတော်ဟှို လတ်ညှိုးန စမ်းသပ်ရဘဲန ငါယောင်ကြည်ဟှို့ မှုဟှ” ဆိုဘီး သူးနို့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","တဘတ်ကြာဘီးန တဗဲ့တော်လေဟှာ အီထဲမာ ပ္လန်စုဝီနေဟှူ ခီမာ သောမလည်း သူးနို့နတူးဒူ ရှိနေလေဟှယ်။ ခွဗော့‑က်လေဟှို ပိဟှားဘေမဲ့ ယေရှုဟှာ ကြွလာတော်မူဘီး သူးနို့လယ်မာ ရပ်တော်မူဘီးဟှာ “နန်းနို့မာ ငြီသတ်မှုရှိစေ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","အယ်ဘီးန ကိုယ်တော်ဟှာ “နန့်ရဲ့လတ်ညှိုးန အယ်နေရာဟှို တို့ဘီးဟှာ ငါ့လတ်လေဟှိုကေ့။ အယ်ဘီးဟှာ နန့်လတ်ဟှို ဆန့်ဘီး ငါ့နံဘေးဟှို စမ်းသပ်ကေ့။ သံသယမှေ့ဘဲ့န ယောင်ကြည်ပါ!” ဆိုဘီး သောမဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","သောမဟှာ “ကျွန်တော့်သခင်၊ ကျွန်တော့်ဘုရားသခင်!” ဆိုဘီး ကိုယ်တော့်ဟှို လျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ယေရှုဟှာ “နန်ဟှာ ငါ့ဟှို ဗြင်ရဟှူကြောန့် ယောင်ကြည်ဇာလော။ ငါ့ဟှို ဗြင်ဘဲ့န ယောင်ကြည်ဟှူ လူလေဟှာ မင်္ဂလာရှိဟှယ်!” ဆိုဘီးသူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","အယ်ကျမ်းထဲမာ ရေးဟှားဘဲဟှူ တခြားနိမိတ်လတ်ခဏာလေ ဘောင်ဂီးဟှိုလည်း တဗဲ့တော်လေရှေ့မာ ယေရှုဟှာ ပြတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","အယ်ဘေမဲ့ ယေရှုဟှာ ဘုရားသခင်ရဲ့ သားတော် မေရှိယ ဖြစ်တော်မူဟှယ် ဆိုဇာဟှို နန်းနို့ ယောင်ကြည်ဂေ့ဟှို့န အယ်မျိုး ယောင်ကြည်ဇာအားဖြင့် ကိုယ်တော့်နာမနှိုက် သတ်ဟှို ရရှိဟှို့တွပ် အယ်မူဇာလေဟှို ရေးဟှားဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","အယ်ဘီးန ယေရှုဟှာ တိဗေရိအိုင်နားမာ တဗဲ့တော်လေဟှို နော့‑က်တခါ ကိုယ်ထန်ရှားပြတော်မူဟှယ်။ ကိုယ်ထန်ရှားပြဇာဟှ အယ်မျိုးဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ရှိမုန်ပေတရု၊ မြွှာဘ္လူး ဆိုဘီး ခေါ်ဟှူ သောမ၊ ဂါလိလဲနယ်၊ ကာနဗြို့သား နာသနေလ၊ ဇေဗေဒဲရဲ့သားလေန တခြားတဗဲ့တော် နှေ့ယော့‑က်ဟှာ တူးဒူရှိနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ရှိမုန်ပေတရုဟှာ “ငါ ငါးသွားဖမ်းမယ်” ဆိုဘီး တခြားလူလေဟှို ပြောလေဟှယ်။ သူးနို့ဟှ “နို့လေလည်းလိုက်မယ်” ဆိုဘီး ပ္လန်ပြောဂေ့ဟှယ်။ အယ်ကြောန့် သူးနို့ဟှာ လှေန ငါးဖမ်းထွပ်ဟှားဂေ့ဟှယ်။ အယ်ဘေမဲ့ အယ်ညဉ့်မာ တကောန်လည်း ဖမ်းမိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","မိုးလန်းဇာမာ ယေရှုဟှာ ကမ်းနားမာ ရပ်နေဘေမဲ့လည်း တဗဲ့တော်လေဟှာ ယေရှုဖြစ်ဟှယ် ဆိုဇာဟှို သိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","အယ်န ယေရှုဟှာ “မိဆွေလေ၊ ငါးကောန်လည်းဖမ်းမိဟှလော” ဆိုဘီး သူးနို့ဟှို မေးတော်မူလေဟှယ်။ သူးနို့ဟှာ “ကောန်လည်းမိဟှ” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ကိုယ်တော်ဟှာ “နန်းနို့လှေရဲ့ ညာဖတ်ဟှို ပိုက်ဟှို ပစ်ခ္လဂေ့။ အယ်ဆိုဟှာ နန်းနို့ဟှာ ငါးလေဟှို ဖမ်းမိလေ့မယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ အယ်ကြောန့် သူးနို့ဟှာ ပိုက်ဟှို ပစ်ခ္လလိုက်ဇာ ငါးလေဘောင်ဂီးမိနေကြောန့် ပိုက်ဟှို ဆွဲဒန်ဟှို့ ခွန်အားမှေ့ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ယေရှုရှစ်တော်မူဟှူ တဗဲ့တော်ဟှာ “သခင်ဘုရားဘဲ့!” ဆိုဘီး ရှိမုန်ပေတရုဟှို ပြောလေဟှယ်။ သူဟှာ သခင်ဘုရားဖြစ်ဟှယ် ဆိုဇာဟှို ပေတရုကြားလိုက်ခီမာ ခလွတ်ဟှားဟှူ ပ္လန်အန်းဂီဟှို ခါးမာပတ်ဘီးဟှာ ရေထဲဟှို ခူခ္လဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","တခြားတဗဲ့တော်လေဟှာ ငါးနပ္လဲ့နေဟှူပိုက်ဟှို ဆွဲဒန်ဘီးဟှာ လှေစီးဘီး ကမ်းနားဟှို လာဂေ့ဟှယ်။ သူးနို့ဟှာ ကမ်းဟှနေ ကိုက်တရာလော့‑က်ဘဲ့ ဝီးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","သူးနို့ဟှာ ကမ်းထတ်ဟှို ရော့‑က်ဟှူ ခီမာ မီးဘောင်ထတ်မာ ကန်ဟှားဟှူ ငါးန မုနဲနဲဟှားဟှို တွိဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ယေရှုဟှာ “နန်းနို့ ခုဖမ်းလာဟှူ ငါးနဲနဲဟှား ယူလာဂေ့” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ရှိမုန်ပေတရုဟှာ လှေထတ်ဟှို တတ်ဟှားဘီး ငါးဂီးလေနပ္လဲ့နေဟှူ ပိုက်ကွန်ဟှို ကမ်းထတ်ဟှို ဆွဲဒန်လိုက်ဟှူ ခီမာ အားလောင်းပေါန်း ၁၅၃ ကောန် ရှိဟှယ်။ အယ်မျှလောက် ငါးလေဘောင်ဂီး ဖမ်းမိဘေမဲ့လည်း ပိုက်ဟှာ စုပ္လဲဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ယေရှုဟှာ “လာစားဂေ့” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ တဗဲ့တော်လေဟှ သခင်ဘုရားဖြစ်တော်မူဟှယ် ဆိုဇာဟှို သိနေဟှူကြောန့် “ကိုယ်တော်ဟှာ ဖယ်သူနူး” ဆိုဘီးလည်း မေးရဲဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","အယ်ကြောန့် ယေရှုဟှာ သူးနို့နားဟှို ကြွလာတော်မူဘီး မုဟှိုယူဘီးဟှာ ပေးလေဟှယ်။ အယ်မျိုးဘဲ့ ငါးဟှိုလည်း ယူဘီးဟှာ ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ယေရှုဟှာ သေရာဟှနေ ထမြော့‑က်တော်မူဘီးန တဗဲ့တော်လေဟှို ကိုယ်ထန်ရှားပြဇာဟှာ တတိယခါ ဖြစ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","တဗဲ့တော်လေ စားဂေ့ဘီးန ယေရှုဟှ “ယောဟန်ရဲ့သား ရှိမုန်၊ သူးနို့ ငါ့ဟှို ရှစ်ဇာထတ် နန်ဟှာ ငါ့ဟှို ပိုဘီး ရှစ်ဘဲ့လော” ဆိုဘီး ရှိမုန်ပေတရုဟှို မေးတော်မူလေဟှယ်။ ပေတရုဟှ “မှန်ပါဟှယ် သခင်၊ ကိုယ်တော့်ဟှို ကျွန်တော်ရှစ်ဟှယ် ဆိုဇာဟှို ကိုယ်တော်သိပါဟှယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ယေရှုဟှ “ငါ့ရဲ့သိုးသားဂန်းလေဟှို ကျွေးမွေးပါ” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ယေရှုဟှာ “ယောဟန်ရဲ့သား ရှိမုန်၊ ငါ့ဟှို ရှစ်ဘဲ့လော” ဆိုဘီး သူ့ဟှို ဒုတိယခါ မေးတော်မူလေဟှယ်။ ပေတရုဟှ “ရှစ်ပါဟှယ် သခင်၊ ကျွန်တော် ရှစ်ဟှယ် ဆိုဇာဟှို ကိုယ်တော်သိပါဟှယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ယေရှုဟှာ “ငါ့သိုးလေဟှို ကေ့ရှုပါ” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ယေရှုဟှာ “ယောဟန်ရဲ့သား ရှိမုန်၊ ငါ့ဟှို ရှစ်ဘဲ့လော” ဆိုဘီး သူ့ဟှို တတိယခါ မေးတော်မူလေဟှယ်။ ယေရှုဟှာ သောင်းခါ မေးတော်မူဟှူကြောန့် ပေတရုဟှာ ဝန်းနဲဟှားဘီး “သခင်၊ ကိုယ်တော်ဟှာ ဂူလောင်းဟှို သိတော်မူဟှူကြောန့် ကိုယ်တော့်ဟှို ကျွန်တော်ရှစ်ဟှယ် ဆိုဇာဟှို ကိုယ်တော်သိပါဟှယ်!” ဆိုဘီး ကိုယ်တော့်ဟှို ပ္လန်လျှော့‑က်လေဟှယ်။ ယေရှုဟှာ “ငါ့သိုးလေဟှို ကေ့ရှုပါ။ ");
INSERT INTO tvn_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","နန်းနို့ဟှို ငါ မှန်တိုင်းပြောမယ်၊ နန်ဟှာ ငယ်ရွယ်ဒူးခီမာ နန်ဝတ်ရှင်ဇာဟှို ဝတ်ဘီး နန်သွားရှင်ဟှူနေရာဟှို သွားနိုင်ဟှယ်။ အယ်ဘေမဲ့ နန်ဟှာ အိုဟှားဟှူ ခီမာ နန့်လတ်နှေ့ဖတ်ဟှို ဆန့်ဟှားဘီး ယော့‑က်ယော့‑က်ဟှ နန့်ဟှို ဝတ်ဆင်ဘီးဟှာ နန်သွားရှင်ဘဲဟှူ နေရာဟှို ယူဆောန်ဟှားလေ့မယ်” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","အယ်မျိုးပြောနေဇာဟှ ပေတရုဟှာ အယ်မျိုးနည်းလမ်းန သေရဇာအားဖြင့် ဘုရားသခင်ရဲ့ ဖောင်းသရေတော်ဟှို ထန်ရှားစေမယ် ဆိုဇာဟှို ယေရှုဟှာ ဖော်ပြနေဇာဖြစ်ဟှယ်။ အယ်ဘီးန ယေရှုဟှာ “ငါ့နော့‑က်လိုက်ဟှား!” ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ပေတရုဟှာ လှည့်ကေ့လိုက်ဘီး သူ့နော့‑က်မာ ယေရှုရှစ်တော်မူဟှူ တဗဲ့တော်ဟှို ဗြင်လေဟှယ်။ အယ်လူဟှာ ညဉ့်ဇာစားဟှူ ခီမာ ယေရှုဟှို မှီဘီး “သခင်၊ ကိုယ်တော့်ဟှို သစ်စာဖော့‑က်မယ့်လူဟှာ ဖယ်သူနူး” ဆိုဘီး မေးဟှူလူဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ပေတရုဟှာ အယ်တဗဲ့တော်ဟှို ဗြင်ဟှူ ခီမာ “သခင်၊ အယ်လူဟှာ ဖယ်မျိုးဖြစ်လေ့မယ်နူး” ဆိုဘီး ယေရှုဟှို မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ယေရှုဟှ “ငါပ္လန်ကြွလာမယ့်ခီထိ သူ့ဟှို သတ်ရှင်စေဟှို့ ငါလိုရှိဟှယ် ဆိုဟှာ နန့်နဖြားဆိုင်နူး။ ငါ့နော့‑က်ဟှို လိုက်ဟှား!” ဆိုဘီး ပ္လန်ဖြေတော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","အယ်ကြောန့် အယ်တဗဲ့တော်ဟှာ သေဟှို့ မှုဟှ ဆိုဘီး အယ်ဒန်းဟှာ ယေရှုရဲ့ နော့‑က်တော်လိုက်လေထဲမာ ပ္လံ့ဟှားလေဟှယ်။ အယ်ဘေမဲ့ ယေရှုဟှာ အယ်တဗဲ့တော် သေဟှို့ မှုဟှ ဆိုဘီး မိန့်တော်မူဇာ မှုဟှ။ ကိုယ်တော်ဟှ “ငါပ္လန်ကြွလာမယ့်ခီထိ သူ့ဟှို သတ်ရှင်စေဟှို့ ငါလိုရှိဟှယ် ဆိုဟှာ နန့်နဖြားဆိုင်နူး” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","အယ်ကြောန်းရာလေဟှို သတ်သေခံဘီး ရေးဟှားလူဟှာ အယ်တဗဲ့တော်ဘဲ့ ဖြစ်ဟှယ်။ သူ့သတ်သေခံချစ်လေဟှာ မှန်ဘဲ့ဖြစ်ဟှယ် ဆိုဇာဟှို နို့လေသိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ယေရှုပြုတော်မူဟှူ တခြားဇာလေဟှာ ဘောင်ဂီးရှိသေးဟှယ်။ အယ်မူဇာလေ ဂူလောင်းဟှို မှတ်တမ်းတန်ဟှားမယ် ဆိုဟှာ ကျမ်းလေဟှို အယ်လောကမာ ထားဇာနေရာမှေ့ဟှို့ မှုဟှ ဆိုဘီး ထန်မိဟှယ်။");
INSERT INTO tvn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ရှစ်ရဟှူ သော်ဖိလု၊ ယေရှုဟှာ မှုတော်ဆောန်ရှင်းန သွန်သန်ရှင်းလေဟှို စလောက်ဟှူခီဟှနေ၊ ");
INSERT INTO tvn_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ကောန်းဂန်ဘောင်ဟှို တတ်ကြွဟှားဟှူနေ့ထိ လောက်ဆောန်ဟှားဇာလေ ဂူလောင်းဟှို ပထမစာစောန်မာ ကျွန်တော်ရေးဟှားဟှယ်။ ကိုယ်တော်ဟှာ ကောန်းဂန်ဘောင်ဟှို တတ်ကြွဟှားခန်မာ ဝီးကော့‑က်ဟှားဟှူ တမန်တော်လေဟှို သန့်ရှင်းဟှူဝိညာဉ်တော်ရဲ့ တဂိုးန မိန့်တော်မူဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ကိုယ်တော်ဟှာ သေခံဘီးန ရစ်လေးဆယ် လောင်းလောင်း ခီဘောင်ဂီး ကိုယ်ထန်ရှားပြဘီး မိမိသတ်ရှင်ကြောန်းဟှို ခိုင်လောင်ဟှူ သတ်သေပြလေဟှယ်။ တမန်တော်လေဟှာ ကိုယ်တော့်ဟှို ဗြင်ရဂေ့ဘီး ကိုယ်တော်ဟှလည်း သူးနို့ဟှို ဘုရားသခင်ရဲ့ နိုင်ငံတော်ကြောန်းဟှို ပြောပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","သူးနို့လေဟှာ စုလာဂေ့ဟှူ ခီမာ ကိုယ်တော်ဟှ “ယေရုရှလင်ဗြို့ဟှနေ ထွပ်ဟှားဂေ့ဘဲ့န ငါ့ဖရဲ့ ဂဒိဟှို စောန့်နေဂေ့။ ငါဟှာ အယ်ဂဒိကြောန်းဟှို နန်းနို့ဟှို ပြောပြဟှားပီးဘီ။ ");
INSERT INTO tvn_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ယောဟန်ဟှာ ရေန ဗတ္တိဇံပေးဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ဟှာ ရစ်နဲနဲ ကြာဘီးဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န ဗတ္တိဇံဟှို ခံရဂေ့လေ့မယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","တမန်တော်လေဟှာ စုလာဟှူ ခီမာ ကိုယ်တော့်ဟှို “သခင်၊ ကိုယ်တော်ဟှ အယ်ခီမာ ဣသရေလ လူမျိုးတွပ် နိုင်ငံဟှို ပ္လန်ပေးဟှို့လော” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ယေရှုဟှ “ငါ့ဖရဲ့ ခွမ့်အာဏာန စီရင်ဟှားဟှူ နေ့ရစ်ခီလေဟှို နန်းနို့ဟှာ သိခွမ့် မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","အယ်ဘေမဲ့ နန်းနို့ထတ်ဟှို သန့်ရှင်းဟှူဝိညာဉ်တော် ကြွလာဟှူ ခီမာ နန်းနို့ဟှာ တဂိုးဟှို ရဂေ့လေ့မယ်။ အယ်ဘီးမှ နန်းနို့ဟှာ ယေရုရှလင်ဗြို့၊ ယုဒနယ်န ရှမာရိနယ် တနယ်လောင်းဟှနေ မ္လေဂီးဆောင်းထိ ငါ့ရဲ့ သတ်သေလေ ဖြစ်ဂေ့လေ့မယ်” ဆိုဘီး သူးနို့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","အယ်မျိုး ပြောဘီးန သူးနို့လေဟှာ ကေ့နေဒူးမာ ကိုယ်တော်ဟှာ ကောန်းဂန်ဘောင်ဟှို ယူဆောန်ခံရလေဟှယ်။ အယ်ဘီးမှ မိုးတီဟှာ ကိုယ်တော့်ဟှို သူးနို့ရဲ့ မျစ်စိရှေ့ဟှနေ ဖောင်းဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ကိုယ်တော် တတ်ကြွဟှားဇာဟှို သူးနို့လေဟှာ ကောန်းဂန်ဟှို စေ့စေ့ကေ့နေဂေ့ဟှယ်။ အယ်ခီမာ ဝတ်ဖ္လူစင်ကြယ်န လူနှေ့ယော့‑က်ဟှာ ရောက်တရစ် သူးနို့ရဲ့ နားမာ ရပ်နေဘီး ");
INSERT INTO tvn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","အယ်လူလေဟှာ “ဂါလိလဲနယ်သားလေ၊ နန်းနို့ဟှ ဖြားဖြစ်ကြောန့် ရပ်ဘီးဟှာ ကောန်းဂန်ဟှို ကေ့နေဂေ့နူး။ နန်းနို့နားဟှနေ ကောန်းဂန်ဘောင်ဟှို တတ်ကြွဟှားဟှူ အယ်ယေရှုဟှာ ကောန်းဂန်ဟှို တတ်ကြွဟှားဇာဟှို နန်းနို့ ဗြင်ရမျိုးဘဲ့ ပ္လန်ဘီး ကြွလာလေ့မယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","အယ်ဘီးန တမန်တော်လေဟှာ သံလွင် ဆိုဘီး ခေါ်ဟှူ တောန်ဟှနေဘီး ယေရုရှလင်ဗြို့ဟှို ပ္လန်ဟှားဂေ့ဟှယ်။ အယ်တောန်ဟှာ ယေရုရှလင်ဗြို့န မိုင်ဝပ်လော့‑က်ဘဲ့ ဝီးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","သူးနို့လေဟှာ ဗြို့ထဲဟှို ဝမ်ဘီးဟှာ သူးနို့လေ တဲနေဟှူ အီရဲ့ ထတ်ခန်းဟှို သွားဂေ့ဟှယ်။ အယ်လူလေဟှ ပေတရု၊ ယောဟန်၊ ယာကုပ်၊ အန္ဒြေ၊ ဖိလိပ္ပု၊ သောမ၊ ဗာသောလမဲ၊ မဿဲ၊ အာလဖဲရဲ့သားယာကုပ်၊ မျိုးရှစ်ပေါက်ကို ရှိမုန်န ယာကုပ်ရဲ့သား ယုဒလေဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","သူးနို့ဟှာ မီးမဂီးလေ၊ ယေရှုရဲ့မိ မာရိန ကိုယ်တော်ရဲ့ ညီလေဟှာ ခါဘီးခါ စုဝီးဘီး ဆုတောန်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ရစ်နဲနဲ ကြာဘီးန ၁၂၀ လော့‑က်ရှိဟှူ ညီကိုလေဟှာ စည်းဝေးနေဟှူ ခီမာ ပေတရုဟှာ အယ်လူအောက် လယ်နှိုက် စကားပြောဟှို့တွပ် ထဘီးဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ညီကို မောန်နှမလေ၊ ယေရှုဟှို ဖမ်းဟှူ လူလေဟှို လမ်းပြပေးမား ယုဒရှကာရုတ်ကြောန်းဟှို သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှ ဒါဝိဒ်အားဖြင့် ကြိုတန်ဘီး ပြောဟှားဟှူ ကျမ်းစာဟှာ ပ္လဲ့ဇောင်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ယုဒဟှာ မှုတော်ဆောန် တယော့‑က်နေန ဝီးကော့‑က်ခံရဟှူ လူဖြစ်ဘီး နို့လေရဲ့ ဖွဲ့ဝမ်လည်း ဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","သူဟှာ တရားဘဲဟှူ မှုကြောန့် ရဟှူကပ်န လယ်ဂွပ်ဟှို ဝယ်ဘီးန အယ်လယ်ဂွပ်မာ လဲက္လဘီး သေဟှားလေဟှယ်။ သူဟှာ ဗိုက်ပေါ့‑က်ဟှားဘီး သူ့အူလေလည်း ထွပ်က္လလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ယေရုရှလင်ဗြို့မာ နေဟှူလူလေဟှာ အယ်ကြောန်းဟှို ကြားဟှားဂေ့ဘီး အယ်လယ်ဂွပ်ဟှို သူးနို့စကားန “အကေလဒမ” ဆိုဘီး ခေါ်ဂေ့ဟှယ်။ “သွီးမ္လေ” ဆိုဘီး ဓိပါယ်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“ဆာလံကျမ်းမာ “ ‘သူ့ရဲ့ အီဟှာ လူလေတိဆိဟှူ နေရာဖြစ်ပါစေ။ အယ်အီမာ ဖယ်လူလည်း နေရစေန’ ဆိုဘီး ရေးဟှားဟှယ်။” “ ‘အယ်လူရဲ့ ရာထူးဟှိုလည်း တခြားတယော့‑က်ဟှ ယူပါစေ။’ ");
INSERT INTO tvn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“အယ်ကြောန့် သခင်ယေရှုဟှာ နို့လေနားမာ ဝမ်ထွပ်သွားလာဟှူ တခီလောင်း ");
INSERT INTO tvn_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ယောဟန်ရဲ့ ဗတ္တိဇံတရားဟှို ဟောဟှူ ခီဟှစဘီး နို့လေနားဟှနေ ခွာဟှားဘီး ထတ်ဟှို ဆောန်ယူဟှားရှင်းဟှို ခံတော်မူဟှူ နေ့ရစ်ထိ နို့လေန လိုက်ပါသူလေထဲဟှ ယော့က်ယော့က်ဟှာ အယ်သခင် ထမြော့‑က်ရှင်းကြောန်းဟှို နို့လေနတူးဒူ သတ်သေခံဟှူလူ ဖြစ်ရမယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","အယ်ကြောန့် သူးနို့လေဟှာ ယုတ္တု ဆိုဘီး ခေါ်ဟှူ ဗာရှဗ (ခေါ်) ယောသပ်န မဿိလေ နှေ့ယော့‑က်ဟှို ဆိုပြုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","အယ်ဘီးန တဗဲ့တော်လေဟှာ ဝီးကော့‑က်ဇာဟှို လောက်ဟှို့တွပ် “သခင်၊ ကိုယ်တော်ဟှာ လူလေရဲ့ စိနှလောင်းဟှို သိဟှားဟှူကြောန့် ဆုတောန်းဂေ့ဇာဟှ ");
INSERT INTO tvn_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ယုဒဟှာ သူ့န ထိုက်တန်ဟှူ နေရာဟှို သွားဟှို့တွပ် ထွပ်ဟှားဟှူကြောန့် ယုဒနေရာမာ တမန်တော်ဖြစ်န မှုတော်ဆောန်ဟှို့တွပ် အယ်လူ နှေ့ယော့‑က်ထဲဟှ ကိုယ်တော် ဝီးကော့‑က်ဟှားဟှူ လူဟှို ပြတော်မူပါ” ဆိုဘီး ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","အယ်ဘီးန အယ်လူ နှေ့ယော့‑က်တွပ် မဲလိဆွဲဘီး ဝီးကော့‑က်ဂေ့ဟှူ ခီမာ မဿိဟှာ တမန်တော် ဆယ့်တပါးနတူးဒူ တမန်တော်ဖြစ် ဝီးကော့‑က်ခံရလေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ပင်တေကုတ္တေပွဲနေ့ ရော့‑က်လာဟှူ ခီမာ ယောင်ကြည်သူလေ ဂူလောင်းဟှာ တနေရာထဲမာ စုနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","အယ်ခီမာ လေပြင်းမှောန်ဒိုင်းသံမျိုး ကောန်းဂန်ဟှနေ ရောက်တရစ် ပေါ်လာဘီးန သူးနို့လေ ထိုင်နေဟှူ အီတအီလောင်းဟှို ပ္လဲ့ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","အယ်ဘီးန သူးနို့ဟှာ ဖြာထွပ်နေဟှူ မီးလျှာလေမျိုးဟှို ဗြင်ရဂေ့ဘီး သူးနို့ထတ်မာ ရှိနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","သူးနို့ ဂူလောင်းဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န ပ္လဲ့နေဘီး ဝိညာဉ်တော်ဟှ သူးနို့လေ ပြောနိုင်ဟှူတိုင်း တခြားဘာသာစကားလေန စဘီးဟှာ ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","အယ်ကာလမာ ကောန်းဂန်အော့‑က် တိုင်းပြည်သီးသီးဟှ ဘုရားသခင်ဟှို ကြော့‑က်ဂေ့ဟှူ ယုဒလူမျိုးလေဟှာ ယေရုရှလင်ဗြို့မာ တဲနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","အယ်သံဟှို ကြားရဟှူ ခီမာ လူအောက်ဂီးဟှာ စုလာဂေ့ဟှယ်။ တဗဲ့တော်လေ ပြောဟှူဇာဟှို သူးနို့ အားလောင်းဟှ သူးနို့ ဘာသာစကားန ကြားရဂေ့ဟှူကြောန့် အံ့ဩဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","သူးနို့ဟှာ အံ့ဩနေဘီး “အယ်မျိုး ပြောနေဂေ့ဟှူ လူလေဟှာ ဂါလိလဲနယ်သားလေမား! ");
INSERT INTO tvn_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","အယ်ဆိုဟှာ နို့လေ ဂူလောင်းဟှာ နို့လေရဲ့ ဘာသာစကားတိုင်း ကြားရဂေ့ဇာဟှ ဖယ်မျိုးနူး။ ");
INSERT INTO tvn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","နို့လေဟှာ ပါသိပြည်၊ မေဒိပြည်၊ ဧလံပြည်၊ မေသောပေါတာမိပြည်၊ ယုဒပြည်၊ ကပ္ပဒေါကိပြည်၊ ပုန္တုပြည်၊ အာရှိပြည်၊ ");
INSERT INTO tvn_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ဖြူဂိပြည်၊ ပံဖုလိပြည်၊ အဲဂုတ္တုပြည်၊ ကုရေနေဗြို့နီး လိဗုနယ်ဟှ ဖြစ်ဟှယ်။ တချို့ဟှ ရောမဗြို့ဟှနေ ရော့‑က်လာဟှူ ");
INSERT INTO tvn_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ယုဒလူမျိုးလေန ယုဒဘာသာဟှို ပ္လောန်းလဲလာဂေ့ဟှူ လူမျိုးခြားလေ ဖြစ်ဂေ့ဟှယ်။ နို့လေ တချို့ဟှ ကရေတေကျွန်းသားန အာရပ်ပြည်သားလေ ဖြစ်ဂေ့ဟှယ်။ အယ်ဘေမဲ့ အယ်လူလေဟှာ ဘုရားသခင်ရဲ့ အံ့ဩဘွယ်မှုတော်ဟှို နို့လေရဲ့ ဘာသာစကားန ပြောဇာဟှို နို့လေ ကြားရဂေ့ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","သူးနို့လေဟှ အံ့ဩတွေဝေဟှားဘီး “အယ်မူဇာဟှ ဖယ်မျိုးနူး” ဆိုဘီး ရှင်းရှင်းပြောနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","အယ်ဘေမဲ့ တခြားလူလေဟှ “အယ်လူလေဟှာ ရစ်မောနေဂေ့ဟှယ်” ဆိုဘီး ရယ်ဇားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","အယ်ဘီးန ပေတရုဟှာ တမန်တော် တဆယ့်တပါးန တူးဒူရပ်ဘီး က္လယ်ဟှူသံန “ယုဒမျိုးသားလေန ယေရုရှလင်ဗြို့မာ နေဟှူလူလေ အယ်မူဇာဟှို နန်းနို့ဟှို ပြောပြမယ်။ ငါ့စကားဟှို နားထောန်ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","အယ်လူလေဟှာ နန်းနို့ထန်နေမျိုး ယစ်မောနေဇာ မှုဟှ။ ခုမှ မိုးလန်းကိုးနာရီဘဲ့ ရှိသေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","အယ်မူဇာဟှာ ပရောဖက်ယောလ ဟောဟှားဇာ ဖြစ်ဟှယ်။ အယ်ပရောဖက်ဟှ” ");
INSERT INTO tvn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘ဘုရားသခင်ဟှ မိန့်တော်မူဟှယ်။ ငါဟှာ နော့‑က်ဆောင်း နေ့ရစ်လေမာ လူလေထတ်ဟှို ငါ့ရဲ့ ဝိညာဉ်တော်ဟှို လောန်းခ္လမယ်။ နန်းနို့ရဲ့ သားမီးလေဟှာ ငါ့ရဲ့ တရားတော်ဟှို ပရောဖက်ဉာဏ်န ဟောပြောဂေ့လေ့မယ်။ လူငယ်လေဟှာ ရူပါရောင်လေဟှို ဗြင်ရဂေ့လေ့မယ်။ ဖိုးသန်ဂီးလေဟှာ အိမတ်လေဟှို မတ်ဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ငါ့ရဲ့ စေခံ ယော့‑က်ကျားလေန မီးမလေထတ်ဟှို ငါ့ရဲ့ ဝိညာဉ်တော်ဟှို လောန်းခ္လမယ်။ အယ်ဘီးဟှာ သူးနို့ဟှ ပရောဖက်ပြုဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ထတ်ကောန်းဂန်မာ နိမိတ်လတ်ခဏာလေန အော့‑က်ရပ် မ္လေဂီးထတ်မာ သွီး၊ မီးလျှံ၊ မီးခိုးလောင်းန အံ့ဩဘွယ်လေဟှို ငါပြမယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","သခင်ဘုရားရဲ့ အံ့ဩဘွယ် ထူးမြတ်ဟှူနေ့ ရော့‑က်လာခန်မာ နေဟှာ မှောန်မိုက်ဟှားဘီး လဟှလည်း သွီးမျိုးဘဲ့ နီဟှားလေ့မယ်။’ ” ");
INSERT INTO tvn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","“‘အယ်ခီမာ ဘုရားသခင်ရဲ့ နာမတော်ဟှို အော်ခေါ်ဂေ့ဟှူ လူတိုင်းဟှာ ကယ်တန်ရှင်းဟှို ခံရဂေ့လေ့မယ်။’ ” ");
INSERT INTO tvn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“ဣသရေလမျိုးသားလေ၊ အယ်စကားလေဟှို နားထောန်ဂေ့! ဘုရားသခင်ဟှာ နာဇရက်ဗြို့သား ယေရှုအားဖြင့် အံ့ဩဘွယ်လေန နိမိတ်လတ်ခဏာလေဟှို ပြတော်မူဟှယ်။ ကိုယ်တော်ဟှာ ဘုရားသခင်ရဲ့ ခွမ့်အာဏာန ပ္လဲ့ဝဟှူလူဖြစ်ဟှယ် ဆိုဇာဟှို ထန်းထန်ရှားရှားဟှာ သတ်သေပြဟှားဟှယ်။ အယ်မူဇာဟှာ နန်းနို့ရှေ့မာ ဖြစ်ဟှားဟှူကြောန့် နန်းနို့ ကိုယ်တိုင် သိရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ဘုရားသခင်ဟှာ သူ့ရဲ့ကြံစည်တော်တိုင်း ယေရှုဟှို နန်းနို့ လတ်ထဲဟှို အပ်လိုက်ဟှယ်။ နန်းနို့ဟှ ကိုယ်တော့်ဟှို အဓမ္မလူလေလတ်န ကားစင်တန်ဘီး သတ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","အယ်ဘေမဲ့ ဘုရားသခင်ဟှ ကိုယ်တော့်ဟှို သေရှင်းတဂိုးဟှနေ လွတ်မြော့‑က်စေဘီး ထမြော့‑က်စေလေဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သေမန်းဟှာ ကိုယ်တော့်ဟှို မြဲဒမ်း ခယ်နှောန်ဟှားဟှို့ ဖြစ်နိုင်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ဒါဝိဒ်ဟှ ကိုယ်တော်ကြောန်းဟှို၊” “ ‘ငါဟှာ သခင်ဘုရားဟှို မြဲဒမ်း ဗြင်ရဟှယ်။ ကိုယ်တော်ဟှာ ငါ့ညာဖတ်မာ ရှိနေဟှူကြောန့် ငါမာ တောင်လှောက်ဇာ မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","အယ်ကြောန့် ငါ့စိနှလောင်းဟှာ ရွှင်လန်းနေဘီး ငါ့ရဲ့ နှောက်ဟှာ ဝန်းသာရှင်းန ပ္လဲ့နေဟှယ်။ ငါ့ရဲ့ ကိုယ်ခန္ဓာဟှာ မျှော်လင့်ရှင်းထဲမာ ငြီသတ်နေမယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကိုယ်တော်ဟှာ ကျွန်တော်ဟှို မရဏာနိုင်ငံမာ ပစ်ဟှားဟှို့ မှုဟှ။ ကိုယ်တော်ရဲ့ သန့်ရှင်းဟှူ လူလေဟှို သန်းခ္လိုင်းထဲမာ ပေါက်ပျစ်စေဟှို့ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ကိုယ်တော်ဟှ ကျွန်တော်ဟှို သတ်ရှင်ဟှူလမ်းလေဟှို ပြပေးဟှယ်။ ကိုယ်တော်ဟှာ ကျွန်တော့်ဟှို ကိုယ်တော်ရဲ့ မျစ်မှော့‑က်တော်ထဲမာ ဝန်းသာဇာန ပ္လဲ့စေလေမယ်’ ” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ညီကိုလေ၊ နို့လေရဲ့ ဘိုးဘေး ဒါဝိဒ်မန်းဂီးကြောန်းဟှို နန်းနို့ဟှို ငါ ရှင်းရှင်းလန်းလန်းဟှား ပြောရှင်ဟှယ်။ သူဟှာ သေလွန်ဘီး သင်္ဂြိုဟ်ဇာဟှို ခံရဟှယ်။ သူ့ရဲ့ သန်းခ္လိုင်းဟှာ အယ်နေ့ထိ နို့လေနတူးဒူ ရှိသေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","သူဟှာ ပရောဖက်ဖြစ်ဘီး သူ့ရဲ့ သားမ္လေးတယော့‑က်ဟှို သူ့ရဲ့ ပလ္လင်ထတ်မာ ထိုင်စေမယ် ဆိုဘီး ဘုရားသခင်ဟှ သူ့ဟှို သစ်စာပြုဘီး ဂဒိပေးဟှားကြောန်းဟှို သိဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","နောင်ခါမာ ဘုရားသခင်ဟှ ဖယ်မျိုးလောက်မယ် ဆိုဇာဟှို သိဟှူကြောန့်” မေရှိယရဲ့ ထမြော့‑က်ရှင်းကြောန်းဟှို “‘ကိုယ်တော့်ဟှို မရဏာနိုင်ငံမာ ပစ်ဟှားဟှ။ သူ့ရဲ့ ခန္ဓာဟှို သန်းခ္လိုင်းထဲမာ ပေါက်ပျစ်စေဟှို့ မှုဟှ’ ” ဆိုဘီး ကြိုတန်ပြောဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ဘုရားသခင်ဟှ အယ်ယေရှုဟှို သေရာဟှနေ ထမြော့‑က်စေတော်မူဟှယ်။ နို့လေ ဂူလောင်းဟှာ အယ်ဖြစ်ပျစ်ရဲ့ သတ်သေဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ကိုယ်တော်ဟှာ ဘုရားသခင်ရဲ့ ညာဖတ်မာ ချီးမြှင့်ဇာခံဘီးန ဂဒိပေးဟှားတိုင်း သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို ဖနားဟှနေ ခံယူလေဟှယ်။ ခု နန်းနို့လေ တွိဗြင်ဘီး ကြားသိဂေ့ဟှူ ဝိညာဉ်တော်ဟှို နို့လေထတ်ဟှို လောန်းခ္လလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ဒါဝိဒ်ဟှာ ကောန်းဂန်ဘောင်ဟှို တတ်ဟှားဇာ မှုဟှ။ အယ်ဘေမဲ့ သူဟှ၊ “ ‘ထာဝရဘုရားဟှ ငါ့သခင်ဟှို ");
INSERT INTO tvn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","နန့်ရဲ့ ရန်သူလေဟှို နန့်ရဲ့ ခေတန်ခေါင်ဖြစ် ငါထားဟှားခီထိ ငါ့ရဲ့ ညာဖတ်မာ ထိုင်နေပါ ဆိုဘီး မိန့်တော်မူဟှားဟှယ်’ ဆိုဘီး ပြောလေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“အယ်ကြောန့် ဣသရေလလူမျိုး ဂူလောင်းဟှာ မေရှိယဖြစ်နရော၊ သခင်ဖြစ်နရော ဘုရားသခင် ခန့်ဟှားဟှူသူဟှို နန်းနို့ ကားစင်တန်လိုက်ဂေ့ဟှူ ယေရှုဘဲ့ဖြစ်ဟှယ် ဆိုဇာဟှို သေးသေချားချာဟှား သိမှတ်ဟှားဂေ့” ဆိုဘီး လူအောက်ဂီးဟှို ဟောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","လူလေဟှာ အယ်စကားဟှို ကြားဂေ့ဟှူ ခီမာ ရရာတိုင်း စိသောက ဖြစ်ဟှားဂေ့ဘီး ပေတရုန တခြားတမန်တော်လေဟှို “ညီကိုလေ၊ နို့လေဟှ ဖယ်မျိုးလောက်ရဟှို့နူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ပေတရုဟှ “နန်းနို့ ပြစ်လေဟှို ခွမ့်လွှတ်ပေးဇာခံရဟှို့တွပ် နောန်ဒရဂေ့ဘီး ယေရှုခရစ်တော်ရဲ့ နာမန နန်းနို့ ယော့‑က်စီတိုင်း ဗတ္တိဇံဟှိုခံဂေ့။ အယ်ဆိုဟှာ နန်းနို့ဟှာ ဆုလတ်ဆောန်ဖြစ် သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို ရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ဘုရားသခင်ရဲ့ ဂဒိတော်ဟှာ နန်းနို့ တွပ်ရော၊ နန်းနို့ သားမီးလေတွပ်ရော၊ ဝီးမာရှိနေဟှူ လူလေတွပ်ရော ဖြစ်ဟှယ်။ တနည်းအားဖြင့်ဆိုဟှာ နို့လေရဲ့ ဘုရားသခင်ခေါ်ဟှားခံရဟှူ လူလေ ဂူလောင်းတွပ်လည်း ဖြစ်ဟှယ်” ဆိုဘီး သူးနို့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ပေတရုဟှာ တခြားစကားဘောန်းဇောင်နလည်း တောန်းဗန်းဘီး “နန်းနို့ ကိုယ်တိုင် အယ်ဆိုးညစ်ဟှူ လူလေထတ်ဟှို ရော့‑က်လာမယ့် ပြစ်ဒန်ဟှနေ ကန်းလွတ်စေဂေ့” ဆိုဘီး သူးနို့ဟှို တိုက်တွန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","လူလေဘောင်ဂီးဟှ သူ့ရဲ့ တရားစကားဟှို ယောင်ကြည်ဂေ့ဘီး ဗတ္တိဇံခံဂေ့ဟှယ်။ အယ်နေ့မာ လူလေဟှာ ၃,၀၀၀ လော့‑က် တိုးပွားဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","အယ်လူလေဟှာ တမန်တော်လေရဲ့ သွန်သန်ဇာဟှို ခံယူဂေ့ဘီး၊ မုဟှိုဖဲ့ဂေ့ဘီး၊ မိတ်သဟာယ ဖွဲ့ဂေ့ဘီးဟှာ ဆုတောန်းဇာလေနဘဲ့ ခီဟှို ကူစေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","တမန်တော်လေဟှာ အံ့ဩဘွယ်ရာလေန နိမိတ်လတ်ခဏာလေဟှို ပြဂေ့ဟှူကြောန့် လူတိုင်းဟှာ ကြော့‑က်လန့်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ယောင်ကြည်သူလေဟှာ တစုဒဲနေဂေ့ဘီးဟှာ သူးနို့ရဲ့ အောက်စာလေဟှို ယော့‑က်နယော့‑က် ဝီမျှဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","သူးနို့ရဲ့ အောက်စာလေန ပိုင်ဆိုင်ဇာလေဟှို ရောန်းဂေ့ဘီးဟှာ လိုအပ်ဟှူ လူလေဟှို ပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","သူးနို့ဟှာ နေ့တိုင်း ဗိမာန်တော်မာ စုနေဂေ့ဟှယ်။ သူးနို့ရဲ့ အီလေမာလည်း မုဟှိုဖဲ့ဂေ့ဘီး စေဒနာစိန ဝန်းသာအားရ စားဇာလေဟှို ဝီမျှဘီး စားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","သူးနို့ဟှာ ဘုရားသခင်ဟှို ချီးမွမ်းဘီး လူလေရှေ့မာလည်း မျစ်နှာသာ ရဂေ့ဟှယ်။ သခင်ဘုရားဟှလည်း ကယ်တန်ရှင်း ခံရဟှူလူလေဟှို နေ့တိုင်း တိုးပွားစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","တနေ့မာ ပေတရုန ယောဟန်လေဟှာ ဆုတောန်းခီဖြစ်ဟှူ နေဒန်ဇာ သောင်းနာရီမာ ဗိမာန်တော်ဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","မွီးဂဒဲဟှ ခေသန်ဘဲဟှူ လူတယော့‑က်ဟှာ တင့်တယ် ဆိုဘီး ခေါ်ဟှူ ခွဗော့‑က်ဝမာ ရှိနေဟှယ်။ ဗိမာန်တော်ဟှို လာဂေ့ဟှူ လူလေနားဟှ ကပ်တောန်းဟှို့တွပ် အယ်လူဟှို နေ့တိုင်း ထမ်းလာဂေ့ဘီး ခွဗော့‑က်ဝမာ ခ္လဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","အယ်လူဟှာ ပေတရုန ယောဟန်လေ ဗိမာန်တော်ထဲဟှို ဝမ်ဟှို့လောက်နေဇာဟှို ဗြင်ဟှူ ခီမာ တခုခုပေးဟှို့တွပ် တောန်းလျှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","သူးနို့ဟှာ အယ်လူဟှို စေ့စေ့ကေ့လေဟှယ်။ အယ်ဘီးန ပေတရုန ယောဟန်ဟှ “နို့လေဟှို ကေ့!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","အယ်ကြောန့် အယ်လူဟှာ သူးနို့နားဟှ တခုခုရမယ်ဆို ထန်ဘီး သူးနို့ဟှို ကေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","အယ်ဘေမဲ့ ပေတရုဟှ “ငါ့မာ ရွှေလည်း မှေ့ဟှ။ ငွေလည်း မှေ့ဟှ။ အယ်ဘေမဲ့ ငါ့မာ ရှိဟှူဇာဟှို နန့်ဟှိုပေးမယ်။ နာဇရက်ဗြို့သား ယေရှုခရစ်တော်ရဲ့ နာမန ထဘီးလမ်းရှော့‑က်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","အယ်ဘီးန သူ့ရဲ့ ညာဖတ်လတ်ဟှို ဆွဲဒန်လေဟှယ်။ ရှစ်ရှင်းဘဲ့ အယ်လူရဲ့ ခေဒေါ့‑က်န ခေမျစ်စိလေဟှာ သန်မာလာဘီး ");
INSERT INTO tvn_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","သူဟှ ထခူဘီး၊ ထရပ်ဘီးဟှာ စဘီးဟှာ လမ်းရှော့‑က်လေဟှယ်။ အယ်ဘီးန သူဟှာ ခူပေါ့‑က်ဘီး၊ ဘုရားသခင်ဟှို ချီးမွမ်းဘီး သူးနို့နတူးဒူး ဗိမာန်တော်ထဲဟှို ဝမ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","အယ်နေရာမာ ရှိနေဟှူ လူလေဟှ လမ်းရှော့‑က်ဘီး ဘုရားသခင်ဟှို ချီးမွမ်းနေဟှူ အယ်လူဟှို ဗြင်ဟှားဟှူ ခီမာ ");
INSERT INTO tvn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","အယ်လူဟှာ ဗိမာန်တော်ရဲ့ တင့်တယ်ခွဗော့‑က်မာ ထိုင်နေဟှူ ဒေါန်းဇားဖြစ်ဟှယ် ဆိုဇာဟှို မှတ်မိဟှားဟှူ ခီမာ သူးနို့ ဂူလောင်းဟှာ အယ်လူမာ ဖြစ်ဟှားဇာလေဟှို အံ့ဩဘီး တွေဝေဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","အယ်လူဟှာ ပေတရုန ယောဟန်လေဟှို ပိုက်နေဒူးမာ လူလေဟှ အံ့ဩဘီးဟှာ ရှောလမုန်ရဲ့ မုခ်ဦးဆောန်နားမာ ရှိနေဟှူ သူးနို့နားဟှို ပ္လေးလာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ပေတရုဟှာ လူလေဟှို ဗြင်ဟှူ ခီမာ “ဣသရေလူမျိုးလေ၊ ဖြားဖြစ်ကြောန့် နန်းနို့ အံ့ဩနေဂေ့ဟှယ်နူး။ ဖြားဖြစ်ကြောန့် နို့လေဟှို စိုက်ကေ့နေဂေ့နူး။ နို့လေရဲ့ တဂိုး၊ နို့လေရဲ့ သီလန အယ်လူဟှို လမ်းရှော့‑က်နိုင်အောန် လောက်ပေးဟှယ် ဆိုဘီး နန်းနို့ ထန်နေဂေ့ဇာလော။ ");
INSERT INTO tvn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","အာဗြဟံ၊ ဣဇာက်၊ ယာကုပ်ရဲ့ ဘုရားသခင်၊ နို့လေ ဘိုးဘေးလေရဲ့ ဘုရားသခင်ဟှာ သူ့ရဲ့ စေခံယေရှုဟှို ဖောင်းသရေတော်ထန်ရှားစေဟှယ်။ ပိလတ်ဟှာ အယ်သခင်ဟှို လွှတ်ပေးဟှို့တွပ် ဆောင်းဖြတ်ဟှယ်။ အယ်ဘေမဲ့လည်း နန်းနို့ဟှာ အယ်သခင်ဟှို အာဏာပိုင်လေဟှို အပ်ဘီး ပိလတ်ရဲ့ ရှေ့မာ ငြင်းပယ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","နန်းနို့ဟှ သန့်ရှင်းဖြောန့်မတ်ဟှူ သခင်ဟှို ငြင်းပယ်ဂေ့ဘီး လူသတ်မားဟှို လွှတ်ပေးဟှို့တွပ် တောန်းဆိုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","နန်းနို့ဟှာ သတ်ပေးပိုင်ဟှူ သူဟှို သတ်ဂေ့ဟှယ်။ အယ်ဘေမဲ့ ဘုရားသခင်ဟှာ အယ်သခင်ဟှို သေရှင်းဟှနေ ထမြော့‑က်စေဟှယ်။ နို့လေဟှာ အယ်ဖြစ်ပျစ်ရဲ့ သတ်သေလေ ဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","အယ်သခင်ရဲ့ နာမတော်တဂိုးန အယ်ခေသန်ဘဲဟှူလူဟှာ သန်စွမ်းလာဟှယ်။ အယ်သခင်ရဲ့ နာမတော်ဟှို ယောင်ကြည်လိုက်ဟှူန ခု နန်းနို့လေ တွိဗြင်ရဂေ့ဟှူ မှုရာလေ ဖြစ်လာဟှယ်။ နန်းနို့လေဟှ ဗြင်ရတိုင်းဘဲ့ ယေရှုဟှို ယောင်ကြည်ရှင်းဟှဘဲ့ အယ်လူဟှို ကျန်းမာလာစေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ညီကိုလေ၊ ခု နန်းနိုဟှာ နန်းနို့လေရဲ့ ခေါန်းဆောန်မျိုးဘဲ့ ကိုယ်လောက်ဇာဟှို ကိုယ်သိဘဲန လောက်ဂေ့ကြောန်းဟှို ငါသိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","အယ်ဘေမဲ့ ခရစ်တော်ဟှာ သေခံရဟှို့ကြောန်းဟှို ပရောဖက်လေ ဂူလောင်းဟှို ဘုရားသခင်ဟှ ဗျာဒိတ်ပေးဟှားဟှယ်။ အယ်မျိုး ဖြစ်လာဇာဟှ အယ်ဗျာဒိတ်တော်ဟှို ပ္လဲ့ဇောင်ဟှို့တွပ် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","အယ်ကြောန့် ဘုရားသခင်ဟှာ နန်းနို့ ပြစ်လေဟှို လွှတ်ပေးနိုင်ဟှို့တွပ်ကြောန့် နောန်ဒရဘီး ပ္လောန်းလဲဂေ့။ အယ်မျိုးလောက်မယ် ဆိုဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ဘုရားသခင်နားဟှနေ ဝိညာဉ်ခွန်အား ရော့‑က်လာဘီး နန်းနို့တွပ် ဝီးကော့‑က်ဟှားဟှူ မေရှိယဖြစ်ဟှူ ယေရှုဟှို နန်းနို့နားဟှို စေလွှတ်လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ရှေးရှေးဟှ သန့်ရှင်းဟှူ ပရောဖက်လေဟှတဆင့် ပေးလိုက်ဟှူ ဘုရားသခင်ရဲ့ ဗျာဒိတ်တော်နညီ ဂူလောင်းဟှို သစ်ပ္လောန်းလဲဟှားဟှူ ကာလရော့‑က်ခန်ထိ အယ်သခင်ဟှာ ကောန်းဂန်ဘောင်မာ ရှိနေမယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","အယ်ကြောန့် မောရှေဟှာ ‘နန်းနို့ရဲ့ ဘုရားသခင် ထာဝရဘုရားဟှာ ငါ့ဟှို စေလွှတ်မျိုးဘဲ့ ပရောဖက်တပါးဟှို နန်းနို့နားဟှို လွှတ်လေ့မယ်။ အယ်သခင်ဟှာ နန်းနို့ရဲ့ ညီကိုလေထဲဟှ ဖြစ်လေ့မယ်။ အယ်သခင် ပြောဇာလေ ဂူလောင်းဟှို နန်းနို့ဟှာ နားထောန်ရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","အယ်ပရောဖက်ရဲ့ စကားဟှို နားထောန်ဘဲ့ဟှူ လူတိုင်းဟှာ ဘုရားသခင်ရဲ့ လူမျိုးတော်ဟှနေ ဖယ်ရှားဘီး ဖျစ်ဆီးခံရလေ့မယ်’ ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ရှမွေလဟှနေစဘီး ဗျာဒိတ်တော်အားဖြင့် ဟောပြောဂေ့ဟှူ တခြားပရောဖက်လေဟှ အယ်နေ့ရစ်လေမာ ဖြစ်ပျစ်မယ့် ကြောန်းရာလေဟှို ကြေညာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ပရောဖက်လေအားဖြင့် ဘုရားသခင်ပေးဟှူ ဂဒိတော်လေဟှာ နန်းနို့တွပ် ဖြစ်ဟှယ်။ နန်းနို့ ဘိုးဘေးလေန ဘုရားသခင် လောက်ဟှားဟှူ ပဋိညာဉ်ဟှလည်း နန်းနို့တွပ် ဖြစ်ဟှယ်။ ဘုရားသခင်ဟှ အာဗြဟံဟှို ‘နန့်ရဲ့ မ္လေးမ္လစ်လေအားဖြင့် လောကသားလေဟှာ ကောန်းဂျီးမင်္ဂလာဟှို ခံစားရလေ့မယ်’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","အယ်ကြောန့် နန်းနို့ဟှာ ကောန်းဘဲဟှူဇာလေဟှို စွန့်ပစ်ဘီး ကောန်းဂျီးခံစားရဟှို့တွပ် ဘုရားသခင်ဟှာ သူ့ရဲ့ စေခံဟှို နန်းနို့နားဟှို စေလွှတ်လိုက်ဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ပေတရုန ယောဟန်လေဟှာ လူလေဟှို ဟောပြောနေဂေ့ခီမာ ယဇ်ပုရောဟိတ်လေ၊ ဗိမာန်တော်ဟှို စောန့်နေဟှူတပ်မှူးန ဇဒ္ဒုကဲလေဟှာ ရော့‑က်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ယေရှုဟှ သေရာဟှနေ ထမြော့‑က်ဟှားဘီ ဆိုဘီး တမန်တော်လေဟှာ သတ်သေပြဘီး ဟောပြောဟှူကြောန့် ဇဒ္ဒုကဲလေဟှ စိဆိုးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","အယ်ကြောန့် သူးနို့လေဟှာ တမန်တော်လေဟှို ဖမ်းဂေ့ဘီး ညဉ့်ခန်းဇာဖြစ်ဟှားကြောန့် နော့‑က်တနေ့ထိ ထောန်ထဲမာ ထားဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","အယ်ဘေမဲ့ တရားစကားဟှို ကြားဂေ့ဟှူ လူဘောင်ဂီးဟှ ကိုယ်တော့်ဟှို ယောင်ကြည်ဂေ့ဟှယ်။ ယောင်ကြည်လာဟှူ လူလေဟှ ၅,၀၀၀ လော့‑က် တိုးပွားလာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","နော့‑က်တနေ့ ရော့‑က်ဟှူ ခီမာ ယုဒခေါန်းဆောန်လေ၊ လူဂီးလေန ကျမ်းတတ်ဆရာလေဟှာ ယေရုရှလင်ဗြို့မာ စုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ယဇ်ပုရောဟိတ်မန်း အန္နတ်န သူ့ရဲ့ မိသားစုဖြစ်ဟှူ ကယာဖ၊ ယောဟန်၊ အာလေဇန္ဒြေုလူလေန တွိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","အယ်လူလေဟှာ သူးနို့ရှေ့မာ တမန်တော်နှေ့ပါးဟှို ရပ်ခိုင်းဘီး “နန်းနို့ဟှ ဖယ်လူရဲ့ တဂိုး၊ ဖယ်လူရဲ့ နာမန အယ်မှုလေဟှို ဖယ်မျိုး လောက်ဂေ့နူး” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","သန့်ရှင်းဟှူဝိညာဉ်တော်န ပ္လဲ့ဝနေဟှူ ပေတရုဟှာ “လူလေရဲ့ ခေါန်းဆောန်လေန လူဂီးလေ၊ ");
INSERT INTO tvn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ခေသန်ဘဲ့ဟှူ လူတယော့‑က်ဟှို ကျိုးပြုကြောန်းန သူဟှာ ကျန်းမာဟှားဇာန ပတ်သတ်ဘီး ခုနို့လေဟှ စစ်ဆေးခံရမယ် ဆိုဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","နာဇရက်ဗြို့သား ယေရှုခရစ်တော်ရဲ့ နာမတော်တဂိုးန အယ်လူဟှာ ခေသန်လာဘီး ခုနန်းနို့ရှေ့မာ ရပ်နေဇာဟှို နန်းနို့န တူးဒူ ဣသရေလလူမျိုးလေ သိမှတ်ဂေ့ပါ။ အယ်သခင်ဟှို နန်းနို့ဟှ ကားစင်တန်ဘေမဲ့ ဘုရားသခင်ဟှ သေရာဟှနေ ထမြော့‑က်စေလေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“ယေရှုဟှ ‘တိုက်ဟှို ဆော့‑က်ဟှူ ခီမာ နန်းနို့ ပယ်ဟှားဟှူက္လော့‑က်ဟှာ ရေးကီးဆောင်းက္လော့‑က် ဖြစ်လာဟှယ်’ ဆိုဘီး ကျမ်းစာဟှ ပြောဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","အယ်သခင်တပါးဘဲ့ ကယ်တန်နိုင်ဟှယ်။ ကောန်းဂန်အော့‑က်ဟှ လောကမာ အယ်သခင်နာမဟှနေ လွဲဘီး နို့လေဟှို ဖယ်လူလည်း ကယ်တန်နိုင်ဟှ” ဆိုဘီး သူးနို့ဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ပေတရုန ယောဟန်လေဟှာ ပညာတတ်လေမှုဘဲန သာမန်လူလေဖြစ်ဘီး ရဲရင့်နေဇာဟှို တရားလွှတ်တော် ဖွဲ့ဝမ်လေဟှ ဗြင်ဂေ့ဟှူ ခီမာ ရရာတိုင်း အံ့ဩနေဂေ့ဟှယ်။ အယ်လူနှေ့ယော့‑က်ဟှာ ယေရှုရဲ့ လောက်ဖော်ဆောန်ဖတ်လေဖြစ်ဇာဟှို ဒိပြုမိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","အယ်ဘေမဲ့ ရောဂါပျော့‑က်ဟှားဟှူ လူဟှာ တမန်တော်လေန တူးဒူ ရပ်နေဇာဟှို ဗြင်ဟှူ ခီမာ သူးနို့ဟှာ ဖယ်မျိုးလည်း ပြောနိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","တမန်တော်လေဟှို တရားလွှတ်တော်ထဲဟှနေ ထွပ်ခိုင်းဘီးဟှာ သူးနို့ရှင်းရှင်း စဘီးဟှာ တိုင်ဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","သူးနို့လေဟှာ “နို့လေဟှ အယ်လူလေဟှို ဖယ်မျိုးလောက်ရဟှို့နူး။ သူးနို့အားဖြင့် ထူးခြားဟှူ နိမိတ်လတ်ခဏာ ဖြစ်ဟှားဇာဟှို ယေရုရှလင်ဗြို့ဟှ လူတိုင်းဟှ သိဂေ့ဟှယ်။ နို့လေဟှ ငြင်းနိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","အယ်ဘေမဲ့ အယ်ဒန်းဟှာ လူလေထဲမာ ပ္လံ့နှံ့ဘဲနေအောန် ယေရှုရဲ့ နာမတော်ဟှို မှီပြုဘီး နော့‑က်ထပ် ဖယ်လူဟှိုလဲ ဟောပြောဘဲနေဟှို့တွပ် အယ်လူနှေ့ယော့‑က်ဟှို ဒိပေးဂေ့မယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","အယ်ဘီးန တမန်တော်လေဟှို ပ္လန်ခေါ်ဘီးဟှာ ယေရှုရဲ့ နာမတော်ဟှို မှီပြုဘီး နော့‑က်ထပ် လောင်းဝ ဟောပြောဘဲနေဟှို့တွပ် မိန့်ပေးလိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ပေတရုန ယောဟန်လေဟှ “နို့လေဟှာ ဘုရားသခင်ရဲ့ စကားဟှို နားထောန်ဇာထတ် နန်းနို့ရဲ့ စကားဟှို နားထောန်ဇာဟှ ဘုရားသခင်ရဲ့ ရှေ့မာ မှန်ဟှယ်၊ မှားဟှယ် ဆိုဇာဟှို နန်းနို့ ကိုယ်တိုင်ဘဲ့ ဆောင်းဖြတ်ပေးဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","နို့လေကိုယ်တိုင် ကြားရ၊ ဗြင်ရဇာလေဟှို ဟောပြောဘဲန နေနိုင်ဟှ” ဆိုဘီး ပ္လန်ပြောလိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","အယ်ကြောန့် တရားလွှတ်တော် ဖွဲ့ဝမ်လေဟှာ သူးနို့ဟှို ပ္လန်ဘီးဟှာ သေးသေချားချာဟှား ဒိပေးဘီးန ထွပ်ခိုင်းလိုက်ဂေ့ဟှယ်။ လူလေဟှာ ဖြစ်ပျစ်ဟှူ ဇာလေတွပ် ဘုရားသခင်ရဲ့ ဖောင်းသရေတော်ဟှို ချီးမွမ်းနေဂေ့ဟှူကြောန့် တမန်တော်လေဟှို ဖြားပြစ်ဒန်လည်း စီရင်နိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","အံ့ဩဘွယ်ကောန်းအောန် ရောဂါပျော့‑က်ဟှားဟှူလူဟှာ သတ်လေးဆယ်ကျော်လော့‑က် ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ပေတရုန ယောဟန်လေဟှာ လွတ်မြော့‑က်လာဂေ့ဟှူ ခီမာ သူးနို့ လူလေနားဟှို ပ္လန်ဟှားဘီးန ယဇ်ပုရောဟိတ်ဂီးန သတ်ကီးဝါဂီးလေ ပြောလိုက်ဇာလေဟှို ပ္လန်ဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","အယ်ကြောန်းဟှို ကြားရဂေ့ဟှူ ခီမာ အယ်လူလေဟှာ တူးဒူ ဆုတောန်းဂေ့ဟှယ်။ “စိုးရဟှူသခင်၊ ကိုယ်တော်ဟှ ကောန်းဂန်န မ္လေဂီး၊ ပန်လယ်န ရှိမျှဂူလောင်းဟှိုလည်း ဖန်ဆင်းဟှူ ဘုရားသခင် ဖြစ်ဟှယ်! ");
INSERT INTO tvn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ကိုယ်တော်ဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်အားဖြင့် ကိုယ်တော်ရဲ့ စေခံ၊ ကျွန်တော့်လေ ဘိုးဘေး ဒါဝိဒ်ဟှနေ တဆင့်၊” “ ‘လူမျိုးခြားလေဟှာ ဖြားဖြစ်ကြောန့် ရောင်းရင်းဆန်ခတ် ဖြစ်နေဂေ့နူး’ ” လူမျိုးဘောန်းဇောင်ဟှာ ဖြားဖြစ်ကြောန့် ကျိုးမှေ့ဘဲန ကြံစည်ဂေ့နူး။ ");
INSERT INTO tvn_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","လောကရဲ့ မန်းဂီးလေန အောက်ချောက်မားလေဟှာ ဘုရားသခင်ဟှို ပေါင်ကန်ဟှို့တွပ် ပြင်ဆင်ဂေ့ဟှယ်။ ဘုရားသခင်န ကိုယ်တော်ရဲ့ မေရှိယဟှို ဆန့်ကျင်ဟှို့တွပ် စုဂေ့ဟှယ်၊ ဆိုဘီး မိန့်တော်မူဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","မှန်တိုင်းဆိုဟှာ ဟေရုဒ်န ပုန္တိပိလတ်လေဟှာ လူမျိုးခြားလေ၊ ဣသရေလလူမျိုးလေန တူးဒူ ကိုယ်တော်ရဲ့ သန့်ရှင်းဟှူစေခံ၊ ကိုယ်တော်ဘိသိပေးဟှူ ယေရှုဟှို ဆန့်ကျင်ဟှို့တွပ် အယ်ဗြို့ထဲမာ စုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","အယ်မျိုး စုဂေ့ဇာဟှာ ကိုယ်တော်ရဲ့ တဂိုးတော်န လိုတော်ရ ခွဲခန့်ဟှားဇာလေဟှို ဖြစ်ပျစ်ဟှို့တွပ် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","သခင်၊ ခု အယ်လူလေရဲ့ ချီးခြော့‑က်ဟှူဇာဟှို မှတ်ဟှားပေးပါ။ ကိုယ်တော်ရဲ့ စေခံလေဟှို ကိုယ်တော်ရဲ့ တရားတော်ဟှို ရဲရဲရင့်ရင့်ဟှား ဟောဟှို့ခွမ့် ပေးတော်မူပါ။ ");
INSERT INTO tvn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","လူလေရဲ့ ရောဂါလေဟှို ပျော့‑က်စေဟှို့တွပ် ကိုယ်တော်ရဲ့ လတ်တော်ဟှို ဆန့်တော်မူပါ။ ကိုယ်တော်ရဲ့ သန့်ရှင်းဟှူစေခံ ယေရှုရဲ့ နာမတော်န နိမိတ်လတ်ခဏာန အံ့ဩဘွယ်ရာလေဟှို လောက်တော်မူပါ။ ");
INSERT INTO tvn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","အယ်မျိုး ဆုတောန်းဂေ့ဘီးခီမာ သူးနို့ စည်းဝေးနေရာဟှာ လှောက်လာဟှယ်။ သူးနို့ ဂူလောင်းဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န ပ္လဲ့ဝဘီး ဘုရားသခင်ရဲ့ တရားတော်ဟှို ရဲရဲရင့်ရင့်ဟှား ဟောပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ယောင်ကြည်သူလေဟှာ စိနှလောင်း တလောင်းတဝဒဲ ဖြစ်ဂေ့ဟှူကြောန့် ဖယ်လူလဲ ကိုယ့်ရဲ့ အောက်စာဟှို ကိုယ်ပိုင်ဟှယ် ဆိုဘီး ပြောဂေ့ဟှ။ သူးနို့မာ ရှိနေဟှူ အောက်စာလေ ဂူလောင်းဟှို ပိုင်ဂေ့ဟှယ် ဆိုဘီး ကြေညာဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","တမန်တော်လေဟှာ သခင်ယေရှုခရစ်တော်ရဲ့ ရှင်ပ္လန်ထမြော့‑က်ရှင်းကြောန်းဟှို ကီးမားဟှူ တဂိုးန သတ်သေခံဂေ့ဟှယ်။ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟှာ ကီးမားဟှူ တဂိုးန သူးနို့ ဂူလောင်းထဲမာ လောက်လောက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","လယ်လေ၊ အီလေ ပိုင်ဂေ့ဟှူ လူလေဟှာ သူးနို့ အောက်စာလေဟှို ရောန်းခ္လဘီး၊ ရဟှူကပ်လေဟှို ယူလာဘီးဟှာ တမန်တော်လေဟှို ပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","အယ်ဘီးန တမန်တော်လေဟှာ လိုအပ်ဟှူ လူလေဟှို လိုက်ဝီပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ယောသပ် ဆိုဘီး ခေါ်ဟှူ လူတယော့‑က်ရှိဟှယ်။ သူ့ဟှို တမန်တော်လေဟှ ဗာနဗ ဆိုဘီး ခေါ်ဂေ့ဟှယ်။ ဗာနဗရဲ့ ဓိပါယ်ဟှ အားပေးကူညီဟှူလူ ဆိုဘီး ခေါ်ဟှယ်။ သူဟှာ ကုရေနေနယ်သား လေဝိမျိုးနွယ် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","သူပိုင်ဟှူ လယ်ဂွပ်ဟှို ရောန်းဘီးဟှာ ရဟှူကပ်ဟှို ယူလာဘီးန တမန်တော်လေဟှို ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","အာနနိနာမယ်ရှိဟှူ လူတယော့‑က်ဟှာ သူ့ရဲ့မယား ရှာဖိရေနတူးဒူ သူးနို့ ပိုင်ဟှူမ္လေဟှို ရောန်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","အယ်ဘီးန အာနနိဟှာ ရောန်းရဟှူ ကပ်တဝပ်ဟှို သူ့ရဲ့မယားန ဘောတူဘီးဟှာ သူးနို့တွပ် ဖယ်ဟှားဘီးဟှာ ကျန်ဟှူကပ်လေဟှိုဘဲ့ တမန်တော်လေဟှို ပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ပေတရုဟှ “အာနနိ၊ နန်ဟှာ လယ်ဟှိုရောန်းရဟှူ ကပ်တဝပ်ဟှို နန်းနို့တွပ် ဖယ်ဟှားဘီး ဖြားဖြစ်ကြောန့် သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို လှည့်ဇားနူး။ ဖြားဖြစ်ကြောန့် စာတန်ဟှို နန်းနို့ စိနှလောင်းဟှို အောက်စိုးခွမ့်ပေးနူး။ ");
INSERT INTO tvn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","နန်ဟှာ အယ်လယ်ဟှို ရောန်းခန်ဒူးဟှ နန်းနို့ပိုင်ဟှယ် မှုဟှာလော။ ရောန်းလိုက်ဘီး နော့‑က်မာလည်း အယ်ကပ်လေဟှို နန်ပိုင်ဟှယ် မှုဟှလော။ ဖြားဖြစ်ကြောန့် စိနှလောင်းထဲမာ အယ်မျိုး ကြံစည်ဂေ့နူး။ နန်ဟှာ လူလေဟှိုဘဲ့ လှည့်ဇားဇာ မှုဟှ။ ဘုရားသခင်ဟှိုလည်း လှည့်ဇားဟှယ်!” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","အယ်စကားဟှို ကြားန အာနနိဟှ လဲက္လဘီး သေဟှားဟှယ်။ အယ်ကြောန်းဟှို ကြားဂေ့ဟှူလူလေဟှာ ရရာတိုင်း ကြော့‑က်လန့်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","လူငယ်လေဟှာ လာဘီးဟှာ အာနနိရဲ့ လောန်းဟှို ဝတ်နပတ်ဘီး ပ္လန်ဟှို ယူဟှားဘီး သင်္ဂြိုဟ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","သောင်းနာရီလော့‑က် ကြာဘီးန အာနနိရဲ့ မယားဟှ ဖြစ်ပျစ်ဟှားဟှူဇာလေဟှို သိဘဲန ရော့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ပေတရုဟှ “နန်းနို့ဟှာ လယ်ဟှို အယ်မျှနဘဲ့ ရောန်းလော” ဆိုဘီး မေးလေဟှယ်။ အယ်မီးမဟှ “ဟုတ်ဟှယ်။ အယ်မျှနဘဲ့ ရောန်းဟှယ်” ဆိုဘီး ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ပေတရုဟှ “သခင်ဘုရားရဲ့ ဝိညာဉ်တော်ဟှို သွီးတိုးစမ်းဟှို့တွပ် ဖြားဖြစ်ကြောန့် နန်းနို့ဟှာ ဘောတူဂေ့နူး။ ကေ့ကေ့၊ နန့်ယော့‑က်ကျားဟှို သင်္ဂြိုဟ်ဘီး ပ္လန်လာဟှူလူလေဟှာ ခွဗော့‑က်မာ ရှိနေဂေ့ဟှယ်။ သူးနို့ဟှာ နန့်ဟှိုလည်း သယ်ဟှားလေ့မယ်!” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ရှစ်ရှင်းဘဲ့ အယ်မီးမဟှာ ပေတရုရဲ့ ခေရင်းမာ လဲက္လဘီးဟှာ သေဟှားဟှယ်။ လူငယ်လေဟှ ရော့‑က်လာဂေ့ဟှူ ခီမာ အယ်မီးမဟှာ သေနေဇာဟှို တွိဟှားဟှူကြောန့် အယ်မီးမရဲ့ လောန်းဟှို ယူဟှားဘီးန သူ့ယော့‑က်ကျားနားမာ သင်္ဂြိုဟ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","သင်းတော်တခုလောင်းန အယ်ကြောန်းဟှို ကြားဂေ့ဟှူ လူလေဟှာ ရရာတိုင်း ကြော့‑က်လန့်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","တမန်တော်လေဟှာ လူလေရှေ့မာ အံ့ဩဘွယ်ရာလေန နိမိတ်လတ်ခဏာလေဟှို ပြဂေ့ဟှယ်။ ယောင်ကြည်သူလေဟှာ ရှောလမုန်ရဲ့ မုခ်ဦးဆောန်မာ စုနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","လူလေဟှာ သူးနို့ဟှို ချီးကျူးဂေ့ဘေမဲ့ ဖယ်လူလည်း သူးနို့ဟှို ပေါန်းသင်းရဲဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","အယ်ဘေမဲ့ သခင်ဘုရားဟှို ယောင်ကြည်ဟှူ ယော့‑က်ကျားလေန မီးမလေဟှာ ဘောင်ဂီးဖြစ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","လူလေဟှ နေကောန်းဘဲ့ဟှူ လူလေဟှို ခေါ်လာဂေ့ဟှယ်။ ပေတရု ဖြတ်ရှော့‑က်ဟှူ ခီမာ သူ့ရဲ့ရိဟှာ လူနာလေထတ်ဟှို က္လဟှို့တွပ် လူနာလေဟှို အိယာလေ၊ ထမ်းစင်လေန သယ်လာဂေ့ဘီး လမ်းမထတ်မာ ခ္လဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ယေရုရှလင်ဗြို့ ပတ်ပတ်လယ်ဟှ ဗြို့လေဟှ လူလေဟှာ ဖျားနေဟှူလူလေ၊ နတ်ဆိုးဝမ်ပူးနေဟှူ လူလေဟှို ခေါ်လာဂေ့ဟှယ်။ အယ်လူနာလေ ဂူလောင်းဟှာ ရောဂါပျော့‑က်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","အယ်ခီမာ ယဇ်ပုရောဟိတ်မန်းန သူ့ရဲ့ နော့‑က်လိုက်လေဖြစ်ဟှူ ဇဒ္ဒုကဲ ဂိုဏ်းဝမ်လေဟှာ တမန်တော်လေဟှို ရရာတိုင်း နာလိုဝန်တိုစိ ရှိလာဂေ့ဟှူကြောန့် သူးနို့လေဟှို ရေးယူဟှို့တွပ် ဆောင်းဖြတ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","သူးနို့ဟှာ တမန်တော်လေဟှို ဖမ်းဘီးဟှာ ပြည်သူ့ ကျဉ်းထောန်ထဲမာ ထားဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","အယ်ဘေမဲ့ အယ်ညဉ့်မာ သခင်ဘုရားရဲ့ ကောန်းဂန်တမန်တပါးဟှာ ထောန်ခွဗော့‑က်လေဟှို ဖွမ့်ဘီး တမန်တော်လေဟှို ခေါ်ထုဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“သွားဘီး ဗိမာန်တော်ထဲမာရပ်ဘီး အယ်သတ်ရှင်ရှင်းန ဆိုင်ဟှူဇာလေ ဂူလောင်းဟှို လူလေဟှို ဟောပြောဂေ့ပါ” ဆိုဘီး သူးနို့ဟှို ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","တမန်တော်လေဟှာ ကောန်းဂန်တမန်ရဲ့ စကားဟှို နားထောန်ဘီး မိုးလန်းစောစောမာ ဗိမာန်တော်ထဲဟှို ဝမ်ဘီးဟှာ ဟောပြောဂေ့ဟှယ်။ ယဇ်ပုရောဟိတ်မန်းန သူ့ပေါန်းဖော်လေဟှာ ဣသရေလလူမျိုး သတ်ကီးဟှူလူလေ ဂူလောင်းဟှို တရားလွှတ်တော်စည်းဝေးမာ စုလာဟှို့ ခေါ်ဂေ့ဟှယ်။ အယ်ဘီးန တမန်တော်လေဟှို ခေါ်ဆောန်လာဟှို့တွပ် စောန့်တပ်သားလေဟှို ကျဉ်းထောန်ဟှို စေလွှတ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ရာရှိလေဟှာ ရော့‑က်ဟှားဟှူ ခီမာ တမန်တော်လေဟှို တွိဂေ့ဟှမ်း။ အယ်ကြောန့် သူးနို့ဟှာ တရားလွှတ်တော်ဟှို ပ္လန်လာဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ကျွန်တော့်ဟှားလေဟှာ ထောန်ဟှို ရော့‑က်ဟှားခီမာ သေးသေချားချာ ပိဟှားဘီး စောန့်တပ်သားလေဟှလည်း ခွဗော့‑က်လေမာ ရပ်နေဇာဟှို တွိဂေ့ဟှယ်။ အယ်ဘေမဲ့ ခွဗော့‑က်လေဟှို ဖွမ့်လိုက်ဟှူ ခီမာ ထဲမာ ဖယ်လူဟှိုလည်း တွိဂေ့ဟှ!” ဆိုဘီး စီရင်ခံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","အယ်စကားဟှို ကြားဟှူ ခီမာ ဗိမာန်တော်စောန့် တပ်မှူးန ယဇ်ပုရောဟိတ်ဂီးလေဟှာ တမန်တော်လေမာ ဖြစ်ပျစ်ဟှားဇာဟှို အံ့ဩဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","အယ်ခီမာ လူတယော့‑က်ဟှ ရော့‑က်လာဘီး “နားထောန်ဂေ့! ကျဉ်းခ္လဟှားဟှူ လူလေဟှာ ဗိမာန်တော်ထဲမာ ရပ်ဘီး လူလေဟှို သွန်သန်နေဂေ့ဟှယ်!” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","အယ်ကြောန့် ရာရှိဟှာ သူ့လူလေနသွားဘီး တမန်တော်လေဟှို ပ္လန်ခေါ်လာဂေ့ဟှယ်။ အယ်ဘေမဲ့လည်း သူးနို့ဟှို လူလေဟှ က္လော့‑က်ခဲနပစ် ဇာဟှို စိုးရိမ်ဟှူကြောန့် တမန်တော်လေဟှို နိုင်ထတ်စီးနန်း လောက်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","တမန်တော်လေဟှို ခေါ်လာဘီးန တရားလွှတ်တော်ရှေ့မာ ရပ်ခိုင်းလိုက်ဟှယ်။ ယဇ်ပုရောဟိတ်မန်းဟှာ တမန်တော်လေဟှို စစ်ဆေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","သူးနို့ဟှ “အယ်လူရဲ့နာမဟှို ဟောပြောဘဲနေဟှို့တွပ် နန်းနို့ဟှို တင်းတင်းကျပ်ကျပ်ဟှား မိန့်ပေးဟှားဟှယ်! အယ်ဘေမဲ့ နန်းနို့ဟှာ ယေရုရှလင်တဗြို့လောင်း နန်းနို့လေရဲ့ သွန်သန်ဇာလေဟှို ပ္လံ့နှံ့စေဘီး အယ်လူရဲ့ သွီးဟှိုလည်း နို့လေထတ်ဟှို က္လစေဟှို့တွပ် ကြံစည်ဂေ့ဟှယ်!” ဆိုဘီး တမန်တော်လေဟှို ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ပေတရုန တမန်တော်လေဟှ “နို့လေဟှာ လူရဲ့ စကားထတ် ဘုရားသခင်ရဲ့ စကားဟှို နားထောန်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","နို့လေ ဘိုးဘေလေရဲ့ ဘုရားသခင်ဟှာ လတ်ဝါးကပ်တိုင်မာ နန်းနို့ သတ်လိုက်ဟှူ ယေရှုဟှို ထမြော့‑က်စေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ဣသရေလလူမျိုးလေဟှာ နောန်ဒရဘီး သူးနို့ ပြစ်လေဟှို ဖြေလွှတ်ပေးဟှို့တွပ် ဘုရားသခင်ဟှာ အယ်သခင်ဟှို သူ့ရဲ့ ညာဖတ်မာ ထားဟှားဘီးဟှာ ခေါန်းဆောန်န ကယ်တန်ရှင်းဖြစ် ချီးမြှော့‑က်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","အယ်မူဇာလေတွပ် နို့လေဟှာ သတ်သေလေ ဖြစ်ဂေ့ဟှယ်။ ဘုရားသခင်ရဲ့ စကားဟှို နာခံဟှူလူလေဟှို ပေးတော်မူဟှူ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှလည်း သတ်သေ ဖြစ်ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","တရားလွှတ်တော် ဖွဲ့ဝမ်လေဟှာ အယ်စကားဟှို ကြားဂေ့ဟှူ ခီမာ ရရာတိုင်း ဒေါသထွပ်ဂေ့ဘီး တမန်တော်လေဟှို သေဒန် ပေးရှင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","အယ်ခီမာ လူလေဟှို ရရာတိုင်း ရိုသေလေးစားရဟှူ၊ ကျမ်းတတ်ဆရာဖြစ်ဟှူ၊ ဂါမလျေလ နာမယ်ရှိဟှူ ဖာရိရှဲတယော့‑က်ဟှ တရားလွှတ်တော်မာ ထရပ်ဘီးဟှာ တမန်တော်လေဟှို ပ္လန်ဟှို ရှစ်ဟှား ခေါ်ထုဟှားဟှို့ မိန့်ပေးလိုက်ဘီးန ");
INSERT INTO tvn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","“ဣသရေလလူမျိုးလေ၊ အယ်လူလေဟှို ဖယ်မျိုးလောက်မယ် ဆိုဇာဟှို ဒိန ဆင်ခြင်ဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","တခီဒူးဟှ သုဒနာမယ်ရှိဟှူ လူတယော့‑က်ဟှာ ပေါ်လာဘီး သူ့ကိုယ်သူ ရေးပါရာရော့‑က်ဟှူ လူဖြစ်ဟှယ် ဆိုဟှူကြောန့် သူ့နော့‑က်ဟှိုလိုက်ဟှူ သူလေဟှာ ၄၀၀ လော့‑က်ရှိလာဟှယ်။ အယ်ဘေမဲ့ သူသတ်ခံရဘီးန သူ့ဟှိုယောင်ကြည်ဟှူလေဟှာ ဖ္လဲဖ္လဲစင်ဖြစ်ဟှားဘီး သူ့ရဲ့လှောက်ရှားမှုလည်း ပျော့‑က်ကွယ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","အယ်ဘီးန သန်းဂေါန်စာရင်းကော့‑က်ဟှူ ခီမာ ဂါလိလဲနယ်သား ယုဒဟှာ ပေါ်လာဘီး လူလေဟှာ သူ့ဟှို အားကိုးလာအောန် စည်းရောင်းလေဟှယ်။ သူလည်းဘဲ့ သတ်ခံရဘီးန သူ့ဟှို ကိုးစားဟှူ လူလေဟှာ ဖ္လဲဖ္လဲစင် ဖြစ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ခုကိစမာလည်း နန်းနို့ဟှို ငါပြောမယ်။ အယ်လူလေဟှို ရေးယူဂေ့န။ သူးနို့ဇာသူးနို့ နေပါစေ! သူးနို့ ကြံစည်ဘီး လောက်ဟှူဇာဟှာ လူဟှဖြစ်လာဟှယ် ဆိုဟှာ အယ်ကိစဟှာ ပျစ်ရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","အယ်ဘေမဲ့ ဘုရားသခင်ဟှနေ ဖြစ်လာဟှူ ကြံစည်ဆိုဟှာ အယ်လူလေဟှို နန်းနို့ တားဆီးနိုင်ဟှ။ နော့‑က်ဘီး ဘုရားသခင်ဟှို ဆန့်ကျင်မျိုးဘဲ့ ဖြစ်ဟှားနိုင်ဟှယ်!” ဆိုဘီး ပြောဟှယ်။ ယုဒ တရားလွှတ်တော်ဟှာ ဂါမလျေလရဲ့ ကြံဉာဏ်ဟှို နားထောန်ဂေ့လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","သူးနို့ဟှ တမန်တော်လေဟှို ခေါ်ဘီး ကီဒန်ပေးဘီးန “ယေရှုနာမဟှို မှီပြုဘီး ဟောပြောဇာဟှို နော့‑က်တခါလောက်န” ဆိုဘီး မိန့်ပေးဘီး လွှတ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","တမန်တော်လေဟှာ ယေရှုရဲ့ နာမတော်တွပ် ရှစ်ကွဲခံရဟှူဇာဟှာ ထိုက်တန်ဟှယ် ဆိုဘီး ဘုရားသခင်သတ်မှတ်ဟှားကြောန့် ဝန်းသာအားရန တရားလွှတ်တော်ဟှနေ ထွပ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","အယ်ဘီးန သူးနို့ဟှာ နေ့တိုင်း ဗိမာန်တော်မာရော၊ လူလေရဲ့ အီမာရော ယေရှုဟှာ မေရှိယဖြစ်ဟှူကြောန်း ဒန်းကောန်းဟှို ဆစ်ဘီးဟှာ ဟောပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","အယ်နေ့ရစ်လေမာ တဗဲ့တော်လေဟှာ ဘောင်ဂီးဖြစ်လာဘီး ဟေလသစကားပြောဟှူ ယုဒလူလေန ဒေသခံ ယုဒလူလေဟှာ ရန်ဖြစ်ဂေ့ဟှယ်။ ဟေလသစကားပြောဟှူ ယုဒလူလေဟှ သူးနို့ရဲ့ မောက်ဆိုးမလေဟှို ကူညီဘဲထားဟှားဟှယ် ဆိုဘီး ယုဒလူလေဟှို ပြစ်တန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","အယ်ကြောန့် တမန်တော် ဆယ့်နှေ့ပါးဟှာ တဗဲ့တော်လေဟှို ခေါ်ဘီးန “နို့လေဟှာ ဘုရားသခင်ရဲ့ စကားတော်ဟှို ဟောပြောဘဲန ဗွဲမာစေခံနေမယ် ဆိုဟှာ ကောန်းဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ညီကို မောန်နှမလေ၊ နန်းနို့ထဲမာ သန့်ရှင်းဟှူဝိညာဉ်တော်နရော၊ ဉာဏ်ပညာနရော ပ္လဲ့ဝဘီးဟှာ အသရေရှိဟှူလူ ခွန်နစ်ယော့‑က်ဟှို ဝီးဂေ့ပါ။ နို့လေဟှာ အယ်လူလေဟှို အယ်တာဝန်တွပ် ခန့်ဟှားဟှို့တွပ် ထော့‑က်ခံမယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","နို့လေဟှ ဆုတောန်းဇာ၊ တရားဟောဇာလေဟှို လောက်ဆောန်ဇာနဘဲ့ ခီဟှိုကူစေမယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","တမန်တော်လေရဲ့ကြံဟှို တဗဲ့တော်လေဟှ ကြိုက်ဂေ့ဟှယ်။ အယ်ကြောန့် သူးနို့ဟှာ ယောင်ကြည်ရှင်းနရော၊ သန့်ရှင်းဟှူဝိညာဉ်တော်နရော ပ္လဲ့ဝဟှူ သတေဖန်န ဖိလိပ္ပု၊ ပြောခေါ်၊ နိကနော်၊ တိမုန်၊ ပါမေနန ယုဒဘာသာဟှို ပ္လောန်းလဲလာဟှူ အန္တိအုတ်ဗြို့သား နိကောလလေဟှို ဝီးကော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","သူးနို့ဟှာ အယ်လူလေဟှို တမန်တော်လေရှေ့ဟှို သွားခိုင်းလိုက်ဂေ့ဟှယ်။ အယ်ဘီးန တမန်တော်လေဟှာ ဆုတောန်းဘီးန သူးနို့ထတ်မာ လတ်ဟှိုတန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ဘုရားသခင်ရဲ့ စကားတော်ဟှာ ဆစ်ဘီး ပ္လံ့နှံ့ဟှားဟှယ်။ ယေရုရှလင်ဗြို့မာ တဗဲ့တော်လေရဲ့ ရေတွပ်ဟှာ ရရာတိုင်းတိုးပွားလာဟှယ်။ ယဇ်ပုရောဟိတ်လေ ဘောင်ဂီးလည်း ဒန်းကောန်းဟှို ယောင်ကြည်ဘီး လတ်ခံလာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","သတေဖန်ဟှာ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်နရော၊ တဂိုးတော်နရော ပ္လဲ့ဝဘီး ရရာတိုင်းကီးဟှူ အံ့ဩဘွယ်လေန နိမိတ်လတ်ခဏာလေဟှို လူလေရှေ့မာ ပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","အယ်ခီမာ ကုရေနေန အာလေဇန္ဒြိယဗြို့ဟှ ယုဒလူလေန လွတ်လပ်ဟှူလူလေရဲ့ ဝါလယ်ဇရပ်ရဲ့ ဖွဲ့ဝမ်တချို့ဟှာ သူ့ဟှို ပြဿနာရှာဂေ့ဟှယ်။ အယ်လူလေနတူးဒူ ကိလိကိပြည်န အာရှိပြည်ဟှ ယုဒလူတချို့ဟှာ သတေဖန်န စဘီးဂြင်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","အယ်ဘေမဲ့ သတေဖန်ဟှာ ဝိညာဉ်တော်ပေးဟှားဟှူ ဉာဏ်ပညာန ပြောဟှူ ခီမာ အယ်လူလေဟှာ သူ့ဟှို ချေပနိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","အယ်ကြောန့် သူးနို့ဟှာ လူလေဟှို “အယ်လူဟှာ မောရှေဟှိုရော၊ ဘုရားသခင်ဟှိုရော စော်ကားဘီး ပြောနေဇာဟှို နို့လေကြားဟှယ်” ဆိုဘီး ပြောဟှို့တွပ် လာဘ်ထိုးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","အယ်မျိုးဘဲ့ သူးနို့ဟှာ သတ်ကီးဝါဂီးလေ၊ ကျမ်းတတ်ဆရာလေန လူထုဟှို နှိုးဆော်ပေးဂေ့ဟှယ်။ အယ်လူလေဟှာ သတေဖန်ဟှို ဖမ်းဘီးဟှာ တရားလွှတ်တော်ဟှို ခေါ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","အယ်ဘီးန သူးနို့ဟှာ မှန်ဘဲ့ဟှူ သတ်သေလေဟှို ခေါ်လာဂေ့ဟှယ်။ သတ်သေခံဟှူလူလေဟှ “အယ်လူဟှာ သန့်ရှင်းဟှူဗိမာန်တော်န မောရှေရဲ့ ပညတ်တရားဟှို ဆန့်ကျင်ဘီးဟှာ မြဲဒမ်းပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","နာဇရက်ဗြို့သား ယေရှုဟှာ ဗိမာန်တော်ဟှို ဖြိုခ္လဘီး ကျွန်တော့်ဟှားလေဟှို မောရှေပေးဟှားဟှူ ထောင်းဒန်းစဉ်လာလေဟှို ပ္လောန်းလဲစေမယ် ဆိုဘီး အယ်လူပြောနေဇာဟှို ကျွန်တော့်ဟှားလေ ကြားဂေ့ဟှယ်” ဆိုဘီး ထွပ်ဆိုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","တရားလွှတ်တော်မာ ထိုင်နေဂေ့ဟှူ လူလေ ဂူလောင်းဟှ သတေဖန်ဟှို စေ့စေ့ကေ့ဟှူ ခီမာ သူ့မျစ်နှာဟှာ ကောန်းဂန်တမန်ရဲ့ မျစ်နှာမျိုး ဖြစ်နေဟှယ် ဆိုဇာဟှို တွိဗြင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","အယ်ခီမာ ယဇ်ပုရောဟိတ်မန်းဟှ “အယ်စွပ်စွဲချစ်ဟှာ မှန်ဘဲ့လော” ဆိုဘီး သတေဖန်ဟှို မေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","သတေဖန်ဟှ “ညီကိုလေန ဖလေ၊ ငါ့စကားဟှို နားထောန်ဂေ့ပါ။ နို့လေရဲ့ဖ အာဗြဟံဟှာ ခါရန်ဗြို့မာ နေဟှို့တွပ် သွားခန်မာ မေသောပေါတာမိပြည်မာ ရှိနေဒူးမာ ဘုရားသခင်ရဲ့ ဖောင်းသရေတော်ဟှာ သူ့နားမာ ပေါ်လာဘီး ");
INSERT INTO tvn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ဘုရားသခင်ဟှ ‘နန့်ရဲ့ ပြည်န နန့်ရဲ့ မိသားစုဟှို ထားရစ်ဘီးဟှာ ငါပြဟှူ ပြည်ဟှို သွားပါ’ ဆိုဘီး သူ့ဟှို မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","အယ်ကြောန့် အာဗြဟံဟှာ ခါလဒဲပြည်ဟှနေ ထွပ်လာဘီး ခါရန်ဗြို့မာ နေဟှို့တွပ် သွားလေဟှယ်။ သူ့ဖ သေဟှားဘီးန အယ်ဗြို့ဟှနေ ခု နန်းနို့ နေဟှူပြည်ဟှို ဘုရားသခင်ဟှ ပ္လောန်းခိုင်းလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","အယ်ဘီးန ဘုရားသခင်ဟှာ အာဗြဟံဟှို အယ်ပြည်မာ ခေခ္လဟှို့ နေရာဟှိုမျှ ပေးဟှ။ အယ်ဘေမဲ့ သူကိုယ်တိုင်န သူ့ရဲ့ သားမ္လေးလေဟှို အယ်ပြည်ဟှို ပိုင်ပေးမယ် ဆိုဘီး ဂဒိပေးလေဟှယ်။ ဘုရားသခင်ဟှာ အယ်မျိုး ဂဒိပေးဟှူ ခီဒူးဟှ အာဗြဟံမာ သားမီးလေ မှေ့သေးဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ဘုရားသခင်ဟှ အာဗြဟံဟှို ‘နန့်ရဲ့ မ္လေးမ္လစ်လေဟှာ နိုင်ငံရပ်ခြားမာ နေရဂေ့လေ့မယ်။ အယ်နိုင်ငံဟှ လူလေဟှာ သူးနို့ဟှို ကျွန်ခံစေဘီးဟှာ နှစ်ပေါန်း ၄၀၀ လောင်းလောင်း ညှဉ်းဆဲဇာဟှို ခံရဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","အယ်ဘေမဲ့ ဘုရားသခင်ဟှာ သူးနို့ဟှို ကျွန်ခံခိုင်းဟှူ လူလေဟှိုလည်း ငါစီရင်မယ်။ အယ်ဘီးန နန့်ရဲ့ သားမ္လေးလေဟှာ အယ်ပြည်ဟှနေ လွတ်မြော့‑က်ဂေ့ဘီးဟှာ အယ်နေရာမာ ငါ့ဟှို ကိုးကွယ်ဘီး ဝတ်ပြုဂေ့လေ့မယ်’ ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","အယ်ဘီးန ဘုရားသခင်ဟှာ ရေဖျားလှီးဇာနဆိုင်ဟှူ ပဋိညာဉ်ဟှိုလည်း အာဗြဟံဟှို ပေးလေဟှယ်။ အယ်ကြောန့် အာဗြဟံဟှာ ဣဇာက်ဟှို မွီးဘီးန ရှစ်ရစ်မြော့‑က်နေ့မာ ရေဖျားလှီးပေးဟှယ်။ ဣဇာက်ဟှာ သူ့သားယာကုပ်၊ ယာကုပ်ဟှာ လူမျိုးဆယ့်နှေ့မျိုးရဲ့ ဘိုးဘေးလေဖြစ်ဟှူ သူ့သား ဆယ့်နှေ့ယော့‑က်ဟှိုလည်း ရေဖျားလှီးပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ယာကုပ်ရဲ့ သားလေဟှာ သူးနို့ညီ ယောသပ်ဟှို နာလိုဘဲကြောန့် အဲဂုတ္တုပြည်မာ ကျွန်ခံဟှို့တွပ် ရောန်းလိုက်ဂေ့ဟှယ်။ အယ်ဘေမဲ့ ဘုရားသခင်ဟှာ သူ့နတူးဒူ ရှိနေဟှူကြောန့်၊ ");
INSERT INTO tvn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","သူ့ရဲ့ ဒေါက်ခဆင်းရဲလေ ထဲဟှနေဘီး ကယ်တန်လိုက်ဟှယ်။ ဘုရားသခင်ဟှာ ယောသပ်ဟှို အဲဂုတ္တုပြည်ရဲ့ ဖာရောမန်းဂီးရှေ့မာ မျစ်နှာသာရစေဟှယ်။ သူ့ဟှိုလည်း ဉာဏ်ပညာပေးလေဟှယ်။ ဖာရောမန်းဂီးဟှာ သူ့ဟှို အဲဂုတ္တုပြည်န သူ့ရဲ့ နန်းတော်တခုလောင်းဟှို အောက်ချောက်မားဖြစ် သူ့ဟှို ခန့်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","အဲဂုတ္တုပြည်န ခါနာန်ပြည်လေမာ စာခေါန်းဗားဘေး ရော့‑က်လာဟှူ ခီမာ လူလေဟှ ရရာတိုင်း ဒေါက်ခရော့‑က်ဂေ့ဟှယ်။ နို့လေရဲ့ ဘိုးဘေးလေမာလည်း စားဇာမှေ့ဂေ့ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","အယ်ဘေမဲ့ အဲဂုတ္တုပြည်မာ စားဇာလေရှိနေဟှယ် ဆိုဇာဟှို ယာကုပ်ကြားရခီမာ သူ့ရဲ့ သားလေဟှို အယ်ပြည်ဟှို ပထမခါ လွှတ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","သူးနို့ဟှာ ဒုတိယခါ ရော့‑က်လာဂေ့ဟှူ ခီမာ ယောသပ်ဟှာ သူ့ညီကိုလေဟှို သူဟှာ ဖယ်လူဖြစ်ဟှယ် ဆိုဇာဟှို ပြောပြလိုက်ဟှယ်။ ဖာရောဟှာ ယောသပ်ရဲ့ မိသားစုကြောန်းဟှို သိဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","အယ်ကြောန့် ယောသပ်ဟှာ သူ့ဖ ယာကုပ်နတူးဒူ ခွန်နစ်ဆယ်ငါးယော့‑က်ရှိဟှူ မိသားတစုလောင်းဟှို အဲဂုတ္တုပြည်ဟှို ခေါ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","အယ်ကြောန့် ယာကုပ်ဟှာ အဲဂုတ္တုပြည်ဟှို သွားဟှယ်။ အယ်ပြည်မာဘဲ့ သူ့န သူ့သားလေဟှာ သေဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","သူးနို့ရဲ့ လောန်းလေဟှို ရှေခင်ဗြို့ဟှို ယူဆောန်ဟှားဘီးဟှာ အာဗြဟံဝယ်ဟှားရစ်ဟှူ သန်းခ္လိုင်းမာ သင်္ဂြိုဟ်ဂေ့ဟှယ်။ အယ်သန်းခ္လိုင်းဟှ ဟာမော်ရဲ့ သားလေနားဟှ ကပ်န ဝယ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“ဘုရားသခင်ဟှာ အာဗြဟံဟှို ပေးဟှားဟှူ ဂဒိတော်ဟှို ပ္လဲ့ဇောင်ဟှို့တွပ် ခီနီးလာဟှူ ခီမာ အဲဂုတ္တုပြည်မာ ဣသရေလ လူလေဟှို လူဦးရေတိုးပွားစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","အယ်ခီမာ အဲဂုတ္တုပြည်မာ ယောသပ်ဟှို သိဘဲဟှူ မန်းဂီးတပါး ပေါ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","အယ်မန်းဂီးဟှာ နို့လေရဲ့ ဘိုးဘေးလေဟှို လှည့်ဇားဘီး သူးနို့ဟှို နှိစစ်ဂေ့ဟှယ်။ သူးနို့ရဲ့ သားဂန်းဟှားလေဟှိုလည်း သေစေဟှို့တွပ် အီပ္လန်မာ ပစ်ဟှားခိုင်းဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","အယ်ခီကာလမာ မောရှေဟှာ မွီးလာဟှယ်။ မောရှေဟှာ ဘုရားသခင်ရှေ့မာ ရရာတိုင်း နားလူဘွယ်ကောန်းဟှူ သားဂန်းဟှား ဖြစ်ဟှယ်။ သူ့မိသားစုရဲ့ သောင်းလ လောင်းလောင်း စောန့်ရှော့‑က်ဇာဟှို ခံရဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","သူဟှာ အီပ္လန်မာ ပစ်ဟှားခံရဟှူ ခီမာ ဖာရောမန်းဂီးရဲ့ သမီးတော်ဟှ သူ့ဟှို သားနေန မွီးဇားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","မောရှေဟှာ အဲဂုတ္တုလူလေရဲ့ တတ်ပညာ ဂူလောင်း သန်ဟှားဘီး နှလောင်းရည်၊ လတ်ရောင်းရည်လေန ပ္လဲ့ဇောင်ဟှူလူ ဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“သူဟှာ သတ်လေးဆယ်ပ္လဲ့ဟှူ ခီမာ သူ့ညီကိုလေဖြစ်ဟှူ ဣသရေလ လူလေနားဟှို သွားလည်ဟှို့တွပ် စိဆောင်းဖြတ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ဣသရေလလူ တယော့‑က်ဟှို အဲဂုတ္တုလူ တယော့‑က်ဟှ ညှဉ်းဆဲနေဇာဟှို ဗြင်ဟှူ ခီမာ သူ့လူဖတ်ဟှနေ ဝမ်ကူညီဘီး အဲဂုတ္တုလူဟှို သတ်လိုက်ဘီးဟှာ ဂလဲ့စားချေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","မောရှေဟှာ သူ့ရဲ့ ညီကို မောန်နှမလေဟှို ကယ်တန်ဟှို့တွပ် သူးနို့ဟှို ဘုရားသခင်ဟှ လွှတ်လိုက်ဟှယ် ဆိုဇာဟှို သူးနို့လေဟှ နားလည်ဂေ့လေ့မယ် ဆိုဘီး ထန်ဟှားဟှယ်။ အယ်ဘေမဲ့ အယ်လူလေဟှာ နားလည်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","နော့‑က်တနေ့မာ ဣသရေလလူ နှေ့ယော့‑က်ဟှာ ရန်ဖြစ်နေဂေ့ဇာဟှို ဗြင်ဟှူ ခီမာ မောရှေဟှ ‘နန်းနို့ဟှာ ညီကိုရှင်းဖြစ်ဘီးဟှာ ဖြားဖြစ်ကြောန့် ရန်ဖြစ်နေဂေ့နူး’ ဆိုဘီး သူးနို့ဟှို မေးဘီး ရန်ငြီးဟှို့တွပ် ကြိုးစားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","အယ်ဘေမဲ့ နိုင်ကျင့်နေဟှူလူဟှာ မောရှေဟှို ဘေးဟှိုတွန်းလိုက်ဘီးန ‘နို့လေဟှို တရားစီရင်ဟှို့တွပ် အောက်ချောက်မားဖြစ် နန့်ဟှို ဖယ်သူဟှ ခန့်ဟှားနူး။ ");
INSERT INTO tvn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","နတ်ကီးဒူးဟှ အဲဂုတ္တုလူ တယော့‑က်ဟှို သတ်မျိုး ငါ့ဟှိုလည်း သတ်ဟှို့လော’ ဆိုဘီး မေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","မောရှေဟှာ အယ်စကားဟှို ကြားဟှူ ခီမာ အဲဂုတ္တုပြည်ဟှနေ ထွပ်ပ္လေးဟှားဘီး မိဒျန်ပြည်မာ နေလေဟှယ်။ အယ်ပြည်မာ သားနှေ့ယော့‑က်ဟှို ရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“နှစ်လေးဆယ် ကြာဘီးန သိနာတောန်နားဟှ ကန္တာရထဲမာ မီးလောန်နေဟှူ ချောင်ထဲမာ ကောန်းဂန်တမန် တပါးဟှာ မောရှေဟှို ကိုယ်ထန်ရှားပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","အယ်မူဇာဟှို ဗြင်ဟှူ ခီမာ မောရှေဟှာ ရရာတိုင်း အံ့ဩဘီးန ရှင်းရှင်းလန်းလန်းဟှား ဗြင်ရဟှို့တွပ် နီးနားဟှို တိုးဟှားဟှယ်။ အယ်ဘေမဲ့ ဘုရားသခင်ဟှ ");
INSERT INTO tvn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ငါဟှာ နန်းနို့ ဘိုးဘေးလေရဲ့ ဘုရားသခင်၊ အာဗြဟံ၊ ဣဇာက်၊ ယာကုပ်ရဲ့ ဘုရားသခင် ဖြစ်ဟှယ်’ ဆိုဘီး သံတော်ဟှို ကြားရဟှူကြောန့် မောရှေဟှာ ကြော့‑က်လန့် တူလှောက်ဟှားဘီး ကေ့ဟှို့ရဲဘဲ ဖြစ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ဘုရားသခင်ဟှ ‘နန် ခေနန်းဟှားဟှူ နေရာဟှာ သန့်ရှင်းဟှူမ္လေ ဖြစ်ဟှယ်။ နန့်ခေနပ်ဟှို ခလွတ်လိုက်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","အဲဂုတ္တုပြည်မာ ငါ့လူမျိုးလေဟှို နှိစစ်ခံနေရဇာဟှို ငါဗြင်ရဟှယ်။ သူးနို့ရဲ့ ညည်းတွားသံလေဟှို ငါကြားရဟှယ်။ သူးနို့ဟှို ကယ်တန်ဟှို့တွပ် ငါဆင်းလာဘီ။ အယ်ကြောန့် ခုလာဟှယ်။ နန့်ဟှို အဲဂုတ္တုပြည်ဟှို ငါလွှတ်မယ်’ ဆိုဘီး မောရှေဟှို မိန့်တော်မူလေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“မောရှေဟှာ ဣသရေလလူမျိုးလေရဲ့ ပစ်ပယ်ခံရဟှူလူ ဖြစ်ဟှယ်။ အယ်ဘီးဟှာ ‘နို့လေဟှို တရားစီရင်ဟှို့တွပ် အောက်ချောက်မားဖြစ် နန့်ဟှို ဖယ်သူဟှ ခန့်ဟှားနူး’ ဆိုဘီး အယ်လူလေရဲ့ မေးဇာဟှိုလည်း ခံရဟှယ်။ အယ်ဘေမဲ့ သူဟှာ ဣသရေလ လူမျိုးလေဟှို အောက်ချောက်ဟှို့တွပ် မီးတော့‑က်နေဟှူ ချောင်ထဲမာ ထန်ရှားဟှူ ကောန်းဂန်တမန် တပါးရဲ့ ကူညီန ဣသရေလလူမျိုးလေ လွတ်မြော့‑က်ဟှို့တွပ် ဘုရားသခင် လွှတ်လိုက်ဟှူလူ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","သူဟှာ အဲဂုတ္တုပြည်န ပန်လယ်နီမာရော၊ နှစ်လေးဆယ် လောင်းလောင်း တောကန္တာရထဲမာရော အံ့ဩဘွယ်ရာန နိမိတ်လတ်ခဏာလေဟှို ပြဘီး ဣသရေလ လူမျိုးလေဟှို အဲဂုတ္တုပြည်ဟှနေ ခေါ်ဆောန်လာဟှူ လူဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","အယ်မောရှေဟှာ ဣသရေလ လူမျိုးလေဟှို ‘နန်းနို့ရဲ့ ညီကိုလေထဲမာ ငါ့နတူဟှူ ပရောဖက်တပါးဟှို ဘုရားသခင်ဟှာ နန်းနို့တွပ် ပေါ်ခိုင်းလေ့မယ်’ ဆိုဘီး ပြောဟှူလူ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","သူဟှာ တောကန္တာရမာ စုနေဟှူ ဣသရေလ လူမျိုးလေနရော၊ နို့လေ ဘိုးဘေးလေနရော၊ သိနာတောန်ထတ်မာ သူ့ဟှို စကားပြောဟှူ ကောန်းဂန်တမန်နရော တူးဒူရှိနေဟှူလူ ဖြစ်ဟှယ်။ နို့လေဟှို ပြောဟှို့တွပ် ဘုရားသခင်နားဟှနေ သတ်ရှင်စေဟှူ တရားတော်ဟှို ရလာဟှူလူလည်း ဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“အယ်ဘေမဲ့ နို့လေရဲ့ ဘိုးဘေးလေဟှာ သူ့စကားဟှို နားထောန်ဂေ့ဟှ။ သူ့ဟှို ငြင်းပယ်ဘီးဟှာ သူးနို့ရဲ့ စိနှလောင်းဟှ အဲဂုတ္တုပြည်ဟှို ပ္လန်ရှင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","သူးနို့ဟှာ ‘နို့လေရှေ့ဟှ ကြွဟှားမယ့် ဘုရားလေဟှို နို့လေတွပ် လောက်ပေးပါ။ နို့လေဟှို အဲဂုတ္တုပြည်ဟှနေ ခေါ်ဆောန်လာဟှူ အယ်မောရှေဟှ ဖယ်မျိုးဖြစ်ဟှားဟှယ်ဆိုဇာ နို့လေသိဂေ့ဟှ’ ဆိုဘီး အာရုန်ဟှို ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","အယ်ဘီးန သူးနို့ဟှာ နွားသားဂန်းဟှား ရောက်ထုဟှို လောက်ဘီးဟှာ သူးနို့လတ်န လောက်ဟှားဟှူရောက်ထုဟှို ယဇ်ပူဇော်ဘီးဟှာ စားဗွဲသော့‑က်ဗွဲ လောက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","အယ်ကြောန့် ဘုရားသခင်ဟှာ သူးနို့ဟှို မျစ်နှာလွှဲဘီးဟှာ ကောန်းဂန်ကြယ်တာရာလေဟှို ကိုးကွယ်ဂေ့ဟှို့တွပ် စွန့်ပစ်ဟှားလိုက်ဟှယ်။ ပရောဖက်ကျမ်းမာ” “‘ဣသရေလ လူမျိုးလေ၊ နန်းနို့ဟှာ တောကန္တာရမာ နှစ်လေးဆယ် လောင်းလောင်း ယဇ်ကောန်လေဟှို ပူဇော်ဟှို့တွပ် ငါ့နားဟှို ယူလာဖူးဘဲ့လော။ ");
INSERT INTO tvn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","နန်းနို့ဟှာ မောလုပ်ရဲ့ တဲန နန်းနို့ရဲ့ ဘုရား ရှင်ဖန်ရဲ့ ကြယ်လေဟှို သယ်လာဂေ့ဟှယ်။ အယ်ဇာလေဟှာ နန်းနို့ ကိုးကွယ်ဟှို့တွပ် လောက်ဟှားဟှူ ရောက်ထုလေ ဖြစ်ဂေ့ဟှယ်။ အယ်ကြောန့် နန်းနို့ဟှို ဗာဗုလုန်ဗြို့ဟှို ကျော်ဘီးဟှာ ခေါ်ဆောန်ဟှားမယ်’ ဆိုဘီး ရေးဟှားတိုင်းဘဲ့ ဖြစ်လာဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“နို့လေရဲ့ ဘိုးဘေးလေတွပ် တောကန္တာရမာ သတ်သေခံဟှူ တဲတော် ရှိဟှယ်။ မောရှေဟှို ဘုရားသခင်ပြဟှားဟှူ ပေါင်ဇံတိုင်း သတ်သေခံဟှူ တဲတော်ဟှို ဆော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","နို့လေရဲ့ ဘိုးဘေးလေဟှာ သူးနို့ရဲ့ ဖလေနားဟှနေ အယ်တဲတော်ဟှို မွေဆစ်ခံဘီးဟှာ ဘုရားသခင် နှန်ထုဟှူ လူမျိုးလေရဲ့ ပြည်ဟှို ယောရှုနတူးဒူ ချီတတ်ဘီးဟှာ သီးပိုက်ဂေ့ဟှူ ခီမာ အယ်တဲတော်ဟှို သယ်ဟှားဂေ့ဟှယ်။ အယ်တဲတော်ဟှ ဒါဝိဒ်မန်းဂီး လတ်ထတ်ထိ ရှိနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ဒါဝိဒ်ဟှာ ဘုရားသခင်ရှေ့မာ မျစ်နှာသာရဟှူလူ ဖြစ်ဟှယ်။ အယ်ဘီးဟှာ ယာကုပ်ရဲ့ ဘုရား ကိန်းဝပ်ဘီးနေဟှူ ဗိမာန်တော်ဟှို ဆော့‑က်ရဟှို့တွပ် ဘုရားသခင်ဟှို တောန်းရှော့‑က်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","အယ်ဘေမဲ့ ဘုရားသခင်ရဲ့ ဗိမာန်တော်ဟှို ဆော့‑က်ခွမ့်ရဟှူ လူဟှ ရှောလမုန်မန်းဂီး ဖြစ်လေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“အယ်ဘေမဲ့ ဗြစ်ဆောင်းဖြစ်ဟှူ ဘုရားသခင်ဟှာ လူလတ်န ဆော့‑က်ဟှားဟှူ အီမာ ကျိန်းဝပ်ဟှ ဆိုဘီး ပရောဖက်ဟှပြောဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ဘုရားသခင်ဟှ “ ‘ကောန်းဂန်ဘောင်ဟှာ ငါ့ရဲ့ ပလ္လင်ဖြစ်ဟှယ်။ မ္လေဂီးဟှာ ငါ့ရဲ့ ခေတန်ခေါင် ဖြစ်ဟှယ်။ နန်းနို့ဟှာ ဖြားအီမျိုး ငါ့တွပ် ဆော့‑က်ဂေ့ဟှို့နူး။ ငါကျိန်းဝပ်နေဟှူ နေရာဟှာ ဖယ်မာနူး။ ");
INSERT INTO tvn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ငါကိုယ်တိုင်ဘဲ့ အယ်ဇာလေဟှို ဖန်ဆင်းဇာ မှုဟှလော’ ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“နန်းနို့ဟှာ ရရာတိုင်း ခေါန်းမာဂေ့ဟှယ်! နန်းနို့ စိနှလောင်းဟှာ ဘုရားသခင်ရဲ့ တရားတော်ဟှို ကြားရဟှို့တွပ် နားပန်းဂေ့ဟှယ်! နန်းနို့ဟှာ နန်းနို့ ဘိုးဘေးလေမျိုးဘဲ့ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို မြဲဒမ်းဆန့်ကျင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","နန်းနို့ ဘိုးဘေးလေ ညှဉ်းဆဲဖူးဘဲဟှူ ပရောဖက်လေ ရှိဘဲ့လော။ သူးနို့ဟှာ ဘုရားသခင်ရဲ့ ဖြောန့်မတ်ဟှူစေခံ ကြွလာမယ့် ကြောန်းဟှို ကြိုတန်ဘီးဟောဂေ့ဟှူ ပရောဖက်လေဟှို သတ်ပစ်ဂေ့ဟှယ်။ ခုလည်း နန်းနို့ဟှာ အယ်သခင်ဟှို သတ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","နန်းနို့လေဟှာ ကောန်းဂန်တမန်လေဟှနေ တဆင့် ပေးလိုက်ဟှူ ပညတ်တော်ဟှို ရဘေမဲ့ အယ်ပညတ်တော်ဟှို လိုက်နာဂေ့ဟှ” ဆိုဘီး သတေဖန်ဟှ ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ယုဒတရားလွှတ်တော် ဖွဲ့ဝမ်လေဟှာ အယ်စကားဟှို ကြားရဟှူ ခီမာ ရရာတိုင်း ဒေါသထွပ်ဘီးဟှာ အံက္လိနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","သတေဖန်ဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န ပ္လဲ့ဝဘီး ကောန်းဂန်ဟှို ကေ့လိုက်ဟှူ ခီမာ ဘုရားသခင်ရဲ့ ဖောင်းသရေတော်န ဘုရားသခင်ရဲ့ ညာဖတ်မာ ယေရှုရပ်နေဇာဟှို ဗြင်နေရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","သတေဖန်ဟှ “ငါဟှာ ကောန်းဂန်ပွမ့်နေဇာန လူ့ရဲ့သားဟှာ ဘုရားသခင်ရဲ့ ညာဖတ်မာ ရပ်နေဇာဟှို ငါဗြင်ရဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","အယ်လူလေဟှာ သံက္လယ်ဂီး အော်ဘီးဟှာ သူးနို့ရဲ့ နားလေဟှို လတ်န ပိဟှားဘီးဟှာ သတေဖန်နားဟှို တရှီထိုး ပ္လေးလာဂေ့ဘီးဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","သူ့ဟှို ဗြို့ပ္လန်ဟှို ဆွဲထုဘီးန က္လော့‑က်ခဲန ပစ်ဂေ့ဟှယ်။ သိသတ်သေလေဟှာ သူးနို့ အန်းဂီလေဟှို ရှောလုနာမယ်ရှိဟှူ လူငယ် တယော့‑က်နားမာ ထားရစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","သူးနို့ဟှာ က္လော့‑က်ခဲန ပစ်နေဟှူ ခီမာ သတေဖန်ဟှာ “သခင်ယေရှု၊ ကျွန်တော့်ရဲ့ ဝိညာဉ်ဟှို လတ်ခံတော်မူပါ” ဆိုဘီး ဆုတောန်းဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","သူဟှာ ဒူးထော့‑က်ဘီးဟှာ “သခင်ဘုရား၊ သူးနို့ရဲ့ ပြစ်ဟှို ခွမ့်လွှတ်ပေးပါ ဆိုဘီး သံက္လယ်ဂီး အော်ဘီးန သေဟှားလေဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ရှောလုဟှာ သတေဖန် သတ်ခံရဟှူ မှုမာ သတ်သေ ဖြစ်ဟှယ်။ အယ်နေ့မာဘဲ့ ယေရုရှလင်ဗြို့ဟှ သင်းတော်မာ ပြင်းထန်ဟှူ ညှဉ်းဆဲဇာလေဟှာ စဘီး ဖြစ်လာဟှယ်။ အယ်ကြောန့် တမန်တော်လေဟှလွဲဘီး ယောင်ကြည်သူလေ ဂူလောင်းဟှာ ယုဒပြည်န ရှမာရိပြည်လေဟှို ထွပ်ပ္လေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ဘုရားတရားဟှို ရိုသေဟှူ လူတချို့ဟှာ သတေဖန်ဟှို သင်္ဂြိုဟ်ဘီး သူ့တွပ် ရရာတိုင်း ငိုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","အယ်ဘေမဲ့ ရှောလုဟှာ အီဘီးအီ ဝမ်ဘီးဟှာ ယောင်ကြည်သူ ယော့‑က်ကျားလေန မီးမလေဟှို ဆွဲထုဘီး ထောန်ထဲမာ ခ္လဟှားဘီး သင်းတော်ဟှို ဖျစ်ဆီးဟှို့တွပ် ကြိုးစားနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ဖ္လဲဖ္လဲစင်ဖြစ်ဟှားဟှူ ယောင်ကြည်သူလေဟှာ နေရာတိုင်းဟှို သွားဘီးဟှာ ဒန်းကောန်းဟှို ဟောပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ဖိလိပ္ပုဟှာ ရှမာရိပြည်ရဲ့ ဓိကဗြို့တော်ဟှို သွားဘီး ခရစ်တော်ကြောန်းဟှို ဟောပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","လူလေဟှာ ဖိလိပ္ပုပြဟှူ နိမိတ်လတ်ခဏာလေဟှို ဗြင်ဟှူ ခီမာ သူ့ရဲ့ တရားစကားဟှို အာရောင်စိုက်ဘီး နားထောန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","နတ်ဆိုးစွဲနေဟှူ လူလေဘောင်ဂီးထဲဟှနေ နတ်ဆိုးလေဟှာ သံက္လယ်ဂီးန အော်ဘီးဟှာ ထွပ်ဟှားဂေ့ဟှယ်။ လေဖြတ်ဟှူလူ၊ ခေလတ်သန်ဘဲ့ဟှူ လူလေဟှာ ရောဂါပျော့‑က်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","အယ်ကြောန့် အယ်ဗြို့မာ ရရာတိုင်း ဝန်းသာဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","အယ်ဗြို့မာ ရှိမုန် နာမယ်ရှိဟှူလူ တယော့‑က်ရှိဟှယ်။ သူဟှာ သူ့ရဲ့ နတ်ဝိဇ္ဇာပညာန ရှမာရိ လူမျိုးလေဟှို အံ့ဩစေဘီး သူ့ကိုယ်သူ ထူးမြတ်ဟှူလူ ဖြစ်ဟှယ် ဆိုဘီး ဝါကြွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","အယ်ဗြို့မာရှိဟှူ လူတန်းစားလေ ဂူလောင်းဟှ သူ့ဟှို အာရောင်စိုက်ဘီး “အယ်လူဟှာ ဘုရားသခင်ရဲ့ ‘မဟာတဂိုးတော်’ ဖြစ်ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","သူးနို့ဟှာ ရှိမုန်ဟှို အာရောင်စိုက်နေဇာဟှ သူဟှာ ခီကြာဂီး နတ်ဝိဇ္ဇာပညာန အံ့ဩစေဟှူကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","အယ်ဘေမဲ့ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ကြောန်းန ယေရှုခရစ်တော်ကြောန်း ဒန်းကောန်းဟှို ဖိလိပ္ပုဟှ ဟောဟှူ ခီမာ အယ်လူလေဟှာ ယောင်ကြည်လာဂေ့ဘီးဟှာ ယော့‑က်ကျားလေရော မီးမလေပါ ဗတ္တိဇံဟှို ခံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ရှိမုန် ကိုယ်တိုင်လည်း ယောင်ကြည်ဘီး ဗတ္တိဇံဟှို ခံဘီးန ဖိလိပ္ပုနားမာ နေနေဟှယ်။ သူဟှာ ကီးမားဟှူ အံ့ဩဘွယ်လေန နိမိတ်လတ်ခဏာလေဟှို ဗြင်ရဟှူ ခီမာ အံ့ဩနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ရှမာရိပြည်သားလေဟှာ ဘုရားသခင်ရဲ့ စကားတော်ဟှို ခံယူဂေ့ဟှယ် ဆိုဇာဟှို ယေရုရှလင်ဗြို့မာရှိဟှူ တမန်တော်လေ ကြားရဟှူ ခီမာ ပေတရုန ယောဟန်လေဟှို သူးနို့နားဟှို လွှတ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","တမန်တော်နှေ့ပါးဟှာ ရော့‑က်လာဟှူ ခီမာ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို ယောင်ကြည်သူ လူသစ်လေ လတ်ခံရရှိဟှို့ ဆိုဘီး သူးနို့တွပ် ဆုတောန်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့လေဟှာ သခင်ယေရှု နာမတော်နှိုက် ဗတ္တိဇံဟှို ခံယောင်မျှဘဲ့ ရှိသေးဘီး သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှာ အယ်လူလေထဲဟှ ဖယ်လူထတ်မာလည်း ရော့‑က်လာသေးဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","အယ်ဘီးန ပေတရုန ယောဟန်လေဟှာ သူးနို့ထတ်ဟှို လတ်တန်ဂေ့ဟှူ ခီမာ သူးနို့ဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို ခံရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","တမန်တော်လေ လတ်တန်ဟှူ ခီမာ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို အယ်ယောင်ကြည်သူလေ ရရှိဟှားဟှယ် ဆိုဇာဟှို ရှိမုန်ဟှ ဗြင်ဟှားဟှူကြောန့် ကပ်ဟှို ယူလာဘီးဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ကျွန်တော် လတ်တန်လိုက်ဟှူ လူတိုင်းဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို ရဟှို့တွပ် တဂိုးအာဏာဟှို ကျွန်တော်ဟှိုလည်း ပေးပါ” ဆိုဘီး တောန်းလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ပေတရုဟှ “နန်ဟှာ ဘုရားသခင်ရဲ့ ဆုကျေးဇူးဟှို ကပ်န ဝယ်နိုင်ဟှယ် ဆိုဘီး ထန်မှတ်ဟှူကြောန့် နန့်ရဲ့ ကပ်ဟှာ နန့်နတူးဒူ ပျစ်စီးပါစေ။ ");
INSERT INTO tvn_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ဘုရားသခင်ရှေ့မာ နန့်ရဲ့ စိနှလောင်းဟှာ ဖြောန့်ဘဲဟှူကြောန့် နို့လေရဲ့ လောက်ထဲမာ ပါဝမ်ခွမ့် မှေ့ဟှ။ နန့်ဝီစုလည်း မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","အယ်မျိုး ဆိုးညစ်ဟှူ ကြံစည်ဟှို နောန်ဒရဘီး အယ်မျိုးစိနှလောင်းထဲမာ ကြံစည်မိဟှူဇာဟှို ပြစ်လွှတ်ခံရဟှို့တွပ် သခင်ဘုရားနားမာ ဆုတောန်းပါ။ ");
INSERT INTO tvn_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ နန်ဟှာ ရိုးသားဘဲဟှူစိန ပ္လဲ့နေဘီးဟှာ ပြစ်ရဲ့ ချောက်နှောန်ဇာထဲမာ ရှိနေဇာဟှို ငါဗြင်ဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ရှိမုန်ဟှ “သင်ပြောနေဇာလေ တခုလည်းဖြစ်ဘဲဟှို့တွပ် သခင်ဘုရားဟှို ကျွန်တော်တွပ် ဆုတောန်းပေးဂေ့ပါ” ဆိုဘီး တောန်းဗန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ပေတရုန ယောဟန်လေဟှာ သခင်ဘုရားရဲ့ စကားတော်ဟှို သတ်သေခံဘီးဟှာ ဟောပြောဘီးန ယေရုရှလင်ဗြို့ဟှို ပ္လန်ဟှားဂေ့ဟှယ်။ ပ္လန်ခရီးမာ သူးနို့ဟှာ ရှမာရိဝါလေမာ ဒန်းကောန်းဟှို ဟောပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်ဟှာ ဖိလိပ္ပုဟှို “နန်ဟှာ ထဘီးဟှာ ယေရုရှလင်ဗြို့ဟှနေ ဂါဇဗြို့ဟှို သွားဟှူလမ်းတိုင်း တောန်ဖတ်ဟှို သွားလိုက်” ဆိုဘီး ပြောလိုက်ဟှယ်။ ခုခီမာ အယ်လမ်းဟှို သောင်းဂေ့ဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","အယ်ကြောန့် ဖိလိပ္ပုဟှာ ထဘီးဟှာ သွားလေဟှယ်။ အယ်ဘီးန အဲသယောပိပြည်ဟှ မိဖုရား ကန္ဒက်ရဲ့ မှူးမတ်ဂီးဖြစ်ဘီး မိဖုရားရဲ့ ဘဏ္ဍာလေ ဂူလောင်းဟှို စီမံခန့်ခွဲရဟှူ အဲသယောပိပြည်သား တယော့‑က်ဟှာ ယေရုရှလင်ဗြို့ဟှို လာရော့‑က် ဝတ်ပြုကိုးကွယ်ဘီး ");
INSERT INTO tvn_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ပ္လန်လမ်းမာ သူ့ရဲ့ ဗြင်းရထားထတ်မာ ထိုင်ဘီး ပရောဖက် ဟေရှာယရဲ့ ကျမ်းစာဟှို ဖတ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ဝိညာဉ်တော်ဟှာ ဖိလိပ္ပုဟှို “အယ်ဗြင်းလှည်းနားဟှို သွားလိုက်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ဖိလိပ္ပုလည်း ပ္လေးဟှားဘီးဟှာ ပရောဖက်ဟေရှာယကျမ်းဟှို အယ်လူဟှာ ဖတ်နေဇာဟှို ကြားဟှူ ခီမာ “နန်ဖတ်နေဇာဟှို နားလည်ဘဲ့လော” ဆိုဘီး မေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","အယ်ရာရှိဟှာ “ရှင်းပြပေးမယ့်လူ မှေ့ဘဲန ဖယ်မျိုးနားလည်ဟှို့နူး” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ သူဟှာ ဖိလိပ္ပုဟှို ဗြင်းလှည်းထတ်ဟှို တတ်ခိုင်းဘီးဟှာ သူ့နတူးဒူ ထိုင်ဟှို့တွပ် တိုက်တွန်းလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","အယ်လူဖတ်နေဟှူ ကျမ်းချစ်ဟှ “သတ်ခံရဟှို့တွပ် ဆွဲခေါ်ဟှားဟှူ သိုးမျိုးဘဲ့ သူ့ဟှို ယူဆောန်ဟှားဂေ့ဟှယ်။ မွီးညှပ်မားရှေ့မာ သိုးသားဂန်းဟှားဟှာ သူ့နှောက်ဟှို ပိဟှားမျိုး သူဟှာ သူ့နှောက်ဟှို ဖွမ့်ဘဲနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","သူဟှာ ရှောက်ခ္လဇာဟှို ခံရဘီး တရားမျှတမှုတွပ် ငြင်းပယ်ခံရဟှယ်။ အယ်လောကဟှာ သူ့သတ်ဟှို ရောက်သီးဟှားကြောန့် ဖယ်လူလည်း သူ့ရဲ့ သားမ္လေးလေကြောန်းဟှို ပြောပြနိုင် ဂေ့ဟှ” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","အယ်ရာရှိဟှ “နန့်ဟှို မေးအူးမယ်။ ပရောဖက်ဟှာ ဖယ်လူရဲ့ ကြောန်းဟှို ပြောနေနူး။ သူ့ကိုယ်သူ ပြောနေဇာလော။ တခြားလူ တယော့‑က် ကြောန်းလော” ဆိုဘီး ဖိလိပ္ပုဟှို မေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ဖိလိပ္ပုဟှာ အယ်ကျမ်းပိုဒ်နဘဲ့ စပြုဘီးဟှာ ယေရှုကြောန်း ဒန်းကောန်းဟှို ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","သူးနို့ဟှာ ဆစ်ဘီးဟှာ ခရီးသွားနေဂေ့ဟှူ ခီမာ ရေရှိဟှူနေရာဟှို ရော့‑က်ဟှားဂေ့ဘီး အယ်ရာရှိဟှ “အယ်နေရာမာရေရှိဟှယ်။ ကျွန်တော် ဗတ္တိဇံခံဟှို့တွပ် တားဆီးမယ့် ဇာလေရှိလော” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ရာရှိဟှာ ဗြင်းလှည်းဟှို ရပ်ခိုင်းလိုက်ဟှယ်။ အယ်ဘီးန သူးနို့ နှေ့ယော့‑က်ဟှာ ရေထဲဟှို ဆင်းဟှားဂေ့ဘီးဟှာ ဖိလိပ္ပုဟှာ ရာရှိဟှို ဗတ္တိဇံပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","သူဟှာ ရေထဲဟှ ထလာဟှူ ခီမာ ဘုရားသခင်ရဲ့ ဝိညာဉ်တော်ဟှာ ဖိလိပ္ပုဟှို တခြားနေရာဟှို ယူဆောန်ဟှားလေဟှယ်။ ရာရှိဟှာ ဖိလိပ္ပုဟှို နော့‑က်ထပ် တွိရဟှမ်း။ သူဟှာ ဝန်းသာရှင်းပ္လဲ့န ခရီးဆစ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ဖိလိပ္ပုဟှာ အာဇုတ်ဗြို့ဟှို ရော့‑က်ရှိနေဇာဟှို သိရဟှယ်။ အယ်ဘီးန ကဲသရိဗြို့ဟှို ရော့‑က်ဒဲ့ထိ ဗြို့တိုင်းမာ ဒန်းကောန်းဟှို ဟောပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","အယ်ခီမာ ရှောလုဟှာ သခင်ဘုရားရဲ့ တဗဲ့တော်လေဟှို သတ်ဟှို့တွပ် ချီးခြော့‑က်နေဟှယ်။ သူဟှာ ယဇ်ပုရောဟိတ်မန်း နားဟှို သွားဘီးဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","သခင်ဘုရားရဲ့ လမ်းစဉ်ဟှို လိုက်ရှော့‑က်ဟှူ ယော့‑က်ကျားန မီးမလေဟှိုတွိမယ် ဆိုဟှာ အယ်လူလေဟှို ဖမ်းဘီးဟှာ ယေရုရှလင်ဗြို့ဟှို ခေါ်လာနိုင်ဟှို့တွပ် ဒမာသက်ဗြို့မာရှိဟှူ ဝါလယ်ဇရပ်လေဟှို မှာစာလေဟှို ရေးပေးဟှို့တွပ် တောန်းရှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ရှောလုဟှာ ဒမာသက်ဗြို့နားဟှို ရော့‑က်ခါနီးမာ ကောန်းဂန်ဟှနေ လန်းရောန်တခုဟှာ သူ့ပတ်လည်မာ ရောက်တရစ် ထွန်းတော့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","သူဟှာ မ္လေဂီးထတ်ဟှို လဲက္လဘီးန “ရှောလု၊ ရှောလု နန်ဟှာ ဖြားဖြစ်ကြောန့် ငါ့ဟှို ညှဉ်းဆဲနူး” ဆိုဘီး သူ့ဟှို မေးနေဟှူ သံဟှို ကြားရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ရှောလုဟှ “သခင်၊ ကိုယ်တော်ဟှ ဖယ်သူနူး” ဆိုဘီး မေးလျှော့‑က်လိုက်ဟှယ်။ သံတော်ဟှ “ငါဟှာ နန်ညှဉ်းဆဲနေဟှူ ယေရှုဘဲ့ဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“အယ်ဘေမဲ့ ထဘီးဟှာ ဗြို့ထဲဟှို သွားလိုက်။ အယ်နေရာမာ နန်လောက်ရဟှို့ ဇာလေဟှို ငါပြောပြမယ်” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ရှောလုနတူးဒူ ခရီးသွားနေဂေ့ဟှူ လူလေဟှာ အယ်သံဟှို ကြားရဘေမဲ့ ဖယ်လူဟှိုလည်း ဗြင်ရဘဲ့ဟှူကြောန့် တွေဝေဘီးဟှာ ရပ်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ရှောလုဟှာ မ္လေဂီးဟှထဘီးန မျစ်စိဟှို ဖွမ့်လိုက်ဟှူ ခီမာ ဖြားလည်း ဗြင်ရဟှမ်း။ အယ်ကြောန့် အယ်လူလေဟှာ သူ့လတ်ဟှို ဆွဲဘီးဟှာ ဒမာသက်ဗြို့ထဲဟှို ခေါ်ဆောန်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","သူဟှာ သောင်းရစ်လောင်းလောင်း မျစ်ကန်းဖြစ်ဟှားဘီး ဖြားဇာလည်း စားသော့‑က်ဘဲန နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ဒမာသက်ဗြို့မာ အာနနိ နာမယ်ရှိဟှူ တဗဲ့တော် တယော့‑က်ရှိဟှယ်။ ရူပါရောင်ထဲမာ သခင်ဘုရားဟှ အာနနိဟှို “အာနနိ!” ဆိုဘီး ခေါ်လိုက်ဟှယ်။ အာနနိဟှ “ကျွန်တော်ရှိပါဟှယ်။ သခင်ဘုရား” ဆိုဘီး ပ္လန်ဖြေလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","သခင်ဘုရားဟှ “နန်ထဘီး လမ်းဖြောန့် နာမယ်ရှိဟှူ လမ်းဟှိုသွားလိုက်။ တာရှုဗြို့သား ရှောလု နာမယ်ရှိဟှူ လူဟှို ယုဒရဲ့အီမာ မေးလိုက်ပါ။ သူဟှာ ဆုတောန်းနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","သူဟှာ မျစ်စိ ပ္လန်ဗြင်ရဟှို့တွပ် အာနနိ နာမယ်ရှိဟှူလူ လာဘီးဟှာ သူ့ထတ်မာ လတ်လာတန်ဇာဟှို ရူပါရောင်ထဲမာ ဗြင်ဟှားပီးဘီ” ဆိုဘီး မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","အာနနိဟှ “သခင်ဘုရား၊ အယ်လူဟှာ ယေရုရှလင်ဗြို့မာရှိဟှူ ကိုယ်တော်ရဲ့ သန့်ရှင်းဟှူ လူလေဟှို ဖယ်မျှလော့‑က် ဒေါက်ခပေးဟှယ် ဆိုဇာ လူလေဘောင်ဂီးနားဟှနေ ကျွန်တော်ကြားရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ကိုယ်တော်နာမဟှို ဆုတောန်းဟှူ လူလေရှိမျှဟှို ဖမ်းဟှို့တွပ် ယဇ်ပုရောဟိတ်ဂီးလေရဲ့ ခွမ့်အာဏာန ဒမာသက်ဗြို့ဟှို လာဟှူလူဖြစ်ဟှယ်” ဆိုဘီး ရှော့‑က်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","သခင်ဘုရားဟှ “သွားလိုက်။ အယ်လူဟှို လူမျိုးခြားလေ၊ မန်းဂီးလေန ဣသရေလလူမျိုးလေဟှို ငါ့နာမဟှို ကြေညာဟှို့တွပ် ငါဝီးကော့‑က်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ငါ့ရဲ့ နာမတော်ကြောန့် သူခံရမယ့် ဆင်းရဲဒေါက်ခကြောန်းဟှို သူ့ဟှို ငါကိုယ်တိုင် ဖော်ပြမယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","အယ်ကြောန့် အာနနိဟှာ ရှောလုရှိဟှူအီဟှို သွားဘီး ရှောလုထတ်မာ လတ်ဟှိုတန်ဘီးန “ညီရှောလု၊ နန့်မျစ်စိ ပ္လန်ဗြင်ဟှို့တွပ်ရော၊ သန့်ရှင်းဟှူဝိညာဉ်တော်န ပ္လဲ့ဝဟှို့တွပ်ရော လမ်းမာနန့်ဟှို ထန်ရှားပြဟှူ သခင်ယေရှုဟှာ ငါ့ဟှို နန့်နားဟှို လွှတ်လိုက်ဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ရှစ်ရှင်းဘဲ့ ရှောလုရဲ့ မျစ်စိဟှနေ ငါးကြေးလေဟှာ ကွာက္လမျိုးဖြစ်ဘီးဟှာ မျစ်စိပ္လန်ဗြင်ဟှားဟှယ်။ သူဟှာ ထဘီးန ဗတ္တိဇံခံလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","သူဟှာ စားဇာစားဘီးန ခွန်အား ပ္လဲ့လာလေဟှယ်။ ရှောလုဟှာ ဒမာသက်ဗြို့မာ တဗဲ့တော်လေန ရစ်နဲနဲ ကြာအောန်နေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ရှစ်ရှင်းဘဲ့ ဝါလယ်ဇရပ်လေဟှို သွားဘီးဟှာ ယေရှုဟှာ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်ဟှယ် ဆိုဇာဟှို စဘီးဟှာ ဟောပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","သူ့စကားဟှို ကြားဟှူလူလေဟှာ အံ့ဩဂေ့ဘီးဟှာ “အယ်လူဟှာ ယေရုရှလင်ဗြို့မာ ယေရှုဟှို ကိုးကွယ်ဟှူ လူလေဟှို သတ်ဟှူလူ မှုဟှလော။ သူဟှာ အယ်လူလေဟှို ဖမ်းဘီးဟှာ ယဇ်ပုရောဟိတ်ဂီးလေနားဟှို ပို့ဟှူလူ မှုဟှလော” ဆိုဘီး မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","အယ်ဘေမဲ့ ရှောလုရဲ့ ဟောပြောချစ်ဟှာ တဂိုးန ပိုဘီး ဟှာ ပ္လဲ့ဇောင်လာဘီး သခင်ယေရှုဟှာ မေရှိယဖြစ်ဟှယ် ဆိုဇာဟှို သတ်သေပြဘီး ဟောပြောဟှူကြောန့် ဒမာသက်ဗြို့မာနေဟှူ ယုဒလူမျိုးလေဟှ ပ္လန်ဘီးချေပဟှို့ နိုင်ဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ရစ်လေကြာဟှားဘီးန ရှောလုဟှို သတ်ဟှို့တွပ် ယုဒလူမျိုးလေဟှာ ကြံစည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","အယ်ဘေမဲ့ သူးနို့ရဲ့ စီစဉ်လေဟှို ရှောလုဟှ သိဟှားဟှယ်။ သူးနို့ဟှာ ရှောလုဟှို သတ်ဟှို့တွပ် နေ့ရော၊ ညဉ့်ရော ဗြို့ရဲ့ ခွဗော့‑က်နားမာ စောန့်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ရှောလုရဲ့ တဗဲ့လေဟှာ ညဉ့်ခန်းဇာမာ သူ့ဟှိုယူဘီးန တောန်းထဲဟှို ထဲ့ဘီးဟှာ ဗြို့ရိုးထတ်ဟှနေ ရှောခ္လဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","သူဟှာ ယေရုရှလင်ဗြို့ဟှို ရော့‑က်လာဟှူ ခီမာ တဗဲ့လေန ပေါန်းဟှို့တွပ် ကြိုးစားဟှယ်။ အယ်ဘေမဲ့ သူဟှာ တဗဲ့တော်တယော့‑က် ဖြစ်ဟှယ် ဆိုဇာဟှို သူးနို့လေဟှာ ယောင်ကြည်ဘဲ့ကြောန့် သူ့ဟှို ကြော့‑က်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","အယ်ဘီးန ဗာနဗဟှာ သူ့ဟှို ကူညီဘီး တမန်တော်လေနားဟှို ခေါ်လာဟှယ်။ ရှောလုဟှာ လမ်းမာ သခင်ဘုရားဟှို ဗြင်ရဟှူဇာလေရော၊ ဒမာသက်ဗြို့မာ ယေရှုရဲ့နာမန ဖယ်မျှထိ ရဲရဲရင့်ရင့်ဟှား ဟောဇာလေဟှိုရော သူဟှ သူးနို့ဟှို ရှင်းပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ရှောလုဟှာ တမန်တော်လေနတူးဒူ နေဘီး ယေရုရှလင်ဗြို့ဟှို နှံ့အောန်သွားဘီးဟှာ သခင်ဘုရားရဲ့ နာမတော်ဟှို ရဲရဲရင့်ရင့်ဟှား ဟောပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","သူဟှာ ဟေလသစကားပြောဟှူ ယုဒလေန ဆွေးနွီး ပြောဆိုဂေ့ဟှယ်။ အယ်ဘေမဲ့ အယ်လူလေဟှာ သူ့ဟှို သတ်ဟှို့တွပ် ကြံစည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","အယ်ဒန်းဟှို ညီကိုလေဟှ ကြားရဟှူ ခီမာ သူ့ဟှို ကဲသရိဗြို့ဟှို ခေါ်ဆောန်ဟှားဘီး တာရှုဗြို့ဟှို ပို့ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","အယ်ကြောန့် ယုဒပြည်၊ ဂါလိလဲပြည်န ရှမာရိပြည် နေရာနှံ့မာရှိဟှူ သင်းတော်ဟှာ ငြီသတ်ဟှူ ကာလဟှို ရဂေ့ဟှယ်။ သင်းတော်ဟှာ သခင်ဘုရားဟှို ကြော့‑က်ရွံ့ ရိုသေဇာန သတ်ရှင်ဘီး သန့်ရှင်းဟှူဝိညာဉ်တော်ရဲ့ ကူညီရှင်းကြောန့် ခိုင်ခန့်မြဲမြံဟှားဘီး သင်းသားလေ ဘောင်ဂီးဖြစ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ပေတရုဟှာ နေရာတိုင်းဟှို သွားဘီး လုဒ္ဒဗြို့မာရှိဟှူ ဘုရားသခင်ရဲ့ သန့်ရှင်းသူလေနားဟှို ရော့‑က်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","အယ်ဗြို့မာ လေဖြတ်ဘီးဟှာ ရှစ်နှစ်လောင်းလောင်း အိယာထဲမာ လဲနေဟှူ အဲနေနာမယ်ခေါ်ဟှူ လူတယော့‑က်ဟှို တွိဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ပေတရုဟှ “အဲနေ၊ ယေရှုခရစ်တော်ဟှာ နန့်ဟှို ကျန်းမာစေဘီ။ ထဘီးဟှာ အိယာဟှို ကော့‑က်လိုက်” ဆိုဘီး သူ့ဟှို ပြောလိုက်ဟှယ်။ အဲနေဟှာ ရှစ်ရှင်းဘဲ့ ထလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","လုဒ္ဒဗြို့န ရှာရုန်ဗြို့မာနေဟှူ လူလေ ဂူလောင်းဟှာ အဲနေဟှို ဗြင်ဘီး သခင်ဘုရားဖတ်ဟှို ပ္လောန်းလဲလာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ယုပ္ပေဗြို့မာ တဗိသနာမယ်ရှိဟှူ တဗဲ့တော်မ တယော့‑က်ရှိဟှယ်။ သူ့နာမယ်ဟှ ဟေလသစကားန ဆိုဟှာ “ဒေါ်ကာ” ဖြစ်ဘီး “သမင်” ဆိုဘီး ဓိပါယ်ရဟှယ်။ သူဟှာ မြဲဒမ်း ကောန်းဇာဟှို လောက်ဘီး ဆင်းရဲသားလေဟှို ကူညီဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","အယ်ခီမာ သူဟှာ ဖျားဘီး သေဟှားလေဟှယ်။ သူ့လောန်းဟှို ရေချိုးပေးဂေ့ဘီးဟှာ အီထတ်ခန်းမာ ထားဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","လုဒ္ဒဗြို့န ယုပ္ပေဗြို့ဟှာ ရရာတိုင်း ဝီးဘဲကြောန့် လုဒ္ဒဗြို့မာ ပေတရုရှိနေဇာဟှို တဗဲ့တော်လေကြားဟှူ ခီမာ “ကျွန်တော့်ဟှားလေနားဟှို ဗြန်းဗြန်ဟှားလာပါ” ဆိုဘီး လူနှေ့ယော့‑က်ဟှို ပေတရုနားဟှို လွှတ်လိုက်ဘီး တောန်းဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","အယ်ကြောန့် ပေတရုဟှာ အယ်လူနှေ့ယော့‑က်န လိုက်ဟှားဟှယ်။ သူရော့‑က်ဟှူ ခီမာ လူလေဟှာ သူ့ဟှို အီထတ်ခန်းဟှို ခေါ်ဟှားဂေ့ဟှယ်။ မောက်ဆိုးမလေဟှာ ပေတရုနားမာ လာငိုဘီးဟှာ ဒေါ်ကာသေခန်ဒူးဟှ ချောက်ဟှားဟှူ အန်းဂီလေန ဝတ်ရောင်လေဟှို ပြဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ပေတရုဟှာ အယ်လူလေဟှို ခန်းပ္လန်ဟှို ထွပ်ခိုင်းဘီးဟှာ ဒူးထော့‑က် ဆုတောန်းလိုက်ဟှယ်။ အယ်ဘီးန လောန်းဖတ်ဟှို လှည့်ဘီးဟှာ “တဗိသ ထလိုက်” ဆိုဘီး ပြောလိုက်ဟှယ်။ ဒေါ်ကာဟှာ မျစ်စိပွမ့်ဘီးန ပေတရုဟှို ဗြင်ဟှူ ခီမာ ထထိုင်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ပေတရုဟှာ လတ်ဟှို ကမ်းပေးဘီးန အယ်မီးမဟှို ဆွဲထူလိုက်ဟှယ်။ အယ်ဘီးန သန့်ရှင်းသူလေန မောက်ဆိုးမလေဟှို ခေါ်ဘီးဟှာ သတ်ရှင်နေဟှူ ဒေါ်ကာဟှို ပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","အယ်ဒန်းဟှို ယုပ္ပေဗြို့ တဗြို့လောင်း ကြားရဟှူ ခီမာ လူလေဘောင်ဂီးဟှ သခင်ဘုရားဟှို ယောင်ကြည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ပေတရုဟှာ ယုပ္ပေဗြို့မာနေဟှူ၊ ရှိမုန် နာမယ်ရှိဟှူ သရေလောက်မားန ခီကြာဂီးနေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ကဲသရိဗြို့မာ ကော်နေလိ နာမယ်ရှိဟှူ လူတယော့‑က်ရှိဟှယ်။ သူဟှာ “ဣတလိတပ်” ခေါ်ဟှူတပ်ဟှ တပ်မှူးတယော့‑က်ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","သူဟှာ ဘာသာရေးသမား တယော့‑က်ဖြစ်ဘီး သူန သူ့မိသားတစုလောင်းဟှာ ဘုရားသခင်ဟှို ကိုးကွယ်ဂေ့ဟှယ်။ သူဟှာ ဆင်းရဲဟှူ ယုဒလူမျိုးလေဟှို ရစ်ရစ်ရောရောဟှား လှူတတ်ဟှယ်။ သူဟှာ ဘုရားသခင်ဟှို ခီမှန်မှန် ဆုတောန်းဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","နေဒန် သောင်းနာရီလော့‑က်မာ ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်တပါးဟှာ သူ့နားဟှို လာဘီးဟှာ “ကော်နေလိ” ဆိုဘီး ခေါ်လိုက်ဇာဟှို ရူပါရောင်ထဲမာ ထန်းထန်ရှားရှားဟှား ဗြင်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","သူဟှာ ကြော့‑က်ကြော့‑က်န အယ်ကောန်းဂန်တမန်ဟှို စိုက်ကေ့ဘီးန “သခင်၊ ဖြားကိစရှိနူး” ဆိုဘီး မေးလိုက်ဟှယ်။ အယ်ကောန်းဂန်တမန်ဟှ “နန့်ဆုတောန်းသံန စွန့်ကြဲပေးကမ်းဇာလေဟှို ဘုရားသခင်ဟှ နှစ်သက်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ခု ယုပ္ပေဗြို့ဟှို လူလေဟှို လွှတ်ဘီးဟှာ ပေတရု နာမယ်ရှိဟှူ ရှိမုန်ဟှို သွားခေါ်လာ။ ");
INSERT INTO tvn_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","သူဟှာ သရေလောက်မား ရှိမုန်အီမာ ရှိနေဟှယ်။ အယ်အီဟှ ပန်လယ်ကမ်းနားမာရှိဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","အယ်ကောန်းဂန်တမန်ဟှာ ထွပ်ဟှားဟှူ ခီမာ ကော်နေလိဟှာ သူ့ရဲ့ စေခံနှေ့ယော့‑က်န ဘုရားတရားကိုင်းရှိုင်းဟှူ စစ်သားတယော့‑က်ဟှိုလည်း ခေါ်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","သူဟှာ သူးနို့ဟှို ကြောန်းရာလေဟှို ပြောပြဘီးဟှာ ယုပ္ပေဗြို့ဟှို လွှတ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","နော့‑က်တနေ့မာ အယ်လူလေဟှာ ခရီးသွားဂေ့ဘီးန ယုပ္ပေဗြို့နားဟှို ရော့‑က်ဟှားဂေ့ဟှယ်။ မွန်းဒဲ့ခီမာ ပေတရုဟှာ ဆုတောန်းဟှို့တွပ် အီးခေါန်မိုးထတ်ဟှို တတ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","သူဟှာ ရရာတိုင်း ဗိုက်ဆာလာဘီး တခုခုစားရှင်လာဟှယ်။ စားဇာလေဟှို ပြင်ဆင်နေဒူးမာ သူဟှာ ရူပါရောင်ဟှို ဗြင်ရလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","သူဟှာ ကောန်းဂန် ပွမ့်ဟှားဘီးဟှာ ဒေါ့‑က်လေးဒေါ့‑က်န ချောက်ဟှားဟှူ ပိစဂီးတခုန တူဟှူဇာဟှာ မ္လေဂီးထတ်ဟှို နိက္လလာဇာဟှို ဗြင်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","အယ်မူဇာထဲမာ မ္လေဂီးထတ်မာရှိဟှူ ခေလေးရှောန်းလိဆန်လေ၊ တွားဘီးသွားဟှူ လိဆန်လေန ကောန်းဂန်ဟှ ငှတ်လေပါဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","အယ်ဘီးန “ပေတရု၊ ထဘီး သတ်စားလိုက်” ဆိုဘီး ငါ့ဟှို ပြောဟှူသံဟှိုလည်း ငါကြားရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ပေတရုဟှ “သခင်၊ ဖယ်မျိုးလည်းဖြစ်နိုင်ဟှ! ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကျွန်တော်ဟှာ ညစ်ညူးဇာန သန့်ရှင်းဘဲဟှူဇာဟှို ဖယ်ဒူးဟှလည်း စားဖူးဟှ” ဆိုဘီး လျှော့‑က်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","သံတော်ဟှ “ဘုရားသခင်ဟှ သန့်ရှင်းဟှယ် ဆိုဇာဟှို ညစ်ညူးဟှယ် ဆိုဘီး ပြောန” ဆိုဘီး ဒုတိယခါ မိန့်တော်မူလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","အယ်မျိုး သောင်းခါဖြစ်ဘီးန ရှစ်ရှင်းဘဲ အယ်ပိစဟှို ကောန်းဂန်ထဲဟှို ပ္လန်ဘီးဟှာ ဆွဲဒန်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ပေတရုဟှာ အယ်ရူပါရောင်ရဲ့ ဓိပါယ်ဟှို စဉ်းစားနေဒူးမာ ကော်နေလိ လွှတ်လိုက်ဟှူ လူလေဟှာ ရှိမုန်ရဲ့ အီဟှို ရှာတွိဟှားဘီး အီခွဗော့‑က်ရှေ့မာ ရပ်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","အယ်လူလေဟှ “ပေတရုနာမယ်ရှိဟှူ ရှိမုန်ဟှာ အယ်အီမာရှိလော” ဆိုဘီး အော်ဘီးဟှာ မေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ပေတရုဟှာ ရူပါရောင်ကြောန်းဟှို စဉ်းစားနေဒူးမာ ဝိညာဉ်တော်ဟှ “လူသောင်းယော့‑က်ဟှာ နန့်ဟှို ရှာနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","သူးနို့လေဟှို ငါဘဲ့ လွှတ်လိုက်ဟှူကြောန့် ထဘီးဆင်းဟှားလိုက်။ သံသယမှေ့ဘဲန သူးနို့န လိုက်ဟှားလိုက်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ပေတရုဟှာ အယ်လူလေနားဟှို ဆင်းဟှားဘီးဟှာ “နန်းနို့ ရှာနေဟှူလူဟှာ ငါဘဲ့ဖြစ်ဟှယ်။ ဖြားဖြစ်ကြောန့် နန်းနို့ ရော့‑က်လာဂေ့နူး” ဆိုဘီး မေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","အယ်လူလေဟှ “ဖြောန့်မတ်ဘီး ဘုရားသခင်ဟှို ကြော့‑က်ဟှူ၊ ယုဒလူမျိုးလေရဲ့ ချီးကျူးဘီး လေးစားခံရဟှူ တပ်မှူးကော်နေလိဟှ လွှတ်လိုက်ဟှယ်။ သင့်ဟှို ဖိခေါ်ဘီး သင့်ရဲ့စကားဟှို နားထောန်ရမယ် ဆိုဘီး သန့်ရှင်းဟှူ ကောန်းဂန်တမန်တပါးရဲ့ စကားတော်ဟှို လတ်ခံရရှိဟှယ်” ဆိုဘီး ပ္လန်ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ပေတရုဟှာ အယ်လူလေဟှို အီထဲဟှို ခေါ်ဖိဘီးဟှာ တည်းခိုစေလေဟှယ်။ နတ်ကီးတိုင်န သူဟှာ အယ်လူလေန တူးဒူ ထွပ်ဟှားဘီးဟှာ ယုပ္ပေဗြို့ဟှ ယောင်ကြည်သူ ညီကိုတချို့လည်း သူ့နတူးဒူ လိုက်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","နော့‑က်နေ့မာ ပေတရုဟှာ ကဲသရိဗြို့ဟှို ရော့‑က်ဟှားဟှယ်။ အယ်ဗြို့မာ ကော်နေလိဟှာ သူခေါ်ဖိဟှားဟှူ ဆွေမျိုးလေန ရင်းနှီးဟှူ မိဆွေလေန တူးဒူ သူ့ဟှိုစောန့်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ပေတရု ဝမ်လာဟှူ ခီမာ ကော်နေလိဟှာ ကြိုဆိုဘီးဟှာ သူ့ရဲ့ ခေရင်းမာ ပျပ်ဝပ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ပေတရုဟှ သူ့ဟှို ဆွဲဒန်ဘီး “ထဒန်၊ ငါကိုယ်တိုင်လည်း လူဘဲ့ဖြစ်ဟှယ်” ဆိုဘီး ကော်နေလိဟှို ပြောလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ပေတရုဟှာ ကော်နေလိန စကားပြောရင်း အီထဲဟှို ဝမ်ဟှားဟှူ ခီမာ လူလေဘောင်ဂီး စုနေဇာဟှို တွိလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","အယ်လူလေဟှို ပေတရုဟှ “ယုဒလူလေဟှာ လူမျိုးခြားလေန ပေါန်းဖော်ဟှို့န သူးနို့နားဟှို အီးခ္လယ်သွားဟှို့တွပ် ဘာသာတရားဟှ ခွမ့်ပြုဟှ ဆိုဇာဟှို နန်းနို့ ကိုယ်တိုင်လည်း ကောန်းကောန်း သိဂေ့ဟှယ်။ အယ်ဘေမဲ့ ဖယ်လူဟှိုမျှ ညစ်ညူးဟှူလူ၊ စင်ကြယ်ဘဲဟှူလူ ဆိုဘီး ခေါ်ဘဲနေဟှို့တွပ် ဘုရားသခင်ဟှာ ငါ့ဟှို ဖော်ပြတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","အယ်ကြောန့် ငါ့ဟှို နန်းနို့ ခေါ်ဖိဟှူ ခီမာ ငါဟှာ ငြင်းဆိုဘဲန လိုက်လာဟှယ်။ ဖြားဖြစ်ကြောန့် ငါ့ဟှို ခေါ်ဖိရနူး” ဆိုဘီး မေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ကော်နေလိဟှ “ပီးဟှားဟှူ သောင်းရစ်လော့‑က်ဒူးဟှ နေဒန်သောင်းနာရီမာ ကျွန်တော်ဟှာ အီမာ ဆုတောန်းနေဟှယ်။ အယ်ခီမာ တော့‑က်ပြောန်နေဟှူဝတ်န လူတယော့‑က်ဟှာ ကျွန်တော့်ရှေ့မာ ရော့‑က်တရစ်ရပ်ဘီး ");
INSERT INTO tvn_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘ကော်နေလိ၊ နန့်ဆုတောန်းသံဟှို ဘုရားသခင်ဟှ ကြားဟှယ်။ နန့် စွန့်ကြဲပေးကမ်းဟှူ ဇာလေဟှိုလည်း သိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","အယ်ကြောန့် ယုပ္ပေဗြို့ဟှို လူလွှတ်ဘီးဟှာ ပေတရု နာမယ်ရှိဟှူ ရှိမုန်ဟှို ခေါ်ဖိလိုက်။ သူဟှာ ပန်လယ်ကမ်းနားမာရှိဟှူ သရေလောက်မား ရှိမုန်အီမာ ရှိနေဟှယ်’ ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","အယ်ကြောန့် ကျွန်တော်ဟှာ ရှစ်ရှင်းဘဲ သင့်နားဟှို လူလွှတ်လိုက်ဟှယ်။ သင်ကြွလာဇာတွပ် ကျေးဇူးတန်ဟှယ်။ သင့်ဟှို သခင်ဘုရား ပြောဟှားဟှူ စကားလေဟှို ကြားရဟှို့တွပ် ကျွန်တော့်လေဟှာ ဘုရားသခင်ရှေ့မာ ဆင်သင့်ဖြစ်နေဂေ့ဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","အယ်ဘီးန ပေတရုဟှ “ဘုရားသခင်ဟှာ မှန်တိုင်းဘဲ့ မျစ်နှာလိုက်ဟှ ဆိုဇာဟှို ခု ငါဟှာ နားလည်ဟှားဘီ။ ");
INSERT INTO tvn_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ဘုရားသခင်ဟှို ကြော့‑က်ဘီး ဖြောန့်မတ်ဟှူ လူမျိုးတိုင်းဟှိုဘဲ့ လတ်ခံဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ဘုရားသခင်ဟှာ ဂူလောင်းရဲ့ သခင်ဖြစ်ဟှူ ယေရှုခရစ်တော်အားဖြင့် ငြီသတ်ဇာနဆိုင်ဟှူ ဒန်းကောန်းဟှို ဣသရေလလူမျိုးလေဟှို ဟောဟှို့တွပ် စေလွှတ်လိုက်ဟှယ် ဆိုဇာဟှို နန်းနို့ သိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ဗတ္တိဇံတရားဟှို ယောဟန်ဟောပြောဘီးန ဂါလိလဲပြည်ဟှနေ စဘီးဟှာ ယုဒပြည် တရှော့‑က်လောင်းမာ ကီးမားဟှူ ဖြစ်ပျစ်ဟှို နန်းနို့ သိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ဘုရားသခင်ဟှာ နာဇရက်ဗြို့သား ယေရှုဟှို သန့်ရှင်းဟှူဝိညာဉ်တော်န တဂိုးတော်လေ ကိုယ်တော်ထတ်ဟှို ဖယ်မျိုးလောန်းခ္လဟှားဟှယ် ဆိုဇာဟှို နန်းနို့ သိဂေ့ဟှယ်။ ဘုရားသခင်ဟှာ ကိုယ်တော်နတူးဒူ ရှိဟှူကြောန့် ကိုယ်တော်ဟှာ နေရာတိုင်းဟှို သွားဘီးဟှာ ကောန်းဇာလေ လောက်ဆောန်ဘီး မာရ်နတ်ရဲ့ တဂိုးအော့‑က်မာရှိဟှူ လူလေ ဂူလောင်းဟှို ကျန်းမာစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","နို့လေဟှာ ယေရုရှလင်ဗြို့န ယုဒပြည်မာ ကိုယ်တော်လောက်ဟှူဇာ ဂူလောင်းရဲ့ သတ်သေလေဖြစ်ဂေ့ဟှယ်။ အယ်ဘီးန လူလေဟှာ ကိုယ်တော့်ဟှို လတ်ဝါးကပ်တိုင်မာ ခိဆွဲဘီး သတ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","အယ်ဘေမဲ့ သောင်းရစ်ကြာဘီးန ဘုရားသခင်ဟှာ ကိုယ်တော့်ဟှို သေရာဟှနေ ထမြော့‑က်စေဘီးဟှာ ကိုယ်ထန်ရှားပြဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","အယ်ဘေမဲ့ လူတိုင်းဟှာ ကိုယ်တော့်ဟှို ဗြင်ရဂေ့ဇာ မှုဟှ။ သိသတ်သေလေဖြစ်န ဘုရားသခင်ဟှ ကြိုတန်ဘီး ဝီးကော့‑က်ဟှားဟှူ၊ သေရာဟှနေ ထမြော့‑က်ဘီးန ကိုယ်တော်နတူးဒူ စားသောက်ဂေ့ဟှူ နို့လေမျှဘဲ့ ဗြင်ရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ကိုယ်တော်ဟှ လူလေဟှို ဒန်းကောန်း ဟောပြောဟှို့တွပ်န ကိုယ်တော်ဟှာ သတ်ရှင်နေဟှူလူလေန သေဟှားဟှူလူလေဟှို တရားစီရင်ဟှူ သခင်ဖြစ် ဘုရားသခင်ခန့်ဟှားဟှယ် ဆိုဇာဟှို သတ်သေခံဟှို့တွပ် နို့လေဟှို မိန့်မှာဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ကိုယ်တော့်ဟှို ယောင်ကြည်ဟှူ လူတိုင်းဟှာ ကိုယ်တော်ရဲ့ နာမတော်အားဖြင့် ပြစ်လွှတ်ခံရလေ့မယ် ဆိုဘီး ကိုယ်တော်ကြောန်းဟှို ပရောဖက်လေဟှ သတ်သေခံဟှားဟှယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","အယ်စကားဟှို ပေတရုဟှ ပြောနေဒူးမာ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှာ တရားစကားဟှို နားထောန်နေဂေ့ဟှူ လူလေထတ်ဟှို ဆင်းလာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ပေတရုနတူးဒူး လိုက်လာဟှူ ရေဖျားလှီးဟှားဟှူ ယောင်ကြည်သူ ယုဒလူမျိုးလေဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်ရဲ့ လတ်ဆောန်ဟှို လူမျိုးခြားလေထတ်ဟှိုလည်း သွန်းလောန်းဟှူကြောန့် ရရာတိုင်း အံ့ဩဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ လူမျိုးခြားလေဟှာ ထူးဆန်းဟှူ ဘာသာစကားလေဟှို ပြောနေဂေ့ဇာန ဘုရားသခင်ရဲ့ ဂေါင်တော်ဟှို ချီးမွမ်းဂေ့ဇာဟှို ကြားရဂေ့ဟှယ်။ အယ်ကြောန့် ပေတရုဟှ၊ ");
INSERT INTO tvn_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“အယ်လူလေဟှာ နို့လေမျိုးဘဲ့ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို ခံရဂေ့ဟှယ်။ အယ်ကြောန့် သူးနို့ဟှို ရေနဗတ္တိဇံဟှို ခံယူဘဲနေအောန် ဖယ်လူဟှ တားနိုင်ဟှို့နူး” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","အယ်ကြောန့် ပေတရုဟှာ သူးနို့ဟှို ယေရှုခရစ်တော်ရဲ့ နာမတော်မာ ဗတ္တိဇံခံဟှို့တွပ် မိန့်ပေးလိုက်ဟှယ်။ အယ်ဘီးန ပေတရုဟှို သူးနို့လေနတူးဒူ ရစ်နဲနဲနေဟှို့တွပ် တောန်းလျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","လူမျိုးခြားလေဟှ ဘုရားသခင်ရဲ့ စကားတော်ဟှို လတ်ခံရရှိဂေ့ဟှယ် ဆိုဇာဟှို ယုဒပြည် နေရာနှံ့မာ ရှိနေဟှူ တမန်တော်လေန ယောင်ကြည်သူ ညီကိုလေဟှ ကြားရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ယေရုရှလင်ဗြို့ဟှို ပေတရု ရော့‑က်ဟှူ ခီမာ ရေဖျားလှီးဟှားဟှူ ယောင်ကြည်သူ ညီကိုလေဟှ သံသယဖြစ်ဟှူကြောန့် ");
INSERT INTO tvn_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“နန်ဟှာ ရေဖျားလှီးဘဲဟှူ လူမျိုးခြားလေရဲ့ အီဟှို ဝမ်ဘီးဟှာ သူးနို့န တူးဒူ စားသော့‑က်နေမား” ဆိုဘီး သူ့ဟှို ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","အယ်ကြောန့် ပေတရုဟှာ ကြောန်းရာတခုလောင်းဟှို စဟှနေဆောင်းထိ ပြောပြလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ပေတရုဟှ “ငါဟှာ ယုပ္ပေဗြို့မာ ဆုတောန်းနေဒူးမာ ရူပါရောင်ဟှို ဗြင်ရဟှယ်။ ဒေါ့‑က်လေးဒေါ့‑က်န ချောက်ဟှားဟှူ ပိစဂီးတခုန တူဟှူဇာဟှာ ကောန်းဂန်ဟှနေ နိက္လလာဘီး ငါ့နားဟှို ရော့‑က်လာဇာဟှိုလည်း ငါဗြင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ငါဟှာ အယ်မူဇာထဲဟှို သေးသေချားချာဟှား ကေ့လိုက်ဟှူ ခီမာ ခေလေးရှောန်းလိဆန်လေ၊ မ္လေဂီးမာနေဟှူ သားရဲလေ၊ တွားဘီးသွားဟှူ လိဆန်လေန ကောန်းဂန်ဟှ ငှတ်လေဟှို ဗြင်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","အယ်ဘီးန ‘ပေတရု၊ ထဘီး သတ်စားလိုက်’ ဆိုဘီး ငါ့ဟှို ပြောဟှူသံဟှို ငါကြားရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","အယ်ဘေမဲ့ ငါဟှ ‘သခင်၊ ဖယ်မျိုးလည်း ဖြစ်နိုင်ဟှ။ ကျွန်တော်ဟှာ ညစ်ညူးဇာန သန့်ရှင်းဘဲဟှူဇာဟှို ဖယ်ဒူးဟှလည်း စားဖူးဟှ’ ဆိုဘီး ပ္လန်လျှော့‑က်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ကောန်းဂန်ဟှနေ သံတော်ဟှ ‘ဘုရားသခင်ဟှ သန့်ရှင်းဟှယ် ဆိုဇာဟှို ညစ်ညူးဟှယ် ဆိုဘီး ပြောန’ ဆိုဘီး ဒုတိယခါ မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","အယ်မျိုး သောင်းခါဖြစ်ဘီးန အယ်ဇာတခုလောင်းဟှို ကောန်းဂန်ထဲဟှို ပ္လန်ဘီး ဆွဲဒန်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ရှစ်ဟှားကြာဘီးန ကဲသရိဗြို့ဟှနေဘီး ငါ့နားဟှို လွှတ်လိုက်ဟှူ လူသောင်းယော့‑က်ဟှ ငါတည်းနေဟှူ အီဟှို ရော့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ဝိညာဉ်တော်ဟှ သံသယမှေ့ဘဲန အယ်လူလေန တူးဒူ လိုက်ဟှားဟှို့တွပ် ငါ့ဟှို ပြောဟှယ်။ ယုပ္ပေဗြို့ဟှ ညီကိုခြော့‑က်ယော့‑က်လည်း ငါ့နတူးဒူ လိုက်ဂေ့ဟှယ်။ နို့လေဂူလောင်းဟှာ ကော်နေလိရဲ့ အီထဲဟှို ဝမ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ကော်နေလိဟှ သူ့အီမာ ကောန်းဂန်တမန်တပါးဟှ ရပ်ဘီးဟှာ ‘ပေတရု နာမယ်ရှိဟှူ ရှိမုန်ဟှို ခေါ်ဟှို့တွပ် ယုပ္ပေဗြို့ဟှို ယော့‑က်ယော့‑က်ဟှို လွှတ်လိုက်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","အယ်လူဟှာ နန့်န နန့်မိသားစု ဂူလောင်းဟှို ကယ်တန်ခံရမယ့် တရားစကားဟှို ပြောလေ့မယ်’ ဆိုဘီး နို့လေဟှို ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","အယ်ဘီးန ငါဟှာ စဘီးပြောဟှူ ခီမာ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှာ ရင်းရင်ဒူးဟှ နို့လေထတ်ဟှို ဆင်းလာမျိုးဘဲ့ အယ်လူလေထတ်ဟှိုလည်း ဆင်းလာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","အယ်ခီမာ ‘ယောဟန်ဟှာ ရေန ဗတ္တိဇံပေးဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န ဗတ္တိဇံခံရဂေ့လေ့မယ်’ ဆိုဘီး သခင်ဘုရား မိန့်တော်မူဟှားဇာဟှို ငါဟှာ ပ္လန်ဒိရဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ဘုရားသခင်ဟှာ သခင်ယေရှုခရစ်တော်ဟှို ယောင်ကြည်ဟှူ နို့လေဟှို ပေးဟှူမျိုးဘဲ့ အယ်လူမျိုးခြားလေဟှိုလည်း တူညီဟှူ လတ်ဆောန်ဟှို ပေးဟှယ် ဆိုဇာ ထန်ရှားနေဟှယ်။ အယ်ဆိုဟှာ ငါဟှာ ဖယ်မျိုးလူ ဖြစ်ဟှူကြောန့် ဘုရားသခင်ဟှို တားနိုင်ဟှို့နူး!” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","အယ်စကားဟှို ကြားရဟှူ ခီမာ အယ်လူလေဟှာ ပြစ်တန်ဂေ့ဟှမ်း။ အယ်ဘီးန ဘုရားသခင်ဟှို ချီးမွမ်းဂေ့ဘီး “အယ်ဆိုဟှာ ဘုရားသခင်ဟှာ သတ်ရှင်ဟှို့တွပ် ပို့ဆောန်ဟှူ နောန်ဒတရားဟှို လူမျိုးခြားလေဟှိုလည်း ပေးတော်မူဘီ။” ");
INSERT INTO tvn_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ယောင်ကြည်သူလေဟှာ သတေဖန်သတ်ခံရဟှူ ခီမာ ဖြစ်လာဟှူ ညှဉ်းဆဲမှုကြောန့် နေရာတိုင်းဟှို ကွဲဟှားဂေ့ဟှယ်။ တချို့ လူလေဟှာ ဖိနိတ်ပြည်၊ ကုပရုကျွန်း၊ အန္တိအုတ်ဗြို့ထိ ရော့‑က်ဟှားဂေ့ဟှယ်။ သူးနို့ဟှာ ဘုရားသခင်ရဲ့ စကားတော်ဟှို ယုဒလူမျိုးလေဟှိုဘဲ့ ဟောပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","သူးနို့ထဲမာ ကုပရုကျွန်းန ကုရေနေနယ်ဟှ ယောင်ကြည်သူလေ တချို့ပါဟှယ်။ သူးနို့ဟှာ အန္တိအုတ်ဗြို့ဟှို သွားဘီးဟှာ လူမျိုးခြားလေဟှို သခင်ယေရှုရဲ့ ကြောန်းဖြစ်ဟှူ ဒန်းကောန်းဟှို ဟောပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","သူးနို့ဟှာ သခင်ဘုရားရဲ့ တဂိုးတော်ဟှို ခံရဂေ့ကြောန့် လူလေဘောင်ဂီးဟှ ယောင်ကြည်ဘီးဟှာ သခင်ဘုရားဖတ်ဟှို ပ္လောန်းလဲလာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","အယ်ဒန်းဟှို ယေရုရှလင်ဗြို့မာရှိဟှူ သင်းတော်ဟှ ကြားရဟှူ ခီမာ ဗာနဗဟှို အန္တိအုတ်ဗြို့ဟှို လွှတ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","သူဟှာ အယ်ဗြို့ဟှို ရော့‑က်ဟှူ ခီမာ လူလေဟှာ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟှို ဗြင်ရဟှူ ခီမာ ရရာတိုင်း ဝန်းသာဘီးဟှာ သခင်ဘုရားဟှို စိနှလောင်းကြွင်းမဲ့ ယောင်ကြည်ဘီး သစ်စာစောန့်ဂေ့ဟှို့တွပ် တိုက်တွန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ဗာနဗဟှာ သူတော်ကောန်းဖြစ်ဘီး သန့်ရှင်းဟှူဝိညာဉ်တော်နရော၊ ယောင်ကြည်ရှင်းနရော ပ္လဲ့ဝနေဟှယ်။ အယ်ကြောန့် လူလေဘောင်ဂီးဟှာ သခင်ဘုရားဖတ်ဟှို ပ္လောန်းလဲလာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","အယ်ဘီးန ဗာနဗဟှာ ရှောလုဟှို ရှာဟှို့တွပ် တာရှုဗြို့ဟှို သွားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","သူ့ဟှို တွိဟှူ ခီမာ အန္တိအုတ်ဗြို့ဟှို ခေါ်လာဟှယ်။ သူးနို့ နှေ့ယော့‑က်ဟှာ တနှစ်လောင်းလောင်း သင်းတော်မာ စုဝေးဂေ့ဘီးဟှာ လူလေဟှို သွန်သန်ဟှယ်။ တဗဲ့တော်လေဟှာ ပထမဦးဆောင်း ခရစ်ယာန် ဆိုဘီး ခေါ်ခံရဟှူနေရာဟှာ အန္တိအုတ်ဗြို့မာ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","အယ်ခီမာ ပရောဖက်တချို့ဟှာ ယေရုရှလင်ဗြို့ဟှနေ အန္တိအုတ်ဗြို့ဟှို လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","အယ်လူလေထဲဟှ အာဂဗု နာမယ်ရှိဟှူ လူတယော့‑က်ဟှာ ထဘီးဟှာ တကမ္ဘာလောင်းမာ ငတ်မွတ်ခေါန်းပါးဘေး ရော့‑က်လာလေ့မယ် ဆိုဘီး ဝိညာဉ်တော်အားဖြင့် ကြိုတန်ဘီး ဟောပြောလေဟှယ်။ အယ်မူဇာဟှာ မန်းဂီး ကလောဒိ လတ်ထတ်မာ ငတ်မွတ်ခေါန်းပါးဘေး က္လရော့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","တဗဲ့တော်လေဟှာ သူးနို့ တတ်နိုင်မျှတိုင်းဘဲ့ ယုဒပြည်မာရှိနေဟှူ ညီကို မောန်နှမလေဟှို ကူညီဟှို့တွပ် ဆောင်းဖြတ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","အယ်မျိုး ဆောင်းဖြတ်ဂေ့ဘီးန ကပ်လေဟှို ဗာနဗန ရှောလုလေအားဖြင့် ယေရုရှလင်ဗြို့မာရှိဟှူ သင်းတော် လူဂီးလေနားဟှို ပို့ပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","အယ်ခီကာလမာ ဟေရုဒ်မန်းဂီးဟှာ သင်းတော်ဝမ်တချို့ဟှို စဘီးဟှာ ညှဉ်းဆဲဟှို့တွပ် ကြံစည်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","သူဟှာ ယောဟန်ရဲ့ နောန် ယာကုပ်ဟှို ထားန သတ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","အယ်မူဇာဟှို ယုဒလူမျိုးလေဟှ နှစ်သက်ဂေ့ဟှယ်။ အယ်ကြောန့် သူဟှာ ပေတရုဟှိုလည်း ဖမ်းဟှားလေဟှယ်။ အယ်မူဇာဟှာ တဆေးမှေ့ဘဲ့ဟှူ မုပွဲတော်ခီမာ ဖြစ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ဟေရုဒ်ဟှာ ပေတရုဟှို ဖမ်းဘီးန စစ်သားလေးယော့‑က်စီပါဟှူ တပ်စုလေးစုရဲ့ လတ်ထဲဟှို အပ်ဘီးဟှာ ကျဉ်းခ္လဟှားဟှယ်။ ပသခါပွဲပီးဟှားဘီးန သူ့ဟှို ယုဒလူမျိုးလေရဲ့ ရှေ့မာ စစ်ဆေးဘီးဟှာ စီရင်ဟှို့တွပ် ကြံစည်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","အယ်ကြောန့် ပေတရုဟှာ ထောန်ထဲမာ ကျဉ်းခ္လခံရဟှယ်။ အယ်ခီမာ သင်းတော်ဟှ သင်းသားလေဟှာ ပေတရုတွပ် စိပါလတ်ပါန ဘုရားသခင်ဟှို ဆုတောန်းနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ဟေရုဒ်ဟှာ ပေတရုဟှို လူလေရှေ့ဟှို ခေါ်လာဘီး စစ်ဆေးဟှူ နေ့ရော့‑က်ခန် ညဉ့်ခန်းဇာမာ ပေတရုဟှာ စစ်သားနှေ့ယော့‑က်ကြားမာ အိမွိနေဟှယ်။ သူ့ဟှို သံကြိုးနှေ့ပန်န ခယ်ဟှားဟှယ်။ ထောန်ခွဗော့‑က်ရှေ့မာလည်း စောန့်တပ်သားလေဟှာ စောန့်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်ဟှာ ရော့‑က်တရစ် ပေါ်လာဘီးဟှာ ချောက်ခန်းထဲမာ လန်းဟှားလေဟှယ်။ ကောန်းဂန်တမန်ဟှာ သူ့ရဲ့ခေါင်းဟှို လှောက်ဘီးဟှာ “ဗြန်းဗြန်ဟှားထလိုက်!” ဆိုဘီး နိုးဟှယ်။ ရှစ်ရှင်းဘဲ ခယ်ဟှားဟှူ သံကြိုးလေဟှာ ပေတရုရဲ့ လတ်ဟှနေ ကလွတ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","အယ်ဘီးန ကောန်းဂန်တမန်ဟှ “နန့်ရဲ့ ခါးဗတ်ဟှို ပတ်ဘီးဟှာ ခေနပ်ဟှို စီးလိုက်” ဆိုဘီး ပြောလိုက်ဟှယ်။ ပေတရုဟှာ ပြောဟှူတိုင်း လောက်လိုက်ဟှယ်။ ကောန်းဂန်တမန်ဟှ “ဝတ်လောင်ဟှို ချောင်ဘီးဟှာ ငါ့နတူးဒူလိုက်” ဆိုဘီး ပြောလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ပေတရုဟှာ ချောက်ခန်းဟှနေထွပ်ဘီး သူ့နော့‑က်ဟှို လိုက်ဟှားလေဟှယ်။ သူဟှာ ကောန်းဂန်တမန် လောက်ဟှူဇာလေဟှို မှန်ဖြစ်ဟှယ် ဆိုဇာ သိဟှ။ ရူပါရောင်ဟှို ဗြင်နေဟှယ် ဆိုဘီး ထန်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","သူးနို့ဟှာ စောန့်လေခ္လဟှားဟှူ နေရာနှေ့ခုဟှို ကျော်ဘီးဟှာ ထောန်ထဲဟှထွပ်ဟှူ သံခွဗော့‑က်နားဟှို ရော့‑က်ဟှားဂေ့ဟှယ်။ အယ်ခွဗော့‑က်ဟှာ သူ့လိုလို ပွမ့်နေဟှူကြောန့် သူးနို့ ထွပ်ဟှားဘီးဟှာ လမ်းတိုင်းသွားလိုက်ဂေ့ဟှယ်။ အယ်ဘီးန ကောန်းဂန်တမန်ဟှာ ပေတရုနားဟှနေ ရော့‑က်တရစ် ထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ပေတရုဟှာ ပ္လန်ဘီး ဒိရလာဟှူ ခီမာ “သခင်ဘုရားဟှာ သူ့ရဲ့ ကောန်းဂန်တမန်ဟှို လွှတ်ဘီးဟှာ ငါ့ဟှို ဟေရုဒ်ရဲ့ လတ်ထဲဟှရော၊ ယုဒလူမျိုးလေရဲ့ လတ်ထဲဟှို ငါ့ဟှို ရော့‑က်စေဘဲဟှို့တွပ် မျှော်နေဟှူဘေးဟှနေ ကယ်တန်ရှင်းဟှို ခု ငါစစ်မှန်သိဟှားဘီ ဆိုဘီး ပြောဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","အယ်မျိုးသိဟှူ ခီမာ သူဟှာ မာကု ဆိုဘီး ခေါ်ဟှူ ယောဟန်ရဲ့မိ မာရိအီဟှို သွားဟှယ်။ အယ်အီမာ လူလေဘောင်ဂီးဟှ စုဘီးဟှာ ဆုတောန်းနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ပေတရုဟှာ အီခွဗော့‑က်ဟှို ခေါ့‑က်လိုက်ဟှူ ခီမာ ရောဒေနာမယ်ရှိဟှူ၊ စေခံ မီးမဂန်းဟှားဟှာ ခွဗော့‑က်ဖွမ့်ဟှို့ လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","သူဟှာ ပေတရုသံဟှို မှတ်မိဟှူကြောန့် ရရာတိုင်း ဝန်းသာဘီးဟှာ ခွဗော့‑က်ဟှို ဖွမ့်ဘဲန အီထဲဟှို ပ္လေးဟှားဘီး ပေတရု ပ္လန်မာရော့‑က်နေဟှယ် ဆိုဘီး လူလေဟှို ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","အယ်လူလေဟှ “နန်ဟှာ ရူးနေမား” ဆိုဘီး ပြောဟှယ်။ အယ်ဘေမဲ့ မီးမဂန်းဟှားဟှ သူပြောနေဇာဟှာ မှန်းမှန်ကန်းကန် ဖြစ်နေဟှူကြောန့် သေးသေချားချာဟှား ပြောဟှူ ခီမာ သူးနို့ဟှာ “ပေတရုရဲ့ ကောန်းဂန်တမန် ဖြစ်လေ့မယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ပေတရုဟှာ ခွဗော့‑က်ဟှို ဆစ်ဘီးဟှာ ခေါ့‑က်နေဟှူ ခီမာ သူးနို့ဟှာ ခွဗော့‑က်ဟှို ဖွမ့်လိုက်ဂေ့ဟှူကြောန့် ပေတရုဟှို ဗြင်ဟှားဘီး အံ့ဩဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ပေတရုဟှာ တိတိဟှား နေဂေ့ဟှို့တွပ် လတ်နချစ်ပြဘီးဟှာ သခင်ဘုရားဟှာ သူ့ဟှို ထောန်ထဲဟှ ဖယ်မျိုးခေါ်ထုလာဟှယ် ဆိုဇာဟှို ပြောပြဟှယ်။ အယ်ဘီးန “အယ်ကြောန်းဟှို ယာကုပ်န တခြားညီကို မောန်နှမ လေဟှိုလည်း ပြောပြဂေ့ပါ” ဆိုဘီး တခြားနေရာဟှို ထွပ်ဟှားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","မိုးလန်းလာဟှူ ခီမာ “ပေတရုဟှ ဖယ်မာနူး” ဆိုဘီး စောန့်တပ်သားလေဟှာ ရရာတိုင်း ကြော့‑က်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ဟေရုဒ်မန်းဂီးဟှာ ပေတရုဟှို ရှာခိုင်းဟှူ ခီမာ တွိဘဲ့ကြောန့် စောန့်တပ်သားလေဟှို စစ်ဆေးဘီးန သေဒန်ပေးဟှို့တွပ် မိန့်ခ္လလိုက်ဟှယ်။ အယ်ဘီးန ဟေရုဒ်မန်းဂီးဟှာ ယုဒပြည်ဟှနေ ထွပ်ဟှားဘီးဟှာ ကဲသရိဗြို့ထဲမာ ရှစ်ဟှားနေနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ဟေရုဒ်မန်းဂီးဟှာ တုရုဗြို့သားလေန ဇိဒုန်ဗြို့သားလေဟှို ရရာတိုင်း ဒေါသထွပ်ဟှူကြောန့် အယ်ဗြို့သားလေဟှာ စည်းရောင်းဘီးဟှာ မန်းဂီးနားဟှို ရော့‑က်လာဂေ့ဟှယ်။ နန်းတော်အောက် ဗလတ္တုရဲ့ ကူညီဟှို ယူဂေ့ဘီး ဟေရုဒ်မန်းဂီးနားဟှို ဝမ်ဘီးဟှာ ငြီသတ်ဟှို့တွပ် စကားကမ်းလှမ်းဂေ့ဟှယ်။ ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူးနို့ပြည်ဟှာ ဟေရုဒ်မန်းဂီးရဲ့ ပြည်ဟှို မှီခိုစားသော့‑က်နေရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ဟေရုဒ်ဟှာ ချီးချစ်ဟှားဟှူနေ့မာ မန်းဂီးအန်းဂီလေဟှို ဝတ်ဘီးဟှာ ရာဇပလ္လင်ထတ်မာ ထိုင်ဘီးဟှာ လူလေဟှို မိန့်ခွန်းပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","အယ်လူလေဟှ “အယ်သံဟှာ လူရဲ့သံ မှုဟှ။ ဘုရားသခင်ရဲ့ သံတော်ဖြစ်ဟှယ်” ဆိုဘီး ကြွေးကြော်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","အယ်ခီမာ မန်းဂီးဟှာ ဘုရားသခင်ရဲ့ ဂေါင်တော်ဟှို ချီးမွမ်းဘဲကြောန့် ရှစ်ရှင်းဘဲ့ ဘုရားသခင်ရဲ့ ကောန်းဂန်တမန်ဟှာ သူ့ဟှို ဒန်ခတ်လိုက်ဟှူကြောန့် သူဟှာ ပိုးလေစားခံရဘီး သေဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","အယ်ခီမာ ဘုရားသခင်ရဲ့ စကားတော်ဟှာ နေရာတိုင်းဟှို ပ္လံ့နှံ့ဟှားဘီးဟှာ ယောင်ကြည်သူလေဟှာ တိုးပွားလာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ဗာနဗန ရှောလုလေဟှာ သူးနို့ မှုကိစဟှို လောက်ဂေ့ဘီးန မာကု ဆိုဘီး ခေါ်ဟှူ ယောဟန်ဟှို သူးနို့နတူးဒူ ခေါ်ဘီးဟှာ ယေရုရှလင်ဗြို့ဟှနေ ပ္လန်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","အန္တိအုတ်ဗြို့ဟှ သင်းတော်မာ ပရောဖက်လေန ဆရာလေရှိဟှယ်။ အယ်လူလေဟှာ ဗာနဗ၊ နိဂါ ဆိုဘီး ခေါ်ဟှူ ရှုမောင်၊ ကုရေနေနယ်သား လုကိ၊ စော်ဘွားဟေရုဒ်ရဲ့ ငယ်ဂျင်းဖြစ်ဖူးဟှူ မာနင်န ရှောလုဟှားလေ ဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","အယ်လူလေဟှာ သခင်ဘုရားရဲ့ မှုတော်ဟှို လောက်ဆောန်ဘီး စာရှောန်နေဂေ့ဒူးမာ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှ သူးနို့ဟှို “ရှောလုန ဗာနဗလေဟှို ငါ့မှုဟှို ဆောန်ဟှို့တွပ် သီးသန့် ဝီးကော့‑က်ဟှားဂေ့” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","သူးနို့ဟှာ စာရှောန်ဆုတောန်းဘီးန ဗာနဗန ရှောလုလေရဲ့ ခေါန်းထတ်မာ သူးနို့လတ်ဟှို တန်ဂေ့ဟှယ်။ အယ်ဘီးန သူးနို့ဟှို မှုတော်ဆောန်ဟှို့တွပ် လွှတ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ဗာနဗန ရှောလုလေဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော် လွှတ်လိုက်တိုင်းဘဲ့ သေလုကိဗြို့ဟှနေ ကုပရုကျွန်းဟှို သန်းဖောန သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","သူးနို့ဟှာ ရှာလမိဗြို့ဟှို ရော့‑က်ဟှူ ခီမာ ယုဒလူမျိုးလေရဲ့ ဝါလယ်ဇရပ်လေမာ ဘုရားသခင်ရဲ့ စကားတော်ဟှို ဟောပြောဂေ့ဟှယ်။ မာကု ဆိုဘီး ခေါ်ဟှူ ယောဟန်ဟှာ သူးနို့လေရဲ့ လတ်ထော့‑က်နေန ကူညီပေးဟှို့တွပ် ခေါ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","သူးနို့ဟှာ အယ်ကျွန်းဟှို ဖြတ်ဟှားဘီးဟှာ ပါဖုဗြို့ထိ သွားဂေ့ဟှယ်။ အယ်ဗြို့မာ ယုဒလူမျိုး ပရောဖက်တုယောန်ဖြစ်ဟှူ နတ်ဝိဇ္ဇာတယော့‑က်ဟှို တွိဂေ့ဟှယ်။ သူ့နာမယ်ဟှ ဗာယေရှု ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","သူဟှာ ဗြို့ဝန်မန်း သေရဂိပေါလုရဲ့ မိဆွေဖြစ်ဟှယ်။ အယ်ဗြို့ဝန်မန်းဟှာ ဒိပညာရှိဟှူ လူတယော့‑က်ဖြစ်ဟှယ်။ သူဟှာ ဘုရားသခင်ရဲ့ စကားတော်ဟှို ကြားရှင်ဟှူကြောန့် ဗာနဗန ရှောလုဟှို ဖိခေါ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","အယ်ဘေမဲ့ ဟေလသဘာသာန ဧလုမနာမယ်ရှိဟှူ နတ်ဝိဇ္ဇာတယော့‑က်ဟှာ ဗြို့ဝန်မန်းဟှို ယောင်ကြည်ရှင်းဟှနေ လွဲစေဟှို့တွပ် ဗာနဗန ရှောလုလေဟှို တားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","အယ်ခီမာ ပေါလု ဆိုဘီး ခေါ်ဟှူ ရှောလုဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န ပ္လဲ့ဝဘီး နတ်ဝိဇ္ဇာသမားဟှို စိုက်ကေ့ဘီးန၊ ");
INSERT INTO tvn_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“နန်ဟှာ မာရ်နတ်ရဲ့သား! လှည့်ဇားလီညာသူ၊ မှန်တရားရဲ့ ရန်သူ၊ နန်ဟှာ ဘုရားသခင်ရဲ့ ဖြောန့်မတ်ဟှူလမ်းဟှို ဖျစ်ဆီးဘဲန နေနိုင်ဟှလော။ ");
INSERT INTO tvn_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ခုဘဲ့ ဘုရားသခင်ရဲ့ လတ်တော်ဟှာ နန့်ထတ်မာ က္လလာဘီးဟှာ မျစ်စိကန်းလေ့မယ်။ နန်ဟှာ နေဟှို ကြာဂီးဗြင်ရဟှို့ မှုဟှ” ဆိုဘီး ပြောဟှယ်။ ရှစ်ရှင်းဘဲ့ ဧလုမဟှာ မျစ်စိကန်းဟှားဘီးဟှာ လောင်းဝ မှောန်မိုက် ဖြစ်ဟှားကြောန့် သူ့လတ်ဟှို ဆွဲဘီး လမ်းပြပေးဟှူလူဟှို စမ်းတဝါးဝါး ရှာနေရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ဗြို့ဝန်မန်းဟှာ အယ်ဖြစ်ပျစ်ဇာဟှို ဗြင်ဟှူ ခီမာ ယောင်ကြည်လာဟှယ်။ သူဟှာ သခင်ဘုရားရဲ့ တရားတော်ဟှို ကြားရခီမာလည်း အံ့ဩနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ပေါလုန သူ့ပေါန်းဖော်လေဟှာ ပါဖုဗြို့ဟှနေ သန်းဖောနသွားဘီးန ပံဖုလိပြည် ပေရဂေဗြို့ဟှို ရော့‑က်ဟှားဂေ့ဟှယ်။ အယ်နေရာမာ မာကု ဆိုဘီး ခေါ်ဟှူ ယောဟန်ဟှာ သူးနို့န လမ်းခွဲဘီးဟှာ ယေရုရှလင်ဗြို့ဟှို ပ္လန်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","သူးနို့ဟှာ ပေရဂေဗြို့ဟှ ထွပ်ဟှားဘီးဟှာ ပိသိဒိပြည် အန္တိအုတ်ဗြို့ဟှို ရော့‑က်ဟှားဘီး ဒန်းနေ့မာ ဝါလယ်ဇရပ်ဟှို ဝမ်ဘီး ထိုင်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ပညတ်ကျမ်းန ပရောဖက်ကျမ်းလေဟှို ဖတ်ဟှူ ခီမာ ဝါလယ်ဇရပ် တာဝန်ခံလေဟှာ သူးနို့ဟှို “ညီကိုလေ၊ အယ်လူလေဟှို တိုက်တွန်းအားပေးဟှူစကား ပြောမယ် ဆိုဟှာ ပြောဂေ့ပါ” ဆိုဘီး ကြောန်းကြားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ပေါလုဟှာ ထဘီးဟှာ လတ်နပြလိုက်ဘီးန “ဣသရေလလူမျိုးလေန ဘုရားသခင်ဟှို ကိုးကွယ်ဟှူ လူမျိုးခြားလေ ငါ့စကားဟှို နားထောန်ဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ဣသရေလလူမျိုးလေရဲ့ ဘုရားသခင်ဟှာ နို့လေရဲ့ ဘိုးဘေးလေဟှာ အဲဂုတ္တုပြည်မာ ဧည့်သည်ဖြစ်န နေဟှူ ခီမာ သူးနို့ဟှို ဝီးကော့‑က်ဘီးဟှာ လူမျိုးဂီး ဖြစ်စေဟှယ်။ အားကီးဟှူ တဂိုးတော်န အယ်ပြည်ဟှနေ ထုဆောန်ဟှားဟှူ ခီမာ ");
INSERT INTO tvn_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","တောကန္တာရမာ နှစ်လေးဆယ်လောင်းလောင်း သူဟှာ သီးခံဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","အယ်ဘီးန ခါနာန်ပြည်မာနေဟှူ လူမျိုးခွန်နစ်မျိုးဟှို ဖျစ်ဆီးဘီးဟှာ အယ်ပြည်ဟှို သူ့လူမျိုးလေဟှို ပိုင်ပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","အယ်မူဇာလေဟှာ နှစ်ပေါန်းလေးရာငါးဆယ် နီးပါးကြာဟှားဟှယ်။” “အယ်ဘီးန ပရောဖက်ရှမွေလခီထိ တရားသူဂီးလေဟှို ပေါ်လာစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","သူးနို့ဟှာ မန်းဂီးတပါးဟှို တောန်းဂေ့ဟှူကြောန့် ဘုရားသခင်ဟှာ ကိရှရဲ့သား ဗင်္ယာမိန်မျိုးနွယ်ဖြစ်ဟှူ ရှောလုဟှို နှစ်လေးဆယ်လောင်းလောင်း အောက်ချောက်ဟှို့တွပ် သူးနို့ဟှို ပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","အယ်ဘီးန ဘုရားသခင်ဟှာ ရှောလုဟှို ဖယ်ဘီးဟှာ ဒါဝိဒ်ဟှို ဣသရေလရဲ့ မန်းဂီးဖြစ်န ချီးမြှော့‑က်လိုက်ဟှယ်။ ဘုရားသခင်ဟှ ‘ငါ လောက်ခိုင်းဟှားဇာလေဟှို လောက်ဟှို့တွပ် ငါ့ရဲ့ စိတော်နတွိဟှူ ယေရှဲရဲ့သား ဒါဝိဒ်ဟှို ငါတွိဟှားဘီ’ ဆိုဘီး ဒါဝိဒ်န ပတ်သတ်ဇာလေဟှို သတ်သေခံလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ဘုရားသခင်ဟှာ သူ့ရဲ့ ဂဒိတော်တိုင်း ဣသရေလလူမျိုးလေတွပ် ကယ်တန်ရှင်ယေရှုဟှို အယ်ဒါဝိဒ်ရဲ့ သားမ္လေးလေထဲမာ ပေါ်လာစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ယေရှုဟှာ မှုတော်မြတ်ဟှို လောက်ခန်မာ ယောဟန်ဟှာ ဣသရေလလူမျိုးလေဟှို နောန်ဒရဘီး ဗတ္တိဇံခံဂေ့ပါ ဆိုဘီး ဟောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","သူလောက်ရဟှူ မှုတော်မြတ် ပီးဆောင်းခါနီးမာ ယောဟန်ဟှာ ‘နန်းနို့ဟှ ငါ့ဟှို ဖယ်လူ ဆိုဘီး ထန်ဂေ့နူး။ ငါဟှာ နန်းနို့ စောန့်နေဟှူသခင် မှုဟှ။ အယ်သခင်ဟှာ ငါ့နော့‑က်မာ ပေါ်လာလေ့မယ်။ ငါဟှာ အယ်သခင်ရဲ့ ခေနပ်ကြိုးဟှို ဖြေဟှို့ဟှိုမှ ထိုက်ဟှ’ ဆိုဘီး ပြောဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“အာဗြဟံရဲ့ သားမ္လေးလေဖြစ်ဟှူ ငါ့ညီကိုလေန ဘုရားသခင်ဟှို ကိုးကွယ်ဟှူ လူမျိုးခြားလေ၊ ကယ်တန်ရှင်းဆိုင်ဟှူ အယ်မူတရားတော်ဟှို နို့လေနားဟှို ပေးပို့လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ယေရုရှလင်ဗြို့သားလေန သူးနို့ခေါန်းဆောန်လေဟှ အယ်သခင်ဟှာ ကယ်တန်ရှင် ဖြစ်ဟှယ် ဆိုဇာဟှို နားလည်ဂေ့ဟှ။ ဒန်းနေ့တိုင်း သူးနို့ဖတ်ဂေ့ဟှူ ပရောဖက်လေရဲ့ စကားလေဟှိုလည်း နားလည်ဂေ့ဟှ။ အယ်ဘေမဲ့ သူးနို့လေဟှာ ပရောဖက်လေရဲ့ စကားတိုင်း ပ္လဲ့ဇောင်ဟှို့တွပ် အယ်သခင်ဟှို ပြစ်ဒန်စီရင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","အယ်မျိုး သေဒန်စီရင်ဟှို့ ပြစ်တခုလည်း သူးနို့လေ တွိဘေမဲ့လည်း ကိုယ်တော့်ဟှို သေဒန်ပေးဟှို့တွပ် ပိလတ်မန်းဟှို တောန်းဆိုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","သူးနို့ဟှာ အယ်သခင်န ပတ်သတ်ဘီး ကျမ်းစာထဲမာ ပြောဟှားဇာလေဟှို လောက်ဂေ့ဘီးန အယ်သခင်ရဲ့ တဗဲ့တော်လေဟှာ လတ်ဝါးကပ်တိုင်ဟှနေ ခ္လဘီး သန်းခ္လိုင်းဂူမာ သင်္ဂြိုဟ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","အယ်ဘေမဲ့ ဘုရားသခင်ဟှာ အယ်သခင်ဟှို သေရာဟှနေ ထမြော့‑က်စေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","အယ်ဘီးန အယ်သခင်ဟှာ ရင်းရင်ဒူးဟှ သူ့နတူးဒူ ဂါလိလဲပြည်ဟှနေ ယေရုရှလင်ဗြို့ဟှို လိုက်ပါလာဂေ့ဟှူ လူလေဟှို ရစ်ပေါန်းကြာဂီး ကိုယ်ထန်ရှားပြဟှယ်။ သူးနို့ဟှ ခုခီမာ ဣသရေလလူမျိုးလေဟှို ကိုယ်တော်ကြောန်းဟှို သတ်သေခံနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","နို့လေလည်း ဘိုးဘေးလေဟှို ပေးဟှားဟှူ၊ ဂဒိတော်နဆိုင်ဟှူ၊ ကောန်းမြတ်ဟှူ ဒန်းကောန်းဟှို နန်းနို့လေဟှို ဟောပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ဘုရားသခင်ဟှာ ယေရှုဟှို ထမြော့‑က်စေဘီး ဘိုးဘေးလေရဲ့ သားမီးလေဖြစ်ဂေ့ဟှူ နို့လေတွပ် အယ်ဂဒိတော်လေဟှို ပ္လဲ့ဇောင်စေတော်မူဘီ။ ဆာလံကျမ်း ဒုတိယခန်းမာ၊” “ ‘နန်ဟှာ ငါ့သားဖြစ်ဟှယ်။ အယ်နေ့ဘဲ့ နန့်ဟှို သားရာဟှို ငါပေးဘီ’ ဆိုဘီး ရေးဟှားတိုင်းဘဲ့ ဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“သန်းခ္လိုင်းထဲမာ ပေါက်ပျစ်ဘဲန သေရာဟှနေ ထမြော့‑က်ဟှူကြောန်းဟှို ဘုရားသခင်ဟှ၊” “‘ဒါဝိဒ်ဟှိုလည်း ကောန်းဂျီးပေးဟှို့တွပ် ဂဒိပြုဟှားတိုင်းဘဲ့ နန်းနို့ဟှိုလည်း သန့်ရှင်းမြင့်မြတ်ဘီး သေချာဟှူကောန်းဂျီးဟှို ပေးမယ်’ ဆိုဘီး ပြောဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“တခြားကျမ်းပိုဒ်မာ၊ ‘ကိုယ်တော်ဟှာ သန့်ရှင်းဟှူ စေခံဟှို သန်းခ္လိုင်းထဲမာ ပေါက်ပျစ်စေဟှို့ မှုဟှ’ ဆိုဘီး ပြောဟှားဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“ဒါဝိဒ်ဟှာ သူသတ်ရှင်နေဒူးဟှ ဘုရားသခင်ရဲ့ ကြံစည်ရှိဟှူတိုင်း လိုက်ရှော့‑က်ဘီးန သေဟှားဘီးဟှာ ဘိုးဘေးလေရဲ့ သန်းခ္လိုင်းထဲမာ သင်္ဂြိုဟ်ခံရဟှယ်။ သူ့ရဲ့ခန္ဓာဟှာ သန်းခ္လိုင်းထဲမာ ပေါက်ပျစ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","အယ်ဘေမဲ့ ဘုရားသခင် ထမြော့‑က်စေလိုက်ဟှူ သခင်ရဲ့ခန္ဓာဟှာ ပေါက်ပျစ်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","အယ်ကြောန့် ညီကိုလေ၊ အယ်သခင်အားဖြင့် ပြစ်လေ ခွမ့်လွှတ်ရှင်းကြောန်းဟှို နန်းနို့လေဟှို ဟောပြောနေဇာဟှိုရော၊ ယောင်ကြည်ဟှူ လူတိုင်းဟှာ ကိုယ်တော်အားဖြင့် မောရှေရဲ့ ပညတ်တရားအားဖြင့် ဖြောန့်မတ်ဟှယ် ဆိုဘီး သိမှတ်ပြုရှင်း ခံရနိုင်ဘဲဟှူရာလေ ဂူလောင်းဟှနေ လွတ်ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","အယ်သခင်အားဖြင့် ဖြောန့်မတ်ဟှယ် ဆိုဘီး သိမှတ်ပြုရှင်း ခံရဇာဟှိုရော နန်းနို့ သိမှတ်ဂေ့။ ");
INSERT INTO tvn_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ပရောဖက်ကျမ်းလေမာ ငါ မိန့်တော်မူဟှားဇာဟှို ထီမဲ့မြင်ဟှူသူလေ နားထောန်ဂေ့။” ");
INSERT INTO tvn_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“ ‘ ထီလေးဇားမားလေ၊ ကေ့ရှုဂေ့! အံ့ဩဟှားဘီး သေပါလေစေ! အယ်နေ့ ငါလောက်နေဟှူဇာလေဟှို ယော့‑က်ယော့‑က်ဟှ ရှင်းပြဘေမဲ့လည်း နန်းနို့ဟှာ ယောင်ကြည်ဟှို့ မှုဟှ’ ဆိုဘီး ဖော်ပြဟှားဟှယ်။ အယ်မျိုး ဖော်ပြဟှားတိုင်း ဖြစ်ဟှို့တွပ် ဒိထားဂေ့ပါ၊” ဆိုဘီး ဟောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ဝါလယ်ဇရပ်ဟှနေ ပေါလုန ဗာနဗလေဟှာ ထွပ်လာဟှူ ခီမာ လူလေဟှ သူးနို့ဟှို နော့‑က်ပတ်ဒန်းနေ့မာ အယ်ကြောန်းလေဟှို နော့‑က်တခါ ဟောပြောဟှို့တွပ် တောန်းဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ဝါလယ်ဇရပ်မာ လူစုကွဲဟှားဟှူ ခီမာ ယုဒလူမျိုးလေန ဘုရားသခင်ဟှို ကိုးကွယ်ဘီး ယုဒဘာသာဝမ်ဖြစ်လာဟှူ လူလေဟှာ ပေါလုန ဗာနဗလေရဲ့ နော့‑က်ဟှိုလိုက်ဟှားဂေ့ဟှယ်။ တမန်တော်လေဟှ အယ်လူလေဟှို ဘုရားသခင်ရဲ့ ကျေးဇူးတော်န ဆစ်ဘီးဟှာ သတ်ရှင်ဟှို့တွပ် စည်းရောင်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","နော့‑က်ပတ်ဒန်းနေ့မာ သခင်ဘုရားရဲ့ စကားတော်ဟှို ကြားရဟှို့တွပ် တဗြို့လောင်းနီးပါး ရော့‑က်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ယုဒလူမျိုးလေဟှာ လူအောက်ဂီးဟှို ဗြင်ဟှူ ခီမာ နာလိုဘဲကြောန့် ပေါလုဟောပြောဟှူ စကားလေဟှို ကဲ့ရဲ့ဘီးဟှာ ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","အယ်ဘေမဲ့ ပေါလုန ဗာနဗလေဟှ “နို့လေဟှ ဘုရားသခင်ရဲ့ စကားတော်ဟှို နန်းနို့ဟှို ပထမဆောင်း ဟောရဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ဟှာ အယ်မူတရားတော်ဟှို ပယ်ဘီးဟှာ ကိုယ့်ကိုယ်ကိုယ် ထာဝရသတ်န ထိုက်တန်ဟှ ဆိုဘီး စီရင်ဂေ့ဟှူကြောန့် နို့လေဟှာ နန်းနို့နားဟှနေ ထွပ်ဟှားဘီးဟှာ လူမျိုးခြားလေနားဟှို သွားမယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ဘုရားသခင်ဟှ” “‘ကယ်တန်ရှင်းကျေးဇူးဟှို တကမ္ဘာလောင်းဟှို ရော့‑က်စေဟှို့တွပ်န နန်းနို့လေဟှို လူမျိုးခြားလေတွပ် လန်းရောန်ဖြစ်စေဟှို့ ငါခန့်ဟှားဟှယ်၊’ ဆိုဘီး နို့လေဟှို မိန့်မှာဟှားဟှယ်” ဆိုဘီး ပိုဘီး ရဲရဲရင့်ရင့်ဟှား ဟောပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","လူမျိုးခြားလေဟှာ အယ်မျိုး ကြားရဟှူ ခီမာ ဝန်းသာဘီးဟှာ သခင်ဘုရားရဲ့ စကားတော်ဟှို ချီးမွမ်းဂေ့ဟှယ်။ ထာဝရသတ်တွပ် ဝီးကော့‑က်ခံရဟှူ လူလေဟှာ ယောင်ကြည်သူလေ ဖြစ်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","သခင်ဘုရားရဲ့ တရားတော်ဟှာ တနယ်လောင်းဟှို ပ္လံ့နှံ့ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","အယ်ဘေမဲ့ ယုဒလူမျိုးလေဟှာ ဘုရားသခင်ဟှို ကိုးကွယ်ဟှူ ထတ်တန်းလွှာမီးမလေန ဗြို့ရဲ့ မျစ်နှာဖောင်းလေဟှို တိုက်တွန်းဘီးဟှာ ပေါလုန ဗာနဗလေဟှို ညှဉ်းဆဲဟှို့တွပ် စဘီးနှိုးဆော်လေဟှယ်။ သူးနို့ဟှာ အယ်လူနှေ့ယော့‑က်ဟှို သူးနို့ နယ်ဟှနေ နှန်ထုလိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","အယ်ခီမာ ပေါလုန ဗာနဗလေဟှာ သူးနို့ဟှို ဒိပေးဟှို့တွပ် ခေဖွားဟှ မ္လေမုဟှို ခါခ္လဘီးဟှာ ဣကောနိဗြို့ဟှို ထွပ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","အန္တိအုတ်ဗြို့ဟှ တဗဲ့တော်လေဟှာ ဝန်းသာဘီးဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်န ပ္လဲ့ဝနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ဣကောနိဗြို့မာလည်း ပေါလုန ဗာနဗဟှာ ယုဒလူမျိုးလေရဲ့ ဝါလယ်ဇရပ်ဟှို ဝမ်ဘီးဟှာ ဟောပြောဟှူ ခီမာ ယုဒလူမျိုးလေန လူမျိုးခြားလေဟှာ ဘောင်ဂီး ယောင်ကြည်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","အယ်ဘေမဲ့ ယောင်ကြည်ဘဲ့ဟှူ ယုဒလူမျိုးလေဟှာ လူမျိုးခြား ညီကိုလေဟှို နာလိုဘဲစိ ဖြစ်လာဟှို့တွပ် ဆွပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ပေါလုန ဗာနဗလေဟှာ အယ်ဒေသမာ ကြားကြာဟှား နေဘီးဟှာ သခင်ဘုရားရဲ့ကြောန်းဟှို ရဲရဲရင့်ရင့်ဟှား ဟောပြောဂေ့ဟှယ်။ ကိုယ်တော်ဟှာ အယ်လူလေဟောပြောဟှူ ကျေးဇူးတော်တရားဟှာ မှန်ကန်ဟှယ် ဆိုဇာဟှို သတ်သေပြဟှို့တွပ် သူးနို့လေဟှို အံ့ဩဘွယ်ရာလေန နိမိတ်လတ်ခဏာလေဟှို ပြနိုင်ဟှို့ တဂိုးဟှို ပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ဗြို့သူဗြို့သားလေဟှာ နှေ့စုကွဲဟှားဂေ့ဟှယ်။ တစုဟှ ယုဒလူမျိုးလေဖတ်ဟှို ပါဟှားဘီး နော့‑က်တစုဟှ တမန်တော်လေဖတ်ဟှို ပါဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ရာရှိလေ၊ ယုဒလူမျိုးလေန လူမျိုးခြား တချို့လေဟှာ တမန်တော်လေဟှို ညှဉ်းဆဲဘီး က္လော့‑က်ခဲနပစ်ဟှို့တွပ် ဆောင်းဖြတ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","အယ်ကြောန်းဟှို တမန်တော်လေဟှ ကြားရဟှူ ခီမာ လုကောနိပြည်ထဲဟှ လုတ္တရဗြို့၊ ဒေရဗေဗြို့န နီးနားဟှဒေသဟှို ထွပ်ပ္လေးဟှားဂေ့ဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","အယ်နေရာမာ သူးနို့ဟှာ ဒန်းကောန်းဟှို ဟောပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","လုတ္တရဗြို့မာ မွီးဂဒဲဟှ ခေသန်ဘဲကြောန့် လောင်းဝ လမ်းရှော့‑က်နိုင်ဘဲဟှူ လူတယော့‑က်ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","သူဟှာ အယ်နေရာမာ ထိုင်ဘီး ပေါလုရဲ့စကားဟှို နားထောန်နေဟှယ်။ ပေါလုဟှာ သူ့ဟှို စိစိကေ့လိုက်ဟှူကြောန့် ကျန်းမာနိုင်ဟှူ ယောင်ကြည်ရှင်းရှိဟှယ် ဆိုဇာဟှို ဗြင်ဟှူ ခီမာ ");
INSERT INTO tvn_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","“ထဘီးဟှာ မတ်တတ်ရပ်လိုက်” ဆိုဘီး သံက္လယ်ဂီးန အော်လိုက်ဟှယ်။ အယ်လူဟှာ ထခူဘီးဟှာ စဘီးလမ်းရှော့‑က်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","လူအောက်ဂီးဟှာ ပေါလုလောက်ဟှူဇာလေဟှို ဗြင်ဟှူ ခီမာ “နတ်ဘုရားလေဟှာ လူယောန်ဆောန်ဘီးဟှာ နို့လေနားဟှို လာဟှယ်!” ဆိုဘီး သူးနို့ဟှာ လုကောနိ ဘာသာစကားန စဘီးဟှာ အော်ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","သူးနို့ဟှာ ဗာနဗဟှို ဇုသ ဆိုဘီး ခေါ်ဂေ့ဟှယ်။ ပေါလုဟှာ ဦးဆောန်ဟောပြောသူ ဖြစ်ဟှူကြောန့် ဟေရမေ ဆိုဘီး ခေါ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ဇုသရဲ့ နတ်ဘုရားဗိမာန်ဟှာ ဗြို့ပ္လန်မာရှိဟှူကြောန့် အယ်နတ်ဘုရားရဲ့ ယဇ်ပုရောဟိတ်ဟှာ နွားလားလေန ပန်းဂေါင်းလေဟှို ဗြို့ခွဗော့‑က်ဝဟှို ယူလာဂေ့ဟှယ်။ သူ့နတူးဒူ လူအောက်ဂီးလည်း တမန်တော်လေဟှို ပူဇော်ရှင်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","အယ်ဘေမဲ့ တမန်တော်ဗာနဗန ပေါလုလေဟှ အယ်ကြောန်းဟှို ကြားရဂေ့ဟှူ ခီမာ သူးနို့ရဲ့ အန်းဂီလေဟှို ဆုဖ္လဲ့ဘီးဟှာ လူလေကြားထဲဟှို ပ္လေးလာဘီးဟှာ ");
INSERT INTO tvn_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“နန်းနို့ဟှာ ဖြားဖြစ်ကြောန့် အယ်မျိုးလောက်ဂေ့နူး။ နို့လေဟှ နန်းနို့မျိုးဘဲ့ သာမန်လူလေဖြစ်ဂေ့ဟှယ်! နန်းနို့ဟှာ အယ်မျိုး ကျိုးမှေ့ဘဲ့ဟှူ ဇာလေဟှို ပစ်လွှပ်ဂေ့ဘီးဟှာ သတ်ရှင်ဟှူ ဘုရားသခင်ဖတ်ဟှို ပ္လန်လာဟှို့တွပ် နန်းနို့ဟှို ဒန်းကောန်းပြောဟှို့တွပ် ရော့‑က်လာဟှယ်။ သတ်ရှင်ဟှူ ဘုရားသခင်ဟှာ ကောန်းဂန်န မ္လေဂီး၊ ပန်လယ်န ရှိမျှဂူလောင်းဟှိုလည်း ဖန်ဆင်းဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ရင်းရင်ဒူးဟှ ဆိုဟှာ ကိုယ်တော်ဟှာ လူလေ ဂူလောင်းဟှို သူးနို့ရဲ့ လမ်းစဉ်တိုင်း ရှော့‑က်လှမ်းဟှို့ ခွမ့်ပေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","အယ်ဘေမဲ့ ကောန်းဇာလေ လောက်ရှင်းအားဖြင့် ကိုယ်တော် ရှိဟှယ် ဆိုဇာဟှို သတ်သေထော့‑က်ထားလေန လူလေဟှို မြဲဒမ်း ပြဟှယ်။ ကိုယ်တော်ဟှာ ကောန်းဂန်ဟှနေ မိုးဝါစေဘီးဟှာ သီးနှံလေဟှို ဖြစ်စေဟှယ်။ နန်းနို့ဟှို စားဇာလေဟှို ပေးဘီး နန်းနို့ရဲ့စိဟှို ရွှင်လန်းစေဟှယ်” ဆိုဘီး အော်ဘီးပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","တမန်တော်လေဟှာ အယ်မျိုးပြောဘေမဲ့လည်း ပူဇော်ဆစ်သဟှို့တွပ် လောက်နေဟှူ လူလေဟှို ခတ်ခတ်ခဲခဲ တားနေရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","အန္တိအုတ်ဗြို့န ဣကောနိဗြို့ဟှနေ ရော့‑က်လာဂေ့ဟှူ ယုဒလူတချို့ဟှာ သူးနို့ဖတ်ဟှို ပါအောန် စည်းရောင်းဂေ့ဟှယ်။ အယ်ဘီးန ပေါလုဟှို က္လော့‑က်ခဲန ပစ်ဘီးဟှာ သေဟှားဘီ ဆိုဘီး ထန်ဘီးဟှာ ဗြို့ပ္လန်ဟှို ဆွဲထုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","အယ်ဘေမဲ့ သူ့နားဟှို တဗဲ့တော်လေဟှာ စုလာဂေ့ဟှူ ခီမာ ပေါလုဟှာ ဗြို့ထဲဟှို ပ္လန်ဝမ်ဟှားဟှယ်။ နော့‑က်တနေ့မာ ပေါလုန ဗာနဗဟှာ ဒေရဗေဗြို့ဟှို ထွပ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ပေါလုန ဗာနဗလေဟှာ ဒေရဗေဗြို့မာ ဒန်းကောန်းဟှို ဟောပြောဂေ့ဟှူ ခီမာ လူဘောင်ဂီးဟှ တဗဲ့တော်ဖြစ်လာဂေ့ဟှယ်။ အယ်ဘီးန လုတ္တရဗြို့၊ ဣကောနိဗြို့န ပိသိဒိပြည် အန္တိအုတ်ဗြို့ဟှို ပ္လန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","တဗဲ့တော်လေဟှို ခိုင်ခန့်စေဘီး သူးနို့လေရဲ့ ယောင်ကြည်ရှင်းစိဟှို ခိုင်မြဲဟှို့တွပ် တိုက်တွန်းဂေ့ဟှယ်။ သူးနို့ဟှာ “နို့လေဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟှို ဝမ်ဟှို့တွပ် ဒေါက်ခဆင်းရဲ ဘောင်ဂီး ခံရလေ့မယ်” ဆိုဘီး သွန်သန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ပေါလုန ဗာနဗလေဟှာ သင်းတော်လေမာ လူဂီးလေဟှို ခန့်ဟှားဂေ့ဟှယ်။ စာရှောန်ဆုတောန်းဘီးန သူးနို့ယောင်ကြည်ဂေ့ဟှူ သခင်ဘုရားနားဟှို သူးနို့လေဟှို အပ်ပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ပေါလုန ဗာနဗဟှာ ပိသိဒိပြည်ဟှို ဖြတ်ဘီးန ပံဖုလိပြည်ဟှို ရော့‑က်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","သူးနို့ဟှာ ပေရဂေဗြို့မာ တရားဟှို ဟောဂေ့ဟှယ်။ အယ်ဘီးန အတ္တလိဗြို့ဟှို သွားဘီးဟှာ၊ ");
INSERT INTO tvn_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","အန္တိအုတ်ဗြို့ဟှို သန်းဖောန သွားဂေ့ဟှယ်။ အယ်ဗြို့ဟှာ ခုသူးနို့ရဲ့ မှုတော်လောက်ငန်း ပီးဟှားဟှူကြောန့် ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ထဲဟှို အပ်ဘီးဟှာ လွှတ်လိုက်ဟှူဗြို့ ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","အန္တိအုတ်ဗြို့ဟှို ရော့‑က်ဟှူ ခီမာ သူးနို့ဟှာ သင်းတော်မာ စုခိုင်းဘီးဟှာ သူးနို့ဟှို ဘုရားသခင်ဟှ သတ်သေထူဟှားဇာလေန လူမျိုးခြားလေ ယောင်ကြည်လာဟှို့တွပ် ကိုယ်တော်ဟှာ ယောင်ကြည်ရှင်း ခွဗော့‑က်ဟှို ဖွမ့်ပေးဟှူကြောန်းလေဟှို ပ္လန်ပြောပြဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","အယ်ဘီးန သူးနို့ဟှာ တဗဲ့တော်လေနတူးဒူ ကြာဂီးနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","လူတချို့ဟှာ ယုဒပြည်ဟှနေ အန္တိအုတ်ဗြို့ဟှို သွားဘီးဟှာ ညီကို မောန်နှမလေဟှို “နန်းနို့ဟှာ မောရှေရဲ့ ပညတ်တရားတိုင်း ရေဖျားလှီးဇာဟှို ခံဟှဆိုဟှာ ကယ်တန်ရှင်းရနိုင်ဟှ” ဆိုဘီး သွန်သန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ပေါလုန ဗာနဗလေဟှာ အယ်လူလေန ပြင်းပြင်းထန်းထန်ဟှား ဂြင်းခူဂေ့ဟှယ်။ အယ်ကြောန့် ပေါလု၊ ဗာနဗန ယောင်ကြည်သူတချို့ဟှို အယ်ပြဿနာ ဆွေးနွီးဟှို့တွပ် ယေရုရှလင်ဗြို့ဟှ တမန်တော်လေန သင်းလူဂီးလေနားဟှို စေလွှတ်ဟှို့တွပ် ဆောင်းဖြတ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","သူးနို့ဟှာ သင်းတော်ရဲ့ ပို့ဆောန်ပေးရှင်းအားဖြင့် ဖိနိတ်ပြည်န ရှမာရိပြည်လေဟှို ဖြတ်သွားနေဟှူ ခီမာ လူမျိုးခြားလေဟှာ ဘုရားသခင်ဖတ်ဟှို ပ္လောန်းလဲလာဂေ့ကြောန်းဟှို ပြောပြဂေ့ဟှူကြောန့် ညီကိုလေဟှာ ရရာတိုင်း ဝန်းသာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","သူးနို့လေဟှာ ယေရုရှလင်ဗြို့ဟှို ရော့‑က်ဟှားဂေ့ဟှူ ခီမာ သင်းတော်၊ တမန်တော်လေန သင်းလူဂီးလေဟှ သူးနို့ဟှို ကြိုဆိုဂေ့ဟှယ်။ သူးနို့ဟှို ဘုရားသခင်ဟှ ဖယ်မျှလော့‑က် သောင်းပြုဟှယ် ဆိုဇာဟှို ဂူလောင်းဟှို ပ္လန်ပြောပြဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","အယ်ဘေမဲ့ ဖာရိရှဲဖွဲ့ဝမ်လေန ယောင်ကြည်သူ တချို့လေဟှာ ထဘီးဟှာ “လူမျိုးခြားလေဟှာ ရေဖျားလှီးဇာခံရဘီး မောရှေရဲ့ ပညတ်တရားဟှို စောန့်ထီးရမယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","တမန်တော်လေန သင်းလူဂီးလေဟှာ အယ်ကိစဟှို သောင်းသပ်ဟှို့တွပ် စုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ခီကြာဂီး ဆွေးနွီးဂေ့ဘီးန ပေတရုဟှာ ထဘီးဟှာ “ညီကိုလေ၊ လူမျိုးခြားလေဟှာ ဒန်းကောန်းကြားဘီး ယောင်ကြည်နိုင်ဟှို့တွပ် ရင်းရင်ဂဒဲဟှ ဘုရားသခင်ဟှာ ဒန်းကောန်းဟှို ဟောပြောဟှို့တွပ် ငါ့ဟှို ဦးဆောင်း နန်းနို့ ထဲဟှနေ ဝီးကော့‑က်ဟှားဟှယ် ဆိုဇာဟှို နန်းနို့ သိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","လူလေရဲ့ စိနှလောင်းဟှိုသိဟှူ ဘုရားသခင်ဟှာ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို နို့လေဟှို ပေးမျိုးဘဲ့ လူမျိုးခြားလေဟှိုလည်း ပေးရှင်းအားဖြင့် သူးနို့လေဟှို လတ်ခံကြောန်း သတ်သေဟှို ပြလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ကိုယ်တော်ဟှာ သူးနို့လေန နို့လေဟှို ခွဲခြားဟှ။ သူးနို့ဟှာ ကိုယ်တော့်ဟှို ယောင်ကြည်ဟှူကြောန့် သူးနို့ရဲ့ စိနှလောင်းဟှာ သန့်ရှင်းဟှားဘီး သူးနို့ရဲ့ ပြစ်လေလည်း ဖြေလွှတ်ပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","အယ်ကြောန့် နန်းနို့ဟှာ ဖြားဖြစ်ကြောန့် ဘုရားသခင်ဟှို စောင်ဇမ်းဂေ့နူး။ နို့လေရဲ့ ဘိုးဘေးလေရော၊ နို့လေကိုယ်တိုင်ဟှာ ထမ်းနိုင်ဘဲဟှူ ဝန်ထောက်လေဟှို ဖြားဖြစ်ကြာန့် တဗဲ့တော်လေဟှို ထမ်းခိုင်းဂေ့နူး။ ");
INSERT INTO tvn_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","မှုဟှ! နို့လေဟှလည်း အယ်လူလေမျိုးဘဲ့ သခင်ယေရှုရဲ့ ကျေးဇူးတော်အားဖြင့် ကယ်တန်ခံရဟှယ် ဆိုဇာဟှို ယောင်ကြည်ဂေ့ဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ဗာနဗန ပေါလုလေဟှာ လူမျိုးခြားလေထဲမာ ဘုရားသခင်လောက်ဟှူ အံ့ဩဘွယ်ရာလေန နိမိတ်လတ်ခဏာကြောန်းဟှို ပြောနေဟှူ ခီမာ စုနေဟှူ လူလေဟှ တိတိဆိဆိဟှား နားထောန်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","သူးနို့လေ ပြောဘီးန ယာကုပ်ဟှ “ညီကိုလေ၊ ငါ့စကားဟှို နားထောန်ဂေ့! ");
INSERT INTO tvn_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ဘုရားသခင်ဟှာ သူ့နာမတော်တွပ် လူမျိုးခြားလေထဲဟှ လူတချို့ဟှို သူ့ရဲ့ လူစုဖြစ်ဟှို့တွပ် ဝီးထုဟှူ ခီမာ သူးနို့ဟှို ဂရုစိုက်ကြောန်းဟှို ရှိမုန်ဟှ ရှင်းပြဟှားပီးဘီ။ ");
INSERT INTO tvn_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ပရောဖက်လေရဲ့ စကားလေဟှာ အယ်ကြောန်းရာန ကိုက်ညီဟှယ်။ ကျမ်းစာထဲမာ” ");
INSERT INTO tvn_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ ‘အယ်မူဇာ ပီးဟှားဘီးန ငါပ္လန်လာမယ်၊ အယ်ဘီးဟှာ ပြိုက္လနေဟှူ ဒါဝိဒ်ရဲ့တဲဟှို ငါပ္လန်ဆော့‑က်မယ်။ ငါဟှာ ပျစ်စီးနေဟှူ အယ်တဲတော်ဟှို ပ္လန်ဆော့‑က်ဘီး ဒါဝိဒ်ရဲ့တဲဟှို နော့‑က်တခါ ပ္လန်ဆော့‑က်မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ကျန်ရစ်ဟှူ လူလေန ငါ့နာမအားဖြင့် ခေါ်ရှင်းခံရဟှူ လူမျိုးခြားလေ ဂူလောင်းဟှာ ဘုရားသခင်ဟှို ရှာဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ရင်းရင်ဂဒဲဟှ အယ်မူဇာဟှို သိစေတော်မူဟှူ ထာဝရဘုရား မိန့်တော်မူဟှားဟှယ်’ ” ဆိုဘီး ရေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ယာကုပ်ဟှ ဆစ်ဘီးဟှာ “အယ်ကြောန့် ဘုရားသခင်နားဟှို ပ္လောန်းလဲလာဂေ့ဟှူ လူမျိုးခြားလေဟှို ဒေါက်ခရော့‑က်အောန် နို့လေ စီရင်သင့်ဟှ ဆိုဘီး ငါထန်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","အယ်ကြောန့် ရောက်ထုလေဟှို ပူဇော်ဟှားဘီး သန့်ရှင်းဘဲဟှူ စားဇာလေဟှို စားရှင်း၊ တရားဘဲဟှူ မေထုန်ပြုရှင်း၊ လည်ဗန်းလှီးဘဲန သတ်ဟှားဟှူ လိဆန်န သွီးလေဟှို စားရှင်းဟှနေ ရှောန်ဂေ့ဟှို့တွပ် စာရေးသင့်ဟှယ် ဆိုဇာ ငါယူဆဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ရင်းရင်ဒူးဟှ မောရှေရဲ့ ပညတ်တရားဟှို ဝါလယ်ဇရပ်မာ ဒန်းနေ့တိုင်းမာ ဖတ်ဟှယ်။ အယ်ဘီးဟှာ သူ့ရဲ့ တရားဟှို ဗြို့တိုင်းမာ ဟောပြောဂေ့ဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","အယ်ကြောန့် တမန်တော်လေ၊ သင်းလူဂီးလေန သင်းတော်တခုလောင်းဟှာ သူးနို့လေထဲဟှ လူတချို့ဟှို ဝီးကော့‑က်ဘီးဟှာ ပေါလုန ဗာနဗလေနတူးဒူ အန္တိအုတ်ဗြို့ဟှို လွှတ်ဟှို့တွပ် ဆောင်းဖြတ်ဂေ့ဟှယ်။ သူးနို့လေဟှာ ညီကိုလေထဲမာ ရရာတိုင်း လေးစားခံရဟှူ ဗာရှဗ ဆိုဘီး ခေါ်ဟှူ ယုဒန သိလလေဟှို ဝီးကော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","သူးနို့ဟှနေ တဆင့် ပေးလိုက်ဟှူ စာထဲမာ၊ “နန်းနို့ ညီကိုလေ ဖြစ်ဂေ့ဟှူ တမန်တော်လေန သင်းလူဂီးလေဟှ အန္တိအုတ်ဗြို့၊ ရှုရိပြည်န ကိလိကိပြည်မာနေဟှူ လူမျိုးခြား ညီကိုလေဟှို နှောက်ဆစ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","နို့လေထဲဟှ လူတချို့ဟှာ နို့လေရဲ့ ခွမ့်ပြုချစ်ရဘဲန နန်းနို့နားဟှို သွားဘီးဟှာ စိနှောက်ယှစ်ဖြစ်စေဟှူ စကားလေဟှို ပြောဘီး နန်းနို့ဟှို ဒေါက်ခပေးကြောန်းဟှို နို့လေသိရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","အယ်ဘေမဲ့ ကျွန်တော့်လေဟှာ စည်းဝေးလောက်ဘီး လူတချို့ဟှို ဝီးကော့‑က်ဘီးဟှာ နန်းနို့နားဟှို လွှတ်ဟှို့တွပ် ဂူလောင်း ဘောတူဂေ့ဟှယ်။ အယ်လူလေဟှာ ကျွန်တော့်လေ ရှစ်ဟှူဗာနဗန ပေါလုလေနတူးဒူ လိုက်ဟှားဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ပေါလုန ဗာနဗလေဟှာ နို့လေရဲ့ သခင်ယေရှုခရစ်တော်ရဲ့ နာမတော်တွပ် မှုတော်ဟှို သတ်စွန့်ဘီး လောက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","အယ်ကြောန့် ကျွန်တော့်လေဟှာ သူးနို့နတူးဒူ ယုဒန သိလလေဟှို နန်းနို့နားဟှို လွှတ်လိုက်ဟှယ်။ ကျွန်တော့်လေ ရေးလိုက်ဟှူစာမာ ပြောဟှားဟှူ ကြောန်းရာလေဟှို သူးနို့ ကိုယ်တိုင်လည်း ပြောပြဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","သန့်ရှင်းဟှူဝိညာဉ်တော်န ကျွန်တော့်လေဟှာ လိုက်နာဟှို့ လိုအပ်ချစ်လေမှတပါး တခြားဝန်လေဟှို ထမ်းဘဲဟှို့တွပ် ဘောတူဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ရောက်ထုဟှို ပူဇော်ဟှားဟှူစာဟှို စားန။ သွီးဟှိုလည်း စားန။ လည်ဗန်းလှီးဘဲန သတ်ဟှားဟှူ လိဆန်ဟှိုလည်း စားန။ နန်းနို့ ကိုယ်တိုင်လည်း တရားဘဲဟှူ မေထုန်ဟှို ရှောန်ရမယ်။ အယ်မူဇာလေဟှို ရှောန်မယ် ဆိုဟှာ နန်းနို့တွပ် လောင်လော့‑က်ဟှားဘီ။ ကျန်းမာရွှင်လန်းဂေ့ပါစေ” ဆိုဘီး ရေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","စေတမန်လေဟှို လွှတ်လိုက်ဘီး သူးနို့ဟှာ အန္တိအုတ်ဗြို့ဟှို သွားဘီး ယောင်ကြည်သူလေဟှို စုခိုင်းဘီးဟှာ အယ်ပေးစာဟှို ပေးလိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","သူးနို့ဟှာ အယ်စာဟှို ဖတ်ပြဂေ့ဟှူ ခီမာ တိုက်တွန်းဟှားဟှူ စကားလေကြောန့် ရရာတိုင်း ဝန်းသာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ယုဒန သိလလေ ကိုယ်တိုင်ဟှ ပရောဖက်လေ ဖြစ်ဂေ့ဟှူကြောန့် ညီကိုလေဟှို ခီကြာဂီး တိုက်တွန်းအားပေးဘီး ခိုင်ခန့်စေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","သူးနို့ဟှာ အယ်နေရာမာ ရစ်ကြာဂီး နေဘီးန ညီကိုလေဟှို ငြီးငြီးချမ်းချမ်းဟှား ပ္လန်လွှတ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ပေါလုန ဗာနဗလေဟှာ အန္တိအုတ်ဗြို့မာနေဘီး သခင်ဘုရားရဲ့ ဒန်းကောန်းဟှို တခြားလူလေနတူးဒူ ဟောပြောသွန်သန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ရစ်နဲနဲကြာဘီးန ပေါလုဟှ ဗာနဗဟှို “သခင်ဘုရားရဲ့ စကားတော်ဟှို နို့လေဟောဟှားဟှူ၊ ဗြို့လေမာရှိဟှူ ညီကိုလေနားဟှို ပ္လန်ဟှားဘီးဟှာ သူးနို့လေရဲ့ ခြေနေလေဟှို လေ့လာဂေ့ဇို့” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ဗာနဗဟှာ မာကုနာမယ် ဆိုဘီး ခေါ်ဟှူ ယောဟန်ဟှို ခေါ်ဆောန်ရှင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","အယ်ဘေမဲ့ ပေါလုဟှ ပံဖုလိပြည်မာ သူးနို့နားဟှနေ ထွပ်ဟှားဘီး သာသနာခရီးဟှို ဆောင်းထိလိုက်ဘဲဟှူ သူဟှို ခေါ်ဆောန်ဟှို့ သင့်ဟှ ဆိုဘီး ယူဆဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","သူးနို့ဟှာ ပြင်းပြင်းထန်းထန်ဟှား ဂြင်းခူဂေ့ဘီး လမ်းခွဲဂေ့ဟှယ်။ ဗာနဗဟှာ မာကုဟှို ခေါ်ဘီးဟှာ ကုပရုကျွန်းဟှို သန်းဖောန သွားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ပေါလုဟှ သိလဟှို ဝီးကော့‑က်ဘီးဟှာ ထွပ်ဟှားဟှယ်။ ညီကိုလေဟှာ ပေါလုဟှို သခင်ဘုရားရဲ့ ကျေးဇူးတော်န အပ်လိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ပေါလုဟှာ အယ်နေရာဟှနေ ရှုရိပြည်န ကိလိကိပြည်ဟှို သွားဘီးဟှာ သင်းတော်လေဟှို ခိုင်ခန့်စေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ပေါလုဟှာ ဒေရဗေဗြို့န လုတ္တရဗြို့ဟှို ရော့‑က်လာဟှယ်။ လုတ္တရဗြို့မာ တိမောသေ နာမယ်ရှိဟှူ တဗဲ့တော်တယော့‑က်ရှိဟှယ်။ သူ့မိဟှာ ယောင်ကြည်ဟှူ ယုဒလူမျိုးဖြစ်ဟှယ် သူ့ဖဟှာ ဟေလသလူမျိုးဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","လုတ္တရဗြို့န ဣကောနိဗြို့ဟှ ညီကို မောန်နှမလေထဲမာ အသရေရှိဘီး သတ်သေခံနိုင်ဟှူ လူလည်းဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ပေါလုဟှာ တိမောသေဟှို သူးနို့နတူးဒူ လိုက်ဟှို့ရအောန် ဆိုဘီး အယ်နေရာမာရှိဟှူ ယုဒလူမျိုးလေကြောန့် သူ့ဟှို ရေဖျားလှီးပေးလေဟှယ်။ အယ်မျိုး လောက်ရဟှူကြောန်းဟှ တိမောသေရဲ့ ဖဟှ ဟေလသလူမျိုးဖြစ်ဟှယ် ဆိုဇာဟှို သူးနို့လေ ဂူလောင်း သိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","သူးနို့ဟှာ ဗြို့လေဟှို ဖြတ်ဟှားဘီး ယေရုရှလင်ဗြို့မာနေဟှူ တမန်တော်လေန သင်းလူဂီးလေ ဆောင်းဖြတ်ဟှားဟှူ စည်းမျဉ်းလေဟှို စောန့်ထီးဟှို့တွပ် ယောင်ကြည်သူလေဟှို ပေးအပ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","အယ်ကြောန့် သင်းတော်လေဟှာ ယောင်ကြည်မှု ပိုခိုင်မြဲလာဘီး နေ့တိုင်း လူဦးရေ တိုးပွားလာလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","သူးနို့ဟှာ ဖြူဂိပြည်န ဂလာတိပြည်ဟှို ဖြတ်ဟှားဂေ့ဟှယ်။ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှာ သူးနို့ဟှို အာရှိပြည်မာ တရားဟောဟှို့တွပ် ခွမ့်ပေးဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","သူးနို့ဟှာ မုသိပြည်နယ်စပ်ဟှို ရော့‑က်ဟှားဂေ့ဟှူ ခီမာ ဗိသုနိပြည်ဟှို သွားဟှို့တွပ် ကြိုးစားဂေ့ဟှယ်။ အယ်ဘေမဲ့ သခင်ယေရှုရဲ့ ဝိညာဉ်တော်ဟှ သူးနို့ဟှို ခွမ့်ပေးဟှမ်း။ ");
INSERT INTO tvn_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","အယ်ကြောန့် သူးနို့ဟှာ မုသိပြည်ဟှို ဖြတ်ဟှားဘီး တရောဗြို့ဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","အယ်ညဉ့်မာ ပေါလုဟှာ “မာကေဒေါနိပြည်ဟှို လာဘီးဟှာ ကျွန်တော့်လေဟှို ကူညီမဇပါ” ဆိုဘီး မာကေဒေါနိပြည်သား တယော့‑က်ဟှာ ရပ်ဘီးဟှာ တောန်းဗန်နေဇာဟှို ရူပါရောင်ထဲမာ ဗြင်ရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ပေါလုဟှ အယ်ရူပါရောင်ဟှို ဗြင်ဘီးန မာကေဒေါနိပြည်သားလေဟှို ဒန်းကောန်းဟောဟှို့တွပ် ဘုရားသခင်ဟှာ နို့လေဟှို ခေါ်တော်မူဟှယ် ဆိုဘီး ရှစ်ရှင်းဘဲ မာကေဒေါနိပြည်ဟှို သွားဟှို့တွပ် ဆောင်းဖြတ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ကျွန်တော့်လေဟှာ တရောဗြို့ဟှနေ သာမောသရက်ကျွန်းဟှို သန်းဖောန သွားဂေ့ဘီးန နော့‑က်တနေ့မာ နာပေါလိဗြို့ဟှို ရော့‑က်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","အယ်ဗြို့ဟှနေဘီး ဖိလိပ္ပိဗြို့ဟှို သွားဂေ့ဟှယ်။ ဖိလိပ္ပိဗြို့ဟှာ မာကေဒေါနိပြည်ရဲ့ ပထမနယ်ရဲ့ ဗြို့တဗြို့၊ ရောမလတ်အော့‑က်ခံဟှူ ဗြို့လည်းဖြစ်ဟှယ်။ အယ်ဗြို့မာ ကျွန်တော့်လေဟှာ ကြာဂီးနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ဒန်းနေ့မာ နို့လေဟှာ ဗြို့ပ္လန်ဟှို ထွပ်ဂေ့ဟှယ်။ အယ်ဘီးန ဆုတောန်းဟှို့တွပ် နေရာရှိနိုင်ဟှယ် ဆိုဘီး စိထန်န မြစ်ကမ်းနားဟှို သွားဘီး အယ်နေရာမာ စုနေဟှူ မီးမလေဟှို ဟောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","အယ်လူလေထဲမာ သွာတိရဗြို့ဟှ ခရမ်းရောန် ဝတ်လေဟှို ရောန်းဝယ်မား လုဒိနာမယ်ရှိဟှူ မီးမတယော့‑က်လည်း နားထောန်နေဟှယ်။ သူဟှာ ဘုရားသခင်ဟှို ကိုးကွယ်ဟှူသူ ဖြစ်ဟှယ်။ သခင်ဘုရားဟှာ ပေါလုဟောနေဟှူ တရားစကားဟှို အာရောင်စိုက်ဟှို့တွပ် အယ်မီးမရဲ့ စိနှလောင်းဟှို ဖွမ့်ပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","သူ့နတူးဒူ အီသူအီသားလေဟှာ ဗတ္တိဇံခံဘီးန လုဒိဟှ “ကျွန်မဟှာ သခင်ဘုရားဟှို တကယ်ယောင်ကြည်သူ ဖြစ်ဟှယ် ဆိုဘီး ဆောင်းဖြတ်ဟှယ် ဆိုဟှာ ကျွန်မအီဟှို လာဘီးဟှာ နေဂေ့ပါ” ဆိုဘီး ကျွန်တော့်လေဟှို တောန်းဗန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","တနေ့မာ ကျွန်တော့်လေဟှာ ဆုတောန်းဟှူ နေရာဟှို သွားဂေ့ဟှူ ခီမာ ဗေဒန်ဟောနိုင်ဟှူ၊ နတ်ဝမ်ပူးနေဟှူ၊ စေခံမီးမဂန်း တယော့‑က်ဟှို တွိဂေ့ဟှယ်။ သူဟှာ အယ်မျိုး ဗေဒန်ဟောရှင်းအားဖြင့် သူ့ဇရှင်ဟှို ကပ်လေဘောင်ဂီး ရစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","အယ်စေခံဟှာ ပေါလုန ကျွန်တော့်လေ နော့‑က်ဟှိုလိုက်ဘီးဟှာ “အယ်လူလေဟှာ ဗြစ်ဆောင်းဟှူ ဘုရားသခင်ရဲ့ စေခံလေဖြစ်ဟှယ်! သူးနို့ဟှာ နန်းနို့ဟှို ဖယ်မျိုး ကယ်တန်ခံရနိုင်ဟှယ် ဆိုဇာဟှို ဟောဟှူလူလေဖြစ်ဟှယ်” ဆိုဘီး အော်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","အယ်မီးမဂန်းဟှားဟှာ ရစ်လေကြာဂီး အယ်မျိုးလောက်နေကြောန့် ပေါလုဟှာ ရရာတိုင်း စိနှောက်ရှစ်ဖြစ်လာဘီး၊ နော့‑က်ဟှိုလှည့်ဘီးဟှာ “နန်ဟှာ အယ်မီးမဂန်းဟှားထဲဟှနေ ထွပ်ဟှားလိုက်။ ယေရှုခရစ်တော်ရဲ့ နာမတော်နှိုက် နန့်ဟှို ငါ မိန့်ပေးဟှယ်!” ဆိုဘီး အယ်နတ်ဟှို ပြောလေဟှယ်။ ရှစ်ရှင်းဘဲ အယ်နတ်ဟှာ ထွပ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","မီးမဂန်းဟှားရဲ့ ဇရှင်ဟှာ သူးနို့မာ ကပ်ဝမ်ဟှို့တွပ် မျှော်လင့်ချစ်မှေ့ဘီ ဆိုဇာဟှို သိဟှူ ခီမာ ပေါလုန သိလလေဟှို ဖမ်းဘီးဟှာ လူလေစုဝီးဟှူ နေရာမာရှိနေဟှူ အာဏာပိုင်လေနားဟှို ဆွဲခေါ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ရောမရာရှိလေရဲ့ ရှေ့ဟှို ရော့‑က်ဟှူ ခီမာ “အယ်လူလေဟှာ ယုဒလူမျိုးလေ ဖြစ်ဂေ့ဟှယ်။ ကျွန်တော့်လေ ဗြို့ဟှို ဆူပူအောန် လောက်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ရောမနိုင်ငံသားလေဖြစ်ဟှူ၊ ကျွန်တော့်လေ လတ်ခံအပ်ဘဲဟှူ၊ ကျင့်သောင်းအပ်ဘဲဟှူ ထောင်းဒန်းစဉ်လာလေဟှို သူးနို့လေဟှာ သွန်သန်နေဂေ့ဟှယ်” ဆိုဘီး လျှော့‑က်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","လူအောက်ဂီးဟှလည်း ပေါလုန သိလလေဟှို ဆန့်ကျင်ဂေ့ဟှယ်။ ရာရှိလေဟှာ အယ်လူနှေ့ယော့‑က်ရဲ့ ဝတ်လေဟှို ဆုဖ္လဲ့ဘီး သူးနို့ဟှို ကီဒန်ပေးဟှို့တွပ် မိန့်ပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","သူးနို့ဟှို ပြင်းပြင်းထန်းထန်ဟှား ရိုက်ဘီးန ထောန်ထဲမာ ထားဟှားဂေ့ဟှယ်။ အယ်ဘီးန သူးနို့ဟှို လောင်းလောင်ခြောင်းခြောင်ဟှား ထားဟှို့တွပ် ထောန်မှူးဟှို မိန့်ပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","အယ်မျိုး မှာလိုက်ဟှူတိုင်း ထောန်မှူးဟှာ သူးနို့ဟှို ထောန်ရဲ့ ထဲခန်းမာ ထားဟှားဘီးဟှာ သူးနို့ ခေလေဟှိုလည်း ထိတောင်းခတ်ဟှားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ညဉ့်သန်းဂေါန်ခီမာ ပေါလုန သိလလေဟှာ ဘုရားသခင်ဟှို ဆုတောန်းဘီး ချီးမွမ်းချင်း ဆိုနေဂေ့ဟှယ်။ သူးနို့လေ ချင်းဆိုနေဇာဟှို တခြားထောန်သားလေလည်း နားထောန်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","အယ်ခီမာ ရော့‑က်တရစ် ပြင်းထန်ဟှူ မ္လေဂီးလှောက်လာဘီး ထောန်ရဲ့ အုပြစ်လေဟှာ လှောက်ခါလာဟှယ်။ ခွဗော့‑က်လေ ဂူလောင်းဟှာ ရှစ်ရှင်းဘဲ ပွမ့်ထွပ်ဟှားဘီး ထောန်သားလေ ဂူလောင်းရဲ့ ခယ်ဟှားဟှူ သံကြိုးလေလည်း ပ္လုထွပ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ထောန်မှူးဟှာ အိယာဟှ နိုးဟှားဘီး ပွမ့်နေဟှူ ထောန်ခွဗော့‑က်လေဟှို ဗြင်ဟှူ ခီမာ ထောန်သားလေဟှာ ထွပ်ပ္လေးဟှားဘီ ဆိုဘီး စိထန်နေဟှူကြောန့် ထားဟှို ဆွဲထုဘီးန သူ့ကိုယ်သူ သတ်ဟှို့ လောက်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","အယ်ဘေမဲ့ ပေါလုဟှ “နန့်ကိုယ်နန် အန္တရာယ်ဖြစ်စေန! နို့လေဂူလောင်း အယ်နေရာမာ ရှိနေဂေ့ဟှယ်” ဆိုဘီး သံက္လယ်ဂီးန အော်ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ထောန်မှူးဟှာ မီးတိုင်ဟှို တောန်းဘီးန ပ္လေးဝမ်ဟှားဘီး ပေါလုန သိလလေရဲ့ ခေရင်းမာ တောင်လှောက်ဘီး ပျပ်ဝပ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","အယ်ဘီးန သူးနို့ဟှို ပ္လန်ဟှို ခေါ်ဆောန်လာဘီးဟှာ “ဆရာလေ၊ ကျွန်တော်ဟှာ ကယ်တန်ခံရဟှို့တွပ် ဖြားမျိုးလောက်ဟှို့နူး” ဆိုဘီး မေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","သူးနို့ဟှလည်း “သခင်ယေရှုဟှို ယောင်ကြည်ပါ။ ယောင်ကြည်မယ် ဆိုဟှာ နန့်န နန့်မိသားစုဟှာ ကယ်တန်ခံရလေ့မယ်” ဆိုဘီး ပ္လန်ဖြေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","အယ်ဘီးန သူ့န သူ့အီမာရှိနေဟှူ လူလေ ဂူလောင်းဟှို သခင်ဘုရားရဲ့ စကားတော်ဟှို ဟောပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","အယ်ညဉ့်မာဘဲ့ ထောန်မှူးဟှာ ပေါလုန သိလလေဟှို ခေါ်ဘီးဟှာ ဒန်ရာလေဟှို ဆေးပေးဟှယ်။ အယ်ဘီးန သူ့န သူ့အီသူအီသား ဂူလောင်းဟှာ ရှစ်ရှင်းဘဲ ဗတ္တိဇံခံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","သူဟှာ ပေါလုန သိလလေဟှို သူ့အီဟှို ခေါ်ဘီးဟှာ စားဇာလေဟှို ကျွေးဟှယ်။ သူ့န သူ့မိသားစုဟှာ ဘုရားသခင်ဟှို ယောင်ကြည်ရဂေ့ကြောန့် ရရာတိုင်း ဝန်းသာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","နော့‑က်တနေ့ မိုးလန်းဟှားဟှူ ခီမာ ရောမအာဏာပိုင်လေဟှာ သူးနို့လေဟှို ထောန်ဟှနေ လွှတ်လိုက်ဟှို့တွပ် ရဲရာရှိလေဟှို မိန့်ပေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","အယ်ကြောန့် ထောန်မှူးဟှာ ပေါလုဟှို “ရာရှိလေဟှာ နန်းနို့ဟှို ထောန်ဟှနေ လွှတ်ဟှို့တွပ် ပြောဟှားဟှယ်။ အယ်ကြောန့် ငြီးငြီးချမ်းချမ်းဟှား သွားဂေ့ပါ” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ပေါလုဟှ “ရောမနိုင်ငံသားဖြစ်ဟှူ နို့လေဟှို စစ်ကြောစီရင်ဘဲန လူလေရှေ့မာ ရိုက်ဂေ့ဟှယ်! အယ်ဘီးန နို့လေဟှို ထောန်ခ္လဟှားဂေ့ဟှယ်။ ခုလည်းဘဲ့ နို့လေဟှို တိတိဟှား လွှတ်လိုက်ဂေ့ဟှို့လော။ အယ်မျိုးလောက်သင့်ဟှ! သူးနို့ ကိုယ်တိုင်လာဘီး နို့လေဟှို ထောန်ဟှနေ လာထုဂေ့” ဆိုဘီး ရဲရာရှိလေဟှို ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ရဲရာရှိလေဟှာ အယ်ကြောန်းဟှို ရာရှိလေဟှို ပ္လန်ပြောဂေ့ဟှယ်။ ပေါလုန သိလလေဟှာ ရောမနိုင်ငံသား ဖြစ်ကြောန်းဟှို ရာရှိလေဟှာ ကြားရဟှူ ခီမာ ကြော့‑က်လန့်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","အယ်ကြောန့် သူးနို့ဟှာ လာဘီးဟှာ ပေါလုန သိလလေဟှို တိုက်တွန်းဂေ့ဟှယ်။ အယ်ဘီးန သူးနို့လေဟှို ထောန်ဟှနေ ထုဆောန်ဘီးဟှာ အယ်ဗြို့ဟှနေ ထွပ်ဟှားဟှို့တွပ် တောန်းဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ပေါလုန သိလလေဟှာ ထောန်ထဲဟှ ထွပ်ဘီးဟှာ လုဒိအီဟှို သွားဂေ့ဟှယ်။ အယ်ဘီးန ညီကို မောန်နှမလေဟှို တွိဘီးဟှာ အားပေးစကားလေဟှို ပြောဘီးန အယ်ဗြို့ဟှနေ ထွပ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ပေါလုန သိလဟှာ ခရီးသွားဂေ့ဟှူ ခီမာ အံဖိပေါလိဗြို့န အာပေါလောနိဗြို့ဟှို ဖြတ်ဟှားဘီး သက်သာလောနိတ်ဗြို့ဟှို ရော့‑က်ဟှားဂေ့ဟှယ်။ အယ်ဗြို့မာ ယုဒဝါလယ်ဇရပ်ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ပေါလုဟှာ သူးနို့ထောင်းဇံရှိဟှူတိုင်း ဝါလယ်ဇရပ်ဟှို သွားဘီးဟှာ ဒန်းနေ့ သောင်းရစ်လောင်းလောင်း ကျမ်းစာဟှို ကိုးကားဘီးဟှာ လူလေန သေးသေချားချာဟှား ဆွေးနွီးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","မေရှိယဟှာ ဒေါက်ခဝေဒနာခံရဟှူ ကြောန်းဟှို ကျမ်းချစ် ထော့‑က်ထားလေနတူးဒူ ရှင်းရှင်းလန်းလန်းဟှား ပြောပြဟှယ်။ ပေါလုဟှ “နန်းနို့ဟှို ငါပြောပြနေဟှူ ယေရှုဟှာ မေရှိယဖြစ်ဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ယုဒလူတချို့ဟှာ သွီးဆောန်ခံရဘီး ပေါလုန သိလလေရဲ့ ဖွဲ့ထဲဟှို ဝမ်ဟှားဂေ့ဟှယ်။ ဘုရားသခင်ဟှို ကိုးကွယ်ဟှူ ဟေလသလူမျိုး ဘောင်ဂီးန ထန်ပေါ်ကျော်ကြားဟှူ မီးမလေလည်း သူးနို့ဖွဲ့ထဲဟှို ဝမ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","အယ်ဘေမဲ့ ယုဒလူ တချို့ဟှာ နာလိုဘဲဟှူ စိရှိဟှူကြောန့် လမ်းလေမာ ကောန်းဘဲဟှူ လူလေဟှို ခေါ်ဘီးဟှာ လူလေဘောင်ဂီးဟှို စုခိုင်းဘီးဟှာ တဗြို့လောင်း ဆူပူအောန် လောက်ဂေ့ဟှယ်။ သူးနို့ဟှာ ယာသုန်ရဲ့အီဟှို ဝမ်ဘီးဟှာ ပေါလုန သိလလေဟှို လူလေရှေ့ဟှို ဆွဲထုဟှို့တွပ် ရှာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ရှာတွိဘဲဟှူ ခီမာ သူးနို့ဟှာ ယာသုန်န ညီကို မောန်နှမလေ တချို့ဟှို ဗြို့ရဲ့ အာဏာပိုင်လေရှေ့ဟှို ခေါ်ဆောန်ဟှားဘီးဟှာ “အယ်လူလေဟှာ လောကီနိုင်ငံရဲ့ နေရာတိုင်းမာ ဒေါက်ခပေးနေဂေ့ဟှယ်။ သူးနို့ဟှာ ခုလည်း ကျွန်တော့်လေရဲ့ဗြို့ဟှို ရော့‑က်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ယာသုန်ဟှာ အယ်လူလေဟှို သူ့အီမာ လတ်ခံဟှားဟှယ်။ အယ်လူလေဟှာ ယေရှုနာမယ်န မန်းဂီးတပါးရှိဟှယ် ဆိုဘီး ကဲသာမန်းဂီးရဲ့ မိန့်တော်ဟှို ဆန့်ကျင်ဖတ် လောက်နေဂေ့ဟှယ်” ဆိုဘီး အော်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","အယ်မျိုး စကားလေန သူးနို့လေဟှာ လူအောက်ဂီးန ဗြို့အာဏာပိုင်လေဟှို ရောက်ရောက်သဲသဲ လောက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","အာဏာပိုင်လေဟှာ ယာသုန်န လောက်ဖော်ဆောန်ဖတ်လေဟှို အာမခံဖြစ်န ကပ်ပေးခိုင်းဘီးဟှာ ထွပ်ဟှားဟှို့တွပ် ခွမ့်ပြုလိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ညဉ့်ခန်းဇာ ရော့‑က်လာဟှူ ခီမာ ညီကို မောန်နှမလေဟှာ ပေါလုန သိလလေဟှို ဗေရိဗြို့ဟှို စေလွှတ်ဂေ့ဟှယ်။ အယ်ဗြို့ဟှို ရော့‑က်ဟှူ ခီမာ သူးနို့ဟှာ ယုဒဝါလယ်ဇရပ်ဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ဗေရိဗြို့သားလေဟှ သက်သာလောနိတ်ဗြို့ဟှ လူလေထတ် စိထားမြတ်ဂေ့ဟှယ်။ အယ်ကြောန့် ပေါလုဟောဟှူ တရားဟှို ရရာတိုင်း ကြည်ညိုဟှူစိန နာခံဂေ့ဟှယ်။ သူးနို့ဟှာ ပေါလု ပြောဇာလေဟှာ တကယ်မှန်ဘဲ့လား ဆိုဘီး သိနိုင်ဟှို့တွပ် နေ့တိုင်းကျမ်းစာဟှို လေ့လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","အယ်ကြောန့် လူလေဘောင်ဂီး ယောင်ကြည်လာဂေ့ဟှယ်။ အယ်မျိုး ယောင်ကြည်သူလေထဲမာ ဂေါန်သရေရှိဟှူ ဟေလသလူမျိုး မီးမန ယော့‑က်ကျားလေလည်း ပါဝမ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ဗေရိဗြို့မာ ဘုရားသခင်ရဲ့ စကားတော်ဟှို ပေါလု ဟောနေဟှယ် ဆိုဇာဟှို သက်သာလောနိတ်ဗြို့ဟှ ယုဒလူမျိုးလေဟှာ ကြားရဂေ့ဟှူ ခီမာ ဗေရိဗြို့ဟှို လာဂေ့ဘီးဟှာ လူလေဟှို ဆူပူအောန် နှိုးဆော်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ညီကို မောန်နှမလေဟှာ ရှစ်ရှင်းဘဲ့ ပေါလုဟှို ပန်လယ်ကမ်းခြေဟှို သွားခိုင်းလိုက်ဟှယ်။ သိလန တိမောသေလေဟှ ဗေရိဗြို့မာဘဲ့ နေရစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ပေါလုဟှို လိုက်ပို့ဂေ့ဟှူ လူလေဟှာ သူ့နတူးဒူ အာသင်ဗြို့ထိ လိုက်ဟှားဂေ့ဟှယ်။ အယ်ဘီးန သိလန တိမောသေလေဟှို ဗြန်းဗြန်ဟှား လိုက်လာဟှို့တွပ် ညွှန်ကြားချစ်ဟှို ယူဘီးန ဗေရိဗြို့ဟှို ပ္လန်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ပေါလုဟှာ အာသင်ဗြို့မာ သိလန တိမောသေလေဟှို စောန့်နေဒူးမာ အယ်ဗြို့မာ ရောက်ထုလေဘောင်ဂီး ရှိနေဟှယ် ဆိုဇာဟှို ဗြင်ဟှူ ခီမာ ရရာတိုင်း စိကောန်းဘဲ ဖြစ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","အယ်ကြောန့် ဝါလယ်ဇရပ်မာ ယုဒလူမျိုးလေ၊ ဘုရားသခင်ဟှို ကိုးကွယ်ဟှူ လူမျိုးခြားလေ နေ့တိုင်းဗြို့ထဲဟှ လူလေစုဝီးဟှူ နေရာဟှို လာဂေ့ဟှူ လူလေန ဆွေးနွီးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ဧပိကုရုန သတောအိပ် တွေးခေါ်ပညာရှင်လေ တချို့လည်း ပေါလုန ဆွေးနွီးငြင်းခူဂေ့ဟှယ်။ အယ်လူလေထဲမာ တချို့ဟှ “အယ်လူဟှာ ဖြားဇာပြောနေနူး” ဆိုဘီး ပြောဂေ့ဟှယ်။ တခြားလူလေဟှ “သူဟှာ လူမျိုးခြားလေရဲ့ နတ်ဘုရားလေရဲ့ ကြောန်းဟှို ပြောနေဇာနတူဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ပေါလုဟှာ ယေရှုကြောန်းန ရှင်ပ္လန်ထမြော့‑က်ရှင်းကြောန်းဖြစ်ဟှူ ဒန်းကောန်းဟှို ဟောပြောကြောန့် သူးနို့လေဟှာ အယ်မျိုး ပြောနေဂေ့ဇာဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","အယ်ကြောန့် အယ်လူလေဟှ ပေါလုဟှို အာရေပါဂု တရားရောင်းဟှို ခေါ်ဆောန်ဟှားဂေ့ဘီးဟှာ “နန်ဟောပြောနေဟှူ ယူဝါဒသစ်ကြောန်းဟှို နို့လေလည်း သိရှင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","နန်ဟောပြောဟှူ ကြောန်းရာတချို့ဟှာ နို့လေတွပ် သစ်ဆန်းဖြစ်နေဟှယ်။ အယ်ကြောန်းရာရဲ့ ဓိပါယ်ဟှိုလည်း နို့လေသိရှင်ဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","အာသင်ဗြို့သား ဂူလောင်းန အယ်ဗြို့မာနေဟှူ ဧည့်သည်လေဟှာ ကြောန်းရာသစ်ဆန်းလေဟှို ပြောဇာန နားထောန်ဇာ အားဖြင့်ဘဲ့ ခီဟှို ကူစေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ပေါလုဟှာ အာရေပါဂု တရားရောင်းရှေ့မာ ရပ်ဘီး “အာသင်ဗြို့သားလေ၊ နန်းနို့ဟှာ ရရာတိုင်း ဘုရားတရားဟှို ကြည်ညိုဟှူ လူလေဖြစ်ဟှယ် ဆိုဇာဟှို ငါဗြင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ကျွန်တော့်ဟှာ ခန်ဗျားလေရဲ့ဗြို့ဟှို ရှော့‑က်လည်ဘီး ကိုးကွယ်ဟှူဇာလေဟှို ကေ့ဟှူ ခီမာ ‘နို့လေ သိဘဲဟှူ ဘုရားတွပ်’ ဆိုဘီး နာမယ်ရေးဟှားဟှူ ယဇ်ပလ္လင်တခုဟှို တွိဟှယ်။ အယ်မျိုး ခန်ဗျားလေသိဘဲန ကိုးကွယ်နေဟှူ ဘုရားကြောန်းဟှို ခု ကျွန်တော်ပြောပြမယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ကမ္ဘာလောကဂီးန ရှိဇာဂူလောင်းဟှို ဖန်ဆင်းဟှူ ဘုရားသခင်ဟှာ ကောန်းဂန်န မ္လေဂီးရဲ့ သခင်ဖြစ်ဟှူကြောန့် လူလတ်န ဆော့‑က်ဟှားဟှူ ဗိမာန်တော်လေမာနေဇာ မှုဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","အယ်သခင်ကိုယ်တိုင်ဘဲ့ လူလေ ဂူလောင်းဟှို သတ်နတူးဒူ တခြားရာ ဂူလောင်းဟှိုလည်း ပေးသနားတော်မူဟှယ်။ အယ်ကြောန့် သူဟှာ တခုခုဟှို လိုရှင်ဟှူကြောန့် လူလတ်န ပြုစုဇာဟှို ခံတော်မူဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ကိုယ်တော်ဟှာ လူတယော့‑က်ဟှနေဘီး လူမျိုးဂူလောင်းဟှို ဖန်ဆင်းလိုက်ဘီး တကမ္ဘာလောင်းမာ သူးနို့ဟှို နေစေဟှယ်။ အယ်လူမျိုး ဂူလောင်းဟှို သတ်ရှင်နေထိုင်ဟှို့တွပ် ခီကာလန နေရာလေဟှို ကြိုတန်ပိုင်းခြား သတ်မှတ်ဟှားဘီး ပေးဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","28","အယ်မျိုးလောက်ဇာဟှာ လူလေဟှာ ကိုယ်တော့်ဟှို တွိလိုတွိငြား စမ်းသပ်ဘီး ရှာဟှို့တွပ်ဘဲ့ ဖြစ်ဟှယ်။” “ ‘ကျွန်တော့်လေဟှာ ကိုယ်တော်ကြောန့် သတ်ရှင်ဘီး လှောက်ရှား နေရဂေ့ဟှယ်။’ ” အယ်ကြောန့် တကယ်ဆိုဟှာ ဘုရားသခင်ဟှ ဖယ်သူနလည်းဝီးဇာ မှုဟှ။ ခန်ဗျားဟှားလေထဲမာ ကဗျာဆရာတချို့ဟှ၊ “‘နို့လေဟှာ ကိုယ်တော်ရဲ့ သားမီးလေ ဖြစ်ဂေ့ဟှယ်’ ” ဆိုဘီး ပြောဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“ကျွန်တော့်လေဟှာ ဘုရားသခင်ရဲ့ သားမီးလေ ဖြစ်ဂေ့ဟှူကြောန့် ဘုရားသခင်ဟှို လူရဲ့နုပညာန ကျွမ်းကျင်ရှင်းအားဖြင့် ထုလောက်ဟှားဟှူ ရွှေရောက်ထု၊ ငွေရောက်ထု၊ က္လော့‑က်ရောက်ထုနတူဟှယ် ဆိုဘီး ထန်မှတ်သင့်ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ဘုရားသခင်ဟှာ လူလေသိနားလည်ဘဲဟှူ ခီကာလဟှို ရှုမှတ်တော် မှုဟှ။ အယ်ဘေမဲ့ ခု နေရာတိုင်းဟှ လူလေဂူလောင်းဟှို နောန်ဒရဟှို့တွပ် မိန့်တော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ကိုယ်တော် ဝီးကော့‑က်ဟှားဟှူ လူအားဖြင့် လောကသားလေဟှို ဖြောန့်မတ်ရှင်းတရားန စီရင်မယ့် နေ့ရစ်ဟှို သတ်မှတ်ဟှားကြောန့် ဖြစ်ဟှယ်။ အယ်မျိုးဖြစ်မယ် ဆိုဇာဟှို အယ်သခင်ဟှာ သေရာဟှနေ ထမြော့‑က်ရှင်းအားဖြင့် လူလေဂူလောင်းဟှို အယ်သတ်သေဟှို ပြဟှားဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","သေရာဟှနေ ထမြော့‑က်ကြောန်းဟှို ကြားရဟှူ ခီမာ တချို့လူလေဟှ ရယ်ဇားဂေ့ဟှယ်။ အယ်ဘေမဲ့ တချို့လူလေဟှ “နန်ပြောနေဟှူကြောန်းဟှို နို့လေဟှ နော့‑က်တခါ ကြားရှင်သေးဟှယ်” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","အယ်ဘီးန ပေါလုဟှာ စည်းဝေးဟှနေ ထွပ်ဟှားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","တချို့လူလေဟှာ ပေါလုန ပေါန်းဘီးဟှာ ယောင်ကြည်သူလေ ဖြစ်လာဂေ့ဟှယ်။ အယ်လူလေထဲမာ ဒယောနုသိ နာမယ်ရှိဟှူ အာရေတောင် တရားရောင်းရဲ့ ဖွဲ့ဝမ်တယော့‑က်၊ ဒမာရိ နာမယ်ရှိဟှူ မီးမတယော့‑က်န တခြားလူ တချို့လည်း ပါဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","အယ်ဘီးန ပေါလုဟှာ အာသင်ဗြို့ဟှ ထွပ်ဟှားဘီး ကောရိန့်ဗြို့ဟှို ရော့‑က်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","အယ်ဗြို့မာ ပုန္တုပြည်သား အာကုလ နာမယ်ရှိဟှူ ယုဒလူမျိုးတယော့‑က်န သူ့မယား ပြစ်ကိလလေဟှို တွိဟှားဟှယ်။ ယုဒလူမျိုးလေဟှ ရောမဗြို့ဟှနေ ထွပ်ဟှားဟှို့တွပ် ကလောဒိမန်းဂီးဟှ မိန့်ထုဟှားဟှူကြောန့် သူးနို့ဟှာ ကြာသေးခန်ဟှ ဣတလိပြည်ဟှနေ ထွပ်လာဂေ့ဟှူ လူလေဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","အယ်လူလေဟှာ ပေါလုမျိုးဘဲ တဲရှင်ချောက်ဘီး သတ်မွီးနေဟှူ တဲရှင်ချောက်မားလေ ဖြစ်ဂေ့ဟှယ်။ အယ်ကြောန့် ပေါလုဟှာ သူးနို့လေနားဟှို သွားဘီးဟှာ သူးနို့နတူးဒူ လောက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ယုဒလူမျိုးန ဟေလသလူမျိုးလေဟှို သွီးဆောန်ဟှို့တွပ် သူဟှာ ဒန်းနေ့တိုင်း ဝါလယ်ဇရပ်မာ ဆွေးနွီးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","သိလန တိမောသေလေဟှာ မာကေဒေါနိပြည်ဟှနေ ရော့‑က်လာဂေ့ဟှူ ခီမာ ပေါလုဟှာ ယုဒလူမျိုးလေဟှို တခီလောင်း တရားဟောပြောဘီးန ယေရှုဟှာ မေရှိယဖြစ်ဟှယ် ဆိုဘီး သတ်သေခံလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ယုဒလူမျိုးလေဟှာ သူ့ဟှို စော်ကားဘီး ပြောနေဟှူ ခီမာ ပေါလုဟှာ သူ့အန်းဂီဟှနေ ဖောင်လေဟှို ခါခ္လဘီးဟှာ “နန်းနို့ရဲ့ သွီးဟှာ နန်းနို့ ခေါန်းထတ်မာ ရှိပါစေ! ငါ့တာဝန် မှုဟှ။ ခုဟှစဘီး ငါဟှာ လူမျိုးခြားလေနားဟှို သွားမယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","အယ်ဘီးန အယ်လူလေနားဟှ ထွပ်ဟှားဘီးဟှာ ဘုရားသခင်ဟှို ကိုးကွယ်ဟှူ တိတုယုတ္တု နာမယ်ရှိဟှူ လူမျိုးခြားရဲ့ အီဟှို သွားဘီးဟှာ နေလေဟှယ်။ သူ့အီဟှာ ဝါလယ်ဇရပ်န ကပ်နေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ဝါလယ်ဇရပ်မှူးဖြစ်ဟှူ ကရိပ္ပုန သူ့မိသားစုဂူလောင်းဟှာ သခင်ဘုရားဟှို ယောင်ကြည်ဟှူသူလေ ဖြစ်လာဂေ့ဟှယ်။ တခြား ကောရိန္သုဗြို့သား ဘောင်ဂီးဟှလည်း တရားတော်ဟှို ကြားရဟှူ ခီမာ ယောင်ကြည်ဘီးဟှာ ဗတ္တိဇံခံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","တညဉ့်မာ ပေါလုဟှာ ရူပါရောင်ဟှို ဗြင်ရဟှယ်။ ရူပါရောင်ထဲမာ သခင်ဘုရားဟှ “ကြော့‑က်န။ ဆစ်ဘီးဟောပါ။ လတ်ရှော့န။ ");
INSERT INTO tvn_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါဟှာ နန့်နတူးဒူ ရှိဟှယ်။ ဖယ်သူဟှလည်း နန့်ဟှို ဘေးပြုနိုင်ဟှ။ အယ်ဗြို့မာရှိဟှူ လူဘောင်ဂီးဟှ ငါ့လူလေ ဖြစ်ဂေ့ဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ပေါလုဟှာ အယ်ဗြို့မာ တနှစ်နခြော့‑က်လ နေဘီးဟှာ ဘုရားသခင်ရဲ့ စကားတော်ဟှို သွန်သန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ဂါလျုန်ဟှာ အခါယပြည်ရဲ့ ဗြို့ဝန်မန်း ဖြစ်နေဟှူ ခီမာ ယုဒလူမျိုးလေဟှာ စုဘီး ပေါလုဟှို ဖမ်းဘီးဟှာ တရားပလ္လင်ရှေ့ဟှို ခေါ်ဆောန်လာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","သူးနို့ဟှ “အယ်လူဟှာ ပညတ်တရားဟှို ဆန့်ကျင်ဘီး ဘုရားသခင်ဟှို ကိုးကွယ်ဂေ့ဟှို့တွပ် လူလေဟှို သွီးဆောန်နေဟှယ်” ဆိုဘီး လျှော့‑က်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ပေါလုဟှာ စကားပြောဟှို့ လောက်နေဒူးမာ ဂါလျုန်ဟှ “ယုဒလူမျိုးလေ၊ အယ်မှုဟှာ ကောန်းဘဲဟှူမှု၊ တရားဘဲဟှူမှုဖြစ်ဟှယ် ဆိုဟှာ ငါဟှာ နန်းနို့ရဲ့ စွပ်စွဲချစ်လေဟှို စိရှယ်လတ်ရှယ်န နားထောန်နိုင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","အယ်ဘေမဲ့ အယ်မူဇာဟှာ စကားလေ၊ နာမယ်လေန ပညတ်တရားနဆိုင်ဟှယ် ဆိုဟှာ နန်းနို့ ကိုယ်တိုင်ဘဲ့ ဆောင်းဖြတ်ဂေ့။ အယ်မှုဟှို ငါစီရင်ဟှ” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ယုဒလူမျိုးလေဟှို တရားပလ္လင်ရှေ့ဟှနေ နှန်ထုလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","အယ်လူလေဟှာ ဝါလယ်ဇရပ်မှူး သုဿင်ဟှို ဖမ်းဘီးဟှာ တရားပလ္လင်ရှေ့မာ ရိုက်ဂေ့ဟှယ်။ အယ်ဘေမဲ့ ဂါလျုန်ဟှာ အယ်မှုဟှို လောင်းဝ ဂရုစိုက်ဘဲနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ပေါလုဟှာ ကောရိန္သုဗြို့မာ ကြာဂီးနေဟှယ်။ အယ်ဘီးန ညီကို မောန်နှမလေဟှို နှောက်ဆစ်ဘီး ပြစ်ကိလ၊ အာကုလလေနတူးဒူ ရှုရိပြည်ဟှို သန်းဖောန သွားဂေ့ဟှယ်။ ကင်ခြေဗြို့ဟှနေ သန်းဖောန ထွပ်ခန်မာ သူဟှာ ဘုရားသခင်ဟှို သစ်စာဂဒိ ပြုဟှားဟှူကြောန့် သူ့ခေါန်းဟှို ရိလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ဧဖက်ဗြို့ဟှို ရော့‑က်ဟှားဟှူ ခီမာ ပေါလုဟှာ ပြစ်ကိလန အာကုလလေဟှို ဗြို့မာထားရစ်ဟှယ်။ သူဟှာ ဝါလယ်ဇရပ်ဟှို ဝမ်ဘီးဟှာ ယုဒလူမျိုးလေန ဆွေးနွီးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","လူလေဟှာ သူးနို့နတူးဒူ ကြာဂီးနေဟှို့တွပ် တိုက်တွန်းဂေ့ဘေမဲ့လည်း ပေါလုဟှာ လတ်ခံဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","အယ်မျိုးပြောမယ့်စား “ဘုရားသခင်ဟှ လိုတော်ရှိမယ် ဆိုဟှာ နန်းနို့နားဟှို ပ္လန်လာမယ်” ဆိုဘီး ဧဖက်ဗြို့ဟှနေ သန်းဖောန ထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","သူဟှာ ကဲသရိဗြို့ဟှို ရော့‑က်ဟှားဟှူ ခီမာ ယေရုရှလင်ဗြို့ဟှို တတ်ဟှားဘီး သင်းတော်ဟှို နှောက်ဆစ်ဘီး အန္တိအုတ်ဗြို့ဟှို သွားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","အယ်ဗြို့မာ ကြာဂီးနေဘီးန ပ္လန်ထွပ်ဟှားဘီး၊ ဂလာတိပြည်န ဖြူဂိပြည်ဟှို လှည့်လည်ဘီး တဗဲ့တော်လေဟှို ခိုင်ခန့်မြဲမြံ စေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","အယ်ခီမာ အာလေဇန္ဒြိဗြို့သား အာပေါလု နာမယ်ရှိဟှူ ယုဒလူမျိုးတယော့‑က်ဟှာ ဧဖက်ဗြို့ဟှို ရော့‑က်လာဟှယ်။ သူဟှာ ကျမ်းစာဟှို ကျွမ်းကျင်ဘီး ဟောပြောကောန်းဟှူ လူဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","သူဟှာ သခင်ဘုရားရဲ့ လမ်းစဉ်ဟှို သေးသေချားချာဟှား သွန်သန်ခံဟှားရဟှူလူ ဖြစ်ဟှယ်။ သူဟှာ စိအားထတ်သန်ဘီး ယေရှုန ဆိုင်ဟှူဇာလေဟှို မှန်းမှန်ကန်းကန်ဟှား သွန်သန်နေဟှယ်။ အယ်ဘေမဲ့ သူဟှာ ယောဟန်ရဲ့ ဗတ္တိဇံဟှိုဘဲ့ သိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","သူဟှာ ဝါလယ်ဇရပ်မာ စဘီးဟှာ ရဲရဲရင့်ရင့်ဟှား ဟောနေဟှယ်။ သူ့ဟောပြောချစ်လေဟှို ကြားရဟှူ ပြစ်ကိလန အာကုလလေဟှာ သူ့ဟှို အီဟှို ခေါ်ဘီးဟှာ ဘုရားသခင်ရဲ့ လမ်းစဉ်ဟှို သေးသေချားချာဟှား ရှင်းပြပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","အယ်ဘီးန သူဟှာ အခါယပြည်ဟှို သွားဟှို့ ဆောင်းဖြတ်လိုက်ဟှယ်။ အယ်ကြောန့် ဧဖက်ဗြို့ဟှ ယောင်ကြည်သူလေဟှာ သူ့ဟှို လတ်ခံဟှို့တွပ် အခါယပြည်ဟှ ယောင်ကြည်သူလေနားဟှို စာရေးပေးရှင်းအားဖြင့် ကူညီပေးဂေ့ဟှယ်။ သူဟှာ အခါယပြည်ဟှို ရော့‑က်ဟှူ ခီမာ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်အားဖြင့် ယောင်ကြည်လာဟှူ လူလေဟှို ဘောင်ဂီး ကူညီပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ သူဟှာ ကျမ်းစာအားဖြင့် ယေရှုဟှာ မေရှိယ ဖြစ်ဟှူကြောန်းဟှို ထော့‑က်ပြဘီး လူလေရှေ့မာ ယုဒလူမျိုးလေဟှို ပိုင်းပိုင်ဟှား ချေပလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ကောရိန့်ဗြို့မာ အာပေါလု ရှိနေဟှူ ခီမာ ပေါလုဟှာ ထတ်မာ ဖော်ပြဟှားဟှူ နေရာလေဟှို ရှော့‑က်သွားဘီးန ဧဖက်ဗြို့ဟှို ရော့‑က်လာဟှယ်။ အယ်ဗြို့မာ တဗဲ့တော် တချို့ဟှို တွိဘီး၊ ");
INSERT INTO tvn_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","သူးနို့ဟှို “နန်းနို့လေဟှာ ယောင်ကြည်သူလေ ဖြစ်လာဂေ့ဟှူ ခီမာ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှို လတ်ခံဂေ့ဘီးလော” ဆိုဘီး မေးဟှယ်။ အယ်လူလေဟှ “သန့်ရှင်းဟှူဝိညာဉ်တော်ရှိဟှယ် ဆိုဇာဟှို ကျွန်တော့်လေ ကြားဖူးဟှ” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ပေါလုဟှ “အယ်မျိုးဆိုဟှာ နန်းနို့ဟှာ ဖြားမျိုးစား ဗတ္တိဇံဟှို ခံဟှားနူး” ဆိုဘီး မေးဟှယ်။ အယ်လူလေဟှ “ယောဟန်ရဲ့ ဗတ္တိဇံဟှို ခံဟှားဟှယ်” ဆိုဘီး ပ္လန်ဖြေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ပေါလုဟှ “ယောဟန်ရဲ့ ဗတ္တိဇံဟှာ နောန်ဒနဆိုင်ဟှူ ဗတ္တိဇံဖြစ်ဟှယ်။ ယောဟန်ဟှာ သူ့နော့‑က်မာ ကြွလာဟှူ သခင်ဟှို ယောင်ကြည်ရမယ် ဆိုဘီး ဣသရေလလူမျိုးလေဟှို ပြောရစ်ဟှယ်။ အယ်သခင်ဟှာ ယေရှုဘဲ့ ဖြစ်ဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","အယ်စကားဟှို ကြားရဟှူ ခီမာ သူးနို့ဟှာ သခင်ယေရှုနာမနှိုက် ဗတ္တိဇံခံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ပေါလုဟှာ သူးနို့ခေါန်းထတ်ဟှို လတ်တန်လိုက်ဟှူ ခီမာ သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှာ သူးနို့ထတ်ဟှို ရော့‑က်လာဟှယ်။ အယ်ဘီးန သူးနို့ဟှာ ထူးဆန်းဟှူ ဘာသာစကားလေဟှို ပြောဂေ့ဘီး ဘုရားသခင်ရဲ့ တရားတော်ဟှိုလည်း ပရောဖက်ပြုဘီး ဟောပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","သူးနို့ဟှာ အားလောင်းပေါန်း လူဆယ့်နှေ့ယော့‑က်လော့‑က် ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ပေါလုဟှာ ဝါလယ်ဇရပ်ထဲဟှို ဝမ်ဟှားဘီး သောင်းလလောင်းလောင်း ရဲရဲရင့်ရင့်ဟှား ဟောပြောဘီး ဘုရားသခင်ရဲ့ နိုင်ငံတော်ကြောန်းဟှို ဆွေးနွီးဘီး လူလေဟှို သွီးဆောန်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","အယ်ဘေမဲ့ လူတချို့ဟှာ ခေါန်းမာဘီး ယောင်ကြည်ဘဲန လူလေရှေ့မာ သခင်ဘုရားရဲ့ လမ်းစဉ်လေဟှို ကဲ့ရဲ့ဂေ့ဟှယ်။ အယ်ကြောန့် ပေါလုဟှာ တဗဲ့တော်လေဟှို ခေါ်ဘီး အယ်လူလေနားဟှနေ ထွပ်ဟှားဘီးဟှာ တုရန္နုရဲ့ စာသန်ခန်းမမာ နေ့တိုင်း ဆွေးနွီးဗွဲလေ လောက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","နှေ့နှစ်လောင်းလောင်း အယ်မျိုးလောက်ဟှူကြောန့် အာရှိပြည်မာနေဟှူ ယုဒလူမျိုးလေန ဟေလသလူမျိုးလေဟှာ သခင်ဘုရားရဲ့ စကားတော်ဟှို ကြားရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ဘုရားသခင်ဟှာ ပေါလုအားဖြင့် ရရာတိုင်း ထူးခြားဟှူ နိမိတ်လတ်ခဏာလေဟှို ပြတော်မူဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ပေါလုသောင်းဟှားဟှူ လတ်ကိုင်ပဝါန ခါးဗတ်လေဟှို လူနာလေနားဟှို ယူဆောန်ဟှားဟှူ ခီမာ သူးနို့ဟှာ ရောဂါပျော့‑က်ဟှားဘီး နတ်ဆိုးလေလတ်ဟှနေလည်း လွှတ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","နယ်တကာလှည့်ဘီး နတ်ဆိုးလေဟှို နှန်ထုနေဟှူ ယုဒလူတချို့ဟှာ သခင်ယေရှုရဲ့ နာမဟှို သောင်းပြုဘီး နတ်ဆိုးဟှို နှန်ထုဟှို့ ကြိုးစာဂေ့ဟှယ်။ သူးနို့ဟှာ “ပေါလုဟောနေဟှူ ယေရှုရဲ့ နာမန နန့်ဟှို ငါနှန်ထုဟှယ်” ဆိုဘီး နတ်ဆိုးဟှို မိန့်ပေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","အယ်မျိုးလောက်နေဟှူ သူလေဟှာ သာကေဝ နာမယ်ရှိဟှူ ယုဒယဇ်ပုရောဟိတ်ဂီးရဲ့ သားခွန်နစ်ယော့‑က် ဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","အယ်ဘေမဲ့ နတ်ဆိုးဟှ “ယေရှုဟှို ငါသိဟှယ်။ ပေါလုဟှိုလည်း ငါသိဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ဟှ ဖယ်သူလေနူး” ဆိုဘီး သူးနို့ဟှို မေးလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","အယ်ဘီးန နတ်ဆိုးဝမ်နေဟှူ လူဟှာ သူးနို့ဟှို ပြင်းပြင်းထန်းထန်ဟှား တိုက်ခိုက်ဂေ့ဟှယ်။ သူးနို့ဟှာ ခ္လေးဗ္လန်းဗ္လန်းန၊ ဒန်ရာလေန အီထဲဟှနေ ထွပ်ပ္လေးဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","အယ်ကြောန်းဟှို ဧဖက်ဗြို့မာနေဟှူ ယုဒလူမျိုးလေန ဟေလသလူမျိုးလေဟှာ ကြားရဂေ့ဟှယ်။ သူးနို့ဟှာ ရရာတိုင်း ကြော့‑က်ဂေ့ဘီးဟှာ သခင်ယေရှုရဲ့ နာမဟှို ချီးမွမ်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ယောင်ကြည်သူလေဟှာ ရော့‑က်လာဂေ့ဘီး သူးနို့လောက်မိဟှူ ဇာလေဟှို ပွမ့်ပွမ့်လန်းလန်းဟှား ဖော်ပြဘီးဟှာ ဝန်ခံဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","နတ်ဝိဇ္ဇာတတ်ဟှို သောင်းဟှူလူလေဟှာ သူးနို့ စာစောန်လေဟှို စုစည်းယူလာဘီး လူအားလောင်းရှေ့မာ မီးရှို့ဂေ့ဟှယ်။ အယ်စာစောန်လေရဲ့ တန်ဖိုးဟှို တွပ်ကေ့ဟှူ ခီမာ ငွေဒန်းဂါး ၅၀,၀၀၀ ဖိုးလော့‑က် ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","အယ်နည်းလမ်းအားဖြင့် သခင်ဘုရားရဲ့ စကားတော်ဟှာ တဂိုးတော်န တိုးပွားဘီး အောန်မြင်လေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","အယ်ဇာလေ ဖြစ်ဟှားဘီးန မာကေဒေါနိပြည်န အခါယပြည်ဟှနေဘီး ယေရုရှလင်ဗြို့ဟှို သွားဟှို့တွပ် ဝိညာဉ်တော်အားဖြင့် ပေါလုဟှာ စိဆောင်းဖြတ်လိုက်ဟှယ်။ သူဟှ “အယ်ဗြို့ဟှို ငါသွားဘီးန ရောမဗြို့ဟှိုလည်း သွားမယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ပေါလုဟှာ သူ့ဟှို စေခံနေဟှူ တိမောသေန ဧရတ္တုလေဟှို မာကေဒေါနိပြည်ဟှို လွှတ်လိုက်ဟှယ်။ သူဟှ အာရှိပြည်မာ ရှစ်ဟှားနေရစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","အယ်ခီမာ သခင်ဘုရားရဲ့ လမ်းစဉ်ကြောန့် ဧဖက်ဗြို့မာ ဆူပူမှုဂီးတခု ဖြစ်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ဒေမေတရိ နာမယ်ရှိဟှူ ငွေပဒေခတ်မားဟှာ အာတေမိနတ်မီးရဲ့ ငွေနတ်ကွန်းငယ်လေ လောက်ရှင်းအားဖြင့် လတ်မှုပညာရှင်လေဟှို ရရာတိုင်း ကပ်ရစေလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","အယ်ကြောန့် သူဟှာ အယ်လောက်ငန်း လောက်နေဟှူ လောက်မားလေနတူးဒူ တခြားလောက်မား လေဟှိုလည်း စုဘီးဟှာ “ငါ့လူလေ၊ အယ်လောက်ငန်းန နို့လေဟှာ ဝမ်ငွေကောန်းနေဟှယ် ဆိုဇာဟှို နန်းနို့လေ သိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ခု နန်းနို့ကိုယ်တိုင် ဗြင်ရ၊ ကြားဟှားဟှူတိုင်း အယ်ပေါလုဟှာ ‘လူလတ်န လောက်ဟှားဟှူ ဘုရားလေဟှာ ဘုရားမှုဟှ’ ဆိုဘီး ဧဖက်ဗြို့န အာရှိပြည် တပြည်လောင်းဟှ လူလေဘောင်ဂီးဟှို သွီးဆောန်ဘီး လမ်းမှားစေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","အယ်မှုဟှာ နို့လေရဲ့ လောက်ငန်းဟှို နာမယ်ပျစ်စေမယ် ဆိုဘီး စိုးရိမ်ဇာရှိမျှ မကဘဲန ကီးမြတ်ဟှူ အာတေမိ နတ်ဖုရားမရဲ့ ဗိမာန်ဟှာ ပမာဏပြုဇာ မှေ့ဘဲန အာရှိပြည်န ကမ္ဘာတဝန်းလောင်းမာ ကိုးကွယ်ဟှူ နတ်ဖုရားမရဲ့ ဂေါင်သရေလည်း ပျော့‑က်ကွယ်ဟှားလေ့မယ်” ဆိုဘီး ပြောလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","အယ်စကားဟှို ကြားဟှူ လတ်မှုပညာရှင်လေဟှာ ဒေါသထွပ်ဘီးဟှာ “ဧဖက်ဗြို့ရဲ့ အာတေမိ နတ်ဖုရားမဟှာ ကီးမြတ်ဟှယ်” ဆိုဘီး အော်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","တဗြို့လောင်းဟှာ ရရာတိုင်း ရှောက်ရှစ်ခတ်ဟှားဟှယ်။ လူလေဟှာ ပေါလုနတူးဒူ ခရီးသွားဟှူ မာကေဒေါနိပြည်သား ဂါယုန အာရိတ္တာခုလေဟှို ဖမ်းဘီးဟှာ ပွဲခံဟှူ ခန်းမဂီးဟှို ဗြန်းဗြန်ဟှား ဆွဲခေါ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ပေါလုဟှာ သူကိုယ်တိုင်ဘဲ့ လူအောက်ဂီးရှေ့ဟှို သွားရှင်ဘေမဲ့လည်း တဗဲ့တော်လေဟှာ ခွမ့်ပြုဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ပေါလုရဲ့ မိဆွေဖြစ်ဟှူ နယ်အာဏာပိုင် တချို့ဟှလည်း ပွဲခံဟှူ ခန်းမဂီးထဲဟှို ဝမ်ဘဲဟှို့တွပ် သူ့နားဟှို လူလွှတ်ဘီး တောန်းဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","အယ်ခီမာ လူလေဟှာ တယော့‑က်တဘော့‑က် အော်ဘီးဟှာ ရောက်ရောက်သဲသဲ ဖြစ်နေဂေ့ဟှယ်။ လူလေဟှ သူးနို့လေ ဖြားဖြစ်ကြောန့် စုနေဂေ့ဟှယ် ဆိုဇာဟှို သိဂေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ယုဒလူမျိုးလေဟှာ အာလေဇန္ဒြုဟှို ရှေ့ဟှို ထွပ်ခိုင်းစေဟှယ်။ လူလေတချို့ဟှလည်း အယ်လူဟှာ ခုဖြစ်နေဟှူ ကိစနဆိုင်ဟှယ် ဆိုဘီး ယူဆဂေ့ဟှယ်။ အာလေဇန္ဒြုဟှာ လူအောက်ဂီးဟှို တိတိဟှားနေဟှို့တွပ် လတ်န ချစ်ပြလိုက်ဟှယ်။ အယ်ဘီးဟှာ ဖြေရှင်းဟှူ စကားဟှို ပြောဟှို့တွပ် ကြိုးစားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","သူဟှာ ယုဒလူမျိုးဖြစ်ဟှယ် ဆိုဇာဟှို သူးနို့လေ သိဂေ့ဟှူ ခီမာ “ဧဖက်ဗြို့သားလေရဲ့ အာတေမိ နတ်ဖုရားမဟှာ ကီးမြတ်ဟှယ်” ဆိုဘီး နှေ့နာရီလော့‑က်ထိ လူလေဟှာ တသံဒဲ အော်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","နော့‑က်ဆောင်းမာ ဗြို့စာရေးဟှာ လူအောက်ဂီးဟှို တိတိဟှားနေခိုင်းဘီး “ဧဖက်ဗြို့သားလေ၊ ဧဖက်ဗြို့တော်ဟှာ ကီးမြတ်ဟှူ အာတေမိနတ်ဖုရားမရဲ့ ဗိမာန်တော်န ကောန်းဂန်ဘောင်ဟှနေ က္လလာဟှူ ရောက်ထုလေဟှို ထီးသီးစော့‑က်ရှော့‑က်ဟှားဟှူ ဗြို့ဖြစ်ဟှယ် ဆိုဇာဟှို လူတိုင်းသိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","အယ်မူဇာဟှို ဖယ်လူလည်း ဂြင်းနိုင်ဟှ။ အယ်ကြောန့် နန်းနို့ဟှာ တိတိဆိဆိနေဂေ့။ စဉ်းစားဘဲန ဖြားဇာလည်း လောက်ဂေ့န။ ");
INSERT INTO tvn_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","နန်းနို့ဟှာ သူးနို့ဟှို အယ်နေရာဟှို ခေါန်းဆောန်လာဂေ့ဟှယ်။ သူးနို့ဟှာ နို့လေရဲ့ ဗိမာန်တော်ဟှို ဖျစ်ဆီးရှင်းလည်း မှုဟှ။ နို့လေရဲ့ နတ်ဖုရားမဟှိုလည်း ကဲ့ရဲ့ဟှူ စကားလေလည်း ပြောဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ဒေမေတရိန သူ့ပေါန်းပါလေထဲဟှ ယော့‑က်ယော့‑က်ဟှ တရားစွဲမယ် ဆိုဟှာ တရားရောင်းဖွမ့်ဟှူ ရစ်မာဘဲ့ အာဏာပိုင်လေရှိဟှူကြောန့် တရားစွဲနိုင်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","အယ်ဘေမဲ့ နန်းနို့မာ တခြားကိစရှိဟှယ် ဆိုဟှာ တရားဝမ်စည်းဝေးမာ ဆောင်းဖြတ်ရမယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","အယ်နေ့ဖြစ်ဟှားဟှူ ကိစန ပတ်သတ်ဘီး ခိုင်လောင်ဟှူ ကြောန်းပြချစ် ပေးနိုင်ဘဲဟှူကြောန့် နို့လေဟှာ အယ်ပဒိပခတွပ် တရားစွဲခံရမယ် ဆိုဇာဟှိုဘဲ့ စိုးရိမ်ရဟှယ်။ နို့လေဟှာ အယ်ပဒိပခတွပ် ဖြေရှင်းချစ်ပေးနိုင်ဟှို့ မှုဟှ” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","အယ်မျိုးပြောဘီးန ဗြို့စာရေးဟှာ လူအောက်ဂီးဟှို ပ္လန်ခိုင်းလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ရှောက်ရှစ်ခတ်ဇာလေ ပီးဟှားဘီးန ပေါလုဟှာ တဗဲ့တော်လေဟှို ခေါ်ဘီး နှစ်သိမ့်ပေးဟှယ်။ အယ်ဘီးန သူးနို့ဟှို နှောက်ဆစ်ဘီးဟှာ မာကေဒေါနိပြည်ဟှို ထွပ်ဟှားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","သူဟှာ နေရာတိုင်းဟှို သွားဘီးဟှာ ယောင်ကြည်သူလေဟှို နှစ်သိမ့်အားပေးဘီးန အခါယပြည်ဟှို သွားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","သူဟှာ အယ်ပြည်မာ သောင်းလနေဟှယ်။ အယ်ဘီးန ရှုရိပြည်ဟှို သန်းဖောန သွားဟှို့ ဆင်သင့်ဖြစ်နေဟှူ ခီမာဘဲ့ ယုဒလူမျိုးလေဟှာ သူ့ဟှို သတ်ဟှို့တွပ် ကြံစည်နေဟှယ် ဆိုဇာဟှို ကြားရဟှယ်။ အယ်ကြောန့် သူဟှာ မာကေဒေါနိပြည်ဟှို ဖြတ်ဘီး ပ္လန်ဟှို့တွပ် စိဆောင်းဖြတ်လိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ပေါလုနတူးဒူ လိုက်ဟှားသူလေဟှ ဗေရိဗြို့သားဖြစ်ဟှူ ပုရုရဲ့သား သောပတရု၊ သက်သာလောနိတ်ဗြို့သားလေ ဖြစ်ဂေ့ဟှူ အာရိတ္တာခုန သေကန္ဒု၊ ဒေရဗေဗြို့သားဖြစ်ဟှူ ဂါယု၊ အာရှိပြည်သားလေ ဖြစ်ဂေ့ဟှူ တုခိတ်န တရောဖိမ်လေ၊ အယ်ဘီးဟှာ တိမောသေလေ ဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","အယ်လူလေဟှာ ရင်ဦးဆောင်းသွားဂေ့ဘီးန ကျွန်တော့်လေဟှို တရောဗြို့မာ စောန့်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","တဆေးမှေ့ဘဲဟှူ မုပွဲတော် ပီးဟှားဘီးန ကျွန်တော့်လေဟှ ဖိလိပ္ပိဗြို့ဟှနေဘီး သန်းဖောန လာဂေ့ဟှယ်။ ငါးရစ်ကြာဘီးန သူးနို့ရှိနေဟှူ တရောဗြို့ဟှို ရော့‑က်ဟှားဘီး အယ်ဗြို့မာ ခွန်နစ်ရစ်လော့‑က် နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ကျွန်တော့်လေဟှာ စနေနေ့ နေဒန်ဇာမာ မိတ်သဟာယစာ စားဂေ့ဟှို့တွပ် စုဂေ့ဟှယ်။ ပေါလုဟှာ နော့‑က်တနေ့မာ အယ်ဗြို့ဟှနေ ထွပ်ဟှို့တွပ် ကြံစည်ဟှားကြောန့် ညဉ့်နတ်ခီထိ လူလေဟှို ဆစ်ဘီးဟှာ ဟောပြောနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ကျွန်တော့်လေ စည်းဝေးဟှူ ထတ်ခန်းမာ မီးအီလေ ဘောင်ဂီးထွန်းဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ဥတုခု နာမယ်ရှိဟှူ ကောန်သားတယော့‑က်ဟှာ လတ်တန်ဗော့‑က်ထတ်မာ ထိုင်နေဟှယ်။ ပေါလုဟှ ဆစ်ဘီးဟောနေဟှူ ခီမာ ဥတုခုဟှာ အိငိုက်လာဘီးန နော့‑က်ဆောင်းမာ အိမွိဟှားဟှူကြောန့် အီသောင်းထပ်ဟှနေဘီး မ္လေဂီးထတ်ဟှို က္လဟှားလေဟှယ်။ လူလေဟှာ သူ့ဟှို ခီလိုက်ဟှူ ခီမာ သေဟှားဘီ ဆိုဇာဟှို တွိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","အယ်ခီမာ ပေါလုဟှာ အော့‑က်ဟှို ဆင်းဘီးဟှာ အယ်လူထတ်မာ သူ့ကိုယ်ဟှို မှောက်ခ္လဘီးန ဖတ်ဟှားလိုက်ဟှယ်။ လူလေဟှို “စိုးရိမ်ဂေ့န။ သူဟှာ သတ်ရှင်နေသေးဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ပေါလုဟှာ အီထတ်ဟှို ပ္လန်တတ်ဘီး တဗဲ့တော်လေနတူးဒူ မုဟှိုဖဲ့ဘီး စားဂေ့ဟှယ်။ မိုးလန်းဟှူခီထိ ကြာဂီးစကားပြောဘီးန ပေါလုဟှာ ထွပ်ဟှားလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","တဗဲ့တော်လေဟှာ သတ်ရှင်နေသေးဟှူ ကောန်သားဟှို သူ့အီဟှို ခေါ်ဟှားဘီးမှ ရရာတိုင်း သတ်သာရာ ရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ကျွန်တော့်လေဟှာ သန်းဖောနားဟှို ရင်ဦးဆောင်းသွားဘီးန အဿုဗြို့ဟှို သွားဂေ့ဟှယ်။ အဿုဗြို့ဟှိုရော့‑က်မှ ပေါလုဟှို သန်းဖောစီးခိုင်းဟှို့တွပ် ဖြစ်ဟှယ်။ ပေါလုဟှာ အယ်ဗြို့ဟှို ကူးလမ်းဟှနေ သွားမယ် ဆိုဘီး ပြောဟှားကြောန့် ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","သူ့ဟှာ ကျွန်တော့်လေဟှို အဿုဗြို့မာ တွိဟှူကြောန့် သူ့ဟှို သန်းဖောထတ်ဟှို ခေါ်ဘီးဟှာ မိတုလင်ဗြို့ဟှို သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ကျွန်တော်ဟှားလေဟှာ အယ်နေရာဟှနေ ဝှပ်လွပ်ဘီး နော့‑က်တနေ့မာ ခိအုကျွန်းနားဟှို ရော့‑က်ဟှားဂေ့ဟှယ်။ တရစ်ကြာဘီးန သာမုကျွန်းဟှို ရော့‑က်ဟှားဘီး နော့‑က်တရစ်မှ မိလက်ဗြို့ဟှို ရော့‑က်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ပေါလုဟှာ အာရှိပြည်မာ ခီကူရှင်ဘဲကြောန့် ဧဖက်ဗြို့ဟှို ဖြတ်ဘီး သန်းဖောန သွားဟှို့တွပ် စိဆောင်းဖြတ်ဟှားဟှယ်။ ဖြစ်နိုင်မယ် ဆိုဟှာ ပင်တေကုတ္တေ ပွဲတော်မီအောန် ယေရုရှလင်ဗြို့ဟှို ရော့‑က်ဟှို့တွပ် သူဟှာ ဗြန်းဗြန်ဟှား သွားနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","အယ်ခီမာ ပေါလုဟှာ ဧဖက်ဗြို့ဟှ သင်းတော်လူဂီးလေဟှို သူ့ဟှို လာတွိဟှို့တွပ် မိလက်ဗြို့ဟှနေ လူလွှတ်ဘီး ကြောန်းကြားလိုက်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","အယ်လူလေဟှ ရော့‑က်လာဂေ့ဟှူ ခီမာ ပေါလုဟှ “ငါဟှာ အာရှိပြည်ဟှို ရော့‑က်ဟှူနေ့ဟှစဘီး နန်းနို့နတူးဒူ ရှိနေဟှူ ခီတိုင်းဟှာ ဖယ်မျိုးသတ်ရှင်ဟှယ် ဆိုဇာဟှို နန်းနို့လေ သိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ယုဒလူမျိုးလေရဲ့ ကြံစည်လေကြောန့် ခတ်ခဲဟှူခီလေဟှို ကြောင်တွိနေရဘေမဲ့လည်း ငါဟှာ မျစ်ရယ်က္လဘီး၊ စိနှလောင်းနှိခ္လဘီး သခင်ဘုရားဟှို စေခံဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","လူအောက်ဂီးရှေ့မာရော၊ နန်းနို့ အီလေမာရော ငါဟှာ ဟောပြောဘီး သွန်သန်ဟှူ ခီမာ နန်းနို့တွပ် ကျိုးရှိဟှူ စကားလေဟှို ဖယ်ခါလည်း ဝှပ်ဘီးထားဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ဘုရားသခင်ရှေ့မာ နောန်ဒရရှင်း၊ နို့လေရဲ့ သခင်ယေရှုဟှို ယောင်ကြည်ရှင်း ကြောန်းလေဟှို ယုဒလူမျိုးလေဟှိုရော၊ ဟေလသလူမျိုးလေဟှိုရော လေးလေးနတ်နတ်ဟှား ဒိပေးဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ခု ငါဟှာ ဝိညာဉ်တော်ရဲ့ မိန့်တော်ဟှို နာခံဘီး ယေရုရှလင်ဗြို့ဟှို သွားရမယ်။ အယ်ဗြို့မာ ဖယ်မျိုးဖြစ်မယ် ဆိုဇာဟှို ငါသိဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှ ‘နန်ဟှာ တောက်နှောန်ရှင်းန ဒေါက်ခလေဟှို ခံရလေ့မယ်’ ဆိုဘီး ဗြို့တိုင်းမာ ငါ့ဟှို ဒိပေးဟှားဟှယ် ဆိုဇာဟှို ငါသိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","အယ်ဘေမဲ့ ငါ့တွပ်သတ်မှတ်ဟှားဟှူ လောက်တာဝန်န သခင်ယေရှုပေးဟှားဟှူ မှုတော်ဟှို ပီးအောန်လောက်ဆောန်ဟှို့ ဓိကဖြစ်ဟှူကြောန့် ငါဟှာ ကိုယ့်သတ်ဟှို ကိုယ်ဗြောဟှ။ ကိုယ်တော်ပေးဟှားဟှူ မှုတော်ဟှာ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ကြောန်းဖြစ်ဟှူ ဒန်းကောန်းဟှို ကြေညာဟှို့တွပ် ဖြစ်ဟှယ်။” ");
INSERT INTO tvn_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ငါဟှာ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ကြောန်းဟှို နန်းနို့နားဟှို လာဘီး ဟောပြောဟှယ်။ အယ်ဘေမဲ့ နန်းနို့ဟှလွဲဘီး ဖယ်သူဟှလည်း ငါ့မျစ်နှာဟှို နော့‑က်တခါ ဗြင်ရဟှို့မှုဘီ ဆိုဇာဟှို ငါသိနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","အယ်ကြောန့် နန်းနို့ထဲဟှ ယော့‑က်ယော့‑က်ဟှာ သတ်ဝိညာဉ်ဆောင်းရှောင်းမယ် ဆိုဟှာ လူလေရဲ့သွီးန ငါကင်းလွတ်ဟှယ် ဆိုဇာဟှို အယ်နေ့ဘဲ့ နန်းနို့ဟှို ငါဟှာ လေးလေးနတ်နတ်ဟှား သတ်သေခံဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ဖြားဖြစ်ကြောန့်နူးဆိုဟှာ ငါဟှာ ဘုရားသခင်ရဲ့ လိုတော်ဟှို နန်းနို့လေဟှို ဂူလောင်း ပြောပြဟှားပီးဘီ။ ");
INSERT INTO tvn_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","အယ်ကြောန့် နန်းနို့လေဟှာ ကိုယ့်ကိုယ်ကိုယ်ရော၊ နန်းနို့လတ်ထဲဟှို သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှ ပေးဟှားဟှူ သိုးစုလေဟှိုရော စောန့်ရှော့‑က်ဘီး ကေ့ရှုဂေ့ပါ။ ဘုရားသခင် ရဲ့ သင်းတော်ဟှို သိုးထီးမျိုး ကေ့ရှုဂေ့ပါ။ ဘုရားသခင်ဟှာ သူ့သားတော်ရဲ့ သွီးတော်အားဖြင့် သင်းတော်ဟှို ဝယ်ဟှားဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ငါမှေ့ဘဲဟှူ နော့‑က်မာ လူတချို့ဟှာ နန်းနို့နားဟှို လာဘီးဟှာ ရစ်ဆစ်ကြမ်းထန်းဟှူ ဝံပုလွေလေမျိုး သိုးစုဟှို ညှာတာဘဲန လောက်ဂေ့မယ် ဆိုဇာဟှို ငါသိနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","နန်းနို့ထဲမာ တချို့လူလေဟှာ လီညာပြောဆိုဘီး ယောင်ကြည်သူလေဟှို သူ့နော့‑က်ဟှို ခေါ်ဟှားဟှူခီ ရော့‑က်လာလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","အယ်ကြောန့် ဒိနနေဂေ့ပါ။ ငါဟှာ နန်းနို့ ဂူလောင်းဟှို သောင်းနှစ်လောင်းလောင်း နေ့ရောညဉ့်ရော မျစ်ရယ်က္လဘီး ဆောင်းမသွန်သန်ဇာဟှို ဒိရဂေ့ပါ။ ");
INSERT INTO tvn_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“ခု နန်းနို့လေဟှို ဘုရားသခင်ရဲ့ လတ်ထဲဟှိုရော၊ ကျေးဇူးတော်တရားရဲ့ လတ်ထဲဟှိုရော ငါအပ်လိုက်ဟှယ်။ အယ်ကျေးဇူးတော်တရားဟှာ နန်းနို့လေဟှို တည်ဆော့‑က်ဟှို့တွပ် ကိုယ်တော်ရဲ့ သန့်ရှင်းသူလေတွပ် ထားဟှားဟှူ ကောန်းဂျီးမင်္ဂလာလေဟှို နန်းနို့ ခံစားရလေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ငါဟှာ တခြားသူလေရဲ့ ရွှေလေ၊ ငွေလေန ဝတ်စားလေဟှို တတ်မတ်ဇာ မှေ့ဟှ။ ");
INSERT INTO tvn_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ငါဟှာ အယ်လတ်လေန လောက်လောက်ဘီး ငါ့ပေါန်းသင်းလေရဲ့ လိုအပ်ဇာလေဟှို ဖ္လဲ့ပေးနေဟှယ် ဆိုဇာဟှို နန်းနို့လေဟှ သိဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","အယ်မျိုးဘဲ့ နန်းနို့လေလည်း လောက်ဟှို ကြိုးစားဘီး ဆင်းရဲဟှူ လူလေဟှို ကူညီဂေ့ဟှို့တွပ် ငါပြရစ်ဟှယ်။ သခင်ယေရှု ကိုယ်တိုင်ဟှ ‘ပေးဟှူဇာဟှ ရယူဇာထတ် ပိုဘီး မင်္ဂလာရှိဟှယ်’ ဆိုဘီး မိန့်တော်မူဟှားဟှူ စကားဟှို ဒိရဂေ့ပါ” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","အယ်မျိုးပြောဘီးန ပေါလုဟှာ ဒူးထော့‑က်ဘီး အယ်လူလေနတူးဒူ ဆုတောန်းလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","သူးနို့လေ ဂူလောင်းဟှာ ရရာတိုင်း ငိုဂေ့ဘီးန ပေါလုဟှို ဖတ်ဘီး နှောက်ဆစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ပေါလုဟှာ သူ့မျစ်နှာဟှို နော့‑က်တခါ ဗြင်ရဟှို့မှုဘီ ဆိုဘီး ပြောဟှူကြောန့် သူးနို့လေဟှာ ပိုဘီး ဟှာ ဝန်းနဲဂေ့ဟှယ်။ အယ်ဘီးန သူးနို့ဟှာ ပေါလုဟှို သန်းဖောနားဟှို လိုက်ပို့ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ကျွန်တော့်လေဟှာ အယ်လူလေနားဟှနေဘီး ထွပ်လာဘီးဟှာ သန်းဖောန ကောသကျွန်းဟှို တည့်တည့်သွားဂေ့ဟှယ်။ နော့‑က်တနေ့မာ ရောဒုကျွန်းဟှိုရော၊ အယ်ကျွန်းဟှနေဘီး ပါတရဗြို့ဟှိုရော ရော့‑က်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ဖိနိတ်ပြည်ဟှို သွားဟှူ သန်းဖောတစင်းဟှို တွိဟှားဟှူ ခီမာ အယ်သန်းဖောထတ်ဟှို တတ်ဘီး သွားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ကျွန်တော့်လေဟှာ ကုပရုကျွန်းဟှို ဗြင်ရဟှူ ခီမာ အယ်ကျွန်းရဲ့ တောန်ဖတ်ဟှနေဖြတ်ဘီး ရှုရိပြည်ဟှို သန်းဖောန သွားဂေ့ဟှယ်။ တုရုဗြို့မာ ကူပစ်စီးလေဟှို ခ္လရဟှို့တွပ် အယ်ဗြို့မာ သန်းဖောဟှို ဝမ်ဘီးနားရဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ကျွန်တော့်လေဟှာ အယ်နေရာမာ တဗဲ့တော်တချို့ဟှို တွိဘီး သူးနို့နတူးဒူ ခွန်နစ်ရစ် နေဂေ့ဟှယ်။ အယ်တဗဲ့တော်လေဟှာ ဝိညာဉ်တော်ရဲ့ တဂိုးန ပေါလုဟှို ယေရုရှလင်ဗြို့ဟှို သွားဘဲဟှို့တွပ် ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","အယ်ဘေမဲ့ ခွန်နစ်ရစ် ကြာဟှားဟှူ ခီမာ ကျွန်တော့်လေဟှာ ခရီးသွားဂေ့ဟှယ်။ တဗဲ့တော်လေ ဂူလောင်းဟှာ သူးနို့ မီးမလေန သားဂန်းဟှားလေနတူးဒူ ဗြို့ပ္လန်ဟှ ပန်လယ်ကမ်းနားဟှို ရော့‑က်အောန် လိုက်ပို့ဂေ့ဟှယ်။ ကျွန်တော့်လေဟှာ ပန်လယ်ကမ်းနားမာ ဒူးထော့‑က်ဘီး ဆုတောန်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","အယ်ဘီးန ယော့‑က်နယော့‑က် နှောက်ဆစ်ဘီးဟှာ ကျွန်တော့်လေဟှာ သန်းဖောထတ်ဟှို တတ်ဘီး သူးနို့လေဟှ အီဟှို ပ္လန်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","တုရုဗြို့ဟှနေဘီး ဆစ်ဘီးသွားဂေ့ဟှူ ခီမာ ကျွန်တော့်လေဟှာ ပတောလင်ဗြို့ဟှို ရော့‑က်ဟှားဂေ့ဟှယ်။ အယ်ဗြို့မာ ညီကို မောန်နှမလေဟှို နှောက်ဆစ်ဘီးန သူးနို့နတူးဒူ တရစ်လော့‑က်နေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","နော့‑က်တနေ့မာ ထွပ်ဟှားဘီး ကဲသရိဗြို့ဟှို ရော့‑က်ဟှားဂေ့ဟှယ်။ ကျွန်တော့်လေဟှာ ဧဝံဂေလိဆရာ ဖိလိပ္ပု အီမာတည်းဂေ့ဟှယ်။ ဖိလိပ္ပုဟှ တဗဲ့တော်လေဟှို ကူညီဟှို့တွပ် ယေရုရှလင်သင်းတော်ဟှ ဝီးကော့‑က်ဟှားဟှူလူ ခွန်နစ်ယော့‑က်ထဲမာပါဟှူ လူတယော့‑က်ဖြစ်ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","သူ့မာ အီထောန်က္လသေးဘဲဟှူ သမီးလေးယော့‑က်ရှိဟှယ်။ သူ့သမီးလေဟှာ ပရောဖက်ပြုဘီး ဘုရားသခင်ရဲ့ တရားတော်ဟှို ကြေညာဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","အယ်အီမာ ကျွန်တော့်လေဟှာ ရစ်တန်ကြာ နေဘီးဟှူ ခီမာ အာဂဗု နာမယ်ရှိဟှူ ပရောဖက်တယော့‑က်ဟှာ ယုဒပြည်ဟှနေ ရော့‑က်လာဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","သူဟှာ ကျွန်တော့်လေနားဟှို လာဘီး ပေါလုရဲ့ ခါးဗတ်ဟှို ယူဘီး သူ့ခေန လတ်ဟှို ခယ်လိုက်ဟှယ်။ အယ်ဘီးန “အယ်ခါးဗတ် ဇရှင်ဟှို ယုဒလူလေဟှ ယေရုရှလင်ဗြို့မာ အယ်မျိုးခယ်ဘီးဟှာ လူမျိုးခြားလေဟှို အပ်ဂေ့လေ့မယ် ဆိုဘီး သန့်ရှင်းဟှူဝိညာဉ်တော်ဟှ မိန့်တော်မူဟှယ်” ဆိုဘီး ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","အယ်စကားဟှို ကြားရဟှူ ခီမာ ကျွန်တော့်လေန အယ်နေရာမာရှိနေဟှူ လူလေဟှ ယေရုရှလင်ဗြို့ဟှို သွားဘဲဟှို့တွပ် ပေါလုဟှို တောန်းဗန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","အယ်ဘေမဲ့ ပေါလုဟှ “နန်းနို့ဟှာ ဖြားဖြစ်ကြောန့် အယ်မျိုးငိုဘီးဟှာ ငါ့ရဲ့ စိနှလောင်းဟှို ကြေကွဲစေဂေ့နူး။ ငါဟှာ သခင်ယေရှုရဲ့ နာမတော်ကြောန့် ယေရုရှလင်ဗြို့မာ ခယ်ခံရဘီး သေခံဟှို့ဟှိုမှ ဆင်သင့်ရှိဟှယ်” ဆိုဘီး ပ္လန်ပြောဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ပေါလုဟှို သွီးဆောန်နိုင်ဘဲကြောန့် ကျွန်တော့်လေဟှာ လတ်ရှော့လိုက်ဘီး “သခင်ဘုရားရဲ့ လိုတော်တိုင်းဘဲ ဖြစ်ပါစေ” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ရစ်နဲနဲကြာဘီးန ကျွန်တော့်လေဟှာ ပစ်စီးလေဟှို ထောက်ဘိုးဘီးဟှာ ယေရုရှလင်ဗြို့ဟှို တတ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ကဲသရိဗြို့ဟှ တဗဲ့တော်တချို့ဟှာ ကျွန်တော့်လေနတူးဒူ လိုက်ဘီး ကျွန်တော့်လေဟှို ကုပရုကျွန်းသား တဗဲ့တော်ဟောန်း တယော့‑က်ဖြစ်ဟှူ မနာသုန်ရဲ့ အီမာတည်းဟှို့တွပ် ခေါ်ဟှားဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ယေရုရှလင်ဗြို့ဟှို ရော့‑က်ဟှားဂေ့ဟှူ ခီမာ ညီကို မောန်နှမလေဟှ ကြိုဆိုဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","နော့‑က်တနေ့မာ ပေါလုဟှာ ကျွန်တော့်လေနတူးဒူ ယာကုပ်ဟှို တွိဟှို့တွပ် သွားဂေ့ဟှယ်။ သင်းတော်လူဂီးလေ အားလောင်းလည်း သူ့နားမာ ရှိနေဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ပေါလုဟှာ အယ်လူလေဟှို နှောက်ဆစ်ဘီးန သူ့ရဲ့ မှုတော်လောက်ငန်းအားဖြင့် လူမျိုးခြားလေဟှို ဘုရားသခင်လောက်ဟှူ မှုရှိမျှဂူလောင်းဟှို တန်ပြဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","သူးနို့လေဟှာ အယ်မူဇာဟှို ကြားရဘီးန ဘုရားသခင်ဟှို ချီးမွမ်းဂေ့ဟှယ်။ အယ်ဘီးန သူးနို့ဟှ “ညီပေါလု၊ ယုဒလူလေ ထောန်နသောန်းနချီဘီး ယောင်ကြည်သူလေ ဖြစ်လာဂေ့ဟှယ် ဆိုဇာဟှို နန်းနို့လေ သိဗြင်ဂေ့ဟှယ်။ သူးနို့လေ ဂူလောင်းဟှာ ပညတ်တရားဖတ်မာ စိအားထတ်သန်ဟှူ သူလေ ဖြစ်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","‘နန်ဟှာ လူမျိုးခြားလေထဲမာနေဟှူ ယုဒလူလေဟှို နန်းနို့ရဲ့ သားဂန်းဟှားလေဟှို ရေဖျားလှီးပေးဂေ့န။ နန်းနို့ဟှာ ယုဒ ထောင်းဒန်းစဉ်လာလေဟှို လိုက်ဂေ့န’ ဆိုဘီး မောရှေရဲ့ ပညတ်တရားဟှို စွန့်ပစ်ဟှို့တွပ် သွန်သန်နေဇာဟှို အယ်လူလေဟှ ကြားရဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","အယ်မျိုးဆိုဟှာ နို့လေဟှာ ဖယ်မျိုးလောက်ရဟှို့နူး။ နန်ရော့‑က်လာဟှူဒန်းဟှို သူးနို့လေဟှာ ကြားရမယ် ဆိုဇာ သေချာနေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","အယ်ကြောန့် နန့်ဟှို နို့လေပြောဟှားဟှူတိုင်း လောက်လိုက်။ နို့လေမာ သစ်စာဂဒိပြုဟှားဟှူ လူလေးယော့‑က်ရှိဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","အယ်လူလေဟှို ခေါ်ဟှားဘီး သူးနို့နတူးဒူ စင်ကြယ်ရှင်းဟှို လောက်ဘီးဟှာ သူးနို့ခေါန်းဟှို ရိဟှို့တွပ်ခဟှို ပေးလိုက်။ အယ်မျိုးလောက်မယ် ဆိုဟှာ နန့်ကြောန်းဟှို သူးနို့ကြားရဂေ့ဟှူ ဒန်းဟှာ မှန်ဟှ ဆိုဇာဟှိုရော၊ နန်ကိုယ်တိုင်ဘဲ့ မောရှေရဲ့ ပညတ်တရားဟှို တိတိက္လက္လဟှား စောန့်ထီးဟှယ် ဆိုဇာဟှိုရော လူတိုင်းသိဂေ့လေ့မယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","အယ်ဘေမဲ့ ယောင်ကြည်သူ လူမျိုးခြားလေတွပ်ဟှ ရောက်ထုရှေ့မာ ပူဇော်ဟှားဟှူ စားဇာ၊ သွီး၊ လည်ဗန်းလှီးဘဲန သတ်ဟှားဟှူ လိဆန်လေဟှို စားဘဲဟှို့တွပ်န တရားဘဲဟှူ မေထုန်ဟှိုလည်း ရှောန်ဟှို့တွပ် နို့လေဟှာ ဆောင်းဖြတ်ဘီး သူးနို့နားဟှို စာရေးဘီး ကြောန်းကြားဟှားပီးဘီ” ဆိုဘီး ပြောဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","အယ်ကြောန့် ပေါလုဟှာ နော့‑က်တနေ့မာ အယ်လူလေးယော့‑က်ဟှို ခေါ်ဘီးန သူးနို့နတူးဒူ စင်ကြယ်ရှင်းဟှို လောက်ဂေ့ဟှယ်။ အယ်ဘီးန သူဟှာ ဗိမာန်တော်ဟှို သွားဘီး သူးနို့ယော့‑က်ချင်းစီတွပ် ပူဇော်သကာလောက်ရမယ့် ခီဖြစ်ဟှူ စင်ကြယ်ရှင်းဟှို လောက်ရဟှူ နေ့ရစ်လေ ပီးဆောင်းမယ့်ခီဟှို သိပေးလေဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ခွန်နစ်ရစ်လော့‑က် ကြာဟှားဟှူ ခီမာ အာရှိပြည်ဟှနေ ယုဒလူတချို့ဟှာ ပေါလုဟှို ဗိမာန်တော်မာ ဗြင်ဟှားဂေ့ဟှယ်။ သူးနို့ဟှာ လူအောက်ဂီးဟှို နှိုးဆော်ပေးဘီး ပေါလုဟှို ဖမ်းဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","သူးနို့ဟှ “ဣသရေလလူလေ၊ ကူညီဂေ့ပါ။ အယ်လူဟှာ နေရာတိုင်းဟှို သွားဘီး နို့လူမျိုးန နို့လူမျိုးရဲ့ ပညတ်တရားဟှိုရော၊ အယ်ဗိမာန်တော်ဟှိုရော ဆန့်ကျင်ဘီး လူတိုင်းဟှို သွန်သန်နေဟှယ်။ အယ်မျှလော့‑က်ဘဲ့ မှုဘဲန သူဟှာ လူမျိုးခြားလေဟှိုလည်း ဗိမာန်တော်ထဲဟှို ခေါ်ဆောန်လာဘီးဟှာ အယ်သန့်ရှင်းဟှူ နေရာဟှို ညစ်ညူးစေဟှယ်” ဆိုဘီး အော်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ဖြားဖြစ်ကြောန့် အယ်မျိုးပြောနူး၊ ဆိုဟှာ သူးနို့ဟှာ ပေါလုဟှို ဧဖက်ဗြို့သား တရောဖိမ်နတူးဒူ ဗြို့ထဲမာတွိဘီး အယ်လူဟှို ဗိမာန်တော်ထဲဟှို ပေါလုဟှာ ခေါ်လာဟှယ် ဆိုဘီး ထန်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","တဗြို့လောင်းဟှာ ရှောက်ရှစ်ခတ်ဘီး လူလေဟှာ ပ္လေးလာဘီးန ပေါလုဟှို ဖမ်းဘီးဟှာ ဗိမာန်တော်ပ္လန်ဟှို ဆွဲထုဂေ့ဟှယ်။ ရှစ်ရှင်းဘဲ့ ဗိမာန်တော်ရဲ့ ခွဗော့‑က်လေဟှို ပိလိုက်ဂေ့ဟှယ်။ ");
INSERT INTO tvn_vpl VALUES ("AC21_31","07